﻿USE sofia;
DROP TABLE IF EXISTS sofia.bsp_vpl;
CREATE TABLE bsp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bsp_vpl WRITE;
INSERT INTO bsp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Dəkəcop, kɔ Kanu kəwurɛ kɔm k'antɔf. ");
INSERT INTO bsp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tɛm tatɔkɔ antɔf ŋɛnayɔ fɛ teyi, kubump kənayi kəba kəroŋ. Mba Amera ŋa Kanu ŋɛnayi sɔ domun kəroŋ ŋocbum ŋi. ");
INSERT INTO bsp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kɔ Kanu kəloku: «Pəwaŋkəra peyi!» Kɔ pəwaŋkəra peyi. ");
INSERT INTO bsp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kɔ Kanu kənəŋk a pəwaŋkəra pentesɛ. Kɔ Kanu kəŋgbɛy pəwaŋkəra kɔ kubump. ");
INSERT INTO bsp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kɔ Kanu kəwe pəwaŋkəra «dɔsɔk», kɔ kəwe kubump «pibi.» Kɔ dɔfɔy deyi, kɔ bətbət beyi, kɔ tɔyɔnɛ dɔsɔk dɔcɔkɔ-cɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kɔ Kanu kəloku sɔ: «Pəkuymɛ peyi, ntɛ tɔŋsɔŋɛ domun deyersɛnɛ mɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kɔ Kanu kəyɔ kɔ pəkuymɛ peyi kɔ pɛŋgbɛy domun d'antɔf kɔ dakəroŋ, kɔ teyi tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kɔ Kanu kəwe pəkuymɛ mpɛ «kɔm.» Kɔ dɔfɔy deyi kɔ bətbət beyi, kɔ tɔyɔnɛ dɔsɔk da mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kɔ Kanu kəloku: «Domun ndɛ deyi kɔm tantɔf mɔ, doloŋkanɛ tofo tin, pəwosu peyi, powur, peyi takəroŋ!» Kɔ teyi tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kɔ Kanu kəwe tofo towosu «antɔf,» kɔ kəwe mofo mmɛ mɛla domun mɔ «cəba.» Kɔ Kanu kənəŋk a tentesɛ tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kɔ Kanu kəloku sɔ: «Antɔf ŋopoŋ pubuk, yika ŋa defet, kɔ tɔk yokom nyɛ yende yockom antɔf kəroŋ taciŋa mɔ! Yɔyɔ sɔ defet da yi!» Kɔ teyi tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","K'antɔf ŋompoŋ pəbuk, kɔ yika yɔyɔ defet, kɔ tɔk yokom yɔyɔ defet da yi. Kɔ Kanu kənəŋk sɔ a tentesɛ. ");
INSERT INTO bsp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kɔ dɔfɔy deyi kɔ bətbət beyi, kɔ tɔyɔnɛ dɔsɔk da maas. ");
INSERT INTO bsp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kɔ Kanu kəloku sɔ: «Yomotər-motər yeyi dəpəkuymɛ, ntɛ tɔŋsɔŋɛ dɔsɔk dɛgbɛyɛnɛ kɔ pibi mɔ! Kɔ tɔyɔnɛ mɛgbɛkərɛ ma tɛm, dɔsɔk kɔ meren. ");
INSERT INTO bsp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Yɔyɔnɛ yomotər-motər ya pəkuymɛ nyɛ yende yɔcsɔŋ antɔf pəwaŋkəra mɔ!» Kɔ teyi tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kɔ Kanu kəwurɛ yomotər-motər mɛrəŋ kɔ kəndɛt yi. Pomot pɔpɔŋ pɛtasərnɛ dɔsɔk, kɔ pomot pɛfɛt pɛtasərnɛ pibi. Kɔ Kanu kəwurɛ cɔs kɔ kəndɛt. ");
INSERT INTO bsp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kɔ Kanu kəndɛt yomotər-motər nyɛ dəkɔm yɔcsɔŋ antɔf pəwaŋkəra. ");
INSERT INTO bsp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Pomot pɔpɔŋ pɛtasərnɛ dɔsɔk, pomot pɛfɛt kɔ cɔs yɛtasərnɛ pibi, tɔsɔŋɛ pəwaŋkəra pɛgbɛyɛnɛ kɔ kubump. Kɔ Kanu kənəŋk a tentesɛ. ");
INSERT INTO bsp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kɔ dɔfɔy deyi, kɔ bətbət beyi, kɔ tɔyɔnɛ dɔsɔk da maŋkəlɛ. ");
INSERT INTO bsp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kɔ Kanu kəloku sɔ: «Yeŋesəm ya dəkəba yɛcsɛp dəromun. Bɛmp yɛcfɛlər-fɛlər kɔm tantɔf!» ");
INSERT INTO bsp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kɔ Kanu kəwurɛ sɛm yɔpɔŋ ya dəromun dokom dokom, kɔ yɛŋɛrəŋ-ŋɛrəŋ ya dəromun, kɔ domun doncop kəsɛp. Kɔ Kanu kəwurɛ sɔ bɛmp dokom dokom. Kɔ Kanu kənəŋk a tentesɛ. ");
INSERT INTO bsp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kɔ Kanu kəmpocɛ yi pətɔt, kɔ kəloku: «Nəyɔnɛ akombəra, nəla, nəlas domun da dəkəba, kɔ bɛmp, yɛla antɔf kəroŋ!» ");
INSERT INTO bsp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kɔ dɔfɔy deyi kɔ bətbət beyi, kɔ tɔyɔnɛ dɔsɔk da kəcamət. ");
INSERT INTO bsp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kɔ Kanu kəloku sɔ: «Antɔf ŋɔyɔ yeŋesəm dokom dokom, sɛm yɔcɔl, yeliŋɛ-liŋɛ, kɔ sɛm ya dəkulum, fəp fa yi kɔ dokom da yi!» Kɔ teyi tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kɔ Kanu kəwurɛ sɛm ya dəkulum dokom dokom, yɔcɔl dokom dokom kɔ yeliŋɛ-liŋɛ fəp dokom dokom. Kɔ Kanu kənəŋk a tentesɛ. ");
INSERT INTO bsp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kɔ Kanu kəloku: «Awa, palompəs fum teyi tosu, wəwurɛnɛ kosu, nwɛ endetasərnɛ lop ya dəkəba, bɛmp ya darenc, yɔcɔl kɔ yeliŋɛ-liŋɛ ya dəntɔf fəp mɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kɔ Kanu kəsɛl afum ntɛ tɔŋsɔŋɛ ŋawurɛnɛ kɔ nkɔn mɔ, kɔ kəsɛl ŋa ŋawurɛnɛ kɔ nkɔn Kanu yati. Kɔ kəsɛl ŋa wərkun kɔ wəran. ");
INSERT INTO bsp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kɔ Kanu kəmpocɛ ŋa pətɔt, kɔ kəloku: «Nəyɔnɛ akombəra, nəla, nəlas antɔf, nəboc antɔf tɛfaŋ tonu! Nətasərnɛ lop ya dəkəba, bɛmp nyɛ yɛŋfɛlər darenc mɔ, sɛm kɔ yeliŋɛ-liŋɛ ya dəntɔf fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kɔ Kanu kəloku: «Isɔŋ nu yika nyɛ yɔyɔ defet dakayi mɔ, kɔ yokom ya tɔk. Yɔyɔnɛ nu yeri. ");
INSERT INTO bsp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Sɛm ya dəntɔf, bɛmp ya darenc, yɛfɛlər-fɛlər ya darenc, kɔ yeliŋɛ-liŋɛ ya dəntɔf, ca fəp nyɛ yeŋesəm mɔ, isɔŋ yi dəmnɛ yika yobuk yɔyɔnɛ yi yeri.» Kɔ teyi sɔ tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kɔ Kanu kənəŋk a mes mɔkɔ ɛnayɔ mɔ fəp, mɔtɔt dəm mɛnayi. Kɔ dɔfɔy deyi kɔ bətbət beyi, kɔ tɔyɔnɛ dɔsɔk da camət-tin. ");
INSERT INTO bsp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Dɔsɔk da camət-tin dadɔkɔ, di d'analəpəs kɔm kɔ antɔf, kɔ ca yɔkɔ yeyi yi disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tataka ta camət-mɛrəŋ, kɔ yolompəs ya Kanu fəp yelip, k'ɛsak, k'eŋesəm tataka ta camət-mɛrəŋ ta yɛbəc yɔn. ");
INSERT INTO bsp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kɔ Kanu kəsɔŋ tataka ta camət-mɛrəŋ pəleli. K'eleləs pi, bawo dɔsɔk dadɔkɔ dɔ Kanu kəsak yɛbəc ya kəlompəs yɔkɔ ɛnayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dəkəyɛfɛ da kɔm k'antɔf dɔ dadɔkɔ, ntɛ awurɛ yi mɔ. Ntɛ MARIKI Kanu owurɛ antɔf kɔ kɔm mɔ, ");
INSERT INTO bsp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ali tɔtɔk pa dalɛ pin pɛnayi fɛ antɔf kəroŋ, ali ayika ŋa dalɛ ŋin ŋɛnapoŋ fɛ tɛm tatɔkɔ. Bawo MARIKI Kanu ɛnatorɛ fɛ wəcafən dəntɔf, fum ɛnayi fɛ sɔ, nwɛ ɛmbəc antɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mba kifir kəncpɛ dəntɔf, nkɛ kəncdəməs antɔf fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kɔ MARIKI Kanu ɛsɛlɛ fum kəbof ka dəntɔf. Kɔ Kanu kəfurup kɔ dololəm kifir ka kəyinɛ doru, kɔ fum ɔyɔnɛ paka peŋesəm. ");
INSERT INTO bsp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kɔ MARIKI Kanu ɔmbɔf tɔk yokom nde dalɛ da Edeŋ, kəca nkɛ dec dɛmpɛ mɔ, k'ɛmbɛrsɛ di fum nwɛ ɛnasɛl mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kɔ MARIKI Kanu ɔsɔŋɛ kɔ tɔk yokom yɔbɔt kədi yompoŋəs-poŋəs fəp, kəlɛkɛnɛ kətɔk ka kəyinɛ wəyeŋ katina nkɛ kənacəmɛ nde dalɛ dacɔ mɔ, kɔ kətɔk ka kəcərɛnɛ pətɔt kɔ pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kɔ kəŋgbɔkɔ kəwur Edeŋ, nkɛ kəncdəməs dalɛ mɔ. Kɔ kəŋgbɔkɔ kaŋkɔ kəŋkɔ kəyerənɛ dalɛ disrɛ waca maŋkəlɛ. ");
INSERT INTO bsp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kəca kəcɔkɔ-cɔkɔ k'ancwe «Pisɔŋ», ki kənɔŋkər atɔf ŋa Hawila fəp, nde kɛma kəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nde ambəp kɛma kəsoku pɛs mɔ, tɔk yobotu ambɔnc, kɔ masar mɔtɔt meyim seŋ. ");
INSERT INTO bsp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kəca ka mɛrəŋ k'aŋwe «Kihɔŋ», ki kənɔŋkər atɔf ŋa Kus. ");
INSERT INTO bsp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","K'aŋwe kəŋgbɔkɔ ka maas «Tikər», ki kəcepər kəca nkɛ dec dɛmpɛ dare da Asur mɔ. Kəŋgbɔkɔ ka maŋkəlɛ kəyɔnɛ «Ɛfərat.» ");
INSERT INTO bsp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kɔ MARIKI Kanu ɛlɛk fum, k'ɛmbɛrsɛ kɔ dalɛ da Edeŋ disrɛ, a pəcbɔfət ca, pəcbumɛnɛ sɔ di. ");
INSERT INTO bsp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kɔ MARIKI Kanu entiŋ-tiŋ fum: «Məntam kədi yeri ya dalɛ dandɛ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mba ta mədi pokom pa kətɔk ka kəcərɛnɛ pətɔt kɔ pəlɛc de! Bawo dɔsɔk ndɛ məndedi pokom pa ki mɔ, məŋfi!» ");
INSERT INTO bsp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kɔ MARIKI Kanu oloku: «Pəmar fɛ wərkun pəyi sona! Indelompəs wəmarəs kɔn, ntɛ tɔŋsɔŋɛ ŋayi mɛrəŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kɔ MARIKI Kanu ɛŋkɛrɛ sɛm ya dalɛ kɔ bɛmp ya darenc nyɛ ɛnawurɛ dəntɔf mɔ, pədemɔmən ntɛ fum ende pəcwe yi mɔ. Ntɛ tɔŋsɔŋɛ yowurɛ yɔn fəp yɔyɔ mewe mmɛ fum ende pəcwe yi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kɔ fum ɔsɔŋ sɛm yɔcɔl fəp mewe, kɔ bɛmp ya darenc kɔ fum ɔsɔŋ sɔ sɛm ya dəkulum fəp mewe. Mba ntɛ tɔyɔnɛ ta fum mɔ, ɔsɔtɔ fɛ nwɛ endetam kəcmar kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kɔ MARIKI Kanu ɔsɔŋ wərkun mere mɔpɔŋ, k'endirɛ. Kɔ Kanu kəwurɛ wərkun kəbɛnt kəkəsək ka dɛbəkəc. Kɔ kəluksərnɛ sɔ, kɔ kəntaməs dənda. ");
INSERT INTO bsp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kɔ MARIKI Kanu olompsɛ wəran kəbɛnt kəkəsək nkɛ ɛnawurɛ wərkun mɔ, k'eŋkenɛ wərkun wəran nwɛ. ");
INSERT INTO bsp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kɔ wərkun oŋkulɛ: «Apayo!» «Wəkawɛ, kəbɛnt ka bɛnt yem, tɛsɛm ta sɛm yem.» Wəkawɛ andewe «wəran» wənɛncɛnɛ ka wərkun, bawo nnɔ dis dem d'awurɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ti tɔsɔŋɛ ntɛ wərkun ɛŋsakɛ kas kɔ kɛrɛ pəsektərnɛ kɔ wəran kɔn mɔ. Ŋakafəlɛ ŋayɔnɛ tɛsɛm tin. ");
INSERT INTO bsp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wərkun kɔ wəran mɛrəŋ maŋan fəp kəsɔkər kɔ ŋanayi, ta ŋaŋlapərɛnɛ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Abok ŋɛnacərɛ mes ŋɛtas sɛm ya dalɛ fəp nyɛ MARIKI Kanu ɛnawurɛ mɔ. K'abok ŋeyif wəran: «Kanu kəloku nu ti yati a ta nədi yokom ya tɔk ya dalɛ dandɛ ba?» ");
INSERT INTO bsp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kɔ wəran oloku abok: «Səndi yokom ya tɔk ya dalɛ dandɛ yati. ");
INSERT INTO bsp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mba kətɔk nkɛ kəyi dalɛ dacɔ mɔ, Kanu kəloku: ‹Ta nədi yokom ya ki, ta nəgbuŋɛnɛ ŋaŋ ki! Kɔ nəyɔ ti-ɛ, nəŋfi.›» ");
INSERT INTO bsp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","K'abok ŋoloku wəran: «Nəfɔfi! ");
INSERT INTO bsp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bawo Kanu kəncərɛ, a dɔsɔk ndɛ nəndi yi mɔ, fɔr yonu yeŋmepɛ, nəyi pəmɔ Kanu nkɛ kəncərɛ pətɔt kɔ pəlɛc mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kɔ wəran ɛnəŋk a pokom pa kətɔk pɔmbɔt kədi, pɔmbɔt kəmɔmən, pɛntam kəsɔŋ kəcərɛ pətɔt kɔ pəlɛc. Kɔ wəran oŋgbotu pokom k'endi. K'ɔsɔŋ wos wəkɔ ŋanasol mɔ, kɔ wəkakɔ sɔ endi. ");
INSERT INTO bsp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kɔ ŋamepɛ fɔr, kɔ ŋancərɛnɛ a kəsɔkər kɔ ŋawur. Kɔ ŋaŋgbotu bɔpər, kɔ ŋasɔt maŋkara kɔ ŋambɛrnɛ mi. ");
INSERT INTO bsp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Dec dɔrɔfɔy, ntɛ tefef towur mɔ, wərkun kɔ wəran ŋane dim da MARIKI Kanu, nwɛ ɔnckɔtəs mɔ. Wərkun kɔ wəran kɔ ŋaŋkɔ ŋagbɔpnɛ ŋabɔlɛ MARIKI Kanu fɔr kiriŋ, tɔk ya dalɛ dadɔkɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kɔ MARIKI Kanu ewe wərkun eyif kɔ: «Deke məyi-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kɔ wərkun oloku Kanu: «Dim d'in'am dalɛ disrɛ, k'inesɛ, bawo iwur kəsɔkər, ti t'iŋgbɔpnɛnɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kɔ MARIKI eyif kɔ sɔ: «Anɔ'mentər əm a kəsɔkər kɔ məwur-ɛ? Cepɔ məndi pokom pa kətɔk kəŋkɔ inamɔn'am mɔ ba?» ");
INSERT INTO bsp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kɔ wərkun oloku: «Wəran nwɛ məsɔŋ im mɔ, nkɔn ɔsɔŋ im pi k'ina sɔ indi.» ");
INSERT INTO bsp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kɔ MARIKI Kanu eyif wəran: «Ta ake tɔ məyɔnɛ tantɛ-ɛ?» Kɔ wəran oloku Kanu: «Abok ŋetiŋkər im, k'indi pokom pampɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kɔ MARIKI Kanu oloku abok: «Bawo məsɔŋɛ wəran kəciya, kəsɔŋ əm kənder pəlɛc sɛm yɔcɔl, kɔ sɛm ya dop fəp dacɔ. Kor kɔ mənde məcliŋɛnɛ, məcdi kəbof mataka ma kiyi kam doru fəp. ");
INSERT INTO bsp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kəbɛrəs əm k'inder dacɔ kɔ wəran, kəyɛfɛ nəna haŋ awut a wəran kəbəp awut a məna, abok! Wəran ende pəcputək əm domp, məna abok, məcŋaŋ kɔ dəmnɛ atek.» ");
INSERT INTO bsp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kɔ Kanu kəloku wəran: «Indeyɔ kəbɛkəs kam kəccu'm. Pəcuca pɔ mənde məckom. Mɛfaŋ mam məndekɔ nda wos əm. Mba endetasərn'am.» ");
INSERT INTO bsp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kɔ Kanu kəloku wərkun: «Bawo məncəŋkəl dim da wəran kam, kɔ məndi pokom pa kətɔk nkɛ inamɔn'am kədi mɔ, indesɔŋ antɔf pəlɛc tetam: Pəcuca pɔ mənde məcsɔtər ŋi yeri yam dɔsɔk o dɔsɔk kiyi kam doru fəp. ");
INSERT INTO bsp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Yika ya dəkulum yɔ mənde məcdi. Mba antɔf ŋende ŋockom am bɛŋk kɔ ŋgbɔŋkəlɔ. ");
INSERT INTO bsp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kawonɛ ka tobu tam kəndesɔŋ'am kəcsɔm kəcom haŋ tɛm ntɛ məndelukus dəntɔf nde məyɛfɛ mɔ. Bawo kəbof kɔ məyɔnɛ, dəkəbof məndesɔlukus.» ");
INSERT INTO bsp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kɔ wərkun ɔsɔŋ wəran kɔn tewe ta «Hawa», bawo nkɔn Hawa ɔyɔnɛ iya wəka afum a doru fəp. ");
INSERT INTO bsp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kɔ MARIKI Kanu olompsɛ Adama kɔ wəran kɔn, Hawa, yamos ya akata, k'ɛmbɛr ŋa yi. ");
INSERT INTO bsp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kɔ MARIKI Kanu oloku: «Ah! Ntɛ fum ende pəyi oŋ pəmɔ səna mɔ, pəcərɛ pəlɛc kɔ pətɔt, səkɛmbərnɛ ta pətɛnc kəca pəlɛk sɔ pokom pa kətɔk kəyinɛ wəyeŋ, pədeyi oŋ doru katina.» ");
INSERT INTO bsp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kɔ MARIKI Kanu owurɛnɛ Adama dalɛ da Edeŋ disrɛ, pəkɔbəc antɔf nyɛ ɛnasɛlɛ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ntɛ MARIKI Kanu owurɛnɛ fum dalɛ da Edeŋ mɔ, k'ɛncəmbər mɛlɛkɛ kerub ntende dec dɛmpɛ dalɛ da Edeŋ, kɔ dakma ndɛ dencfikəlɛ dɛccɛsəŋɛ nɛnc, ntɛ tɔŋsɔŋɛ ta alɔtərnɛ kətɔk ka kəyinɛ wəyeŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","K'Adama ŋambəpɛnɛ kɔ wəran kɔn Hawa, kɔ Hawa ɛmbɛkəs, k'oŋkom Kayin. Kɔ Hawa oloku: «Isɔtɔ wan wərkun kəmar ka MARIKI disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kɔ Hawa oŋkom sɔ wəfɛt ka Kayin nwɛ anawe Abɛl mɔ. K'Abɛl ende pəyɔnɛ wəkɛk ka cir kɔ ŋkesiya. Kɔ Kayin ɔyɔnɛ wəbifti. ");
INSERT INTO bsp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kɔ tɛm tɔlɔma tende tɛbəp, kɔ Kayin ɛlɛk yokom ya dəntɔf, k'ɛŋkɛrɛ yi MARIKI kədeloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","K'Abɛl nkɔn sɔ, ɛŋkɛrɛ MARIKI yokom yɔcɔkɔ-cɔkɔ ya yɔcɔl yɔn kɔ moro ma yi. Kɔ MARIKI ɔmɔmənɛ Abɛl kɔ kəloŋnɛ kɔn fɔr yɔtɔt. ");
INSERT INTO bsp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mba MARIKI ɛnamɔmənɛ fɛ Kayin kɔ kəloŋnɛ kɔn fɔr yɔtɔt. Kɔ pəntɛlɛ Kayin, k'ɛŋɛy kəro. ");
INSERT INTO bsp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kɔ MARIKI eyif Kayin: «Ta ake tɔ pəntɛlɛn'am-ɛ, ta ake tɔ məŋɛyɛ kəro-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kɔ məŋkɔt belbel-ɛ, məndesel. Kɔ məŋkɔt pəlɛc-ɛ, kiciya kəy'əm dəkusuŋka kɔ mɛfaŋ ma ki mey'əm. Mba məsɛp mətasərnɛ ki.» ");
INSERT INTO bsp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kɔ Kayin ɔncɔpər wɛnc Abɛl. Mba ntɛ ŋanayi dalɛ mɔ, kɔ Kayin ɛyɛfər wɛnc Abɛl kəsutɛnɛ, k'endif kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kɔ MARIKI eyif Kayin: «Deke wɛnc əm Abɛl eyi-ɛ?» Kɔ Kayin oloku: «Incərɛ fɛ. Cepɔ wəkɛkəs kɔn iyɔnɛ ba?» ");
INSERT INTO bsp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kɔ Kanu kəyif Kayin: «Cəke cɔ məyɔ wɛnc əm-ɛ? Dim da mecir ma wɛnc əm deyi kəkulɛ-kulɛ kəyɛfɛ dəntɔf haŋ nnɔ iyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ndɛkəl oŋ, kətolan'am k'antɔf ŋender pəlɛc, nŋɛ ŋɛwani kusu kɔ məsɔŋɛ ŋi kəmerəs mecir ma wɛnc əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kɔ mənde məcbəc antɔf-ɛ, ŋɔfɔde ŋɔcsɔŋ əm pəbotu pa ŋi. Ti tɔ pənde pəctɛlɛn'am məccepɛ-cepɛ dəkəbəc.» ");
INSERT INTO bsp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kɔ Kayin oloku MARIKI: «Pəlel pa kiciya kem pɛmbɛk kəsarɛ. ");
INSERT INTO bsp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Məmbɛləs im mɔkɔ nnɔ antɔf ŋam ŋebi ŋeyi mɔ. Pənamar im kəgbɔpən'am, kɔ kəcepɛ-cepɛ dəntɔf, kɔ fum ɛmbəp im dənda-ɛ, pədif im.» ");
INSERT INTO bsp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mba, kɔ MARIKI oloku kɔ: «Kɔ fum endif Kayin-ɛ, aŋluksɛ ayɛk ŋɔn camət-mɛrəŋ.» Kɔ MARIKI eŋgbesi Kayin ntɛ tɔŋsɔŋɛ aŋɛ ŋambəp kɔ mɔ, ta ŋasut kɔ ŋadif. ");
INSERT INTO bsp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kɔ Kayin owur fɔr ya MARIKI kiriŋ dalɛ da Edeŋ, k'ɔŋkɔ pəyi atɔf ŋa Nodu nde dec dɛmpɛ dalɛ da Edeŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kɔ Kayin ŋambəpɛnɛ kɔ wəran kɔn. Kɔ wəkakɔ ɛmbɛkəs k'oŋkom Henok. Kɔ Kayin owurɛ dare k'ɔsɔŋ di tewe ta wan kɔn Henok. ");
INSERT INTO bsp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kɔ Henok oŋkom Iradu, k'Iradu oŋkom Mehuyayɛl, kɔ Mehuyayɛl oŋkom Metusayɛl, kɔ Metusayɛl oŋkom Lɛmɛk. ");
INSERT INTO bsp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Kɔ Lɛmɛk ɛlɛk aran mɛrəŋ, pacwe wəkin «Ada,» kɔ wəka mɛrəŋ «Cila.» ");
INSERT INTO bsp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","K'Ada oŋkom Yabal, nkɔn ɔyɔnɛ wətem ka akɛk yɔcɔl acepɛ-cepɛ. ");
INSERT INTO bsp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tewe ta wɛnc tɛnayɔnɛ Yubal: Nkɔn ɔyɔnɛ wətem k'afer coŋkəlo k'afula luk. ");
INSERT INTO bsp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Kɔ Cila nkɔn sɔ dəmnɛ oŋkom Tubal Kayin, nwɛ ɛncgbɛc ca fəp ya kɔpər kɔ ya fɛc mɔ. Wəkirɛ kɔn ancwe Nahama. ");
INSERT INTO bsp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kɔ Lɛmɛk oloku aran ɔn: «Ada kɔ Cila nəcəŋkəl dim dem! Aran a Lɛmɛk nəsu ləŋəs nəcəŋkəl moloku mem. K'asut im-ɛ, indif fum. K'ambopər im-ɛ, indif wanfɛt. ");
INSERT INTO bsp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kɔ pəyɔnɛ padif afum camət-mɛrəŋ kəluksɛ ayɛk ŋa Kayin-ɛ, andedif afum 77, a pacluksɛ ayɛk ŋa Lɛmɛk.» ");
INSERT INTO bsp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama kɔ Hawa ŋasɔtɔ sɔ wan. Kɔ Hawa ewe kɔ «Sɛt», ti tɔ tatɔkɔ «Kanu kəsɔŋ im sɔ wəlɔma kədeyɔn'em Abɛl wəkɔ Kayin endif mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kɔ Sɛt ende pəkom wan pacwe kɔ Enɔs. Tɛm tatɔkɔ t'anacop kəkor-koru tewe ta MARIKI. ");
INSERT INTO bsp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Buk ba dokombəra da Adama bɔ bambɛ. Dɔsɔk ndɛ Kanu kəsɛl Adama mɔ, k'ɛsɛl kɔ, pəwurɛnɛ kɔ nkɔn Kanu. ");
INSERT INTO bsp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wərkun kɔ wəran k'ɛsɛl ŋa, k'ompocɛ ŋa pətɔt, k'ewe ŋa tewe ta «fum,» dɔsɔk ndɛ ɛncsɛl ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama endesɔtɔ meren 130, k'ɔsɔtɔ wan wəwurɛnɛ kɔ nkɔn, pəmɔ tɔkɔ eyi mɔ, k'ɔsɔŋ kɔ tewe ta Sɛt. ");
INSERT INTO bsp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ntɛ Adama oŋkom Sɛt mɔ, k'eyi sɔ doru meren 800, mmɛ ɛnasɔtɔ sɔ awut arkun k'awut aran mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Kəwon ka Adama doru kənasɔtɔ meren 930, a k'endefi. ");
INSERT INTO bsp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛt ɛnasɔtɔ meren 105, a k'endekom Enɔs. ");
INSERT INTO bsp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ntɛ Sɛt oŋkom Enɔs mɔ, k'eyi sɔ doru meren 807, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kəwon ka Sɛt doru kənasɔtɔ meren 912, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enɔs ɛnasɔtɔ meren 90 a pədekom Kenaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ntɛ Enɔs oŋkom Kenaŋ mɔ, k'eyi sɔ doru meren 815, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kəwon ka Enɔs doru fəp kənasɔtɔ meren 905, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kɔ Kenaŋ ɔsɔtɔ meren 70 a k'endekom Mahalalel. ");
INSERT INTO bsp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ntɛ oŋkom Mahalalel mɔ, kɔ Kenaŋ eyi sɔ doru meren 840, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kəwon ka Kenaŋ doru fəp kənasɔtɔ meren 910, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel ɛnasɔtɔ meren 65 a k'endekom Yɛrɛdu. ");
INSERT INTO bsp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ntɛ Mahalalel oŋkom Yɛrɛdu mɔ, k'eyi sɔ doru meren 830, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kəwon ka Mahalalel doru fəp, kənasɔtɔ meren 895, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yɛrɛdu ɛnasɔtɔ meren 162 a k'endekom Henok. ");
INSERT INTO bsp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ntɛ Yɛrɛdu oŋkom Henok mɔ, k'eyi sɔ doru meren 800, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kəwon ka Yɛrɛdu doru fəp kənasɔtɔ meren 962, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok ɛnasɔtɔ meren 65 a k'endekom Metusela. ");
INSERT INTO bsp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ntɛ Henok oŋkom Metusela mɔ, k'ɔsɔtɔ sɔ meren 300 ŋasol kɔ Kanu. K'oŋkom sɔ awut arkun k'aran alɔma. ");
INSERT INTO bsp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Kəwon ka Henok doru fəp kənasɔtɔ meren 365. ");
INSERT INTO bsp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Kɔ Henok ɛncəmɛ dɔpɔ da Kanu darəŋ, kɔ tende telip, bawo Kanu kənalɛk kɔ pəyi wəyeŋ. ");
INSERT INTO bsp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ɛnasɔtɔ meren 187 a k'endekom Lɛmɛk. ");
INSERT INTO bsp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ntɛ Metusela oŋkom Lɛmɛk mɔ, k'ɔsɔtɔ sɔ meren 782, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kəwon ka Metusela doru kənasɔtɔ meren 969, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lɛmɛk ɛnasɔtɔ meren 182 a k'endekom wan wərkun. ");
INSERT INTO bsp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kɔ Lɛmɛk ewe wan wəkakɔ «Nuha.» K'oloku: «Wəkawɛ ende pəcyamsɛ-yamsɛ su, kəcɛm-cɛmnɛ ka pucuy mpɛ yɛbəc yocuca nyɛ waca womboc antɔf nyɛ, MARIKI ɛnasɔŋ pəlɛc tetosu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ntɛ Lɛmɛk oŋkom Nuha mɔ, k'eyi sɔ doru meren 595. K'oŋkom sɔ awut arkun k'awut aran alɔma. ");
INSERT INTO bsp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kəwon ka Lɛmɛk doru fəp kənasɔtɔ meren 777, k'efi. ");
INSERT INTO bsp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuha ɛnasɔtɔ meren 500 a k'endekom Sem, Ham, kɔ Yafɛt. ");
INSERT INTO bsp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ntɛ afum ŋancop kəla antɔf kəroŋ mɔ, k'aŋkoməs ayecəra. ");
INSERT INTO bsp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kɔ mɛlɛkɛ ŋanəŋk a ayecəra aka afum ŋantesɛ. Kɔ ŋayɛk-yɛk aran aŋan ayecəra akakɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kɔ MARIKI oloku: «Ifaŋ fɛ kəsak afum ŋayinɛ kifir kəyinɛ doru nkɛ inasɔŋ ŋa mɔ, bawo fum sɛm dəm yɔ. Kəyi kɔn doru kəfɔde kəccepər sɔ meren 120.» ");
INSERT INTO bsp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tɛm tatɔkɔ tɔ cɔrgba cənayi doru, ntɛ awut a Kanu ŋantɛfərnɛ ayecəra aka afum, akɔ ŋasɔŋ ŋa awut mɔ. Awut akakɔ ŋanayɔnɛ abɛ akur a tɛm tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kɔ MARIKI ɛnəŋk deyeŋki bəkəc da afum dɛla doru, dɔsɔk o dɔsɔk mɛcɛm-cɛmnɛ mɛlɛc gbəcərəm mɔ afum ŋayinɛ. ");
INSERT INTO bsp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Kɔ MARIKI ɛŋaŋnɛ tɛlər kəsɛl kɔn fum, k'abəkəc ŋɛŋkafəlɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kɔ MARIKI oloku: «Kənim k'inder afum aŋɛ inasɛl mɔ, kəyɛfɛ afum, kəbəp sɛm, kəkɔ ka yeliŋɛ-liŋɛ haŋ bɛmp ya darenc, bawo iŋaŋnɛ tɛlər kəsɛl kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mba kɔ Nuha ɔsɔtɔ kəŋanɛnɛ ka MARIKI, bawo Kanu kənanəŋk dolompu dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tecepərɛnɛ ta Nuha tɛntɛ: Nuha, fum wətɔt ɛnayi pəlomp, pəsol kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuha, awut maas ŋ'ɛnakom: Sem, Ham kɔ Yafɛt. ");
INSERT INTO bsp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mba nnɔ fɔr ya Kanu kiriŋ, afum ŋanatesɛ fɛ bəkəc. Mes mɛlɛc gbəcərəm mɛnayi doru. ");
INSERT INTO bsp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kanu kənanəŋk a doru dɛsəkpɛ, bawo afum fəp ŋanagbaymɛ-gbaymɛ dɔpɔ dɔtɔt. ");
INSERT INTO bsp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ti t'ɛnasɔŋɛ Kanu kəloku Nuha: «Incɛm-cɛmnɛ kəmələk yeŋesəm ya doru fəp, bawo tes taŋan tɔsɔŋɛ kɔ doru dɛla kədəkətɛrɛnɛ, kənim ŋa k'inder doru. ");
INSERT INTO bsp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Məcaŋɛ abil ŋɔpɔŋ cəbam ca kawe, məwurɛ ŋi sədukəlɔ səlarəm, məsop ŋi kɔrtal tedisrɛ kɔ todoru. ");
INSERT INTO bsp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ntɛ tɔ məndecaŋ ŋi: Ŋɔbɔl cururu 300 (mɛtər 137), ŋɔwɔkəl cururu 50 (mɛtər 23), ŋotukmɛ cururu 30 (mɛtər 14). ");
INSERT INTO bsp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Məgbəpər ŋi tadarenc, məsak kururu katin (mɛtər dacɔ) kəyɛfɛ nde kəroŋ haŋ nde dəkəpom, məwurɛ ŋi kumba kəsək, mədeŋər ŋi dɛk maas. ");
INSERT INTO bsp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Bawo ina, domun dɛlarəm d'indesak ndɛ dendemələk ca fəp mɔ. Mpɛ o mpɛ peŋesəm doru mɔ, pendefi. ");
INSERT INTO bsp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kɔ məna, indesek sɔ danapa kɔ məna, məde məbɛrɛ debil kɔ wəran kam, awut am k'aran aŋan! ");
INSERT INTO bsp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Məde məbɛrsɛnɛ sɔ ŋi disrɛ sɛm ya doru fəp mɛrəŋ mɛrəŋ, workun kɔ wɛran, ntɛ tɔŋsɔŋɛ nəde nəyi doru kɔ yi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sɛm yeŋesəm ya doru fəp, yorkun kɔ yɛran, yɛfɛt kɔ yɔpɔŋ, yede yɔlɔtərn'am ntɛ tɔŋsɔŋɛ yi sɔ yede yeyi doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Awa, mətɛn yeri fəp, məmɛŋkərnɛ yi ntɛ tɔŋsɔŋɛ nəde nəcsɔtɔ yedi nəna kɔ yi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ti tɔ Nuha ɛnayɔ, ɛnayɔ mes fəp mmɛ Kanu kənaloku kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kɔ MARIKI kəloku Nuha: «Məbɛrɛ abil disrɛ, məna k'afum am fəp, bawo iŋkɔkcɛ a mən'olomp fɔr yem kiriŋ dɛtɛmp dandɛ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Məlɛkɛnɛ sɛm yɔtɔt camət-mɛrəŋ camət-mɛrəŋ, yorkun kɔ yɛran, mba sɛm yɛlɛc, məlɛk yi mɛrəŋ mɛrəŋ: Workun kɔ wɛran gbəcərəm. ");
INSERT INTO bsp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kɔ bɛmp, məlɛkɛnɛ yi fəp dacɔ, yorkun camət-mɛrəŋ kɔ yɛran camət-mɛrəŋ. Ti t'endesɔŋɛ yi sɔ yeyi doru. ");
INSERT INTO bsp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pəncəmɛ mata camət-mɛrəŋ, itorɛ wəcafən mata 40 kɔ pibi 40 camcam. Tɛm tatɔkɔ indefɛŋ nnɔ doru afum aŋɛ inasɛl mɔ fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuha ɛnayɔ mɔyɔ fəp, mmɛ MARIKI ɛnasom kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuha ɛnasɔtɔ meren 600 a kɔ domun dendekal antɔf. ");
INSERT INTO bsp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","K'ɛmbɛrɛ debil kɔ wəran kɔn, awut ɔn k'aran aŋan, ntɛ tɔŋsɔŋɛ ŋayacnɛ domun ndɛ dɛnabaŋ antɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Sɛm yɔtɔt kɔ yɛlɛc, bɛmp kɔ sɛm yɛfɛt yɛfɛt nyɛ yeŋliŋɛ-liŋɛ mɔ fəp, ");
INSERT INTO bsp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kɔ Kanu kəmbɛrsɛ yi abil disrɛ nde Nuha eyi mɔ, mɛrəŋ mɛrəŋ yorkun kɔ yɛran, pəmɔ tɔkɔ Kanu kənaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ntɛ tataka ta camət-mɛrəŋ tencepər mɔ, kɔ domun dɛmbaŋ antɔf. ");
INSERT INTO bsp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kəren nkɛ Nuha ɔsɔtɔ meren 600, tataka ta wəco kɔ camət-mɛrəŋ, ŋof ŋa mɛrəŋ disrɛ, kɔ domun dombuncɛ dəcəŋgbɔkɔ fəp, kɔ kɔm kəŋgbitɛ pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kɔ wəcafən oncop kətuf mata 40 kɔ pibi 40. ");
INSERT INTO bsp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Dɔsɔk dayi dɔ Nuha ɛnabɛrɛ debil kɔ wəran kɔn k'awut ɔn, Sem, Ham, kɔ Yafɛt, k'aran aŋan maas, ");
INSERT INTO bsp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","kɔ sɛm ya dop kɔ ya dare yin yin kɔ sɛm yɛfɛt yɛfɛt, bɛmp kɔ taktaka. ");
INSERT INTO bsp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Kɔ yeŋesəm (sɛm) yorkun kɔ yɛran mɛrəŋ mɛrəŋ nyɛ yɛnayi doru mɔ, kɔ yender nde abil ŋa Nuha ŋeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kɔ yorkun kɔ yɛran sɛm dokom fəp, yɛmbɛrɛ abil disrɛ pəmɔ tɔkɔ Kanu kənaloku ti Nuha mɔ, kɔ MARIKI kəŋgbətər ŋa kumba. ");
INSERT INTO bsp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kɔ domun dɛmbaŋ antɔf mata 40, ntɛ domun dɛmpɛ mɔ, k'abil ŋofoy. ");
INSERT INTO bsp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ntɛ domun dɛncpɛ mɔ, ti tɔ abil ŋoncfoy. ");
INSERT INTO bsp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kɔ domun dɛmbɛrɛnɛ kəpɛ haŋ kɔ mɔrɔ meŋeci fəp mɛŋkalɛ. ");
INSERT INTO bsp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","(Tɛlpəs oŋ kɔ domun dɛmpɛ haŋ kɔ dencepər cururu wəco kɔ kəcamət mɔrɔ kəroŋ). Kɔ domun dɛmpɛ kɔ dɛŋkal mɔrɔ meŋeci haŋ cururu wəco kɔ kəcamət (mɛtər camət-mɛrəŋ). ");
INSERT INTO bsp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ca nyɛ yɛnayi antɔf kəroŋ, a yecŋesəm mɔ fəp, kɔ yefi: Bɛmp, sɛm yɔcɔl, sɛm ya dop kɔ yeliŋɛ-liŋɛ fəp kəlɛkɛnɛ afum. ");
INSERT INTO bsp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kəyɛfɛ paka mpɛ pɛnayi antɔf kəroŋ a pecŋesəm mɔ, kɔ pefi. ");
INSERT INTO bsp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kɔ Kanu kəfɛŋ dəntɔf paka mpɛ pencŋesəm mɔ, kəyɛfɛ fum haŋ kəbəp sɛm yɔpɔŋ, yɛfɛt yɛfɛt kɔ bɛmp, k'enim yi doru fəp. Mɛnɛ Nuha gbəcərəm, aka kəlɔ kɔn disrɛ kɔ sɛm nyɛ yɛnayi debil mɔ, ŋanafis. ");
INSERT INTO bsp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Domun dɛnabaŋ antɔf haŋ mataka 150. ");
INSERT INTO bsp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kɔ Kanu kəncɛm-cɛmnɛ Nuha, sɛm ya dop kɔ yɔcɔl ya dare, nyɛ yɛnayi kɔ Nuha abil disrɛ mɔ. Kɔ Kanu kəwurɛ afef doru, kɔ domun doncop kətor. ");
INSERT INTO bsp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kəba ka dəntɔf kɔ darenc cəmɛpɛnɛ, kɔ wəcafən ɛsak kətuf. ");
INSERT INTO bsp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kɔ domun dembelɛ antɔf kəroŋ tepic tepic. Mata 150 disrɛ, kɔ domun dɛncɛsɛ dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tataka ta wəco kɔ camət-mɛrəŋ (17), ŋof ŋa camət-mɛrəŋ, k'abil ŋɛndɛ tɔrɔ tin ta Ararat kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kɔ domun dɛncɛsɛ haŋ ŋof ŋa wəco. Tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋaŋɔkɔ, kɔ mɔrɔ meŋeci moncop kəwurɛ səbomp. ");
INSERT INTO bsp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tataka ta 40, kɔ Nuha eŋgbiti wundɛr nwɛ ɛnabɛr abil mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","K'ɛsak abɛmp ŋa ser ŋin kɔ ŋɔŋkɔ. Pəwon fɛ kɔ ŋoluksərnɛ, pənamar Nuha pəkar domun delip kəwosər dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kɔ Nuha ɛsak sɔ antantoriya kəkɔmɔmən kɔ pəyɔnɛ a domun d'ontor-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mba ŋɛnasɔtɔ fɛ kəfo nkɛ ŋɛntam kəndɛ mɔ, bawo domun dɛnasɔrɔbaŋ antɔf fəp, kɔ ŋoluksərnɛ nde debil. Kɔ Nuha ɛntɛnc kəca k'osumpər ŋi, k'ɛmbɛrsɛ debil. ");
INSERT INTO bsp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","K'ɛŋkar sɔ mata camət-mɛrəŋ, k'ɛsak sɔ ŋi. ");
INSERT INTO bsp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","K'antantoriya ŋoluksərnɛ dec dɔrɔfɔy ŋɛgbəm tɔbɔpər tɛcaŋk ta kətɔk ka olif. Kɔ Nuha ɛncərɛ katina a domun dɛncɛsɛ. ");
INSERT INTO bsp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","K'ɛŋkarɛnɛ sɔ haŋ tataka ta camət-mɛrəŋ, k'ɛsak sɔ antantoriya. Mba ntɛ ŋi ŋɔŋkɔ mɔ, ŋɛnalukus fɛ sɔ nnɔ eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋɔcɔkɔ-cɔkɔ nŋɛ Nuha ɔsɔtɔ meren 601, ti tɔ domun dɛnasak antɔf. Kɔ Nuha eŋgbipi abil, k'ɔmɔmən doru. K'ɛnəŋk a domun fəp dowosər. ");
INSERT INTO bsp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tataka ta wəco mɛrəŋ kɔ camət mɛrəŋ (27), ŋof ŋɔcɔkɔ-cɔkɔ ŋayi, antɔf fəp ŋɛnawos fər. ");
INSERT INTO bsp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kɔ Kanu kəloku Nuha: ");
INSERT INTO bsp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Məwur abil disrɛ, məna kɔ wəran kam, awut am k'aran aŋan. ");
INSERT INTO bsp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Məwurɛnɛ sɔ sɛm yɛləpəs nyɛ yeyi abil disrɛ kɔ məna mɔ. Kɔ bɛmp dokom fəp, sɛm yɛfɛt kɔ yɔpɔŋ, yɛsam doru yokom.» ");
INSERT INTO bsp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kɔ Nuha owur debil nkɔn kɔ wəran kɔn k'awut ɔn k'aran aŋan. ");
INSERT INTO bsp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kɔ sɛm, bɛmp kɔ yeliŋɛ-liŋɛ yowur fəp dokom dokom. ");
INSERT INTO bsp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kɔ Nuha olompəs tetek toloŋnɛ MARIKI, k'ɛlɛk sɛm kɔ bɛmp yosoku dacɔ yin yin, k'ɔncɔfɛ yi MARIKI nde tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kɔ MARIKI ɛmbaŋ ambɔnc ŋa kəloŋnɛ nŋɛ ŋontorɛ-torɛ kɔ abəkəc mɔ, k'olokunɛ dɛbəkəc, «Ifɔsɔsɔŋ antɔf pəlɛc teta fum. Kance kɔ, bawo afum mɛcɛm-cɛmnɛ mɛlɛc meyi ŋa dəbəkəc kəyɛfɛ dowut daŋan, mba ifɔsɔləsər ca nyɛ yeŋesəm doru pəmɔ ntɛ intɛp ti kəcyɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","«Kəwon ka antɔf doru fəp, kəbɔf kɔ kətɛl, pəwonu kɔ pəcaŋki, kətən kɔ dɛrəŋ, dɔsɔk kɔ pibi, yɔfɔdelip.» ");
INSERT INTO bsp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kɔ Kanu kəmpocɛ Nuha pətɔt k'awut ɔn, kɔ kəloku ŋa: «Nəyɔnɛ akombəra, nəkom pəlarəm, nəlas antɔf. ");
INSERT INTO bsp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kəyɛfɛ mɔkɔ, sɛm ya doru fəp, kəbəp bɛmp, sɛm yɛfɛt kɔ lop, yende yecnesɛ nu. Nəndetam kəcsɔm yi. ");
INSERT INTO bsp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Paka o paka mpɛ peyi wəyeŋ pɔckɔt mɔ, pɔyɔnɛ nu peri pəmɔ ntɛ inasɔŋ nu yokom ya yika yɛcaŋk kɔ ya tɔk mɔ. Isɔŋ nu oŋ ndɛkəl yayɔkɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mba ta nəde nəcsɔm wɛsɛm nwɛ wɔsɔrɔyɔ mecir ma wi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Indeyif nu teta mecir monu, mmɛ mɔyɔnɛ kəyi doru konu mɔ. Indeyif sɔ ti sɛm fəp nyɛ yendedif fum mɔ. Pəmɔ ntɛ indeyif ti fum nwɛ endedif wɛnc mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«Nwɛ endif fum mɔ, padif sɔ (məna wəkayi), bawo Kanu kəlompəs fum pəwurɛnɛ kɔ nkɔn sərka. ");
INSERT INTO bsp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kɔ nəna, nəyɔnɛ akombəra, nəkom pəlarəm, nəsamsər doru.» ");
INSERT INTO bsp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kɔ Kanu kəloku sɔ Nuha k'awut ɔn: ");
INSERT INTO bsp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«K'ina, indesek sɔ danapa kɔ nəna, kəbəp ka yuruya yam kɔ nəna nəncepər-ɛ, ");
INSERT INTO bsp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kɔ ca fəp nyɛ yɔnɔŋkər nu mɔ: Bɛmp, sɛm ya dare kɔ ya dop, nyɛ yowur debil mɔ, kɔ nyɛ andekom nnɔ doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Isek danapa kɔ nəna, ntɛ t'indeyɔ: Domun dɔfɔdesɔdi antɔf, wəcafən ɔfɔdesɔyi nwɛ endeləsər antɔf mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kɔ Kanu kəndeŋər: «Paka pa danapa dosu pɛmpɛ mpɛ pendeyi su dacɔ kɔ nəna doru o doru, kəbəp ka ca yeŋesəm. ");
INSERT INTO bsp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Isɛkən ambəncəran (asiŋki) ŋem nde dəkəp. In'ende kəccɛm-cɛməs im temer ntɛ isɔŋ antɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tɛm o tɛm ntɛ wəcafən ende pəcbiyɛ, a asiŋki ŋowur mɔ, ");
INSERT INTO bsp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","incɛm-cɛmnɛ temer tɔkɔ inasɔŋ nu kɔ ca nyɛ yeŋesəm doru mɔ, wəcafən ɔfɔdesɔtuf nwɛ endesɔləsər ca ya doru fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Dəkəp ambəncəran ŋɔŋkɔyi. K'indenəŋk ŋi-ɛ, indecɛm-cɛmnɛ temer ta danapa dem ta doru o doru ntɛ inalɛk kɔ ca fəp nyɛ yeŋesəm doru mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kɔ Kanu kəŋgbɔkərɛnɛ sɔ moloku mamɛ Nuha: «Asiŋki ŋementər temer ntɛ isɔŋ nu kɔ ca ya doru nyɛ yeŋesəm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Awut a Nuha aŋɛ ŋanawur debil mɔ ŋanayɔnɛ: Sem, Ham, kɔ Yafɛt. Ham ɔyɔnɛ papa wəka Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Awut a Nuha akaŋɛ maas ŋagbɔkərɛ sɔ kəlas antɔf. ");
INSERT INTO bsp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Kɔ Nuha ɔyɔnɛ wəbifti antɔf k'ɔmbɔf ŋgbɔŋkəlɔ ya wɛn. ");
INSERT INTO bsp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kɔ Nuha omun member k'encis. K'ɔŋkɔ pəwur kəsɔkər nde abal ŋɔn disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ntɛ Ham papa wəka Kanaŋ ɛnəŋk kas Nuha pəyi kəsɔkər mɔ, k'ɔŋkɔ pəloku ti awɛnc aŋa mɛrəŋ, aŋɛ ŋanayi nde doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem kɔ Yafɛt ŋalɛk kəloto. Mɛrəŋ maŋan fəp, kɔ ŋaŋkumpnɛ kəloto kaŋkɔ dəcəro. Kɔ ŋaŋkɔ cəkəmuntəra kɔ ŋaŋkɔ ŋabəp papa kəŋan pəyi kəsɔkər. Kɔ ŋaŋkump kɔ kəsɔkər kəŋkɔ ɛnafəntərɛ mɔ. Mba ntɛ ŋanakafəli cəro cəŋan a kɔ ŋaŋkɔ kas kəŋan cəkəmuntəra mɔ, ŋananəŋk fɛ kas kəŋan kəsɔkər. ");
INSERT INTO bsp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ntɛ pəncɛrŋɛ Nuha kəcis kaŋkɔ disrɛ mɔ, k'aloku kɔ tɔkɔ pənayi kɔ ntɛ ɛnacis mɔ, kɔ tɔkɔ wan kɔn wəlpəs ɛnayɔ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kɔ Nuha oloku: «Intolanɛ Kanaŋ pəlɛc! Kanaŋ pəyɔnɛ wəcar ka acar a awɛnc aŋa!» ");
INSERT INTO bsp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kɔ Nuha oloku sɔ: «Intola MARIKI, Kanu ka Sem, Kanaŋ pəyɔnɛ wəcar kəŋan! ");
INSERT INTO bsp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kanu kəyac Yafɛt! Yafɛt pəyi abal ŋa Sem disrɛ, Kanaŋ nkɔn pəyɔnɛ wəcar kəŋan!» ");
INSERT INTO bsp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kɔ Nuha eyi sɔ doru meren 350, ntɛ domun dɛlarəm dencepər mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kəwon ka Nuha doru fəp, kənasɔtɔ meren 950, a k'endefi. ");
INSERT INTO bsp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dokombəra da awut a Nuha: Semy, Ham, kɔ Yafɛt dɛndɛ. Awut a Nuha ŋanakom awut, ntɛ domun dɛlarəm denacepər mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Awut a Yafɛt ŋanayɔnɛ: Komɛr, Makɔk, Maday, Yawaŋ, Tubal, Mɛsɛk, kɔ Tiras. ");
INSERT INTO bsp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Awut a Komɛr: Askenas, Rifat, kɔ Tokarma. ");
INSERT INTO bsp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Awut a Yawaŋ: Elisa, Tarsis, Kitim, kɔ Dodanim. ");
INSERT INTO bsp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Awut akakɔ ŋanakom afum aŋɛ ŋayersɛnɛ kəndɛ cəba kəsək mɔ, kɔ tɔf yaŋan, kɔ cusu cəŋan, kɔ cusuŋka cəŋan nde tɔf yaŋan. ");
INSERT INTO bsp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Awut a Ham ŋanayɔnɛ: Kus, Misira, Put, kɔ Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Awut a Kus: Seba, Hawila, Sabta, Rama, kɔ Sabatəka. Awut a Rama: Saba kɔ Dedaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ɛnakom sɔ Nimrod, nkɔn onuŋkɛnɛ kəyɔnɛ korgba doru dandɛ. ");
INSERT INTO bsp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrod ɛnayɔnɛ wəpɛn korgba nde fɔr ya MARIKI kiriŋ. Ti tɔ alokɛnɛ: «Pəmɔ Nimrod, korgba kəpɛn nde fɔr ya MARIKI kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","K'eŋkekərɛ dɛbɛ kərɛsna Babɛl, Ɛrɛk, Akad, kɔ Kalne nde atɔf ŋa Siŋhar. ");
INSERT INTO bsp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dəndo atɔf ŋaŋɔkɔ ŋɔ Asur ɛnawur, k'ɛncəmbər Niniwe, dare da Rehobot, Kalah, ");
INSERT INTO bsp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kɔ Rɛsɛŋ, dare dɔpɔŋ dɔkɔ dɛnayi Niniwe kɔ Kalah dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kɔ Misira ɛnayɔnɛ wətem k'afum aŋɛ: Aka Lud, aHanam, aLehab, aNaftu, ");
INSERT INTO bsp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","aPatərus, aKasəlu (aŋɛ aFilisti ŋawur dacɔ mɔ) k'aKaftor. ");
INSERT INTO bsp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kɔ Kanaŋ oŋkom Cidoŋ, coco cɔn, kɔ Het. ");
INSERT INTO bsp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaŋ ɛnayɔnɛ wətem ka cusuŋka cəlarəm: Aka Yebus, Amɔr, aKirkas, ");
INSERT INTO bsp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","aHewy, aHarki, aSini, ");
INSERT INTO bsp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","aka Arwad, aCemar, aHamat. Ti disrɛ kɔ cusuŋka ca Kanaŋ cənde cəsamsər. ");
INSERT INTO bsp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Cələncər ca aKanaŋ cənakɔ kəyɛfɛ Cidoŋ, Kerar kəsək, haŋ Kasa, kɔ kəca ka Sodom, kəca ka Komora, kəca ka Adma kɔ kəca ka Ceboyim, haŋ Lasah. ");
INSERT INTO bsp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Awut a Ham ŋɔ akakɔ, dəcusuŋka cusuŋka, dəcusu cusu, dətɔf tɔf. ");
INSERT INTO bsp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Kɔ Sem wəbeki ka Yafɛt, ɔsɔtɔ sɔ awut. Sem ɔyɔnɛ wətem ka Heber k'afum ɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Awut a Sem ŋanayɔnɛ: Helam, Asur, Arpaksad, Lud, k'Aram. ");
INSERT INTO bsp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Awut a Aram ŋanayɔnɛ: Huc, Hul, Kɛtɛr kɔ Mas. ");
INSERT INTO bsp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad ɛnakom Sɛlah. Kɔ Sɛlah oŋkom Hebɛr. ");
INSERT INTO bsp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kɔ Hebɛr oŋkom awut arkun mɛrəŋ. Tewe ta wəkin tɛnayɔnɛ Pɛlɛk, bawo tɛm tɔn tɔ antɔf ŋɛnayerɛnɛ. Kɔ tewe ta wɛnc tɛnayɔnɛ Yoktan. ");
INSERT INTO bsp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kɔ Yoktan oŋkom Almodad, Sɛlɛf, Hacarmawɛt, Yɛrah, ");
INSERT INTO bsp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Husal, Dikalah, ");
INSERT INTO bsp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Hobal, Abimayɛl, Saba, ");
INSERT INTO bsp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, kɔ Yobab. Akaŋɛ fəp awut a Yoktan ŋanayi. ");
INSERT INTO bsp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kɔ ŋandɛ kəyɛfɛ ka Mesa, Sefar kəsək, haŋ nde mɔrɔ ma nde dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Awut a Sem ŋɔ akakɔ, dəcusuŋka cusuŋka, dəcusu cusu, dətɔf tɔf. ");
INSERT INTO bsp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Cusuŋka ca awut a Nuha cɔ cacɔkɔ, kɔ tɔkɔ aŋkom ŋa mɔ. Afum akaŋɛ ŋɔ afum ŋawur dəris a kɔ ŋandeyersɛnɛ dəntɔf, doru fəp ntɛ domun dɛlarəm denacepər mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tɛm tatɔkɔ doru fəp kusu kin k'anccɔp, pacloku, moloku min mayi. ");
INSERT INTO bsp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","K'afum ŋande ŋakɔ kəca nkɛ dec dɛmpɛ mɔ, kɔ ŋanəŋk mɔrɔ atɔf ŋa Siŋhar, kɔ ŋandɛ mi dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kɔ ŋalokɛnɛ: «Pasut birik, pacɔf bi!» Kɔ birik bɔcɔf babɔkɔ bɔyɔnɛ ŋa masar, kɔ kɔrtal kəyɔnɛ ŋa dos. ");
INSERT INTO bsp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kɔ ŋaloku sɔ: «Paŋkɔn, pacəmbər dare kɔ kəlɔ nkɛ domp da ki dendekɔ haŋ dɔsɔ kɔm mɔ. Ntɛ tɔŋsɔŋɛ pasɔtɔ tewe mɔ, tɔsɔŋɛ su sɔ kətɔsamsər doru.» ");
INSERT INTO bsp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kɔ MARIKI ontor kədemɔmən dare kɔ kəlɔ nkɛ afum ŋanccəmbər mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kɔ MARIKI oloku, «Nəmɔmən afum aŋɛ! Fəp faŋan kusu kin kɔ ŋancɔp. Nəmɔmən sɔ ntɛ ŋancop kəyɔ mɔ. Tɔlɔm o tɔlɔm teyi fɛ ntɛ tɔŋmɔnɛ ŋa kəyɔ ka tɛfaŋ taŋan mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Paŋkɔn, pator, panɔŋkəl-nɔŋkəl kusu kəŋan ntɛ tɔŋsɔŋɛ ta ŋanenɛnɛ sɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kɔ MARIKI ɛsamsər ŋa doru, kɔ ŋasak kəcəmbər dare. ");
INSERT INTO bsp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ti t'awenɛ di Babɛl, bawo difɔ MARIKI ɛnanɔŋkəl cusu, k'ɛsaməsər afum doru. ");
INSERT INTO bsp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Tecepərɛnɛ ta Sem tɛntɛ: Sem ɛnasɔtɔ meren 100, a pədekom Arpaksad, teren ta mɛrəŋ ntɛ domun dɛnasak antɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Kəkom ka Arpaksad, kɔ Sem eyi sɔ doru meren 500, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad ɛnasɔtɔ meren 35, a pədekom Sɛlah. ");
INSERT INTO bsp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kəkom ka Sɛlah, Arpaksad ɛnasɔtɔ sɔ meren 403, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sɛlah ɛnasɔtɔ meren 30, a pədekom Hebɛr. ");
INSERT INTO bsp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kəkom ka Hebɛr, Sɛlah ɛnasɔtɔ sɔ meren 403, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kɔ Hebɛr ɔsɔtɔ meren 34, a pədekom Pɛlɛk. ");
INSERT INTO bsp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kəkom ka Pɛlɛk, Hebɛr ɛnasɔtɔ sɔ meren 430, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pɛlɛk ɛnasɔtɔ meren 30, a pədekom Rehu. ");
INSERT INTO bsp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kəkom ka Rehu, Pɛlɛk ɛnasɔtɔ sɔ meren 209, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu ɛnasɔtɔ meren 32, a pədekom Seruk. ");
INSERT INTO bsp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kəkom ka Seruk, Rehu ɛnasɔtɔ sɔ meren 207, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk ɛnasɔtɔ meren 30, a pədekom Nahor. ");
INSERT INTO bsp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kəkom ka Nahor, Seruk ɛnasɔtɔ sɔ meren 200, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor ɛnasɔtɔ meren 29 a pədekom Terah. ");
INSERT INTO bsp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kəkom ka Terah, Nahor ɛnasɔtɔ sɔ meren 119, mmɛ ɛnakom sɔ awut arkun k'awut aran alɔma mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah ɛnasɔtɔ meren 70, a pədekom Abram, Nahor kɔ Haraŋ. ");
INSERT INTO bsp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tecepərɛnɛ ta Terah tɛntɛ: Terah okom Abram, Nahor kɔ Haraŋ nwɛ ɛnakom Lɔt mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haraŋ, fɔr ya kas kiriŋ y'ɛnafi, atɔf nŋɛ anakom kɔ mɔ, nde dare da Ur nde atɔf ŋa Kaldi. ");
INSERT INTO bsp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram kɔ Nahor ŋanɛncɛ. Wəran ka Abram ancwe Saray kɔ wəran ka Nahor, Milka. Milka, wan ka Haraŋ ɛnayi, ŋapaŋnɛ kas kin kɔ Yiska. ");
INSERT INTO bsp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray ɛnakom fɛ, ɛnasɔtɔ fɛ wan. ");
INSERT INTO bsp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kɔ Terah ɛlɛk wan kɔn Abram, kɔ wansɔ kɔn Lɔt, wan ka Haraŋ, k'ɛlɛkɛnɛ sɔ Saray wəran ka Abram, kɔ ŋasol fəp faŋan kəwur ka nde dare da Ur nde atɔf ŋa Kaldi kəkɔ ka atɔf ŋa Kanaŋ. Kɔ ŋambəp atɔf ŋa Haraŋ kɔ ŋandɛ di. ");
INSERT INTO bsp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah ɛnawon doru meren 205, a k'endefi dəndo atɔf ŋa Haraŋ. ");
INSERT INTO bsp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kɔ MARIKI oloku Abram: «Məwur atɔf ŋam, dəŋkom dam, kəlɔ ka papa kam, məkɔ atɔf nŋɛ indementər əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Indesɔŋ'am kəyɔnɛ ka kas k'afum alarəm, indesɔŋ əm pətɔt, indesɔŋɛ tewe tam tɛbɛk. Məndetolanɛ afum alɔma pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Indesɔŋ pətɔt aŋɛ ŋandetolan'am pətɔt mɔ. Indesɔŋ pəlɛc aŋɛ ŋandetolan'am pəlɛc mɔ. Tetam t'indesɔŋɛnɛ cusuŋka ca doru fəp pətɔt.» ");
INSERT INTO bsp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","K'Abram owur Haraŋ pəmɔ tɔkɔ MARIKI ɛnaloku kɔ ti mɔ, kɔ Lɔt ɛncɛpsɛ kɔ darəŋ. Tɛnatəŋnɛ Abram pəsɔtɔ meren 75. ");
INSERT INTO bsp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","K'Abram ɛlɛk Saray, wəran kɔn, kɔ Lɔt wan ka wəbek'ɔn wərkun kɔ ca yɔkɔ ŋanayɔ di mɔ, k'afum akɔ ɛnasɔtɔ Haraŋ mɔ. Kɔ ŋawur kəkɔ atɔf ŋa Kanaŋ. Kɔ ŋambɛrɛ atɔf ŋa Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","K'Abram ɛncali atɔf haŋ kəfo nkɛ ancwe Səkɛm, haŋ nde tofo ntɛ Aŋkiri ŋa More ŋɛncəmɛ mɔ. Aka Kanaŋ ŋanayi atɔf ŋaŋɔkɔ tɛm tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kɔ MARIKI owurər Abram k'oloku kɔ: «Indesɔŋ atɔf ŋaŋɛ yuruya yam.» K'Abram olompsɛ MARIKI mmɛ mɛnawurər kɔ mɔ, tetek toloŋnɛ dəndo. ");
INSERT INTO bsp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","K'eyekti sɔ di saŋka, nde ɛncyɛfɛ pəckɔ dəmɔrɔ mɔ, kəca nkɛ dec dɛmpɛ Betel mɔ. K'ɛncəmbər abal di, Betel beyi kɔ nde dec dɛŋkalɛ mɔ, dare da Hay deyi kɔ nde dec dɛmpɛ mɔ. K'ɔlɔ di tetek toloŋnɛ MARIKI, k'ontola tewe ta MARIKI. ");
INSERT INTO bsp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","K'Abram ɛyɛfɛ kəcal-cali kəkɔ ka kəca ka Nɛkɛf. ");
INSERT INTO bsp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Dor dɛnayi dɔtɔf, k'Abram ontor Misira kəkɔcepərɛnɛ tɛm, bawo dor dɛncbɛk kəbɛk dəm. ");
INSERT INTO bsp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ntɛ ɔlɔtərnɛ kəbɛrɛ Misira mɔ, k'oloku wəran kɔn Saray: «Məcəŋkəl im, incərɛ a wəran wətɔt teyi məyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","K'aka Misira ŋandekɔnəŋk əm-ɛ, ŋandekɔloku: ‹Wəran kɔn ɔfɔ!› Tɛm tatɔkɔ ŋandekɔdif im, ŋasak məna. ");
INSERT INTO bsp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mədekɔ məloku ŋa a wəkirɛ kem məyɔnɛ. Ntɛ tɔŋsɔŋɛ ŋasumpər im belbel tetam mɔ, tetam t'endekɔsɔŋɛ, ta ifi-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ntɛ Abram ɛmbɛrɛ Misira mɔ, k'aka Misira ŋanəŋk wəran nwɛ entesɛ pəcepərər. ");
INSERT INTO bsp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","K'akəsək a Firawona ŋanəŋk kɔ, kɔ ŋayek-yekəs kɔ nda Firawona. Ntɛ tɔ k'aŋkɛrɛ wəran nwɛ nde kəlɔ ka Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kɔ Firawona osumpər Abram belbel teta Saray, k'ɔsɔtɔ kəyɛfɛ sɛm yɛfɛt haŋ yɔpɔŋ, sɔfale, amarəs arkun k'aran kɔ yɔkɔmɛ. ");
INSERT INTO bsp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mba kɔ MARIKI ɔsɔŋ Firawona k'afum ɔn runc yɔpɔŋ teta Saray, wəran ka Abram. ");
INSERT INTO bsp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kɔ Firawona ewe Abram, k'eyif kɔ: «Cəke cɔ məyɔ em ntɛ? Ake'sɔŋɛ ntɛ məntɔlok'im a wəran kam ɔfɔ mɔ? ");
INSERT INTO bsp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","T'ake tɔ məlokɛ a wəkirɛ kam ɔfɔ-ɛ? Məsɔŋ'em kəlɛk kɔ pəyɔnɛ wəran kem. Ndɛkəl oŋ, wəran kam ɛwɛ. Məlɛk kɔ! Məkɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kɔ Firawona oloku afum ɔn, «Nəsak kɔ pəkɔ nkɔn, kɔ wəran kɔn kɔ ca nyɛ yɔyɔnɛ yɔn mɔ fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","K'Abram ɛmpɛrnɛ Misira kəkɔ ka kəca ka Nɛkɛf, nkɔn, wəran kɔn kɔ ca yɔkɔ ɛnayɔ mɔ fəp, pəsol kɔ wərok kɔn Lɔt. ");
INSERT INTO bsp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ɛnasɔtɔ daka dɛlarəm, ɛnala yɔcɔl, pəsam kɔ kɛma. ");
INSERT INTO bsp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","K'ɛyɛfɛ kəcal-cali kəyɛfɛ ka Nɛkɛf haŋ Betel da ɛnadɔf abal tɔcɔkɔ-cɔkɔ mɔ, Betel kɔ Hay dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Kəca nkɛ ɛnanuŋkɛnɛ kəlompəs tetek toloŋnɛ Kanu dənda, k'Abram oŋkornɛ tewe ta MARIKI. ");
INSERT INTO bsp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lɔt nwɛ ŋanasol mɔ, nkɔn sɔ ɛnayɔ cir, ŋkesiya, cəna kəbəp cəbal. ");
INSERT INTO bsp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Atɔf ŋɛnafɛtər ŋa kəyi kəŋan tofo tin, bawo yɔcɔl yaŋan yɛnala. ");
INSERT INTO bsp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kɔ kəcɔp kənde kəyi akɛk a yɔcɔl ya Abram k'akɛk a yɔcɔl ya Lɔt dacɔ. Atɔf ŋaŋɔkɔ sɔ, aKanaŋ k'aPerisi ŋanandɛ ŋi tɛm tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","K'Abram oloku Lɔt: «Pəmar fɛ akɛk a yɔcɔl yam ŋacɔp k'akɛk a yɔcɔl yem. Səna sɔ pəmar fɛ su ti, bawo aka kəlɔ kin disrɛ ŋɔ səyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Antɔf fəp ŋɔ ŋaŋɛ ŋey'əm fɔr kiriŋ mɔ. Kɔ məŋkɔ kəca kətɔt-ɛ, iŋkɔ kəmeriya. Kɔ məŋkɔ kəmeriya, iŋkɔ kətɔt, mba məwosɛ səgbɛyɛnɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kɔ Lɔt eyekti fɔr k'ɛnəŋk aranta ŋa Yurdɛn tɔkɔ ŋɛndəm mɔ (tɛm tatɔkɔ ta Kanu kəntaləsər Sodom kɔ Komora-ɛ), pənckɔ haŋ Cohar pəmɔ aranta (mɛrɛ) ŋa MARIKI, pəmɔ atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kɔ Lɔt ɛlɛk dalɛ da Yurdɛn fəp, k'ɔŋkɔ kəca nkɛ dec dɛmpɛ mɔ, tatɔkɔ tɔ ŋanagbɛyɛnɛ kɔ Abram. ");
INSERT INTO bsp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","K'Abram ɛndɛ atɔf ŋa Kanaŋ, kɔ Lɔt ɛndɛ sədare sa aranta ŋa Yurdɛn k'ɔndɔf cəbal cɔn kəca ka Sodom. ");
INSERT INTO bsp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Afum a Sodom ŋanatesɛ fɛ bəkəc, ŋancciya MARIKI. ");
INSERT INTO bsp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Kɔ MARIKI oloku Abram, ntɛ ŋasakɛnɛ oŋ kɔ Lɔt mɔ: «Məyekti fɔr kəyɛfɛ dənda məyi mɔ, məmɔmən kəca kətɔt, kəmeriya nde dec dɛmpɛ kɔ nde dɛŋkalɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Bawo atɔf ŋaŋɛ məŋnəŋk mɔ fəp indesɔŋ əm ŋi kɔ yuruya yam. ");
INSERT INTO bsp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Indesɔŋɛ yuruya yam yɛla haŋ ta antam kəlɔm ŋa-ɛ, pəmɔ tɔkɔ antɔtam kəlɔm kəbof antɔf kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Məyɛfɛ məkɔt atɔf ŋaŋɛ dobolu kɔ dowokulu da ŋi, bawo indesɔŋ əm ŋi.» ");
INSERT INTO bsp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kɔ Abram encepɛ cəbal cɔn, k'ende pədɔf ci nde tofo ntɛ Aŋkiri ŋa Mamre yɛncəmɛ mɔ kəsək, ta ɔmbɔlɛ Hebərɔŋ-ɛ, k'olompəs di tetek toloŋnɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tɛm tatɔkɔ tɔ abɛ a tɔf maŋkəlɛ ŋancyɛfərɛnɛ kɔ abɛ a sədare kəcamət: Amrafɛl wəbɛ wəka Siŋhar, Aryok wəbɛ wəka Elasar, Kədɔr-Lahomɛr wəbɛ wəka Helam, kɔ Tidəhal wəbɛ wəka Koyim, ");
INSERT INTO bsp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","tɛnatəŋnɛ abɛ akakɔ ŋacyɛfərɛnɛ kɔ abɛ a sədare kəcamət: Bera wəbɛ wəka Sodom, Birəsa wəbɛ wəka Komora, Sinab wəbɛ wəka Adma, Semeber wəbɛ wəka Ceboyim kɔ wəbɛ wəka Bela mbɛ bɔyɔnɛ Cohar mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Abɛ akaŋɛ kəcamət fəp aranta ŋa Sidim dacɔ ŋanandɛ, nde pəyɔnɛ mɔkɔ Kəba Kədokət mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Meren wəco kɔ mɛrəŋ ŋayi kətam ka Kədɔr-Lahomɛr dəntɔf, mba teren ta wəco kɔ maas kɔ ŋayeŋkər kɔ səbomp. ");
INSERT INTO bsp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Teren ta wəco kɔ maŋkəlɛ, Kədɔr-Lahomɛr k'abɛ akɔ ŋanabɛrɛnɛ mɔ, ŋasut aRefay nde dare da Asterot-Karnayim, kɔ ŋasut aSus nde Ham, kɔ ŋasut afum a Em nde Aranta ŋa Kiriyatayim. ");
INSERT INTO bsp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","K'abɛ maŋkəlɛ ŋasut aHor ndaraŋan, nde mɔrɔ ma Sehir. Kɔ ŋambɛləs aHor haŋ nde tofo ntɛ Aŋkiri ŋa Paran ŋɛncəmɛ mɔ, nde tɛgbərɛ kəsək. ");
INSERT INTO bsp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","K'abɛ akaŋɛ maŋkəlɛ ŋaluksərnɛ Eyən-Mispe (nŋɛ ŋɔyɔnɛ Kadɛs mɔ), kɔ ŋasut aka Amalek atɔf ŋaŋan fəp kɔ Amɔr aŋɛ ŋanandɛ Hacacon-Tamar mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kɔ abɛ a sədare kəcamət (Sodom, Komora, Adma, Ceboyim kɔ Bela, ti tɔ tatɔkɔ Cohar) ŋambɛrɛnɛ kəsutɛnɛ nde aranta ŋa Sidim. ");
INSERT INTO bsp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Akɔ sɔ ŋayi: Kədɔr-Lahomɛr wəbɛ wəka Helam, Tidəhal wəbɛ wəka Koyim, Amrafɛl wəbɛ wəka Siŋhar, kɔ Aryok wəbɛ wəka Elasar. Abɛ maŋkəlɛ ŋayɛfərɛnɛ kɔ abɛ kəcamət. ");
INSERT INTO bsp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ntɛ Aranta ŋa Sidim ŋɛnala cələmp ca kɔrtal mɔ, k'abɛ aŋɛ kəcamət dacɔ, wəbɛ wəka Sodom kɔ wəka Komora ŋayɛksɛ kɔ ŋantɛmpɛnɛ ci disrɛ. K'alpəs aŋɛ maas k'asɔdar aŋan ŋayɛksɛ kɔ ŋantɛfərnɛ kəca ka dətɔrɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","K'atam a asɔdar a abɛ kəcamət ŋawɛtəs ca ya aka Sodom kɔ Komora kɔ yeri yaŋan fəp, kɔ ŋaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kɔ ŋasumpər sɔ Lɔt kɔ daka dɔn, nkɔn Lɔt wan ka wəbeki ka Abram ɛnayi, (kəyɛfərɛnɛ kaŋkɛ kənabəp Lɔt nwɛ pəyi Sodom). ");
INSERT INTO bsp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kɔ wəmulpɛ dəkəwan wəkin ende pəloku ti Abram wəHebəre, nwɛ ɛnandɛ nde kəfo nkɛ Aŋkiri ŋa Mamre wəAmɔr ŋɛnacəmɛ mɔ. Mamre nwɛ pəyɔnɛ wɛnc ka Ɛskɔl kɔ Haner, aŋɛ ŋanacaŋəs kətəŋnɛ kɔ Abram mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ntɛ Abram ene kəsumpər ka wan ka wəbek'ɔn mɔ, k'oloŋka asol ɔn afum 318 aŋɛ ŋanabaŋsɛ, akomɛnɛ ɔn dacɔ mɔ. K'ɛncɛpsɛ abɛ aŋɛ ŋanasumpər wan ka wəbek'ɔn darəŋ haŋ dare da Dan. ");
INSERT INTO bsp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","K'Abram eyerəs kənay (kəgba) kɔn, kɔ ŋawɛkərnɛ ŋa kəyɛfərɛnɛ ka pibi, nkɔn Abram k'amar ɔn, kɔ ŋasut asumpər a wan ka wəbek'ɔn, kɔ ŋambɛləs ŋa haŋ Hoba, nŋɛ ŋeyi Damas kəca kəmeriya mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","K'oluksɛ ca fəp, k'oluksɛ sɔ Lɔt wan ka wəbek'ɔn, aran, k'afum alpəs aŋɛ. ");
INSERT INTO bsp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ntɛ Abram osut Kədɔr-Lahomɛr k'amarɛnɛ ɔn mɔ, kɔ wəbɛ wəka Sodom owur kədefaynɛ kɔ nde aranta ŋa Sawe, nde pəyɔnɛ «Aranta ŋa Wəbɛ» mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek, wəbɛ wəka Salɛm, ɛŋkɛrɛ kəcom kɔ member: Melkisedek, wəloŋnɛ wəka Kanu nkɛ kəyi canu cəlɔma fəp kəroŋ mɔ, ɛnayi. ");
INSERT INTO bsp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kɔ Melkisedek ontolanɛ Abram, k'oloku: «Məna Abram, Kanu nkɛ kəyi canu cəlɔma fəp kəroŋ mɔ, Wəbɛ wəka dəntɔf kɔ darenc, kəpoc'am pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ileləs Kanu nkɛ kəyi canu cəlɔma fəp kəroŋ mɔ, nkɛ kəlɛk ayɛfərɛnɛ am kɔ kəmbɛr əm dəwaca mɔ!» Kɔ Abram ɔsɔŋ kɔ farilɛ fa ca yɔkɔ ŋanasɔtɔ dəkəwan mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kɔ wəbɛ wəka Sodom oloku Abram: «Məsɔŋ im afum, məlɛk ca yayɛ fəp yam.» ");
INSERT INTO bsp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kɔ Abram oluksɛ wəbɛ wəka Sodom mɔcɔp: «Indot kəca nnɔ MARIKI nwɛ eyi canu cəlɔma fəp kəroŋ mɔ, nwɛ ɔyɔnɛ wəbɛ wəka darenc kɔ dəntɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ifɔlɛk ali paka pin ca yam dacɔ. Ali debeŋa kɔ pəyi fɛ ti-ɛ pɛpətərɛ pa kɔfta kam. Ti tɔ məntɔtam kəloku: ‹In'ɔsɔŋɛ Abram kəyɔ daka.› ");
INSERT INTO bsp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ifɔlɛk daka o daka, mɛnɛ yeri nyɛ afum em ŋandi mɔ, kɔ kəyer nkɛ atɛmp em Ɛskɔl, Haner, kɔ Mamre ŋasɔtɔ mɔ, bawo pəmar ŋasɔtɔ kəyer.» ");
INSERT INTO bsp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ntɛ mes mamɔkɔ mencepər mɔ, kɔ MARIKI owurər Abram dəmere k'oloku kɔ ntɛ: «Ta mənesɛ, Abram! Ina yati indeyɔn'am aca. Indeluks'am kəway pəpɔŋ.» ");
INSERT INTO bsp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kɔ Abram eyif Kanu: «MARIKI Wəbɛ kem, ake məndesɔŋ im-ɛ? Intas ta iyɔ wan-ɛ, wədelɛk kɛ kem ɔyɔnɛ Eliyeser wəka Damas.» ");
INSERT INTO bsp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kɔ Abram ɔnɔcər: «Məsɔŋ f'em awut, nwɛ aŋkom nde kəlɔ kem disrɛ mɔ, nkɔn endelɛk kɛ kem.» ");
INSERT INTO bsp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kɔ MARIKI oloku kɔ, «Ala, bafɔ nkɔn endeyɔnɛ wəlɛk ka kɛ kam, mba wan kam wəkom nwɛ endewur əm dəris mɔ yati.» ");
INSERT INTO bsp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kɔ MARIKI owurɛnɛ Abram abal ŋɔn disrɛ, k'oloku kɔ: «Məgbətnɛ kɔm. Məlɔm cɔs cacɔkɔ, kɔ məntam-ɛ.» K'ɔnɔcər: «Pəmɔ cɔs cacɔkɔ, yuruya yam afɔde pactam kəlɔm ŋa fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram ɛnagbɛkər kəlaŋ kɔn MARIKI. Ti tɔ MARIKI ɛnalɔmɛ kɔ fum wəlompu. ");
INSERT INTO bsp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kɔ Kanu kəloku kɔ: «In'ɔyɔnɛ MARIKI nwɛ ɛnawur'am Ur ŋa aKaldi kədesɔŋ əm atɔf ŋaŋɛ, məde məlɛk ŋi kɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kɔ Abram eyif: «MARIKI Wəbɛ kem, cəke c'indetam kəcərɛ a indesɔtɔ atɔf ŋaŋɛ kɛ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kɔ Kanu kəloku kɔ: «Məkɛr'em wana weyecəra win, wir wɛran win, kɔ aŋkesiya ŋorkun ŋin fəp fayi ya meren maas maas, tɔpay tin kɔ apokpoka ŋin.» ");
INSERT INTO bsp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kɔ Abram ɛŋkɛrɛ sɛm yayɔkɔ k'eŋgber-gberi yi dacɔ dacɔ k'ombocəs yegber-gberi yayɔkɔ mɛrəŋ mɛrəŋ yɛtɛfərɛnɛ, kɔ bɛmp, məlməl m'ɛnaboc yi ta aŋgberi yi-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kɔ yɔfən yontorər sɛm yegber-gberi yayɔkɔ, mba k'Abram ɛmbɛləs yi. ");
INSERT INTO bsp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Dec dendekalɛ, k'Abram endirərnɛ, k'ayekyek ŋɔpɔŋ ŋɛŋgbəpərnɛ kɔ k'enesɛ dəmere. ");
INSERT INTO bsp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kɔ Kanu kəloku Abram: «Məcərɛ a yuruya yam yendeyɔnɛ acikəra atɔf ŋocuru nŋɛ ŋɔntɔyɔnɛ ŋaŋan mɔ. Ŋandekɔyɔnɛ di acar, andekɔtɔrəs ŋa di haŋ meren 400. ");
INSERT INTO bsp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mba Indetɔrəs afum aŋɛ ŋandecəmbər ŋa dacar mɔ, ŋandewur atɔf ŋaŋɔkɔ kɔ ca yɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kɔ məna Abram, məndekɔbəp atem am pəforu disrɛ, pawup əm detem dobotu disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Yuruya yam yendeluksərnɛ nnɔ mɛnɛ tɛm ta danapa da maŋkəlɛ, bawo Amɔr ŋantacepərər fɛ kiciya kəŋan a idebɛləs ŋa dɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ntɛ dec dɛŋkalɛ mɔ, k'asum ŋɛmət (dimi dontor) kɔ teken pɛncɛsəŋɛ, nɛnc kɔ kinimɛ yencepər yoboc ya sɛm yeyer yayɔkɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Dɔsɔk dadɔkɔ dɔ MARIKI ɛnacaŋəs kəyi kəŋan danapa kɔ Abram. Pəcloku Abram: «Isɔŋ yuruya yam kəyɛfɛ ka kəŋgbɔkɔ ka Misira haŋ Ɛfərat, kəŋgbɔkɔ kəpɔŋ: ");
INSERT INTO bsp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Indesɔŋ yuruya yam atɔf ŋa aKeni, aKenisi, aKadmon, ");
INSERT INTO bsp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ŋa aHewy, aPerisi, aRefay, ");
INSERT INTO bsp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ŋa Amɔr, aKanaŋ, aKirkas, kɔ aYebus.» ");
INSERT INTO bsp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saray wəran k'Abram ɛnakomɛ fɛ kɔ wan. Mba ɛnayɔ wəcar wəran wəMisira, pacwe kɔ Hakar. ");
INSERT INTO bsp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kɔ Saray oloku Abram: «Mənəŋk, MARIKI ɛyamsər im kəsɔtɔ ka wan. Məfəntərɛ kɔ wəcar kem, tɔlɔma intam kəsɔtər kɔ wan wərkun.» Kɔ Abram ɛncəŋkəl dim da Saray. ");
INSERT INTO bsp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Awa, kɔ Saray wəran ka Abram ɛlɛk wəcar kɔn wəMisira, Hakar, k'ɔsɔŋ kɔ wos Abram pəyɔ kɔ wəran. Tɛnatəŋnɛ kəndɛ ka Abram atɔf ŋa Kanaŋ kəsɔtɔ meren wəco. ");
INSERT INTO bsp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kɔ Abram ŋafəntərɛ kɔ Hakar, kɔ Hakar ɛmbɛkəs. Ntɛ ɛncərɛ a ɛmbɛkəs mɔ, Hakar ɔmɔmənɛ fɛ sɔ Saray fɔr yɔtɔt. ");
INSERT INTO bsp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kɔ Saray oloku Abram: «Mən'endesarɛ pəcuy pa mɔlɔməs mmɛ ɔlɔməs im mɔ! Ina yati, in'ɛlɛk wəcar kem k'imbɛr əm kɔ dəwaca, mba ntɛ ɛnəŋknɛ oŋ pəbɛkəs mɔ, k'ɛyɛfɛ kəfər-fərəs im. Mba MARIKI omboc su kiti dacɔ (kəyi su dacɔ), ina kɔ məna!» ");
INSERT INTO bsp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kɔ Abram oluksɛ Saray moloku: «Wəcar kam ey'əm dəwaca. Məyɔ kɔ tɔkɔ tentes'am mɔ.» Awa, kɔ Saray ɔntɔrəs Hakar haŋ kɔ Hakar ɛyɛksər kɔ, k'ɔŋkɔ pəbɔlɛ. ");
INSERT INTO bsp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Kɔ mɛlɛkɛ ma MARIKI mɔŋkɔ mɛbəp kɔ nde dətɛgbərɛ kələmp kəlɔma kəsək ta ɔmbɔlɛ kəŋgbɔkɔ nkɛ kəyi dɔpɔ da Sur mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kɔ mɛlɛkɛ mmɛ meyif: «Hakar, wəcar ka Saray, deke məyɛfɛ-ɛ? Deke məŋkɔ-ɛ?» Kɔ Hakar oluksɛ mi moloku: «Mariki mem Saray, iyɛksər.» ");
INSERT INTO bsp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kɔ mɛlɛkɛ ma MARIKI moloku, «Məluksərnɛ ndena Mariki mam, məkɔ məfəntərɛ kɔ dəntɔf.» ");
INSERT INTO bsp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kɔ mɛlɛkɛ ma MARIKI moloku kɔ: «Indesɔŋɛ yuruya yam yɛla haŋ ta antam kəlɔm ŋa-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kɔ mɛlɛkɛ ma MARIKI moloku kɔ: «Məmbɛkəs tantɛ, wan wərkun məndekom, wan wəkakɔ məde məsɔŋ kɔ tewe ta Səmayila, bawo MARIKI ene kəkulɛ-kulɛ ka pəcuy pam. ");
INSERT INTO bsp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wan kam endeyi pəmɔ sɔfale sa dop. Ende pəccaŋ afum fəp kəyɛfərɛnɛ, fəp fəcyɛfərɛnɛ kɔ nkɔn. Sona s'endendɛ pəbɔlɛnɛ afum alpəs aŋɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kɔ Hakar ewe MARIKI mmɛ mɛnalok-lokər kɔ mɔ, «Ata-Ɛl-Roy,» ti tɔ tatɔkɔ: «Inəŋk nnɔ Kanu nkɛ kənəŋk im mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ti t'awenɛ kələmp kaŋkɔ, kələmp ka Lahay-Roy. Kələmp kaŋkɔ kəyi Kadɛs kɔ Beredu dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kɔ Hakar oŋkomɛ Abram wan wərkun, kɔ Abram ewe wan wəkakɔ Hakar ɛnakomɛ kɔ mɔ tewe ta Səmayila. ");
INSERT INTO bsp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram ɛnasɔtɔ meren 86 tɛm ntɛ Hakar onckomɛ kɔ Səmayila mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ntɛ Abram ɔsɔtɔ meren 99 mɔ, kɔ MARIKI owurər kɔ, pəcloku kɔ: «In'ɔyɔnɛ Kanu nkɛ kəntam mes ma doru fəp mɔ, məkɔt fɔr yem kiriŋ, məcəmɛ pəlompu darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Indecaŋəs danapa dosu, ina kɔ məna dacɔ, isɔŋ əm yuruya yɛlarəm.» ");
INSERT INTO bsp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kɔ Abram ɛncəp tobu dəntɔf kɔ Kanu kəloku kɔ ntɛ: ");
INSERT INTO bsp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Ta ina, danapa dem dɛndɛ kɔ məna dacɔ: Məndeyɔnɛ kas ka afum a tɔf yɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Afɔsɔw'am tewe ta Abram, mba Abraham, bawo indesɔŋ'am kəyɔnɛ ka kas ka afum a tɔf yɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Indesɔŋ əm dokombəra dɔpɔŋ, indesɔŋ'am kəkom ka afum alarəm, abɛ yati ŋandeyi ŋa dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Indepɛnɛ danapa, ina kɔ məna dacɔ kəbəp ka yuruya yam kɔ məna məfi-ɛ, indecəmɛ danapa dadɔkɔ darəŋ kɔ yuruya yam doru o doru. Tɛm tatɔkɔ Kanu kam k'indeyɔnɛ kɔ ka yuruya yam kɔ məna məndecepər-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Indesɔŋ əm kɔ yuruya yam atɔf ŋa Kanaŋ ŋaŋɛ məntɛp kəcbɛrɛ mɔ fəp, ŋendeyɔnɛ ŋaŋan doru o doru, iyɔnɛ Kanu kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kɔ Kanu kəloku Abraham: «Məna kɔ yuruya yam, dɛtɛmp dɛtɛmp nəleləs danapa ndɛ səncaŋəs mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ntɛ tɔ nəndetɔmpərərnɛ danapa dem ndɛ incaŋəs məna kɔ yuruya yam kɔ məndecepər-ɛ. Nwɛ o nwɛ ɔŋyɔnɛ wərkun yuruya yam dacɔ mɔ, pakənc kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kəkənc konu kəndementər kəcəmɛ konu danapa dem darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kəyɛfɛ dɛtɛmp kɔ dɛtɛmp awut anu arkun fəp packənc ŋa tataka ta camət-maas, pəyɔnɛ wəkom wəka kəlɔ kam, kɔ pəyɔnɛ fɛ ti-ɛ fum nwɛ asɔtɔnɛ pəsam nnɔ wəcikəra eyi mɔ, ta ɔyɔnɛ wəka yuruya yam mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Pəmar pade packənc nwɛ andekom nde kəlɔ kam kɔ nwɛ andesɔtɔnɛ pəsam mɔ, ti tendeyɔnɛ kəfat ka danapa dem da doru o doru nde dis donu. ");
INSERT INTO bsp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Wərkun nwɛ o nwɛ antɔkənc mɔ, aŋwurɛ wəkayi afum ɔn dacɔ, tɛm tatɔkɔ danapa dem delip nnɔ nkɔn eyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kɔ Kanu kəloku sɔ Abraham: «Ntɛ tɔyɔnɛ ta wəran kam Saray mɔ, ta məwe kɔ sɔ Saray, kəyɛfɛ mɔkɔ Sara s'ande pacwe kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kəpocɛ kɔ k'inder, ipocɛ sɔ məna wan nwɛ endekom'am mɔ. Indepocɛ kɔ pətɔt, nkɔn endeyɔnɛ kɛrɛ ka tɔf yɛlarəm. Abɛ a tɔf yɛlarəm ŋandewur kɔ dəris.» ");
INSERT INTO bsp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kɔ Abraham ɛncəp kəro dəntɔf kəsel, k'olokunɛ dɛbəkəc: «Wərkun wəka meren 100 ɛntam kəkom ba? Kɔ Sara ɔsɔtɔ meren 90 endekom ba?» ");
INSERT INTO bsp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kɔ Abraham oloku Kanu: «Məgbətnɛ Səmayila doru!» ");
INSERT INTO bsp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kɔ Kanu kəloku: «Ala! Wəran kam Sara endekom'am wan nwɛ məndewe Siyaka mɔ. Indecəmɛ danapa dosu darəŋ kɔ nkɔn, iyɛfɛ sɔ icəmɛ di darəŋ kɔ yuruya yɔn kɔ nkɔn encepər-ɛ danapa da doru o doru dɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ntɛ tendeŋərnɛ ti mɔ, ine wəran kam pəctolanɛ Səmayila: Indepocɛ kɔ pətɔt, indesɔŋ kɔ dokombəra dɔpɔŋ indesɔŋɛ yuruya yɔn yɛla endeyɔnɛ kas ka abɛ wəco kɔ mɛrəŋ kɔ wətem ka afum alarəm. ");
INSERT INTO bsp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mba ntɛ tɔyɔnɛ ta danapa dem mɔ, Sara oŋkom'am tɛm tantɛ dok.» ");
INSERT INTO bsp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ntɛ Kanu kəlip kəlok-lokər Abraham mɔ, kɔ Kanu kəmpɛ darenc. ");
INSERT INTO bsp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","K'Abraham ɛlɛk wan kɔn Səmayila kɔ afum aŋɛ anakom kəlɔ kɔn disrɛ mɔ fəp, kəbəp ka aŋɛ ɛnawayɛ pəsam pɔn mɔ, ti tɔ tatɔkɔ arkun a kəlɔ kɔn disrɛ fəp. K'ɛŋkənc ŋa dɔsɔk din dadɔkɔ, pəmɔ tɔkɔ Kanu kənaloku kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham ɛnasɔtɔ meren 99 a k'andekənc kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Wan kɔn Səmayila, ɛnasɔtɔ meren wəco kɔ maas a k'andekənc kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Dɔsɔk dadɔkɔ d'aŋkənc Abraham kɔ wan kɔn, Səmayila. ");
INSERT INTO bsp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","K'aŋkənc arkun aka kəlɔ kɔn disrɛ fəp, kəyɛfɛ acar aŋɛ anakom di mɔ haŋ akɔ ɛnawayɛ pəsam pɔn nnɔ acikəra ŋayi mɔ. K'aŋkənc ŋa fəp kɔ nkɔn Abraham. ");
INSERT INTO bsp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kɔ MARIKI owurər Abraham nde tofo ntɛ ŋkiri ya Mamre yɛnacəmɛ mɔ, tɛtəŋnɛ Abraham pəndɛ nde kusuŋka ka abal ŋɔn daŋ, tɛm ntɛ pəŋwonɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kɔ Abraham eyekti fɔr, k'ɛnəŋk arkun maas ŋacəmɛ ta ŋambɔlɛ kɔ-ɛ. Ntɛ ɛnəŋk ŋa mɔ, k'ewirnɛ kəkɔbəpɛnɛ kɔ ŋa, k'ontontnɛnɛ ŋa haŋ dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Kɔ Abraham oloku wəkin ŋa dacɔ: «Mariki, ilɛtsɛn'am intam kəsɔtər əm kəwosɛn'em kəcəmɛ ka nnɔna wacar kam ba? ");
INSERT INTO bsp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Pakɛrɛ nu oŋ domun depic nəbikɛnɛ wɛcək, nəŋesəm nnɔ kətɔk nkɛ dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Indesɔŋ nu sɔ peri, ntɛ tɔŋsɔŋɛ nu kəsɔtɔ sɔ fənɔntər mɔ, a nədekɔ tɛm tatɔkɔ nəfɔdecepər nnɔ nderem kifəli, iyi kiyi konu.» K'acikəra ŋaloku: «Tentesɛ! Məyɔ tɔkɔ məloku mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kɔ Abraham ɔŋkɔ katəna katəna abal ŋɔn disrɛ nde Sara eyi mɔ, k'oloku kɔ: «Məkufɛ məlɛk kəmbefe kətɔt tafala kəmaas məgbɛntɛ akaŋɛ cəcom.» ");
INSERT INTO bsp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","K'ɛyɛksɛ sɔ kəkɔ ka nde yɔcɔl yeyi mɔ, k'osumpər tana pɔtɔt dis nde yɔcɔl yɔn dacɔ, k'ɔsɔŋ pi wəcar kɔn wətɛmp wəkin kɔ wəkakɔ olompəs pi katəna katəna. ");
INSERT INTO bsp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kɔ Abraham ɛlɛk fulaya kɔ mɛsɛ ma wana kɔ sɛm ya tana tatɔkɔ analompəs mɔ, k'ɔŋkɔ pəcəmbərər yi acikəra ɔn. Kɔ nkɔn Abraham ɛncəmɛ ŋa kəsək kətɔk dəntɔf, k'acikəra ŋacdi yeri. ");
INSERT INTO bsp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ntɛ ŋalip kədi yeri mɔ, kɔ ŋayif Abraham: «Deke wəran kam Sara eyi-ɛ?» Kɔ Abraham oloku ŋa, «Eyi nde abal disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kɔ wəcikəra wəkin oloku: «Inder nnɔ ndaram dok tɛm tantɛ wəran kam Sara endekom wan wərkun.» Sara ɛnacəmɛ dəkusuŋka Abraham tadarəŋ pəccəŋkəl. ");
INSERT INTO bsp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham kɔ Sara ŋanasikər, ŋabɛk, Sara ɛnawurɛnɛ fɛ sɔ wətam kəsɔtɔ awut. ");
INSERT INTO bsp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kɔ Sara eselərnɛ pəcloku: «Ndɛkəl ntɛ isikər oŋ mɔ, pəbotu pendey'im sɔ ba? Mariki wos im sɔ, esikər.» ");
INSERT INTO bsp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kɔ MARIKI eyif Abraham «Ta ake tɔ Sara eselɛ-ɛ a pəcloku: ‹Mba kance kɔ, indetam kəsɔtɔ wan nnɔ isikər mɔ ba?› ");
INSERT INTO bsp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Tes teyi ntɛ tɛntambər MARIKI mɔ ba? Dok tɛm tantɛ imboncər əm mɔ, inder nnɔ ndaram, Sara endesɔtɔ wan wərkun.» ");
INSERT INTO bsp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kɔ Sara eyemɛ, k'ombupərɛ «Isel fɛ,» bawo ɛnanesɛ. Kɔ MARIKI ɔŋgbɔkərɛ: «Ala, məsel!» ");
INSERT INTO bsp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","K'afum aŋɛ ŋayɛfɛ kəkɔ, kɔ ŋamɔmən kəca ka Sodom. Kɔ Abraham ɛncəmbər ŋa kəkɔlembərnɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kɔ MARIKI eyifnɛ: «Imɛŋkər Abraham ntɛ ifaŋ kəyɔ mɔ ba? ");
INSERT INTO bsp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham endeyɔnɛ kas ka afum a atɔf ŋɔpɔŋ, ŋa fənɔntər. Afum a doru fəp tetɔn tɔ ŋandesɔtɔnɛ kəpocɛ pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Bawo inasom kɔ pəloku awut ɔn kɔ afum ɔn, a ŋacəmɛ dɔpɔ da ina MARIKI darəŋ, ŋacəmɛ pəlompu darəŋ kɔ sariyɛ ntɛ tɔŋsɔŋɛ ina Kanu ilasɛ Abraham dim ndɛ ɛnasɔŋ tetɔn mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kɔ MARIKI oloku Abraham: «Mes mmɛ amboncɛ Sodom kɔ Komora mɔ, mɛmbɛk kɔ kiciya ka mi kəyɔ wɛywɛy. ");
INSERT INTO bsp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kətor k'inder dəntɔf idemɔmən kɔ pəyɔnɛ a ntɛ aŋloku taŋan mɔ kance kɔ-ɛ, kɔ pəntɔyɔnɛ ti-ɛ, ina sɔ icərɛ ti.» ");
INSERT INTO bsp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kɔ acikəra aŋɛ ŋayɛfɛ tofo tatɔkɔ kɔ ŋantɛfərnɛ kəca ka Sodom. MARIKI pəsɔrɔyi kɔ Abraham. ");
INSERT INTO bsp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kɔ Abraham ɔlɔtərnɛ k'eyif Kanu: «Məndekɔtɔrsɛnɛ sɔ fum wəlompu pəmɔ wəlɛc ba? ");
INSERT INTO bsp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tɔlɔma afum atɔt wəco kəcamət (50) ŋayi afum aka dare dadɔkɔ dacɔ, məndekɔləsər sɔ dare dadɔkɔ ba? Məfɔtam kəŋaŋnɛnɛ ŋa teta afum alompu akaŋɛ wəco kəcamət (50) aŋɛ ŋayi ŋa dacɔ mɔ?» ");
INSERT INTO bsp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","«Tɔbɔl'am məna kəyɔ ka tantɛ! Məfɔdedifɛnɛ fum wəlompu kɔ wətɔlomp, tɛm tatɔkɔ wətɔdəkət pəsɔtɔ pəcuy pin payi kɔ wədəkət. Tɔbɔl'am məna nwɛ məyɔnɛ wəboc kiti ka doru fəp mɔ, məfɔdeyi ta məleləs sariyɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kɔ MARIKI oloku: «K'imbəp nde dare da Sodom disrɛ afum alompu wəco kəcamət-ɛ (50), iŋaŋnɛnɛ alpəs akɔ tetaŋan.» ");
INSERT INTO bsp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kɔ Abraham ɔŋgbɔkərɛ k'oloku: «Nəmɔmən ntɛ iyeŋk abəkəc kəlok-lokər Mariki Kanu mɔ, ina nwɛ iyɔnɛ kəbof ka dəntɔf kɔ ka dənɛnc dəm mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tɔlɔma afum alompu akaŋɛ wəco kəcamət (50) ŋandekɔbut afum kəcamət paləsər oŋ dare fəp ba?» Kɔ Kanu kəloku: «Ifɔləsər di k'imbəp di afum alompu wəco maŋkəlɛ kɔ kəcamət-ɛ (45).» ");
INSERT INTO bsp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kɔ Abraham ɛncəmɛ kɔ darəŋ kəloku kɔ toloku ntɛ: «Tɔlɔma alompu wəco maŋkəlɛ (40) ŋ'andekɔbəp di?» Kɔ Kanu kəloku: «Ifɔləsər, k'imbəp di alompu wəco maŋkəlɛ-ɛ (40).» ");
INSERT INTO bsp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kɔ Abraham oloku: «Ilɔktərn'am, Mariki Kanu! Ta pətɛl'am k'ilok-loku sɔ-ɛ! Tɔlɔma alompu wəco maas (30) ŋ'andekɔbəp di?» Kɔ Kanu kəloku Abraham: «Ifɔləsər di k'imbəp dɔtɔf afum alompu wəco maas-ɛ (30).» ");
INSERT INTO bsp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kɔ Abraham oloku: «Mariki Kanu, məŋaŋnɛnɛ mɔcɔp mem. Tɔlɔma alompu wəco mɛrəŋ (20) ŋ'andekɔbəp di?» Kɔ Kanu kəloku Abraham: «Ifɔləsər di teta afum akakɔ wəco mɛrəŋ (20).» ");
INSERT INTO bsp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kɔ Abraham oloku: «Ilɛtsɛn'am, Mariki mem! Ta pətɛl'am, tɛlpəs t'indelok-lokər əm. Tɔlɔma alompu wəco ŋayi di.» Kɔ Kanu kəloku sɔ Abraham, «Ifɔləsər di teta afum akakɔ wəco.» ");
INSERT INTO bsp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ntɛ ŋalip kəlok-loku mɔ, kɔ MARIKI ɔŋkɔ, kɔ Abraham olukus nde ndɔrɔn. ");
INSERT INTO bsp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Dec dɔrɔfɔy kɔ mɛlɛkɛ mmɛ mɛrəŋ mender Sodom. Lɔt pəndɛ dəkəbɛrɛ da dare. Ntɛ ɛnəŋk mi mɔ, k'ɛyɛfɛ kəkɔbəpɛnɛ kɔ mi, k'ontontnɛnɛ mi dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kɔ Lɔt oloku ŋa: «Ilɛtsɛnɛ nu, nəna mariki mem, nəder nnɔ kəlɔ ka wəcar konu. Nəcepərɛnɛ dɛ pibi, nəbikɛnɛ wɛcək, nədena nəyɛfɛ bətbətana suy, nəsumpər sɔ dɔpɔ donu, nəkɔ.» Kɔ mɛlɛkɛ moloku kɔ: «Ala, nnɔ tofo tantɛ tɔ səndecepərɛnɛ pibi!» ");
INSERT INTO bsp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mba kɔ Lɔt ɛncəmɛnɛ ŋa ti darəŋ haŋ kɔ ŋade ŋaləpsər kəkɔ nde ndɔrɔn. K'olompsɛ ŋa yeri yɔtɔt, k'ɛmpɛcɛ ŋa cəcom, kɔ ŋandi yeri. ");
INSERT INTO bsp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ta ŋantafəntərɛ-ɛ, k'afum a dare da Sodom ŋaŋkɛl kəlɔ, kəyɛfɛ awut haŋ abeki fəp faŋan ŋanayi di, ali fum anasak fɛ. ");
INSERT INTO bsp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kɔ ŋawe Lɔt kɔ ŋayif kɔ: «Deke afum akɔ ŋayi-ɛ, aŋɛ ŋambɛrɛ nnɔ ndaram nnɔ pibi pampɛ mɔ? Məwurɛnɛ ŋa nnɔ səyi mɔ, ntɛ tɔŋsɔŋɛ səfəntərər ŋa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kɔ Lɔt owur dəkusuŋka nnɔ ŋayi mɔ, k'ɛŋgbət kumba tadarəŋ tɔn. ");
INSERT INTO bsp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","K'oloku ŋa: «Ala, Anapa, Ilɛtsɛnɛ nu ta nəyɔ pəlɛc pampɛ! ");
INSERT INTO bsp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ilɛtsɛnɛ nu! Iyɔ ayecəra mɛrəŋ atɔcərɛ arkun, ilɛtsɛnɛ nu ikɛrɛ nu ŋa nnɔ dabaŋka, nəyɔ ŋa mɛfaŋ monu. Mba ta nəyɔ acikəra em ntɛ o ntɛ, bawo kəyi kem kɔ ŋayinɛ dɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","K'afum a Sodom ŋaloku kɔ: «Məbɔlɛ day! Məna wəcikəra məfaŋ kəbocər səna dɔpɔ ndɛ səndekɔt mɔ, kɔ məntɔwurɛnɛ ŋa-ɛ, tɔkɔ səndedeŋər məna mɔ tendecepər taŋan!» Kɔ ŋawɛn Lɔt pəpɔŋ kɔ ŋalɔtərnɛ kumba kəkɔləsər ki. ");
INSERT INTO bsp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kɔ mɛlɛkɛ mmɛ mɛrəŋ mosumpər Lɔt, kɔ mɛmbɛrsɛ kɔ, kɔ mɛŋgbət kumba. ");
INSERT INTO bsp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Afum akɔ ŋanayi dəkusuŋka mɔ, kɔ mɛlɛke mɔsɔŋ ŋa kətɔnəŋk, kəyɛfɛ wanfɛt haŋ wəbeki, kɔ tɛyamsɛ ŋa kənəŋk sɔ kumba. ");
INSERT INTO bsp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kɔ mɛlɛkɛ ŋayif Lɔt: «An'ɔ məyɔ sɔ nnɔ fum-ɛ? Arkun aŋɛ məsɔŋ aran mɔ, awut am arkun kɔ aran, kɔ afum am fəp, akɔ məyɔ dare dandɛ mɔ fəp, məwurɛnɛ ŋa nnɔ dare dandɛ. ");
INSERT INTO bsp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kələsər kɔ sənder tofo tantɛ, bawo MARIKI fɔr kiriŋ, ntɛ aŋlokɛ afum a dare dandɛ mɔ, tɛmbɛk. MARIKI osom su kədeləsər dare dandɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kɔ Lɔt ɔŋkɔ pəbəp arkun aŋɛ ŋananɛncɛ awut ɔn mɔ, k'oloku ŋa: «Nəkufɛ nəyɛfɛ dɛ! Bawo MARIKI endeder kələsər dare dandɛ.» Mba, kɔ arkun akaŋɛ ŋancɛm-cɛmnɛ a kəwoləs kɔ Lɔt ɛndɛ. ");
INSERT INTO bsp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pəndeyi dɔsɔka dɛləpəs kɔ mɛlɛkɛ ŋaloku Lɔt: «Məroknɛ məyɛfɛ dɛ, məlɛk wəran kam, kɔ awut am ayecəra aŋɛ ŋayi nnɔ mɔ, ta pəlɛc pedesɔtɔ ŋa kɔ dare dandɛ denciya mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mba Lɔt pəcwon, kɔ mɛlɛkɛ ŋasumpər ŋa waca, nkɔn kɔ wəran kɔn kɔ awut ɔn ayecəra mɛrəŋ, kɔ mɛlɛkɛ ŋawurɛnɛ ŋa dare disrɛ, bawo MARIKI ɛnafaŋ kəyac kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ntɛ mɛlɛkɛ ŋawurɛnɛ ŋa dare disrɛ mɔ, kɔ mɛlɛkɛ min moloku Lɔt: «Məyɛksɛ ntɛ tɔŋsɔŋɛ ta məfi mɔ! Ta məmɔmən tadarəŋ, ta məcəmbərəs tofo o tofo nnɔ aranta ŋaŋɛ! Məkɔ məndɛ məyacnɛ nde dətɔrɔ, ta mədefi.» ");
INSERT INTO bsp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kɔ Lɔt oloku ŋa: «Ala, mariki mem! Tɔfɔtam kəyi. ");
INSERT INTO bsp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ilɛtsɛn'am! Wəcar kam ɔsɔtər əm kəŋaŋnɛnɛ ntɛ məlas layidi dam nnɔ iyi mɔ, ntɛ məsak im kəyi doru mɔ, mba ifɔtam kəyɛksɛ ibəp tɔrɔ tatɔkɔ a məctorɛ pəlɛc, kɔ pəyi fɛ ti-ɛ ina sɔ, iŋfi. ");
INSERT INTO bsp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ilɛtsɛn'am məŋnəŋk dare dɔkɔ, dɔlɔtərn'em k'iyɛksɛ ibɛrɛ di kɔ dɛfɛtɛ sɔ. Məc'em ikɔ indɛ iyacnɛ di, dɛfɛtɛ fɛ ba? Intam di kəbɛrɛ, tɔsɔŋ'em kəyi doru!» ");
INSERT INTO bsp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kɔ mɛlɛkɛ moloku kɔ: «Awa, kətola kam kaŋkɛ disrɛ, ifɔləsər dare dadɔkɔ məŋle mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Awa, məroknɛ məkɔ, bawo ifɔtam kəyɔ tɔlɔm o tɔlɔm ta məntabɛrɛ di-ɛ.» Ti t'ɔsɔŋɛ ntɛ awenɛ dare dadɔkɔ Cohar mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Dec dɛncpɛ, a kɔ Lɔt ɛmbɛrɛ Cohar. ");
INSERT INTO bsp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kɔ MARIKI ɔntufər aka Sodom kɔ Komora kəyɛfɛ darenc, pərbəlɔ kɔ nɛnc, nyɛ MARIKI ɛncsak mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kɔ Kanu kələsər sədare fəp, kɔ aranta, kɔ afum kəbəp ka yopoŋ dəntɔf fəp. ");
INSERT INTO bsp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kɔ wəran ka Lɔt ɔmɔmən tadarəŋ, k'ɛntəŋklɛ k'ɔyɔnɛ tɛrəŋka ta mɛr. ");
INSERT INTO bsp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kɔ Abraham ɛyɛfɛ bətbət suy, k'ɔŋkɔ nde tofo tɔkɔ ŋanacəmɛ kɔ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kɔ Abraham ɔmɔmən kəca ka Sodom kɔ Komora, k'ɔmɔmən sədare sa aranta fəp, k'ɛnəŋk kinimɛ kəcpɛ pəmɔ ntɛ kinimɛ kəpɔŋ kənde kəcpɛ daranta mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ntɛ Kanu kəncləsər sədare sa aranta ŋaŋɔkɔ mɔ, kɔ Kanu kəncɛm-cɛmnɛ Abraham, kɔ kəyac Lɔt pəlɛc ntɛ kəncləsər sədare nsɛ Lɔt ɛnandɛ pəyacnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kɔ Lɔt ɛyɛfɛ Cohar k'awut ɔn aran mɛrəŋ kəpɛ kəkɔndɛ dətɔrɔ, bawo ɛnanesɛ kəndɛ ka Cohar. K'ɔŋkɔ pəyi kumbuŋkum ka tɔrɔ tɔlɔma disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kɔ wan wəran wəcɔkɔ-cɔkɔ wəka Lɔt oloku wəlpəs: «Papa kosu ɔyɔnɛ wətem, fum eyi fɛ dɔtɔf nwɛ endeder su mɔ, pəmɔ ntɛ mes mosu mokur moloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Məder səsɔŋɛ kɔ kəmun member ntɛ tɔŋsɔŋɛ pəfəntərər su, tɔŋsɔŋɛ səsɔtɔnɛ kɔ yuruya mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kɔ ŋasɔŋɛ kas kəŋan kəmun member pibi papɔkɔ. Kɔ wan kɔn wəran wəcɔkɔ-cɔkɔ ɔŋkɔ pəfəntərɛ kɔ kas. Mba Lɔt ɛnacərɛnɛ fɛ kəbɛrɛ kɔ kəwur ka wan kɔn. ");
INSERT INTO bsp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Dɔckɔsɔk k'oloku wəfɛtəra kɔn: «Ifəntərɛna nnɔ pibi kɔ papa. Pasɔŋɛ kɔ sɔ kəmun member nnɔ pibi, ntɛ tɔŋsɔŋɛ məna sɔ nəkɔ nəfəntərɛ kɔ nkɔn mɔ tɔsɔŋɛ pasɔtɔnɛ kɔ yuruya mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Pəndesɔbiyɛ kɔ awut ɔn aran ŋasɔŋ kɔ sɔ member. Pibi papɔkɔ kɔ wan kɔn wəran wəfɛt wəkɔ ɔŋkɔ pəbɛrər papa kəŋan Lɔt, kɔ ŋafəntərɛ. Kas kəŋan ɛnacərɛnɛ fɛ kəbɛrɛ kɔ kəwur ka wəkakɔ sɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kɔ awut aran a Lɔt aŋɛ mɛrəŋ fəp ŋambɛksɛ Lɔt kas kəŋan. ");
INSERT INTO bsp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kɔ wan wəran wəka Lɔt wəcɔkɔ-cɔkɔ oŋkom wan wərkun, k'ewe kɔ Mohab. Nkɔn ɔyɔnɛ papa ka aMohab, ŋayi doru haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kɔ wan ka Lɔt wəran wəfɛt oŋkom wan wərkun, k'ewe kɔ «Ben Ami.» Nkɔn ɔyɔnɛ papa ka aka Amɔŋ ŋayi doru haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kɔ Abraham ɛyɛfɛ di kəkɔ ka atɔf ŋa Nɛkɛf. K'ɛndɛ Kadɛs kɔ Sur dacɔ, k'ɛyɛfɛ sɔ k'encepərɛnɛ tɛm Kerar. ");
INSERT INTO bsp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham oncloku afum aka di teta wəran kɔn Sara: «Wəkirɛ kem ɔfɔ.» Kɔ Abimɛlɛk, wəbɛ wəka Kerar, ɛmbaŋ Sara. ");
INSERT INTO bsp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Awa, kɔ Kanu kənder Abimɛlɛk dəmere ma pibi kɔ kəloku kɔ: «Kəfi kɔ mənder teta wəran wəkɔ məsumpər mɔ, bawo wəran wəlɔ ɔfɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimɛlɛk nwɛ ɛnatɔgbuŋɛnɛ wəran nwɛ mɔ, k'eyif: «Mariki mem, cəke cɔ pəyi-ɛ, kədif kɔ mənder atɔf ŋin ali ŋayɔnɛ afum alompu? ");
INSERT INTO bsp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nkɔn Abraham yati olok'im: ‹Wəkirɛ kem ɔfɔ,› kɔ wəran yati nkɔn sɔ oloku: ‹Wɛnc im wərkun ɔfɔ?› Abəkəc ŋosoku ŋ'inayɔ, ali pəlɛc iyɔ fɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kɔ Kanu kəloku kɔ dəmere: «Incərɛ belbel ina sɔ, a abəkəc ŋosoku ŋɔ mənayɔ ntɛ məcyɔ tantɛ mɔ. Ina yati in'ɛyaməs am kədəktər im, ti t'inatɔwos'am a məgbuŋɛnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ndɛkəl, məluksɛ wəran wəkawɛ wos. Bawo sayibɛ sa Kanu s'ɔyɔnɛ, endetolan'am məyi doru. Kɔ məntɔluksɛ kɔ-ɛ, məcərɛ a kəfi kɔ mənder kɔ ca yɔkɔ məyɔ mɔ fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kɔ Abimɛlɛk ɛyɛfɛ bətbət suy, k'ewe acar ɔn fəp. K'ɔlɔmər ŋa mere mamɔkɔ fəp. Kɔ kənesɛ kəpɔŋ kəsumpər afum akakɔ. ");
INSERT INTO bsp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kɔ Abimɛlɛk ewe Abraham k'eyif kɔ: «Cəke cɔ məyɔ su tantɛ-ɛ? Kɔ kiciya kəre k'inciy'am-ɛ, ntɛ məsɔŋɛ su, ina k'atɔf ŋem kəciya pəpɔŋ mɔ? Məy'em mɔyɔ mmɛ pəntɔmar məy'em mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kɔ Abimɛlɛk eyif Abraham: «Cəke cɔ mənafaŋ ntɛ məyɔ tantɛ mɔ?» ");
INSERT INTO bsp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kɔ Abraham oloku: «Inacɛm-cɛmnɛ a kənesɛ Kanu kəyi fɛ nnɔ, a andedif im teta wəran kem. ");
INSERT INTO bsp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ntɛ tendeŋərnɛ ti mɔ, kance kɔ, a wəkirɛ kem ɔfɔ. Kas kin kɔ səmpaŋnɛ, səyerɛnɛ cɛrɛ. K'ender sɔ k'ɔyɔnɛ wəran kem. ");
INSERT INTO bsp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ntɛ Kanu kəsɔŋ'em kəyɛfɛ kəlɔ ka papa wəkem mɔ, ti t'inaloku Sara: ‹Məlɛk'em layidi kəca nkɛ o nkɛ səŋkɔ mɔ, mədekɔ məcloku a wɛnc əm wərkun iyɔnɛ.›» ");
INSERT INTO bsp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kɔ Abimɛlɛk ɛlɛk cir, ŋkesiya, cəna kɔ acar arkun kɔ aran k'ɔsɔŋ Abraham k'oluksɛ kɔ wəran kɔn Sara. ");
INSERT INTO bsp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kɔ Abimɛlɛk oloku: «Atɔf ŋem ŋɔ ŋaŋɛ nnɔ fɔr yam kiriŋ, məndɛ nnɔ pəndebɔt əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","K'oloku Sara: «Isɔŋ wɛnc əm wərkun mɛncəmbəl ma gbeti wul win, bɔyɔn'am aca nnɔ afum ŋayi mɔ, kəmentər a məncərɛ fɛ tɔlɔm o tɔlɔm tes tantɛ disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kɔ Abraham ontola Kanu, kɔ Kanu kəntaməs Abimɛlɛk, wəran kɔn kɔ acar ɔn, kɔ ŋantam kəkom, ");
INSERT INTO bsp_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","bawo MARIKI ɛnasumpər aka kəlɔ ka Abimɛlɛk fəp dokombəra teta wəran ka Abraham, Sara. ");
INSERT INTO bsp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Kɔ MARIKI ɛmbaŋ Sara pəmɔ tɔkɔ ɛnaloku ti mɔ, kɔ MARIKI ɛlasɛ kɔ dim dɔkɔ ɛnasɔŋ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kɔ Sara ɛmbɛkəs, k'oŋkomɛ Abraham wan wərkun detem dɔn disrɛ, tɛm tatɔkɔ Kanu kənaboncər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kɔ Abraham ewe wan wərkun nwɛ Sara oŋkomɛ kɔ mɔ «Siyaka.» ");
INSERT INTO bsp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kɔ Abraham ɛŋkənc Siyaka wan kɔn wərkun nwɛ tataka ta camət-maas tɔn, pəmɔ tɔkɔ Kanu kənasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham ɛnasɔtɔ meren tasar tin (100), ntɛ anckom wan kɔn Siyaka mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kɔ Sara oloku: «Kanu kəsɔŋ'em kəselsər. Nwɛ o nwɛ ene kəkom kem Siyaka mɔ, tɔŋyɔ kɔ mesel.» ");
INSERT INTO bsp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","K'endeŋər: «An'ɛnatam kəsɔŋɛ Abraham kəlaŋ a Sara endemɛsər awut-ɛ? Mba iŋkomɛ kɔ wan wərkun detem dɔn disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kɔ wan ɛmbɛk k'awurɛ kɔ mɛsɛ. Kɔ Abraham omboc kəsata kəpɔŋ dɔsɔk ndɛ awurɛ Siyaka mɛsɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kɔ Sara ɛnəŋk wan wərkun, nwɛ wəran wəMisira Hakar ɛnakomɛ Abraham mɔ, pəcsel. ");
INSERT INTO bsp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kɔ Sara oloku Abraham: «Məbɛləs wan wəran wəcar nwɛ kɔ wan kɔn wərkun. Bawo wan ka wəcar wəkawɛ ŋafɔdepaŋnɛ kɛ kɔ wan kem.» ");
INSERT INTO bsp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kɔ toloku tatɔkɔ tɛntɛlɛ Abraham belbel teta wan kɔn. ");
INSERT INTO bsp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mba kɔ Kanu kəloku Abraham: «Ta tɛtɛl'am teta wan kam wərkun kɔ kɛrɛ, wəcar kam. Məwosɛnɛ Sara ntɛ o ntɛ ɛŋfaŋər əm mɔ. Bawo nnɔ Siyaka eyi mɔ, məndesɔtɔ yuruya nyɛ yendetɔmpər tewe tam mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Indeyɔnɛ sɔ wan ka wəcar kam atɔf. Bawo nkɔn sɔ yuruya yam y'ɔyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kɔ Abraham ɛyɛfɛ bətbət suy, k'ɛlɛk kəcom, k'ɛlas apampɛ domun k'ɔsɔŋ Hakar, k'ɛndəndəsər kɔ wan, k'ɛmbɛləs ŋa. Kɔ Hakar ɔŋkɔ pəyi Tɛgbərɛ ta Bersaba. ");
INSERT INTO bsp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ntɛ apampɛ ŋelip domun mɔ, kɔ Hakar ɛsak wan tɔtɔk dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","K'ɛŋkafələr k'ɔŋkɔ pəndɛ kəsək pəccɔpəsnɛ: «Ifaŋ fɛ kəgbətnɛ wan kem pəcfi.» K'ɔŋkɔ pəndɛ pəbɔlɛnɛ kɔ dobolu da kələm ka ambəncəran katin pətɛfərnɛ kɔ, pəcbok. ");
INSERT INTO bsp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kɔ Kanu kəne wan dim, kɔ mɛlɛkɛ ma Kanu mewe Hakar darenc kɔ meyif kɔ: «Ake'ntɔrs'əm-ɛ Hakar? Ta mənesɛ! Bawo Kanu kəne wan kam dim nde eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Məyɛfɛ məlɛk wan, məsumpər kɔ waca mɛrəŋ, bawo afum alarəm ŋ'indesɔŋ kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kɔ Kanu kəmepi Hakar fɔr k'ɛnəŋk kələmp. K'ɔŋkɔ pəlas apampɛ domun, k'ɔsɔŋ wan k'omun. ");
INSERT INTO bsp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kɔ Kanu kəmbum wan nwɛ ɛncbɛk, pəyi dətɛgbərɛ mɔ, k'ende pəyɔnɛ wəpɛnɛ mbəncəran. ");
INSERT INTO bsp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kɔ Səmayila ɛmbɛk dəndo tɛgbərɛ ta Paran, kɔ kɛrɛ ɛntɛnɛ kɔ wəran wəMisira. ");
INSERT INTO bsp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tɛm tatɔkɔ, Abimɛlɛk ŋasol kɔ Pikɔl, wəbɛ wəka asɔdar ɔn, k'ende pəloku Abraham: «Kanu kəsol am mes mmɛ məŋyɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Mədɛrəm'em oŋ ma nnɔ, məckornɛ Kanu a məfɔdetiŋkər im, awut em, kɔ awut-sɔ em, mədɛrəm em sɔ a məndetɔmpər em kɔ atɔf nŋɛ məyi mɔ abəkəc ŋosoku, pəmɔ tɔkɔ iyɔn'am mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kɔ Abraham oloku: «Indɛrəm am ti.» ");
INSERT INTO bsp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mba kɔ Abraham ɛnal Abimɛlɛk teta kələmp nkɛ acar a Abimɛlɛk ŋanabaŋɛ fənɔntər mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kɔ Abimɛlɛk oloku: «Incərɛ fɛ nwɛ ɛnayɔ tɔyɔ tatɔkɔ mɔ: Mənasɔŋɛ f'em ti kəcərɛ, mɔkɔ məndesɔŋ'em oŋ ti kəcərɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kɔ Abraham ɛlɛk ŋkesiya, cir kɔ cəna, k'ɔsɔŋ yi Abimɛlɛk. Kɔ ŋaluksərnɛ kɔ ŋasek danapa mɛrəŋ maŋan. ");
INSERT INTO bsp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Kɔ Abraham ɛncəmbər kəsək cir cəyecəra camət-mɛrəŋ ca yɔcɔl yɔn. ");
INSERT INTO bsp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kɔ Abimɛlɛk eyif Abraham: «Ŋkesiya yɛran camət-mɛrəŋ ya ake yɔ məncəmbər kəsək-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","K'Abraham oloku Abimɛlɛk: «Məwosɛ kəbaŋ ŋkesiya yɛran camət-mɛrəŋ yayɛ tɔyɔnɛ kətəŋnɛ kosu tes a in'ɛnakay kələmp kaŋkɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ti tɔ awenɛ tofo tatɔkɔ «Bersaba», bawo dəndo kəfo kaŋkɔ kɔ ŋanadɛrmɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kɔ ŋantəŋnɛ kəsek danapa dəndo Bersaba. Kɔ tɛyɛfɛ dənda, Abimɛlɛk kɔ Pikɔl wəbɛ ka asɔdar ɔn ŋayɛfɛ, kɔ ŋalukus atɔf ŋa aFilisti. ");
INSERT INTO bsp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kɔ Abraham ɔmbɔf abet Bersaba, k'oŋkornɛ MARIKI nwɛ ɔntɔlip doru o doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","K'Abraham encepərɛnɛ tɛm tobolu atɔf ŋa aFilisti. ");
INSERT INTO bsp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ntɛ mes mmɛ mencepər mɔ, kɔ Kanu kəmbocər Abraham dɔpɔ, kɔ kəwe kɔ: «Abraham!» K'owosɛnɛ ki: «In'ɛwɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kɔ Kanu kəloku: «Məlɛk oŋ wan kam sona Siyaka, wəkakɔ məmbɔtər mɔ. Məkɔ atɔf ŋa Moriya dəndo, məkɔ məloŋnɛn'em wan kam kəloŋnɛ ka kəcɔf nde tɔrɔ mpɛ indekɔmentər əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kɔ Abraham ɛyɛfɛ bətbət suy k'ɛŋgbɛk sɔfale sɔn kəbənda, k'ɛlɛkɛnɛ acar ɔn atɛmp mɛrəŋ kɔ wan kɔn Siyaka. Kɔ Abraham ɛŋgbɛs tɔk nyɛ ɛnakɔcɔfɛ Kanu poloŋnɛ mɔ, k'ɛntas nde kəfo kəŋkɔ Kanu kənamentər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tataka ta maas, kɔ Abraham eyekti kəro k'ɛnəŋk kəfo kaŋkɔ pəbɔlɛ. ");
INSERT INTO bsp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","K'oloku atɛmp ɔn: «Nəyi nnɔ kɔ sɔfale. Siyaka k'ina, kəpɛ kɔ sənder nde kəroŋ kəkɔtontnɛnɛ Kanu. Kɔ səlip-ɛ, səndebəp nu nnɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kɔ Abraham ɛlɛk tɔk nyɛ anakɔcɔfɛ Kanu poloŋnɛ mɔ, k'ɛsarsər yi wan kɔn Siyaka, kɔ nkɔn ɛlɛk nɛnc kɔ faka. Kɔ ŋasol mɛrəŋ maŋan kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Kɔ Siyaka ewe kas Abraham k'eyif kɔ: «Papa!» Kɔ wəkakɔ owosɛ: «In'ɛwɛ, wan kem!» Kɔ Siyaka oloku: «Nɛnc dɔ dandɛ kɔ tɔk, mba deke teŋkesiya tɔkɔ aŋkɔloŋnɛ Kanu pacɔf mɔ peyi-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kɔ Abraham oloku: «Wan kem, Kanu ki sərka kəŋkɔsɔtɔ teŋkesiya ntɛ aŋkɔcɔfɛ kɔ poloŋnɛ mɔ.» Kɔ ŋasol mɛrəŋ maŋan sɔ kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ntɛ ŋambəp kəfo nkɛ Kanu kənamentər kɔ mɔ, kɔ Abraham ɛncəmbər tetek toloŋnɛ Kanu, k'omboc tɔk. K'oŋkot wan kɔn Siyaka, k'edeŋər kɔ tɔk ya kəloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kɔ Abraham ɛntɛnc kəca k'ɛlɛk faka kəkɔfay wan kɔn amera. ");
INSERT INTO bsp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kɔ mɛlɛkɛ ma MARIKI mewe kɔ darenc. Kɔ moloku: «Abraham! Abraham!» K'owosɛ: «In'ɛwɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kɔ mɛlɛkɛ moloku: «Ta mədeŋər wan kam kəca, ta məyɔ kɔ tes o tes, bawo incərɛ oŋ ndɛkəl a məŋnesɛ Kanu, ntɛ məntɔfatɛn'em wan kam mɔ, wan kam sona.» ");
INSERT INTO bsp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kɔ Abraham eyekti fɔr k'ɛnəŋknɛ tadarəŋ aŋkesiya ŋorkun lɛn ya ŋi yɛpətsərnɛ dɛrəntəm. Kɔ Abraham ɔŋkɔ pəlɛk aŋkesiya nŋɛ k'ɛsəkpərɛ ŋi wan kɔn, k'oloŋnɛ ŋi Kanu k'ɔncɔf, k'ɛsak wan kɔn. ");
INSERT INTO bsp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kɔ Abraham ɔsɔŋ tofo tatɔkɔ tewe ta «MARIKI ɛŋnəŋk.» Ti tɔ aŋlokɛ mɔkɔ: «Nde tɔrɔ ta MARIKI kəroŋ, andekɔnəŋk kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kɔ mɛlɛkɛ ma MARIKI mɔŋgbɔkərɛ sɔ kəwe Abraham darenc, ");
INSERT INTO bsp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","kɔ moloku: «Toloku ta MARIKI indɛrəm'am ti, ina sərka! ‹Bawo məyɔ tantɛ, məfatɛnɛ f'em wan kam sona Siyaka, ");
INSERT INTO bsp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","indelas əm kəpocɛ pətɔt, indesɔŋɛ afum am ŋala pəmɔ cɔs ca darenc kɔ asənc ŋa kəba kəsək. Yuruya yam yendetasərnɛ aterɛnɛ aŋan. ");
INSERT INTO bsp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Afum a doru fəp ŋandesɔtɔ kəpocɛ pətɔt teta yuruya yam, bawo məncəŋkəl dim dem.›» ");
INSERT INTO bsp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kɔ Abraham oluksərnɛ nde atɛmp ɔn ŋanckar kɔ mɔ, kɔ ŋayɛfɛ kɔ ŋasol fəp faŋan kəkɔ Berseba, bawo Abraham Berseba ɛnandɛ. ");
INSERT INTO bsp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ntɛ mes mamɔkɔ mencepər mɔ, k'ande paloku Abraham ntɛ: Milka oŋkomɛ sɔ wɛnc Nahor awut arkun: ");
INSERT INTO bsp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Huc wan kɔn wəcɔkɔ-cɔkɔ, Bus wɛnc wərkun, Kemuyel papa ka Aram, ");
INSERT INTO bsp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haso, Pildas, Yidlaf kɔ Betuhɛl. ");
INSERT INTO bsp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Kɔ Betuhɛl oŋkom Rebeka. Awut arkun akaŋɛ camət-maas ŋɔ Milka ɛnakomɛ Nahor, wɛnc ka Abraham. ");
INSERT INTO bsp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kɔ wəlak'ɔn Rehuma, nkɔn sɔ ɛnakomɛ kɔ awut: Tebah, Kaham, Tahas, kɔ Mahaka. ");
INSERT INTO bsp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Kəwon ka Sara doru kənasɔtɔ meren tasar tin wəco mɛrəŋ kɔ camət-mɛrəŋ (127), meren mamɔkɔ mɔ Sara ɛnasɔtɔ doru. ");
INSERT INTO bsp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara ɛnafi nde dare da Kiriyat-Arba, ti tɔ tatɔkɔ Hebərɔŋ atɔf ŋa Kanaŋ. Kɔ Abraham ender kətəŋnɛ kəwup ka Sara, pəbok kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kɔ Abraham ɛyɛfɛ pəsak wəran kɔn wəfi, k'oloku aHewy moloku mmɛ: ");
INSERT INTO bsp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Wəcikəra iyɔnɛ, wəcepərɛnɛ tɛm nnɔ ndoronu, nəpoc em tofo towupɛnɛ nnɔ ndoronu, intam kəwup wəran kem, ibɔlɛn'em kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kɔ aHewy ŋaloku Abraham: ");
INSERT INTO bsp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Məcəŋkəl su, mariki! Fum wəpɔŋ wəka Kanu məyɔnɛ su dacɔ. Məmɔmən kəfo nkɛ kəmbɔt əm mɔ, məwup wəran kam dəkəwupɛnɛ dosu dacɔ. Ali fum ɔfɔdefatɛnɛ dəkəwupɛnɛ dɔn kəwup ka wəran kam.» ");
INSERT INTO bsp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kɔ Abraham ɛyɛfɛ k'ontontnɛnɛ afum a dɔtɔf, aHewy fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Kɔ Abraham oloku ŋa ntɛ: «Kɔ nəwosɛ a iwup wəran kem nnɔ ibɔlɛn'em kɔ-ɛ, nəcəŋkəl im, nəluksɛ tɛfaŋ tem Hɛfəroŋ, wan ka Cohar. ");
INSERT INTO bsp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","A pəsak em kumbuŋkum ka Makpela nkɛ kəyɔnɛ kɔn mɔ, nde dalɛ dəkusu. Pəwayər im di gbeti mbɛ bɛntam kəsɔtɔ di mɔ, ntɛ tɔŋsɔŋɛ pəyɔnɛ di dəkəwupɛnɛ dem nəna dacɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hɛfəroŋ ɛnandɛ aHewy dacɔ. Kɔ Hɛfəroŋ wəHewy oloku Abraham aHewy fɔr kiriŋ kɔ aŋɛ ŋancbɛrɛ dare daŋan dəkusuŋka mɔ: ");
INSERT INTO bsp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Ala, mariki mem. Məcəŋkəl im! Isɔŋ əm dalɛ, k'isɔŋ əm sɔ kumbuŋkum kəŋkɔ kəyi di mɔ. Isɔŋ əm ki, fɔr ya awut a atɔf ŋem kiriŋ. Məwup di wəran kam.» ");
INSERT INTO bsp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kɔ Abraham ontontnɛnɛ afum aka dɔtɔf. ");
INSERT INTO bsp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","K'oloku ntɛ Hɛfəroŋ, fɔr ya afum a dɔtɔf kiriŋ: «Məna sɔ məkafəlɛ məcəŋkəl im! Iŋsɔŋ kəway ka dalɛ! Məwosɛn'em ti, a idewup di wəran kem.» ");
INSERT INTO bsp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kɔ Hɛfəroŋ oloku Abraham: ");
INSERT INTO bsp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Mariki mem, məcəŋkəl im! Antɔf ŋa gbeti mɛncəmbəl masar maŋkəlɛ (400), ake babɔkɔ bɔyɔnɛ ina kɔ məna dacɔ-ɛ? Məwup di wəran kam!» ");
INSERT INTO bsp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ntɛ Abraham ene moloku ma Hɛfəroŋ mɔ, k'ɔsɔŋ kɔ gbeti mbɛ ɛnabonc mɔ, gbeti mɛncəmbəl masar maŋkəlɛ (400), fɔr ya aHewy kiriŋ. Gbeti mɛncəmbəl masar maŋkəlɛ (400) babɔkɔ, bɛnayɔnɛ hakɛ ŋa kəway ka antɔf ŋaŋɔkɔ tɛm tatɔkɔ nnɔ acaməs ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kɔ tɔyɔnɛ oŋ dalɛ da Hɛfəroŋ ndɛ deyi Makpela, pətɛfərɛnɛ di kɔ Mamre mɔ, kəyɛfɛ dalɛ kəkɔ kumbuŋkum haŋ tɔk nyɛ yɛnacəmɛ dəkələncər mɔ fəp, ");
INSERT INTO bsp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kɔ yɔyɔnɛ oŋ ya Abraham fɔr ya aHewy kiriŋ kɔ akɔ ŋancbɛrɛ dare dadɔkɔ dəkusuŋka mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ntɛ tencepər mɔ, kɔ Abraham owup wəran kɔn Sara nde kumbuŋkum ka dalɛ da Makpela, nde pəntɛfərɛnɛ kɔ Mamre mɔ, ti tɔ tatɔkɔ Hebərɔŋ atɔf ŋa Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Dalɛ kɔ kumbuŋkum nkɛ kənayi di mɔ, kɔ pəyɔnɛ di oŋ dəkəwupɛnɛ da Abraham ndɛ ɛnaway fɔr ya aHewy kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham ɛnasikər, meren mɔn mɛnabɔlɛ kətɛnc, MARIKI ɛnapocɛ kɔ pətɔt fəp. ");
INSERT INTO bsp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kɔ Abraham oloku wəcar kɔn nwɛ ɛnanaŋkanɛ kəwon nnɔ ndɔrɔn mɔ, nwɛ onclompsɛ kɔ ca yɔn mɔ: «Mədeŋ kəca kam aləŋk ŋem tantɔf, ");
INSERT INTO bsp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Indesɔŋ'am kədɛrəm MARIKI, Kanu nkɛ kəyi darenc kɔ dəntɔf mɔ, ta məlɛkɛ wan kem wəran wəKanaŋ, afum akaŋɛ indɛ dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mba məde məkɔ atɔf ŋem nde dəŋkom dem, məlɛkɛ di wan kem Siyaka wəran.» ");
INSERT INTO bsp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kɔ wəcar kɔn oloku kɔ: «Tɔlɔma ta wəran ɔŋkɔwosɛ kəcɛps'em darəŋ kəder ka nnɔ-ɛ, tɛm tatɔkɔ iluksɛ wan kam atɔf nŋɛ məyɛfɛ mɔ ba?» ");
INSERT INTO bsp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kɔ Abraham oloku: «Məkɛmbərnɛ a məluksɛ wan kem dəndo de! ");
INSERT INTO bsp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","MARIKI, Kanu nkɛ kəyi darenc mɔ, nkɛ kəsɔŋ'em kəsak afum em kɔ dəŋkom dem mɔ, nkɛ kəlok-lokər im a kədɛrm'em kəsɔŋ ka atɔf ŋaŋɛ yuruya yem mɔ, nkɔn sərka endesom mɛlɛkɛ mɛcəm'am fɔr kiriŋ, dəndo məndekɔlɛkɛ wan kem wəran mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kɔ wəran ɔntɔkɔwosɛ kəcəm'am darəŋ-ɛ, iŋaŋnɛn'am kədɛrəm nkɛ isɔŋ'am kədɛrəm mɔ. Mba ta məluksɛ wan kem dəndo de!» ");
INSERT INTO bsp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kɔ wəcar endeŋ kəca mariki mɔn Abraham aləŋk tantɔf, k'ɛndɛrmɛ kɔ teta moloku mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kɔ wəcar ɛlɛk yɔkɔmɛ wəco yɔkɔmɛ ya mariki mɔn dacɔ, k'ɔŋkɔ. Tɛnatəŋnɛ pətɔmpər daka da wəbɛ kɔn dɔtɔt fəp. ");
INSERT INTO bsp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ntɛ ɛmbɛrɛ Mesopotami nde dare da Nahor mɔ, k'ɛncəp yɔkɔmɛ suwu dare kəsək ta ɔmbɔlɛ kələmp ka domun-ɛ, dec dɔrɔfɔy tɛm tɔkɔ aran ŋaŋwur kəkɔkɛt domun mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","K'ontola: «Məna MARIKI, Kanu ka Abraham mariki mem, məmar im kənəŋk ka paka mpɛ intɛn mɔ, ilɛtsɛn'am. Kɔ məyɔ ti-ɛ, məlasɛ mariki mem Abraham layidi dɔkɔ mənasɔŋ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","In'ɛwɛ incəmɛ nnɔ kələmp kəsək mɔ, k'ayecəra a afum a dare ŋawur kədekɛt domun-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Pəyɔnɛ a wəyecəra nwɛ indeloku: ‹Ilɛtsɛn'am məti tɔbɔl tam imun,› a wəkayi pəlok'im: ‹Məmun, isɔŋ sɔ yɔkɔmɛ yam yomun,› pəyɔnɛ a wəkakɔ məmpocɛ wəcar kam Siyaka! Tɛm tatɔkɔ indecərɛ a məlasɛ mariki mem Abraham layidi dɔkɔ mənasɔŋ kɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ɛnalip fɛ moloku, kɔ Rebeka wan ka Betuhɛl, wan sɔ ka Milka kɔ Nahor wɛnc ka Abraham oŋwur pəgbaŋnɛ tɔbɔl tɔn. ");
INSERT INTO bsp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Wəyecəra wətɔt teyi ɛnayi, ta ɛntacərɛ wərkun-ɛ, ali wərkun wəkin ɛnacərɛ fɛ kɔ dɛran. K'ontor dəkələmp k'ɛlas tɔbɔl tɔn k'ɛmpɛ. ");
INSERT INTO bsp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kɔ wəcar ɛyɛksɛ kəkɔfaynɛ kɔ, k'oloku kɔ: «Məpoc em domun depic da tɔbɔl tam, ilɛtsɛn'am.» ");
INSERT INTO bsp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kɔ Rebeka oloku: «Məmun, mariki mem!» K'ɛmbɛlkər kətinɛ kɔ tɔbɔl tɔn, k'ɔsɔŋ kɔ domun, k'omun. ");
INSERT INTO bsp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ntɛ elip kəsɔŋ wəcar ka Abraham k'omun mɔ, k'oloku kɔ sɔ: «Indekɛtɛ yɔkɔmɛ yam domun yi sɔ yomun haŋ pətəŋnɛ yi.» ");
INSERT INTO bsp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","K'ɛmbɛlkər kəneŋkəli domun dɛləpəs dəkəsamp, k'ɛyɛksɛ sɔ kəkɔkɛt domun dɔlɔma dəkələmp, k'ɛŋkɛtɛ yɔkɔmɛ fəp domun. ");
INSERT INTO bsp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kɔ wəcar ka Abraham eyifnɛ teta wəyecəra nwɛ dɛbəkəc, kɔ pəyɔnɛ a MARIKI eyi kəlompsɛ kɔ pɔkɔt pɔn-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ntɛ yɔkɔmɛ yelip kəmun mɔ, kɔ wərkun nwɛ ɛlɛk kurundɛ ka kɛma ka tɛncəmbəl dacɔ, kɔ cəsora ca dəkəca mɛrəŋ ca kɛma ka mɛncəmbəl wəco, kəsora kin o kin k'ɔsɔŋ Rebeka. ");
INSERT INTO bsp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kɔ wərkun nwɛ eyif Rebeka: «An'okom əm-ɛ wəyecəra? Məlok'im ti ilɛtsɛn'am. Səntam kəsɔtɔ kəfo dəkəcepərɛnɛ pibi, nde kəlɔ ka papa kam?» ");
INSERT INTO bsp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kɔ Rebeka oloku: «Wan ka Betuhɛl iyɔnɛ, nwɛ Milka ɛnakomɛ Nahor mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","K'endeŋər: «Mɛmpəlɛ kɔ yika yɛlarəm yeyi nnɔ ndorosu kɔ tofo tecepərɛnɛ pibi teyi sɔ di.» ");
INSERT INTO bsp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kɔ wərkun nwɛ ontontnɛnɛ MARIKI, ");
INSERT INTO bsp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","pəcloku: «Iŋkor-kor'əm məna MARIKI, Kanu ka mariki mem Abraham. Məna nwɛ məntɔsak kəlas layidi ndɛ mənasɔŋ kɔ mɔ, məcyɔnɛ mariki mem mɛfaŋ mɔn fəp mɔ! MARIKI məsol'em kɔ məŋkɛr'em haŋ nnɔ kəlɔ ka awɛnc a mariki mem Abraham.» ");
INSERT INTO bsp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kɔ wəyecəra ɛyɛksɛ k'ɔŋkɔ pəlɔmər mes mamɔkɔ fəp kɛrɛ nde ndɔrɔn. ");
INSERT INTO bsp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka ɛnayɔ wɛnc wərkun pacwe kɔ Labaŋ. Kɔ wəkakɔ ɛyɛksɛ kəkɔmɔmən wərkun nwɛ, nde dəkələmp. ");
INSERT INTO bsp_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labaŋ ɛnanəŋkɛ Rebeka kurundɛ kɔ cəsora dəwaca, k'ɛnanenɛ kɔ pəcloku: «Ti tɔ wərkun wəkakɔ olok-lokər əm.» Kɔ wɛnc wərkun wəka Rebeka ender nda wərkun nwɛ, ɛnayi kələmp kəsək kɔ yɔkɔmɛ yɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kɔ Labaŋ oloku: «Məder məna nwɛ MARIKI ompocɛ mɔ! Ta ake tɔ məndeyinɛ dabaŋka-ɛ? Ifɛŋ dukulɔ k'ilompsɛ yɔkɔmɛ yam tofo.» ");
INSERT INTO bsp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kɔ wərkun nwɛ ɛmbɛrɛ dəkəlɔ. Kɔ Labaŋ ontorɛ yɛsarɛ ya yɔkɔmɛ, k'ɔsɔŋ yi yika kɔ mɛmpəlɛ. K'ɔsɔŋ wərkun nwɛ kɔ afum aŋɛ ɛnasolɛ mɔ domun debikɛnɛ wɛcək. ");
INSERT INTO bsp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kɔ tɛyɛfɛ dənda k'ancəmbərɛ kɔ yeri. Mba k'oloku: «Ifɔdi kərɛsna paka, mɛnɛ iloku toloku ntɛ inder kəloku mɔ.» Kɔ Labaŋ oloku kɔ: «Məloku!» ");
INSERT INTO bsp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","K'oloku: «Awa. Wəcar ka Abraham iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Bel-bel bɔ MARIKI ompocɛ mariki mem pətɔt nwɛ ɔyɔnɛ fum wəlel mɔ. Kanu kəmpocɛ kɔ cəna ŋkesiya kɔ cir, gbeti kɔ kɛma, acar arkun kɔ aran, yɔkɔmɛ kɔ sɔfale. ");
INSERT INTO bsp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara wəran ka mariki mem ende pəkomɛ kɔ wan wərkun detembəra dɔn disrɛ. Wan wərkun wəkakɔ, nkɔn mariki mem ɔsɔŋ daka dɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mariki mem Abraham ɔsɔŋ'em kədɛrəm, kəcloku: ‹Məfɔdetɛnɛ wan kem wəran ayecəra a Kanaŋ dacɔ atɔf nŋɛ iyi mɔ, ");
INSERT INTO bsp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mba məde məkɔ nde iyɛfɛ mɔ, kor kosu disrɛ, mətɛnɛ di wan kem wəran.› ");
INSERT INTO bsp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","K'iloku Mariki mem: ‹Tɔlɔm ta wəran ɔŋkɔwosɛ kəcɛps'em darəŋ kəder nnɔ-ɛ.› ");
INSERT INTO bsp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","K'olok'im: ‹MARIKI nwɛ iŋkɔt fɔr kiriŋ mɔ, endesom mɛlɛkɛ mɔn mɛbaŋ əm pɔkɔt pam. Məlɛkɛ wan kem wəran nde kusuŋka kosu, pəyɔnɛ sɔ wəka kor kosu.› ");
INSERT INTO bsp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kɔ Abraham olok'im: ‹Indewur'am kədɛrəm kaŋkɛ imbɛrs'am a mədɛrəm mɔ, kɔ pəyɔnɛ a məŋkɔ nde kor kosu a ta awos'am, kəsɔŋ ka wan wəran-ɛ iŋŋaŋnɛn'am kədɛrəm kaŋkɛ.› ");
INSERT INTO bsp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ntɛ imbəpna mɔkɔ nde dəkələmp mɔ, k'iloku: ‹MARIKI, Kanu ka mariki mem Abraham, kɔ məŋwosɛ kəlompəs em pɔkɔt-ɛ, ");
INSERT INTO bsp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","in'ɔfɔ nwɛ iyi kələmp ka domun kəsək mɔ.› Wəyecəra nwɛ endewur kədekɛt domun mɔ, nwɛ indeloku: ‹Məpoc em domun depic da tɔbɔl tam imun,› ");
INSERT INTO bsp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","a wəkayi pəlok'im: ‹Məbaŋ məmun məna sərka, indesɔkɛtɛ yɔkɔmɛ yam!› Wəyecəra wəkakɔ pəyɔnɛ nwɛ MARIKI ɛncəmbərɛ wan ka mariki mem Abraham mɔ! ");
INSERT INTO bsp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ilipna fɛ ti kəlokunɛ dɛbəkəc, kɔ Rebeka oŋwur pəgbaŋnɛ tɔbɔl dəkəbanca. K'ontor dəkələmp k'ɛŋkɛt domun. K'iloku kɔ: ‹Ilɛtsɛn'am məpoc'em imun.› ");
INSERT INTO bsp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","K'ɛmbɛlkər kətin'em tɔbɔl tɔn tɔkɔ ɛŋgbaŋnɛna mɔ, k'olok'im: ‹Məmun, indepocɛ sɔ yɔkɔmɛ yam yomun.› K'imun, k'ompocɛ sɔ yɔkɔmɛ yem kɔ yomun. ");
INSERT INTO bsp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","K'iyif kɔ: ‹An'okom əm-ɛ wəyecəra?› K'olok'im: ‹Wan ka Betuhɛl iyɔnɛ, wansɔ ka Nahor kɔ Milka.› K'imbɛr kɔ kurundɛ dololəm kɔ cəsora dəwaca. ");
INSERT INTO bsp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","K'intontnɛnɛ MARIKI, k'iyek-yekəs kɔ, Kanu ka mariki mem Abraham, nkɛ kəsol'em kədelɛk wan ka wɛnc idesɔŋ kɔ Siyaka wan ka nkɔn Abraham mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ndɛkəl oŋ kɔ pəyɔnɛ a məwosɛ kəlasɛ mariki mem Abraham pəsoku disrɛ, layidi ndɛ mənasɔŋ kɔ mɔ, məsɔŋ'em ti kəcərɛ, kɔ pəyɔnɛ fɛ ti-ɛ, ikɔ kəca kəmeriya, kɔ pəyi fɛ ti-ɛ, kətɔt.» ");
INSERT INTO bsp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labaŋ kɔ Betuhɛl ŋaloku: «Tes tantɛ nda MARIKI tɛyɛfɛ, səfɔtam kəloku ti tɔlɔm o tɔlɔm. ");
INSERT INTO bsp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ɔfɔ wəkawɛ fɔr yam kiriŋ, məlɛk kɔ nəkɔ. Pəkɔ pəyɔnɛ wəran ka wan ka mariki mam pəmɔ tɔkɔ MARIKI oloku ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ntɛ wəcar ka Abraham ene moloku mamɔkɔ mɔ, k'ontontnɛnɛ MARIKI dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kɔ wəcar k'Abraham owurɛ yosumpər-sumpər ya gbeti, ya kɛma, kɔ yamos k'ɔsɔŋ yi Rebeka, k'ompocɛ sɔ Labaŋ wɛnc wərkun wəka Rebeka kɔ kɛrɛ kəŋan pəlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ntɛ mes mamɔkɔ melip mɔ, wərkun nwɛ k'asol ɔn, kɔ ŋandi yeri kɔ ŋamun, kɔ ŋancepərɛnɛ pibi. Dec dendesɔk, ntɛ ŋayɛfɛ mɔ, kɔ wəcar nwɛ oloku: «Nəsak im iluksərnɛ nda mariki mem.» ");
INSERT INTO bsp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kɔ Labaŋ ŋaloku kɔ kɛrɛ: «Wan wəran pəyi nnɔ kərɛsna mata wəco kɔ səna. Kɔ tencepər-ɛ, məntam kəkɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kɔ wərkun nwɛ oloku ŋa: «Ta nəsɔŋ'em kəwon ka nnɔ, bawo MARIKI olompəs em pɔkɔt. Nəsak im ilukus ndena mariki mem.» ");
INSERT INTO bsp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kɔ Labaŋ ŋaloku kɔ kɛrɛ: «Səwe wan wəran, səyif kɔ tɔkɔ ɛfaŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kɔ ŋawe Rebeka kɔ ŋayif kɔ: «Məfaŋ kəkɔ kɔ wərkun nwɛ ba?» Kɔ Rebeka owosɛ: «Ɛy.» ");
INSERT INTO bsp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Labaŋ kɔ kɛrɛ ŋasak Rebeka kɔ wəran nwɛ ɛnabaŋ kɔ mɔ, wəcar ka Abraham kɔ asol ɔn kɔ ŋaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kɔ ŋantolanɛ Rebeka kɔ ŋaloku kɔ: «Məna wəkirɛ kosu, məyɔnɛ wəka afum alarəm! Məyɔnɛ fum nwɛ yuruya yɔn yendetam aterɛnɛ aŋan mɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kɔ Rebeka ɛyɛfɛ kɔ acar ɔn ayecəra k'ɛmpɛsɛ yɔkɔmɛ kəroŋ, k'ɛncəmɛ wərkun nwɛ darəŋ. Kɔ wəcar ka Abraham ɛlɛk Rebeka kɔ ŋaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tɛtəŋnɛ Siyaka pəlukus kəyɛfɛ ka kələmp ka Lahay-Roy, pəndɛ nde atɔf ŋa Nɛkɛf. ");
INSERT INTO bsp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Dɔfɔy dɔlɔma kɔ Siyaka ɔŋkɔ dəŋkɔtəs dəkulum, endeyekti fɔr k'ɛnəŋk yɔkɔmɛ yecder. ");
INSERT INTO bsp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka endeyekti sɔ fɔr k'ɛnəŋk Siyaka, k'ontor yɔkɔmɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","K'eyif wəcar ka Abraham: «Wərkun wəre ɔfɔ wəkawɛ nnɔ dəkulum nwɛ ender kəfaynɛ su mɔ?» Kɔ wəcar oloku kɔ: «Mariki mem mɔ.» K'ɛlɛk kəloto kɔn k'ɛŋgbalərnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kɔ wəcar ka Abraham ɔlɔmər Siyaka mes mɔkɔ ɛnacepərɛnɛ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kɔ Siyaka eŋkekərɛ Rebeka abal ŋa kɛrɛ Sara disrɛ. K'ɛlɛk Rebeka k'ɔyɔnɛ wəran kɔn, k'ɔmbɔtər kɔ. Ti t'ɛnasɔŋɛ Siyaka pəwak kəpəl-pələs defi da kɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kɔ Abraham ɛlɛk sɔ wəran wəlɔma, pacwe kɔ Ketura. ");
INSERT INTO bsp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kɔ Ketura oŋkomɛ kɔ awut arkun: Simraŋ, Yɔksaŋ, Medaŋ, Madiyaŋ, Yisbak, kɔ Suwah. ");
INSERT INTO bsp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Kɔ Yɔksaŋ oŋkom Saba kɔ Dedaŋ. Awut arkun a Dedaŋ ŋanayɔnɛ afum a tɔf maas: Asuri, aLetusi kɔ aLeyumi. ");
INSERT INTO bsp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Awut a Madiyaŋ ŋanayɔnɛ Hefah, Hefer, Henok, Abidah, kɔ Ɛldaha. Akaŋɛ ŋanayɔnɛ awut a Ketura. ");
INSERT INTO bsp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham ɛnasɔŋ daka dɔn fəp Siyaka. ");
INSERT INTO bsp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Awut a alak'ɔn, k'ompocɛ ŋa, pəsɔrɔyi doru, k'eŋkekərɛ ŋa poŋ pəbɔlɛnɛ ŋa wan kɔn Siyaka, atɔf nŋɛ ŋeyi ntende kəca nkɛ dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Kəwon ka Abraham doru kənasɔtɔ meren tasar tin wəco camət mɛrəŋ kɔ kəcamət (175). ");
INSERT INTO bsp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kɔ Abraham ontorɛ kifir, k'efi ntɛ encepərɛnɛ detem dobotu mɔ, pəbɛk, pənɛmbərɛ mataka ma doru, k'ɔnɔŋkəl atem ɔn aŋɛ ŋanafi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Siyaka kɔ Səmayila awut a Abraham, ŋawup kɔ nde dəkəwupɛnɛ da Makpela, nde dalɛ da Hɛfəroŋ wan ka Cohar wəHewy, pətɛfərɛnɛ di kɔ Mamre. ");
INSERT INTO bsp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Dalɛ dɛnayi ndɛ Abraham ɛnaway nnɔ aHewy ŋayi mɔ. Difɔ anawup Abraham kɔ wəran kɔn Sara. ");
INSERT INTO bsp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ntɛ defi da Abraham dencepər mɔ, kɔ Kanu kəmpocɛ wan kɔn Siyaka nwɛ ɛnandɛ nde kələmp ka Lahay-Roy kəsək mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Awut a Səmayila ŋɔ akaŋɛ, Səmayila wan k'Abraham, nwɛ wan wəran wəMisira Hakar wəcar ka Sara ɛnakomɛ Abraham mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mewe ma awut a Səmayila mɛmɛ, tɔkɔ ŋanabɛkɛnɛ mɔ: Nebayɔt coco ca Səmayila, Kedar, Adebel, Mibəsam, ");
INSERT INTO bsp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Dumah, Masa, ");
INSERT INTO bsp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis, kɔ Kedema. Awut a Səmayila ŋɔ akakɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Mewe maŋan mɔ mamɔkɔ tɛndɛ taŋan cəgbo cəgbo. Abɛ wəco kɔ mɛrəŋ ŋanayi ŋa kiriŋ dɛlay daŋan. ");
INSERT INTO bsp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Kəyi ka Səmayila doru kənawon meren tasar tin wəco maas kɔ camət mɛrəŋ (137). K'ontorɛ kifir, k'ɔnɔŋkəl atem ɔn akɔ ŋanafi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Afum a Səmayila ŋayi kəyɛfɛ ka Hawila haŋ Sur nsɛ səntɛfərnɛ Misira mɔ, kəkɔ ka kəca ka Asiri. Yuruya ya Səmayila ŋanandɛ ŋatɛfərnɛ awɛnc aŋa fəp. ");
INSERT INTO bsp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Afum a Siyaka ŋ'aŋɛ, wan ka Abraham. Abraham okom Siyaka. ");
INSERT INTO bsp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Siyaka ɛnasɔtɔ meren wəco maŋkəlɛ (40) a k'endenɛncɛ Rebeka, wan wəran wəka Betuhɛl wəka Aram wəka Padaŋ-Aram, wəkirɛ ka Labaŋ wəka Aram. ");
INSERT INTO bsp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kɔ Siyaka ontola MARIKI teta wəran kɔn, bawo ɛnakom fɛ wan. Kɔ MARIKI ene kətola kɔn. Kɔ wəran kɔn Rebeka ɛmbɛkəs. ");
INSERT INTO bsp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kɔ awut ŋayɛfərɛnɛ kɔ kor disrɛ, kɔ Rebeka eyifnɛ: «Ak'ender im tantɛ-ɛ?» K'ɔŋkɔ pəkornɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kɔ MARIKI oloku kɔ: «Afum a tɔf mɛrəŋ ŋay'əm dəkor, afum mɛrəŋ akakɔ ŋandegbɛyɛnɛ kəwur əm dəkor. Afum a wəkin nwɛ ŋandetasərnɛ aka wəka mɛrəŋ. Wəbeki endeyi wəfɛt tantɔf.» ");
INSERT INTO bsp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Dəŋkom dɔn k'anəŋk a cəberi cəyi kɔ dəkor. ");
INSERT INTO bsp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Dəŋkom daŋan, kɔ wəcɔkɔ-cɔkɔ ender pəla cəfon cəyim dəris pəmɔ wɛsɛm, k'awe kɔ Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kɔ tencepər, kɔ wəka mɛrəŋ ender pəsumpər atek ŋa wəcɔkɔ-cɔkɔ. K'awe wəkakɔ Yakuba. Siyaka pəsɔtɔ tɛm tatɔkɔ oŋ meren wəco camət tin (60) a k'andekomɛ kɔ awut akaŋɛ. ");
INSERT INTO bsp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kɔ awut arkun aŋɛ ŋambɛk. Kɔ Esayu ende pəyɔnɛ wəpɛn wətɔt, wəbɔtər kəyɛksɛ-yɛksɛ dəkulum kətɛn ka sɛm yɛpɛn, kɔ Yakuba nkɔn ɔyɔnɛ wəyi wəka dare, wətɔsimsɛ dis pəbɔtər kəndɛ d'abal. ");
INSERT INTO bsp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Siyaka ɛnabɔtər Esayu bawo ɛnabɔtər sɛm nyɛ Esayu ɛncpɛn mɔ. Rebeka nkɔn pəbɔtər Yakuba. ");
INSERT INTO bsp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Dɔsɔk dɔlɔma kɔ Yakuba oncoŋər mɛnc, kɔ Esayu ender pəyɛfɛ dəkulum dis dɔlɔl kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kɔ Esayu oloku Yakuba: «Məpoc'em, ilɛtsɛn'am idi pəyim pam papɔkɔ bawo dis dɔlɔl im.» Ti tɔ asɔŋɛ Esayu tewe ta «Edɔm». ");
INSERT INTO bsp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kɔ Yakuba oloku Esayu: «Məwayər im mɔkɔ dəkəcəmɛ da debeki dam.» ");
INSERT INTO bsp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kɔ Esayu oloku kɔ: «In'ɛwɛ icfi, ake dəkəcəmɛ da debeki dadɔkɔ dendeyɔ em-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kɔ Yakuba oloku: «Mədɛrəm'em kərɛsna.» Kɔ Esayu ɛndɛrmɛ Yakuba k'ɛwayər kɔ dəkəcəmɛ da debeki dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kɔ Yakuba ompocɛ Esayu kəcom, kɔ mɛnc mamɔkɔ. Kɔ Esayu endi yeri yayɔkɔ, k'omun, k'ɛyɛfɛ k'ɔŋkɔ. Tatɔkɔ tɔ Esayu ɛnagbal dəkəcəmɛ da debeki dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kɔ dor dende deyi dɔtɔf, ndɛ dɛnaciyanɛ kɔ dor dɔcɔkɔ-cɔkɔ dɔkɔ dɛnayi di tɛm ta Abraham mɔ. Kɔ Siyaka ɔŋkɔ nda Abimɛlɛk, wəbɛ ka aFilisti nde Kerar. ");
INSERT INTO bsp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kɔ MARIKI owurər Siyaka, k'oloku kɔ: «Ta mətor Misira, məyi atɔf nŋɛ indeboncər əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Məndɛ atɔf ŋaŋɛ. Isol'am, indepoc'am pətɔt, bawo məna kɔ yuruya yam ŋ'indesɔŋ antɔf ŋaŋɛ fəp. Indelas tɛm tatɔkɔ kədɛrəm nkɛ inadɛrmɛ papa kam Abraham mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Indeyɔ yuruya yam yɛla pəmɔ cɔs ca darenc. Indesɔŋ yuruya yam tɔf yayɛ fəp. Afum a doru fəp ŋande ŋactɛn kətola nnɔ yuruya yam yeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abraham ɛnacəŋkəl dim dem, pəcəmɛ dɔpɔ dem darəŋ, pəsumpər moloku mem, pəleləs mɛfaŋ mem kɔ sariyɛ sem.» ");
INSERT INTO bsp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kɔ Siyaka ɛndɛ Kerar. ");
INSERT INTO bsp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ntɛ afum a tofo tatɔkɔ ŋancyifət teta wəran kɔn mɔ, pəcloku ŋa: «Wəkirɛ kem ɔfɔ.» Pəcnesɛ kəloku a wəran kɔn ɔfɔ, ta afum a tofo tatɔkɔ ŋadif kɔ, bawo Rebeka ɛnatesɛ. ");
INSERT INTO bsp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ntɛ kəyi kɔn kəncwon di mɔ, kɔ tosurɛnɛ Abimɛlɛk wəbɛ ka aFilisti pəwurɛ kəro dəwundɛr pəcmɔmən, k'ɛnəŋk Siyaka pəccɛcɛnɛ kɔ wəran kɔn Rebeka. ");
INSERT INTO bsp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kɔ Abimɛlɛk ewe Siyaka k'eyif kɔ: «Wəran kam ɔyɔnɛ wəran nwɛ ba! Ake'sɔŋɛ ntɛ məloku su a wəkirɛ kam ɔfɔ mɔ?» Kɔ Siyaka oloku kɔ: «Iloku ti kənesɛ disrɛ ta idefinɛ tetɔn.» ");
INSERT INTO bsp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kɔ Abimɛlɛk oloku kɔ: «Cəke məyɔ su tantɛ? Pəpic pɛcəmɛ wəlɔma su dacɔ ŋafəntərɛ kɔ wəran kam, kɔ mən'ɔsɔŋɛ su kəsarɛ kiciya.» ");
INSERT INTO bsp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kɔ Abimɛlɛk ɔsɔŋ dim dadɔkɔ afum ɔn fəp, ntɛ: «Fum nwɛ o nwɛ oŋgbuŋɛnɛ wərkun nwɛ kɔ wəran kɔn mɔ, mɛnɛ padif wəkayi.» ");
INSERT INTO bsp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Kɔ Siyaka ɔmbɔf kəren kaŋkɔ dɔtɔf k'ɛntɛl tasar tin (100) ta tɔkɔ ɛnabɔf mɔ, bawo MARIKI ɛnapocɛ kɔ pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kɔ wərkun nwɛ ɔsɔtɔ daka, k'ɛmbɛrɛnɛ kəsɔtɔ daka haŋ k'ɛnaŋkanɛ kəyɔnɛ wəka daka wəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Siyaka ɛnayɔ yɔcɔl yɛlarəm: Cəna, cir, ŋkesiya, kɔ acar alarəm, tɔsɔŋɛ aFilisti ŋayɔnɛ kɔ kəraca. ");
INSERT INTO bsp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Cələmp ncɛ acar a kas Abraham ŋanakay kiyi kɔn doru mɔ, kɔ aFilisti ŋaməntən ci, kɔ ŋalas ci kəbof. ");
INSERT INTO bsp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kɔ Abimɛlɛk oloku Siyaka: «Məyɛfɛ ndorosu məkɔ bawo məmbɛk su fənɔntər.» ");
INSERT INTO bsp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kɔ Siyaka ɛyɛfɛ di, k'ɔŋkɔ pəcəmbər saŋka nde dəŋgbəl da Kerar kəsək. ");
INSERT INTO bsp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kɔ Siyaka ɔŋgbɔkərɛ sɔ kəkay cələmp ncɛ anakay tɛm ta kas Abraham, a kɔ aFilisti ŋaməntən ci kəcepər ka defi da Abraham mɔ. K'ewe sɔ ci mewe mɔkɔ kas ɛnawe ci mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kɔ acar a Siyaka ŋaŋkay sɔ kələmp kəlɔma, dəndo mɔrɔ dacɔ, kɔ ŋambəp ki disrɛ domun dɔtɔt. ");
INSERT INTO bsp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Akɛk a yɔcɔl ya dare da Kerar ŋancaŋ akɛk a yɔcɔl ya Siyaka kəcɔp, ŋacsimsɛ kələmp, kɔ ŋaloku: «Kələmp kaŋkɛ kosu kɔ.» Kɔ Siyaka ewe kələmp kaŋkɔ Esɛk, bawo afum ŋanagbɛkəlɛnɛ ta ki kɔ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kɔ acar a Siyaka ŋaluksərnɛ sɔ kəkay kələmp kəlɔma nkɛ anagbɛkəlɛnɛ sɔ taka ki mɔ, k'ewe ki Sitna. ");
INSERT INTO bsp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","K'eliŋ saŋka sɔn dəndo, k'ɔŋkɔ pəkay sɔ kələmp kəlɔma nkɛ anatɔgbɛkəlɛnɛ ta ki mɔ, k'ewe ki Rehobot, bawo, oncloku: MARIKI pəyac su, pəsikəli su, kədesɔtɔ fənɔntər atɔf ŋaŋɛ. ");
INSERT INTO bsp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kɔ Siyaka ɛmpɛrnɛ Bersaba. ");
INSERT INTO bsp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kɔ MARIKI owurər kɔ pibi papɔkɔ, k'oloku kɔ: «In'ɔyɔnɛ Kanu ka papa kam Abraham. Ta mənesɛ, bawo isol'am, indepoc'am pətɔt, indeyɔ sɔ yuruya yam ŋala, teta wəcar kem Abraham.» ");
INSERT INTO bsp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kɔ Siyaka ɛncəmbər di tetek toloŋnɛ k'okornɛ tewe ta MARIKI. K'ɛncəmbər sɔ di abal, kɔ acar ɔn ŋaŋkay sɔ di kələmp. ");
INSERT INTO bsp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kɔ Abimɛlɛk ɛyɛfɛ Kerar kəkɔnəŋk nkɔn Siyaka ŋasol kɔ Ahusat wanapa kɔn, kɔ Pikɔl wəbɛ wəka asɔdar ɔn. ");
INSERT INTO bsp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kɔ Siyaka eyif ŋa: «Ta ake tɔ nənderɛnɛ nnɔ nderem-ɛ, bawo nənter im, kɔ nəmbɛləs im nde ndoronu?» ");
INSERT INTO bsp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kɔ ŋaloku kɔ: «Sənəŋk belbel a MARIKI osol'am. Ti tɔ səlokɛ: A padɛrmɛnɛ, ti tɔ tatɔkɔ məna kɔ səna, patəŋnɛ pasek danapa. ");
INSERT INTO bsp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ntɛ tendesɔŋɛ ta məyɔ su ali pəlɛc pin, pəmɔ tɔkɔ sənatɔyɔ əm pəlɛc, kɔ səyɔ əm pətɔt haŋ kɔ səsak əm kɔ məŋkɔ pəforu disrɛ mɔ. Ndɛkəl oŋ MARIKI ompoc'am.» ");
INSERT INTO bsp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kɔ Siyaka ombocɛ ŋa kəsata, kɔ ŋandi yeri kɔ ŋamun. ");
INSERT INTO bsp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kɔ ŋayɛfɛ bətbət suy kɔ ŋandɛrmɛnɛ. Kɔ Siyaka ɛsak ŋa kɔ ŋalukus kɔ ŋasak Siyaka pəforu disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Dɔsɔk din dadɔkɔ dɔ acar a Siyaka ŋander ŋaloku kɔ teta kələmp kəŋkɔ ŋanakay mɔ, kɔ ŋaloku kɔ: «Səsɔtɔ domun.» ");
INSERT INTO bsp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kɔ Siyaka ewe kələmp kaŋkɔ Sibeya. Ti tɔsɔŋɛ ntɛ aŋwenɛ dare dadɔkɔ Bersaba haŋ mɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esayu kəsɔtɔ kɔn meren wəco maŋkəlɛ (40), k'ɛlɛk aran aHewy, pacwe ŋa Sudit wan ka Beri kɔ Basmat wan ka Elɔn. ");
INSERT INTO bsp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","K'aran aHitara akaŋɛ mɛrəŋ ŋawonəs Siyaka kɔ Rebeka dis. ");
INSERT INTO bsp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Siyaka ɔncyɔnɛ wətem, fɔr yɔclɔl kɔ haŋ kɔ tɛləpsər kɔ kətɔnəŋk. K'ewe wan kɔn wəcɔkɔ-cɔkɔ Esayu, k'oloku kɔ: «Wan kem!» Kɔ Esayu owosɛ: «In'ɛwɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kɔ Siyaka ɔŋgbɔkərɛ: «Iyɔnɛ wətem, incərɛ fɛ dɔsɔk dem defi. ");
INSERT INTO bsp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Məlɛk oŋ yɛpɛnɛ yam, cəbəlma cam kɔ ambəncəran, məkɔ dəkulum məkɔ məpɛn'em wɛsɛm. ");
INSERT INTO bsp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Məlompəs'em peri pəmɔ tɔkɔ imbɔtər ti mɔ. Məkɛr'em pi, idi, ntɛ tɔŋsɔŋɛ ina yati itolan'am pətɔt a icfi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka pəccəŋkəl tɔkɔ Siyaka oncloku wan kɔn Esayu mɔ. Kɔ Esayu ɔŋkɔ dəkulum kəkɔpɛn wɛsɛm, pəkɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Kɔ Rebeka oloku wan kɔn Yakuba: «Ntɛ t'ine. Papa kam pəcloku wɛnc əm Esayu: ");
INSERT INTO bsp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Məkɛr'em wɛsɛm. Məlompəs'em peri mpɛ indedi, itolan'am pətɔt nde MARIKI eyi mɔ, a icfi.› ");
INSERT INTO bsp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ndɛkəl oŋ wan kem məcəŋkəl dim dem, məyɔ tɔkɔ indelok'əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Məkɔ məlɛk'em nde yɔcɔl dacɔ, mbiyofo yɔtɔt mɛrəŋ. Ilompsɛ papa kam peri pɔtɔt pəmɔ tɔkɔ ɔmbɔtər pi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Məndekenɛ papa kam peri papɔkɔ, ntɛ tɔŋsɔŋɛ pətolan'am pətɔt a pəcfi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kɔ Yakuba oloku kɛrɛ Rebeka: «Ɛy, mba wɛnc im Esayu ɛla cəfon dəris, k'ina iyɔ fɛ ci. ");
INSERT INTO bsp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tɔlɔma papa wəkem pəkɔwakəs im dis, endecər'em kətɔlomp tɔsɔŋ'em kəsɔtɔ pəlɛc ta isɔtɔ pətɔt-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kɔ kɛrɛ oloku kɔ: «Tɔyɔnɛ a pəlɛc papɔkɔ peder im! Məcəŋkəl gbəcərəm dim dem. Məkɔ məkɛr'em mir.» ");
INSERT INTO bsp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kɔ Yakuba ɔŋkɔ pəlɛk mir, k'ɛŋkɛrɛ iya kɔn. Kɔ iya kɔn olompəs peri, pəmɔ tɔkɔ papa kɔn ɛnabɔtər pi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kɔ Rebeka ɛlɛk yamos ya Esayu wan kɔn wəcɔkɔ-cɔkɔ, yamos yɔtɔt yɔkɔ ɛnatam kəsɔtɔ dɛkɛr mɔ, k'ɔsɔŋ yi wan kɔn wəlpəs Yakuba k'ɛmbɛrnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","K'oŋkump Yakuba akata ŋa mbiyofo yɔkɔ ŋanadif mɔ dəwaca kɔ dəkilim, kəbəp ka mofo mɔkɔ mɛnatɔyɔ cəfon mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kɔ Rebeka ɔsɔŋ wan kɔn Yakuba peri pɔkɔ ɛnalompəs mɔ, kɔ kəcom. ");
INSERT INTO bsp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kɔ Yakuba ɔŋkɔ nde papa kɔn eyi mɔ, k'oloku: «Papa wəkem!» Kɔ Siyaka owosɛ: «In'ɛwɛ. Mən'an'ɔfɔ-ɛ, Wan kem?» ");
INSERT INTO bsp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kɔ Yakuba oloku kas: «In'ɔfɔ Esayu wan kam wəcɔkɔ-cɔkɔ. Iyɔ tɔkɔ məlokun'em mɔ. Məyɛfɛ ilɛtsɛn'am, məndɛ məsɔm wɛsɛm wem, ntɛ tɔŋsɔŋɛ məna yati mətolan'em pətɔt mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kɔ Siyaka oloku wan kɔn: «Mba məyeŋk kəsɔtɔ wɛsɛm wan kem!» Kɔ Yakuba oloku: «MARIKI Kanu kam kəkɛr'em wi fɔr yem kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kɔ Siyaka oloku Yakuba: «Məcɔŋnɛ oŋ wan kem, iwakəs əm, icərɛ kɔ pəyɔnɛ a wan kem Esayu ɔfɔ-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kɔ Yakuba ɔlɔtərnɛ kas Siyaka, k'ɛwakəs kɔ k'oloku: «Dim dandɛ da Yakuba dɔ, mba waca wawɛ wa Esayu wɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Siyaka ɛnanɛpəl fɛ kɔ. Bawo waca wɔn wɛnala cəfon pəmɔ waca wa wɛnc Esayu, k'ontolanɛ kɔ pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","K'eyif: «Mən'ɔfɔ məna wan kem Esayu?» Kɔ Yakuba owosɛnɛ kɔ: «Ɛy.» ");
INSERT INTO bsp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kɔ Siyaka oloku: «Məbɛr'em isɔm wɛsɛm wa wan kem, ntɛ tɔŋsɔŋɛ, ina yati itolan'am pətɔt mɔ.» Kɔ Yakuba ɛmbɛrɛ Siyaka yeri k'endi, k'ɛŋkɛrɛ kɔ sɔ member k'omun. ");
INSERT INTO bsp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kɔ kas Siyaka oloku sɔ: «Məcɔŋnɛ məcup im wan kem.» ");
INSERT INTO bsp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kɔ Yakuba ɔncɔŋnɛ, k'oncup kɔ. Kɔ Siyaka ene ambɔnc ŋa yamos ya Esayu. K'ontolanɛ kɔ ntɛ: «Ɛy, ambɔnc ŋa wan kem ŋeyi pəmɔ ambɔnc ŋa dalɛ ndɛ MARIKI ompocɛ pətɔt mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kanu kəsɔŋ əm pəcaŋki pa darenc kɔ daka da dəntɔf: Malɔ kɔ member pəlarəm! ");
INSERT INTO bsp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","MARIKI pəsɔŋɛ, afum ŋay'əm dəntɔf, Kanu kəsɔŋɛ afum ŋatontnɛn'am! Kanu kəsɔŋɛ məyi awɛnc əm aŋa kəroŋ, Kanu kəsɔŋɛ awut a iya kam ŋatontnɛn'am dəntɔf! Kanu kəsɔŋ pəlɛc, wəkɔ ɛŋfaŋ'am pəlɛc mɔ, Kanu kəsɔŋ pətɔt wəkɔ ɛŋfaŋ'am pətɔt mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Siyaka ɛnadelip kətolanɛ Yakuba, Yakuba endeyɛfɛ kas dəntɔf, kɔ wɛnc Esayu ɛmbɛrɛ pəyɛfɛ dəkəpɛn. ");
INSERT INTO bsp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kɔ Esayu olompəs sɔ peri k'eŋkenɛ kas Siyaka. K'oloku kas: «Papa məyɛfɛ məsɔm wɛsɛm wa wan kam, ntɛ tɔŋsɔŋɛ mətolan'em pətɔt məna yati mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kɔ kas Siyaka eyif kɔ: «Mən'an'ɔfɔ-ɛ?» Kɔ Esayu oloku kɔ: «In'ɔfɔ wan kam wəcɔkɔ-cɔkɔ Esayu.» ");
INSERT INTO bsp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kɔ pəyi Siyaka yamayama, yamayama pəpɔŋ k'oloku: «An'ɔkɔ pəpɛn wɛsɛm k'ɛŋkɛr'em-ɛ? Isɔm yi a kɔ məndeder, intolanɛ kɔ pətɔt. Kətola pətɔt kəlip kəsumpər kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ntɛ Esayu ene moloku ma kas mɔ, k'ɛmbɛr kəbebe, k'oŋkulɛ-kulɛ pəpɔŋ, k'oloku kas: «Ina sɔ mətolan'em pətɔt Papa.» ");
INSERT INTO bsp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kɔ Siyaka oloku kɔ: «Wɛnc əm enderɛnɛ cəmpənpən k'ɛlɛk kətolanɛ pətɔt kam.» ");
INSERT INTO bsp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kɔ Esayu oloku: «Cepɔ ntɛ asɔŋ kɔ tewe ta Yakuba mɔ, ti t'ɛŋnɛmps'em haŋ kəmɛrəŋ? Ɛnabaŋər im tɔkɔ dəcəmɛ da debeki dem. Kɔ pəndesɔyi tantɛ k'ɛŋlɛkər im sɔ kətolanɛ pətɔt kem.» Kɔ Esayu endeŋər: «Papa, məmɛŋkərnɛ fɛ sɔ kətolanɛ pətɔt kəlɔma, məsɔŋ im ki?» ");
INSERT INTO bsp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Kɔ Siyaka oloku Esayu: «Isɔŋ kɔ kəyi kam kəroŋ, k'isɔŋ kɔ awɛnc aŋa fəp kəyi kɔ dəntɔf, k'isɔŋ kɔ bəle kɔ wɛn. Cəke c'indeyɔnɛ məna-ɛ, wan kem?» ");
INSERT INTO bsp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kɔ Esayu eyif kas: «Kətola pətɔt kin kaŋkɔ gboŋ kɔ məyɔ ba, Papa? Ina sɔ mətolan'em pətɔt, Papa!» Kɔ Esayu ɛyɛfɛ kəbok. ");
INSERT INTO bsp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kɔ kas Siyaka oloku kɔ: «Mənəŋk! Dəkəndɛ dam dɔfɔdeyɔ daka da dəntɔf Kɔ pəcaŋki mpɛ pɛŋyɛfɛ darenc mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Dakma dam dendedəs əm doru, Məndeyi wɛnc əm dəntɔf. Məndeyi tam taciŋa Fənɔntər fam fəndesɔŋɛ, məccer kɔ mɛfaŋ mɔn.» ");
INSERT INTO bsp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Kɔ Esayu ɛmɛŋkɛ Yakuba mɛtɛlɛ, teta kətolanɛ pətɔt nkɛ kas ɛnatolanɛ Yakuba mɔ. Esayu pəccɔpəsnɛ dɛbəkəc, «Mataka ma defi da papa wəkem mɔmbɔlɛ fɛ sɔ. Indedif wɛnc im Yakuba.» ");
INSERT INTO bsp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","K'aŋkɔ paloku Rebeka mɛcɛmcɛmnɛ mɛlɛc ma Esayu nnɔ Yakuba eyi mɔ. Kɔ Rebeka ewe wan kɔn Yakuba, k'oloku kɔ: «Məne ntɛ wɛnc əm Esayu ɛfaŋ kəluks'am ayɛk mɔ, a pədif əm. ");
INSERT INTO bsp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Awa wan kem, məcəŋkəl im! Məyɛfɛ, məkɔ məgbɔpnɛ ndena wɛnc im wərkun Labaŋ nde Haraŋ. ");
INSERT INTO bsp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Məkɔ məyi di mataka, haŋ mɛtɛlɛ ma wɛnc əm melip. ");
INSERT INTO bsp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kɔ mɛtɛlɛ ma wɛnc əm mendelip-ɛ, pəpələrnɛ pəcuy pɔkɔ məyɔ kɔ mɔ, indew'am məder. Ta ake t'indebutɛ nu mɛrəŋ monu dɔsɔk din-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kɔ Rebeka oloku Siyaka: «Doru dɛŋgbəf im teta awut aran aHewy. Kɔ Yakuba ɛnɛncɛ wəHewy, wan wəran wəka dɔtɔf pəmɔ akaŋɛ, ake indesɔyɔ oŋ doru-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kɔ Siyaka ewe Yakuba, k'ontolanɛ kɔ pətɔt, k'osom kɔ ntɛ: «Ta mənɛncɛ wəran wəka Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Məyɛfɛ. Məkɔ Padaŋ-Aram, ndena papa ka iya kam. Məlɛk di wəran awut aran a ncɔk'am Labaŋ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kanu kɛ kəntam mes fəp doru mɔ kəpoc'am pətɔt, kəsɔŋ əm dokombəra, kəsɔŋ'am məla ntɛ tɔŋsɔŋɛ məyɔnɛ afum alarəm mɔ! ");
INSERT INTO bsp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","MARIKI pəsɔŋ əm pətɔt pa Abraham kɔ yuruya yam ntɛ tɔŋsɔŋɛ atɔf ŋaŋɛ məyi decikəra mɔ, ŋey'əm dəwaca pəmɔ tɔkɔ Kanu kənasɔŋ ŋi Abraham mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kɔ Siyaka ɛsak Yakuba k'ɔŋkɔ Padaŋ-Aram, ndena Labaŋ wan ka Betuhɛl, wəAram, wɛnc wərkun wəka Rebeka, iya wəka Yakuba kɔ Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kɔ Esayu ɛnəŋk a Siyaka ontolanɛ Yakuba pətɔt, k'oloku kɔ kəkɔ sɔ Padaŋ-Aram pəkɔtɛn wəran, mba ntɛ Siyaka onctolanɛ kɔ mɔ, ɛnasom kɔ ntɛ: «Ta mənɛncɛ wəran wəka Kanaŋ de.» ");
INSERT INTO bsp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakuba ɛnane moloku ma kas kɔ kɛrɛ, k'ɔŋkɔ Padaŋ-Aram. ");
INSERT INTO bsp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kɔ Esayu ɛnəŋk a mes ma awut aran aka Kanaŋ mɛnabɔt fɛ papa kɔn Siyaka. ");
INSERT INTO bsp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kɔ Esayu ɔŋkɔ ndena Səmayila, k'ɛlɛk di wəran pacwe kɔ Mahalat, wan wəran wəka Səmayila wan k'Abraham, wəkirɛ ka Nebayɔt, kəbɛrɛnɛ ka aran aHewy akɔ ɛnayɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kɔ Yakuba ɛyɛfɛ Bersaba k'ɔŋkɔ Haraŋ. ");
INSERT INTO bsp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","K'ɛmbəp tofo tɔlɔma k'endirɛ di, bawo dec dɛnaləpɛ kɔ. Kɔ Yakuba ɛlɛk tasar tin ta kəfo kaŋkɔ, k'ɛfakɛnɛ pi, k'ɛfəntərɛ kəfo kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","K'ɛwɛrəp, k'ɛnəŋk samɛ səcəmɛ dəntɔf domp da si docgbuŋɛnɛ kɔm mɛlɛkɛ a Kanu mɛcfərəŋk si, mɛcpɛ, moctor. ");
INSERT INTO bsp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kɔ MARIKI ɛncəmɛ samɛ sasɔkɔ darenc. K'oloku: «In'ɔyɔnɛ MARIKI, Kanu k'Abraham papa kam, kɔ Kanu ka Siyaka. Antɔf ŋaŋɔkɔ məfəntərɛ mɔ, indesɔŋ əm ŋi məna kɔ yuruya yam. ");
INSERT INTO bsp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Yuruya yam ŋendela pəmɔ kəbof ka dəntɔf. Məndewɔkələs dəkəndɛ dam kəca kətɔt kɔ kəmeriya, nde dec dɛmpɛ mɔ kɔ nde dɛŋkalɛ mɔ. Afum a doru fəp ŋande ŋactɛnər əm kətolanɛ pətɔt kɔ yuruya yam. ");
INSERT INTO bsp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ina yati in'osol'am, inde icbum əm kəca nkɛ o nkɛ məŋkɔ mɔ, indekɛr'am atɔf ŋaŋɛ, bawo ifɔsak əm ta intalas tantɛ iŋlok'əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kɔ Yakuba entimɛ dəmere, k'oloku: «Tɔlɔma MARIKI eyi nnɔ tofo tantɛ, k'intɔnacərɛ ti!» ");
INSERT INTO bsp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","K'enesɛ k'oloku: «Mba tofo tɔyɔ wɛywɛy! Pənciyanɛ fɛ dɛ kɔ kəlɔ ka Kanu, kusuŋka ka darenc kɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kɔ Yakuba ɛyɛfɛ bətbət suy, k'ɛlɛk tasar tɔkɔ ɛnafakɛnɛ domp mɔ, k'ɛncəmbər pi, k'oloŋər pi kəroŋ moro mɔbɔy teta kəpusɛ ka pi Kanu. ");
INSERT INTO bsp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kɔ Yakuba ewe tofo tatɔkɔ Betel, mba dare dadɔkɔ dɛnanuŋkɛnɛ dɔyɔ tewe ta Lus. ");
INSERT INTO bsp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kɔ Yakuba ontola pəcloku: «Kɔ pəyɔnɛ a Kanu kəsol'em kəcbum im dɔpɔ ndɛ iŋkɔt mɔ, kɔ pəyɔnɛ a kəŋsɔŋ im kəcom kem kəsɔm, kəsɔŋ im sɔ yamos ibɛrnɛ, ");
INSERT INTO bsp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","k'ilukus pəforu disrɛ nde kəlɔ ka papa wəkem-ɛ, awa MARIKI endeyɔnɛ Kanu kem. ");
INSERT INTO bsp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tasar tantɛ incəmbər teta kəpusɛ ka pi Kanu mɔ, pendeyɔnɛ kəlɔ ka Kanu. Indesɔŋ əm farilɛ fa mpɛ o mpɛ məndekɔsɔŋ im mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kɔ Yakuba ɛyɛfɛ kəkɔt kəkɔ ka atɔf ŋa awut a nde dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kɔ Yakuba ɛnəŋk kələmp dəndo dəkulum, kɔ yɔcɔl yɛfɛt yɛfɛt yoloŋkanɛ mofo maas yɛcəmɛ kələmp kaŋkɔ kəsək, bawo kələmp kaŋkɔ kɔ yɔcɔl yoncmun. Tasar mpɛ pɛnayi kələmp dəkusu mɔ pɛnabɛk. ");
INSERT INTO bsp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Difɔ yɔcɔl fəp yɛncbəpɛnɛ. Pabiŋkəli tasar papɔkɔ anaboc kələmp dəkusu mɔ, cir kɔ ŋkesiya yomun. Kɔ yelip-ɛ paluksɛ tasar papɔkɔ sɔ kələmp dəkusu. ");
INSERT INTO bsp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kɔ Yakuba eyif akɛk yɔcɔl: «Awɛnc im aŋa, aka deke ŋɔ nəyɔnɛ-ɛ?» Kɔ akakɔ ŋaloku kɔ: «Aka Haraŋ ŋɔ səyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kɔ Yakuba eyif ŋa: «Nəncərɛ Labaŋ, wan ka Nahor?» Kɔ ŋawosɛ: «Ɛy, səncərɛ kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","K'eyif ŋa: «Cəke cɔ pəyi kɔ-ɛ?» Kɔ akakɔ ŋaloku kɔ: «Daka o daka! Wan kɔn wəran Rasɛl ender wəkɔ kɔ yɔcɔl yɛfɛt yɛfɛt.» ");
INSERT INTO bsp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kɔ Yakuba oloku ŋa: «Dec dɔsɔrɔbɛk kərɛsna. Tɛm toloŋka yɔcɔl tɛntabəp fɛ. Nəsɔŋ yɔcɔl domun, kɔ nəlip-ɛ nəkekərɛ yi kərɛsna yɔkɔsɔmət.» ");
INSERT INTO bsp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kɔ ŋaloku kɔ: «Səfɔtam ti kɔ yɔcɔl fəp yɔntɔloŋkanɛ-ɛ, bawo ti tɔ səmbiŋkəli tasar ntɛ aŋsuncɛ kələmp mɔ, a yɔcɔl yɛfɛt yɛfɛt yomun.» ");
INSERT INTO bsp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakuba eyi kəlok-lokər akɛk kɔ Rasɛl ɛmbɛrɛ kɔ yɔcɔl yɛfɛt yɛfɛt ya kas, bawo Rasɛl wəkɛk ɛnayi. ");
INSERT INTO bsp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ntɛ Yakuba ɛnəŋk Rasɛl wan wəran wəka Labaŋ kɔ yɔcɔl yɛfɛt yɛfɛt ya Labaŋ mɔ, k'ɔncɔŋnɛ k'embiŋkəli tasar tatɔkɔ ancsuncɛ kələmp mɔ. Kɔ yɔcɔl yɛfɛt yɛfɛt ya Labaŋ yomun. ");
INSERT INTO bsp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kɔ Yakuba oncup Rasɛl, k'ɛyɛfɛ kəfək, pəcbok. ");
INSERT INTO bsp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kɔ Yakuba oloku Rasɛl: «Fum ka papa kam iyɔnɛ, wan ka Rebeka iyɔnɛ.» Kɔ Rasɛl ɛyɛksɛ kəkɔloku ti kas Labaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ntɛ Labaŋ ene kəder ka Yakuba wan ka wəkirɛ kɔn mɔ, k'ɛyɛksɛ k'ende pəsapnɛ Yakuba, k'ɛmakərɛnɛ kɔ. Kɔ Labaŋ eŋkekərɛ kɔ nde kəlɔ kɔn, kɔ Yakuba ɔlɔmər kɔ mes mɔkɔ mɛnasɔtɔ kɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kɔ Labaŋ oloku kɔ: «Kance kəsoku pɛs kɔ: Mecir min mɔ səmpaŋnɛ!» Kɔ Yakuba eyi ndena Labaŋ ŋof ŋin. ");
INSERT INTO bsp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kɔ Labaŋ ende pəloku Yakuba: «Bawo fum kem məyɔnɛ, məfɔdebəc'em kifəli? Məboncər im daka ndɛ məfaŋ da kəway kam mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labaŋ ɛnayɔ ayecəra mɛrəŋ: Tewe ta Bɔmbɔ bɔn tɛnayɔnɛ Leya, kɔ Cayi cɔn Rasɛl. ");
INSERT INTO bsp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ɛnatesɛ fɔr dəkəro, mba Rasɛl ɛnanaŋkanɛ kətesɛ. ");
INSERT INTO bsp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rasɛl ɛnabɔt Yakuba mes. Kɔ Yakuba oloku Labaŋ: «Indebəc'am meren camət-mɛrəŋ, teta wan kam wəran Cayi: Rasɛl.» ");
INSERT INTO bsp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kɔ Labaŋ oloku kɔ: «Kəsɔŋ əm kɔ kəncepər im tɔkɔ iŋkɔsɔŋ kɔ wərkun wəcuru mɔ. Məyi nnɔ nderem!» ");
INSERT INTO bsp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kɔ Yakuba ɛmbəcɛ Labaŋ meren camət-mɛrəŋ teta Rasɛl. Kɔ meren camət-mɛrəŋ mamɔkɔ meyi, Yakuba dəfɔr pəmɔ mataka, bawo Rasɛl ɛnabɔt kɔ mes. ");
INSERT INTO bsp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kɔ Yakuba ende pəloku Labaŋ: «Məsɔŋ im wəran wəkem bawo tɛm tem ta yɛbəc telip, ifaŋ kənɛncɛ kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kɔ Labaŋ ewe aka tofo tatɔkɔ fəp, kɔ ŋambəpɛnɛ k'omboc kəsata. ");
INSERT INTO bsp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pəndeyi dɔfɔy, k'ɛlɛk wan kɔn wəran Leya k'eŋkenɛ Yakuba, kɔ Yakuba ɛnɛncɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kɔ Labaŋ ɔsɔŋ wan kɔn wəran Leya wəcar wəran nwɛ ancwe Silpa mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Dec dendesɔk, kɔ Yakuba ɛnəŋk a bafɔ Leya asɔŋ kɔ. K'oloku Labaŋ: «Cəke cɔ məyɔ em ntɛ? Bafɔ teta Rasɛl t'imbəc'am? Ta ake tɔ məntiŋkər'em-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kɔ Labaŋ oloku: «Afɔsɔŋ səna ndorosu Cayi, ta antasɔŋ Bɔmbɔ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mələpəs tataka toluksər kɔ Bɔmbɔ, a sədesɔŋ əm sɔ Cayi kɔ məndewosɛ sɔ kəbəc'em tetɔn meren camət-mɛrəŋ-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kɔ Yakuba ɔyɔ tatɔkɔ, k'ɛləpəs tataka toluksər kɔ Leya, kɔ Labaŋ ɔsɔŋ kɔ sɔ wan kɔn wəran Rasɛl. ");
INSERT INTO bsp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Kɔ Labaŋ ɛlɛk wəcar kɔn Bilha k'ɔsɔŋ kɔ Rasɛl. ");
INSERT INTO bsp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ka Yakuba ɛnɛncɛ sɔ Rasɛl nwɛ ɛnabɔt kɔ mes, pətas Leya mɔ. K'ɛmbəcɛ sɔ Labaŋ meren camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kɔ MARIKI ɛnəŋk a ambɔtər fɛ Leya pəmɔ Rasɛl, k'ɔsɔŋ Leya dokombəra. K'osumpər Rasɛl dokombəra. ");
INSERT INTO bsp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Kɔ Leya ɛmbɛkəs. K'oŋkom wan wərkun, k'ewe wan wəkakɔ Ruben. Ti tɔ tatɔkɔ nnɔ eyi mɔ, «MARIKI ɛnəŋk kəlapəs kem. Ndɛkəl oŋ, wos im endebɔtər im.» ");
INSERT INTO bsp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","K'ɔŋgbɔkərɛ sɔ kəbɛkəs, k'oŋkom sɔ wan wərkun. Kɔ Leya oloku a: «MARIKI ene a ambɔtər f'em, k'ɔsɔŋ im sɔ wəkawɛ.» Kɔ Leya ɔsɔŋ wəkakɔ tewe ta Simeyɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kɔ Leya oluksərnɛ k'ɛmbɛkəs, k'oŋkom wan wərkun sɔ. K'oloku: «Tantɛ taŋ, wos im endegbɛkər'em, bawo iŋkomɛ kɔ awut arkun maas. It'anasɔŋɛ wan wəkakɔ tewe ta Lewy.» ");
INSERT INTO bsp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","K'ɛmbɛkəs sɔ k'oŋkom wan wərkun sɔ. K'oloku: «Tantɛ taŋ indekor-koru MARIKI.» Ti tɛnawenɛ wan wəkakɔ tewe ta Yuda. Kɔ Leya ɛsak oŋ, kəkom. ");
INSERT INTO bsp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ntɛ Rasɛl ɛnəŋk a eyi fɛ kəkomɛ Yakuba mɔ, k'ɔyɔnɛ wɛnc wəran Leya kəraca. Kɔ Rasɛl oloku Yakuba: «Məsɔŋ im awut kɔ pəyi fɛ ti-ɛ, iŋfi!» ");
INSERT INTO bsp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kɔ pəntɛlɛ Yakuba nnɔ Rasɛl eyi mɔ, k'oloku: «Incəmɛ dəkəcəmɛ da Kanu, nkɛ kəntɔsɔŋ əm dokombəra mɔ?» ");
INSERT INTO bsp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kɔ Rasɛl oloku: «Wəcar kem wəran Bilha ɛwɛ, məfəntərɛ kɔ nkɔn ntɛ tɔŋsɔŋɛ pəsɔtɔ wan mɔ. Nnɔ suwu sem s'endekom wan wəkakɔ, pəsɔŋ'em kəyɔ wan.» ");
INSERT INTO bsp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kɔ Rasɛl ɔsɔŋ Yakuba wəcar kɔn wəran Bilha. Kɔ Yakuba ɔŋkɔ kɔ, ");
INSERT INTO bsp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Kɔ Bilha ɛmbɛkəs, k'oŋkomɛ Yakuba wan wərkun. ");
INSERT INTO bsp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kɔ Rasɛl oloku: «Kanu kəmboc'em kiti, kɔ kəne sɔ dim dem, kəmpoc'em wan wərkun.» Ti tɛnasɔŋɛ wan wəkakɔ tewe ta Dan. ");
INSERT INTO bsp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kɔ Bilha wəcar ka Rasɛl, ɔŋgbɔkərɛ sɔ kəbɛkəs, k'oŋkomɛ Yakuba wan wərkun tamɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kɔ Rasɛl oloku: «Kanu kəmar im kəsiməs kɔ wɛnc im wəran Leya, k'intam kɔ.» Kɔ Rasɛl ɔsɔŋ wan wəkakɔ tewe ta Naftali. ");
INSERT INTO bsp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ntɛ Leya ɛnəŋk a ɛsak kəkom mɔ, k'ɛlɛk wəcar kɔn Silpa k'ɔsɔŋ kɔ Yakuba pənɛncɛ. ");
INSERT INTO bsp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kɔ Silpa wəcar ka Leya oŋkomɛ Yakuba wan wərkun. ");
INSERT INTO bsp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Kɔ Leya oloku a: «Pəbotu pender!» Kɔ Leya ɔsɔŋ wan wəkakɔ tewe ta Kadu. ");
INSERT INTO bsp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa wəcar ka Leya ɔŋgbɔkərɛ sɔ kəkomɛ Yakuba wan wərkun tamɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Kɔ Leya oloku: «Mba pəmbɔt im! Ɛy, aran ŋande ŋackul'em oŋ a pəmbɔt əm.» K'ɔsɔŋ wan kakɔ tewe ta Asɛr. ");
INSERT INTO bsp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Dɔsɔk dɔlɔma katɛla kənayi, kɔ Ruben ɔŋkɔ dalɛ. K'ɔŋkɔ pəsɔtɔ di yeri yokom yɔlɔma, k'ɛŋkɛrɛ yi iya kɔn Leya. Kɔ Rasɛl oloku Leya: «Ilɛtsɛn'am, məpoc'em yokom yɔlɔma nyɛ wan kam ɛŋkɛr'am mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kɔ Leya oloku Rasɛl: «Pəntəŋnɛ f'am ntɛ məmbaŋər im wos im mɔ, mɛnɛ məsɔtɔ sɔ yeri ya wan kem?» Kɔ Rasɛl oloku Leya: «Awa! Ndaram ende mɔkɔ fəntərɛ, kəway ka yeri ya wan kam.» ");
INSERT INTO bsp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Dɔfɔy dendebəp, ntɛ Yakuba ɛyɛfɛ dalɛ mɔ, kɔ Leya ɔŋkɔ pəfaynɛ kɔ, k'oloku Yakuba: «Nnɔ nderem mənde mɔkɔ fəntərɛ, bawo kəsɔtɔ kam pibi pɔmɔkɔ, mɛnɛ ntɛ isəkpərɛ pi yeri yɔlɔma ya dalɛ nyɛ wan kem ɛŋkɛrɛna mɔ.» Kɔ Yakuba ŋafəntərɛ pibi papɔkɔ kɔ Leya. ");
INSERT INTO bsp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kɔ Kanu kəmbaŋ Leya, k'ɛmbɛkəs. K'oŋkomɛ Yakuba wan wərkun wəka kəcamət. ");
INSERT INTO bsp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kɔ Leya oloku: «Kanu kəsɔŋ im kəway kem. Ina nwɛ ilɛk wəcar kem wəran k'isɔŋ kɔ wos im mɔ.» Kɔ Leya ewe wan wəkakɔ Isakar. ");
INSERT INTO bsp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kɔ Leya endesɔ pəbɛkəs, k'oŋkomɛ Yakuba sɔ wan wərkun wəka camət-tin. ");
INSERT INTO bsp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kɔ Leya oloku: «Kanu ompoc'em! Tantɛ taŋ, wos im endeyi tofo tin k'ina, bawo iŋkomɛ kɔ awut arkun camət-tin.» Kɔ Leya ewe wan wəkakɔ Sabulon. ");
INSERT INTO bsp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kɔ Leya ɛmbɛkəs, k'oŋkom wan wəran nwɛ ɛnasɔŋ tewe ta Dina mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kɔ Kanu kənde kəcɛm-cɛmnɛ Rasɛl, kɔ kəne kətola kɔn, kɔ kəsɔŋ kɔ dokombəra. ");
INSERT INTO bsp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Kɔ Rasɛl ende pəbɛkəs, k'oŋkom wan wərkun. K'oloku: «Kanu kəliŋ im malap.» ");
INSERT INTO bsp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kɔ Rasɛl ewe wan kɔn wəkakɔ Isifu, k'oloku: «MARIKI pəbɛrɛn'em sɔ wan wərkun wəlɔma!» ");
INSERT INTO bsp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ntɛ Rasɛl oŋkom Isifu mɔ, kɔ Yakuba oloku Labaŋ: «Məsak im ilukus nnɔ nderem, ikɔ nde atɔf ŋem. ");
INSERT INTO bsp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Məsɔŋ im aran em k'awut em aŋɛ imbəc'am tetaŋan mɔ, ŋa ŋɔ səndekɔ, bawo məna yati məncərɛ yɛbəc nyɛ imbəc'am mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kɔ Labaŋ oloku Yakuba: «Ifaŋ a məboncər im kəway nkɛ indesɔŋ əm mɔ. Canu cem cəsɔŋ'em kəcərɛ a MARIKI ompoc'em pətɔt tetam. ");
INSERT INTO bsp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Məboncər im kəway kam iŋsɔŋ əm ki.» ");
INSERT INTO bsp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kɔ Yakuba oloku Labaŋ: «Məna yati, məncərɛ kɔ tɔkɔ imbəc'am mɔ, kɔ tɔkɔ isɔŋɛ kɔ yɔcɔl yam yeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Bawo yɔcɔl yepic yɔkɔ inabəp'am mɔ, yɛla oŋ ndɛkəl. Kɔ MARIKI ompoc'am kəlɛk dɔsɔk ndɛ imbɛrɛ kəlɔ kam mɔ, haŋ mɔkɔ. Ndɛkəl oŋ ake tɛm tɔ indebəcɛ afum em-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kɔ Labaŋ eyif kɔ: «Ak'indesɔŋ əm-ɛ?» Kɔ Yakuba oloku: «Məfɔdesɔŋ im daka o daka. Kɔ məwosɛ kəyɔ tɔkɔ indelok'əm mɔ, indesɔkɛkəs yɔcɔl yam yɛfɛt yɛfɛt, ibum'am sɔ yi. ");
INSERT INTO bsp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mɔkɔ indecepər yɔcɔl yam yɛfɛt yɛfɛt fəp dacɔ, mədekɔcəmbər ŋkesiya yɛtɛmsər kɔ yɛcɛmcɛmər fəp kəsək yɔyɔnɛ yɔpɔŋ, yɔyɔnɛ yɛfɛt, ŋkesiya nyɛ yɔyɔ lom yɛcapsər mɔ, kɔ cir ncɛ cəncɛmcɛmər, ncɛ cəntɛmsər mɔ. Yayɔkɔ yendeyɔnɛ kəway kem. ");
INSERT INTO bsp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Dolompu dem deŋmentər əm ti alna, kɔ məndekɔmɔmən kəway kem-ɛ. Mpɛ o mpɛ pɔ mənəŋk di alna cir dacɔ ta pɛntɛmsər, ta pɛncɛmcɛmər kɔ ŋkesiya dacɔ ta pɛncapsər alom mɔ, məcərɛ a iŋkiyər əm pi.» ");
INSERT INTO bsp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kɔ Labaŋ oloku Yakuba: «Awa! Iwosɛ toloku tam.» ");
INSERT INTO bsp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Awa, dɔsɔk dadɔkɔ dɔ, Labaŋ ɛncəmbər mbiyofo ya cəgbɛr, yɛcɛmcɛmər, cir cətɛmsər kɔ cəcɛmcɛmər cir ncɛ cənayɔ pəfer mɔ fəp, ŋkesiya yɔkɔ yɛnayɔ alom ŋɛcapsər mɔ. Kɔ Labaŋ ɛlɛk yi fəp, k'ɛmbɛr awut ɔn dəwaca. ");
INSERT INTO bsp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","K'awut ɔn ŋambɔlɛnɛ yɔcɔl yayɔkɔ, kəkɔt ka mata maas kɔ Yakuba dacɔ nwɛ ɛnckɛkəs sɔ yɔcɔl ya Labaŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kɔ Yakuba ɛlɛk wara wɛcaŋk wa tɔk maas yeciyanɛ, k'ɛnaci wi pol ntɛ tɔŋsɔŋɛ pəfer pa kətɔk powur mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kɔ Yakuba ɔndɔfət wara wawɔkɔ ɛnanaci mɔ nde yɔcɔl yoncmun mɔ, ntɛ tɔŋsɔŋɛ yɛcnəŋk wara wawɔkɔ mɔ, tɔsɔŋɛ yorkun yɛccɛc yɛran kɔ yender dəkəmun-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kɔ yɔcɔl yɛncɛcɛnɛ wara wawɔkɔ kəsək, ti tɛnasɔŋɛ yɔcɔl yockoməs mowut ma cəgbɛr, mɛtɛmsər kɔ mɛcɛmcɛmər. ");
INSERT INTO bsp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ntɛ Yakuba ɛŋgbɛy meŋkesiya mɔ, k'ɛncəmbər yi fɔr ya yɔcɔl ya Labaŋ kiriŋ nyɛ yɛnayɔ cəgbɛr kɔ alom ŋɛcapsər mɔ, k'ɔsɔtɔ yɔcɔl nyɛ ɛnacəmbər taciŋa ta owosɛ yɔnɔŋkəlɛnɛ kɔ ya Labaŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kəcɛc nkɛ o nkɛ yɔcɔl yetifi yorkun yɛcfaŋ kəcɛc yɛran mɔ, Yakuba ɛnclɛk wara wɔn wɛnaci pəcəmbər wi yɔcɔl fɔr kiriŋ dəndo yoncmun mɔ, ntɛ tɔŋsɔŋɛ yɛtam kəcɛcɛnɛ, yɛcnəŋk wara wawɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kɔ Yakuba ɛnəŋk a, pɔcɔl peleŋki pɛfaŋ kəcɛc-ɛ, ɔdɔf fɛ pi kəra kɔn kənaci. Kɔ tende tɛləpsər oŋ Yakuba kəyɔ yɔcɔl yetifi kɔ Labaŋ ɔyɔ yeleŋki. ");
INSERT INTO bsp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kɔ Yakuba ende pəyɔnɛ wəka daka wəpɔŋ. K'ɔyɔ yɔcɔl yɛfɛt yɛfɛt yɛlarəm, acar arkun, acar aran, yɔkɔmɛ kɔ sɔfale. ");
INSERT INTO bsp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kɔ Yakuba ene mɛcɛm-cɛmnɛ ma awut a Labaŋ, ŋacloku: «Yakuba ɛlɛk daka da papa kosu fəp, di dɔsɔŋɛ kɔ kəyɔnɛ ka wəka daka dandɛ fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kɔ Yakuba ɛŋgbɛkərɛ a kəro ka Labaŋ kəyi fɛ sɔ nnɔ eyi mɔ, pəmɔ tɔkɔ pənayi cɔkɔ-cɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kɔ MARIKI oloku Yakuba: «Məlukus atɔf ŋa awisi aŋa, dəŋkom dam. Isol'am.» ");
INSERT INTO bsp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kɔ Yakuba ewe Rasɛl kɔ Leya aŋɛ ŋanayi dalɛ ŋackɛk yɔcɔl yɔn cir kɔ ŋkesiya mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","K'oloku ŋa: «Iŋgbɛkərɛ a, kəro ka papa konu kəyi fɛ sɔ nnɔ iyi mɔ, pəmɔ tɔkɔ pənayi cɔkɔ-cɔkɔ mɔ. Mba Kanu ka papa kem kəsol'em. ");
INSERT INTO bsp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nəncərɛ nəna yati a imbəcɛ papa konu kɔ fənɔntər fem fəp. ");
INSERT INTO bsp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mba papa konu ɛŋkafəli-kafəli, k'encepɛ-cepɛ kəway kem haŋ wəco. Mba Kanu kəwosɛ fɛ kɔ kəy'em pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Pənaloku a yɛtɛmsər yɔyɔnɛ kəway kam-ɛ, kɔ yɔcɔl fəp yɛnader yockoməs awut atɛmsər. Pənaloku sɔ a ya cəgbɛr yɔyɔnɛ kəway kam-ɛ, yɔcɔl fəp kɔ awut a cəgbɛr yɔ yɛnader yockoməs. ");
INSERT INTO bsp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kanu kəmbaŋ yɔcɔl yɔn nnɔ papa konu eyi mɔ, kɔ kəsɔŋ im. ");
INSERT INTO bsp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Tɛm ntɛ yɔcɔl yɛncfaŋ kəcɛcɛnɛ mɔ, k'iyekti fɔr darenc, k'iwɛrəp a yɔcɔl yorkun nyɛ yɛnccɛc yɛran mɔ, yɛnayɔ cəgbɛr, yɛtɛmsər, yɛcɛmcɛmər. ");
INSERT INTO bsp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kɔ mɛlɛkɛ ma Kanu molok'im dəmere: ‹Yakuba!› K'iwosɛ: ‹In'ɛwɛ!› ");
INSERT INTO bsp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kɔ mɛlɛkɛ molok'im: ‹Məyekti fɔr məmɔmən. Yɔcɔl yorkun fəp nyɛ yeyi kəcɛc yɛran mɔ, yɔyɔ cəgbɛr kɔ yɛntɛmsər kɔ yɛcɛmcɛmər. Bawo inəŋk mɔyɔ mɔkɔ Labaŋ ɔy'əm mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","In'ɔyɔnɛ Kanu ka Betel, nde mənacəmbər tasar, kɔ məbɔy pi moro teta kəpus mɔ, nde mənadɛrm'im mɔ. Ndɛkəl oŋ, məyɛfɛ atɔf ŋaŋɛ, məlukus dəŋkom dam.›» ");
INSERT INTO bsp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasɛl kɔ Leya ŋaloku kɔ: «Mba səyɔ sɔ kɛ nnɔ kəlɔ ka papa kosu? ");
INSERT INTO bsp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mba ɔlɔm fɛ su oŋ pəmɔ acikəra ba, bawo ɛncaməs su, k'endi pəsam posu. ");
INSERT INTO bsp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Daka ndɛ Kanu kəmbaŋər papa kosu mɔ fəp, dendeyɔnɛ oŋ dosu k'awut asu. Məyɔ tɔkɔ Kanu kəlok əm mɔ fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kɔ Yakuba ɛyɛfɛ, k'ɛndəs awut ɔn yɔkɔmɛ kəroŋ kɔ aran ɔn. ");
INSERT INTO bsp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Kɔ Yakuba osolɛ yɔcɔl yɔn kəkɛk, kɔ daka dɔn fəp ndɛ ɛnasɔtɔ mɔ, yɔcɔl nyɛ ɛnasɔtɔ Padaŋ-Aram mɔ, k'ɔŋkɔ ndena papa kɔn Siyaka, atɔf ŋa Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kɔ Labaŋ ende pəkɔ kəgbɛt-gbɛt ŋkesiya yɔn. Kɔ Rasɛl eŋkiyɛ mɛrəŋka ma papa kɔn Labaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Kɔ Yakuba nkɔn entiŋkər Labaŋ wəAram ntɛ ɔnckɔ ndɔrɔn, ta elembərnɛ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kɔ Yakuba ɛyɛksɛ kɔ daka dɔkɔ ɛnayɔ mɔ fəp, k'ɛyɛfɛ k'empimnɛ kəŋgbɔkɔ, k'ɛntɛfərnɛ mɔrɔ ma Kaladu. ");
INSERT INTO bsp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tataka ta maas, k'aloku Labaŋ a Yakuba ɛyɛksɛ. ");
INSERT INTO bsp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kɔ Labaŋ ɛlɛk awɛnc aŋa kɔ ŋancəmɛ Yakuba darəŋ kəkɔt ka mata camət-mɛrəŋ, kɔ ŋambəp kɔ nde mɔrɔ ma Kaladu. ");
INSERT INTO bsp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kɔ Kanu kənder Labaŋ wəAram dəmere ma pibi, kɔ Kanu kəloku kɔ: «Məkɛmbərnɛ kəlok-lokər Yakuba.» ");
INSERT INTO bsp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Kɔ Labaŋ ɛmbəp Yakuba pəcəmbər abal ŋɔn tɔrɔ kəroŋ. Kɔ nkɔn sɔ dəmnɛ ɛncəmbər abal ŋɔn kɔ awɛnc aŋa tɔrɔ ta Kaladu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kɔ Labaŋ eyif Yakuba: «Cəke cɔ məyɔ tantɛ-ɛ? Ta ake tɔ məntiŋkər'em, məckekərɛ awut em aran pəmɔ afum aŋɛ asumpər dəkəwan mɔ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ta ake tɔ məŋgbɔpnɛnɛ kɔ məyɛksɛ-ɛ? Məntiŋkər f'em ba, məyɛksər f'em ba? K'inasak əm məkɔ pəbotu disrɛ, pacleŋəs, pacfula pacfer. ");
INSERT INTO bsp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Məwosɛ f'em kəcup awut-sɔ em arkun kɔ awut em aran! Tantɛ taŋ məmbut amera. ");
INSERT INTO bsp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Intam kəyɔ əm pəlɛc, mba Kanu ka papa kam kəlokus'em nendisna: ‹Məkɛmbərnɛ kəloku ka Yakuba pəlɛc!› ");
INSERT INTO bsp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Bawo pəŋwon əm kəkɔ ndena papa kam, ta ake tɔ məŋkiyɛnɛ canu cem-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kɔ Yakuba oloku Labaŋ: «Indenanesər-nesər ti kəcɛm-cɛmnɛ a, məndebaŋər im awut am aran. ");
INSERT INTO bsp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mba məmɔmən nwɛ o nwɛ məŋnəŋkɛ canu cam afum em dacɔ mɔ, wəkakɔ eŋfi! Awɛnc asu aŋa fɔr kiriŋ məmɔmən məlɛk mpɛ o mpɛ pɔyɔnɛ pam mɔ məkekərɛ.» Mba Yakuba ɛnacərɛ fɛ a Rasɛl eŋkiyər Labaŋ canu ca kusuŋka kəŋan. ");
INSERT INTO bsp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kɔ Labaŋ ɛmbɛrɛ abal ŋa Yakuba, k'owur k'ɛmbɛrɛ ŋa Leya, k'owur k'ɛmbɛrɛ abal ŋa acar aran aŋɛ mɛrəŋ, ɛnəŋk fɛ daka o daka. Kɔ Labaŋ ɛmbɛrɛ abal ŋa Rasɛl disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rasɛl pəlɛk mɛrəŋka pəboc mi dəntɔf, k'ɛlɛk dɔcɔm ndɛ aŋnɔnɛ yɔkɔmɛ kəroŋ mɔ k'endeŋər, k'ɛyɛfɛ k'ɛndɛ di kəroŋ. Kɔ Labaŋ efen-feni abal disrɛ fəp ɛnəŋk fɛ mɛrəŋka mmɛ. ");
INSERT INTO bsp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kɔ Rasɛl oloku papa kɔn: «Mariki mem, ta pətɛl'am, ntɛ intɔyɛfɛn'am mɔ, tɛntəŋnɛ iyɔ tɔkɔ teŋyi aran tɛm o tɛm mɔ.» Kɔ Labaŋ ɛntɛn mɛrəŋka mmɛ haŋ, ɛnəŋk fɛ. ");
INSERT INTO bsp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kɔ abəkəc ŋɛmpɛ Yakuba, k'ɛncaŋ Labaŋ kəcɔp. Kɔ Yakuba ɛlɛk moloku, k'oloku: «Deke iləsər-ɛ, deke inciya-ɛ tantɛ məncəm'em darəŋ mɔ? ");
INSERT INTO bsp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ntɛ məfen-feni ca yem fəp mɔ, ake mənəŋk-ɛ ca yam ya dukulɔ-ɛ? Məmentər im yi fɔr ya awɛnc im aŋa kɔ awɛnc əm aŋa ŋabɛrɛ su dacɔ ina kɔ məna. ");
INSERT INTO bsp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Meren wəco mɛrəŋ mɔ iyi nnɔ ndaram. Mba aŋkesiya ŋam ŋin, wir wan win wɛlɛcɛ fɛ kor, isɔmɛ f'am aŋkesiya yɔcɔl yam dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Iŋkɛrɛ f'am pɔcɔl pefi, in'ɛnasarɛ teta yi. Məncwer im kəsɔŋ ka kəway kɔ nyɛ anckiyər im pəwaŋkəra kɔ pibi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Inayi nnɔ nne yɔccɔf im pəwaŋkəra, kəfe kəcsut im pibi, mere mɔbɔlɛn'em. ");
INSERT INTO bsp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tɔsɔtɔ meren wəco mɛrəŋ ntɛ iyi nnɔ ndaram mɔ. Icbəc'am teta awut am aran meren wəco kɔ maŋkəlɛ, kɔ meren mmɛ camət-tin, ta yɔcɔl yam yɛfɛt yɛfɛt. Mba mənacepɛ-cepɛ kəway kem haŋ wəco. ");
INSERT INTO bsp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Pəyɔnɛ fɛ Kanu ka papa kem Abraham, Kanu Kəwɛy-wɛy ka Siyaka kəsol'em-ɛ, kɔ tantɛ tɔ məsak im ilukus waca wɔsɔkər. Kanu kənəŋk malap mem, kɔ kəlɔləs nkɛ inalɔləs waca mɔ, ti tɔ kəmbocɛsa su nendisna kiti.» ");
INSERT INTO bsp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Kɔ Labaŋ oloku Yakuba: «Awut arkun akaŋɛ, awut aran akaŋɛ kəbəp yɔcɔl yayɛ fəp yemi yɔ. Cəke c'intam mɔkɔ kəyɔnɛ awut em aran kɔ awut aŋɛ ŋaŋkom mɔ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ndɛkəl məder səsek danapa fɔr ya fum wəlɔma kiriŋ ina kɔ məna.» ");
INSERT INTO bsp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kɔ Yakuba ɛlɛk tasar tin, k'ɛncəmbər pi cos teta kəpus ka pi. ");
INSERT INTO bsp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Kɔ Yakuba oloku awɛnc aŋa: «Nəwɛtəs masar!» K'awɛnc aŋa ŋawɛtəs masar kɔ ŋamboc tɛpɛsa. Kɔ ŋandɛ tɛpɛsa papɔkɔ kəroŋ kɔ ŋandi yeri. ");
INSERT INTO bsp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Kɔ Labaŋ ewe tɛpɛsa papɔkɔ «Yekar Sahaduta,» kɔ Yakuba nkɔn ewe pi «Kaled.» ");
INSERT INTO bsp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kɔ Labaŋ oloku: «Tɛpɛsa pampɛ peyi su mɔkɔ dacɔ.» Ti tɔ asɔŋɛ pi tewe ta Kaled. ");
INSERT INTO bsp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tɛpɛsa papɔkɔ p'aŋwe sɔ Mispe, bawo Labaŋ ɛnaloku: «MARIKI kəgbɛkərɛ su ina kɔ məna kɔ səndesɔlərɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kɔ məntɔrəs awut em aran-ɛ, kɔ məlɛk sɔ aran alɔma-ɛ, məcərɛ a bafɔ fum eyi su dacɔ, mba Kanu yati.» ");
INSERT INTO bsp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kɔ Labaŋ oloku: «Tɛpɛsa pɛmpɛ, kɔ tasar tɔkɔ incəmbər ina kɔ məna dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tɛpɛsa pa masar pampɛ kɔ tasar pɛcəmbər cos pampɛ peyi su dacɔ kətəŋnɛ tes, a ifɔsɔcepər tɛpɛsa pampɛ kəkɔcaŋərn'am kəyɔ ka pəlɛc, məna sɔ ta məcepər tɛpɛsa pampɛ kɔ tasar pampɛ kəkɔcaŋərn'em kəkɔyɔ pəlɛc.» ");
INSERT INTO bsp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kɔ Labaŋ oloku: «Kanu ka Abraham kɔ Nahor, kɔ Kanu ka kas kəŋan kəyi su dacɔ.» Kɔ Yakuba ɛndɛrmɛ Kanu Kəwɛy-wɛy ka papa kɔn Siyaka. ");
INSERT INTO bsp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kɔ Yakuba oloŋnɛ tɔrɔ tatɔkɔ kəroŋ, k'ewe awɛnc aŋa kədedi yeri yayɔkɔ. Kɔ ŋandi yeri yayɔkɔ kɔ ŋandirɛ tɔrɔ papɔkɔ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kɔ Labaŋ ɛyɛfɛ bətbət suy, k'oncup awut-sɔ ɔn arkun k'aran, k'ontolanɛ ŋa, k'osumpər dɔpɔ kəlukus ka nde ndɔrɔn. ");
INSERT INTO bsp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kɔ Yakuba sɔ ɛncəmɛ dɔpɔ dɔn darəŋ, kɔ mɛlɛke a Kanu ŋancɛpsɛ kɔ darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakuba endenəŋk mi, k'oloku: «Afan ŋa Kanu ŋɔ!» K'ɔsɔŋ tofo tatɔkɔ tewe ta Mahanayim. ");
INSERT INTO bsp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakuba pəyi tadarəŋ k'osom nda wɛnc Esayu nwɛ ɛnayi kulum ka Edɔm mɔ, atɔf ŋa Sehir. ");
INSERT INTO bsp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kɔ Yakuba osom ŋa ntɛ: «Ntɛ tɔ nəŋkɔloku mariki wɛnc im Esayu: ‹A wəcar kam Yakuba-ɛ, a iŋkɔ iwon nda Labaŋ haŋ. ");
INSERT INTO bsp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Iyɔ cəna, sɔfale, ŋkesiya, cir, acar arkun kɔ aran. Ti t'isom'am nnɔ mariki wɛnc im eyi mɔ, pəctam kəwosɛ ibɛrɛ.›» ");
INSERT INTO bsp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","K'asom ŋaluksərnɛ nnɔ Yakuba eyi mɔ, kɔ ŋaloku kɔ: «Səŋkɔ nda wɛnc əm Esayu, nkɔn sɔ kəlompəsnɛ k'ɛndɛ kədebəp əm, kɔ afum 400.» ");
INSERT INTO bsp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","K'abəkəc ŋɔntɔfəntərɛ Yakuba, kɔ kənesɛ kəsumpər kɔ. K'eyer afum akɔ ŋanasol mɔ cəgba mɛrəŋ, kəbəp ŋkesiya, cir, cəna haŋ yɔkɔmɛ. ");
INSERT INTO bsp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kɔ Yakuba oloku: «Kɔ Esayu ɛntam afum a kəgba kin-ɛ, a kɔ ŋaŋyɛksɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Kɔ Yakuba oloku: «Kanu ka papa kem Abraham, Kanu ka papa kem Siyaka, MARIKI nwɛ olok'im: ‹Məlukus atɔf ŋam nde aŋkom əm mɔ, indeyɔn'am pətɔt!› ");
INSERT INTO bsp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ifɛtər layidi kɔ pətɔt mpɛ məŋkɛr'em mɔ, ina wəcar kam. Bawo ntɛ inccepər Yurdɛn yayɛ mɔ, togbo tem gbəcərəm t'inatɔmpər, ndɛkəl oŋ iyer afum em cəgba mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ilɛtsɛn'am məbaŋ im, wɛnc im Esayu dəwaca! Bawo iŋnesɛ ta pədesut im, kɔ iya ka awut em. ");
INSERT INTO bsp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kɔ məna Kanu mənalok'im: ‹Indey'əm pətɔt, indeyɔ yuruya yam ŋala pəmɔ asənc ŋa dəkəba, nŋɛ antɔtam kəlɔm mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Difɔ Yakuba ɛnacepərɛnɛ pibi. K'ɛyɛk-yɛk daka dɔn dɔkɔ ɛnakɛrɛ mɔ dacɔ kəkɔpocɛ wɛnc Esayu: ");
INSERT INTO bsp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Cir masar mɛrəŋ (200), mbiyofo wəco mɛrəŋ (20), ŋkesiya yɛran masar mɛrəŋ (200) kɔ yorkun wəco mɛrəŋ (20), ");
INSERT INTO bsp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","kɔ yɔkɔmɛ yɛran wəco maas (30) kɔ awut ayi akɔ yɛncmɛsər mɔ, cəna cəran wəco maŋkəlɛ (40), mura wəco (10), sɔfale səran wəco mɛrəŋ (20) kɔ sərkun wəco (10). ");
INSERT INTO bsp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kɔ Yakuba ɔsɔŋ yɔcɔl yayɔkɔ fəp fa yi kɔ dokom da yi acar ɔn, k'oloku ŋa: «Nəy'im kiriŋ, nəsolɛ yɔcɔl yayɛ dokom dokom, nəbɔlɛnɛ yi kɔ yɔkɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","K'osom wəcɔkɔ-cɔkɔ: «Kɔ nəŋkɔbəpɛnɛ kɔ wɛnc im Esayu a pəyif əm: ‹An'ɔ məyɔnɛ? Deke məŋkɔ-ɛ? An'ɔyɔ yɔcɔl yayɛ məsolɛ mɔ-ɛ?› ");
INSERT INTO bsp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Məloku kɔ: ‹Ya wəcar kam Yakuba yɔ, kəpocɛ kɔ nkɛ ɔsɔŋ im a ikenɛ mariki mem Esayu mɔ. Mba nkɔn ɔfɔ wəkɔ ender im tadarəŋ mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","K'osom sɔ kəsom kin kaŋkɔ, asolɛ yɔcɔl ya mɛrəŋ, ya maas kəbəp ka alpəs akɔ ŋanayi tadarəŋ ŋasolɛ yɔcɔl mɔ: «Tatɔkɔ tɔ nəŋkɔloku Esayu kɔ nəŋkɔbəpɛnɛ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nəloku kɔ: ‹Wəcar kam Yakuba ender su wəkɔ tadarəŋ.›» Bawo Yakuba ɛnaloku: «Kəpocɛ kaŋkɛ kəy'im kiriŋ mɔ, ik'iŋkɔtor-torɛnɛ kɔ abəkəc, a sədenəŋkɛnɛ fɔr disrɛ. Tɔlɔma endekɔselɛn'em belbel.» ");
INSERT INTO bsp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kɔ yopocɛ yayɔkɔ yeyi kɔ kiriŋ, k'encepərɛnɛ pibi papɔkɔ dəndo dəkulum. ");
INSERT INTO bsp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kɔ Yakuba ɛyɛfɛ pibi papɔkɔ, k'ɛlɛk aran ɔn mɛrəŋ, amarəs aran ɔn mɛrəŋ k'awut ɔn wəco kɔ pin, k'ɛncalɛnɛ ŋa dəŋgbəl da Yabɔk. ");
INSERT INTO bsp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ntɛ Yakuba ɛlɛk aran ɔn, k'ɛncalɛnɛ ŋa dəŋgbəl kɔ daka dɔkɔ ɛnayɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kɔ Yakuba eyi di sona. Pəndebiyɛ, kɔ fum wəlɔma ɛyɛfɛ kəsiməs kɔ Yakuba haŋ dɔsɔka. ");
INSERT INTO bsp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ntɛ wəsimsɛnɛ kɔn ɛnəŋk, eyi fɛ kətam kɔ mɔ, k'osut kɔ nnɔ dətɔkɔc. Kɔ tɔkɔc ta Yakuba towur pəcsiməs kɔ fum wəkakɔ. ");
INSERT INTO bsp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kɔ fum wəkakɔ oloku: «Məsak im ikɔ, bawo pəyi kəyɔ panpan.» Kɔ Yakuba oloku kɔ: «Ifɔsak əm məkɔ ta məntolan'em-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kɔ fum wəkakɔ eyif Yakuba: «Cəke c'aŋw'am-ɛ?» Kɔ Yakuba oloku: «Yakuba y'aŋw'em.» ");
INSERT INTO bsp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kɔ fum wəkakɔ oloku kɔ sɔ: «Yakuba yɔfɔsɔyɔnɛ tewe tam, Yisrayel ŋ'ande pacw'am, bawo məsiməs kɔ Kanu kɔ afum, kɔ məntam ŋa.» ");
INSERT INTO bsp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kɔ Yakuba eyif fum wəkakɔ: «Ilɛtsɛn'am məboncər im tewe tam.» Kɔ fum nwɛ eyif kɔ: «Ta ake tɔ məfaŋɛ kəcərɛnɛ tewe tem-ɛ?» Kɔ fum nwɛ ontolanɛ Yakuba dəndo. ");
INSERT INTO bsp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Kɔ Yakuba ɔsɔŋ tofo tatɔkɔ tewe ta Peniyɛl, bawo nkɔn olokunɛ: «Inəŋk Kanu səgbətnɛnɛ, k'intɔfi.» ");
INSERT INTO bsp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Dec dɛncpɛ a pəccepər Peniyɛl. Yakuba pəctorər tɔkɔc tɔn. ");
INSERT INTO bsp_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Ti tɔsɔŋɛ ntɛ awut a Yisrayel ŋantɔsɔm abənta ŋa dətɔkɔc mɔ, bawo abənta ŋa dətɔkɔc ŋɔ Kanu kənasut Yakuba, nde kəbɛnt ka dəkəcək kɔ kəbɛnt ka dəkumunt yɛmbəpɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kɔ Yakuba eyekti kəro k'ɛnəŋk Esayu pəcder pəsɔlɛ afum tasar tin (100). Kɔ Yakuba eyer awut Leya, Rasɛl, kɔ acar aŋɛ mɛrəŋ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kɔ Yakuba ɛncəmbər aran ɔn acar kiriŋ, k'awut aŋan ŋancɔnc ŋa, kɔ Leya ɛncɛk k'awut ɔn ŋayi kɔ darəŋ, kɔ Rasɛl ɛncəmɛ kɔ wan kɔn Isifu eyi kɔ darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kɔ nkɔn yati encepər ŋa fɔr kiriŋ, k'ontontnɛnɛ Esayu dəntɔf camət-mɛrəŋ, haŋ k'ɔlɔtərnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kɔ Esayu ɛyɛksɛ kəkɔbəpɛnɛ kɔ Yakuba wɛnc, k'ɛsapnɛ kɔ, k'ɛnɛpsərnɛ kɔ dəkilim, k'oncup kɔ, kɔ ŋayɛfɛ fəp faŋan kəbok. ");
INSERT INTO bsp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kɔ Esayu eyekti kəro, k'ɛnəŋk aran kɔ awut, k'eyif: «Are ŋɔ akaŋɛ?» Kɔ Yakuba oloku kɔ: «Awut akaŋɛ ŋɔ Kanu kənamar im kəsɔtɔ nɔnɔfɔr dɔn disrɛ, ina wəcar kam.» ");
INSERT INTO bsp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kɔ aran ɔn acar ŋalɔtərnɛ Esayu, kɔ awut aŋan, kɔ ŋantontnɛnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kɔ Leya ɔlɔtərnɛ kɔ sɔ kɔ awut ɔn, kɔ ŋa sɔ ŋantontnɛnɛ kɔ, kɔ Isifu kɔ Rasɛl ŋalɔtərnɛ kɔ, kɔ ŋantontnɛnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kɔ Esayu eyif kɔ: «Ake məndeyɔnɛ yɔcɔl yayɛ səncepər-cepər mɔ?» Kɔ Yakuba oloku kɔ: «Kətəŋnɛ ka məna mariki mem k'inafaŋ. Ti t'inacɛm-cɛmnɛ kəsɔŋ əm yi.» ");
INSERT INTO bsp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kɔ Esayu oloku Yakuba: «Yɛlar im ina wɛnc im, məmɛŋkərnɛ yayɛ yɔyɔnɛ yam.» ");
INSERT INTO bsp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kɔ Yakuba oloku Esayu: «Ala. Ilɛtsɛn'am, kɔ pəyɔnɛ a isɔtər əm kətəŋnɛ, məwosɛ məbaŋ kəpocɛ kem. Ti t'imɔmənɛ kəro kam pəmɔ tɔkɔ aŋmɔmən kəro ka Kanu mɔ, kɔ məselɛn'em belbel. ");
INSERT INTO bsp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Məbaŋ kəpocɛ kem nkɛ isɔŋ əm mɔ, bawo Kanu kəmar im k'isɔtɔ daka dɔkɔ ifaŋ mɔ fəp.» Kɔ Yakuba ɛncəmɛnɛ ti Esayu darəŋ haŋ kɔ wəkakɔ owosɛ kəbaŋ ka kəpocɛ kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kɔ Esayu oloku: «Paŋkɔn, pasolnɛ dɔpɔ, in'endey'əm kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kɔ Yakuba oloku: «Mariki mem, məncərɛ a awut ŋancuca kəkɔtɛnɛ, k'isolɛ sɔ mir mowut kɔ mana mɛmɛsɛ. K'ayɔ yi yɔkɔt pəpɔŋ dɔsɔk din-ɛ yɔcɔl yowut fəp yeŋfi. ");
INSERT INTO bsp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mariki mem məy'im kiriŋ, indey'əm tadarəŋ, pəpic-pəpic isurɛnɛ yɔcɔl k'awut pɔkɔt, haŋ ibɛrɛ ndena wɛnc im nde atɔf ŋa Sehir.» ");
INSERT INTO bsp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kɔ Esayu oloku: «Isakər'am afum em alɔma akɔ isolɛ mɔ.» Kɔ Yakuba eyif Esayu: «Ak'indeyɔnɛ ŋa-ɛ? Tɛfaŋ ta ina, isɔtɔ kəŋaŋnɛ nnɔ məna mariki mem meyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Dɔsɔk dadɔkɔ dɔ Esayu ɛlɛk dɔpɔ kəlukus ka Sehir. ");
INSERT INTO bsp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kɔ Yakuba ɔŋkɔ dare da Sukɔt. K'ɔlɔ kəlɔ kɔn k'ɔlɔnɛ yɔcɔl yɔn ŋgbancan. Ti t'asɔŋɛ tofo tatɔkɔ tewe ta «Sukɔt». ");
INSERT INTO bsp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kɔ Yakuba ɛmbɛrɛ kətamnɛ disrɛ dare da Səkɛm, atɔf ŋa Kanaŋ. K'ɔŋkɔ pəcəmbərəs dare kəsək kəbɛrɛ kɔn kəyɛfɛ ka Padaŋ-Aram. ");
INSERT INTO bsp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","K'ɛway awut a Hamɔr arkun dəwaca, papa ka Səkɛm, tofokəl ta antɔf nde ɛnacəmbər abal mɔ. Ɛnaway di mɛncəmbəl tasar tin (100). ");
INSERT INTO bsp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kɔ Yakuba ɛncəmbər di tetek toloŋnɛ Kanu, k'ewe tofo tatɔkɔ «El-Elohe-Yisrayel». ");
INSERT INTO bsp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, wan wəran nwɛ Leya ɛnakomɛ Yakuba mɔ, ɛyɛfɛ kəkɔnəŋk awut aran a dɔtɔf. ");
INSERT INTO bsp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Səkɛm, wan ka Hamɔr wəHewy wəbɛ wəka dɔtɔf, ɛnəŋk kɔ, k'ɛmbaŋ kɔ, k'ombocərnɛ kɔ, k'ɛlapəs kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Kɔ Səkɛm esektərnɛ teta Dina wan wəran ka Yakuba, haŋ dəmoloku mɔn k'ɛsɛp kəsɔtɔ ka kəbɔtər ka Dina. ");
INSERT INTO bsp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kɔ Səkɛm oloku papa kɔn Hamɔr: «Məsɔŋ im wəyecəra wəkawɛ pəyɔnɛ wəran kem wənɛncɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kɔ Yakuba ende pəcərɛ a Səkɛm ɛncərɛ wan kɔn Dina dɛran. Mba ntɛ awut a Yakuba arkun ŋanayi dalɛ kɔ yɔcɔl yɔn mɔ, kɔ Yakuba ɛncaŋkɛ ti haŋ kɔ ŋander kəyɛfɛ dalɛ. ");
INSERT INTO bsp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kɔ Hamɔr papa ka Səkɛm ɔŋkɔ pəlok-lokər Yakuba. ");
INSERT INTO bsp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kɔ awut a Yakuba ŋander kəyɛfɛ dalɛ. Ntɛ ŋane moloku mamɔkɔ mɔ, kɔ mosumpər ŋa. Kɔ pəntɛlɛ ŋa, bawo Səkɛm ɛnayɔ tɔyɔ ntɛ pənatɔmar paŋaŋnɛnɛ kɔ Yisrayel mɔ: Kəkiyɛ kəcərɛ Dina wan ka Yakuba dɛran, ta ŋayɔnɛ akin ayi-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kɔ Hamɔr oloku ŋa ntɛ: «Wan kem Səkɛm ɛfaŋ kəfaŋ dəm wəkirɛ konu Dina kənɛncɛ, nəsɔŋ kɔ kɔ pənɛncɛ, ilɛtsɛnɛ nu. ");
INSERT INTO bsp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Antam kəkotərɛnɛ pacnɛncɛnɛnɛ. Nəde nəcsɔŋ su awut anu aran, nəclɛk awut asu aran. ");
INSERT INTO bsp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nəndendɛ kɔ səna, atɔf ŋendeyi nu dəwaca pəmɔ səna, nəyi dɛ, nəccaməs, nətɛn sɔ dɛ ntɔf.» ");
INSERT INTO bsp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kɔ Səkɛm oloku papa kɔ awɛnc a Dina: «K'isɔtər nu kəwosɛ-ɛ, iŋsɔŋ nu mpɛ o mpɛ nəŋwer im mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Nəwer im kəfac kəpɔŋ kɔ yopocɛ yɛlarəm. Iŋsɔŋ nu yi. Mba nəsɔŋ wəyecəra wəkawɛ Səkɛm pənɛncɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kɔ awut a Yakuba arkun ŋantiŋkər Səkɛm kɔ kas bawo Səkɛm ɛnakiyɛ kəcərɛ ka wəkirɛ kəŋan dɛran. ");
INSERT INTO bsp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kɔ awut a Yakuba ŋaloku Səkɛm kɔ kas: «Pəncuca su kəsɔŋ wəkirɛ kosu, fum nwɛ antɔkənc mɔ, bawo tendeyɔnɛ kəlapəs kosu. ");
INSERT INTO bsp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kɔ səndewosɛ tɛfaŋ tonu-ɛ, mɛnɛ nəna sɔ nəwosɛ kəyi pəmɔ səna, ti tɔ tatɔkɔ arkun aŋɛ ŋayi nu dacɔ mɔ fəp pakənc ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tɛm tatɔkɔ səŋwosɛ kəclɛk awut anu aran sənɛncɛ, nəna sɔ dəmnɛ nəclɛk akosu nəcnɛncɛ. Səndɛ nnɔ kɔ nəna payɔnɛ sɔ afum akin ayi. ");
INSERT INTO bsp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mba kɔ nəntɔtam kəne tɔkɔ səloku a pakənc nu mɔ, səŋlɛk wan kosu Dina, səkɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamɔr kɔ wan kɔn Səkɛm ŋawosɛ moloku mamɔkɔ, kəwosɛ a pakənc ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kɔ wan wərkun nwɛ oncop tɔyɔ tatɔkɔ, bawo ɛnabɔtər Dina haŋ pəcepərər. Nkɔn Səkɛm sɔ, anabɔtər kɔ nde ndaraŋan patas aka di fəp. ");
INSERT INTO bsp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamɔr kɔ Səkɛm ŋaŋkɔ nde dəkəbɛrɛ da dare daŋan, kɔ ŋaloku afum a dare: ");
INSERT INTO bsp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Afum akaŋɛ ŋasɔkɛ su bəkəc. Ŋawosɛ kəndɛ atɔf ŋaŋɛ ŋaccaməs, atɔf ŋaŋɛ ŋɔwɔkəl ŋa. Ande paclɛkərɛnɛ aran kɔ ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mba afum akaŋɛ kəwosɛ kəŋan kəndɛ kɔ səna, payɔnɛ akin ayi, mɛnɛ pawosɛ arkun aŋɛ ŋayi su dacɔ mɔ fəp, pakənc ŋa pəmɔ ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yɔcɔl yaŋan kɔ ca yaŋan fəp yɔfɔdeyɔnɛ yosu ba? Pawosɛ tɛfaŋ taŋan gbəcərəm, ŋayi su dɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Akɔ ŋanakɔ dəkəbɛrɛ da dare daŋan mɔ fəp, kɔ ŋancəŋkəl Hamɔr kɔ wan kɔn Səkɛm. Arkun akɔ ŋanader dəkəbɛrɛ da dare daŋan dəkəcəŋkəl mɔ fəp, k'aŋkənc ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tataka ta maas ta kəkənc kəŋan, akənc ŋayi kəcunɛnɛ, kɔ awut a Yakuba mɛrəŋ, Simeyɔŋ kɔ Lewy awɛnc arkun a Dina, ŋalɛkəs sakma səŋan kɔ ŋander ŋacop dəkəbɛrɛ da dare daŋan, nde afum a di ŋanacɛm-cɛmnɛ kəyi pəforu disrɛ mɔ. Simeyɔŋ kɔ Lewy ŋawɛkərnɛ arkun a dɔtɔf kədifət haŋ kɔ ŋalip ŋa fəp. ");
INSERT INTO bsp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Kɔ ŋandifɛnɛ sɔ Hamɔr kɔ Səkɛm sakma səŋan, kɔ ŋalɛk wəkirɛ kəŋan Dina ndena Səkɛm kɔ ŋaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","K'awut a Yakuba ŋawɛkərnɛ sɔ afi, kɔ ŋaŋkiyər aka dare bawo mɛtɛlɛ mɛnayi ŋa kəlapəs ka wəkirɛ kəŋan Dina. ");
INSERT INTO bsp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kɔ ŋalɛk ŋkesiya, cir, cəna, sɔfale, yɔcɔl yɔkɔ yɛnayi dare disrɛ kɔ dəkulum mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Kɔ awut a Yakuba ŋawɛtəs ca ya afi, awut aŋan, aran aŋan, kɔ ca yɔkɔ ŋanabəp nda Səkɛm kɔ Hamɔr mɔ fəp kɔ ŋaŋkekərɛ. ");
INSERT INTO bsp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kɔ Yakuba oloku Simeyɔŋ kɔ Lewy: «Nəyɔ em pəlɛc tetonu tendesɔŋɛ aka Kanaŋ kɔ aka Perisi ŋadeter im! Nəncərɛ a səmpicɛ, kəbɛrɛnɛ kɔ ŋander kədesutɛnɛ kɔ ina, tɛm tatɔkɔ ŋandesut im ŋaləsər afum em.» ");
INSERT INTO bsp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Kɔ awut a Yakuba ŋaloku kas kəŋan: «Səndewosɛ Səkɛm pəyɔ wəkirɛ kosu pəmɔ wəran wəyi yamayama ba?» ");
INSERT INTO bsp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kɔ Kanu kəloku Yakuba: «Məyɛfɛ məpɛ məkɔ məndɛ Betel, məlompəs di tetek toloŋnɛ Kanu nkɛ kənawurər əm, ntɛ mənayɛksər wɛnc əm Esayu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kɔ Yakuba oloku afum ɔn, kɔ akɔ ŋanayi kɔ nkɔn mɔ: «Nəwurɛ nu dacɔ canu cəcikəra. Nəsɔkəsnɛ, nəsəkpər yɛbɛrnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kəyɛfɛ k'ander, papɛrnɛ Betel. Dəndo iŋkɔcəmbər tetek toloŋnɛ Kanu nkɛ kənalok-lokər im dɔsɔk ndɛ inayi pəcuca disrɛ, a kɔ kəsol'em tɛm ntɛ inayi dɔpɔ ickɔ decikəra mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kɔ ŋasɔŋ Yakuba canu cəcikəra ncɛ cənayi ŋa dəwaca mɔ fəp, kəbəp ya dələŋəs yaŋan. Kɔ Yakuba ɛmət yi nde kətɔk kəpɔŋ kəŋkɔ kəyi Səkɛm kəsək mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kɔ ŋaŋkɔ. Kɔ ayek-yek ŋa Kanu ŋɛŋgbəpərnɛ aka sədare səkəsək fəp, kɔ ŋantɔtam kəcəmɛ awut a Yakuba darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kɔ Yakuba ŋambɛrɛ kɔ akɔ ŋanacəmɛ kɔ darəŋ mɔ fəp, kəkɔ ka Lus, ti tɔ tatɔkɔ dare da Betel, atɔf ŋa Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","K'ɛncəmbər di tetek toloŋnɛ Kanu, k'ewe tofo tatɔkɔ «El-Betel», bawo difɔ Kanu kənawurər kɔ tɛm ntɛ ɛnayɛksər wɛnc mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kɔ Debora, wəran nwɛ ɛnadusum Rebeka mɔ, efi. K'awup kɔ Betel tantɔf, nde aŋkiri dəntɔf nŋɛ awe tewe ta «Kətɔk ka Mɛncər» mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kɔ Kanu kəwurər sɔ Yakuba, ntɛ ɛmbɛrɛ Padaŋ-Aram mɔ, kɔ kəmpocɛ kɔ pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kɔ Kanu kəloku kɔ: «Mən'aŋwe Yakuba, mba afɔsɔw'am tewe ta Yakuba tatɔkɔ. ‹Yisrayel› ŋ'ande pacw'am oŋ.» Kɔ Kanu kəsɔŋ kɔ oŋ tewe ta Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kɔ Kanu kəloku kɔ: «In'ɔyɔnɛ Kanu nkɛ kəntam mes fəp mɔ. Məyɔnɛ wəkombəra, məla. Afum a tɔf yɛlarəm ŋɔ məndekom, abɛ ŋandewur əm dəris. ");
INSERT INTO bsp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Atɔf nŋɛ isɔŋ Abraham kɔ Siyaka mɔ, indesɔŋ əm ŋi kɔ yuruya yam kɔ məndecepər-ɛ. Indesɔŋ ŋa atɔf ŋaŋɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kɔ Kanu kəmbɔlɛ kɔ day, nde kənalok-lokər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Kɔ Yakuba ɛncəmbər tasar da kəfo kaŋkɔ Kanu kənalok-lokər kɔ mɔ. K'oloŋər pi member kɔ moro mɔbɔy teta kəpusɛ ka pi Kanu. ");
INSERT INTO bsp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kɔ Yakuba ɔsɔŋ tofo tatɔkɔ tewe ta Betel, nde Kanu kənalok-lokər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakuba ɛyɛfɛ Betel kɔ afum ɔn. Ŋanawak kəbɔlɛ sɔ kəbɛrɛ ka Efrata, kɔ Rasɛl oŋkom, kəkom kəcuy. ");
INSERT INTO bsp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Eyi pəcuy pa kəkom kaŋkɔ, kɔ wəbaŋ kɔn wan oloku: «Ta mənesɛ, bawo məsɔtɔ sɔ wan wərkun!» ");
INSERT INTO bsp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ntɛ Rasɛl encfi mɔ, k'ewe wan wəkakɔ Bɛn-Oni. Mba kɔ kas ewe kɔ Beŋyamin. ");
INSERT INTO bsp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kɔ Rasɛl efi. K'awup kɔ nde dɔpɔ da Efrata, nde Betlɛhɛm. ");
INSERT INTO bsp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kɔ Yakuba ɛncəmbər tasar nde kufu ka Rasɛl, tasar popus papɔkɔ ɛnacəmbər kufu ka Rasɛl mɔ, pɔsɔrɔyi di haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kɔ Yakuba ɔŋkɔ, pəcəmbər abal nde Mikədal-Edɛr takəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ntɛ Yakuba eyi atɔf ŋaŋɔkɔ mɔ, kɔ Ruben ɔŋkɔ pəfəntərər Bilha wəlakɔ ka papa kɔn, kɔ Yakuba ɛncərɛ ti. Yakuba ɛnasɔtɔ awut arkun wəco kɔ mɛrəŋ: ");
INSERT INTO bsp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Awut a Leya: Ruben coco ca Yakuba, Simeyɔŋ, Lewy, Yuda, Isakar, kɔ Sabulon. ");
INSERT INTO bsp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Awut a Rasɛl: Isifu kɔ Beŋyamin. ");
INSERT INTO bsp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Awut a Bilha, wəmarəs ka Rasɛl: Dan kɔ Naftali. ");
INSERT INTO bsp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Awut a Silpa, wəmarəs ka Leya: Kadu kɔ Asɛr. Awut a Yakuba ŋanayi akakɔ, aŋɛ ɛnakom Padaŋ-Aram mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kɔ Yakuba ender kas Siyaka kəsək, nde Mamre, nde Kiriyat Arba, nde pəyɔnɛ Hebərɔŋ mɔ, a kɔ Abraham kɔ Siyaka ŋanayi decikəra mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Kəwon ka Siyaka doru kənasɔtɔ meren tasar tin kɔ wəco camət maas (180). ");
INSERT INTO bsp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","K'eŋgbiŋ kifir. K'efi, k'ɔnɔŋkəl atem ɔn akɔ ŋanafi mɔ, Siyaka ɛnasikər, doru dɛtəŋnɛ kɔ. K'awut ɔn Esayu kɔ Yakuba ŋawup kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dokombəra da Esayu dɔ dandɛ, nwɛ aŋwe sɔ Edɔm mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Kɔ Esayu ɛlɛk aran ɔn, aran a Kanaŋ dacɔ: Ada, wan wəran ka Elon wəHewy, Oholibama wan wəran ka Ana, wan wəran ka Cibehɔŋ wəHewy, ");
INSERT INTO bsp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basmat wan wəran ka Səmayila, wəkirɛ ka Nebayɔt. ");
INSERT INTO bsp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Kɔ Ada oŋkomɛ Esayu Elifas, kɔ Basmat oŋkom Rehuwɛl. ");
INSERT INTO bsp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Kɔ Oholibama oŋkom Yehus, Yahelam, kɔ Korah. Awut a Esayu ŋɔ akakɔ aŋɛ anakomɛ kɔ Kanaŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kɔ Esayu ɛlɛk aran ɔn, awut ɔn arkun kɔ aran, afum ɔn aka kəlɔ kɔn, yɔcɔl yɔn kɔ ca yɔkɔ ɛnasɔtɔ atɔf ŋa Kanaŋ mɔ fəp, k'ɔŋkɔ atɔf ŋɔlɔma. K'ɔmbɔlɛ wɛnc Yakuba, ");
INSERT INTO bsp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","bawo yɔcɔl yɛnalar ŋa, ta ŋantam kəyi tofo tin-ɛ. Atɔf nŋɛ ŋanayi mɔ ŋɛnafɛtər ŋa teta yɔcɔl yaŋan yɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kɔ Esayu ɛndɛ nde mɔrɔ ma Sehir. Esayu, nkɔn ancwe sɔ Edɔm. ");
INSERT INTO bsp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dokombəra da Esayu, dɔ dandɛ wətem ka yuruya nyɛ aŋwe Edɔm mɔ, nde mɔrɔ ma Sehir kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Mewe ma awut a Esayu mɔ mamɛ: Elifas wan ka Ada wəran ka Esayu, Rehuwɛl wan ka Basmat wəran ka Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Awut a Elifas ŋanayɔnɛ: Teman, Omar, Sefo, Kahetam, kɔ Kenas. ");
INSERT INTO bsp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna wəlakɔ ka Elifas ɛnayi wan ka Esayu. K'oŋkomɛ Elifas Amalɛk. Awut a Ada ŋɔ akakɔ wəran ka Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Mewe ma awut a Rehuwɛl mɔ mamɛ: Nahat, Serah, Sama, kɔ Misa. Awut a Basmat ŋɔ akakɔ wəran ka Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Mewe ma awut a Oholibama wan wəran ka Ana, wansɔ ka Cibehɔŋ, wəran ka Esayu: K'oŋkomɛ Esayu Yehus, Yahelam, kɔ Korah. ");
INSERT INTO bsp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mewe ma abɛ a yuruya ya Esayu mɛmɛ: Awut abɛ a Elifas, coco ca Esayu: Wəbɛ Teman, wəbɛ Omar, wəbɛ Sefo, wəbɛ Kenas, ");
INSERT INTO bsp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","wəbɛ Korah, wəbɛ Kahetam, kɔ wəbɛ Amalɛk. Abɛ a Elifas ŋɔ akakɔ, atɔf ŋa Edɔm. Awut a Ada ŋɔ akakɔ. ");
INSERT INTO bsp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Awut a Rehuwɛl, wan ka Esayu ŋɔ akaŋɛ: Wəbɛ Nahat, wəbɛ Serah, wəbɛ Sama, kɔ wəbɛ Misa. Abɛ a Rehuwɛl ŋɔ akakɔ atɔf ŋa Edɔm. Awut a Basmat ŋɔ akakɔ, wəran ka Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Awut a Oholibama ŋɔ akaŋɛ, wəran ka Esayu: Wəbɛ Yehus, wəbɛ Yahelam, kɔ wəbɛ Korah. Abɛ a Oholibama ŋɔ akaŋɛ wan wəran ka Ana, wəran ka Esayu. ");
INSERT INTO bsp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Awut a Esayu ŋɔ akakɔ, kɔ abɛ aŋan. Esayu nwɛ ancwe sɔ «Edɔm» mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Awut a Sehir wəHori ŋɔ akaŋɛ: Lotaŋ, Sobal, Cibehɔŋ, Ana, ");
INSERT INTO bsp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disɔŋ, Eser, kɔ Disaŋ. Abɛ aHori ŋɔ akakɔ, awut a Sehir nde atɔf ŋa Edɔm. ");
INSERT INTO bsp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Awut a Lotaŋ ŋanayɔnɛ Hori kɔ Hemam. Wəkirɛ ka Lotaŋ ɛnayɔnɛ Timna. ");
INSERT INTO bsp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Awut a Sobal ŋanayɔnɛ Alwaŋ, Manahat, Ebal, Sefo, kɔ Onam. ");
INSERT INTO bsp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Awut a Cibehɔŋ ŋanayɔnɛ Aya kɔ Ana. Ana wəkakɔ ɛnafir kələmp nde dətɛgbərɛ, pəkɔ dəŋkɛk sɔfale sa papa kɔn Cibehɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Awut a Ana ŋanayɔnɛ Disɔŋ kɔ Oholibama, wan ka Ana wəran. ");
INSERT INTO bsp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Awut a Disaŋ ŋanayɔnɛ: Hemdaŋ, Esbaŋ, Yitəran, kɔ Keran. ");
INSERT INTO bsp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Awut a Eser ŋanayɔnɛ: Bilaŋ, Sawaŋ, kɔ Akaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Awut a Disaŋ ŋanayɔnɛ Huc kɔ Araŋ. ");
INSERT INTO bsp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Abɛ a Hori ŋɔ akaŋɛ: Wəbɛ Lotaŋ, wəbɛ Sobal, wəbɛ Cibehɔŋ, wəbɛ Ana, ");
INSERT INTO bsp_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","wəbɛ Disɔŋ, wəbɛ Eser, wəbɛ Disaŋ. Abɛ a Hori ŋa akakɔ, abɛ aŋan atɔf ŋa Sehir. ");
INSERT INTO bsp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tɛm tatɔkɔ abɛ ŋanatɔmpər fɛ kərɛsna dɛbɛ nde atɔf ŋa Yisrayel. Mewe ma abɛ aŋɛ ŋanacepər atɔf ŋa Edɔm mɔ, mɔ mamɛ: ");
INSERT INTO bsp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, wan ka Behor, ɛnayɔnɛ wəbɛ Edɔm, tewe ta dare dɔn tɛnayɔnɛ Dinaba. ");
INSERT INTO bsp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kɔ Bela efi. Kɔ Yobab wan ka Serah wəka Bɔcəra ɛlɛk dɛbɛ dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kɔ Yobab efi. Kɔ Hucam wəka atɔf ŋa Temani ɛlɛk dɛbɛ dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kɔ Hucam efi. Kɔ Hadad wan ka Bedadu ɛlɛk dɛbɛ dɔn. Nkɔn ɛnacəmbər Madiyaŋ nde kulum ka Mohab. Tewe ta dare dɔn tɛnayɔnɛ Awit. ");
INSERT INTO bsp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kɔ Hadad efi. Kɔ Samla wəka Masreka ɛlɛk dɛbɛ dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kɔ Samla efi. Kɔ Sawul wəka dare da Rehobot Dəkəŋgbɔkɔ ɛlɛk dɛbɛ dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kɔ Sawul efi. Kɔ Bal Hanan, wan ka Akbɔr, ɛlɛk dɛbɛ dɔn. ");
INSERT INTO bsp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kɔ Bal Hanan wan ka Akbɔr efi. Kɔ Hadar ɛlɛk dɛbɛ dɔn. Tewe ta dare dɔn tɛnayɔnɛ Pawu, kɔ tewe ta wəran kɔn tɛnayɔnɛ Mehetabɛl, wan ka Matɛrodu wəran, wan ka Mesahabu wəran. ");
INSERT INTO bsp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mewe ma abɛ a Esayu mɔ mamɔkɔ, dəcor dəcor, dətɔf tɔf. Pəmɔ tatɔkɔ mewe maŋan moloku ti mɔ: Wəbɛ Timna, wəbɛ Alwa, wəbɛ Yetet, ");
INSERT INTO bsp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","wəbɛ Oholibama, wəbɛ Ela, wəbɛ Pinɔŋ, ");
INSERT INTO bsp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","wəbɛ Kenas, wəbɛ Teman, wəbɛ Mibəcar, ");
INSERT INTO bsp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","wəbɛ Makdiyɛl, wəbɛ Iram. Akaŋɛ ŋanayɔnɛ abɛ a Edɔm, kɔ dəkəndɛ daŋan atɔf ŋɔkɔ ŋanayɔnɛ abɛ mɔ. Esayu ɛnayɔnɛ wətem ka aka Edɔm. ");
INSERT INTO bsp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Kɔ Yakuba ɛndɛ atɔf ŋa Kanaŋ nde kas ɛnandɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dokombəra da Yakuba dɛndɛ: Kəsɔtɔ ka Isifu meren wəco kɔ camət-mɛrəŋ, kɔ Isifu ɛyɛfɛ pəccɛpsɛ awɛnc aŋa darəŋ ŋackɛk ŋkesiya kɔ cir. Pəyɔnɛ wan wəfɛt, pəccəmɛ awut arkun a Bilha kɔ Silpa darəŋ, aran a kas. Mba Isifu encder pəcsɔŋɛ papa kəŋan kəcərɛ mɛcɛmcɛmnɛ mɛlɛc mɔkɔ menccepər di mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakuba ɛnabɔtər Isifu pətas awut ɔn alpəs aŋɛ fəp, bawo detem disrɛ d'ɛnasɔtɔ kɔ. Kɔ Yakuba ɔsɔt burumus bɔnɔŋkəsəl lom k'ɔsɔŋ bi Isifu. ");
INSERT INTO bsp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kɔ awɛnc a Isifu ŋande ŋanəŋk, a kas kəŋan ɔmbɔtər Isifu pətas ŋa fəp. Kɔ ŋamɛŋkɛ Isifu mɛtɛlɛ mamɔkɔ. Kɔ ŋayi ta ŋaŋlok-lokər Isifu belbel-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kɔ Isifu ɛwɛrəp, k'ɔŋkɔ pəloku mere mamɔkɔ awɛnc aŋa, kɔ akakɔ ŋanaŋkanɛ sɔ kəter kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kɔ Isifu oloku ŋa: «Awɛnc im aŋa, nəcəŋkəl mere mmɛ iwɛrəpna mɔ! ");
INSERT INTO bsp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Dəkulum ayina pacsek mɛmpəlɛ. Pəwon fɛ kɔ kilim kem ka mɛmpəlɛ kəyɛfɛ kɔ kəncəmɛ sot! Kɔ cilim ca mɛmpəlɛ ma nəna cənder cənɔŋkər kem, kɔ cəntontnɛnɛ ki.» ");
INSERT INTO bsp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kɔ awɛnc aŋa ŋaloku kɔ: «Mba məna məncɛm-cɛmnɛ kəyɔnɛ ka wəbɛ ka səna ba? Məyi su kəroŋ?» Kɔ ŋambɛrɛnɛ sɔ kəter kɔ teta moloku mɔn mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kɔ Isifu endesɔ pəwɛrəp, k'oloku sɔ ti awɛnc aŋa. K'oloku: «Iwɛrəpna sɔ: Dec, ŋof kɔ cɔs wəco kɔ pin yontontnɛn'em.» ");
INSERT INTO bsp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kɔ Isifu oloku mere mamɔkɔ papa kɔn kɔ awɛnc aŋa. Kɔ papa kɔn oŋkul-kulər kɔ, k'eyif kɔ: «Cəke cɔ mere mamɛ məwɛrəp mɔ moloku-ɛ? Məncɛm-cɛmnɛ a səndeder, iya kam, awɛnc əm aŋa, kɔ ina sədetontnɛn'am dəntɔf?» ");
INSERT INTO bsp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kɔ awɛnc a Isifu ŋayɔnɛ kɔ kəraca. Mba kɔ kas kəŋan ɛmɛŋkərnɛ kəwɛrəp kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kɔ awɛnc a Isifu ŋande ŋawur, kəkɔkɛk ŋkesiya kɔ cir ya kas kəŋan nde Səkɛm. ");
INSERT INTO bsp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kɔ Yakuba oloku Isifu: «Awɛnc əm aŋa ŋayi Səkɛm ŋawurɛnɛ yɔcɔl kəkɔsɔmət. Məder, ifaŋ kəsom əm nde ŋayi mɔ.» Kɔ Isifu owosɛ: «In'ɛwɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kɔ Yakuba oloku kɔ: «Məkɔ məmɔmən em kɔ pəyɔnɛ a daka o daka dɔyɔ fɛ awɛnc əm aŋa kɔ yɔcɔl yɛfɛt yɛfɛt-ɛ. Məder məlok'im ti.» K'osom kɔ kəyɛfɛ ka aranta ŋa Hebərɔŋ, kɔ Isifu ɔŋkɔ Səkɛm. ");
INSERT INTO bsp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Kɔ wərkun wəlɔma ɔŋkɔ pəbəp kɔ pəckafəlɛ-kafəlɛ dəkulum. Kɔ wərkun nwɛ eyif kɔ: «Ake məntɛn-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kɔ Isifu oloku kɔ: «Awɛnc im aŋa ŋ'intɛn, ilɛtsɛn'am məmentər im nde ŋayi kəkɛk yɔcɔl mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kɔ wərkun nwɛ oloku kɔ: «Ŋayɛfɛ dɛ, inenɛna ŋa ŋacloku: ‹Paŋkɔn kəca ka Dotaŋ.›» Kɔ Isifu ɛncəmɛ ni yaŋan darəŋ kɔ yɔcɔl haŋ k'ɔŋkɔ pəbəp ŋa Dotaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","K'awɛnc aŋa ŋanəŋk kɔ pəbɔlɛ, ta ɛntabəp ŋa-ɛ, kɔ ŋasekɛ kɔ kədif. ");
INSERT INTO bsp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kɔ ŋalokɛnɛ: «Wəbɛ ka kəwɛrəp ender wəkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nəder oŋ padif kɔ, pagbal kɔ nde dəkələmp. Pakɔ paloku a wɛsɛm wɔsɔm kɔ. Pamɔmən oŋ daka ndɛ kəwɛrəp kɔn kəndeyɔnɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kɔ Ruben ene ti, k'ɛmbaŋ kɔ akakɔ dəwaca. K'oloku: «Ta pasɔŋɛ kɔ kəfi.» ");
INSERT INTO bsp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kɔ Ruben oloku sɔ: «Ta nəwurɛ mecir! Nəgbal kɔ kələmp kaŋkɛ kəyi nnɔ dətɛgbərɛ mɔ. Ta nədeŋər kɔ kəca!» Ɛnaloku ŋa moloku mamɛ, ntɛ tɔŋsɔŋɛ pətam kəyac Isifu defi, pəkenɛ kɔ kas mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ntɛ Isifu ɛmbəp awɛnc aŋa mɔ, kɔ akakɔ ŋawurɛ kɔ burumus bɔnɔŋkəsəl lom bɔkɔ ɛnabɛrnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kɔ ŋasumpər kɔ, kɔ ŋantorɛ kɔ dəkələmp. Kələmp kaŋkɔ kənawosər, ali domun kənayɔ fɛ. ");
INSERT INTO bsp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kɔ ŋandɛ ŋacdi yeri, ŋandeyekti fɔr, kɔ ŋanəŋk afum a Səmayila ŋayɛfɛ atɔf ŋa Kaladu. Yɔkɔmɛ yaŋan yɛsarɛ suray, cɔl kɔ labundɛ nyɛ ŋanckekərɛ Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kɔ Yuda eyif awɛnc aŋa: «Ta ake tɔ andedifɛ wɛnc kosu pamɛŋk mecir mɔn-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nəder pacamsər kɔ afum a Səmayila. Ta padeŋər kɔ kəca. Bawo wɛnc kosu ɔfɔ, mecir min mayi mɔ ampaŋnɛ.» K'awɛnc aŋa ŋanenɛ kɔ moloku mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kɔ acaməs aMadiyaŋ aŋɛ ŋanccepər mɔ, ŋampɛnɛ Isifu dəkələmp. Kɔ awɛnc a Isifu ŋancamsər kɔ aMadiyaŋ gbeti ncəmbəl wəco mɛrəŋ, k'aMadiyaŋ ŋaŋkekərɛ Isifu Misira. ");
INSERT INTO bsp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ntɛ Ruben oluksərnɛ kədemɔmən kələmp disrɛ mɔ, ɛmbəp fɛ sɔ Isifu kələmp disrɛ. K'ɛwal-wali yɛbɛrnɛ yɔn. ");
INSERT INTO bsp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","K'ɛŋkafəlɛ nnɔ awɛnc aŋa ŋayi mɔ, k'oloku: «Wan nwɛ eyi fɛ sɔ nnɔ dəkələmp! Cəke indeyɔ oŋ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kɔ ŋalɛk burumus ba Isifu, kɔ ŋafay ambiyofo amera, kɔ ŋasopət burumus babɔkɔ mecir. ");
INSERT INTO bsp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kɔ ŋaŋkenɛ kas kəŋan burumus bɔnɔŋkəsəl lom ba Isifu babɔkɔ, kɔ ŋaŋkɔ ŋacloku kas kəŋan: «Yamos yayɛ yɔ səŋkɔ sənəŋk. Məna sɔ məmɔmən ma kɔ pəyɔnɛ a burumus ba wan kam bɔ-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kɔ Yakuba ɛnɛpəl bi, k'oloku: «Burumus ba wan kem bɔ! Wɛsɛm wɛlɛc wɔlɔma wɔsɔm kɔ! Wɛsɛm wɛwatəri-watəri kɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kɔ Yakuba ɛwal-wali yamos yɔn, k'esekənɛ kəloto k'abɛk defi. K'ombok wan kɔn Isifu mataka mɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kɔ awut ɔn arkun kɔ aran fəp ŋayɛfɛ kətorɛ-torɛ kɔ abəkəc. Mba k'ombupərɛ kəlɛtsɛnɛ fəp. K'oloku: «Indebok wan kem haŋ dɔsɔk ndɛ indekɔbəp kɔ dabiya mɔ!» K'ɛncəmɛ kəbok ka wan kɔn darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kɔ aMadiyaŋ ŋancaməs Isifu Misira. Kɔ Potifar wətupɛ ka Firawona yeri nwɛ ɛnayɔnɛ wəbɛ ka abum a dəsaŋka sa Firawona mɔ, ɛway kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Tɛm tatɔkɔ, Yuda pəbɔlɛnɛ awɛnc aŋa, k'ɔŋkɔ pəyi kɔ wərkun wəlɔma nwɛ ancwe Hira mɔ, wəka Adulam ɛnayi. ");
INSERT INTO bsp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Dəndo, kɔ Yuda ɛnəŋk wəyecəra wəKanaŋ wəlɔma pacwe kɔ Suwa. K'ɛlɛk kɔ k'ɛnɛncɛ k'ombocərnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kɔ Suwa ɛmbɛkəs, k'oŋkomɛ Yuda wan wərkun k'ewe kɔ Er. ");
INSERT INTO bsp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","K'ɛmbɛkəs sɔ k'oŋkom wan wərkun k'ɔsɔŋ kɔ tewe ta Onaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","K'ɔŋgbɔkərɛ sɔ kəkom wan wərkun nwɛ ɛnawe Sɛlah mɔ. Dare da Kisibu Yuda ɛnayi tɛm ntɛ Suwa onckom Sɛlah mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kɔ Yuda ɛfacɛ coco cɔn wəyecəra nwɛ ancwe Tamar mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mba Er, nwɛ ɛnayɔnɛ coco ca Yuda mɔ, ɛnatesɛ fɛ fɔr ya MARIKI kiriŋ. Kɔ MARIKI ɔsɔŋɛ kɔ kəfi. ");
INSERT INTO bsp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kɔ Yuda oloku tɔŋɔ tɔn Onaŋ: «Məbocərnɛ wəran ka wəbek'am. Məsɔŋɛ wəran kɔn pəsɔtɔnɛ kɔ yuruya.» ");
INSERT INTO bsp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ntɛ Onaŋ ɛnacərɛ a awut aŋɛ endesɔŋ wəran ka wəbek'ɔn, ŋafɔdeyɔnɛ akɔn mɔ, kɔ Onaŋ ŋanckɔnafəntərɛ kɔ wəran ka wɛnc-ɛ, pəcloŋ domun dɔn d’arkun dəntɔf, ntɛ tɔŋsɔŋɛ ta ɔsɔŋɛ wɛnc kəsɔtɔ yuruya mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mɔyɔ mɔn mamɔkɔ mɔncbɔt fɛ MARIKI, k'ɔsɔŋɛ sɔ nkɔn Onaŋ kəfi. ");
INSERT INTO bsp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kɔ Yuda oloku Tamar wəran ka wan kɔn: «Məndɛ kəbal ka wos əm ndena papa kam haŋ wan kem wərkun Sɛlah pəcbɛk.» Bawo Yuda onclokunɛ: «Wəkawɛ sɔ kəfi k'ender pəmɔ abek'ɔn.» Kɔ Tamar ɔŋkɔ pəyi nde kəlɔ ka papa kɔn. ");
INSERT INTO bsp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kɔ mataka mɛlarəm mencepər, kɔ wan wəran ka Suwa, wəran ka Yuda, efi. Ntɛ abəkəc ŋɛnator Yuda mɔ, k'ɛmpɛrnɛ kəca ka Timna kɔ wanapa kɔn Hira wəka Adulam, nde akɔ ŋancfon ŋkesiya yɔn ŋanayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","K'aŋkɔ paloku Tamar: Konci kam ɛntas Timna kəkɔfon ŋkesiya yɔn yɛfɛt. ");
INSERT INTO bsp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kɔ Tamar owurɛ yamos yɔn ya cəbokəra, k'ɛŋgbalərnɛ kəloto, k'ɛnɛpsərnɛ ki, k'ɔŋkɔ pəndɛ dəkəbɛrɛ da Enayim nde dɔpɔ da Timna. Bawo ɛnanəŋk a Sɛlah ɛmbɛk, k'antɔlɛk kɔ pasɔŋ Sɛlah pəyɔnɛ wəran kɔn. ");
INSERT INTO bsp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kɔ Yuda ɛnəŋk Tamar, kɔ pəyi kɔ pəmɔ wəran wəyamayama, bawo ɛnakumpənɛ kəro. ");
INSERT INTO bsp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kɔ Yuda ɛncaŋ Tamar moloku dɔpɔ: «Taŋkɔn, səkɔ səfəntərɛ.» Bawo Yuda ɛnacərɛ fɛ a wəran ka wan kɔn wərkun ɔfɔ. Kɔ Tamar eyif kɔ: «Ake məndekɔsɔŋ im, kɔ məmbocərn'em-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","K'oloku: «Iŋkɔkɛr'am wir wowut yɔcɔl yem dacɔ.» Kɔ Tamar oloku: «Mɛnɛ məsɔŋ im paka pɔlɔm itɔmpər haŋ məckɛrɛ wir wowut wawɔkɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kɔ Yuda eyif kɔ: «Ake indesɔŋ əm haŋ ickɛrɛ wir wowut nwɛ-ɛ?» Kɔ Tamar oloku kɔ: «Məsɔŋ im tamp tam, kəbənda kɔ kəgbo kaŋkɔ məntɔmpər mɔ.» Kɔ Yuda ɔsɔŋ kɔ yi. Kɔ Yuda ɛfəntərɛ kɔ Tamar, kɔ Tamar ɛmbɛksɛ Yuda. ");
INSERT INTO bsp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kɔ Tamar ɛyɛfɛ k'ɔŋkɔ, k'owurɛ kəloto kaŋkɔ ɛnagbalərnɛ mɔ, k'ɛmbɛrnɛ sɔ yamos yɔn ya kəbal. ");
INSERT INTO bsp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kɔ Yuda osom wanapa kɔn wəAdulam, a pəkenɛ Tamar wir wowut, pəkɛrɛnɛ ca yɔkɔ ɛnacəmbər di sɛkɛ mɔ. Mba ɛnanəŋk fɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kɔ wəkakɔ ɔŋkɔ pəcyifət afum akɔ ɛnabəp di mɔ: «Deke wəran wətɛn arkun, nwɛ ɛncəmɛna nnɔ dɔpɔ da Enayim mɔ, eyi-ɛ?» Kɔ akakɔ ŋaloku kɔ: «Wəran wətɛn arkun ɔfɔcəmɛ nnɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kɔ wərkun nwɛ olukus k'ɔŋkɔ pəcloku Yuda: «Inəŋk fɛ kɔ. Ali afum a tofo tatɔkɔ ŋaloku: ‹A wəran wətɛn arkun eyi fɛ nnɔ.›» ");
INSERT INTO bsp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kɔ Yuda oloku: «Pəmɛŋkərnɛ ca yem yɔkɔ ɔntɔmpər mɔ! Ta patɛnərnɛ malap. Bawo isom pakenɛ kɔ wir wowut kɔ məntɔnəŋk kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ntɛ yof maas yencepər mɔ, k'ande paloku Yuda: «Wəran ka wan kam ɔŋkɔt yamayama, kɔ tɔsɔŋɛ kɔ kəbɛkəs.» Kɔ Yuda oloku: «Nəwurɛnɛ kɔ. Pacɔf kɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ntɛ asolɛ kɔ kəwurɛnɛ doru mɔ, k'osom nda konci kɔn: «Wəbɛkəsəs kem ɔyɔ ca nyɛ. Məsɛp məcərɛ nwɛ ɔyɔ tamp pampɛ, kəbənda kaŋkɛ, kɔ kəgbo kaŋkɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kɔ Yuda ɛnɛpəl yi. K'oloku: «Tamar olomp pətas im, bawo iwosɛ fɛ kəsɔŋ kɔ wan kem Sɛlah.» Difɔ tɛnalip ɛncərɛ fɛ kɔ sɔ dɛran. ");
INSERT INTO bsp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ntɛ Tamar ɛyɛfɛ kəkom mɔ, k'anəŋk a cəberi cəyi kɔ dəkor. ");
INSERT INTO bsp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tamar eyi kəkom. Kɔ wan wəcɔkɔ-cɔkɔ owurɛ kəca. Kɔ wəran wəbaŋ wan osumpər kənaka nkɛ kəca k'oŋkot kɔ debeŋa deyim dəkəca, pəcloku: «Wəkawɛ andenuŋkɛnɛ kəkom.» ");
INSERT INTO bsp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mba kɔ kənaka nkɛ kəliŋ kəca, kɔ wɛnc onuŋkɛnɛ kəwur. Kɔ wəbaŋ wan eyifnɛ: «Kəpəc kəre kɔ məwurɛ kaŋkɛ-ɛ?» Kɔ Tamar ewe wan wəkakɔ Pɛrɛc. ");
INSERT INTO bsp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kɔ wan wəka mɛrəŋ owur, nwɛ anakot debeŋa dəkəca mɔ, kɔ Tamar ewe wəkakɔ tewe ta Serah. ");
INSERT INTO bsp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","K'aŋkekərɛ Isifu Misira. Kɔ Potifar wəMisira, wəbɛ wəpɔŋ wəka firawona, nwɛ ɛnayɔnɛ wəkiriŋ ka abum ɔn mɔ, ɛway kɔ afum a Səmayila dəwaca akɔ ŋanakɛrɛ kɔ Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","MARIKI ɛnasolɛ Isifu, pəcuca fəp pɔ MARIKI ɛncbaŋ kɔ. Kəlɔ ka Mariki mɔn wəMisira k'ɛnayi. ");
INSERT INTO bsp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kɔ Mariki mɔn ɛnəŋk a MARIKI osolɛ Isifu. Mosumpər mɔn fəp, MARIKI ɛncmar kɔ mectesɛ kɔ dəwaca. ");
INSERT INTO bsp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Kɔ Isifu ende pəsɔtɔ kəlaŋ ka wəbɛ kɔn nwɛ ɛncbəcɛ mɔ. Kɔ wəkakɔ ɛlɛk kɔ, k'ɔsɔŋ kɔ dɛbɛ da kəcəmbər-cəmbər mes ma kəlɔ kɔn disrɛ. K'ɛlɛk daka dɔn fəp, k'ɛmbɛr di Isifu dəwaca pəclompsɛ-lompsɛ kɔ di kəcəmbər-cəmbər. ");
INSERT INTO bsp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ntɛ Potifar ɛlaŋ Isifu, a k'ɔsɔŋ kɔ kəcəmbər-cəmbər ka mes ma kəlɔ kɔn disrɛ fəp mɔ, kɔ MARIKI ompocɛ kəlɔ ka wəMisira nwɛ, teta Isifu. Kɔ kəpocɛ ka MARIKI kəsumpər daka da Potifar fəp, kəyɛfɛ dɛkɛr haŋ nde dalɛ. ");
INSERT INTO bsp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","K'ɛsakərɛ teta daka dɔn fəp Isifu, nkɔn ɛnasumpər fɛ sɔ ntɛ o ntɛ mɛnɛ yeri nyɛ encdi mɔ. Mba Isifu fum wətɔt teyi ɛnayi. ");
INSERT INTO bsp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ntɛ mes mamɔkɔ mencepər mɔ, kɔ wəran ka mariki mɔn ende pəcencər Isifu fɔr, k'oloku kɔ: «Məfəntərɛ kɔ ina!» ");
INSERT INTO bsp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kɔ Isifu ɛfati. K'oloku wəran ka mariki mɔn: «Mənəŋk ntɛ mariki mem ɛlɛk mes mɔn fəp k'ɛmbɛr im dəwaca mɔ, tɔsɔŋɛ ɔfɔsɔyɔ ntɛ o ntɛ dɛkɛr k'ɛlɛk sɔ daka dɔn fəp k'ɔsɔŋ im kəcəmbər-cəmbər. ");
INSERT INTO bsp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Fum nwɛ o nwɛ eyi fɛ nnɔ kəlɔ kaŋkɛ nwɛ elelɛ pəcepər im mɔ. Ɔmɔnɛnɛ f'em ntɛ o ntɛ ta kəlɔ kaŋkɛ mɛnɛ məna, bawo wəran kɔn məyɔnɛ. Ak'endesɔŋ'em oŋ kəyɔ pəlɛc pɔpɔŋ, iciyanɛ sɔ Kanu-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kɔ wəran nwɛ ɛncəmɛnɛ Isifu moloku mamɔkɔ darəŋ haŋ mataka mɛlarəm. Mba Isifu ɛnawosɛ fɛ mɛcɛm-cɛmnɛ mɔn, kəcərɛ a ŋafəntərɛ kɔ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Dɔsɔk dɔlɔma, kɔ Isifu ɛmbɛrɛ dukulɔ dəkəlompəs yɛbəc yɔn. Mba dɔsɔk dadɔkɔ afum a kəlɔ kaŋkɔ ali wəkin ɛnayi fɛ dɛkɛr. ");
INSERT INTO bsp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kɔ wəran nwɛ osumpər pɛbɛrnɛ pa Isifu k'oloku kɔ: «Məfəntərɛ kɔ ina!» Kɔ Isifu ɛsakərɛ kɔ pɛbɛrnɛ pɔn, k'ɛyɛksɛ k'owur doru. ");
INSERT INTO bsp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ntɛ wəran nwɛ ɛnəŋk a Isifu ɛsakərɛ kɔ pɛbɛrnɛ pɔn dəwaca, k'ɛyɛksɛ k'owur doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","K'ewe afum a kəlɔ kəŋan k'oloku ŋa ntɛ: «Nənəŋk, wəHebəre nwɛ wos im ɛŋkɛrɛ pədefani su mɔ. Isifu ender im a pədefəntərɛ kɔ ina. Ti tɔ iŋkul-kulɛnɛ pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ntɛ endecərɛ a kəpɛnɛ k'indɛ dim mɔ, k'ɛyɛksɛ. K'ɛsakər'em pɛbɛrnɛ pɔn kɔ nkɔn owur nde doru.» ");
INSERT INTO bsp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kɔ wəran nwɛ ombocərnɛ pɛbɛrnɛ pa Isifu kəsək, haŋ mariki ma Isifu pəcbɛrɛ dɛkɛr. ");
INSERT INTO bsp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kɔ wəran nwɛ oloku wos tin tayi, k'oloku kɔ: «Wəcar wəHebəre nwɛ məŋkɛrɛ su mɔ, ender im a pədefan'im. ");
INSERT INTO bsp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mba ntɛ iŋkulɛ-kulɛ pəpɔŋ mɔ, k'ɛsak pɛbɛrnɛ pɔn nnɔ iyi mɔ. Kɔ nkɔn ɛyɛksɛ k'owur nde doru.» ");
INSERT INTO bsp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ntɛ mariki ma Isifu ene moloku ma wəran kɔn, nwɛ oncloku kɔ: «Ntɛ tɔ wəcar kam ɔy'em!» ");
INSERT INTO bsp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kɔ mɛtɛlɛ mɔpɔŋ mosumpər mariki ma Isifu. Kɔ wəkakɔ ɛmbɛr Isifu dəbili kəca nkɛ wəbɛ ɛncbɛr afum dəbili mɔ. Kɔ Isifu eyi dəndo dəbili. ");
INSERT INTO bsp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kɔ MARIKI osolɛ Isifu, k'ɛlas layidi da amera ŋobotu ŋɔkɔ ɛnasɔŋ kɔ mɔ. K'ɔsɔŋɛ wəbɛ wəka dəbili kəmar kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kɔ wəbɛ wəka dəbili ɛlɛk aka dəbili fəp k'ɛmbɛr ŋa Isifu dəwaca, ntɛ o ntɛ tenccepər oŋ di mɔ, Isifu tencepər dəwaca kərɛsna. ");
INSERT INTO bsp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wəbɛ wəka dəbili ɔncmɔmən fɛ sɔ ntɛ o ntɛ Isifu ɛnatɔmpər dəwaca, bawo MARIKI ɛnasolɛ kɔ, pəclompsɛ kɔ mosumpər mɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ntɛ mes mamɔkɔ mencepər mɔ, kɔ amarəs mɛrəŋ a Firawona, wəbɛ ka Misira, wətupɛ kɔ wəcɔfɛ kɔn cəcom, ŋande ŋaciyanɛ mariki maŋan. ");
INSERT INTO bsp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kɔ pəntɛlɛ Firawona nnɔ amarəs ɔn mɛrəŋ ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kɔ Firawona osom k'asumpər ŋa, k'aŋkɔ pacaŋər ŋa nde bili bɔkɔ anacaŋər Isifu mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kɔ wəbɛ ka aka dəbili oloku Isifu kəgbɛkərɛ ŋa pəmɔ ntɛ ɛnayi ŋa kəsək mɔ. Kɔ ŋayi dəbili tɛm tɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pibi pin disrɛ, kɔ amarəs a Firawona aŋɛ mɛrəŋ ŋawɛrəp. Nwɛ o nwɛ, tɛwɛrəp tɔn taciŋa teciyanɛ kɔ ta wəkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Dec dendesɔk, kɔ Isifu ɛnəŋk ŋa ŋamɔncnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kɔ Isifu eyif amarəs a Firawona aŋɛ mɛrəŋ aŋɛ ŋanayi dəbili kɔ nkɔn mɔ, k'eyif ŋa: «Ta ake tɔ nəŋɛyɛ cəro mɔkɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kɔ ŋaloku Isifu: «Səwɛrəpna nnɔ pibi, mba fum eyi fɛ nnɔ nwɛ endetam kəloku su tedisrɛ ta mere mamɔkɔ mɔ.» Kɔ Isifu eyif ŋa: «Bafɔ Kanu kətɔmpər kəcərɛ ka tedisrɛ ta mes ba? Nəlok'im ma mere monu.» ");
INSERT INTO bsp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kɔ wətupɛ ka Firawona yomunəs ɔlɔmər Isifu mere mamɔkɔ ɛnawɛrəp mɔ. K'oloku: «Mere mmɛ iwɛrəpna mɔ: Aŋgbɔŋkəlɔ ŋa wɛn ŋeyin'em fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ŋɔyɔ wara maas. Ntɛ aŋgbɔŋkəlɔ nŋɛ ŋoŋgbuc mɔ kɔ cɛk ya yokom yɛmbɛk, kɔ yokom yayɔkɔ yɔlɔl. ");
INSERT INTO bsp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tɛtəŋnɛ itɔmpər apɔt nŋɛ inctupɛ wəbɛ kem Firawona mɔ. K'ilɛk yokom yɔlɔma k'ifɔcəs yi nnɔ apɔt nŋɛ inctupɛ Firawona mɔ disrɛ, k'isɔŋ Firawona məncɔncɔ ma pokom papɔkɔ inafɔcsɛ kɔ dɔpɔt mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kɔ Isifu oloku kɔ: «Tedisrɛ tayi tɛntɛ: Wara wawɔkɔ maas, mata maas mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kɔ mata maas mencepər-ɛ, Firawona endesɔlukus kəyekt'əm domp, pəluks'am yɛbəc yam. Məndesɔ məctupɛ kɔ yomunəs pəmɔ tɔkɔ məncbəc ti mɔ, məcbɛr kɔ yeri yɔkɔ mənde kəctupɛ kɔ mɔ dəkəca. ");
INSERT INTO bsp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","K'andesak əm-ɛ, ta mədekɔpələrn'em, ilɛtsɛn'am məlɛk'em layidi a məndekɔmar im nnɔ wəbɛ eyi mɔ. Ntɛ tɔŋsɔŋɛ pəwurɛn'em nnɔ kəlɔ kaŋkɛ disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bawo atɔf ŋa Hebəre ŋalɛk im k'aŋkɛrɛ Misira. Kɔ nnɔ, ali tes iyɔ fɛ ntɛ andebɛr'em dəbili mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ntɛ wəcɔfɛ ka Firawona cəcom ɛnəŋk a moloku mmɛ Isifu oloku ma mere mɔ, mɔmbɔt kəne, k'oloku Isifu: «Ina mere mem, mafala maas ma kəcom kəgbɛnt m'isarɛna. ");
INSERT INTO bsp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kəfala kaŋkɔ kəŋɛcna ci dacɔ mɔ fəp, yeri yɔkɔ wəcɔf cəcom ontup a pəcsɔŋ yi Firawona mɔ fəp yeyina dənda. Bɛmp yɔcsɔm yeri yayɔkɔ isarɛna kəfala disrɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kɔ Isifu oloku kɔ: «Tedisrɛ tayi tɛntɛ: Cəfala cacɔkɔ maas, mata maas mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kɔ mata maas mencepər-ɛ, Firawona endepɛn'am darenc, pəbɛr əm kəbənda dəkilim pəgbɛk əm, bɛmp yɔsɔm əm.» ");
INSERT INTO bsp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tataka ta maas, dɔsɔk doluksər da kəkom ka Firawona. K'ombocɛ amarəs ɔn kəsata kəpɔŋ. K'ɔsɔŋ wəcɔfɛ kɔn cəcom dɛbɛ dɔpɔŋ, amarəs ɔn fəp fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","K'oluksɛ sɔ wəka mɛrəŋ wəkɔ yɛbəc yɔkɔ ɛnayi cɔkɔ-cɔkɔ mɔ: Kɔ wəkakɔ oncop sɔ kəctup pəbɛr Firawona apɔt dəkəca. ");
INSERT INTO bsp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kɔ Firawona osumpər wəcɔf cəcom wəpɔŋ pəmɔ tɔkɔ Isifu ɛnaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Wətupɛ ka Firawona yomunəs ɛncɛm-cɛmnɛ fɛ sɔ Isifu, k'ɛmpələrnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kɔ teren tin tencepər, teren ta mɛrəŋ, kɔ Firawona ɛwɛrəp: Pəcəmɛ kəŋgbɔkɔ nkɛ aŋwe Nil mɔ kəsək. ");
INSERT INTO bsp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kɔ cəna cəran cətifi camət-mɛrəŋ cəncafɛ dəkəŋgbɔkɔ. Kɔ cəyɛfɛ kəsɔmət dalɛ. ");
INSERT INTO bsp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kɔ cəna cəran camət-mɛrəŋ cəlɔma cəleŋki cəncafɛ sɔ cəkɔ tadarəŋ dəkəŋgbɔkɔ. Kɔ ci cəŋkɔ sɔ cəcəmɛ cəcɔkɔ-cɔkɔ kəsək dəkəŋgbɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kɔ cəna cəleŋki ncɛ cəyɛfɛ kəsɔm cəna cətifi cəkɔ. Kɔ Firawona ɛntəmɛ. ");
INSERT INTO bsp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kɔ Firawona ɔŋgbɔkərɛ sɔ kədirɛ, k'ɛwɛrəp sɔ tamɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Səbomp sa malɔ camət-mɛrəŋ səpɔŋ səwurəs atoka ŋin ŋɔtɔt. Kɔ səbomp sa malɔ səfɛt səwurəs səcɔkɔ-cɔkɔ tantɔf. ");
INSERT INTO bsp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kɔ səbomp sa malɔ səfɛt nsɛ səndi səbomp sa malɔ səpɔŋ səlarɛ səkɔ. Kɔ Firawona ɛntəmɛ sɔ. Mere mayi mɔ mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Dec dendesɔk, kɔ amera ŋɛlɛcɛ-lɛcɛ Firawona. K'ewe acərɛ mes k'abeki a Misira fəp. Kɔ Firawona ɔlɔmər ŋa mere mɔn. Mba ali fum ɛnayi fɛ nwɛ ɛnctam kəloku kɔ tedisrɛ ta mere mɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kɔ wətupɛ kɔn yomunəs ɛlɛk moloku, k'oloku Firawona: «Incɛm-cɛmnɛ mɔkɔ tɛpələrnɛ tem. ");
INSERT INTO bsp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pənatɛlɛ Firawona nnɔ amarəs ɔn ŋayi mɔ, k'osom k'asumpər im kɔ wəcɔfɛ kɔn cəcom, k'ɛmbɛr su dəbili nde kəlɔ ka wəbɛ ka abum ɔn. ");
INSERT INTO bsp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kɔ səwɛrəp ina kɔ wəka mɛrəŋ kem pibi pin. Nwɛ o nwɛ mere mɔn taciŋa mmɛ antam kəloku tedisrɛ ta mi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tɛtəŋnɛ səyi bili bin kɔ wətɛmp wəcar wəHebəre wəka wəbɛ ka abum a Firawona wəlɔma. Kɔ səloku kɔ nwɛ o nwɛ mere mɔn k'oloku su tedisrɛ ta mi. ");
INSERT INTO bsp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kɔ tosurɛnɛ kɔ teyi pəmɔ tɔkɔ ɛnaloku nwɛ o nwɛ mɔ. Kɔ Firawona oluks'em yɛbəc yem yɔcɔkɔ-cɔkɔ. K'ɛŋgbɛk wəka mɛrəŋ kem.» ");
INSERT INTO bsp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kɔ Firawona osom a pawenɛ kɔ Isifu. K'awurɛnɛ kɔ katəna katəna dəbili. K'ofonnɛ, k'ɛsəkpər yamos, k'ɔŋkɔ nde Firawona ɛnawe kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kɔ Firawona oloku Isifu: «Iwɛrəp, mba ali fum isɔtɔ fɛ nwɛ oŋlok'im tedisrɛ ta mere mem mɔ. Mba alok'im a məntam kəloku tedisrɛ ta mere mmɛ aŋlok'əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kɔ Isifu oloku Firawona: «Bafɔ in'ɔfɔ! Kanu kəndeloku Firawona tedisrɛ ta mere mɔn.» ");
INSERT INTO bsp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kɔ Firawona oloku Isifu: «Mere mem-ɛ, kəŋgbɔkɔ kəsək incəmɛna. ");
INSERT INTO bsp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kɔ cəna camət-mɛrəŋ cətɔt cətifi cəncafɛ dəkəŋgbɔkɔ, kɔ cəyɛfɛ kəsɔmət dalɛ. ");
INSERT INTO bsp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kɔ cəna camət-mɛrəŋ cəlɔma cəleŋki cəlɛc, ci cəncafɛ sɔ cəkɔ tadarəŋ dəkəŋgbɔkɔ. Mba intanəŋk fɛ Misira cəna cəlɛcɛ pəmɔ cacɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kɔ cəna cəlɛc cəleŋki ncɛ cəyɛfɛ kəsɔm cəcɔkɔ-cɔkɔ camət-mɛrəŋ cətifi cətɔt cəkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Cəna cətifi ncɛ cəcbɛrɛ cəleŋki dəputuk, ta ancərɛ kɔ pəyɔnɛ yati cəmbɛrɛ ci dəputuk-ɛ. Kɔ cəna cəlɛc ncɛ cənaŋkanɛ sɔ kəlɛcɛ, pətas tɔkɔ cənalɛcɛ mɔ. K'intəmɛ. ");
INSERT INTO bsp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","K'iwɛrəp sɔ ntɛ: Səbomp camət-mɛrəŋ sa malɔ sətɔt səlarɛ səwurəs atoka ŋin ŋayi. ");
INSERT INTO bsp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kɔ səbomp camət-mɛrəŋ sa malɔ səlɔma səfɛt səwurəs səcɔkɔ-cɔkɔ səkɔ tantɔf. ");
INSERT INTO bsp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kɔ səbomp sa malɔ səfɛt nsɛ səndi səbomp sa malɔ səpɔŋ səkɔ. Iloku mere mamɛ acərɛ mes. Mba ali fum isɔtɔ fɛ nwɛ oŋlok'im tedisrɛ ta mi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kɔ Isifu oloku Firawona: «Mere ma Firawona fəp, toloku tin tɔ moloku. Kanu kəyi kəmentər Firawona ntɛ kəndeyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Cəna cətɔt ncɛ camət-mɛrəŋ, meren camət-mɛrəŋ mɔ. Kɔ səbomp sa malɔ sətɔt nsɛ camət-mɛrəŋ, meren camət-mɛrəŋ mɔ, mere min mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Cəna cəlɛc cəleŋki ncɛ cəmpɛna cəkɔ tadarəŋ mɔ, meren camət-mɛrəŋ mɔ, kɔ səbomp sa malɔ səfɛt nsɛ, dor da meren camət-mɛrəŋ dɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Pəmɔ tɔkɔ intɛp ti kəcloku Firawona mɔ, Kanu kəmentər Firawona tɔkɔ kəndeyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Meren camət-mɛrəŋ ma kənɛmbərɛ mender mamɛ atɔf ŋa Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kɔ meren camət-mɛrəŋ ma kənɛmbərɛ mencepər-ɛ meren camət-mɛrəŋ ma dor mendecəmɛ mi darəŋ: Dor dadɔkɔ dendeluksɛ Misira darəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kɔ dor dadɔkɔ dencepər-ɛ, afɔdetam kəcərɛ yati kɔ pəyɔnɛ a kənɛmbərɛ kənayi dɛ tɔlɔma-ɛ. Debeki da dor dadɔkɔ dendesɔŋɛ ti. ");
INSERT INTO bsp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kɔ mənəŋk Firawona pəgbɔkərɛ kəwɛrəp mere min mamɔkɔ kəmɛrəŋ-ɛ, Kanu kəyi kəsɔŋɛ kɔ kəcərɛ: A mes melip nnɔ kəyi mɔ, kəbɛlkər kɔ kənder oŋ kəbəc yɛbəc ya ki. ");
INSERT INTO bsp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ntɛ Firawona ɛncərɛ oŋ a Isifu ɔyɔ amera, k'ɛncərɛ sɔ mes mɔ, kɔ Firawona ɔsɔŋ kɔ dɛbɛ atɔf ŋa Misira disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Firawona pəyɛfɛ oŋ, pəboncəs akɔ ŋandeyɔnɛ abɛ aŋɛ ŋandekɔtɛnɛ atɔf ŋa Misira mɔ, ntɛ tɔŋsɔŋɛ ŋabaŋəs katin ka kəcamət ka kəsɔtɔ yɛtɛl yaŋan, atɔf ŋa Misira meren camət-mɛrəŋ ma kəmɛmbərɛ mmɛ disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ŋaloŋka yeri ya meren mobotu mmɛ mender mɔ, ŋayɔ ti dim da Firawona dəntɔf. Firawona pəsom pamɛŋk yeri sədare fəp. ");
INSERT INTO bsp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yeri yayɔkɔ yɔ andemɛŋkɛ atɔf, kədɛm ka meren camət-mɛrəŋ ma dor mmɛ Isifu oloku kədeyi mɔ, ntɛ tɔŋsɔŋɛ ta dor dadɔkɔ dedetam atɔf ŋa Misira mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kɔ moloku mamɔkɔ mɔmbɔt Firawona kɔ amarəs ɔn. ");
INSERT INTO bsp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kɔ Firawona eyif ŋa: «Andetam kəsɔtɔ fum pəmɔ Isifu ba, pəyɔ amera ŋa Kanu?» ");
INSERT INTO bsp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kɔ Firawona oloku Isifu: «Ntɛ Kanu kəsɔŋ əm kəcərɛ ka mes mamɛ fəp mɔ, fum o fum eyi fɛ nwɛ ɔsɔk domp, pəcərɛ mes pəmɔ məna mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Məna Isifu, mən'endeyɔnɛ wəkiriŋ ka kəlɔ kem, afum a atɔf ŋem fəp. Mən'ɔ ŋandeyi darəŋ, dɛbɛ da ina Firawona gbəcərəm dendecepər dam.» ");
INSERT INTO bsp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kɔ Firawona oloku Isifu: «Misira mɔ mamɛ isɔŋ əm dɛbɛ da atɔf ŋaŋɛ fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kɔ Firawona owurɛ kurundɛ kɔn dəkəca, k'ɛmbɛr ki Isifu dəkəca. K'ɛmbɛr Isifu yamos yɔtɔt ya kəloto ka səbeŋa sa kentəler. K'ɛŋgbɛk kɔ kɛma dəkilim. ");
INSERT INTO bsp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kɔ Firawona ɛmbɛk Isifu abil ŋa dəkəwan ŋɔkɔ ŋɛnacɔnc ŋɔn mɔ, kɔ ŋancɛk kəkɔ. Kɔ afum ŋayɛfɛ kəkul-kulɛnɛ ŋa: «Abərek!» Tatɔkɔ tɔ Firawona ɛnasɔŋ Isifu dɛbɛ, atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kɔ Firawona oloku sɔ Isifu: «In'ɔyɔnɛ Firawona! Kɔ məntɔwosɛ-ɛ atɔf ŋa Misira, ali fum ɔfɔyekti dɛ kəca, k'ɔŋkɔyekti kəcək kɔn atɔf ŋa Misira.» ");
INSERT INTO bsp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kɔ Firawona ewe Isifu tewe ta Misira «Cafənat Paheneyah.» K'ɔsɔŋ kɔ wəran pacwe kɔ Asnat, wan wəran ka Potifera, wəloŋnɛ ka dare da Hon. Kɔ Isifu owur kəkɔcərɛ Misira mmɛ ɛnasɔtɔ kəkɔtɛnɛ dɛbɛ ta ɛncərɛ mi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Isifu ɛnasɔtɔ meren wəco maas (30) a Firawona pədecərɛ kɔ. Ntɛ ancəmbər kɔ dɛbɛ mɔ, fɔr ya Firawona kiriŋ yɔ Isifu ɛnawur kəkɔcərɛ atɔf ŋa Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Meren camət-mɛrəŋ ma kənɛmbərɛ mamɔkɔ disrɛ, kɔ afum a Misira ŋambɛrɛnɛ kəbəc. ");
INSERT INTO bsp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kɔ Isifu oloŋka yeri yayɔkɔ fəp Misira meren mmɛ camət-mɛrəŋ. K'oloŋka yeri ya sədare səfɛt səkɔ sənɔŋkər sədare səpɔŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Isifu ɛnaloŋka kur ka yeri pəmɔ kəsənc ka dəkəba, kur kənabɛk haŋ paccɛm-cɛmnɛ a dor dɔfɔsɔtam kəsumpər aka Misira. ");
INSERT INTO bsp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Teren tɔcɔkɔ-cɔkɔ ta dor, kɔ Isifu oŋkom awut arkun mɛrəŋ aŋɛ Asnat wan wəran ka Potifera wəloŋnɛ ka dare da Hon ɛnakomɛ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kɔ Isifu ewe coco cɔn Manase, ti tatɔkɔ Kanu kəsɔŋɛ kɔ kəpələr ka pəcuy fəp kɔ kəsakɛnɛ kɔ aka kəlɔ ka kas. ");
INSERT INTO bsp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","K'ewe wan kɔn tɔŋɔ Ɛfrayim, ti tɔ tatɔkɔ Kanu kəsɔŋ kɔ dokombəra atɔf nŋɛ analapəs kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kɔ meren camət-mɛrəŋ ma kənɛmbərɛ melip. ");
INSERT INTO bsp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kɔ meren camət-mɛrəŋ ma dor moncop pəmɔ tɔkɔ Isifu ɛnaloku ti mɔ. Dor dɛnayi tɔf ya Misira fəp. Mba yeri yɛmɛŋkərnɛ yɛnayi sɔ atɔf ŋa Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ntɛ dor dosumpər aka Misira mɔ, kɔ ŋambokər Firawona kəsɔtɔ ka cəcom. Kɔ Firawona oloku aka Misira: «Nəkɔ nənəŋk Isifu, ntɛ oŋloku nu mɔ, nəyɔ tatɔkɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ntɛ dor dɛmbɛk Misira mɔ, kɔ Isifu oncop kəcamsər aka Misira malɔ. Mba dor dɛncbɛk kəbɛk dəm atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Afum ŋacyɛfɛ mofo fəp ma Misira kədeway malɔ nnɔ Isifu eyi mɔ, bawo dor dɛnanaŋkanɛ kəbɛk Misira. ");
INSERT INTO bsp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kɔ Yakuba ene a mɛŋgbɛn meyi Misira. Kɔ Yakuba oloku awut ɔn: «Ta ake tɔ nəndeyinɛ nnɔ nəcmɔmənɛnɛ fɔr disrɛ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kɔ Yakuba oloku: «Ine a malɔ meyi Misira. Nətor nəkɔ nəwayɛ su dəndo malɔ, ta padefinɛ dor.» ");
INSERT INTO bsp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kɔ awɛnc a Isifu wəco ŋantor kəkɔway malɔ Misira. ");
INSERT INTO bsp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mba Yakuba ɛnasak fɛ Beŋyamin wəkɔ ɛnapaŋnɛ kɛrɛ kɔ Isifu mɔ pəcɛpsɛ awɛnc aŋa darəŋ, bawo Yakuba ɛnaloku: «Beŋyamin ɔfɔkɔ ta tes tɛlɛc tɔlɔma tɔkɔsɔtɔ kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kɔ awut a Yakuba ŋaŋkɔ Misira kəkɔway malɔ pəmɔ tɔkɔ afum alarəm ŋanckɔ Misira dəkəway malɔ mɔ, bawo dor dɛnayi atɔf ŋa Kanaŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tɛm tatɔkɔ Isifu pəyɔnɛ wəbɛ wəka sədare sa Misira. Nkɔn ɛncwayər afum a Misira fəp malɔ. Kɔ awɛnc a Isifu ŋander ŋatontnɛnɛ Isifu fɔr yɔn kiriŋ, ŋacəp mobu dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kɔ Isifu ɛnəŋk awɛnc aŋa. K'ɛnɛpəl ŋa. Mba owurər fɛ ŋa kəcərɛnɛ. K'olok-lokərɛ ŋa dim deyeŋki, k'eyif ŋa: «Deke nəyɛfɛ-ɛ?» Kɔ awɛnc aŋa ŋaloku kɔ: «Atɔf ŋa Kanaŋ ŋɔ səyɛfɛ, kɔ sənder kəway nnɔ yeri.» ");
INSERT INTO bsp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kɔ Isifu ɛnɛpəl awɛnc aŋa. Mba awɛnc aŋa ŋananɛpəl fɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kɔ Isifu ɛncɛm-cɛmnɛ mere mɔkɔ ɛnawɛrəp tetaŋan mɔ. K'oloku ŋa: «Atɛn mes ŋɔ nəyɔnɛ! Mes ma atɔf ŋaŋɛ mɔ nənder kətɛn, nəkɔ nəloku mi aka atɔf ŋonu.» ");
INSERT INTO bsp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kɔ ŋaloku Isifu: «Ala, mariki mem, dəkəway yeri gbəcərəm sənder. ");
INSERT INTO bsp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Dɛwɛnca dɔ səyɔ fəp fosu, wərkun wəkin okom su. Səsɔkɛnɛ bəkəc! Səclok'əm a dəkətɛn yeri gbəcərəm sənder.» ");
INSERT INTO bsp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kɔ Isifu oloku ŋa: «Kəbupərɛ ti kɔ nəndɛ, mɛtambər ma atɔf ŋaŋɛ mɔ nənder kətɛn nəkɔloku mi ndoronu.» ");
INSERT INTO bsp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kɔ awɛnc aŋa ŋaloku Isifu: «Wəco kɔ mɛrəŋ wɔ sənayi kas kosu kəkom nde Kanaŋ. Mba wəkɔ ɛfɛtɛ su dacɔ mɔ eyi mɔkɔ dɛkɛr kɔ papa kosu, kɔ wəkin ɛnafi.» ");
INSERT INTO bsp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kɔ Isifu oloku ŋa: «Tɔkɔ iloku nu mɔ, ti tɔyɔnɛ kance: Atɛn mes ŋɔ nəyɔnɛ! ");
INSERT INTO bsp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Awa, yɛbəc nyɛ y'indecəmbər nu: Indɛrmɛ nu tewe ta Firawona, nəfɔwur nnɔ ta wəfɛt konu wəlpəs wəkakɔ nəsak dɛkɛr mɔ ender-ɛ. ");
INSERT INTO bsp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nəsom wɛnc konu wəkin pəkɔkɛrɛ wɛnc konu wəkakɔ nəsak dɛkɛr mɔ. Kɔ nəna aŋɛ endesak nnɔ mɔ, dəbili andebɛr nu. Andemɔmən moloku monu, pacərɛ kɔ pəyɔnɛ kance kɔ nəloku-ɛ. Kɔ pəyɔnɛ fɛ ti-ɛ, indɛrmɛ nu tewe ta Firawona atɛn mes ŋɔ nəyɔnɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kɔ Isifu ɛmbɛr ŋa dəbili mata maas. ");
INSERT INTO bsp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tataka ta maas, kɔ Isifu oloku ŋa: «Nəyɔ ntɛ, tɔsɔŋɛ nu kəyi doru. Iŋnesɛ Kanu! ");
INSERT INTO bsp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kɔ pəyɔnɛ a nəsɔkɛnɛ bəkəc-ɛ, nəsak wɛnc konu wəkin dəbili. Nəna alpəs aŋɛ nəkenɛ afum anu yeri kərɛs bawo dor deyi. ");
INSERT INTO bsp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nəkɛrɛn'em wəfɛt konu wəkɔ nəsak dəndo mɔ ntɛ tɔŋsɔŋɛ pamɔmən moloku monu kɔ pəyɔnɛ a kance kɔ-ɛ, ta nədefi.» ");
INSERT INTO bsp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ti tɔ ŋanayɔ, ŋaclokɛnɛ: «Ɛy. Sən'ɛnayɔ ti wɛnc kosu. Bawo anəŋk ayɛk ŋɔn, tɛm ntɛ oncloku su a paŋaŋnɛnɛ kɔ mɔ, ta ancəŋkəlɛ kɔ-ɛ. Ti tɔ ayɛk ŋɔn ŋeyi kəsutɛ su tantɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kɔ Ruben ɛlɛk moloku, k'oloku ŋa: «Inaloku fɛ nu ti ba, ta nəyɔ wan nwɛ pəlɛc? Mba nənacəŋkəl f'em. Ndɛkəl oŋ awer su mecir mɔn.» ");
INSERT INTO bsp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Awɛnc a Isifu ŋanacərɛ fɛ a Isifu eŋne kusu kəŋan bawo wəcepərɛnɛ moloku ɛnayi kɔ dacɔ kɔ awɛnc aŋa. ");
INSERT INTO bsp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kɔ Isifu ɔmbɔlɛ awɛnc aŋa, k'ɔŋkɔ pəbok. Ntɛ elip mɔ, k'oluksərnɛ kədelok-lokər ŋa. K'ɛlɛk Simeyɔŋ awɛnc aŋa dacɔ, k'ɛmbɛr kɔ dəbili fɔr ya awɛnc aŋa kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kɔ Isifu osom a palasɛ ŋa yeri dəlɔba, paluksɛ nwɛ o nwɛ pəsam pɔn nde alɔba ŋɔn, pasarsər ŋa yeri yayɔkɔ. Ti tɔ anayɔnɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kɔ awɛnc ɔn ŋasarsər sɔfale səŋan yeri. Kɔ ŋasumpər dɔpɔ kɔ ŋaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kɔ wɛnc ka Isifu wəkin ende pəsikəli alɔba ŋɔn nde dəkarwaŋse pəfaŋ kəwurɛ sɔfale sɔn yika yɔsɔm, kɔ wəkakɔ ɛnəŋk pəsam pɔn alɔba ŋɔn disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","K'oloku awɛnc aŋa: «Aluks'em pəsam pem. Ipɛmpɛ nnɔ alɔba ŋem.» Kɔ mera yeyi ŋa yamayama kəcərɛ a ŋaŋkɔ dəkəway paluksɛ ŋa sɔ pəsam paŋan. Kɔ ŋayifnɛ: «Cəke cɔ Kanu kəyɔ su tantɛ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kɔ ŋambɛrɛ ndena papa kəŋan Yakuba nde atɔf ŋa Kanaŋ. Kɔ ŋalɔmər kas kəŋan mes mɔkɔ mɛnasɔtɔ ŋa mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kɔ ŋaloku kas kəŋan: «Fum wəkɔ ɔyɔnɛ mariki ma atɔf ŋa Misira mɔ, olok-lokərɛ su dim deyeŋki, k'endeŋɛ su kəyɔnɛ atɛn mes ma Misira mmɛ səndeloku aka nnɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kɔ səloku kɔ a səsɔkɛnɛ bəkəc, bafɔ atɛn mes ŋɔ səyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kɔ Səloku kɔ sɔ a wəco kɔ mɛrəŋ wɔ sənayi kas kosu kəkom, mba wəfɛt kosu eyi dɛkɛr nde Kanaŋ, kɔ wəkin ɛnafi su dacɔ. ");
INSERT INTO bsp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kɔ mariki ma Misira moloku su: ‹Ntɛ tɔ nəndeyɔ a itam kəcərɛ a nəsɔkɛnɛ bəkəc. Nəsak wɛnc konu wəkin nnɔ, nəkenɛ afum anu yeri kərɛsna bawo dor deyi. ");
INSERT INTO bsp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Nəkɔ, nəkɛr'em wəfɛt konu. Tɛm tatɔkɔ, indecərɛ a bafɔ atɛn mes ŋɔ nəyɔnɛ, kɔ nəsɔkɛnɛ bəkəc. Indeluksɛ nu wɛnc konu, tɛm tatɔkɔ nəcəmɛ sɔ kəcaməs konu darəŋ dɔtɔf.›» ");
INSERT INTO bsp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ntɛ ŋambɛrɛ ndaraŋan akɔ ŋayuk malɔ mɔkɔ ŋanakɛrɛ mɔ, kɔ fəp faŋan ŋanəŋkəs-nəŋkəs pəsam paŋan nde lɔba yaŋan disrɛ. Ŋa kɔ kas kəŋan ntɛ ŋanəŋkəs pəsam nde lɔba yaŋan disrɛ mɔ, kɔ kənesɛ kənder ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kɔ kas kəŋan Yakuba oloku ŋa: «Awut em ŋɔ nəfaŋ kəbaŋsər im! Isifu eyi fɛ sɔ doru, Simeyɔŋ eyi fɛ sɔ doru, kɔ nəfaŋ sɔ kəlɛkər im Beŋyamin-ɛ! In'ɔ mamɔkɔ fəp mendetɔrəs.» ");
INSERT INTO bsp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kɔ Ruben oloku papa kɔn: «Məde məyɔ padif awut em mɛrəŋ k'intɔkɛr'am Bɛŋyamin. Məbɛr im kɔ dəwaca, indekɛr'am kɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kɔ Yakuba oloku: «Wan kem ɔfɔtor kɔ nəna, bawo wəbek'ɔn Isifu efi. Sona s'eyi oŋ. Kɔ tɛlɛc tɔsɔtɔ kɔ dɔpɔ-ɛ, cəke cɔ nəndeyɔ-ɛ, tɛm tatɔkɔ nəŋsɔŋ'em kətorɛ cəfon cem cəfer dabiya kɔ abəkəc ŋocuy nde afi ŋayi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Dor dɛncbɛk kəbɛk dəm dɔtɔf. ");
INSERT INTO bsp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ntɛ ŋalip kədi malɔ mɔkɔ ŋanakɛrɛ kəyɛfɛ Misira mɔ, kɔ Yakuba oloku awut ɔn: «Nəluksərnɛ, nəkɔ nəwayɛ su yeri yepic.» ");
INSERT INTO bsp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kɔ Yuda oloku kɔ: «Wəbɛ ka Misira ɛnabeŋnɛ su: ‹Ta inəŋk nu sɔ cəro, kɔ nəntɔkɛr'em wɛnc konu wəlpəs-ɛ.› ");
INSERT INTO bsp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kɔ məŋwosɛ kəsak wəfɛt kosu səkɔ-ɛ, səntor Misira kəkɔway'am yeri. ");
INSERT INTO bsp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kɔ məntɔwosɛ kəsak kɔ səkɔ-ɛ, səfɔtam kətor Misira kəkɔway'am yeri, bawo wərkun wəkakɔ ɛnaloku: ‹Ta inəŋk nu sɔ cəro kɔ nəntɔkɛr'em wəfɛt konu-ɛ.›» ");
INSERT INTO bsp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kɔ Yakuba oloku: «Ta ake tɔ nənayɔn'em pəlɛc tantɛ, kəcloku wərkun wəkakɔ a nəyɔ wəfɛt-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kɔ awut ɔn ŋaloku: «Wərkun wəkakɔ ɛnayifət su pəlarəm tetosu kɔ tokomɛnɛ tosu, pəcyif su: ‹Papa konu ɔsɔrɔyi doru? Nəyɔ wɛnc wəlɔma sɔ?› Kɔ səluksɛ kɔ moloku mamɔkɔ. Sənatam kəcərɛ, a endeloku su: ‹Nəkɔ nəkɛr'em wəfɛt konu!›?» ");
INSERT INTO bsp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kɔ Yuda oloku papa kəŋan Yakuba: «Məsak wəfɛt səkɔ kɔ ina. Səndeyɛfɛ səkɔ, tɔsɔŋɛ su kədeyi doru ta səfi-ɛ, məna papa, awut asu kɔ səna. ");
INSERT INTO bsp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","In'ɔsɔŋ əm temer, teta wəfɛt: In'ɔ məndewer kɔ, kɔ intɔkɛr'am kɔ-ɛ, ta iluksɛ kɔ ider ibɛr əm kɔ dəwaca-ɛ, in'endesarɛ tɛm tatɔkɔ kiciya doru o doru nnɔ məyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Patɔbɔlsɛnɛ moloku-ɛ, kɔ səntam ntɛ kəkɔ kəmɛrəŋ səlukus.» ");
INSERT INTO bsp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kɔ papa kəŋan Yakuba oloku ŋa: «Bawo teyi tantɛ, nəkɔ nəyɔ ntɛ: Nəlɛk yopocɛ, ca ya atɔf ŋaŋɛ yɔlɔma nətɔmpərɛnɛ wərkun wəkakɔ: Dɔni, mɛsɛ ma cəme mepic, cigbili, yamaku, mɛŋgbɛn ma yalakɛ kɔ cɔla. ");
INSERT INTO bsp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nəlɛk pəsam pɔkɔ nənakekərɛ tɔcɔkɔ-cɔkɔ mɔ kəmɛrəŋ. Nəluksɛ pəsam pɔkɔ anabɛrɛ nu dəlɔba mɔ, tɔlɔma ŋanaciya kəciya dəm. ");
INSERT INTO bsp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Nəlɛk wəfɛt konu nəkɔ ndena wərkun wəkawɛ. ");
INSERT INTO bsp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Intola MARIKI nwɛ ɛntam mes ma doru fəp mɔ, pəsɔŋɛ wərkun wəkakɔ pəkɔ pəyɔnɛ nu nɔnɔfɔr pəsak wɛnc konu wəkɔ osumpər mɔ nəder, nəkɛrɛnɛ sɔ Beŋyamin! Kɔ ina kɔ pəyɔnɛ a awut em ŋandewur im dəwaca-ɛ, awa ŋawur im dəwaca!» ");
INSERT INTO bsp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kɔ awut a Yakuba ŋalɛk yopocɛ yayɔkɔ kɔ pəsam pɔkɔ ŋanakekərɛ tɔcɔkɔ-cɔkɔ mɔ kəmɛrəŋ, kɔ Beŋyamin. Kɔ ŋayɛfɛ, kɔ ŋantor Misira. Kɔ ŋaŋkɔ ŋamentərnɛ Isifu. ");
INSERT INTO bsp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ntɛ Isifu ɛnəŋk Beŋyamin kɔ awɛnc aŋa mɔ, k'oloku wəcamsɛ kɔn: «Məbɛrsɛ afum akaŋɛ dɛkɛr, mədif pɔcɔl, məcoŋ, bawo afum akaŋɛ ŋɔ səndenadi mɔkɔ yeri tofo tin daŋana.» ");
INSERT INTO bsp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kɔ fum wəkakɔ ɔyɔ tɔkɔ Isifu ɛnaloku kɔ mɔ, k'ɛmbɛrsɛ afum aŋɛ dɛkɛr ndena Isifu. ");
INSERT INTO bsp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kɔ awɛnc a Isifu ŋanesɛ ntɛ anabɛrsɛ ŋa ndena Isifu mɔ, kɔ ŋaloku: «Teta pəsam pɔkɔ anasak lɔba yosu disrɛ mɔ ti t'aŋkɛrɛ su nnɔ. Aŋkɛrɛ su nnɔ, ŋadewɛkərnɛ su ŋacəmbər su dacar kɔ sɔfale sosu.» ");
INSERT INTO bsp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kɔ ŋalɔtərnɛ wəcamsɛ ka Isifu, kɔ ŋaloku kɔ moloku mmɛ dəkusuŋka: ");
INSERT INTO bsp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Nəŋaŋnɛnɛ su, mariki mem! Sənader tɔcɔkɔ-cɔkɔ kədeway yeri. ");
INSERT INTO bsp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ntɛ sənclukus mɔ, kɔ səŋkɔsikəli lɔba yosu karwaŋse, kɔ sənəŋk nwɛ o nwɛ pəsam pɔn nde alɔba ŋɔn. Mba səŋkɛrɛnɛ sɔ pi. ");
INSERT INTO bsp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Səŋkɛrɛnɛ sɔ pəsam pɔlɔma kədeway yeri. Səncərɛ fɛ nwɛ ɛnabɛr pəsam papɔkɔ nde lɔba yosu disrɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kɔ wərkun nwɛ oloku ŋa: «Ta nənesɛ bəkəc yɔfɔr nu! Kanu konu kɔ, Kanu ka papa konu kənasɔŋ nu pəsam nde lɔba yonu. Pəsam ponu pɛnader im.» Kɔ wəcamsɛ ka Isifu owurɛnɛ Simeyɔŋ nnɔ awɛnc aŋa ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kɔ fum wəkawɛ ɛmbɛrsɛ ŋa nde kəlɔ ka Isifu disrɛ. K'ɔsɔŋ ŋa domun, kɔ ŋambikɛnɛ wɛcək. K'ɔsɔŋ sɔ sɔfale səŋan yika. ");
INSERT INTO bsp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kɔ ŋalompəs kəpocɛ kəŋan, ŋackar kəder ka Isifu daŋ, bawo ŋananenɛ Isifu pəcloku: «Sən'endedi yeri daŋ dɔmɔkɔ kɔ ŋa.» ");
INSERT INTO bsp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ntɛ Isifu ender dɛkɛr daŋ mɔ, kɔ ŋasɔŋ Isifu yopocɛ yaŋan nyɛ ŋanatɔmpərɛnɛ kɔ mɔ, kɔ ŋantontnɛnɛ kɔ dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kɔ Isifu eyifət ŋa teta dis daŋan, k'eyif ŋa: «Papa konu wətem wəkɔ nəŋle mɔ, ɛntamnɛ? Ɔsɔrɔyi doru?» ");
INSERT INTO bsp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kɔ awɛnc aŋa ŋaloku: «Wəcar kam, papa kosu ɛntamnɛ, ɔsɔrɔyi doru.» Kɔ ŋantontnɛnɛ Isifu. ");
INSERT INTO bsp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kɔ Isifu eyekti fɔr. Ntɛ ɛnəŋk Beŋyamin wəpaŋnɛ kɔn kɛrɛ mɔ, k'eyif ŋa: «Wəkawɛ ɔyɔnɛ wəfɛt konu wəlpəs, wəkɔ nənalok'im tetɔn mɔ?» K'ɔnɔcər: «Kanu kəmar əm wan kem!» ");
INSERT INTO bsp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kɔ Isifu oncopər moloku, bawo ɛnctɛyɛ-tɛyɛ pəbotu pa kənəŋk ka wɛnc, ɛnafaŋ kəbok. Kɔ Isifu ɛmbɛrɛ dukulɔ dɔn, k'ombok di haŋ. ");
INSERT INTO bsp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kɔ Isifu ɛsak kəbok, k'ombufərnɛ kəro, k'owur. K'ɛsɛp kətɔbok sɔ fɔr ya awɛnc aŋa kiriŋ. K'oloku: «Nəwurɛnɛ su yeri.» ");
INSERT INTO bsp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","K'ambɛrɛ Isifu yeri taciŋa, awɛnc aŋa taciŋa, kɔ aMisira ŋa ŋayi sɔ taciŋa. Bawo aMisira ŋancwosɛ fɛ kəpaŋnɛ dap da yeri kɔ aHebəre. ");
INSERT INTO bsp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kɔ awɛnc a Isifu ŋandɛ fɔr yɔn kiriŋ. Kəyɛfɛ ka coco ca papa kəŋan haŋ wəfɛt kəŋan nwɛ o nwɛ kɔ dəkəndɛ dɔn. Kɔ ŋayɛfɛ kəlokɛnɛ kəciyanɛ nkɛ kəyi ŋa ntɛ Isifu osumpər ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kɔ Isifu ɛmbɛrɛnɛ ŋa yeri yɔn nyɛ nkɔn encdi mɔ. Mba pɛbɛrɛnɛ mpɛ ɛnasɔŋ Beŋyamin mɔ pɛnala kəcamət, pɛtas pa akɔ. Kɔ ŋamun haŋ kɔ pəntəŋnɛ ŋa kɔ nkɔn Isifu. ");
INSERT INTO bsp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kɔ Isifu oloku wəcamsɛ kɔn: «Məlasɛ afum akaŋɛ malɔ dəlɔba pəmɔ tɔkɔ lɔba yaŋan yɛntam kəlɛk malɔ mɔ. Məbɛr pəsam paŋan nde lɔba yaŋan disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Məbɛr sɔ apɔt ŋem ŋomunɛ ŋa gbeti ŋɔkɔ, nde alɔba ŋa wəfɛt wəkɔ kɔ pəsam pɔkɔ ɛŋkɛrɛ kədewayɛ malɔ mɔ.» Kɔ wəcamsɛ ka Isifu ɔyɔ tɔkɔ Isifu ɛnaloku kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Dec dendesɔk, k'asak afum aŋɛ kəlukus nde ndaraŋan kɔ sɔfale səŋan. ");
INSERT INTO bsp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ŋawur dare disrɛ ta ŋantabɔlɛ-ɛ, kɔ Isifu oloku wəcamsɛ kɔn: «Məyɛfɛ məcəmɛ afum aŋɛ darəŋ haŋ məbəp ŋa. Məyif ŋa: ‹Ta ake tɔ nəsɔŋɛ pətɔt kəway pəlɛc-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bafɔ apɔt ŋaŋɛ ŋɔ mariki mem oŋmunɛ, ŋɔsɔŋɛ kɔ kəcərɛ tɔkɔ tender mɔ ba? Nənciya kəyɔ tantɛ nəyɔ mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kɔ wəcamsɛ ka Isifu ɛmbɛlər ŋa k'ɛmbəp ŋa. K'ɔŋgbɔkərɛnɛ ŋa moloku mɔkɔ Isifu ɛnasom kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kɔ ŋaloku wəcamsɛ ka Isifu: «Ta ake tɔ mariki oŋlok-lokərɛ su tantɛ-ɛ? Səna amarəs am səfɔtam kəyɔ tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sənuŋkɛnɛ kərɛsna kɔ səŋkɛrɛ nu pəsam pɔkɔ sənanəŋk nde lɔba yosu mɔ, kəyɛfɛ Kanaŋ. Ta ake tɔ səndekiyɛnɛ pəsam kɔ pəyi fɛ ti kɛma nde kəlɔ ka mariki mam-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nwɛ o nwɛ aŋnəŋkɛ ca yayɔkɔ mɔ, padif kɔ, kɔ səna fəp səyɔnɛ acar a mariki mem!» ");
INSERT INTO bsp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kɔ wəcamsɛ ka Isifu oloku ŋa: «Awa. Ine nu sim! Nwɛ o nwɛ aŋnəŋkɛ paka mɔ, ɔŋyɔnɛ wəcar kem. Nəna alpəs aŋɛ nəŋkɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kɔ ŋambɛlkər-bɛlkər kətorɛ-torɛ lɔba yaŋan dəntɔf kɔ ŋasikəli-sikəli yi. ");
INSERT INTO bsp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kɔ wəcamsɛ ka Isifu oncop kəfen-feni kəyɛfɛ alɔba ŋa wəbeki, k'ɛləpsər alɔba ŋa wəfɛt. Kɔ wəcamsɛ ka Isifu ɔŋkɔ pənəŋk apɔt nŋɛ nde alɔba ŋa Beŋyamin. ");
INSERT INTO bsp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kɔ awɛnc a Isifu ŋawal-wali yamos yaŋan, kɔ ŋandəndəsər sɔ sɔfale səŋan lɔba yaŋan. Kɔ ŋaluksərnɛ sɔ dare disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda kɔ awɛnc aŋa ŋander sɔ nda Isifu wəkɔ ɛnasɔrɔyi kəfo kaŋkɔ ŋanasak kɔ mɔ. Kɔ ŋantɛmpɛnɛ dəntɔf Isifu fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kɔ Isifu eyif ŋa: «Cəke cɔ nəyɔ tantɛ-ɛ? Nəncərɛ fɛ a intam kəcərɛ tɔkɔ tɔŋgbɔpnɛ mɔ, tɔkɔ tender mɔ?» ");
INSERT INTO bsp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kɔ Yuda oloku: «Cəke c'indeloku mariki mem-ɛ? Cəke c'indeloku mətam kəlaŋ su-ɛ? Kanu kəmbəp amarəs am ŋaciya. Səyɔnɛ oŋ acar a mariki mosu, kəyɛfɛ səna haŋ wəkɔ anəŋk apɔt alɔba ŋɔn disrɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kɔ Isifu oloku: «Ifɔdebəc ti tatɔkɔ! Fum nwɛ anəŋkɛ apɔt mɔ, endeyɔnɛ wəcar kem. Kɔ nəna, nəpɛrnɛ nəkɔ ndena papa konu bəkəc yoforu disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kɔ Yuda ɔlɔtərnɛ Isifu k'oloku kɔ: «Ilɔktərn'am mariki, məwosɛ wəmarəs kam pəlok-lokər əm ta abəkəc ŋɛp'am nnɔ eyi mɔ! Bawo məyi pəmɔ Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tɔcɔkɔ-cɔkɔ Mariki ɛnayifət amarəs ɔn pəcloku: ‹Nəyɔ kas kɔ pəyɔnɛ fɛ ti-ɛ wəfɛt ba?› ");
INSERT INTO bsp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kɔ səwosɛnɛ kɔ: ‹Səyɔ kas kətem, kɔ wəfɛt wan nwɛ oŋkom detem dɔn disrɛ mɔ. Wəpaŋnɛ kɔn kɛrɛ ɛnafi. Kɛrɛ kɔn kəkom, sona s'eyi oŋ, kɔ kas ɔmbɔtər kɔ.› ");
INSERT INTO bsp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kɔ məloku amarəs am: ‹Nəkɔ nəkɛrɛ wəfɛt konu inəŋk kɔ fɔr yem.› ");
INSERT INTO bsp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kɔ səloku mariki mem: ‹Wəfɛt kosu ɔfɔtam kəyɛfɛ papa kosu kəsək. K'ɛyɛfɛ kɔ kəsək-ɛ, papa kosu eŋfi.› ");
INSERT INTO bsp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kɔ məloku amarəs am: ‹Kɔ nəntɔkɛrɛ wəfɛt konu-ɛ, ta inəŋk nu sɔ dɛ.› ");
INSERT INTO bsp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ntɛ səluksərnɛ ndena papa kosu wəmarəs kam mɔ, kɔ səluksɛ kɔ moloku ma məna mariki mem. ");
INSERT INTO bsp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kɔ papa kosu oloku: ‹Nəkɔ sɔ nəwayɛ su yeri yepic.› ");
INSERT INTO bsp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kɔ səloku kɔ: ‹Səfɔtam kəkɔ. Mba kɔ səŋsolɛ wəfɛt kosu-ɛ, səŋkɔ, bawo wərkun wəkakɔ ɔfɔwosɛ kənəŋk su cəro ta səŋkenɛ kɔ wəfɛt kosu pənəŋk-ɛ.› ");
INSERT INTO bsp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kɔ papa kosu wəmarəs kam oloku su: ‹Nəncərɛ a wəran kem awut mɛrəŋ ŋ'ɛnakom'em. ");
INSERT INTO bsp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kɔ wəkin ende pəsak im. Ilaŋ ti a wəkakɔ, anawatəri-watəri kɔ, bawo intanəŋk fɛ kɔ haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kɔ nəmbaŋər im sɔ ndɛkəl wəkawɛ-ɛ, tes tedekɔsɔtɔ kɔ-ɛ, pəcuy disrɛ pɔ nəndesɔŋ'em kətorɛ cəfon cem cəfer dabiya nde afi ŋayi mɔ.› ");
INSERT INTO bsp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ndɛkəl oŋ k'ilukus nde wəmarəs kam, papa kem eyi mɔ, ta iŋkenɛ kɔ wəfɛt kosu nwɛ abəkəc ŋɔn ŋosumpər mɔ, ");
INSERT INTO bsp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","eŋfi katina kɔ ɔntɔnəŋkɛ su wəfɛt kosu-ɛ. Tɛm tatɔkɔ amarəs am ŋandesɔŋɛ wəmarəs kam papa kosu kətorɛnɛ cəfon cɔn cəfer dabiya pəcuy disrɛ. ");
INSERT INTO bsp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Bawo ina wəmarəs kam isɔŋ kɔ temer kəluksɛ kɔ sɔ wan kɔn, icloku papa kosu: ‹K'intɔluks'am wəfɛt kosu-ɛ, in'endesarɛ kiciya doru o doru nnɔ papa kem eyi mɔ!› ");
INSERT INTO bsp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ndɛkəl ilɛtsɛn'am: Ina wəmarəs kam iyi nnɔ. Iyɔnɛ wəcar ka məna mariki mem. Wəfɛt kosu pəlukus kɔ awɛnc im aŋa nde papa kosu eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Cəke c'intam kəlukus, ta iluksɛ wəfɛt kosu nnɔ papa kosu eyi mɔ-ɛ? Ha! Intola fɛ kənəŋk pəlɛc pɔkɔ pendekɔsɔtɔ papa kosu mɔ, k'intɔluksɛ kɔ wəfɛt kosu-ɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Isifu ɛnatam fɛ sɔ kəmɛŋk mɛncər nnɔ afum akɔ ŋanayi kɔ kəsək mɔ dacɔ, k'oŋkulɛ: «Nəwurɛnɛ afum fəp!» Ali wəkin ɛnayi fɛ sɔ Isifu kəsək ntɛ encmentərnɛ awɛnc aŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","K'ɛyɛfɛ kəbok, aMisira kɔ aka kəlɔ ka Firawona ŋane kɔ dim kəbok. ");
INSERT INTO bsp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kɔ Isifu oloku awɛnc aŋa: «In'ɔfɔ Isifu! papa kem ɔsɔrɔyi doru ba?» Mba awɛnc aŋa ŋanatam fɛ kəluksɛ kɔ moloku ntɛ pənciyanɛ ŋa kənəŋk kɔ sɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kɔ Isifu oloku awɛnc aŋa: «Ilɛtsɛnɛ nu, nəlɔtərn'em.» Kɔ ŋalɔtərnɛ kɔ. K'oloku ŋa sɔ: «In'ɔfɔ Isifu wɛnc konu nwɛ nənacaməs a kɔ aŋkɛrɛ kɔ Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ndɛkəl oŋ, ta nəwakəsnɛ. Ta pətɛlɛ nu kəcaməs kem pakɛr'em nnɔ, bawo kəbum konu, nəyi doru kɔ Kanu kənabɛlkər'em kəkɛrɛ nnɔ, iyi nu kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Teren ta mɛrəŋ ta dor tɔ tantɛ dɔtɔf. Pəncəmɛ meren kəcamət afɔde pacbifti, afɔde pactɛl. ");
INSERT INTO bsp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kanu kəkɛr'em iyi nu kiriŋ, ntɛ tɔŋsɔŋɛ nu kəsɔtɔ ka nnɔ atɔf ŋaŋɛ yuruya mɔ, imar nu ta nəfi, icbum nu pəyeŋki pampɛ ayi kəcepərɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ndɛkəl oŋ, bafɔ nən'ɛkɛr'em nnɔ, mba Kanu kɔ. Kanu kəncəmbər im iyɔnɛ papa ka Firawona, mariki ma kəlɔ kɔn disrɛ, wəkiriŋ ka sədare sa Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nəroknɛ nəpɛ nde papa kem eyi mɔ. Nəkɔ nəloku kɔ: ‹Ntɛ tɔ wan kam Isifu ɛnaloku su: Kanu kəncəmbər im mariki ma atɔf ŋa Misira fəp. Ta məwon kəder nnɔ iyi mɔ! ");
INSERT INTO bsp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nde atɔf ŋa Kosɛŋ ŋɔ məŋkɔyi, məfɔdebɔl'em, kəyɛfɛ məna papa kəbəp awut am, awut-sɔ am, yɔcɔl yam yɔpɔŋ kɔ yɛfɛt haŋ ca nyɛ məyɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nnɔ taŋ indetam kəcsɔŋ əm ca fəp bawo pəsɔrɔcəmɛ meren kəcamət a dor declip. Ti disrɛ dor dɔfɔdesumpər yɔkɔ məyɔ mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«Fɔtɔ nəŋgbətnɛ ti fɔr yonu, kɔ wəfɛt kem Beŋyamin ɛŋgbətən'em fɔr yɔn yati a in'oŋlok-lokər nu. ");
INSERT INTO bsp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nəkɔ nəloku papa kem kɔ pəlel mpɛ isɔtɔ Misira mɔ fəp. Nəlɔmər kɔ ntɛ nənəŋk dɛ mɔ fəp. Nəroknɛ nətorɛnɛ papa kem nnɔ iyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kɔ Isifu ɛnapsərnɛ sɔ wəfɛt kɔn Beŋyamin dəkilim, kɔ ŋayɛfɛ kəbok. ");
INSERT INTO bsp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kɔ Isifu oncupəs awɛnc aŋa fəp. Kɔ ŋandeləpsər kəndɛ tofo tin kɔ ŋalok-loku. ");
INSERT INTO bsp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kɔ moloku mamɔkɔ mɛsam kəlɔ ka Firawona fəp disrɛ, a awɛnc a Isifu ŋanderna mɔkɔ. Kɔ toloku tatɔkɔ tɔmbɔt Firawona kɔ amarəs ɔn. ");
INSERT INTO bsp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kɔ Firawona oloku Isifu: «Məloku awɛnc əm aŋa: ‹Nəyɔ ntɛ: Nəlɛk yɔcɔl yonu, nəkɔ atɔf ŋa Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Nəlɛk papa konu kɔ afum ɔn, nəder nnɔ iyi mɔ. Indeyɔnɛ nu ntɛ o ntɛ tentesɛ atɔf ŋa Misira mɔ. Nənde nəcdi yeri yoboŋu ya Misira.› ");
INSERT INTO bsp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Iwos'am kəloku awɛnc əm aŋa: ‹Nəyɔ ntɛ: Nəlɛk cibil atɔf ŋa Misira, nəkɔ nəlɛk awut kɔ aran anu kɔ papa konu nəder.› ");
INSERT INTO bsp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ta nəŋaŋnɛ mɛlər teta ca yonu yɔkɔ nəndekɔsak di mɔ, bawo mpɛ o mpɛ peyi atɔf ŋa Misira pɔyɔnɛ pɔtɔt mɔ, pendeyɔnɛ ponu.» ");
INSERT INTO bsp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kɔ awut a Yakuba ŋayɔ tatɔkɔ. Kɔ Isifu ɔsɔŋ awɛnc aŋa cibil pəmɔ tɔkɔ Firawona ɛnasom kɔ ti mɔ. K'ɔsɔŋ ŋa sɔ yeri yɔkɔ ŋanakɔ kəcdi dɔpɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kɔ Isifu ompocɛ awɛnc aŋa fəp yamos yɛsəkpərɛ k'ɔsɔŋ Beŋyamin gbeti mɛncəmbəl masar maas (300) kɔ yamos kəcamət yɛsəkpərɛ. ");
INSERT INTO bsp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ca nyɛ yɔ Isifu ɛnasɔŋ pakenɛ kas kəŋan: Sɔfale surkun wəco səsarɛ ca yɔtɔt ya Misira, kɔ sɔfale səran wəco səsarɛ malɔ, cəcom kɔ yeri ta ntɛ ɔŋkɔsumpər dɔpɔ kəder Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kɔ Isifu ɛsak awɛnc aŋa kɔ ŋalukus. K'oloku ŋa: «Ta nəkɔcɔp dɔpɔ de!» ");
INSERT INTO bsp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kɔ awɛnc a Isifu ŋayɛfɛ Misira kɔ ŋampɛ Kanaŋ ndena papa kəŋan Yakuba. ");
INSERT INTO bsp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kɔ awɛnc a Isifu ŋaloku kas kəŋan teta Isifu kiyi kɔn doru sɔ. Kɔ ŋaloku kas kəŋan a Isifu ɔyɔnɛ wəbɛ wəka atɔf ŋa Misira fəp. Mba abəkəc ŋɛnapɛ fɛ Yakuba bawo ɛnalaŋ fɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kɔ ŋalɔmər kɔ moloku mɔkɔ Isifu ɛnasom ŋa mɔ fəp. Ntɛ Yakuba ɛnanəŋk cibil cəkɔ Isifu ɛnasak kədelɛk kɔ mɔ, ti tɛnasɔŋɛ kɔ oŋ abəkəc kəpɛ. ");
INSERT INTO bsp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kɔ Yakuba oloku: «Ilaŋ ti oŋ! Wan kem Isifu ɔsɔrɔyi doru! Indekɔnəŋk kɔ a icfi.» ");
INSERT INTO bsp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kɔ Yakuba ɔŋkɔ kɔ ca yɔkɔ ɛnayɔ mɔ. Ntɛ ɛmbɛrɛ Bersaba mɔ, k'oloŋnɛ di Kanu ka papa kɔn Siyaka. ");
INSERT INTO bsp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kɔ Kanu kəlok-lokər Yakuba kənəŋk ka pibi disrɛ. Kɔ Kanu kəwe kɔ: «Yakuba! Yakuba!» K'owosɛ: «In'ɛwɛ!» ");
INSERT INTO bsp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kɔ Kanu kəloku kɔ: «In'ɔfɔ ina Kanu, Kanu ka papa kam. Ta mənesɛ kətor ka Misira. Bawo difɔ iŋkɔsɔŋ'am kəyɔnɛ ka kas ka afum alarəm. ");
INSERT INTO bsp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Sən'endesol kətor ka Misira. In'endesɔŋ'am sɔ kəpɛ. Isifu yati endemɛp'əm fɔr waca wɔn.» ");
INSERT INTO bsp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kɔ Yakuba ɛyɛfɛ Bersaba. Kɔ awut a Yakuba ŋaŋkekərɛ kas kəŋan, aran aŋan, kɔ awut aŋan cibil ca dəntɔf disrɛ ncɛ Firawona ɛnasɔŋ pakɔ kɛrɛ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kɔ ŋalɛk sɔ yɔcɔl yaŋan kɔ ca yɔkɔ ŋanasɔtɔ atɔf ŋa Kanaŋ mɔ. Kɔ Yakuba ɔŋkɔ Misira kɔ afum ɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","K'eŋkenɛnɛ atɔf ŋa Misira yuruya yɔn fəp, awut ɔn arkun kɔ awut-sɔ ɔn arkun, awut ɔn aran kɔ awut-sɔ ɔn aran. ");
INSERT INTO bsp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mewe ma awut a Yakuba mɔ mmɛ, aŋɛ ŋanakɔ Misira mɔ. Yakuba kɔ awut ɔn: Coco ca Yakuba, Ruben. ");
INSERT INTO bsp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Awut a Ruben: Henok, Palu, Hecərɔŋ, kɔ Karmi. ");
INSERT INTO bsp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Awut a Simeyɔŋ: Yemuyɛl, Yamin, Ohad, Yakin, kɔ Cohar, kɔ Sawul wan wərkun wəka wəKanaŋara. ");
INSERT INTO bsp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Awut a Lewy: Kerson, Kehat, kɔ Merari. ");
INSERT INTO bsp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Awut a Yuda: Hɛr, Onan, Sɛlah, Perɛc, kɔ Serah, mba Hɛr kɔ Onan ŋanafi nde atɔf ŋa Kanaŋ. Awut a Perɛc ŋanayɔnɛ Hecərɔŋ kɔ Hamul. ");
INSERT INTO bsp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Awut a Isakar: Tola, Puwa, Yɔb, kɔ Simrɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Awut a Sebulɔŋ: Sered, Ɛlɔŋ, kɔ Yahalɛl. ");
INSERT INTO bsp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Awut akaŋɛ ŋɔ Leya ɛnakomɛ Yakuba nde Padaŋ-Aram, mba wan kɔn wəran Dina eyi fɛ ti. Kəlɛk awut ɔn aran haŋ arkun, ŋanakɔ afum wəco maas (33). ");
INSERT INTO bsp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Awut a Kadu: Cifyɔn, Haki, Suni, Ecəbɔŋ, Eri, Arodi, kɔ Areli. ");
INSERT INTO bsp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Awut a Asɛr: Yima, Yisuwa, Yisuwi, kɔ Beriya, kɔ Sera wəkirɛ kəŋan. Wan ka Beriya: Hebɛr kɔ Malkiyɛl. ");
INSERT INTO bsp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Awut a Silpa wəmarəs nwɛ Labaŋ ɛnasɔŋ wan kɔn wəran Leya mɔ, ŋɔ akakɔ aŋɛ ɛnakomɛ Yakuba mɔ. Ŋanayi afum wəco kɔ camət-tin (16). ");
INSERT INTO bsp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Awut a Rasɛl, wəran ka Yakuba: Isifu kɔ Beŋyamin. ");
INSERT INTO bsp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kɔ Isifu nkɔn oŋkom Misira awut mɛrəŋ: Manase kɔ Ɛfrayim, aŋɛ Asnat wan wəran ka Potifera wəloŋnɛ ka dare da Hon, ɛnakomɛ Isifu mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Awut a Beŋyamin: Bela, Bekɛr, Asubɛl, Kera, Naman, Ehi, Rɔs, Mupim, Hupim, kɔ Ardu. ");
INSERT INTO bsp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yuruya yayɛ yɔ Rasɛl ɛnasɔtɔnɛ nkɔn Yakuba, ŋanayi afum wəco kɔ maŋkəlɛ (14). ");
INSERT INTO bsp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Wan ka Dan: Husim. ");
INSERT INTO bsp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Mewe ma awut a Naftali mɛmɛ: Yacel, Kumi, Yecer, kɔ Silem. ");
INSERT INTO bsp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Awut a Bilha ŋɔ akakɔ, Bilha nwɛ Labaŋ ɛnasɔŋ wan kɔn wəran Rasɛl mɔ pəyɔ kɔ wəcar, k'oŋkomɛ ŋa Yakuba. Ŋanayi afum camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Afum aŋɛ ŋanacɛpsɛ Yakuba kəkɔ ka Misira mɔ, ŋanayi afum wəco camət tin kɔ camət tin (66) aŋɛ ŋanayɔnɛ akom ɔn mɔ, alɔm fɛ aran a awut ɔn arkun de. ");
INSERT INTO bsp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Awut a Isifu aŋɛ ɛnakom Misira mɔ: Ŋanayi awut mɛrəŋ. Afum a Yakuba aŋɛ ŋanacəpsɛ kɔ darəŋ kəkɔ ka Misira mɔ, ŋanayi fəp faŋan afum wəco camət mɛrəŋ (70). ");
INSERT INTO bsp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kɔ Yakuba osom Yuda pəyi kɔ kiriŋ kəkɔ ka Kosɛŋ ndena Isifu. Kɔ Yuda ɛmbɛrɛ atɔf ŋa Kosɛŋ. ");
INSERT INTO bsp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kɔ Isifu ɛlɛk abil ŋɔn k'ɛmpɛ Kosɛŋ kəkɔbəpɛnɛ kɔ papa kɔn Yakuba. Isifu ŋaŋkɔwurərɛnɛ kɔ papa kɔn, k'ɛnapsərnɛ kɔ dəkilim k'ɛyɛfɛ kəbok. K'ombok haŋ. ");
INSERT INTO bsp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kɔ Yakuba oloku Isifu: «Intam oŋ kəfi bawo inəŋk əm kəro, k'incərɛ oŋ a məyi doru!» ");
INSERT INTO bsp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kɔ Isifu oloku awɛnc aŋa kɔ afum a papa kɔn: «Ilukus ikɔ iluksɛ Firawona kəbɛrɛ konu. Ikɔ iloku kɔ a: ‹Awɛnc im aŋa kɔ afum a papa kem aŋɛ ŋanayi atɔf ŋa Kanaŋ mɔ, ŋander nnɔ iyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Afum akɛk a ŋkesiya, cir, kɔ cəna ŋɔ ŋayɔnɛ, bawo akɛk a acɔl ŋɔ. Ŋaŋkɛrɛ yɔcɔl yaŋan fəp kɔ ca yaŋan.› ");
INSERT INTO bsp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kɔ tɛm tendebəp ntɛ Firawona endewe nu pəcyif nu: ‹Ake'yɔnɛ yɛbəc yonu-ɛ?› ");
INSERT INTO bsp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Nəcloku kɔ: ‹Sən'acar am, akɛk ŋɔ səyɔnɛ, kəyɛfɛ dɛtɛmp dosu haŋ mɔkɔ, yɛbəc yayɔkɔ yɔ səmbəpɛ akombəra asu.› Ti disrɛ, nəyi Kosɛŋ, bawo pəcyik-yik aMisira kəndɛ kɔ akɛk a ŋkesiya kɔ cir.» ");
INSERT INTO bsp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kɔ Isifu ɔŋkɔ pəluksɛ ti Firawona. K'oloku kɔ: «Awɛnc im aŋa kɔ papa kem ŋander kəyɛfɛ ka atɔf ŋa Kanaŋ kɔ yɔcɔl yaŋan ŋkesiya, cir kɔ cəna kəbəp ka ca yaŋan fəp. Ŋayi tantɛ atɔf ŋa Kosɛŋ.» ");
INSERT INTO bsp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kɔ Isifu ɛlɛk awɛnc aŋa kəcamət k'ementər ŋa Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kɔ Firawona eyif awɛnc a Isifu: «Ake'yɔnɛ yɛbəc yonu-ɛ?» Kɔ awɛnc a Isifu ŋaloku Firawona: «Sən'acar am, akɛk a ŋkesiya, cir kɔ cəna ŋɔ səyɔnɛ pəmɔ papa kosu aŋa.» ");
INSERT INTO bsp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kɔ ŋaloku sɔ Firawona: «Sənder kədendɛ atɔf ŋaŋɛ, bawo dəkəcɔl deyi fɛ sɔ nde acar am ŋayɛfɛ mɔ, kɔ dor dɛmbɛk kəbɛk dəm atɔf ŋa Kanaŋ. Məwosɛ oŋ acar am kəndɛ atɔf ŋa Kosɛŋ.» ");
INSERT INTO bsp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kɔ Firawona oloku Isifu: «Papa kam kɔ awɛnc əm aŋa ŋander nnɔ məyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Atɔf ŋa Misira ŋey'əm dəwaca, mədəs papa kam kɔ awɛnc əm aŋa nnɔ pəntesɛ ŋa Kosɛŋ mɔ, kɔ məncərɛ sɔ awɛnc əm aŋa dacɔ afum alompu-ɛ, məcəmbər ŋa ŋackɛks'em yɔcɔl.» ");
INSERT INTO bsp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kɔ Isifu ɛŋkɛrɛ papa kɔn Yakuba kədementər kɔ Firawona. Kɔ Yakuba ontolanɛ Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kɔ Firawona eyif Yakuba: «Meren cəke mɔ məyi doru-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kɔ Yakuba oloku kɔ: «Meren mmɛ isɔtɔ kəcepɛ-cepɛ disrɛ mɔ, mɛmbəp meren tasar tin kɔ wəco maas (130), kiyi kem doru kəncepər katəna katəna. Incepərɛnɛ meren meyeŋki kiyi kem doru. Intasɔtɔ fɛ meren mmɛ akombəra em ŋanasɔtɔ mɔ, mba tecepərɛnɛ doru tin tayi tɔ səncepərɛnɛ doru.» ");
INSERT INTO bsp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kɔ Yakuba ontolanɛ sɔ Firawona. K'ɛyɛfɛ, k'ɛsak kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kɔ Isifu ɛndəs papa kɔn kɔ awɛnc aŋa atɔf ŋa Misira. K'ɔsɔŋ ŋa antɔf Misira, nde atɔf ŋa Ramsɛs, pəmɔ tɔkɔ Firawona ɛnaloku kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kɔ Isifu ɛntam oŋ kəgbɛkərɛ papa kɔn, awɛnc aŋa, kɔ aka kəlɔ ka papa kɔn fəp pəmɔ tɔkɔ ŋanalanɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Yeri yɛnayi fɛ sɔ atɔf ŋa Misira fəp, bawo dor dɛnasɔtɔ fənɔntər. Atɔf ŋa Misira kɔ atɔf ŋa Kanaŋ dor dɛnclɛŋkəs oŋ kəlɛŋkəs dəm afum a tɔf yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kɔ Isifu ɛwɛtəs gbeti fəp mbɛ bɛnayi atɔf ŋa Misira kɔ atɔf ŋa Kanaŋ mɔ. Pəcsəkpərɛ gbeti babɔkɔ malɔ, kɔ Isifu ɛmbɛrsɛ gbeti babɔkɔ nde kəlɔ ka Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ntɛ gbeti ba Misira kɔ Kanaŋ belip mɔ, kɔ aMisira fəp ŋander nnɔ Isifu eyi mɔ. Kɔ ŋaloku: «Məsɔŋ su yeri! Cepɔ səndefi fɔr yam kiriŋ bawo gbeti beyi fɛ sɔ?» ");
INSERT INTO bsp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kɔ Isifu oloku: «Nəsɔŋ yɔcɔl yonu. Iŋsɔŋ nu kəcom kəsəkpɛ ka yɔcɔl yonu, bawo gbeti beyi fɛ sɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kɔ ŋaŋkɛrɛ Isifu yɔcɔl yaŋan. Kɔ Isifu ɔŋsɔŋ ŋa yeri kəsəkpɛ ka yɔcɔl yaŋan: Fəlɛs, yɔcɔl yɛfɛt kɔ yɔpɔŋ, sɔfale. Kɔ Isifu ɔsɔŋ ŋa yeri ya teren tatɔkɔ kəsəkpɛ ka yɔcɔl yaŋan fəp. ");
INSERT INTO bsp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ntɛ teren tatɔkɔ tencepər mɔ, kɔ aka Misira ŋander sɔ nnɔ Isifu eyi mɔ teren tɔckɔsɔk. Kɔ ŋaloku kɔ: «Səfɔtam kəmɛŋkər mariki mem a gbeti bosu belip, kɔ yɔcɔl yosu yelip. Daka o daka dɛncəmɛ fɛ su sɔ, mɛnɛ dis dosu kɔ ntɔf yosu. ");
INSERT INTO bsp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Səndefi oŋ fɔr yam kiriŋ ba, kɔ ntɔf yosu? Məway su kɔ ntɔf yosu kəsəkpɛ ka yeri. Tɛm tatɔkɔ səyɔnɛ acar a Firawona, səna kɔ ntɔf yosu. Məsɔŋ su defet səbəc ta sədefi, ntɔf yosu yedefəntərɛ gbəlməs.» ");
INSERT INTO bsp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kɔ Isifu ɛwayɛ Firawona ntɔf ya Misira fəp, aka Misira fəp ŋanacaməs ntɔf yaŋan, bawo dor dɛnabɛkər ŋa. Kɔ atɔf ŋɔyɔnɛ oŋ ŋa Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Kɔ Firawona ɛlɛk afum aŋɛ ŋanayi dəcələncər ca Misira mɔ, k'ɛŋkɛrɛ ŋa sədare səpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mba Isifu ɛnaway fɛ ntɔf ya aloŋnɛ, bawo Firawona ɛnamɔnɛ kəway ka ntɔf yaŋan. Aloŋnɛ ŋayi kəkɛkəs ka Firawona disrɛ, ti tɔ aloŋnɛ ŋanatɔcamsɛ ntɔf yaŋan. ");
INSERT INTO bsp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kɔ Isifu oloku afum a Misira: «Iway nu mɔkɔ kɔ ntɔf yonu, nəyɔnɛ mɔkɔ aka Firawona. Defet dɛndɛ: Nəntam kəbɔf dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kɔ nənde nəctɛl-ɛ, nəde nəcsɔŋ farilɛ poboc pin pa yɛtɛl yonu Firawona. Nəna nəlɛk yoboc maŋkəlɛ nyɛ, yendeyɔnɛ nu yeri ya dɛkɛr kɔ awut, yɔyɔnɛ nu sɔ defet da teren tɔcɔnc mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kɔ ŋaloku Firawona: «Məluksɛ su kəyi doru! Səsɔtɔ kəŋaŋnɛnɛ ka mariki mosu, səndeyɔnɛ acar a Firawona.» ");
INSERT INTO bsp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kɔ Isifu ɛncəmbər ti kɔ tɔyɔnɛ mɔkɔ tɔyɔ ta Misira: Poboc pa kəcamət fəp pa Firawona pɔ. Mɛnɛ ntɔf ya aloŋnɛ gbəcərəm yɔtɔyɔnɛ ya Firawona. ");
INSERT INTO bsp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kɔ Yakuba ɛndɛ atɔf ŋa Misira, atɔf ŋa Kosɛŋ. Kɔ pəyɔnɛ di ndaraŋan k'ɔyɔnɛ kas ka afum alarəm. ");
INSERT INTO bsp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kɔ Yakuba eyi doru meren wəco kɔ camət-mɛrəŋ (17) atɔf ŋa Misira. Kəwon ka Yakuba doru fəp kənasɔtɔ meren tasar tin wəco maŋkəlɛ kɔ camət mɛrəŋ (147). ");
INSERT INTO bsp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mataka ma Yakuba kəlɔtəs kəlip, k'ewe wan kɔn Isifu k'oloku kɔ: «Kɔ məfaŋ kəmar im-ɛ, məboc kəca kam aləŋk ŋem tantɔf, məlɛk'em layidi pəsoku disrɛ ndɛ məndetɔmpər'em mɔ: Ilɛtsɛn'am ta məwup im Misira! ");
INSERT INTO bsp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","K'indefəntərɛ kɔ papa kem aŋa-ɛ, məwurɛn'em Misira. Məkɔ məwup im nde kufu kəŋan kəyi mɔ.» Kɔ Isifu oloku kɔ: «Indeyɔ tɔkɔ məlok'im mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kɔ Yakuba oloku: «Mədɛrəm'em ti.» Kɔ Isifu ɛndɛrmɛ kɔ ti. Kɔ Yakuba ontontnɛ nde kəfənc kɔn dəromp. ");
INSERT INTO bsp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ntɛ mes mamɔkɔ mencepər mɔ, k'aŋkɔ paloku Isifu a Papa kɔn ɛntamnɛ fɛ. Kɔ Isifu ɛlɛkɛnɛ awut ɔn mɛrəŋ Manase kɔ Ɛfrayim. ");
INSERT INTO bsp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","K'asɔŋɛ ti Yakuba kəcərɛ, k'aloku kɔ: «Wan kam Isifu eyi kəder nnɔ məyi mɔ.» Kɔ Yakuba oloŋka fənɔntər fɔn k'ɛyɛfɛ, k'ɛndɛ kəfənc kɔn kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Kɔ Yakuba oloku Isifu: «MARIKI nwɛ ɛntam mes fəp ma doru mɔ ɛnawurər im dare da Lus nde atɔf ŋa Kanaŋ k'ɔsɔŋ im temer kədepoc'em pətɔt. ");
INSERT INTO bsp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","K'olok'im: ‹Indesɔŋ əm dokombəra, indesɔŋ'am kəla, indesɔŋ'am kəyɔnɛ wətem ka afum alarəm. Indesɔŋ atɔf ŋaŋɛ yuruya yam kɔ məncepər-ɛ, atɔf ŋaŋɛ ŋendeyɔnɛ ŋaŋan doru o doru.›» ");
INSERT INTO bsp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Ndɛkəl oŋ, awut mɛrəŋ aŋɛ məŋkom atɔf ŋa Misira a k'indeder nnɔ məyi mɔ, ŋandeyɔnɛ akemi. Ɛfrayim kɔ Manase ŋayɔnɛ akemi, pəmɔ tɔkɔ iyɔ Ruben kɔ Simeyɔŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mba awut aŋɛ məndekom oŋ aŋɛ mɛrəŋ tadarəŋ mɔ, akam ŋandeyi akakɔ, awɛnc aŋa ŋɔ ŋandesɔtər kɛ. ");
INSERT INTO bsp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kəder kem Padaŋ, kɔ Rasɛl efir im dɔpɔ da Kanaŋ, ta pəmbɔlɛ su kəbɛrɛ Efrata-ɛ. Difɔ inawup kɔ katina dəndo dɔpɔ da Efrata, nde pəyɔnɛ Betlɛhɛm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kɔ Yakuba ɔmɔmən awut a Isifu k'eyif: «Are ŋɔ akaŋɛ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kɔ Isifu oloku papa kɔn: «Awut em ŋɔ, aŋɛ Kanu kəsɔŋ im nnɔ mɔ.» Kɔ Yakuba oloku: «Ilɛtsɛn'am məyɔ ŋa ŋacɔŋnɛ nnɔ itolanɛ ŋa.» ");
INSERT INTO bsp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Detem dɛnalɔləs Yakuba fɔr. Ɛnctam fɛ sɔ kənəŋk. Kɔ Isifu ɔncɔŋ awut ɔn nde Yakuba eyi mɔ, kɔ Yakuba oncup ŋa, k'ɛmakərnɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Kɔ Yakuba oloku Isifu: «Inacɛm-cɛmənɛ fɛ sɔ kədenəŋk əm. Mba Kanu kəsɔŋ'em k'inəŋk əm haŋ awut am!» ");
INSERT INTO bsp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kɔ Isifu eliŋ awut kas dələŋk, k'ɛncəp kəro dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Kɔ Isifu osumpər mɛrəŋ maŋan fəp waca, pəsumpərɛ Ɛfrayim kəca kətɔt mba pəyi kəca kəmeriya ka Yakuba, k'osumpərɛ Manase kəca kəmeriya mba pəyi Yakuba kəca kətɔt, k'ɔncɔŋɛnɛ ŋa sɔ nde wətem kəŋan eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kɔ Yakuba ɛntɛnc kəca kɔn kətɔt, k'endeŋ ki Ɛfrayim dəromp nwɛ ɛnafɛtɛ mɔ, k'endeŋər Manase kəca kɔn kəmeriya dəromp. Ɛnacərɛ belbel tɔkɔ ɔncyɔ waca wɔn mɔ, ali ntɛ Manase ɛnayɔnɛ wan wəcɔkɔ-cɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Motolanɛ mmɛ mɔ Yakuba ɛnatolanɛ Isifu: «Kanu nkɛ kənəŋk papa kem aŋa Abraham kɔ Siyaka tecepərɛnɛ taŋan mɔ, Kanu nkɛ kəŋkɛks'im kəyɛfɛ ntɛ iyi doru haŋ mɔkɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mɛlɛkɛ mmɛ mɛncyac im pəlɛc mɔ, mɔsɔŋɛ awut aŋɛ! Pawe ŋa tewe tem kɔ mewe ma papa kem aŋa, Abraham kɔ Siyaka. Kanu kəsɔŋɛ ŋa kəkom pəlarəm nde atɔf ŋaŋɔkɔ dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ntɛ Isifu ɛnəŋk kas pəcdeŋər Ɛfrayim kəca kɔn kətɔt mɔ, kɔ tɔntɔbɔt kɔ. Kɔ Isifu osumpər kəca ka kas, k'ɔncɔŋ ntende domp da Manase ta pədeŋər ki Ɛfrayim. ");
INSERT INTO bsp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kɔ Isifu oloku papa kɔn: «Ta məyɔ tantɛ, fɔtɔ Manase ɛbɛk. Nkɔn pəmar mədeŋər kəca kam kətɔt.» ");
INSERT INTO bsp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kɔ papa kɔn ɛfati, k'oloku: «Incərɛ ti, wan kem. Incərɛ ti! Nkɔn sɔ endeyɔnɛ wətem ka afum alarəm, endebɛk. Mba wɛnc Tɔŋɔ endebɛk kɔ, yuruya yɔn yendelas tɔf fəp.» ");
INSERT INTO bsp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kɔ Yakuba ontolanɛ ŋa dɔsɔk dadɔkɔ, k'oloku: «Mən'endesɔŋɛ Yakuba pəctolanɛ a pəckulɛ a: ‹Kanu kəsɔŋ'am kəyi pəmɔ Ɛfrayim, pəmɔ Manase!›» Tatɔkɔ tɔ Yakuba ɛnacəmbər Efrayim Manase kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kɔ Yakuba oloku Isifu: «Kəfi k'inder! Mba Kanu kəndesolɛ nu. Kəndeluksɛ nu atɔf ŋa atem anu. ");
INSERT INTO bsp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Imbɛrɛn'am pɔkɔ awɛnc əm aŋa ŋantɔdesɔtɔ mɔ, ip'ɔyɔnɛ mpɛ inabaŋərɛ aka Amɔr dakma dem kɔ ambəncəran ŋem mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kɔ Yakuba ewe awut ɔn, k'oloku: «Nəloŋkanɛ iloku nu tɔkɔ tendeder nu kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nəloŋkanɛ, nəcəŋkəl im awut a Yakuba! Nəcəŋkəl Yisrayel papa konu! ");
INSERT INTO bsp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, məna coco cem, məna nwɛ inakom tɛm ntɛ inayɔ fənɔntər mɔ: Məncepər awɛnc əm aŋa tokom, kɔ fənɔntər. ");
INSERT INTO bsp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Məyeŋk pəmɔ domun ndɛ dɛŋyɛksɛ dəkəŋgbɔkɔ mɔ, mba məfɔdesɔyɔnɛ wəkiriŋ, Bawo mənapɛsɛ dəkəfəntərɛ da papa kam, Mənayik-yikəs kəfənc kem kəpɛsɛ ka ki, kɔ wəran kem wəkin. ");
INSERT INTO bsp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyɔŋ kɔ Lewy dɛwɛnca dɔ ŋayɔ: Ŋa ŋantəŋnɛ, ŋasek kəkɔyɔ pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ala, ifaŋ fɛ kənɔŋkəl tɛŋkəndəm taŋan! Ta mɛcɛm-cɛmnɛ mem mɛtəŋnɛ nde ŋantəŋnɛ kəbəpɛnɛ mɔ! Bawo mɛtɛlɛ maŋan disrɛ, ŋandif fum. Kəwosɛ kəŋan disrɛ, kɔ ŋancopu-copu mura bənta. ");
INSERT INTO bsp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Intolanɛ mɛtɛlɛ maŋan pəlɛc, bawo mɛmbɛk pɛləsər. Intolanɛ pəlɛc deyeŋki bəkəc daŋan, bawo dɔfɔyɔnɛ nɔnɔfɔr. Indeyerəs ŋa atɔf ŋa Yakuba, Indesamsər ŋa atɔf ŋa Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, məna, awɛnc əm aŋa ŋandeyek-yekəs əm. Məndesumpər aterɛnɛ am cərɔbɔ. Kɔ awɛnc əm aŋa ŋandecəp am səbomp fɔr yam kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, kusunuŋku kəwut kɔ məyɔnɛ. Dəkəwatəri-watəri wɛsɛm wam məyɛfɛ, wan kem! Nkɔn oŋnut wɛcək, pəfəntərɛ pəmɔ kusunuŋku. Pəmɔ kusunuŋku kəran: An'ɛntam ki kəyekti ta kəfaŋ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kəgbo ka dɛbɛ kəfɔde kəcbɔlɛ Yuda, kəgbo ka dɛbɛ kəndeyi yuruya yɔn dəwaca, haŋ tɛm ntɛ wəka kəgbo kaŋkɔ yati endeder mɔ, wəkɔ afum fəp ŋandeyi dəntɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nkɔn (Yuda) ende pəckot sɔfale sɔn dəŋgbɔŋkəlɔ ya wɛn, pəkot wan ka si nde kətɔk ka wɛn, Ende pəcyak yamos yɔn dəwɛn, kɔ burumus bɔn, dəməncɔncɔ ma yokom ya wɛn. ");
INSERT INTO bsp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Member mendesɔŋɛ kɔ fɔr kəyimbərɛ, Mɛsɛ ma wana mendefertər əm sek. ");
INSERT INTO bsp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Kɔ məna Sabulon, kəba kəsək məndendɛ, nde cibil cəndeyɔ kətənta mɔ. Cələncər ca atɔf ŋaŋɔkɔ cəndewɔkəl haŋ Sidoŋ. ");
INSERT INTO bsp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar, məna sɔfale səpɔŋ sɔ məyɔnɛ, nsɛ səŋfəntərɛ gbɔrɛ mɛrəŋ dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Pənəŋk a kəfo kaŋkɔ eyi kəŋesəm mɔ kəntesɛ, k'atɔf ŋɔmbɔt. Pətirmi kumunt padəndəsər kɔ pɛsarɛ, Yɛbəc ya dacar y'endeyi. ");
INSERT INTO bsp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, endeyɔnɛ afum ɔn wəbɛ. Pəmɔ kusuŋka kəlɔma cusuŋka cəlpəs ca Yisrayel cəkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan, endeyi pəmɔ abok nŋɛ ŋeyi dɔpɔ mɔ, aŋkisin nŋɛ ŋeyi dɔpɔ kəsək mɔ. Abok nŋɛ ŋɛŋaŋ bənta ya afəlɛs, a tɔsɔŋɛ wəyɛksɛnɛ ka ŋi kətɛmpɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Iŋgbɛkər əm amera MARIKI, a məndeyac im! ");
INSERT INTO bsp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kadu, kənay kəndepaŋnɛ kɔ pəyɛfɛ pəcəmɛ ŋa darəŋ kəbɛləs. ");
INSERT INTO bsp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ndena Asɛr, yeri yoboŋu yendela di. Antɔf ŋam ŋende ŋɔcsɔŋ yeri nyɛ pəmar yɔyɔnɛ yeri y'abɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, were w'ɔyɔnɛ nwɛ weyi kiyi ka wi, ta tes o tes toŋkotərnɛ wi mɔ. Ende pəckoməs awut atɔt. ");
INSERT INTO bsp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Isifu, popoŋ pa kətɔk kəkom pɔyɔnɛ, Popoŋ pa kətɔk kəkom nkɛ kəcəmɛ kəŋgbɔkɔ kəsək mɔ, wara wa ki wetilsərnɛ damba. ");
INSERT INTO bsp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ŋandəktər kɔ, kɔ ŋampɛn. Apɛnɛ mbəncəran ŋanayɔnɛ ayɛfərɛnɛ am. ");
INSERT INTO bsp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mba ambəncəran ŋɔn ŋende ŋɛtəŋnɛnɛ kɔ nkɔn sərka. Anacaŋəs waca wɔn kətam ka Kanu kɔ fənɔntər fa Yakuba dəntɔf. Ɔyɔnɛ wəkɛkəs kɔ togbu pa aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tewe ta Kanu ka papa kam, nkɛ kəyɔnɛ wəmar kam mɔ, tewe ta Kanu nkɛ kəntam mes fəp ma doru mɔ, nkɛ kəndepoc'am mɔ: Kəpocɛ pətɔt nkɛ kəndeyɛfɛ darenc mɔ, kəpocɛ pətɔt nkɛ kəŋyɛfɛ dəntɔf mɔ, kəpocɛ pətɔt ka awut alarəm kɔ yɔcɔl yɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kətolanɛ nkɛ papa kam ontolan'am mɔ, kəncepər kətolanɛ pətɔt ka aŋɛ ŋaŋkom im mɔ, haŋ dəkələpsər da mɔrɔ ma doru o doru. Kətolanɛ pətɔt kaŋkɔ kəyi Isifu dəromp, dəndo domp dacɔ da Isifu nwɛ ɔyɔnɛ wəbɛ ka awɛnc aŋa mɔ! ");
INSERT INTO bsp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beŋyamin, kalma k'ɔyɔnɛ nkɛ kəŋwatəri-watəri mɔ. Bətbət kəwatəri-watəri wɛsəm wa ki, dɔfɔy, pəyerəs yɔsɔtɔ ya ki.» ");
INSERT INTO bsp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Awut akaŋɛ ŋayɔnɛ cusuŋka wəco kɔ mɛrəŋ ca Yisrayel. Moloku mamɛ mɔ kas kəŋan ɛnaloku ŋa, ntɛ onctolanɛ ŋa mɔ. Yakuba ɛnatolanɛ ŋa nwɛ o nwɛ kɔ kətolanɛ kɔn taciŋa. ");
INSERT INTO bsp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ntɛ Yakuba elip kətolanɛ awut ɔn mɔ, k'osom ŋa: «Intas kəbəp atem em aŋɛ ŋafi mɔ. Nəwup im kɔ papa kem aŋa, nde kufu kəŋkɔ kəyi nde dalɛ da Hɛfəroŋ wəHewy mɔ, ");
INSERT INTO bsp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nde kufu nkɛ kəyi dalɛ da Makpela, Mamre kəsək, nde atɔf ŋa Kanaŋ. Dalɛ dadɔkɔ dɔ Abraham ɛnaway nnɔ Hɛfəroŋ eyi mɔ, pəyɔnɛ di dəkəwupɛnɛ da afum ɔn. ");
INSERT INTO bsp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Difɔ anawup Abraham kɔ wəran kɔn Sara, difɔ anawup Siyaka kɔ wəran kɔn Rebeka, difɔ inawup sɔ Leya wəran kem. ");
INSERT INTO bsp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Dalɛ kɔ kufu nkɛ kəyi di mɔ, Abraham ɛnaway di aHewy dəwaca.» ");
INSERT INTO bsp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ntɛ Yakuba elip kəsom awut ɔn mɔ, k'ɛfəntərɛ dəkəfənc. K'eŋgbiŋ kifir k'ɔnɔŋkəlɛnɛ atem ɔn aŋɛ ŋanafi mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kɔ Isifu ɛntɛmpɛnɛ papa kɔn kəroŋ, k'ombok kɔ kəroŋ, k'oncup kɔ. ");
INSERT INTO bsp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kɔ Isifu osom acar ɔn akɔ ŋanayɔnɛ atɛn cɔl mɔ, a ŋasop kas acɔl nŋɛ ŋɔsɔŋɛ ta wəfi ente katəna mɔ. Kɔ atɛn cɔl ŋasop Yakuba acɔl ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kɔ tɔŋkɔ mata wəco maŋkəlɛ (40). Tɛm tatɔkɔ mataka mamɔkɔ m'ancsop afi acɔl ŋa kətɔte ŋaŋɔkɔ, kɔ aMisira ŋambok kɔ mata wəco camət mɛrəŋ (70). ");
INSERT INTO bsp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ntɛ mataka ma kəbal kɔn mencepər mɔ, kɔ Isifu oloku afum akɔ ŋanayi nde saŋka sa Firawona mɔ, k'oloku ŋa: «K'intam kəsɔtər nu layidi-ɛ, nəloku ntɛ Firawona ilɛtsɛnɛ nu: ");
INSERT INTO bsp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Papa kem ɛnasɔŋ'em kədɛrəm, pəcloku: ‹Kəfi k'inder! Məkɔ məwup im nde kufu kəŋkɔ iŋkay nde atɔf ŋa Kanaŋ mɔ.› Difɔ ifaŋ kəpɛ ikɔwup papa kem. K'ilip-ɛ, inder.» ");
INSERT INTO bsp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kɔ Firawona oloku kɔ: «Məpɛ məkɔ məwup papa kam pəmɔ tɔkɔ ɔsɔŋ'am kədɛrəm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kɔ Isifu ɛmpɛ kəkɔwup papa kɔn. Kɔ ŋampɛ kɔ abeki aka saŋka sa Firawona fəp kəbəp abeki a atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Kɔ afum a Isifu fəp, kəlɛk awɛnc aŋa kəbəp ka afum a papa kɔn, mɛnɛ awut afɛt, yɔcɔl yaŋan yɔpɔŋ kɔ yɛfɛt ŋ'anasak atɔf ŋa Kosɛŋ. ");
INSERT INTO bsp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Isifu kɔ cibil ca dəntɔf k'ayɛksɛnɛ fəlɛs ŋampɛ kɔ nkɔn, kɔ tɔsɔŋɛ akɔ a Kanaŋ kəla. ");
INSERT INTO bsp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ŋandebəp pəferere pa Atad, nŋɛ ŋeyi Yurdɛn takəroŋ mɔ, kɔ ŋawup Yakuba dəndo kəyek-yekəs disrɛ. Kɔ Isifu ombok kas mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kɔ andɛ a atɔf ŋaŋɔkɔ, aka Kanaŋ, ŋayi kəbal ka Yakuba dəndo pəferere pa Atad. Kɔ ŋaloku: «Defi dɔpɔŋ dɔ dandɛ aMisira dacɔ!» Ti t'asɔŋɛ tofo tatɔkɔ tewe ta «Abɛl Misira» nde Yurdɛn takəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kɔ awut a Yakuba ŋayɔ tɔkɔ papa kəŋan ɛnaloku ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kɔ awut ɔn ŋaŋkekərɛ kɔ atɔf ŋa Kanaŋ. Kɔ ŋawup kɔ nde kufu ka dalɛ da Makpela, dalɛ ndɛ Abraham ɛnaway Hɛfəroŋ wəHiti dəwaca mɔ, pəyɔ di dəkəwupɛnɛ da afum ɔn, nde Mamre kəsək. ");
INSERT INTO bsp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ntɛ Isifu elip kəwup papa kɔn mɔ, k'oluksərnɛ Misira kɔ awɛnc aŋa kɔ akɔ ŋanacəmbər kɔ, kəkɔwup papa kɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ntɛ awɛnc a Isifu ŋanəŋk a papa kəŋan efi mɔ, kɔ ŋaloku: «Kɔ Isifu ɛŋkafəlɛ pəyɔnɛ wəterɛnɛ kosu, kəluksɛ ka ayɛk ŋa pəlɛc mpɛ sənayɔ kɔ mɔ!» ");
INSERT INTO bsp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kɔ ŋasom a paloku Isifu: «Papa kam ɛnasom ntɛ a pəcfi: ");
INSERT INTO bsp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Ntɛ tɔ nəŋkɔloku Isifu: O! Ilɛtsɛn'am məŋaŋnɛnɛ awɛnc əm aŋa pəlɛc kɔ kiciya kəŋan, bawo ŋanayɔ əm pəlɛc! Ilɛtsɛn'am məŋaŋnɛ oŋ kiciya ka acar a Kanu ka papa kam!›» Kɔ Isifu ombok ntɛ analoku kɔ moloku mamɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kɔ awɛnc aŋa ŋander ŋa sərka ŋatɛmpɛnɛ Isifu dəntɔf kɔ ŋaloku: «Sən'ɔfɔ akaŋɛ acar am.» ");
INSERT INTO bsp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kɔ Isifu oloku ŋa: «Ta nənesɛ. Cepɔ Kanu k'iyɔnɛ? ");
INSERT INTO bsp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nənasek'em kəyɔ ka pəlɛc. Mba Kanu kənakafəli ti pətɔt, kəlompsɛ ka ntɛ teyi mɔkɔ mɔ, kɔ kəyac ka defi da afum alarəm. ");
INSERT INTO bsp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ndɛkəl oŋ, ta nənesɛ! Indetamɛ nu mɛfaŋ monu fəp kɔ ma awut anu.» Kɔ Isifu ontorɛ-torɛ ŋa bəkəc, k'olok-lokərɛ ŋa dim d'antɔf. ");
INSERT INTO bsp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Kɔ Isifu ɛndɛ Misira nkɔn kɔ afum ɔn. K'eyi doru meren tasar tin kɔ wəco (110). ");
INSERT INTO bsp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Kɔ Isifu ɛnəŋk awut a Ɛfrayim haŋ dɛtɛmp maas. Kɔ Makir, wan ka Manase, oŋkom awut ɔn ləŋk ya Isifu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kɔ Isifu oloku awɛnc aŋa: «Kəfi k'inder. Mba Kanu kəndemar nu ilaŋ ti. Kanu kəndepɛnɛ nu nde atɔf ŋɔkɔ kənalɛkɛ Abraham, Siyaka kɔ Yakuba layidi kəsɔŋ ŋa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kɔ Isifu ɔsɔŋɛ awut a Yakuba kədɛrəm, pəcloku: «Kanu kəndemar nu ilaŋ ti. Nəde nəpɛnɛ bɛnt yem, nəbɔlɛnɛ yi nnɔ.» ");
INSERT INTO bsp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kɔ Isifu efi pəsɔtɔ meren tasar tin kɔ wəco (110). K'asop kɔ acɔl nŋɛ ŋɔŋsɔŋɛ wəfi kətɔte katəna mɔ. Kɔ ŋambɛr kɔ kaŋkəra ka tasar pɛpat dəndo atɔf ŋa Misira.");
INSERT INTO bsp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Mewe ma awut a Yakuba mɔ mmɛ, aŋɛ ŋanader Misira kɔ nkɔn Yakuba mɔ. Fəp faŋan ŋanakɛrɛnɛ aka wɔlɔ waŋan disrɛ fəp: ");
INSERT INTO bsp_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeyɔŋ, Lewy, kɔ Yuda, ");
INSERT INTO bsp_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sabulon, kɔ Beŋyamin, ");
INSERT INTO bsp_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Kadu kɔ Asɛr. ");
INSERT INTO bsp_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yuruya ya Yakuba fəp ŋanayi afum wəco camət-mɛrəŋ (70). Tɛnatəŋnɛ Isifu nkɔn pəyi tɛm tatɔkɔ Misira. ");
INSERT INTO bsp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kɔ Isifu ende pəfi kɔ awɛnc aŋa, kɔ danapa dadɔkɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kɔ aka Yisrayel ŋande ŋasɔtɔ dokombəra, kɔ ŋala, kɔ kənay kəŋan kəsɔtɔ sɔkət kəcepərər. K'atɔf ŋa Misira ŋɛlarɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ntɛ tɛm tɔlɔma tencepər mɔ, kɔ fum wəlɔma nwɛ ɛnatɔcərɛ Isifu mɔ, ende pəyɔnɛ wəbɛ Misira. ");
INSERT INTO bsp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kɔ wəbɛ nwɛ ende pəloku afum ɔn: «Nənəŋk, afum aka Yisrayel ŋala, kɔ ŋayɔ sɔkət ŋatas su. ");
INSERT INTO bsp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mɛnɛ patɛn kəcərɛ kəkɔt, ntɛ andeyamsər ŋa dokombəra daŋan mɔ. Kɔ pəyɔnɛ fɛ ti-ɛ, kɔ kəwan kəyɛfɛ-ɛ, ŋantam kəmar aterɛnɛ asu kəsutɛnɛ, kɔ telip-ɛ, ŋamulpər su ŋawur atɔf ŋaŋɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Awa, kɔ aka Misira ŋancəmbər akiriŋ aŋɛ ŋanakɔsɔŋəs aka Yisrayel yɛbəc ya dacar mɔ. Ti disrɛ, kɔ aka Yisrayel ŋancəmbər sədare sa Pitɔm kɔ Ramsɛs, pəyɔnɛ di dəkəmɛŋk da firawona. ");
INSERT INTO bsp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mba pɔkɔt pa firawona pɛnakɔt fɛ few, bawo tatɔkɔ anctɔrəs aka Yisrayel mɔ, ti tɔ ŋanckom, ŋacla, ŋacwɔkələs dəkəndɛ daŋan, kɔ tɔsɔŋɛ pater aka Yisrayel pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Kɔ aka Misira ŋancəmbər aka Yisrayel yɛbəc ya dacar yeyeŋki. ");
INSERT INTO bsp_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","K'aka Misira ŋandoktəsɛ aka Yisrayel doru yɛbəc yeyeŋki: Yɛbəc ya dos, ya birik, ya dalɛ fəp. Yɛbəc ya dacar yayɔkɔ yɔ ŋanacəmbər aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kɔ wəbɛ wəka Misira ende pəloku aran abaŋ awut aHebəre, pacwe wəkin «Sifra,» kɔ wəka mɛrəŋ «Puwa.» ");
INSERT INTO bsp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Kɔ wəbɛ wəka Misira oloku ŋa: «Kɔ nənde kəcbaŋ aran aHebəre awut-ɛ, nəcmɔmən ŋa kiriŋ. Nwɛ ɔŋyɔnɛ wərkun mɔ, nədif kɔ, nwɛ ɔŋyɔnɛ wəran mɔ, nəsak wəkakɔ pəyi doru.» ");
INSERT INTO bsp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mba kɔ aran abaŋ awut aŋɛ ŋanesɛ Kanu, ŋayɔ fɛ ntɛ wəbɛ ka Misira ɛnaloku ŋa mɔ, kɔ ŋance awut arkun kɔ ŋayi doru. ");
INSERT INTO bsp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kɔ wəbɛ wəka Misira ewe aran abaŋ awut aŋɛ, k'eyif ŋa: «Ta ake tɔ nəyɔnɛ tantɛ-ɛ? Ta ake tɔ nəncenɛ awut aŋan arkun ŋacyinɛ doru-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Kɔ abaŋ awut aŋɛ ŋaloku firawona: «Ntɛ tɔsɔŋɛ ti mɔ, aran aHebəre ŋayi fɛ pəmɔ aran aka Misira. Aran aHebəre ŋayeŋk mɛnc dəŋkom, ŋaŋlip kəkom a səna abaŋ awut səcbəp di.» ");
INSERT INTO bsp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kɔ Kanu kəyɔnɛ abaŋ awut aŋɛ pətɔt, k'aka Yisrayel ŋala, kɔ ŋasɔtɔ sɔ sɔkət kɔ ŋancepərər. ");
INSERT INTO bsp_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Abaŋ awut aŋɛ ŋananesɛ Kanu, itɔ Kanu kənasɔŋɛ ŋa dokombəra. ");
INSERT INTO bsp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kɔ firawona ende pəsom afum ɔn fəp: «Nəsumpər awut arkun aHebəre fəp, aŋɛ ande packom mɔ, nəcgbal ŋa nde kəŋgbɔkɔ ka Nil, mba nəcsak gbəcərəm awut aran ŋayi doru.» ");
INSERT INTO bsp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kɔ wərkun wəlɔma wəka kusuŋka ka Lewy ɛnɛncɛ wəran wəlɔma nwɛ ŋanapaŋnɛ kusuŋka kin kɔ nkɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kɔ wəran nwɛ ɛmbɛkəs, k'oŋkom wan wərkun. Kɔ wəran nwɛ ɛnəŋk dɔtɔt da wan, k'ɔŋgbɔpnɛnɛ wan kɔn yof maas. ");
INSERT INTO bsp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ntɛ ɛnəŋk a ɔfɔsɔtam kəgbɔpnɛnɛ wan mɔ, kɔ wəran nwɛ ɛlɛk kəfala nkɛ andunɛ cəŋkɔlma mɔ, k'osop ki paka mpɛ powurɛnɛ kɔrtal kɔ bən ya cəme mɔ, ntɛ tɔŋsɔŋɛ ki kəfɔy mɔ. K'ɛmbɛr wan kəfala nkɛ disrɛ, k'ɔŋkɔ pəcəmbər ki dəcəŋkɔlma nde aparpara ŋa kəŋgbɔkɔ ka Nil. ");
INSERT INTO bsp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kɔ wəkirɛ ka wan nwɛ aŋgbal mɔ, ɛncəmɛ pəwak kəbɔlɛnɛ kaŋkəra nkɛ, ntɛ tɔŋsɔŋɛ pəctam kəcərɛ tɔkɔ tendeder wan mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kɔ wan wəran wəka firawona ende pətor nde kəŋgbɔkɔ kəkɔbikɛ-bikɛ, amarəs ɔn aran ŋayi kəkɔtəs agbɛp ŋa kəŋgbɔkɔ ka Nil. Kɔ wan ka firawona wəran nwɛ ɛnəŋk kəfala cəŋkɔlma dacɔ, k'osom wəmarəs kɔn wəran kəkɔlɛk ki. ");
INSERT INTO bsp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Wan ka firawona wəran endegbipi kəfala nkɛ, k'ɛnəŋk wan: Wan wərkun ɛnayi, pəcbok. Kɔ tɔyɔnɛ kɔ nɔnɔfɔr, k'oloku: «Wan wəHebəre wəlɔma ɔfɔ wəkawɛ!» ");
INSERT INTO bsp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kɔ wəkirɛ ka wan nwɛ oloku wan ka firawona wəran: «Məfaŋ a ikɔ iwen'am wəkombəra wəHebəre wəlɔma, pədemsər'am wan wəkawɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kɔ wan ka firawona wəran oluksɛ wəyecəra ntɛ: «Məkɔ!» Kɔ wəyecəra nwɛ ɔŋkɔ pəwe iya wəka wan wəkakɔ anafir mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kɔ wan ka firawona wəran oloku wəran nwɛ: «Məkenɛnɛ wan wəkawɛ məkɔ məcmɛsər'em kɔ belbel. Indesɔŋ əm kəway.» Kɔ wəran nwɛ ɛlɛk wan, k'ɛmɛsər kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ntɛ awurɛ wan mɛsɛ mɔ, kɔ wəran nwɛ ɛlɛk kɔ, k'eŋkenɛ wan ka firawona wəran, pəyɔnɛ kɔ wan. K'ɔsɔŋ kɔ tewe ta Musa bawo ti tɔ tatɔkɔ «dəromun incafi kɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ntɛ Musa ɛmbɛk k'ɔyɔnɛ wətɛmp mɔ, dɔsɔk dɔlɔma k'ende pəkɔ kəkɔmɔmən awɛnc aŋa, k'ɔŋkɔ pənəŋk yɛbəc yaŋan yeyeŋki nyɛ anacəmbər ŋa mɔ. Ntɛ ɔncɔŋnɛ kiriŋ mɔ, k'ɔŋkɔ pənəŋk wəka Misira pəcsut wɛnc wəHebəre wəkin. ");
INSERT INTO bsp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kɔ Musa ɔmɔmən-mɔmən, ntɛ ɔntɔnəŋk fum mɔ, k'osut wəka Misira nwɛ k'endif, k'ɛlɛk kɔ k'ɛmət dɛsənc. ");
INSERT INTO bsp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Dɔckɔsɔk kɔ Musa owur sɔ, k'ɔŋkɔ pənəŋk aHebəre mɛrəŋ ŋacsutɛnɛ. K'eyif wəkɔ ɛnadəkət mɔ: «Ta ake tɔ məŋsutɛ wəkos əm-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Kɔ fum nwɛ oloku kɔ: «An'ɛcəmbər əm dɛbɛ kɔ wəboc kiti su kəroŋ-ɛ? Kədif im kɔ mənder pəmɔ tɔkɔ məndifsa wəka Misira mɔ ba?» Kɔ Musa enesɛ, k'olokunɛ dɛbəkəc: «Tɔlɔma ancərɛ tes tantɛ iyɔsa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kɔ firawona ene tɔkɔ tɛnacepər mɔ, k'ɛntɛn oŋ kədif Musa. Mba kɔ Musa ɛyɛksɛ k'ɔmbɔlɛ firawona, k'ɔŋkɔ atɔf ŋa Madiyaŋ. Ntɛ ɛmbɛrɛ Madiyaŋ mɔ k'ɔŋkɔ pəndɛ kələmp kəsək. ");
INSERT INTO bsp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Awa, wəloŋnɛnɛ ka aka Madiyaŋ ɛnayɔ awut aran camət-mɛrəŋ. Kɔ awut aran aŋɛ ŋander kədekɛt domun, kɔ ŋalasəs dəkəmun da yɔcɔl ya kas kəŋan. ");
INSERT INTO bsp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kɔ akɛk alɔma ŋander ŋabɛləs ŋa. Kɔ Musa ɛyɛfɛ k'ɔŋkɔ pəbaŋ ŋa, k'ɔsɔŋ yɔcɔl yaŋan domun kɔ yomun. ");
INSERT INTO bsp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ntɛ ŋalukus nda kas kəŋan Rehuwɛl mɔ, kɔ kas kəŋan eyif ŋa: «Ta ake tɔ nənuŋkɛnɛnɛ mɔkɔ kəbɛrɛ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","K'ayecəra aŋɛ ŋaloku kas kəŋan: «Wəka Misira wəlɔma ɛyac su nnɔ akɛk ŋayi mɔ. Ɛŋkɛtɛna su domun yati, k'ɔsɔŋ yɔcɔl yosu.» ");
INSERT INTO bsp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kɔ Rehuwɛl eyif ayecəra: «Deke eyi-ɛ? Ta ake tɔ nəsakɛ fum wəkakɔ-ɛ? Nəwe kɔ pəder pədi yeri.» ");
INSERT INTO bsp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Kɔ Musa ende pəwosɛ kəyi ka ndena Rehuwɛl, nwɛ ɛnasɔŋ wan kɔn wəran Sefora kənɛncɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kɔ wəran kakɔ ende pəkom wan, k'awe kɔ Kɛrsɔm, «Wəcikəra,» bawo k'oloku ti tɔ tatɔkɔ: «Wəcikəra iyɔnɛ kərɛsna atɔf ŋocuru.» ");
INSERT INTO bsp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ntɛ pəwon mɔ, kɔ wəbɛ wəka Misira ende pəfi, aka Yisrayel ŋacgbis, ŋackulɛ-kulɛnɛ teta dacar deyeŋki dɔkɔ ŋanayi mɔ. Kɔ kəmar nkɛ ŋancbok mɔ, kəmpɛ haŋ nde nkɔn Kanu eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Kɔ Kanu kəne kigbis kəŋan. Kɔ Kanu kəncɛm-cɛmnɛ danapa ndɛ ŋanacaŋəs kɔ Abraham, Siyaka kɔ Yakuba mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Kɔ Kanu kəmɔmən aka Yisrayel, kɔ kəlɛk te taŋan waca disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Kɔ Musa ende pəyiɔnɛ wəkɛk yɔcɔl ya Yetero, papa ka wəran kɔn, nwɛ ɛnayɔnɛ wəloŋnɛ wəka Madiyaŋ mɔ. Dɔsɔk dɔlɔma, k'ende pəkekərɛ yɔcɔl k'encepər dətɛgbərɛ, k'ɛmbəp Horɛb tɔrɔ ta Kanu. ");
INSERT INTO bsp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kɔ mɛlɛkɛ ma MARIKI mowurər kɔ dənɛnc dɛmar disrɛ, nde dɛrəntəm. Kɔ Musa ɔmɔmən, k'ɛnəŋk arəntəm fəp ŋɛcmar, mba ŋɛnctɛyɛ fɛ. ");
INSERT INTO bsp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kɔ Musa ɛncɛm-cɛmnɛ: «Iluksərnɛ ma, imɔmən tes ntɛ intatɔnəŋk mɔ, ta ake tɔ arəntəm ŋɔntɔtɛyɛnɛ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kɔ MARIKI ɛnəŋk a kəluksərnɛ kɔ Musa ɛndɛ kəkɔgbɛkərɛ tes ntɛ. Kɔ Kanu kəwe kɔ dəndo dɛrəntəm, k'oloku kɔ: «Musa! Musa!» K'owosɛnɛ kɔ: «In'ɛwɛ!» ");
INSERT INTO bsp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kɔ Kanu kəloku kɔ: «Ta məcɔŋnɛ nnɔ, məwurɛ cɔfta dəwɛcək, bawo kəfo kaŋkɔ məncəmɛ mɔ, antɔf ŋosoku ŋɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Kɔ kəndeŋər: «In'ɔyɔnɛ Kanu ka papa kam, Kanu ka Abraham, Kanu ka Siyaka, Kanu ka Yakuba.» Kɔ Musa oŋkumpnɛ kəro, bawo ɛnanesɛ kəmɔmən Kanu. ");
INSERT INTO bsp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kɔ MARIKI oloku: «Inəŋk belbel ntɛ antɔrəs afum em aŋɛ ŋayi Misira mɔ. Ine ntɛ ŋayi kəbokər kətɔrəs ka abɛ aŋɛ ŋancəmbər ŋa dacar fɔr kiriŋ mɔ, incərɛ pucuy paŋan. ");
INSERT INTO bsp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","It'intorɛnɛ kədebaŋər ŋa aka Misira, ipɛnɛ ŋa sɔ atɔf ŋaŋɛ, ikekərɛ ŋa atɔf ŋobotu, atɔf ŋowokəlu disrɛ, nde atɔf ŋoboŋu dalɛ k’awop, atɔf nŋɛ aka Kanaŋ, aHit, aka Amɔr, aPerisi, aHiwy kɔ aYebus ŋandɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Kəbok ka aka Yisrayel kənder oŋ haŋ nnɔ iyi mɔ, k'inəŋk kətɔrəs kəlarəm nkɛ aka Misira ŋayi kətɔrəs afum em mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ndɛkəl oŋ məkɔ, isom əm ndena firawona. Məwurɛnɛ afum em aka Yisrayel Misira.» ");
INSERT INTO bsp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kɔ Musa eyif Kanu: «An'iyɔnɛ-ɛ, ntɛ indekɔ nda firawona, ikɔwurɛnɛ aka Yisrayel Misira mɔ?» ");
INSERT INTO bsp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kɔ Kanu kəloku kɔ: «In'osol'am! Tɛgbɛkərɛ ntɛ tendesɔŋ'am kəcərɛ a in'osom əm: Ntɛ məndewurɛnɛ aka Yisrayel Misira mɔ, fəp fonu nəde nəcsalɛn'em nnɔ tɔrɔ ntɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kɔ Musa oloku kɔ: «K'iŋkɔ nnɔ aka Yisrayel ŋayi mɔ, ikɔ icloku ŋa: Kanu ka atem anu kəsom im nnɔ nəyi mɔ. Mba kɔ ŋaŋkɔyif im ntɛ aŋwe ki mɔ, cəke c'iŋkɔloku ŋa-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kɔ Kanu kəloku Musa: «Nwɛ iyɔnɛ mɔ, iyɔnɛ!» Kɔ kəndeŋər: «Ntɛ tɔ məŋkɔloku aka Yisrayel: Nwɛ aŋwe ‹Iyɔnɛ› osom im nnɔ nəyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kɔ Kanu kəloku sɔ Musa: «Ntɛ tɔ məŋkɔloku aka Yisrayel: ‹MARIKI, Kanu ka atem anu, Kanu ka Abraham, ka Siyaka, ka Yakuba kəsom im nnɔ nəyi mɔ.› Tewe tem tɔ tatɔkɔ ta tɛm o tɛm, kɔ tɛcɛmcɛmnɛ tem tantɛ tɔ dɛtɛmp kɔ dɛtɛmp. ");
INSERT INTO bsp_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Məkɔ məloŋka abeki aka Yisrayel, məloku ŋa: ‹MARIKI, Kanu ka atem anu Abraham, Siyaka, kɔ Yakuba owurər im.› Kɔ kəloku: ‹Incɛm-cɛmnɛ kəwurɛ nu pəcuca pɔkɔ ancəmbər nu Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","K'iloku a kəwurɛnɛ nu k'inder kətɔrəs disrɛ nkɛ nəyi Misira mɔ, ikekərɛ nu atɔf ŋa aKanaŋ, aHit, aka Amɔr, aPerisi, aHiwy kɔ aYebus, atɔf nŋɛ ŋoboŋ dalɛ k’awop mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Aka Yisrayel ŋaŋkɔcəŋkəl dim dam, nəsol oŋ nəkɔ, məna kɔ abeki aka Yisrayel, ndena wəbɛ wəka Misira, nəloku kɔ: ‹MARIKI, Kanu ka aHebəre kəmbəp su. Ndɛkəl məwosɛ su kəkɔt marənt ma mata maas nde dətɛgbərɛ, ntɛ tɔŋsɔŋɛ səkɔ səloŋnɛ MARIKI Kanu kosu mɔ.› ");
INSERT INTO bsp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ina incərɛ a wəbɛ ka Misira ɔfɔdekɔwosɛ nu kəkɔ, ta pəyɔnɛ fənɔntər fəsɔŋɛ kɔ ti-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kətenci k'inder kəca isut Misira, mes mɛwɛy-wɛy mɔpɔŋ fəp m'indesutɛ Misira. Kɔ mes mamɔkɔ mencepər-ɛ, ŋadesak nu nəkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Indesɔŋɛ aka Yisrayel ŋasɔtɔ kəmar ka kəbɔtər ka aka Misira. Kɔ nənde nəckɔ-ɛ, nəfɔdekɔ waca wɔsɔkər. ");
INSERT INTO bsp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Aran aka Yisrayel fəp ŋade ŋawer aran a Misira aŋɛ ŋayi ndaraŋan, kɔ pəyɔnɛ fɛ ti-ɛ, aran akɔ ŋandɛ mɔ, ca ca gbeti, ya kɛma kɔ yamos, nyɛ nəndesarsər awut anu arkun kɔ aran mɔ. Ntɛ tɔ nəbaŋər aka Misira ca cəŋan.» ");
INSERT INTO bsp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mba kɔ Musa oluksɛ MARIKI moloku: «Ŋafɔdekɔlaŋ im, ŋafɔdekɔcəŋkəl dim dem. Ntɛ ŋandekɔloku mɔ: ‹MARIKI owurər f'am.›» ");
INSERT INTO bsp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kɔ MARIKI eyif kɔ: «Ake məntɔmpər-ɛ?» Kɔ Musa oloku: «Kəgbo.» ");
INSERT INTO bsp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kɔ MARIKI oloku: «Mələm ki ma dəntɔf.» Kɔ Musa ɛləm kəgbo kɔn dəntɔf, kɔ kəgbo kəntəŋkəlɛ abok. Kɔ Musa ɛyɛksər ŋi. ");
INSERT INTO bsp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kɔ MARIKI oloku Musa: «Mətɛnc kəca məsumpər ŋi nde dəkəleŋa.» Kɔ Musa ɛntɛnc kəca k'osumpər ŋi, kɔ ŋɛntəŋkəlɛ sɔ kəgbo kəca kɔn disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Kɔ MARIKI oloku Musa: «Tantɛ t'endekɔsɔŋɛ aka Yisrayel kəlaŋ oŋ a MARIKI Kanu ka atem aŋan, Kanu ka Abraham, Siyaka, kɔ Yakuba kəwurər əm.» ");
INSERT INTO bsp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kɔ MARIKI oloku sɔ Musa: «Məbɛr kəca duma tantɔf dɛbəkəc,» kɔ Musa ɛmbɛr kəca kɔn duma tantɔf k'endeŋnɛ dɛbəkəc. Ntɛ eliŋnɛ ki mɔ, «Eh!», kɔ sen səsumpər kɔ kəca kɔ kəferɛ, pəmɔ ntɛ kibi kəntufər paka mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kɔ Kanu kəloku kɔ sɔ: «Məgbɔkərɛ sɔ kədeŋnɛ kəca dɛbəkəc.» Kɔ Musa endeŋnɛ sɔ kəca kɔn duma tantɔf dɛbəkəc, «Eh!», kɔ akata ŋa kəca kɔn ŋoluksərnɛ sɔ kəyi pəmɔ ŋɔcɔkɔ-cɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Kɔ MARIKI oloku Musa: «Kɔ pəyɔnɛ a ŋalaŋ f'am, ŋancəŋkəl fɛ dim da tɛgbɛkərɛ tɛwɛy-wɛy tɔcɔkɔ-cɔkɔ-ɛ, ŋandelaŋ əm teta tɛgbɛkərɛ tɛwɛy-wɛy tɔcɔnc tantɛ. ");
INSERT INTO bsp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kɔ pəyɔnɛ a ŋasumpər fɛ sɔ moloku mam ta mɛgbɛkərɛ mɛwɛy-wɛy mamɛ mɛrəŋ-ɛ, ta ŋancəŋkəl dim dam-ɛ, məkɛt domun da Nil, məloŋ di antɔf ŋowosu kəroŋ, domun da kəŋgbɔkɔ ka Nil dadɔkɔ məŋloŋ mɔ, dɔŋyɔnɛ mecir antɔf ŋowosu kəroŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Kɔ Musa oloku MARIKI: «Məŋaŋnɛ Mariki, mba fum nwɛ ɔntɔfəfərɛnɛ temer mɔ iyɔnɛ. Bafɔ nendisna, bafɔ nendecna, bafɔ kəyɛfɛ ntɛ mənalɛk kəlok-lokər ina, wəcar kam, a k'ilelɛ kusu kɔ temer mɔ. Tɛsəkpər fɛ. Bawo ilelɛ kusu kɔ temer.» ");
INSERT INTO bsp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kɔ MARIKI oloku Musa: «An'ɔsɔŋ fum kusu ntɛ tɔŋsɔŋɛ pətam kəlok-loku mɔ-ɛ? An'ɔsɔŋɛ fum kəyɔnɛ bobo, kɔ pəyɔnɛ fɛ ti wətɔne-ɛ? An'ɔsɔŋɛ fum kənəŋk, kɔ pəyɔnɛ fɛ ti wətɔnəŋk-ɛ? Bafɔ in'ɔfɔ, ina MARIKI ba? ");
INSERT INTO bsp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ndɛkəl oŋ, məkɔ! Ina yati indekɔyi kɔ kusu kam, indekɔ ictəks'am tɔkɔ məndekɔ məcloku mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mba kɔ Musa oloku sɔ: «Məŋaŋnɛ Mariki mba ilɛtsɛn'am, məsom wəlɔma wəkɔ məfaŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kɔ pəntɛlɛ MARIKI nnɔ Musa eyi mɔ, k'oloku Musa: «Bafɔ məyɔ wɛnc Aruna, wəLewy? Incərɛ a oŋlok-loku belbel. Gbɛs, nkɔn ender wəkɔ kədefayn'am. Kənəŋk kam kəndebɔt kɔ dɛbəkəc. ");
INSERT INTO bsp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Məde məlok-lokər kɔ, məde məloku kɔ ntɛ endekɔloku mɔ. In'endekɔtɔmpər kusu kam kɔ kɔn, iŋkɔtəks'on tɔkɔ nəndekɔ nəcyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aruna endekɔlok-lokər'am afum aka Yisrayel, endekɔ kəcyɔn'am kusu, məna məyi pəmɔ kanu nkɛ kəsom kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Mətɔmpər kəgbo kaŋkɛ dəkəca, ki kɔ məŋkɔ məcmentərɛ mɛgbɛkərɛ mɛwɛy-wɛy.» ");
INSERT INTO bsp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kɔ Musa ɔŋkɔ, k'oluksərnɛ ndena Yetero papa ka wəran kɔn. Kɔ Musa oloku kɔ: «Ilɛtsɛn'am kəwos'em kəluksərnɛ Misira nde afum em ŋayi mɔ kəkɔnəŋk kɔ ŋasɔrɔyi doru-ɛ.» Kɔ Yetero oloku Musa: «Awa məkɔnɛ abəkəc ŋoforu.» ");
INSERT INTO bsp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Kɔ MARIKI oloku Musa, dəndo atɔf ŋa Madiyaŋ: «Məkɔ, məlukus Misira, bawo afum aŋɛ ŋanafaŋ kədif əm mɔ, ŋafi.» ");
INSERT INTO bsp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kɔ Musa ɛlɛk wəran kɔn kɔ awut ɔn, k'ɛndəs ŋa sɔfale kəroŋ, k'olukus atɔf ŋa Misira pətɔmpər kəgbo nkɛ Kanu kənaloku kɔ kəlɛk mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kɔ MARIKI oloku Musa: «Ntɛ məyi kəlukus Misira mɔ, məkɔkcɛ mɛgbɛkərɛ mɛwɛy-wɛy mɔkɔ isɔŋ'am kətam kəyɔ mɔ fəp, məkɔ məyɔ mi firawona fɔr kiriŋ. Mba ina Kanu, iŋkɔ icyeŋkəs kɔ domp ntɛ tɔŋsɔŋɛ ta ɛsak aka Yisrayel ŋakɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Məkɔ məloku firawona: ‹Ntɛ tɔ MARIKI oloku: Yisrayel coco cem cɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ilok'əm a məsak wan kem pəkɔ, ntɛ tɔŋsɔŋɛ pəkɔsalɛn'em mɔ. Mba ntɛ məfati kəsak kɔ pəkɔ mɔ, kədif k'inder wan kam wəcɔkɔ-cɔkɔ.›» ");
INSERT INTO bsp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kəlukus kəŋan disrɛ, kɔ Musa ɔŋkɔ pəcepərɛnɛ pibi kəfo kəlɔma, kɔ MARIKI ender pəbəp kɔ, pəcfaŋ kədif kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kɔ Sefora wəran kɔn ɛlɛk tasar towoŋu, k'eŋgbintɛ kərot ka wan kɔn, k'oŋgbuŋɛnɛnɛ ki wɛcək wa Musa, k'oloku: «Wos im wəka dəmecir məyɔn'em!» ");
INSERT INTO bsp_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","MARIKI ɛncɛm-cɛmnɛ fɛ sɔ kədif ka Musa teta kəkənc ka wan kɔn. Itɔ Sefora ɛnalokɛnɛ sɔ Musa: «Wos im wəka dəmecir!» Toloku tantɛ t'aŋloku teta kəkənc. ");
INSERT INTO bsp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Kɔ MARIKI oloku Aruna: «Məkɔ məbəpɛnɛ kɔ Musa nde dətɛgbərɛ.» Kɔ Aruna ɔŋkɔ pəbəp wɛnc Musa nde tɔrɔ ta Kanu, k'ɛsapnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kɔ Musa oloku wɛnc Aruna moloku kɔ mɛgbɛkərɛ mɛwɛy-wɛy fəp mmɛ MARIKI ɛnasom kɔ kəloku kɔ kəyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa kɔ Aruna ŋasol, kɔ ŋaŋkɔ ŋaloŋka abeki aka Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Kɔ Aruna oluksɛ abeki a Yisrayel moloku mmɛ MARIKI ɛnasom Musa kədeloku mɔ fəp, k'ementər mɛgbɛkərɛ mɛwɛy-wɛy fɔr ya afum kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Kɔ afum a Yisrayel ŋalaŋ. Kɔ ŋancərɛ a MARIKI enderɛnɛ te taŋan k'ɛncərɛ pəcuca pɔkɔ ŋayi disrɛ mɔ, kɔ ŋantontnɛ kəkor-koru belbel MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ntɛ tencepər mɔ, Musa kɔ Aruna ŋaŋkɔ ŋabəp firawona kɔ ŋaloku kɔ: «Ntɛ tɔ MARIKI oloku, Kanu ka aka Yisrayel: Məsak afum em ŋakɔ ŋaboc'em kəsata ka sali nde dətɛgbərɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kɔ firawona eyif ŋa: «An'ɔyɔnɛ MARIKI, ntɛ indecəŋkəl dim dɔn, isak aka Yisrayel ŋakɔ mɔ? Incərɛ fɛ MARIKI, tamɛrəŋ ta ti sɔ, ifɔsak aka Yisrayel ŋakɔ nnɔ o nnɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Kɔ Musa ŋaloku kɔ Aruna: «Kanu ka aHebəre kənabəp su. Məsak su, ilɛtsɛn'am, səkɔt mata maas dətɛgbərɛ səkɔloŋnɛ MARIKI Kanu kosu, ntɛ tɔŋsɔŋɛ ta osutɛ su arom kɔ dakma mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kɔ wəbɛ ka Misira eyif ŋa: «Məna Musa kɔ Aruna, ta ake tɔ nəfaŋ kəyamsɛ afum yɛbəc yaŋan-ɛ?» A cəke? Nəkɔ nəsumpər yɛbəc yonu ya dacar. ");
INSERT INTO bsp_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kɔ firawona oloku: «Nənəŋk, aka Yisrayel ŋala oŋ dɔtɔf! Kɔ nəsɔŋɛ ŋa kəsak yɛbəc yaŋan yeyeŋki.» ");
INSERT INTO bsp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Dɔsɔk din dadɔkɔ dɔ firawona osom abɛ a dacar aMisira kɔ abum aYisrayel, pəcloku: ");
INSERT INTO bsp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Ta nəgbɔkərɛ sɔ kəcsɔŋ aka Yisrayel mɛmpəlɛ mosutɛ birik pəmɔ tɔkɔ nəsɔŋsa ŋa nendisna kɔ nendecna mɔ. Mɛnɛ ŋasərka ŋakɔ oŋ ŋactɛn mi! ");
INSERT INTO bsp_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Kəlɔm ka birik nkɛ ŋasutsa nendisna kɔ nendecna mɔ, nəgbəc ŋa ŋasut ki! Ta nəbelɛ ŋa kəlɔm kaŋkɔ de! Bawo acembər ŋɔ ŋayɔnɛ! Ti tɔ ŋambokɛnɛnɛ, ŋacloku: ‹Paŋkɔn loŋnɛ Kanu kosu.› ");
INSERT INTO bsp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nəbɛrɛnɛ yɛbəc ya afum akaŋɛ, pəmar ŋabəc yi ntɛ tɔŋsɔŋɛ ta ŋancəŋkəl sɔ moloku ma yem mamɔkɔ mɔ!» ");
INSERT INTO bsp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kɔ abɛ a dacar kɔ abum aYisrayel ŋaloku afum: «Ntɛ tɔ firawona oloku: ‹Ifɔsɔsɔŋ nu mɛmpəlɛ! ");
INSERT INTO bsp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Nəkɔ, nənasərka nətɛn mɛmpəlɛ nnɔ o nnɔ nəntam kəsɔtɔ mi mɔ, mba ali pəpic afɔdebeli yɛbəc yonu yeyeŋki nyɛ pəmar nu kəbəc mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kɔ aka Yisrayel ŋasamsər atɔf ŋa Misira fəp, kətɛn toka ya mɛmpəlɛ mosutɛ birik. ");
INSERT INTO bsp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Abɛ a dacar aMisira ŋacgbəŋ-gbəŋər ŋa, ŋacloku: «Nəkufɛ nəlip yɛbəc yonu ya dɔsɔk o dɔsɔk, pəmɔ cɔkɔ-cɔkɔ ntɛ mɛmpəlɛ mencyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ŋanakɔ haŋ ŋacsut abum aYisrayel aŋɛ abɛ a Misira aka firawona ŋanacəmbərɛ aka Yisrayel mɔ, ŋacyif ŋa: «Ta ake tɔ nəntɔbəpɛ mɔkɔ kəlɔm ka birik bɔkɔ nəsutsa nendisna kɔ nendecna mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kɔ abum aYisrayel ŋaŋkɔ ŋabokɛnɛ nnɔ firawona eyi mɔ, kɔ ŋaloku kɔ: «Ta ake tɔ məntɔrsɛ tantɛ acar am-ɛ? ");
INSERT INTO bsp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ayi fɛ sɔ kəsɔŋ acar am mɛmpəlɛ, k'aŋloku su sɔ: ‹Nəsut birik!› Mənəŋk ntɛ aŋsut acar am mɔ, mba afum am yati, ŋasarɛ kiciya.» ");
INSERT INTO bsp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mba kɔ firawona oluksɛ ŋa: «Nəna nəncembər, nəfanɛ! Ti tɔ nəŋlokɛnɛ: ‹Paŋkɔn loŋnɛ MARIKI!› ");
INSERT INTO bsp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ndɛkəl oŋ, nəkɔ nəsumpər yɛbəc yonu. Afɔsɔsɔŋ nu mɛmpəlɛ, mba kəlɔm ka birik bɔkɔ amboncər nu kəsut mɔ, kɔ nəndesut.» ");
INSERT INTO bsp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kɔ abum aYisrayel ŋa sɔ ŋanəŋk pəcuca pɔkɔ ŋayi mɔ ntɛ aloku ŋa: «Afɔbeli kəlɔm ka birik bɔkɔ amboncər nu kəsut dɔsɔk o dɔsɔk mɔ!» ");
INSERT INTO bsp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ntɛ abɛ aŋɛ ŋancsɔŋəs aka Yisrayel yɛbəc yeyeŋki ŋawur nda firawona mɔ, kɔ ŋambəp Musa kɔ Aruna aŋɛ ŋackar ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kɔ abum aYisrayel ŋaloku Musa kɔ Aruna: «MARIKI pəmɔmən nu, pəsɔŋ nu kəway! Nəsɔŋɛ firawona kɔ amarəs ɔn kəter su. Nəlɛk sakma kɔ nəmbɛr ŋa dəwaca ŋadif su!» ");
INSERT INTO bsp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Kɔ Musa oluksərnɛ nnɔ MARIKI eyi mɔ, k'oloku: «Mariki ta ake tɔ məyɔnɛ afum akaŋɛ pəlɛc-ɛ? Itɔ mənasom em ba? ");
INSERT INTO bsp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kəyɛfɛ ntɛ iŋkɔ ndena firawona k'ilok-lokər kɔ tewe tam mɔ, pəlɛc dəm peyi kəyɔ afum akaŋɛ, məyi fɛ kəyɔ tɔlɔm o tɔlɔm məbaŋ afum am.» ");
INSERT INTO bsp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","MARIKI oloku Musa: «Kənəŋk kɔ mənder oŋ, ntɛ indeyɔ firawona mɔ: Kəca ka fənɔntər k'indesɔŋɛnɛ kɔ kəsak aka Yisrayel ŋakɔ. Tɔyɔ ta kəca ka fənɔntər fem tendesɔŋɛ kɔ yati kəbɛləs aka Yisrayel atɔf ŋɔn disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kɔ Kanu kəlok-lokər sɔ Musa, kəcloku kɔ: «In'ɔyɔnɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Inawurər Abraham, k'iwurər Siyaka, k'iwurər Yakuba, ina, Kanu nkɛ kəntam mes ma doru fəp mɔ, mba tɔcɔkɔ-cɔkɔ inasɔŋɛ fɛ ŋa kəcərɛ tewe tem ta ‹MARIKI›. ");
INSERT INTO bsp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Inasek sɔ danapa kɔ ŋa, k'isɔŋ ŋa Kanaŋ atɔf nŋɛ ŋanccepɛ-cepɛ kəndɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","K'ine sɔ kigbis ka aka Yisrayel aŋɛ aka Misira ŋayi kətɔrsɛ dacar mɔ, k'incɛm-cɛmnɛ danapa ndɛ inasek kɔ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ti tɔ məŋkɔlokɛnɛ aka Yisrayel a in'ɔyɔnɛ MARIKI, indewurɛ nu yɛbəc yeyeŋki nyɛ aka Misira ŋancəmbər nu mɔ, indewurɛ nu yɛbəc nyɛ aka Misira ŋayi kətɔrsɛ nu mɔ. Fənɔntər fem f'indewursɛ nu ŋa dəwaca a idebocər ŋa kiti kəlel. ");
INSERT INTO bsp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Indebaŋ nu ntɛ tɔŋsɔŋɛ nəyɔnɛ afum em, iyɔnɛ Kanu konu mɔ. Tɛm tatɔkɔ nəndecərɛ sɔ a in'ɔyɔnɛ MARIKI Kanu konu, nkɛ kəwurɛ nu yɛbəc yeyeŋki nyɛ aka Misira ŋancəmbər nu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Iŋkɔbɛrsɛ nu atɔf nŋɛ inadot kəca idɛrmɛ Abraham, Siyaka, kɔ Yakuba kəsɔŋ nu mɔ. Ina MARIKI iŋkɔsɔŋ nu ŋi ŋɔyɔnɛ ŋonu.» ");
INSERT INTO bsp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ti tɔ Musa ɛnaloku aka Yisrayel, mba ŋancne fɛ tɔkɔ Musa oncloku ŋa mɔ. Bəkəc yɛnafəfərɛnɛ ŋa teta yɛbəc yeyeŋki yɔkɔ ŋanayi disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kɔ MARIKI oloku sɔ Musa: ");
INSERT INTO bsp_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Məkɔ məloku firawona wəbɛ ka Misira a pəsak aka Yisrayel ŋakɔ, ŋawur atɔf ŋɔn.» ");
INSERT INTO bsp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kɔ Musa oloku fɔr ya MARIKI kiriŋ: «Kɔ aka Yisrayel ŋantɔcəŋkəl im, cəke cɔ firawona ɔŋkɔcəŋkəl im-ɛ, ina nwɛ ilelɛ temer mɔ?» ");
INSERT INTO bsp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Kɔ MARIKI oloku Musa kɔ Aruna, k'osom ŋa teta aka Yisrayel kɔ firawona wəbɛ ka Misira, ŋawurɛnɛ aka Yisrayel atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Mewe ma akiriŋ aŋan dəwɔlɔ mɔ mmɛ: Awut a Ruben Coco ca Yisrayel (Yakuba): Henok, Palu, Hecərɔŋ kɔ Karmi. Cor ca Ruben cənayi cacɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Awut a Simeyɔŋ: Yemuyɛl, Yamin, Ohad, Yakin kɔ Cohar, Sawul wəkɔ wəKanaŋara ɛnakomɛ kɔ mɔ. Cor ca Simeyɔŋ cənayi cacɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Mewe ma awut a Lewy mɔ mmɛ tɔkɔ ŋaŋkomɛnɛ mɔ: Kerson, Kehat kɔ Merari. Kəwon ka Lewy doru kənabəp meren tasar tin wəco maas kɔ camət-mɛrəŋ (137). ");
INSERT INTO bsp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Awut a Kerson: Libni kɔ Simeyi, kɔ cor cəŋan. ");
INSERT INTO bsp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Awut a Kehat: Amram, Yicahar, Hebərɔŋ kɔ Usiyɛl. Kəwon ka Kehat doru kənasɔtɔ meren tasar tin wəco maas kɔ maas (133). ");
INSERT INTO bsp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Awut a Merari: Mali kɔ Musi. Cor ca Lewy cənayi cacɔkɔ kɔ tɔkɔ anacicəs taruku ta dokombəra da Lewy disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Kɔ Amram ɛnɛncɛ wəran nwɛ ancwe Yokɛbɛd wəkirɛ ka kas mɔ, kɔ wəkakɔ oŋkomɛ kɔ Aruna kɔ Musa. Kəwon ka Amram doru kənasɔtɔ meren tasar tin wəco maas kɔ camət-mɛrəŋ (137). ");
INSERT INTO bsp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Awut a Yicahar: Kore, Nefɛk kɔ Sikiri. ");
INSERT INTO bsp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Awut a Usiyɛl: Misayel, Elcafaŋ kɔ Sitiri. ");
INSERT INTO bsp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Kɔ Aruna ɛnɛncɛ wəran nwɛ ancwe Eliseba mɔ, wan ka Aminadab wəran, wəkirɛ ka Nasɔŋ. Kɔ wəkakɔ oŋkomɛ kɔ Nadab, Abihu, Elasar kɔ Itamar. ");
INSERT INTO bsp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Awut a Kore: Asir, Elkana kɔ Abiyasaf. Cor ca Kore cənayi cacɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Kɔ Elasar, wan ka Aruna, ɛnɛncɛ wəran awut aran a Putiyel dacɔ, kɔ wəkakɔ oŋkomɛ kɔ wan wərkun nwɛ anawe Finehas mɔ. Akiriŋ a cor ca Lewy ŋ'akakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Afum akaŋɛ mɛrəŋ Musa kɔ Aruna ŋɔ MARIKI ɛnaloku: «Nəwurɛnɛ aka Yisrayel atɔf ŋa Misira dəcor dəcor.» ");
INSERT INTO bsp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aruna kɔ Musa yati ŋanalok-lokər firawona wəbɛ wəka Misira teta kəwurɛnɛ ka aka Yisrayel atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Dɔsɔk ndɛ MARIKI ɛnalok-lokər Musa nde atɔf ŋa Misira mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kɔ MARIKI oloku Musa: «In'ɔyɔnɛ MARIKI. Məkɔ məgbɔkərɛ məloku firawona wəbɛ ka Misira moloku fəp mmɛ ilok'əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kɔ Musa oloku fɔr ya MARIKI kiriŋ: «Ina nwɛ ilelɛ temer mɔ: Cəke cɔ firawona ɔŋkɔcəŋkəl im-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kɔ MARIKI oloku Musa: «Məcəŋkəl im, indesɔŋ'am kəyɔnɛ kanu nnɔ firawona eyi mɔ. Wɛnc əm Aruna nkɔn endedəŋk mi, nkɔn pəyɔnɛ sayibɛ sam. ");
INSERT INTO bsp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mən'endekɔ məcloku tɔkɔ indekɔ icsom əm fəp, wɛnc əm pəcgbɔkərɛnɛ mi firawona, ntɛ tɔsɔŋɛ pəsak aka Yisrayel ŋawur atɔf ŋɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Kɔ ina, in'ɔŋkɔ icyeŋkəs firawona domp, icyɔ Misira mɛgbɛkərɛ mɛwɛy-wɛy kɔ mɔyɔ mɔpɔŋ mɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Firawona ɔfɔcəŋkəl nu. Tɛm tatɔkɔ t'iŋkɔsutɛ Misira kəca kem, iwurɛnɛ aka Yisrayel afum em dəcor dəcor, citi cəpɔŋ c'indewurɛnɛ ŋa atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Aka Misira ŋandecərɛ a in'ɔyɔnɛ MARIKI ntɛ indesutɛ ŋa kəca kem, iwurɛnɛ aka Yisrayel di mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa kɔ Aruna ŋayɔ belbel tɔkɔ MARIKI ɛnasom ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tɛnatəŋnɛ Musa pəsɔtɔ meren wəco camət-maas (80), kɔ wɛnc Aruna meren wəco camət-maas kɔ maas (83), tɛm ntɛ ŋanclok-lokər firawona mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Tɛm ntɛ firawona endeloku: ‹Nəyɔ tɛgbɛkərɛ tɛwɛy-wɛy mɔ,› məna məloku Aruna: ‹Məlɛk kəgbo kam mələm ki firawona dəntɔf.› Kəgbo kaŋkɔ kəndetəŋkəlɛ kəyɔnɛ abok.» ");
INSERT INTO bsp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kɔ Musa ŋaŋkɔ kɔ Aruna nde firawona eyi mɔ, kɔ ŋayɔ pəmɔ tɔkɔ MARIKI ɛnasom ŋa mɔ. Kɔ Aruna ɛləm kəgbo kɔn dəntɔf fɔr ya firawona kɔ amarəs ɔn kiriŋ, kɔ kəgbo kaŋkɔ kəntəŋkəlɛ abok. ");
INSERT INTO bsp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mba kɔ firawona ewe asɛr kɔ acərɛ mes a Misira. Dure fəp faŋan kɔ ŋa sɔ ŋayɔ tin tayi. ");
INSERT INTO bsp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Akakɔ fəp, kɔ ŋaləməs cəgbo cəŋan dəntɔf, kɔ cəntəŋkəlɛ bok. Mba kɔ kəgbo ka Aruna kəmerəs cəgbo cəŋan. ");
INSERT INTO bsp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kɔ firawona eyeŋk sɔ domp, k'ɛfati kəcəŋkəl Musa kɔ Aruna pəmɔ tɔkɔ MARIKI ɛnaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kɔ MARIKI oloku Musa: «Firawona ɛntaŋ aləŋəs, ɛfati kəsak aka Yisrayel ŋakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bətbətana, mədena məkɔ məbəp firawona tɛm ntɛ endena pəcder nde dəkəŋgbɔkɔ mɔ. Mədena məcəmɛ məkar kɔ nde agbɛp ŋa kəŋgbɔkɔ ka Nil, mətɔmpər kəgbo kaŋkɔ kənatəŋkəlɛ abok mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mədena sɔ məloku firawona: ‹MARIKI Kanu k'aHebəre kəsom im nnɔ məyi mɔ, idelok'əm: Məsak afum em ŋakɔ, ntɛ tɔŋsɔŋɛ ŋakɔ ŋasalɛn'em nde dətɛgbərɛ mɔ.› Mba məna, haŋ ndɛkəl məyi fɛ kəcəŋkəl ti. ");
INSERT INTO bsp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ntɛ tɔ MARIKI oloku: ‹Tantɛ tendesɔŋ'am kəcərɛ a in'ɔyɔnɛ MARIKI: Kəsutɛ k'inder domun da kəŋgbɔkɔ ka Nil kəgbo kaŋkɛ, dɛtəŋkəlɛ dɔyɔnɛ mecir. ");
INSERT INTO bsp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Lop nyɛ yeyi dəkəŋgbɔkɔ mɔ, yendefi. Domun da dəkəŋgbɔkɔ dendesɛn pəlɛc, aka Misira ŋafɔdewosɛ sɔ kəmun ka domun da kəŋgbɔkɔ kaŋkɔ.›» ");
INSERT INTO bsp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kɔ MARIKI oloku Musa: «Məloku Aruna: Məlɛk kəgbo kam məcenc kəca kam domun da Misira kəroŋ kəyɛfɛ ka domun da dəsəbo kəbəp ka da dəsəŋgbəl, haŋ da dəcumbul kəkɔ ka da yɛmɛŋkɛ domun yaŋan fəp.» Domun dendetəŋkəlɛ mecir, mecir mendeyi Misira fəp, haŋ dəyɛmɛŋkɛ domun ya masar kɔ ya tɔk. ");
INSERT INTO bsp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa kɔ Aruna ŋanayɔ pəmɔ tɔkɔ MARIKI ɛnasom ŋa mɔ. Kɔ Musa eyekti kəgbo kəsutɛ ki domun da Nil fɔr ya firawona kɔ amarəs ɔn kiriŋ, kɔ domun da dəkəŋgbɔkɔ fəp dɛntəŋkəlɛ mecir. ");
INSERT INTO bsp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kɔ lop nyɛ yɛnayi kəŋgbɔkɔ ka Nil mɔ fəp yefi, kɔ domun da Nil dɛsɛn pəlɛc, aka Misira ŋanctam fɛ sɔ kəmun domun da Nil, kɔ mecir meyi Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kɔ dure aka Misira ŋayɔ deser daŋan fəp. Kɔ firawona eyeŋk sɔ domp, ɛncəŋkəl fɛ Musa kɔ Aruna, pəmɔ tɔkɔ MARIKI ɛnaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kɔ firawona olukus nde ndɔrɔn, ɛnabɛr fɛ mɔyɔ mamɔkɔ dɛbəkəc. ");
INSERT INTO bsp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Kɔ aka Misira fəp ŋaŋkayəs cələmp nde kəŋgbɔkɔ ka Nil kəsək ntɛ tɔŋsɔŋɛ ŋasɔtɔ domun domun mɔ, bawo ŋanctam fɛ sɔ kəmun domun da Nil. ");
INSERT INTO bsp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kɔ mata camət-mɛrəŋ mencepər kəyɛfɛ ntɛ MARIKI osut domun da Nil mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Kɔ MARIKI oloku Musa: «Məde məkɔ nde firawona eyi mɔ, məloku kɔ: ‹Ntɛ tɔ MARIKI oloku: Məsak afum em ŋakɔ ntɛ tɔŋsɔŋɛ ŋakɔ ŋasalɛn'em mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Kɔ məfati kəsak ŋa ŋakɔ-ɛ, ina MARIKI, iŋsutɛ atɔf ŋam fəntəl. ");
INSERT INTO bsp_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Kəŋgbɔkɔ ka Nil kəndesɛp fəntəl, nyɛ yendepɛ yɛbɛrɛ kəlɔ kam disrɛ, yɛbɛrɛ nde dəkəfəntərɛ dam, yɛpɛsɛ nde kəfənc kam, yɛbɛrɛ sɔ nde wɔlɔ wa amarəs am kɔ afum am fəp, yendebɛrɛ sɔ nde ancɔf'am cəcom, haŋ ampɔcək'am cəcom mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Fəntəl yendefərəŋk əm, yɛfərəŋk afum am kɔ amarəs am fəp.›» ");
INSERT INTO bsp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ntɛ tɔ kɔ MARIKI oloku Musa: «Məloku Aruna: ‹Məcenc kəca kam kɔ kəgbo kam kəŋgbɔkɔ kəroŋ, nde dəsəŋgbəl sa Nil fəp, haŋ nde dəcumbul, məpɛnɛ fəntəl atɔf ŋa Misira.›» ");
INSERT INTO bsp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kɔ Aruna encenc kəca kɔn domun da Misira kəroŋ, kɔ fəntəl yɛmpɛ kɔ yoŋkump antɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kɔ dure kɔ deser daŋan ŋa sɔ ŋayɔ pəmɔ tatɔkɔ, kɔ ŋampɛnɛ fəntəl antɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kɔ firawona ewe Musa kɔ Aruna k'oloku ŋa: «Nətolanɛ su MARIKI pəbɔlɛn'em fəntəl yayɛ kɔ afum em. Tɛm tatɔkɔ iŋsak afum aka Yisrayel, ntɛ tɔŋsɔŋɛ ŋakɔ ŋaloŋnɛ MARIKI mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kɔ Musa oloku firawona: «Pəlel pam, ake tɛm t'indetolan'on, kɔ amarəs am, kɔ afum aka atɔf ŋam, ntɛ tɔŋsɔŋɛ pəsɔlɛnɛ fəntəl ya nde ndaram kɔ ya nde wɔlɔ wam, pəcəmɛ ya nde dəkəŋgbɔkɔ gbəcərəm nyɛ ɔntɔdeliŋ mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kɔ firawona oloku kɔ: «Məyɔ ti alna.» Kɔ Musa oloku kɔ: «Tendeyi pəmɔ tɔkɔ məloku ti mɔ, tɔsɔŋ'am kəcərɛ a ali fum eyi fɛ pəmɔ MARIKI Kanu kosu! ");
INSERT INTO bsp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Fəntəl yendebɔl'am kɔ wɔlɔ wam, k'amarəs am, k'afum am, mɛnɛ nde dəkəŋgbɔkɔ ka Nil gbəcərəm yendeyi.» ");
INSERT INTO bsp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musa kɔ Aruna ŋawur ndena firawona, kɔ Musa ɛlɛtsɛnɛ MARIKI teta fəntəl nyɛ ɛnakɛrɛ firawona kətɔrəs kɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kɔ MARIKI ɔyɔ tɔkɔ Musa ɛnaloku kɔ mɔ. Kɔ fəntəl yefis-fis kəyɛfɛ nde dəwɔlɔ, dəcəbaŋka haŋ nde dalɛ. ");
INSERT INTO bsp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","K'aloŋka-loŋka yi mɛpɛsa mɛpɛsa, kɔ ambɔnc ŋa pəte pa yi ŋosumpər atɔf ŋa Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mba ntɛ firawona ɛnəŋk a kəŋesəm kənder mɔ, k'eyeŋk sɔ domp, ɛncəŋkəl fɛ sɔ Musa kɔ Aruna pəmɔ tɔkɔ MARIKI ɛnaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kɔ MARIKI oloku Musa: «Məloku Aruna: ‹Məcenc kəgbo kam, məsutɛ ki kəbof ka dəntɔf.› Kəbof kaŋkɔ kəndetəŋkəlɛ mes-yɛŋaŋ Misira fəp.» ");
INSERT INTO bsp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Itɔ ŋanayɔ. Kɔ Aruna encenc kəgbo kɔn k'osutɛ ki kəbof ka dəntɔf. Kɔ kəbof kaŋkɔ kəntəŋkəlɛ mes nyɛ yɛncŋaŋ afum kɔ yɔcɔl mɔ, kɔ kəbof ka atɔf ŋa Misira fəp kəyɔnɛ mes. ");
INSERT INTO bsp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kɔ dure ŋa sɔ ŋawakəs deser daŋan fəp ntɛ tɔŋsɔŋɛ ŋa sɔ ŋawurɛ mes-yɛŋaŋ mɔ, mba ŋanatam fɛ. Kɔ mes yɛlar-lar afum kɔ yɔcɔl. ");
INSERT INTO bsp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kɔ dure ŋaloku firawona: «Kəca ka Kanu kɔ!» Mba firawona encyeŋk kəyeŋk dəm domp, owosɛ fɛ kəcəŋkəl Musa kɔ Aruna, pəmɔ tɔkɔ MARIKI ɛnaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kɔ MARIKI oloku Musa: «Məde məyɛfɛ bətbət suy, məkɔ məcəmɛ dɔpɔ dɔkɔ firawona encepər mɔ. K'ende kəcwur kəkɔ ka nde dəkəŋgbɔkɔ-ɛ, məde məloku kɔ: ‹Ntɛ tɔ MARIKI oloku: Məsak afum em ntɛ tɔŋsɔŋɛ ŋakɔ ŋasalɛn'em mɔ! ");
INSERT INTO bsp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kɔ məntɔsak afum em ŋakɔ-ɛ, iŋwɛnər'on kənay ka waŋkəp yɛlarəm, kəyɛfɛ məna, kəkɔ amarəs am, kəbəp afum am haŋ wɔlɔ wam. Wɔlɔ wa aka Misira wendelarɛ waŋkəp haŋ yokump antɔf nŋɛ ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mba dɔsɔk dadɔkɔ indegbɛy atɔf ŋa Kosɛŋ nde afum em ŋayi mɔ, dəndo taŋ waŋkəp yɛlarəm yɔfɔkɔyi di, isɔŋ'am oŋ kəcərɛ a ina, MARIKI, iyi atɔf ŋaŋɛ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Indeboc tɛgbɛkərɛ afum em kɔ afum am dacɔ, ntɛ tendeyɔnɛ tɛyacɛ ta afum em mɔ. Alna tɛgbɛkərɛ tɛwɛy-wɛy tatɔkɔ teŋyi.›» ");
INSERT INTO bsp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kɔ MARIKI ɔyɔ tatɔkɔ. Kɔ waŋkəp yɛlarəm yender nde kəlɔ ka firawona kɔ nde kəlɔ ka amarəs ɔn, kɔ nde atɔf ŋa Misira fəp kɔ waŋkəp yɛlarəm yayɔkɔ yɛləsər atɔf. ");
INSERT INTO bsp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kɔ firawona ewe Musa kɔ Aruna, k'oloku ŋa: «Nəkɔ nəloŋnɛ Kanu konu nnɔ atɔf ŋaŋɛ disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kɔ Musa oluksɛ firawona: «Pəntesɛ fɛ kəyɔ tatɔkɔ, bawo kəloŋnɛ nkɛ səŋkɔloŋnɛ MARIKI Kanu kosu mɔ, kəloŋnɛ kɔ nkɛ kəyik-yik aka Misira mɔ teta dinɛ daŋan, kɔ səloŋnɛ ki fɔr yaŋan kiriŋ-ɛ, bafɔ ŋandeca-cas su ba? ");
INSERT INTO bsp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mata maas mɔ səndekɔt nde dətɛgbərɛ a səkɔloŋnɛ MARIKI Kanu kosu, pəmɔ tɔkɔ ɔŋkɔloku su ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kɔ firawona oloku: «Ina kəsak nu k'inder nəkɔloŋnɛ MARIKI Kanu konu nde dətɛgbərɛ. Mba ta nəbɔlɛ de, nətolanɛn'em!» ");
INSERT INTO bsp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kɔ Musa oloku firawona: «Inckɔwur nnɔ ndaram intola MARIKI, alna tuŋ waŋkəp yɛlarəm yayɛ yɔmbɔlɛ firawona, amarəs ɔn kɔ afum ɔn. Mba ta firawona pəgbɔkərɛ sɔ kəyembər su, ta pəfati kəsak aka Yisrayel ŋakɔloŋnɛ MARIKI.» ");
INSERT INTO bsp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ntɛ Musa owur ndena firawona mɔ, k'ontola MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kɔ MARIKI ɔyɔ tɔkɔ Musa ɛnaloku kɔ mɔ, kɔ waŋkəp yɛlarəm yɔmbɔlɛ firawona, kɔ afum ɔn, kɔ amarəs ɔn. Ali awaŋkəp ŋin ŋɛnayi fɛ sɔ Misira. ");
INSERT INTO bsp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mba kɔ firawona ɛntaŋ aləŋəs, owosɛ fɛ kəsak aka Yisrayel ŋakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kɔ MARIKI oloku Musa: «Məkɔ məbəp firawona, məkɔ məloku kɔ: ‹Ntɛ tɔ MARIKI, Kanu ka aHebəre kəloku: Məsak afum em ŋakɔ ntɛ tɔŋsɔŋɛ ŋakɔ ŋasalɛn'em mɔ.› ");
INSERT INTO bsp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kɔ məfati kəsak ŋa ŋakɔ, məwon sɔ kəsumpər ŋa sɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","MARIKI oŋsutɛ yɔcɔl yam kəca nyɛ yeyi dəkulum mɔ, kəyɛfɛ ka fəlɛs kəbəp ka sɔfale, yɔkɔmɛ kəkɔ ka nde cəna kɔ ŋkesiya yeyi mɔ, yendesɔtɔ arom ŋɛlɛc. ");
INSERT INTO bsp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mba MARIKI endegbɛy yɔcɔl ya aka Yisrayel nnɔ yɔcɔl ya aka Misira yeyi mɔ, ali pɔcɔl pin pɔfɔdefi yɔcɔl ya aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","MARIKI ombonc dɔsɔk ndɛ toncop mɔ, oloku a alna ɔŋyɔ ti atɔf ŋa Misira disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kɔ MARIKI ɔyɔ ti dɔckɔsɔk. Kɔ yɔcɔl ya aka Misira yefi, ali pɔcɔl pa aka Yisrayel pin pɛnafi fɛ. ");
INSERT INTO bsp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kɔ firawona osom pakɔ patɛn mes mamɔkɔ. K'aŋkɔ pabəp ali pɔcɔl pa aka Yisrayel pin pɛnafi fɛ. Mba haŋ tɛm tantɛ firawona ɛntaŋ aləŋəs, ɛsak fɛ aka Yisrayel ŋakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kɔ MARIKI oloku Musa kɔ Aruna: «Nəwɛt asum ŋa karɔrɔ kəca pet, Musa pələm ŋi darenc fɔr ya firawona kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Asum ŋaŋɔkɔ ŋendetəŋkəlɛ kəfəl atɔf ŋa Misira fəp kəroŋ. Kəfəl kaŋkɔ kəndesɔŋ atɔf ŋa Misira fəp kəyɛfɛ afum kəbəp ka yɔcɔl pəkəfər-kəfər mpɛ pendeyɔnɛ ŋa bɛcɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Musa kɔ Aruna ŋawɛt asum ŋa karɔrɔ kɔ ŋaŋkɔ ŋabəp firawona, kɔ Musa ɛləm asum ŋaŋɔkɔ darenc, kɔ ŋɔsɔŋ afum kɔ yɔcɔl bɛcɛ ya arom. ");
INSERT INTO bsp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Dure aMisira ŋanctam fɛ kəcəmɛ Musa fɔr kiriŋ, teta bɛcɛ nyɛ yɛnawur ŋa pəmɔ tɔkɔ yɛnawur aka Misira fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kɔ MARIKI ɔncɔŋəs sɔ firawona kəyeŋk domp, ɛncəŋkəl fɛ ŋa sɔ pəmɔ tɔkɔ MARIKI ɛnaloku ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kɔ MARIKI oloku Musa: «Məde məyɛfɛ bətbət suy, məkɔ məmentərnɛ firawona kiriŋ. Məloku kɔ: ‹Ntɛ tɔ MARIKI, Kanu ka aHebəre kəloku: Məsak afum em ŋakɔ, ŋasalɛn'em. ");
INSERT INTO bsp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Bawo tantɛ taŋ mən'indesɔŋ pucuy pem fəp, kəyɛfɛ ka amarəs am kəbəp ka afum am fəp, ntɛ tɔŋsɔŋɛ məcərɛ a paka mpɛ o mpɛ powurɛnɛ fɛ kɔ ina doru dandɛ. ");
INSERT INTO bsp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Inacenc kəca isut am arom, məna kɔ afum am-ɛ, kɔ məməlkɛ ntɛ doru dandɛ. ");
INSERT INTO bsp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mba isak əm kɔ məyi doru ntɛ tɔsɔŋɛ imentər əm fənɔntər fem, tɔsɔŋɛ sɔ tewe tem tɛsamsər doru fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kɔ məmpətəs sɔ afum em, məsak fɛ ŋa ŋakɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","intufər aka Misira alna dec dandɛ letər dɛlarəm ndɛ dɛntatɔtuf Misira kəyɛfɛ dɔsɔk ndɛ moncop mɔ haŋ ndɛkəl. ");
INSERT INTO bsp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ndɛkəl oŋ, məsom nde dalɛ pakɛrɛ pɔcɔl mpɛ o mpɛ kɔ daka ndɛ o ndɛ dɔyɔnɛ dam mɔ, letər dendetorər afum kɔ yɔcɔl fəp kəroŋ nyɛ yeyi dalɛ ta aloŋka yi dəkəlɔ mɔ, yendefi.›» ");
INSERT INTO bsp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Amarəs a firawona aŋɛ ŋananesɛ toloku ta MARIKI mɔ, ŋambɛrsɛ acar aŋan kɔ yɔcɔl yaŋan dəcəkɛr katəna. ");
INSERT INTO bsp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mba aŋɛ ŋanatɔbɛr moloku ma MARIKI dɛbəkəc mɔ, ŋasak acar aŋan kɔ yɔcɔl yaŋan dalɛ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kɔ MARIKI oloku Musa: «Məpɛnɛ kəca kam darenc, letər dotor atɔf ŋa Misira disrɛ fəp, afum kəroŋ, yɔcɔl kəroŋ kɔ yika ya dalɛ da Misira kəroŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Kɔ Musa ɛmpɛnɛ kəgbo kɔn darenc, kɔ MARIKI owurɛ dim da pukulɛ-kulɛ, kɔ letər dontor, kɔ dɛwɛ dosut antɔf. Kɔ MARIKI ontorɛ letər dəntɔf pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Kɔ letər dontor, nɛnc dɛccɛsəŋɛ letər dacɔ. Kəyɛfɛ ntɛ doru dɛnacop mɔ haŋ mɔkɔ, letər, afef kɔ dɛwɛ yɛntator fɛ Misira pəmɔ dɔsɔk dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Kɔ letər dontorər ca yɔkɔ yɛnayi dalɛ mɔ fəp, antɔf ŋa Misira fəp kəyɛfɛ ka afum kəbəp ka yɔcɔl. Kɔ letər dosut sɔ yika ya dalɛ fəp, kɔ dentep-tepi sɔ tɔk ya dalɛ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Atɔf ŋa Kosɛŋ gbəcərəm nde aka Yisrayel ŋanayi mɔ, ŋɔ letər dɛnatɔtor. ");
INSERT INTO bsp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kɔ firawona osom pawenɛ kɔ Musa kɔ Aruna k'oloku ŋa: «Tantɛ taŋ, inciya. MARIKI olomp, ina kɔ afum em sən'eciya. ");
INSERT INTO bsp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nətola MARIKI. Pukulɛ-kulɛ kɔ letər yɛcəmɛ! Iŋsak nu nəkɔ, afɔsɔcəmbərəs nu kəkɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kɔ Musa oloku firawona: «Kɔ indenawur dare-ɛ, indepɛnɛ waca wem nde MARIKI eyi mɔ. Pukulɛ-kulɛ pendenasakɛ, letər dɔfɔdenayi, tendesɔŋ'am kəcərɛ a doru dandɛ da MARIKI dɔ. ");
INSERT INTO bsp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mba incərɛ a məna kɔ amarəs am, nəfɔdesɔnesɛ MARIKI Kanu.» ");
INSERT INTO bsp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Akotan ŋɛnalɛŋk, pundu pokom letər dɛnasɔŋɛ yi kəlɛcɛ. ");
INSERT INTO bsp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mba mɛŋgbɛn mɔlɔma mɛnalɛcɛ fɛ, bawo mi moncwon kəkom, ti tɔ letər dɛnatɔləsərɛ mi. ");
INSERT INTO bsp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kɔ Musa owur ndena firawona kɔ dare disrɛ, kɔ Musa encencər MARIKI waca. Pukulɛ-kulɛ pa darenc kɔ letər yɛsakɛ, kɔ wəcafən ɛsak kətuf. ");
INSERT INTO bsp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ntɛ firawona ɛnəŋk wəcafən, kɔ letər yɛsak kətuf kɔ pukulɛ-kulɛ pa darenc pɛsakɛ mɔ, k'ɔŋgbɔkərɛ sɔ kəciya k'ɛntaŋ aləŋəs, nkɔn kɔ amarəs ɔn. ");
INSERT INTO bsp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kɔ firawona eyeŋk domp, ɛsak fɛ aka Yisrayel ŋakɔ, pəmɔ tɔkɔ MARIKI ɛnasɔŋɛ ti Musa kəloku mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kɔ MARIKI oloku Musa: «Məkɔ məbəp firawona, bawo in'endesɔŋɛ kɔ kətaŋ aləŋəs, nkɔn kɔ amarəs ɔn, ntɛ tɔsɔŋɛ imentər mɛgbɛkərɛ mɛwɛy-wɛy mem fɔr yaŋan kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ntɛ tendesɔŋ'am kəsɔtɔ tɔkɔ mənde məcloku awut am kɔ awut-sɔ am mɔ, mes mmɛ iyɔ aMisira, kɔ mɛgbɛkərɛ mɛwɛy-wɛy mmɛ iwurɛ ndaraŋan mɔ. Tendesɔŋ'on kəcərɛ a in'ɔyɔnɛ MARIKI.» ");
INSERT INTO bsp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa kɔ Aruna ŋaŋkɔ nde firawona eyi mɔ, kɔ ŋaloku kɔ: «Ntɛ tɔ MARIKI Kanu ka aHebəre kəloku: Ake tɛm tɔ məndesak kəfati kətontnɛn'em-ɛ? Məsak afum em ŋakɔsalɛn'em. ");
INSERT INTO bsp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kɔ məfati kəsak afum em ŋakɔ-ɛ, alna iŋkɛrɛ cəlaŋkəma atɔf ŋam. ");
INSERT INTO bsp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Cəndekump atɔf ŋam ali antɔf ta aŋnəŋk-ɛ. Ci cəndesɔm yɔbɔf yɛlpəs nyɛ letər dɛsak mɔ, cəndesɔm tɔk yonu yɔkɔ yeyi kəpoŋ nde dəkulum mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Cəndelas wɔlɔ wam, wɔlɔ wa amarəs am, kɔ wɔlɔ wa aka Misira fəp. Kəyɛfɛ awisi aŋa kəbəp ka atem am, ali wəkin ɛnəŋk fɛ towurɛnɛ ta ti haŋ mɔkɔ.» Kɔ Musa ɛmbɛr firawona kumunt, k'owur ndɔrɔn. ");
INSERT INTO bsp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kɔ amarəs a firawona ŋayif kɔ: «Ake tɛm tɔ fum wəkawɛ endesak kəyɔnɛ su towul-ɛ? Məsak afum aŋɛ ŋakɔsalɛnɛ MARIKI, Kanu kəŋan. Məntacərɛ fɛ a Misira meyi kəlɛcɛ ba?» ");
INSERT INTO bsp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","K'aŋkɔ sɔ pawe Musa kɔ Aruna, kɔ ŋander nnɔ firawona eyi mɔ. Kɔ firawona oloku ŋa: «Nəntam kəkɔsalɛnɛ MARIKI, Kanu konu. Mba are ŋaŋkɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Kɔ Musa oloku kɔ: «Səŋkɔ kɔ atɛmp asu, atem asu, səŋkɔ kɔ awut asu arkun kɔ ayecəra, səŋkɔ kɔ yɔcɔl yosu yɔpɔŋ kɔ yɛfɛt, bawo kəsata ka MARIKI kɔ nnɔ səna səyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Mba kɔ firawona oloku ŋa: «MARIKI pəmar nu kɔ pəyɔnɛ icsak nu nəkɔ nəna kɔ aran anu kɔ awut anu-ɛ! Tɔsɔk pɛs a nəyɔ mɛcɛm-cɛmnɛ mɛlɛc! ");
INSERT INTO bsp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tɛfaŋ tonu tɔfɔtam kəkɔt! Nəna arkun nəkɔ nəsalɛnɛ MARIKI, tatɔkɔ tɔ nəfaŋ!» K'ambɛləs ŋa firawona fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kɔ MARIKI oloku Musa: «Məcenc kəca atɔf ŋa Misira, ntɛ tɔŋsɔŋɛ cəlaŋkəma kəder mɔ, cəpɛ, cəsɔm yika ya dɔtɔf fəp kɔ yobuk yɛlpəs nyɛ letər dɛnasak atɔf ŋa Misira mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kɔ Musa encenc kəgbo kɔn atɔf ŋa Misira, kɔ MARIKI owurɛ afef kəyɛfɛ ka ntende dec dɛmpɛ mɔ, kɔ afef ŋowur Misira dɔsɔk dadɔkɔ fəp pibi kɔ pəwaŋkəra. Dec dendesɔk, afef ŋa ntende dec dɛmpɛ mɔ ŋɛŋkɛrɛ cəlaŋkəma. ");
INSERT INTO bsp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kɔ cəlaŋkəma cəmpɛ atɔf ŋa Misira fəp, kɔ cəndɛs-dɛs mofo fəp Misira disrɛ. Ntɛ tɔ doru doncop cəlaŋkəma cəntayi fɛ pəmɔ tatɔkɔ, cəfɔsɔyi pəmɔ ti. ");
INSERT INTO bsp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kɔ cəlaŋkəma cəŋkump antɔf ŋa Misira fəp, kɔ cəmbiyəsər antɔf. Kɔ cəsɔm yika ya dəntɔf fəp, kɔ yokom ya tɔk fəp, kɔ ca ncɛ letər dɛnasak mɔ fəp. Misira disrɛ fəp anasak fɛ ali pubuk pin pa kətɔk kɔ pəyɔnɛ fɛ ti-ɛ pa ayika ŋa dalɛ. ");
INSERT INTO bsp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kɔ firawona ɛmbɛlkər kəwe ka Musa kɔ Aruna. K'oloku ŋa: «Inciyanɛ MARIKI Kanu konu, k'inciyanɛ sɔ nəna. ");
INSERT INTO bsp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ndɛkəl oŋ ilɛtsɛn'am məŋaŋnɛn'em kiciya kem tɛlpəs tantɛ. Nətolan'em nnɔ MARIKI Kanu konu eyi mɔ, ntɛ tɔŋsɔŋɛ pəluks'em darəŋ defi dandɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kɔ Musa owur ndena firawona, k'ontola MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Kɔ MARIKI ɛŋkafəli afef ŋɔpɔŋ nŋɛ ŋɛnayɛfɛ kəca nkɛ dec dɛŋkalɛ mɔ, afef ŋaŋɔkɔ ŋɛnafɛlərɛnɛ cəlaŋkəma cacɔkɔ, kɔ ŋeŋkekərɛ nde kəba ka Cəŋkɔlma. Ali kəlaŋkma kin afef ŋaŋɔkɔ ŋɛnasak fɛ atɔf ŋa Misira fəp. ");
INSERT INTO bsp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mba kɔ MARIKI eyeŋkəs sɔ firawona domp, kɔ firawona ɛfati kəsak ka aka Yisrayel ŋakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kɔ MARIKI oloku Musa: «Məcenc kəca kam darenc, kubump kətor atɔf ŋa Misira, kubump ka kəwakəs.» ");
INSERT INTO bsp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kɔ Musa encenc kəca kɔn darenc, kɔ kubump ka kəwakəs kəntor atɔf ŋa Misira fəp haŋ mata maas. ");
INSERT INTO bsp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nwɛ o nwɛ ɛncnəŋk fɛ wəkɔ, ali fum ɛnctam fɛ kəyɛfɛ dəkiyi dɔn haŋ mata maas. Mba aka Yisrayel fəp ŋanayɔ pəwaŋkəra nde ŋanayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kɔ firawona ewe Musa k'oloku kɔ: «Nəkɔ nəsalɛnɛ MARIKI! Mba yɔcɔl yonu yɛfɛt kɔ yɔpɔŋ taŋ nəndesak yi nnɔ, awut anu afɛt afɛt kɔ aran anu, nəntam kəkekərɛ ŋa.» ");
INSERT INTO bsp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mba kɔ Musa oluksɛ kɔ: «Məna yati, mɛnɛ mədesɔŋ su yɔcɔl yɔlɔma nyɛ səndekɔloŋnɛnɛ kɔ yɔkɔ səndekɔcɔfɛ MARIKI Kanu kosu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ntɛ tendeŋərnɛ ti mɔ, səndekenɛnɛ yɔcɔl yosu ali kəgboro kin səfɔdesak, bawo yi yɔ səndekɔwurɛ dacɔ nyɛ səndekɔloŋnɛnɛ MARIKI Kanu kosu. Səntacərɛ fɛ kərɛsna mpɛ səŋkɔloŋnɛnɛ MARIKI mɔ, mɛnɛ səcbɛrɛ dəndo.» ");
INSERT INTO bsp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kɔ MARIKI eyeŋkəs sɔ firawona domp, firawona ɛnafaŋ fɛ sɔ kəsak aka Yisrayel ŋakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Kɔ firawona oloku Musa: «Məwur nnɔ nderem! Məkɛmbərnɛ ta inəŋk əm sɔ fɔr yem kiriŋ, dɔsɔk ndɛ o ndɛ mənder sɔ nnɔ mɔ, məŋfi dɔsɔk dadɔkɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Kɔ Musa oloku firawona: «Ntɛ məloku ti tatɔkɔ mɔ, awa! Ifɔsɔgbɔkərɛ kəder nnɔ fɔr yam kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kɔ MARIKI oloku Musa: «Pəcuy pin gboŋ p'indesɔdeŋər firawona, kɔ Misira. Kɔ tencepər-ɛ, endesak nu nəwur dɛ. K'endelip kəsak nu a nəkɔ-ɛ, endekɔ haŋ pəcbɛləs nu dɛ few. ");
INSERT INTO bsp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Məmɛŋkəs afum am, ilɛtsɛn'am, a wərkun nwɛ o nwɛ kɔ wəran nwɛ o nwɛ ŋawer andɛ aŋan ca ca gbeti kɔ kɛma.» ");
INSERT INTO bsp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kɔ MARIKI ɔsɔŋ aka Yisrayel kəmar ka kəbɔtər nde fɔr ya aka Misira kiriŋ. Musa sɔ yati fum ɛnayi nwɛ amarəs a firawona kɔ afum ŋanaleləs atɔf ŋa Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kɔ Musa oloku: Ntɛ tɔ MARIKI oloku: «Cɛkcɛkana, indenacepər Misira dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Awut acɔkɔ-cɔkɔ fəp ŋandenafi atɔf ŋa Misira, kəyɛfɛ coco ca firawona wəkakɔ ɛndɛ dɔcɔm dɔn dabɛ kəroŋ mɔ, haŋ kəkɔbəp coco ca wəmarəs kɔn wəran wəkɔ ɛŋgbɛntɛ kɔ kəcom mɔ, kəkɔ haŋ awut acɔkɔ-cɔkɔ fəp a yɔcɔl. ");
INSERT INTO bsp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kəbok kəpɔŋ kəndeyi Misira, kəbok nkɛ kəntatɔyi Misira, a kɔ kəntɔsɔyi dɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mba ndena aka Yisrayel, ali acen ŋɔfɔdekul-kulər di kəyɛfɛ fum, haŋ pɔcɔl, ntɛ tɔŋsɔŋɛ nəcərɛ tɔkɔ MARIKI ɛŋgbɛy kəyɔ aka Misira nnɔ aka Yisrayel ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Amarəs am fəp ŋandeder ŋatontnɛn'em ŋacloku: ‹Məna kɔ afum aŋɛ ŋancəm'am darəŋ mɔ fəp, nəkɔ!› Kɔ tencepər-ɛ, indewur atɔf ŋaŋɛ.» Kɔ Musa owur nda firawona, pətɛlɛ kɔ pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Awa kɔ MARIKI oloku Musa: «Firawona ɔfɔkɔcəŋkəl nu, ntɛ tɔŋsɔŋɛ mɛgbɛkərɛ mɛwɛy-wɛy mem mɛla atɔf ŋa Misira mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa kɔ Aruna ŋayɔ mɛgbɛkərɛ mɛwɛy-wɛy mmɛ fəp fɔr ya firawona kiriŋ. Kɔ MARIKI eyeŋkəs domp da firawona tuŋ, ɛsak fɛ aka Yisrayel ŋawur atɔf ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Kɔ MARIKI oloku Musa kɔ Aruna nde atɔf ŋa Misira: ");
INSERT INTO bsp_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Ŋof ŋaŋɛ ŋendeyɔnɛ nu oŋ ŋɔcɔkɔ-cɔkɔ ŋa yof. Ŋi ŋendeyɔnɛ nu ŋɔcɔkɔ-cɔkɔ ŋa teren. ");
INSERT INTO bsp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nəloku ti kəloŋkanɛ ka aka Yisrayel fəp, nəcloku ŋa: Tataka ta wəco ta ŋof ŋaŋɛ, wəkombəra o wəkombəra, kɔ pəyɔnɛ fɛ ti-ɛ, kəlɔ o kəlɔ ŋalɛk aŋkesiya ŋorkun ŋa teren tin, kɔ pəyɔnɛ fɛ ti-ɛ, ambiyofo. ");
INSERT INTO bsp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kɔ afum a kəlɔ ka wəkayi disrɛ ŋampicər pɔcɔl papɔkɔ-ɛ, wəkayi pəlɛkɛnɛ andɛ ɔn akɔ ŋalɔtərɛnɛ wɔlɔ mɔ, wəkayi pəmɔmən dɛlay da afum a kəlɔ kɔn. Nəyerəs pɔcɔl papɔkɔ, ntɛ nwɛ o nwɛ ɛntam kəsɔm mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Pɔyɔnɛ pɔcɔl porkun pa teren tin mpɛ pɔntɔyɔ dolokəp mɔ. Nəntam kəlɛk aŋkesiya ŋorkun ŋa teren tin, kɔ pəyɔnɛ fɛ ti-ɛ, ambiyofo. ");
INSERT INTO bsp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nəmɛŋk pi haŋ tataka ta wəco kɔ maŋkəlɛ ta ŋof ŋaŋɛ. Fitiri fa dɔsɔk dadɔkɔ, kəloŋkanɛ ka aka Yisrayel fəp ŋasurɛnɛ kəfayəs nwɛ o nwɛ pɔcɔl pɔkɔ ɛmɛŋkərnɛ kədif mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Palɛk mecir mamɔkɔ pasop mi cəsək kɔ takəroŋ ta fərɛm fa kusuŋka ka kəlɔ kəŋkɔ andesɔm sɛm yayɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Pakakəl sɛm yayɔkɔ pibi payi, pasɔmɛ sɛm yayɔkɔ cəcom cətɔyɔ lebin kɔ bɔpər yodokət. ");
INSERT INTO bsp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Afɔsɔm sɛm yayɔkɔ yogbulpun, kɔ pəyɔnɛ fɛ ti-ɛ, papɛcɛ yi domun de! Aŋkakəl yi kəkakəl dəm, kəyɛfɛ domp kəbəp ka cəgboro cayi, kəkɔ yedisrɛ ya pɔcɔl papɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ali tɛsɛm tin ta nəsak pa dɔckɔsɔk. Mba kɔ nəsak tɛsɛm tɔlɔma-ɛ, dɔckɔsɔk nəcɔf pi. ");
INSERT INTO bsp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ntɛ tɔ pəmar nəlompəsnɛ kəsɔm sɛm yayɔkɔ: Nəkotnɛ mabamaba dəfi, nəbɛrnɛ cɔfta, nətɔmpər mogbo dəwaca. Nəsɔm yi katəna katəna. Ti tendeyɔnɛ kəsata ka Kəcepər ka mɛlɛkɛ medif teta kəleləs ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pibi pampɛ pender mɔ, indecepər atɔf ŋa Misira disrɛ fəp, idifət awut acɔkɔ-cɔkɔ a atɔf ŋa Misira, kəyɛfɛ ka nnɔ afum ŋayi mɔ haŋ nnɔ yɔcɔl yeyi mɔ, kəbocər k'inder canu ca Misira kiti kəlel. In'ɔfɔ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mecir mamɔkɔ mendekɔyɔnɛ nu tɛgbɛkərɛ ta dəwɔlɔ nwɛ nəndekɔyi mɔ: K'indekɔ icnəŋk mecir-ɛ, indekɔ iccepər nu ta intorər nu pəlɛc mpɛ o mpɛ pɛŋmələk mɔ-ɛ, mpɛ indekɔ icsutɛ atɔf ŋa Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Dɔsɔk dadɔkɔ dendeyɔnɛ nu dɔsɔk dɛcɛm-cɛmnɛ, nədekɔ nəcbocɛ kəsata kaŋkɔ MARIKI. Nəde nəcboc kəsata kaŋkɔ nətɔmpərnɛ sariyɛ sasɔkɔ dɛtɛmp donu tɛm o tɛm.» ");
INSERT INTO bsp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Mata camət-mɛrəŋ disrɛ, nənde nəcsɔm cəcom cətɔyɔ lebin. Tataka tɔcɔkɔ-cɔkɔ, nəwurɛnɛ lebin nde wɔlɔ wonu, bawo nwɛ o nwɛ ɔŋsɔm kəcom kəyɔ lebin mɔ, kəyɛfɛ tataka tɔcɔkɔ-cɔkɔ haŋ tataka ta camət-mɛrəŋ ta kəsata kaŋkɛ, aŋwurɛ wəkayi afum aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tataka tɔcɔkɔ-cɔkɔ kɔ tataka ta camət-mɛrəŋ nəde nəwe kəloŋkanɛ kəsoku teta kəleləs ina MARIKI. Ali yɛbəc ta fum pəsumpər dɔsɔk dadɔkɔ mɛrəŋ, mɛnɛ yeri yonu yedi gbəcərəm yɔ nəŋlompəs dɔsɔk dadɔkɔ nyɛ nwɛ o nwɛ ɛntam kədi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Nəbocɛ kəsata ka Cəcom cətɔyɔ lebin, bawo dɔsɔk dadɔkɔ yati d'inawurɛnɛ afum anu atɔf ŋa Misira dəcor dəcor. Nəde nəcboc kəsata kaŋkɔ tɛm o tɛm dɛtɛmp kɔ dɛtɛmp. ");
INSERT INTO bsp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ŋof ŋɔcɔkɔ-cɔkɔ tataka ta wəco kɔ maŋkəlɛ (14) tayi dec dɔrɔfɔy, nəsɔm cəcom cətɔnɔŋkəl lebin haŋ tataka ta wəco mɛrəŋ kɔ tin (21) dec dɔrɔfɔy. ");
INSERT INTO bsp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mata camət-mɛrəŋ mmɛ disrɛ, pəmar fɛ pabəp lebin nde wɔlɔ wonu disrɛ. Nwɛ o nwɛ ɔŋsɔm kəcom kənɔŋkəl lebin mɔ, aŋwurɛ wəkayi kəloŋkanɛ ka aka Yisrayel dacɔ, pəyɔnɛ wəka Yisrayel, pəmɔ wəcikəra. ");
INSERT INTO bsp_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ta nəsɔm mpɛ o mpɛ pɔyɔ lebin mɔ. Cəcom cətɔnɔŋkəl lebin gbəcərəm cɔ nəntam kəsɔm, nnɔ o nnɔ nəndɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kɔ Musa ewe abeki a Yisrayel fəp, k'oloku ŋa: «Nəkɔ nəlɛk ŋkesiya, kɔ pəyɔnɛ fɛ ti-ɛ cir kəlɔ o kəlɔ pɔcɔl pin teta kəcepər ka mɛlɛkɛ medif, nəfayəs yi. Nəsu mɔbɔl mecir mamɔkɔ mɛbɛrɛ mi. ");
INSERT INTO bsp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nəlɛk sɔ lɛ ya hisɔp nəcgbət yi dəmecir ma poloŋnɛ mɔkɔ meyi dətɔbɔl mɔ, nəcsopət mi dəfərɛm fa cumba ca cusuŋka cəsək kɔ takəroŋ ta wɔlɔ wonu. Kɔ nəna dacɔ ali fum ta pəwur nde kəlɔ kɔn haŋ dec dɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ntɛ MARIKI endenanɔŋkər Misira kəcsutɛ ŋa pəlɛc mɔ, k'ɛnəŋk mecir mamɔkɔ nde fərɛm fa cusuŋka ca wɔlɔ wonu-ɛ, MARIKI encepər kəcepər dəm wɔlɔ wonu kəroŋ, ɔfɔsak wəmələk kɔ pəlɛc pɔn kəbɛrɛ wɔlɔ wonu. ");
INSERT INTO bsp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nəde nəmɛŋkərnɛ ti, tɔyɔnɛ oŋ sariyɛ sa məna kɔ yuruya yam doru o doru. ");
INSERT INTO bsp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kɔ nəndekɔ nde atɔf nŋɛ MARIKI endekɔsɔŋ nu mɔ, pəmɔ tɔkɔ oloku ti mɔ-ɛ, nədekɔ nəmɛŋkərnɛ tokor-koru tantɛ. ");
INSERT INTO bsp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kɔ awut anu ŋandekɔyif nu: ‹Cəke cɔ tɔyɔ tokur tantɛ toloku-ɛ?› ");
INSERT INTO bsp_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nəloku ŋa: ‹Kəloŋnɛ ka kəcɛm-cɛməs ntɛ MARIKI ɛnacepər wɔlɔ wa aka Yisrayel dəndo Misira ntɛ oncsutɛ Misira pəlɛc, pəcyay wɔlɔ wosu mɔ.›» K'aka Yisrayel ŋantontnɛnɛ MARIKI, kɔ ŋancəpɛ kɔ suwu. ");
INSERT INTO bsp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ntɛ tatɔkɔ tencepər mɔ, k'aka Yisrayel ŋasumpər dɔpɔ, kɔ ŋaŋkɔ. Kɔ ŋayɔ tatɔkɔ MARIKI ɛnasom Musa kɔ Aruna mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Cɛkcɛk cəndebəp, kɔ MARIKI endifət awut acɔkɔ-cɔkɔ fəp nde atɔf ŋa Misira, kəyɛfɛ ka wan ka firawona wəcɔkɔ-cɔkɔ nwɛ ɛnandɛ dɔcɔm dɔn dabɛ mɔ, haŋ wan wəcɔkɔ-cɔkɔ wəka fum nwɛ osumpər k'ɛmbɛr dəbili mɔ, kəbəp ka awut acɔkɔ-cɔkɔ a yɔcɔl fəp. ");
INSERT INTO bsp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kɔ firawona ɛyɛfɛ pibi, nkɔn kɔ amarəs ɔn, kəbəp ka aka Misira fəp, bawo kəlɔ kənayi fɛ nkɛ kənatɔyɔ wəfi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pibi disrɛ kɔ firawona ewe Musa kɔ Aruna, k'oloku ŋa: «Nəyɛfɛ nəwur afum em dacɔ, nəna k'aka Yisrayel fəp! Nəkɔ nəsalɛnɛ MARIKI pəmɔ tɔkɔ nəloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nəkenɛnɛ yɔcɔl yonu pəmɔ tɔkɔ nəloku ti mɔ. Nəkɔ! Nətolan'em sɔ!» ");
INSERT INTO bsp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Aka Misira ŋancbɛlkər aka Yisrayel kəwur ka dɔtɔf bawo ŋancloku: «Kəfi kɔ sənder fəp!» ");
INSERT INTO bsp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","K'aka Yisrayel ŋalɛkɛnɛ cəcom cəŋan ta lebin dɛntakəfəs ci-ɛ. Kɔ ŋaŋgbaŋəsnɛ yɔnɔktɛ yaŋan cəcom pafɔktər yi dəyamos yaŋan. ");
INSERT INTO bsp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","K'aka Yisrayel ŋayɔ tɔkɔ Musa ɛnaloku ŋa mɔ: Kɔ ŋantola aka Misira ca ca gbeti, ya kɛma, kɔ yamos. ");
INSERT INTO bsp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Kɔ MARIKI ɔsɔŋ aka Yisrayel kəmar ka kəbɔtər nde fɔr ya aka Misira, kɔ akakɔ ŋasɔŋ aka Yisrayel ca cəkɔ ŋanafaŋər ŋa mɔ. Ti disrɛ kɔ ŋafoŋət aka Misira. ");
INSERT INTO bsp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","K'aka Yisrayel ŋayɛfɛ Ramsɛs kəkɔ ka Sukɔt, kənay k'asɔdar kənatam kəyi arkun wul masar camət-tin (600.000) ta alɔm awut k'aran aŋan-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Acikəra alɔma ŋananɔŋkəlɛnɛ aka Yisrayel kəkɔ. Ŋasolɛnɛ yɔcɔl yɛfɛt kɔ yɔpɔŋ yaŋan yɛlarəm. ");
INSERT INTO bsp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kɔ ŋalompsɛ biskit bɔtɔnɔŋkəl lebin ambefe ŋɔkɔ ŋanayɛfɛnɛ Misira mɔ. Kəmbefe kaŋkɔ kənapɛ fɛ bawo ananɔŋkəl fɛ ki lebin. Ntɛ anabɛləs ŋa Misira mɔ, ŋanatam fɛ kəkar kəlompəsnɛ ŋadɛmnɛ yeri ya dɔpɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Kəndɛ ka aka Yisrayel Misira kənawon meren masar maŋkəlɛ kɔ wəco maas (430). ");
INSERT INTO bsp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Dɔsɔk ndɛ meren mmɛ masar maŋkəlɛ kɔ wəco maas (430) melip mɔ, dɔsɔk dadɔkɔ yati dɔ afum a MARIKI fəp ŋawur Misira dəcor dəcor. ");
INSERT INTO bsp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Pibi papɔkɔ camcam MARIKI ɛnacepərɛnɛ pi kəwurɛnɛ aka Yisrayel atɔf ŋa Misira, pəmar pibi papɔkɔ pɔyɔnɛ aka Yisrayel pɛmɛŋkərnɛ dɛtɛmp kɔ dɛtɛmp kətɔdirɛnɛ teta MARIKI, tendeyɔnɛ ŋa oŋ tɔyɔ taŋan tokur ta doru o doru. ");
INSERT INTO bsp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Kɔ MARIKI oloku Musa kɔ Aruna: «Ntɛ tɔ sariyɛ sa kəsata ka kəcɛm-cɛməs ka Kəcepər ka mɛlɛkɛ medif səloku: Ali wəcikəra ta pəde pəcdi yeri yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Wəcar nwɛ awayɛ pəsam mɔ, ɛntam kədi yeri yonu, kɔ pəyɔnɛ a aŋkənc kɔ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Amɔnɛ wəcikəra wəcepər kɔ wəbəc nwɛ aŋsɔŋ kəway mɔ kədi yi. ");
INSERT INTO bsp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Sɛm yayɔkɔ dɛkɛr aŋsɔm yi, afɔkekərɛ yi kəfo kəcuru, ali kəbɛnt kin ta papor-poru. ");
INSERT INTO bsp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kəloŋkanɛ ka aka Yisrayel fəp ŋamboc kəsata kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Məna wəcikəra nwɛ məfaŋ kəbocɛ MARIKI kəsata kaŋkɔ mɔ, mɛnɛ arkun a kəlɔ kɔn disrɛ fəp, pakənc ŋa. Wəkayi ɛntam kəlɔtərnɛ kəsata, pəyi kɔ pəmɔ wəka Yisrayel. Mba wətɔkənc nwɛ o nwɛ ɔfɔsɔm sɛm yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tɛtəksɛ tin tatɔkɔ t'amboncər wəYisrayel yati kɔ wəcikəra nwɛ eyi nu dacɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","K'aka Yisrayel ŋasurɛnɛ kəyɔ tɔkɔ MARIKI ɛnasom Musa kɔ Aruna mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Dɔsɔk dadɔkɔ dɔ MARIKI ɛnawurɛnɛ aka Yisrayel atɔf ŋa Misira, pəcɛk ŋa cəgba cəŋan dəcor dəcor. ");
INSERT INTO bsp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Nəpus'em awut acɔkɔ-cɔkɔ fəp, pəyɔnɛ aka afum, pəyɔnɛ aka yɔcɔl, nwɛ o nwɛ ɔyɔnɛ wan ka kɛrɛ wəcɔkɔ-cɔkɔ aka Yisrayel dacɔ, wəkemi ɔfɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kɔ Musa oloku afum: «Nəde nəccɛm-cɛmnɛ dɔsɔk ndɛ nəwur atɔf ŋa Misira, nde nənayɔnɛ acar mɔ, bawo sɔkət sa kəca ka nkɔn MARIKI sənawurɛnɛ nu di. Ti disrɛ ta pasɔm paka o paka pɔnɔŋkəl lebin. ");
INSERT INTO bsp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Nəŋwur mɔkɔ ŋof ŋa Abib. ");
INSERT INTO bsp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tɛm ntɛ MARIKI endekɔbɛrs'am atɔf ŋa Kanaŋ, nda aHit, nda Amɔr, nda aHiwy, nda aYebus, atɔf nŋɛ ŋomboŋ dalɛ k’awop mɔ, nŋɛ MARIKI ɛnadɛrmɛ atem anu kəsɔŋ əm mɔ, mədekɔ məcbocɛ MARIKI kəsata kaŋkɛ ŋof ŋaŋɛ. ");
INSERT INTO bsp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mata camət-mɛrəŋ məcsɔm kəcom cətɔnɔŋkəl lebin. Tataka ta camət-mɛrəŋ məbocɛ MARIKI kəsata. ");
INSERT INTO bsp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Cəcom cətɔnɔŋkəl lebin c'andekɔ pacsɔm mata mamɔkɔ camət-mɛrəŋ. Pəmar fɛ padekɔ pacnəŋk nda nwɛ o nwɛ daka o daka dɔnɔŋkəl lebin, pəmar fɛ yati padekɔ sɔ pacnəŋk ndaram lebin, atɔf ŋam disrɛ fəp.» ");
INSERT INTO bsp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«Dɔsɔk dadɔkɔ məde məloku wan kam ntɛ: ‹Teta tɔkɔ MARIKI ɛnayɔn'em ntɛ incwur Misira mɔ.› ");
INSERT INTO bsp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Tendeyɔnɛ nu tɛgbɛkərɛ kəca kam kəroŋ kɔ tɛcɛmcɛməs ta fɔr yam, tɔsɔŋɛ mɛtəksɛ ma MARIKI mey'əm dəkusu, bawo kəca ka sɔkət kɔ MARIKI ɛnawurɛn'am Misira. ");
INSERT INTO bsp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tataka tantɛ ombonc mɔ tɔ mənde məcboc oŋ kəsata kɔn, kəren o kəren.» ");
INSERT INTO bsp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Kɔ MARIKI endekɔbɛrs'am Kanaŋ, pəsɔŋ əm di, pəmɔ tɔkɔ ɛndɛrm'am ti kɔ atem am mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","məde məcsɔŋ nwɛ o nwɛ ɔyɔnɛ wan wərkun wəcɔkɔ-cɔkɔ wəka wəran, kɔ awut acɔkɔ-cɔkɔ a yɔcɔl yam. Arkun akɔ, MARIKI ɔyɔ ŋa. ");
INSERT INTO bsp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kɔ pəyɔnɛ a wan wəcɔkɔ-cɔkɔ wəka sɔfale ɔfɔ-ɛ, məwurusɛ si aŋkesiya, kɔ pəyɔnɛ fɛ ti-ɛ, ambiyofo. Kɔ məntɔwurus si-ɛ, mətepi sɔfale sasɔkɔ kilim. Məwurus sɔ awut arkun acɔkɔ-cɔkɔ a afum. ");
INSERT INTO bsp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Alna kɔ wan kam endeyif əm: ‹Cəke cɔ tantɛ toloku-ɛ?›, məloku kɔ: ‹Sɔkət sa kəca sɔ MARIKI ɛnawurɛnɛ su Misira, nde atɔf nŋɛ sənayɔnɛ acar mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ntɛ firawona ɛncfati kəsak su səkɔ mɔ, kɔ MARIKI endifət awut acɔkɔ-cɔkɔ fəp atɔf ŋa Misira, kəyɛfɛ ka awut acɔkɔ-cɔkɔ a afum haŋ awut acɔkɔ-cɔkɔ a yɔcɔl. Ti tɔsɔŋɛ ntɛ iŋloŋnɛnɛ MARIKI pɔcɔl porkun mpɛ o mpɛ pɔyɔnɛ pɔcɔkɔ-cɔkɔ pa kɛrɛ ka pi mɔ, icwurus awut em arkun acɔkɔ-cɔkɔ.› ");
INSERT INTO bsp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Tendeyɔn'am tɛgbɛkərɛ kəca kam kəroŋ kɔ tafəc mpɛ aŋkot əm dətobu fɔr yam dacɔ mɔ, bawo sɔkət sa kəca sɔ MARIKI ɛnawurɛnɛ su Misira.» ");
INSERT INTO bsp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ntɛ firawona ɛsak aka Yisrayel ŋakɔ mɔ, Kanu kəsolnɛnɛ fɛ ŋa dɔpɔ da atɔf ŋa aFilisti, ali ntɛ pənayɔnɛ a dɔpɔ dadɔkɔ dɔlɔtərnɛ mɔ. Bawo Kanu kənalokunɛ: «K'aka Yisrayel ŋanəŋk kəwan-ɛ, ŋaŋaŋnɛ tɛlər kəwur kəŋan Misira, tɔsɔŋɛ ŋa sɔ kəluksərnɛ di.» ");
INSERT INTO bsp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kɔ Kanu kənɔŋkərɛnɛ aka Yisrayel kəca ka dɔpɔ da dətɛgbərɛ, ntende kəba ka Cəŋkɔlma. Aka Yisrayel ŋanawur atɔf ŋa Misira ŋalompəsnɛ cəkəwan. ");
INSERT INTO bsp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Kɔ Musa ɛlɛkɛnɛ bɛnt ya Isifu, bawo Isifu ɛnasɔŋɛ awut a Yisrayel kədɛrəm, pəcloku: «Kɔ Kanu kəndemar nu-ɛ, nənde nəmitɛnɛ bɛnt yem, nəkekərɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","K'aka Yisrayel ŋayɛfɛ Sukɔt, kɔ ŋaŋkɔ ŋacəmbər saŋka səŋan Etam, ntende tɛgbərɛ dəkusu. ");
INSERT INTO bsp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","MARIKI ɔnckɔt kɔ ŋa, daŋ pəkɔtɛnɛ ŋa kɔ acul ŋa kəp ntɛ tɔŋsɔŋɛ ŋa kəsolnɛ dɔpɔ mɔ, kɔ pibi pəmot pa acul ŋa nɛnc pɔsɔŋ ŋa pəwaŋkəra, tɔŋsɔŋɛ ŋa kətam kəkɔt daŋ kɔ pibi. ");
INSERT INTO bsp_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Acul ŋa kəp ŋencliŋnɛ fɛ aka Yisrayel fɔr kiriŋ daŋ, acul ŋa pəmot pa nɛnc ŋencliŋnɛ fɛ ŋa sɔ fɔr kiriŋ pibi. ");
INSERT INTO bsp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Məloku aka Yisrayel a ŋaluksərnɛ ŋader ŋacəmbər saŋka səŋan nde Pi Hirɔt tekiriŋ, Mikədɔl kɔ kəba dacɔ, ŋatɛfərnɛ Bal Cefɔŋ. Kəfo kaŋkɔ tekiriŋ kɔ nəŋkɔcəmbər saŋka kəba kəsək. ");
INSERT INTO bsp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firawona ɔŋkɔ pəclokɛ aYisrayel: ‹Kəyara-yara kɔ ŋandɛ dɔtɔf, pənciyanɛ ŋa, tɛgbərɛ tendi ŋa!› ");
INSERT INTO bsp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Indeyeŋkəs firawona domp, endecəmɛ ŋa darəŋ kəbɛləs. Ti disrɛ, indesɔtɔ kəyek-yekəs dəmɔyɔ mmɛ indeyɔ firawona kɔ asɔdar ɔn fəp mɔ, aka Misira ŋandecərɛ a in'ɔyɔnɛ MARIKI.» K'aka Yisrayel ŋayɔ ti. ");
INSERT INTO bsp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","K'aŋkɔ paloku wəbɛ wəMisira a aka Yisrayel ŋayɛksɛ. K'abəkəc ŋa firawona kɔ amarəs ɔn yɛŋkafəlɛ sɔ teta aka Yisrayel. Kɔ ŋayifnɛ: «Cəke cɔ sənayɔ tantɛ kəsak aka Yisrayel ŋakɔ-ɛ? Səŋgbal abəcɛ asu!» ");
INSERT INTO bsp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kɔ firawona osom a pasektər abil ŋɔn ŋa dəkəwan, k'osolɛ asɔdar ɔn kɔ ŋaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kɔ firawona ɛlɛk cibil ca dəkəwan cətɔt masar camət-tin (600), kɔ cibil ca dəkəwan ca Misira cəlpəs, abɛ asɔdar ŋanayi ci kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Kɔ MARIKI eyeŋkəs domp da firawona wəbɛ ka Misira: k'ɛncəmɛ aka Yisrayel darəŋ kəbɛləs, mba aka Yisrayel ŋanaŋɛc səbomp kəwur atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","K'aka Misira ŋancəmɛ aka Yisrayel darəŋ kəbɛləs: Fəlɛs ya firawona fəp kɔ cibil cɔn ca dəkəwan, kəbəp ka ayɛksɛnɛ ɔn fəlɛs, kəkɔ ka asɔdar ɔn, kɔ ŋaŋkɔ ŋabəp aka Yisrayel nde Pi Hirɔt ntende kəba kəsək nde ŋanacəmbər saŋka ŋatɛfərɛnɛ Bal Cefɔŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ntɛ firawona ɔnclɔtərnɛ mɔ, aka Yisrayel ŋandeyekti fɔr, apayo! kɔ ŋanəŋk aka Misira ŋancəmɛ ŋa darəŋ kəbɛləs. K'aka Yisrayel ŋanesɛ pəpɔŋ, kɔ ŋaŋkulɛ-kulɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","K'aka Yisrayel ŋaloku Musa: «Cufu cəla fɛ Misira ntɛ məŋkɛrɛ su kədedif nnɔ dətɛgbərɛ mɔ ba? Cəke cɔ məŋyɔ su tantɛ-ɛ, məwurɛnɛ su Misira mɔ?» ");
INSERT INTO bsp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Bafɔ sənalok'əm Misira: «Məce su səbəcɛ aka Misira, bawo kəbəcɛ ka aMisira kəncepər su kəfi nnɔ dətɛgbərɛ!» ");
INSERT INTO bsp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Kɔ Musa oloku aka Yisrayel: «Ta nənesɛ, nəcəmɛ gbiŋ, nəgbətnɛ ntɛ MARIKI endeyac nu mɔkɔ mɔ, bawo aka Misira akaŋɛ nəŋgbətnɛ mɔkɔ mɔ, nəfɔsɔnəŋk ŋa few. ");
INSERT INTO bsp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","MARIKI endesutnɛnɛ nu, kɔ nəna, nəndɛ nəcaŋk.» ");
INSERT INTO bsp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kɔ MARIKI oloku Musa: «Ta ake tɔ məŋkul-kulɛn'em-ɛ? Məloku aka Yisrayel ŋasolnɛ dɔpɔ daŋan darəŋ tuŋ kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Kɔ məna Musa məyekti kəgbo kam, məcenc ki dəkəba, məgberi ki. Aka Yisrayel ŋakɔt kəba disrɛ antɔf ŋowosu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kɔ ina MARIKI, kəyeŋkəs k'inder səbomp s'aka Misira, ntɛ tɔŋsɔŋɛ ŋacəmɛ nu darəŋ kəbɛləs mɔ. Difɔ indeyek-yekəsnɛnɛ kələsər firawona, asɔdar ɔn fəp, cibil cɔn ca dəkəwan, k'ayɛksɛnɛ a ci. ");
INSERT INTO bsp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tɛm tatɔkɔ, aka Misira ŋandecərɛ a in'ɔyɔnɛ MARIKI, k'indeyek-yekəsnɛnɛ firawona, kɔ cibil cɔn ca dəkəwan k'ayɛksɛnɛ ɔn fəlɛs.» ");
INSERT INTO bsp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mɛlɛkɛ ma Kanu mmɛ mencyi asɔdar aka Yisrayel tekiriŋ mɔ, mɔŋkɔ mɛcəmɛ asɔdar aka Yisrayel tadarəŋ, acul ŋa kəp nŋɛ ŋencyi ŋa tekiriŋ mɔ, ŋi sɔ kɔ ŋɔŋkɔ ŋa tadarəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","K'acul ŋa kəp ŋɔŋkɔ ŋeyi asɔdar aka Yisrayel k'asɔdar aka Misira dacɔ. Acul ŋa kəp nŋɛ ŋɔncsɔŋ pibi kəsək k'aka Misira, kəsək ka mɛrəŋ ŋɔcsɔŋ aka Yisrayel pəwaŋkəra pibi disrɛ. Pibi papɔkɔ disrɛ fəp, aka Yisrayel kɔ aka Misira ŋanalɔtərɛnɛ fɛ. ");
INSERT INTO bsp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kɔ Musa entenci kəca kɔn dəkəba, kɔ MARIKI owurɛ afef ŋɔpɔŋ nŋɛ ŋɛncyɛfɛ kəca nkɛ dec dɛmpɛ mɔ. Kɔ ŋɛwɛn pibi papɔkɔ fəp domun da dəkəba kɔ ŋowosəs kəba, kɔ domun dɛgbɛyɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","K'aka Yisrayel ŋantor dəkəba antɔf ŋowosu, kɔ domun deyi kəca kətɔt kɔ kəmeriya pəmɔ biŋkəli. ");
INSERT INTO bsp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","K'aka Misira ŋancəmɛ aka Yisrayel darəŋ kəbɛləs kəyɛfɛ fəlɛs ya firawona kəbəp cibil cɔn ca dəkəwan, kəkɔ ka ayɛksɛnɛ ɔn fəlɛs, fəp faŋan kɔ ŋantor dəkəba. ");
INSERT INTO bsp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Dɔsɔka dɛləpəs kɔ MARIKI ontorɛ fɔr, k'ɔmɔmən asɔdar aka Misira pəyi acul ŋa nɛnc kɔ ŋa kəp disrɛ, k'osutɛ asɔdar aka Misira pəyamayama. ");
INSERT INTO bsp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kɔ MARIKI ɛyamsər səntef sa cibil ca dəkəwan ca aka Misira kəkafəlɛ belbel, kɔ tɔsɔŋɛ ci kəyɛlnɛ kəkɔt. K'aka Misira ŋaloku: «Payɛksɛ pamulpər aka Yisrayel, bawo MARIKI eyi kəsutnɛnɛ ŋa nnɔ aka Misira ŋayi mɔ!» ");
INSERT INTO bsp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kɔ MARIKI oloku Musa: «Məcenc kəca kam dəkəba, domun dɛgbəpərnɛ aka Misira, kəyɛfɛ ka cibil cəŋan ca dəkəwan kəbəp ka ayɛksɛnɛ fəlɛs aŋan.» ");
INSERT INTO bsp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kɔ Musa encenc kəca kɔn dəkəba, dɔsɔka dɛləpəs kɔ kəba kəluksərnɛ tɔkɔ kənayi mɔ. Aka Misira ŋanayi kəyɛksər kəba, mba kɔ MARIKI ɛŋgbəpər ŋa domun. ");
INSERT INTO bsp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kɔ domun dender kɔ dɛŋgbəpərnɛ cibil cəŋan ca dəkəwan, kɔ ayɛksɛnɛ fəlɛs kɔ asɔdar a firawona fəp, aŋɛ ŋanator dəkəba kəcɛpsɛ ka aka Yisrayel mɔ. Ali wəkin ɛnamulpɛ fɛ. ");
INSERT INTO bsp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mba aka Yisrayel ŋa ŋackɔt kəba disrɛ antɔf ŋowos fər. Domun deyi ŋa kəca kətɔt kɔ kəmeriya pəmɔ biŋkəli. ");
INSERT INTO bsp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Dɔsɔk dadɔkɔ dɔ MARIKI ɛnabaŋ aka Yisrayel aMisira dəwaca. K'aka Yisrayel ŋanəŋk aka Misira ŋafis-fis daparpara. ");
INSERT INTO bsp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","K'aka Yisrayel ŋanəŋk fənɔntər nfɛ MARIKI ɛnasutɛ aka Misira mɔ. K'aka Yisrayel ŋanesɛ MARIKI, kɔ ŋalaŋ MARIKI kɔ Musa wəmarəs kɔn. ");
INSERT INTO bsp_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ntɛ tencepər mɔ, Musa k'aka Yisrayel ŋaleŋsɛ MARIKI teleŋ ntɛ: «Indeleŋsɛ MARIKI bawo ɛnamentər debeki da kətam kɔn: Ɛŋgbal afəlɛs kɔ wəyɛksɛnɛ ka ŋi dəkəba. ");
INSERT INTO bsp_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","MARIKI ɔyɔnɛ sɔkət sem kɔ teleŋ tem, Nkɔn ɔyɔnɛ wəyac kem. Kanu kem kɔ, indeyek-yekəs kɔ. Kanu ka papa kem kɔ, indekor-koru debeki dɔn. ");
INSERT INTO bsp_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","MARIKI korgba kɔ! Tewe tɔn tɔyɔnɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ɛləm dəkəba cibil ca dəkəwan ca firawona kɔ kənay kɔn k'asɔdar. Asɔdar abaŋsɛ aMisira, anakal ŋa nde kəba ka Cəŋkɔlma. ");
INSERT INTO bsp_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kɔ putukum pa kəba pɛŋgbəpərnɛ ŋa, kɔ ŋantor kəba dəntɔf pəmɔ masar. ");
INSERT INTO bsp_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Kəca kam kətɔt, MARIKI, kəyɔ fənɔntər fəwɛy-wɛy! Kəca kam kətɔt, MARIKI, kəmputuk wəterɛnɛ kam. ");
INSERT INTO bsp_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Debeki da dɛbɛ dam dɔsɔŋɛ kəyɛt aŋɛ ŋancəm'am dɛbəkəc mɔ. Kɔ məwurɛ mɛtɛlɛ mam-ɛ: Mendi ŋa pəmɔ ntɛ nɛnc dendi tuktukur ya mɛmpəlɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kifir k'aloləm ŋam gbəcərəm kəsɔŋɛ domun da dəkəba kəgbɛyɛnɛ, kɔ yam yɛncəmɛ pəmɔ biŋkəli, kɔ domun da kəba dəntɔf dɛncəp. ");
INSERT INTO bsp_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Wəterɛnɛ kosu oncloku: ‹Kəbɛləs ŋa k'inder, isumpər ŋa! Ibaŋər ŋa ca cəŋan pəmɔ tɔkɔ pəncepərər kəbɔt im mɔ. Kəwurɛ k'inder dakma, iməlkɛ ŋa kəca kem!› ");
INSERT INTO bsp_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kɔ məfurup, kɔ kəba kəŋkal ŋa, kɔ ŋaŋkalɛ pəmɔ ntɛ tomunt pegbəleŋ pontor domun da dəkəba dɛwɛy-wɛy disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Canu cəyi fɛ ncɛ cəntəŋnɛnɛ kɔ məna MARIKI mɔ! An'eyi pəmɔ məna, dosoku dam dɛmbɛk, dɔyɔ wɛywɛy, nwɛ pəmar a pakor-koru mɔ, məna nwɛ məŋyɔ mes mmɛ moŋwosəs kusu mɔ? ");
INSERT INTO bsp_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Məntenci kəca kam kətɔt gbəcərəm, kɔ antɔf ŋendi ŋa. ");
INSERT INTO bsp_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Kəsektərnɛ kam danapa kɔ məŋkɔtɛnɛ afum am akaŋɛ mənawurus mɔ, fənɔntər fam fɔ məndesolɛ ŋa, məliŋərnɛ ŋa nde dəkiyi dam dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ntɛ andɛ asu ŋane ti mɔ, kɔ ŋayikcɛ. Kɔ kənesɛ kəpɔŋ kəsumpər afum aka Filisti. ");
INSERT INTO bsp_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ayekyek ŋosumpər abɛ a atɔf ŋa Edɔm, kɔ kəyikcɛ kəsumpər afum akiriŋ a Mohab, kɔ bəkəc yɛlɛcɛ-lɛcɛ aka Kanaŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kənesɛ kɔ ayekyek ŋontorər ŋa. Debeki da kəca kam, dɛnasɔŋɛ ŋa kəcaŋk pəmɔ tasar haŋ afum am ŋaclip kəcepər, MARIKI, haŋ afum aŋɛ mənaway mɔ ŋaclip kəcepər. ");
INSERT INTO bsp_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Məde məkekərɛ ŋa məkɔ mədəs nde tɔrɔ kəroŋ mpɛ məsɔŋ ŋa kɛ mɔ, kəfo kaŋkɔ mənalompəs dəkiyi dam mɔ, MARIKI, dəndo kəfo kəsoku kaŋkɔ mənacəmbərɛ, Mariki, waca wam mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","MARIKI ɔntɔmpər dɛbɛ doru o doru. ");
INSERT INTO bsp_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Bawo fəlɛs ya firawona kɔ cibil cɔn ca dəkəwan kɔ ayɛksɛnɛ fəlɛs ɔn ŋantɛmpɛnɛ dəkəba. Kɔ MARIKI ɛŋgbəpər ŋa domun da dəkəba, mba aYisrayel ŋaŋkɔt antɔf ŋowosu kəba dacɔ, wɛcək waŋan wowos fər.» ");
INSERT INTO bsp_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kɔ sayibɛ Miriyam, wəkirɛ ka Aruna ɛlɛk tamba, kɔ aran aYisrayel fəp ŋancəmɛ kɔ darəŋ, ŋacpisɛ ŋacfer mamba. ");
INSERT INTO bsp_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Kɔ Miriyam oluksɛ ŋa: «Nəleŋsɛ MARIKI, bawo ɛnamentər debeki da kətam kɔn. Ɛləm dəkəba afəlɛs kɔ wəyɛksɛnɛ ka ŋi.» ");
INSERT INTO bsp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kɔ Musa ɔsɔŋɛ aka Yisrayel kəyɛfɛ kəba ka Cəŋkɔlma, k'osolnɛnɛ ŋa dɔpɔ da tɛgbərɛ ta Sur. Kɔ ŋaŋkɔt mata maas dətɛgbərɛ, ŋasɔtɔ fɛ domun. ");
INSERT INTO bsp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kɔ ŋambɛrɛ Mara, mba ŋanatam fɛ kəmun domun da Mara, bawo dɛnadoktɛ. Ti tɔ awenɛ di tewe ta Mara «pədokət». ");
INSERT INTO bsp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","K'aka Yisrayel ŋancop kəcɔpɛnɛ-cɔpɛnɛ nnɔ Musa eyi mɔ, ŋacloku: «Ake andemun-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Kɔ Musa oŋkornɛ MARIKI, kɔ MARIKI ementər kɔ kətɔk nkɛ ɛnaləm dəromun mɔ, kɔ domun dadɔkɔ dɔyɔnɛ dobotu. Difɔ MARIKI ɛnasɔŋ aka Yisrayel sariyɛ kɔ tɔyɔ tokur tɔkɔ ŋande ŋacyɔ doru o doru mɔ. Dəndo MARIKI ɛnawakəs kəlaŋ kəŋan. ");
INSERT INTO bsp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kɔ Musa oloku: «Kɔ məncəŋkəl belbel dim da MARIKI Kanu kam, kɔ məyɔ ntɛ tentesɛ MARIKI fɔr kiriŋ mɔ, məsu ləŋəs məcəŋkəl mosom mɔn kɔ məmɛŋkərnɛ sariyɛ sɔn fəp-ɛ, ali docu din ifɔsɔŋ əm ndɛ isɔŋ aka Misira mɔ. In'ɔfɔ MARIKI, nwɛ ɛntaməs əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","K'aka Yisrayel ŋaŋkɔ ŋabɛrɛ Elim nde cələmp wəco kɔ mɛrəŋ (12) cənayi kɔ komp wəco camət-mɛrəŋ (70) mɔ. Kɔ ŋacəmbər saŋka səŋan dəndo domun kəsək. ");
INSERT INTO bsp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kɔ kəloŋkanɛ ka aka Yisrayel fəp kəyɛfɛ Elim kɔ ŋaŋkɔ ŋabɛrɛ tɛgbərɛ ta Sin, mpɛ pəyi Elim kɔ Sinayi dacɔ mɔ, tataka ta wəco kɔ kəcamət ta ŋof ŋa mɛrəŋ nŋɛ ŋayɛfɛ Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Awa kɔ kəloŋkanɛ ka aka Yisrayel fəp ŋancop kəcɔpɛnɛ-cɔpɛnɛ dəndo dətɛgbərɛ nnɔ Musa kɔ Aruna ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kɔ aka Yisrayel ŋaloku ŋa: «Ah! Ali MARIKI ɛnadiftɛ su kəca kɔn Misira, ntɛ sənandɛ carɔrɔ ca sɛm kəsək mɔ, ntɛ səncsɔm cəcom haŋ sənɛmbərɛ mɔ! Kədiftɛ ka kəloŋkanɛ kaŋkɛ fəp dor kɔ nəwurɛnɛ su kədesak tɛgbərɛ tantɛ!» ");
INSERT INTO bsp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kɔ MARIKI oloku Musa: «Kətufər nu k'inder cəcom kəyɛfɛ ka darenc. Afum ŋande ŋacwur ŋacwɛtəs dɔsɔk o dɔsɔk ncɛ ŋantam kəsɔm dɔsɔk mɔ, tɛm tatɔkɔ indewakəs ŋa icərɛ kɔ pəyɔnɛ ŋancəmɛ mɛtəksɛ mem darəŋ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Tataka ta camət-tin, kɔ ŋandelompəs yɔkɔ ŋawɛtəs mɔ, nəndesɔtɔ kəmɛrəŋ ka yeri ya dɔsɔk o dɔsɔk.» ");
INSERT INTO bsp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa kɔ Aruna ŋaloku aka Yisrayel fəp: «Dɔfɔyana, nəndenacərɛ a MARIKI ɛnawurɛnɛ nu atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Bətbətana, nəndenanəŋk nɔrɔ da debeki da MARIKI, bawo ene kəcɔpɛnɛ konu nnɔ nkɔn MARIKI eyi mɔ. Kɔ səna, ake səyɔnɛ ntɛ nəndecɔpɛnɛ nnɔ səyi mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kɔ Musa oloku: «MARIKI endenasɔŋ nu mɔkɔ dɔfɔy sɛm yɔsɔm, bətbətana cəcom ncɛ nəndesɔm haŋ nənɛmbərɛ mɔ. Kɔ MARIKI ene kəcɔpɛnɛ nkɛ nəncɔpɛnɛ nnɔ eyi mɔ. Kɔ səna ake səyɔnɛ-ɛ? Bafɔ nnɔ səyi mɔ nəncɔpɛnɛ, mba nnɔ MARIKI eyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kɔ Musa oloku Aruna: «Məloku kəloŋkanɛ ka aka Yisrayel: Nəder nəlɔtərnɛ MARIKI fɔr kiriŋ, bawo ene kəcɔpɛnɛ konu.» ");
INSERT INTO bsp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aruna eyi kəlok-lokər kəloŋkanɛ ka aka Yisrayel fəp, ŋandekafəli fɔr kəca ka ntende dətɛgbərɛ, kɔ ŋanəŋk nɔrɔ da debeki da MARIKI dowur kəp disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Ine kəcɔpɛnɛ ka aka Yisrayel. Məloku ŋa ntɛ: Dɔfɔyana sɛm yɔ nəndenasɔm, bətbətana cəcom cɔ nəndenanɛmbərɛ. Ti disrɛ nəndecərɛ a in'ɔyɔnɛ MARIKI, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Pəndeyi dɔfɔy, kɔ bɛmp yender yɛfəntərɛ yokump saŋka. Dec dendesɔk kɔ kibi kəfəntərɛ antɔf mofo fəp mmɛ mɛŋkɛl saŋka mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ntɛ kibi kəndeliŋnɛ dəntɔf mɔ, kɔ pəyi antɔf ŋa tɛgbərɛ kəroŋ pəmɔ ca ncɛ yowurɛ mɛŋgbɛn mɔ, ca cacɔkɔ yeferɛ pəmɔ ntɛ ancɛ malɔ mɔsɔkər antɔf kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","K'aka Yisrayel ŋamɔmən kɔ ŋayifɛnɛ: «Ake dɔ dandɛ-ɛ?» bawo ŋanacərɛ fɛ daka ndɛ dɛnayi mɔ. Kɔ Musa oloku ŋa: «Yeri yɔ nyɛ MARIKI ɔsɔŋ nu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ntɛ tɔ MARIKI osom: Nəwɛtəs nwɛ o nwɛ, yeri nyɛ yɛntam kətəŋnɛ kɔ mɔ. Nwɛ o nwɛ pəwɛt litɛr mɛrəŋ da fum wəkin, kəlɔm ka tɔkɔ nəyi dəcəbal mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","K'aka Yisrayel ŋayɔ tatɔkɔ Musa ɛnaloku ŋa mɔ, k'alɔma ŋancepərər kəlɔm, k'alɔma ŋantɔbəp kəlɔm. ");
INSERT INTO bsp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mba ntɛ anatubuc mɔ, nwɛ ɛnawɛt pəcepərər kəlɔm mɔ, ombut tɔkɔ ɛnacepərər mɔ. Kɔ wəkɔ ɛnawɛt pəpic mɔ, ɔŋsɔtɔ kəlɔm kəŋkɔ pənamar mɔ. Kɔ nwɛ o nwɛ ɛwɛtəs yeri nyɛ ŋɛnatam kətəŋnɛ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kɔ Musa oloku ŋa: «Ali fum ta pəfənərnɛ yeri ya dɔckɔsɔk.» ");
INSERT INTO bsp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mba ŋanacəŋkəl fɛ Musa, k'afum alɔma ŋafənərnɛ yeri ya dɔckɔsɔk. Pəndeyi bətbət kɔ yeri yayɔkɔ yɛmbɛrɛ yɛt, kɔ yɛsɛn. Kɔ pəntɛlɛ Musa nnɔ afum akakɔ ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Bətbət o bətbət, nwɛ o nwɛ ɛncwɛt yeri yɔkɔ yɛnctəŋnɛ kɔ kədi ka dɔsɔk dadɔkɔ mɔ, kɔ nne yɔnckɔnawonɛ-ɛ, yɛsəŋgbər. ");
INSERT INTO bsp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Tataka ta camət-tin, kɔ nwɛ o nwɛ ɛwɛt potubuc pa mata mɛrəŋ, litɛr maŋkəlɛ da fum wəkin. K'akiriŋ a kəloŋkanɛ ka aka Yisrayel ŋaŋkɔ ŋaluksɛ ti Musa. ");
INSERT INTO bsp_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kɔ Musa oloku ŋa: «Ti tɔ MARIKI oloku. Alna dɔsɔk da kəŋesəm dɔ, ndɛ ampusɛ MARIKI mɔ. Nəpɛc yɔkɔ pəmar nu kəpɛc tɔkɔ nəfaŋ mɔ, yecernɛ yɔkɔ fəp, nəmɛŋkərnɛ yi haŋ bətbətana.» ");
INSERT INTO bsp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kɔ ŋamɛŋk yeri yayɔkɔ haŋ bətbət pəmɔ tɔkɔ Musa ɛnasom ŋa ti mɔ. Yeri yayɔkɔ ŋanamɛŋk mɔ, yɛt yɛnabɛrɛ fɛ yi, yɛnasɛn fɛ sɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kɔ Musa oloku ŋa: «Nədi yeri yayɛ mɔkɔ, bawo dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ deyi mɔkɔ, nəfɔsɔtɔ mɔkɔ yeri yɛwɛtəs dalɛ. ");
INSERT INTO bsp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mata camət-tin disrɛ nəntam kəwɛtəs yeri, mba simiti tataka ta camət-mɛrəŋ yeri yɛwɛtəs yɔfɔyi.» ");
INSERT INTO bsp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tataka ta camət-mɛrəŋ, kɔ afum alɔma ŋawur kəkɔwɛtəs yeri, mba ŋanasɔtɔ fɛ. ");
INSERT INTO bsp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kɔ MARIKI eyif Musa: «Haŋ tɛm tere tɔ nəndesak kəcfati kəmɛŋkərnɛ mosom kɔ mɛtəksɛ mem-ɛ? ");
INSERT INTO bsp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nəmɔmən! Kɔ MARIKI ɔsɔŋ nu simiti dɔsɔk da kəŋesəm-ɛ, pəsɔŋ nu sɔ tataka ta camət-tin yeri yɔkɔ pəmar nu kədi mata mɛrəŋ mɔ. Nwɛ o nwɛ pəmar pəndɛ kəfo nkɛ eyi mɔ, ta nwɛ o nwɛ pəwur ndɔrɔn tataka ta camət-mɛrəŋ dɔsɔk ndɛ ampusɛ MARIKI mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ntɛ tɔ, k'aka Yisrayel ŋaŋesəm simiti tataka ta camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","K'aka Yisrayel ŋawe yeri yayɔkɔ «man». Yeri yayɔkɔ yɛnawurɛnɛ mɛŋgbɛn ma yika yɔlɔma, meferɛ, meyi dəkusu pəmɔ ntɛ kəcom kəŋyɔ mɛsɛ ma cəme mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kɔ Musa oloku: «Ntɛ tɔ MARIKI osom: Nəlas kəfala ka litɛr mɛrəŋ katin yeri ya man, nəmɛŋkɛ yi awut-sɔ anu, ntɛ tɔŋsɔŋɛ ŋade ŋanəŋk cəcom ncɛ iŋsɔŋ nu nəcdi nnɔ dətɛgbərɛ ntɛ iwurɛn'on atɔf ŋa Misira mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kɔ Musa oloku Aruna: «Məlɛk tɔndɛ məbɛr pi yeri ya man litɛr mɛrəŋ. Məkɔ məcəmbər pi nde MARIKI fɔr kiriŋ, ntɛ tɔŋsɔŋɛ pamɛŋkɛ yi oŋ dɛtɛmp da awut-sɔ anu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Pəmɔ tatɔkɔ MARIKI ɛnasom ti Musa mɔ, kɔ Aruna ɛlas tɔndɛ k'ɔŋkɔ pəcəmbər pi kiriŋ nde walakɛ nwɛ wementər danapa dɔn, ntɛ tɔŋsɔŋɛ pamɛŋk yi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","K'aka Yisrayel ŋandi man meren wəco maŋkəlɛ (40) haŋ tɛm ntɛ ŋanader atɔf nŋɛ afum ŋanandɛ mɔ. Ŋanadi man haŋ kəren nkɛ ŋanader nde kələncər ka atɔf ŋa Kanaŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Wəco wa potubucɛ pa omɛr pɔncyɔ potubucɛ pa efah katin. ");
INSERT INTO bsp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kɔ kəloŋkanɛ ka aka Yisrayel fəp kəyɛfɛ tɛgbərɛ ta Sin kɔ kəcepɛ-cepɛ pəmɔ tɔkɔ MARIKI oncsom ŋa ti mɔ. Kɔ ŋancəmbər saŋka nde Refidim, mba domun domun dɛnayi fɛ ndɛ afum ŋanctam kəmun mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Awa, k'afum ŋayɛfɛ kətɛnsər Musa kəcɔp. Kɔ ŋaloku: «Məsɔŋ su domun səmun!» Kɔ Musa oluksɛ ŋa moloku: «Ta ake tɔ nəntɛns'em kəcɔp-ɛ? Ta ake tɔ nəŋwaksɛ MARIKI-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mera yɛnawos aka Yisrayel, afum ŋaccɔpɛnɛ nnɔ Musa eyi mɔ. Ŋacloku: «Ta ake tɔ mənasɔŋɛ su kəpɛ Misira, mədesɔŋɛ su kəfinɛ mera yowosu, səna, awut asu kɔ yɔcɔl yosu-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kɔ Musa oŋkulɛ-kulɛ pəckornɛ MARIKI, pəcloku: «Cəke c'indeyɔnɛ afum akaŋɛ-ɛ? Kɔ pəncepər ndɛkəl nnɔ-ɛ, ŋandeca-cas im.» ");
INSERT INTO bsp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kɔ MARIKI oloku Musa: «Məcepər aka Yisrayel tekiriŋ, məlɛkɛnɛ abeki aka Yisrayel. Məlɛkɛnɛ sɔ kəgbo kam nkɛ mənasutɛ kəŋgbɔkɔ ka Nil mɔ, məcɔŋnɛ kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","K'ina, incəmɛ nnɔ tekiriŋ tam, tasar ta tɔrɔ ta Horɛb kəroŋ. Məsutɛ tasar kəgbo kam, poŋwur domun ndɛ aka Yisrayel ŋantam kəmun mɔ.» Kɔ Musa ɔyɔ ti, fɔr ya abeki aka Yisrayel kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kɔ ŋawe kəfo kaŋkɔ Masa «kədəktər», kɔ Meriba «kəcɔp», bawo aka Yisrayel ŋanatɛnsər di Musa kəcɔp, kɔ ŋawakəs di MARIKI, kəcyifnɛ: «MARIKI eyi su dacɔ ba, ka eyi fɛ su dacɔ?» ");
INSERT INTO bsp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Dəndo kəfo kaŋkɔ ancwe Refidim mɔ, difɔ aka Amalɛk ŋander ŋayektər aka Yisrayel kəwan. ");
INSERT INTO bsp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Awa, kɔ Musa oloku Yosuwe: «Məyɛk-yɛkɛ su dacɔ arkun, məwur məsutɛnɛ k'aka Amalɛk. Alna incəmɛ nde tɔrɔ dətelempan itɔmpər kəgbo ka Kanu.» ");
INSERT INTO bsp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kɔ Yosuwe ɔyɔ tɔkɔ Musa ɛnaloku kɔ mɔ, kəkɔsutɛnɛ k'aka Amalɛk. Musa, Aruna kɔ Hur ŋampɛ nde tɔrɔ dətelempan. ");
INSERT INTO bsp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kɔ Musa ɛmpɛnɛ kəca darenc-ɛ, aka Yisrayel ŋatasərnɛ aka Amalɛk. Mba k'ɔnckɔnatorɛ waca-ɛ, aka Amalɛk ŋatasərnɛ aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ntɛ waca wendelɔl Musa mɔ, Aruna kɔ Hur ŋalɛk tasar kɔ ŋaŋkɔ ŋaboc pi Musa dəntɔf kɔ wəkakɔ ɛndɛ pi kəroŋ. Aruna kɔ Hur ŋasoc Musa waca darenc, Aruna kəca kin Hur kəca ka mɛrəŋ haŋ kɔ dec dɔŋkɔ dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kɔ Yosuwe ɛntam Amalɛk k'afum ɔn, k'endiftɛ ŋa dakma. ");
INSERT INTO bsp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kɔ MARIKI oloku Musa: «Məcicəs ti nde dəbuk, tede tɔyɔnɛ tɛcɛmcɛmnɛ, məloku Yosuwe belbel, a indenim Amalɛk ntɛ tɔŋsɔŋɛ ali fum ta endecɛm-cɛmnɛ ŋa doru dandɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kɔ Musa ɛncəmbər tetek toloŋnɛ k'ewe di: «MARIKI ɔyɔnɛ tɛgbɛkərɛ ta kətam kem.» ");
INSERT INTO bsp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kɔ Musa oloku: «Bawo ayektər dɛbɛ da MARIKI kəca kəlɔma, MARIKI endesutɛnɛ kəsutɛnɛ dəm kɔ dɛtɛmp o dɛtɛmp da aka Amalɛk.» ");
INSERT INTO bsp_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetero, wəloŋnɛ ka Madiyaŋ papa ka wəran ka Musa, ene mes mɔkɔ Kanu kənayɔnɛ Musa k'aka Yisrayel afum ɔn mɔ, k'ɛncərɛ tɔkɔ MARIKI owurɛnɛ aka Yisrayel Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kɔ Yetero papa ka wəran ka Musa, ɛlɛk Sefora, wəran ka Musa nwɛ ɛnalukus ndɔrɔn k'awut ɔn mɛrəŋ mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Musa ɛnasɔŋ tewe ta Kɛrsɔm coco cɔn, bawo ɛnaloku: «Wəcikəra iyɔnɛ nnɔ atɔf ŋocuru ŋaŋɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Kɔ wan wəka mɛrəŋ, nkɔn ɛnawe Eliyeser, bawo Musa ɛnaloku: «Kanu ka papa wəkem kənder kədemar im, kɔ kəyac im dakma da firawona.» ");
INSERT INTO bsp_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Wəran ka Musa k'awut ɔn kɔ kas Yetero ŋander ŋabəp Musa dətɛgbərɛ, nde ɛnacəmbər saŋka tɔrɔ ta Kanu kəsək mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kɔ Yetero oloku Musa: «Ina papa wəka wəran kam, Yetero, inder nnɔ məyi mɔ kɔ wəran kam kɔ awut ɔn mɛrəŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kɔ Musa eŋgbintərnɛ papa ka wəran kɔn, k'ɛncəpɛ kɔ suwu, k'ɛmakərnɛ kɔ. Kɔ ŋayifɛnɛ nwɛ o nwɛ ntɛ pəyi kɔ mɔ, kɔ ŋambɛrɛ dabal. ");
INSERT INTO bsp_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Kɔ Musa ɔlɔmər papa ka wəran kɔn mes mɔkɔ MARIKI ɛnayɔ firawona k'aka Misira mɔ fəp teta aka Yisrayel, k'ɔlɔmər kɔ sɔ pəcuca pɔkɔ ŋanasɔtɔ dɔpɔ, kɔ tɔkɔ MARIKI ɛnayac ŋa pi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","K'amera ŋɔmbɔt Yetero teta pətɔt pɔkɔ MARIKI ɛnayɔnɛ aka Yisrayel mɔ fəp, kɔ tɔkɔ MARIKI ɛnabaŋ aka Yisrayel aka Misira dəwaca mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Kɔ Yetero oloku: «Iŋkor-koru Kanu nkɛ kəbaŋ nu aka Misira kɔ firawona dəwaca mɔ, MARIKI nwɛ owurɛ nu dacar da aka Misira mɔ! ");
INSERT INTO bsp_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Incərɛ oŋ a MARIKI ɛmbɛk pətas canu fəp, ɛnamentər ti ntɛ aka Misira ŋanctɔrəs aka Yisrayel mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Kɔ Yetero papa ka wəran ka Musa ɛlɛk pɔcɔl mpɛ ɛnadekɔcɔfɛ Kanu mɔ, k'oloŋnɛ sɔ yoloŋnɛ yɔlɔma. Aruna kɔ abeki aka Yisrayel fəp ŋander ŋadi yeri yayɔkɔ kɔ papa ka wəran ka Musa Kanu fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Dɔckɔsɔk, kɔ Musa ɛndɛ kəboc kiti ka aka Yisrayel, k'aka Yisrayel ŋacəmɛ Musa fɔr kiriŋ kəyɛfɛ bətbət haŋ dɔfɔy ntɛ tɔŋsɔŋɛ Musa pəcəŋkəl moloku maŋan mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kɔ papa ka wəran ka Musa ɛnəŋk tɔkɔ Musa ɔncyɔnɛ aka Yisrayel mɔ fəp, k'oloku: «Cəke cɔ məŋyɔnɛ aka Yisrayel tantɛ fəp-ɛ? Ta ake tɔ mənɔnɛ nnɔ sona-ɛ, ta ake tɔ afum ŋacəmɛn'am fɔr kiriŋ kəyɛfɛ tɛbətbət haŋ dɔfɔy-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Kɔ Musa oloku papa ka wəran kɔn: «Dɔpɔ da Kanu d'afum ŋander kətɛn nnɔ iyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Afum aŋɛ kəgbɛkəlɛnɛ kəmbɛrɛ dacɔ mɔ, ŋader ŋanəŋk im. Iboc kiti afum akakɔ mɛrəŋ dacɔ, icsɔŋɛ ŋa kəcərɛ sariyɛ sa Kanu kɔ mɛtəksɛ mɔn.» ");
INSERT INTO bsp_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kɔ papa ka wəran ka Musa oloku kɔ: «Tantɛ məŋyɔ mɔ, tentesɛ fɛ. ");
INSERT INTO bsp_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Məŋlɔləsnɛ dis, məlɔləs sɔ afum aka Yisrayel aŋɛ nəyi mɔ dis. Tɔyɔ tantɛ tɛnaŋkanɛ kəlelɛ, məfɔtam kəyɔ ti sona. ");
INSERT INTO bsp_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ndɛkəl oŋ məcəŋkəl dim dem məwosɛ imɛŋkəs əm ntɛ tɔŋsɔŋɛ nəsol kɔ Kanu mɔ! Ntɛ pəmar mɔ, məna məyɔnɛ afum aka Yisrayel nnɔ Kanu kəyi mɔ, mən'ɔ pəmar məckenɛ Kanu moloku ma kəgbɛkəlɛnɛ ma aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Məlɔmər ŋa sariyɛ sa Kanu, kɔ mɛtəksɛ mɔn. Məmentər ŋa sɔ dɔpɔ dɔkɔ pəmar ŋacəmɛ darəŋ mɔ, kɔ tɔyɔ ntɛ pəmar ŋa kəyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Məyɛk-yɛk afum alompu aka Yisrayel fəp dacɔ, aŋɛ ŋaŋnesɛ Kanu mɔ, afum akɔ ŋayeŋkɛ kance, aŋɛ ŋantɔfaŋ daka ndɛ dɔntɔsɔk mɔ. Məcəmbər afum wul o wul (1.000), afum am akakɔ məyɛk-yɛk mɔ, wəkin pəyɔnɛ ŋa wəbɛ, wəlɔma wəbɛ wəka afum tasar tin (100), wəlɔma wəbɛ wəka afum wəco kəcamət (50), wəlɔma wəbɛ wəka afum wəco. ");
INSERT INTO bsp_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Afum ayɛk-yɛk akakɔ ŋacbocɛ aka Yisrayel kiti tɛm fəp. Ŋackenɛ məna Musa mes mɔpɔŋ, ŋa ŋackiti mes mɛfɛt mɔkɔ. Məbelinɛ pɛsarɛ, ŋa sɔ ŋamar əm kəsarɛ pi. ");
INSERT INTO bsp_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kɔ məyɔ tatɔkɔ, Kanu kəcsoməs əm ti-ɛ, məfɔtɔrəsnɛ. Tamɛrəŋ ta ti, afum akaŋɛ ŋaŋkɔ ndaraŋan pəforu disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Kɔ Musa ɛncəŋkəl dim da papa ka wəran kɔn, k'ɔyɔ tatɔkɔ wəkakɔ ɛnaloku kɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Kɔ Musa ɛyɛk-yɛk afum alompu Yisrayel fəp disrɛ, k'ɛncəmbər ŋa dɛbɛ: Wəbɛ wəka afum wul win (1.000), wəbɛ wəka afum tasar tin (100), wəbɛ wəka afum wəco kəcamət (50), wəbɛ wəka afum wəco. ");
INSERT INTO bsp_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","K'akakɔ ŋambocɛ oŋ aka Yisrayel kiti tɛm fəp. Ŋackenɛ Musa mes mocuca kəboc kiti, ŋa ŋacboc kiti ka mes mɛfɛt mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kɔ Musa elembərnɛ papa ka wəran kɔn, kɔ wəkakɔ olukus nde atɔf ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ŋof ŋa maas kəyɛfɛ ntɛ ŋawur Misira mɔ, k'aka Yisrayel ŋambɛrɛ dɔsɔk dadɔkɔ nde tɛgbərɛ ta Sinayi. ");
INSERT INTO bsp_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","K'aka Yisrayel ŋayɛfɛ Refidim mɔ, kɔ ŋaŋkɔ tɛgbərɛ ta Sinayi. Dəndo kɔ ŋancəmbər saŋka ŋatɛfərnɛ tɔrɔ ta di. ");
INSERT INTO bsp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kɔ MARIKI ewe Musa tɔrɔ kəroŋ, kɔ Musa ɛmpɛ di. Kɔ MARIKI oloku kɔ: «Ntɛ tɔ məŋkɔloku afum a Yakuba akaŋɛ, moloku mamɛ mɔ məŋkɔdəŋkər aka Yisrayel: ");
INSERT INTO bsp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nənanəŋk nənasərka tɔkɔ inayɔ aka Misira mɔ: Pəyi pəmɔ banca ya asiksik y'ifɛlərɛnɛ nu, kəkɛrɛ nu nnɔ iyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ndɛkəl oŋ, kɔ nəsu ləŋəs nəncəŋkəl dim dem belbel, nəmɛŋkərnɛ sɔ danapa dem ndɛ sənasek mɔ-ɛ, nəna aka Yisrayel nəŋyɔnɛ akemi aka dətim afum fəp dacɔ. In'ɔyɔ doru fəp, ");
INSERT INTO bsp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","mba kɔ nəna aka Yisrayel, nəndeyɔn'em afum aloŋnɛ, nəyɔn'em sɔ afum asoku. Moloku mamɛ mɔ məŋkɔloku ŋa.» ");
INSERT INTO bsp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kɔ Musa ɔŋkɔ pəwe abeki aka Yisrayel, k'ementər ŋa moloku mmɛ MARIKI ɛnasom kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","K'aka Yisrayel fəp ŋasurɛnɛ kəloku Musa: «Səndeyɔ tɔkɔ MARIKI oloku mɔ fəp.» Kɔ Musa oluksɛ MARIKI moloku mamɔkɔ aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Kɔ MARIKI oloku Musa: «Indeder nnɔ məyi mɔ, igbɔpnɛ dəkəp kəpɔŋ, ntɛ tɔŋsɔŋɛ aka Yisrayel ŋacn'em dim ntɛ inde iclok-lokər əm mɔ, tɔsɔŋɛ ŋa sɔ kəcgbɛkər əm kəlaŋ tɛm fəp.» Kɔ Musa kəluksɛ MARIKI moloku ma aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kɔ MARIKI oloku Musa: «Məkɔ nde aka Yisrayel ŋayi mɔ, məpus'em ŋa mɔkɔ kɔ alna teta kəbəpɛnɛ kəŋan kɔ ina, ŋayak sɔ yamos yaŋan. ");
INSERT INTO bsp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ŋalip kəlompəsnɛ ŋackar dɔsɔkɔ, bawo tataka tatɔkɔ, MARIKI endetor fɔr ya aka Yisrayel fəp kiriŋ nde tɔrɔ ta Sinayi kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Məkɔ məcəmbər ŋa agbɛp ŋa tɔrɔ haŋ mənɔŋkər, məcloku ŋa: ‹Nəkɛmbərnɛ ta nəpɛ dətɔrɔ, ta nəgbuŋɛnɛ sɔ agbɛp ŋa pi. Nwɛ o nwɛ ogbuŋɛnɛ pi, mɛnɛ padif kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Wəkayi, kəca kəfɔgbuŋɛnɛ kɔ, mba anca-cas kɔ kəca-cas dəm, kɔ pəyɔnɛ fɛ ti-ɛ, pasɔ-sɔsɛ kɔ cəbəlma. Pəyɔnɛ wɛsɛm, pəyɔnɛ fum, nwɛ o nwɛ oŋgbuŋnɛ pi mɔ, wəkayi ɔfɔyi sɔ doru.› Tɛm ntɛ afula kəlɛn ka aŋkesiya dim dɔpɔŋ mɔ, afum ayɛk-yɛk ŋandenatam kəpɛsɛ tɔrɔ kəroŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kɔ Musa ontor dətɔrɔ kəder nnɔ aka Yisrayel ŋayi mɔ, k'ompus ŋa, kɔ ŋayak sɔ yamos yaŋan. ");
INSERT INTO bsp_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kɔ Musa oloku aka Yisrayel: «Nəlompəsnɛ haŋ dɔsɔkɔ, ta nəlɔtərnɛ aran.» ");
INSERT INTO bsp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tataka ta maas bətbət kɔ pəŋkulɛ-kulɛ darenc, kɔ pəmotər-motər, kɔ kəp kəpɔŋ kəyi tɔrɔ kəroŋ. K'aluk ŋowurɛ dim pəpɔŋ, aka Yisrayel akɔ ŋanayi dəsaŋka mɔ fəp, ŋayɛfɛ kəyikcɛ. ");
INSERT INTO bsp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kɔ Musa owurɛnɛ aka Yisrayel dəsaŋka kəkɔbəpɛnɛ kɔ Kanu, kɔ ŋaŋkɔ ŋacəmɛ tɔrɔ dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tɔrɔ ta Sinayi fəp pɛncpɛ kinimɛ, bawo MARIKI ɛnator di nɛnc disrɛ. Kinimɛ ka pi kəcpɛ pəmɔ kinimɛ ka doco, kɔ tɔrɔ fəp pɛyɛfɛ kəyikcɛ pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ntɛ dim da aluk dɛncnaŋkanɛ kəkulɛ pəpɔŋ mɔ, Musa pəclok-loku, Kanu kəcluksɛ kɔ moloku dəpukulɛ-kulɛ. ");
INSERT INTO bsp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Kɔ MARIKI ontor nde tɔrɔ ta Sinayi kəroŋ, dəndo dətelempan, kɔ MARIKI ewe Musa, kɔ Musa ɛmpɛ. ");
INSERT INTO bsp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kɔ MARIKI oloku Musa: «Mətor məkɔ məmɔnɛ aka Yisrayel ta ŋabɛlkər kədemɔmən MARIKI de, ta tedesɔŋɛ alarəm kəfi. ");
INSERT INTO bsp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ali aloŋnɛnɛ aŋɛ ŋantam kəlɔtərn'em mɔ yati, ŋa sɔ ŋapusnɛ teta kəbəpɛnɛ kəŋan kɔ ina, ta ŋasɔŋɛ MARIKI kədedifət aloŋnɛ alɔma kəgba kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kɔ Musa oloku MARIKI: «Aka Yisrayel ŋafɔdetam kəpɛ tɔrɔ ta Sinayi, bawo mənasom im belbel, məcloku: ‹Məmentər ŋa kələncər, məpus tɔrɔ teta kəbəpɛnɛ kəŋan kɔ ina, məbɔlɛnɛ pi afum.›» ");
INSERT INTO bsp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kɔ MARIKI oloku kɔ: «Məkɔ, mətor, nəpɛ kɔ Aruna. Mba ta aloŋnɛnɛ kɔ aka Yisrayel ŋabɛlkər kəpɛ nnɔ MARIKI eyi mɔ de, ta ŋadesɔŋ'em kədifət afum kəgba kəŋan dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kɔ Musa ontor nnɔ afum ŋayi mɔ, k'olok-lokər ŋa. ");
INSERT INTO bsp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kɔ Kanu kəloku moloku mamɛ fəp: ");
INSERT INTO bsp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«In'ɔyɔnɛ MARIKI Kanu kam, in'owurɛn'am atɔf ŋa Misira nde kəlɔ ka dacar.» ");
INSERT INTO bsp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Məfɔdeyɔ canu cəlɔma fɔr ya ina kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Ta məpat sɔ tɛrəŋka, ta məlompəs paka o paka mpɛ powurɛnɛ kɔ pɔkɔ peyi dəkɔm, dəntɔf, kɔ dəkəba mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ta məde məctontnɛ ca yayɔkɔ fɔr kiriŋ, ta məde məcsalɛnɛ yi sɔ, bawo ina MARIKI, Kanu kam, Kanu k'iyɔnɛ nkɛ kəyɔ kəraca mɔ, nkɛ kəŋluksɛ kəway ka kiciya ka papa nnɔ awut ɔn ŋayi mɔ, haŋ dɛtɛmp maas haŋ dɛtɛmp maŋkəlɛ da akɔ ŋanter im mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Mba intɔmpər kəsektərnɛ danapa haŋ dɛtɛmp wul win (1.000) da afum aŋɛ ŋambɔtər im, ŋamɛŋkərnɛ mosom mem mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Ta mədekɔ məcbonc tewe ta MARIKI Kanu kam kifəli. MARIKI ɔfɔŋaŋnɛnɛ nwɛ omboncəs tewe tɔn kifəli mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Məccɛm-cɛmnɛ dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ, məpus'em di. ");
INSERT INTO bsp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mata camət-tin tataka toluksər disrɛ mədekɔ məcbəc, məclompəs yɛbəc yam fəp mataka mamɔkɔ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mba tataka ta camət-mɛrəŋ, dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI Kanu kam mɔ dɔ. Ali yɛbəc ta məbəc dɔsɔk dadɔkɔ, kəyɛfɛ məna, wan kam wərkun kɔ wəran, kəkɔ ka wəcar kam wərkun kɔ wəran, kəbəp ka yɔcɔl yam kɔ acikəra aŋɛ ŋayi sədare sam mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Bawo mata camət-tin mɔ MARIKI ɛnalompəs antɔf, kɔm, kəba kɔ ca cəkɔ yeyi doru mɔ fəp, k'eŋesəm tataka ta camət-mɛrəŋ. It'ɔsɔŋɛ ntɛ MARIKI ompocɛ dɔsɔk da kəŋesəm pətɔt, k'ampusɛ kɔ di mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Məleləs wisi kɔ wiri, ntɛ tɔŋsɔŋɛ mataka mam meyi doru mɔbɔl nde antɔf ŋɔkɔ MARIKI Kanu kam ɔsɔŋ əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Ta mədif fum.» ");
INSERT INTO bsp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Ta məsumpər dalakɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Ta məkiyɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Ta məbaŋɛ wɛnc əm sede sa yem.» ");
INSERT INTO bsp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Ta məyɔ fɔr gban-gban nnɔ kəlɔ ka wɛnc əm kəyi mɔ. Ta məyɔ fɔr gban-gban nnɔ wəran ka wɛnc əm eyi mɔ, kəyɛfɛ wəcar kɔn wərkun kɔ wəran, wana wɔn, kəbəp ka sɔfale sɔn, ta məfaŋɛ daka o daka da wɛnc əm abəkəc ŋɛlɛc.» ");
INSERT INTO bsp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","K'afum fəp, ŋane pukulɛ-kulɛ pa darenc kɔ dim da aluk kɔ ŋanəŋk pəmotər-motər kɔ kinimɛ kəcpɛ tɔrɔ kəroŋ. Ntɛ aka Yisrayel ŋanəŋk mes mamɔkɔ mɔ, kɔ ŋayikcɛ, kɔ ŋancəmɛ ŋabɔlɛnɛ tɔrɔ. ");
INSERT INTO bsp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","K'aka Yisrayel ŋaloku Musa: «Məlok-lokər su, səndecəŋkəl əm, mba ta Kanu kəlok-lokər su, ta tɔsɔŋɛ sədefi.» ");
INSERT INTO bsp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kɔ Musa oloku aka Yisrayel: «Ta nənesɛ, bawo kəwakəs konu kɔ Kanu kənderɛnɛ. Ntɛ ɛfaŋ mɔ a nənesɛ kɔ, ntɛ tɔŋsɔŋɛ ta nənciya mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Aka Yisrayel ŋacəmɛ pəbɔlɛ, mba Musa nkɔn pəclɔtərnɛ kubump nkɛ MARIKI ɛnayi disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kɔ MARIKI oloku Musa: «Ntɛ tɔ məŋkɔloku aka Yisrayel: ‹Nənəŋk a dəkɔm iyi kəlok-lokər nu. ");
INSERT INTO bsp_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ta nəde nəclompəs ina fɔr kiriŋ canu ca gbeti, kɔ pəyɔnɛ fɛ ti-ɛ, canu ca kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Məde məlompəs'em tetek toloŋnɛ pa dos, mpɛ nənde kəcloŋnɛn'em kəroŋ yoloŋnɛ yɔcɔf kɔ yoloŋnɛ yam ya kəpaŋnɛ pəforu, ŋkesiya kɔ cir kɔ pəyɔnɛ fɛ ti-ɛ, cəna. Ina sɔ indeder əm icpoc'am pətɔt kəfo nkɛ o nkɛ inde icsɔŋɛ kəcɛm-cɛmnɛ tewe tem mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kɔ pəyɔnɛ a tetek toloŋnɛ pa masar pɔ məŋlompəs-ɛ, ta məlompsɛ pi masar mɛpat. Bawo kɔ məmpat mi-ɛ, məŋsɔŋɛ mi kətɔsɔk teta tetek toloŋnɛ pem. ");
INSERT INTO bsp_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ta nəlomps'em tetek toloŋnɛ mpɛ ande pacfərəŋk a pakɔ paloŋn'em mɔ, ntɛ tɔŋsɔŋɛ ta panəŋk wəkɔ ɔŋkɔpɛsɛ kəkɔloŋn'em mɔ kəsɔkər.›» ");
INSERT INTO bsp_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Mɔyɔ mokur fɔr ya Kanu kiriŋ mmɛ mɔ məŋkɔloku ŋa: ");
INSERT INTO bsp_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kɔ məway wəcar wəHebəre-ɛ, pəyɔnɛ wəcar meren camət-tin. Teren ta camət-mɛrəŋ, pəwur yɛŋən dacar ali kəway ɔfɔsɔŋ. ");
INSERT INTO bsp_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kɔ tɔyɔnɛ sona s'ɛnayi tɛm ntɛ ɛcbɛrɛ dacar mɔ, sona sɔn s'oŋwur sɔ. K'ɛnanɛncɛ-ɛ, wəran kɔn ŋaŋwur dacar. ");
INSERT INTO bsp_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kɔ pəyɔnɛ a mariki mɔn ɔsɔŋ kɔ wəran, wəran wəkakɔ pəkomɛ kɔ awut arkun kɔ awut aran-ɛ, awut kɔ wəran, aka mariki mɔn ŋɔ ŋaŋyɔnɛ, nkɔn pəwur dacar sona sɔn. ");
INSERT INTO bsp_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kɔ wəcar nwɛ oloku: ‹Imbɔtər mariki mem, awut em kɔ wəran kem, ifaŋ fɛ kəwur dacar-ɛ,› ");
INSERT INTO bsp_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","awa, mariki mɔn pəlɔtərnɛnɛ kɔ Kanu, pəbakcər kɔ dəkumba kɔ pəyi fɛ ti-ɛ, pəlɛk kɔ pəbakcər dəfərɛm fa kumba kɔn. Mariki mɔn pəpifɛ kɔ abak aləŋəs, tɛm tatɔkɔ wəcar wəkakɔ endeyɔnɛ oŋ wəbəcɛ kɔn doru o doru.» ");
INSERT INTO bsp_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Kɔ fum ɛncaməs wan kɔn wəran pəkɔyɔnɛ wəcar-ɛ, wəkakɔ ɔfɔwur dacar pəmɔ awut arkun acar. ");
INSERT INTO bsp_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kɔ pəyɔnɛ a mariki mɔn ɛnaway kɔ pənɛncɛ-ɛ, tɛlpəs ta ɔmbɔt kɔ sɔ mes-ɛ, pəmar pəce fum wəlɔma pəwurus kɔ, mba sariyɛ səfɔwosɛ mariki mamɔkɔ kəcamsər kɔ acikəra atɔyɔnɛ aHebəre, bawo elip kəyembər kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kɔ pəyɔnɛ a mariki mamɔkɔ wan kɔn wərkun ɛwayɛ kɔ kənɛncɛ-ɛ, pəmar pəyɔ kɔ tɔyɔ tin tayi kɔ awut ɔn aran akom kɔ ŋandekɔ dəkəlɔ-ɛ pəmɔ tɔkɔ tɔyɔ tokur fɔr ya Kanu kiriŋ toloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kɔ mariki mɔn ɛnɛncɛ sɔ wəran wəlɔma, pəmar fɛ pəbeli ntɛ o ntɛ ɔncyɔ wəran wəkakɔ mɔ, kəyɛfɛ yeri kəbəp ka yamos, haŋ kəfəntərɛ. ");
INSERT INTO bsp_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kɔ mariki mmɛ ɔntɔyɔnɛ wəran nwɛ mes mamɛ maas-ɛ, wəran wəkawɛ ɛntam kəwur dacar ali daka ɔfɔsɔŋ, ali pəsam ɔfɔsɔŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Fum nwɛ o nwɛ oŋsut wəlɔma haŋ pədif kɔ mɔ, mɛnɛ padif wəkayi. ");
INSERT INTO bsp_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kɔ pəyɔnɛ a məŋyɛfɛnɛ fɛ kədif kɔn-ɛ, Kanu kəsɔŋɛ k'efir əm dəwaca, indementər əm kəfo nkɛ məntam kəyɛksɛ məkɔ məyacnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nwɛ endifɛ wɛnc cəmpənpən pəyɛfɛnɛ ti mɔ, ali pəyacnɛ tetek toloŋnɛ pem kəroŋ, məkɔ məlɛk kɔ ntɛ tɔŋsɔŋɛ padif kɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Nwɛ o nwɛ oŋsut kas, kɔ pəyɔnɛ fɛ ti, kɛrɛ mɔ, mɛnɛ padif wəkayi.» ");
INSERT INTO bsp_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Nwɛ o nwɛ eŋkiyɛ fum pəcaməs, kɔ pəyɔnɛ fɛ ti, panəŋkɛ kɔ fum wəkakɔ dəwaca mɔ, mɛnɛ padif wəkayi.» ");
INSERT INTO bsp_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Nwɛ o nwɛ ontolanɛ kas, kɔ pəyɔnɛ fɛ ti, kɛrɛ pəlɛc mɔ, mɛnɛ padif wəkayi.» ");
INSERT INTO bsp_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Kɔ afum ŋaŋgbɛkəlɛnɛ, wəkin pətɛmp wəka mɛrəŋ kɔn tasar, kɔ pəyɔnɛ fɛ ti aŋkulma, kɔ wəkakɔ ɔntɔfi mba pəwon kəfəntərɛ ti-ɛ, ");
INSERT INTO bsp_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kɔ tɔyɔnɛ a wəkakɔ ɛntam kəyɛfɛ pətɔmpər kəgbo pəkɔtəs doru-ɛ, pəmar pace wəkakɔ ɛnasut kɔ mɔ. Mba wəkakɔ ɛnasut kɔ pəsɔŋɛ kɔ kəcu mɔ, ɛmar kəsɔŋ kɔ kəway ka ntɛ ɛyamsɛ kɔ yɛbəc mɔ, pətɛnɛ kɔ sɔ acɔl haŋ pətamnɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Kɔ fum ɛntɛmp wəcar kɔn kətɔk, tɔyɔnɛ wəcar wərkun, wəran, kɔ wəcar wəkakɔ efinɛ ti-ɛ, aŋluksɛ wəkayi ayɛk. ");
INSERT INTO bsp_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mba kɔ wəcar wəkakɔ efi fɛ haŋ tataka tin, mata mɛrəŋ mecepər-ɛ, afɔyɔ fum wəkakɔ ntɛ o ntɛ bawo daka da mariki mɔn d'ɔyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Kɔ afum ŋasutɛnɛ ŋakɔ ŋasutərɛnɛ wəran wəbɛkəs, tɔsɔŋɛ wəkakɔ kəkom mba ta daka o daka dɔsɔtɔ kɔ sɔ-ɛ, pəmar wos ka wəran wəkakɔ ŋatəŋnɛ kɔ aboc kiti ŋaboncər asutɛnɛ kəway nkɛ ŋaŋsɔŋ fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mba kɔ pəyɔnɛ a tɔsɔŋ wəran wəbɛkəs kakɔ dolokəp-ɛ, kəway ka defi kəyɔnɛ defi, ");
INSERT INTO bsp_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","dɔfɔr kɔ dɔfɔr, desek kɔ desek, kəca kɔ kəca, kəcək kɔ kəcək, ");
INSERT INTO bsp_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kəcɔf k'aŋsɔŋɛ kəcɔf kəway, kəbopər k'aŋsɔŋɛ kəbopər kəway, kəfat k'aŋsɔŋɛ kəfat kəway.» ");
INSERT INTO bsp_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Kɔ fum oŋsut wəcar kɔn wərkun, kɔ pəyɔnɛ fɛ ti wəran haŋ pəpici kɔ dɔfɔr-ɛ, pəmar pəsak wəcar wəkakɔ pəkɔ yɛŋən, tɔyɔnɛ kəway ka dɔfɔr dɔn. ");
INSERT INTO bsp_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kɔ fum osut wəcar kɔn haŋ pəyotu kɔ desek-ɛ, pəmar pəsak wəcar wəkakɔ pəkɔ yɛŋən, tɔyɔnɛ kəway ka desek dɔn.» ");
INSERT INTO bsp_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Kɔ wana wɛncaŋ wərkun, kɔ pəyɔnɛ fɛ ti wəran lɛn, fum wəkakɔ pəfinɛ ti-ɛ, wana wawɔkɔ wɛmar kəca-cas haŋ wefi, sɛm ya wana wawɔkɔ yɛmar fɛ kəsɔm, ti disrɛ kiti nkɛ o nkɛ afɔsɔbocər wəka wana wawɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mba kɔ pəyɔnɛ a wana wɔ, tokur aŋa wɛnccaŋ afum lɛn, pacsɔŋɛ ti wəsərka kəcərɛ ta wəkakɔ ɛŋkɛmbərnɛ wi haŋ wana wawɔkɔ wedif fum-ɛ, pəmar paca-cas wana wawɔkɔ haŋ wefi, wəka wana sɔ mɛnɛ padif kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mba kɔ pəyɔnɛ a kəway k'awer wəka wana wawɔkɔ ntɛ tɔŋsɔŋɛ ta andif kɔ mɔ, pəmar pəsɔŋ kəway kaŋkɔ awer kɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kɔ pəyɔnɛ a wana, wan wərkun kɔ pəyɔnɛ wan wəran wendif-ɛ, tɔyɔ tokur fɔr ya Kanu kiriŋ tin tatɔkɔ tɔ pəmar pakɔtɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kɔ pəyɔnɛ a wana nwɛ wəcar wərkun kɔ pəyɔnɛ fɛ ti, wəcar wəran wendif-ɛ, pəmar pasɔŋ sikəl wəco maas (30) mariki ma wəcar wəkakɔ, ntɛ tɔyɔnɛ ta wana mɔ, paca-cas wi haŋ wefi.» ");
INSERT INTO bsp_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Kɔ fum ɛŋkay abi, pəsak ŋi fos ta ɛŋgbəpər ŋi, a wana wəder kɔ pəyɔnɛ fɛ ti, sɔfale səder sətor abi ŋaŋɔkɔ disrɛ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","wəkay ka abi ɛŋlɛk pɔcɔl papɔkɔ pefi mɔ, pəsɔŋ wəka pɔcɔl pəsam pɔyɔnɛ kəway ka pɔcɔl pɔn.» ");
INSERT INTO bsp_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Kɔ wana wa fum wendif wana wa wəkɔ-ɛ, ŋacaməs wana wɔkɔ wɔntɔfi mɔ, ŋayerɛnɛ pəsam, ŋayerɛnɛ sɔ sɛm ya wana wɔkɔ wefi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mba kɔ pəyɔnɛ tokur aŋa wana wɔ wɛnccaŋ lɛn, paloku ti wəsərka ta owosɛ kəkɛmbərnɛ wi-ɛ, tɛm tatɔkɔ wəka wana nwɛ wɛncaŋ wɔkɔ lɛn a kɔ wefi mɔ, ɛŋlɛk wana wefi, pəsɔŋ wəkɔ wana weyi wəyeŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","«Kɔ fum eŋkiyɛ wana kɔ pəyɔnɛ fɛ ti aŋkesiya, kɔ pəyɔnɛ fɛ ti wir-ɛ, tɔyɔnɛ a ɛfay pɔcɔl papɔkɔ amera kɔ pəyɔnɛ fɛ ti pəcaməs pi-ɛ, pəmar pəluksɛ cəna kəcamət kəway ka wana win wɔkɔ eŋkiyɛ mɔ, ŋkesiya maŋkəlɛ kəway ka ŋin ŋɔkɔ eŋkiyɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kɔ pəyɔnɛ pabəpɛnɛ wəke pəcbɛrɛ kəkɔkiyɛ, pasut kɔ haŋ pəfi-ɛ, ancərɛ fɛ teta mecir ma wəkakɔ, afɔluksɛ ayɛk ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Mba kɔ pəyɔnɛ a pəwaŋkəra pɔ ambəpɛnɛ wəkayi dec dɔsɔrɔyi dɛ-ɛ, fum nwɛ oŋsut wəke haŋ pədif kɔ mɔ, tɛyɛfɛnɛ tɔ. Wədif kɔn ɛsarɛ teta mecir ma wəke wəkakɔ. Mba wəke nwɛ aŋsumpər mɔ oŋluksɛ kəway ka paka pɔkɔ eŋkiyɛ mɔ, k'ɔntɔtam kəsɔŋ kəway ka pi-ɛ, pəmar pacaməs wəke wəkakɔ pasɔŋ kəway ka pi. ");
INSERT INTO bsp_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","K'ambəpɛ kɔ paka papɔkɔ eŋkiyɛ mɔ pɔsɔrɔyi wəyeŋ-ɛ, tɔyɔnɛ wana, sɔfale, aŋkesiya, wir, wəkayi pəmar pəluksɛ pɔcɔl papɔkɔ pədeŋər pi pɔcɔl pin. ");
INSERT INTO bsp_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kɔ fum ɛsak yɔcɔl yɔn, yɔkɔ yɔsɔmɛ wɛnc yɔbɔf yɔn ya dalɛ, kɔ pəyɔnɛ fɛ ti ŋgbɔŋkəlɔ yɔn ya wɛn-ɛ, pəmar pamɔmən abɔf ŋɔn nŋɛ ŋoŋkom belbel mɔ, pasɔŋ wəkɔ yɔcɔl yɔn yɔsɔmɛ yɔbɔf mɔ, yokom yɔn yɔkɔ yentesɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kɔ fum ɛmbɛr yika nɛnc, nɛnc dadɔkɔ dɔkɔ dɔcɔf kur ka yɛtɛl dɔbɔf, tɔyɔnɛ a yɔbɔf yayɔkɔ yɔlɔl, kɔ pəyɔnɛ fɛ ti yɔsɔrɔbukɛ-ɛ, pəmar wəbɛr ka nɛnc dadɔkɔ pəsɔŋ kəway yi. ");
INSERT INTO bsp_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Kɔ fum ɔsɔŋ wəndɛ kɔn kəmɛŋk ka pəsam, kɔ pəyɔnɛ fɛ ti daka dɔlɔm, a pakɔ pakiyər wəkakɔ anasɔŋ kəmɛŋk mɔ nde kəlɔ kɔn disrɛ k'anəŋk wəke wəkakɔ-ɛ, pəmar pəsɔŋ kəmɛrəŋ ka daka dɔkɔ ɛnakiyɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kɔ tɔyɔnɛ anəŋk fɛ wəke ka ca yayɔkɔ-ɛ, pəmar wəkɔ anasɔŋ daka kəmɛŋk pəkɔ pəmentərnɛ Kanu pədɛrəm a ɛncərɛ fɛ tɔsɔlɛ ntɛ o ntɛ ta daka dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tes o tes t'aŋgbɛkəlɛnɛ, tɔyɔnɛ ta wana, sɔfale, aŋkesiya, wir kɔ pəyɔnɛ fɛ ti, yamos, paka mpɛ o mpɛ pɔsɔlɛ, afum mɛrəŋ ŋacgbɛkəlɛnɛ kəyɔnɛ ka wəka pɔcɔl kɔ pəyɔnɛ fɛ ti paka pɔlɔm-ɛ, agbɛkəlɛnɛ akakɔ mɛrəŋ ŋakɔ ŋamentərnɛ nda akiti fɔr ya Kanu kiriŋ. Nwɛ kiti kəŋkɔlɛcɛ mɔ, fum wəkakɔ pəsɔŋ wəkɔ ŋanayi kəgbɛkəlɛnɛ mɔ mɛrəŋ ma paka pɔkɔ ŋanayi kəgbɛkəlɛnɛ ta pi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kɔ fum ɔsɔŋ wɛnc kəcɔl tɔyɔnɛ wana, sɔfale, aŋkesiya, wir tɔyɔnɛ pɔcɔl mpɛ o mpɛ, a pɔcɔl papɔkɔ pefi, kɔ pəyɔnɛ fɛ ti, pətɛpɛ kəcək, kɔ pəyɔnɛ fɛ ti pakiyɛ pi, ta fum o fum ɛntəŋnɛ ti-ɛ, ");
INSERT INTO bsp_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","pəmar fum wəkɔ anasɔŋ kəcɔl mɔ, pəkɔ pədɛrmɛ wɛnc wəkɔ ɛnasɔŋ kɔ kəcɔl mɔ a ɛŋkiyɛ fɛ pɔcɔl pɔkɔ wɛnc ɛnasɔŋ kɔ kəcɔl mɔ. Tɛm tatɔkɔ pəmar wəka pɔcɔl pəwosɛ kədɛrəm kaŋkɔ, pəmar fɛ sɔ wɛnc pəluksɛ kəway ka pi. ");
INSERT INTO bsp_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Mba kɔ pəyɔnɛ a aŋkiyɛ pɔcɔl mpɛ nde kəlɔ kɔn-ɛ, pəmar pəluksɛ kəway ka pi wɛnc wəkɔ ɛnasɔŋ kɔ kəcɔl mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Kɔ pəyɔnɛ a wɛsɛm wa dop wɛwatəri-watəri pɔcɔl papɔkɔ-ɛ, fum wəkɔ anasɔŋ kəcɔl mɔ, ɛmar kəkenɛ sɛm yɛlpəs yayɔkɔ wəkɔ ɛnasɔŋ kɔ kəcɔl mɔ, wəkakɔ pəyɔnɛ sɔ wənəŋk ka ti. Tɛm tatɔkɔ pəmar fɛ kɔ sɔ kəluksɛ kəway ka pi nwɛ ɛnasɔŋ kɔ kəcɔl mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kɔ fum ɔŋkɔ pəyefu pɔcɔl nnɔ wɛnc eyi mɔ, a pɔcɔl papɔkɔ pede pɛtɛpɛ kəcək, kɔ pəyɔnɛ fɛ ti pefi kumunt ka wəka pɔcɔl papɔkɔ darəŋ-ɛ, pəmar wəkɔ ɛnakɔ pəyefu wɛnc pɔcɔl mɔ, pəluksɛ pi kəway. ");
INSERT INTO bsp_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kɔ pɔcɔl papɔkɔ pefi fɔr ya wəka pi kiriŋ-ɛ, kəluksɛ kəway ka pɔcɔl papɔkɔ kəyi fɛ sɔ. Kɔ pəyɔnɛ anasɔŋ kɔ daka a pəcyefu kɔ pɔcɔl papɔkɔ-ɛ, pəntəŋnɛ tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Kɔ wərkun ɛŋkɛltər wəyecəra wətɔcərɛ wərkun, nwɛ wərkun ɛntatɔfac mɔ, haŋ ŋafəntərɛ-ɛ, pəmar pəsɔŋ kəfac ka wəyecəra wəkakɔ, pəlɛk kɔ sɔ pənɛncɛ. ");
INSERT INTO bsp_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kɔ pəyɔnɛ a papa ka wəyecəra nwɛ owosɛ fɛ kəsɔŋ ka wərkun nwɛ wəyecəra kɔn-ɛ, tɔfɔyamsɛ wərkun wəkakɔ kəsɔŋ ka kəfac ka wəyecəra wəkakɔ ŋafəntərɛ kɔ nkɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ta nəsak wəran dure pəyi doru. ");
INSERT INTO bsp_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Nwɛ o nwɛ ɛŋfəntərər wɛsɛm mɔ, mɛnɛ padif wəkakɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Nwɛ o nwɛ oŋloŋnɛ canu cəcuru ta pəyɔnɛ MARIKI-ɛ, mɛnɛ pasut kɔ haŋ pəməlkɛ. ");
INSERT INTO bsp_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ta mədir wəcikəra, ta məmentər kɔ sɔ fənɔntər, bawo nəna sɔ nənayi decikəra atɔf ŋa Misira. ");
INSERT INTO bsp_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ta nətɔrəs wəcəbokəra nwɛ o nwɛ, ta nətɔrəs sɔ wan nwɛ o nwɛ akombəra ɔn ŋafi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kɔ mətɔrəs fum wəkakɔ haŋ kəbok kɔn kəder im-ɛ, iŋne kəbok kɔn, ");
INSERT INTO bsp_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","pəntɛl'em pəpɔŋ, dəkəwan indif'am dakma. Tɛm tatɔkɔ məna sɔ wəran kam endeyɔnɛ wəcəbokəra, awut am ŋayɔnɛ atɔyɔ kas. ");
INSERT INTO bsp_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Kɔ məmbɔr wətɔyɔ daka pəsam afum em dacɔ-ɛ, ta məyɔ pəmɔ tɔkɔ wəbɔs-bɔsər wəlɔma ɔŋyɔ mɔ, ta məloku a mɛnɛ pədeŋər'am gbɛs dəkəluksɛ da debe dam. ");
INSERT INTO bsp_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Kɔ fum ɛncəmbər'am sɛkɛ duma dɔn da kəfe-ɛ, məluksɛ kɔ di a dec dɛckalɛ, ");
INSERT INTO bsp_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","bawo duma dadɔkɔ gbəcərəm dɔyɔ dokumpɛ da dis dɔn. Dere d'ɔŋkɔkumpɛnɛ a pəfəntərɛ-ɛ? Kɔ wəkayi oŋkorn'em-ɛ, iŋne kɔ dim bawo Kanu nkɛ iyɔnɛ mɔ, iŋyɔnɛ nɔnɔfɔr. ");
INSERT INTO bsp_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ta məfər-fərəs Kanu, ta mətolanɛ wəkiriŋ wəka afum am pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ta nəcwon kəkɛr'em yoloŋnɛ ya yɛtɛl yonu. Nəcsɔŋ im awut anu arkun acɔkɔ-cɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ti tɔ pəmar sɔ məcyɔ nnɔ wana wam, aŋkesiya ŋam kɔ wir wam pəmar wan wəcɔkɔ-cɔkɔ wəka pɔcɔl pam ŋayi kɔ kɛrɛ mata camət-mɛrəŋ. Tataka ta camət-maas, məsɔŋ im pi. ");
INSERT INTO bsp_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Afum apus ŋɔ nəndeyɔn'em, pəmar fɛ nəde nəcsɔm sɛm nyɛ wɛsɛm wɛwatəri-watəri dəkulum mɔ, nəde nəcgbalɛ yi cen. ");
INSERT INTO bsp_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Ta məkɔtɛnɛ yem. Ta məbaŋɛ fum wəlɛc kəbaŋɛ ka yem. ");
INSERT INTO bsp_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ta məcəmɛ kənay darəŋ kəkɔyɔ pəlɛc. K'andebocɛ afum kiti-ɛ, ta məlasnɛ kəca k'afum alarəm yem disrɛ nəsɔŋɛ aboc kiti kəfɛr kiti. ");
INSERT INTO bsp_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ta məbaŋɛ wətɔyɔ daka dəŋkiti k'ɔntɔyɔ kance-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Kɔ məŋkɔ məpətərnɛ wana wa wəterɛnɛ kam kɔ pəyɔnɛ fɛ ti sɔfale sɔn səsɔlɛ-ɛ, məsumpər si məkɛrɛ kɔ dare. ");
INSERT INTO bsp_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kɔ mənəŋk sɔfale sa wəterɛnɛ kam sətɛmpɛnɛ pɛsarɛ pa si dəntɔf-ɛ, ta məcepər, məmar kɔ kədeŋ-deŋi si pɛsarɛ. ");
INSERT INTO bsp_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ta nəyay sariyɛ sa wɛnc əm wətɔyɔ daka dəŋkiti. ");
INSERT INTO bsp_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Məbɔlɛnɛ toloku ta yem, ta məsɔŋɛ wətɔləsər tes kɔ pəyɔnɛ ti-ɛ wəlompu kəfi, bawo ifɔsak fum wəlɛc pəkɔ yɛŋən. ");
INSERT INTO bsp_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ta məbaŋ kəpocɛ ka dəŋkiti, bawo kəpocɛ kaŋkɔ kəŋsɔŋɛ anəŋk kətɔsɔnəŋk kance, kəsɔŋɛ sɔ kənəŋk kance ka alompu. ");
INSERT INTO bsp_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ta mətɔrəs wəcikəra nwɛ ɛndɛ ndaram mɔ. Nəncərɛ belbel tɔkɔ pəŋyi kɔ mɔ, bawo acikəra ŋɔ nənayɔnɛ atɔf ŋa Misira.» ");
INSERT INTO bsp_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Meren camət-tin məcbɔf antɔf ŋam, məcpim yokom ŋa ŋi. ");
INSERT INTO bsp_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mba teren ta camət-mɛrəŋ məsɔŋɛ ŋi kəŋesəm məsak ŋi. Itɔ afum am atɔyɔ daka ŋandinɛ sɔ ŋi kɔ sɛm ya dop sɔ yɔsɔm yɛlpəs yɔkɔ. Məyɔ sɔ tin tayi ta ŋgbɔŋkəlɔ yam ya wɛn kɔ tɔk yam ya olif. ");
INSERT INTO bsp_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Məbəc yɛbəc yam mata camət-tin. Mba tataka ta camət-mɛrəŋ, məleləs dɔsɔk da kəŋesəm, ntɛ tɔŋsɔŋɛ wana kɔ sɔfale sam yeŋesəm dɔsɔk dadɔkɔ mɔ, ntɛ tɔŋsɔŋɛ sɔ wan ka wəcar kam wəran kɔ wəcikəra ŋatam sɔ kəŋesəm mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Nəcəmɛ mamɛ iloku nu mɔ fəp darəŋ. Nəkɛmbərnɛ belbel ta nəde nəckornɛ canu cəcuru. Ta nəcɛm-cɛməs mewe ma canu cəcuru, ta panenɛ nu mi dəkusu yati!» ");
INSERT INTO bsp_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Kəren o kəren mədekɔ məcboc'em cəsata ca sali maas. ");
INSERT INTO bsp_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Məde məcboc'em kəsata ka cəcom cətɔnɔŋkəl lebin. Mata camət-mɛrəŋ ma kəsata kaŋkɔ disrɛ, ŋof ŋa Abib, məde məcsɔm cəcom cətɔnɔŋkəl lebin, pəmɔ tɔkɔ isom əm ti Misira mɔ, bawo ŋof ŋaŋɔkɔ disrɛ ŋɔ mənawur di. Pəmar fɛ pade pacmentərnɛ fɔr yem kiriŋ waca wɔsɔkər.» ");
INSERT INTO bsp_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«Məde məcboc'em sɔ kəsata ka Kətɛl, yokom yɔcɔkɔ-cɔkɔ ya yɔbɔf yam ya dalɛ.» «Kɔ mənde məcboc'em kəsata ka Kəpim ka yɔbɔf yam ya teren dəkələpsər, kɔ məlip kəloŋka ka yokom ya tɔk yam-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kəmaas teren disrɛ pəmar arkun fəp afum anu dacɔ ŋamentərnɛ fɔr ya Wəbɛ MARIKI kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Ta məloŋ mecir ma yoloŋnɛ nyɛ məŋkɛr'em mɔ paka pɔnɔŋkəl lebin mpɛ o mpɛ. Ta nəmɛŋkərnɛ moro ma poloŋnɛ pem haŋ dɔckɔsɔk bətbət. ");
INSERT INTO bsp_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Məde məckɛrɛ nde kəlɔ ka MARIKI Kanu kam yokom yɔcɔkɔ-cɔkɔ ya yɔbɔf ya atɔf ŋam. Ta məpɛcɛ wir mɛsɛ ma kɛrɛ ka wi de.» ");
INSERT INTO bsp_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«K'ina, indesom mɛlɛkɛ mmɛ mendey'əm kiriŋ, mmɛ mendekɔ mocbum əm dɔpɔ mɔ, mosol'am haŋ məbɛrɛ kəfo nkɛ inalomps'am mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mədekɔ məkɛmbərnɛ fɔr ya mi kiriŋ, mədekɔ məcəmɛ dim da mi darəŋ. Ta məyeŋkər mi domp, bawo mɔfɔdekɔŋaŋnɛ dɛtaŋi ləŋəs dam, bawo tewe tem teyi mi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kɔ məncəŋkəl dim dɔn belbel, məyɔ tɔkɔ ilok'əm mɔ fəp-ɛ, indeyɔnɛ wəter ka aterɛnɛ am, wəyɛfərɛnɛ ka aŋɛ ŋambəp əm kəyɛfərɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mɛlɛkɛ mem mendekɔt fɔr yam kiriŋ mekekərɛ nda Amɔr, aHit, aPerisi, aKanaŋ, aHiwy kɔ aYebus, indekɔmələk ŋa. ");
INSERT INTO bsp_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ta mətontnɛnɛ canu cəŋan, ta məsalɛnɛ ci. Ta məcyɔ tɔkɔ ŋaŋyɔ mɔ, mba məcləsər mɛrəŋka maŋan few, məcwɔkəc masar motontnɛ mɔkɔ ŋaccəmbər mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Kɔ nəndekɔ nəcsalinɛ MARIKI Kanu konu-ɛ, endekɔ pəcsɔŋ pətɔt kəcom kam kɔ domun dam pəbɔlɛn'am docu. ");
INSERT INTO bsp_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Wəran wəcɔŋ ɔfɔdekɔyi atɔf ŋam, wəran wətɔkom ɔfɔkɔsɔyi di. Indesɔŋ am kəwon doru. ");
INSERT INTO bsp_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ayek-yek ŋ'indenuŋkɛnɛ kəsak ŋey'əm kiriŋ, indewɛnər afum akɔ nəndekɔ ndaraŋan mɔ fəp anciyan, indekɔsɔŋɛ aterɛnɛ anu fəp ŋayɛksər nu. ");
INSERT INTO bsp_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Deme d'indenuŋkɛnɛ isak dey'əm kiriŋ, ndɛ dendekɔbɛləs aHiwy, aKanaŋ kɔ aHit mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ifɔdekɔbɛləs ŋa fɔr yam kiriŋ kəren kin, ta tedesɔŋɛ atɔf kəyɔ yer-yer, sɛm yɛlɛc ya dop yɛla nyɛ yendetɔrəs əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pəpic pəpic p'indekɔ icbɛləs ŋa fɔr yam kiriŋ haŋ məcla məctam kəbaŋ atɔf fəp. ");
INSERT INTO bsp_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Indekɔboc'am kələncər kəyɛfɛ ka kəba ka Cəŋkɔlma haŋ nde kəba k'aFilisti, kəyɛfɛ ka nde dətɛgbərɛ haŋ nde kəŋgbɔkɔ ka Ɛfərat. Bawo indekɔlɛk afum aka atɔf ŋaŋɔkɔ ibɛr əm ŋa dəwaca, ibɛləs ŋa fɔr yam kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ta mədekɔcaŋəs danapa kɔ ŋa, ta məcaŋəs sɔ danapa kɔ canu cəŋan. ");
INSERT INTO bsp_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ŋafɔdekɔ ndɛ atɔf ŋam, ntɛ tɔŋsɔŋɛ ta ŋadesɔŋ'am kəciya nnɔ iyi mɔ. Kɔ məsak afum akakɔ kəndɛ ndaram-ɛ, tɔŋsɔŋ'am kəsali canu cəŋan, tɔyɔn'am towul.» ");
INSERT INTO bsp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kɔ Kanu kəloku Musa: Məpɛ nnɔ MARIKI iyi mɔ, məna, Aruna, Nadab kɔ Abihu, kɔ abeki wəco camət-mɛrəŋ (70) aka Yisrayel, nədekɔ nətontn'em pəbɔlɛ. ");
INSERT INTO bsp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa sona endelɔtərnɛ MARIKI, akɔ ŋafɔdelɔtərnɛ de, afum sɔ ŋafɔdepɛ kɔ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kɔ Musa ender k'oloku moloku ma MARIKI mamɔkɔ fəp aka Yisrayel, kɔ mosom mɔn fəp. K'aka Yisrayel ŋawosɛ dim din: «Moloku mmɛ MARIKI oloku mɔ fəp, səndeyɔ mi». ");
INSERT INTO bsp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kɔ Musa encicəs moloku ma MARIKI fəp. Dec dendesɔk k'ɛyɛfɛ bətbət suy, k'ɛncəmbər tetek toloŋnɛ nde tɔrɔ dəntɔf k'ɛncəmbər sɔ masar wəco kɔ mɛrəŋ teta tɛcɛmcɛməs ta cusuŋka ncɛ wəco kɔ mɛrəŋ ca Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","K'osom atɛmp aka Yisrayel ŋakenɛ MARIKI yoloŋnɛ yɔcɔf, ŋakenɛ sɔ MARIKI mura ma kəloŋnɛ ka kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Kɔ Musa ɛlɛk dacɔ da mecir mamɔkɔ k'ɛmbɛr mi dətɔbɔl, k'ɛwɛsəsər dacɔ da mecir tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","K'ɛlɛk buk ba Danapa ndɛ ŋanacaŋəs kɔ MARIKI mɔ, k'ɛŋkaraŋɛnɛ bi aka Yisrayel. K'aka Yisrayel ŋaloku: Səndecəmɛ tɔkɔ MARIKI oloku mɔ darəŋ fəp, səndesɔcəŋkəl kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kɔ Musa ɛlɛk mecir k'ɛwɛsəsər mi aka Yisrayel, k'oloku: Nənəŋk mecir ma danapa ndɛ MARIKI esek kɔ nəna aka Yisrayel mɔ mamɛ, kɔ mosom mɔn mmɛ nəntəŋnɛ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kɔ Musa ŋampɛ k'Aruna, Nadab, Abihu kɔ abeki aŋɛ wəco camət-mɛrəŋ (70) aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Kɔ ŋanəŋk Kanu ka Yisrayel pəcəmbərər wɛcək wa Ki tantɔf, pənayi pəmɔ ntɛ aŋlompəs paka pɔyɔ alom ŋa bulu mɔ, pəmɔ tɔkɔ kɔm kəŋsɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mba ɛnatenci fɛ kəca kɔn afum apɔŋ aka Yisrayel akakɔ kəroŋ. Kɔ ŋaŋgbətnɛ Kanu, kɔ ŋandi yeri kɔ ŋamun. ");
INSERT INTO bsp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Kɔ MARIKI oloku Musa: Məpɛ nnɔ iyi mɔ, nnɔ tɔrɔ kəroŋ məde məcəmɛ nnɔ kərɛsna: Walakɛ wa masar w'indesɔŋ əm, sariyɛ kɔ tosom tem t'incicəs wi kəroŋ ntɛ məŋkɔtəksɛ aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa ɛyɛfɛ kɔ Yosuwe wəmarəs kɔn, kɔ Musa ɛmpɛ tɔrɔ ta Kanu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","K'oloku abeki aka Yisrayel: «Nəkar su nnɔ haŋ səder sɔ səbəp nu. Nəmɔmən Aruna kɔ Hur ŋayi nu dɛ kəsək. Nwɛ o nwɛ tes tɛmbəp mɔ, wəkayi pəlɔtərnɛ ŋa.» ");
INSERT INTO bsp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kɔ Musa ɛmpɛ sɔ dətɔrɔ, kɔ kəp kəŋgbəpər tɔrɔ. ");
INSERT INTO bsp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kɔ nɔrɔ da debeki da MARIKI deyi tɔrɔ ta Sinayi kəroŋ oŋ, kɔ kəp kəŋgbəpər tɔrɔ haŋ mata camət-tin. Tataka ta camət-mɛrəŋ, MARIKI pəyi dəkəp k'ewe Musa. ");
INSERT INTO bsp_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Nɔrɔ da debeki da MARIKI dɛnawurɛnɛ nɛnc aka Yisrayel dəfɔr pəmɔ ntɛ nɛnc dɔpɔŋ dende kəcmar tɔrɔ kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Kɔ Musa ɛmbɛrɛ kəp kaŋkɔ disrɛ, k'ɛmpɛ nde tɔrɔ kəroŋ. Kɔ Musa ɔŋkɔ pəwon nde tɔrɔ kəroŋ mata wəco maŋkəlɛ (40) daŋ kɔ pibi. ");
INSERT INTO bsp_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Məloku aka Yisrayel a ŋabaŋəs kəfɛk kem. Nəbaŋ kəpocɛ ka nwɛ o nwɛ ɔŋsɔk abəkəc pɛs kəsɔŋ ki mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kəfɛk nkɛ kɔ nəndebaŋsər ŋa: Kɛma, gbeti, kɔpər, ");
INSERT INTO bsp_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","cəloto cəgbət karɛ alom ŋa məntambɛnc, alom ŋeyim ŋeyimbərər, cəloto ncɛ andunɛ səbeŋa sa kentəler kɔ ncɛ andunɛ cəfon ca wir mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kata ya ŋkesiya nyɛ aŋgbət karɛ alom ŋeyim mɔ, kata ya ntempeli, tɔk ya kasiya, ");
INSERT INTO bsp_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","moro momotɛnɛ, labundɛ dobotu ambɔnc ndɛ ande pacnɔŋkəl moro mɔbɔy mɔsɔkəsnɛ, kɔ suray səbotu ambɔnc, ");
INSERT INTO bsp_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","kɔ masar mɔtɔt mmɛ aŋwe onikəs mɔ kɔ mɔtɔt mɔlɔma mmɛ andebɛr duma da efɔd kɔ yuba yɛgbɛknɛ dɛbəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Kəfo kəsoku kɔ aka Yisrayel ŋandecəmbər'em, ntɛ tɔŋsɔŋɛ idetam kəndɛ ŋa dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pəmɔ yayɔkɔ indementər əm mɔ, məlompəs ca ya dəkiyi dosoku kɔ yosumpər-sumpər ya di pəmɔ tatɔkɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Kaŋkəra ka kətɔk ka kasiya kɔ ŋandelompəs. Ŋatubuc ki dobolu cururu mɛrəŋ kɔ dacɔ, kɔ dowokulu da ki kururu katin kɔ dacɔ kɔ dotukum da ki kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Məsop kaŋkəra kaŋkɔ kɛma kəsoku pɛs, tedisrɛ kɔ todoru, payɔ ki kəbər ka kɛma haŋ panɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Palompəs cəsora maŋkəlɛ ca kɛma ncɛ andekɔbɛr kaŋkəra kaŋkɔ dəmoŋkubut mɔ cəsora mɛrəŋ kəsək kin, kɔ cəkɔ mɛrəŋ kəsək ka mɛrəŋ kəŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Məpat cəgbo mɛrəŋ ca tɔk ya kasiya məsop ci kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Pasor cəgbo cacɔkɔ dəcəsora ca kɛma cacɔkɔ, ntɛ tɔŋsɔŋɛ pade pactam kəsɛlɛŋ kaŋkəra kaŋkɔ pacgbaŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","K'alip kəsor cəgbo cacɔkɔ dəcəsora ca kaŋkəra-ɛ, pəmar fɛ sɔ pasulu ci. ");
INSERT INTO bsp_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kaŋkəra kaŋkɔ disrɛ kɔ məŋkɔbɛr walakɛ nwɛ wementər danapa dem k'aka Yisrayel nwɛ indesɔŋ əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Afɛŋk ŋɔsɔksɛ kiciya ŋaŋɔkɔ, kɛma kəsoku pɛs kɔ nəndekɔlompsɛ ŋi. Dobolu da ŋi dendeyɔ cururu mɛrəŋ kɔ dacɔ, kɔ dowokulu da ŋi kururu katin kɔ dacɔ. Afɛŋk ŋaŋɔkɔ ŋendeyɔnɛ ŋɛgbəpərɛ kaŋkəra. ");
INSERT INTO bsp_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Məlompsɛ mɛlɛkɛ kerub mɛrəŋ kɛma kətɛmp, məsɛlərɛnɛ mi dəkəcop kɔ dəkələpsər da afɛŋk ŋɔsɔksɛ kiciya kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Məsɛlərɛnɛ mɛlɛkɛ kerub min dəkəcop da afɛŋk ŋɔsɔksɛ kiciya kəroŋ, mɛlɛkɛ kerub mɔkɔ dəkələpsər da ŋi kəroŋ. Məlompəs mɛlɛkɛ kerub mɛrəŋ kɔ afɛŋk ŋaŋɔkɔ yɔyɔnɛ paka pin nde dəkəcop kɔ dəkələpsər da ŋi kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mɛlɛkɛ mamɔkɔ mɛrəŋ mendekɔperi banca takəroŋ, yi yokump afɛŋk ŋɔsɔksɛ kiciya, mɛtɛfərɛnɛ meti cəro nde afɛŋk ŋɔsɔksɛ kiciya kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","K'alip kəbɛr ki disrɛ walakɛ nwɛ wementər danapa dem kɔ aka Yisrayel nwɛ indesɔŋ əm mɔ, məgbəpərɛ kaŋkəra afɛŋk ŋɔsɔksɛ kiciya ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Dənda afɛŋk ŋaŋɔkɔ kəroŋ sənde səcbəpɛnɛ, mɛlɛkɛ kerub mamɔkɔ mɛrəŋ dacɔ mmɛ meyi afɛŋk ŋɔsɔksɛ kiciya ŋaŋɔkɔ aŋgbəpər kaŋkəra kaŋkɔ kəroŋ mɔ. Difɔ indekɔ icsom əm mɛfaŋ mem fəp mɔkɔ mənde məcloku aka Yisrayel mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Məlompsɛ amɛsa kətɔk ka kasiya. Dobolu da ŋi dɔyɔ cururu mɛrəŋ, dowokulu da ŋi dɔyɔ kururu katin, kɔ deŋeci da ŋi kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Məsop amɛsa ŋaŋɔkɔ kɛma kəsoku pɛs, məlompəs ŋi cəsək kəbər ka kɛma haŋ mənɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Məboc cəbam cəlɔma cəsək cacɔkɔ maŋkəlɛ tantɔf, dowokulu da ci dɔcyɔ kəca disrɛ, mənɛpsər ci kɛma haŋ mənɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Məlompəs cəsora maŋkəlɛ ca kɛma, məboc ci dəmoŋkubut kəsurɛnɛ ka yɛcəmɛnɛ maŋkəlɛ ya amɛsa ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Cəsora cacɔkɔ maŋkəlɛ cəlɔtərnɛ fərɛm. Cəsora cacɔkɔ c'andekɔsor cəgbo ncɛ ande paclɛkɛnɛ amɛsa ŋaŋɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Məpat cəgbo ca kətɔk ka kasiya, məsop ci kɛma, cəgbo cacɔkɔ c'andekɔ pactam kəgbaŋnɛnɛ amɛsa ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Məlompsɛ ŋi ca ncɛ pəmar mɔ: Pəlet, mɔbɔl, səpɔt kɔ mapan nyɛ andekɔ pacbəcɛ yoloŋnɛ ya moro kɔ wɛn mɔ, kɛma kəsoku pɛs kɔ məndelompsɛ yi. ");
INSERT INTO bsp_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Pəmar məde məccəmbər'em kəcom nkɛ ande pacloŋn'em mɔ nnɔ amɛsa ŋaŋɛ kəroŋ tɛm o tɛm.» ");
INSERT INTO bsp_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Məde məlompsɛ pɛdɛtɛ səlamp kɛma kətɛmp kəsoku pɛs. Pasɛlərɛnɛ pi kəyɛfɛ ka pɛcəmɛnɛ kəkɔ təmboŋk pa pi, yɔnɔnɛ ya səlamp, yogbuc ya pi, kɔ yowurɛnɛ ya yɛlɛŋk ya tɔk. ");
INSERT INTO bsp_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Tatɔkɔ tɔ pɔŋkɔyi wara camət-tin wɔŋkɔyɛfɛ dətəmboŋk paracɔ mɔ, kəca o kəca wara maas. ");
INSERT INTO bsp_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kəra o kəra ka pɛdɛtɛ səlamp kəyɔ yogbuc maas kɔ yɛlɛŋk ya yi. Itɔ pəŋkɔyi wara camət-tin nwɛ wɔŋkɔyɛfɛ dətəmboŋk pa pɛdɛtɛ səlamp mɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Təmboŋk pa pɛdɛtɛ səlamp pɔyɔ yɔnɔnɛ ya səlamp maŋkəlɛ nyɛ yɔŋkɔwurɛnɛ yɛlɛŋk ya tɔk yokom mɔ, yogbuc, kɔ yɛlɛŋk ya yi. ");
INSERT INTO bsp_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Wara wawɔkɔ mɛrəŋ mɛrəŋ kəmaas nwɛ wɛŋyɛfɛ dətəmboŋk paracɔ mɔ, dəkəyɛfɛ da wara mɛrəŋ o mɛrəŋ mɛnɛ pogbuc pin peyi wi tantɔf. ");
INSERT INTO bsp_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Pasɛlərɛnɛ yogbuc kɔ wara, patɛmpɛ fəp fa yi ancəmbəl ŋin ŋa kɛma kəsoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Məlompəs səlamp camət-mɛrəŋ səkɔ pəmar pacəmbər yɔnɔnɛ səlamp kəroŋ mɔ, ntɛ tɔŋsɔŋɛ səcweŋki tekiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Macaŋk kɔ map mɛkayɛ meken sɔ fəp fa mi pəmar mɔyɔnɛ kɛma kəsoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Pɛdɛtɛ səlamp, pɛcəmbərɛ pa pi kɔ yosumpər-sumpər yayɔkɔ, kɛma kəsoku pɛs kilo wəco maas (30) kɔ pəmar palompsɛ yi. ");
INSERT INTO bsp_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Məna Musa məgbətnɛ belbel, məsurɛnɛ yɛbəc nyɛ məmɔmən nnɔ tɔrɔ kəroŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Musa məlompsɛ dəkiyi dosoku cəpol wəco ca kəloto ka səbeŋa sa kentəler, ka alom ŋa məntambɛnc, alom ŋa bulu k'alom ŋeyim. Səbeŋa sasɔkɔ sɔ məŋkɔdunɛ ci kəroŋ lulu ya mɛlɛkɛ kerub. Yɛbəc ya wəcɛrəŋ yendeyi yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dobolu da cəpol cacɔkɔ fəp dɔkɔ dɔyɔ nkɛ o nkɛ cururu wəco mɛrəŋ kɔ camət-maas (28), kɔ dowokulu da kəpol nkɛ o nkɛ dɔkɔ dɔyɔ cururu maŋkəlɛ, cəpol fəp cəde cətəŋnɛnɛ potubuc. ");
INSERT INTO bsp_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mədekɔ məgbɛtlɛnɛ-gbɛtlɛnɛ cəpol kəcamət dɛwɛnca, məyɔ sɔ tin tayi cəkɔ kəcamət. ");
INSERT INTO bsp_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Məwes-wesɛ dobol da kəloto kəcɔkɔ-cɔkɔ kəkəsək səbeŋa s'alom ŋa məntambɛnc, məde mənut yi, məyɔ sɔ tin tayi kəpol ka kəloto ka mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Dobol da cəloto cacɔkɔ mɛrəŋ məwes-wesɛ di səbeŋa wəco kəcamət (50), mənut yi, məsɔŋɛ yewes-wesi ya cəloto cacɔkɔ mɛrəŋ fəp yosurɛnɛ dɛwɛnca. ");
INSERT INTO bsp_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Məde məlompəs ŋkora wəco kəcamət (50) ya kɛma nyɛ məndekɔcɛpərɛnɛ cəloto cacɔkɔ mɛrəŋ mɔ, ntɛ tendesɔŋɛ cəloto ca dəkiyi dosoku kədeyɔnɛ kin mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Mədunɛ cəpol ca kəloto ka mɛrəŋ kətelər nkɛ wəco kɔ pin cəfon ca wir, ncɛ andekɔperi dəkiyi dosoku kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dobolu da kəpol nkɛ o nkɛ dede dɔyɔ cururu wəco maas (30), kɔ dowokulu dede dɔyɔ cururu maŋkəlɛ. Cəpol ncɛ wəco kɔ pin (11) fəp cəde cəyɔ potubuc pin payi. ");
INSERT INTO bsp_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Məgbɛtlɛnɛ taciŋa cəpol kəcamət, kɔ cəpol cəkɔ camət-tin sɔ taciŋa. Kəpol ka camət-tin, pəmar ki kəyɛlɛ tekiriŋ ta aŋgbancan. ");
INSERT INTO bsp_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Məde məlompəs yewes-wesi wəco kəcamət (50) kəpol kəkəsək ka yɛgbɛtlɛnɛ yɔcɔkɔ-cɔkɔ, mənut yi. Kəpol kəkəsək ka yɛgbɛtlɛnɛ ya mɛrəŋ sɔ, məlompəs kəsək kayi yewes-wesi wəco kəcamət (50), mənut sɔ yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Məlompəs ŋkora wəco kəcamət (50) ya kɔpər nyɛ məndegbɛkər deyewes-wesi mɔ, ntɛ tɔŋsɔŋɛ aŋgbancan ŋɔyɔnɛ ŋin mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Dacɔ da cəpol ca cəloto dendecernɛ, paŋɛrɛ di dəkiyi dosoku tadarəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dobolu da cəpol ca cəloto decernɛ, pəmar payer di dacɔ kəsək o kəsək ntɛ tɔŋsɔŋɛ paŋɛr dəkiyi dosoku belbel mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Məlompsɛ pokumpɛ pa aŋgbancan kata ya ŋkesiya yɔkɔ aŋgbət karɛ kəyim mɔ, məgbɔkərɛ sɔ kəlompsɛ kata ya ntempeli pokumpɛ pa mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Məlompsɛ fərɛm fa dəkiyi dosoku tɔk ya kasiya, nfɛ andekɔcəmbər mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Pəmar fərɛm o fərɛm fəbɔl cururu wəco kɔ dowokulu da fi dɔyɔ kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Fərɛm o fərɛm pəmar fəyɔ sek mɛrəŋ nyɛ yosol dɛwɛnca mɔ, tatɔkɔ tɔ pəmar payɔ fərɛm fa dəkiyi dosoku fəp. ");
INSERT INTO bsp_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Məlompsɛ ntende kəca kətɔt ka di nde dec dɛmpɛ mɔ fərɛm wəco mɛrəŋ (20). ");
INSERT INTO bsp_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Məlompsɛ yɛcəmɛnɛ wəco maŋkəlɛ (40) ya gbeti nyɛ məndekɔcəmbər tantɔf ta fərɛm wəco mɛrəŋ (20) mɔ. Nfɛ o nfɛ fəyɔ yɛcəmɛnɛ mɛrəŋ, kəsurɛnɛ ka bi yɔkɔ pəmar pasɛt sek mɛrəŋ yɔkɔ fərɛm fəyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kəca kəmeriya ka dəkiyi dosoku nde dec dɛmpɛ mɔ, məlompsɛ sɔ dəndo fərɛm wəco mɛrəŋ (20). ");
INSERT INTO bsp_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Yɛcəmɛnɛ wəco maŋkəlɛ (40) ya gbeti, ti tɔ tatɔkɔ yɛcəmɛnɛ mɛrəŋ yede yeyi fərɛm fin tantɔf. ");
INSERT INTO bsp_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Məde məlompəs fərɛm camət-tin fa tɔgbɔkɛnɛ ta dəkiyi dosoku kəca ka ntende dec dɛŋkalɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Məlompəs fərɛm mɛrəŋ taciŋa nfɛ fəŋkɔyi dəmoŋkubut nde tɔgbɔkɛnɛ pa dəkiyi dosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Məde məyɔ fərɛm fafɔkɔ mɛrəŋ fəgbɛpɛnɛ kəyɛfɛ tantɔf, məkotərɛnɛ fi takəroŋ kəsora kin. Tin tayi t'andeyɔ fərɛm, mɛrəŋ fəkɔ feyi moŋkubut mamɔkɔ mɛrəŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Itɔ tatɔkɔ fərɛm camət-maas kɔ yɛcəmɛnɛ wəco kɔ camət-tin (16) ya gbeti, fərɛm o fərɛm fəyɔ yɛcəmɛnɛ mɛrəŋ tantɔf. ");
INSERT INTO bsp_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Məpat cəgbo ca kətɔk ka kasiya kəcamət ncɛ andesumpərɛ fərɛm fəp fa kəsək kin ka dəkiyi dosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Cəgbo kəcamət sɔ ca fərɛm fa kəsək ka mɛrəŋ ka dəkiyi dosoku, kɔ cəgbo kəcamət sɔ ca fərɛm fa tɔgbɔkɛnɛ ta dəkiyi dosoku ntende dec dɛŋkalɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kəgbo kəracɔ kəmar kəcepər fərɛm fa kəsək kin fəp dacɔ kəyɛfɛ fərɛm fəcɔkɔ-cɔkɔ haŋ kəbəp fəlpəs. ");
INSERT INTO bsp_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Məde məsop fərɛm fəp kɛma, məlompsɛ cəsora kɛma ncɛ andecɛpərɛnɛ cəgbo cacɔkɔ mɔ, məsop sɔ ci kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Kɔ mamɔkɔ melip-ɛ, məna Musa məyekti dəkiyi dosoku, məcəmbər di dowurɛnɛ kɔ dandɛ imentər əm nnɔ tɔrɔ kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Məlompsɛ kəloto kəkəŋkɛ ka səbeŋa sa kentəler, sa alom ŋa məntambɛnc, sa alom ŋa bulu, kɔ sa alom ŋeyim. Pawurɛ kəloto kaŋkɔ kəroŋ lulu ya mɛlɛkɛ kerub mɛrəŋ. Yɛbəc ya wəcɛrəŋ kədu yendeyi yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Məde mədɛt ki dəmogbu maŋkəlɛ ma kətɔk ka kasiya mmɛ asop kɛma kɔ mɔyɔ ŋkora ya kɛma mɔ, məcəmbər mi dəyɛcəmɛnɛ maŋkəlɛ kəroŋ ya gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Nədɛtər kəloto kəkəŋkɛ ŋkora tantɔf. Kəloto kəkəŋkɛ kaŋkɔ tadarəŋ k'aŋkɔcəmbər kaŋkəra nkɛ kəyɔ walakɛ nwɛ wementər danapa dem kɔ aka Yisrayel mɔ. Nədɛt kəloto kəkəŋkɛ kaŋkɔ ntɛ tɔŋsɔŋɛ kəyer aŋgbip ŋosoku kɔ tɔksɔ tosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Kɔ məlip-ɛ, məgbəpər oŋ afɛŋk ŋɔsɔksɛ kiciya kaŋkəra nkɛ kəmentər danapa dem k'aka Yisrayel nde dətɔksɔ tosoku. ");
INSERT INTO bsp_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Məcəmbər amɛsa kəloto kəkəŋkɛ todoru, aŋgbip disrɛ ntende kəca kətɔt ka nde dec dɛmpɛ mɔ, kɔ pɛdɛtɛ səlamp pi pɛtɛfərɛnɛ kɔ amɛsa ntende kəca kəmeriya ka nde dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Məde mədunɛ kusuŋka k'aŋgbancan cəloto cəŋɛrɛ ca səbeŋa sa kentəler, panɔŋkəsəl səbeŋa sa alom ŋa məntambɛnc, sa alom ŋa bulu kɔ sa alom ŋeyim. ");
INSERT INTO bsp_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Məde məpatɛ kəloto kəŋɛrɛ mogbu kəcamət ma kətɔk ka kasiya, məsop mi kɛma, məgbɛkər ŋkora ya kɛma mogbu mamɔkɔ. Məsɛlɛ yɛcəmɛnɛ ya mogbu kəcamət yayɔkɔ kɔpər.» ");
INSERT INTO bsp_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Məlompsɛ tetek toloŋnɛ Kanu kətɔk ka kasiya, dobolu da pi dɔyɔ cururu kəcamət, kɔ dowokulu da pi sɔ cururu kəcamət. Tetek pɛtəŋnɛnɛ cəsək fəp, mba deŋeci da pi dɔyɔ cururu maas. ");
INSERT INTO bsp_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Məlompəs lɛn ya tetek nde moŋkubut mamɔkɔ makəroŋ maŋkəlɛ. Məde məsɛlərɛnɛ lɛn yayɔkɔ kɔ tetek toloŋnɛ ntɛ tɔŋsɔŋɛ yɔyɔnɛ paka pin mɔ, məsop pi kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Məlompsɛ tetek toloŋnɛ dap dɛbɛrɛ kəbof, pel, mapan, bak yosortɛ sɛm kɔ map mɛkayɛ meken. Məlompsɛ yosumpər-sumpər yayɛ fəp kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Məlompsɛ tetek toloŋnɛ manta ma kɔpər, məbɛr mi cəsora maŋkəlɛ ca kɔpər dəmoŋkubut. Məcəmbər mi kəbər ka tetek toloŋnɛ tantɔf, deŋeci da manta mamɔkɔ mɛcbəp dacɔ da tetek. ");
INSERT INTO bsp_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Pacəmbər manta mamɔkɔ kəbər ka tetek toloŋnɛ tantɔf, deŋeci da manta mamɔkɔ mɛcbəp deŋeci dacɔ da tetek. ");
INSERT INTO bsp_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Məpatɛ tetek toloŋnɛ cəgbo kətɔk ka kasiya, məsop ci kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Pasor cəgbo cacɔkɔ dəcəsora cacɔkɔ cəyi cəsək ca tetek papɔkɔ mɔ, ntɛ tɔŋsɔŋɛ pactam kəkekərɛ tetek toloŋnɛ papɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tetek toloŋnɛ papɔkɔ məŋkɔlompsɛ cəbam mɔ, pede pɔyɔ fos disrɛ. Ŋayɔ pi pəmɔ tɔkɔ anamentər əm nnɔ tɔrɔ kəroŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Məlompəs abaŋka ŋa dəkiyi dosoku. Ntende kəca kətɔt ka nde dec dɛmpɛ mɔ, pəmar dobolu da saŋka dɔyɔ cururu tasar tin (100), mədɛt di cəloto ca səbeŋa sa kentəler. ");
INSERT INTO bsp_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mogbu wəco mɛrəŋ ma kəpər (20) kɔ yɛcəmɛnɛ ya mi ya kɔpər wəco mɛrəŋ (20), ŋkora ya mogbu kɔ gbat-gbata ya mi pəmar yɔyɔnɛ ya gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kəca kəmeriya ka ntende dec dɛmpɛ mɔ, pəmar ki kəyɔ sɔ cəloto pəmɔ kəcɔkɔ-cɔkɔ dobolu da ki dɔyɔ cururu tasar tin (100), kəca kaŋkɔ kəyɔ mogbu wəco mɛrəŋ (20) kɔ yɛcəmɛnɛ ya mi wəco mɛrəŋ (20) ya kɔpər. Ŋkora ya mogbu kɔ gbat-gbata ya mi fəp, pəmar palompsɛ yi gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Dowokulu d'abaŋka kəca nkɛ dec dɛŋkalɛ mɔ, cəloto ca saŋka sa ŋi cəbɔl cururu wəco kəcamət (50), mogbu ma ci wəco kɔ yɛcəmɛnɛ ya mi wəco. ");
INSERT INTO bsp_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Dowokulu d'abaŋka kəca nkɛ dec dɛmpɛ mɔ, pəmar dɔbɔl cururu wəco kəcamət (50). ");
INSERT INTO bsp_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Pəmar cəloto ca kəsək kin cəde cəyɔ dobolu da cururu wəco kɔ kəcamət (15), mogbu maas kɔ yɛcəmɛnɛ ya mi maas. ");
INSERT INTO bsp_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Padɛt sɔ cəloto cururu wəco kɔ kəcamət (15) cəlɔma kəca ka mɛrəŋ, mogbu maas kɔ yɛcəmɛnɛ ya mi maas. ");
INSERT INTO bsp_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pəmar paŋɛrɛ kusuŋka ka saŋka cəloto ca səbeŋa sa kentəler ca cururu wəco mɛrəŋ (20), yɛbəc yayɔkɔ yede yɔyɔnɛ ya wəcərɛ kədu pəlompsɛ ci səbeŋa sa alom ŋa məntambɛnc, sa alom ŋa bulu, sa alom ŋeyim, pəcəmbərɛ cəloto cəŋɛrɛ caŋkɔ mogbu maŋkəlɛ kɔ yɛcəmɛnɛ ya mi maŋkəlɛ. ");
INSERT INTO bsp_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mogbu mmɛ andecəmbərɛ saŋka mɔ fəp gbat-gbata ya mi yɔyɔnɛ gbeti. Ŋkora sɔ yɔyɔnɛ ya gbeti, kɔ yɛcəmɛnɛ ya mi yɔyɔnɛ ya kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Saŋka sasɔkɔ səbɔl cururu tasar tin (100), kɔ dowokulu da si cururu wəco kəcamət (50), kɔ deŋeci da si cururu kəcamət. Pəmar cəloto cacɔkɔ fəp cəyɔnɛ ca səbeŋa sa kentəler, kɔ yɛcəmɛnɛ ya kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kəyɛfɛ ka yosumpər-sumpər ya yɛbəc ya dəndo dəkiyi dosoku kəbəp ka cəgbo cədɔf ca saŋka fəp, pəmar palompsɛ yi fəp kɔpər.» ");
INSERT INTO bsp_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Kɔ məna Musa, məsom aka Yisrayel ŋakɛr'am moro mɔtɔt ma olif mɔfɔc, ntɛ tɔŋsɔŋɛ səlamp səctam kəmar dɔfɔy o dɔfɔy mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aruna kɔ awut ɔn arkun ŋandekɔcəmbər pɛdɛtɛ səlamp nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu nde todoru ta kəloto kəŋkɔ kəkəŋk kaŋkəra nkɛ kəmentər danapa dem k'aka Yisrayel mɔ. Pəmar səlamp sədekɔ səcmar MARIKI fɔr kiriŋ kəyɛfɛ dɔfɔy haŋ bətbət. Sariyɛ sa tɛm o tɛm sɔ, pəmar aka Yisrayel ŋade ŋacleləs si dɛtɛmp kɔ dɛtɛmp.» ");
INSERT INTO bsp_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kɔ MARIKI oloku Musa: «Məlɔtərnɛnɛ aYisrayel dacɔ nnɔ məyi mɔ wɛnc əm Aruna, k'awut ɔn arkun Nadab, Abihu, Elasar kɔ Itamar. Məgbɛy ŋa kɔ aka Yisrayel alpəs aŋɛ, ntɛ tɔŋsɔŋɛ ŋayɔn'em aloŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Məlompsɛ wɛnc əm Aruna yamos ya dəKanu, ntɛ tɔŋsɔŋɛ yede yecmentər dəkəcəmɛ kɔ delel dɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Məlok-lokər acɛrəŋ fəp, akɔ ilas kifir ka dɛcɛrəŋ mɔ: Ŋa ŋandelompsɛ Aruna yamos, nyɛ endebɛrnɛ k'ande pacsɔkəs kɔ-ɛ, a padeyɔnɛ oŋ wəloŋnɛ kem. ");
INSERT INTO bsp_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Yamos nyɛ yɔ pəmar ŋalompəs: Yuba yɛgbɛknɛ dɛbəkəc, duma da efɔd, burumus, duma dedisrɛ, kəfakəl, kɔ tabataba. Ŋalompsɛ wɛnc əm Aruna kɔ awut ɔn yamos ya dəKanu ntɛ tɔŋsɔŋɛ ŋade ŋacbəc em yɛbəc ya kəloŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Acərɛ kədu ŋalɛk kɛma, kəloto ka səbeŋa sa kentəler alom ŋa məntambɛnc, ŋa bulu, kɔ ŋeyim.» ");
INSERT INTO bsp_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Acɛrəŋ ŋadunɛ duma da efɔd kəloto ka səbeŋa sa kentəler, sa alom ŋa məntambɛnc, alom ŋa bulu kɔ ŋeyim kɔ səbeŋa sa kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Palompəs yeyesɛ banca mɛrəŋ, pasɔtərɛnɛ yi cəsək ca banca ya duma da efɔd. ");
INSERT INTO bsp_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Pasɔtərɛnɛ sɔ tabataba yɔyɔnɛ paka pin kɔ duma da efɔd. Tolompəs ta yi towurɛnɛ: Kəloto ka səbeŋa sa kentəler, səbeŋa sa alom ŋa məntambɛnc, sa alom ŋa bulu, kɔ alom ŋeyim kɔ səbeŋa sa kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Məlɛk sɔ walakɛ wa masar mɔtɔt ma onikəs mɛrəŋ nwɛ məndecic mewe ma awut a Yakuba mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Pacic mewe camət-tin tasar tɔcɔkɔ-cɔkɔ kəroŋ, kɔ mewe mɛlpəs mɔkɔ camət-tin sɔ tasar ta mɛrəŋ tɔkɔ kəroŋ, tɔkɔ ŋambɛkɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Masar mɛpat mamɔkɔ mɛrəŋ mɔyɔnɛ yɛbəc yɔtɔt, wəcərɛ kəpat pəpatəs tamp ta masar pəcicəs mi kəroŋ mewe ma awut a Yisrayel, pəbɛr mi fərɛm fa kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Məde məsɔtərɛnɛ masar mamɔkɔ mɛrəŋ yeyesɛ banca ya duma da efɔd kəroŋ, tɔyɔnɛ tɛcɛmcɛməs ta awut a Yisrayel (Yakuba). Ti disrɛ Aruna ende pəcdɛtərnɛ mewe mamɔkɔ dəbanca fɔr ya ina MARIKI kiriŋ ntɛ tɔŋsɔŋɛ iccɛm-cɛmnɛ nu tɛm fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Məlompsɛ fərɛm fafɔkɔ kɛma, ");
INSERT INTO bsp_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","mədu megbekce mɛrəŋ pəmɔ kəbənda yayɔkɔ sɔ kɛma kəsoku pɛs, nyɛ andekɔdɛtər fərɛm fafɔkɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Məlompəs yuba ya kiti yɛgbɛknɛ dɛbəkəc, pasɔtɛ yi kəloto ka səbeŋa sa kentəler, səbeŋa sa kɛma, səbeŋa sa alom ŋa məntambɛnc, alom ŋa bulu, alom ŋeyim pəmɔ tɔkɔ alompəs duma da efɔd mɔ. Yɛbəc ya wəcɛrəŋ yendeyi yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Panut ki kəmɛrəŋ, kəsək o kəsək kəyɔ dobolu da kəca disrɛ katin. ");
INSERT INTO bsp_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pəmar məcɛk kəloto kaŋkɔ kəroŋ masar momotər-motər cəgba maŋkəlɛ: Kəgba kəcɔkɔ-cɔkɔ kəyɔ tasar teyim, tasar p'alom ŋa cəbe, kɔ tasar pa alom ŋa bulu ŋɔnɔŋksəl pəbuk. ");
INSERT INTO bsp_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Kəgba ka mɛrəŋ kəyɔ masar momotər-motər mmɛ: Tasar teyim ceŋ, tasar t'alom ŋa bulu kɔ diyamaŋ. ");
INSERT INTO bsp_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Kəgba ka maas kəyɔ masar mmɛ: Tasar pa alom ŋa alembəra, tasar pa lom yɛla cəgbɛr kɔ tasar ta alom ŋa məntambɛnc. ");
INSERT INTO bsp_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Kəgba ka maŋkəlɛ kəyɔ masar mmɛ: Tasar ta alom ŋobuk mɛl, tasar ta lom yɛcɛmcɛmər kɔ tasar ta alom ŋobuk. Tasar o tasar məde məsɛtər pi dəfərɛm fa kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Pacic mewe ma awut a Yisrayel (Yakuba) masar mamɔkɔ wəco kɔ mɛrəŋ (12) kəroŋ pəmɔ tɔkɔ ancic tamp mɔ. Tasar o tasar tende kəcmentər tewe ta kusuŋka kin ncɛ wəco kɔ mɛrəŋ (12) dacɔ ca Yisrayel.» ");
INSERT INTO bsp_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Məde məlompsɛ yuba yɛgbɛknɛ dɛbəkəc megbekce ma kɛma kəsoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Məlompəs curundɛ mɛrəŋ ncɛ məŋkɔbɛr moŋkubut mɛrəŋ makəroŋ ma yuba yɛgbɛknɛ dɛbəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Məgbɛkər megbekce mamɔkɔ mɛrəŋ ma kɛma curundɛ cəkɔ cəyi dəmoŋkubut ma yuba yɛgbɛknɛ dɛbəkəc yayɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Məde məgbɛkər sɔ cəsək cəlpəs ca megbekce mamɔkɔ mɛrəŋ dəfərɛm mɛrəŋ nfɛ fəyi yeyesɛ banca ya duma da efɔd mɔ tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Məlompəs sɔ curundɛ mɛrəŋ ca kɛma ncɛ andekɔbɛr moŋkubut mantɔf ma yuba yɛgbɛknɛ dɛbəkəc, kəsək kaŋkɔ kəndekɔ kəcgbuŋɛnɛ duma da efɔd mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Məlompəs sɔ curundɛ mɛrəŋ cəlɔma ca kɛma ncɛ andekɔbɛr yeyesɛ banca ya duma da efɔd tantɔf mɔ tekiriŋ, dəkəsɔtərɛnɛ da yi pəsurɛnɛ kɔ takəroŋ ta tabataba ta duma da efɔd. ");
INSERT INTO bsp_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kəbənda ka alom ŋa məntambɛnc kɔ məŋkɔkotərɛnɛ curundɛ ca yuba yɛgbɛknɛ dɛbəkəc kɔ ca duma da efɔd, ntɛ tɔŋsɔŋɛ yuba yedeŋsɛ takəroŋ ta tabataba pa duma da efɔd, tɔsɔŋɛ sɔ yuba kətɔtam kəsakɛnɛ kɔ duma da efɔd mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ti tendesɔŋɛ Aruna kəbɛrɛ nde aŋgbip ŋosoku pəgbɛknɛ yuba ya kiti dɛbəkəc, nyɛ yɔyɔ mewe ma cusuŋka ca Yisrayel fəp mɔ. Ti tɔŋsɔŋɛ ina MARIKI kəccɛm-cɛmnɛ nu tɛm fəp.» ");
INSERT INTO bsp_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","«Məna Musa, mədekɔ məbɛr nde yuba ya kiti disrɛ masar ma kiti mɛrəŋ ‹Yurim› kɔ ‹Tumim,› ntɛ tɔŋsɔŋɛ meyi Aruna dɛbəkəc k'endebɛrɛ nde MARIKI fɔr kiriŋ-ɛ. Ti disrɛ Aruna ende kəcgbɛknɛ yi tɛm o tɛm k'endebɛrɛ nde MARIKI fɔr kiriŋ ntɛ tɔŋsɔŋɛ aka Yisrayel ŋacərɛ kiti kem mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Məde məlompsɛ burumus ba efɔd səbeŋa sa alom ŋa məntambɛnc fəp. ");
INSERT INTO bsp_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Dede dɔyɔ dəkəməl domp nde dacɔ da burumus babɔkɔ, pəmar pagbɛnt bi haŋ panɔŋkər, pəmɔ ntɛ andu yamos ya akata, ntɛ tɔŋsɔŋɛ ta bɛwalɛ mɔ. Yɛbəc ya wəcɛrəŋ kədu yendeyi. ");
INSERT INTO bsp_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Mədu burumus babɔkɔ tantɔf cəpare ca alom ŋa məntambɛnc, alom ŋa bulu k'alom ŋeyim. Məbɛrsər-bɛrsər haŋ mənɔŋkər meŋgbeŋkəle ma kɛma lulu ya cəpare dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Teŋgbeŋkəle pa kɛma pin kəpare kin, teŋgbeŋkəle pa kɛma pin kəpare kin y'aŋkɔbɛrsərɛnɛ burumus tantɔf haŋ panɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Duma dadɔkɔ dɔ Aruna ende kəcbɛrnɛ k'endekɔbəc'em yɛbəc ya wəloŋnɛ-ɛ. Dim da ŋgbeŋkəle dadɔkɔ d'ande kəcne k'endebɛrɛ nde aŋgbip ŋosoku fɔr ya MARIKI kiriŋ kɔ k'ende kəcwur di-ɛ, ti tɔŋsɔŋɛ kɔ kətɔfi.» ");
INSERT INTO bsp_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Məlompəs abɔpər ŋa kɛma kəsoku pɛs nŋɛ andecic ‹Dosoku da MARIKI› pəmɔ tɔkɔ ancic tamp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Məkotərɛnɛ abɔpər ŋaŋɔkɔ kəfakəl tekiriŋ kəbənda ka alom ŋa məntambɛnc. ");
INSERT INTO bsp_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Abɔpər ŋaŋɔkɔ aŋkotər Aruna dətobu mɔ ŋendesɔkəs yoloŋnɛ ya aka Yisrayel fəp, ntɛ tɔŋsɔŋɛ ina MARIKI ide icbaŋ kəpocɛ kəŋan, ali ŋacciya-ciya kəckɛr'em yopocɛ yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Duma dedisrɛ kɔ kəfakəl yɔ məndelompsɛ kəloto ka səbeŋa sa kentəler. Məlompsɛ kɔ sɔ tabataba, yɛbəc ya wəcɛrəŋ kədu yendeyi.» ");
INSERT INTO bsp_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Ntɛ tɔyɔnɛ ta awut arkun a Aruna mɔ, suma sədisrɛ s'andesɔtɛ ŋa, mabamaba kɔ cəfakəl nyɛ ŋande ŋacmentərɛ dəkəcəmɛ kɔ delel daŋan mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","«Kɔ məna Musa, mən'endebɛr wɛnc əm Aruna kɔ awut ɔn yamos yayɔkɔ, məbɔy ŋa moro dəsəbomp mədeŋər ŋa pɛsarɛ paŋan. Tatɔkɔ tɔ məndekɔ cəmbər ŋa dekiriŋ, ŋayɔnɛ afum asoku, ŋacbəc em oŋ yɛbəc ya aloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Məlompsɛ ŋa cɔgba ca kəloto ka səbeŋa sa kentəler ntɛ tɔŋsɔŋɛ ta ŋawur kəsɔkər mɔ, cɔgba cacɔkɔ cəcyɛfɛ ŋa dəfi haŋ nde dələŋk. ");
INSERT INTO bsp_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Cɔgba cacɔkɔ cɔ Aruna kɔ awut ɔn arkun ŋande ŋacbɛrnɛ kɔ ŋande kəcbɛrɛ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, kɔ pəyɔnɛ fɛ ti, kɔ ŋade kəclɔtərnɛ nde tetek toloŋnɛ-ɛ. Ti disrɛ ŋafɔdesarɛ kiciya nkɛ kəndedif ŋa mɔ. Sariyɛ sa tɛm o tɛm sɔ nnɔ Aruna kɔ yuruya yɔn ŋayi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Kɔ MARIKI oloku: «Ntɛ tɔ pəmar məna Musa məkɔ mədəs Aruna kɔ awut ɔn kəyɔnɛ afum asoku, ŋacbəc'em ŋayɔn'em aloŋnɛ: Məlɛk tura kɔ ŋkesiya yorkun nyɛ mɛrəŋ yɔtɔyɔ dolokəp, ");
INSERT INTO bsp_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","cəcom cətɔnɔŋkəl lebin, cəcom cəlok-lok cətɔyɔ lebin papɔckɛ ci moro, kɔ biskit bɔtɔyɔ lebin pasop bi moro, məlompsɛ cəcom cacɔkɔ fəp kəmbefe kətɔt ka bəle. ");
INSERT INTO bsp_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Məbɛr ci dəkəfala məkekərɛ kəfala kaŋkɔ, tura kɔ ŋkesiya yorkun mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Məlɔtərnɛnɛ Aruna kɔ awut ɔn arkun nde kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu tekiriŋ, məbiknɛnɛ ŋa domun. ");
INSERT INTO bsp_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Məde məlɛk yamos, məbɛr Aruna yamos: Duma dedisrɛ, burumus ba duma da efɔd, duma da efɔd, kɔ yuba yɛgbɛknɛ nyɛ məndekɔkotərɛnɛ dɛbəkəc kɔ tabataba pa duma da efɔd mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Məcəp kɔ kəfakəl, mədɛtər ki tekiriŋ tɔbɔpər tɛgbɛkərɛ ta dəKanu. ");
INSERT INTO bsp_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Məlɛk moro mɔbɔy mopusɛ, məloŋər kɔ mi dəromp, tɔyɔnɛ kədəs kɔ dekiriŋ da yɛbəc yem ya kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kɔ telip-ɛ, məwe sɔ awut arkun a Aruna ŋacɔŋnɛ, ŋa sɔ məbɛr ŋa suma sədisrɛ saŋan. ");
INSERT INTO bsp_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kɔ məlip-ɛ, məgbəncəs Aruna kɔ awut ɔn arkun mabamaba maŋan, məcəpəs ŋa cəfakəl. Ti disrɛ mədəs ŋa yɛbəc yem ya dəKanu tɔyɔnɛ oŋ sariyɛ sa kor kəŋan doru o doru. ");
INSERT INTO bsp_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Məlɔtərnɛnɛ tura papɔkɔ nde daŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Aruna kɔ awut ɔn arkun ŋadeŋər pi waca dəromp. ");
INSERT INTO bsp_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Məsu tɔbɔl məfay wana wawɔkɔ MARIKI fɔr kiriŋ ntende kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Mecir ma wi mɛbɛrɛ dətɔbɔl. ");
INSERT INTO bsp_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Məgbət tɛlər dəmecir ma tura papɔkɔ məsopət mi lɛn maŋkəlɛ ya moŋkubut ma tetek toloŋnɛ, məloŋ mecir mɛlpəs nde pɛcəmɛnɛ pa tetek tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Məlɛk moro mɔkɔ moŋkump yedisrɛ ya pɔcɔl papɔkɔ mɔ fəp, pəwotwotər pa mim, fi nyɛ mɛrəŋ kɔ moro ma yi, məkɔ məcɔf'em yi fəp nde tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Məcɔf sɛm, yedisrɛ ya aputuk kɔ akata ŋa tura yayɔkɔ dənɛnc saŋka todoru. Kəloŋnɛ kɔ nkɛ kəŋsɔŋɛ paŋaŋnɛnɛ aloŋnɛ kiciya kəŋan mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Kɔ telip-ɛ, nəkɛrɛ aŋkesiya ŋorkun ŋɔcɔkɔ-cɔkɔ, Aruna kɔ awut ɔn arkun ŋadeŋər ŋi waca dəromp. ");
INSERT INTO bsp_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Məsu tɔbɔl məfay aŋkesiya ŋaŋɔkɔ, məlɛk mecir mamɔkɔ məwɛsəsər cəsək ca tetek toloŋnɛ fəp haŋ mənɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Məcɛnəs aŋkesiya ŋorkun ŋaŋɔkɔ fəkəl fəkəl, məyak yedisrɛ ya ŋi kɔ wɛcək, məkɔ məboc yi fəkəl ya sɛm yayɔkɔ kɔ domp kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Məcɔfɛ MARIKI aŋkesiya ŋorkun fəp tetek toloŋnɛ kəroŋ. Pɔcɔl pɔcɔf pɔ, mpɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa pi ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","K'alip-ɛ, məkɛrɛ sɔ aŋkesiya ŋa mɛrəŋ ŋɔkɔ. Aruna kɔ awut ɔn arkun ŋadeŋər sɔ ŋaŋɔkɔ waca dəromp. ");
INSERT INTO bsp_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Məsu tɔbɔl məfay aŋkesiya ŋaŋɔkɔ. Məlɛk mecir ma ŋi məsop mi Aruna kɔ awut ɔn ləŋəs ya waca wɔtɔt, kɔ tɛlər tɔpɔŋ mpɛ o mpɛ pa waca waŋan wɔtɔt, kɔ tɛlər tɔpɔŋ mpɛ o mpɛ pa wɛcək waŋan wɔtɔt. Məlɛk mecir mɛlpəs, məwɛsəsər mi cəsək ca tetek toloŋnɛ fəp haŋ mənɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Məlɛk sɔ mecir mɔkɔ meyi tetek toloŋnɛ kəroŋ mɔ kɔ moro mɔbɔy məwɛsəsər mi Aruna kɔ yamos yɔn, məyɔ sɔ tin tayi awut ɔn kɔ yamos yaŋan. Kəlɛk dɔsɔk dadɔkɔ, Aruna kɔ awut ɔn ŋayɔnɛ oŋ aloŋnɛ apus em. ");
INSERT INTO bsp_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Məlɛk moro ma aŋkesiya ŋorkun, kəleŋa, moro mmɛ moŋkump yedisrɛ ya aŋkesiya mɔ, pəwotwotər pa mim, kɔ fi mɛrəŋ kɔ moro mmɛ moŋkump yi mɔ kɔ aləŋk ŋa kəcək kətɔt. Aŋkesiya ŋorkun ŋɛdəsɛ ŋa dekiriŋ da kəloŋnɛ ŋɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Məwurɛ cəcom cətɔyɔ lebin cəlɔma dəkəfala nkɛ ancəmbər MARIKI fɔr kiriŋ mɔ: Kəcom kəlok-lok kin, kəcom nkɛ anɔktərɛnɛ moro ma olif mɔ, kɔ biskit. ");
INSERT INTO bsp_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Məbɛr yi fəp Aruna dəwaca kɔ awut ɔn, mətubucnɛ kəsɔŋ yi ina MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kɔ telip-ɛ, məbaŋər ŋa yi dəwaca, məkɔ məcɔfɛ yi MARIKI nde dətetek poloŋnɛ kəroŋ. Ambɔnc ŋa yi ŋontorɛ-torɛ MARIKI abəkəc. Kəloŋnɛ kɔ, nkɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Məlɛk kəmpəcpəc ka aŋkesiya ŋorkun ŋa mɛrəŋ ŋɛdəsɛ ŋa Aruna dekiriŋ da kəloŋnɛ, mətubucnɛ kəsɔŋ ki MARIKI kəca kam pəmɔ tɔkɔ aŋsɔŋ fum paka mɔ, sɛm ya məna yɔ yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Məsɔkəs kəmpəcpəc nkɛ məndesɔŋ MARIKI pəmɔ tɔkɔ aŋsɔŋ fum daka mɔ. Məsɔŋ sɔ aləŋk ŋa aŋkesiya ŋorkun nŋɛ anafɛk teta kədəsɛ Aruna k'awut ɔn dekiriŋ da kəloŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Yopoc mɛrəŋ yayɔkɔ ya Aruna kɔ awut ɔn yɔ, tendeyɔnɛ sariyɛ sa tɛm o tɛm aka Yisrayel dacɔ. Bawo yopocɛ ya kəfɛk yayɔkɔ, yoloŋnɛ ya kəpaŋnɛ pəforu yɔ, nyɛ yɔyɔnɛ ya MARIKI mɔ. Mba Aruna k'awut ɔn ŋande ŋacsɔtər yi aka Yisrayel dəyoloŋnɛ yaŋan. ");
INSERT INTO bsp_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Kɔ Aruna efi-ɛ, yamos yɔn ya dəKanu yayɔkɔ wəlɔma aŋsɔŋ yi awut ɔn dacɔ, wəkakɔ sɔ pəbɛrnɛ yi dɔsɔk ndɛ ambɔy moro kədəs kɔ dekiriŋ da yɛbəc ya dəKanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Wəloŋnɛ wəkin awut ɔn dacɔ nwɛ andedəs dəkəcəmɛ da Aruna mɔ, ɛmbɛrnɛ yamos yayɔkɔ mata camət-mɛrəŋ, k'endebɛrɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ kəkɔbəc'em nde aŋgbip ŋosoku-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Məlɛk aŋkesiya ŋorkun nŋɛ ŋɔyɔnɛ ŋɛdəsɛ dekiriŋ da kəloŋnɛ mɔ, məpɛc sɛm yayɔkɔ kəfo kəsoku kəlɔma saŋka disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aruna kɔ awut ɔn arkun ŋasɔm sɛm yayɔkɔ, kɔ cəcom cəkɔ cəyi dəkəfala mɔ, nde kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ŋa gbəcərəm ŋɔ pəmar kəsɔm ka sɛm ya kəsɔkəs ka kiciya yayɔkɔ kɔ kəloŋnɛ ka kədəs dekiriŋ da kəloŋnɛ kem kɔ kəsɔkəs ka yi. Pəmar fɛ fum wəcuru pəsɔm sɛm yayɔkɔ, bawo yeri yosoku yɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kɔ pəyɔnɛ a sɛm ya yoloŋnɛ yayɔkɔ, kɔ pəyɔnɛ fɛ ti, cəcom cəlɔma cəncəmɛ haŋ bətbət-ɛ, məgbal yɛlpəs yɔkɔ dənɛnc. Pəmar fɛ pasɔm yi, bawo yeri yopus yɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Məyɔ Aruna kɔ awut ɔn arkun pəmɔ tɔkɔ isom əm ti mɔ fəp. Mata camət-mɛrəŋ mɔ məndedəs ŋa dekiriŋ da kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dɔsɔk o dɔsɔk mata camət-mɛrəŋ mamɔkɔ disrɛ pəmar məloŋnɛ tura pin teta kətubucnɛ ka kəsɔkəs ka kiciya. Ti tɔŋsɔŋɛ məsɔkəs tetek toloŋnɛ kətɔsɔk ka pi. Kɔ tencepər-ɛ, məloŋər moro tetek toloŋnɛ kəroŋ ntɛ tɔŋsɔŋɛ məpusɛ pi MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mata camət-mɛrəŋ mɔ mənde məctubucnɛ kəsɔkəs tetek toloŋnɛ teta kəpusɛ ka pi MARIKI. Itɔ tetek toloŋnɛ pɔŋyɔnɛ oŋ posoku pɛs mpɛ ampusɛ MARIKI mɔ, tɔcsɔŋɛ paka o paka pogbuŋɛnɛ pi, ampusɛ pi MARIKI. Kɔ tɔyɔnɛ fum pəgbuŋɛnɛ pi-ɛ, ɔŋyɔnɛ oŋ fum nwɛ ampusɛ MARIKI mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Dɔsɔk o dɔsɔk pəmar məde məcloŋnɛ oŋ tetek toloŋnɛ kəroŋ ŋkesiya yorkun mɛrəŋ ya teren tin tin. ");
INSERT INTO bsp_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Aŋkesiya ŋin bətbət bɔ məŋloŋnɛ ŋi, aŋkesiya ŋa mɛrəŋ dɔfɔy dɔ məŋloŋnɛ ŋi. ");
INSERT INTO bsp_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Aŋkesiya ŋɔcɔkɔ-cɔkɔ pacɔfɛ ŋi MARIKI kɔ kəmbefe kətɔt kilo kəmaas nkɛ ampɔckɛ moro mɔtɔt ma olif litɛr din kɔ dacɔ mɔ, məloŋər ki wɛn litɛr din kɔ dacɔ teta kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kɔ dɔfɔy dɛmbəp-ɛ, məkɛr'em sɔ aŋkesiya ŋa mɛrəŋ mədeŋər ŋi kəloŋnɛ ka mɛŋgbɛn kɔ ka wɛn pəmɔ tɔkɔ məkɛr'em bətbət mɔ. Yoloŋnɛ yɔ, nyɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa yi ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Tekiriŋ oŋ, dɛtɛmp o dɛtɛmp dende kəcloŋn'em kəloŋnɛ ka kəcɔf pɔcɔl nde kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, fɔr ya MARIKI kiriŋ. Difɔ indekɔ icbəpɛnɛ kɔ nəna a iclok-lokər əm di. ");
INSERT INTO bsp_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Difɔ indekɔ icbəpɛnɛ k'aka Yisrayel, nɔrɔ da debeki dem dende docpus di. ");
INSERT INTO bsp_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ina MARIKI in'endesɔpus aŋgbancan ŋɛbəpɛnɛ kɔ tetek toloŋnɛ, ipus sɔ Aruna kɔ yuruya yɔn ntɛ tɔŋsɔŋɛ ŋade ŋayɔnɛ aloŋnɛ em. ");
INSERT INTO bsp_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Indendɛ aka Yisrayel dacɔ, iyɔnɛ Kanu kəŋan. ");
INSERT INTO bsp_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Aka Yisrayel ŋandecərɛ a in'ɔyɔnɛ MARIKI Kanu kəŋan, ina nwɛ inawurɛnɛ ŋa atɔf ŋa Misira, idendɛ ŋa dacɔ mɔ. In'ɔyɔnɛ MARIKI, Kanu kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Məde məlompəs tetek pɔcɔfɛ MARIKI suray. Kətɔk ka kasiya kɔ məndelompsɛ pi. ");
INSERT INTO bsp_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Dobolu da tetek papɔkɔ dɔyɔ kururu katin, kɔ dowokulu da pi kururu katin, pəndetəŋnɛnɛ cəsək fəp. Deŋeci da pi dɔyɔ cururu mɛrəŋ, tetek papɔkɔ kɔ lɛn ya pi yɛtəpərɛnɛ yɔyɔnɛ paka pin. ");
INSERT INTO bsp_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Məsop pi kɛma kəsoku pɛs, kəlɛk amɛsa ŋa pi kəroŋ kəbəp ka cəsək ca pi kəkɔ haŋ lɛn ya pi. Məlompəs pi kəbər ka kɛma cəsək haŋ mənɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Məlompəs cəsora mɛrəŋ ca kɛma, məbɛr ci kəbər tantɔf ka cəsək mɛrəŋ ca tetek papɔkɔ. Cəsora cacɔkɔ cɔ andekɔ pacsor cəgbo, ntɛ tɔŋsɔŋɛ pactam kəsɛlɛŋ pi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Məde məpat cəgbo ca kətɔk ka kasiya, məsop ci kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Məkɔ məcəmbər tetek papɔkɔ tekiriŋ ta kəloto kəkəŋkɛ kaŋkəra nkɛ kəyɔ walakɛ nwɛ wementər danapa dem kɔ aka Yisrayel mɔ. Afɛŋk ŋɔsɔksɛ kiciya nŋɛ aŋgbəpər kaŋkəra kəroŋ mɔ, difɔ səndekɔ səcbəpɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Bətbət o bətbət Aruna pədekɔ pəccɔf'em di suray k'ende kəclompəs səlamp-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aruna pədekɔ pəccɔf suray səbotu ambɔnc sasɔkɔ k'endekɔ pəcmot səlamp dec dɔrɔfɔy-ɛ. Pəmar pade paccɔf suray sasɔkɔ dɛtɛmp kɔ dɛtɛmp donu. ");
INSERT INTO bsp_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Tetek tɔ ntɛ pəntɔmar nəde nəccɔfɛ di MARIKI suray səcuru mɔ, pəmar fɛ nəcloŋnɛ di yɔcɔl yɔcɔf, ta nəcloŋnɛ di sɔ kəloŋnɛ ka mɛŋgbɛn, afɔde pacloŋər di wɛn wa kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Katin gboŋ teren disrɛ tɔ Aruna ende pəctubucnɛ kəsɔkəs kiciya lɛn ya tetek toloŋnɛ kəroŋ. Dɛtɛmp kɔ dɛtɛmp ende pəctubucnɛ kəsɔksɛ tetek mecir ma pɔcɔl pa kəloŋnɛ ka kiciya katin teren o teren. Tetek tosoku pɛs pɔ pɔyɔnɛ oŋ, mpɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Kɔ məndekɔlip kəlɔm aka Yisrayel fəp-ɛ, nwɛ o nwɛ pəfɛkɛ MARIKI gbeti kəway ka kəyi kɔn doru, ntɛ tɔŋsɔŋɛ ta docu ndɛ o ndɛ dosumpər ŋa tɛm ta kəlɔm mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Afum aŋɛ andekɔlɔm mɔ fəp, ntɛ tɔ ŋandekɔfɛk: Gbeti gbəleŋ kəram kəcamət pəmɔ potubuc pa nde aŋgbip ŋosoku mpɛ pɔyɔnɛ kəram wəco mɛrəŋ (20) mɔ. Ina MARIKI andefɛkɛ gbeti babɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Nwɛ o nwɛ andekɔlɔm nwɛ ɔsɔtɔ meren wəco mɛrəŋ (20) mɔ, haŋ kəpɛ takəroŋ fəp faŋan ŋafɛkɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Wəka daka ɔfɔla wətɔyɔ daka kəfɛk kaŋkɔ, fəp faŋan ŋandetəŋnɛnɛ kəfɛk nwɛ o nwɛ endefɛkɛ MARIKI gbɛti gbəleŋ kəcamət, ntɛ tɔŋsɔŋɛ ŋawurusnɛ kəyi kəŋan doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kɔ məlip kəbaŋəs kəfɛk kaŋkɔ-ɛ, məde məclompsɛ gbeti babɔkɔ mes ma aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Ti tende kəcsɔŋɛ MARIKI kəcɛm-cɛmnɛ aka Yisrayel pəcyac ŋa teta kəwurus kəyi kəŋan doru. ");
INSERT INTO bsp_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Məsɛl kəsamp ka kɔpər, kɔ pɛcəmɛnɛ pa ki sɔ pəyɔnɛ kɔpər, məbɛr kəsamp kaŋkɔ domun ndɛ aloŋnɛ ŋande ŋacsɔkəsnɛnɛ mɔ, məkɔ məcəmbər kəsamp kaŋkɔ tetek toloŋnɛ kɔ aŋgbancan ŋɛbəpɛnɛ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Kəsamp kaŋkɔ kɔ Aruna kɔ awut ɔn arkun ŋande ŋackɛt domun ndɛ ŋande ŋacbiknɛnɛ waca kɔ wɛcək mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kɔ ŋambɛrɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ-ɛ, domun dadɔkɔ dɔ ŋande kəcbikɛnɛ, ti tɔŋsɔŋɛ ta ŋafi-ɛ. Tin tayi tɔ kɔ ŋande kəckɔ kəlɔtərnɛ tetek toloŋnɛ kəkɔbəc kɔ kəcɔfɛ MARIKI yoloŋnɛ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Wɛcək kɔ waca wɔ pəmar ŋacbikɛnɛ, ntɛ tɔŋsɔŋɛ ta ŋafi mɔ. Sariyɛ sa tɛm o tɛm sɔ, nnɔ Aruna kɔ yuruya yɔn ŋayi mɔ dɛtɛmp kɔ dɛtɛmp. ");
INSERT INTO bsp_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Məna məlɛk suray səbotu ambɔnc: Kəlɔl ka kətɔk nkɛ aŋwe mir mɔ kilo kəcamət, pol ya kətɔk kəbifəli nkɛ aŋwe sinamɔn mɔ kilo mɛrəŋ kɔ dacɔ, kɔ kilo mɛrəŋ kɔ dacɔ ka awo ŋɔlɔma nŋɛ ŋɔmbɔt ambɔnc mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kɔ kətɔk ka kasiya kəbifəli kilo kəcamət pəmɔ potubuc pa nde aŋgbip ŋosoku, kɔ moro ma olif litɛr camət-tin. ");
INSERT INTO bsp_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Məlompsɛ yi moro mɔbɔy mopus ma dəKanu: Pagbuluŋ mi labundɛ, tɔyɔnɛ yɛbəc ya wəcərɛ kəlompəs labundɛ. Moro mopus mɔ mmɛ ande pacbɔy nde dəKanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Moro mamɔkɔ mɔ mənde məcbɔy aŋgbancan ŋɛbəpɛnɛ kɔ Kanu kɔ kaŋkəra nkɛ kəyɔ walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","kəbəp ka amɛsa kɔ yosumpər-sumpər ya ŋi fəp, pɛdɛtɛ səlamp kɔ yosumpər-sumpər ya pi, tetek pɔcɔfɛ MARIKI suray, ");
INSERT INTO bsp_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","tetek toloŋnɛ yɔcɔf kɔ yosumpər-sumpər ya pi, kəsamp kɔ pɛcəmɛnɛ pa ki. ");
INSERT INTO bsp_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Məpusɛ MARIKI ca cacɔkɔ, yendeyɔnɛ ca cəpus yosoku pɛs, tɔsɔŋɛ paka mpɛ o mpɛ kɔ pəyɔnɛ fɛ ti fum nwɛ o nwɛ oŋgbuŋɛnɛ ca cacɔkɔ mɔ, ɔŋyɔnɛ oŋ fum nwɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Məbɔy sɔ Aruna moro mamɔkɔ kɔ awut ɔn kədəs ŋa dekiriŋ da kəloŋnɛ, məpus ŋa ntɛ tɔŋsɔŋɛ ŋacbəc'em oŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Məloku aka Yisrayel: Moro mɔbɔy mopus ma ina MARIKI mɔ, dɛtɛmp kɔ dɛtɛmp donu. ");
INSERT INTO bsp_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ali fum ɔfɔsopɛ mi dəris tatɔkɔ kifəli, ali fum pəmar fɛ sɔ pəlompəs moro mowurɛnɛ ma mamɛ. Moro mɔ mmɛ ambɔy kəpus ka aloŋnɛ aŋɛ andəs dekiriŋ da yɛbəc ya dəKanu mɔ. Moro mopus mɔ mmɛ pəmar aka Yisrayel ŋaleləs MARIKI fɔr kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nwɛ o nwɛ olompəs moro mowurɛnɛ ma mi, pəsop mi wətɔyɔnɛ wəloŋnɛ mɔ, aŋwurɛ wəkayi aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kɔ MARIKI oloku Musa: Məlɛk ca cəbotu ambɔnc: Stakte, onikəs kɔ kalbanɔŋ, mənɔŋkəl yi kɔ suray sətɔt sa kəlɔl ka kətɔk, yɛtəŋnɛnɛ dɛlay. ");
INSERT INTO bsp_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Wəcərɛ kəlompəs labundɛ pənɔŋkəl suray sasɔkɔ mɛr, ntɛ tɔŋsɔŋɛ pəsɔtɔ suray sətɔt kɔ səsoku nsɛ ampusɛ yɛbəc ya dəKanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Pabifəli suray səlɔma, nsɛ andekɔboc nde kaŋkəra nkɛ kəyɔ walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel mɔ tekiriŋ ta nde aŋgbancan disrɛ kəfo nkɛ səndekɔ səcbəpɛnɛ mɔ. Suray sosoku sɔ nsɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Pəmar fɛ nəde nəclompəs suray səwurɛnɛ sa saŋsɛ nsɛ afum ŋaŋsopɛ kifəli mɔ, pəmar səyɔnɛ nu səpusɛ fum nwɛ andəs dekiriŋ da yɛbəc ya MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nwɛ o nwɛ olompəs suray pəmɔ saŋsɛ, teta kəne ka si ambɔnc ŋobotu mɔ, aŋwurɛ wəkayi aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Mənəŋk iwe Betsalel tewe tɔn, wan ka Uri, wansɔ ka Hur, wəka kusuŋka ka Yuda. ");
INSERT INTO bsp_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ilas kɔ amera ŋa Kanu ntɛ tɔŋsɔŋɛ pəcɛrŋɛ, pəsɔk domp, pəcərɛ yɛbəc fəp mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ɛncərɛ kəpər yɛbəc ya kɛma, ya gbeti kɔ ya kɔpər, ");
INSERT INTO bsp_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kəpat ka masar momotər-motər kɔ kəsɛt mi dəfərɛm, kəpat ka tɔk, kɔ dɛcɛrəŋ da yɛbəc fəp. ");
INSERT INTO bsp_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Isɔŋ kɔ wəmar nwɛ ɔyɔnɛ Oholiyab wan ka Ahisamak wəka kusuŋka ka Dan, k'isɔŋ sɔ afum alɔma dɛcɛrəŋ. Ŋa ŋ'andekɔbɛrɛnɛ kəbəc ka tɔkɔ isom əm mɔ fəp: ");
INSERT INTO bsp_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Kəyɛfɛ ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu kəbəp ka kaŋkəra nkɛ kəyɔ walakɛ nwɛ wementər danapa da MARIKI k'aka Yisrayel mɔ, kəkɔ afɛŋk ŋɔsɔksɛ kiciya, kɔ yosumpər-sumpər ya aŋgbancan, ");
INSERT INTO bsp_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","kəlɛk amɛsa kɔ yosumpər-sumpər ya ŋi, pɛdɛtɛ səlamp pa kɛma kəsoku pɛs, kəbəp ka yosumpər-sumpər ya pi, tetek pɔcɔfɛ MARIKI suray, ");
INSERT INTO bsp_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","tetek toloŋnɛ pa pɔcɔl pɔcɔf kɔ yosumpər-sumpər ya pi, kəsamp kɔ pɛcəmɛnɛ pa ki, ");
INSERT INTO bsp_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","yamos ya dəKanu ya Aruna wəloŋnɛ kɔ yuruya yɔn nyɛ ŋande kəcbɛrnɛ kɔ ŋandebəc'em-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Moro mɔbɔy kɔ labundɛ dobotu ambɔnc da aŋgbip ŋosoku, acɛrəŋ ŋalompəs yi pəmɔ tɔkɔ isom əm ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Məloku aka Yisrayel: Nəde nəcleləs dɔsɔk da kəŋesəm dem, tendeyɔnɛ ina kɔ nəna aka Yisrayel dacɔ tɛgbɛkərɛ haŋ dɛtɛmp kɔ dɛtɛmp da yuruya yonu, ti tendesɔŋɛ ŋacərɛ a in'ɔyɔnɛ MARIKI mmɛ mɔŋsɔkəs nu, nəyɔnɛ afum aŋɛ ampus'em mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Nəde nəcleləs dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ, bawo dɔsɔk dopus dɔ nnɔ nəyi mɔ. Nwɛ o nwɛ ɔntɔleləs di mɔ, andif kɔ. Fum nwɛ o nwɛ ɛmbəc tɛbəc dɔsɔk dadɔkɔ mɔ, aŋwurɛ kɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nəde nəcbəc mata camət-tin, mba simiti tataka ta camət-mɛrəŋ tɔyɔnɛ dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ. Fum nwɛ o nwɛ ɛmbəc dɔsɔk da kəŋesəm dadɔkɔ mɔ, andif kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Pəmar aka Yisrayel ŋaleləs dɔsɔk da kəŋesəm. Ŋacəmɛ sariyɛ sa di darəŋ dɛtɛmp kɔ dɛtɛmp, tɔyɔnɛ tɛcaŋsɛ ta danapa da tɛm o tɛm. ");
INSERT INTO bsp_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Tɛgbɛkərɛ tantɛ tendeyi oŋ ina k'aka Yisrayel dacɔ tɛm o tɛm. Bawo mata camət-tin mɔ MARIKI ɛnabəc antɔf kɔ kɔm, tataka ta camət-mɛrəŋ k'ɛsak yɛbəc, k'eŋesəm.» ");
INSERT INTO bsp_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ntɛ MARIKI elip kəlok-lokər Musa nde tɔrɔ ta Sinayi mɔ, k'ɔsɔŋ Musa walakɛ wa masar mɛrəŋ nwɛ wementər danapa dɔn kɔ aka Yisrayel mɔ, nwɛ MARIKI ɛnacicɛ mɛlər mɔn yati mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kɔ aka Yisrayel ŋanəŋk ntɛ Musa oncwon kətor kəyɛfɛ ka nde tɔrɔ kəroŋ mɔ. Awa, k'afum ŋaŋkɔ ŋaloŋkanɛ nnɔ Aruna eyi mɔ, kɔ ŋaloku: «Məlompsɛ su canu cəkɔt su fɔr kiriŋ, bawo Musa fum wəkawɛ ɛmpɛnɛ su Misira mɔ, səncərɛ fɛ ntɛ tɔsɔtɔ kɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Kɔ Aruna oloku ŋa: «Nəwurɛ yadələŋəs ya kɛma nyɛ aran anu, awut anu arkun kɔ aran, ŋambɛrəsnɛ mɔ, nəkɛr'em yi.» ");
INSERT INTO bsp_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","K'afum aka Yisrayel fəp ŋawurɛ-wurɛ yadələŋəs ya kɛma nyɛ ŋanabɛrəsnɛ dələŋəs mɔ, kɔ ŋasɔŋ yi Aruna. ");
INSERT INTO bsp_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kɔ Aruna ɛmbaŋsər ŋa yi dəwaca, k'ɛŋgbɛcɛ tɛrəŋka ta tura towut anata. K'aka Yisrayel ŋaloku: «Kanu kam kɔ kaŋkɛ, Yisrayel, nkɛ kəmpɛn'am atɔf ŋa Misira mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ntɛ Aruna ɛnəŋk ti mɔ, k'olompəs tetek toloŋnɛ tura tatɔkɔ tekiriŋ. K'oŋkulɛ: «Alna ambocɛ MARIKI kəsata!» ");
INSERT INTO bsp_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Dɔckɔsɔk k'aka Yisrayel ŋayɛfɛ bətbət suy kɔ ŋaŋkɛrɛ yoloŋnɛ yɔcɔf kɔ yoloŋnɛ ya kəpaŋnɛ pəforu. Kɔ ŋandɛ, ŋandi yeri, ŋamun, kɔ ŋayɛfɛ kəwoləs-woləs. ");
INSERT INTO bsp_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Kɔ MARIKI oloku Musa: «Mətor katəna katəna, bawo afum am aŋɛ məsolɛ kəwurɛnɛ atɔf ŋa Misira mɔ, ŋanciya pəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ŋambɛlkər kəgbaymɛ dɔpɔ dɔkɔ imentər ŋa mɔ. Tɛrəŋka ta tura ta afɛc tɔ ŋalompəs, kɔ ŋantontnɛnɛ pi, kɔ ŋaloŋnɛnɛ pi, haŋ kɔ ŋaloku: ‹Canu conu cɔ cancɛ Yisrayel ncɛ cəwurɛnɛ nu atɔf ŋa Misira mɔ!›» ");
INSERT INTO bsp_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Kɔ MARIKI oloku Musa: «Awa, inəŋk ntɛ afum akaŋɛ ŋayi mɔ, ataŋi ləŋəs ŋɔ ŋayɔnɛ fəp faŋan. ");
INSERT INTO bsp_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ndɛkəl oŋ məc'em, kətɛl'em kɔ pənder nnɔ ŋayi mɔ, kəmələk ŋa k'inder fəp faŋan, mba məna indesɔŋ'am kəyɔ yuruya yɛlarəm məyɔnɛ wəka atɔf ŋɔpɔŋ.» ");
INSERT INTO bsp_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Kɔ Musa ɛlɛtsɛnɛ MARIKI Kanu kɔn kəŋaŋnɛ, k'oloku kɔ: «MARIKI, ta ake tɔ pəntɛlɛn'am nda afum am-ɛ, aŋɛ məwurɛnɛ Misira fənɔntər fam fəpɔŋ kɔ sɔkət sa kəca kam mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Tendesɔŋɛ aka Misira ŋandeloku: «Kəyɔ kəŋan pəlɛc kɔ MARIKI owurɛnɛ aka Yisrayel atɔf ŋa Misira, kəkɔdif kəŋan nde dəmɔrɔ, pəmələk ŋa, pənim ŋa antɔf kəroŋ!» Mətorɛ abəkəc ta məyɔ ti, məbupərɛ kəyɔ ka afum am pəlɛc! ");
INSERT INTO bsp_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Məcɛm-cɛmnɛ Abraham, Siyaka kɔ Yakuba, acar am aŋɛ mənaloku, məcdɛrəm mənasərka: «Indesɔŋɛ afum am kəla pəmɔ cɔs ca darenc. Indesɔŋ yuruya yam atɔf ŋaŋɛ fəp nŋɛ iloku ta ŋi mɔ, ŋɔyɔnɛ oŋ kɛ kəŋan doru o doru.» ");
INSERT INTO bsp_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kɔ MARIKI ombupərɛ sɔ pəlɛc pɔkɔ ɛnacɛm-cɛmnɛ kəyɔ afum ɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kɔ Musa ontor kəyɛfɛ ka tɔrɔ kəroŋ, pətɔmpər walakɛ nwɛ mɛrəŋ, pacicəs wi bəkəc yayi mɛrəŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Walakɛ wawɔkɔ mɛrəŋ, yɛbəc ya Kanu yɛnayi, nkɔn Kanu ɛnacicəs wi kəroŋ kəca kɔn. ");
INSERT INTO bsp_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ntɛ Yosuwe ene aka Yisrayel kəkulɛ-kulɛ mɔ, k'oloku Musa: «Sim sa kəwan s'iŋne saŋsɛ nde saŋka disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Kɔ Musa oloku kɔ: «Ala bafɔ sim sa kəsɔtɔ kətam ka kəyɛfərɛnɛ sɔ, bafɔ sim sa kəpariya kəyɛfərɛnɛ sɔ ina iyi kəne. Sim sa kəsata sɔ ina iyi kəne.» ");
INSERT INTO bsp_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ntɛ ɔlɔtərnɛ saŋka mɔ, k'ɛnəŋk tɛrəŋka ta tura towut, k'ɛnəŋk sɔ afum ŋacpisɛ. Awa, kɔ pəntɛlɛ Musa, k'ɛŋgbal walakɛ wa masar wawɔkɔ ɛnatɔmpər mɔ, kɔ wɔŋkɔ wɛwɛslɛ-wɛslɛ nde tɔrɔ dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kɔ Musa ɛlɛk tɛrəŋka tatɔkɔ ŋanalompəs mɔ, k'ɔŋkɔ pəbɛr pi dənɛnc. Kɔ Musa embifəli yɛlpəs yɔkɔ yɛnacəmɛ mɔ, k'ɛlɛk yi k'ɛŋgbal dəromun ndɛ ɛnasɔŋ aka Yisrayel kəmun mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kɔ Musa ɛŋkafəlɛ nnɔ Aruna eyi mɔ, k'eyif kɔ: «Cəke cɔ aka Yisrayel ŋayɔ əm ntɛ məsɔŋɛ ŋa kiciya kəpɔŋ kaŋkɛ mɔ?» ");
INSERT INTO bsp_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Kɔ Aruna oloku: «Ta pətɛl'am, mariki mem! Məna yati məncərɛ aka Yisrayel: Ŋambɔtər mes mɛlɛc. ");
INSERT INTO bsp_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ŋa ŋalok'im: ‹Məlompsɛ su canu ncɛ cəndekɔt su kiriŋ mɔ, bawo səncərɛ fɛ ntɛ tɔsɔtɔ Musa nwɛ ɛnawurɛnɛ su atɔf ŋa Misira mɔ.› ");
INSERT INTO bsp_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","K'iloku ŋa a nwɛ o nwɛ ɔŋyɔ peyesnɛnɛ pa kɛma mɔ pəwurɛ pi! Kɔ ŋasɔŋ im yi, k'imbɛr yi dənɛnc, kɔ tura towut tantɛ towur di disrɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Kɔ Musa ɛnəŋk ntɛ antɔsɔtam kədusum afum mɔ, bawo Aruna ɛnasak ŋa ŋacyɔ tɔkɔ ŋafaŋ mɔ, kɔ tɔsɔŋɛ ŋa kəyɔ tɔkɔ tɛŋlapəs ŋa nnɔ aterɛnɛ aŋan ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kɔ Musa ɔŋkɔ pəcəmɛ dəkusuŋka da saŋka, k'oloku: «Nəna aŋɛ nəyinɛ MARIKI mɔ, nəder nnɔ iyi mɔ!» K'aka kusuŋka ka Lewy fəp ŋaŋkɔ ŋamɛpnɛ Musa dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kɔ Musa oloku ŋa: «Ntɛ tɔ MARIKI, Kanu ka Yisrayel kəloku: ‹Nwɛ o nwɛ pəlɛk dakma dɔn, pəcop nnɔ dəkusuŋka da saŋka haŋ dəkələpsər da si, kədifət awɛnc anu, anapa anu k'akomɛnɛ anu.›» ");
INSERT INTO bsp_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Dɔsɔk dadɔkɔ k'aLewy ŋaleləs dim da Musa, kɔ tɔsɔŋɛ aka Yisrayel afum wul maas (3.000) kəfi. ");
INSERT INTO bsp_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kɔ Musa oloku aLewy: «Kəyɛfɛ mɔkɔ andəs nu nəyɔnɛ oŋ afum aŋɛ ŋandeyi yɛbəc ya MARIKI mɔ, bawo nənesərnɛ fɛ kədif ka awut anu kɔ awɛnc anu aŋa. MARIKI pəpocɛ nu mɔkɔ pətɔt!» ");
INSERT INTO bsp_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Dɔckɔsɔk, kɔ Musa oloku aka Yisrayel: «Nənciya pəpɔŋ! Ndɛkəl oŋ kəpɛ k'inder nde MARIKI eyi mɔ. Tɔlɔma ikɔtam kəsɔtər kɔ kəsɔkəs ka kiciya konu.» ");
INSERT INTO bsp_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kɔ Musa oluksərnɛ nde MARIKI eyi mɔ, k'oloku: «Məŋaŋnɛ MARIKI! Afum akaŋɛ ŋanciya pəpɔŋ, ŋalompəs canu ca kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Məŋaŋnɛnɛ ŋa kiciya kəŋan, ilɛtsɛn'am! Kɔ məyɔ fɛ ti-ɛ, mənim ina tewe nde buk bɔkɔ mənacic mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Kɔ MARIKI oloku Musa: «Fum nwɛ enciy'em mɔ, iŋliŋ tewe tɔn buk bem disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ndɛkəl oŋ, məkɔ, məsolɛ afum am məkekərɛ ŋa kəfo nkɛ imentər əm mɔ. Mɛlɛkɛ mem mendekɔ yi nu kiriŋ, mba dɔsɔk ndɛ inder kəbocɛ nu kiti nde nəyi mɔ, indesɔŋ ŋa ayɛk ŋa kiciya kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kɔ MARIKI osut aka Yisrayel, bawo ŋanacəmɛ Aruna darəŋ, a wəkakɔ pəlompsɛ ŋa tɛrəŋka ta tura towut. ");
INSERT INTO bsp_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kɔ MARIKI oloku Musa: «Nəyɛfɛ kəfo kaŋkɛ, məna k'aka Yisrayel aŋɛ məmpɛnɛ atɔf ŋa Misira mɔ. Nəkɔ nde atɔf ŋɔkɔ inadɛrmɛ Abraham, Siyaka, kɔ Yakuba mɔ, icloku: ‹Indesɔŋ ŋi yuruya yam.› ");
INSERT INTO bsp_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Indesak mɛlɛkɛ meyi nu kiriŋ, indekɔbɛləs aKanaŋ, aMɔr, aHit, aPerisi, aHiwy, kɔ aYebus, ");
INSERT INTO bsp_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","atɔf ŋaŋɔkɔ ŋomboŋ dalɛ k’awop mɔ. Mba ifɔdesolɛ nu inasərka, iŋnesɛ ta idekɔlip nu kədifət, bawo afum ataŋi ləŋəs ŋɔ nəyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ntɛ aka Yisrayel ŋane moloku mebeŋəsnɛnɛ mamɔkɔ mɔ, kɔ ŋanɔnɛ mi kəbal, nwɛ o nwɛ ɛnayesnɛ fɛ sɔ. ");
INSERT INTO bsp_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kɔ MARIKI oloku Musa: «Məloku aka Yisrayel: Afum ataŋi ləŋəs ŋɔ nəyɔnɛ. K'isolɛ nu kəkɔ tɛm tepic gbəcərəm-ɛ, iŋmələk nu dɔpɔ. Nəwurɛ yeyesnɛnɛ yonu indemɔmən ntɛ indeyɔ nu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ti disrɛ, k'aka Yisrayel ŋaŋgbek-gbeki yeyesnɛnɛ yaŋan fəp kəyɛfɛ ka tɔrɔ ta Horɛb. ");
INSERT INTO bsp_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kɔ Musa ɛlɛk aŋgbancan k'ɛncəmbər ŋi nkɔnsərka saŋka todoru pəwak kəbɔlɛnɛ ŋi. K'ewe di «Aŋgbancan ŋɛbəpɛnɛ kɔ Kanu.» Nwɛ o nwɛ ɛncfaŋ tes nnɔ MARIKI eyi mɔ, mɛnɛ wəkayi pəwur saŋka disrɛ pəder nde aŋgbancan ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kɔ Musa ende kəcwur kəkɔ daŋgbancan-ɛ, aka Yisrayel fəp ŋaŋyɛfɛ. Ŋacəmɛ-cəmɛ cusuŋka ca cəbal cəŋan ŋagbətnɛ kɔ haŋ pəbɛrɛ aŋgbancan ŋaŋɔkɔ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kɔ Musa elip kəbɛrɛ aŋgbancan ŋaŋɔkɔ disrɛ-ɛ, acul ŋa kəp ŋotor ŋɛcəmɛ dəkusuŋka da aŋgbancan ŋaŋɔkɔ, MARIKI pəlok-loku kɔ Musa. ");
INSERT INTO bsp_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","K'aka Yisrayel fəp ŋanəŋk tɔkɔ kəp kənccəmɛ kəsuŋka ka aŋgbancan mɔ, ŋayɛfɛ fəp faŋan ŋatontəsnɛ nwɛ o nwɛ nde kusuŋka ka abal ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","MARIKI pəlok-lokər Musa ŋatɛfərɛnɛ, pəmɔ ntɛ fum endelok-lokər wanapa kɔn mɔ. Kɔ telip-ɛ, Musa pəlukus nde dəsaŋka. Mba wəmarsɛnɛ kɔn wətɛmp Yosuwe wan ka Nun ɛncyɛfɛ fɛ aŋgbancan ŋaŋɔkɔ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kɔ Musa oloku MARIKI: «Məmɔmən, məlok'im: ‹Məsolɛ aka Yisrayel,› mba məmentər f'em fum nwɛ məyi kəsom kədemar im mɔ. Ti disrɛ məloku: ‹Incərɛ tewe tam, k'iyɛk-yɛk əm, kɔ kəmar ka kəbɔtər kem kəmbəp əm.› ");
INSERT INTO bsp_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ndɛkəl oŋ ilɛtsɛn'am, kɔ pəyɔnɛ a məmar im teta kəbɔtər kam-ɛ, məsɔŋ'em kəcərɛ səpɔ sam. Tɔŋsɔŋ'em kəcər'am, tɔsɔŋ'em sɔ kəmar ka kəbɔtər kam kəsol'em. Məmɔmən afum a atɔf ŋaŋɛ, akam ŋɔ!» ");
INSERT INTO bsp_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Kɔ MARIKI oloku Musa: «Inasərka, in'endekɔ kɔ məna! Isɔŋ əm sɔ pəforu.» ");
INSERT INTO bsp_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kɔ Musa oloku: «Kɔ pəyɔnɛ a məfɔkɔ-ɛ, ta məsɔŋɛ su kəpɛ nnɔ de. ");
INSERT INTO bsp_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Cəke c'andetam kəcərɛ a məyɛk-yɛk su ina kɔ afum am-ɛ? Kəyi kam su dacɔ gbəcərəm kəntam kəmentər kəgbɛy kosu kɔ afum alpəs aka doru.» ");
INSERT INTO bsp_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Kɔ MARIKI oloku Musa: «Indeyɔ tɔkɔ məloku mɔ. Incərɛ tewe tam, k'iyɛk-yɛk əm, kɔ kəmar ka kəbɔtər kem kəmbəp əm.» ");
INSERT INTO bsp_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Kɔ Musa oloku MARIKI: «Məmentər im nɔrɔ da debeki dam, ilɛtsɛn'am.» ");
INSERT INTO bsp_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kɔ MARIKI oloku Musa: «Indecepərɛn'am fɔr kiriŋ dobotu dem amera, icbonc sɔ tewe ta MARIKI fɔr yam kiriŋ. Iŋaŋnɛnɛ nwɛ iŋfaŋ kəŋaŋnɛnɛ mɔ, indeyɔnɛ fum nɔnɔfɔr nwɛ indefaŋ kəyɔnɛ nɔnɔfɔr mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kɔ MARIKI endeŋər: «Məfɔdetam kənəŋk im kəro məna Musa, bawo fum ɔfɔtam kənəŋk im kəro wəkayi pəyi sɔ doru.» ");
INSERT INTO bsp_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kɔ MARIKI oloku: «Kəfo kɔ kaŋkɛ ina kəsək, məcəmɛ tasar tantɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kɔ nɔrɔ da debeki dem dendenacepər-ɛ, indebɛr əm abi ŋa tasar disrɛ, ikump əm kəca kem haŋ iclip kəcepər. ");
INSERT INTO bsp_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","K'ilip kəcepər-ɛ, a ideliŋ kəca kem, tɛm tatɔkɔ məntam kənəŋk im kumunt, mba afɔtam kənəŋk im kəro.» ");
INSERT INTO bsp_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kɔ MARIKI oloku Musa: Məpat walakɛ mɛrəŋ wa masar pəmɔ wɔcɔkɔ-cɔkɔ, indecicəs moloku mɔkɔ mɛnayi walakɛ wɔcɔkɔ-cɔkɔ wawɔkɔ mənapor-poru mɔ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Məlompəsnɛ bətbətana. Mədena mənuŋkɛnɛ kəpɛ nnɔ tɔrɔ ta Sinayi kəroŋ, məkɔ məcəmɛ fɔr yem kiriŋ dəndo tɔrɔ dətelempan. ");
INSERT INTO bsp_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ali fum ta pəpɛ kɔ məna, ta panəŋk sɔ fum tɔrɔ kəroŋ. Kəyɛfɛ ka ŋkesiya, cir, cəna ta yɔlɔtərnɛ di kəsɔmət! ");
INSERT INTO bsp_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kɔ Musa ɛmpat walakɛ wa masar mɛrəŋ pəmɔ wɔcɔkɔ-cɔkɔ. Kɔ Musa ɛyɛfɛ bətbət suy k'ɛmpɛ nde tɔrɔ ta Sinayi kəroŋ pətɔmpər walakɛ wa masar wawɔkɔ mɛrəŋ pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kɔ MARIKI ontor dəkəp, k'ɔŋkɔ pəyi Musa kəsək, k'omboncnɛ tewe tɔn: «MARIKI.» ");
INSERT INTO bsp_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kɔ MARIKI encepər Musa fɔr kiriŋ pəcloku: «MARIKI, MARIKI, Kanu k'iyɔnɛ nkɛ kəŋyɔnɛ nɔnɔfɔr, kəcŋaŋnɛnɛ mɔ, Kanu nkɛ pəntɔbɛlkər kətɛlɛ mɔ, Kanu nkɛ kəŋsektərnɛ danapa da ki mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Kanu k'iyɔnɛ nkɛ kəntɔmpər kəsektərnɛ danapa da fum haŋ dɛtɛmp wul win mɔ, Kanu nkɛ kəŋaŋnɛnɛ afum kiciya kəŋan, kətɔcəŋkəl kəŋan kɔ pəlɛc paŋaŋ mɔ. Mba kəfɔŋaŋnɛ kiti ka fum nwɛ ɛndəkət mɔ, fum nwɛ enciya mɔ iŋsɔŋ kəway kəlɛc kɔn yuruya yɔn dɛtɛmp maas, haŋ dɛtɛmp maŋkəlɛ.» ");
INSERT INTO bsp_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Kɔ Musa ɛmbɛlkər kəcəp tobu dəntɔf k'ontontnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Kɔ Musa oloku: «Mariki, ilɛtsɛn'am kɔ pəyɔnɛ a isɔtɔ kəmar ka kəbɔtər fɔr yam kiriŋ-ɛ, məder Mariki məsolɛ su. Afum ataŋi ləŋəs ŋɔ səyɔnɛ yati, mba məŋaŋnɛnɛ kiciya kosu kɔ pəlɛc posu, məlɛk su səyɔnɛ afum am.» ");
INSERT INTO bsp_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kɔ MARIKI oloku Musa: «Danapa dɔ səndesek, fɔr ya afum am fəp kiriŋ, indeyɔ mes mɔpɔŋ mmɛ mɛntatɔyi doru dandɛ fəp mɔ, kɔ nda afum a tɔf yɛlpəs nyɛ mɔ. Aka Yisrayel aŋɛ ŋandekɛl əm mɔ, ŋandenəŋk yɛbəc ya MARIKI, tɔyɔ tɔpɔŋ ntɛ indeyɔ kɔ məna mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","«Məde məcyɔ ntɛ o ntɛ iŋkɔsom əm mɔkɔ kədeyɔ mɔ. Indekɔbɛləs fɔr yam kiriŋ Amɔr, aKanaŋ, aHit, aPerisi, aHiwy, kɔ aYebus. ");
INSERT INTO bsp_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Məkɛmbərnɛ ta nədekɔsek danapa kɔ afum aka tɔf nyɛ nəndekɔbɛrɛ mɔ, ta ŋadeyɔnɛ mowul aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nədekɔ nəcwɔkəc tetek toloŋnɛ taŋan, nəgbal masar motontnɛ maŋan mɛcəmbər, nəccɛpəs mogbu maŋan motontnɛ ma dəcanu. ");
INSERT INTO bsp_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ta mədekɔ məctontnɛnɛ canu cəcuru, bawo tewe tɔn tɔyɔnɛ ‹MARIKI ma kəraca,› Kanu nkɛ kəyɔ kəraca mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ta mədekɔsek danapa kɔ afum aka atɔf ŋaŋɔkɔ. Bawo kɔ teyi-ɛ, kɔ ŋandekɔsali ŋacloŋnɛ canu cəŋan-ɛ, ŋaŋw'am kəkɔtəŋnɛ ti, kɔ məŋkɔ oŋ-ɛ, məfɔtam kəyi ta məndi yeri yayɔkɔ ŋaŋkɔloŋnɛnɛ canu cəŋan mɔ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kɔ nəfacɛ awut anu arkun awut aŋan aran-ɛ, awut aran akakɔ ŋandebɛrsɛ ŋa kəsali kɔ kəloŋnɛ kəŋan ka canu cəcuru. ");
INSERT INTO bsp_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ta mədekɔlompəs canu ca fɛc de.» ");
INSERT INTO bsp_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Mədekɔ məcboc kəsata ka cəcom cətɔyɔ lebin: Mata camət-mɛrəŋ ma ŋof ŋa Abib, mədekɔ məcsɔm cəcom ncɛ cəntɔyɔ lebin mɔ, pəmɔ ntɛ isom əm ti mɔ, bawo ŋof ŋa Abib, ŋaŋɔkɔ disrɛ ŋɔ mənayɛfɛ atɔf ŋa Misira.» ");
INSERT INTO bsp_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Pokom pɔcɔkɔ-cɔkɔ porkun pa yɔcɔl fəp pemi pɔ, kəlɛkɛnɛ pokom porkun mpɛ yɔcɔl yonu yende yockom mɔ, kəlɛk wana, wir haŋ aŋkesiya. ");
INSERT INTO bsp_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Məndekɔ məcwurus sɔfale səwut nsɛ andekɔkom səcɔkɔ-cɔkɔ mɔ, aŋkesiya ŋorkun ŋa teren tin kɔ pəyɔnɛ fɛ ti ambiyofo, kɔ məntɔwurus si-ɛ, mətepi si kilim. Mədekɔ məcwurus awut am arkun acɔkɔ-cɔkɔ aŋɛ andekɔ packom'am mɔ.» «Afɔde packɔ nde kəfo kem kəsoku waca wɔsɔkər.» ");
INSERT INTO bsp_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Məndekɔ məcbəc mata camət-tin, məleləs tataka ta camət-mɛrəŋ ntɛ tɔyɔnɛ dɔsɔk da kəŋesəm mɔ. Ali pəyɔnɛ a tɛm tebifti kɔ tɛtɛl tɔ məleləs pi.» ");
INSERT INTO bsp_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Mədekɔ məcboc kəsata ka Mataka Moluksər, tɛm ntɛ məndekɔcop kətɛl mɔ, kɔ kəsata ka Yɛtɛl tɛm ntɛ məndetɛl dəcəbɔf teren dəkələpsər mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Kəren o kəren, kəmaas kɔ aka Yisrayel arkun pəmar ŋader ŋamentərnɛ fɔr ya Wəbɛ MARIKI Kanu ka aka Yisrayel kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Bawo indekɔbaŋər afum alɔma tɔf yaŋan ibɛrɛnɛ yonu ntɛ tɔŋsɔŋɛ yonu yɛbɛk mɔ, ali fum ɔfɔdekɔtubucnɛ kəbaŋər nəna tɔf yonu tɛm tantɛ maas ta teren disrɛ, ntɛ mənde kəckɔ dəkəmentərnɛ MARIKI Kanu konu fɔr kiriŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Məfɔde məckɛr'em pɔcɔl poloŋnɛ kɔ paka pɔnɔŋkəl lebin, pəmar fɛ məmɛŋk sɛm ya kəloŋnɛ ka kəcɛm-cɛməs ka Kəcepər ka mɛlɛkɛ medif kəyɛfɛ dɔfɔy haŋ dɔckɔsɔk bətbət.» ");
INSERT INTO bsp_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Mədekɔ məckɛrɛ nde kəlɔ ka MARIKI Kanu kam yokom yɔcɔkɔ-cɔkɔ ya antɔf ŋam. Ta mədekɔ məcpɛcɛ ambiyofo mɛsɛ ma kɛrɛ ka ŋi.» ");
INSERT INTO bsp_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kɔ MARIKI oloku Musa: «Məcic moloku mamɛ, bawo moloku mamɛ m'indesekɛ danapa kɔ məna k'aka Yisrayel.» ");
INSERT INTO bsp_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Kɔ Musa ŋayi kɔ MARIKI mata wəco maŋkəlɛ pibi kɔ daŋ. Endi fɛ peri, omun fɛ domun. K'encicəs walakɛ nwɛ kəroŋ moloku ma sariyɛ sa danapa, mɛtəkəs wəco. ");
INSERT INTO bsp_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kɔ Musa ontor kəyɛfɛ ka tɔrɔ ta Sinayi kəroŋ pətɔmpər walakɛ mɛrəŋ nwɛ wementər danapa dɔn kɔ aka Yisrayel mɔ. Musa ɛnacərɛ fɛ a kəlok-loku kɔn kɔ Kanu kənasɔŋɛ kɔ kəro kəmot. ");
INSERT INTO bsp_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aruna kɔ aka Yisrayel fəp ŋaŋgbətnɛ Musa, ntɛ kəro kɔn kəncmot mɔ. Kɔ ŋanesɛ kəlɔtərnɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kɔ Musa ewe ŋa. Kɔ Aruna k'akiriŋ a kəloŋkanɛ ka aka Yisrayel fəp ŋander nnɔ nkɔn Musa eyi mɔ, k'olok-lokər ŋa. ");
INSERT INTO bsp_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ntɛ elip mɔ, kɔ aka Yisrayel alpəs aŋɛ ŋalɔtərnɛ kɔ oŋ, k'oloku ŋa moloku mɔkɔ MARIKI ɛnasom kɔ nde tɔrɔ ta Sinayi kədeloku aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ntɛ Musa elip kəlok-loku ŋa mɔ, k'ɛlɛk kəfakəl k'oŋkumpnɛ kəro. ");
INSERT INTO bsp_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ntɛ Musa endebɛrɛ nde kəfo kəsoku kəkɔlok-loku kɔ MARIKI mɔ, k'eliŋnɛ kəfakəl dəkəro. K'owur kəyɛfɛ ka dəndo kəfo kəsoku disrɛ-ɛ, pəloku aka Yisrayel tɔkɔ MARIKI osom kɔ kədeloku ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Aka Yisrayel ŋancmɔmən kəro ka Musa ntɛ kəcmot mɔ. K'elip kəlok-lokər ŋa, pəkumpnɛ sɔ kəro mɛnɛ dɔsɔk ndɛ ɔŋkɔ sɔ nde kəfo kəsoku disrɛ kəkɔlok-loku kɔ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Kɔ Musa oloŋka aka Yisrayel fəp, k'oloku ŋa: «Ntɛ tɔ MARIKI osom a pacyɔ: ");
INSERT INTO bsp_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mata camət-tin pabəc, mba tataka ta camət-mɛrəŋ, simiti, dɔsɔk da kəŋesəm dɔ ndɛ ampusɛ MARIKI mɔ. Fum nwɛ o nwɛ ɛmbəc dɔsɔk dadɔkɔ mɔ, andif kɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Pəmar fɛ nəmot nɛnc dɔsɔk da kəŋesəm simiti nde wɔlɔ wonu.» ");
INSERT INTO bsp_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Kɔ Musa oloku kəloŋkanɛ ka aka Yisrayel fəp: «Ntɛ tɔ MARIKI osom: ");
INSERT INTO bsp_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‹Nəlɛk dəyɔsɔtɔ yonu nəfɛkɛ MARIKI. Wərkun nwɛ o nwɛ ɔsɔk abəkəc ŋɔtɔt, pəkɛrɛ MARIKI kəfɛk: Kəyɛfɛ kɛma, gbeti, kɔpər, ");
INSERT INTO bsp_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","cəloto cəgbət karɛ alom ŋa məntambɛnc, alom ŋeyim, ŋeyimbərər sɔ, cəloto ncɛ andunɛ səbeŋa sa kentəler kɔ cəfon ca wir mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kata ya ŋkesiya yorkun nyɛ aŋgbət karɛ alom ŋeyim mɔ, kata ya ntempeli, tɔk ya kasiya, ");
INSERT INTO bsp_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","kɔ moro momotɛnɛ, labundɛ dobotu ambɔnc ndɛ ande pacgbuluŋ moro mɔbɔy, kɔ suray səbotu ambɔnc, ");
INSERT INTO bsp_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kɔ masar mɔtɔt mmɛ aŋwe onikəs mɔ, kɔ mɔtɔt mɔlɔma mmɛ andebɛr duma da efɔd kɔ yuba yɛgbɛknɛ dɛbəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Acɛrəŋ aŋɛ ŋayi nu dacɔ mɔ fəp, ŋader ŋalompəs ca cəkɔ MARIKI osom nu kəlompəs mɔ fəp: ");
INSERT INTO bsp_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Dəkiyi dosoku, aŋgbancan fəp kɔ pokumpɛ pa ŋi, ŋkora ya ŋi, fərɛm fa ŋi, mogbu ma ŋi, gbat-gbata ya ŋi kɔ yɛcəmɛnɛ ya ŋi, ");
INSERT INTO bsp_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kaŋkəra ka dəKanu kɔ cəgbo ca ki kɔ afɛŋk ŋɔsɔksɛ kiciya, kɔ kəloto kəŋɛrɛ, ");
INSERT INTO bsp_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","amɛsa kɔ cəgbo ca ŋi, yosumpər-sumpər ya ŋi fəp kɔ cəcom ncɛ aloŋnɛnɛ Kanu mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","pɛdɛtɛ səlamp kɔ yosumpər-sumpər ya pi, səlamp kɔ moro momotɛnɛ, ");
INSERT INTO bsp_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","tetek mpɛ ancɔfɛ MARIKI suray mɔ, kɔ cəgbo ca pi, moro mɔbɔy, suray səbotu ambɔnc, kəloto kəŋɛrɛ kəŋkɔ andɛt aŋgbancan ŋosoku dəkusuŋka mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","tetek toloŋnɛ yɔcɔf yɔcɔl kɔ manta ma kɔpər ya pi, cəgbo ca pi kɔ yosumpər-sumpər ya pi fəp, kəsamp kəbɛrɛ domun dɔsɔkəsnɛnɛ, kɔ pɛcəmɛnɛ pa ki, ");
INSERT INTO bsp_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","cəloto ca saŋka, mogbu ma ci kɔ yɛcəmɛnɛ ya mi, kɔ kəloto kəŋɛrɛ ka nde kusuŋka ka saŋka, ");
INSERT INTO bsp_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","cəgbo cədɔf ca dəkiyi dosoku, ca saŋka, kɔ bənda yɔkɔ pəmar mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","yamos yodu yɔkɔ pəmar pabɛrnɛ a pabəc yɛbəc nde aŋgbip ŋosoku mɔ, kɔ yamos ya dəKanu nyɛ Aruna kɔ awut ɔn ŋandekɔ ŋacbɛrnɛ a ŋacbəcɛ Kanu mɔ.›» ");
INSERT INTO bsp_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kɔ kəloŋkanɛ k'aka Yisrayel fəp ŋayɛfɛ fɔr ya Musa kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Afum aŋɛ ŋanatesɛ bəkəc mɔ fəp, kɔ ŋaŋkɛrɛ MARIKI kəfɛk kəŋan teta yɛbəc ya aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, kɔ kəlompəs ka yamos ya dəKanu. ");
INSERT INTO bsp_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","K'arkun kɔ aran ŋander. Afum aŋɛ ŋanayɔ bəkəc yosoku pɛs mɔ ŋaŋkɛrɛ yeyesnɛnɛ ya kɛma yadələŋəs, kurundɛ, yɛgbɛknɛ, cəsora kɔ yeyesnɛnɛ fəp nyɛ alompsɛ kɛma mɔ, kɔ ŋander ŋasɔŋ yi MARIKI kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Aŋɛ ŋanayɔ cəloto ca alom ŋa məntambɛnc mɔ, alom ŋeyim, cəloto ca səbeŋa sa kentəler, ca cəfon ca wir, kata ya ŋkesiya yorkun nyɛ aŋgbət dəpəyim, kɔ kata ya ntempeli mɔ ŋaŋkɛrɛ yi fəp. ");
INSERT INTO bsp_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Aŋɛ ŋanamɛŋkərnɛ kəsək kəfɛk ka gbeti kɔ kɔpər mɔ, ŋaŋkɛrɛ yi MARIKI. Aŋɛ ŋanayɔ tɔk ya kasiya mɔ, ŋaŋkɛrɛ yi teta yɛbəc yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","K'aran acɛrəŋ ŋandunɛ cəloto ca suwa waca waŋan, kɔ ŋaŋkekərɛ ncɛ ŋanadu mɔ, cəloto ca alom ŋa məntambɛnc, alom ŋeyim, alom ŋa bulu kɔ cəloto ca səbeŋa sa kentəler. ");
INSERT INTO bsp_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Aran acɛrəŋ alɔma aŋɛ ŋanatesɛ bəkəc mɔ, kɔ ŋandunɛ cəloto cətelər cəfon ca cir. ");
INSERT INTO bsp_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","K'akiriŋ aka Yisrayel ŋaŋkɛrɛ masar ma onikəs kɔ masar mɔtɔt mɔlɔma mmɛ pəmar pabɛrəs duma da efɔd kɔ yuba nyɛ wəloŋnɛ wəpɔŋ ɛŋgbɛknɛ dɛbəkəc mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","kɔ suray səbotu ambɔnc, kɔ moro momotɛnɛ dəsəlamp, moro mɔbɔy kɔ suray nsɛ ancɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Arkun kɔ aran aŋɛ o aŋɛ ŋanatesɛ bəkəc kəfɛkɛ yɛbəc nyɛ MARIKI ɛnasom Musa mɔ, fəp ŋanakɛrɛ MARIKI kəpocɛ kəŋan bəkəc yosoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kɔ Musa oloku aka Yisrayel: Nəmɔmən, MARIKI ewe Betsalel tewe tɔn, wan ka Uri wansɔ ka Hur wəka kusuŋka ka Yuda, ");
INSERT INTO bsp_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","k'ɛlas kɔ amera ŋa Kanu ntɛ tɔŋsɔŋɛ pəcɛrŋɛ, pəsɔk domp, pəcərɛ yɛbəc fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ɛncərɛ kəpər yɛbəc ya kɛma, ya gbeti, kɔ ya kɔpər, ");
INSERT INTO bsp_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kəpat ka masar momotər-motər, kɔ kəsɛt mi dəfərɛm, kəpat ka tɔk, kɔ dɛcɛrəŋ da yɛbəc fəp, kɔ kəpər ka yi. ");
INSERT INTO bsp_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kɔ Kanu kəmpocɛ Betsalel pətɔt ntɛ tɔŋsɔŋɛ pətam kətəksɛ afum alɔma dɛcɛrəŋ dadɔkɔ fəp mɔ, kɔ kəmpocɛ sɔ Oholiyab wan ka Ahisamak wəka kusuŋka ka Dan pətɔt papɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","MARIKI ɛnalas ŋa dɛcɛrəŋ ŋactam kəbəc ka yɛbəc yayɔkɔ fəp, kəyɛfɛ ka kəpat, kənɛkəs, kəcɛm, kədu cəloto ca alom ŋa məntambɛnc, alom ŋeyim, cəloto cəfəfər kɔ cəloto cətelər, kɔ kəpər ka yɛbəc fəp. ");
INSERT INTO bsp_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kəyɛfɛ ka Betsalel kəkɔ ka Oholiyab kəbəp ka acɛrəŋ alpəs akɔ MARIKI ɛnasɔŋ dɛcɛrəŋ kɔ dosoku səbomp ntɛ tɔŋsɔŋɛ ŋacərɛ yɛbəc ya nde aŋgbip ŋosoku ŋasumpər yɛbəc ŋasurɛnɛ yi pəmɔ tɔkɔ MARIKI ɛnasom ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kɔ Musa ewe Betsalel, Oholiyab kɔ acɛrəŋ akɔ MARIKI ɛnabɛr dosoku səbomp mɔ, aŋɛ bəkəc yaŋan yɛnasumpər kəbəc yɛbəc yayɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Kɔ ŋasɔtər Musa ca cəkɔ aka Yisrayel ŋanafɛk teta kəlompəs kɔ yɛbəc ya aŋgbip ŋosoku mɔ. Bətbət o bətbət anckɛrɛ Musa yɛfɛk tuŋ, bəkəc yosoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Awa afum acɛrəŋ aŋɛ ŋanasumpər yɛbəc fəp ya aŋgbip ŋosoku mɔ, ŋancəmbərəs nwɛ o nwɛ yɛbəc yɔkɔ ɛnayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Kɔ ŋander ŋaloku Musa: Afum ŋayi kəcepərər kəkɛrɛ ka yɛfɛk teta yɛbəc yɔkɔ MARIKI osom kəlompəs mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kɔ Musa osom padəŋk saŋka disrɛ fəp: Ali fum, pəyɔnɛ wərkun pəyɔnɛ wəran, ta pətɛn sɔ pɛfɛkɛ aŋgbip ŋosoku! K'ayamsər oŋ afum kənaŋkanɛ kəkɛrɛ ka yɛfɛk yɛcəmbərɛ ya aŋgbip ŋosoku. ");
INSERT INTO bsp_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Yɛfɛk nyɛ anabaŋəs mɔ yɛnctəŋnɛ haŋ yecepərər teta yɛbəc nyɛ pənamar kəbəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Afum acɛrəŋ aŋɛ ŋancbəc mɔ fəp, ŋalompsɛ dəkiyi dosoku cəpol wəco ca səbeŋa sa kentəler, alom ŋa məntambɛnc, alom ŋa bulu, k'alom ŋeyim, padu ci kəroŋ lulu ya mɛlɛkɛ kerub, yɛbəc ya acɛrəŋ yɛnayi. ");
INSERT INTO bsp_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dobolu da cəpol cacɔkɔ fəp dɔyɔ nkɛ o nkɛ cururu wəco mɛrəŋ kɔ camət-maas (28) kɔ dowokulu da kəpol nkɛ o nkɛ dɔyɔ cururu maŋkəlɛ, cəpol fəp cənatəŋnɛnɛ potubuc. ");
INSERT INTO bsp_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","K'ɛŋgbɛtlɛnɛ-gbɛtlɛnɛ cəpol kəcamət kin kin, k'ɛŋgbɛtlɛnɛ-gbɛtlɛnɛ sɔ cəkɔ kəcamət. ");
INSERT INTO bsp_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kɔ ŋawes-wesɛ dobol da kəloto kəcɔkɔ-cɔkɔ kəkəsək səbeŋa s'alom ŋa məntambɛnc, kɔ ŋanut yi, kɔ ŋayɔ sɔ tin tayi kəpol ka kəloto ka mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Dobol da cəloto cacɔkɔ mɛrəŋ, k'ewes-wesɛ di səbeŋa wəco kəcamət (50), k'onut yi, k'ɔsɔŋɛ yewes-wesi ya cəloto cacɔkɔ mɛrəŋ fəp kəsurɛnɛ yin yin. ");
INSERT INTO bsp_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","K'olompəs ŋkora wəco kəcamət (50) ya kɛma nyɛ ɛnacɛpərɛnɛnɛ cəloto cacɔkɔ mɛrəŋ mɔ, kɔ tɔsɔŋɛ cəloto ca dəkiyi dosoku kəyɔnɛ kin. ");
INSERT INTO bsp_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ntɛ elip mɔ, k'olompsɛ cəpol ca kəloto kətelər wəco kɔ pin cəfon ca wir, ncɛ ɛnalompsɛ dəkiyi dosoku mɔ, k'emperi ci dəkiyi dosoku kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kəpol nkɛ o nkɛ kənayɔ dobolu da cururu wəco maas (30), kɔ dowokulu dɔyɔ cururu maŋkəlɛ. Cəpol ncɛ wəco kɔ pin (11) cənatəŋnɛnɛ potubuc. ");
INSERT INTO bsp_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","K'ɛŋgbɛtlɛnɛ taciŋa cəpol ncɛ kəcamət, k'ɔyɔ sɔ tin tayi cəkɔ camət-tin. ");
INSERT INTO bsp_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","K'olompəs yewes-wesi wəco kəcamət (50) kəpol kəkəsək ka yɛgbɛtlɛnɛ yɔcɔkɔ-cɔkɔ, k'onut yi. Kəpol kəkəsək ka yɛgbɛtlɛnɛ ya mɛrəŋ yɔkɔ k'olompəs yewes-wesi wəco kəcamət (50), k'onut sɔ yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","K'olompəs ŋkora wəco kəcamət (50) ya kɔpər, k'ɛŋgbɛkərɛnɛ yi kɔ tɔsɔŋɛ aŋgbancan kəyɔnɛ ŋin. ");
INSERT INTO bsp_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","K'olompsɛ pokumpɛ pa aŋgbancan pɔcɔkɔ-cɔkɔ kata ya ŋkesiya yorkun nyɛ anagbət karɛ kəyim mɔ, k'oŋkumpɛ tamɛrəŋ kata ya ntempeli. ");
INSERT INTO bsp_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","K'olompsɛ dəkiyi dosoku tɔk ya kasiya fərɛm k'ɛncəmbər fi. ");
INSERT INTO bsp_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dobolu da fərɛm o fərɛm dɛnayɔ cururu wəco kɔ dowokulu da fi kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Fərɛm o fərɛm fənayɔ sek mɛrəŋ nyɛ yɛnasol mɔ, tatɔkɔ t'ɛnayɔ sɔ fərɛm fa dəkiyi dosoku fəp. ");
INSERT INTO bsp_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","K'olompəs fərɛm wəco mɛrəŋ (20) fa kəca kətɔt ka nde dec dɛmpɛ da dəkiyi dosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","K'olompəs yɛcəmɛnɛ wəco maŋkəlɛ (40) ya gbeti nyɛ ɛnacəmbər tantɔf ta fərɛm wəco mɛrəŋ (20). Fərɛm o fərɛm fənayɔ yɛcəmɛnɛ mɛrəŋ, kəsurɛnɛ ka bi nyɛ antam kəsɛt sek mɛrəŋ yɔkɔ fərɛm fəyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","K'olompəs sɔ fərɛm wəco mɛrəŋ (20) fa kəca kəmeriya ka nde dec dɛmpɛ da dəkiyi dosoku mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","kɔ yɛcəmɛnɛ wəco maŋkəlɛ (40) ya gbeti, ti tɔ tatɔkɔ yɛcəmɛnɛ mɛrəŋ yɛnayi fərɛm fin tantɔf. ");
INSERT INTO bsp_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","K'olompəs fərɛm camət-tin fa tɔgbɔkɛnɛ ta dəkiyi dosoku, kəca ka ntende dec dɛŋkalɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","k'olompəs fərɛm mɛrəŋ taciŋa fa moŋkubut ma tɔgbɔkɛnɛ pa dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","K'ɛŋgbɛpɛnɛ fərɛm fafɔkɔ mɛrəŋ kəyɛfɛ tantɔf k'oŋkotərnɛ fi takəroŋ kəsora kin. K'ɔyɔ tin tayi fərɛm nfɛ mɛrəŋ, nfɛ fənayi moŋkubut yayɔkɔ mɛrəŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Fərɛm camət-maas fənayi, kɔ yɛcəmɛnɛ wəco kɔ camət-tin (16) ya gbeti, ti tɔ tatɔkɔ fərɛm o fərɛm fənayɔ yɛcəmɛnɛ mɛrəŋ tantɔf. ");
INSERT INTO bsp_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","K'ɛmpat cəgbo ca kətɔk ka kasiya kəcamət ncɛ cənasumpər fərɛm fəp fa kəsək kin ka dəkiyi dosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Cəgbo kəcamət ca fərɛm fa kəsək ka mɛrəŋ ka dəkiyi dosoku, kɔ cəgbo kəcamət sɔ cəsumpərɛ fərɛm fa tɔgbɔkɛnɛ ta dəkiyi dosoku, ntende dec dɛŋkalɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","K'olompəs kəgbo kəracɔ nkɛ kənacepər fərɛm fa kəsək kin fəp dacɔ mɔ, kəyɛfɛ fərɛm fəcɔkɔ-cɔkɔ haŋ kəbəp fəlpəs. ");
INSERT INTO bsp_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","K'osop fərɛm fəp kɛma, k'olompəs cəsora ca kɛma nde pənamar cəgbo cəcepər mɔ, k'osop sɔ ci kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","K'olompsɛ kəloto kəkəŋkɛ səbeŋa sa kentəler sa alom ŋa məntambɛnc, sa alom ŋa bulu kɔ sa alom ŋeyim. K'ondu kəloto kaŋkɔ kəroŋ mɛlɛkɛ kerub, yɛbəc ya wəcɛrəŋ kədu yɛnayi yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","K'ɛmpatɛ ki mogbu maŋkəlɛ ma kətɔk ka kasiya, k'osop mi kɛma. Mogbu mamɔkɔ mɔ anabɛr ŋkora ya kɛma. K'olompsɛ mogbu mamɔkɔ yɛcəmɛnɛ maŋkəlɛ ya gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Dəkusuŋka d'aŋgbancan, k'ondunɛ kəloto kəŋɛrɛ səbeŋa sa kentəler, k'ɔnɔŋksəl si səbeŋa sa alom ŋa məntambɛnc, sa alom ŋa bulu kɔ sa alom ŋeyim. ");
INSERT INTO bsp_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","K'olompsɛ kəloto kəŋɛrɛ mogbu kəcamət kɔ ŋkora, k'osop yɛnɛkəs ya mogbu takəroŋ kɔ gbat-gbata ya mi kɛma. Yɛcəmɛnɛ ya mi kəcamət, kɔpər kənayi. ");
INSERT INTO bsp_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Kɔ Betsalel olompsɛ kaŋkəra ka sede sa danapa da MARIKI kɔ aka Yisrayel kətɔk ka kasiya. Kaŋkəra kaŋkɔ kənabɔl cururu mɛrəŋ kɔ dacɔ, kɔ dowokulu da ki dɛnayɔ kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kɔ Betsalel osop kaŋkəra kaŋkɔ tedisrɛ kɔ todoru kɛma kəsoku pɛs, k'olompəs kəbər ka kɛma haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","K'olompəs cəsora maŋkəlɛ ca kɛma ncɛ ɛnabɛr moŋkubut ma kaŋkəra kaŋkɔ mɔ, kəsək kətɔt cəsora mɛrəŋ kɔ kəsək kəmeriya cəsora mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","K'ɛmpat cəgbo mɛrəŋ ca kətɔk kəca kətɔt ka kasiya, k'osop ci kɛma kəsoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","K'osor cəgbo cacɔkɔ cəsora cəcəsək ntɛ tɔŋsɔŋɛ pactam ki kəsɛlɛŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Kɔ ŋalompsɛ afɛŋk ŋɔsɔksɛ kiciya kɛma kəsoku pɛs, dobolu da ŋi dɛnayɔ cururu mɛrəŋ kɔ dacɔ kɔ dowokulu da ŋi dɔyɔ kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","K'olompsɛ mɛlɛkɛ kerub mɛrəŋ kɛma kətɛmp, k'ɛsɛlərɛnɛ mi dəkəcop kɔ dəkələpsər da afɛŋk ŋɔsɔksɛ kiciya kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Məsɛlərɛnɛ mɛlɛkɛ kerub min dəkəcop da afɛŋk kəroŋ, mɛlɛkɛ kerub mɛrəŋ mɔkɔ dəkələpsər da ŋi kəroŋ. K'olompəs mɛlɛkɛ kerub mɛrəŋ kɔ afɛŋk ŋɔsɔksɛ kiciya, kɔ yɔyɔnɛ paka pin nde dəkəcop kɔ dəkələpsər da ŋi kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mɛlɛkɛ kerub mamɔkɔ mɛrəŋ meperi banca takəroŋ, yi yokump afɛŋk ŋɔsɔksɛ kiciya, mɛnatɛfərɛnɛ meti cəro ŋi kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kɔ Betsalel olompsɛ amɛsa kətɔk ka kasiya. Dobolu da amɛsa ŋaŋɔkɔ dɛnayɔ cururu mɛrəŋ, kɔ dowokulu da ŋi dɛnayɔ kururu katin, kɔ deŋeci da ŋi kururu katin kɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","K'osop ŋi kɛma kəsoku pɛs, k'olompəs ŋi kəbər ka kɛma haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Kɔ Betsalel olompsɛ cəsək cacɔkɔ maŋkəlɛ fərɛm nfɛ dowokulu da fi dɛnctəŋnɛnɛ kɔ dowokulu da kəca disrɛ mɔ, k'ɛmbɛr ki kəbər ka kɛma haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","K'olompəs sɔ cəsora maŋkəlɛ ca kɛma ncɛ ɛnabɛr moŋkubut m'amɛsa kəsurɛnɛ ka yɛcəmɛnɛ maŋkəlɛ ya ŋi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Cəsora cacɔkɔ cənalɔtərnɛ fərɛm, difɔ ancsor cəgbo ncɛ anctam kəlɛk ŋi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","K'olompəs cəgbo ca kətɔk ka kasiya k'osop ci kɛma, cəgbo cacɔkɔ c'anclɛkɛ amɛsa ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","K'olompsɛ yosumpər-sumpər ya dɛmɛsa kəyɛfɛ pəlet, mɔbɔl, səpɔt kɔ mapan nyɛ ancbəcɛ teta yoloŋnɛnɛ ya moro kɔ ya wɛn mɔ, kɛma kəsoku pɛs k'ɛnalompsɛ yi. ");
INSERT INTO bsp_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kɔ Betsalel olompsɛ pɛdɛtɛ səlamp kɛma kətɛmp kəsoku pɛs, k'ɛsɛlərɛnɛ kəyɛfɛ pɛcəmɛnɛ, kəkɔ təmboŋk pa pi, yɔnɔnɛ ya səlamp, yogbuc ya pi, kɔ yowurɛnɛ ya yɛlɛŋk ya tɔk. ");
INSERT INTO bsp_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Wara camət-tin wɛncyɛfɛ dətəmboŋk paracɔ, kəca o kəca wara maas. ");
INSERT INTO bsp_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kəra o kəra kənayɔ yɔnɔnɛ ya səlamp maas nyɛ yɛnawurɛnɛ yɛlɛŋk ya tɔk yokom mɔ, kənayɔ sɔ pogbuc kɔ pɛlɛŋk. Itɔ pənayi wara camət-tin nwɛ wɛnayɛfɛ dəpɛdɛtɛ səlamp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Təmboŋk pa pɛdɛtɛ səlamp pɛnayɔ yɔnɔnɛ ya səlamp maŋkəlɛ nyɛ yɛnawurɛnɛ kɔ yɛlɛŋk ya tɔk yokom mɔ, yogbuc kɔ yɛlɛŋk ya yi. ");
INSERT INTO bsp_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Wara wawɔkɔ mɛrəŋ mɛrəŋ kəmaas nwɛ wɛncyɛfɛ dətəmboŋk paracɔ mɔ, dəkəyɛfɛ da wara mɛrəŋ o mɛrəŋ, pogbuc pin pin pencyi wi tantɔf. ");
INSERT INTO bsp_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Yogbuc kɔ wara wawɔkɔ fəp anasɛlərɛnɛ yi, fəp fa yi fəyɔnɛ ancəmbəl ŋin ŋa kɛma kəsoku pɛs kətɛmp. ");
INSERT INTO bsp_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","K'olompəs səlamp camət-mɛrəŋ, macaŋk kɔ map mɛkayɛ meken. K'olompsɛ fəp fa mi kɛma kəsoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kɛma kəsoku pɛs kilo wəco maas (30) k'ɛnalompsɛ pɛdɛtɛ səlamp kɔ yosumpər-sumpər ya pi. ");
INSERT INTO bsp_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kɔ Betsalel olompsɛ tetek pɔcɔfɛ MARIKI suray kətɔk ka kasiya. Dobolu da tetek papɔkɔ dɛnayɔ kururu katin, kɔ dowokulu da pi kururu katin, pənatəŋnɛ cəsək fəp, kɔ deŋeci da pi cururu mɛrəŋ. Tetek kɔ lɛn ya pi yɛtəpərɛnɛ anasɛlərɛnɛ yɔyɔnɛ paka pin. ");
INSERT INTO bsp_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","K'osop pi kɛma kəsoku pɛs kəlɛk amɛsa ŋa pi kəroŋ kəbəp ka cəsək ca pi kəkɔ haŋ lɛn ya pi. K'olompəs pi kəbər ka kɛma cəsək haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","K'olompəs cəsora mɛrəŋ ca kɛma ncɛ anabɛr ci kəbər tantɔf ta cəsək mɛrəŋ ca tetek papɔkɔ. Cəsora cacɔkɔ cɔ andekɔ pacsor cəgbo, ntɛ tɔŋsɔŋɛ pactam kəlɛk ka pi mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","K'ɛmpat cəgbo ca kətɔk ka kasiya k'osop ci kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Kɔ Betsalel olompəs moro mɔbɔy mopusɛ, k'olompsɛnɛ sɔ suray səsoku pɛs nsɛ səmbɔt ambɔnc mɔ, yɛbəc ya wəcərɛ kəlompəs labundɛ yɛnayi. ");
INSERT INTO bsp_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Kɔ Betsalel olompsɛ tetek toloŋnɛ Kanu pɔcɔl pacɔf kətɔk ka kasiya, dobolu da pi dɛnabəp cururu kəcamət, kɔ dowokulu da pi cururu kəcamət. Cəsək ca pi cəntəŋnɛnɛ, mba deŋeci da pi dɛnayɔ cururu maas. ");
INSERT INTO bsp_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","K'olompəs lɛn ya tetek nde moŋkubut makəroŋ maŋkəlɛ, nyɛ anasɛlərɛnɛ kɔ pi mɔ, kɔ tɔsɔŋɛ pi kəyɔnɛ paka pin, k'osop pi kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","K'olompsɛ yosumpər-sumpər ya tetek toloŋnɛ fəp, kəlɛk ka dap, pel, mapan, bak yosortɛ sɛm kɔ map mɛkayɛ meken. K'olompsɛ yosumpər-sumpər yayɛ fəp kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","K'olompəs manta ma kɔpər, k'ɛncəmbər mi kəbər ka tetek toloŋnɛ kəyɛfɛ tantɔf haŋ dacɔ. K'ɛsɛl cəsora maŋkəlɛ ca kɔpər ncɛ ɛnabɛr dəmoŋkubut ma manta, teta kəsor ka cəgbo mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","K'olompəs cəsora maŋkəlɛ ncɛ ɛnabɛr moŋkubut maŋkəlɛ ma manta ma kɔpər mamɔkɔ mɔ, ntɛ tɔŋsɔŋɛ pactam kəsor ka cəgbo mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","K'ɛmpat cəgbo ca kətɔk ka kasiya, k'osop ci kɔpər. ");
INSERT INTO bsp_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","K'osor cəgbo cacɔkɔ dəcəsora cacɔkɔ cənayi cəsək ca tetek toloŋnɛ mɔ, ntɛ tɔŋsɔŋɛ pactam kəlɛk tetek papɔkɔ mɔ. Ɛnalompsɛ pi cəbam, kɔ pɔyɔ fos disrɛ. ");
INSERT INTO bsp_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","K'ɛsɛlɛ kəsamp ka kɔpər, kɔ pɛcəmɛnɛ pa ki sɔ pənayɔnɛ kɔpər. K'alompsɛ yi mɛm nyɛ aran aŋɛ ŋanayi yɛbəc nde kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","K'olompəs abaŋka. K'ɛncəmbərɛ saŋka kəca kətɔt ka ntende dec dɛmpɛ mɔ cəloto ca səbeŋa sa kentəler. Dobolu da cəloto cacɔkɔ dɛnabəp cururu tasar tin (100). ");
INSERT INTO bsp_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Mogbu ma yi wəco mɛrəŋ (20) kɔ yɛcəmɛnɛ wəco mɛrəŋ (20) kɔpər kənayi. Ŋkora ya mogbu kɔ gbat-gbata ya mi yɔyɔnɛ gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kəca kəmeriya ka ntende dec dɛmpɛ mɔ, cəloto cənabɔl cururu tasar tin (100), mogbu wəco mɛrəŋ (20) kɔ yɛcəmɛnɛ ya yi wəco mɛrəŋ (20) ya kɔpər, ŋkora ya mogbu kɔ gbat-gbata ya mi fəp gbeti bɛnayi. ");
INSERT INTO bsp_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kəca nkɛ dec dɛŋkalɛ mɔ, cəloto cənabɔl cururu wəco kəcamət (50) mogbu ma ci wəco kɔ yɛcəmɛnɛ ya mi wəco, ŋkora ya mogbu kɔ gbat-gbata ya mi fəp gbeti bɛnayi. ");
INSERT INTO bsp_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kəca nkɛ dec dɛmpɛ mɔ, dobolu d'abaŋka dɛnayɔ cururu wəco kəcamət (50). ");
INSERT INTO bsp_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kɔ kəsək kin kəyɔ cəloto ncɛ cənabɔl cururu wəco kɔ kəcamət (15) mɔ, mogbu maas kɔ yɛcəmɛnɛ ya mi maas. ");
INSERT INTO bsp_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Kəca ka mɛrəŋ, dəkusuŋka da saŋka kəca kətɔt kɔ kəmeriya, dobolu da cəloto dɛnayɔ cururu wəco kɔ kəcamət (15), mogbu maas kɔ yɛcəmɛnɛ ya mi maas. ");
INSERT INTO bsp_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Cəloto ncɛ ananɛpər saŋka mɔ fəp, cəloto ca səbeŋa sa kentəler sənayi. ");
INSERT INTO bsp_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Yɛcəmɛnɛ ya mogbu fəp, ya kɔpər yɛnayi, ŋkora ya mogbu kɔ gbat-gbata fəp ya gbeti yɛnayi, yɛnɛksɛ ya mogbu fəp anasop yi gbeti, kɔ mogbu ma saŋka fəp anakotərɛnɛ mi kɔ gbat-gbata ya gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","K'ondunɛ cəloto ncɛ anaŋɛrɛ kusuŋka ka saŋka mɔ. K'olompsɛ ci səbeŋa sa alom ŋa məntambɛnc, səbeŋa alom ŋa bulu, sa alom ŋeyim, səbeŋa sa kentəler, yɛbəc ya wəcərɛ kədu yɛnayi. Cəloto cəŋɛrɛ cənabɔl cururu wəco mɛrəŋ (20) kɔ deŋeci da ci dɛnayɔ cururu kəcamət, pəmɔ dowokulu da cəloto ca saŋka. ");
INSERT INTO bsp_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Anadɛtər yi mogbu maŋkəlɛ mmɛ mɛnacəmɛnɛ yɛcəmɛnɛ maŋkəlɛ ya kɔpər mɔ, ŋkora kɔ gbat-gbata ya gbeti yɛnayi, kɔ yɛnɛksɛ ya mogbu sɔ, anasop yi gbeti. ");
INSERT INTO bsp_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Cəgbo cədɔf ca dəkiyi dosoku kɔ abaŋka ŋa saŋka fəp, ca kɔpər cənayi. ");
INSERT INTO bsp_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tatɔkɔ tɔ daka da fɛc ndɛ anabɛrsɛ kəlompəs ka dəkiyi dosoku ndɛ walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel mɔ. Pəmɔ tɔkɔ Musa ɛnasom ŋa ti mɔ, aLewy ŋanalɔm yi, Itamar pəyi ti kiriŋ wan wərkun wəka wəloŋnɛ Aruna. ");
INSERT INTO bsp_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Kɔ Betsalel wan ka Uri, wansɔ ka Hur, wəka kusuŋka ka Yuda, ɛmbəc tɔkɔ MARIKI ɛnasom Musa mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiyab, wan ka Ahisamak, wəka kusuŋka ka Dan ɛnamar kɔ, wəkakɔ ɛncpat, wəcɛrəŋ nwɛ oncdu cəloto ca alom ŋa məntambɛnc, alom ŋa bulu, kɔ alom ŋeyim, kɔ cəloto ca səbeŋa sa kentəler. ");
INSERT INTO bsp_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kɛma nkɛ kənabɛrɛ kəlompəs ka aŋgbip ŋosoku mɔ fəp kənabəp kilo masar camət-maas wəco camət-mɛrəŋ kɔ camət-mɛrəŋ (877), potubucɛ pa aŋgbip ŋosoku p'anatubcɛ ki. ");
INSERT INTO bsp_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Gbeti mbɛ aka kəloŋkanɛ ka Yisrayel ŋanafɛk mɔ fəp, bɛnakɔ kilo wul maas wəco kɔ camət-maas (3.018), potubucɛ pa aŋgbip ŋosoku p'anatubcɛ ki. ");
INSERT INTO bsp_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","K'ayer kəfɛk kaŋkɔ-ɛ, antam kəloku a arkun wul masar camət-tin kɔ maas, masar kəcamət wəco kəcamət (603.550) aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ (20) haŋ kəpɛ kəroŋ mɔ, nwɛ o nwɛ ɛnafɛk pəsam gbeti kəcamət potubucɛ pa pəsam p'aŋgbip ŋosoku. ");
INSERT INTO bsp_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kɔ ŋalompsɛ gbeti wul maas (3.000) yɛcəmɛnɛ tasar tin (100) ya fərɛm ya aŋgbip ŋosoku kɔ ya kəloto kəkəŋkɛ tedisrɛ ti tɔŋsɔŋ pɛcəmɛnɛ o pɛcəmɛnɛ analompsɛ pi gbeti kilo wəco maas (30). ");
INSERT INTO bsp_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","K'alompsɛ gbeti bɛlpəs mbɛ kilo wəco kɔ camət-mɛrəŋ (17) kɔ kəram masar camət-mɛrəŋ kɔ wəco kəcamət (750) ŋkora ya mogbu, k'aŋsop sɔ ncaləran kɔ gbat-gbata nyɛ anakotərɛnɛ kɔ mogbu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Kɔpər nkɛ aka Yisrayel ŋanatubucnɛ kəsɔŋ MARIKI mɔ kənabəp kilo wul mɛrəŋ, tasar tin wəco mɛrəŋ kɔ maŋkəlɛ (2.124). ");
INSERT INTO bsp_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Kɔ ŋalompəs ki yɛcəmɛnɛ ya dəkusuŋka da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, tetek toloŋnɛ pa kɔpər kɔ manta ma kɔpər mɔkɔ ananɛp pi mɔ, kɔ yosumpər-sumpər ya tetek fəp, ");
INSERT INTO bsp_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kɔ yɛcəmɛnɛ ya saŋka kɔ ya dəkusuŋka da saŋka, kɔ cəgbo cədɔf ca dəkiyi dosoku kɔ ca saŋka fəp. ");
INSERT INTO bsp_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Səbeŋa sa alom ŋa məntambɛnc, alom ŋa bulu, kɔ alom ŋeyim sɔ ŋanalompsɛ yamos ya dəKanu nyɛ pəmar pabɛrnɛ a pabəc yɛbəc nde aŋgbip ŋosoku mɔ. K'alompsɛ sɔ Aruna yamos ya dəKanu pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","K'olompsɛ duma da efɔd kəloto ka səbeŋa sa kentəler, sa kɛma, sa alom ŋa məntambɛnc, alom ŋa bulu, kɔ alom ŋeyim. ");
INSERT INTO bsp_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Kɔ ŋamperi bɔpər ya kɛma nyɛ ŋanagbint-gbinti kɔ ŋanɛkəs yi mɛgbɛr mɛfɛt mɛfɛt mmɛ ŋancbɛrsər cəloto cəfəfər ca səbeŋa sa kentəler, alom ŋa məntambɛnc, alom ŋa bulu, kɔ alom ŋeyim, kɔ tɔyɔnɛ yɛbəc ya acɛrəŋ kədu. ");
INSERT INTO bsp_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","K'ambɛr duma da efɔd yeyesɛ banca mɛrəŋ nyɛ anasɔtərɛnɛ yi cəsək ca banca ya duma da efɔd mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Tabataba mpɛ pɛnanɔŋkər duma da efɔd ŋaŋɔkɔ mɔ. Anasɔtərɛnɛ pi, kɔ yɔyɔnɛ paka pin kɔ duma da efɔd: Tolompəs ta yi tɛnawurɛnɛ: kəloto ka səbeŋa sa kentəler, sa kɛma, sa alom ŋa məntambɛnc, alom ŋa bulu, kɔ alom ŋeyim pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Kɔ ŋalompəs walakɛ wa masar mɔtɔt ma onikəs kɔ ŋambɛrsər mi fərɛm fa kɛma disrɛ. Kɔ ŋancicəs mewe ma awut a Yisrayel, pəmɔ ntɛ ancic tamp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","K'ɔsɔtərɛnɛ masar mamɔkɔ yeyesɛ banca ya duma da efɔd kəroŋ, kəcɛm-cɛməs ka mewe ma awut a Yisrayel (Yakuba), pəmɔ ntɛ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","K'ondunɛ yuba yɛgbɛknɛ dɛbəkəc kəloto ka səbeŋa sa kentəler, panɔŋkəl səbeŋa sa kɛma, sa alom ŋa məntambɛnc, alom ŋa bulu kɔ alom ŋeyim, pəmɔ tɔkɔ analompəs duma da efɔd mɔ. Yɛbəc ya wəcɛrəŋ kədu yɛnayi. ");
INSERT INTO bsp_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Yuba yɛgbɛknɛ dɛbəkəc yayɔkɔ ananut yi kəmɛrəŋ, yɛtəŋnɛnɛ cəsək fəp dobolu da cəsək ca yi dɛnayɔ kəca disrɛ katin. ");
INSERT INTO bsp_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Kɔ ŋandɛtər ki masar momotər-motər cəgba maŋkəlɛ: Kəgba kəcɔkɔ-cɔkɔ kənayɔ tasar teyim, tasar t'alom ŋa cəbe, kɔ tasar pa alom ŋobuk mɛl. ");
INSERT INTO bsp_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Kəgba ka mɛrəŋ kənayɔ tasar teyim ceŋ, tasar t'alom ŋa bulu kɔ diyamaŋ. ");
INSERT INTO bsp_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Kəgba ka maas kənayɔ Tasar pa alom ŋa alembəra, tasar pa lom yɛla cəgbɛr kɔ tasar pa alom ŋa məntambɛnc. ");
INSERT INTO bsp_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Kəgba ka maŋkəlɛ kənayɔ tasar pa alom ŋobuk mɛl, tasar pa lom yɛcɛmcɛmər kɔ tasar pa alom ŋobuk. Tasar o tasar anasɛtər pi dəfərɛm fa kɛma. ");
INSERT INTO bsp_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tasar o tasar anacic pi tewe ta wan wəkin wəka Yisrayel (Yakuba), pəmɔ tɔkɔ ancic tamp mɔ. Ti tencmentər mewe ma cusuŋka ncɛ wəco kɔ mɛrəŋ (12) ca Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kɔ ŋalompsɛ yuba yɛgbɛknɛ dɛbəkəc yayɔkɔ megbekce ma kɛma kəsoku pɛs. ");
INSERT INTO bsp_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Kɔ ŋalompəs fərɛm mɛrəŋ fa kɛma, kɔ curundɛ mɛrəŋ ca kɛma ncɛ anabɛr moŋkubut mɛrəŋ ma yuba yɛgbɛknɛ dɛbəkəc makəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","K'aŋgbɛkər megbekce mamɔkɔ mɛrəŋ ma kɛma curundɛ cəkɔ cəyi dəmoŋkubut ma yuba yɛgbɛknɛ dɛbəkəc yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Kɔ ŋaŋkɔ ŋaŋgbɛkər cəsək cəlpəs ca megbekce mamɔkɔ mɛrəŋ dəfərɛm mɛrəŋ nfɛ fənayi yeyesɛ banca ya duma da efɔd mɔ tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kɔ ŋalompəs sɔ curundɛ mɛrəŋ ca kɛma kɔ ŋambɛr ci moŋkubut ma yuba yɛgbɛknɛ yayɔkɔ tantɔf, kəsək nkɛ kəncgbuŋɛnɛ duma da efɔd mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kɔ ŋalompəs sɔ curundɛ mɛrəŋ cəlɔma ca kɛma ncɛ ŋanabɛr yeyesɛ banca ya duma da efɔd tantɔf mɔ, tekiriŋ, dəkəsɔtərɛnɛ da yi nde pəsurɛnɛ kɔ takəroŋ ta tabataba ta duma da efɔd mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kɔ ŋaŋkotərɛnɛ curundɛ ca yuba yɛgbɛknɛ dɛbəkəc kɔ ca duma da efɔd kəbənda ka alom ŋa məntambɛnc, kɔ tɔsɔŋɛ yuba yɛgbɛknɛ dɛbəkəc kədeŋsɛ takəroŋ ta tabataba pa duma da efɔd, tɔsɔŋɛ sɔ yuba kətɔtam kəsakɛnɛ kɔ duma da efɔd, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","K'ondunɛ burumus ba efɔd səbeŋa sa alom ŋa məntambɛnc fəp, yɛbəc ya wəcɛrəŋ kədu yɛnayi. ");
INSERT INTO bsp_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Dəkəməl domp da duma dadɔkɔ dacɔ dɛnayi, pəmɔ ntɛ andunɛ yamos akata mɔ. Anagbɛnt di kilim haŋ panɔŋkər ntɛ tɔŋsɔŋɛ ta dɛwalɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kɔ ŋandu bi tantɔf haŋ kɔ ŋanɔŋkər cəpare ca alom ŋa məntambɛnc, alom ŋa bulu, alom ŋeyim kɔ səbeŋa sa kentəler. ");
INSERT INTO bsp_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Kɔ ŋalompəs meŋgbeŋkəle ma kɛma kəsoku pɛs, kɔ ŋambɛrsər-bɛrsər yi burumus tantɔf haŋ kɔ ŋanɔŋkər lulu ya cəpare dacɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Teŋgbeŋkəle pin kəpare kin, teŋgbeŋkəle pin kəpare kin k'ambɛrsər yi burumus haŋ k'anɔŋkər, ntɛ tɔŋsɔŋɛ pəkɔbəc'em pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","K'acɛrəŋ kədu ŋasɔtɛ sɔ Aruna kɔ awut ɔn duma dedisrɛ da kəloto ka səbeŋa sa kentəler. ");
INSERT INTO bsp_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Cəfakəl, məmbo kɔ cɔgba fəp fa yi fənayɔnɛ kəloto ka kentəler. ");
INSERT INTO bsp_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","K'acɛrəŋ ŋandunɛ mabamaba kəloto ka səbeŋa sa kentəler, ŋanɔŋkəsəl səbeŋa sa alom ŋa məntambɛnc, sa alom ŋa bulu, kɔ sa alom ŋeyim, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Kɔ ŋalompsɛ abɔpər ŋa dəKanu kɛma kəsoku pɛs, k'ancic ŋi kəroŋ «Dosoku da MARIKI» pəmɔ ntɛ ancic tamp mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kɔ ŋaŋkotərɛnɛ tɛbənda ta alom ŋa məntambɛnc kəfakəl takəroŋ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Kɔ yɛbəc ya dəkiyi dosoku, y'aŋgbancan ŋɛbəpɛnɛ kɔ Kanu yelip oŋ. Aka Yisrayel ŋanasurɛnɛ kəyɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","K'aka Yisrayel ŋaŋkɛrɛ Musa dəkəyi dosoku: Aŋgbancan kɔ ca ya ŋi: ŋkora ya ŋi, fərɛm fa ŋi, gbat-gbata ya ŋi, mogbu ma ŋi kɔ yɛcəmɛnɛ ya ŋi, ");
INSERT INTO bsp_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kata ya ŋkesiya yorkun nyɛ aŋgbət alom ŋeyim, pokumpɛ pa kata ya ntempeli, kɔ kəloto kəŋɛrɛ, ");
INSERT INTO bsp_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","kaŋkəra nkɛ kəmentər danapa da MARIKI, kɔ cəgbo ca ki kɔ afɛŋk ŋɔsɔksɛ kiciya, ");
INSERT INTO bsp_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","amɛsa kɔ yosumpər-sumpər ya ŋi fəp, kɔ cəcom ncɛ aloŋnɛnɛ Kanu mɔ, ");
INSERT INTO bsp_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","pɛdɛtɛ səlamp pa kɛma kəsoku pɛs kɔ səlamp sa pi, yosumpər-sumpər ya pi fəp kɔ moro momotɛnɛ ma pi, ");
INSERT INTO bsp_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","tetek toloŋnɛ pa kɛma, moro mɔbɔy, suray səbotu ambɔnc, kəloto kəŋɛrɛ ka dəkusuŋka da aŋgbancan, ");
INSERT INTO bsp_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","tetek toloŋnɛ pa kɔpər kɔ manta ma kɔpər, kɔ cəgbo ca pi kɔ yosumpər-sumpər ya pi, kəsamp kəbɛrɛ domun dɔsɔkəsnɛnɛ kɔ pɛcəmɛnɛ pa ki, ");
INSERT INTO bsp_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","cəloto ca saŋka kɔ mogbu ma ci, kɔ yɛcəmɛnɛ ya mi, kəloto kəŋɛrɛ dəkusuŋka da saŋka, kəlɛkɛnɛ bənda kɔ cəgbo cədɔf ca yi, yosumpər-sumpər nyɛ pənamar pabəcɛ dəkiyi dosoku mɔ fəp, aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ fəp, ");
INSERT INTO bsp_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","yamos yodu yɔkɔ pəmar pabɛrnɛ a pabəc yɛbəc nde aŋgbip ŋosoku mɔ, kɔ yamos ya dəKanu nyɛ Aruna kɔ awut ɔn ŋandekɔ ŋacbɛrnɛ a ŋacbəcɛ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Aka Yisrayel ŋanabəc yɛbəc yayɔkɔ pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ntɛ Musa ɛnəŋk a ŋasurɛnɛ kəbəc yɛbəc fəp yɔkɔ MARIKI ɛnasom kəbəc mɔ, k'ontolanɛ aka Yisrayel pətɔt. ");
INSERT INTO bsp_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋɔcɔkɔ-cɔkɔ, məcəmbər dəkiyi dosoku, aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Məbɛrsɛ di kaŋkəra nkɛ kəyɔ walakɛ nwɛ wementər danapa dem kɔ aka Yisrayel mɔ, məkəŋkɛ kaŋkəra kaŋkɔ kəloto ta afum ŋacnəŋk ki. ");
INSERT INTO bsp_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Məkɛrɛ amɛsa məcəmbər ŋi kəroŋ yosumpər-sumpər tɔkɔ pəmar mɔ. Məkɛrɛ pɛdɛtɛ səlamp məcəmbər, mədɛt pi səlamp. ");
INSERT INTO bsp_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Məkɔ məcəmbər tetek toloŋnɛ pa kɛma mpɛ ande paccɔf suray nsɛ səmbɔt ambɔnc mɔ, tekiriŋ ta kaŋkəra nkɛ kəmentər danapa da MARIKI mɔ. Kɔ telip-ɛ, mədɛt kəloto kəŋɛrɛ nde kusuŋka ka dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Məcəmbər tetek toloŋnɛ yɔcɔl yɔcɔf nde dəkəbɛrɛ da dəkiyi dosoku, ndɛ dɔyɔnɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Məcəmbər kəsamp aŋgbip kɔ tetek toloŋnɛ dacɔ, palas ki domun. ");
INSERT INTO bsp_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Məcəmbər saŋka haŋ mənɔŋkər, mədɛt kəloto kəŋɛrɛ dəkusuŋka da si.» ");
INSERT INTO bsp_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Məlɛk moro mɔbɔy məsop mi dəkiyi dosoku kɔ yosumpər-sumpər ya di fəp. Məpus di kɔ yosumpər-sumpər ya di ntɛ tɔŋsɔŋɛ ca cacɔkɔ fəp nde dəkiyi dosoku kɔ disrɛ yɔyɔnɛ yopus fɔr ya MARIKI kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Məbɔy tetek toloŋnɛ mpɛ ancɔfɛ MARIKI yɔcɔl mɔ, kɔ yosumpər-sumpər ya pi, məpusɛ MARIKI tetek toloŋnɛ, tɔsɔŋɛ pi oŋ kəyɔnɛ posoku pɛs fɔr yem kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Məbɔy kəsamp kɔ pɛcəmɛnɛ pa ki, məpusɛ yi sɔ MARIKI.» ");
INSERT INTO bsp_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Məcɔŋɛnɛ Aruna kɔ awut ɔn arkun nde kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, məbikɛ ŋa domun. ");
INSERT INTO bsp_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Məbɛr Aruna yamos yɔn ya dəKanu, məbɔy kɔ moro ma dəKanu, tɛm tatɔkɔ məsɔkəs kɔ pəbəc'em oŋ yɛbəc ya wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Məcɔŋɛnɛ sɔ awut ɔn məbɛrəs ŋa duma dedisrɛ daŋan. ");
INSERT INTO bsp_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Məbɔy ŋa moro ma dəKanu pəmɔ tɔkɔ məmbɔy mi kas kəŋan mɔ. Ŋa sɔ ŋade ŋabəc'em pəmɔ aloŋnɛ. Kəbɔy ka moro ma dəKanu kaŋkɔ kəndesɔŋɛ ŋa kətɔmpər yɛbəc ya kəloŋnɛ kem doru o doru.» ");
INSERT INTO bsp_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Kɔ Musa ɔyɔ tɔkɔ MARIKI ɛnasom kɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋɔcɔkɔ-cɔkɔ ŋa teren ta mɛrəŋ, k'ancəmbər dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kɔ Musa ɛncəmbər dəkiyi dosoku kɔ yɛcəmɛnɛ ya di, k'ɛncəmbər fərɛm, k'emperi cəgbo, k'ɛncəmbər mogbu. ");
INSERT INTO bsp_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ntɛ elip mɔ, k'emperi kəloto kəkumpɛ dəkiyi dosoku, k'oluksərnɛ k'ɛŋgbəpər kəloto ka mɛrəŋ takəroŋ, pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Kɔ Musa ɛlɛk walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel wɔkɔ anacicəs mɔ, k'ɛmbɛr kaŋkəra disrɛ, k'osor cəgbo cəlɛkɛ ca kaŋkəra kaŋkɔ, k'ɛlɛk afɛŋk ŋɔsɔksɛ kiciya k'ɛŋgbəpər ki takəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","K'ɛlɛk kaŋkəra k'eŋkekərɛ ki nde dəkiyi dosoku disrɛ. K'ɛndɛt kəloto kəkəŋkɛ nkɛ kəyi tekiriŋ ta kaŋkəra nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel mɔ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Kɔ Musa ɛncəmbər amɛsa aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ, ntende kəca kəmeriya ka dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","K'ɛncəmbər-cəmbər cəcom fɔr ya MARIKI kiriŋ, pəmɔ tɔkɔ nkɔn MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","K'ɛncəmbər pɛdɛtɛ səlamp aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ, pɛtɛfərɛnɛ kɔ amɛsa, ntende kəca kətɔt ka dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","K'ɛncəmbər səlamp MARIKI fɔr kiriŋ, pəmɔ tɔkɔ nkɔn MARIKI ɛnasom ti nkɔn Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Kɔ Musa ɛncəmbər tetek pa kɛma nde aŋgbancan ŋɛbəpɛnɛ disrɛ kəloto kəkəŋkɛ tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","K'ɔncɔf suray səbotu ambɔnc, pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","K'ɛndɛt kəloto kəŋɛrɛ nde kusuŋka da dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Kɔ Musa ɛncəmbər tetek toloŋnɛ yɔcɔl yɔcɔfɛ MARIKI nde kusuŋka ka dəkiyi dosoku, ndɛ dɔyɔnɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, k'oloŋnɛ di pɔcɔl pɔcɔf, kɔ kəloŋnɛ ka mɛŋgbɛn, pəmɔ tɔkɔ MARIKI ɛnasom ti nkɔn Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Kɔ Musa ɛncəmbər kəsamp aŋgbancan ŋɛbəpɛnɛ kɔ tetek toloŋnɛ dacɔ, k'ambɛr ki domun dɔsɔkəsnɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Kəlɛk nkɔn Musa kəbəp ka Aruna haŋ awut ɔn arkun kɔ ŋambikɛnɛ waca kɔ wɛcək teta kəsɔkəsnɛ. ");
INSERT INTO bsp_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kɔ ŋande kəcbɛrɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ ŋackɔ kəlɔtərnɛ tetek toloŋnɛ-ɛ, mɛnɛ ŋambikɛnɛ teta kəsɔkəsnɛ pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kɔ Musa ɛncəmbər saŋka k'ɔnɔŋkər dəkiyi dosoku kɔ tetek toloŋnɛ, k'ɛndɛt kəloto kəŋɛrɛ nde kusuŋka ka saŋka. Tatɔkɔ tɔ Musa ɛnaləpəs yɛbəc nyɛ MARIKI ɛnasom kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ntɛ yɛbəc nyɛ yelip mɔ, kɔ kəp kənder kəgbəpərnɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, kɔ nɔrɔ da debeki da MARIKI dender dɛlas dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Tɛnasɔŋɛ ta Musa ɛntam kəbɛrɛ daŋgbancan ŋɛbəpɛnɛ-ɛ, bawo kəp kənayi ŋi kəroŋ kɔ nɔrɔ da debeki da MARIKI dɛnalas dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tɛm ntɛ aka Yisrayel ŋaccepɛ-cepɛ mɔ, ŋacyɛfɛ fɛ kəlɛk dɔpɔ mɛnɛ kəp kənuŋkɛnɛ kəyɛfɛ dəkiyi dosoku kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kɔ kəp kəntɔyɛfɛ-ɛ, aka Yisrayel ŋafɔcepɛ haŋ dɔsɔk ndɛ kəŋyɛfɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Dɔsɔk disrɛ, kəp ka MARIKI kəncyi dəkiyi dosoku kəroŋ, kɔ pəmbiyɛ-ɛ nɛnc dencyi sɔ dəkiyi dosoku kəroŋ, tatɔkɔ tɛnayi fɔr ya aka Yisrayel fəp kiriŋ, tɛm ntɛ ŋanayi kəcepɛ-cepɛ kəŋan disrɛ fəp mɔ.");
INSERT INTO bsp_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Kɔ MARIKI ewe Musa kəyɛfɛ ka nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, k'osom kɔ: ");
INSERT INTO bsp_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Məloku aka Yisrayel ntɛ: Kɔ fum wəkin nəna dacɔ ɛfaŋ kəpocɛ MARIKI pɔcɔl teta kəloŋnɛ-ɛ, ɛntam kəlɛk pi nde cir, ŋkesiya kɔ pəyɔnɛ fɛ ti-ɛ cəna cɔn dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kɔ fum endekenɛ MARIKI wana teta poloŋnɛ pɔcɔf pɔn-ɛ, pɔyɔnɛ tura pɔtɔyɔ dolokəp. Wəkayi pəkekərɛ pi nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ntɛ tɔŋsɔŋɛ MARIKI pəbaŋ kəpocɛ kaŋkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Wəkayi pədeŋ kəca kɔn pɔcɔl poloŋnɛ pɔcɔf papɔkɔ dəromp, MARIKI ɛmbaŋ kəpocɛ kaŋkɔ teta kəsɔkəs ka kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Wəkɛrɛ ka tura papɔkɔ pəfay pi MARIKI fɔr kiriŋ. Awut arkun yuruya ya Aruna aloŋnɛ ŋasu tɔbɔl, mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. Ŋamentər mi MARIKI, ŋawɛsəsər mi cəsək ca tetek toloŋnɛ mpɛ peyi dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ haŋ ŋanɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Fum wəkayi pənat poloŋnɛ pɔcɔf papɔkɔ, pəcɛnəs pi fəkəl fəkəl. ");
INSERT INTO bsp_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Awut arkun a Aruna wəloŋnɛ ŋade ŋacmot nɛnc nde tetek toloŋnɛ ta Kanu kəroŋ, ŋade ŋaccɔl tɔk dənɛnc. ");
INSERT INTO bsp_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Awut arkun a Aruna aloŋnɛ ŋade ŋacboc fəkəl ya sɛm yayɔkɔ, domp kɔ moro ma yi ŋade ŋacdeŋ yi dətɔk ya nɛnc nde tetek toloŋnɛ Kanu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Wəkɛrɛ tura papɔkɔ pəyakɛ yedisrɛ kɔ wɛcək wa pi domun, k'elip-ɛ, wəloŋnɛ wəkin pəlɛk yi pəcɔfɛ MARIKI fəp nde tetek toloŋnɛ kəroŋ. Pɔcɔl pɔcɔf pɔ, kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kɔ fum endekenɛ pɔcɔl poloŋnɛ pɔcɔf mpɛ ɛlɛk dəŋkesiya kɔ pəyɔnɛ fɛ ti dəcir cɔn mɔ-ɛ, pɔyɔnɛ porkun mpɛ pɔntɔyɔ dolokəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Pəfay pi tetek toloŋnɛ Kanu kəca kəmeriya nkɛ dec dɛmpɛ mɔ MARIKI fɔr kiriŋ, pabɛr mecir mamɔkɔ fəp tɔbɔl disrɛ. Awut arkun a Aruna aloŋnɛ ŋalɛk mecir mamɔkɔ ŋawɛsəsər mi tetek toloŋnɛ Kanu cəsək fəp. ");
INSERT INTO bsp_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Wəsɔŋ pɔcɔl papɔkɔ pəcɛnəs pi fəkəl fəkəl, domp kɔ moro, wəloŋnɛ pədeŋ fəkəl ya sɛm yayɔkɔ nɛnc da tetek toloŋnɛ Kanu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Pəyakɛ yedisrɛ kɔ wɛcək wawɔkɔ domun. Wəloŋnɛ pəlɛk pəkenɛ yi fəp MARIKI, pəcɔfɛ kɔ yi nde tetek toloŋnɛ kəroŋ. Pɔcɔl pɔcɔf pɔ, kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kɔ fum endekenɛ MARIKI abɛmp teta poloŋnɛ pɔcɔf-ɛ, wəkayi pəlɛk mɔpay kɔ pəyɔnɛ fɛ ti-ɛ, ntantoriya. ");
INSERT INTO bsp_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Wəloŋnɛ pəkekərɛ abɛmp nŋɛ nde dətetek toloŋnɛ ta Kanu kəroŋ, pəkɔncəl ŋi kilim, pəcɔfɛ ŋi MARIKI domp nde tetek toloŋnɛ kəroŋ, pəloŋər mecir ma abɛmp ŋaŋɔkɔ tetek toloŋnɛ Kanu cəsək. ");
INSERT INTO bsp_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Wəloŋnɛ pəwurɛ tɔlɔba pɛmɛŋkɛ yeri kɔ rɔt ya abɛmp ŋaŋɔkɔ, pəgbal yi tetek toloŋnɛ Kanu kəsək ntende dec dɛmpɛ mɔ, nde ambɛr kəbof kəboŋu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Wəloŋnɛ pəgberi abɛmp ŋaŋɔkɔ banca dacɔ kɛp mɛrəŋ, mba ta pəgbɛy ŋi. Pəcɔfɛ ŋi MARIKI nde tɔk ya tetek toloŋnɛ kəroŋ. Pɔcɔl pɔcɔf pɔ, kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc.» ");
INSERT INTO bsp_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kɔ fum endekenɛ MARIKI yoloŋnɛ ya mɛŋgbɛn-ɛ, yɔyɔnɛ kəmbefe kətɔt pəloŋər ki moro, pədeŋər ki suray sətɔt sa kəlɔl ka kətɔk. ");
INSERT INTO bsp_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Pəkɛrɛ kəmbefe kaŋkɔ awut arkun a Aruna aloŋnɛ. Wəloŋnɛ wəkin pəwɛt kəmbefe kaŋkɔ aloŋər moro mɔ aŋkulma katin kɔ suray sətɔt sayi fəp, pəcɔfɛ yi MARIKI nde dətetek toloŋnɛ kəroŋ, tɛcɛmcɛməs tɔ. Kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kəmbefe kəlpəs ka kəloŋnɛ ka mɛŋgbɛn kaŋkɔ, Aruna kɔ yuruya yɔn ŋayɔ ki. Kəloŋnɛ kəsoku kəpus kɔ, bawo dəyoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, kəyɛfɛ. ");
INSERT INTO bsp_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kɔ pəyɔnɛ məckekərɛ poloŋnɛ pa mɛŋgbɛn mpɛ ancɔf dəpɔcɔfɛ kəcom mɔ, pɔyɔnɛ kəmbefe kətɔt, kəcom kəlok-lok kətɔnɔŋkəl lebin panɔktərɛnɛ ki moro, kɔ pəyɔnɛ fɛ ti biskit bɔtɔnɔŋkəl lebin pasopət bi moro. ");
INSERT INTO bsp_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kɔ məde məckekərɛ kəcom kənɛkət teta kəloŋnɛ ka mɛŋgbɛn-ɛ, kəyɔnɛ kəmbefe kətɔt kənɔktərɛnɛ kɔ moro ma olif ta kəyɔ lebin. ");
INSERT INTO bsp_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Patepi kəcom kaŋkɔ mopoc mopoc, paloŋər sɔ ki moro. Kəloŋnɛ ka mɛŋgbɛn kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kɔ məndekekərɛ kəcom nkɛ anɛkət dətap teta kəloŋnɛ ka mɛŋgbɛn mɔ-ɛ, panɔktərɛnɛ kəmbefe kətɔt kaŋkɔ kɔ moro ma olif. ");
INSERT INTO bsp_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Məkenɛ MARIKI kəloŋnɛ ka mɛŋgbɛn nkɛ alompəs mɔ, pakɛrɛ ki wəloŋnɛ nwɛ ɔŋkɔlɔtərnɛnɛ ki tetek toloŋnɛ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kəloŋnɛ ka mɛŋgbɛn kɔ, wəloŋnɛ pəbeli pɔkɔ aŋkɔkɛrɛ MARIKI teta kəcɛm-cɛməs mɔ, pəcɔfɛ ki MARIKI dəndo dətetek toloŋnɛ kəroŋ. Kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ kɔ, nkɛ ambɔnc ŋa ki ŋontorɛ-torɛ kɔ abəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kəmbefe kəlpəs ka kəloŋnɛ ka mɛŋgbɛn kaŋkɔ, Aruna kɔ yuruya yɔn ŋayɔ ki. Kəloŋnɛ kəsoku kəpus kɔ, bawo dəyoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, kəyɛfɛ. ");
INSERT INTO bsp_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ali kəloŋnɛ ka mɛŋgbɛn kin nkɛ andekenɛ MARIKI mɔ ta kənɔŋkəl lebin. Ta pacɔfɛ MARIKI poloŋnɛ mpɛ o mpɛ anɔŋkəl lebin kɔ pəyɔnɛ fɛ ti-ɛ mɛsɛ ma cəme mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Nəkenɛ MARIKI yɛtɛl yɔcɔkɔ-cɔkɔ ya yɔbɔf yonu, mba ta pacɔfɛ kɔ yi nde dətetek toloŋnɛ kəroŋ, pəmɔ yoloŋnɛ nyɛ ancɔfɛ kɔ teta ambɔnc ŋɔkɔ ŋontorɛ-torɛ kɔ abəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Poloŋnɛ pa mɛŋgbɛn mpɛ o mpɛ mənde məckenɛ MARIKI mɔ, payɛk-yɛkər pi mɛr. Ta məsak kəloŋnɛ ka mɛŋgbɛn kam ta kəyɔ mɛr-ɛ, bawo mɛr mɔyɔnɛ tɛcɛmcɛməs ta kəsek ka Kanu kam danapa kɔ aka Yisrayel. Yoloŋnɛ fəp məyɛk-yɛkər yi mɛr. ");
INSERT INTO bsp_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Nənde nəckekərɛ kəloŋnɛ MARIKI mɛŋgbɛn ma yɛtɛl yonu yɔcɔkɔ-cɔkɔ, nənɛktɛ mɛŋgbɛn ma asek ŋɔcɔkɔ-cɔkɔ nɛnc, kɔ telip-ɛ, nəcɔ mɛŋgbɛn mamɔkɔ təmpɛra a nəndekɛrɛ kəloŋnɛ kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Nəloŋər ki moro ma olif, nədeŋər ki suray sətɔt sa kəlɔl ka kətɔk. Kəloŋnɛ ka mɛŋgbɛn kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Wəloŋnɛ nkɔn pəbeli təmpɛra pɔlɔma pəcɔf kɔ moro ma olif kɔ suray sasɔkɔ fəp teta kəcɛm-cɛməs. Kəloŋnɛ kɔ nkɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Kɔ fum endekenɛ MARIKI kəloŋnɛ ka kəpaŋnɛ pəforu, tɔyɔnɛ pəclɛk wana wawɔkɔ nde yɔcɔl yɔn dacɔ-ɛ, pəkenɛ MARIKI tura kɔ pəyɔnɛ fɛ ti, wana wɛran nwɛ wɔntɔyɔ dolokəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Pədeŋər kəca kɔn domp da pɔcɔl papɔkɔ a pədefay pi nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Awut arkun a Aruna aloŋnɛ ŋawɛsəsər mecir mamɔkɔ dətetek toloŋnɛ Kanu haŋ ŋanɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Yedisrɛ ya poloŋnɛ pa kəpaŋnɛ pəforu nyɛ ande packekərɛ kəcɔfɛ MARIKI mɔ: Moro mmɛ moŋkump yedisrɛ mɔ fəp, ");
INSERT INTO bsp_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","fi yayɔkɔ mɛrəŋ kɔ moro mɔkɔ moŋkump yi mɔ, kɔ mɔkɔ moŋkump cəsək kɔ pəwotwotər pa mim mɔ, pawurɛ mi fəp tin kɔ fi. ");
INSERT INTO bsp_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Awut arkun a Aruna ŋacɔfɛ yi fəp MARIKI nde dətetek toloŋnɛ kəroŋ kɔ pɔcɔl pɔcɔf mpɛ peyi dənɛnc da tɔk mɔ. Kəloŋnɛ kɔ, nkɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kɔ fum endekenɛ MARIKI pɔcɔl pa kəloŋnɛ ka kəpaŋnɛ pəforu mpɛ ɛlɛk dəŋkesiya kɔ pəyɔnɛ fɛ ti dəcir mɔ, pəkenɛ MARIKI pɔcɔl mpɛ pɔntɔyɔ dolokəp mɔ, pɔyɔnɛ porkun kɔ pəyɔnɛ fɛ ti-ɛ pɛran. ");
INSERT INTO bsp_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kɔ pəyɔnɛ a aŋkesiya ŋɔ-ɛ, pəkekərɛ ŋi nde MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Fum wəkakɔ pədeŋ kəca kɔn domp da poloŋnɛ pɔn, pəfay pi nde tekiriŋ ta aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Awut arkun a Aruna ŋawɛsəsər mecir ma poloŋnɛ papɔkɔ cəsək ca tetek toloŋnɛ Kanu haŋ ŋanɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Dəpoloŋnɛ pa kəpaŋnɛ pəforu papɔkɔ aŋkɛrɛ MARIKI pacɔfɛ kɔ mɔ, wəloŋnɛ wəkin pəkɛrɛ: Moro ma pi, kəleŋa məlməl pagbinti ki nde dəkətiti kɔ moro fəp mmɛ moŋkump yedisrɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","fi yayɔkɔ mɛrəŋ kɔ moro mɔkɔ moŋkump yi mɔ, kɔ mɔkɔ moŋkump cəsək kɔ pəwotwotər pa mim mɔ, pawurɛ mi fəp tin kɔ fi. ");
INSERT INTO bsp_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Wəloŋnɛ pəcɔf yi fəp nde dətetek toloŋnɛ Kanu kəroŋ, yeri nyɛ ancɔfɛ MARIKI mɔ yɔ. ");
INSERT INTO bsp_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kɔ fum endekenɛ MARIKI wir yɔcɔl yɔn dacɔ-ɛ, pəkekərɛ wi MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Pədeŋər pɔcɔl papɔkɔ kəca dəromp, k'elip-ɛ, pafay pi nde tekiriŋ ta aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Awut arkun a Aruna ŋawɛsəsər mecir mamɔkɔ tetek toloŋnɛ Kanu cəsək haŋ ŋanɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Wəloŋnɛ wəkin pəlɛk yedisrɛ ya poloŋnɛ mpɛ aŋkɛrɛ MARIKI mɔ pəcɔfɛ kɔ yi: Moro mɔkɔ moŋkump yedisrɛ ya pɔcɔl papɔkɔ mɔ fəp, ");
INSERT INTO bsp_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","fi yayɔkɔ mɛrəŋ kɔ moro mɔkɔ moŋkump yi mɔ, kɔ mɔkɔ moŋkump cəsək kɔ pəwotwotər pa mim mɔ, pawurɛ mi fəp tin kɔ fi. ");
INSERT INTO bsp_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Wəloŋnɛ pəcɔfɛ yi MARIKI fəp nde dətetek toloŋnɛ kəroŋ. Yeri nyɛ ancɔfɛ MARIKI mɔ yɔ. Ambɔnc ŋa yi ŋontorɛ-torɛ MARIKI abəkəc. Moro ma yɔcɔl yoloŋnɛ fəp, ma MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Sariyɛ sa doru o doru sɔ tendeyɔnɛ dɛtɛmp o dɛtɛmp donu mofo mmɛ nəndendɛ mɔ: Nəfɔde nəcsɔm moro ma wɛsɛm kɔ ma pɔcɔl, nəfɔde nəcmun mecir ma yi.» ");
INSERT INTO bsp_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Məloku aka Yisrayel: Kɔ fum enciya kətɔyɛfɛnɛ disrɛ pəyɔ tes ntɛ sariyɛ sa MARIKI səmɔnɛ mɔ-ɛ, tɔkɔt ntɛ tɔ nəde nəckɔt: ");
INSERT INTO bsp_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kɔ tɔyɔnɛ wəloŋnɛ nwɛ anabɔy moro kəyɔnɛ ka wəkiriŋ k'aloŋnɛ mɔ eciya, pəsɔŋɛ sɔ afum kəsarɛ kiciya-ɛ, pəkenɛ MARIKI teta kiciya kɔn tura pɔtɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Pəkekərɛ tura tatɔkɔ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, nde tekiriŋ ta MARIKI. Wəloŋnɛ pədeŋ tura tatɔkɔ kəca dəromp, pəfay pi MARIKI fɔr kiriŋ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Wəkiriŋ k'aloŋnɛ nwɛ anabɔy moro mɔ pəlɛk mecir mamɔkɔ pəkekərɛ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ");
INSERT INTO bsp_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","pəgbət tɛlər dəmecir mamɔkɔ, pəwɛsəsər haŋ camət-mɛrəŋ MARIKI fɔr kiriŋ, tekiriŋ ta kəloto nkɛ kəŋkəŋk tɔksɔ tosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Wəloŋnɛ pəsop mecir mamɔkɔ lɛn maŋkəlɛ ya moŋkubut ma tetek mpɛ ancɔfɛ Kanu suray pɔkɔ peyi nde tekiriŋ ta MARIKI mɔ, nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. K'elip-ɛ, pəkɔ pəloŋər mecir mɛlpəs ma tura tatɔkɔ nde pɛcəmɛnɛ pa tetek toloŋnɛ mpɛ peyi dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, nde ancɔfɛ MARIKI yɔcɔl yoloŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Pəwurɛ moro fəp ma tura ta kəloŋnɛ ka kiciya, moro mɔkɔ moŋkump yedisrɛ ya pɔcɔl papɔkɔ mɔ fəp, ");
INSERT INTO bsp_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","fi yayɔkɔ mɛrəŋ kɔ moro mɔkɔ mɔfɔktər yi, kɔ mɔkɔ moŋkump yi cəsək kɔ pəwot-wotər pa mim mɔ, pəgbinti mi tin kɔ fi. ");
INSERT INTO bsp_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Pəmɔ ntɛ aŋwurɛ yi nde dətura ta kəloŋnɛ ka kəpaŋnɛ pəforu mɔ, wəloŋnɛ pəcɔfɛ yi MARIKI nde dətetek toloŋnɛ mpɛ ancɔf yɔcɔl yoloŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mba akata ŋa tura, sɛm ya pi fəp, domp, wɛcək kɔ yedisrɛ ya pi kəlɛkɛnɛ yedisrɛ ya aputuk ya pi fəp, ");
INSERT INTO bsp_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yɛlpəs ya tura, wəloŋnɛ pəwurɛnɛ yi dəsaŋka todoru kəfo kəsoku nkɛ aŋgbal kəbof kəboŋu mɔ, pəkɔ pəcɔfɛ yi dəndo nɛnc da tɔk, nde tɛpɛsa pa kəbof kəboŋu kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kɔ pəyɔnɛ a kəloŋkanɛ ka aka Yisrayel fəp ŋaciya tosom tin ta MARIKI ta ŋayɛfɛnɛ ti-ɛ, kɔ ŋayɔ tes ntɛ sariyɛ sa MARIKI səmɔnɛ, tɔsɔŋɛ ŋa kəsarɛ kiciya-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ŋanckɔnacərɛ kiciya kəŋan, ŋakɛrɛ tura teta kəloŋnɛ ka kiciya kaŋkɔ. Ŋakekərɛ tura tatɔkɔ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Abeki a kəloŋkanɛ ka aka Yisrayel ŋadeŋər pi waca dəromp, ŋawurɛ fum wəkin ŋa dacɔ pəfay tura papɔkɔ MARIKI fɔr kiriŋ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Wəkiriŋ k'aloŋnɛ wəkɔ anabɔy moro mɔ, pəkekərɛ mecir ma pi nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Wəloŋnɛ pəgbət tɛlər dəmecir mamɔkɔ, pəwɛsəsər mi kəloto kəŋkɔ kəŋkəŋk tɔksɔ tosoku mɔ haŋ camət-mɛrəŋ MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Pəsopət sɔ mecir mamɔkɔ lɛn maŋkəlɛ ya moŋkubut ma tetek mpɛ ancɔf suray mpɛ peyi MARIKI fɔr kiriŋ mɔ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ. Pəloŋər mecir mɛlpəs fəp nde pɛcəmɛnɛ pa tetek toloŋnɛ Kanu pɔcɔl pɔcɔf mpɛ peyi nde dəkəbɛrɛ d'aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Pəwurɛ moro ma pɔcɔl papɔkɔ fəp pəcɔfɛ mi MARIKI nde tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Pəyɔ teta tura tatɔkɔ pəmɔ tɔkɔ ɔŋyɔ teta tura mpɛ aŋloŋnɛ teta kiciya mɔ, wəloŋnɛ pətubucnɛ kəsɔkəs aka Yisrayel kiciya kəŋan, MARIKI pəŋaŋnɛnɛ ŋa ki. ");
INSERT INTO bsp_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Wəloŋnɛ pəlɛk yɛlpəs ya tura papɔkɔ pəwurɛnɛ saŋka todoru, pəkɔ pəcɔf yi pəmɔ tura poloŋnɛ pa kiciya ka nkɔnsərka. Kəloŋnɛ ka kiciya ka kəloŋkanɛ k'aka Yisrayel fəp kɔ kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Kɔ pəyɔnɛ a wəkiriŋ wəkin eciya MARIKI ta ɛyɛfɛnɛ ti, pəyɔ tes ntɛ sariyɛ sa MARIKI Kanu kɔn səmɔnɛ mɔ, tɔsɔŋɛ kɔ kəsarɛ kiciya-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ɔnckɔnacərɛ kiciya kaŋkɔ, pəkɛrɛ ambiyofo nŋɛ ŋɔntɔyɔ dolokəp mɔ teta kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Pədeŋər ambiyofo ŋaŋɔkɔ kəca dəromp, pəfay ŋi kəfo nkɛ aŋfay yoloŋnɛ yɔcɔf mɔ, nde MARIKI fɔr kiriŋ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Kəloŋnɛ ka kiciya kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Wəloŋnɛ pəgbət tɛlər tɔn mecir ma pɔcɔl pa kəloŋnɛ ka kiciya, pəsopət mi lɛn maŋkəlɛ ya moŋkubut ma tetek mpɛ ancɔfɛ MARIKI yoloŋnɛ mɔ, pəloŋər pɛcəmɛnɛ pa tetek tatɔkɔ mecir mɛlpəs mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Pəcɔfɛ MARIKI moro ma pɔcɔl papɔkɔ fəp nde dətetek toloŋnɛ kəroŋ, pəmɔ moro ma kəloŋnɛ ka kəpaŋnɛ pəforu. Wəloŋnɛ pətubucnɛ kəsɔkəs ka wəkiriŋ kəciya kɔn, MARIKI ɛŋŋaŋnɛnɛ kɔ kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Kɔ pəyɔnɛ a fum wəlɔma gbəcərəm wəka dɔtɔf eciya sariyɛ sa MARIKI ta ɛyɛfɛnɛ ti, pəyɔ tes ntɛ sariyɛ sa MARIKI səmɔnɛ mɔ, tɔsɔŋɛ kɔ kəsarɛ kiciya-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ɔnckɔnacərɛ kiciya kɔn, pəkɛrɛ wir wɛran nwɛ wɔntɔyɔ dolokəp mɔ teta kəloŋnɛ ka kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Pədeŋər pɔcɔl pa kəloŋnɛ papɔkɔ kəca dəromp, pəfay pi nde aŋfay yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Wəloŋnɛ pəgbət tɛlər tɔn dəmecir ma pɔcɔl pa kəloŋnɛ ka kiciya kaŋkɔ, pəsopət mi lɛn maŋkəlɛ ya moŋkubut ma tetek mpɛ ancɔfɛ MARIKI yoloŋnɛ yɔcɔf mɔ, pəloŋər mecir mɛlpəs mɔkɔ pɛcəmɛnɛ pa pi. ");
INSERT INTO bsp_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Pəwurɛ moro ma pɔcɔl papɔkɔ fəp, pəmɔ tɔkɔ aŋwurɛ moro ma poloŋnɛ pa kəpaŋnɛ pəforu mɔ. Wəloŋnɛ pəcɔfɛ mi MARIKI nde tetek toloŋnɛ kəroŋ, ambɔnc ŋaŋɔkɔ ŋontorɛ-torɛ MARIKI abəkəc. Wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kiciya kɔn, MARIKI ɛŋŋaŋnɛnɛ kɔ ki. ");
INSERT INTO bsp_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kɔ pəyɔnɛ a fum wəkayi aŋkesiya ŋ'ɛŋkɛrɛ kədeloŋnɛ teta kiciya kɔn-ɛ, pəkɛrɛ aŋkesiya ŋɛran nŋɛ ŋɔntɔyɔ dolokəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Fum wəkakɔ pədeŋ kəca kɔn pɔcɔl pa kəloŋnɛ ka kiciya dəromp, pəfay pi nde kəfo nkɛ aŋfay yɔcɔl yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Wəloŋnɛ pəgbət tɛlər tɔn dəmecir ma pɔcɔl poloŋnɛ pa kiciya, pəsopət mi lɛn maŋkəlɛ ya moŋkubut ma tetek mpɛ ancɔfɛ MARIKI yoloŋnɛ mɔ, pəloŋər mecir mɛlpəs mamɔkɔ pɛcəmɛnɛ pa pi. ");
INSERT INTO bsp_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Pəwurɛ moro ma pɔcɔl papɔkɔ fəp, pəmɔ tɔkɔ aŋwurɛ moro ma aŋkesiya nŋɛ aŋloŋnɛ kəpaŋnɛ ka pəforu mɔ. Wəloŋnɛ pəcɔfɛ mi MARIKI nde tetek toloŋnɛ kəroŋ kɔ yoloŋnɛ yɔkɔ ancɔfɛ MARIKI mɔ. Wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kiciya kɔn, MARIKI ɛŋŋaŋnɛnɛ kɔ ki.» ");
INSERT INTO bsp_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kɔ fum entəŋnɛ tes-ɛ, pawe dəŋkiti fum wəkakɔ ɛncərɛ tes tatɔkɔ mɔ, wəkayi pəciya kətɔwosɛ kəloku tɔkɔ ene kɔ pəyɔnɛ fɛ ti tɔkɔ ɛncərɛ tes tatɔkɔ mɔ, ɛŋsarɛ kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Kɔ fum oŋgbuŋɛnɛ paka mpɛ o mpɛ pɔtɔsɔk ta ɛyɛfɛnɛ ti-ɛ, tɔyɔnɛ wɛsɛm wefi, pɔcɔl pefi, pəliŋɛ-liŋɛ pefi, fum wəkayi ɔŋyɔnɛ wətɔsɔk, tɛm tatɔkɔ wəkayi ɛŋsarɛ kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kɔ fum oŋgbuŋɛnɛ pəyikyik pa fum ta ɛyɛfɛnɛ ti tɔŋsɔŋɛ nkɔn sɔ kətɔsɔk, k'endenacərɛ ti tɛlpəs-ɛ, wəkayi ɛŋsarɛ kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Kɔ fum ontorɛ dim pəloku tes o tes ta ɛncɛm-cɛmnɛ tɛləpsər ta ti, pədɛrəm kəyɔ pəlɛc kɔ pəyɔnɛ fɛ ti pətɔt, k'endenacərɛ ti tɛlpəs-ɛ, wəkayi ɛŋsarɛ kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Kɔ fum ɛsarɛ kiciya pəmɔ kaŋkɔ-ɛ, pəkɔ pəcɛŋ teta tes tɔkɔ enciya mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","kɔ tɛyɛfɛ dənda-ɛ, pəkenɛ MARIKI aŋkesiya ŋɛran teta kəloŋnɛ ka kəlompəs ka kiciya kɔn. Pəkɛrɛ sɔ aŋkesiya ŋɛran ŋa teren tin, kɔ pəyɔnɛ fɛ ti wir wɛran wa teren tin teta kəloŋnɛ ka kiciya. Wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kɔ fum ɔntɔyɔ pɔsɔtɔnɛ aŋkesiya kɔ pəyɔnɛ fɛ ti wir teta kəloŋnɛ ka kəlompəs ka kiciya kɔn-ɛ, wəkayi pəkɛrɛ MARIKI mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti-ɛ, ntantoriya mɛrəŋ. Abɛmp ŋin paloŋnɛ ŋi MARIKI pəmɔ tɔkɔ aŋloŋnɛ poloŋnɛ pa kiciya mɔ, abɛmp ŋa mɛrəŋ pəmɔ tɔkɔ aŋloŋnɛ pɔcɔl pɔcɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Fum wəkayi pəkɛrɛ yi wəloŋnɛ, wəloŋnɛ pənuŋkɛnɛ pəkɛrɛ abɛmp nŋɛ MARIKI teta kəloŋnɛ ka kiciya mɔ. Pəkɔncəl ŋi kilim, mba ta pəcopu ki de. ");
INSERT INTO bsp_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Wəloŋnɛ pəwɛsəsər mecir ma kəloŋnɛ ka kiciya cəsək ca tetek toloŋnɛ Kanu kəroŋ, pəloŋər mecir mɛlpəs mɔkɔ pɛcəmɛnɛ pa tetek. Kəloŋnɛ ka kiciya kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kɔ tatɔkɔ tencepər-ɛ, wəloŋnɛ pəcɔfɛ MARIKI abɛmp ŋa mɛrəŋ pəmɔ tɔkɔ sariyɛ səloku ti mɔ. Wəloŋnɛ pətubucnɛ kəsɔkəs ka fum wəkakɔ kəciya kɔn, MARIKI ɛŋŋaŋnɛnɛ kɔ ki. ");
INSERT INTO bsp_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Kɔ fum ɔntɔyɔ pɔsɔtɔnɛ mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti, ntantoriya mɛrəŋ-ɛ, wəkayi pəkɛrɛ kəmbefe kətɔt kilo kəmaas padeloŋnɛ teta kiciya kɔn. Mba teta kəloŋnɛ ka kiciya kaŋkɔ wəkayi ɔfɔbɛr kəmbefe kaŋkɔ moro ma olif, ɔfɔdeŋər sɔ ki suray. Kəloŋnɛ ka kiciya kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Fum wəkayi pəkenɛ wəloŋnɛ kəmbefe kaŋkɔ, wəloŋnɛ pəwɛt ki aŋkulma katin teta kəcɛm-cɛməs, pəcɔf ki nde dətetek toloŋnɛ Kanu kɔ yoloŋnɛ yɔkɔ ancɔfɛ MARIKI mɔ. Kəloŋnɛ ka kiciya kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kɔ telip-ɛ, wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kiciya nkɛ enciya mɔ, MARIKI ɛŋŋaŋnɛnɛ wəkayi kiciya kɔn. Kəcom kəlpəs, ka wəloŋnɛ kɔ, pəmɔ kəloŋnɛ ka mɛŋgbɛn. ");
INSERT INTO bsp_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Kɔ fum ɔntɔcəmɛ sariyɛ sa ca nyɛ ampusɛ MARIKI mɔ darəŋ ta ɛyɛfɛnɛ ti-ɛ, enciya kiciya kəpɔŋ. Pəkɛrɛ poloŋnɛ teta kəloŋnɛ ka kəlompəs ka kiciya kɔn: Aŋkesiya ŋorkun ŋɔtɔyɔ dolokəp. Kəway ka ŋi kəmbəp kəway kəŋkɔ amboncər kɔ nde aŋgbip ŋosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ teta tɔkɔ enciyanɛ aŋgbip mɔ. Pəsɔŋ alamali ŋaŋɔkɔ fəp wəloŋnɛ. Wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kiciya kɔn kɔ ka aŋkesiya ŋoloŋnɛnɛ teta kəlompəs ka kiciya kɔn. MARIKI ɛŋŋaŋnɛnɛ kɔ ki. ");
INSERT INTO bsp_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kɔ fum enciya pəyɔ tes tin ntɛ sariyɛ sa MARIKI səmɔnɛ mɔ, ali tɔyɔnɛ a ɛyɛfɛnɛ fɛ ti, ɛŋsarɛ kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Fum wəkayi pəkɛrɛ wəloŋnɛ aŋkesiya ŋorkun dəyɔcɔl yɔn teta kəlompəs ka kəciya kɔn, nŋɛ ŋɔntɔyɔ dolokəp mɔ. Ŋɛtəŋnɛ kəway ka kəloŋnɛ ka kəlompəs ka kiciya. Wəloŋnɛ pətubucnɛ kəsɔkəs ka wəkayi kiciya kɔn nkɛ ɔntɔyɛfɛnɛ mɔ. Aŋŋaŋnɛnɛ kɔ ki. ");
INSERT INTO bsp_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Kəloŋnɛ ka kəlompəs ka kiciya kɔ, bawo wəkayi ɛsarɛ kiciya nnɔ MARIKI eyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Fum nwɛ o nwɛ enciya MARIKI fɔr kiriŋ, pəyemɛ teta paka mpɛ anasɔŋ kɔ kəmɛŋk, kɔ pəyɔnɛ fɛ ti, paka mpɛ ɛnakiyɛ mɔ, paka mpɛ ɛnabɔ, kɔ pəyɔnɛ fɛ ti pəbaŋər wɛnc mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","kɔ tɔyɔnɛ wəkayi efir paka pɔlɔma, pəde pəgbɛkəl ti tɛlpəs, kɔ pəyɔnɛ fɛ mamɔkɔ fəp, pədɛrəm yem disrɛ, ntɛ tɔŋsɔŋɛ pəmɛŋk tes tɛlɛc pəmɔ tatɔkɔ mɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","fum wəkayi ɛŋsarɛ kiciya. Pəluksɛ paka pɔkɔ eŋkiyɛ, mpɛ anasɔŋ kɔ kəmɛŋk, mpɛ ɛnabaŋər wɛnc, kɔ pəyɔnɛ fɛ ti paka mpɛ ɛnafir mɔ wəsərka. ");
INSERT INTO bsp_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Teta paka mpɛ pɔŋsɔŋɛ fum kədɛrəm yem disrɛ mɔ, pəluksɛ pi fəp wəsərka, mba pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. Pəloŋka daka dadɔkɔ pəsɔŋ wəkɔ ɛnayɔ di mɔ dɔsɔk ndɛ ɛncərɛ a ɛsarɛ kiciya mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Kɔ tatɔkɔ telip-ɛ, fum wəkakɔ pəkenɛ wəloŋnɛ teta kəloŋnɛ ka kəlompəs ka kiciya kɔn nnɔ MARIKI eyi mɔ, aŋkesiya ŋorkun nŋɛ ŋɔntɔyɔ dolokəp, nŋɛ ŋɛntəŋnɛ sɔ kəway nkɛ amboncər kɔ aŋgbip ŋosoku teta kəloŋnɛ kaŋkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Wəloŋnɛ pətubucnɛ kəsɔkəs ka fum wəkakɔ kiciya kɔn MARIKI fɔr kiriŋ, tɔyɔnɛ kiciya nkɛ o nkɛ ɛŋsarɛ mɔ, MARIKI ɛŋŋaŋnɛnɛ kɔ ki.» ");
INSERT INTO bsp_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Məsom Aruna k'awut ɔn arkun tosom ntɛ: Sariyɛ sa pɔcɔl mpɛ ancɔfɛ MARIKI mɔ sɔ saŋsɛ: Pɔcɔl pɔcɔf peyi aco ŋa tetek toloŋnɛ Kanu kəroŋ pibi fəp haŋ dec dɔsɔk, nɛnc da pi dɛmar pibi fəp. ");
INSERT INTO bsp_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Wəloŋnɛ pəbɛrnɛ burumus kɔ kɔgba kɔn ka kəloto ka suwa. Pəwɛt kəbof kəboŋu nkɛ nɛnc dɔncɔfɛna MARIKI poloŋnɛ mɔ, pəboc ki tetek toloŋnɛ Kanu kəsək. ");
INSERT INTO bsp_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","K'elip-ɛ, pəwurɛ yamos yayɔkɔ ɛmbɛrnɛna mɔ, pəlɛk yocuru pəwɛt kəbof kaŋkɔ pəwurɛnɛ ki dəsaŋka, pəkɔ pəboc ki kəfo kəsoku. ");
INSERT INTO bsp_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Nɛnc dɛcmar tetek toloŋnɛ Kanu kəroŋ, ta denimɛ. Bətbət o bətbət wəloŋnɛ pəcɔlər di tɔk, pədeŋ poloŋnɛ pɔcɔf tetek kəroŋ, pəcɔfɛ MARIKI moro ma pɔcɔl poloŋnɛ pa kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Nɛnc dɛcmar tɛm fəp tetek toloŋnɛ Kanu kəroŋ, ta denimɛ few. ");
INSERT INTO bsp_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Sariyɛ nsɛ səcəmɛ kəloŋnɛ ka mɛŋgbɛn darəŋ: Awut arkun a Aruna ŋackɛrɛ ki MARIKI fɔr kiriŋ, tekiriŋ ta tetek toloŋnɛ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Wəloŋnɛ pəwɛt yoloŋnɛ ya mɛŋgbɛn yayɔkɔ aŋkulma katin ŋa kəmbefe kətɔt, moro ma olif kɔ suray sətɔt sa kəlɔl ka kətɔk fəp nsɛ andeŋər yoloŋnɛ ya mɛŋgbɛn mɔ, pəcɔfɛ yi MARIKI fəp dətetek toloŋnɛ kəroŋ. Tɛcɛmcɛməs tɔ. Ambɔnc ŋa yi ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aruna k'awut ɔn arkun ŋalɛk yɛlpəs ya kəloŋnɛ yayɔkɔ, ta ŋanɔŋkəl yi lebin kɔ ŋandedi yi-ɛ. Kəfo kəsoku kɔ ŋadi yeri yayɔkɔ nde abaŋka ŋa aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Afɔnɔŋkəl yi lebin. Yɛlpəs yayɔkɔ y'impocɛ ŋa yoloŋnɛ yem dacɔ, nyɛ ancɔfɛ ina MARIKI mɔ. Yeri yayɔkɔ yosoku yɔ, nyɛ ampusɛ MARIKI pəmɔ tɔkɔ pəyi kəloŋnɛ ka kiciya kɔ ka kəlompəs ka kiciya mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Yuruya ya Aruna arkun gbəcərəm ŋande ŋacsɔm ki. Tede tɔyɔnɛ ŋa sariyɛ sa doru o doru, dɛtɛmp o dɛtɛmp daŋan, ntɛ tɔyɔnɛ ta yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, fum o fum ɔntɔyɔnɛ wəloŋnɛ, a pəgbuŋɛnɛ yoloŋnɛ yayɔkɔ mɔ, ɛŋsarɛ kiciya kəpɔŋ.» ");
INSERT INTO bsp_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Yoloŋnɛ nyɛ yɔ Aruna k'awut ɔn arkun ŋaŋkɛrɛ MARIKI dɔsɔk ndɛ wəkin ŋa dacɔ ɔŋsɔtɔ kəbɔy ka kəyɔnɛ ka wəloŋnɛ mɔ: Kəloŋnɛ ka mɛŋgbɛn kaŋkɔ Aruna k'awut ɔn ŋaloŋnɛ dɔsɔk dadɔkɔ kəmbefe kətɔt kilo kəmaas, kilo katin kɔ dacɔ bətbət, kilo katin kɔ dacɔ dɔfɔy. ");
INSERT INTO bsp_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Panɔktərɛnɛ kəmbefe kaŋkɔ moro ma olif, panɛkət kəcom kaŋkɔ dəkarɔrɔ kəwon. Məde məkenɛ MARIKI kəloŋnɛ ka mɛŋgbɛn kaŋkɔ. Patepi kəcom kəfɛt kəfɛt a padecɔfɛ ki MARIKI, ambɔnc ŋaŋɔkɔ ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Wan ka Aruna nwɛ andebɔy kədəs dekiriŋ da kəloŋnɛ dadɔkɔ mɔ, nkɔn sɔ pəloŋnɛ kəloŋnɛ kaŋkɔ. Sariyɛ sa doru o doru sɔ nnɔ MARIKI eyi mɔ, pacɔfɛ kəcom kaŋkɔ fəp MARIKI. ");
INSERT INTO bsp_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kəloŋnɛ ka mɛŋgbɛn nkɛ o nkɛ ka wəloŋnɛ, pacɔfɛ ki fəp MARIKI, ali kəpic ta pasɔm.» ");
INSERT INTO bsp_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«Məloku Aruna k'awut ɔn: Sariyɛ nsɛ səcəmɛ kəloŋnɛ ka kiciya darəŋ: Kəfo nkɛ aŋfay yɔcɔl yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, difɔ aŋfay sɔ pɔcɔl poloŋnɛ pa kiciya. Paka posoku pɔ mpɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Wəloŋnɛ nwɛ oŋloŋnɛ poloŋnɛ pa kiciya mɔ, pəsɔm pi kəfo kəsoku nde abaŋka ŋa aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Nwɛ o nwɛ oŋgbuŋɛnɛ sɛm ya poloŋnɛ papɔkɔ mɔ, ɛŋsarɛ kiciya kəpɔŋ! Kɔ mecir ma pɔcɔl papɔkɔ afay mɔ mɛncɛsəkər yamos-ɛ, payak pɛcɛsəkər papɔkɔ nde kəfo nkɛ ampus mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Dap da dos ndɛ ampɛcɛ sɛm yayɔkɔ mɔ, k'alip-ɛ, pawɔkəc di. Kɔ pəyɔnɛ a dap da kɔpər d'ampɛcɛ sɛm yayɔkɔ-ɛ, anckɔnalip, pasɔŋk di, payaksɛ di domun. ");
INSERT INTO bsp_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","It'ɔyɔnɛ arkun a dokom d'aloŋnɛ gbəcərəm ŋantam kəsɔm yi: Yeri yosoku yɔ nyɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Mba afɔsɔm pɔcɔl poloŋnɛ pa kiciya mpɛ o mpɛ aŋkekərɛ mecir ma pi nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu teta kətubucnɛ kəsɔkəs ka aŋgbip ŋosoku kətɔsɔk mɔ, ta pasɔm pi, mba paləm pi fəp dənɛnc.» ");
INSERT INTO bsp_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Sariyɛ nsɛ səcəmɛ kəloŋnɛ ka kəlompəs ka kiciya darəŋ. Kəloŋnɛ kaŋkɛ kəsoku kɔ, nkɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kəfo nkɛ aŋfay yɔcɔl yoloŋnɛ yɔcɔf mɔ, aŋfay sɔ pɔcɔl poloŋnɛ teta kəlompəs ka kiciya. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Pawɛsəsər mecir mamɔkɔ cəsək ca tetek toloŋnɛ Kanu haŋ panɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Pakɛrɛ moro ma pi fəp, kəleŋa, kɔ moro mɔkɔ moŋkump yedisrɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","fi yayɔkɔ mɛrəŋ kɔ moro mɔkɔ mɔfɔktər yi mɔ, kɔ pəwot-wotər pa mim mmɛ aŋgbiti tin kɔ fi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Wəloŋnɛ pəcɔfɛ yi MARIKI nde tetek toloŋnɛ kəroŋ. Kəloŋnɛ ka kəlompəs ka kiciya kɔ, nkɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Aloŋnɛ arkun gbəcərəm ŋantam kəsɔm sɛm yayɔkɔ kəfo kəsoku. Kəloŋnɛ kaŋkɛ kəsoku kɔ, nkɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Kəloŋnɛ ka kəlompəs ka kiciya kɔ kəloŋnɛ ka kiciya, sariyɛ sin sayi sɔ kəloŋnɛ kaŋkɛ mɛrəŋ kəyɔ: Sɛm yayɔkɔ, wəloŋnɛ nwɛ ontubucnɛ kəsɔkəs kiciya mɔ, ɔyɔ yi. ");
INSERT INTO bsp_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kɔ wəloŋnɛ eŋkenɛ fum pɔcɔl poloŋnɛ pɔcɔf-ɛ, wəloŋnɛ ɔyɔ akata ŋa pɔcɔl pɔcɔf papɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Poloŋnɛ pa mɛŋgbɛn mpɛ o mpɛ pɔ ancɔf doco, panɛkət dəkarɔrɔ kɔ pəyɔnɛ fɛ ti dədap mɔ, wəloŋnɛ nwɛ eŋkekərɛ pi pəcɔfɛ MARIKI mɔ, ɔyɔ pi. ");
INSERT INTO bsp_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Poloŋnɛ pa mɛŋgbɛn mpɛ o mpɛ p'anɔktərɛnɛ kɔ moro, kɔ pəyɔnɛ fɛ ti-ɛ powos, yuruya ya Aruna fəp ŋɔ aŋyer pi pɛtəŋnɛnɛ ŋa gbɛp. ");
INSERT INTO bsp_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Sariyɛ nsɛ səcəmɛ kəloŋnɛ ka kəpaŋnɛ pəforu darəŋ, nkɛ aŋkenɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kɔ fum ɛndekenɛ kəloŋnɛ ka kəyif MARIKI barka teta pətɔt pɔn-ɛ, wəkayi pədeŋər poloŋnɛ pa cəcom cəlok-lok ncɛ anɔktərɛnɛ kɔ moro ma olif mɔ ta kəyɔ lebin, kɔ biskit bɔtɔnɔŋkəl lebin pasopət bi moro ma olif, kɔ cəcom cəlok-lok ncɛ alompsɛ kəmbefe kətɔt nkɛ anɔktərɛnɛ moro ma olif mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pəkekərɛ sɔ cəcom cəlok-lok ncɛ anɔŋkəl lebin mɔ, kədeŋər ka kəloŋnɛ ka kəyif MARIKI barka kɔ kəloŋnɛ ka kəpaŋnɛ pəforu kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Wəkayi pəbeli pəkenɛ MARIKI pipic dəyoloŋnɛ yɔn fəp, yɛlpəs yayɔkɔ ya wəloŋnɛ nwɛ ɛwɛsəsər mecir ma pɔcɔl poloŋnɛ pa kəpaŋnɛ pəforu dətetek mɔ, nkɔn ɔyɔ yi. ");
INSERT INTO bsp_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Sɛm ya pɔcɔl pa kəloŋnɛ ka kəyif MARIKI barka kɔ ka kəpaŋnɛ pəforu, dɔsɔk ndɛ aŋloŋnɛ pi mɔ, idɔ aŋsɔm yi ali pin afɔsak pedirɛ haŋ bətbət. ");
INSERT INTO bsp_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Kɔ wəkayi eŋkekərɛ kəloŋnɛ ka kədɛrəm, kɔ pəyɔnɛ fɛ ti, kəloŋnɛ ka kəpocɛ abəkəc ŋosoku pɛs-ɛ, dɔsɔk ndɛ endekekərɛ pɔcɔl papɔkɔ mɔ, idɔ aŋsɔm pi. K'asak pɛlpəs pedirɛ-ɛ, antam kəsɔm pi dɔckɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kɔ pəyɔnɛ a sɛm yɛntambər afum pasak yi yedirɛ sɔ-ɛ, dɔckɔsɔk da maas pacɔf yi. ");
INSERT INTO bsp_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nwɛ o nwɛ ɔsɔm sɛm ya kəloŋnɛ kəpaŋnɛ ka pəforu kaŋkɔ tataka ta maas, fum nwɛ eŋkenɛ MARIKI poloŋnɛ mɔ, MARIKI ɔfɔbaŋ pi, kəloŋnɛ kɔn kaŋkɔ kəyɔnɛ fɛ kɔ daka o daka, sɛm yayɔkɔ yɔyɔnɛ kɔ oŋ yɔtɔsɔk. Nwɛ o nwɛ ɔŋsɔm yi mɔ, ɛsarɛ kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kɔ paka pɔtɔsɔk poŋgbuŋɛnɛ sɛm yayɔkɔ-ɛ, ta pasɔm yi, pagbal yi dənɛnc. Mɛnɛ fum pəsɔk a pəctam kəsɔm sɛm ya kəloŋnɛ kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mba fum nwɛ o nwɛ ɔsɔm sɛm ya kəloŋnɛ ka kəpaŋnɛ pəforu nkɛ kəyɔnɛ ka MARIKI ta ɔsɔk-ɛ, aŋwurɛ wəkayi aYisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Fum nwɛ o nwɛ ogbuŋɛnɛ paka pɔtɔsɔk, pəmɔ fum wətɔsɔk, sɛm yɔtɔsɔk, yeliŋɛ-liŋɛ yɔtɔsɔk, paka pɔtɔsɔk mpɛ o mpɛ, a wəkayi pəsɔm sɛm ya kəloŋnɛ ka kəpaŋnɛ pəforu nkɛ kəyɔnɛ ka MARIKI mɔ, aŋwurɛ wəkayi aYisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Məloku aka Yisrayel: Ta ŋadi moro ma wana, ma aŋkesiya kɔ ma wir. ");
INSERT INTO bsp_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Moro ma wɛsɛm nwɛ antɔfay kɔ pəyɔnɛ fɛ ti wɛsɛm nwɛ sɛm yendif mɔ, nəntam mi kəyɔnɛ mes fəp, mba ta nədi mi. ");
INSERT INTO bsp_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Fum nwɛ o nwɛ edi moro ma pɔcɔl poloŋnɛ mpɛ aŋkekərɛ pacɔfɛ MARIKI mɔ, aŋwurɛ kɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ta nəmun mecir, mɔyɔnɛ ma abɛmp, ma pɔcɔl kəfo nkɛ o nkɛ nəŋyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Fum nwɛ o nwɛ omun mecir mɔyɔnɛ mmɛ o mmɛ mɔ, aŋwurɛ wəkayi aka Yisrayel dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kɔ MARIKI osom sɔ Musa: ");
INSERT INTO bsp_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Məloku aka Yisrayel: Məna nwɛ məndekenɛ MARIKI poloŋnɛ teta kəpaŋnɛ ka pəforu mɔ, məkenɛ kɔ fəkəl yɔn nyɛ wəkayi embelər poloŋnɛ pɔn pa kəpaŋnɛ pəforu dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Fum nwɛ eŋkenɛ MARIKI poloŋnɛ mɔ, pəkekərɛ moro ma pɔcɔl poloŋnɛ mpɛ ancɔfɛ MARIKI mɔ, pəkekərɛ mi kɔ kəmpəcpəc nkɛ antubucnɛ kəsɔŋ MARIKI fɔr kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Wəloŋnɛ pəcɔfɛ MARIKI moro mamɔkɔ nde tetek toloŋnɛ kəroŋ, mba kəmpəcpəc kəyɔnɛ ka Aruna k'awut ɔn arkun. ");
INSERT INTO bsp_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Dəyoloŋnɛ ya kəpaŋnɛ pəforu nəmbelɛ wəloŋnɛ aləŋk ŋa kəca kətɔt. ");
INSERT INTO bsp_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Awut arkun a Aruna dacɔ, nwɛ eŋkekərɛ mecir kɔ moro ma pɔcɔl poloŋnɛ pa kəpaŋnɛ pəforu mɔ, nkɔn ɔŋsɔtɔ aləŋk ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Iŋlɛk dəyoloŋnɛ ya kəpaŋnɛ pəforu nyɛ aka Yisrayel ŋaŋkɛrɛ ina MARIKI mɔ: Kəmpəcpəc nkɛ antubucnɛ kəsɔŋ em mɔ, k'aləŋk nŋɛ aŋwurɛ mɔ, isɔŋ yi Aruna wəloŋnɛ kɔ yuruya yɔn. Sɛm yayɔkɔ yende yɔcyɔnɛ yaŋan, sariyɛ sa doru o doru sɔ tendeyɔnɛ nnɔ aka Yisrayel ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Fəkəl yayɔkɔ yɔ ambelɛ Aruna kɔ yuruya yɔn dəyoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, kəyɛfɛ dɔsɔk ndɛ andəs ŋa dekiriŋ kəyɔnɛ aloŋnɛ a MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Tatɔkɔ tɔ MARIKI osom aka Yisrayel kəde kəcsɔŋ aloŋnɛ fəkəl yayɔkɔ dɔsɔk ndɛ ambɔy ŋa mɔ, sariyɛ sa doru o doru sɔ tendeyɔnɛ ŋa dɛtɛmp o dɛtɛmp daŋan. ");
INSERT INTO bsp_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Sariyɛ sa yoloŋnɛ sɔ saŋsɛ: Sariyɛ sa yɔcɔl yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, sa kəloŋnɛ ka mɛŋgbɛn, sa kəloŋnɛ ka kiciya, sa kəloŋnɛ ka kəlompəs ka kiciya, sa kəloŋnɛ ka kədəs ka dekiriŋ da aloŋnɛ kɔ sa kəloŋnɛ ka kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Tatɔkɔ tɔ MARIKI ɛnasom Musa dəndo dətɛgbərɛ nde tɔrɔ ta Sinayi, dɔsɔk ndɛ ɛnaloku aka Yisrayel kəkɛrɛ MARIKI yoloŋnɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Məlɛk Aruna k'awut ɔn arkun, yamos ya aloŋnɛ, moro mɔbɔy mopusɛ, tura ta kəloŋnɛ ka kiciya, ŋkesiya yorkun nyɛ mɛrəŋ kɔ kəfala ka cəcom cətɔnɔŋkəl lebin. ");
INSERT INTO bsp_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Məloŋka aka kəloŋkanɛ ka Yisrayel fəp nde dəkəbɛrɛ d'aŋgbancan ŋɛbəpɛnɛ kɔ Kanu.» ");
INSERT INTO bsp_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Kɔ Musa ɔyɔ tɔkɔ MARIKI ɛnasom kɔ mɔ, kɔ aka Yisrayel ŋaloŋkanɛ nde dəkəbɛrɛ d'aŋgbancan. ");
INSERT INTO bsp_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Kɔ Musa oloku kəloŋkanɛ ka aka Yisrayel: «Ntɛ tɔ MARIKI osom aka Yisrayel kəyɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Kɔ Musa ɔncɔŋ Aruna kɔ awut ɔn arkun, k'embikɛnɛnɛ ŋa domun. ");
INSERT INTO bsp_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","K'ɛmbɛr Aruna duma dedisrɛ k'ɛŋgbənc kɔ tabataba, k'endeŋər kɔ burumus kɔ duma da efɔd ndɛ ɛnagbəncɛ tabataba pa duma da efɔd ndɛ ɛnakot kɔ tadarəŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Kɔ Musa ɛŋgbɛk kɔ yuba yɛgbɛknɛ nyɛ ɛnabɛr masar mɛrəŋ disrɛ mɔ: Tasar ta Yurim kɔ ta Tumim. ");
INSERT INTO bsp_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","K'ɛncəp kɔ kəfakəl, k'ɛndɛtər ki tekiriŋ abɔpər ŋa kɛma, tɛgbɛkərɛ ta dəKanu, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kɔ Musa ɛlɛk moro mɔbɔy mopusɛ, k'ɔmbɔy dəkiyi dosoku kɔ ca cəkɔ yɛnayi di mɔ, k'ompus yi fəp. ");
INSERT INTO bsp_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","K'ɛwɛsəsər moro tetek toloŋnɛ Kanu haŋ camət-mɛrəŋ teta kəpus ka pi, k'ɔmbɔy tetek toloŋnɛ Kanu kɔ yosumpər-sumpər ya di fəp, kəsamp kɔ pɛcəmɛnɛ pa ki ntɛ tɔŋsɔŋɛ pəpus yi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","K'oloŋər domp da Aruna moro mamɔkɔ, k'ɔmbɔy Aruna sɔ ntɛ tɔŋsɔŋɛ pəpus kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kɔ Musa ɔncɔŋɛnɛ awut arkun a Aruna, k'ɛmbɛr ŋa suma sədisrɛ. K'ɛŋgbəncəs ŋa mabamaba, k'ɛncəpəs ŋa cəfakəl pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Kɔ Musa ɔlɔtərnɛnɛ tura toloŋnɛ ta kiciya. Aruna kɔ awut ɔn arkun ŋandeŋər pi waca dəromp. ");
INSERT INTO bsp_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Kɔ Musa ɛfay pi, k'asu tɔbɔl kɔ mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. Kɔ Musa ɛlɛkɛ mecir tɛlər tɔn k'osopət mi lɛn maŋkəlɛ ya moŋkubut ma tetek toloŋnɛ Kanu teta kəpusɛ ka pi MARIKI. Tatɔkɔ t'ɛnasɔkəs tetek toloŋnɛ Kanu. K'oloŋər mecir mɛlpəs mɔkɔ pɛcəmɛnɛ pa tetek toloŋnɛ, k'ompus pi ntɛ tɔŋsɔŋɛ pactam kəsɔkəs ka pi kətɔsɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Kɔ Musa ɛlɛk moro mɔkɔ mɛnakump yedisrɛ mɔ fəp, pəwotwotər pa mim kɔ fi nyɛ mɛrəŋ kɔ moro ma yi, k'ɔncɔfɛ yi MARIKI tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mba kɔ Musa ɔŋkɔ pəcɔf nde saŋka todoru yɛlpəs ya tura: Akata, sɛm kɔ yedisrɛ ya aputuk pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kɔ Musa ɛŋkɛrɛ aŋkesiya ŋorkun ŋa poloŋnɛ pɔcɔf. Aruna kɔ awut ɔn arkun ŋandeŋər ŋi waca dəromp. ");
INSERT INTO bsp_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Kɔ Musa ɛfay ŋi, k'asu tɔbɔl, kɔ mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. Kɔ Musa ɛwɛsəsər mi tetek toloŋnɛ Kanu cəsək haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Kɔ Musa ɛncɛnəs aŋkesiya ŋorkun ŋaŋɔkɔ fəkəl fəkəl. K'ɔncɔfɛ yi MARIKI kəyɛfɛ domp, fəkəl, kɔ moro ma aŋkesiya ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","K'ɛyakɛ yedisrɛ kɔ wɛcək domun, a k'endecɔf yi fəp nde tetek toloŋnɛ Kanu kəroŋ. Aŋkesiya ŋorkun ŋaŋɔkɔ fəp ŋɔ Musa ɛnacɔfɛ MARIKI. Poloŋnɛ papɔkɔ p'ancɔfɛ MARIKI, ambɔnc ŋa pi ŋontorɛ-torɛ MARIKI abəkəc. Musa ɛnayɔ pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kɔ Musa ɛŋkɛrɛ aŋkesiya ŋa mɛrəŋ nŋɛ ŋɔyɔnɛ ŋa kədəs ka dekiriŋ da kəloŋnɛ mɔ. Aruna kɔ awut ɔn arkun ŋandeŋər aŋkesiya ŋaŋɔkɔ waca dəromp. ");
INSERT INTO bsp_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Kɔ Musa ɛfay ŋi, k'asu tɔbɔl, kɔ mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. Kɔ Musa ɛlɛk mecir, k'osop mi aləŋəs ŋa kəca kətɔt ka Aruna kɔ tɛlər tɔn tɔpɔŋ ta kəca kətɔt kɔ tɛlər tɔn tɔpɔŋ pa kəcək kɔn kətɔt. ");
INSERT INTO bsp_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Kɔ Musa ɔncɔŋɛnɛ awut arkun a Aruna, k'osop ŋa mecir mamɔkɔ nde ləŋəs yaŋan ya kəca kətɔt, mɛlər maŋan mɔpɔŋ ma waca waŋan wɔtɔt kɔ mɛlər maŋan mɔpɔŋ ma wɛcək waŋan wɔtɔt, kɔ Musa ɛwɛsəsər mecir mɛlpəs mɔkɔ tetek toloŋnɛ Kanu cəsək haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Kɔ Musa ɛlɛk kəleŋa kɔ moro mɔkɔ mɛnakump yedisrɛ ya aŋkesiya nyɛ mɔ, kɔ pəwotwotər pa mim kɔ fi mɛrəŋ kɔ moro ma yi kɔ aləŋk ŋa kəcək kətɔt. ");
INSERT INTO bsp_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Kɔ Musa ɛlɛk kəfala ka cəcom cətɔnɔŋkəl lebin nkɛ anacəmbər MARIKI fɔr kiriŋ mɔ, k'ɛlɛk kəcom kəlok-lok kin, kəcom kəlok-lok kin nkɛ anɔktərɛnɛ moro ma olif mɔ, kɔ biskit, k'endeŋər yi moro ma pɔcɔl poloŋnɛ kɔ aləŋk ŋa kəca kətɔt kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Kɔ Musa ɛlɛk yi fəp k'ɛmbɛr Aruna dəwaca kɔ awut ɔn, k'ontubucnɛ kəsɔŋ yi MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kɔ Musa ɛmbaŋər ŋa yi dəwaca, k'endeŋ yi pɔcɔl pɔcɔf kəroŋ, k'ɔncɔfɛ yi fəp MARIKI dətetek toloŋnɛ kəroŋ. Kɔ tɔyɔnɛ kəloŋnɛ ka kədəs ka aloŋnɛ dekiriŋ da yɛbəc ya dəKanu. Kəloŋnɛ kɔ, nkɛ ancɔfɛ MARIKI mɔ, nkɛ ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Kɔ Musa ɛlɛk kəmpəcpəc ka aŋkesiya ŋoloŋnɛnɛ ŋa kədəs dekiriŋ da kəloŋnɛ, k'ontubucnɛ kəsɔŋ ŋi MARIKI fɔr kiriŋ, ŋaŋɔkɔ ŋɛnayɔnɛ ŋa Musa, pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kɔ Musa ɛlɛk moro mɔbɔy mopusɛ kɔ mecir mɔkɔ mɛnayi nde dətetek toloŋnɛ Kanu kəroŋ mɔ, k'ɛwɛsəsər mi Aruna kɔ yamos yɔn, awut ɔn kɔ yamos yaŋan. K'ompus Aruna kɔ yamos yɔn, awut a Aruna arkun kɔ yamos yaŋan. ");
INSERT INTO bsp_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kɔ Musa oloku Aruna kɔ awut ɔn arkun: «Nəpɛc sɛm nyɛ nde kusuŋka ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, difɔ nəŋkɔsɔm yi kɔ cəcom ncɛ cəyi nnɔ kəfala ka kədəs ka dekiriŋ mɔ, pəmɔ tɔkɔ inaluksɛ nu kəsom ka Kanu mɔ: Aruna kɔ awut ɔn ŋaŋsɔm yi. ");
INSERT INTO bsp_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kɔ yɔntɔlip-ɛ, nəcɔf yɛlpəs ya sɛm kɔ cəcom cacɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Mata camət-mɛrəŋ nəfɔyɛfɛ dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu haŋ mataka ma kədəs konu dekiriŋ mecepər, bawo mata camət-mɛrəŋ m'andəs nu dekiriŋ da kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Tantɛ teyi mɔkɔ mɔ, tɔ MARIKI nkɔn wəsərka osom a payɔ, ntɛ tɔŋsɔŋɛ kəsɔkəs nu kiciya konu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mata camət-mɛrəŋ mɔ nəndeyi dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, pibi kɔ daŋ kɔ tencepər-ɛ nəmɛŋkərnɛ sariyɛ sa MARIKI saŋsɛ ntɛ tɔŋsɔŋɛ ta nəfi mɔ: Tantɛ t'anasom im.» ");
INSERT INTO bsp_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aruna kɔ awut ɔn arkun ŋayɔ mɔyɔ fəp mmɛ MARIKI ɛnasom Musa nnɔ ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Tataka ta camət-maas kɔ Musa ewe Aruna kɔ awut ɔn arkun, kəlɛkɛnɛ ka abeki aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Kɔ Musa oloku Aruna: «Məlɛk tura tɛfɛt ta kəloŋnɛ ka kiciya kɔ aŋkesiya ŋorkun ŋa teren tin teta poloŋnɛ mpɛ ancɔfɛ MARIKI mɔ, mɛrəŋ ma yi fəp ta yɔyɔ dolokəp, məmentər yi MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Məloku aka Yisrayel ntɛ: Nəlɛk ambiyofo teta kəloŋnɛ ka kiciya, tura ta teren tin kɔ aŋkesiya ŋorkun ŋa teren tin ta yɔyɔ dolokəp, nəcɔfɛ yi MARIKI, ");
INSERT INTO bsp_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","tura tin kɔ aŋkesiya ŋorkun ŋin ŋa kəloŋnɛ ka kəpaŋnɛ pəforu ntɛ tɔŋsɔŋɛ paloŋnɛ yi MARIKI fɔr kiriŋ mɔ, kɔ kəloŋnɛ ka mɛŋgbɛn nkɛ anɔktərɛnɛ kɔ moro ma olif mɔ, bawo MARIKI endewurər nu mɔkɔ!» ");
INSERT INTO bsp_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","K'aŋkekərɛ ca yɔkɔ Musa ɛnasom kəkekərɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. Kɔ kəloŋkanɛ ka aka Yisrayel fəp ŋabəpɛnɛ kɔ ŋancəmɛ MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kɔ Musa oloku: «Ntɛ tɔ MARIKI osom, nəyɔ ti ntɛ tɔŋsɔŋɛ nɔrɔ da delel da MARIKI dowurər nu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kɔ Musa oloku Aruna: «Məlɔtərnɛ tetek toloŋnɛ Kanu. Məloŋnɛ kəloŋnɛ ka kiciya kam kɔ pɔcɔl poloŋnɛ pɔcɔf pam, mətubucnɛ kəsɔkəsnɛ kiciya kam kɔ ka afum. Məsɔŋ sɔ yoloŋnɛ ya afum, mətubucnɛ sɔ kəsɔkəs ŋa kiciya kəŋan pəmɔ tɔkɔ MARIKI osom ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kɔ Aruna ɔlɔtərnɛ tetek toloŋnɛ Kanu k'ɛfay tura tɛfɛt teta kiciya ka nkɔnsərka. K'asu tɔbɔl, kɔ mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Kɔ awut arkun a Aruna ŋaŋkenɛ kɔ mi. K'Aruna ɛŋgbət mi tɛlər tɔn k'osopət lɛn maŋkəlɛ ya moŋkubut ma tetek toloŋnɛ, k'oloŋər mɛlpəs pɛcəmɛnɛ pa pi. ");
INSERT INTO bsp_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","K'ɔncɔfɛ MARIKI dətetek toloŋnɛ kəroŋ moro ma pɔcɔl, fi mɛrəŋ kɔ pəwot-wotər pa mim ma kəloŋnɛ ka kiciya, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mba k'aŋkɔ pacɔf saŋka tadarəŋ sɛm kɔ akata. ");
INSERT INTO bsp_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","K'Aruna ɛfay pɔcɔl mpɛ ancɔfɛ MARIKI mɔ, k'asu tɔbɔl, kɔ mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. Kɔ awut ɔn ŋasɔŋ kɔ mecir mamɔkɔ, k'ɛwɛsəsər mi cəsək ca tetek toloŋnɛ haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Kɔ ŋasɔŋ kɔ fəkəl kɔ domp da poloŋnɛ pɔcɔf, k'ɔncɔfɛ yi MARIKI tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","K'ɛyak yedisrɛ ya pɔcɔl papɔkɔ kɔ wɛcək, k'ɔncɔfɛ yi MARIKI nde dətetek toloŋnɛ kəroŋ kɔ poloŋnɛ pɔcɔf. ");
INSERT INTO bsp_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Kɔ Aruna oloŋnɛ yoloŋnɛ ya aka Yisrayel. K'ɛlɛk ambiyofo nŋɛ aka Yisrayel ŋanakɛrɛ kədeloŋnɛ teta kiciya mɔ, k'ɛfay ŋi, k'oloŋnɛ ŋi teta kiciya pəmɔ tɔkɔ ɛnaloŋnɛ tura mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","K'eŋkenɛ MARIKI yoloŋnɛ yɔcɔf nyɛ mɛrəŋ pəmɔ tɔkɔ sariyɛ səloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","K'eŋkekərɛ yoloŋnɛ ya mɛŋgbɛn nyɛ ɛnalas dəkəca mɔ, k'ɔncɔfɛ yi MARIKI nde dətetek toloŋnɛ kəroŋ, kəlɛkɛnɛ ka poloŋnɛ pɔcɔf pɛbətbət. ");
INSERT INTO bsp_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","K'ɛfay tura kɔ aŋkesiya ŋorkun teta kəloŋnɛ ka kəpaŋnɛ pəforu ka afum. K'asu tɔbɔl, kɔ mecir mamɔkɔ mɛmbɛrɛ pi disrɛ. Kɔ awut arkun a Aruna ŋasɔŋ kɔ mecir mamɔkɔ, k'ɛwɛsəsər mi cəsək ca tetek toloŋnɛ haŋ k'ɔnɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Kɔ ŋasɔŋ kɔ moro ma tura kɔ aŋkesiya, kəleŋa kɔ moro moŋkump fi kɔ pəwot-wotər pa mim. ");
INSERT INTO bsp_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","K'endeŋ moro dəkəmpəcpəc, k'ɔncɔfɛ MARIKI moro dətetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Kɔ Aruna ontubucnɛ kəsɔŋ kəmpəcpəc kɔ aləŋk ŋa kəca kətɔt MARIKI fɔr kiriŋ, pəmɔ tɔkɔ Musa ɛnasom ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kɔ Aruna eyekti waca darenc nnɔ aka Yisrayel ŋayi mɔ, k'ontolanɛ ŋa pətɔt. Ntɛ elip kəloŋnɛ ka kiciya, kəloŋnɛ ka poloŋnɛ pɔcɔf kɔ kəloŋnɛ ka kəpaŋnɛ pəforu mɔ, k'ontor tetek toloŋnɛ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa kɔ Aruna ŋambɛrɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ. Ntɛ ŋandewur mɔ, kɔ ŋantolanɛ aka Yisrayel pətɔt. Kɔ nɔrɔ da debeki da MARIKI dowurər aka Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Kɔ nɛnc dowur MARIKI fɔr kiriŋ kɔ dɔncɔf pɔcɔl poloŋnɛ pɔcɔf kɔ moro ma pi dətetek toloŋnɛ kəroŋ. Kɔ aka Yisrayel fəp ŋanəŋk ti. Kɔ ŋaŋkul-kulɛnɛ pəbotu, kɔ ŋancəp mobu dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Kɔ awut arkun mɛrəŋ a Aruna, Nadab kɔ Abihu nwɛ o nwɛ k'ɛlɛk tap k'ɛmbɛr pi nɛnc disrɛ k'ɔncɔlər suray. Kɔ ŋaŋkenɛ MARIKI nɛnc ndɛ dɛnatɔtesɛ ndɛ ɛnatɔsom ŋa kəkɛrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kɔ nɛnc dowur MARIKI tekiriŋ, kɔ dɔncɔf ŋa, kɔ ŋafi mɛrəŋ maŋan MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kɔ Musa oloku Aruna: «Ntɛ tɔ MARIKI ɛnasom: ‹Ifaŋ aŋɛ ŋaŋlɔtərn'em mɔ, ŋacərɛ a in'ɔyɔnɛ Kanu ka kance, ŋade ŋacleləs dosoku dem. Ŋacyek-yekəs nɔrɔ da debeki dem aka Yisrayel fəp fɔr kiriŋ.›» Kɔ Aruna ɛncaŋk pem. ");
INSERT INTO bsp_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Kɔ Musa ewe Misayɛl kɔ Elcafaŋ awut a Usiyɛl papa ka Aruna wəfɛt, k'oloku ŋa: «Nəcɔŋnɛ nəde nəlɛk awɛnc nu aŋa, nəwurɛnɛ ŋa daŋgbancan ŋosoku, nəbɔlɛnɛ ŋa saŋka.» ");
INSERT INTO bsp_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","K'akakɔ ŋancɔŋnɛ kɔ ŋalɛk cəbel cəŋan ŋasɔrɔbɛrnɛ suma sədisrɛ səŋan kɔ ŋawurɛnɛ ŋa dəsaŋka, pəmɔ tɔkɔ Musa ɛnaloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kɔ Musa oloku Aruna, Elasar kɔ Itamar, awut a Aruna: «Ta nəsakti cəfon conu. Ta nəwal-wali yamos yonu, tɔŋsɔŋɛ nu kətɔfi, tɔŋsɔŋɛ kətɔkɛrɛ kəloŋkanɛ ka aka Yisrayel mɛtɛlɛ. Awɛnc nu aŋa, aka Yisrayel fəp ŋabok teta afum aŋɛ nɛnc da MARIKI dendif mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ta nəyɛfɛ dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ta tedesɔŋ'on kəfi, bawo moro mɔbɔy teta kəpus ma MARIKI meyi nu dəris.» Kɔ ŋayɔ tɔkɔ Musa ɛnaloku ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kɔ MARIKI oloku Aruna: ");
INSERT INTO bsp_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Məna kɔ awut am: Kɔ nəndekɔ nəcbɛrɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu-ɛ, ta nəmun wɛn, ta nəmun sɔ maŋkɔntɔ mmɛ o mmɛ, tɔŋsɔŋɛ nu kətɔfi. Tende tɔyɔnɛ nu sariyɛ sa doru o doru, dɛtɛmp o dɛtɛmp donu. ");
INSERT INTO bsp_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ti tendesɔŋ'on nəctam kəgbɛy paka popus kɔ pɔtɔpus, paka posoku kɔ pɔtɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Nəctam sɔ kətəksɛ aka Yisrayel sariyɛ nsɛ MARIKI ɛnasom Musa kədeloku ŋa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Kɔ Musa oloku Aruna, kɔ awut ɔn aŋɛ ŋanacəmɛ kɔ mɔ, Elasar kɔ Itamar: «Nəlɛk yoloŋnɛ ya mɛŋgbɛn yɛlpəs ya yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, nədi yi tetek toloŋnɛ kəsək. Ta nənɔŋkəl yi lebin de, yeri yosoku yɔ nyɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Nədi yi kəfo kəsoku: Itɔ sariyɛ səloku nu məna kɔ awut am arkun teta yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, itɔ anasom im. ");
INSERT INTO bsp_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nəsɔm sɔ yi kəfo kəsoku, məna kɔ awut am kəyɛfɛ kəmpəcpəc nkɛ anatubucnɛ kəsɔŋ MARIKI kɔ aləŋk ŋɔkɔ anabelər mɔ. Asɔŋ nu yi, kɔ sariyɛ səloku a mən'ɔyɔ yi k'awut am, nnɔ yoloŋnɛ ya kəpaŋnɛ pəforu ya aka Yisrayel yeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Aka Yisrayel ŋade ŋackɛrɛ moro ma yɔcɔl yoloŋnɛ nyɛ ande paccɔfɛ MARIKI mɔ, ŋabelər aləŋk kɔ kəmpəcpəc ŋatubucnɛ kəsɔŋ yi MARIKI fɔr kiriŋ. K'alip ti-ɛ, aləŋk kɔ kəmpəcpəc yɔyɔnɛ yonu, bawo sariyɛ sa MARIKI sɔ, sɛm yonu yɔ yayɔkɔ doru o doru, pəmɔ tɔkɔ MARIKI osom ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kɔ Musa ɛntɛn ambiyofo ŋoloŋnɛnɛ kiciya belbel, mba k'ɔnkɔ pəbəp pacɔf ŋi. Kɔ pəntɛlɛ Musa nnɔ Elasar kɔ Itamar ŋayi mɔ, awut arkun a Aruna aŋɛ ŋanacəmɛ kɔ mɔ, kɔ Musa eyif ŋa: ");
INSERT INTO bsp_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Ta ake tɔ nəntɔsɔmɛ ambiyofo ŋoloŋnɛnɛ kiciya nde kəfo kəsoku-ɛ? Yeri yosoku yɔ nyɛ ampusɛ MARIKI mɔ, ɔsɔŋ nu yi ntɛ tɔŋsɔŋɛ nəcsarɛ kiciya ka kəloŋkanɛ ka aka Yisrayel, nəctubucnɛ kəsɔkəs ŋa kiciya kəŋan mɔ, itɔ MARIKI ɔsɔŋɛ nu ŋi. ");
INSERT INTO bsp_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Anakekərɛ fɛ mecir mamɔkɔ nde aŋgbip ŋosoku disrɛ. Pənamar nəsɔm ambiyofo ŋaŋɔkɔ nde kəfo kəpus mɔ, pəmɔ tɔkɔ inasom nu ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Kɔ Aruna oloku Musa: «Dɔsɔk dandɛ dɔ awut em ŋanakekərɛ kəloŋnɛ ka kiciya kəŋan kɔ ka poloŋnɛ pɔcɔfɛ MARIKI fɔr kiriŋ. Məncərɛ belbel tɔkɔ tɛnasɔt'em mɔ: K'isɔm dɔsɔk dɔmɔkɔ poloŋnɛ pa kiciya-ɛ, tɔmbɔt MARIKI ba?» ");
INSERT INTO bsp_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Kɔ Musa ene ti, kɔ tɔmbɔt kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Kɔ MARIKI osom Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Nəloku aka Yisrayel: Sɛm nyɛ yeyi dəntɔf mɔ fəp, nyɛ y'awosɛ nu kəde kəcsɔm: ");
INSERT INTO bsp_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Nəndetam kəcsɔm sɛm fəp nyɛ yɛŋgbɛyɛnɛ mɛlər mɔ, yɛcnakəmnɛ kɔ yɔntɔyi kəsɔmət-ɛ, pəmɔ wana. ");
INSERT INTO bsp_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Mba ta nəde nəcsɔm sɛm nyɛ yɛŋnakəmnɛ gbəcərəm ta yɛŋgbɛyɛnɛ mɛlər mɔ. Ta nəde nəcsɔm sɔ sɛm nyɛ yɛŋgbɛyɛnɛ mɛlər mɛrəŋ gbəcərəm ta yɛnakəmnɛ mɔ, pəmɔ sɛm nyɛ: Yɔkɔmɛ yɛŋnakəmnɛ, mba yɛŋgbɛyɛnɛ fɛ mɛlər, yɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Debem da dəmasar sɔ dɛŋnakəmnɛ, mba dɛŋgbɛyɛnɛ fɛ mɛlər, dɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Tɔrɔp tɛŋnakəmnɛ, mba pɛŋgbɛyɛnɛ fɛ mɛlər, pɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Asɔp ŋɛŋgbɛyɛnɛ mɛlər, mba ŋɔfɔnakəmnɛ yeri pəmɔ wana, ŋɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ta nəsɔm sɛm ya asɔp, ta nəgbuŋɛnɛ ŋefi ŋa yi. Ŋɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ntɛ tɔyɔnɛ sɛm nyɛ yeyi dəromun mɔ, nyɛ yɔ awosɛ nu kəde kəcsɔm: Sɛm nyɛ yɔyɔ yɛŋɛrnɛnɛ kɔ wokwok mɔ fəp, kɔ yeyi dəromun mɔ, tɔyɔnɛ dəcəba tɔyɔnɛ dəcəŋgbɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mba sɛm yɛfɛt yɛfɛt kɔ yɔpɔŋ nyɛ yeyi dəromun mɔ fəp, tɔyɔnɛ dəcəba tɔyɔnɛ dəcəŋgbɔkɔ, yeliŋɛ-liŋɛ nyɛ yɔntɔyɔ wokwok kɔ yɛŋɛrnɛnɛ mɔ, nəter yɔtɔsɔk yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nəter sɛm yayɔkɔ, ta nəsɔm yi. Nəkɛmbərnɛ kəcgbuŋɛnɛ yi, nəlɔm pefi pa yi pəmɔ pəyikyik mpɛ nənter mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nəter sɛm ya dəromun fəp nyɛ yɔntɔyɔ yɛŋɛrnɛnɛ kɔ wokwok mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Kɔ bɛmp nyɛ yɔ nəndeter, ta nəde nəcsɔm yi, yɔsɔk fɛ nnɔ nəyi mɔ: Asiksik, ayɔfən, asiksik ŋa dəkəba, ");
INSERT INTO bsp_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","aŋkəlokəlo, təŋgbɛ kɔ dokomɛnɛ da yi, ");
INSERT INTO bsp_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","bɛmp yaser kɔ dokomɛnɛ da yi fəp, ");
INSERT INTO bsp_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","otəris, awump ŋa dare, acəmɛcəmɛ, abəkar kɔ dokomɛnɛ da yi, ");
INSERT INTO bsp_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","awump ŋa dop kɔ dokomɛnɛ da ŋi, aŋgbeŋgbəlec, ");
INSERT INTO bsp_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","antombon, ayɔfən, ");
INSERT INTO bsp_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","kətɛp kɔ dokomɛnɛ da yi, kɔ tempirfin. ");
INSERT INTO bsp_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Nəter yeyi wəyeŋ yɛfɛt yɛfɛt nyɛ yɔyɔ banca yɛcfɛlər kɔ yɔckɔt wɛcək wa yi maŋkəlɛ kəroŋ mɔ, yɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mba yoyokɛ-yokɛ yɛfɛt yɛfɛt dacɔ nyɛ yɔyɔ banca yɛcfɛlər mba yɔckɔtɛnɛ sɔ wɛcək maŋkəlɛ mɔ, nəntam kəsɔm nyɛ yɔyɔ wɛcək mɛrəŋ nwɛ wɛntam kəsɔŋɛ yi kəyokɛ dəntɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Yoyokɛ-yokɛ nyɛ yɛŋfɛlər mɔ, nyɛ yɔ nənde nəctam kəcsɔm: Dokomɛnɛ da cəlaŋkəma kɔ cəcal. ");
INSERT INTO bsp_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mba yeŋesəm yɛfɛt yɛfɛt yɔlɔma nyɛ yɔyɔ banca yɛcfɛlər, yɔckɔt sɔ wɛcək maŋkəlɛ wa yi kəroŋ mɔ fəp, yɔsɔk fɛ nnɔ nəyi mɔ, nəde nəter yi. ");
INSERT INTO bsp_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Sɛm nyɛ yɔŋsɔŋɛ nu kətɔsɔk: Nwɛ o nwɛ ogbuŋɛnɛ wefi wa yi, wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Nwɛ o nwɛ ɔntɔmpər wɛsɛm wefi wawɔkɔ mɔ, pəmar pəyak yamos yɔn, wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Wɛsɛm nwɛ o nwɛ wɔntɔgbɛyɛnɛ mɛlər belbel kɔ pəyɔnɛ fɛ ti ta wɛŋnakəmnɛ kɔ wendeŋesəm pəmɔ wana-ɛ, wɔsɔk fɛ nnɔ nəyi mɔ. Nwɛ o nwɛ oŋgbuŋɛnɛ wi mɔ, ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Wɛsɛm nwɛ o nwɛ wɔyɔ wɛcək maŋkəlɛ nwɛ wɔyɔ sɛnc mɔ, wɔsɔk fɛ nnɔ nəyi mɔ. Nwɛ o nwɛ oŋgbuŋɛnɛ wefi wa yi, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Nwɛ o nwɛ ɔtɔmpər wefi wa yi, pəyak yamos yɔn, ɔsɔk fɛ haŋ dec dɛkalɛ. Yɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Sɛm yeliŋɛ-liŋɛ nyɛ yɛŋsɛp dəntɔf mɔ, nyɛ yɔntɔsɔk nnɔ nəyi mɔ: Agbɛlkɛc, wer, asel kɔ dokomɛnɛ da yi, ");
INSERT INTO bsp_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","sokedɔŋkɛ, acakar, kəmbəmbərət, tɛgbəcmɔtɛ, kɔ akəlencen. ");
INSERT INTO bsp_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sɛm yɛfɛt yeliŋɛ-liŋɛ yɛsɛp dacɔ, nyɛ yɔtɔsɔk nnɔ nəyi mɔ. Nwɛ o nwɛ ogbuŋɛnɛ pefi pa yi, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Paka mpɛ o mpɛ pɔ peliŋɛ-liŋɛ papɔkɔ pin pefi payi pɛntɛmpɛnɛ kəroŋ, pɔsɔk fɛ: Tɔyɔnɛ apɛpɛ, yamos, akata, alɔba, paka mpɛ o mpɛ andegbuŋsərɛnɛ mɔ. Payaksɛ paka papɔkɔ domun, mba pɔsɔk fɛ haŋ dec dɛkalɛ. Kɔ dɔfɔy dencepər-ɛ, pɔŋsɔk oŋ. ");
INSERT INTO bsp_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Pɛsɛl mpɛ o mpɛ pɔ yeliŋɛ-liŋɛ yayɔkɔ pin pefi payi pɛntɛmpɛnɛ disrɛ ca cəlɔma kəroŋ, pɔsɔk fɛ sɔ, nəwɔkəc pɛsɛl papɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Peri mpɛ o mpɛ pɔ aloŋər domun ndɛ dɛyɛfɛ pɛsɛl papɔkɔ disrɛ mɔ, pɔsɔk fɛ sɔ. Kɔ pəyɔnɛ pomun pɔ-ɛ, pɔsɔk fɛ, peyi oŋ pɛbɛrɛ mpɛ o mpɛ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Paka mpɛ o mpɛ pɔ pefi pa pin pa yeliŋɛ-liŋɛ yayɔkɔ pɛntɛmpɛnɛ kəroŋ, pɔsɔk fɛ. Kɔ tɔyɔnɛ pɛntɛmpɛnɛ pɔcɔfɛ cəcom disrɛ-ɛ, paləsər pi, pɔcɔfɛ kəcom papɔkɔ pɔsɔk fɛ oŋ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kɔ pefi pa yeliŋɛ-liŋɛ papɔkɔ pin pɛntɛmpɛnɛ dəkələmp kɔ pəyɔnɛ fɛ ti, dəkəŋgbɔkɔ-ɛ, domun dadɔkɔ dɔsɔk, mba fum wəkɔ ɔŋkɔwurɛ pi dənda dəromun mɔ, ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kɔ pefi payi pɛntɛmpɛnɛ mɛŋgbɛn mɔkɔ pəmar pakɔbɔf mɔ kəroŋ-ɛ, mɛŋgbɛn mamɔkɔ mɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mba kɔ pəyɔnɛ a ampuk mɛŋgbɛn mamɔkɔ teta kədi-ɛ, a pefi pa peliŋɛ-liŋɛ papɔkɔ pɛctɛmpɛnɛ mi kəroŋ-ɛ, mɛŋgbɛn mamɔkɔ mɔsɔk fɛ nnɔ nəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kɔ tɔyɔnɛ wɛsɛm nwɛ aŋwosɛ nu kəsɔm mɔ, wefi wisərka, nwɛ o nwɛ oŋgbuŋɛnɛ wi mɔ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Nwɛ o nwɛ ɔsɔm sɛm ya pefi papɔkɔ, pəyak yamos yɔn, ɔsɔk fɛ haŋ dec dɛkalɛ. Nwɛ o nwɛ ɔtɔmpər sɔ pefi papɔkɔ mɔ, pəyak yamos yɔn, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Nəter yeliŋɛ-liŋɛ yɛfɛt fəp nyɛ yɛŋsɛp dəntɔf mɔ, pəyikyik pɔ, ta nəsɔm yi. ");
INSERT INTO bsp_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Nəter yeliŋɛ-liŋɛ dəntɔf, kɔ nyɛ yeŋliŋɛ kor ka yi kəroŋ mɔ, kɔ nyɛ yɔŋkɔtɛ wɛcək maŋkəlɛ kɔ pəyɔnɛ fɛ ti wɛcək wecepər maŋkəlɛ mɔ, pəyikyik pɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ta nəsɔŋnɛ kətɔsɔk nkɛ anter mɔ teta yeliŋɛ-liŋɛ yɛfɛt nyɛ yɛŋsɛp mɔ. Ta nəwosɛ yogbuŋɛnɛ nu, yɔsɔŋɛ nu kətɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","MARIKI iyɔnɛ, Kanu konu. Nədeyɔnɛ afum acempi aŋɛ ampus'em mɔ, bawo ina MARIKI, incemp. Ta nəsɔŋnɛ kətɔsɔk teta yeliŋɛ-liŋɛ yɛfɛt nyɛ yɛŋsɛp dəntɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","MARIKI iyɔnɛ nwɛ ɛnapɛnɛ nu atɔf ŋa Misira, ideyɔnɛ Kanu konu mɔ. Nəyɔnɛ afum acempi aŋɛ ampus'em mɔ, bawo ina MARIKI, incemp. ");
INSERT INTO bsp_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Sariyɛ sasɔkɔ səcəmɛ sɛm darəŋ, bɛmp, yɛŋɛrəŋ ya dəromun fəp kɔ yeliŋɛ-liŋɛ ya dəntɔf fəp, ");
INSERT INTO bsp_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ntɛ tɔŋsɔŋɛ pagbɛy sɛm yosoku kɔ yɔtɔsɔk mɔ, sɛm nyɛ awosɛ kəsɔm kɔ nyɛ antɔwosɛ kəsɔm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Məloku aka Yisrayel: Kɔ wəran ɛmbɛkəs pəkom wan wərkun-ɛ, ɔsɔk fɛ haŋ mata camət-mɛrəŋ. Ɔsɔk fɛ pəmɔ tɔkɔ endenəŋk wəka darenc ŋof o ŋof mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Tataka ta camət-maas pakənc wan. ");
INSERT INTO bsp_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Wəran wəkakɔ pəyi sɔ mata wəco maas kɔ maas (33) kəsɔkəsnɛ mecir mɔn. Ta pəgbuŋɛnɛ paka mpɛ o mpɛ ampusɛ MARIKI mɔ, ta wəkayi sɔ pəkɔ nde aŋgbip ŋosoku, haŋ pəlip kəlas mataka mɔn ma kəsɔkəsnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kɔ wəran oŋkom wan wəran-ɛ, ɔsɔk fɛ haŋ mataka moluksər mɛrəŋ, pəmɔ tɔkɔ endenəŋk wəka darenc ŋof o ŋof mɔ. Pəsɔkəsnɛ mecir mɔn mata wəco camət-tin kɔ camət-tin (66). ");
INSERT INTO bsp_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Kɔ wəran elip mataka mɔn ma kəsɔkəsnɛ-ɛ, tɔyɔnɛ dokombəra da wan wərkun kɔ pəyɔnɛ fɛ ti wan wəran, pəkɛrɛ wəloŋnɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu tekiriŋ, aŋkesiya ŋorkun ŋa teren tin teta poloŋnɛ pɔcɔf, kɔ antantoriya kɔ pəyɔnɛ fɛ ti-ɛ, tɔpay teta kəloŋnɛ ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Wəloŋnɛ pəkɛrɛ yi MARIKI fɔr kiriŋ, pətubucnɛ sɔ kəsɔkəs kɔ kətɔsɔk kɔn. Kɔ telip-ɛ, wəran wəkakɔ ɔŋsɔk kəloŋ kɔn mecir dəŋkom. Sariyɛ sasɔkɔ səcəmɛ wəran darəŋ nwɛ oŋkom wan wərkun kɔ pəyɔnɛ fɛ ti, pəkom wan wəran mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kɔ wəran wəkakɔ ɔntɔyɔ daka ndɛ ɔŋkɔsɔtɔnɛ aŋkesiya ŋa teren tin mɔ, wəran wəkakɔ pəlɛk mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti-ɛ, ntantoriya yowut mɛrəŋ, pin pɔyɔnɛ poloŋnɛ pɔcɔf, pa mɛrəŋ pɔyɔnɛ poloŋnɛ pa kiciya. Wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kətɔsɔk kɔn, wəran wəkayi ɔsɔk oŋ.» ");
INSERT INTO bsp_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Kɔ fum ɔyɔ pəkəfər-kəfər dakata, amɔncɔ kɔ pəyɔnɛ fɛ ti, pətɛmsər petelər mpɛ pɛŋləpsər kəyɔnɛ kɔ docu da akata ndɛ dɛncalərnɛ mɔ, pakekərɛ wəkayi wəloŋnɛ Aruna kɔ pəyɔnɛ fɛ ti-ɛ, wan kɔn wəkin. ");
INSERT INTO bsp_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Wəloŋnɛ pəkɔkcɛ arunc nŋɛ ŋeyi kɔ dakata mɔ. Kɔ pəyɔnɛ cəfon cɔn ca dakata cəferɛ-ɛ, tɔyɔnɛ arunc ŋɔn ŋontukmɛ ŋɛtas akata ŋɔn-ɛ, arunc ŋa docu d’akata dɛcalərnɛ dɔ. Wəloŋnɛ pəkɔkcɛ kɔ, pəloku kɔ a ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kɔ pəyɔnɛ wəkayi ɔyɔ pətɛmsər petelər pefer mpɛ pɔntɔtukmɛ pɛtas akata ŋɔn mɔ, tɔyɔnɛ cəfon cɔn ca dakata cəntaferɛ fɛ-ɛ, wəloŋnɛ pəbɔlɛnɛ wəka arunc wəkakɔ afum mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Tataka ta camət-mɛrəŋ wəloŋnɛ pəgbɔkərɛ sɔ kəkɔkcɛ kɔ. Kɔ tɔyɔnɛ mata camət-mɛrəŋ mamɛ disrɛ, arunc ŋɔn ŋencepər fɛ tɔkɔ ɛnasak ŋi mɔ, runc yɛsamsər fɛ kɔ dakata-ɛ, wəloŋnɛ pəgbɔkərɛ kəbɔlɛnɛ kɔ sɔ afum haŋ mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kɔ mata camət-mɛrəŋ mɛmbəp sɔ tamɛrəŋ-ɛ, wəloŋnɛ pəkɔkcɛ kɔ, k'ɛnəŋk runc nyɛ yɔfɔncnɛ, yɛsamsər fɛ kɔ dakata-ɛ, wəloŋnɛ ɛntam kəloku a fum wəkakɔ ɔsɔk, amɔncɔ ŋɔ. Wəkayi pəyak yamos yɔn, ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mba kɔ pəyɔnɛ amɔncɔ ŋaŋɔkɔ ŋɔwɔkəl kɔ dakata-ɛ, tɛm ntɛ wəloŋnɛ ɛnalip kəloku kɔ a fum wəsoku ɔfɔ mɔ, wəkayi pəmar pəluksərnɛ kəkɔmentərnɛ wəloŋnɛ sɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Wəloŋnɛ pəkɔ pəkɔkcɛ, kɔ pəyɔnɛ amɔncɔ ŋɔwɔkəl kɔ dakata-ɛ, wəloŋnɛ pəloku a wəkayi ɔsɔk fɛ. Arunc ŋa docu da akata dɛcalərnɛ dɔ yati. ");
INSERT INTO bsp_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Kɔ arunc ŋa docu da akata dɛcalərnɛ ŋosumpər fum-ɛ, pakekərɛ kɔ nda wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Wəloŋnɛ pəkɔkcɛ kɔ: Kɔ akata ŋɔn ŋowur pəkəfər-kəfər pəfer-ɛ, kɔ pəkəfər-kəfər pəfer papɔkɔ pɔsɔŋɛ kɔ cəfon ca dakata kəferɛ-ɛ, haŋ magbali mocwur pəkəfər-kəfər pɔn-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","arunc ŋa docu da akata dɛcalərnɛ ŋɛcəp kɔ dakata. Wəloŋnɛ pəloku a wəkayi ɔsɔk fɛ. Wəloŋnɛ ɔfɔsɔtɛn kəbɔlɛnɛ kɔ afum teta kəkɔkcɛ kɔ sɔ, bawo ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kɔ tɔyɔnɛ arunc ŋa docu da akata dɛcalərnɛ dɛsamsər kɔ dakata, dosumpər akata ŋɔn fəp, kəyɛfɛ dəromp haŋ dəwɛcək, nnɔ o nnɔ wəloŋnɛ ɔŋmɔmən kɔ dis mɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","wəloŋnɛ pəkɔkcɛ kɔ. Kɔ tɔyɔnɛ runc yosumpər kɔ dis fəp-ɛ, wəloŋnɛ pəloku a wəkakɔ ɔsɔk, bawo dis dɔn fəp deferɛ. Fum wəkakɔ ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mba dɔsɔk ndɛ ancop kənəŋk kɔ magbali dəris mɔ, wəkayi ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kɔ wəloŋnɛ ɛnəŋk kɔ magbali-ɛ, pəloku wəkayi a ɔsɔk fɛ: Magbali mɔsɔk fɛ, arunc ŋa docu da akata dɛcalərnɛ dɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Kɔ magbali mɛsəkpər alom meferɛ-ɛ, wəkayi pəkɔ sɔ ndena wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Wəloŋnɛ pəgbɔkərɛ kəkɔkcɛ kɔ. Kɔ pəyɔnɛ arunc ŋɔn ŋeferɛ sɔ-ɛ, wəloŋnɛ pəloku a wəkayi ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kɔ abɛcɛ ŋowur fum, ŋede ŋɛtamnɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a tɛlpəs oŋ, pəkəfər-kəfər pefer pede powur da abɛcɛ ŋɛnayi mɔ kɔ pəyɔnɛ fɛ ti, pətɛmsər petelər pefer peyimbərər pəlɔma pede powur dənda-ɛ, wəkayi pəkɔ pəmentərnɛ wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Wəloŋnɛ pəkɔkcɛ kɔ: Kɔ pəyɔnɛ arunc ŋaŋɔkɔ ŋontukmɛ ŋɛtas akata-ɛ, cəfon ca dənda cəferər-ɛ, wəloŋnɛ pəloku a wəkayi ɔsɔk fɛ. Arunc ŋa docu da akata dɛcalərnɛ dɔ, ndɛ dowur dɛbɛcɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kɔ wəloŋnɛ ɔŋkɔkcɛ arunc ŋaŋɔkɔ ŋɔyɔ fɛ kəfon kəfer-ɛ, arunc ŋaŋɔkɔ ŋontukmɛ fɛ sɔ ŋɛtas akata ŋɔn, tɔyɔnɛ sɔ arunc ŋaŋɔkɔ ŋɔfɔncnɛ-ɛ, wəloŋnɛ pəbɔlɛnɛ wəkayi afum mataka camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kɔ pəyɔnɛ docu dɔwɔkəl kɔ dakata-ɛ, wəloŋnɛ pəloku a ɔsɔk fɛ. Arunc ŋa docu da akata dɛcalərnɛ dɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mba kɔ arunc ŋaŋɔkɔ ŋeyi teyi tɔcɔkɔ-cɔkɔ ta ŋi, ta ŋɔwɔkəl kɔ dakata-ɛ, kəfat ka abɛcɛ kɔ. Wəloŋnɛ pəloku a wəkayi ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kɔ fum ɛntɛyɛ akata, wəkayi pənalɛ akata, pɔyɔnɛ pətɛmsər petelər pəferɛ dənda kɔ pəyɔnɛ fɛ ti, pəferər peyimbərər-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","wəloŋnɛ pəkɔkcɛ kɔ. Kɔ pəyɔnɛ cəfon ca pətɛmsər papɔkɔ peferɛ-ɛ, pətɛmsər papɔkɔ pontukmɛ pɛtas akata-ɛ, arunc ŋa docu da akata dɛcalərnɛ dɔ, ndɛ dosumpər kɔ dənda pəntɛyɛ mɔ. Wəloŋnɛ pəloku a wəkayi ɔsɔk fɛ, arunc ŋa docu da akata dɛcalərnɛ dɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Kɔ wəloŋnɛ ɛnəŋk cəfon cəfer cəyi fɛ kɔ pətɛmsər petelər, ta pəntukmɛ pətas akata, tɔyɔnɛ pəfɔncnɛ-ɛ, wəloŋnɛ pəbɔlɛnɛ wəkayi afum mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Tataka ta camət-mɛrəŋ, wəloŋnɛ pəmɔmən kɔ. Kɔ tɔyɔnɛ arunc ŋɔwɔkəl kɔ dakata-ɛ, wəloŋnɛ pəloku a fum wəkayi ɔsɔk fɛ. Arunc ŋa docu da akata dɛcalərnɛ dɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kɔ pəyɔnɛ pɛtamsər papɔkɔ peyi teyi tɔcɔkɔ-cɔkɔ ta pi-ɛ, kɔ pəyɔnɛ pɔwɔkəl fɛ kɔ dakata pɔfɔncnɛ-ɛ, pəkəfər-kəfər pa kətɛyɛ pɔ. Wəloŋnɛ pəloku a wəkayi ɔsɔk, kəfat ka kətɛyɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kɔ wərkun kɔ pəyɔnɛ fɛ ti wəran pəyɔ arunc dəromp kɔ pəyɔnɛ fɛ ti, dəkek-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","wəloŋnɛ pəkɔkcɛ arunc ŋaŋɔkɔ, kɔ ŋontukmɛ ŋɛtas akata, ta ŋɔyɔ cəfon cəyɔfəl ca alom ŋa cəbe-ɛ, wəloŋnɛ pəloku a wəkayi ɔsɔk fɛ. Tani tɔ, arunc ŋa docu dakata dɛcalərnɛ ndɛ doŋsumpər akata ŋa dəromp kɔ pəyɔnɛ fɛ ti-ɛ ŋa dəkek mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kɔ wəloŋnɛ ɛnəŋk arunc ŋa tani ŋaŋɔkɔ ŋontukmɛ fɛ ŋɛtas akata ŋɔn, ta ŋɔyɔ sɔ cəfon cəbi-ɛ, wəloŋnɛ pəbɔlɛnɛ wəkakɔ ɔyɔ arunc ŋa tani ŋaŋɔkɔ mɔ afum mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Tataka ta camət-mɛrəŋ, wəloŋnɛ pəkɔkcɛ sɔ arunc ŋaŋɔkɔ. Kɔ pəyɔnɛ arunc ŋa tani ŋaŋɔkɔ ŋɔwɔkəl fɛ, ŋɔyɔ fɛ cəfon ca alom ŋa cəbe, ŋontukmɛ fɛ ŋɛtas akata ŋɔn-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","fum wəkakɔ pəfonnɛ, mba ɔfɔfon kəfo kəŋkɔ arunc ŋa tani ŋeyi mɔ. Wəloŋnɛ pəbɔlɛnɛ kɔ afum tamɛrəŋ sɔ, mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Wəloŋnɛ pəgbɔkərɛ sɔ kəkɔkcɛ kɔ arunc ŋa tani tataka ta camət-mɛrəŋ. Kɔ pəyɔnɛ arunc ŋa tani ŋaŋɔkɔ ŋɔwɔkəl fɛ kɔ dakata, ŋontukmɛ fɛ ŋɛtas akata ŋɔn-ɛ, wəloŋnɛ pəloku a wəkayi ɔsɔk, pəyak yamos yɔn, ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kɔ pəyɔnɛ wəkayi ntɛ wəloŋnɛ oloku a ɔsɔk mɔ mba arunc ŋɔn ŋende ŋɔwɔkəl kɔ dakata-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","wəloŋnɛ pəgbɔkərɛ kɔ sɔ kəkɔkcɛ. Kɔ pəyɔnɛ a arunc ŋa tani ŋɔwɔkəl kɔ dakata-ɛ, wəloŋnɛ ɔfɔsɔtɛn kəcərɛ kɔ pəyɔnɛ wəkayi ɔyɔ cəfon ca alom ŋa cəbe-ɛ, wəkayi ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Kɔ pəyɔnɛ arunc ŋa tani ŋaŋɔkɔ ŋɔwɔkəl fɛ kɔ dakata fəp, tɔyɔnɛ cəfon cəbi cəmpoŋ kɔ dənda-ɛ, arunc ŋa tani ŋaŋɔkɔ ŋɛntamnɛ, wəkayi ɔsɔk. Wəloŋnɛ pəloku kɔ a ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Tɔyɔnɛ wərkun kɔ pəyɔnɛ fɛ ti wəran, ɔyɔ pətɛmsər pefer dakata-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","wəloŋnɛ pəkɔkcɛ kɔ. Kɔ pəyɔnɛ pətɛmsər papɔkɔ peferər kɔ pɔfɔncnɛ-ɛ, yatərɛ yowur wəkayi dakata, ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Kɔ wərkun ɔgbɔtəlɛ-gbɔtəlɛ cəfon-ɛ, kəlɛndɛ kɔ, wəkayi ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kɔ pəyɔnɛ dətobu cəfon cəŋgbɔtəlɛ-gbɔtəlɛ kɔ-ɛ, kəlɛndɛ ka dətobu kɔ. Wəkayi ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mba kɔ tɔyɔnɛ tekiriŋ kɔ pəyɔnɛ fɛ ti tadarəŋ ta dənda pəŋgbɔtəlɛ-gbɔtəlɛ mɔ, arunc ŋeyi kəroŋ ŋeferər kɔ pəyɔnɛ fɛ ti, ŋeyimbərər-ɛ, arunc ŋa docu da akata dɛcalərnɛ ŋowur wəkayi dənda dəkəlɛndɛ, tɔyɔnɛ tekiriŋ, tɔyɔnɛ tadarəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Wəloŋnɛ pəkɔkcɛ kɔ. Kɔ tɔyɔnɛ a pəkəfər-kəfər papɔkɔ peferər, peyimbərər, tɔyɔnɛ tekiriŋ tɔyɔnɛ tadarəŋ mba powurɛnɛ kɔ arunc ŋa docu da akata dɛcalərnɛ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","id'osumpər wəkayi, ɔsɔk fɛ. Wəloŋnɛ pəloku kɔ a ɔsɔk fɛ, bawo arunc ŋa docu da akata dɛcalərnɛ dosumpər kɔ domp. ");
INSERT INTO bsp_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Fum nwɛ docu da akata dɛcalərnɛ doŋsumpər mɔ, pəmar pəcbɛrnɛ yamos yɛwalɛ-walɛ, pəwur domp fos. Wəkayi pəkumpnɛ kusu, pəckulɛ-kulɛ: ‹Wətɔsɔk! Wətɔsɔk!› ");
INSERT INTO bsp_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kəwon nkɛ o nkɛ kɔ docu dadɔkɔ dowon kɔ mɔ, ɔsɔk fɛ. Kətɔsɔk kɔn disrɛ, pəyi sona. Dəkiyi dɔn dɔbɔlɛnɛ saŋka.» ");
INSERT INTO bsp_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Kɔ pətɛmsər pa pəmɔf posumpər yamos, tɔyɔnɛ kəloto ka səbeŋa sa cəfon ca aŋkesiya kɔ pəyɔnɛ fɛ ti kəloto ka suwa-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ali pəyɔnɛ kəpol, tɔyɔnɛ kəloto ka səbeŋa sa cəfon ca aŋkesiya, ka kəloto ka suwa, kɔ akata nŋɛ alompəs mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kɔ pətɛmsər papɔkɔ pəyɔ alom ŋobuk, kɔ pəyɔnɛ fɛ ti, alom ŋeyimbərər yamos kəroŋ, kɔ pəyɔnɛ fɛ ti akata kəroŋ-ɛ, pakenɛ wəloŋnɛ pətɛmsər papɔkɔ, pəkɔ pəkɔkcɛ. ");
INSERT INTO bsp_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Wəloŋnɛ pəkɔkcɛ pətɛmsər papɔkɔ, pəmɛŋk paka papɔkɔ haŋ mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Tataka ta camət-mɛrəŋ, wəloŋnɛ pəgbɔkərɛ sɔ kəkɔkcɛ ka paka papɔkɔ: Kɔ pəyɔnɛ a pətɛmsər papɔkɔ pɔwɔkəl pi kəroŋ-ɛ, kəretan kɔ nkɛ antɔtam kəliŋ day mɔ. Paka pɔtɔsɔk pɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Wəloŋnɛ pəcɔf kəpol, kəloto ka səbeŋa sa cəfon ca aŋkesiya, kɔ pəyɔnɛ fɛ ti kəloto ka suwa, kɔ pəyɔnɛ fɛ ti-ɛ, paka papɔkɔ alompsɛ akata mɔ. Bawo afɔtam kəwurɛ pi pətɛmsər papɔkɔ, pacɔf pi. ");
INSERT INTO bsp_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mba kɔ wəloŋnɛ ɔŋkɔkcɛ paka papɔkɔ, pənəŋk pətɛmsər pɔwɔkəl fɛ pi kəroŋ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","wəloŋnɛ pəsom payak pi, pəgbɔkərɛ sɔ pi kəmɛŋk haŋ mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Kɔ wəloŋnɛ endenasɔgbɔkərɛ pi kəkɔkcɛ ntɛ alip pi kəyak mɔ, pənəŋk pətɛmsər papɔkɔ pɛsəkpər fɛ teyi, ali pɔwɔkəl fɛ paka papɔkɔ kəroŋ, paka pɔtɔsɔk pɔ. Pacɔf pi, tɔyɔnɛ tedisrɛ kɔ pəyɔnɛ fɛ ti-ɛ, takəroŋ ta paka papɔkɔ tɔ pəntɛmsər. ");
INSERT INTO bsp_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mba kɔ wəloŋnɛ ɛnəŋk, ntɛ ayak kəloto kaŋkɔ mɔ, pətɛmsər papɔkɔ posumpər fɛ sɔ pəpɔŋ-ɛ, wəloŋnɛ pəwali kəfo kaŋkɔ pənatɛmsər dəyamos, dəkəloto kɔ pəyɔnɛ fɛ ti, paka pa akata mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kɔ tencepər a pətɛmsər pedegbɔkərɛ sɔ kəwur paka papɔkɔ kəroŋ-ɛ, tɔyɔnɛ kəpol, kəloto, paka pa akata, kəretan kəyi kəsumpər paka papɔkɔ, pacɔf pi. ");
INSERT INTO bsp_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Kɔ paka pɛntɛmsər tɔyɔnɛ kəpol, kəloto, paka pa akata mpɛ anayak, pətɛmsər pa pəmɔf papɔkɔ powur mɔ-ɛ, pagbɔkərɛ pi kəyak, a pedeyɔnɛ paka posoku. ");
INSERT INTO bsp_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Sariyɛ sasɔkɔ səcəmɛ docu d’akata dɛcalərnɛ darəŋ, kɔ pətɛmsər pa pəmɔf pa yamos ya səbeŋa sa cəfon ca aŋkesiya kɔ pəyɔnɛ fɛ ti kəloto ka suwa, kɔ pəyɔnɛ fɛ ti, paka mpɛ alompsɛ akata mɔ. Mɛtəksɛ mamɛ mɔŋsɔŋɛ kəcərɛ a paka mpɛ pɔsɔk kɔ pəyɔnɛ fɛ ti-ɛ, pɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Sariyɛ nsɛ səcəmɛ kəsɔkəs ka aŋɛ docu da akata dɛcalərnɛ dosumpər mɔ dɔsɔk da kəsɔkəs kəŋan. Pakenɛ kɔ wəloŋnɛ, ");
INSERT INTO bsp_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","wəloŋnɛ pəwur dəsaŋka sa aka Yisrayel. Kɔ wəloŋnɛ ɛnəŋk docu da akata dɛcalərnɛ da fum wəkawɛ dɛntamnɛ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","wəloŋnɛ pəsom pasumpərɛ wəkakɔ eyi kəsɔkəsnɛ mɔ, bɛmp yosoku mɛrəŋ yeyi wəyeŋ, padeŋər kətɔk kəbotu ambɔnc ka sɛdər, tafəc peyim, kɔ alɛ ŋa hisɔp. ");
INSERT INTO bsp_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Wəloŋnɛ pəsom, pafay abɛmp ŋɔcɔkɔ-cɔkɔ ŋɔkɔ dətɔbɔl mpɛ pɔyɔ domun decempi da dəkəŋgbɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Wəloŋnɛ pəlɛk abɛmp ŋa mɛrəŋ ŋɔkɔ ŋeyi wəyeŋ mɔ kɔ kətɔk kəbotu ambɔnc ka sɛdər, tafəc peyim, kɔ alɛ ŋa hisɔp, pəgbət yi fəp nde dətɔbɔl mpɛ pɔyɔ mecir ma abɛmp ŋɔkɔ afay mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Wəloŋnɛ pəwɛsəsər fum wəkakɔ eyi kəsɔkəsnɛ docu d’akata dɛcalərnɛ mɔ mecir haŋ camət-mɛrəŋ. Kɔ tencepər-ɛ, pəloku fum wəkawɛ ɔsɔk oŋ. Wəloŋnɛ pəsak abɛmp ŋeyi wəyeŋ, ŋɛfɛlər ŋɔkɔ dəkulum. ");
INSERT INTO bsp_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Fum nwɛ asɔkəs mɔ pəyak yamos yɔn, pəfonnɛ cəfon cɔn fəp, pəbikɛ dəromun. Kɔ telip-ɛ, wəkayi ɔsɔk, ɛntam kəbɛrɛ dəsaŋka sa aka Yisrayel, mba pəyi mata camət-mɛrəŋ todoru ta abal ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Tataka ta camət-mɛrəŋ, pəfonnɛ sɔ cəfon ca dəris fəp, ca domp dɔn, ca kek, haŋ ca dəfɔr pəfonnɛ sɔ cəfon cɔn ca dəris cəlpəs cəkɔ. Pəyak yamos yɔn, pəbikɛ domun, tɛm tatɔkɔ ɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Tataka ta camət-maas, wəkayi pəlɛk ŋkesiya yorkun mɛrəŋ ya teren tin tin nyɛ yɔntɔyɔ dolokəp, kɔ aŋkesiya ŋɛran ŋa teren tin ŋɔtɔyɔ dolokəp, kəmbefe kətɔt ka kəloŋnɛ ka mɛŋgbɛn kilo camət-maŋkəlɛ panɔktərɛnɛ ki moro, kɔ moro litɛr dacɔ. Pəkɛrɛ yi wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Wəloŋnɛ nwɛ eyi kəsɔkəs fum mɔ, pəcəmbər wəkayi kɔ yoloŋnɛnɛ yɔn MARIKI fɔr kiriŋ, nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Wəloŋnɛ pəlɛk aŋkesiya ŋorkun ŋɔcɔkɔ-cɔkɔ, pəkekərɛ ŋi MARIKI fɔr kiriŋ teta kəloŋnɛ ka kəlompəs ka kiciya, kɔ moro litɛr dacɔ. Pətubucnɛ kəsɔŋ yi MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Wəloŋnɛ pəfay aŋkesiya ŋorkun nde kəfo kəsoku nkɛ aŋfay yɔcɔl ya kəloŋnɛ teta kiciya kɔ yɔkɔ ancɔfɛ MARIKI mɔ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Yoloŋnɛ ya kəlompəs ka kiciya kɔ ya kəloŋnɛ ka kiciya, wəloŋnɛ ɔyɔ yi. Yeri yosoku yɔ nyɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Wəloŋnɛ pəlɛk mecir ma pɔcɔl poloŋnɛ pa kəlompəs ka kiciya, pəsop mi aləŋəs ŋa kəca kətɔt kɔ tɛlər tɔpɔŋ ta kəca kətɔt kɔ tɛlər tɔpɔŋ ta kəcək kətɔt ka fum wəkakɔ ayi kəsɔkəs mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Wəloŋnɛ pəlɛk moro ma olif, pəkəlnɛ mi kəca kɔn kəmeriya disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Wəloŋnɛ pətɛm tɛlər tɔn tɔcɔkərɛ ta kəca kətɔt dəmoro mɔkɔ meyi kɔ kəca kəmeriya disrɛ mɔ, pəwɛsəsərɛ mi tɛlər tatɔkɔ ɛntɛm dəmoro mɔ camət-mɛrəŋ MARIKI tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Wəloŋnɛ pəlɛk sɔ moro mɔkɔ meyi kɔ dəkəca mɔ, pəsop mi fum wəkakɔ aləŋəs ŋa kəca kətɔt kɔ tɛlər tɔpɔŋ ta kəca kətɔt, kɔ tɛlər tɔpɔŋ ta kəcək kətɔt, da anasop mecir ma poloŋnɛ pa kəlompəs ka kiciya mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Wəloŋnɛ pəsop moro mɛlpəs mɔkɔ mɛncəmɛ kɔ dəkəca mɔ domp da fum wəkɔ ayi kəsɔkəs mɔ. Wəloŋnɛ pətubucnɛ kəsɔkəs wəkayi kətɔsɔk kɔn MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kɔ telip-ɛ, wəloŋnɛ pəkɛrɛ poloŋnɛ pa kiciya, pətubucnɛ kəsɔkəs wəkayi kətɔsɔk kɔn. Wəloŋnɛ pəfay poloŋnɛ mpɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Wəloŋnɛ pəcɔfɛ MARIKI nde tetek toloŋnɛ kəroŋ pɔcɔl poloŋnɛ kɔ pa mɛŋgbɛn. Wəloŋnɛ pətubucnɛ kəsɔkəs wəcunɛ docu ndɛ dɛncalərnɛ dakata mɔ, wəkakɔ ɔŋsɔk oŋ.» ");
INSERT INTO bsp_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Kɔ pəyɔnɛ nwɛ docu da akata dɛcalərnɛ dɛnasumpər mɔ wətɔyɔ daka ɔfɔ, kəsɔtɔ kɔn kəfɔtam kəsɔŋ kɔ daka dadɔkɔ-ɛ, pəlɛk aŋkesiya ŋorkun ŋin ŋa teren tin teta kəloŋnɛ ka kəlompəs ka kiciya, pəmentər ŋi MARIKI ntɛ tɔŋsɔŋɛ patubucnɛ kəsɔkəs kɔ kətɔsɔk kɔn mɔ. Pədeŋər sɔ kəmbefe kətɔt kilo kəmaas nkɛ anɔktərɛnɛ kɔ moro ma olif mɔ teta kəloŋnɛ ka mɛŋgbɛn, kɔ moro litɛr dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Wəkayi pəlɛk mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti-ɛ, ntantoriya mɛrəŋ, pəmɔ tɔkɔ kəsɔtɔ kɔn kəmentər mɔ, ŋin ŋɔyɔnɛ poloŋnɛ pa kiciya, kɔ pa mɛrəŋ pɔyɔnɛ poloŋnɛ pa pɔcɔl poloŋnɛ pɔcɔf. ");
INSERT INTO bsp_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Tataka ta camət-maas wəkayi pəkɛrɛ wəloŋnɛ yoloŋnɛ yɔn fəp nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ, fɔr ya MARIKI kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Wəloŋnɛ pəlɛk aŋkesiya ŋorkun teta kəloŋnɛ ka kəlompəs ka kiciya kɔ moro ma olif litɛr dacɔ, pətubucnɛ kəsɔŋ yi MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Wəloŋnɛ pəfay aŋkesiya ŋorkun nŋɛ aŋkɛrɛ teta kəloŋnɛ ka kəlompəs ka kiciya mɔ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Wəloŋnɛ pəlɛk mecir ma ŋi, pəsop mi aləŋəs ŋa kəca kətɔt ka fum wəkakɔ eyi kəsɔkəsnɛ mɔ, tɛlər tɔn tɔpɔŋ ta kəca kətɔt, kɔ tɛlər tɔn tɔpɔŋ ta kəcək kətɔt. ");
INSERT INTO bsp_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Wəloŋnɛ pəkəl moro ma olif kəca kɔn kəmeriya disrɛ, ");
INSERT INTO bsp_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","pətɛm tɛlər tɔn tɔcɔkərɛ dəmoro mamɔkɔ, pəwɛsəsər camət-mɛrəŋ MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Wəloŋnɛ pəsop moro mamɔkɔ meyi kɔ dəkəca mɔ aləŋəs ŋa kəca kətɔt ka fum wəkakɔ ayi kəsɔkəs mɔ, tɛlər tɔpɔŋ ta kəca kɔn kətɔt kɔ tɛlər tɔpɔŋ ta kəcək kɔn kətɔt, kəfo nkɛ anasop kɔ mecir ma poloŋnɛ pa kəlompəs ka kiciya mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Wəloŋnɛ pəsop moro mɛlpəs mɔkɔ mɛncəmɛ kɔ kəca disrɛ mɔ fum wəkakɔ ayi kəsɔkəs mɔ dəromp, ntɛ tɔŋsɔŋɛ patubucnɛ kəsɔkəs kɔ kətɔsɔk kɔn MARIKI fɔr kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Kɔ tencepər-ɛ, wəloŋnɛ pəlɛk tɔpay pɔcɔkɔ-cɔkɔ kɔ pəyɔnɛ fɛ ti, antantoriya ŋɔcɔkɔ-cɔkɔ, mpɛ wəkayi ɛntam kəsɔtɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Pəloŋnɛ pin kəloŋnɛ ka kiciya, pəloŋnɛ pa mɛrəŋ kəloŋnɛ ka poloŋnɛ pɔcɔf kɔ kəloŋnɛ ka mɛŋgbɛn. Wəloŋnɛ pətubucnɛ kəsɔkəs fum nwɛ ayi kəsɔkəs mɔ MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Sariyɛ sasɔkɔ səcəmɛ wəkɔ docu d’akata dɛcalərnɛ doŋsumpər mɔ, fum wəkɔ kəsɔtɔ kɔn kəmpicɛ teta kəsɔkəs kɔn mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Kɔ nəndekɔbɛrɛ atɔf ŋa Kanaŋ nŋɛ isɔŋ nu mɔ-ɛ, k'isop pətɛmsər pa pəkilər kəlɔ kəlɔma ka atɔf ŋonu ŋofu-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","wəka kəlɔ kaŋkɔ pəkɔ pəloku ti wəloŋnɛ: ‹Pətɛmsər pɔlɔma p'inəŋk nde kəlɔ kem.› ");
INSERT INTO bsp_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Wəloŋnɛ pəsom kərɛsna pawurɛ ca yayɔkɔ yeyi kəlɔ kaŋkɔ disrɛ mɔ, a nkɔn wəloŋnɛ pədebɛrɛ ki kəkɔkcɛ pətɛmsər papɔkɔ. Ti disrɛ, paka mpɛ o mpɛ pɛnayi kəlɔ kaŋkɔ disrɛ mɔ fəp, pɔfɔyɔnɛ pɔtɔsɔk. Kɔ telip-ɛ, wəloŋnɛ pəbɛrɛ kəlɔ kaŋkɔ disrɛ kəkɔkcɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kɔ pəyɔnɛ a pətɛmsər papɔkɔ pɔyɔ alom ŋobukər kɔ pəyɔnɛ fɛ ti alom ŋeyimbərər tɔyɔnɛ abi ŋaŋɔkɔ ŋontukmɛ dədamba da kəlɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","wəloŋnɛ pəwur kəlɔ kaŋkɔ disrɛ. K'eyi dəkəbɛrɛ da kəlɔ-ɛ, pəcaŋ ki mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Wəloŋnɛ pəluksərnɛ di tataka ta camət-mɛrəŋ, kɔ pəyɔnɛ a pətɛmsər papɔkɔ pɔwɔkəl samba sa kəlɔ kəroŋ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","wəloŋnɛ pəsom pawurɛ masar mamɔkɔ mɛntɛmsər mɔ, pakɔ pagbaləs mi kəfo kətɔsɔk, pawurɛnɛ mi dare disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Pakɔs dos dadɔkɔ anasop damba tedisrɛ mɔ fəp, pawurɛnɛ di dare disrɛ nde kəfo kətɔsɔk pagbal. ");
INSERT INTO bsp_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Palɛk masar mɔlɔma, pəcəmbər mi dəkəcəmɛ da mɔcɔkɔ-cɔkɔ. Pawɛt sɔ dos dɔlɔma pasop samba sədisrɛ sasɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Kɔ tɔyɔnɛ pətɛmsər papɔkɔ pɔŋgbɔkərɛ sɔ kəsumpər kəlɔ nkɛ anawurɛ masar a k'aŋkɔs, k'asop sɔ ki dos mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","wəloŋnɛ pəgbɔkərɛ sɔ kəkɔkcɛ ki. Kɔ pəyɔnɛ a pətɛmsər powur sɔ-ɛ, pəkilər pɔ mpɛ pɛncalərnɛ dəkəlɔ mɔ: Kəlɔ kaŋkɔ kəsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Mɛnɛ pacekəli kəlɔ kaŋkɔ, pawuŋ ki, pawɛtəs masar, cəgbo kɔ kəbof nkɛ analɔnɛ kəlɔ kaŋkɔ mɔ fəp, pakɔ pagbal yi kəfo kətɔsɔk, pəwurɛnɛ yi dare disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Fum nwɛ o nwɛ ɛbɛrɛ kəlɔ kaŋkɔ disrɛ mata mamɔkɔ ancaŋ ki mɔ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Fum nwɛ o nwɛ endirɛ kɔ pəyɔnɛ fɛ ti, pədi peri kəlɔ kaŋkɔ disrɛ mɔ, pəyak yamos yɔn. ");
INSERT INTO bsp_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kɔ wəloŋnɛ oluksərnɛ kəkɔkcɛ kəlɔ pənəŋk, ntɛ aŋgbɔkərɛ kəsop ka kəlɔ kaŋkɔ dos mɔ, pətɛmsər powur fɛ sɔ, wəloŋnɛ pəloku kəlɔ kaŋkɔ kəsɔk, pəlɛc peliŋnɛ ki. ");
INSERT INTO bsp_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Kəloŋnɛ ka kəsɔkəs ka kəlɔ, wəloŋnɛ pəlɛk bɛmp mɛrəŋ, kɔ kətɔk kəbotu ambɔnc ka sɛdər, tafəc peyim, kɔ alɛ ŋa hisɔp. ");
INSERT INTO bsp_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Pəfay abɛmp ŋɔcɔkɔ-cɔkɔ tɔbɔl disrɛ mpɛ pɔyɔ domun decempi da dəkəŋgbɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Wəloŋnɛ pəlɛk kətɔk kəbotu ambɔnc ka sɛdər, alɛ ŋa hisɔp, tafəc peyim kɔ abɛmp ŋa mɛrəŋ ŋɔkɔ, pəgbət yi dəromun decempi da dəkəŋgbɔkɔ dɔkɔ deyi tɔbɔl tɔkɔ pɔyɔ mecir ma abɛmp ŋɔkɔ afay mɔ, pəwɛsəsər kəlɔ kaŋkɔ haŋ camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Pəliŋɛ pətɔsɔk pa kəlɔ kaŋkɔ mecir ma abɛmp, domun decempi da dəkəŋgbɔkɔ dadɔkɔ, abɛmp ŋɔkɔ antɔfay mɔ, kɔ kətɔk kəbotu ambɔnc ka sɛdər, alɛ ŋa hisɔp kɔ tafəc peyim. ");
INSERT INTO bsp_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Wəloŋnɛ pəsak abɛmp ŋɛfɛlər ŋowur dare disrɛ, ŋɔkɔ dəkulum. Tatɔkɔ tɔ wəloŋnɛ ontubucnɛ kəsɔkəs ka kəlɔ kətɔsɔk ka ki. Kəlɔ kaŋkɔ kəŋsɔk oŋ tɛm tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Sariyɛ sasɔkɔ səcəmɛ docu d’akata dɛcalərnɛ kɔ tani ta dəromp fəp darəŋ, ");
INSERT INTO bsp_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","kəyɛfɛ pəkilər pa wɔlɔ haŋ yamos, ");
INSERT INTO bsp_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kəyɛfɛ pəkəfər-kəfər, amɔncɔ, haŋ pətɛmsər pomotər-motər fəp. ");
INSERT INTO bsp_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Sariyɛ saŋsɛ səŋsɔŋɛ kəcərɛ kəyɛfɛ ka fum kəkɔ ka ca yɛlpəs nyɛ, ca ncɛ yɔsɔk kɔ nyɛ yɔntɔsɔk mɔ. Sariyɛ sa docu da akata dɛcalərnɛ, pəmɔf pa yamos, kɔ pəkilər sɔ sasɔkɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Kɔ MARIKI osom Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Nəloku aka Yisrayel: Wərkun nwɛ o nwɛ docu dɔsɔŋɛ domun dɛcgbələr dəkəsɔtɛ dɔn ta pəyɔnɛ mɔsɔtɛ mɔ-ɛ, dɔsɔŋ kɔ kətɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kɔ docu dadɔkɔ dɔcsɔŋɛ domun docwur dəkəsɔtɛ dɔn ta pəyɔnɛ mɔsɔtɛ, kɔ pəyɔnɛ fɛ ti, ta doŋwur kɔ-ɛ, pəyi oŋ ntɛ o ntɛ, domun dadɔkɔ dɔsɔŋɛ kɔ kətɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kəfənc nkɛ o nkɛ kɔ wəkayi ɛfəntərɛ, kɔ pəyɔnɛ fɛ ti dɔcɔm ndɛ o ndɛ dɔ wəkayi ɔnɔnɛ, yɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Fum nwɛ o nwɛ oŋgbuŋɛnɛ kəfənc kaŋkɔ, pəyak yamos yɔn, pəbikɛ dis dɔn. Wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Fum nwɛ ɛndɛ dɔcɔm ndɛ fum wətɔtamnɛ wəkayi ɛyɛfɛ mɔ, pəyak yamos yɔn, pəbikɛ. Wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Fum nwɛ oŋgbuŋɛnɛ wətɔtamnɛ wəkayi mɔ, pəyak yamos yɔn, pəbikɛ. Wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kɔ wətɔtamnɛ wəkakɔ oyukər fum wəsoku lin-ɛ, wəsoku wəkakɔ pəyak yamos yɔn, pəbikɛ. Ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Dɔcɔm da pɛyɛksɛnɛ mpɛ o mpɛ dɔ fum wətɔtamnɛ ɛndɛ kəroŋ pəkɔ delek mɔ, dɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Fum nwɛ o nwɛ ogbuŋɛnɛ paka mpɛ wətɔtamnɛ wəkakɔ ɛnafakɛnɛ mɔ, ɔsɔk fɛ haŋ dec dɛkalɛ. Fum nwɛ ɛŋlɛk ca pəmɔ yayɔkɔ mɔ, pəyak yamos yɔn, pəbikɛ. Ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Fum nwɛ o nwɛ wətɔtamnɛ oŋgbuŋɛnɛ ta embikɛnɛ waca mɔ, fum wəkakɔ oŋgbuŋɛnɛ mɔ, pəyak yamos yɔn, pəbikɛ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Pɛsɛl mpɛ o mpɛ pɔ wətɔtamnɛ wəkayi oŋgbuŋɛnɛ mɔ, pawɔkəc pi. Kɔ pəyɔnɛ pɛbɛrɛ paka pa kətɔk pɔ-ɛ, pagbosɛ pi domun. ");
INSERT INTO bsp_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Kɔ domun dɔkɔ dɛnasɔŋɛ fum wəkakɔ kətɔsɔk mɔ dɛsakɛ kɔ kəcgbələr-ɛ, fum wəkakɔ pəkar tataka toluksər tin, a pəcsɔk. Pəyak yamos yɔn, pəbikɛ domun decempi da dəkəŋgbɔkɔ, k'elip-ɛ, ɔsɔk oŋ. ");
INSERT INTO bsp_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Tataka ta camət-maas, wəkayi pəlɛk mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti-ɛ, ntantoriya mɛrəŋ, pəkɔ nde MARIKI fɔr kiriŋ, nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, pəkɔ pəsɔŋ yi wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Wəloŋnɛ pəloŋnɛ abɛmp ŋin teta kəloŋnɛ ka kiciya kɔ abɛmp ŋa mɛrəŋ teta kəloŋnɛ ka poloŋnɛ pɔcɔf. Kɔ telip-ɛ, MARIKI fɔr kiriŋ wəloŋnɛ pətubucnɛ kəsɔkəs wəkayi kətɔsɔk kaŋkɔ kənayi kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Fum nwɛ o nwɛ domun d'arkun dowur kɔ mɔ, wəkayi pəbikɛ dis dɔn fəp. Wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Pəyɔnɛ yamos, pəyɔnɛ pokumpɛnɛ pa akata, kɔ domun d'arkun dadɔkɔ doŋgbuŋɛnɛ pi-ɛ, payak paka papɔkɔ, mba pɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kɔ wərkun ɛfəntərər wəran-ɛ, mɛrəŋ maŋan fəp ŋabikɛ, ŋasɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kɔ wəran ɛnəŋk wəka darenc, mecir mɛcgbələr kɔ-ɛ, ɔsɔk fɛ haŋ tataka toluksər tin. Fum nwɛ oŋgbuŋɛnɛ kɔ mɔ, wəkayi sɔ ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kɔ wəran ɛnəŋk wəka darenc-ɛ, kəfənc nkɛ o nkɛ k'ɛfəntərɛ, dɔcɔm ndɛ o ndɛ dɔ wəkayi ɛndɛ, yɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Fum nwɛ o nwɛ ogbuŋɛnɛ kəfənc kaŋkɔ, pəyak yamos yɔn, pəbikɛ dis dɔn. Wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Fum nwɛ o nwɛ oŋgbuŋɛnɛ dɔcɔm dadɔkɔ mɔ, wəkayi pəyak yamos yɔn, pəbikɛ dis dɔn, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kɔ tɔyɔnɛ paka pɔlɔma pɛnayi kəfənc kɔ pəyɔnɛ fɛ ti-ɛ, paka pɔkɔ wəran wəkakɔ ɛnandɛ kəroŋ mɔ, nwɛ o nwɛ ogbuŋɛnɛ paka papɔkɔ mɔ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kɔ pəyɔnɛ ŋafəntərɛ kɔ wərkun kəfənc kin, mecir mɔn ma wəka darenc mosoptɛ wərkun-ɛ, wərkun wəkakɔ ɔsɔk fɛ haŋ tataka toluksər tin, kəfənc nkɛ o nkɛ k'ɛfəntərɛ kəroŋ kəsɔk fɛ sɔ. ");
INSERT INTO bsp_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kɔ mecir mendegbələr wəran, ta pəyɔnɛ wəka darenc ɛnəŋk-ɛ, kɔ pəyɔnɛ fɛ ti, pənəŋk wəka darenc tecepər mataka mɔkɔ ɔmbɔt nəŋk kɔ, ɔsɔk fɛ haŋ dɔsɔk ndɛ tɛŋsakɛ kɔ, pəmɔ tɔkɔ ɔntɔsɔk ntɛ endenəŋk wəka darenc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kəfənc nkɛ o nkɛ k'ɛfəntərɛ, paka mpɛ o mpɛ p'ɛndɛ kəroŋ mata mamɔkɔ mecir mendegbələr kɔ mɔ, yɔsɔk fɛ pəmɔ tɔkɔ wəran ɔntɔsɔk k'endenəŋk wəka darenc-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Fum nwɛ o nwɛ oŋgbuŋɛnɛ kəfənc kaŋkɔ kɔ pəyɔnɛ fɛ ti dɔcɔm dadɔkɔ mɔ, pəyak yamos yɔn, pəbikɛ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Kɔ mecir mɛsakɛ kɔ kəgbələr-ɛ, wəran wəkakɔ pəkar sɔ tataka toluksər tin, a pədesɔk sɔ. ");
INSERT INTO bsp_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Tataka ta camət-maas, pəlɛk mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti, ntantoriya mɛrəŋ pəkenɛ yi wəloŋnɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Wəloŋnɛ pəloŋnɛ abɛmp ŋin ŋɔkɔ teta kəloŋnɛ ka kiciya, kɔ abɛmp ŋa mɛrəŋ ŋɔkɔ teta kəloŋnɛ ka poloŋnɛ pɔcɔf. Kɔ telip-ɛ, wəloŋnɛ pətubucnɛ MARIKI fɔr kiriŋ kəsɔkəs kɔ kətɔsɔk ka kəwur ka mecir kɔn.» ");
INSERT INTO bsp_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kɔ MARIKI oloku Musa kɔ Aruna: «Nəloku aka Yisrayel a ŋabɔlɛnɛ aŋgbip ŋosoku kɔ ŋantɔsɔk-ɛ: Ti tendesɔŋɛ ta ŋafinɛ teta kətɔsɔk kəŋan nkɛ kəntam kəsɔŋɛ dəkiyi dem kətɔsɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Sariyɛ saŋsɛ səcəmɛ kəyɛfɛ afum aŋɛ docu da kəgbələr domun dəkəsɔtɛ daŋan dosumpər ta pəyɔnɛ mɔsɔtɛ mɔ-ɛ, tɔsɔŋɛ ŋa kətɔsɔk, ");
INSERT INTO bsp_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kəbəp wəran nwɛ eyi kənəŋk wəka darenc mɔ, kəlɛkɛnɛ ka wərkun kɔ pəyɔnɛ fɛ ti wəran nwɛ docu da kəgbələr domun dəkəsɔtɛ dɔn doŋsumpər mɔ, kɔ wərkun nwɛ ɛŋfəntərər wəran nwɛ ɔntɔsɔk mɔ tɔŋsɔŋɛ fəp faŋan kətɔsɔk.» ");
INSERT INTO bsp_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Kɔ MARIKI oloku Musa ntɛ awut arkun a Aruna mɛrəŋ aŋɛ ŋanamentərnɛ nde MARIKI fɔr kiriŋ kɔ ŋafinɛ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Kɔ MARIKI osom Musa: «Məloku wɛnc əm Aruna, ta pəde pəcbɛrɛ tɛm fəp nde dətɔksɔ, ta pəde pəccali tɛm fəp kəloto nkɛ kəŋkəŋk afɛŋk ŋɔsɔksɛ kiciya nŋɛ ŋeyi kaŋkəra ka danapa da MARIKI kəroŋ mɔ, ta pədefi tɛm ntɛ indewur dəkəp afɛŋk ŋaŋɔkɔ kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Tɛbɛrɛ ntɛ tɔ Aruna ende pəcbɛrɛ nde dətɔksɔ tosoku: Pəlɛk tura teta kəloŋnɛ ka kiciya, kɔ aŋkesiya ŋorkun teta poloŋnɛ pɔcɔf. ");
INSERT INTO bsp_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Pəbɛrnɛ duma dedisrɛ, kɔ kɔgba, pəgbəncnɛ tabataba, pəcəpnɛ kəfakəl. Yamos yayɔkɔ fəp yɔyɔnɛ yopus, ya kəloto ka suwa, iy'ende pəcbɛrnɛ k'elip kəbikɛ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kəloŋkanɛ ka aka Yisrayel ŋade ŋacsɔŋ Aruna mbiyofo mɛrəŋ teta kəloŋnɛ ka kiciya kɔ aŋkesiya ŋorkun ŋin teta poloŋnɛ mpɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aruna pəlɔtərnɛnɛ tura tetek toloŋnɛ, pəloŋnɛ pi teta kiciya ka nkɔnsərka, pətubucnɛ kəsɔkəsnɛ kiciya kɔn kɔ ka aka kəlɔ kɔn disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Aruna pəlɛk mbiyofo nyɛ mɛrəŋ, pəkekərɛ yi MARIKI fɔr kiriŋ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aruna pəkot yampuŋpuŋ ntɛ tɔŋsɔŋɛ pəcərɛ a mbiyofo yayɔkɔ mɛrəŋ, ŋɔkɔ aloŋnɛnɛ MARIKI mɔ, kɔ ŋɔkɔ aŋkekərɛ kəkɔsak yɛŋən nde dətɛgbərɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ambiyofo nŋɛ yampuŋpuŋ yɔsɔŋ MARIKI mɔ, Aruna pəlɛk ŋi, pəloŋnɛ teta kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Kɔ ambiyofo nŋɛ yampuŋpuŋ yɔsɔŋ kəkɔsak yɛŋən nde dətɛgbərɛ mɔ, Aruna pəkekərɛ ŋi ŋeyi wəyeŋ nde daŋgbancan MARIKI fɔr kiriŋ, pətubucnɛ kəsɔkəs ŋi kiciya a padekekərɛ ŋi kəkɔsak yɛŋən nde dətɛgbərɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aruna nkɔn pəkekərɛ tura pa kəloŋnɛ ka kiciya ka nkɔnsərka, pətubucnɛ kəsɔkəsnɛ kiciya kɔn, kɔ ka aka kəlɔ kɔn disrɛ. Pəfay tura pa kəloŋnɛ ka kiciya ka nkɔnsərka. Pasu tɔbɔl, mecir mamɔkɔ mɛbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Aruna pəlɛk nde tetek toloŋnɛ pa dətɔksɔ kəroŋ tap tɛlarɛ meken MARIKI fɔr kiriŋ, kɔ suray sətɔt aŋkulma kəmɛrəŋ, pəkekərɛ yi kəloto kəkəŋkɛ tadarəŋ, nde dətɔksɔ tosoku, ");
INSERT INTO bsp_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","pəcɔf suray sasɔkɔ MARIKI fɔr kiriŋ, ntɛ tɔŋsɔŋɛ kinimɛ ka suray kaŋkɔ kəgbəpərnɛ afɛŋk nŋɛ ŋeyi kaŋkəra nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel mɔ, ntɛ tɔŋsɔŋɛ Aruna kətɔfi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Aruna pəgbət tɛlər tɔn dəmecir ma tura pa kəloŋnɛ ka kiciya, pəwɛsəsər afɛŋk ŋɔsɔksɛ kiciya ntende dec dɛmpɛ mɔ. Pəwɛsəsər sɔ haŋ camət-mɛrəŋ afɛŋk ŋɔsɔksɛ kiciya tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Kɔ telip-ɛ, Aruna pəwur sɔ pəfay ambiyofo ŋa kəloŋnɛ ka kiciya ka aka Yisrayel. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. Aruna pəkekərɛ mecir mamɔkɔ nde kəloto kəkəŋkɛ tadarəŋ. Aruna pəyɔ sɔ mecir ma ambiyofo mamɔkɔ pəmɔ tɔkɔ ɔyɔ mecir ma tura mɔ, pəwɛsəsər mecir mamɔkɔ afɛŋk ŋɔsɔksɛ kiciya kəroŋ kɔ tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ti disrɛ Aruna pətubucnɛ kəsɔkəs ka tɔksɔ tosoku, dɛtaŋi ləŋəs da aka Yisrayel kɔ kiciya kəŋan fəp. Kɔ tɛyɛfɛ day-ɛ, pəyɔ sɔ tin tayi aŋgbancan ŋɛbəpɛnɛ kɔ Kanu nŋɛ ŋeyi ŋa dacɔ kətɔsɔk kəŋan disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ali fum ɔfɔyi aŋgbancan ŋɛbəpɛnɛ kɔ Kanu disrɛ kɔ Aruna endebɛrɛ dətɔksɔ kəkɔtubucnɛ kəsɔkəs kiciya-ɛ, haŋ tɛm ntɛ endewur mɔ. Aruna pətubucnɛ kəsɔkəsnɛ kiciya kɔn, ka kəlɔ kɔn disrɛ, kɔ ka kəloŋkanɛ ka aka Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","K'elip-ɛ, pəwur ntende dətetek toloŋnɛ pɔkɔ peyi MARIKI fɔr kiriŋ mɔ, pətubucnɛ kəsɔkəs pi kətɔsɔk, pəlɛk mecir ma tura kɔ ma ambiyofo, pəsopət mi lɛn maŋkəlɛ ya moŋkubut ma tetek toloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Aruna pəwɛsəsərɛ tɛlər tɔn mecir haŋ camət-mɛrəŋ tetek toloŋnɛ kəroŋ. Kiciya ka aka Yisrayel kənasɔŋɛ pi kətɔsɔk, mba ti disrɛ Aruna pəsɔkəs pi, poluksərnɛ sɔ kəyɔnɛ paka popus. ");
INSERT INTO bsp_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Kɔ Aruna elip kətubucnɛ kəsɔkəs kətɔsɔk ka tɔksɔ, ka aŋgbancan ŋɛbəpɛnɛ kɔ Kanu kɔ ka tetek toloŋnɛ-ɛ, pakɛrɛ kɔ ambiyofo ŋeyi wəyeŋ. ");
INSERT INTO bsp_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aruna pədeŋər waca wɔn mɛrəŋ ambiyofo ŋaŋɔkɔ ŋeyi wəyeŋ mɔ, pəlɔmər ŋi kiciya ka aka Yisrayel, dɛtaŋi daŋan ləŋəs kɔ mes maŋan mɛlɛc fəp, pəsarsər ŋi. Kɔ telip-ɛ, pawurɛ fum ŋa dacɔ, pəkekərɛ ambiyofo ŋaŋɔkɔ nde dətɛgbərɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Tɛm tatɔkɔ, ambiyofo ŋɛsarɛ kiciya ka aka Yisrayel fəp, ŋekekərɛ ki kəfo kəyer-yer nkɛ antɔbəp mɔ. Wəkayi pəkekərɛ ambiyofo pəsak ŋi nde dətɛgbərɛ. ");
INSERT INTO bsp_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Aruna pəluksərnɛ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, pəwurɛ yamos ya kəloto ka suwa yɔkɔ ɛnabɛrnɛ a k'ɛmbɛrɛ nde dətɔksɔ tosoku mɔ, pəboc yi dəndo deŋgbip. ");
INSERT INTO bsp_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Pəbikɛ dəndo kəfo kaŋkɔ ampusɛ kɔ kəbikɛ mɔ, pəbɛrnɛ yamos yɔn. Aruna pəwur, pəloŋnɛ pɔcɔl pɔcɔf pɔn kɔ pa aka Yisrayel. Pətubucnɛ kəsɔkəsnɛ kiciya kɔn kɔ ka aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Pəcɔfɛ MARIKI tetek toloŋnɛ kəroŋ moro ma pɔcɔl poloŋnɛ pa kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Fum nwɛ eŋkekərɛ ambiyofo ŋaŋɔkɔ kəkɔsak yɛŋən nde dətɛgbərɛ mɔ, pəyak yamos yɔn, pəbikɛnɛnɛ domun a pədebɛrɛ dəsaŋka. ");
INSERT INTO bsp_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ntɛ tɔyɔnɛ tura kɔ ambiyofo nyɛ aloŋnɛnɛ kiciya, a k'aŋkekərɛ mecir ma yi dətɔksɔ kəkɔtubucnɛ kəsɔkəs ka kətɔsɔk kɔ ka kiciya fəp mɔ, pakekərɛ yɔcɔl yayɔkɔ mɛrəŋ saŋka todoru, pacɔf akata, sɛm kɔ yedisrɛ ya aputuk ya yi. ");
INSERT INTO bsp_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Fum nwɛ ɛŋgbal yi dənɛnc mɔ pəyak yamos yɔn, pəbikɛ a pədebɛrɛ dəsaŋka. ");
INSERT INTO bsp_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Sariyɛ sasɔkɔ sɔ nəde nəcyɔ doru o doru: Tataka ta wəco ta ŋof ŋa camət-mɛrəŋ, nəsuŋ, ali tɛbəc ta nəsumpər, kəyɛfɛ nəna aka Yisrayel haŋ kəbəp acikəra akɔ ŋancepərɛnɛ tɛm tepic nu dacɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","bawo dɔsɔk dadɔkɔ d'antubucnɛ kəsɔkəs nu kiciya konu. Nəndesɔk oŋ MARIKI fɔr kiriŋ teta kiciya konu fəp. ");
INSERT INTO bsp_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Dɔsɔk dadɔkɔ camcam dede dɔyɔnɛ nu dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ, nəde nəcsuŋ. Nəde nəcleləs sariyɛ sasɔkɔ doru o doru. ");
INSERT INTO bsp_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kɔ Aruna encepər-ɛ, wəloŋnɛ nwɛ ende pəctubucnɛ kəsɔkəs kiciya kɔ kətɔsɔk mɔ endeyɔnɛ wəloŋnɛ nwɛ anabɔy moro teta yɛbəc ya dəKanu, padəs kɔ dəkəcəmɛ da kas kəyɔnɛ ka wəloŋnɛ wəpɔŋ. Pəde pəcbɛrnɛ yamos ya dəKanu ya kəloto ka suwa. ");
INSERT INTO bsp_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Nkɔn ende pəctubucnɛ kəsɔkəs ka tɔksɔ tosoku, aŋgbancan ŋɛbəpɛnɛ kɔ Kanu kɔ tetek toloŋnɛ, pətubucnɛ kəsɔkəs aloŋnɛ kɔ kəloŋkanɛ ka aka Yisrayel fəp kiciya kəŋan. ");
INSERT INTO bsp_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Sariyɛ sɔ, nsɛ nəntɔdesak kəyɔ doru o doru mɔ, ntɛ tɔŋsɔŋɛ katin kəren o kəren disrɛ, pactam kətubucnɛ kəsɔkəs aka Yisrayel fəp kiciya kəŋan.» K'ayɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Məloku Aruna, awut ɔn kɔ aka Yisrayel fəp, a ntɛ tɔ MARIKI osom: ");
INSERT INTO bsp_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Kɔ wəka Yisrayel ɛfaŋ kəfay tura, aŋkesiya kɔ pəyɔnɛ fɛ ti wir saŋka disrɛ kɔ pəyɔnɛ fɛ ti saŋka tadarəŋ, ");
INSERT INTO bsp_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ta eŋkekərɛ pɔcɔl papɔkɔ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu kəkɔloŋnɛ pi MARIKI nde dəkiyi dɔn tekiriŋ-ɛ, aŋlɔm wəkayi wəsarɛ kiciya teta mecir mamɔkɔ oloŋ mɔ. Aŋwurɛ wəkayi aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ti disrɛ sariyɛ saŋsɛ səndesɔŋɛ aka Yisrayel kətɔfay sɔ yɔcɔl yaŋan dəkulum, mba ŋackenɛ yi MARIKI kəloŋnɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, fɔr ya wəloŋnɛ kiriŋ. Ŋakenɛ yi MARIKI teta kəloŋnɛ ka kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Wəloŋnɛ pəwɛsəsər mecir ma yoloŋnɛ yayɔkɔ tetek toloŋnɛ pa MARIKI mpɛ pəyi dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. Pəcɔfɛ moro ma yi MARIKI, ambɔnc ŋaŋɔkɔ ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ti disrɛ aka Yisrayel kətɔsɔ kəcloŋnɛ canu ca yem ncɛ cəwurɛnɛ mbiyofo, ncɛ ŋayi pəyamayama mɔ. Aka Yisrayel ŋacəmɛ sariyɛ sasɔkɔ darəŋ doru o doru, dɛtɛmp o dɛtɛmp daŋan. ");
INSERT INTO bsp_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Awa! Məloku ŋa sɔ ntɛ: Kɔ wəka Yisrayel, kɔ pəyɔnɛ fɛ ti wəcikəra nwɛ eyi ŋa dacɔ mɔ, pəckɛrɛ poloŋnɛ pɔcɔf, kɔ pəyɔnɛ fɛ ti, poloŋnɛ pɔlɔma, ");
INSERT INTO bsp_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ta eŋkekərɛ pɔcɔl papɔkɔ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu tekiriŋ kəkɔloŋnɛ MARIKI-ɛ, aŋwurɛ fum wəkakɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Fum nwɛ o nwɛ, pəyɔnɛ wəka Yisrayel, pəyɔnɛ wəcikəra nwɛ eyi aka Yisrayel dacɔ mɔ, omun mecir pəyɔnɛ mmɛ o mmɛ, iŋkafələrnɛ wəkakɔ omun mecir mɔ, iwurɛ kɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Bawo kiyi wəyeŋ ka dis, dəmecir kəyi. Ina MARIKI in'ɛcəmbərɛ nu mi dətetek toloŋnɛ, ntɛ tɔŋsɔŋɛ isɔkəs nu kiciya konu mɔ, bawo mecir mɔŋsɔŋɛ kəsɔkəs kiciya. Ntɛ tɔyɔnɛ, a mi mɔtɔmpər kəyi wəyeŋ ka dis mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","It'ɔsɔŋɛ k'iloku aka Yisrayel: Ta nwɛ o nwɛ nu dacɔ pəmun mecir. Ta wəcikəra nwɛ o nwɛ eŋyi nu dacɔ mɔ pəmun mecir. ");
INSERT INTO bsp_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Kɔ wəka Yisrayel wəlɔma kɔ pəyɔnɛ fɛ ti, wəcikəra nwɛ eyi nu dacɔ mɔ, osumpər dəkulum wɛsɛm kɔ pəyɔnɛ fɛ ti, abɛmp nyɛ awosɛ kəsɔm mɔ, pəloŋ mecir ma yi dəntɔf pəkufunɛ mi kəbof. ");
INSERT INTO bsp_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Bawo kiyi wəyeŋ doru fəp, dəmecir kəyi. It'ilokɛ aka Yisrayel: Ta nəmun mecir ma paka peyi wəyeŋ mpɛ o mpɛ, bawo kiyi wəyeŋ doru fəp, dəmecir kəyi. Nwɛ o nwɛ omun mecir ma paka peyi wəyeŋ mɔ, aŋwurɛ wəkayi aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kɔ fum o fum wəka Yisrayel kɔ pəyɔnɛ fɛ ti, wəcikəra nwɛ eyi ŋa dacɔ mɔ, wəlɔma ɔsɔm wɛsɛm nwɛ wefi wisərka, kɔ pəyɔnɛ fɛ ti, wɛsɛm wəlɔma wendif wi-ɛ, pəyak yamos yɔn, pəbikɛnɛnɛ domun, ɔsɔk fɛ haŋ dec dɛkalɛ. Kɔ tencepər-ɛ, wəkayi ɔsɔk oŋ. ");
INSERT INTO bsp_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kɔ fum wəkayi ɔntɔyak yamos yɔn, k'embikɛnɛ fɛ sɔ-ɛ, wəkayi ɛŋsarɛ kiciya.» ");
INSERT INTO bsp_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Məsom aka Yisrayel, məloku ŋa: In'ɔyɔnɛ MARIKI, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ta nəyɔ mes mɔkɔ aŋyɔ atɔf ŋa Misira nde nənayi mɔ, ta nəyɔ sɔ mes mɔkɔ aŋyɔ atɔf ŋa Kanaŋ nde iyi kəkekərɛ nu mɔ. Ta nəcəmɛ mɔyɔ maŋan darəŋ! ");
INSERT INTO bsp_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nəde nəcyɔ mɔyɔ mokur mem, nəmɛŋkərnɛ sariyɛ sem, bawo in'ɔyɔnɛ MARIKI Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Nəmɛŋkərnɛ sariyɛ sem kɔ mɔyɔ mokur mem: Məna nwɛ mənde kəccəmɛ mi darəŋ mɔ, məŋyinɛ mi doru. In'ɔyɔnɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ta wəYisrayel nwɛ o nwɛ ŋafəntərɛ kɔ wəran nwɛ ŋalɔtərɛnɛ dokom mɔ. In'ɔyɔnɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ta məfəntərɛ kɔ wəran ka wisi nwɛ ɔyɔnɛ wiri mɔ. Iya kam ɔfɔ, ta məfəntərɛ kɔ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ta məfəntərɛ kɔ kɔncəra kam nwɛ o nwɛ. Kəlapəs ka wisi kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ta məfəntərɛ kɔ wəkirɛ kam, wəpaŋnɛ kɛrɛ kɔ pəyɔnɛ fɛ ti, nwɛ nəmpaŋnɛ kas mɔ, tɔyɔnɛ pakom kɔ kəlɔ konu disrɛ, kɔ pəyɔnɛ fɛ ti kəfo kəcuru. ");
INSERT INTO bsp_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ta məfəntərɛ kɔ wansɔ kam wəran, nwɛ wan kam wərkun kɔ pəyɔnɛ fɛ ti wan kam wəran oŋkom mɔ. Kəlapəs kam kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ta məfəntərɛ kɔ wan wəran nwɛ kɔncəra kam oŋkom mɔ. Wan wəran wəkakɔ wisi aŋkomɛ kɔ, wəkirɛ kam ɔfɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ta məfəntərɛ kɔ wəkirɛ ka papa kam, bawo wəkomɛnɛ ka papa kam ɔfɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ta məfəntərɛ kɔ wɛnc wəran ka iya wəkam, bawo wəkomɛnɛ ka iya wəkam ɔfɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ta məlapəs wɛnc ka wisi kəfəntərɛ kɔ wəran kɔn, bawo kɔncəra kam ɔfɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ta məfəntərɛ kɔ wəran ka wan kam wərkun. Wəran ka wan kam ɔfɔ. Ta məfəntərɛ kɔ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ta məfəntərɛ kɔ wəran ka wɛnc əm, kəlapəs ka wɛnc əm kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ta məfəntərər wəran kɔ wan kɔn wəran. Ta məfəntərər sɔ yuruya yɔn yɛran nyɛ o nyɛ, tɔyɔnɛ wərkun kɔ pəyɔnɛ fɛ ti-ɛ wəran, akomɛnɛ ɔn pat ŋɔ. Tes tɛlɛc ta kəbut amera tɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ta mənɛncɛ wɛnc wəran ka wəran kam kəyi ka wəran kam doru fəp. Tɔŋsɔŋɛ kəraca kəyi ŋa dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ta məfəntərɛ kɔ wəran tɛm ntɛ endenəŋk wəka darenc bawo wəran wəkakɔ ɔsɔk fɛ tɛm tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ta məfəntərɛ kɔ wəran ka wɛnc wəlɔma afum am dacɔ, bawo tɔŋsɔŋ'am kətɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ta məloŋnɛ məcɔfɛ wan kam wəkin kanu ka yem Molɛk. Kɔ pəyɔnɛ ti-ɛ, ta nəfulus tewe ta Kanu kam. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ta wərkun pəfəntərɛ kɔ wərkun pəmɔ tɔkɔ ɛŋfəntərɛ kɔ wəran mɔ. Pəyikyik mpɛ MARIKI enter mɔ pɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ta məfəntərər ali pɔcɔl mpɛ o mpɛ, bawo tɔŋsɔŋ'am kətɔsɔk. Ali wəran sɔ ta ŋafəntərɛ kɔ pɔcɔl. Dɛyamayama dɔpɔŋ dɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ta mpɛ o mpɛ yi dacɔ pɔsɔŋɛ nu kətɔsɔk bawo mes mamɔkɔ fəp mɛnasɔŋɛ afum a tɔf yɔlɔma, aŋɛ iyi kəbɛləs nu tekiriŋ mɔ, kətɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Atɔf ŋa Kanaŋ yati ŋɔsɔk fɛ sɔ, iluksɛ kəway ka kiciya ka ŋi, kɔ atɔf ŋɛŋɛnc akɔ ŋanandɛ ŋi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nəna aka Yisrayel kɔ acikəra aŋɛ ŋayi nu dacɔ mɔ, nəmɛŋkərnɛ sariyɛ kɔ mɔyɔ mokur mem, ta nədekɔ nəcyɔ pəyikyik papɔkɔ MARIKI enter mɔ de. ");
INSERT INTO bsp_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Afum akɔ ŋananuŋkɛnɛ kəndɛ atɔf ŋaŋɔkɔ mɔ, ŋanayɔ ŋi pəyikyik fəp mpɛ MARIKI enter mɔ, kɔ tɔsɔŋɛ atɔf kətɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ti disrɛ, ta nəsɔŋɛ antɔf kətɔsɔk, ŋendeŋɛnc nəna aŋɛ nəsɔŋɛ ŋi kətɔsɔk mɔ, pəmɔ tɔkɔ ŋɛnaŋɛnc akɔ ŋananuŋkɛnɛ ŋi kəndɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Fum o fum ɔyɔ pəyikyik papɔkɔ mpɛ o mpɛ MARIKI enter mɔ, aŋwurɛ kɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nəmɛŋkərnɛ mosom mem, ta nənde nəcyɔ pəyikyik mpɛ MARIKI enter mɔ, ta nəde nəcyɔ mɔyɔ meyikyik mmɛ anuŋkɛnɛ kəndɛ ka atɔf ŋaŋɛ ŋancyɔ, a nəna nədeder mɔ. Ta mɔyɔ mamɔkɔ medesɔŋɛ nu kətɔsɔk. MARIKI iyɔnɛ, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Məloku kəloŋkanɛ ka Yisrayel fəp: Pəmar nəyɔnɛ afum acempi aŋɛ ampus'em mɔ, bawo ina MARIKI Kanu konu, incemp! ");
INSERT INTO bsp_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Fum nwɛ o nwɛ nəna dacɔ pəleləs kɛrɛ kɔ kas, pəleləs sɔ dɔsɔk dem da kəŋesəm fəp. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ta nəgbaymɛ nəcəmɛ mɛrəŋka mefəli darəŋ, ta nəlompəs sɔ canu ca fɛc. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kɔ nənde nəckɛr'em yoloŋnɛ ya kəpaŋnɛ pəforu-ɛ, nəloŋn'em yi pəmɔ tɔkɔ sariyɛ səloku ti mɔ, ntɛ tɔŋsɔŋɛ ibaŋ kəloŋnɛ konu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nəsɔm daka dadɔkɔ, dɔsɔk ndɛ nəŋloŋn'em mɔ kɔ dɔckɔsɔk, yɔkɔ yɛncəmɛ haŋ tataka ta maas mɔ, pacɔf yi. ");
INSERT INTO bsp_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kɔ fum wəlɔma ɔsɔm yeri yayɔkɔ tataka ta maas-ɛ, yeri yɔtɔsɔk yɔ, ifɔbaŋ kəloŋnɛ konu kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Fum nwɛ o nwɛ endi sɔ yeri yayɔkɔ mɔ, ɛŋsarɛ kiciya, bawo eyik-yikəs paka mpɛ ampusɛ MARIKI mɔ: Aŋwurɛ fum wəkakɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kɔ nənde nəctɛl nde antɔf ŋonu-ɛ, ta nədekɔ nəctɛl səbomp sa yokom yɔkɔ yeyi abɔf ŋonu cəsək mɔ, ta nədekɔ sɔ nəcluksərnɛ kəcgbɛtəs səbomp səkɔ nənatɔnəŋk dəkətɛl mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ta nəluksərnɛ sɔ kəpiməs yokom ya ŋgbɔŋkəlɔ ya wɛn yɔkɔ aŋsakəs-sakəs ŋi darenc mɔ, ta nəwɛtəs sɔ cəbɔkəlɛ ca yi. Nəsakərɛ yi atɔyɔ daka, kɔ acikəra. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ta nəkiyɛ, ta nwɛ o nwɛ pəyembər wɛnc, ta məyɔ kɔ cəmpənpən. ");
INSERT INTO bsp_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ta nədɛrəm yem disrɛ tewe tem, kɔ məyɔ ti-ɛ, məfulus tewe ta Kanu kam. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ta mədir wɛnc əm, ta məkiyɛ! Ta kəway ka fum nwɛ ɛmbəc'am mɔ kədir'am dəwaca haŋ dɔckɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ta mətolanɛ wətɔne pəlɛc, ta nəbocɛ sɔ wətɔnəŋk paka dɔpɔ mpɛ ɔŋkɔpət mɔ. Məmentər mɔyɔ mam disrɛ a məleləs im. MARIKI iyɔnɛ, Kanu kam. ");
INSERT INTO bsp_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ta nəcboc kiti pətɔlomp disrɛ: Ta məcəmɛnɛ wətɔyɔ daka, ta məbaŋɛ wəka daka, mba məbocɛ wɛnc əm kiti tɔkɔ sariyɛ səloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ta nəfor afum anu. Ta nəyemsɛnɛ wɛnc konu, yem nyɛ yɔŋkɔsɔŋɛ padif kɔ mɔ. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ta məmɛŋkərnɛ dɛbəkəc mɛcɛm-cɛmnɛ mɛlɛc ma wɛnc əm, ta mənesərnɛ kənal kɔ tɔkɔ teyi mɔ de! Ta mədesarsərnɛ kiciya tetɔn. ");
INSERT INTO bsp_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ta məluksɛ ayɛk, ta məmɛŋkərnɛ mɛtɛlɛ nnɔ awɛnc əm aŋa ŋayi mɔ. Məbɔtər wɛnc əm pəmɔ tɔkɔ məmbɔtərnɛ mɔ, MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Nəde nəcmɛŋkərnɛ sariyɛ sem: Ta məsɔŋɛ yɔcɔl mɛrəŋ yɛcɛcɛnɛ nyɛ yɔntɔyɔnɛ dokom din dayi mɔ. Ta nəbɔf abɔf ŋonu yɔbɔf nyɛ yɔntɔyɔnɛ yin yayi mɔ. Ta nəbɛrnɛ yamos nyɛ anɔŋkəl kədunɛ səbeŋa sa akotan kɔ sa kentəler mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Kɔ wərkun ɛfəntərər wəran wəcar nwɛ wərkun wəlɔma owurɛnɛ tetɔn kəfaŋ kənɛncɛ mɔ, kɔ pəyɔnɛ a antawurus fɛ wəran wəkakɔ, tamɛrəŋ ta antasak wəran wəkakɔ pəwur dacar pəkɔ yɛŋən-ɛ, wərkun wəkakɔ ɛfəntərər wəran wəcar wəkakɔ mɔ pəsɔŋ alamali. Mba afɔdif ŋa, bawo wəran wəkakɔ ɔsɔrɔyɔnɛ wəcar. ");
INSERT INTO bsp_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Wərkun wəkakɔ pəkenɛ MARIKI aŋkesiya ŋorkun nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ŋɔyɔnɛ poloŋnɛ pa kəlompəs ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Wəloŋnɛ pətubucnɛ kəsɔkəs wəkayi kiciya MARIKI fɔr kiriŋ teta kəlompəs ka kiciya kaŋkɔ ɔyɔ mɔ, MARIKI ɛŋŋaŋnɛnɛ kɔ kiciya kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kɔ nəndekɔbɛrɛ atɔf ŋa Kanaŋ nəlip kəbɔf ka tɔk yokom yedi fəp-ɛ, nəclɔm yokom ya tɔk yayɔkɔ amɔnɛ kədi haŋ meren maas, ta nədi yi. ");
INSERT INTO bsp_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Yokom ya tɔk yayɔkɔ yendekɔkom teren ta maŋkəlɛ mɔ fəp, nəde nəcpusɛ yi ina MARIKI, nəckɛr'em yi kəkorkoru disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Teren ta kəcamət, nəntam kədi yokom yayɔkɔ, nədekɔ nəcpim yi, yendela, yɔyɔnɛ yonu. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ta nəde nəcsɔm sɛm nyɛ mecir mayi mɔsɔrɔyi yi mɔ. Ta nəyɔ mes ma dure, ta nəgbal kəsənc. ");
INSERT INTO bsp_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ta nəfonnɛ cəfon cəkəsək ca domp donu, ta məfonnɛ kek cəsək. ");
INSERT INTO bsp_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ta nəpirintnɛ ca cəlɔm dəkata nyɛ kəbikɛ kəntɔnim mɔ, ta nəgbes-gbesinɛ sɔ dis teta kəbal ka fum wəfi. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ta nələsər delel da awut anu aran kəcɔŋəs ŋa kəcfəntərɛ-fəntərɛ kɔ arkun aŋɛ ŋantɔnɛncɛ ŋa mɔ, ta tedesɔŋɛ afum a dɔtɔf kəyi ka yamayama, ta tedesɔŋɛ ŋacyɔ mes mɛlɛc ma kəbut amera mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Nədekɔ nəcleləs dɔsɔk da kəŋesəm dem ndɛ o ndɛ, nəleləs sɔ kəfo kəsoku kem. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ta nəsɛp kəlok-loku kɔ mera ya afi. Ta nətɛn kəsɔŋnɛ kətɔsɔk tetaŋan. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Məde məcleləs abeki, məde məcsɔŋ wətem pəlel. Məmentər dəmɔyɔ mam a məleləs ina Kanu kam. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kɔ wəcikəra ender pəyi nu dacɔ atɔf ŋonu-ɛ, ta nədir kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nəsumpər wəcikəra kakɔ pəmɔ wɛnc konu. Nəbɔtər kɔ pəmɔ nənasərka. Nəccɛm-cɛmnɛ a nəna sɔ nənayɔnɛ acikəra atɔf ŋa Misira. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ta nəyɔ kətɔlomp nkɛ o nkɛ dəyotubucɛ yonu fəp. ");
INSERT INTO bsp_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Nəyɔ yotubcɛ yɛtəŋnɛnɛ. MARIKI iyɔnɛ, Kanu konu nkɛ kənawurɛnɛ nu atɔf ŋa Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Nəmɛŋkərnɛ sariyɛ sem kɔ mɔyɔ mokur mem fəp, nəde nəccəmɛ sɔ mi darəŋ. MARIKI iyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Məloku aka Yisrayel: Fum nwɛ o nwɛ, kəyɛfɛ wəka Yisrayel haŋ acikəra aŋɛ ŋayi nu dacɔ mɔ, ɔsɔŋ wan kɔn wəkin nnɔ kanu ka yem nkɛ aŋwe Molɛk mɔ, padif wəkayi. Aka Yisrayel ŋaca-cas kɔ masar. ");
INSERT INTO bsp_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ina sɔ iŋkafələr wəkayi fɔr, iwurɛ kɔ aka Yisrayel dacɔ, bawo ɔsɔŋ yuruya yɔn yin kanu ka yem nkɛ aŋwe Molɛk mɔ. Ti disrɛ, ɔsɔŋɛ aŋgbip ŋem ŋosoku kətɔsɔk, k'ofulus dosoku da tewe tem. ");
INSERT INTO bsp_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kɔ aka Yisrayel ŋamɛpɛ mes mamɔkɔ fɔr, ta ŋandif fum wəkakɔ ɔsɔŋ wan kɔn kanu ka yem nkɛ aŋwe Molɛk mɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ina MARIKI, iŋkafələr fum wəkayi fɔr kɔ aka kor kɔn disrɛ, iwurɛ ŋa aka Yisrayel dacɔ, nkɔn fum wəkakɔ kɔ akɔ ŋampaŋnɛ pəyamayama kəyek-yekəs ka kanu ka yem ka Molɛk kaŋkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Kɔ fum ɛsɛp kənəŋkɛnɛ kɔ afi kɔ pəyɔnɛ fɛ ti pəgbal kəsənc nkɛ o nkɛ nnɔ afi ŋayi mɔ, ŋampaŋnɛ pəyamayama kəyek-yekəs ka canu ca yem cacɔkɔ-ɛ, iŋkafələr wəkayi fɔr, iwurɛ kɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Nəpusnɛ fɔr yem kiriŋ, nəyɔnɛ afum acempi, bawo MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Nəde nəmɛŋkərnɛ sariyɛ sem, nəde nəccəmɛ sɔ si darəŋ. In'ɔyɔnɛ MARIKI, nwɛ ompus nu mɔ, nəyɔnɛ afum acempi. ");
INSERT INTO bsp_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Nwɛ o nwɛ ontolanɛ kas kɔ pəyɔnɛ fɛ ti, kɛrɛ pəlɛc mɔ, padif kɔ. Nkɔn ɛsarɛ teta defi dɔn sona gboŋ, bawo otolanɛ akombəra ɔn pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Kɔ fum oŋsumpər dalakɔ kɔ wəran wəlɔ kɔ tɔyɔnɛ wəran ka wɛnc wəlɔma ŋayi dalakɔ-ɛ, padif afum akakɔ mɛrəŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Kɔ wərkun ɛfəntərər wəran wəlɔma wəka kas-ɛ, ɛlapəs kas, padif mɛrəŋ maŋan fəp. Ŋasarɛ sɔ teta defi daŋan. ");
INSERT INTO bsp_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kɔ wərkun ɛfəntərər wəran ka wan kɔn wərkun-ɛ, padif afum akakɔ mɛrəŋ fəp. Dɛyamayama dɔpɔŋ dɔ: Ŋasarɛ sɔ teta defi daŋan. ");
INSERT INTO bsp_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kɔ wərkun ŋafəntərər wəkos wərkun pəmɔ tɔkɔ wərkun ɛŋfəntərɛ kɔ wəran mɔ, mɛrəŋ maŋan fəp ŋayɔ pəyikyik mpɛ MARIKI enter mɔ, padif ŋa mɛrəŋ maŋan fəp. Ŋasarɛ sɔ teta defi daŋan. ");
INSERT INTO bsp_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kɔ wərkun ɛnɛncɛ wan wəran kɔ kɛrɛ-ɛ, tes tɛlɛc ta kəbut amera tɔ. Pacɔf wərkun wəkakɔ, wan wəran kɔ kɛrɛ, ntɛ tɔŋsɔŋɛ ta tes ta kəbut amera tatɔkɔ tɔgbɔkərɛ sɔ kəyi nu dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kɔ wərkun ɛfəntərər pɔcɔl-ɛ, padif wərkun wəkakɔ, padif sɔ pɔcɔl papɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kɔ wəran ɛfəntərɛ kɔ pɔcɔl-ɛ, padif wəran wəkakɔ kɔ pɔcɔl papɔkɔ. Ŋasarɛ sɔ teta defi daŋan. ");
INSERT INTO bsp_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kɔ fum ɛnɛncɛ wəkirɛ kɔn nwɛ ŋampaŋnɛ kas kɔ pəyɔnɛ fɛ ti, nwɛ ŋampaŋnɛ kɛrɛ mɔ, ŋakɔ haŋ ŋafəntərɛ-ɛ, tɔyɔ ta malap tɔ ŋayɔ, pawurɛ ŋa fɔr ya awɛnc aŋa kiriŋ. Fum nwɛ ɛfəntərər wəkirɛ kɔn mɔ, ɛsarɛ kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kɔ wərkun ɛfəntərər wəran nwɛ eyi kənəŋk wəka darenc mɔ, aŋwurɛ mɛrəŋ maŋan fəp aka Yisrayel dacɔ, kəcərɛ mɛrəŋ maŋan fəp ŋatəŋnɛ kəfəntərɛ tɛm ntɛ wəran eyi kənəŋk wəka darenc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ta məfəntərər wɛnc wəran wəka iya kam, kɔ pəyɔnɛ fɛ ti wəkirɛ ka papa kam, bawo kəlapəs ka akombəra am kɔ. Aŋɛ ŋaŋyɔ ti mɔ, ŋaŋsarɛ kiciya kəŋan. ");
INSERT INTO bsp_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kɔ wərkun ɛfəntərər kɔncəra kɔn-ɛ, ŋalapəs wos ka wəkakɔ. Afum akakɔ mɛrəŋ ŋasarɛ kiciya kəŋan, ŋaŋfi ta ŋayɔ awut-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Kɔ fum ɛnɛncɛ wəran ka wɛnc-ɛ, tɔyɔ teyikyik tɔ. Afum akakɔ mɛrəŋ ŋafɔsɔtɔ awut, tamɛrəŋ wərkun wəkakɔ ɛlapəs wɛnc. ");
INSERT INTO bsp_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Nəmɛŋkərnɛ sariyɛ sem kɔ mɔyɔ mokur mem fəp, nəde nəcyɔ mi, ti tendesɔŋɛ atɔf nŋɛ iŋkekərɛ nu kəndɛ mɔ, ta atɔf ŋɛŋɛnc nu-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ta nədekɔ nəcyɔ mɔyɔ ma afum akɔ iŋkɔbɛləs nu fɔr kiriŋ mɔ de! Afum akakɔ kəcyɔ kəŋan mes mɛlɛc mamɔkɔ fəp kəsɔŋɛ k'inter ŋa. ");
INSERT INTO bsp_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mba inaloku nu: ‹Nən'endekɔlɛk antɔf ŋaŋan, ina yati endekɔsɔŋ nu ŋi, antɔf ŋoboŋu ŋɔ dalɛ kɔ awop. MARIKI iyɔnɛ, Kanu konu, in'ɛgbɛy nu kɔ afum alpəs aŋɛ.› ");
INSERT INTO bsp_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Itɔ pəmar nəcgbɛy sɛm yosoku kɔ yɔtɔsɔk, bɛmp yosoku kɔ yɔtɔsɔk, ntɛ tɔŋsɔŋɛ ta nəyik-yikəsnɛ teta sɛm yayɔkɔ yɔntɔsɔk mɔ. Sɛm, bɛmp, kɔ yɛfɛlər-fɛlər nyɛ yencepɛ-cepɛ nu dacɔ mɔ, iŋgbɛy yi ntɛ tɔŋsɔŋɛ nəcərɛ nyɛ yɔntɔsɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Nəyɔnɛ afum acempi apus nnɔ iyi mɔ, bawo ina MARIKI, incemp. Iŋgbɛy nu kɔ afum alpəs aŋɛ ntɛ tɔŋsɔŋɛ nəyɔnɛ akemi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Kɔ wərkun kɔ pəyɔnɛ fɛ ti, wəran wəlɔma ŋande kəclok-loku kɔ afi, kɔ pəyɔnɛ fɛ ti ŋacgbal kəsənc, paca-cas ŋa masar, padif. Ŋasarɛ sɔ teta defi daŋan.» ");
INSERT INTO bsp_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Kɔ MARIKI osom Musa: «Məloku awut arkun a Aruna, aloŋnɛ: Ta wəloŋnɛ pəsɔŋnɛ kətɔsɔk kəgbuŋɛnɛ kəbel ka fum, a ntɛ wəkakɔ ɔyɔnɛ wəka kusuŋka ka Lewy mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Mɛnɛ tɔyɔnɛ a fum kɔn pat ɔfɔ: Kɛrɛ, kas, wan kɔn wərkun, wan kɔn wəran, wɛnc. ");
INSERT INTO bsp_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Kɔ pəyɔnɛ wəkirɛ kɔn wətɔlɔ ɔfɔ-ɛ, aŋwosɛ kɔ kətɔsɔk tetɔn. Wəkirɛ, wəka kəlɔ kəŋan disrɛ ɔfɔ, bawo wəloŋnɛ ɛntasɔŋ fɛ kɔ wərkun kəlɔ kəcuru disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Wəloŋnɛ wəkiriŋ ka afum ɔyɔnɛ, pəmar fɛ pəsɔŋɛnɛ kətɔsɔk pəfulusnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ta aloŋnɛ ŋafonnɛ səbomp mofo mɔlɔma, ta ŋafonnɛ cek cəsək, ta ŋagbes-gbesinɛ dis. ");
INSERT INTO bsp_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ŋayɔnɛ aŋɛ ampusɛ Kanu kəŋan mɔ, ta ŋafulus tewe ta Kanu kəŋan, bawo ŋa ŋaŋkɛr'em yoloŋnɛ nyɛ ancɔfɛ ina MARIKI mɔ, yeri ya Kanu kəŋan. Itɔ pəmar ŋayɔnɛ afum acempi aŋɛ ampus'em mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ta aloŋnɛ ŋacnɛncɛ aran ayi yamayama, kɔ pəyɔnɛ fɛ ti, wəran nwɛ aŋləsər kəfac mɔ, kɔ pəyɔnɛ fɛ ti, wəran nwɛ ŋasakɛnɛ kɔ wos mɔ, bawo wəloŋnɛ wərkun ɔfɔ, nwɛ ampusɛ Kanu kɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Məna wəka Yisrayel nwɛ o nwɛ məde məcleləs wəloŋnɛ, bawo nkɔn ɛŋkɛrɛ yeri nyɛ nəŋsɔŋ ina Kanu konu mɔ. Aloŋnɛ ŋade ŋayɔnɛ afum apus nnɔ nəyi mɔ, bawo ina MARIKI incemp, k'iyɛk-yɛk aka Yisrayel ntɛ tɔŋsɔŋɛ ŋayɔnɛ afum acempi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kɔ wan wəran ka wəloŋnɛ ofulusnɛ pəyi yamayama-ɛ, kas wəloŋnɛ ofulus: Pacɔf wan wəran wəkakɔ pəyi wəyeŋ.» ");
INSERT INTO bsp_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Wəloŋnɛ wəpɔŋ ɔyɔnɛ wəkiriŋ ka awɛnc aŋa aloŋnɛ: Nkɔn nwɛ anabɔy moro dəromp, padəs kɔ dekiriŋ da kəloŋnɛ, pabɛr kɔ yamos ya dəKanu mɔ, ta pəsaktinɛ cəfon, ta pəwal-wali yamos yɔn teta defi. ");
INSERT INTO bsp_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ta wəloŋnɛ wəpɔŋ pəkɔ defi da nwɛ o nwɛ, ta pəsɔŋɛnɛ kətɔsɔk, ali tɔyɔnɛ a kas, kɔ pəyɔnɛ fɛ ti kɛrɛ efi-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ta pəyɛfɛ nde kəfo kəsoku, ta pədefulus kəfo kəsoku ka Kanu kɔn, bawo kəbɔy kɔn moro ma dəKanu kənapus kɔ aloŋnɛ dacɔ. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Wəloŋnɛ wəpɔŋ pənɛncɛ wəran nwɛ antɔləsər kəfac mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ta pənasər wəcəbokəra, ta pənɛncɛ wəran nwɛ ŋasakɛnɛ kɔ wos mɔ, ta pənɛncɛ wəran nwɛ ofulusnɛ pəyi yamayama mɔ. Pəlɛk wəran akomɛnɛ ɔn dacɔ nwɛ antɔləsər kəfac mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ntɛ tɔŋsɔŋɛ ŋa kətɔgbuluŋ awut nde dokom daŋan, ŋayɔnɛ afum acempi, asoku pɛs mɔ. In'ɔyɔnɛ MARIKI mmɛ mompus ŋa yɛbəc yem mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Məloku Aruna: Yuruya yam fəp dɛtɛmp kɔ dɛtɛmp, nwɛ o nwɛ ɔŋyɔ dolokəp dəris mɔ, ta pəlɔtərnɛ tetek toloŋnɛ kəsɔŋ ina Kanu kɔn peri. ");
INSERT INTO bsp_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Fum nwɛ o nwɛ ɔyɔ dolokəp kəfo kəlɔma dəris, ta pəlɔtərn'em: Kəyɛfɛ wətɔnəŋk, fum nwɛ ɛntəmbələr mɔ, fum nwɛ ɔyɔ dolokəp dəkəro mɔ, kɔ pəyɔnɛ fɛ ti, dis dɔn dɛlɛcɛ kəfo kəlɔma mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","fum nwɛ ɛntɛpɛ kəca kɔ pəyɔnɛ fɛ ti, kəcək mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","fum wəka kəndɛŋk, kɔ pəyɔnɛ fɛ ti, fum wəkələc, fum nwɛ ɔyɔ tɛsɛŋk dərɔfɔr mɔ, wəka yatərɛ, wəka amɔncɔ, wərkun nwɛ antɛmp cɔkəl mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ali wəkin yuruya ya Aruna wəloŋnɛ dacɔ nwɛ ɔyɔ dolokəp mɔ, ta pəlɔtərnɛ tetek tem toloŋnɛ kəkɛr'em yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ. Nwɛ ɔyɔ dolokəp mɔ, ɔfɔlɔtərnɛ kəsɔŋ Kanu kɔn yeri. ");
INSERT INTO bsp_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mba wəkayi ɛntam kədi yeri ya Kanu kɔn, yoloŋnɛ yosoku kɔ nyɛ ampus’em mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mba ta wəloŋnɛ wəyɔ dolokəp pəbəp kəloto kəkəŋkɛ, ta wəkayi pəlɔtərnɛ sɔ tetek toloŋnɛ Kanu, bawo ɔyɔ dolokəp. Ta pəfulus mofo mem mosoku, ina MARIKI impus mi.» ");
INSERT INTO bsp_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Kɔ Musa oloku Aruna moloku mmɛ, kɔ awut ɔn kɔ aka Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Məlɔmər Aruna kɔ awut ɔn mes mmɛ aŋmɔnɛ ŋa kədi yoloŋnɛ nyɛ aka Yisrayel ŋande ŋacpus'em mɔ, ntɛ tɔŋsɔŋɛ ta ŋafulus tewe ta dosoku dem mɔ. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Məloku ŋa: Yuruya ya aloŋnɛ fəp dacɔ, wərkun nwɛ o nwɛ ɔlɔtərnɛ yoloŋnɛ yosoku nyɛ aka Yisrayel ŋampusɛ MARIKI mɔ, ta wəkayi ɔsɔk-ɛ, aŋwurɛ wərkun wəkakɔ yɛbəc yem. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Wərkun nwɛ o nwɛ yuruya ya Aruna dacɔ docu da akata dɛcalərnɛ dosumpər kɔ, kɔ pəyɔnɛ fɛ ti, wəkayi domun dɛcgbələr dəkəsɔtɛ dɔn ta pəyɔnɛ mɔsɔtɛ-ɛ, ta pədi yoloŋnɛ yosoku ya MARIKI, haŋ pəcsɔk. Tin tayi tɔ kɔ nwɛ ɔntɔsɔk bawo oŋgbuŋsərɛnɛ wəfi, kɔ nwɛ domun d’arkun dendewur, ");
INSERT INTO bsp_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kɔ nwɛ oŋgbuŋsərɛnɛ yɛliŋɛ-liŋɛ yɔtɔsɔk kɔ pəyɔnɛ fɛ ti fum nwɛ kəgbuŋsərɛnɛ kɔn kəŋsɔŋɛ fum kətɔsɔk mɔ, tɔyɔnɛ kətɔsɔk ka fum wəkakɔ nkɛ o nkɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Nwɛ o nwɛ ogbuŋsərɛnɛ paka pɔtɔsɔk, wəkayi ɔsɔk fɛ haŋ dec dɛkalɛ, ta fum wəkakɔ pədi yeri ya yoloŋnɛ yosoku, mɛnɛ wəkayi pəbikɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Dec dɔnckɔnakalɛ wəkayi pəsɔk oŋ, ɛntam kədi sɔ yeri yosoku ya kəloŋnɛ, yeri yɔn yɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ta wəloŋnɛ pəsɔm wɛsɛm nwɛ antɔfay mɔ, kɔ pəyɔnɛ fɛ ti, pɔcɔl mpɛ wɛsɛm wɔlɔma wendif mɔ, tɔŋsɔŋɛ kɔ kətɔsɔk. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Aloŋnɛ ŋandemɛŋkərnɛ sariyɛ sa yɛbəc yem, ta ŋasarɛ kiciya ka kəfulus yeri nyɛ ampusɛ MARIKI mɔ. Kɔ ŋantɔleləs teta yeri yayɔkɔ tɔŋsɔŋɛ ŋa kəfi. Ina MARIKI, in'ompus ŋa. ");
INSERT INTO bsp_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ta nwɛ o nwɛ wətɔyɔnɛ dokom da aloŋnɛ pədi yeri yosoku ya kəloŋnɛ. Kəyɛfɛ wəcikəra wəcepər kəbəp ka wəbəcɛ ka wəloŋnɛ nwɛ ɔŋsɔŋ kəway mɔ, ali wəkin ta pədi yeri yosoku yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mba wəcar nwɛ wəloŋnɛ ɛnawayɛ pəsam pɔn mɔ, ɛntam kədi yi, kɔ fum nwɛ aŋkom kəlɔ kɔn disrɛ mɔ, ŋantam kədi yeri yopus ya kəloŋnɛ yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kɔ wətɔyɔnɛ wəloŋnɛ ɛnɛncɛ wan wəran wəka wəloŋnɛ, ta wəran wəkakɔ pədi sɔ yeri yosoku ya kəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Wan wəran ka wəloŋnɛ nwɛ ɔntɔkom a wos pəfi, kɔ pəyɔnɛ fɛ ti, ŋasakɛnɛ kɔ wos, pəlukus pəde pəndɛ kəlɔ ka kas pəmɔ tɔkɔ ɛnayi di ntɛ ɛnatɔlɔ mɔ, ɛntam kədi sɔ yeri ya kas. Mba ta wətɔyɔnɛ yuruya ya aloŋnɛ nwɛ o nwɛ pədi yeri yosoku yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Kɔ fum wəlɔma, kətɔyɛfɛnɛ disrɛ endi peri mpɛ ampusɛ MARIKI mɔ-ɛ, wəkayi pəsɔŋ wəloŋnɛ pɛtəŋnɛnɛ pa yeri yosoku yɔkɔ endi mɔ, pəkafəlɛ sɔ pədeŋər alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ta aloŋnɛ ŋafulus yoloŋnɛ ya aka Yisrayel nyɛ ŋande ŋacbelər yoloŋnɛ nyɛ ŋampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Kɔ aloŋnɛ ŋandi yeri yayɔkɔ ta ŋasɔk-ɛ, ŋaŋsɔŋɛ aka Yisrayel kəsarɛ kiciya nkɛ pəmar ŋaŋsɔŋɛ alamali mɔ. In'ɔyɔnɛ MARIKI nwɛ ompus yoloŋnɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Məloku Aruna kɔ awut ɔn kɔ aka Yisrayel fəp: Fum nwɛ o nwɛ wəka kəlɔ ka Yisrayel kɔ pəyɔnɛ fɛ ti wəcikəra wəcepərɛnɛ tɛm aka Yisrayel dacɔ edekenɛ MARIKI kəloŋnɛ ka poloŋnɛ pɔcɔf: Tɔyɔnɛ teta kədɛrəm nkɛ o nkɛ kɔ pəyɔnɛ fɛ ti, teta kəloŋnɛ ka kəpocɛ abəkəc ŋosoku pɛs fəp, ");
INSERT INTO bsp_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kɔ wəkayi ɛfaŋ a ibaŋ kəloŋnɛ kɔn-ɛ, pəloŋn'em pɔcɔl porkun mpɛ pɔntɔyɔ dolokəp mɔ, tɔyɔnɛ tura, aŋkesiya, ambiyofo. ");
INSERT INTO bsp_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ta nəkɛr'em pɔcɔl mpɛ pɔyɔ dolokəp mɔ, ifɔbaŋ kəloŋnɛ konu kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kɔ fum endekenɛ MARIKI wana, aŋkesiya, kɔ pəyɔnɛ fɛ ti wir teta kəloŋnɛ ka kəpaŋnɛ pəforu kɔ pəyɔnɛ fɛ ti teta kədɛrəm kɔn kɔ pəyɔnɛ fɛ ti teta kəpocɛ abəkəc ŋosoku pɛs-ɛ, iŋwosɛ kəbaŋ ka kəloŋnɛ kaŋkɔ, kɔ tɔyɔnɛ pɔcɔl papɔkɔ pɔyɔ fɛ dolokəp-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ta nəkenɛ MARIKI pɔcɔl pɔtɔnəŋk, pɔcɔl mpɛ ambopər kɔ pəyɔnɛ fɛ ti, pɔcɔl mpɛ aŋgbinti kəcək mɔ, mpɛ pɔŋgbɔtəlɛ-gbɔtəlɛ cəfon mɔ, pɔcɔl mpɛ pɔyɔ yatərɛ mɔ, kɔ pəyɔnɛ fɛ ti amanta kɔ pəyɔnɛ fɛ ti docu da akata dɔlɔma mɔ. Ta nəkekərɛ pi teta kəloŋnɛ nkɛ ancɔfɛ MARIKI nde dətetek toloŋnɛ kəroŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Məntam kəken'em kəloŋnɛ ka kəpocɛ abəkəc ŋosoku pɛs: Wana, aŋkesiya, wir nwɛ wɔyɔ kəcək kɔ pəyɔnɛ fɛ ti kəca kəbɔl kətas kəŋkɔ mɔ, mba ifɔbaŋ yayɔkɔ teta kəlas ka kədɛrəm konu. ");
INSERT INTO bsp_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ta nəkɛrɛ ina MARIKI pɔcɔl mpɛ antɛmp, mpɛ amporu-poru, mpɛ awurɛ cɔkəl kɔ pəyɔnɛ fɛ ti, pɔcɔl mpɛ ancopu arit mɔ. Ta nədekɔ nəcyɔ yɔcɔl yonu tatɔkɔ nde atɔf ŋonu. ");
INSERT INTO bsp_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ta nəway acikəra dəwaca yɔcɔl yɔkɔ aŋgbinti dis mofo mɔlɔma mɔ, kədeloŋnɛ ina Kanu konu. Kəgbinti dis da pɔcɔl papɔkɔ dɔsɔŋɛ pi kəyɔ dolokəp. Ifɔbaŋ pi kəloŋnɛ konu.» ");
INSERT INTO bsp_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Kəyɛfɛ tura, aŋkesiya ŋorkun, ambiyofo, k'aŋkom yi-ɛ, wan pəyi kɛrɛ dəntɔf haŋ mata camət-mɛrəŋ. Kəyɛfɛ oŋ tataka ta camət-maas ta pɔcɔl papɔkɔ, iŋwosɛ pi kəbaŋ teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ta nəfay pɔcɔl pɛran kɔ wan ka pi dɔsɔk din dayi, tɔyɔnɛ wana, aŋkesiya kɔ wir. ");
INSERT INTO bsp_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kɔ nəndeloŋnɛ MARIKI teta kəyif kɔn barka-ɛ, nəcəmɛ sariyɛ sa kəloŋnɛ ntɛ tɔŋsɔŋɛ pəbaŋ ki mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nəsɔm sɛm yayɔkɔ dɔsɔk da kəloŋnɛ dadɔkɔ, ali pin ta nəsak pa dɔckɔsɔk. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Nəmɛŋkərnɛ mosom mem, nəde nəcyɔ mi. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ta nəfulus dosoku dem, ntɛ tɔŋsɔŋɛ aka Yisrayel ŋaleləs dosoku dem mɔ. In'ɔyɔnɛ MARIKI nwɛ ompus nu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Inawurɛnɛ nu atɔf ŋa Misira ntɛ tɔŋsɔŋɛ ide iyɔnɛ Kanu konu mɔ. MARIKI iyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Məloku aka Yisrayel: Cəsata ca kəyek-yekəs MARIKI ncɛ nənde nəcwe kəloŋkanɛ ka aka Yisrayel fəp mɔ, kəloŋkanɛ kəsoku kənde kəcyi. Mataka ma cəsata cacɔkɔ mɔ mamɛ: ");
INSERT INTO bsp_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Mataka camət-tin ma tataka toluksər disrɛ fəp aŋwosɛ nu kəbəc, mba tataka ta camət-mɛrəŋ simiti, dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ dɔ, kəloŋkanɛ kəsoku kɔ, tetem. Ali tɛbəc tin ta nəsumpər dɔsɔk da kəŋesəm dadɔkɔ, dɔsɔk deleləs MARIKI dɔ nnɔ o nnɔ nəndeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Cəsata ca kəyek-yekəs MARIKI ncɛ cɔ nənde nəcwenɛ kəloŋkanɛ kəsoku ka aka Yisrayel tɛm ntɛ ambonc mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Kɔ MARIKI osom Musa: «Tataka ta wəco kɔ maŋkəlɛ ta ŋof ŋɔcɔkɔ-cɔkɔ ŋa teren, dec dɔrɔfɔy, nəbocɛ MARIKI kəsata ka Kəcepər. ");
INSERT INTO bsp_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Tataka ta wəco kɔ kəcamət (15) ta ŋof ŋaŋɔkɔ, nəde nəcbocɛ MARIKI kəsata ka Cəcom cətɔnɔŋkəl lebin. Nəde nəcsɔm cəcom cətɔnɔŋkəl lebin mata camət-mɛrəŋ camcam. ");
INSERT INTO bsp_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Tataka tɔcɔkɔ-cɔkɔ ta tataka toluksər tayi, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Nəckɛrɛ yoloŋnɛ yɔkɔ ancɔfɛ MARIKI mɔ, dɔsɔk o dɔsɔk, mata camət-mɛrəŋ disrɛ. Tataka ta camət-mɛrəŋ, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Məloku aka Yisrayel: Kɔ nəndekɔbɛrɛ atɔf ŋonu nŋɛ isɔŋ nu mɔ, kɔ nəndekɔ nəctɛl-ɛ, nədekɔ nəckenɛ wəloŋnɛ asek ŋɔcɔkɔ-cɔkɔ ŋa yɛtɛl yonu yɔcɔkɔ-cɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Wəloŋnɛ nkɔn ɔŋkɔtubucnɛ kəsɔŋ yi MARIKI fɔr kiriŋ, ntɛ tɔŋsɔŋɛ pəbaŋ yi mɔ. Wəloŋnɛ ontubucnɛ ŋi kəsɔŋ dɔckɔsɔk da kəŋesəm. ");
INSERT INTO bsp_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Dɔsɔk ndɛ nəntubucnɛ kəsɔŋ asek ŋa yɛtɛl yayɔkɔ mɔ, idɔ nəkenɛ MARIKI aŋkesiya ŋorkun ŋa teren tin nŋɛ ŋɔntɔyɔ dolokəp mɔ teta poloŋnɛ pɔcɔf. ");
INSERT INTO bsp_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Nədeŋər kəloŋnɛ ka mɛŋgbɛn kilo camət-tin ka kəmbefe kətɔt nkɛ anɔktərɛnɛ kɔ moro mɔ. Nədeŋər sɔ wɛn litɛr din kɔ dacɔ, nəcɔfɛ yi MARIKI. Kəloŋnɛ kɔ, nkɛ ambɔnc ŋa ki ŋontorɛ-torɛ MARIKI abəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Nəfɔdi ali pokom pa yɛtɛl yayɔkɔ kəyɛfɛ kəcom, mɛŋgbɛn mɛnɛkət, mɛŋgbɛn mofu, ali pin ta nədi, ta nəntakenɛ Kanu konu sek yɔcɔkɔ-cɔkɔ ya yɛtɛl yonu-ɛ. Tɔyɔnɛ nu sariyɛ sa doru o doru, dɛtɛmp kɔ dɛtɛmp donu, nnɔ o nnɔ nəndeyi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Kɔ MARIKI osom sɔ Musa: «Kəyɛfɛ ka dɔsɔk ndɛ nəŋkɛrɛ sek ya yɛtɛl yonu nyɛ antubucnɛ kəsɔŋ mɔ, kəyɛfɛ dɔckɔsɔk da kəŋesəm dadɔkɔ, nəde nəclɔm mataka moluksər camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Nəde nəclɔm mata wəco kəcamət, haŋ dɔckɔsɔk da dɔsɔk da kəŋesəm da camət-mɛrəŋ, nəkenɛ sɔ MARIKI kəloŋnɛ ka mɛŋgbɛn mofu. ");
INSERT INTO bsp_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kəyɛfɛ nde dəkiyi donu, nəde nəckɛrɛ cəcom mɛrəŋ kədetubucnɛ kəsɔŋ ci MARIKI. Kəcom o kəcom pəmar palompsɛ ki kəmbefe kətɔt kilo kəmaas panɔŋkəl ki lebin pakakəl. Cəcom cɔ ncɛ aŋlompsɛ MARIKI yɛtɛl yɔcɔkɔ-cɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Nədeŋər kəloŋnɛ ka kəcom kaŋkɔ: Ŋkesiya yorkun camət-mɛrəŋ ya teren tin tin nyɛ yɔntɔyɔ dolokəp mɔ, tura tin, ŋkesiya yorkun mɛrəŋ, nəcɔf'em yi nde dətetek toloŋnɛ kəroŋ nədeŋər sɔ yoloŋnɛ ya mɛŋgbɛn kɔ wɛn wa yi. Yoloŋnɛ yɔ nyɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa yi ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kɔ tatɔkɔ tencepər-ɛ, nəkɛrɛ MARIKI ambiyofo ŋin teta kəloŋnɛ ka kiciya, kɔ ŋkesiya yorkun mɛrəŋ ya teren tin teta kəloŋnɛ ka kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Wəloŋnɛ pətubucnɛ kəsɔŋ yi fɔr ya MARIKI kiriŋ, kəlɛkɛnɛ ka cəcom cəcɔkɔ-cɔkɔ ncɛ antubucnɛ kəsɔŋ kɔ ŋkesiya yayɔkɔ mɛrəŋ: Yeri yopus ya MARIKI yɔ, wəloŋnɛ ɔyɔ yi. ");
INSERT INTO bsp_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Dɔsɔk dadɔkɔ yati, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs im, ta nəbəc yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. Tɔyɔnɛ nu sariyɛ sa doru o doru, dɛtɛmp kɔ dɛtɛmp donu, nnɔ o nnɔ nəndeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kɔ nənde nəctɛl nde antɔf ŋonu-ɛ, ta nəde nəctɛl cəsək ca cəbɔf conu, ta nəluksərnɛ sɔ kəgbɛtəs ka səbomp nsɛ nəmpələs tadarəŋ tonu mɔ, nəsakərɛ sasɔkɔ wətɔyɔ daka kɔ wəcikəra. MARIKI iyɔnɛ, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Məloku aka Yisrayel: Dɔsɔk dɔcɔkɔ-cɔkɔ da ŋof ŋa camət-mɛrəŋ dɔyɔnɛ nu dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ, dɔsɔk dɛcɛm-cɛməs kɔ dofula luk. Nəde nəcwe kəloŋkanɛ kəsoku tewe tem. ");
INSERT INTO bsp_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ, mba nəkɛrɛ MARIKI yoloŋnɛ nyɛ ancɔfɛ kɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Tataka ta wəco ta ŋof ŋa camət-mɛrəŋ, dɔsɔk dɔpɔŋ da Kəsɔkəs ka kiciya dɔ. Dɔsɔk dadɔkɔ kəloŋkanɛ kəsoku kɔ, teta kəleləs im. Nəsuŋ dɔsɔk dadɔkɔ, nəkɛrɛ MARIKI yoloŋnɛ nyɛ ancɔfɛ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ta nəsumpər tɛbəc o tɛbəc dɔsɔk dadɔkɔ, bawo dɔsɔk da Kəsɔkəs ka kiciya dɔ, dɔsɔk dotubucnɛ kəsɔkəs nu kiciya konu fɔr ya MARIKI kiriŋ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Nwɛ o nwɛ ɛdɛncəs kəsuŋ dɔsɔk dadɔkɔ mɔ, aŋwurɛ kɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Nwɛ o nwɛ oŋsumpur yɛbəc dɔsɔk dadɔkɔ mɔ, ina yati iŋmələk kɔ afum ɔn dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ali tɛbəc ta nəsumpur dɔsɔk dadɔkɔ. Sariyɛ sa doru o doru sɔ dɛtɛmp o dɛtɛmp, nnɔ o nnɔ nəndeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Dɔsɔk dadɔkɔ dɔyɔnɛ nu dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ, nəsuŋ tatɔkɔ ta camət-maŋkəlɛ ta ŋof, nəŋesəm kəyɛfɛ dɔfɔy haŋ dɔckɔsɔk dɔfɔy.» ");
INSERT INTO bsp_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Məloku aka Yisrayel: Tataka ta wəco kɔ kəcamət ta ŋof ŋa camət-mɛrəŋ, pabocɛ MARIKI kəsata ka Cəlɛŋgbɛ, haŋ mataka camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Tataka tɔcɔkɔ-cɔkɔ, kəloŋkanɛ kəsoku kɔ, teta kəleləs im. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Dɔsɔk o dɔsɔk mata camət-mɛrəŋ mamɔkɔ disrɛ, nəckenɛ MARIKI yoloŋnɛ nyɛ andecɔfɛ kɔ mɔ. Tataka ta camət-maas, kəloŋkanɛ kəsoku kɔ, teta kəleləs im. Nəkɛrɛ ina MARIKI yoloŋnɛ nyɛ andecɔf'em mɔ. Kəloŋkanɛ kəlpəs ka kəsata kaŋkɛ kɔ, ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Cəsata cancɛ cɔ nəcboc teta kəleləs ka MARIKI, nəde nəcwe kəloŋkanɛ kəsoku nkɛ nəde nəckɛrɛ MARIKI yoloŋnɛ nyɛ ande paccɔfɛ kɔ nde dətetek toloŋnɛ Kanu kəroŋ mɔ, yoloŋnɛ ya mɛŋgbɛn, yoloŋnɛ ya kəpaŋnɛ pəforu kɔ yoloŋnɛ ya wɛn wa yi, pəmɔ tɔkɔ pəmar paloŋnɛ dɔsɔk ndɛ o ndɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Yoloŋnɛ yayɔkɔ y'ande pacdeŋər yoloŋnɛ ya dɔsɔk da kəŋesəm fəp ndɛ ampusɛ MARIKI mɔ, kəyɛfɛ ka yopocɛ yonu, yoloŋnɛ ya kədɛrəm yonu haŋ yoloŋnɛ yopocɛ yonu nyɛ nəŋsɔŋ MARIKI bəkəc yosoku pɛs mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Teta kəsata ka cəlɛŋgbɛ, tataka ta wəco kɔ kəcamət yati ta ŋof ŋa camət-mɛrəŋ, kɔ kətɛl ka yɔbɔf yonu kəlip-ɛ, nədekɔ nəcboc kəsata ka MARIKI mata camət-mɛrəŋ disrɛ. Tataka tɔcɔkɔ-cɔkɔ kɔ tataka ta camət-maas ta kəsata kaŋkɔ, mataka meŋesəm mmɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Tataka tɔcɔkɔ-cɔkɔ, nəlɛk yokom yɔtɔt ya tɔk yokom yonu, bat ya komp, wara wa tɔk yɔyɔ bɔpər kɔ cəŋkɔlma ca dəromun, nəwoləs-woləs ina MARIKI Kanu konu fɔr kiriŋ mata camət-mɛrəŋ mamɔkɔ fəp disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kəren o kəren nəde nəcbocɛ ina MARIKI kəsata mata camət-mɛrəŋ, ŋof ŋa camət-mɛrəŋ ŋa teren o teren disrɛ. Tede tɔyɔnɛ nu sariyɛ sa doru o doru, dɛtɛmp kɔ dɛtɛmp. ");
INSERT INTO bsp_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Akom aka Yisrayel fəp ŋade ŋacyi cəlɛŋgbɛ disrɛ mata camət-mɛrəŋ, ");
INSERT INTO bsp_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ntɛ tɔŋsɔŋɛ yuruya yonu yedecərɛ a inayinɛ aka Yisrayel dəcəlɛŋgbɛ ntɛ inawurɛnɛ ŋa atɔf ŋa Misira mɔ. MARIKI iyɔnɛ, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Tatɔkɔ tɔ Musa ɛnalɔmər aka Yisrayel cəsata ca kəloŋkanɛ kəyek-yekəs MARIKI. ");
INSERT INTO bsp_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Məsom aka Yisrayel ŋakɛr'am moro mɔtɔt ma olif mɔfɔc, ntɛ tɔŋsɔŋɛ səlamp səctam kəmar dɔfɔy o dɔfɔy mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aruna pəccəmbər pɛdɛtɛ səlamp nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu nde todoru ta kəloto kəkəŋkɛ kaŋkəra nkɛ kəmentər danapa dem k'aka Yisrayel, ntɛ tɔŋsɔŋɛ səcmar tɛm fəp MARIKI fɔr kiriŋ kəyɛfɛ dɔfɔy haŋ bətbət mɔ. Tede tɔyɔnɛ nu sariyɛ sa doru o doru, dɛtɛmp o dɛtɛmp deleləs si. ");
INSERT INTO bsp_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aruna pədekɔ pəccəmbər səlamp pɛdɛtɛ pa səlamp pa kɛma kəsoku pɛs, ntɛ tɔŋsɔŋɛ səcmar tɛm fəp MARIKI fɔr kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Məlɛk kəmbefe kətɔt, məkakəl cəcom cəlok-lok wəco kɔ mɛrəŋ, palompsɛ kəcom nkɛ o nkɛ kəmbefe kilo camət-tin. ");
INSERT INTO bsp_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Nəboc ci fɔr ya MARIKI kiriŋ nde amɛsa ŋa kɛma kəsoku pɛs, cəgba mɛrəŋ. Kəgba o kəgba pacɛk ki cəcom camət-tin. ");
INSERT INTO bsp_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kəgba o kəgba məboc ki suray sətɔt sa kəlɔl ka kətɔk, nsɛ andecɔfɛ ina MARIKI dəkəcəmɛ da cəcom teta kəcɛm-cɛməs mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Dɔsɔk o dɔsɔk deŋesəm ndɛ ampusɛ MARIKI mɔ, paboc'em cəcom cacɔkɔ ntɛ tɔŋsɔŋɛ cəde cəcyi MARIKI fɔr kiriŋ tɛm fəp mɔ. Dəcəcom ca aka Yisrayel nənde nəcbelər ci, danapa da doru o doru dɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Cəcom cacɔkɔ, ca Aruna kɔ yuruya yɔn cɔ, ŋade ŋacsɔm ci kəfo kəsoku: Yede yɔyɔnɛ ŋa yeri yosoku nyɛ ambelər yoloŋnɛ nyɛ ampusɛ MARIKI kəcɔfɛ kɔ mɔ dacɔ. Tede tɔyɔnɛ nu sariyɛ sa doru o doru.» ");
INSERT INTO bsp_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Dɔsɔk dɔlɔma, wərok wəYisrayel wəlɔma kas pəyɔnɛ wəMisira, pacwe kɛrɛ Selomit wan wəran wəka Dibri wəka kusuŋka ka Dan. Kɔ wərok nwɛ, ɔŋkɔ aYisrayel dacɔ k'ɔŋkɔ pəyektər wəka Yisrayel wəlɔma kəyɛfərɛnɛ dəndo dəsaŋka. Kɔ wərok nwɛ ɔlɔməs MARIKI pəcbonc tewe tɔn, k'ontolanɛ kɔ pəlɛc. K'asumpər wan wəkakɔ k'aŋkenɛ kɔ Musa. ");
INSERT INTO bsp_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","K'aŋkɔ pacaŋər kɔ, packar MARIKI kəloku tɔkɔ andeyɔ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Nəwurɛnɛ wan wəkawɛ ɔlɔməs im mɔ saŋka disrɛ! Aŋɛ ŋane kɔ dim mɔ fəp, ŋadeŋər kɔ waca dəromp, ntɛ tɔŋsɔŋɛ afum fəp ŋacərɛ a fum wəkawɛ ɛsarɛ kəciya mɔ, kɔ telip-ɛ, kəloŋkanɛ ka aka Yisrayel fəp ŋaca-casɛ kɔ masar. ");
INSERT INTO bsp_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ntɛ tɔ məŋkɔloku aka Yisrayel: Məna nwɛ o nwɛ məntolanɛ Kanu kam pəlɛc mɔ, məsarɛ kiciya kam. ");
INSERT INTO bsp_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Nwɛ o nwɛ ɛŋfər-fərəs tewe ta MARIKI mɔ, padif kɔ: Kəloŋkanɛ ka Yisrayel fəp ŋanca-casɛ wəkayi masar ŋadif. Wəkayi, pəyɔnɛ wəka Yisrayel, pəyɔnɛ wəcikəra, andif wəkayi teta ntɛ ɔlɔməs tewe ta Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Nwɛ o nwɛ oŋsut fum pədif kɔ mɔ, mɛnɛ padif wəkayi. ");
INSERT INTO bsp_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Nwɛ o nwɛ osut pɔcɔl pa wɛnc pədif pi mɔ, pəsɔŋ pɔlɔma peyi wəyeŋ kəway ka pɔkɔ endif mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kɔ fum ombopər fum wəlɔma-ɛ, pabopər sɔ wəkayi, pəmɔ kəbopər kəŋkɔ ombopər wɛnc mɔ: ");
INSERT INTO bsp_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kəway ka kətepi kəyɔnɛ kətepi, dɔfɔr dɔyɔnɛ kəway ka dɔfɔr, desek dɔyɔnɛ kəway ka desek. Dolokəp dɔkɔ ɔŋyɔ wɛnc mɔ, idɔ aŋluksɛ kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Nwɛ oŋsut pɔcɔl pədif mɔ, pəluksɛ kəway ka pi, pɔcɔl peyi wəyeŋ, mba k'osut fum pədif-ɛ, mɛnɛ padif kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kiti kin kayi kɔ kəyɛfɛ wəcikəra kəbəp wəka Yisrayel: MARIKI iyɔnɛ, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Kɔ Musa oloku moloku mamɔkɔ aka Yisrayel, k'awurɛnɛ wəkakɔ ɛnatolanɛ tewe ta Kanu pəlɛc mɔ, saŋka tadarəŋ k'aŋkɔ paca-cas kɔ masar. Kɔ aka Yisrayel ŋayɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Kɔ MARIKI osom Musa nde tɔrɔ ta Sinayi: ");
INSERT INTO bsp_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Məloku aka Yisrayel: Kɔ nəndekɔbɛrɛ atɔf nŋɛ iyi kəsɔŋ nu mɔ, nəce antɔf ŋonu ŋaŋɔkɔ ŋeŋesəm pipic, teta kəleləs ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Meren camət-tin disrɛ, nəntam kəcbɔf nde cəbɔf conu, nəcɛpəs wara wa ŋgbɔŋkəlɔ ya wɛn yonu, nəcpim yokom ya yi. ");
INSERT INTO bsp_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mba teren ta camət-mɛrəŋ, teren camcam ta kəŋesəm ta antɔf tɔ, ntɛ ampusɛ MARIKI mɔ. Ta məbɔf dalɛ dam, ta məcɛpəs ŋgbɔŋkəlɔ ya wɛn wam dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ta mətɛl pas ya mɛŋgbɛn mɔkɔ mɛnatɛmpɛnɛ kɔ moŋpoŋ mɔ, ta məpim sɔ yokom ya ŋgbɔŋkəlɔ ya wɛn wam wɔkɔ məntɔcɛpəs dəntɔf mɔ. Teren teŋesəm ta antɔf tɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ti disrɛ nəntam kəcdi yokom nyɛ antɔf ŋendepoŋ teren ta ŋi teŋesəm disrɛ mɔ, kəyɛfɛ məna, kəkɔ wəcar kam wərkun kɔ wəran, wəbəcɛ kam nwɛ məŋsɔŋ kəway mɔ, kɔ wəcikəra wəcepər wəkɔ eyi ndaram mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Yokom yayɔkɔ yendekɔyɔnɛ sɔ yeri ya yɔcɔl kɔ sɛm yonu yɔkɔ yeyi nde atɔf ŋam mɔ teren tatɔkɔ fəp.» ");
INSERT INTO bsp_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Nəde nəclɔm meren meŋesəm camət-mɛrəŋ, haŋ camət-mɛrəŋ, kəwon ka ti kəyɔnɛ meren wəco maŋkəlɛ kɔ camət-maŋkəlɛ (49). ");
INSERT INTO bsp_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Tataka ta wəco ta ŋof ŋa camət-mɛrəŋ, dɔsɔk dadɔkɔ məfula aluk cawon cawon: Dɔsɔk da Kəsɔkəs ka kiciya dɔ, nəfula luk atɔf ŋonu fəp disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Nəpusɛ teren ta wəco kəcamət (50) tatɔkɔ MARIKI, tɛm tatɔkɔ nədəŋk kəyi yɛŋən dɔtɔf aka sədare sonu fəp. Teren tatɔkɔ tɔyɔnɛ nu teren ta Kəkul-kulɛnɛ Pəbotu. Nwɛ o nwɛ pəluksərnɛ kəbaŋ antɔf kɔ paka pɔn, pəkɔ sɔ afum ɔn kəsək nde kəlɔ kɔn disrɛ. ");
INSERT INTO bsp_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Teren ta wəco kəcamət (50) tatɔkɔ tendeyɔnɛ nu teren ta Kəkul-kulɛnɛ Pəbotu, ta nədebɔf, ta nədetɛl sɔ pas yɔkɔ yompoŋ dalɛ mɔ, ta nəpim sɔ ŋgbɔŋkəlɔ ya wɛn yonu nyɛ nəntɔcɛpəs dəntɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Bawo teren ta Kəkul-kulɛnɛ Pəbotu tɔ, tɔyɔnɛ nu teren topus. Nəde nəcdi yokom nyɛ dalɛ donu dɔŋsɔŋ disərka mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Kəren ka kəsata ka Kəkul-kulɛnɛ Pəbotu kaŋkɔ disrɛ, nwɛ o nwɛ pəlukus nde antɔf ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kɔ məndecamsər wɛnc əm antɔf, kɔ pəyɔnɛ fɛ ti məcwayər kɔ paka pɔlɔm-ɛ, ta nwɛ o nwɛ pədir wɛnc. ");
INSERT INTO bsp_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Məwayər wɛnc əm, mba ta məpələr kəlɔm ka meren mɔkɔ mencepər kəyɛfɛ ka teren ta Kəkul-kulɛnɛ Pəbotu tɛlpəs haŋ teren tɔkɔ nəyi mɔ, kɔ meren mɛtɛl mɔkɔ mɛncəmɛ sɔ a teren ta Kəkul-kulɛnɛ Pəbotu kəcbəp sɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Tɔkɔ meren mende kəcbɔlɛ mɔ, itɔ kəway kənde kəcpɛ. Tɔkɔ meren mende kəcbelɛ mɔ, itɔ kəway kənde kəctor, bawo kəlɔm ka kətɛl k'ayi kəcamsər əm. ");
INSERT INTO bsp_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ta fum o fum pədir wɛnc, mənesɛ Kanu kam. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Nəde nəcəmɛ sariyɛ sem darəŋ, nəmɛŋkərnɛ mɔyɔ mem mokur, nəccəmɛ mi darəŋ, nənɔnɛ bəkəc yoforu dɔtɔf. ");
INSERT INTO bsp_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Antɔf ŋendekɔ ŋɔcsɔŋ yokom ya ŋi, nyɛ nəndekɔ nəcdi haŋ nəgbərfɛnɛ mɔ, nənɔnɛ di bəkəc yoforu. ");
INSERT INTO bsp_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kɔ nəndekɔ nəcyifnɛ: ‹Kɔ səntɔbɔf paka, ta səmpim paka-ɛ, ake səndedi teren ta camət-mɛrəŋ-ɛ?› ");
INSERT INTO bsp_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Awa ina MARIKI, indetorər nu kəpocɛ pətɔt kem teren ta camət-tin disrɛ, indesɔŋɛ antɔf ŋokom yokom ya meren maas. ");
INSERT INTO bsp_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Teren ta camət-maas, nəgbɔkərɛ sɔ kəbɔf ka cəbɔf conu, mba kəren kaŋkɔ sɔ, yɛtɛl yonu yokur yɔ nəndi sɔ, bawo yokom yɔkɔ nənamɛŋk mɔ, yendelar nu haŋ ta nəntam yi kəlip kədi teren ta camət-maas-ɛ, nəntam kəkar teren ta camət-maŋkəlɛ a nəccop kədi ka yokom yofu.» ");
INSERT INTO bsp_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Afɔde paccaməs antɔf telip katina: Antɔf fəp ŋemi ŋɔ, nde nderem nəyi decikəra, andɛ a ŋi kərɛsna ŋɔ nəyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ti disrɛ atɔf nŋɛ indesɔŋ nu mɔ, mɛnɛ nəkɔcəmbər di sariyɛ səwurusɛ antɔf ŋam nŋɛ mənacamsər fum mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kɔ daka delipər wɛnc əm, pəcamsər əm antɔf ŋɔn tofokəl-ɛ, wɛnc nwɛ ŋanaŋkanɛ kəlɔtərɛnɛ dokom mɔ, ɛntam kəder pəwurus antɔf ŋaŋɔkɔ wɛnc ɛnacamsər əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kɔ fum wəkayi ɔntɔyɔ wɛnc wəlɔtərɛnɛ dokom nwɛ ɛntam kəwurus antɔf ŋɔn mɔ, kɔ nkɔn ende pəsɔtɔ daka ndɛ nkɔnsərka ɛntam kəwurusɛ antɔf ŋɔn ŋɔkɔ ɛnacaməs mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","pəlɔm meren mmɛ mencepər kəyɛfɛ ntɛ ɛnacaməs tofokəl papɔkɔ haŋ kəren nkɛ ɔsɔtɔ daka ndɛ ɔŋkɔwurusɛ pi mɔ, pəlɔm sɔ meren mmɛ mɛncəmɛ a teren ta Kəkul-kulɛnɛ Pəbotu tɛcbəp mɔ, pədeŋər kəway kaŋkɔ pəsɔŋ wəkɔ ɛnaway mɔ, tɛm tatɔkɔ ɛntam kəluksərnɛ nde antɔf ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kɔ wəkayi ɔsɔtɔ fɛ daka ndɛ ɔŋkɔwurusɛ antɔf ŋɔn, haŋ teren ta Kəkul-kulɛnɛ Pəbotu tɛbəp, antɔf ŋeŋyi wəkɔ ɛnaway ŋi mɔ dəwaca. Kɔ teren tatɔkɔ tɛmbəp-ɛ, wəcaməs ka ŋi pəluksərnɛ sɔ kəbaŋ antɔf ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kɔ fum ɛncaməs kəlɔ kɔn nkɛ kəyi dare dɔpɔŋ ndɛ asɔ saŋka haŋ k'anɔŋkər mɔ, wəcaməs kəlɔ ɛntam kəwurus ki haŋ teren tin kəyɛfɛ ntɛ ɛnacaməs kəlɔ kaŋkɔ mɔ. Wəway kəlɔ ɛntam kəkarɛnɛ kɔ kəwurus ka kəlɔ kaŋkɔ haŋ teren tin. ");
INSERT INTO bsp_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kɔ teren tin camcam tencepər wəka kəlɔ ender fɛ pəwurus kəlɔ kɔn-ɛ, tɛm tatɔkɔ kəlɔ kəŋyɔnɛ ka wəkɔ ɛnaway ki mɔ kɔ awut ɔn. Wəway ka kəlɔ kaŋkɔ ɔfɔluksɛ wəcaməs ka ki teren ta Kəkul-kulɛnɛ Pəbotu de. ");
INSERT INTO bsp_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Sariyɛ sin sayi sɔ wɔlɔ wa sədare səfɛt kɔ ntɔf, antam wi kəwurus pəmɔ ntɛ aŋluksɛ sɔ wi asərka kɔ teren ta Kəkul-kulɛnɛ Pəbotu tɛmbəp-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Sədare sa aLewy, kɔ wɔlɔ wɔkɔ wɔyɔnɛ waŋan mɔ, aLewy ŋa ŋande ŋactam kəwurus wi tɛm o tɛm. ");
INSERT INTO bsp_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ali tɔyɔnɛ wəLewy wəlɔma ɛway kəlɔ kaŋkɔ, oŋluksɛ ki wəLewy wəcɔkɔ-cɔkɔ wəkɔ ɛnayɔ ki mɔ teren ta Kəkul-kulɛnɛ Pəbotu, bawo wɔlɔ wa sədare sa aLewy gbəcərəm wɔ ŋayɔ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Dalɛ dɔkɔ deyi sədare səŋan cəsək mɔ, afɔway di, dalɛ daŋan dɔ doru o doru.» ");
INSERT INTO bsp_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Kɔ wɛnc əm eyi'm kəsək daka delipər kɔ-ɛ, məcəmɛ kɔ dəntɔf, pəyɔnɛ wəcikəra, kɔ pəyɔnɛ fɛ ti wəcikəra wəcepərɛnɛ tɛm, ntɛ tɔŋsɔŋɛ nkɔn sɔ pətam kəyi ndaram mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ta nətɛnər kɔ kədir nkɛ o nkɛ, mənesɛ Kanu kam, wɛnc əm ɛntam kəyi ndaram kɔ məna. ");
INSERT INTO bsp_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Məbɔr kɔ pəsam, mba ta məwer kɔ kədeŋər ka tɔkɔ mənabɔr kɔ mɔ. Kɔ məbɔr kɔ yeri-ɛ, ta məwer kɔ kədeŋər am. ");
INSERT INTO bsp_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","MARIKI iyɔnɛ, Kanu kam nkɛ kənawurɛnɛ nu atɔf ŋa Misira, kədesɔŋ nu atɔf ŋa Kanaŋ mɔ. Iyɔnɛ Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Kɔ wɛnc əm ɔyɔnɛ wətɔyɔ daka, pəcamsərn'am-ɛ, ta məcəmbər kɔ yɛbəc ya dacar. ");
INSERT INTO bsp_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Pəcbəc'am ndaram, məcsɔŋ kɔ kəway, pəmɔ wəcikəra wəcepər. Pəbəc'am haŋ teren ta Kəkul-kulɛnɛ Pəbotu. ");
INSERT INTO bsp_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Kɔ teren ta Kəkul-kulɛnɛ Pəbotu tɛmbəp-ɛ, wəkayi pəwur kəlɔ kam yɛŋən, nkɔn kɔ awut ɔn ŋalukus nde kor kəŋan, nde antɔf ŋa akas aŋa. ");
INSERT INTO bsp_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Bawo amarəs em ŋɔ aŋɛ iwurɛnɛ atɔf ŋa Misira mɔ. Afɔcaməs ŋa pəmɔ tɔkɔ ancaməs acar mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ta məcəmbər wɛnc əm yɛbəc ya dacar, məmentər a məleləs ina Kanu kam. ");
INSERT INTO bsp_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Afum a tɔf nyɛ yɛŋkɛl nu mɔ, nəntam kəcwayər ŋa acar arkun kɔ aran. ");
INSERT INTO bsp_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nəndetam sɔ kəcway acikəra akɔ ŋandendɛ nu dacɔ kəcepərɛnɛ tɛm mɔ, afum aŋan a dəcor akɔ aŋkom atɔf ŋonu mɔ, akakɔ nəntam kəcəmbər ŋa dacar. ");
INSERT INTO bsp_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Nənde nəcsakərɛ ŋa awut anu kɔ nəna nəfi-ɛ, ŋayɔnɛ akəŋan. Nənde nəcmɛŋk ŋa, ŋayɔnɛ nu acar doru o doru. Mba nəna aka Yisrayel, ta nwɛ o nwɛ pəcəmbər wɛnc yɛbəc ya dacar. ");
INSERT INTO bsp_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kɔ wɛnc əm ɔyɔnɛ wətɔyɔ daka, pəkɔ pəcamsərnɛ wəcikəra wəcepərɛnɛ tɛm, kɔ pəyɔnɛ fɛ ti, wəcikəra nwɛ ɛndɛ nu dacɔ mɔ, kɔ pəyɔnɛ fɛ ti wɛnc ka wəcikəra wəkɔ ŋampaŋnɛ kor kin mɔ, ");
INSERT INTO bsp_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","wɛnc konu ɛntam kəwurusnɛ: Aŋwosɛ wɛnc wəlɔma kəwurus kɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Kɔ wɛnc ɔntɔtam kəwurus kɔ-ɛ, ncɔk'ɔn, kɔ pəyɔnɛ fɛ ti, wəkiya kɔn, kɔ pəyɔnɛ fɛ ti, wɛnc nwɛ ŋalɔtərɛnɛ dokom mɔ ŋantam kəwurus kɔ. Kɔ pəyɔnɛ fum wəkakɔ ɔsɔtɔ daka dowurusɛnɛ, ɛntam kəwurusnɛ nkɔnsərka. ");
INSERT INTO bsp_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Wəkayi ɔŋlɔm kəyɛfɛ kəren nkɛ ɛncaməsnɛ mɔ haŋ meren mmɛ mɛncəmɛ teren ta Kəkul-kulɛnɛ Pəbotu kəbəp mɔ. Dəkəlɔm da meren mamɔkɔ, antam kəcərɛ kəway nkɛ pəmar pəsɔŋ mɔ. Palɔm kəway kaŋkɔ pəmɔ tɔkɔ aŋsɔŋ fum kəway ka yɛbəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kɔ pəyɔnɛ teren ta Kəkul-kulɛnɛ Pəbotu tɔsɔrɔbɔlɛ-ɛ, wəkayi pawurusɛ kɔ kəway kəŋkɔ ɛnacamsɛ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kɔ pəyɔnɛ a teren ta Kəkul-kulɛnɛ Pəbotu tɔlɔtərnɛ-ɛ, palɔm meren mmɛ mɛncəmɛ teren ta Kəkul-kulɛnɛ Pəbotu kəbəp mɔ, pasɔŋ wəkɔ ɛnaway kɔ mɔ kəway kətəŋnɛnɛ ka meren mmɛ mɛncəmɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kəyi ka wəkayi fəp ndena wəkɔ ɛnaway kɔ mɔ, wəbəc ɔyɔnɛ nwɛ pəmar pasɔŋ kəway teren kəlip mɔ, ta wəway kɔn pəcəmbər kɔ yɛbəc ya dacar fɔr yonu kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","K'awurus fɛ wɛnc konu towurus ntɛ o ntɛ-ɛ, nəkar endewur dacar nkɔn kɔ awut ɔn teren ta Kəkul-kulɛnɛ Pəbotu. ");
INSERT INTO bsp_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","In'ɔ aka Yisrayel ŋayɔnɛ acar. Abəc'em ŋɔ, in'owurɛnɛ ŋa atɔf ŋa Misira. MARIKI iyɔnɛ, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«Ta nəde nəclompəs mɛrəŋka mefəli, ali ta nəde nəcpat tɛrəŋka, ali tasar totontnɛ tin nəde nəccəmbər, ta nədekɔ nəccəmbər ali tasar pɛnɛkəs pin mpɛ nəndekɔ nəctontnɛ fɔr kiriŋ mɔ. MARIKI iyɔnɛ, Kanu konu. ");
INSERT INTO bsp_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Nədekɔ nəcleləs dɔsɔk da kəŋesəm ndɛ ampus’em mɔ fəp, nəleləs sɔ aŋgbip ŋosoku ŋem. MARIKI iyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Kɔ nəncəmɛ sariyɛ sem darəŋ, nəmɛŋkərnɛ mosom mem, nəcyɔ mi-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","iŋsɔŋ nu wəcafən tɛm tɔn, yɔbɔf yonu yoŋkom, kɔ tɔk ya dəkulum yoŋkom sɔ yokom ya yi. ");
INSERT INTO bsp_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Awa nde ndoronu kəsɛpər ka mɛŋgbɛn kənde kəcwon haŋ tɛm tɔfɔcəs wɛn, kɔ kəfɔcəs wɛn kəwon haŋ tɛm ta kəbɔf ka dalɛ sɔ. Nəde nəcdi yeri yonu nəcgbərfɛnɛ, nənɔnɛ sɔ bəkəc yoforu nde atɔf ŋonu. ");
INSERT INTO bsp_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Iŋfɔrəs atɔf ŋonu, nənde nəcfəntərɛ ali fum ta empempi nu-ɛ. Indebɛləs'on atɔf ŋonu sɛm ya dop yɛlɛc yɔkɔ, dakma dɔfɔsɔcepər atɔf ŋonu. ");
INSERT INTO bsp_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Nənde nəcbɛləs aterɛnɛ anu aŋɛ nənde kəcdiftɛ sakma sonu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Afum anu kəcamət gboŋ ŋande ŋacbɛləs aterɛnɛ anu afum tasar tin, afum anu tasar tin (100) ŋande ŋacbɛləs aterɛnɛ anu afum wul wəco (10.000), aŋɛ nənde kəcdiftɛ sakma sonu mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Indecencɛ nu kəro, isɔŋ nu dokombəra, isɔŋɛ nu kəla, indeleləs sɔ danapa dem kɔ nəna. ");
INSERT INTO bsp_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Nəndekɔ nəcdi yɛtɛl yonu yokur haŋ nəwurɛ yɛlpəs nəbɛr yofu. ");
INSERT INTO bsp_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Indekɔcəmbər dəkəyi dem nu dacɔ, ifɔdebɛr nu kumunt. ");
INSERT INTO bsp_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Indesolɛ nu, iyɔnɛ nu Kanu, nəna nəyɔnɛ afum em. ");
INSERT INTO bsp_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","MARIKI iyɔnɛ, Kanu konu, nkɛ kənawurɛnɛ nu atɔf ŋa Misira, ntɛ tɔŋsɔŋɛ ta nəyɔnɛ sɔ acar mɔ. K'intepi kətam ka aka Misira, k'isɔŋɛ nu kəyekti səbomp.» ");
INSERT INTO bsp_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Mba kɔ nəntɔcəŋkəl moloku mem, ta nəncəmɛ mosom mem fəp darəŋ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kɔ nənce sariyɛ sem, nəfən mɔyɔ mokur mem, ta nəncəmɛ mosom mem darəŋ, kɔ nəncopu danapa dem-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ntɛ t'iŋyɔ nu: Indebɛr nu abɔc dəbəkəc, meleŋki kɔ fiba, ntɛ tendeyamsɛ nu kənəŋk belbel, tɔcsɔm mataka monu meyi doru mɔ. Nənde nəcbɔf kifəli, aterɛnɛ anu ŋande kəcdi yi. ");
INSERT INTO bsp_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Indebɛr nu kumunt, aterɛnɛ anu ŋande kəctam nu. Aŋɛ ŋanter nu mɔ ŋande kəcyi nu kəroŋ, nəcyɛksɛ ta fum o fum ɛncəmɛ nu darəŋ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Kɔ mamɔkɔ fəp meyi ta nəcəŋkəl im-ɛ, intɔrəs nu camət-mɛrəŋ teta kiciya konu. ");
INSERT INTO bsp_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Indetepi kədot banca konu, isɔŋɛ wəcafən kətɔder, yɔbɔf yɔfɔde yectesɛ atɔf ŋonu. ");
INSERT INTO bsp_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Sɔkət sonu sənde kəclɛcɛ kifəli, atɔf ŋonu ŋɔfɔsɔkom pəmɔ tɔkɔ pəmar mɔ, tɔk yonu yɔfɔsɔkom. ");
INSERT INTO bsp_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kɔ nəncəm'em dɛbəkəc kəyɛfərɛnɛ, ta nəwosɛ kəcəŋkəl im-ɛ, iŋnɔcər sɔ kəsutɛ nu mɔtɔrəs camət-mɛrəŋ teta kiciya konu. ");
INSERT INTO bsp_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Iŋkɛrɛ nu sɛm ya dop, nyɛ yende kəcdifər nu awut mɔ, sɛm nyɛ yendelip kədifət ka yɔcɔl yonu, sɛm nyɛ yendesɔŋɛ nu kəpicɛ mɔ. Tɛm tatɔkɔ səpɔ sonu səyɔ yeryer. ");
INSERT INTO bsp_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Kɔ mamɔkɔ fəp meyi ta nəwosɛ kətɔrəs kem kaŋkɔ, nəcəm'em dɛbəkəc-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ina sɔ incəmɛ nu dɛbəkəc, iŋnɔcər kəsut nu camət-mɛrəŋ teta kiciya konu. ");
INSERT INTO bsp_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Iŋkɛrɛ nu dakma doluksɛ ayɛk, ndɛ dendeluksɛ ayɛk ŋa danapa dem mɔ. Tɛm ntɛ nəŋloŋkanɛ sədare sonu mɔ, nəna dacɔ iŋkɛrɛ nu arom, tɛm tatɔkɔ ambɛr nu aterɛnɛ anu dəwaca. ");
INSERT INTO bsp_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","K'indebaŋər nu kəcom-ɛ, aran wəco ŋande ŋacbɛrɛnɛ kəcɔf cəcom pɔcɔfɛ kəcom pin, ŋatubuc kəyer nu ci, tɔŋsɔŋɛ nəcsɔm ci ta cəsɔŋɛ nu kənɛmbərɛ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","K'iyɔ sɔ mamɔkɔ ta nəncəŋkəl im, nəsɔrɔcəm'em dɛbəkəc-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","incəmɛ nu dɛbəkəc icepərər, iŋnɔcər kətɔrəs nu camət-mɛrəŋ teta kiciya konu. ");
INSERT INTO bsp_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Nənde kəcsɔm dis da awut anu arkun kɔ aran. ");
INSERT INTO bsp_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Iŋləsər mofo mɛsali monu nde dəmɔrɔ, iwuŋ metek monu nde nəncɔfɛ suray canu conu ca yem mɔ, ilɛk cəbel ca afum anu afi, ideŋər ci cəbel ca mɛrəŋka monu kəroŋ. Abəkəc ŋem ŋɔbɔlɛ nu. ");
INSERT INTO bsp_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Indecekəli sədare sonu, iləsər mofo mɛsali monu, ifɔsɔliŋərnɛ ambɔnc ŋa yoloŋnɛ yonu nŋɛ ŋontorɛ-tor'em abəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Inasərka in'endewoŋkər atɔf. Aterɛnɛ anu aŋɛ ŋandendɛ ŋi mɔ, ŋandesumpərnɛ cusu. ");
INSERT INTO bsp_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Iŋkɛrɛ nu afum aŋɛ ŋandewɛkərnɛ nu mɔ, isamsər nu afum a tɔf alpəs aŋɛ dacɔ. Atɔf ŋonu, aŋləsər ŋi pəmɔ tɛgbərɛ, kɔ sədare sonu səcɛkəlɛ. ");
INSERT INTO bsp_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Awa, meren mmɛ nəndeyi marənt ndena aterɛnɛ anu mɔ fəp, atɔf ŋonu nŋɛ nəsak ŋɛlɛcɛ mɔ, ŋendeŋesəm kəsəkpɛ ka tɔkɔ nənatɔsak ŋi ŋeŋesəm mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tɛm ntɛ ŋendeyi ŋɛlɛcɛ mɔ fəp, ŋendesɔtɔ kəŋesəm nkɛ ŋɛnatɔŋesəm ntɛ nənandɛ ŋi mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Awɛnc nu aŋa alpəs aŋɛ ŋandeyi nda aterɛnɛ aŋan mɔ, indesɔŋ ŋa defer fɔr. Kəborɛ-borɛ ka abɔpər gbəcərəm kənde kəcsɔŋɛ ŋa kəyɛksɛ. Ŋande kəcyɛksɛ pəmɔ ntɛ fum endeyɛksər dakma mɔ, ŋayɛksɛ haŋ ŋakɔ ŋatɛmpɛnɛ, ta fum o fum ɛncəmɛ ŋa darəŋ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ŋandekɔ ŋacfoŋkən-foŋkən ŋaccaŋərɛnɛ kəyɛksɛ pəmɔ tɔkɔ aterɛnɛ aŋan ŋancəmɛ ŋa darəŋ ŋatɔmpərɛ ŋa sakma mɔ, tɔyɔnɛ oŋ ali fum ɛncəmɛ fɛ ŋa darəŋ. Nəfɔdetam kəcəmɛ aterɛnɛ anu fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Dəkələpsər da ti, marənt mɔ nəndefi, tɔf ŋocuru yemer nu. ");
INSERT INTO bsp_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Dətɔf ya aterɛnɛ anu, awɛnc anu alpəs aŋɛ andesak mɔ, ŋandete teta kiciya kəŋan kɔ ka atem aŋan.» ");
INSERT INTO bsp_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Mba aŋɛ ŋantɔdefi kətɔrəs kaŋkɔ disrɛ mɔ, ŋandecɛŋ kiciya kəŋan kɔ ka atem aŋan, mes mɛlɛc mmɛ ŋacyɔ ina MARIKI, ŋacəm'em sɔ dɛbəkəc. ");
INSERT INTO bsp_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Ti tendesɔŋɛ ŋa kəcərɛ a ina sɔ, icəmɛ ŋa dɛbəkəc, k'isamsər ŋa nde atɔf ŋa aterɛnɛ aŋan. Tɛm tatɔkɔ, kɔ bəkəc yaŋan yɔtɔcərɛ ina Kanu yendekɔlapəs ŋa teta kətɔsumpər danapa dosu, ŋawosɛ kətɔrəs ka kiciya kəŋan-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","indecɛm-cɛmnɛ danapa dem ndɛ inasek kɔ Yakuba, Siyaka, kɔ Abraham mɔ, ti tendesɔŋ'em oŋ kəcɛm-cɛmnɛ atɔf ŋonu. ");
INSERT INTO bsp_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ti disrɛ kɔ ŋandesak atɔf-ɛ, atɔf ŋaŋɔkɔ ŋendetam kəŋesəm. Tɛm tatɔkɔ ŋandewosɛ kətɔrəs bawo ŋawosɛ fɛ sariyɛ sem kɔ ŋafən mɔyɔ mem mokur teta ntɛ ŋantɔcəmɛnɛ mɔyɔ mokur mem darəŋ ŋacfati sɔ kəyɔ sariyɛ sem mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ali tɛm tatɔkɔ asamsər ŋa nda aterɛnɛ aŋan mɔ, ifɔter ŋa doru o doru haŋ imələk ŋa de, ifɔcopu sɔ danapa dem kɔ ŋa. MARIKI iyɔnɛ, Kanu kəŋan. ");
INSERT INTO bsp_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ɛy, indecɛm-cɛmnɛ kəŋaŋnɛnɛ ŋa, teta danapa dɔkɔ sənacaŋəs kɔ atem aŋan mɔ, aŋɛ inawurɛnɛ atɔf ŋa Misira mɔ, fɔr ya afum a tɔf yɛlpəs nyɛ fəp kiriŋ, ideyɔnɛ ŋa Kanu mɔ. MARIKI iyɔnɛ.» ");
INSERT INTO bsp_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Sariyɛ saŋsɛ, mɔyɔ mokur kɔ mɛtəksɛ mamɛ mɔ MARIKI ɛnacəmbər nkɔn kɔ aka Yisrayel dacɔ nde tɔrɔ ta Sinayi, kəsom ka Musa. ");
INSERT INTO bsp_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Məloku aka Yisrayel: Kɔ fum ɛndɛrəm kəsɔŋ ka fum wəlɔma teta yɛbəc ya MARIKI-ɛ, pəmar wəkayi pəwurusɛ kɔ pəsam mpɛ pɛntəŋnɛ kəway ka kəwurusɛ fum nkɛ ambonc nde aŋgbip ŋosoku mɔ, nkɔn pəlɛk fum kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Kəway kaŋkɛ kɔ nəndetam kəcwurusɛ afum aŋɛ anasɔŋ MARIKI kədɛrəm disrɛ mɔ: Kɔ pəyɔnɛ wərkun nwɛ ɔsɔtɔ kəyɛfɛ meren wəco mɛrəŋ (20) haŋ kəbəp ka meren wəco camət-tin mɔ (60), pawurusɛ kɔ pəsam gbəleŋ wəco kəcamət (50) potubucɛ pa nde aŋgbip ŋosoku. ");
INSERT INTO bsp_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kɔ pəyɔnɛ wəran ɔfɔ-ɛ, pəsam gbəleŋ wəco maas (30) pɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kɔ pəyɔnɛ wan nwɛ ɔsɔtɔ meren kəyɛfɛ kəcamət haŋ wəco mɛrəŋ (20) mɔ, k'ɔyɔnɛ wan wərkun-ɛ, pəsam gbəleŋ wəco mɛrəŋ (20), k'ɔyɔnɛ wəran-ɛ, pəsam gbəleŋ wəco (10) pɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kɔ pəyɔnɛ wanfɛt wəka ŋof ŋin haŋ meren kəcamət ɔfɔ-ɛ, aŋsɔŋ teta wan wərkun pəsam gbəleŋ kəcamət (5), teta wan wəran pəsam gbəleŋ maas (3). ");
INSERT INTO bsp_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kɔ pəyɔnɛ wəbeki wəka meren wəco camət-tin (60) haŋ pəcepər ɔfɔ-ɛ, aŋsɔŋɛ tetɔn pəsam gbəleŋ wəco kɔ kəcamət (15) k'ɔyɔnɛ wərkun-ɛ. K'ɔyɔnɛ wəran-ɛ, pasɔŋ pəsam gbəleŋ wəco (10). ");
INSERT INTO bsp_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kɔ pəyɔnɛ wəkɔ ɛndɛrəm mɔ ɔyɔ fɛ daka ndɛ ɔŋkɔsɔŋ kəway kətəŋnɛ mɔ, pakɔ pacəmbər wəkayi wəloŋnɛ fɔr kiriŋ, wəloŋnɛ pəcɛm-cɛmnɛ tɔkɔ ɔŋkɔboncər kɔ mɔ. Wəloŋnɛ pəmɔmən kəsɔtɔ ka wəkayi daka a pəctam kəwer kɔ kəway kaŋkɔ pəmar pəsɔŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Kɔ pəyɔnɛ pɔcɔl pɔ mpɛ pentesɛ kəkenɛ MARIKI mɔ, mpɛ o mpɛ andekenɛ MARIKI mɔ, papus pi. ");
INSERT INTO bsp_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Afɔsəkpərɛ pɔcɔl pɔtɔt, pɛlɛc. Afɔsɔsəkpərɛ pɛlɛc, pɔtɔt. K'asəkpərɛ pɔcɔl, pɔcɔl pɔlɔma-ɛ, ampusɛ MARIKI yɔcɔl yayɔkɔ mɛrəŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kɔ pəyɔnɛ pɔcɔl pɔtɔsɔk pɔ-ɛ, mpɛ antɔwosɛ kəloŋnɛ MARIKI mɔ, pakenɛ pi wəloŋnɛ pəmɔmən. ");
INSERT INTO bsp_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Wəloŋnɛ ɔŋkɔmɔmən dɔtɔt da pɔcɔl kɔ pəyɔnɛ fɛ ti, dɛlɛc da pɔcɔl papɔkɔ, a pəboncər wəkayi tɔkɔ pəmar pəsɔŋ kəway mɔ. Kəway kaŋkɔ kɔ afum ŋaŋkɔcəmɛ darəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kɔ wəka pɔcɔl ɛfaŋ kəwurus pɔcɔl pɔn-ɛ, pəsɔŋ kəway ka pi kɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kɔ fum ompusɛ kəlɔ kɔn MARIKI, wəloŋnɛ pəmɔmən dɔtɔt kɔ dɛlɛc da kəlɔ kaŋkɔ, kəway kaŋkɔ ɔŋkɔboncɛ ki mɔ, k'aŋkɔcəmɛ darəŋ. ");
INSERT INTO bsp_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kɔ wəka kəlɔ kaŋkɔ ɛfaŋ kəwurus kəlɔ kɔn-ɛ, pəsɔŋ kəway ka ki məlməl, a pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. Kəlɔ kaŋkɔ kəŋluksərnɛ sɔ kəyɔnɛ kɔn. ");
INSERT INTO bsp_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kɔ fum ɛlɛk abɔf ŋɔn pəpusɛ MARIKI-ɛ, defet dɔkɔ ɛŋgbalɛ abɔf ŋaŋɔkɔ mɔ d'aŋkɔlɛk kəway ka di: Pəsam gbəleŋ wəco kəcamət (50) kəway ka defet da mɛŋgbɛn kilo masar maas (300). ");
INSERT INTO bsp_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kɔ pəyɔnɛ a kəcop ka teren ta Kəkul-kulɛnɛ Pəbotu tɔ wəkayi ompusɛ abɔf ŋɔn MARIKI-ɛ, tatɔkɔ t'amboncɛ kɔ kəway. ");
INSERT INTO bsp_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kɔ pəyɔnɛ a teren ta Kəkul-kulɛnɛ Pəbotu tencepər a kɔ fum endepusɛ abɔf ŋɔn MARIKI-ɛ, wəloŋnɛ pəlɔm meren mɔkɔ mɛncəmɛ a teren ta Kəkul-kulɛnɛ Pəbotu tɛcbəp mɔ, pəbeli kəway ka abɔf. ");
INSERT INTO bsp_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kɔ wəka abɔf ɛfaŋ kəwurus ka abɔf ŋɔn-ɛ, pəsɔŋ kəway ka abɔf ŋɔn nkɛ wəloŋnɛ omboncər kɔ mɔ. A pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. Tɛm tatɔkɔ abɔf ŋoluksərnɛ sɔ ŋɔyɔnɛ ŋɔn. ");
INSERT INTO bsp_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kɔ wəka abɔf owurus fɛ abɔf ŋɔn haŋ fum wəcuru pəway ŋi-ɛ, wəka abɔf ŋaŋɔkɔ ɔfɔsɔtam kəwurus ŋi. ");
INSERT INTO bsp_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kɔ teren ta Kəkul-kulɛnɛ Pəbotu tɛmbəp-ɛ, abɔf ŋaŋɔkɔ ŋoŋluksərnɛ MARIKI, aloŋnɛ ŋayɔ oŋ ŋi. Pəŋyi tɛm tatɔkɔ pəmɔ ntɛ fum ɔŋsɔŋ paka MARIKI, ta ɛntam sɔ pi kəbaŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kɔ fum ompusɛ MARIKI abɔf nŋɛ ɛnaway mɔ, tɔyɔnɛ bafɔ kɛ ka atem ɔn kəsak kɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","wəloŋnɛ pəlɔm meren mmɛ mɛncəmɛ teren ta Kəkul-kulɛnɛ Pəbotu tɔkɔ kəbəp mɔ, wəka abɔf pəsɔŋ dɔsɔk dadɔkɔ yati kəway kaŋkɔ wəloŋnɛ omboncər kɔ mɔ. Papusɛ pəsam papɔkɔ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Kɔ teren ta Kəkul-kulɛnɛ Pəbotu tɛmbəp-ɛ, abɔf ŋoluksər wəka ŋi wəcɔkɔ-cɔkɔ, itɔ tatɔkɔ fum nwɛ ɛnalɛk ŋi kɛ ka atem ɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Kəway nkɛ o nkɛ ambonc mɔ, kəyɔnɛ kəway ka nde aŋgbip ŋosoku: Delel da pəsam gbəleŋ bin dɛtəŋnɛnɛ kɔ kəram wəco (10).» ");
INSERT INTO bsp_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Ali fum ta pəpusɛ MARIKI wan wəcɔkɔ-cɔkɔ wəka pɔcɔl pɔn, pəyɔnɛ wana, aŋkesiya, wir, bawo awut acɔkɔ-cɔkɔ a yɔcɔl yɔn fəp, MARIKI ɔyɔ yi. ");
INSERT INTO bsp_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kɔ pəyɔnɛ pɔcɔl pɔtɔsɔk pɔ-ɛ, wəka pi pəwurus pi, pəsɔŋ kəway nkɛ wəloŋnɛ omboncər kɔ mɔ. A pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. K'ɔntɔwurus pi-ɛ, wəloŋnɛ ɛntam pi kəcamsər nwɛ ɛŋfaŋ pi mɔ, kəway kaŋkɔ wəloŋnɛ omboncər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Paka mpɛ o mpɛ pɔyɔnɛ pa fum, wəkayi pəlɛk pi pəpusɛ MARIKI doru o doru mɔ, afɔsɔtam kəcaməs pi, afɔsɔtam kəwurus pi, pəyɔnɛ fum, pəyɔnɛ pɔcɔl, pəyɔnɛ abɔf nŋɛ wəka ŋi ɛlɛk kɛ mɔ. Daka ndɛ o ndɛ ampus topus tatɔkɔ mɔ, daka dosoku dɔ ndɛ ampusɛ MARIKI mɔ, afɔsɔtam kəsəkpər ti. ");
INSERT INTO bsp_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Kɔ tɔyɔnɛ fum ɔfɔ nwɛ sariyɛ sa kədif səsumpur mɔ, afɔtam kəwurus kɔ, mɛnɛ padif fum wəkayi. ");
INSERT INTO bsp_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Farilɛ fa yɔbɔf fəp, pəyɔnɛ pɔbɔf, pəyɔnɛ yokom ya tɔk, MARIKI ɔyɔ yi, daka dɔ ndɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kɔ fum ɛfaŋ kəwurus ka farilɛ fɔn-ɛ, pəsɔŋ kəway ka farilɛ fɔn, pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Farilɛ fa yɔcɔl, cəna, ŋkesiya, kɔ cir fəp, camət-maŋkəlɛ ya wəka yɔcɔl yɔ, pa wəco, MARIKI ampusɛ pi. ");
INSERT INTO bsp_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Afɔtɛn kəcərɛ kɔ pəyɔnɛ pɔcɔl papɔkɔ pentesɛ kɔ pəyɔnɛ fɛ ti, pɛlɛcɛ-ɛ, afɔsəkpər pi. K'asəkpərɛ pɔcɔl pɔcɔl-ɛ, yɔcɔl yayɔkɔ mɛrəŋ fəp ampusɛ yi MARIKI, afɔsɔtam kəwurus yi.» ");
INSERT INTO bsp_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Mosom mamɔkɔ mɔ MARIKI ɛnasom Musa nnɔ aka Yisrayel ŋayi mɔ nde tɔrɔ ta Sinayi.");
INSERT INTO bsp_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Nde tɛgbərɛ ta Sinayi, nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋa mɛrəŋ, teren ta mɛrəŋ ta kəwur ka aka Yisrayel Misira, kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Nəlɔm kəloŋkanɛ ka afum a Yisrayel dəcor kɔ dəwɔlɔ, nəlɔm səbomp tin tin mewe ma arkun fəp. ");
INSERT INTO bsp_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Məna kɔ Aruna nəlɔm aŋɛ ŋantam kətɔmpər yosutnɛnɛ Yisrayel mɔ, dəcəgba ca asutɛnɛ, kəyɛfɛ aŋɛ ŋayɔ meren wəco mɛrəŋ haŋ kəcepər ka ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Nəndekɔsɔtɔ amar, akiriŋ akin akin a cusuŋka conu. ");
INSERT INTO bsp_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Mənəŋk mewe ma arkun aŋɛ ŋandemar nu mɔ. Kusuŋka ka Ruben: Elicur wan ka Sedewur. ");
INSERT INTO bsp_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Kusuŋka ka Simeyɔŋ: Selumiyel, wan ka Curisaday. ");
INSERT INTO bsp_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Kusuŋka ka Yuda: Nasɔŋ, wan ka Aminadab. ");
INSERT INTO bsp_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Kusuŋka ka Isakar: Netaneyel, wan ka Cuwar. ");
INSERT INTO bsp_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Kusuŋka ka Sabulon: Eliyab, wan ka Heloŋ. ");
INSERT INTO bsp_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Kusuŋka ka awut a Isifu, kusuŋka ka Efrayim: Elisama, wan ka Amihud. Kusuŋka ka Manase: Kamaliyel, wan ka Pedacur. ");
INSERT INTO bsp_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Kusuŋka ka Beŋyamin: Abidan, wan ka Kideyoni. ");
INSERT INTO bsp_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Kusuŋka ka Dan: Ahiyeser, wan ka Amisaday. ");
INSERT INTO bsp_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Kusuŋka ka Asɛr: Pakiyel, wan ka Okəraŋ. ");
INSERT INTO bsp_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Kusuŋka ka Kad: Eliyasaf, wan ka Dewel. ");
INSERT INTO bsp_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Kusuŋka ka Naftali: Ahira, wan ka Enan.» ");
INSERT INTO bsp_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Akiriŋ a cusuŋka aŋɛ anayɛk-yɛk kəloŋkanɛ ka Yisrayel dacɔ mɔ, ŋanayɔnɛ akiriŋ a cəgba ca asutɛnɛ a Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa kɔ Aruna ŋalɛk afum aŋɛ anamentər mewe maŋan mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","kɔ ŋaloŋka aka Yisrayel fəp dɔsɔk dɔcɔkɔ-cɔkɔ da ŋof ŋa mɛrəŋ. Musa kɔ Aruna ŋacicəs mewe maŋan dəcor kɔ dəwɔlɔ, kɔ ŋalɔm ŋa tin tin, arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ (20) haŋ ŋacepər ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Pəmɔ tɔkɔ MARIKI ɛnasom ti Musa a pəlɔm ŋa nde dətɛgbərɛ ta Sinayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kɔ kəlɔm kəncop nda kusuŋka ka awut a Ruben wan wəcɔkɔ-cɔkɔ wəka Yisrayel, kəbənda ka yuruya yɔn, dəcor kɔ dəwɔlɔ, dokom kɔ dokom, palɔm tin tin mewe ma arkun fəp, aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, kɔ aŋɛ ŋantam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","arkun aŋɛ ŋanalɔm nde kusuŋka ka Ruben mɔ: Wul wəco maŋkəlɛ kɔ camət-tin, masar kəcamət (46.500). ");
INSERT INTO bsp_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kəbənda ka yuruya ya Simeyɔŋ, dəcor kɔ dəwɔlɔ, aŋɛ analɔm tin tin mewe ma arkun fəp kəyɛfɛ aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti mɔ, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","arkun aŋɛ analɔm nde kusuŋka ka Simeyɔŋ mɔ, ŋanayi afum wul wəco kəcamət kɔ camət-maŋkəlɛ, masar maas (59.300). ");
INSERT INTO bsp_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kəbənda ka yuruya ya Kad, dəcor kɔ dəwɔlɔ, k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","aŋɛ analɔm nde kusuŋka ka Kad: Afum wul wəco maŋkəlɛ kɔ kəcamət, masar camət-tin wəco kəcamət (45.650). ");
INSERT INTO bsp_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kəbənda ka yuruya ya Yuda, dəcor kɔ dəwɔlɔ, k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","arkun aŋɛ analɔm nde kusuŋka ka Yuda mɔ, ŋanayi afum wul wəco camət-mɛrəŋ kɔ maŋkəlɛ, masar camət-tin (74.600). ");
INSERT INTO bsp_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kəbənda ka yuruya ya Isakar, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","arkun aŋɛ analɔm nde kusuŋka ka Isakar, ŋanayi afum wul wəco kəcamət kɔ maŋkəlɛ, masar maŋkəlɛ (54.400). ");
INSERT INTO bsp_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kəbənda ka yuruya ya Sabulon, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ, haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","arkun aŋɛ analɔm nde kusuŋka ka Sabulon, ŋanayi afum wul wəco kəcamət kɔ camət-mɛrəŋ, masar maŋkəlɛ (57.400). ");
INSERT INTO bsp_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kəbənda ka yuruya ya Isifu: Awut aka Efrayim, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","arkun aŋɛ analɔm nde kusuŋka ka Efrayim ŋanayi afum wul wəco maŋkəlɛ, masar kəcamət (40.500). ");
INSERT INTO bsp_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kəbənda ka yuruya ya Manase, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","arkun aŋɛ analɔm nde kusuŋka ka Manase mɔ, ŋanayi afum wul wəco maas kɔ mɛrəŋ, masar mɛrəŋ (32.200). ");
INSERT INTO bsp_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kəbənda ka yuruya ya Beŋyamin, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ, haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","analɔm nde kusuŋka ka Beŋyamin arkun wul wəco maas kɔ kəcamət, masar maŋkəlɛ (35.400). ");
INSERT INTO bsp_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kəbənda ka yuruya ya Dan, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, kɔ arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Awa, nde kusuŋka ka Dan analɔm di arkun wul wəco camət-tin kɔ mɛrəŋ, masar camət-mɛrəŋ (62.700). ");
INSERT INTO bsp_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kəbənda ka yuruya ya Asɛr, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","arkun aŋɛ analɔm nde kusuŋka ka Asɛr ŋanayi afum wul wəco maŋkəlɛ kɔ pin, masar kəcamət (41.500). ");
INSERT INTO bsp_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kɔ kəbənda ka yuruya ya Naftali, dəcor kɔ dəwɔlɔ k'alɔm mewe ma arkun aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋactam kətɔmpər yosutnɛnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","akaŋɛ ŋanalɔm nde kusuŋka ka Naftali ŋanayi afum wul wəco kəcamət kɔ maas, masar maŋkəlɛ (53.400). ");
INSERT INTO bsp_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Arkun akaŋɛ ŋɔ Musa, Aruna kɔ arkun aŋɛ wəco kɔ mɛrəŋ aŋɛ ŋanayɔnɛ akiriŋ a cusuŋka ca Yisrayel mɔ, ŋanalɔm, kəlɔ o kəlɔ fum wəkin. ");
INSERT INTO bsp_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Arkun akaŋɛ ŋ'analɔm aka Yisrayel dacɔ, dəwɔlɔ kɔ dəwɔlɔ kəyɛfɛ aŋɛ ŋanasɔtɔ meren wəco mɛrəŋ haŋ ŋacepər ti, arkun aŋɛ ŋanctam kətɔmpər yosutnɛnɛ Yisrayel mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","arkun aŋɛ analɔm mɔ fəp, ŋanayi afum wul masar camət-tin kɔ maas, masar kəcamət wəco kəcamət (603.550). ");
INSERT INTO bsp_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ALewy teta kusuŋka kəŋan ananɔŋkəl fɛ ŋa kəlɔm ka aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Ta mədenɔŋkəl arkun a kusuŋka ka Lewy kəlɔm kɔ aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Məna, məkekərɛ aLewy nde dəkiyi da kaŋkəra nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel mɔ, kɔ yosumpər-sumpər kɔ ca yɔkɔ yeyi di disrɛ mɔ fəp. Ŋa ŋande ŋacgbaŋnɛ kaŋkəra kaŋkɔ kɔ yosumpər-sumpər ya di, ŋayɔnɛ akiriŋ a ki, ŋa ŋande ŋackɛl dəkiyi da kaŋkəra dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","K'andecepɛnɛ dəkiyi dosoku-ɛ, aLewy ŋancekəli di. K'aŋkɔ sɔ kəcəmbər dəkiyi dosoku-ɛ, aLewy ŋaŋlɔ sɔ di. Kɔ fum wəfulus ɔlɔtərnɛ di-ɛ, mɛnɛ padif kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Aka Yisrayel fəp nwɛ o nwɛ pəyi saŋka sɔn disrɛ, ta pəbɔlɛnɛ kɔlər ka kəgba kɔn k'asutɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ALewy ŋande ŋackɛl dəkiyi dosoku ndɛ doŋkump kaŋkəra nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel mɔ, ntɛ tɔŋsɔŋɛ ta mɛtɛlɛ ma MARIKI mɛbəp kəloŋkanɛ ka afum a Yisrayel mɔ, aLewy ŋacbum dəkiyi dosoku da kaŋkəra kaŋkɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Kɔ aka Yisrayel ŋayɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Aka Yisrayel nwɛ o nwɛ pəcəmɛ kɔlər kɔn kəsək, tɛnɛpəlɛ ta kəlɔ kɔn dəntɔf. Ŋacəmɛ ŋatɛfərɛnɛ, ŋacəmbər cəbal cətɛfərɛnɛ, cəkɛl aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Aŋɛ ŋandekɔcəmɛ ntende dec dɛmpɛ mɔ, ŋaŋdekɔyi kɔlər ka saŋka sa Yuda dəntɔf, kəgba k'asutɛnɛ nkɛ o nkɛ, kəyɔ wəkiriŋ wəkin wəka kusuŋka kɔn. Wəkiriŋ ka kusuŋka ka Yuda: Nasɔŋ, wan ka Aminadab, ");
INSERT INTO bsp_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","asutɛnɛ ɔn aŋɛ analɔm mɔ, ŋanabəp wul wəco camət-mɛrəŋ kɔ maŋkəlɛ, masar camət-tin (74.600). ");
INSERT INTO bsp_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Kusuŋka ka Yuda kəsək, ka Isakar kəŋkɔcəmɛ. Wəkiriŋ ka kusuŋka kəŋan: Netaneyel, wan ka Cuwar. ");
INSERT INTO bsp_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco kəcamət kɔ maŋkəlɛ, masar maŋkəlɛ (54.400). ");
INSERT INTO bsp_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kɔ tɛyɛfɛ dənda-ɛ, kusuŋka ka Sabulon. Wəkiriŋ ka kusuŋka kəŋan: Eliyab, wan ka Heloŋ. ");
INSERT INTO bsp_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco kəcamət kɔ camət-mɛrəŋ, masar maŋkəlɛ (57.400). ");
INSERT INTO bsp_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Afum akaŋɛ ŋanalɔm kəyi saŋka sa Yuda: Asutɛnɛ wul tasar tin wəco camət-maas kɔ camət-tin, masar maŋkəlɛ (186.400), asutɛnɛ akakɔ ŋandeyi kiriŋ kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ntende kəca kətɔt ka nde dec dɛmpɛ mɔ, kɔlər ka saŋka sa Ruben: Wəkiriŋ kəŋan Elicur, wan ka Sedewur. ");
INSERT INTO bsp_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco maŋkəlɛ kɔ camət-tin, masar kəcamət (46.500). ");
INSERT INTO bsp_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ŋa kəsək, kusuŋka ka Simeyɔŋ. Wəkiriŋ kəŋan: Selumiyel, wan ka Curisaday. ");
INSERT INTO bsp_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco kəcamət kɔ camət-maŋkəlɛ, masar maas (59.300). ");
INSERT INTO bsp_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kɔ tɛyɛfɛ dənda-ɛ, kusuŋka ka Kadu. Wəkiriŋ kəŋan: Eliyasaf, wan ka Rehuwel. ");
INSERT INTO bsp_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco maŋkəlɛ kɔ kəcamət, masar camət-tin wəco kəcamət (45.650). ");
INSERT INTO bsp_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Asutɛnɛ aŋɛ analɔm nde saŋka sa Ruben mɔ: Wul tasar tin wəco kəcamət kɔ pin, masar maŋkəlɛ wəco kəcamət (151.450), asutɛnɛ akakɔ ŋandekɔ tamɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Kɔ tɛyɛfɛ dənda-ɛ, aŋgbancan ŋɛbəpɛnɛ kɔ Kanu ŋosolnɛ ŋa darəŋ kɔ saŋka sa aLewy ŋayi saŋka dacɔ. Ŋacɛk kəkɔ tɔkɔ ŋaŋkɔloŋkanɛ kəndɛ mɔ, nwɛ o nwɛ kɔ kəgba kɔn, kɔlər kɔn dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ntende dec dɛŋkalɛ mɔ, kɔlər ka saŋka sa Efrayim kənayi di, kəgba ka asutɛnɛ ɔn. Wəkiriŋ ka kusuŋka kəŋan ɛnayɔnɛ Elisama wan ka Amihud. ");
INSERT INTO bsp_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco maŋkəlɛ, masar kəcamət (40.500). ");
INSERT INTO bsp_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ŋa kəsək kusuŋka ka Manase. Wəkiriŋ kəŋan: Kamaliyel wan ka Pedacur. ");
INSERT INTO bsp_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco maas kɔ mɛrəŋ, masar mɛrəŋ (32.200). ");
INSERT INTO bsp_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Kɔ tɛyɛfɛ dənda-ɛ, kusuŋka ka Beŋyamin, wəkiriŋ kəŋan: Abidan wan ka Kideyoni. ");
INSERT INTO bsp_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco maas kɔ kəcamət, masar maŋkəlɛ (35.400). ");
INSERT INTO bsp_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Asutɛnɛ aŋɛ analɔm saŋka sa Efrayim mɔ, ŋanayi afum wul tasar tin kɔ camət-maas, tasar tin (108.100). Kəgba ka asutɛnɛ kaŋkɔ kəŋkɔ tamaas, ŋayi aLewy tadarəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ntende kəca kəmeriya ka nde dec dɛmpɛ mɔ, kɔlər ka saŋka sa Dan, kəgba ka asutɛnɛ ɔn. Wəkiriŋ ka kusuŋka kəŋan: Ahiyeser wan ka Amisaday. ");
INSERT INTO bsp_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Asutɛnɛ ɔn aŋɛ analɔm mɔ: Afum wul wəco camət-tin kɔ mɛrəŋ, masar camət-mɛrəŋ (62.700). ");
INSERT INTO bsp_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Kusuŋka ka Asɛr, aŋɛ ŋancəmbər saŋka səŋan kusuŋka ka Dan kəsək mɔ ŋader. Wəkiriŋ kəŋan: Pakiyel wan ka Okəraŋ. ");
INSERT INTO bsp_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Asutɛnɛ aŋɛ analɔm mɔ: Afum wul wəco maŋkəlɛ kɔ pin, masar kəcamət (41.500). ");
INSERT INTO bsp_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kɔ tɛyɛfɛ dənda-ɛ, kusuŋka ka Naftali. Wəkiriŋ ka kusuŋka kəŋan: Ahira wan ka Enan. ");
INSERT INTO bsp_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Asutɛnɛ aŋɛ analɔm mɔ: Afum wul wəco kəcamət kɔ maas, masar maŋkəlɛ (53.400). ");
INSERT INTO bsp_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Asutɛnɛ aŋɛ analɔm saŋka sa Dan mɔ: Afum wul tasar tin wəco kəcamət kɔ camət-mɛrəŋ, masar camət-tin (157.600). Ŋandekɔ tɛlpəs kɔ kɔlər kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Afum akaŋɛ ŋanalɔm Yisrayel, dəwɔlɔ kɔ dəwɔlɔ. Akakɔ analɔm cəgba ca asutɛnɛ dəsaŋka disrɛ mɔ, ŋanabəp wul masar camət-tin kɔ maas, masar kəcamət wəco kəcamət (603.550). ");
INSERT INTO bsp_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Analɔm fɛ aLewy aYisrayel dacɔ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Kɔ aYisrayel ŋayɔ tɔkɔ MARIKI ɛnaloku Musa mɔ. Tatɔkɔ tɔ ŋanaloŋkanɛ aŋɛ o aŋɛ kɔ kɔlər kəŋan. Tatɔkɔ tɔ ŋanckɔ aŋɛ o aŋɛ kɔ kor kəŋan kəlɔ kəŋan disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Mewe ma awut a Aruna kɔ Musa mɔ mamɛ dɔsɔk ndɛ MARIKI olok-lokər Musa nde tɔrɔ ta Sinayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Mewe ma awut arkun a Aruna mɔ mamɛ: Coco Nadab, tɔŋɔ Abihu, sama Elasar, baki Itamar. ");
INSERT INTO bsp_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mewe ma awut arkun a Aruna mɔ mamɔkɔ, aloŋnɛ aŋɛ ŋanasɔtɔ kəbɔy, akaŋɛ ŋanawurɛ kəyɔnɛ ka akiriŋ a yɛbəc ya Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab kɔ Abihu ŋanasɔtɔ fɛ awut ntɛ ŋanafi nde tɛgbərɛ ta Sinayi MARIKI fɔr kiriŋ mɔ, bawo ŋanakɛrɛ kɔ nɛnc dɔtɔtesɛ ndɛ ɛnatɔsom ŋa kəkɛrɛ kɔ mɔ. Kəfi kəŋan kənasɔŋɛ Elasar kɔ Itamar ŋayɔnɛ oŋ akiriŋ a aloŋnɛ kas kəŋan Aruna kəsək. ");
INSERT INTO bsp_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Məkɛrɛ kusuŋka k'aLewy, məsɔŋ ŋa Aruna wəloŋnɛ, ntɛ tɔŋsɔŋɛ ŋacmar kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ŋacəmɛ yɛbəc yɔn kɔ kəloŋkanɛ ka Yisrayel fəp nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Ŋa ŋadekɔ ŋacbəc yɛbəc ya nde dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ŋa ŋandekɔyɔnɛ abum a yosumpər-sumpər ya nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ŋacəmɛ sɔ yɛbəc ya aka Yisrayel. Ŋa ŋandekɔcəmɛ yɛbəc ya nde dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Məsɔŋ aLewy, ntɛ tɔŋsɔŋɛ ŋacmar Aruna kɔ awut ɔn arkun yɛbəc, tewe t’aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Mədəs Aruna kɔ awut ɔn arkun kəyɔnɛ ka akiriŋ a yɛbəc ya Kanu. Kɔ fum wəcuru ɔlɔtərnɛ kəyɔ yɛbəc ya aloŋnɛ-ɛ, mɛnɛ padif kɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Ina, ilɛk aLewy aYisrayel dacɔ dəkəcəmɛ da awut acɔkɔ-cɔkɔ a aran aYisrayel fəp. ALewy, akemi ŋɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Bawo awut acɔkɔ-cɔkɔ fəp, akemi ŋɔ. Dɔsɔk ndɛ inasut awut acɔkɔ-cɔkɔ Misira mɔ, k'impusnɛnɛ awut acɔkɔ-cɔkɔ a Yisrayel fəp, kəlɛk wəkom wəcɔkɔ-cɔkɔ nwɛ o nwɛ wəka fum kəbəp ka wəka pɔcɔl.» ");
INSERT INTO bsp_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Nde tɛgbərɛ ta Sinayi, kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Məlɔm awut a Lewy dəwɔlɔ kɔ dəcor, məlɔm arkun kəlɛk aŋɛ ŋasɔtɔ ŋof ŋin haŋ ŋacepər ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Kɔ Musa ɔlɔm ŋa pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Mewe ma awut a Lewy mɔ mamɛ: Kerson, Kehat kɔ Merari. ");
INSERT INTO bsp_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Mewe ma awut a Kerson mɔ mamɛ dəcor: Libini kɔ Simeyi. ");
INSERT INTO bsp_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Awut a Kehat dəcor: Amram, Yicahar, Hebərɔŋ kɔ Usiyɛl. ");
INSERT INTO bsp_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Awut a Merari dəcor: Mali kɔ Musi. Cor ca aLewy cɔ cacɔkɔ dəwɔlɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kerson ɔyɔnɛ wətem ka aka kor ka Libini kɔ kor ka Simeyi. Cor ca Kerson cɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Afum aŋɛ analɔm ŋa dacɔ mɔ, arkun aŋɛ analɔm kəyɛfɛ aŋɛ ŋanasɔtɔ ŋof ŋin haŋ ŋacepər ti mɔ, ŋanabəp afum wul camət-mɛrəŋ, masar kəcamət (7.500). ");
INSERT INTO bsp_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Cor ca Kerson ŋancndɛ nde dəkiyi dosoku tadarəŋ ntende dec dɛŋkalɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Wəkiriŋ ka cor ca Kerson: Eliyasaf, wan ka Layɛl. ");
INSERT INTO bsp_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ntɛ tɔyɔnɛ ta aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, awut a Kerson ŋanatɔmpər kəcəmbər-cəmbər ka mes ma dəkiyi dosoku fəp: Kəyɛfɛ aŋgbancan kəkɔ kəloto kəkumpɛ, kəbəp kəloto kəkəŋkɛ nkɛ kəyi nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","cəloto ca saŋka kɔ kəloto kəŋɛrɛ dəkəbɛrɛ da saŋka, dəkiyi dosoku fəp kɔ tetek toloŋnɛ panɔŋkərɛ yi bənda yɔkɔ aŋsektɛ ca yayɔkɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Aka Kehat: Kor ka Amram, ka Yicahar, ka Hebərɔŋ kɔ ka Usiyɛl. Kehat ɔyɔnɛ wəkiriŋ kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ntɛ analɔm arkun fəp kəyɛfɛ ka akɔ ŋanasɔtɔ ŋof ŋin haŋ ŋacepər ti mɔ, ŋanabəp wul camət-maas, masar camət-tin (8.600). Ŋa ŋanatɔmpər teta ca yɔkɔ yɛnayi aŋgbip ŋosoku disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kor ka awut a Kehat ŋa ŋancndɛ nde kəca kətɔt ka dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Wəkiriŋ ka wɔlɔ wa cor ca aka Kehat: Elicafan wan ka Usiyɛl. ");
INSERT INTO bsp_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ŋa ŋanatɔmpər teta kaŋkəra ka Danapa da Kanu kɔ aka Yisrayel, amɛsa, pɛdɛtɛ səlamp, metek moloŋnɛ, yosumpər-sumpər ya deŋgbip nyɛ ambəcɛ di mɔ fəp, kɔ kəloto kəkəŋkɛ. Ŋa ŋanatɔmpər sɔ yɛbəc fəp ya ca yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Wəbɛ ka akiriŋ a cor ca aka Lewy: Elasar wan wərkun ka wəloŋnɛ Aruna. Nkɔn ɔncmɔmən aŋɛ ŋanatɔmpər yɛbəc ya deŋgbip mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari ɔyɔnɛ wətem ka aka kor ka Mali kɔ ka Musi. Cor mɛrəŋ cɔ ɔyɔ: Kor ka Mali kɔ ka Musi. ");
INSERT INTO bsp_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ntɛ analɔm arkun dacɔ aŋɛ ŋanasɔtɔ kəyɛfɛ ŋof ŋin haŋ ŋacepər ti mɔ, anasɔtɔ wul camət-tin, masar mɛrəŋ (6.200). ");
INSERT INTO bsp_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Wəkiriŋ ka aka kor ka Merari ɛnayɔnɛ Curiyel wan ka Abihayil. Ŋa ŋancndɛ kəca kəmeriya ka dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Awut a Merari ŋanatɔmpər teta fərɛm fa dəkiyi dosoku, mogbu kɔ gbat-gbata kɔ yɛcəmɛnɛ ya aŋgbancan kɔ ca yɔkɔ ancbəcɛ di mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","mogbu ma saŋka haŋ panɔŋkər kɔ yɛcəmɛnɛ ya mi, cəgbo ca ŋi kɔ bənda. ");
INSERT INTO bsp_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa, Aruna kɔ awut ɔn arkun, ŋa ŋandɛ dəkiyi dosoku tekiriŋ ntende dec dɛmpɛ mɔ, aŋgbancan ŋɛbəpɛnɛ kɔ Kanu tekiriŋ. Ŋa ŋatɔmpər teta yɛbəc ya aŋgbip ŋosoku. Fum wəcuru nwɛ o nwɛ ɔŋlɔtərnɛ ŋi mɔ, mɛnɛ padif kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ALewy aŋɛ Musa kɔ Aruna ŋanalɔm pəmɔ tɔkɔ MARIKI ɛnasom ŋa ti mɔ, arkun fəp dəcor aŋɛ ŋanasɔtɔ ŋof ŋin haŋ ŋacepər ti mɔ, ŋanabəp wul wəco mɛrəŋ kɔ mɛrəŋ (22.000). ");
INSERT INTO bsp_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Kɔ MARIKI oloku Musa: «Məlɔm arkun acɔkɔ-cɔkɔ fəp aYisrayel dacɔ, kəyɛfɛ aŋɛ ŋasɔtɔ ŋof ŋin haŋ ŋacepər ti mɔ, məlɔm ŋa məcic mewe maŋan. ");
INSERT INTO bsp_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","MARIKI iyɔnɛ. Məlɛk em aLewy dəkəcəmɛ da awut acɔkɔ-cɔkɔ aka Yisrayel, yɔcɔl yaŋan yi sɔ yɔyɔnɛ yɔcɔl yɔcɔkɔ-cɔkɔ ya aka Yisrayel.» ");
INSERT INTO bsp_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Kɔ Musa ɔlɔm awut acɔkɔ-cɔkɔ a Yisrayel fəp pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Arkun acɔkɔ-cɔkɔ aŋɛ analɔm ŋa dacɔ mɔ fəp, mewe ma aŋɛ ŋanasɔtɔ ŋof ŋin haŋ ŋacepər ti mɔ, ŋanabəp wul wəco mɛrəŋ kɔ mɛrəŋ, masar mɛrəŋ wəco camət-mɛrəŋ kɔ maas (22.273). ");
INSERT INTO bsp_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Məlɛk aLewy dəkəcəmɛ da awut acɔkɔ-cɔkɔ a Yisrayel. Məlɛk sɔ yɔcɔl ya aLewy dəkəcəmɛ da yɔcɔl ya Yisrayel. ALewy, akemi ŋɔ ŋayɔnɛ. MARIKI iyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Afum masar mɛrəŋ wəco camət-mɛrəŋ kɔ maas (273) ŋancepərər kəlɔm ka aLewy. Mɛnɛ pawurus ŋa, ");
INSERT INTO bsp_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","məwer nwɛ o nwɛ pəsam gbeti kəcamət, potubucɛ pa nde aŋgbip ŋosoku, mpɛ o mpɛ kəram wəco. ");
INSERT INTO bsp_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Məsɔŋ pəsam papɔkɔ Aruna kɔ awut ɔn, teta kəway ka kəwurus ka kəlɔm ka aLewy akɔ kəncepərər mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kɔ Musa ewerəs gbeti babɔkɔ, kəwurus ka afum akɔ ŋanacepərər dɛlay da aLewy mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kɔ Musa ɛlɛk gbeti ba awut acɔkɔ-cɔkɔ aYisrayel: Pəsam gbəleŋ wul win, masar maas wəco camət-tin kɔ kəcamət (1.365), pəmɔ potubuc pa nde aŋgbip ŋosoku. ");
INSERT INTO bsp_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Kɔ Musa ɔsɔŋ gbeti babɔkɔ ɛnawerəs mɔ Aruna kɔ awut ɔn arkun pəmɔ tɔkɔ MARIKI ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Məlɔm aKehat arkun aLewy dacɔ, dəcor kɔ dəwɔlɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kəyɛfɛ aŋɛ ŋasɔtɔ meren wəco maas kəbəp ka meren wəco kəcamət mɔ (30-50), aŋɛ o aŋɛ ŋantam kəbəc tɛbəc tɔlɔma nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Awa, yɛbəc ya yuruya ya Kehat nde d'aŋgbancan ŋɛbəpɛnɛ kɔ Kanu yɔ nyɛ: Ŋa ŋatɔmpər teta ca yosoku nyɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kɔ aYisrayel ŋandecepɛ-ɛ, Aruna kɔ awut ɔn arkun ŋanuŋkɛnɛ ŋader ŋaliŋ kəloto kəkəŋkɛ, ŋagbəpər kaŋkəra nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ŋadeŋər ki kəroŋ kəloto ka akata ŋa antempeli, kɔ tɛyɛfɛ dənda-ɛ ŋaperi ki kəroŋ kəloto ka alom ŋa məntambɛnc. ");
INSERT INTO bsp_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ŋaperi kəloto ka alom ŋa məntambɛnc amɛsa ŋa cəcom cəloŋnɛ kəroŋ, ŋacəmbər ki kəroŋ pəlet, mɔmbəl, mapan kɔ mɔpɔt moloŋnɛnɛ wɛn. Ŋaccəmbər di cəcom ncɛ pəmar pacsɔŋ im tɛm fəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ŋakumpɛ yayɔkɔ fəp kəloto ka alom ŋeyim ŋadeŋər ki kəloto ka akata ŋa antempeli, kɔ telip-ɛ, ŋasor ki cəgbo cəlɛkɛ ca ki. ");
INSERT INTO bsp_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ŋalɛk kəloto ka alom ŋa məntambɛnc ŋakumpɛ pɛdɛtɛ səlamp kɔ səlamp sa pi kəyɛfɛ macaŋk, map mɛkayɛ meken kɔ yɛbɛrɛ ya moro mmɛ ambəcɛ dəndo aŋgbancan mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ŋakumpɛ ca yayɔkɔ kəloto ka akata ŋa antempeli, ŋadɛtər ki cəgbo mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ŋaperi kəloto ka alom ŋa məntambɛnc tetek toloŋnɛ ta kɛma, ŋakumpɛ ki akata ŋa antempeli, ŋadɛtɛ yi cəgbo cəkɔ aŋsor cəlɛkɛ ca kaŋkəra mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ŋalɛk yosumpər-sumpər yɔkɔ ambəcɛ dəndo deŋgbip mɔ fəp, ŋanɛpsərɛ yi kəloto ka alom ŋa məntambɛnc, ŋakumpɛ yi akata ŋa antempeli, ŋadɛt yi dəcəgbo mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ŋacliŋ kəbof ka dənɛnc tetek pɔcɔfɛ MARIKI suray, kɔ ŋalip-ɛ, ŋaperi kəloto ka alom ŋa məntambɛnc tetek toloŋnɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ŋadeŋ yosumpər-sumpər yayɔkɔ ambəcɛ di mɔ fəp, kəlɛk carɔrɔ, bak, pel kɔ səpɔt səpɔŋ, yosumpər-sumpər ya tetek toloŋnɛ fəp, ŋakumpɛ yi akata ŋa antempeli. Kɔ telip-ɛ, ŋasor cəgbo cəlɛkɛ ca ki. ");
INSERT INTO bsp_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Kɔ ŋayɛfɛ kəcepɛ-ɛ, Aruna kɔ awut ɔn arkun ŋader kəgbəpər aŋgbip ŋosoku kɔ yosumpər-sumpər ya di fəp, awut a Kehat ŋader ŋalɛk aŋgbip ŋosoku, mba ta ŋagbuŋɛnɛ ŋi de, ntɛ tɔŋsɔŋɛ ta ŋafi mɔ. Yɛbəc ya awut a Kehat yɔ yayɔkɔ nde d'aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Elasar wan wərkun wəka Aruna wəloŋnɛ, nkɔn ɔtɔmpər kəmɔmən ka moro ma səlamp, suray səbotu ambɔnc, mɛŋgbɛn mmɛ aŋloŋnɛ MARIKI tɛm o tɛm mɔ, kɔ moro mɔbɔy. Nkɔn ɔtɔmpər kəbum ka dəkiyi dosoku kɔ daka dɔkɔ deyi di disrɛ mɔ fəp, kɔ yosumpər-sumpər ya dəndo aŋgbip ŋosoku.» ");
INSERT INTO bsp_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Ta nəcopər kusuŋka ka aLewy cor ca Kehat. ");
INSERT INTO bsp_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Nəyɔnɛ ŋa tatɔkɔ, tɔŋsɔŋɛ ŋa kətɔfi kɔ ŋandekɔ kəlɔtərnɛ kəgbuŋsərɛnɛ ca yosoku nyɛ ampusɛ MARIKI mɔ. Aruna kɔ awut ɔn arkun ŋander ŋacəmbər nwɛ o nwɛ yɛbəc yɔn gbəcərəm kɔ ca yɔkɔ pəmar wəkayi pəsarɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ta ŋabɛrɛ sona deŋgbip ŋosoku ali tɛm tepic kəmɔmən ka ca yopus. Kɔ ŋayɔ ti-ɛ, ŋaŋfi.» ");
INSERT INTO bsp_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Məlɔm sɔ awut arkun a Kerson, dəwɔlɔ kɔ dəcor ");
INSERT INTO bsp_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","kəyɛfɛ aŋɛ ŋasɔtɔ meren wəco maas kəbəp ka meren wəco kəcamət mɔ (30-50), aŋɛ o aŋɛ ŋantam kəbəc yɛbəc yɔlɔma nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Yɛbəc ya kor ka Kerson yɔ yayɛ: ");
INSERT INTO bsp_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ŋa ŋantɔmpər cəloto cəŋɛrɛ ca dəkəyi dosoku kɔ ca aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, kəloto kəkumpɛ ka ŋi kɔ akata ŋa antempeli ŋɔkɔ andeŋər ki kəroŋ, kɔ kəloto kəkumpɛ kəŋkɔ kəyi dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Cəloto cəŋɛrɛ saŋka kɔ kəloto kəŋkɔ kəyi nde dəkəbɛrɛ da saŋka mɔ, dəkiyi dosoku fəp haŋ panɔŋkər kɔ tetek toloŋnɛ, bənda ya saŋka kɔ yosumpər-sumpər ya di, ŋa ŋatɔmpər yɛbəc yayɔkɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Kəsom ka Aruna kɔ awut ɔn arkun kɔ yuruya ya Kerson yɔ ŋande ŋacbəc, ntɛ tɔyɔnɛ yɛsarɛ kɔ yɛbəc mɔ, yuruya ya Kerson yende yoloku ŋa tɔkɔ pəmar ŋa kətɔmpər, tɔkɔ pəmar ŋabəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Tatɔkɔ tɔyɔnɛ yɛbəc ya kor ka Kerson nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, Itamar wan wərkun wəka Aruna wəloŋnɛ pəcmɔmən yɛbəc yaŋan.» ");
INSERT INTO bsp_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","MARIKI pəcloku Musa: «Məlɔm arkun a yuruya ya Merari dəcor kɔ dəwɔlɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","kəyɛfɛ aŋɛ ŋasɔtɔ meren wəco maas kəbəp ka meren wəco kəcamət mɔ (30-50), aŋɛ o aŋɛ ŋantam kəbəc yɛbəc ya nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Yɛbəc nyɛ yɔyɔnɛ yaŋan, ŋade ŋacgbaŋnɛ ca fəp ya aŋgbancan ŋɛbəpɛnɛ kɔ Kanu: Fərɛm fa dəkiyi dosoku, cəgbo, mogbu kɔ yɛcəmɛnɛ ya di, ");
INSERT INTO bsp_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","mogbu mamɔkɔ mɛŋkɛl saŋka mɔ kɔ yɛcəmɛnɛ ya mi, cəgbo kɔ bənda, yosumpər-sumpər fəp kɔ ca yɔkɔ yɔyɔnɛ yɛbəcɛ ya yi mɔ fəp. Aloŋnɛ ŋalɔmər ŋa tin tin mewe ma ca yɔkɔ pəmar ŋa kətɔmpər mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tatɔkɔ tɔyɔnɛ yɛbəc ya kor ka Merari, yɛbəc yaŋan nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu fəp, Itamar wan wərkun wəka Aruna wəloŋnɛ pəcmɔmən yi.» ");
INSERT INTO bsp_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, Aruna kɔ akiriŋ a kəloŋkanɛ ka afum a Yisrayel ŋalɔm arkun a kor ka Kehat dəcor kɔ dəwɔlɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","aŋɛ ŋanasɔtɔ meren wəco maas kəbəp ka meren wəco kəcamət mɔ (30-50), aŋɛ o aŋɛ ŋantam kəbəc yɛbəc yɔlɔma nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Afum aŋɛ analɔm ŋa dacɔ dəcor mɔ, ŋanayi wul mɛrəŋ, masar camət-mɛrəŋ wəco kəcamət (2.750). ");
INSERT INTO bsp_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Afum akaŋɛ ŋanalɔm kor ka Kehat dacɔ, afum akɔ ŋancbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. Musa kɔ Aruna ŋalɔm ŋa kəsom ka MARIKI disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Arkun aŋɛ analɔm awut a Kerson dacɔ dəcor kɔ dəwɔlɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","aŋɛ ŋasɔtɔ meren wəco maas kəbəp ka meren wəco kəcamət mɔ, aŋɛ o aŋɛ ŋantam kəbəc yɛbəc yɔlɔma nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","arkun aŋɛ analɔm ŋa dacɔ dəcor kɔ dəwɔlɔ mɔ, ŋanayi wul mɛrəŋ, masar camət-tin wəco maas (2.630). ");
INSERT INTO bsp_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Afum akaŋɛ ŋanalɔm kor ka Kerson dacɔ, arkun akɔ ŋancbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. Musa kɔ Aruna ŋalɔm ŋa kəsom ka MARIKI disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Arkun aŋɛ analɔm nde kor ka Merari dəcor kɔ dəwɔlɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","aŋɛ ŋanasɔtɔ meren wəco maas haŋ meren wəco kəcamət mɔ, afum aŋɛ ŋancbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","aŋɛ analɔm ŋa dacɔ dəcor mɔ, ŋanabəp wul maas, masar mɛrəŋ (3.200). ");
INSERT INTO bsp_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Afum akaŋɛ ŋanalɔm awut arkun a Merari dacɔ. Musa kɔ Aruna ŋalɔm ŋa kəsom ka MARIKI disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ALewy aŋɛ Musa, Aruna kɔ akiriŋ aYisrayel ŋanalɔm dəcor kɔ dəwɔlɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","aŋɛ ŋanasɔtɔ meren wəco maas haŋ kəbəp meren wəco kəcamət mɔ, afum aŋɛ ŋanctam kəbəc kɔ kəsarɛ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ");
INSERT INTO bsp_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","aŋɛ analɔm ŋa dacɔ mɔ fəp, ŋanabəp afum wul camət-maas, masar kəcamət kɔ wəco camət-maas (8.580). ");
INSERT INTO bsp_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","K'alɔm ŋa pəmɔ tɔkɔ MARIKI ɛnasom Musa, pəcmentər nwɛ o nwɛ yɛbəc yɔn. K'alɔm ŋa kəsom ka MARIKI disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Məsom aka Yisrayel, ŋawurɛ afum aŋɛ ŋayɔ docu dɛcalərnɛ da akata mɔ fəp saŋka səŋan disrɛ, ŋawurɛ sɔ nwɛ o nwɛ ɔyɔ docu dəkəsɔtɛ dɔn dɛcgbələr domun, ŋawurɛ sɔ nwɛ o nwɛ ɔtɔsɔk teta defi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Pəyɔnɛ wərkun, pəyɔnɛ wəran nəwurɛ kɔ saŋka disrɛ ntɛ tɔŋsɔŋɛ ta ŋayik-yikəs saŋka səŋan nde iyi ŋa dacɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Kɔ aka Yisrayel ŋayɔ tatɔkɔ, ŋawurɛ atɔsɔk dəsaŋka. Kɔ aYisrayel ŋayɔ tɔkɔ MARIKI ɛnaloku Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Məloku aYisrayel: Kɔ wərkun kɔ pəyɔnɛ fɛ ti wəran enciya wəkos fum kiciya nkɛ kəyɔnɛ kəgbɛkəl ka MARIKI mɔ, fum wəkakɔ ɛŋsarɛ kiciya nnɔ MARIKI eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Pəcɛŋ gbasŋa kiciya kɔn, pəsɔŋ kəway ka paka papɔkɔ məlməl, a pədeŋər sɔ alamali nŋɛ wəloŋnɛ omboncər kɔ mɔ, pasɔŋ kəway kɔ alamali wəkɔ anciya mɔ teta kəlompəs ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Kɔ tɔyɔnɛ fum wəkakɔ enciya mɔ efi, mba ta ɔyɔ wəkomɛnɛ wəgbəcɛnɛ nwɛ antam kəsɔŋ daka dolompsɛ da kiciya kɔn mɔ-ɛ, wəloŋnɛ pəmar pasɔŋ daka dadɔkɔ pətubucnɛ kəsɔŋ di ina MARIKI, wəciya pəkɛrɛ aŋkesiya ŋorkun teta kəloŋnɛ ka kəlompəs ka kiciya. Wəloŋnɛ pətubucnɛ kəsɔkəs kɔ kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Mpɛ o mpɛ ambelər yoloŋnɛ ya aka Yisrayel mɔ, wəloŋnɛ wəkɔ aŋkɛrɛ poloŋnɛ papɔkɔ mɔ, ɔyɔ pi. ");
INSERT INTO bsp_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ca yopus nyɛ aŋkɛrɛ MARIKI mɔ, wəloŋnɛ ɔyɔ yi.» ");
INSERT INTO bsp_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Məloku aYisrayel, məloku ŋa: Kɔ wərkun ɔyɔ wəran nwɛ ɔŋyɔ kɔ cəmpənpən, ta ɔsɔkɛ kɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kɔ wərkun wəlɔma ɛfəntərər wəran wəkakɔ ta wos ɛncərɛ ti, wəran wəkakɔ eyik-yikəsnɛ kəgbɔpnɛ disrɛ, ta fum o fum ɔyɔnɛ ti sede, ta fum o fum osumpər kɔ tɔyɔ tatɔkɔ disrɛ, ");
INSERT INTO bsp_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","k'ɔyɔnɛ ti kəraca, k'ɔyɔnɛ wəran kɔn kəraca, kɔ tɔyɔnɛ kance kɔ, kɔ tɔyɔnɛ kəraca nkɛ ɔyɔnɛ wəran kɔn mɔ yem yɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","awa wərkun wəkakɔ pəkekərɛ wəran kɔn ndena wəloŋnɛ kɔ kəmbefe ka mɛŋgbɛn ma ɔrs kilo kəmaas, ta pəloŋər ki moro, ta pədeŋər sɔ suray, bawo kəloŋnɛ teta kəraca kɔ, kəloŋnɛ nkɛ kəcɛm-cɛməs kiciya nkɛ kəncepər mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Wəloŋnɛ pəcəmbər wəran wəkakɔ MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Wəloŋnɛ pəlɛk domun dopus dətɔbɔl. Wəloŋnɛ pəwɛt kəbof dəntɔf ka dəndo dəkiyi dosoku, pəbɛr ki domun dadɔkɔ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Wəloŋnɛ pəcəmbər wəran wəkakɔ MARIKI fɔr kiriŋ, pəperi kɔ cəfon, pəbɛr kɔ dəwaca poloŋnɛ pa mɛŋgbɛn pa kəraca papɔkɔ pɛcɛm-cɛməsɛ, wəloŋnɛ nkɔn pətɔmpər domun dodokət da kətolanɛ pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Wəloŋnɛ pəloku wəran wəkakɔ kədɛrəm: ‹Kɔ tɔyɔnɛ nəfəntərɛ fɛ kɔ wərkun nwɛ o nwɛ, ntɛ məlɔ mɔ, məŋgbɔpnɛ fɛ wos əm məyik-yikəsnɛ-ɛ, domun dodokət da kətolanɛ pəlɛc dandɛ dɔfɔyɔ'm tɔlɔm o tɔlɔm tɛlɛc. ");
INSERT INTO bsp_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mba kɔ tɔyɔnɛ, ntɛ məlɔ mɔ, məŋgbɔpnɛ kɔ nəfəntərɛ kɔ wərkun wəcuru, kɔ tɔsɔŋ'am kətɔsɔk-ɛ,› ");
INSERT INTO bsp_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","wəloŋnɛ pəloku wəran wəkakɔ kədɛrəm, pəloku wəran: ‹MARIKI pəpoc'am pəlɛc afum am dacɔ, MARIKI pəsumpər əm dokombəra, pəyams'am kəkom, ");
INSERT INTO bsp_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","domun dandɛ dɔŋsɔŋ pəlɛc mɔ, dosumpər əm dokombəra dɛyams'am kəkom.› Wəran pəloku: ‹Iwosɛ, teyi tatɔkɔ!› ");
INSERT INTO bsp_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Wəloŋnɛ pəcic kətolanɛ pəlɛc kaŋkɔ dəwalakɛ kəroŋ, k'elip-ɛ, pənimɛ yecicəs yayɔkɔ domun dodokət da kətolanɛ pəlɛc dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Pəsɔŋ wəran domun dadɔkɔ pəmun di, dotor kɔ dəkor dɔsɔŋ kɔ pəlɛc. ");
INSERT INTO bsp_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Wəloŋnɛ pəbaŋər wəran nwɛ poloŋnɛ pa mɛŋgbɛn pa kəraca. Wəloŋnɛ pətubucnɛ kəsɔŋ yi MARIKI a pədekekərɛ nde dətetek poloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Wəloŋnɛ pəwɛt aŋkulma katin ŋa poloŋnɛ pa mɛŋgbɛn teta kəcɛm-cɛməs, pəcɔfɛ pi MARIKI nde tetek toloŋnɛ kəroŋ, kɔ tencepər-ɛ, a pədesɔŋ wəran domun dadɔkɔ kəmun. ");
INSERT INTO bsp_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kɔ wəran elip kəmun domun dadɔkɔ, tɔyɔnɛ eyik-yikəsnɛ kəgbɔpnɛ disrɛ, ŋafəntərɛ kɔ wərkun wəcuru-ɛ, domun dadɔkɔ dontor kɔ dəkor dɔsɔŋ kɔ pəlɛc, dosumpər kɔ dokombəra, dɛyamsɛ kɔ kəkom. Wəran nwɛ pəsɔtɔ pəlɛc awɛnc aŋa dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mba kɔ tɔyɔnɛ wəran nwɛ eyik-yikəsnɛ fɛ-ɛ, wəran wəsoku ɔfɔ, yem y'amboncɛ kɔ, endekom pəsɔtɔ yuruya. ");
INSERT INTO bsp_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Sariyɛ sasɔkɔ səyɔnɛ sa kəraca, kɔ wəran ɔlɔ, pəkafəlɛ pəgbɔpnɛ ŋafəntərɛ kɔ wərkun wəcuru-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","sariyɛ sasɔkɔ səŋkɔt sɔ nnɔ wərkun nwɛ ɔŋyɔnɛ wəran kɔn kəraca yem disrɛ mɔ. Kɔ wərkun eŋkekərɛ wəran kɔn MARIKI fɔr kiriŋ, wəloŋnɛ pəyɔ wəran sariyɛ saŋsɛ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Kiciya nkɛ o nkɛ kəyi fɛ wərkun, mba wəran ɛsarɛ kiciya kɔn, kɔ tɔyɔnɛ a kance kɔ-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Məloku aka Yisrayel, məloku ŋa: Kɔ wərkun kɔ pəyɔnɛ fɛ ti wəran, ɛndɛrəm kəpusnɛ kəsɔŋnɛ ina MARIKI-ɛ, kədɛrəm ka kəŋɛrnɛ kɔ, ");
INSERT INTO bsp_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ta fum wəkakɔ pəmun sɔ wɛn kɔ yomunəs ya maŋkɔntɔ, ta pəmun məncɔncɔ ma yokom ya wɛn, ta pədi yowosu ya yokom ya wi ");
INSERT INTO bsp_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","mata mɔkɔ eŋyi kəŋɛrnɛ disrɛ mɔ fəp, ta pədi paka mpɛ o mpɛ pɛŋyɛfɛ dəwɛn mɔ, kəyɛfɛ mɛŋgbɛn ma wi haŋ abomba ŋa wi. ");
INSERT INTO bsp_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Mata mɔkɔ ɛndɛrəm kəyi kəŋɛrnɛ disrɛ teta MARIKI mɔ fəp, ta pafon kɔ domp haŋ tɛm ta kəpusnɛ kɔn telip. Ɔyɔnɛ fum wəcempi, pəsak cəfon cɔn cəpoŋ yɛŋən. ");
INSERT INTO bsp_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Mata mamɔkɔ ɛndɛrəm kəŋɛrnɛ teta MARIKI mɔ disrɛ, ta pəlɔtərnɛ wəfi, ");
INSERT INTO bsp_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","tɔyɔnɛ kəbel ka kas, ka kɛrɛ, ka wɛnc wərkun, ka wəkirɛ kɔn ta tɔsɔŋɛ kɔ kətɔsɔk, bawo docoku dɔn domp dementər a wəŋɛrnɛ wəka Kanu ɔyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Mata mɔkɔ eŋyi kəŋɛrnɛ disrɛ mɔ fəp, wəpusnɛ wəka MARIKI ɔyɔnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kɔ tɔyɔnɛ fum pəfi kɔ kəsək gbəncana babɔkɔ, tɔsɔŋɛ kɔ kələsər kədɛrəm kɔn ka kəŋɛrnɛ-ɛ pəfonnɛ sɔ dɔsɔk dɔn da kəsɔkəsnɛ, tataka ta camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Tataka ta camət-maas pəkɛrɛ mɔpay mɛrəŋ kɔ pəyɔnɛ fɛ ti ntantoriya mɛrəŋ wəloŋnɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Wəloŋnɛ pəloŋnɛ pin teta kəloŋnɛ ka kiciya, pəloŋnɛ pɔkɔ teta poloŋnɛ mpɛ ancɔfɛ MARIKI mɔ, pətubucnɛ kəsɔkəs kɔ kətɔsɔk kɔn teta kəgbuŋɛnɛ ka wəfi. Dɔsɔk dadɔkɔ, pəgbɔkərɛ sɔ kəpusnɛ domp. ");
INSERT INTO bsp_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Wəkayi pəgbɔkərɛ sɔ kəpusnɛ MARIKI mata mɔn ma kəŋɛrnɛ. Fum wəkakɔ pəkɛrɛ aŋkesiya ŋorkun ŋa teren tin teta kəloŋnɛ ka kəlompəs ka kiciya. Afɔlɔm mata mɔkɔ mencepər mɔ, bawo defi dɛnaləsər kəŋɛrnɛ kɔn teta MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Sariyɛ nsɛ səyɔnɛ sa aŋɛ ŋandɛrəm kəŋɛrnɛ teta MARIKI mɔ. Dɔsɔk ndɛ kədɛrəm kɔn ka kəŋɛrnɛ kəŋlip mɔ, pakekərɛ kɔ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Pəkɛrɛ MARIKI poloŋnɛ pɔn: Aŋkesiya ŋorkun ŋa teren tin ŋɔtɔyɔ dolokəp teta poloŋnɛ mpɛ ancɔfɛ MARIKI mɔ, aŋkesiya ŋɛran ŋa teren tin ŋɔtɔyɔ dolokəp teta kəloŋnɛ ka kiciya, kɔ aŋkesiya ŋorkun ŋin ŋɔtɔyɔ dolokəp teta kəloŋnɛ ka kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Pəkɛrɛ sɔ kəfala kin ka cəcom cətɔnɔŋkəl lebin, cəcom cəlok-lok ca kəmbefe kətɔt papɔckɛ ki moro, kɔ biskit bɔtɔnɔŋkəl lebin pasopət bi moro. Pədeŋər sɔ yoloŋnɛ yaŋan ya mɛŋgbɛn kɔ ya wɛn. ");
INSERT INTO bsp_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Wəloŋnɛ pəkɛrɛ yoloŋnɛ yayɔkɔ fɔr ya MARIKI kiriŋ, pəloŋnɛ poloŋnɛ pa kiciya kɔ mpɛ ancɔfɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Pəkɛrɛ MARIKI aŋkesiya ŋorkun teta kəloŋnɛ ka kəpaŋnɛ pəforu, pədeŋər kəfala ka cəcom cətɔnɔŋkəl lebin. Wəloŋnɛ pəkɛrɛ kəloŋnɛ kɔn ka mɛŋgbɛn kɔ ka wɛn, ");
INSERT INTO bsp_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","wədɛrəm kəŋɛrnɛ pəfonnɛ cəfon ca kəŋɛrnɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, pəlɛk cəfon cɔn ca kəŋɛrnɛ cacɔkɔ, pəbɛr ci dəndo dənɛnc da kəloŋnɛ ka kəpaŋnɛ pəforu dɔkɔ deyi kəmar mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Wəloŋnɛ pəlɛk kəbanca ka aŋkesiya ŋorkun ŋɔkɔ ampɛc mɔ, kəcom kəlok-lok kin kətɔnɔŋkəl lebin nde kəfala disrɛ kɔ biskit bɔtɔnɔŋkəl lebin, pəbɛr yi wədɛrəm kəŋɛrnɛ dəwaca, tɔyɔnɛ wədɛrəm kəŋɛrnɛ elip kəfonnɛ cəfon cɔn ca kəŋɛrnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Wəloŋnɛ pətubucnɛ kəsɔŋ yi MARIKI fɔr kiriŋ. Ca yopus yɔ, nyɛ yɔyɔnɛ ya wəloŋnɛ mɔ, kəlɛkɛnɛ ka kəmpəcpəc kaŋkɔ antubucnɛ kəsɔŋ MARIKI, kɔ aləŋk ŋɔkɔ aŋwurɛ mɔ, kɔ telip oŋ-ɛ, sariyɛ səŋwosɛ kɔ sɔ kəmun wɛn. ");
INSERT INTO bsp_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Sariyɛ sasɔkɔ səyɔnɛ sa wəŋɛrnɛ nwɛ ɛndɛrəm kəsɔŋnɛ MARIKI mɔ. Yoloŋnɛ yayɔkɔ y'oloŋnɛ MARIKI teta kəŋɛrnɛ kɔn, k'ɛntam kəyɔ tɔlɔm pəcepər tatɔkɔ-ɛ, aŋwosɛ kɔ ti, mba mɛnɛ pənuŋkɛnɛ kəleləs kədɛrəm kɔn, pəmɔ tɔkɔ sariyɛ sa kəŋɛrnɛ səloku ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Məloku Aruna kɔ awut ɔn arkun, ntɛ tɔ pəmar nəde nəctolanɛ aka Yisrayel pətɔt, nəcloku ŋa: ");
INSERT INTO bsp_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹MARIKI pəpoc'am, pəbumɛn'am! ");
INSERT INTO bsp_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","MARIKI pəgbətn'am, pəyɔnɛ nu nɔnɔfɔr! ");
INSERT INTO bsp_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","MARIKI pəyektər əm kəro kɔn, pəsɔŋ əm pəforu!› ");
INSERT INTO bsp_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Kɔ aloŋnɛ ŋandebonc tewe tem kətolanɛ aka Yisrayel pəmɔ ntɛ ilɔmər ŋa mɔ-ɛ, ina MARIKI impocɛ ŋa pətɔt.» ");
INSERT INTO bsp_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Dɔsɔk ndɛ Musa ɛnalip kəcəmbər dəkiyi dosoku mɔ, k'ompus di pəcbɔy di moro kɔ yosumpər-sumpər ya di fəp. K'ɔyɔ tin tayi tetek toloŋnɛ kɔ yosumpər-sumpər ya di fəp, k'ɔmbɔy yi k'ompus sɔ yi. ");
INSERT INTO bsp_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Awa kɔ akiriŋ a Yisrayel, akiriŋ a wɔlɔ disrɛ ŋaŋkɛrɛ yoloŋnɛ yaŋan. Akiriŋ aka dəcusuŋka akakɔ ŋanalɔm aYisrayel mɔ, ŋanakɛrɛ yi. ");
INSERT INTO bsp_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Kɔ ŋaŋkɛrɛ yoloŋnɛ yaŋan MARIKI fɔr kiriŋ: Cibil camət-tin ncɛ cəna wəco kɔ mɛrəŋ cəncliŋəs mɔ, wəkiriŋ o wəkiriŋ ɛnasɔŋ wana win, akiriŋ mɛrəŋ ŋancpaŋnɛ kəsɔŋ abil ŋin. Kɔ ŋaŋkɛrɛ ci nde dəkəbɛrɛ dəkiyi dosoku tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Məbaŋər ŋa yoloŋnɛ yaŋan ntɛ tɔŋsɔŋɛ pacbəcɛ yi nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Məbɛr yi aLewy dəwaca, aŋɛ o aŋɛ kɔ yɛbəc yaŋan.» ");
INSERT INTO bsp_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Kɔ Musa ɛlɛk cibil kɔ cəna k'ɔsɔŋ ci aLewy. ");
INSERT INTO bsp_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","K'ɔsɔŋ cibil mɛrəŋ kɔ cəna maŋkəlɛ awut arkun a Kerson, kətubcɛnɛ ka yɛbəc yɔkɔ ŋayɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","K'ɔsɔŋ cibil maŋkəlɛ kɔ cəna camət-maas awut arkun a Merari, kətubcɛnɛ ka yɛbəc yɔkɔ ŋayɔ mɔ, kəmɔmən ka Itamar wan wərkun wəka wəloŋnɛ Aruna disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mba ɛnasɔŋ fɛ awut a Kehat, ntɛ yɛbəc ya akakɔ yɛnayɔnɛ ya ca yopus mɔ, kɔ ntɛ pəmar ŋagbaŋnɛ yi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kɔ akiriŋ ŋaŋkɛrɛ yoloŋnɛ yopusɛ ya tetek toloŋnɛ dɔsɔk dɔbɔy da pi. Kɔ ŋaŋkɛrɛ yi fɔr ya MARIKI kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kɔ MARIKI oloku Musa: «Akiriŋ ŋacder akin akin dɔsɔk o dɔsɔk wəkin pəkɛrɛ yoloŋnɛ yɔn teta kəpus ka tetek toloŋnɛ tofu.» ");
INSERT INTO bsp_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Dɔsɔk dɔcɔkɔ-cɔkɔ, ta kusuŋka ka Yuda, Nasɔŋ wan ka Aminadab ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Yopocɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300), kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta kəloŋnɛ ka mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","tura tin, aŋkesiya ŋorkun, k'aŋkesiya ŋorkun ŋa teren tin teta yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Nasɔŋ wan ka Aminadab ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Dɔsɔk da mɛrəŋ, ta kusuŋka ka Isakar, wəkiriŋ kəŋan Netaneyel wan ka Cuwar ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Kɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) mɔ, palas ŋi suray, ");
INSERT INTO bsp_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","tura tin, aŋkesiya ŋorkun, aŋkesiya ŋorkun ŋa teren tin teta yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Netaneyel wan ka Cuwar ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Dɔsɔk da maas, wəkiriŋ ka aka Sabulon, Eliyab wan ka Heloŋ ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100), pəlas ŋi suray, ");
INSERT INTO bsp_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Eliyab wan ka Heloŋ ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Dɔsɔk da maŋkəlɛ, wəkiriŋ ka aka Ruben, Elicur wan ka Sedewur ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray, ");
INSERT INTO bsp_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Elicur wan ka Sedewur ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Dɔsɔk da kəcamət, wəkiriŋ ka aka Simeyɔŋ, Selumiyel wan ka Curisaday, ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray, ");
INSERT INTO bsp_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Selumiyel wan ka Curisaday ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Dɔsɔk da camət-tin, wəkiriŋ ka aka Kadu, Eliyasaf wan ka Dewel, ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Eliyasaf wan ka Dewel ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Dɔsɔk da camət-mɛrəŋ, wəkiriŋ ka aka Efrayim, Elisama wan ka Amihud ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Elisama wan ka Amihud ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Dɔsɔk da camət-maas, wəkiriŋ ka aka Manase, Kamaliyel wan ka Pedacur ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Kamaliyel wan ka Pedacur ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Dɔsɔk da camət-maŋkəlɛ, wəkiriŋ ka aka Bɛŋyamin, Abidan wan ka Kideyoni ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Abidan wan ka Kideyoni ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Dɔsɔk da wəco, wəkiriŋ ka aka Dan, Ahiyeser wan ka Amisaday, ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Ahiyeser wan ka Amisaday ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Dɔsɔk da wəco kɔ pin, wəkiriŋ ka aka kusuŋka ka Asɛr, Pakiyel wan ka Okəraŋ, ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Pakiyel wan ka Okəraŋ ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dɔsɔk da wəco kɔ mɛrəŋ wəkiriŋ ka aka kusuŋka ka Naftali, Ahira wan ka Enan ɛnamentərnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Yoloŋnɛ nyɛ y'ɛnakɛrɛ: Apəlet ŋin nŋɛ analompsɛ gbeti kilo kin kɔ kəram masar maas (1.300) mɔ, kɔ apɔt nŋɛ analompsɛ gbeti kəram masar camət-mɛrəŋ (700) mɔ. Pəsam gbeti mpɛ o mpɛ pɛnctəŋnɛnɛ kɔ potubuc pa pəsam gbeti pa nde aŋgbip ŋosoku. Ca yayɔkɔ mɛrəŋ fəp yɛlarɛ kəmbefe kətɔt nkɛ ananɔktərɛnɛ kɔ moro teta yoloŋnɛ ya mɛŋgbɛn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","K'ɛŋkɛrɛ sɔ apɔt ŋɔlɔma nŋɛ analompsɛ kɛma kəram tasar tin (100) palas ŋi suray mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","tura tin, aŋkesiya ŋorkun ŋin, aŋkesiya ŋorkun ŋa teren tin, teta kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ambiyofo ŋin teta kəloŋnɛ ka kiciya, ");
INSERT INTO bsp_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","kɔ teta kəloŋnɛ ka kəpaŋnɛ pəforu: Mura mɛrəŋ, ŋkesiya yorkun kəcamət, mbiyofo kəcamət, ŋkesiya yorkun kəcamət ya teren tin tin. Yoloŋnɛ yayɔkɔ yɔ Ahira wan ka Enan ɛnakɛrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yoloŋnɛ yayɔkɔ yɔ akiriŋ a Yisrayel ŋanasɔŋ teta kəpus ka tetek toloŋnɛ, dɔsɔk ndɛ ambɔy pi mɔ: Pəlet wəco kɔ mɛrəŋ ya gbeti, səpɔt wəco kɔ mɛrəŋ ya gbeti, kɔ səpɔt wəco kɔ mɛrəŋ ya kɛma. ");
INSERT INTO bsp_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Apəlet nŋɛ o nŋɛ kilo kin, kəram masar maas (1.300), apɔt nŋɛ o nŋɛ kəram masar camət-mɛrəŋ (700), gbeti ba ca yayɔkɔ bɛmbəp kilo wəco mɛrəŋ kɔ maŋkəlɛ (24), pəmɔ ntɛ antubuc nde deŋgbip mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Səpɔt nsɛ wəco kɔ mɛrəŋ sa kɛma, apɔt o apɔt kəram tasar tin (100), palas ŋi suray. Delel da kɛma ka səpɔt saŋsɛ fəp dɛnabəp kilo kin kəram masar mɛrəŋ (200). ");
INSERT INTO bsp_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Yɔcɔl nyɛ anakɛrɛ teta yoloŋnɛ nyɛ anacɔfɛ MARIKI mɔ yɛnabəp: Mura wəco kɔ mɛrəŋ, ŋkesiya yorkun wəco kɔ mɛrəŋ, ŋkesiya yorkun ya teren tin tin wəco kɔ mɛrəŋ kɔ yoloŋnɛ ya mɛŋgbɛn ma yi, kɔ mbiyofo wəco kɔ mɛrəŋ ya kəloŋnɛ ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Yɔcɔl ya kəloŋnɛ ka kəpaŋnɛ pəforu: Mura wəco mɛrəŋ kɔ maŋkəlɛ (24), ŋkesiya yorkun wəco camət-tin (60), mbiyofo wəco camət-tin (60), ŋkesiya yorkun ya teren tin tin wəco camət-tin (60). Yayɔkɔ yɛnayɔnɛ yoloŋnɛ ya kəpus ka tetek toloŋnɛ, ntɛ analip pi kəbɔy mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ntɛ Musa ɛncbɛrɛ nde aŋgbancan ŋɛbəpɛnɛ kəkɔlok-loku kɔ Kanu mɔ, k'ene dim ndɛ donclok-lokər kɔ kəyɛfɛ afɛŋk ŋɔsɔksɛ kiciya nŋɛ aŋgbəpər kaŋkəra nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel mɔ. Mɛlɛkɛ kerub mɛrəŋ dacɔ, k'olok-lokər kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Məsom Aruna: Kɔ məncəmbər səlamp-ɛ, pəmar pomot pa səlamp nsɛ camət-mɛrəŋ peweŋki tekiriŋ ta pɛdɛtɛ pa si.» ");
INSERT INTO bsp_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Kɔ Aruna ɔyɔ tatɔkɔ, k'omot səlamp k'ɛncəmbər si səcmot tekiriŋ ta pɛdɛtɛ pa si, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ntɛ t'analompəs pɛdɛtɛ səlamp papɔkɔ: Kɛma kətɛmp k'anagbɛcɛ pi kəyɛfɛ pɛcəmɛnɛ pa pi haŋ yowurɛnɛ ya yɛlɛŋk. Analompəs pɛdɛtɛ pa səlamp kəsurɛnɛ tɔkɔ MARIKI ɛnamentər Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Məlɛk aLewy aYisrayel dacɔ, məpus em ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ntɛ tɔ məŋkɔpus em ŋa: Məwɛsər ŋa domun ndɛ dɔŋkɔsɔkəs ŋa kiciya mɔ, ŋafonnɛ dis fəp, ŋayak yamos yaŋan, ŋasɔkəsnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kɔ tencepər-ɛ, ŋalɛk tura kɔ yoloŋnɛ ya mɛŋgbɛn ya pi, it'ɔyɔnɛ kəmbefe kətɔt nkɛ anɔktərɛnɛ kɔ moro mɔ, məlɛk sɔ tura pa mɛrəŋ teta kəloŋnɛ ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Məkekərɛ aLewy nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, məloŋka aka Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Məcɔŋɛnɛ aLewy fɔr ya ina MARIKI kiriŋ, aYisrayel ŋadeŋ aLewy waca waŋan. ");
INSERT INTO bsp_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aruna pətubucnɛ kəsɔŋ ina MARIKI aLewy aYisrayel dacɔ, tɔyɔnɛ oŋ ŋa ŋayi yɛbəc ya ina MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ALewy ŋadeŋər waca waŋan dəsəbomp sa mura, məloŋnɛ pin teta kiciya, kɔ pa mɛrəŋ poloŋnɛ pɔcɔfɛ MARIKI teta kəsɔkəs ka kiciya ka aLewy. ");
INSERT INTO bsp_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Məcəmbər aLewy fɔr ya Aruna kɔ awut ɔn arkun kiriŋ, mətubucnɛ kəsɔŋ ŋa MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Məgbɛy aLewy kɔ aYisrayel. Ti disrɛ aLewy ŋayɔnɛ akemi. ");
INSERT INTO bsp_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Kɔ tatɔkɔ tencepər-ɛ, aLewy ŋader ŋacəmɛ yɛbəc ya nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Tatɔkɔ tɔ məŋkɔsɔkəs ŋa, mətubucnɛ sɔ kəsɔŋ ŋa ina MARIKI, ");
INSERT INTO bsp_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","bawo ampus im ŋa fəp aka Yisrayel dacɔ. Ilɛk aLewy dəkəcəmɛ da awut acɔkɔ-cɔkɔ da wəYisrayel nwɛ o nwɛ ɔyɔnɛ wan wəcɔkɔ-cɔkɔ wəka kɛrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Bawo awut acɔkɔ-cɔkɔ a Yisrayel fəp akemi ŋɔ, tɔyɔnɛ wan wəcɔkɔ-cɔkɔ wəka fum, tɔyɔnɛ wəka pɔcɔl. Dɔsɔk ndɛ inasut awut acɔkɔ-cɔkɔ atɔf ŋa Misira mɔ, d'inapusnɛ awut acɔkɔ-cɔkɔ a Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","K'ilɛk aLewy dəkəcəmɛ da awut acɔkɔ-cɔkɔ a Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Isɔŋ aLewy Aruna kɔ awut ɔn arkun aYisrayel dacɔ, ntɛ tɔŋsɔŋɛ ŋacəmɛnɛ aYisrayel yɛbəc ya nde d'aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, ŋactubucnɛ sɔ kəsɔkəs aYisrayel kiciya kəŋan. Ti disrɛ aYisrayel ŋafɔsɔtɔ pəlɛc teta kəlɔtərnɛ kəŋan aŋgbip ŋosoku.» ");
INSERT INTO bsp_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Aruna kɔ kəloŋkanɛ ka afum a Yisrayel fəp ŋasurɛnɛ kəyɔ aLewy tɔkɔ MARIKI ɛnasom Musa kəyɔ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Kɔ aLewy ŋasɔkəsnɛ kɔ ŋayak yamos yaŋan. Kɔ Aruna ontubucnɛ kəmentər ŋa MARIKI fɔr kiriŋ, k'ontubucnɛ sɔ kəsɔkəs ŋa kiciya kəŋan ntɛ tɔŋsɔŋɛ ŋasɔk oŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Kɔ tatɔkɔ tencepər-ɛ, aLewy ŋader ŋacəmɛ yɛbəc ya nde daŋgbancan ŋɛbəpɛnɛ kɔ Kanu Aruna kɔ awut ɔn arkun fɔr kiriŋ, pəmɔ tɔkɔ MARIKI ɛnasom Musa teta aLewy mɔ, tatɔkɔ t'ɛnayɔnɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Ntɛ tɔyɔnɛ ta aLewy: WəLewy wərkun nwɛ o nwɛ ɔsɔtɔ meren kəyɛfɛ meren wəco mɛrəŋ kɔ kəcamət (25) haŋ pəcepər mɔ, ɛntam kəbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","K'ɔsɔtɔ meren wəco kəcamət-ɛ (50), pəsak kəbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Wəkayi pəcmar awɛnc aŋa kɔ akakɔ ŋande kəcbum yɛbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu-ɛ, mba ta nkɔn pəbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Məyɔ tatɔkɔ nnɔ aLewy ŋayi mɔ, teta yɛbəc yaŋan nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu.» ");
INSERT INTO bsp_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nde tɛgbərɛ ta Sinayi, ŋof ŋɔcɔkɔ-cɔkɔ ŋa teren ta mɛrəŋ kəyɛfɛ kəwur ka aka Yisrayel atɔf ŋa Misira, kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«AYisrayel ŋacboc kəsata ka kəcɛm-cɛməs ka Kəcepər ka mɛlɛkɛ medif tataka ntɛ amboncɛ ki mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Nəde nəcboc kəsata kaŋkɔ tataka ta wəco kɔ maŋkəlɛ ta ŋof ŋaŋɛ, kɔ dec dendekalɛ-ɛ, nəboc ki pəmɔ tɔkɔ sariyɛ kɔ mɔyɔ mokur moŋkotərɛnɛ ki mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kɔ Musa oloku ti aYisrayel, ntɛ tɔŋsɔŋɛ ŋaboc kəsata kaŋkɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Kɔ ŋamboc kəsata kaŋkɔ tataka ta wəco kɔ maŋkəlɛ ta ŋof ŋɔcɔkɔ-cɔkɔ dec dɛckalɛ, dəndo tɛgbərɛ ta Sinayi. Kɔ aYisrayel ŋasurɛnɛ kəyɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kɔ arkun alɔma ŋayi aŋɛ ŋanatɔsɔk teta kəgbuŋɛnɛ kəŋan wəfi mɔ, a ŋafɔtam kəboc kəsata ka Kəcepər dɔsɔk dadɔkɔ. Awa, kɔ ŋaŋkɔ ŋamentərnɛ Musa kɔ Aruna dɔsɔk dadɔkɔ yati, ");
INSERT INTO bsp_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","kɔ ŋayif Musa: «Teta wəfi tɔsɔŋɛ su kətɔsɔk, t'ake tɔ səntɔtamɛ kəkɛrɛ MARIKI yoloŋnɛ dɔsɔk da kəsata dandɛ kɔ awɛnc asu aŋa a Yisrayel-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Kɔ Musa oloku ŋa: «Nəcəmɛ nnɔ, nəkar im ikɔ icəŋkəl moloku mmɛ MARIKI ɔŋkɔsom im tetonu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Məloku aka Yisrayel: Kɔ wərkun wəlɔma nəna dacɔ dɛtɛmp kɔ dɛtɛmp donu fəp, ɔntɔsɔk teta wəfi kɔ pəyɔnɛ fɛ ti pəkɔ marənt mobol-bolu-ɛ, pəbocɛ MARIKI kəsata ka kəcɛm-cɛməs Kəcepər ka mɛlɛkɛ medif. ");
INSERT INTO bsp_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ŋade ŋacboc kəsata kaŋkɔ tataka ta wəco kɔ maŋkəlɛ ta ŋof ŋa mɛrəŋ, kɔ dec dendekalɛ-ɛ, ŋasɔmɛ ki cəcom cətɔnɔŋkəl lebin kɔ bɔpər yodokət. ");
INSERT INTO bsp_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ali paka ta pasak haŋ bətbət, ta paporu sɔ ali kəbɛnt ka poloŋnɛ. Paboc kəsata ka Kəcepər kaŋkɔ pəmɔ tɔkɔ sariyɛ səloku mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kɔ wərkun ɔsɔk, ta ɔŋkɔ marənt pəfati kəboc kəsata ka kəcɛm-cɛməs ka Kəcepər-ɛ, aŋwurɛ kɔ afum ɔn dacɔ, bawo ɔsɔŋ fɛ MARIKI kəpocɛ kɔn dɔsɔk ndɛ ambonc mɔ. Wərkun wəkakɔ ɛsarɛ teta kiciya kɔn. ");
INSERT INTO bsp_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kɔ wəcikəra nwɛ eyi nu dacɔ mɔ omboc kəsata ka Kəcepər ka MARIKI-ɛ, pəmar pəsurɛnɛ tɔkɔ sariyɛ kɔ tɔkɔ asom teta ki mɔ. Sariyɛ sin sayi sɔ nəna kɔ acikəra teta kəsata kaŋkɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Dɔsɔk ndɛ ancəmbər dəkiyi dosoku ndɛ aŋwe aŋgbancan nde walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel mɔ, kɔ kəp kəŋkump di bətbət haŋ dɔfɔy. Kəyɛfɛ oŋ dɔfɔy haŋ bətbət, kɔ kəp nkɛ kəyi dəkiyi dosoku kəroŋ kəcmot pəmɔ nɛnc. ");
INSERT INTO bsp_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tatɔkɔ tɔ tencyi tɛm fəp: Kəp kəckump di, kɔ pəmbiyɛ-ɛ, pəcmot pəmɔ nɛnc. ");
INSERT INTO bsp_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tɛm o tɛm tɔ kəp kəyɛfɛ aŋgbancan kəroŋ, aYisrayel ŋancyɛfɛ ŋakɔ nde kəp kəncəmɛ mɔ, ŋancəmbər di saŋka. ");
INSERT INTO bsp_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","AYisrayel ŋancyɛfɛ kəsom ka MARIKI, ŋacndɛ kəsom ka MARIKI. Ŋancndɛ kəfo kaŋkɔ kəwon ka kəp dəkiyi dosoku kəroŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kɔ kəp kəwon dəkiyi dosoku kəroŋ-ɛ, aYisrayel ŋacəmɛ yɛbəc ya MARIKI, ŋafɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kɔ kəp kəyi dəkiyi dosoku kəroŋ mataka mepic-ɛ, aYisrayel ŋancndɛ kəfo kaŋkɔ kəsom ka MARIKI, ŋancyɛfɛ sɔ kəkɔ kəsom ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kɔ tɔyɔnɛ kəp kəyi dəkiyi dosoku kəroŋ kəyɛfɛ bətbət haŋ pibi, kɔ kəyɛfɛ di kəroŋ bətbət-ɛ, aYisrayel ŋaŋyɛfɛ kəfo kaŋkɔ. Kɔ kəp kəyɛfɛ dəkiyi dosoku kəroŋ pəwaŋkəra-ɛ, aYisrayel ŋayɛfɛ kəfo kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kɔ kəp kəyi dəkiyi dosoku kəroŋ mata mɛrəŋ, ŋof ŋin kɔ pəyɔnɛ fɛ ti teren tin-ɛ, aYisrayel ŋancndɛ, ŋafɔkɔ. Kɔ kəp kəyɛfɛ dəkiyi dosoku kəroŋ-ɛ, ŋa sɔ ŋayɛfɛ kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ŋancndɛ kəsom ka MARIKI, ŋacyɛfɛ kəkɔ kəsom ka MARIKI. AYisrayel ŋanccəmɛ yɛbəc ya MARIKI pəmɔ tɔkɔ MARIKI oncsom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Məlompəs luk mɛrəŋ ya gbeti bɛtɛmp. Luk yayɔkɔ yɔ mənde məcwenɛ kəloŋkanɛ ka afum aka Yisrayel, məcsɔŋɛ ŋa sɔ kəyekti saŋka kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","K'afula luk mɛrəŋ-ɛ, kəloŋkanɛ ka aYisrayel fəp ŋabəpsɛn'am dəntɔf nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","K'afula aluk ŋin-ɛ, abɛ kɔ akiriŋ a cusuŋka ca Yisrayel ŋambəpsɛn'am kəsək. ");
INSERT INTO bsp_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","K'afula ŋi cawon cawon-ɛ, aŋɛ ŋanacəmbər saŋka ntende dec dɛmpɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, ŋayɛfɛ ŋakɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","K'afula ŋi cawon cawon ta mɛrəŋ-ɛ, aŋɛ ŋandɛ kəca kətɔt ka aŋgbancan mɔ ŋayɛfɛ ŋakɔ. Kəkɔ nkɛ o nkɛ, aluk ŋaŋfula cawon cawon. ");
INSERT INTO bsp_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Nəfula sɔ kəbəpsɛnɛ ka kəloŋkanɛ ka aYisrayel, mba nəfɔrəs kəfula. ");
INSERT INTO bsp_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Awut arkun a Aruna, aloŋnɛ ŋande ŋacfula luk. Sariyɛ nsɛ sɔ nəndecəmɛ darəŋ doru o doru dɛtɛmp kɔ dɛtɛmp. ");
INSERT INTO bsp_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Nde atɔf ŋonu, kɔ nəndekɔ nəckɔ dəkəsutɛnɛ kɔ aterɛnɛ anu-ɛ aŋɛ ŋaŋwɛkərnɛ nu mɔ, pəmar nəfula luk cawon cawon, MARIKI Kanu konu endecɛm-cɛmnɛ tetonu, pəyac nu nnɔ aterɛnɛ anu ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Mataka monu ma pəbotu mmɛ nəmbəpsɛnɛ kəboc cəsata kɔ kəcəmɛ ka yof yonu mɔ, nəfula luk, nəkɛrɛ yoloŋnɛ yɔcɔf kɔ yoloŋnɛ ya kəpaŋnɛ pəforu yonu. Ti disrɛ, tɔŋyɔnɛ tɛcɛmcɛməs ta Kanu konu tetonu. MARIKI iyɔnɛ, Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Teren ta mɛrəŋ ta kəndɛ kəŋan tɛgbərɛ ta Sinayi, tataka ta wəco mɛrəŋ ta ŋof ŋa mɛrəŋ, kɔ kəp kəyɛfɛ dəkiyi dosoku da walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Kɔ aYisrayel ŋayɛfɛ kəcepɛ tɛgbərɛ ta Sinayi kəkɔ, kɔ kəp kəŋkɔ kəcəmɛ tɛgbərɛ ta Paran. ");
INSERT INTO bsp_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Kəyɛfɛ kəŋan kəkɔ kəcɔkɔ-cɔkɔ kənayi kaŋkɔ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Kɔ kɔlər ka saŋka sa aka Yuda dəcəgba ca asutɛnɛ, ŋayɛfɛ kəkɔ acɔkɔ-cɔkɔ. Nasɔŋ wan ka Aminadab ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Kəgba ka asutɛnɛ a kusuŋka ka Isakar, Netaneyel wan ka Cuwar ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliyab wan ka Heloŋ ɛnayɔnɛ wəkiriŋ ka kəgba ka asutɛnɛ a kusuŋka ka Sabulon. ");
INSERT INTO bsp_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","K'ancekəli dəkiyi dosoku. Aka kor ka Kerson kɔ ka Merari ŋayɛfɛ kəkɔ ŋagbaŋnɛ di. ");
INSERT INTO bsp_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kɔ kɔlər ka saŋka sa aka Ruben, dəcəgba ca asutɛnɛ ŋayɛfɛ kəkɔ. Elicur wan ka Sedewur ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Kɔ kəgba ka asutɛnɛ a kusuŋka ka Simeyɔŋ ŋayɛfɛ kəkɔ, Selumiyel wan ka Curisaday ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Kɔ kəgba ka asutɛnɛ ka kusuŋka ka Kad ŋayɛfɛ kəkɔ, Eliyasaf wan ka Dewel ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kɔ aka Kehat ŋayɛfɛ kəkɔ, ŋagbaŋnɛ yosumpər-sumpər ya aŋgbip ŋosoku nyɛ ambəcɛ di mɔ. Kɔ aLewy akɔ ŋanuŋkɛnɛ kədecaŋər-caŋər dəkiyi dosoku, ŋackar kəder ka aka Kehat. ");
INSERT INTO bsp_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kɔ kɔlər ka saŋka sa Efrayim ŋayɛfɛ kəkɔ dəcəgba ca asutɛnɛ, Elisama wan ka Amihud ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Kɔ kəgba ka asutɛnɛ a kusuŋka ka Manase ŋayɛfɛ kəkɔ, Kamaliyel wan ka Pedacur ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Kɔ kəgba ka asutɛnɛ aka Bɛŋyamin ŋayɛfɛ kəkɔ, Abidan wan ka Kideyoni ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kɔ kɔlər ka saŋka sa aka Dan ŋayɛfɛ kəkɔ dəcəgba ca asutɛnɛ, ŋa ŋanafak saŋka fəp tadarəŋ. Ahiyeser wan ka Amisaday ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Kəgba ka asutɛnɛ aka kusuŋka ka Asɛr ŋayɛfɛ kəkɔ, Pakiyel wan ka Okəraŋ ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Kəgba ka asutɛnɛ aka kusuŋka ka Naftali ŋayɛfɛ kəkɔ, Ahira wan ka Enan ɛnayɔnɛ ŋa wəkiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tantɛ tɔ cəgba ca asutɛnɛ aka Yisrayel cənacɛk kəkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Kɔ Musa oloku Hobab wan ka Rehuwel wəka Madiyaŋ papa ka wəran ka Musa: «Kəfo kɔ səŋkɔ nkɛ MARIKI oloku su: ‹Indesɔŋ nu mɔ.› Məder pakɔ səŋkɔyɔ əm pətɔt, bawo MARIKI oloku kəyɔ Yisrayel pətɔt.» ");
INSERT INTO bsp_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Kɔ wəkakɔ oloku Musa: «Ifɔkɔ. Atɔf ŋem ŋ'iŋkɔ nde aŋkom im mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kɔ Musa ɛlɛtsɛnɛ kɔ: «Ta məsak su ilɛtsɛn'am, kɔ məncərɛ sɔ mofo mmɛ səntam kəndɛ nde dətɛgbərɛ mɔ, məyɔnɛ wəsolɛ kosu. ");
INSERT INTO bsp_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kɔ mənder pakɔ-ɛ, məna sɔ məŋsɔtɔ pətɔt pɔkɔ MARIKI oloku kəyɔnɛ su mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Kɔ aka Yisrayel ŋayɛfɛ tɔrɔ ta MARIKI kəkɔ, kɔ ŋaŋkɔt mata maas. Kaŋkəra ka danapa da MARIKI kəyi ŋa kiriŋ, mata maas kəctɛnɛ ŋa dəkəŋesəm. ");
INSERT INTO bsp_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kəp ka MARIKI kəncyi ŋa kəroŋ pəwaŋkəra kɔ ŋandeyɛfɛ kəkɔ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kəyɛfɛ nkɛ o nkɛ kaŋkəra kəncyɛfɛ kəkɔ mɔ, Musa oncloku: «Məyɛfɛ MARIKI! Ater am ŋasamsər! Aŋɛ ŋanter əm mɔ, ŋayɛksɛ fɔr yam kiriŋ!» ");
INSERT INTO bsp_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Tɛm o tɛm ntɛ kaŋkəra kənccəmɛ mɔ, Musa oncloku: «Məluksərnɛ, MARIKI! Məder nnɔ cəgba ca asɔdar a Yisrayel aŋɛ ŋancepər wul wul mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Aka Yisrayel ŋaccɔpəsnɛ pəlarəm fɔr ya MARIKI kiriŋ. Ntɛ ene ti mɔ, kɔ pəntɛlɛ kɔ. Kɔ nɛnc da MARIKI dowur ŋa dacɔ, kɔ dɔncɔf saŋka kəyɛfɛ toŋkubut haŋ pa mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Kɔ aka Yisrayel ŋaŋkulɛ-kulɛ kəwe Musa kədemar ŋa. Kɔ Musa ɛlɛtsɛnɛ MARIKI, kɔ nɛnc denimɛ. ");
INSERT INTO bsp_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","K'awe kəfo kaŋkɔ tewe ta Tabera, ti tɔyɔnɛ «Kətɛyɛ», bawo nɛnc da MARIKI dɛnacɔf afum ŋa dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Dɔsɔk dɔlɔma sɔ, afum alɔma ŋanayi aYisrayel dacɔ sɛm yɛbas ŋa, kɔ aka Yisrayel yati ŋancop kəbok, ŋacloku: «An'endesɔŋ su sɛm yɔsɔm-ɛ? ");
INSERT INTO bsp_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Səncɛm-cɛmnɛ lop nyɛ səncsɔm kifəli Misira mɔ, kamkumbus, cəmbasoso, mɛrkɛt, ces kɔ yowurɛnɛ ya yi! ");
INSERT INTO bsp_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ndɛkəl oŋ kəfi kɔ sənder! Yeri yɔlɔma yɛmbas su, mba fɔr yosu yɔfɔnəŋk paka o paka mɛnɛ yeri ya man gbəcərəm!» ");
INSERT INTO bsp_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Awa, man mɛnawurɛnɛ kɔ mɛŋgbɛn mefer. ");
INSERT INTO bsp_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Aka Yisrayel ŋancsamsər kəwɛtəs ka mi, ŋagbifəlɛ mi masar kɔ pəyɔnɛ fɛ ti-ɛ dəkirir. Dəkarɔrɔ anccoŋ mi, kɔ pəyɔnɛ fɛ ti-ɛ palompsɛ mi cəcom, mencyi dəkusu pəmɔ biskit mbɛ bɔyɔ moro mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kɔ kibi kənde kəctufər afum pibi dəsaŋka-ɛ, man moctuf. ");
INSERT INTO bsp_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Kɔ Musa ene tɔkɔ afum ŋancbokɛnɛ mɔ, nwɛ o nwɛ nde kor kɔn, nde dəkəbɛrɛ d'abal ŋɔn. Kɔ pəntɛlɛ MARIKI pəpɔŋ, kɔ pəntɔbɔt sɔ Musa. ");
INSERT INTO bsp_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Kɔ Musa eyif MARIKI: «Ta ake tɔ mənuŋksərɛ ina, wəcar kam pəlɛc pelel pampɛ-ɛ? Ta ake tɔ məntɔyɔn'em nɔnɔfɔr-ɛ, ntɛ məlɛk mes ma afum akaŋɛ fəp kɔ məsarsər im mɔ? ");
INSERT INTO bsp_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","In'olompəs afum akaŋɛ fəp ba? In'okom ŋa ntɛ məlok'im: ‹Məgbɔsnɛ ŋa pəmɔ ntɛ wəkombəra ɔŋgbɔsnɛ kənaka mɔ, haŋ nde atɔf ŋɔkɔ mənadɛrmɛ atem aŋan kəsɔŋ ŋa mɔ?› ");
INSERT INTO bsp_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Deke iŋkɔlɛk sɛm nyɛ indesɔŋ afum akaŋɛ fəp mɔ? Bawo ŋambokər im ŋacloku: ‹Məsɔŋ su sɛm səsɔm!› ");
INSERT INTO bsp_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ifɔtam ina sona kəsarɛ mes ma afum akaŋɛ fəp. Mes maŋan melelər im, ifɔtam mi kəsarɛ. ");
INSERT INTO bsp_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kɔ tɔyɔnɛ pəlɛc pelel pampɛ pɔ məndenuŋksər im-ɛ, kɔ tɔyɔnɛ məyɔn'em nɔnɔfɔr-ɛ, ilɛtsɛn'am mədif im oŋ, tɔsɔŋ'em kətɔnəŋk pəlɛc pampɛ məyi kəcəmbər im mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Kɔ MARIKI oloku Musa: «Məloŋkan'em abeki wəco camət-mɛrəŋ (70) aka Yisrayel, aŋɛ məncərɛ kəyɔnɛ abeki kɔ atubuc mes a afum mɔ. Məkɛrɛ ŋa nnɔ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ŋade ŋacəmɛ nnɔ kɔ məna. ");
INSERT INTO bsp_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Indetor di ilok-lokər əm, indebelər əm Amera ŋem ŋepic, iyer ŋa ŋi, ntɛ tɔŋsɔŋɛ ŋamar əm kəsarɛ mes ma afum akaŋɛ mɔ, tɔsɔŋ'am kətɔsɔsarɛ mi sona sam. ");
INSERT INTO bsp_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ntɛ tɔyɔnɛ ta afum mɔ, məloku ŋa: Nəpusnɛ teta alna, nəndesɔsɔm sɛm, bawo nəmbokər MARIKI, nəcloku: ‹An'endesɔŋ su sɛm nyɛ səndesɔm mɔ? Sənayinɛ pətɔt Misira!› MARIKI endesɔŋ nu sɛm nəsɔm. ");
INSERT INTO bsp_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nəndesɔm yi, bafɔ dɔsɔk din, bafɔ mata mɛrəŋ, bafɔ mata kəcamət, bafɔ mata wəco, bafɔ mata wəco mɛrəŋ, ");
INSERT INTO bsp_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mba ŋof ŋin camcam haŋ sɛm yayɔkɔ yocwur nu dəloləm, haŋ yɛgbəf nu, bawo nənce MARIKI nwɛ eyi nu dacɔ, kɔ nəmbok fɔr yɔn kiriŋ nəcloku: ‹Ta ake tɔ səwurɛnɛ Misira-ɛ?›» ");
INSERT INTO bsp_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Kɔ Musa oloku: «Afum akaŋɛ ŋaŋkɛl im mɔ ŋambəp arkun wul masar camət-tin (600.000), kɔ məloku: ‹Indesɔŋ ŋa sɛm yɔsɔm ŋof ŋin camcam!› ");
INSERT INTO bsp_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ali padifɛ afum akaŋɛ ŋkesiya, cir, kɔ cəna cosu, sɛm ya yi yɛntəŋnɛ ŋa ba? Andesɔŋ ŋa lop ya dəkəba fəp, a yɛtəŋnɛ ŋa ba?» ");
INSERT INTO bsp_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Kɔ MARIKI eyif Musa: «Kəca ka MARIKI kəndebumpsɛnɛ oŋ ba? Məndenəŋk tɔkɔ ilok'əm mɔ kɔ tɔyɔnɛ tendeyi kɔ pəyɔnɛ tɔfɔdesɔyi-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kɔ Musa owur, k'oloku afum moloku ma MARIKI. K'oloŋka abeki a Yisrayel aŋɛ wəco camət-mɛrəŋ (70), k'ɛncəmbər ŋa ŋakɛl aŋgbancan. ");
INSERT INTO bsp_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Kɔ MARIKI ontor dəkəp, k'olok-lokər Musa. Kɔ MARIKI ɛlɛk dəMusa Amera ŋɔkɔ ɛnabɛr kɔ mɔ, k'eyerəs ŋi abeki aŋɛ wəco camət-mɛrəŋ (70). Ntɛ Amera nŋɛ ŋendegbuŋɛnɛ ŋa mɔ, kɔ ŋayɛfɛ kəlok-loku cəsayibɛ, mba katin kaŋkɔ gbəcərəm kɔ tɛnasɔtɔ ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Arkun mɛrəŋ, pacwe wəkin Eldad, kɔ wəkɔ Medad, ŋaŋyi dəsaŋka, kɔ Amera nŋɛ ŋɔŋkɔ ŋogbuŋɛnɛ ŋa, afum ŋɔ, analɔm ŋa abeki a Yisrayel dacɔ, mba ŋanawur fɛ ŋakɔ dəndo aŋgbancan ŋosoku dɔsɔk dadɔkɔ, kɔ ŋayɛfɛ kəlok-loku cəsayibɛ dəndo dəsaŋka. ");
INSERT INTO bsp_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Kɔ wətɛmp wəlɔma ɛyɛksɛ kəkɔloku ti Musa: «Eldad kɔ Medad ŋayi kəlok-loku cəsayibɛ nde dəsaŋka!» ");
INSERT INTO bsp_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Kɔ Yosuwe wan ka Nun nwɛ ɛnayɔnɛ wəmarsɛnɛ ka Musa kəyɛfɛ dɛtɛmp dɔn mɔ, oloku: «Musa mariki mem, məmɔnɛ ŋa!» ");
INSERT INTO bsp_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Kɔ Musa eyif kɔ: «Kəraca kɔ məŋyɔn'em ba? Ah, MARIKI pəyerəs afum ɔn fəp Amera ŋɔn, ntɛ tɔŋsɔŋɛ ŋayɔnɛ sayibɛ mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Kɔ Musa olukus nde dəsaŋka kɔ abeki aka Yisrayel akaŋɛ. ");
INSERT INTO bsp_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kɔ MARIKI owurɛ afef nŋɛ ŋɛnayɛfɛ nde dəkəba mɔ, kɔ ŋender ŋɛgbalɛ aka Yisrayel bakɔrnɛ nde dəsaŋka kɔ cəsək ca si kəkɔt ka pəwaŋkəra pin camcam kəsək o kəsək, bɛmp yɛnadeŋsərɛnɛ dəntɔf deŋeci da kururu kəmɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Dɔsɔk dadɔkɔ fəp, kɔ pibi fəp kɔ dɔckɔsɔk, afum ŋacwɛtəs bakɔrnɛ. Nwɛ ɛnapicɛ bɛmp yɛwɛtəs mɔ, ɛnasɔtɔ tɔn tin pəcepər. Kɔ ŋancɛ yi saŋka kəsək haŋ kənɔŋkər ntɛ tɔŋsɔŋɛ yowos mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ntɛ sɛm yɛnasɔrɔyi ŋa dəcusu ta ŋantacɔkəm yi mɔ, kɔ pəntɛlɛ MARIKI nnɔ aka Yisrayel ŋayi mɔ. Kɔ MARIKI osutɛ ŋa pucuy pɔpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","K'awe kəfo kaŋkɔ Kibərot Tawa, ti tɔyɔnɛ «Kufu ka tɛbas», bawo dəndo anawup afum akɔ kəsɔm sɛm kənabas mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kɔ aka Yisrayel ŋayɛfɛ Kibərot Tawa kəkɔ ka Hacerot, kɔ ŋancəmbər di saŋka. ");
INSERT INTO bsp_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Awa, Aruna kɔ Miriyam ŋafor Musa teta wəran wəKusi wəkɔ ɛnalɛk kənɛncɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kɔ ŋaloku: «Musa gbəcərəm MARIKI olok-lokər ba? Bafɔ olok-lokər sɔ səna?» Kɔ MARIKI ene ti. ");
INSERT INTO bsp_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa fum wənatɔpɛnɛ banca ɛnayi, ɛnatorɛ banca pətas afum a doru fəp. ");
INSERT INTO bsp_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Kɔ MARIKI oloku Musa, Aruna kɔ Miriyam: «Nəwur maas monu fəp nəkɔ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Kɔ ŋaŋkɔ maas maŋan fəp.» ");
INSERT INTO bsp_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kɔ MARIKI ontor dəkəp, k'ɔŋkɔ pəcəmɛ nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ, k'ewe Aruna kɔ Miriyam, kɔ ŋancɔŋnɛ mɛrəŋ maŋan. ");
INSERT INTO bsp_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kɔ MARIKI oloku: «Nəcəŋkəl moloku mem ilɛtsɛnɛ nu! Kɔ fum eyi nu dacɔ pəyɔnɛ sayibɛ-ɛ, iŋmentərnɛ wəkayi dɔsɔk, kɔ pəyɔnɛ fɛ ti-ɛ, ilok-lokər kɔ pibi kəwɛrəp disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tenciyanɛ kɔ ta wəcar kem Musa fum nwɛ ilaŋ teta yɛbəc yem fəp mɔ ɔfɔ. ");
INSERT INTO bsp_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Dim dem yati d'iŋlok-lokərɛ kɔ gbasŋa, ifɔgbɔpnɛ kɔ, ɛŋnəŋk mɔyɔ mem mɔlɔma yati mmɛ afum ŋantɔnəŋk mɔ. Ta ake tɔ nəntɔnesɛnɛ kəfor Musa wəcar kem-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Kɔ pəntɛlɛ MARIKI nnɔ ŋayi mɔ, k'olukus. ");
INSERT INTO bsp_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kɔ kəp kəluksərnɛ sɔ aŋgbancan kəroŋ, kɔ sen səsumpər Miriyam, k'eferɛ pəmɔ ntɛ kibi kəntufər paka mɔ. Kɔ Aruna ɛŋkafəlɛ nnɔ Miriyam eyi mɔ. Sen səsumpər Miriyam dis dɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kɔ Aruna oloku Musa: «Məŋaŋnɛ, mariki mem! Ilɛtsɛn'am, ta məsarsər su kiciya nkɛ sənciya dotoŋkulu disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ilɛtsɛn'am, ta pəyi pəmɔ wan nwɛ aŋkom pəfi mɔ, nwɛ dis dɔn dɔsɔmnɛ kəsək k'endewur kɛrɛ dəkor-ɛ!» ");
INSERT INTO bsp_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kɔ Musa oloku MARIKI: «Kanu ilɛtsɛn'am mətaməs kɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Kɔ MARIKI oloku Musa: «Tɔcyɔnɛ a kas oyukər kɔ lin dəkəro-ɛ, k'eyinɛ fɛ malap mamɔkɔ haŋ mata camət-mɛrəŋ ba? Pawurɛnɛ kɔ dəsaŋka mata camət-mɛrəŋ, kɔ tencepər-ɛ, aŋluksɛ kɔ sɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","K'awurɛnɛ Miriyam dəsaŋka mata camət-mɛrəŋ. Aka Yisrayel ŋanayɛfɛ fɛ kəkɔ haŋ k'aluksɛ kɔ sɔ dəsaŋka. ");
INSERT INTO bsp_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ntɛ tencepər mɔ, kɔ aka Yisrayel ŋayɛfɛ Hacerot kɔ ŋaŋkɔ ŋandɛ nde tɛgbərɛ ta Paran. ");
INSERT INTO bsp_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Məsom afum ŋakɔtɛnəs mes yɔkyɔk atɔf ŋa Kanaŋ nkɛ isɔŋ aka Yisrayel mɔ, məyɛk-yɛk kusuŋka o kusuŋka wərkun wəkin nwɛ ɔyɔnɛ wəkiriŋ afum ɔn dacɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kɔ Musa osom afum akakɔ kəyɛfɛ ka tɛgbərɛ ta Paran, pəmɔ tɔkɔ MARIKI ɛnasom kɔ mɔ, fəp fəŋan akiriŋ ŋɔ ŋanayɔnɛ aYisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mewe maŋan mɔ mmɛ: Kusuŋka ka Ruben: Samuya wan ka Sakur. ");
INSERT INTO bsp_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kusuŋka ka Simeyɔŋ: Safat wan ka Hory. ");
INSERT INTO bsp_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kusuŋka ka Yuda: Kalɛb wan ka Yefune. ");
INSERT INTO bsp_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kusuŋka ka Isakar: Yikal wan ka Isifu. ");
INSERT INTO bsp_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kusuŋka ka Efrayim: Hose wan ka Nun. ");
INSERT INTO bsp_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kusuŋka ka Beŋyamin: Palti wan ka Rafu. ");
INSERT INTO bsp_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kusuŋka ka Sabulon: Kadiyel wan ka Sody. ");
INSERT INTO bsp_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kusuŋka ka Manase, wan ka Isifu: Kady wan ka Susy. ");
INSERT INTO bsp_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Kusuŋka ka Dan: Amiyel wan ka Kemali. ");
INSERT INTO bsp_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Kusuŋka ka Asɛr: Setur wan ka Mikayel. ");
INSERT INTO bsp_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Kusuŋka ka Naftali: Naby wan ka Wofosi. ");
INSERT INTO bsp_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kusuŋka ka Kad: Kewel wan ka Maky. ");
INSERT INTO bsp_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Afum akaŋɛ ŋɔ Musa ɛnasom kəkɔkcɛ atɔf. Kɔ Musa ewe Hose wan ka Nun tewe ta Yosuwe. ");
INSERT INTO bsp_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kɔ Musa osom ŋa kəkɔkɔkcɛ mes ma atɔf ŋa Kanaŋ, k'oloku ŋa: «Nəpɛrnɛ ta Nɛkɛf, nəkɔ nəpɛ ta dəmɔrɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Nəkɔ nəkɔkcɛ atɔf ntɛ ŋeyi mɔ: Afum aŋɛ ŋayi ŋi mɔ, kɔ tɔyɔnɛ ŋayɔ sɔkət, kɔ tɔyɔnɛ ŋayɔ fɛ sɔkət-ɛ, nəcərɛ, kɔ tɔyɔnɛ ŋala, kɔ tɔyɔnɛ ŋala fɛ. ");
INSERT INTO bsp_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Nətɛn sɔ kəcərɛ kɔ tɔyɔnɛ atɔf ŋɔtɔt ŋɔ kɔ tɔyɔnɛ atɔf ŋɛlɛc ŋɔ-ɛ, kɔ tɔyɔnɛ sədare səŋan mopoc mopoc mɔ ŋandɛ kɔ tɔyɔnɛ sədare səŋan samba səŋeci s'aŋkɛlɛ si-ɛ. ");
INSERT INTO bsp_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Nəkɔkcɛ sɔ kəcərɛ kɔ tɔyɔnɛ antɔf ŋaŋan ŋentesɛ yɔbɔf, kɔ tɔyɔnɛ ŋɔfɔtesɛ yɔbɔf-ɛ, kɔ tɔyɔnɛ atɔf ŋaŋɔkɔ ŋɔyɔ tɔk, kɔ tɔyɔnɛ ŋɔyɔ fɛ tɔk-ɛ. Nəbaŋsɛ, nəpimɛnɛ yokom ya tɔk ya atɔf ŋaŋɔkɔ, bawo tɛm ta kəpim ta yokom yɔcɔkɔ-cɔkɔ ya wɛn tɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kɔ afum akakɔ anasom mɔ ŋampɛ, kɔ ŋaŋkɔ ŋatɛnəs yɔkyɔk mes ma atɔf ŋa Kanaŋ, kəyɛfɛ tɛgbərɛ ta Cin haŋ dare da Rehob, ndɛ dɔlɔtərnɛ Lebo Hamat mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Kɔ ŋampɛrnɛ ta Nɛkɛf, kɔ ŋaŋkɔ haŋ Hebərɔŋ nde afum aŋeci yuruya ya Anak, Ahiman, Sesay kɔ Talmay, yɛnayi mɔ. Analɔ dare da Hebərɔŋ meren camət-mɛrəŋ mecepər a padelɔ dare da Coyan ca Misira. ");
INSERT INTO bsp_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kɔ ŋaŋkɔ haŋ nde dəŋgbəl da Ɛskɔl nde ŋanagbinti aŋgbɔŋkəlɔ ŋa wɛn kɔ acɛk ŋa pokom pa ŋi mɔ, kɔ ŋasɛlɛŋ yi kɔ afum mɛrəŋ ŋaŋgbaŋnɛ. Kɔ ŋampimɛnɛ sɔ yokom ya cəpare kɔ ya fik. ");
INSERT INTO bsp_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","K'awe kəfo kaŋkɔ dəŋgbəl da Ɛskɔl, ti tɔyɔnɛ cəHebəre «Acɛk» teta acɛk ŋɔkɔ aka Yisrayel ŋanapim di mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ntɛ mata wəco maŋkəlɛ (40) mencepər mɔ, k'asom ŋalukus kəyɛfɛ atɔf ŋɔkɔ ŋanakɔ kətɛnəs mes yɔkyɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ŋandebɛrɛ, kɔ ŋaŋkɔ ndena Musa, Aruna kɔ kəloŋkanɛ ka aka Yisrayel fəp aŋɛ ŋayi Kadɛs, nde tɛgbərɛ ta Paran mɔ. K'asom ŋaloku Musa kɔ Aruna kɔ kəloŋkanɛ ka aka Yisrayel fəp tɔkɔ ŋananəŋk mɔ, kɔ ŋamentərɛnɛ ŋa yokom ya tɔk ya atɔf ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kɔ ŋalɔm: «Səŋkɔ nde atɔf ŋɔkɔ mənasom su mɔ. Atɔf ŋoboŋu dalɛ k’awop yati ŋɔ. Yokom ya tɔk ya di yɔ yayɛ! ");
INSERT INTO bsp_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mba afum aŋɛ ŋayi atɔf ŋaŋɔkɔ mɔ ŋayɔ fənɔntər, sədare səŋan səmbɛk, k'aŋkɛlɛ si samba. Sənəŋk di yati yuruya ya Anak, afum aŋeci. ");
INSERT INTO bsp_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Aka Amalɛk ŋandɛ Nɛkɛf. AHit, aYebus kɔ aka Amɔr ŋandɛ dəmɔrɔ, kɔ aKanaŋ, ŋa ŋandɛ kəba kəsək kɔ gbɛp ya kəŋgbɔkɔ ka Yurdɛn.» ");
INSERT INTO bsp_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kɔ Kalɛb ɔsɔŋɛ afum kəcaŋk fɔr ya Musa kiriŋ. K'oloku: «Pakɔ pabaŋ atɔf, aŋkɔtam ŋa!» ");
INSERT INTO bsp_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mba asom alɔma akɔ ŋanakɔ kɔ ŋa mɔ, ŋaloku Musa: «Afɔtam kəkɔsutɛnɛ kɔ afum akaŋɛ, bawo ŋayɔ sɔkət ŋatas su.» ");
INSERT INTO bsp_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kɔ ŋayɛfɛ kəloku pəlɛc pa atɔf ŋaŋɔkɔ aka Yisrayel fɔr kiriŋ. Kɔ ŋaloku: «Atɔf nŋɛ sənanɔŋkər kəkɔkcɛ mes ma di mɔ, atɔf ŋɔ nŋɛ ŋendif afum aŋɛ ŋander kəndɛ di mɔ. Afum aŋɛ sənəŋk di mɔ fəp, afum aŋeci ŋɔ. ");
INSERT INTO bsp_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Afum aŋɛ sənəŋk di mɔ, ŋaŋɛc tɛcəmɛ. Aka yuruya ya Anak yɔ. K'ayi ŋa kəsək-ɛ, səŋyi pəmɔ cəntaŋgbɛ. Tatɔkɔ yati tɔ ŋancnəŋk su.» ");
INSERT INTO bsp_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Kɔ kəloŋkanɛ ka aka Yisrayel fəp ŋayɛfɛ kəkulɛ-kulɛ, kɔ ŋambok pibi fəp. ");
INSERT INTO bsp_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Kɔ aka Yisrayel ŋancɔpər Musa kɔ Aruna. Kɔ kəloŋkanɛ ka aka Yisrayel ŋaloku: «Kəfi kosu Misira kɔ pəyɔnɛ fɛ ti, kəfi kosu nnɔ dətɛgbərɛ kəncepər kəfi kosu aterɛnɛ asu dəwaca! ");
INSERT INTO bsp_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ta ake tɔ MARIKI eyi kəkekərɛ su atɔf ŋaŋɔkɔ pəkɔ pəsɔŋɛ padifɛ su sakma-ɛ? Ŋasumpər-sumpər aran kɔ aka wɔlɔ wosu disrɛ, aŋɛ andelɔm yofoŋət yaŋan dacɔ mɔ! Kəlukus kosu Misira kəncepər fɛ tatɔkɔ ba?» ");
INSERT INTO bsp_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ŋaclokɛnɛ taŋan: «Pacəmbər wəbɛ wəkin, palukus Misira!» ");
INSERT INTO bsp_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa kɔ Aruna ŋantontnɛnɛ MARIKI dəntɔf kəloŋkanɛ ka aka Yisrayel fəp fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ntɛ Yosuwe wan ka Nun kɔ Kalɛb wan ka Yefune akɔ ŋanakɔ kəkɔkcɛ mes ma atɔf ŋalip kəne moloku mamɔkɔ mɔ, kɔ pəntɛlɛ ŋa haŋ kɔ ŋawal-wali yamos yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Kɔ ŋaloku kəloŋkanɛ ka afum a Yisrayel fəp: «Atɔf ŋaŋɔkɔ sənɔŋkər kəkɔkcɛ mes ma di mɔ, atɔf ŋɔtɔt ŋɔ. ");
INSERT INTO bsp_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kɔ MARIKI ɔmbɔtər su-ɛ, ɛmbɛrsɛ su atɔf ŋaŋɔkɔ, pəsɔŋ su ŋi. Atɔf ŋɔ nŋɛ ŋomboŋ dalɛ k’awop mɔ! ");
INSERT INTO bsp_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ta payeŋkər MARIKI səbomp, ta panesɛ sɔ afum a atɔf ŋaŋɔkɔ katəna k'aŋkɔtam. Ŋayɔ fɛ sɔ katəkəp nkɛ kəŋkump ŋa mɔ. MARIKI eyi kɔ səna. Ta nənesɛ ŋa!» ");
INSERT INTO bsp_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ntɛ kəloŋkanɛ ka aka Yisrayel fəp kəloku kəca-cas Yosuwe kɔ Kalɛb mɔ, kɔ nɔrɔ da debeki da MARIKI dontor aka Yisrayel fəp fɔr kiriŋ nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Kɔ MARIKI oloku Musa: «Ake tɛm tɔ afum akaŋɛ ŋandesak kəcerəsnɛ mes mem-ɛ? Ake tɛm tɔ ŋandefati kəgbɛkər im kəlaŋ-ɛ, ali ntɛ imentər mɛgbɛkərɛ mɛwɛy-wɛy fɔr yaŋan kiriŋ mɔ? ");
INSERT INTO bsp_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Arom ŋ'indesɔŋ ŋa, ibaŋər ŋa sɔ kɛ nkɛ inaloku kəsɔŋ ŋa, mba məna indesɔŋ'am kəyɔnɛ kas ka atɔf ŋɔpɔŋ nŋɛ ŋendebɛk ŋɔyɔ sɔkət ŋɛtas aka Yisrayel mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Kɔ Musa oloku MARIKI: «Aka Misira ŋane a sɔkət sam sɔ mənapɛnɛ afum akaŋɛ atɔf ŋa Misira, ");
INSERT INTO bsp_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","kɔ ŋaloku ti afum aka atɔf ŋaŋɔkɔ. Kɔ aka Kanaŋ ŋane ntɛ: A məna MARIKI məyi afum am dacɔ, a məŋmentərnɛ ŋa gbasŋa, a məckɔt ŋa fɔr kiriŋ, məcbumɛ ŋa kəp pəwaŋkəra disrɛ, kɔ pibi disrɛ nɛnc. ");
INSERT INTO bsp_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Kɔ məndifət afum akaŋɛ fəp katin-ɛ, afum a tɔf nyɛ ŋane pacloku tetam mɔ, ŋandeloku: ");
INSERT INTO bsp_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹MARIKI ɔfɔtam kəbɛrsɛ afum akaŋɛ atɔf nŋɛ ɛnadɛrəm kəsɔŋ ŋa mɔ: Ti t'endifɛ ŋa nde dətɛgbərɛ!› ");
INSERT INTO bsp_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ndɛkəl oŋ, ilɛtsɛn'am fənɔntər fa MARIKI fəmentərnɛ debeki dɔn disrɛ pəmɔ tɔkɔ məloku ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Pəfɔtɛlɛ MARIKI katəna, k'eŋsektərnɛ danapa, ɛŋŋaŋnɛnɛ kiciya kɔ kəyeŋkər domp. Mba ɔfɔsəkpərɛ wəciya wətɔciya, pəsɔŋ kəway ka kiciya yuruya ya wəciya haŋ dɛtɛmp da maas, dɛtɛmp da maŋkəlɛ. ");
INSERT INTO bsp_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Məŋaŋnɛ kiciya ka afum akaŋɛ ilɛtsɛn'am teta kəsektərnɛ danapa kam, pəmɔ ntɛ mənalɛk kəŋaŋnɛnɛ afum akaŋɛ kəyɛfɛ Misira haŋ nnɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Kɔ MARIKI oloku: «Iŋaŋnɛnɛ ŋa teta moloku mam. ");
INSERT INTO bsp_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mba indɛrəm kəyi kem doru kɔ nɔrɔ da debeki da MARIKI ndɛ dɛlarɛ doru mɔ: ");
INSERT INTO bsp_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Afum aŋɛ ŋananəŋk nɔrɔ da debeki dem kɔ mɛgbɛkərɛ mmɛ inawurɛ Misira kɔ nde dətɛgbərɛ mɔ, mba ŋandəktər im haŋ wəco kɔ ŋantɔcəŋkəl, ");
INSERT INTO bsp_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","nwɛ o nwɛ ŋa dacɔ ɔfɔdenəŋk atɔf nŋɛ inadɛrəm kəsɔŋ atem aŋan mɔ. Ali wəkin akaŋɛ ŋanc'em mɔ ŋafɔdenəŋk ŋi. ");
INSERT INTO bsp_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mba bawo amera ŋɔlɔma ŋɛnayi Kalɛb wəcar kem k'eleləs tɔkɔ inasom kɔ mɔ ta enesərnɛ-ɛ, indekɔbɛrsɛnɛ nkɔn atɔf ŋaŋɔkɔ ɔŋkɔ mɔ, yuruya yɔn yɛbaŋ sɔ di. ");
INSERT INTO bsp_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Aka Amalɛk kɔ aKanaŋ dəmɔrɔ dacɔ ŋandɛ. Alna, nəlɛk dɔpɔ da dətɛgbərɛ kəkɔ kəca ka kəba ka Cəŋkɔlma.» ");
INSERT INTO bsp_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Kɔ MARIKI eyif Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Kəloŋkanɛ ka afum alɛc akaŋɛ tɛm tere tɔ ŋandesak kəgbɛkəl im-ɛ? Ine tɔkɔ aka Yisrayel ŋaŋgbɛkəl im mɔ! ");
INSERT INTO bsp_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Moloku ma MARIKI mɔ mamɛ! Məloku ŋa ntɛ: Indɛrəm kəyi kem doru, indeyɔ nu tɛtəŋnɛ ta moloku mɔkɔ nəloku fɔr yem kiriŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Nnɔ tɛgbərɛ tantɛ tɔ nəndefi. Nəna fəp fonu aŋɛ analɔm nəsɔtɔ meren wəco mɛrəŋ (20) haŋ kəcepər ti mɔ, kɔ nəŋgbɛkəl im mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","nəfɔdebɛrɛ atɔf nŋɛ inadot kəca idɛrəm kədəs nu mɔ. Mɛnɛ Kalɛb wan ka Yefune kɔ Yosuwe wan ka Nun gbəcərəm ŋandekɔbɛrɛ di. ");
INSERT INTO bsp_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kɔ awut anu aŋɛ nəloku: ‹Aŋkɔsak ŋa pafoŋət mɔ,› iŋkɔbɛrsɛ ŋa di, ŋa ŋandekɔcərɛ atɔf ŋaŋɔkɔ nəna nənce mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Kɔ nəna, nnɔ tɛgbərɛ tantɛ tɔ nəndefi. ");
INSERT INTO bsp_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Awut anu ŋandeyɔnɛ akɛk yɔcɔl nde dətɛgbərɛ meren wəco maŋkəlɛ (40) disrɛ, ŋa ŋandesarɛ kəway ka kiciya ka dɛyamayama donu, haŋ nəclip kəfis-fis nnɔ dətɛgbərɛ. ");
INSERT INTO bsp_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kəlɔm ka mataka mɔkɔ nənawon kəkɔkcɛ mes ma atɔf ŋa Kanaŋ yɔkyɔk mɔ, it'ɔyɔnɛ mata wəco maŋkəlɛ (40), nəndesarɛ kəciya konu meren wəco maŋkəlɛ (40), dɔsɔk o dɔsɔk teren tin. Ti tendesɔŋɛ nu kəcərɛ ntɛ kəfatər kem kəyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ina MARIKI, ilok-loku. Nəna kəloŋkanɛ ka afum alɛc kɔ nəyɔnɛ, nətəŋn'em kəroŋ. Awa, indɛrəm towurɛnɛ ta ti t'indeyɔ nu. Nnɔ tɛgbərɛ tantɛ tɔ nəndelip fəp, difɔ nəndefi.» ");
INSERT INTO bsp_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Afum aŋɛ Musa ɛnasom kəkɔtɛnəs mes yɔkyɔk atɔf ŋa Kanaŋ mɔ, kəlukus kəŋan kɔ ŋander ŋalɔm pəlɛc pa atɔf ŋaŋɔkɔ, kɔ tɔsɔŋɛ kəloŋkanɛ ka aka Yisrayel fəp kətəŋnɛ Musa kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Arkun akakɔ ŋanalɔm pəlɛc pa atɔf ŋa Kanaŋ mɔ, ŋafis-fis MARIKI fɔr kiriŋ katəna bawo ɛnasutɛ ŋa pucuy. ");
INSERT INTO bsp_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Afum akɔ ŋanakɔ kəkɔkcɛ mes nde Kanaŋ mɔ fəp ŋanafi, mɛnɛ Yosuwe wan ka Nun kɔ Kalɛb wan ka Yefune ŋanacəmɛ oŋ. ");
INSERT INTO bsp_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kɔ Musa oloku mamɛ aka Yisrayel fəp, k'afum ŋaŋkekərɛ kəbal kəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ali ntɛ MARIKI ɛnatɔsom ŋa kəkɔ mɔ, kɔ ŋayɛfɛ bətbət suy kəpɛrnɛ ka ntende dəmɔrɔ, ŋacloku: «Kəpɛrnɛ kɔ səndɛ kəfo nkɛ MARIKI oloku teta ki mɔ: A sənciya!» ");
INSERT INTO bsp_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mba Musa oloku: «Ta ake tɔ nəŋsakɛ mosom ma MARIKI-ɛ? Tantɛ tɔfɔkɔt. ");
INSERT INTO bsp_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ta nəpɛrnɛ! MARIKI eyi fɛ nu dacɔ. Ta nəsɔŋɛ aterɛnɛ anu kəkɔsut nu. ");
INSERT INTO bsp_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Aka Amalɛk kɔ aKanaŋ ŋayi tekiriŋ tonu, sakma s'andekɔdiftɛ nu. Bawo nəŋgbaymɛ nnɔ MARIKI eyi mɔ, ɔfɔdeyi nu dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Kɔ ŋantaŋ ləŋəs kəpɛ ka nde dətɔrɔ kəroŋ. Mba Musa kɔ kaŋkəra ka danapa da MARIKI kɔ aka Yisrayel ŋanayɛfɛ fɛ saŋka disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Awa, aka Amalɛk kɔ aKanaŋ aŋɛ ŋanandɛ dəndo dəmɔrɔ mɔ ŋantor. Kɔ ŋasut aYisrayel kɔ ŋambɛləs ŋa haŋ Horma. ");
INSERT INTO bsp_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Məloku aka Yisrayel ntɛ: Kɔ nəŋkɔbɛrɛ atɔf ŋɔkɔ nəŋkɔndɛ mɔ, atɔf nŋɛ isɔŋ nu mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kɔ nəndekɔ nəccɔfɛ MARIKI yoloŋnɛ-ɛ, tɔyɔnɛ pɔcɔl pɔcɔf, tɔyɔnɛ kəloŋnɛ ka kədɛrəm ka kətola tes, kɔ pəyɔnɛ fɛ ti kəloŋnɛ ka kəpocɛ abəkəc ŋosoku pɛs, kɔ pəyɔnɛ fɛ ti yoloŋnɛ nyɛ nəŋkɛrɛ MARIKI tɛm ta cəsata conu cəpɔŋ mɔ, yɔyɔnɛ cəna, kɔ pəyɔnɛ fɛ ti ŋkesiya, cir ntɛ tɔŋsɔŋɛ nəcsɔŋɛ MARIKI kəne ambɔnc ŋobotu mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","məna nwɛ məndeloŋn'em pɔcɔl mɔ, pəkɛrɛn'em sɔ kəmbefe kətɔt kilo kəmaas panɔktərɛnɛ ki moro litɛr din kɔ dacɔ teta kəloŋnɛ ka mɛŋgbɛn. ");
INSERT INTO bsp_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Pəkɛrɛ sɔ wɛn litɛr din kɔ dacɔ, kɔ tɔyɔnɛ pəckɛrɛ aŋkesiya ŋorkun kədeloŋnɛ poloŋnɛ pɔcɔfɛ MARIKI kɔ pəyɔnɛ fɛ ti-ɛ, kəloŋnɛ kəlɔma. ");
INSERT INTO bsp_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kɔ tɔyɔnɛ pəcloŋnɛ aŋkesiya ŋorkun-ɛ, pəkɛrɛnɛ kəmbefe kətɔt kilo camət-tin pənɔktərɛnɛ ki moro litɛr mɛrəŋ teta kəloŋnɛ ka mɛŋgbɛn, ");
INSERT INTO bsp_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","pədeŋər sɔ kəloŋnɛ ka wɛn litɛr mɛrəŋ, ambɔnc ŋa kəloŋnɛ kaŋkɔ ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kɔ tɔyɔnɛ məckɛrɛ tura towut teta poloŋnɛ pɔcɔf, kɔ pəyɔnɛ fɛ ti kəloŋnɛ ka kədɛrəm kətola tes, kɔ pəyɔnɛ fɛ ti kəloŋnɛ ka kəpaŋnɛ pəforu nnɔ MARIKI eyi mɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","pəkɛrɛnɛ kɔ wana, poloŋnɛ pa mɛŋgbɛn pa kəmbefe kətɔt kilo camət-maŋkəlɛ panɔktərɛnɛ kɔ moro litɛr maas, ");
INSERT INTO bsp_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","pəkɛrɛnɛ sɔ kəloŋnɛ ka wɛn litɛr maas. Ambɔnc ŋa yoloŋnɛ yayɔkɔ ancɔfɛ MARIKI mɔ ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tɔyɔ tin tatɔkɔ ta aŋyɔnɛ tura ntɛ o ntɛ, aŋkesiya ŋorkun nŋɛ o nŋɛ, ambiyofo kɔ aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ. ");
INSERT INTO bsp_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Nəntam kəkɛrɛ yɔcɔl yɛlarəm kɔ pəyɔnɛ fɛ ti-ɛ yɔcɔl yepic, mba nəcdeŋər ca yayɛ fəp, pɔcɔl mpɛ o mpɛ nəndekɔ kəloŋnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tantɛ tɔ nwɛ o nwɛ aŋkom aYisrayel dacɔ mɔ ŋacəmɛ sariyɛ saŋsɛ darəŋ kɔ ŋande kəckɛrɛ yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa yi ŋotorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Tɔyɔnɛ dɛtɛmp donu fəp, wəcikəra nwɛ owon kəndɛ nu dacɔ, kɔ nwɛ eyi kəcepərɛnɛ tɛm tepic nu dacɔ mɔ, fəp fəŋan ŋacəmɛ tɔyɔ tin tantɛ darəŋ pəmɔ nəna. Kɔ ŋande ŋackɛrɛ yoloŋnɛ nyɛ ancɔfɛ ina MARIKI mɔ, ambɔnc ŋa yi ŋotorɛ-tor'em abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Sariyɛ sin sasɔkɔ səndeyɔnɛ sa aka Yisrayel fəp, kɔ sa acikəra akɔ ŋayi nu dacɔ mɔ. Sariyɛ sa doru o doru sɔ dɛtɛmp donu fəp. Kəgbɛy kəyi fɛ wəYisrayel kɔ wəcikəra dacɔ MARIKI fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sariyɛ sin gboŋ səndeyi, kɔ dɔpɔ din nnɔ aka Yisrayel ŋayi mɔ kɔ nnɔ acikəra aŋɛ ŋayi nu dacɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Məloku aka Yisrayel: Kɔ nəndekɔbɛrɛ atɔf nŋɛ indekɔbɛrsɛ nu mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kɔ nənde kəcsɔm cəcom ca atɔf ŋaŋɔkɔ-ɛ, pəmar nəcbelɛ MARIKI cəlɔma. ");
INSERT INTO bsp_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pəmɔ tɔkɔ ambeli mɛŋgbɛn nde dəkur, tɛm ta kəsɛpər mɔ, nəbeli kəmbefe kətɛp kəcnɔkət, nəlompsɛ ki kəcom kəlok-lok teta kəloŋnɛ ka mɛŋgbɛn monu mɔcɔkɔ-cɔkɔ pəmɔ tɔkɔ aŋloŋn'em mɛŋgbɛn kəsɛpər mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nəde nəcsɔŋ kəcom kəpɛc kəcɔkɔ-cɔkɔ MARIKI, sariyɛ sa dɛtɛmp kɔ dɛtɛmp donu sɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Kɔ tɔyɔnɛ kətɔyɛfɛnɛ disrɛ ta nəŋkɔtɛnɛ mosom mamɛ fəp mmɛ MARIKI osom Musa mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","mes fəp mmɛ MARIKI osom nu, kəlɛk dɔsɔk ndɛ MARIKI ɛnasom Musa nnɔ nəyi mɔ, awut anu kɔ awut-sɔ anu, ");
INSERT INTO bsp_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","kɔ tɔyɔnɛ kətɔyɛfɛnɛ disrɛ k'ayɔnɛ tes tatɔkɔ, ta kəloŋkanɛ ka aka Yisrayel kəncərɛ ti-ɛ, kəloŋkanɛ kəŋan fəp ŋakɛrɛ tura mpɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa pi ŋontorɛ-torɛ MARIKI abəkəc. Ŋadeŋər sɔ kəloŋnɛ ka mɛŋgbɛn kɔ ka wɛn pəmɔ tɔkɔ sariyɛ səloku ti mɔ, kɔ ambiyofo ŋin teta kəloŋnɛ ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Wəloŋnɛ pətubucnɛ kəsɔkəs ka kəloŋkanɛ ka afum a Yisrayel kiciya kəŋan, aŋŋaŋnɛnɛ ŋa ki. Bawo kəciya kənayi nkɛ ŋanatɔyɛfɛnɛ mɔ. Kɔ ŋaŋkɛrɛ kəloŋnɛ nkɛ ancɔfɛ MARIKI mɔ, ŋaŋkɛrɛ sɔ kəloŋnɛ ka kiciya MARIKI fɔr kiriŋ teta kiciya kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Aŋŋaŋnɛ kəloŋkanɛ ka afum a Yisrayel kɔ acikəra akɔ ŋayi ŋa dacɔ mɔ, bawo kiciya ka afum fəp kənayi nkɛ ŋanatɔyɛfɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kɔ tɔyɔnɛ a fum wəkin eciya kətɔyɛfɛnɛ disrɛ-ɛ, wəkayi pəkɛrɛ wir wɛran wa teren tin teta kəloŋnɛ ka kiciya. ");
INSERT INTO bsp_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Wəloŋnɛ pətubucnɛ kəsɔkəs wəsɔlɛ nwɛ enciya mɔ kiciya kɔn MARIKI fɔr kiriŋ. Kɔ wəloŋnɛ ontubucnɛ kəsɔkəs kɔ kiciya kɔn-ɛ, aŋŋaŋnɛnɛ kɔ ki. ");
INSERT INTO bsp_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ntɛ aŋyɔ kəciya disrɛ ta ɛyɛfɛnɛ ti mɔ, sariyɛ sin sɔ nnɔ aka Yisrayel kɔ acikəra aŋɛ ŋayi nu dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mba kɔ fum wɔlɔma wəka Yisrayel kɔ pəyɔnɛ fɛ ti wəcikəra enciya kəyɛfɛnɛ disrɛ-ɛ, ɔlɔməs MARIKI, aŋwurɛ wəkakɔ afum ɔn dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Fum wəkakɔ ɛfər-fərəs toloku ta MARIKI, k'ence tosom tɔn, aŋwurɛ wəkakɔ afum ɔn dacɔ pəsarɛ sɔ kiciya kɔn.» ");
INSERT INTO bsp_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ntɛ aka Yisrayel ŋanayi nde dətɛgbərɛ mɔ, k'aŋkɔ pabəp wərkun wəlɔma pəcwɛtəs tɔk simiti dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Afum akɔ ŋanabəp kɔ pəcwɛtəs tɔk mɔ, ŋakekərɛ kɔ nde Musa, Aruna kɔ kəloŋkanɛ ka aka Yisrayel fəp fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Pamɛŋk fum nwɛ kəfo nkɛ ɔntɔtam kəmulpɛ mɔ, bawo antatəŋnɛ fɛ ntɛ o ntɛ andeyɔ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Kɔ MARIKI oloku Musa: «Fum wəkawɛ mɛnɛ padif kɔ, kəloŋkanɛ ka aka Yisrayel fəp ŋaca-cas kɔ nde saŋka todoru.» ");
INSERT INTO bsp_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kəloŋkanɛ fəp ŋawurɛnɛ kɔ saŋka todoru, ŋaca-cas kɔ, ti disrɛ pəfi pəmɔ tɔkɔ MARIKI osom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Məloku aka Yisrayel, a dɛtɛmp daŋan fəp ŋade ŋawes-wesi yamos yaŋan tantɔf, ŋacbɛr bənda ya alom ŋa məntambɛnc. ");
INSERT INTO bsp_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Yewes-wesi ya yamos yonu yɔ. Nəde nəcmɔmən yi, nəccɛm-cɛmnɛ mosom ma MARIKI, ntɛ tɔŋsɔŋɛ nəcəmɛ mi darəŋ mɔ. Ta nəde nəccɛm-cɛmnɛ mɛfaŋ ma bəkəc yonu kɔ ma fɔr yonu, nyɛ yɔŋsɔŋɛ nu kəsak ka kəbɔt ka Kanu nəcəmɛ canu cəcuru darəŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Nənde nəccɛm-cɛmnɛ mosom mem, nəcəmɛ mi darəŋ. Nəyɔnɛ afum acempi aŋɛ ampus'em mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","MARIKI iyɔnɛ Kanu konu. In'ɛnawurɛnɛ nu Misira ideyɔnɛ Kanu konu. MARIKI iyɔnɛ Kanu konu.» ");
INSERT INTO bsp_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kore wan ka Yicahar, wansɔ ka Kehat wəka kusuŋka ka Lewy, kɔ Dataŋ kɔ Abiram awut a Eliyab, kɔ Ɔŋ wan ka Pelet aka kusuŋka ka Ruben, ");
INSERT INTO bsp_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ŋancəmɛ Musa dɛbəkəc, kɔ afum masar mɛrəŋ kɔ wəco kəcamət (250) aka Yisrayel ŋasol kɔ ŋa. Arkun aka mewe mɔpɔŋ ŋɔ ŋanayɔnɛ kəloŋkanɛ kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Kɔ ŋaŋmɛpnɛ Musa kɔ Aruna, kɔ ŋalok-lokər ŋa: «Tantɛ tɛntəŋnɛ su oŋ! Afum a kəloŋkanɛ ka Yisrayel fəp, ampusɛ ŋa MARIKI, kɔ MARIKI eyi ŋa dacɔ. Ta ake tɔ nəndotnɛ nnɔ kəloŋkanɛ ka MARIKI kəyi mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ntɛ Musa ɛnane moloku mamɔkɔ mɔ, kɔ mosumpər kɔ pəpɔŋ, k'ɛntɛmpɛnɛ dəntɔf, k'ɛncəpɛ MARIKI tobu. ");
INSERT INTO bsp_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","K'oloku Kore kɔ kəloŋkanɛ kɔn fəp: «Alna bətbət MARIKI endenasɔŋɛ kəcərɛ nwɛ ɔyɔnɛ wəkɔn, nwɛ encemp, nwɛ ɛntam kəlɔtərnɛ kɔ mɔ, ɛŋsak wəkɔ ɛyɛk-yɛk mɔ pəlɔtərnɛ nde eyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Nəyɔ ntɛ, məna Kore kɔ kəloŋkanɛ kam fəp, nəlɛk map mɔcɔfɛ suray. ");
INSERT INTO bsp_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Alna nəbɛr mi meken kɔ suray fɔr ya MARIKI kiriŋ. Wərkun nwɛ MARIKI endeyɛk-yɛk mɔ, nkɔn ampusɛ kɔ. Nəna nəŋgbəf im, Yuruya ya Lewy!» ");
INSERT INTO bsp_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Kɔ Musa oloku Kore: «Nəcəŋkəl, ilɛtsɛnɛ nu awut-sɔ a Lewy! ");
INSERT INTO bsp_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Tɛntəŋnɛ fɛ nu ntɛ Kanu ka Yisrayel kəyɛk-yɛk nu taciŋa kəloŋkanɛ ka aka Yisrayel dacɔ, kɔ owosɛ nəna kəlɔtərnɛ, nətɔmpər yɛbəc yɔn nde dəkiyi dosoku teta kəloŋkanɛ ka Yisrayel mɔ? ");
INSERT INTO bsp_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","MARIKI owosɛ məna Kore kɔ awɛnc əm aŋa aLewy fəp kəlɔtərnɛ kɔ, kɔ nəŋwe sɔ kəyɔnɛ ka aloŋnɛ! ");
INSERT INTO bsp_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ti tɔsɔŋɛ ntɛ məna kɔ kəloŋkanɛ ka afum fəp nəyeŋkər MARIKI səbomp mɔ! Anɔ Aruna ɔyɔnɛ-ɛ, ntɛ nəndecəmɛ kɔ dɛbəkəc mɔ?» ");
INSERT INTO bsp_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kɔ Musa osom fum wəlɔma kəkɔwe Dataŋ kɔ Abiram awut a Eliyab. Mba kɔ ŋaloku: «Səfɔpɛ! ");
INSERT INTO bsp_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Pəntəŋnɛ f'am ntɛ məmpɛnɛ su kəyɛfɛ atɔf ŋoboŋu dalɛ k’awop mɔ, mədedif su nnɔ dətɛgbərɛ? Kɔ məfaŋ sɔ kəsɔŋnɛ dɛbɛ? ");
INSERT INTO bsp_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ala! Bafɔ atɔf ŋoboŋu dalɛ k’awop ŋɔ məŋkɛrɛ su. Məyer fɛ su dalɛ kɔ ŋgbɔŋkəlɔ ya wɛn yɔyɔnɛ yosu! Məcɛm-cɛmnɛ a atɔnəŋk ŋɔ səyɔnɛ ba? Səfati, səfɔder!» ");
INSERT INTO bsp_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Kɔ pəntɛlɛ Musa pəpɔŋ, k'oloku MARIKI: «Ta məbaŋ yoloŋnɛ yaŋan! Paka o paka intabaŋər fɛ ŋa, ali sɔfale, ali katin intayɔ fɛ wəkin tes tɛlɛc.» ");
INSERT INTO bsp_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Kɔ Musa oloku Kore: «Məna kɔ kəloŋkanɛ kam fəp, nəkɔ alna MARIKI fɔr kiriŋ kɔ Aruna. ");
INSERT INTO bsp_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Nwɛ o nwɛ pətɔmpərɛnɛ tap pəbɛr pi suray, pəkɔ pəmentər pi MARIKI. Ti tɔŋkɔsɔŋ map masar mɛrəŋ wəco kəcamət (250). Məna kɔ Aruna nəna sɔ nəkenɛnɛ map monu.» ");
INSERT INTO bsp_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Dɔckɔsɔk Kore kɔ kəloŋkanɛ kɔn ŋalɛk nwɛ o nwɛ tap tɔn, kɔ ŋambɛr mi meken, kɔ ŋandeŋər suray takəroŋ kɔ ŋaŋkɔ dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, kɔ Musa kɔ Aruna. ");
INSERT INTO bsp_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kɔ Kore oloŋka kəloŋkanɛ kɔn fəp nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, k’eŋgbiŋər ŋa nnɔ Musa kɔ Aruna ŋayi mɔ. Gbəncana babɔkɔ, kɔ nɔrɔ da debeki da MARIKI dowurər kəloŋkanɛ ka aka Yisrayel fəp. ");
INSERT INTO bsp_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Nəgbɛynɛ kəloŋkanɛ k'afum akaŋɛ imələk ŋa katina!» ");
INSERT INTO bsp_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mba Musa kɔ Aruna ŋancəp mobu dəntɔf kɔ ŋantola Kanu ŋacyif: «O Kanu, məna nwɛ məsɔŋ kəŋesəm yeyi wəyeŋ ya doru fəp mɔ! Fum wəkin enciy'am, pəndetɛl'am nnɔ kəloŋkanɛ k'afum fəp kəyi mɔ ba?» ");
INSERT INTO bsp_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Məloku kəloŋkanɛ ka afum a Yisrayel: Nəbɔlɛnɛ cəbal ca Kore, Dataŋ kɔ Abiram nde ŋandɛ mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Kɔ Musa ɛyɛfɛ k'ɔŋkɔ pəbəp Dataŋ kɔ Abiram, abeki a Yisrayel ŋacəmɛ kɔ darəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kɔ Musa oloku kəloŋkanɛ ka afum a Yisrayel: «Ilɛtsɛnɛ nu nəbɔlɛ cəbal ca afum alɛc bəkəc akaŋɛ, ta nəgbuŋɛnɛ sɔ daka ndɛ o ndɛ dɔyɔnɛ daŋan mɔ, ta tɔsɔŋɛ nədefinɛ teta kiciya kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kɔ aka Yisrayel ŋambɔlɛ cəbal ca Kore, Dataŋ kɔ Abiram. Dataŋ kɔ Abiram ŋawur kɔ ŋancəmɛ nde dəkəbɛrɛ da cəbal cəŋan kɔ aran aŋan, kɔ aka wɔlɔ waŋan disrɛ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Kɔ Musa oloku: «Tantɛ tendesɔŋɛ nu kəcərɛ a MARIKI osom im kədeyɔ mamɛ fəp. Ali tes ifɔlɛkərnɛ kəyɔ inasərka. ");
INSERT INTO bsp_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kɔ afum akaŋɛ ŋafi pəmɔ tɔkɔ afum alpəs ŋaŋfi mɔ, ta ŋafinɛ pəwɛy-wɛy-ɛ, bafɔ MARIKI osom im. ");
INSERT INTO bsp_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mba kɔ MARIKI ɔyɔ tes tɛwɛy-wɛy, kɔ antɔf ŋɛwani kusu ŋemer afum akaŋɛ kɔ daka daŋan, ŋayi wəyeŋ a ŋackɔ dabiya-ɛ, tɔŋsɔŋɛ nu kəcərɛ a afum akaŋɛ ŋafani MARIKI.» ");
INSERT INTO bsp_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa endelip moloku mɔn kɔ antɔf ŋɛŋgbɛrɛ ŋa dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Kɔ antɔf ŋɛwani kusu, kɔ ŋemer Dataŋ, Abiram, afum aŋan, asol a Kore fəp kɔ daka daŋan. ");
INSERT INTO bsp_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Kɔ ŋantor dabiya ŋayi wəyeŋ, ŋa kɔ daka ndɛ dɔyɔnɛ daŋan mɔ. Kɔ antɔf ŋɛmət ŋa, kɔ ŋaməlkɛ kəloŋkanɛ ka aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Aka Yisrayel aŋɛ ŋanayi ŋa kəsək mɔ fəp, ŋayɛksɛ ntɛ afum aŋɛ ŋanckulɛ-kulɛ mɔ, ŋacloku: «Ta antɔf ŋemer su!» ");
INSERT INTO bsp_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Gbəncana babɔkɔ kɔ MARIKI owurɛ nɛnc, kɔ dɔncɔf arkun masar mɛrəŋ kɔ wəco kəcamət (250) aŋɛ pənatɔmar kəcɔf suray mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Məloku Elasar wan wərkun wəka Aruna wəloŋnɛ, a pəliŋ map nɛnc dacɔ, pələm meken pəbɔlɛ, bawo ampus map mamɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Map ma arkun aŋɛ ŋanaciya akɔ ŋafinɛ teta kiciya kəŋan mɔ, nətɛmpəs mi, nətəpəs tetek toloŋnɛ. Bawo anamentər mi fɔr ya MARIKI kiriŋ, tɔsɔŋɛ kɔ mɔyɔnɛ mopus, mendeyɔnɛ tɛgbɛkərɛ nnɔ aka Yisrayel ŋayi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Elasar wəloŋnɛ ɛwɛtəs map ma kɔpər mmɛ akɔ nɛnc dɛnadiftɛ teta kiciya kəŋan ŋanamentər mɔ, k'ɛntɛmpəs mi, k'antəpəs mi tetek toloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Tɔyɔnɛ tɛcɛmcɛməs ta aka Yisrayel, ntɛ tɔŋsɔŋɛ nwɛ o nwɛ ɔntɔyɔnɛ wəloŋnɛ, wərkun nwɛ o nwɛ ɔntɔyɔnɛ yuruya ya Aruna mɔ, ɔfɔmentərnɛ kəmot ka suray MARIKI fɔr kiriŋ, ta pədeyi pəmɔ Kore kɔ kəloŋkanɛ ka acəmɛnɛ ɔn, tantɛ tɔ MARIKI ɛnasom Musa kəloku. ");
INSERT INTO bsp_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Dɔckɔsɔk, kɔ kəloŋkanɛ ka aka Yisrayel fəp ŋayɛfɛ kəcɔpɛnɛ teta Musa kɔ Aruna, ŋacloku: «Nən'ɔsɔŋɛ afum a MARIKI kəfis-fis!» ");
INSERT INTO bsp_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ntɛ aka Yisrayel ŋancloŋkanɛ teta Musa kɔ Aruna mɔ, ntɛ ŋanatɛfərnɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ, kɔ kəp kəŋkump ŋi, kɔ nɔrɔ da debeki MARIKI dowurər ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Musa kɔ Aruna ŋaŋkɔ nde aŋgbancan ŋɛbəpɛnɛ tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Nəbɔlɛnɛ kəloŋkanɛ kaŋkɛ, imələk ŋa katin!» Musa kɔ Aruna ŋancəp mobu dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Kɔ Musa oloku Aruna: «Məlɛk tap məbɛr pi meken ma tetek toloŋnɛ məbɛr pi suray, məkɔ katəna nde kəloŋkanɛ ka aka Yisrayel ŋayi mɔ, məkɔ mətubucnɛ kəsɔkəs ŋa kiciya kəŋan. Mɛtɛlɛ mender MARIKI, pəlɛc peyeŋki poncop!» ");
INSERT INTO bsp_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Kɔ Aruna ɛlɛk tap, pəmɔ tɔkɔ Musa ɛnaloku kɔ ti mɔ, k'ɛyɛksɛ aloŋkanɛ dacɔ. Pəlɛc pɛnacop nnɔ afum ŋayi mɔ. K'ɛmbɛr suray k'ontubucnɛ kəsɔkəs aka Yisrayel kiciya kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Aruna pəcəmɛ afi kɔ ayi wəyeŋ dacɔ, kɔ pəlɛc pɛsakɛ. ");
INSERT INTO bsp_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Pəlɛc papɔkɔ pɛnadif afum wul wəco kɔ maŋkəlɛ, masar camət-mɛrəŋ (14.700), ta alɔm afum akɔ ŋanafi teta Kore disrɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Kɔ Aruna ender nnɔ Musa eyi mɔ, nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, kɔ pəlɛc pɛsakɛ. ");
INSERT INTO bsp_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Məloku aka Yisrayel: Məwer ŋa kusuŋka o kusuŋka kəgbo kin, wəkiriŋ ka kusuŋka o kusuŋka pəsɔŋ əm kəgbo kin, ti tɔyɔnɛ cəgbo wəco kɔ mɛrəŋ. Məcic tewe ta kusuŋka o kusuŋka kəgbo kəŋan kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Məcic tewe ta Aruna kəgbo ka aLewy. Wəkiriŋ ka kusuŋka o kusuŋka endeyɔ kəgbo kin. ");
INSERT INTO bsp_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Məboc cəgbo cacɔkɔ nde aŋgbancan ŋɛbəpɛnɛ disrɛ, nde kaŋkəra tekiriŋ nkɛ kəmentər danapa da MARIKI kɔ aka Yisrayel, nde imbəpɛnɛ kɔ nəna mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Wərkun nwɛ indeyɛk-yɛk mɔ, kəgbo kɔn kəndepoŋ. Ti disrɛ indesɔŋɛ aka Yisrayel kəsak kəcɔpɛnɛ tetonu.» ");
INSERT INTO bsp_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Kɔ Musa osom aka Yisrayel ntɛ: Akiriŋ a cusuŋka fəp ŋasɔŋ kɔ kəgbo kin, wəkiriŋ o wəkiriŋ kəgbo kin ti tɔŋsɔŋ cəgbo wəco kɔ mɛrəŋ. Kəgbo ka Aruna kənayi cəgbo cacɔkɔ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Kɔ Musa omboc cəgbo fəp MARIKI fɔr kiriŋ nde aŋgbancan nŋɛ ŋɔyɔ kaŋkəra nkɛ amɛŋk walakɛ nwɛ wementər danapa da MARIKI kɔ aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Dɔckɔsɔk, ntɛ Musa ɛmbɛrɛ nde aŋgbancan ŋosoku disrɛ mɔ, kəgbo ka Aruna, nkɛ kəyɔnɛ ka aka kusuŋka ka aLewy mɔ, kəpoŋ. Kənagbuc kɔ kəsɔŋ yɛlɛŋk, kɔ kəwurɛ yokom yololu. ");
INSERT INTO bsp_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Kɔ Musa owurɛ cəgbo fəp MARIKI fɔr kiriŋ, k'ementər ci aka Yisrayel fəp, kɔ ŋanəŋk kɔ nwɛ o nwɛ ɛlɛk kəgbo kɔn. ");
INSERT INTO bsp_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Kɔ MARIKI oloku Musa: «Məluksɛ sɔ kəgbo ka Aruna nde kaŋkəra nkɛ kəmentər danapa dem kɔ aka Yisrayel mɔ, ntɛ tɔŋsɔŋɛ pamɛŋk ki di teta tɛgbɛkərɛ ta ayeŋki səbomp. Ti disrɛ məŋyamsɛ ŋa kəcɔpɛnɛ tetem, tɔsɔŋɛ ŋa sɔ kətɔfi.» ");
INSERT INTO bsp_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Kɔ Musa ɔyɔ tɔkɔ MARIKI ɛnasom kɔ mɔ, kɔ teyi tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Kɔ aka Yisrayel ŋaloku Musa: «Tosu telip, səna səsɔlɛ, fəp fosu səsɔlɛ! ");
INSERT INTO bsp_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Nwɛ o nwɛ ɔŋlɔtərnɛ dəkiyi dosoku da MARIKI mɔ, eŋfi! Tantɛ tɔ səndelip kəfis-fis fəp fosu ba?» ");
INSERT INTO bsp_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Kɔ MARIKI oloku Aruna: «Məna, awut am kɔ aka kəlɔ kam disrɛ nən'endesarɛ kiciya nkɛ o nkɛ aŋyɔ nnɔ aŋgbip ŋosoku mɔ. Məna kɔ awut am nən'endesarɛ kiciya nkɛ nnɔ yɛbəc ya wəloŋnɛ yeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Məsak sɔ awɛnc əm aŋa aLewy, aka kusuŋka ka wisi ŋalɔtərnɛ aŋgbip kɔ məna. Ŋadekɔ ŋacmar əm, mba məna kɔ awut am, nən'endekɔ nəccəmɛ aŋgbancan nŋɛ kaŋkəra nkɛ kəmentər danapa dem kəyi mɔ tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Awɛnc əm aŋa aLewy ŋandebum yɛbəc yam kɔ ya daŋgbancan, mba ŋafɔde ŋaclɔtərnɛ yosumpər-sumpər yopus kɔ tetek toloŋnɛ. Ti disrɛ nəna kɔ ŋa nəfɔfi. ");
INSERT INTO bsp_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ŋandey'əm kəsək ŋacmar əm yɛbəc ya nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu fəp. Ali fum wəcuru ɔfɔlɔtərnɛ nu. ");
INSERT INTO bsp_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Kɔ nəna yɛbəc ya nde deŋgbip yɔ nəndeyi kɔ ya tetek toloŋnɛ. Ti disrɛ mɛtɛlɛ ma Kanu mɔfɔsɔyi nnɔ aka Yisrayel ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ina, ilɛk awɛnc əm aŋa aLewy aka Yisrayel dacɔ: Akemi ŋɔ, k'isɔŋ nu ŋa ntɛ tɔŋsɔŋɛ ŋacbəc yɛbəc ya nde aŋgbancan ŋɛbəpɛnɛ kɔ ina mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mba məna Aruna kɔ awut am nəsumpər yɛbəc yonu ya aloŋnɛ nde dətetek toloŋnɛ kɔ ya nde deŋgbip nde kəloto kəkəŋkɛ tadarəŋ. Ina Kanu isɔŋ nu yɛbəc yayɔkɔ. Kɔ fum wəcuru ɔlɔtərnɛ kəfo kəpus kaŋkɔ-ɛ, mɛnɛ padif kɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Kɔ MARIKI oloku Aruna: «Ina, isɔŋ əm kətɔmpər teta yoloŋnɛ nŋɛ aka Yisrayel ŋampus'em mɔ fəp. Isɔŋ əm yi məna kɔ awut am, yendeyɔnɛ ya awut am doru o doru. ");
INSERT INTO bsp_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Yeri nyɛ yendeyɔnɛ ya məna ca yopus dacɔ nyɛ antɔcɔf mɔ: Yoloŋnɛ yaŋan ya mɛŋgbɛn fəp, yoloŋnɛ ya kiciya kɔ yoloŋnɛ ya kəlompəs ka kiciya nyɛ aka Yisrayel ŋande ŋackɛr'em mɔ. Ca yosoku nyɛ ande pacpusɛ MARIKI mɔ, yam yɔ, kɔ awut am arkun. ");
INSERT INTO bsp_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Mədi yi pəmɔ daka dosoku ndɛ ampusɛ MARIKI mɔ. Arkun a yuruya ya Aruna fəp ŋantam yi kədi. Məde məcleləs sariyɛ sa yeri nyɛ ampusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Nyɛ yendeyɔnɛ yam: Nənde nəcsɔtɔ kəsək ka daka ndɛ aka Yisrayel ŋande ŋackɛr'em, yoloŋnɛ nyɛ antubucnɛ kəsɔŋ im mɔ. Impocɛ nu yayɔkɔ doru o doru, məna kɔ awut am arkun kɔ awut am aran. Aka kəlɔ kam disrɛ fəp, nwɛ o nwɛ ɔŋsɔk mɔ, ɛntam kədi yeri yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Isɔŋ əm yokom yɔcɔkɔ-cɔkɔ nyɛ aka Yisrayel ŋande ŋackɛrɛ MARIKI mɔ: Yeri yɔtɔt ya moro ma olif, ya wɛn kɔ ya mɛŋgbɛn fəp. ");
INSERT INTO bsp_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Yokom ya tɔk yɔcɔkɔ-cɔkɔ ya dɔtɔf nŋɛ ŋande ŋackɛrɛ MARIKI mɔ, yam yende yecyi. Nwɛ o nwɛ ɔŋsɔk aka kəlɔ kam disrɛ mɔ, ɛntam yi kədi. ");
INSERT INTO bsp_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Mpɛ o mpɛ pɔ aka Yisrayel ŋande ŋacsɔŋ im mɔ, afɔtam kəwurus pi, pam pende pecyi. ");
INSERT INTO bsp_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Nwɛ o nwɛ ɔyɔnɛ wan wəcɔkɔ-cɔkɔ wəka kɛrɛ afum kɔ yɔcɔl dacɔ, nwɛ aŋkɛrɛ MARIKI mɔ, wəkam eŋyi. Mba wan wəcɔkɔ-cɔkɔ wəka fum kɔ wəka pɔcɔl pɔtɔsɔk ande pacwurus'am ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kəway ka kəwurus nkɛ ande pacwurus'am ŋa mɔ kəyɔnɛ: Wan wərkun wəka ŋof ŋin gbeti mɛncəmbəl kəcamət tɛncəmbəl mpɛ o mpɛ pɔyɔ kəram wəco, pəmɔ kəway ka gbeti nkɛ kəyi nde aŋgbip ŋosoku mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mba afɔwurus wan wəcɔkɔ-cɔkɔ wəka wana, wəka aŋkesiya kɔ wəka wir, ampusɛ yi MARIKI, nkɔn aŋloŋnɛ yi. Mecir ma yi mɔ mənde məcwɛsəsər tetek toloŋnɛ, məccɔfɛ sɔ MARIKI moro ma yi, ambɔnc ŋaŋɔkɔ ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Sɛm ya yi, yam yɔ, pəmɔ kəmpəcpəc nkɛ atubucnɛ kəsɔŋ MARIKI kɔ aləŋk ŋa kəca kətɔt mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Isɔŋ nəna aloŋnɛ daka ndɛ o ndɛ aka Yisrayel ŋande ŋacbelɛ MARIKI dəyoloŋnɛ nyɛ ampusɛ kɔ mɔ. Yeri yonu yɔ yayɔkɔ, məna Aruna, awut am arkun kɔ aran doru o doru. Danapa da mɛr dɔ səsek məna kɔ yuruya yam doru o doru.» ");
INSERT INTO bsp_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Kɔ MARIKI oloku Aruna: «Məfɔdeyɔ kɛ atɔf ŋaŋan, məfɔdesɔtɔ tofokəl ŋa dacɔ. In'ɔyɔnɛ kɛ kam kɔ tofokəl pam aka Yisrayel dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Kɔ MARIKI endeŋər sɔ kəloku: «Isɔŋ aka kusuŋka ka aLewy kɛ, farilɛ fəp Yisrayel disrɛ kəway ka yɛbəc yɔkɔ ŋambəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Aka Yisrayel ŋafɔsɔlɔtərnɛ aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ntɛ tɔŋsɔŋɛ ta ŋasarsərnɛ kiciya, ŋafi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ALewy ŋatɔmpər yɛbəc ya nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ŋa ŋaŋsarɛ sɔ kiciya nkɛ ŋanciya di mɔ. Sariyɛ sa doru o doru sɔ, sa dɛtɛmp kɔ dɛtɛmp. ALewy ŋafɔsɔtɔ kɛ aYisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Isɔŋ aLewy kɛ nkɛ kəyɔnɛ farilɛ nfɛ aka Yisrayel ŋambelɛ MARIKI mɔ. It'ɔsɔŋɛ ntɛ ilokɛ tetaŋan, a ŋafɔsɔtɔ kɛ aka Yisrayel dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Məloku aLewy: Kɔ nənde nəcsɔtər aka Yisrayel farilɛ nfɛ isɔŋ nu yɔsɔtɔ yaŋan disrɛ, yɔyɔnɛ kɛ konu mɔ, nəwurɛ pebelər pa MARIKI farilɛ fa farilɛ. ");
INSERT INTO bsp_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ande pacbelɛ MARIKI farilɛ fafɔkɔ pəmɔ ntɛ ambelɛ kɔ mɛŋgbɛn nde dəkur kɔ wɛn wofu nwɛ ambelɛ nu dapampɛ nde aŋfɔcəs wi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tatɔkɔ tɔ nənde nəcyɔ, nəna sɔ nəcbelɛ MARIKI farilɛ dəca fəp nyɛ aka Yisrayel ŋande ŋacsɔŋ nu mɔ, nəna sɔ nəcsɔŋ farilɛ nfɛ nənde nəcwurɛ teta MARIKI mɔ Aruna wəloŋnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Dəyopocɛ fəp nyɛ aŋsɔŋ nu mɔ, nəcbelɛ MARIKI popoc pɔtɔt pa yi, nəpusɛ kɔ pi. Dəca yɔtɔt fəp nəcbelɛ popoc popus. ");
INSERT INTO bsp_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Məloku sɔ aLewy: Kɔ nəmbelɛ yi MARIKI-ɛ, nəmɛŋkərnɛ yɛlpəs. Nəntam kəmɛŋkərnɛ yi pəmɔ ntɛ aYisrayel ŋaŋmɛŋkərnɛ yɛlpəs ya mɛŋgbɛn, ya wɛn wofu kɔ ya moro ma olif maŋan. AYisrayel kɔ aLewy, tin tayi tɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Nəntam yi kədi mofo fəp, nəna kɔ aka kəlɔ konu disrɛ: Kəway ka yɛbəc yonu kɔ, yɔkɔ nəmbəc nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Tatɔkɔ tɔfɔsɔŋɛ nu kəsarɛ kiciya nkɛ o nkɛ, kɔ nənde nəclip kəbeli yɔtɔt, ta nəfulus yoloŋnɛ yopus ya aka Yisrayel-ɛ, nəfɔfinɛ ti.» ");
INSERT INTO bsp_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Kɔ MARIKI oloku Musa kɔ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Ntɛ t'ancic dəsariyɛ sa MARIKI nsɛ ɛncəmbər mɔ: Məloku aka Yisrayel, a ŋakɛr'am wana wɛran weyim nwɛ wɔntɔyɔ dolokəp, nwɛ wɛntatɔdəndɛ kel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Nəsɔŋ wi Elasar wəloŋnɛ, pəwurɛnɛ wi dəsaŋka, pafay wi fɔr yɔn kiriŋ. Pasu tɔbɔl mecir mamɔkɔ mɛbɛrɛ pi disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Elasar wəloŋnɛ pəlɛk mecir ma wana wawɔkɔ, pəwɛsəs mi camət-mɛrəŋ ntende dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Pacɔf wana wawɔkɔ fɔr yɔn kiriŋ, akata, sɛm ya wi, mecir kɔ yedisrɛ ya aputuk. ");
INSERT INTO bsp_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Wəloŋnɛ pəlɛk kətɔk kəbotu ambɔnc ka sɛdər kɔ yika yobotu ambɔnc ya hisɔp kɔ tafəc peyim, pələm ca yayɔkɔ dənɛnc yɔcɔfɛnɛ kɔ wana wawɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Wəloŋnɛ pəyakɛ yamos yɔn kɔ dis dɔn domun, a pədebɛrɛ saŋka disrɛ. Wəloŋnɛ ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Nwɛ ɛnacɔf wana mɔ pəyak yamos yɔn, pəbikɛ domun, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Wərkun wəsoku wəkin pəwɛt kəbof ka wana wawɔkɔ, pəkɔ pəboc ki kəfo kəpus saŋka tadarəŋ. Pamɛŋkɛ ki kəloŋkanɛ ka Yisrayel teta kəlompəs ka domun dɔsɔksɛ. Kəloŋnɛ ka kiciya kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Fum nwɛ ɛŋwɛt kəbof ka wana kaŋkɔ mɔ, pəyak yamos yɔn, ɔsɔk fɛ haŋ dec dɛkalɛ. Sariyɛ sa doru o doru sɔ nnɔ aka Yisrayel kɔ acikəra aŋɛ ŋandɛ ŋa dacɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Nwɛ oŋgbuŋɛnɛ wəfi mɔ, ɔsɔk fɛ haŋ mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Tataka ta maas kɔ ta camət-mɛrəŋ, pəmar pəsɔkəsnɛnɛ domun ndɛ dɔŋsɔkəs mɔ. K'ɔntɔsɔkəsnɛ tataka ta maas kɔ ta camət-mɛrəŋ-ɛ, ɔfɔsɔk. ");
INSERT INTO bsp_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nwɛ o nwɛ oŋgbuŋɛnɛ wəfi ta ɔsɔkəsnɛ mɔ, eŋyik-yikəs dəkiyi da MARIKI. Aŋwurɛ wəkayi aYisrayel dacɔ, bawo awɛs-wɛsəsər fɛ kɔ domun dɔsɔksɛ, ɔsɔk fɛ: Kətɔsɔk kɔn kəyi kɔ sɔ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Sariyɛ sɔ nsɛ: Kɔ fum efi abal disrɛ-ɛ, nwɛ o nwɛ ɛmbɛrɛ abal ŋaŋɔkɔ disrɛ, nwɛ o nwɛ eŋyi di mɔ, ɔfɔsɔk haŋ mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Pɛbɛrɛ paka mpɛ o mpɛ peŋyi abal ŋaŋɔkɔ disrɛ ta aŋgbəpər pi mɔ, pɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Nwɛ o nwɛ oŋgbuŋɛnɛ dəkulum fum nwɛ andif, kɔ pəyɔnɛ fɛ ti pəfinɛ defi dekifəli, bɛnt ya wəfi kɔ pəyɔnɛ fɛ ti kufu kɔn-ɛ, ɔsɔk fɛ haŋ mata camət-mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Palɛkɛ wətɔsɔk, kəbof ka wana weyim nwɛ ancɔfɛ MARIKI teta kiciya mɔ, pabɛr ki dətaŋku, pabɛr ki kəroŋ domun decempi da dəkəŋgbɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Wərkun wəsoku pəlɛk alɛ ŋa hisɔp, pəgbət ŋi dəromun. K'elip-ɛ, pəwɛsəsər abal, pənaŋkanɛ yosumpər-sumpər kɔ afum akɔ ŋayi di mɔ, nwɛ oŋgbuŋsərɛnɛ bɛnt ya wəfi, nwɛ andif kɔ pəyɔnɛ fɛ ti pəfinɛ defi dekifəli, kɔ pəyɔnɛ fɛ ti kufu kɔn mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Fum wəsoku pəwɛsəsər wətɔsɔk tataka ta maas kɔ ta camət-mɛrəŋ, wəkakɔ ɔsɔk tataka ta camət-mɛrəŋ. Pəyak yamos yɔn, pəbikɛ domun, kɔ dec dɛŋkalɛ-ɛ, ɔŋsɔk. ");
INSERT INTO bsp_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Wərkun wətɔsɔk nwɛ ɔntɔsɔkəsnɛ mɔ, andewurɛ kɔ aka Yisrayel dacɔ, bawo eyik-yikəs kəfo kəpus ka MARIKI. Bawo anawɛsəsər fɛ kɔ domun dɔsɔksɛ, ɔsɔk fɛ. ");
INSERT INTO bsp_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Sariyɛ sa doru o doru sɔ nnɔ aka Yisrayel ŋayi mɔ. Nwɛ ɛwɛsəsər domun dɔsɔksɛ dadɔkɔ mɔ, pəyak yamos yɔn. Nwɛ oŋgbuŋɛnɛ domun dɔsɔksɛ mɔ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Mpɛ o mpɛ wətɔsɔk oŋgbuŋɛnɛ mɔ, pɔŋyɔnɛ pɔtɔsɔk. Nwɛ oŋgbuŋɛnɛ pi mɔ, ɔsɔk fɛ haŋ dec dɛkalɛ. ");
INSERT INTO bsp_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Kɔ kəloŋkanɛ ka aka Yisrayel fəp kənder nde tɛgbərɛ ta Cin ŋof ŋɔcɔkɔ-cɔkɔ ŋa teren tatɔkɔ, kɔ afum ŋandɛ Kadɛs. Difɔ Miriyam ɛnafi, k'awup kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ntɛ kəloŋkanɛ ka aka Yisrayel kənatɔyɔ domun mɔ, kɔ ŋaloŋkanɛ teta Musa kɔ Aruna. ");
INSERT INTO bsp_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kɔ afum aka Yisrayel ŋantɛnər Musa kəyɛfərɛnɛ. Ŋacloku: «Ali sənafi ntɛ awɛnc asu ŋancfis-fis fɔr ya MARIKI kiriŋ mɔ! ");
INSERT INTO bsp_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","T'ake tɔ nəŋkɛrɛnɛ kəloŋkanɛ ka MARIKI nnɔ dətɛgbərɛ sədefis-fis kɔ yɔcɔl yosu-ɛ? ");
INSERT INTO bsp_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","T'ake tɔ nənawurɛnɛ su Misira, kɔ nəŋkɛrɛ su kəfo kəlɛc kaŋkɛ-ɛ? Bafɔ kəfo kɔ nkɛ antam kəgbal defet mɔ, fik fəyi fɛ, wɛn weyi fɛ, cəpare cəyi fɛ, ali domun deyi fɛ ndɛ antam kəmun mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa kɔ Aruna ŋambɔlɛnɛ afum aka Yisrayel, kɔ ŋaŋkɔ dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Kɔ ŋantɛmpɛnɛ dəntɔf, nɔrɔ da debeki da MARIKI dementərnɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Məlɛk kəgbo məloŋka kəloŋkanɛ ka aka Yisrayel, məna Musa kɔ Aruna wɛnc əm. Nəlok-lokər tasar peyeŋki fɔr yaŋan kiriŋ, pɔsɔŋ domun. Məwurɛ ŋa domun da tasar peyeŋki məsɔŋɛ aka Yisrayel ŋamun kɔ yɔcɔl yaŋan.» ");
INSERT INTO bsp_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Kɔ Musa ɛlɛk kəgbo k’Aruna nkɛ kənayi MARIKI fɔr kiriŋ mɔ, pəmɔ tɔkɔ ɛnasom kɔ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa kɔ Aruna ŋaloŋka aka Yisrayel tekiriŋ ta tasar peyeŋki. Kɔ Musa oloku ŋa: «Nəcəŋkəl, ilɛtsɛnɛ nu, ataŋi ləŋəs! Səndetam kəwurɛ nu domun nnɔ tasar peyeŋki pampɛ ba?» ");
INSERT INTO bsp_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mba Musa eyekti kəca kɔn k'osutɛ tasar teyeŋki kəgbo kəmɛrəŋ. Gbəncana babɔkɔ kɔ domun dɛlarəm dowur. Kɔ kəloŋkanɛ ka aka Yisrayel ŋamun kɔ yɔcɔl yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mba kɔ MARIKI oloku Musa kɔ Aruna: «Bawo nəsɔtɔ fɛ kəlaŋ kəlarəm nnɔ iyi mɔ, nəmentər fɛ decempi dem fɔr ya aka Yisrayel kiriŋ, nəfɔdebɛrsɛnɛ afum akaŋɛ atɔf nŋɛ isɔŋ ŋa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","K'awe abat ŋaŋɔkɔ «Meriba» ti tɔyɔnɛ kusu kəŋan «Kəcɔp», kəfo kaŋkɔ kɔ aka Yisrayel ŋanctɛn kəcaŋ MARIKI kəcɔp, nwɛ ɛnamentər decempi dɔn ŋa dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Kəyɛfɛ Kadɛs, kɔ Musa osom afum ndena wəbɛ wəka Edɔm: «Ntɛ tɔ aka Yisrayel, awɛnc əm aŋa ŋaloku: Məncərɛ mes mocuy mmɛ mɛmbəp su mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Atem asu ŋanator Misira, kɔ səwon di kəndɛ. Mba, kɔ aka Misira ŋantɔrəs su, səna kɔ atem asu. ");
INSERT INTO bsp_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Kɔ səŋkulɛ-kulɛ nnɔ MARIKI eyi mɔ, k'ɛncəŋkəl su. K'osom mɛlɛkɛ min, kɔ mowurɛ su Misira. Ndɛkəl oŋ səyi Kadɛs, dare ndɛ deyi'm kəsək mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Məce su, ilɛtsɛn'am, səcepər dare dam. Səfɔcepər nde dalɛ dam, dalɛ da ŋgbɔŋkəlɔ ya wɛn wam, səfɔmun domun da cələmp cam. Dɔpɔ din gboŋ dɔ səndesolnɛ, səfɔgbaymɛ kəca kətɔt, səfɔgbaymɛ kəca kəmeriya, haŋ səcepər kələncər kam.» ");
INSERT INTO bsp_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mba kɔ wəbɛ wəka Edɔm oluksɛ kɔ ntɛ: «Nəfɔcali atɔf ŋem, kɔ nəcepər-ɛ, incaŋ nu kəyɛfərɛnɛ kɔ dakma dem.» ");
INSERT INTO bsp_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Kɔ aka Yisrayel ŋaloku: «Dɔpɔ din dɔ səndesolnɛ, kɔ səmun domun dam, səna kɔ yɔcɔl yosu-ɛ səŋsɔŋ'əm kəway ka di, tɔyɔ fɛ tes. Kəcepər gbəcərəm kɔ səfaŋ ali səfɔcəmbərəs.» ");
INSERT INTO bsp_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mba kɔ wəbɛ wəka Edɔm oluksɛ ŋa sɔ: «Nəfɔcepər nnɔ!» K'aka Edɔm ŋawur kɔ afum alarəm aŋɛ ŋanayɔ fənɔntər fəpɔŋ mɔ, kəkɔgbintərnɛ aka Yisrayel kəsutɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Kɔ wəbɛ wəka Edɔm ɛfati kəce aka Yisrayel ŋacepər atɔf ŋɔn. Ti tɛnasɔŋɛ aka Yisrayel kəlɛk dɔpɔ docuru. ");
INSERT INTO bsp_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kəloŋkanɛ ka aka Yisrayel fəp ŋayɛfɛ Kadɛs, kɔ ŋaŋkɔ nde tɔrɔ ta Hor. ");
INSERT INTO bsp_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Kɔ MARIKI oloku Musa kɔ Aruna, nde tɔrɔ ta Hor nde kələncər ka Edɔm. ");
INSERT INTO bsp_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Kɔ MARIKI oloku: «Aruna nkɔn endefi, pəlukus nde atem ɔn ŋayi mɔ, ɔfɔbɛrɛ atɔf nŋɛ isɔŋ aka Yisrayel mɔ, bawo nənacəmɛ mosom mem dɛbəkəc nde abat ŋa Meriba.» ");
INSERT INTO bsp_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Məna, Musa məlɛk Aruna kɔ wan kɔn Elasar məpɛnɛ ŋa tɔrɔ ta Hor kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Məwurɛ Aruna yamos yɔn yopus, məbɛr yi wan kɔn Elasar, nnɔ Aruna endefi pəlukus sɔ nde atem ɔn ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Kɔ Musa ɔyɔ tɔkɔ MARIKI ɛnasom kɔ mɔ. K'ɛmpɛ tɔrɔ ta Hor kəroŋ, fɔr ya kəloŋkanɛ ka aka Yisrayel fəp kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Kɔ Musa owurɛ Aruna yamos yɔn, k'ɛmbɛr yi wan kɔn Elasar. Dəndo Aruna ɛnafi tɔrɔ kəroŋ. Musa kɔ Elasar ŋantor dətɔrɔ. ");
INSERT INTO bsp_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ntɛ kəloŋkanɛ ka aka Yisrayel fəp ŋanacərɛ a Aruna efi mɔ, kɔ kəlɔ ka Yisrayel fəp kəmbok kɔ mata wəco maas (30). ");
INSERT INTO bsp_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Wəbɛ wəka dare da Arad, wəKanaŋ, nwɛ ɛnandɛ nde Nɛkɛf mɔ, ene a aka Yisrayel ŋayi kəder dɔpɔ da Atarim. K'osut aka Yisrayel k'osumpər-sumpər acar. ");
INSERT INTO bsp_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ti disrɛ kɔ aka Yisrayel ŋandɛrmɛ MARIKI, ŋacloku: «Kɔ məmbɛr afum akaŋɛ su dəwaca-ɛ, səŋləsər sədare səŋan fəp». ");
INSERT INTO bsp_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Kɔ MARIKI ɛncəŋkəl ŋa, k'ɛmbɛr aKanaŋ aYisrayel dəwaca. Kɔ aka Yisrayel ŋasut ŋa, kɔ ŋaləsər sədare səŋan. K'awe kəfo kaŋkɔ tewe ta Horma, tɔyɔnɛ kusu kəŋan «Kələsər». ");
INSERT INTO bsp_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Kɔ aka Yisrayel ŋayɛfɛ tɔrɔ ta Hor ŋalɛk dɔpɔ da kəba ka Cəŋkɔlma, ntɛ tɔŋsɔŋɛ ŋanɔŋkər Edɔm mɔ. Ŋayi dɔpɔ kɔ bəkəc yɛlɛcɛ-lɛcɛ ŋa. ");
INSERT INTO bsp_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Kɔ aka Yisrayel ŋalokər-lokər Kanu kɔ Musa: «T'ake tɔ nəwurɛ su Misira a nədedif su nnɔ dətɛgbərɛ? Nnɔ kəcom kɔ domun yɔntɔyi mɔ, mɛnɛ yeri yɔtɔbɔt yayɛ.» ");
INSERT INTO bsp_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ti disrɛ kɔ MARIKI ɛŋkɛrɛ afum akakɔ bok ya mɔkɔn. Kɔ yɛŋaŋəs afum kɔ alarəm ŋafis-fis aYisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Kɔ afum ŋander ŋanəŋk Musa kɔ ŋaloku: «Sənciya, səlokər-lokər MARIKI kɔ məna. Məlɛtsɛnɛ MARIKI, a pəbɔlɛnɛ su bok yayɛ!» Kɔ Musa eyi kəlɛtsɛnɛ MARIKI teta aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Kɔ MARIKI oloku Musa: «Məlompəs abok ŋa mɔkɔn mədɛt ŋi togbu darenc. Nwɛ o nwɛ abok ŋɛŋŋaŋ mɔ k'ɛŋgbətnɛ abok ŋaŋɔkɔ-ɛ, ɔfɔfi.» ");
INSERT INTO bsp_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Kɔ Musa olompəs abok ŋa kɔpər, k'ɛndɛt ŋi dətogbu darenc. Aŋɛ bok yɛnaŋaŋ tɛm tatɔkɔ, kɔ ŋaŋgbətnɛ ŋi mɔ, ŋanafi fɛ. ");
INSERT INTO bsp_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Kɔ aka Yisrayel ŋaŋkɔ ŋandɛ Obot. ");
INSERT INTO bsp_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kɔ ŋayɛfɛ Obot kɔ ŋancəmbər saŋka nde Iye Abarim, dəndo tɛgbərɛ mpɛ pətɛfərɛnɛ Mohab nde dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kɔ ŋayɛfɛ di kɔ ŋaŋkɔ ŋacəmbər cəbal nde dəŋgbəl da Sered kəsək. ");
INSERT INTO bsp_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kɔ ŋayɛfɛ kəfo kaŋkɔ, kɔ ŋampɛrnɛ kəca ka kəŋgbɔkɔ ka Arnɔŋ nkɛ kəŋgbələr nde dətɛgbərɛ kɔ kəndewur atɔf ŋa aka Amɔr mɔ. Kəŋgbɔkɔ ka Arnɔŋ kəyɔnɛ kələncər aka Mohab kɔ aka Amɔr dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","It'alokɛnɛ dəbuk ba Cəwan ca MARIKI: «Dare da Waheb nde Sufa kɔ waca wa səŋgbəl sa Arnɔŋ fəp, ");
INSERT INTO bsp_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kɔ səŋgbəl nsɛ səyi kəca ka dare da Ar səlɔtərnɛ ntende kələncər ka Mohab.» ");
INSERT INTO bsp_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kɔ ŋayɛfɛ dəndo kɔ ŋaŋkɔ Ber, it'ɔyɔnɛ kusu kəŋan: «Kələmp». Difɔ MARIKI ɛnaloku Musa: «Məloŋka aka Yisrayel, isɔŋ ŋa domun.» ");
INSERT INTO bsp_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Teta kələmp kaŋkɔ tɛnasɔŋɛ aka Yisrayel kəleŋəs teleŋ ntɛ: Məpɛnɛ dəkələmp, Domun! Pakul-kulɛnɛ pəbotu! ");
INSERT INTO bsp_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kələmp nkɛ abɛ ŋaŋkay mɔ, nkɛ afum apɔŋ asu ŋaŋkayɛ cəŋgbasar ca dɛbɛ mɔ kɔ cəgbo cəŋan cəkɔtsɛ mɔ! Kɔ ŋayɛfɛ dətɛgbərɛ kɔ ŋaŋkɔ Matana. ");
INSERT INTO bsp_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ntɛ aka Yisrayel ŋanayɛfɛ Matana mɔ, kɔ ŋaŋkɔ Naliyel, kɔ ŋayɛfɛ Naliyel kɔ ŋaŋkɔ Bamot. ");
INSERT INTO bsp_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Kɔ ŋayɛfɛ Bamot kɔ ŋaŋkɔ mɔrɔ dacɔ mmɛ meyi atɔf ŋa Mohab mɔ, kəca ka takəroŋ ta tɔrɔ ta Piska, tɔrɔ mpɛ pentilsərnɛ tekiriŋ ta tɛgbərɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Kɔ aka Yisrayel ŋasom ndena Sihɔŋ, wəbɛ wəAmɔr ŋacloku kɔ: ");
INSERT INTO bsp_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Səfaŋ kəcali nnɔ atɔf ŋam. Səfɔgbaymɛ ntende dalɛ dam, səfɔgbaymɛ ntende ŋgbɔŋkəlɔ ya wɛn wam, səfɔmun domun da cələmp cam. Dɔpɔ din gboŋ dɔ səndesolnɛ, səfɔgbaymɛ haŋ səcali atɔf ŋam.» ");
INSERT INTO bsp_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihɔŋ ɛnawosɛ fɛ aka Yisrayel kəcepər nde kələncər kɔn. Kɔ Sihɔŋ oloŋka afum ɔn fəp, kɔ ŋawur kəkɔsutɛnɛ kɔ aka Yisrayel nde dətɛgbərɛ. Kɔ ŋander ŋagbintərnɛ ŋa Yahas kɔ ŋawɛkərnɛ ŋa kəsutɛnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kɔ aka Yisrayel ŋandiftɛ ŋa sakma, kɔ ŋabaŋ atɔf ŋa Sihɔŋ kəyɛfɛ kəŋgbɔkɔ ka Arnɔŋ haŋ ka Yabɔk, haŋ kəbəp kələncər ka atɔf ŋa Amɔŋ. Belbel b'anabum kələncər ka Amɔŋ. ");
INSERT INTO bsp_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Aka Yisrayel ŋasumpər sədare sasɔkɔ fəp, kɔ ŋandɛ sədare sa Amɔr nde, dare da Hesbon, kɔ madare mmɛ mɔnɔŋkər ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesbon dare da Sihɔŋ dɛnayi, kɔ wəbɛ wəka Amɔr osutɛnɛ kɔ wəbɛ wəka Mohab wəcɔkɔ-cɔkɔ, kɔ wəbɛ wəka Amɔr ɛmbaŋər kɔ atɔf ŋɔn fəp haŋ nde kəŋgbɔkɔ ka Arnɔŋ. ");
INSERT INTO bsp_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","It'ɔŋsɔŋɛ aka taruku ŋaloku: «Nəder Hesbon, dare da Sihɔŋ! Nəcəmbər di, dɔsɔtɔ sɔ fənɔntər! ");
INSERT INTO bsp_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Bawo nɛnc dowur Hesbon, kɔ dɛləsər dare da Sihɔŋ, kɔ dɔncɔf dare da Ar nde atɔf ŋa Mohab, kɔ canu ca yem ca mofo mɛsali nde mɔrɔ ma Arnɔŋ. ");
INSERT INTO bsp_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ah! Pəcuy ponu pɛmbɛk, nəna aka Mohab! Nəsɔlɛ, afum aka Kemos! Sihɔŋ wəbɛ wəka Amɔr ɔsɔŋɛ awut anu arkun kəyɛksɛ, k'ɔsɔŋɛ awut anu aran kəyɔnɛ acar ɔn. ");
INSERT INTO bsp_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Sələmər ’Amɔr cəbəlma: Aləsər Hesbon haŋ Dibɔŋ. Kɔ sələsər Hesbon haŋ Nofa, haŋ kəbəp ka atɔf ŋa Medeba.» ");
INSERT INTO bsp_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Tantɛ tɔ aka Yisrayel ŋanandɛ atɔf ŋa aka Amɔr. ");
INSERT INTO bsp_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Kɔ Musa osom atɛn mes kəkɔcərɛ dare da Yaser. Ti disrɛ kɔ aka Yisrayel ŋasumpər madare mɛkəsək, kɔ ŋambɛləs aka Amɔr akɔ ŋanayi di mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Kɔ aka Yisrayel ŋampɛrnɛ ntende dɔpɔ da Basan. Ɔk, wəbɛ wəka Basan kɔ asɔdar ɔn fəp ŋawur kəkɔsutɛnɛ kɔ aka Yisrayel, kɔ ŋayektər ŋa kəwan nde Edreyi. ");
INSERT INTO bsp_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Kɔ MARIKI oloku Musa: Ta mənesɛ kɔ, imbɛr əm kɔ dəwaca, nkɔn, afum ɔn fəp kɔ atɔf ŋɔn. Məyɔ kɔ tɛfaŋ tam pəmɔ tɔkɔ mənayɔ Sihɔŋ wəbɛ wəka Amɔr, nwɛ ɛnandɛ Hesbon mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Kɔ aka Yisrayel ŋasut Ɔk, afum ɔn kɔ awut ɔn, ali ŋanasak fɛ ayi wəyeŋ, kɔ ŋalɛk atɔf ŋaŋɔkɔ kɛ. ");
INSERT INTO bsp_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Kɔ aka Yisrayel ŋaŋkɔ ŋacəmɛ aranta ŋowosu ŋa Mohab, nde dec dɛmpɛ kəŋgbɔkɔ ka Yurdɛn mɔ, ŋatɛfərnɛ Yeriko. ");
INSERT INTO bsp_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak wan ka Cipor ɛnanəŋk tɔkɔ aka Yisrayel ŋanayɔ aka Amɔr mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Aka Mohab ŋananesɛ dɛlay da afum akaŋɛ, bawo aMohab ŋanane tɔkɔ Yisrayel ŋanayɔ Amɔr mɔ, kɔ dis dɛndɛncɛ ŋa fəp. ");
INSERT INTO bsp_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Kɔ Mohab oloku abeki aka Madiyaŋ: «Ndɛkəl oŋ kəsɔm kɔ kənay kaŋkɛ kənder ca nyɛ yeyi su kəsək mɔ fəp pəmɔ ntɛ wana wɔŋsɔm yɔbɔf ya dalɛ mɔ.» Balak wan ka Cipor ɛnayɔnɛ wəbɛ wəka atɔf ŋa Mohab tɛm tatɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","K'osom ndena Balam wan ka Behor, nwɛ ɛnandɛ Petor ntende kəŋgbɔkɔ ka Ɛfərat kəsək mɔ. K'oloku ntɛ: «Afum alɔma ŋawur Misira ŋalarɛ dɔtɔf, ŋandɛ su tekiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ndɛkəl oŋ məder, ilɛtsɛn'am məntolan'em afum akaŋɛ pəlɛc, bawo ŋayɔ sɔkət ŋatas im. Ti disrɛ tɔlɔma indetam kəsut ŋa ibɛləs ŋa atɔf ŋem, bawo incərɛ nwɛ məntolanɛ pətɔt mɔ, ɔŋsɔtɔ pətɔt, kɔ nwɛ məntolanɛ pəlɛc mɔ, wəkayi ɔŋsɔtɔ pəlɛc.» ");
INSERT INTO bsp_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Abeki aMohab kɔ aMadiyaŋ ŋaŋkɔ, ŋakenɛ wəgbal kəsənc yopocɛ. Kɔ ŋander ŋabəp Balam kɔ ŋaloku kɔ moloku ma Balak. ");
INSERT INTO bsp_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Kɔ Balam oloku ŋa ntɛ: «Nəcepərɛnɛ nnɔ pibi, indeluksɛ nu toloku ntɛ MARIKI endelok'im mɔ.» Kɔ akiriŋ aMohab ŋayi ndena Balam. ");
INSERT INTO bsp_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ntɛ tɛm tɔlɔma tencepər mɔ, kɔ Kanu kənde kəder Balam, kɔ kəyif kɔ: «Afum are ŋayi ndaram-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Kɔ Balam oloku Kanu: «Balak wan ka Cipor, wəbɛ wəka Mohab, nkɔn osom ŋa kədelok'im: ");
INSERT INTO bsp_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Afum aŋɛ ŋawur Misira mɔ ŋalas atɔf. Ndɛkəl, məder məntolan'em ŋa pəlɛc. Tɔlɔma intam kəsut ŋa haŋ ibɛləs ŋa.›» ");
INSERT INTO bsp_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kɔ Kanu kəloku Balam: «Məfɔkɔ kɔ ŋa. Ta mətolanɛ aka Yisrayel pəlɛc, bawo antolanɛ ŋa pətɔt.» ");
INSERT INTO bsp_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kɔ Balam ɛyɛfɛ bətbət k'oloku akiriŋ a Balak: «Nəkɔ nde atɔf ŋonu, bawo MARIKI ɛfati kəsak im kəkɔ kɔ nəna.» ");
INSERT INTO bsp_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kɔ akiriŋ aMohab ŋander ŋabəp Balak kɔ ŋaloku kɔ: «Balam ɛfati kəder kɔ səna.» ");
INSERT INTO bsp_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Kɔ Balak osom sɔ akiriŋ akɔ ŋanala acɔkɔ-cɔkɔ, aŋɛ dekiriŋ daŋan dɛnacepər da akakɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Kɔ ŋander ŋabəp Balak wan ka Cipor, kɔ ŋaloku kɔ: «Ilɛtsɛn'am, ta tes o tes tɛyaməs am kədenəŋk im. ");
INSERT INTO bsp_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Indelas əm pəlel, iyɔn'am tɔkɔ məŋlok'im mɔ. Məder, ilɛtsɛn'am, mətolan'em afum akaŋɛ pəlɛc.» ");
INSERT INTO bsp_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mba kɔ Balam oloku asom a Balak: «Ali Balak pəsɔŋ im gbeti kɔ kɛma fəp nyɛ yeyi nde kəlɔ kɔn mɔ, ifɔtam tɔlɔm o tɔlɔm kəgbaymɛ tosom ta MARIKI, Kanu kem! ");
INSERT INTO bsp_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Awa, ilɛtsɛnɛ nu nəyi nnɔ pibi pampɛ, nəna sɔ, icərɛ ntɛ MARIKI endelok im sɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Kɔ Kanu kəwurər Balam pibi disrɛ, k'oloku kɔ: «Bawo arkun akaŋɛ ŋander kəw'am, məkɔ kɔ ŋa. Mba məyɔ tɔkɔ indelok'əm mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Kɔ Balam ɛyɛfɛ bətbət, k'ɛmbɛkɛ sɔfale sɔn səfɛt kəroŋ kɔ ŋantas kɔ akiriŋ aka Mohab. ");
INSERT INTO bsp_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Kɔ pəntɛlɛ Kanu, bawo Balam ŋaŋkɔ kɔ akiriŋ aMohab. Kɔ mɛlɛkɛ ma MARIKI mɛncəmɛ dɔpɔ kədemɔnɛ kɔ kəcepər. Kɔ Balam ɛmpɛsɛ sɔfale sɔn səfɛt kəroŋ, ŋanayi kɔ acar ɔn mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ntɛ sɔfale sənəŋk mɛlɛkɛ ma MARIKI mɛcəmɛ dɔpɔ mɔtɔmpər dakma mɔ, kɔ sɔfale səŋgbaymɛ dɔpɔ, kɔ səŋkɔ ta dalɛ. Balam osut si ntɛ tɔŋsɔŋɛ səsolnɛ dɔpɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Kɔ mɛlɛkɛ ma MARIKI mɛncəmɛ sɔ dɔpɔ ŋgbɔŋkəlɔ ya wɛn dacɔ, biŋkəli beyi kəca kətɔt kɔ kəmeriya. ");
INSERT INTO bsp_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ntɛ sɔfale sənanəŋk mɛlɛkɛ ma MARIKI mɔ, kɔ səŋgbəcərɛnɛ kəcək ka Balam damba. K'ɔŋgbɔkərɛ sɔ si kəsut. ");
INSERT INTO bsp_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Kɔ mɛlɛkɛ ma MARIKI mecepər pəbɔlɛ, kɔ mɔŋkɔ mɛcəmɛ kəfo kəlɔma kətɔwɔkəl nkɛ antɔtam kəgbaymɛ kəca kətɔt kɔ kəmeriya mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ntɛ sɔfale sənəŋk mɛlɛkɛ ma MARIKI sɔ mɔ, kɔ səfəntərɛ Balam tantɔf. Kɔ pəntɛlɛ Balam k'osutɛ sɔfale kəgbo kɔn. ");
INSERT INTO bsp_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Awa, kɔ MARIKI ɛwani sɔfale kusu, kɔ səloku Balam: «Cəke c'iyɔ ntɛ məsut im tamaas mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Kɔ Balam oloku sɔfale sɔn: «Məfan'im kəfani dəm! Tɔcyɔnɛ a intɔmpər dakma dəkəca-ɛ, k'indif əm ndɛkəl.» ");
INSERT INTO bsp_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kɔ sɔfale səloku Balam: «Bafɔ sɔfale sam s'iyɔnɛ nsɛ məmpɛsɛ tɛm fəp haŋ mɔkɔ mɔ ba? Tantɛ t'imbɔt kəyɔ əm ba?» Kɔ Balam oloku: «Ala!» ");
INSERT INTO bsp_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Kɔ MARIKI emepi fɔr ya Balam, k'ɛnəŋk mɛlɛkɛ ma MARIKI mɛcəmɛ dɔpɔ, mɔtɔmpər dakma dəkəca. Kɔ Balam ontontnɛ, k'ɛncəp suwu kɔ tobu tɔn dəntɔf. ");
INSERT INTO bsp_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Kɔ mɛlɛkɛ ma MARIKI moloku kɔ: «Ta ake tɔ məsutɛ si kəmaas-ɛ? Iwur ntɛ tɔŋsɔŋɛ idemɔn'am kəkɔ, bawo inəŋk marənt mamɛ mentesɛ f'am. ");
INSERT INTO bsp_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Sɔfale sam sənəŋk im, kɔ səngbaym'em kəmaas. Sətɔyɔ tatɔkɔ-ɛ, kɔ mən'indif isak si doru.» ");
INSERT INTO bsp_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Kɔ Balam oloku mɛlɛkɛ ma MARIKI: «Inciya. Incərɛ fɛ a məy'im kiriŋ dɔpɔ. Mba kɔ marənt mamɛ mɔntɔbɔt əm-ɛ, ilukus!» ");
INSERT INTO bsp_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Kɔ mɛlɛkɛ ma MARIKI moloku Balam: «Məkɔ kɔ arkun akaŋɛ. Mba məloku gbəcərəm ntɛ indekɔlok'əm mɔ.» Kɔ Balam ŋaŋkɔ kɔ akiriŋ aka Balak. ");
INSERT INTO bsp_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kɔ Balak ene a Balam ender. K'owur kəkɔfaynɛ kɔ haŋ dare da Mohab ndɛ dɔsɔŋɛnɛ kələncər kɔ Arnɔŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Kɔ Balak oloku Balam: «Bafɔ inaw'am ba? Ak'ɛnasɔŋ'am kətɔder katəna mədenəŋk im-ɛ? Mənacɛm-cɛmnɛ ifɔtam kəsɔŋ əm pəlel?» ");
INSERT INTO bsp_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Kɔ Balam oloku Balak: «Ndɛkəl oŋ, ntɛ inder inəŋk əm mɔ, intam kəlok'əm ntɛ o ntɛ ifaŋ mɔ? Toloku ntɛ Kanu kəndebɛr im dəkusu mɔ, t'indelok'əm!» ");
INSERT INTO bsp_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balam kɔ Balak ŋaŋkɔ, kɔ ŋambɛrɛ dare da Kiriyat-Hucot. ");
INSERT INTO bsp_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak oloŋnɛ cəna kɔ ŋkesiya, k'ɔsɔŋ Balam kɔ akiriŋ aŋɛ ŋanayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Bətbət, kɔ Balak ɛlɛk Balam k'ɛmpɛnɛ kɔ dare da Bamɔt Bal, nde ɛnctam kənəŋk dɛlay da aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Kɔ Balam oloku Balak: «Məcəmbər'em nnɔ metek moloŋnɛ camət-mɛrəŋ, məlomps'em mura camət-mɛrəŋ kɔ ŋkesiya yorkun camət-mɛrəŋ.» ");
INSERT INTO bsp_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak ɛnayɔ tɔkɔ Balam ɛnaloku kɔ mɔ. Balak kɔ Balam ŋancɔfɛ MARIKI tetek toloŋnɛ ntɛ o ntɛ kəroŋ tura tin kɔ aŋkesiya ŋorkun ŋin. ");
INSERT INTO bsp_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kɔ Balam oloku Balak: «Məcəmɛ poloŋnɛ pɔcɔf pam kəsək, ina ibɔlɛ. Tɔlɔma MARIKI pədeder kəbəp im. Indelok'əm ntɛ endementər im mɔ.» Kɔ Balam ɔŋkɔ nde tɔrɔ mpɛ pɔntɔyɔ tɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Kɔ Kanu kəwurər Balam, kɔ Balam oloku Kanu: «Icəmbər metek moloŋnɛ camət-mɛrəŋ, k'iloŋnɛ tetek o tetek kəroŋ tura tin kɔ aŋkesiya ŋorkun ŋin.» ");
INSERT INTO bsp_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Kɔ MARIKI ɛmbɛr moloku Balam dəkusu. K'oloku kɔ: «Məlukus nde Balak eyi mɔ, məloku kɔ ntɛ.» ");
INSERT INTO bsp_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","K'olukus nde Balak eyi mɔ, nwɛ ɛnacəmɛ poloŋnɛ pɔcɔf pɔn kəsək kɔ abɛ aka Mohab fəp. ");
INSERT INTO bsp_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balam oloku taruku ntɛ: «Balak ɔsɔŋ'em kəder kəyɛfɛ Aram, wəbɛ wəka Mohab ɔsɔŋ'em kəder nde mɔrɔ ma kəca nkɛ dec dɛmpɛ mɔ. K'olok'im: ‹Məder mətolanɛ afum a Yakuba pəlɛc! Ɛy, məder, məsɔŋɛ aka Yisrayel kənesɛ!› ");
INSERT INTO bsp_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mba cəke c'intam kətolanɛ pəlɛc nwɛ Kanu nkɔnsərka ɔntɔsɔŋ pəlɛc mɔ? Cəke c'indesɔŋɛ afum kənesɛ aŋɛ MARIKI ɔntɔsɔŋɛ kənesɛ mɔ? ");
INSERT INTO bsp_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Nde masar dətelempan iŋnəŋk afum akaŋɛ, nde mɔrɔ kəroŋ iŋgbətnɛ ŋa: Afum ŋɔ, aŋɛ ŋandɛ taciŋa mɔ, ŋancərɛnɛ a ŋanciyanɛ kɔ tɔf yɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","An'ɛntam kəlɔm dɛlay da aka Yisrayel-ɛ? Afum aka kor ka Yakuba ŋala pəmɔ cɔs. Intola kəfi pəmɔ akɔ ŋaleləs Kanu mɔ, ilip pəmɔ ntɛ aka Yisrayel ŋaŋlip mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Kɔ Balak oloku Balam: «Cəke cɔ məy'em-ɛ? Isɔŋ'am kəder nnɔ kətolanɛ aterɛn'em pəlɛc, mba kɔ məna məntolanɛ ŋa pətɔt.» ");
INSERT INTO bsp_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balam oloku: «K'indelok-loku-ɛ, pəmar fɛ a ickɛmbərnɛ kəloku moloku mmɛ MARIKI ɛmbɛr im dəkusu mɔ ba?» ");
INSERT INTO bsp_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak oloku kɔ: «Məder kɔ ina, ilɛtsɛn'am, kəfo kəlɔma nde məndenəŋk ŋa mɔ. Kəsək kin kɔ məndenəŋk, mba məfɔnəŋk ŋa fəp. Mətolan'em ŋa pəlɛc!» ");
INSERT INTO bsp_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Kɔ Balak eŋkekərɛ Balam haŋ dəkiyi da wəbum, nde telempan pa tɔrɔ ta Piska kəsək. K'ɛncəmbər metek moloŋnɛ camət-mɛrəŋ, k'ɔncɔfɛ MARIKI tetek o tetek tura tin kɔ aŋkesiya ŋorkun ŋin. ");
INSERT INTO bsp_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Kɔ Balam oloku Balak: «Məna məcəmɛ nnɔ, poloŋnɛ pɔcɔf pam kəsək. Ina, ikɔcəŋkəl MARIKI.» ");
INSERT INTO bsp_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Kɔ MARIKI ender kədebəpɛnɛ kɔ Balam. K'ɛmbɛr kɔ toloku tin dəkusu k'oloku kɔ: «Məlukus nde Balak eyi mɔ, məloku kɔ ntɛ.» ");
INSERT INTO bsp_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Kɔ Balam oluksərnɛ nde Balak eyi mɔ, nwɛ ɛnacəmɛ poloŋnɛ pɔcɔf pɔn kəsək mɔ, ŋayi kɔ akiriŋ aMohab. Kɔ Balak eyif kɔ: «Cəke cɔ MARIKI oloku-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kɔ Balam oloku taruku ntɛ: «Məyɛfɛ, Balak, məcəŋkəl im! Məsu aləŋəs ntɛ indelok'əm mɔ, wan ka Cipor! ");
INSERT INTO bsp_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Kanu, bafɔ wərkun ɔfɔ nwɛ eŋyemɛ mɔ, bafɔ fum ɔfɔ nwɛ ɛŋŋaŋnɛ tɛlər mɔ. Ntɛ oloku mɔ, ɔfɔdeyɔ ti ba? Ntɛ oŋloku mɔ, bafɔ ɔŋyɔ ti ba? ");
INSERT INTO bsp_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ina, iwosɛ kətolanɛ afum akaŋɛ pətɔt, bawo MARIKI ɔsɔŋ ŋa pətɔt, ifɔsəkpər. ");
INSERT INTO bsp_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","MARIKI ɛnəŋkɛ fɛ Yakuba pəcuca, ɔfɔnəŋk kətɔrəs aYisrayel dacɔ. MARIKI, Kanu kəŋan, eyi kɔ ŋa. Eŋne kəkulɛ-kulɛnɛ pəbotu paŋan pəmɔ wəbɛ. ");
INSERT INTO bsp_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nkɔn Kanu ɛnawurɛnɛ ŋa Misira, kɔ sɔkət nsɛ səwurɛnɛ sa wana wa dəkulum mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kəgbal kəsənc kəyi fɛ aka Yisrayel dacɔ, dure deyi fɛ nde yuruya ya Yakuba ŋancərɛ tɛm tɔtɔt mes mmɛ Kanu kəŋyɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Afum akaŋɛ ŋaŋyɛfɛ pəmɔ kusunuŋku kəran, ŋacəmɛ pəmɔ kusunuŋku kərkun, nkɛ kəntɔfəntərɛ ta kəntalip kəsɔm wɛsɛm nwɛ kəŋsumpər mɔ, kəmun mecir ma pedif pa ki.» ");
INSERT INTO bsp_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Kɔ Balak oloku Balam: «Kɔ məntɔwosɛ kətolanɛ ŋa pəlɛc-ɛ, ta mətolanɛ ŋa pətɔt ilɛtsɛn'am!» ");
INSERT INTO bsp_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Kɔ Balam oloku kɔ: «Isɔŋ'am ti kəcərɛ: Pəmar iloku ntɛ o ntɛ MARIKI oŋlok'im mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kɔ Balak oloku Balam: «Məder, ilɛtsɛn'am, ikekər'am sɔ kəfo kəlɔma. Tɔlɔma nəŋkɔtəŋnɛ kɔ Kanu a mətolan'em afum akaŋɛ pəlɛc!» ");
INSERT INTO bsp_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kɔ Balak eŋkekərɛ Balam nde telempan pa tɔrɔ ta Peyɔr mpɛ pentilsərnɛ tɛgbərɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Kɔ Balam oloku Balak: «Məcəmbər'em nnɔ metek moloŋnɛ camət-mɛrəŋ məlomps'em mura camət-mɛrəŋ kɔ ŋkesiya camət-mɛrəŋ.» ");
INSERT INTO bsp_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Kɔ Balak ɔyɔ tɔkɔ Balam ɛnaloku kɔ mɔ, k'ɔncɔfɛ MARIKI tura tin kɔ aŋkesiya ŋin tetek toloŋnɛ ntɛ o ntɛ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ntɛ Balam ɛnəŋk a pənabɔt MARIKI kəsɔŋ aka Yisrayel pətɔt mɔ, ɔŋkɔ fɛ sɔ pəmɔ tɔkɔ ɔncyɔ ti mɔ kətɛnəs mɔyɔ mɔn ma dure, k'ɛŋkafəlɛ k'ɛntɛfərnɛ kəca ka dətɛgbərɛ. ");
INSERT INTO bsp_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kɔ Balam eyekti fɔr k'ɛnəŋk aka Yisrayel ŋandɛ cusuŋka cusuŋka, awa kɔ amera ŋa Kanu ŋender kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","K'oloku taruku ntɛ: «Moloku mmɛ mɔ, ina Balam wan ka Behor iloku, ina wərkun nwɛ iŋnəŋk pəcempi cəleŋ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","moloku ma nwɛ eŋne moloku ma Kanu mɔ, ma nwɛ ɛŋnəŋk ntɛ Wəka Fənɔntər eŋmentər kɔ mɔ, moloku ma nwɛ ontontnɛ Kanu fɔr kiriŋ mɔ, fɔr yemepi. ");
INSERT INTO bsp_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Afum aka Yisrayel, nəna aŋɛ nəwur dokom da Yakuba mɔ, cəbal conu ncɛ nəyi mɔ cəntesɛ yati! ");
INSERT INTO bsp_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Cəbal conu cəfəntərɛ pəmɔ dəŋgbəl, pəmɔ lakɔ ndɛ deyi kəŋgbɔkɔ kəsək mɔ, pəmɔ sukum nsɛ MARIKI ɔmbɔf mɔ, pəmɔ tɔk yetes ya sɛdər nyɛ yɛncəmɛ domun kəsək mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Nde ndoronu domun dompurər dəkələmp dɛcdəməs yɔbɔf ya dalɛ. Wəbɛ wəYisrayel endetam Akak, dɛbɛ da Yisrayel dendesɔtɔ fənɔntər. ");
INSERT INTO bsp_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Kanu kənawurɛnɛ ŋa atɔf ŋa Misira, kɔ fənɔntər fəpɔŋ nfɛ fəwurɛnɛ fa wana wa dop mɔ. Ŋaŋmələk afum akɔ ŋaŋwɛkərnɛ ŋa mɔ. Ŋactepi bɛnt ya aterɛnɛ aŋan, ŋacfutɛ ŋa cəbəlma. ");
INSERT INTO bsp_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ŋantontnɛ, ŋafəntərɛ pəmɔ kusunuŋku, pəmɔ kusunuŋku kəran, an'ɛntam ki kəyekti-ɛ? Aka Yisrayel, fum pəsɔtɔ pətɔt nwɛ ontolan'am pətɔt mɔ, pəsɔtɔ pəlɛc nwɛ ontolan'am pəlɛc mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Awa, kɔ pəntɛlɛ Balak pəpɔŋ nnɔ Balam eyi mɔ. K'ompol waca teta mɛtɛlɛ mɔn, k'oloku Balam: «Aterɛnɛ em ŋ'inaw'am kədetolanɛ pəlɛc, kɔ məna mətolanɛ ŋa pətɔt haŋ kəmaas! ");
INSERT INTO bsp_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ndɛkəl oŋ, məyɛfɛ məkɔ nde ndaram! Inaloku a indelas əm pəlel, mba MARIKI ɛmbaŋər əm pəlel papɔkɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Kɔ Balam eyif Balak: «Bafɔ inaloku asom am ntɛ ba? ");
INSERT INTO bsp_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Ali tɔyɔnɛ Balak pəsɔŋ im gbeti kɔ kɛma ka kəlɔ kɔn disrɛ fəp, ifɔtam kəgbɛkəl tosom ta MARIKI kəyɔ ka pətɔt kɔ pəyɔnɛ fɛ ti-ɛ pəlɛc. Tɔkɔ MARIKI endelok’im mɔ, t'indeloku.› ");
INSERT INTO bsp_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ndɛkəl oŋ, intas nde afum em ŋayi mɔ, məder ilok'əm kɔ pəndewon-ɛ, ntɛ aka Yisrayel ŋandeyɔ oŋ afum am mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Kɔ Balam ɛndəŋk toloku ntɛ: «Moloku ma Balam wan ka Behor, moloku ma wərkun nwɛ ɛŋnəŋk pəcempi mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","moloku ma nwɛ eŋne moloku ma Kanu mɔ, ma nwɛ ɛncərɛ mɛcərɛ ma Wəka darenc mɔ, moloku ma ina nwɛ iŋnəŋk mementər ma Wəka Fənɔntər mɔ, ma nwɛ ontontnɛ fɔr ya Kanu kiriŋ mɔ, fɔr yemepi. ");
INSERT INTO bsp_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Iŋnəŋk tɔkɔ tendeder mɔ, mba bafɔ kərɛsna kɔ tendeyi, iŋgbətnɛ ti, mba bafɔ tɛkərɛsna tɔ. Kɔs kəyi kəyɛfɛ yuruya ya Yakuba dacɔ, wəka kəŋgbasar eyi kəyɛfɛ Yisrayel. Kɔ kəŋgbasar kɔn ka dɛbɛ, dɛkəŋk oŋsut ki aMohab, pələsər yuruya ya Sɛt fəp, aŋɛ ŋayɔnɛ acepɛ-cepɛ aka dɔtɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Yisrayel ŋandeyɔ sɔkət. Ŋandebaŋ Edɔm, ŋandebaŋər Sehir, aterɛnɛ ɔn. ");
INSERT INTO bsp_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Wəwur ka dokom da Yakuba endetasərnɛ ŋa, endemələk alpəs akɔ ŋandecəmɛ dare mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Kɔ Balam ɛnəŋk aka Amalɛk k'oloku moloku mmɛ: «Amalɛk ŋɔ akaŋɛ aŋɛ ŋantam fəp mɔ. Kɔ pəndewon-ɛ, andeləsər ŋa few.» ");
INSERT INTO bsp_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kɔ Balam ɛnəŋk sɔ aKeni, k'oloku: «Dəkiyi donu d'ɛncəp, tasar kəroŋ wɔlɔ wonu weyi. ");
INSERT INTO bsp_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mba andemələk nəna aKeni, tɛm ntɛ aka Asur ŋandekekərɛ nu dacar mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kɔ Balam oloku sɔ: «Pəlɛc pere! An'endeyi doru tɛm ntɛ Kanu kəndeyɔ ti mɔ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Cibil cəndeder kəyɛfɛ Sipər, afum akakɔ ŋandesut aka Asur, ŋasut sɔ aka Heber, mba ayɛfɛ Sipər akakɔ sɔ ŋatɛfərnɛ kəmələk kəŋan!» ");
INSERT INTO bsp_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kɔ Balam olukus nde ndɔrɔn, kɔ Balak nkɔn sɔ ɔŋkɔ kəca kɔn. ");
INSERT INTO bsp_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ntɛ aka Yisrayel ŋanandɛ Sitim mɔ, dəndo kɔ ŋayɛfɛ kəcfəntərər ayecəra aMohab. ");
INSERT INTO bsp_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Kɔ ayecəra aMohab akakɔ ŋasɔŋɛ aYisrayel kəcloŋnɛ canu cəŋan, ŋadi yeri ya canu cacɔkɔ, ŋactontnɛnɛ ci. ");
INSERT INTO bsp_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Kɔ aka Yisrayel ŋasektərnɛ teta Bal Peyɔr, kɔ pəntɛlɛ MARIKI nnɔ aka Yisrayel ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Kɔ MARIKI oloku Musa: «Məlɛk abɛ aka Yisrayel fəp, məyɔ pagbɛk ŋa fɔr ya MARIKI kiriŋ ŋatɛfərnɛ dec, ntɛ tɔŋsɔŋɛ mɛtɛlɛ mɔpɔŋ ma MARIKI molukus Yisrayel darəŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kɔ Musa oloku aboc kiti a Yisrayel: «Nwɛ o nwɛ nu dacɔ pədif afum ɔn dacɔ akɔ ŋasektərnɛ teta Bal Peyɔr mɔ!» ");
INSERT INTO bsp_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kɔ wəYisrayel wəlɔma ender pəmentər awɛnc aŋa wəran wəMadiyaŋ wəlɔma, fɔr ya Musa kɔ kəloŋkanɛ ka aka Yisrayel fəp kiriŋ, tɛnatəŋnɛ akakɔ ŋacbok nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. ");
INSERT INTO bsp_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ntɛ Finehas wan wərkun wəka Elasar wansɔ ka Aruna wəloŋnɛ ɛnəŋk kɔ mɔ, k'ɛyɛfɛ kəloŋkanɛ ka aka Yisrayel dacɔ k'ɛlɛk kəŋgbasar. ");
INSERT INTO bsp_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Kɔ Finehas ɛncəmɛ kɔ darəŋ nde aŋgbancan disrɛ nde wəkakɔ ɛnabɛrɛ kɔ wəran wəMadiyaŋ nwɛ mɔ, k'endif ŋa mɛrəŋ maŋan fəp, k'ɔsɔ ŋa cor dəntɔf. Gbəncana babɔkɔ, arom nŋɛ ŋɛnayi aka Yisrayel mɔ, ŋɛncəmɛ. ");
INSERT INTO bsp_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Pəcuy papɔkɔ pɛnadif afum wul wəco mɛrəŋ kɔ maŋkəlɛ (24.000). ");
INSERT INTO bsp_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Wəloŋnɛ Finehas wan wərkun wəka Elasar wansɔ ka Aruna wəloŋnɛ oluksɛ mɛtɛlɛ mem nnɔ aka Yisrayel ŋayi mɔ, bawo ɛnayɛfərɛnɛn'em aka Yisrayel, tɔsɔŋ'em kətɔmələk ŋa mɛtɛlɛ mem ma kəraca disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Awa, məloku Finehas a səsek danapa da pəforu kɔ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Danapa da pəforu dɔn dendeyi, da yuruya yɔn kɔ nkɔn encepər-ɛ, ɔsɔŋɛ ŋa kədeyɔnɛ aloŋnɛ a doru o doru, bawo ementər kəraca ka Kanu kɔn, k'ɔsɔkəs aka Yisrayel kiciya kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Tewe ta wəYisrayel nwɛ anadif kɔ wəran wəMadiyaŋ nwɛ mɔ tɛnayɔnɛ Simri. Wan ka Salu ɛnayi, wəkiriŋ ɛnayɔnɛ kəlɔ ka apa kɔn kusuŋka ka Simeyɔŋ dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Tewe ta wəran wəMadiyaŋ wəkɔ anadif mɔ, tɛnayɔnɛ Kosbi. Wan wəran ka Cur ɛnayi wəbɛ wəka cor cəlarəm ca kusuŋka k'aMadiyaŋ kəlɔma. ");
INSERT INTO bsp_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Nəwɛkərnɛ aMadiyaŋ, nədifət ŋa, ");
INSERT INTO bsp_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","bawo dəmɔyɔ ma Peyɔr kɔ ma Kosbi, cəmpənpən cɔ ŋanawɛkərnɛ nu. Kosbi wəkirɛ kəŋan ɛnayi, wan wəran wəka wəbɛ wəMadiyaŋ wəlɔma. Dɔsɔk da pəlɛc pɔpɔŋ pa Peyɔr d'anadif kɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","Ntɛ pəcuy pɔpɔŋ pencepər mɔ, kɔ MARIKI oloku ŋa sɔ moloku. ");
INSERT INTO bsp_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Kɔ MARIKI oloku Musa kɔ Elasar, wan wərkun wəka wəloŋnɛ Aruna: ");
INSERT INTO bsp_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Nəlɔm aka kəloŋkanɛ ka Yisrayel fəp, kəyɛfɛ arkun aŋɛ ŋasɔtɔ meren wəco mɛrəŋ (20) haŋ ŋacepər ti, dəwɔlɔ kɔ dəwɔlɔ afum fəp aŋɛ ŋantam kəsutɛnɛnɛ Yisrayel mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Dəndo dətɛgbərɛ ta Mohab nde kəŋgbɔkɔ ka Yurdɛn kəsək nde pəntɛfərɛnɛ kɔ Yeriko mɔ, Musa kɔ Elasar ŋaloku aka Yisrayel: ");
INSERT INTO bsp_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Nəlɔm arkun fəp kəyɛfɛ meren wəco mɛrəŋ (20) haŋ pəcepər ti,» pəmɔ tɔkɔ MARIKI osom ti Musa kɔ aka Yisrayel aŋɛ ŋancwur Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Kusuŋka ka Ruben wan wəcɔkɔ-cɔkɔ ka Yakuba, nkɛ kor ka yuruya ya Henok, kɔ ya Palu yowur mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","yuruya ya Hecərɔŋ kɔ ya Karmi. ");
INSERT INTO bsp_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ŋa ŋanayɔnɛ aka cor ca Ruben: Aŋɛ analɔm ŋa dacɔ mɔ, ŋanabəp wul wəco maŋkəlɛ kɔ maas, masar camət-mɛrəŋ kɔ wəco maas (43.730). ");
INSERT INTO bsp_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Wan ka Palu ɔyɔnɛ Eliyab, ");
INSERT INTO bsp_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","papa ka Nemuyel, Dataŋ kɔ Abiram. Dataŋ kɔ Abiram abeki mɛrəŋ aka kəloŋkanɛ ka aYisrayel akaŋɛ ŋanayeŋkər Musa kɔ Aruna səbomp. Ŋa ŋanasolɛ afum masar mɛrəŋ wəco kəcamət (250) a Kore ntɛ ŋanacəmɛ MARIKI dɛbəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Kɔ antɔf ŋɛwani kusu kɔ ŋemer Dataŋ, Abiram kɔ nkɔn Kore. Dɔsɔk dadɔkɔ dɔ kəloŋkanɛ kɔn kəfi fəp, ntɛ nɛnc dɛnacɔf afum masar mɛrəŋ kɔ wəco kəcamət mɔ (250). Kɔ tɔyɔnɛ alpəs akɔ tɛgbɛkərɛ. ");
INSERT INTO bsp_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mba awut a Kore ŋanafi fɛ dɔsɔk dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Kusuŋka ka Simeyɔŋ dəcor kɔ dəcor: Yuruya ya Nemuyel, ya Yamin, kɔ ya Yakin ");
INSERT INTO bsp_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kor ka Serah kɔ ka Sawul. ");
INSERT INTO bsp_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Cor ca Simeyɔŋ cənabəp arkun wul wəco mɛrəŋ kɔ mɛrəŋ, masar mɛrəŋ (22.200). ");
INSERT INTO bsp_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Kusuŋka ka Kad, dəcor kɔ dəcor: Cifiyɔn, Haki kɔ Suni kɔ yuruya yaŋan, ");
INSERT INTO bsp_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osni kɔ Eri kɔ yuruya yaŋan, ");
INSERT INTO bsp_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod kɔ Areli kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Afum aŋɛ analɔm kusuŋka ka Kad dacɔ mɔ, ŋanabəp arkun wul wəco maŋkəlɛ, kɔ masar kəcamət (40.500). ");
INSERT INTO bsp_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yuruya ya Yuda: Er kɔ Onan, mba Er kɔ Onan ŋanafi atɔf ŋa Kanaŋ. ");
INSERT INTO bsp_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Kusuŋka ka Yuda kɔ kaŋkɛ dəcor kɔ dəcor: Kor ka Sela, ka Pɛrɛc kɔ ka Serah kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Cor ca Pɛrɛc cɔ cancɛ: Kor ka Hecərɔŋ kɔ ka Hamul kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Cor ca Yuda cɔ cancɛ, afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco camət-mɛrəŋ kɔ camət-tin, masar kəcamət (76.500). ");
INSERT INTO bsp_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Yuruya ya Isakar yɔ yayɛ dəcor kɔ dəcor: Kor ka Tola kɔ ka Puwa kɔ yuruya yaŋan, ");
INSERT INTO bsp_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kor ka Yasub kɔ ka Simrɔŋ kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Cor ca Isakar cənayi cacɔkɔ, afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco camət-tin kɔ maŋkəlɛ, masar maas (64.300). ");
INSERT INTO bsp_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Yuruya ya Sabulon yɔ yayɛ dəcor kɔ dəcor: Kor ka Sered, ka Elon kɔ ka Yalel, kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Cor ca Sabulon cənayi cacɔkɔ, afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco camət-tin, masar kəcamət (60.500). ");
INSERT INTO bsp_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yuruya ya Isifu yɔ yayɛ dəcor kɔ dəcor: Kor ka Manase kɔ ka Efrayim. ");
INSERT INTO bsp_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Yuruya ya Manase yɔ yayɛ: Kor ka Makir kɔ ka Kalad. Makir ɛnakom Kalad, kɔ yuruya ya Kalad ŋa sɔ ŋanayɔnɛ cor cəlɔma. ");
INSERT INTO bsp_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Cor ca Kalad cɔ cancɛ: Kor ka Yeser kɔ ka Helek, ");
INSERT INTO bsp_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","kor ka Asriyel kɔ ka Sɛkɛm, ");
INSERT INTO bsp_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kor ka Semida kɔ ka Hefer. ");
INSERT INTO bsp_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Mba Celofad wan ka Hefer ɛnasɔtɔ fɛ wan wərkun, mɛnɛ awut aran. Mewe ma awut ɔn aran mɔ mamɛ: Mala, Noha, Hokəla, Milka kɔ Tirsa. ");
INSERT INTO bsp_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Cor ca Manase cənayi cacɔkɔ, afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco kəcamət kɔ mɛrəŋ, masar camət-mɛrəŋ (52.700). ");
INSERT INTO bsp_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Yuruya ya Efrayim yɔ yayɛ dəcor kɔ dəcor: Kor ka Sutela, kor ka Beker kɔ ka Tahan kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Kor ka Sutela kɔ kaŋkɛ: Eran kɔ yuruya yɔn. ");
INSERT INTO bsp_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Cor ca Efrayim cɔ cancɛ, afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco maas kɔ mɛrəŋ, masar kəcamət (32.500). Yuruya ya Isifu yɔ yayɔkɔ dəcor kɔ dəcor. ");
INSERT INTO bsp_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Yuruya ya Beŋyamin yɔ yayɛ dəcor kɔ dəcor: Kor ka Bela, ka Asbel kɔ ka Ahiram kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Kor ka Sufam kɔ ka Hufam kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Yuruya ya Bela ŋanayɔnɛ Ardu kɔ Naman. ");
INSERT INTO bsp_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Yuruya ya Beŋyamin yɔ yayɔkɔ dəcor kɔ dəcor. Afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco maŋkəlɛ kɔ kəcamət, masar camət-tin (45.600). ");
INSERT INTO bsp_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Yuruya ya Dan yɔ yayɛ dəcor kɔ dəcor: Kor ka Suham. Cor ca Dan cənayi cacɔkɔ dəcor kɔ dəcor. ");
INSERT INTO bsp_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Afum aŋɛ analɔm nde cor ca Suham mɔ ŋanabəp arkun wul wəco camət-tin kɔ maŋkəlɛ, masar maŋkəlɛ (64.400). ");
INSERT INTO bsp_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Yuruya ya Asɛr dəcor kɔ dəcor: Kor ka Yimna, ka Yiswi kɔ ka Beriya. ");
INSERT INTO bsp_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Yuruya ya Beriya: Kor ka Heber kɔ ka Malkiyel kɔ yuruya yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Tewe ta wan wəran wəka Asɛr tɛnayɔnɛ Serah. ");
INSERT INTO bsp_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Yuruya ya Asɛr yɛnayi yayɔkɔ dəcor kɔ dəcor: Afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco kəcamət kɔ maas, masar maŋkəlɛ (53.400). ");
INSERT INTO bsp_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Yuruya ya Naftali dəcor kɔ dəcor: Kor ka Yacel kɔ ka Kuni, ");
INSERT INTO bsp_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","kor ka Yecer kɔ ka Silem. ");
INSERT INTO bsp_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Cor ca Naftali cənayi cacɔkɔ dəcor kɔ dəcor, afum aŋɛ analɔm ŋa dacɔ mɔ ŋanabəp arkun wul wəco maŋkəlɛ kɔ kəcamət, masar maŋkəlɛ (45.400). ");
INSERT INTO bsp_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Afum aŋɛ analɔm aka Yisrayel dacɔ ŋanabəp afum wul masar camət-tin kɔ pin, masar camət-mɛrəŋ kɔ wəco maas (601.730). ");
INSERT INTO bsp_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Kəyer ŋa kɔ ander atɔf, ŋɔyɔnɛ kɛ kəŋan tɔkɔ ŋalanɛnɛ afum mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Afum akɔ ŋandenaŋkanɛ kəla mɔ, məsɔŋ ŋa kɛ nkɛ kənaŋkanɛ kəbɛk mɔ, akɔ ŋampicɛ afum mɔ, məsɔŋ ŋa kɛ nkɛ kəmpicɛ mɔ, andesɔŋ nwɛ o nwɛ kɛ kɔn tɔkɔ alanɛnɛ afum aŋɛ alɔm mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Mba yampuŋpuŋ y'andekot kəyer nu atɔf, andeyer nu kɛ dəcusuŋka kɔ dəcusuŋka. ");
INSERT INTO bsp_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Yampuŋpuŋ y'andekot kəyer kɛ akɔ ŋala kɔ akɔ ŋampicɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Afum aŋɛ ŋ'analɔm kusuŋka ka Lewy dəcor kɔ dəcor: Kor ka Kerson, kor ka Kehat kɔ ka Merari. ");
INSERT INTO bsp_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Cusuŋka cancɛ cəyɔ cor cəfɛt cəlɔma: Kor ka Libni, ka Hebərɔŋ, ka Mali, ka Musi kɔ ka Kore. Kehat nkɔn okom Amram. ");
INSERT INTO bsp_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Tewe ta wəran ka Amram tɛnayɔnɛ Yokɛbɛd wan wəran wəka Lewy. Anakom kɔ ntɛ Lewy ɛnayi Misira mɔ. Yokɛbɛd oŋkomsɛ Amram: Aruna, Musa, kɔ Miriyam wəkirɛ kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Awut a Aruna ŋayɔnɛ Nadab, Abihu, Elasar, kɔ Itamar. ");
INSERT INTO bsp_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab kɔ Abihu ŋa ŋanafi ntɛ ŋanamentərnɛ fɔr ya MARIKI kiriŋ ŋacɔfɛ kɔ suray nsɛ antɔpusɛ MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ALewy arkun aŋɛ analɔm aYisrayel dacɔ, aŋɛ ŋanayɔ ŋof ŋin ŋacepər ti mɔ, ŋanabəp wul wəco mɛrəŋ kɔ maas (23.000). Kəlɔm kəŋan kənadeŋərnɛ fɛ kəlɔm ka aka Yisrayel dacɔ, bawo anasɔŋ fɛ aka Lewy kɛ aka Yisrayel dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Afum aŋɛ ŋɔ Musa kɔ Elasar wəloŋnɛ ŋanalɔm nde aranta ŋowosu ŋa Mohab, dəndo kəŋgbɔkɔ ka Yurdɛn kəsək, nde pəntɛfərnɛ kɔ dare da Yeriko mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","AYisrayel aŋɛ dacɔ, ali fum wəkin ɛnayi fɛ di ntɛ Musa kɔ Aruna wəloŋnɛ ŋanalɔm aka Yisrayel cɔkɔ-cɔkɔ nde dətɛgbərɛ ta Sinayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Teta aŋɛ ŋanafi mɔ, MARIKI ɛnaloku: «Ŋandefi dətɛgbərɛ, ali wəkin ɔfɔdeyi doru, mɛnɛ Kalɛb wan ka Yefune, kɔ Yosuwe wan ka Nun.» ");
INSERT INTO bsp_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Dɔsɔk dɔlɔma, kɔ awut aran aka Celofad, wan ka Hefer, wansɔ ka Kalad wəka Makir, aka cusuŋka ka Manase wan ka Isifu, ŋamentərnɛ. Mewe ma awut aran akakɔ mɔ mamɛ: Mala, Noha, Hokəla, Milka kɔ Tirsa. ");
INSERT INTO bsp_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Kɔ awut aran aŋɛ ŋaŋkɔ ŋamentərnɛ fɔr ya Musa kiriŋ, wəloŋnɛ Elasar, akiriŋ kɔ kəloŋkanɛ fəp nde dəkəbɛrɛ da aŋgbancan ŋɛbəpɛnɛ kɔ Kanu. Kɔ ŋaloku: ");
INSERT INTO bsp_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Papa kosu efi nde dətɛgbərɛ, ɛnayi fɛ kəloŋkanɛ ka Kore dacɔ nkɛ kənafani MARIKI mɔ: Kiciya kɔn yati kɔ efinɛ, ɛsak fɛ wan wərkun. ");
INSERT INTO bsp_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kətɔyɔ ka papa kosu wan wərkun kəndesɔŋɛ padeliŋ tewe tɔn kor kɔn disrɛ ba? Awa nəsɔŋ su kɛ awɛnc a papa kosu dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Kɔ Musa ementər tetaŋan fɔr ya MARIKI kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Awut aran a Celofad ŋayɔ kance. Nəsɔŋ ŋa antɔf kɛ awɛnc a kas kəŋan dacɔ, ŋa ŋɔ məndesɔŋ kɛ ka kas kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Məloku aYisrayel: Kɔ fum wəlɔma efi ta ɛsak wan wərkun-ɛ, nəsɔŋ kɛ kɔn wan kɔn wəran. ");
INSERT INTO bsp_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","K'ɔntɔyɔ wan wəran-ɛ, nəsɔŋ kɛ kɔn awɛnc aŋa arkun. ");
INSERT INTO bsp_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Mba kɔ wəfi wəkakɔ ɔntɔyɔ awɛnc arkun-ɛ, nəsɔŋ kɛ kɔn awɛnc a kas. ");
INSERT INTO bsp_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kɔ kas ɔntɔyɔ awɛnc-ɛ, nəsɔŋ kɛ kɔn wəkomɛnɛ kɔn nwɛ ŋaŋgbəcɛnɛ kor kəŋan disrɛ mɔ. Nkɔn pəmar pəsɔtɔ ki. Tendeyɔnɛ aka Yisrayel sariyɛ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Kɔ MARIKI oloku Musa: «Məpɛ tɔrɔ pa Abarim kəroŋ, məmɔmən atɔf nŋɛ isɔŋ aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Məndenəŋk ŋi, mba məndefi ta məmbɛrɛ di-ɛ, pəmɔ tɔkɔ tɔsɔtɔ wɛnc əm Aruna mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","bawo nənayeŋkər mosom mem səbomp nde tɛgbərɛ ta Cin, ntɛ kəloŋkanɛ kəctɛnsər im kəcɔp mɔ: Nənamentər fɛ decempi dem fɔr ya Yisrayel kiriŋ.» Ntɛ tɔyɔnɛ ta domun da Meriba nde Kadɛs nde tɛgbərɛ ta Cin mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Kɔ Musa oloku MARIKI: ");
INSERT INTO bsp_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«MARIKI, Kanu nkɛ kəntɔmpər kəpɛnɛ kɔ kətorɛ kifir ka yeyi wəyeŋ ya doru fəp mɔ, məcəmbər wəkiriŋ wərkun kəloŋkanɛ kaŋkɛ, ");
INSERT INTO bsp_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","nwɛ ende pəcsolɛ ŋa kɔ ŋaŋkɔ ŋacder sɔ mɔ, ta kəloŋkanɛ ka MARIKI kədeyi pəmɔ yɔcɔl nyɛ yɔntɔyɔ wəkɛk mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Kɔ MARIKI oloku Musa: «Məlɛk Yosuwe wan ka Nun, wərkun nwɛ isɔŋ amera ŋem mɔ. Mədeŋər kɔ kəca. ");
INSERT INTO bsp_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Məkɔ məcəmbər kɔ wəloŋnɛ Elasar kɔ kəloŋkanɛ fəp kiriŋ, məsɔŋ kɔ mosom fɔr yaŋan kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Məndesɔŋ kɔ pelel pam pɔlɔma, ntɛ tɔŋsɔŋɛ kəloŋkanɛ ka aka Yisrayel fəp kəccəŋkəl kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Yosuwe ende pəccəmɛ wəloŋnɛ Elasar tekiriŋ. Wəloŋnɛ pəyifɛ kɔ ina MARIKI masar ma kiti mmɛ mɔyɔnɛ Yurim mɔ. Mosom mamɔkɔ mɔ aka Yisrayel ŋande ŋackɔnɛ ŋacderɛnɛ sɔ, nkɔn Yosuwe kɔ kəloŋkanɛ ka aka Yisrayel fəp.» ");
INSERT INTO bsp_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Kɔ Musa ɔyɔ tɔkɔ MARIKI ɛnasom kɔ mɔ. K'ɛlɛk Yosuwe k'ɛncəmbər kɔ wəloŋnɛ Elasar kɔ kəloŋkanɛ fəp fɔr kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Kɔ Musa endeŋər Yosuwe waca, k'ɔsɔŋ kɔ mosom, pəmɔ tɔkɔ MARIKI ɛnaloku ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Kɔ MARIKI osom Musa: ");
INSERT INTO bsp_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Məloku aka Yisrayel tosom ntɛ: Nəde nəckɛmbərnɛ belbel kəckɛr'em yoloŋnɛ nyɛ yɔyɔnɛ yopocɛ yem, tɛm ntɛ ambonc mɔ, yeri yem, yoloŋnɛ yɔcɔf nyɛ ambɔnc ŋa yi ŋontorɛ-tor'em abəkəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Məde məloku ŋa sɔ: Yoloŋnɛ yɔcɔf yɔ nəndekenɛ MARIKI: Dɔsɔk o dɔsɔk nəde nəccɔfɛ MARIKI ŋkesiya yorkun mɛrəŋ ya teren tin tin yɔtɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mənde məcloŋnɛ aŋkesiya ŋorkun ŋɔcɔkɔ-cɔkɔ bətbət, kɔ ŋa mɛrəŋ dec dɔrɔfɔy. ");
INSERT INTO bsp_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Teta kəloŋnɛ ka mɛŋgbɛn, məde məckɛrɛ kilo maas ka kəmbefe kətɔt mənɔktərɛnɛ ki litɛr din kɔ dacɔ da moro ma olif mɔtɔt. ");
INSERT INTO bsp_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Yɔcɔl yoloŋnɛ yayɔkɔ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ yede yocwurɛnɛ kɔ yɔkɔ anacop kəloŋnɛ kɔ nde tɔrɔ ta Sinayi mɔ. Ambɔnc ŋa yi ŋontorɛ-torɛ MARIKI abəkəc, kəloŋnɛ ka yeri nkɛ ancɔfɛ MARIKI mɔ kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Aŋkesiya ŋorkun nŋɛ o nŋɛ, məloŋər wɛn litɛr din kɔ dacɔ teta kəloŋnɛ ka wɛn. Məloŋər wi nde dəkiyi dosoku. ");
INSERT INTO bsp_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Dec dɔrɔfɔy, məloŋnɛ aŋkesiya ŋorkun ŋa mɛrəŋ, toloŋnɛ tin tayi pəmɔ yoloŋnɛ ya mɛŋgbɛn ya bətbət, kɔ kəloŋnɛ ka wɛn wa ki. Kəloŋnɛ ka yeri kɔ nkɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa ki ŋontorɛ-torɛ kɔ abəkəc.» ");
INSERT INTO bsp_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Simiti, dɔsɔk da kəŋesəm ndɛ ampusɛ MARIKI mɔ, nəde nəcloŋnɛ ŋkesiya yorkun mɛrəŋ ya teren tin tin yɔtɔyɔ dolokəp. Teta kəloŋnɛ ka mɛŋgbɛn, məkɛrɛ sɔ kəmbefe kətɔt kilo camət-tin panɔktərɛnɛ ki moro kɔ kəloŋnɛ ka wɛn wa ki. ");
INSERT INTO bsp_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Dɔsɔk o dɔsɔk nəde nəcloŋnɛ MARIKI poloŋnɛ pɔcɔf bətbət kɔ dɔfɔy. Mba dɔsɔk da kəŋesəm ndɛ ampusɛ kɔ mɔ, nəde nəcdeŋər poloŋnɛ pɔcɔf papɔkɔ kɔ wɛn wa pi.» ");
INSERT INTO bsp_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Dɔsɔk dɔcɔkɔ-cɔkɔ da yof yonu fəp, nəkɛrɛ MARIKI yoloŋnɛ yɔcɔf yayɛ: Mura mɛrəŋ, aŋkesiya ŋorkun ŋin kɔ ŋkesiya yorkun camət-mɛrəŋ ya teren tin tin yɔtɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Nəde nəcdeŋər sɔ yoloŋnɛ yayɔkɔ teta kəloŋnɛ ka mɛŋgbɛn: Tura mpɛ o mpɛ kəmbefe kətɔt kilo camət-maŋkəlɛ panɔktərɛnɛ ki moro kɔ aŋkesiya ŋorkun nŋɛ o nŋɛ kəmbefe kətɔt kilo camət-tin panɔktərɛnɛ ki moro, ");
INSERT INTO bsp_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ padeŋər ŋi poloŋnɛ pa mɛŋgbɛn pa kəmbefe kətɔt kilo kəmaas panɔktərɛnɛ ki moro. Kəloŋnɛ ka pɔcɔl mpɛ ancɔfɛ MARIKI mɔ pɔ, ambɔnc ŋa poloŋnɛ pɔcɔf papɔkɔ ŋontorɛ-torɛ kɔ abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Nədeŋər sɔ kəloŋnɛ ka wɛn: Teta tura mpɛ o mpɛ nəkɛrɛ litɛr maas, teta aŋkesiya ŋorkun litɛr mɛrəŋ, kɔ teta aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ litɛr din kɔ dacɔ. Yoloŋnɛ yɔcɔl yɔcɔf yayɛ yɔ pəmar nənde nəcloŋnɛ tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋofu ŋa teren fəp. ");
INSERT INTO bsp_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Nəkɛrɛ sɔ MARIKI ambiyofo ŋin teta kəloŋnɛ ka kiciya, nənɔcər ŋi yoloŋnɛ yayɔkɔ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ, kɔ kəloŋnɛ ka wɛn wa yi. ");
INSERT INTO bsp_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Ŋof ŋɔcɔkɔ-cɔkɔ ŋa teren, tataka ta wəco kɔ maŋkəlɛ (14), nəboc kəsata ka kəcɛm-cɛməs ka Kəcepər ka mɛlɛkɛ medif kəleləs ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Tataka ta wəco kɔ kəcamət (15) ta ŋof ŋaŋɔkɔ, nəde nəcbocɛ MARIKI kəsata ka Cəcom cətɔnɔŋkəl lebin. Nəde nəcsɔm cəcom cətɔnɔŋkəl lebin mata camət-mɛrəŋ camcam. ");
INSERT INTO bsp_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Dɔsɔk dɔcɔkɔ-cɔkɔ da tataka toluksər tayi, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ! ");
INSERT INTO bsp_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Nəde nəkɛrɛ MARIKI yoloŋnɛ nyɛ nəndecɔfɛ kɔ mɔ teta poloŋnɛ pɔcɔf: Mura mɛrəŋ, aŋkesiya ŋorkun ŋin kɔ ŋkesiya yorkun camət-mɛrəŋ ya teren tin tin. Nəlɛk yɔcɔl yɔtɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pɔcɔl mpɛ o mpɛ, nədeŋər pi kəmbefe kətɔt ka poloŋnɛ pa mɛŋgbɛn panɔktərɛnɛ ki kɔ moro: Tura mpɛ o mpɛ kilo camət-maŋkəlɛ kɔ aŋkesiya ŋorkun kilo camət-tin, ");
INSERT INTO bsp_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ kilo kəmaas. ");
INSERT INTO bsp_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Nəkɛrɛ ambiyofo ŋin teta kəloŋnɛ ka kiciya, ntɛ tɔŋsɔŋɛ patubucnɛ kəsɔkəs nu kiciya konu mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Yoloŋnɛ yayɔkɔ yɔ nəde nədeŋər sɔ yoloŋnɛ nyɛ ancɔfɛ MARIKI bətbət, nyɛ ancɔfɛ kɔ dɔsɔk o dɔsɔk mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Dɔsɔk o dɔsɔk mata camət-mɛrəŋ disrɛ nəde nəckɛrɛ yoloŋnɛ yayɔkɔ, yi yɔyɔnɛ yoloŋnɛ ya yeri nyɛ ancɔfɛ MARIKI mɔ. Ambɔnc ŋa yi ŋontorɛ-torɛ kɔ abəkəc. Padeŋər yi sɔ yoloŋnɛ ya dɔsɔk o dɔsɔk nyɛ ancɔfɛ MARIKI mɔ, kɔ kəloŋnɛ ka wɛn wa yi. ");
INSERT INTO bsp_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Tataka ta camət-mɛrəŋ, kəloŋkanɛ kəsoku kɔ teta kəleləs MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Dɔsɔk ndɛ nəntɛl yokom yɔcɔkɔ-cɔkɔ ya antɔf ŋonu mɔ, nəde nəckɛr'em yoloŋnɛ ya mɛŋgbɛn mofu ma yɛtɛl yonu. Dɔsɔk da kəsata ka Mataka Moluksər dadɔkɔ, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs ina MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nəkɛrɛ MARIKI yoloŋnɛ nyɛ ancɔfɛ kɔ mɔ: Mura mɛrəŋ, aŋkesiya ŋorkun ŋin kɔ ŋkesiya yorkun camət-mɛrəŋ ya teren tin tin. Ambɔnc ŋa yi ŋotorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pɔcɔl o pɔcɔl, nəloŋnɛnɛ pi kəmbefe kətɔt nkɛ anɔktərɛnɛ kɔ moro mɔ: Teta tura o tura nədeŋər kilo camət-maŋkəlɛ, teta aŋkesiya ŋorkun nŋɛ o nŋɛ kilo camət-tin, ");
INSERT INTO bsp_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","kɔ teta aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ kilo kəmaas. ");
INSERT INTO bsp_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Nəloŋnɛ sɔ ambiyofo ŋin teta kətubucnɛ kəsɔkəs nu kiciya konu. ");
INSERT INTO bsp_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Nədeŋər yoloŋnɛ yayɔkɔ fəp yoloŋnɛ yɔcɔf ya dɔsɔk o dɔsɔk kɔ yoloŋnɛ ya mɛŋgbɛn nyɛ andeŋər yi mɔ. Nəde nəckɛrɛ yɔcɔl nyɛ yɔntɔyɔ dolokəp mɔ, kɔ yoloŋnɛ ya wɛn. ");
INSERT INTO bsp_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Dɔsɔk dɔcɔkɔ-cɔkɔ da ŋof ŋa camət-mɛrəŋ, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs ina MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. Dɔsɔk ndɛ aŋfula aluk cawon cawon mɔ pəbotu pɔ. ");
INSERT INTO bsp_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Nəde nəcloŋnɛ MARIKI yɔcɔl yɔcɔf, ambɔnc ŋa yoloŋnɛ yayɔkɔ ŋontorɛ-torɛ kɔ abəkəc: Tura tin, aŋkesiya ŋorkun ŋin kɔ ŋkesiya yorkun ya teren tin tin camət-mɛrəŋ, fəp fa yi ta yɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Nəkɛrɛ sɔ yoloŋnɛ ya mɛŋgbɛn ya yi, kəmbefe kətɔt nkɛ anɔktərɛnɛ kɔ moro mɔ: Teta tura o tura kəmbefe kilo camət-maŋkəlɛ, teta aŋkesiya ŋorkun kəmbefe kilo camət-tin, ");
INSERT INTO bsp_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","teta aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ kəmbefe kilo kəmaas. ");
INSERT INTO bsp_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mədeŋər sɔ ambiyofo ŋin teta kətubucnɛ kəsɔkəs nu kiciya konu. ");
INSERT INTO bsp_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Padeŋər yɔcɔl yoloŋnɛ yayɔkɔ kəloŋnɛ nkɛ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ. Padeŋər sɔ yi yɔcɔl yoloŋnɛ yɔcɔf ya dɔsɔk dɔcɔkɔ-cɔkɔ da ŋof o ŋof kɔ yoloŋnɛ ya mɛŋgbɛn kɔ yoloŋnɛ ya wɛn ya yi. Ambɔnc ŋa yoloŋnɛ yɔcɔf yayɔkɔ fəp ŋontorɛ-torɛ MARIKI abəkəc. ");
INSERT INTO bsp_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Tataka ta wəco ta ŋof ŋa camət-mɛrəŋ, nəde nəcwe kəloŋkanɛ kəsoku, nəsuŋ ta nəbəc ntɛ o ntɛ dɔsɔk dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nəkenɛ MARIKI yoloŋnɛ yɔcɔf, ambɔnc ŋa yi ŋontorɛ-torɛ kɔ abəkəc: Tura tin, aŋkesiya ŋorkun ŋin kɔ ŋkesiya yorkun camət-mɛrəŋ ya teren tin tin nyɛ yɔntɔyɔ dolokəp mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Yoloŋnɛ ya mɛŋgbɛn ya yi yɔyɔnɛ kəmbefe kətɔt nkɛ anɔktərɛnɛ moro mɔ: Kəmbefe kaŋkɔ kilo camət-maŋkəlɛ teta tura tin, kilo camət-tin teta aŋkesiya ŋorkun, ");
INSERT INTO bsp_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","kəmbefe kətɔt kilo kəmaas teta aŋkesiya ŋorkun ŋa teren tin nŋɛ o nŋɛ. ");
INSERT INTO bsp_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Nəkɛrɛ sɔ ambiyofo teta kəloŋnɛ ka kiciya, kədeŋər ka kəloŋnɛ ka kətubucnɛ kəsɔkəs ka kiciya, padeŋər sɔ yoloŋnɛ nyɛ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ, yoloŋnɛ ya mɛŋgbɛn kɔ ya wɛn wa yi. ");
INSERT INTO bsp_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Tataka ta wəco kɔ kəcamət ta ŋof ŋa camət-mɛrəŋ, nəde nəcwe kəloŋkanɛ kəsoku teta kəleləs ka ina MARIKI. Ta nəbəc dɔsɔk dadɔkɔ yɛbəc nyɛ o nyɛ nəmbɔt bəc mɔ. Nəbocɛ MARIKI kəsata mata camət-mɛrəŋ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Nəkekərɛ yɔcɔl yɔcɔf, yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, ambɔnc ŋa yoloŋnɛ yayɔkɔ ŋontorɛ-torɛ MARIKI abəkəc: Mura wəco kɔ maas, ŋkesiya yorkun mɛrəŋ kɔ ŋkesiya wəco kɔ maŋkəlɛ ya teren tin tin, yi fəp yɔtɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Yoloŋnɛ ya mɛŋgbɛn ya yi yɔyɔnɛ kəmbefe kətɔt nkɛ anɔktərɛnɛ moro mɔ: Teta tura o tura nəkɛrɛ kəmbefe kilo camət-maŋkəlɛ, teta aŋkesiya ŋorkun nŋɛ o nŋɛ kəmbefe kilo camət-tin, ");
INSERT INTO bsp_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ŋkesiya ya teren tin tin wəco kɔ maŋkəlɛ kəmbefe kilo kəmaas teta nŋɛ o nŋɛ, ");
INSERT INTO bsp_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","nəkɛrɛ sɔ ambiyofo teta kəloŋnɛ ka kiciya, nədeŋər sɔ yoloŋnɛ nyɛ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ, kɔ kəloŋnɛ ka mɛŋgbɛn kɔ ka wɛn wa yi. ");
INSERT INTO bsp_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","34","Kəyɛfɛ tataka ta mɛrəŋ haŋ ta camət-mɛrəŋ ta kəsata, nəcdeŋər kəloŋnɛ nkɛ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ, nəcloŋnɛ yɔcɔl yɔtɔyɔ dolokəp, yoloŋnɛ ya mɛŋgbɛn ya kəmbefe kɔ wɛn wa yi. Yɔcɔl nyɛ yɔ nənde nəcloŋnɛ: Dɔsɔk da mɛrəŋ: Mura wəco kɔ mɛrəŋ, ŋkesiya yorkun mɛrəŋ, ŋkesiya wəco kɔ maŋkəlɛ ya teren tin tin, kɔ ambiyofo ŋin. Dɔsɔk da maas: Mura wəco kɔ pin, ŋkesiya yorkun mɛrəŋ, ŋkesiya yorkun wəco kɔ maŋkəlɛ ya teren tin tin, kɔ ambiyofo ŋin. Dɔsɔk da maŋkəlɛ: Mura wəco, ŋkesiya yorkun mɛrəŋ, ŋkesiya yorkun wəco kɔ maŋkəlɛ ya teren tin tin, kɔ ambiyofo ŋin. Dɔsɔk da kəcamət: Mura camət-maŋkəlɛ, ŋkesiya yorkun mɛrəŋ, ŋkesiya yorkun wəco kɔ maŋkəlɛ ya teren tin tin, kɔ ambiyofo ŋin. Dɔsɔk da camət-tin: Mura camət-maas, ŋkesiya yorkun mɛrəŋ, ŋkesiya yorkun wəco kɔ maŋkəlɛ ya teren tin tin, kɔ ambiyofo ŋin. Dɔsɔk da camət-mɛrəŋ: Mura camət-mɛrəŋ, ŋkesiya yorkun mɛrəŋ, ŋkesiya yorkun wəco kɔ maŋkəlɛ ya teren tin tin kɔ ambiyofo ŋin. ");
INSERT INTO bsp_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Tataka ta camət-maas ta kəsata, kəloŋkanɛ kəlpəs kɔ. Ta nəbəc ntɛ o ntɛ nəmbɔt bəc mɔ dɔsɔk dadɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Nəkekərɛ yɔcɔl nyɛ ancɔfɛ MARIKI mɔ yoloŋnɛ yɔcɔf nyɛ ambɔnc ŋa yi ŋontorɛ-torɛ kɔ abəkəc mɔ: Tura tin, aŋkesiya ŋorkun ŋin kɔ ŋkesiya yorkun camət-mɛrəŋ ya teren tin tin, fəp fa yi ta yɔyɔ dolokəp. ");
INSERT INTO bsp_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Pɔcɔl o pɔcɔl, pəmar paloŋnɛnɛ pi kəmbefe kɔ wɛn kətubcɛnɛ ka ntɛ sariyɛ səloku nu ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Nəloŋnɛ sɔ ambiyofo teta kəloŋnɛ ka kiciya, nədeŋər yoloŋnɛ nyɛ ancɔfɛ MARIKI dɔsɔk o dɔsɔk mɔ, nədeŋər sɔ kəloŋnɛ ka mɛŋgbɛn kɔ ka wɛn nwɛ aŋloŋnɛnɛ yi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Yoloŋnɛ yayɛ yɔ nənde nəckɛrɛ MARIKI mataka ma kəsata. Nədeŋər yi yoloŋnɛ ya kədɛrəm, yoloŋnɛ ya kəpocɛ abəkəc ŋosoku pɛs, yoloŋnɛ nyɛ ancɔfɛ MARIKI mɔ, ya mɛŋgbɛn, ya wɛn kɔ ya kəpaŋnɛ pəforu. ");
INSERT INTO bsp_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Kɔ Musa oloku aka Yisrayel tɔkɔ MARIKI ɛnasom kɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Kɔ Musa oloku akiriŋ a cusuŋka ca Yisrayel: «Ntɛ tɔ MARIKI osom: ");
INSERT INTO bsp_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Kɔ fum ɛndɛrəm kəkɛrɛ MARIKI poloŋnɛ, kɔ pəyɔnɛ fɛ ti pəŋaŋnɛ tes tɔlɔma, pəmar fɛ pəyi ta ɛlas dim dɔn-ɛ, pəyɔ tɔkɔ oloku mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Kɔ wəyecəra ɔsɔrɔyi ndena kas, pədɛrəm kəyɔnɛ MARIKI tes tɔlɔma, ");
INSERT INTO bsp_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","kɔ kas ɛncərɛ kədɛrəm kaŋkɔ ta oloku tɔlɔm o tɔlɔm-ɛ, wan wəran pəmar pəlas dim dɔn, pəyɔ tɔkɔ ɛnadɛrəm kəyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Mba dɔsɔk ndɛ kas ɛncərɛ ti, pəloku a owosɛ fɛ kədɛrəm ka wan kɔn wəran mɔ, wan wəran nwɛ ɛntam kəyi ta ɛlas dim dɔkɔ ɛnadɛrəm mɔ. MARIKI ɛŋaŋnɛnɛ kɔ kədɛrəm kɔn, bawo kas owosɛ fɛ. ");
INSERT INTO bsp_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Kɔ wəyecəra ɛndɛrəm, kɔ pəyɔnɛ fɛ ti pəsɔŋ temer kəyɔ tes tɔlɔma ta ɛncɛm-cɛmnɛ, tecepər pəde pəlɔ tɛlpəs, ");
INSERT INTO bsp_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","dɔsɔk ndɛ wos ɛncərɛ ti ta oloku tɔlɔm o tɔlɔm-ɛ, pəmar pəlas dim dɔkɔ ɛnadɛrəm mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Mba dɔsɔk ndɛ wos ɛncərɛ ti, pəloku a owosɛ fɛ kədɛrəm ka wəran kɔn mɔ-ɛ, wəran nwɛ ɛntam kəyi ta ɛlas dim dɔkɔ ɛnadɛrəm mɔ. MARIKI ɛŋaŋnɛnɛ kɔ kədɛrəm kɔn, bawo wos owosɛ fɛ. ");
INSERT INTO bsp_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Kɔ wəcəbokəra kɔ pəyɔnɛ fɛ ti wəran nwɛ ŋancenɛnɛ kɔ wos, tɔyɔnɛ ɛndɛrəm kəyɔ ka tes-ɛ, pəmar pəlas dim dɔn. ");
INSERT INTO bsp_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Kɔ wəran wəlɔ ɛndɛrəm kɔ pəyɔnɛ fɛ ti pəsɔŋ temer kəyɔ ka tes tɔlɔma, ");
INSERT INTO bsp_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","wos pəcərɛ kədɛrəm kaŋkɔ ta oloku tɔlɔm o tɔlɔm-ɛ, pəmar pəlas dim da kədɛrəm dɔkɔ ɛnasɔŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mba kɔ tɔyɔnɛ, dɔsɔk ndɛ wos ɛncərɛ ti mɔ, wos pəloku a owosɛ fɛ kədɛrəm kaŋkɔ-ɛ, wəran nwɛ ɛntam kəyi ta ɔyɔ tɔkɔ ɛnadɛrəm mɔ. MARIKI ɛŋaŋnɛnɛ wəran nwɛ, bawo wos owosɛ fɛ kədɛrəm kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Kədɛrəm nkɛ o nkɛ kɔ pəyɔnɛ fɛ ti kəsɔŋ temer kəsak tes tɔlɔma-ɛ, wos ɛntam kəwosɛ ti kɔ pəyɔnɛ fɛ ti pəbupərɛ ti. ");
INSERT INTO bsp_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Kɔ wos ɔntɔloku tɔlɔm o tɔlɔm haŋ dɔckɔsɔk-ɛ, wos owosɛ tɛm tatɔkɔ kədɛrəm kaŋkɔ kɔ pəyɔnɛ fɛ ti kəsɔŋ temer kaŋkɔ. Wos owosɛ ti tɛm tatɔkɔ teta kəyi kɔn ta ombupərɛ dɔsɔk ndɛ ɛncərɛ ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Kɔ tɔyɔnɛ pəwon kəbupərɛ ti-ɛ, nkɔn wos ɔŋyɔnɛ wəciya teta ntɛ wəran kɔn ɔntɔlas dim da kədɛrəm kɔn mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Sariyɛ saŋsɛ sɔ MARIKI ɛnasom Musa, ntɛ pəmar teyi wərkun kɔ wəran kɔn dacɔ mɔ, kɔ pəyɔnɛ fɛ ti wəyecəra kɔ kas dacɔ kɔ tɔyɔnɛ pəsɔrɔyi ndena kas-ɛ. ");
INSERT INTO bsp_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Məluksɛ aMadiyaŋ ayɛk ŋa aYisrayel. Kɔ tencepər-ɛ, məndefi.» ");
INSERT INTO bsp_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Kɔ Musa oloku aYisrayel: «Afum nəna dacɔ ŋalɛk yosutnɛnɛ, ŋakɔ ŋawɛkərnɛ aMadiyaŋ kəsutɛnɛ, ntɛ tɔŋsɔŋɛ nəluksɛ ayɛk nŋɛ MARIKI oloku kəluksɛ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Nəyɛk-yɛk afum wul win (1.000) kusuŋka o kusuŋka ka Yisrayel.» ");
INSERT INTO bsp_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","K'ayɛk-yɛk cusuŋka ca Yisrayel fəp arkun asutɛnɛ wul wəco kɔ mɛrəŋ (12.000). ");
INSERT INTO bsp_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Kɔ Musa eŋkekərɛ arkun akaŋɛ wul win (1.000) kusuŋka o kusuŋka dəkəsutɛnɛ kəlɛkɛnɛ Finehas wan ka wəloŋnɛ Elasar, nwɛ ɛnatɔmpər yosumpər-sumpər yopus ya aŋgbip ŋosoku kɔ luk nyɛ awenɛ teta kəloŋkanɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Kɔ ŋalɛk yosutnɛnɛ kɔ ŋawɛkərnɛ aMadiyaŋ pəmɔ ntɛ MARIKI ɛnasom ti Musa mɔ: Kɔ ŋandifət arkun aMadiyaŋ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Kɔ ŋandiftɛnɛ abɛ aMadiyaŋ aŋɛ kəcamət: Ewy, Rekem, Cur, Hur, Reba, kɔ ŋandifɛnɛ sɔ Balam wan ka Behor. ");
INSERT INTO bsp_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Kɔ aka Yisrayel ŋasumpər aran kɔ awut aMadiyaŋ dacar kɔ ŋafoŋət yɔcɔl kɔ daka daŋan fəp. ");
INSERT INTO bsp_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Kɔ ŋancɔfət sədare səŋan səpɔŋ kɔ madare maŋan. ");
INSERT INTO bsp_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Kɔ ŋaŋkekərɛ daka da Madiyaŋ fəp, kəlɛk afum haŋ yɔcɔl yaŋan nyɛ ŋanasumpər mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Kɔ ŋaŋkekərɛ acar aŋɛ ŋanasumpər dəkəwan kɔ daka dɔkɔ ŋanalɛk mɔ, kɔ ŋamentər yi Musa, wəloŋnɛ Elasar kɔ kəloŋkanɛ ka aka Yisrayel aŋɛ ŋanandɛ nde tɛgbərɛ ta Mohab nde Yurdɛn kəsək, ŋatɛfərnɛ Yeriko mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, wəloŋnɛ Elasar kɔ akiriŋ a kəloŋkanɛ ka Yisrayel fəp ŋawur kəkɔfaynɛ ŋa saŋka tadarəŋ. ");
INSERT INTO bsp_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Kɔ pəntɛlɛ Musa nnɔ akiriŋ a cəgba ca asutɛnɛ wul win (1.000), kɔ ca asutɛnɛ tasar tin (100) a dəkəwan aŋɛ ŋanalukus mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Kɔ Musa oloku: «Ta ake tɔ nəntɔdiftɛ aran akaŋɛ fəp-ɛ? ");
INSERT INTO bsp_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Aran akaŋɛ, moloku ma Balam disrɛ ŋasɔŋɛ aka Yisrayel kəcəmɛ MARIKI dɛbəkəc teta Peyɔr. Ti tɛnasɔŋɛ pəcuy pɔsɔtɔ kəloŋkanɛ ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ndɛkəl oŋ nədifət awut arkun aMadiyaŋ kɔ aran fəp aŋɛ arkun ŋafəntərər mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mba ayecəra aŋɛ arkun ŋantatɔfəntərər mɔ, nəmɛŋkərnɛ ŋa, akonu. ");
INSERT INTO bsp_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Kɔ nəna, nwɛ o nwɛ endif fum kɔ pəyɔnɛ fɛ ti pəgbuŋɛnɛ wəfi mɔ, pəyi nnɔ saŋka tadarəŋ, ŋandesɔkəsnɛ kiciya kəŋan tataka ta maas kɔ ta camət-mɛrəŋ kɔ acar anu. ");
INSERT INTO bsp_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Nəndesɔkəs sɔ yamos fəp, ca ya akata, ca nyɛ aŋlompsɛ cəfon ca cir mɔ, kɔ yosumpər-sumpər nyɛ alompsɛ tɔk mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Kɔ wəloŋnɛ Elasar oloku asɔdar aŋɛ ŋanakɔ dəkəwan mɔ: «Tantɛ tɔ sariyɛ nsɛ MARIKI osom Musa mɔ səloku: ");
INSERT INTO bsp_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Kɛma, gbeti, kɔpər, afɛc, yoku kɔ sumbu, ");
INSERT INTO bsp_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ca nyɛ yɛntam nɛnc mɔ fəp, nəcɔf yi, a nədesɔksɛ yi domun dɔsɔksɛ. Nyɛ yɔntɔtam nɛnc mɔ, domun ndɛ dɔŋsɔkəs mɔ d'andesɔksɛ yi. ");
INSERT INTO bsp_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Nəyak yamos yonu tataka ta camət-mɛrəŋ, nəŋsɔk tɛm tatɔkɔ. Kɔ tencepər-ɛ, nəntam kəbɛrɛ dəsaŋka.» ");
INSERT INTO bsp_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Məna, wəloŋnɛ Elasar kɔ akiriŋ a dəcor aka kəloŋkanɛ, nəlɔm daka ndɛ nəsɔtɔ dəkəwan mɔ, afum kɔ yɔcɔl nyɛ nəsumpər mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Nəyer daka ndɛ nəsɔtɔ dəkəwan mɔ asutɛnɛ kɔ aka kəloŋkanɛ. ");
INSERT INTO bsp_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Yɔsɔtɔ ya asutɛnɛ dacɔ, nyɛ yɔyɔnɛ ya MARIKI. Fum wəkin afum masar kəcamət (500) dacɔ, wana win cəna masar kəcamət (500) dacɔ, aŋkesiya ŋin ŋkesiya masar kəcamət (500) dacɔ, wir win cir masar kəcamət (500) dacɔ yɔyɔnɛ ya MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Nəsɔŋ wəloŋnɛ Elasar yɔsɔtɔ yayɔkɔ ambelɛ ina MARIKI mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Daka dɔkɔ aŋsɔŋ aka Yisrayel mɔ, nəwurɛ fum wəkin afum wəco kəcamət (50) dacɔ, pɔcɔl pin wəco kəcamət (50) dacɔ, kəyɛfɛ cəna, ŋkesiya, sɔfale, cir kəbəp ka yɔcɔl yɛlpəs yɔkɔ nəsɔŋ yayɔkɔ aLewy aŋɛ ŋantɔmpər kəbum ka dəkiyi dosoku dem mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa kɔ wəloŋnɛ Elasar ŋayɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Yɔcɔl nyɛ asutɛnɛ ŋanafoŋət dəkəwan mɔ: Dɛlay da ŋkesiya kɔ cir dɛnabəp wul masar camət-tin, wəco camət-mɛrəŋ kɔ kəcamət (675.000). ");
INSERT INTO bsp_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Dɛlay da cəna dɛnabəp wul wəco camət-mɛrəŋ kɔ mɛrəŋ (72.000). ");
INSERT INTO bsp_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Dɛlay da sɔfale dɛnabəp wul wəco camət-tin kɔ pin (61.000), ");
INSERT INTO bsp_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","kɔ aran wul wəco maas kɔ mɛrəŋ (32.000) aŋɛ arkun ŋanatɔfəntərər mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Yɔcɔl yɛfɛt nyɛ y'anasɔŋ asutɛnɛ: Ŋkesiya kɔ cir wul masar maas wəco maas kɔ camət-mɛrəŋ, masar kəcamət (337.500). ");
INSERT INTO bsp_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Yɔcɔl nyɛ anabelər ya MARIKI mɔ yɛnabəp masar camət-tin, wəco camət-mɛrəŋ kɔ kəcamət (675). ");
INSERT INTO bsp_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Cəna wul wəco maas kɔ camət-tin (36.000), k'ambelɛ MARIKI wəco camət-mɛrəŋ kɔ mɛrəŋ (72). ");
INSERT INTO bsp_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Sɔfale wul wəco maas, masar kəcamət (30.500), k'ambelɛ MARIKI wəco camət-tin kɔ pin (61). ");
INSERT INTO bsp_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Afum wul wəco kɔ camət-tin (16.000) k'ambelɛ MARIKI wəco maas kɔ mɛrəŋ (32). ");
INSERT INTO bsp_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Kɔ Musa ɔsɔŋ wəloŋnɛ Elasar yɔsɔtɔ nyɛ pənamar pasɔŋ MARIKI mɔ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Yɔsɔtɔ yɔkɔ pənamar pasɔŋ aYisrayel mɔ, nyɛ Musa ɛnabelər yɔsɔtɔ ya asutɛnɛ dacɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ŋkesiya kɔ cir yɛnabəp wul masar maas wəco maas kɔ camət-mɛrəŋ, masar kəcamət (337.500), ");
INSERT INTO bsp_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","cəna cənabəp wul wəco maas kɔ camət-tin (36.000), ");
INSERT INTO bsp_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","sɔfale sənabəp wul wəco maas, masar kəcamət (30.500), ");
INSERT INTO bsp_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","kɔ afum ŋanabəp wul wəco kɔ camət-tin (16.000). ");
INSERT INTO bsp_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Yɔsɔtɔ yɔkɔ pənamar pasɔŋ aYisrayel mɔ, kɔ Musa owurɛ pɔsɔtɔ mpɛ o mpɛ dacɔ, pin wəco kəcamət (50) disrɛ, k'ɔsɔŋ aLewy aŋɛ ŋantɔmpər kəbum ka dəkiyi dosoku da MARIKI mɔ, pəmɔ tɔkɔ MARIKI ɛnasom ti Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Akiriŋ a asutɛnɛ tasar tin (100), akiriŋ a asutɛnɛ wul win (1.000) ŋander ŋabəp Musa, ");
INSERT INTO bsp_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","kɔ ŋaloku kɔ: «Səlɔm asutɛnɛ aŋɛ sənasolɛ mɔ. Ali wəkin ombut fɛ su dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Fəp fosu səmpocɛ-pocɛ MARIKI ca ya kɛma nyɛ səsɔtɔ dəkəwan mɔ, kəyɛfɛ yɛgbɛknɛ, cəsora, curundɛ ca tamp, kəbəp yadələŋəs kɔ ca ya kɛma yɔlɔma, ntɛ tɔŋsɔŋɛ patubucnɛ kəsɔkəs səna yati kiciya kosu MARIKI fɔr kiriŋ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa kɔ wəloŋnɛ Elasar ŋasɔtər asutɛnɛ kɛma, ca fəp yɛgbɛc. ");
INSERT INTO bsp_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Delel da kɛma fəp nkɛ akiriŋ a asutɛnɛ tasar tin (100), asutɛnɛ wul win (1.000) ŋanasɔŋ MARIKI mɔ, dɛnabəp kilo tasar tin kɔ wəco camət-mɛrəŋ (170). ");
INSERT INTO bsp_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Asutɛnɛ, ŋa ŋanamɛŋkərnɛ yɔsɔtɔ yaŋan nyɛ ŋanafoŋət mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa kɔ wəloŋnɛ Elasar ŋambaŋ kɛma nkɛ akiriŋ a asutɛnɛ tasar tin (100) kɔ asutɛnɛ wul win (1.000) ŋaŋkɛrɛ ŋa mɔ, kɔ ŋambɛr yi nde aŋgbancan ŋɛbəpɛnɛ kɔ Kanu, ntɛ tɔŋsɔŋɛ tɔyɔnɛ tɛcɛmcɛməs ta MARIKI teta aka Yisrayel mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Aka kusuŋka ka Ruben kɔ ka Kad ŋanayɔ yɔcɔl yɛlarəm. Kɔ ŋanəŋk a antɔf ŋa Yaser kɔ ŋa Kalad ŋentesɛ kəcɔl. ");
INSERT INTO bsp_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Kɔ aka cusuŋka ca Kad kɔ Ruben ŋander ŋaloku Musa, wəloŋnɛ Elasar kɔ akiriŋ a kəloŋkanɛ: ");
INSERT INTO bsp_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Atarot, Dibɔŋ, Yaser, Nimra, Hesbon, Eleyale, Sebam, Nebo kɔ Beyɔŋ, ");
INSERT INTO bsp_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","sədare nsɛ kəloŋkanɛ ka Yisrayel ŋasut kəmar ka MARIKI disrɛ mɔ fəp. Atɔf ŋaŋɛ ŋentesɛ kəcɔl. Səna, acar am, səyɔ yɔcɔl.» ");
INSERT INTO bsp_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Kɔ ŋaloku: «Kɔ tɔyɔnɛ məcwosɛ-ɛ, Musa məsɔŋ səna kəyer disrɛ atɔf ŋaŋɛ. Ta məcepərɛnɛ su kəŋgbɔkɔ ka Yurdɛn.» ");
INSERT INTO bsp_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Kɔ Musa eyif aka kusuŋka ka Kad kɔ ka Ruben: «Awɛnc anu aŋa ŋande ŋackɔ dəkəwan, nəna nəndɛ nnɔ ba? ");
INSERT INTO bsp_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ta ake tɔ nəfaŋ kəbɛrɛ aYisrayel abɔc kəkɔ atɔf nŋɛ MARIKI ɔsɔŋ ŋa mɔ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tantɛ tɔ awisi aŋa ŋanayɔ, ntɛ inasom Kadɛs Barneya mɔ, kəkɔkɔkcɛ atɔf ŋa Kanaŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Kɔ ŋaŋkɔ nde dəŋgbəl da Ɛskɔl, ntɛ ŋaŋkɔkcɛ atɔf mɔ, kɔ ŋambɛr aYisrayel abɔc kətɔbɛrɛ atɔf nŋɛ MARIKI eyi kəsɔŋ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Kɔ pəntɛlɛ MARIKI dɔsɔk dadɔkɔ, k'ɛndɛrəm: ");
INSERT INTO bsp_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹Arkun aŋɛ ŋanapɛ kəyɛfɛ ka Misira mɔ, kəlɛk ka meren wəco mɛrəŋ (20) haŋ kəcepər ka ti, ŋafɔdenəŋk atɔf nŋɛ inadɛrəm kəsɔŋ Abraham, Siyaka kɔ Yakuba mɔ, bawo ŋaleləs fɛ dim dem. ");
INSERT INTO bsp_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Mɛnɛ Kalɛb wan ka Yefune wəka kor ka Kenisi kɔ Yosuwe wan ka Nun, ŋa ŋadenəŋk atɔf ŋaŋɔkɔ, bawo ŋa ŋaleləs dim da MARIKI.› ");
INSERT INTO bsp_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Kɔ pəntɛlɛ MARIKI nnɔ aka Yisrayel ŋayi mɔ, k'ɔsɔŋɛ ŋa kənɔŋkər-nɔŋkər nnɔ dətɛgbərɛ meren wəco maŋkəlɛ (40) haŋ kɔ dɛtɛmp ndɛ dɛnayɔ tɔkɔ tɔntɔbɔt MARIKI mɔ ŋalip kəməlkɛ. ");
INSERT INTO bsp_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Kɔ nəna, nəlɛk sɔ dəkəcəmɛ da awisi aŋa, pəmɔ yɔpɔsər ya kətɔk nəyɔnɛ kəgba ka aciya, nənɔcər mɛtɛlɛ ma MARIKI nnɔ aka Yisrayel ŋayi mɔ! ");
INSERT INTO bsp_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Nəna aka cusuŋka ca Kad kɔ Ruben, kɔ nəntɔleləs dim da MARIKI-ɛ, ɛŋsak sɔ afum asu nnɔ dətɛgbərɛ, nəsɔŋɛ ŋa kəməlkɛ.» ");
INSERT INTO bsp_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Kɔ aka cusuŋka aŋɛ ŋalɔtərnɛ Musa kɔ ŋaloku kɔ: «Kulɛ ka ŋkesiya kɔ cir cosu kɔ səfaŋ kəlompəs nnɔ kɔ dəkiyi da afum asu aka dəwɔlɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Kɔ səlip-ɛ, səlɛk yosutnɛnɛ səcəmɛ aYisrayel tekiriŋ, haŋ səkekərɛ ŋa mofo maŋan mɛndɛ. Aka wɔlɔ wosu disrɛ ŋandendɛ sədare nsɛ ambum mɔ, teta afum aŋɛ anabaŋər atɔf mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Səfɔlukus nnɔ ndorosu ta aka Yisrayel ŋasɔtɔ nwɛ o nwɛ kɛ kɔn-ɛ. ");
INSERT INTO bsp_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Səna səfɔkɔsɔtɔ paka dəkɛ kəŋan nde kəŋgbɔkɔ ka Yurdɛn tadarəŋ, bawo səna səsɔtɔ kɛ kəca nkɛ dec dɛmpɛ Yurdɛn mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Kɔ Musa oloku ŋa: «Kɔ nəyɔ tatɔkɔ, kɔ nəlɛk yosutnɛnɛ nəcəmɛ MARIKI tekiriŋ kəkɔ dəkəwan, ");
INSERT INTO bsp_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","nəlɛk fəp fonu yosutnɛnɛ nəcali Yurdɛn MARIKI fɔr kiriŋ, nəyi di haŋ MARIKI pəlip kəbɛləs aterɛnɛ ɔn-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","kɔ nəndelukus tɛm ntɛ atɔf ŋendeyi kətam ka MARIKI dəntɔf mɔ-ɛ, awa, tɛm tatɔkɔ gbəcərəm, tonu telip nnɔ MARIKI kɔ aka Yisrayel ŋayi mɔ. Tɛm tatɔkɔ yati atɔf ŋaŋɛ ŋɔyɔnɛ oŋ ŋonu kəwosɛ ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Mba kɔ nəntɔyɔ tatɔkɔ-ɛ, nənciya MARIKI, nəcərɛ a kiciya konu kəŋluksərnɛ nu. ");
INSERT INTO bsp_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Nəcəmbər dəkiyi da afum anu aka dəwɔlɔ kɔ kulɛ ka ŋkesiya kɔ cir conu, nəyɔ sɔ tɔkɔ towur nu dəcusu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Aka kusuŋka ka Kad kɔ ka Ruben ŋaloku Musa: «Acar am ŋɔ səyɔnɛ, Mariki, tɔkɔ məloku mɔ, tɔ səndeyɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Aran asu kɔ awut, yɔcɔl yosu fəp yendeyi sədare sa Kalad. ");
INSERT INTO bsp_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Fəp fosu səndelɛk yosutnɛnɛ səkɔ dəkəwan kəsom ka MARIKI pəmɔ tɔkɔ məloku ti mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Kɔ Musa osom tetaŋan wəloŋnɛ Elasar, Yosuwe wan ka Nun kɔ akiriŋ a wɔlɔ wa cusuŋka ca Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Kɔ Musa oloku ŋa: «Kɔ aka cusuŋka ca Kad kɔ Ruben ŋancali kəŋgbɔkɔ ka Yurdɛn kɔ nəna-ɛ, kɔ fəp faŋan ŋalɛk yosutnɛnɛ kəkɔ dəkəwan pəmɔ tɔkɔ MARIKI osom ti mɔ, kɔ atɔf ŋeyi kətam konu dəntɔf-ɛ, nəsɔŋ ŋa atɔf ŋa Kalad kɛ. ");
INSERT INTO bsp_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mba kɔ ŋantɔlɛk yosutnɛnɛ ŋacali kɔ nəna-ɛ, ŋasɔtɔ kɛ ka antɔf nəna dacɔ nnɔ Kanaŋ.» ");
INSERT INTO bsp_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Aka cusuŋka ca Kad kɔ Ruben ŋaloku: «Ntɛ MARIKI oloku su mɔ, səndeyɔ ti. ");
INSERT INTO bsp_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Səndelɛk yosutnɛnɛ pəmɔ tɔkɔ MARIKI oloku ti mɔ, səbɛrɛ Kanaŋ. Mba səna, nnɔ kəca nkɛ dec dɛmpɛ Yurdɛn mɔ sədesɔtɔ kɛ ka antɔf.» ");
INSERT INTO bsp_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Kɔ Musa ɔsɔŋ aka cusuŋka ca Kad kɔ Ruben kɔ kusuŋka dacɔ ka Manase wan ka Isifu atɔf ŋa Sihɔŋ wəbɛ wəka Amor, atɔf ŋa Ɔk wəbɛ ka Basan, atɔf kɔ sədare sayi, kɔ antɔf ŋɔkɔ ŋɛŋkɛl sədare sasɔkɔ mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Kɔ aka kusuŋka ka Kad ŋancəmbər Dibɔŋ, Atarot, Arower, ");
INSERT INTO bsp_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarot Sofan, Yaser, Yokboha, ");
INSERT INTO bsp_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nimra kɔ Bet Haraŋ sədare sa sɔkət, kulɛ ka ŋkesiya kɔ cir cəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Kɔ aka kusuŋka ka Ruben ŋancəmbər Hesbon, Eleyale, kɔ Kiriyatayim, ");
INSERT INTO bsp_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo kɔ Bal Meyɔŋ, sədare nsɛ anader pasəkpər mewe mɔ, kɔ Sibima. Kɔ ŋasɔŋ sədare səkɔ ŋancəmbər mɔ mewe. ");
INSERT INTO bsp_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Aka kor ka Makir wan ka Manase ŋaŋkɔ Kalad kɔ pəyɔnɛ di ndaraŋan. Kɔ ŋambaŋər di aka Amor akɔ ŋanandɛ di mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Kɔ Musa ɔsɔŋ atɔf ŋa Kalad Makir wan ka Manase kɔ wəkakɔ ɛndɛ di. ");
INSERT INTO bsp_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yahir wan ka Manase, ɔŋkɔ pəlɛk madare ma aka Amor mɔlɔma, k'ewe di madare ma cəbal ma Yahir. ");
INSERT INTO bsp_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba nkɔn sɔ ɔŋkɔ pəwɛkərnɛ Kenat kɔ madare mmɛ mɛsəŋkɛnɛ di mɔ, k'ɔsɔŋ di tewe tɔn Noba. ");
INSERT INTO bsp_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Mofo mecepɛ-cepɛ ma aYisrayel mɔ mamɛ ntɛ ŋanawur Misira cəgba kɔ cəgba, Musa kɔ Aruna ŋasolɛ ŋa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Kɔ Musa encic mewe ma mofo mmɛ ŋanccəmbərəs mɔ, kəsom ka MARIKI. ");
INSERT INTO bsp_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Kɔ ŋayɛfɛ Ramsɛs ŋof ŋɔcɔkɔ-cɔkɔ, tataka ta wəco kɔ kəcamət ta ŋof ŋɔcɔkɔ-cɔkɔ. Dɔckɔsɔk da kəcepər ka mɛlɛkɛ medif, kɔ aYisrayel ŋawur yɛŋən fɔr ya aka Misira fəp kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Tɛm tatɔkɔ tɔ aka Misira ŋancwup awut aŋan acɔkɔ-cɔkɔ akɔ ŋanafir ŋa mɔ. Kɔ MARIKI ombocər canu ca Misira kiti. ");
INSERT INTO bsp_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Kɔ aka Yisrayel ŋayɛfɛ Ramsɛs kɔ ŋaŋkɔ ŋacəmbər saŋka nde Sukɔt. ");
INSERT INTO bsp_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Kɔ ŋayɛfɛ Sukɔt kɔ ŋaŋkɔ ŋacəmbərəs Etam nŋɛ ŋeyi tɛgbərɛ kəsək mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Kɔ ŋayɛfɛ Etam kɔ ŋaluksərnɛ kəca ka Pi Hirɔt nde pəntɛfərɛnɛ Bal Cefɔŋ mɔ kɔ ŋaŋkɔ ŋacəmbərəs Mikədɔl. ");
INSERT INTO bsp_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Kɔ ŋayɛfɛ Pi Hirɔt kɔ ŋancali kəba ka Cəŋkɔlma kɔ ŋaŋkɔ dətɛgbərɛ. Kɔ ŋaŋkɔt mata maas tɛgbərɛ ta Etam disrɛ, kɔ ŋaŋkɔ ŋandɛ Mara. ");
INSERT INTO bsp_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Kɔ ŋayɛfɛ Mara kɔ ŋaŋkɔ Elim. Cələmp wəco kɔ mɛrəŋ (12) cənayi Elim kɔ komp wəco camət-mɛrəŋ (70) dəndo ŋanacəmbərəs. ");
INSERT INTO bsp_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Kɔ ŋayɛfɛ Elim kɔ ŋaŋkɔ ŋacəmbərəs kəba ka Cəŋkɔlma kəsək. ");
INSERT INTO bsp_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Kɔ ŋayɛfɛ dəndo kəba ka Cəŋkɔlma, kɔ ŋaŋkɔ ŋacəmbərəs tɛgbərɛ ta Sin. ");
INSERT INTO bsp_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Kɔ ŋayɛfɛ tɛgbərɛ ta Sin kɔ ŋaŋkɔ ŋacəmbərəs Dofka. ");
INSERT INTO bsp_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Kɔ ŋayɛfɛ Dofka kɔ ŋaŋkɔ ŋandɛ Alus. ");
INSERT INTO bsp_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Kɔ ŋayɛfɛ Alus kɔ ŋaŋkɔ ŋacəmbərəs Refidim, nde afum ŋanatɔsɔtɔ domun domun mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Kɔ ŋayɛfɛ Refidim kɔ ŋaŋkɔ ŋacəmbərəs tɛgbərɛ ta Sinayi. ");
INSERT INTO bsp_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Kɔ ŋayɛfɛ tɛgbərɛ ta Sinayi kɔ ŋaŋkɔ ŋacəmbərəs Kibərot Tawa. ");
INSERT INTO bsp_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kɔ ŋayɛfɛ Kibərot Tawa kɔ ŋaŋkɔ ŋacəmbərəs Hacerot. ");
INSERT INTO bsp_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Kɔ ŋayɛfɛ Hacerot kɔ ŋaŋkɔ ŋacəmbərəs Ritma. ");
INSERT INTO bsp_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Kɔ ŋayɛfɛ Ritma kɔ ŋaŋkɔ ŋacəmbərəs Rimon Pɛrɛc. ");
INSERT INTO bsp_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Kɔ ŋayɛfɛ Rimon Pɛrɛc kɔ ŋaŋkɔ ŋacəmbərəs Libna. ");
INSERT INTO bsp_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Kɔ ŋayɛfɛ Libna kɔ ŋaŋkɔ ŋacəmbərəs Risa. ");
INSERT INTO bsp_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Kɔ ŋayɛfɛ Risa kɔ ŋaŋkɔ ŋacəmbərəs Kelata. ");
INSERT INTO bsp_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kɔ ŋayɛfɛ Kelata kɔ ŋaŋkɔ ŋacəmbərəs nde tɔrɔ ta Sɛfɛr. ");
INSERT INTO bsp_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Kɔ ŋayɛfɛ tɔrɔ ta Sɛfɛr kɔ ŋaŋkɔ ŋacəmbərəs Harada. ");
INSERT INTO bsp_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Kɔ ŋayɛfɛ Harada kɔ ŋaŋkɔ ŋacəmbərəs Makelot. ");
INSERT INTO bsp_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Kɔ ŋayɛfɛ Makelot kɔ ŋaŋkɔ ŋacəmbərəs Tahat. ");
INSERT INTO bsp_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Kɔ ŋayɛfɛ Tahat kɔ ŋaŋkɔ ŋacəmbərəs Tara. ");
INSERT INTO bsp_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Kɔ ŋayɛfɛ Tara kɔ ŋaŋkɔ ŋacəmbərəs Mitka. ");
INSERT INTO bsp_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Kɔ ŋayɛfɛ Mitka kɔ ŋaŋkɔ ŋacəmbərəs Hasemona. ");
INSERT INTO bsp_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Kɔ ŋayɛfɛ Hasemona kɔ ŋaŋkɔ ŋacəmbərəs Moserot. ");
INSERT INTO bsp_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Kɔ ŋayɛfɛ Moserot kɔ ŋaŋkɔ ŋacəmbərəs Bene Yakan. ");
INSERT INTO bsp_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Kɔ ŋayɛfɛ Bene Yakan kɔ ŋaŋkɔ ŋacəmbərəs Hor Kidkad. ");
INSERT INTO bsp_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Kɔ ŋayɛfɛ Hor Kidkad kɔ ŋaŋkɔ ŋacəmbərəs Yotbata. ");
INSERT INTO bsp_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Kɔ ŋayɛfɛ Yotbata kɔ ŋaŋkɔ ŋacəmbərəs Abərona. ");
INSERT INTO bsp_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Kɔ ŋayɛfɛ Abərona kɔ ŋaŋkɔ ŋacəmbərəs Eciyɔŋ Keber. ");
INSERT INTO bsp_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Kɔ ŋayɛfɛ Eciyɔŋ Keber kɔ ŋaŋkɔ ŋacəmbərəs tɛgbərɛ ta Cin nde Kadɛs. ");
INSERT INTO bsp_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kɔ ŋayɛfɛ Kadɛs kɔ ŋaŋkɔ ŋacəmbərəs nde tɔrɔ ta Hor nde Edɔm kəsək. ");
INSERT INTO bsp_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kɔ wəloŋnɛ Aruna ɛmpɛ nde tɔrɔ ta Hor kəroŋ kəsom ka MARIKI disrɛ, k'ɔŋkɔ pəfi di teren ta wəco maŋkəlɛ (40) kəwur ka aka Yisrayel Misira, tataka tɔcɔkɔ-cɔkɔ ta ŋof ŋa kəcamət. ");
INSERT INTO bsp_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aruna ɛnasɔtɔ meren tasar tin wəco mɛrəŋ kɔ maas (123) ntɛ encfi nde tɔrɔ ta Hor mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","WəKanaŋ ɛnayi nwɛ ɛnayɔnɛ wəbɛ wəka dare da Arad, pəndɛ Nɛkɛf mɔ. Nkɔn ɛnane taŋ kəder ka aYisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Kɔ ŋayɛfɛ tɔrɔ ta Hor kɔ ŋaŋkɔ ŋacəmbərəs Calmona. ");
INSERT INTO bsp_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Kɔ ŋayɛfɛ Calmona kɔ ŋaŋkɔ ŋacəmbərəs Punon. ");
INSERT INTO bsp_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Kɔ ŋayɛfɛ Punon kɔ ŋaŋkɔ ŋacəmbərəs Obot. ");
INSERT INTO bsp_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Kɔ ŋayɛfɛ Obot kɔ ŋaŋkɔ ŋacəmbərəs Iye Abarim, nde kələncər ka Mohab. ");
INSERT INTO bsp_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Kɔ ŋayɛfɛ Iyim kɔ ŋaŋkɔ ŋacəmbərəs Dibɔŋ Kad. ");
INSERT INTO bsp_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Kɔ ŋayɛfɛ Dibɔŋ Kad kɔ ŋaŋkɔ ŋacəmbərəs Almon Diblatayim. ");
INSERT INTO bsp_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Kɔ ŋayɛfɛ Almon Diblatayim kɔ ŋaŋkɔ ŋacəmbərəs nde tɔrɔ ta Abarim nde pəntɛfərɛnɛ Nebo mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Kɔ ŋayɛfɛ tɔrɔ ta Abarim kɔ ŋaŋkɔ ŋacəmbərəs nde tɛgbərɛ ta Mohab, kəŋgbɔkɔ ka Yurdɛn kəsək nde pəntɛfərɛnɛ Yeriko mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Kɔ ŋaŋkɔ ŋandɛ Yurdɛn kəsək, kəyɛfɛ Bet Yesimɔt haŋ Abɛl Sitim nde tɛgbərɛ ta Mohab. ");
INSERT INTO bsp_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Nde tɛgbərɛ ta Mohab, nde kəŋgbɔkɔ ka Yurdɛn kəsək nde pəntɛfərɛnɛ kɔ Yeriko mɔ, kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«Məloku aYisrayel: Kɔ nəŋkɔcepər Yurdɛn kəbɛrɛ ka atɔf ŋa Kanaŋ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","nəkɔ nəbaŋər afum akɔ ŋandɛ atɔf ŋaŋɔkɔ mɔ fəp, nəmələk masar maŋan mɛpat motontnɛnɛ, nəmələk mɛrəŋka maŋan ma fɛc yɛgbɛc, nələsər sɔ mofo mɛsali dəmɔrɔ mmɛ ŋampusɛ canu cəŋan mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Nəbaŋ atɔf nəndɛ ŋi, isɔŋ nu atɔf ŋaŋɔkɔ ntɛ tɔŋsɔŋɛ ŋɔyɔnɛ nu kɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Nəkot yampuŋpuŋ nəyer atɔf nŋɛ ŋɔyɔnɛ kɛ konu mɔ, dəcor dəcor. Nəbɛkɛnɛ ntɔf tɔkɔ nəlanɛnɛ mɔ, akɔ ŋala mɔ, nəsɔŋ ŋa kɛ ka antɔf nkɛ kəmbɛk mɔ. Aŋɛ ŋampicɛ mɔ, nəsɔŋ ŋa kɛ ka antɔf nkɛ kəmpicɛ mɔ. Cusuŋka ncɛ o ncɛ ŋabaŋ da yampuŋpuŋ yɔŋsɔŋ ŋa mɔ. Nəbaŋ ntɔf yayɔkɔ yɔyɔnɛ nu kɛ ka dəcusuŋka. ");
INSERT INTO bsp_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Kɔ nəntɔbɛləs afum aŋɛ ŋandɛ atɔf ŋaŋɔkɔ fəp fɔr yonu kiriŋ-ɛ, afum akɔ nəŋsak mɔ, ŋandekɔtɔrəs nu pəmɔ ntɛ paka pɛmbɛrɛ fum dəfɔr mɔ kɔ pəyɔnɛ fɛ ti bɛŋk nyɛ yɔŋsɔ-sɔs cumunt mɔ. Ŋande ŋactɔrəs nu sədare nsɛ nəndɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Iŋyɔ nu tɔkɔ inacɛm-cɛmnɛ kəyɔ ŋa mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Məsom aYisrayel ntɛ, məloku ŋa: Kɔ nəndekɔbɛrɛ Kanaŋ-ɛ, antɔf nyɛ isɔŋ nu kɛ mɔ, cələncər ca ŋi cɔ cancɛ: ");
INSERT INTO bsp_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Kəca kətɔt kɔ məntɛfərnɛ nde dec dɛmpɛ mɔ, antɔf ŋonu ŋɔŋkɔcop tɛgbərɛ ta Cin kɔ atɔf ŋa Edɔm. Kələncər konu kəŋkɔcop kəca kətɔt ka kəba Kədokət kɔ məntɛfərnɛ nde dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Kəkɔ kəkafələr ntende kəca kətɔt ka dəkəpɛ da Mekəlencər, kəsolnɛ kəca ka Cin, kəkɔcepər kəca kətɔt ka Kadɛs Barneya, kəkɔ kəcepər sɔ Hacar Adar kɔ Acmon, ");
INSERT INTO bsp_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","kəkɔkafələr sɔ Acmon haŋ kəkɔ kəsumpər dəŋgbəl da Misira a kədewur nde dəkəba. ");
INSERT INTO bsp_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Kələncər konu ntende dec dɛŋkalɛ mɔ, kəkɔyɔnɛ kəba Kəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Ntende kəca kəmeriya kɔ məntɛfərnɛ nde dec dɛmpɛ mɔ, kəyɛfɛ nde kəba Kəpɔŋ, nəcic ki haŋ nde tɔrɔ ta Hor. ");
INSERT INTO bsp_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Kəyɛfɛ nde tɔrɔ ta Hor, nəcic ki kəcepər dəkəbɛrɛ da Lebo Hamat ntɛ tɔŋsɔŋɛ kəbəp Cedad mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Kələncər kaŋkɔ kəkɔ ta Sifron haŋ kəkɔ kəsumpər Hacar Enan: Kələncər konu ka kəca kəmeriya kɔ kaŋkɔ. ");
INSERT INTO bsp_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Nəcic kələncər konu ntende dec dɛmpɛ mɔ, kəyɛfɛ Hacar Enan haŋ Sefam, ");
INSERT INTO bsp_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","kələncər kaŋkɔ kətor kəyɛfɛ Sefam kəkɔ Ribla kəca nkɛ dec dɛmpɛ Ayin mɔ, kələncər kaŋkɔ kətor kəgbuŋɛnɛ dobo da kəba ka Kineret ntende dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Kələncər kaŋkɔ kətor sɔ Yurdɛn, kəkɔ kəsumpər kəba Kədokət. Atɔf ŋonu ŋaŋɔkɔ kɔ cələncər ncɛ cənɔŋkər ŋi mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Kɔ Musa osom aYisrayel ntɛ: «Atɔf ŋaŋɔkɔ ŋɔ nəŋkɔyerɛnɛ dəyampuŋpuŋ, antɔf nŋɛ MARIKI ɔsɔŋ payer cusuŋka ncɛ camət-maŋkəlɛ kɔ dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Bawo kusuŋka ka Ruben dəcor kɔ dəcor, kusuŋka ka Kad dəcor kɔ dəcor ŋasɔtɔ kɛ kəŋan ka antɔf, kɔ kusuŋka dacɔ ka Manase sɔ kəsɔtɔ kɛ kəŋan ka antɔf. ");
INSERT INTO bsp_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Cusuŋka cancɛ mɛrəŋ kɔ kusuŋka dacɔ ka Manase ŋanasɔtɔ kɛ kəŋan ka antɔf kəca nkɛ dec dɛmpɛ Yurdɛn nde pətɛfərɛnɛ Yeriko mɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Mewe ma afum mɔ mamɛ, aŋɛ ŋaŋkɔyer nu antɔf mɔ. Wəloŋnɛ Elasar kɔ Yosuwe wan ka Nun. ");
INSERT INTO bsp_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Nədekɔ nəlɛk wəkiriŋ wəkin ka kusuŋka o kusuŋka, teta kəyer ka antɔf. ");
INSERT INTO bsp_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Mewe ma afum akaŋɛ mɔ mamɛ: Kusuŋka ka Yuda: Kalɛb wan ka Yefune, ");
INSERT INTO bsp_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Kusuŋka ka Simeyɔŋ: Semuwɛl wan ka Amihud. ");
INSERT INTO bsp_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kusuŋka ka Bɛŋyamin: Elidad wan ka Kislon. ");
INSERT INTO bsp_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Kusuŋka ka Dan: Buki wan ka Yokəli. ");
INSERT INTO bsp_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Kusuŋka ka Isifu, kor ka Manase: Wəkiriŋ Haniyel wan ka Efod. ");
INSERT INTO bsp_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kusuŋka ka Efrayim: Kemuyel wan ka Siftan. ");
INSERT INTO bsp_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Kusuŋka ka Sabulon: Wəkiriŋ Elicafan wan ka Parnak. ");
INSERT INTO bsp_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Kusuŋka ka Isakar: Paltiyel wan ka Asan. ");
INSERT INTO bsp_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Kusuŋka ka Asɛr: Ahihud wan ka Selomi. ");
INSERT INTO bsp_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Kusuŋka ka Naftali: Pedahel wan ka Amihud.» ");
INSERT INTO bsp_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Afum akaŋɛ ŋɔ MARIKI ɛnasom kəyer ka antɔf ŋa Kanaŋ aYisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Nde tɛgbərɛ ta Mohab, nde Yurdɛn kəsək, nde pəntɛfərɛnɛ kɔ Yeriko mɔ, kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«Məsom aYisrayel, ŋasɔŋ aLewy kɛ ka antɔf dəntɔf yaŋan disrɛ, sədare nsɛ ŋantam kəndɛ mɔ, nəsɔŋ ŋa sɔ ntɔf nyɛ yɛŋkɛl si mɔ, yɔcɔl yaŋan yɔcsɔtɔ dəkəsɔmət. ");
INSERT INTO bsp_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ALewy ŋandɛ sədare sasɔkɔ, ntɔf yɔkɔ yɛŋkɛl ŋa mɔ yɔyɔnɛ dəkəsɔmət da yɔcɔl yaŋan, pətɔt paŋan kɔ pa yɔcɔl yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Ntɔf yɔkɔ yɛŋkɛl sədare səŋan, nyɛ nəndesɔŋ ŋa mɔ, pəmar yɔyɔ dowokulu da mɛtər masar kəcamət (500) haŋ pənɔŋkər. ");
INSERT INTO bsp_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Teta dəkəsɔmət da yɔcɔl yayɔkɔ nətubuc kəyɛfɛ ka damba ndɛ dɛŋkɛl dare mɔ, kəkɔ ntende dec dɛmpɛ mɛtər wul win (1.000) kɔ nde dɛŋkalɛ sɔ mɔ, mɛtər wul win (1.000), kəca kətɔt mɛtər wul win (1.000) kɔ kəmeriya mɛtər wul win (1.000), dare deyi dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Nəsɔŋ aLewy sədare səyacnɛ camət-tin nsɛ wədif fum ta ɛyɛfɛnɛ ti, ɛntam kəyɛksɛ pəkɔ mɔ. Nəsɔŋ ŋa sɔ sədare wəco maŋkəlɛ kɔ mɛrəŋ (42). ");
INSERT INTO bsp_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Sədare nsɛ pəmar pasɔŋ aLewy mɔ: Sədare wəco maŋkəlɛ kɔ camət-maas (48) kɔ cəsək ca si teta dəkəsɔmət da yɔcɔl yaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Sədare nsɛ nəndesɔŋ aLewy mɔ, tɔkɔ cusuŋka cəŋlanɛnɛ kəsɔtɔ ntɔf mɔ, tɔ cəndelanɛnɛ sɔ kəsɔŋ aLewy ntɔf. Kusuŋka nkɛ kəŋsɔtɔ pəlarəm mɔ kəsɔŋ pəlarəm, nkɛ kəŋsɔtɔ pipic mɔ kəsɔŋ pipic.» ");
INSERT INTO bsp_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Kɔ MARIKI oloku Musa: ");
INSERT INTO bsp_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Məloku aYisrayel: Kɔ nəncali Yurdɛn nəcbɛrɛ Kanaŋ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","nəyɛk-yɛk sədare nsɛ səndeyɔnɛ nu sədare səyacnɛ mɔ, ntɛ tɔŋsɔŋɛ nwɛ endif fum ta ɛyɛfɛnɛ ti, ɛŋyɛksɛ pəkɔ pəyacnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Sədare sasɔkɔ səndeyɔnɛ nu səyacnɛ, wəluksɛ ayɛk. Ti disrɛ, wədif fum ɔfɔfi ta kəloŋkanɛ kəntakiti kɔ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Sədare camət-tin nsɛ nəndesɔŋ mɔ, səndeyɔnɛ nu səyacnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Nəsɔŋ sədare maas ntende dec dɛmpɛ Yurdɛn mɔ, sədare maas nde Kanaŋ: Sədare sasɔkɔ səyɔnɛ nu səyacnɛ. ");
INSERT INTO bsp_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Sədare sasɔkɔ camət-tin səyɔnɛ səyacnɛ sa aYisrayel, acikəra andɛ kɔ acepərɛnɛ tɛm aŋɛ ŋayi nu dacɔ mɔ, nwɛ o nwɛ endif fum ta ɛyɛfɛnɛ ti mɔ, ɛntam kəyɛksɛ pəkɔ pəyacnɛ di. ");
INSERT INTO bsp_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Kɔ fum ɛyɛfɛnɛ ti, pəsutɛ wɛnc paka pa afɛc tɔsɔŋɛ kɔ kəfi-ɛ, wədif fum ɔfɔ, mɛnɛ padif wəkakɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Kɔ fum ɛncanɛ wɛnc tasar tɔsɔŋɛ kɔ kəfi-ɛ, wədif fum ɔfɔ. Mɛnɛ padif fum wəkakɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Kɔ fum osutɛ wɛnc paka pa kətɔk tɔsɔŋɛ kɔ kəfi-ɛ, wədif fum ɔfɔ. Mɛnɛ padif wəkakɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Wəluksɛ ayɛk ŋa wəfi, ɔnckɔnabəp wədif fum wəkakɔ, pədif kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Kɔ tɔyɔnɛ fum pəwɛn wɛnc kəter disrɛ, kɔ pəyɔnɛ fɛ ti pəca kɔ paka pɔlɔm tɔsɔŋɛ wəkakɔ kəfi-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","kɔ pəyɔnɛ fɛ ti pəcaŋ kɔ aŋkulma kantera disrɛ tɔsɔŋɛ wəkayi kəfi-ɛ, padif wəcaŋ kɔn aŋkulma, wədif fum ɔfɔ. Wəluksɛ ayɛk ŋa wəfi ɔnckɔnabəp kɔ, pədif kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Mba kɔ fum ɛwɛn wɛnc kətɔyɛfɛnɛ disrɛ kɔ pəyɔnɛ fɛ ti pəca kɔ paka pɔlɔm kətɔyɛfɛnɛ disrɛ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","kɔ tɔyɔnɛ pəca kɔ tasar kətɔyɛfɛnɛ disrɛ, tɔsɔŋɛ kɔ kəfi mba ta ŋanaterɛnɛ, ta ɛntɛn kəyɔ kɔ pəlɛc-ɛ, ");
INSERT INTO bsp_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","kəloŋkanɛ kəboc kiti wədif fum kɔ wəluksɛ ayɛk ŋa wəfi dacɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Kɔ kəloŋkanɛ kəbaŋ wədif fum wəluksɛ ayɛk ŋa wəfi dəwaca. Kəloŋkanɛ kəluksɛ wədif fum wəkakɔ dare dɔkɔ ɛnayɛksɛ pəkɔ pəyacnɛ mɔ. Pəyi di haŋ wəloŋnɛ wəpɔŋ nwɛ ɛnasɔtɔ kəbɔy ka moro ma dəKanu mɔ, pəfi. ");
INSERT INTO bsp_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Kɔ wədif fum owur cələncər ca dare ndɛ ɛnayɛksɛ pəyacnɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","tɔyɔnɛ wəluksɛ ayɛk ŋa wəfi pəbəp kɔ cələncər ca dare dɛyacnɛ todoru-ɛ, wəluksɛ ayɛk pədif kɔ-ɛ, ɛsarɛ fɛ teta defi dɔn. ");
INSERT INTO bsp_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Bawo pəmar wədif fum nwɛ pəyi dare dɛyacnɛ disrɛ haŋ wəloŋnɛ wəpɔŋ pəfi. Kɔ tencepər-ɛ, wədif fum nwɛ ɛntam kəlukus nde dare dɔn dokur. ");
INSERT INTO bsp_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Nəde nəcleləs sariyɛ saŋsɛ dɛtɛmp kɔ dɛtɛmp nnɔ o nnɔ nəndeyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Kɔ tɔyɔnɛ fum pədif wɛnc kəyɛfɛnɛ disrɛ-ɛ, padif wədif fum wəkakɔ, kɔ sede alarəm ŋalok-loku-ɛ, toloku ta sede sin tɔfɔsɔŋɛ padif wədif fum wəkakɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ta nəde nəcwosɛ kəpocɛ kəlɛc teta kəkafəli pəlompu. Ta nəŋaŋnɛnɛ wədif fum nwɛ pəmar padif mɔ, mɛnɛ padif kɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ta nədesɔ nəcwosɛ kəpocɛ nəŋaŋnɛnɛ wədif fum pəlukus dare dɔn dokur ta wəloŋnɛ wəpɔŋ ɛntafi-ɛ. ");
INSERT INTO bsp_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ta nəyik-yikəs atɔf ŋɔkɔ nəŋyi mɔ. Bawo k'andif fum-ɛ, tɔŋsɔŋɛ atɔf kəyik-yik, mecir ma wədif ka fum gbəcərəm mɔ antam kəsɔksɛ ka atɔf nŋɛ andif fum mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ta nəde nəcyik-yikəs atɔf nŋɛ nəndendɛ mɔ, difɔ indɛ nu dacɔ: MARIKI iyɔnɛ, indɛ aka Yisrayel dacɔ.» ");
INSERT INTO bsp_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Kɔ akiriŋ a kor ka Kalad, wan ka Makir wəka Manase, nwɛ ɔyɔnɛ wəka kusuŋka ka Isifu mɔ, ŋander ŋaloku fɔr ya Musa kiriŋ, akiriŋ a cusuŋka kɔ akiriŋ a cor ca Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Kɔ ŋander ŋaloku: «Mariki mem, MARIKI osom əm kəsɔŋ dəyampuŋpuŋ atɔf ŋɔyɔnɛ kɛ ka aYisrayel. Kɔ məsɔtər sɔ MARIKI kəsɔŋ ka kɛ ka Celofad wɛnc kosu, awut ɔn aran. ");
INSERT INTO bsp_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Kɔ tɔyɔnɛ wəka kusuŋka kəlɔma aYisrayel dacɔ pənɛncɛ kɔ-ɛ, pəlɛc pampɛ pɛntam kəbəp su tɛm tatɔkɔ, bawo kɛ kosu kəndebelɛ antɔf ŋa kusuŋka kosu, kədeŋər ka kɛ ka kusuŋka ka awos aŋa. Ti disrɛ, kɛ nkɛ yampuŋpuŋ yɛnasɔŋ su mɔ kəmbelɛ. ");
INSERT INTO bsp_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Tedeŋər ta ti, kɔ teren ta Kəkul-kulɛnɛ Pəbotu tɛmbəp-ɛ, kɛ kəŋan ka antɔf kəndebelɛ dəkɛ ka kusuŋka kosu kədeŋərnɛ ka awos aŋa.» ");
INSERT INTO bsp_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Kɔ Musa osom aYisrayel kəsom ka MARIKI disrɛ, k'oloku: «Aka kusuŋka ka Isifu ŋaloku kance. ");
INSERT INTO bsp_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ntɛ tɔ MARIKI osom awut aran a Celofad: Ŋalɔ nwɛ ŋaŋfaŋ pənɛncɛ ŋa mɔ, mba tɔcyɔnɛ a wərkun wəkayi pəcyɔnɛ wəka kusuŋka ka kas kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Tɔŋyɔnɛ tɛm tatɔkɔ, kɛ ka antɔf ŋa Yisrayel kəfɔyɛfɛ kəkɔ kədeŋərnɛ kɛ ka kusuŋka kəlɔma. Kusuŋka nkɛ o nkɛ kətɔmpər kɛ ka antɔf ŋaŋan. ");
INSERT INTO bsp_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Kɔ tɔyɔnɛ kusuŋka disrɛ wəran ɛlɛk kɛ ka antɔf ŋa kas-ɛ, wəka kusuŋka ka kas pəmar pənɛncɛ kɔ. Ti disrɛ, kusuŋka o kusuŋka ka Yisrayel kəndetɔmpərnɛ kɛ ka antɔf nkɛ atem aŋan ŋanasɔtɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Kɔ teyi tatɔkɔ-ɛ, kɛ ka antɔf nkɛ o nkɛ kəfɔkɔ kusuŋka kəlɔma. Kusuŋka ka Yisrayel nkɛ o nkɛ kəntɔmpər kɛ ka antɔf ŋa akas aŋa.» ");
INSERT INTO bsp_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Kɔ awut aran a Celofad ŋayɔ tɔkɔ MARIKI ɛnasom Musa mɔ. ");
INSERT INTO bsp_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mala, Tirsa, Hokəla, Milka kɔ Noha awut aran a Celofad ŋalɔs-lɔs nda awut arkun a akas aŋan afɛt, ");
INSERT INTO bsp_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","aka yuruya ya Manase wan ka Isifu dacɔ. Kɔ kɛ ka antɔf ŋaŋan kəyi sɔ kɔ kusuŋka kɔ kor ka apa kəŋan. ");
INSERT INTO bsp_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Tosom kɔ sariyɛ saŋsɛ sɔ MARIKI ɛnaloku Musa kəsom aYisrayel nde tɛgbərɛ ta Mohab nde Yurdɛn kəsək, nde pəntɛfərɛnɛ kɔ Yeriko mɔ.");
INSERT INTO bsp_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Moloku mamɛ mɔ Aŋnabi Musa ɛnaloku aka Yisrayel fəp tɛm ntɛ ŋanayi mokuru ma Yurdɛn, nde tɛgbərɛ, nde aranta ŋowosu ndɛ pəntɛfərɛnɛ kɔ Suf mɔ, sədare sa Paran: Tofɛl, Labaŋ, Hacerot kɔ Disahab dacɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Kəkɔt ka mata wəco kɔ tin (11) kɔ, kəyɛfɛ ka tɔrɔ ta Horɛb məsolnɛ ta dɔpɔ da mɔrɔ ma Sehir haŋ məkɔ məbɛrɛ Kadɛs Barneya. ");
INSERT INTO bsp_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Teren ta wəco maŋkəlɛ (40) ntɛ aka Yisrayel ŋanayɛfɛ kɔ ŋawur Misira mɔ, tataka tacɔkɔ-cɔkɔ ta ŋof ŋa wəco kɔ pin (11), kɔ Musa oloku ŋa moloku fəp mɔkɔ MARIKI ɛnasom kɔ nnɔ ŋayi mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Musa oncloku ŋa mi tɛtəŋnɛ elip kəsut Sihɔŋ wəbɛ ka Amɔr nwɛ ɛnandɛ Hesbon mɔ, kɔ Ɔk wəbɛ ka Basan nwɛ ɛnandɛ Astarot kɔ Edreyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ntende dec dɛmpɛ Yurdɛn mɔ, nde atɔf ŋa Mohab, kɔ Musa oncop kəsɔksər aka Yisrayel Sariyɛ sa Kanu nsɛ, pəcloku mamɛ: ");
INSERT INTO bsp_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«MARIKI Kanu kosu ɛnalok-lokər su nde tɔrɔ ta Horɛb: Kəwon konu kəndɛ nnɔ tɔrɔ tantɛ kəsək kəntəŋnɛ oŋ. ");
INSERT INTO bsp_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Nəyɛfɛ nəsumpər sɔ dɔpɔ nəkɔ nde tɔrɔ ta aka Amɔr kɔ andɛ aŋan fəp, nda akɔ ŋandɛ Araba, tɔrɔ kəroŋ, Sefela, Nɛkɛf, agbɛp ŋa kəba, haŋ nde atɔf ŋ'aKanaŋ kɔ Libaŋ, haŋ nde Ɛfərat kəŋgbɔkɔ kəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Mənəŋk! Isɔŋ nu antɔf ŋaŋɛ! Nəkɔ nəbaŋ antɔf nŋɛ MARIKI ɛnadɛrmɛ atem anu Abraham, Siyaka kɔ Yakuba kəsɔŋ ŋa kɔ yuruya yaŋan kɔ ŋa ŋancepər-ɛ.» ");
INSERT INTO bsp_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","«Tɛm tantɛ ina Musa icloku nu: Ifɔtam kəsarɛ mes monu sona sem. ");
INSERT INTO bsp_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","MARIKI Kanu konu kəsɔŋɛ nu kəla, nəla mɔkɔ pəmɔ kənay ka cɔs ca darenc. ");
INSERT INTO bsp_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Intola MARIKI Kanu ka atem anu kəsɔŋɛ nu sɔ kəla wul win (1.000) pəcepər tantɛ, pəpocɛ nu pətɔt pəmɔ tɔkɔ ɛnaloku nu ti mɔ! ");
INSERT INTO bsp_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Cəke c'intam kəsarɛ sona sem pɛsarɛ pəlel pa mɛgbɛkəlɛnɛ monu-ɛ? ");
INSERT INTO bsp_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Nəyɛk-yɛk nu dacɔ afum aŋɛ ŋancərɛ kəkɔtɛnɛ mes, asoku səbomp aŋɛ aleləs cusuŋka conu disrɛ mɔ, icəmbər ŋa ŋayɔnɛ nu akiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Kɔ nəlok'im a tɔkɔ məncɛm-cɛmnɛ kəyɔ mɔ, a tentesɛ. ");
INSERT INTO bsp_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","K'ilɛk afum akɔ ŋanayɔnɛ akiriŋ a cusuŋka conu mɔ, afum aŋɛ ŋancərɛ kəkɔtɛnɛ mes, aŋɛ afum fəp ŋaleləs belbel mɔ, k'incəmbər ŋa, kɔ ŋayɔnɛ akiriŋ anu aka afum wəco wəco, akiriŋ aka afum wəco kəcamət kəcamət (50, 50), akiriŋ aka afum tasar tin tin (100, 100), akiriŋ aka afum wul win win (1.000, 1.000), k'atubuc mes cusuŋka conu disrɛ. ");
INSERT INTO bsp_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Tɛm tatɔkɔ t'inasom abocɛ anu kiti: «Nəcəŋkəl awɛnc anu aŋa, nəbocɛ nwɛ o nwɛ kiti pəlompu disrɛ nkɛ pəmar pabocɛ nkɔn kɔ wɛnc, kɔ pəyɔnɛ fɛ ti, nkɔn kɔ wəcikəra dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ta nəde nəcmɔmən cəro dəŋkiti de! Nəcəŋkəl fum wəlel pəmɔ tɔkɔ nəncəŋkəl wəfəfər mɔ. Ta fum o fum pənɛmpsɛ nu fɔr, bawo Kanu kəyɔ kiti. Kɔ kiti kəlɔma kəncuca nu-ɛ, nəken'em ki, ina sɔ icəŋkəl. ");
INSERT INTO bsp_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Tɛm tantɛ, isom nu kəyɔ mes fəp mmɛ pəmar nu kədeyɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Kɔ səyɛfɛ tɔrɔ ta Horɛb, sənakɔt dɔpɔ da tɔrɔ ta aka Amɔr. Səŋkɔ səcali tɛgbərɛ tɔpɔŋ tɛwɛy-wɛy tatɔkɔ nənəŋk mɔ, pəmɔ tɔkɔ MARIKI Kanu kosu kənasom su ti mɔ. Kɔ sənder səbɛrɛ Kadɛs Barneya. ");
INSERT INTO bsp_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","K'iloku nu: «Nəmbəp tɔrɔ ta aka Amɔr mpɛ MARIKI Kanu kosu kəsɔŋ su mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Mənəŋk! Fɔr yam kiriŋ MARIKI Kanu kam kəsɔŋ əm atɔf ŋaŋɛ. Məpɛ məkɔ məbaŋ ŋi pəmɔ tɔkɔ MARIKI Kanu ka atem am kənalok'əm ti mɔ. Ta mənesɛ, ta dis dɔlɔl əm!» ");
INSERT INTO bsp_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Kɔ nənder nəlɔtərn'em fəp kəlok'im: «Panuŋkɛnɛ pasom afum, ŋakɔ ŋamɔmən atɔf ŋaŋɛ yɔkyɔk, ŋader ŋaluksɛ su mes mmɛ ŋanəŋk dɔpɔ ndɛ andekɔt kəpɛ ka di mɔ, kɔ sədare nsɛ pəmar pabəp mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Kɔ moloku mamɔkɔ mɔmbɔt im, k'ilɛk arkun wəco kɔ mɛrəŋ (12) nu dacɔ, kusuŋka o kusuŋka fum wəkin. ");
INSERT INTO bsp_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Kɔ ŋayɛfɛ ŋasumpər dɔpɔ, kɔ ŋampɛ mɔrɔ kəroŋ haŋ kɔ ŋaŋkɔ ŋabɛrɛ haŋ kəŋgbɔkɔ k'Ɛskɔl, kɔ ŋaŋgbɛkərɛ di belbel. ");
INSERT INTO bsp_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Kɔ ŋampimɛnɛ yokom y'antɔf ŋaŋɔkɔ yɔlɔma kɔ ŋantor ŋakɛrɛ su yi. Kɔ ŋaloku su ntɛ: «Antɔf ŋɔtɔt ŋɔ MARIKI Kanu kosu kəsɔŋ su.» ");
INSERT INTO bsp_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Mba nənawosɛ fɛ kəpɛ di, kɔ nəyeŋkəsnɛ səbomp nnɔ mosom ma MARIKI Kanu konu meyi mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Kɔ nəcɔpɛnɛ nde cəbal conu, nəcloku: «Ntɛ MARIKI enter su mɔ, it'owurɛnɛ su atɔf ŋa Misira, pədelɛk su pəbɛr aka Amɔr dəwaca ntɛ tɔsɔŋɛ ŋadifət su mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Deke səndepɛ-ɛ? Awɛnc asu ŋasɔŋɛ su bəkəc kəlɛcɛ-lɛcɛ, ntɛ ŋaloku su: ‹Afum ŋɔ, ŋala ŋatas su kɔ ŋaŋɛc su sɔ tɛcəmɛ. Sədare səŋan səmbɛk kɔ səyɔ sibiŋkəli haŋ darenc. Sənakɔ haŋ sənəŋk yuruya ya Anak afum aŋeci tɛcəmɛ.›» ");
INSERT INTO bsp_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Iloku nu: «Ta nəyikcɛ, ta nənesɛ ŋa! ");
INSERT INTO bsp_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","MARIKI Kanu konu nkɛ kəyi nu kiriŋ kəkɔt mɔ, kəŋkɔsutnɛnɛ nu, pəmɔ tɔkɔ kənayɔnɛ nu fɔr yonu kiriŋ Misira, ");
INSERT INTO bsp_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","kɔ tɔkɔ kənayɔnɛ nu sɔ nde dətɛgbərɛ mɔ, difɔ mənanəŋk MARIKI Kanu kam kəlɛk əm pəmɔ ntɛ wərkun ɛŋlɛk wan kɔn mɔ kəkɔt konu disrɛ fəp haŋ kɔ nənder nəbɛrɛ kəfo kaŋkɛ.» ");
INSERT INTO bsp_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ti disrɛ nənagbɛkər fɛ sɔ MARIKI Kanu konu kəlaŋ, ");
INSERT INTO bsp_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","nkɔn nwɛ ɔnckɔt nu fɔr kiriŋ dɔpɔ tɛm tatɔkɔ pəckɔtɛnɛ nu kəfo nkɛ nəntam kəcəmbər saŋka mɔ. Kɔ pəmbiyɛ-ɛ, nɛnc dɔ MARIKI encmentərɛ nu dɔpɔ ndɛ pəmar nəkɔt mɔ, kɔ pəyɔ waŋkəra-ɛ, kəp kɔ encmentərɛ nu dɔpɔ ndɛ pəmar nəkɔt mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","MARIKI ene kəcɔpəsnɛ konu. Mɛtɛlɛ mɔn disrɛ, k'ɛndɛrəm: ");
INSERT INTO bsp_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","«Ali fum wəkin wəka dɛtɛmp dɛlɛc dandɛ ɔfɔdenəŋk antɔf ŋobotu nŋɛ inadɛrəm kəsɔŋ atem anu mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Mɛnɛ Kalɛb sona, wan ka Yefune endekɔnəŋk di. Indesɔŋ kɔ, nkɔn kɔ awut ɔn, atɔf nŋɛ ɛnakɔt mɔ, bawo nkɔn ɛlas kəyɔ mes mɔkɔ MARIKI ɛnafaŋər kɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Tetonu tɛnasɔŋɛ ntɛ pəntɛlɛnɛ MARIKI nnɔ iyi mɔ, k'olok'im: «Məna Musa yati məfɔbɛrɛ atɔf ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Yosuwe wan ka Nun, nwɛ ɛncəm'am fɔr kiriŋ mɔ, endekɔbɛrɛ atɔf ŋaŋɔkɔ. Məyeŋkəs kɔ abəkəc bawo nkɔn endekɔsɔŋ atɔf ŋaŋɛ aka Yisrayel ŋɔyɔnɛ kɛ kəŋan.» ");
INSERT INTO bsp_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Kɔ MARIKI oloku fəp fonu: «Cənaka conu ncɛ nənaloku: ‹Ŋandeyɔnɛ ca nyɛ aterɛnɛ asu ŋandekɔwɛtəs mɔ,› kɔ awut anu akakɔ ŋantɔcərɛ pətɔt kɔ pəlɛc mɔkɔ mɔ, ŋa ŋandekɔbɛrɛ atɔf ŋaŋɔkɔ kɔ Yosuwe. Ŋa ŋɔ indekɔsɔŋ atɔf ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Kɔ nəna, nəyɛfɛ nəkafəlɛ nəsumpər dɔpɔ da dətɛgbərɛ ntende kəca ka kəba ka Cəŋkɔlma.» ");
INSERT INTO bsp_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Kɔ nəna aka Yisrayel nəluks'em moloku ntɛ: «Sənaciya nnɔ MARIKI eyi mɔ. Səndekɔpɛ, səsutɛnɛ pəmɔ tɔkɔ MARIKI Kanu kosu kəsom su ti mɔ.» Kɔ nwɛ o nwɛ ɛlɛk yosutnɛnɛ teta kəwan, bawo nənacɛm-cɛmnɛ a pəŋkɔfəfərɛnɛ nu kəbaŋ sədare sa mɔrɔ kəroŋ. ");
INSERT INTO bsp_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Mba MARIKI olok'im: «Musa məloku ŋa: ‹Ta nəpɛ, ta nəsutɛnɛ, bawo iyi fɛ nu dacɔ. Itɔ aterɛnɛ anu ŋafɔdekɔsut nu.›» ");
INSERT INTO bsp_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","K'ilok-lokər nu, mba nənacəŋkəl f'em kɔ nəntaŋər kəsom ka MARIKI ləŋəs. Kəlɛknɛ disrɛ kɔ nəsumpər dɔpɔ kəpɛ ka nde dəmɔrɔ. ");
INSERT INTO bsp_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Awa, aka Amɔr aŋɛ ŋanandɛ dəndo mɔrɔ mamɔkɔ mɔ, ŋantor kədebəpɛnɛ kɔ nəna, kɔ ŋambɛləs nu pəmɔ ntɛ cəme cəmbɛləs mɔ. Ŋanasamsər nu kəyɛfɛ mɔrɔ ma Sehir haŋ Horma. ");
INSERT INTO bsp_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ntɛ nəyɛfɛ dəkəwan mɔ, kɔ nənde nəbokər MARIKI, mba MARIKI enenɛ fɛ nu, owosɛ fɛ yati kəsu aləŋəs pəcəŋkəl kəbokɛnɛ konu. ");
INSERT INTO bsp_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Kɔ nəndɛ Kadɛs kɔ nəwon di haŋ. ");
INSERT INTO bsp_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Kɔ səyɛfɛ kɔ səsumpər sɔ dɔpɔ kəkɔ kəca ka dətɛgbərɛ ntende kəba ka Cəŋkɔlma, pəmɔ tɔkɔ MARIKI ɛnalok'im ti mɔ. Mataka mɛlarəm səcnɔŋkər-nɔŋkər dəndo mɔrɔ ma Sehir. ");
INSERT INTO bsp_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Awa! Kɔ MARIKI olok'im: ");
INSERT INTO bsp_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«Nəwon kənɔŋkər-nɔŋkər nnɔ mɔrɔ mamɛ, nəyɛfɛ nəsumpər sɔ dɔpɔ da kəca kəmeriya ka ntende dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Məna Musa məloku tosom ntɛ aka Yisrayel: ‹Kələncər ka akomɛnɛ anu kɔ nəŋkɔcepər, yuruya ya Esayu, aŋɛ ŋandɛ mɔrɔ ma Sehir mɔ. Ŋandekɔnesɛ nu, mba nəkɛmbərnɛ belbel. ");
INSERT INTO bsp_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Ta nədekɔyektər ŋa kəyɛfərɛnɛ de! Bawo ali kəfo nkɛ fum ɛntam kəcəmbər kəcək mɔ ifɔdekɔsɔŋ nu atɔf ŋaŋan disrɛ. Inalip kəsɔŋ mɔrɔ ma Sehir Esayu, mɔyɔnɛ mɔn. ");
INSERT INTO bsp_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Nəndekɔ nəcway kəway dəm yeri kɔ domun donu dəndo.› ");
INSERT INTO bsp_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Bawo MARIKI Kanu kam kəmpoc'am pətɔt dəmosumpər ma waca wam fəp, Kanu kənacərɛ kəkɔt kam tɛgbərɛ pɔpɔŋ pampɛ. Meren wəco maŋkəlɛ (40) mɔ mamɛ MARIKI Kanu kam kəsol'am, ali paka pombut f'am.» ");
INSERT INTO bsp_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Ti tɛnasɔŋɛ səcepər səbɔlɛ akomɛnɛ asu, awut a Esayu aŋɛ ŋandɛ nde mɔrɔ ma Sehir mɔ. Ntɛ sənccepər ŋa mɔ, kɔ səyay dɔpɔ da Araba, Elat kɔ Eciyɔŋ Keber. Kɔ səŋkɔ səkafəlɛ kɔ səlɛk dɔpɔ da tɛgbərɛ ta Mohab. ");
INSERT INTO bsp_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Kɔ MARIKI olok'im: «Ta məyektər aMohab kəwan, ta məwɛkərnɛ ŋa sɔ! Bawo ali kəfo ifɔsɔŋ əm atɔf ŋaŋan. Inalip kəsɔŋ dare da Ar awut a Lɔt, dɔyɔnɛ daŋan.» ");
INSERT INTO bsp_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Cɔkɔ-cɔkɔ aka Emy ŋanandɛ dare da Ar, afum apɔŋ ŋanayi, ŋala, ŋaŋɛc tɛcəmɛ pəmɔ aka Anak. ");
INSERT INTO bsp_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Anclɔm aRefay pəmɔ aka Anak, mba aMohab, «aka Emy» ŋɔ ŋancwe ŋa. ");
INSERT INTO bsp_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Atɔf ŋa mɔrɔ ma Sehir, cɔkɔ-cɔkɔ aHor ŋanandɛ ŋi, kɔ awut a Esayu ŋander ŋabaŋər ŋa ŋi, kɔ ŋandifət ŋa, kɔ ŋandɛ di, pəmɔ tɔkɔ aka Yisrayel ŋayɔ nde atɔf ŋaŋan, nŋɛ MARIKI ɛnasɔŋ ŋa kəndɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Kɔ MARIKI osom ŋa ntɛ: «Ndɛkəl oŋ, nəyɛfɛ oŋ nəcali kəŋgbɔkɔ ka Sered.» Kɔ səŋkɔ səcali ki. ");
INSERT INTO bsp_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Kəwon kosu dɔpɔ ntɛ səlɛk kəkɔt kəyɛfɛ ka Kadɛs Barneya haŋ səcali kəŋgbɔkɔ ka Sered mɔ, kənasɔtɔ meren wəco maas kɔ camət-maas (38), haŋ kɔ danapa da afum asu aka dəkəwan fəp ŋalip kəfis-fis su dacɔ, pəmɔ tɔkɔ MARIKI ɛnadɛrmɛ ŋa ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Kəca ka MARIKI kənayi ŋa sɔ kəroŋ teta kəmələk kəŋan ŋa su dacɔ haŋ ŋalip kəfis-fis. ");
INSERT INTO bsp_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Ntɛ arkun a dəkəwan fəp ŋafis-fis afum dacɔ mɔ, ");
INSERT INTO bsp_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","kɔ MARIKI olok'im: ");
INSERT INTO bsp_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«Mɔkɔ məndekɔcali kələncər k'aMohab məbɛrɛ dare da Ar. ");
INSERT INTO bsp_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Tɛm tatɔkɔ, mətɛfərnɛ oŋ aka Amɔŋ. Ta mədekɔyektər ŋa kəwan, ta mədekɔwɛkərnɛ ŋa de, bawo ifɔsɔŋ əm ali kəfo kin dəndo atɔf ŋ'Amoŋ. Inalip kəsɔŋ ŋi awut a Lɔt, ŋɔyɔnɛ ŋaŋan.» ");
INSERT INTO bsp_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Atɔf ŋaŋɔkɔ sɔ analɔm ŋi pəmɔ atɔf ŋa aka Refay, ŋa ŋanandɛ ŋi cɔkɔ-cɔkɔ. Aka Amɔŋ ŋacwe afum akakɔ «aSamsumi.» ");
INSERT INTO bsp_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Afum akakɔ apɔŋ ŋanayi, ŋala, ŋaŋɛc sɔ tɛcəmɛ, pəmɔ yuruya ya Anak. Kɔ MARIKI ɛmələk aRefay fɔr ya aka Amɔŋ kiriŋ, kɔ ŋambaŋər ŋa atɔf ŋaŋɔkɔ kɔ ŋandɛ. ");
INSERT INTO bsp_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Tatɔkɔ tɔ MARIKI ɛnayɔnɛ awut a Esayu aŋɛ ŋandɛ nde mɔrɔ ma Sehir mɔ, ntɛ ɛnamələk aHor fɔr yaŋan kiriŋ mɔ, kɔ ŋambaŋ atɔf ŋaŋan, kɔ ŋandɛ di haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Aka Awy aŋɛ ŋanandɛs-ndɛs sədare haŋ Kasa mɔ, aKaftɔr aŋɛ ŋanayɛfɛ Kaftɔr mɔ, ŋanader ŋadifət ŋa, kɔ ŋandɛ atɔf ŋaŋan. ");
INSERT INTO bsp_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","«Awa, nəyɛfɛ nəsumpər sɔ dɔpɔ nəcali kəŋgbɔkɔ ka Arnɔŋ. Məmɔmən ilɛk Sihɔŋ, wəbɛ ka Hesbon wəka aka Amɔr kɔ atɔf ŋɔn, ibɛr əm dəwaca. Tɛm tɛmbəp, məbaŋər ŋa atɔf ŋaŋan, məyektər ŋa kəwan. ");
INSERT INTO bsp_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Kəyɛfɛ mɔkɔ, kəbɛr k'inder oŋ afum akaŋɛ ŋayi kɔm tantɔf mɔ fəp anciyan kɔ kənes'am. Kɔ ŋane pacloku tetam-ɛ, ŋaŋyikcɛ, dis dɛdɛncɛ ŋa fɔr yam kiriŋ.» ");
INSERT INTO bsp_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Inasak asom kəyɛfɛ ka nde tɛgbərɛ ta Kedemot, kəkɔ ka nda Sihɔŋ wəbɛ ka Hesbon, kəkɔloku kɔ moloku ma kətəŋnɛ: ");
INSERT INTO bsp_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","«Atɔf ŋam ŋ'ifaŋ kəcali, mba dɔpɔ dem d'indesolnɛ gbəcərəm, ifɔgbaymɛ kəca kətɔt, ifɔgbaymɛ kəca kəmeriya. ");
INSERT INTO bsp_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Pəsam pɔ indekɔ icwayər'am yeri yonu nyɛ indekɔ icdi mɔ, icwayər'am sɔ pəsam domun ndɛ indekɔ icmun mɔ, kəcepər gbəcərəm k'ifaŋ ta incəmbərəs-ɛ. ");
INSERT INTO bsp_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Itɔ sənatəŋnɛ kɔ awut a Esayu aŋɛ ŋandɛ nde mɔrɔ ma Sehir, k'aMohab aŋɛ ŋandɛ dare d'Ar mɔ. Məna sɔ məwos'em kəcepər atɔf ŋam haŋ kəŋgbɔkɔ ka Yurdɛn, icali ikɔ nde atɔf ŋɔkɔ MARIKI Kanu kosu kəsɔŋ su kəkɔndɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Mba Sihɔŋ, wəbɛ ka Hesbon, ɛnawosɛ fɛ kəce su səcepər nde ndɔrɔn, bawo MARIKI Kanu kam kənayeŋkəs kɔ abəkəc kɔ domp, ntɛ tɔŋsɔŋɛ pəlɛk kɔ pəbɛr əm dəwaca mɔ, itɔ teyinɛ mɔkɔ tantɛ. ");
INSERT INTO bsp_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Kɔ MARIKI olok'im: «Məmɔmən ilɛk oŋ ndɛkəl Sihɔŋ kɔ atɔf ŋɔn k'imbɛr əm ŋa dəwaca. Məbaŋ oŋ ndɛkəl atɔf ŋɔn, ŋɔyɔnɛ ŋam.» ");
INSERT INTO bsp_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Kɔ Sihɔŋ owur kɔ afum ɔn fəp, kəkɔcaŋ su kəsutɛnɛ nde Yahas. ");
INSERT INTO bsp_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Kɔ MARIKI Kanu kosu kəmbɛr kɔ su dəwaca, kɔ səsut kɔ, nkɔn kɔ awut ɔn, kɔ afum ɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Tɛm tatɔkɔ tɔ sənasumpər sədare sasɔkɔ fəp kɔ səsut afum aŋan haŋ ŋaməlkɛ, kəyɛfɛ arkun kəbəp ka aran haŋ awut fəp, ali wəkin ɛnamulpər fɛ su. ");
INSERT INTO bsp_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Mba yɔcɔl kɔ daka gbəcərəm da sədare sasɔkɔ sənasumpər mɔ, dɔ sənafoŋət. ");
INSERT INTO bsp_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Kəyɛfɛ ka Arower nde agbɛp ŋa kəŋgbɔkɔ ka Arnɔŋ, kɔ dare dɔkɔ deyi nde kəŋgbɔkɔ kaŋkɔ kəsək mɔ, haŋ kəbɛrɛ Kalad, ali dare dɛnayi fɛ ndɛ sənatarpɛnɛ mɔ. Kɔ MARIKI Kanu kosu kəlɛk ŋa fəp kɔ kəmbɛr ŋa su dəwaca. ");
INSERT INTO bsp_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Mba sənagbuŋɛnɛ fɛ atɔf ŋ'Amoŋ. Sənakenɛ afum aŋɛ ŋanandɛ kəŋgbɔkɔ ka Yabɔk kəsək mɔ fəp pəlel, kɔ afum akɔ ŋanayi sədare sa dəmɔrɔ mɔ fəp, kəlɛkɛnɛ ka sədare səkɔ MARIKI Kanu kosu kənamɔnɛ su kəgbuŋɛnɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Kɔ səyɛfɛ səsumpər sɔ dɔpɔ kəpɛrnɛ ka Basan. Kɔ Ɔk wəbɛ ka Basan owur kədecaŋ su kəsutɛnɛ nde Edreyi, kɔ afum ɔn fəp. ");
INSERT INTO bsp_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Kɔ MARIKI olok'im: «Ta mənesɛ kɔ! Ilɛk kɔ, k'imbɛr əm dəwaca, kɔ afum ɔn fəp kɔ atɔf ŋɔn. Məyɔ kɔ pəmɔ tɔkɔ mənayɔ Sihɔŋ wəbɛ ka aka Amɔr, nwɛ ɛnandɛ Hesbon mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","MARIKI Kanu kosu ɛlɛk sɔ Ɔk wəbɛ ka Basan kɔ afum ɔn fəp, k'ɛmbɛr su dəwaca. Kɔ səsut ŋa, ali fum ɛnamulpər fɛ su ŋa dacɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Tɛm tatɔkɔ tɔ sənasumpər sədare sasɔkɔ fəp, ali dare din dɛnayi fɛ si dacɔ ndɛ sənatɔsumpər mɔ. Ɔk ɛnatɔmpər dɛbɛ da sədare wəco camət-tin (60) nde Arkɔb ŋa Basan. ");
INSERT INTO bsp_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Sədare sasɔkɔ fəp, anakɛl si sibiŋkəli səŋeci səyɔ cumba ncɛ anccaŋ mɔ. Mba sədare səlarəm səlɔma sənayi sɔ nsɛ sənatɔyɔ sibiŋkəli mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Kɔ səsut afum aka di fəp haŋ kɔ ŋaməlkɛ, pəmɔ tɔkɔ sənayɔ Sihɔŋ wəbɛ ka Hesbon mɔ, kɔ səndifət ŋa fəp, kəyɛfɛ arkun kəbəp ka aran haŋ awut. ");
INSERT INTO bsp_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Mba kɔ səfoŋət yɔcɔl kɔ daka fəp da sədare sasɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Tɛm tatɔkɔ tɔ sənabaŋər sɔ abɛ a aka Amɔr aŋɛ mɛrəŋ atɔf ntende kəca kəŋkɔ dec dɛmpɛ Yurdɛn, kəyɛfɛ ka nde kəŋgbɔkɔ ka Arnɔŋ haŋ nde tɔrɔ ta Hɛrmɔŋ. ");
INSERT INTO bsp_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Tɔrɔ tatɔkɔ tɔ aSidɔŋ ŋancwe «Siriyɔŋ,» aka Amɔr ŋacwe pi «Senir.» ");
INSERT INTO bsp_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Sənabaŋ sədare sa aranta ŋa Kalad kɔ Basan fəp, haŋ Salka kɔ Edreyi sədare sa wəbɛ Ɔk sənayi nde Basan. ");
INSERT INTO bsp_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Ɔk wəbɛ wəka Basan sona gboŋ s'ɛnacəmɛ doru oŋ aRefay alpəs dacɔ. Kəfənc kɔn ka fɛc kəsɔrɔyi Raba dare dɔpɔŋ d'Amoŋ. Dobolu da kəfənc kaŋkɔ dɔncyɔ cururu camət-maŋkəlɛ, kɔ dowokulu da ki cururu maŋkəlɛ. ");
INSERT INTO bsp_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Tɛm tatɔkɔ tɔ sənabaŋ atɔf ŋaŋɔkɔ, k'isɔŋ ŋi aRuben kɔ aKad kəyɛfɛ ka atɔf ŋa Arower nde kəŋgbɔkɔ ka Arnɔŋ haŋ dacɔ da mɔrɔ ma Kalad kɔ sədare sayi. ");
INSERT INTO bsp_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","K'isɔŋ atɔf ŋɛlpəs ŋa Kalad kɔ tɔf fəp ya dɛbɛ da Ɔk nde Basan, aka kusuŋka dacɔ ka Manase, kɔ ŋandɛ ntende dec dɛmpɛ Yurdɛn mɔ: Sədare sa Arkɔb kɔ Basan fəp, s'ancwe atɔf ŋ'aRefay. ");
INSERT INTO bsp_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Kɔ Yahir wan ka Manase ɛlɛk sədare nsɛ sənayi kəyɛfɛ ka Arkɔb mɔ, haŋ kələncər k'aKesur kɔ aMakat. K'ɛsəkpər Basan tewe, k'ɔsɔŋ di tewe tɔn. «Sədare sa cəbal sa Yahir», it'asɔrɔwe di haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","K'ilɛk atɔf ŋa Kalad k'isɔŋ ŋi Makir. ");
INSERT INTO bsp_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","K'ilɛk kəsək ka antɔf ŋa Kalad kəlɔma, k'isɔŋ aRuben kɔ aKad haŋ k'iŋkɔ inarnɛ kəŋgbɔkɔ ka Arnɔŋ, kəkɔ ka nde kəŋgbɔkɔ ka Yabɔk nde aka Amɔŋ ŋayɔ kələncər mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Kələncər ka antɔf nŋɛ ŋeyi ntende dec dɛmpɛ Yurdɛn mɔ kɔ kəŋkɔ kəlɛkɛnɛ Araba ŋɔkɔ ŋɔsɔŋɛnɛ kələncər kɔ Yurdɛn mɔ, kəyɛfɛ ka Kineret haŋ kəkɔ ka kəba k'Araba haŋ nde kəba Kədokət, nde pətəmbələr pa tɔrɔ ta Piska ntende dec dɛmpɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Tɛm tatɔkɔ t'inasom nu, icloku ntɛ: «MARIKI Kanu konu kəlɛk atɔf ŋaŋɛ kɔ kəsɔŋ nu, ŋendeyɔnɛ ŋonu. Nəna afum aŋɛ nəyɔ sɔkət mɔ fəp, nəlɛk yosutnɛnɛ nəcepər awɛnc nu aŋa aka Yisrayel kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Aran anu k'awut anu kɔ yɔcɔl yonu gbəcərəm, yendeyi nnɔ sədare nsɛ isɔŋ nu mɔ. Incərɛ a yɔcɔl yonu yɛla. ");
INSERT INTO bsp_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Nəsol kɔ awɛnc nu aŋa haŋ tɛm ntɛ MARIKI endesɔŋ ŋa kəŋesəm pəmɔ nəna mɔ, haŋ ŋa sɔ ŋabaŋ atɔf ŋɔkɔ MARIKI Kanu konu kəsɔŋ ŋa nde kəca ka mokuru ma Yurdɛn mɔ. Kɔ telip-ɛ, nəntam kəluksərnɛ nwɛ o nwɛ nde antɔf nŋɛ isɔŋ kɔ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Tɛm tatɔkɔ t'inasom Yosuwe, k'iloku kɔ: «Fɔr yam yɛnəŋk ntɛ MARIKI Kanu konu kəyɔ abɛ aŋɛ mɛrəŋ mɔ, tatɔkɔ tɔ MARIKI endekɔsɔyɔ tɔf nyɛ məndekɔcepər mɔ fəp. ");
INSERT INTO bsp_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ta nədekɔnesɛ ŋa de! Bawo MARIKI Kanu konu yati endekɔ pəcsutɛnɛnɛ nu.» ");
INSERT INTO bsp_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Tɛm tatɔkɔ t'inalɛtsɛnɛ MARIKI: ");
INSERT INTO bsp_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","«MARIKI Wəbɛ kem, məncop kəmentər im, ina wəcar kam, debeki dam, kɔ sɔkət sa kəca kam. Kanu kəre kəyi nde darenc kɔ pəyɔnɛ fɛ ti nnɔ dəntɔf nkɛ kəntam kətubucnɛ yɛbəc yam kɔ mɔyɔ mam mɔpɔŋ mɔ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Ilɛtsɛn'am məna Kanu kəsak im icepər nnɔ, ikɔ inəŋk antɔf ŋobotu nŋɛ ŋeyi Yurdɛn mokuru mɔ, mɔrɔ mentesɛ dəfɔr mmɛ kɔ Libaŋ.» ");
INSERT INTO bsp_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Mba kɔ tetonu tɔsɔŋɛ kɔ pəmpɛrnɛ MARIKI nnɔ iyi mɔ haŋ, k'ɔntɔwosɛ kəcəŋkəl im. Kɔ MARIKI olok'im: «Moloku mam mamɔkɔ mɛntəŋn'em kəne! Ta məgbɔkərɛ sɔ kəlok'im mi de!» ");
INSERT INTO bsp_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Kɔ MARIKI olok'im: «Məpɛ tɔrɔ ta Piska nde dətelempan, məyekti fɔr məgbətnɛ antɔf kəca nkɛ dec dɛŋkalɛ, kɔ nde dɛmpɛ mɔ, kəca kətɔt kɔ kəmeriya, məmɔmənɛ ŋi fɔr yam mba məfɔdecali Yurdɛn yayɛ mənəŋk mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Mba məsom Yosuwe, məsɔŋ kɔ sɔkət, məyeŋkəs kɔ abəkəc, bawo nkɔn endekɔyinɛ aka Yisrayel kiriŋ pəsɔŋɛ ŋa kəbaŋ atɔf ŋaŋɛ məŋkɔgbətnɛ mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Awa, kɔ səndɛ oŋ dəndo mɔrɔ dacɔ, sətɛfərɛnɛ kɔ Bet Peyɔr. ");
INSERT INTO bsp_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","«Ndɛkəl oŋ, aka Yisrayel, nəcəŋkəl sariyɛ kɔ mɔyɔ mokur mamɛ indetəksɛ nu kəcəmɛ mi darəŋ mɔ, ntɛ tendesɔŋɛ nu kəyi doru nəbaŋ atɔf ŋɔkɔ MARIKI Kanu ka atem anu kəsɔŋ nu mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ta nədeŋər ntɛ o ntɛ moloku mamɛ indesom nu mɔ, ali tin ta nəbelər sɔ mi, mba nəmɛŋkərnɛ mosom ma MARIKI Kanu konu pəmɔ ntɛ indesom nu mi mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Fɔr yonu yɛnəŋk ntɛ MARIKI ɔyɔ Bal Peyɔr mɔ: MARIKI Kanu kam kəmələk nu dacɔ fum nwɛ o nwɛ ɛnacəmɛ kanu ka Peyɔr darəŋ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Mba nəna aŋɛ nəsektərnɛ MARIKI Kanu konu mɔ, fəp fonu nəsɔrɔyi doru haŋ mɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Nəmɔmən, inatəksɛ nu sariyɛ kɔ mɔyɔ mokur pəmɔ ntɛ MARIKI Kanu kem ɛnasom im mi mɔ, ntɛ tɔŋsɔŋɛ nədekɔ nəcəmɛ mi darəŋ nde atɔf nŋɛ nəndekɔbaŋ, ŋɔyɔnɛ ŋonu mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Nədekɔ nəmɛŋkərnɛ mi, nəcəmɛ sɔ mi darəŋ. Ti tendekɔmentər kəcərɛ kəkɔtɛnɛ mes konu kɔ kəsɔk konu səbomp fɔr ya afum alpəs aŋɛ ŋandekɔ ŋacne pacloku sariyɛ sonu saŋsɛ mɔ. Ŋandekɔ ŋacloku: ‹Afum apɔŋ a atɔf ŋaŋɛ ŋancərɛ kəkɔtɛnɛ mes kɔ ŋasɔk səbomp!› ");
INSERT INTO bsp_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Afum aka atɔf ŋɔpɔŋ ŋere ŋayɔ canu ncɛ cəlɔtərnɛ ŋa pəmɔ ntɛ MARIKI Kanu kosu kəŋlɔtərnɛ səna tɛm o tɛm ntɛ səŋwe kɔ kəmar su mɔ-ɛ? ");
INSERT INTO bsp_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Afum aka atɔf ŋɔpɔŋ ŋere ŋayɔ sariyɛ kɔ mɔyɔ mokur mmɛ molomp, pəmɔ sariyɛ nsɛ iyi kəbocər nu mɔkɔ fɔr kiriŋ mɔ-ɛ?» ");
INSERT INTO bsp_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","«Mba məkɛkəsnɛ belbel, məkɛmbərnɛ sɔ mənasərka mataka ma kəyi kam doru fəp, ta mədepələrnɛ mɔyɔ mmɛ mənanəŋkɛ fɔr yam mɔ, ta mɔbɔlɛnɛ abəkəc ŋam. Mətəksɛ mi awut am kɔ awut-sɔ am. ");
INSERT INTO bsp_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Məcɛm-cɛmnɛ dɔsɔk ndɛ mənacəmɛ MARIKI Kanu kam fɔr kiriŋ nde tɔrɔ ta Horɛb mɔ, dɔsɔk dadɔkɔ kɔ MARIKI olok'im: ‹Məloŋkan'em aka Yisrayel fəp, ifaŋ kəsɔŋɛ ŋa kəne moloku mem, ntɛ tɔŋsɔŋɛ ŋatəkəs kənes'em mataka ma kəyi kəŋan doru fəp, ntɛ tɔŋsɔŋɛ ŋade ŋactəksɛ sɔ mi awut aŋan mɔ.› ");
INSERT INTO bsp_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Dɔsɔk dadɔkɔ kɔ nəncəmɛ tɔrɔ dəntɔf. Tɔrɔ tɛcmar nɛnc haŋ nde darenc, mba kubump kənayi, kəp kɔ kibi kəpɔŋ. ");
INSERT INTO bsp_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Kɔ MARIKI olok-lokər nu nɛnc disrɛ, kɔ nəne moloku dənɛnc, mba nənanəŋk fɛ ali teyi tɔn, mɛnɛ dim gbəcərəm. ");
INSERT INTO bsp_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","K'ɛndəŋkər nu kəsek kɔn danapa kɔ nəna, danapa ndɛ osom nu kəkɔtɛnɛ sɔ moloku mmɛ wəco mɔ, k'encicəs mi dəwalakɛ wa masar mɛrəŋ. ");
INSERT INTO bsp_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Tɛm tatɔkɔ tɔ MARIKI ɛnasom im kətəksɛ nu sariyɛ kɔ mɔyɔ mokur, ntɛ tɔŋsɔŋɛ nəcəmɛ mi darəŋ nde atɔf ŋɔkɔ nəŋkɔbaŋ, ŋɔyɔnɛ ŋonu mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","«Bawo nənanəŋk fɛ ali teyi tɔn dɔsɔk ndɛ MARIKI ɛnalok-lokər nu nɛnc disrɛ nde tɔrɔ ta Horɛb mɔ, nəkɛmbərnɛ belbel ");
INSERT INTO bsp_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ta nədetalərnɛ kəlompəs tɛrəŋka powurɛnɛ pa wərkun kɔ pəyɔnɛ fɛ ti wəran, ");
INSERT INTO bsp_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","kɔ pəyɔnɛ fɛ ti wɛsɛm wɔlɔma nwɛ weyi antɔf kəroŋ, kɔ pəyɔnɛ fɛ ti bɛmp nyɛ yɛŋfɛlər darenc mɔ, ");
INSERT INTO bsp_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","kɔ pəyɔnɛ fɛ ti yɛliŋɛ-liŋɛ ya dəntɔf, kɔ pəyɔnɛ fɛ ti lop nyɛ yeyi dəkəba mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ta məckɔnayekti fɔr kəmɔmən dəkɔm, mənəŋk dec, ŋof, kɔ cɔs nyɛ yɔyɔnɛ kənay ka ca ya dəkɔm mɔ, ta məsaknɛ paliŋəs əm kəctontnɛnɛ yi, kəcsalɛnɛ yi. Bawo afum aka doru fəp ŋɔ MARIKI Kanu kam ɔsɔŋ ca yayɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Mba nəna, MARIKI ɛlɛk nu k'owurɛnɛ nu Misira, nde nənayinɛ dacar ndɛ dɛnawurɛnɛ kɔ aco nŋɛ ŋɔŋsɔŋɛ afɛc kəsaynɛ mɔ, ntɛ tɔŋsɔŋɛ nəyɔnɛ afum ɔn a dətim mɔ. Itɔ teyinɛ mɔkɔ tantɛ. ");
INSERT INTO bsp_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Mba tetonu tɛnasɔŋɛ pətɛlɛ MARIKI nnɔ ina Musa iyi mɔ. K'ɛndɛrəm a ifɔcepər Yurdɛn, a ifɔbɛrɛ antɔf ŋobotu ŋɔkɔ MARIKI Kanu kam ɔsɔŋ əm kɛ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Awa ina Musa, nnɔ atɔf ŋaŋɛ ŋ'indefi, ifɔdecepər dɛ. Mba nəna nəndecepər, nəkɔ nəbaŋ antɔf ŋobotu ŋaŋɔkɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Nəkɛmbərnɛ belbel ta nədepələrnɛ danapa da MARIKI Kanu konu ndɛ ɛnasek kɔ nəna mɔ. Ta nəlompəs tɛrəŋka powurɛnɛ pa paka mpɛ o mpɛ, ta məyɔ tes ntɛ MARIKI Kanu kam kəmɔnɛ kəyɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Bawo MARIKI Kanu kam, eyi pəmɔ nɛnc ndɛ dɔncɔf paka mpɛ o mpɛ peŋyi di kiriŋ mɔ, Kanu kɔ nkɛ kəyɔ kəraca mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Kɔ nəndekɔsɔtɔ awut kɔ awut-sɔ, nəwon atɔf ŋaŋɔkɔ, kɔ nəndekɔtalərnɛ nəlompəs tɛrəŋka powurɛnɛ pa paka mpɛ o mpɛ, nəcyɔ mes mɛlɛc fɔr ya MARIKI Kanu konu kiriŋ mmɛ mɔŋsɔŋɛ kɔ kətɛlɛ mɔ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","indɛrəm mɔkɔ kɔm kɔ antɔf dacɔ, yɔyɔnɛ su sede: Nəndekɔfis-fis katəna dəndo atɔf ŋaŋɔkɔ nəŋkɔbaŋ ŋɔyɔnɛ ŋonu mɔ, kɔ nəndekɔcali Yurdɛn mɔ. Kɔ nəyɔ tatɔkɔ-ɛ, mataka monu mɔfɔdekɔbɔlɛ atɔf ŋaŋɔkɔ, padifət nu. ");
INSERT INTO bsp_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","MARIKI ɛŋsamsər nu afum alpəs aŋɛ dacɔ, nəpicɛ afum akɔ MARIKI endekekərɛ nu dacɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Dəndo tɔf yayɔkɔ, nəndekɔ nəcsalɛnɛ canu ncɛ cəyɔnɛ yɛbəc ya waca w'afum mɔ, pəyɔnɛ kətɔk, tasar, canu ncɛ cəntɔnəŋk, ta cəŋne, ta cəndi peri, ta cəŋne sɔ ambɔnc mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Dəndo nəndekɔtɛn MARIKI Kanu kam. Kɔ məntɛnɛ ki abəkəc ŋam fəp kɔ amera ŋam fəp-ɛ, məndekɔnəŋk ki. ");
INSERT INTO bsp_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Pəcuy pam disrɛ, kɔ mes mamɛ fəp mendekɔbəp əm-ɛ, tɛm tatɔkɔ məndekɔluksərnɛ MARIKI Kanu kam, məcəŋkəl sɔ dim dɔn. ");
INSERT INTO bsp_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Bawo MARIKI Kanu kam, Kanu ka nɔnɔfɔr kɔ, kəfɔkɔsak əm, kəfɔkɔmələk əm, kəfɔdekɔpələr danapa ndɛ ɛnadɛrmɛ atem am mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","«Kəyɛfɛ dɔsɔk ndɛ Kanu kəlompəs afum doru mɔ, kəyɛfɛ toŋkubut pa doru kəbəp ka pɔkɔ, tes tɔpɔŋ tencepər doru ntɛ tɛmbɛk pəmɔ tantɛ mɔ ba? Ane tes doru towurɛnɛ ta tantɛ ba? ");
INSERT INTO bsp_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Afum alɔma ŋane kanu kəŋan dim kəclok-loku dənɛnc, pəmɔ ntɛ məna məne Kanu kam dim, a kɔ məyi sɔ doru mɔ ba? ");
INSERT INTO bsp_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Kɔ pəyɔnɛ fɛ Kanu kosu-ɛ, kanu kəre kəkɔ kəbaŋ afum ɔn aterɛnɛ aŋan dəwaca dəmɛwakəs, dəmɛgbɛkərɛ, dəmɔyɔ mɛwɛy-wɛy, kəwan disrɛ, dəsɔkət sa kəca kɔn kətenci, kɔ mes mɔpɔŋ mɛwɛy-wɛy mmɛ MARIKI ɛnayɔnɛ nu atɔf ŋa Misira mɔ fəp, fɔr yam kiriŋ mɔ ba? ");
INSERT INTO bsp_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Tɛnasɔkər əm, kəcərɛ a MARIKI ɔyɔnɛ Kanu. Kəlɔma kəyi fɛ mɛnɛ nkɔn. ");
INSERT INTO bsp_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Kəyɛfɛ darenc kɔ kəsɔŋ'am kəne ki dim, kəctəks'am. Nnɔ dəntɔf kɔ kəsɔŋ'am kənəŋk nɛnc dɔpɔŋ da ki, ndɛ mənane ki dim disrɛ kəclok-lokər əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Kɔ nkɔnsərka yati owurɛn'am atɔf ŋa Misira kɔ fənɔntər fɔn fəpɔŋ, bawo ɛnabɔtər atem am, itɔ ɛnayɛk-yɛkɛ yuruya yaŋan ntɛ ŋa ŋancepər mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Kɔ kəmbaŋər afum tɔf aŋɛ ŋala əm kɔ ŋambɛk əm sɔkət mɔ, ntɛ tɔŋsɔŋɛ kəbɛrs'am yi kəsɔŋ əm yi kɛ yɔyɔnɛ yam mɔ, itɔ teyinɛ mɔkɔ tantɛ. ");
INSERT INTO bsp_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Awa, məndecərɛ mɔkɔ, məde məmɛŋkərnɛ sɔ ti dɛbəkəc, a MARIKI ɔyɔnɛ Kanu kəyɛfɛ darenc nde dəkɔm haŋ nnɔ antɔf kəroŋ, kanu kəlɔma kəyi fɛ sɔ, mɛnɛ Ki sona gboŋ. ");
INSERT INTO bsp_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Məmɛŋkərnɛ sariyɛ sɔn kɔ mosom mɔn pəmɔ mamɛ iyi kəsom əm mɔkɔ mɔ, ntɛ tɔŋsɔŋɛ mes mam mede mectesɛ, məna kɔ awut am kɔ məncepər-ɛ, məwon sɔ doru antɔf kəroŋ nŋɛ MARIKI Kanu kam ɔsɔŋ əm kəndɛ doru o doru mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Kɔ Musa ɛyɛk-yɛk sədare maas, mokuru ma Yurdɛn ntende dec dɛmpɛ mɔ, ");
INSERT INTO bsp_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ntɛ tɔŋsɔŋɛ səyɔnɛ səyacnɛ sa fum nwɛ endif wɛnc ta ɛyɛfɛnɛ ti. Tɔyɔnɛ yati fum nwɛ ɛnatɔter tokur aŋa mɔ, ntɛ tɔŋsɔŋɛ pətam kəyɛksɛ pəkɔ sədare saŋsɛ din pəyacnɛ kəluksɛ ayɛk mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Sədare sasɔkɔ sənayɔnɛ: Teta afum a Ruben, dare da Bɛcɛr nde aranta ŋa dətɛgbərɛ. Teta afum a Kad, dare da Ramot nde Kalad. Teta afum a Manase, dare da Kolan nde Basan. ");
INSERT INTO bsp_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Sariyɛ nsɛ sɔ Musa ɛnacəmbərɛ-cəmbərɛ aka Yisrayel. ");
INSERT INTO bsp_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Mosom, sariyɛ kɔ mɔyɔ mokur mmɛ mɔ Musa ɛnalɔmər aka Yisrayel, ntɛ ŋanawur atɔf ŋa Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Mokuru ma Yurdɛn mɔ ŋanayi, nde mɔrɔ dacɔ, pətɛfərɛnɛ di kɔ Bet Peyɔr, nde atɔf ŋa Sihɔŋ wəbɛ wəka aka Amɔr, nwɛ ɛnandɛ Hesbon, nwɛ Musa ɛnasut kɔ aka Yisrayel mɔ, ntɛ ŋanawur kəyɛfɛ atɔf ŋa Misira mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","K'aka Yisrayel ŋambaŋ atɔf ŋɔn kɔ ŋa Ɔk, wəbɛ wəka Basan. Abɛ a aka Amɔr akaŋɛ mɛrəŋ, nde mokuru ma Yurdɛn ntende dec dɛmpɛ mɔ ŋanandɛ. ");
INSERT INTO bsp_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Aka Yisrayel ŋambaŋ atɔf ŋaŋɔkɔ kəyɛfɛ ka Arower nde agbɛp ŋa kəŋgbɔkɔ ka Arnɔŋ, haŋ nde tɔrɔ ta Siyɔn mpɛ aŋwe sɔ Hɛrmɔŋ mɔ, ");
INSERT INTO bsp_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Araba fəp, mokuru ma Yurdɛn ntende dec dɛmpɛ mɔ, haŋ nde kəba ka Araba, nde pətəmbələr pa Piska. ");
INSERT INTO bsp_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Kɔ Musa ewe aka Yisrayel fəp, k'oloku ŋa: «Məsu ləŋəs, məna Yisrayel, sariyɛ kɔ mɔyɔ mokur mmɛ iyi kəloku mɔkɔ mɔ. Nətəkəs mi, nəmɛŋkərnɛ kəcəmɛ ka mi sɔ darəŋ. ");
INSERT INTO bsp_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","MARIKI Kanu kosu kəsek danapa kɔ səna aka Yisrayel nde tɔrɔ ta Horɛb. ");
INSERT INTO bsp_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Bafɔ atem asu ŋɔ MARIKI ŋanasek danapa dadɔkɔ de, mba səna aŋɛ səyi mɔkɔ doru səcŋesəm mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","MARIKI ɛnalok-lokər nu dətɔrɔ nətɛfərɛnɛ pəyi nɛnc disrɛ. ");
INSERT INTO bsp_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Tɛm tatɔkɔ t'ina Musa, inacəmɛ nu dacɔ kɔ MARIKI, ntɛ tɔŋsɔŋɛ icluksɛ nu moloku ma MARIKI mɔ, bawo nəncnesɛ nɛnc dadɔkɔ. Nənapɛ fɛ tɔrɔ kəroŋ. K'oloku: ");
INSERT INTO bsp_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‹In'ɔyɔnɛ MARIKI Kanu kam, in'owurɛn'am atɔf ŋa Misira nde kəlɔ ka dacar. ");
INSERT INTO bsp_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Məfɔdeyɔ canu cəlɔma fɔr ya ina kiriŋ. ");
INSERT INTO bsp_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ta məlompəs tɛrəŋka mpɛ o mpɛ powurɛnɛ kɔ paka mpɛ peyi dəkɔm, dəntɔf kɔ dəkəba mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ta məde məctontnɛ ca yayɔkɔ fɔr kiriŋ, ta məde məcsalɛnɛ yi sɔ. Bawo ina MARIKI Kanu kam, Kanu k'iyɔnɛ nkɛ kəyɔ kəraca mɔ, nkɛ kəŋluksɛ kəway ka kiciya ka kas nnɔ awut ɔn ŋayi mɔ, haŋ dɛtɛmp maas haŋ dɛtɛmp maŋkəlɛ da akɔ ŋanter im mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Mba iŋsektərnɛ danapa da dɛtɛmp wul win (1.000), da afum aŋɛ ŋambɔtər im ŋamɛŋkərnɛ mosom mem mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ta məbonc tewe ta MARIKI Kanu kam kifəli. MARIKI ɔfɔsak ta ɔsɔŋ kəway ka kiciya, nwɛ omboncəs tewe tɔn kifəli mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Məleləs simiti dɔsɔk da kəŋesəm, dɔyɔn'am dɔsɔk dopus pəmɔ ntɛ MARIKI Kanu kam kəsom əm ti mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Mata camət-tin tataka toluksər disrɛ mədekɔ məcbəc, məclompəs yɛbəc yam fəp mataka mamɔkɔ disrɛ. ");
INSERT INTO bsp_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Mba tataka ta camət-mɛrəŋ, dɔsɔk da kəŋesəm dɔ ndɛ ampusɛ MARIKI Kanu kam mɔ. Ali yɛbəc ta məbəc dɔsɔk dadɔkɔ, kəyɛfɛ məna, wan kam wərkun kɔ wəran, kəkɔ ka wəcar kam wərkun kɔ wəran, kəbəp wana wam, sɔfale sam, pɔcɔl pam mpɛ o mpɛ, kɔ wəcikəra kam nwɛ eyi nde ndaram, ntɛ tɔŋsɔŋɛ wəcar kam wərkun kɔ wəran ŋactam kəŋesəm dɔsɔk dadɔkɔ pəmɔ məna mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Mədekɔ məccɛm-cɛmnɛ a mənayɔnɛ wəcar atɔf ŋa Misira, kɔ MARIKI Kanu kam kəŋkɔ kəwurɛn'am di kɔ sɔkət sa kəca kɔn kətenci. Itɔ MARIKI Kanu kam kəsom əm kəcleləs dɔsɔk da kəŋesəm ndɛ ampusɛ kɔ mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Məleləs wisi kɔ wiri, pəmɔ ntɛ MARIKI Kanu kam osom'əm mɔ, ntɛ tɔŋsɔŋɛ mataka mam meyi doru mɔbɔl mɔ, mes mam mede mectesɛ sɔ nde antɔf ŋɔkɔ MARIKI Kanu kam ɔsɔŋ əm mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ta mədif fum. ");
INSERT INTO bsp_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ta məsumpər dalakɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Ta məkiyɛ. ");
INSERT INTO bsp_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ta məbaŋɛ wɛnc əm sede sa yem. ");
INSERT INTO bsp_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Ta məyɔ fɔr gban-gban nnɔ wəran ka wɛnc əm eyi mɔ. Ta məfaŋ kəlɔ ka wɛnc əm, kəyɛfɛ dalɛ dɔn, wəcar kɔn wərkun kɔ wəran, wana wɔn, sɔfale sɔn, ta məfaŋɛ daka o daka da wɛnc əm abəkəc ŋɛlɛc.›» ");
INSERT INTO bsp_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Moloku mamɛ mɔ MARIKI ɛnaloku kəloŋkanɛ konu fəp nde dətɔrɔ, pəyi nɛnc disrɛ, dəkəp kɔ kubump kəpɔŋ, pəpɛnɛ dim, ali toloku ɛnadeŋər fɛ sɔ. K'encic moloku mamɛ walakɛ mɛrəŋ wa masar kəroŋ k'ɔsɔŋ im wi. ");
INSERT INTO bsp_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Ntɛ nəne dim dadɔkɔ kəyɛfɛ ka kubump disrɛ mɔ, tɛtəŋnɛ tɔrɔ fəp pɛcmar nɛnc, kəyɛfɛ nəna, kəkɔ akiriŋ a cusuŋka conu fəp, kəbəp abeki anu nənder nəlɔtərn'em. ");
INSERT INTO bsp_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Kɔ nəloku: «MARIKI Kanu kosu kəmentər su nɔrɔ da debeki dɔn, kɔ səne dim dɔn pəyi nɛnc disrɛ. Dɔsɔk dadɔkɔ sənanəŋk oŋ a Kanu kəntam kəlok-lokər fum, wəkayi pətam sɔ kəyi doru. ");
INSERT INTO bsp_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Mba ndɛkəl, ta ake tɔ səndefinɛ ti-ɛ? Bawo nɛnc dɔpɔŋ dandɛ dendecɔf su. Kɔ səŋgbɔkərɛ sɔ kəcəŋkəl dim da MARIKI Kanu kosu-ɛ, səŋfi. ");
INSERT INTO bsp_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Fum wəre ɛnane pəmɔ səna dim da Kanu ka doru o doru kəclok-loku dənɛnc wəkayi pəyi sɔ doru-ɛ? ");
INSERT INTO bsp_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Musa məna məlɔtərnɛ məcəŋkəl tɔkɔ MARIKI Kanu kosu ɔŋkɔloku mɔ fəp, məna məder məloku su ntɛ o ntɛ MARIKI Kanu kosu kəlok'əm mɔ. Səndecəŋkəl ti, səcyɔ sɔ ti.» ");
INSERT INTO bsp_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Kɔ MARIKI ene moloku mɔkɔ nəna aka Yisrayel nəlok'im mɔ, kɔ MARIKI olok'im: «Ine tɔkɔ aka Yisrayel ŋalok'əm mɔ. Tɔkɔ ŋaloku mɔ fəp tentesɛ. ");
INSERT INTO bsp_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Tɔcyɔnɛ a ŋandeyɔ bəkəc yayɛ tɛm fəp ŋacnes'em, ŋamɛŋkərnɛ mosom mem fəp, ntɛ tɔŋsɔŋɛ mes maŋan mede mectesɛ ŋa kɔ awut aŋan doru o doru mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Məna Musa, məloku ŋa: ‹Nəlukus nde cəbal conu.› ");
INSERT INTO bsp_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Mba məna Musa, məyi nnɔ kɔ ina, idelok'əm tosom fəp, sariyɛ kɔ mɔyɔ mokur mem mmɛ məŋkɔtəksɛ ŋa, ntɛ tɔŋsɔŋɛ ŋacəmɛ mi darəŋ nde atɔf ŋɔkɔ iŋkɔsɔŋɛ ŋa kəbaŋ ŋɔyɔnɛ ŋaŋan mɔ.» ");
INSERT INTO bsp_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Ina Musa icloku nu a nədekɔ nəmɛŋkərnɛ kəcəmɛ ka tɔkɔ MARIKI Kanu konu kəsom nu mɔ darəŋ. Ta nədekɔ nəcgbaymɛ kəca kətɔt, ta nədekɔ nəcgbaymɛ kəca kəmeriya. ");
INSERT INTO bsp_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Nəsurɛnɛ kəcəmɛ dɔpɔ dɔkɔ MARIKI Kanu konu kəsom nu mɔ fəp darəŋ, ntɛ tɔŋsɔŋɛ nəyi doru, pəde pəbɔt nu, nəbɔlsɛ mataka monu nde atɔf ŋaŋɔkɔ nəŋkɔbaŋ ŋɔyɔnɛ ŋonu mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Mosom, sariyɛ kɔ mɔyɔ mokur mɛmɛ, mmɛ MARIKI Kanu konu kəsom a patəksɛ nu mɔ, ntɛ tɔŋsɔŋɛ nədekɔ nəcəmɛ mi darəŋ ntende atɔf ŋɔkɔ nəyi kəcepər kəkɔbaŋ ŋɔyɔnɛ ŋonu mɔ, ");
INSERT INTO bsp_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ntɛ tɔŋsɔŋɛ məcnesɛ MARIKI Kanu kam, məmɛŋkərnɛ dɔsɔk o dɔsɔk kiyi kam doru, məna kɔ wan kam kɔ wan ka wan kam sariyɛ sɔn fəp kɔ mosom mɔn mmɛ iyi kəsom əm, ntɛ tɔŋsɔŋɛ mataka mam meyi doru mɔbɔl mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Awa məcəŋkəl mi məna Yisrayel, məmɛŋkərnɛ kəcəmɛ ka mi darəŋ, ntɛ tɔŋsɔŋɛ mes mam mede mectesɛ, nəkoməs, nəla duk pəmɔ tɔkɔ MARIKI Kanu ka atem am kənalok'əm ti, nnɔ atɔf ŋaŋɛ ŋomboŋ dalɛ k’awop mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Məcəŋkəl, Yisrayel! MARIKI Kanu kosu, sona gboŋ s'ɔyɔnɛ MARIKI. ");
INSERT INTO bsp_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Məbɔtərɛ MARIKI Kanu kam, abəkəc ŋam fəp, afɔkəl ŋam fəp, kɔ sɔkət sam fəp. ");
INSERT INTO bsp_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Moloku mamɛ iyi kəsom əm mɔkɔ mɔ, mede mey'əm dɛbəkəc. ");
INSERT INTO bsp_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Mədekɔ məgbɔkərɛnɛ mi awut am, məcloku mi kɔ məndɛ kəlɔ kam disrɛ, kɔ mənde kəckɔt, kɔ mənde kəcfəntərɛ, kɔ mənde kəcyɛfɛ sɔ dəkəfənc-ɛ. ");
INSERT INTO bsp_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Məkotərnɛ mi kəca kam kəroŋ, tɔyɔnɛ tɛgbɛkərɛ dəwaca wam kəroŋ, mey'əm dətobu fɔr yam dacɔ. ");
INSERT INTO bsp_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Məcicəs mi fərɛm fa kumba ka kəlɔ kam kɔ dəcusuŋka ca sədare sam. ");
INSERT INTO bsp_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Kɔ MARIKI Kanu kam, endekɔbɛrs'am atɔf ŋɔkɔ kənadɛrmɛ atem am Abraham, Siyaka, kɔ Yakuba kəsɔŋ əm mɔ, sədare səpɔŋ, sətɔt, nsɛ məntɔcəmbər mɔ, ");
INSERT INTO bsp_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","məndebɛrɛ wɔlɔ nwɛ wɛlarɛ ca cətɔt fəp nyɛ məntɔbɛrsɛ mɔ, məndekɛt domun dəcələmp ncɛ məntɔkay mɔ, məndedi yokom ya ŋgbɔŋkəlɔ ya wɛn kɔ tɔk ya olif nyɛ məntɔbɔf mɔ. Kɔ məndekɔdi yeri mənɛmbərɛ-ɛ, ");
INSERT INTO bsp_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","məkɛmbərnɛ kətɔpələr MARIKI, nwɛ ɛnawurɛn'am atɔf ŋa Misira kəlɔ ka dacar mɔ. ");
INSERT INTO bsp_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Nkɔn MARIKI Kanu kam məndekɔ məcnesɛ, məcsalɛnɛ kɔ, məcdɛrmɛ tewe tɔn. ");
INSERT INTO bsp_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ta nədekɔ nəccəmɛ canu cəcuru darəŋ, canu ca afum aŋɛ ŋandekɔkɛl nu mɔ de! ");
INSERT INTO bsp_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Bawo MARIKI Kanu kam nwɛ eyi nu dacɔ mɔ, Kanu kɔ nkɛ kəyɔ kəraca mɔ, kɔ məsɔŋɛ pətɛlɛ ki nnɔ məyi mɔ-ɛ, kəŋmələk əm, kəsɔŋɛ ta anəŋk əm sɔ antɔf ŋaŋɛ kəroŋ-ɛ. ");
INSERT INTO bsp_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ta nədə