﻿USE sofia;
DROP TABLE IF EXISTS sofia.bsnNT_vpl;
CREATE TABLE bsnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bsnNT_vpl WRITE;
INSERT INTO bsnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesús ñacami “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõar'i, Abraham ñamasir'i, to yicõari, Ʉjʉ David ñamasir'i jãnami. Tire mʉa masisere bojagʉ ñari, ĩ ñicʉa vãmere mʉare gotigʉagʉ yaja yʉ. Ado bajiro vãme cʉtimasiñujarã ĩna: ");
INSERT INTO bsnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ñamasir'i macʉ ñamasiñuju Isaac. Isaac macʉ ñamasiñuju Jacob. Jacob macʉ ñamasiñuju Judá. To yicõari, gãjerã ĩ bederã quẽne ñamasiñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá rĩa Fares, to yicõari, Zara ñamasiñujarã. Ĩna jaco ñamasiñuju Tamar. Fares macʉ ñamasiñuju Esrom. Esrom macʉ ñamasiñuju Aram. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram macʉ ñamasiñuju Aminadab. Aminadab macʉ ñamasiñuju Naasón. Naasón macʉ ñamasiñuju Salmón. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón macʉ ñamasiñuju Booz. Ĩ jaco ñamasiñuju Rahab. Booz macʉ ñamasiñuju Obed. Ĩ jaco ñamasiñuju Rut. Obed macʉ ñamasiñuju Isa'i. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isa'i macʉ ñamasiñuju Ʉjʉ David vãme cʉtigʉ. David macʉ ñamasiñuju Salomón. Ĩ jaco ñamasiñuju Ur'ias ñamasir'i manajo. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón macʉ ñamasiñuju Roboam. Roboam macʉ ñamasiñuju Ab'ias. Ab'ias macʉ ñamasiñuju Asa. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa macʉ ñamasiñuju Josafat. Josafat macʉ ñamasiñuju Joram. Joram macʉ ñamasiñuju Uz'ias. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uz'ias macʉ ñamasiñuju Jotam. Jotam macʉ ñamasiñuju Acaz. Acaz macʉ ñamasiñuju Ezequ'ias. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequ'ias macʉ ñamasiñuju Manasés. Manasés macʉ ñamasiñuju Amón. Amón macʉ ñamasiñuju Jos'ias. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jos'ias macʉ ñamasiñuju Jecon'ias. To yicõari, ĩ bederã quẽne ñamasiñujarã. To bajiro ĩna bajiñarijʉ, Israel sitanare ñejecõari, Babiloniana ĩnare juamasiñujarã, ĩnare rotiajerʉarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Quẽna Jecon'ias macʉ ñamasiñuju Salatiel. Salatiel macʉ ñamasiñuju Zorobabel. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel macʉ ñamasiñuju Abiud. Abiud macʉ ñamasiñuju Eliaquim. Eliaquim macʉ ñamasiñuju Azor. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor macʉ ñamasiñuju Sadoc. Sadoc macʉ ñamasiñuju Aquim. Aquim macʉ ñamasiñuju Eliud. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud macʉ ñamasiñuju Eleazar. Eleazar macʉ ñamasiñuju Matán. Matán macʉ ñamasiñuju Jacob. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob macʉ ñañuju José. Ĩ ñañuju Mar'ia manajʉ. So ñañuju “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i, Jesús jaco. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham rĩa jãnerabatia, David ĩ ñamasiariajʉne jʉaãmo cõro, gʉbo babari rãca jẽnituarirãcʉ ñasʉomasiñujarã. Abraham macʉ ñamasiñuju Isaac. Isaac macʉ ñamasiñuju Jacob. To bajiro mani cõĩaruji vajama, David ĩ ñamasiriajaʉne jʉaãmo cõro, gʉbo babari rãca jẽnituarirãcʉ ñamasiñujarã ĩna. Tijʉ bero, quẽna David macʉ ñamasiñuju Salomón. Salomón macʉ ñamasiñuju Roboam. To bajiro mani cõĩaruji vajama, Babilonia macajʉ Israel sitanare ĩna jua vamasiriajaʉne quẽna jʉaãmo cõro, gʉbo babari rãca jẽnituarirãcʉ ñamasiñujarã ĩna. Jecon'ias macʉ ñañuju Salatiel. Salatiel macʉ ñañuju Zorobabel. To bajiro mani cõĩaruji vajama, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ĩ ruyuarirodo jʉaãmo cõro, gʉbo babari rãca jẽnituarirãcʉ ñamasiñujarã quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i, Jesús ĩ ruyuare ado bajiro bajiyuju: Ĩ jaco ñaroco, Mar'ia vãme cʉtigo ñañuju so. So manajʉ ñarocʉ ñañuju José. Ĩ rãca so ñaroto rĩjoro, Esp'iritu Santo sore ejacõari, sore macʉ yiyuju ĩ. Sore ĩ macʉ yijare, macʉ sãñagõ ñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, so manajʉ ñarocʉ quẽnagʉ̃ ñañuju. To bajiro bajigʉ ñari, masa ĩaro rĩjorojʉa bojoneoro so tãmʉorotire bojabesuju. To bajiri, masa ĩna ajibeto, “Mʉre bojabeaja yʉ”, sore yirʉaboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","To bajiro tʉoĩa ĩ cãniatone, ĩ cãjiriarojʉ Diore moabosagʉ ángel, ĩre ruyuaĩoñuju. Ruyuaĩocõari, ado bajiro ĩre gotiyuju: —Ajiya José, David ñamasir'i jãnami. Mar'iare manajo cʉtirʉa güibesa. Esp'iritu Santo sore ĩ macʉ yijare, macʉ sãñagõ ñaamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Macʉ cʉorʉocomo so. Ĩre, Jesús ĩre vãme yirʉcʉja mʉ. Masa rojose ĩna yise ñajare, Dios ĩ masiriose vaja, vaja yirẽtobosarocʉ ñarʉcʉmi ĩ. To bajiro yirocʉ ĩ ñajare, Jesús ĩre vãme yirʉcʉja mʉ —Josére ĩre yiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","“Ado bajiro bajirʉaroja” Diore gotirẽtobosamasir'i ĩ yimasire ñajare, to bajiro yiyuju ángel. Ado bajiro yimasiñuju: ");
INSERT INTO bsnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Rõmio, ʉ̃mʉa rãca ñabeco, macʉ sãñagõ ñarʉocomo so. To bajiri macʉ cʉorʉocomo so. ‘Emanuel’ ĩre yirʉarãma masa”, yimasiñuju Diore gotirẽtobosarimasʉ. (“Mani rãca ñaami Dios” yire ũni ñaja “Emanuel” yirema.) ");
INSERT INTO bsnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","“Esp'iritu Santo sʉorine macʉ sãñaamo” ángel ĩ yire ñajare, Mar'iare ĩ ya vijʉ ãmicoasuju José. Macʉ sãñagõ so ñajare, so rãca ñabetirũgũñuju. So cʉoro bero, Jesús ĩre vãme yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea sita ñarimaca, Belén vãme cʉti macajʉ ruyuayuju ĩ. Ĩ ruyuarirodore ti sita ʉjʉ, Herodes vãme cʉtigʉ ñañuju. Jesús ĩ ruyuaro bero, Jerusalén macajʉ ejayujarã, muiju ĩ jiadojʉa vadiriarã, ñocoa ĩna bajisere buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ti maca ejacõari, sẽniĩañujarã ĩna: —¿Nore ñati jud'io masa ʉjʉ ñarocʉ ruyuar'ima? Muiju ĩ jiadojʉa ñocore ĩabʉjacõari, “Tojʉ ruyuagʉmi” yirã ñari, ĩre rʉ̃cʉbʉoroana vadiaja yʉa —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","To bajiro ĩna sẽniĩacudisere ajicõari, toagʉ ʉjʉ, Herodes bʉto tʉoĩagüiyuju, “Ĩjʉa, ʉjʉ yʉ ñasere yʉre ẽmarʉcʉmi” yitʉoĩagʉ̃ ñari. Ĩre bajiro rĩne tʉoĩañujarã ti macana Jerusalén macana quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","To bajiro tʉoĩagʉ̃ ñari, paia ʉjarãre, Dios ĩ rotimasire gotimasiorimasare quẽne ĩnare jirẽoñuju Herodes. Ĩna ejaro ĩacõari, ado bajiro ĩnare sẽniĩañuju ĩ: —“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉma, ¿nojʉ, “Ruyuarʉcʉmi” yiyujari Dios ocare masa ĩna ucamasire? —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","To bajiro ĩ yisẽniĩarone, ado bajiro ĩre yicʉdiyujarã ĩna: —“Judea sita Belén vãme cʉti macajʉ ruyuarʉcʉmi” yiucamasiñumi sĩgʉ̃ Diore gotirẽtobosarimasʉ. Ado bajiro yaja ĩ ucamasire: ");
INSERT INTO bsnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Judea sita ñarimaca Belén vãme cʉti maca, jairimaca me ñaboarine, ñamasuri maca ñarʉaroja ti maca. Ti macagʉ ʉjʉ ñamasugʉ̃ ruyuarʉcʉmi. Ĩ ñarʉcʉmi yʉ yarã Israel sitana ʉjʉ. Ĩnare quẽnaro ĩatirʉ̃nʉrʉcʉmi ĩ, yiyuju Dios”, yiucare ñaja —ĩre yigotiyujarã Dios ĩ rotimasire gotimasiorimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","To ĩna yisere ajicõari, quẽna ñocoa ĩna bajisere buerimasare masa ĩna ajibeto ĩnare jiyuju Herodes. To yicõari, ado bajiro ĩnare sẽniĩañuju ĩ: —¿Divato masu ñoco ruyuasʉori? —ĩnare yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","To yigajano, Belénjʉ ĩnare varotiyuju ĩ: —Vasa. Sũcare, quẽnaro ĩre macama. Ĩre ĩabʉjacõari, yʉre gotirã vaba. Yʉ quẽne ĩre rʉ̃cʉbʉogʉ varʉ yaja —yiyuju, ĩnare yitogʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","To bajiro ĩ yirotisere ajicõari, ĩ yirore bajirone vasujarã ĩna. To ĩna vatone, muiju jiadojʉa ñoco, ĩna ĩar'i, ĩnare rĩjoro cʉti vasuju. To bajiva, tujarʉ̃gʉ̃ñuju, sũca ĩ ñaro veca. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ñoco ĩ tujarʉ̃gʉ̃sere ĩacõari, bʉto variquẽna vasujarã ĩna, ñocoa ĩna bajisere buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ñoco ĩ ñaro ẽñeroca ñarivi sãjacõari, ĩna ĩajama, to ñañuju sũca, ĩ jaco rãca. Ĩre ĩacõari, ĩ rĩjorojʉa gʉsomuniari tuetuejayujarã ĩna, ĩre rʉ̃cʉbʉoquẽnariorã. To bajiro yigajano, ĩna juavarere jãnacõari, oro, quẽnase sʉtise to yicõari, mirra vãme cʉtisere quẽne ĩre ĩsiñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","To ĩna yiro bero, ĩna cãjiriarojʉ, “Herodes tʉ tudiabesa. ‘To ñagʉ̃mi sũca’ yimasibeticõato ĩ”, ĩnare yiyuju Dios. To bajiri tire masicõari, Jerusalénjʉ vamenane gaje maajʉ tudicoasujarã ĩna yuja, ĩna ya macajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ñocoa ĩna bajisere buerimasa ĩna tudiato bero, José ĩ cãjiriarojʉ ĩre ruyuayuju ángel quẽna. Ruyuacõari, ado bajiro ĩre yiyuju: —Yujiya. Sũcare, ĩ jacore quẽne Egiptojʉ ĩnare ũmato rudiasa mʉ. Tone ñacõama maji. Mʉre yʉ gotirojʉ tudiaba. Herodes, Jesúre sĩarʉ ĩre macarʉcʉmi —Josére ĩre yiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","To ĩ yijare, yujicõari, Jesúre, ĩ jacore quẽne ñamine Egiptojʉ ĩnare ũmato rudicoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tojʉ ĩna ñatoyene bajirocacoasuju Ʉjʉ Herodes. “Egipto sitajʉ yʉ macʉ ĩ ñaro ĩre jicõarʉcʉja yʉ”, ĩre gotirẽtobosarimasʉ sʉorine Dios ĩ yimasire ñajare, to bajirone bajiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bajirocabecʉjʉ, ñocoa ĩna bajisere buerimasa ĩre gotimenane, gaje maajʉ ĩna tudiarere ajicõari, bʉto jũnisiniñuju Herodes. To bajiri jũnisinigʉ̃ ñari, Belén ñarãre, ti maca tʉanare rĩamasa jʉa cʉ̃ma tʉsanare ʉ̃mʉare, to yicõari, ĩna bero ruyuariarãre quẽne sĩarotijeocõañuju. Ñocoa ĩna bajisere buerimasa, “Jʉa cʉ̃ma tʉsajʉ” ĩna yirere ajigʉ ñari, ĩnare sĩarotiyuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Raquel ñamasirio so rĩare maigõ, so otimasiriarore bajiro Belén macana ĩna rĩare mairã, ĩna otirotire tʉoĩacõari, ado bajiro ucamasiñumi Diore gotirẽtobosarimasʉ Jerem'ias vãme cʉtigʉ: ");
INSERT INTO bsnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá vãme cʉti macago so rĩare so tʉoĩa otise ruyurʉaroja. Oticõa ñarʉocomo so, Raquel vãme cʉtigo, so rĩare otigo. Gãjerã, ‘Otibesa’ sore ĩna yiboajaquẽne, ajibetirʉocomo, so rĩa ñamasiboariarãre godocʉtigo ñari”, yiucamasiñumi Jerem'ias. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Egiptojʉ José ĩ ñaro rijacoasuju Herodes. Ĩ rijato bero, José ĩ cãjiriarojʉre sĩgʉ̃ ángel ĩre ruyuaĩoñuju quẽna. To bajicõari, ado bajiro ĩre yiyuju: ");
INSERT INTO bsnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—¡Yujiya! Jesúre, ĩ jacore quẽne Israel sitajʉ ĩnare ũmato tudiasa. Ĩre sĩarʉaboacana rijajedicoajama ĩna —Josére ĩre yiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","To ĩ yijare, yujicõari, Jesúre, ĩ jacore quẽne Israel sitajʉ ĩnare ũmato vasuju José. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Maa vacʉjʉ, ajiyuju José: “Herodes ñaboar'i macʉ, Arquelao vãme cʉtigʉ, ĩ jacʉre vasoagʉ Judea sitajʉ ñañuju”, yire quetire ajiyuju. Ti quetire ajicõari, güigʉ ñari, tojʉ varʉabesuju. To bajiro bajigʉne, quẽna tojʉ cãjiriañuju ĩ. Cãjiriacõari, “Tojʉ yʉ vajama, quẽnabetoja. Galilea sitajʉa varʉcʉja yʉ”, yitʉoĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea sitajʉ ejacõari, Nazaret vãme cʉti macajʉ ñagʉ̃ vasuju. Diore gotirẽtobosarimasa, “Nazaret macagʉ ñarʉcʉmi ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ”, Jesúre ĩna yiucamasire ñajare, to bajirone bajiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tirodori bero, Juan Bautista vãme cʉtigʉ, Judea sitajʉ yucʉ́ manojʉ ejayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tojʉ ejacõari, ado bajiro ĩre ajirã ejarãre gotimasiorũgũñuju ĩ: —Yoaro mene ejarʉcʉmi “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ. To bajiri rojose mʉa yisere yitʉjacõari, Dios ĩ bojasejʉare yi yuya mʉa —ĩnare yirũgũñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ĩne ñañuju, “Ado bajiro yirʉcʉmi” Diore gotirẽtobosarimasʉ Isa'ias vãme cʉtimasir'i ĩ yiucamasir'i. Ado bajiro ĩre yiucamasiñuju Isa'ias: “Yucʉ́ manojʉ sĩgʉ̃ masʉ ado bajiro goticudirũgũrʉcʉmi: ‘Mani ʉjʉ ejarʉcʉmi. To bajiri, rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩaña mʉa, ĩre yurã’ yirʉcʉmi sĩgʉ̃”, yiucamasiñuju Isa'ias, Juan ĩ bajirotire goti rĩjoro yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Camello joane suariaro sãñagʉ̃ ñañuju ĩ. To yicõari, vecʉ gaserone vẽñaricũñuju, ĩ sãñasere. Ñimia ba, to yicõari, beroa ocore idi, yirũgũñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ĩre ajirã, jãjarã masa ejayujarã. Jerusalén macana, Judea sitana, to yicõari, Jordán vãme cʉtiya tʉana quẽne ejayujarã, ĩre ajirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","To bajiro ĩ gotisere ajirã ñari, “Rojose mani yisere Dios manire masirioato” yirã, “Rojose yirã ñaja yʉa” Diore ĩna yigotiro bero, Jordán vãme cʉtirisajʉ oco rãca ĩnare bautiza ñañuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","To bajiro ĩ yiñarone, fariseo masa, to yicõari saduceo masa quẽne Juan oco rãca ĩ bautizasere bojarã ejayujarã. Ĩna ejasere ĩacõari, ado bajiro ĩnare yiyuju Juan: —Oco rãca mʉare yʉ bautizasere bojaboaja mʉa. Vãtia ʉjʉ rojose ĩ yirore bajirone rojose yijairã ñaja mʉa. To bajiro bajirã ñari, “Rojose yʉa yise vaja rojose yʉare yibetirʉcʉmi Dios” yitʉoĩa vadiboaja mʉa. ¿To bajiro mʉa bajise sʉorine rojose mʉa tãmʉorotire masibeatique mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rojosere yitʉjacõari, “Quẽnarã ñaama” masa mʉare ĩna yiĩamasirotire yirã, quẽnasejʉare yirũgũrona ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ado bajiro yitʉoĩabesa mʉa: “Abraham ñamasir'i jãnerabatia ñamasurã mani ñajare, rojose mani yise vaja rojose manire yibetirʉcʉmi Dios” yitʉoĩabesa. Adiari gʉ̃tari rãca Abraham jãnerabatiare ĩ godoveorʉajama, godoveomasigʉ̃mi Dios —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Oteriayucʉ́ri, rica mani yucʉ́rire bajiro bajiaja mʉa. Rica manijare, quẽareacõari, soereariarore bajiro yirʉcʉmi Dios. Tire bajirone yiecorʉarãja mʉa quẽne, mʉa tʉoĩavasoabetijama. ¡Quẽnase mʉa yibetire ĩacõari, jeame yatibetimejʉ mʉare rearʉcʉmi Dios! —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gaje vãme ado bajiro gotiyuju Juan: —Yʉ berore yʉ rẽtoro masigʉ̃ ejarʉcʉmi. Ñamasurã rĩne ĩre yibosamasiama, ñamasugʉ̃ masu ĩ ñajare. Rojose ĩna yisere yitʉjacõari, Dios ĩ bojasejʉare yirãre oco rãca bautizarũgũaja yʉ. To bajiro yʉ yirũgũse ti quẽnaboajaquẽne, yʉ bero ejagʉ ĩ moasejʉa quẽnamasucõarʉaroja. Ĩma, Esp'iritu Santore cõamasirʉcʉmi, masare. Ĩ sʉorine “Dios ĩ bojabetire yaja yʉa” yimasicõari, tʉoĩavasoarʉarãma —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gaje vãme ado bajiro masare gotiyuju Juan: —Yʉ bero ejagʉjʉama, trigo ajere besegʉre bajiro yirʉcʉmi, masare. To bajiri ti gasere yireacõari, soereariarore bajiro yirʉcʉmi, jeame yatibetimejʉ masare cõagʉ̃, to yicõari, quẽnase cõrone juagʉre bajiro yirʉcʉmi, ĩre ajitirʉ̃nʉrãre juavacʉ —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cojorʉ̃mʉ Galilea sitajʉ ñar'i, Jordán vãme cʉtirisajʉ vasuju Jesús. Juan tʉjʉ ejacõari, oco rãca ĩre bautizarotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","To bajiro ĩre ĩ yiboajaquẽne, oco rãca ĩre bautizarʉabesuju Juan: —Bajibeaja. No yigʉ mʉre bautizamasibecʉja yʉ. Mʉjʉa, yʉ rẽtoro masigʉ̃ ñari, oco rãca yʉre bautizarocʉ ñaja mʉ —Jesúre ĩre yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","To ĩ yisere ajicõari, ado bajiro ĩre yicʉdiyuju Jesús: —Yʉre oco rãca mʉ bautizasere bojaami Dios. Ñajediro Dios ĩ rotirore bajiro cʉdiroti ñaja manire —Juanre ĩre yiyuju Jesús. To bajiro ĩ yijare, —Baʉ. To bajirone bojaroja —ĩre yicʉdicõari, Jesúre oco rãca ĩre bautizayuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús ĩ majarʉ̃gʉ̃rirĩmarone ʉ̃mʉagasero soje jãnacoasuju ti. Ti jãnarone, õ vecajʉ Jesús ĩ ĩamʉorone, bujare bajigʉ rujiadicõari, Jesús joere rocajeoyuju Esp'iritu Santo. ");
INSERT INTO bsnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jesús joere ĩ rocaejarone, ado bajiro yi ocaruyuyuju õ vecajʉ: —Yʉ macʉ, yʉ maigʉ̃ masu ñaja mʉ. Mʉ rãca bʉto variquẽnaja yʉ —ĩre yi ocaruyuyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesús, oco rãca Juanre ĩ bautizarotiro bero, yucʉ́ manojʉ ĩre ũmato vasuju Esp'iritu Santo, “Satanás ĩ bojarore bajiro rojose Jesúre ĩre yirotiĩato” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","To bajiri tojʉ, yucʉ́ manojʉ jʉarã masa cõro ñarirʉ̃mʉri, ñamiri quẽne tocãrãca ñamirine babecʉne ñacõarũgũñuju Jesús. To bajigʉ ñari, bʉto ñiorijayuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","To ĩ bajiro ĩacõari, ado bajiro rojose ĩre yirotiĩaboayuju vãtia ʉjʉ, Satanás: —Dios macʉne mʉ ñajama, adiari gʉ̃tarine pan godoveoya mʉ —ĩre yirotiboayuju, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","To bajiro Satanás ĩre ĩ yiboajaquẽne, —Yibeaja yʉ. Dios oca masa ĩna ucamasire ado bajiro gotiaja: “Bare rĩne ñamasuse me ñaja. Dios ocare mani cʉdisejʉa ñaja ñamasusema. ‘Bare ti manijare, rijarearʉarãja’ yire ti ñaboajaquẽne, Dios rijarere ĩ bojabetijama, rijabetirʉarãja. ‘Caticõa ñato’ yigʉ yimasigʉ̃ ñaami ĩ”, yigotiaja Dios oca masa ĩna ucamasire —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","To ĩ yiro bero, Jerusalénjʉ, Dios ĩ beseria maca ñamasuri macajʉ Jesúre ĩre ũmato vasuju Satanás. To ejacõari, Diore yirʉ̃cʉbʉoriavi joejʉ ĩre ũmato mʉjasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","To ĩre ũmato mʉjaejacõari, ado bajiro yiyuju Satanás: —Dios oca masa ĩna ucamasire ado bajiro gotiaja: “Ĩre moabosarimasa ángel mesare mʉre coderotirʉcʉmi Dios. Mʉ quediajama, ‘Gʉ̃ta joejʉ rocajeocõari, ĩ gʉbo jearomi’ yirã, mʉre boca ñiarʉarãma ĩna”, yigotiaja Dios oca. To bajiri Dios macʉne mʉ ñajama, adojʉne jatiquedi rujiaĩasaque mʉ —Jesúre yirotiboayuju Satanás. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","To bajiro ĩ yiboajaquẽne, Jesújʉama, ado bajiro ĩre yiyuju: —To bajiro mʉ yisere cʉdibeaja yʉ. “Dios ĩ yiriarore bajiro yʉre boca ñiarʉarãma ángel mesa” yigʉ, yʉ jatiquediĩajama, Dios ĩ bojabetire yigʉ yigʉja yʉ. Gajeye ado bajiro gotiaja Dios oca masa ĩna ucamasire: “‘Dios, “Yirʉcʉja” yiyumi’ yitʉoĩacõari, ‘To bajiro masu yirʉ yiyujari’ yimasirʉarã, mʉa tʉoĩarore bajiro mʉa yiajejama, quẽnabeaja”, yigotiaja Dios oca masa ĩna ucamasire —ĩre yiyuju Jesús, Satanáre. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","To bajiro ĩ yiro bero, gʉ̃taʉ ʉ̃mʉaricʉ joejʉ Jesúre ũmato vasuju Satanás quẽna. Tojʉ ũmato ejacõari, adi macarʉcʉro ñarimacari jediro ĩre ĩojeocõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ĩre ĩogajanocõari, ado bajiro ĩre yiyuju Satanás: —Yʉ rĩjorojʉa gʉsomuniari tuetucõari, “Yʉ ʉjʉ ñamasugʉ̃ ñaja mʉ” yʉre mʉ yirʉ̃cʉbʉojama, adi sita ñajedirore mʉre ĩsirʉcʉja yʉ —Jesúre ĩre yiyuju Satanás. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","To bajiro ĩ yise ñajare, ado bajiro ĩre cʉdiyuju Jesús: —Vasa mʉ. Ado bajiro gotiaja Dios oca masa ĩna ucamasire: “Mani ʉjʉ Dios sĩgʉ̃rene, ‘Yʉ ʉjʉ ñamasugʉ̃ ñaja mʉʉ’ ĩre yirʉ̃cʉbʉocõari, cʉdiroti ñaja”, yigotiaja Dios oca masa ĩna ucamasire —Satanáre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","To bajiro Jesús ĩ yisere ajicõari, vacoasuju Satanás yuja. Ĩ vato bero, Jesúre ejarẽmorã ejayujarã ángel mesa. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","“Tubiberiavijʉ tubibe ecocoajami Juan” yise quetire ajicõari, Galilea sitajʉ tudicoasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","To va, ĩ ya maca Nazaret vãme cʉti macajʉ eja, no cõro mene ñaboa, Capernaum vãme cʉti macajʉ ñagʉ̃ vasuju. Ti maca ñañuju ʉtabʉcʉra Galilea vãme cʉtira tʉjʉ, Zabulón sita, to yicõari, Neftal'i sita tʉ ñarimaca. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ti macajʉ Jesús ĩ ñajama, Diore gotirẽtobosarimasʉ Isa'ias vãme cʉtimasir'i, ado bajiro ĩ yiucamasire ñari, bajiyuju: ");
INSERT INTO bsnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Jordán vãme cʉtirisa jodejʉ Galilea vãme cʉtira ñaja. Tira tʉre ñaja Zabulón sita, to yicõari Neftal'i sita. Ti sitajʉre jud'io masa me ñaama, Diore masimena. Ĩnare gotimasiocõari, rojose ĩna tãmʉoborotire ĩnare yirẽtobosarocʉre cõarʉcʉmi Dios, ĩ bojarore bajiro ‘Quẽnaro yirã ñato’ yigʉ”, yiucamasiñumi Isa'ias. To bajiro ĩ yiucamasiriarore bajirone, ti sitajʉ ejayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti sitajʉ ejacõari, Dios ocare, ado bajise masare gotimasiocudisʉoyuju Jesús: —Diore rotibosarocʉ, ĩ rotisʉoroti mojoroaca rʉyaja. Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, yʉre ajitirʉ̃nʉña —masare yigotimasiocudisʉoyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cojorʉ̃mʉ, ʉtabʉcʉra Galilea vãme cʉtira tʉjʉ vacudigʉ vasuju Jesús. To vacʉjʉ, ĩañuju, Simón vãme cʉtigʉre, bero Pedro vãme cʉtirocʉre, ĩ bedi Andrére quẽne. Vai sĩarimasa ñañujarã ĩna. Bajiyucʉrire rearoderuu yiñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ĩna tʉ ejacõari, ado bajiro yiyuju Jesús: —Yʉ rãca vayá. Yucʉrema mʉa vai vejese ũnirene masa yʉre ĩna ajitirʉ̃nʉrotire gotimasiobosarimasa ñarʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","To ĩ yirirĩmarone, ĩna bajiyucʉrire cũ, ĩre sʉyacoasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","To yi varũtu vacʉne, gãjerã jʉarã ñarãre ĩnare jiyuju Jesús. Ĩna ñañujarã Santiago, ĩ bedi Juan rãca. Ĩna jacʉ Zebedeo rãca cũmuajʉ ĩna bajiyucʉrire siaquẽno sãñañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","To ĩ yisere ajicõarãjʉma, ĩna jacʉre, to yicõari ĩna cũmuare quẽne vaveocoasujarã, Jesúre sʉyana. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilea sitajʉ gotimasiocudiyuju Jesús. Tocãrãca macarirene Dios ocare ĩna buerivirijʉ sãjaejacõari, oca quẽnasere masare ĩnare gotimasioñuju. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, yʉre ajitirʉ̃nʉña”, ĩnare yigotimasioñuju. To yicõari, rijaye cʉtirãre ĩnare catioyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","To bajiri Jesús rijarãre ĩ catiosere masa ĩna gotibatojare, Siria sitana quẽne tire ajicõari, rijaye cʉtirãre juaejayujarã, “Jesús ĩnare catiato” yirã. Ĩna ʉsʉrijʉ vãtia sãñarãre quẽne juaejayujarã, “Vãtiare bureato Jesús” yirã. Rijaquedirãre, to yicõari, micarãre quẽne juaejayujarã, Jesúre catiorotirã. Ĩna ñaro cõrone ĩnare catioyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jesús ĩ vacudiro cõrone, jãjarã masa ĩre sʉyajojicõañujarã. Galilea sitana, Decápolis macana, Jerusalén macana, Judea sitana, to yicõari, Jordán vãme cʉtirisa gajejacatʉana quẽne ĩre sʉyarũgũñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","3","Jãjarã masa ĩna ñasere ĩacõari, burojʉ majaejayuju. To ĩ bajirone, ĩ buerã ĩ tʉ rẽjañujarã. Ĩna ejaro ĩacõari, ado bajiro ĩnare gotimasiosʉoyuju Jesús: —“Masimena ñari, mʉ ejarẽmose bʉto bojaja yʉa”, Diore ĩre yisẽnirũgũrãma, ĩ yarã ñarãma. To bajiri, rojose tãmʉoboarine, Dios tʉjʉ variquẽnarona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yucʉrire Dios ĩ bojabetire yicõari, tʉoĩasʉtiritiñarã quẽne, variquẽnarona ñarãma, berojʉ ĩna tʉoĩasʉtiritisere Dios ĩnare ĩ yirẽtobosaroti ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Masimena ñaja yʉa” yirã, Dios ĩ ejarẽmosere sẽnirũgũrã ñari, Dios ĩ goticatore bajirone variquẽnarʉarãma, adi macarʉcʉroana ʉjarã ĩna ñarotire Dios ĩnare ĩ yirẽtobosaroti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Gajeye rẽtoro Dios ĩ bojasere yirʉa tʉoĩarã quẽne, variquẽnarona ñarãma, “Yʉ bojasere yivariquẽnato” yigʉ, Dios, ĩnare ĩ ejarẽmose ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Gãjerãre ĩamaicõari, quẽnaro yirã quẽne, variquẽnarʉarãma, Dios quẽne, ĩnare ĩamaicõari, quẽnaro ĩ yiroti ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dios ĩ bojarore bajiro rĩne quẽnase tʉoĩarã variquẽnarãma ĩna quẽne, berojʉ Diore ĩarona ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Quẽnaro ñarotire oca quẽnorã quẽne, variquẽnarʉarãma, “Yʉ rĩa ñaama” Dios ĩ yiĩarona ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dios ĩ rotirore bajirone ĩna yise sʉorine gãjerãjʉa rojose ĩnare ĩna yiboajaquẽne, variquẽnarʉarãma, Ʉjʉ Dios yarã quẽnaro ĩ yirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yʉre mʉa ajitirʉ̃nʉse sʉorine gãjerã mʉare ajatud'icõari, “Rojorã ñaama” mʉare ĩna yisocaboajaquẽne, variquẽnarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","To bajiro mʉare ĩna yiboajaquẽne, bʉto variquẽnaña mʉa, “Berojʉ Dios tʉjʉ ejarã, quẽnase bʉjarʉarãja” yimasirã ñari. Mʉa rĩjoroana, Diore gotirẽtobosamasiriarãre quẽne, rojose mʉare ĩna yirore bajirone ĩnare quẽne rojose yimasiñujarã masa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Quẽna ado bajiro ĩ buerãre ĩnare gotiyuju Jesús: —Moa ñaja bare sãre. Mʉa barotire vaibʉcʉ rii catisere cũrãma, moa turãja mʉa, “Boarobe” yirã. Moa ti ocaboase ti ocabeticoajama, “Quẽna tudiocato” yirã, no bajiro yimasimenaja mʉa. To bajiri, tire reacõarãja, “Tire masa cʉdavʉoreacõato” yirã. Moa ocatʉjabetire bajiro mʉa bajijama, quẽnaja. Yʉre mʉa ajitirʉ̃nʉ tʉjabetijama, moa ocatʉjabetire bajiro bajirã ñarʉarãja mʉa. To bajiboarine, yʉre mʉa ajitirʉ̃nʉ tʉjajama, quẽna yʉre tudiajitirʉ̃nʉbetirʉarãja. Mʉa sʉorine quẽnaro yimenama gãjerã. To bajiri mʉare bojabetirʉcʉja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Quẽna ado bajiro ĩnare gotiyuju: —Rẽtiarojʉre busubatosere bajiro bajiroti ñaja mʉare. To bajiro mʉa bajijare, busubatose quẽnaro ti ruyurore bajirone mʉare ĩarʉarãma masa. Jairimaca buro joejʉ ñarimaca quẽnaro ti ruyurore bajirone mʉare ĩajedicõarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sĩabusuoriare jẽocõari, sotʉne tiare mubʉamenaja mʉa. Tiare jẽocõari, “Ñajediro ti vianare busuato” yirã, vecajʉ jeorãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tire bajirone quẽnaro yiya mʉa, “‘Quẽnaro yirã ñaama, Diore ajitirʉ̃nʉrã ñari’ yimasiato masa jediro” yirã, to yicõari, “Mani jacʉ õ vecagʉre quẽnase ĩre yirʉ̃cʉbʉoato ĩna” yirã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Quẽna ado bajiro ĩ buerãre ĩnare yiyuju Jesús: —“Moisés ñamasir'ire Dios ĩ roticũmasirere, to yicõari, Diore gotirẽtobosarimasa ĩna gotimasiomasirere reagʉ vayumi Jesús”, yitʉoĩabesa mʉa. Tire reagʉagʉ me vadicajʉ yʉ. “Tire quẽnaro riojo ajimasiato” yigʉ, vadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Riojo mʉare gotiaja yʉ. Moisére Dios ĩ roticũmasire, to yicõari, Diore gotirẽtobosarimasa ĩna gotimasiore ñajediro ñacõarũgũrʉaroja. Adi macarʉcʉro jediroto rĩjoro, cojo vãme godocʉtibetirʉaroja. Ñajediro Dios ĩ gotiriarore bajirone bajirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","No bojagʉ, Moisére Dios ĩ roticũmasire ñamasuse me ti ñaboajaquẽne, tire cʉdibecʉ, “No yibeaja, mani cʉdibetijaquẽne” yigotimasiogʉ̃ ñagʉ̃mi quẽnabecʉ. Ʉjʉ Dios yarã quẽnaro ĩ yirã rãcagʉ ñamasugʉ̃ me ñarʉcʉmi ĩ ũgʉ̃ma. No bojagʉ Moisére Dios roticũmasirere cʉdicõari, “Tire mani cʉdijama, quẽnaja” yigotimasiogʉ̃ ñagʉ̃mi quẽnagʉ̃. To bajiri Ʉjʉ Dios yarã quẽnaro ĩ yirã rãcagʉ ñamasugʉ̃ ñarʉcʉmi ĩjʉama. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Riojo mʉare gotiaja yʉ. Moisére Dios ĩ roticũmasire gotimasiorimasa, fariseo masa quẽne, quẽnaro ĩna yiboase rẽtoro quẽnaro mʉa yibetijama, Ʉjʉ Dios yarã me ñarʉarãja mʉa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Dios ĩ rotimasire gotimasiorimasa sʉorine ado bajise ajirũgũaja mʉa: “Sĩabesa. Ĩ sĩajama, ĩ sĩase vaja ĩre sĩaroti ñaja”, yimasirere ajirũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉma, ado bajiro mʉare gotirẽmoaja: Jũnisinire quẽne rojose ñaja. No bojagʉ gãjire jũnisinigʉ̃ ĩ jũnisinise vaja rojose ĩre yiroti ñaja. No bojagʉre gãjire jũnisinicõari, rujajine, “Vaja magʉ̃ ñaja mʉ” ĩre yigʉma, rujajine ĩ yise vaja, “Rojose tãmʉorʉcʉmi”, ĩre yirʉarãma ʉjarã. No bojagʉre, gãjire jũnisinicõari, ĩre tud'igʉrema, ĩ tud'ise vaja, jeame yatibetimejʉ ĩre cõacõarʉcʉmi Dios, mʉare yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tire masirã ñari, gajeyere quẽne tʉoĩaña mʉa. Diore rʉ̃cʉbʉorã soemʉoriajʉ vacʉne, “Rojose ĩre yibʉ yʉ” mʉa yitʉoĩabʉjajama, Diore rʉ̃cʉbʉorã ĩre mʉa soemʉoĩsirotire soemʉobeja maji. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Tire cũcõari, rojose mʉa yir'i tʉjʉre vasa, ĩre oca quẽnoroana. Ĩre oca quẽnogajanocõari, Diore soemʉoĩsiroana tudivaja yuja, mʉare yaja yʉ. “Rojose mʉa yir'ire oca quẽnocõari rĩne, Diore oca quẽnomasirʉarãja”, mʉare yigʉ yaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gajeye ado bajiro bajiaja: Gãjire rojose mʉa yijama, oca quẽnorimasʉ tʉjʉ mʉa ejaroto rĩjoro, ĩ rãca oca quẽnoroti ñaja mʉa jʉarãjʉne. Oca quẽnorimasʉ tʉ ejamenane, mʉa oca quẽnobetijama, masare coderimasʉre juarotirʉcʉmi, mʉare. Ĩjʉa, mʉare tubiberʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Riojo mʉare gotiaja yʉ. Rojose mʉa yire vaja mʉa vaja yibetijama, budimenaja mʉa. Tire bajirone bajirʉaroja Dios ĩ vaja sẽnirirʉ̃mʉ ejaroto rĩjorojʉa, rojose mʉa yir'ire ĩre oca quẽnoña. Mʉa gãmerã oca quẽnobetijama, Dios ĩ vaja sẽnirirʉ̃mʉ rojose tãmʉotʉjabetiriarojʉ mʉare cõarʉcʉmi, tudibudire manojʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Quẽna gajeye ado bajiro yiyuju Jesús: —Dios ĩ rotimasire gotimasiorimasa sʉorine ado bajisere ajirũgũaja mʉa: “Gãji manajo rãca ajerio cʉtibesa”, yirere ajirũgũaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yʉma, ado bajiro mʉare gotirẽmoaja: Rõmio, no bojagore yirʉa tʉoĩare quẽne rojose ñaja. No bojagʉ, rõmiore yirʉa tʉoĩagʉ̃, ĩ tʉoĩasene sore ajerio cʉtigʉ yigʉmi ĩ ũgʉ̃ma, mʉare yaja yʉ —yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Quẽna ado bajiro gotimasioñuju Jesús: —“Yʉ cajea riojojacatʉaga sʉorine ĩabojacõari, rojose yibʉ yʉ” mʉa yitʉoĩajama, tiare ãmirocacõaña. Coja cajea mʉare ti manijama, quẽnabetoja. To bajiboarine, jʉajʉne caje cʉticõari, mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Yʉ ãmo sʉorine rojose yibʉ yʉ” mʉa yitʉoĩajama, ti ãmore jatarocacõaña. Mʉare cojo ãmo ti manijama, quẽnabetoja. To bajiboarine jʉaãmo rãca mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Gajeye ado bajiro gotiaja Moisére Dios ĩ roticũmasire: “No bojagʉ ĩ manajore ĩ rocarʉajama, ‘Mʉre rocagʉ yaja’ yise papera ucacõari, sore ĩsiroti ñaja”, yigotiaja Dios ĩ rotimasire. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉma, ado bajiro mʉare gotiaja: Ĩ manajo gãji rãca so ajeri cʉtibetiboajaquẽne, sore ĩ rocajama, bʉto rojose sore yigʉ yigʉmi ĩ ũgʉ̃ma. To bajiro ĩ yise sʉorine, gãji rãca so manajʉ cʉtijama, Diojʉama, “So manajʉ me rãca ajeri cʉtiamo”, yiĩagʉ̃mi. Ʉ̃mʉre quẽne, gãji ĩ rocario rãca ĩ manajo cʉtijama, “Ĩ manajo me rãca ajerio cʉtiami”, yiĩagʉ̃mi Dios. To bajiri mʉa manajoa gãjerã rãca ĩna ajeriarã cʉtibetijama, ĩnare reabetiroti ñaja —ĩ buerãre yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Quẽna gajeye ado bajise ĩnare gotiyuju Jesús: —Dios ĩ rotimasire gotimasiorimasa ado bajiro mʉare ĩna gotimasirere ajirũgũaja mʉa: “No bojase mʉa yirotire mʉa yirʉajama, ‘Yimasucõarʉarãja yʉa. Tire yʉa yibetijama, Dios, rojose yʉare yibogʉmi’ yirã, ‘Yirʉarãja’ mʉa yirore bajirone yiba”, yirere ajirũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","To bajiri cojojirema mʉa gotirore bajiro yiterã ñari, ado bajiro tʉoĩavasoaboaja mʉa: “‘Dios vãme rãca riojo yaja’ mani yijama, rojose manire yibogʉmi” yirã ñari, “Dios vãmere gotivasoarã yaja yʉa” yirã, gaje vãmere õ vecayere gotiboaja mʉa. To bajiro yimena quẽne, gaje vãme rãca, macarʉcʉroayere yiboarãja. Tire yiterã, Jerusalén vãme cʉti macayere yiboarãja. To bajiro mʉa yibetijama, gaje vãme rãca, mʉa rʉjoare quẽne, to yicõari, mʉa joare quẽne yiboarãja mʉa, ñise, botise mʉa joare godoveomasimena ñaboarine. Ti ũnire yibetiroti ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Yirʉarãja” yirã quẽne, “Yirʉarãja” yi, “Yibetirʉarãja” yirã quẽne, “Yibetirʉarãja” yicõa tʉjasa. “Socarã me yaja yʉa” yirã, gajeye mʉa gotirẽmojama, vãtia ʉjʉ ejarẽmose rãca gotirẽmorã yirãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Quẽna gajeye ado bajiro ĩ buerãre ĩnare gotiyuju Jesús: —Dios ĩ rotimasire gotimasiorimasa ado bajiro mʉare ĩna gotimasirere ajirũgũaja mʉa: “Mʉ cajeare ĩ jajama, mʉjʉa quẽne, ĩ cajeare jaroti ñaja. Mʉ gujiare ĩ jajeajama, mʉjʉa quẽne, ĩ gujiare jajearoti ñaja”, yimasirere ajirũgũaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yʉjʉama, ado bajiro mʉare gotiaja: Rojose mʉre yigʉre gãmebesa. Ado bajirojʉa yiya: Cojojacatʉa, mʉ vayujuare ĩ jajama, gajejacatʉare quẽne ĩre jarotiya. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gãji, mʉre ocasãrʉ, “Rojose yʉre yibʉ mʉ. To bajiri, rojose mʉ yise vaja mʉ sudirore yʉre ĩsiña. Mʉ ĩsibetijama, mʉre ocasãrʉcʉja yʉ” ĩ yijama, ĩre ĩsiña. To yicõari, gajease quẽnabʉsariase ĩre ĩsirẽmocõaña. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sĩgʉ̃ ĩ gajeyeũnire mʉre ũmaroticõari, “Adone cũcõaña mʉ” mʉre ĩ yiboajaquẽne, mʉ vadiriacũcõrone gãme varẽmocõarijʉ ĩre cũbosaya. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No bojarã mʉre gajeyeũni sẽnirãre ĩsiña. Sĩgʉ̃, gajeyeũni magʉ̃ ñari, “Yʉre vasoaya” mʉre ĩ yijama, ĩre vasoaya —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Quẽna ado bajiro ĩnare yiyuju Jesús: —Dios ĩ rotimasire gotimasiorimasa ado bajiro mʉare ĩna gotimasirere ajirũgũaja mʉa: “Mʉa babarãre quẽnaro ĩamaiña. To yicõari, mʉare ĩaterãre ĩateya”, yimasirere ajirũgũaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yʉjʉama, ado bajiro mʉare rotiaja: Mʉare ĩaterãre quẽne ĩamaiña. Mʉare rojose yirãre quẽne quẽnaro ĩna bajirotire yirã, Diore ĩnare sẽnibosaya mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","To bajiro mʉa yijama, “Mani jacʉ õ vecagʉ rĩa ñaja yʉa” yiĩorã yirãja mʉa, ĩ bojarore bajiro yirã ñari. Masa jedirore quẽnaro yirũgũgʉ̃mi Dios. Ĩre cʉdimenare quẽne quẽnaro yirũgũgʉ̃mi. Ĩ ñagʉ̃mi quẽnarãre, rojorãre quẽne, “Busuato” yigʉ, muijure busurotigʉ, to yicõari, ocore quẽne quedirotigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉare ĩamairã rĩne mʉa ĩamaijama, ¿“Quẽnaro yaja mʉa” mʉare yi, vaja yigʉjari Dios? Yibecʉmi. Rojorã, ʉjʉre gãjoa sẽnibosarimasa, ĩnare ĩamairã rĩrene ĩamairũgũama ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉa tʉ ejarãre mʉare bajiro bajirã rĩrene mʉa sẽnijama, ¿“Quẽnaro yaja” mʉare yi, vaja yigʉjari Dios? Yibecʉmi. Diore ajimena quẽne, ĩnare ĩamairã rĩrene ĩamairũgũama ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","To bajiri mʉajʉama, mani jacʉ õ veca ñagʉ̃ quẽnase rĩne ĩ yirore bajiro yirã ñaña mʉa. Mʉare rojose yirãre quẽne, mʉare bajiro bajirã mere quẽne ĩamaicõari, quẽnaro yiroti ñaja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Quẽna ado bajiro ĩ buerãre ĩnare yiyuju Jesús: —Quẽnaro mʉa yijama, “‘Quẽnaro yama ĩna’ yato gãjerã” yirã me, quẽnaro yiya mʉa. Masa ĩna ĩaro rĩjorojʉa rĩne, “‘Quẽnaro Diore cʉdirã ñaama’ yʉare yiĩato ĩna” yirã, mʉa yiĩoboajama, ñie vaja bʉjamenaja mʉa, õ vecajʉ mani jacʉ Dios tʉjʉ ejarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sĩgʉ̃ri, “Quẽnarã ñaja yʉa” yiboarine, ĩna yirore bajiro yirã me ñarãma ĩna. Ado bajirojʉa yirã ñarãma: Maioro bajirãre ejarẽmorã, ĩnare ĩna ĩsijama, masa jedirore gotibatorãma. Dios ocare ĩna buerivijʉre rẽjarãre quẽne, jãjarã masa ĩna vati maarijʉre quẽne ñacõari, ĩnare gotibatorãma, “‘Quẽnarã ñañuma’ yʉare yiĩarʉ̃cʉbʉoato” yirã. To bajiro ĩna yirore bajiro yibesa mʉa. Riojo mʉare gotiaja yʉ. To bajiro ĩna yise vaja masa ĩnare ĩna rʉ̃cʉbʉosene jẽre vaja bʉjacõama ĩnama. Ñie gajeye bʉjarẽmobetirʉarãma, Dios tʉjʉre. Ĩnare masa ĩna rʉ̃cʉbʉoboajaquẽne, Diojʉama, ĩnare rʉ̃cʉbʉobetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉajʉama, maioro bajirãre mʉa ejarẽmojama, “‘Quẽnaro yirã ñaama ĩna’ yʉare yiĩato” yirã me, ĩnare ejarẽmoña. To yicõari, mʉa baba ñamasugʉ̃re quẽne, “To bajiro yibʉ yʉa” yigotimenane, ĩnare ejarẽmoña. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","To bajiro maioro bajirãre quẽnaro mʉa yijama, masa ĩabetore bajiro yirã yirʉarãja mʉa. To bajiro mʉa yijama, mani jacʉ, masa ĩabetojʉ ĩamasigʉ̃ ñari, quẽnaro mʉa yise vaja, quẽnaro mʉare yirʉcʉmi —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Sĩgʉ̃ri, “Quẽnarã ñaja yʉa” yiboarine, ĩna yirore bajiro yirã me ñarãma ĩna. Ado bajiro yirã ñarãma: Diore ĩna sẽnijama, Dios ocare ĩna buerivirijʉ rʉ̃gõcõari, sẽnirãma. To yicõari, jãjarã masa ĩna vati maarijʉre quẽne ñacõari, Diore ñagõrãma. To bajiro yirãma, masa ĩna ĩarʉ̃cʉbʉosere bojarã ñari. To bajiro ĩna yise vaja masa ĩna ĩarʉ̃cʉbʉosere jẽre bʉjacõarãma ĩna. Ñie gajeye bʉjarẽmobetirʉarãma, Dios tʉjʉre. Ĩnare masa ĩna ĩarʉ̃cʉbʉoboajaquẽne, Diojʉama, ĩnare ĩarʉ̃cʉbʉobetirʉcʉmi. To bajiri, mʉama, Diore mʉa ñagõjama, ĩna yirore bajiro Diore ñagõbesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉama, Diore mʉa sẽnijama, gãjerã mʉare ĩna ĩabeto sẽnirʉarã ñari, mʉa ya sõajʉ tubibesãjacõari, ĩre sẽniña. To bajiro yicõari, mani jacʉ ruyubecʉre ĩre sẽniña. Masa ĩna masibeto Diore mʉa sẽnijama, to bajiro mʉa yise vaja, mʉare vaja yirʉcʉmi mani jacʉ, masa ĩna ĩabetiboajaquẽne mani tʉoĩasere masigʉ̃ ñari —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Dios yarã me ñarã, ĩna rʉ̃cʉbʉogʉre sẽnirã, cojoji me sẽniajerãma ĩna, “Cojoji me tire mani sẽnijama, manire ajigʉmi” yitʉoĩarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ĩnare bajiro yibesa mʉama. Mʉa bojase mʉa sẽniroto rĩjorojʉne jẽre masicõagʉ̃mi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","To bajiri Diore mʉa sẽnijama, ado bajiro sẽniña: “Yʉa jacʉ, masa ñajediro, ‘Quẽnarẽtogʉ̃ ñaja mʉ’ mʉre yirʉ̃cʉbʉoato ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Adi macarʉcʉroana, mʉ bojase rĩne yʉa yirotire tʉoĩa yurũgũaja yʉa. Jẽre õ vecajʉ mʉ ñarojʉ mʉ yarã mʉ rotirore bajirone yiñarãma. To bajiri adi macarʉcʉrojʉre quẽne mʉ rotirore bajiro rĩne yirere bojaja yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Adirʉ̃mʉ yʉa barotire cõaña mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","‘Rojose yʉa yisere masirioya’ mʉre yisẽniaja yʉa, yʉare rojose yirãre quẽne masiriorã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Rojose yʉa yirotire masigʉ̃ ñari, ‘Tire yibeticõato ĩna’ yigʉ, yʉare matabosaya”. To bajiro Diore mʉa sẽnijama, quẽnaja —ĩnare yiyuju Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Mʉare rojose yirãre mʉa masiriojama, mani jacʉ õ vecagʉ rojose mʉa yisere masiriorʉcʉmi ĩ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gãjerãre rojose ĩna yisere mʉa masiriobetijama, mani jacʉ quẽne rojose mʉa yisere masiriobetirʉcʉmi —ĩnare yiyuju Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Sĩgʉ̃ri, “Quẽnarã ñaja yʉa” yiboarine, ĩna yirore bajiro yirã me ñarãma. Bare bamenane Diore ĩna sẽnijama, “ ‘Sʉtiritiama’ yiĩato ĩna” yirã, sʉtiritirãre bajirã ñaĩorãma ĩna. To bajiro yirãma, “‘Ĩna, Diore rʉ̃cʉbʉorã, bare bamena bajirãma’ masa yʉare yiĩato” yirã. To bajiro ĩna yirore bajiro yibesa mʉama. Riojo mʉare gotiaja yʉ. To bajiro ĩna yise vaja masa ĩnare ĩna rʉ̃cʉbʉosene jẽre vaja bʉjacõama ĩnama. Ñie gajeye bʉjarẽmobetirʉarãma, Dios tʉjʉre. Ĩnare masa ĩna rʉ̃cʉbʉoboajaquẽne, Diojʉama, ĩnare rʉ̃cʉbʉobetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Mʉajʉama, Diore rʉ̃cʉbʉorã, bare bamenane ĩre mʉa sẽnijama, sʉtiritirãre bajiro bajibesa. Mʉa yirũgũrore bajiro mʉa joare quẽne quẽnaro siroa, riogare quẽne quẽnaro coe, yiya, “Masa yʉare ĩacõari, bare yʉa babetire masibeticõato” yirã. To bajiro mʉa yijama, mani jacʉ gãjerã ĩna ĩamasibetiboajaquẽne, ĩamasigʉ̃ ñari, mʉare vaja yirʉcʉmi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Adi macarʉcʉrojʉ, “Gajeyeũni jairo juarẽocũrʉarãja” yirã me moaña mʉa. Gajeyeũni mʉa juarẽocũboasere barearʉarãma gajeyeũni barimasa. Gajeyema, boarʉaroja ti. To yicõari, gajeyerema juarudirʉarãma juarudirimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ado bajirojʉa yirã ñaña mʉa: “Õ vecajʉ mani jacʉ tʉjʉ ĩ bojarore bajiro quẽnaro mani yise vaja, quẽnaro manire yirʉcʉmi” yitʉoĩacõari, quẽnaro yirã ñaña. Õ vecayejʉarema, quẽnaro mʉare Dios ĩ yisere barearã manama. Boabetirʉaroja tima. To yicõari juarudirimasa quẽne, ejabetirʉarãma. Dios manire quẽnaro ĩ yise jedibetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mʉa vaja tarere mʉa quẽnocũ vajama, ti rione tʉoĩarejaicõa ñarãja mʉa. Tire yimenane, “Quẽnaro yʉa yise vaja õ vecajʉ vaja tacũrã yaja” yitʉoĩacõari, quẽnaro yirũgũña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Mʉa caje quẽnaro ti ruyujama, “Tine ñaja quẽnamasuse”, yiĩamasiaja mʉa. To bajiboarine, mʉa caje quẽnaro ti ruyubetijama, quẽnabetire ĩacõari, mʉa masune, “Ti ñaja quẽnamasuse”, yisocarʉarãja mʉa. Tire bajiro bajiaja mʉa tʉoĩase quẽne. Dios ĩ bojarore bajiro quẽnaro mʉa tʉoĩajama, ñajediro quẽnaro riojo tʉoĩamasirʉarãja mʉa. Ĩ bojabetire mʉa tʉoĩajama, “Riojo tʉoĩarã ñaja” yisocañarã rĩne, bʉtobʉsa tʉoĩamasimena ñacoarʉarãja mʉa. To bajiri, quẽnabetire ĩacõari, “Mani masune, ‘Ti ñaja quẽnamasuse’ yisocarobe” yirã, Dios ĩ bojarore bajiro quẽnaro tʉoĩaña mʉa —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Quẽna ado bajiro ĩnare gotiyuju Jesús: —Diore yirʉ̃cʉbʉorãma, adi macarʉcʉroayere bʉto bojatʉoĩamenama, “Diojʉa ñaami ñamasugʉ̃” yitʉoĩarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","To bajiri, “Dios ñaami ñamasugʉ̃” yitʉoĩarã ñari, ĩre cʉdirãma, adi macarʉcʉrojʉre mʉa bajirotire tʉoĩarejaibesa mʉa. “¿No bajiro bʉjacõari, bare ba, idi, sudi sãña, yicatiñarãti yʉa?”, yitʉoĩarejaibesa. Quẽnamasuse mani ʉsʉre, to yicõari, mani rujʉre manire ĩsiñumi Dios. To bajiri mani baroti, mani idiroti, to yicõari sudi mani sãñarotire quẽne cõarũgũrʉcʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minia ĩna bajisere tʉoĩaña mʉa. Ĩna otebetiboajaquẽne, to yicõari, bare ĩna juarẽocũbetiboajaquẽne, Dios, ĩnare bare cõarũgũami. “Miniare quẽne ĩamaigʉ̃ ñari, manire roque rẽtoro maigʉ̃mi”, ¿yimasibeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Adi macarʉcʉrojʉre ñarã yoaro catirʉarãja” mʉa yitʉoĩarejaiboase, “Yoarobʉsa catiato” yiro, mʉare ejarẽmomasibeaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sudi sãñarʉa tʉoĩarejaibesa. Go bʉcʉasere tʉoĩaĩasaque mʉa: Moabeti, to yicõari, sudi sãñarʉa tʉoĩarejaibeaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","To bajiboarine, Ʉjʉ Salomón ñamasir'i gajeyeũni jaigʉ ĩ ñaboajaquẽne, quẽnase ĩ sudi sãñamasire rẽtoro quẽnase ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gore bʉto quẽnase ñarotirũgũami Dios. Quẽnase ñaboarine, yoaro mene sĩnicoatoja. Ti sĩniro ĩacõari, tire tĩarãma masa, bare roariajaʉjʉre. To bajiri yoaro catise me ti ñaboajaquẽne, tire quẽnorũgũgʉ̃mi Dios. Go rẽtoro manire maigʉ̃mi Dios. To bajiri, “Manire sudi cõarʉcʉmi”, yimasiroti ñaja. “To bajirone yigʉmi Dios”, yiajitirʉ̃nʉbetibʉsarã ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","To bajiri, “¿No bajiro bʉjacõari, bare ba, idi, sudi sãña, yicatiñarãti yʉa?”, yitʉoĩarejaibetiroti ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dios yarã me ñarãma, tire bʉto tʉoĩarejairãma. Manijʉarema, mani jacʉ õ vecagʉ ñagʉ̃mi, “Ti rʉyaja, ĩnare” yimasigʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","To bajiri, “Ʉjʉ Dios yarã, quẽnaro ĩ yirã ñaja mani. Ĩ bojarore bajiro quẽnase rĩne yirʉarãja”, yitʉoĩarũgũña mʉa. To bajiro mʉa yijama, adi macarʉcʉroaye mʉa cʉobetire bʉjarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","To bajiro ti bajijare, adirʉ̃mʉ mʉa bajise rĩne tʉoĩaroti ñaja. Busiyʉ mʉa bajirotire tʉoĩarejai rĩjoro cʉtibesa mʉa. Tocãrãcarʉ̃mʉrine ricati bajirũgũaja —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Quẽna ado bajiro ĩnare yiyuju Jesús: —“Rojose yirã ñaama. To bajiro yirã ñari, rojose tãmʉorʉarãma”, gãjerãre ĩnare yiĩabesebesa. To bajiro mʉa yijama, “Rojose yirã ñaama”, mʉare yiĩaromi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","To bajiri, gãjerãre rojose ĩna yise sʉorine “Rojose tãmʉorʉarãja” mʉa yiĩacõĩajama, mʉare ĩ beserirʉ̃mʉjʉ, “Rojose yirã ñaama”, mʉare yiĩacõĩarʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Gajeyerema, ado bajiro yirãre bajiro yaja mʉa: Gãji bʉto rojose ĩ yibetiboajaquẽne, “Mʉ cajeare sũjuriroaca sãñaja. Tijʉacare ãmirocato” yirãre bajiro yaja mʉa. Tire bʉto ĩatirʉ̃nʉrã ñaboarine, mʉa cajeajʉre jairisũjuro sãñarijaʉre tijaʉre, “Ãmirocaya” yimasibeaja mʉa, “Bʉto rojorã ñaja yʉa” yitʉoĩamasimena ñari. Mʉa rãcagʉ ĩ yisejʉare ĩacõari, “Riojo tʉoĩabeaja mʉ. ‘Quẽnasejʉare tʉoĩavasoaya’ yirã, riojo mʉre gotirʉarãja” yigotirã ñaboarine, “Adi ñaja quẽnase. Tijʉa ñaja rojose”, yimasimenaja, ĩ rẽtoro rojose yirã ñari. “Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojorã ñaja mʉa. “Bʉto rojorã ñaja yʉa” mʉa yitʉoĩamasiro berojʉ, mʉa rãcagʉre ejarẽmomasirãja mʉa, “Quẽnaro riojo ñato ĩ” yirã —ĩ buerãre ĩnare yimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Quẽna ado bajiro ĩnare yiyuju Jesús: —Bʉto quẽnase ñaja Dios oca. Ĩ yere ajiterãre gotimasiobetirʉarãja mʉa. “Bare quẽnase ti ñaboajaquẽne, yaia ĩna batese ti ñajama, manire jũnisinicõari, cũnisurerearʉarãma ĩna” yirã, ĩnare ecabeaja mʉa. To yicõari, mʉa ye jairo vaja cʉtise, perla vãme cʉtisere yesea vatoajʉ reacũbeaja mʉa. To bajiro mʉa yijama, mʉa reacũsere bojamena ñari, tire cʉdavʉoreacõarʉarãma ĩna. To bajirone bajiaja Dios oca quẽnasere ajiterãrene mʉa gotimasiorʉajaquẽne. To bajiri, ĩna ajirʉabetire ĩamasicõari, ĩnare gotimasiomasibetirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Quẽna ado bajiro ĩnare yiyuju Jesús: —Diore mʉa sẽnijama, cõarʉcʉmi. Ĩre sẽnicõari, mʉa macajama, bʉjarʉarãja mʉa. Sĩgʉ̃ no bojase ĩre ti rʉyajama, gãji ya vijʉ ejacõari sãjarʉ, sẽniĩagʉ̃mi. Ĩ sẽniĩajare, ĩre sãjaroticõari, ĩre ejarẽmogʉ̃mi. To bajirone bajiaja Diore sẽnirãre quẽne. Ĩre mʉa sẽnisere ajicõari, quẽnaro mʉare yiejarẽmorʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Dios manire ejarẽmorʉcʉmi” yitʉoĩarã ñari, ĩre ĩna sẽnisere ĩnare cõarʉcʉmi. Ĩna macajaquẽne, bʉjarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Bare bojaja yʉ” mʉa macʉ ĩ yisẽnijama, ¿gʉ̃tane ĩsirãtique mʉa? Ĩsimenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Vai bojaja yʉ” mʉa macʉ ĩ yisẽnijama, ¿ãña bar'i merene ĩsirãtique mʉa? Ĩsimenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Diore bajiro quẽnase yirã me ñaboarine, mʉa rĩare quẽnaro yaja mʉa. “To bajiro yirã ñaja” yimasirã ñari, “Mani jacʉ õ vecagʉre mani sẽnijama, quẽnaro masu manire yirʉcʉmi”, yimasiaja mani —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Quẽna ado bajiro ĩnare yiyuju Jesús: —Gãjerã quẽnaro mʉare ĩna yisere bojaja mʉa. Tire bojarã ñari, quẽnaro ĩnare yiya mʉajʉa quẽne. To bajirone Moisés ñamasir'ire roticũmasiñuju Dios. To yicõari Diore gotirẽtobosarimasa ĩna ucamasire quẽne, to bajirone yaja —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quẽna ado bajiro ĩnare yiyuju Jesús: —Ʉjʉ Dios yarã quẽnaro ĩ yirã mʉa ñarʉajama, eyabetisoje, to yicõari, eyabeti maare vanare bajiro josarʉarãja mʉa. Ti josaboajaquẽne, ĩ yarã ñaña mʉa. Ĩ yarã mejʉama, jãjarã ñarãma. Gaje soje eyarisojere sãjacõari, to yicõari, eyari maa vanare bajiro josabetirʉarãma ĩnama. Ti josabetiboajaquẽne, rojose tãmʉotʉjabetiriarojʉ varona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Eyabetisoje, to yicõari, eyabeti maare vanare bajiro josarʉarãma, Ʉjʉ Dios yarã quẽnaro ĩ yirãma. Ti josaboajaquẽne, Dios tʉjʉ ejacõari, ĩ rãca quẽnaro ñacõarũgũrʉarãma. Jãjarã me ñarʉarãma ĩnama —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Quẽna ado bajiro ĩnare yiyuju Jesús: —“Ʉjʉ Dios yarã quẽnaro ĩ yirã ñari, ĩre gotirẽtobosarimasa ñaja yʉa quẽne”, yitorimasa ñarãma sĩgʉ̃ri. To bajiro ĩna yitosere quẽnaro ajimasiña mʉa. Tire mʉa ajimasibetijama, to bajiro mʉare ĩna yitose ñajare, Dios yere mʉa ajirũgũboasere masiriticoarʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ĩna gotimasiose sʉorine, “Quẽnarã ñaama” yimenane, ĩna bajire cʉtisejʉare ĩasʉoya mʉa. Ti rica cʉtise sʉorine yucʉ́re ĩamasiaja mani. Ʉye juaroana, vãtijota yucʉ́rijʉre macamenaja mani. Quẽnase bare higos vãme cʉtire juaroana, vidirojʉ ñaricʉ savajotaʉjʉre macamenaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","To bajiri, yucʉ́ vãnʉquẽnaricʉma, quẽnase rica cʉtiroja. Vãnʉbetijʉama, quẽnabetiarine rica cʉticõaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","To bajiri, yucʉ́ vãnʉricʉ, “Quẽnase rica cʉtiricʉ ñaja” mani yiboaricʉne, quẽnabeti rica cʉtibetoja. To yicõari, vãnʉbeti, “Quẽnabeti rica cʉtiricʉ ñaja” mani yiboaricʉne, quẽnase rica cʉtibetoja. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tocãrãca yucʉ́rire, vãnʉbeticõari, rica quẽnabeti yucʉ́rire quẽacõari, jeamejʉ soereacõare ñaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","To bajiri yucʉ́ ricare ĩacõari, “Quẽnaricʉ ñaja ti. Quẽnabeti ñaja adima” mani yimasirore bajirone, “Diore gotirẽtobosarimasa ñaja yʉa” yirã, ĩna yisere ĩacõari, “Quẽnarã ñaama ĩna. Quẽnamena ñaama ãnoa”, yimasirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Quẽna ado bajiro ĩnare yiyuju Jesús: —Ñajediro, “Yʉa ʉjʉ ñaja mʉ” yʉre yirã me ñarʉarãma yʉ jacʉ yarã, quẽnaro ĩ yironama. Yʉ jacʉ ĩ bojarore bajiro yirã rĩne ñarʉarãma õ vecajʉ varonama. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Masare Dios ĩ beserirʉ̃mʉ ti ejaro, jãjarã ado bajiro yiboarʉarãma: “Yʉa ʉjʉ, yʉare mʉ rotijare, mʉre gotirẽtobosacajʉ yʉa. Yʉare mʉ rotijare, masa ʉsʉrijʉ sãñarãre vãtiare bureacajʉ yʉa. To yicõari, yʉare mʉ rotijare, jairo ĩaĩañamani yiĩocajʉ yʉa”, yʉre yiboarʉarãma ĩna, socarãne. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","To bajiro ĩna yiboajaquẽne, ado bajiro ĩnare yirʉcʉja yʉ: “Tire mʉare yirotibeticajʉ yʉ. Mʉare masibeaja. ¡Vasa! Rojose yirã ñaja mʉa”, ĩnare yirʉcʉja yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Quẽna ado bajiro ĩnare yiyuju Jesús: —Mʉare yʉ gotimasiosere ajicõari, yʉ rotirore bajiro yigʉ, quẽnaro tʉoĩagʉ̃ ñagʉ̃mi ĩ ũgʉ̃ma. Ĩ ñagʉ̃mi gʉ̃tajãijʉ gojeri coaejocõari, botari rʉ̃gõcõari, vi bʉagʉre bajiro bajigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Vi ĩ bʉaro bero, bʉto oco quediroja. Bʉto mino vatoja. To bajicõari, riaga jaicoatoja. Ti vijʉ ti jaiejacoaboajaquẽne, juriaquedibetoja ti vi. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yʉre ajiboarine, yʉ rotirore bajiro yibecʉjʉa ñagʉ̃mi sita vajarojʉ vi bʉagʉre bajiro bajigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ti vi ĩ bʉaro bero, bʉto oco quediroja. Bʉto mino vatoja. To bajicõari, riaga jaicoatoja. Ti vijʉre ti jaiejarone, yoaro mene juriaquedicoatoja —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","To bajiro Jesús ĩnare ĩ yigotimasioro bero, Dios ĩ rotimasire gotimasiorimasare bajiro me, ʉjʉre bajiro bojonebecʉne quẽnaro ĩ gotimasiojare, ajiĩañamani ĩ gotise ti ñajare, no yimasibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Burojʉ ñar'i, Jesús ĩ rojaejarone, jãjarã masa ĩre sʉyayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","To ĩna bajirone, sĩgʉ̃ gase boagʉ Jesúre vacãnamuacõari, ĩ rĩjorojʉa gʉsomuniari tuetuejayuju, ĩre rʉ̃cʉbʉogʉ. To yicõari, ado bajiro Jesúre ĩre yiyuju: —Yʉ ʉjʉ, yʉ cãmire mʉ yarʉajama, yaya —yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","To bajiro ĩre ĩ yisere ajicõari, —Mʉ cãmire yarʉcʉja yʉ —ĩre yigʉne, ĩre moaĩañuju Jesús. To bajiro ĩ yirirĩmarone, ĩ cãmi ĩre yaticoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","To ĩre yigajanocõari, gãjerãre ĩre gotirotibesuju Jesús. To bajiro ĩre yicõari, ado bajiro ĩre yiyuju: —Yucʉacane paire mʉ rujʉre ĩoaya. To yigʉne, Moisére Dios ĩ roticũmasiriarore bajirone vaibʉcʉrã ecariarãre sĩacõari, paire ĩsima, Diore rʉ̃cʉbʉogʉ. To mʉ yisere ĩacõari, “Caticoasumi”, yirʉarãma masa —ĩre yiyuju Jesús, gase boaboar'ire. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaum vãme cʉti macajʉre Jesús ĩ ejaro ĩacõari, ĩ tʉjʉ vayuju surara ʉjʉ. Romano masʉ ñañuju ĩ. Jesús tʉ ejacõari, rʉ̃cʉbʉose rãca ado bajiro ĩre sẽniñuju: ");
INSERT INTO bsnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Yʉ ʉjʉ, yʉre moabosarimasʉ ĩ bajisere ajimaiña. Yʉ ya vijʉ rijajesami. Micacõari, bʉto visiomi —Jesúre ĩre yiyuju surara ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Ĩre catiogʉ varʉcʉja yʉ —ĩre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","To ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyuju surara ʉjʉ, Jesúre: —Yʉ ʉjʉ, quẽnagʉ̃ masu ñaja mʉ. Yʉma, rojose yʉ yisere tʉoĩa bojonegʉ̃ ñari, yʉ ya vire mʉre sãjarotimasibecʉja yʉ. Tojʉ sãjabetiboarine, mʉ ñagõtʉoĩasene catiomasigʉ̃ja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gãjerã surara ʉjarã beroagʉ ñaja yʉ. To bajiri, yʉ quẽne, gãjerã surarare rotigʉ ñaja yʉ. Sĩgʉ̃re, “¡Vasa!” yʉ yijama, vajami. Gãjire, “Vayá” yʉ yijama, vadiami. To yicõari, yʉre moabosarimasʉre, “Tire yiya” yʉ yijama, yirũgũami. To bajiri, mʉ roque rotigʉ masu ñari, tojʉ vabetiboarine, mʉ ñagõtʉoĩasene caticoarʉcʉmi —Jesúre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","To bajiro ĩ yisere ajiyamanire bajiro ajitʉoĩañuju Jesús. To bajiri ado bajiro ĩnare yiyuju, ĩre sʉyarãre: —Riojo mʉare gotiaja yʉ. Israel ñamasir'i jãnerabatia yʉ yarã ñaboarine, “Masigʉ̃, to yicõari, quẽnagʉ̃ ñari, yʉre yirẽmorʉcʉmi” yʉre ĩ yitʉoĩarore bajiro tʉoĩagʉ̃re, ĩabetirũgũaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Quẽnaro yʉre ajiya. Ĩre bajiro bajirã Israel masa me, jãjarã ejarʉarãma õ vecajʉ Dios tʉjʉ. Muiju ĩ jiadojʉa vadiriarã quẽne, ĩ rocasãtojʉa vadiriarã quẽne ejarʉarãma. Tojʉre, rojorãre Dios ĩ rearo bero, ĩ rãca barujirʉarãma ĩna. Ĩna rãca ñarʉarãma Abraham, Isaac, to yicõari, Jacob ñamasir'i quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel ñamasir'i jãnerabatia Diorãca barujirona ñaboariarã, rojose ĩna yire sʉorine rẽtiarojʉ ĩnare reacõarʉcʉmi. Tojʉre ñacõari, bʉto rojose tãmʉorã ñari, guji põguẽ, oti, yirʉarãma ĩna —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","To yigajano, surara ʉjʉjʉare ado bajiro yiyuju: —Mʉ ya vijʉ tudiasa. “Ñamasugʉ̃ ñari, yʉre catiobosacõarʉcʉmi” yʉre mʉ yitʉoĩarore bajirone bajirʉaroja —ĩre yiyuju Jesús. To ĩ yirirĩmarone, surara ʉjʉre moabosarimasʉ, vijʉ rijañaboar'i caticoasuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedro ya vijʉ vasuju Jesús. Ti vi ejacõari, Pedro ũmañicore ĩañuju. Cãnijesariaro joejʉ jesayuju so. So rujʉ bʉto asicõari, bʉbʉribʉjayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sore ĩacõari, so ãmore ĩ moaĩarone, rujʉ asicõari, so bʉbʉribʉjaboase tʉjacoasuju. To bajiri vʉ̃mʉrʉ̃gʉ̃cõari, bare ĩre ecayuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tirʉ̃mʉ rãiorijʉne juaejoyujarã, ĩna ʉsʉrijʉ vãtia sãñarãre Jesús tʉjʉ, “Vãtiare ĩnare bureato” yirã. To ĩna yiro ĩacõari, cojoji ñagõgʉ̃ne, vãtiare bureayuju Jesús. Jãjarã ñañujarã ĩna ʉsʉrijʉ vãtia sãñarã, masa ĩna juaejoriarã. To yicõari, rijaye cʉtirãre quẽne catioyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","To bajiro bajiyuju, Isa'ias, Diore gotirẽtobosarimasʉ ñamasir'i, “To bajiro bajirʉaroja” ĩ yiucamasire ti ñajare. Ado bajiro ucamasiñumi Isa'ias: “Mani rijaye cʉtire catiorʉcʉmi. To yicõari, josari mani tãmʉoñasere yirẽtobosarʉcʉmi” yiucamasiñumi Isa'ias, Jesús ĩ catiorotire yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cojorʉ̃mʉ jãjarã masa ĩ tʉjʉ ĩna ñagãnibiaro ĩacõari, —Gajejacatʉajʉ jẽacoajaro mani —ĩ buerãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","To ĩ yise rãcane, sĩgʉ̃, Dios ĩ rotimasire gotimasiorimasʉ, Jesús tʉ ejayuju. —Gotimasiorimasʉ, no bojaro mʉ vato cõrone mʉre sʉyarʉaja yʉ —Jesúre ĩre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","To ĩ yirone, ado bajiro ĩre cʉdiyuju Jesús: —Buyairoarema, ĩna gojeri ñacajʉ. Miniare quẽne, ĩna jibʉri ñacajʉ. To ĩna bajiboajaquẽne, yʉ, Dios ĩ cacʉma, cãniriajʉ magʉ̃re bajiro bajiaja yʉ. To bajiri yʉre mʉ sʉyajama, bʉto mʉre josarʉaroja —ĩre yiyuju Jesús, Dios ĩ rotimasire gotimasiorimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","To ĩ yiro bero, gãji Jesús buerimasʉ ado bajiro ĩre yiyuju: —Yʉ ʉjʉ, yʉre yuya mʉ maji. Yʉ jacʉ ĩ bajirocacoajare, ĩre yujegʉacʉ yaja yʉ. Ĩre yujecõari bero, mʉre sʉyarʉcʉja yʉ —Jesúre ĩre yiboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","To bajiro ĩre ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyuju Jesús: —Yucʉne yʉre sʉyaya mʉ. Yʉre ajitirʉ̃nʉmena, rijariarãre bajiro bajirã ñarãma. Ĩnajʉa rijariarãre yujeato ĩna —ĩre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús ĩ buerã rãca cũmuajʉ vasãjañuju, jẽacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ĩna jẽatone, bʉto mino vasuju. To bajicõari, bʉto sabeyuju. Ti saberone, cũmua sagueca yiro, rujacoarʉayuju. To ti bajiboajaquẽne, cãnigʉ̃ yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ĩ cãniro ĩacõari, ĩre yujioyujarã ĩna: —Yʉa ʉjʉ, ¡rujareana yaja mani! To bajiri mani rujaborotire yirẽtoña mʉ —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","To bajiro ĩna yirone, —¿No yirã bʉto güiati mʉa? “Rojose mani tãmʉoboajaquẽne, manire yirẽtobosarʉcʉmi”, yʉre yitʉoĩarã me ñaja mʉa —ĩnare yiyuju. To yi, vʉ̃mʉrʉ̃gʉ̃cõari, —¡Mino tʉjaya! ¡Sabese quẽne tʉjaya mʉa! —yiyuju Jesús. To ĩ yirone, tʉjacoasuju mino. Sabese quẽne, sabebesuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tire ĩacõari, no yimasibesujarã ĩna. —¿Ñimʉ ũgʉ̃ masʉ ñati ãni? Minore to yicõari, sabesere quẽne ĩ tʉjarotijama, ĩre ajiaja —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ʉtabʉcʉra gajejacatʉajʉ Gadara vãme cʉti maca tʉjʉ ejayujarã. To ĩna ejarone, masa rijariarãre ĩna yujereariavijʉre jʉarã ʉ̃mʉa budiayujarã. To bajicõari, Jesús tʉre ejarʉ̃gʉ̃ ejayujarã. Jʉarãjʉne vãtia sãñarã ñari, bʉto guayujarã. To bajiro ĩna bajijare, rẽtomasiña mañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesúre ĩarãne, ado bajiro yiavasãñujarã ĩna ʉsʉrijʉre sãñarã, vãtia: —¿No yigʉ yʉa tʉ vadiati Dios macʉ? ¡Yʉare gõjanabiobesa! Rojose yʉa yise vaja, rojose yʉare mʉ yirotirʉ̃mʉ ti ejabetiboajaquẽne, ¿rojose yʉare yigʉ vadiati mʉ? —Jesúre yiyujarã vãtia. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","To ĩna yiñaro sojʉa jãjarã ecariarã yesea macabañañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ĩnare ĩacõari, rʉ̃cʉbʉose rãca Jesúre yisẽniñujarã vãtia: —Yʉare mʉ bureajama, õa yeseajʉare yʉare sãjarotiya —yiyujarã vãtia. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","To bajiro ĩre ĩna yijare, —Mʉare varotiaja yʉ —vãtiare ĩnare yiyuju Jesús. To ĩ yirone, jʉarãjʉrene ĩna ʉsʉrijʉre sãñaboariarã budicoasujarã yuja, yeseajʉare sãjaroana. Ĩna sãjarone, buro ũmaroja vacõari, ʉtabʉcʉrajʉ ĩna ñaro cõrone rearoderujacõa tʉjasujarã, vãtia ĩnare ĩna sãjajare. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yeseare coderimasa, to bajiro ĩna bajisere ĩacõari, ũmacoasujarã, ĩna ya macajʉ vana. To bajicõari, vãtia sãñaboariarã ĩna yiecose ñaro cõrone ti macanare gotijeocõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tire ajicõari, Jesúre ĩarã vasujarã ĩna, ti macana jediro. Ĩ tʉ ejacõari, ĩre güirã, rʉ̃cʉbʉose rãca ĩre varotiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","To bajiro ĩre ĩna yijare, ʉtabʉcʉra gajejacatʉajʉ tudijẽa ejacoasuju Jesús, ĩ ya macajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ti macajʉ ĩ ñaro, micagʉ̃re rijarã ãmivariajʉ joejʉ ĩre ãmiejayujarã. “Ĩre ĩamaicõari, ĩre catiorʉcʉmi” ĩna yitʉoĩasere ĩamasicõari, micagʉ̃jʉare ado bajiro ĩre yiyuju Jesús: —Yʉ maigʉ̃, tʉoĩatutuaya. Rojose mʉ yirere mʉre masiriocõaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","To ĩ yisere ajicõari, ti macana sĩgʉ̃ri Dios ĩ rotimasire gotimasiorimasa ado bajiro tʉoĩañujarã: “To bajise ĩ ñagõjama, Diore ĩre rʉ̃cʉbʉobecʉ yami”, yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","To bajiro ĩna yitʉoĩasere ĩamasicõari, ado bajiro ĩnare yiyuju Jesús: —“‘Diore bajiro masa rojose ĩna yisere masiriomasiaja’ yisocaami”, yʉre yitʉoĩaboaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Rojose mʉ yisere masiriocõaja” yʉ yicõa tʉjajama, “Socʉ yami. Socʉ me yami”, yʉre yiĩamasigʉ̃ magʉ̃mi. To bajiboarine, micagʉ̃re, “Vʉ̃mʉrʉ̃gʉ̃cõari, vasa” ĩre yʉ yijama, “Socʉ me yami. Rojose ĩ yirere masiriocõami”, yʉre yiĩamasirãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","To bajiri, “‘Dios ĩ roticõacacʉ ñari, Diore bajirone masare rojose ĩna yisere masiriomasigʉ̃ ñaami’ yʉre yiĩamasiato” yigʉ, ãni micagʉ̃re ado bajiro yaja yʉ: Vʉ̃mʉrʉ̃gʉ̃ña mʉ. Mʉ jesarijʉre ãmiña. To yicõari, mʉ ya vijʉ tudiasa, ĩre yaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","To ĩre ĩ yirone, micagʉ̃ ñaboar'i, vʉ̃mʉrʉ̃gʉ̃cõari, ĩ jesarijʉre ãmi, ĩ ya vijʉ vacoasuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","To bajiro Jesús ĩ yisere ĩaʉcacoasujarã masa. “Ti ũnire ĩabetirũgũcajʉ mani. Ãni, Dios ĩ masise rãca yigʉ yami” yitʉoĩacõari, “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽnañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Micagʉ̃re catiogajano vagʉne, Mateo vãme cʉtigʉre yʉre ĩabʉjacami Jesús. Ʉjʉre gãjoa sẽnibosarimasʉ ñacajʉ yʉ. Gãjoa sẽnirã ĩna rujirijʉre gãjoa sẽnirujicajʉ. To yʉ yiñaro ĩacõari, —Yʉre ajisʉyaya —yʉre yicami Jesús. To bajiro ĩ yisere ajicõari, ĩre sʉyacoacajʉ yʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yʉ ya vijʉ ejacajʉ yʉa. To ejacõari, bacajʉ yʉa. Yʉ rãca barã ejacana, jãjarã ñacama. Yʉ yicatore bajiro rojose yirã, ʉjʉre gãjoa sẽnibosarimasa, to yicõari, gãjerã, “Rojose yirã ñaama” masare yiĩarã quẽne ñacama. Jesús buerimasa quẽne ñacama. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","To yʉa bajirone, ejacama fariseo masa. Ĩna ñacama, Moisére Dios ĩ roticũmasirere bʉto ajirʉ̃cʉbʉorã, rojose yirã rãca ñarʉamena. Ejacõari, yʉa bañasere ĩacõari, yʉ rãcanare Jesús buerimasare ĩnare sẽniĩacama: —¿No yigʉ mʉare buegʉma, ãnoa rojose yirã rãca bati? —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdicami Jesús, fariseo masare: —Catiquẽnarãma, ʉco yigʉre bojamenama. Rijaye cʉtirã rĩne ĩre bojarãma ĩna. To bajiro bajiaja yʉre quẽne. “Rojosere yirã me ñaja yʉa”, yirãma, yʉre bojamenama. “Rojose yirã ñaja yʉa” yirã rĩne yʉre bojarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dios oca masa ĩna ucamasirere ado bajiro quẽnaro tʉoĩaña mʉa. Ado bajiro gotiaja ti: “Gãjerãre mʉa ĩamaisere bojaja yʉ. Gãjerãre mʉa ĩamaibetijama, vaibʉcʉrã ecariarãre sĩacõari, yʉre mʉa soemʉoboajaquẽne, ñie vaja manoja ti”, yigotiaja Dios oca, masa ĩna ucamasire. Quẽnaro yirãre jigʉ me, adi macarʉcʉrojʉre vadicajʉ yʉ. Rojose yirãre, “Rojose ĩna yisere yitʉjato” yigʉ, vadicajʉ yʉ. To bajiri to bajiro yitʉoĩagʉ̃ ñari, ãnoa rãca bagʉ yaja yʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ buerã, Jesús tʉjʉ ejacama ĩna. To bajicõari, ado bajise ĩre sẽniĩacama: —Yʉa quẽne, fariseo masa quẽne, mani ñicʉa ĩna yimasiriarore bajiro Diore yʉa sẽnirirʉ̃mʉrirema bare babetirũgũaja yʉa. ¿No yirã tire yibeati mʉ buerãma? —ĩre yicama Juan buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","To ĩna yisere ajicõari, ado bajiro ĩnare gotimasiocami Jesús: —Sĩgʉ̃ ĩ ãmosiarirʉ̃mʉre ĩre variquẽnaejarẽmorã ñarãma. To ĩ ũmato yiñaro cõro ĩre variquẽnaejarẽmorãma. Ĩnare bajiro bajiama yʉ buerã. Yʉ rãca ñari, variquẽnacõa ñaama. “Sʉtiritimena ñari, no yirã bare babeticõa yimenama”, yimasire ñaja. To bajiboarine, cojorʉ̃mʉ yʉre ĩna ñiavato ĩacõari, bare bamenane Diore sẽnirʉarãma, “Mani sʉtiritisere ĩacõari, quẽnaro manire ejarẽmoato Dios” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mame oca yʉ gotimasiose ricati ti ñajare, yʉ ye rãca mani ñicʉa ĩna yimasirere mʉa tʉoĩavʉojama, quẽnabeaja. Sudiro bʉcʉase ti vojama, mamagasero rãca seretumasimenaja mani. Mamagaserone mani seretujama, mani coero bero carato tʉ̃atutu vatone bʉcʉasejʉa vocoatoja. Bʉcʉase, mamase rãca mani seretumasibetore bajirone, mame oca yʉ gotimasiosere, mani ñicʉa oca rãca tʉoĩavʉobesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","To bajirone bajiaja ʉye oco quẽne. Mame ʉye ocore, vaibʉcʉgaserone quẽnoriajoa bʉcʉjoajʉare jiomenaja mani. Bʉcʉjoajʉre mani jiojama, jãmʉsĩnituca yiro, yivocõaroja tijoajʉare. To bajiro mani yijama, ʉye ocore, vaibʉcʉgaserone quẽnoriajoare quẽne, to bajirone yireacõa tʉjana yirãja mani. “To bajirobe” yirãma, mame ʉye ocore vaibʉcʉgaserone quẽnoriajoa, mamajoajʉare jiore ñaroja. To yicõari, ʉye oco, vaibʉcʉgaserone quẽnoriajoa quẽne, cojoro cõro quẽnaro ñarʉaroja. To bajiri mame ʉye ocore, bʉcʉjoajʉre mani jiobetore bajiro mame oca yʉ gotimasiosere, mani ñicʉa oca rãca tʉoĩavʉobesa mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","To bajise Jesús ĩ gotiñarone, sĩgʉ̃ jud'io masa ʉjʉ ejacami. Ejacõari, Jesús rĩjorojʉa gʉsomuniari tuetucami, ĩre rʉ̃cʉbʉogʉ. To yigʉne, ado bajiro Jesúre yicami: —Yucʉacane yʉ maco bajirocacoamo. So tʉ ejacõari, sore mʉ moaĩajama, tudicaticoarʉocomo so —Jesúre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","To ĩ yisere ajicõari, ĩre sʉyacoacami Jesús. To bajiri yʉa, ĩ buerimasa quẽne vacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","To yʉa vatone, sĩgõ rõmio rijago Jesús sʉyarojʉa ejarʉ̃gʉ̃riomo. Gãmorõmi cʉtigo ñañumo so. Jʉaãmo cõro, gʉbo jʉa jẽnituari cʉ̃mari rijañañuju. “Jesús sudiro gaja moaĩarʉaja yʉ. Ti rĩne bojaja yʉ. To bajiro yʉ yijama, quẽnaejacoarʉocoja yʉ”, yiriomo so. To bajiro yirio ñari, Jesús sʉyarojʉa ejarʉ̃gʉ̃cõari, ĩ sudiro gajare moaĩariomo. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","So moaĩasere masicõari, jʉdarʉ̃gʉ̃cami Jesús. To yicõari, ado bajiro sore goticami: —Variquẽnaña yʉ maigõ. “Ĩ sudiro gajare yʉ moaĩajama, quẽnaejacoarʉocoja yʉ” yʉre mʉ yitʉoĩase ñajare, “Quẽnaejato” mʉre yibʉ yʉ —sore yicami Jesús. To bajiro ĩ yirirĩmarone, quẽnaejacoacamo so yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","To yi vanane, ʉjʉ ya vijʉ ejacoacajʉ yʉa, Jesúrãca. Ĩ macore yujeroana, tõroari juti, yioti avasãñacama ");
INSERT INTO bsnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","To bajiro ĩna yiñajare, ado bajiro ĩnare yicami: —Budiasa mʉa. “Bajirocacoajamo” mʉa yiboago, bajirocabesumo. Cãnigõ yigomo —ĩnare yicami Jesús. To ĩ yijare, ĩre ajacama ĩna, “Bajirocacoamo” yimasirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Masa ĩna budiato bero, bajirocario tʉjʉ jãjacõari, so ãmore ñiacami Jesús. To ĩ yirone, quẽna tudicaticõari, vʉ̃mʉrʉ̃gʉ̃coacamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jesús sore ĩ catiosere ti sitana masa ñaro cõrone gotibatocõañuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","28","Tojʉ ñariarã yʉa cãnirivi yʉa tudiatone, caje ĩamena jʉarã Jesúre avasã sʉyadicama: —Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉare ĩamaiña —Jesúre yisʉyacama ĩna. Vijʉ yʉa sãjaejarone, ĩna quẽne sʉyasãjaejacoacama. To ĩna bajirone, ado bajiro ĩnare sẽniĩacami Jesús: —“Yʉa caje ĩabetire ‘Ĩato’ yigʉ, yʉare ejarẽmomasigʉ̃mi”, ¿yʉre yitʉoĩati mʉa? —ĩnare yicami Jesús. —Yʉa ʉjʉ, to bajirone mʉre yitʉoĩaja yʉa —ĩre yicʉdicama. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","To ĩna yijare, ĩna cajere moaĩagʉ̃ne ado bajiro yicami Jesús: —“Manire catiorʉcʉmi” yʉre mʉa yitʉoĩase sʉorine mʉare ĩarotiaja yʉ —ĩnare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","To ĩ yirone, ĩacõacama. To yicõari, ado bajiro ĩnare goticami Jesús: —Gãjerãre gotibetimasucõama mʉa —ĩnare yiboacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","To bajiro ĩ yiboajaquẽne, ti sitana jedirore gotibatocõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ĩamena ñaboariarã ĩna budirirĩmarone, ejacama gãjerã, ñagõbecʉre ãmiejarã, vãti ĩ ʉsʉjʉre sãjacõari, ĩre ñagõrotibetir'ire. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús, vãtire ĩ burocarone, ñagõbecʉ ñaboar'i, ñagõcoacami yuja. Tire ĩacõari, no yimasibeticama masa: —Adojʉre, Israel sitajʉre, ado bajise yigʉre ĩaña manirũgũmʉ maji —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo masajʉama, ado bajiro yicama: —Ãni, vãtia ʉjʉ ĩ masise rãca vãtiare bureaami —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ti sitajʉ gotimasiocudijeocami Jesús. Tocãrãca maca masa Dios ocare ĩna buerivirijʉre sãjacõari, oca quẽnasere masare ĩnare gotimasiocami. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, yʉre ajitirʉ̃nʉña”, ĩnare yigotimasiocami. To yicõari, rijaye cʉtirãre jediro catiocami. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Oveja, ʉjʉ manare bajiro bajirã ñacama ĩna masa. No yimasibetiboana tʉoĩagõjanabidirã ñacama. To bajiro ĩna bajisere ĩacõari, ĩnare ĩamaicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","To bajiro ĩna bajisere ĩagʉ̃ ñari, ado bajiro yʉare yicami: —Ote jairo bʉcʉaroja. To bajiboarine, mojoroaca ñarãma tire juarimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","To bajiro ti bajijare, ote ʉjʉre sẽniña, ĩre moabosarimasa cõato ĩ yirã —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Cojorʉ̃mʉ ĩ buerimasare yʉare jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre jirẽocami Jesús. Yʉare jirẽocõari, ado bajiro yicami: —Masa ʉsʉrijʉ sãñarãre vãtiare, “Budiya” mʉa yijama, budirʉarãma. Rijaye cʉtirãre quẽne, “Catiya” mʉa yijama, caticoarʉarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñacajʉ yʉa, “Yʉ ocare gotimasiocudiba” Jesús ĩ yicana. Ado bajiro vãme cʉtirã ñacajʉ yʉa: Simón vãme cʉtiboacacʉ, Pedro vãme cʉtigʉ, ĩ bedi Andrés ñacama. To yicõari, Zebedeo rĩa ñacama Santiago, ĩ bedi Juan. Gãjerã, Felipe, Bartolomé, Tomás, yʉ Mateo vãme cʉtigʉ, ʉjʉre gãjoa sẽnibosarimasʉ ñaboacacʉ ñacajʉ. Alfeo macʉ Santiago, to yicõari, Tadeo vãme cʉtigʉ, gãji ñacami Simón vãme cʉtigʉ, celote yere tʉoĩaboar'i. Tʉsagʉ Judas Iscariote vãme cʉticami. Ĩ ñañumi Jesúre ĩsirocarocʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","To bajiri yʉa, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉre ado bajiro yʉare gotimasiocudiroticami Jesús: —Jud'io masa me ĩna ñarimacari gotimasiocudibeja mʉa. Samaria sita ñarimacarire quẽne vabeja mʉa —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","—Israel sitana tʉjʉare vasa. Ĩna ñarãma Dios yarã ñaboariarã, oveja yayirãre bajiro bajirã —yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","—“Diore rotibosarocʉ ĩ rotisʉoroti mojoroaca rʉyaja. Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, Jesúre ajitirʉ̃nʉña” yigotimasiocudiba mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gase boarãre mʉa ĩajama, ĩnare catioba mʉa. Gãjerã no bojase rijaye cʉtirãre quẽne ĩnare catioba. Rijariarãre tudicatioba. Masa ʉsʉrijʉ sãñarãre vãtiare quẽne ĩnare bureaba. Vaja manone to yirotire mʉare ʉjoaja yʉ. To bajiri, vaja sẽnimenane, mʉa quẽne gotimasiocudi, rijaye cʉtirãre catio, ĩna ʉsʉrijʉ sãñarãre vãtiare ĩnare burea, yicudirʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","—Mʉa vaja yiroti gãjoa juaábeja. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","To yicõari, bare sãriajoari juaábeja mʉa. Sudi mʉa sãñasene sãñacõari, vaja. Gajeye gʉbo sudi mʉa vasoaroti juaábeja. Tueriayucʉ́rire quẽne juaábeja. No bojarã gãjerãre moabosarimasa, vaja bʉjarãma. To bajirone bajirʉaroja mʉare quẽne. Ĩnare mʉa gotimasiose vajane ĩsiecorʉarãja mʉa quẽne —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Jairimaca, mojorimacare ejarã, quẽnaro yigʉre macama mʉa. Ĩre bʉjacõari, ĩ tʉ cãnima. Ti macanare mʉa gotimasiojama, ĩ tʉ rĩne ñama maji, gajerojʉ mʉa varoto rĩjoro. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vijʉ ejarã, “¿Ñati mʉa?” yisẽniĩacõari, “Quẽnaro ñaña mʉa”, yiba. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","To mʉa yirone, ti viana quẽnaro mʉare ĩna bocaãmijama, mʉa yirore bajiro quẽnaro ñarʉarãma. Quẽnaro mʉare ĩna bocaãmibetijama, “‘Quẽnaro ñaña’ yʉa yibetiriarãre bajirone ñacõaña mʉa” ĩnare yi, vacoaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mʉare quẽnaro ĩna bocaãmibetijama, to yicõari mʉa gotisere ĩna ajirʉabetijaquẽne, ti vire ñabeja. Ti vire budicõari, sitare gʉbo sudi tuyasere varereaba. “Quẽnaro yʉare bocaãmibeticõari, yʉare mʉa ajirʉabetijare, rojose mʉare yirʉcʉmi Dios” yirã, to bajiro yirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Riojo mʉare gotiaja yʉ. Ti macana mʉare ĩna ajirʉabeti vaja Diojʉama, rojose ĩnare yirʉcʉmi masare ĩ beserirʉ̃mʉ ti ejaro. Sodoma macana ñamasiriarã rẽtobʉsaro rojose tãmʉorʉarãma ĩna, mʉare quẽnaro bocaãmimenama —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Quẽna ado bajiro ĩ buerãre yʉare yicami Jesús: —Ovejare, buyairoa vatoajʉ güiorojʉ ĩnare cõagʉ̃re bajiro mʉare gotimasiocudirotiaja yʉ. To bajiri mʉa ñagõroto rĩjoro, quẽnaro tʉoĩama. To yicõari, mʉare rojose ĩna yiboajaquẽne, mʉajʉama quẽnasejʉare yirã rĩne ñacõama. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ado bajiro bajiroti ñajare, quẽnaro tʉoĩama mʉa: Mʉare ñejecõari, Dios ocare ĩna buerivirijʉ ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. Tojʉ mʉare bajerʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","To yicõari, yʉ ocare mʉa gotimasiojare, macari ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. To yi vanane, ʉjarã ñamasurã rĩjorojʉa mʉare juaárʉarãma. To bajiro mʉare ĩna yijare, ʉjarãre, to yicõari, jud'io masa mere yʉ ocare gotirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ʉjarã rĩjorojʉa mʉare ĩna juaejaro, “¿No bajiro ñagõrãti yʉa?”, yitʉoĩarejaibeja mʉa. “Ñagõña” mʉare ĩna yirirĩmarone, mani jacʉ Dios ĩ cõagʉ̃, Esp'iritu Santo ĩ ejarẽmose rãca “Ado bajiro gotirʉarãja yʉa” yimasirʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Quẽna ado bajiro yʉare yicami Jesús: —Yʉ yere ajiterãre güiose ĩna yisere ĩarʉarãja mʉa. Sĩgʉ̃ rĩa ñaboarine, “Ĩnare sĩato” yirã, ñejerotirʉarãma ĩna. To yicõari, jacʉa quẽne, “Yʉa rĩare sĩato” yirã, ĩna rĩare ñejerotirʉarãma. Ĩna rĩajʉa quẽne, ĩna jacʉare ajijũnisinicõari, gãjerãre sĩarotirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yʉ ocare mʉa goticudijare, jediro masa mʉare ĩaterʉarãma. To bajiro ĩna yiboajaquẽne, no bojarã yʉre ajitirʉ̃nʉ tʉjamenarema, rojose tãmʉotʉjabetiriarojʉ ĩna varoti ñaboarere ĩnare yirẽtobosarʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cojo maca mʉare rojose ĩna yijama, gaje macajʉ rudiaja mʉa. Riojo mʉare gotiaja yʉ. Jediro Israel sitajʉre ñarimacarire mʉa goticudijeoroto rĩjoro, yʉ, Dios ĩ roticõacacʉ, adi macarʉcʉrojʉre tudiejarʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ĩnare buegʉ rẽtobʉsaro masirã me ñaama ĩ buerã. To bajiboarine, quẽnaro ĩna buejeocõajama, ĩnare buerimasʉre bajirone masirãma ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","“Yʉare buegʉre bajiro yʉa bajijama, quẽnaja”, yitʉoĩaroti ñaja. To bajicõari, ĩre moabosarimasare quẽne, “Yʉa ʉjʉre bajiro yʉa bajijama, quẽnaja”, yitʉoĩaroti ñaja. To bajiro ti bajijare, yʉre mʉa ʉjʉre Beelzebú yʉre ĩna vãme yitud'ijama, yʉ yarã mʉa ñajare, rẽtoro rojose mʉare yitud'irʉarãma ĩna —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Quẽna ado bajiro ĩ buerãre yʉare yicami Jesús: —Rojose mʉare ĩna yitud'iboajaquẽne, ĩnare güibeja mʉa. “Masa ĩna ĩabeto yitud'irã yaja” mʉare ĩna yiboajaquẽne, Diojʉama, ĩacõarʉcʉmi. Ñiejʉa masa ĩna yirudise maja, Diorema. Adirʉ̃mʉri masa ĩna masibeti jediro, Dios ĩ beserirʉ̃mʉ ti ejaro, “Quẽnaro tire masiato” yigʉ, gotirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Masa ĩna ajibeto yayioroaca mʉare yʉ gotisere “Jediro ajiato” yirã, gotibatorʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉare sĩarʉarãre güibeja mʉa. Mʉa ʉsʉrijʉrema sĩamasimenama ĩna. Diojʉare mʉa güijama, quẽnaja. Ĩ ñaami mani catisere rotigʉ. Ĩ masu masiami. To bajiri rojose tãmʉotʉjabetiriarojʉ mʉare reamasicõami. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jʉarã miniare mani vaja yijama, cojotii gãjoatii rãca vaja yire ñaroja ti, mojoroaca vaja cʉtirã ĩna ñajare. To cõroaca vaja cʉtiboarine, Dios ĩ rotibetone rijagʉ magʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Masajʉare, Dios ĩ ĩajama, jairo vaja cʉtirãre bajiro manire ĩaami. Manire bʉto maiami ĩ. To bajiro bajigʉ ñari, mani rʉjoajoare, cojojoara rʉyabeto cõĩajeogʉ ñaami. To bajiri rojose mʉare yirãre güibeja —ĩ buerãre yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Quẽna ado bajiro yʉare yicami Jesús: —Masa ĩna ĩaro rĩjorojʉa, “Jesúre ajitirʉ̃nʉrã ñaja yʉa” yirãrema, yʉ quẽne õ vecajʉ yʉ jacʉ ĩ ĩaro rĩjorojʉa, “Ãnoa ñaama yʉ yarã”, yiĩorʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","To bajiboarine masa ĩaro rĩjorojʉa, “Jesúre ajitirʉ̃nʉrã me ñaja yʉa” ĩna yijama, yʉ quẽne, õ vecajʉ yʉ jacʉ ĩ ĩaro rĩjorojʉa, “Yʉ yarã me ñaama ĩna”, yirʉcʉja yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Quẽna ado bajiro yʉare yicami Jesús: —“‘Quẽnaro ñato masa’ yigʉ, vayumi Jesús”, yʉre yitʉoĩabesa mʉa. Dios ĩ bojabeti yirã, yʉ ocare ajijũnisinicõari, yʉre ajitirʉ̃nʉrãre ĩaterʉarãma ĩna. To bajiri ado bajirojʉa yʉre yitʉoĩaña: “‘Ĩ sʉorine ricatiri tʉoĩarʉarãma’ yigʉ, vayumi Jesús”, yʉre yitʉoĩaña. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ĩ macʉ, yʉre ĩ ajitirʉ̃nʉjama, ĩ jacʉjʉa ĩre ĩaterʉcʉmi. Jacʉjʉa, yʉre ĩ ajitirʉ̃nʉjama, ĩ macʉjʉa, ĩre ĩaterʉcʉmi. So macojʉa, yʉre so ajitirʉ̃nʉjama, so jacojʉa, sore ĩaterʉocomo. Jacojʉa, yʉre so ajitirʉ̃nʉjama, so macojʉa, sore ĩaterʉocomo. So ũmañicojʉa yʉre so ajitirʉ̃nʉjama, so jẽjojʉa, sore ĩaterʉocomo. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","To bajiri sĩgʉ̃ yʉre ajitirʉ̃nʉgʉ̃ ĩ ñajare, ĩ yarã ñaboarine, ĩre ĩaterʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","No bojagʉ ĩ jacore, ĩ jacʉre yʉre ĩ mairo rẽtobʉsaro maigʉ̃ma, yʉ yʉ ñamasibecʉmi ĩ ũgʉ̃ma. No bojagʉ ĩ macore, ĩ macʉre yʉre ĩ mairo rẽtobʉsaro maigʉ̃ma, yʉ yʉ ñamasibecʉmi ĩ ũgʉ̃ma. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","No bojagʉ, “Jesúre bajiro rojose tãmʉosʉyarʉcʉja yʉ” yitʉoĩabecʉma, yʉ yʉ ñamasibecʉmi ĩ ũgʉ̃ma. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","No bojarã, no ĩna bojarone ñare cʉtirãma adi macarʉcʉro ñasere ĩavariquẽnacõari, Diore tʉoĩamenama, Dios ĩ catisere yayibetire cʉomena ñarʉarãma ĩna. To bajiboarine, yʉre ajitirʉ̃nʉrã, yʉ oca ĩna gotisere ajijũnisinicõari, ĩna sĩarãma, Dios tʉ quẽnaro ñarona ñarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Quẽna ado bajiro yʉare yicami Jesús: —Mʉare cõagʉ̃ yʉ ñajare, gãjerã tʉ mʉa ejaro, quẽnaro mʉare ĩna yijama, yʉrene quẽnaro yirã yirãma. Yʉre quẽnaro yirãma, yʉre cõacacʉre quẽnaro yirã yirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“Diore gotirẽtobosarimasʉ ñagʉ̃mi” yimasicõari, quẽnaro ĩre yirã, ĩre gotirẽtobosarimasʉ Dios tʉ quẽnase ĩ bʉjaroto cõrone bʉjarʉarãma ĩna quẽne. “Quẽnaro yigʉ ñaami” yimasicõari, quẽnaro ĩre yirã, quẽnaro yigʉ Dios tʉ quẽnase ĩ bʉjaroto cõrone bʉjarʉarãma ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Riojo mʉare gotiaja yʉ. Yʉre ajisʉyarã ñamasurã me ĩna ñaboajaquẽne, yʉre ajitirʉ̃nʉrã ĩna ñajare, quẽnaro ĩnare yirã, to bajiro ĩna yise vaja, vaja bʉjarʉarãma ĩna. Ocone ĩnare ĩna ioboajaquẽne, vaja bʉjarʉarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yʉare, ĩ buerãre jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre yʉare ĩ gotimasioro bero, ti sita ñarimacarianare ĩnare gotimasiocudirã vacajʉ yʉa, Jesúrãca. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tirodo Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ, tubiberiavijʉ ñañuju ĩ. Tojʉ ĩ ñarone, Jesús masare ĩ gotimasiocudicati, to yicõari, ĩaĩañamani ĩ yiĩocati queti ĩre ejayuju. Tire ajicõari, jʉarã ĩ buerimasare cõañumi, “Jesúre sẽniĩaaya” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yʉa tʉ ejacõari, ado bajiro Jesúre sẽniĩacama ĩna: —¿Mʉne ñati “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i, “Yʉ bero ejarʉcʉmi” Juan ĩ yigotimasiocacʉ? ¿Gãjire yuroti ñatique maji? —ĩre yisẽniĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","To ĩna yisẽniĩarone, ado bajiro ĩnare yicʉdicami Jesús: —Vasa mʉa. Juan tʉjʉ tudiasa. Ĩ tʉ ejacõari, mʉa ĩasere, mʉa ajisere quẽne ĩre gotiba. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ado bajiro ĩre gotiba mʉa: “Jesús ĩ masise rãca ĩ yijare, ĩabetiboariarã quẽne ĩama. Rujasagueri vaboariarã quẽne, quẽnaro vama. Gase boariarãre quẽne, ĩna cãmi yatibʉ. Ajimena ñaboariarã quẽne, ajima. Bajireariarã quẽne, tudicatima. To yicõari, maioro bajirã quẽne, Dios oca quẽnasere gotimasio ecoama ĩna”, yigotiba, Juan tʉjʉ ejacõari. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","To bajiri, “‘Quẽnase bʉjarʉarãma yʉre ajitirʉ̃nʉrã, “Socʉ me yami” yʉre yitʉoĩarãma’ yimi”, ĩre yigotiba —ĩnare yicami Jesús, Juan buerimasare. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","To bajiro ĩ yisere ajicõari, ĩna vase rãcane, Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ ĩ ñare quetire goticami Jesús, jãjarã ĩre ajisʉyarãre: —Yucʉ́ manojʉ vana, ¿ñimʉ ũgʉ̃re tʉoĩa vacati mʉa? ¿Masa ĩna bojasere bajiro yirʉa tʉoĩagʉ̃re ĩarã vacati mʉa? “To bajiro tʉoĩagʉ̃ me ñacami”, yimasiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ñimʉ ũgʉ̃re tʉoĩarã vacati mʉa? ¿Quẽnase sudi sãñagʉ̃re tʉoĩa vacati? To bajiro me tʉoĩariarãja mʉa. “Quẽnase sudi sãñarãma, quẽnarivirijʉ, ʉjarã ya virijʉ ñarãma”, yimasiaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ñimʉ ũgʉ̃re tʉoĩa vacati mʉa? ¿Diore gotirẽtobosarimasʉre tʉoĩa vacatique mʉa? Riojo mʉare gotiaja yʉ. Gãjerã Diore gotirẽtobosarimasa rẽtoro ñagʉ̃re ĩariarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan ĩ bajirotire gotiro, ado bajise gotiaja Dios oca masa ĩna ucamasire: “‘“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, mʉre yʉ cõaroto rĩjoro, mʉre gotiyurocʉre cõasʉorʉcʉja yʉ maji’ yami Dios. ‘Ĩ ñarʉcʉmi ado bajise gotirocʉ: “Yoaro mene ejarʉcʉmi ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ. To bajiri rojose Dios ĩ bojabetire yitʉjacõari, ĩ bojasejʉare yi yuya mʉa” yigotirocʉ ñarʉcʉmi’, yami Dios”, yigotiaja Dios oca masa ĩna ucamasire. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Diore gotirẽtobosarimasa ĩna gotimasire rẽtoro ñamasuse ñaja, Juan, Diore ĩ gotirẽtobosasejʉa. To bajiro ti bajiboajaquẽne, Juan ĩ gotise rẽtoro ñamasuse ñaja yʉ gotiroticõarã ĩna gotise. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, Jesúre ajitirʉ̃nʉña” ĩna yigotisere yaja yʉ. Ñamasurã ñaama, “Ñamasurã me ñaama Jesús ĩ gotiroticõarã” mʉa yiĩaboajaquẽne —yicami Jesús, ĩre ajisʉyarãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Quẽna ado bajiro yicami Jesús: —Juan ĩ gotimasiosʉorijʉne, “Ʉjʉ Dios yarã quẽnaro ĩ yirã mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, Jesúre ajitirʉ̃nʉña” yirere ajicõari, ti josaboajaquẽne, yʉre ajisʉya variquẽnasʉoadicama masa. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan ĩ gotimasiosʉoroto rĩjorojʉne, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ Dios ĩ cõarocʉre goticoayuma ĩna, Diore gotirẽtobosarimasa. Moisére Dios ĩ roticũmasire quẽne, tire gotiaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Diore gotirẽtobosarimasʉ El'ias vãme cʉtimasir'ire bajiro bajigʉ ejarʉcʉmi”, yigotiyujarã ĩna, Diore gotirẽtobosarimasa. To bajiro ĩna yimasirere, “Riojo ucamasiñuma ĩna” mʉa yitʉoĩajama, “Juan ĩ ejarotire gotirã yimasiñuma”, yimasiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mʉa ajimasirʉajama, quẽnaro yʉre ajitirʉ̃nʉña mʉa —ĩre ajisʉyarãre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Quẽna ado bajiro ĩre ajisʉyarãre goticami Jesús: —Ado bajiro yirãre bajiro yirã ñarãja mʉa, adirodoriana: Daquerã, gãjerã rãca ajerʉamenare bajiro yirã ñarãja. Ĩna ajeritũcurojʉ rujicõari, gãjerãjʉare, ado bajiro ĩnare gotirujirãma: “‘Basavariquẽnato mani’ yirã, mʉare jutibosaboabʉ yʉa. To bajiro yʉa yiboajaquẽne, basabejʉ mʉa. To bajiri, ‘Rijariarãre bʉcʉrã ĩna oticatore bajiro sʉtiriose boca otirʉarãja mʉa, yʉa basañarone’ yiboabʉ yʉa. To yʉa yiboajaquẽne, otibejʉ mʉa”, ĩnare yigotirãma, ĩna rãca ajerʉamenare. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ĩna rãca ajerʉamenare bajiro yirã ñarãja mʉa, adirodoriana. Juan, quẽnase bare babeti, quẽnase idire idibeti bajiñañuju ĩ. To bajiro bajigʉ ĩ ñajare, “Vãti sãñagʉ̃ ñagʉ̃mi”, ĩre yitʉoĩacajʉ mʉa, ĩre ajiterã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ĩ bero gotimasiosʉocajʉ yʉ, Dios ĩ roticõacacʉ. Yʉjʉama, quẽnase bare ba, quẽnase idire idi bajiñaja yʉ. To bajiro yigʉ yʉ ñajare, “Jairo bagʉ ñaami. Idimecʉgʉ̃ ñaami. Ʉjʉre gãjoa sẽnibosarimasa, gãjerã rojose yirãre quẽne ĩnare baba cʉtiami”, yʉre yiĩajũnisiniaja mʉa, yʉre quẽne ajiterã ñari. To bajiro Juanre quẽne, yʉre quẽne mʉa yise ti ñaboajaquẽne, Dios ĩ masise rãca yʉa yise ti ñajare, berojʉ, “Quẽnaro yirã yiboayuma” yʉare yimasirʉarãja mʉa —yicami Jesús, ĩre ajisʉyarãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tijʉ bero, ĩaĩañamani ĩ yiĩoboacana ya macarire tʉoĩacõari, Dios ĩ bojabetire ĩna yisere tʉoĩasʉtiriticõari, ĩna yitʉjabetijare, rojose ĩna tãmʉorotire yigʉ, ado bajiro goticami Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Coraz'in macana, to bajicõari, Betsaida macana quẽne, bʉto rojose tãmʉorʉarãma. Ti macarianare ĩaĩañamani yʉ yiĩocatore bajiro, Tiro vãme cʉti macanare, Sidón vãme cʉti macanare quẽne ĩaĩañamani yʉ ĩojama, tirʉ̃mʉjʉ rojose ĩna yisere tʉoĩasʉtiriticõari, yitʉjacoaboriarãma ĩnama. “Rojose yʉa yisere yirʉabeaja” yisʉtiritirã ñari, sʉtiritirã ĩna sãñasejʉa sudi vasoacõari, to yicõari, ĩna rʉjoarijʉ õja majeoboriarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Riojo mʉare gotiaja yʉ. Sidón macana, to bajicõari, Tiro macana ñamasiriarã rẽtobʉsaro rojose tãmʉorʉarãma ĩna, Dios, masare ĩ beserirʉ̃mʉ ti ejaro. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum macanajʉa, “Quẽnarã ñari, õ vecajʉ Dios ĩ ñarojʉ ñarona ñaja mani”, yitʉoĩaboarãma ĩna. To bajiro ĩna yitʉoĩaboajaquẽne, Dios tʉjʉ ñabetirʉarãma. Rojose tãmʉotʉjabetiriarojʉ ñaja ĩna cõaecorotoma. Toanare ĩaĩañamani yʉ yiĩocatore bajiro, Sodoma macanare quẽne yʉ yiĩojama, rojose ĩna yisere yitʉjaboriarãma ĩnama. To bajiri adirʉ̃mʉrire quẽne ñacõaboriaroja ti maca maji. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Riojo mʉare gotiaja yʉ. Ti macana yʉre ĩna ajirʉabeti vaja, Diojʉama, rojose ĩnare yirʉcʉmi masare ĩ beserirʉ̃mʉ ti ejaro. Sodoma macana ñamasiriarã rẽtobʉsaro rojose tãmʉorʉarãma ĩna —yitʉoĩa goticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Ĩre ajitirʉ̃nʉrãre, “Mʉ sʉorine ajitirʉ̃nʉama” yigʉ, “Quẽnaja” Diore yivariquẽnagʉ̃, ado bajiro yicami Jesús: —Cacʉ, õ vecagʉ ʉjʉ ñaja mʉ. Adi macarʉcʉrore quẽne, ñajediro ʉjʉ ñaja mʉ. “Jẽre masiaja yʉa” yitʉoĩaboarãre, “Yʉ ocare ajimasibeticõato ĩna” yigʉ, ĩnare masirioaja mʉ. To yicõari, “Masimena ñaja yʉa” yirãjʉare, “Ajimasiato” yigʉ, ĩna ajimasirotire yirẽmorũgũaja mʉ. To bajiro mʉ yijama, mʉ bojarore bajiro yigʉ yaja mʉ —Diore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","To yicõari, ĩre ajisʉyarãjʉare ado bajiro goticami Jesús: —Yʉ jacʉ ĩ ejarẽmose sʉorine jediro yimasijeogʉ ñaja yʉ. “Tire yimasiato” yigʉ, adi macarʉcʉrojʉre yʉre cõacami yʉ jacʉ. To bajiro yicacʉ ñari, yʉ yisere masijeocõami yʉ jacʉ. Yʉ quẽne, ĩ yisere masijeocõaja. “Ĩre masiato” yigʉ, yʉ beserã rĩne yʉ jacʉre masiama —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","29","Quẽna ado bajiro yicami Jesús: —Cojo vãme me ĩna rotise ti ñajare, jairo gajacõari, ñarãre bajiro bajiaja mʉa. “Tire cʉdijeomasimenaja mani” yisʉtiritirã ñari, yʉjʉare ajirã vayá mʉa. Yʉre ajitirʉ̃nʉcõari, rʉ̃cʉse gajacõari, ñamenare bajiro variquẽnarã ñarʉarãja mʉa. Masare maitʉoĩagʉ̃ ñaja yʉ. “Ñamasugʉ̃ ñari, ĩnare ajirʉ̃cʉbʉobeaja yʉ” yigʉ me ñaja yʉ. No bojarãre yʉre ajitirʉ̃nʉrãre ejarẽmogʉ̃ ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mʉare yʉ rotise josari me ñaja. To bajiri yʉ rotisere mʉa cʉdijama, variquẽnarʉarãja mʉa —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ʉsʉsãjariarʉ̃mʉ ti ejaro, trigo ĩna oteriavese cʉtore vacajʉ, Jesúrãca. To bajivanane ñiorijacajʉ yʉa. To bajirã ñari, trigo ricare tũnejuacõari, yʉa ãmorine ti gasere sĩguẽreacõari, bacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tire yʉa basere ĩacõari, fariseo masa ado bajiro Jesúre ĩre yicama ĩna: —¡Ĩaña mʉ! Mʉ buerimasa, ʉsʉsãjariarʉ̃mʉ yire mere yama ĩna —Jesúre ĩre yicama. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdicami Jesús: —¿David ñamasir'i ĩ babarã rãca ñiorijacõari, ĩnare ĩ ũmato bamasirere masibeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ñiorijarã ñari, “Mani rãca ñagʉ̃mi Dios” masa ĩna yirivijʉre sãjacõari, Diore ĩre rʉ̃cʉbʉorã gãjerã pan ĩna cũboarerene juacõari, ĩ babarã rãca bamasiñuju ĩ. To bajiri Moisés ñamasir'i ĩ gotimasirema, “Paia rĩne barʉarãma” ĩ yimasiboarerene bamasiñujarã ĩna. To bajiro ĩna yiboajaquẽne, ti vaja rojose ĩnare yibetimasiñumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿“Ʉsʉsãjariarʉ̃mʉ ti ñaboajaquẽne, Diore yirʉ̃cʉbʉoriavijʉ paia ĩna moatʉjabetiboajaquẽne, rojose yirã me yirãma ĩna”, Moisés ñamasir'i ĩ yiucamasirere masiritiatique mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Riojo mʉare gotiaja yʉ. Moisére ĩ roticũmasire, Diore yirʉ̃cʉbʉoriaviaye ñase rẽtobʉsaro ñamasuse ñaja mame yʉ rotise. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios oca masa ĩna ucamasire ajimasibetibʉsaja mʉa. Ado bajiro gotiaja ti: “Vaibʉcʉrã ecariarãre sĩacõari, yʉre ĩna soemʉosere bojabetibʉsaja yʉ. Masa gãjerãre quẽnaro ĩna ĩamaisejʉare bojamasucõaja yʉ”. To bajiro yigotiaja Dios oca masa ĩna ucamasire. Tire, “Ado bajiro yirʉaro yaja” yiajimasirã masu mʉa ñajama, Dios ĩ bojabeti rojose ĩna yibetiboajaquẽne, “Rojose yama” yʉ buerimasare ĩnare yiĩabetiboriarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉ, Dios ĩ roticõacacʉ, “Ʉsʉsãjariarʉ̃mʉre ado bajiro mʉa yijama, quẽnaja. To bajirojʉa mʉa yijama, quẽnabeaja”, yirotigʉ ñaja yʉ —ĩnare yicʉdicami Jesús, fariseo masare. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","To yi vacʉne, Dios ocare ĩna buerivijʉ yʉare ũmato sãjacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti vijʉ ñacami sĩgʉ̃, cojojacatʉa ãmo ñujobecʉ. Fariseo masa quẽne ñacama. “Jesús, rojose yimi” ʉjarãre yi ocasãrʉarã, ado bajiro Jesúre sẽniĩatocama ĩna: —Dios, Moisére ĩ roticũmasirere mʉ tʉoĩajama, “Adirʉ̃mʉ ʉsʉsãjariarʉ̃mʉre rijaye cʉtirãre mani catiojama, quẽnacõaroja”, ¿yitʉoĩati mʉ? —Jesúre ĩre yisẽniĩatocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","To ĩna yisere ajicõari, ado bajiro yicami: —Oveja mʉa ecar'i, gojejʉ ĩ quedirocasãjama, “Ʉsʉsãjariarʉ̃mʉ ñaja” yirã, ¿ãmirã vamenada mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Masʉ rẽtobʉsaro maiĩogʉ̃ ñatique, ovejajʉa? To bajiri, ¿ʉsʉsãjariarʉ̃mʉ quẽne, no bojagʉ masʉre quẽnaro mani yijama, quẽnabetojarique? —ĩnare yicʉdicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","To yicõari, ãmo ñujobecʉjʉare: —Mʉ ãmore ñujoya —ĩre yicami. To ĩ yirone, ĩ ãmore ĩ ñujorone, quẽnaejacoacajʉ yuja, gaje ãmore bajirone. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","To ĩ yisere ĩacõari, budicoacama fariseo masa. Budiacõari, “¿No bajiro yicõari, Jesúre sĩarotirãti mani?” gãmerã yiñagõñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","To bajiro ĩre ĩna tʉoĩa ñagõjaisere masicõari, gajerojʉ vacami Jesús quẽna. Jesús ĩ vato ĩacõari, ĩre sʉyacajʉ yʉa, jãjarã masa. Tojʉ ñajediro masa rijaye cʉtirãre catiocami. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","To yicõari, ĩnare ĩ catiosere gotirotibeticami ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","To bajiro ĩ yijama, “Isa'ias ñamasir'i Diore gotirẽtobosarimasʉ, ‘To bajiro bajirʉaroja’ ĩ yiucamasiriarore bajiro bajiato” yigʉ, yicami, ado bajiro yise ti ñajare: ");
INSERT INTO bsnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ãni ñaami, yʉre moabosarimasʉ yʉ besecacʉ, yʉ ĩavariquẽnagʉ̃. Esp'iritu Santore ĩre cõarʉcʉja yʉ, ‘Ĩ ejarẽmose rãca yʉ bojasere yimasiato ĩ’ yigʉ. To bajiri, ‘Ado bajiro riojo yiroti ñaja’ yigotibatorʉcʉmi, masa ñajedirore. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Masa rãca oca josabecʉ ñarʉcʉmi ĩ. To yicõari, masa ĩna ĩaro rĩjorojʉa rʉ̃gõcõari, ‘Yʉre ajiya mʉa. Masigʉ̃ ñaja yʉ’ yiavasã gotibecʉ ñarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yʉre quẽnaro ajitirʉ̃nʉmenare, yʉ bojarore bajiro yimasibeticõari, tʉoĩasʉtiritirãre quẽne mairʉcʉmi. Ĩnare ĩamaicõari, ‘Quẽnaro yʉre ajitirʉ̃nʉato ĩna’ yigʉ, ĩnare ejarẽmorʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jud'io masa me ñarã rojose ĩna yise vaja rojose ĩna tãmʉoborotire, ‘Manire yirẽtobosarʉcʉmi. To bajiri rojose tãmʉobetirʉarãja’ yivariquẽna yuñarʉarãma”, yiucamasiñumi Isa'ias, Diore gotirẽtobosarimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sĩgʉ̃ ñacami vãti sãñagʉ̃. “Ĩabeticõato; ñagõbeticõato” yigʉ, ĩ ʉsʉjʉre sãjacõari, ñañumi. To bajiri Jesús tʉjʉ ĩre ãmiejacama masa. To ĩna yirone, ĩ ʉsʉjʉre sãñagʉ̃re vãtire burocacami Jesús. To bajiri vãtire ĩ burocajare, ĩamasi, ñagõmasi, bajicoacami yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tire ĩacõari, no yimasibeticama masa jediro: —¿Ʉjʉ David ñamasir'i jãnami “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i mani tʉoĩa yuñarũgũgʉ̃ ñatique ĩ? —yicama. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yicama fariseo masajʉa: —Vãtiare ĩ bureajama, vãtia ʉjʉ Beelzebú vãme cʉtigʉ ĩ masise rãca vãtiare bureagʉ yami —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","To bajiro ĩna tʉoĩasere ĩamasicõari, ado bajiro ĩnare gotimasiocami Jesús: —Cojo sitana rotirimasa ĩna gãmerã quẽajama, ĩna masune gãmerã sĩayayirã yirãma. To bajirone bajiroja cojo macanare quẽne, cojo vi ñarãre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","To bajirone bajiroja vãtiare quẽne. Vãtia ĩna gãmerã bureajama, “Masare rojose yitʉjato mani” yirã yiborãma. To bajiro ti bajijare, “Beelzebú vãme cʉtigʉ ĩ masise rãca masa ʉsʉrijʉ sãñarãre vãtiare bureaami” yʉre mʉa yiboase, riojo yirã me yaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","To bajiro yʉre mʉa yitʉoĩaboajama, mʉa buerã quẽne masa ʉsʉrijʉ sãñarãre vãtiare ĩna bureasere, “Vãti ĩ masise rãca burearãma ĩna quẽne” yirãre bajiro yaja mʉa. To bajiro mʉa yijama, “Tʉoĩamavisiaja mʉa”, mʉare yirʉarãma ĩna, mʉa buerã. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ado bajirojʉa tʉoĩarona ñaboaja mʉa: “Vãtia ʉjʉ ĩ masise rãca me yami. Esp'iritu Santo ĩ masise rãcajʉa vãtiare bureaami”, yʉre yitʉoĩarona ñaja mʉa. To yicõari, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, yʉre yitʉoĩamasiroti ñaja mʉare. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“To bajiro yimasiroti ñaboaja” yigʉ ñari, “Quẽnabʉsaro yimasiato” yigʉ, quẽna gajeye gotimasiore queti mʉare gotiaja yʉ: Sĩgʉ̃, gãji guamʉ ya vi sãjacõari, ĩre ĩ siabetijama, gajeyeũni ẽmamasibecʉmi. Ĩre siacõari, ĩ gajeyeũnire ẽmamasigʉ̃mi yuja. To bajirone bajiaja yʉre quẽne. Vãtia ʉjʉ ĩ rotiboasere ĩre yirotibeticõari, masa ʉsʉrijʉ sãñarãre vãtiare yʉ burease sʉorine, vãti ĩ rotiajeboariarãre ĩre ẽmagʉ̃ yaja, “Yʉ yarã ñato” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","No bojarã yʉ gotiboasere ajitirʉ̃nʉmenama, yʉre ajitirʉ̃nʉboronare matarã yirãma. No bojarã, “Jesúre ajitirʉ̃nʉña” yʉre yigoticudibosamenama, “Ĩre ajibesa” yirãre bajiro bajirã ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","To bajiri, riojo mʉare gotiaja yʉ. Masa jediro rojose ĩna yijama, jediro rojose ĩna ñagõjaquẽne, sʉtiriticõari, Diore ĩna sẽnijama, rojose ĩna yisere masiriorʉcʉmi. To bajiboarine, Esp'iritu Santojʉare rʉ̃cʉbʉomena rojose ĩre ĩna yitud'ijama, tirema masiriobetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","No bojarã, Dios ĩ roticõacacʉre rojose yʉre ĩna ñagõro bero, sʉtiriticõari, Diore ĩna sẽnijama, rojose ĩna yisere masiriorʉcʉmi. To bajiboarine, Esp'iritu Santo ĩ masise rãca moagʉ̃re, “Satanás ye rãca moami” ĩna yitud'ijama, Esp'iritu Santojʉare rojose yirã yirãma. Tirema gajerodo ti ñacoaboajaquẽne, masiriobetirʉcʉmi Dios —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Quẽna ado bajiro goticami Jesús: —Yucʉ́ quẽnase ti rica cʉtijama, “Quẽnaricʉ ñaja”, yaja mani. Yucʉ́ rojose ti rica cʉtijama, “Rojoricʉ ñaja”, yaja mani. Ricare ĩacõari, “Quẽnaricʉaye, rojoricʉaye ñaja”, yiĩamasiaja mani. To bajirone bajiaja mani yise quẽne. “Quẽnagʉ̃ ñaami. Rojogʉ ñaami” yimasirʉarã, ĩ yisere ĩaĩarãja mani. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Vãtia ʉjʉ rojose ĩ yirore bajirone rojose yijairã ñaja mʉa. Rojorã ñari, no yirã quẽnasere ñagõmenaja mʉa. Mʉa ʉsʉrijʉ rojose mʉa tʉoĩasãñasere ñagõburũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Quẽnagʉ̃ma, quẽnaro tʉoĩagʉ̃ ñagʉ̃mi. To bajiri quẽnase ñagõgʉ̃mi. Rojogʉjʉama, rojose tʉoĩagʉ̃ ñagʉ̃mi. To bajiri rojose ñagõgʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Riojo mʉare gotiaja yʉ. Ejarʉaroja masa jedirore Dios ĩ beserirʉ̃mʉ. Tirʉ̃mʉre tocãrãca vãme, mʉa ñagõria vãmere, “Ado bajiro ti bajijare, to bajise ñagõcajʉ yʉa”, Diore yigotirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","To bajirone bajirʉaroja. Mʉa ñagõrere ĩacõari, “Quẽnase bʉjarã, rojose tãmʉorã, bajirʉarãja”, yirotirʉcʉmi Dios —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","To ĩ yiro bero, ado bajiro ĩre yicama fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne: —Gotimasiorimasʉ, ĩaĩañamani mʉ yiĩosere bojaja yʉa —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","To ĩna yirone, ado bajiro ĩnare cʉdicami Jesús: —Mʉa adirodoriana, rojose yirã jãjarã ñaja mʉa. Yʉre ajiterã ñari, ĩaĩañamani mʉare yʉ yiĩosere bojaboaja mʉa. To bajiro mʉa bojaboajaquẽne, to bajise mʉare yiĩobetirʉcʉja yʉ. To bajiboarine Jonás ñamasir'i Diore gotirẽtobosarimasʉ ĩ bajimasirere bajiro bajiĩoroti ñaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","N'inive vãme cʉti macana ñamasiriarã, ĩna tʉjʉ Jonás ĩ ejaroto rĩjoro idiarʉ̃mʉ, idia ñami vai jaigʉ gʉdajoajʉ ĩ ñamasirere ĩnare ĩ gotisere ajicõari, “Diore gotirẽtobosagʉ ñaami”, ĩre yitʉoĩañujarã ĩna, N'inive macana. To bajiro bajirʉcʉja yʉ quẽne, Dios ĩ roticõacacʉ quẽne. Idia ñami, idiarʉ̃mʉ sita ẽñerocajʉ yʉ ñarere ajicõari, “Dios ĩ cõar'ine ñañumi”, yimasirʉarãma ĩna, masa. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","N'inive macana ñamasiriarã, Jonás ñamasir'i Dios oca ĩ gotisere ajicõari, rojose ĩna yisere sʉtiriticõari, yitʉjamasiñujarã ĩna. Jonás rẽtoro ñamasugʉ̃ ñaja yʉ. To bajiro yʉ bajiboajaquẽne, mʉajʉama, rojose mʉa yisere yitʉjabeaja mʉa. To bajiro yirã mʉa ñajare, masare Dios ĩ beserirʉ̃mʉ ti ejaro, ado bajiro bajirʉaroja: N'inive maca ñamasiriarã, tudicatirʉarãma ĩna. Tudicaticõari, “Mʉa ye sʉorine rojose tãmʉorʉarãja”, mʉare yiĩarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sabá sitana ʉjo ñamasirio, “Ʉjʉ Salomón quẽnaro masigʉ̃ ñañuju” yire quetire ajicõari, sõjʉ vadicõari, ĩre ajigo ejamasiñuju so. Salomón rẽtoro ñamasugʉ̃ ñaja yʉ. To yʉ bajiboajaquẽne, mʉajʉama, yʉre ajitirʉ̃nʉbeaja mʉa. To bajiri, masare Dios ĩ beserirʉ̃mʉ ti ejaro, ado bajiro bajirʉaroja mʉare: Salomón tʉ ejamasirio, tudicaticõari, “Mʉa ye sʉorine rojose tãmʉorʉarãja”, mʉare yirʉocomo so, yʉ gotisere ajirã ñaboarine, rojose mʉa yitʉjabetijare —fariseo masare ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Quẽna ado bajiro yicami Jesús: —Vãti, masʉ ʉsʉjʉre budicõari, oco manorijʉ vacudigʉmi. Tujariajaʉ bʉjabecʉ ñari, ado bajiro tʉoĩagʉ̃mi: ");
INSERT INTO bsnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Yʉ budiriarojʉne vacoarocʉ ñagʉ̃ja yʉ”, yitʉoĩagʉ̃mi. Masʉ ʉsʉjʉre ĩ budigoriarore tudiejagʉ ĩ ĩajama, gõjanabiose mano, quẽnarivire bajiro masʉ ʉsʉjʉre ĩaejagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","To bajiro ĩ ʉsʉjʉre ĩaejacõari, cojomo cõro jʉa jẽnituarirãcʉ vãtia ĩ rẽtoro rojose yirãre ũmato ejagʉmi. To yicõari, ĩna ñaro cõrone masʉ ʉsʉjʉre sãjarãma ĩna. To bajiri, rẽtorobʉsa rojose yigʉ ñagʉ̃mi masʉ yuja. To bajirone bajirʉaroja mʉare adirodoriana rojose yirãre quẽne. Vãtiare yʉ bureacõaboajaquẽne, yʉre ajitirʉ̃nʉmena ñari, bʉtobʉsa rojose yirã ñaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Jesús, masare ĩ gotimasio ñarone, sĩgʉ̃, ado bajiro Jesúre ĩre yicami ĩ: —Mʉ jaco, mʉ bederã rãca macajʉ́jʉ ejama, mʉ rãca ñagõrʉarã —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","To bajiro ĩ yiboajaquẽne, ado bajiro ĩre yicʉdicami Jesús: —¿Ñimo ñati yʉ jacoma? ¿Ñimarã ñati yʉ bederãma? —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","To yigʉne, yʉajʉare, ĩ buerimasare ĩacõari, —Mʉa ñaja yʉ bederãma, yʉ jacore bajiro bajirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","No bojarã yʉ jacʉ õ vecagʉ ĩ rotirore bajiro yirã, ĩna ñarãma yʉ bederãre bajiro bajirãma, yʉ jacore bajiro bajirãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tirʉ̃mʉne, vi ñar'i, budiacõari, ʉtabʉcʉra tʉjʉ yʉa rãca ejarũju ejacami Jesús. To bajicõari, masare gotimasiocami. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Masa jãjarãbʉsa ĩna rẽjaquearo ĩacõari, cũmuajʉ vasãjacõari, rujicami Jesús. Masajʉama, ʉtabʉcʉra tʉ rʉ̃gõcõacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","To bajicõari, cojo queti me tʉoĩacõari, “Ado bajiro bajisere bajiro bajiaja” ĩnare yigotigʉ ñari, ado bajise goticami: —Sĩgʉ̃ oterimasʉ, vesejʉ ote ajere otegʉ vacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Vese ejacõari, ote ajere ĩ reabaterone, gajeye maajʉ vẽjaquearoja. To bajiri minia ejacõari, tire bareacõarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Gajeyema, gʉ̃ta joejʉ reajeoroja. Tijʉ, mojoroaca sita ti ñajare, guaro ti judidaboajaquẽne muiju, asisĩocõagʉ̃mi. To bajicõari, oco manijare, sĩnireacoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gajeyema, jotayucʉ́ vatoajʉ vẽjaquearoja. To bajicõari, ti judiboajaquẽne, jotajʉa bʉcʉaveocoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gajeyema, sita quẽnarojʉ vẽjaquearoja. To baji, judibʉcʉacõari, quẽnase ñacõari, jairo rica cʉtiroja. Cojotõ, cien ñaricari rica cʉtiejoroja. Gajetõ sesenta ñaricari, gajetõ treinta ñaricari rica cʉtiroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tire mʉa ajimasirʉajama, quẽnaro tʉoĩaña mʉa —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","To ĩ yiro bero, ado bajiro Jesúre sẽniĩacajʉ yʉa, ĩ buerã: —¿No yigʉ gotimasiore queti tʉoĩacõari, ĩnare gotirũgũati mʉ? —ĩre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","To yʉa yirone, ado bajiro yʉare cʉdicami: —“Ʉjʉ Dios yarã quẽnaro ĩ yirona yʉa ñarʉajama, ado bajiro yiroti ñaja” ĩna yimasibeticatire, yucʉrema Dios ĩ masise rãca ajimasiaja mʉama. To bajiboarine, gãjerãjʉama, Dios ĩ bojabetijare tire ajimasibeama. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","No bojagʉ Diore ajitirʉ̃nʉgʉ̃re, “Quẽnarobʉsa ajimasiato” yigʉ, ĩ masisere cõarʉcʉmi Dios. Gãjirema, ĩre ajigʉ ñaboarine, ĩre ĩ ajitirʉ̃nʉbetijare, ĩ ajimasiboasere masiriojeocõarʉcʉmi ĩ. To bajiri ĩre masibetimasucõarʉcʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Masa ado bajiro bajirã ĩna ñajare, gotimasiore queti ĩnare gotirũgũaja yʉ: Yʉ yiĩosere ĩarã ñaboarine, yʉ gotisere ajirã ñaboarine, ajimasicõari, “To bajiro manire yigotigʉ yatique”, yimasimenama. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Diore gotirẽtobosarimasʉ Isa'ias ñamasir'i mʉa bajirotire yigʉ, Dios ĩ ñagõmasirere ado bajiro yiucamasiñumi: “‘Yʉre ajirã ñaboarine, ajimasibeticõa ñarʉarãma. Yʉ yiĩosere ĩarã ñaboarine, “To bajiro bajisere yigʉ yatique ĩ”, yiĩamasibeticõa ñarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ado bajiro bajirã ñari, yʉ yere ajimasimena ñarãma ĩna: Gãmo gojeri tusubeti, to yicõari, caje ĩamenare bajiro bajirãma. To bajiro yʉ yijama, “Yʉ yere tʉoĩarʉamena ñaama” yigʉ yaja yʉ. To bajirã ñari, tire quẽnaro ajimasibeama. Yʉ yere ĩna tʉoĩarʉajama, tire ajimasicõari, yʉ bojarore bajiro tʉoĩavasoacõari, yʉre sẽnirʉ̃cʉbʉoborãma ĩna. Yʉre ĩna sẽnijama, yʉre ĩna cãmotadicõa tʉjaborotire ĩnare yirẽtobosabogʉja yʉ’, yigotiami Dios”, yiucamasiñumi Isa'ias ñamasir'i. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Variquẽnaña mʉama. Yʉ yiĩosere tʉoĩacõari, yʉ bojarore bajiro tʉoĩavasoariarã ñari, tire yʉ gotimasiosere ajimasiaja mʉama. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Riojo mʉare gotiaja yʉ. Tirʉ̃mʉjʉ jãjarã Diore gotirẽtobosamasiriarã yucʉ mʉare yʉ yiĩosere ĩarʉamasiboayuma. Yʉ gotimasiosere mʉa ajisere ajirʉamasiboayuma. To bajiri mʉama, jairo yʉ yiĩosere masirã ñari, to yicõari, yʉ gotimasiosere ajirã ñari, variquẽnaña mʉa —yʉare yicami Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Quẽna ado bajiro goticami Jesús: —Ado bajise tʉoĩacõari, oterimasʉ ĩ bajire quetire gotibʉ yʉ: Quẽnaro ajiya mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ote aje, maajʉ vẽjaquearere, minia ĩna barere yʉ yijama, “Ʉjʉ Dios yarã quẽnaro ĩ yirona ĩna ñarʉajama, ado bajiro yiroti ñaja” yʉ yigotimasiosere ĩna ajiboasere, vãtia ʉjʉ ejacõari, guaro ĩ masiriosere yigʉ yibʉ yʉ —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","—Gʉ̃ta joejʉ vẽjaqueacõari, guaro judibʉcʉaboarere, muiju ĩ asisĩorere yʉ yijama, yʉ yere ajicõari, quẽnaro variquẽnase rãca ajirã ñaboarine, yoaro mene tire ĩna quejerotire, to yicõari, yʉ gotisere ajirã ĩna ñajare, gãjerã rojose ĩnare ĩna yijama, yoaro mene yʉ ocare ĩna ajitʉjarotire yigʉ yibʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jotayucʉ́ vatoajʉ vẽjaqueacõari, judiboarere jotajʉa ti bʉcʉaveorere yʉ yijama, yʉ gotisere ajirã ñaboarine, adi macarʉcʉro ti bajisejʉare tʉoĩarejairã ñari, to yicõari, gajeyeũni bojatʉoĩarã ñari, yʉ yejʉare tʉoĩatʉjacõari, yʉ bojarore bajiro yimenare yigʉ yibʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sita quẽnarojʉ vẽjaqueare judibʉcʉacõari, quẽnase rica cʉtirere cojotõ cien ñaricari, gajetõ sesenta ñaricari, gajetõ treinta ñaricari rica cʉtirere yʉ yijama, yʉ gotimasiosere ajimasicõari, Dios ĩ bojarore bajiro quẽnaro yirã yʉ ocare ĩna gotimasiose sʉori, gãjerã masa quẽne yʉre ĩna ajitirʉ̃nʉrotire yigʉ yibʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","“Masare Dios ĩ beserirʉ̃mʉ ti ejaro ado bajiro bajirʉaroja” yigʉ, gaje queti gotimasiocami Jesús: —Sĩgʉ̃ ĩ ya vesejʉ trigo ajere otegʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ĩ otero bero, ĩre moabosarimasa ĩna cãnitoye, ĩ ya vese ejacõari, vidi oterudigʉmi, ĩre ĩategʉ ñari. To yigajano, vacoacʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","To bajiri trigo ti judibʉcʉato, vidi quẽne ruyuaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","To bajisere ĩacõari, ĩna ʉjʉre gotirã vanama ĩna. Ĩ tʉ ejacõari, ado bajiro yirãma: “Yʉa ʉjʉ, ¿no yiro trigo rĩne mʉ otecati ñaboarine, vidi quẽne judiri?”, yirãma, ĩna ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","To ĩna yijare, “Sĩgʉ̃ yʉre ĩategʉ oterimi”, ĩnare yigʉmi ĩ. To ĩ yirone, “¿Ado cõrone yʉa vʉerearã vatire bojati mʉ?”, ĩre yisẽniĩarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","To ĩna yisere ajicõari, ado bajiro ĩnare yigʉmi ĩna ʉjʉ: “¡Vʉebesa maji! Mʉa vʉejama, ote rãcane vʉecõarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trigo rãca bʉcʉacoajaro maji. Ti rica cʉti bʉcʉaro ĩacõari, tire jua bajirãne vʉereacõari, soereacõarʉarãja mʉa. Trigore juacõari, tire cũriavijʉ cũcõarʉarãja mʉa”, ĩnare yirotigʉmi oterimasʉ —yigotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Quẽna ado bajiro gotimasiocami Jesús: —“Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõagʉ̃, yʉ gotimasiosere no bojarã ĩna ajitirʉ̃nʉjama, mʉare yʉ gotisere mojoroaca ajimasiboarine, rojose ĩna ñare cʉtisere tʉoĩavasoacõari, tocãrãcarʉ̃mʉri quẽnaro ñamʉjarʉ̃gʉ̃cõari, quẽnaro ajimasimʉjarʉ̃gʉ̃jama, ado bajiro bajirʉaroja: Sĩgʉ̃ ĩ ya vesejʉre mostaza ajea otegʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gajeye ote aje rẽtoro rʉjaricaca ñaroja ti mostaza ajeaca. To bajiri ĩ oterica mojoricaca ñaboarine, ti judibʉcʉacoajama, ote yucʉ́ri rẽtobʉsaricʉ jairicʉ ñaroja tiʉ. Jairicʉ ti ñajare, tiʉ rʉjʉrijʉ minia ĩna ria cʉtirotijʉrire quẽnorãma ĩna —yigotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Quẽna ado bajiro gotimasiocami Jesús: “ ‘Rotimʉorʉ̃gõrʉcʉja mʉ’ yigʉ, Dios ĩ cõagʉ̃, yʉ gotimasiosere no bojarã ĩna ajitirʉ̃nʉjama, mʉare yʉ gotisere mojoroaca ajimasiboarine, rojose ĩna ñare cʉtisere tʉoĩavasoacõari, tocãrãcarʉ̃mʉri quẽnaro ñamʉjarʉ̃gʉ̃cõari, quẽnaro ajimasimʉjarʉ̃gʉ̃jama, ado bajiro bajirʉaroja” yigʉ, gaje gotimasiore queti goticami: —Rõmio, pan quẽnogoago, trigo vetare idiaji vasãcõari, pan ũmato vauvasere vʉogomo so. To so yijare, jairo vauvaroja ti. Tire bajirone bajirʉaroja, Diore rotibosagʉre yʉre ajitirʉ̃nʉrã jãjarãbʉsa mʉa bʉjʉroti —ĩnare yigotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gotimasiore queti rãca rĩne ĩnare gotimasiorũgũcami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Diore gotirẽtobosarimasʉ, “Ado bajiro bajirʉaroja” ĩ yimasire ti ñajare, to bajise gotimasiorũgũcami. Ado bajiro ucamasiñumi Diore gotirẽtobosarimasʉ: “Masare ĩnare gotigʉ, gotimasiore queti tʉoĩacõari, ĩnare gotimasiorʉcʉmi. To bajiro yigʉ, adi macarʉcʉro ti ruyuaroto rĩjorojʉne masiñamanicoadirere gotimasiorʉcʉmi”, yiucamasiñumi Diore gotirẽtobosarimasʉ Jesúre tʉoĩa yugʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","To bajiro yigotigajanocõari, “Vijʉ vacʉ yaja yʉ”, yisãjacoacami. To ĩ yi vatone, ĩre sʉyasãjacajʉ yʉa quẽne. Sãjaejacõari, ado bajiro ĩre sẽniĩacajʉ yʉa, ĩ buerimasa: —Vidi judire quetire, “Ado bajiro yigʉ, to bajise yibʉ yʉ”, yʉare yigotiya —Jesúre ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","To bajiro yʉa yijare, ado bajiro yʉare goticami Jesús: —Trigo oterimasʉre yigʉ, yʉ masune yigʉ yibʉ yʉ, Dios ĩ roticõacacʉre yʉ yijama. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ĩ ya vesere yʉ yijama, adi macarʉcʉro mani ñarojʉre yigʉ yibʉ yʉ. Trigore yʉ yijama, yʉ yarãre quẽnaro Dios ĩ yirãre yigʉ yibʉ. Vidire yʉ yijama, vãtia ʉjʉ, Satanás ĩ bojarore bajiro yirãre yigʉ yibʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Vidi oterudirimasʉre yʉ yijama, vãtia ʉjʉ Satanáre yigʉ yibʉ. Trigo ti bʉcʉatojʉ ĩna juarere yʉ yijama, adi macarʉcʉro ti jedirotire yigʉ yibʉ. Trigo ti bʉcʉaro, juarimasare yʉ yijama, ángel mesare yigʉ yibʉ, yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Vidi juacõari, ĩna soerearore bajiro bajirʉaroja adi macarʉcʉro ti jedirojʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","To cõrone, Dios ĩ roticõacacʉ, Diore rotibosagʉ, ángel mesare cõarʉcʉja yʉ. “Yʉ yarã vatoajʉ ñacõari, rojose yirãre, to yicõari, rojose ĩnare ũmato yirãre quẽne juaáya” yigʉ, ĩnare cõarʉcʉja. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ĩnare juacõari, jeame yatibetimejʉ reacõarʉarãma ĩna. Tojʉ ñacõari, bʉto rojose tãmʉorã ñari, guji põguẽ, oti, yirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ángel mesa, ĩnare ĩna reagajanoro bero, ado bajiro bajirʉarãja mʉa: Mani jacʉ, “Quẽnase yirã ñaama” ĩ yiĩarã ñari, muiju ĩ busurore bajiro busurʉarãja. Tire mʉa ajimasirʉajama, quẽnaro tʉoĩaña —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Quẽna ado bajiro yʉare goticami Jesús: —Dios yarã quẽnaro ĩ yirã mʉa ñase bʉto quẽnaja ti. To bajiro ti bajijare, sĩgʉ̃ bʉto vaja cʉtise bʉjagʉre bajiro bajirãma Dios yarã ñarʉarã. Sĩgʉ̃ yere bʉto vaja cʉtisere sita vatoajʉ ĩ yayioboarere bʉjagʉmi gãji. Tire bʉjacõari, quẽna tijʉne tudiyayiocũgʉ̃mi. To bajiri, “Jairo vaja cʉti ñaja” yivariquẽnagʉ̃ ñari, ĩ gajeyeũni ñaro cõrone gãjerãre ĩsijeocõagʉ̃mi, gãjoa bʉjarʉ. To yicõari, ti gãjoa rãca ti sita ʉjʉre vaja yigʉmi, sita vatoajʉ jairo vaja cʉtise ĩ bʉjarere cʉorʉ. Tire bajiro bajirãma Dios yarã ñarʉarã. “Adi macarʉcʉroaye jediro yʉ tʉoĩa bojaboase rẽtoro quẽnase ñaja Dios ye” yitʉoĩacõari, jediro ĩ bojarore bajiro yirũgũrãma —yʉare yigotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ti vãmere bajiro gaje queti ado bajiro yʉare goticami Jesús: —Dios yarã quẽnaro ĩ yirã mani ñase quẽnaja ti. To bajiro ti bajijare, bʉto vaja cʉtia perla vãme cʉtiare bʉjagʉre bajiro bajirãma Dios yarã ñarʉarã. Sĩgʉ̃ gajeyeũni ĩsicudirimasʉ, perla vãme cʉtire sẽnicudigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","To yicudigʉne, gãji ĩ cʉoricare quẽnamasuricare bʉjagʉmi yuja. To bajiri tiare bʉto bojagʉ ñari, ĩ gajeyeũni jedirore ĩsicõari, vaja sẽnigʉ̃mi, gãjoa bʉjarʉ. To yicõari, ti gãjoa rãca ĩ bojaricare vaja yigʉmi yuja. Tire bajiro bajirãma Dios yarã ñarʉarã. “Adi macarʉcʉroaye jediro yʉ tʉoĩa bojaboase rẽtoro quẽnaja Dios ye” yitʉoĩacõari, jediro ĩ bojarore bajiro yirũgũrãma —yʉare yigotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Quẽna gotimasiore queti yʉare gotimasiocami Jesús: —Masare Dios ĩ beserirʉ̃mʉ ti ejaro, vai sĩarimasa vaire ĩna beseriarore bajiro bajirʉaroja. Vai sĩarimasa bajiʉ rãca ĩna vayaro, vai vãme cʉtirã ñaro cõro sãjarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ĩna sãjaro ĩacõari, jabuajʉ ĩnare tʉ̃amocũrãma. Ĩnare beserãma. Bariarãrema jibʉjʉ juasãcõari, bayamanare reacõarama. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","To bajirone bajirʉaroja macarʉcʉro ti jediro. Ángel mesa, masare beserã vadirʉarãma. Quẽnarãre, rojorãre beserʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Rojorãre ĩnare juacõari, jeame yatibetimejʉ reacõarʉarãma. Tojʉ ñacõari, bʉto rojose tãmʉorã ñari, guji põguẽ, oti, yirʉarãma ĩna —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tire yʉare gotigajanocõari, ado bajiro yʉare sẽniĩacami Jesús: —¿Tire mʉare yʉ gotimasiose queti jedirore ajimasiati mʉa? —yʉare yisẽniĩacami. —Ajimasiaja —ĩre yicʉdicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","To bajiro yʉa yijare, ado bajiro yʉare goticami: —To bajiri Dios oca masa ĩna ucamasire quẽnaro riojo gotimasiomasicõarãja mʉa. To yicõari, mʉare yʉ gotimasiosere ajimasirã ñari, tire quẽne quẽnaro riojo gotimasiomasirãja. To bajiro mʉa bajijama, vi ʉjʉ gajeyeũni tirʉ̃mʉjʉ ñarere quẽne, mame ĩ juarere quẽne quẽnocũr'ire bajiro bajirãja mʉa. Ĩ ya viana ĩna cʉobetijama, ĩnare ĩsigʉ̃mi. Ĩ yirore bajirone mʉa yarãre quẽne ĩna ajimasiroti ti rʉyajama, tirʉ̃mʉayere, to yicõari, yucʉ yʉ gotisere quẽne quẽnaro riojo ĩnare gotimasiorʉarãja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","To bajiro yʉare gotimasio gajano, yʉare ũmato vacoacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","To bajivana, ĩ ya macajʉ ejacajʉ yʉa. Tojʉ Dios ocare ĩna buerivijʉre sãjaejacõari, masare gotimasio ñacami. Quẽnaro ĩ gotimasiosere ajicõari, no yimasibeticama ĩna: —¿No bajicõari, to bajise gotimasiomasiati ĩ? ¿No bajiro yicõari, ĩaĩañamanire yati? ");
INSERT INTO bsnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Adi macagʉ yucʉ́ moarimasʉ macʉ me ñatique ĩma? ¿Mar'ia macʉ me ñatique? ¿Santiago, José, Simón, Judas mesa gagʉ me ñatique ĩ? ");
INSERT INTO bsnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","To yicõari, jediro mani vatoajʉ ñarã, ¿ĩ bederã rõmiri me ñatique ĩna? To bajiri, ¿nojʉ bueyujari ãni? —Jesúre ĩre yicama ĩna, ĩ ya macana. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","To bajiri, “Ñamasugʉ̃ me ñaami. Mani ya macagʉ mani masigʉ̃ ñaami” yirã ñari, ĩre ajitirʉ̃nʉbeticama ĩna. To ĩna yirone, ado bajiro ĩnare goticami Jesús: —Diore gotirẽtobosarimasʉ gajerojʉ Dios ocare ĩ gotimasiocudijama, ĩre ajirʉ̃cʉbʉorãma. To bajiboarine, ĩ ya macanare, ĩ ya vianare quẽne Dios ocare ĩ gotimasiojama, ĩre ajirʉ̃cʉbʉomenama —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","To bajiri ĩ ya macana, ĩre ĩna ajitirʉ̃nʉbetijare, ĩaĩañamanire jairo yiĩomasibeticami. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Cojorʉ̃mʉ Galilea sitana ʉjʉ, Herodes vãme cʉtigʉ, ĩaĩañamani Jesús ĩ yiĩose quetire ajiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","To ĩ yiñasere ajicõari, ĩre moabosarimasare ado bajiro yiyuju: —Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉne, ñagʉ̃mi quẽna. Rijacoaboarine, tudicaticoarimi. To bajiri ĩaĩañamani yiĩoñagʉ̃mi ĩ —yitʉoĩaboayuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Juan ĩ sĩaecoroto rĩjoro ado bajiro bajire ti ñajare, to bajiro tʉoĩañuju Herodes: Ĩ bedi Felipe manajore Herod'ias vãme cʉtigore ẽmacõari, manajo cʉtiyuju Herodes. To bajiro ĩ yire ñajare, ado bajiro ĩre gotirũgũñuju Juan: —Herod'iare mʉ manajo cʉtise quẽnabeaja. Dios ĩ rotimasirere ajibeaja mʉ —ĩre yirũgũboayuju Juan. Tire ajirʉabesuju ĩ manajo Herod'ias. To bajiri Juanre cõmemane siacõari, tubiberotiyuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","To yicõari, ĩre sĩarotirʉaboayuju. “Diore gotirẽtobosarimasʉ ñaami Juan” masa ĩna yirʉ̃cʉbʉosere ajigʉ ñari, bʉto güiyuju. To bajiri ĩre sĩarotimasibesuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodes ĩ ruyuariarʉ̃mʉ ejayuju. To bajiri, masare jirẽoñuju ĩ, “Boserʉ̃mʉ yito” yigʉ. To yicõari, ĩna rẽjaro bero, Herod'ias maco, ĩna ĩaro rĩjorojʉare basaĩoñuju. So basasere ĩacõari, bʉto variquẽnañuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","To bajiri, —Riojo mʉre gotiaja yʉ. Tʉoĩavasoabetirʉcʉja. No bojase mʉ sẽnijama, mʉre ĩsirʉcʉja —sore yiyuju ĩ Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","To bajiro ĩ yisere ajicõari, so jacojʉa, “Ado bajiro ĩre yicʉdiya” so yi ocasãjare, ado bajiro Herodere cʉdiyuju so: —Yucʉacane Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ rʉjoare, bare jeobariabaja joejʉ jeocõari, yʉre ĩsigʉ̃ vayá —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","To bajiro so yisere ajicõari, sʉtiritiyuju Herodes. To bajiboarine, ĩ jicõariarã ĩna ajiro rĩjorojʉa, “Riojo mʉre gotiaja yʉ. No bojase mʉ sẽnijama, mʉre ĩsirʉcʉja” ĩ yicõare ti ñajare, so sẽnirore bajirone yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tubiberiavijʉ ñagʉ̃re, “Juanre rʉjoa jataya”, ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","To bajiri, ĩ rʉjoare bare jeobariabaja joejʉ jeocõari, Herod'ias macore ĩsiñujarã ĩna. To yicõari, sojʉa, jacore ĩsirẽtoñuju so yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ti queti ajicõari, Herodes tʉjʉ ejayujarã, Juan buerimasa. Ejacõari, ĩ rujʉri ñaboarere ãmivacõari, yujeyujarã. To ĩna yiro bero, yʉa tʉ ejacama ĩna, Jesúre gotirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan oco rãca bautizarimasʉre ĩna sĩare quetire ajicõari, jãjarã masa yʉare ĩna sʉyajare, ĩna rãca ñarʉabecʉ ñari, cũmuajʉ vasãja, yʉare ũmato jẽacoacami, masa ĩna manibʉsarojʉ yʉare ũmato vacʉ. To bajiri ti macariana Jesús ĩ vasere ajicõari, boejʉ jãjarã variarãma, Jesús ĩ ejarotijʉre vana. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","To bajiri rocatu ejarãne, jãjarã masa ñarãre ĩacajʉ yʉa, boejʉ vacõari ejariarãre. Ĩnare ĩamaicõari, rijaye cʉtirãre ĩna juaejarãre catiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Rãioroto rĩjoro, ĩ tʉ ejacõari, ado bajiro yicajʉ yʉa, ĩ buerã: —Jẽre rãioato yaja. Masa manojʉ ñaja. To bajiri ĩnare varotiya mʉ, “Masa cʉtojʉ bare vaja yibarã vajaro” yirã —ĩre yiboacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","To yʉa yisere ajicõari, ado bajirojʉa yʉare yicami Jesús: —No yirã vamenama. Mʉane ĩnare bare ecaya —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","To ĩ yijare, ado bajiro ĩre yicʉdicajʉ yʉa: —Bare maja yʉare quẽne. Cojomo cõro pan, jʉarã vai cʉoaja yʉa —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","To bajiro yʉa yisere ajicõari, ado bajiro yicami: —Adojʉa tire juaya maji —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","To bajiri, —Masare tatũcurojʉ ĩnare rujirotiya —ĩ buerãre yʉare yicami Jesús. To yicõari, cojomo cõro ñaricari pan, jʉarã vai ñarãre juacõari, õ vecajʉa ĩamʉocami. To yicõari, “Quẽnaro yaja mʉ”, Diore ĩre yicami. To yicõari, tire iguesurebatecõari, ĩ buerãre yʉare ĩsicami. To bajiri yʉajʉa, rujirãre ĩsibatocajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sĩgʉ̃ rʉyariaro mano quẽnaro baʉsʉcʉtijedicõacama ĩna. Ĩna bagajanoro bero, ĩna barʉasere, yʉa juarẽojama, jʉaãmo cõro, gʉbo jʉa jẽnituaro ñarijibʉri rʉyacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tire bacana cinco mil ʉ̃mʉa ñacajʉ yʉa. Rõmiare, rĩamasare quẽne cõĩabeticajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cũmuajʉ yʉare vasãjaroticami Jesús. “Yʉre jẽadiyuya. Maji masare tudirotigʉ yaja yʉ”, yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ĩnare tudirotigajano, burojʉ majacoasuju, tojʉ Diore sẽnirʉ. Ti rãioato bero, tojʉ ĩ sĩgʉ̃ne ñacõañuju ĩ maji. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yʉajʉama, ʉtabʉcʉra jẽana, sõjʉ tira gʉdareco tʉsacajʉ yʉa. To yʉa tʉsatone, bʉto mino vacajʉ. To bajica yiro, sabetʉocõacajʉ ti. To bajiri jẽatĩmabeticajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","To yʉa bajiñarone, busurocaroarijaʉ yʉa tʉjʉ oco joene vadicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Oco joejʉ ĩ vadire ĩarãne, ʉcacajʉ yʉa. —¡Bajirocar'i vãti ñaami! —yiavasãcajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","To yʉa yiboajaquẽne, —Güibesa. Variquẽnaña mʉa. Yʉne ñaja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","To ĩ yisere ajicõari, yʉa rãcagʉ Pedro ado bajiro ĩre yicʉdicami: —Yʉ ʉjʉ, mʉne mʉ ñajama, oco joene mʉ tʉjʉ yʉre varotiya —ĩre yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","To ĩ yisere ajicõari, —Vayá mʉ —ĩre yicami Jesús. To ĩ yisere ajicõari, vãgã, oco joejʉ vacami Pedro, Jesús tʉ ejagʉacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","To bajiboarine, mino bʉto ti vasere ĩacõari, güicami. To bajicõari, rujacõa sʉoacami yuja. To bajigʉne, —Yʉ ʉjʉ, rujacʉ yaja yʉ. Yʉre ejarẽmogʉaya —yiavasãcami. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","To ĩ yirone, ĩ ãmore ñiacõari, ado bajiro ĩre yicami Jesús, Pedrore: —¿No yigʉ, “Ĩ ejarẽmose rãca vamasirʉcʉja yʉ”, yʉre yitʉoĩa tʉjacoajari mʉ? —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","To yicõari, cũmuajʉ ĩna vasãjarone, mino vatʉjacoacajʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","To yicõari, cũmuajʉ Jesús rĩjorojʉa gʉsomuniari tuetucajʉ yʉa, ĩre rʉ̃cʉbʉorã: —Socagʉ me ñaja mʉ. Dios macʉne ñaja —Jesúre ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","To baji jẽanane, Genesaret vãme cʉti sitajʉ ejacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti macariana Jesús ĩ ejasere ĩamasicõari, masa jedirore gotibatoriarãma. To bajiri, masa rijaye cʉtirãre juaejacama Jesús tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","To ĩna yirã, ado bajiro Jesúre yicama ĩna: —Mʉ ye sudi gaja yʉare moaĩarotiya. Ti rĩne bojaja yʉa. To bajiro yʉa yijama, caticoarʉarãja yʉa —ĩre yisẽnicama. To bajiri, ĩ sudi gajare moaĩarãma, caticoacama. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseo masa, to yicõari Dios ĩ rotimasire gotimasiorimasa quẽne ejacama, Jesús tʉjʉ. Jerusalénjʉ vadiriarã ñacama. Jesús tʉ ejacõari, ado bajiro ĩre sẽniĩacama ĩna: ");
INSERT INTO bsnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿No yirã mani ñicʉa ĩna yimasiriarore bajiro yibeati mʉ buerimasa? Ĩna baroto rĩjoro, ĩna ãmori coemasiriarore bajiro coebeama ĩna —ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","To bajiro ĩna yijare, ado bajiro ĩnare cʉdicami Jesús: —Mani ñicʉa ĩna rotimasirejʉare cʉdirã ñari, Dios ĩ rotimasusejʉarema cʉdibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ado bajiro gotiaja Dios ĩ rotimasire: “Mʉ jacʉre, mʉ jacore quẽnaro rʉ̃cʉbʉoya”. To yicõari, gaje vãme ado bajiro yaja: “No bojagʉ, ĩ jacʉre, ĩ jacore, ‘Rojose tãmʉoʉcarʉarãja mʉa’ ĩnare ĩ yijama, ĩre sĩaroti ñaja”, yigotiaja Dios ĩ rotimasire. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mʉajʉama, ado bajirojʉa rotiaja mʉa: “Ĩ ye rãca ĩ jacʉare ĩ ejarẽmobetijama, quẽnacõaja. ‘Yʉ gajeyeũni yʉ cʉose Diore yʉ ĩsiroti rĩne ñaja. To bajiri mʉare ejarẽmomasibeaja yʉ’ yicõari, ĩ jacʉare ĩ ejarẽmobetijama, quẽnacõaja”, yirotiaja mʉa. To bajiro mʉa yijama, mani ñicʉa ĩna rotimasirejʉare cʉdirã ñari, Dios ĩ rotisejʉarema cʉdibeaja mʉa. To bajiro mʉa yijama, “Ñie vaja maja Dios oca”, yirã yaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Quẽnaro yirã ñaja yʉa” yiboarine, rojorã ñaja mʉa. Diore gotirẽtobosarimasʉ, Isa'ias ñamasir'i, mʉa bajirotire quẽnaro tʉoĩacõari, ado bajiro ucamasiñumi: ");
INSERT INTO bsnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ĩna oca masune yirã, quẽnaro yʉre yirʉ̃cʉbʉoama ĩna. To bajiro yirã ñaboarine, yʉ bojarore bajiro tʉoĩabeama. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yʉ yere buecõari, ĩna masu ĩna tʉoĩasere gotimasioama. Tirene, ‘Dios ĩ rotise ñaja’ yiboama. To bajiri, yʉre ĩna rʉ̃cʉbʉoboase vaja, ñie vaja bʉjamenama ĩna”, yiucamasiñumi Isa'ias, Diore gotirẽtobosagʉ —yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","To ĩ yiro bero, masare jicõari, ado bajiro ĩnare yicami Jesús: —Yʉre ajicõari, quẽnaro ajimasiña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dios ĩ ĩajama, mani ñicʉa ĩna yimasiriarore bajiro ãmo coemenane mani base sʉori me rojose yirãja mani. Rojose tʉoĩacõari, rojose mani ñagõsejʉa ñaja rojose mani yise. “Ti sʉorine rojose tãmʉorʉarãja mani”, yimasirona ñaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","To bajiro Jesús ĩ yisere ajicõari, ado bajiro ĩre yicajʉ yʉa: —¿Tire mʉ gotisere fariseo masa mʉre ĩna ajijũnisinisere masibeati mʉ? —ĩre yicajʉ yʉa, ĩ buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","To bajiro yʉa yiro, ado bajiro yʉare yicami Jesús: —Ĩ ya vesejʉ ote ĩ otere tʉ vidi ti judijama, ti ñe rãcajʉne vʉereacõarʉcʉmi. To bajirone yirʉcʉmi yʉ jacʉ quẽne. “Yʉ yarã me ñaama” yigʉ ñari, ĩnare reacõarʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","To bajiri fariseo masare tʉoĩagüibesa mʉa. Ĩna ñarãma ĩamena gãjerã ĩamenare tʉ̃a vanare bajiro bajirã. Sĩgʉ̃ ĩabecʉ, gãji ĩabecʉre ĩ tʉ̃avajama, gojejʉ reasãcõanama ĩna jʉarãjʉne. To bajiri rojose ĩna bajirotire masirã ñari, ĩnare tʉoĩagüibesa mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","To ĩ yirone, ado bajiro ĩre yicami Pedro: —Mʉ gotimasiosere quẽnaro yʉare gotirẽtobuya —ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","To ĩ yisere ajicõari, —¿Ajimasibeati mʉa quẽne? —yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","18","—Mʉa basãse mʉa gʉdajoajʉ vatoja ti. Tijʉ bero, rẽtobudiroja ti. To bajiri mʉare rojose yimasibeaja ti. To bajiboajaquẽne, mʉa ñagõjama, tʉoĩacõari, ñagõaja mʉa. To bajiri rojose mʉa tʉoĩajama, ti sʉorine rojose tãmʉorʉarãja mʉa. ¿Tire quẽnaro ajimasibeatique mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Masa, rojose tʉoĩacõari, ado bajise rojose yirãma: Gãjerãre sĩarãma ĩna. Manajo cʉtirã, manajʉ cʉtirã, manajo mana, manajʉ mana quẽne, gãjerã rãca ajeriarã cʉtirãma. Juarudirãma. Socarãma ĩna. Gãjerã ajiro rĩjorojʉa, socarãne, “Ado bajise rojose yima”, yigotirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","To bajise rojose yirãma masa, rojose tʉoĩacõari. Ti sʉorine rojose tãmʉorʉarãma. Baroto rĩjoro, ãmori mani ñicʉa ĩna coemasiriarore bajiro coebeti sʉori me, rojose tãmʉorʉarãma masa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Gotigajanocõari, yʉare ũmato vacoacami Jesús, Tiro, to yicõari Sidón vãme cʉti macari tʉjʉ vana. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tojʉ yʉa ejaro bero, sĩgõ cananeo maso, Jesús tʉjʉare avasã vadicamo so: —Yʉ ʉjʉ, David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉre ĩamaiña. Yʉ maco so ʉsʉjʉ vãti sãñagõ ñaamo. To bajiri bʉto rojose tãmʉoamo —Jesúre yigoticamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","To bajiro so yiboajaquẽne, sore cʉdibeticami Jesús. To bajiri ado bajiro Jesúre yicajʉ yʉa, ĩ buerimasajʉama: —Sore varotiya mʉ. Gõjanabioro manire avasã sʉyaamo —ĩre yiboacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","To bajiro yʉa yirone, ado bajiro sore yicami Jesús: —Yʉ yarã jud'io masa, oveja mavisiarãre bajiro bajirãma. Ĩnare yʉre ejarẽmoroticõacami Dios —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","To bajiro ĩ yisere ajicõari, ĩ rĩjorojʉa gʉsomuniari tuetuejacamo so, ĩre rʉ̃cʉbʉogo. To yicõari, ado bajise ĩre yicamo: —Yʉ ʉjʉ, yʉre ejarẽmoña —ĩre yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","To bajiro so yiboajaquẽne, ado bajiro sore yicami Jesús: —To bajiro yʉ yijama, rĩamasa ĩna basere ẽmacõari, yaiare ecagʉre bajiro yigʉja yʉ —sore yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yicamo so: —Yʉ ʉjʉ, riojo gotiaja mʉ. To bajiboarine ĩna ʉjarã ĩna bavẽjasere barãma yaia —Jesúre ĩre yicamo so. “Yʉa quẽne, jud'io masa me ñaboarine, mojoroaca yʉare mʉ ejarẽmojama, quẽnaja” yigo, to bajise ĩre yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","To bajiro so yisere ajicõari, ado bajiro sore yicami Jesús: —“Yʉre ĩamaicõari, ejarẽmorʉcʉmi”, yʉre yitʉoĩa tʉjabeco masu ñaja mʉ. To bajiro mʉ yitʉoĩase ñajare, mʉ maco ʉsʉjʉ sãñagʉ̃re vãtire ĩre burocacõaja yʉ —sore yicami Jesús. To bajiro ĩ yirirĩmarone, quẽnaejacoasuju so, vijʉ ñario. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","To ĩ yiro bero, Galilea vãme cʉtirita tʉjʉ vacajʉ yʉa, Jesúrãca. Tojʉ ejacõari, burojʉ majacajʉ. Tojʉ maja, joe jeaejacõari, ejarũjucoacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","To yʉa bajiro ĩacõari, Jesús tʉre jãjarã masa ejacama, rijaye cʉtirãre juaejarã. Ĩna juaejacana ado bajiro bajirã ñacama: Rujasagueri vana, jeariarã, ĩamena, ñagõmena, to yicõari, jãjarã gajeye rijaye cʉtirã ñacama. Ĩ tʉ ĩna ejarone, ĩnare catiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ñagõmena ñaboariarã, ñagõcoacama. Rujasagueri vaboariarã, quẽnaro vacama. Ĩamena ñaboariarã, ĩacoacama. Jeariarã quẽne, quẽnaejacoacama. To bajiro bajisere ĩacõari, no yimasibeticama masa, ti ũnire ĩabetirũgũriarã ñari. To bajiri Diore quẽnaro rʉ̃cʉbʉo variquẽnacama ĩna, “Ĩ ñagʉ̃mi quẽnaro yigʉ, jud'io masa yʉa rʉ̃cʉbʉogʉ” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ĩ buerãre yʉare jicõari, ado bajiro yicami Jesús: —Ado ñarãre ĩamaiaja yʉ. Idiarʉ̃mʉ tʉsajʉ yuja, yʉ rãca ĩna ñaro. To bajicõari, bare maama. Bamenane ĩna ya virijʉ ĩna tudiasere bojabeaja yʉ. Ĩnare yʉ tudirotijama, bamenane ĩna vajama, varũtu vanane, ñiorijarã ñari, rijavẽjaborãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","To bajiro ĩ yirone, ado bajiro ĩre yicajʉ yʉa: —Ado, masa manojʉ ñaja. No bajiro masa ñaro cõro ĩna barotire bare bʉjamasiña manoja —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","To yʉa yirone, —¿No cõro jairo pan cʉoati mʉa? —yʉare yicami. —Cojomo cõro jʉa jẽnituaro ñaricari ñaja. To yicõari, vai mojoroaca ñaama —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","To yʉa yirone, rʉ̃cacane masare rujiroticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","To yicõari, pan cojomo cõro jʉa jẽnituaro ñaricari ñasere, vaire quẽne juacõari, “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽnacami. To yicõari, tire iguesurebatecõari, yʉare ĩsicami. To bajiri yʉajʉa, rujirãre ĩnare ĩsibatocajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sĩgʉ̃ rʉyariaro mano baʉsʉcʉtijedicõacama. Ĩna bagajanoro bero, ĩna barʉasere yʉa juarẽojama, cojomo cõro jʉa jẽnituaro ñarijibʉri rʉyacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tire bacana cuatro mil ʉ̃mʉa ñacajʉ yʉa. Rõmiare, rĩamasare quẽne cõĩabeticajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","To yigajanocõari, masare tudiroticami Jesús. To baji, cũmuane Magadán vãme cʉti macajʉ vacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo masa, saduceo masa quẽne, Jesúre ĩarã ejacama ĩna. Ejacõari, ĩre sẽniĩacama, “Cʉdimasibeticõari, rojose tãmʉoato ĩ” yirã: —“‘Dios ĩ cõagʉ̃ ñaami’ yʉre yimasiato” yigʉ, õ vecaye ĩaĩañamani yʉare yiĩoña —yisẽniboacama. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","To ĩna yiboajaquẽne, ado bajiro ĩnare cʉdicami Jesús: —Rãiorijʉ, ʉ̃mʉagasero ti sũaro ĩacõari, “Busiyʉ, quẽnarirʉ̃mʉ ñarʉaroja”, yaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Busurijʉ ñibiacõari, bueri ti sũayujijama, “Adirʉ̃mʉ, oco quedirʉaroja”, yiĩamasiaja mʉa. No bojarirʉ̃mʉ, ʉ̃mʉagaserore ĩacõari, “Quẽnarirʉ̃mʉ, rojorirʉ̃mʉ ñarʉaroja”, yiĩamasiaja. To bajiro yiĩamasirã ñaboarine, ñamasusejʉare ĩamasibeaja mʉa. Adirʉ̃mʉri yʉ yisere ĩarã ñaboarine, “Dios ĩ roticõar'i ñari, yami”, yiĩamasibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mʉa adirodoriana, rojose yirã, Diore mʉa gotirore bajiro yimena ñaja mʉa. To bajirã ñari, “Ĩaĩañamani mʉ yiĩose bojaja”, yʉre yisẽniboaja mʉa. To bajiro mʉa yiboajaquẽne, to bajise mʉare yiĩobetirʉcʉja. To bajiboarine Jonás ñamasir'i Diore gotirẽtobosarimasʉ ĩ bajimasirere bajiro mʉare bajiĩoroti ñaroja —ĩnare yicʉdicami Jesús. To bajiro ĩnare yicõa, ĩnare jẽaveocoacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ʉtabʉcʉra gajejacatʉajʉ jẽaejacõari, —Mani baroti pan masiriticoayuja mani —yʉa masune gãmerã yiñacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","To yʉa yiro, ado bajiro yʉare goticami Jesús: —Fariseo masa, saduceo masa “Pan vauvato” yirã ĩna vʉosere quẽnaro ajicõĩaña mʉa —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To ĩ yisere ajimasimena ñari, yʉa masune ado bajiro gãmerã yicajʉ yʉa: —Pan mani masiritijare, to bajise gotigʉ yigʉmi —gãmerã yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","To bajiro yʉa yitʉoĩasere masicõari, ado bajiro yʉare yicami Jesús: —¿No yirã, “Pan maja manire”, yati mʉa? “Pan ti maniboajaquẽne, manire ĩamaicõari, quẽnaro ejarẽmorʉcʉmi Jesús”, ¿yʉre yitʉoĩabeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿No yirã ajimasibeati mʉa maji? Cojomo cõro ñaricarire panre bʉjʉocõari, cinco mil masa ñarãre ecacajʉ yʉ. Ĩnare yʉ ecaro bero, jairo barʉariajibʉri rʉyacajʉ, ¿Tire masiritiati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tijʉ bero, quẽna cojomo cõro jʉa jẽnituaro ñaricari panre bʉjʉocõari, cuatro mil masa ñarãre ecacajʉ yʉ. Ĩnare yʉ ecaro bero, jairo barʉariajibʉri rʉyacajʉ. ¿Tire quẽne masiritiati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","No yirã ajimasimena masu ñamenaja mʉa tia. Jẽjʉ, “Fariseo masa, saduceo masa, ‘Pan vauvato’ yirã, ĩna vʉosere quẽnaro ajicõĩaña” yʉ yijama, “Pan juabesuma” yigʉ me yibʉ yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","To ĩ yijare, ajimasicajʉ yʉa yuja. “‘Fariseo masa, saduceo masa, “Pan vauvato” yirã ĩna vʉosere quẽnaro ajicõĩaña’ yʉare yigʉ, ‘Ĩna gotimasiosejʉare quẽnaro ajicõĩamasiña, “Ĩnare bajiro bajimavisiarobe” yirã’ yire ũnire yʉare gotimasiogʉ̃ yiboayujari Jesús”, yiajimasicajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","To yi varũtu vanane, Cesarea de Filipo vãme cʉti sitajʉre ejacajʉ yʉa, Jesúrãca. Tojʉ ejacõari, ado bajiro yʉare sẽniĩacami Jesús: —Yʉre, Dios ĩ roticõacacʉre, ¿ñimʉ ñaami yʉre yati ĩna, masa? —yʉare yisẽniĩacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdicajʉ yʉa: —Sĩgʉ̃ri, “Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ, tudicaticõari bajigʉmi quẽna”, mʉre yama ĩna. Gãjerãma, “El'ias ñamasir'i ñagʉ̃mi”, yama ĩna. Gãjerãjʉama, “Jerem'ias ñamasir'i ñagʉ̃mi”, yama. Gãjerãjʉama, “Gãji, Diore gotirẽtobosamasir'i ñagʉ̃mi”, mʉre yama ĩna —Jesúre ĩre yicʉdicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","To bajiro yʉa yirone, —Mʉama, ¿ñimʉ ñaami yʉre yati mʉa? —yʉare yisẽniĩacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","To ĩ yisere ajicõari, ado bajiro yicami Simón Pedro: —Mʉ ñaja rojose yʉa tãmʉoborotire yʉare yirẽtobosacõari, rotimʉorʉ̃gõrocʉ, Dios ĩ cõar'i. Masirẽtogʉ̃, Dios macʉ ñaja mʉ —Jesúre ĩre yicʉdicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","To ĩ yisere ajicõari, ado bajiro ĩre yicami Jesús: —Quẽnaro riojo gotiaja mʉ, Simón, Jonás macʉ. Variquẽnaña mʉ. Tire gotigʉ, masʉ ĩ masise sʉori me tire gotimasiaja mʉ. Õ vecagʉ yʉ jacʉ ĩ masise rãca tire gotimasiaja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ado bajiro mʉre gotiaja yʉ: Mʉ vãme ñaja Pedro. “Gʉ̃ta” yirʉaro yaja ti “pedro” ti yijama. Mʉ gotimasiose sʉorine jãjarã masa, yʉre ajitirʉ̃nʉcõari, rẽjarũgũrʉarãma ĩna. Yʉre ajitirʉ̃nʉrã ĩna ñajare, vãti yarã, “Bajireacõa tʉjajaro ĩna” yirã, rojose ĩnare yimasibetirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","To bajiri, ado bajiro mʉre gotiaja yʉ: Ʉ̃mʉagasero soje jãnariaro cʉogʉre bajiro mʉre cũrʉcʉja yʉ. To bajiri, masare ĩacõari, ado bajiro ĩnare yimasirʉcʉja mʉ: “Ãnoa to bajiro yirã ñari, Ʉjʉ Dios yarã quẽnaro ĩ yirã ñarʉarãma. Ãnoajʉa, to bajiro yirã ñari, Dios yarã me ñaama”, ĩnare yimasirʉcʉja mʉ. Adi sitajʉ yʉre rotibosagʉ ñarʉcʉja mʉ. To bajiro yigʉ ñari, “Ado bajiro mʉa yijama, Dios yarã ñarʉarãja mʉa. Ado bajirojʉa mʉa yijama, Dios yarã me ñarʉarãja mʉa”, yimasirʉcʉja mʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","To bajiro Pedrore ĩre yigotigajanocõari, ado bajiro yʉare yicami: —Ĩne ñaami “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i”, gãjerãre ĩnare yigotibeja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","To ĩ yiro bero, Jerusalénjʉ ĩ bajirotire ado bajiro yʉare gotimasiosʉocami Jesús: —Jerusalénjʉ varoti ñaja yʉre. Tojʉ yʉ ejaro, bʉcʉrã, paia ʉjarã, to yicõari, Dios ĩ rotimasire gotimasiorimasa quẽne, rojose yʉre yicõari, yʉre sĩarʉarãma ĩna. Yʉre ĩna sĩaboajaquẽne, idiarʉ̃mʉ tʉsatirʉ̃mʉne yʉre catiorʉcʉmi Dios —yʉare yisʉocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","To ĩ yisere ajicõari, ricati ĩre jicãmotocõari, ĩre yiboacami Pedro: —Yʉ ʉjʉ, to bajiro mʉ bajirotire bojabecʉmi Dios. ¡To bajiro mʉ bajiroti, mʉre bajibeticõato! —ĩre yiboacami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","To ĩ yisere ajicõari, jʉdarʉ̃gʉ̃gʉ̃ne, ado bajiro Pedrore ĩre goticami Jesús: —¡Satanás, vasa mʉ! Vãtia ʉjʉre ñagõbosagʉ yaja mʉ. To bajiro yibesa. “Dios ĩ bojarore bajiro yibeticõato” yigʉre bajiro yaja mʉ. To bajiro mʉ yijama, Dios ĩ tʉoĩarore bajiro me tʉoĩaja mʉ. Masa ĩna tʉoĩarore bajiro tʉoĩagʉ̃ yaja —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","To yicõari, ado bajiro ĩ buerãre yʉare yicami Jesús: —No bojagʉ yʉ yʉ ĩ ñarʉajama, ĩ bojasere ĩ ye ñarotire tʉoĩabecʉne, “Jesúre bajiro rojose tãmʉorʉcʉja yʉ quẽne” yitʉoĩacõari, yʉjʉare ajisʉyarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","No bojarã, ĩna bojaro ñare cʉtirãma, adi macarʉcʉrore ñasere ĩavariquẽnacõari, Diore tʉoĩamenama, Dios ĩ catisere yayibetire cʉomena ñarʉarãma ĩna. To bajiboarine, yʉre ajitirʉ̃nʉrã, yʉ oca ĩna gotisere ajijũnisinicõari, ĩna sĩarãma, Dios tʉ quẽnaro ñarona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sĩgʉ̃ adi macarʉcʉrojʉ gajeyeũni jediro ĩ bʉjaboajaquẽne, berojʉ rojose tãmʉotʉjabetiriarojʉ ĩ vajama, gajeyeũni ĩ bʉjaboare, ñie vaja manoja. Ñiere Diore ĩsimasibecʉmi, “Ĩ rijato berojʉma tudirijabeticõato” yigʉ, “Dios ĩ catisere yʉre ĩsiato” yigʉ. Mani rijato berojʉma “Tudirijabeticõato” yigʉ, Dios ĩ catisere ĩ ĩsise cõro vaja cʉti manoja. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉ, Dios ĩ roticõacacʉ ñacõari, “Quẽnarẽtogʉ̃ ñaja yʉ”, yʉ jacʉ ĩ yiĩorore bajiro yigʉ ñari, ĩ bususe rãca tudiejarʉcʉja yʉ. Yʉ rãca vadirʉarãma Dios ĩ cõarã, ángel mesa. Tudiejacõari, masa ĩna yisere ĩacõari, “To bajiro yirã ñari, quẽnase bʉjarã, rojose tãmʉorã bajirʉarãja mʉa”, ĩnare yirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Riojo mʉare gotiaja yʉ. Mʉa sĩgʉ̃ri mʉa bajireabetone, “Ñajediro ʉjʉ ñaami yʉ roticõacacʉ” Dios mʉare ĩ yiĩosere ĩarʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cojomo cõro, coja jẽnituarirʉ̃mʉ bero, Pedro, Santiago, ĩ bedi Juanre quẽne ʉ̃mʉariburo joejʉ ĩnare ũmato vacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tojʉ ĩna ejaro, ĩna ĩaro rĩjorojʉa, Jesús rioga busucoasuju ti. Ʉ̃mʉagʉ muijure ĩacãnamuriarore bajiro cajemose busuyuju ti. To yicõari, sudi ĩ sãñase quẽne bʉto boticoasuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","To bajicõari, Moisés ñamasir'i, El'ias ñamasir'i rãca Jesús tʉ ruyuarʉ̃gʉ̃cõari, ĩ rãca ĩna gãmerã ñagõsere ĩañujarã ĩna, Pedro mesa. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","To bajiro ĩna bajisere ĩacõari, ado bajiro Jesúre yiyuju Pedro: —Yʉ ʉjʉ, adojʉ mani ñajama, quẽnamasucõaja. Mʉ bojajama, mʉa ñaro cõrone vijãiri mʉare bʉabosarʉcʉja yʉ. Mʉ yajãi, El'ias yajãi, to yicõari, Moisés yajãi bʉabosarʉcʉja —Jesúre yiboayuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","To bajiro ĩ yirirĩmarone, bueri bʉto cajemose ĩnare buebibecõañuju ti. Ti bueri vatoajʉ ado bajiro ocaruyuyuju: —Ãnine ñaami yʉ macʉ, yʉ maigʉ̃. Ĩre bʉto ĩavariquẽnaja yʉ. Ĩre quẽnaro ajitirʉ̃nʉña mʉa —yi ocaruyuyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","To bajiro yi ocaruyusere ajicõari, bʉto güiyujarã ĩna Pedro mesa. Bʉto güirã ñari, muqueacoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","To bajiro ĩna bajisere ĩacõari, ĩna tʉ vacõari, ĩnare moaĩañuju Jesús. Ĩnare moaĩagʉ̃ne, ado bajiro yiyuju: —Vʉ̃mʉrʉ̃gʉ̃ña. Güibesa mʉa —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","To bajiro ĩ yiro bero, ĩamʉoboayujarã. El'iare, Moisére ĩnare ĩabʉjabesujarã. Jesús sĩgʉ̃ne ñañuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","To bajiro bajicõari bero, ti buro ĩnare ũmato rojacʉne, ado bajiro ĩnare rotiyuju Jesús: —Jẽjʉ mʉa ĩasere gãjerãre gotibeja maji, yʉ, Dios ĩ roticõacacʉ, yʉ rijato bero, quẽna yʉ tudicatiroto rĩjorore —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","To ĩ yijare, ado bajiro Jesúre sẽniĩañujarã ĩna: —¿No yirã, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ ĩ ejaroto rĩjoro ejarʉcʉmi El'ias ñamasir'i”, yati ĩna Dios ĩ rotimasire gotimasiorimasa? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","To ĩna yijare, ado bajiro ĩnare cʉdiyuju Jesús: —Riojo yiyuma Dios ĩ rotimasire gotimasiorimasa, “El'ias ñamasir'i ejasʉorʉcʉmi” ĩna yijama. “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ, ĩ ejaroti ñajare, “Jediro Dios ĩ bojarore bajiro yirã, quẽnaro ñayuto mani” yigʉ, ejasʉorʉcʉmi. To bajiro ĩ bajiroti ñajare, Dios ĩ rotimasire gotimasiorã, ĩna gotiri vãmere bajirone yaja Dios oca masa ĩna ucamasire quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","“To bajiro yaja” yimasirã ñaboarine, ĩ ejaro ĩre ĩamasibesuma ĩna. Jẽre ejayumi. To ĩ bajiboajaquẽne, ĩna bojarore bajiro rojose ĩre yiyuma. Yʉ, Dios ĩ roticõacacʉre quẽne, to bajirone yʉre yirʉarãma —ĩnare yitudiroja vayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","To bajiro ĩ yisere ajimasicõari, “El'ias ñamasir'ire ĩ yijama, Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉjʉare gotigʉ yami, ĩre bajiro tʉoĩar'i ĩ ñajare”, yiajimasiñujarã ĩna Pedro mesa. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ti burojʉ majariarã, yʉa tʉ rojaejacama ĩna quẽna. Jãjarã masa ñacama yʉa rãca. Jesús ĩ tudiejasere ĩacõari, ĩ rĩjorojʉa gʉsomuniari tuetucami sĩgʉ̃. To yicõari, ado bajiro Jesúre yicami: ");
INSERT INTO bsnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Yʉ ʉjʉ, yʉ macʉre ĩamaiña mʉ. Biyaroaca rijaquedirũgũami. To bajica yigʉ, bʉto rojose tãmʉorũgũami. Cojoji me jeamejʉ rocatĩacõarũgũami. To bajicõari, oco vatoajʉ quẽne rocaroacõarũgũmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉ buerã tʉ ĩre ãmiejaboabʉ yʉ. Ĩ ʉsʉjʉre sãñagʉ̃re vãtire burocamasimema ĩna —Jesúre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","To ĩ yisere ajicõari, ado bajiro yicami, yʉare ĩ buerimasare, to yicõari, ĩre ajirã ejarãre quẽne: —Rojosere tʉoĩarã ñari, Diore ajitirʉ̃nʉmena masu ñacõaja mʉa. ¿No cõrojʉ mʉare gotimasio tʉjagʉti yʉ? Yoaro mʉa rãca yʉ ñaboajaquẽne, yʉ masisere mʉare yʉ ʉjosere ajitirʉ̃nʉbeaja mʉa maji —yʉare yicami Jesús. To yigʉne, —Adojʉa vãti sãñagʉ̃re ĩre ãmiaya —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ĩre ĩna ãmiejarone, ĩ ʉsʉjʉ sãñagʉ̃re vãtire burocacõacami Jesús. Vãti ĩ budirirĩmarone, catiquẽnagʉ̃ ñacoacami daquegʉjʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","To ĩ yiro bero, ricati cãmotadicõari, Jesúre ado bajiro ĩre sẽniĩacajʉ yʉa: —¿No yirã daquegʉ ʉsʉjʉre sãñagʉ̃re vãtire burocamasibeti yʉa? —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","To bajiro yʉa yisere ajicõari, ado bajiro cʉdicami Jesús: —“Dios ĩ ejarẽmose rãca burocarʉarãja” yitʉoĩamena ñari, vãtire burocamasibesuja mʉa. Riojo mʉare gotiaja yʉ: “Mojoroaca yimasirã ñaboarine, Dios ĩ ejarẽmose rãca yimasicõarãja” yirã, i burore, “Gajerojʉ vasa” mʉa yirotijama, to bajirone bajirʉaroja ti. Ñiejʉa mʉa yimasibeti manirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","To bajiboarine, jẽjʉ yʉ burocagʉre bajiro bajirãre mʉa burearʉajama, bare bamenane Diore sẽnicõari rĩne bureamasirʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea sitajʉ vana, gãmerã cãmotadiri mene cojojũnane Jesúrãca vacudicajʉ yʉa. To bajiro yʉare ũmato bajicudigʉne, ado bajiro yʉare yicami Jesús: —Yʉre Dios ĩ roticõacacʉre masare ĩsirocarʉcʉmi sĩgʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","To bajiro ĩ yijare, yʉre sĩarʉarãma ĩna. Yʉre ĩna sĩaboajaquẽne, idiarʉ̃mʉ tʉsatirʉ̃mʉne yʉre catiorʉcʉmi Dios —yʉare yicami Jesús. To bajiro ĩ yisere ajicõari, bʉto sʉtiriticajʉ yʉa, ĩ buerã. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","To ĩ yiro bero, Capernaum vãme cʉti maca ejacajʉ yʉa, Jesúrãca. Tojʉ yʉa ñaro, Diore yirʉ̃cʉbʉoriavire boarijaʉrire quẽnorʉarã, vaja sẽnirimasa, Pedrore sẽniĩarã ejayujarã, macajʉ́jʉ: —¿Mʉare gotimasiorimasʉma, Diore yirʉ̃cʉbʉoriavi quẽnoroti vaja ĩsibecʉti ĩ? —Pedrore ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Ĩsirʉcʉmi —yicʉdiyuju Pedrojʉama. Tijʉ bero, vijʉ sãjaejacõari, vaja sẽnirimasa ĩna sẽniĩarere ĩ gotibetone, Jesújʉa, ado bajiro Pedrore ĩre boca yicõacami: —Simón, ¿no bajiro tʉoĩati mʉ? ¿Adigodoana ʉjarã, ñimarãjʉare vaja yirotiati? ¿Ĩna yarãrene gãmerã vaja sẽniatique? ¿Gajero vadiriarãjʉare vaja yirotirũgũatique ĩna? —Pedrore ĩre yisẽniĩacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","To bajiro ĩ yisẽniĩarone, ado bajiro ĩre cʉdicami Pedro: —Gajero vadiriarãjʉare vaja yirotirũgũama —yicʉdicami Pedro. To ĩ yirone, ado bajiro yicami Jesús: —Riojo yaja mʉ. To bajiri Dios macʉ ñari, yʉ ya vi ti ñajare, Diore yirʉ̃cʉbʉoriavi coderãre vaja yibecʉja yʉma. ");
INSERT INTO bsnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","To bajiboarine, “Rojose manire tʉoĩabeticõato” yirã, mani vaja yijama, quẽnaja. Ʉtabʉcʉrajʉ vasa mʉ. Tojʉ vai vejeba. Basʉogʉre ĩre sĩacõari, ĩ risejʉ gãjoatii bʉjarʉcʉja mʉ. Titiine ĩnare vaja yiroti ñaroja, Diore yirʉ̃cʉbʉoriavi coderãre. Titiire ãmicõari, ĩnare ĩsima —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tirʉ̃mʉne Jesúre ĩre sẽniĩacajʉ yʉa ĩ buerimasa: —Mʉre yʉa rotibosarirodo ti ejaro, ¿ñimʉjʉa ñagʉ̃ti ñamasugʉ̃ ñarocʉ? —ĩre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","To yʉa yirone, sĩgʉ̃ daquegʉre jicõari, yʉa rĩjorojʉa ĩre rʉ̃gõroticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","To yicõari, ado bajiro yʉare yicami: —Riojo mʉare gotiaja yʉ. Daquerã, “Ñamasurã me ñaja yʉa” ĩna yitʉoĩarore bajiro mʉa tʉoĩabetijama, Ʉjʉ Dios yarã quẽnaro ĩ yirã me ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ʉjʉ Dios yarã ñamasurã ñaama ãni daquegʉre bajiro tʉoĩarã, “Ñamasurã me ñaja yʉa” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ãni daquegʉre bajiro tʉoĩarã ĩna ñajare, gãjerã tʉ ĩna ejaro, quẽnaro ĩnare yirãma, yʉjʉare quẽnaro yirãre bajiro yirã yirãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Quẽna ado bajiro yʉare goticami Jesús: —No bojarã, ãni daquegʉre bajiro tʉoĩarãre, yʉre ajitirʉ̃nʉrãre rojose ĩna ũmato yijama, bʉto rojose tãmʉorʉarãma. Rojose ĩnare ĩna ũmato yiroto rĩjoro, tocãrãcʉrene ĩna ãmʉarijʉre gʉ̃ta jairica siatucõari, riaga ʉ̃cʉarojʉ ĩnare rearoderuucõajama, rojose tãmʉobetibʉsaborãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Rojose yirã sʉorine bʉto rojose tãmʉorʉarãma masa. Rojose yirã jãjarã ñarãma. To bajiri gãjerãre rojose ũmato yirʉarãma. To ĩna yise sʉori bʉto rojose masu tãmʉocõarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Yʉ ãmo sʉorine rojose yibʉ yʉ” mʉa yitʉoĩamasijama, jatarocaya. “Yʉ gʉbo sʉorine rojose yibʉ yʉ” mʉa yitʉoĩamasijama, jatarocaya. Mʉare cojo ãmo, cojo gʉbo ti manijama, quẽnabetoja. To bajiboarine jʉaãmo rãca, jʉa gʉbo rãca mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Yʉ cajea sʉorine ĩabojacõari, rojose yibʉ yʉ” mʉa yitʉoĩamasijama tiare ãmirocacõaña. Coja cajea mʉare ti manijama, quẽnabetoja. To bajiboarine, jʉajʉne caje cʉticõari, mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Quẽna ado bajiro yʉare goticami Jesús: —Yʉre ajitirʉ̃nʉrãre, “Ñamasurã me ñaja yʉa” yitʉoĩarãre, “Vaja mana ñaama”, ĩnare yiĩatebeja. Õ vecajʉ ángel mesa ñarʉarãma ĩnare ĩatirʉ̃nʉrã. Yʉ jacʉ tʉjʉre cojorʉ̃mʉ rʉyabeto ĩnare ñagõbosarũgũrãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yayirãre bajiro bajirãre, rojose tãmʉoboronare, ĩnare yirẽtobosagʉ vadicajʉ yʉ, Dios ĩ roticõacacʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","To bajiro yicõari, ado bajiro yirũtuacami Jesús: —Adi quetiaca mʉare yʉ gotimasiosere quẽnaro ajitʉoĩaña mʉa. Sĩgʉ̃ ñagʉ̃mi cien oveja cʉogʉ. Cojorʉ̃mʉ sĩgʉ̃ yayicoacʉmi. To bajiri ĩnare coderimasʉ, rʉyarãre, noventa y nueve ñarãre ta vesejʉ ĩnare cũcõari, yayir'ire macagʉ̃ vacoacʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gãjerã yayimena noventa y nueve ñarirãcʉre, “Yayibesuma” yivariquẽnagʉ̃ ñaboarine, yayir'ire bʉjacõari, ĩnare ĩ variquẽnaro rẽtobʉsaro ĩre variquẽnagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mani jacʉ õ vecagʉ to bajirone bajigʉmi ĩ quẽne. Sĩgʉ̃ rʉyabeto daquegʉre bajiro tʉoĩagʉ̃, Dios tʉ ĩ ñabetirotire bojabecʉmi Dios —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Quẽna ado bajiro yʉare gotimasiocami Jesús: —Yʉre ajitirʉ̃nʉgʉ̃ ñaboarine, rojose mʉare ĩ yijama, gãjerãre gotimenane, ĩ tʉ vacõari, ñagõquẽnoma, “‘Riojo yaja mʉ. Mʉre rojose yibʉ yʉ’ yato ĩ” yirã. “Riojo yaja mʉ” ĩ yijama, ñagõquẽnorʉarãja mʉa. To bajiri ĩ rãca quẽnaro baba cʉtirʉarãja mʉa quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Bajibeaja” ĩ yicʉdijama, gãjerã jʉarã, yʉre ajitirʉ̃nʉrã, “Rojose yibʉ mʉ” ĩre yimasirãre ĩnare jicõari, ĩ tʉ vaja mʉa. Jʉarã ĩna manijama, sĩgʉ̃ yʉre ajitirʉ̃nʉgʉ̃re, “Rojose yibʉ mʉ” ĩre yimasigʉ̃re jicõari, ĩ tʉ vaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ĩnare quẽne ĩ ajibetijama, yʉre ajitirʉ̃nʉcõari mʉa rãca rẽjarã jediro ĩna ĩaro rĩjorojʉa ĩnare gotiba mʉa. Ĩna jediro “Rojose yiyuja mʉ” ĩre ĩna yisere ĩ ajibetijama, Diore ajibecʉre, to yicõari, ʉjʉre gãjoa sẽnibosarimasare ĩnare mʉa cãmotadiriarore bajiro ĩre cãmotadirʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Quẽna ado bajiro yʉare yicami Jesús: —Riojo mʉare gotiaja yʉ. Adi macarʉcʉrojʉ yʉre rotibosarã ñarʉarãja mʉa. To bajiro yirã ñari, “Ado bajiro mʉa yijama, Dios yarã ñarʉarãja mʉa. Ado bajirojʉa mʉa yijama, Dios yarã me ñarʉarãja mʉa”, yimasirʉarãja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Quẽna ado bajiro yʉare yicami Jesús: —Gajeye ado bajiro mʉare gotiaja yʉ: Sĩgʉ̃ ĩ tʉoĩarore bajirone mʉa tʉoĩajedicõajama, mʉa bojasere ĩsirʉcʉmi yʉ jacʉ õ vecagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","No bojarijʉ jʉarã, idiarã, yʉre ajitirʉ̃nʉrã ñari, Diore ĩna sẽnijama, ĩna rãca ñarʉcʉja yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","To ĩ yiro bero, ado bajiro Jesúre sẽniĩacami Pedro: —Yʉ ʉjʉ, sĩgʉ̃ mʉre ajitirʉ̃nʉgʉ̃ ñaboarine, yʉre rojose ĩ yijama, ¿nocãrãcaji masu ĩre masiriogʉti yʉ? ¿Cojomo cõro gaje ãmo jʉa jẽnituaro ñarirãcajine ĩre yʉ masiriojama, quẽnarojari? —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","To ĩ yisere ajicõari, ado bajiro ĩre cʉdicami Jesús: —Tocãrãcajine rojose mʉre ĩ yiro cõrone masirioroti ñaja mʉre —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","To yicõari, ado bajiro ĩ buerãre yʉare gotimasiocami Jesús: —Bʉto rojose mʉa yiro bero, sʉtiriticõari, “Yʉare masirioya” Diore mʉa yijama, mʉare masiriorʉcʉmi. To bajiro mʉare ĩ yise ñajare, “Gãjerã rojose mʉare ĩna yiboajaquẽne, mʉare masirioroti ñaja” yigʉ, ado bajise gotimasiore queti mʉare gotiaja yʉ: Ʉjʉ, ĩre vaja morãre gotirʉ, ĩre moabosarimasare jicõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ĩre vaja morãre “Adocãrãcʉ ñaama” ĩ yigʉadijʉne, sĩgʉ̃ jairo ĩre vaja mogʉ̃re ĩre ãmiejarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ĩre ĩna ãmiejarirĩmarore, ñie rãca vaja yimasibecʉmi. To bajiro ĩ bajijare, ĩre ãmiejarãre ado bajiro ĩnare rotigʉmi: “Ãnire, ĩ manajo, ĩ rĩare quẽne gãjerãre yʉre ĩsibosaya, ‘Gãjerãre moabosarimasa ñato’ yirã. To yicõari, ĩ gajeyeũni jedirore gãjerãre ĩsicõari, vaja sẽnima. To yicõari, ti vaja mʉa bʉjasere yʉre ĩsima. To bajiro mʉa yijama, yʉre ĩ vaja mose jedicoarʉaroja”, ĩnare yigotigʉmi ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","To ĩ yisere ajicõari, ĩ rĩjorojʉa gʉsomuniari tuetuejagʉmi ĩre vaja mogʉ̃. To yicõari, rʉ̃cʉbʉose rãca ĩre sẽnigʉ̃mi: “¡Yʉ ʉjʉ, yuya maji! Mʉre yʉ vaja mosere vaja yijeocõarʉcʉja maji”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","To ĩ yisere ajicõari, ĩre ĩamaigʉ̃ ñari, “Tone bajicõato”, ĩre yicõa tʉjacʉmi, ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","To bajiro ĩ ʉjʉ ĩ yisere ajicõari, budicoacʉmi. Budiacʉne, ĩ baba mojoroaca ĩre vaja mogʉ̃re ĩre ĩabʉjagʉmi ĩ quẽne. Ĩre ĩabʉjacõari, ĩ ãmʉare ñiamatagʉmi. To yicõari, ado bajiro ĩre yigʉmi: “¡Yʉre mʉ vaja mosere vaja yijeocõaña mʉ!”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","To ĩ yiboajaquẽne, gʉsomuniari tuetucõari, ado bajise ĩre yigʉmi: “¡Yuya maji! Mʉre yʉ vaja mosere vaja yijeocõarʉcʉja yʉ”, yiboagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","To ĩ yiboajaquẽne, ajibecʉmi ĩ. To bajiri tubiberiavijʉ ĩre ãmiacõari, ĩre cũrotigʉmi, “Yʉre mʉ vaja mosere vaja yijeocõarijʉ, budirʉcʉja mʉ” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ĩ babarã, to bajiro ĩ yisere ĩacõari, bʉto sʉtiritirãma ĩna. To bajiri ĩna ʉjʉ tʉ vacõari, ĩna ĩariaro cõro gotirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","To bajiro ĩna yisere ajicõari, ĩre vaja moboar'i ĩ masirior'ire jirotigʉmi ʉjʉ. Ĩ ejaro ĩacõari, ado bajiro ĩre yigʉmi: “Yʉre moabosarimasʉ rojogʉ masu ñacõaja mʉ. Yʉre mʉ vaja mosere, ‘Tone bajicõato’ mʉre yiboabʉ yʉ, rʉ̃cʉbʉose rãca yʉre mʉ sẽnijare. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉre yʉ ĩamairore bajirone mʉ babare ĩamairoti ñaboayuja”, ĩre yigʉmi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","To bajiro ĩre yicõari, bʉto jũnisinigʉ̃ ñari, ĩre tubiberotigʉmi ĩ quẽne, “Yʉre mʉ vaja mosere vaja yijeocõarijʉ, budirʉcʉja mʉ” yigʉ —yʉare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","To bajise gotigajanocõari, ado bajise yʉare gotitʉsacami Jesús: —To bajirone yirʉcʉmi yʉ jacʉ õ vecagʉ quẽne, gãjerã rojose ĩna yisere mʉa masiriobetijama —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","To bajiro ĩ gotimasioro bero, Galilea sita ñariarã vacõari, Judea sitajʉ ejacajʉ yʉa. Jordán vãme cʉtirisa gajejacatʉajʉ ñacajʉ ti sita. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tojʉ jãjarã masa Jesúre sʉyacama. Rijaye cʉtirãre ĩnare catiocami ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tojʉ yʉa ñaro sĩgʉ̃ri fariseo masa ejacama, Jesúre sẽniĩatorã. Ado bajiro ĩre sẽniĩatocama ĩna: —¿No bojase sʉorine, manajo rocajama, quẽnacõati? —ĩre yisẽniĩatocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","To ĩna yisere ajicõari, ado bajiro ĩnare cʉdicami Jesús: —¿Dios oca masa ĩna ucamasire ado bajiro yisere ĩabeticatique mʉa? “Rẽmojʉ ʉ̃mʉre, rõmiore rujeomasiñuju Dios”, yigotiaja Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","To yicõari gajejʉ ado bajiro gotiaja Dios oca: “Ʉ̃mʉ, rõmio ĩ rujeore ti ñajare, ʉ̃mʉjʉa, manajo cʉtigʉ, ĩ jacʉare ĩnare cãmotadicoarʉcʉmi. Manajo cʉtijama, jʉarã ñaboarine, sĩgʉ̃ rujʉre bajirone ñarʉarãma”, yigotiaja Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","“To bajirʉarãma” Dios ĩ yimasire ti ñajare, mʉa manajoare reabetiroti ñaja —ĩnare yicami Jesús, fariseo masare. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","To ĩ yisere ajicõari, ado bajiro tudisẽniĩatocama ĩna: —Riojo mʉ gotiboajaquẽne, ¿no yigʉ ricati rotimasiñujari Moisés ñamasir'i? Ado bajiro rotimasiñumi ĩ: “No bojagʉ ĩ manajore ĩ rocarʉajama, ‘Mʉre rocagʉ yaja’ yise papera ucacõari, sore ĩsiroti ñaja”, yimasiñumi Moisés —Jesúre ĩre yicama. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","To bajiro ĩna yisere ajicõari, ado bajiro cʉdicami Jesús: —Diore ajiterã ĩna ñajare, “Bʉtobʉsa rojose ĩna manajoare yiroma” yigʉ, manajoa reare beobetimasiñuju Moisés ñamasir'i. Rẽmojʉma to bajiro me bajimasiñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Riojo ado bajiro mʉare gotiaja yʉ: Ĩ manajo gãji rãca so ajeri cʉtibetiboajaquẽne, sore rocacõari, gajeo ĩ manajo cʉtijama, Diojʉa ĩ ĩajama, ĩ manajo me ñagõmo. Ĩ ajerio cʉtigo ñagõmo —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","To ĩ yisere ajicõari, ĩ buerimasajʉa ado bajiro ĩre yicajʉ yʉa: —To yijama, manajo magʉ̃ne ñacõaroti ñañuja —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","To bajiro yʉa yisere ajicõari, ado bajiro yʉare yicami Jesús: —Jediro me ñarãma, manajo cʉtibetiboarine, Dios ĩ bojarore bajiro yimasirã. To bajiro yirãma, Dios ĩ ejarẽmose rãca yirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sĩgʉ̃ri manajo cʉtimena ñarãma. Rõmia rãca ĩna yiroti ti manijare, bajirãma. To bajirãne ruyuariarã ñari, bajirãma. Gãjerãma, “Rĩa yimasibeticõato” yirã, ĩna yijeriarã ñari, bajirãma. Gãjerãma, manajo bojamenama, “Yʉ manajo cʉtibetijama, yʉ ʉjʉ, Dios ĩ bojarore bajiro quẽnabʉsaro yimasirʉcʉja yʉ” yitʉoĩarã ñari, bajirãma. To bajiro bajirʉa tʉoĩarãma, to bajirone bajiato —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesús tʉjʉ rĩamasacare juaejacama masa, ĩ ãmori ñujeocõari, Diore ĩnare sẽnibosato ĩ” yirã. Ĩna juaejasere ĩacõari, ado bajiro ĩnare yicajʉ yʉa, ĩ buerimasa: —¡Juavadibesa! Gõjanabioro yaja mʉa —ĩnare yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","To bajiro yʉa yiboajaquẽne, Jesújʉama, ado bajiro yicami: —Rĩamasare ĩnare matabesa. Ĩnare bajiro tʉoĩarã ñarãma Ʉjʉ Dios yarã quẽnaro ĩ yirã —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","To yicõari, rĩamasare ĩ ãmori ñujeocõari, Diore ĩnare sẽnibosacami Jesús. To yicõari bero, yʉare ũmato vacoacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Gajeyeũni jaigʉ, Jesúre sẽniĩagʉ̃ ejacami: —Gotimasiorimasʉ, yʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere yʉre ĩ ĩsisere yʉ bojajama, ¿no bajise quẽnase yiroti ñati yʉre? —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","To ĩ yisere ajicõari, ado bajiro ĩre cʉdicami Jesús: —¿No yigʉ quẽnaseayere yʉre sẽniĩati mʉ? Dios sĩgʉ̃ne ñaami quẽnagʉ̃ma. To bajiri Dios oca masa ĩna ucamasirere ĩaroti ñaja. Mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉ bʉjarʉajama, Dios ĩ rotimasirere cʉdiroti ñaja —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","To ĩ yijare, —¿Disere yati mʉ, “Dios ĩ rotimasirere cʉdiroti ñaja” mʉ yijama? —Jesúre ĩre yicami. To ĩ yirone, ado bajiro ĩre yicami Jesús: —Dios ĩ rotimasire yʉ yijama, ado bajise rotimasirere yaja yʉ: “Sĩabesa. Gãji manajo rãca ajerio cʉtibesa. Juarudibesa. Socʉne, ‘Rojose yimi’ yigotiyirobesa. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ jacʉre, mʉ jacore quẽne quẽnaro ĩnare rʉ̃cʉbʉoya. To yicõari, mʉ masu rujʉre mʉ mairore bajirone mʉ tʉanare maiña”, yigotiaja Dios ĩ rotimasire —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","To ĩ yirone, ado bajiro ĩre yicʉdicami: —Daquegʉjʉne tire cʉdisʉoadicajʉ yʉ. ¿Ñie gajeye rʉyati quẽnaro yʉ yiroti? —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","To ĩ yisere ajicõari, ado bajiro ĩre goticami Jesús: —Cojo vãme rʉyaja, mʉ yiroti, mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉ bʉjarʉajama: Jediro mʉ cʉosere gãjerãre ĩsijeocõaña. To yicõari, ti vaja bʉjacõari, maioro bajirãre ĩsima. To bajiro mʉ yijama, õ vecajʉ Dios ĩ ñarojʉ quẽnase bʉjarʉcʉja mʉ. To bajiro yigajanocõari, yʉre ajisʉyaya —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","To bajiro ĩ yisere ajicõari, bʉto sʉtiriti vacoacami ĩ, gajeyeũni jaigʉ ñari, tire maigʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","To bajiro ĩ bajivato ĩacõari, ĩ buerimasare ado bajiro yʉare yicami Jesús: —Riojo mʉare gotiaja yʉ. Gajeyeũni jairãrema, yʉre ĩna sʉyarʉa tʉoĩaboajama, bʉto josarʉaroja ĩnare. To bajicõari, yirẽto ecobosabetirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Quẽna tire bajise mʉare tudigotiaja yʉ: Vaibʉcʉ, camello vãme cʉtigʉ, gãjojota gojeacare sãjarẽtobudimasibecʉmi. To bajirone bajiaja gajeyeũni jairãre quẽne, yʉre ajitirʉ̃nʉ sʉyarʉaboarãre. To bajiro bajirã ñari, yirẽto ecobosabetirʉarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","To ĩ yisere ajicõari, no yimasibeticajʉ yʉa, ti ũnire ajibetirũgũriarã ñari. To bajiri ado bajiro ĩre sẽniĩacajʉ yʉa: —Riojo mʉ gotijama, ¿no bajiro bajirãjʉa Dios tʉjʉre ejarʉarãda? —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","To yʉa yirone, yʉare ĩacõari, ado bajiro yicami Jesújʉama: —Ĩna masune ejamasimenama masa, Dios tʉjʉre. Diojʉama, ñajediro yimasijeocõami. Ñiejʉa josase maja, ĩrema. Ĩ sʉorine ĩ tʉjʉ ejamasire ñaja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","To ĩ yisere ajicõari, ado bajiro yicami Pedro: —Jediro yʉa gajeyeũnire cũcõari, mʉre sʉyacajʉ yʉa. ¿To bajiro yʉa bajicati vaja, ñie bʉjarãti yʉa? —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","To ĩ yisere ajicõari, ado bajiro yʉare cʉdicami Jesús: —Riojo mʉare gotiaja yʉ. Cojorʉ̃mʉ adi macarʉcʉro ti jediro quẽna tudiquẽnorʉcʉmi Dios. To bajiro ĩ yirirʉ̃mʉ yʉ, Dios ĩ roticõacacʉ, rʉ̃cʉbʉoriajʉ rujirʉcʉja yʉ, rotigʉagʉ. To cõrone mʉa quẽne yʉre sʉyarã, jʉaãmo cõro, cojo gʉbo jʉa jẽnituaro ñaricũmurorire rujirʉarãja mʉa. To yicõari, mani yarã, jud'io masa, jʉaãmo cõro, cojo gʉbo jʉa jẽnituarirãcʉ ñarã masatubuarire rotirʉarãja mʉa. Yʉre ajitirʉ̃nʉrãre, to yicõari, yʉre ajitirʉ̃nʉmenare ĩabesemasirʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No bojarã, yʉre ajitirʉ̃nʉrã ñari, ĩna ya vi, ĩna yarã, ĩna jacʉa, ĩna rĩa, to yicõari, ĩna ya veserire quẽne ĩna maise ñaro cõro ĩna vaveojama, adigodojʉ ĩna cʉosʉore rẽtobʉsaro quẽnase bʉjarʉarãma ĩna, Dios tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","To bajiboarine adire quẽne quẽnaro tʉoĩaña mʉa: Jãjarã ado bajiro mʉa tʉoĩarore bajirone tʉoĩaboarãma: “Dios ĩ bojase yirã rẽtoro Dios ĩ bojasere yirã ñari, ñamasurã ñaja yʉa. To bajiri, õ vecajʉre quẽne ñamasurã ñari, quẽnase bʉjarʉarãja”, yitʉoĩaboarãma. To bajiro yirã ñari, gãjerãre ĩacõari, “Ĩna ya vi, ĩna yarã, ĩna jacʉa, ĩna rĩa, to yicõari ĩna ya veserire vaveomena ñari, ñamasurã me ñaama. To bajiri, õ vecajʉre quẽnase mojoroaca bʉjarona ñaama”, yitʉoĩaboarãma. To bajiro me bajirʉaroja. Adojʉ ñamasurã, õ vecajʉarema ñamasumena ñarʉarãma ĩna. Adi macarʉcʉrojʉ ñamasumenama, õ vecajʉarema ñamasurã ñarʉarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","To yicõari, ĩ buerimasare yʉare gotimasiorũtuacami Jesús. “‘Adojʉ ñamasurã ñaja yʉa. To bajiri õ vecajʉ quẽne ñamasurã ñari, quẽnamasuse bʉjarʉarãja’ yitʉoĩabeticõato” yigʉ, ado bajise yʉare gotimasiocami: —Ʉye vese cʉogʉ, ʉye ti bʉcʉaro ĩacõari, busurijʉ jẽjʉ ĩre moabosaronare jigʉ vacʉmi. To bajirone yirʉcʉmi Dios, mʉa ʉjʉ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ĩnare bʉjacõari, ado bajiro ĩnare gotigʉmi: “Mʉa moase vaja mʉa sẽniro cõrone mʉare vaja yirʉcʉja yʉ”, ĩnare yigʉmi. To yicõari, ĩnare moaroticõagʉ̃mi, ĩ ya vesejʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Muiju ĩ asitutuajedirijʉ cõro, moarʉarã ĩna yuritũcurojʉ ĩna ñacõajare, gãjerãre ĩnare ĩabʉjagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Vasa, mʉa quẽne. Yʉ ʉye vesejʉ moaaya. Mʉa moajama, quẽnaro mʉare vaja yirʉcʉja yʉ”, ĩnare yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","To bajiri ĩna quẽne ĩre moabosarã vacoanama. To yicõari, bero ʉ̃mʉrecaji ñaro vacʉ, gãjerãre bʉjagʉmi. Ñamicajʉa ti tʉsato vacʉ, gãjerãre bʉjagʉmi quẽna. Moare manare bʉjacõari, ĩnare moaroticõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yucʉ́ veca muiju tʉsato, gãjerã moarʉarã ĩna yuritũcurojʉ ejacõari, moamenane ĩna ñacõajare, “¿No yirã moamenane ñarʉ̃mʉ cʉtiati mʉa?”, ĩnare yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","To ĩ yirone, “Ñimʉjʉa, yʉare moarotibeami. To bajiri ñacõaja yʉa”, ĩre yirãma ĩna. To bajiro ĩna yijare, “Vasa mʉa quẽne. Yʉ ʉye vesejʉ yʉre moabosaaya”, ĩnare yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Rãiorijʉ, ĩre moabosarimasare coderimasʉre ĩre jigʉmi. “Yʉre moabosarimasare ĩnare jiaya mʉ”, ĩre yigʉmi. “To yicõari, ejatʉsariarãre vaja yisʉoya. Ĩnare vaja yigajanocõari, ĩna rĩjorobʉsa ejariarãre vaja yiya. To bajiro rĩne yicõa vasa. To bajiri, moarã ejasʉoriarãre ĩnare vaja yitʉsaya”, ĩre yigʉmi, ĩre moabosarimasare coderimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","To bajiro ĩ yijare, ejatʉsariarãjʉa ejasʉorãma. Ĩna ejaro ĩacõari, cojorʉ̃mʉ vaja tariaro cõro ĩna moare vaja ĩnare vaja yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","To cõro ĩna vaja tasere ĩacõari, “Manima jaibʉsaro bʉjarʉarãja”, yitʉoĩaboarãma ejasʉoriarãjʉa. To bajiro yitʉoĩaboariarãre gãjerã ĩna vaja taro cõrone ĩnare vaja yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ʉjʉ ĩ vaja yirotisere ĩacõari, ñagõjairãma ejasʉoriarãjʉa: ");
INSERT INTO bsnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Vesejʉ ejatʉsariarã, yoaro meaca ĩna moaboajaquẽne, yʉare mʉ ĩsiro cõrone ĩnare ĩsiaja mʉ. Yʉama, cojorʉ̃mʉ jediro, muiju ĩ asicõaro josari moaboabʉ yʉa”, ĩre yitud'irãma, ĩna ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","To bajiro ĩna yiboajaquẽne, sĩgʉ̃re ado bajiro cʉdigʉmi ĩna ʉjʉ: “Rojose mʉre yibejʉ yʉ. Jẽjʉ, ‘Mʉa vaja sẽniro cõrone mʉare vaja yirʉcʉja’ yigʉ ñari, to cõrone mʉare vaja yibʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mʉ moare vaja juacõari, vasa. Mʉre yʉ vaja yiro cõrone, ‘Ejatʉsariarãre quẽne vaja yirʉcʉja’ yitʉoĩamʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","16","Yʉ ye gãjoa ñamʉ ti. To bajiri yʉ bojarore bajirone yibʉ yʉ. Ĩnare quẽnaro yʉ vaja yisere ĩajũnisiniaja mʉ”, ĩre yigʉmi ĩ ʉjʉ. To bajiri adi queti mʉare yʉ gotirore bajiro bajirʉaroja. Adojʉ ñamasurã, õ vecajʉarema ñamasumena ñarʉarãma ĩna. Adi macarʉcʉrojʉ ñamasumenama, õ vecajʉarema ñamasurã ñarʉarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalénjʉ yʉare ũmato varũtu vacʉne, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre yʉare gotirʉ, ricati yʉare jicãmotocami Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Quẽnaro ajiya mʉa. Jerusalénjʉ vana bajiaja mani. Tojʉ mani ejaro, yʉre Dios ĩ roticõacacʉre paia ʉjarãre, Dios ĩ rotimasire gotimasiorimasare ĩsirocarʉcʉmi sĩgʉ̃. Ĩnajʉa, “Ĩre sĩaroti ñaja”, yʉre yirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","To yicõari, romano masare yʉre ĩsirʉarãma. To ĩna yijare, yʉre ajatud'icõari, bajerʉarãma ĩna. To yicõari, yucʉ́tẽrojʉ yʉre jajuturʉarãma. Yʉre jajutucõari, yʉ rijato bero, yʉre yujeboarʉarãma. To ĩna yiboajaquẽne, yʉre ĩna sĩaro bero, idiarʉ̃mʉ tʉsatirʉ̃mʉne yʉre catiocõarʉcʉmi Dios —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","To ĩ yiro bero, Zebedeo rĩa jaco, so rĩa rãca ejacamo, so rĩa ĩna bajirotire Jesúre sẽnigõ ejago. Adocãrãcʉ ñacama so rĩa: Santiago, Juan ñacama ĩna. Jesúre rʉ̃cʉbʉogo, ĩ rĩjorojʉa gʉsomuniari tuetucamo so. To yicõari, Jesús quẽnaro so rĩare ĩ yirotire sẽnicamo. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","So sẽnisere ajicõari, —¿No bajiro quẽnaro yʉ yirotire bojati mʉ? —sore yicami Jesús. To ĩ yijare, ado bajiro cʉdicamo so: —“Ñajediro ʉjʉ ñaja yʉ” yiĩocõari, mʉ rotisʉorirodo ti ejaro, yʉ rĩare ado bajiro ĩnare mʉ ũmato rujirotire bojaja yʉ: Sĩgʉ̃ mʉ riojojacatʉa, gãjire mʉ gãcojacatʉa ĩnare ũmato rujirʉcʉja mʉ, “Mʉ rotirore bajirone ĩna quẽne rotimasiato” yigʉ —ĩre yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","To so yisere ajicõari, so rĩajʉare ado bajiro yicami Jesús: —Tʉoĩamasimenane yʉre sẽniboaja mʉa. Yʉ rãca mʉa rotirʉajama, ¿mʉa quẽne yʉre bajirone rojose tãmʉorãtique mʉa? —ĩnare yicami Jesús. —Bajicõarãja —ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","To ĩna yisere ajicõari, ado bajiro yicami Jesús: —Riojo mʉare gotiaja yʉ. Mʉa quẽne, yʉ tãmʉorotire bajiro rojose tãmʉorʉarãja. To bajiboajaquẽne, yʉ riojojacatʉa, yʉ gãcojacatʉa mʉare rojomasibecʉja yʉ. “Ĩna ñarʉarãma yʉ macʉ tʉ rujirona” yʉ jacʉ ĩ yicana rĩne rujirʉarãma —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesús buerimasa jʉaãmo cõro ñarã, yʉa ajibetone, “To bajiro bojaja yʉa” ĩna yirudisere ajicõari, jũnisinicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","To bajiro yʉa bajijare, yʉa jedirore jirẽocõari, ado bajiro yicami Jesús: —Ʉjarã, Dios yarã me ñarã, ĩna yarãre bʉto tutuaro rotirãma ĩna. Tire masiaja mʉa —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","—Mʉama, yʉ yarã ñari, ĩnare bajiro bajibetirʉarãja. Yʉre ajitirʉ̃nʉrã, ñamasurã ñarʉarãma, gãjerã ĩna bojasere masicõari, quẽnaro ĩnare yiejarẽmorã. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","To bajiri ñamasurã mʉa ñarʉajama, gãjerãre moabosarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dios ĩ roticõacacʉ quẽne, to bajirone bajiaja yʉ. “Gãjerã yʉ bojasere masicõari, quẽnaro yʉre yato ĩna” yigʉ me vadicajʉ yʉ. “Ĩna bojasejʉare masicõari, quẽnaro ĩnare yirʉcʉja” yigʉ vadicajʉ yʉ. To yicõari, jãjarã rojose ĩna yisere Dios ĩ masiriose vaja, ĩnare vaja yibosagʉagʉ vadicajʉ yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó vãme cʉti maca ñacõari, yʉa vatone, jãjarã masa yʉare sʉyacama, Jesúre ĩarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tojʉ yʉa vatone, jʉarã ĩamena rujicama, maa tʉ. Jesús ĩ rẽtosere ajicõari, ado bajiro ĩre jiavasãcama ĩna: —Yʉa ʉjʉ, Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉare ĩamaiña mʉ —yiavasãcama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","To bajiro ĩna yiavasãrone, —¡Avasãbesa! —ĩnare yicama masa. To bajiro ĩna yiboajaquẽne, bʉtobʉsa avasãcama ĩna: —Yʉa ʉjʉ, Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉare ĩamaiña —Jesúre ĩre yiavasãcama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","To ĩna yisere ajicõari, tujarʉ̃gʉ̃cami Jesús. To bajicõari, ĩamenare jicami: —¿No bajiro mʉare yʉ yisere bojati mʉa? —ĩnare yisẽniĩacami, caje ĩamenare. To ĩ yijare, ado bajiro ĩre yicʉdicama: ");
INSERT INTO bsnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Yʉa ʉjʉ, tudiĩarʉaja yʉa —ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","To ĩna yisere ajicõari, ĩnare ĩamaigʉ̃ ñari, ĩna cajearire moaĩacami. To bajiro ĩ yirirĩmarone, ĩamena ñaboacana, ĩacoacama ĩna yuja. Ĩacõari, ĩna quẽne Jesúre sʉyacoadicama. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jerusalén cõñana, Betfagé vãme cʉti maca ejacajʉ yʉa. Olivo vãme cʉti buro jʉdo ñacajʉ ti maca. Tojʉ jʉarã yʉa rãcanare ĩ buerãre ado bajiro ĩnare roticõacami Jesús: —Mani varoto riojo ñarimacare vasa maji. Tojʉ ejacõari, burra ĩna siaturʉ̃gõriore bʉjarʉarãja mʉa, so macʉ rãca ñagõre. Ĩnare õjacõari, yʉre juadibosaba. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ti macagʉ mʉa õjaro ĩacõari, mʉare ĩ sẽniĩajama, “Mani ʉjʉ ĩnare bojami. No cõro mene tʉocõarʉcʉmi quẽna”, ĩre yicʉdiba. To bajiro mʉa yisere ajicõari, sẽniĩarẽmobetirʉcʉmi. “Baʉ. Vasa”, mʉare yirʉcʉmi —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","To bajiro ĩnare yiroticami Jesús, Diore gotirẽtobosarimasʉ, “Ado bajiro bajirʉaroja” ĩ yiucamasire ñajare: ");
INSERT INTO bsnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén macanare ado bajiro yirʉarãja mʉa: ‘Ĩaña mʉa. Mʉa ʉjʉ vadiami. “Ñamasugʉ̃ me ñaja yʉ” yitʉoĩagʉ̃re bajiro ejaami. Burra, gajeyeũni ũmagõ macʉ joejʉ jesacõari, vadiami’ yirʉarãja mʉa”, yiucamasiñuju Diore gotirẽtobosarimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","To bajiri Jesús ĩ rotisere ajicõari, ĩ rotirore bajirone yiyuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burra to yicõari, so macʉre quẽne ĩnare juaejacama ĩna. To yicõari, ĩna ye sudi joeayere vejecõari ĩna joere jeocama ĩna. To ĩna yiro bero, macʉjʉare vajejacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jãjarã masa ñacama. Ĩna ye sudi joeayere vejecõari, ĩ varotijʉre cũ rĩjoro cʉticama. “Yʉa ʉjʉ ñaja mʉ” yirã, to bajiro yicama, Jesúre rʉ̃cʉbʉorã. Gãjerã yucʉ́ rʉjʉri jasurecõari, maare cũ rĩjoro cʉticama. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","To yicõari, “‘“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ ñaja yʉ’ yiĩocõari, rotisʉorʉcʉmi yuja” Jesúre ĩre yitʉoĩarã ñari, bʉto variquẽnacama ĩna. Ĩre rĩjoro cʉti vana, ĩre sʉyarã quẽne, ĩre ĩavariquẽnarã ado bajiro avasã vacama ĩna: —¡Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaami! ¡Quẽnase ĩre yivariquẽnato mani! ¡Diore rotibosagʉ quẽnaro ĩ yigʉ ñaami! ¡Diore quẽne, quẽnase ĩre yivariquẽnato mani, ãni yʉa ʉjʉre ĩ cõajare! —yiavasã vacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","To bajiro Jesús, Jerusalénjʉ, masa rãca ĩ ejasere ĩacõari, bʉto gãmerã ñagõcama ti macana jediro. —¿Ñimʉ ũgʉ̃ ñati? —gãmerã yisẽniĩacama, masa ĩna avasã vado vatoajʉ Jesús ĩ vadire ĩacõari. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","To ĩna yijare, gãjerã ado bajiro yicʉdicama: —Ĩne ñaami Diore gotirẽtobosarimasʉ, Jesús vãme cʉtigʉ, Galilea sita Nazaret vãme cʉti macagʉ —yicama masa. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ti macajʉre ejacõari, Diore yirʉ̃cʉbʉoriavijʉ sãjacajʉ yʉa, Jesúrãca. Ti vijʉ gajeyeũni ĩsirãre, ĩnare vaja yirãre quẽne tud'iãgõbucami Jesús. Gãjerã ye rãca gãjoa vasoarimasa ĩna gãjoa jeorijaʉrire tucaguereacami. To yicõari, buja ĩsirimasa ĩna rujiri cũmurorire tucaguereacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","To yicõari, ado bajiro ĩnare goticami Jesús: —Diore gotirẽtobosarimasa ĩna ucamasire ado bajiro gotiaja: “Yʉ ya vima, yʉre sẽnirʉ̃cʉbʉorã rẽjariavi ñarʉaroja”, yigotiaja, adi vire. To bajiro ĩ yimasire ti ñaboajaquẽne, ado bajiro mʉa yiñase sʉorine juarudirimasa ya vire bajiro bajiaja ti —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti vijʉ, yʉa ñarone, ĩamena to yicõari rujasagueri vana, ejacama, Jesús tʉjʉ. To bajiro ĩna bajirone ĩnare catiocami. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ti vire ñacama paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne. To bajiri Jesús, ĩaĩañamani ĩ yiĩosere ĩacõari, “¡Ʉjʉ David ñamasir'i jãnami, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami! ¡Quẽnase ĩre yivariquẽnato mani!” rĩamasa ĩna yiavasã ñasere ajicõari, Jesújʉare bʉto jũnisinicama. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","To bajiri ado bajiro Jesúre sẽniĩacama: —¿To bajiro mʉre ĩna yisere ajiati mʉ? “To bajise yibesa”, ĩnare yiya —ĩre yicama ĩna. To ĩna yiboajaquẽne, ado bajiro ĩnare goticami Jesús: —Ajiaja yʉ. Dios oca masa ĩna ucamasire to bajirone gotiaja rĩamasa ĩna yirotire. ¿Ĩabeticatique ado bajiro yisere? Ado bajiro gotiaja ti: “‘Rĩamasa, to yicõari, ũjurãca quẽne, mʉre quẽnaro rʉ̃cʉbʉorʉarãma ĩna’ to bajiro mʉ yise ñajare”, yigotiaja Dios oca —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","To ĩ yiro bero, ĩnare vaveocõari, Betania vãme cʉti macajʉ ejacõari, cãnicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Quẽna busurijʉ Jerusalénjʉ tudiacajʉ yʉa. To yʉa bajiro, Jesús, ñiorijacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Maa tʉ higuera vãme cʉtiʉ ñacajʉ. Tiʉ ricare barʉ, ojaboacami Jesús. Rica manicajʉ, tiʉjʉama. Jũ rĩne ñacajʉ. To bajiri tiʉre ado bajiro yicami Jesús: —Jʉaji rica maniʉcarʉarãja —tiʉre yicami. To bajiro ĩ yirirĩmarone, sĩnirocacoacajʉ tiʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","To bajiro ti bajisere ĩacõari, no yimasibeticajʉ yʉa, ti ũnire ĩabetirũgũcana ñari. “¿No yiro guaro sĩnirocacoajari ti?”, yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","To yʉa yirone, ado bajiro yʉare cʉdicami ĩ: —Riojo mʉare gotiaja yʉ. “To bajiro yirʉcʉmi Dios” ĩre mʉa yiajitirʉ̃nʉ tʉjabetijama, higuera vãme cʉtiʉre yʉ yise ũni rĩrene yimasimenaja mʉa. Gajeye josase ti ñaboajaquẽne, yimasicõarãja. “I burore, moa riagajʉ rocaroacoasa” mʉa yijama, to bajirone bajirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Yʉa sẽnijama, yʉare ĩsicõagʉ̃mi” yitʉoĩacõari, Diore mʉa sẽnijama, mʉare ĩsirʉcʉmi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","To ĩ yiro bero, Jerusalénjʉ ejacajʉ yʉa. To bajicõari, Diore yirʉ̃cʉbʉoriavijʉ Jesúrãca sãjacajʉ yʉa. Sãjaejacõari, masare gotimasiocami Jesús. To ĩ yiñarone, bʉcʉrã, paia ʉjarã quẽne, ejacama ĩna, Jesúre sẽniĩarã: —¿Ñimʉ mʉre ĩ rotise rãca to bajiro yirũgũati mʉ? —ĩre yisẽniĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","To bajiro ĩna yisere ajicõari, —Yʉ quẽne, ado bajiro mʉare sẽniĩaja yʉ. Yʉre mʉa cʉdicõarojʉ, “Ĩ rotise rãca yaja yʉ”, mʉare yirʉcʉja maji. ¿Ñimʉ rotiyujari, Juanre, “Oco rãca masare ĩnare bautizaya” yigʉ? ¿Dios rotiyujari? ¿Masajʉa rotiyujarique? —ĩnare yisẽniĩacami Jesús. To ĩ yisere ajicõari, ĩna masurione gãmerã ñagõñacama ĩna: —“Dione, Juanre oco rãca masare bautizarotiyumi” mani yijama, ado bajiro manire sẽniĩajacagʉmi: “Tire masirã ñaboarine, ¿no yirã ĩre ajitirʉ̃nʉbeticati mʉa?” manire yisẽniĩajacagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","To yicõari, “Masane, Juanre oco rãca bautizarotiriarãma” mani yijama, manire bʉto tud'irʉarãma masa, “Diore gotirẽtobosarimasʉ ñaboacami Juan” yirã ñari —gãmerã yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","To bajiro gãmerã ñagõrã ñari, ado bajiro ĩre cʉdicama ĩna: —Juanre rotir'ire masibeaja yʉa —Jesúre yicõacama ĩna. To ĩna yisere ajicõari, ado bajiro ĩnare cʉdicami Jesús: —To bajiro yʉre mʉa cʉdijare, “Ĩ rotise rãca yaja yʉ”, mʉare yigotibetirʉcʉja yʉ quẽne —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","To bajiro ĩnare yigajanocõari, gotimasiore queti ĩnare goticami Jesús: —¿No bajiro tʉoĩati mʉa, adire, yʉ gotigʉadire? Sĩgʉ̃ ñagʉ̃mi jʉarã rĩa cʉtigʉ. Ĩ macʉ ñasʉogʉre ado bajiro yigʉmi ĩ: “Macʉ, yucʉrema mani ʉye vesere moagʉaja”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","To ĩ yiboajaquẽne, “Varʉabeaja yʉ”, ĩre yicʉdigʉmi. To bajiro yiboarine, berojʉma, tʉoĩavasoacõari, moagʉ̃ vacoacʉmi ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","To ĩ yiro bero, gãji ĩ macʉre quẽne, to bajirone ĩre yigʉmi. To ĩ yirone, “Baʉ. Moagʉ̃ varʉcʉja yʉ”, ĩ jacʉre yicʉdigʉmi ĩ. To yiboarine, vabecʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","To bajiri mʉa tʉoĩajama, ¿nijʉa ñañujari ĩ jacʉ ĩ rotiriarore bajirone cʉdir'i? —ĩnare yisẽniĩacami Jesús. To ĩ yisẽniĩarone, ado bajiro ĩre cʉdicama: —Ĩ, moarotisʉor'ijʉa, ĩ jacʉ ĩ rotiriarore bajiro ĩre cʉdiyumi —ĩre yicʉdicama. To ĩna yisere ajicõari, ado bajiro yicami Jesús: —Riojo mʉare gotiaja yʉ. Ʉjʉre gãjoa sẽnibosarimasare, to yicõari, rõmia, ʉ̃mʉare ajeriarã cʉticõari, vaja sẽnirã rõmirire, “Rojorã masu ñaama” ĩnare yiĩaterã ñarãja mʉa. Mʉa ĩaterã sĩgʉ̃ri, tʉoĩavasoacõari, Ʉjʉ Dios yarã quẽnaro ĩ yirã ñarãma. Ĩnare bajiro mʉa tʉoĩavasoabetijama, ĩ yarã me ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan, oco rãca masare bautizarimasʉ, “Ado bajirojʉa mʉa yijama, quẽnaroja” mʉare ĩ yigotimasioboajaquẽne, ĩre ajibesuja mʉa. To bajiboarine, “Rojorã masu ñaama” mʉa yiĩaterãjʉama, ĩre ajitirʉ̃nʉñuma ĩna. To bajiri ĩre ĩna ajitirʉ̃nʉsere ĩariarã ñaboarine, ĩre ajibeticõari, rojose mʉa yirũgũriarore bajiro rojose yicõa ñaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Quẽna ado bajiro ĩnare gotimasiocami Jesús: —Sĩgʉ̃ masʉ ʉye vese otegʉmi. Tire otegajanocõari, matagʉmi. To yicõari, ʉye oco juarotijʉ quẽnogʉ̃mi. Tijʉ bero, vecajʉ ñacõari, ĩ ĩatirʉ̃nʉjesarotijʉ quẽnogʉ̃mi. To yigajanocõari, gãjerãre, “Yʉre ĩatirʉ̃nʉbosaba”, yigʉmi. “Ʉye ti rica cʉtiro, gãjerãre ĩsicõari, vaja sẽnirʉarãja mʉa. To yicõari, mʉa juajama, ‘Ado cõro ñaja mani ye. Ado cõro ñaja ĩ yema’ yicõĩama”, ĩnare yigʉmi. To yicõari, gajerojʉ vacoacʉmi yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","To bajiri cojorʉ̃mʉ, “Ʉye rica cʉti bʉcʉatoja ti” yigʉ, ĩre moabosarimasare cõagʉ̃mi, “Ʉye, yʉre ĩna cũbosarere yʉre juabosaaya” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ʉye vesejʉ ĩna ejaro ĩacõari, ti vese coderãjʉa, ado bajiro yirãma: Ĩnare ñejecõari, jarãma. Gãjerãre sĩarãma, to yicõari gãjerãre gʉ̃tane reasĩarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","To ĩna yire quetire ajicõari, jãjarãbʉsa ĩre moabosarimasare cõagʉ̃mi vese ʉjʉ, ĩ ye ñarotire juabosaaya yigʉ. Ti vesejʉ ĩna ejarone, ĩatirʉ̃nʉrimasa, to rĩjoro ejariarãre ĩna yiriarore bajirone yirãma, ĩnare quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","To bajiro ĩna yiecore quetire ajicõari, “Yʉ macʉjʉare rʉ̃cʉbʉorãma” yitʉoĩacõari, ĩre cõaboagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","To bajiro ĩ yicõar'ire, vesejʉ ĩ ejasere ĩacõari, ado bajiro gãmerã ñagõrãma vese coderimasa: “Adi vese ʉjʉ macʉne ñaami. To bajiri ĩ bajirocaveojama, ĩne ñaami ĩre vasoarocʉ. To bajiri ĩre mani sĩajama, mani ye sita ñarʉaroja yuja”, gãmerã yiñagõrãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","To bajiri vese sojʉajʉ ĩre ñia vati, ĩre sĩarocacõarãma —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","To bajiro ĩnare yigajanocõari, ado bajiro ĩnare sẽniĩacami: —¿Ti vese ʉjʉ tudiejagʉ, no bajiro ĩnare yigʉjari, ti vese coderimasare? —ĩnare yisẽniĩacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","To ĩ yisere ajicõari, ado bajiro ĩre cʉdicama ĩna: —Rojorã masu ñarãma ti vese ĩatirʉ̃nʉrã. To bajiri ĩnare ĩamaibecʉne ĩnare sĩareagʉmi. To ĩ yiro bero, gãjerãre ti vesere ĩatirʉ̃nʉronare vasoagʉmi, ĩ ye ñarotire juabosaronare —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","To ĩna yicʉdisere ajicõari, Jesújʉa, ado bajiro ĩnare yicami: —“Ʉye vese ʉjʉ macʉre rojorã ĩna sĩarocarere bajirone viri bʉarimasa gʉ̃ta ĩna beserocaria ñaboarine, ñamasurica ñarʉaroja”, yigotiaja Dios ocare masa ĩna ucamasire. ¿Tire ĩabeticatique mʉa? Ado bajiro gotiaja: “Gʉ̃ta rãca vi quẽnorimasa coja gʉ̃tare rocarãma ĩna. Ĩna rocaria ñaboarine, gajea gʉ̃ta rẽtoro quẽnarica ñarʉaroja tia. Tia gʉ̃ta sʉorine quẽnarivi quẽnorʉcʉmi Dios. Tia manijama, quẽnomasibetibogʉmi. To bajiro bojagʉmi Dios mani ʉjʉ. To bajiri tia gʉ̃ta sʉori Dios quẽnaro ĩ yisere ajimasicõari, bʉto tʉoĩa variquẽnaja mani”, yigotiaja Dios oca masa ĩna ucamasire. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","To bajiri ado bajiro yigʉ, ti quetire mʉare gotibʉ yʉ: Diore rotibosagʉre yʉre ajitirʉ̃nʉmena mʉa ñajare, jud'io masa mejʉare, “Yʉ yarã ñaña” ĩnare yicõari, quẽnaro ĩnare yirʉcʉmi Dios. Ĩnajʉama, Dios ĩ bojarore bajiro ĩre ajitirʉ̃nʉrʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","No bojarã yʉre, yʉ ocare ajiterã, rojose tãmʉorʉarãma ĩna —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesús ĩ gotimasiosere ajicõari, “Mani bajisere yigʉ yami”, yiajimasicõacama fariseo masa, paia ʉjarã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","To bajiri Jesúre ñiarʉaboacama ĩna. “Diore gotirẽtobosarimasʉ ñaami Jesús” masa ĩna yitʉoĩajare, masare güirã, ĩre ñiabeticama. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Quẽna gotimasiore queti masare goticami Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Adi quetire tʉoĩacõari, “Tire bajiro bajirʉaroja, masare ‘Yʉ yarã ñaña mʉa’ Ʉjʉ Dios ĩ yiroti” mʉare gotimasiogʉ̃ yaja: Sĩgʉ̃ ʉjʉ, ĩ macʉ ĩ ãmosiarotirʉ̃mʉre quẽnoyugʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","To yicõari, “Ĩavariquẽna ejarẽmoronare jiaya mʉa” yigʉ, ĩre moabosarimasare cõagʉ̃mi ĩ. To ĩ yisere ajicõari, jirã vaboarãma ĩna. Ĩnajʉama, vadirʉamenama. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ĩna vadirʉabetire ajicõari, gãjerã ĩre moabosarimasare cõagʉ̃mi quẽna. “‘Yʉa ʉjʉ mʉare jigʉ ñari, ĩ yarã vaibʉcʉrã mame bʉcʉarãre sĩarotimi. Jẽre quẽnogajanomʉ yʉa. To bajiri ĩ macʉ ĩ ãmosiarirʉ̃mʉ ĩarã vayá mʉa quẽne’ ĩnare yiba”, yicõagʉ̃mi ĩna ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","To ĩ yisere ajicõari, jirã vaboarãma ĩna quẽna. Ĩnare cʉdimenane, vacoanama, ĩna ye moare moaroana. Sĩgʉ̃ ĩ ya vesejʉ vacʉmi. Gãji ĩ gajeyeũni ĩsirojʉ vacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gãjerãma, ʉjʉ ĩ cõaboariarãre ñejecõari, ĩnare jasĩacõarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tire ajicõari, bʉto jũnisinigʉ̃mi ʉjʉ. To bajiri ĩ yarã surarare cõagʉ̃mi. “Ĩnare sĩacõari, ĩna ya virire soereacoaya”, ĩnare yicõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","To ĩ yiro bero, gãjerã ĩre moabosarimasare ado bajiro gotigʉmi: “Yʉ macʉ ĩ ãmosiarotiaye quẽnogajanomʉ. Jẽjʉ yʉ queti cõaboarã, ĩna ejabetijare, quẽnaja. Ĩnare jicõabetiroti ñaboayuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jãjarã masa ĩna vati maarijʉare vasa. To mʉa ĩabʉjarã cõro jirẽocõari, ĩnare ũmato vaba”, ĩnare yigʉmi ʉjʉ, ĩre moabosarimasare. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ĩ rotirore bajirone masare jirẽorãma ĩna. Quẽnarã, rojorã, ĩna bʉjarã cõro jirẽorãma. To bajiri ʉjʉ ya vi, jʉ̃mʉcoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ĩ jicõariarãre ĩagʉ̃ sãjagʉ̃mi ʉjʉ. Sĩgʉ̃re, ĩna ãmosiaro ĩarã ejarã ĩna sãñase ũnire sãñabecʉre ĩabʉjagʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","To bajiri, ĩre ĩacõari, ado bajiro ĩre sẽniĩagʉ̃mi: “¿No yigʉ ĩna ãmosiaro ĩarã ĩna sãñase ũni sãñabeati mʉ?”, ĩre yigʉmi. To ĩ yiboajaquẽne, ĩre cʉdibecʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","To ĩ bajijare, bare jeorimasare ado bajiro ĩnare yigʉmi ʉjʉ. “Ĩ gʉbori, ĩ ãmorire quẽne siacõari, rẽtiarojʉ ĩre rocacõaña. Tojʉ ñacõari, bʉto rojose tãmʉogʉ̃ ñari, guji põguẽ, oti, yirʉcʉmi”, ĩnare yigʉmi ʉjʉ, bare jeorimasare. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","To bajiro bajirʉaroja, “Yʉ yarã ñaña mʉa” Ʉjʉ Dios ĩ yiroti quẽne. Jãjarã masare, “Yʉ yarã ñaña mʉa” Dios ĩ yire ti ñaboajaquẽne, sĩgʉ̃rine ñarãma ĩ rãca ñarona —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","To ĩ yisere ajicõari, fariseo masa ĩ tʉ ñaboarã cãmotadicoacama ĩna, gãmerã ñagõroana. “Ado bajiro yirãsa”, yiruyuyuma: —Ado bajiro mani sẽniĩajama, cʉdimasibeticõari rojose tãmʉorʉcʉmi —yitʉoĩaboayuma. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To bajiro yitʉoĩarã ñari, ĩna rãcanare, to yicõari, “Ʉjʉ ñamasugʉ̃ ñarʉcʉmi Herodes” yirũgũriarãre quẽne, Jesús tʉ ĩnare cõañujarã ĩna, “Ĩre sẽniĩaaya mʉa” yirã. To ĩna yicõariarã ado bajiro Jesúre sẽniĩacama ĩna: —Ajiya gotimasiorimasʉ. “Riojo gotigʉ ñaami”, mʉre yimasiaja yʉa. “Ado bajiro mani yisere bojagʉmi Dios” yigotimasiogʉ̃ ñari, riojo yʉare gotimasioaja mʉ. “Ado bajiro yʉ gotimasiojama, yʉre ajijũnisinirʉarãma” yitʉoĩabecʉne, riojo gotigʉ ñaja mʉ. “Ãnoama, ñamasurã ĩna ñajare, ricati ĩna ajijũnisinibetire ĩnare gotimasiorʉcʉja”, yitʉoĩabecʉ ñaja mʉ. Masa ñajedirore yʉare riojo gotigʉ ñaja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To bajiro yigʉ mʉ ñajare, mʉ tʉoĩasere ajirʉaja yʉa. ¿Roma macagʉ ʉjʉ, César, gãjoa manire ĩ vaja yirotisere mani vaja yijama, quẽnacõarojari? ¿Dios ĩ rotimasirere cʉdimena yirãjarique mani, ĩre mani vaja yijama? —Jesúre yisẽniĩaboacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesújʉama, “Rojose yʉre yirʉarã, to bajise yʉre sẽniĩatoama ĩna”, yimasicõacami. To bajiri ado bajiro ĩnare cʉdicami: —“Quẽnarã ñaja yʉa” yiboarine, mʉa yirore bajiro yirã me ñaja mʉa. ¿No yirã, “Rojose ĩre yirãsa” yirã, to bajise yʉre sẽniĩatoati mʉa? —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Roma macagʉ ʉjʉre gãjoatii, ĩre vaja yirotitiire, cojotii yʉre ĩoña —ĩnare yicami Jesús. To ĩ yijare, ãmiadi, ĩre ĩocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gãjoatiire ĩacõari, ado bajiro ĩnare sẽniĩacami Jesús: —¿Ñimʉ rioga tuyati? ¿Ñimʉ vãme tuyati? —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","To ĩ yirone, —Roma macagʉ Ʉjʉ César rioga tuyaja. To yicõari, ĩ vãme quẽne ñaja ti —Jesúre yicʉdicama ĩna. To ĩna yijare, ado bajise yicami Jesús: —To bajiri aditiire ĩacõari, “César yatii ñaja”, yimasiaja mʉa. To bajiri, gobierno ĩ vaja yirotijama, ĩnare vaja yiroti ñaja. To bajirone bajiaja Diore quẽne. Jediro Dios ĩ cõase ti ñajare, “Yʉa cʉose ti ñaboajaquẽne, ti rãca mʉ bojarore bajiro yirʉarãja”, Diore ĩre yiroti ñaja, manire. To yicõari, “No bojase moare yʉa yise quẽne, mʉ ʉjose rãca yʉa yimasise ti ñajare, ti rãca mʉ bojarore bajiro yirũgũrʉarãja”, ĩre yiroti ñaja, mʉare —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","To bajiro ĩ yisere ajicõari, no yimasibeticama ĩna, quẽnaro gotigʉre ajibetirũgũriarã ñari. To bajiri jʉaji tudisẽniĩamenane, vacoacama yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tirʉ̃mʉne saduceo masa quẽne ejacama, Jesúre sẽniĩatorã. “Masa ĩna rijato bero, ĩna ʉsʉri, ĩna rujʉri ñaro cõrone quẽna tudicatimenama” yirã ñacama saduceo masa. Ado bajiro ĩre sẽniĩacama: ");
INSERT INTO bsnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ajiya gotimasiorimasʉ. Moisés ñamasir'i ado bajiro ĩ yiucacũmasire ti ñajare, mʉre sẽniĩarã vabʉ yʉa: “Sĩgʉ̃, manajo cʉtiboa, rĩa magʉ̃ne ĩ bajirocajama, ĩ gagʉ manajo ñariore manajo cʉtirʉcʉmi ĩ bedijʉa. To bajiri ĩ rãca ñacõari, so macʉ cʉtijama, ĩ gagʉ macʉ ñarʉcʉmi”, yimasiñuju Moisés. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yʉa rãcana, sĩgʉ̃ rĩa, cojomo cõro jʉa jẽnituarirãcʉ ʉ̃mʉa ñaboacama. Sĩgõrene manajo cʉtiboacama ĩna. Ñasʉogʉ sore manajo cʉtisʉoboacami. Rĩa magʉ̃ne rijacoacami ĩ. Ĩ rijato bero, gãji ĩ bedi vasoaboacami. Ĩ quẽne rĩa magʉ̃ne rijacoacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ĩ bederã quẽne, to bajirone sore manajo cʉtiboacama. Rĩa manane, rijajedicoacama ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","So manajʉa ĩna rijajediro bero, so quẽne rijacoacamo yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To bajiri bajireacõari, quẽna ĩna tudicatijama, ¿ñimʉjʉa ñaguĩda so manajʉ masu ñarocʉma, ĩna ñaro cõrone sore ĩna manajo cʉticato bero? —Jesúre yisẽniĩatocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","To ĩna yirone, ado bajiro cʉdicami Jesús: —Dios oca masa ĩna ucamasire ajimasimena ñaja mʉa. Dios ĩ masisere quẽne masirã me ñaja. To bajirã ñari, Moisés ĩ ucamasirere tʉoĩacõari, “Riojo me gotiro yaja”, yitʉoĩaboaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ado bajirojʉa bajiaja: Bajireariarã, ĩna tudicatiro bero, manajo cʉtire, manajʉ cʉtire quẽne manirʉaroja. Ángel mesare bajiro bajirã ñarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿“Masa ĩna bajirearo bero, ĩna ʉsʉri caticõaroja”, yirere ĩabeticatique mʉa? Dios ĩ masune ĩ gotirere ĩre gotirẽtobosarimasʉ ado bajise ucamasiñumi: ");
INSERT INTO bsnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Mʉa ñicʉa ñamasiriarã Abraham, Isaac, Jacob, ĩna rʉ̃cʉbʉo vadimasicacʉne ñaja yʉ”, yigotimasiñumi Dios. Masa bajireariarã ĩna ʉsʉri ti caticõa ñabetijama, to bajise yibetimasiborimi. Bajireariarã, quẽna tudicatirãjʉa ĩna rʉ̃cʉbʉogʉ ñagʉ̃mi. “Ĩna ʉsʉri ti caticõa ñajare, bajireariarã ñaboarine, Diore rʉ̃cʉbʉocõa ñarãma”, yire ñaja —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","To bajiro ĩ yisere ajicõari, no yimasibeticama ĩna, quẽnaro gotigʉre ajibetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceo masare Jesús quẽnaro ĩnare ĩ cʉdise ñajare, gajeye ĩre ĩna sẽniĩatomasibetirere ajiyujarã fariseo masa. Tire ajicõari, rẽjañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tijʉ bero, sĩgʉ̃ ĩna rãcagʉ, Dios ĩ rotimasire gotimasiorimasʉ, Jesúre sẽniĩagʉ̃ ejacami. “Ado bajiro josasere yʉ sẽniĩajama, cʉdimasibeticõari rojose tãmʉorʉcʉmi” yigʉ, ado bajise ĩre sẽniĩacami: ");
INSERT INTO bsnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Gotimasiorimasʉ, ¿disejʉa ñati ñamasuse masu Dios ĩ rotimasire, mʉ ĩajama? —ĩre yisẽniĩacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","To bajiro ĩ yisere ajicõari, ado bajiro cʉdicami Jesús: —Mani ʉjʉre, Diore bʉto mairoti ñaja. No bojagʉre mani mairo rẽtoro, no bojase mani cʉose, to yicõari, mani bojatʉoĩase rẽtoro Diore mairoti ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ti ñaja ñasʉose, ñamasuse Dios ĩ rotimasire. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","To yicõari, gajeye tire bajibʉsasene ado bajiro yaja: “Mʉ masu rujʉre mʉ mairore bajirone mʉ tʉanare maiña”, yigotiaja Dios ĩ rotimasire. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","To bajiri jʉa vãmene ñaja ñamasuse masu Dios ĩ rotimasire. Tire mʉ cʉdijama, Moisés ñamasir'i ĩ rotimasire, to yicõari, Diore gotirẽtobosarimasa ĩna gotimasiomasirere quẽne cʉdijeocõagʉ̃ yigʉja mʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Fariseo masa yʉa tʉ ĩna rẽjaro, ado bajiro ĩnare sẽniĩacami Jesús: —“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ, ¿ñimʉ ñarʉcʉmi yitʉoĩati mʉa? —ĩnare yicami Jesús. —“Ʉjʉ David ñamasir'i jãnamine ñarʉcʉmi” yaja —ĩre yicʉdicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","To ĩna yisere ajicõari, ado bajiro ĩnare yicami: —To bajiro mʉa yitʉoĩaboajaquẽne, Ʉjʉ David ñamasir'i, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cũrocʉre tʉoĩagʉ̃, ¿no yigʉ Diore yigʉre bajiro, “yʉ ʉjʉ” yimasiñujari ĩ? Esp'iritu Santo ĩ ejarẽmose rãca ado bajiro ucamasiñumi: ");
INSERT INTO bsnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Yʉ ʉjʉre ado bajiro yirʉcʉmi Dios: ‘Yʉ riojojacatʉa rujiya maji. Mʉre ĩaterãre, “Rojose yitʉjaya” ĩnare yʉ yiro bero, rojose yimasibetirʉarãma. To cõrone rotisʉorʉcʉja mʉ’ yirʉcʉmi Dios, yʉ ʉjʉre”, yiucamasiñumi David. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","To bajiri, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, David ñamasir'i jãnami ñarʉcʉmi” yiucamasire ti ñaboajaquẽne, ¿no yigʉ ĩ ʉjʉre bajiro bajigʉtique? —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","To bajiro ĩnare ĩ gotisere ajicõari, sĩgʉ̃ ĩre cʉdimasigʉ̃ manicami. “Mani rẽtoro masigʉ̃ ñaami” yitʉoĩacõari, “‘Ãnoama masimena ñaama’ yiromi” yirã, ĩre sẽniĩa tʉjacõacama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","To ĩ yiro bero, masare, yʉa ĩ buerãre quẽne, ado bajiro yʉare yicami Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Dios ĩ rotimasire gotimasiorimasa, fariseo masa quẽne, Moisére Dios ĩ roticũmasirere buerẽtobucõari, “Ado bajiro yiroti ñaja manire”, yigotimasiorã ñaama. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","To bajiri tire ĩna gotimasiosere quẽnaro ajitirʉ̃nʉña mʉa. To bajiboarine, ĩna yirore bajiro yimena ĩna ñajare, ĩna yirore bajiro yibesa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dios ĩ rotimasirere buerẽtobucõari, ĩ rotimasire rẽtobʉsaro yirotiama ĩna. “Cojo vãme me mani rotise ñajare, cʉdijeomasimenama ĩna” yimasirã ñaboarine, ĩnare ĩamaimenane, “Ñajediro yʉa gotirẽtobuse riojo ñaja”, masare ĩnare yicõa ñarũgũama. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jediro ĩna yisere, “Quẽnaro yirã ñaama” masa ĩna yiĩarʉ̃cʉbʉosere bojarã yama. Ĩna riovecari siature, ĩna ricari dʉreature quẽne Dios ocasãñarijataroriaca jacabʉsarijatarori cʉoama ĩna, “Gãjerã manire ĩacõari, quẽnaro rʉ̃cʉbʉoato ĩna” yirã. To yicõari sudiro gaja seayore, jacabʉsase seayore cʉtiaseri sãñaama ĩna. “Quẽnaro yirã ñaama ĩna” masa ĩna yiĩarʉ̃cʉbʉosere bojarã yama. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Boserʉ̃mʉri ñaro ĩna barujijama, ñamasuri cũmurorire rujivariquẽnarũgũama ĩna. Dios ocare bueriavirijʉre quẽne ñamasuri cũmurorire rujivariquẽnarũgũama. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","To yicõari, jãjarã masa ĩna rẽjarũgũrijaʉrire ejarũgũama. Masare ĩna bocajama, rʉ̃cʉbʉose rãca ĩnare ĩna sẽnisere bojarũgũama. To yicõari, “gotimasiorimasʉ” masa ĩna yijama, ajivariquẽnarũgũama. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mʉarema, ĩna yirore bajiro mʉa yibetijare, quẽnarʉaroja. “Gotimasiorimasʉ” mʉa rãcana mʉare ĩna yisere bojabetirʉarãja mʉa. Sĩgʉ̃ne ñaja yʉ, mʉa jedirore gotimasiorimasʉma. Mʉama, cojoro cõrone ñarã ñaja mʉa, yʉre ajitirʉ̃nʉrãma. To bajiri gotimasiorimasʉ gãmerã yimasimenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Õ vecajʉre ñagʉ̃ sĩgʉ̃ne ñaami mani jacʉ, Dios vãme cʉtigʉ. To bajiri adi sitagʉre, gãjire yʉre ajitirʉ̃nʉgʉ̃re, Diore mʉa yirʉ̃cʉbʉorore bajiro yirã, “yʉa jacʉ” ĩre yibeja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Yʉa ʉjʉ ñaja mʉ” gãjerã mʉare ĩna yirʉ̃cʉbʉosere ĩnare yirotibeja. “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõacacʉ, yʉ sĩgʉ̃ne ñaja mʉa ʉjʉma. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sĩgʉ̃ yʉre ajitirʉ̃nʉgʉ̃, ñamasugʉ̃ ĩ ñarʉajama, gãjerã ĩna bojasere masicõari, quẽnaro ĩnare yiejarẽmogʉ̃ ñarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Quẽnaro ĩnare ĩna yirʉ̃cʉbʉosere bojarãre, “Ñamasurã me ñato”, ĩnare yirʉcʉmi Dios. No bojagʉ, “Ñamasugʉ̃ me ñaja yʉ” yicõari, quẽnaro gãjerãre yirẽmogʉ̃jʉare, “Ñamasugʉ̃ ñato”, ĩre yirʉcʉmi Dios —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Fariseo masare, Dios ĩ rotimasire gotimasiorimasare quẽne yigʉ, ado bajiro goticami Jesús: —Bʉto rojose tãmʉorʉarãja mʉa. “Quẽnaro yirã ñaja yʉa” yiboarine, rojorã ñaja mʉa. Dios ĩ rotimasirere buerẽtobucõari, ñamasuse mejʉare ajitirʉ̃nʉcõari, gotimasiovadicajʉ mʉa. To bajiro mʉa yijama, “Ʉjʉ Dios yarã quẽnaro ĩ yirã ñabeticõato mani” yirãre bajiro yiñaja mʉa. To yicõari, “Gãjerã, Ʉjʉ Dios yarã quẽnaro ĩ yirã ñabeticõato ĩna” yirã yaja mʉa. Dios yarã ĩna ñarʉaboajaquẽne, ĩnare matarã yaja mʉa. To bajiri mʉa quẽne ĩ yarã ñabetirʉarãja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Bʉto rojose tãmʉorʉarãja mʉa, fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne. “Quẽnaro yirã ñaja yʉa”, yitʉoĩaboaja mʉa. Manajʉa rijaveoriarã ya virire ẽmarã ñaboarine, masa ĩna ĩaro rĩjorojʉa, “‘Quẽnaro yirã ñaama’ yiĩato” yirã, “Yoaro Diore sẽnirã yaja”, yisocarũgũboaja mʉa. To bajiro mʉa yise vaja, gãjerã rojorã, rojose ĩna tãmʉose rẽtoro rojose tãmʉorʉarãja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Bʉto rojose tãmʉorʉarãja mʉa. “Quẽnaro yirã ñaja yʉa” yiboarine, mʉa yirore bajiro yirã me ñaja mʉa. “Manire bajiro gãji ĩ tʉoĩajama, quẽnaja” yitʉoĩacõari, masare bʉto gotimasiocudiaja mʉa. Sĩgʉ̃, “Yʉare bajiro tʉoĩato” mʉa yigʉre, “Mani ajitirʉ̃nʉro rẽtoro mani yere ajitirʉ̃nʉato ĩ” yirã yaja mʉa. To bajiro mʉa yijama, “Bʉtobʉsa rojose tʉoĩato” yirã yaja mʉa. To bajiri, mʉa rẽtobʉsaro Dios ĩ bojabetire yicõari, “Rojose tãmʉotʉjabetiriarojʉ varʉcʉmi ĩ quẽne”, yirã yaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","22","Quẽna ado bajiro ĩnare goticami Jesús, fariseo masare, Dios ĩ rotimasirere gotimasiorimasare quẽne: —Bʉto rojose tãmʉorʉarãja mʉa. Ĩamena, gãjerã ĩamenare tʉ̃a vanare bajiro bajirã ñaja mʉa. No bojase mʉa yirotire mʉa yirʉajama, “Yimasucõarʉarãja yʉa. Tire yʉa yibetijama, Dios, rojose yʉare yibogʉmi” yirã, yirere ado bajiro gãjerãre gotimasiorũgũboaja mʉa: “Cojojirema mani gotirore bajiro yirʉamena ñari, ado bajirojʉa mani gotijama, quẽnacõaroja”, yirũgũboaja mʉa: “Mani gotirũgũrore bajiro yirã ñaboarine, Dios vãmere mani gotivasoajama, mani gotirore bajiro mani yibetiboajaquẽne, rojose manire yibecʉmi Dios”, yirũgũboaja mʉa. To yicõari, ado bajiro gotimasiorẽmoaja: “Dios vãmere gotiterã, Diore yirʉ̃cʉbʉoriavi vãme rãca mani yijama, quẽnacõaroja. To bajiro yiterã, Diore yirʉ̃cʉbʉorã soemʉoriajaʉ vãme rãca mani yijama, quẽnacõaroja. Tire mani yitejama, õ vecajʉ ʉ̃mʉagaserojʉ Dios ĩ ñaro vãme rãca mani yijama, quẽnacõaroja. To bajiboarine, Diore yirʉ̃cʉbʉoriaviaye oro vãme cʉtise rãca, to yicõari, gaje vãme Diore rʉ̃cʉbʉorã soemʉoriajaʉ joere jesase vãme rãca mani yijama, mani gotirore bajirone yiroti ñaja”, yiboaja mʉa. Tʉoĩamasimena, ĩamenare bajiro bajirã ñaja mʉa. Ñajediro Dios ye ti ñajare, ĩ vãmerene gotirã yaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Bʉto rojose tãmʉorʉarãja mʉa. “Quẽnaro yirã ñaja yʉa” yiboarine, rojorã ñaja mʉa. Dios ĩ rotimasirere buerẽtobucõari, ñamasuse mejʉare ajitirʉ̃nʉrãja mʉa. To bajiro yirã ñari, bare sãvʉorere, an'is, menta, comino vãme cʉtire mojoroaca ti vaja cʉtiboajaquẽne, Diore yirʉ̃cʉbʉoriavi moabosarimasare ĩsiaja mʉa. To bajiro yirã ñaboarine, Dios ĩ rotimasire ñamasusejʉarema ajitirʉ̃nʉmena ñaja mʉa. Ado bajiro bajiaja ñamasuse: Quẽnaro riojo yire, gãjerãre ĩamaire, to yicõari, Diore maire quẽne ñaja ñamasuse. Tire quẽne yirũgũrona ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","To bajiro yirã ñari, ado bajiro yirãre bajiro yaja mʉa: “Beco rãca idirobe” yirã, oco mʉa idirotire veorũgũaja mʉa. To bajiro yirã ñaboarine, camello vãme cʉtigʉjʉarema jaigʉ ĩ ñaboajaquẽne, rujʉne bayurãre bajiro yirũgũaja mʉa. To bajiri, ĩamena, gãjerã ĩamenare tʉ̃a vanare bajiro bajirã ñaja mʉa. Dios ĩ rotimasire ñamasuse mere ajirʉ̃cʉbʉorã ñaboarine, ñamasusejʉare yimena ñaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Bʉto rojose tãmʉorʉarãja mʉa. “Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojorã ñaja mʉa. Idiriabaja, bare jeobariabaja joema coeriabajari ñaboarine, jubeajʉama bʉto ʉeri cʉtibajarire bajiro bajiaja mʉa. Mʉa ʉsʉri bajisejʉarema tʉoĩabeaja mʉa. To bajirã ñari, “Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojosere quẽne tʉoĩarã ñari, rojorã ñaja mʉa. Ĩaʉorã ñari, “Ĩnare yitocõari, ĩna cʉoboasere ẽmarʉarãja”, yitʉoĩarã ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“Rojorã ñaja mani” yimasimena ñari, ĩamenare bajiro bajirã ñaja mʉa, fariseo masa. Rojosere tʉoĩatʉjaya. To bajiro mʉa yijama, Dios ĩ bojarore bajiro tʉoĩarã ñari, quẽnaro yirã ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bʉto rojose tãmʉorʉarãja mʉa fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne. “Quẽnaro yirã ñaja yʉa” yiboarine, mʉa yirore bajiro yirã me ñaja mʉa. Masa yujeriaviri botisene viariavirire bajiro bajiaja mʉa. Masa ĩna ĩaquẽnariviri ñaboarine, jubeajʉama rijariarã gõa quẽnabetoja. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","To bajiro bajirã ñaja mʉa. “Quẽnaro yirã ñaama” masa ĩna yiĩarã ñaboarine, mʉa tʉoĩare cʉtisema rojorã ñaja. “Quẽnaro yirã ñaama” masa mʉare ĩna yiĩasere bojatʉoĩarã ñaboarine, rojose ñaro cõro tʉoĩarã ñaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Quẽna ado bajiro ĩnare gotirũtuacami Jesús: —Bʉto rojose tãmʉorʉarãja mʉa. “Quẽnaro yirã ñaja yʉa” yiboarine, mʉa yirore bajiro yirã me ñaja mʉa. Diore gotirẽtobosamasiriarãre ĩna yujemasiriajʉ joere quẽnarijʉ quẽnoaja mʉa, “Quẽnarã ñamasiñuma” yirã. To yicõari, gãjerã quẽnaro yiriarãre quẽne ĩna yujeriajʉ joere quẽnase quẽnorũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","To yicõari, ado bajiro yirũgũaja mʉa: “Mani ñicʉa, Diore gotirẽtobosarimasare ĩna sĩarearo, ĩnare sĩa ejarẽmobetiboriarãja mani”, yirũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","To bajiro mʉa yijama, “Quẽnarã ñañuma” yirã me yaja mʉa. Ado bajirojʉa yirã yaja: “Diore gotirẽtobosamasiriarãre mani ñicʉa ĩna sĩamasire quẽnañuja ti” yirã yaja mʉa, mʉa ñicʉa rojose ĩna yiriarore bajiro rojose yirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉa ñicʉa Diore gotirẽtobosarimasare ĩna sĩasʉovadimasiriarore bajirone mʉa quẽne ĩna jãnerabatia ñari, Diore gotirẽtobosarimasare sĩajeocõaroti ñaja —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Vãtia ʉjʉ rojose ĩ yirore bajirone rojose yijairã ñaja mʉa. Rojose tãmʉotʉjabetiriarojʉ mʉa varotire, no bajiro rudimasibetirʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mʉa jud'io masa vatoajʉ Diore gotirẽtobosarãre, quẽnaro tʉoĩarãre quẽne, Dios ocare gotimasiorãre quẽne cõarʉcʉja yʉ. Ĩnare sĩarʉarãja mʉa. Gãjerãrema yucʉ́tẽrojʉ jajusĩarʉarãja. Gãjerãrema, Dios ocare ĩna buerivirijʉ ĩnare jarʉarãja. Gãjerãrema, ĩna vati macari ñaro cõrone rojose ĩnare yisʉyarʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","To bajiro mʉa yiroti ti ñajare, ado bajiro yirʉcʉmi Dios, mʉa ñicʉare, mʉa yarã jedirore yʉre ajitirʉ̃nʉmenare: Abel ñamasir'ire mʉa ñicʉ ĩ sĩasʉomasire, to yicõari Diore yirʉ̃cʉbʉoriavi jubeajʉ ñarijaʉ soemʉoriajaʉ tʉjʉ Berequ'ias macʉre Zacar'iare ĩna sĩatʉsamasirere, quẽnaro yirãre ĩna sĩavadimasire ñajare, bʉto rojose tãmʉorʉarãja mʉa, adirʉ̃mʉri ñarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Riojo mʉare gotiaja yʉ. Mʉa ñicʉa ĩna bajimasiriarore bajirone Diore mʉa ajitirʉ̃nʉbeticõa ñajare, ĩna sĩamasire vaja rojose ĩnare ĩ yiroti rẽtobʉsaro rojose mʉare yirʉcʉmi Dios, adirʉ̃mʉri ñarãre —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén macanare ĩre ĩna sĩarocaro bero ĩna bajirotire tʉoĩacõari, ado bajiro yicami Jesús: —Jerusalén macana, Diore gotirẽtobosamasiriarãre sĩamasiriarã jãnerabatia ñacõama ĩna. Dios ĩ cõamasiriarãre, ĩ ocare gotimasiorimasare gʉ̃tane ĩnare reasĩamasiriarã jãnerabatia ñaama. Cojoji me gãjaboco so querʉjʉ ẽñeroca so rĩare so juarẽorore bajiro ĩnare yirʉaboacajʉ yʉ, ĩnare coderʉ. To bajiro yʉ yirʉaboajaquẽne, ĩnajʉa yʉre bojabeticama. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","To bajiri jẽre, “Ĩna ñarijʉre codetʉjacõaja yʉ yuja”, yitʉoĩami Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Riojo gotiaja yʉ: “‘¡Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i vadiami! ¡Quẽnase ĩre yivariquẽnato mani! ¡Diore rotibosagʉ ĩ ñajare, ĩre quẽnaro yato Dios!” yʉre ĩna yiroto rĩjoro, quẽna jʉaji yʉre ĩabetirʉarãma ĩna —ĩnare yitʉoĩa ñagõcami Jesús, Jerusalén macanare. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Diore yirʉ̃cʉbʉoriavijʉ ñacõari, budiacami Jesús. Ĩre ẽmʉcõari, ado bajiro ĩre yicajʉ yʉa: —Adi vire ĩaña mʉ —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","To bajiro yʉa yirone, ado bajiro yʉare yicami Jesús: —¿Adi vire quẽnaro ĩati mʉa? Mʉa ĩarivi ti bajirotire riojo mʉare gotigʉagʉ yaja yʉ. Adi vi mʉa ĩarivi ñaro cõrone cagueroca ecorʉaroja. To bajiri adi viaye gajea gʉ̃ta joere, gajea jesabeticõarʉaroja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tijʉ bero, Olivo vãme cʉti buro joejʉ rujicami Jesús. To ĩ rujirone, gãjerã ĩna mano ĩacõari, ado bajiro ĩre sẽniĩacajʉ yʉa: —¿Divato cagueroca ecoroti Diore yirʉ̃cʉbʉoriavi? ¿No bajiro ti bajisere ĩacõari, “Jesús ejagʉagʉ yigʉmi”, yimasirãti yʉa? ¿No bajiro ti bajiro ĩacõari, “Adi macarʉcʉro jediato yaja”, yimasirãti yʉa? —Jesúre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","To bajiro yʉa yisere ajicõari, ado bajiro yʉare cʉdicami Jesús: —Roori ñarʉarãja mʉa, “Socarãne, gãjerã manire yitoroma” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jãjarã yitorã ñarʉarãma, “Yʉne ñaja ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃” yirã. To bajiro ĩna yisocasere jãjarã masa ĩnare ajisʉyaboarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mʉa tʉana, to yicõari, gajeroana quẽne gãjerã rãca ĩna gãmerã sĩasere ajirʉarãja mʉa. Tire ajicõari, güibetirʉarãja mʉa. “Bajirʉaroja” Dios ĩ yiriarore bajirone bajirʉaroja. To bajiro ĩna gãmerã yiñaboajaquẽne, adi macarʉcʉro jediro me bajirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cojo sitana gaje sitana rãca gãmerã sĩarʉarãma. Cojo maca me ñioñarʉaroja. To yicõari bʉto sita saberʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","To bajiri, rojose tãmʉosʉorʉarãma masa. Ĩna tãmʉose rẽtobʉsaro rojose tãmʉoroana yirãma yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tirodori, gãjerã, mʉare ñejecõari, ĩsirearʉarãma, gãjerãre, “‘Rojorã ñaama’ yiĩacõari, rojose ĩnare yato” yirã. To bajiri, gãjerãjʉa, rojose mʉare yigajanocõari, mʉare sĩarʉarãma. Yʉre ajitirʉ̃nʉrã mʉa ñajare, mʉare ĩaterʉarãma adi macarʉcʉroana jediro. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","To bajicõari, jãjarã yʉre ajitirʉ̃nʉrã, ajitirʉ̃nʉ tʉjarʉarãma ĩna. To yicõari, yʉre ajitirʉ̃nʉrã, sĩgʉ̃ri, gãmerã ĩaterʉarãma. Gãjerã, ĩna rãcanare ĩatecõari, ĩsirearʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Diore gotirẽtobosarimasa ñaja yʉa” yitorã, jãjarã ñarʉarãma. To bajiro ĩna yisocasere jãjarã masa ĩnare ajisʉyaboarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bʉtobʉsa rojose rĩne yirũtu vare ti ñajare, gãmerã maire quẽne manibʉsacoarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","To bajiro ti bajiboajaquẽne yʉre ajitirʉ̃nʉ tʉjamenare, adi macarʉcʉro ti jedirojʉ, rojose tãmʉotʉjabetiriarojʉ ĩna vaborotire ĩnare yirẽtobosarʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, Jesúre ajitirʉ̃nʉña” yire queti, adi macarʉcʉro ñarã masa ñaro cõrone gotimasiojeo ecorʉarãma. Ĩna masijedicõaro berojʉ adi macarʉcʉro jedirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Diore gotirẽtobosarimasʉ Daniel ñamasir'i ado bajiro ucamasiñumi: “Adi macarʉcʉro jedirirodo sĩgʉ̃, ‘Diore rʉ̃cʉbʉobeticõato ĩna’ yigʉ, Dios ĩ bojabetire yirʉcʉmi. Diore yirʉ̃cʉbʉoriavijʉ ĩ ñasere masirʉarãja mʉa”, yiucamasiñumi Daniel ñamasir'i. (Yʉ, Mateo, adi papera Daniel ĩ ucamasirere Jesús ĩ gotisere yʉ ucasere ĩacõari, ajimasiña.) To bajiri Dios ĩ bojabetire ĩ yisere ĩacõari, “Jerusalén maca ti jedirotirʉ̃mʉ cõñaro bajiaja”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","To bajiro bajirirʉ̃mʉ Judea sitana gʉ̃tayucʉjʉ guaro rudicoajaro ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sĩgʉ̃ ĩ ya vi joejʉ jesagʉma, rujiacõari, ĩ ya vi jubeajʉ gajeyeũni ñasere juaátĩmabetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gãji, vesejʉ moañagʉ̃, ĩ ye sudire juagʉ tudiatĩmabetirʉcʉmi, rujarĩmarone yʉ ejaroti ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Rõmia macʉ sãñarã, ũjurã cʉorã quẽne, rojose tãmʉorʉarãma ĩna, ũmatĩmabetica yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Bʉto oco quedirirʉ̃mʉre, to yicõari, ʉsʉsãjariarʉ̃mʉre bajibeticõato” yirã, Diore sẽnicõa ñarũgũña. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","To bajiro bajirirʉ̃mʉri bʉto rojose tãmʉorʉarãma masa. Adi macarʉcʉro ñasʉoriarʉ̃mʉri masa rojose ĩna tãmʉoadire rẽtoro tãmʉorʉarãma ĩna. Rojose ĩna tãmʉoro bero, to bajise rojose tãmʉobetirʉarãma yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Yoaro mebʉsane rojose tãmʉoato masa” Dios ĩ yibetijama, sĩgʉ̃ catirʉyarocʉ manibogʉmi. “Yʉ yarã ñaña mʉa” ĩ yirere cʉdiriarãre ĩamaigʉ̃ ñari, “Yoaro mebʉsane rojose tãmʉoato ĩna”, yirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","To bajiro bajiñarirodorire, “Ãnine ñaami ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i. Ejayumi” gãjerã ĩna yijama, ĩnare ajibeja mʉa. To yicõari, gãjerãjʉama, “Tone ñagʉ̃mi. Ejayuju” mʉare ĩna yijaquẽne, ĩnare ajibeja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jãjarã yitorã ñarʉarãma, “Yʉne ñaja ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃” yirã, to yicõari, “Diore gotirẽtobosarimasa ñaja yʉa” yirã. To bajiro yirã, ĩaĩañamani jairo yiĩorʉarãma, masare yitorã. To bajiro yirʉarãma, “‘Yʉ yarã ñaña mʉa’ Dios ĩ yirere cʉdirã quẽne, manijʉare ajitirʉ̃nʉato” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tire mʉare yʉ gotimasiosere quẽnaro tʉoĩaña mʉa. Ti bajiroto rĩjoro jediro mʉare gotijeobʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","To bajiri, “Yucʉ́ manojʉ ñagʉ̃mi, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i” mʉare ĩna yijama, ĩarã vabetirʉarãja mʉa. To yicõari, “Vi jubeajʉ yayiorojʉ ñagʉ̃mi, ‘Rotimʉorʉ̃gõrʉcʉja mʉ’ yigʉ, Dios ĩ cõar'i” ĩna yijama, ĩnare ajitirʉ̃nʉbetirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Macarʉcʉro jediro bʉjo ĩ yabesere masa ĩna ĩarore bajiro Dios ĩ roticõacacʉ, yʉ vadore yʉre ĩare ñarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rijar'i, ĩ boacũñarorema, yuca ejarãma ĩna —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","To yicõari, quẽna ado bajiro yʉare yicami Jesús: —Tire rojose ĩna tãmʉo gajanorijaʉne, gaje vãme rojose bajirʉaroja. Muiju ʉ̃mʉagʉ asibetirʉcʉmi yuja. Ñamiagʉ quẽne busubetirʉcʉmi. Ñocoa quẽne vẽjacoarʉarãma. To yicõari, õ vecayere nʉrʉobatorʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","To bajiro ti bajiro ĩacõari, “Õ vecagʉ Dios ĩ roticõagʉ̃ rujiadigʉagʉ yigʉmi”, yʉre yirʉarãma masa. Yʉ rujiadire ĩacõari, güirã, otirʉarãma. Yʉ masise rãca, oco bueri vatoajʉ bʉto yʉ busubatorujiadire ĩarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Õ vecajʉ trompeta jutise ocaruyurʉaroja. To cõrone, “ ‘Yʉ yarã ñaña’ Dios ĩ yirere cʉdiriarãre jʉdoaga soje, jũnaga soje, varuaga soje, gajejacatʉa varuaga soje ñarã jedirore juarẽoato” yigʉ, ángel mesare cõarʉcʉja yʉ. To yʉ yijare, yʉ yarã ñaro cõrone juarẽorʉarãma ĩna —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","To yicõari, quẽna ado bajiro yʉare goticami Jesús: —Gotimasiore queti mʉare gotigʉ yaja yʉ. Higuera vãme cʉtiʉre tʉoĩaña mʉa. Higuera vãme cʉtiʉ gajecu bʉcʉamʉjacõari, jũ mameaja. Tire ĩacõari, “Mojoroaca rʉyaja cʉ̃ma ti ejaroti”, yimasiaja mani, jud'io masa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mʉare yʉ gotisere bajiro bajisere ĩacõari, “Mojoroaca rʉyaja Jesús ĩ vadiroti”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Riojo mʉare gotiaja yʉ. Adirodo ñarã mʉa bajireajediroto rĩjoro, mʉare yʉ gotirore bajirone bajirʉaroja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adi macarʉcʉro ñaro cõrone, to yicõari, õ vecaye quẽne jedicoarʉaroja. To bajiboarine, yʉ ocama, jedibeti mʉorʉ̃gõcõarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ado cõrone ejarʉcʉmi Jesús” yimasigʉ̃ magʉ̃mi. Ángel mesa quẽne, masimenama ĩna. Dios macʉ ñaboarine, “To cõro ejarʉcʉja yʉ”, yimasibeaja yʉ quẽne. Yʉ jacʉ sĩgʉ̃ne masigʉ̃mi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Quẽna ado bajiro yʉare gotirẽmocami Jesús: —Noé ñamasir'i ĩ ñariarodo masa ĩna bajiñamasiriarore bajiro bajiñarʉarãma, Dios ĩ roticõacacʉ, yʉ tudiejarirʉ̃mʉre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Adi macarʉcʉro ti rujaroto rĩjoro, bare ba, idi, manajo cʉti, yicõa ñamasiñujarã ĩna. Diore tʉoĩari mene, “¿To bajiroado yatique?” yimenane, jairica cũmua quẽnogajanocõari, Noé ĩ vasãjaro ũnone to bajiro yicõa ñamasiñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","“To bajiroado yiroja” ĩna yimasibetone, ĩnare ruureacõamasiñuju Dios. To bajirone bajirʉarãma masa, yʉ tudiejarirʉ̃mʉre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yʉ ejarirʉ̃mʉ jʉarã ʉ̃mʉa ĩna vesejʉ moañarʉarãma. To ĩna yiñarone, sĩgʉ̃ ãmiecorʉcʉmi. Gãjima, ãmiecobetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rõmia jʉarã trigore vãiañarʉarãma. To bajiri, sĩgõ ãmiecorʉocomo. Gajeoma, ãmiecobetirʉocomo. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","To bajiro bajiroti ti ñajare, roori ñarʉarãja mʉa, “To cõrone tudiejarʉcʉmi mani ʉjʉ” yʉre yimasimena ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sĩgʉ̃ vi ʉjʉ, “Adi ñami juarudirimasʉ ejarʉcʉmi” ĩ yimasijama, roori ñabogʉmi, ĩre matarʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","To bajiri, “Dios ĩ roticõagʉ̃ ĩ tudiejarotire mani masibetirĩmarone tudiejaromi” yirã, roori ñarũgũrʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Quẽna ado bajiro yʉare gotirẽmocami Jesús: —Ado bajiro bajirʉcʉmi yʉre quẽnaro ajitirʉ̃nʉ tʉjabecʉ, quẽnaro tʉoĩagʉ̃: Ʉjʉ, gajerojʉ ñagʉacʉ, ĩ varoto rĩjoro, “Yʉ ya vianare yʉre codebosaba” yigʉ, ĩre moabosarimasʉre ĩ cũ var'ire bajiro bajigʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ĩ ʉjʉ, ĩ rotivariarore bajirone ĩ moayurere tudiejacõari, ĩ ĩaejajama, quẽnaro ĩre yigʉmi, ĩre moabosarimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Riojo mʉare gotiaja yʉ. Ʉjʉ ĩ bojarore bajirone ĩ yire ti ñajare, ĩ cʉose jedirorene ĩre ĩatirʉ̃nʉ rotigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ado bajiro bajirʉcʉmi yʉre quẽnaro ajitirʉ̃nʉbecʉma: Rojose yigʉ ĩ ñajama, ʉjʉ, ĩ vato bero, “Yoatojʉ tudiejagʉmi” yitʉoĩagʉ̃ ñari, ĩ ʉjʉ moabosarimasare rojose yigʉmi. To yicõari, idimecʉrũgũrãre baba cʉticõari, ĩna rãca idirũgũgʉ̃mi ĩ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","To ĩ yiñarone, ĩ ʉjʉ, tudiejagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tudiejacõari, ĩ rotiriarore bajiro ĩ yibetire ti ñajare, rojose ĩre yigʉmi. To bajiri “Quẽnaro yirã ñaja yʉa” yiboarine, ĩna yirore bajiro yimena rojose ĩna tãmʉorore bajirone tãmʉogʉ̃mi. Bʉto rojose tãmʉogʉ̃ ñari, guji põguẽ, oti, yigʉmi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Quẽna ado bajiro yʉare yicami Jesús: —Ʉjʉ Dios yarã ñaronama, quẽnaro ĩ yironama, to yicõari, ĩ yarã me ñaronajʉama, ado bajiro bajirãre bajiro bajirʉarãma: Mamarã rõmiri jʉaãmocãrãco ñarãma, mame manajo cʉtirocʉre ĩre bocarã vana. To vana, ĩna sĩabusuore juaánama. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cojomocãrãco ñarãma quẽnaro tʉoĩarã. To yicõari, cojomocãrãco quẽnaro tʉoĩamena ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Quẽnaro tʉoĩamenama ĩna sĩabusuorere juarã ñaboarine, ʉye ti jediro, ĩna jiovasoaborotire juaámenama. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Quẽnaro tʉoĩarãjʉama, “Ti jediro jiorãsa mani” yirã, juaánama. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Manajo cʉtirocʉ ĩ ejatĩmabetijare, yoaro yubʉsaboa, cãnicoanama. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ĩna cãniñarone, ñami gʉdareco cõñaro cõro ocaruyuroja yuja: “Manajo cʉtirocʉ vadicoadiami yuja. Ĩre bocarã vayá”, yi ocaruyuroja. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tire ajicõari, ĩna sĩabusuore sĩarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Cojomocãrãco ñarã quẽnaro tʉoĩamenajʉa, ado bajiro yirãma quẽnaro tʉoĩarãjʉare: “Yʉa sĩabusuore ʉye jedicoajʉ ti. To bajiri mʉa ʉye mojoroaca yʉare ĩsiña”, yiboarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","To bajiro ĩna yiboajaquẽne, ado bajiro cʉdirãma quẽnaro tʉoĩarã: “Ĩsibeaja. Mʉa masune ʉye ĩsirimasa tʉjʉ vacõari, vaja yiaya. Mʉare yʉa ĩsijama, manire tĩjabetiboroja”, ĩnare yirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","To bajiro ĩna yisere ajicõari, ʉye vaja yirã vacoanama quẽnaro tʉoĩamenajʉa. Ĩna vato bero, manajo cʉtirocʉ ejagʉmi yuja. Quẽnaro ñayuriarã rõmirima, ĩ ejarone, ĩ rãca sãjacoanama ĩna, ĩ ãmosiaro ĩarã. Sãjacõari, sojere tucõagʉ̃mi manajo cʉtirocʉjʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Soje ĩ turiaro bero, ejaboarãma quẽnaro tʉoĩamena. Sãjamasimenama. To bajiri, manajo cʉtirocʉre ado bajiro ĩre yiboarãma: “Yʉa ʉjʉ, soje jãnaña maji”, ĩre yiboarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","To ĩna yisere ajicõari, ado bajiro ĩnare cʉdigʉmi manajo cʉtirocʉ: “Riojo mʉare gotiaja yʉ. Yʉ yarã me ñaja mʉa. Mʉare masibeaja yʉ”, ĩnare yigʉmi manajo cʉtirocʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—To bajiri roori ñarũgũrʉarãja mʉa, “To cõrone tudiejarʉcʉmi” yʉre yimasimena ñari —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Quẽna ado bajiro yʉare yicami Jesús: —Quẽna yʉ tudiejaro, “Ñajediro ʉjʉ ñaja yʉ” yiĩocõari, yʉ yarã yʉre ajitirʉ̃nʉrã ĩna yisere masicõari, moabosarimasa ʉjʉ ado bajiro ĩ yiriarore bajiro bajirʉaroja: Sĩgʉ̃ ñagʉ̃mi gaje sitajʉ varocʉ. Ĩ varoto rĩjoro, ĩre moabosarimasare jirẽogʉ̃mi. Ĩnare jirẽocõari, ĩ ye gãjoare ĩnare bategʉmi. “Yʉ manitoyejʉ adi gãjoa rãca vaja yicõari, mʉa vaja yisere gãjerãre ĩsirã, jaibʉsaro vaja sẽnima, ‘Jaibʉsaro gãjoa bʉjarãsa’ yirã”, ĩnare yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","To bajiri, sĩgʉ̃re cinco mil ñaritiiri gãjoatiire ĩre ĩsigʉ̃mi. Gãjire, dos mil ñaritiiri ĩsigʉ̃mi. To yicõari, gãjirema, mil ñaritiiri ĩsigʉ̃mi. Ĩnare ĩsigajanocõari, vacoacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ʉjʉ ĩ vato bero, cinco mil ñaritiiri ĩsiecor'i, quẽna cinco mil ñaritiiri bʉjarẽmogʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gãji dos mil ñaritiiri ĩsiecor'i, quẽna dos mil ñaritiiri bʉjarẽmogʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gãji, mil ñaritiiri ĩsiecor'ima, ĩ ĩsiecoriaro cõrone yujecũcõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yoatojʉ ʉjʉ tudiejagʉmi quẽna. Tudiejacõari, “Gãjoa ĩnare yʉ ĩsicati rãca, ¿no bajiro yʉre yibosayujari ĩna?” yisẽniĩarʉ, ĩnare jigʉmi quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cinco mil ñaritiiri ĩ ĩsir'ire jisʉogʉmi. To ĩ yigʉ, ejacõari, ĩre ĩ ĩsiriaro cõro tʉogʉmi. To yicõari, cinco mil ĩ bʉjarẽmorere ĩre ĩsigʉ̃mi. To yigʉne, ado bajiro gotigʉmi: “Cinco mil ñaritiiri yʉre ĩsicajʉ mʉ. To bajiri quẽna gaje cinco mil ñaritiiri mʉre bʉjarẽmobosabʉ yʉ”, ĩ ʉjʉre ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","To ĩ yijare, ado bajiro ĩre cʉdigʉmi ĩ ʉjʉ: “Yʉre quẽnaro moabosayuja mʉ. Yʉ roticatore bajirone yʉre cʉdiyuja mʉ. Mojoroaca mʉre yʉ ĩsicati rãca yʉ roticatore bajiro mʉ yire ti ñajare, ñamasuse yʉre yibosarʉcʉja mʉ. Yʉ rãca variquẽnaña”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","To ĩ yiro bero, gãji, dos mil ñaritiiri ĩsiecor'i ejagʉmi. Ejacõari, ĩre ĩ ĩsiriaro cõro tʉogʉmi ĩ quẽne. To yicõari, gaje dos mil ñaritiiri ĩ bʉjarẽmorere ĩsigʉ̃mi. To yigʉne, ado bajiro gotigʉmi: “Dos mil ñaritiiri yʉre ĩsicajʉ mʉ. To bajiri quẽna gaje dos mil ñaritiiri mʉre bʉjarẽmobosabʉ yʉ”, ĩ ʉjʉre ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","To ĩ yijare, ado bajiro ĩre cʉdigʉmi ĩ ʉjʉ: “Yʉre quẽnaro moabosayuja mʉ. Yʉ roticatore bajirone yʉre cʉdiyuja mʉ. Mojoroaca mʉre yʉ ĩsicati rãca yʉ roticatore bajiro mʉ yire ti ñajare, ñamasuse yʉre yibosarʉcʉja mʉ. Yʉ rãca variquẽnaña”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Ĩ bero ĩ ʉjʉre ĩogʉ̃ ejagʉmi mil ñaritiiri ĩsiecor'i: “Yʉ ʉjʉ, adine ñaja mʉ gãjoa, yʉre mʉ ĩsicati. Tire yujecũcõacajʉ yʉ, mʉre güigʉ ñari, ‘Ti sʉorine yʉre tud'ijacagʉmi; bʉto roticõari ĩ bojarore bajiro yirere bojagʉ ñacami’ yitʉoĩagʉ̃ ñari”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","To bajiro ĩ yijare, ado bajiro ĩre cʉdigʉmi ĩ ʉjʉ: “Yʉ bojasere yitegʉ bajiyuja mʉ. Rojogʉ ñaja mʉ. ‘Tud'ijacagʉmi; bʉto roticõari ĩ bojarore bajiro yirere bojagʉ ñacami’ yʉre yitʉoĩagʉ̃ ñaboarine, quẽnaro yʉre moabosabesuja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gãjoa mʉre yʉ ĩsicati rãca vaja yicõari, mʉ vaja yisere gãjerãre ĩsicõari, jaibʉsaro vaja sẽnibetiboarine, gãjoa cũriavijʉa mʉ cũjama, jaibʉsaro yʉre bʉjarẽmobosaboriaja mʉ”, ĩre yitud'igʉmi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","To bajiro ĩre yigajanocõari, gãjerãre ado bajiro rotigʉmi: “Ãnire gãjoa yʉ ĩsiboacatire ẽmaña. Tire ẽmacõari, diez mil ñaritiiri yʉre ĩsigʉ̃jʉare ĩsiña”, ĩnare yigʉmi ĩna ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","To yicõari, ado bajise ĩnare gotirẽmogʉ̃mi: “No bojagʉ ĩre yʉ ĩsise rãca yʉ bojarore bajiro yigʉ, quẽnase bʉjarʉcʉmi. Ñiejʉa rʉyabetirʉaroja ĩre. No bojagʉ ĩre yʉ ĩsise rãca yʉ bojarore bajiro yibecʉrema, ĩre yʉ ĩsiboacatire ĩre ẽmarʉcʉja yʉ, ‘Yʉ bojarore bajiro yimasibeami’ yigʉ. To yicõari, ĩre yʉ ẽmasere gãji yʉ bojarore bajiro yigʉjʉare ĩsirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ãni yʉre moabosarimasʉ ñie vaja magʉ̃re, rẽtiarojʉ ĩre rocacõaña mʉa. Tojʉ ñacõari, bʉto rojose tãmʉogʉ̃ ñari, guji põguẽ, oti, yirʉcʉmi”, yigʉmi ĩna ʉjʉ —yʉare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ado bajiro yʉare goticami Jesús quẽna: —Dios ĩ roticõacacʉ yʉ tudiejaro, yʉ rãca ejarʉarãma ángel mesa. Ejacõari, masare rotigʉagʉ, rʉ̃cʉbʉoriajʉ rujirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","To bajicõari, “Adi macarʉcʉroana masa ñajediro yʉ rĩjorojʉa ejato” yigʉ, ángel mesare juaárotirʉcʉja yʉ. To bajiro ĩna yiejoro bero, yʉ yarãre, yʉ yarã mere quẽne ĩamasicõari, ricati ĩnare cũrʉcʉja yʉ. Oveja coderimasʉ, ovejare ricati, cabrare ricati ĩ cũrore bajiro ĩnare yirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yʉ yarãre yʉ riojojacatʉa cũrʉcʉja. To yicõari, yʉ yarã mere yʉ gãcojacatʉa cũrʉcʉja. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","To bajiri yʉ riojojacatʉanare ado bajiro ĩnare yirʉcʉja yʉ: “Yʉ jacʉ quẽnaro ĩ yirã ñaja mʉa. To bajiri ĩ rãca ĩ ye quẽnasere bʉjarʉarãja mʉa yuja. ‘To bajiro bajirʉarãma’ mʉare yitʉoĩacõari, quẽnobosacami, adi macarʉcʉro rujeogʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ ñiorijaro, yʉre bare ecacajʉ mʉa. Yʉ idirʉaro, yʉre iocajʉ mʉa. Gajeroagʉ mʉa masibecʉ yʉ ñaboajaquẽne, quẽnaro yʉre bocaãmicajʉ mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yʉ sudi mano, yʉre sudi sãcajʉ mʉa. Yʉ rijaro, yʉre ĩarã ejacajʉ mʉa. Tubiberiavi yʉ ñaro, yʉre ĩarã ejacajʉ mʉa”, yirʉcʉja yʉ, yʉ yarãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","To bajiro yʉ yisere ajicõari, ado bajiro yʉre sẽniĩarʉarãma ĩna: “Yʉa ʉjʉ, ¿Divato mʉ ñiorijasere ĩacõari, mʉre bare ecacati yʉa? ¿Divato mʉ idirʉaro mʉre iocati yʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Divato gajeroagʉ yʉa masibecʉ mʉ ñaboajaquẽne, quẽnaro mʉre bocaãmicati yʉa? To yicõari, ¿divato mʉ sudi mano, mʉre sudi sãcati yʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","To yicõari, ¿divato mʉ tubibe ecoro, mʉ rijarore quẽne, mʉre ĩarã ejacati yʉa?”, yʉre yisẽniĩarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdirʉcʉja yʉ: “Riojo mʉare gotiaja yʉ. Yʉ yarãre, ‘Ñamasurã me ñaama’ ĩnare yiboarine, quẽnaro ĩnare mʉa yijama, yʉrene quẽnaro yirã yicajʉ mʉa”, ĩnare yirʉcʉja yʉ, yʉ yarãre, yʉ riojojacatʉajʉa ñarãre. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","To yicõari, yʉ gãcojacatʉajʉa ñarãrema ado bajiro yirʉcʉja yʉ: “Yʉre cãmotadiya mʉa. ‘Rojose tãmʉorʉarãma’ Dios ĩ yirã ñaja mʉa. ‘Jeame yatibetimejʉ, rojose tãmʉorʉarãma vãtia, ĩna ʉjʉ rãca’ Dios ĩ yirujeocatijʉjʉ vasa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ ñiorijaro yʉre bare ecabeticajʉ mʉa. Yʉ idirʉaro yʉre iobeticajʉ mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gajeroagʉ mʉa masibecʉ yʉ ñajare, yʉre bocaãmibeticajʉ mʉa. Yʉ sudi mano, yʉre sudi sãbeticajʉ mʉa. Yʉ rijaro quẽne, tubiberiavi yʉ ñaro quẽne, yʉre ĩarã ejabeticajʉ mʉa”, ĩnare yirʉcʉja yʉ, yʉ gãcojacatʉanare. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","To bajiro ĩnare yʉ yirone, ado bajiro yʉre sẽniĩarʉarãma ĩna: “¿Divato mʉ ñiorijaro mʉre ecabeticati yʉa? ¿Divato mʉ idirʉaro, mʉre iobeticati yʉa? ¿Divato gajeroagʉ yʉa masibecʉ mʉ ñajare, mʉre bocaãmibeticati yʉa? ¿Mʉ sudi mano, mʉre sudi sãbeticati yʉa? ¿Divato mʉ tubibe ecoro, mʉ rijarore quẽne, mʉre ĩarã ejabeticati yʉa?”, yʉre yisẽniĩarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdirʉcʉja yʉ: “Riojo mʉare gotiaja yʉ. Ãnoa yʉ riojojacatʉana yʉ yarãre, ‘Ñamasurã me ñaama’ ĩnare yiboarine, quẽnaro ĩnare mʉa yibetijama, yʉrene quẽnaro yimena bajicajʉ mʉa”, ĩnare yicʉdirʉcʉja yʉ, yʉ gãcojacatʉanare. ");
INSERT INTO bsnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","To bajiro ĩnare yigajanocõari, rojose ĩna tãmʉotʉjabetirotojʉ ĩnare reacõarʉcʉja yʉ. To yicõari, yʉ yarãjʉama, quẽnaro ĩna ñacõa ñarotojʉ varʉarãma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","To bajiro gotigajanocõari, ĩ buerimasare ado bajiro yʉare yicami Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Jʉarʉ̃mʉ berone ñaroado yaja Pascua boserʉ̃mʉ ñasʉorirʉ̃mʉ. Tirʉ̃mʉne yʉre Dios ĩ roticõacacʉre masare ĩsirocarʉcʉmi sĩgʉ̃. To bajiri yʉre ñiacõari, yucʉ́tẽrojʉ jajusĩarʉarãma ĩna —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tirʉ̃mʉri paia ʉjʉ ñamasugʉ̃ Caifás vãme cʉtigʉ ya vijʉ rẽjacõari, tʉoĩañañujarã bʉcʉrã, paia ʉjarã quẽne: ");
INSERT INTO bsnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","—Jesúre sĩarʉarã, ¿no bajiro yigʉ ñaami yitocõari, ñiarotirãti mani? ");
INSERT INTO bsnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","To bajiboarine, boserʉ̃mʉ ñaro ĩre mani sĩajama, tire ĩajũnisinicõari, manire rojose yiborãma masa —gãmerã yiñagõñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania vãme cʉti macajʉ cãmi boacacʉ, Simón vãme cʉtigʉ ya vijʉ ñacajʉ yʉa, Jesúrãca. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti vijʉ Jesús ĩ barujirone, sĩgõ, gʉ̃ta sotʉ alabastro vãme cʉti rãca veariarʉ ãmiejacamo. Sʉtiquẽnase bʉto vaja cʉtise, nardo vãme cʉtise sãñaritʉ ñacajʉ tirʉ, so ãmiritʉ. To bajiri Jesús tʉaca eja, ĩ rʉjoa joere ĩre yuejeocamo so. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","To bajiro so yisere ĩacõari, jũnisinicajʉ yʉa ĩ buerimasa. To bajiri, ado bajiro gãmerã yicajʉ yʉa: —¡Jairo gãjoa yireago yamo! ");
INSERT INTO bsnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tire ĩsicõari, jairo gãjoa bʉjacõari, maioro bajirãre ejarẽmoroti ñaboaja ti —gãmerã yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","To bajiro yʉa yisere ajicõari, ado bajiro yʉare yicami Jesús: —Sore gõjanabiobesa mʉa. Tire yʉre so yuejeojama, quẽnaro yʉre yigo yamo. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maioro bajirã mʉa rãca ñacõa ñarũgũrʉarãma, mʉa ejarẽmorona. Yʉma, mʉa rãca ñacõa ñabetirʉcʉja. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Adio sʉtiquẽnase yʉre so yuejeojama, yʉre ĩna yujeroto rĩjoro yuejeo rĩjoro cʉtigo yamo. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Riojo mʉare gotiaja yʉ. Yʉ bajiroti quẽnase quetire, adi macarʉcʉroana jedirore gotibatorʉarãma masa. To bajirone bajirʉaroja sʉtiquẽnase yʉre so yuejeose queti quẽne. So yuejeosere masiritimenane tire gotibatorʉarãma —yʉare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesús buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñacajʉ yʉa. To bajiri yʉa rãcagʉne Judas Iscariote vãme cʉtigʉ, paia ʉjarãre ñagõgʉ̃ varimi. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ĩna tʉjʉ ejacõari, ado bajiro ĩnare sẽniĩañuju ĩ: —¿No cõro jairo yʉre vaja yirãda mʉa, “Jesúre ñiato” yigʉ, mʉare yʉ gotijama? —ĩnare yisẽniĩañuju. To ĩ yisẽniĩase ñajare, treinta ñaritiiri gãjoa ĩre ĩsiñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","To bajiro ĩna gãmerã yiriaro bero, “¿Dirĩmaro ũno Jesúre ĩnare ñiarotigʉti yʉ?”, yitʉoĩacõa ñañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascua boserʉ̃mʉ pan ũmato vauvase vʉoyamani basʉoriarʉ̃mʉ ejacajʉ ti. To bajiri Jesús buerimasa, ado bajiro ĩre sẽniĩacajʉ yʉa: —Pascua boserʉ̃mʉ ñajare, mani barotire, ¿nojʉ bare yʉa quẽnoyusere bojati mʉ? —ĩre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Jerusalénjʉ vasa mʉa. Tojʉ ejacõari, ado bajiro ĩre yiba, vi ʉjʉre: “Manire gotimasiorimasʉ ado bajiro mʉre yicõami: ‘Mojoroaca rʉyaja, Dios ĩ bojarore bajiro yʉ yijeoroti. To bajiri, ĩ ya vijʉ adi ñami Pascua boserʉ̃mʉ ti ñajare, yʉ buerimasare ũmato bagʉ varʉcʉja’ mʉre yicõami”, ĩre yigotiba mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","“To bajiro yiba mʉa” Jesús ĩ yicatore bajirone yiyuma ĩna. To bajiri, Pascua boserʉ̃mʉ yʉa barotire quẽnoyuyuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ti ñami ĩ buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã barujicajʉ yʉa, Jesúrãca. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yʉa bañarone, ado bajiro yʉare yicami Jesús: —Riojo mʉare gotiaja yʉ. Sĩgʉ̃ mʉa rãcagʉ, yʉre ĩaterãre yʉre ĩsirocarʉcʉmi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","To ĩ yisere ajicõari, bʉto sʉtiriticajʉ yʉa. Tocãrãcʉne sʉtiritirã ñari, ado bajiro ĩre sẽniĩacajʉ yʉa: —¿Yʉ ʉjʉ, yʉne ñabetiboati, mʉre ĩsirocarocʉ? —ĩre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","To bajiro yʉa yisere ajicõari, ado bajiro yʉare cʉdicami Jesús: —Sĩgʉ̃, yʉ rãca yosebagʉ ñaami yʉre ĩsirocarocʉma. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dios oca masa ĩna ucamasire ti gotirore bajiro rojose tãmʉorʉcʉja yʉ, Dios ĩ roticõacacʉ. To bajirocʉ yʉ ñajare, yʉre ĩaterãre yʉre ĩsirocarʉcʉmi. Yʉre ĩ gotiyirose sʉorine rojose tãmʉorʉcʉja yʉ. “Masare yirẽtobosarʉcʉmi” Dios ĩ yimasire ti ñajare, bajirʉcʉja yʉ. To bajiboarine, yʉre gotiyiror'ijʉama, rojose tãmʉorʉcʉmi. Ruyuabeticõarocʉ ñaboayumi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","To ĩ yirone, Judas, Jesúre ĩsirocarocʉ, socʉne ado bajiro Jesúre ĩre sẽniĩatocami: —Gotimasiorimasʉ, ¿yʉne ñabetiboati, mʉre ĩsirocarocʉ? —ĩre yisẽniĩacami. To ĩ yirone, ado bajiro ĩre cʉdicami Jesús: —Riojo yaja mʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yʉa bañarone, pan ãmicõari, “Quẽnaja”, Diore ĩre yicami Jesús. To yigajano, tire mʉtocõari, ĩ buerimasare yʉare ĩsibatogʉne, ado bajiro yʉare yicami: —Baya mʉa. Ti ñaja yʉ rujʉ rii —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tire yʉa bagajanorone, idiriabaja ãmicõari, “Quẽnaro yaja mʉ”, Diore yicami quẽna. To yicõari, tibaja yʉare ĩsigʉ̃ne, ado bajiro yicami: —Mʉa jediro adire idiya. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Adi ñaja tirʉ̃mʉana “Rojose mani yirere masirioato” yirã, Diore rʉ̃cʉbʉoriajʉ joere ĩna yuejeoriarore bajiro bajise. Yucʉrema, yʉ ri'i ñaja. Ti sʉorine, “Gajerodo to bajiro mʉare yirʉcʉja yʉ” Dios ĩ yicũmasiriarore bajiro bajirʉaroja. To bajicõari, jãjarã masa rojose ĩna yisere masiriocõari, tuditʉoĩabetirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Riojo mʉare gotiaja yʉ. “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, yʉ jacʉ yʉre ĩ cũroto rĩjoro, quẽna jʉaji ʉye oco idibetirʉcʉja yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","To ĩ yiro bero, Diore rʉ̃cʉbʉorã basacajʉ yʉa. Basagajano, Olivo vãme cʉti burojʉ vacoacajʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","To yʉa vatone, ado bajiro yʉare yicami Jesús: —Adi ñamine yʉre ajitirʉ̃nʉ tʉjacõari, vaveorʉarãja mʉa jediro. Dios oca masa ĩna ucamasire to bajiro ti gotijare, to bajise mʉare yaja yʉ. Ado bajiro gotiaja ti: “Oveja coderimasʉre bajiro bajigʉre sĩarʉcʉja yʉ. To bajiri ĩ yarã ovejare bajiro bajirã rudibatecoarʉarãma”, yigotiaja Dios oca masa ĩna ucamasire, manire gotiro. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yʉre mʉa vaveoboajaquẽne, yʉre ĩna sĩaro bero, quẽna tudicaticõari, Galilea sitajʉ mʉa vato, yʉjʉa mʉa rĩjoro ñatʉjarʉcʉja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","To ĩ yisere ajicõari, ado bajiro ĩre yicami Pedro: —Ãnoa jediro, mʉre ĩna vaveoboajaquẽne, mʉre vaveobetirʉcʉja yʉma —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","To ĩ yisere ajicõari, ado bajiro ĩre cʉdicami Jesús: —Riojo mʉre gotiaja yʉ. Adi ñami busiyʉjʉa gãjabocʉ ĩ ñagõroto rĩjoro, idiaji, “Jesúre masibeaja; ĩ rãcagʉ me ñaja yʉ”, yisocarʉcʉja mʉ —Pedrore ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","To bajiro ĩ yisere ajicõari, ado bajiro cʉdicami Pedro: —Mʉ rãca yʉre ĩna sĩarʉajaquẽne, “Jesúrãcagʉ me ñaja yʉ”, yisocabetirʉcʉja yʉ —Jesúre yicami Pedro. To bajiro Pedro ĩ yisere ajicõari, yʉa quẽne to bajiro yijedicõacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","To yʉa yiro bero, Getseman'i vãme cʉtojʉ yʉare ũmato vacami Jesús. Tojʉ ejacõari, ado bajiro yʉare goticami Jesús: —Õjʉ Diore sẽnigʉacʉ yaja yʉ. To yʉ vatoye, ado rujicõaña mʉa maji —yʉare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","To yi vacʉne, Pedrore, to yicõari, Zebedeo rĩare jʉarãjʉrene ji vacami Jesús. To yi vacʉne, bʉto tʉoĩasʉtiriticami yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","To bajiro bajigʉne, ado bajiro yiyuju Jesús, ĩ rãca variarãre: —Bʉto tʉoĩasʉtiritiaja yʉ. Sʉtiriosene yʉre sĩaro yaja. Adone yʉre yuñaña maji. Yʉ cãnibetore bajirone cãnibeja mʉa quẽne, Diore sẽniñarã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","To yicõari, to sojʉabʉsa varẽmoñuju Jesús. Va, sita tũcurojʉ murocacũcõari, Diore sẽniñuju ĩ: —Cacʉ, yʉre ĩna sĩarotire matamasiaja mʉ. To bajiboarine, mʉ bojarore bajirone bajiato —Diore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","To yigajano, Pedro mesa ĩna cãnitoyene ĩna tʉjʉ ejayuju. Ĩnare yujiocõari, ado bajise Pedrore ĩre yiyuju Jesús: —¿No yirã cojo hora cõro cãnibetibʉsarãne, yʉre yuñabetimasucõati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yʉ cãnibetore bajirone cãnibesa mʉa quẽne. To bajicõari, Diore sẽniña, “Vãtia ʉjʉ Satanás ĩ yirotisere yicõari, Dios ĩ bojabetire yirobe” yirã. Quẽnaro mʉare masiaja yʉ. “Dios ĩ bojasere yirʉcʉja” yirã ñaboarine, cojojirema rojose ʉsʉri cʉtirã ñari, Dios ĩ bojabetijʉare yirũgũaja mʉa —Pedro mesare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","To yicõari, gãme vacʉ, ado bajiro Diore sẽniñuju Jesús: —Cacʉ, yʉre ĩna sĩaroti matamasiaja mʉ. To bajiboarine, mʉ bojarore bajirone bajiato —Diore yisẽniñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","To yigajano vacʉne, cãniariarãre ĩnare ejayuju quẽna. Bʉto vʉjaejarã ñari, cãniñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","To bajiri rĩjoro ĩnare ĩ yiriarore bajirone ĩnare yicõa, Diore sẽnigʉ̃ vacoasuju quẽna. To ejacõari, rĩjoro Diore ĩ sẽniriarore bajirone ĩre sẽniñuju quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Diore sẽnigʉ̃ var'i, tudiejacõari yʉare yujiocami: —¿No yirã cãni manicõati mʉa maji? Ado cõrone Dios ĩ roticõacacʉre rojose yirãre yʉre ĩsirocarocʉ vadicoagʉmi yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","To bajiri yujiya mʉa. Ĩre bocarã vajaro. Yʉre ĩsirocarocʉ vadiami yuja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","To bajiro Jesús yʉare ĩ yiñarirĩmarone, Judas Iscariote vãme cʉtigʉ, yʉa rãcagʉne, vadicami yuja. Jãjarã ĩ rãca vadicama jariaseri cʉorã, gãjerã yucʉ́juriri cʉorã. Bʉcʉrã, paia ʉjarã quẽne ĩna cõariarã ñacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jẽre ado bajiro goti vadiruyuyumi Judas, ĩ rãca vanare, “ ‘Ĩne ñaami Jesús’ yiĩamasiato ĩna” yigʉ: —Jesúre sẽnicõari, ĩre usurʉcʉja yʉ. To yʉ yirone, ĩre ñiama mʉa —ĩnare yi vadiruyuyumi. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","To bajiro yir'i ñari, Jesús rĩjorojʉa ejacõari, ado bajiro ĩre yicami Judas: —Gotimasiorimasʉ, ¿ñati mʉ? —ĩre yigʉne, usucami. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","To ĩ yirone, ado bajiro yicami Jesús: —“To bajiro yirãsa mani” ĩnare mʉ ũmato yivadiriarore bajiro yiya mʉ —ĩre yicami Jesús. To ĩ yirone, ĩre ñiacama Judas rãca vadiriarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","To ĩna yirone, sĩgʉ̃ Jesúrãcagʉ, ĩ jariase yoveaãmicõari, paia ʉjʉ ñamasugʉ̃re moabosarimasʉre gãmoro jatarocacõacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","To ĩ yisere ĩacõari, ado bajiro ĩre yicami Jesús: —Mʉ jariasere tudisuacõaña quẽna. “Jariase rãca gãmerã quẽarãma, tiase rãcane sĩaecorʉarãma”, yimasiaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ado cõrone yʉ jacʉre yʉ sẽnijama, setenta y dos mil ñarã ángel mesare cõamasicõagʉ̃mi. ¿Tire masibeati mʉ? ");
INSERT INTO bsnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","To bajiboarine, ĩnare ĩre yʉ sẽnijama, Dios oca masa ĩna ucamasire, “To bajiro bajirʉaroja” ĩna yimasiriarore bajiro bajibetiboroja. To bajiri tire ĩre sẽnibeaja yʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","To yicõari, ĩre ñiarã ejarãjʉare ado bajiro yicami Jesús: —¿No yirã gajeyeũni juarudirimasʉre ñiarã vanare bajiro jariaseri rãca, yucʉ́juriri rãca yʉre ñiarã vadiati mʉa? Tocãrãcarʉ̃mʉne Diore yirʉ̃cʉbʉoriavijʉ mʉa ñaro mʉare gotimasio rujirũgũmʉ yʉ. To yʉ bajiboajaquẽne yʉre ñiabetirũgũmʉ mʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Diore gotirẽtobosarimasa, ado bajiro yʉre mʉa yirotirene ucamasiñuma. To bajiri to bajirone yʉre yaja mʉa —ĩnare yicami Jesús, ĩre ñiarã ejarãre. Jesúre ĩna ñiasere ĩacõari, ũmarudijedicoacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesúre ñiacõari, paia ʉjʉ ñamasugʉ̃ Caifás vãme cʉtigʉ tʉjʉ ĩre ãmiasujarã. Tojʉ rẽjacõari, ñañujarã Dios ĩ rotimasire gotimasiorimasa, to yicõari, bʉcʉrã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesúre ĩna ãmivato, sõjʉ yayiĩasʉyayuju Pedro. Ĩnare yayiĩasʉyacõari, paia ʉjʉ ñamasugʉ̃ ya vi, ta biberiasãniro rẽtosãjacoasuju. Sãjacõari, Diore yirʉ̃cʉbʉoriavi coderimasa rãca rujiyuju ĩ. “No bajiro Jesúre ĩna yigajano vato ĩagʉ̃sa” yigʉ, tojʉ bocaĩarujiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paia ʉjarã, to yicõari, gãjerã ʉjarã, ĩna jediro, Jesúre sĩarʉayujarã. To bajiro yirã ñari, “Rojose masu yigʉ ñaami Jesús” yisocaronare macañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jãjarã masa socarãne ĩna gotiboajaquẽne, to bajiro ĩna yisere ajicõari, “To bajiro ĩ yire ñajare, ĩre sĩaroti ñaja”, yimasibesujarã ĩna maji. To bajiboarine, jʉarã ejayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ejacõari, ado bajiro socarãne gotiyujarã: —“Diore yirʉ̃cʉbʉoriavire caguerocamasiaja yʉ. To yicõari, idiarʉ̃mʉ tʉsatirʉ̃mʉne bʉajeocõamasiaja”, yicami ãni —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","To ĩna yirone, paia ʉjʉ ñamasugʉ̃, vʉ̃mʉrʉ̃gʉ̃cõari ado bajiro Jesúre yiyuju: —To bajiro mʉre ĩna yi ocasãsere, ¿no bajiro yati mʉ? ¿Cʉdibeati mʉ? —Jesúre ĩre yiboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","To ĩ yiboajaquẽne, cojo vãme cʉdibeticõañuju. Ĩ cʉdibetire ĩacõari, ado bajiro Jesúre yiyuju paia ʉjʉ ñamasugʉ̃: —Quẽnaro riojo yʉare cʉdiya mʉ. Mʉ socajama, rojose mʉre yirʉcʉmi Dios. ¿“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'ine, Dios macʉne ñati mʉ? —Jesúre ĩre yisẽniĩañuju paia ʉjʉ ñamasugʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Mʉ yirore bajirone bajiaja. Ĩne ñaja yʉ. To bajiri, Dios ĩ roticõacacʉ ñari, yoaro mene ĩ riojojacatʉa rujicõari, masare besegʉagʉ oco bueri vatoajʉ yʉ rujiadire ĩarʉarãja mʉa, —paia ʉjʉ ñamasugʉ̃re yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","To bajiro Jesús ĩ yisere ajitegʉ ñari, ĩ sudire tʉ̃avoyuju paia ʉjʉ ñamasugʉ̃. To yigʉne, ado bajiro ĩ rãcanare yiyuju: —¡To bajiro ĩ ñagõjama, Diore rʉ̃cʉbʉobecʉ yami! ¡“Diore bajiro bajigʉ ñaja yʉ” yigʉ yami! No yirã gãjerã, “Rojose yigʉ ñaami” yironare macarẽmomenaja mani yuja. Mʉa quẽne, Diore rʉ̃cʉbʉobecʉ ĩ yisere ajiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","To bajiro ĩ yisere ajicõari, ¿no bajiro ĩre yiroti ñati? —ĩ rãcanare yiyuju paia ʉjʉ ñamasugʉ̃. To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyujarã: —Rojose masu yicõami. Ĩre sĩacõaroti ñaja —yicʉdiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","To yicõari, Jesús riogare gooco eoreatuyujarã ĩna. To yicõari, ĩ cajere siabibecõari, ĩre jayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","To yicõari, —“‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃ ñaja yʉ” mʉ yijama, mʉ masise rãca, “Ĩ, yʉre jami”, yʉare yiya —Jesúre yitud'iyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Vi jubeajʉ Jesúre rojose ĩna yiñarone, macajʉ́jʉa rujicõañuju Pedro. Sĩgõ paia ʉjʉ ñamasugʉ̃re moabosarimaso, Pedro tʉ ejacõari, ado bajiro ĩre yiyuju: —Jesús, Galilea sitagʉ rãca vacudirũgũgʉ̃ne ñagʉ̃ja mʉ quẽne —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","To bajiro so yisere ajicõari, masa jediro ĩna ajiro rĩjorojʉa ado bajiro yiyuju Pedro: —“Riojo yaja mʉ”, mʉre yimasibeaja yʉ —sore yiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","To bajiro sore yicʉdicõa, ta biberiasãniro sãjariasoje tʉ vasuju Pedro. To ĩ vatone, gajeo ĩre ĩacõari, ado bajiro yiyuju: —Ãni, Jesús Nazaret macagʉ rãca vacudigʉ ñaami —yiyuju, gãjerãre gotigo. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","To bajiro ĩnare so yisere ajicõari, ado bajiro yiyuju Pedro: —Ĩre masibeaja yʉ. Socʉ me yaja yʉ. Dios quẽne yʉre ajigʉmi —ĩnare yiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","To ĩ yigotiriaro bero yoatobʉsa, to ñarã ado bajiro Pedrore gotiyujarã: —Riojo yaja yʉa. Jesúrãca vacudirũgũgʉ̃ne ñaja mʉ. Ĩna ñagõsere bajirone ñagõaja mʉ —Pedrore ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Ĩre masibeaja yʉ. Socʉ me yaja. Dios yʉre ajigʉmi —ĩnare yiyuju Pedro. To bajiro ĩ yigajanorirĩmarone, gãjabocʉ ñagõcõañuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ĩ ñagõsere ajicõari, Jesús ado bajise ĩre ĩ gotirere masibʉjayuju Pedro yuja: “Gãjabocʉ ĩ ñagõroto rĩjoro, idiaji, ‘Jesúre masibeaja yʉ’ yirʉcʉja mʉ” ĩre ĩ yirere masibʉjayuju. Tire masibʉjacõari, vacoasuju. Vacõari, bʉto otiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Busuro bero, bʉcʉrã, paia ʉjarã quẽne, ĩna jediro tudirẽjañujarã ĩna. To bajicõari, “Ado bajiro mani yijama, Jesúre sĩarʉarãma”, yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","To bajiro yirã ñari, Jesús ãmorire siacõari ĩre ãmiasujarã ĩna, Pilato vãme cʉtigʉ ya vijʉ vana. Jud'io masa ʉjʉ ñamasugʉ̃, romano masʉ ñañuju Pilato. To bajiri ĩ ya vijʉ Jesúre ãmiejayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesúre ĩsirocacacʉ, “Jesúre sĩaroti ñaja” ĩna yisere ajicõari, “Rojose yibʉ yʉ”, yitʉoĩa sʉtiritiyuju. To bajigʉ ñari, bʉcʉrã, paia ʉjarã quẽne, Diore yirʉ̃cʉbʉoriavijʉ ñarãre, ĩnare ejacõari, gãjoatiiri treinta ñaritiiri ĩre ĩna ĩsiboarere ĩnare tʉocõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Gãjoatiirire ĩnare ĩsigʉ̃ne, ado bajiro ĩnare yiyuju ĩ: —Rojose yibʉ yʉ. Ñie rojose yibecʉrene mʉare ĩsirocacõañuja yʉ —ĩnare yiyuju. To bajiro ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyujarã ĩna: —To bajiro yʉare mʉ yiboajaquẽne, no yibeaja yʉarema. Mʉre bajiroja —Judare ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","To ĩna yisere ajicõari, ti vijʉ gãjoatiiri ĩ ĩsiecoboarere reabateyuju Judas. To yi, gajano vacʉne, yucʉ́jʉ mʉjacõari, ti rʉjʉjʉ misimare siatucõari, ĩ ãmʉare quẽne siatu, quedirocayo rijacoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Diore yirʉ̃cʉbʉoriavijʉ gãjoatiiri Judas ĩ reabaterere juarẽoñujarã ĩna, paia ʉjarã. Tire juarẽocõari, ado bajiro yiyujarã: —Adi gãjoa mani vaja yise sʉorine sĩgʉ̃re sĩaroana yaja. To bajiri Diore yirʉ̃cʉbʉoriavi boarijaʉrire quẽnorʉarã, vaja yiroti gãjoa sãriajʉre sãbetiroti ñaroja —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","To bajiro yitʉoĩacõari, “Riri sotʉri vearimasʉ sitare vaja yito mani. Ti sita ñarʉaroja gajeroanare bajirearãre mani yujeroti sita”, yitʉoĩañujarã ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","To bajiri ti sita vaja yirʉarã, “Jesúre sĩato mani” yirã, Judare ĩna ĩsiboare rãca ĩna vaja yire ñari, adirʉ̃mʉri quẽne, Ri'i Vese vãme cʉticõa ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","To bajiro ĩna yijama, tirʉ̃mʉjʉ Diore gotirẽtobosarimasʉ Jerem'ias ñamasir'i ĩ ucamasiriarore bajirone bajiyuju. Ado bajiro ucamasiñuju ĩ: “‘Ado cõro vaja cʉtiami sĩgʉ̃ ʉ̃mʉ’ yitʉoĩarã ñari, ĩre ĩsir'ire treinta gãjoatiiri ĩna vaja yiboarere juacõari, riri sotʉri vearimasʉ sitare vaja yirʉarãma ĩna, Israel ñamasir'i jãnerabatia. To bajiro ĩna yijama, Dios ĩ bojarore bajiro yirã yirʉarãma”, yiucamasiñuju Jerem'ias ñamasir'i. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ti sitana ʉjʉ ñamasugʉ̃, romano masʉ ñañuju Pilato vãme cʉtigʉ. To bajiri ĩ tʉjʉ Jesúre ãmiasujarã ĩna. Ĩre ĩna ãmiejaro ĩacõari, ado bajiro sẽniĩañuju Pilato: —¿Mʉne ñati jud'io masa ʉjʉ? —Jesúre yiyuju Pilato. To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Mʉ yirore bajirone bajiaja yʉ —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","To bajiro Jesús ĩ yisere ajicõari, bʉcʉrã, paia ʉjarã quẽne, “Rojose yigʉ ñaami Jesús” Pilatore ĩre ĩna yi ocasãboajaquẽne, ĩnare ñagõcʉdibesuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","To bajiro Jesúre ĩna yi ocasãsere ajicõari, Jesúre tudisẽniĩañuju Pilato: —¿To bajiro mʉre ĩna yisere ajibeati mʉ? —Jesúre yiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","To bajiro ĩre ĩ yisẽniĩaboajaquẽne, ĩre cʉdibeticõañuju Jesús. Ĩ cʉdibetire ĩacõari, no yimasibesuju Pilato, ĩre bajiro bajigʉre ĩabetirũgũr'i ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tocãrãca cʉ̃ma, Pascua boserʉ̃mʉ jud'io masa ĩna quẽnojama, sĩgʉ̃, tubibe ecor'ire ĩna burotigʉre ĩnare bubosarũgũñuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tubiberiavijʉ ñañuju sĩgʉ̃, masa jediro ĩna masigʉ̃ Barrabás vãme cʉtigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","To bajiri ĩ yirũgũriarore bajiro yigʉ, masa ĩna rẽjarore ĩacõari, ado bajiro ĩnare sẽniĩañuju Pilato: —¿Ñimʉjʉare yʉ busere bojati mʉa? ¿Jesús Barrabás vãme cʉtigʉjʉare bugʉtique yʉ? Ĩre yʉ bubetijama, ¿“ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami Jesús” masa ĩna yigʉjʉare bugʉtique yʉ? —ĩnare yisẽniĩañuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","“Jesúre ĩajũnisinirã ñari, yʉre ĩsima” yitʉoĩagʉ̃, to bajiro yiyuju Pilato, Jesúre burʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oca ĩna ñagõquẽnorijʉjʉ ĩ rujiro, ĩ manajo ĩre queti cõañuju: “Rojose ĩre yibesa. Ñie rojose yigʉ me ñagʉ̃mi. To bajiro ĩ yiecoroto rĩjoro güiose cãjiriamʉ yʉ”, ĩre yicõañuju, so manajʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bʉcʉrã, paia ʉjarã quẽne ado bajiro tijʉ rẽjarãre masare, “Ado bajiro yiya”, ĩnare yirotiyujarã ĩna: —“Barrabájʉare bucõari, Jesújʉare sĩarotiya mʉ”, ĩre yiya mʉa —ĩnare yirotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Quẽna ado bajiro tudisẽniĩañuju Pilato: —¿Ñimʉjʉare yʉ busere bojati mʉa? —ĩnare yisẽniĩañuju. To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyujarã ĩna: —Barrabájʉare mʉ busere bojaja yʉa —yiyujarã ĩna, Pilatore. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","To ĩna yisere ajicõari, ado bajiro ĩnare sẽniĩañuju Pilato: —To yijama, ¿no bajiro yigʉti yʉ Jesúre, “ ‘Rotimʉorʉ̃gõrʉcʉja mʉ’ yigʉ, Dios ĩ cõar'i ñaami” masa ĩna yigʉjʉarema? —ĩnare yisẽniĩañuju. To ĩ yirone, ĩna ñaro cõrone ado bajiro ĩre avasãcʉdiyujarã: —¡Yucʉ́tẽrojʉ ĩre jajusĩaroticõaña mʉ! —ĩre yiavasã cʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","To ĩna yijare, ado bajiro ĩnare sẽniĩañuju Pilato: —¿Ñie rojose ĩ yire sʉori ĩre sĩarotigʉti yʉ? —ĩnare yiyuju Pilato. To ĩ yiboajaquẽne, quẽna bʉtobʉsa tudiavasãñujarã ĩna: —¡Yucʉ́tẽrojʉ ĩre jajusĩaroticõaña! —yiavasãñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","To bajiro ĩna yijare, no yimasibetiboacʉ, ado bajiro tʉoĩañuju Pilato: “No bajiro yicõari, ĩre bumasibecʉja yʉ. Ĩna bojarore bajiro yʉ yibetijama, avasãtʉjabeticõari, rojose yijacarãma ĩna”, yitʉoĩañuju. To bajiro tʉoĩacõari, oco juarotiyuju ĩ. To yicõari, ado bajiro ĩnare gotiyuju: —Mʉa ĩaro rĩjorojʉa yʉ ãmorire coeĩoaja yʉ, “Ãni rojose yibecʉre sĩarʉabeaja yʉma” yigʉ. To bajiri mʉa masune mʉa sĩarotijama, quẽnacõaroja. To bajiro mʉa yijama, mʉane sʉoye cʉtirʉarãja mʉa —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","To ĩ yisere ajicõari, masa ñajediro ĩre cʉdiyujarã: —Yʉa masiaja. ¡Yʉa, yʉa rĩa quẽne sʉoye cʉtirʉarãja, ĩre yʉa sĩarotijama! —ĩre yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","To bajiro ĩna yijare, Barrabáre bucõañuju Pilato. Jesújʉarema, ĩ surarare ĩsiñuju, “Ĩre bajecõari, yucʉ́tẽrojʉ ĩre jajusĩato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","To bajiri ĩna ya vijʉ Jesúre ãmiejayujarã surara mesa. Ĩre ãmiejacõari, ĩna jediro ĩre gãnibiarʉ̃gʉ̃ñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","To yicõari, “Ʉjʉre bajigʉ ñato” yirã, ado bajiro Jesúre yiyujarã: Jesús ĩ sudi sãñasere vejecõari, ʉjarã ĩna sãñarito ũnore, sũarivʉjorore ĩre sãñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","To yicõari, ĩ rʉjoa joere jotabedo ĩna suariabedone ĩre jeoyujarã. To yicõari, riojojacatʉaga ãmore, yucʉ́, ʉjʉ ĩ cʉoricʉre ĩre ĩsiñujarã. To bajiro ĩre yicõari, ĩ rĩjorojʉa gʉsomuniari tuetucõari, ado bajiro ĩre yiajatud'iyujarã: —Jud'io masa ʉjʉre mʉre quẽnarotiaja yʉa yuja —Jesúre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","To yirãne, gooco ĩre eoreatuyujarã ĩna. To yicõari, ĩ cʉoricʉre ẽmacõari, ĩ rʉjoare jayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","To bajiro ĩre yigajanocõari, ʉjarã ĩna sãñarito ũnore ĩna sãriarore ĩre veayujarã ĩna quẽna. To yicõari, ĩ sudijʉa ĩre sãñujarã quẽna. Ĩre sudi sãgajanocõari, yucʉ́tẽrojʉ jajusĩaroana ĩre ãmiasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ĩre ãmivanane, sĩgʉ̃ Cirene vãme cʉti sitagʉ, Simón vãme cʉtigʉre bocacama ĩna. Ĩre bocacõari, “Jesús ĩ gaja vatijãire ĩre gajabosaya”, ĩre yi vacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","To yi vanane, Gólgota vãme cʉti burojʉ ejacama ĩna. “Rʉjoco Buro” yire ũni ñacajʉ “Gólgota” yire. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tojʉ ejacõari, ʉye ocore, sʉ̃ese rãca vʉocõari Jesúre ĩre iocama ĩna. “Ĩre jũnise jũni ruyubeticõato” yirã, yiboacama. Tire idiĩaboa yicõacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yucʉ́tẽrojʉ Jesúre ĩre jajutugajanocõari, “Ñimʉjʉa ĩ sudire ĩ ʉjaro ĩarãsa mani” yirã, gʉ̃tarine reacũĩa ajeñacama. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","To yiajegajanocõari, ĩre code rujicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesús ĩ tuyaritẽrojʉre ĩ rʉjoa vecare ucaturiajʉ tuyacajʉ. “Ado bajiro ĩ yise sʉorine jaju ecoami” yiĩorijʉ ñacajʉ. Ado bajise goticajʉ: “Ãni ñaami Jesús, jud'io masa ʉjʉ”, yigoticajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesúrãca jʉarã, jaju ecocama. Gajeyeũni juarudirimasa ñacama ĩna. Sĩgʉ̃re ĩ riojojacatʉa, gãjire ĩ gãcojacatʉa ĩnare jajutucama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Masa rẽtoana, ĩna rʉjoarire yure, yure yicama, “Jaju ecor'ire ĩre ĩateaja” yirã. To yicõari, ado bajiro ĩre ajatud'icama ĩna: —Ado bajiro yiboacajʉ mʉ: “Diore yirʉ̃cʉbʉoriavire caguerocamasiaja yʉ. To yicõari, idiarʉ̃mʉ tʉsatirʉ̃mʉne bʉajeocõamasiaja”, yiboacajʉ mʉ. To bajiri “Dios macʉ ñaja yʉ” mʉ yisocabetijama, mʉ yimasise rãca mʉ masune yucʉ́tẽrojʉre rujicoaya —ĩre yiajatud'icama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bʉcʉrã, paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne, to bajirone Jesúre yiajatud'i ñacama ĩna. Ado bajiro yicama: ");
INSERT INTO bsnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Gãjerãrema catiogʉ ñaboarine, ĩ masu rojose ĩ tãmʉoserema yirẽtomasibeami —yiajatud'icama. —Israel ñamasir'i jãnerabatia ʉjʉ ñaami. To bajiri yucʉ́tẽrojʉre rujicoadiato. To bajiro ĩ bajiro ĩacõari, “Ĩne ñaami”, yimasirʉarãja —yiajatud'icama. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—“Dios macʉ ñaja yʉ. Yʉre ejarẽmorʉcʉmi”, yirũgũmi. To bajiri ĩ macʉne ĩ ñajama, ĩre ĩamaigʉ̃ ñari, ĩre yirẽtobosato Dios —yiajatud'icama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jʉarã Jesúrãca yucʉ́tẽrojʉ jaju ecoriarã quẽne, to bajirone Jesúre yitud'icama. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ʉ̃mʉrecaji ñarone, rẽtiacoacajʉ yuja. Idia hora rẽtiacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","To cõro ti rẽtiatʉsatone, ado bajiro tutuaro avasãcami Jesús: —El'i, El'i, ¿lema sabactani? —yiavasãcami. “Dios, yʉ jacʉ, ¿no yigʉ yʉre cãmotadiati mʉ?” yire ũni ñacajʉ ti, ĩ avasãcati. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sĩgʉ̃ri tojʉ ñarã ĩ avasãsere ajicõari, ado bajiro yicama ĩna: —Diore gotirẽtobosarimasʉ El'ias ñamasir'ire jigʉ yami ĩ —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","To bajiro Jesús ĩ yiavasãrone, sĩgʉ̃, Jesús tʉ ũmaejacõari, ʉye oco jiarere ñiabiacõari, yucʉ́ gajajʉ siatucõari, Jesús rise tʉjʉre ñumʉotuboacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","To bajiro ĩ yiboajaquẽne, ado bajiro yicama gãjerãjʉa: —Yibesa mʉ. Tone bajicõato. Rojose ĩ tãmʉosere yirẽtobosagʉ El'ias ñamasir'i ĩ ejasere ĩarãsa mani —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tutuaro avasãtʉsa, ʉsʉtadicoacami yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tirĩmarone Diore yirʉ̃cʉbʉoriavi yotoria gasero vorujijedicoasuju ti. “Dios ĩ ñarisõa vãme cʉti sõare sãjamasibeama masa” yirã, ĩna yotoria gasero ñacajʉ. To yicõari, sita sabecajʉ. Gʉ̃ta quẽne caguevẽjacoacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","To bajicõari, masare yujeriaviri quẽne jãnacoasuja. To bajicõari jãjarã rijariarã Diore ajitirʉ̃nʉriarã tudicaticoasuma. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tudicaticõari, ti virire budicoasuma. Budiacõari, Jesús ĩ tudicatiro bero, Jerusalénjʉ Dios ĩ beseria maca ñamasuri macajʉre ĩna vacudisere ĩacama jãjarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús yucʉ́tẽrojʉ ĩ tuyarore, codeñacama surara, ĩna ʉjʉ rãca. To bajiñarã, sita sabesere, gajeye güiose bajisere ĩacõari, bʉto güicama ĩna. To bajiri ado bajiro yicama: —Socabesumi. Dios macʉne ñaboayumi ãni —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Galilea sitajʉ Jesúre sʉyavadicana rõmiri jãjarã sõjʉ ĩarʉ̃gõcama. Ĩna ñacama ĩre ejarẽmorũgũcana. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ĩna rãca ñacamo Mar'ia Magdalena. Gajeo Mar'ia vãme cʉtigo quẽne ñacamo. Sone ñacamo Santiago, to yicõari, José jaco. Zebedeo ñamasicacʉ rĩa jaco quẽne ñacamo. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rãioroto rĩjoro José vãme cʉtigʉ, Arimatea macagʉ Jesús rujʉrire ĩagʉ̃ ejayuju. Gãjoa jaigʉ ñacami. To bajicõari, Jesúre ajitirʉ̃nʉrũgũcacʉ ñacami. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","To ĩ bajiro bero, Jesús rujʉrire ãmirʉ, Pilatore sẽnigʉ̃ vasuju. Ĩre ĩ sẽnirore bajirone ĩre cʉdiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","To bajiro ĩ yir'i ñari, Jesús rujʉrire rujiogʉ vasuju. Ĩre rujiocõari, sudijãiri botiquẽnarijãirine ĩre gũmañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","To yigajanocõari, masa yujeriavi gʉ̃tavi mame ĩ quẽnorotiriavijʉ ĩ rujʉrire cũñuju. To yicõari, ti vi sojere gʉ̃tane tũnuo bibecũ, vacoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","To bajiro ĩ yiñaro ĩañariarãjʉne masa yujeriavi rĩjorojʉa, Mar'ia Magdalena, gajeo Mar'ia quẽne, rujicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gajerʉ̃mʉ ñañuju ʉsʉsãjariarʉ̃mʉ. Tirʉ̃mʉne paia ʉjarã, fariseo masa quẽne, Pilatore ñagõrã vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ĩ tʉ ejacõari, ado bajiro ĩre yiyujarã ĩna: —Yʉa ʉjʉ, ajiya. Socarimasʉ ĩ yisocacatire masibʉjabʉ yʉa. “Idiarʉ̃mʉ tʉsatirʉ̃mʉne quẽna tudicatirʉcʉja yʉ”, yisocacami, ĩ sĩaecoroto rĩjoro. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","To bajiri ĩ rujʉrire ĩna yujeriavi soje tʉre surarare coderoticõaña, “Ĩ buerimasa ĩ rujʉrire ãmirudiroma” yigʉ. Ĩ rujʉrire ĩna ãmijama, “Rijar'i ñaboarine, quẽna tudicaticoami”, yisocarʉarãma ĩna. Ĩ rijaroto rĩjoro, “Ĩ rotimʉorʉ̃gõrotire yigʉ, Dios ĩ cõacacʉ, jud'io masa ʉjʉ ñaja yʉ” ĩ yisocacati ti ñajare, quẽnabeaja. To bajiri, “Tudicaticoami” ĩna yisocajama, quẽnabetimasucõarʉaroja —Pilatore yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","To ĩna yisere ajicõari, ado bajiro cʉdiyuju Pilato: —Mʉare yʉ ĩsicanarene coderotiya mʉa —ĩnare yicʉdiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","To ĩ yisere ajicõari, Jesús rujʉrire ĩna yujeriavire coderotiyujarã ĩna. To yicõari, gʉ̃ta sojere quẽnaro bibequẽnoñujarã ĩna, “Ĩ rujʉrire ãmirã ĩna jãnajama, ĩamasirãsa mani” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ʉsʉsãjariarʉ̃mʉ ti jediro, quẽna moasʉoriarʉ̃mʉ ti busumʉjado, Mar'ia Magdalena, gajeo Mar'ia quẽne, Jesús rujʉrire ĩna yujeriavire ĩarã vacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","To ĩna vatone, bʉto sita sabeyuju. To ti bajirone, sĩgʉ̃ ángel rujiejayuju. Rujiejacõari, Jesúre ĩna yujeriavire gʉ̃tane ĩna bibeboariare jãnañuju. To yicõari, tia joene rujiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bʉjo ĩ yabesere bajiro yaayuju ĩ. Ĩ sudi quẽne bʉto botiquẽnañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ĩre ĩacõari, güirã nanañujarã ti vire coderimasa. Nanacõari, rijavẽjarãre bajiro bajireacũcoasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","To ĩna bajirone, ángel ado bajiro rõmiajʉare gotiyuju: —Güibesa mʉa. Jesús yucʉ́tẽrojʉ ĩna jajusĩar'ire mʉa macasere masiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Maami adojʉre. Ĩ goticatore bajirone tudicaticoami. Ĩre ĩna yujeriajʉre ĩarã vayá. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tire ĩacõari, guaro ĩ buerimasare ado bajiro ĩnare gotiaya: “Quẽna tudicaticoasumi Jesús. To yicõari, mani rĩjoro Galilea sitajʉ varocʉ ñañuju. Tojʉ ĩre tudiĩarʉarãja mani”, ĩnare yigotiaya mʉa. Adire mʉare gotigʉ bajibʉ yʉ —ĩnare yiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","To ĩ yisere ajicõari, Jesús rujʉri ĩna yujeboariavijʉ budianane, güitʉoĩaboarine, variquẽnase rãca ũmacoayuma ĩna, Jesús buerimasare yʉare gotirã vana. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ĩna ũmavadone ĩnare sẽniĩacãnamua ruyuayuju Jesús. “¿Ñati mʉa?” ĩ yisere ajicõari, ĩre yirʉ̃cʉbʉorã, ĩ rĩjorojʉa muqueacõari, ĩ gʉborire ñiañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","To bajiro ĩre ĩna yirone, ado bajiro yiyuju ĩ: —Güibesa mʉa. Yʉ yarã yʉ buecanare ado bajiro ĩnare gotiaya: “Galilea sitajʉ vajaro. Tojʉ ĩre ĩarʉarãja mani”, ĩnare yiba —rõmiare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Rõmia ĩna gotirã vato ũnone, surara quẽne, Jesús rujʉrire ĩna yujeriavire codeboariarã sĩgʉ̃ri, macajʉ tudicoasujarã ĩna. Tudiejacõari, paia ʉjarãre gotiyujarã, ĩna ĩare ñaro cõrone. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti quetire ajicõari, bʉcʉrã rãca ñagõrã vasujarã paia ʉjarã. “To bajiro bajire ti ñajare, ado bajiro yirʉarãja mani” yimasirʉarã bajiyujarã ĩna. To bajiri, sĩgʉ̃re bajiro tʉoĩacõari, Jesúre ĩna yujeriavire codeboariarãre jairo gãjoa ĩsiñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","To yicõari, ado bajiro ĩnare socarotiyujarã ĩna: —“Ñami yʉa cãnitoye, ĩ ñaboar'i buerimasane Jesús rujʉrire ãmirudicoasuma ĩna”, yigotibatoya mʉa —masare yiyujarã bʉcʉrã, paia ʉjarã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","—Ʉjʉ Pilato ti quetire ajicõari, mʉare ĩ jũnisinijama, mʉare ñagõbosarʉarãja yʉa, “Rojose ĩnare yibesa” yirã. Yʉare cʉdicõarʉcʉmi —ĩnare yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","To bajiro ĩna yijare, gãjoare boca juacõari, ĩnare ĩna rotiriarore bajirone socase queti goticudiyujarã ĩna, Jesúre ĩna yujeriavire codeboariarã. To bajiri adirʉ̃mʉri quẽne, “Tudicatibesuju Jesús. Ĩ ñaboar'i buerimasane, ĩ rujʉrire ãmirudiyujarã ĩna” yire quetire goticõa ñarũgũama jud'io masa. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesús ĩ tudicatisere, rõmia ĩna gotisere ajicõari, Galilea sitajʉ vacajʉ yʉa, ĩ buerã, jʉaãmo cõro, gʉbo coja jẽnituarirãcʉ ñarã. “Ti buro joejʉ yʉre ĩarʉarãja mʉa” yʉare ĩ yicatojʉ vacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tojʉ ejacõari, Jesúre ĩacajʉ yʉa. Ĩre ĩacõari, ĩre rʉ̃cʉbʉocajʉ yʉa. Sĩgʉ̃ri, “Ĩ me ñaami”, yitʉoĩacama ĩna, bajirãjʉma. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","To bajiro yʉa yirone, ado bajiro yʉare yicami Jesús: —Adi macarʉcʉrojʉre, to yicõari, õ vecajʉre quẽne, “Rotigʉ ñarʉcʉja mʉ”, yʉre yicũmi yʉ jacʉ, Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","To bajiri mʉare quẽne masa jedirore yʉ ocare mʉare goticudirotiaja, “Yʉre ajitirʉ̃nʉato” yigʉ. To yicõari, yʉre ajitirʉ̃nʉrãre ĩacõari, yʉ jacʉ vãme, yʉ vãme, to yicõari Esp'iritu Santo vãme rãca oco rãca ĩnare bautizaba mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","To yicõari, “Jediro yʉ rotisere cʉdiato” yirã, ĩnare gotimasioma. Yʉre mʉa ĩabetiboajaquẽne, cojorʉ̃mʉ rʉyabeto mʉa rãca ñarũgũrʉcʉja yʉ, mʉare ejarẽmogʉ̃. To bajiro bajicõa ñarʉcʉja yʉ, adi macarʉcʉro ti jedirojʉ —yʉare yicami Jesús. To cõrone ñaja.");
INSERT INTO bsnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","3","“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i, Jesús ĩ bajirere mʉare gotigʉ yaja yʉ. Ĩne ñaami Dios macʉ. To bajiri, ado bajiro ñasʉoaja: Jesúre goti rĩjoro cʉtigʉ ñañuju Juan vãme cʉtigʉ, tirʉ̃mʉjʉ ĩre ĩ goti rĩjoro cʉtirotire yigʉ, Diore gotirẽtobosarimasʉ, Isa'ias vãme cʉtigʉ ado bajiro ĩ yiucamasire ñajare: “‘“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, mʉre yʉ cõaroto rĩjoro, mʉre gotiyurocʉre cõasʉorʉcʉja yʉ maji’ yami Dios. Yucʉ́ manojʉ ado bajiro gotimasiorʉcʉmi: ‘Mani ʉjʉ ejarʉcʉmi. To bajiri, rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya mʉa, ĩre yurã’ yirʉcʉmi”, yiucamasiñumi Isa'ias, Juan ĩ bajirotire goti rĩjoro yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","To bajiri, yucʉ́ manojʉ ñacõari, ado bajiro ĩre ajirã ejariarãre gotimasiocudirũgũñuju ĩ: —Rojose mʉa yisere tʉoĩasʉtiritiya mʉa. To yicõari, “Rojose yirʉabeaja yʉa. Diorãca quẽnaro ñarʉarãja yʉa” yirã, oco rãca yʉre bautizarotiya mʉa. To bajiro mʉa yijama, rojose mʉa yisere mʉare masiriorʉcʉmi Dios —ĩnare yigoticudirũgũñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","6","Camello joane suariaro sãñagʉ̃ ñañuju ĩ. To yicõari, vecʉ gaserone vẽñaricũñuju, ĩ sãñasere. Ñimia ba, to yicõari, beroa ocore idi, yirũgũñuju. Ĩre ajirã, jãjarã masa ejayujarã. Jerusalén macana, Judea sitana quẽne ejayujarã. To bajiro ĩ gotisere ajirã ñari, “Rojose mani yisere Dios manire masirioato” yirã, “Rojose yirã ñaja yʉa” Diore ĩna yigotiro bero, Jordán vãme cʉtirisajʉ oco rãca ĩnare bautizayuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Gaje vãme ado bajiro masare gotimasiorũgũñuju ĩ: —Yʉ bero yʉ rẽtoro masigʉ̃ ejarʉcʉmi. Ñamasurã rĩne ĩre yibosamasiama, ñamasugʉ̃ masu ĩ ñajare. Rojose ĩna yisere yitʉjacõari, Dios ĩ bojasejʉare yirãre oco rãca bautizarũgũaja yʉ. To bajiro yʉ yirũgũse ti quẽnaboajaquẽne, yʉ bero ejagʉ ĩ moasejʉa quẽnamasucõarʉaroja. Ĩma, Esp'iritu Santore cõamasirʉcʉmi, masare. Ĩ sʉorine, “Dios ĩ bojabetire yaja yʉa” yimasicõari, tʉoĩavasoarʉarãma —ĩnare yigotimasiorũgũñuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tirʉ̃mʉrine Galilea sitajʉre ñarimaca Nazaret vãme cʉti maca ñar'i, Jordán vãme cʉtirisajʉ vasuju Jesús. Juan tʉjʉ ejacõari, oco rãca ĩre bautizarotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Juan ĩre ĩ bautizaro bero, majarʉ̃gʉ̃gʉ̃ne, õ vecajʉ ʉ̃mʉagasero soje, ti jãnasere ĩañuju Jesús. Ti jãnarone, Esp'iritu Santo, bujare bajigʉ rujiadicõari, ĩ joere ĩ rocajeosere ĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jesús joere ĩ rocajeorone, ado bajiro yi ocaruyuyuju õ vecajʉ: —Yʉ macʉ, yʉ maigʉ̃ masu ñaja mʉ. Mʉ rãca bʉto variquẽnaja yʉ —yi ocaruyuyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesús, oco rãca Juanre ĩ bautizarotiro bero, yucʉ́ mano, vaibʉcʉrã ĩna ñarojʉ, ĩre ũmato vasuju Esp'iritu Santo. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tojʉre cuarenta ñarirʉ̃mʉri ñañuju Jesús. Tojʉ ĩ bajiñarone, vãtia ʉjʉ Satanás, ĩre ejacõari, “Yʉ rotisere yicõari, Dios ĩ bojabetire yato” yigʉ, ĩre rotirũgũboayuju. Ĩre cʉdibesuju. To bajicõari, Diore moabosarã ángel mesa ĩre ejarẽmoñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tirʉ̃mʉri, tubiberiavijʉ Juan ĩ tubibe ecoro bero, Galilea sitajʉ vacoasuju Jesús. Dios oca quẽnasere gotimasiocudigʉ vasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ado bajiro masare gotimasiocudiyuju: —“To cõrone bajirʉaroja yʉre rotibosarocʉ, ĩ rotisʉoroti” Dios ĩ yitʉoĩariajʉ ejaja yuja. Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, ĩ oca quẽnasere mʉare yʉ gotisere ajitirʉ̃nʉña —masare yigotimasiocudiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cojorʉ̃mʉ, ʉtabʉcʉra Galilea vãme cʉtira tʉjʉ vacudigʉ vasuju Jesús. To vacʉjʉ, ĩañuju, Simón vãme cʉtigʉre, bero Pedro vãme cʉtirocʉre, ĩ bedi Andrére quẽne. Vai sĩarimasa ñañujarã ĩna. Bajiyucʉrire rearoderuu yiñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ĩna tʉ ejacõari, ado bajiro yiyuju Jesús: —Yʉ rãca vayá. Yucʉrema mʉa vai vejese ũnirene masa yʉre ĩna ajitirʉ̃nʉrotire gotimasiobosarimasa ñarʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","To ĩ yirirĩmarone, ĩna bajiyucʉrire cũ, ĩre sʉyacoasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","20","To yi varũtu vacʉne, gãjerã jʉarã ñarãre ĩnare jiyuju Jesús. Ĩna ñañujarã Santiago, ĩ bedi Juan rãca. Ĩna jacʉ Zebedeo rãca cũmuajʉ ĩna bajiyucʉrire siaquẽno sãñañujarã. To ĩ yisere ajicõari, ĩna jacʉre, ĩre moabosarãre quẽne vaveocoasujarã, Jesúre sʉyana. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaum macajʉ ejayujarã ĩna. Ti macajʉ ĩna ejaro bero, ʉsʉsãjariarʉ̃mʉ ti ejaro, Dios ocare ĩna buerivijʉ sãjañuju Jesús. Sãjacõari, masare gotimasioñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dios ĩ rotimasire gotimasiorimasare bajiro me, ʉjʉre bajiro bojonebecʉne quẽnaro ĩ gotimasiojare, ajiĩañamani ĩ gotise ti ñajare, no yimasibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti vire sĩgʉ̃ ʉ̃mʉ ñañuju, ĩ ʉsʉjʉ vãti sãñagʉ̃. Jesús, masare ĩ gotimasiorone, ĩ ʉsʉjʉre sãñacõari ado bajiro Jesúre ĩre yiavasãñuju vãti: ");
INSERT INTO bsnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, Nazaret vãme cʉti macagʉ, ¿no yigʉ yʉa tʉ vadiati mʉ? ¡Yʉare gõjanabiobesa! ¿Rojose yʉa yise vaja, rojose yʉare yigʉagʉ vadiati mʉ? Mʉre ĩamasiaja yʉa. Rojose yigʉ me, Dios ĩ cõar'i ñaja mʉ —Jesúre yiavasãñuju vãti. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","To ĩ yirone, oca tutuase rãca ado bajiro ĩre yiyuju Jesús: —¡Ñagõbesa mʉ! ¡To yicõari, ĩ ʉsʉjʉre budigoya! —vãtire ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","To ĩ yirone, rijaquedirotiyuju vãti, masʉre. To yi, bʉto avasãcõari, masʉ ʉsʉjʉre budigocoasuju yuja. To ĩ bajijare, masʉjʉama quẽnaejacoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","To bajisere ĩacõari, ti vi ñarã jediro no yimasibesujarã ĩna, ti ũnire ĩabetirũgũriarã ñari. To bajicõari, ĩna masune ado bajiro gãmerã sẽniĩañujarã: —¿No bajiati? Ajiĩañamani oca manire gotimasiogʉ̃ yami. Bʉto masigʉ̃ ñaami. Vãtia bʉto masirã ĩna ñaboajaquẽne, masa ʉsʉrijʉre sãñarãre ĩnare bureamasiami —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","To bajiro Jesús ĩ yiñasere masa ĩna gotibatojare, yoaro mene Galilea sitana tire ajijediyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","To bajiro Jesús ĩ yiro berone, Dios ocare ĩna buerivijʉ budiasuju. Santiago, ĩ bedi Juan quẽne, gãjerã Jesús ĩ buerimasa quẽne ĩ rãca vasujarã, Simón ĩ bedi Andrés rãca ĩna ñarũgũriavijʉre vana. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","To ĩna ejarone, Jesúre gotiyujarã ĩna: —Simón ũmañico bʉto asicõari, bʉbʉribʉjaamo —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","To bajiro ĩna yijare, Jesús, so tʉ ejarʉ̃gʉ̃cõari, sore tʉ̃avʉ̃mʉoñuju. To ĩ yirirĩmarone, sore rujʉ asiboase sore tʉjacoasuju. To bajiro ĩ yicatiocõario, bare ĩnare ecayuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tirʉ̃mʉ, rãiorijʉne, rijaye cʉtirãre juaejayujarã masa, “Jesús ĩnare catiato” yirã. Ĩna ʉsʉrijʉ vãtia sãñarãre quẽne juaejayujarã, “Vãtiare bureato Jesús” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gãjerã quẽne, ti macana jediro soje tʉ rẽjañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jãjarã ñañujarã rijaye cʉtirã, to yicõari, ĩna ʉsʉrijʉ vãtia sãñarã, masa ĩna juaejoriarã. Rijaye cʉtirãre catioyuju. To yicõari, ĩna ʉsʉrijʉre sãñarãre vãtiare bureayuju. Vãtia, ĩre ĩna ĩamasisere ĩacõari, ĩnare ñagõrotibesuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gajerʉ̃mʉ busujedibetibʉsarojʉne, masa manojʉ vacoasuju Jesús, Diore sẽnigʉacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","To ĩ bajiboajaquẽne, Simón ĩ babarã rãca ĩre macasʉya, ejacoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ĩre ĩabʉjacõari, —Masa jediro mʉre macaama —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","To bajiro ĩna yiboajaquẽne, ado bajiro ĩnare cʉdiyuju Jesús: —Ita. Gaje macarianare quẽne quẽnase quetire gotimasiocudirocʉ ñaja yʉ. Tire yigʉ vadicajʉ yʉ —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","To bajiri Galilea sitajʉ gotimasiocudiyuju Jesús. Tocãrãca macarirene Dios ocare ĩna buerivirijʉ sãjaejacõari, oca quẽnasere masare ĩnare gotimasioñuju. To yicõari, ĩna ʉsʉrijʉre sãñarãre vãtiare bureayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To bajiri sĩgʉ̃ gase boagʉ, Jesús rĩjorojʉa gʉsomuniari tuetuejayuju, ĩre rʉ̃cʉbʉogʉ. To yicõari, ado bajiro Jesúre ĩre yiyuju: —Yʉ ʉjʉ, yʉ cãmire mʉ yarʉajama, yaya —ĩre yisẽniñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","To bajiro ĩre ĩ yisere ajicõari, —Mʉ cãmire yarʉcʉja yʉ —ĩre yigʉne, ĩre moaĩañuju Jesús. To bajiro ĩ yirirĩmarone, ĩ cãmi ĩre yaticoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","To ĩre yigajanocõari, —Gãjerãre gotibetimasucõama —ĩre yiyuju Jesús. To yicõari, ado bajiro ĩre rotiyuju: —Yucʉacane paire mʉ rujʉre ĩoaya. Mʉ rujʉre ĩre ĩogʉ̃ne, Moisére Dios ĩ roticũmasiriarore bajiro vaibʉcʉrã ecariarãre sĩacõari, paire ĩre ĩsima, Diore rʉ̃cʉbʉogʉ. To mʉ yisere ĩacõari, “Caticoasumi”, yirʉarãma masa —ĩre yiyuju Jesús, gase boaboar'ire. ");
INSERT INTO bsnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ĩre ĩ gotirotibetiboajaquẽne, masa jedirore gotibatoyuju, “Yʉ gase boasere yacõami Jesús” yigʉ. To bajiro ĩ gotibatojare, macari Jesús ĩ vacudijama, yayioro vacudirũgũñuju ĩ. To bajiri, masa manojʉ ñacudirũgũñuju. To ĩ bajiñaboajaquẽne, macariana ñajediro ĩre ĩarã ejarũgũñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","To bajiro ĩ yicudiriarʉ̃mʉri bero, Capernaum vãme cʉti macajʉ tudiejayuju Jesús quẽna. Ĩ ñarũgũrivijʉre ĩ tudiejasere ajiyujarã masa. Tire ajicõari, ĩ tʉjʉ rẽjañujarã ĩna. Jãjarã ĩna ñajare, vi jʉ̃mʉcoasuju ti. Nojʉa rʉ̃gõriajʉ mañuju. Soje tʉ quẽne, nojʉa rʉ̃gõriajʉ mañuju. To ĩna bajirone, vi jubeajʉ Dios oca ĩnare gotimasio ñañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","To bajiro ĩ yiñarone, babaricãrãcʉ ñacõari, micagʉ̃re ãmiejayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ĩre ãmiejacõari, Jesús tʉjʉ cũrʉaboayujarã ĩna. To ĩna yirʉaboarore jãjarã ñabibecõañujarã. To bajiri vijʉre sãjamasibesujarã. “Tire bajicõaja” yirã, vi joejʉ ĩre ãmimʉjasujarã. Ĩre ãmimʉjacõari, Jesús ĩ rʉ̃gõro vecare goje yijorayujarã. To yigajano, micagʉ̃re ĩ jesarijʉ rãcane ĩre jidirujio ejoyujarã, Jesús tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","“Ĩre ĩamaicõari, ĩre catiorʉcʉmi” ĩna yitʉoĩasere ĩamasicõari, micagʉ̃jʉare ado bajiro ĩre yiyuju Jesús: —Rojose mʉ yirere mʉre masiriocõaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","To ĩ yisere ajicõari, ti macana sĩgʉ̃ri Dios ĩ rotimasire gotimasiorimasa, ado bajiro tʉoĩañujarã: ");
INSERT INTO bsnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿No yigʉ to bajise yati ĩ? To bajiro ĩ ñagõjama, Diore ĩre rʉ̃cʉbʉobecʉ yami ĩ. Dios sĩgʉ̃ne ñagʉ̃mi ti ũnire yimasigʉ̃ma”, yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","To bajiro ĩna yitʉoĩasere ĩamasicõari, ado bajiro ĩnare yiyuju Jesús: —“‘Diore bajiro masa rojose ĩna yisere masiriomasiaja’ yisocaami”, yʉre yitʉoĩaboaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Rojose mʉ yisere masiriocõaja” yʉ yicõa tʉjajama, “Socʉ yami. Socʉ me yami” yʉre yiĩamasigʉ̃ magʉ̃mi. To bajiboarine, “Vʉ̃mʉrʉ̃gʉ̃cõari, vasa” ĩre yʉ yijama, “Socʉ me yami. Rojose ĩ yirere masiriocõami”, yʉre yiĩamasirãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","To bajiri, Dios ĩ roticõacacʉ ñari, “‘Diore bajirone masare rojose ĩna yisere masiriomasigʉ̃ ñaami’ yʉre yiĩamasiato” yigʉ, ãni micagʉ̃re ado bajiro ĩre yaja yʉ: ");
INSERT INTO bsnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Vʉ̃mʉrʉ̃gʉ̃ña mʉ. Mʉ jesarijʉre ãmiña. To yicõari, mʉ ya vijʉ tudiasa”, ĩre yaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","To ĩ yirirĩmarone, masa jediro ĩna ĩaro rĩjoro vʉ̃mʉrʉ̃gʉ̃cõari, ĩ jesarijʉre ãmi, ĩ ya vijʉ vacoasuju ĩ yuja. To bajiro Jesús ĩ yisere ĩaʉcacoasujarã masa. “Ti ũnire ĩabetirũgũcajʉ mani. Ãni, Dios ĩ masise rãca yigʉ yami” yitʉoĩacõari, —Quẽnaro yaja mʉ —Diore ĩre yivariquẽnañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Micagʉ̃re ĩ catioriaro bero, Ʉtabʉcʉra Galilea vãme cʉtira tʉjʉ quẽna tudivasuju Jesús. Tojʉ jãjarã masa rẽjañujarã. Ĩna rẽjasere ĩacõari, Dios oca ĩnare gotimasioñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Gotimasio gajano, vacʉne, Lev'i vãme cʉtigʉre ĩre ĩabʉjayuju. Alfeo macʉ ñañuju ĩ, Lev'i. Ʉjʉre gãjoa sẽnibosarimasʉ ñañuju. Gãjoa sẽnirã ĩna rujirijʉre gãjoa sẽnirujiyuju. To ĩ yiñaro, ĩacõari, —Yʉre ajisʉyaya —ĩre yiyuju Jesús. To bajiro ĩ yisere ajicõari, ĩre sʉyacoasuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bero, Lev'i ya vijʉ ejacõari, bayuju Jesús. To bajiri Jesúrãca bañañujarã Lev'i ĩ yiriarore bajiro rojose yirã, ʉjʉre gãjoa sẽnibosarimasa, gãjerã “Rojose yirã ñaama” masare yiĩarã quẽne. To yicõari, Jesús buerimasa quẽne bañañujarã ĩna. To bajiri jãjarã masu ñañujarã Jesúre ĩre ajisʉyarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","To ĩna bañarone, ejayujarã fariseo masa, Dios ĩ rotimasirere gotimasiorimasa quẽne. Ĩna ñañujarã, Moisére Dios ĩ roticũmasirere bʉto ajirʉ̃cʉbʉorã, rojose yirã rãca ñarʉamena. Ejacõari, rojose yijairã rãca ĩna bañasere ĩacõari, Jesús buerimasare ĩnare sẽniĩañujarã: —¿No yigʉ mʉare buegʉma, ãnoa rojose yirã rãca bañati? —yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","To bajiro ĩna yisẽniĩajare, ado bajiro ĩnare cʉdiyuju Jesús: —Catiquẽnarãma, ʉco yigʉre bojamenama. Rijaye cʉtirã rĩne ĩre bojarãma ĩna. To bajiro bajiaja yʉre quẽne. “Rojose yirã me ñaja yʉa”, yirãma, yʉre bojamenama. “Rojose yirã ñaja yʉa” yirã rĩne yʉre bojarãma. Quẽnaro yirãre jigʉ me, adi macarʉcʉrojʉre vadicajʉ yʉ. Rojose yirãre, “Rojose ĩna yisere yitʉjato” yigʉ, vadicajʉ yʉ. To bajiri ãnoa, “Rojose yirã ñaama” mʉa yiĩarã rãca bañaja yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan masare oco rãca bautizarimasʉ ĩ buerã, fariseo masa quẽne, ĩna ñicʉa ĩna yimasiriarore bajiro bare bamenane Diore sẽniñujarã, “Mani sʉtiritisere ĩacõari, quẽnaro manire ejarẽmoato Dios” yirã. To ĩna yirirʉ̃mʉre Jesúre sẽniĩarã ejayujarã sĩgʉ̃ri: —Juan ĩ buerimasa, to yicõari, fariseo masa quẽne, mani ñicʉa ĩna yimasiriarore bajiro Diore ĩna sẽnirirʉ̃mʉrirema bare babetirũgũama. ¿No yirã tire yibeati mʉ buerãma? —Jesúre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","To ĩna yisere ajicõari, ado bajiro ĩnare gotimasioñuju Jesús: —Sĩgʉ̃ ĩ ãmosiarirʉ̃mʉre ĩre variquẽnaejarẽmorã ñarãma. To ĩ ũmato yiñaro cõro ĩre variquẽnaejarẽmorãma. Ĩnare bajiro bajiama yʉ buerã. Yʉ rãca ñari, variquẽnacõa ñaama. “Sʉtiritimena ñari, no yirã bare babeticõa yimenama” yimasire ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","To bajiboarine, cojorʉ̃mʉ yʉre ĩna ñiavato ĩacõari, bare bamenane Diore sẽnirʉarãma, “Mani sʉtiritisere ĩacõari, quẽnaro manire ejarẽmoato Dios” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mame oca yʉ gotimasiose ricati ti ñajare, yʉ ye rãca mani ñicʉa ĩna yimasirere mʉa tʉoĩavʉojama, quẽnabeaja. Sudiro bʉcʉase ti vojama, mamagasero rãca seretumasimenaja mani. Mamagaserone mani seretujama, mani coero bero carato tʉ̃atutu vatone bʉcʉasejʉa vocoatoja. Bʉcʉase, mamase rãca mani seretumasibetore bajirone, mame oca yʉ gotimasiosere, mani ñicʉa oca rãca tʉoĩavʉobesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","To bajirone bajiaja ʉye oco quẽne. Mame ʉye ocore, vaibʉcʉgaserone quẽnoriajoa bʉcʉjoajʉare jiomenaja mani. Bʉcʉjoajʉre mani jiojama, jãmʉsĩnituca yiro, yivocõaroja tijoajʉare. To bajiro mani yijama, ʉye ocore, vaibʉcʉgaserone quẽnoriajoare quẽne, to bajirone yireacõa tʉjana yirãja mani. “To bajirobe” yirãma, mame ʉye ocore vaibʉcʉgaserone quẽnoriajoa, mamajoajʉare jiore ñaroja. To yicõari, ʉye oco, vaibʉcʉgaserone quẽnoriajoa quẽne, cojoro cõro quẽnaro ñarʉaroja. To bajiri mame ʉye ocore, bʉcʉjoajʉre mani jiobetore bajiro mame oca yʉ gotimasiosere, mani ñicʉa oca rãca tʉoĩavʉobesa mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ʉsʉsãjariarʉ̃mʉ ti ejaro, trigo ĩna oteriavese cʉtore vasuju Jesús, ĩ buerimasa rãca. To bajivanane, trigo ricare tũnejuacõari, ĩna ãmorine ti gasere sĩguẽreacõari, bayujarã ĩ buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tire ĩna basere ĩacõari, fariseo masa ado bajiro Jesúre ĩre yiyujarã: —¡Ĩaña mʉ! Mʉ buerimasa, ʉsʉsãjariarʉ̃mʉ yire mere yama ĩna —Jesúre ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —¿David ñamasir'i ĩ babarã rãca ñiorijacõari, ĩnare ĩ ũmato bamasirere masibeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Paia ʉjʉ ñamasugʉ̃ Abiatar vãme cʉtigʉ ĩ ñarore David mesa, ñiorijarã ñari, “Mani rãca ñagʉ̃mi Dios” masa ĩna yirivijʉre sãjacõari, Diore ĩre rʉ̃cʉbʉorã pan gãjerã ĩna cũboarerene juacõari, ĩ babarã rãca bamasiñuju ĩ. To bajiri Moisés ñamasir'i ĩ gotimasirema, “Paia rĩne barʉarãma” ĩ yimasiboarerene bamasiñujarã ĩna. To bajiro ĩna yiboajaquẽne, ti vaja rojose ĩnare yibetimasiñumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“‘Ʉsʉsãjariarʉ̃mʉre ado bajiro yiya’ yʉ yisere cʉdirã ñato” yigʉ me, masare rujeoyumi Dios. Masare rujeocõari, “Ʉsʉsãjariarʉ̃mʉ ñarʉaroja”, yicũmasiñumi, “Quẽnaro ñato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yʉ, Dios ĩ roticõacacʉ, “Ʉsʉsãjariarʉ̃mʉre ado bajiro mʉa yijama, quẽnaja. To bajirojʉa mʉa yijama, quẽnabeaja”, yirotigʉ ñaja yʉ —ĩnare yicʉdiyuju Jesús, fariseo masare. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","To yi vacʉne, Dios ocare ĩna buerivijʉ sãjasuju Jesús. Ti vijʉ ñañuju sĩgʉ̃, cojojacatʉa ãmo ñujobecʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseo masa quẽne ñañujarã. “‘Jesús, rojose yimi’ ʉjarãre yigoti, yirorãsa” yirã, Jesúre ĩre ĩacodeyujarã ĩna. “Adirʉ̃mʉ ʉsʉsãjariarʉ̃mʉre ãni ãmo ñujobecʉre ĩ masise rãca ĩ ñujorotijama, ‘Dios, Moisére ĩ roticũmasirere cʉdibecʉ yimi’ yigotirʉarãja mani”, yitʉoĩañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","To bajiro ĩna yitʉoĩarone, ado bajiro yiyuju Jesús, ãmo ñujobecʉjʉare: —Vʉ̃mʉrʉ̃gʉ̃ña —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","To bajiro ĩre yigajanogʉ̃ne, fariseo masare ado bajiro ĩnare sẽniĩañuju: —¿Ʉsʉsãjariarʉ̃mʉre quẽne, no bojagʉ masʉre quẽnaro mani yijama, quẽnabetojari? ¿Disejʉare yiroti ñati? ¿Quẽnasejʉare, rojosejʉare yiroti ñati ti? ¿Rijaye cʉtirãre catiorejʉare yiroti ñatique? To yiterã, ¿ĩnare sĩacõaroti ñatique? —ĩnare yiyuju Jesús. To ĩ yiboajaquẽne, ĩre cʉdibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","To bajiri ĩre ĩna ajitesere ĩajũnisinigʉ̃ ñaboarine, ĩnare ĩasʉtiritigʉne, ãmo ñujobecʉjʉare ado bajiro ĩre yiyuju Jesús: —Mʉ ãmore ñujoya mʉ —ĩre yiyuju. To ĩ yirone, ĩ ãmore ĩ ñujorone, quẽnaejacoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","To ĩ yisere ajicõari, budicoasujarã fariseo masa. Budiacõari, “Ʉjʉ ñamasugʉ̃ ñarʉcʉmi Herodes” yirũgũriarã rãca ñagõrã vasujarã. “¿No bajiro yicõari, Jesúre sĩarotirãti mani?”, gãmerã yiñagõñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","To ĩ yiro bero, ĩ buerimasa rãca vacoasuju Jesús ʉtabʉcʉra Galilea vãme cʉtirajʉ vana. To ĩna vato, Galilea sitana jãjarã Jesúre sʉyasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Gaje macariana quẽne, jãjarã masa, ĩaĩañamani Jesús ĩ yiñasere ajicõari, ĩ tʉjʉ ejayujarã. Ĩna ñañujarã: Judea sitana, Jerusalén macana, Idumea sitana, Jordán vãme cʉtiya gajejacatʉana, Tiro macana, to yicõari, Sidón macana quẽne ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jãjarã rijaye cʉtirãre Jesús ĩ catiosere ajicõari, gãjerã bʉto ĩre moaĩarʉayujarã ĩna, “To bajiro mani yijama, caticoanaja” yirã. To bajiro ĩna yitʉoĩajare, “Rʉ̃gõbibecõarãma” yigʉ ñari, —Cũmua cʉo yuya mʉa —ĩ buerimasare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ĩna ʉsʉrijʉre vãtia sãñarã, Jesúre ĩacõari, ĩ rĩjorojʉa gʉsomuniari tuetucõari muquearãne, ado bajiro yiavasãñujarã ĩna: —Dios macʉne ñaja mʉ —Jesúre ĩre yiavasãñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","To bajiro ĩna yisere ajicõari, oca tutuase rãca ĩnare ñagõrotibesuju Jesús, vãtiare rotigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Cojorʉ̃mʉ burojʉ majacõari, ĩ buerimasare ĩ bojarãre jirẽoñuju Jesús. To bajiri ĩ tʉjʉ ĩna ejarone, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre beseyuju. To yicõari, ado bajiro ĩnare gotiyuju: —Yʉ rãcane ñacõarʉarãja mʉa. To bajicõari, yʉ ocare yʉre goticudibosarã ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Masa ʉsʉrijʉ sãñarãre vãtiare, “Budiya” mʉa yijama, budirʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ado bajiro vãme cʉtirã ñañujarã jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã ĩ beseriarã: Simón vãme cʉtiboar'i Pedro vãme cʉtigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","To yicõari Zebedeo rĩa ñacama Santiago ĩ bedi Juan. Ĩna jʉarãre Boanerges vãme yiyuju Jesús. Ti vãme, Bʉjo rĩa yire ũni ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Tadeo ñañujarã. Alfeo macʉ Santiago, to yicõari, Simón vãme cʉtigʉ, celote yere tʉoĩaboar'i ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tʉsagʉ Judas Iscariote vãme cʉtiyuju. Ĩ ñañuju Jesúre ĩsirocar'i. To bajiri jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñañujarã Jesús ĩ beseriarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bero, vijʉ Jesúrãca tudiejayujarã ĩ buerimasa. To ĩna bajiro, jãjarã masa rẽjañujarã. To bajiri, bare bamasibeticõañujarã ĩna, Jesús mesa. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","To bajiro ĩna bajiñase quetire ajicõari, “Mecʉrimasʉ ñacoacʉ yigʉmi”, Jesúre ĩre yiyujarã masa. To bajiro ĩre ĩna yisere ajicõari, ĩ yarã, ĩre jirã vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gãjerã Dios ĩ rotimasirere gotimasiorimasa Jerusalén maca vadiriarã ado bajiro Jesúre yiyujarã ĩna: —Ĩ ʉsʉjʉ vãtia ʉjʉ Beelzebú vãme cʉtigʉ sãñagʉ̃ ñaami. To bajiri Beelzebú ĩ masise rãca vãtiare bureaami —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","To bajiro ĩna yise ñajare, ĩnare jiyuju Jesús. To yicõari, ĩ tʉjʉ ĩna ejaro, gotimasiore queti ado bajiro ĩnare gotiyuju: —Vãtia ʉjʉ, masa ʉsʉrijʉ ĩ yarãre sãjarotigʉ ñaboarine, no yigʉ, “Ĩnare bureaya” yigʉ ñabecʉmi tia. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Cojo sitana rotirimasa ĩna gãmerã quẽajama, ĩna masune gãmerã sĩayayirã yirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","To bajirone bajiroja cojo vi ñarãre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tire bajirone bajiroja vãtiare quẽne. Vãtia ĩna gãmerã bureajama, “Masare rojose yitʉjato mani” yirã yiborãma. To bajiro ti bajijare, “Beelzebú vãme cʉtigʉ ĩ masise rãca masa ʉsʉrijʉ sãñarãre vãtiare bureaami” yʉre mʉa yiboase, riojo yirã me yaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","To bajiro ĩnare yigoticõari, quẽna gajeye gotimasiore queti ĩnare gotiyuju: —Sĩgʉ̃, gãji guamʉ ya vi sãjacõari, ĩre ĩ siabetijama, gajeyeũni ẽmamasibecʉmi. Ĩre siacõari, ĩ gajeyeũnire ẽmamasigʉ̃mi yuja. To bajirone bajiaja yʉre quẽne. Vãtia ʉjʉ ĩ rotiboasere ĩre yirotibeticõari, vãtiare yʉ burease sʉorine, vãti ĩ rotiajeboariarãre ĩre ẽmagʉ̃ yaja, “Yʉ yarã ñato” yigʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","To bajiro ĩnare yigoticõari, quẽna ado bajiro ĩnare yiyuju Jesús: —Riojo mʉare gotiaja yʉ. Masa jediro rojose ĩna yijama, jediro rojose ĩna ñagõjaquẽne, sʉtiriticõari, Diore ĩna sẽnijama, rojose ĩna yisere masiriorʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","To bajiboarine, Esp'iritu Santojʉare rʉ̃cʉbʉomena rojose ĩre ĩna yitud'ijama, tirema masiriobetirʉcʉmi. To bajiro ĩna yijama, to bajirone rojose ĩnare ñacõa ñarũgũrʉaroja —yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Esp'iritu Santo ĩ masise rãca ĩ yiboajaquẽne, “Ĩ ʉsʉjʉ vãti sãñagʉ̃ ñari, bajigʉmi” ĩre ĩna yise ñajare, to bajise ĩnare gotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Jesús, masare ĩ gotimasio ñarone, ĩ tʉ rujigãnirã ado bajiro ĩre yiyujarã ĩna: —Mʉ jaco, mʉ bederã rãca macajʉ́jʉ ejama, mʉ rãca ñagõrʉarã —Jesúre ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","To bajiro ĩna yiboajaquẽne, ado bajiro ĩnare cʉdiyuju Jesús: —¿Ñimo ñati yʉ jacoma? ¿Ñimarã ñati yʉ bederãma? —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","To yigʉne, ĩ tʉ rujigãnirãre ĩacõari, —Mʉa ñaja yʉ bederãma, yʉ jacore bajiro bajirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","No bojarã yʉ jacʉ õ vecagʉ ĩ rotirore bajiro yirã, ĩna ñarãma yʉ bederãre bajiro bajirãma, yʉ jacore bajiro bajirãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Quẽna ʉtabʉcʉra tʉ ejacõari, masare gotimasioñuju Jesús. Masa jãjarãbʉsa ĩna rẽjaquearo ĩacõari, cũmuajʉ vasãjacõari, rujiyuju Jesús. Masajʉama, ʉtabʉcʉra tʉ ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","To bajicõari, cojo queti me tʉoĩacõari, “Ado bajiro bajisere bajiro bajiaja” ĩnare yigotigʉ ñari, ado bajise gotiyuju: ");
INSERT INTO bsnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Adi queti mʉare yʉ gotisere quẽnaro ajiya mʉa. Sĩgʉ̃ oterimasʉ vesejʉ ote ajere otegʉ vacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Vese ejacõari, ote ajere ĩ reabaterone, gajeye maajʉ vẽjaquearoja. To bajiri minia ejacõari, tire bareacõarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Gajeyema, gʉ̃ta joejʉ reajeoroja. Tijʉ, mojoroaca sita ti ñajare, guaro ti judidaboajaquẽne, muiju, asisĩocõagʉ̃mi. To bajicõari, oco manijare, sĩnireacoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gajeyema, jotayucʉ́ vatoajʉ vẽjaquearoja. To bajicõari, ti judiboajaquẽne, jotajʉa bʉcʉaveocoatoja ti. To bajiri rica cʉtibetoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gajeyema, sita quẽnarojʉ vẽjaquearoja. To baji, judibʉcʉacõari, quẽnase ñacõari, jairo rica cʉtiroja. Cojotõ, treinta ñaricari rica cʉtiroja. Gajetõ, sesenta ñaricari, gajetõ, cien ñaricari rica cʉtiroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tire mʉa ajimasirʉajama, quẽnaro tʉoĩaña mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tijʉ bero, Jesús sĩgʉ̃ne ĩ ñaro, ĩ buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã, gãjerã ĩre ajisʉyarã rãca ĩ tʉ rẽjacõari, ado bajiro ĩre sẽniĩañujarã: —¿Gotimasiore queti yʉare mʉ gotise, no yire ũni ñati ti? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","To bajiro ĩna yisẽniĩajare, ado bajiro ĩnare cʉdiyuju ĩ: —“Ʉjʉ Dios yarã quẽnaro ĩ yirona, yʉa ñarʉajama, ado bajiro yiroti ñaja” ĩna yimasibeticatire Dios sʉorine ajimasiaja mʉama. To bajiboarine gãjerãjʉama, Dios ĩ bojabetijare, tire ajimasibeama. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","To bajiri, gotimasiore queti rãca gotimasioaja yʉ, ado bajiro bajirã ĩna ñajare: Adi macarʉcʉroaye rĩrene tʉoĩarã ñari, yʉ yiĩosere ĩacõari, to yicõari, yʉ gotisere ajicõari, “To bajiro manire yigotigʉ yami”, manire yimasibeama. To bajiro bajirã ñari, rojose ĩna yisere tʉoĩavasoacõari, “Yʉare masirioya”, Diore yisẽnibeama. To bajiri yirẽto ecobosabetirʉarãma ĩna —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bero, quẽna ado bajiro ĩnare gotiyuju Jesús: —Oterimasʉ ĩ bajire quetire mʉare yʉ gotisere mʉa ajimasibetijama, gajeye yʉ gotirotire quẽne ajimasimenaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","To yigʉne, ado bajiro ti quetire ĩnare gotirẽtobuyuju Jesús: —Oterimasʉma, yʉ gotimasisere gotimasiocudirimasʉre bajiro bajigʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ote aje, maajʉ vẽjaquearere, minia ĩna barere yʉ yijama, “Ʉjʉ Dios quẽnaro ĩ yirona ĩna ñarʉajama, ado bajiro yiroti ñaja” yʉ yigotimasiosere ĩna ajiboasere, vãtia ʉjʉ ejacõari guaro ĩ masiriosere yigʉ yibʉ yʉ —yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","—Gʉ̃ta joejʉ vẽjaqueacõari, guaro judibʉcʉaboarere, muiju ĩ asisĩorere yʉ yijama, yʉ yere ajicõari, quẽnaro variquẽnase rãca ajirã ñaboarine, yoaro mene tire ĩna quejerotire, to yicõari, yʉ gotisere ajirã ĩna ñajare, gãjerã rojose ĩnare ĩna yijama, yoaro mene yʉ ocare ĩna ajitʉjarotire yigʉ yibʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Jotayucʉ́ vatoajʉ vẽjaqueacõari, judiboarere jotajʉa ti bʉcʉaveorere yʉ yijama, yʉ gotisere ajirã ñaboarine, adi macarʉcʉro ti bajisejʉare tʉoĩarejairã ñari, to yicõari, gajeyeũni bojatʉoĩarã ñari, yʉ yejʉare ĩna tʉoĩatʉjacõari, yʉ bojarore bajiro yimenare yigʉ yibʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sita quẽnarojʉ vẽjaqueare judibʉcʉacõari, quẽnase rica cʉtirere cojotõ treinta ñaricari, gajetõ sesenta ñaricari, gajetõ cien ñaricari rica cʉtirere yʉ yijama, yʉ gotmasiosere ajimasicõari, Dios ĩ bojarore bajiro quẽnaro yirã yʉ ocare ĩna gotimasiose sʉori, gãjerã masa quẽne yʉre ĩna ajitirʉ̃nʉrotire yigʉ yibʉ —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Quẽna gaje queti ado bajiro ĩnare gotiyuju Jesús: —Sĩabusuoriare jẽocõari, sotʉne tiare mubʉamenaja mani. Tiare jẽocõari, “Ñajediro ti vianare ʉ̃jʉbusuato” yirã, vecajʉ jeorãja mani. Tire bajiro bajiaja yʉ gotimasiose. “Ajimasibeticõato masa” yigʉ me, to bajise ĩnare gotiaja yʉ. “Quẽnaro riojo ajimasiato masa” yigʉ, gotirũgũaja. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dios sʉorine masa ĩna ajimasibeticati jediro, quẽnaro ajimasirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tire, mʉare yʉ gotisere mʉa ajimasirʉajama, quẽnaro tʉoĩaña mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","To yicõari, quẽna ado bajiro ĩnare gotiyuju Jesús: —Mʉare yʉ gotisere quẽnaro ajitirʉ̃nʉña mʉa. Mʉa ajitirʉ̃nʉrũtuatore bajirone “Bʉtobʉsa ajimasiato” yigʉ, mʉare ejarẽmorʉcʉmi Dios. Rẽtobʉsaro mʉare ĩ ejarẽmose ñajare, variquẽnarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","To bajiri, no bojagʉ Diore ajitirʉ̃nʉgʉ̃re, “Quẽnarobʉsa ajimasiato” yigʉ, ĩ masisere cõarʉcʉmi Dios. Gãjirema, ĩre ajigʉ ñaboarine, ĩre ĩ ajitirʉ̃nʉbetijare, Dios ĩ rotise sʉorine ĩ ajimasiboasere masiriticõarʉcʉmi ĩ. To bajiri Diore masibetimasucõarʉcʉmi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Quẽna ado bajiro masare gotimasioñuju Jesús: —No bojarã, Ʉjʉ Dios yarã quẽnaro ĩ yirãma, yʉ gotimasiosere ajitirʉ̃nʉñarã rĩne, ĩ sʉorine bʉtobʉsa ĩre bajiro quẽnaro yirã ñarũtuarʉarãma. To bajiro ĩna bajijama, ote aje ti judibʉcʉatore bajiro bajiama. Oterimasʉ otegʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Otecõari, tocãrãca ñamiri, ʉ̃mʉari quẽne, ĩ cãnijaquẽne, ĩ cãnibetijaquẽne, no yibetoja ĩ otere. Ĩ codetirʉ̃nʉcõa ñabetiboajaquẽne, ti masurione judicõari, bʉcʉatoja. Ti bʉcʉamʉjasere, “Ado bajiro bʉcʉatʉsajʉ ti” yimasibetiboajaquẽne, bʉcʉamʉjacoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ĩ otere ti masurione judiroja ti. Rĩjoro rujasaviaca judisʉoroja. Bero, bʉcʉamʉjacõari jũ cʉtiroja. To bajicõari rica cʉtiroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti bʉcʉaro ĩacõari, juagʉmi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Quẽna ado bajiro gotiyuju Jesús: —“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃, yʉ gotimasiosere no bojarã ĩna ajitirʉ̃nʉjama, mʉare yʉ gotisere mojoroaca ajimasiboarine, rojose ĩna ñare cʉtisere tʉoĩavasoacõari, tocãrãcarʉ̃mʉri quẽnaro ñamʉjarʉ̃gʉ̃cõari, quẽnaro ajimasimʉjarʉ̃gʉ̃jama, ado bajiro bajirʉaroja: ");
INSERT INTO bsnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sĩgʉ̃ ĩ ya vesejʉre mostaza ajea otegʉmi. Gajeye ote aje rẽtoro rʉjaricaca ñaroja ti, mostaza ajeaca. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","To bajiri ĩ oterica mojoricaca ñaboarine, ti judibʉcʉacoajama, ote yucʉ́ri rẽtobʉsaricʉ jairicʉ ñaroja tiʉ. Jairicʉ ti ñajare, tiʉ rʉjʉrijʉ minia ĩna ria cʉtirotijʉrire quẽnorãma ĩna —yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Gotimasiore queti rãca rĩne ĩnare gotimasiorũgũñuju Jesús, “Ĩna ajimasiro cõro ajimasiato” yigʉ. To bajiro yicõari, ĩ buerimasa rĩne ĩna ñaro, quẽnaro ĩnare gotirẽtobujeocõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tirʉ̃mʉ muiju ĩ rocasãro, ĩ buerimasare ado bajiro ĩnare yiyuju Jesús: —Gajejacatʉajʉ jẽajaro mani —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","To bajiri jãjarã masa Jesúre ajirã ejarãre, ĩ sãñaricũmuajʉne ĩ buerimasa rãca ĩnare jẽaveocoasujarã. To bajiri, gaje cũmuariana quẽne, ĩnare jẽasʉyasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","To ĩna jẽatone, bʉto mino vasuju. To bajicõari, bʉto sabeyuju. Ti saberone, cũmua sagueca yiro, rujacoarʉayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","To ti bajiboajaquẽne, rʉjoa tutuoriajʉ rãca ĩ rʉjoare tutuocõari, cãnisãñañuju Jesús, cũmua gʉdejʉ. Ĩ cãniro ĩacõari, ĩre yujioyujarã ĩna: —Yʉa ʉjʉ, ¡rujareana yaja mani! ¿“To bajiro ti bajijama, quẽnacõaroja”, yati mʉ? —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","40","To bajiro ĩna yirone, —¿No yirã bʉto güiati mʉa? “Rojose mani tãmʉoboajaquẽne, manire yirẽtobosarʉcʉmi”, yʉre yitʉoĩabeaja mʉa —ĩnare yiyuju Jesús. To yigajanocõari, ado bajiro yiyuju Jesús: —¡Mino tʉjaya! ¡Sabese quẽne tʉjaya mʉa! —yiyuju Jesús. To ĩ yirone, tʉjacoasuju mino. Sabese quẽne, sabebesuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","To bajiro ĩ yiboajaquẽne, bʉto güicõa ñañujarã ĩna. To bajiri, ado bajiro gãmerã sẽniĩañujarã: —¿Ñimʉ ũgʉ̃ masʉ ñati ãni? Minore, to yicõari, sabesere ĩ tʉjarotijama, ĩre ajiaja —gãmerã yiyujarã Jesús buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ʉtabʉcʉra gajejacatʉajʉ Gerasa vãme cʉti maca tʉjʉ ejayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","5","To ĩna ejarone, masa rijariarãre ĩna yujereariavijʉre sĩgʉ̃ ʉ̃mʉ budiayuju, Jesúre ĩagʉagʉ. Ti vijʉ ñañuju ĩ ñaro. Vãti sãñagʉ̃ ñañuju. To bajiri no yimasiñamagʉ̃ ñañuju. Cojoji me cõmemane ĩ gʉbori sotorire, ĩ ãmorire quẽne siaboayujarã. To ĩna yiboajaquẽne, tʉ̃asure reacõarũgũñuju ĩ. To bajiro bajigʉ ñari, ʉ̃mʉa, ñamirire quẽne gʉ̃tayucʉ joejʉ vacudirũgũñuju. To bajicõari, masa yujereariavijʉre ñacõari, avasãmecʉcudirũgũñuju. To bajiro bajicudica yigʉ, gʉ̃tarijʉ quediroca vacudirũgũñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","To bajiro bajiñar'i, sõjʉne Jesúre ĩabʉjacõari, ũmarojayuju. Jesús tʉjʉ ejacõari, ĩ rĩjorojʉa gʉsomuniari tuetuyuju, ĩre rʉ̃cʉbʉogʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","To bajiro ĩ yiejasere ĩacõari, ado bajiro ĩ ʉsʉjʉre sãñagʉ̃jʉare vãtire yiyuju Jesús: —Ãni masʉ ĩ ʉsʉjʉ sãñagʉ̃ budiya mʉ —ĩre yiyuju Jesús. To ĩ yijare, —Jesús, masirẽtogʉ̃, Dios macʉ ñaja mʉ. ¿No yigʉ yʉa tʉ vadiati mʉ? “Yʉre gõjanabiobesa”, mʉre yisẽniaja yʉ. Dios ĩ ĩaro rĩjorojʉa, “Rojose mʉ yise vaja, rojose mʉre yibeaja yʉ”, yʉre yiya —Jesúre yisẽniñuju vãti. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","To ĩ yirone, ado bajiro ĩre yiyuju Jesús: —¿Ñimʉ vãme cʉtiati mʉ? —ĩre yiyuju. To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju vãti: —Legión vãme cʉtiaja, jãjarã ñarã ñari —ĩre yicʉdiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","To bajiri ado bajiro Jesúre sẽniĩañujarã: —Gaje sitajʉ ĩnare cõabesa mʉ —Jesúre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Burojʉ jãjarã ecariarã yesea macabañañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ĩnare ĩacõari, ado bajiro Jesúre yisẽniñujarã ĩna: —Yʉare mʉ bureajama, õa yeseajʉare yʉare sãjarotiya —ĩre yisẽniñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","To bajiro ĩna yijare, —Mʉare varotiaja yʉ —vãtiare ĩnare yiyuju Jesús. To ĩ yirone, masʉ ʉsʉjʉre sãñaboariarã budicoasujarã yuja, ecariarã yesea, dos mil cõro ñarãjʉare sãjaroana. Ĩna sãjarone, buro ũmaroja vacõari, ʉtabʉcʉrajʉ rearoderujacõa tʉjasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yeseare coderimasa, to bajiro ĩna bajisere ĩacõari, ũmacoasujarã, ĩna ya macajʉ vana. Tojʉ ejacõari, ti macanare, to yicõari, ti maca tʉ ñarimacarianare quẽne tire gotibatoyujarã. To bajiro ĩna yigotisere ajicõari, Jesúre ĩarã vasujarã ĩna, ti macana jediro. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ĩ tʉjʉ ejacõari, vãtia sãñaboar'ire ĩañujarã ĩna. Sudi sãñacõari, Jesús tʉ rujiyuju. Ĩna bajirore bajiro bajigʉ ñañuju ĩ yuja. Vãtia ĩna sãñajama, tʉoĩamasibecʉ ñañuju maji. Quẽnaro tʉoĩagʉ̃ ñañuju yuja. To bajiro ĩ yimasisere ĩacõari, Jesúre bʉto güiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vãtia sãñaboar'i ĩ bajisere, to yicõari, yesea ĩna bajirere ĩariarã, gãjerãre gotiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","To bajiri Jesúre bʉto güirã ñari, —Vacoasa. Ado mʉ ñasere bojabeaja —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","To ĩna yijare, tudiacʉ, cũmuajʉ vasãjañuju Jesús. To ĩ bajirone, ado bajiro ĩre yiboayuju vãtia sãñaboar'i: —Mʉ rãca bʉto varʉaja yʉ quẽne —ĩre yiboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","To bajiro ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyuju Jesús: —“Yʉ rãca vadibesa. Mʉ ya vijʉ tudiasa. Dios yʉre ĩ ĩamaijare, ĩ masise rãca yʉ ʉsʉjʉ sãñarãre vãtiare bureami Jesús”, mʉ yarãre ĩnare yigotiba —ĩre yicʉdiyuju Jesús, vãtia sãñaboar'ire. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","To bajiro ĩ yijare, ĩ yarã tʉjʉ tudicoasuju ĩ. Tudiejacõari, Decápolis vãme cʉti sita ñarimacarianare, Jesús ĩ yirere goticudiyuju. To bajiro ĩ yigotisere ajicõari, no yimasibesujarã ĩna masa, ti ũnire ajibetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús, tudijẽacoasuju quẽna, gajejacatʉajʉ. Ʉtabʉcʉra tʉjʉ ĩ ñaro jãjarã masa rẽjañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","To bajirone, Dios ocare ĩna buerivi ʉjʉ quẽne ejayuju, Jairo vãme cʉtigʉ. Jesúre ĩacõari, ĩ rĩjorojʉa gʉsomuniari tuetuyuju, ĩre rʉ̃cʉbʉogʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","To yicõari, ado bajiro Jesúre ĩre yiyuju: —Yʉ maco bajirocaco yimo. So tʉ ejacõari, sore mʉ moaĩajama, caticoarʉocomo —Jesúre ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","To bajiro Jairo ĩ yisere ajicõari, ĩre sʉyasuju Jesús. Jãjarã masa ĩre sʉyacõari, no bajiro yi vamasiña manojʉ vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","To bajiro ĩna bajiro vatoajʉre sĩgõ, gãmorõmi cʉtigo ñañuju so. Jʉaãmo cõro, gʉbo jʉa jẽnituari cʉ̃mari gãmogõre bajiro bajicõarʉ̃mʉri cʉtirũgũñuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jãjarã ʉco yirimasa sore ĩna ʉco yire vaja, vaja yigo, gãjoa so cʉoboarere ĩnare ĩsijeocõañuju. To bajiro ĩnare so yiboajaquẽne, bʉtobʉsa bajiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","To bajiri gãjerãre Jesús ĩ catiore queti ajirio ñari, jãjarã masa vatoajʉ Jesúre sʉyasuju so. “Jesús sudiro moaĩarʉaja yʉ. Ti rĩne bojaja yʉ. To bajiro yʉ yijama, quẽnaejacoarʉocoja yʉ”, yiyuju so. To bajiro yirio ñari, Jesús sʉyarojʉa ejarʉ̃gʉ̃cõari, ĩ sudirore moaĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","So moaĩarirĩmarone, gãmogõre bajiro so bajiñaboare tʉjasuju. To bajiri, “Quẽnaejacoajʉ yʉ”, yimasiñuju so yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","So moaĩarone, “Yʉ masise sʉorine quẽnaejacoajamo”, yimasicõañuju Jesús. To bajiri jʉdarʉ̃gʉ̃cõari, ado bajiro masare sẽniĩañuju ĩ: —¿Ñimʉ yʉ sudirore moaĩari? —ĩnare yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","To ĩ yirone, ĩ buerimasa ado bajiro yiyujarã ĩna: —¿No yigʉ, “Ñimʉ yʉre moaĩati”, yati mʉ? Mʉ tʉjʉ jãjarã ñaja yʉa, mʉre moaĩarã —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","To ĩna yiboajaquẽne, ĩre moaĩagʉ̃re ĩamacañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","“Ĩre moaĩagõne, quẽnaejacoajʉ yʉ” yimasigõ ñari, nanagõne, Jesús rĩjorojʉa ejacõari, gʉsomuniari tuetuyuju so. To yicõari, ñajediro so bajirere Jesúre gotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","To so yirone, ado bajiro sore cʉdiyuju Jesús: —Yʉ maigõ, “Ĩ sudi gajare yʉ moaĩajama, ĩ masise sʉorine quẽnaejacoarʉocoja yʉ” yitʉoĩagõ ñari, quẽnaejacoajʉ mʉ. To bajiri, “Quẽnaejacoajʉ”, yitʉoĩa variquẽna vasa mʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","To bajiro sore ĩ yiñarone, Dios ocare ĩna buerivi ʉjʉ Jairo vãme cʉtigʉ ya viana ejayujarã. Ejacõari, ado bajiro Jairore gotiyujarã: —Mʉ maco bajirocacoamo. No yirã gotimasiorimasʉ ĩ vasere bojamenaja mani yuja —Jairore yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","To ĩna yiboajaquẽne, —Tʉoĩasʉtiritibesa mʉ. Yʉ masisejʉare tʉoĩacõa ñaña —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","To yicõari, gãjerãre sʉyarotibesuju Jesús yuja. Pedro, Santiago, ĩ bedi Juan, ĩna idiarãrene sʉyarotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","To yi, vanane, Jairo ya vijʉ ejayujarã. Tojʉ ejana, ĩna ĩajama, ĩ maco so bajirocacoajare, bʉto otiñañujarã ĩna, ti vi ejariarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ĩna otiñarivijʉre sãjaejacõari, ado bajiro ĩnare yiyuju: —¿No yirã otiati mʉa? “Bajirocacoajamo” mʉa yiboago, bajirocabecomo. Cãnigõ yigomo —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","To ĩ yisere ajicõari, ĩre ajayujarã ĩna, “Bajirocacoasumo” yimasirã ñari. To bajiro ĩna yiboajaquẽne, ĩnare budirotiyuju Jesús. Ĩnare budiroticõari, bajirocario jacʉare, to yicõari, ĩre sʉyarãre quẽne, ũmato jãjasuju Jesús, bajirocario so ñarisõajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ĩnare ũmato jãjacõari, so ãmore ñiañuju Jesús. To yigʉne, ado bajiro sore yiyuju: —Talita cumi —sore yiyuju. (“‘Daquego, vʉ̃mʉrʉ̃gʉ̃ña’ mʉre yaja yʉ” yire ũni ñañuju.) ");
INSERT INTO bsnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","To ĩ yirirĩmarone, quẽna tudicaticõari, vʉ̃mʉrʉ̃gʉ̃ vasuju so yuja. Jʉaãmo cõro, gʉbo jʉa jẽnituari cʉ̃mari tʉsaco ñañuju so. So tudicatisere ĩacõari, no yimasibesujarã masa, ti ũnire ĩabetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sore catiocõari, —Sore ĩ catiosere gãjerãre gotibetimasucõama —ĩnare yiyuju Jesús. To yicõari, —Bare sore ecaya mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","To bajiri Capernaum macanare ĩnare gotimasio gajanocõari, ĩ buerimasare ũmato vacoasuju Jesús, ĩ ya macajʉ, Nazaret vãme cʉti macajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tojʉ ʉsʉsãjariarʉ̃mʉ ñarone Dios ocare ĩna buerivijʉre sãjaejacõari, masare gotimasio ñañuju Jesús. Quẽnaro ĩ gotimasiosere ajicõari, no yimasibesujarã ĩna: —¿No bajicõari, to bajise gotimasiomasiati ĩ? ¿No bajiro yicõari, ĩaĩañamanire yati? —Jesúre yiyujarã ĩna, ĩ ya macana. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gajeye ado bajiro yiyujarã ĩna: —¿Adi macagʉ yucʉ́ moarimasʉ me ñatique ĩma? ¿Mar'ia macʉ me ñatique? ¿Santiago, José, Judas, Simón mesa gagʉ me ñatique ĩ? To yicõari, mani vatoajʉ ñarã, ¿ĩ bederã rõmiri me ñatique ĩna? —Jesúre ĩre yiyujarã ĩna, ĩ ya macana. To bajiri, “Ñamasugʉ̃ me ñaami. Mani ya macagʉ, mani masigʉ̃ ñaami” yirã ñari, ĩre ajitirʉ̃nʉbesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","To ĩna yirone, ado bajiro ĩnare gotiyuju Jesús: —Diore gotirẽtobosarimasʉ gajerojʉ Dios ocare ĩ gotimasiocudijama, ĩre ajirʉ̃cʉbʉorãma. To bajiboarine, ĩ ya macanare, ĩ ya vianare quẽne, Dios ocare ĩ gotimasiojama, ĩre ajirʉ̃cʉbʉomenama —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","To bajiri ĩ ya macana, ĩre ĩna ajitirʉ̃nʉbetijare, ĩaĩañamani yiĩomasibesuju ĩ. Mojoroaca ñañujarã ĩ ãmo ñujeocõari ĩ catioriarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ĩ yarã ĩre ĩna ajitirʉ̃nʉbetire ĩacõari, no yimasibesuju Jesús, ĩnare bajiro tʉoĩarãre ĩabetirũgũr'i ñari. To bajiri, gaje macarijʉ vasuju, masare gotimasiocudigʉ vacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre ĩ buerãre jirẽoñuju Jesús. Ĩnare jirẽocõari, tocãrãca macarire jʉarãri cõañuju. Ĩnare cõagʉ̃ne, masa ʉsʉrijʉ sãñarãre vãtiare, ĩna bureamasirotire ĩnare ʉjoyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","To yicõari ado bajiro ĩnare yiyuju: —Mʉa bare sãriajoari, gãjoare quẽne juaábesa. No bojase mʉa cʉose juaábesa. Tueriayucʉ́ri rĩne juaása. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gʉbo sudi mʉa sãñasene sãñacõari, sudi mʉa sãñasene sãñacõari, vasa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gajeye ado bajiro ĩnare yiyuju Jesús: —Tocãrãca macare mʉa ejajama, mʉa ejasʉorivine cãnima. Ti vine ñacõari, ti macanare ĩnare gotimasio ñama maji, gajerojʉ mʉa varoto rĩjoro. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mʉa ejarimacana quẽnaro mʉare ĩna bocaãmibetijama, to yicõari, mʉa gotisere ĩna ajirʉabetijaquẽne, ti macajʉre ñabeja. Mʉare ĩna ajirʉabetijare, mʉa gʉbo sudi tuyasere sitare varerea, vacoaja. To bajiro mʉa yijama, “Quẽnaro yʉare bocaãmibeticõari, yʉare mʉa ajirʉabetijare, rojose mʉare yirʉcʉmi Dios” yirã, yirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","To bajiro ĩ yijare, “Rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya” ĩnare yigotimasiocudirã vasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Masa ʉsʉrijʉ sãñarãre vãtiare bureayujarã ĩna. Jãjarã rijaye cʉtirãre quẽne, ʉye yuejeoyujarã ĩna. To ĩna yijare, quẽnaejacoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesús ĩ bajiñasere, ajijedicõañujarã Galilea vãme cʉti sitana. To yicõari, ĩna ʉjʉ Herodes quẽne ajiyuju, ado bajiro ĩna yisere: —Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉne sĩaecoboarine, tudicaticoarimi. To bajiri ĩaĩañamani yiĩoñagʉ̃mi —yiyujarã ĩna, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gãjerãma, ado bajiro yiyujarã: —Diore gotirẽtobosarimasʉ El'ias ñamasir'i ñagʉ̃mi quẽna —yiyujarã. Gãjerãjʉama, ado bajiro yiyujarã: —Diore gotirẽtobosarimasʉ ñamasir'ire bajiro bajigʉ ñaami —yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes quẽne, ado bajiro yiyuju: —Juan ñagʉ̃mi quẽna. Ĩ rʉjoare ĩre jatarocaroticõacajʉ yʉ. To bajiro yʉ yirotiboajaquẽne, quẽna tudicaticoarimi —yiyuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Juan ĩ sĩaecoroto rĩjoro ado bajiro bajire ti ñajare, to bajiro tʉoĩañuju Herodes: Ĩ bedi Felipe manajore Herod'ias vãme cʉtigore ẽmacõari, manajo cʉtiyuju Herodes. To bajiro ĩ yire ñajare, ado bajiro ĩre gotirũgũñuju Juan: —Herod'iare mʉ manajo cʉtise quẽnabeaja. Dios ĩ rotimasirere ajibeaja mʉ —ĩre yirũgũboayuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","To bajiro ĩ yigotisere ajitego ñari, ĩre sĩarotirʉaboayuju Herod'ias. To bajiro so yitʉoĩaboajaquẽne, “Dios ĩ bojarore bajiro quẽnaro yigʉ ñaami Juan” yigʉ, ĩ gotisere ajirʉ̃cʉbʉogʉ ñari, Herod'ias, Juanre so sĩarʉaboasere matayuju Herodes. Juan ĩre ĩ gotisere quẽnaro ajivariquẽnagʉ̃ ñaboarine, “To bajiro yirʉcʉja yʉ”, yimasibesuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","To bajiñarũgũboa, cojorʉ̃mʉ, “Ado bajiro yʉ yijama, yʉre matamasibecʉmi”, yitʉoĩañuju Herod'ias yuja. Tirʉ̃mʉ, Herodes ĩ ruyuariarʉ̃mʉ ñañuju ti. To bajiri ĩre moabosarimasa ʉjarãre, surara ʉjarãre, toana Galilea sitana ñamasuri masare quẽne jirẽoñuju ĩ, “Boserʉ̃mʉ yito” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","To yicõari, ĩna rẽjaro bero, Herod'ias maco, ĩna ĩaro rĩjorojʉare basaĩoñuju. So basasere ĩacõari, variquẽnañuju Herodes, ĩ jicõariarã quẽne. To bajiri, ado bajiro sore gotiyuju Herodes: —No bojase mʉ sẽnijama, mʉre ĩsirʉcʉja —sore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","To yicõari, ado bajiro sore gotirẽmoñuju: —Riojo mʉre gotiaja. Tʉoĩavasoabetirʉcʉja. Yʉ cʉose, “Gʉdareco bojaja” mʉ yisẽniboajaquẽne, mʉre ĩsicõarʉcʉja —Herod'ias macore yiyuju Herodes. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","To ĩ yisere ajicõari, so jacore sẽniĩagõ vasuju so, “¿Ñiere ĩre sẽnigõti yʉ?” yigo. To so yisere ajicõari, ado bajiro sore yi ocasãñuju so jaco: —“Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ rʉjoare bojaja”, ĩre yiya —so macore yicʉdiyuju Herod'ias. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To so yijare, guaro Herodes tʉjʉ vacõari, ado bajiro ĩre gotiyuju: —Yucʉacane Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ rʉjoare bare jeobariabaja joejʉ jeocõari, yʉre ĩsigʉ̃ vayá —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","To bajiro so yisere ajicõari, bʉto sʉtiritiyuju Herodes. To bajiboarine, ĩ jicõariarã ĩna ajiro rĩjorojʉa, “Riojo mʉre gotiaja yʉ. No bojase mʉ sẽnijama, mʉre ĩsirʉcʉja” ĩ yicõare ñajare, so sẽnirore bajirone yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","To bajiri Juanre sĩarʉabetiboarine, —Juan rʉjoare jatacõari, ãmiaya —yiroticõañuju, ĩ surarare. To ĩ yijare, tubiberiavijʉ vacõari, Juan rʉjoare jatayuju surara. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","To yicõari, bare jeobariabaja joejʉ jeocõari, Herod'ias macore ĩsiñuju. To yicõari, sojʉa, jacore ĩsirẽtoñuju so yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ti queti ajicõari, Herodes tʉjʉ ejayujarã, Juan buerimasa. Ejacõari, ĩ rujʉri ñaboarere ãmivacõari, yujeyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã ĩ buerimasa, ĩ goticudiroticõariarã, tudiejacõari, Jesúrãca rẽjañujarã. Ĩ rãca rẽjacõari, ĩna goticudirere, to yicõari, jediro ĩna yicudirere quẽne gotijeocõañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gãjerã ĩna vato ũnone, gãjerã ejavasoacõarũgũñujarã masa. To ĩna bajicõa ñajare, Jesús, ĩ buerimasa quẽne, ʉsʉsãja, bare ba, yimasibesujarã. To bajiri, ado bajiro ĩ buerimasare yiyuju: —Ita. Õjʉ, masa ĩna manibʉsarojʉ vajaro mani. Tojʉ ʉsʉsãjarʉarãja —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","To ĩ yijare, cũmua vasãja vacoasujarã ĩna, masa ĩna manibʉsarojʉ vana. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","To bajiro ĩna yi vaboajaquẽne, ti macariana jãjarã masa, Jesús ĩ buerimasa rãca ĩ vasere ĩamasicõari, ũmacoasujarã ĩna, Jesús ĩ ejarotijʉre vana. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","To bajiri Jesújʉa, majaejacõari, jãjarã masa ejacõari ñarãre ĩnare ĩañuju. Ĩ ĩajama, ovejare coderimasʉ ĩnare ĩ codebetore bajiro bajiyujarã ĩna. To bajiri ĩnare ĩamaiñuju. Ĩnare ĩamaigʉ̃ ñari, cojo vãme me ĩnare gotimasioñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","To ĩ yirone, rãioroto rĩjoro, Jesús buerimasa, ĩ tʉ ejacõari, ado bajiro yiyujarã: —Jẽre rãioato yaja. Masa manojʉ ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","To bajiri ĩnare varotiya mʉ, “Masa cʉtojʉ bare vaja yibarã vajaro” yirã —ĩre yiboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","To ĩna yiboajaquẽne, ado bajiro ĩnare cʉdiyuju Jesús: —Mʉane ĩnare bare ecaya —ĩnare yiyuju ĩ. To ĩ yijare, ado bajiro ĩre cʉdiyujarã ĩna: —Doscientos gãjoatiiri rãca vaja yiroti ñaboaroja manire, pan ĩna baroti vaja yirã —Jesúre yicʉdiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","To ĩna yisere ajicõari, ado bajiro ĩnare sẽniĩañuju Jesús: —“¿Nocãrãca pan cʉoati mʉa?”, yisẽniĩacudiya maji —ĩnare yiyuju Jesús. To bajiri sẽniĩabʉjacõari, ĩre gotiyujarã: —Cojomo cõro pan, jʉarã vai cʉoaja yʉa —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","To ĩna yirone, —Masare tatũcurojʉ rujatubuari rujirotiya —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","To ĩ yise ñajare, rujatubuari rujibateyujarã ĩna. Cojojʉri cien ñarirãcʉ, to yicõari, cincuenta ñarirãcʉ rujibateyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","To bajiro ĩnare rujiroticõari bero, cojomo cõro ñaricari pan, to yicõari, jʉarã vai ñarãre juacõari, õ vecajʉa ĩamʉocõari, “Quẽnaro yaja mʉ”, Diore ĩre yiyuju. To yicõari bero, panre iguesurebatecõari, ĩ buerimasare ĩsiñuju, “Rujirãre ĩsibatoya” yigʉ. Jʉarã vaire quẽne iguesurebatecõari, ĩ buerimasare ĩsiñuju, “Rujirãre ĩsibatoya” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sĩgʉ̃ rʉyariaro mano quẽnaro baʉsʉcʉtijedicõañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ĩna bagajanoro bero, ĩna barʉasere, ĩ buerimasa ĩna juarẽojama, jʉaãmo cõro, gʉbo jʉa jẽnituaro ñarijibʉri rʉyayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tire bariarã, cinco mil ʉ̃mʉa ñañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Masa ĩna barʉasere ĩ buerimasa ĩna juarẽogajanorone, cũmuajʉ ĩnare vasãjarotiyuju Jesús: —Betsaida vãme cʉti macajʉ yʉre jẽadiyuya. Maji masare vare gotigʉ yaja yʉ —yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ĩnare vare gotigajano, burojʉ majacoasuju, tojʉ Diore sẽnirʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ti rãioato bero, ʉtabʉcʉra jẽana, tira gʉdareco tʉsasujarã, Jesús buerimasa. Jesújʉama, sĩgʉ̃ne ñacõañuju ĩ maji. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","To bajicõari, ĩ buerimasare ĩacõañuju. To ĩna tʉsatone, bʉto mino vasuju. To bajiri jẽatĩmabesujarã ĩna. To ĩna bajiñarone, busurocaroarijaʉ ĩna tʉjʉ oco joene vayuju Jesús. To bajivagʉ, ĩnare rẽtocoarocʉre bajiro vayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Oco joejʉ ĩ vadire ĩarãne, ʉcacoasujarã ĩna. “¡Bajirocar'i vãti ñaami!”, yiavasãñujarã. To ĩna yiboajaquẽne, —Güibesa. Variquẽnaña mʉa. Yʉne ñaja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","To yigʉne, ĩna vaticũmuajʉ vasãjacõañuju Jesús. Ĩ vasãjarone, mino vatʉjacoasuju yuja. To bajiro ti bajisere ĩacõari, no yimasibesujarã ĩ buerimasa, ti ũnire ĩabetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","To bajiro ĩna bajijama, cinco mil ʉ̃mʉare Jesús ĩ ecarere ĩariarã ñaboarine, “Ĩaĩañamanire yimasijeogʉ ñaami” ĩre yimasimena ñari, to bajiro bajiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","To baji, jẽanane, Genesaret vãme cʉti sitajʉ jẽaejayujarã ĩna. Tojʉ cũmuare siatujoyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cũmuare siagajano, ĩna majatone, Jesúre ĩamasicõañujarã ti macana, tijʉana. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","To bajiri masa jedirore gotibatorã ũmacoasujarã ĩna. Tire ajirã ñari, ti macariana rijaye cʉtirãre Jesús tʉjʉ juaejayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ĩ vacudiri macari cõrone mojorimacajʉ ĩ vajaquẽne, jairimacajʉre ĩ vajaquẽne, masa ĩna rẽjarũgũrijaʉrire ĩ vajaquẽne, to yicõari, Jesús ĩ varoti maarijʉre quẽne, rijaye cʉtirãre juaejocũñujarã. To yicõari, —Mʉ sudi gajare ĩnare moaĩarotire bojaja yʉa. To bajiro ĩna yijama, caticoarʉarãma —ĩre yiyujarã rijaye cʉtirãre juaejariarã. To bajiri, ĩre moaĩariarãma, caticoasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseo masa, to yicõari, Dios ĩ rotimasire gotimasiorimasa quẽne ejayujarã ĩna, Jesús tʉjʉ. Jerusalénjʉ vadiriarã ñañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesús tʉ ejacõari, ĩ buerimasa sĩgʉ̃ri, ĩna baroto rĩjoro, ĩna ñicʉa ĩna ãmorire ĩna coemasiriarore bajiro ĩna coebetire ĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Jud'io masa ñajediro, ĩna ñicʉa ye quẽnaro ajirʉ̃cʉbʉorã ñañujarã ĩna. To bajirã ñari, ĩna ñicʉa ĩna yimasiriarore bajiro ãmori coecõari rĩne, bayujarã ĩna. Masa, bare vaja yirã ĩna rẽjarojʉ vaja yirã variarã, tudiejacõari, ĩna ñicʉa ĩna ãmorire ĩna coemasiriarore bajiro yirã, ĩna ãmorire coecõasʉori rĩne, barũgũñujarã ĩna. To yicõari, idiriabajari, oco cũria sotʉri, no bojase sotʉri quẽne coeyujarã. Bare barã rujiriajʉrire quẽne to bajiro yiyujarã ĩna, jud'io masa. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tire bʉto ajirʉ̃cʉbʉorã ñari, fariseo masa, to yicõari, Dios ĩ rotimasire gotimasiorimasa quẽne, ado bajiro Jesúre sẽniĩañujarã ĩna: —¿No yirã mani ñicʉa ĩna yimasiriarore bajiro yibeati mʉ buerimasa? Ĩna baroto rĩjoro, mani ñicʉa ĩna ãmori coemasiriarore bajiro coebeama —ĩre yiyujarã ĩna, fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","To bajiro ĩna yijare, ado bajiro ĩnare cʉdiyuju Jesús: —“Quẽnaro yirã ñaja yʉa” yiboarine, rojorã ñaja mʉa. Diore gotirẽtobosarimasʉ, Isa'ias ñamasir'i, mʉa bajirotire quẽnaro tʉoĩacõari, ado bajiro ucamasiñuju: “Ĩna oca masune yirã, quẽnaro yʉre yirʉ̃cʉbʉoama ĩna. To bajiro yirã ñaboarine, yʉ bojarore bajiro tʉoĩabeama. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yʉ yere buecõari, ĩna masu ĩna tʉoĩasere gotimasioama. Tirene, ‘Dios ĩ rotise ñaja’ yiboama. To bajiri yʉre ĩna rʉ̃cʉbʉoboase vaja, ñie vaja bʉjamenama ĩna”, yiucamasiñuju Isa'ias, Diore gotirẽtobosagʉ —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","To yicõari, quẽna ado bajiro ĩnare yiyuju Jesús: —Dios ĩ rotisejʉare ajitirʉ̃nʉmenane, mani ñicʉa ocajʉare quẽnaro ajitirʉ̃nʉaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","To yicõari, quẽna ado bajiro ĩnare gotirẽmoñuju Jesús: —Mani ñicʉa yejʉare ajirʉ̃cʉbʉorã, Dios ĩ rotimasirejʉare cʉdibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dios ĩ roticũmasirere Moisés ĩ ucamasire ado bajiro gotiaja: “Mʉ jacʉre, mʉ jacore quẽnaro rʉ̃cʉbʉoya”. To yicõari, gaje vãme ado bajiro yaja: “No bojagʉ ĩ jacʉre, ĩ jacore, ‘Rojose tãmʉoʉcarʉarãja mʉa’ ĩnare ĩ yijama, ĩre sĩaroti ñaja”, yigotiaja Moisére Dios ĩ roticũmasire. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mʉajʉama, ado bajirojʉa rotiaja mʉa: “Ĩ ye rãca ĩ jacʉare ĩ ejarẽmobetijama, quẽnacõaja. ‘Yʉ gajeyeũni, yʉ cʉose Diore yʉ ĩsiroti rĩne ñaja. To bajiri mʉare ejarẽmomasibeaja yʉ’ yicõari, ĩ jacʉare ĩ ejarẽmobetijama, quẽnacõaja”, yirotiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","To yicõari, gajeye jairo ti ũnire bajiro mʉa yirotise ñaja. To bajiro yirotirã, “Dios manire ĩ roticũmasirere cʉdibeticõato” yirãre bajiro yaja mʉa. To yicõari, “Mani ñicʉa ĩna rotimasirejʉare ñamasuse ñaja” mʉa yitʉoĩajama, “Ñie vaja maja Dios ĩ rotimasire” yirã yaja mʉa —fariseo masare, to yicõari, Dios ĩ rotimasire gotimasiorimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","16","To bajiro ĩnare yigotigajanocõari, masare jirẽocõari, ado bajiro ĩnare gotiyuju Jesús: —Ñajediro quẽnaro ajiya, yʉ gotimasiosere. Tire ajicõari, “To bajiro manire yigotigʉ yami”, yiajimasiña mʉa: Mani ñicʉa, “Mani basãse sʉorine ñaja Dios ĩ ĩavariquẽnabeti, ĩre mani yirʉ̃cʉbʉose ĩ bojabeti”, yitʉoĩamasiboayuma. To bajiro me bajiaja. Rojose tʉoĩacõari, mʉa ñagõse sʉorine bajiaja, Dios ĩ ĩavariquẽnabeti, ĩre mʉa yirʉ̃cʉbʉosere ĩ bojabetima —masare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","To bajiro ĩnare yigotigajano, masa jãjarã vatoajʉ ñar'i, vacoasuju Jesús, ĩ buerimasa rãca. Vijʉ sãjaejacõari, ado bajiro ĩre sẽniĩañujarã ĩ buerimasa: —Jẽjʉ mʉ gotimasiosere quẽnaro yʉare gotirẽtobuya —Jesúre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","To ĩna yisere ajicõari, —¿Ajimasibeati mʉa quẽne? —yiyuju ĩ. —Mʉa basãse mʉa gʉdajoajʉ vatoja ti. Tijʉ bero, rẽtobudiroja ti. To bajiri, mʉa ʉsʉrijʉrema rojose yimasibeaja ti —ĩnare yiyuju Jesús. To bajiro ĩ yijama, “Ñajediro bare mani baboajaquẽne, Dios ĩ bojabetire yirã me yirãja mani” yigʉ yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","To yicõari, ado bajiro ĩnare gotirẽmoñuju Jesús: —Dios ĩ ĩajama, masa rojose ĩna tʉoĩasejʉa ñaja rojosema. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Masa, rojose ĩna tʉoĩajama, ado bajiro yirãma: Juarudirãma. Gãjerãre sĩarãma. Manajo cʉtirã, manajʉ cʉtirã quẽne, gãjerã rãca ajeriarã cʉtirãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Gajeyeũnire gãjerã yere ʉorãma. Socajairãma. Bojoneose ti ñaboajaquẽne, tire yicõarãma. Gãjerãre, “Yʉ rẽtobʉsaro quẽnaro ñaama”, yiĩajũnisinirãma. Gãjerã ajiro rĩjorojʉa socarãne, “Ado bajise rojose yima”, yigotirãma. “Ñamasurã ñaja yʉama”, yitʉoĩarãma. Riojo tʉoĩamasimenama. Dios yere rʉ̃cʉbʉomenama. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Adi rojose jediro yirãma masa, rojose ĩna tʉoĩajama —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","To ñar'i, vacoasuju Jesús. Vacõari, Tiro vãme cʉti maca tʉjʉ ejayuju. To ejacõari yayioro vijʉre sãjarʉaboayuju. To bajiboarine yayioro sãjamasibesuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","To bajiri Jesús ĩ ejare queti ajicõari, sĩgõ rõmio ĩ tʉjʉre vasuju so. Vãti sãñagõ jaco ñañuju so. Jud'io maso me ñañuju. Sirofenicia sitago ñañuju. Jesús rĩjorojʉa ejacõari, gʉsomuniari tuetucõari, ado bajiro bʉto ĩre sẽniñuju: —Yʉre ejarẽmoña mʉ. Yʉ maco so ʉsʉjʉ vãti sãñagõ ñaamo. Ĩre burocaya mʉ —Jesúre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","To so yisere ajicõari, ado bajiro sore cʉdiyuju Jesús: —Yʉ yarã jud'io masare ejarẽmosʉoaja. Yʉ yarãre yʉ ejarẽmoroto rĩjoro gãjerãre yʉ ejarẽmojama, rĩamasa ĩna basere ẽmacõari, yaiare ecagʉre bajiro yigʉja yʉ —sore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju so: —Yʉ ʉjʉ, riojo gotiaja mʉ. To bajiboarine ĩna ʉjarã ĩna bavẽjasere barãma yaia —Jesúre ĩre yiyuju so. “Jud'io masare ejarẽmogʉ̃ ñaboarine, yʉare quẽne mojoroaca ejarẽmomasigʉ̃ja” yigo, to bajise ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","To so yisere ajicõari, ado bajiro sore yiyuju Jesús: —Quẽnaro tʉoĩacõari, gotiaja mʉ. Mʉ maco ʉsʉjʉ sãñagʉ̃re vãtire ĩre burocacõaja yʉ. To bajiri mʉ ya vijʉ tudiasa —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","So ya vijʉ tudiejacõari, cãnijesariaro joejʉ so macore so jesaro ĩacõari, “Vãti so ʉsʉjʉre sãñar'i jẽre budicoasumi”, yimasiñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro maca tʉjʉ ñar'i, Sidón vãme cʉti macajʉ rẽtoasuju Jesús. To rẽto vacʉne Decápolis sita ñarimacarire quẽne rẽtoasuju. To rẽtoacʉne, Galilea Ʉtabʉcʉra tʉjʉ ejacoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","To ĩ ñarone, sĩgʉ̃ ajibeti, ñagõmasibeti bajigʉre ãmiejayujarã masa. Ĩre ãmiejacõari, Jesúre sẽniñujarã, “Ajibecʉre ĩ ãmori ñujeocõari ĩre catioato” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","To bajiri ajibecʉre gajerojʉa ũmato vasuju Jesús. Ĩre ũmato vacõari, ĩ gãmo gojerijʉre ĩ ãmovãsoa rãca tõmesõñuju Jesús. To yigajano, ĩ ãmovãsoare gooco eotucõari, ĩ ñemerore moaĩañuju, ĩ ñagõmasibetijare. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","To yicõari, õ vecajʉare ĩamʉocõari, ʉsʉ sĩnisãñuju Jesús. To yigʉne, ado bajiro ĩre yiyuju: —Efata —yiyuju Jesús. (“Ajiya yuja” yire ũni ñañuju ti.) ");
INSERT INTO bsnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","To ĩ yirone, ajibecʉ ñaboar'i ajicoasuju yuja. To bajicõari, quẽnaro ñagõcoasuju ĩ, ñagõmasibecʉ ñaboar'i. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","To bajiro ĩre yigajanocõari, ado bajiro masare yiyuju: —Gãjerãre gotibetimasucõama mʉa —ĩnare ĩ yiboajaquẽne, bʉtobʉsa gotibatorũgũñujarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","To bajiro Jesús ĩ yisere ajivariquẽnacõari, no yimasibesujarã ĩna, ti ũnire ajibetirũgũriarã ñari. To bajiri, ado bajiro Jesús ĩ yisere gotiyujarã: —Ñajediro quẽnaro yimasijeogʉ ñaami. Ajimenare, “Ajiato” ñagõmenare quẽne, “Ñagõato” yigʉ ñaami —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Quẽna Jesús tʉjʉ jãjarã masa rẽjacõari, ĩna ñaro rĩne bare jedicoasuju ĩnare. To bajiri ĩ buerimasare jicõari, ado bajiro yiyuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ado ñarãre ĩamaiaja yʉ. Idiarʉ̃mʉ tʉsajʉ yuja, yʉ rãca ĩna ñaro. To bajicõari bare maama. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bamenane ĩna ya virijʉ ĩna tudiasere bojabeaja yʉ. Sĩgʉ̃ri sõjʉ vadiriarã ñaama. Ĩnare yʉ tudirotijama, bamenane ĩna vajama, ñiorijarã ñari, rijavẽjacoaborãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","To bajiro ĩ yirone, ado bajiro ĩre yiyujarã ĩ buerimasa: —Ado, masa manojʉ ñaja. No bajiro masa ñaro cõro ĩna barotire bare bʉjamasiña manoja —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","To ĩna yirone, —¿No cõro jairo pan cʉoati mʉa? —ĩnare yiyuju. —Cojomo cõro jʉa jẽnituaro ñaricari ñaja —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","To ĩna yirone, rʉ̃cacane masare rujirotiyuju Jesús. To yicõari pan cojomo cõro jʉa jẽnituaro ñaricari ñasere juacõari, “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽnañuju Jesús. To yicõari tire iguesurebatecõari, ĩ buerimasare ĩsiñuju. To bajiri ĩnajʉa rujirãre ĩsibatoyujarã yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vai quẽne mojoroaca cʉoyujarã ĩna. To bajiri vaire juacõari, “Quẽnaro yaja mʉ”, Diore yiyuju Jesús quẽna. To yicõari, ĩ buerimasare ĩsibatorotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sĩgʉ̃ rʉyariaro mano baʉsʉcʉtijedicõañujarã. Ĩna bagajanoro bero, ĩna barʉasere juarẽoñujarã Jesús buerimasa. Ĩna juarẽojama, cojomo cõro jʉa jẽnituaro ñarijibʉri rʉyayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tire bariarã cuatro mil masa ñañujarã. Ĩnare ecagajanocõari, ĩnare tudirotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","To yicõari bero, ĩ buerimasa rãca cũmuajʉ vasãjacõari, Dalmanuta vãme cʉti sitajʉ vacoasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseo masa, Jesús tʉ ejacõari, ĩre sẽniĩañujarã, “Cʉdimasibeticõari, rojose tãmʉoato ĩ” yirã: —“‘Dios ĩ cõagʉ̃ ñaami’ yʉre yimasiato” yigʉ, õ vecaye ĩaĩañamani yʉare yiĩoña —ĩre yiboayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","To bajiro ĩna yisere ajicõari, ʉsʉ sĩnisãñuju Jesús. To yicõari, ado bajiro ĩnare yiyuju: —¿No yirã adirodoriana ĩaĩañamani rãca rĩne yʉ yisere bojati mʉa? Riojo mʉare gotiaja yʉ. Ĩaĩañamani mʉare yiĩobecʉja yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","To bajiro ĩnare yicõa, ĩnare jẽaveocoasuju Jesús, ĩ buerimasa rãca. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesúrãca jẽana, ĩna baroti pan masiritiyujarã. Ĩna vaticũmuajʉre pan cojane cʉoyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","To bajiro ĩna bajire ñajare, ado bajiro ĩnare gotiyuju Jesús: —Fariseo masa, to yicõari, Herodes quẽne “Pan vauvato” yirã, ĩna vʉosere quẽnaro ajicõĩaña mʉa —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To ĩ yisere ajimasimena ñari, ĩna masune ado bajiro gãmerã yiyujarã ĩna: —Pan mani masiritijare, to bajise gotigʉ yigʉmi —gãmerã yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","To bajiro ĩna gãmerã yisere masicõari, ado bajiro ĩnare gotiyuju ĩ: —¿No yirã “Pan maja manire”, yati mʉa? ¿Yʉre ajimasibeati mʉa maji? ¿Adi macarʉcʉroaye rĩne tʉoĩarãre bajiro tʉoĩacõa ñati mʉa maji? ");
INSERT INTO bsnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","¿Yʉ yiĩosere ĩarã ñaboarine, ajimasibeati mʉa maji? —ĩnare yiyuju Jesús. To yicõari, ado bajise ĩnare yirẽmoñuju: —Cojomo cõro ñaricarire panre bʉjʉocõari, cinco mil masa ñarãre ecacajʉ yʉ. Ĩnare yʉ ecaro bero, ¿nocãrãca jibʉri rʉyacati ti? —ĩnare yiyuju Jesús. To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyujarã ĩna: —Jʉaãmo cõro, gʉbo jʉa jẽnituaro ñarijibʉri rʉyacajʉ —ĩre yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Quẽna ĩnare tudisẽniĩañuju: —Tijʉ bero, quẽna cojomo cõro jʉa jẽnituaro ñaricari panre bʉjʉocõari, cuatro mil masa ñarãre ecacajʉ yʉ. Ĩnare yʉ ecaro bero, ¿nocãrãca jibʉri rʉyacati ti? —ĩnare yiyuju. —Cojomo cõro, jʉa jẽnituaro ñarijibʉri rʉyacajʉ —ĩre yicʉdiyujarã ĩ buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","To bajiro ĩna yicʉdisere ajicõari, ado bajiro ĩnare tudisẽniĩañuju Jesús: —To bajiro yʉ yiĩocatire masirã ñaboarine, ¿jẽjʉ mʉare yʉ gotisere ajimasibeati mʉa maji? “Fariseo masa, to yicõari, Herodes quẽne, ‘Pan vauvato’ yirã, ĩna vʉosere quẽnaro ajicõĩaña” yʉ yijama, bare mere yaja yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bero, Jesús, ĩ buerimasa rãca Betsaida vãme cʉti macajʉre ejayuju. To ĩna ejaro ĩacõari, caje ĩabecʉre ãmiejayujarã masa, “Caje ĩabecʉre Jesús ĩ moaĩarone, ĩacoarʉcʉmi” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","To bajiro ĩna yiejogʉre ti maca sojʉabʉsa ĩre tʉ̃a vasuju Jesús. To yicõari, ĩ cajearire goocone eotucõari, moaĩañuju Jesús, “Ĩato ĩ” yigʉ. To yicõari, ado bajiro ĩre sẽniĩañuju: —¿Ĩati mʉ? —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","To ĩ yirone, caje ĩabecʉ quẽnaca ĩasʉoyuju. To bajiri ado bajiro cʉdiyuju ĩ: —Masare ĩaja yʉ. To bajiro yʉ ĩaboajaquẽne, yucʉ́rine vasere bajiro bajiaja —yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","To ĩ yijare, quẽna ĩ cajearire tudimoaĩa quẽnoñuju. To ĩ yirone, quẽnaro ĩacoasuju. Ñajediro quẽnaro ĩre ruyuyuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","To bajiro ĩ bajiro ĩacõari, ado bajiro ĩre gotiyuju Jesús: —Macajʉre vacõari, mʉre yʉ ĩarotisere gãjerãre gotibatobecʉne, mʉ ya vijʉ tudiasa —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","To ĩ yiriaro bero, Cesarea de Filipo vãme cʉti sita ñarimacarijʉre ĩ buerimasare ũmato vasuju Jesús. To ĩnare ũmato vacʉne, ado bajiro ĩnare sẽniĩañuju: —¿Ñimʉ ñaami yʉre yati ĩna, masa? —ĩnare yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","29","To ĩ yisẽniĩajare, ado bajiro ĩre cʉdiyujarã ĩ buerimasa: —Sĩgʉ̃ri, “Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ, tudicaticõari bajigʉmi”, mʉre yama ĩna. Gãjerãma, “El'ias ñamasir'i ñagʉ̃mi”, yama. Gãjerãjʉama, “Gãji, Diore gotirẽtobosamasir'i ñagʉ̃mi”, mʉre yama —Jesúre yicʉdiyujarã. To ĩna yirone, —Mʉajʉama, ¿ñimʉ ñaami, yʉre yati mʉa? —ĩnare yiyuju Jesús. To ĩ yirone, ado bajiro ĩre cʉdiyuju Pedro: —Mʉ ñaja rojose yʉa tãmʉoborotire yʉare yirẽtobosacõari, rotimʉorʉ̃gõrocʉ, Dios ĩ cõar'i —Jesúre yiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","To bajiro Pedro ĩ yicʉdijare, gãjerãre gotirotibesuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","To yicõari, ĩ bajirotire ado bajiro ĩ buerimasare gotisʉoyuju Jesús: —Yʉ, Dios ĩ roticõacacʉ, bʉto rojose tãmʉorʉcʉja. Bʉcʉrã, paia ʉjarã, to yicõari, Dios ĩ rotimasire gotimasiorimasa quẽne, rojose yʉre yicõari, yʉre sĩarʉarãma ĩna. Yʉre ĩna sĩaboajaquẽne, idiarʉ̃mʉ tʉsatirʉ̃mʉne yʉre catiorʉcʉmi Dios —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ĩ sĩaecorotire riojo ĩnare ĩ gotise ñajare, ajimasicõañujarã. Tire ajimasicõari, ricati ĩre jicãmotocõari, —“Bajirʉaroja” yʉare mʉ yigotise bajibeticõato —ĩre yiboayuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To ĩ yisere aji, Jesújʉama, ĩ buerimasa ĩna ñarojʉare jʉdarʉ̃gʉ̃, ĩacõari, ado bajiro Pedrore ĩre yiyuju: —¡Satanás, vasa mʉ! Vãtia ʉjʉre ñagõbosagʉ yaja mʉ. To bajiro mʉ yijama, Dios ĩ tʉoĩarore bajiro me tʉoĩaja mʉ. Masa ĩna tʉoĩarore bajiro tʉoĩagʉ̃ yaja —ĩre yiyuju Jesús, Pedrore. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","To yicõari, ĩ buerimasare gãjerãre quẽne ĩnare jirẽocõari, ado bajiro yiyuju Jesús: —No bojagʉ yʉ yʉ ĩ ñarʉajama, ĩ bojasere, ĩ ye ñarotire tʉoĩabecʉne, “Jesúre bajiro rojose tãmʉorʉcʉja yʉ quẽne” yitʉoĩacõari, yʉjʉare ajisʉyarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","No bojarã, ĩna bojaro ñare cʉtirãma, adi macarʉcʉrore ñasere ĩavariquẽnacõari, Diore tʉoĩamenama, Dios ĩ catisere yayibetire cʉomena ñarʉarãma ĩna. To bajiboarine, yʉre ajitirʉ̃nʉrã, yʉ oca ĩna gotisere ajijũnisinicõari, ĩna sĩarãma, Dios tʉ quẽnaro ñarona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sĩgʉ̃ adi macarʉcʉrojʉ gajeyeũni jediro ĩ bʉjaboajaquẽne, berojʉ rojose tãmʉotʉjabetiriarojʉ ĩ vajama, ĩ gajeyeũni ĩ bʉjaboare, ñie vaja manoja. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ñiere Diore ĩsimasibecʉmi, ĩ rijato berojʉma “Tudirijabeticõato” yigʉ, “Dios ĩ catisere yʉre ĩsiato” yigʉ. Mani rijato berojʉma “Tudirijabeticõato” yigʉ, Dios ĩ catisere ĩ ĩsise cõro vaja cʉti manoja. ");
INSERT INTO bsnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Jesúre ajitirʉ̃nʉcõari, ĩ ocare ĩna gotimasiose sʉorine ĩnare rʉ̃cʉbʉobeama adirodoriana” yiĩagʉ̃ ñari, ĩna ĩaro rĩjorojʉa, “Jesúre rʉ̃cʉbʉogʉ ñaja yʉ”, yibojonebesa. To bajiro yibojonegʉ̃ ñari, yʉ yʉ ĩ ñarʉabetijama, “Yʉ yʉ me ñaami”, ĩre yiĩarʉcʉja yʉ quẽne, Dios ĩ roticõacacʉ ñacõari, “Quẽnarẽtogʉ̃ ñaja yʉ” yʉ jacʉ ĩ yiĩorore bajiro yigʉ ñari, ĩ bususe rãca yʉ vadirʉ̃mʉ. Yʉ rãca vadirʉarãma Dios ĩ cõarã, ángel mesa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","To yicõari, gajeye ĩnare gotirẽmoñuju Jesús: —Riojo mʉare gotiaja yʉ. Mʉa sĩgʉ̃ri mʉa bajireabetone, “Ñajediro ʉjʉ ñaami yʉ roticõacacʉ” Dios mʉare ĩ yiĩosere ĩarʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cojomo cõro, coja jẽnituarirʉ̃mʉ bero, Pedro, Santiago, to yicõari Juanre quẽne, ʉ̃mʉariburo joejʉ ĩnare ũmato vasuju Jesús. Tojʉ ĩnare ũmato ejacõari, ĩna ĩaro rĩjorojʉa ricati ruyugʉ godovedicoasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sudi ĩ sãñase bʉto boticoasuju. To bajicõari, cajemose busuyuju ti. To bajise botise ĩabetirũgũñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","To bajicõari, El'ias ñamasir'i, Moisés ñamasir'i rãca Jesús tʉ ruyuarʉ̃gʉ̃cõari, ĩ rãca ĩna ñagõsere ĩañujarã ĩna, Pedro mesa. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","To bajiro ĩna bajisere ĩacõari bʉto güiyujarã. Bʉto güigʉ ñari, “To bajiro yigʉ yigʉja” yiri mene, ado bajiro Jesúre yiyuju Pedro: —Yʉ ʉjʉ, adojʉ mani ñajama, quẽnamasucõaja. Mʉa ñaro cõrone vijãiri mʉare quẽnobosarʉarãja yʉa. Mʉ yajãi, Moisés yajãi, to yicõari, El'ias yajãi bʉabosarʉarãja —Jesúre yiboayuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","To bajiro ĩ yirirĩmarone, bueri bʉto cajemose ĩnare buebibecõañuju ti. Ti bueri vatoajʉ ado bajiro ocaruyuyuju: —Ãnine ñaami yʉ macʉ, yʉ maigʉ̃. Ĩre quẽnaro ajitirʉ̃nʉña mʉa —yi ocaruyuyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ti ocaruyuro bero, ĩaboayujarã. El'iare, Moisére quẽne, ĩnare ĩabʉjabesujarã. Jesús sĩgʉ̃ne ñañuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","To bajiro bajicõari bero, ti buro ĩnare ũmato rojacʉne, ado bajiro ĩnare rotiyuju Jesús: —Jẽjʉ mʉa ĩasere gãjerãre gotibeja maji, Dios ĩ roticõacacʉ, yʉ rijato bero, quẽna yʉ tudicatiroto rĩjorore —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","To bajiro ĩna bajirere gãjerãre gotimenane, ĩna masune tʉoĩacõa ñañujarã ĩna. Tire tʉoĩacõa ñarã ñari, ado bajiro gãmerã yisẽniĩañujarã: —¿No bajiro yire ũnire yigʉ yati, “Rijacoaboarine tudicatirʉcʉja” ĩ yijama? —gãmerã yisẽniĩañujarã Pedro mesa. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","To bajiro yirã ñari, ado bajiro Jesúre sẽniĩañujarã ĩna: —¿No yirã, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ ĩ ejaroto rĩjoro ejarʉcʉmi El'ias ñamasir'i”, yati ĩna Dios ĩ rotimasire gotimasiorimasa? —Jesúre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","To ĩna yijare, ado bajiro ĩnare cʉdiyuju Jesús: —Riojo yiyuma Dios ĩ rotimasire gotimasiorimasa, “El'ias ñamasir'i ejasʉorʉcʉmi”, ĩna yijama. “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, ĩ ejaroti ñajare, jediro Dios ĩ bojarore bajiro yirã quẽnaro ñayuto mani” yigʉ ejasʉorʉcʉmi. “To bajiro yaja” yimasirã ñaboarine, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉre ĩatecõari, cojo vãme me rojose ĩre yirʉarãma masa, Dios oca ĩna yiucamasirejʉarema ajimasibeama. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Riojo mʉare gotiaja yʉ. El'ias ñamasir'ire bajiro bajigʉ jẽre ejaboayumi. Dios oca masa ĩna ucamasiriarore bajiro yirã, ĩna bojarore bajiro rojose ĩre yiyuma ĩna —ĩnare yiyuju Jesús, Pedro mesare. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Burojʉ ejariarã, ĩna rãcana ĩna ñarojʉre tudiejayujarã. Tudiejacõari, ĩna ĩajama, Jesús buerimasa rãca jãjarã masa ñañujarã. To bajicõari, ĩna rãca, Dios ĩ rotimasire gotimasiorimasa rãca ĩna gãmerã oca josasere ĩañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús ĩ vadisere ĩacõari, bʉto variquẽnañujarã. Variquẽnarã ñari, ĩ tʉ ũmasujarã ĩre sẽnirã vana. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ĩre ĩna sẽnigajanoro, ado bajiro ĩnare sẽniĩañuju Jesús: —¿No bajise ĩna rãca gãmerã oca josari mʉa? —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To ĩ yisere ajicõari, sĩgʉ̃ ado bajiro Jesúre cʉdiyuju: —Gotimasiorimasʉ, yʉ macʉ ĩ ʉsʉjʉ vãti sãñagʉ̃ ñaami. To bajiro bajica yigʉ, ñagõbecʉ ñaami. To bajiri “Jesús, vãtire burocagʉmi” yigʉ, yʉ macʉre ãmivabʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tocãrãcajine yʉ macʉ ʉsʉjʉ sãñacõari, ĩre rojose ĩ yijama, biyaroaca rijaquedicõari, ĩ risejʉ sõmo budi, guji põguẽ, ĩ rujʉ tutuajedicoarũgũami. To bajiro ĩ bajijare, mʉ buerimasare, “Yʉ macʉ ʉsʉjʉ sãñagʉ̃re vãtire burocaya”, ĩnare yisẽniboabʉ. Ĩre burocamasimema —Jesúre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","To ĩ yisere ajicõari, ado bajiro yiyuju Jesús: —Diore ajitirʉ̃nʉmena masu ñacõaja mʉa. ¿No cõrojʉ mʉare gotimasio tʉjagʉti yʉ? Yoaro mʉa rãca yʉ ñaboajaquẽne, yʉ masisere mʉare yʉ ʉjosere ajitirʉ̃nʉbeaja mʉa maji —ĩnare yiyuju Jesús. To yigʉne, —Adojʉa vãti sãñagʉ̃re ãmiaya —yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","To ĩ yisere ajicõari, Jesús tʉjʉ ĩre ãmiasujarã. To ĩna yirone, vãtijʉa, Jesúre ĩacõari, masʉ ʉsʉjʉ sãñagʉ̃ ñari, rojose yiyuju, masʉjʉare. To bajiro ĩ yijare, rijaquedigʉne, ĩ risejʉ sõmo budiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","To ĩ bajirone, rijaquedigʉ jacʉre ado bajiro sẽniĩañuju Jesús: —¿Nocãrãcarodori ado bajiro bajitʉsajari mʉ macʉ? —ĩre yiyuju Jesús. To ĩ yisere ajicõari, ado bajiro Jesúre cʉdiyuju ĩ: —Daquegʉaca ñagʉ̃jʉne to bajiro bajisʉocami. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Cojoji me jeamejʉ rocatĩacõarũgũmi. To yicõari, oco vatoajʉ quẽne rocaroacõarũgũmi. To bajiro yirũgũmi, yʉ macʉre sĩarʉ. Yʉare mʉ ejarẽmomasijama, yʉare ĩamaicõari, ejarẽmoña mʉ —Jesúre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","To ĩ yisere ajicõari, ado bajiro ĩre yiyuju Jesús: —“Yimasigʉ̃mi”, ¿yʉre yitʉoĩabeati mʉ? To bajiro yʉre mʉ yitʉoĩajama, ñiejʉa josase manoja —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To ĩ yisere ajicõari, ado bajiro cʉdiyuju ĩ: —“Yʉ macʉre catiomasigʉ̃mi”, mʉre yitʉoĩamasicõaja, bajigʉjʉma. To bajiro tʉoĩavʉogʉ, “Ñabeticõato” yigʉ, yʉre ejarẽmoña —Jesúre yiavasãñuju ĩ, rijaquedigʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","To bajiro ĩ yiavasãsere ajicõari, jãjarãbʉsa masa ũmarẽjañujarã, Jesús tʉjʉ. To ĩna bajisere ĩacõari, tutuase rãca ado bajiro vãtire yiyuju Jesús: —Vãti, yʉre ajiya. “Masa ñagõbeticõato”, to yicõari, “Ajibeticõato” yigʉ ñaja mʉ. ¡To bajiri ãni ʉsʉre budiya! ¡Quẽna ĩre tudisãjabeja! —vãtire yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","To ĩ yirone, avasãcõari, rijaquedirotiyuju vãtijʉa. To yicõari, ĩ ʉsʉjʉ sãñaboagʉ, budicoasuju yuja. Ĩ budirone, rijar'ire bajiro bajicoasuju masʉjʉa. To bajise ĩacõari, “Rijacoajami”, yiyujarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","To ĩna yiboajaquẽne, Jesús ĩ ãmore ñiacõari, ĩre tʉ̃a vʉ̃mʉoñuju. To ĩ yirone, rʉ̃gõcoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","To yicõari bero, to ñarivijʉ sãjañuju Jesús. Ti vijʉ sãjaejacõari, ado bajiro ĩre sẽniĩañujarã ĩ buerimasa: —¿No yirã vãtire burocamasibeti yʉa? —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Jẽjʉ yʉ burocagʉre bajiro bajirãre mʉa burocarʉajama, Diore sẽnicõari rĩne burocamasirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Cesarea de Filipo ñar'i, vacʉ, Galilea sitare ĩ buerimasare ũmato rẽtoasuju Jesús. Jãjarã masa ĩna ajisere bojabesuju, ĩ buerimasare goticudigʉ ñari. Ado bajiro ĩnare gotiyuju: —Yʉre Dios ĩ roticõacacʉre masare ĩsirocarʉcʉmi sĩgʉ̃. To bajiro ĩ yijama, yʉre sĩarʉarãma ĩna. Yʉre ĩna sĩaboajaquẽne, idiarʉ̃mʉ tʉsatirʉ̃mʉne quẽna tudicaticoarʉcʉja yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","To bajiro ĩnare ĩ gotisere ajimasibesujarã ĩ buerã. To bajirã ñaboarine, ĩre sẽniĩabesujarã, ĩre güirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum vãme cʉti macajʉ ĩnare ũmato vasuju Jesús. To bajivana, “¿Ñimʉjʉa ñagʉ̃ti ñamasugʉ̃ ñarocʉ?”, gãmerã yi vasujarã Jesús buerimasa. To bajiro ĩna yi vare ñajare, ĩna ya vijʉ sãjaejacõari, ado bajiro ĩnare sẽniĩañuju Jesús: —Maa vana, ¿no bajise gãmerã oca josa vadi mʉa? —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","To bajiro ĩ yisẽniĩasere ajiboarine, cʉdibesujarã ĩna, “¿Ñimʉjʉa ñagʉ̃ti ñamasugʉ̃ ñarocʉ?” gãmerã yi oca josa vadiriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ĩna cʉdibetire, ĩa, ejarũjucoasuju Jesús. To bajicõari, ĩ buerimasare, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre jirẽoñuju. To bajiro yicõari, ado bajiro ĩnare gotiyuju: —No bojagʉ ñamasugʉ̃ ĩ ñarʉajama, “Ñamasugʉ̃ me ñaja yʉ” yitʉoĩacõari, masa jedirore moabosarʉcʉmi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","To yigʉne, sĩgʉ̃ daquegʉre jicõari, ĩna rĩjorojʉa ĩre ãmijeoyuju Jesús. To yicõari, ado bajiro ĩnare gotiyuju: ");
INSERT INTO bsnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ãni daquegʉ, “Ñamasugʉ̃ me ñaja yʉ” ĩ yitʉoĩarore bajiro tʉoĩarãma, Ʉjʉ Dios yarã ñamasurã ñaama. To bajiro ti bajijare, ãni daquegʉre bajiro tʉoĩarãre, gãjerã tʉ ĩna ejaro, quẽnaro ĩnare yirãma, yʉrene quẽnaro yirã yirãma. To yicõari, yʉre quẽnaro yirãma, yʉre cõacacʉre quẽne, quẽnaro yirã yirãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ado bajiro Jesúre gotiyuju Juan: —Gotimasiorimasʉ, masa ʉsʉrijʉ sãñarãre vãtiare bureagʉre ĩamʉ yʉa. “Jesúre ajitirʉ̃nʉgʉ̃ ñari, ado bajise mʉare rotimasiaja yʉ: ‘Budiya’ ”, yiñaami, vãtiare bureagʉ. Mani rãcagʉ me ĩ ñajare, “Tire yibesa”, ĩre yibʉ yʉa —Jesúre yigotiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","To ĩ yisere ajicõari, ado bajiro ĩre yiyuju Jesús: —“Tire yibeticõaña”, ĩre yibeja. Quẽnaro yirimi. No bojagʉ yʉre rʉ̃cʉbʉocõari, ĩaĩañamani ĩ yiĩoro bero, rojose yʉre ñagõbecʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","No bojagʉ yʉre ajitirʉ̃nʉcõari, mani yise ũnire yigʉma, mani rãcagʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Riojo mʉare gotiaja yʉ. Yʉre ajisʉyarã ñamasurã me ĩna ñaboajaquẽne, yʉre ajitirʉ̃nʉrã mʉa ñajare, quẽnaro mʉare yirã, to bajiro ĩna yise vaja, vaja bʉjarʉarãma ĩna, Dios tʉjʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Quẽna ado bajiro ĩ buerimasare gotiyuju Jesús: —Ãni daquegʉre bajiro tʉoĩarãre, yʉre ajitirʉ̃nʉrãre rojose ĩna ũmato yijama, bʉto rojose tãmʉorʉarãma. Rojose ĩnare ĩna ũmato yiroto rĩjoro, tocãrãcʉrene ĩna ãmʉarijʉre gʉ̃ta jairica siatucõari, riaga ʉ̃cʉarojʉ ĩnare rearoderuucõajama, rojose tãmʉobetibʉsaborãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“‘Rẽtoro rojose tãmʉorobe’ yirã, rojose mʉa yisere yitʉjaya mʉa” yigʉ, ado bajiro ĩnare gotiyuju Jesús: —“Yʉ ãmo sʉorine rojose yibʉ yʉ” mʉa yitʉoĩamasijama, jatarocaya. Mʉare cojo ãmo ti manijama, quẽnabetoja. To bajiboarine, jʉaãmo rãca mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tojʉ ĩna rujʉrire becoa batʉjabetirʉarãma. To yicõari, jeamere yarocʉ quẽne magʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Yʉ gʉbo sʉorine rojose yibʉ yʉ” mʉa yitʉoĩamasijama, jatarocaya. Mʉare cojo gʉbo ti manijama, quẽnabetoja. To bajiboarine, jʉa gʉbo rãca mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tojʉ ĩna rujʉrire becoa batʉjabetirʉarãma. To yicõari, jeamere yarocʉ quẽne magʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Yʉ cajea sʉorine ĩabojacõari, rojose yibʉ yʉ” mʉa yitʉoĩamasijama, tiare ãmirocacõaña. Coja cajea mʉare ti manijama, quẽnabetoja. To bajiboarine, jʉajʉne caje cʉticõari, mʉa bajireajama, jeame yatibetimejʉ mʉa vajama, rẽtobʉsaro quẽnabetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tojʉ ĩna rujʉrire becoa batʉjabetirʉarãma. To yicõari, jeamere yarocʉ quẽne magʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Rojose ñaja” yimasiboarine, rojose mʉa yijama, quẽnabetoja. To bajiri, “Rojose yibetirʉarãja”, yitʉoĩacõa ñarũgũña mʉa. Rojose yiterã ñari, bʉto mʉa bojase ti ñaboajaquẽne, tire mʉa yibetijama, bʉtobʉsa Diore ajitirʉ̃nʉrã ñarʉarãja mʉa. To bajiro mʉa bajirotire bojagʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa ñaja bare sãre. Mʉa barotire vaibʉcʉ rii catisere cũrãma, moa turãja mʉa, “Boarobe” yirã. Moa ti ocaboase ti ocabeticoajama, “Quẽna tudiocato” yirã, no bajiro yimasimenaja mʉa. Moa ocabetire bajiro bajiama sĩgʉ̃ri. Ĩna sʉorine quẽnaro yimasibeami Dios. Moa ocatʉjabetijʉare bajiro bajiya mʉa. To bajiro bajirã mʉa ñajama, mʉa sʉorine quẽnaro yimasigʉ̃mi Dios. Yʉre mʉa ajitirʉ̃nʉ tʉjabetijama, rojose yibetibʉsarʉarãma gãjerã. Gãjerã quẽnaro mʉa yisere ĩacõari, mʉare bajiro quẽnaro yirʉarãma ĩna quẽne. To bajiro bajirã ñari, quẽnaro gãmerã yiñaña —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaum ñar'i, Judea sitajʉ ĩ buerimasare ũmato vasuju Jesús. To eja, Jordán vãme cʉtirisa jẽa, to boejʉajʉ jãjarã masa ĩ rãca rẽjañujarã quẽna. Tojʉ ĩnare gotimasioñuju, ĩ yirũgũriarore bajirone. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","To ĩnare ĩ gotimasio ñarone, ĩ tʉ ejayujarã fariseo masa. Ejacõari, “Cʉdimasibeticõari, rojose tãmʉoato” yirã, ado bajise ĩre sẽniĩatoyujarã ĩna: —¿Sĩgʉ̃ ĩ manajore ĩ rocajama, quẽnacõati? —ĩre yisẽniĩañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","To bajiro ĩre ĩna yisẽniĩasere ajicõari, ado bajiro ĩnare cʉdiyuju ĩ: —¿No bajise rotimasiñujari Moisés? —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","To ĩ yisere ajicõari, ado bajiro cʉdiyujarã ĩna: —Ado bajiro rotimasiñuju: “No bojagʉ ĩ manajore ĩ rocarʉajama, ‘Mʉre rocagʉ yaja’ yise papera ucacõari, ĩsiroti ñaja”, yimasiñuja Moisére Dios ĩ roticũmasire —Jesúre yicʉdiyujarã fariseo masa. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","To ĩna yirone, ado bajiro yiyuju Jesús: —Diore ajiterã ĩna ñajare, “Bʉtobʉsa ĩna manajoare rojose yiroma” yigʉ, manajoa reare beobetimasiñuju Moisés ñamasir'i. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Rẽmojʉ ʉ̃mʉre, rõmiore rujeomasiñuju Dios”, yigotiaja Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","To yicõari, gajejʉ ado bajiro gotiaja Dios oca: “Ʉ̃mʉ, rõmio ĩ rujeore ti ñajare, ʉ̃mʉjʉa, manajo cʉtigʉ ĩ jacʉare ĩnare cãmotadicoarʉcʉmi. Manajo cʉticõari, jʉarã ñaboarine, sĩgʉ̃ rujʉre bajirone ñarʉarãma”, yigotiaja Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","“To bajirʉarãma” Dios ĩ yimasire ñajare, mʉa manajoare reabetiroti ñaja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","To ĩ yiro bero, vijʉ ñacõari, to bajiro ĩ gotisere sẽniĩañujarã ĩ buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","To ĩna yijare, ado bajiro ĩnare cʉdiyuju Jesús: —Ĩ manajore rocacõari, gajeo ĩ manajo cʉtijama, Dios ĩ ĩajama, ĩ manajo masu me ñagõmo. Sore ajerio cʉtigʉ yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","To bajirone bajiaja rõmiore quẽne. So manajʉre rocacõari, gãjire so manajʉ cʉtijama, so manajʉ masu me ñagʉ̃mi, Dios ĩ ĩajama. Ĩre ajeri cʉtigo yigomo —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesús tʉjʉ rĩamasacare juaejayujarã masa, “Ĩ ãmori ñujeocõari, Diore ĩnare sẽnibosato ĩ” yirã. Ĩna juaejasere ĩacõari, ado bajiro ĩnare yiyujarã ĩ buerimasa: —¡Juadibesa! Gõjanabioro yaja mʉa —ĩnare yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","To ĩna yisere ĩajũnisinigʉ̃ne, ado bajiro ĩnare gotiyuju Jesújʉa: —Rĩamasare ĩnare matabesa. Ĩnare bajiro tʉoĩarã ñaama Ʉjʉ Dios yarã quẽnaro ĩ yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Riojo mʉare gotiaja yʉ. Rĩamasa ĩna yiecorore bajiro quẽnaro yiecorã ñaama Ʉjʉ Dios yarã —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","To ĩnare yigotigajanocõari, rĩamasare ĩ ãmori ñujeocõari, Diore ĩnare sẽnibosayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Quẽna Jesús varũtu vacʉ ĩ bajirone, sĩgʉ̃, ũmaejayuju. Ejacõari, ĩ rĩjorojʉa gʉsomuniari tuetugʉne, ado bajiro Jesúre ĩre sẽniĩañuju: —Gotimasiorimasʉ, quẽnagʉ̃ ñaja mʉ. Yʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere yʉre ĩ ĩsisere yʉ bojajama, ¿no bajiro yiroti ñati yʉre? —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju: —¿No yigʉ, “Quẽnagʉ̃ ñaja mʉ”, yʉre yati mʉ? Dios sĩgʉ̃ne ñaami quẽnagʉ̃ma. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉ bʉjarʉajama, Dios ĩ rotimasirere cʉdiroti ñaja. Tire masiaja mʉ. Dios ĩ rotimasire yʉ yijama, ado bajise yimasirere yaja yʉ: “Sĩabesa. Gãji manajo rãca ajerio cʉtibesa. Juarudibesa. Socʉne, ‘Rojose yimi’ yigotiyirobesa. Gãjerãre yitobesa, ‘Ĩna ye cʉogʉsa’ yigʉ. Mʉ jacʉre, mʉ jacore quẽne quẽnaro ĩnare rʉ̃cʉbʉoya”, yigotiaja Dios ĩ rotimasire —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","To ĩ yisere ajicõari, ado bajiro yicʉdiyuju: —Daquegʉjʉne tire cʉdisʉoadimasicajʉ yʉ —ĩre yicʉdiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","To ĩ yisere ajicõari, ĩre ĩamaiñuju Jesús. To bajiri, ado bajiro ĩre gotiyuju: —Cojo vãme rʉyaja mʉ yiroti, mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉ bʉjarʉajama: Jediro mʉ cʉosere gãjerãre ĩsijeocõaña. To yicõari, ti vaja mʉ bʉjasere maioro bajirãre ĩsima. To bajiro mʉ yijama, õ vecajʉ Dios ĩ ñarojʉ quẽnase bʉjarʉcʉja mʉ. To bajiro yigajanocõari, yʉre ajisʉyaya —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","To ĩ yigʉ, bʉto sʉtiriti vacoasuju ĩ, gajeyeũni jaigʉ ñari, tire maigʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","To yigajanogʉ̃ne, ĩ buerimasare ĩacõari, ado bajiro gotiyuju Jesús: —Gajeyeũni jairãrema, yʉre ĩna sʉyarʉa tʉoĩaboajama, bʉto josarʉaroja ĩnare. To bajicõari, yirẽto ecobosabetirʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","To bajiro ĩ yisere ajicõari, no yimasibesujarã ĩ buerimasa, ti ũnire ajibetirũgũrã ñari. To bajiri quẽna ĩnare gotirẽmoñuju Jesús: —Yʉ buerã, ajiya. No bojarã, yʉre ĩna sʉyarʉa tʉoĩaboajama, bʉto josarʉaroja ĩnare. To bajiboarine bʉtobʉsa josarʉaroja gajeyeũni jairãrema. Vaibʉcʉ camello vãme cʉtigʉ, gãjojota gojeacare sãjarẽtobudimasibecʉmi. To bajirone bajiaja gajeyeũni jairãre quẽne, yʉre ĩna ajitirʉ̃nʉ sʉyarʉaboajama. To bajiro ĩna bajijare, yirẽto ecobosabetirʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","To bajiro ĩnare ĩ gotisere ajicõari, no yimasibesujarã ĩna. To bajiri ado bajiro ĩre sẽniĩarẽmoñujarã: —Riojo mʉ gotijama, ¿no bajiro bajirãjʉa Dios tʉjʉre ejarʉarãda? —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","To ĩna yirone, ĩnare ĩacõari, ado bajiro ĩnare gotiyuju Jesújʉama: —Ĩna masune ejamasimenama masa, Dios tʉjʉre. Diojʉama, ñajediro yimasijeocõami. Ñiejʉa josase maja, ĩrema. Ĩ sʉorine ĩ tʉjʉ ejamasire ñaja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","To ĩ yisere ajicõari, ado bajiro ĩre yiyuju Pedro: —Jediro yʉa gajeyeũnire cũcõari, mʉre sʉyacajʉ yʉa —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Riojo mʉare gotiaja yʉ. No bojarã yʉre ajitirʉ̃nʉrã ñari, yʉ ocare gotiroana, ĩna ya vi, ĩna yarã, ĩna jacʉa, ĩna rĩa, to yicõari ĩna ya veserire quẽne, ĩna maise ñaro cõro ĩna vaveojama, ĩna cʉoboare rẽtobʉsaro quẽnase bʉjarʉarãma ĩna, adi macarʉcʉrore. Yʉre ajitirʉ̃nʉrã ñari, rojose tãmʉorã ñaboarine, ado bajiro quẽnaro ĩnare yirʉcʉmi Dios: Jairo viri, jairo veseri, jãjarã yarã cʉti, to yicõari jãjarã rĩa cʉtireayere ĩsirʉcʉmi Dios. To yicõari, “Ĩna rijato berojʉma tudirijabeticõato” yigʉ, ĩ catisere ĩnare ĩsirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","To bajiboarine, adire quẽne quẽnaro tʉoĩaña mʉa: Ado bajiro mʉa tʉoĩarore bajirone tʉoĩaboarãma: “Dios ĩ bojase yirã rẽtoro Dios ĩ bojasere yirã ñari, ñamasurã ñaja yʉa. To bajiri, õ vecajʉre quẽne ñamasurã ñari, quẽnase bʉjarʉarãja”, yitʉoĩaboarãma. To bajiro yirã ñari, gãjerãre ĩacõari, “Ĩna ya vi, ĩna yarã, ĩna jacʉa, ĩna rĩa, to yicõari ĩna ya veserire vaveomena ñari, ñamasurã me ñaama. To bajiri, õ vecajʉre quẽnase mojoroaca bʉjarona ñaama”, yitʉoĩaboarãma. To bajiro me bajirʉaroja. Adojʉ ñamasurã, õ vecajʉarema ñamasumena ñarʉarãma ĩna. Adi macarʉcʉrojʉ ñamasumenama, õ vecajʉarema ñamasurã ñarʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ĩ buerimasa, Jerusalénjʉ Jesús ĩnare ĩ ũmato varũtu vajare, “Ʉjarã ĩre ĩaterã ĩna ñarojʉ ĩ vasere güibeticõami Jesús”, ĩre yitʉoĩa vasujarã ĩna. Ĩnajʉama, ĩre sʉyarã, bʉto güiyujarã. To ĩna bajirone, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre ĩ buerãre ricati ĩnare jicãmotocõari, ado bajiro ĩnare gotiyuju: ");
INSERT INTO bsnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Quẽnaro ajiya mʉa. Jerusalénjʉ vana bajiaja mani. Tojʉ mani ejaro, Dios ĩ roticõacacʉre, sĩgʉ̃ yʉre ĩsirocarʉcʉmi, paia ʉjarãre, to yicõari, Dios ĩ rotimasire gotimasiorimasare. Ĩnajʉa, “Ĩre sĩaroti ñaja”, yʉre yirʉarãma. To yicõari, romano masare yʉre ĩsirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","To ĩna yijare, yʉre ajatud'irã, gooco yʉre eoreatucõari, bajerʉarãma ĩna. To yicõari yucʉ́tẽrojʉ yʉre jajurocacõarʉarãma. Yʉre jajurocacõari, yujeboarʉarãma. To ĩna yiboajaquẽne, yʉre ĩna sĩarirʉ̃mʉ bero, idiarʉ̃mʉ tʉsatirʉ̃mʉne tudicaticoarʉcʉja yʉ quẽna —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","To ĩ yiro bero, Zebedeo rĩa, Santiago, to yicõari Juan, Jesúrãca ñagõrã ejayujarã ĩna. Ejacõari, ado bajiro ĩre sẽniñujarã: —Gotimasiorimasʉ, “Ado bajiro yʉare ejarẽmoña” mʉre yʉa yisẽnisere, mʉ cʉdise bojaja yʉa —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","To bajiro ĩna yisere ajicõari, —¿No bajiro mʉare yʉ yibosasere bojati mʉa? —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","To ĩ yijare, ado bajiro ĩre yiyujarã ĩna: —“Ñajediro ʉjʉ ñaja yʉ” yiĩocõari, mʉ rotisʉorirodo ti ejaro, ado bajiro yʉare mʉ ũmato rujirotire bojaja yʉa: Sĩgʉ̃ mʉ riojojacatʉa, gãjire mʉ gãcojacatʉa yʉare ũmato rujirʉcʉja mʉ, mʉ rotirore bajirone yʉa rotimasirotire yigʉ —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","To bajiro ĩre ĩna yisẽniboajaquẽne, ado bajiro ĩnare cʉdiyuju Jesús: —Tʉoĩamasimenane, yʉre sẽniboaja mʉa. Yʉ rãca mʉa rotirʉajama, ¿mʉa quẽne yʉre bajirone rojose tãmʉorãtique mʉa? —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","To bajiro ĩnare ĩ yirone, —Bajicõarãja —ĩre yicʉdiyujarã. To bajiro ĩna cʉdise ñajare, ado bajiro yiyuju Jesús: —Riojo mʉare gotiaja yʉ. Mʉa quẽne, yʉ tãmʉorotire bajiro rojose tãmʉorʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","To bajiro mʉa bajiboajaquẽne, yʉ riojojacatʉa, yʉ gãcojacatʉa mʉare rojomasibecʉja yʉ. “Ĩna ñarʉarãma yʉ macʉ tʉ rujirona” yʉ jacʉ ĩ yicana rĩne rujirʉarãma —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesús buerimasa jʉaãmo cõro ñarã ĩna ajibetone, “To bajiro bojaja yʉa” ĩna yisere ajicõari, jũnisiniñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","To bajiro ĩna bajijare, ĩna jedirore jirẽocõari, ado bajiro gotiyuju Jesús: —Ʉjarã, Dios yarã me ñarã, ĩna yarãre bʉto tutuaro rotirãma ĩna. Tire masiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉama, yʉ yarã ñari, ĩnare bajiro bajibetirʉarãja. Yʉre ajitirʉ̃nʉrã, ñamasurã ñarʉarãma, gãjerã ĩna bojasere masicõari, quẽnaro ĩnare yiejarẽmorã. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","To bajiri ñamasurã mʉa ñarʉajama, gãjerãre moabosarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dios ĩ roticõacacʉ quẽne, to bajirone yaja yʉ. “Gãjerã yʉ bojasejʉare masicõari, quẽnaro yʉre yato ĩna” yigʉ me vadicajʉ yʉ. “Ĩna bojasere masicõari, quẽnaro ĩnare yirʉcʉja” yigʉ vadicajʉ yʉ. To yicõari, jãjarã rojose ĩna yisere Dios ĩ masiriorotire ĩnare vaja yibosagʉagʉ vadicajʉ yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericó vãme cʉti maca ñacõari, ĩna vatone, jãjarã masa ĩnare sʉyasujarã, Jesúre ĩarã. Tojʉ ĩna vatone, ĩabecʉ, Bartimeo vãme cʉtigʉ rujiyuju, maa tʉ. Timeo macʉ ñañuju ĩ. Maioro bajigʉ ñari, ĩ barotire, to yicõari, gajeyeũniaca ĩ cʉorotire tʉoĩagʉ̃, gãjoa sẽnirujiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Jesús, Nazaret macagʉ rẽtoacʉ yami” masa ĩna yisere ajicõari, ado bajiro ĩre jiavasãñuju: —Jesús, Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉre ĩamaiña mʉ —yiavasãñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","To bajiro ĩ yiavasãrone, —¡Avasãbesa! —ĩre yiyujarã masa. To bajiro ĩna yiboajaquẽne, bʉtobʉsa avasãñuju quẽna: —Ʉjʉ David ñamasir'i jãnami “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉre ĩamaiña —Jesúre ĩre yiavasãñuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","To ĩ yisere ajicõari, tujarʉ̃gʉ̃ñuju Jesús. To bajicõari, —Ĩre jiya mʉa —masare ĩnare yiyuju. To ĩ yijare, ĩabecʉre jiyujarã ĩna: —Variquẽnaña. Vʉ̃mʉrʉ̃gʉ̃ña. Mʉre jiami Jesús —ĩre yiyujarã, ĩabecʉre. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","To bajiro ĩna yisere ajicõari, ĩ sudiro joeadore vearocacõañuju, “Guaro vatĩmagʉ̃sa” yigʉ. To yicõa, vʉ̃mʉrʉ̃gʉ̃ vasuju ĩ, Jesús tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ĩ ejasere ĩacõari, ado bajiro ĩre yiyuju Jesús: —¿No bajiro mʉre yʉ yisere bojati mʉ? —ĩre yiyuju, caje ĩabecʉre. To ĩ yijare, ado bajiro ĩre yicʉdiyuju: —Gotimasiogʉ̃, yʉ tudiĩarotire mʉ ejarẽmosere bojaja yʉ —ĩre yiyuju caje ĩabecʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yiyuju Jesús: —Vasa mʉ. “Yʉre ĩamaicõari, ĩarotirʉcʉmi” yʉre yitʉoĩagʉ̃ ñari, ĩacoajʉ mʉ yuja. Ñie rojose maja mʉre yuja —ĩre yiyuju Jesús. To bajiro ĩ yirirĩmarone, caje ĩabecʉ ñaboar'i, ĩacoasuju ĩ yuja. Ĩacõari, ĩ quẽne Jesúre sʉyacoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jerusalén cõñana, Betfagé, Betania vãme cʉti macari tʉjʉ ejayujarã ĩna. Ti macari tʉjʉre Olivo vãme cʉti buro ñañuju ti. Ti burojʉ ejagʉagʉne, jʉarã ĩ buerãre ado bajiro ĩnare gotiyuju Jesús: —Mani varoto riojo ñarimacare vasa maji. Tojʉ ejacõari, burro macʉ ĩna siaturʉ̃gõr'ire bʉjarʉarãja mʉa, jesaĩañamagʉ̃re. Ĩre õjacõari, yʉre ãmiadibosaba. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ti macagʉ, mʉa õjaro ĩacõari, “¿No yirã ĩre õjati mʉa?” mʉare ĩ yisẽniĩajama, “Mani ʉjʉ ĩre bojami. No cõro mene tʉocõarʉcʉmi quẽna”, ĩre yicʉdiba —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","To ĩ yisere ajicõari, vasujarã ĩna. To ejacõari, maa tʉ ñarivi soje tʉre ĩna siaturʉ̃gõr'ire ĩabʉjayujarã. Ĩabʉjacõari, ĩre ĩna õjarone, —¿No yirã ĩre õjati mʉa? —yisẽniĩañujarã ĩna, burro ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","To ĩna yisẽniĩase ñajare, Jesús ĩnare ĩ cʉdirotiriaro bajirone cʉdiyujarã ĩna. To ĩna yirone, ĩnare varotiyujarã burro ʉjarãjʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","To ĩna yijare, burro macʉre ãmivasujarã, Jesús tʉjʉ. To yicõari, ĩna ye sudi joeayere vejecõari, burro macʉ joere jeoyujarã. To ĩna yirone, vajejayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jãjarã masa ñañujarã. Ĩna ye sudi joeayere vejecõari, ĩ varotijʉre cũ rĩjoro cʉtiyujarã. “Yʉa ʉjʉ ñaja mʉ” yirã, to bajiro yiyujarã, Jesúre rʉ̃cʉbʉorã. Gãjerã yucʉ́ rʉjʉri jasurecõari, maare cũ rĩjoro cʉtiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","To yicõari, “‘“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ ñaja yʉ’ yiĩocõari, rotisʉorʉcʉmi yuja” Jesúre ĩre yitʉoĩarã ñari, bʉto variquẽnañujarã ĩna. Ĩre rĩjoro cʉti vana, ĩre sʉyarã quẽne, ĩre ĩavariquẽnarã, ado bajiro avasã vasujarã: —¡“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaami! ¡Quẽnase ĩre yivariquẽnato mani! ¡Diore rotibosagʉ quẽnaro ĩ yigʉ ñaami! ");
INSERT INTO bsnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ʉjʉ David ñamasir'i jãnami ĩ rotirirodo, “Quẽnarirodo ñarʉaroja” Dios ĩ yiriarodo ejaroado yaja! ¡Diore quẽne, quẽnase ĩre yivariquẽnato mani, ãni yʉa ʉjʉre ĩ cõajare! —yiavasã vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","To bajiro ĩna yi vato rĩne, Jerusalénjʉ ejayuju Jesús. Ejacõari, Diore yirʉ̃cʉbʉoriavire sãjañuju. Sãjaejacõari, jediro ĩabatojeocõari bero, “Rãioato bajiaja” yigʉ, ĩ buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre ũmato tudiasuju, Betania macajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gajerʉ̃mʉ Betania maca ñaboa, ĩ buerimasare ũmato vacʉ, ñiorijayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","To bajivacʉne, sõjʉne higuera vãme cʉtiʉre ĩabʉjacõañuju Jesús. Quẽnaro jũ cʉtiyuju. Ti ricare barʉ ojaboayuju. Rica mañuju, tiʉjʉama. Jũ rĩne ñañuju. Rica mañuju, rica cʉtirodo me ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","To bajiri tiʉre ado bajiro yiyuju Jesús: —Jʉaji rica maniʉcarʉarãja mʉa —tiʉre yiyuju ĩ. To bajiro ĩ yisere ajiyujarã ĩna, ĩ buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","To bajiro ĩ yiro bero, varũtu ejacoasujarã, Jerusalénjʉ. Ti macajʉ ejacõari, Diore yirʉ̃cʉbʉoriavijʉ sãjañujarã. Ti vijʉ gajeyeũni ĩsirãre, ĩnare vaja yirãre quẽne, tud'iãgõbuyuju Jesús. Gãjerã ye rãca gãjoa vasoarimasa ĩna gãjoa jeorijaʉrire tujuareayuju. To yicõari, buja ĩsirimasa ĩna rujiri cũmurorire tucaguereayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","To yicõari, Diore rʉ̃cʉbʉoriavijʉ gajeyeũni no bojasere masa jedirore juarotibesuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","To yicõari, ado bajiro ĩnare gotiyuju: —Diore gotirẽtobosarimasa ĩna ucamasire ado bajiro gotiaja: “Yʉ ya vima, masa jediro yʉre sẽnirʉ̃cʉbʉorã rẽjariavi ñarʉaroja”, yigotiaja, adi vire. To bajiro Dios ĩ yimasire ti ñaboajaquẽne, ado bajiro mʉa yiñase sʉorine juarudirimasa ya vire bajiro bajiaja ti —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ti vijʉ Diore yirʉ̃cʉbʉoriavijʉ ñañujarã paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne. To bajiro Jesús ĩ yisere ĩacõari, “¿No bajiro yicõari, ĩre sĩarãti mani?”, gãmerã yiñagõñañujarã ĩna, ĩre güirã ñari, ĩ gotimasiosere ajicõari, jãjarã masa ĩna ajirʉ̃cʉbʉose ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ĩnare gotimasiocõari bero, ti rãioatone, ĩ buerimasare ũmato vacoasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gajerʉ̃mʉ busurijʉ jẽjʉ quẽna maa vana higuera vãme cʉtiʉ, “Rica maniʉcarʉarãja mʉa” Jesús ĩ yiriʉ tʉre ejayujarã ĩna. To ejacõari, higuera sĩniar'ire ĩañujarã. Ti ñemari quẽne sĩnijedicoasuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","To cõrone Jesús ĩ ñagõrere tʉoĩabʉjacõari, gotiyuju Pedro: —Gotimasiorimasʉ, ĩaña. Higuera vãme cʉtiʉre, “Jʉaji rica maniʉcarʉarãja mʉa” mʉ yimasiricʉ sĩnirocacoasuja ti —Jesúre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","To ĩ yisere ajicõari, ado bajiro ĩ buerimasare gotiyuju Jesús: —“Dios ĩ ejarẽmose rãca yimasicõarãja”, yitʉoĩaña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Riojo mʉare gotiaja yʉ. No bojagʉ yʉre ajitirʉ̃nʉgʉ̃, i burore, “Moa riagajʉ mʉa masune rocaroacoasa” ĩ yijama, to bajirone bajirʉaroja, “Dios ĩ ejarẽmose rãca yimasicõagʉ̃ja” ĩ yitʉoĩa tʉjabetijama. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Yʉa sẽnijama, yʉare ĩsicõagʉ̃mi” yitʉoĩacõari, Diore mʉa sẽnijama, mʉare ĩsirʉcʉmi, ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Diore sẽnirã, mʉare rojose yirãre mʉa masiriojama, mani jacʉ õ vecagʉ rojose mʉa yisere masiriorʉcʉmi ĩ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gãjerãre rojose ĩna yisere mʉa masiriobetijama, mani jacʉ quẽne rojose mʉa yisere masiriobetirʉcʉmi —ĩnare yiyuju Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","To ĩ yiro bero, Jerusalénjʉ ejayujarã quẽna Jesúrãca. To bajicõari, Diore yirʉ̃cʉbʉoriavijʉ sãjañuju Jesús. Sãjaejacõari, ĩ ñacudirone, ĩ tʉ ejarʉ̃gʉ̃ñujarã paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa, to yicõari, bʉcʉrã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ejarãne, ado bajiro ĩre sẽniĩañujarã ĩna: —¿Ñimʉ mʉre ĩ rotise rãca to bajiro yirũgũati mʉ? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","To bajiro ĩna yisere ajicõari, —Yʉ quẽne, ado bajiro mʉare sẽniĩaja yʉ. Yʉre mʉa cʉdicõarojʉ, “Ĩ rotise rãca yaja yʉ”, mʉare yirʉcʉja maji. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ñimʉ rotiyujari, Juanre, “Oco rãca masare ĩnare bautizacudiya” yigʉ? ¿Dios rotiyujari? ¿Masajʉa rotiyujarique? —ĩnare yisẽniĩañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","To ĩ yisere ajicõari, ĩna masurione gãmerã ñagõñañujarã ĩna: —“Dios, Juanre oco rãca bautizarotiyumi” mani yijama, ado bajiro manire sẽniĩajacagʉmi: “Tire masirã ñaboarine, ¿no yirã ĩre ajitirʉ̃nʉbeticati mʉa?” manire yisẽniĩajacagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","To yicõari, “Masane, Juanre oco rãca bautizarotiriarãma” mani yijama, manire bʉto tud'irʉarãma masa, “Diore gotirẽtobosarimasʉ ñaboacami Juan” yirã ñari —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","To bajiro gãmerã ñagõrã ñari, ado bajiro ĩre cʉdiyujarã ĩna: —Juanre rotir'ire masibeaja yʉa —Jesúre yicõañujarã ĩna. To ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —To bajiro mʉa cʉdijare, “Ĩ rotise rãca yaja yʉ”, mʉare yigotibetirʉcʉja yʉ quẽne —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gotimasiore queti masare gotiyuju Jesús: —Sĩgʉ̃ masʉ ʉye vese otegʉmi. Tire otegajanocõari, matagʉmi. To yicõari, ʉye oco juarotijʉ quẽnogʉ̃mi. Tijʉ bero, vecajʉ ñacõari, ĩ ĩatirʉ̃nʉjesarotijʉ quẽnogʉ̃mi. To yigajanocõari, gãjerãre, “Yʉre ĩatirʉ̃nʉbosaba”, yigʉmi. “Ʉye ti rica cʉtiro, gãjerãre ĩsicõari, vaja sẽnirʉarãja. To yicõari, mʉa juajama, ‘Ado cõro ñaja mani ye. Ado cõro ñaja ĩ ye’ yicõĩama”, ĩnare yigʉmi. To yicõari, gajerojʉ vacoacʉmi yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","To bajiri cojorʉ̃mʉ, “Ʉye rica cʉti bʉcʉatoja ti” yigʉ, ĩre moabosarimasʉre cõagʉ̃mi, “Ʉye, yʉre ĩna cũbosarere yʉre juabosaya” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ʉye vesejʉ ĩ ejarone, ĩre ñiacõari jarãma vese coderimasa. To yicõa, ĩre ʉye ĩsimenane, “Vasa”, yirãma ĩna. To bajiri ʉye juabecʉne tudiejagʉmi, ĩre roticõar'i tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","To bajiri ʉye ĩ juabetire ĩacõari, gãji ĩre moabosarimasʉre cõagʉ̃mi quẽna, vese ʉjʉ, “Ʉye yʉre juabosagʉ vasa” yigʉ. Ʉye vesejʉ ĩ ejasere ĩacõari, rujajine ĩre yitud'icõari, ĩre quẽne jarãma ĩna. To bajiri ĩ rʉjoajʉ cãmi cʉtigʉmi ĩ. To bajiro ĩre yigajanocõari, ʉye ĩsimenane, “Vasa”, ĩre yirãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","To bajiri ʉye ĩ juabetire ĩacõari, quẽna gãji ĩre moabosarimasʉre cõagʉ̃mi vese ʉjʉ. Ĩre sĩarãma. Bero, jãjarãbʉsa cõarũgũboagʉmi vese ʉjʉ. Ĩnare quẽne to bajirone yirũgũrãma vese coderimasa. Sĩgʉ̃rire bʉto jarãma. Gãjerãre sĩarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ĩnare ĩ cõariaro bero, sĩgʉ̃ rʉyagʉmi yuja, ĩ cõarocʉ. Ĩ ñagʉ̃mi ĩ macʉ, ĩ maigʉ̃. To bajiri, “Yʉ macʉjʉare rʉ̃cʉbʉorʉarãma” yitʉoĩagʉ̃, ĩre cõaboagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","To bajiro ĩ yicõar'ire, vesejʉ ĩ ejasere ĩacõari, ado bajiro gãmerã ñagõrãma vese coderimasa: “Adi vese ʉjʉ macʉne ñaami. To bajiri ĩ bajirocaveojama, ĩne ñaami ĩre vasoarocʉ. To bajiri ĩre mani sĩajama, mani ye sita ñarʉaroja yuja”, gãmerã yiñagõrãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","To bajiri vese sojʉajʉ ĩre ñia vati, ĩre sĩarocacõarãma ĩna —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","To bajiro ĩnare gotigajanocõari, ado bajiro ĩnare gotiyuju quẽna: —¿Ti vese ʉjʉ tudiejagʉ, no bajiro ĩnare yigʉjari ĩ, ti vese coderimasare? Ado bajiro yigʉmi: Vesejʉ vacõari, ti vese coderãre sĩarʉcʉmi. To yicõari, gãjerãjʉare coderotigʉmi ĩ, ti vesere —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Gajeye ado bajiro gotirũtuasuju Jesús: —“Ʉye vese ʉjʉ macʉre rojorã ĩna sĩarocarere bajirone viri bʉarimasa gʉ̃ta ĩna beserocaria ñaboarine, ñamasurica ñarʉaroja”, yigotiaja Dios oca masa ĩna ucamasire. ¿Tire ĩabeticatique mʉa? Ado bajiro gotiaja: “Gʉ̃ta rãca vi quẽnorimasa coja gʉ̃tare rocarãma ĩna. Ĩna rocaria ñaboarine, gajea gʉ̃ta rẽtoro quẽnarica ñarʉaroja tia. Tia gʉ̃ta sʉorine quẽnarivi quẽnorʉcʉmi Dios. Tia manijama, quẽnomasibetibogʉmi. To bajiro bojagʉmi Dios mani ʉjʉ. To bajiri tia gʉ̃ta sʉori Dios quẽnaro ĩ yisere ajimasicõari, bʉto tʉoĩa variquẽnaja mani”, yigotiaja Dios oca masa ĩna ucamasire —ĩnare yigotiyuju Jesús, paia ʉjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesús ĩ gotimasiosere ajicõari, “Ʉye vese coderimasa ĩ yijama, manirene yigʉ yami. To yicõari, gʉ̃tavi quẽnorimasa ĩ yijaquẽne, manirene yami. Ĩre rojose mani yisere yigʉ yami”, yiajimasiñujarã ĩna. To bajiri Jesúre ñiarʉaboayujarã. To bajiboarine masare güirã, ĩre ñiabesujarã. Ĩre ñiarʉaboa, vacoasujarã ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bero, fariseo masa, to yicõari, “Ʉjʉ ñamasugʉ̃ ñarʉcʉmi Herodes” yirũgũriarã, Jesús tʉ ĩna rãcanare cõañujarã ĩna, “Ado bajiro josari mʉa sẽniĩajama, cʉdimasibeticõari rojose tãmʉorʉcʉmi Jesús” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","To ĩna yicõariarã, ado bajiro Jesúre sẽniĩañujarã ĩna: —Ajiya gotimasiorimasʉ. “Riojo gotiami”, mʉre yimasiaja yʉa. “Ado bajiro mani yisere bojagʉmi Dios” yigotimasiogʉ̃ ñari, riojo yʉare gotimasioaja mʉ. “Ado bajiro yʉ gotimasiojama, yʉre ajijũnisinirʉarãma” yitʉoĩabecʉne, riojo gotigʉ ñaja mʉ. “Ãnoama, ñamasurã ĩna ñajare, ĩna ajijũnisinibeti vãmejʉare ĩnare gotimasiorʉcʉja”, yitʉoĩabecʉ ñaja mʉ. Masa ñajedirore yʉare riojo gotigʉ ñaja mʉ. To bajiro yigʉ mʉ ñajare, mʉ tʉoĩasere ajirʉaja yʉa. ¿Roma macagʉ ʉjʉ, César, gãjoa manire ĩ vaja yirotisere mani vaja yijama, quẽnacõarojari? ¿Dios ĩ rotimasirere cʉdimena yirãjarique mani, ĩre mani vaja yijama? —Jesúre yisẽniĩaboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesújʉama, “Rojose yʉre yirʉarã, to bajise yʉre sẽniĩatoama ĩna”, yimasicõañuju. To bajiri ado bajiro ĩnare yiyuju: —¿No yirã, “Rojose ĩre yirãsa” yirã, to bajise yʉre sẽniĩatoati mʉa? —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","—Gãjoatii cojotii yʉre ĩoña —ĩnare yiyuju Jesús. To ĩ yijare, gãjoatii ĩre ĩoñujarã. Gãjoatiire ĩacõari, ado bajiro ĩnare sẽniĩañuju Jesús: —¿Ñimʉ rioga tuyati? ¿Ñimʉ vãme tuyati? —ĩnare yiyuju Jesús. To ĩ yirone, —Roma macagʉ Ʉjʉ César vãme cʉtigʉ rioga tuyaja. To yicõari, ĩ vãme quẽne ñaja ti —Jesúre yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","To ĩna yijare, ado bajise yiyuju Jesús: —To bajiri aditiire ĩacõari, “César yatii ñaja”, yimasiaja mʉa. To bajiri ʉjarã ĩna vaja yirotijama, ĩnare vaja yiroti ñaja. To bajirone bajiaja Diore quẽne. Jediro Dios ĩ cõase ti ñajare, “Yʉa cʉose ti ñaboajaquẽne, ti rãca mʉ bojarore bajiro yirʉarãja”, Diore ĩre yiroti ñaja manire —ĩnare yiyuju Jesús. To bajiro ĩ yisere ajicõari, no yimasibesujarã ĩna, ĩre bajiro quẽnaro gotigʉre ajibetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","To bajicõari, saduceo masa quẽne ejayujarã, Jesúre sẽniĩatorã. “Masa ĩna rijato bero, ĩna ʉsʉri, ĩna rujʉri ñaro cõrone quẽna tudicatimenama” yirã ñañujarã saduceo masa. Ado bajiro ĩre sẽniĩañujarã: —Ajiya gotimasiorimasʉ. Moisés ñamasir'i ado bajiro ĩ yiucacũmasire ti ñajare, mʉre sẽniĩarã vabʉ yʉa. “Sĩgʉ̃, manajo cʉtiboa, rĩa magʉ̃ne ĩ bajirocajama, ĩ gagʉ manajo ñariore manajo cʉtirʉcʉmi ĩ bedijʉa. To bajiri ĩ rãca ñacõari, so macʉ cʉtijama, ĩ gagʉ macʉ ñarʉcʉmi”, yimasiñuju Moisés. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sĩgʉ̃ rĩa cojomo cõro, jʉa jẽnituarirãcʉ ʉ̃mʉa ñaboacama. Sĩgõrene manajo cʉtiboacama ĩna. Ñasʉogʉ sore manajo cʉtisʉoboacami. Rĩa magʉ̃ne rijacoacami ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Ĩ rijato bero, gãji ĩ bedi vasoaboacami. Ĩ quẽne rĩa magʉ̃ne rijacoacami. Ĩ bederã quẽne, to bajirone sore manajo cʉtiboacama. Rĩa manane, rijajedicoacama ĩna quẽne. So manajʉa ĩna rijajediro bero, so quẽne rijacoacamo yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To bajiri bajireacõari, quẽna ĩna tudicatijama, ¿ñimʉjʉa ñaguĩda so manajʉ masu ñarocʉma, ĩna ñaro cõrone sore ĩna manajo cʉticato bero? —Jesúre yisẽniĩatoyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","To ĩna yirone, ado bajiro cʉdiyuju Jesús: —Dios oca, masa ĩna ucamasire ajimasimena ñaja mʉa. Dios ĩ masisere quẽne masirã me ñaja. To bajirã ñari, Moisés ĩ ucamasirere tʉoĩacõari, “Riojo me gotiro yaja”, yitʉoĩaboaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ado bajirojʉa bajiaja: Bajireariarã, ĩna tudicatiro bero, manajo cʉtire, manajʉ cʉtire quẽne manirʉaroja. Ángel mesare bajiro bajirã ñarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿“Masa ĩna bajirearo bero, ĩna ʉsʉri caticõaroja” yirere ĩabeticatique mʉa? ¿Yucʉ́yoa ʉ̃jʉriyoa vatoajʉ Dios Moisére ĩ ñagõmasirere ĩabeticatique? Dios masune ĩre ĩ gotimasirere ado bajiro ucamasiñumi Moisés: “Mʉa ñicʉa ñamasiriarã Abraham, Isaac, Jacob, ĩna rʉ̃cʉbʉo vadimasicacʉne ñaja yʉ”, yigotimasiñumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Masa bajireariarã ĩna ʉsʉri ti caticõa ñabetijama, to bajise yibetimasiborimi. Bajireariarã, quẽna tudicatirãjʉa ĩna rʉ̃cʉbʉogʉ ñaami. “Ĩna ʉsʉri ti caticõa ñajare, bajireariarã ñaboarine, Diore rʉ̃cʉbʉocõa ñarãma” yire ñaja. Bʉto mavisiaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sĩgʉ̃, Dios ĩ rotimasire gotimasiorimasʉ ejayuju. Ejacõari, Jesúrãca ĩna ñagõrore ajiñañuju ĩ. To bajiri, “Quẽnaro cʉdiami Jesús” yiajigʉ ñari, ĩre sẽniĩañuju ĩ: —Dios ĩ rotimasire ñamasuse, ¿disejʉa ñati? —ĩre yisẽniĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","To ĩ yisere ajicõari, ado bajiro cʉdiyuju Jesús: —Dios ĩ rotimasire ñamasuse ado bajiro gotiaja: “Ajiya mʉa, Israel sitana. Dios sĩgʉ̃ne ñaami mani ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mani ʉjʉre, Diore bʉto mairoti ñaja. No bojagʉre mani mairo rẽtoro, no bojase mani cʉose, mani bojatʉoĩase, to yicõari mani moare cʉtise rẽtoro Diore mairoti ñaja”, yigotiaja Dios ĩ rotimasire ñamasuse. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","To yicõari, gajeye ado bajiro gotiaja ti: “Mʉ masu rujʉre mʉ mairore bajirone mʉ tʉanare maiña”, yigotiaja Dios ĩ rotimasire. Disejʉa gajeye Dios ĩ rotimasire rẽtoro ñamasuse maja —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yiyuju Dios ĩ rotimasire gotimasiorimasʉ: —To bajirone bajiaja. Riojo gotiaja mʉ. “Sĩgʉ̃ne ñaami Dios. Ĩre bajiro bajigʉ gãji magʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mani ʉjʉre Diore bʉto mairoti ñaja. No bojagʉre mani mairo rẽtoro Diore mairoti ñaja, manire. No bojase mani cʉose mani mairo rẽtoro Diore mairoti ñaja. Diore mairã ñari, mani tʉoĩase, mani yise, jediro quẽnaro yiroti ñaja”, yaja. To yicõari, “Mani masu rujʉre mani mairore bajirone jedirore maiña”, yigotiaja Dios ĩ rotimasire. Gajeye Moisére Dios ĩ roticũmasiriarore bajirone vaibʉcʉrã ecariarãre sĩacõari, Diore rʉ̃cʉbʉorã, paire mani ĩsijama, quẽnaja. Gajeye no bojase Dios ĩ rotimasiriarore bajiro paire mani ĩsijama, quẽnaja. To bajiboarine to bajiro yirã jediro mani ĩsise rẽtobʉsaro quẽnaja, Diore, to yicõari, masare quẽne mani maijama —Jesúre yiyuju Dios ĩ rotimasire gotimasiorimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","To bajiro quẽnaro ĩ yisere ajicõari, ado bajiro ĩre yiyuju Jesús: —Yʉ ĩajama, Dios yarã ĩre ĩna ajitirʉ̃nʉsere ajimasiaja mʉ. Ĩ yʉ quẽnaro ĩ yigʉ mʉ ñarʉajama, ñamasiaja mʉ —ĩre yiyuju Jesús. To bajiro Jesús ĩ yiro bero, “Mani rẽtoro masigʉ̃ ñaami” yitʉoĩacõari, “‘Ãnoama masimena ñaama’ yiromi” yirã, ĩre sẽniĩa tʉjacoasujarã yuja. “Mani rẽtoro masigʉ̃ ñaami Jesús” yitʉoĩarã ñari, ĩre sẽniĩarẽmobesujarã yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","36","Diore yirʉ̃cʉbʉoriavijʉ masare gotimasio ñagʉ̃ne, ado bajiro ĩnare sẽniĩañuju Jesús: —“‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, masʉ ñarʉcʉmi. Ʉjʉ David ñamasir'i jãnamine ñarʉcʉmi”, yama Dios ĩ rotimasire gotimasiorimasa. To bajiro ĩna yitʉoĩaboajaquẽne, Esp'iritu Santo ĩ ejarẽmose rãca yigʉ, Diore yigʉre bajiro, “yʉ ʉjʉ” yimasiñujari Ʉjʉ David ñamasir'i, ĩ jãnami ĩ ñaboajaquẽne, ado bajise ĩ yiucajama: “Yʉ ʉjʉre ado bajiro yirʉcʉmi Dios: ‘Yʉ riojojacatʉa rujiya maji. Mʉre ĩaterãre, “Rojose yitʉjaya” ĩnare yʉ yiro bero, rojose yimasibetirʉarãma yuja. To cõrone rotisʉorʉcʉja mʉ’ yirʉcʉmi Dios, yʉ ʉjʉre”, yiucamasiñumi David. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","To bajiri, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, David ñamasir'i jãnami ñarʉcʉmi” yiucamasire ti ñaboajaquẽne, ¿no yigʉ ĩ ʉjʉre bajiro bajigʉtique? —ĩnare yiyuju Jesús. To bajiro ĩ yigotisere ajivariquẽnañujarã jãjarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Masare ado bajiro ĩnare gotimasioñuju Jesús: —Dios ĩ rotimasire gotimasiorimasare bajiro bajibeja mʉama. Dios ĩ rotimasire gotimasiorimasa, sudiro yoaquẽnariase sãñacõari, masa ĩna ĩaro rĩjoro vacudi variquẽnarãma ĩna. To yicõari, jãjarã masa ĩna rẽjarũgũrijaʉrire ejarũgũrãma. Gãji ĩnare ĩ bocajama, rʉ̃cʉbʉose rãca ĩnare ĩ sẽnisere ajivariquẽnarãma. Dios ocare ĩna buerivirijʉre quẽne ñamasuri cũmurorire rujivariquẽnarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Boserʉ̃mʉri ti ñajaquẽne, ĩna barujijama, ñamasuri cũmurorire rujivariquẽnarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Manajʉa rijaveoriarã ya virire ẽmarã ñaboarine, masa ĩna ĩaro rĩjorojʉa, “‘Quẽnaro yirã ñaama’ yiĩato” yirã, “Yoaro Diore sẽnirã yaja”, yisocarũgũboarãma ĩna. To bajiro ĩna yise vaja, gãjerã rojorã, rojose ĩna tãmʉose rẽtoro rojose tãmʉorʉarãma ĩna —masare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Diore yirʉ̃cʉbʉoriavijʉ ñacõari, gãjoa sãriajʉ riore rujiyuju Jesús. Rujicõari, jãjarã masa tijʉre gãjoa ĩna sãñasere ĩañuju. Gãjoa jairã, jairo sãñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","To ĩna yiñarone, sĩgõ, manajʉ rijaveorio ejacõari, gãjoatii jʉatiine so sãsere ĩañuju. Mojoroaca vaja cʉtitiiri ñañuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tire so sãro ĩacõari, ado bajiro ĩ buerimasare gotiyuju Jesús: —Riojo mʉare gotiaja yʉ. Adio maioro bajigo, gãjerã rẽtoro sãmo so. ");
INSERT INTO bsnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gãjoa jairã ĩna sãboajaquẽne, jairo rʉyacõaroja ĩnarema. Soma, so cʉose ñaro cõroacane sãcõamo —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Diore yirʉ̃cʉbʉoriavijʉ ñar'i, budiasuju Jesús ĩ buerimasa rãca. To ĩ ũmato bajirone, ado bajiro ĩre gotiyuju ĩ buerimasʉ: —¡Gotimasiorimasʉ, ĩaña! Quẽnarivi ñaja. Gʉ̃ta quẽnase rãca quẽnaro quẽnoñuma ĩna —Jesúre ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","To ĩ yirone, ado bajiro ĩre cʉdiyuju Jesús: —Jairivi ti ñaboajaquẽne, mʉa ĩarivi ñaro cõrone cagueroca ecorʉaroja. To bajiri adi viaye gajea gʉ̃ta joere gajea jesabeticõarʉaroja —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Tijʉ bero, Olivo vãme cʉti buro joejʉ rujiyuju Jesús. Ti buro riojojʉa ñañuju Diore yirʉ̃cʉbʉoriavi. To ĩ rujirone, gãjerã ĩna mano ĩacõari, ĩ buerimasa, Pedro, Santiago, Juan, to yicõari Andrés, ado bajiro ĩre sẽniĩañujarã ĩna: —¿Divato cagueroca ecoroti Diore yirʉ̃cʉbʉoriavi? ¿No bajiro ti bajiro ĩacõari, “Jesús ejagʉagʉ yigʉmi”, yimasirãti yʉa? ¿No bajiro ti bajiro ĩacõari, “Adi macarʉcʉro jediato yaja”, yimasirãti yʉa? —Jesúre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Roori ñarʉarãja mʉa, “Socarãne, gãjerã manire yitoroma” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jãjarã yitorã ñarʉarãma, “Yʉne ñaja ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃” yirã. To bajiro ĩna yisocasere jãjarã masa ĩnare ajisʉyaboarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","To bajicõari, mʉa tʉana, to yicõari, gajeroana quẽne, gãjerã rãca ĩna gãmerã sĩasere ajirʉarãja mʉa. Tire ajicõari, güibetirʉarãja mʉa. “Bajirʉaroja” Dios ĩ yiriarore bajirone bajirʉaroja. To bajiro ĩna gãmerã yiñaboajaquẽne, adi macarʉcʉro jediro me bajirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cojo sitana gaje sitana rãca gãmerã sĩarʉarãma. Bʉto sita saberʉaroja. To yicõari, cojo maca me ñioñarʉaroja. To bajiri, rojose tãmʉosʉorʉarãma masa. Ĩna tãmʉose rẽtobʉsaro rojose tãmʉoroana yirãma yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Quẽnaro tʉoĩama mʉa: Mʉare ñejecõari, Dios ocare ĩna buerivirijʉ ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. Tojʉ mʉare bajerʉarãma. To yicõari, yʉ ocare mʉa gotimasiojare, macari ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. To yi vanane, ʉjarã ñamasurã rĩjorojʉa mʉare juaárʉarãma ĩna. To bajiro mʉare ĩna yijare, yʉ oca quẽnasere ĩnare gotirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tire adi macarʉcʉro ñarã masa ñaro cõrone gotimasiojeo ecorʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mʉare ñejecõari, ʉjarã rĩjorojʉa mʉare ĩna juaejaro, “¿No bajiro ñagõrãti yʉa?”, yitʉoĩarejaibeja mʉa. “Ñagõña” mʉare ĩna yirirĩmarone, Dios ĩ cõagʉ̃ Esp'iritu Santo ĩ ejarẽmose rãca, “Ado bajiro gotirʉarãja yʉa”, yimasirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Quẽna gajeye ado bajiro ĩnare gotirẽmoñuju Jesús: —Yʉ yere ajiterãre güiose ĩna yisere ĩarʉarãja mʉa. Sĩgʉ̃ rĩa ñaboarine, “Ĩnare sĩato” yirã, ñejerotirʉarãma ĩna. To yicõari, jacʉa quẽne, “Yʉa rĩare sĩato” yirã, ĩna rĩare ñejerotirʉarãma. Ĩna rĩajʉa quẽne, ĩna jacʉare ajijũnisinicõari, gãjerãre sĩarotirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yʉ ocare mʉa goticudijare, jediro masa mʉare ĩaterʉarãma. To bajiro ĩna yiboajaquẽne, no bojarã yʉre ajitirʉ̃nʉ tʉjamenarema, rojose tãmʉotʉjabetiriarojʉ ĩna varoti ñaboarere ĩnare yirẽtobosarʉcʉmi Dios —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Quẽna gajeye ado bajiro ĩnare gotirẽmoñuju Jesús: —Adi macarʉcʉro jedirirodo, sĩgʉ̃, “Diore rʉ̃cʉbʉobeticõato ĩna” yigʉ, Dios ĩ bojabetire yirʉcʉmi. Diore yirʉ̃cʉbʉoriavijʉ ĩ ñasere masirʉarãja mʉa. (Yʉ, Marcos, adi paperare Jesús ĩ gotisere yʉ ucasere ĩacõari, ajimasiña.) To bajiri Dios ĩ bojabetire ĩ yisere ĩacõari, “Jerusalén maca ti jedirotirʉ̃mʉ cõñaro bajiaja”, yimasirʉarãja mʉa. To bajiro bajirirʉ̃mʉ Judea sitana gʉ̃tayucʉjʉ guaro rudicoajaro ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sĩgʉ̃ ĩ ya vi joejʉ jesagʉma, rujiacõari, ĩ ya vi jubeajʉ gajeyeũni ñasere juaátĩmabetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gãji, vesejʉ moañagʉ̃, ĩ ye sudire juagʉ tudiatĩmabetirʉcʉmi, rujarĩmarone yʉ ejaroti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Rõmia macʉ sãñarã, ũjurã cʉorã quẽne, rojose tãmʉorʉarãma ĩna, ũmatĩmabetica yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Bʉto oco quedirirʉ̃mʉre bajibeticõato” yirã, Diore sẽnicõa ñarũgũña. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","To bajiro bajirirʉ̃mʉri bʉto rojose tãmʉorʉarãma masa. Adi macarʉcʉro ñasʉoriarʉ̃mʉri masa rojose ĩna tãmʉoadire rẽtoro tãmʉorʉarãma ĩna. Rojose ĩna tãmʉoro bero, to bajise rojose tãmʉobetirʉarãma yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Yoaro mebʉsane rojose tãmʉoato masa” Dios ĩ yibetijama, sĩgʉ̃ catirʉyarocʉ manibogʉmi. “Yʉ yarã ñaña mʉa” ĩ yirere cʉdiriarãre ĩamaigʉ̃ ñari, “Yoaro mebʉsane rojose tãmʉoato ĩna”, yirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","To bajiro bajiñarirodorire, “Ãnine ñaami ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i. Ejayumi” gãjerã ĩna yijama, ĩnare ajibeja mʉa. To yicõari, gãjerãjʉama, “Tone ñagʉ̃mi. Ejayuju” mʉare ĩna yijaquẽne, ĩnare ajibeja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jãjarã yitorã ñarʉarãma, “Yʉne ñaja ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃” yirã, to yicõari, “Diore gotirẽtobosarimasa ñaja yʉa” yirã. To bajiro yirã, ĩaĩañamani yiĩorʉarãma, masare yitorã. To bajiro yirʉarãma, “‘Yʉ yarã ñaña mʉa’ Dios ĩ yirere cʉdirã, manijʉare ajitirʉ̃nʉato” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tire mʉare yʉ gotimasiosere quẽnaro tʉoĩaña mʉa. Ti bajiroto rĩjoro jediro mʉare gotijeobʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tire rojose ĩna tãmʉogajanoro berone, gaje vãme rojose bajirʉaroja. Muiju ʉ̃mʉagʉ asibetirʉcʉmi yuja. Ñamiagʉ quẽne busubetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ñocoa quẽne, vẽjacoarʉarãma. To yicõari, õ vecaye jediro nʉrʉarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","To bajiro ti bajiro, Dios ĩ roticõagʉ̃ õ vecajʉ yʉ rujiadore ĩarʉarãma masa. Yʉ masise rãca, oco bueri vatoajʉ yʉ busubatorujiadire ĩarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","To cõrone, “Yʉ yarã ñaña” Dios ĩ yirere cʉdiriarãre jʉdoaga soje, jũnaga soje, varuaga soje, gajejacatʉa varuaga soje ñarã jedirore “Juarẽoato” yigʉ, ángel mesare cõarʉcʉja yʉ. To yʉ yijare, yʉ yarã ñaro cõrone juarẽorʉarãma ĩna —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","To yicõari, quẽna gajeye ado bajiro ĩnare gotirẽmoñuju Jesús: —Gotimasiore queti mʉare gotigʉ yaja yʉ. Higuera vãme cʉtiʉre tʉoĩaña mʉa. Higuera vãme cʉtiricʉ gajecu bʉcʉamʉjacõari, jũ mameaja. Tire ĩacõari, “Mojoroaca rʉyaja cʉ̃ma ti ejaroti”, yimasiaja mani, jud'io masa. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mʉare yʉ gotisere bajiro bajisere ĩacõari, “Mojoroaca rʉyaja Jesús ĩ vadiroti”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Riojo mʉare gotiaja yʉ. Adirodo ñarã mʉa bajireajediroto rĩjoro, mʉare yʉ gotirore bajirone bajirʉaroja ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adi macarʉcʉro ñaro cõrone, to yicõari, õ vecaye quẽne jedicoarʉaroja. To bajiboarine, yʉ ocama jedibeti mʉorʉ̃gõcõarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ado cõrone ejarʉcʉmi Jesús”, yimasigʉ̃ magʉ̃mi. Ángel mesa quẽne masimenama ĩna. Dios macʉ ñaboarine, “To cõro ejarʉcʉja yʉ”, yimasibeaja yʉ quẽne. Yʉ jacʉ sĩgʉ̃ne masigʉ̃mi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","—To bajiro bajiroti ti ñajare, roori ñarʉarãja mʉa, “To cõrone tudiejarʉcʉmi” yʉre yimasimena ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Quẽna yʉ tudiejaroti ado bajiro bajirʉaroja: Sĩgʉ̃ ñagʉ̃mi gaje sitajʉ varocʉ. Ĩ varoto rĩjoro, ĩre moabosarimasare jirẽogʉ̃mi. Ĩnare jirẽocõari, tocãrãcʉrene ricati ĩna moarotire ĩnare rotigʉmi. To yicõari, soje coderimasʉre quẽne, “Yʉ tudiejarotire yugʉ tocãrãcarʉ̃mʉne quẽnaro bocaĩama”, yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ĩre bajiro bajirʉcʉja yʉ quẽne. To bajiro bajiroti ti ñajare, roori ñarʉarãja mʉa, “To cõrone tudiejarʉcʉmi mani ʉjʉ” yʉre yimasimena ñari. Rãiorijʉ, ñami gʉdareco, gãjabocʉ ñagõrijʉ, busurijʉ yʉ vadirotire masibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Roori ñarʉarãja mʉa, “Mani cãniñarone tudiejaromi” yirã. Yʉre masimenare bajiro bajibeja. ");
INSERT INTO bsnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","To bajise yʉ gotijama, mʉa rĩrene gotigʉ me yaja yʉ. Masa jedirore tʉoĩacõari gotiaja yʉ. Roori ñarʉarãja mʉa —ĩ buerimasare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jʉarʉ̃mʉ rʉyayuju yuja Pascua boserʉ̃mʉ pan ũmato vauvase vʉoyamanire basʉoriarʉ̃mʉ. To bajicõari, paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne, ado bajiro gãmerã ñagõñañujarã ĩna: —Jesúre sĩarʉarã, ¿no bajiro yigʉ ñaami yitocõari, Jesúre ñiarãti mani? —gãmerã yiñagõñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—To bajiboarine, boserʉ̃mʉ ñaro ĩre mani sĩajama, tire ĩajũnisinicõari, manire rojose yiborãma masa —gãmerã yiñagõñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania vãme cʉti macajʉ cãmi boagʉ ñaboar'i, Simón vãme cʉtigʉ ya vijʉ ñañuju Jesús. Ti vijʉ Jesús ĩ barujirone, sĩgõ, gʉ̃ta sotʉ alabastro vãme cʉti rãca veariarʉ ãmiejayuju so. Sʉtiquẽnase bʉto vaja cʉtise, nardo vãme cʉtise sãñaritʉ ñañuju tirʉ, so ãmiritʉ. To bajiri, Jesús tʉaca eja, tirʉ ãmʉare vẽjeacõari ĩ rʉjoa joere ĩre yuejeoyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","To bajiro so yisere ĩacõari, jũnisiniñujarã sĩgʉ̃ri Jesús buerimasa. To bajiro yirãne, ado bajiro gãmerã yiyujarã ĩna: —¡Jairo gãjoa yireago yamo! ");
INSERT INTO bsnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tire ĩsicõari, jairo gãjoa trescientos denarios rẽtoro bʉjacõari, maioro bajirãre ejarẽmoroti ñaboaja ti —gãmerã yiyujarã ĩna. To bajiro yicõari, sore tud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","To bajiro ĩna yiboajaquẽne, Jesújʉama, ado bajiro ĩnare yiyuju: —Sore gõjanabiobesa mʉa. Tire yʉre so yuejeojama, quẽnaro yʉre yigo yamo. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Maioro bajirã mʉa rãca ñacõa ñarũgũrʉarãma. No mʉa bojarirʉ̃mʉ quẽnaro ĩnare ejarẽmomasirʉarãja mʉa. Yʉma, mʉa rãca ñacõa ñabetirʉcʉja. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adio, quẽnaro so yimasiro cõro yʉre yamo. Yʉre sʉtiquẽnase so yuejeojama, yʉre ĩna yujeroto rĩjoro yuejeo rĩjoro cʉtigo yamo. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Riojo mʉare gotiaja yʉ. Yʉ bajiroti quẽnase quetire, adi macarʉcʉroana jedirore gotibatorʉarãma masa. To bajirone bajirʉaroja sʉtiquẽnase yʉre so yuejeose queti quẽne. So yuejeosere masiritimenane tire gotibatorʉarãma —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote vãme cʉtigʉ rãca ñarã ñajediro Jesús buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñañujarã. To bajiboagʉ, paia ʉjarã ĩna ñarojʉre vasuju, Jesúre ĩnare ĩsirocarʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jesúre ĩ ĩsirocarʉasere ajivariquẽnacõari, —Gãjoa mʉre ĩsirʉarãja yʉa —ĩre yiyujarã ĩna, paia ʉjarã. To ĩna yisere ajivariquẽnacõari, tudicoasuju Judas. Jesús tʉjʉre ejacõari, “¿Dirĩmaro ũnone Jesúre ĩnare yʉ ĩsijama, josari mene ĩre ñiamasirojari ĩna?”, yitʉoĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascua boserʉ̃mʉ pan ũmato vauvase vʉoyamani basʉoriarʉ̃mʉ, to yicõari oveja macʉre ĩna sĩariarʉ̃mʉ ejayuju ti. To bajiri Jesús buerimasa ado bajiro ĩre sẽniĩañujarã ĩna: —Pascua boserʉ̃mʉ ñajare, mani barotire, ¿nojʉ bare yʉa quẽnoyusere bojati mʉ? —ĩre yisẽniĩañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","To ĩna yijare, ado bajiro ĩnare yicõañuju Jesús: —Jerusalénjʉ mʉare yʉ gotigʉ tʉre vasa mʉa. To mʉa ejarone, sĩgʉ̃, oco vagʉ mʉare bocarʉcʉmi. Ĩre sʉyaja mʉa. To bajicõari, vi ĩ sãjarone, ti vi ʉjʉre ado bajiro ĩre yiba: “Gotimasiorimasʉ, ‘¿nojʉ ñati Pascua boserʉ̃mʉ adi ñami yʉ buerimasare yʉ ũmato barotijaʉ?’ mʉre yicõami”, yiba mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","To mʉa yirone, mʉare ĩorʉcʉmi, vecaga sõa, jairisõa, mame quẽnogajanoriasõare. Tone mani barotire quẽnoyuba mʉa —ĩnare yiyuju Jesús, ĩnare varotigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","To ĩ yijare, vacoasujarã ĩna jʉarã yuja. To eja, ĩ yiriarore bajirone bajiyuju ti. To bajiri tisõajʉ ĩna barotire quẽnoyuyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","To bajiri Pascua boserʉ̃mʉaye bare bariajʉ ti ejaro, ĩ buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã ejacõari, barujiyujarã ĩna, ĩ rãca. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ĩna bañarone, ado bajiro ĩnare yiyuju Jesús: —Riojo mʉare gotiaja yʉ. Sĩgʉ̃ mʉa rãcagʉ, yʉ rãca bagʉ, yʉre ĩaterãre yʉre ĩsirocarʉcʉmi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","To ĩ yisere ajicõari, bʉto sʉtiritiyujarã ĩna. Tocãrãcʉne sʉtiritirã ñari, ado bajiro ĩre sẽniĩañujarã ĩna: —¿Yʉne ñabetiboati, mʉre ĩsirocarocʉ? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Mʉa rãcagʉ sĩgʉ̃, yʉ rãca yosebagʉ ñaami yʉre ĩsirocarocʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dios oca masa ĩna ucamasire ti gotirore bajiro rojose tãmʉorʉcʉja yʉ, Dios ĩ roticõacacʉ. To bajirocʉ yʉ ñajare, yʉre ĩaterãre yʉre ĩsirocarʉcʉmi. Yʉre ĩ ĩsirocaroti sʉorine rojose tãmʉorʉcʉja yʉ. “Masare yirẽtobosarʉcʉmi” Dios ĩ yimasire ñajare, bajirʉcʉja yʉ. To bajiboarine, yʉre ĩsirocarocʉjʉama, rojose tãmʉorʉcʉmi. Ruyuabeticõarocʉ ñaboayumi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ĩna bañarone, pan ãmicõari, “Quẽnaja”, Diore yiyuju Jesús. To yigajano, tire mʉtocõari, ĩ buerimasare ĩnare ĩsibatogʉne ado bajiro ĩnare yiyuju ĩ: —Baya mʉa. Ti ñaja yʉ rujʉ rii —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tire ĩna bagajanorone, idiriabaja ãmicõari, “Quẽnaro yaja mʉ”, Diore yiyuju quẽna. To yicõari, tibajare ĩnare ĩsiñuju. Ĩna jediro idijedicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ĩsigʉ̃ne, ado bajiro ĩnare gotiyuju Jesús: —Adi ñaja tirʉ̃mʉana “Rojose mani yirere masirioato” yirã, Diore rʉ̃cʉbʉoriajʉ joere ĩna yuejeoriarore bajiro bajise. Yucʉrema, yʉ ri'i ñaja. Ti sʉorine, “Gajerodo to bajiro mʉare yirʉcʉja yʉ” Dios ĩ yicũmasiriarore bajiro bajirʉaroja yuja. To bajicõari, jãjarã masa rojose ĩna yisere masiriocõari, tuditʉoĩabetirʉcʉmi Dios yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Riojo mʉare gotiaja yʉ. “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios yʉre ĩ cũroto rĩjoro, quẽna jʉaji ʉye oco idibetirʉcʉja yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","To ĩ yiro bero, Diore rʉ̃cʉbʉorã, basayujarã ĩna. Basagajano, Olivo vãme cʉti burojʉ vacoasujarã ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","To ĩna vatone, ado bajiro ĩnare yiyuju Jesús: —Adi ñamine yʉre ajitirʉ̃nʉ tʉjacõari, vaveorʉarãja mʉa jediro. Dios oca masa ĩna ucamasire to bajiro ti gotijare, to bajise mʉare gotiaja yʉ. Ado bajiro gotiaja ti: “Oveja coderimasʉre bajiro bajigʉre sĩarʉcʉja yʉ. To bajiri ĩ yarã ovejare bajiro bajirã rudibatecoarʉarãma”, yigotiaja Dios oca masa ĩna ucamasire, manire gotiro. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yʉre mʉa vaveoboajaquẽne, yʉre ĩna sĩaro bero, quẽna tudicaticõari, Galilea sitajʉ mʉa vato bero, yʉjʉa, mʉa rĩjoro ñatʉjarʉcʉja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","To ĩ yisere ajicõari, ado bajiro ĩre yiyuju Pedro: —Ãnoa jediro, mʉre ĩna vaveoboajaquẽne, mʉre vaveobetirʉcʉja yʉma —Jesúre ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Riojo mʉre gotiaja yʉ. Adi ñami busiyʉjʉa gãjabocʉ jʉaji ĩ ñagõroto rĩjoro, idiaji, “Jesúre masibeaja; ĩ rãcagʉ me ñaja yʉ”, yisocarʉcʉja mʉ —Pedrore ĩre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","To bajiro ĩ yisere ajicõari, ado bajiro cʉdiyuju Pedro: —Mʉ rãca yʉre ĩna sĩarʉajaquẽne, “Jesúrãcagʉ me ñaja yʉ”, yisocabetirʉcʉja yʉ —Jesúre yiyuju Pedro. To bajiro Pedro ĩ yisere ajicõari, gãjerã Jesús buerimasa quẽne, to bajiro yijedicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","To ĩna yiro bero, Getseman'i vãme cʉtojʉ ĩnare ũmato vasuju Jesús. Tojʉ ejacõari, ado bajiro ĩnare gotiyuju: —Diore sẽnigʉacʉ yaja yʉ. To yʉ vatoye, ado rujicõaña mʉa maji —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","To yigajanogʉ̃ne, Pedrore, Santiagore, to yicõari Juanre quẽne ji vasuju Jesús. To vacʉ, bʉto tʉoĩasʉtiritiyuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","To bajiro bajigʉ ñari, ado bajiro yiyuju Jesús ĩ rãca variarãre: —Bʉto tʉoĩasʉtiritiaja yʉ. Sʉtiriosene yʉre sĩaro yaja. Adone yʉre yuñaña maji. Yʉ cãnibetore bajirone cãnibeja mʉa quẽne, Diore sẽniñarã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","To yicõari, to sojʉabʉsa varẽmoñuju Jesús. Va, sita tũcurojʉ murocacũcõari, Diore sẽniñuju ĩ, “Yʉre ĩna sĩarotire yʉre matabosato ĩ” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ado bajiro Diore sẽniñuju ĩ: —Cacʉ, ñajediro yimasigʉ̃ ñaja mʉ. Yʉre ĩna sĩaroti matamasiaja mʉ. To bajiboarine, mʉ bojarore bajirone bajiato —Diore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","To yigajano, Pedro mesa ĩna cãnitoyene ĩna tʉjʉ ejayuju. Ĩnare yujiogʉne, ado bajise Pedrore ĩre yiyuju Jesús: —¿Simón, cãniati mʉ? ¿No yirã cojo hora cõro cãnibetibʉsarãne, yʉre yuñabetimasucõati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yʉ cãnibetore bajirone cãnibesa mʉa quẽne. To bajicõari, Diore sẽniña, “Vãtia ʉjʉ Satanás ĩ yirotisere yicõari, Dios ĩ bojabetire yirobe” yirã. Riojo mʉare masiaja yʉ. “Dios ĩ bojasere yirʉcʉja” yirã ñaboarine, cojojirema rojose tʉoĩarã ñari, Dios ĩ bojabetijʉare yirũgũaja mʉa —Pedro mesare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","To yicõari, gãme vacʉ, Diore ĩ sẽniriarore bajirone tudisẽniñuju ĩ quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","To yigajano, vacʉne, cãniariarãre ĩnare ejayuju quẽna. Bʉto vʉjaejarã ñari, cãniñujarã ĩna. To bajiri rĩjoro ĩnare ĩ yiriarore bajiro ĩnare ĩ sẽniĩaro, ĩre cʉdimasibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","To bajiro ĩnare yigajanocõari, Diore sẽnigʉ̃ vasuju Jesús quẽna. Diore sẽnigʉ̃ var'i, tudiejacõari, ĩnare yujioyuju: —¿No yirã cãni manicõati mʉa maji? Ado cõrone, Dios ĩ roticõacacʉre, rojose yirãre yʉre ĩsirocarocʉ vadicoagʉmi yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","To bajiri yujiya mʉa. Ĩre bocarã vajaro. Yʉre ĩsirocarocʉ vadiami yuja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","To bajiro Jesús ĩnare ĩ yiñarirĩmarone, Judas Iscariote vãme cʉtigʉ, Jesús buerimasa rãcagʉne vayuju yuja. Jãjarã ĩ rãca vayujarã jariaseri cʉorã, gãjerã yucʉ́juriri cʉorã. Paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa, to yicõari bʉcʉrã quẽne ĩna cõariarã ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jẽre ado bajiro goti vayuju Judas, ĩ rãca vanare, “‘Ĩne ñaami Jesús’ yiĩamasiato ĩna” yigʉ: —Jesúre sẽnicõari, ĩre usurʉcʉja yʉ. To yʉ yirone, ĩre ñiacõari, quẽnaro ĩre ĩatirʉ̃nʉ vaja mʉa —ĩnare yi vayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","To bajiro yir'i ñari, Jesús rĩjorojʉa ejacõari, ado bajiro ĩre yiyuju Judas: —Gotimasiorimasʉ, ¿ñati mʉ? —ĩre yigʉne, usuyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","To ĩ yirone, Jesúre ĩre ñiañujarã Judas rãca vadiriarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","To ĩna yirone, sĩgʉ̃ Jesús tʉ rʉ̃gõgʉ̃, ĩ jariase yoveaãmicõari, paia ʉjʉ ñamasugʉ̃re moabosarimasʉre gãmoro jatarocacõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","To ĩ yiro bero, ĩre ñiarã ejarãre ado bajiro yiyuju Jesús: —¿No yirã gajeyeũni juarudirimasʉre ñiarã vanare bajiro jariaseri rãca, yucʉ́juriri rãca yʉre ñiarã vadiati mʉa? Tocãrãcarʉ̃mʉne Diore yirʉ̃cʉbʉoriavijʉ mʉa ñaro mʉare gotimasio rujirũgũmʉ yʉ. To yʉ bajiboajaquẽne, yʉre ñiabetirũgũmʉ mʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Diore gotirẽtobosarimasa, ado bajiro yʉre mʉa yirotirene ucamasiñuma. To bajiri, to bajirone yʉre yaja mʉa —ĩnare yiyuju Jesús, ĩre ñiarã ejarãre. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesúre ĩna ñiasere ĩacõari, ũmarudijedicoasujarã ĩna, ĩ buerimasa jediro. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","To ĩna bajiboajaquẽne, gãji mamʉ, Jesúre ĩna ãmivatone, ĩnare sʉyasuju ĩ. Sudijãirine gũmañuju. To ĩ bajirone, ĩre ñiaboayujarã ĩna, Jesúre ãmivana. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ĩre ñiaca yirã, ĩ gũmaritore tʉ̃aveacõañujarã. To ĩna yigʉ, sudi magʉ̃ne ũmacoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesúre ñiacõari, paia ʉjʉ ñamasugʉ̃ tʉjʉ ĩre ãmiasujarã. Tojʉ rẽjacõari, ñañujarã paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa, to yicõari bʉcʉrã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesúre ĩna ãmivato, sõjʉ yayiĩasʉyayuju Pedro. Ĩnare yayiĩasʉyacõari, paia ʉjʉ ñamasugʉ̃ ya vi matariasãniro rẽtosãjacoasuju. Sãjacõari, Diore yirʉ̃cʉbʉoriavi coderimasa rãca rujiyuju ĩ, jea sũmañagʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Paia ʉjarã, to yicõari gãjerã ʉjarã, ĩna jediro Jesúre sĩarʉayujarã. To bajiro yirã ñari, “Rojose masu yigʉ ñaami Jesús” yisocaronare macañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jãjarã masa socarãne ĩna gotiboajaquẽne, ricati rĩne ĩna yise ñajare, “To bajiro ĩ yire ñajare, ĩre sĩaroti ñaja”, yimasibesujarã ĩna maji. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","To bajiboarine, sĩgʉ̃ri vʉ̃mʉrʉ̃gʉ̃cõari, ado bajiro yisocayujarã ĩna: —Ãni Jesús vãme cʉtigʉ ĩ ñagõmasisere ajibʉ yʉa. Ado bajiro yimasimi: “Diore yirʉ̃cʉbʉoriavire caguerocacõari, idiarʉ̃mʉ tʉsatirʉ̃mʉne quẽna gaje vi masa ĩna quẽnorivi mere quẽna tudibʉajeocõarʉcʉja”, yimasimi ĩ —yisocayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","To bajiro yisocarã ñaboarine, tocãrãcʉ ricati rĩne gotiboayujarã ĩna. To bajiro ĩna yise ñajare, “Ĩ ye sʉorine rojose tãmʉorʉcʉmi”, Jesúre yimasibesujarã ĩna maji. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","To bajiro ĩna yisocaboajaquẽne, paia ʉjʉ ñamasugʉ̃, vʉ̃mʉrʉ̃gʉ̃cõari, ado bajiro Jesúre yiyuju: —To bajiro mʉre ĩna yi ocasãsere ¿no bajiro yati mʉ? ¿Cʉdibeati mʉ? —Jesúre ĩre yiboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","To ĩ yiboajaquẽne, cojo vãme cʉdibeticõañuju. Ĩ cʉdibetire ĩacõari, ado bajiro Jesúre sẽniĩañuju paia ʉjʉ ñamasugʉ̃ quẽna: —¿“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'ine, Dios macʉne ñati mʉ? —Jesúre yisẽniĩañuju paia ʉjʉ ñamasugʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Ĩne ñaja yʉ. To bajiri, Dios ĩ roticõacacʉ ñari, ĩ riojojacatʉa rujicõari, masare besegʉagʉ, oco bueri vatoajʉ yʉ rujiadire ĩarʉarãja mʉa —paia ʉjʉ ñamasugʉ̃re yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","To ĩ yirone, “Jesús ĩ yisere ajiteaja” yigʉ, ĩ sudire tʉ̃avoyuju paia ʉjʉ ñamasugʉ̃. To yigʉne, ado bajiro ĩ rãcanare yiyuju ĩ: —¡“Diore bajiro bajigʉ ñaja yʉ” yigʉ yami! No yirã gãjerã, “Rojose yigʉ ñaami” yironare macarẽmomenaja mani yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mʉa quẽne Diore rʉ̃cʉbʉobecʉ ĩ yisere ajiaja mʉa. To bajiro ĩ yise ajicõari, ¿no bajiro ĩre yiroti ñati? —ĩ rãcanare yiyuju paia ʉjʉ ñamasugʉ̃. To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyujarã: —Rojose masu yicõami. Ĩre sĩacõaroti ñaja —yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","To yicõari, sĩgʉ̃ri, Jesúre gooco eoreatuyujarã ĩna. To yicõari, ĩ cajere siabibecõari, ĩre jayujarã. To yicõari, —“‘Ĩ, mʉre jaami’ yʉre yigotiami Dios”, yʉare yiya mʉ —ĩre yiajatud'iyujarã ĩna. Diore yirʉ̃cʉbʉoriavi coderimasa quẽne, ĩre jayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Vi jubeajʉ Jesúre rojose ĩna yiñarone, macajʉ́jʉa ñacõañuju Pedro. To ĩ ñarone, sĩgõ, paia ʉjʉ ñamasugʉ̃re moabosarimaso, ejayuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro ĩ jea sũmañaro ĩre ĩacõari, ado bajiro ĩre yiyuju so: —Jesús, Nazaret macagʉ rãca vacudir'i ñagʉ̃ja mʉ quẽne —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","To bajiro so yisere ajicõari, ado bajiro yiyuju Pedro: —“Riojo yaja mʉ”, mʉre yimasibeaja yʉ. Mʉre ajimasibeaja —sore yiyuju Pedro. To bajiro yicõari, matariasãniro sãjariasoje tʉ vasuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","To ĩ ñasere ĩacõari, quẽna soje tʉ ñarãre ado bajiro gotiyuju so, moabosarimaso: —Ãni, Jesúrãca vacudir'i ñaami —yiyuju, ĩnare gotigo. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","To bajiro ĩnare so yisere ajicõari, quẽna, —Ĩre masibeaja yʉ —yiyuju Pedro. To so yiro bero, to ñarã ado bajiro Pedrore yiyujarã ĩna: —Riojo yaja. Jesúrãca vacudirũgũgʉ̃ne ñaja mʉ quẽne. Mʉ quẽne Galilea sitagʉ ñaja mʉ —Pedrore yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","To bajiro ĩna yisere ajicõari, ado bajiro cʉdiyuju Pedro: —Ĩre masibeaja yʉ. Socʉ me yaja yʉ. Socabetimasucõaja. Dios, yʉre ajigʉmi —ĩnare yicʉdiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","To bajiro ĩ yigajanorirĩmarone, gãjabocʉ jʉaji ñagõcõañuju yuja. Ĩ ñagõsere ajicõari, Jesús ado bajiro ĩre ĩ gotirere masibʉjayuju Pedro yuja: “Gãjabocʉ jʉaji ĩ ñagõroto rĩjoro idiaji, ‘Jesúre masibeaja yʉ’ yirʉcʉja mʉ” ĩre ĩ yirere masibʉjayuju. Tire masibʉjacõari, bʉto otiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Busurocacũse rãca bʉcʉrã, paia ʉjarã, to yicõari Dios ĩ rotimasire gotimasiorimasa quẽne, ʉjarã ñajediro tudirẽjañujarã ĩna. To bajicõari, Jesús ãmorire siacõari, ĩre ãmiasujarã ĩna, Pilato vãme cʉtigʉ ya vijʉ vana. To bajiri ĩ ya vijʉ Jesúre ãmiejayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jesúre ĩna ãmiejarone, ado bajiro ĩre sẽniĩañuju Pilato: —¿Mʉne ñati jud'io masa ʉjʉ? —ĩre yiyuju Pilato. To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Mʉ yirore bajirone bajiaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","To ĩ yirone, paia ʉjarã, —Cojo vãme me rojose yigʉ ñaami. Ado bajise rojose yimi —Pilatore yi ocasãñujarã paia ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","To bajiro Jesúre ĩna yi ocasãsere ajicõari, ado bajiro Jesúre sẽniĩañuju Pilato: —¿No yigʉ cʉdibeati mʉ? ¿Cojo vãme me, rojose mʉre ĩna yisere ajibeati mʉ? —Jesúre yiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","To bajiro ĩre ĩ yisẽniĩaboajaquẽne, ĩre cʉdibeticõañuju Jesús. Ĩ cʉdibetire ĩacõari, no yimasibesuju Pilato, ĩre bajiro bajigʉre ĩabetirũgũr'i ñari. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tocãrãca cʉ̃ma Pascua boserʉ̃mʉ jud'io masa ĩna quẽnojama, sĩgʉ̃ tubibe ecor'ire ĩna burotigʉre ĩnare bubosarũgũñuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tubiberiavijʉ ñarã, “Gobierno ĩ rotiboasere cʉdibeticõari, mani masu rotirãsa” yirã rãcagʉ ñañuju Barrabás vãme cʉtigʉ. Ĩ babarã rãca rojose yicõari, masare sĩañuju ĩ. To bajiro ĩ yire vaja tubiberiavijʉ ñañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","To bajiri jãjarã masa Pilato tʉjʉ ejacõari, ado bajiro ĩre sẽniñujarã ĩna: —Yʉare mʉ yibosarũgũcatore bajiro yiya quẽna —ĩre yisẽniñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare sẽniĩañuju Pilato: —¿Ñimʉjʉare yʉ busere bojati mʉa? ¿Jud'io masa ʉjʉre yʉ busere bojatique mʉa? —ĩnare yisẽniĩañuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","“Jesúre ĩajũnisinirã ñari, yʉ tʉ ãmiejama” yitʉoĩagʉ̃ ñari, ĩre burʉ, to bajiro yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","To bajiro ĩ yiboajaquẽne, masare to rẽjarãre rĩjorojʉne ĩnare ocasãcõañujarã paia ʉjarã, “Barrabájʉare burotito mani” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","To bajiri Barrabáre ĩna burotijare, quẽna ĩnare tudisẽniĩañuju Pilato: —To yijama, ¿no bajiro yigʉti yʉ, Jesúre, “Jud'io masa ʉjʉ ñaami” mʉa yigʉjʉarema? —ĩnare yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","To ĩ yirone, ado bajiro ĩre avasãcʉdiyujarã: —Yucʉ́tẽrojʉ ĩre jajusĩaroticõaña mʉ —ĩre yiyujarã ĩna, Pilatore. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","To ĩna yijare, ado bajiro ĩnare sẽniĩañuju Pilato: —¿Ñie rojose ĩ yire sʉori ĩre sĩarotigʉti yʉ? —ĩnare yiyuju Pilato. To ĩ yiboajaquẽne, quẽna bʉtobʉsa tudiavasãñujarã ĩna: —Yucʉ́tẽrojʉ ĩre jajusĩaroticõaña —yiavasãñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","To bajiro ĩna yijare, masa to rẽjarã ĩna bojarore bajiro yirʉagʉ ñari, Barrabáre bucõañuju Pilato. Jesújʉarema, ĩ surarare ĩsiñuju, “Ĩre bajecõari, yucʉ́tẽrojʉ jajusĩato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","To bajiri ĩna ya vijʉ, Jesúre ãmiejayujarã surara mesa. Ĩre ãmiejacõari, ĩna jediro ĩre gãnibiarʉ̃gʉ̃ñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","To yicõari, “Ʉjʉre bajigʉ ñato” yirã, ʉjarã ĩna sãñarito ũnore, sũarivʉjorore Jesúre sãñujarã. To yicõari, ĩ rʉjoa joere jotabedo ĩna suariabedone ĩre jeoyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","To bajiro ĩre yicõari, ado bajiro ĩre yiajatud'iyujarã: —Jud'io masa ʉjʉre mʉre quẽnarotiaja yʉa yuja —Jesúre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","To yicõari, yucʉ́ rãca ĩ rʉjoare jayujarã. Ĩre jacõari, gooco ĩre eoreatuyujarã ĩna. To yicõari, “Mʉre rʉ̃cʉbʉoaja” yiajatud'irã, ĩ rĩjorojʉa gʉsomuniari tuetuyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","To bajiro ĩre yigajanocõari, ʉjarã ĩna sãñarito ũnore ĩna sãriarore ĩre veayujarã ĩna quẽna. To yicõari, ĩ sudijʉa ĩre sãñujarã quẽna. Ĩre sudi sãgajanocõari, yucʉ́tẽrojʉ ĩre jajusĩaroana, ĩre ãmiasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ĩre ãmivanane, sĩgʉ̃ Cirene vãme cʉti sitagʉ, Simón vãme cʉtigʉre, Alejandro, to yicõari, Rufo, ĩna jacʉre bocayujarã. Ĩre bocacõari, —Jesús ĩ gaja vatijãire ĩre gajabosaya —ĩre yi vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","To yi vanane, Gólgota vãme cʉti burojʉ ejayujarã ĩna. “Rʉjoco Buro” yire ũni ñañuju “Gólgota” yire. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tojʉ ejacõari, ʉye ocore, mirra vãme cʉtise rãca vʉocõari, Jesúre ĩre ioyujarã ĩna. “Ĩre jũnise jũni ruyubeticõato” yirã, yiboayujarã. Idibesuju Jesújʉama. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","To yicõari, yucʉ́tẽrojʉ Jesúre jajutuyujarã ĩna. To yicõari, Jesús ye sudire bojarã, ado bajiro yiyujarã: —Ñimʉjʉa ãni sudi ĩ ʉjaro ĩaĩarãsa mani —yiajeyujarã, gʉ̃tarine reacũĩañarãne. To bajiro yiajecõari, ĩ ye sudi gãmerã ĩsibatoyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Muiju asitutuatijʉ ĩre jajutuyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesús ĩ tuyaritẽrojʉre ĩ rʉjoa vecare ucaturiajʉ tuyayuju. “Ado bajiro ĩ yise sʉorine jaju ecoami”, yiĩorijʉ ñañuju. Ado bajise gotiyuju: “Ãni ñaami jud'io masa ʉjʉ”, yigotiyuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesúrãca jʉarã, jaju ecoyujarã ĩna. Gajeyeũni juarudirimasa ñañujarã. Sĩgʉ̃re Jesús riojojacatʉare, gãjirema ĩ gãcojacatʉajʉare jajutuyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","To bajiro Jesúre yiyujarã, Dios oca masa ĩna ucamasire, “ ‘Rojorã rãcagʉ ñaami’ ĩre yiĩarʉarãma masa”, Jesúre yimasire ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Masa rẽtoana, ĩna rʉjoari yure, yure yiyujarã, “Jaju ecor'ire ĩre ĩateaja” yirã. To yicõari, ĩre ajatud'iyujarã ĩna: —“Diore yirʉ̃cʉbʉoriavire caguerocamasiaja yʉ. To yicõari, idiarʉ̃mʉ tʉsatirʉ̃mʉne bʉajeocõamasiaja”, yiboacajʉ mʉ. Socʉ me mʉ yijama, mʉ yimasise rãca mʉ masune yucʉ́tẽrojʉre rujicoaya —Jesúre ĩre yiajatud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne, to bajirone Jesúre yiajatud'i ñañujarã ĩna. Ado bajiro yiyujarã: —Gãjerãrema catiogʉ ñaboarine, ĩ masu rojose ĩ tãmʉoserema yirẽtomasibeami —yiajatud'i ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃, Israel ñamasir'i jãnerabatia mani ʉjʉ ñaami. To bajiri yucʉ́tẽrojʉre rujicoadiato. To bajiro ĩ bajiro ĩacõari, “Ĩne ñaami”, yimasirʉarãja —yiajatud'iyujarã. Jʉarã Jesúrãca yucʉ́tẽrojʉ jaju ecoriarã quẽne, to bajirone Jesúre yitud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ʉ̃mʉrecaji ñarone, rẽtiacoasuju yuja. Idia hora rẽtiañañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To cõro ti rẽtiatʉsatone, jud'io masa ye rãca ado bajiro tutuaro avasãñuju Jesús: —Eloi, Eloi, ¿lema sabactani? —yiavasãñuju. (“Dios, yʉ jacʉ, ¿no yigʉ yʉre cãmotadiati mʉ?” yire ũni ñañuju ti.) ");
INSERT INTO bsnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sĩgʉ̃ri tojʉ ñarã, to bajiro ĩ yiavasãsere ajicõari, ado bajiro yiyujarã ĩna: —¡Ajiya mʉa! Diore gotirẽtobosarimasʉ El'ias ñamasir'ire jigʉ yami —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","To bajiro Jesús ĩ yiavasãrone, sĩgʉ̃, Jesús tʉ ũmaejacõari, ʉye oco jiarere ñiabiacõari, yucʉ́ gajajʉ siatucõari, Jesús rise tʉjʉre ñumʉotuyuju. To yigʉne, ado bajiro ĩ rãcanare yiyuju ĩ: —Ñagõbesa mʉa maji. El'ias ñamasir'i ãnire ĩ rujiosere ĩato mani —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tutuaro avasãtʉsa, ʉsʉtadicoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tirĩmarone, Diore yirʉ̃cʉbʉoriavi yotoria gasero vorujijedicoasuju ti. “‘Dios ĩ ñarisõa’ vãme cʉti sõare sãjamasibeama masa” yirã, ĩna yotoria gasero ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesús ĩ ʉsʉtadiro, ĩ rĩjorojʉa ĩarʉ̃gõñuju surara ʉjʉ. To bajiri Jesús ĩ ʉsʉtadisere ĩacõari, ado bajiro yiyuju ĩ: —Socabesumi. Dios macʉne ñaboayumi ãni —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Galilea sitajʉ Jesúre sʉyavadiriarã rõmiri quẽne sõjʉ ĩarʉ̃gõñujarã. Ĩna ñañujarã ĩ ejarẽmoriarã. Ĩna rãca ñañuju Mar'ia Magdalena. Gajeo Mar'ia vãme cʉtigo quẽne ñañuju. Sone ñañuju Santiago Mojogʉ̃ ĩna yigʉ, to yicõari, José vãme cʉtigʉ jaco. Gajeo, Salomé vãme cʉtigo quẽne ñañuju. Gãjerã jãjarã ñañujarã Jesúre sʉyavadiriarã rõmiri, Jerusalénjʉ ĩ rijarere ĩariarã. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Arimatea macagʉ, José vãme cʉtigʉ quẽne, ñañuju. Jud'io masa ʉjarã rãcagʉ, masa ĩna ĩarʉ̃cʉbʉogʉ, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, Jesúre yitʉoĩagʉ̃ ñañuju. Tirʉ̃mʉjʉama jud'io masa ĩna ʉsʉsãjariarʉ̃mʉ rĩjoroagarʉ̃mʉ rãiorotirʉ̃mʉ rĩjoroaca ñañuju. To bajiri José, Jesús ĩ rijatore ĩacõari, “Jesúre rʉ̃cʉbʉogʉ ñaja yʉ” yitʉoĩatutuacõari, Pilatore sẽnigʉ̃ vasuju, Jesús rujʉrire ãmirʉ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatojʉa, José ĩ sẽnisere ajicõari, “¿Socabeati? ¿Jẽre rijacoasujari ĩ?”, yitʉoĩañuju. To yigʉ ñari, surara ʉjʉre jiyuju. To bajiri ĩ ejarone, —¿Rijamasucoati Jesús vãme cʉtigʉ? —ĩre sẽniĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","To ĩ yisere ajicõari, —Jẽre rijacoami —ĩre yicʉdiyuju ĩ, surara ʉjʉ. To ĩ yirone, José ĩ sẽnirore bajirone ĩre cʉdiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","To ĩ yir'i ñari, sudijãiri botiquẽnarijãiri rãca Jesúre ĩ gũmarotijãirire vaja yicõari, ĩ rujʉrire rujiogʉ vasuju. Ĩre rujiocõari, ĩre gũmañuju, tijãiri rãca. To yigajanocõari, masa yujeriavi gʉ̃tavi mame ĩ quẽnorotiriavijʉ ĩ rujʉrire cũñuju. To yicõari, ti vi sojere gʉ̃tane tũnuobibecũ vacoasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mar'ia Magdalena, to yicõari gajeo Mar'ia, José vãme cʉtigʉ jaco quẽne, Jesús rujʉrire José ĩ cũro ĩañañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ʉsʉsãjariarʉ̃mʉ ti jediro, quẽna moasʉoriarʉ̃mʉ jẽjʉaca Mar'ia Magdalena, gajeo Mar'ia, Santiago jaco, to yicõari Salomé vãme cʉtigo quẽne, sʉtiquẽnase vaja yiyujarã ĩna, “Jesús rujʉre turãsa mani” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","To yicõari, muiju ĩ busumʉjado, Jesús rujʉrire ĩna yujeriavire ĩarã vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Vanane, —¿Ñimʉ ñarojari, yujeriavi gʉ̃ta ĩna biberiare manire tũnuogobosarocʉ? —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ejacõari, ĩna ĩajama, gʉ̃ta tũnuo bibeboariaro mañuju. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jairicaro ñañuju. To bajiri ti vi sãjacõari, sĩgʉ̃ ángel ĩ rujisere ĩañujarã ĩna. Sudiro botiriase yoariase sãñacõari rujiyuju riojojacatʉajʉare. Bʉto güiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","To ĩna bajirone, ado bajiro ĩnare yiyuju ĩ: —Güibesa mʉa. Jesús Nazaret macagʉre, yucʉ́tẽrojʉ ĩna jajusĩamasigʉ̃re mʉa macasere masiaja yʉ. Maami adojʉre. Tudicaticoami. Ĩre ĩna cũmasirijʉre ĩaña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vasa mʉa. Ĩ buerimasare ado bajiro ĩnare gotiaya: “Mani rĩjoro Galilea sitajʉ varocʉ ñañuju. Tojʉ ĩre tudiĩarʉarãja mani, ĩ goticatore bajirone”, ĩnare yigotiaya mʉa —ĩnare yigotiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","To ĩ yisere ajicõari, Jesúre ĩna yujeboariavijʉ budicõari, güirã ñari bʉto nanañujarã. To bajicõari, gãjerãre gotimenane ũmacoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tirʉ̃mʉ, Jesús ĩ tudicatiriarʉ̃mʉ, ti semana ñasʉorirʉ̃mʉ ñañuju ti. Busurijʉ jẽjʉ quẽna tudicaticõari, Mar'ia Magdalenare rĩjoro ruyuaĩoñuju ĩ. Cojomo cõro gaje ãmo jʉa jẽnituarirãcʉ so ʉsʉjʉ sãñariarãre vãtiare ĩ bureario ñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús ĩ tudicatisere ĩacõari, ĩ buerimasare ĩre tʉoĩasʉtiriti otirãre gotigo vasuju so. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ĩna tʉ ejacõari ado bajiro yiyuju so: —Quẽna catiami Jesús. Ĩre ĩamʉ yʉ —ĩnare yiboayuju so. So gotisere ajiboarine, “Riojo gotiamo”, yibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bero, ĩ buerimasa jʉarã Jerusalénjʉ budicõari ĩna vacudirone, ĩnare ruyuaĩoñuju Jesús quẽna. Gãjire bajigʉ ñacõari, ĩnare ruyuaĩoñuju. To bajiri, ĩre ĩamasibesujarã ĩna maji. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","“Jesús ñaami” yiĩamasicõari, tudiasujarã ĩna, gãjerã ĩ buerimasare gotirã vana. Ĩna gotiboajaquẽne, “Riojo gotiama”, yibesujarã ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","To yiro bero, cojorʉ̃mʉ ĩ buerimasa jʉaãmo cõro, gʉbo coja jẽnituarirãcʉ ñarã ĩna barujirone, ĩnare ruyuaĩoñuju Jesús quẽna. Ĩnare ruyuaĩocõari, ado bajiro ĩnare gotiyuju Jesús: —Yʉ tudicatiro bero, gãjerãre yʉ ruyuaĩosere ĩacõari, mʉare ĩna gotiboasere, “Riojo gotiama”, yitʉoĩabejʉ mʉa. “Jẽre masiaja” yirãre bajiro tʉoĩaboabʉ mʉa. Tʉoĩavasoarʉabejʉ mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","To bajiro yicõari, quẽna ado bajiro ĩnare rotiyuju Jesús: —Masa jedirore yʉ ocare ĩnare goticudirʉarãja mʉa, “Ajitirʉ̃nʉato” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","No bojagʉre, yʉ ocare ajitirʉ̃nʉcõari, oco rãca bautizarotigʉre, “Rojose maja” ĩre yiĩacõari, rojose tãmʉotʉjabetiriarojʉ ĩ vaborotire ĩre yirẽtobosarʉcʉja yʉ. To bajiboarine, no bojagʉ yʉ ocare ajitirʉ̃nʉbecʉrema, rojose ñacõarʉaroja ĩre. To bajiri rojose tãmʉotʉjabetiriarojʉ varʉcʉmi ĩ ũgʉ̃ma —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Yʉre ajitirʉ̃nʉrã, ado bajiro yirʉarãma ĩna: Yʉre ajitirʉ̃nʉrã ñari, yʉ masise sʉorine masa ʉsʉrijʉ sãñarãre vãtiare burearʉarãma. To yicõari, ĩna masibeti oca ñaboaserene ñagõrʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ãñare ĩna ñiaboajaquẽne, to yicõari, oco jũnise vʉore ĩna idiboajaquẽne, no bajibetoja ĩnare. Diore sẽnicõari, rijarãre ãmo ñujeorʉarãma. To ĩna yirone, caticoarʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","To ĩ gotiro bero, Dios ĩ ñarojʉ mani ʉjʉ Jesúre ãmimʉja vasuju Dios. Ĩre ãmimʉja ejacõari, riojojacatʉajʉare ĩre rojoyuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","To ĩ mʉjaro bero, masa ñajedirore Dios oca goticudirã vasujarã ĩna Jesús ĩ buerimasa yuja. To bajiro ĩna goticudisere ĩacõari, mani ʉjʉ Jesús ĩnare ejarẽmoñuju, “Ĩnare quẽnaro ajitirʉ̃nʉato” yigʉ. To bajiri ĩ ejarẽmose rãca ĩaĩañamani masare yiĩoñujarã ĩna quẽne. To cõrone ñaja.");
INSERT INTO bsnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teófilo, ¿ñaboati mʉ? Jesús ĩ bajire queti mʉre ucabosagʉ yaja yʉ. Jãjarã masa Jesús ĩ bajire quetire ucayuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesús buerã, yʉare ĩna goticatore bajirone ucayuma. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","To bajiri, yʉ quẽne, ti queti jedirore quẽnaro buecõari, tire mʉre ucabosagʉ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","“Ti quetire quẽnaro masijeocõato” yigʉ, mʉre ucabosaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea sitana ʉjʉ, Herodes vãme cʉtigʉ ĩ ñarirodo ñañujarã Zacar'ias, ĩ manajo Isabel vãme cʉtigo rãca. Zacar'ias, Ab'ias ñamasir'i jãnami ñari, pai ñañuju ĩ. Ĩ manajo quẽne pai, Aarón ñamasir'i jãneño ñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dios ĩ ĩajama, quẽnarã ñañañujarã ĩna jʉarãjʉne. Ĩ rotirore bajirone yiyujarã ĩna. Masa quẽne, “Rojose yirã ñaama ĩna”, ĩnare yimasibesujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Rĩa mana rĩne bʉcʉrã ñacoasujarã ĩna. Bʉto rĩa cʉtirʉarũgũboayujarã, bajirãjʉma. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Cojorʉ̃mʉ Diore yirʉ̃cʉbʉoriavijʉ moañañuju Zacar'ias, ĩ yarã rãca. Ĩna yirũgũriarore bajiro yiyujarã: “Ñimʉjʉa ‘Dios ĩ ñarisõa’ vãme cʉti sõajʉ ĩ sãjaro ĩaĩarãsa mani” yirã, reacũĩañujarã, gʉ̃tarine. To yigajanocõari, “Zacar'ias ñaami, tisõajʉ sãjarocʉ” yimasicõari, ĩre sãjarotiyujarã ĩna. —Quẽnase sʉtisere bueaya mʉ —ĩre yiyujarã ĩna. To bajiri, tisõajʉ sãjaejacõari, bueyuju ĩ, Zacar'ias. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tire ĩ buetoyene, macajʉ́jʉ ñacõari, jãjarã masa Diore sẽniñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","To bajiri quẽnase sʉtise ĩ bueñarone, ĩ bueñaricasabo riojojacatʉajʉare ruyuarʉ̃gʉ̃ñuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","To ĩ bajirone ĩre ĩaʉcacoasuju Zacar'ias. To bajicõari, bʉto ĩre güiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","To ĩ bajirone, ado bajiro ĩre gotiyuju ángel: —Yʉre güibesa mʉ. Dios ĩre mʉ sẽnirũgũsere mʉre ajiami. To bajiri, ado bajiro mʉre yicõami: “Macʉ cʉtirʉocomo so, ĩ manajo. Juan ĩre vãme yato”, mʉre yimi Dios —ĩre yigotiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","To yigajano, ado bajiro ĩre gotirũtuasuju, Zacar'iare, ĩ macʉ ñarocʉ ĩ bajirotire gotigʉ: —Mʉ macʉ ñarocʉre Juanre ĩre ĩacõari, “Yʉre quẽnaro rʉ̃cʉbʉoami”, yirʉcʉmi Dios. Ado bajiro bajirʉcʉmi mʉ macʉ: Ĩ jacore sãñagʉ̃jʉrene, Esp'iritu Santore cõarʉcʉmi Dios, Esp'iritu Santo ĩ ejarẽmose rãca tʉoĩacõari, Dios ĩ bojarore bajiro Juan ĩ yirũgũrotire yigʉ. Masa rojose ĩna tãmʉoborotire ĩnare yirẽtobosacõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ, Cristo ĩ ruyuaroto rĩjoro ruyuarʉcʉmi mʉ macʉ. Idire mecʉosere, to yicõari, vinore quẽne idibetirʉcʉmi. Ĩ sʉorine jãjarã Dios ĩ bojarore bajiro tuditʉoĩarʉarãma Israel ñamasir'i jãnerabatia. Diore gotirẽtobosamasir'i El'ias vãme cʉtimasir'ire bajiro masare güitʉoĩabecʉne gotimasiorʉcʉmi. Jacʉa ĩna rĩare “Tudimaiato ĩna” yigʉ, gotirʉcʉmi. Diore ajimena, “Tʉoĩavasoato ĩna” yigʉ, to yicõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉre Cristore yurã, quẽnase ĩna tʉoĩavasoarotire yigʉ, to bajiro yirʉcʉmi. To bajiro yirocʉ ĩ ñajare, ĩ ruyuaro bʉto variquẽnarʉcʉja mʉ. Jãjarã masa bʉto variquẽnarʉarãma, bʉcʉacʉ to bajiro ĩ gotisere ajicõari —Zacar'iare ĩre yigotiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","To ĩ yirone, ado bajiro ĩre yicʉdiyuju Zacar'ias: —¿No bajiro mʉ yisere ĩacõari, “Riojo yami”, mʉre yimasirʉcʉada yʉ? Rĩa mana bajiaja yʉa. Jẽre bʉcʉo ñaamo yʉ manajo. Yʉ quẽne bʉcʉ ñaja yʉ —ĩre yiyuju, ángeljʉare. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","To bajiro ĩ yijare, ado bajiro ĩre gotiyuju ángel: —Diorãcagʉ ñaja yʉ, Gabriel vãme cʉtigʉ. “Quẽnase queti gotiaya” yigʉ, yʉre cõami. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","To bajiri mʉre yʉ gotirore bajiro bajirʉaroja. Adire yʉ gotisere quẽnaro ajiya mʉ: Yʉ gotisere “Bajibetoja” mʉ yitʉoĩajama, ñagõbecʉ ñacoarʉcʉja mʉ. Mʉ macʉ ĩ ruyuaro bero tudiñagõcoarʉcʉja mʉ, bajigʉjʉma —Zacar'iare ĩre yigotiyuju, ángel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","To ĩna gãmerã yiñaro ũnone, macajʉ́jʉ Zacar'iare yucõa ñañujarã ĩna. Yubʉsaboana, “¿No yigʉ to cõro yoaro bajiati?”, yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","To ĩna yiñarone, budicoayuju ĩ yuja. Ĩna tʉjʉre budiejacõari ĩnare gotimasibesuju, ñagõmasibecʉ ñari. To ĩ bajisere ĩacõari, “Diore yirʉ̃cʉbʉoriavijʉ Dios ĩ ruyuaĩosere ĩar'i ñari, bajiami”, yimasicõañujarã ĩna. Ĩnare gotimasibeticõa tʉjasuju ĩ. To bajiro bajigʉ ñari, ĩ ãmorine ĩ bajirere ĩnare gotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Diore yirʉ̃cʉbʉoriavijʉ ĩ moarũgũrere moagajanocõari, ĩ ya vijʉ tudicoasuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","To ĩ baji tudiejato bero, gʉda ñacoasuju so, ĩ manajo, Isabel vãme cʉtigo. To bajiri cojomocãrãcʉ muijua cõro vi budibeco bajiñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","To bajiñagõne, ado bajiro yitʉoĩañuju so: “Rĩa manicoadicajʉ yʉ. To bajiri bʉto bojonerũgũcajʉ yʉ. Yucʉrema Dios yʉre ĩamaicõari, quẽnaro ĩ yijare, gʉda ñaja yʉ yuja”, yitʉoĩa variquẽnarũgũñuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel vãme cʉtigo cojomo cõro, coja jẽnituarirãcʉ muijua, gʉda so ñatʉsato, quẽna gaje queti ĩre gotirotiyuju Dios, ángel Gabriel vãme cʉtigʉre. Galilea sita, Nazaret vãme cʉti macajʉ ĩre cõañuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tojʉ ñañuju so, Jesús jaco ñaroco, Mar'ia vãme cʉtigo. Mamo, ʉ̃mʉa rãca ñabeco ñañuju so. Ʉjʉ David ñamasir'i jãnami, José vãme cʉtigʉ manajoroco ñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","To bajiri Gabriel, so tʉ ejacõari, ado bajiro sore yiyuju: —¿Ñaboati mʉ? Gãjerã rõmia rẽtoro quẽnaro mʉre yigʉ ñari, quẽnaro mʉre codeami Dios —Mar'iare yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","To ĩ yirone, tire ajicõari, bʉto tʉoĩarejaiyuju so: “¿No yigʉ to bajise yʉre yati ĩ?”, yitʉoĩarejaiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","To bajise so yitʉoĩarone ado bajise sore gotiyuju ĩ, Gabriel: —Yʉ gotisere tʉoĩarejaibesa mʉ. Bʉto mʉre maiami Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yʉ gotisere quẽnaro ajiya. Gʉda ñarʉocoja mʉ. To bajicõari, macʉ cʉtirʉocoja mʉ. Macʉ cʉticõari, Jesús ĩre vãme yirʉocoja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Masigʉ̃ ñarʉcʉmi mʉ macʉ. Mʉ macʉre, “Yʉ macʉ ñaami”, ĩre yirʉcʉmi Dios. Ĩ ñicʉ, David vãme cʉticacʉ, “Israel ñacacʉ jãnerabatia ʉjʉ ñaña mʉ” yigʉ, ʉjʉ ĩre cũcami Dios. Ĩre ĩ cũcatore bajirone mʉ macʉre quẽne ʉjʉ ĩre cũrʉcʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","To bajiri Israel vãme cʉticacʉ jãnerabatiare rotimʉorʉ̃gõrʉcʉmi mʉ macʉ. Ĩ rotise jedibetirʉaroja ti —Mar'iare sore yigotiyuju ĩ ángel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","To ĩ yisere ajicõari, ado bajiro ĩre sẽniĩañuju so: —Ʉ̃mʉa rãca yʉ ñabetiboajaquẽne, ¿no bajiro yʉre bajiroti ti? —ĩre yisẽniĩañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","To so yisẽniĩarone, ado bajise sore yigotiyuju ĩ: —Dios ĩ rotise rãca gʉda ñarʉocoja mʉ. Esp'iritu Santore mʉ tʉjʉ ĩre cõarʉcʉmi. To bajiri mʉre ejacõari, mʉre macʉ yirʉcʉmi ĩ. To bajiro mʉre ĩ yijare, mʉ macʉ ñarocʉre, “Quẽnagʉ̃, quẽnaro yigʉ, Dios macʉ ñaami”, ĩre yimasirʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mʉ yo Isabel vãme cʉtigo quẽne bʉcʉo ñaboarine, macʉ sãñagõ ñaamo so. Cojomo cõro coja jẽnituarirãcʉ muijua jẽre gʉda ñatʉsajamo so, rĩa magõ ĩna yiboacacone. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios quẽnaro sore ĩ yijare, bajiamo so. Disejʉane Diorema josase maja. Ĩ yimasise rĩne ñacõaja. To bajiri bajiamo. Mʉ quẽne, to bajirone bajirʉocoja mʉ —Mar'iare yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","To ĩ yisere ajicõari, ado bajiro yiyuju so: —Dios ĩ rotirore bajirone yirʉocoja yʉ. To mʉ yirore bajirone yʉre yato Dios —yiyuju so, Mar'ia, ángeljʉare. To so yiro bero, vacoasuju ĩ, ángel Gabriel vãme cʉtigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tijʉ bero, gajeyeũni quẽnosãjeo, guaro vacoasuju so, Judea sita bʉto buri jairojʉ, Isabelre ĩagoaco. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tojʉ ejacõari, Zacar'ias ya vijʉ sãjaejacõari, ĩ manajore sẽniĩañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","To so yiro ajicõari, so gʉdajoa sãñagʉ̃ sũca yuguiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","43","To ĩ yirone, Esp'iritu Santo ĩ ejarẽmose rãca tʉoĩacõari, ado bajiro Mar'iare gotiyuju Isabel: —Yʉ ʉjʉ jaco ñaroco ejaja mʉ. Bʉto quẽnaro mʉre yiyumi Dios. Mʉ macʉ ñarocʉre quẽne, bʉto quẽnaro ĩre yirʉcʉmi. Ñamasugõ me yʉ ñaboajaquẽne, yʉre ĩagõ ejaja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yʉre mʉ sẽniĩarone, yʉ gʉdajoa sãñagʉ̃ sũca variquẽnagʉ̃, yuguiami. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Dios ĩ goticõariarore bajiro bajirʉocoja yʉ” yitʉoĩagõ ñari, variquẽnaja mʉ quẽne —Mar'iare yiyuju Isabel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","To bajiro so yirone, variquẽnagõ ñari ado bajiro yiyuju Mar'ia: —Ĩ bojarore bajiro yirʉa tʉoĩagõ ñaboarine, ñamasugõ me yʉ ñaboajaquẽne, yʉre ĩamaicõari quẽnaro yami Dios. To bajiro yʉre ĩ yise ñajare, “Ñie rojose mano yʉre yirẽtobosarũgũgʉ̃mi”, Diore ĩre yivariquẽnaja yʉ. Bʉto quẽnaro yami Dios, ĩ bojarore bajiro quẽnaro yʉ yirotire yigʉ. Ĩ ñagʉ̃mi masijeogʉ. Quẽnaro yigʉ ñagʉ̃mi. To bajiro quẽnaro yʉre ĩ yise ñajare, “Quẽnaro sore yiyumi Dios”, yʉre yirũgũrʉarãma masa ñajediro. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ĩre rʉ̃cʉbʉorãre ĩamaicõari, quẽnaro yirũgũgʉ̃mi Dios. To bajirone yicõa mʉorʉ̃gõrʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","“Gãjerã rẽtoro masirã ñaja yʉa” yitʉoĩarã, no bojase ĩna yirʉaboasere ĩnare yirotibesumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ʉjarãre ñamasurã ĩna ñarʉaboasere ĩnare ñarotibeticõari, ñamasumenajʉare, “Ñamasurã ñato”, yiyumi. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ñie manare quẽnasere ĩnare cõaboarine, gajeyeũni jairãrema ĩnare cõabesumi. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Adire masiritibecʉ ñari, to bajiro yiyumi: Mani ñicʉ, Abrahamre, ĩ beroanare quẽne, “Mʉa masare, mʉa jãnerabatiare quẽnaro yicõa ñarʉcʉja yʉ”, ĩnare yigotimasiñuju Dios. Tire masiritibecʉ ñari, to bajiro yiyumi —Isabelre yigotiyuju Mar'ia. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Idiarã muijua sore baba cʉtiñaboa, so ya vijʉ tudicoasuju Mar'ia. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mar'ia so tudiato bero, macʉ cʉtiyuju so, Isabel. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","So macʉ cʉtisere ajicõari, “Quẽnaro sore ejarẽmogʉ̃ yiyumi Dios”, yitʉoĩañujarã ĩna, so yarã, so tʉana quẽne. To bajiro yitʉoĩarã ñari, sore variquẽna ejayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ĩ ruyuariaro bero, cojomo cõro, idia jẽnituarirʉ̃mʉri ĩ cʉotʉsato, ĩ tʉjʉre ejayujarã masa, ĩna yirũgũriarore bajiro sũcare circuncisión yirã ejarã. To yicõari, —Ĩ jacʉ vãmene ĩre vãme yito mani —yiboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","To ĩna yiboajaquẽne, jacojʉama, —Bajibeaja. Juan vãme cʉtiami —ĩnare yicõañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","To so yiro ajicõari, —Mʉ ya jũnana ti vãmere vãme cʉtibeticoayuma —sore yiyujarã ĩnajʉama. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","To yicõari, Zacar'iare, ĩna ãmorine ado bajise ĩre sẽniĩañujarã: —Mʉ macʉre, ¿No bajise ĩre vãme yirʉati mʉ? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","To ĩna yijare, ñagõbecʉ ñari, ucariajãi sẽniñuju Zacar'ias. Tijãire ãmicõari, “Juan vãme cʉtiami, yʉ macʉ”, ĩnare yiuca ĩoñuju ĩ. Ti ũnire ĩabetirũgũriarã ñari, no yimasibesujarã ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tirĩmarone, tudiñagõcoasuju Zacar'ias quẽna. To bajicõari, “Quẽnamasucõaja”, Diore yivariquẽnañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ti quetire ajicõari, bʉto güiyujarã ĩna tʉana ñajediro, ti ũnire ajibetirũgũriarã ñari. Judea sitana burori cʉtoana jediro ti quetire gãmerã gotibatoyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ĩna gotibatosere ajicõari, Zacar'ias macʉre Dios ĩ ejarẽmose ñajare, “¿Bʉcʉacʉ, no bajiro yigʉ ñariquĩda?”, yitʉoĩañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cojorʉ̃mʉ Esp'iritu Santo ĩ ejarẽmose rãca Diore gotirẽtobosagʉ, ado bajiro basayuju Zacar'ias: ");
INSERT INTO bsnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","75","—Tirʉ̃mʉjʉ ado bajiro Diore gotibosamasiñujarã ĩre gotirẽtobosamasiriarã: “Sĩgʉ̃, Ʉjʉ David ñamasir'i jãnami, mʉa jãnerabatiare ejarẽmogʉ̃ ruyuarʉcʉmi. Ruyuacõari, mʉa jãnerabatiare ĩaterimasa sʉorine rojose ĩna tãmʉoborotire ĩnare yirẽtobosarʉcʉmi”, Diore yigotirẽtobosamasiñujarã ĩna. Ado bajiro mani ñicʉare gotimasiñuju Dios: “Yʉ goticatore bajiro mʉare, mʉa jãnerabatiare quẽne ĩamaicõari, quẽnaro ĩnare yicõa ñarʉcʉja”, manire yigotimasiñuju Dios. Mani ñicʉre, Abraham vãme cʉtimasir'ire quẽne ado bajiro gotimasiñuju Dios: “Yʉ ñaja Dios. Riojo mʉre gotiaja yʉ. Mʉ jãnerabatiare gãjerã ĩna ĩatese sʉorine rojose ĩna tãmʉoborotire ĩnare yirẽtobosarʉcʉja yʉ. Ĩnare güimenane, yʉ bojarore bajiro ‘Yimasiato ĩna’ yigʉ, to bajiro yirʉcʉja yʉ. Adire masiritibetirʉcʉja yʉ. To bajiri, ĩna catiñaro cõro ‘Yʉare ĩagʉ̃mi Dios’ yimasiritimenane, yʉ bojarore bajiro quẽnaro yirũgũrʉarãma”, yigotimasiñuju Dios. To bajiri, ĩre gotirẽtobosarimasa, ĩna gotimasiriarore bajiro, to yicõari ĩ masune ĩ gotimasiriarore bajirone yigʉagʉ yigʉmi Dios yuja. Yoaro mene adi macarʉcʉrojʉ vadicõari, ĩre ajitirʉ̃nʉrãre rojose mani tãmʉoborotire yirẽtobosagʉagʉ yigʉmi. To bajiro yirocʉ ĩ ñajare, “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽnato mani —yibasavariquẽnañuju Zacar'ias. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","79","To yigajanocõari, “Ado bajiro yirocʉ ñaja mʉ”, ĩ macʉre yibasavariquẽnañuju Zacar'ias: —Yoaro mene ejarʉcʉmi mani ʉjʉ, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ. To bajiro ĩ bajiroti rĩjoro ñajare, “Rojose mʉa yirũgũsere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya mʉa, ĩre yurã”, yigotimasiorocʉ ñaja mʉ. To bajiro mʉ yisere ajicõari, tʉoĩavasoa yuñarãre ĩamaicõari, quẽnaro yigʉ ñari, ĩ rãca quẽnaro ñacõari, “Ĩ bojarore bajiro quẽnaro yirã ñato” yigʉ, ĩ yere masimenare ĩnare gotimasiocõari, rojose ĩna tãmʉoborotire ĩnare yirẽtobosarocʉre cõarʉcʉmi Dios. To bajiro yigoti rĩjoro cʉtirocʉ mʉ ñajare, “Masirẽtogʉ̃re Diore gotirẽtobosarimasʉ ñaami”, mʉre yiĩarʉarãma masa, —ĩ macʉre Juanre yibasavariquẽnañuju Zacar'ias. ");
INSERT INTO bsnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yucʉ́ manojʉ bʉcʉayuju Juan vãme cʉtigʉ. Bʉcʉarũtuacʉne, Dios ĩ bojarore bajiro quẽnaro yigʉ ñarũtuasuju ĩ. Masare ĩ gotimasiorotirʉ̃mʉ ti ejaroto rĩjoro, yucʉ́ manojʉre ñarũgũñuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","To bajiro bajiñarirodojʉre masa ñajediro ʉjʉ, César Augusto vãme cʉtigʉ, ĩ rotirimacarire ñarãre, “Ado cõro ñaama” yimasirʉ, ĩna vãmere ucaturotisʉoyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ĩre rotibosarimasʉ, Cirenio vãme cʉtigʉ Siria sitana ʉjʉ ĩ ñarirodore masa vãmere ucaturotisʉoyuju César. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","To bajiri, masa ñajediro, ĩna ñicʉa ĩna ñamasiriarojʉ vãme ucaturotirã varoti ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","To bajiri, José quẽne, Galilea sitajʉre ñarimaca Nazaret vãme cʉti maca ñar'i, Judea sita Belén vãme cʉti macajʉare vasuju. Ti macajʉ ruyuamasiñuju ĩ ñicʉ ñamasir'i, Ʉjʉ David. To ĩ bajimasire ñajare, tojʉ vasuju, José, Mar'ia rãca ĩna vãmere ucarotigʉacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jẽre so jacʉare sẽnicõañuju ĩ. To bajiro yir'i ñari, so rãca vasuju José. “Macʉ cʉtirʉocomo” Dios ĩ yirio ñari, gʉda ñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","To bajiri Belén vãme cʉti macajʉ ĩna ejaro, so macʉ cʉtirotirʉ̃mʉ ejayuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","To bajiro sore ti bajijare, vacudirã ĩna cãnirivi ĩna ñarotijʉre sẽniboayujarã ĩna. Masa jʉ̃mʉcõañujarã, ti vire. To bajiri, vaibʉcʉrãre bare ecariavijʉ ejayujarã ĩna yuja. Tojʉ Dios macʉre macʉ cʉtiyuju Mar'ia. To yicõari, sũcare sudigaserorine ĩre gũmañuju so, jud'io masa ĩna yirũgũriarore bajiro yigo. To yicõari, cãnijesariaro ti manijare, vaibʉcʉrãre bare ecariacorojʉ so macʉre sãñuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén maca tʉ ñañujarã ĩna, oveja coderimasa. Ñamire ĩnare ĩatirʉ̃nʉñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","To ĩna bajirone, ĩna tʉjʉre ruyuarʉ̃gʉ̃ñuju sĩgʉ̃ ángel, Diore moabosagʉ. To ĩ bajirone, ĩna tʉjʉ bʉto busubatoyuju, “‘Dios macʉ ruyuagʉmi’ yiĩamasiato ĩna” yigʉ. To bajiro ti bajijare, oveja coderimasa bʉto güiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","To ĩna bajirone, ado bajiro yiyuju ángel: —Güibesa mʉa. Masa ĩna ĩavariquẽnarotire yigʉ, quẽnase queti mʉare gotigʉ bajiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ʉjʉ David ĩ ruyuamasicati macajʉre, masa rojose ĩna yise vaja ĩnare vaja yibosarocʉ, yucʉne ruyuami. Ĩ ñaami mani ʉjʉ, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ado bajiro bajiñagʉ̃re ĩre bʉjamasirʉarãja mʉa: Vaibʉcʉrãre bare ecariavijʉ ñagʉ̃mi. Tojʉ sudigaserine gũmacoar'i, vaibʉcʉrãre bare ecariacorojʉ sãñagʉ̃mi ĩ. Tojʉ ñagʉ̃re ĩre ĩabʉjacõari, “Ĩne ñaami”, yimasirʉarãja mʉa —ĩnare yigotiyuju ángel. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","To ĩ yiñarirĩmarone, gãjerã ángel mesa jãjarã ruyuayujarã ĩna. Ruyuacõari, ado bajise Diore ĩre basavariquẽnañujarã ĩna: ");
INSERT INTO bsnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Dios õ vecagʉ quẽnarẽtogʉ̃, to yicõari, masirẽtogʉ̃ ĩ ñajare, quẽnaro ĩre yito mani. Dios ĩ ĩavariquẽnarã ĩ rãca quẽnaro ñato ĩna —yiyujarã ĩna ángel mesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","To yigajano, tudicoasujarã ĩna, õ vecajʉ, Dios ĩ ñarojʉ. Ĩna tudiato bero, —Dios manire ĩ queti cõarere ajiaja mani. To bajiri, Belénjʉ vaĩato mani —gãmerã yiyujarã ĩna oveja coderimasa. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","To bajiro gãmerã yigajano, guaro vacoasujarã ĩna yuja. Tojʉ ejacõari, Josére, Mar'iare ĩnare ĩabʉjayujarã ĩna. Sũcare quẽne vaibʉcʉrãre bare ecariacorojʉ sãñagʉ̃re ĩre ĩabʉjayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ĩre ĩabʉjacõari, ángel ĩnare ĩ gotirere to ñarãre ĩnare gotiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","To ñariarã jediro, ĩna gotisere ajicõari, no yimasibesujarã, ti ũnire ajibetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mar'iajʉama ñagõbesuju so, oveja coderimasa ĩna gotisere ajicõari. To bajiboarine, sũca ĩ bajisere bʉto tʉoĩañuju so masuriojʉma. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","To bajiri oveja coderimasa ti quetire gotigajano, tudicoasujarã ĩna. Tudianane, ado bajise Diore ĩre yivariquẽna tudiasujarã ĩna: —Dios manire ĩ queti cõare, riojo ñañuja ti. Masirẽtogʉ̃, to yicõari, quẽnarẽtogʉ̃ ñagʉ̃mi Dios —ĩre yivariquẽna vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sũca cojomo cõro idia jẽnituarirʉ̃mʉri ĩ ruyuariaro bero ti tʉsato, circuncisión ĩre yiyujarã. To yicõari, Jesús ĩre vãme yiyujarã ĩna, sũcare. Mar'ia gʉda so ñaroto rĩjorojʉne ángel sore ĩ vãme yirotiriarore bajirone ĩre vãme yirã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","To ĩna yiriaro bero, Jerusalénjʉ vasujarã ĩna. Moisés ñamasir'ire Dios ĩ roticũmasirere cʉdirã bajiyujarã ĩna. Ado bajise roticũmasiñuju ĩ: “Sũca ĩ ruyuaro bero, jʉarã masa cõro ñarirʉ̃mʉri bero, buja mʉa ecariarãre ĩsima, paiare. Mʉa cʉobetijama, vaja yicõari, ĩsima, ‘Ĩnare soemʉoato’ yirã. To bajiro yiba, yʉre rʉ̃cʉbʉorã. To bajiro mʉa yijama, sũca ĩ ruyuaroto rĩjoro yʉre yirʉ̃cʉbʉoriavi mʉa sãjarũgũriarore bajirone sãjamasirʉarãja mʉa quẽna. Mʉa ĩsijama, buja mame bʉcʉarãre ĩsirʉarãja mʉa. Ʉ̃mʉ, rõmio, to cõrone ĩsirʉarãja mʉa. Buja mame bʉcʉarã ĩna manijama, jʉarã bujare bajirã ñarãcare ĩsirʉarãja mʉa”, yirotimasiñuju Dios. Gajeye ado bajiro yirotimasiñuju Dios: “Mʉa macʉ ruyuasʉogʉre, paiare ĩorã, ĩre ãmivarʉarãja mʉa, ‘Dios yʉ ñaami’ yiĩorã”, yirotimasiñuju Dios. To bajise Dios ĩ yirotimasire ñajare, Jesúre ãmivasujarã, paiare ĩoroana. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","To bajiri Jerusalénjʉ ejacõari, Diore yirʉ̃cʉbʉoriavijʉre vasujarã ĩna. Tojʉre ñañuju Simeón. Diore quẽnaro ajirʉ̃cʉbʉogʉ, ĩ rotimasirere quẽnaro cʉdigʉ ñañuju ĩ. “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, Cristo, Israel jãnerabatiare, yʉ yarãre ejarẽmorũgũrʉcʉmi ĩ, ‘Quẽnaro ñato’ yigʉ” yitʉoĩagʉ̃ ñari, ĩ ejarotire yugʉ bajicõa ñañuju ĩ. Dios ĩ cõagʉ̃ Esp'iritu Santo ĩ ejarẽmose rãca tʉoĩagʉ̃ ñañuju ĩ. To bajiro bajigʉ ñari, cojorʉ̃mʉ ado bajise tʉoĩañuju: “Yʉ bajirocaroto rĩjoro, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉre Cristore ĩarʉcʉja yʉ”, yitʉoĩañuju Simeón. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","29","Cojorʉ̃mʉ Esp'iritu Santo Dios ĩ cõagʉ̃ ĩre ĩ ejarẽmose rãca tʉoĩamasicõari, Diore yirʉ̃cʉbʉoriavijʉ sãjaejacoasuju ĩ. Tirʉ̃mʉne Jesúre ãmiejayujarã José, ĩ manajo rãca. To ĩna sãjaejarone, ĩna macʉre bocaãmicõari, ado bajise Diore yigotiyuju ĩ, Diore variquẽnagʉ̃: —Yʉ ʉjʉ, jẽre yʉ ĩarʉarũgũcacʉre yʉre mʉ goticatore bajirone ĩre ĩacõaja yuja. To bajiri, variquẽnaja yʉ. Yʉ bajirocacoajama, quẽnacõaroja yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ĩre ajitirʉ̃nʉrã rojose yʉa tãmʉoborotire yʉare yirẽtobosarocʉre mʉ cõar'ire ĩre ĩacõaja jẽre. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ĩ sʉorine “Israel jãnerabatiare quẽnaro yiyumi Dios” yimasicõari, Diore masirʉarãma Israel jãnerabatia me ñarã quẽne —yiyuju Simeón. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José, to yicõari, Mar'ia quẽne, Jesús ĩ bajirotire Simeón ĩ gotisere ajicõari, no yimasibesujarã ĩna, “Mani macʉ ĩ bajirotire quẽnaro goti rĩjoro cʉtimasiami” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","To yicõari, quẽnaro Dios ĩnare ĩ yirotire ĩnare ñubuejeoyuju Simeón. To yigajano, Jesús ĩ bajirotire ado bajiro sore gotiyuju quẽna, Mar'iare: —Quẽnaro ajiya mʉ. “Israel ñamasir'i jãnerabatia, Dios ĩ bojasere quẽnaro masiato” yigʉ, ãni sũcare cõañumi Dios. To bajiri ĩ gotimasiosere ajicõari, ĩre tud'irʉarãma jãjarã masa. To bajiro ĩna yijare, ĩnare ĩacõari, “‘Diore rʉ̃cʉbʉorã ñaja yʉa’ yigotiboarine, ĩre terã ñaama”, yimasirʉarãma gãjerãjʉa. Ĩre tud'irãma, ĩna rijato berojʉ rojose tãmʉotʉjabetiriarojʉ vajedicoarʉarãma ĩna. To bajiboarine gãjerãjʉama, jãjarã, ãnire ajitirʉ̃nʉcõari, Dios yarã ñacoarʉarãma ĩna, rojose tãmʉotʉjabetiriarojʉ vaborona. Mʉjʉama, ãni mʉ macʉ ĩ bajirotire bʉto sʉtiritirʉocoja mʉ —Jesús jacore yiyuju Simeón. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","To ĩ yiro bero, Diore yirʉ̃cʉbʉoriavijʉre ñañuju Ana vãme cʉtigo. Aser ñamasir'i jãneño ñañuju so, Fanuel maco. Diore gotirẽtobosarimaso ñañuju so quẽne. So manajʉ cʉtiboar'i, cojomo cõro jʉa jẽnituarirãca cʉ̃mari so rãca ñatʉsacʉne, sore bajirocaveocoasuju. To ĩ bajiveorio sĩgõne ñacõarũgũñuju so. To bajiñagõ rĩne, ochenta y cuatro cʉ̃mari cʉotʉsasuju. Diore yirʉ̃cʉbʉoriavijʉ ñacõari, so quẽne Diore ĩre rʉ̃cʉbʉogo, ĩre so sẽnirirʉ̃mʉri bare babetirũgũñuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón ĩnare ĩ gotiñarone ĩna tʉjʉ ejayuju so Ana. Ĩnare ĩ gotisere ajicõari, “Quẽnaro yiyuja mʉ”, Diore ĩre yivariquẽnañuju so. To yigajanocõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉre, “Jerusalén macana quẽnaro ñato” yigʉ, ĩnare yirẽtobosarocʉre ĩ ejarotire tʉoĩa yuñarãre, “Jẽre ruyuayumi”, ĩnare yigotibatoyuju Ana. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José, to yicõari, Mar'ia quẽne Moisés ñamasir'ire Dios ĩ roticũmasiriarore bajirone yigajanocõañujarã ĩna. To bajiri, Galilea sitare ñarimaca, Nazaret vãme cʉti macajʉ Jesúre ĩre ãmitudiasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","To baji tudieja, ti macajʉ ñacõañujarã ĩna. Tojʉ bʉcʉayuju Jesús. Quẽnaro masirũtuasuju, ĩ bʉcʉarũtuatore bajirone. To bajicõari, rujʉ tutuaquẽnagʉ̃ ñarũtuasuju ĩ. To bajiro ĩ bajiñarore ĩre yirẽmorũgũñuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nazaretjʉ Jesús ĩ ñatoye, Jerusalénjʉ tocãrãca cʉ̃mane Pascua boserʉ̃mʉ ĩarã varũgũñujarã ĩ jacʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","To bajiri jʉaãmo cõro, gʉbo jʉa jẽnituaro ñaricʉ̃mari tʉsacʉjʉ, Pascua boserʉ̃mʉre ĩagʉacʉ, ĩ jacʉa rãca vasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","45","Boserʉ̃mʉ ĩagajano, ĩna tudirirʉ̃mʉ, “To bajigʉmi” yimasiña manone, tojʉne tujacoasuju Jesújʉama. To ĩ bajiboajaquẽne, “Gãjerã rãca baba cʉtivagʉ bajigʉmi”, yitʉoĩacõañujarã ĩ jacʉajʉama. To bajiro ĩna yitʉoĩa vaboajaquẽne, rãiorijʉ ĩna tʉjʉre ejabesuju. To bajiro ĩ bajijare, ĩna yarãre, ĩna rãca vanare, ĩna masirãre sẽniĩacudiboayujarã ĩna. “Maami”, yicõañujarã ĩnajʉama. To bajiro ĩna yijare, Jerusalénjʉne ĩre macarã tudicoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tojʉ ejacõari, idiarʉ̃mʉ ĩre macatʉsanajʉ ĩre ĩabʉjayujarã ĩna yuja. Diore yirʉ̃cʉbʉoriavijʉ ñañuju ĩ. Tojʉ Dios ĩ rotimasire gotimasiorimasa rãca rujicõari, gãmerã ñagõñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ĩ gotisere ajicõari, “Daquegʉ ñaboarine, josasere yʉa sẽniĩaboajaquẽne, quẽnaro tʉoĩacõari, yʉare cʉdiami”, ĩre yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","To ĩna yiñarone, Jesús jacʉa ĩna tʉjʉ sãjaejacõari, ĩre ĩaʉcacoasujarã. To bajicõari, ado bajiro ĩre yiyuju ĩ jaco: —Macʉ, ¿no yigʉ to bajiro yʉare bajiveoati mʉ? Bʉto tʉoĩarejairãne mʉre macamʉ yʉa —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","To bajiro ĩre so yirone, ĩjʉama ado bajiro sore cʉdiyuju ĩ: —¿No yirã yʉre macari mʉa? ¿Adi vire yʉ jacʉ ĩ bojasere yʉ yirotire masibeti mʉa? —ĩ jacʉare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","To bajiro ĩ yisere quẽnaro ajimasibesujarã ĩnajʉama. “No bajiro yirʉ yati mani macʉ”, yitʉoĩacõañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","52","Ĩ jacojʉama, quẽnaro ajimasibetiboarine, so ʉsʉjʉma quẽnaro tʉoĩacõa ñañuju. To bajiro ĩnare ĩ yiro bero, ĩ jacʉa rãca tudicoasuju, Nazaretjʉ. Tojʉ bʉcʉarũtuasuju ĩ. Bʉcʉarũtuacʉne, ĩ jacʉa ĩre ĩna rotirore bajiro yirũgũñuju ĩ. To bajicõari, bʉtobʉsa masirũtuasuju ĩ. To bajiro ĩ bajisere ĩre ĩavariquẽnarũgũñuju Dios. Masa quẽne, ĩre ĩavariquẽnarũgũñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Cojorʉ̃mʉ yucʉ́ manojʉ Zacar'ias macʉre, Juanre Jordán vãme cʉtiyajʉ ĩre gotiroticõañuju Dios. To ĩre ĩ gotiroticõarirodore, Tiberio César, jʉaãmo cõro, cojo gʉbo jediro ñaricʉ̃mari ĩ rotitʉsaticʉ̃mare, cojo sita me ñarãre rotigʉ ñañuju ĩ. Ĩre rotibosarã quẽne ñañujarã ĩna. Pilato vãme cʉtigʉ Judea sitanare ĩre rotibosayuju ĩ. Gãji, Herodes vãme cʉtigʉ, Galilea sitanare ĩre rotibosayuju ĩ. Gãji, Herodes bedi, Felipe vãme cʉtigʉ, Iturea, to yicõari, Traconite sita ñarãre ĩre rotibosayuju, ĩma. Gãji Lisanias vãme cʉtigʉ, Abilinia sitanare ĩre rotibosayuju. To bajicõari, paia ʉjarã ñamasurã Anás, Caifás vãme cʉtirã ñañujarã ĩna. Tirodore Juanre gotirotiyuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","To ĩ yijare, Jordán vãme cʉtiya riaga tʉjʉ ñacõari, ĩre ajirã ejarãre ado bajiro gotirʉ̃jacudirũgũñuju: —Rojose mʉa yisere tʉoĩasʉtiritiya mʉa. To yicõari, “Rojose yirʉabeaja yʉa. Diorãca quẽnaro ñarʉarãja yʉa” yirã, oco rãca yʉre bautizarotiya mʉa. To bajiro mʉa yijama, rojose mʉa yisere mʉare masiriorʉcʉmi Dios —ĩnare yigotiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ado bajiro Juan ĩ bajirotire ucamasiñuju Isa'ias, Diore gotirẽtobosarimasʉ ñamasir'i: “Yucʉ́ manojʉ sĩgʉ̃ masʉ ado bajiro goticudirũgũrʉcʉmi: ‘Mani ʉjʉ ejarʉcʉmi. To bajiri, rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya mʉa, ĩre yurã. Ʉjʉ, ĩ vadiroto rĩjoro, quẽnaro quẽnoyurãma masa. Rojoribedo maa, ñaboaria maare riojo maa gorãma, ĩ vadiroti maare. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Goje ti ñajama, sita rãca biberãma. Buri cʉti maa ti ñajaquẽne, coaquẽnocũrãma. To bajiro yʉ yijama, “Jediro rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya mʉa, mani ʉjʉre yurã” yigʉ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","To bajiro mʉa yiro bero, rojose mʉa tãmʉoborotire mʉare yirẽtobosarocʉre Dios ĩ cõagʉ̃re ĩajedirʉarãja mʉa’ yigoticudirũgũrʉcʉmi, yucʉ́ manojʉ ñacõari”, yiucamasiñumi Isa'ias ñamasir'i. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","To bajiri oco rãca Juanre bautizarotirã, ejayujarã jãjarã masa. Ĩna bautizarotirone, ado bajiro ĩnare yiyuju Juan: —Oco rãca mʉare yʉ bautizasere bojaboaja mʉa. Vãtia ʉjʉ rojose ĩ yirore bajirone rojose yijairã ñaja mʉa. To bajiro bajirã ñari, “Rojose yʉa yise vaja rojose yʉare yibetirʉcʉmi Dios”, yitʉoĩa vadiboaja mʉa. ¿To bajiro mʉa bajise sʉorine rojose mʉa tãmʉorotire masibeatique mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rojosere yitʉjacõari, “Quẽnaro yirã ñaama” masa mʉare ĩna yiĩamasirotire yirã, quẽnasejʉare yirũgũrona ñaja mʉa. Ado bajiro yitʉoĩabesa mʉa: “Abraham ñamasir'i jãnerabatia ñamasurã mani ñajare, rojose mani yise vaja rojose manire yibetirʉcʉmi Dios”, yitʉoĩabesa. Adiari gʉ̃tari rãca Abraham jãnerabatiare ĩ godoveorʉajama, godoveomasigʉ̃mi Dios —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","—Oteriayucʉ́ri, rica mani yucʉ́rire bajiro bajiaja mʉa. Rica manijare, quẽareacõari, soereariarore bajiro yirʉcʉmi Dios. Tire bajirone yiecorʉarãja mʉa quẽne, mʉa tʉoĩavasoabetijama. ¡Quẽnase mʉa yibetire ĩacõari, jeame yatibetimejʉ mʉare rearʉcʉmi Dios! —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","To ĩ yigotisere ajicõari, —¿No bajirojʉa yʉa yirotire bojati Dios? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","To bajiro ĩre ĩna yisẽniĩarone ado bajiro ĩnare cʉdiyuju Juan: —Jʉase sudirori cʉorã, cojase ĩsima, sudi magʉ̃re. Bare cʉorã, bare magʉ̃re ecaba —ĩnare yicʉdiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ʉjʉre gãjoa sẽnibosarimasa quẽne ejayujarã, Juanre oco rãca bautizarotirã. Ejacõari, ado bajiro ĩre sẽniĩañujarã ĩna quẽne: —Gotimasiorimasʉ, yʉajʉarema ¿ñiere yʉa yirotire bojati Dios? —ĩre yisẽniĩañujarã ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","To bajiro ĩna yirone, ado bajiro ĩnare gotiyuju Juan: —Mʉa ʉjarã masare ĩna vaja sẽnirotiro cõrone sẽniña. Ti rẽtoro vaja sẽnibeticõaña mʉa —ĩnare yicʉdiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Surara quẽne ado bajiro sẽniĩañujarã ĩna: —¿Yʉarema, no bajiro yʉa yirotire bojati? —ĩre yisẽniĩañujarã. To bajiro ĩna yisẽniĩarone, ado bajiro ĩnare cʉdiyuju ĩ: —Gãjerãre ẽmabesa mʉa. Socarãne gãjerãre rojose ñagõmacabesa. Mʉa moase vajare, mʉa ʉjarã mʉare ĩna vaja yiro cõrone cʉovariquẽnaña mʉa —ĩnare yicʉdiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Masajʉama, Juan ĩ gotimasiosere ajicõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ Dios ĩ cõarocʉre bʉto tʉoĩayucõa ñarã ñari, “¿Ĩne ñaruyuatique?”, Juanre ĩre yitʉoĩañujarã, ĩna ʉsʉrijʉma. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","To bajiro ĩna yitʉoĩase ñajare, ado bajiro ĩnare yiyuju Juan: —“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ me ñaja yʉ. Rojose ĩna yisere yitʉjacõari, Dios ĩ bojasejʉare yirãre oco rãca bautizarũgũaja yʉ. To bajiro yʉ yiboajaquẽne, yʉ bero ejagʉ ĩ moasejʉa quẽnamasucõarʉaroja. Ĩma, Esp'iritu Santore cõamasirʉcʉmi, masare. “Dios ĩ bojabetire yaja yʉa” yimasicõari, tʉoĩavasoarʉarãma, Esp'iritu Santo ĩ ejarẽmose rãca —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gajeye ado bajiro masare gotiyuju Juan: —Yʉ bero ejagʉjʉama, trigo ajere besegʉre bajiro yirʉcʉmi, masare. To bajiri ti gasere yireacõari, soereariarore bajiro yirʉcʉmi, jeame yatibetimejʉ masare cõagʉ̃. To yicõari, quẽnase cõrone juagʉre bajiro yirʉcʉmi, ĩre ajitirʉ̃nʉrãre juavacʉ —ĩnare yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Masare gotimasiogʉ̃, cojo vãme me gotirũgũñuju, Cristo quẽnaro ĩ yirotire gotimasiogʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","To bajiro ĩnare gotirũgũgʉ̃ ñari, Ʉjʉ Herodes, ĩ bedi Felipe manajore Herod'ias vãme cʉtigore ĩ manajo cʉtijare, to yicõari, rojose yijaigʉ ĩ ñajare, “Rojose yigʉ yaja mʉ”, ĩre yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","To bajiro Juan ĩ yisere ajicõari, rẽtoro rojose yigʉ, tubiberiavijʉ Juanre ĩre tubibecũñuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ĩ tubibe ecoroto rĩjoro, rojose ĩna yisere yitʉjacõari, Dios ĩ bojasejʉare yirãre oco rãca ĩnare bautizarũgũñuju Juan. To bajiri, Jesús quẽne, rojose yibecʉ ñaboarine, oco rãca Juanre bautizarotigʉ ejayuju. To ĩ yiecoro bero, Diore, ĩ jacʉre sẽniñuju. Ĩre ĩ sẽniñarone, õ vecajʉ ʉ̃mʉagasero soje jãnacoasuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ti jãnarone, bujare bajigʉ rujiadicõari, Jesús joere rocajeoyuju Esp'iritu Santo. Jesús joere ĩ rocajeorone, ado bajiro yi ocaruyuyuju õ vecajʉ: —Yʉ macʉ, yʉ maigʉ̃ masu ñaja mʉ. Mʉ rãca bʉto variquẽnaja yʉ —ĩre yi ocaruyuyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Treinta cʉ̃mari cõro cʉotʉsacʉ, masare gotimasiosʉoyuju Jesús. To bajiri manire bajiro rujʉ cʉticõari ĩ ruyuare ñajare, “José macʉ ñaami”, ĩre yitʉoĩañujarã masa. To bajiro ĩna yitʉoĩare ñajare, ĩ jacʉre bajiro bajiyuju José. José jacʉ ñamasiñuju El'i. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","El'i jacʉ ñamasiñuju Matat. Matat jacʉ ñamasiñuju Lev'i. Lev'i jacʉ ñamasiñuju Melqui. Melqui jacʉ ñamasiñuju Jana. Jana jacʉ ñamasiñuju José. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José jacʉ ñamasiñuju Matat'ias. Matat'ias jacʉ ñamasiñuju Amós. Amós jacʉ ñamasiñuju Nahúm. Nahúm jacʉ ñamasiñuju Esli. Esli jacʉ ñamasiñuju Nagai. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai jacʉ ñamasiñuju Maat. Maat jacʉ ñamasiñuju Matat'ias. Matat'ias jacʉ ñamasiñuju Semei. Semei jacʉ ñamasiñuju Josec. Josec jacʉ ñamasiñuju Judá. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá jacʉ ñamasiñuju Joanán. Joanán jacʉ ñamasiñuju Resa. Resa jacʉ ñamasiñuju Zorobabel. Zorobabel jacʉ ñamasiñuju Salatiel. Salatiel jacʉ ñamasiñuju Neri. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri jacʉ ñamasiñuju Melqui. Melqui jacʉ ñamasiñuju Adi. Adi jacʉ ñamasiñuju Cosam. Cosam jacʉ ñamasiñuju Elmadam. Elmadam jacʉ ñamasiñuju Er. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er jacʉ ñamasiñuju Jesús. Jesús jacʉ ñamasiñuju Eliezer. Eliezer jacʉ ñamasiñuju Jorim. Jorim jacʉ ñamasiñuju Matat. Matat jacʉ ñamasiñuju Lev'i. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lev'i jacʉ ñamasiñuju Simeón. Simeón jacʉ ñamasiñuju Judá. Judá jacʉ ñamasiñuju José. José jacʉ ñamasiñuju Jonam. Jonam jacʉ ñamasiñuju Eliaquim. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim jacʉ ñamasiñuju Melea. Melea jacʉ ñamasiñuju Mena. Mena jacʉ ñamasiñuju Matatá. Matatá jacʉ ñamasiñuju Natán. Natán jacʉ ñamasiñuju David. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David jacʉ ñamasiñuju Isa'i. Isa'i jacʉ ñamasiñuju Obed. Obed jacʉ ñamasiñuju Booz. Booz jacʉ ñamasiñuju Sala. Sala jacʉ ñamasiñuju Naasón. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón jacʉ ñamasiñuju Aminadab. Aminadab jacʉ ñamasiñuju Admin. Admin jacʉ ñamasiñuju Arni. Arni jacʉ ñamasiñuju Esrom. Esrom jacʉ ñamasiñuju Fares. Fares jacʉ ñamasiñuju Judá. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá jacʉ ñamasiñuju Jacob. Jacob jacʉ ñamasiñuju Isaac. Isaac jacʉ ñamasiñuju Abraham. Abraham jacʉ ñamasiñuju Taré. Taré jacʉ ñamasiñuju Nacor. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor jacʉ ñamasiñuju Serug. Serug jacʉ ñamasiñuju Ragau. Ragau jacʉ ñamasiñuju Peleg. Peleg jacʉ ñamasiñuju Heber. Heber jacʉ ñamasiñuju Sala. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala jacʉ ñamasiñuju Cainán. Cainán jacʉ ñamasiñuju Arfaxad. Arfaxad jacʉ ñamasiñuju Sem. Sem jacʉ ñamasiñuju Noé. Noé jacʉ ñamasiñuju Lamec. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec jacʉ ñamasiñuju Matusalén. Matusalén jacʉ ñamasiñuju Enoc. Enoc jacʉ ñamasiñuju Jared. Jared jacʉ ñamasiñuju Mahalaleel. Mahalaleel jacʉ ñamasiñuju Cainán. ");
INSERT INTO bsnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán jacʉ ñamasiñuju Enós. Enós jacʉ ñamasiñuju Set. Set jacʉ ñamasiñuju Adán. Adán, Dios ĩ rujeosʉomasir'i ñamasiñuju ĩ, masa jediro ñicʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jordán ĩna yirisajʉ Juan oco rãca ĩre ĩ bautizaro bero, Esp'iritu Santo bujare bajigʉ rujiadicõari, Jesús joere rocajeoejagʉne, ĩre ejarẽmosʉoyuju, Dios ĩ bojarore bajiro Jesús ĩ yicõa ñarũgũrotire yigʉ. To bajivagʉre yucʉ́ manojʉ ĩre ũmato vasuju Esp'iritu Santo. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tojʉre cuarenta ñarirʉ̃mʉri Esp'iritu Santo ĩ bojarore bajiro vacudiyuju Jesús. To ĩ bajiñarone, vãtia ʉjʉ Satanás, ĩre ejacõari, “Yʉ yirotisere yicõari, Dios ĩ bojabetire yato” yigʉ, ĩre rotirũgũboayuju. To bajiro ĩ bajicudirirʉ̃mʉrire babesuju Jesús. To bajigʉ ñari, bʉto ñiorijayuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","To bajiro ĩ bajijare, ado bajiro ĩre yirotiboayuju Satanás: —Dios macʉne mʉ ñajama, adia gʉ̃tare, pan godoveoya mʉ —ĩre yirotiboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","To bajiro Satanás ĩre ĩ yiboajaquẽne, —Yibeaja yʉ. Dios oca masa ĩna ucamasire ado bajiro gotiaja: “Bare rĩne ñamasuse me ñaja. Dios ocare mani cʉdisejʉa ñaja ñamasusema. ‘Bare ti manijare, rijarearʉarãja’ yire ti ñaboajaquẽne, rijarere Dios ĩ bojabetijama, rijabetirʉarãja. Catiñarotire rotigʉ ñaami”, yigotiaja Dios oca masa ĩna ucamasire —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","To bajiro ĩ yiro bero, gʉ̃taʉ joejʉ Jesúre ũmato vasuju Satanás. Tojʉ ũmato ejacõari, adi macarʉcʉro ñarimacari jediro guaro ĩre ĩojeocõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ĩre ĩogajanocõari, ado bajiro ĩre gotiyuju Satanás: —“Masa ñajedirore rotiya” yigʉ, yʉre cũcami Dios. Ĩna gajeyeũni quẽne, yʉ ye ñaja. To bajiri, yʉ rĩjorojʉa gʉsomuniari tuetucõari, “Yʉ ʉjʉ ñamasugʉ̃ ñaja mʉ” yʉre mʉ yirʉ̃cʉbʉojama, adi sita ñajediro mʉre ĩsirʉcʉja yʉ —Jesúre ĩre yiyuju Satanás. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","To bajiro ĩre ĩ yigotiboajaquẽne, ado bajiro ĩre cʉdiyuju Jesús: —Yibeaja yʉ. Ado bajiro gotiaja Dios oca masa ĩna ucamasire: “Mani ʉjʉ Dios sĩgʉ̃rene, ‘Yʉ ʉjʉ ñamasugʉ̃ ñaja mʉ’ ĩre yirʉ̃cʉbʉocõari, cʉdire ñaja”, yigotiaja Dios oca masa ĩna ucamasire —Satanáre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","To ĩ yiro bero, Jerusalén macajʉ Jesúre ĩre ũmato vasuju Satanás quẽna. Tojʉ ejacõari, Diore yirʉ̃cʉbʉoriavi joejʉ ĩre ũmato mʉjasuju. Ĩre ũmato mʉjaejacõari, ado bajiro yiyuju Satanás: —Ado bajiro gotiaja Dios oca masa ĩna ucamasire: “Ĩre moabosarimasa ángel mesare mʉre coderotirʉcʉmi Dios. Mʉ quediajama, ‘Gʉ̃ta joejʉ rocajeogʉ, ĩ gʉbo jearomi’ yirã, mʉre boca ñiarʉarãma ĩna”, yigotiaja Dios oca. To bajiro Dios oca ti gotijare, Dios macʉne mʉ ñajama, adojʉne yʉre jatiquedi rujiaĩoña mʉ —Jesúre yiboayuju Satanás. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","To bajiro ĩre ĩ yiboajaquẽne, Jesújʉama, ado bajiro ĩre yiyuju: —To bajiro mʉ yisere cʉdibeaja yʉ. “Dios ĩ yiriarore bajiro yʉre boca ñiarʉarãma ángel mesa” yimasirʉ, yʉ jatiquediĩajama, Dios ĩ bojabetire yigʉ yigʉja yʉ. Gajeye ado bajiro gotiaja Dios oca masa ĩna ucamasire: “‘Dios, “Yirʉcʉja” yiyumi’ yitʉoĩarã, ‘¿Yirʉ masu yiyujari?’ yimasirʉarã, mʉa tʉoĩarore bajiro mʉa yiajejama, quẽnabeaja”, yigotiaja Dios oca masa ĩna ucamasire —ĩre yiyuju Jesús, Satanáre. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Rojose ĩre yirotijeoboa, vacoasuju Satanás, “Bero ĩre yirotiĩagʉ̃sa” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Satanás ĩ vato bero, quẽna Galilea sitajʉ tudicoasuju Jesús. Tudiejacõari, Esp'iritu Santore cʉogʉ ñari, ĩ ejarẽmose rãca disejʉa rʉyariaro mano quẽnaro yiyuju Jesús, tojʉre. To bajiro ĩ yijare, ĩ bajise quetire gotibatoyujarã masa, toana jediro, gajeroana quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dios ocare ĩna buerivirijʉ masare gotimasiocudirũgũñuju Jesús. To bajiro ĩ yisere ajicõari, “Quẽnaro masigʉ̃ ñaami”, ĩre yiyujarã ĩna, ĩre ajirã jediro. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nazaretjʉ, ĩ bʉcʉariarojʉ tudiejayuju Jesús. Daquegʉ ñagʉ̃jʉne jud'io masa ĩna ʉsʉsãjariarʉ̃mʉrire Dios ocare ĩna buerivire sãjarũgũr'i ñari, ʉsʉsãjariarʉ̃mʉ ti ejaro sãjasuju. Sãjacõari, ejarũju ejayuju. To bajiñaboa, vʉ̃mʉrʉ̃gʉ̃ñuju, Dios ocare ĩagotigʉagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ĩ vʉ̃mʉrʉ̃gʉ̃rone, Diore gotirẽtobosamasir'i, Isa'ias ĩ ucamasire ñaritutire ĩre ĩsiñuju ti viagʉ. To bajiro ĩ yirone, titutire jãnacõari, ĩ ĩagotirotijʉre ĩabʉjayuju. Ĩabʉjacõari, ado bajiro ĩnare ĩagotiyuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—“Esp'iritu Santore cʉogʉ ñari, ĩ ejarẽmose rãca tʉoĩacõari, mʉare gotiaja yʉ. ‘Maioro bajirãre quẽnaro yʉ yiroti quetire ĩnare gotirʉcʉja mʉ’ yigʉ, ‘Rojose yirʉaboarine, tire yibeticõato’ yigʉ, yʉre cõacami. Sĩgʉ̃ri yʉre masimena, ĩamenare bajiro bajirã, ‘Yʉre masiato ĩna’ yigʉ, yʉre cõacami. Gãjerãma, tubibe ecoriarãre bajiro bajirãre, rojose yisejariarãre, ‘Rojose ĩna yisere yitʉjato’ yigʉ, yʉre cõacami. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘“Adirodone ñaja Ʉjʉ Dios, masare rojose ĩna tãmʉoborotire ĩnare ĩ yirẽtobosarotirodo”, ĩnare yigotiaya mʉ’ yigʉ, yʉre cõacami”. “To bajiro bajirʉaroja ti”, yiucamasiñumi Isa'ias, Dios ocare gotirẽtogʉ̃ —ĩnare yiĩagotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","To bajiro yiĩagoti gajanocõari, ĩ ĩaritutire bʉacõari, ti viagʉre tʉoyuju. To yicõa, ejarũjucoasuju yuja, ĩnare buegʉagʉ. To ĩ bajirone bʉto ĩre ĩañujarã ĩna jediro, ĩnare ĩ gotisere ajirʉarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","To bajiro ĩna bajirone, ado bajiro ĩnare gotiyuju ĩ: —Jẽre adirodone ñaja, “Bajirʉaroja” Isa'ias ĩ yiucamasiriarore bajirone bajirirodo —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","To bajiro ĩ yisere ajicõari, no yimasibesujarã ĩna: —¿No bajiro bajicõari, quẽnaro gotimasiomasiati ĩ? ¿Adi macagʉ José macʉ me ñatique? —Jesúre ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yiyuju Jesús: —Yʉre rʉ̃cʉbʉobeaja mʉa. Ado bajiro yʉre yitʉoĩaja mʉa: “Capernaum vãme cʉtojʉ ĩaĩañamani ĩ yirere ajicajʉ mani. Riojo gotigʉ, ĩaĩañamani ĩ yisere manire quẽne yiĩoato ĩ”, yitʉoĩaja mʉa. Mani gotise queti, ado bajiro gotiaja: “Sĩgʉ̃, ʉco yigʉ, ĩ rijajama, ĩ masune ʉco yi, caticoacʉmi. To bajiro ĩ bajisere ĩacõari, ‘Ʉco yigʉ masune ñaami’ yimasirãja mani”, yigotiaja. Ti ũnire yʉre gotirʉa tʉoĩaja mʉa, ado bajiro yʉ yisere bojarã ñari: “Ĩaĩañamani yigʉ masu mʉ ñajama, Capernaumjʉ ĩaĩañamani mʉ yiĩorere bajiro mʉ ya macanare quẽne yiĩoroti ñaja”, yʉre yiboarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","To yigajano, ado bajiro ĩnare gotiyuju quẽna: —Riojo mʉare gotiaja yʉ. Diore gotirẽtobosarimasʉ gajerojʉ Dios ocare ĩ gotimasiocudijama, ĩre ajirʉ̃cʉbʉorãma. To bajiboarine, ĩ ya macanare Dios ocare ĩ gotimasiojama, ĩre ajiterãma. To bajirone bajiaja yʉre quẽne —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—To bajirone bajimasiñuju ti, mani ñicʉare quẽne. Diore gotirẽtobosamasir'i, El'ias vãme cʉtigʉre, ĩ yarã ñamasiriarã, ĩre ajitemasiñujarã ĩna. El'ias ĩ ñarirodori yoaro oco quedibetimasiñuju. Idia cʉ̃ma jediro gaje cʉ̃ma gʉdareco oco quedibetimasiñuju. To bajiro bajica yiro, bare manimasiñuju. Manajʉa rijaveomasiriarã, tirodori jãjarã ñamasiñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","To bajiri El'ias ĩ ejarẽmorotire bojarã, jãjarã ĩna ñaboajaquẽne, ĩna tʉjʉare cõabecʉne, “Sidón vãme cʉti maca tʉ ñarimaca, Sarepta vãme cʉti maca ñagõjʉare sore ejarẽmoaya” yigʉ, ĩre cõamasiñuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eliseo vãme cʉtigʉ, Diore gotirẽtobosamasir'ire quẽne, to bajirone bajimasiñuju. Ĩ ñarirodori, mani ñicʉa ñamasiriarã, gase boarã jãjarã ñamasiñujarã ĩna. Jãjarã ĩna ñaboajaquẽne, ĩnare catiobetimasiñuju ĩ. Ĩnare catiobetiboarine, gãjerã masʉjʉare, Siria sitagʉre Naamán vãme cʉtigʉre catiomasiñuju Eliseo —ĩnare yigotiyuju Jesús, Dios ocare ĩna buerivi rẽjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","To bajiro ĩ yigotisere ajicõari, ĩna jedirone bʉto jũnisiniñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","To bajiro bajirã ñari, Jesúre ñiacoasujarã ĩna. Gʉ̃taʉ ñañuju ti, ĩna ñarimaca tʉjʉ. “Tiʉ gʉ̃taʉ joejʉ ĩre turocaqueoto mani” yirã, Jesúre ñia vaboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ĩre ĩna ñia vaboajaquẽne, no yimasiña manone ĩna vatoane vacoasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","32","Galilea sitare ñarimaca, Capernaum vãme cʉti macajʉ vasuju Jesús. Ti macajʉ ejacõari, ʉsʉsãjariarʉ̃mʉ ti ejaro, Dios ocare ĩna buerivijʉ ĩnare gotimasioñuju ĩ. Ʉjʉre bajiro bojonebecʉne quẽnaro ĩ gotimasiojare, ajiĩañamani ĩ gotise ti ñajare, no yimasibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti vire sĩgʉ̃ ʉ̃mʉ ñañuju, ĩ ʉsʉjʉ vãti sãñagʉ̃. Ĩ ʉsʉjʉ sãñacõari, ado bajiro Jesúre ĩre avasãñuju vãti: ");
INSERT INTO bsnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús, Nazaret vãme cʉti macagʉ, ¿no yigʉ yʉa tʉ vadiati mʉ? ¡Yʉare gõjanabiobesa! ¿Rojose yʉa yise vaja, rojose yʉare yigʉagʉ vadiati mʉ? Mʉre ĩamasiaja yʉa. Rojose yigʉ me, Dios ĩ cõar'i ñaja mʉ —Jesúre yiavasãñuju vãti. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","To ĩ yirone, oca tutuase rãca ado bajiro ĩre yiyuju Jesús: —¡Ñagõbesa mʉ! ¡To yicõari, ĩ ʉsʉjʉre budigoya! —vãtire ĩre yiyuju Jesús. To ĩ yirone, rijaquedirotiyuju vãti, masʉre. To yicõari, rojose ĩre yirʉagʉ ñaboarine, rojose ĩre yibecʉne, ĩre budigocoasuju yuja. To ĩ bajijare, masʉjʉama quẽnaejacoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","To bajisere ĩacõari, ti vi ñarã jediro no yimasibesujarã ĩna, ti ũnire ĩabetirũgũriarã ñari. To bajicõari, ĩna masune ado bajiro gãmerã sẽniĩañujarã: —¿No bajiati? Ajiĩañamani oca manire gotimasiogʉ̃ yami. Bʉto masigʉ̃ ñaami. Vãtia bʉto masirã ĩna ñaboajaquẽne, masa ʉsʉrijʉre sãñarãre ĩnare bureamasiami —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","To bajiro Jesús ĩ yiñasere masa ĩna gotibatojare, Galilea sitana tire ajijedicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dios ocare ĩna buerivijʉ ñar'i, budiasuju Jesús, Simón Pedro ya vijʉ vacʉ. Ti vijʉ sãjaejacõari, Pedro ũmañicore ĩañuju. So rujʉ bʉto asicõari, bʉbʉribʉjayuju so. To bajiro so bajijare, Jesús sore ĩ catiosere bojayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","To bajiro ĩna yirone, so tʉ ejarʉ̃gʉ̃cõari, —So rujʉ asise, tʉjaya —yiyuju ĩ. To bajiro ĩ yirone, sore rujʉ asiboase sore tʉjacoasuju. To bajiro sore ĩ yicatiorirĩmarone, vʉ̃mʉrʉ̃gʉ̃cõari, bare ĩnare ecayuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tijʉ bero, rãiorijʉ Jesús tʉjʉ juaejayujarã, rijaye cʉtirãre. To ĩna bajisere ĩacõari, tocãrãcʉre ĩ ãmori ñujeocõari, ĩnare catioyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vãti sãñarãre quẽne juaejayujarã. Ĩnare quẽne, ĩna ʉsʉrijʉ sãñarãre vãtiare bureayuju Jesús. To ĩ yirone, “Dios macʉne ñaami” yimasirã ñari, —Dios macʉ ñaja mʉ —vãtia ĩna yiavasãjare, ĩnare ñagõrotibesuju Jesús, “‘Masa rojose ĩna tãmʉoborotire ĩnare yirẽtobosacõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaami Jesús’ masare yiajioroma” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gajerʉ̃mʉ, busurijʉ, masa manojʉ vacoasuju Jesús, Diore sẽnigʉacʉ. To ĩ bajiboajaquẽne, ti macana, ĩre macasʉya, ejacoasujarã ĩna. Tojʉ ĩre ĩabʉjacõari, —Yʉa rãca tudiaya mʉ. Gãjerã ĩna ñarojʉ vabesa mʉ —ĩre yiboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yicʉdiyuju Jesús: —Tudiabeaja yʉ. Gaje macarianare quẽne, quẽnase quetire goticudirũgũrocʉ ñaja yʉ. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, yʉre ajitirʉ̃nʉña”, ĩnare quẽne yigotimasioroti ñaja. “To bajiro yicudiato” yigʉ, yʉre cõacami Dios —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","To bajiri, gaje macariana jud'io masa Dios ocare ĩna buerivirijʉ sãjacõari, quẽnase quetire gotimasiocudirũgũñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cojorʉ̃mʉ Genesaret vãme cʉtira ʉtabʉcʉra tʉjʉ ñañuju Jesús. To ĩ bajiro ĩacõari, jãjarã masa ejayujarã. Ĩna ejaro ĩacõari, ĩnare gotimasio ñañuju ĩ. To bajiri ĩ gotimasiosere bʉto ajirʉarã ñari, ĩ tʉre jãjarãbʉsa ejayujarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","To bajiri ĩ rʉ̃gõboarijʉre rʉ̃gõbibecõañujarã. To ĩna bajijare, jʉa cũmuari masa maniari jayasere ĩabʉjayuju ĩ. Vai sĩarimasa ĩna bajiyucʉrire coerã ĩna vãgãgoriari ñañuju. Coja ñañuju Pedro yaga. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tia tʉ ñañuju Pedro, vai sĩañar'i ĩ bajiyucʉrire coeñagʉ̃. To bajiri tiare vasãjacõari, —Quẽnaca yʉre ñuviojoya mʉ —Pedrore ĩre yiyuju Jesús. Ĩre ĩ ñuviojoro bero, cũmuajʉ sãñacõari, masare gotimasioñuju quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ĩnare gotimasio gajanocõari, ado bajiro Pedrore ĩre yiyuju: —¡Ʉ̃cʉarojʉ vijajajacõari, mʉa bajiyucʉre rearoderuuya mʉa! —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yicʉdiyuju Pedro: —Yʉa ʉjʉ, jẽjʉ ñami yʉa bajiyucʉre rearoderuu ñamicʉtiboabʉ yʉa. Vai, mama ĩna. To bajiboarine yʉare mʉ rotijare, rearoderuu ĩarʉarãja quẽna —Jesúre yicʉdiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","To bajiri, ʉ̃cʉarojʉ vijajajacõari, ĩna bajiyucʉrire rearoderuucõari, tʉ̃ajãmʉoboayujarã ĩna. Ĩna tʉ̃ajãmʉoboaro, jãjarã ĩna sãjajare, ĩna bajiyucʉri vocoabʉsa bajiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","10","To ti bajijare, gãjerã vai sĩarimasare jiyujarã ĩna, “Yʉare ejarẽmoroaya” yirã. To ĩna yirã, ĩna tʉjʉ ejacõari, ĩna ya cũmuajʉ vaire juasãñujarã ĩna quẽne. Jʉa cũmuajʉne rujarʉabʉsarojʉ yijʉ̃mʉojocõañujarã. Pedro rãcana ñañujarã Zebedeo rĩa, Juan vãme cʉtigʉ, to yicõari, Santiago vãme cʉtigʉ. Jãjarã vai ĩna sãjaro ĩaʉcajedicoasujarã ĩna, ti ũnire ĩabetirũgũriarã ñari. Tire ĩaʉcacõari, Jesús tʉre gʉsomuniari tuetucõari, —Masirẽtogʉ̃ ñaja mʉ. To bajiro yigʉ ñari, quẽnaro yigʉ mʉ ñasere masiaja yʉ. Dios ĩ bojarore bajiro yigʉ me ñaja yʉma. Yʉre baba cʉtirʉabecʉja mʉ, quẽnagʉ̃ ñari —Jesúre yiyuju Pedro. To bajiro ĩ yisere ajicõari, ado bajiro ĩnare yiyuju Jesús: —Yʉre güibeticõaña mʉa. Vai sĩarimasa mʉa ñaserema jẽre moagajanocõaja mʉa. To bajiri yucʉrema masa yʉre ĩna ajitirʉ̃nʉrotijʉare yʉre moabosarã ñarũgũrʉarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","To bajiro ĩ yijare, ĩna cũmuarire vejamocũ, to yicõari, ĩna gajeyeũnire quẽne cũcõa, ĩre sʉyacoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cojorʉ̃mʉ macajʉ Jesús ĩ ñaro, ĩ tʉjʉ ejayuju rijaye cʉtigʉ, ĩ rujʉ jediro gase boagʉ. Jesúre ĩacõari, gʉsomuniari tuetuyuju, ĩre rʉ̃cʉbʉogʉ. To yicõari, ado bajiro Jesúre ĩre yiyuju: —Yʉ ʉjʉ, yʉ cãmire mʉ yarʉajama, yaya —ĩre yisẽniñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","To bajiro ĩre ĩ yisere ajicõari, —Mʉ cãmire yarʉcʉja yʉ —ĩre yigʉne, ĩre moaĩañuju Jesús. To bajiro ĩ yirirĩmarone, ĩ cãmi ĩre yaticoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","To ĩre yigajanocõari, gãjerãre ĩre gotirotibesuju Jesús. To bajiro ĩre yicõari, ado bajiro ĩre yiyuju: —Yucʉacane paire mʉ rujʉre ĩoaya. Mʉ rujʉre ĩre ĩogʉ̃ne, Moisére Dios ĩ roticũmasiriarore bajiro vaibʉcʉrã ecariarãre sĩacõari, paire ĩre ĩsima, Diore rʉ̃cʉbʉogʉ. To mʉ yisere ĩacõari, “Caticoasumi”, yirʉarãma masa —ĩre yiyuju Jesús, gase boaboar'ire. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","To bajiro ĩ yisere masa ĩna masisere ĩ bojabetiboajaquẽne, Jesús ĩ yiñase quetire ajijedicõañujarã. To bajiri, jãjarãbʉsa masa ejarũgũñujarã, Jesús tʉjʉre, ĩ gotisere ajirã, to yicõari, ĩna rijaye cʉtisere ĩre catiorotirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","To bajiro ĩna bajiboajaquẽne, masa manojʉ ĩnare cãmotadiveocoarũgũñuju Jesús, Diore ĩre sẽnigʉ̃ vacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cojorʉ̃mʉ Jesús masare ĩ gotimasio ñarore, fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne ajirujiyujarã ĩna. Ĩna ñañujarã Galilea sita ñarimacariana, to bajicõari, Judea sita ñarimacariana. Gãjerãma, Jerusalén macana ñañujarã. To ĩna ajirujirone, Dios ĩ masise rãca rijaye cʉtirãre ĩnare catioĩoñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","To bajiro ĩ yiñarone, micagʉ̃re ãmiayujarã. Ĩre ãmiadicõari, Jesús tʉjʉ cũrʉaboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","To ĩna yirʉaboarore jãjarã masa ñabibecõañujarã. To bajiri, vijʉre sãjamasibesujarã. “Tire bajicõaja” yirã, vi joejʉ ĩre ãmimʉjasujarã. Ĩre ãmimʉjacõari, Jesús ĩ rʉ̃gõro vecare goje yijorayujarã. To yigajano, micagʉ̃re ĩ jesarijʉ rãcane ĩre jidirujio ejoyujarã, Jesús tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Micagʉ̃re ĩamaicõari, ĩre catiorʉcʉmi Jesús” ĩna yitʉoĩasere ĩamasicõari, micagʉ̃jʉare ado bajiro ĩre yiyuju: —Rojose mʉ yirere mʉre masiriocõaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To ĩ yisere ajicõari, Dios ĩ rotimasire gotimasiorimasa, fariseo masa quẽne, ado bajiro tʉoĩañujarã ĩna: —¿No yigʉ to bajise yati ĩ? To bajiro ĩ ñagõjama, Diore ĩre rʉ̃cʉbʉobecʉ yami. Dios sĩgʉ̃ne ñagʉ̃mi, ti ũnire yimasigʉ̃ma —yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","To bajiro ĩna yitʉoĩasere ĩamasicõari, ado bajiro ĩnare yiyuju Jesús: —“‘Diore bajiro masa rojose ĩna yisere masiriomasiaja’ yisocaami”, yʉre yitʉoĩaboaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Rojose mʉ yirere masiriocõaja” yʉ yicõa tʉjajama, “Socʉ yami. Socʉ me yami”, yʉre yiĩamasigʉ̃ magʉ̃mi. To bajiboarine, micagʉ̃re, “Vʉ̃mʉrʉ̃gʉ̃cõari, vasa” ĩre yʉ yijama, “Socʉ me yami. Rojose ĩ yirere masiriocõami”, yʉre yiĩamasirãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","To bajiri, “‘Dios ĩ roticõacacʉ ñari, Diore bajirone masare rojose ĩna yisere masiriomasigʉ̃ ñaami’ yʉre yiĩamasiato” yigʉ, ãni micagʉ̃re ado bajiro ĩre yaja yʉ: “Vʉ̃mʉrʉ̃gʉ̃ña mʉ. Mʉ jesarijʉre ãmiña. To yicõari, mʉ ya vijʉ tudiasa”, ĩre yaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","To ĩ yirirĩmarone, masa jediro ĩna ĩaro rĩjoro vʉ̃mʉrʉ̃gʉ̃cõari, ĩ jesarijʉre ãmi, ĩ ya vijʉ vacoasuju ĩ yuja. “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽna vasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","To bajiro Jesús ĩ yisere ĩaʉcacoasujarã masa. “Ti ũnire ĩabetirũgũcajʉ mani. Ãni, Dios ĩ masise rãca yigʉ yami” yitʉoĩacõari, “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽnañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Micagʉ̃re catiocõari bero vacoasuju Jesús. To bajivacʉ, Lev'i vãme cʉtigʉre ĩañuju. Ʉjʉre gãjoa sẽnibosarimasʉ ñañuju. Gãjoa sẽnirã ĩna rujirijʉre gãjoa sẽnirujiyuju. To ĩ bajiro, ĩre ĩacõari, ado bajiro ĩre yiyuju Jesús: —Yʉre ajisʉyaya —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","To bajiro ĩ yisere ajicõari, ĩ yere juabecʉne, Jesúre sʉyacoasuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bero, ĩ ya vijʉ ejacõari, Jesúre rʉ̃cʉbʉogʉ, jairo bare quẽnorotiyuju Lev'i. To yicõari, Jesúre, ĩ buerimasare quẽne jiyuju. Ʉjʉre gãjoa sẽnibosarimasare, to yicõari, gãjerãre quẽne jirẽoñuju ĩ. Ĩna ñañujarã “Rojose yirã ñaama” masa ĩna yiĩarã. To bajiri, jãjarã ñañujarã ĩ jirẽoriarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","To bajiri, Jesúrãca ĩna bañarone, ejayujarã fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne. Ĩna ñañujarã, Moisére Dios ĩ roticũmasirere bʉto ajirʉ̃cʉbʉorã, rojose yirã rãca ñarʉamena. To bajiri, ĩna bañarojʉ ejacõari, ado bajiro Jesús buerimasare ĩnare sẽniĩañujarã: —¿No yirã ãnoa rojose yirã rãca bati mʉa? —ĩnare yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Catiquẽnarãma, ʉco yigʉre bojamenama. Rijaye cʉtirã rĩne ĩre bojarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","To bajiro bajiaja yʉre quẽne. “Rojosere yirã me ñaja yʉa” yirãma, yʉre bojamenama. “Rojose yirã ñaja yʉa” yirã rĩne yʉre bojarãma. Quẽnase yirãre jigʉagʉ me, adi macarʉcʉrojʉre vadicajʉ yʉ. Rojosere yirã, “Rojose ĩna yisere yitʉjato” yigʉ, vadicajʉ yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","To ĩ yiro bero, Jesúre sẽniĩañujarã sĩgʉ̃ri: —Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ buerimasa, to yicõari, fariseo masa quẽne, mani ñicʉa ĩna yimasiriarore bajiro Diore ĩna sẽnirirʉ̃mʉrirema bare babetirũgũama. ¿No yirã tire yibeati mʉ buerãma? —Jesúre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","To ĩna yisere ajicõari, ado bajiro ĩnare gotimasioñuju Jesús: —Sĩgʉ̃ ĩ ãmosiarirʉ̃mʉre ĩre variquẽnaejarẽmorã ñarãma. To ĩ ũmato yiñaro cõro ĩre variquẽnaejarẽmocõa ñarãma. Ĩnare bajiro bajiama yʉ buerã. Yʉ rãca ñari, variquẽnacõa ñaama. “Sʉtiritimena ñari, no yirã bare babeticõa yimenama” yimasire ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","To bajiboarine, cojorʉ̃mʉ yʉre ĩna ñiavato ĩacõari, bare bamenane Diore sẽnirũgũrʉarãma, “Mani sʉtiritisere ĩacõari, quẽnaro manire ejarẽmoato Dios” yirã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","To yicõari, quẽna gaje gotimasiore queti ado bajise ĩnare gotirẽmoñuju Jesús: —Mame oca yʉ gotimasiose ricati ti ñajare, yʉ ye rãca mani ñicʉa ĩna yimasirere mʉa tʉoĩavʉojama, quẽnabeaja. Sudiro bʉcʉase ti vojama, sudiro mamasere voãmicõari, tiatumenaja mani, bʉcʉase vorijʉre. To bajiro mani yijama, sudiro mamasere yirojocõarãja mani. To bajicõari, bʉcʉase rãca quẽnaro ruyubetoja mamaseagajʉ rãca mani tiaturijʉ ñari. To bajiri bʉcʉase, mamase rãca mani tiavʉobetore bajiro, mame oca yʉ gotimasiosere, mani ñicʉa oca rãca tʉoĩavʉobesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","To bajirone bajiaja ʉye oco quẽne. Mame ʉye ocore, vaibʉcʉgaserone quẽnoriajoa bʉcʉjoajʉare jiomenaja mani. Bʉcʉjoajʉre mani jiojama, jãmʉsĩnituca yiro, yivocõaroja tijoajʉare. To bajiro mani yijama, ʉye ocore, vaibʉcʉgaserone quẽnoriajoare quẽne to bajirone yireacõa tʉjana yirãja mani. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“To bajirobe” yirãma, mame ʉye ocore vaibʉcʉgaserone quẽnoriajoa, mamajoajʉare jiore ñaroja. To yicõari, ʉye oco, vaibʉcʉgaserone quẽnoriajoa quẽne, cojoro cõro quẽnaro ñarʉaroja. To bajiri mame ʉye ocore, bʉcʉjoajʉre mani jiobetore bajiro mame oca yʉ gotimasiosere, mani ñicʉa oca rãca tʉoĩavʉobesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","To bajiro mʉare yaja yʉ, ado bajiro ti bajijare: Mani gotise queti ado bajiro bajiaja: “Ʉye oco tirʉ̃mʉjʉ ĩna quẽnorere idirũgũrãma, ʉye oco mame ĩna quẽnose idirʉamenama, ‘Tirʉ̃mʉaye ĩna quẽnorejʉa quẽnaja’ yirã”, yigotiaja mani gotise. To bajirone bajiaja mame oca yʉ gotimasiose quẽne. Jãjarã tirʉ̃mʉaye ocare ajirʉ̃cʉbʉosejarãma, mame oca yʉ gotimasiosere ajiterãma, “Tirʉ̃mʉaye ocajʉa quẽnaja” yirã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ʉsʉsãjariarʉ̃mʉ ti ejaro, trigo oteriavese cʉtore vasujarã, Jesúrãca. To bajivanane, trigo ricare tũnejuacõari, ĩna ãmorine ti gasere sĩguẽreacõari, bayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tire ĩna basere ĩacõari, sĩgʉ̃ri fariseo masa ado bajiro ĩnare yiyujarã: —Ʉsʉsãjariarʉ̃mʉ yire mere yaja mʉa —ĩnare yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —¿David ñamasir'i, ĩ babarã rãca ñiorijacõari, ĩnare ĩ ũmato bamasirere masibeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ñiorijarã ñari, “Mani rãca ñagʉ̃mi Dios” masa ĩna yirivijʉre sãjacõari, Diore ĩre rʉ̃cʉbʉorã pan gãjerã ĩna cũboarerene juacõari, ĩ babarã rãca bamasiñuju ĩ. To bajiri Moisés ñamasir'i ĩ gotimasirema, “Paia rĩne barʉarãma” ĩ yimasiboarerene bamasiñujarã ĩna. To bajiro ĩna yiboajaquẽne, ti vaja rojose ĩnare yibetimasiñumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yʉ, Dios ĩ roticõacacʉ, “Ʉsʉsãjariarʉ̃mʉre ado bajiro mʉa yijama, quẽnaja. To bajirojʉa mʉa yijama, quẽnabeaja”, yirotigʉ ñaja yʉ —ĩnare yicʉdiyuju Jesús, fariseo masare. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gaje semana gaja, ʉsʉsãjariarʉ̃mʉ ti ejaro, Dios ocare ĩna buerivijʉ tudivasuju Jesús quẽna. Sãjacõari, toanare gotimasioñuju. Ti vijʉ ñañuju sĩgʉ̃, riojojacatʉa ãmo ñujobecʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dios ĩ rotimasire gotimasiorimasa, to yicõari, fariseo masa quẽne ñañujarã. “‘Jesús, rojose yimi’ ʉjarãre ĩre yigotiyirorãsa” yirã, Jesúre ĩre ĩacodeyujarã ĩna. “Adirʉ̃mʉ ʉsʉsãjariarʉ̃mʉre ãni ãmo ñujobecʉre ĩ masise rãca ĩ ñujorotijama, ‘Dios, Moisére ĩ roticũmasirere cʉdibecʉ yimi’ yigotirʉarãja mani”, yitʉoĩañujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","To bajiro ĩna yitʉoĩasere ĩamasicõañuju Jesús. To bajigʉ ñari, ado bajiro yiyuju, ãmo ñujobecʉjʉare: —Vʉ̃mʉrʉ̃gʉ̃ña —ĩre yiyuju. To ĩ yirone, vʉ̃mʉrʉ̃gʉ̃ñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","To bajiro ĩre yicõari, Dios ĩ rotimasire gotimasiorimasare, to yicõari, fariseo masare quẽne ado bajiro ĩnare sẽniĩañuju Jesús: —¿Ʉsʉsãjariarʉ̃mʉre quẽne, no bojagʉ masʉre quẽnaro mani yijama, quẽnabetojari? ¿Disejʉare yiroti ñati? ¿Quẽnasejʉare, rojosejʉare yiroti ñati ti? ¿Rijaye cʉtirãre catiorejʉare yiroti ñatique? To yiterã, ¿ĩnare sĩacõaroti ñatique? —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ĩ sẽniĩasere ĩna cʉdisere ajirʉ, tocãrãcʉrene ĩnare ĩaboayuju. Ĩna cʉdibeto ĩaboacʉ, ado bajiro ĩre yiyuju, ãmo ñujobecʉjʉare: —Mʉ ãmore ñujoya mʉ —ĩre yiyuju Jesús. To ĩ yirone, ĩ ãmore ĩ ñujorone, quẽnaejacoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","To bajiro ĩre ĩ yijare, Jesúre bʉto jũnisiniñujarã ĩna Dios ĩ rotimasire gotimasiorimasa, to yicõari, fariseo masa quẽne. “¿No bajiro yicõari, Jesúre sĩarotirãti mani?”, gãmerã yiñagõñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cojorʉ̃mʉ burojʉ majasuju Jesús, Diore sẽnigʉacʉ. Tojʉ Diore sẽni ñamicʉtibusuocoasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ĩ sẽni busuorirʉ̃mʉre, ĩ buerimasare jirẽoñuju Jesús. To bajiri ĩ tʉ ĩna ejarone, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã ĩnare beseyuju, ĩ ocare goticudibosaronare. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Ado bajiro vãme cʉtirã ñañujarã: Simón vãme cʉtiboar'i Pedro vãme cʉtigʉ, ĩ bedi, Andrés ñañujarã. Santiago, Juan, Felipe, Bartolomé, Mateo, Tomás ñañujarã. Alfeo macʉ, Santiago, to yicõari, Simón vãme cʉtigʉ, celote yere tʉoĩaboar'i ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiago macʉ, Judas vãme cʉtigʉ ñañuju. Tʉsagʉ Judas Iscariote vãme cʉtiyuju. Ĩ ñañuju Jesúre ĩsirocar'i. To bajiri jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñañujarã Jesús ĩ beseriarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ĩ beseriaro bero, ĩna rãca rojaejayuju ĩ, rujatũcurorijʉ. Tojʉ gãjerã Jesús buerimasa ĩre ñayuyujarã ĩna. Judea sita ñarimacariana, gãjerãma, Jerusalén macana ñañujarã. Gãjerã moa riaga tʉana, Tiro macana, to yicõari, Sidón macana quẽne ñañujarã ĩna. Ĩ gotimasiosere ajirʉarã, to yicõari, ĩ catiosere bojarã, ĩre ñayuyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ĩna ʉsʉrijʉre vãtia sãñarã ñari, rojose tãmʉorã quẽne ñañujarã. Ĩna ʉsʉrijʉre sãñarãre vãtiare bureayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","To yicõari, tocãrãcʉ rijaye cʉtirãre quẽne catioyuju. To bajiro ĩ yisere ĩacõari, masa jediro ĩre moaĩarʉayujarã, “Manire quẽne catioato” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ĩnare catiogajano, ĩ buerimasare ĩacõari, ado bajiro ĩnare gotiyuju ĩ: —“Masimena ñari, mʉ ejarẽmose bʉto bojaja yʉa”, Diore ĩre yisẽnirũgũrãma, ĩ yarã ñarãma. To bajiri, rojose tãmʉoboarine, Dios tʉjʉ variquẽnarona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yucʉrire Dios ĩ bojabetire yicõari, tʉoĩasʉtiritiñarã quẽne, variquẽnarona ñarãma, berojʉ ĩna tʉoĩasʉtiritisere Dios ĩnare ĩ yirẽtobosaroti ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dios ĩ roticõacacʉre, yʉre mʉa ajitirʉ̃nʉse sʉorine gãjerã mʉare ajatud'icõari, “Rojorã ñaama” mʉare ĩna yisocaboajaquẽne, variquẽnarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","To bajiro mʉare ĩna yiboajaquẽne, bʉto variquẽnaña mʉa, “Berojʉ Dios tʉjʉ ejarã, quẽnase bʉjarʉarãja” yimasirã ñari. Mʉa rĩjoroana, Diore gotirẽtobosamasiriarãre quẽne, rojose mʉare ĩna yirore bajirone ĩnare quẽne rojose yimasiñujarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gãjerãma, gajeyeũni jairo cʉovariquẽnarã ñari, Diore bojamena ñarãja mʉa. Adigodojʉ variquẽnarã ñaboarine, berojʉma sʉtiritirʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gãjerãma, “Disejʉa yʉare rʉyabeaja” yivariquẽnarã ñari, Diore bojamena ñarãja mʉa. Adigodojʉre variquẽnarã ñaboarine, berojʉma variquẽnabetirʉarãja mʉa. Gãjerãma, mʉa rijato bero mʉa bajirotire tʉoĩamenane, adigodoayere tʉoĩacõari ajarãma, berojʉ, otirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Masa, “Quẽnaro yirã ñaama” mʉare ĩna yisere ajicõari, variquẽnaboaja mʉa. To bajirone bajimasiñuju tirʉ̃mʉjʉ. “Diore gotirẽtobosarimasa ñaja yʉa” yitomasiriarãre, “Quẽnaro yirã ñama” ĩnare yirʉ̃cʉbʉomasiboayujarã mʉa ñicʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yʉre ajitirʉ̃nʉrãre ado bajise mʉare rotiaja yʉ: Mʉare ĩaterãre quẽne ĩamaiña. Ĩnare ĩamaicõari, quẽnaro yiya. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rojose mʉare yirãre quẽne quẽnaro ĩna ñarotire, Diore ĩnare sẽnibosaya mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cojojacatʉa, mʉa vayujuare ĩ jajama, gajejacatʉare quẽne ĩre jarotiya. Sĩgʉ̃, mʉa sudirore joeagarore ĩ veaãmijama, jubeagarore quẽne ĩre veaĩsicõaña. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","No bojarã mʉa gajeyeũnire ĩna sẽnijama, ĩsiña. Mʉa gajeyeũnire juarudigʉre, “Yʉre tʉoya”, ĩre yibesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gãjerã quẽnaro mʉare ĩna yisere bojaja mʉa. To bajiri quẽnaro mʉare ĩna yisere bojarã ñari, quẽnaro ĩnare yiya mʉa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mʉare ĩamairã rĩne mʉa ĩamaijama, ¿“Quẽnaro yaja mʉa”, mʉare yiĩagʉ̃jari Dios? Yibecʉmi. Rojose yirã quẽne, ĩnare mairã rĩrene ĩnare ĩamairũgũrãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Quẽnaro mʉare yirã rĩrene quẽnaro mʉa yijama, ¿“Quẽnaro yaja mʉa”, mʉare yiĩagʉ̃jari Dios? Yibecʉmi. Rojose yirã quẽne, quẽnaro ĩnare yirã rĩrene quẽnaro yirũgũrãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mʉare tʉomasirã rĩrene no bojasere mʉa vasoajama, ¿“Quẽnaro yaja mʉa”, mʉare yiĩagʉ̃jari Dios? Yibecʉmi. Rojose yirã, ĩnare tʉomasirã rĩrene ĩna sẽnisere ĩnare ĩsirãma ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","To bajiri ado bajiro mʉare gotiaja yʉ: Mʉare rojose yirãre quẽne, ĩnare maiña mʉa. Ĩnare quẽne quẽnaro yiya. “Mani ĩsisere manire tʉorʉarãma” yitʉoĩamenane, ĩnare ĩsiña. To bajiro ĩnare mʉa yijama, quẽnamasusere mʉare ʉjorʉcʉmi Dios. “Quẽnaro yaja mʉ” Diore yimenarene, to yicõari, rojose yirãre Dios ĩ mairore bajirone mʉa maijama, “Dios rĩa ñaja yʉa” yiĩorã yirãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mani jacʉ Dios ĩ ĩamairore bajirone mʉa quẽne, masare ĩamaiña —ĩ buerimasare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Quẽna ado bajiro gotiyuju Jesús: —“Rojose yirã, ñaama. To bajiro yirã ñari, rojose tãmʉorʉarãma”, gãjerãre ĩnare yiĩabesebesa. To bajiro mʉa yijama, “Rojose yirã ñaama”, mʉare yiĩaromi Dios. Gãjerã rojose mʉare ĩna yisere mʉa masiriojama, rojose mʉa yisere mʉare masiriorʉcʉmi Dios quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","No bojase ĩna cʉobetijama, ĩnare ĩsiña. To bajiro mʉa yijama, ĩnare mʉa ĩsirere ĩacõĩacõari, mʉa ĩsise rẽtobʉsaro mʉare ĩsirʉcʉmi Dios —ĩre ajitirʉ̃nʉrãre yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","To yigʉne, adi gotimasiore quetire ĩnare gotiyuju: —Sĩgʉ̃ ĩabecʉ, gãji ĩabecʉre ĩ tʉ̃avajama, gojejʉ reasãcõanama, ĩna jʉarãjʉne. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gajeyerema, ĩnare buegʉ rẽtobʉsaro masirã me ñaama ĩ buerã. To bajiboarine quẽnaro ĩna buejeocõajama, ĩnare buerimasʉre bajirone masirãma ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Gajeyerema, ado bajiro yirãre bajiro yaja mʉa: Gãji bʉto rojose ĩ yibetiboajaquẽne, “Mʉ cajeare sũjuriroaca sãñaja. Tijʉacare ãmirocato” yirãre bajiro yaja mʉa. Tire bʉto ĩatirʉ̃nʉrã ñaboarine, mʉa cajeajʉre jairisũjuro sãñarijaʉre tijaʉre “Ãmirocaya”, yimasibeaja mʉa, “Bʉto rojorã ñaja yʉa” yitʉoĩamasimena ñari. Mʉa rãcagʉ ĩ yisejʉare ĩacõari, “Riojo tʉoĩabeaja mʉ. ‘Quẽnasejʉare tʉoĩavasoaya’ yirã, riojo mʉre gotirʉarãja” yigotirã ñaboarine, “Adi ñaja quẽnase. Tijʉa ñaja rojose”, yimasimenaja, ĩ rẽtoro rojose yirã ñari. “Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojorã ñaja mʉa. “Bʉto rojorã ñaja yʉa” mʉa yitʉoĩamasiro berojʉ, mʉa rãcagʉre ejarẽmomasirãja mʉa, “Quẽnaro riojo ñato ĩ” yirã —ĩ buerãre ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Gajeyerema, yucʉ́ vãnʉricʉ, “Quẽnase rica cʉtiricʉ ñaja” mani yiboaricʉne, quẽnabeti rica cʉtibetoja. To yicõari, vãnʉbeti, “Quẽnabeti rica cʉtiricʉ ñaja” mani yiboaricʉne, quẽnase rica cʉtibetoja. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ti rica cʉtise sʉorine yucʉ́re ĩamasiaja mani. Quẽnase bare higos vãme cʉtiʉ ricare juaroana, vãtijota yucʉ́rijʉre macamenaja mani. To yicõari, ʉye juaroana, vidirojʉ ñaricʉ savajotaʉjʉre macamenaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","To bajirone bajiaja masare quẽne. Sĩgʉ̃ri quẽnase tʉoĩarã ñari, quẽnase yirãma. Gãjerã, rojose tʉoĩarã ñari, rojose yirãma. To bajiro bajiaja mʉa ñagõse quẽne. Masa ĩna ñagõsere ajicõari, “Rojose tʉoĩarã ñaama. Quẽnase tʉoĩarã ñaama”, yimasiaja mʉa. To bajiri ĩna ʉsʉrijʉ ĩna tʉoĩabʉjʉoñaserene, ĩna riserijʉ ñagõburũgũama ĩna —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Quẽna ado bajiro ĩnare yiyuju Jesús: —¿No yirã yʉ rotisere cʉdibetiboarine, “Yʉa ʉjʉ” yʉre yati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yʉ gotimasiosere ajicõari, yʉ rotirore bajiro yigʉma, ado bajiro yigʉ ũgʉ̃re bajiro bajigʉ ñagʉ̃mi: ");
INSERT INTO bsnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ĩ ũgʉ̃ ñagʉ̃mi gʉ̃tajãijʉ gojeri coaejocõari, botari rʉ̃gõcõari, vi bʉagʉre bajiro bajigʉ. Vi ĩ bʉaro bero, bʉto oco quediroja. To bajicõari, riaga jaicoatoja. Ti vijʉ ti jaiejacoaboajaquẽne, juriaquedibetoja ti vi. ");
INSERT INTO bsnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yʉre ajiboarine, yʉ rotirore bajiro yibecʉjʉa ñagʉ̃mi sita vajarojʉ vi bʉagʉre bajiro bajigʉ. Ti vi ĩ bʉaro bero, bʉto oco quediroja. To bajicõari, riaga jaicoatoja. Ti vijʉre ti jaiejarone, yoaro mene juriaquedicoatoja —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gotimasiore queti ĩnare gotigajanocõari, Capernaum vãme cʉti macajʉ vasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ti macajʉre ñañuju romano masʉ. Surara ʉjʉ ñañuju ĩ. Ĩre moabosarimasʉ, ĩ maigʉ̃, bʉto rijayuju. Bajirocacʉjʉ yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","To bajiri ti macajʉ Jesús ĩ vadire ajicõari, “Ĩre catiogʉ vadiato Jesús” yigʉ, jud'io masa bʉcʉrãre ĩnare cõañuju ĩ, “Ĩre jiaya” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","To bajiri Jesús tʉjʉ ejacõari, ado bajiro ĩre yisẽniñujarã ĩna: —Yʉa tʉagʉ, romano masʉ, surara ʉjʉ, ĩ queti cõarã bajiaja yʉa. “Vadiato Jesús. Yʉ maigʉ̃, yʉre moabosagʉ, bʉto rijaami. To bajiri rijacʉ yami. Ĩre catiogʉ vadiato” ĩ yijare, bajibʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mani yarã, jud'io masare maiami. To bajiri ĩne Dios ocare yʉa buerotivire bʉaroticami. To yigʉ ĩ ñajare, ĩre sẽnibosarã bajibʉ yʉa. ¿Ĩre moabosagʉre catiogʉ varʉabeati mʉ? —Jesúre yisẽniñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","To bajiro ĩna yijare, ĩna rãca vacoasuju Jesús. Ĩ cõñatone, gãjerã ʉjʉ ĩ cõariarã ĩre bocayujarã ĩna. Ĩre bocacõari, ado bajise ĩre queti gotiyujarã ĩna: —“Yʉ ʉjʉ, quẽnagʉ̃ ñaja mʉ”, mʉre yami romano masʉ. “Yʉma, rojose yʉ yisere tʉoĩabojonegʉ̃ ñari, yʉ ya vire ĩre sãjarotimasibecʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","To bajiri, ĩre boca bojoneaja yʉ”, mʉre yami. No yigʉ sãjabecʉja mʉ. “Sãjabetiboarine, ĩ ñagõtʉoĩasene catiomasicõagʉ̃mi”, mʉre yami. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Gãjerã surara ʉjarã beroagʉ ñaja yʉ. To bajiri, yʉ quẽne, gãjerã surarare rotigʉ ñaja yʉ. Sĩgʉ̃re, ‘¡Vasa!’ yʉ yijama, vajami. Gãjire, ‘Vayá’ yʉ yijama, vadiami. To yicõari, yʉre moabosarimasʉre, ‘Tire yiya’ yʉ yijama, yirũgũami. To bajiri, ĩ roque rotigʉ masu ñari, adojʉ sãjadibetiboarine, ĩ ñagõtʉoĩasene caticoarʉcʉmi”, mʉre yami —Jesúre yiyujarã ĩna, romano masʉ ĩ gotirotirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","To bajiro ĩ yirere ajicõari, no yimasibesuju Jesús. To bajiri, jʉdarʉ̃gʉ̃cõari, jãjarã ĩre sʉyarãre ado bajiro ĩnare gotiyuju: —Riojo mʉare gotiaja yʉ. Israel ñamasir'i jãnerabatia yʉ yarã ñaboarine, “Masigʉ̃, to yicõari, quẽnagʉ̃ ñari, yʉre yirẽmorʉcʉmi” romano masʉ yʉre ĩ yitʉoĩarore bajiro tʉoĩagʉ̃re ĩabetirũgũaja yʉ —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","To bajiro ĩ yiro bero, romano masʉ ĩ gotirotiriarã, vijʉre sãjacõari, ĩna ĩajama, ĩre moabosagʉre catiquẽnagʉ̃ ñagʉ̃re ĩre ĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","To ĩ yiriaro bero, gaje macajʉ vasuju Jesús, Na'in vãme cʉti macajʉ. Ĩ buerã quẽne gãjerã quẽne, jãjarã masa ĩ rãca vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti macajʉ ĩna ejaro, bajirocar'i rujʉrire gajavayujarã ĩna, ĩre yujeroana. Jãjarã masa ĩna rãca vayujarã ĩna. Ĩ ñaboar'i jaco quẽne, vayuju. Manajʉ rijaveorio ñañuju so. Sĩgʉ̃ne macʉ cʉtirio ñari, bʉto otiyuju. So oti vadone sore bocayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sore ĩamaicõari, —To cõrone otitʉjaya mʉ —sore yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","To yicõari, so macʉ rujʉri ĩna gajarijotire ĩ moaĩaejarʉ̃gʉ̃rone, tujarʉ̃gʉ̃cõañujarã ĩna. Ĩna tujarʉ̃gʉ̃rone, —“Vʉ̃mʉrũjuña” mʉre yaja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","To ĩ yirone, vʉ̃mʉrũjuri, ñagõñuju ĩ yuja, bajirocar'i. To ĩ bajiro ĩacõari, ĩ jacore tʉ̃aĩsiñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ĩre ĩ catiosere ĩacõari, güiyujarã masa, ti ũnire ĩabetirũgũriarã ñari. To bajirã ñari, —Diore gotirẽtobosarimasʉ ñamasugʉ̃ mani tʉjʉre ejaami yuja. Ĩ yarã mani ñajare, manire ĩamaicõari, Jesús sʉorine manire ejarẽmoami Dios —Diore yirʉ̃cʉbʉo variquẽnañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","To bajiro Jesús ĩ yisere ajijedicõañujarã ĩna, Judea sitana. Ti sita sojʉana quẽne, tire ajiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús ĩ yiñasere masijeocõañuju, Juan, ĩ buerimasa ĩna gotise ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tire ĩre ĩna gotiro bero, jʉarã ĩ buerãre sẽniĩaroticõañuju Juan: —Jesúre, “¿Mʉne ñati, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i, ‘Yʉ bero ejarʉcʉmi’ Juan ĩ yigotimasiocacʉ? ¿Gãjire yuroti ñatique maji?”, Jesúre yisẽniĩaaya —ĩnare yicõañuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","To bajiro ĩ yicõariarã, Jesús tʉ ejacõari, ado bajiro ĩre sẽniĩañujarã ĩna: —Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ buerã ñaja yʉa. “Ĩre sẽniĩaaya” ĩ yicõajare vabʉ yʉa. ¿Mʉne ñati, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i, “Yʉ bero ejarʉcʉmi” Juan ĩ yigotimasiocacʉ? ¿Gãjire yuroti ñatique maji? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","To bajiro ĩna yisẽniĩarã ejarone, jãjarã rijaye cʉtirãre catioĩoñuju Jesús. Masa ʉsʉrijʉ sãñarãre vãtiare quẽne bureaĩoñuju. To yicõari, caje ĩamenare quẽne ĩnare ĩarotiĩoñuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","To bajiri, Juan ĩ cõariarã ĩna sẽniĩasere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Ado bajiro Juanre gotiba mʉa: “Jesús ĩ masise rãca ĩ yijare, ĩabetiboariarã quẽne ĩama. Rujasagueri vaboariarã quẽne, quẽnaro vama. Gase boariarãre quẽne, ĩna cãmi yatibʉ. Ajimena ñaboariarã quẽne, ajima. Bajireariarã quẽne, tudicatima. To yicõari, maioro bajirãre quẽne, Dios oca quẽnasere gotimasio ecoma ĩna”, yigotiba, Juan tʉjʉ ejacõari. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","To bajiri, “‘Quẽnase bʉjarʉarãma yʉre ajitirʉ̃nʉrã, “Socʉ me yami”, yʉre yitʉoĩarãma’ yimi”, ĩre yigotiaya —ĩnare yiyuju Jesús, Juan ĩ sẽniĩarotiriarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","To bajiro ĩ yisere ajicõari, ĩna vase rãcane, Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ ĩ ñare quetire gotiyuju Jesús, jãjarã ĩre ajisʉyarãre: —Yucʉ́ manojʉ vana, ¿ñimʉ ũgʉ̃re tʉoĩa vacati mʉa? ¿Masa ĩna bojasere bajiro yirʉa tʉoĩagʉ̃re ĩarã vacati mʉa? “To bajiro tʉoĩagʉ̃ me ñacami”, yimasiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ñimʉ ũgʉ̃re tʉoĩarã vacati mʉa? ¿Quẽnase sudi sãñagʉ̃re tʉoĩa vacati? To bajiro me tʉoĩariarãja mʉa. “Quẽnase sudi sãñarãma, quẽnarivirijʉ, ʉjarã ya virijʉ ñarãma”, yimasiaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ñimʉ ũgʉ̃re tʉoĩa vacati mʉa? ¿Diore gotirẽtobosarimasʉre tʉoĩa vacatique mʉa? Riojo mʉare gotiaja yʉ. Gãjerã Diore gotirẽtobosarimasa rẽtoro ñagʉ̃re ĩariarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan ĩ bajirotire gotiro, ado bajise gotiaja Dios oca masa ĩna ucamasire: “‘“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, mʉre yʉ cõaroto rĩjoro, mʉre gotiyurocʉre cõasʉorʉcʉja yʉ maji’ yami Dios. ‘Ĩ ñarʉcʉmi ado bajise gotirocʉ: “Yoaro mene ejarʉcʉmi, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ. To bajiri rojose Dios ĩ bojabetire yitʉjacõari, ĩ bojasejʉare yi yuya mʉa” yigotirocʉ ñarʉcʉmi’ yami Dios”, yigotiaja Dios oca masa ĩna ucamasire. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Diore gotirẽtobosarimasa ĩna gotimasire rẽtoro ñamasuse ñaja, Juan, Diore ĩ gotirẽtobosasejʉa. To bajiro ti bajiboajaquẽne, Juan ĩ gotise rẽtoro ñamasuse ñaja yʉ gotiroticõarã ĩna gotise. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, Jesúre ajitirʉ̃nʉña” ĩna yigotisere yaja yʉ. Ñamasurã ñaama, “Ñamasurã me ñaama Jesús ĩ gotiroticõarã” mʉa yiĩaboajaquẽne —ĩ rãca ñarãre ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juan ĩ gotimasiorere ajitirʉ̃nʉñujarã ĩna, ʉjʉre gãjoa sẽnibosarimasa. Gãjerã quẽne, jãjarã ĩre ajitirʉ̃nʉñujarã ĩna. “Mʉ gotirore bajirone bajiaja. Rojose yirã ñaja yʉa” yitʉoĩacõari, Juanre bautizarotiyujarã ĩna, Diore rʉ̃cʉbʉorã. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ĩna bautizarotiboajaquẽne, fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne, Juan ĩ gotisere ajicõari, “Bajibeaja ti”, yitʉoĩañujarã ĩnajʉama. Dios ĩ bojasere yirʉabesujarã. To bajiri Juanre bautizarotibesujarã ĩnama. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Quẽna ado bajiro ĩnare gotiyuju Jesús: —Ado bajiro yirãre bajiro yirã ñarãja mʉa, adirodoriana: ");
INSERT INTO bsnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Daquerã, gãjerã rãca ajerʉamenare bajiro yirã ñarãja. Ĩna ajeritũcurojʉ rujicõari, gãjerãjʉare, ado bajiro ĩnare gotirujirãma: “‘Basavariquẽnato mani’ yirã, mʉare jutibosaboabʉ yʉa. To bajiro yʉa yiboajaquẽne, basabejʉ mʉa. To bajiri, ‘Rijariarãre bʉcʉrã ĩna oticatore bajiro sʉtiriose boca otirʉarãja mʉa, yʉa basañarone’ yiboabʉ yʉa. To yʉa yiboajaquẽne, otibejʉ mʉa”, ĩnare yigotirãma, ĩna rãca ajerʉamenare. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ĩna rãca ajerʉamenare bajiro yirã ñarãja mʉa, adirodoriana. Juan, quẽnase bare babeti, quẽnase idire idibeti bajiñañuju ĩ. To bajiro bajigʉ ĩ ñajare, “Vãti sãñagʉ̃ ñagʉ̃mi”, ĩre yitʉoĩacajʉ mʉa, ĩre ajiterã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ĩ bero gotimasiosʉocajʉ yʉ, Dios ĩ roticõacacʉ. Yʉjʉama, quẽnase bare ba, quẽnase idire idi bajiñaja yʉ. To bajiro yigʉ yʉ ñajare, “Jairo bagʉ ñaami. Idimecʉgʉ̃ ñaami. Ʉjʉre gãjoa sẽnibosarimasa, gãjerã rojose yirãre quẽne ĩnare baba cʉtiami”, yʉre yiĩajũnisiniaja mʉa, yʉre quẽne ajiterã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","To bajiro Juanre quẽne, yʉre quẽne mʉa yise ti ñaboajaquẽne, Dios ĩ masise rãca yʉa yise ti ñajare, berojʉ, “Quẽnaro yirã yiboayuma”, yʉare yimasirʉarãja mʉa —ĩ rãca ñarãre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sĩgʉ̃ fariseo masʉ ñañuju ĩ, Simón vãme cʉtigʉ. “Bare bagʉ vaja”, Jesúre yiyuju ĩ. To bajiro ĩ yijare, ĩ tʉjʉ vasuju Jesús. Sãjaejacõari, barujiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti macajʉ rõmio ñañuju rojose yigo. To bajiri, Simón ya vijʉ bare bagʉ Jesús ĩ ejasere ajicõari, gʉ̃ta sotʉ alabastro vãme cʉti rãca veariarʉ ãmiejayuju so. Sʉtiquẽnase sãñaritʉ ñañuju tirʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesús gʉbori veca ejarʉ̃gʉ̃cõari, otiyuju so. So otirone, so caje oco reajeoyuju ti, ĩ gʉborire. To yicõari, so joa ñajone tire vejacaroyuju. Tire vejacarocõari, ĩ gʉborire usuyuju. To yicõari, sʉtiquẽnase so juadirere Jesús gʉbori joere yuejeoyuju. Ĩre rʉ̃cʉbʉogo yiyuju, to bajiro so yijama. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","To bajiro so yiro ĩacõari, ado bajiro tʉoĩañuju Simón, Jesúre, “Bare bagʉaba” ĩre yir'ijʉa: “Diore gotirẽtobosagʉ masu ĩ ñajama, iso rõmiore, ‘Rojose yigo ñaamo’ yiĩamasicõari, sore moaĩarotibetibogʉmi”, yitʉoĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","To bajiro Simón ĩ tʉoĩasere masicõari, ado bajiro yiyuju Jesús: —Gotimasiore queti mʉre gotigʉagʉ yaja yʉ. To ĩ yirone, —Yʉre gotiya —Jesúre ĩre yicʉdiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","To bajiro ĩ yicʉdirone, ado bajiro ĩre gotiyuju Jesús: —Ʉ̃mʉa jʉarã ñarãma ĩna, gãjijʉare gãjoa vasoariarã. Sĩgʉ̃, jʉa cʉ̃ma moaroto cõro vaja mogʉ̃mi ĩ. Gãjijʉama, jʉarã muijua moaroto cõro vaja mogʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gãjoa tʉorʉaboarãma ĩna, bajirãjʉma. To bajiri ĩna gãjoa mano ĩacõari, “Tone bajicõato. Yʉre mʉa vaja mosere mʉare masiriocõaja yʉ”, ĩnare yigʉmi, ĩnare maigʉ̃ ñari. To bajiri, ado bajiro mʉre sẽniĩaja yʉ: Gãjoa vasoariarãre ĩnare ĩ masiriore ñajare, ¿nijʉa bʉto ĩre maigʉ̃jari? —ĩre yisẽniĩañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","To bajiro ĩre ĩ yisẽniĩarone, —Yʉ tʉoĩajama, jairo ĩre vaja mor'ijʉa, bʉto ĩre maigʉ̃mi —ĩre yicʉdiyuju Simón. To ĩ yirone, —Riojo yaja mʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","To yigoticõari, rõmiojʉare sore ĩagʉ̃ne ado bajiro Simónre yiyuju Jesús: —¿Adiore ĩati mʉ? Yʉre jiboarine, mʉ ya vi yʉ ejaro, yʉ gʉborire yʉ coerotire oco yʉre ĩsibejʉ mʉ. To bajiboarine adioma so caje oco rãca yʉ gʉborire coemo soma. To yicõari, so joa ñajone yʉ gʉborire vejacoecaromo so. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Yʉre sẽnigʉ̃ne, ejarãre mani yarã ĩna yirũgũrore bajiro yʉre usubejʉ mʉ. To bajiro mʉ bajiboajaquẽne, sãjaejagone yʉ gʉborire so usurojʉne usutʉjabeticõa ñaamo adioma, yʉre rʉ̃cʉbʉogo. Mʉma, yʉ rʉjoa joere ʉye sʉtiquẽnase yʉre yuejeobejʉ mʉ. Yʉre rʉ̃cʉbʉobecʉ ñari, bajibʉ mʉ. To mʉ bajiboajaquẽne, sojʉama, ʉye sʉtiquẽnase jairo vaja cʉtisere yʉ gʉbori joere yuejeoamo so. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","To bajiri quẽnaro ajiya mʉ. Bʉto yʉre so maisere yiĩomo so. Tire ĩacõari, ado bajiro sore yimasiaja mani: “‘Rojose yijaigo yʉ ñaboajaquẽne, rojose yʉ yisere yʉre masiriogʉmi Dios’ yitʉoĩagõ ñaamo”, yimasiaja mani. To bajiboarine, “Diore maibetibʉsaja” yigʉre ĩacõari, ado bajisejʉa yimasiaja mani: “‘Bʉto rojose yibecʉ yʉ ñajare, Dios mojoroaca yʉre ĩ masiriojare, ĩre maibetibʉsacõaja’ yitʉoĩagʉ̃ ñaami”, ĩre yimasiaja mani —Simónre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","To yicõari, rõmiore ado bajiro sore yiyuju Jesús: —Rojose mʉ yirũgũrere mʉre masiriocõamʉ yʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","To bajiro ĩ yirone, —¿No yigʉ to bajise yati ĩ? To bajiro ĩ ñagõjama, Diore rʉ̃cʉbʉobecʉ yami. Dios sĩgʉ̃ne ñagʉ̃mi ti ũnire yimasigʉ̃ma —yitʉoĩañujarã ĩna, gãjerã “Baroaya” yigʉ, Simón ĩ jiriarãjʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","To bajiro ĩna yitʉoĩajare, ado bajiro sore yiyuju Jesús: —“Rojose yʉ yirũgũsere yʉre masiriocõañumi Dios” mʉ yitʉoĩase ñajare, rojose tãmʉotʉjabetiriarojʉ mʉ vaborotire mʉre yirẽtobosabʉ yʉ. To bajiri, “Dios ĩ ĩajama, quẽnagõ ñaja yʉ”, yitʉoĩa variquẽna vasa mʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tijʉ bero, cojo maca me ejacudiyuju Jesús, Dios oca quẽnasere masare gotimasiocudigʉ. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, yʉre ajitirʉ̃nʉña”, ĩnare yigotimasiocudiyuju. Ti macarijʉre ĩ rãca vasujarã ĩna, ĩ ocare goticudisʉorona, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Rõmia quẽne, ĩna ʉsʉrijʉ sãñarãre vãtiare Jesús ĩ bureariarã, to yicõari, rijaye cʉtiriarã ĩ catioriarã quẽne ñabajiyujarã ĩna, Jesúre sʉyarã. Sĩgõ, Mar'ia Magdalena vãme cʉtigo ñañuju so. Cojomo cõro gaje ãmo jʉa jẽnituarirãcʉ so ʉsʉjʉ sãñariarãre vãtiare ĩ bureario ñañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Gajeo, Juana, Cuza manajo, ñañuju so. Cuza, Herodes ya vijʉ codegʉ ñañuju ĩ. Gajeo, Susana vãme cʉtigo ñañuju so. Gãjerã rõmia quẽne, jãjarã ñañujarã ĩna, Jesúre sʉyarã. Ĩna cʉosere Jesúre, ĩ buerimasare quẽne ĩnare ĩsirũgũñujarã ĩna, ĩnare ejarẽmorã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jesúre ajirã ĩ tʉjʉ rẽjarũtuasujarã ĩna, gajemacari ñarã quẽne. To ĩna bajiro, ado bajise gotimasiore queti ĩnare gotiyuju ĩ: ");
INSERT INTO bsnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Sĩgʉ̃ oterimasʉ, vesejʉ ote ajere otegʉ vacʉmi. Vese ejacõari, ote ajere ĩ reabaterone, gajeye maajʉ vẽjaquearoja. To bajiri tire cʉdarãma masa, maa vana. To yicõari, minia ejacõari, tire bareacõarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gajeyema, gʉ̃ta joejʉ reajeoroja. To bajicõari, judiboarine, oco manijare, sĩnireacoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gajeyema, jotayucʉ́ vatoajʉ vẽjaquearoja. To bajicõari, ti judiboajaquẽne, jotajʉa bʉcʉaveocoatoja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gajeyema, sita quẽnarojʉ vẽjaquearoja. To baji, judibʉcʉacõari, quẽnase ñacõari, jairo rica cʉtiroja. Cojotõ cien ñaricari rica cʉtiejoroja —ĩnare yigotiyuju Jesús. To yigajanocõari, —Tire mʉa ajimasirʉajama, quẽnaro tʉoĩaña mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tijʉ bero, ado bajiro Jesúre sẽniĩañujarã ĩ buerimasa: —Oterimasʉ ĩ bajire queti mʉ gotimasiose, ¿no yire ũni ñati ti? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","To bajiro ĩna yisẽniĩajare, ado bajiro ĩnare cʉdiyuju ĩ: —“Ʉjʉ Dios yarã quẽnaro ĩ yirona yʉa ñarʉajama, ado bajiro yiroti ñaja” ĩna yimasibeticatire Dios ĩ masise rãca ajimasiaja mʉama. To bajiboarine, gãjerãjʉama, yʉ yiĩosere ĩarã ñaboarine, to yicõari, yʉ gotisere ajirã ñaboarine, “To bajiro manire yigotigʉ yami”, yimasimenama. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ado bajiro yirʉaro yaja” oterimasʉ ĩ bajire quetire yʉ gotise: Ote ajere yʉ yijama, Dios ocare yigʉ yibʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ote aje, maajʉ vẽjaquearere yʉ yijama, “Ʉjʉ Dios yarã quẽnaro ĩ yirona ĩna ñarʉajama, ado bajiro yiroti ñaja” yʉ yigotimasiosere quẽnaro ajimasimenare yigʉ yibʉ yʉ. Minia, ejacõari, ote ajere ĩna basere yʉ yijama, vãtia ʉjʉ ejacõari, Dios ocare ĩna ajimasiboasere guaro ĩ masiriosere yigʉ yibʉ yʉ. To bajiro yami vãtia ʉjʉ, “Dios ocare ajitirʉ̃nʉcõari, quẽnaro yirẽto ecoroma ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gʉ̃ta joejʉ vẽjaqueacõari, guaro judibʉcʉaboarere yʉ yijama, yʉ yere ajicõari, quẽnaro variquẽnase rãca ajirã ñaboarine, yoaro mene tire ĩna quejerotire yigʉ yibʉ. Sĩnirearere yʉ yijama, yʉ yere ajirã ñaboarine, rojose ĩna tãmʉojama, yoaro mene yʉ ocare ĩna ajitʉjarotire yigʉ yibʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jotayucʉ́ vatoajʉ vẽjaqueacõari, judiboarere jotayucʉ́jʉa ti bʉcʉaveorere yʉ yijama, yʉ gotisere ajirã ñaboarine, tʉoĩarejairã, to yicõari, gajeyeũni bojatʉoĩarã ñari, yʉ yejʉare ĩna tʉoĩatʉjarotire yigʉ yibʉ. To bajiro bajirã, yʉ yere ajisʉoboarine, yʉ bojarore bajiro yimenama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sita quẽnarojʉ vẽjaqueare judibʉcʉacõari, quẽnase rica cʉtirere yʉ yijama, yʉ yere ajimasicõari, Dios ĩ bojarore bajiro quẽnaro yirãre yigʉ yibʉ —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Quẽna gaje queti ado bajiro ĩnare gotiyuju Jesús: —Sĩabusuoriare jẽocõari, sotʉne tiare mubʉamenaja mani. Tiare jẽocõari, “Ñajediro ti vianare ʉ̃jʉbusuato” yirã, vecajʉ jeorãja mani. Tire bajiro bajiaja yʉ gotimasiose. “Ajimasibeticõato masa” yigʉ me, to bajise ĩnare gotiaja yʉ. “Quẽnaro riojo ajimasiato ĩna” yigʉ, gotirũgũaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dios sʉorine masa ĩna ajimasibeticati jediro, quẽnaro ajimasirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","No bojagʉ Diore ajitirʉ̃nʉgʉ̃re, “Quẽnarobʉsa ajimasiato” yigʉ, ĩ masisere cõarʉcʉmi Dios. Gãjirema, ĩre ajigʉ ñaboarine, ĩre ĩ ajitirʉ̃nʉbetijare, ĩ ajimasiboasere masiriojeocõarʉcʉmi ĩ. To bajiri ĩre masibetimasucõarʉcʉmi ĩ. To bajiro ti bajijare, mʉare yʉ gotisere quẽnaro mʉa ajimasirʉajama, Dios ĩ bojarore bajiro quẽnaro yimʉorʉ̃gõña mʉa —ĩ buerimasare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús, masare ĩ gotmasio ñarone, ĩ jaco, ĩ bederã rãca ĩre ĩarã ejaboayujarã ĩna. To bajiboarine jãjarã masa ĩna ñajare, ĩ tʉjʉ ejamasibesujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ĩ tʉ ĩna ejamasibetijare, sĩgʉ̃, ado bajiro Jesúre ĩre yiyuju: —Mʉ jaco, mʉ bederã quẽne macajʉ́jʉ ejama, mʉ rãca ñagõrʉarã —Jesúre ĩre yigotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","To bajiro ĩ yigotisere ajicõari, ĩre ajiñarãjʉare ado bajiro ĩnare yiyuju Jesús: —No bojarã Dios ocare ajicõari, ĩ rotirore bajiro yirã ñarãma yʉ bederãre bajiro bajirã, yʉ jacore bajiro bajirã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cojorʉ̃mʉ Jesús ĩ buerã rãca cũmuajʉ vasãjacõari, —Gajejacatʉajʉ jẽajaro mani —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ĩna jẽatone, bʉto mino vasuju. To bajicõari, bʉto sabeyuju. Ti saberone, cũmua sagueca yiro, oco sãjacõari, rujacoarʉayuju. To ti bajiboajaquẽne, cãnigʉ̃ yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ĩ cãniro ĩacõari, ĩre yujioyujarã ĩna: —Yʉa ʉjʉ, ¡rujareana yaja mani! —ĩre yiyujarã ĩna. To bajiro ĩna yijare, —¡Mino tʉjaya! ¡Sabese quẽne tʉjaya mʉa! —yiyuju Jesús. To ĩ yirone, tʉjacoasuju mino. Sabese quẽne sabebesuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","To yicõari, —“Rojose mani tãmʉoboajaquẽne, manire yirẽtobosarʉcʉmi”, yʉre yitʉoĩarã me ñaja mʉa —ĩnare yiyuju Jesús. To bajiro ĩ yisere ĩacõari, no yimasibesujarã ĩ buerimasa. —¿Ñimʉ ũgʉ̃ masʉ ñati ãni? Minore, to yicõari, sabesere ĩ tʉjarotijama, ĩre ajiaja —gãmerã yiyujarã ĩna, ĩre güirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ʉtabʉcʉra gajejacatʉajʉ Gerasa vãme cʉti maca tʉjʉ ejayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tojʉ ejacõari, Jesús ĩ majatone, sĩgʉ̃ ʉ̃mʉ, ti macajʉ ñaboar'i, ĩre bocayuju ĩ. Sudi magʉ̃ne, yoaro masa rijariarãre ĩna yujereariavijʉ ñarũgũñuju ĩ. Vãtia sãñagʉ̃ ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","To bajigʉ ñari, cojoji me ĩ masu ĩ bojasere yimasibeticõari, vãtia ĩna bojasejʉare yirũgũñuju ĩ. To bajiro bajigʉ ĩ ñajare, cõmemane ĩre siaboayujarã ĩna. Ĩre ĩna siaboajaquẽne, tʉ̃asure reacõarũgũñuju ĩ. To yicõari, yucʉ́ manojʉ varũgũñuju, ĩre sãñarã vãtia to bajiro ĩre ĩna varotijare. To bajiri Jesúre ĩ bocarone, —Ãni masʉ ʉsʉjʉ sãñarã, budiya mʉa —vãtiare ĩnare yiyuju Jesús. To ĩ yirone, masʉjʉa, vãtia sʉorine avasãcõari, Jesús rĩjorojʉa gʉsomuniari tuetuyuju. To ĩ bajirone, vãtiajʉa, masʉ ʉsʉjʉ sãñacõari, ado bajiro Jesúre sẽniĩaavasãñujarã: —Jesús, masirẽtogʉ̃, Dios macʉ ñaja mʉ. ¿No yigʉ yʉa tʉ vadiati mʉ? “Yʉare gõjanabiobesa”, mʉre yisẽniaja yʉa. “Rojose mʉa yise vaja, rojose mʉare yibeaja yʉ”, yʉare yiya —Jesúre yisẽniñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","To ĩna yirone, ado bajiro vãtia sãñagʉ̃re sẽniĩañuju Jesús: —¿Ñimʉ vãme cʉtiati mʉ? —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju vãtiajʉa: —Legión vãme cʉtiaja yʉa —ĩre yiyujarã. Jãjarã ĩ ʉsʉjʉre sãñarã ñari, to bajiro ĩre yicʉdiyujarã vãtia. To yicõari, bʉto Jesúre sẽniñujarã: —Tʉsabetigoje tubibe ecocõari, josari tãmʉoriarojʉ yʉare cõabesa mʉ —Jesúre ĩre yisẽniñujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Burojʉ jãjarã ecariarã yesea macabañañujarã. Ĩnare ĩacõari, ado bajiro Jesúre sẽniñujarã vãtiajʉa: —Yʉare mʉ bureajama, õa yeseajʉare yʉare sãjarotiya —ĩre yiyujarã ĩna. To bajiro ĩre ĩna yijare, —Mʉare varotiaja yʉ —vãtiare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","To ĩ yirone, masʉ ʉsʉjʉre sãñaboariarã budicoasujarã yuja, yeseajʉare sãjaroana. Ĩna sãjarone, buro ũmaroja vacõari, ʉtabʉcʉrajʉ rearoderujacõa tʉjasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yeseare coderimasa, to bajiro ĩna bajisere ĩacõari, ũmacoasujarã, ĩna ya macajʉ vana. Tojʉ ejacõari, ti macanare, to yicõari, ti maca tʉ ñarimacarianare quẽne, tire gotibatoyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","To bajiro ĩna yigotisere ajicõari, Jesúre ĩarã vasujarã ĩna, ti macana. Ĩ tʉjʉ ejacõari, vãtia sãñaboar'ire ĩañujarã ĩna. Sudi sãñacõari, Jesús tʉ rujiyuju. Ĩna bajirore bajiro bajigʉ ñañuju ĩ yuja. Vãtia ĩna sãñajama, tʉoĩamasibecʉ ñañuju maji. Quẽnaro tʉoĩagʉ̃ ñañuju yuja. To ĩ bajisere ĩacõari, Jesúre bʉto güiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vãtia sãñaboar'i ĩ bajisere ĩariarã, gãjerãre gotiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","To bajiri, Gerasa vãme cʉti macana to sojʉa vadiriarã quẽne, Jesúre bʉto güirã ñari, —Vacoasa. Ado mʉ ñasere bojabeaja —ĩre yiyujarã ĩna. To ĩna yijare, tudiacʉ, cũmuajʉ vasãjañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","To ĩ bajirone, ado bajiro ĩre yiboayuju vãtia sãñaboar'i: —Mʉ rãca bʉto varʉaja yʉ quẽne —ĩre yiboayuju. To bajiro ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Yʉ rãca vadibesa. Mʉ ya vijʉ tudiasa. “Dios ĩ masise rãca yʉ ʉsʉjʉ sãñarãre vãtiare bureami Jesús”, mʉ yarãre ĩnare yigotiba —ĩre yicʉdiyuju Jesús, vãtia sãñaboar'ire. To bajiro ĩ yijare, ĩ yarã tʉjʉ tudicoasuju ĩ. Tudiejacõari, ĩ ya maca ñarã jedirore, ti quetire goticudiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús tudijẽacoasuju quẽna, gajejacatʉajʉ. Tojʉ ĩ ejarotire yucõa ñañujarã ĩna, masa. To bajiri ĩ jẽaeja majatone bʉto variquẽnase rãca ĩre sẽniñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","To ĩna bajirone, Dios ocare ĩna buerivi ʉjʉ quẽne ejayuju, Jairo vãme cʉtigʉ. Jesúre ĩacõari, ĩ rĩjorojʉa gʉsomuniari tuetuyuju, ĩre rʉ̃cʉbʉogʉ. To yicõari, ado bajiro Jesúre ĩre sẽniñuju: —Yʉ maco sĩgõne ñagõ, jʉaãmo cõro, gʉbo jʉa jẽnituari cʉ̃mari tʉsaco ñaamo so. Bajirocaco yimo. So tʉ ejacõari, sore mʉ moaĩajama, caticoarʉocomo —Jesúre ĩre yisẽniñuju. To bajiro Jairo ĩ yisere ajicõari, ĩre sʉyasuju Jesús. Jãjarã masa ĩre sʉyacõari, no bajiro yi vamasiña manojʉ vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","To bajiro ĩna bajivatoajʉre sĩgõ gãmorõmi cʉtigo ñañuju so. Jʉaãmo cõro, gʉbo jʉa jẽnituari cʉ̃mari rijañañuju. Ʉco yirimasa, sore ĩna ʉco yire vaja, vaja yigo, gãjoa so cʉoboarere ĩnare ĩsijeocõañuju. To bajiro ĩnare so yiboajaquẽne, quẽnaejabesuju so. To bajiri gãjerãre Jesús ĩ catiore quetire ajirio ñari, jãjarã masa vatoajʉ Jesúre sʉyasuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ĩ sʉyarojʉa ejarʉ̃gʉ̃cõari, ĩ sudiro gajare moaĩañuju. So moaĩarirĩmarone, sore quẽnaejacoasuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","So moaĩarone, ado bajiro masare sẽniĩañuju ĩ: —¿Ñimʉ yʉ sudirore moaĩari? —ĩnare yisẽniĩañuju. —Mʉre moaĩaña maja —ĩre ĩna yicʉdijedicõajare, ĩ buerimasʉ, Pedro vãme cʉtigʉ, ado bajiro Jesúre yiyuju ĩ: —¿No yigʉ “¿Ñimʉ yʉre moaĩati?”, yati mʉ? Mʉ tʉjʉ jãjarã ñaja yʉa, mʉre moaĩarã —ĩre yiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","To ĩ yiboajaquẽne, —Sĩgõ rõmio, “Quẽnaejagosa” yigo, yʉre moaĩamo so. Yʉre moaĩagõne, “Yʉ masise sʉorine quẽnaejacoajamo”, yimasicõamʉ yʉ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","To bajiro ĩ yijare, “Jẽre ĩre yʉ moaĩasere masicõami” yigo ñari, nanagõne, Jesús rĩjorojʉa ejacõari, gʉsomuniari tuetuyuju so. To yicõari, ñajediro so bajirere Jesúre gotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","To so yirone, ado bajiro sore cʉdiyuju Jesús: —Yʉ maigõ, “Ĩ sudiro gajare yʉ moaĩajama, quẽnaejacoarʉocoja yʉ” mʉ yitʉoĩase ñajare, “Quẽnaejato”, mʉre yibʉ yʉ. To bajiri, “To bajiro yʉre yimi”, yitʉoĩa variquẽna vasa mʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","To bajiro sore ĩ yiñarone, Dios ocare ĩna buerivi ʉjʉ Jairo vãme cʉtigʉ ya viagʉ ejayuju. Ejacõari, ado bajiro Jairore gotiyuju: —Mʉ maco bajirocacoamo. No yigʉ mʉ ya vijʉ gotimasiorimasʉ ĩ vasere bojabecʉja mʉ yuja —Jairore yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","To ĩ yisere ajicõari, ado bajiro Jairore gotiyuju Jesús: —Tʉoĩasʉtiritibesa mʉ. Yʉ masisejʉare tʉoĩacõa ñaña. Mʉ tʉoĩacõa ñajama, tudicaticoarʉocomo so —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","To yi vanane, ejayujarã Jairo ya vijʉre. Tojʉ ejana ĩna ĩajama, ĩ maco so bajirocacoajare, bʉto otiñañujarã ĩna, ti vi ejariarã. To bajiro ĩna yiñajare, ado bajiro ĩnare yiyuju Jesús: —Otibesa mʉa. “Bajirocacoajamo” mʉa yiboago, cãnigõ yamo —ĩnare yiyuju Jesús. To ĩ yijare, ĩre ajayujarã ĩna, “Bajirocacoamo” yimasirã ñari. To yicõari, bajirocario so jesari sõajʉre ĩnare jãjarotibesuju Jesús. Pedro, Santiago, Juan, to yicõari bajirocario jacʉare quẽne tocãrãcʉne ĩnare jãjarotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jãjaejacõari, bajirocario ãmore ñiagʉ̃ne, ado bajiro sore yiyuju Jesús: —Daquego, vʉ̃mʉrʉ̃gʉ̃ña —sore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","To ĩ yirone, bajirocario cativʉ̃mʉrʉ̃gʉ̃cõañuju so yuja. To so bajisere ĩacõari, —Bare sore ecaya mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","So tudicatisere ĩacõari, no yimasibesujarã so jacʉa, ti ũnire ĩabetirũgũriarã ñari. To bajiro ĩna bajisere ĩacõari, ĩna macore ĩ catiosere gotirotibesuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cojorʉ̃mʉ, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre ĩ buerimasare jirẽoñuju Jesús. Ĩnare jirẽocõari, masa ʉsʉrijʉ sãñarãre vãtiare ĩna bureamasirotire, to yicõari, rijaye cʉtirãre ĩna catiomasirotire ĩnare ʉjoyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","To bajiro yicõari, ĩnare ĩ cõaroto rĩjoro ado bajiro ĩnare yiyuju: —“Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, Jesúre ajitirʉ̃nʉña”, yigotimasiocudirona ñaja mʉa. To bajicõari, rijaye cʉtirãre catiorona ñaja —ĩnare yirotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","To yicõari, quẽna ado bajiro ĩnare yiyuju Jesús: —No bojase mʉa cʉose juaábeja. Tueriayucʉ́ri, mʉa bare sãriajoari, to yicõari, gãjoare quẽne juaábeja. Gajeye sudi juaámenane, mʉa sãñasene sãñacõari, vaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tocãrãca macare mʉa ejajama, mʉa ejasʉorivine cãnima. Ti vine ñacõari, yʉ ocare goticudirʉarãja mʉa maji, gajerojʉ mʉa varoto rĩjoro. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mʉa ejarimacana, quẽnaro mʉare ĩna bocaãmibetijama, to yicõari mʉa gotisere ĩna ajirʉabetijaquẽne, ti macajʉre ñabeja. Mʉare ĩna ajirʉabetijare, mʉa gʉbo sudi tuyasere sitare varerea, vacoaja. To bajiro mʉa yijama, “Quẽnaro yʉare bocaãmibeticõari, yʉare mʉa ajirʉabetijare, rojose mʉare yirʉcʉmi Dios” yirã yirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","To bajiro ĩ yijare, ĩ ocare goticudirã vasujarã ĩna: “Rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya” ĩnare yigoticõari, Cristo sʉorine quẽnaro Dios ĩ yirotire gotimasiocudiyujarã ĩna. Rijaye cʉtirãre quẽne catiocudiyujarã, ĩna vati macari ñaro cõrone. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Jesús ĩ bajiñasere, to yicõari, ĩ goticudirotiriarã ĩna bajiñasere quẽne ajijeocõañuju Galilea vãme cʉti sita ñarã ʉjʉ, Herodes vãme cʉtigʉ. To yicõari, Jesús ĩ bajiñasere masa ĩna tʉoĩasere quẽne ajiyuju Herodes. Ado bajiro tʉoĩañujarã sĩgʉ̃ri: —Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉne sĩaecoboarine, tudicaticoarimi —yitʉoĩañujarã. Gãjerãma, ado bajiro yiyujarã: —Diore gotirẽtobosarimasʉ El'ias ñamasir'i ñagʉ̃mi quẽna —yiyujarã. Gãjerãjʉama, ado bajiro yiyujarã: —Diore gotirẽtobosarimasa ñamasiriarã rãcagʉ tudicatir'i ñagʉ̃mi quẽna —yiyujarã ĩna, Jesúre. Herodejʉama, ado bajiro yiyuju: —Juan me ñagʉ̃mi. Ĩ rʉjoare jatarocaroticõacajʉ yʉ. To bajiri, ¿ñimʉ ũgʉ̃ ñarojari ĩ? —yiyuju Herodes. To bajiro yigʉ ñari, Jesúre ĩarʉarũgũboayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ĩ goticudiroticõariarã, tudiejacõari, Jesúrãca rẽjañujarã jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã ĩ buerimasa. Ĩ rãca rẽjacõari, ĩna yicudirere ĩre gotiyujarã. To bajiro ĩna yiro bero, ĩnare ũmato vasuju Jesús, masa ĩna manibʉsarojʉ, Betsaida vãme cʉti macajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","To bajiri Jesús ĩ vati quetire ajicõari, ĩre sʉyaejasujarã jãjarã masa. Ĩna ejasere ĩacõari, —Yʉre ajirã, ado mʉa ejase quẽnaja —ĩnare yiyuju Jesús. To yicõari, ado bajiro ĩnare gotimasioñuju: —Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, yʉre ajitirʉ̃nʉña —ĩnare yigotimasioñuju. To yicõari, rijaye cʉtirãre catioyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","To bajiro yiñarone, rãioroto rĩjoro, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã Jesús buerimasa, ĩ tʉ ejacõari, ado bajiro ĩre yiyujarã: —Masa manojʉ ñaja. To bajiri, “Masa cʉtojʉ bare vaja yibamasiato ĩna” yigʉ, to yicõari, ĩna cãnirotijʉrire “Vaja yicõari, cãniato ĩna” yigʉ, masare ĩnare varotiya mʉ —Jesúre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","To bajiro ĩna yiboajaquẽne, —Mʉane ĩnare bare ecaya —ĩnare yiyuju ĩ. To ĩ yirone, —Jairo bare cʉobeaja yʉa. Bajiboarine, cojomo cõro pan, jʉarã vai cʉoaja yʉa. Ĩna barotire, no bajiro vaja yibosamasimenaja mani —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ĩna tʉjʉre cinco mil ʉ̃mʉa ñañujarã ĩna. To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yiyuju Jesús, ĩ buerimasare: —Masare rujatubuari ĩnare rujirotiya. Tocãrãcatubuare “Cincuenta ñarirãcʉ rujiya”, ĩnare yiya mʉa —ĩnare yiyuju Jesús, ĩ buerimasare. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","To bajiro ĩ yijare, ĩ rotirore bajirone ĩnare rujirotijeoyujarã ĩna, Jesús buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","To bajiro ĩna rujijediro ĩacõari, cojomo cõro ñaricari panre, jʉarã vai ñarãre quẽne juacõari, õ vecajʉa ĩamʉoñuju Jesús. To yicõari, “Quẽnaro yaja mʉ”, Diore ĩre yiyuju. To yicõari, panre iguesurebatecõari, ĩ buerimasare ĩsiñuju, “Rujirãre ĩnare ĩsibatoya” yigʉ. Jʉarã vaire quẽne vẽtʉ̃rebatecõari, ĩ buerimasare ĩsiñuju, “Rujirã jedirore ĩnare ĩsibatoya” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sĩgʉ̃ rʉyariaro mano quẽnaro baʉsʉcʉtijedicõañujarã. Ĩna bagajanoro bero, ĩna barʉasere ĩna juarẽojama, jʉaãmo cõro, gʉbo jʉa jẽnituaro ñarijibʉri rʉyayuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cojorʉ̃mʉ ĩ buerimasa rĩne ĩna ñaro, ĩ jacʉre sẽniñuju Jesús. Ĩ jacʉre sẽnigajanocõari, ado bajiro ĩnare sẽniĩañuju ĩ: —¿Ñimʉ ñaami yʉre yati ĩna masa? —ĩnare yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","To ĩ yisere ajicõari ado bajiro ĩre cʉdiyujarã ĩ buerimasa: —Sĩgʉ̃ri, “Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ, tudicaticõari bajigʉmi quẽna”, mʉre yama ĩna. Gãjerãma, “El'ias ñamasir'i ñaami”, yama ĩna. Gãjerãjʉama, “Diore gotirẽtobosamasir'i ñaami”, mʉre yama —Jesúre yicʉdiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","To ĩna yirone, ado bajiro ĩnare tudisẽniĩañuju Jesús: —Mʉama, ¿ñimʉ ñaami yʉre yati mʉa? —ĩnare yiyuju. To ĩ yirone, ado bajiro ĩre cʉdiyuju Pedro: —Mʉ ñaja rojose yʉa tãmʉoborotire yʉare yirẽtobosacõari, rotimʉorʉ̃gõrocʉ, Dios ĩ cõar'i —Jesúre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","To bajiro Pedro ĩre ĩ yisere ajicõari, gãjerãre gotirotibesuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","To yicõari, ado bajiro ĩnare gotiyuju ĩ: —Yʉ, Dios ĩ roticõacacʉ, bʉto rojose tãmʉorʉcʉja. Bʉcʉrã, paia ʉjarã, to yicõari, Dios ĩ rotimasire gotimasiorimasa quẽne, rojose yʉre yicõari, yʉre sĩarʉarãma ĩna. Yʉre ĩna sĩaboajaquẽne, idiarʉ̃mʉ tʉsatirʉ̃mʉne yʉre catiorʉcʉmi Dios —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","To yicõari, ĩ buerimasare gãjerãre quẽne ĩnare jirẽocõari, ado bajiro gotiyuju Jesús: —No bojagʉ yʉ yʉ ĩ ñarʉajama, ĩ bojasere, ĩ ye ñarotire tʉoĩabetirʉcʉmi. Tʉoĩabeticõari, “Jesúre bajiro rojose tãmʉorʉcʉja yʉ quẽne” yitʉoĩacõari, yʉjʉare ajisʉyarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","No bojarã, ĩna bojaro ñare cʉtirema adi macarʉcʉrore ñasere ĩavariquẽnacõari, Diore tʉoĩamenama, Dios ĩ catisere yayibetire cʉomena ñarʉarãma ĩna. To bajiboarine, yʉre ajitirʉ̃nʉrã, yʉ oca ĩna gotisere ajijũnisinicõari, ĩna sĩarãma, Dios tʉ quẽnaro ñarona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sĩgʉ̃ adi macarʉcʉrojʉ gajeyeũni jediro ĩ bʉjaboajaquẽne, berojʉ rojose tãmʉotʉjabetiriarojʉ ĩ vajama, ĩ gajeyeũni ĩ bʉjaboare ñie vaja manoja. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Masa ĩna ĩaro rĩjorojʉa, “Jesúre rʉ̃cʉbʉogʉ ñaja yʉ”, yibojonebesa. To bajiro yibojonegʉ̃ ñari, yʉ yʉ ĩ ñarʉabetijama, “Yʉ yʉ me ñaami”, ĩre yiĩarʉcʉja yʉ quẽne, Dios ĩ roticõacacʉ ñacõari, “Quẽnarẽtogʉ̃ ñaja yʉ” yʉ jacʉ ĩ yiĩorore bajiro yigʉ ñari, ĩ bususe rãca yʉ vadirʉ̃mʉ. Yʉ rãca vadirʉarãma Dios ĩ cõarã, ángel mesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Riojo mʉare gotiaja yʉ. Mʉa sĩgʉ̃ri mʉa bajireabetone, “Ñajediro ʉjʉ ñaami yʉ roticõacacʉ” Dios mʉare ĩ yiĩosere ĩarʉarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","To bajiro ĩnare ĩ yigotiriaro bero, cojomo cõro, gaje ãmo idia jẽnituaro tʉsatirʉ̃mʉ cõro, Pedro, Juan to yicõari Santiagore quẽne buro joejʉ ĩnare ũmato vasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","32","Tojʉ ĩna ejaro bero, Diore sẽnigʉ̃ vasuju Jesús. To ĩ bajitoye, bʉto ĩnare vʉjaejayuju Pedro mesare. To ĩna bajiñarone, Jesújʉa, Diore sẽniñagʉ̃ne, ricati ruyugʉ godovedicoasuju. To ĩ bajisere ĩaʉcacoasujarã ĩna. Sudi ĩ sãñase bʉto boticoasuju. To bajicõari, cajemose busuyuju ti. To ĩ bajirone, Moisés ñamasir'i, El'ias ñamasir'i rãca Jesús tʉ ruyuarʉ̃gʉ̃ñujarã ĩna. Ĩna quẽne, busubatese rãca ruyuayujarã ĩna. To bajicõari, Jerusalén vãme cʉti macajʉ ĩ sĩaecorotire Jesúrãca ĩna gãmerã ñagõñasere ĩañujarã Pedro mesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","To bajiri Jesúrãca ñagõgajanocõari, ĩna cãmotadirirĩmarone, ado bajiro Jesúre gotiyuju Pedro: —Yʉ ʉjʉ, adojʉ mani ñajama, quẽnamasucõaja. Mʉa ñaro cõrone vijãiri mʉare bʉabosarʉarãja yʉa. Mʉ yajãi, El'ias yajãi, to yicõari, Moisés yajãi bʉabosarʉarãja —Jesúre yiboayuju Pedro. “To bajiro yigʉ yigʉja” yiri mene yicõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","To bajiro ĩ yirirĩmarone, bueri bʉto cajemose ĩnare buebibecõañuju ti. To bajiro ĩnare ti bajirone, bʉto güiyujarã ĩna Pedro mesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","To bajicõari, bueri vatoajʉ ado bajiro ocaruyuyuju: —Ãnine ñaami yʉ macʉ, “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, yʉ cõagʉ̃. Ĩre quẽnaro ajitirʉ̃nʉña mʉa —yi ocaruyuyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","To bajiro ti ocaruyuro bero, ĩaboayujarã. El'iare, Moisére quẽne ĩnare ĩabʉjabesujarã. Jesús sĩgʉ̃ne ñañuju ĩ yuja. To bajisere ĩariarã ñaboarine, yoaro, gãjerãre tire gotimenane bajicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti burojʉ majariarã, gajerʉ̃mʉjʉ rojaejayujarã ĩna quẽna. Ti buro jʉdojʉ, jãjarã masa ĩre yurã bajiñarãre ĩnare ejayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jesús ĩ ejasere ĩacõari, sĩgʉ̃, ado bajiro ĩre sẽniñuju: —Gotimasiorimasʉ, yʉ macʉre ĩamaiña mʉ. Sĩgʉ̃ne ñagʉ̃ ñaami. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ĩ ʉsʉjʉre vãti sãñañaami. To bajiro ĩ bajijare, biyaroaca rijaquedicõari, ĩ risejʉ sõmo budirũgũami. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","To bajiri mʉ buerimasare, “Yʉ macʉ ʉsʉjʉ sãñagʉ̃re vãtire burocaya”, ĩnare yisẽniboabʉ yʉ. Ĩre burocamasimema —Jesúre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","To ĩ yisere ajicõari, ĩ buerimasare, to yicõari, ĩre ajirã ejariarãre quẽne ado bajiro ĩnare yiyuju Jesús: —Rojosere tʉoĩarã ñari, Diore ajitirʉ̃nʉmena masu ñacõaja mʉa. ¿No cõrojʉ mʉare gotimasio tʉjagʉti yʉ? Yoaro mʉa rãca yʉ ñaboajaquẽne, yʉ masise mʉare yʉ ʉjosere ajitirʉ̃nʉbeaja mʉa maji —ĩnare yiyuju Jesús. To yicõari, —Adojʉa mʉ macʉre ãmiaya —ĩre yiyuju, vãti sãñagʉ̃ jacʉjʉare. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","To bajiro ĩ yijare, ĩ macʉre Jesús tʉjʉ ĩ ãmivatone, ĩ ʉsʉjʉ sãñagʉ̃ vãti, ĩre rijaquedirotiyuju. To bajiro ĩ yijare, rijarocacũcoasuju. To bajiro ĩ bajirone, —To cõrone ĩre yitʉjaya —yicõari, vãtire ĩre burocacõañuju Jesús. Vãti ĩ budirone, catiquẽnagʉ̃ ñacoasuju daquegʉjʉa. To ĩ bajirone, ĩ jacʉre ĩre tʉ̃aĩsiñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","To bajiro Jesús ĩ yisere ĩacõari, no yimasibesujarã masa jediro, ti ũnire ĩabetirũgũriarã ñari. “Jesús ĩ yiĩose rãca ‘Masirẽtogʉ̃ ñaja yʉ’ manire yiĩogʉ̃ yami Dios”, yitʉoĩañujarã ĩna jediro. Jesús ĩ yisere masa ĩna tʉoĩañarone, ado bajiro ĩ buerimasare gotiyuju ĩ: ");
INSERT INTO bsnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Mʉare yʉ gotisere ajicõari, masiritibeja mʉa. Yʉre Dios ĩ roticõacacʉre masare ĩsirocarʉcʉmi sĩgʉ̃ —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","To bajiro ĩ yiboajaquẽne, ajimasibesujarã ĩna. “Ajimasibeticõato” Dios ĩ yijare, bajiyujarã. To bajicõari, “Yʉare gotiquẽnoña”, yimasibesujarã, ĩre güirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","“¿Ñimʉjʉa ñagʉ̃ti ñamasugʉ̃ ñarocʉ?”, gãmerã yi oca josayujarã Jesús buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","To bajiro ĩna gãmerã yisere ĩamasicõari, sĩgʉ̃ daquegʉre jicõari, ĩ tʉjʉ ĩre rʉ̃gõrotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","To yicõari, ado bajiro ĩnare gotiyuju: —Ãni daquegʉ, “Ñamasugʉ̃ me ñaja yʉ” ĩ yitʉoĩarore bajiro tʉoĩarãre, gãjerã tʉ ĩna ejaro, quẽnaro ĩnare yirãma, yʉrene quẽnaro yirã yirãma. To yicõari, yʉre quẽnaro yirãma, yʉre cõacacʉre quẽne quẽnaro yirã yirãma. To bajiri, ado bajise mʉare gotiaja yʉ: Yʉre ajitirʉ̃nʉgʉ̃, gãjerã ĩna bojasere masicõari, quẽnaro ĩnare yiejarẽmogʉ̃ ñarʉcʉmi ñamasugʉ̃ma —ĩ buerimasare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","To bajiro ĩ yigotiro berone, ado bajiro Jesúre gotiyuju Juan: —Gotimasiorimasʉ, masa ʉsʉrijʉ sãñarãre vãtiare bureagʉre ĩamʉ yʉa. “Jesúre ajitirʉ̃nʉgʉ̃ ñari, ado bajise mʉare rotimasiaja yʉ: ‘Budiya’ ”, yiñami, vãtiare bureagʉ. Mani rãcagʉ me ĩ ñajare, “Tire yibesa”, ĩre yibʉ yʉa —Jesúre yigotiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","To ĩ yisere ajicõari, ado bajiro ĩre yiyuju Jesús: —“Tire yibeticõaña”, ĩre yibeja. Quẽnaro yirimi —ĩre yiyuju Jesús. To yicõari, ĩ buerimasa jedirore ado bajiro yiyuju: —Ado bajiro ti bajijare, to bajiro yaja yʉ: No bojagʉ yʉre ajitirʉ̃nʉcõari, mani yise ũnire yigʉma, mani rãcagʉ ñagʉ̃mi —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dios õ vecajʉ ĩ ñarojʉ ĩre ĩ ãmimʉjarotirʉ̃mʉ ti cõñarũtuadijare: —Jerusalénjʉ mani varoti ejacoajʉ. To bajiri varũtu vajaro mani —ĩ, buerãre yi vasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Varũtu vacʉne, ĩ rãcanare ĩ ejaroti quetire, “Goti rĩjoro cʉtiaya”, ĩnare yicõañuju ĩ. To ĩ yicõariarã, Samaria sitajʉ ñarimacajʉ ejacõari, “Jesús ĩ cãnirotijʉre macayurã bajibʉ yʉa”, yiboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","To bajiboarine ti macanajʉa, Jesús ĩ ejasere bojabesujarã ĩna. “Jerusalénjʉ vacʉ bajigʉmi” yimasirã ñari, ĩre ĩaterã bajiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","To bajiro ĩna bajise ñajare, ado bajiro Jesúre sẽniĩañujarã, Juan, ĩ gagʉ Santiago rãca: —Yʉa ʉjʉ, ¿“Õ vecaye jea ʉ̃jʉvẽjase rãca ĩnare soereacõaña mʉ”, Diore yʉa yisẽnisere bojati mʉ? —ĩre yisẽniĩaboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","To bajiro ĩre ĩna yisẽniĩarone, jʉdarʉ̃gʉ̃cõari, ado bajiro oca tutuase rãca ĩnare gotiyuju Jesús: —¿No yirã to bajise tʉoĩati mʉa? To bajiro mʉa yitʉoĩajama, vãti ĩ bojarore bajiro tʉoĩarã yaja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","To bajiro ĩnare yigajanocõari, Samaria sitana ĩnare ĩna bojabetijare, gaje macajʉa vacoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ĩna varũtuatone, sĩgʉ̃ ĩna rãca var'i, ado bajiro Jesúre ĩre yiyuju: —No bojaro mʉ vato cõrone mʉre sʉyarʉaja yʉ —Jesúre ĩre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","To ĩ yirone, ado bajiro ĩre cʉdiyuju Jesús: —Buyairoarema, ĩna gojeri ñacajʉ. Miniare quẽne, ĩna jibʉri ñacajʉ. To ĩna bajiboajaquẽne, yʉ, Dios ĩ roticõacacʉma, cãniriajʉ magʉ̃re bajiro bajiaja yʉ. To bajiri yʉre mʉ sʉyajama, bʉto mʉre josarʉaroja —ĩre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","To ĩre ĩ yiro bero, ado bajiro gãjijʉare yiyuju Jesús: —Yʉre sʉyaya mʉ —ĩre yiyuju. To ĩ yiboajaquẽne, ado bajiro Jesúre cʉdiyuju ĩ: —Yʉ ʉjʉ, yʉre yuya mʉ maji. Yʉ jacʉ ĩ bajirocacoajare, ĩre yujegʉacʉ yaja yʉ. Ĩre yujecõari bero, mʉre sʉyarʉcʉja yʉ —Jesúre ĩre yiboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","To bajiro ĩre ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyuju Jesús: —Yucʉne yʉre sʉyaya mʉ. “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, Jesúre ajitirʉ̃nʉña”, yigoticudiaya mʉ. Yʉre ajitirʉ̃nʉmena, rijariarãre bajiro bajirã ñarãma. Ĩnajʉa rijariarãre yujeato ĩna —ĩre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","To bajiro ĩre ĩ yiro bero, quẽna gãji ado bajiro Jesúre yiyuju: —Mʉ rãca yʉ varoto rĩjoro, yʉ ya vianare ĩnare vare gotigʉacʉ yaja yʉ maji —Jesúre ĩre yiboayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","To bajiro ĩ yiboajaquẽne, ado bajiro ĩre cʉdiyuju Jesús: —“Diore rotibosagʉre mʉre ajitirʉ̃nʉ sʉyarʉcʉja” yiboarine, gaje vãme tʉoĩavʉogʉma, Ʉjʉ Dios yʉ me ñagʉ̃mi —ĩre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tijʉ bero, Jesús ĩ buerimasare ĩ goticudirotisʉoriarã mere, gãjerãre beseyuju Jesús. Setenta y dos ñarirãcʉ beseyuju. Ĩnare besecõari, “Yʉ ocare goti rĩjoro cʉtiaya”, ĩnare yicõañuju ĩ. Ĩ goticudiroti macari ñaro cõrone jʉarãri cõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ĩnare ĩ cõaroto rĩjoro, ado bajiro ĩnare yiyuju: —Ote jairo bʉcʉaroja. To bajiro ti bajijare, ote ʉjʉre sẽniña, “Moabosarimasa cõato ĩ” yirã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","To bajiro ĩnare yigoticõari, ado bajiro ĩnare yiyuju quẽna: —Ovejare, buyairoa vatoajʉ güiorojʉ ĩnare cõagʉ̃re bajiro mʉare gotimasiocudirotiaja yʉ —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—No bojase mʉa cʉose juaábeja. Gãjoare, barere quẽne juaábeja. Gʉbo sudi juaámenane, mʉa cʉdasene cʉdacõari, vaja. Maajʉ masare mʉa bocajama, ĩnare sẽniĩa, rẽtocoarʉarãja mʉa, yoaro ĩnare queti gotimaniamenane —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","—Vijʉ ejacõari, “¿Ñati mʉa?” ĩnare yigajanocõari, “ ‘Quẽnaro ñaña mʉa’ mʉare yaja yʉa”, ĩnare yiba, ti vianare. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","To mʉa yirone, ti viana quẽnaro mʉare ĩna bocaãmijama, mʉa yirore bajiro quẽnaro ñarʉarãma. Quẽnaro mʉare ĩna bocaãmibetijama, “‘Quẽnaro ñaña’ yʉa yibetiriarãre bajirone ñacõaña mʉa” ĩnare yi, vacoaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","No bojarã gãjerãre moabosarimasa, vaja bʉjarãma. To bajirone bajirʉaroja mʉare quẽne. Quẽnaro mʉare bocaãmirã tʉne ñacõari, ĩnare mʉa gotimasiose vajane ĩna basene ba, ĩna idise idi yicõa ñarʉarãja mʉa. Mʉa ejarivine ñacõarʉarãja mʉa, gaje viri cãnicudimenane. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Macajʉ mʉa ejariviana, no bojase bare mʉare ĩna ecasene ba variquẽnama. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Rijaye cʉtirãre catioba. To yicõari, “Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, Jesúre ajitirʉ̃nʉña”, ti macanare yigotimasioma. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","To bajiboarine yʉ cõarimacajʉre mʉa ejaro, mʉare quẽnaro ĩna bocaãmibetijama, ti maca gʉdarecojʉ jãjarã ĩna ĩaro rĩjorojʉa ejacõari, ado bajiro ĩnare gotiba mʉa: ");
INSERT INTO bsnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ʉjʉ Dios yarã quẽnaro ĩ yirona mʉa ñarotire gotirã bajiboabʉ yʉa. To bajiri, ‘Quẽnaro yʉare bocaãmibeticõari, yʉare mʉa ajirʉabetijare, rojose mʉare yirʉcʉmi Dios’ yirã, adi macaye sitare yʉa gʉbo sudi tuyasere varereaja yʉa”, ĩnare yigotiba mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Riojo mʉare gotiaja yʉ. Ti macana mʉare ĩna ajirʉabeti vaja Diojʉama, rojose ĩnare yirʉcʉmi masare ĩ beserirʉ̃mʉ ti ejaro. Sodoma macana ñamasiriarã rẽtobʉsaro rojose tãmʉorʉarãma ĩna, mʉare quẽnaro bocaãmimenama —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","To bajiro ĩnare yigoticõari, macariana ĩre ĩna ajitirʉ̃nʉbetire gotiyuju Jesús: —Coraz'in macana, to bajicõari, Betsaida macana quẽne, bʉto rojose tãmʉorʉarãma. Ti macarianare ĩaĩañamani yʉ yiĩocatore bajiro, Tiro vãme cʉti macanare, Sidón vãme cʉti macanare quẽne ĩaĩañamani yʉ ĩojama, tirʉ̃mʉjʉ rojose ĩna yisere tʉoĩasʉtiriticõari, yitʉjacoaboriarãma ĩnama. “Rojose yʉa yisere yirʉabeaja” yisʉtiritirã ñari, sʉtiritirã ĩna sãñasejʉa sudi vasoacõari, to yicõari, ĩna rʉjoarijʉ õja majeoboriarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sidón macana, to bajicõari, Tiro macana ñamasiriarã rẽtobʉsaro rojose tãmʉorʉarãma ĩna, Dios, masare ĩ beserirʉ̃mʉ ti ejaro. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum macanajʉa, “Quẽnarã ñari, õ vecajʉ Dios ĩ ñarojʉ ñarona ñaja mani”, yitʉoĩaboarãma ĩna. To bajiro ĩna yitʉoĩaboajaquẽne, Dios tʉjʉ ñabetirʉarãma. Rojose tãmʉotʉjabetiriarojʉ ñaja ĩna cõaecorotoma. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mʉa gotisere ajicõari, “Riojo yama” mʉare ĩna yijama, yʉrene, “Riojo yami” yirã yirʉarãma. Mʉare ĩna ajitejama, yʉre ajiterã yirʉarãma. To bajiro ĩna yijama, yʉre cõacacʉre, yʉ jacʉre, ajiterã yirʉarãma —ĩnare yiyuju Jesús, ĩ gotiroticõarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tijʉ bero, ĩ gotiroticõariarã, setenta y dos ñarirãcʉ Jesús tʉ tudiejayujarã quẽna. Variquẽnase rãca tudiejarãne, ado bajiro ĩre gotiyujarã ĩna: —Masa ʉsʉrijʉ sãñarãre, vãtiare, “Jesús ĩ rotise rãca mʉare budirotiaja” yʉa yijama, cʉdima ĩna —Jesúre yigotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","To ĩna yirone, —Yʉ rotise rãca vãtia ʉjʉ, Satanás yarãre mʉa burearone, õ vecajʉ bʉjo ĩ yabesere bajiro Satanás ĩ quedirujiasere ĩamʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Ãñare, cotibajare ĩnare cʉdaboarine, rojose tãmʉobetirʉarãja mʉa” yigʉ, yʉ masisere mʉare ʉjocajʉ yʉ, “Rojose yirã jediro, to yicõari, vãtia quẽne rojose mʉare yibeticõato” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yʉ ejarẽmose rãca masa ʉsʉrijʉ sãñarãre, vãtiare, mʉa burearere tʉoĩa variquẽnaboarine, “Ado cõro ñaama yʉ rãca ñarũgũrona” Dios ĩ yiucatu ecocana ñari, tijʉare bʉtobʉsa tʉoĩa variquẽnaroti ñaja —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","To yigajanocõari, Esp'iritu Santo ĩ ejarẽmose rãca, “Quẽnaja”, Diore yivariquẽnagʉ̃, ado bajiro yiyuju Jesús: —Cacʉ, õ vecagʉ ʉjʉ ñaja mʉ. Adi macarʉcʉrore quẽne, ñajediro ʉjʉ ñaja mʉ. “Jẽre masiaja yʉa” yitʉoĩaboarãre, “Yʉ ocare ajimasibeticõato ĩna” yigʉ, ĩnare masirioaja mʉ. To yicõari, “Masimena ñaja yʉa” yirãjʉare, “Ajimasiato” yigʉ, ĩna ajimasirotire yirẽmorũgũaja mʉ. To bajiro mʉ yijama, mʉ bojarore bajiro yigʉ yaja mʉ —Diore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","To yicõari, ado bajiro ĩ rãca ñarãjʉare gotiyuju Jesús: —Yʉ jacʉ ĩ ejarẽmose sʉorine jediro yimasijeogʉ ñaja yʉ. “Tire yimasiato” yigʉ, adi macarʉcʉrojʉre yʉre cõacami yʉ jacʉ. To bajiro yʉre yicacʉ ñari, yʉ yisere masijeocõami yʉ jacʉ. Yʉ quẽne, ĩ yisere masijeocõaja. “Ĩre masiato” yigʉ, yʉ beserã rĩne yʉ jacʉre masiama —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","To yicõari, ĩ buerimasa rĩne ĩna ñaro, ado bajiro ĩnare gotiyuju Jesús: —Variquẽnaña mʉama. Yʉ yiĩosere tʉoĩacõari, yʉ bojarore bajiro tʉoĩavasoariarã ñari, tire yʉ gotimasiosere ajimasiaja mʉama. Riojo mʉare gotiaja yʉ. Tirʉ̃mʉjʉ jãjarã Diore gotirẽtobosamasiriarã yucʉ mʉare yʉ yiĩosere ĩarʉamasiboayuma. Yʉ gotimasiosere mʉa ajisere ajirʉamasiboayuma. To bajiri mʉama, jairo yʉ yiĩosere masirã ñari, to yicõari, yʉ gotimasiosere ajirã ñari, variquẽnaña mʉa —ĩnare yiyuju Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","To bajiro Jesús ĩ yiñarone, sĩgʉ̃ Dios ĩ rotimasirere gotimasiorimasʉ, ĩre sẽniĩarʉ, vʉ̃mʉrʉ̃gʉ̃ñuju. “Ado bajiro yʉ sẽniĩajama, josase ti ñajare, cʉdimasibeticõari bojoneose tãmʉorʉcʉmi” yitʉoĩagʉ̃ ñari, ado bajise ĩre sẽniĩañuju: —Gotimasiorimasʉ, yʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere yʉre ĩ ĩsisere yʉ bojajama, ¿no bajiro yiroti ñati yʉre? —ĩre yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju: —¿No bajiro yati ti, Dios ĩ rotimasire, tire buegʉ mʉ ĩajama? —ĩre boca yisẽniĩacõañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","To bajiro ĩ yisere ajicõari, ado bajiro Jesúre cʉdiyuju ĩ: —Dios ĩ rotimasire, ado bajiro yaja ti: “Mani ʉjʉre, Diore bʉto mairoti ñaja. No bojagʉre mani mairo rẽtoro, no bojase mani cʉose, to yicõari, mani bojatʉoĩase rẽtoro Diore mairoti ñaja”. To yicõari, “Mʉ masu rujʉre mʉ mairore bajirone mʉ tʉanare maiña” yigotiaja Dios ĩ rotimasire ñamasuse —Jesúre yicʉdiyuju Dios ĩ rotimasire gotimasiorimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","To bajiro ĩ yisere ajicõari, —Riojo cʉdiaja mʉ. To bajiro mʉ yirũgũjama, mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉre ĩ ĩsisere bʉjarʉcʉja mʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","To bajiro ĩ yisere ajicõari, “Ti vãme ñaro cõrone cʉdijeobeami” yitʉoĩagʉ̃ ñari, “Quẽna gaje vãme yʉ sẽniĩajama, gotimasibeticõari, bojoneoro tujarʉcʉmi” yigʉ, Jesúre ĩre sẽniĩañuju ĩ quẽna: —¿Ñimarã ñati yʉ tʉana, yʉ maironama? —ĩre yisẽniĩañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","To bajiro ĩ yisẽniĩajare, gotimasiore queti gotiyuju Jesús: —Sĩgʉ̃ jud'io masʉ, Jerusalénjʉ rojacʉmi Jericójʉ ejagʉ vacʉ. Maa ĩ vatone, ĩre ñiarãma juarudirimasa. Ĩre ñiacõari, sudi ĩ sãñasere, to yicõari, ĩ gajeyeũni ñajediro ĩre ẽmajeocõarãma ĩna. To yicõari, masacatibecʉjʉ ĩre quẽasĩacõarãma ĩna. To yi, vacoanama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","To ĩna yi vato bero, vagʉmi pai. Ĩre ĩarʉabecʉ ñari, ĩre gãnirẽtocoacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ĩ bero, paire moabosarimasʉ vagʉmi. Ĩ quẽne ĩre ĩacõari, gãnirẽtocoacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Ĩna rẽtoro bero, samaritano masʉ vagʉmi. Ĩre ĩamaicõari, ĩ tʉre tujarʉ̃gʉ̃ ejagʉmi. To bajicõari, ĩ cãmire ĩre ʉco yigʉ, olivo ʉyene, to yicõari, ʉye oco rãca ĩ cãmire ĩre tugʉmi. To yicõari, sudigase rãca ĩ cãmire ĩre dʉreagʉmi. Dʉreagajanocõari, ĩ yʉ burro vãme cʉtigʉ joejʉ ĩre ãmijeo, vacoacʉmi samaritano masʉ. Vacudirimasa ĩna cãnirivijʉ ĩre ãmiejocõari, ĩre codegʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","To bajiro ĩre yicodeñaboa, gajerʉ̃mʉ ti vi ʉjʉre ĩre gãjoa ĩsigʉ̃mi, jʉarʉ̃mʉ moare vaja yire cõro. To yicõari, ado bajiro gotigʉmi: “Rojorã ĩna quẽasĩaecor'ire ĩre vaja yibosagʉ yaja yʉ, ado ĩre mʉ coderoti vaja. ¡To bajiri quẽnaro ĩre codeba mʉ! Ĩre mʉ codero bero, yʉ vaja mojama, ado quẽna gãme vagʉ, mʉre vaja yicõarʉcʉja yʉ” ĩre yigʉmi, ti vi ʉjʉre —yigotiyuju Jesús, Dios ĩ rotimasire gotimasiorimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","To bajiro ĩre yigotigajanocõari, ado bajiro ĩre sẽniĩañuju Jesús: —Ti quetire, ¿no bajiro tʉoĩati mʉ? Ĩna idiarã ñariarã, ¿nijʉa ĩre ĩamaiñujari ĩ? —ĩre yisẽniĩañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","To bajiro ĩ yisẽniĩarone, —“Maioro bajigʉ ñaami” yiĩasʉtiriticõari, quẽnaro ĩre yir'ijʉa ñarimi ĩre mair'ima —Jesúre yicʉdiyuju Dios ĩ rotimasire gotimasiorimasʉ. To bajiro ĩ yirone, ado bajiro cʉdiyuju Jesús: —Riojo yʉre cʉdiaja mʉ. To bajiri, mʉ quẽne to bajirone yiya. Maioro bajirãre mʉ ĩajama, ĩnare ejarẽmoña —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Ĩ buerimasa rãca Jerusalénjʉ varũtu vacʉne, gaje macajʉ ĩnare ũmato ejayuju Jesús. Tojʉre Marta vãme cʉtigo, so bedeo, Mar'ia rãca ñañuju so. To bajiri ĩna ya vijʉ Jesús ĩ ejarone, ĩre bocacõari, ĩre sẽniñuju Marta. Sãjaejacõari, Jesús ĩ gotimasio ñaro tʉre rujiyuju so bedeo, Mar'ia, ĩre ajirujigo. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","To bajiro so bajijare, Martajʉa, “Jairo moare ti ñajare sĩgõne ñari, moatĩmabeaja yʉ” yigo, Jesúre ado bajiro ĩre yiboayuju so: —Yʉ ʉjʉ, yʉ sĩgõne yʉ moasejʉarema tʉoĩabeaja mʉ. Yʉ bedeo, yʉre ejarẽmobeamo so. To bajiri, “Mʉ gagore sore moaejarẽmoña”, sore yiya mʉ —Jesúre ĩre yiboayuju Marta. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","To bajiro so yisere ajicõari, ado bajiro sore cʉdiyuju Jesús: —Marta, yʉ maigõ, moarere tʉoĩarejaibesa mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mʉ bedeo, quẽnasejʉare tʉoĩamasiamo so. To bajiri yʉ gotisere ajigo yamo. To bajiro so bajijare, sore moarotire maja —sore yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cojorʉ̃mʉ ĩ jacʉre ĩre sẽniñuju Jesús. To ĩ yigajanorone, sĩgʉ̃ ĩ buerimasʉ ado bajiro ĩre sẽniĩañuju: —Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ, ĩ buerãre Diore ĩna sẽnirotire gotimasioñuju ĩ. To bajiri, ¿yʉare quẽne Diore yʉa sẽnirotire yʉare gotimasiogʉ̃ti mʉ? —Jesúre yisẽniĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","To bajiro ĩ yijare, ado bajiro ĩ buerimasare gotimasioñuju Jesús: —Diore mʉa sẽnijama, ado bajiro sẽnirʉarãja mʉa: “Yʉa jacʉ, masa ñajediro, ‘Quẽnarẽtogʉ̃ ñaja mʉ’ mʉre yirʉ̃cʉbʉoato ĩna. Adi macarʉcʉroana, mʉ bojase rĩne yʉa yirotire tʉoĩa yurũgũaja yʉa. Jẽre õ vecajʉ mʉ ñarojʉ mʉ yarã mʉ rotirore bajirone yiñarãma. To bajiri adi macarʉcʉrojʉre quẽne mʉ rotirore bajiro rĩne yirere bojaja yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tocãrãcarʉ̃mʉne yʉa barotire cõaña mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‘Rojose yʉa yisere masirioya’ mʉre yisẽniaja yʉa, rojose yʉare yirãre quẽne masiriorã ñari. Rojose yʉa yirotire masigʉ̃ ñari, ‘Tire yibeticõato ĩna’ yigʉ, yʉare matabosaya”. Ado bajiro Diore mʉa sẽnijama, quẽnaja —yiyuju Jesús, ĩ buerimasare. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","To yicõari, gotimasiore queti ado bajiro ĩnare gotiyuju: —Sĩgʉ̃, vacudigʉ, ñami gʉdarecojʉ ĩ baba ya vijʉre ejagʉmi. Ĩ ejaro ĩacõari, bare ĩre ecaroti ti manijare, gaje viagʉ ĩ babare sẽnigʉ̃ vacoacʉmi. Ĩ ya vijʉ ejacõari, “Yʉ baba ĩ ejaro ĩre yʉ ecaroti ti manijare, mʉre bare sẽnigʉ̃ bajibʉ yʉ”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To bajiro ĩ yirone, ado bajiro ĩre cʉdigʉmi: “Yʉre gõjanabiobesa mʉ. Jẽre sojere bibecõamʉ yʉ. Yʉ, yʉ rĩa quẽne cãnirã yaja yʉa. To bajiri, vãgãcõari, mʉre ĩsimasibeaja yʉ”, ĩre yicʉdicõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ĩre ĩ ĩsirʉabetiboajaquẽne, ĩre ĩ sẽnitʉjabetijare, ĩ bojasere ĩsicõarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","To bajiri quẽnaro yʉre ajiya mʉa. Diore mʉa sẽnijama, cõarʉcʉmi. Ĩre sẽnicõari, mʉa macajama, bʉjarʉarãja mʉa. Sĩgʉ̃ no bojase ĩre ti rʉyajama, gãji ya vijʉ ejacõari sãjarʉ, sẽniĩagʉ̃mi. Ĩ sẽniĩajare, ĩre sãjaroticõari, ĩre ejarẽmogʉ̃mi. To bajirone bajiaja Diore sẽnirãre quẽne. Ĩre mʉa sẽnisere ajicõari, quẽnaro mʉare yiejarẽmorʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Dios manire ejarẽmorʉcʉmi” yitʉoĩarã ñari, ĩre ĩna sẽnisere ĩnare cõarʉcʉmi. Ĩna macajaquẽne, bʉjarʉarãma —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","To yicõari, quẽna ado bajiro ĩnare gotimasioñuju Jesús: —“Vai bojaja yʉ” mʉa macʉ ĩ yisẽnijama, ¿ãña, bar'i merene ĩsirãtique mʉa? Ĩsimenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Gãjabocʉ ria bojaja yʉ” mʉa macʉ ĩ yijama, ¿cotibajare ĩsirãtique mʉa? Ĩsimenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Diore bajiro quẽnase yirã me ñaboarine, mʉa rĩare quẽnaro yaja mʉa. To bajiri tire masicõari, ado bajiro Diore yimasiaja mani: “No bojarã Esp'iritu Santore cʉorʉarã, mani jacʉ õ vecagʉre ĩna sẽnijama, ĩnare cõarʉcʉmi”, yimasiaja mani —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sĩgʉ̃ vãti sãñagʉ̃ ñañuju. “¡Ñagõbeticõato!” yigʉ, ĩ ʉsʉjʉre sãjacõari, ñañuju. Ĩre Jesús ĩ burocarone, ñagõmasicoasuju masʉjʉa. Tire ĩacõari, no yimasibesujarã masa, ti ũnire ĩabetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sĩgʉ̃ri, ado bajiro Jesúre ĩre yitʉoĩañujarã ĩna: —Ĩ ʉsʉjʉ vãtia ʉjʉ Beelzebú vãme cʉtigʉ sãñagʉ̃ ñaami Jesús. To bajiri Beelzebú ĩ masise rãca vãtiare bureaami —Jesúre ĩre yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gãjerãma, ado bajiro Jesúre yiyujarã: —“Dios ĩ cõagʉ̃ ñaami” yʉa yiĩamasirotire yigʉ, õ vecaye ĩaĩañamani yʉare yiĩoña —Jesúre ĩre yiboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","“Beelzebú sãñagʉ̃ ñaami” socarãne ĩna yitʉoĩasere masicõari, ado bajiro ĩnare gotiyuju Jesús: —Cojo sitana rotirimasa ĩna gãmerã quẽajama, ĩna masune gãmerã sĩayayirã yirãma. To bajirone bajiroja cojo macanare quẽne, cojo vi ñarãre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","To bajirone bajiroja vãtiare quẽne. Vãtia ĩna gãmerã bureajama, “Masare rojose yitʉjato mani” yirã yiborãma. To bajiro ti bajijare, “Beelzebú vãme cʉtigʉ ĩ masise rãca masa ʉsʉrijʉ sãñarãre vãtiare bureaami” yʉre mʉa yiboase, riojo yirã me yaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","To bajiro yʉre mʉa yitʉoĩaboajama, mʉa buerã quẽne masa ʉsʉrijʉ sãñarãre vãtiare ĩna bureasere, “Vãti ĩ masise rãca burearãma ĩna quẽne” yirãre bajiro yaja mʉa. To bajiro mʉa yijama, “Tʉoĩamavisiarã yaja mʉa”, mʉare yirʉarãma ĩna, mʉa buerã. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ado bajirojʉa tʉoĩarona ñaboaja mʉa: “Vãtia ʉjʉ ĩ masise rãca me yami. Esp'iritu Santo ĩ masise rãcajʉa vãtiare bureaami”, yʉre yitʉoĩarona ñaja mʉa. To yicõari, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, yitʉoĩamasiroti ñaja mʉare. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“To bajiro yimasiroti ñaboaja” yigʉ ñari, “Quẽnabʉsaro yimasiato” yigʉ, quẽna gajeye gotimasiore queti mʉare gotiaja yʉ: Sĩgʉ̃, guamʉ, jairo besu cʉogʉ ñari, ĩ ya viayere quẽnaro ĩ ĩatirʉ̃nʉjare, no bajiro yicõari juarudimasimenama. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","To bajiboarine, “Jairo cʉogʉ yʉ ñajare, yʉre ẽmamasigʉ̃ magʉ̃mi” ĩ yitʉoĩaboasere, gãji ejacõari, ĩre quẽagʉ̃mi. To yicõari, ĩ besure, ĩ gajeyeũnire quẽne ẽmacõari, gãjerã ĩ babarãre ĩsibatogʉmi ĩ rẽtoro tĩmagʉ̃. Tire bajiro bajiaja yʉre quẽne. Vãtia ʉjʉ, masigʉ̃ ĩ ñaboajaquẽne, yʉjʉa, ĩ rẽtoro masigʉ̃ ñaja yʉ. Ĩ rotiboasere ĩre yirotibeticõari, vãtiare yʉ burease sʉorine, vãti ĩ rotiajeboariarãre ĩre ẽmagʉ̃ yaja, “Yʉ yarã ñato” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","No bojarã yʉ gotiboasere ajitirʉ̃nʉmenama, yʉre ajitirʉ̃nʉboronare matarã yirãma. No bojarã, “Jesúre ajitirʉ̃nʉña” yʉre yigoticudibosamenama, “Ĩre ajibesa” yirãre bajiro bajirã ñarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Quẽna ado bajiro yiyuju Jesús: —Vãti, masʉ ʉsʉjʉre budicõari, oco manorijʉ vacudigʉmi. Tujariajaʉ bʉjabecʉ ñari, ado bajiro tʉoĩagʉ̃mi: “Yʉ budiriarojʉne vacoarocʉ ñagʉ̃ja yʉ”, yitʉoĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Masʉ ʉsʉjʉre ĩ budigoriarore tudiejagʉ ĩ ĩajama, gõjanabiose mano, quẽnarivire bajiro masʉ ʉsʉjʉre ĩaejagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","To bajiro ĩ ʉsʉjʉre ĩaejacõari, cojomo cõro jʉa jẽnituarirãcʉ vãtia ĩ rẽtoro rojose yirãre ũmato ejagʉmi. To yicõari, ĩna ñaro cõrone masʉ ʉsʉjʉre sãjarãma ĩna. To bajiri, rẽtorobʉsa rojose yigʉ ñagʉ̃mi masʉ yuja. To bajirone bajirʉaroja mʉare adirodoriana rojose yirãre quẽne. Vãtiare yʉ bureacõaboajaquẽne, yʉre ajitirʉ̃nʉmena ñari, bʉtobʉsa rojose yirã ñaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","To bajiro ĩ yisere ajicõari, sĩgõ rõmio masa vatoajʉ ñacõari, ado bajiro Jesúre ĩre yiyuju: —Bʉto variquẽnagõmo so, mʉre ũjubʉcʉorio —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","To so yirone, ado bajiro sore cʉdiyuju Jesús: —To bajiro yʉre mʉ yiboajaquẽne, Dios ocare ajicõari, ĩ rotisere quẽnaro yirã ñarãma bʉto variquẽnarãma —sore yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesús tʉjʉre jãjarãbʉsa masa ĩna ejarũtuatone, ado bajiro ĩnare gotiyuju Jesús: —Mʉa adirodoriana, rojose yirã jãjarã ñaja mʉa. Yʉre ajiterã ñari, ĩaĩañamani mʉare yʉ yiĩosere bojaboaja mʉa. To bajiro mʉa bojaboajaquẽne, mʉare yiĩobetirʉcʉja yʉ. To bajiboarine Jonás ñamasir'i Diore gotirẽtobosarimasʉ ĩ bajimasirere bajiro bajiĩoroti ñaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonás ĩna tʉjʉ ĩ ejaroto rĩjoro ĩ bajimasirere ĩnare ĩ gotisere ajicõari, “Diore gotirẽtobosagʉ ñaami”, ĩre yitʉoĩamasiñujarã ĩna, N'inive vãme cʉti macana ñamasiriarã. Ti ũnire bajiro bajirʉcʉja yʉ quẽne, Dios ĩ roticõacacʉ ñari. To bajiro yʉ bajise ñajare, “Dios ĩ cõar'ine ñañumi”, yimasirʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ʉjʉ Salomón quẽnaro masigʉ̃ ñañuju” yire quetire ajicõari, Sabá sitana ʉjo ñamasirio, sõjʉ vadicõari, ĩre ajigo ejamasiñuju so. Salomón rẽtoro ñamasugʉ̃ ñaja yʉ. To bajiro yʉ bajiboajaquẽne, mʉajʉama, yʉre ajitirʉ̃nʉbeaja mʉa. To bajiri masare Dios ĩ beserirʉ̃mʉ ti ejaro, ado bajiro bajirʉaroja mʉare: Salomón tʉ ejamasirio, tudicaticõari, “Mʉa ye sʉorine rojose tãmʉorʉarãja”, mʉare yirʉocomo so, yʉ gotisere ajirã ñaboarine, rojose mʉa yitʉjabetijare, ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","N'inive macana ñamasiriarã, Jonás ñamasir'i Dios oca ĩ gotisere ajicõari, rojose ĩna yisere sʉtiriticõari, yitʉjamasiñujarã ĩna. Jonás rẽtoro ñamasugʉ̃ ñaja yʉ. To bajiro yʉ bajiboajaquẽne, mʉajʉama, rojose mʉa yisere yitʉjabeaja mʉa. To bajiro yirã mʉa ñajare, masare Dios ĩ beserirʉ̃mʉ ti ejaro, ado bajiro bajirʉaroja: N'inive maca ñamasiriarã, tudicatirʉarãma ĩna. Tudicaticõari, “Mʉa ye sʉorine rojose tãmʉorʉarãja”, mʉare yiĩarʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","To yicõari, quẽna gaje queti, gotimasiore queti ado bajiro ĩnare gotiyuju Jesús: —Sĩabusuoriare jẽocõari, sotʉne tiare mubʉamenaja mʉa. Tire jẽocõari, “Ñajediro ti vianare ʉ̃jʉbusuato” yirã, vecajʉ jeorãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","35","To yicõari, quẽna gaje gotimasiore queti ĩnare gotiyuju: —Mʉa caje quẽnaro ti ruyujama, “Tine ñaja quẽnamasuse”, yiĩamasiaja mʉa. To bajiboarine, mʉa caje quẽnaro ti ruyubetijama, quẽnabetire ĩacõari, mʉa masune, “Ti ñaja quẽnamasuse”, yisocarãja mʉa. Tire bajiro bajiaja mʉa tʉoĩase quẽne. Dios ĩ bojarore bajiro quẽnaro mʉa tʉoĩajama, ñajediro quẽnaro riojo tʉoĩamasirʉarãja mʉa. Ĩ bojabetire mʉa tʉoĩajama, “Riojo tʉoĩamasiaja” mʉa masune yisocañarã rĩne, ñajediro riojo tʉoĩamasimena ñacoarʉarãja mʉa. To bajiri, quẽnabetire ĩacõari, “Mani masune, ‘Ti ñaja quẽnamasuse’ yisocarobe” yirã, Dios ĩ bojarore bajiro quẽnaro tʉoĩaña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dios ĩ bojarore bajiro quẽnase rĩne mʉa tʉoĩajama, ñajediro quẽnaro riojo tʉoĩamasirʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","To bajiro ĩ yigajanoro bero, sĩgʉ̃ fariseo masʉ, —Yʉ ya vijʉ yʉ rãca bagʉ vayá mʉ —Jesúre yiyuju. To bajiro ĩ yir'i ñari, ĩ tʉjʉ sãjaejacõari, ĩ ãmori coebecʉne, baejarũju vasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","To ĩ bajiro ĩacõari, “‘“Manire ĩavariquẽnato Dios” yirã, mani ñicʉa ĩna yimasiriarore bajiro ãmori coecõari rĩne, baroti ñaja’ yirotimasirere yirʉ̃cʉbʉobeami Jesús” ĩre yiĩagʉ̃ ñari, no yimasibesuju fariseo masʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","To bajiro ĩre ĩ yitʉoĩasere ĩamasicõari, ado bajiro ĩre gotiyuju Jesús: —Idiriabaja, bare jeobariabajare bajiro bajiaja mʉa, fariseo masa. Idiriabaja, bare jeobariabaja joema coeriabajari ñaboarine, jubeajʉama bʉto ʉeri cʉtibajarire bajiro bajiaja mʉa. Mʉa ʉsʉri bajisejʉarema tʉoĩabeaja mʉa. To bajirã ñari, “Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojosere quẽne tʉoĩarã ñari, rojorã ñaja mʉa. Ĩaʉorã ñari, “Ĩnare yitocõari, ĩna cʉoboasere ẽmarʉarãja”, yitʉoĩarã ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tʉoĩamasimenare bajiro bajirã ñaja mʉa, “Rojorã ñaja mani” yimasimena ñari. ¿Dios, mani rujʉrire rujeor'i, mani ʉsʉrire quẽne rujeobesujarique ĩ? Mani ʉsʉrire rujeor'i ñari, quẽnaro mani tʉoĩasere quẽne bojaami Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Rojosere tʉoĩatʉjaya. To bajiro mʉa yijama, Dios ĩ bojarore bajiro tʉoĩarã ñari, quẽnaro yirã masu ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bʉto rojose tãmʉorʉarãja mʉa, fariseo masa. Dios ĩ rotimasirere buerẽtobucõari, ñamasuse mejʉare ajitirʉ̃nʉrãja mʉa. To bajiro yirã ñari, bare sãvʉorere, an'is, menta, comino vãme cʉtire mojoroaca ti vaja cʉtiboajaquẽne, Diore yirʉ̃cʉbʉoriavi moabosarimasare ĩsiaja mʉa. To bajiro yirã ñaboarine, Dios ĩ rotimasire ñamasusejʉarema ajitirʉ̃nʉmenaja mʉa. Ado bajiro bajiaja ñamasuse: Quẽnaro riojo yire, gãjerãre ĩamaire, to yicõari, Diore maire quẽne ñaja ñamasuse. Tire quẽne yirũgũrona ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bʉto rojose tãmʉorʉarãja mʉa, fariseo masa. Boserʉ̃mʉ ñaro rʉ̃cʉbʉoriajaʉjʉ baruji variquẽnaja mʉa. Dios ocare ĩna buerivirijʉ quẽne rʉ̃cʉbʉoriajaʉjʉ rujivariquẽnaja. Masa ĩna ñarijʉ mʉa ejajama, rʉ̃cʉbʉose rãca mʉare ĩna sẽnisere bojarũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bʉto rojose tãmʉorʉarãja mʉa. Masa, gojere bajiro bajiaja mʉa. Ti goje joere vaboarine, “Masa ĩna yujeriagoje ñaroja” yimasimenama, õ ẽñerocajʉ ti ñajare. Tire bajiro bajiaja mʉare quẽne. Rojose mʉa tʉoĩasere masimena ñari, “Rojorã rãca ñaja mani”, mʉare yimasibeama masa, mʉa tʉjʉ ejarã —ĩnare yigotiyuju Jesús, fariseo masare. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","To bajiro ĩ yigotirone, sĩgʉ̃ Dios ĩ rotimasire gotimasiorimasʉ ñañuju ĩ. Ado bajiro Jesúre yiyuju: —Gotimasiorimasʉ, tʉoĩamasiri mene goticõaja mʉ. Fariseo masare to bajiro mʉ yijama, yʉare quẽne tud'igʉ yaja mʉ —Jesúre ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","To bajiro ĩ yirone, ado bajiro ĩre cʉdiyuju Jesús: —Mʉa, Dios ĩ rotimasire gotimasiorimasa quẽne bʉto rojose tãmʉorʉarãja. Dios ĩ rotimasire masirã ñari, ĩ rotimasire rẽtobʉsaro yirotirũgũaja mʉa. “Cojo vãme me mani rotise ñajare, cʉdijeomasimenama ĩna” yimasirã ñaboarine, ĩnare ĩamaimenane, “Ñajediro yʉa gotirẽtobuse riojo ñaja”, masare ĩnare yirũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bʉto rojose tãmʉorʉarãja mʉa. Diore gotirẽtobosamasiriarãre mʉa ñicʉa ĩna sĩamasiriarãre ĩna yujemasiriajaʉ joere quẽnarijaʉri quẽnoaja mʉa, “Quẽnarã ñañuma” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","To bajiro mʉa yijama, “Quẽnarã ñañuma” yirã me yaja mʉa. Ado bajirojʉa yirã yaja: “Diore gotirẽtobosamasiriarãre mani ñicʉa ĩna sĩamasire quẽnañuja ti” yirã yaja mʉa, mʉa ñicʉa rojose ĩna yiriarore bajiro rojose yirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","To bajiro mʉa yiroto rĩjorojʉne masicõañumi Dios, quẽnaro tʉoĩagʉ̃ ñari. Ado bajiro yiyumi, mʉa ñicʉare, to yicõari, mʉare quẽne tʉoĩayugʉ ñari: “Jud'io masa vatoajʉ yʉre gotirẽtobosarãre, to yicõari, gãjerã yʉ oca goticudirimasare quẽne cõarʉcʉja yʉ. Ĩnare sĩarʉarãma ĩna. Gãjerãrema, rojose ĩnare yirʉarãma”, jud'io masare mʉare yiyumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","To bajiri mʉa ñicʉa ĩna yimasire, mʉa yisere quẽne ado bajiro mʉare yirʉcʉmi Dios: Abel ñamasir'ire mʉa ñicʉ ĩ sĩasʉomasire, to yicõari Diore gotirẽtobosarimasare mʉ ñicʉa ĩna sĩamasire, to yicõari Diore yirʉ̃cʉbʉoriavi jubeajʉ ñarijaʉ soemʉoriajaʉ tʉjʉ mʉa ñicʉa Zacar'iare ĩna sĩatʉsamasire ti ñajare, bʉto rojose tãmʉorʉarãja mʉa adirʉ̃mʉri ñarã. Ĩna bajimasiriarore bajirone Diore mʉa ajitirʉ̃nʉbeticõa ñajare, ĩna sĩamasire vaja rojose ĩnare ĩ yiroti rẽtobʉsaro rojose mʉare yirʉcʉmi Dios, adirʉ̃mʉri ñarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bʉto rojose tãmʉorʉarãja mʉa, Dios ĩ rotimasire gotimasiorimasa. Tire buerẽtobucõari, ñamasuse mejʉare ajitirʉ̃nʉcõari, gotimasiovadicajʉ mʉa. To bajiro mʉa yijama, “Ʉjʉ Dios yarã quẽnaro ĩ yirã ñabeticõato mani” yirãre bajiro yiñaja mʉa. To yicõari, “Gãjerã, Ʉjʉ Dios yarã quẽnaro ĩ yirã ñabeticõato ĩna” yirã yaja mʉa. Dios yarã ĩna ñarʉaboajaquẽne, ĩnare matarã yaja mʉa. To bajiri mʉa quẽne ĩ yarã ñabetirʉarãja mʉa —ĩre yicʉdiyuju Jesús, Dios ĩ rotimasire gotimasiorimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","To yigajano, ĩre jivar'i ya vijʉre Jesús ĩ budiato, bʉto ĩre jũnisiniñujarã Dios ĩ rotimasire gotimasiorimasa, fariseo masa quẽne. Ĩre jũnisinirã ñari, bʉto ĩre sẽniĩagõjanabioyujarã ĩna. “Ĩ cʉdimasibetijama, ĩre ocasãrãsa mani” yirã, quẽnaro ajisʉya vasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","“Rojose Jesúre yirãsa” yirã, ĩre ĩna ajicode ñarone, jãjarã masa ĩ tʉjʉre rẽjañujarã ĩna. Jãjarã masu rẽjarã ñari, ĩna masune gãmerã cʉdarorijʉ ñañujarã ĩna. To ĩna bajiñarone, Jesús ĩ buerimasajʉare ado bajiro gotisʉoyuju ĩ: —Fariseo masa “Pan vauvato” yirã, ĩna vʉosere quẽnaro ajicõĩaña mʉa. “Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojose yirã ñaama. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Masa ĩna masibeti jediro, ĩ beserirʉ̃mʉ ti ejaro, “Quẽnaro tire masiato” yigʉ, masare ĩnare gotirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Masa ĩna ajibeto yayioroaca mʉa ñagõsere, “Jediro ajiato” yigʉ, mʉa ñagõrere gotirʉcʉmi Dios —ĩ buerimasare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","To yicõari, quẽna ado bajiro ĩ buerimasare gotiyuju Jesús: —Yʉ babarãre ado bajiro mʉare gotiaja yʉ: Mʉare sĩarʉarãre güibeja mʉa. Mʉa ʉsʉrijʉrema sĩamasimenama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Diojʉare mʉa güijama, quẽnaja. Ĩ ñaami mani catisere rotigʉ. Ĩ masu masiami. To bajiri rojose tãmʉotʉjabetiriarojʉ mʉare reamasicõami. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Cojomocãrãcʉ miniare mani vaja yijama, jʉatii gãjoatiiri rãca vaja yire ñaroja ti, mojoroaca vaja cʉtirã ĩna ñajare. To cõroaca vaja cʉtiboarine, Dios ĩ rotibetone rijagʉ magʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Masajʉare, Dios ĩ ĩajama, jairo vaja cʉtirãre bajiro manire ĩaami. Manire bʉto maiami ĩ. To bajiro bajigʉ ñari, mani rʉjoajoare, cojojoara rʉyabeto cõĩajeogʉ ñaami. To bajiri rojose mʉare yirãre güibeja —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Quẽna ado bajiro ĩ buerimasare gotiyuju Jesús: —Ado bajiro mʉare gotiaja yʉ: Masa ĩna ĩaro rĩjorojʉa, “Jesúre ajitirʉ̃nʉrã ñaja yʉa” yirãrema, yʉ quẽne õ vecajʉ yʉ jacʉ yarã ángel mesa ĩna ĩaro rĩjorojʉa, “Ãnoa ñaama yʉ yarã”, yiĩorʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","To bajiboarine masa ĩaro rĩjorojʉa, “Jesúre ajitirʉ̃nʉrã me ñaja yʉa” ĩna yijama, yʉ quẽne, Dios ĩ roticõacacʉ, õ vecajʉ yʉ jacʉ yarã ángel mesa ĩna ĩaro rĩjorojʉa, “Yʉ yarã me ñaama ĩnama”, yirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","No bojarã, Dios ĩ roticõacacʉre rojose yʉre ĩna ñagõro bero, sʉtiriticõari, Diore ĩna sẽnijama, rojose ĩna yisere masiriorʉcʉmi. To bajiboarine, Esp'iritu Santo ĩ masise rãca moagʉ̃re, “Satanás ye rãca moami” ĩna yitud'ijama, Esp'iritu Santojʉare rojose yirã yirãma. Tirema gajerodo ti ñacoaboajaquẽne, masiriobetirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yʉ ocare mʉa gotimasiojare, mʉare ñejecõari, Dios ocare ĩna buerivirijʉ ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. To yicõari, macari ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. To yi vanane, ʉjarã ñamasurã rĩjorojʉa mʉare juaárʉarãma. Ʉjarã rĩjorojʉa mʉare ĩna juaejaro, “¿No bajiro ñagõrãti yʉa?”, yitʉoĩarejaibeja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","“Ñagõña” mʉare ĩna yirirĩmarone, mani jacʉ Dios ĩ cõagʉ̃, Esp'iritu Santo ĩ ejarẽmose rãca “Ado bajiro gotirʉarãja yʉa”, yimasirʉarãja mʉa —ĩ buerimasare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","To bajiro ĩ yiro bero, ado bajiro Jesúre sẽniĩañuju sĩgʉ̃: —Gotimasiorimasʉ, yʉ jacʉ ñamasicacʉ gajeyeũnire cʉobeaja yʉ. Yʉ gagʉ, tire juacũcacʉ ñaboarine, yʉre ĩsirʉabeami. To bajiri, “Ĩ ye ñarotire ĩre ĩsiña mʉ” ĩre yiya, yʉ gagʉre —Jesúre ĩre yiboayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju: —“Tire yirotirimasʉ ñarʉcʉja mʉ” yigʉ me, yʉre cõacami Dios —ĩre yicudiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","To yicõari, masa jedirore ado bajiro gotiyuju: —Gãjerã ye gajeyeũnire bojaĩabesa. To yicõari, gajeyeũni cʉtirã mʉa ñajama, bʉto tire maibesa. Jairo mani cʉojama, mani cʉobetijaquẽne, no yibeaja. Ti sʉori me variquẽnare ñaroja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","To yicõari, gotimasiore queti ĩnare gotimasioñuju Jesús: —Sĩgʉ̃ masʉ gajeyeũni jaigʉ ñagʉ̃mi. Ĩ ote quẽne, jairo rica cʉtiroja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jairo ti ricacʉto ĩacõari ado bajiro tʉoĩagʉ̃mi: “¿No bajiro yigʉti yʉ? Nojʉa cũmasiriaro maja yʉ”, yitʉoĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","To bajiro yitʉoĩagʉ̃ne, “Ado bajiro yirʉcʉja yʉ”, yitʉoĩabʉjagʉmi. “Bare cũriavirire caguereacõari, gaje viri jacabʉsariviri bʉarʉcʉja yʉ. To yicõari, ti virijʉre yʉ barere, yʉ gajeyeũnire quẽne cũrʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","To yigajanocõari, ado bajiro tʉoĩa variquẽnarʉcʉja yʉ: ‘Guaro jedibetirʉaroja ti, yʉ cʉose. To bajiri, ʉsʉsãja, quẽnaro bare ba, idire idi, yivariquẽna ñarʉcʉja yʉ’ ”, yitʉoĩaboagʉmi, socʉne. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","To bajiro ĩ yitʉoĩañarone, ado bajiro ĩre yigʉmi Dios: “Tʉoĩamasibecʉre bajiro yaja mʉ. Mʉ rijato bero mʉ bajirotire tʉoĩabecʉne yicõaja mʉ. Adi ñamine rijacoarʉcʉja mʉ. To bajiri mʉ cʉosema, ¿ñimʉ yejʉa ñarʉaroada?”, ĩre yigʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tire bajirone bajiaja Diore tʉoĩamenane, jairobʉsa gajeyeũni juacũrũtuanarema. “Disejʉa rʉyabetirʉaroja yʉare” ĩna yiboajaquẽne, Dios ĩ ĩajama, “Yʉ ye quẽnasejʉare bʉjabetirona ñaama, yʉre ajitirʉ̃nʉmena ñari”, ĩnare yiĩaami Dios —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","To ĩ yiro bero, ado bajiro ĩ buerimasare gotiyuju quẽna: —To bajiro Dios ĩ yiĩase ti ñajare, adi macarʉcʉrojʉre mʉa bajirotire tʉoĩarejaibesa mʉa. “¿No bajiro bʉjacõari, bare ba, idi, sudi sãña, yicatiñarãti yʉa?”, yitʉoĩarejaibesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Quẽnamasuse mani ʉsʉre, to yicõari mani rujʉre manire ĩsiñumi Dios. To bajiri mani baroti, mani idiroti, to yicõari sudi mani sãñarotire quẽne cõarũgũrʉcʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minia ĩna bajisere tʉoĩaña mʉa. Ĩna otebetiboajaquẽne, to yicõari, bare ĩna juarẽocũbetiboajaquẽne, ĩnare bare cõarũgũami Dios. “Miniare quẽne ĩamaigʉ̃ ñari, manire roque rẽtoro maigʉ̃mi”, ¿yimasibeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Adi macarʉcʉrojʉre ñarã yoaro catirʉarãja yʉa” mʉa yitʉoĩarejaiboase, “Yoarobʉsa catiato” yiro, mʉare ejarẽmomasibeaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","To bajiro ti bajijare, mʉa catiñarotire tʉoĩarejaibesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sudi mʉa sãñarotire quẽne tʉoĩarejaibesa. Go bʉcʉasere tʉoĩaĩasaque mʉa: Moabeti, to yicõari, sudi sãñarʉa tʉoĩarejaibeaja ti. To bajiboarine, Ʉjʉ Salomón ñamasir'i gajeyeũni jaigʉ ĩ ñaboajaquẽne, quẽnase ĩ sudi sãñamasire rẽtoro quẽnase ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gore bʉto quẽnase ñarotirũgũami Dios. Quẽnase ñaboarine, yoaro mene sĩnicoatoja. Ti sĩniro ĩacõari, bare quẽnorʉarã, tire juacõari, soerãma masa. To bajiri yoaro catise me ti ñaboajaquẽne, tire quẽnorũgũgʉ̃mi Dios. Go rẽtoro manire roque maigʉ̃ ñari, “Manire sudi cõarʉcʉmi Dios”, yimasiroti ñaja mʉare. “To bajirone yigʉmi Dios”, yiajitirʉ̃nʉbetibʉsarã ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","To bajiri, “¿No bajiro bʉjacõari, bare ba, idi, yicatiñarãti yʉa?”, yitʉoĩarejaibesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dios yarã me ñarãma, tire bʉto tʉoĩarejairãma. Manijʉarema, mani jacʉ ñagʉ̃mi, “Ti rʉyaja, ĩnare” yimasigʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","To bajiri, “Ʉjʉ Dios yarã, quẽnaro ĩ yirã ñaja mani. Ĩ bojarore bajiro quẽnase rĩne yirʉarãja”, yitʉoĩarũgũña mʉa. To bajiro mʉa yijama, adi macarʉcʉroaye mʉa cʉobetire bʉjarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jãjarã me ñaja mʉa. To bajiboarine tʉoĩarejaibesa. Ʉjʉ Dios quẽnase mʉare cõavariquẽnarũgũami. To yicõari, ĩ ñarojʉ õ vecajʉ variquẽnase rãca mʉare bocaãmirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jediro mʉa cʉose gãjerãre ĩsijeocõaña. To yicõari, ti vaja bʉjacõari, maioro bajirãre ĩsima. To bajiro mʉa yijama, õ vecajʉ Dios ĩ ñarojʉ quẽnase bʉjarʉarãja mʉa. Mʉare quẽnaro Dios ĩ yise jedibetirʉaroja. Tojʉre juarudirimasa ejabetirʉarãma. To yicõari, quẽnaro mʉare Dios ĩ yisere barearã manama. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Õ vecaye quẽnase mʉa bʉjaroti jedibetiroti ti ñajare, mʉa cʉosejʉare tire tʉoĩarejaimenane, “Quẽnaro yʉa yise vaja õ vecajʉ vaja tacũrã yaja” yitʉoĩacõari, quẽnaro yirũgũña —ĩ buerimasare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ado bajiro ĩnare gotiyuju Jesús: —Adi macarʉcʉrore vaveorʉcʉja yʉ. To bajiboarine, tudivadirʉcʉja quẽna. Yʉ manitoye quẽne, yʉ bojarore bajiro quẽnaro yicõa ñama, yʉ tudiejarotire tʉoĩayurã ñari —ĩnare yiyuju Jesús. To bajiro yigajanocõari, gotimasiore quetire tʉoĩacõari, ĩnare gotiyuju Jesús: —Sĩgʉ̃ ʉjʉ gãjerã ĩna ãmosiarirʉ̃mʉ, boserʉ̃mʉ ĩna yiro, ĩagʉ̃ vacoacʉmi ĩ. To bajiri ĩ tudiejaroto rĩjoro ĩre moabosarimasa ĩre yurãma ĩna. “¿No cõro tudiejagʉti ĩ?”, yirũgũrãma ĩna. Tudiejacõari, “Manire ĩ jirone, guaro sojere jãnarʉarãja mani”, yitʉoĩarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","To bajiri cãnibetiriarã ñari, ĩna ʉjʉ ĩ tudiejaro, bʉto variquẽnarãma ĩna. To cõrone ĩna ʉjʉ ĩnare rujirotigʉmi. Ĩnare rujiroti, ĩ masune ĩnare bare ecagʉmi, ĩna ʉjʉ ñaboarine. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","To bajiri ñami gʉdareco ti ñacoaboajaquẽne, cãnibetiriarã ñari, ĩna ʉjʉ ĩ tudiejaro, ĩre ĩacõari, bʉto variquẽnarãma ĩna. To bajiri ʉjʉ ĩ manitoyejʉ ĩ tudiejarotire yurã, ĩna cãnibetiriarore bajiro bajicõa ñarʉarãja mʉa, yʉre yurã ñari. Yʉ bojarore bajiro quẽnaro yicõa ñama mʉa. To bajiro mʉa bajijama, yʉ tudiejaro ĩacõari, bʉto variquẽnarʉarãja —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","To yicõari, quẽna gaje queti gotiyuju: —Adi quetire quẽne tʉoĩaña: Sĩgʉ̃ vi ʉjʉ, “Adi ñami juarudirimasʉ ejarʉcʉmi” ĩ yimasijama, roori ñabogʉmi, ĩre matarʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","To bajiri, “Dios ĩ roticõagʉ̃ ĩ tudiejarotire mani masibetirĩmarone tudiejaromi” yirã, roori ñarũgũrʉarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","To bajiro ĩ yijare, sĩgʉ̃ ĩ buerimasʉ, Pedro vãme cʉtigʉ, ado bajiro Jesúre ĩre sẽniĩañuju ĩ: —Yʉ ʉjʉ, ¿tire yʉa rĩrene gotigʉ yati mʉ? ¿Jedirore gotigʉ yatique mʉ? —ĩre yisẽniĩaboayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","To ĩ yirone, ado bajiro ĩre cʉdiyuju Jesús, gaje queti, gotimasiore rãca gotigʉ: —Ado bajiro bajirʉcʉmi yʉre quẽnaro ajitirʉ̃nʉ tʉjabecʉ, quẽnaro tʉoĩagʉ̃: Ʉjʉ, gajerojʉ ñagʉacʉ, ĩ varoto rĩjoro, “Yʉ ya vianare yʉre codebosaba” yigʉ, ĩre moabosarimasʉre ĩ cũvar'ire bajiro bajigʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ĩ ʉjʉ, ĩ rotiriarore bajirone ĩ moayurere tudiejacõari, ĩ ĩaejajama, quẽnaro ĩre yigʉmi, ĩre moabosarimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Riojo mʉare gotiaja yʉ. Ʉjʉ ĩ bojarore bajirone ĩ yire ti ñajare, ĩ cʉose jedirorene, ĩre ĩatirʉ̃nʉrotigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ado bajiro bajirʉcʉmi yʉre quẽnaro ajitirʉ̃nʉbecʉma: Rojose yigʉ ĩ ñajama, ʉjʉ ĩ vato bero, “Yoatojʉ tudiejagʉmi” yitʉoĩagʉ̃ ñari, ĩ ʉjʉre moabosarimasare rojose yigʉmi. To yicõari idimecʉrũgũrãre baba cʉticõari, ĩna rãca idirũgũgʉ̃mi ĩ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","To ĩ yiñarone, ĩ ʉjʉ, tudiejagʉmi. Tudiejacõari, ĩ rotiriarore bajiro ĩ yibetire ti ñajare, rojose ĩre yigʉmi. To bajiri “Quẽnaro yirã ñaja yʉa” yiboarine, ĩna yirore bajiro yimena rojose ĩna tãmʉorore bajirone tãmʉogʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","No bojagʉ ĩ ʉjʉ ĩ bojasere masiboarine, ĩ rotiriarore bajiro ĩ yibetijama, tudiejacõari, bʉto ĩre quẽasĩacõagʉ̃mi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gãjijʉa, ʉjʉ ĩ bojasere masibecʉne ĩ yijama, tudiejacõari, quẽnabʉsane ĩre quẽagʉ̃mi ĩ ʉjʉ —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Quẽna ado bajiro ĩnare gotiyuju Jesús: —“‘Rojose tãmʉotʉjabetiriarojʉ mani vaborotire manire yirẽtobosarʉcʉmi Jesús’ yivariquẽnarona ñato” yigʉ, vadicajʉ yʉ. To bajiro bajicacʉ ñari, gãjerã tire tʉoĩamenare ĩnare soereagʉagʉre bajiro bajicajʉ yʉ. To bajicacʉ ñari, guaro ĩnare yʉ rijabosarotire bojaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“‘Quẽnaro ñato ĩna masa’ yigʉ, vayumi Jesús”, yʉre yitʉoĩabesa mʉa. Dios ĩ bojabeti yirã, yʉ ocare ajijũnisinicõari, yʉre ajitirʉ̃nʉrãre ĩaterʉarãma ĩna. To bajiri ado bajirojʉa yʉre yitʉoĩaña: “‘Ĩ sʉori ricatiri tʉoĩarʉarãma masa’ yigʉ bajiyumi Jesús”, yʉre yitʉoĩaña. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Ado bajiro bajirʉaroja” yigʉ yaja yʉ: Cojo viana ñaboarine, sĩgʉ̃ri yʉre ajitirʉ̃nʉrã ña, gãjerãjʉa yʉre ajiterã ña, bajirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ĩ macʉ, yʉre ĩ ajitirʉ̃nʉjama, ĩ jacʉjʉa ĩre ĩaterʉcʉmi. Jacʉjʉa, yʉre ĩ ajitirʉ̃nʉjama, ĩ macʉjʉa, ĩre ĩaterʉcʉmi. So macojʉa, yʉre so ajitirʉ̃nʉjama, so jacojʉa, sore ĩaterʉocomo. Jacojʉa, yʉre so ajitirʉ̃nʉjama, so macojʉa, sore ĩaterʉocomo. So jẽjojʉa yʉre so ajitirʉ̃nʉjama, so ũmañicojʉa, sore ĩaterʉocomo. So ũmañicojʉa yʉre so ajitirʉ̃nʉjama, so jẽjojʉa, sore ĩaterʉocomo —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","To yicõari, ado bajiro ĩnare gotirũtuasuju Jesús, jãjarã masare: —Muiju ĩ rocasãtojʉa bueri ti vadijama, “Oco quedirʉaja”, yiĩamasiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","To yicõari, mino varuagũmuaye ti vẽatujama, “Bʉto asirʉcʉmi muiju”, yiĩamasiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ñamasuse mere ĩamasicõari, “Masirã ñaja yʉa”, yitʉoĩaboaja mʉa. Ñamasusejʉare masibeaja mʉa. Adirʉ̃mʉri yʉ yisere ĩarã ñaboarine, “Dios ĩ roticõar'i ñari, yami”, yiĩamasibeaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ado bajiro ĩnare gotiyuju Jesús quẽna: —¿No yirã mʉa masune yʉ yisere ĩacõari, “¿To bajirojʉa yiroti ñatique?”, yitʉoĩabeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gãjire rojose mʉa yijama, oca quẽnorimasʉ tʉjʉ mʉa ejaroto rĩjoro, ĩ rãca oca quẽnoroti ñaja mʉa jʉarãne. Oca quẽnorimasʉ tʉ ejamenane, mʉa oca quẽnobetijama, masare coderimasʉre juarotirʉcʉmi, mʉare. Ĩjʉa, mʉare tubiberʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Riojo mʉare gotiaja yʉ. Rojose mʉa yire vaja mʉa vaja yibetijama, budimenaja mʉa. Tire bajirone bajirʉaroja. Dios ĩ vaja sẽnirirʉ̃mʉ ejaroto rĩjorojʉa, rojose mʉa yir'ire ĩre oca quẽnoña. Mʉa gãmerã oca quẽnobetijama, Dios ĩ vaja sẽnirirʉ̃mʉ ti ejaro, rojose tãmʉotʉjabetiriarojʉ, tudibudiyamanojʉ mʉare cõarʉcʉmi —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tirʉ̃mʉne queti gotirã Jesús tʉjʉ ejayujarã ĩna. Ĩ tʉjʉ ejacõari, ado bajise ĩre gotiyujarã ĩna: —Galilea sitana, Diore yirʉ̃cʉbʉoriavijʉ sãjaejacõari, Diore rʉ̃cʉbʉorã, vaibʉcʉrãre sĩañujarã ĩna. To ĩna bajirone, Ʉjʉ Pilato ĩ yarãre ĩnare sĩaroticõañuju —Jesúre yigotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","To bajiro ĩna yigotisere ajicõari, ado bajiro ĩnare gotiyuju Jesús: —Galileana ĩna bajiyayirere mʉare gotirʉcʉja yʉ: Bʉto rojose ĩna yise vaja me bajiyayiyujarã ĩna. Gãjerã Galileana rẽtoro rojose yirã me ñaboayujarã ĩna. Mʉa quẽne, rojose mʉa yisere mʉa tʉoĩavasoabetijama, bajiyayicoarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","5","Siloé vãme cʉti macajʉre cojo vi, juriaquediato, jʉaãmocãrãcʉ, cojo gʉbo jedi, gaje gʉbo idia jẽnituarirãcʉ masare sĩañuju ti. Bʉto rojose ĩna yire vaja me bajiyayiyujarã ĩna quẽne. Gãjerã Jerusalén macana rẽtoro rojose yirã me ñaboayujarã ĩna. Mʉa quẽne rojose mʉa yisere yitʉjacõari, Dios ĩ bojarore bajirojʉa mʉa yibetijama, bajiyayicoarʉarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Quẽna gaje queti gotimasiore queti ĩnare gotiyuju Jesús: —Sĩgʉ̃ masʉ vese cʉtigʉ ñagʉ̃mi. Ĩ ya vesere higuera vãme cʉtiʉre otegʉmi. Ĩ oter'i, “Bʉcʉa, rica cʉticoatoja ti” yigʉ, ĩagʉ̃ vacʉmi. Vaejacõari, ĩaboagʉmi. Rica manicõaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","To ñagʉ̃mi, ĩ vesere codebosarimasʉ. To bajiri, ĩjʉare ado bajiro gotigʉmi: “Jẽre idia cʉ̃ma tiʉre rica macaboaja yʉ. Rica manirũgũaja ti. Quẽarocacõaña mʉ, tiʉre. Rojoricʉ ñaja ti. Gaji ote vasoaroti ñaja”, ĩre yigotigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","To ĩ yiboajaquẽne, ado bajiro ĩre cʉdigʉmi vese coderimasʉ: “Maji. Quẽarocabeticõato mani. Adi cʉ̃mare quẽne quẽnaro tiʉre ĩacoderʉaja yʉ. Sita quẽnase tu, vaibʉcʉrã gʉda quẽne tu, quẽnaro tiʉre code, gaje cʉ̃ma gãme tudiĩarʉarãja mani quẽna. To cõrone ti rica manicõajama, quẽarocarʉarãja mani”, ĩre yicʉgʉdimi vese coderimasʉ —ĩnare yigotiyuju Jesús ");
INSERT INTO bsnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ʉsʉsãjariarʉ̃mʉ ti ñaro Dios ocare ĩna buerivijʉ masare gotimasio ñañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ĩnare ĩ gotimasio ñarojʉre ñañuju sĩgõ rõmio. Yoaro, jʉaãmo cõro, cojo gʉbo jedi, gaje gʉbo idia jẽnituarirãca ñaricʉ̃mari so ʉsʉjʉ vãti ĩ sãñajare, mubiarine ñacõañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","To so bajiñasere ĩacõari, sore yiyuju. —Jẽre mʉ rijaye cʉtise mʉre jedicoajʉ ti —sore yiyuju Jesús. To yigʉne, so sʉyarojʉa joere ĩ ãmori ñujeoyuju. Ĩ ñujeorirĩmarone, riojo vʉ̃mʉjocoasuju so yuja. Vʉ̃mʉjogone, ado bajiro gotiyuju: —Jesús sʉorine quẽnaro yʉre yami Dios —yigotiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","To bajiro so yiboajaquẽne, Dios ocare ĩna buerivi ʉjʉ, so quẽnaejasere ĩacõari, Jesúre ĩajũnisiniñuju ĩ. “Ʉsʉsãjariarʉ̃mʉre catiorotibeama ʉjarã. To bajiri, ‘Rojose yigʉ ñaami’ ”, Jesúre yijũnisiniñuju ĩ. To bajiro Jesúre ĩre yijũnisinigʉ̃ ñari, ado bajiro masajʉare gotiyuju: —Tocãrãca semana, cojomo cõro coja jẽnituarirãcarʉ̃mʉri, moariarʉ̃mʉri ñaja ti. To cõrojʉ mʉa catirotire sẽnirã vadirũgũroti ñaja. Adirʉ̃mʉ ʉsʉsãjariarʉ̃mʉ ũnorema to bajiro yirã ejabesa mʉa —ĩnare yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","To bajiro ĩnare ĩ yirone, ado bajiro ĩre gotiyuju Jesús: —“Quẽnaro yirã ñaja yʉa” yitʉoĩaboarine, rojorã ñaja mʉa. Ʉsʉsãjariarʉ̃mʉ ti ñaboajaquẽne, mʉa ta vecʉare, burroare, bare ecariavijʉ ñarãre ĩnare jojiocõari, ĩna oco idirojʉ tʉ̃a varũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","To bajiro mʉa yirũgũse ñajare, adiore yʉ catiosere ĩacõari, bʉto variquẽnaroti ñaboaja mʉare. Vaibʉcʉ me ñaamo. Mani yo, Abraham ñamasir'i jãneñone ñaamo so. Vãtia ʉjʉ sore siacõari, cʉogʉre bajiro yiyumi. Jʉaãmo cõro, cojo gʉbo jedi, gaje gʉbo idia jẽnituarirãca cʉ̃mari to bajiro sore cʉoñañumi. To bajiro sore ĩ yicʉoñajare, “Ʉsʉsãjariarʉ̃mʉne sore catiocõaroti ñaroja”, yibʉ yʉ. Mʉa quẽne yʉre bajiro tʉoĩamasiña —ĩre yiyuju Jesús, ti vi ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","To bajiro ĩ yisere ajicõari, “Riojo gotiami”, yibojoneñujarã ĩna, ĩre tud'iriarã. Gãjerãjʉama, bʉto variquẽnañujarã ĩna, jediro quẽnase rĩne Jesús ĩ yirũgũsere ĩacõari. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Higuera, rica manire sĩgʉ̃ ĩ rocare queti Jesús ĩ gotiro bero, ado bajirone masare gotimasioñuju: —“Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõagʉ̃, yʉ gotimasiosere no bojarã ĩna ajitirʉ̃nʉjama, mʉare yʉ gotisere mojoroaca ajimasiboarine, rojose ĩna ñare cʉtisere tʉoĩavasoacõari, tocãrãcarʉ̃mʉri quẽnaro ñamʉjarʉ̃gʉ̃cõari, quẽnaro ajimasimʉjarʉ̃gʉ̃jama, ado bajiro bajirʉaroja: ");
INSERT INTO bsnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sĩgʉ̃ ĩ ya vese mostaza ajea otegʉmi. To bajiri ĩ oterica mojoricaca ñaboarine, ti judibʉcʉacoajama, ote yucʉ́ri rẽtobʉsaricʉ jairicʉ ñaroja tiʉ. Jairicʉ ti ñajare, tiʉ rʉjʉrijʉ minia ĩna ria cʉtirotijʉrire quẽnorãma ĩna —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Quẽna ado bajiro gotimasioñuju Jesús: —“Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios ĩ cõagʉ̃, yʉ gotimasiosere no bojarã ĩna ajitirʉ̃nʉjama, mʉare yʉ gotisere mojoroaca ajimasiboarine, rojose ĩna ñare cʉtisere tʉoĩavasoacõari, tocãrãcarʉ̃mʉri quẽnaro ñamʉjarʉ̃gʉ̃cõari, quẽnaro ajimasimʉjarʉ̃gʉ̃jama, ado bajiro bajirʉaroja: ");
INSERT INTO bsnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Rõmio, pan quẽnogoago, trigo vetare idiaji vasãcõari, pan ũmato vauvasere vʉogomo so. To so yijare, jairo vauvaroja ti. Tire bajirone bajirʉaroja, Diore rotibosagʉre yʉre ajitirʉ̃nʉrã jãjarãbʉsa mʉa bʉjʉroti —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalénjʉ vacʉ ñaboarine, tocãrãca maca ĩ rẽtorimacarire ĩnare gotimasiovasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","To ĩ bajivatone, sĩgʉ̃ ĩ rãcagʉ ĩre sẽniĩañuju ĩ: —¿Yʉ ʉjʉ, masa rojose tãmʉotʉjabetiriarojʉ vaborona Dios ĩ yirẽtobosarona, mojoroaca ñarãti? —ĩre yisẽniĩañuju, Jesúre. To bajiro ĩ yisere ajicõari, ĩ rãcanare ado bajiro ĩnare gotimasioñuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ʉjʉ Dios yarã quẽnaro ĩ yirã mʉa ñarʉajama, eyabetisojere sãjarãre bajiro josarʉarãja mʉa. Ti josaboajaquẽne, ĩ yarã ñaña mʉa. Riojo mʉare gotiaja yʉ: Ĩ yarã mejʉama, jãjarã ñarʉarãma õ vecajʉ eyabetisoje sãjarʉaboarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","26","Soje bibero bero ejarʉarãma ĩna. To bajicõari, sojere jãnamasimena ñari, ado bajiro yʉre sẽniĩaboarʉarãma ĩna: “Ʉjʉ, soje jãnaña mʉ” yʉre yiboarʉarãma. To ĩna yirone, “Mʉare masibeaja yʉ”, ĩnare yirʉcʉja yʉ. To bajiro ĩnare yʉ yisere ajicõari, ado bajiro yʉre yirʉarãma ĩna: “Mʉ rãca bare ba, idi, yicanane ñaja yʉa. Yʉa ya macajʉre ejacõari, yʉare gotimasiocajʉ mʉ”, yiboarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","To ĩna yirone, “‘Jẽre mʉare masibeaja’ yigotigajanomʉ yʉ. ¡Vasa! Rojorã ñaja mʉa”, ĩnare yirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","To yʉ yirone, ĩna ñicʉa, Abraham, Isaac, Jacob, to yicõari Diore gotirẽtobosamasiriarã ñajediro Dios tʉjʉ quẽnaro ĩna ñasere ĩacõari, bʉto sʉtiritirʉarãma ĩna, ĩnare yʉ sãjarotibetijare. To bajicõari, bʉto rojose tãmʉorã ñari, guji põguẽ, oti, yirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","To bajiboarine Dios tʉjʉ ejarʉarãma gãjerã. Muiju ĩ jiado vadiriarã, ĩ rocasãto vadiriarã, to yicõari varuaga soje vadiriarã, gajejacatʉa varuaga soje vadiriarã ñarʉarãma. Tojʉre ĩ rãca barujirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jãjarã adojʉ ñamasurã, õ vecajʉarema ñamasumena ñarʉarãma ĩna. Adi macarʉcʉrojʉ jãjarã ñamasumenama, õ vecajʉarema ñamasurã ñarʉarãma —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","To bajiro ĩ yigotimasiorone, Jesús tʉjʉ ejayujarã fariseo masa sĩgʉ̃ri. Ĩ tʉjʉ ejacõari, ado bajiro gotiyujarã ĩna: —Gajerojʉ vacoasa mʉ. Ʉjʉ Herodes, mʉre sĩarʉ macañañuju ĩ —Jesúre yigotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Herodere quẽnaro tʉoĩagʉ̃re ado bajiro ĩre gotiba mʉa: ");
INSERT INTO bsnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Moaroti ñaja yʉre maji. Masa ʉsʉrijʉ sãñarãre vãtiare ĩnare burearoti, to yicõari rijaye cʉtirãre catioroti ñaja yʉre maji. Yʉma, yʉ bajiñarotire quẽnaro masiaja yʉ. To bajiri Jerusalénjʉne vacʉ bajiaja yʉ. To bajiro yʉre varotiami Dios. Tone Diore gotirẽtobosamasiriarãre sĩarearũgũmasiñujarã ĩna, masa. Tone yʉre quẽne sĩarʉarãma ĩna”. To bajiro yʉ gotisere yʉre gotibosaba mʉa —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","To bajiro ĩnare yigajanocõari, Jerusalén macanare ĩre ĩna sĩarocaro bero ĩna bajirotire tʉoĩacõari, ado bajiro yiyuju Jesús: —Jerusalén macana, Diore gotirẽtobosamasiriarãre sĩamasiriarã jãnerabatia ñacõama ĩna. Dios ĩ cõamasiriarãre ĩ ocare gotimasiorimasare gʉ̃tane ĩnare reasĩamasiriarã jãnerabatia ñaama. Cojoji me gãjaboco so querʉjʉ ẽñeroca so rĩare so juarẽorore bajiro ĩnare yirʉaboacajʉ yʉ, ĩnare coderʉ. To bajiro yʉ yirʉaboajaquẽne, ĩnajʉa yʉre bojabeticama. ");
INSERT INTO bsnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","To bajiri jẽre “Ĩna ñarijʉre codetʉjacõaja yʉ yuja”, yitʉoĩami Dios. Riojo gotiaja yʉ: “‘¡Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i vadiami! ¡Quẽnase ĩre yivariquẽnato mani! ¡Diore rotibosagʉ ĩ ñajare, ĩre quẽnaro yato Dios!”, yʉre ĩna yiroto rĩjoro, quẽna jʉaji yʉre ĩabetirʉarãma ĩna —ĩnare yitʉoĩa ñagõñuju Jesús, Jerusalén macanare. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ʉsʉsãjariarʉ̃mʉ ti ñaro, fariseo masa ʉjʉ ya vijʉre bagʉ vasuju Jesús. Tojʉ ĩ ejaro, “Jesús, rojose yimi” ʉjarãre yi ocasãrʉarã, Jesúre quẽnaro ĩacodeyujarã ĩna, fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tojʉ ñañuju sĩgʉ̃, ĩ rujʉ jediro ʉcʉgʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","To bajiri fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne ĩna tʉoĩasere masicõari, ado bajiro ĩnare sẽniĩañuju Jesús: —¿Adirʉ̃mʉ ʉsʉsãjariarʉ̃mʉre rijaye cʉtirãre manire catiorotibeati Dios oca masa ĩna ucamasire? —ĩnare yisẽniĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","To bajiro ĩ yiboajaquẽne, ĩre cʉdibesujarã ĩnajʉama. To bajiri ʉcʉgʉre jicõari, ĩre catioyuju Jesús. To yicõari, ĩre varotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ĩre varoticõari, ĩ vato bero ñarãre ado bajiro ĩnare gotiyuju ĩ: —Ta vecʉ mʉa ecar'i, gojejʉ ĩ quedirocasãjama, “Ʉsʉsãjariarʉ̃mʉ ñaja” yirã, ¿ãmirã vamenada mʉa? —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","To ĩ yisere ajicõari, no bajiro ĩre cʉdimasibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","To ĩ yiro bero, tojʉ barã ejarã, rʉ̃cʉbʉoriajʉrire rujirʉayujarã ĩna. To ĩna bajisere ĩacõari, ado bajiro ĩnare gotimasioñuju Jesús quẽna: ");
INSERT INTO bsnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—No bojagʉ ĩ ãmosiarotire “Ĩarã vadiato” yigotiecorã mʉa ñajama, ĩ tʉjʉ ejarãne, rʉ̃cʉbʉoriajʉ rujibeja. To bajiro mʉa bajibetijama, rʉ̃cʉbʉoriajʉ mʉa rujiro bero gãji mʉa rẽtoro ñamasugʉ̃ ĩ ejajama, ado bajiro mʉare gotirʉcʉmi vi ʉjʉ: “Tʉsarojʉa rujiaya mʉama. Ãnijʉa, mʉa bero ejagʉjʉa, adore rujirʉcʉmi”, mʉare yirʉcʉmi. To bajiro ĩ yirone, bʉto bojonerʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","To bajiri “Ĩarã vadiato” mʉare ĩna yijama, ĩna tʉjʉ ejacõari, tʉsarojʉa rujiba mʉa. Vi ʉjʉ, mʉare ĩacõari, “Rʉ̃cʉbʉoriajʉjʉa rujiaya mʉa”, yirʉcʉmi. To bajiro mʉare ĩ yiro ajiri, mʉare yirʉ̃cʉbʉorʉarãma ĩna, rujirã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ado bajiro ti bajijare, to bajiro bajiaja: No bojagʉre, ñamasugʉ̃ ñarʉagʉre, “Ñamasugʉ̃ me ñato”, ĩre yirʉcʉmi Dios. No bojagʉre, “Ñamasugʉ̃ me ñaja yʉ” yigʉ, quẽnaro gãjerãre yirʉ̃cʉbʉogʉjʉare, “Ñamasugʉ̃ ñato”, ĩre yirʉcʉmi Dios —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","To yigajanocõari, viagʉre ado bajiro ĩre gotiyuju Jesús: —Gãjerãre mʉ barotijama, mʉ babarãre, mʉ yarãre, to yicõari, jairo cʉorãre mʉ tʉanare, ĩnare barotibeticõaña. Ĩnare mʉ barotijama, bero ĩnajʉa quẽna barotirãma, cʉorã ñari yibeticõaña. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","To bajiri, gãjerãre mʉ barotijama, ñie cʉomenare, micarãre, rujasagueri vanare, to yicõari, ĩamenare quẽne barotiya mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ĩnajʉama mʉre bare ecamasimenama ĩna, mojoroaca cʉorã ñari. To bajiro ĩnare mʉ yijama, bʉto variquẽnarʉcʉja mʉ. Berojʉ ĩ bojarore bajiro yiriarãre rijariarãre, ĩ catiorirʉ̃mʉjʉ mʉre vaja yirʉcʉmi Dios, to bajiro mʉ yise vaja —viagʉre yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","To bajiro ĩ yisere ajicõari, sĩgʉ̃, Jesúrãca barujigʉ, ado bajiro ĩre gotiyuju: —Ʉjʉ Dios tʉjʉ õ vecajʉ ĩ rãca barona variquẽnarʉarãja mani —Jesúre ĩre yigotiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —To bajirone bajiboroja, Dios tʉjʉ mʉ ejajama —ĩre yicʉdiyuju Jesús. To yicõari, gotimasiore quetire gotiyuju: —Cojorʉ̃mʉ sĩgʉ̃ masʉ quẽnaro boserʉ̃mʉ yigʉmi. Tirʉ̃mʉ ñaroto rĩjoro jãjarã masare jigʉmi, ĩnare ũmato barʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","To bajiri boserʉ̃mʉ ti ejaro, ĩre moabosagʉre cõagʉ̃, ado bajiro ĩre yigʉmi: “Yʉ rãca barona barã vadiato ĩna. ‘ “Bare quẽnogajanoaja yʉ jẽre”, mʉare yicõami’ ĩnare yigotiba”, ĩre yigotigʉmi, ĩre moabosarimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","To bajiro ĩ yicõar'i, gãjerãre jicudiboagʉmi. Ĩna ñajediro ricatine ĩre boca cʉdirãma ĩna. Ĩ jisʉogʉ ado bajiro ĩre cʉdigʉmi: “Cojotũcuro oteriatũcuro vaja yibʉ yʉ. Tojʉre ĩagʉacʉ yaja yʉ. To bajiri, ‘Ĩ tʉjʉ bagʉ varʉaboarine, vamasibeaja’ yʉre yigotibosaba”, ĩre yicʉdigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gãjima, ado bajiro ĩre cʉdigʉmi: “‘Cojomocãrãcʉ ta vecʉa vaja yibʉ yʉ. Ĩnare ĩaĩagʉacʉ yaja’ yicõami. To bajiri, ‘Vadimemi’ ĩre yicõama, mʉ ʉjʉre”, ĩre yicʉdigʉmi, ĩ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gãjijʉama, ado bajiro yigʉmi quẽna: “Manajo cʉticoajʉ yʉ, yucʉacane. To bajiri boserʉ̃mʉ ĩagʉ̃ vamasibeaja yʉ”, ĩre yicʉdigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","To bajiro ĩna yijare, ĩ ʉjʉ ya vijʉ tudiejacõari, ĩna yicõasere ĩre gotigʉmi. To bajiro ĩna yicõasere ĩ gotiro ajijũnisinigʉ̃mi ĩ ʉjʉ. Jũnisinigʉ̃ne, ado bajiro rotigʉmi quẽna: “¡Guaro vasa mʉ! ¡Macari ñajediro vasa mʉ! Ñie cʉomenare, micarãre, ĩamenare, rujasagueri vanare, ĩnare jiba. Ĩnajʉa, yʉ tʉjʉ barã vadiato ĩna”, ĩre yigotigʉmi, ĩre moabosarimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","To bajiri ʉjʉ ĩ yirore bajiro yigoticudigʉmi ĩre moabosarimasʉ. Ĩ goticudiro bero, tudiejacõari, ado bajiro ʉjʉre gotigʉmi: “Ʉjʉ, yʉre mʉ roticõarore bajirone ĩnare gotigajanomʉ yʉ yuja. Masa bojarẽmocõaja maji”, yigotigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","To bajiro ĩ yijare, ado bajiro ĩre rotigʉmi ʉjʉ quẽna: “Maca tʉsaroanare maa tʉri ñarãre quẽne ĩnare jijeocõama mʉ. ‘Yʉ vi jʉ̃mʉcoajaro’ yigʉ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘Yʉ rãca baroadiato’ yʉ yicõaboarãjʉama, yʉ rãca babetirʉarãma ĩna”, ĩre yigʉmi ĩ ʉjʉ —ĩre yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tirʉ̃mʉri jãjarã masa Jesúrãca vasujarã ĩna. To ĩna bajiro jʉdarʉ̃gʉ̃, ĩnare ĩacõari, ado bajiro gotiyuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—No bojagʉ yʉ buegʉ, ĩ jacʉre, ĩ jacore, ĩ manajore, ĩ rĩare ĩ mairo rẽtobʉsaro yʉre maigʉ̃mi. To bajicõari, catiquẽnagʉ̃ ñagʉ̃ quẽne, rijaye tãmʉo gajajuagʉ ñaboarine, yʉre maigʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","No bojagʉ, “Jesúre bajiro rojose tãmʉosʉyarʉcʉja yʉ” yitʉoĩabecʉ, yʉre ajitirʉ̃nʉgʉ̃ ñamasibecʉmi —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","To yigajanocõari, gotimasiore queti ĩnare gotiyuju ĩ: —Ʉ̃mʉarivi quẽnorʉ, “Ti vire yʉ quẽnojama, ¿vaja tĩjacoarʉaboati?” yigʉ, ĩ ye gãjoare cõĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ĩ cõĩabetijama, ti vire ĩ quẽnogajanobetone, ĩ vaja yiñaboase gãjoa jediveocoatoja ti, ĩre. To bajiri ĩ vire quẽnogajanobecʉmi. Gãjerã, ĩ quẽnogajanobeto ĩacõari, ĩre ajarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Adi vire quẽnoboarine, gajanomasibeami ĩ”, ĩre yiajarãma ĩna —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","To yigajano, gaje queti ĩnare gotirũtuasuju: —Ʉjʉ, gãji ʉjʉ rãca ĩna gãmerã quẽajama, ado bajiro tʉoĩagʉ̃mi: “¿Yʉa diez mil ñarirãcʉ yʉre moabosarimasa rãca, veinte mil masa cʉogʉre quẽarẽtocũrãjari yʉa?”, ¿yitʉoĩasʉobecʉjarique? ");
INSERT INTO bsnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Ĩnare quẽarẽtomasimenaja yʉa” ĩ yitʉoĩajama, “¿No bajiro yʉa yirotire bojati mʉ, ‘Yʉa rãca gãmerã quẽabeticõato’ yirã?”, ĩ ʉ̃mʉare yisẽniĩa roticõagʉ̃mi, gãji ʉjʉ tʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","To bajiri, vi bʉagʉre, to yicõari, gãmerã sĩaroana ʉjʉre bajiro bajiaja yʉ. Jẽre yʉ yirotire cõĩajeocajʉ yʉ. To yicõari, “To bajiro ĩna yijama, yʉ buerã ñarʉarãma”, yimasiaja yʉ. To bajiro yigʉ yʉ ñajare, ado bajisere tʉoĩamasiña mʉa: No bojagʉ, jediro ĩ cʉosere yʉ bojarore bajiro yʉ yirotisere bojabecʉ, yʉre ajitirʉ̃nʉgʉ̃ ñamasibecʉmi —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Quẽna ado bajiro gotiyuju Jesús: —Moa ñaja bare sãre. Mʉa barotire vaibʉcʉ rii catisere cũrãma, moa turãja mʉa, “Boarobe” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Moa ti ocaboase ti ocabeticoajama, “Quẽna tudiocato” yirã, no bajiro yimasimenaja mʉa. To bajiri, tire reacõarãja mʉa. Moa ocatʉjabetire bajiro mʉa bajijama, quẽnaja. Tire mʉa ajimasirʉajama, quẽnaro tʉoĩaña mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesúre ajirã ĩ tʉjʉ ejarũgũñujarã. Ĩna ñañujarã rojose yirã, ʉjʉre gãjoa sẽnibosarimasa, to yicõari, gãjerã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","To bajiri fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne ñañujarã. Ado bajiro Jesúre gõjañujarã ĩna: —Rojose yirãre maiami. Ĩna rãca barũgũami —ĩre yigõjacodeyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","To bajiro ĩna yijare, gotimasiore queti ado bajiro ĩnare gotimasioñuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Sĩgʉ̃ ñagʉ̃mi cien ovejare codegʉ. Cojorʉ̃mʉ sĩgʉ̃ oveja yayicoacʉmi. To bajiri ĩnare coderimasʉ, rʉyarãre, noventa y nueve ñarãre ta vesejʉ ĩnare cũcõari, yayir'ire macagʉ̃ vacoacʉmi ĩ, “Bʉjacõarijʉ tʉjarʉcʉja” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yayir'ire bʉjacõari, bʉto variquẽnagʉ̃ne, ĩre gaja tudicoacʉmi, ĩ ya vijʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ĩ ya vi ejacõari, ĩ babarãre, ĩ tʉanare quẽne, rẽjarotigʉmi. “Oveja yayir'ire bʉjabʉ yʉ. Mʉa quẽne yʉre variquẽna ejarẽmoña”, ĩnare yivariquẽnagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tire bajiro bajiroja õ vecajʉ Dios ĩ ñarojʉ. Oveja yayir'ire bʉjacõari, ĩ variquẽnariarore bajiro variquẽnarãma ángel mesa, Diore moabosarã, sĩgʉ̃ masʉ, rojose ĩ yisere yitʉjacõari, Dios ĩ bojasejʉare ĩ yijama. Socarãne gãjerãma, “Quẽnarã ñaja yʉa” yitʉoĩarãrema variquẽnamenama ángel mesa —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","To yicõari, gaje queti gotirẽmoñuju Jesús quẽna: —Rõmio, jʉaãmocãrãcatiiri, gãjoatiiri cʉogo ñagõmo. Cojotii ti yayiro ĩacõari, sĩabusuoriare so ya vire sĩabusuogomo so. To yicõari, quẽnaro tumacagõmo, “Titiire bʉjacõarijʉ tʉjarʉocoja” yigo. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Titiire bʉjacõari, bʉto variquẽnagõne, so babarãre, so tʉanare quẽne rẽjarotigomo. “Gãjoatiire yayiritiire bʉjabʉ yʉ. Mʉa quẽne yʉre variquẽnaejarẽmoña”, ĩnare yivariquẽnagõmo. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tire bajiro bajiroja õ vecajʉ Dios ĩ ñarojʉ. Gãjoatiire bʉjacõari, so variquẽnariarore bajiro variquẽnarãma ángel mesa, Diore moabosarã, sĩgʉ̃ masʉ, rojose ĩ yisere yitʉjacõari, Dios ĩ bojasejʉare ĩ yijama —ĩnare yigotimasiñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","To yicõari, gaje queti gotirẽmoñuju Jesús quẽna: —Sĩgʉ̃ masʉ jʉarã rĩa cʉtigʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ĩ bedijʉa, ĩ jacʉre ado bajise ĩre yigʉmi: “Cacʉ, yʉ ye ñarotire yʉre ĩsiña mʉ”, ĩre yigʉmi. To bajiro ĩ yijare, ĩnare ʉjojeocõagʉ̃mi ĩ jacʉ, ĩna ye ñarotire. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","To ĩ yiro beroagarʉ̃mʉrine, ĩ macʉ, ĩ bedijʉa gaje sitajʉ varʉ ĩ yere ĩsigʉ̃mi ĩ. Ti gãjoa rãcane vacoacʉmi, gaje sitajʉ vacʉ. Tojʉ ejacõari, rujajine ĩ gãjoare yibatereajeocõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","To bajiro yireacõari bero, josari tãmʉogʉ̃mi, tojʉre. To ĩ bajiñarone, ti sitajʉ bare quẽnaro manoja. To ti bajijare, bʉto ñiorijasʉogʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","To bajiro bajiboacʉ, toagʉre moare sẽnigʉ̃mi ĩ. To bajiri ecariarã yeseare ĩre coderotigʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ĩnare codeñagʉ̃jʉ, yesea ĩna basene barʉaboagʉmi, mano ñiorijagʉ ñari, ñimʉjʉane ĩre ĩna bare ecabecʉ ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","To bajiñaboacʉ, tʉoĩagʉ̃mi ĩ: “Yʉ jacʉ moabosarimasarema jãjarã ĩna ñaboajaquẽne, ĩna base rʉyaquẽnacʉda ti. No yigʉ yʉma adojʉre ñiorija ñati yʉ”, yitʉoĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","To yi, “Baʉ. Cacʉ ya vijʉ tudiarocʉ ñagʉ̃ja yʉ. Tojʉre tudiejacõari, ado bajise Cacʉre ĩre yirʉcʉja yʉ: ‘Cacʉ, rojose yicajʉ yʉ, Diore, mʉre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","To bajiri macʉ yʉre mʉ yise bojabeaja yʉ. Mʉre moabosarimasʉre bajirojʉa yʉre yiya mʉ’ yʉ jacʉre ĩre yicõa ejarʉcʉja yʉ”, yitʉoĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","To yi, ĩ jacʉ ĩ ñarojʉa tudicoacʉmi, maane. To bajiro ĩ bajivato, sõjʉne ĩ jacʉ bocaĩacõari, ĩre ĩamaigʉ̃mi. To bajiri ĩre vabocacõari, jabario, usu, ĩre yigʉmi, ĩ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","To bajiro ĩ yirone, “Cacʉ, Diore rojose ĩre yicajʉ. Mʉre quẽne rojose mʉre yicajʉ yʉ. To bajiri macʉ yʉre mʉ yise bojabeaja yʉ”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","To bajiro ĩ yiboajaquẽne, ĩre moabosarimasare jicõari, “Sudi quẽnase masure juaáya. To yicõari, ĩre sudi sãña. Ãmo sãriabedore quẽne ĩre sãña. Gʉbo sudire quẽne ĩre sãña. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","To yicõari, ta vecʉ mame jaigʉre ĩre sĩaña mʉa. Ĩre bacõari, basavariquẽnato mani. Yʉ macʉre, ‘Rijacoarimi’ ĩre yirũgũboabʉ yʉ. Caticõañumi”, ĩnare yigʉmi ĩ jacʉ. To yicõari, ĩre basajeorãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","To bajiro ĩna yiñarijʉre ĩ macʉ ñasʉogʉjʉama, vesejʉne bocañacõagʉ̃mi. To bajiñaboacʉ, tudiacʉmi yuja. Tudiacʉ, ĩ ajicõñarũtu vajama, to basa ocaruyu ñarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","27","Tire ajicõari, ĩ jacʉre moabosarimasʉre ĩre sẽniĩagʉ̃mi, “¿Ñiere yirã yiri ĩna?” yigʉ. To bajiro ĩ yirone, “Mʉ bedi tudiejami. To bajiri ta vecʉ mame jaigʉre sĩarotimi mʉ jacʉ, mʉ bedi ĩ tudiejajare”, ĩre yigʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","To bajiri tire ajicõari, bʉto jũnisinigʉ̃mi, ĩ gagʉ, vire sãjarʉabecʉ. To bajiri ĩ jacʉ tire, “¡To bajibeticõaña mʉ!” yigʉ, budiacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","To bajiro ĩ bajirone, ado bajise ĩ jacʉre ĩre yigʉmi: “Tocãrãca cʉ̃ma mʉ ye moarere mʉre moabosarũgũboacajʉ yʉ. To bajiboarine, divatojʉane no sĩgʉ̃ vaibʉcʉaca cabrito vãme cʉtigʉacare, ‘Ĩ babarã rãca basavariquẽna bato ĩna’ yigʉ, yʉre ĩsibeticajʉ mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","To bajiboarine, mʉ macʉ rojorã rõmiri rãca mʉ ye gãjoare yireagʉ var'ijʉarema, ta vecʉ mame jaigʉre sĩacõari, basavariquẽnaja mʉ”, ĩre yigʉmi, ĩ jacʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","To bajiro ĩ yijare, ado bajiro ĩre cʉdigʉmi ĩ jacʉ: “Ado yʉ rãcane ñacõarũgũaja mʉ. To bajiri yʉ cʉose jediro mʉ ye ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yucʉrema basavariquẽnato mani, mʉ bedi, ‘Rijacoarimi’ yʉ yirũgũboagʉ, gãme tudiejami. Ĩre bʉjacõaja mani yuja”, ĩre yigʉmi ĩ jacʉ —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ado bajise ĩ buerimasare gotiyuju Jesús quẽna: —Sĩgʉ̃ gajeyeũni jaigʉ ĩ yere codebosagʉre ĩre cʉogʉmi. Gãjerãjʉa, “Mʉ yere yibatereagʉ yami”, ĩre yigotirãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","To bajiro ĩna yisere ajicõari, ĩ yere codebosagʉre ĩre jicõari, ado bajiro ĩre yigʉmi: “Gãjerã, mʉ yibatereasere gotiama. To bajiri mʉ yisere cõĩari, ucatucõaña mʉ. Yʉ yere codebosabetirʉcʉja mʉ yuja”, ĩre yigotigʉmi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","To bajiro ĩ yijare, ado bajiro tʉoĩarejaigʉmi ĩre codebosarimasʉ: “¿No bajiro bajigʉti yʉ? Yʉ ʉjʉ yʉre bucõarʉcʉmi yuja. No gajeye moare bʉjabecʉja yʉ yuja. Ote oteroti ñarore coatĩmabecʉja yʉ. Bojoneose, gãjerãre gãjoa sẽnibecʉja yʉ”, yitʉoĩarejaigʉmi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","To bajiro yitʉoĩarejaiboacʉ, “Jẽre yʉ yirotire masiaja yʉ yuja, ‘yʉ ʉjʉ yʉre ĩ buro bero, gãjerã ĩna ya virijʉ yʉ ejaro yʉre ĩamaiato ĩna’ yigʉ”, yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","To bajiri ĩ ʉjʉre vaja morãre ĩnare jijeocõagʉ̃mi. To bajiro yitʉoĩar'i ñari, sĩgʉ̃ ĩ ejaro, ado bajiro ĩre yigʉmi: “¿No cõro yʉ ʉjʉre vaja moati mʉ?”, ĩre yisẽniĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","To bajiro ĩ yisẽniĩarone, “Cien ñarirajeri ʉyerajeri bare roagʉ sãvʉorere tire vaja moaja yʉ”, ĩre yigʉmi. To bajiro ĩ yirone, “Jaʉ. Rujiya. ‘Adi mʉ vaja more tuyarijũrore mojoroaca cincuenta ñaro vaja moaja’ yiucatu vasoatoya”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","To bajiro ĩre yigajanocõari, gãji ĩ ejaro, ĩre sẽniĩagʉ̃mi: “¿No cõro vaja moati mʉma?”, ĩre yigʉmi. “Cien jibʉri pan quẽnorotire vaja moaja yʉ”, ĩre yigʉmi. To bajiro ĩ yirone, “Adi mʉ vaja more ñarijũrore mojoroaca ochenta jibʉri vaja moaja yiucatu vasoatoya”, ĩre yigʉmi. To yicõari, gãjerãre quẽne to bajiro rĩne yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","To bajiro ĩ yiro ajicõari, “Quẽnaro yigʉ me ñaboarine, tʉoĩamasigʉ̃ ñaami”, yitʉoĩagʉ̃mi ĩ ʉjʉ, ĩre —ĩnare yigotiyuju Jesús, ĩ buerimasare. —To bajiro tʉoĩaama ĩna, jãjarã masa, Diore ajiterã. Gajeyeũnire bʉto tʉoĩarã, masare yitocõari, vaja bʉjamasiama ĩna. Yʉre ajitirʉ̃nʉrãjʉama, “Quẽnabʉsaro Dios ĩ bojarore bajiro ajitirʉ̃nʉato ĩna” yirã, quẽnaro mʉa yirotire tʉoĩabetibʉsacõaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","To bajiri ado bajiro mʉare gotiaja yʉ: Rijanane mʉa yere, mʉa gajeyeũnire juavamasibetirʉarãja. To bajiri mʉa cʉosere maioro bajirãre ĩsiña mʉa. To bajiro mʉa yijama, mʉa rijato bero, ĩnare quẽnaro yiriarã mʉa ñajare, Dios ĩ ñarojʉ quẽnaro mʉare ĩavariquẽnarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Gajeyere quẽne mʉare gotiaja yʉ. Gajeyeũni, gãjoa codebosarimasʉ mojoroaca ñasere quẽnaro codegʉma, jairo ñasere quẽne quẽnaro codemasiami. Gãjima, gajeyeũni, gãjoa codebosarimasʉ ñagʉ̃ mojoroaca ñasere codemasibecʉma, jairo ñasere quẽne codemasibecʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Adi macarʉcʉrojʉre Dios mʉare ĩ ĩsise “Dios ĩ cõase ñaja” yitʉoĩacõari, mʉa gãjoare, gajeyeũnire, mʉa cʉosere quẽnaro mʉa cʉomasijama, Dios, bʉto variquẽnacõari, ĩ tʉayere quẽnamasusere mʉare ʉjorʉcʉmi, tʉoĩamasireayere, moamasireayere, to yicõari mʉa ñarotiayere quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Adi macarʉcʉroayere ĩ cõasere mʉa cʉomasibetijama, quẽnamasuse mʉa cʉoborotire ʉjobetirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Diore yirʉ̃cʉbʉorãma, adi macarʉcʉroayere tʉoĩarʉ̃cʉbʉomenama, “Diojʉa ñaami ñamasugʉ̃” yitʉoĩarã ñari —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","To bajiro ĩ yisere ajicõari, ñagõjʉrʉañujarã fariseo masa, gajeyeũnire, to yicõari, gãjoare quẽne, tire bʉto bojarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","To ĩna yijare, ado bajiro ĩnare gotiyuju Jesús: —Quẽnase mʉa yijama, “‘Quẽnarã ñaama’ manire yiĩato masa” yirã, yitorũgũaja mʉa. To bajiro mʉa yiboajaquẽne, mʉa tʉoĩasere ĩamasigʉ̃ ñaami Dios. To bajiri, “Quẽnamasucõaja” masajʉama ĩna yiĩaboasere, Diojʉama, “Quẽnabetimasucõaja” yiĩaami —fariseo masare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Rẽmojʉre Dios yere Moisés ĩ rotimasirere, Diore gotirẽtobosamasiriarã masare ĩna gotimasiorema, Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ ĩ gotimasioriajʉne tʉsaja. “Ʉjʉ Dios yarã quẽnaro ĩ yirã mʉa ñarʉajama, rojose mʉa yisere yitʉjacõari, Jesúre ajitirʉ̃nʉña” yisejʉa ñaja ñamasusema. Tire ajirã ñari, quẽnaro yʉre ajivariquẽnasʉyasʉoadicama jãjarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Adirʉ̃mʉriaye ñamasuse ti ñaboajaquẽne, Moisére Dios ĩ roticũmasire, to yicõari, Diore gotirẽtobosarimasa ĩna gotimasiomasire ñajediro ñacõarũgũrʉaroja. Adi macarʉcʉro jediroto rĩjoro, cojo vãme godocʉtibetirʉaroja. Ñajediro Dios ĩ gotiriarore bajirone bajirʉaroja —ĩnare yigotimasioñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Quẽna ado bajiro ĩnare gotimasioñuju Jesús: —Sĩgʉ̃ ĩ manajore rocacõari, gajeore ĩ manajo cʉtijama, ĩ manajo masu me ñaamo. Sore ajerio cʉtigʉ yami, Dios ĩ ĩajama. To yicõari, manajʉ rocario rãca ĩ manajo cʉtijaquẽne, ĩ manajo masu me ñaamo. Sore ajerio cʉtigʉ yami, Dios ĩ ĩajama —ĩnare yigotimasiñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","To bajiro yigajanocõari, quẽna ado bajiro ĩnare gotiyuju Jesús: —Sĩgʉ̃ ñagʉ̃mi jairo gajeyeũni cʉogʉ. Quẽnase sudi, vaja jacase rĩne sãñarũgũgʉ̃mi. Tocãrãcarʉ̃mʉrine bare quẽnase rĩne ba, boserʉ̃mʉ quẽno, variquẽnarũgũgʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ĩ ya vi soje tʉaca ñie cʉobecʉ, maioro masu bajigʉ rujigʉmi, Lázaro vãme cʉtigʉ. Ĩ rujʉri cãmi boagʉ ñagʉ̃mi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ĩ bareasere barʉa rujigʉmi. To ĩ bajirujirone, ĩ cãmire ĩre verogõjanabiorãma yaia. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","23","Cojorʉ̃mʉ rijacoacʉmi Lázaro. Ĩ rijato bero, õ vecajʉ ĩ ñicʉ Abraham tʉjʉ ĩ ʉsʉre ãmicõanama ángel mesa. Bero, gajeyeũni jaigʉ quẽne bajirocacoacʉmi. Bajirocacõari, yuje ecogʉmi. To bajicõari, rojose tãmʉotʉjabetiriarojʉ cõaecogʉmi. Tojʉ ñacõari, ĩamʉogʉ̃ne, Abraham, Lázaro rãca ĩna ñaro ĩabʉjagʉmi, õ vecajʉ ñarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","25","Ĩnare ĩabʉjacõari, Abrahamre ado bajise avasãĩamʉogʉ̃mi: “Ñicʉ, yʉre ĩamaiña. Adi jeamere bʉto rojose tãmʉoaja yʉ. Lázarore, yʉ tʉjʉ ĩre cõaña. Mojoroaca oco juaádiato”, ĩre yiavasãgʉ̃mi. To ĩ yirone, ado bajiro ĩre cʉdigʉmi Abraham: “Tʉoĩaña jãnami. Mʉ ya macajʉ ñagʉ̃ quẽnasere cʉocajʉ mʉ. Variquẽnacajʉ mʉ. Lázarojʉama tojʉ ñagʉ̃ bʉto rojose tãmʉocami. Yucʉrema, quẽnaro variquẽnaro ñagʉ̃ bajiami yuja. Mʉjʉama bʉto rojose tãmʉogʉ̃ bajiaja mʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gajeyerema jairigoje ñamatacõaja. To bajiri mʉ tʉjʉre ejamasibeaja yʉa. Mʉajʉa quẽne yʉa tʉjʉre ejamasibeaja mʉa”, ĩre yicʉdigʉmi Abraham. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","To bajiro ĩ yijare, gajeyeũni jaigʉ ñaboar'i ado bajiro ĩre yigʉmi: “‘Lázarore yʉ jacʉ ya vijʉ ĩre cõaña’ yigʉ yaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yʉ bederã cojomocãrãcʉ ñarãre, Lázarore ĩre gotiroticõaña. ‘Ĩna quẽne, adojʉ rojose yʉ tãmʉorore bajiro bajiroma’ yigʉ yaja”, Abrahamre yigotiboagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","To ĩ yirone, “Moisés, to yicõari, Diore gotirẽtobosamasiriarã quẽne ĩna ucarere jẽre tire cʉorãma ĩna, mʉ yarã. Tire bueato ĩna”, ĩre yicʉdigʉmi Abraham. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","To ĩ yirone, “Bajibeaja. Buemenama. ‘Rijar'ine tudicaticõari, gotiami manire’ yirã, ĩre ajirʉ̃cʉbʉocõari, tʉoĩavasoarʉarãma ĩna”, ĩre yiboagʉmi, jeamejʉ rojose tãmʉoñagʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","To ĩ yirone, ado bajiro ĩre cʉdigʉmi Abraham quẽna: “Moisés, to yicõari, Diore gotirẽtobosamasiriarã, ĩna ucamasirere mʉ bederã ĩna ajitirʉ̃nʉbetijama, rijar'i, ĩnare ĩ gotiboajaquẽne, ĩre ajimenama”, yigʉmi Abraham —ĩnare yigotiyuju Jesús, fariseo masare. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ĩ buerimasare ado bajiro gotimasioñuju Jesús: —Rojose yirã jãjarã ñarãma. To bajiri gãjerãre rojose ũmato yirʉarãma. To ĩna yise sʉori bʉto rojose tãmʉorʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Rojose ĩnare ĩna ũmato yiroto rĩjoro, tocãrãcʉrene ĩna ãmʉarijʉre gʉ̃ta jairica siatucõari, riaga ʉ̃cʉarojʉ ĩnare rearoderuucõajama, rojose tãmʉobetibʉsaborãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","To bajiri, “Rojose mani ũmato yijama, rojose tãmʉoborãja” yirã, quẽnaro tʉoĩamasirine ñarũgũña mʉa. Sĩgʉ̃ rojose mʉare ĩ yijama, “Rojose yʉre yibʉ mʉ”, ĩre yiya. To bajiro mʉ yisere ajicõari, “Riojo yaja mʉ” ĩ yisʉtiritijama, rojose mʉare ĩ yisere ĩre masirioya mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tocãrãcajine rojose mʉare ĩna yijama, ĩnare masirioya, rojose mʉare ĩna yiro cõrone, “Jʉaji rojose mʉare yibetirʉcʉja” yirãre —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","To bajiro ĩ yisere ajicõari, —“Tocãrãcajine masiriotĩmamenaja” yitʉoĩarã ñari, yʉa masiriotĩmarotire Dios ĩ ejarẽmosere bojaja —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","To bajiro ĩre ĩna yirone, ado bajiro ĩnare gotiyuju Jesús: —Mojoroaca yimasirã ñaboarine, “Dios ĩ ejarẽmose rãca yimasicõarãja” yirã, icʉ morera vãme cʉtiʉre, “Mʉa masune vʉevati, rʉ̃gõaya” mʉa yirotijama, to bajirone bajirʉaroja ti —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","To yigajanocõari, ado bajiro ĩnare gotirũtuasuju ĩ quẽna: —To bajiri, ĩaĩañamani mʉa yijama, ado bajirojʉa tʉoĩama mʉa: Moabosarimasʉ cʉorã ĩre mʉa rotisere tʉoĩaña: Ovejare mʉare codebosagʉar'ire, ĩ tudiejaro, “Mʉjʉa basʉoya”, ĩre yimenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ado bajirojʉa ĩre yirãja mʉa: “Yʉa barotire roabosaya. Roagajanocõari, yʉare ecaba. Yʉa bagajanoro bero, mʉjʉa barʉcʉja mʉ”, ĩre yirãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mʉa moarotisere ĩ moaro ĩacõari, “Quẽnaja ti”, ĩre yimenaja mʉa, “Yʉare moabosarimasʉ ñaami” ĩre yitʉoĩarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","To bajiro ĩre mʉa yitʉoĩarore bajirone tʉoĩagʉ̃mi ĩ quẽne. To bajiri, “‘Quẽnaro yaja mʉa’ manire yato Dios” yitʉoĩacõari, “Ñamasurã ñaja” yirãre bajiro yisocabesa. “No bojagʉre moabosarimasʉ, ĩ moarotiecorore bajiro bajigʉ ñaja”, yitʉoĩarũgũña —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","To bajiri Galilea sita, Samaria sita rãca vatojere varũtuasuju ĩ, Jesús, Jerusalén macajʉ vacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Varũtu vacʉne, gaje maca ejayuju. Ti macajʉre ĩ ejaro, jʉaãmocãrãcʉ rujʉri gase boarã ĩre bocayujarã ĩna. Ĩ tʉaca ejamenane, sõjʉ ñarine ado bajiro ĩre yiavasãñujarã ĩna: ");
INSERT INTO bsnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Jesús yʉa ʉjʉ, yʉare ĩamaiña mʉ —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","To bajiro ĩna yiavasãrone, ĩnare ĩacõari, ado bajiro ĩnare yiyuju Jesús: —Paiare mʉa rujʉrire ĩoaya. To mʉa yijama, caticoarʉarãja mʉa —ĩnare yiyuju ĩ. To bajiro ĩ yijare, vacoasujarã ĩna. Maa ĩna vato rĩne ĩna cãmi boaboare yaticoasuju ti yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","To bajiro sĩgʉ̃ rujʉ gase boagʉ ñar'i, ti yatiro ĩacõari, jʉdarʉ̃gʉ̃, Jesús tʉjʉ tudicoasuju quẽna. Tudiacʉne, variquẽnagʉ̃ ñari, “Quẽnaro yʉre yami Dios”, yiavasã varũtuasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús tʉjʉre tudiejacõari, muqueayuju ĩ. To bajicõari, ado bajiro Jesúre gotiyuju: —Yʉ gase boaboase mʉ sʉorine ti yatijare, bʉto quẽnaja —Jesúre ĩre yigotiyuju. Ĩ ñañuju samaritano masʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","To bajiro ĩ yisere ajicõari, ado bajiro yiyuju Jesús: —Jʉaãmocãrãcʉre gase boariarãre yʉ catioboajaquẽne, ãni samaritano masʉ, ĩ sĩgʉ̃ne tudiadiami, “Quẽnaro yʉre yami Dios” yigʉ vagʉ —ĩ rãcanare ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","To bajiro yigajanocõari, ĩ catior'ire ado bajiro ĩre yiyuju: —Vʉ̃mʉrʉ̃gʉ̃ña. Vasa. “Yʉre ĩamaicõari, catiorʉcʉmi Jesús” mʉ yitʉoĩajare, mʉre catiobʉ yʉ —ĩre yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Cojorʉ̃mʉ ado bajiro Jesúre sẽniĩañujarã fariseo masa: —¿No cõro ejacõari, rotisʉogʉti Dios ĩ cõarocʉ? —ĩre yisẽniĩañujarã ĩna. To bajiro ĩre ĩna yisẽniĩarone ado bajiro ĩnare cʉdiyuju Jesús: —Mʉa yutʉoĩarore bajiro bajibeaja ti. Ruyurone, “Adine ñaja. Ise ñaja” yimasiñamanire bajiro bajise ñaja, Dios ĩ roticõagʉ̃ ĩ ejasema. Jẽre mʉa vatoane ñaboaja ti —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","To bajiro yicʉdigajanocõari, ĩ buerãre ado bajiro ĩnare gotiyuju Jesús: —Yoaro yʉ rãca ñarʉaboarãja mʉa. To bajiro mʉa bajiboajaquẽne, mʉa rãca ñacõa ñabetirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","To bajiri yʉ tudivadiroto rĩjorore, “Ĩne ñaami. Tudiejami. Tone ñami”, mʉare yisocarʉarãma. To bajiro ĩna yijama, ĩnare ajibetirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ʉ̃mʉagasero jedirojʉ bʉjo ĩ yabesere masa ĩna ĩarore bajiro yʉ vadore yʉre ĩare ñarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","To bajiro yʉ bajiroti rĩjorore, adirodoana jairo rojose yʉre ĩna yisere rojose tãmʉoroti ñaja ti. “Dios ĩ cõagʉ̃ me ñaami” yica yirã, yʉre sĩarotirʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yʉre ĩna sĩaro bero, tudicaticõari, quẽna vadirʉcʉja yʉ, adi macarʉcʉrojʉre. Noé ñamasir'i ĩ ñariarodo masa ĩna bajiñamasiriarore bajiro bajiñarʉarãma, Dios ĩ roticõacacʉ, yʉ tudiejarirʉ̃mʉre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Adi macarʉcʉro ti rujaroto rĩjoro bare ba, idi, manajo cʉti, yicõa ñamasiñujarã ĩna. Diore tʉoĩari mene, “¿To bajiroado yatique?” yimenane, jairica cũmua quẽnogajanocõari, Noé ĩ vasãjaro ũnone to bajiro yicõa ñamasiñujarã ĩna. “To bajiroado yiroja” ĩna yimasibetone, ĩnare ruureacõañuju Dios. To bajirone bajirʉarãma masa, yʉ tudiejarirʉ̃mʉre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","To bajirone bajiñamasiñujarã masa, Lot ñamasir'i ĩ ñariarodoana quẽne. Sodoma macana bare barã, idirã, gajeyeũni gãmerã ĩsirã, gãjerã vaja yicõari cʉorã, gãjerãma, oterã, viri bʉarã, yicõa ñamasiñujarã ĩna, Diore tʉoĩamenane. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodomajʉre ñaboar'i Lot ĩ rudiro bero, õ vecaye jea ʉ̃jʉse azufre vãme cʉtise rãca Dios ĩ soereamasiriarore bajiro bajirone bajirʉaroja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","To bajirone bajiñarʉarãma masa, Dios ĩ roticõacacʉ yʉ tudiejarirʉ̃mʉre quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","To bajiri, quẽnaro ñaña mʉa, rojosere yimenane. Yʉ gotisere quẽnaro tʉoĩamʉjarʉ̃gʉ̃ña, “No bojarijaʉne vagʉmi” yitʉoĩarã ñari. No yimasiña manirʉaroja. Sĩgʉ̃ ĩ ya vi joejʉ jesagʉma, rujiacõari, ĩ ya vi jubeajʉ gajeyeũni ñasere juaátĩmabetirʉcʉmi. Gãji, vesejʉ moañagʉ̃, ĩ ye sudire juagʉ tudiatĩmabetirʉcʉmi, rujarĩmarone yʉ ejaroti ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot manajo so bajimasirere tʉoĩaña mʉa. Gajeyeũnire ũmaveovaco ñari, tire maigõ, ĩatʉoca yigone, moatutune godovedirocacoasuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","No bojarã, no ĩna bojarone ñare cʉtirãma adi macarʉcʉro ñasere ĩavariquẽnacõari, Diore tʉoĩamenama, Dios ĩ catisere yayibetire cʉomena ñarʉarãma ĩna. To bajiboarine, yʉre ajitirʉ̃nʉrã, yʉ oca ĩna gotisere ajijũnisinicõari, ĩna sĩarãma, Dios tʉjʉ quẽnaro ñarona ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gajeyerema adi macarʉcʉrojʉ yʉ tudivadojʉ, ñami ti ñajama jʉarã ʉ̃mʉa cãniñarãre ejacõari, sĩgʉ̃ ãmiecorʉcʉmi. Gãjima, ãmiecobetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ʉ̃mʉa ti ñajama, rõmia jʉarã trigore vãiaabo ñarʉarãma. To bajiri, sĩgõ ãmiecorʉocomo. Gajeoma, ãmiecobetirʉocomo. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jʉarã ʉ̃mʉa vesejʉ moañarʉarãma. To ĩna yiñarone, sĩgʉ̃ ãmiecorʉcʉmi. Gãjima, ãmiecobetirʉcʉmi —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","To bajiro ĩnare ĩ yigotirone, —¿Nojʉre to bajise bajiroti ti? —ĩre yisẽniĩañujarã ĩ buerimasa. To bajiro ĩre ĩna yisẽniĩarone, ado bajiro cʉdiyuju Jesús: —Rijar'i, ĩ boacũñarorema, yuca ejarãma ĩna —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","“Diore ĩre sẽnitʉjabeticõato ĩna” yigʉ ĩnare gotimasioñuju ĩ: ");
INSERT INTO bsnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Cojo macare sĩgʉ̃ masʉ ñagʉ̃mi masa ĩna yisere ĩacõĩarimasʉ. Diore, to yicõari, masare quẽne rʉ̃cʉbʉobecʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ĩ ya macajʉre sĩgõ ñagõmo manajʉ rijaveorio. Biyaroaca ado bajiro ĩre sẽnigõ ejaboagomo: “Yʉre ejarẽmoña mʉ. Rojose yʉre yami”, ĩre yiboagomo. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","To bajiro so yiboajaquẽne, sore yibosadabecʉmi. To bajiboarine, bʉto ĩre so sẽnicõa ñajare, ado bajiro tʉoĩagʉ̃mi yuja: “Diore, to yicõari, masare quẽne rʉ̃cʉbʉobecʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","To bajiro bajigʉ ñaboarine, bʉto so sẽnigõjanabiocõa ñajare, sore ejarẽmorʉcʉja yʉ. Sore yʉ ejarẽmobetijama, yʉre gõjanabiocõa ñabogomo”, yitʉoĩagʉ̃mi —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti quetire gotigajanocõari, “Ado bajiro yirʉaro yaja”, ĩnare yiyuju: —Masa ĩna yisere ĩacõĩarimasʉ ĩ yirere ajiĩasaque mʉa: ");
INSERT INTO bsnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","¿Dios, ĩ ejarẽmosere bojarã ĩre sẽnitʉjamenare, ĩ yarãre, yoaro ĩnare ejarẽmobecʉtique ĩ? To bajiro yibecʉmi Diojʉama. Mʉa sẽniro cõrone tocãrãcajine mʉare cʉdimasiami. To bajiri, ¿“Yʉare ejarẽmogʉ̃mi Dios” yitʉoĩacõari, ĩre sẽnitʉjamenare, tudivagʉ, bʉjarʉcʉada yʉ? —yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Quẽna gaje queti ĩnare gotimasioñuju. Ĩre ajirã sĩgʉ̃ri ado bajise yitʉoĩañujarã ĩna: “Quẽnaro yirã ñaja yʉama”, yitʉoĩañujarã ĩna. To bajiro yicõari, “Rojorã ñaama ĩnama”, gãjerãre yiĩarã ñañujarã ĩna. To bajiro yirã ĩna ñajare, ado bajise queti ĩnare gotiyuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ʉ̃mʉa jʉarã ñarãma ĩna, Diore yirʉ̃cʉbʉoriavijʉ ĩre sẽnirã vana. Sĩgʉ̃ fariseo masʉ ñagʉ̃mi. Gãji, ʉjʉre gãjoa sẽnibosarimasʉ ñagʉ̃mi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo masʉ, Diore yirʉ̃cʉbʉoriavijʉre sãjaejarʉ̃gʉ̃cõari, ado bajiro Diore ĩre yigʉmi, ĩ tʉoĩase rãca: “Dios, mʉre variquẽnaja yʉ, gãjerãre bajiro bajibetir'i. Gãjerãma, juarudirã ña, yitorã ña, gãjerã manajoare ajeriarã cʉtirã ñarãma ĩna. Ado ejagʉ, ʉjʉre gãjoa sẽnibosarimasʉ, ĩre bajiro bajigʉ me ñaja yʉ. To bajiri mʉre variquẽnaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tocãrãca semana jʉaji bare babeaja yʉ, mʉ rotimasirere cʉdigʉ ñari. Yʉ moase vaja jʉaãmocõro ñaritiiri vaja tagʉ, cojotii mʉ ya vire cũbosarũgũaja yʉ”, Diore ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gãjijʉa gãjoa sẽnibosarimasʉ õjʉne tujacõari, õ vecajʉre ĩamʉobecʉmi, ĩ rojosere bojone, sʉtiritimasucõagʉ̃ ñari, ĩ cotitẽrore jagʉne, ado bajise Diore sẽnigʉ̃mi: “Dios, yʉre ĩamaiña mʉ. Rojose yʉ yisere yʉre masirioya mʉ”, Diore yisẽnigʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yʉre quẽnaro ajiya mʉa: Rojose ĩ yisere sʉtiriticõari, Diore sẽnigʉ̃ma, rojose ĩ yisere masirio ecocõari, ĩ ya vijʉ tudiacʉmi. Gãjijʉama, fariseo masʉ, ĩ ya vijʉ tudiajama, “Rojogʉ ñaami”, Dios ĩ yiĩagʉ̃ ñagʉ̃mi. To bajiro ti bajijare, ado bajiro mʉare gotiaja yʉ: “Quẽnaro yirã mani ñajare, ‘Quẽnarã ñaja mʉa’ manire yiĩagʉ̃mi Dios” yitʉoĩarãre, “Quẽnarã me ñaama. Rojorã ñaama”, yiĩagʉ̃mi Dios. No bojagʉre, “Quẽnagʉ̃ me ñaja yʉ” Diore yisʉtiritigʉjʉare, “Quẽnagʉ̃ ñaami”, ĩre yiĩarʉcʉmi Dios —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesús tʉjʉ rĩamasacare juaejayujarã masa, “Ĩ ãmori ñujeocõari, Diore ĩnare sẽnibosato ĩ” yirã. Ĩna juaejasere ĩacõari, ado bajiro ĩnare yiyujarã ĩ buerimasa: —¡Juadibesa! Gõjanabioro yaja mʉa —ĩnare yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","To bajiro ĩnare ĩna yiboajaquẽne, rĩamasare jirẽocõari, ado bajiro ĩ buerimasajʉare yiyuju Jesús: —Rĩamasare, “Juadibesa” ĩnare yibesa. “Quẽnaro yʉare yirʉcʉmi Dios” yitʉoĩarã ñaama rĩamasa. Ĩna tʉoĩarore bajiro tʉoĩarã ñaama Ʉjʉ Dios yarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Riojo mʉare gotiaja yʉ. Rĩamasa ĩna yiecorore bajiro yiecorã ñarãma Ʉjʉ Dios yarã —ĩ buerimasare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sĩgʉ̃ ʉjʉ, ado bajiro Jesúre ĩre sẽniĩañuju: —Gotimasiorimasʉ, quẽnagʉ̃ ñaja mʉ. Yʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere yʉre ĩ ĩsisere yʉ bojajama, ¿no bajiro yiroti ñati yʉre? —Jesúre ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju: —¿No yigʉ, “Quẽnagʉ̃ ñaja mʉ”, yʉre yati mʉ? Dios sĩgʉ̃ne ñaami quẽnagʉ̃ma. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉ bʉjarʉajama, Dios ĩ rotimasirere cʉdiroti ñaja. Tire masiaja mʉ. Dios ĩ rotimasire yʉ yijama, ado bajise yimasirere yaja yʉ: “Gãji manajo rãca ajerio cʉtibesa. Sĩabesa. Juarudibesa. Socʉne, ‘Rojose yimi’ yigotirobesa. Mʉ jacʉre, mʉ jacore quẽne quẽnaro ĩnare rʉ̃cʉbʉoya”, yigotiaja Dios ĩ rotimasire —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","To ĩ yisere ajicõari, ado bajiro yicʉdiyuju: —Daquegʉjʉne tire cʉdisʉoadicajʉ yʉ —ĩre yicʉdiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","To ĩ yisere ajicõari, ado bajiro ĩre gotiyuju Jesús: —Cojo vãme rʉyaja mʉ yiroti, mʉ rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere mʉ bʉjarʉajama: Jediro mʉ cʉosere gãjerãre ĩsijeocõaña. To yicõari, ti vaja bʉjacõari, maioro bajirãre ĩsima. To bajiro mʉ yijama, õ vecajʉ Dios ĩ ñarojʉ quẽnase bʉjarʉcʉja mʉ. To bajiro yigajanocõari, yʉre ajisʉyaya —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","To ĩ yigʉ bʉto sʉtiriti vacoasuju ĩ, gajeyeũni jaigʉ ñari, tire maigʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ĩ sʉtiritisere ĩacõari, ado bajiro ĩ buerimasajʉare gotiyuju Jesús: —Gajeyeũni jairãrema, yʉre ĩna sʉyarʉa tʉoĩaboajama, bʉto josarʉaroja ĩnare. To bajicõari, yirẽto ecobosabetirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Vaibʉcʉ camello vãme cʉtigʉ, gãjojota gojeacare sãjarẽtobudimasibecʉmi. To bajirone bajiaja gajeyeũni jairãre quẽne, yʉre ĩna ajitirʉ̃nʉ sʉyarʉaboajama. To bajiro ĩna bajijare, yirẽto ecobosabetirʉarãma —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","To bajiro ĩnare ĩ yisere ajicõari, no yimasibesujarã ĩna. To bajiri ado bajiro ĩre sẽniĩañujarã: —Riojo mʉ gotijama, ¿no bajiro bajirãjʉa Dios tʉjʉre ejarʉarãda? —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Ĩna masune ejamasimenama masa, Dios tʉjʉre. Diojʉama, ñajediro yimasijeocõami. Ñiejʉa josase maja ĩrema. Ĩ sʉorine ĩ tʉjʉ ejamasire ñaja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","To ĩ yisere ajicõari, ado bajiro ĩre yiyuju Pedro: —Yʉ ʉjʉ, jediro yʉa gajeyeũnire cũcõari, mʉre sʉyacajʉ yʉa —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Riojo mʉare gotiaja yʉ. No bojarã yʉre ajitirʉ̃nʉrã ñari, yʉ ye gotiroana, ĩna ya vi, ĩna yarã, ĩna manajoa, ĩna jacʉa, ĩna rĩa, to yicõari ĩna ya veserire quẽne ĩna vaveojama, ĩna cʉoboare rẽtobʉsaro quẽnase bʉjarʉarãma ĩna, adi macarʉcʉrore. To yicõari, ĩna rijato berojʉma “Tudirijabeticõato” yigʉ, ĩ catisere ĩnare ĩsirʉcʉmi Dios —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jerusalénjʉ ĩnare ũmato varũtu vacʉne, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre ĩnare gotirʉ, ricati ĩnare jicãmotoyuju Jesús. To bajiro yicõari, ado bajiro ĩnare yiyuju: —Quẽnaro ajiya mʉa. Jerusalénjʉ vana bajiaja mani. Dios ĩ roticõacacʉ, yʉ bajirotire jairo ucayuma tirʉ̃mʉana Diore gotirẽtobosamasiriarã. Ñajediro ĩna ucarere bajirone bajijeocõarʉaroja yʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Romano masare yʉre ĩsirʉarãma. To ĩna yijare, yʉre ajatud'irã, gooco yʉre eoreatucõari, bajerʉarãma ĩna. To yicõari, yucʉ́tẽrojʉ yʉre jajurocacõarʉarãma. Yʉre jajurocacõari, yujeboarʉarãma. To ĩna yiboajaquẽne, yʉre ĩna sĩarirʉ̃mʉ bero, idiarʉ̃mʉ tʉsatirʉ̃mʉne tudicaticoarʉcʉja yʉ quẽna —ĩnare yiboayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","To bajiro ĩnare ĩ yisere ajimasibesujarã ĩna, ĩna ajimasirotire Dios ĩ cõabetijare. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó vãme cʉti macajʉ ĩ cõñatone, caje ĩabecʉ rujiyuju, maa tʉ. Maioro bajigʉ ĩ barotire, to yicõari, gajeyeũniaca ĩ cʉorotire tʉoĩagʉ̃, gãjoa sẽnigʉ̃ bajiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Masa jãjarã ĩna rẽtosere ajicõari, —¿No bajiro bajiati ti? —ĩnare yisẽniĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","To bajiro ĩnare ĩ yisẽniĩarone, —Jesús Nazaret macagʉ, rẽtoacʉ yami —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","To bajiro ĩna yisere ajicõari, ado bajiro Jesúre jiavasãñuju ĩ: —Jesús, yʉa ʉjʉ, Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉre ĩamaiña mʉ —yiavasãñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","To bajiro ĩ yiavasãrone, —¡Avasãbesa! —ĩre yiyujarã ĩna, Jesúre ĩre rĩjoro cʉti vana. To bajiro ĩna yiboajaquẽne, bʉtobʉsa avasãñuju quẽna: —Ʉjʉ David ñamasir'i jãnami, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaja mʉ. Yʉre ĩamaiña —Jesúre ĩre yiavasãñuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","To ĩ yisere ajicõari, tujarʉ̃gʉ̃ñuju Jesús. To bajicõari, —Ĩre jiya mʉa —masare ĩnare yiyuju. To bajiro ĩ yijare, Jesús tʉjʉ ĩre jiejoyujarã ĩna. To ĩna jiejoro ĩacõari, —¿No bajiro mʉre yʉ yisere bojati mʉ? —ĩre yiyuju Jesús, caje ĩabecʉre. To ĩ yijare, ado bajiro ĩre yicʉdiyuju: —Yʉ ʉjʉ, tudiĩarʉaja yʉ —ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","To bajiro ĩ yisere ajicõari, ado bajiro yiyuju Jesús: —“Yʉre ĩamaicõari, ĩarotirʉcʉmi” yʉre yitʉoĩagʉ̃ ñari, ĩacoajʉ mʉ. Ñie rojose maja mʉre yuja —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","To bajiro ĩ yirirĩmarone, caje ĩabecʉ ñaboar'i, ĩacoasuju ĩ yuja. Ĩacõari, ĩ quẽne Jesúre sʉyacoasuju. “Quẽnaro yaja mʉ”, Diore ĩre yivariquẽna vasuju ĩ. Masa quẽne tire ĩarã, “Quẽnaro ĩre yami Dios”, yiyujarã ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","To bajiri, Jericó vãme cʉti macare rẽtoacʉ bajiboayuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","To ĩ bajivatore, sĩgʉ̃ ti macagʉ ñañuju, Zaqueo vãme cʉtigʉ. Ĩ ñañuju gãjoa sẽnibosarimasa ʉjʉ. Gajeyeũni jaigʉ ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","To bajiri, Jesús ĩ rẽtoato bʉto ĩarʉaboayuju. Ĩre ĩarã jãjarã ĩna ñajare, ĩre ĩabʉjabesuju ĩ, yegʉaca ñari. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","To bajiri, Jesús ĩ varoti maa tʉjʉ ĩ rĩjoro ũma va, yucʉ́jʉ mʉjasuju, Jesúre ĩre ĩarʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ĩ jesaro ẽñeroca ejayuju Jesús. To bajicõari, ĩre ĩamʉoñuju, Zaqueore. Ĩre ĩamʉogʉ̃ne, —Zaqueo, guaro rujiaya mʉ. Yucʉ mʉ ya vijʉ tujarʉcʉja yʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","To bajiro ĩre ĩ yirone, guaro rujiacõari, variquẽnagʉ̃ne, Jesúre ĩre ũmato vasuju Zaqueo, ĩ ya vijʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","To bajiri Zaqueo ya vijʉ Jesús ĩ ñasere ĩacõari, ado bajiro gãmerã yiyujarã masa: —Rojogʉ tʉre ñagʉ̃ bajiami —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ĩ ya vijʉ ñacõari, ado bajiro Jesúre gotiyuju Zaqueo: —Yʉ cʉose, gajeyeũnire, maioro bajirãre gʉdareco ĩnare ĩsirʉcʉja yʉ. Gãjerãre ĩnare yitocõari, ĩna ye ñaboasere ẽmacajʉ yʉ. To bajiri ĩnare yʉ ẽmacati rẽtoro ĩnare ĩsirʉcʉja yʉ. Babarirãcaji ĩnare yʉ ẽmacati rẽtobʉsaro ĩnare ĩsirʉcʉja —Jesúre ĩre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","To bajiro ĩre ĩ yisere ajicõari, ado bajiro ĩre gotiyuju Jesús: —Quẽnaro yaja mʉ. Abraham Diore ĩ ajitirʉ̃nʉmasiriarore bajiro Diore ajitirʉ̃nʉaja mʉ. To bajiro yigʉ mʉ ñajare, mʉre, to yicõari, mʉ ya vianare quẽne, rojose mʉa yisere mʉare masiriocõaja yʉ. To yicõari, rojose mʉa tãmʉoborotire mʉare yirẽtobosarʉcʉja yʉ. Yayirãre bajiro bajirãre, rojose tãmʉoboronare, ĩnare yirẽtobosagʉ vadicajʉ yʉ, Dios ĩ roticõacacʉ —ĩre yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","To bajiro ĩre ĩ yigotisere ajicõari, ado bajiro tʉoĩaboayujarã masa: “Jerusalénjʉ ĩ ejaroti mojoroaca ti rʉyajare, yucʉacane Israel vãme cʉti sitare manire rotisʉorʉcʉmi Jesús, Dios ĩ roticõar'i, romano masare bucõari”, yitʉoĩaboayujarã ĩna. To bajiro ĩna yitʉoĩasere ĩamasicõari, gotimasiore quetire ado bajiro ĩnare gotiyuju Jesús: ");
INSERT INTO bsnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","—Sĩgʉ̃ ñagʉ̃mi gaje sitajʉ varocʉ, ʉjʉ ñamasugʉ̃ ĩ ñarojʉ, ʉjʉ ĩ ñarotire sẽnigʉ̃, “Yʉ ya macanare rotigʉsa” yigʉ. Ĩ varoto rĩjoro, ĩre moabosarimasare jʉaãmocãrãcʉre jirẽogʉ̃mi. Ĩnare jirẽocõari, ĩ ye gãjoare ĩnare bategʉmi. “Yʉ manitoyejʉ adi gãjoa rãca vaja yicõari, mʉa vaja yisere gãjerãre ĩsirã, jaibʉsaro vaja sẽnima, ‘Jaibʉsaro gãjoa bʉjarãsa’ yirã”. To yigajano, vacoacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","To bajiro ĩ bajiboajaquẽne, ĩ ya macana ʉjʉ ĩ ñasere bojamenama ĩna. “Yʉa ʉjʉ ĩ ñasere bojabeaja” yirã, ĩna rãcanare gotiroticõarãma, ʉjʉ ñamasugʉ̃re. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","To bajiro ĩnare ĩna yicõaboajaquẽne, ĩna ʉjʉ ĩre cũgʉ̃mi ʉjʉ ñamasugʉ̃. To bajiro ĩ yir'i ñari, ĩ ya macanare ĩnare rotigʉ tudiejagʉmi. Tudiejacõari, ĩ gãjoa ĩsiriarãre ĩnare jicõagʉ̃mi, “Tire quẽnaro yimasiboayujari ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ĩ moarimasʉ ejasʉogʉ, ado bajiro ĩre yigʉmi: “Gãjoa yʉre mʉ ĩsicati rãca mʉre bʉjarẽmobosabʉ yʉ, jʉaãmocãrãcaji yʉre mʉ ĩsicati rẽtobʉsaro”, ĩre yigʉmi, ĩ ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","To bajiro ĩ yijare, “Yʉre quẽnaro moabosayuja mʉ. Yʉ yicatore bajiro yʉre cʉdiyuja mʉ. Mojoroaca mʉre yʉ ĩsicati rãca yʉ yicatore bajiro yigʉ mʉ ñajare, ñamasuse moare mʉre moarotiaja yʉ. Jʉaãmocãrãca macarianare rotirʉcʉja mʉ”, ĩre yigʉmi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ĩ bero gãji ejagʉmi: “Gãjoa yʉre mʉ ĩsicati rãca mʉre bʉjarẽmobosabʉ yʉ, cojomocãrãcaji yʉre mʉ ĩsicati rẽtobʉsaro”, ĩre yigʉmi, ĩ ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","To bajiro ĩ yijare, “Cojomocãrãca macarianare rotirʉcʉja mʉma”, ĩre yigʉmi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Ĩ bero, ĩ ʉjʉre ĩogʉ̃ ejagʉmi gãji: “Adine ñaja mʉ gãjoa, yʉre mʉ ĩsicati. Sudigaserone gũmacõari, cũcajʉ yʉ, ‘Bʉto roticõari ĩ bojarore bajiro yirere bojagʉ ñacami’ mʉre yigüigʉ ñari”, ĩre yigʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","To bajiro ĩ yijare, ado bajiro ĩre cʉdigʉmi ĩ ʉjʉ: “To bajiro yʉre yitʉoĩagʉ̃ ñaboarine, yʉre quẽnaro moabosabetir'i mʉ ñajare, rojose mʉre yirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Gãjoa mʉre yʉ ĩsicati rãca vaja yicõari, mʉ vaja yisere gãjerãre ĩsicõari, jaibʉsaro vaja sẽnibetiboarine, gãjoa cũriavijʉa mʉ cũjama, jaibʉsaro yʉre bʉjarẽmobosaboriaja mʉ”, ĩre yitud'igʉmi ĩ ʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","25","To bajiro yigotigajano, ĩ tʉ rʉ̃gõrãre ĩacõari, ado bajiro ĩnare rotigʉmi: “Ãnire gãjoa yʉ ĩsiboacatire ẽmaña. Tire ẽmacõari, jʉaãmocãrãcaji ĩre yʉ ĩsicati rẽtobʉsaro bʉjarẽmocõari cʉogʉjʉare ĩre ĩsiña”, ĩnare yigʉmi ĩna ʉjʉ. To bajiro ĩ yirotiboajaquẽne, “Jẽre jairo cʉoami ĩma”, ĩre yicõarãma, ĩna ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","To bajiro ĩre ĩna yisere ajicõari, ado bajiro gotigʉmi ĩna ʉjʉ: “No bojagʉ ĩre yʉ ĩsise rãca yʉ bojarore bajiro yigʉ, quẽnase bʉjarʉcʉmi. No bojagʉ ĩre yʉ ĩsise rãca yʉ bojarore bajiro yibecʉrema, ĩre yʉ ĩsiboacatire ĩre ẽmarʉcʉja yʉ, ‘Yʉ bojarore bajiro yimasibeami’ yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ʉjʉ yʉ ñasere bojamenarema, yʉ rĩjorojʉa jiejocõari, ĩnare sĩareacõaña mʉa”, yigʉmi ĩna ʉjʉ —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","To bajiro yigotigajanocõari, varũtu vasuju Jesús, Jerusalén ñaejari maajʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Varũtuacõari, ejayuju, Betfagé, Betania vãme cʉti macari tʉjʉre. Ti macari tʉjʉre, Olivo vãme cʉti buro ñañuju ti. Ti burojʉ ejagʉagʉne, jʉarã ĩ buerãre ado bajiro ĩnare gotiyuju ĩ: —Mani varoto riojo ñarimacare vasa maji. Tojʉ ejacõari, burro macʉ ĩna siaturʉ̃gõr'ire bʉjarʉarãja mʉa, jesaĩañamagʉ̃re. Ĩre õjacõari, yʉre ãmiadibosaba. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ti macagʉ sĩgʉ̃, mʉa õjaro ĩacõari, “¿No yirã ĩre õjati?” mʉare ĩ yisẽniĩajama, “Mani ʉjʉ ĩre bojami”, ĩre yicʉdiba —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","To ĩ yisere ajicõari, vasujarã ĩna. To ejacõari, Jesús ĩ gotiriarore bajirone burro macʉre ĩabʉjayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ĩre ĩna õjarone, —¿No yirã ĩre õjati mʉa? —yiyujarã ĩna, burro ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","To bajiro ĩna yirone, —Mani ʉjʉ bojaami —ĩnare yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","To bajiro ĩnare yigajanocõari, burro macʉre ãmivasujarã, Jesús tʉjʉ. To yicõari, ĩna ye sudi joeayere vejecõari, burro macʉ joere jeoyujarã. To yigajanocõari, Jesúre ĩre vajejarotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","To bajiri burro joere jesamaja vasuju Jesús, Olivo vãme cʉti buro majacʉ. To ĩ jesamaja vatone, ĩna ye sudi joeayere vejecõari, ĩ varotijʉre cũ rĩjoro cʉtiyujarã. “Yʉa ʉjʉ ñaja mʉ” yirã, to bajiro yiyujarã, Jesúre rʉ̃cʉbʉorã. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","To bajiro ĩna yi vati maajʉre jesamaja, joe jeacõari, Jerusalénjʉ ĩ rojaroto rĩjorore, “Quẽnaro yaja”, Diore yiavasã variquẽnañujarã ĩna, jãjarã. Dios ĩ masise rãca ĩaĩañamani Jesús ĩ yiĩorere tʉoĩacõari, ado bajiro yiavasã variquẽnañujarã: ");
INSERT INTO bsnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i, ñaami. ¡Diore rotibosagʉ quẽnaro ĩ yigʉ ñaami! Manire ĩavariquẽnagʉ̃mi Dios. Quẽnagʉ̃ masune ñaami —yiavasã variquẽnañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","To bajiro ĩna yiavasã ñarone, sĩgʉ̃ri ñañujarã fariseo masa quẽne. To bajiri Jesúre rʉ̃cʉbʉorã ĩna yiavasãsere ajicõari, ado bajiro Jesúre yiboayujarã ĩna: —Mʉ buerãre avasãrotibeticõaña mʉ —ĩre yiboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","To bajiro ĩre ĩna yiboajaquẽne, ado bajiro ĩnare cʉdiyuju Jesús: —To bajiro ĩna yiavasãbetijama, adiari gʉ̃tarijʉare avasãroticõarʉcʉmi Dios —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","To yi va, Jerusalén maca tʉaca ejagʉne, ti macare ĩagʉ̃ne, otiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ado bajiro yiotiyuju: —Yucʉne Jerusalén macana, variquẽnarere ĩnare Dios ĩ cõarʉaboasere, ĩna masune ajitirʉ̃nʉ sʉyamasibeama. To bajiri quẽnaro ñavariquẽnamasibetirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Masa rojose ĩna tãmʉosere yʉ sʉorine Dios ĩnare ĩ yirẽtobosasere masimena ñari, bʉto rojose tãmʉorʉarãma ĩna. Ĩnare quẽarʉarã vadirʉarãma gãjerã. Adi macajʉre vadicõari, ĩnare gãnibiaquearʉarãma, “Rudiroma” yirã. Gãnibiaqueacõari, quẽnaro sĩajeocõarʉarãma, ĩnare. Virire quẽne, gajeyeũnire quẽne jediro reajeocõarʉarãma ĩna. To bajiro ĩna yireacõaro bero, adi maca ñaboariaro, rujatũcuro ñarʉaroja ti —yiotiyuju Jesús, Jerusalén macare ĩagʉ̃ne. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","To bajiro yigajano, varũtu vaejacoasuju ĩ, Jerusalénjʉ. To ejacõari, Diore yirʉ̃cʉbʉoriavijʉ sãjañuju ĩ. Sãjaejacõari, ti vijʉ ĩsiñarãre ãgõbucõañuju ĩ. Ĩnare ãgõbucõagʉ̃ne, ado bajiro ĩnare gotiyuju: —Dios ĩ rotimasire masa ĩna ucamasire ado bajiro gotiaja: “Yʉ ya vima, yʉre sẽnirʉ̃cʉbʉorã rẽjariavi ñarʉaroja”, yigotiaja, adi vire. To bajiro ĩ yimasire ti ñaboajaquẽne, mʉa sʉorine juarudirimasa ñarivire bajiro bajiaja ti —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","To bajiro ĩnare ĩ yiãgõburiaro bero, tocãrãcarʉ̃mʉri ti vine masare buerũgũñuju Jesús. To ĩ yisere, paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne, masa ʉjarã quẽne, “¿No bajiro ĩre sĩarãti mani?”, yitʉoĩarũgũñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","No bajiro yimasibesujarã ĩna, bajirãjʉma, masa ñajediro bʉto ĩre ĩna ajitirʉ̃nʉ sʉyajare. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cojorʉ̃mʉ, Diore yirʉ̃cʉbʉoriavijʉ masare gotimasioñuju Jesús. “Rojose mʉa yisere yitʉjacõari, quẽnasejʉare tʉoĩavasoaya” ĩnare yigoticõari, ĩ sʉorine quẽnaro ĩnare Dios ĩ yirotire gotimasioñuju ĩ. To bajiro ĩ yigotimasio ñarone, ĩre sẽniĩarã, ĩ tʉre ejayujarã bʉcʉrã, paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ado bajiro ĩre yisẽniĩañujarã ĩna: —¿Ñimʉ mʉre ĩ rotise rãca to bajiro yirũgũati mʉ? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","To bajiro ĩna yisere ajicõari, —Yʉ quẽne, ado bajiro mʉare sẽniĩaja yʉ: ");
INSERT INTO bsnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ñimʉ rotiyujari, Juanre, “Oco rãca masare ĩnare bautizacudiya” yigʉ? ¿Dios rotiyujari? ¿Masajʉa rotiyujarique? —ĩnare yisẽniĩañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","To ĩ yisere ajicõari, ĩna masune gãmerã ñagõñujarã ĩna: —“Dione, Juanre oco rãca masare bautizarotiyumi” mani yijama, ado bajiro manire sẽniĩajacagʉmi: “Tire masirã ñaboarine, ¿no yirã ĩre ajitirʉ̃nʉbeticati mʉa?” manire yisẽniĩajacagʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","To yicõari, “Masane, Juanre oco rãca bautizarotiriarãma” mani yijama, gʉ̃tarine manire reasĩarʉarãma masa, “Diore gotirẽtobosarimasʉ ñaboacami Juan” yirã ñari —gãmerã yiñagõñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","To bajiro yirã ñari, ado bajiro ĩre cʉdiyujarã ĩna: —Juanre rotir'ire masibeaja yʉa —Jesúre yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","To ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —To bajiro mʉa cʉdijare, yʉre rotigʉ vãmere gotibetirʉcʉja yʉ quẽne —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","To bajiro ĩnare yigajanocõari, gotimasiore queti ado bajiro ĩnare gotiyuju Jesús: —Sĩgʉ̃ masʉ ʉye vese otegʉmi. Tire otegajanocõari, gãjerãre, “Yʉre ĩatirʉ̃nʉbosaba”, yigʉmi. “Ʉye ti rica cʉtiro, gãjerãre ĩsicõari, vaja sẽnirʉarãja. To yicõari, mʉa juarotire, ‘Ado cõro ñaja mani ye. Ado cõro ñaja ĩ ye’ yicõĩama”, ĩnare yirotigʉmi. To yicõari, gajerojʉ vacoacʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","To bajiri cojorʉ̃mʉ, “Ʉye rica cʉti bʉcʉacoatoja” yigʉ, ĩre moabosarimasʉre cõagʉ̃mi, “Ʉye, yʉre ĩna cũbosarere yʉre juabosaaya” yigʉ. Ʉye vesejʉ ĩ ejarone, ĩre ñiacõari jarãma vese coderimasa. To yicõa, ĩre ʉye ĩsimenane, “Vasa”, yirãma ĩna. To bajiri ʉye juabecʉne tudiejagʉmi, ĩre roticõar'i tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","To bajiri ʉye ĩ juabetire ĩacõari, gãjire cõagʉ̃mi quẽna, vese ʉjʉ, “Ʉye yʉre juabosagʉ vasa” yigʉ. Ʉye vesejʉ ĩ ejasere ĩacõari, rujajine ĩre yitud'icõari, ĩre quẽne jarãma ĩna. To bajiro ĩre yigajanocõari, ʉye ĩsimenane, “Vasa”, ĩre yirãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","To bajiri ʉye ĩ juabetire ĩacõari, quẽna gãjire cõagʉ̃mi vese ʉjʉ. Ʉye vesejʉ ĩ ejasere ĩacõari, ĩre quẽne jarãma ĩna. To bajiri cãmi cʉtigʉmi. To yicõari, ĩre ñiacõari, vese sojʉajʉ rocarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","To bajiro ti bajijare, “¿No bajiro yigʉti yʉ?”, yitʉoĩagʉ̃mi ʉjʉ. “Yʉ maigʉ̃re, yʉ macʉre ĩre cõarʉcʉja yʉ. Ĩjʉare rʉ̃cʉbʉorãma ĩna”, yitʉoĩagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","To bajiro yitʉoĩacõari, ĩ macʉre cõagʉ̃mi. To bajiro ĩ yitʉoĩaboajaquẽne, ĩ macʉ vesejʉ ĩ ejasere ĩacõari, ado bajiro gãmerã ñagõrãma vese coderimasa: “Adi sita ʉjʉ ĩ bajirocaveojama, ĩ macʉne ñaami vasoarocʉ. To bajiri ĩre mani sĩajama, mani ye sita ñarʉaroja yuja”, gãmerã yirãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","To bajiri vese sojʉajʉ ĩre ñia oja vanama. To yicõari, sĩarãma ĩna yuja —ĩnare yiyuju Jesús, ti quetire gotigʉ. To bajiro ĩnare yigajanocõari, ado bajiro ĩnare gotiyuju quẽna: —¿Ti vese ʉjʉ tudiejagʉ, no bajiro ĩnare yigʉjari ĩ, ti vese coderimasare? ");
INSERT INTO bsnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ado bajiro yigʉmi: Vesejʉ vacõari, ti vese coderãre sĩagʉ̃mi. To yicõari, gãjerãre coderotigʉmi, ti vesere —ĩnare yiyuju Jesús. To bajiro ĩ yisere ajimasicõañujarã jud'io masa. To bajiri, —¡Bajibeticõato ti! —yiyujarã ĩna. “‘Ʉjʉ macʉre sĩariarãre bajiro bajiaja mʉa’, manire yami” yimasicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","To bajiro ĩna yirone, ĩnare ĩacõari, ado bajiro ĩnare yiyuju Jesús: —¿“Ʉye vese ʉjʉ ĩ macʉre rojorã ĩna sĩarocarere bajirone gʉ̃tavi quẽnorimasa coja gʉ̃tare rocarʉarãma” Dios oca masa ĩna yiucamasirere ĩabeticatique mʉa? Ado bajiro gotiaja: “Gʉ̃ta rãca vi quẽnorimasa coja gʉ̃tare rocarãma ĩna. Ĩna rocaria ñaboarine, gajea gʉ̃ta rẽtoro quẽnarica ñarʉaroja tia. Tia gʉ̃ta sʉorine quẽnarivi quẽnorʉcʉmi Dios. Tia manijama, quẽnomasibetibogʉmi”, yigotiaja Dios oca masa ĩna ucamasire. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","To yigajano, ado bajiro gotirũtuasuju ĩ Jesús: —No bojarã, yʉ ocare ajiterã, rojose tãmʉorʉarãma ĩna —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","To bajiro Jesús ĩ gotimasiosere ajicõari, “Manirene mani bajisere yigʉ yami”, yiajimasiñujarã paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne. “‘Ʉjʉ macʉre sĩariarãre bajiro bajiaja mʉa’ manire yami”, yiajimasiñujarã ĩna. To bajiro yirã ñari, Jesúre ñiarʉaboayujarã ĩna. To bajiboarine masare güirã, ĩre ñiabesujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jesúre ñiarʉarã ñari, gãjerãre cõañujarã ĩna, Jesús tʉjʉ. To bajiri, “‘Mani ʉjʉ César ĩ rotisere quẽnabeaja’ ĩ yisere ajirudirã vasa. To bajiro ĩ yise ti ñajama, ĩre gotiyirorãsa mani, Pilatore”, yitʉoĩaboayujarã. To bajiri Jesús tʉjʉre ĩ gotisere ajirãre bajiro bajitoyujarã ĩna cõariarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jesús tʉ ejacõari, ado bajiro ĩre sẽniĩañujarã ĩna: —Ajiya gotimasiorimasʉ. “Riojo gotigʉ ñaja mʉ”, yimasiaja yʉa. “Ado bajiro mani yisere bojagʉmi Dios” yigotimasiogʉ̃, ñaro cõrone riojo yʉare gotimasioaja mʉ. “Ado bajiro yʉ gotimasiojama, yʉre ajijũnisinirʉarãma” yitʉoĩabecʉne, riojo gotigʉ ñaja mʉ. Masa ñajedirore riojo gotigʉ ñaja mʉ. To bajiro yigʉ mʉ ñajare, mʉ tʉoĩasere ajirʉaja yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Roma macagʉ ʉjʉ, César, gãjoa manire ĩ vaja yirotisere mani vaja yijama, quẽnacõarojari? ¿Dios ĩ rotimasirere cʉdimena yirãjarique mani, ĩre mani vaja yijama? —Jesúre yisẽniĩaboayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Jesújʉama, “Rojose yʉre yirʉarã, to bajise yʉre sẽniĩatoama ĩna”, yimasicõañuju. To bajiri, ado bajiro ĩnare gotiyuju: —Gãjoatii cojotii yʉre ĩoña mʉa. To ĩ yijare, gãjoatii ãmiadi, ĩre ĩoñujarã ĩna. Gãjoatiire ĩacõari, ado bajiro ĩnare sẽniĩañuju Jesús: —¿Ñimʉ rioga tuyati? ¿Ñimʉ vãme tuyati? —ĩnare yiyuju Jesús. To ĩ yirone, —Roma macagʉ Ʉjʉ César vãme cʉtigʉ rioga tuyaja. To yicõari, ĩ vãme tuyaja ti —Jesúre yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","To ĩna yijare, ado bajise yiyuju Jesús: —To bajiri aditiire ĩacõari, “César yatii ñaja”, yimasiaja mani. Ʉjarã manire ĩna vaja yirotijama, ĩnare vaja yiroti ñaja, manire. To bajirone bajiaja Diore quẽne. “Dios sʉori bajiaja” mani yimasijama, “Yʉa cʉose ti ñaboajaquẽne, ti rãca mʉ bojarore bajiro yirʉarãja”, Diore ĩre yiroti ñaja, manire —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","To bajiro ĩ yisere ajicõari, no yimasibesujarã ĩna, to bajise quẽnaro ñagõgʉ̃re ajibetirũgũriarã ñari. To bajiri, ĩre sẽniĩatʉjacõañujarã yuja. Jesús rojose ĩ yibetijare, ĩna ʉjʉre ocasãmasibesujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","To bajicõari, saduceo masa quẽne sĩgʉ̃ri ejayujarã, Jesúre sẽniĩatorã. “Masa ĩna rijato bero, ĩna ʉsʉri ĩna rujʉri ñaro cõrone quẽna tudicatimenama” yirã ñañujarã saduceo masa. Ado bajiro ĩre sẽniĩañujarã: —Ajiya, gotimasiorimasʉ. Moisés ñamasir'i ado bajiro ĩ yiucacũmasire ti ñajare, mʉre sẽniĩarã vabʉ yʉa. Ado bajiro yimasiñuju Moisés: “Sĩgʉ̃, manajo cʉtiboa, rĩa magʉ̃ne ĩ bajirocajama, ĩ gagʉ manajo ñariore manajo cʉtirʉcʉmi ĩ bedijʉa. To bajiri ĩ rãca ñacõari, so macʉ cʉtijama, ĩ gagʉ macʉ ñarʉcʉmi”, yimasiñuju Moisés. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sĩgʉ̃ rĩa cojomo cõro, jʉa jẽnituarirãcʉ ʉ̃mʉa ñaboacama. Sĩgõrene manajo cʉtiboacama ĩna. Ñasʉogʉ sore manajo cʉtisʉoboacami. Rĩa magʉ̃ne rijacoacami ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Ĩ rijato bero, gãji ĩ bedi vasoaboacami. Ĩ quẽne rĩa magʉ̃ne rijacoacami. Ĩ bederã quẽne, to bajirone sore manajo cʉtiboacama. Rĩa manane, rijajedicoacama ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","So manajʉa ĩna rijajediro bero, so quẽne rijacoacamo yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To bajiri bajireacõari, quẽna ĩna tudicatijama, ¿ñimʉjʉa ñaguĩda so manajʉ masu ñarocʉma, ĩna ñaro cõrone sore ĩna manajo cʉticato bero? —Jesúre yisẽniĩatoyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","To ĩna yirone, ado bajiro cʉdiyuju Jesús: —Bajireariarã, “Quẽnarã ñaama” Dios ĩ yiĩarã, quẽna tudicatiro bero, manajo cʉtire, manajʉ cʉtire quẽne manirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tudirijabetirona ñari, to bajiro bajirʉarãma. Õ vecajʉ ángel mesare bajiro bajirã ñarʉarãma. To bajicõari, ĩ sʉorine tudicatiriarã ñari, Dios rĩa ñarʉarãma —ĩnare yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—¿“Masa ĩna bajirearo bero, ĩna ʉsʉri caticõaroja” yirere ĩabeticatique mʉa? ¿Yucʉ́yoa ʉ̃jʉriyoa vatoajʉ Dios Moisére ĩ ñagõmasirere ĩabeticatique? Dios masune ado bajiro gotimasiñumi ĩ oca masa ĩna ucamasire rãca: “Mʉa ñicʉa ñamasiriarã Abraham, Isaac, Jacob, ĩna rʉ̃cʉbʉo vadimasicacʉne ñaja yʉ”, yigotimasiñumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Masa bajireariarã ĩna ʉsʉri ti caticõa ñabetijama, to bajise yibetimasiborimi. Bajireariarã, quẽna tudicatirãjʉa ĩna rʉ̃cʉbʉogʉ ñagʉ̃mi. Masa ĩna ʉsʉri ti caticõa ñabetiboajaquẽne, “Diore rʉ̃cʉbʉorã ñarãma”, yimasiña maja. “Ĩna ʉsʉri ti caticõa ñajare, bajireariarã ñaboarine, Diore rʉ̃cʉbʉocõa ñarãma”, yire ñaja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","To ĩ yise ñajare, saduceo masa, ĩre sẽniĩarẽmobesujarã, ĩre güirã ñari. To bajiri, ado bajiro Jesúre yiyujarã sĩgʉ̃ri, Dios ĩ rotimasire gotimasiorimasajʉama: —Gotimasiorimasʉ, quẽnaro cʉdiaja mʉ —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","43","To bajiro ĩre ĩna yiboajaquẽne, ado bajiro masare gotiyuju Jesús: —“‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, masʉ ñarʉcʉmi. Ʉjʉ David ñamasir'i jãnamine ñarʉcʉmi” yise ñaja. To bajiro mʉa yitʉoĩaboajaquẽne, Diore yigʉre bajiro, “yʉ ʉjʉ”, yimasiñujari Ʉjʉ David ñamasir'i, ĩ jãnami ĩ ñaboajaquẽne, ado bajise ĩ yiucajama: “Yʉ ʉjʉre ado bajiro yirʉcʉmi Dios: ‘Yʉ riojojacatʉa rujiya maji. Mʉre ĩaterãre, “Rojose yitʉjaya” ĩnare yʉ yiro bero, rojose yimasibetirʉarãma yuja. To cõrone rotisʉorʉcʉja mʉ’ yirʉcʉmi Dios, yʉ ʉjʉre”, yiucamasiñumi David. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","To bajiri, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, David ñamasir'i jãnami ñarʉcʉmi” yiucamasire ti ñaboajaquẽne, ¿no yigʉ ĩ ʉjʉre bajiro bajigʉtique? —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","To bajiro ĩnare yigajanocõari, masa ĩna ajijediro, ado bajiro ĩ buerimasare gotiyuju Jesús: —Dios ĩ rotimasire gotimasiorimasare bajiro bajibeja mʉama. Dios ĩ rotimasire gotimasiorimasa, sudiro yoaquẽnariase sãñacõari, masa ĩna ĩaro rĩjoro vacudi variquẽnarãma ĩna. To yicõari, jãjarã masa ĩna rẽjarũgũrijaʉrire ejarũgũrãma. Gãji ĩnare ĩ bocajama, rʉ̃cʉbʉose rãca ĩnare ĩ sẽnisere ajivariquẽnarãma. Dios ocare ĩna buerivirijʉre quẽne ñamasuri cũmurorire rujivariquẽnarãma. Boserʉ̃mʉri ti ñajaquẽne, ĩna bajama, ñamasuri cũmurorire rujivariquẽnarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Manajʉa rijaveoriarã ya virire ẽmarã ñaboarine, masa ĩna ĩaro rĩjorojʉa, “‘Quẽnaro yirã ñaama’ yiĩato” yirã, yoaro Diore sẽnirã yaja, yisocarũgũboarãma ĩna. To bajiro ĩna yise vaja, gãjerã rojorã, rojose ĩna tãmʉose rẽtoro rojose tãmʉorʉarãma ĩna —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Diore yirʉ̃cʉbʉoriavijʉ ñacõari, gãjoa jairã gãjoa sãriajʉjʉre gãjoa ĩna sãñasere ĩañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","To ĩna yiñarone, sĩgõ, manajʉ rijaveorio, gãjoatii jʉatiine so sãsere ĩañuju. Mojoroaca vaja cʉtitiiri ñañuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tire so sãro ĩacõari, ado bajiro ĩ buerimasare gotiyuju Jesús: —Riojo mʉare gotiaja yʉ. Adio maioro bajigo, gãjerã rẽtoro sãmo so. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gãjoa jairã ĩna sãboajaquẽne, jairo rʉyacõaroja ĩnarema. Soma, so cʉose ñaro cõroacane sãcõamo —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Diore yirʉ̃cʉbʉoriavire ĩacõari, sĩgʉ̃ri ĩ buerimasa ado bajiro Jesúre ĩre yiyujarã: —Quẽnarivi ñaja. Gʉ̃ta quẽnase rãca quẽnaro quẽnoñuma ĩna. Diore rʉ̃cʉbʉorã ĩna cũre quẽne quẽnase ñaja —Jesúre ĩre yiyujarã ĩna. To bajiro ĩna yisere ajicõari, ado bajiro gotiyuju Jesús: —Adi vi mʉa ĩarivi ñaro cõrone cague vẽjajedicoarʉaroja. To bajiri adi viaye gajea gʉ̃ta joere jesabetirʉaroja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ado bajiro Jesúre ĩre sẽniĩañujarã ĩna: —¿Divato cagueroca ecoroti Diore yirʉ̃cʉbʉoriavi? ¿No bajiro ti bajiro ĩacõari, “Jesús ejagʉagʉ yigʉmi”, yimasirãti yʉa? ¿No bajiro ti bajiro ĩacõari, “Adi macarʉcʉro jediato yaja”, yimasirãti yʉa? —Jesúre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdiyuju Jesús: —Roori ñarʉarãja mʉa, “Socarãne, gãjerã manire yitoroma” yirã. Jãjarã yitorã ñarʉarãma, “Yʉne ñaja ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃” yirã. To yicõari, “Adi macarʉcʉro ti jediroti cõñaja”, yitorʉarãma. To bajiro ĩna yiboajaquẽne, ĩnare ajitirʉ̃nʉbetirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","To bajicõari, mʉa tʉana to yicõari, gajeroana quẽne gãjerã rãca ĩna gãmerã sĩasere ajirʉarãja mʉa. Tire ajicõari, güibetirʉarãja mʉa. “Bajirʉaroja” Dios ĩ yiriarore bajirone bajirʉaroja. To bajiro ĩna gãmerã yiñaboajaquẽne, adi macarʉcʉro jediro me bajirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cojo sitana, gaje sitana rãca gãmerã sĩarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bʉto sita saberʉaroja. To yicõari, cojo maca me ñioñarʉaroja. To bajicõari, cojo sita me gajeye rojose cõarʉcʉmi Dios, “Rojose tãmʉoato masa” yigʉ. Vecajʉre ĩaĩañamani güiose Dios ĩ yiĩose ñarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","To bajiro ti bajiroto rĩjoro, mʉare ñejecõari, rojose mʉare yirʉarãma masa. Dios ocare ĩna buerivijʉ ʉjarã rĩjorojʉa mʉare juaácõari, mʉare goti yirorʉarãma ĩna. To yicõari, mʉare tubiberʉarãma. Yʉ ocare mʉa gotimasiojare, macari ʉjarã rĩjorojʉa mʉare juaárʉarãma ĩna. To yi vanane, ʉjarã ñamasurã rĩjorojʉa mʉare juaejarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","To bajiro mʉare ĩna yijare, yʉ oca quẽnasere ĩnare gotirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mʉare ñejecõari, ʉjarã rĩjorojʉa mʉare ĩna juaároto rĩjoro, “¿No bajiro ñagõrãti yʉa?”, yitʉoĩarejaibetirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mʉa ñagõrotijʉ ti ejaro, “Ado bajiro ñagõroti ñaja”, yimasirʉarãja. Mʉa ñagõjama, mʉa masise rãca me ñagõrʉarãja. Yʉ masise rãca ñagõrʉarãja. Yʉ masise mʉare yʉ cõajare, mʉa ñagõsere ajicõari, “Socarã yaja mʉa”, mʉare yibetirʉarãma mʉare ĩaterã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Mʉa jacʉa, mʉa bederã, mʉa yarã, mʉa rãcana quẽne, mʉare ĩsirearʉarãma ĩna. To bajiro ĩna yijare, sĩaecorʉarãja mʉa sĩgʉ̃ri. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yʉre ajitirʉ̃nʉrã mʉa ñajare, mʉare ĩaterʉarãma jãjarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","To bajiro mʉare ĩna yiboajaquẽne, ñie mʉare godocʉtirʉaroja. Dios ĩ ejarẽmose rãca ĩ tʉjʉ ejacõari, quẽnaro ñacõa ñarũgũrʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yʉre mʉa ajitirʉ̃nʉ tʉjabetijama, to bajirone bajirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusalén macajʉre surara ĩna gãnibiasere mʉa ĩajama, “Jerusalén maca ti jedirotirʉ̃mʉ cõñaro bajiaja”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Jerusalén maca jedirotire Dios oca masa ĩna ucamasire ti gotirore bajiro bajirʉaroja. Rojose tãmʉoriarʉ̃mʉri ñarʉaroja. To bajiroti ti ñajare, Jerusalén maca tʉana, Judea sitana, Jerusalén macajʉ rudibeticõato ĩna. Gʉ̃tayucʉjʉajʉ guaro rudicoajaro ĩna. Jerusalén macana quẽne, guaro rudicoajaro ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","To bajiro bajirirʉ̃mʉre bʉto rojose tãmʉorʉarãma masa, ĩ bojasere ĩna yibetire Dios ĩ ĩajũnisinijare. Rõmia macʉ sãñarã, ũjurã cʉorã quẽne, rojose tãmʉorʉarãma ĩna, ũmatĩmabetica yirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sĩgʉ̃rire jasĩarʉarãma jud'io masa me ñarã. Gãjerãre, sĩaecomenare ĩnare ñejebatecoarʉarãma, gajerorijʉ. To yicõari, ĩna ye sita cʉorʉarãma jud'io masa me ñarã, “To cõrone rotitʉjarʉarãma” Dios ĩ yitʉoĩariarʉ̃mʉ ti ejaroto rĩjoro. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jud'io masa me ñarã ĩna rotirirodo jedirijaʉ, muiju ʉ̃mʉagʉ, to yicõari, ñamiagʉ quẽne, ñocoa quẽne, bʉto güiose bajiĩorʉarãma. Tire ĩagüirʉarãma adi macarʉcʉroana ñajediro. Moa riaga bʉto jacase saberʉaroja. To bajiro ti bʉsisere ajigüicõari, no yimasibetirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Õ vecayere nʉrʉobatorʉcʉmi Dios. To bajiro ti bajiro ĩacõari, “Adi macarʉcʉro jediato yaja” yitʉoĩacõari, bʉto güirʉarãma ĩna. Sĩgʉ̃ri ĩamecʉ vanane, rijavẽjarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","To bajicõari, yʉ masise rãca, bʉto bususe rãca, oco bueri vatoajʉ adi macarʉcʉrojʉre Dios ĩ roticõacacʉ yʉ rujiadire ĩarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","To bajiri, adi güiose ti bajisʉorore ĩacõari, tʉoĩatutuarʉarãja mʉa. Tʉoĩatutuacõari, ĩamʉorʉarãja mʉa, “Yucʉacane rojose tãmʉotʉjabetiriarojʉ mani vaborotire manire yirẽtobosagʉagʉ yigʉmi Dios” yimasirã ñari —ĩnare yigotiyuju Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","To yigajanocõari, gotimasiore queti gotiyuju quẽna: —Yʉcʉ́re tʉoĩaña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yucʉ́ gajecu bʉcʉamʉjacõari, jũ mameaja. Tire ĩacõari, “Mojoroaca rʉyaja cʉ̃ma ti ejaroti”, yimasiaja mani, jud'io masa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tire bajiro mʉare yʉ gotise ti bajisere ĩacõari, “Mojoroaca rʉyaja Diore rotibosagʉ, Jesús ĩ vadiroti”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Riojo mʉare gotiaja yʉ. Adirodo ñarã mʉa bajireajediroto rĩjoro, mʉare yʉ gotirore bajirone bajirʉaroja ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adi macarʉcʉro ñaro cõrone, to yicõari, õ vecaye quẽne jedicoarʉaroja. To bajiboarine, yʉ ocama, jedibeti mʉorʉ̃gõcõarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","To bajiri yʉ vadirotire masiritibesa. Idire mecʉose idimecʉcõari, yʉre mʉa masiritijama, quẽnabetoja. To bajicõari, gajeyeũni mʉa cʉose, to yicõari, gajeye mʉa cʉorʉa tʉoĩasere bʉto tʉoĩarã ñari, yʉre mʉa masiritijama, quẽnabetoja. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“To cõrone ejarʉcʉmi” jãjarã masa ĩna yimasibetirĩmarone, tudiejarʉcʉja yʉ. To yʉ bajijare, masa ñajediro yʉre rudimasibetirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","To bajiro bajiroti ti ñajare, roori ñarʉarãja mʉa. To bajicõari, ado bajiro Diore sẽnirũgũrʉarãja mʉa: “‘Dios ĩ roticõacacʉ ĩ tudivadiroto rĩjoro, rojose tãmʉoroti ti ñaboajaquẽne, ĩre ajitirʉ̃nʉ tʉjabeticõari, õ vecajʉ ĩ rĩjorojʉa bojonemenane ejato’ yigʉ, yʉare ejarẽmoña”, ĩre yisẽnirũgũrʉarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tocãrãcarʉ̃mʉrine Diore yirʉ̃cʉbʉoriavijʉ masare gotimasiorũgũñuju Jesús. Ñamirema ĩnare vaveocõari, Olivo vãme cʉti burojʉ cãnirũgũñuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Quẽna busurijʉ jãjarã masa ĩre ajirã sãjarũgũñujarã ĩna, Diore yirʉ̃cʉbʉoriavijʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pascua boserʉ̃mʉ pan ũmato vauvase vʉoyamani basʉoriarʉ̃mʉ cõñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","To bajicõari, paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa quẽne, Jesúre sĩarʉarã, masare güirã ñari, “¿No bajiro yicõari, ĩre ñiarãti mani?”, gãmerã yiñagõñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","To ĩna yitʉoĩañatoyene, Judas Iscariote vãme cʉtigʉ rãca ñarã ñajediro Jesús buerimasa, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñañujarã. To bajiboagʉre, ĩ ʉsʉjʉre sãjacoasuju vãtia ʉjʉ, Satanás vãme cʉtigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","To bajiri, ĩ ʉsʉjʉ vãtia ʉjʉ ĩ sãjare, ĩ sʉorine rojose tʉoĩacõari, paia ʉjarã, Diore yirʉ̃cʉbʉoriavi coderã ĩna ñarojʉre vacoasuju Judas. Ĩna tʉjʉ ejacõari, Jesúre ĩ ĩsirocarotire gãmerã ñagõñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jesúre ĩ ĩsirocarʉasere ajivariquẽnacõari, —Gãjoa mʉre ĩsirʉarãja yʉa —ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","To ĩna yisere ajivariquẽnacõari, tudicoasuju Judas. Jesús tʉjʉre ejacõari, “¿Dirĩmaro ũnone Jesúre ĩnare yʉ ĩsijama, josari mene ĩre ñiamasirojari ĩna?”, yitʉoĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pascua boserʉ̃mʉ pan ũmato vauvase vʉoyamani basʉoriarʉ̃mʉ, to yicõari, oveja macʉre ĩna sĩariarʉ̃mʉ ejayuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","To bajiri Pedrore, Juanre ado bajiro ĩnare yicõañuju Jesús: —Adi ñami bare mani barotire quẽnoyurã vasa mʉa —ĩnare yicõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","To bajiro ĩ yisere ajicõari, —¿Nojʉ bare quẽnoyurãti yʉa? —ĩre yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","To bajiro ĩna yisẽniĩarone, ado bajirone ĩnare cʉdiyuju Jesús: —Yʉre quẽnaro ajiya mʉa. Macajʉ mʉare yʉ gotigʉ tʉre vasa mʉa. To mʉa ejarone, sĩgʉ̃, oco vagʉ mʉare bocarʉcʉmi. Ĩre sʉyaja mʉa. To bajicõari, vi ĩ sãjarone, ti vi ʉjʉre ado bajiro ĩre yiba: “‘¿Nojʉ ñati Pascua boserʉ̃mʉ adi ñami yʉ buerimasare yʉ ũmato barotijaʉ?’ mʉre yicõami gotimasiorimasʉ”, yiba mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","To mʉa yirone, mʉare ĩorʉcʉmi, vecajʉa sõa, jairisõa, quẽnogajanoriasõare. Tone mani baroti quẽnoyuba mʉa —ĩnare yiyuju Jesús, ĩnare varotigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","To ĩ yijare, vacoasujarã ĩna jʉarã yuja. To eja, ĩ yiriarore bajirone bajiyuju ti. To bajiri tisõajʉ ĩna barotire quẽnoyuyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","To bajiri Pascua boserʉ̃mʉaye bare bariajʉ ti ejaro, ĩ buerimasa jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarã ejacõari, barujiyujarã ĩna, ĩ rãca. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","To bajiñarãne, ĩnare ũmato bagʉagʉne, ado bajiro ĩnare gotiyuju Jesús: —Rojose yʉ tãmʉoroto rĩjoro, mʉa rãca Pascua boserʉ̃mʉ bare bʉto barʉa tʉoĩacajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dios ĩ roticõacacʉ ñari, mʉare yʉ ũmato baro bero, quẽna tudibabetirʉcʉja. To bajiboarine, adi macarʉcʉrojʉ yʉ tudivado berojʉ yʉre roticõacacʉ ĩ ñarojʉre tudi mʉa rãca quẽnaro bavariquẽnarʉcʉja yʉ, rojose tãmʉoboriarãre yʉ yirẽtobosarã rãca —ĩ buerimasare ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","To yigajano, idiriabaja ãmicõari, —Quẽnaro yaja mʉ —Diore yiyuju. To yicõari, tibaja ĩnare ĩsigʉ̃ne, ado bajiro yiyuju ĩ: —Mʉa jediro adire idiya. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Riojo mʉare gotiaja yʉ. “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, Dios yʉre ĩ cũroto rĩjoro, ʉye oco idibetirʉcʉja yʉ —ĩnare yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","To yigajanocõari, pan ãmicõari, “Quẽnaja”, Diore yiyuju Jesús. To yigajano, tire mʉtocõari, ĩ buerimasare ĩsibatogʉne, ado bajiro ĩnare gotiyuju ĩ: —Ti ñaja yʉ rujʉ rii. Mʉare rijabosarʉcʉja yʉ. Yʉ rijato bero, mʉare yʉ rijabosare tʉoĩacõari, yʉre rʉ̃cʉbʉorã, ado bajirone rẽjacõari, barũgũrʉarãja —ĩnare yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","To yicõari, bare ĩna baro bero, ʉye oco sãñaribajare ãmicõari, ado bajiro ĩnare gotiyuju Jesús quẽna: —Adi ñaja tirʉ̃mʉana, “Rojose mani yirere masirioato” yirã, Diore rʉ̃cʉbʉoriajʉ joere ĩna yuejeoriarore bajiro bajise. Yucʉrema, yʉ ri'i ñaja. Ti sʉorine, “Gajerodori ado bajiro masare quẽnaro yirʉcʉja yʉ” Dios ĩ yigotimasiriarore bajiro bajirʉaroja yuja. Yʉ rijato bero, mʉare yʉ rijabosare tʉoĩacõari, yʉre rʉ̃cʉbʉorã, ado bajirone rẽjacõari, idirũgũrʉarãja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","To yigajano, ado bajiro ĩnare gotiyuju quẽna: —Dios ĩ tʉoĩariarore bajiro rojose tãmʉorʉcʉja yʉ, Dios ĩ roticõacacʉ. To bajiro bajirocʉ yʉ ñajare, sĩgʉ̃ mʉa rãcagʉ, yʉ rãca bagʉ, yʉre ĩaterãre yʉre ĩsirocarʉcʉmi. Yʉre ĩ gotiyirose sʉorine rojose tãmʉorʉcʉja yʉ. “Masare yirẽtobosarʉcʉmi” Dios ĩ yimasire ñajare, tirotire yigʉ bajirʉcʉja yʉma. To bajiboarine, yʉre gotiyirogʉjʉama, rojose tãmʉorʉcʉmi —ĩnare yigotiyuju Jesús, ĩ buerimasare. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","To bajiro ĩ yisere ajicõari, —¿Ñimʉjʉa ñati, ĩre ĩsirocarocʉma? —ĩna masune gãmerã yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","To bajiro gãmerã yigajanocõari, —¿Ñimʉjʉa ñagʉ̃ti ñamasugʉ̃ma? —gãmerã yi oca josayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","To bajiro ĩna yijare, ado bajiro ĩnare gotiyuju Jesús: —Ʉjarã, Dios yarã me ñarã, ĩna yarãre bʉto tutuaro rotirãma ĩna. To bajiro yirã ĩna ñaboajaquẽne, “Masare quẽnaro yirã ñaama”, yiĩarʉ̃cʉbʉore ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉama, yʉ yarã ñari, ĩnare bajiro bajibetirʉarãja. Yʉre ajitirʉ̃nʉgʉ̃, ñamasugʉ̃ ñarʉcʉmi, gãjerã bedire bajiro bajitʉoĩagʉ̃. To bajiro yʉ yijama, “Gãjerã ĩna bojasere masicõari, quẽnaro ĩnare yirʉ̃cʉbʉogʉ ñarʉcʉmi” yigʉ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Nijʉa rẽtoro ñamasugʉ̃ ñarojari, rotigʉjʉa, rotiecogʉjʉa? Moarotigʉ ñagʉ̃mi ñamasugʉ̃ma. To bajiro ti bajiboajaquẽne, yʉjʉa, mʉa ʉjʉ ñaboarine mʉa bojasere masicõari, quẽnaro mʉare yigʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Rojose tãmʉoadicajʉ yʉ. To bajiro bajigʉ yʉ ñaboajaquẽne, yʉre ajitirʉ̃nʉcõa ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","To bajiro bajirã mʉa ñajare, ado bajiro quẽnaro mʉare yirʉcʉja yʉ: “Rotimʉorʉ̃gõrʉcʉja mʉ” yigʉ, yʉ jacʉ yʉre ĩ cũrojʉ, “Rotirʉarãja mʉa quẽne” yigʉ, mʉare cũrʉcʉja yʉ quẽne. To cõrone jʉaãmo cõro, cojo gʉbo jʉa jẽnituaro ñariaserire rujirʉarãja mʉa. To yicõari, mani yarã, jud'io masa, jʉaãmo cõro, cojo gʉbo jʉa jẽnituarirãcʉ ñarã masatubuarire rotirʉarãja mʉa. Yʉre ajitirʉ̃nʉrãre, to yicõari, yʉre ajitirʉ̃nʉmenare ĩacõĩamasirʉarãja. To yicõari, yʉ rãca bare ba, idi yiiñarũgũrʉarãja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","To yigajanocõari, ĩ buegʉre Pedrore ado bajiro gotiyuju Jesús: —Quẽnaro yʉre ajiya mʉa. Vãtia ʉjʉ, “‘¿Jesúre ajitirʉ̃nʉrã masu ñati ĩna?’ yiĩarʉ, rojose ĩnare cõarʉaja yʉ”, Diore yisẽniĩañuju ĩ, mʉare. To bajiro ĩ yijama, “Rojose ĩnare yʉ cõajama, Jesúre ajitirʉ̃nʉ tʉjacoanama ĩna” yigʉ, yiyuju ĩ, tire. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","To bajiro Diore ĩ yiboajaquẽne, Diore mʉre sẽnibosabʉ yʉ, “Yʉre ajitirʉ̃nʉbetiboarine, quẽna yʉre ajitirʉ̃nʉato ĩ” yigʉ. To bajiri yʉre ajitirʉ̃nʉbetiboarine, quẽna yʉre mʉ ajitirʉ̃nʉro bero, gãjerã yʉ buerã ñarãre ejarẽmoma, quẽnaro yʉre ĩna ajitirʉ̃nʉcõa ñarũgũrotire yigʉ —Pedrore ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","To bajiro ĩre ĩ yisere ajicõari, ado bajiro Jesúre ĩre yiyuju Pedro: —Mʉre ĩna tubibeboajaquẽne, mʉre ĩna sĩacõajaquẽne, mʉ rãca ñacõa ñagʉ̃ ñari, sĩaecomasiaja yʉ quẽne —Jesúre ĩre yiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","To ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Riojo mʉre gotiaja yʉ. Busiyʉjʉa gãjabocʉ ĩ ñagõroto rĩjoro idiaji, “Jesúre masibeaja; ĩ rãcagʉ me ñaja yʉ”, yirʉcʉja mʉ —Pedrore ĩre yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","To yigajanocõari, ĩ buerimasare ado bajiro ĩnare sẽniĩañuju Jesús: —¿Mʉa cʉosere, mʉa barere, gajeye gʉbo sudire quẽne tire mʉare juarotibeticõari, “Jʉarãri, vacõari, yʉ ocare gotibosacudiaya” yigʉ, mʉare yʉ yirotisʉocatirʉ̃mʉre ñie mʉare godocʉocati? —ĩnare yisẽniĩañuju. —Yʉare godo cʉobeticajʉ —yicʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","To bajiro ĩna yicʉdisere ajicõari, ado bajiro ĩnare gotiyuju Jesús: —Yucʉrema mʉa cʉosere, mʉa barere, to yicõari, mʉa gãjoare quẽne juaya. Jariase cʉobecʉ, sudiro yoariase, ĩ gʉbojʉ tʉsariasere ĩsicõari, jariasere vaja yiya. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Masa rojose yʉre ĩna yirotire quẽnaro mʉa tʉoĩamasirotire yigʉ, to bajise mʉare yaja yʉ. Ado bajiro yʉre gotiyuja Dios oca masa ĩna ucamasire: “Rojorãre ĩnare ĩna yirore bajiro ĩre yirʉarãma, rojose ĩ tãmʉorotire yirã”, yʉre yigotiyuja ti. Diore gotirẽtobosarimasa, “Ado bajiro bajirʉaroja” ĩna yiucamasire ñajare, to bajiro yʉre yirʉarãma. Ñajediro ĩna ucamasirere bajirone bajijeocõarʉaroja yʉre —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","To bajiro ĩnare ĩ yisere ajimasibeticõari, ado bajiro ĩre yiyujarã ĩna, ĩ buerã: —Yʉa ʉjʉ, ĩaña mʉ. Adone jʉajãi, jariase cʉoaja yʉa —yiyujarã ĩna. To bajiro ĩna yijare, —To bajiro masu yimenaja mani —ĩnare yicʉdiyuju Jesús yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","To yigajanocõari, Jerusalén vãme cʉti macajʉ ñar'i, Olivo vãme cʉti burojʉ ĩ buerimasare ĩ ũmato varũgũriarore bajirone ĩnare ũmato vasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tojʉ ejacõari, ado bajiro ĩnare gotiyuju Jesús: —Vãtia ʉjʉ Satanás ĩ yirotisere yicõari, “Dios ĩ bojabetire yirobe” yirã, Diore sẽniña —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","To bajiro ĩnare yicõa, ĩ sĩgʉ̃ne to sojʉabʉsa vasuju ĩ. Ĩacõarine ñagʉ̃, gʉsomuniari tuetucõari, ado bajiro Diore sẽniñuju ĩ: —Cacʉ, yʉre ĩna sĩaroti matamasiaja mʉ. To bajiboarine, mʉ bojarore bajirone bajiato —Diore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","To bajiro ĩre yigajanorone, ángel Diore moabosagʉ ruyuayuju ĩ. Ruyuacõari, “Dios ĩ bojarore bajiro yicõa ñato” yigʉ, Jesúre ejarẽmoñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","To ĩ yiro bero, rojose ĩ tãmʉorotire tʉoĩa sʉtiritigʉ ñari, bʉtobʉsa Dios ĩ ejarẽmorotire sẽnitʉjabesuju Jesús. To bajiro bajiñagʉ̃ rĩne, bʉto ri'i rãca vʉsase ʉsaca budicõari, “tapi, tapi, tapi” yivẽjareacũñuju ti, sita joejʉre. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Diore sẽnigajano, vʉ̃mʉrʉ̃gʉ̃cõari, ĩ buerã tʉ tudiejayuju. Ĩ gotirere bʉto tʉoĩasʉtiriticodeboa, cãnicoasujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ĩna tʉ ejacõari, —Cãnibesa mʉa. Vʉ̃mʉrʉ̃gʉ̃cõari, Diore sẽniña, “Vãtia ʉjʉ Satanás ĩ yirotisere yicõari, Dios ĩ bojabetire yirobe” yirã —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","To bajiro Jesús ĩnare ĩ gotiñarirĩmarone, jãjarã masa vayujarã ĩna. Ĩnare ũmato vagʉ, Judas Iscariote vãme cʉtigʉ, Jesús buerimasʉ ñar'ine ñañuju ĩ. To bajivadi, Jesús rĩjorojʉa ejacõari, socʉne ĩre bʉto ĩamaigʉ̃re bajiro ĩre usugʉagʉ yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","To ĩ yirone, ado bajiro ĩre gotiyuju Jesús: —Judas, ¿Dios ĩ roticõacacʉre yʉre sĩaronare, “To bajiro usugotigʉsa”, yitʉoĩaboati mʉ? —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","To bajiro ĩ yirone, Jesúre ĩna ñiarʉaro ĩamasicõari, —Yʉa ʉjʉ, ¿jariase rãca ĩnare jasurereacõarãti yʉa? —yisẽniĩañujarã ĩna, ĩ buerã. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","To yisẽniĩarãne, sĩgʉ̃ ĩ buegʉ, ĩ jariase yoveaãmicõari, paia ʉjʉ ñamasugʉ̃re moabosarimasʉre gãmoro jatarocacõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","To ĩ yisere ĩacõari, ado bajiro ĩre yiyuju Jesús: —Yibesa mʉa —ĩnare yiyuju Jesús, ĩ buerãre. To yicõari, gãmoro jataroca ecogʉjʉare ĩ gãmorore ãmitucõari, ñariarore bajirone yiquẽnocõañuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","To yicõari, ĩre ñiarʉarãre, paia ʉjarãre, Diore yirʉ̃cʉbʉoriavi coderimasare, to yicõari, bʉcʉrãre quẽne, ado bajiro ĩnare yiyuju Jesús: —¿No yirã gajeyeũni juarudirimasʉre ñiarãre bajiro jariaseri rãca, yucʉ́ rãca yʉre ñiarã vadiati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tocãrãcarʉ̃mʉrine Diore yirʉ̃cʉbʉoriavijʉ mʉa ñaro gotimasiorũgũmʉ yʉ. To bajiboarine yʉre ñiabetirũgũmʉ mʉa maji. Yucʉrema Dios ĩ tʉoĩacatore bajirone bajirʉaroja. To bajiri, Satanás sʉorine rojose mʉa bojarore bajiro yimasirʉarãja mʉa yuja —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","To bajiro ĩ yirone, Jesúre ñiacõari, paia ʉjʉ ñamasugʉ̃ tʉjʉ ĩre ãmiasujarã. Tojʉ ejacõari, sãjasujarã ĩna. Ĩre ĩna ãmivato, sõjʉ yayiĩasʉyayuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","To bajiri Jesúre ãmivariarã sĩgʉ̃ri tojʉ ejacõari, macajʉ́ tũcuro gʉdarecojʉ tujayujarã. Tone jea riocõari, rujiyujarã ĩna, jea sũmañarã. To ĩna bajiñarone, ejacõari, ĩna rãca rujiyuju Pedro quẽne, jea sũmagʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jeame tʉ rujigʉ ñari, quẽnaro ruyuyuju ĩ. To bajiro ĩ bajijare, sĩgõ paia ʉjʉ ñamasugʉ̃re moabosarimaso, jeame tʉ ĩ rujiro ĩre ĩamasicõari, —Jesúrãcagʉne ñaami —Pedrore yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","To bajiro so yisere ajicõari, ado bajiro sore yiyuju Pedro: —Ĩre masibeaja yʉ —sore yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","To ĩ yiro beroaca, ĩre ĩacõari, —¿Jesúrãcagʉ ñabetiboati mʉ? —ĩre yiyuju gãji. To bajiro ĩ yisere ajicõari, —Ĩ me ñaja yʉ —yiyuju ĩjʉama. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cojo hora bero, gãji, Pedro ĩ ñagõsere ajicõari, ĩ babarãre ado bajiro yiyuju: —Jesúrãcagʉne ñaami, Galilea sitagʉ ñari —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","To bajiro ĩre ĩ yisere ajicõari, ado bajiro yiyuju Pedro: —“Riojo yaja mʉ”, mʉre yimasibeaja yʉ. Jesúre masibeaja —ĩre yiyuju Pedro. To bajiro ĩ yirirĩmarone, gãjabocʉ ñagõcõañuju yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ĩ ñagõrone, Jesús, jʉdarʉ̃gʉ̃cõari, Pedrore ĩañuju ĩ. Ĩ jʉdarʉ̃gʉ̃ ĩarone, Jesús ĩre ĩ gotirere masibʉjayuju Pedro yuja, “Gãjabocʉ ĩ ñagõroto rĩjoro, idiaji, ‘Jesúre ajisʉyagʉ me ñaja yʉ’ yirʉcʉja mʉ” Jesús ĩ yirere. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tire masibʉjacõari, vacoasuju. Vacõari, bʉto otiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","To bajiri, Jesúre ĩacoderimasa, ĩre jacõari, ajatud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ĩ cajere siabibecõari, ĩre jayujarã. To yicõari, —“‘Ĩ, mʉre jaami’ yʉre yigotiami Dios”, yʉare yiya mʉ —Jesúre ĩre yisẽniĩa tud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","To yicõari, cojo vãme me ĩre yiajatud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","Busuro bero, paia ʉjarã quẽne, to yicõari, Dios ĩ rotimasire gotimasiorimasa quẽne, Jesús tʉre rẽjañujarã ĩna. Rẽjacõari, ĩre ãmiasujarã ĩna, ʉjarã ñamasurã tʉjʉre. Tojʉ ejacõari, ado bajiro Jesúre yiyujarã ĩna: —“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ mʉ ñajama, yʉare gotiya —Jesúre ĩre yiyujarã ĩna. To bajiro ĩre ĩna yisere ajicõari, ado bajiro cʉdiyuju Jesús: —“Ĩne ñaja yʉ” yʉ yijama, yʉre ajirʉamenaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yʉjʉa, yʉ sẽniĩajama, yʉre cʉdimenaja mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","To yigajanocõari, ado bajiro ĩnare gotiyuju quẽna: —Yʉ bajirotire masibeticõari, to bajiro yʉre yaja mʉa. Dios ĩ roticõacacʉ ñari, yoaro mene ĩ riojojacatʉa rujicõari mʉare yʉ besero ĩarʉarãja mʉa —yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","To bajiro ĩ yisere ajicõari, —¿“Dios macʉne ñaja yʉ” yigʉ yati mʉ? —ĩre yisẽniĩañujarã ĩna jediro. To bajiro ĩna yisere ajicõari, —To bajirone bajiaja. Ĩne ñaja yʉ —ĩnare yicʉdiyuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","To bajiro ĩ yisere ajicõari, ado bajiro gãmerã ñagõñujarã ĩna: —“Dios ĩ cõacacʉ, ĩ macʉ ñaja yʉ” ĩ yise sʉorine Diore rojose yigʉ yami. No yirã gãjerãre, “Rojose yigʉ ñaami” yironare macarẽmomenaja mani yuja —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","2","To yigajanocõari, Jesúre ĩre ãmiasujarã ĩna jediro, Pilato vãme cʉtigʉ ya vijʉ vana. Ĩ tʉjʉ ĩre ãmiejacõari, ado bajiro Jesúre gotiyiroyujarã ĩna: —Ãnire bʉjabʉ yʉa. Ado bajiro yimi: “Ʉjʉ Césare gãjoa mʉare ĩ vaja yirotisere mʉa vaja yijama, quẽnabeaja. To yicõari, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃ ñaja yʉ”, yimi —Jesúre ĩre yigotiyiroyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","To bajiro ĩna yise ñajare, ado bajiro Jesúre sẽniĩañuju Pilato: —¿Mʉne ñati jud'io masa ʉjʉ? —ĩre yiyuju Pilato. To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —To bajirone bajiaja —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","To ĩ yirone, paia ʉjarãre, to yicõari, jãjarã masa to ñarãre quẽne ado bajiro ĩnare yiyuju Pilato: —Yʉ ĩajama, ñie rojose yigʉ me ñaami —ĩnare yiboayuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","To bajiro ĩ yiboajaquẽne, bʉto avasãñujarã ĩna: —Galilea sitajʉre gotimasiosʉoyumi. Bero, Judea sitana ñajedirore gotibatomavisioami —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","7","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare sẽniĩañuju Pilato: —¿Ãni, Jesús Galileagʉ ñati? —ĩnare yisẽniĩañuju ĩ. To ĩ yirone, —Toagʉne ñaami —yicʉdiyujarã ĩna. To bajiro ĩna yijare, —Ʉjʉ Herodes ya sitagʉ ĩ ñajare, Herodejʉa ĩre ĩacõĩato —ĩnare yiyuju Pilato. Tirʉ̃mʉrire Jerusalénjʉne ñañuju Herodes quẽne, Pilato ĩ ñarimacane. To bajiri tire masicõari, Herodes tʉjʉ Jesúre cõañuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","To bajiri, Jesús ĩ ejaro, ĩre ĩacõari, bʉto variquẽnañuju Herodes, bʉto ĩre ĩarʉarũgũr'i ñari. Yoaro ĩre ĩarʉaboayuju. Jesús ĩ yirere ajirũgũr'i ñari, ĩ ĩaro rĩjorojʉa quẽne, ĩaĩañamani Jesús ĩ yiĩosere bʉto ĩarʉayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","To bajiro yigʉ ñari, yoaro Jesúre sẽniĩañuju ĩ. To bajiro ĩ yiboajaquẽne, ĩre cʉdibesuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Paia ʉjarã, Dios ĩ rotimasire gotimasiorimasa bʉto rojose avasãgotiyiro ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","To bajiri, Jesús ĩ cʉdibeti ĩaboana, ĩre ajatud'iyujarã Herodes, ĩ surara quẽne. To yigajanocõari, quẽnariase sudiro Jesúre sãcõari, ĩre tʉocõañujarã, Pilato tʉjʉre quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tirʉ̃mʉne Herodes, Pilato rãca gãmerã oca quẽnoñujarã ĩna, gãmerã ĩateboariarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ĩ tʉjʉ Jesúre ĩ tʉocõajare, paia ʉjarãre, masa ʉjarãre to yicõari, masa to ñarãre quẽne jirẽoñuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ĩna ejaro, ado bajiro yiyuju ĩ: —“‘Ʉjʉ César ĩ rotisere cʉdibesa mʉa’ yigotimavisioami” yirã, jẽjʉ ãnire yʉ tʉjʉ ãmiejabʉ mʉa. To bajiro mʉa yise ñajare, mʉa ajiro ĩre quẽnaro sẽniĩaboabʉ yʉ. Yʉ ĩajama, ñie rojose yibecʉ ñaami. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes quẽne, “Ñie rojose yibecʉ ñaami” yigʉ ñari, yʉ tʉjʉ ĩre tʉocõañumi. “Ñie rojose ĩ yiro cõro ĩre sĩaña manoja”, yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","To bajiri ĩre bajegajanocõari, bucõarʉarãma yʉ surara —ĩnare yigotiboayuju Pilato, to rẽjariarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tocãrãca cʉ̃ma Pascua boserʉ̃mʉ jud'io masa ĩna quẽnojama, sĩgʉ̃, tubibe ecor'ire ĩna burotigʉre ĩnare bubosarũgũñuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","To bajiri, “Jesúre ĩre bucõarʉcʉja yʉ” ĩ yisere ajicõari, ado bajiro Pilatore avasãjedicõañujarã masa: —¡Bajibeticõato! ¡Barrabájʉare bucõari, Jesújʉare sĩarotiya mʉ! —yiavasã jedicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás vãme cʉtigʉ, “Gobierno ĩ rotiboasere cʉdibeticõari, mani masu rotirãsa” yitʉoĩacõari, ĩ babarã rãca masare sĩar'i ñañuju. To bajiro ĩ yire vaja tubiberiavijʉ ñañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","To ĩna yiro bero, quẽna ado bajiro gãme tudisẽniĩañuju Pilato. To bajiro ĩna yiavasã ñaboajaquẽne, Jesúre bucõarʉ, quẽna ĩ budirotire sẽniĩaboayuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","To bajiro ĩ yirone, —¡Yucʉ́tẽrojʉ ĩre jaju sĩaroticõaña mʉ! ¡Ĩre jajutuya! —ĩre yiavasã cʉdiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","To bajiro ĩna yirone, jẽre jʉaji ĩnare ĩ gotiboasere gotiboayuju ĩ quẽna: —¿Ñie rojose ĩ yire sʉori ĩre sĩarotigʉti yʉ? Ĩre quẽnaro sẽniĩamʉ yʉ. Yʉ ĩajama, ñie rojose yibecʉ ñaami. To bajiri, ĩre bajegajanocõari, bucõarʉarãma yʉ surara —ĩnare yigotiboayuju Pilato quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","To ĩ yiboajaquẽne, ĩna yiriarore bajiro, ĩre avasãtʉjabesujarã ĩna, Jesúre sĩarʉarã. To bajiro ĩna yiavasãcõa ñajare, ĩna rotirore bajiro cʉdigʉ, Barrabájʉare ĩre bucõañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","To yicõari, Jesújʉarema ĩ yarã surarare ĩsiñuju, “Yucʉ́tẽrojʉ ĩre jajusĩato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","To bajiri Jesúre ãmicoasujarã ĩna, ĩre sĩarã vana. Ĩre ãmivanane, sĩgʉ̃ Cirene vãme cʉti sitagʉ, Simón vãme cʉtigʉre bocayujarã. Ĩre bocacõari, —Jesús ĩ gaja vatijãire ĩre gajabosaya —ĩre yi vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jãjarã masa Jesúre sʉyayujarã ĩna. Rõmia quẽne, ĩre sʉyacõari, otiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","To bajiro ĩna otisere ajicõari, jʉdarʉ̃gʉ̃ñuju Jesús. Jʉdarʉ̃gʉ̃cõari, ado bajiro ĩnare gotiyuju ĩ: —Mʉa Jerusalén macana rõmiri, yʉre otibesa. Mʉa bajirotire, to yicõari, mʉa rĩa ĩna bajirotire tʉoĩacõari, otiya. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","No bojarirʉ̃mʉ ejarʉaroja bʉto rojose mʉa tãmʉorotirʉ̃mʉ. Tirʉ̃mʉre ado bajise tʉoĩarʉarãja mʉa: “Rĩa mana rõmiri rojose tãmʉorã ñaboarine, bʉto sʉtiritibetirʉarãma, ‘Bʉcʉrã rĩne bajirearʉarãja yʉa’ yitʉoĩarã ñari”. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","To bajiri, “Josari rojosere tãmʉorobe; rojose mani yise vaja rojose manire cõarʉcʉmi Dios” yirã, guaro bajireadarotire yirã, “Gʉ̃tayucʉri yʉare tãjoreadaya”, yitʉoĩarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yʉ yirore bajirone bajirʉarãja mʉa. Ado bajiro yʉ gotisere ajitʉoĩaña mʉa: “Ñie rojose yibecʉ ñaami” yʉre yirã ñaboarine, yʉre rojose yama ĩna. To bajiri, “Rojorã ñaama” mʉare yiĩarã ñari, rẽtobʉsaro mʉare rojose yirʉarãma ĩna —ĩnare yigotiyuju Jesús, ĩre otisʉyarãre. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","To bajiri gãjerã jʉarã rojose yiriarãre jua vasujarã, Jesúrãca, ĩnare sĩarʉarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ĩnare jua va, Rʉjoco Buro vãme cʉti burojʉ majaejayujarã. Tojʉ Jesúre, to yicõari, rojorãre quẽne, yucʉ́tẽrorijʉ jajutuyujarã ĩna. Sĩgʉ̃re Jesús riojojacatʉare, gãjirema ĩ gãcojacatʉajʉare jajutuyayujarã. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús ĩre ĩna jajuturo bero, ado bajiro Diore sẽniñuju ĩ: —Cacʉ, yʉre sĩarãre rojose ĩna yisere masirioya mʉ. “Rojose yirã yirãja yʉa” yimasimenane yama ĩna. To bajiro ĩ yiro bero, Jesús ye sudire bojarã, ado bajiro yiyujarã surara: “Ñimʉjʉa ĩ sudire ĩ ʉjaro ĩarãsa mani” yirã, gʉ̃tarine reacũĩa ajeñañujarã. To yiajecõari, ĩ sudire gãmerã ĩsibatoyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tire ĩacõari, Jesúre ajatud'iyujarã masa. Ĩna ʉjarã quẽne, ado bajiro Jesúre ajatud'iyujarã ĩna: —Gãjerãre rijaye cʉtirãre catiorũgũmi. To bajiri, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ ĩ ñajama, ĩ masune rujiadimasiato —yiajatud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Surara quẽne ĩre ajatud'iyujarã ĩna. Ĩ tʉjʉ ejacõari, ʉye oco jiasere Jesúre idirotiboayujarã. Ĩre idirotirãne, ado bajiro ĩre ajatud'iyujarã ĩna: —Mʉ jud'io masa ʉjʉ mʉ ñajama, mʉ masune rujiaya —ĩre yiajatud'iyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús ĩ jaju ecoritẽrojʉre ĩ rʉjoa vecare griego masa oca, romano masa oca, jud'io masa oca ĩna ucaturia jũro tuyayuju. Ado bajise yirijũro ñañuju ti: “Ãni ñaami jud'io masa ʉjʉ”, yiucare ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","To bajicõari, sĩgʉ̃ rojogʉ Jesúrãca yucʉ́tẽrojʉ jaju ecor'i ado bajiro ĩre tud'iyuju ĩ quẽne, Jesúre: —¿“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ me ñatique mʉ? Ĩ mʉ ñajama, rujiacõari, yʉare yirẽtobosaya —ĩre yitud'iyuju ĩ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","To bajiro ĩ yisere ajicõari, gãjijʉama, ado bajiro ĩre boca yiyuju ĩ: —Rojose mani yire sʉori manirema jajutuama ĩna. To bajiri, ¿Dios tʉjʉ ejacõari, rojose mʉ yise vaja rojose mʉre ĩ yirotire güibeatique mʉma? ");
INSERT INTO bsnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Manima, mani masu ye sʉorine bajiaja. To bajiboarine, ĩjʉama, ñie rojose yibecʉ ñaami —boca yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","To bajiro yigajanocõari, ado bajiro Jesújʉare gotiyuju ĩ: —Jesús, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, mʉre cõar'i Dios ĩ cũro bero, yʉre ĩamaicõari, rojose yʉ yise vaja rojose tãmʉotʉjabetiriarojʉ yʉ vaborotire yʉre yirẽtobosaba —Jesúre yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","To ĩ yisere ajicõari, —Yʉre quẽnaro ajiya mʉ. Adirʉ̃mʉne yʉre ajitirʉ̃nʉrã ĩna variquẽna tʉjabetojʉ yʉ rãca ñarʉcʉja mʉ —ĩre yicʉdiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Jesúre ĩna jajusĩariarʉ̃mʉne, ʉ̃mʉrecaji ñarone, rẽtiañuju yuja. Idia hora cõro rẽtiañañuju. Idia hora rẽtiatʉsatone, Diore yirʉ̃cʉbʉoriavijʉ sudigasero yotoriaro vorujijedicoasuju ti. Tiase yotoriaro, “‘Dios ĩ ñarisõa’ vãme cʉti sõare sãjamasibeama masa”, yimasiriaro ñaboayuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","To ti bajirone, —¡Cacʉ, yʉ ʉsʉre mʉ tʉjʉ cõaja yʉ! —Diore yiavasã, ʉsʉtadicoasuju ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","To bajiro ĩ bajijare, ado bajiro yiyuju surara ʉjʉ: —Riojone bajiboayuja. Ñie rojose yigʉ me ñamasiboayumi ãni —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","49","Jãjarã masa ñañujarã, Jesúre ĩna sĩarore ĩarã vadiriarã. Jesúre masirã quẽne, Galilea sitana rõmiri ĩre sʉyaboariarã quẽne, ĩre ĩna sĩasere sõjʉ ĩarʉ̃gõñujarã ĩna quẽne. Tire ĩagajanocõari, bʉto sʉtiritirãne tudijedicoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Arimatea macagʉ, José vãme cʉtigʉ ñañuju. Jud'io masa ʉjarã rãcagʉ, masa ĩna ĩarʉ̃cʉbʉogʉ, quẽnaro yigʉ ñañuju ĩ. To bajicõari, Diore quẽnaro ajirʉ̃cʉbʉogʉ, ĩ rotimasirere quẽnaro cʉdigʉ ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ʉjarã Jesúre ĩna sĩarʉasere bojabesuju ĩjʉama. “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, Jesúre yitʉoĩagʉ̃ ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesús rujʉrire ãmirʉ, Pilatore sẽnigʉ̃ vasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ĩre sẽnicõari, Jesús rujʉrire ãmirujiocõari, sudijãiri botirijãiri rãca ĩre gũmañuju. To yigajanocõari, masa yujeriavi gʉ̃tavi ĩna quẽnoriavijʉ ĩ rujʉrire cũñuju. Gãjerãre yujeĩaña manivi ñañuju ti vi. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tirʉ̃mʉjʉama jud'io masa ĩna ʉsʉsãjariarʉ̃mʉ rĩjoroagarʉ̃mʉ rãiorotirʉ̃mʉ rĩjoroaca ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jesúrãcana rõmiri, Galilea sitana vadimasiriarã rõmiri Jesúre ĩre yujeroanare ĩasʉyayujarã ĩna. Ĩnare sʉya, eja, ĩna yujerivire ĩacõari, Jesús rujʉrire ĩna cũrore ĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ĩagajanocõari, tudicoasujarã. Tudiejacõari, ĩna ñarivijʉ sʉtiquẽnasere rijariarã rãca cũrere quẽnoñujarã ĩna. To yigajanocõari, ʉsʉsãjariarʉ̃mʉ ti ejaro, Dios ĩ rotimasiriarore bajiro ʉsʉsãjañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gaje semana ĩna moasʉoriarʉ̃mʉ ti busumʉjado Jesús rujʉrire ĩna yujeriavire ĩarã vasujarã rõmia, sʉtiquẽnase ĩna quẽnorere, “Tuto mani” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ejacõari, ĩna ĩajama, gʉ̃ta tũnuobibeboaria mañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","To bajiri ti vi sãjacõari, ĩaboayujarã ĩna. Ĩ rujʉri mañuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","To bajiro ti bajiro ĩacõari, “¿No bajiro bajiyujari ti?” ĩna yitʉoĩarone, ĩna tʉre ángel mesa jʉarã ruyuarʉ̃gʉ̃cõañujarã ĩna. Bʉto yaase sudi sãñarã ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","To bajiro ĩna bajirone, bʉto güirãne, gʉsomuniari tuetucõari, mureacũcoasujarã ĩna. To ĩna bajirone, ado bajiro ĩnare gotiyujarã ĩna, ángel mesa: —¿No yirã rijariarã yujeriarojʉ Jesúre macati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maami adorema. Jẽre caticoami. Mʉa rãca Galileajʉ ñagʉ̃, ado bajiro mʉare ĩ goticatire tʉoĩaña mʉa: ");
INSERT INTO bsnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Dios ĩ roticõacacʉ, rojorãre ĩsiecorʉcʉja yʉ. Yʉre jajutu sĩarʉarãma ĩna. To bajiboarine yʉre ĩna sĩaro bero, idiarʉ̃mʉ tʉsatirʉ̃mʉne quẽna tudicaticoarʉcʉja yʉ”, mʉare yicami Jesús —ĩnare yigotiyujarã ĩna ángel mesa. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","10","To bajiro Jesús ĩnare ĩ gotirere tʉoĩabʉjacõari, tudicoasujarã ĩna. Tojʉ ñañujarã Jesús buerimasa jʉaãmo cõro, gʉbo, coja jẽnituarirãcʉ ñarã, gãjerã ĩ rãca ñarã quẽne ñañujarã ĩna. To bajiri ĩna tʉjʉre tudiejacoasujarã ĩna, rõmia. Ado bajiro vãme cʉtirã ñañujarã ĩna: Mar'ia Magdalena vãme cʉtigo ñañuju so. Bero Juana, bero gajeo Mar'ia, Santiago jaco ñañuju so. To yicõari, gãjerã quẽne ñañujarã ĩna. To bajiri Jesús buerimasa tʉjʉ ejacõari, jediro ĩnare bajirere gotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","To bajiro ĩnare ĩna gotiboajaquẽne, ĩnare ajitirʉ̃nʉbesujarã Jesús buerimasa. “Mecʉrã yama ĩna”, yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","To bajiboarine, Pedrojʉama, ĩna gotisere ajicõari, ũmacoasuju ĩ. Ũma vaejacõari, sojejʉ mubiar'i, ĩasõñuju ĩ. Jesúre ĩna gũmaboare rĩne ñañuju ti. Tire ĩacõari, “¿No bajiro bajicõari, bajiyujari ti?” yitʉoĩarejaigʉne, tudicoasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tirʉ̃mʉne Jesúrãca ñariarã jʉarã vasujarã ĩna, Emaús vãme cʉti macajʉ vana. Jerusalénjʉ ñacõari, Emaús vãme cʉti macajʉre varia maa, once kilómetros ñañuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","To vanane, Jesús ĩ bajirocarere gãmerã queti gotivasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","To bajiro ĩna yi vatone, ĩnare ẽmʉñuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ĩnare ĩ ẽmʉboajaquẽne, “Jesúne ñaami”, yimasibesujarã, Dios, ĩre ĩna ĩamasiborotire ĩnare ĩ masiriocõajare. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","To bajiri ĩ rãca vacõa ñañujarã ĩna. To bajivacʉne, —¿Ñie ũni quetire gãmerã gotiati mʉa? —Jesús ĩnare ĩ yisẽniĩarone, sʉtiritirãne, tujarʉ̃gʉ̃ñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","To bajicõari, sĩgʉ̃, Cleofas vãme cʉtigʉ ado bajiro Jesúre sẽniĩañuju ĩ: —¿Mʉma Jerusalénjʉre vacudigʉ ñaboarine, adirʉ̃mʉri bajiñasere masibeati mʉ? —Jesúre ĩre yisẽniĩañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yiyuju Jesús: —¿No bajiro bajise ũnire yigʉ yati mʉ? —ĩnare yisẽniĩañuju ĩ. To bajiro ĩ yisere ajicõari, ado bajiro Jesúre ĩre cʉdiyujarã ĩna: —Jesús, Nazaret macagʉre ĩna yimasisere yaja yʉa. Ĩma, Diore gotirẽtobosagʉ ñari, quẽnaro masare gotimasiocõari, ĩaĩañamanire yiĩogʉ̃ ĩ ñajare, Dios, to yicõari masa jediro, “Quẽnagʉ̃ ñaami”, ĩna yiĩagʉ̃ ñaboami. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","To bajiro yigʉ ĩ ñaboajaquẽne, paia ʉjarã, mani ʉjarã rãca ĩre sĩaroticõamasiñuma ĩna. Yucʉ́tẽrojʉ ĩre jajusĩarotimasiñuma. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Ĩma, Israel sitanare, quẽnaro yʉa ñarotire yiejarẽmorocʉ ñagʉ̃mi”, yitʉoĩamasiboabʉ yʉa. Ĩre ĩna sĩamasirirʉ̃mʉ rãca mani cõĩajama, idiarʉ̃mʉ tʉsatirʉ̃mʉ ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","24","“Ĩ rujʉrire bʉjabejʉ yʉa”, yima. “To yʉa ĩañarone, yʉare ruyuaĩoma ángel mesa. Yʉare ruyuaĩocõari, ‘Jẽre tudicaticoami Jesús’ ”, ĩnare yigotiyujarã ĩna. “To bajiro yima” ĩna yigotisere ajicõari, no yimasibetiboana, yʉa rãca ñarã, sĩgʉ̃ri ĩarã vasuma ĩna. Tojʉ vaejacõari, rõmia ĩna gotiriarore bajirone Jesús rujʉri ti manore ĩañujarã ĩna quẽne —Jesúre yigotiyujarã ĩna, Emaús vãme cʉti macajʉ vana. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yiyuju Jesús: —Tʉoĩamasimenare bajiro bajiaja mʉa. Diore gotirẽtobosarimasa ñamasiriarã “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ ĩ bajirotire ĩna ucamasire ti ñaboajaquẽne, “Riojo gotiriarãma”, yitʉoĩabeaja mʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ, ĩ rotiroto rĩjoro, rojose tãmʉorʉcʉmi”, yiucamasiñuma ĩna jediro —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","To yigajanocõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõarocʉ ĩ bajirotire Moisés ĩ ucamasirere, gãjerã ñajediro Diore gotirẽtobosamasiriarã ĩna ucamasirere quẽne ĩnare gotirẽtobuyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","To bajiro ĩnare goti vacʉ rĩne, ĩna vati macare ejacõari, ĩna tujaro ũnone Jesújʉama, rẽtoarocʉre bajiro bajiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","To ĩ bajiboajaquẽne, ĩre rẽtoarotibesujarã ĩna. —Vabesa mʉ. Adone yʉa rãca tujaya. Rãioato bajiaja —ĩre yiyujarã. To bajiro ĩre ĩna yijare, ĩna ya vijʉ ĩna rãca sãjasuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ĩna sãjaejacõari bero, ĩna rãca barujigʉne, pan ãmicõari, “Quẽnaja”, Diore yigotiyuju Jesús. To yigajanocõari, panre mʉtocõari, ĩnare ĩsibatoyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","To ĩ yirone, ĩre ĩna ĩamasirotire cõañuju Dios. Ĩre ĩna ĩamasirirĩmarone, yayicõa tʉjasuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","To ĩ bajirone, ado bajiro gãmerã yiyujarã ĩna: —Manire ẽmʉcõari, quẽnaro ĩ gotirũtu vadisere ajivariquẽnamʉ mani. To bajiri, “Jesúne ñaami”, yiĩamasiroti ñaboabʉ ti —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","To yiñarãne, Jerusalénjʉ tudicoasujarã ĩna, Jesús buerimasa, jʉaãmo cõro, gʉbo coja jẽnituarirãcʉ ñarã, to yicõari gãjerã ĩna rãcana quẽne ĩna ñarojʉ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","To bajiri, ĩna tudiejaro ĩacõari, ado bajiro ĩnare gotiyujarã ĩna: —Mani ʉjʉ tudicaticoasumi. Pedrore ruyuaĩoñuju ĩ —ĩnare yigotiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","To bajiro ĩna yigotigajanorone, Jesúrãca ĩna vare quetire, to yicõari, panre mʉtocõari, ĩnare ĩ ĩsibatorone, ĩre ĩna ĩamasirere ĩnare gotiyujarã ĩna, Emaús maca variarãjʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","To bajiro ĩna gotiñarone, ĩna vatoajʉ ruyuarʉ̃gʉ̃ñuju Jesús. Ruyuarʉ̃gʉ̃cõari, —¿Ñati mʉa? Quẽnaro ñaña mʉa —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","To bajiro ĩ yiejaro, ĩre ĩaʉcacõari, bʉto güiyujarã ĩna. “¡Bajirocar'i vãti ñaami!”, yitʉoĩagüiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","To ĩna yigüisere ĩacõari, ado bajiro ĩnare yiyuju Jesús: —¿No yirã yʉre ĩaʉcati? ¿No bajiro yirã, “Jesús me ñaami”, yitʉoĩati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yʉne ñaja. Yʉ ãmorire, yʉ gʉborire, ĩna jajumasise godore ĩaĩasaque mʉa. Yʉre moaĩaña mʉa. Bajirocar'i vãtima, gõa maami. Ri'i maami. Yʉma ri'i cʉtijedicõaja yʉ. Ĩaña mʉa —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","To bajiro ĩnare yigotigajanocõari, ĩ ãmorire, ĩ gʉborire quẽne ĩnare ĩoñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","To bajiro ĩnare ĩ yiboajaquẽne, “Ĩne ĩ ñajama, quẽnamasucõaboroja”, ĩre yitʉoĩacõa ñañujarã ĩna maji. To bajiro ĩre ĩna yitʉoĩacõa ñajare, ado bajiro ĩnare yiyuju ĩ: —¿Bare cʉoati mʉa? —ĩnare yisẽniñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","To bajiro ĩ yijare, vai sesoriajuria ĩre ĩsiñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ĩre ĩna ĩsirone, ĩna ĩaro rĩjorojʉa bayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tire bagajanocõari, ado bajiro ĩnare gotiyuju: —Yʉ bajirocaroto rĩjorojʉa yʉ bajirotire mʉare goticajʉ yʉ. Moisés ĩ ucamasire, to yicõari, Diore gotirẽtobosarimasa ñamasiriarã Salmo ĩna ucamasire quẽne yʉ bajirotirene yimasiñuma —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","To bajiro ĩnare yigoticõari, Dios oca masa ĩna ucamasirere ĩna ajimasirotire ĩnare ʉjoyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","To yigajanocõari, ado bajiro ĩnare gotimasioñuju ĩ: —Ado bajiro yʉ bajirotire gotiaja Dios oca masa ĩna ucamasire: “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ bajirocacoarʉcʉmi. Bajirocaboarine, ĩ bajirocaro bero, idiarʉ̃mʉ tʉsatirʉ̃mʉne tudicaticoarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ĩ tudicatiro bero, Jerusalén macanare gotimasiorʉarãma. Ĩnare ĩna gotimasioro bero, adi macarʉcʉro ñarã jedirore ado bajiro gotimasiorʉarãma: ‘Rojose mʉa yisere tʉoĩasʉtiriticõari, yitʉjaya mʉa. To bajiro mʉa yijama, rojose mʉa yise vaja mʉare Cristo ĩ vaja yibosare ñajare, rojose mʉa yisere masirio variquẽnarʉcʉmi Dios’ yigotimasiorʉarãma”, yigotiaja ti, Dios oca masa ĩna ucamasire. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mʉama, to bajiro yʉ bajisere ĩarã ñari, “Riojone ñaja. To bajirone bajicajʉ”, gãjerãre yigotimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dios ĩ yicatore bajirone mʉa rãca ñarocʉre Esp'iritu Santore mʉare cõarʉcʉja yʉ. To bajiri, adi macane Jerusalénne yuñarʉarãja mʉa maji. Esp'iritu Santo rujiejacõari, Dios ĩ masisere mʉare ʉjorʉcʉmi. To bajiro ĩ yiro bero, yʉ ocare goticudirã varʉarãja mʉa —ĩnare yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","To bajiro ĩnare ĩ yiro bero, Betania vãme cʉti maca tʉjʉ ĩ buerimasare ũmato vasuju ĩ. Tojʉ ejacõari, ĩ ãmori ñumʉori, —Quẽnaro mʉare yato Dios —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","To bajiro ĩnare ĩ yiñarone, ĩ ñarojʉ ĩre ãmimʉjacoasuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dios ĩre ĩ ãmimʉjatone, muqueacõari, Jesúre rʉ̃cʉbʉoyujarã ĩna. To yigajanocõari, Jerusalénjʉ quẽnaro variquẽnarã tudicoasujarã ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tudiejacõari, tocãrãcarʉ̃mʉri Diore yirʉ̃cʉbʉoriavijʉ sãjacõari, “Quẽnaro yaja mʉ”, ĩre yivariquẽnarũgũñujarã ĩna. To cõro ñaja.");
INSERT INTO bsnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dios macʉ Jesucristo sʉorine Diore masiama masa. Rẽmojʉne jẽre ñie manojʉrene ñacõamasiñuju Jesús, ĩ jacʉ rãcane. Jesúne, Dios ñacoadimasiñuju. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Macarʉcʉro, õ vecayere quẽne, tire Dios ĩ rujeoroto rĩjorojʉ jẽre ĩ rãcane ñacõamasiñuju ĩ macʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Macarʉcʉrore, õ vecayere quẽne ñajediro ĩ macʉ sʉorine tire rujeomasiñuju Dios. Ĩ macʉ ĩ manone Dios ĩ rujeoroti maniboriaroja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mani rijato berojʉma, “Tudirijabeticõato” yigʉ, Dios ĩ catisere ĩsigʉ̃, ñacoadimasiñuju Dios macʉ. Ĩ jacʉ ĩ catisere ĩ macʉ ĩ ĩsise sʉorine Diorãca quẽnaro ñaama masa, ĩre masirã yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Diore ajimenajʉama, rojose yirã ñari, “Riojo ñamasusere masiaja yʉama”, yitʉoĩaboarãma. To bajiro yirã ñaboarine, “Diorãca quẽnaro ñato” yigʉ, Jesucristo ĩ ĩsisere masa jediro ĩna ajibetirotire yirã, yimasimenama Diore ajiterã. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Sĩgʉ̃ ñacami Juan vãme cʉtigʉ. Masare, “Rojose yirʉabeaja yʉa. Ĩ sʉorine Diorãca quẽnaro ñaja yʉa” yirãre oco rãca ĩnare bautizagʉ ñacami. Ĩre goti rĩjoro cʉtirotiyumi Dios, ĩ macʉ ĩ bajiroti quetire. Ĩ bajiroti quetire ajicõari, “To bajiro masu bajigʉ ñagʉ̃mi” ĩ macʉre masa jediro ĩna yitʉoĩarotire bojagʉ ñari, to bajiro ĩre goti rĩjoro cʉtirotiyumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","9","Riojo ñamasuse Juan ĩ gotimasiocatima ĩ masune tʉoĩaquẽnocõari, ĩ goticati me ñacajʉ ti. Dios macʉ adi macarʉcʉrojʉre ejacacʉ yejʉa ñacajʉ ti, riojo ñamasuse Juan ĩ gotimasiocati. “Rojose mani tãmʉoborotire manire yirẽtobosarocʉ ñaami” Dios macʉre masa ĩna yitʉoĩarotire yigʉ, ĩre goti rĩjoro cʉtirimasʉ ñacami Juanma. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jesúma, adi macarʉcʉrojʉre manire bajiro rujʉ cʉticõari ĩ ruyuaroto rĩjorojʉne jẽre ñacõañuju ĩ. Ĩ sʉorine adi macarʉcʉrore Dios ĩ rujeomasire ti ñaboajaquẽne, ĩre ĩacõari, “Ãni, Dios macʉ ñaami”, ĩre yimasibeticama ĩna, adi macarʉcʉroana masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jud'io masa, “Yʉ rĩa ñaja mʉa” Dios ĩ yigoticũboariarã tʉjʉ manire bajiro rujʉ cʉticõari, ĩna rãca ĩ ñarũgũboajaquẽne, ĩre ĩatecama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ĩre ĩna ĩateboajaquẽne, sĩgʉ̃ri ĩre yʉa ajitirʉ̃nʉjare, “Yʉ rĩa ñaja mʉa”, yʉare yiĩañumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","“Jud'io masa ñari, Dios rĩa ñaja yʉa”, yimasiña manoja. Gãjerã masa quẽne, to bajiro yimasibeama. To yicõari, “Mani masune mani tʉoĩase sʉorine Dios rĩa ñaja mani”, yimasiña manoja. Ado bajirojʉa bajiaja: “‘Yʉ rĩa ñaja mʉa’ ĩ yiĩamaijare, ĩ rĩa ñacoajʉ”, yirejʉa ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dios macʉ manire bajiro rujʉ cʉticõari, yʉa rãca bajiñarũgũcami. Yʉare ĩamaicõari, quẽnaro yirũgũcami. To yicõari, Dios yere gotigʉ, riojo gotimasiorũgũcami. “Ĩ ñacami Dios macʉ. Sĩgʉ̃ne ñagʉ̃, ĩ jacʉre bajiro ñamasugʉ̃ ñacami”, ĩre yimasiaja yʉa, ĩre ĩacana. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ĩrene goticami Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ. Jesús ĩ ejarone, ado bajiro masare goticami: —Ãnine ñaami mʉare yʉ goti rĩjoro cʉtigʉma. Ĩ bajirotire gotigʉ, ado bajiro mʉare yigotiadicajʉ yʉ: “Yʉ bero sĩgʉ̃ ejarʉcʉmi. Yʉ rĩjorojʉne jẽre ñacõañumi. To bajigʉ ĩ ñajare, yʉ rẽtoro ñamasugʉ̃ ñaami ĩma” mʉare yigotiadicajʉ yʉ —yicami Juan, Jesús ĩ bajirotire gotigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Masare maimasucõagʉ̃ ñari, mani ñajedirorene quẽnaro manire yirũgũami Dios macʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés ñamasir'i sʉorine masare Dios ĩ rotimasirere masire ñaja. Jesucristo sʉorine Dios manire ĩ maisejʉarema masire ñaja. Ĩ ocare quẽne, riojo ñamasusere, Jesucristo sʉorine tire masire ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nijʉane Diore ĩre ĩagʉ̃ magʉ̃mi. To bajiboarine ĩ macʉ sĩgʉ̃ne ñagʉ̃, ĩ jacʉ rãcagʉ ñari, ĩ jacʉre bajirone tʉoĩagʉ̃ ñari, ĩ jacʉ ĩ bajisere riojo manire gotimasiocami. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","To bajiri paiare, ĩnare ejarẽmorãre quẽne cõañuma ĩna ʉjarã, Jerusalén macana. “‘¿Ñimʉ ñati mʉ?’ masare oco rãca bautizagʉre Juanre ĩre yisẽniĩama” yirã, ĩnare cõañuma. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","To bajiro ĩre ĩna yisẽniĩasere ajicõari, ado bajiro ĩnare yicʉdicami Juan: —Yʉma, masa rojose ĩna tãmʉoborotire ĩnare yirẽtobosacõari, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃ me ñaja yʉ —ĩnare yicami Juan. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","To bajiro ĩ yirone, ĩre sẽniĩaquẽnocama ĩna: —¿Ñimʉ ũgʉ̃jʉa ñatique mʉ, to yijama? ¿El'ias, Diore gotirẽtobosamasir'i, gãme tudicaticõari, bajiatique mʉ? —ĩre yisẽniĩacama. —Ĩ me ñaja yʉ —yicõacami quẽna. To bajiro ĩ yirone, ĩre sẽniĩacama quẽna: —¿Mʉne ñatique Diore ĩre gotirẽtobosarimasʉ, “Ejarʉcʉmi” ĩna yigʉ? —Juanre yisẽniĩacama. —Ĩ me ñaja yʉ —yicõacami quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","To bajiro ĩ yise ñajare: —¿Ñimʉ ũgʉ̃jʉa ñati mʉ? —ĩre yicama ĩna. —Yʉare sẽniĩaroticõarãre, “Ĩ ñaami”, ĩnare yigotirʉaja yʉa. ¿Ñimʉ ũgʉ̃ ñaja yʉ, yatique mʉ, mʉ masune mʉ yijama? —ĩre yisẽniĩacama quẽna, Juanre, masare oco rãca bautizagʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yicʉdicami: —Yʉne ñaja, yucʉ́ manojʉ masare gotimasiocudirũgũgʉ̃ma. Ado bajiro yigotirũgũaja yʉ: “Mani ʉjʉ ejarʉcʉmi. To bajiri rojose mʉa yisere yitʉjacõari quẽnasejʉare tʉoĩavasoaya, ĩre yurã”, yirũgũaja yʉ. To bajiro yʉ yigotirotire jẽre tirʉ̃mʉjʉne, “To bajiro yirʉcʉmi ĩ”, yiuca rĩjoro cʉticõamasiñumi Diore ĩre gotirẽtobosarimasʉ, Isa'ias ñamasir'i —yicʉdicami Juan, ĩre sẽniĩarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseo masa ĩna cõariarã ñacama ĩna, Juanre sẽniĩacana. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Quẽna ĩre sẽniĩacama ĩna: —To bajise yigʉ ñaboarine, Cristo me ñaboarine, El'ias ñamasir'i me ñaboarine, Diore gotirẽtobosarimasʉ “Ejarʉcʉmi” ĩna yigʉ me ñaboarine, ¿no yigʉ oco rãca masare bautizatique mʉ? —Juanre yisẽniĩacama. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","To bajiro ĩna yisere ajicõari ado bajiro ĩnare yicʉdicami: —Yʉma, masa rojose ĩna yisere yitʉjacõari, Dios ĩ bojasejʉare yirãre oco rãca ĩnare bautizagʉ ñaja yʉ. To bajiboarine mani ñarigodojʉ jẽre ñagʉ̃mi, “To ñagʉ̃mi” mʉa yimasibecʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yʉ bero masare gotigʉ ñaboarine, yʉ rẽtoro ñamasugʉ̃ ñagʉ̃mi ĩma. Ñamasurã rĩne ĩre yibosamasiama, ñamasugʉ̃ masu ĩ ñajare —ĩnare yicʉdicami Juan. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","To bajiri, adi ñajediro bajicajʉ Betania vãme cʉti macajʉ. Ti maca ñacajʉ Juan, masare oco rãca ĩ bautizacatiya Jordán vãme cʉtirisa gajejacatʉajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gajerʉ̃mʉ, yʉa tʉjʉ Jesús ĩ vadone ĩre ĩacami Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ. Ĩre ĩacõari ado bajiro masare yigoticami: —Ĩaña mʉa yuja. Ĩne ñaami Dios yʉ, oveja macʉre bajiro masare rijabosarocʉ. No bojarãre “Rojose yʉ yise vaja yʉre rijabosayumi” ĩre yironare rojose ĩna yise vaja ĩnare rijabosarocʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ĩ yirotirene goti rĩjoro cʉtigʉ ado bajiro mʉare yigoticajʉ yʉ: “Masa ĩna ĩaro rĩjorojʉa yʉ gotimasioro bero gotimasiorʉcʉmi gãji” mʉare yicajʉ yʉ. “Yʉ rĩjorojʉne jẽre ñacoayumi ĩma. To bajiri yʉ rẽtoro ñamasugʉ̃ ñaami” mʉare yicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉ quẽne, “Ĩ ñagʉ̃mi” yimasibeticajʉ yʉ maji. To bajiboarine, “Ĩne ñagʉ̃mi ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i” mani yiĩamasirotire bojagʉ ñari, oco rãca masare bautizadicajʉ yʉ —yʉare yicami Juan. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Quẽna gajeye ado bajiro yʉare yigoticami: —Ĩre ĩaboarine, “Ĩne ñagʉ̃mi ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i”, yimasibeticajʉ yʉ maji. To bajiboarine Dios ado bajiro yʉre yi ocaruyucami ĩ, “Masare oco rãca bautizarʉcʉja mʉ” yʉre yi ocaruyucõari: “Yʉ cõagʉ̃, Esp'iritu Santo, bujare bajigʉ rujiadicõari, ĩ joere rocajeorʉcʉmi. Ĩne ñarʉcʉmi, ‘Rojose ĩna yisere quẽnaro masicõari, tʉoĩavasoatĩmato ĩna’ yigʉ, Esp'iritu Santore cõarocʉ”, yʉre yi ocaruyucami Dios. To bajiro yʉre ĩ yicatore bajirone ĩamʉ yʉ yuja. To bajiri, “Dios macʉ ñaami”, yimasiaja yʉ yuja —yigoticami Juan, yʉare gotigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Gajerʉ̃mʉ oco rãca masare ĩ bautizacatojʉ ñacami Juan quẽna. Ĩ rãca ñacajʉ yʉa, jʉarã, ĩ buerã. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","To yʉa ñaro, Jesús ĩ rẽtoato ĩre ĩacõari, ado bajiro yʉare goticami Juan: —Ĩaña. Ĩne ñaami Dios yʉ, oveja macʉre bajiro masare rijabosarocʉ —yʉare yicami Juan. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","To bajiro Juan ĩ yisere ajicõari, Jesúre ĩre sʉyacajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","To ĩre yʉa sʉyatone, jʉdarʉ̃gʉ̃ ĩacõari, —¿Ñiere bojarã bajiati mʉa? —yʉare yisẽniĩacami. To bajiro ĩ yisẽniĩarone: —Gotimasiorimasʉ, ¿nojʉ ñari mʉ ñaro? —ĩre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","To bajiro ĩre yʉa yirone, —Ĩarã vayá —yʉare yicʉdicami. To bajiro ĩ yijare, ĩre sʉyaejacoacajʉ yʉa, ĩ ñarojʉre. Muiju ĩ rocasãroto rĩjoro ejacajʉ yʉa, tojʉre. To bajiri ĩ rãca bajiña, tojʉne cãnicoacajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan vãme cʉtigʉ, masare oco rãca bautizarimasʉ ĩ gotisere ajicõari, yʉ rãca Jesúre ĩre sʉyacacʉ ñacami Andrés. Simón Pedro vãme cʉtigʉ bedi ñacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesúre ĩre ĩamasicõari, guaro ĩ gagʉ Simónre ĩre jigʉ vacoacami. Ĩre bʉjacõari ado bajiro ĩre gotiyuju: —“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõagʉ̃, Cristo mani yitʉoĩayuñarũgũgʉ̃re ĩamʉ yʉ yuja —ĩre yiyuju Andrés. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","To bajiro ĩre yi, yʉa cʉtojʉa ĩre jicoayumi Andrés. Simónre ĩre ĩacõari, ado bajiro ĩre yicami Jesús: —Simón ñaja mʉ, Jonás macʉ. To bajiboarine Pedro vãme cʉtirʉcʉja mʉ yuja —Simónre ĩre yicami Jesús. (Gʉ̃ta yire ũni ñaja ti, “Pedro” yire.) ");
INSERT INTO bsnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gajerʉ̃mʉ Galilea vãme cʉti sitajʉare yʉare ũmato vacami Jesús. To bajiri tojʉre ejacõari, Felipe vãme cʉtigʉre ĩre bʉjacami yuja. Ĩre bʉjacõari, ado bajiro ĩre yicami Jesús: —Yʉ rãca vayá. Yʉre ajitirʉ̃nʉ sʉyaya mʉ —ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida vãme cʉti macagʉ ñacami Felipe. Ti macanane ñacama Pedro, ĩ bedi Andrés quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesúre ĩamasicõari, Natanael vãme cʉtigʉre ĩre gotigʉ vacoacami Felipe. Ĩre bʉjacõari, ado bajiro ĩre gotiyuju ĩ: —“Bajirʉcʉmi” Moisés ñamasir'i ĩ yiucamasir'ire ĩamʉ yʉ yuja. Diore ĩre gotirẽtobosarimasa quẽne, “To bajirʉcʉmi” ĩna yiucamasir'ire ĩamʉ yʉ yuja. Ĩ ñaami Nazaret vãme cʉti macagʉ, Jesús vãme cʉtigʉ, José vãme cʉtigʉ macʉ —Natanaelre ĩre yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","To bajiro ĩ yirone, —¿Ĩma Nazaret vãme cʉti macagʉ ñaboarine, quẽnagʉ̃ ñaguĩda? —Felipere ĩre yisẽniĩañuju Natanael. —Vayá. Ĩre ĩaĩatoque mani —ĩre yiyuju Felipejʉama. To bajise gãmerã yicõari, yʉa tʉjʉ vadicoayuma ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael ĩ vadore ĩacõari ado bajiro yicami Jesús: —Õ tʉsagʉ, Israel ñamasir'i jãnami Dios ĩ bojasere yigʉ vadiami. Masare yitogʉ me ñaami —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","To bajiro ĩ yirone, —¿No bajiro yicõari yʉre ĩamasiati mʉ? —ĩre yicami Natanael. To bajiro ĩ yirone, —Felipe mʉre ĩ jiroto rĩjorojʉne higuera vãme cʉtiʉ ẽñeroca mʉ ñarojʉne jẽre mʉre ĩacõamʉ yʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","To bajiro ĩ yisere ajicõari: —Gotimasiorimasʉ, Dios macʉ ñaja mʉ, yʉare Israel ñamasir'i jãnerabatiare rotimʉorʉ̃gõrocʉ —ĩre yicami Natanael. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","To bajiro ĩ yisere ajicõari ado bajiro ĩre yicʉdicami Jesús: —“¿Higuera vãme cʉtiʉ ẽñeroca mʉ ñarojʉne jẽre mʉre ĩacõamʉ yʉ” mʉre yʉ yiserene ajicõari, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, yʉre yimasiati mʉ? Adi rẽtoro ĩaĩañamanire mʉre yiĩorʉcʉja yʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gajeye quẽna ado bajiro yʉare yicami Jesús: —Ñamasusere riojo mʉare gotiaja yʉ: Ʉ̃mʉagasero soje ti jãnarone, yʉ, Dios ĩ roticõacacʉre, to yicõari, Diore moabosarãre ĩna mʉjatore, ĩna rujiadore quẽne ĩarʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jʉarʉ̃mʉ bero, Galilea sita Caná vãme cʉti macajʉre sĩgʉ̃ ĩ manajo cʉtirʉ̃mʉ boserʉ̃mʉ ñasʉocajʉ ti. Jesús jaco quẽne ñacamo so, tojʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesúre, to yicõari, yʉa ĩ buerãre quẽne, yʉare jicama ĩna. To bajiro ĩna yicana ñari, yʉa quẽne Jesúrãca ñacajʉ tojʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yʉa idiñaro rĩne ʉye oco jedicoacajʉ. To ti bajirone, ado bajiro Jesúre yicamo ĩ jaco: —Ʉye oco jedicoajʉ yuja —ĩre yicamo. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","To so yirone, —¿Caco, no yigo tire yʉre gotiati mʉ? Maji, ĩaĩañamani Dios ĩ masise rãca yʉ yiĩoroti ejabeaja maji —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","To bajiro ĩ yisere ajicõari ado bajiro ĩnare yicamo so, ʉye oco iorimasare: —Ĩ rotirore bajiro yiya —ĩnare yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tore ñacajʉ oco varia sotʉri, gʉ̃tane ĩna vearia sotʉri. Cojomo cõro, coja jẽnituaro ñari sotʉri ñacajʉ ti. “Ado bajiro mani yijare, ‘Rojose mana ñaja mʉa’ manire yiĩaami Dios” yirã ĩna coeri sotʉri, oco sotʉri ñacajʉ ti. Ti sotʉri cincuenta, to yicõari, setenta litros cõro juari sotʉri ñacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","To bajiri ado bajiro ʉye oco iorimasare ĩnare yicami Jesús: —Oco jiojʉ̃mʉoña adi sotʉrire —ĩnare yicami. To bajiro ĩ yisere ajicõari, ti sotʉri ñaro cõrone jiojʉ̃mʉocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ĩna jiojʉ̃mʉogajanoro ĩacõari, ado bajiro ĩnare yicami Jesús: —Boserʉ̃mʉ ũmato yirimasʉre mojoroaca vaãmi vati, ĩre ioaya —ĩnare yicami Jesús. Ĩnare ĩ yirotirore bajirone iocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tire ĩ idiroto rĩjorojʉne oco jẽre ʉye oco godovedicoasuja ti, ti sotʉ ñaro cõrone. “Toaye ʉye oco ñaroja”, yimasibeticami. Tire iorimasa rĩne masicama ĩna. Tire idicõari, mame manajo cʉtirocʉre jicami boserʉ̃mʉ ũmato yirimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ĩ ejarone, ado bajiro ĩre yicami: —Gãjerãma, ĩna boserʉ̃mʉ yisʉo vajama, quẽnasejʉare iosʉocama. Jairo masa ĩna idiro berojʉ, quẽnabetibʉsare iocama ĩna yuja. Mʉma quẽnasejʉare rʉayuja mʉ, yucʉaca ĩna ioserema —ĩre yicami boserʉ̃mʉ ũmato yirimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","To bajiro Jesús ĩ yicati, ĩaĩañamanire Dios ĩ masise rãca ĩ yiĩosʉocati ñacajʉ ti Galilea sita, Caná vãme cʉti macajʉre. Ĩaĩañamanire ĩ yiĩojama, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõacacʉ ñaja yʉ” yigʉ yiĩosʉocami. To bajiro ĩ yiĩosere ĩacõari, bʉtobʉsa ĩre ajitirʉ̃nʉcajʉ yʉa, ĩ buerã. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Boserʉ̃mʉ ti jediro bero, Capernaum vãme cʉti macajʉ ũmato vacami Jesús. Ĩ jaco, ĩ bederã, to yicõari yʉa ĩ buerã quẽne, ĩ rãca vacajʉ yʉa. Yoarobʉsa ñacajʉ yʉa, ti macajʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yʉa jud'io masa Pascua boserʉ̃mʉ yʉa yirotirʉ̃mʉri cõñaro Jerusalénjʉ ejacajʉ yʉa, Jesúrãca. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tojʉ Diore yirʉ̃cʉbʉoriavijʉ ta vecʉa ĩsirimasa, oveja ĩsirimasa, buja ĩsirimasa quẽne ñacama. Gãjerã ye rãca gãjoa vasoarimasa quẽne ĩna rujiri cũmurorijʉ rujicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","To bajiro ĩna yiñasere ĩacõari bajeriamare quẽnocami Jesús. To bajiro yicõari ĩna yarã ta vecʉare, ovejare Diore yirʉ̃cʉbʉoriavijʉ ñarãre ĩnare bajeãgõbucami. Gãjoa vasoarimasa ye gãjoatiirire varebatereacõacami. To yicõari ĩna gãjoa jeorijaʉrire tucaguereacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","To yicõari, buja ĩsirimasare ado bajiro yicami yuja: —Ãnoa mʉa ĩsironare juabudi vasa mʉa. Yʉ jacʉ ya vire gajeyeũni ĩsiriavi godoveobesa mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","To bajiro ĩ yisere ajicõari, Dios oca masa ĩna ucamasirere ado bajiro tʉoĩabʉjacajʉ yʉa, ĩ buerã: “Mʉ ya vire quẽnaro ĩna yirʉ̃cʉbʉobetijare, ĩnare ĩajũnisinirʉcʉja yʉ. To bajiro yʉ yise ñajare yʉre sĩarocarʉarãma ĩna”, yirere tʉoĩabʉjacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","To ĩ yirone, to ñacana jud'io masa Jesúre ĩre sẽniĩacama: —“Dios ĩ masise rãca yigʉ yaja yʉ” mʉ yijama, ¿no bajiro yʉare yiĩogʉada mʉ? —ĩre yisẽniĩacama ĩna, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","To bajiro ĩna yisere ajicõari ado bajiro ĩnare yicʉdicami Jesús: —Adi vi Diore yirʉ̃cʉbʉoriavire mʉa caguerocacõajama, idiarʉ̃mʉ tʉsatirʉ̃mʉne quẽna ti vire bʉajeocõarʉcʉja yʉ —ĩnare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","To bajiro ĩ yisere ajicõari, —Cuarenta y seis ñaricʉ̃mari josayujarã ĩna, adi vire bʉañarã. ¿Mʉma, “Idiarʉ̃mʉ berone quẽna bʉajeocõarʉcʉja”, yiboati mʉ? —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús to bajiro Diore yirʉ̃cʉbʉoriavire ĩ yijama, ĩ masu rujʉrene yigʉ yicõañumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ĩ bajirocaro bero gãme ĩ tudicatiato, “To bajiro bajirʉaroja” ĩ yigoticatire tʉoĩabʉjacajʉ yʉa, ĩ buecana. Tire tʉoĩabʉjacõari, Dios ocare masa ĩna ucamasirere, Jesús ĩ goticatire quẽne ajitirʉ̃nʉcajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalénjʉ Pascua boserʉ̃mʉ ĩna yiñaro, quẽna gajeye ĩaĩañamanire masare yiĩocami Jesús. To bajiro ĩ yiĩojare, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i mani ʉjʉ ñaami”, ĩre yiajitirʉ̃nʉcama jãjarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Jesújʉama to bajiro ĩna yiajitirʉ̃nʉsere ĩamasicõari, “Socarã mene yama”, yibeticõacami, masa jediro ĩna tʉoĩasere ĩamasigʉ̃ ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sĩgʉ̃ fariseo masʉ, Nicodemo vãme cʉtigʉ ñacami. Jud'io masa vatoajʉre ñamasugʉ̃ ñacami ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ñamijʉ Jesúre ĩre ĩagʉ̃ ejayuju. Ĩ tʉjʉre ejacõari, ado bajiro Jesúre ĩre yiyuju: —Gotimasiorimasʉ, “Mʉre cũñumi Dios, ‘Masare gotimasioato’ yigʉ”, mʉre yimasiaja yʉa. Sĩgʉ̃ mʉ yirore bajirone yiĩoñamanire yigʉre ĩabeticajʉ. To bajiri, “Diorãca ñacõari, yami”, yimasiaja yʉa —Jesúre ĩre yiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","To bajiro ĩ yisere ajicõari, ado bajiro Nicodemore gotiyuju Jesús: —Riojo mʉre gotiaja yʉ. No bojarã, quẽna gãme ruyuamenama, Dios ĩ ñarojʉre ejamasimenama —Nicodemore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","To bajiro ĩ yijare, ado bajiro Jesúre sẽniĩañuju Nicodemo: —¿No bajiro bʉcʉ ñacoaboarine, quẽna gãme tudiruyuacoare ñarojari? ¿Quẽna ĩ jacore sãjacoacʉjarique ĩ, quẽna gãme tudiruyuarʉ? —Jesúre ĩre yiyuju Nicodemo. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —“Quẽna gãme ruyuaroti ñaja” yʉ yijama, masa sʉorine gãme ruyuarotire yigʉ me yaja. “Quẽna gãme ruyuaroti ñaja” yʉ yijama, “‘Dios ĩ cõagʉ̃, Esp'iritu Santo ĩ ejarẽmose rãca Diorãca quẽnaro ñacõari, ĩ bojarore bajiro yirã ñato’ yigʉ, ĩ yirotire sẽniroti ñaja”, yigʉjʉa yaja. “Dios ĩ bojabeti yirʉabeaja yʉ. Ĩ sʉorine ĩ rãca quẽnaro ñaja yʉ” yirã, oco rãca bautizarotiriarã, to yicõari, Esp'iritu Santo ĩ ejarẽmose rãca Diorãca quẽnaro ñarã, ĩna rĩne ñarãma Dios ĩ ñarojʉre ejacõari, ĩ rãca ñamʉorʉ̃gõrona. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Dios ĩ cõagʉ̃, Esp'iritu Santo ĩ ejarẽmose rãca Diorãca quẽnaro ñarã, ĩna rĩne Dios ĩ ñarojʉre ejacõari, ĩ rãca ñamʉorʉ̃gõrʉarãma” mʉre yʉ yisere, ajiyamanire bajiro ajimavisiabesa mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mino no ti bojarone vẽatucõaroja ti. Mino ti vẽatujama, ajiaja mani. To bajiboarine, “Toaye vadoja. Tojʉare vatoja”, yimasibeaja mani. Tire bajirone bajigʉ ñaami Dios ĩ cõagʉ̃, Esp'iritu Santo. “Esp'iritu Santo ĩ ejarẽmose rãca quẽnaro ñacõari, ĩ bojarore bajiro yigʉ ñato” yigʉ, gãjire ĩ yirotire masibeama masa —Nicodemore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","To bajiro ĩ yirone, quẽna gãme sẽniĩaquẽnoñuju Nicodemo: —¿No bajiro bajiroada ti? —Jesúre ĩre yisẽniĩa quẽnoñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ado bajiro ĩre cʉdiyuju Jesús: —¿Israelita masare ĩnare gotimasiogʉ̃ ñaboarine, adi quetirema masibeati mʉ? ");
INSERT INTO bsnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Riojo mʉre gotiaja yʉ. Mani ĩase, Dios ĩ yiserene, mʉare gotirũgũaja yʉa. To bajiboarine yʉa gotirũgũsere ajicõari, “To bajiro me bajiaja”, yicõarũgũaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Adi macarʉcʉroayere yʉ gotisere ajitegʉ ñari, Dios ĩ bajisere ĩabʉjayamanire yʉ gotijaquẽne, ajiterʉcʉja mʉ —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gajeye quẽna ado bajiro ĩre gotiyuju Jesús: —Sĩgʉ̃, Dios ĩ ñarojʉre mʉjar'i maami. Yʉ sĩgʉ̃ne ñaja yʉ, Dios ĩ ñarojʉne rujiadicõari, tudi gãme mʉjarocʉma. Dios ĩ roticõacacʉ ñaja yʉ Diorãcagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tirʉ̃mʉjʉ Moisés ñamasir'i, yucʉ́ manojʉ ñacudigʉ yucʉ́ joejʉ ãñare bajigʉ ñagʉ̃re cõmene quẽnor'ire ĩre jeomasiñuju, “Ãña cũniecoriarã ĩre ĩamʉoato ĩna” yigʉ. To bajiro ĩ yir'ire ãña cũniecoriarã, ĩre ĩamʉorãjʉa, caticoamasiñujarã ĩna quẽna. To bajiro bajirʉaroja yʉre quẽne, Dios ĩ roticõacacʉre quẽne. Yucʉ́tẽrojʉ yʉre jajutucõari, vʉ̃mʉorʉ̃gõrʉarãma ĩna, yʉ bajirocarotire yirã. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","To bajise bajirocʉ ñari, no bojarã, “Jesucristo ĩ bajirocare sʉorine yʉre ĩavariquẽnacõari quẽnaro yirʉcʉmi Dios” yitʉoĩarãre ĩna rijato berojʉ “Tudirijabeticõato” yigʉ, yʉ catisere ĩnare ĩsirʉcʉja yʉ —Nicodemore ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Ñajediro masare maimasucõagʉ̃ ñari, ĩ macʉ sĩgʉ̃ne ñagʉ̃re ĩre cõañumi Dios, “Masare rijabosato” yigʉ. To bajiro ĩ yire ñajare, “Jesucristo ĩ bajirocare sʉorine yʉre ĩavariquẽnacõari, quẽnaro yirʉcʉmi Dios” yitʉoĩarãma, ĩna rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere ĩ ĩsiriarã ñarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Adi macarʉcʉroanare, “Rojose ĩna yise vaja rojose ĩnare yato” yigʉ me, ĩ macʉre cõañumi Dios. Ado bajirojʉa yiyumi. “Mʉre ajitirʉ̃nʉrona ĩna rijato berojʉ, rojose tãmʉotʉjabetiriarojʉ ĩna vaborotire ĩnare yirẽtobosarʉcʉja mʉ” yigʉ, ĩ macʉre cõañumi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Dios macʉ ñagʉ̃mi” Jesúre yitʉoĩagʉ̃re rojose tãmʉotʉjabetiriarojʉre ĩre cõabetirʉcʉmi Dios. Dios macʉ sĩgʉ̃ne ñagʉ̃re, “Dios macʉ me ñagʉ̃mi” ĩre yigʉjʉarema, to bajiro ĩre ĩ yise vaja rojose tãmʉotʉjabetiriarojʉ ĩre cõarʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ĩ macʉre adi macarʉcʉrojʉre ejacacʉre ĩre ajitirʉ̃nʉmenare rojose tãmʉotʉjabetiriarojʉ ĩnare rearʉcʉmi. Ĩ macʉ sʉorine Diorãca quẽnaro ñaama masa, ĩre masirã. Masajʉama rojose yitʉjarʉamena ñarã ñari, quẽnasejʉare tʉoĩavasoarʉamenama ĩna. To bajiri Dios macʉre ajitirʉ̃nʉmenama. To bajiro yirã ĩna ñajare, ĩnare rearʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Rojose yirã, Dios macʉre terãma ĩna. “Masa rĩjorojʉa, ‘To bajise rojose yicajʉ mʉ’ yʉre yiromi Jesús” yibojonerã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dios ĩ bojasere quẽnasejʉare yirãma, Dios macʉre ajitirʉ̃nʉrãma ĩna. Yayiorojʉ yirudibeama ĩnajʉama, “‘Dios ĩnare ĩ yirẽmojare, quẽnasejʉare yirũgũama’ yimasiato ĩna” yirã. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nicodemore Jesús ĩ gotiro bero, vacoacajʉ yʉa, Judea sitajʉ. Tojʉre yoarobʉsa ñacajʉ yʉa. Tojʉ masare oco rãca bautiza ñarũgũcajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan, oco rãca bautizarimasʉ, Salim vãme cʉti maca tʉjʉ Enón vãme cʉti macajʉ oco rãca masare bautizarũgũñuju ĩ quẽne. Tojʉre riaga jairo ti oco cʉtijare, ĩnare bautiza ñarũgũñuju ĩ. Jãjarã masa ĩre bautizarotirã ejarũgũñujarã ĩna, tojʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ado bajiro yiñamasiñuju Juan, tubiberiavijʉ ĩ tubibe ecoroto rĩjoro: ");
INSERT INTO bsnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oco rãca masare Juan ĩ bautiza ñarone, gãji jud'io masʉ, Juan buerã tʉjʉre ejayuju ĩ. Ejacõari, “To bajiro me bajiaja. Ado bajirojʉa mani yijare, ‘Rojose mana ñaja mʉa’ manire yiĩagʉ̃mi Dios” yigʉ, ĩna rãca oca josayuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ĩ rãca ĩna oca josariaro bero, Juan tʉjʉ ejacõari, ado bajiro ĩre gotiyujarã ĩ buerã: —Gotimasiorimasʉ, Jordán vãme cʉtirisa ijacatʉajʉ mʉ ĩagoticacʉ, mʉ yirũgũrore bajirone masare oco rãca ĩnare bautizarũgũñuju ĩ. To bajiri jãjarã masa mani tʉjʉre ejaborona, ĩ tʉjʉa rĩne varũgũrãma ĩna, ĩre yigotiyujarã ĩna —Juanre, masare oco rãca bautizarimasʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare gotiyuju Juan: —Ñie manane ñaborãma masa, Dios ĩ cõabetijama. Mani bajirũgũse quẽne Dios ĩ bojasere bajirone bajirũgũaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i me ñaja yʉ. “‘Ĩ ejaroto rĩjoro, ĩre goti rĩjoro cʉtiato’ yigʉ, Dios ĩ cõar'i ñaja yʉ”, jẽre mʉare yigoticõacajʉ yʉ —ĩnare yiyuju Juan, ĩ buerimasare. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","To yicõari, “Ãmosiagʉ babare bajiro bajiaja yʉ” yigʉ, ado bajiro ĩ buerãre ĩnare gotimasioñuju Juan: —Ãmosiariarʉ̃mʉ so manajʉ ñarocʉ babare ajisʉyaroco me ñagõmo. So manajʉ ñarocʉjʉare ajisʉyaroco ñagõmo. So manajʉre so ajisʉyasere ĩacõari, bʉto variquẽnagʉ̃mi ĩ baba. Tire bajirone, “Masa jãjarãre oco rãca bautizarũgũñuju ĩ quẽne” mʉa yisere ajicõari, bʉto variquẽnaja yʉ quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yʉ rẽtoro ñamasugʉ̃ ñaami ĩma. To bajiri, yʉre ĩna rʉ̃cʉbʉoro rẽtoro ĩre ĩna rʉ̃cʉbʉosere bojaja yʉ —ĩ buerãre yiyuju Juan. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Dios tʉjʉ vadir'i ñaami jediro ʉjʉ ñamasugʉ̃. Gãji ĩ cõro ñamasugʉ̃ magʉ̃mi. Adi macarʉcʉrojʉre ruyuariarã, adi macarʉcʉroayere ĩarã ñari, tirene gotiaja mani. Dios tʉjʉ vadir'ima õ vecayere, to yicõari, adi macarʉcʉroayere quẽne quẽnaro masigʉ̃ ñari, jediro ʉjʉ ñamasugʉ̃ ñaami. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ĩma, ĩ ĩarere, ĩ ajirere gotiami ĩ, Dios yere. To bajiboarine ĩ gotisere ajitirʉ̃nʉbeama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","“Jesús ĩ yirore bajiro bajiroja” ĩre yiajigʉma, to bajiro ĩ yiajise sʉorine “Socagʉ me ñaami Dios” yigʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Esp'iritu Santore ĩre cõañumi ĩ macʉre adi macarʉcʉrojʉre ĩ cõar'ire, “Ĩ tʉoĩarore bajiro tʉoĩamasiato” yigʉ. To bajiro ĩ yir'i ñari, Dios ocarene goticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mani jacʉ Dios, ĩ macʉre maigʉ̃ ñari, “Ñajedirore rotiya mʉ”, ĩre yicũñumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","No bojagʉ, Dios macʉre ajitirʉ̃nʉgʉ̃ma, Dios ĩ catisere cʉogʉ ñaami. To bajiboarine no bojagʉ Dios macʉre ajitirʉ̃nʉbecʉma, Dios ĩ catisere cʉobeami. To bajiro ĩ bajijare, rojose ĩ yisere ĩajũnisini tʉjabecʉne, rojose ĩ yise vaja, rojose ĩre yirʉcʉmi Dios, rojose tãmʉotʉjabetiriarojʉ ĩre rocagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","To bajiri, “Juan rẽtobʉsaro masare oco rãca bautizarũgũñuju Jesújʉa. To bajiri Juan buerimasa rẽtobʉsaro ñañujarã Jesús ĩ buerimasajʉa” yire quetire ajiyujarã fariseo masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Quẽnaro masuma, masare oco rãca bautizabetirũgũcami Jesús. Yʉajʉa, ĩ buerimasajʉa masare oco rãca ĩnare bautizarũgũcajʉ.) ");
INSERT INTO bsnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","To bajiri, “Jesús masare oco rãca bautizagʉ yigʉmi” fariseo masa ĩna yitʉoĩasere masicõari, Judea sitare ñacana vacoacajʉ yʉa Jesúrãca, Galilea sitajʉ tudiana yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","To vana, Samaria sitare rẽtoaroti ñacajʉ yʉare. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","To bajiri tojʉre ejacoacajʉ yʉa, Sicar vãme cʉti macajʉre. Ti macama Jacob ñamasir'i, ĩ macʉ Josére ĩ ĩsimasire sita tʉjʉ ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tojʉre ñacajʉ oco goje, Jacob ñamasir'i ya goje. Bogagʉ ñari, ti goje tʉre ejarũju ejacami Jesús. Ʉ̃mʉrecaji cõro muiju tʉsacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yʉa ĩ buerãjʉama gaje macajʉ bare vaja yirã vacoacajʉ yʉa. Tojʉre Jesús ĩ rujirone, sĩgõ Samaria sitago oco vago ejayumo so. So oco vago ejaro ĩacõari, sore oco sẽniñuju Jesús: —Oco yʉre ioya —sore yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sore ĩ oco sẽnirone, ado bajiro ĩre yiyuju so, Samaria sitago: —¿No yigʉ jud'io masʉ ñaboarine, Samaritana yʉ ñaboajaquẽne, yʉre oco sẽniati mʉ? —Jesúre yiyuju so. Samaritano masa, jud'io masa rãca gãmerã terã ñacoayuja yʉa. To bajiri, to bajiro Jesúre ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","To bajiro so yisere ajicõari: —Dios ĩ ĩsirotire mʉ masijama, “Ĩ ñaami yʉre oco sẽnigʉ̃” mʉ yimasijama, yʉjʉare oco sẽnibogoja mʉ. Yʉre mʉ oco sẽnijama, oco catireayere mʉre iobogʉja yʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","To bajiro ĩ yijare, —Ñiene oco vabecʉja mʉ. Ʉ̃mʉarigoje ñaja adi goje. ¿Nojʉayere yʉre catiorotirema yʉre oco iogʉada mʉ? ");
INSERT INTO bsnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mani ñicʉ Jacob ñamasir'i adi gojere cũmasiñumi ĩ. Ĩ quẽne idimasiñuju, adi goje ocore. Ĩ rĩa quẽne idiyujarã. Ĩ yarã vaibʉcʉrã ecariarã quẽne idiyujarã. Mʉma, ¿“Ĩ rẽtoro ñamasugʉ̃ ñaja yʉ” yigʉ yatique mʉ? —Jesúre ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","To bajiro so yijare, ado bajiro sore cʉdiyuju Jesús: —No bojarã adi goje ocore idiboariarã, quẽna gãme oco idirʉacõarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","No bojarã oco catireayere masare yʉ iorãma, quẽna gãme oco idirʉabetirʉarãma. Ĩnare yʉ oco iose sʉorine Diorãca quẽnaro ñacõa ñarũgũrʉarãma —sore yigotiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","To bajiro ĩ yisere ajicõari: —Tijʉare idirʉaja yʉ quẽne, “Quẽna adi gojeayere tudi oco vacõari, idirobe yʉ” yigo —Jesúre ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","To bajiro so yirone, —Vasa. Mʉ manajʉre ĩre jiaya. Ĩre ji, vaba quẽna adojʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","To bajiro ĩ yijare, —Manajʉ magõ ñaja yʉ —yicʉdiyuju so. To so yisere ajicõari, ado bajiro sore yiyuju Jesús: —“Manajʉ magõ ñaja yʉ” mʉ yiserema soco me yaja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cojomocãrãcʉjʉ manajʉa cʉtirio ñaja mʉ. Quẽna yucʉ mʉ rãca ñagʉ̃ quẽne, mʉ manajʉ masu me ñaami. To bajiri, “Manajʉ magõ ñaja yʉ” mʉ yiserema soco me yaja mʉ —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","To bajise sore ĩ yisere ajicõari, ado bajiro ĩre yiyuju so: —Diore gotirẽtobosagʉ ñaja mʉ, mʉre yimasiaja yʉ —yiyuju so, so bajisere ĩ gotise ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Mani ñicʉa, adi burojʉ ejacõari, vaibʉcʉre soemʉomasiñujarã, Diore ĩre yirʉ̃cʉbʉorã. To bajiboarine mʉama, jud'io masama, “Jerusalénjʉ rĩne yirũgũroti ñaja”, yirũgũaja mʉa —Jesúre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","To bajiro so yijare, ado bajiro sore yiyuju Jesús: —Mʉre yʉ gotisere ajitirʉ̃nʉña mʉ: Cojorʉ̃mʉ adi burore quẽne, to yicõari Jerusalénjʉre quẽne Diore, mani jacʉre, ĩre yirʉ̃cʉbʉorã vabetirʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉama, Diore quẽnaro mʉa masibecʉrene rʉ̃cʉbʉoaja mʉa. Yʉajʉama, mʉa rẽtoro ĩre masiaja yʉa. Yʉa, jud'io masa sʉorine masa rojose ĩna tãmʉoborotire ĩnare yirẽtobosarʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Cojorʉ̃mʉ Diore ĩre yirʉ̃cʉbʉorã vabetirʉarãma” mʉre yʉ yigotiserema yoato mene bajirotirene mʉre gotiaja yʉ. Masa, Diore rʉ̃cʉbʉorã masuma, Esp'iritu Santo ĩ bojarore bajiro tʉoĩacõari, ĩre rʉ̃cʉbʉoama ĩna. To bajiro ĩre yirʉ̃cʉbʉosere bojaami mani jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ĩabʉjayamagʉ̃ ñaami Dios. To bajiri, masa ĩre ĩna rʉ̃cʉbʉomasucõarʉajama, socarã mene Esp'iritu Santo ĩ bojarore bajiro tʉoĩacõari, ĩre rʉ̃cʉbʉorãma —sore yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","To bajiro ĩ yisere ajicõari ado bajiro yiyuju so: —“Diore gotirẽtobosagʉ ejarʉcʉmi, Cristo ĩna vãme yigʉ”, yimasiaja yʉ. Ejacõari, yʉare quẽnaro gotiquẽnojeorʉcʉmi —Jesúre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","To bajiro so yirone, —Ĩne ñaja yʉ, mʉre ñagõgʉ̃ma —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","To bajiro sore ĩ yiñarone, tudiejacajʉ yʉa, ĩ buerã. To rõmio rãca ĩ ñagõñajare, no yimasibeticajʉ yʉa, tiũnire ĩabetirũgũriarã ñari. To bajiboarine, “¿Ñie ũnire bojati mʉ? ¿No yigʉ so rãca gãmerã ñagõri mʉa?”, ĩre yisẽniĩabeticajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yʉa tudiejarone oco varia sotʉre ãmibecone, so ñariarojʉ vacoacamo so. So ñariarojʉ tudiejacõari, ado bajiro masare ĩnare yigoticudiyuju so: ");
INSERT INTO bsnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jediro yʉ yiadirere, “Ado bajiro yicajʉ mʉ” yʉre yigotigʉre ĩarã vayá mʉa quẽne. ¿Diore gotirẽtobosagʉ, Cristo me ñagʉ̃ yiguida ĩ? —ĩnare yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","To bajiro so yirere ajicõari, Jesúre ĩarã, yʉa tʉjʉre vayuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ĩna ejaroto rĩjoro ado bajiro Jesúre yiboacajʉ yʉa: —Gotimasiorimasʉ, baya —ĩre yiboacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","To bajiro ĩre yʉa yiboajaquẽne, ado bajiro yʉare cʉdicami Jesús: —Jẽre yʉrema yʉ bare ñacõaja mʉa masibeti —yʉare yicõacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","To bajiro ĩ yirone, —¿Sĩgʉ̃ ĩre bare cũgʉ̃ ejarida ĩ? —yʉa masune gãmerã yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","To bajiro yʉa gãmerã yiñagõsere ajimasicõari, ado bajiro yʉare yicami Jesús: —Yʉre cõacacʉ ĩ bojasere yʉ yijama, ti moarere yʉ yigajanojama, tine ñaja yʉ barere bajiro bajise. Masama bare bavariquẽnarũgũama. Yʉma yʉre cõacacʉ ĩ bojasere bajiro yicõari, variquẽnarũgũaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Babari muijua rʉyaja maji, ote ti bʉcʉaroti, tire mani juarẽoroti”, tocãrãca cʉ̃mari yirũgũaja mʉa. Dios ocare masare gotimasiorãjʉama, ti ũnire yitʉoĩabesa. “Masare Dios ocare mani gotimasiorotijʉ ejabeaja maji”, yitʉoĩabesa mʉa. Yʉma ado bajiro yaja: Jẽre ote bʉcʉacoajʉ yuja. Yucʉacane tire juaroti ñaja. Ĩaĩasaque. Jãjarã masa yʉre ajitirʉ̃nʉrona vadiama ĩna. Ado cõrone ĩnare mʉa gotimasiojama, quẽnamasucõaja, mʉare yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Socaro me bajiaja bʉcʉrã ĩna gotimasire: “Sĩgʉ̃ ñagʉ̃mi otegʉ. Gãji ñagʉ̃mi ti rica cʉtiro boca juarẽogʉ̃”, yiyujarã bʉcʉrã. To bajiro masune bajiaja ti, yʉ ocare gotimasiorãre quẽne. Tʉoĩasaque mʉa: Sĩgʉ̃ri ñaama yʉ ocare masare gotimasiosʉorã. Oterimasare bajiro bajirã ñaama. Ĩna bero ĩnare gotimasiorã, ti rica cʉtiro boca juarẽorãre bajiro bajirã ñaama gãjerã. Ĩnajʉa ĩna gotimasiorone, ĩnare ajitirʉ̃nʉama masa yuja. To bajiri goti rĩjoro cʉtiriarã ña, bero gotimasiorã ña, bajiama ĩna. No bojagʉ otericare juarẽogʉ̃, vaja bʉjagʉ yigʉmi. To bajirone bajirãma yʉ ocare masare gotimasiorã quẽne, variquẽnarere bʉjarã. Ĩna gotimasiose ti ñajare, yʉre ajitirʉ̃nʉama masa. To bajiri yʉre ajitirʉ̃nʉrã ñari, Diorãca quẽnaro ñarũgũrʉarãma, ĩna rijato berojʉ quẽne. To bajiro ĩna bajisere ĩacõari, ĩnare gotimasiosʉoboariarã, bero ĩnare gotimasiorã rãca bʉto variquẽnarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tirʉ̃mʉjʉ quẽne mʉare cõacajʉ yʉ, mʉa gotimasiose sʉorine masa ĩna ajitirʉ̃nʉrotire yigʉ. Yʉ ocare ĩnare gotimasiosʉoriarã me ñaja mʉa, bajirãjʉma. To bajiri, gãjerã ĩna gotimasioboariarã ñaama, mʉajʉa mʉa gotimasiorone, yʉre ajitirʉ̃nʉrona —yʉare yigoticami Jesús, ĩ buerimasare. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","To bajiro ĩnare ĩ yiro bero, “Jediro yʉ yiadirere, ‘Ado bajiro yicajʉ mʉ’ yʉre yigotimi ĩ” rõmio so yigotisere ajicõari, jãjarã ti macariana Samaria sitana, ado bajiro Jesúre tʉoĩacama ĩna: “Diore gotirẽtobosagʉ, Cristo ñaami”, Jesúre yitʉoĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","To bajiro yitʉoĩarã ñari, Jesús tʉ vadieja, ĩre ĩavariquẽnacõari, yʉare tujaroticama ĩna. To bajiri, ĩna rãca jʉarʉ̃mʉ ñacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ĩna rãca ñacõari, Jesús ĩ masune ĩnare ĩ gotimasiosere ajicõari, “Diore gotirẽtobosagʉ, Cristo ñaami”, yitʉoĩacama jãjarãbʉsa. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jesúre ĩre ajitirʉ̃nʉcõari, ado bajiro sore yicama ĩna, rõmiore: —Jẽre, ĩre ajitirʉ̃nʉaja yʉa, mʉ gotise rĩne me. Yucʉne yʉa masune ĩre ajicõari, “To bajiro masu bajigʉ ñaami”, ĩre yiajitirʉ̃nʉaja yʉa yuja. “Ĩne ñaami adi macarʉcʉroana rojose mani tãmʉoborotire manire yirẽtobosarocʉ”, yimasiaja yʉa yuja —sore yicama ĩna, ti macana. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","To yiro bero jʉarʉ̃mʉ bajiña, vacoacajʉ yʉa quẽna, Jesúrãca, Galilea sitajʉare vana. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ado bajiro yʉare yigoticami Jesús, ĩna gotimasirere gotigʉ: —“Diore gotirẽtobosarimasare ĩna ye sitana ĩnare rʉ̃cʉbʉobeama” yise socaro mene yigotiaja ti —yʉare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea sitajʉre Jesús ĩ ñariarojʉre ĩ rãca yʉa ejatone quẽnaro yʉare yicama toana. Ĩna quẽne Jerusalénjʉ Pascua boserʉ̃mʉ ñaro ĩarã variarã tudiejariarã ñacama ĩna. To bajiri jediro Pascua ñaro Jesús ĩ yicatire ĩariarã ñañuma ĩna quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","To bajiro bero Galilea sita Caná vãme cʉti macajʉ ejacajʉ yʉa quẽna, Jesúrãca. To ñacajʉ, ocorene ʉye oco ĩ godoveocato. Tojʉre ñacami sĩgʉ̃ masʉ ʉjʉre rotibosagʉ. Ĩ macʉ, Capernaum vãme cʉti macajʉ bʉto rijañañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","To bajiri, Judea sitajʉ ñar'i Galilea sitajʉare Jesús ĩ vadisere ajicõari, ĩre ĩagʉ̃ ejacami ʉjʉre rotibosagʉ. Jesús tʉjʉre ejacõari ado bajiro ĩre yicami: —Yʉ ya vijʉ vayá. Yʉ macʉ bajirocacʉ yimi. Ĩre catiogʉ vayá —Jesúre, ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yicami Jesús: —Ĩaĩañamanire yʉ yiĩosere mʉa ĩabetijama, “Dios ĩ masise rãca yigʉ yami”, yʉre yiajitirʉ̃nʉbetirʉarãja mʉa —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","To bajiro ĩ yiboajaquẽne: —Yʉ rãca mʉ vadibetijama, bajirocacoarʉcʉmi yʉ macʉ —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","To bajiro ĩ yijare yuja: —Mʉ ya vijʉ tudiasa. Jẽre ĩre catiocõaja yʉ —ĩre boca yicõacami Jesújʉama. To bajise ĩre ĩ yisere ajicõari, Jesúre ĩre ajitirʉ̃nʉcami. To bajiri ĩ ya vijʉ tudicoacami yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ĩ ya vire ĩ cõñarũtuatone, ĩre moabosarimasa bocacõari, ado bajiro ĩre yigoti bocayujarã ĩna: —Jẽre mʉ macʉ quẽnacoami yuja —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","To bajiro ĩna yirone, —¿No cõro masune tudiquẽnasʉori ĩ, yʉ macʉ? —ĩnare yisẽniĩañuju. —Ñamica, ʉ̃mʉrecaji ñaro masune ĩre tʉjamasimʉ ti —ĩre yiyujarã ĩna, ĩna ʉjʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","To bajiro ĩre ĩna yibocarone, “To cõro muiju ĩ tʉsatone, ‘Jẽre mʉ macʉre catiocõaja yʉ’ yʉre yimasimi Jesús”, yitʉoĩamasiñuju ĩ. To bajiri ĩ quẽne, ĩ yarã quẽne, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ Dios ĩ yicõagʉ̃, manire ejarẽmorocʉ ñaami”, Jesúre ĩre yiajitirʉ̃nʉñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ti ñacajʉ quẽna gaje ĩaĩañamani Jesús ĩ yiĩobabocati, Judea sitare ñacõari, Galilea sitajʉ tudiejacõari, ĩ yiĩocati. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","To ĩ yiro bero, jud'io masa ĩna bajimasirere tʉoĩacõari, boserʉ̃mʉ ti ejajare, Jerusalénjʉ yʉare ũmato vacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ti macana ĩna vajanare, “Sãjaroma ĩna” yirã, ĩna matagãniriacʉ̃ni soje, Oveja vãme cʉti soje ñacajʉ ti. Ti soje tʉre ñacajʉ masa ĩna guarita. Hebreo ocama Betzata vãme cʉticajʉ tira. Tira tʉre cojomocãrãca viriaca sitane ĩna veariaviriaca ñacajʉ, rijaye cʉtirã ĩna cũñariviriaca. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tojʉre jãjarã ñacama rijaye cʉtirã. Caje ĩamena, rujasagueri vana, micarã quẽne, to cũñacama. Tira oco ti saberotire yurã, bajicũñacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Dios tʉagʉ, ángel, tocãrãcaji tirajʉre ĩ ejarone, tira oco saberũgũñuju ti. To ti bajirone, no bojagʉ rijaye cʉtigʉ, varocaroasʉogʉ rĩne guaro catirũgũñuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tojʉ rijaye cʉtirã vatoajʉ ñacami sĩgʉ̃ treinta y ocho cʉ̃mari rijañar'i. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ĩ cũñaro ĩacõari, yoaro ĩ cũñarũgũrere ĩamasicõari, ado bajiro ĩre sẽniĩacami Jesús: —¿Quẽna tudicati quẽnaejacoarʉati mʉ? —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yicami: —Sĩgʉ̃jʉama oco ti saberone yʉre ãmiroñuagʉ̃ maami. Tocãrãcaji oco ti sabero, gãjerãjʉa rĩne yʉ rĩjoro ñuñaveocõarũgũama ĩna —ĩre yicami, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","To bajiro ĩ yirone, —Vʉ̃mʉrʉ̃gʉ̃ña. Mʉ cũñaritore ãmiña. To yicõari, vasa —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","To ĩ yirirĩmarone, quẽnaro catiquẽnagʉ̃ ñacoacami ĩ yuja. Ĩ cũñaritore ãmi, vasʉocami yuja. Tirʉ̃mʉ ñacajʉ jud'io masa yʉa ʉsʉsãjariarʉ̃mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","To bajiri ĩ cũñaritore ĩ gaja vato ĩacõari, ado bajiro ĩre yicama jud'io masa ʉjarã: —Yucʉma ʉsʉsãjariarʉ̃mʉ ñaja. To bajiri mʉ cũñaritore gajabesa mʉ. To bajiro mʉ yijama, moare ñaja ti —ĩre yicama sĩgʉ̃ri, Jesús ĩ catiocacʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","To bajiro ĩna yiro, ado bajiro ĩnare cʉdicami Jesús ĩ catiocacʉ: —Yʉre catiogʉ, “Mʉ cũñaritore ãmiasa”, yʉre yimi —ĩnare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","To bajiro ĩ yisere ajicõari, ado bajiro ĩre sẽniĩacama ĩna: —¿Ñimʉ ñari, “Mʉ cũñaritore ãmiasa” mʉre yigʉma? —ĩre yisẽniĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","To bajiro ĩre ĩna yisẽniĩaboajaquẽne, tojʉre jãjarã masa vatoajʉ Jesús ĩ vayayicoajare, “Ĩ ñaami”, ĩnare yigotimasibeticami. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tijʉ bero, Diore yirʉ̃cʉbʉoriavijʉ yʉa ñaro, rijarʉ̃mʉri cʉtir'ire ĩre ĩabʉjacami Jesús quẽna. Ĩre ĩabʉjacõari, ado bajiro ĩre yicami Jesús: —Ajiya. Quẽnaro quẽna tudicaticoajʉ mʉ. Quẽna gãme rojose yibesa, “Bʉtobʉsa rojose tãmʉorobe” yigʉ —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","To bajiro ĩ yiro bero micase rijaye cʉtiboacacʉ, ĩre sẽniĩaboariarã tʉjʉ ejacõari, “Jesúne ñaami, yʉre catiogʉ”, ĩnare yigotiyumi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","To bajiri ʉsʉsãjariarʉ̃mʉre micaboacacʉre Jesús ĩre ĩ catiocatore bajiro gãjerãre to bajirone ĩ yirũgũjare, josari ĩ tãmʉorotire yirã, ĩre rojose yisʉyacama ĩna, jud'io masa ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","“Ʉsʉsãjariarʉ̃mʉ ti ñaboajaquẽne, masare ĩ catiose vaja, rojose tãmʉoato ĩ” yirã ĩna ñaboajaquẽne, ado bajiro ĩnare yicami Jesújʉama: —Masa rijaye cʉtirãre catiotʉjabecʉ ñaami Dios, yʉ jacʉ. To bajiri ĩnare catiotʉjabeaja yʉ quẽne —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","“Ʉsʉsãjariarʉ̃mʉre Dios ĩ moarotibetiboajaquẽne, moami Jesús”, ĩre yijũnisinicama jud'io masa ʉjarã, ĩre sĩarʉarã. To yicõari, “Dios ñaami yʉ jacʉ” ĩ yisere ajicõari, “‘Diore bajiro ñamasugʉ̃ ñaja yʉ’ yigʉ yami”, yicama ĩna. To bajiro yirã ñari, bʉtobʉsa jũnisinirã ñari, ĩre sĩarʉa tʉoĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","To bajise ĩna yitʉoĩasere ĩamasicõari ado bajiro ĩnare yicami Jesús: —Ñamasusere riojo mʉare gotiaja yʉ: Dios macʉ ñari, yʉ bojase yibeaja yʉ. Yʉ jacʉ ĩ yisere ĩacõari, ĩ yirore bajirone yaja yʉ. Jediro yʉ jacʉ ĩ yirore bajirone yʉ quẽne ĩ macʉ quẽne, to bajirone yaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ jacʉ yʉre maiami. Yʉre maigʉ̃ ñari, jediro ĩ yisere yʉre ĩoami. Adirʉ̃mʉriaye rẽtoro josasere yʉre yiĩorʉcʉmi. To bajiro ĩ yisere yʉ yiĩosere ĩacõari, no yimasibetirʉarãja mʉa quẽne, ti ũnire ĩabetirũgũriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bajireariarãre catiorũgũami yʉ jacʉ. To bajiri yʉ, ĩ macʉ quẽne, ĩ yirũgũrore bajirone yirũgũaja yʉ, no yʉ bojarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Masa rojorãre beserocʉ me ñaami yʉ jacʉ. “Ĩnare beserocʉ ñaja mʉ”, yʉre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","To bajiro yʉre yicami, ĩre quẽnaro ĩna yirʉ̃cʉbʉorore bajirone yʉre quẽne “Yirʉ̃cʉbʉoato ĩna” yigʉ. Quẽnaro yʉre yirʉ̃cʉbʉobecʉma, yʉ jacʉre, yʉre cõacacʉre quẽne yirʉ̃cʉbʉobecʉ yigʉmi —jud'io masa ʉjarãre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","To bajiro ĩnare yigajanocõari, ado bajiro goticami Jesús: —Ñamasusere riojo mʉare gotiaja yʉ: No bojagʉ yʉ ocare ajicõari, yʉre cõacacʉre ajitirʉ̃nʉgʉ̃ma, Dios ĩ catisere cʉogʉ ñaami. Ĩ ũgʉ̃rema, rojose tãmʉotʉjabetiriarojʉ ĩre cõabetirʉcʉmi Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ñamasusere riojo mʉare gotiaja yʉ: Adirʉ̃mʉri bajirotirene mʉare yaja yʉ: Yʉre ajitirʉ̃nʉmenama, bajireariarãre bajiro bajirãma, ĩna rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere cʉomena ñari. To bajiboarine Dios macʉre yʉre ajitirʉ̃nʉrʉarãma sĩgʉ̃ri. Ĩnajʉare, “Ĩna rijato berojʉ tudirijabeticõato” yigʉ, Dios ĩ catisere ĩnare ĩsirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Masare yʉ jacʉ ĩ catiorũgũrore bajiro yʉre ĩ catioroticati ñajare, ĩ catisere ĩnare ĩsimasiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","To yicõari, Dios macʉ ñaboarine, masʉre bajiro rujʉ cʉticõari, masa vatoajʉ ñar'i yʉ ñajare, “Masare besemasirʉcʉja mʉ”, yʉre yicami yʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","To bajiro yʉ yisere ajiyamanire bajiro ajitʉoĩabesa mʉa. Bajireariarã jediro ĩnare yʉ jiro, ĩna ajijedirotirʉ̃mʉ ejarʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","To cõrone yʉ jisere ajicõari, yʉ tʉjʉ ejajedirʉarãma ĩna, tudicatiana yuja. Yʉ tʉ ejacõari, quẽnaro yirũgũriarãma, Diorãca quẽnaro ñacõa ñarũgũrʉarãma ĩna. Rojose yirũgũriarãrema rojose tãmʉotʉjabetiriarojʉ ĩnare cõarʉcʉja yʉ yuja —ĩnare yigoticami Jesús, jud'io masa ʉjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Quẽna ado bajiro ĩnare goticami Jesús: —Yʉ bojarore bajiro yigʉ me ñaja yʉ. Yʉre cõacacʉ ĩ bojarore bajiro yirʉa tʉoĩagʉ̃ ñari, masare rojose yirãre, to yicõari quẽnase yirãre yʉ ĩabesejama, quẽnaro riojo yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“To bajiro yigʉ ñaja yʉ” yʉ masurione yʉ yijama, “Socʉ yami”, yʉre yiroti ñaboroja. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","To bajiboarine, ñaami sĩgʉ̃, yʉre gotibosagʉ. Yʉre ĩ gotibosase, quẽnaro riojo ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gãji quẽne, “Ĩne ñaami ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ Dios ĩ cõar'i”, yʉre yigotibosayumi, Juan, masare oco rãca bautizarimasʉ. Ĩ tʉjʉre mʉa ejarẽmorimasare sẽniĩaroticõañuja mʉa. Quẽnaro riojo mʉare cʉdiyumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Rotimʉorʉ̃gõrʉcʉmi” yigʉ Dios ĩ cõar'ire yʉre ĩ gotibosajaquẽne, yʉre ĩ gotibosabetijaquẽne, no yibeaja ti, yʉre, Dios ĩ cõacacʉ ñari. Juan yʉre ĩ gotibosarere mʉare gotiaja yʉ, tire ajitirʉ̃nʉcõari, rojose tãmʉotʉjabetiriarojʉ mʉa vabetirotire bojagʉ ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Sĩabusuocõari quẽnaro riojo ĩamasire ñaja. Tire bajirone bajicami Juan, quẽnaro riojo yʉre gotibosacacʉ ñari. Ĩre ajivariquẽnañuja mʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","To bajiro mʉare yiboarine, “Sĩgʉ̃ ñaami yʉre gotibosagʉ” yʉ yijama, Juanre tʉoĩagʉ̃ me yaja yʉ. Juan yʉre ĩ gotibosacati rẽtoro ñamasuse ñaja. Tima ĩaĩañamanire mʉare yʉ yiĩorũgũse, yʉ jacʉ yʉre ĩ rotise ñaja. Tire ĩacõari, “Socʉ me yami. Dios ĩ cõar'i ñaami”, yʉre yimasiama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Yʉ jacʉ yʉre cõacacʉ quẽne, ĩ masune, “Yʉ macʉ, yʉ cõagʉ̃ ñaami” yigʉ ñari, masa ĩna ajimasirotire ĩnare cõarũgũami. Ĩ cõacacʉre yʉre ajitirʉ̃nʉmena ñari, ĩre ajimena, to yicõari, ĩ ocare ajitirʉ̃nʉmena ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Dios ocare masa ĩna ucamasirere bʉto buerũgũboaja mʉa, “Ti ocare mani buejama, Diorãca quẽnaro ñacõari, mani rijato berojʉ ĩ rãca quẽnaro ñacõa ñarũgũrʉarãja mani” yirã. To bajiboarine yʉ bajiserene mʉare ti gotiboajaquẽne, yʉre ajirʉabeaja mʉa. Yʉre mʉa ajitirʉ̃nʉjama, Diorãca quẽnaro ñacõari, mʉa rijato berojʉ ĩ rãca quẽnaro ñacõa ñarũgũborãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Quẽnaro yʉre yirʉ̃cʉbʉoato masa” yigʉ me, adi macarʉcʉrojʉre vadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉa tʉoĩasere ĩamasiaja yʉ. To bajiri, “Diore mairã me ñaja mʉa”, mʉare yimasiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉ jacʉ yʉre ĩ roticõajare, adojʉ vadicajʉ yʉ, mʉare gotimasiogʉ̃. To bajiro yʉ bajiboajaquẽne, yʉre ajitirʉ̃nʉbeaja mʉa. No bojagʉ, Dios ĩ cõabecʉrema, “Masa quẽnaro yʉre yirʉ̃cʉbʉoato ĩna” yigʉ ĩ vadijama, ĩjʉare ajitirʉ̃nʉrʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mʉa masune quẽnase gãmerã yirʉ̃cʉbʉorere bojarũgũaja mʉa. Dios sĩgʉ̃ne ñaami mani ʉjʉ. To bajigʉ ĩ ñaboajaquẽne, “Quẽnase manire yato Dios” yirã, no bojase mʉa yirotire yitʉoĩabetirũgũaja mʉa. To bajiro bajirã ñari, yʉre ajitirʉ̃nʉbeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yʉ jacʉ tʉjʉre mʉa ejaro, “Yʉre ajitirʉ̃nʉbeticama”, mʉare yigotiyirobetirʉcʉja yʉ. Moisés ñamasir'ine ñaami to bajisere mʉare yigotiyirogʉ. “Moisés ñamasir'i ĩ rotimasirere quẽnaro mani ajitirʉ̃nʉjama, Dios tʉjʉ varʉarãja mani”, yitʉoĩaboaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","To bajiboarine yʉ bajirotirene ucamasiñumi Moisés. To bajiri ĩ ucamasirere mʉa ajitirʉ̃nʉmasucõajama, yʉre quẽne ajitirʉ̃nʉborãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ĩ ucamasirere quẽnaro ajitirʉ̃nʉmena ñari, yʉre quẽne ajitirʉ̃nʉbeaja mʉa, —ĩnare yicami Jesús, jud'io masa ʉjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","To bajiro ĩnare ĩ yiro bero, ʉtabʉcʉra Galilea vãme cʉtira gajejacatʉajʉajʉ yʉare ũmato jẽacami Jesús. Gaje vãme, Tiberias vãme cʉticajʉ tira. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","“Dios macʉne ñaja yʉ” yigʉ, rijaye cʉtirãre Jesús ĩ catiorũgũsere ĩacõari, jãjarã masa ĩre sʉyarũgũcama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Gajejacatʉajʉ ejacõari, burore yʉare ũmato majacõari, rujicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pascua boserʉ̃mʉ jud'io masa yʉa quẽnorotirʉ̃mʉ cõñacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","To bajiri jãjarã masa Jesúre ĩre sʉyarũgũrã ĩna vadore ĩacõari, ado bajiro Felipere ĩre yicami Jesús: —Ĩnare ecarʉarã, ¿nojʉ bare vaja yirãti mani? —ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","“Ado bajiro yirʉcʉja yʉ” yimasiboarine, “‘Mʉ ejarẽmose rãca ecamasicõarʉarãja’ Felipe yʉre ĩ yicʉdiro ajigʉsa” ĩre yigʉne, yicõañumi Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","To bajiro ĩ yijare ado bajiro ĩre yicʉdicami Felipe: —Doscientos gãjoatiiri rãca vaja yiboarine, ĩnare ecajeomasibetiborãja mani —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","To ĩ yirone, yʉa rãcagʉ, Pedro bedi Andrés vãme cʉtigʉ, ado bajiro Jesúre yicami: ");
INSERT INTO bsnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Sĩgʉ̃ daquegʉ, cojomo cõro pan cebada vãme cʉtise, to yicõari, jʉarã vaire cʉoboami, bajigʉjʉma. Masa jãjarã ĩna ñajare, tĩjariaro manimasucõaja ti —Jesúre ĩre yicami Andrés. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","To bajiro ĩ yirone, —Masare ĩnare rujirotiya —yicami Jesús. Tojʉre tatũcuro ñacajʉ. To bajiri, ta joejʉ rujicama. Cinco mil ʉ̃mʉa ñacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ĩna rujijediro ĩacõari, pan daquegʉ ĩ baborotirene juacõari, “Quẽnaro yaja mʉ”, Diore yivariquẽnacami Jesús. To yicõari ĩ buerãre yʉare ĩsicami, “Rujirãre ĩsibatoya” yigʉ. Vaire quẽne, to bajirone yicami. Sĩgʉ̃ rʉyariaro mano quẽnaro baʉsʉcʉtijedicõacama. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ĩna bagajanoro ĩacõari, ado bajiro yʉare yicami Jesús: —Ĩna barʉasere juarẽoña. Bajirearobe tijʉma —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","To bajiro yʉare ĩ yijare, cebada vãme cʉtise cojomo cõro pan ñaboarere yʉa juarẽojama, jʉaãmo cõro, gʉbo jʉa jẽnituaro ñarijibʉri rʉyacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","To bajiro ĩaĩañamanire Jesús ĩ yiĩoro ĩacõari, ado bajiro yicama masa: —Diore gotirẽtobosarimasʉ, adi macarʉcʉrojʉre vadicõari, manire rotirocʉne ñaami —Jesúre ĩre yicama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","To bajiro ĩna yijare, “Yʉ bojabetiboajaquẽne, yʉre ãmivacõari ʉjʉ yʉre cũrʉama” yimasicõari, ĩ sĩgʉ̃ne buro joejʉre majacoacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ti rãioato ĩacõari, ʉtabʉcʉrare rojaejacajʉ yʉa, Jesús buerimasa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Rojaeja, cũmua vasãja jẽacajʉ yʉa, gajejacatʉajʉ Capernaum vãme cʉti macajʉ vana. Ti rẽtiacoaboajaquẽne, ejabeticõacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","To yʉa bajijẽarũtuatone, bʉto mino vacajʉ. To bajica yiro, bʉto sabetʉocõacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco o seis kilómetros cõro yʉa jẽatʉsatone, yʉa tʉjʉ oco joene vadicami Jesús. Oco joene ĩ vadire ĩarãne, ʉcacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","To bajiro yʉa bajiboajaquẽne, ado bajiro yʉare yicami Jesús: —Güibesa. Yʉne ñaja —yʉare yi vadicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","To bajiro yʉare ĩ yijare, variquẽnarãne, ĩre sãcajʉ yʉa. Ĩre yʉa sãrirĩmarone jẽaejacoacajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Ʉtabʉcʉra gajejacatʉajʉ tujacana, cũmuane yʉa ĩ buerã Jesús ĩ manone yʉa jẽasere ĩacama ĩna. To bajiri gajerʉ̃mʉ yʉa tudijẽaejabetore ĩacõari, Jesúre quẽne ĩre ĩabeticõari, Tiberias macana ĩna ejase cũmune jẽaejayuma, Capernaum vãme cʉti macajʉ, Jesúre macarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yʉare ĩabʉjacõari, ado bajiro Jesúre yisẽniĩacama ĩna: —Gotimasiorimasʉ, ¿Divato adore ejari mʉ? —ĩre yisẽniĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","To bajiro ĩna yisẽniĩasere ajicõari: —Ñamasusere riojo mʉare gotiaja yʉ. Ĩaĩañamanire yʉ yiĩosere ĩari, “To bajiro yigʉ ĩ ñajare, ĩre ajitirʉ̃nʉ sʉyaroti ñaja” yirã me yʉre macasʉyaja mʉa. “Quẽnaro baʉsʉcʉtiriarojʉ bare ecagʉ ñaami” yirã ñari, bajiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bare mʉa bojamasusejʉama yoaro meacane mʉare jediveocoatoja ti. To bajiri mʉa barotire tʉoĩarejaibeticõaña mʉa. Gajeye barere bajiro bajise ñaja, Dios ĩ roticõacacʉ yʉre ajitirʉ̃nʉrãre yʉ ĩsisema. Jedibetirʉaroja tima. “‘Tire ĩsimasiami’ yʉre yimasiato ĩna” yigʉ, ĩaĩañamanire yʉ yiĩorũgũrotire yʉre ʉjocami Dios. To bajiri, bare jedibetijʉare bojarã, Dios ĩ bojasere yiya mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","To bajiro ĩ yijare, ĩre sẽniĩacama ĩna: —¿No bajiro yʉa yirotire bojati Dios? —ĩre yisẽniĩacama. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","To bajiro ĩna yisere ajicõari ado bajiro ĩnare yicʉdicami Jesús: —Dios ĩ cõacacʉre yʉre mʉa ajitirʉ̃nʉsere bojaami Dios —ĩnare yicami Jesús yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","To bajiro ĩ yijare, —¿Ñie ũnire Dios ĩ masise rãca ĩaĩañamanire yʉare yiĩorʉcʉada mʉ, tire ĩacõari “Yʉre ajitirʉ̃nʉato ĩna” yʉare yigʉ? ");
INSERT INTO bsnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mani ñicʉa ñamasiriarã yucʉ́ manojʉ ñacudirã, maná vãme cʉtisere bamasiñujarã ĩna. To bajirone gotiaja Dios ocare masa ĩna ucamasire. Tʉoĩasaque: “Bare Dios ĩ ñaroayere manire ecagʉ yivẽjañumi”, yigotiaja Dios oca, masa ĩna ucamasire —Jesúre ĩre yicama. To bajiro ĩna yijama, “Moisés ñamasir'i sʉorine bajiriaroja ti” yirã yicama. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","To bajiro ĩna yisere ajicõari, ado bajiro cʉdicami Jesús: —Ñamasusere riojo mʉare gotiaja yʉ: Moisés ñamasir'i me Dios ĩ ñaroayere barere ĩnare cõacami. Yʉ jacʉne ñaami ĩ ñaroayere barere ĩnare cõacacʉma. To bajirone bajiaja pan quẽnamasusere quẽne. Tire mʉare cõami Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tire mʉa bajama, mʉa rijato berojʉ, “Tudirijabeticõato” yigʉ, Dios ĩ catisere ĩsiecorʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","To bajiro ĩ yirone, —To yijama, pan quẽnamasusere yʉare ecarũgũma mʉ —ĩre yicama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","To bajiro ĩna yijare, ado bajiro ĩnare yicami Jesús yuja: —Yʉne ñaja pan quẽnamasuse Dios ĩ cõase. To bajiri, no bojagʉ yʉre ajitirʉ̃nʉgʉ̃ma, baʉsʉcʉtirũgũgʉ̃re bajiro bajigʉmi. To bajiri, disejʉane Dios ĩ ejarẽmose ĩre rʉyabetirʉaroja. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","To bajiro yʉ bajiboajaquẽne, yʉre ajitirʉ̃nʉbeaja mʉa, yʉre ĩarã ñaboarine. Jẽre tirene mʉare gotiboabʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","No bojarã yʉre ajitirʉ̃nʉrãma, yʉ jacʉ sʉorine yʉ bojarore bajiro quẽnasejʉare tʉoĩavasoariarã ñaama. No bojagʉ yʉre ajitirʉ̃nʉgʉ̃re, “Mʉre bojabeaja”, ĩre yibetirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Adojʉre vagʉ, yʉ bojasere yirʉ me rujiadicajʉ yʉ. Yʉ jacʉ ĩ bojasejʉare yirʉ, vadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ado bajiro bojaami yʉ jacʉ, yʉre cõacacʉ: Ĩ sʉorine yʉre ajitirʉ̃nʉrã ñajediro, ñatʉsarirʉ̃mʉre rojose tãmʉotʉjabetiriarojʉ ĩna vasere bojabeami. Ĩ tʉjʉ ĩna ñasejʉare bojaami. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","No bojagʉ, “Dios macʉ ñaja mʉ” yʉre yimasicõari, yʉre ajitirʉ̃nʉgʉ̃re, Dios ĩ catisere ĩ cʉosere bojaami yʉ jacʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Pan quẽnamasusere bajiro bajigʉ ñaja yʉ Dios ĩ ñarojʉ rujiadicacʉ” Jesús ĩ yisere ajicõari, ñagõjaicama jud'io masa ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ado bajiro gãmerã yicama: —¿Adi macagʉ, José macʉ me ñatique? Ĩ jacʉre, ĩ jacore quẽne masiaja mani. To bajigʉ ñaboarine, “Dios ĩ ñarojʉ rujiadicajʉ yʉ”, manire yisocaboami —gãmerã yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","To bajiro ĩna gãmerã yiñajare, ado bajiro ĩnare yicami Jesús: —Yʉre ñagõmacabesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yʉ jacʉ sʉorine yʉ bojarore bajiro quẽnasejʉare tʉoĩavasoariarã rĩne ñaama yʉre ajitirʉ̃nʉrã. Ñatʉsarirʉ̃mʉ ĩnare catiorʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diore gotirẽtobosariarã yʉre ajitirʉ̃nʉrona ĩna bajirotire yirã, gotirã ado bajiro ucayuma ĩna: “Dios ĩ masise sʉorine masirʉarãma ĩna jedirone”, yiucayuma ĩna. To bajiri yʉ jacʉ ĩ masise sʉorine yʉ bojarore bajirojʉare tʉoĩavasoacõari, yʉre ajitirʉ̃nʉrʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Masʉ, nijʉane yʉ jacʉre ĩagʉ̃ maami. Yʉ sĩgʉ̃ne ĩ tʉjʉre rujiadicacʉ ñari, ĩre ĩacacʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ñamasusere riojo mʉare gotiaja yʉ: No bojagʉ yʉre ajitirʉ̃nʉgʉ̃ma, Dios ĩ catisere cʉogʉ ñaami. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Pan quẽnamasusere bajiro bajigʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉa ñicʉa yucʉ́ manojʉ maná vãme cʉtisere bare, Dios ĩ cõarũgũrere barũgũriarã ñaboarine bajireajedicoasuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yʉrema, pan quẽnamasusere bajiro bajigʉre, masa ĩna ajitirʉ̃nʉjama, bajireacoaboarine, quẽna tudicaticõari, quẽnaro ñarũgũrʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉne ñaja pan quẽnamasusere bajiro bajigʉ Dios ĩ cõacacʉma. No bojarã yʉre barã ĩna rijato berojʉ, quẽna tudicaticõari, quẽnaro ñarũgũrʉarãma. To bajiro ĩna bajirotire yigʉ, ĩnare rijabosarʉcʉja yʉ —jud'io masa ʉjarãre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","To bajiro ĩ yisere ajicõari, ĩna masune ado bajiro gãmerã yicama ĩna: —¿No bajiro ĩ rujʉre manire ecariquĩda ĩ? —gãmerã yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yicami Jesús: —Ñamasusere riojo mʉare gotiaja yʉ: Yʉre, Dios ĩ roticõacacʉre, yʉ rujʉre mʉa babetijama, yʉ ri'ire quẽne mʉa idibetijama, mʉa rijato berojʉ “Tudirijabeticõato” yigʉ, Dios ĩ catisere cʉobetirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","No bojagʉ yʉ rujʉre bagʉ, yʉ ri'ire idigʉ ñaami Dios ĩ catisere cʉogʉ. To bajicõari, ĩ rijato berojʉ ñatʉsarirʉ̃mʉre tudicaticõari, quẽnaro ñarũgũrʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ rujʉ ñaja bare ñamasuse. To bajicõari, yʉ ri'i ñaja idire ñamasuse. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","To bajiri yʉ rujʉre bacõari, yʉ ri'ire idigʉma, yʉ rãcagʉ ñagʉ̃mi. Yʉjʉa quẽne, ĩ rãcagʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ jacʉ, yʉre cõacacʉ catirere cʉogʉ ñaami. To bajiri ĩ sʉorine catiaja yʉ. To bajirone bajirʉcʉmi yʉre ajitirʉ̃nʉgʉ̃ quẽne. Yʉ sʉorine ĩ rijato berojʉ quẽna tudicaticõari, yʉ rãca quẽnaro ñacõa ñarũgũrʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","To bajiri pan quẽnamasusere bajiro bajigʉ, Dios ĩ ñarojʉ rujiadicacʉ ñaja yʉ. Yʉma mʉa ñicʉare õ vecaye bare Dios ĩ cõare maná vãme cʉtisere bajiro bajigʉ me ñaja. Mʉa ñicʉa, maná vãme cʉtisere bariarã ñaboarine, bajireajediyuma ĩna. No bojagʉ yʉre ajitirʉ̃nʉgʉ̃ma, ĩ rijato berojʉ quẽna tudicaticõari, yʉ rãca quẽnaro ñacõa ñarũgũrʉcʉmi —ĩnare yicami Jesús, jud'io masa ʉjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ado bajiro ĩ gotimasio ñajama, Capernaum vãme cʉti maca ñarivi, Dios ocare ĩna buerivijʉ ñacõari, ĩnare gotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","To bajiro ĩ gotisere ajicõari, jãjarã ĩre sʉyarã, ado bajiro gãmerã yicama ĩna: —To bajiro ĩ yigotimasiose, no bajiro yimasiriaro maja. Tire ajivariquẽnagʉ̃ magʉ̃mi —gãmerã yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","To bajiro ĩna gãmerã yisere masicõacami Jesús. To bajiri, ado bajiro ĩnare yicami: —To bajiro mʉare yʉ yigotimasiosere ajitebesa mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Riojo me yami” mʉa yitʉoĩajama, Dios ĩ roticõacacʉ õ vecajʉ yʉ vadicatojʉre quẽna yʉ tudimʉjatore ĩacõari, “Riojo yiyumi”, yitʉoĩaboarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Yʉ rujʉre ĩna base sʉorine, ĩna rijato berojʉ ‘Tudirijabeticõato’ yigʉ, Dios ĩ catisere cʉorʉarãma masa” yʉ yijama, yʉ rujʉre yigʉ me yaja yʉ. Yʉre masa ĩna ajitirʉ̃nʉsejʉare yigʉ yaja. Yʉre ajitirʉ̃nʉrãrema Esp'iritu Santore ĩnare cõarʉcʉja yʉ, ĩna rijato berojʉ, “Tudirijabeticõato” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","To bajiro yʉ yigotisere, “Socʉ yami”, yitʉoĩaja mʉa sĩgʉ̃ri —ĩnare yicami Jesús. Rẽmojʉne, “Ĩna ñarʉarãma ‘Socʉ yami’ ” yʉre yitʉoĩarã, to yicõari, “Ĩ ñarʉcʉmi yʉre ĩsirocarocʉ” yimasigʉ̃ ñari, to bajiro ĩnare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","To bajiro yigajanocõari, ado bajiro ĩnare gotiquẽnocami: —“Yʉre sʉyarã sĩgʉ̃ri, ‘Socʉ yami’, yʉre yitʉoĩaama” yimasigʉ̃ ñari, “Ñimarã yʉre ajitirʉ̃nʉrã maniborãma, yʉ jacʉ sʉorine quẽnasejʉare ĩna tʉoĩavasoabetijama”, mʉare yibʉ yʉ. To bajiri yʉ jacʉ sʉorine quẽnasejʉare tʉoĩavasoarã me ñari, “Socʉ yami”, yʉre yaja mʉa sĩgʉ̃ri —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","To bajiro ĩ yisere ajicõari, jãjarã ĩre sʉyaboacana ĩre cãmotadicõari, jʉaji ĩ rãca vacudibeticama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","To bajiro ĩna bajiro ĩacõari, jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre ado bajiro yʉare sẽniĩacami Jesús: —¿Mʉa quẽne, “Ĩre cãmotadito mani”, yʉre yitʉoĩati mʉa? —yʉare yisẽniĩacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yicʉdicami Pedro: —Ñimʉjʉa mʉre bajiro bajigʉ magʉ̃mi. Yʉa rijato berojʉ, “Tudirijabeticõato” yigʉ, Dios ĩ catisere yʉare mʉ ĩsisere gotiaja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mʉre ajitirʉ̃nʉaja yʉa. “Rojose yigʉ me, Dios ĩ cõar'i ñaja mʉ”, mʉre yimasiaja yʉa —Jesúre ĩre yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","To bajiro ĩ yisere ajicõari ado bajiro yʉare yicami Jesús: —Mʉarema, ¿jʉaãmo cõro, gʉbo jʉa jẽnituarirãcʉ ñarãre yʉne mʉare bese juabeticati yʉ? To yʉ yicana mʉa ñaboajaquẽne, mʉa vatoare ñaami sĩgʉ̃ vãtia ʉjʉre cʉdigʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","To bajise ĩ yijama, Simón macʉ Judas Iscariotere yigʉ yiyumi Jesús, yʉa jʉaãmo cõro, gʉbo jʉa jẽnituaro rãcagʉ ñaboarine, ĩre ĩsirocarocʉ ĩ ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","To bajiro ĩ yiro bero, quẽna Galilea sitajʉ yʉare ũmato vacudicami Jesús. Judea sitajʉ ñarʉabeticami, ti sitana jud'io masa ʉjarã ĩre ĩna sĩarʉajare. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yucʉ́ manojʉ ĩna ñicʉa ĩna ñacudimasirere tʉoĩariarʉ̃mʉri, Enramadas vãme cʉti boserʉ̃mʉ cõñacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","To bajiri, Jesús bederã ado bajiro ĩre yicama: —Judea sitajʉ mʉre sʉyaboacana, jãjarã ñarãma. To bajiri adojʉre tujabesa. Tojʉane tudicoasa mʉ, ĩna quẽne, “Ĩaĩañamanire mʉ yiĩorũgũsere ĩato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","No bojagʉ, jãjarã masa ĩre ĩna ĩamasirotire ĩ bojajama, masa mojoroaca ñarojʉre yiĩocudibecʉmi. Ĩaĩañamanire yiĩomasigʉ̃ ñari, jãjarã ĩna ñarojʉare yiĩoaya mʉ —ĩre yicama ĩna, Jesús bederã. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesús bederã ñaboarine, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, ĩre yitʉoĩarã me ñacama. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","To bajiri ado bajiro ĩnare yicami Jesús: —Judeajʉ yʉ varoti ejabeaja maji. No bojarirʉ̃mʉ mʉa vajama, mʉarema quẽnacõaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Diore ajimena mʉa ñajare, mʉare ĩatemenama. Yʉrema ĩateama ĩna, “Mʉa yirũgũse, rojose ñaja ti” ĩnare yʉ yijare. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Enramadas boserʉ̃mʉ ĩarã vasa mʉama. Yʉrema, yʉ varoti ejabeaja maji —ĩ bederãre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","To bajiro ĩnare ĩ yiro bero, Galilea sitajʉre ñacõacajʉ yʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ĩ bederã ĩna vato bero, Jesús quẽne, Enramadas boserʉ̃mʉ ũmato ĩagʉ̃ vacami. To bajiboarine, yayioroaca yʉare ũmato ejacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","To ñacama jud'io masa ʉjarã quẽne. Ĩre macaboacama. —¿Nojʉ ñati ĩ? —yicudiboacama. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Tirʉ̃mʉrire jãjarã masa Jesúre ñagõjai ñacama ĩna. Sĩgʉ̃ri ado bajiro yicama: —Quẽnaro yigʉ ñagʉ̃mi —yicama ĩna. Gãjerãjʉama: —Quẽnaro yigʉ me ñagʉ̃mi. Masare yitogʉ ñagʉ̃mi —boca yicama. Ʉjarãre güirã ñari, ĩna masune yayioroaca gãmerã ñagõcõa ñacama ĩna, Jesúre gõjarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Enramadas boserʉ̃mʉ ĩna yi gʉdareco cʉtiato, Diore yirʉ̃cʉbʉoriavire sãjacõari, masare ĩnare gotimasiocami Jesús yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ĩ gotimasiosere ajicõari, no yimasibeticama jud'io masa ʉjarã: —Buebetir'i ñaboarine, ¿no yigʉ to bajise gotimasiomasiati ĩ? —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","To bajiro ĩna yisere masicõari, —Yʉ gotimasiosema yʉ ye me ñaja. Yʉre cõacacʉ ye ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dios ĩ bojasere mʉa yirʉajama, “Dios ĩ yerene gotimasioami”, yimasiborãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","No bojagʉ no ĩ tʉoĩasene gotigʉma, masa quẽnase ĩre ĩna yirʉ̃cʉbʉosere bojagʉmi. No bojagʉ ĩre cõacacʉre Diore masa quẽnase ĩre ĩna yirʉ̃cʉbʉosere bojagʉma, riojo masune gotigʉ ñagʉ̃mi. Ñie ũnijʉare masare ĩnare yitobecʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Moisés ñamasir'i Dios ĩ rotimasirere mʉare cũbesujarique ĩ? Tire cʉorã ñaboarine no bojagʉ mʉa vatoare Dios ĩ rotimasirere cʉdijeogʉ maami. Rojose yʉ yibetiboajaquẽne yʉre sĩarʉaja mʉa —masare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdicama ĩna masa: —Vãti mʉ ʉsʉjʉre sãjacõari, rojose mʉre yitogʉ yigʉmi. Ñimʉjʉa mʉre sĩarʉagʉ magʉ̃mi —ĩre yicama ĩna, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","To bajiro ĩna yijare, —Ʉsʉsãjariarʉ̃mʉ ñaboajaquẽne, sĩgʉ̃ rijagʉre yʉ catioro ĩacõari ĩaʉcacajʉ mʉa, “Ʉsʉsãjariarʉ̃mʉ ñaboajaquẽne moami” yiĩaterã. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés ñamasir'i sũcacare circuncisión yirere mʉare rotiyumi ĩ. Ĩ masu me tire rotisʉoyumi. Jẽre ĩ ñicʉajʉne to bajirone yicoadimasiñujarã ĩna. To bajiro rotimasire ñajare, ʉsʉsãjariarʉ̃mʉ ti ñaboajaquẽne, sũcare circuncisión yaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés ñamasir'i ĩ rotimasirere cʉdirã ñari, ʉsʉsãjariarʉ̃mʉ ti ñaboajaquẽne sũcare circuncisión yaja mʉa. Yʉjʉarema ʉsʉsãjariarʉ̃mʉ ti ñaboajaquẽne sĩgʉ̃ rijagʉre yʉ catiojama, ¿no yirã yʉre jũnisiniati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ñie manone rujajine quẽnaro tʉoĩabetiboarine, “Rojose ĩre ñaja”, yʉre yibesa mʉa. “Rojose ĩre ñaja” mʉa yijama, quẽnaro tʉoĩa rĩjoro yicõari, “Rojose ĩre ñaja”, yʉre yiya mʉa —ĩnare yicami Jesús, masare. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","To bajiro ĩ yisere ajicõari, Jerusalén macana sĩgʉ̃ri ĩna masune gãmerã sẽniĩacama ĩna: —¿Sĩarʉarã, ĩna macagʉ me ñaruyuati ĩ? ");
INSERT INTO bsnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ado mani jediro rĩjorojʉare ñagõñaami ĩ. To ĩ bajiboajaquẽne sĩgʉ̃ ĩre boca yimatagʉ maami. Adoana ʉjarã, “Cristo Dios ĩ cõagʉ̃, mani ʉjʉ ñagʉ̃mi ĩ”, ¿yitʉoĩarãda ĩna? ");
INSERT INTO bsnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Ti macagʉ vayumi”, yimasiaja mani. Cristorema, “Ĩ ejaro, ‘Toagʉ vayumi’ yimasibetirʉarãja mani”, yiadire ñaja —ĩna masune gãmerã yicama ĩna, Jerusalén macana sĩgʉ̃ri. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","To bajiro ĩna yisere ajicõari, Diore yirʉ̃cʉbʉoriavijʉ gotimasio ñacacʉ, oca tutuase rãca ñagõcami Jesús yuja: —Yʉre ĩacõari, “Ti macagʉ ñaami”, yʉre yitʉoĩaboaja mʉa. To bajiro mʉa yitʉoĩajama, yʉre cõacacʉre riojo yigʉre masibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yʉma ĩre masiaja. Ĩ cõacacʉne ñaja yʉ. Ĩ ñarojʉne vadicajʉ yʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","To bajiro ĩ yijare, bʉto ĩre ajijũnisinirã ñari, ĩre ñiarʉaboacama ĩna, jud'io masa ʉjarã. To bajiboarine ĩre ñiamasibeticama ĩna, “To cõrone ñiaecorʉcʉmi” Dios ĩ yiriarʉ̃mʉ ti ejabetijare. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gãjerãma jãjarã ĩre ajitirʉ̃nʉcama ĩna. To bajiri ado bajiro yicama ĩna: —Cristo, Dios ĩ cõar'i ñagʉ̃mi ãni. No bojagʉ ĩ rẽtoro ĩaĩañamanire yigʉ manirʉcʉmi —yicama ĩna, ĩre ajitirʉ̃nʉrã. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Masa Jesús ĩ bajisere yayioroaca ĩna gotiro ajiyuma fariseo masa. To bajiri, Diore yirʉ̃cʉbʉoriavi coderimasare Jesúre ĩre ñiarotiyuma ĩna, paia ʉjarã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ĩna ejaro ĩacõari ado bajiro yicami Jesús: —Yʉre cõacacʉ tʉjʉ quẽna tudiarʉcʉja yʉ. To bajiri yoaro meaca adore masa tʉjʉre ñarʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉre macarʉarãja mʉa. To bajiboarine yʉre bʉjabetirʉarãja mʉa. Yʉ ñarojʉre no bajiro yi vamasibetirʉarãja mʉa —masare ĩnare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","To bajiro Jesús ĩ yisere ajicõari, jud'io masa ʉjarã ĩna masune gãmerã sẽniĩacama ĩna: —¿Nojʉre variquĩda ĩ, ĩre mani bʉjabetirotojʉrema? Mani ñaro sojʉajʉ vacõari griego masa rãca vʉsarã tʉjʉ varʉ yigʉmi, ĩ yijama. Tojʉre vacõari, gãjerã masare, o mani yarãre gotimasiogʉ̃ varʉ yigʉmi, ĩ yijama. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Yʉre macaboarine yʉre bʉjabetirʉarãja mʉa. To bajicõari yʉ ñarojʉre vamasibetirʉarãja mʉa” ĩ yijama, ¿no yire ũnire yati ĩ? —gãmerã yiñagõcama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Masa manojʉ ĩna ñicʉa ĩna ñacudimasirere tʉoĩatʉsariarʉ̃mʉ, tirʉ̃mʉ ñacajʉ rujarʉ̃mʉ masuma. Tirʉ̃mʉre vʉ̃mʉrʉ̃gʉ̃cõari, oca tutuase rãca ñagõcami Jesús: —Sĩgʉ̃ ĩ oco idirʉajama, oco sẽnigʉ̃mi. Tire bajirone, no bojagʉ Diore ĩ masirʉajama, yʉ tʉjʉre vadicõari ĩre yʉ catiorotire sẽnigʉ̃ ejato ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ajiya mʉa. Ado bajiro gotiaja Dios ocare masa ĩna ucamasire: No bojarã yʉre ajitirʉ̃nʉrãrema, “Ĩna ʉsʉrijʉ oco masare catiose, riagare bajiro ũmayucõa ñarʉaroja, ‘Diorãca quẽnaro ñacõa ñarũgũrãjaro’ yiro”, yigotiaja Dios oca —masare ĩnare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","To bajiro ĩ yijama, “Yʉre ajitirʉ̃nʉrãre ĩna ʉsʉrijʉre, Dios ĩ cõagʉ̃ Esp'iritu Santo ejacõari quẽnaro ĩnare ejarẽmocõa ñarũgũrʉcʉmi, ĩna rijato berojʉ tudirijabeticõari, Diorãca quẽnaro ñaronare” yigʉ yicami Jesús. Õ vecajʉre, quẽnase ĩre yirʉ̃cʉbʉoriajʉjʉre Jesús ĩ tudiejabetijare, Dios ĩ cõagʉ̃ Esp'iritu Santore adi macarʉcʉrore Jesúre ajitirʉ̃nʉcanare cõabesumi Dios maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús ĩ ñagõsere ajicõari, sĩgʉ̃ri ado bajiro yicama: —Diore ĩre gotirẽtobosarimasa, Dios ocare ucarã, “To bajirʉcʉmi” masa ĩna yiucamasir'i masune ñaami —yicama ĩna, sĩgʉ̃ri. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gãjerãjʉama ado bajiro yicama ĩna: —Cristo, “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i masune ñacõaami —yicama ĩna. Gãjerãma ado bajiro yicama: —Cristo me ñaami. No bajiro yigʉ, Galileagʉne Cristo ñabecʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios ocare masa ĩna ucamasire ti gotijama, ado bajiro yaja: “Ʉjʉ David ñamasir'i jãnerabatia jãnami ñarʉcʉmi Cristo. To bajiri David ñamasir'ire bajirone Belén macagʉne ñarʉcʉmi ĩ quẽne”, yigotiaja Dios oca —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ado bajise ricatiri rĩne Jesúre ĩre yitʉoĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sĩgʉ̃ri ĩre ñiarʉaboacama. To bajiboarine ĩre ñiamasibeticama. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Diore yirʉ̃cʉbʉoriavire coderimasa Jesúre ĩre ñiamasibeticõari, fariseo masa, paia ʉjarã tʉjʉre tudiacama ĩna. Ñie manane ĩna ejaro ĩacõari ado bajiro ĩnare yisẽniĩañujarã ĩna paia ʉjarã: —¿No yirã ĩre ãmiadibeti mʉa? —ĩnare yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ado bajiro ĩnare yicʉdiyujarã Diore yirʉ̃cʉbʉoriavire coderimasa: —Ĩre bajiro ñagõrã manicama ĩna —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","To bajiro ĩna yijare, fariseo masajʉa ado bajiro ĩnare yiyujarã: —¿To yitogʉ ĩ yiserene ĩre ajiri mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mʉa ʉjarã ñaja yʉa. Yʉama sĩgʉ̃ ĩre ajitirʉ̃nʉgʉ̃ maja. Mani ʉjarã quẽne sĩgʉ̃ ĩre ajitirʉ̃nʉgʉ̃ maami. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Adoana masa Moisés ñamasir'i ĩ rotimasirere masibeticõari, Jesúre ĩre ajitirʉ̃nʉrãma. To bajiro ĩna bajijare, ĩnare rearʉcʉmi Dios —yiyujarã ĩna fariseo masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo ñamijʉ Jesúre ĩre ĩagʉ̃ ejar'i, fariseo masʉ ñañuju ĩ quẽne. Ĩ babarãre ado bajiro ĩnare yiyuju ĩ: ");
INSERT INTO bsnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¡Majique! Moisés ñamasir'i manire ĩ rotimasirere yirã, ĩ gotisere ajicõari, ĩre sẽniĩabetiboarine, “Rojose ñaja ti, ĩre”, yimasibeaja mani —yiyuju Nicodemo, ĩ babarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","To bajiro ĩ yijare, —¿Mʉ quẽne Galileagʉ ñatique mʉ? Dios ocare masa ĩna ucamasiriatutire ĩaĩasaque mʉ. Tire mʉ buero bero, “Diore gotirẽtobosarimasʉ Galileajʉ vadir'i manirʉcʉmi” yiucaturere masirʉcʉja mʉ quẽne —ĩre yiyujarã ĩna, Nicodemore tud'irã. ");
INSERT INTO bsnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","To bajiro ĩre yicõa, ĩna ya virijʉ tudijedicoasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Macajʉ yʉa tujarone, Olivo vãme cʉti burojʉ majacoacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gajerʉ̃mʉ, busurijʉ, Diore yirʉ̃cʉbʉoriavijʉ tudiejacami quẽna Jesús. Ĩ ejaro ĩacõari jãjarã masa ĩ tʉre rẽjacama. To bajiro ĩna bajijare, rujicõari yʉare gotimasiocami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","To bajiro yʉare ĩ yigotimasio ñarone, fariseo masa, Dios ĩ rotimasire gotimasiorimasa quẽne ejacama. Sĩgõ rõmio manajʉ cʉtiboarine gãji rãca ajeri cʉtigore yʉa ĩaro rĩjorojʉare sore jiaejocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","To yicõari, ado bajiro Jesúre ĩre yicama ĩna: —Yʉare masiogʉ̃, adio rõmio manajʉ cʉtiboarine gãji rãca so ajeri cʉtisere ĩamʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés ñamasir'i ĩ rotimasire ado bajiro yirotiaja ti: “To bajiro yirãrema gʉ̃tane ĩnare reasĩaña”, yaja ti. Mʉma, ¿no bajiro tʉoĩati mʉ? —Jesúre ĩre yicama. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","“Moisés ĩ yiriarore bajirone Jesús manire ĩ cʉdibetijama, ‘Jesús, rojose yimi’ ” ʉjarãre yi ocasãrʉarã, Jesúre sẽniĩatoboacama ĩna. To bajiro ĩna yisẽniĩatoboajaquẽne, mubiacõari ĩ ãmo vãsoane ucacami Jesús, sita tũcurojʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ĩre ĩna sẽniĩatʉjabetijare, vʉ̃mʉrʉ̃gʉ̃cõari, ado bajiro ĩnare yicami Jesús yuja: —Mʉa rãcagʉ, “Rojose yibecʉ ñaja yʉ” yigʉ, gʉ̃tane mʉare ũmato rocavasʉoato —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","To bajiro yicõa, quẽna mubiacoacami Jesús. Mubiacõari, sita tũcurore ucacõa ñacami quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","To bajiro ĩ yisere ajicõari, “Rojose yibeticajʉ” yigʉ manicami. To bajiri, sore gʉ̃tane rocavamenane, bʉcʉrã vasʉo, tijʉ bero gãjerã vajedicoacama ĩna. To ĩna baji veogo, so sĩgõne Jesúrãca tujacamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","To ĩna bajiro bero, vʉ̃mʉrʉ̃gʉ̃cõari, so sĩgõne so ñaro ĩacõari, ado bajiro sore sẽniĩacami Jesús: —¿Nojʉ ñati ĩna yuja, “Rojose yimo” mʉre yirãma? ¿Rojose mʉ yise vaja, sĩgʉ̃jʉama mʉre sĩamenane, vacoajari ĩna? —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","To bajiro ĩ yijare, —Yʉre sĩamenane, vacoajama —Jesúre yicamo. To so yisere ajicõari, ado bajiro sore yicami Jesús: —Yʉ quẽne, “Rojose mʉ yire vaja rojose tãmʉorʉocoja”, yibeaja yʉ. Vasa. Quẽna gãme rojose yibeja mʉ yuja —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Quẽna ado bajiro masare ĩnare yigoticami Jesús: —Yʉ sʉorine Diore masiama masa. Yʉre ajitirʉ̃nʉmasurãma, Diore masimenare bajiro bajibetirʉarãma ĩna. Yʉre ajitirʉ̃nʉrãre catioaja yʉ, ĩna rijato berojʉ, “Quẽnaro catijedicõa ñarũgũrãjaro” yigʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","To bajiro ĩ yisere ajicõari, ado bajiro yicama fariseo masa: —“To bajiro bajigʉ ñaja yʉ” mʉ yiboajaquẽne, nijʉane gãji mami, “Riojo gotiami” mʉre yigʉma. To bajiri to bajiro mʉ yiboase vaja maja ti. To bajiro yitocõagʉ̃ yaja mʉ —Jesúre ĩre yicama. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","To bajiro ĩna yijare, ado bajiro ĩnare yicʉdicami Jesús: —Yʉ vadicatojʉre masiaja yʉ. Yʉ varotore quẽne masiaja yʉ. To bajiri yʉ masune yʉ gotise ñaboarine, socase me ñaja ti. Mʉama, yʉ vadicatojʉre, to yicõari, yʉ varotore quẽne masibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Masa ñari, riojo masimenane, “Rojose yirã ñaama”, gãjerãre yiĩabeserũgũaja mʉa. Yʉma, masa ĩna yisere ĩabesegʉ me yaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","To bajiboarine masa rojose ĩna yisere yʉ ĩabesejama, yʉ sĩgʉ̃ne ĩabesebeaja yʉ. Yʉ jacʉ, yʉre cõacacʉ, yʉ rãcane ĩabeseami. To bajiri, masare, “Rojose yirã ñaama” yʉ yijama, riojo masune ĩnare gotiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉa ñicʉa ĩna rotimasirere ado bajiro yiucamasire ñaja ti: “‘Rojose yimi’ jʉarã ĩna yijama, ĩnare ajiya”, yaja ti, mʉa ñicʉa ĩna rotimasire. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","To bajiri, “To bajiro bajigʉ ñaja yʉ”, masare yiĩorũgũaja yʉ, yʉ masu quẽne. Yʉ jacʉ yʉre cõacacʉ quẽne, ĩ masune, “Yʉ macʉ yʉ cõagʉ̃ ñaami” yigʉ ñari, masa ĩna ajimasirotire ĩnare cõarũgũami —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","To bajiro ĩ yisere ajicõari, ado bajiro ĩre sẽniĩacama ĩna: —¿Nojʉ ñati mʉ jacʉ? —ĩre yicama, Jesúre. To bajiro ĩna yijare ĩnare cʉdicami Jesús: —Yʉre ĩamasibeaja mʉa. To bajiri yʉ jacʉre quẽne masibeaja mʉa. Yʉre mʉa ĩamasijama, yʉ jacʉre quẽne masiborãja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Diore yirʉ̃cʉbʉoriavijʉ, masa ĩna gãjoa sãriajʉ tʉjʉre rʉ̃gõcõari, to bajise masare ĩnare yigotimasiocami Jesús. Tojʉ jud'io masa ʉjarã ĩna moarijʉ ti ñaboajaquẽne, Jesúre ñiamasibeticama, ĩre ĩna ñiaroticu maji ti ejabetijare. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Quẽna ado bajiro masare yigoticami Jesús: —Varʉcʉja yʉ. Yʉ vato bero, yʉre macaboarʉarãja mʉa. Yʉre bʉjamena rĩne rojose mʉa yise rãcane bajireacoarʉarãja mʉa. To bajiri yʉ vatojʉre vamasibetirʉarãja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","To bajiro ĩ yisere ajicõari, ado bajiro gãmerã yicama ĩna, jud'io masa ʉjarã: —¿Ĩ masune sĩayayirʉ yati ĩ, “Yʉ varotojʉre vabetirʉarãja mʉa” ĩ yijama? —gãmerã yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","To bajiro ĩna yisere ajicõari: —Mʉama, adigodoana ñaja. Yʉma, õ vecagʉjʉ ñaja. Adi macarʉcʉroana Diore ajimena ñaja mʉama. Yʉma, adi macarʉcʉroagʉ me ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","To bajiri, “Rojose mʉa yise rãcane bajireacoarʉarãja mʉa”, mʉare yibʉ yʉ. “Ĩne ñaja yʉ” yʉ yirore bajiro yʉre mʉa ajitirʉ̃nʉbetijama, rojose mʉa yise rãcane bajireacoarʉarãja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","To bajiro ĩ yisere ajicõari, ado bajiro ĩre sẽniĩacama ĩna: —¿Ñimʉ ũgʉ̃ ñati mʉ? —ĩre yicama ĩna, Jesúre. To bajiro ĩna yirone, ĩnare cʉdicami Jesús: —Mʉare gotisʉogʉjʉne, “Ĩ ñaja yʉ” mʉare yisʉoadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jairo mʉare yʉ gotiroti ñaboaja ti. Rojose mʉa yisere ĩacõari, “Ado bajiro rojose yaja mʉa” cojoji me mʉare yʉ yiborotine bajicõaja ti. To bajiboarine masare adi macarʉcʉroanare mʉare yʉ gotijama, yʉre cõacacʉ ĩ gotirotise rĩne gotirũgũaja yʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","To bajiro ĩ yiboajaquẽne, “‘Yʉre cõacacʉ’ yigʉ, ‘Diore, ĩ jacʉre’ yigʉ yami”, yiajimasibeticama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","To bajiri ado bajiro ĩnare yigoticami Jesús: —Dios ĩ roticõacacʉne ñaja yʉ. Yucʉ́tẽrojʉ masa yʉre ĩna jajuturo bero bajisere ĩacõari, “Riojo yiyumi. To bajiro masune bajigʉ ñañumi”, yʉre yimasirʉarãja mʉa. “Ĩ masurione ĩ tʉoĩasere me gotirũgũñumi. Ĩ jacʉ ĩre ĩ gotimasiorotisere gotirũgũñumi”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉre cõacacʉ yʉ rãcane ñacõa ñarũgũami. Ĩ bojase rĩne yaja yʉ. To bajiri yʉre vaveobetirũgũami —masare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","To bajiro Jesús ĩ yisere ajicõari, jãjarã masa ĩre ajitirʉ̃nʉcama. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","To bajiri jud'io masare ĩre ajitirʉ̃nʉrãre ado bajiro goticami Jesús: —Mʉare yʉ gotimasiorũgũsere mʉa ajitirʉ̃nʉ tʉjabetijama, yʉ buerã masune ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","To bajiro bajirã rĩne Dios ocare socabetire ajimasirʉarãja mʉa. Ti ocare ajimasicõari, rojose mʉa yisejasere yitʉjarʉarãja mʉa, Dios ĩ bojasejʉare yirʉarã —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","To bajiro ĩ yijare, ado bajiro yicama ĩna: —Abraham ñamasir'i jãnerabatia ñari, Dios yarã ñaja yʉa. To bajiri, ¿no bajiro yigʉ, “Rojose mʉa yisejasere yitʉjarʉarãja mʉa, Dios ĩ bojasejʉare yirʉarã”, yʉare yati mʉ? —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","To bajiro ĩna yisere ajicõari, ado bajiro yicami: —Ñamasusere riojo mʉare gotiaja yʉ: No bojarã rojose yirãma, rojose yisejarã ñari, rojose yitʉjamasibeama. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sĩgʉ̃ ĩ ʉjʉre moabosarimasʉ, “Ado yʉre moarotigʉ rãcane ñacõa ñarũgũrʉcʉja yʉ”, yimasibeami. Ʉjʉ macʉjʉama, ĩ rãcane ñacõa ñarũgũrʉcʉmi. To bajiri, Dios rĩama, ĩ rãcane ñacõa ñarũgũrʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","To bajiri, rojose mʉa yisejasere yʉ sʉorine “Yitʉjarʉarãja” mʉa yijama, “Rojose maja ĩnare”, mʉare yirʉcʉja yʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Abraham ñamasir'i jãnerabatia ñaja yʉa” mʉa yisere masiaja yʉ. To bajiro yirã ñaboarine, yʉ gotisere ajitirʉ̃nʉbeticõari yʉre sĩarʉaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉ jacʉ yʉre ĩ yiĩocatire mʉare gotiaja yʉ. Mʉama, mʉa jacʉ rojose yigʉ ĩ rotisere cʉdirã ñaja —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","To bajiro ĩ yisere ajicõari, ado bajiro yicama ĩna: —Abraham ñamasir'ine ñañumi, “yʉa jacʉ” yʉa yigʉma —Jesúre ĩre yicama ĩna. To bajiro ĩna yirone, ado bajiro ĩnare yicami Jesús: —Abraham ĩ yirũgũriarore bajirone yiborãja mʉa, ĩ rĩa mʉa ñajama. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yʉ jacʉ, Dios oca socase mere ĩ gotirotirore bajirone mʉare yʉ gotimasioboajaquẽne, yʉre sĩarʉaja mʉa. Abraham ñamasir'ima ti ũnire yibetirũgũmasiñumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yʉre sĩarʉarã, mʉa jacʉ masu rojose yigʉ ñadir'i ĩ yirũgũrore bajirone yirã ñaja mʉa —ĩnare yicami Jesús. To bajiro ĩ yijare, ado bajiro ĩre yicama: —Yʉa jacʉ masuma, Dios ñaami. Gãji mami yʉarema. Ĩ rĩa masune ñaja yʉama —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare cʉdicami Jesús: —Mʉa jacʉ masune Dios ĩ ñajama, yʉre maiboriarãja mʉa. Yʉ masu me vadicajʉ yʉ. Dios yʉre ĩ cõajare vadicajʉ yʉ. Dios tʉjʉ vadicõari adone ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿No yirã yʉ gotisere ajimasibeati mʉa? Yʉ gotimasiosere ajirʉamena ñari, tire ajimasibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉa jacʉma, vãtia ʉjʉ ñaami. Ĩ rĩa ñaja mʉa. To bajiri ĩ bojasere bajirone mʉa quẽne yirʉa tʉoĩaja mʉa. Rẽmojʉne masare sĩarimasʉne ñacoayumi vãtia ʉjʉ. Riojo gotibetirũgũami. Yitorimasʉ, socase jacʉ ñaami. Ĩ gotijama, socarũgũami. Rẽmojʉne to bajirone bajicoayumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉrema socabeti quetire gotigʉ yʉ ñajare, yʉre ajitirʉ̃nʉbeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sĩgʉ̃, “Ado bajise rojosere yicajʉ mʉ”, yʉre yimasigʉ̃ mami. To bajiri, riojo mʉare yʉ gotiboajaquẽne, ¿no yirã yʉre ajitirʉ̃nʉbeati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios rĩa mʉa ñajama, ĩ ocare ajiboriarãja mʉa. Ĩ rĩa me ñari yʉre ajirʉabeaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","To bajiro ĩ yirone, cʉdicama jud'io masa ʉjarã: —“Samaria sitagʉ, vãti sãñagʉ̃ ñaja mʉ” mʉre yʉa yirũgũse riojone yiyuja yʉa —Jesúre ĩre yicama jud'io masa ʉjarã yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","To bajiro ĩna yisere ajicõari, ado bajiro ĩnare yicami Jesús: —Vãti sãñagʉ̃ me ñaja yʉma. Yʉ jacʉ Diore quẽnase ĩre yirʉ̃cʉbʉoaja yʉ. Mʉama, yʉre rʉ̃cʉbʉobeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Quẽnaro yʉre yirʉ̃cʉbʉoato ĩna masa” yigʉ me vadicacʉ ñaja yʉ. Sĩgʉ̃ne ñaami, quẽnaro masa yʉre ĩna yirʉ̃cʉbʉosere bojagʉma. Yʉre rʉ̃cʉbʉomenare ĩamasigʉ̃ ñaami. Ĩamasicõari, rojose yʉre ĩna yise vaja rojose tãmʉorotirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ñamasusere riojo mʉare gotiaja yʉ. No bojarã yʉ gotisere ajitirʉ̃nʉrãma, bajireabetirʉarãma ĩna —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","To bajiro ĩ yisere ajicõari, ado bajiro Jesúre yicama jud'io masa ʉjarã: —To bajiro mʉ yisere ajicõari, “Vãti sãñagʉ̃ masune ñaami”, mʉre yimasiaja yʉa yuja. Abraham ñamasir'i, Diore gotirẽtobosarimasa ñamasiriarã quẽne, bajireajedicoasuma ĩna. To bajiro ĩna bajire ti ñaboajaquẽne, “Yʉre ajitirʉ̃nʉrãma bajireabetirʉarãma ĩna”, yiboaja mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yʉa ñicʉ Abraham ñamasir'i, ñamasugʉ̃ ñamasiñuju ĩma. ¿Ĩ rẽtoro ñamasugʉ̃ ñatique mʉ? Abraham quẽne, Diore gotirẽtobosarimasa quẽne bajireajedicoasuma ĩna. To yijama, ¿ñimʉ ũgʉ̃ ñati mʉ? —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","To bajiro ĩna yijare, ĩnare cʉdicami Jesús: —Yʉ masurione, “Quẽnagʉ̃ ñaja yʉ. Quẽnase yigʉ ñaja yʉ” yʉ yiboajama, ñie vaja maja ti. Yʉ jacʉ ñaami quẽnase yʉre yirʉ̃cʉbʉogʉ, “Ĩne ñaami yʉa Dios” mʉa yiboagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ĩre masibeaja mʉa. Yʉma, ĩre quẽnaro masiaja. “Ĩre masibeaja” yʉ yijama, mʉare bajirone socagʉ ñabogʉja yʉ. Yʉma, quẽnaro masune ĩre masicõaja yʉ. Ĩ yirore bajirone ĩre cʉdiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉa masa ñicʉ, Abraham ñamasir'i, “Cojorʉ̃mʉ ejarʉcʉmi Dios ĩ cõagʉ̃, ñajediro masa ʉjʉ” yigʉ, variquẽna yuñamasiñumi. To bajiri adi macarʉcʉrojʉre yʉ ejaro ĩacõari, variquẽnamasucõacami —ĩnare yicami Jesús, jud'io masa ʉjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","To bajiro ĩ yisere ajicõari, ado bajiro ĩre yicama ĩna, Jesúre: —Bʉcʉ me ñaja mʉ. Cincuenta cʉ̃mari cʉobetiboarine, ¿no yigʉ, “Abraham ñamasir'ire ĩre ĩacajʉ yʉ”, yati mʉ? —ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","To bajiro ĩna yijare, ado bajiro ĩnare yicami: —Ñamasusere riojo mʉare gotiaja yʉ. Abraham ñamasir'i ĩ ñaroto rĩjorojʉne jẽre ñacõacajʉ yʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","To bajiro ĩ yisere ajicõari, gʉ̃tari juacama, ĩre rearʉarã. To bajiro ĩna yirone, ĩnare rudicõa budiacami Jesús, Diore yirʉ̃cʉbʉoriavire ñaboacacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","To bajivacʉne, sĩgʉ̃ rẽmone caje ĩabecʉ ruyuar'ire ĩre ĩabʉjacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","To ĩ bajisere ĩacõari, ado bajiro ĩre sẽniĩacajʉ yʉa, ĩ buerimasa, Jesúre: —Gotimasiogʉ̃, ¿no yigʉ rẽmone ĩabecʉ ruyuayujari ĩma? ¿Ĩ jacʉajʉa o ĩ masu ye sʉori bajiyujarique? —Jesúre ĩre yisẽniĩacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","To bajiro yʉa sẽniĩarone, ado bajiro yʉare cʉdicami Jesús: —Ĩ masune rojose ĩ yire vaja me, ĩ jacʉa quẽne rojose ĩna yire vaja me, to bajigʉ ruyuayumi ĩ. “Dios ĩ masisere masirãjaro masa” yigʉ, to bajigʉ ruyuayumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ʉ̃mʉa ti ñaro moamasiaja mani. Rãioro berojʉma moamasibeaja mani. To bajirone bajiaja mani catise quẽne. Ado ñarãma, moamasiaja mani. To bajiboarine, no bojarirʉ̃mʉ mani bajireacoajama, moamenaja mani. To bajiri, yʉre cõacacʉ ĩ rotirore bajirone quẽnaro yirũgũroti ñaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","To bajiri adi macarʉcʉrojʉre masa rujʉre bajiro rujʉ cʉticõari, yʉ ñasere ĩacõari, to yicõari, yʉ gotimasiosere ajicõari, Diore masiama masa. Ti ñaja yʉ moare —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","To bajiro yigajanogʉ̃ne, sita tũcurojʉre gooco eoreacũcami. To yicõa, ĩ goocone sitare yierocami. To yicõari, ĩabecʉre tine tucami, ĩ cajere. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","To bajiro ĩre yicõari ado bajiro ĩre yiroticami, ĩabecʉre: —Siloé vãme cʉtirita, masa ĩna guarũgũritajʉ vasa. Tojʉ ejacõari, mʉ cajere coeba —ĩre yicami Jesús, ĩabecʉre. (Hebreo oca rãca “siloé” ĩna yijama, “cõar'i” yirã yicama.) To bajiri Jesús ĩ coerotisere ajicõari, ĩ coerotirore bajirone ĩ cajere coegʉ vacoacami ĩabecʉ. Ĩ cajere coegajanogʉ̃ne, ĩacoasuju. To bajiri ĩ ya vijʉ tudicoasuju. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ĩ tudiejaro ĩacõari, ĩ yarã, ĩre ĩarũgũriarã, ado bajiro ĩre yiyujarã ĩna: —“¿Yʉre ĩamaicõari, yʉre ĩsiña” yirujirũgũgʉ̃ me ñati ĩma? —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","To bajiro ĩna yirone, —Ĩne ñaami —yiyujarã ĩna sĩgʉ̃ri. Gãjerãjʉama: —Ĩ me ñaami. Ĩre bajigʉne ñaami, bajigʉjʉma —yiyujarã gãjerãjʉa. To bajiro ĩna yisere ajicõari ĩ masune, —Ĩne ñaja yʉ —yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","To bajiro ĩ yigotijare ado bajiro ĩre yisẽniĩañujarã masa: —¿No bajiro yicõari, ĩacoati mʉ yuja? —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","To bajiro ĩna yijare, —Sĩgʉ̃, Jesús vãme cʉtigʉ ĩ goocone sitare yierocõari yʉ cajere tumi. Tire tucõari, ado bajiro yʉre yirotimi: “Siloé vãme cʉtiritajʉ vacõari, mʉ cajere coeba”, yʉre yimi. To bajiri tirajʉ ejacõari, yʉ cajere coebʉ yʉ. To bajiro yigʉne, ĩacoajʉ yʉ yuja —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","To bajise ĩnare ĩ yigotijare, ado bajiro ĩre yisẽniĩañujarã masa: —¿Nojʉ ñarojari, to bajiro mʉre yir'ima? —ĩre yisẽniĩaboayujarã ĩna. —Ba. Masibeaja yʉ —yiyuju ĩabecʉ ñaboar'i. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","To bajiro ĩ yisere ajicõari, fariseo masa tʉjʉre ĩabecʉ ñaboar'ire ĩre jiasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ĩ goocone sitare yierocõari ĩabecʉre Jesús ĩ caje ĩaroticatirʉ̃mʉma, jud'io masa ĩna ʉsʉsãjarirʉ̃mʉ ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","To bajiri ĩabetiboacacʉre ĩna ãmiejaro ĩacõari, ado bajiro ĩre yisẽniĩañujarã fariseo masa: —¿No bajiro yicõari, ĩabetirũgũboagʉne, ĩacoati mʉ yuja? —ĩre yisẽniĩañujarã fariseo masa. To bajiro ĩre ĩna yirone, —Ĩ goocone sitare yierocõari, yʉ cajere tumi. Tire coegʉne ĩacoajʉ yʉ yuja —ĩnare yigotiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","To bajiro ĩ yirone, —Mʉre to bajiro yir'ima, Dios ĩ cõar'i me ñagʉ̃mi. Ʉsʉsãjariarʉ̃mʉre rʉ̃cʉbʉobesumi —yiyujarã ĩna. Gãjerãjʉama ado bajiro yiyujarã ĩna: —Rojose yigʉ ĩ ñajama, ado bajiro ĩaĩañamanire yibetiborimi —yiyujarã gãjerãjʉama. To bajiri ricatiri rĩne tʉoĩañujarã ĩna fariseo masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","To yicõari bero, quẽna gãme sẽniĩañujarã ĩna, ĩabecʉ ñaboar'ire: —Mʉma, ¿no bajiro tʉoĩati mʉ, “Ĩato” mʉre yir'ire? —yiyujarã ĩna. To bajiro ĩna yirone, —“Diore gotirẽtobosarimasʉ ñagʉ̃mi”, yaja yʉma —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","“Ĩabecʉ ruyuar'i ñaboarine, ĩacoasumi yuja”, yirʉabesujarã ĩna maji. To bajiri ĩabetiboar'i jacʉare jicõañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ĩna ejaro, ado bajiro ĩnare yisẽniĩañujarã ĩna: —¿Mʉa macʉ, ĩabecʉ ruyuacacʉ mʉa yigʉne ñati ãnima? ¿No bajiro yicõari ĩabecʉ ñaboarine, ĩacoasujari ĩ yuja? —yisẽniĩañujarã ĩna, ĩ jacʉare. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","To bajiro ĩna yisẽniĩajare, ĩnare gotiyujarã ĩna: —Ĩne ñaami yʉa macʉne, ĩabecʉ ruyuacacʉne. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","To bajiboarine, “Ado bajiro yicõari, ĩaami yuja”, yimasibeaja yʉa. Ĩ cajere ĩarotir'ire masibeaja yʉa. Ĩre sẽniĩaña mʉa. Bʉcʉ ñaami jẽre. Ĩ masu mʉare gotiato —yiyujarã ĩ jacʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jud'io masa ʉjarãre ĩnare güirã ñari, “Jesúne ñaami ĩre ĩarotir'i” ĩnare yiterã ñari, to bajise yiyujarã ĩ jacʉa. Jud'io masa ʉjarã ado bajiro yitʉoĩañujarã ĩna: —“Jesús ñaami ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i, mani ʉjʉ” yirãre sãjarotibetirʉarãja mani, Dios ocare ĩna buerivirijʉre —yitʉoĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","To bajiri, “Manire sãjarotibetoma” yirã, “Bʉcʉ ñaami. Ĩre sẽniĩaña”, ĩnare yiyujarã ĩabetiboar'i jacʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","To bajiro ĩna yijare, ĩabetiboar'ire ado bajiro ĩre yiyujarã ĩna quẽna: —Dios sĩgʉ̃rene quẽnase ĩre yirʉ̃cʉbʉoya, mʉ cajere ĩarotir'i ĩ ñajare. Jesújʉarema, “Rojose yigʉ ñaami”, ĩre yimasiaja yʉa —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","To bajiro ĩna yisere ajicõari, ado bajiro yiyuju ĩ: —“Rojose yigʉ, quẽnase yigʉ ñagʉ̃mi”, ĩre yimasibeaja yʉ. “Ĩabecʉ ñaboacacʉ, yucʉrema ĩagʉ̃ ñaja yʉ yuja”, yimasiaja yʉ, tirema —yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","To bajiro ĩ yisere ajiboarine, quẽna ĩre sẽniĩañujarã ĩna: —¿No bajiro mʉre yiri ĩ, “Ĩato ĩ” mʉre yigʉ? —ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","To bajiro ĩna yijare, ado bajiro ĩnare cʉdiyuju ĩ: —Jẽre mʉare gotiboabʉ yʉ. Yʉre ajibeaja mʉa. ¿No yirʉarã quẽna gãme gotire bojati mʉa? ¿Mʉa quẽne ĩ buerã ñarʉatique? —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","To bajiro ĩ yisere ajicõari, ĩre tud'iyujarã ĩna: —Mʉma, ĩ buegʉ ñaja mʉ. Yʉama, Moisés ñamasir'i ĩ rotimasirere buerã ñaja yʉama. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Moisés ñamasir'ire ñagõñumi Dios”, yimasiaja yʉa. Mʉre catior'irema masibeaja yʉa. “Tojʉ vadir'i ñagʉ̃mi”, yimasibeaja yʉa, ĩrema —yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","To bajiro ĩna yisere ajiʉcacõari, ado bajiro ĩnare cʉdiyuju ĩ: —Yʉ cajere ĩ ĩarotiboajaquẽne, “Tojʉ vadir'i ñañumi”, yimasibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","“Rojose yirãrema ajibecʉmi Dios. Ĩre rʉ̃cʉbʉocõari, ĩ bojasere yirã rĩrene ajigʉmi Dios”, yimasiaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","“Ĩabecʉ ruyuar'ire sĩgʉ̃ ĩre ĩaroticõañuju” yire ajiyamanicajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yʉre ĩarotigʉma, Dios ĩ cõagʉ̃ me ĩ ñajama, yʉre no yimasibetiborimi —ĩnare yiyuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","To bajiro ĩ yijare, ado bajiro ĩre yiyujarã ĩna: —Rẽmone rojose rãca ruyuar'i ñaja mʉ. To bajigʉ ñaboarine, “Ĩnare gotimasiorʉcʉja yʉ”, ¿yitʉoĩaboati mʉ, yʉare? —ĩre yiyujarã ĩna, ĩabecʉ ñaboar'ire. To yicõa, ĩre bucõañujarã ĩna, Dios ocare ĩna buerivijʉ ñaboagʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ĩabecʉ ñaboar'ire ĩre ĩna bucõasere ajicajʉ yʉa, Jesúrãca. To bajiri ĩre ĩabʉjacõari, ado bajiro ĩre yicami Jesús: —¿Dios ĩ roticõacacʉre ajitirʉ̃nʉati mʉ? —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","To bajiro ĩ yirone, ado bajiro ĩre cʉdicami: —Yʉre gotiya. “Ĩ ñaami”, yiya. Ĩre ajitirʉ̃nʉrʉaja —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","To bajiro ĩ yirone, ado bajiro ĩre cʉdicami Jesús: —Jẽre ĩre ĩaja mʉ. Ĩne ñaja yʉ, ado mʉ rãca ñagõgʉ̃ne —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","To bajiro ĩ yirone, —Yʉ ʉjʉ, mʉre ajitirʉ̃nʉaja yʉ —Jesúre ĩre yicõa, ĩ rĩjorojʉare gʉsomuniari tuetucami, “Ñamasugʉ̃ masune ñaja mʉ” ĩre yirʉ̃cʉbʉogʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","To ĩ yiro bero, ado bajiro masare yicami Jesús: —Ĩamenare bajiro bajirã ñaama Dios ocare ajitirʉ̃nʉmena. “Quẽnaro Diore ajitirʉ̃nʉato ĩna” yigʉ, adi macarʉcʉrojʉre vadicajʉ yʉ. To bajiboarine Diore ajitirʉ̃nʉmena ñaboarine, “ ‘Diore ajitirʉ̃nʉrã ñaja yʉa’ yirãma, rojose tãmʉotʉjabetiriarojʉ varʉarãma ĩna” yigʉagʉ vadicajʉ yʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","To bajiro ĩ yijare, to ñacana fariseo masa sĩgʉ̃ri, Jesúre ĩre sẽniĩacama ĩna: —¿“Dios ocare masimena ñaama ĩna quẽne” yigʉ, yʉare yati mʉ? —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","To bajiro ĩna yirone, —“Dios ocare quẽnaro masibeaja yʉa” mʉa yigotijama, rojose maniboriaroja ti, mʉare. “Jẽre Dios ocare masiaja yʉa” yirã ñari, yʉre mʉa ajitirʉ̃nʉbetijare, rojose ñacõa ñaja mʉare —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Quẽna masare gotimasiogʉ̃ ado bajiro yicami Jesús: —Ñamasusere riojo mʉare gotiaja yʉ. No bojagʉ oveja ĩna ñarisãnirore, sojere sãjabecʉ, soje manijʉrene joresãjagʉ̃ma, juarudirimasʉ o gãjerã yarãre ẽmacudirimasʉ ñagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sojene sãjagʉ̃ma, ĩnare coderimasʉ ñaami. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ovejare coderimasʉre, “Sãjajaro ĩ” yigʉ ĩre soje jãnabosagʉmi, ti sãniro sojere codegʉ. Ĩ sãjatone ĩ oca jedisere ajimasicõarãma ĩna oveja. Ĩna vãmene ĩnare jibugʉmi, ĩnare masigʉ̃ ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ĩnare jibujeocõari, ĩnare rĩjoro cʉti vacʉmi. Ĩ ocare ajimasicõari, ĩre sʉyarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ĩna ajimasibecʉrema sʉyamenama ĩna. Ĩ ocare ajimasibeticõari, ĩre rudirʉarãma ĩna —ĩnare yicami Jesús, masare. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ado bajise ĩnare yigotimasioboacami Jesús. Ĩnajʉama boca ajimasibeticama. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ĩna ajimasibetire masicõari, ado bajiro ĩnare goticami Jesús quẽna: —Ñamasusere riojo mʉare gotiaja yʉ. Yʉ ñaja soje, oveja ĩna sãjarisojere bajiro bajigʉ. Ovejare bajiro bajirã ñaama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yʉ rĩjoro ejariarãma, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃ ñaja yʉ”, yisocariarãma. Ĩna ñaro cõrone juarudirimasare bajiro bajirã ñacoayuma ĩna, yʉre ajitirʉ̃nʉriarãre, “Ajitirʉ̃nʉbeticõaña” yirã. To bajiro ĩnare ĩna yiboajaquẽne, yʉre ajitirʉ̃nʉrãjʉama, ĩnare cʉdibesuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉ ñaja sojere bajiro bajigʉ. No bojarãre yʉre ajitirʉ̃nʉrãre, rojose tãmʉotʉjabetiriarojʉ ĩna vaborotire ĩnare yirẽtobosarʉcʉja yʉ. Ovejare coderimasʉre bajirone quẽnaro ĩnare ĩacoderũgũrʉcʉja yʉ. To bajiri ñie güiose mano quẽnaro ñacõa ñarũgũrʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Juarudirimasa, masare juarudirʉarã, ĩnare sĩama ĩna. Yʉjʉama, “Sĩgʉ̃ rʉyabeto catireayere quẽnaro cʉojedicõato ĩna” yigʉ, vadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yʉ ñaja ovejare quẽnaro coderimasʉre bajiro bajigʉ. Ovejare quẽnaro coderimasʉre ĩre ĩna sĩarʉaboajaquẽne, quẽnaro ĩnare codecõa ñarʉcʉmi. Ĩre bajiro bajigʉ ñaja yʉ. Yʉre ajitirʉ̃nʉrã rojose ĩna yise vajare yʉne ĩnare vaja yibosarocʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sĩgʉ̃, vaja bojagʉ rĩne ĩ moajama, quẽnaro ovejare codetirʉ̃nʉbecʉmi. Buyairo ĩ ejaro ĩacõari, ovejare vaveocoacʉmi ĩ, ĩre rudigʉ. Ĩ yarã oveja me ĩna ñajare, ĩnare vaveocoacʉmi. To bajiri, buyairo jiaejacõari, ovejare ĩnare ãgõbatereacõagʉ̃mi. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Vaja bojagʉ masune moagʉ̃ ñari, ovejare ĩnare maibecʉne, ĩnare vaveorʉcʉmi, ĩ yarã me ĩna ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yʉ ñaja ovejare quẽnaro coderimasʉre bajiro bajigʉ. Dios, yʉ jacʉ yʉre ĩ masirore bajirone yʉ quẽne ĩre masiaja. Tire bajirone yʉre ajitirʉ̃nʉrãre quẽne ĩnare ĩamasiaja yʉ. Ĩnajʉa quẽne, yʉre ĩamasiama ĩna. Ĩnare rijabosarocʉ ñaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yʉre ajitirʉ̃nʉrona, sĩgʉ̃ri, jud'io masa me ñarʉarãma. Ĩnare quẽne ĩnare jirẽorʉcʉja yʉ. Ĩna quẽne yʉre cʉdirʉarãma ĩna. To bajiri cojorʉ̃mʉ cojo masare bajirone bajicõa ñarũgũrʉarãma ĩna, gãmerã ĩamairã. To bajiri yʉ sĩgʉ̃ne quẽnaro ĩnare coderũgũrʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yʉre ajitirʉ̃nʉrãre ĩnare rijabosarʉaja yʉ, “Ĩna rijato berojʉ rojose tãmʉotʉjabetiriarojʉ vatoma ĩna” yigʉ. Yʉ rijato berojʉ quẽna tudicatirʉcʉja yʉ, bajigʉjʉma. Yʉre ajitirʉ̃nʉrãre yʉ rijabosarʉajare, yʉ jacʉ bʉto yʉre maiami. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Masare yʉ rijabosarʉabetijama, no bajiro yicõari yʉre sĩabetiborãma ĩna. Masare yʉ rijabosarʉase ñaja yʉ bojarore bajirone yʉ yiroti. To bajiri, quẽna yʉ tudicatirʉajama, caticoa masiaja yʉ. To bajiro yʉ yimasirotire yʉre cũcami yʉ jacʉ —masare yigoticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","To bajiro ĩ yisere ajicõari, jud'io masa ʉjarã ricatiri rĩne tʉoĩacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jãjarã ĩna rãcana ado bajiro yicama: —Vãti sãñagʉ̃, mecʉrimasʉ ĩ ñaboajaquẽne, ¿no yirã ĩre ajiati mʉa? —ĩnare yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gãjerãjʉama, ado bajiro yicama ĩna: —Vãti sãñagʉ̃ ĩ ñajama, to bajise ñagõbetiborimi; to yicõari, caje ĩamenare quẽne ĩnare ĩarotibetiborimi —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalénjʉ Diore yirʉ̃cʉbʉoriavijʉre ñarãre Diore rʉ̃cʉbʉomenare ĩnare bucõari, ĩna quẽnorere tʉoĩariarʉ̃mʉri ñacajʉ ti, tirʉ̃mʉri. Juebʉcʉrʉ̃mʉri ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","To bajiri Diore yirʉ̃cʉbʉoriavijʉ sãjacõari, Salomón vãme cʉtijacatʉajʉare vacajʉ yʉa Jesúrãca. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","To bajiro yʉa bajiñarone, Jesús tʉjʉ jud'io masa ʉjarã rẽjacõari, ado bajiro ĩre sẽniĩacama: —¿No cõrojʉ, “Ĩ me ñaami. Ĩne ñaami”, mʉre yimasirãti yʉa? “Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i mʉ ñajama, yucʉne riojo yʉare gotiya —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","To bajiro ĩna yisere ajicõari, ado bajiro cʉdicami Jesús: —Jẽre mʉare gotiboaja yʉ. Yʉre ajibeaja mʉa. Yʉ jacʉ ĩ rotisene cojoji me mʉare yiĩocõarũgũboaja yʉ. Tire ĩacõari, “Ĩne ñaami”, mʉare yiroti ñarũgũboaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yʉ yarã me ñaja mʉa, bajirãjʉma. To bajiri yʉre ajitirʉ̃nʉbeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Oveja ĩna ʉjʉ ocare ĩna ajimasirore bajirone yʉ yarã yʉre ajimasiama ĩna. Yʉ quẽne quẽnaro ĩnare masiaja. To bajiri yʉre ajitirʉ̃nʉ sʉyaama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dios ĩ catisere ĩnare ĩsiaja yʉ. To bajiri nijʉane yʉre jicãmoto ecobetirʉcʉmi. To bajiri, ĩna rijato berojʉ, quẽna tudicatijedicõari yʉ rãca quẽnaro ñacõa ñarũgũrʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","“Ĩnare cʉoato” yigʉ, yʉ jacʉ yʉre cũcami. Nijʉane ĩ rẽtoro masigʉ̃ magʉ̃mi. To bajiri nijʉane yʉre jicãmoto veomasibetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉ, yʉ jacʉ rãca sĩgʉ̃ne ñaja yʉa —yicami Jesús, jud'io masa ʉjarãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","To bajiro ĩ yirone, gʉ̃tarire juacama ĩna, ĩre rearʉarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","To bajiro ĩna yisere ĩacõari, ado bajiro ĩnare yicami Jesús: —Yʉ jacʉ ĩ masisene cojoji me mʉa ĩaro rĩjorojʉa ĩaĩañamanire yiĩorũgũmʉ yʉ. ¿Di vãme yʉ yiĩosere ĩacõari, “Rojose yigʉ yami” yirã, gʉ̃tane yʉre rearʉati mʉa? —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","To bajiro ĩ yirone, ado bajiro ĩre cʉdicama ĩna jud'io masa ʉjarã: —Ĩaĩañamanire mʉ yiĩose sʉori me gʉ̃ta rãca mʉre rearʉarãja yʉa. Rujajine Diore mʉ yise vaja mʉre rearʉarãja yʉa. Yʉare bajiro masʉ ñaboarine, “Dios ñaja yʉ”, yiboaja mʉ —ĩre yicama ĩna, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","To bajiro ĩna yijare, ado bajiro ĩnare yicami Jesús: —“‘Yʉre bajiro bajirã ñaja mʉa’ yiyumi Dios”, yiucamasire ñaja, mʉa ñicʉa ĩna rotimasire. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Dios ocare masa ĩna ucamasire riojo ñamasuse ñaja”, yimasiaja mani. “Ĩ ocare ajitirʉ̃nʉrãre, ‘Yʉre bajiro bajirã ñaja mʉa’ yiyumi Dios”, yimasiaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Mʉ sĩgʉ̃ne ñaja mʉ, yʉre bajiro bajigʉ” yigʉ, adi macarʉcʉrojʉre yʉre cõacami Dios. To bajiro ĩ yicacʉ yʉ ñaboajaquẽne, “Dios macʉ ñaja yʉ” yʉ yirone, ¿no yirã, “Diore yiajegʉ yaja mʉ”, yʉre yati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ jacʉ ĩ yirore bajirone yʉ yibetijama, yʉre ajitirʉ̃nʉbesa. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉ jacʉ ĩ yirore bajirone yʉ yijama, yʉre ajitirʉ̃nʉbetiboarine, yʉ yiĩosere ĩacõari, “Dios macʉ ñaami”, yitʉoĩaroti ñaja mʉare. To bajiri, “Yʉ jacʉ rãcane ñaja yʉ. Ĩ quẽne yʉ rãcane ñaami” yʉ yigotimasiosere ajicõari, “Riojo gotiami”, yʉre yimasirona ñaja mʉa —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","To bajiro ĩ yisere ajicõari, ĩre ñiarʉaboacama ĩna. Jesújʉama boca rudicoacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","To bajivacʉ, Jordán vãme cʉtirisa gajejacatʉajʉ yʉare ũmato jẽacoacami Jesús. Tojʉ ejacõari, masare oco rãca Juan ĩ bautiza ñacatojʉre tujacajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tojʉre jãjarã masa ĩre ĩarã ejacama. Jesúre ĩre ĩacõari, ado bajiro gãmerã yicama ĩna: —Ĩaĩañamanire yiĩobetiboarine, jediro Jesús ĩ bajisere gotigʉ, socʉ mene gotiyumi Juan —gãmerã yicama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tojʉre jãjarã masu, Jesúre ĩre ajitirʉ̃nʉ sʉyasʉocama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Sĩgʉ̃ ñacami Lázaro vãme cʉtigʉ. Ĩ bederã rõmiri ñacama Mar'ia, gajeo Marta. Ĩna ñacama Betania vãme cʉti macana. Mar'ia ñacamo so, Jesús gʉborire sʉtiquẽnase tucõari so joa ñajone vejacarocaco. Bʉto rijayuju Lázaro. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro ĩ rijaro ĩacõari, ĩ bederã rõmiri Jesúre ĩre oca cõañuma ĩna: —Mʉ baba Lázaro bʉto rijami —ĩre yi oca cõañuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tire ajicõari, ado bajiro yʉare yicami Jesús: —Rijaye ĩre sĩabetoja. “‘Quẽnarẽtogʉ̃ ñaami Dios. Ĩ cõrone quẽnagʉ̃ ñaami ĩ macʉ quẽne’ yirʉ̃cʉbʉorãjaro masa” yigʉ, rijagʉ bajigʉmi —yʉare yicami Jesús. “Ĩre rijaye ĩre sĩabetoja” yigʉ, “Rijayayicõa tʉjabetirʉcʉmi” yirʉne yicõañumi. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lázarore, ĩ bederã rõmiri Martare, to yicõari, Mar'iare quẽne ĩnare maicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","To bajiboarine, “Bʉto rijami Lázaro” ĩna yisere ajiboarine, vabeticami Jesús maji. Tone yʉa ñacatone jʉarʉ̃mʉ ñacõacajʉ yʉa maji, Jesúrãca. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","To baji, jʉarʉ̃mʉ bero yʉare ĩ buerãre ado bajiro yʉare yicami Jesús: —Ita quẽna, Judea sitajʉ. Lázaro ĩ ñarojʉ vajaro mani —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","To bajiro ĩ yisere ajicõari, ado bajiro ĩre sẽniĩacajʉ yʉa: —Cãnʉbʉsane toana jud'io masa ʉjarã gʉ̃ta rãca mʉre rearʉacama ĩna. ¿Tojʉre quẽna tudivaroti tʉoĩati mʉ, yʉare gotimasiogʉ̃? —ĩre yisẽniĩacajʉ yʉa, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","To yʉa yirone, ado bajiro yʉare cʉdicami Jesús: —Adi macarʉcʉrojʉre mani catiro cõro quẽnaro cõĩamasiami Dios. Ĩ bojaro cõro catirʉarãja mani. No bojarã Diore masirã, Dios ĩ bojasere yitʉjabeama, yʉre ajitirʉ̃nʉrã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Diore masimenajʉama, Dios ĩ bojasere yirʉabeama, yʉre ajitirʉ̃nʉmena ñari —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tire yʉare goticõa, quẽna gajeye yʉare gotirẽmocami: —Mani baba Lázaro, cãnicoarimi. To bajiri ĩre yujiogʉacʉ yaja yʉ —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","To bajiro ĩ yijare, ado bajiro ĩre yicajʉ yʉa: —Cãnigʉ̃ ĩ bajijama, caticoarʉcʉmi —ĩre yicajʉ yʉa, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","“Cãnigʉ̃ bajigʉmi” Jesús ĩ yisere ajicõari, “Ĩ ʉsʉsãjarere yigʉmi”, yicõacajʉ yʉa. To bajiro yʉa yitʉoĩaboajaquẽne, Jesújʉama, “Bajirocacoarimi” yirʉne yicõañumi Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","To bajiri, “Yʉre quẽnaro ajimasibeama ĩna” yigʉ, riojo yʉare goticami Jesús: —Lázaro bajiyayicoarimi —yicami yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","—Variquẽnaja. Quẽnaro ĩ tʉjʉre vabejʉ yʉ, “Riojo Dios macʉne ñaami” mʉa yirʉ̃cʉbʉorotire yigʉ. To bajiri, ita. Ĩato, Lázarore —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jesús buerimasʉ yʉa rãcagʉ, Tomás vãme cʉtigʉ ñacami. Cojoji ruyuarãne, jʉarã ruyuar'i yʉa yicacʉ ñacami. Ado bajise yʉare yicami: —Ita mani quẽne. Jesúrãcane bajiyayirãsa —yʉare yicami Tomás. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","To bajiri, Betaniajʉ yʉa ejarone, —Babarirʉ̃mʉri tʉsajʉ, Lázarore ĩna yujero bero —yʉare yigoticama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalén macajʉ ñacõari, vajama, tres kilómetros vaejariaro ñacajʉ Betania maca. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jerusalén maca vadiriarã jud'io masa jãjarã ejayuma, Lázaro ĩ bajirocajare otirã. “Quẽnabeti bajiaja ti mʉa gagʉ ĩ bajiyayise” Martare, to yicõari Mar'iare quẽne yiotirã ejayuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","To bajiro ĩna yiñarone, “Vadiami Jesús” ĩna yisere ajicõari, yʉare bocago, vadicoayumo Marta. To so bajiro ũnone, so bedeo, Mar'iajʉama, vadibesumo. Vijʉne ñacõañumo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesús tʉjʉre ejacõari, ado bajiro ĩre yicamo Marta: —Yʉ ʉjʉ, adone mʉ ñajama, yʉ gagʉ bajiyayibetiborimi. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ĩ bajirocato bero ti ñaboajaquẽne, “Diore mʉ sẽnijama, mʉ sẽnirore bajirone mʉre cʉdirʉcʉmi Dios”, yimasiaja yʉ —Jesúre ĩre yicamo so, Marta. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","To so yisere ajicõari, —Mʉ gagʉ quẽna caticoarʉcʉmi —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","To bajiro ĩ yijare, —Socʉ me yaja mʉ. Ñatʉsarirʉ̃mʉ masare Dios ĩ catiorirʉ̃mʉjʉ, quẽna caticoarʉcʉmi yʉ gagʉ —ĩre yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","To so yisere ajicõari, ado bajiro sore yicami Jesús: —Yʉ ñaja masare catiogʉ masuma. No bojarã yʉre ajitirʉ̃nʉrãma bajiyayicoaboarine, quẽna tudicaticõarʉarãma ĩna. To ĩna bajiro bero, jʉaji tudirijabetirʉarãma. ¿Tire ajitirʉ̃nʉati mʉ quẽne? —Martare sore yisẽniĩacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","To bajiro ĩ yisere ajicõari, —“Yʉ ʉjʉ, mʉ yirore bajirone bajiaja ti. Mʉne ñaja, ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i, masa ñajediro ʉjʉ. Dios macʉne ñaja mʉ, adi macarʉcʉrojʉre vadir'i”, mʉre yimasiaja yʉ —Jesúre ĩre yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","To yicõa, so bedeore Mar'iare, sore jigo, tudicoacamo Marta. So tʉjʉre ejacõari, ado bajiro Mar'iare sore gotirudiyuju so, yayioroaca: —Manire gotimasiorimasʉ tone ñaami. “Vadiato”, mʉre yimi —sore yiyuju Marta, so bedeore. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","To sore so yigoticõarojʉma, guaro vʉ̃mʉ budi vadicoayumo so Mar'ia, Jesúre ĩre ĩagoago. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesúrãca ti macajʉre ejabeticajʉ yʉa maji. Marta yʉare so bocacatojʉne ñacõacajʉ yʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mar'ia rãca ñañuma ĩna jud'io masa, so gagʉ ĩ bajiyayijare otirã. To bajiri Mar'ia guaro so vʉ̃mʉ vado ĩacõari sore sʉyayuma ĩna quẽne. “Masa boero tʉjʉ otigo, vaco bajigomo” yirã baji ruyuyuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mar'ia, Jesús tʉjʉ ejacõari, ĩ gʉbori tʉjʉ gʉsomuniari tuetucamo so, ĩre rʉ̃cʉbʉogo. To yicõari, ado bajiro ĩre yicamo so: —Yʉ ʉjʉ, cãnʉjʉ mʉ ejajama, yʉ gagʉ bajiyayibetiborimi —Jesúre ĩre yicamo so, Mar'ia. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mar'ia so otisere ĩacõari, so rãca vadicana jud'io masa quẽne ĩna otisere ĩacõari, Jesús, bʉto sʉtiriticami. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","To bajicõari ĩnare sẽniĩacami Jesús: —¿Nojʉ ĩre yujemasiri mʉa? —ĩnare yisẽniĩacami Jesús. To bajiro ĩ yirone, —Adojʉa ĩagʉ̃ vadiĩasa yʉa ʉjʉ —ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","To bajiro ĩre ĩna yirone, oticami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jesús ĩ otisere ĩacõari, ado bajiro yicama ĩna jud'io masa, sĩgʉ̃ri: —Ĩaĩasaque. Lázarore bʉto ĩre maiboayumi —gãmerã yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","To bajiro ĩna yirone, gãjerã sĩgʉ̃ri ado bajiro yicama: —Caje ĩabecʉre ĩaroticacʉ ñaboarine, ¿no yigʉ Lázarorema, “Rijabeticõato”, yimasibesujari? —gãmerã yicama ĩna sĩgʉ̃ri, to ñacodecana. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bʉto sʉtiritigʉne, ejarʉ̃gʉ̃cami Jesús, Lázaro masa boero tʉjʉre. Gʉ̃tavi ñacajʉ ti, bajirocar'ire ĩna yujeriajʉ. Gʉ̃tane bibe ecoyuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tojʉre ejagʉne, —Gʉ̃tare tũnuo gocõaña —ĩnare yicami Jesús. To bajiro ĩ yirone ado bajiro ĩre yicamo so, Marta, Lázaro ñaboar'i bedeo: —¡Yʉ ʉjʉ, majique! Babaricãrãcarʉ̃mʉ tʉsacoajʉ ĩ bajiyayiro bero. Jẽre ʉ̃ni sʉticoacʉmi —Jesúre yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","To so yiboajaquẽne, ado bajiro sore yicami Jesús: —Yʉre mʉ ajitirʉ̃nʉjama, rẽtoro ñamasusere Dios ĩ yimasisere ĩarʉocoja mʉ, mʉre yibʉ yʉ —sore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","To bajiri yuja, gʉ̃tare tũnuogocama masa. Ĩna tũnuogorone, õ vecajʉare ĩamʉocõari, ado bajiro yicami Jesús: —Cacʉ, “Quẽnaja” mʉre yaja, yʉre mʉ ajise ñajare. Tocãrãcajine mʉre yʉ sẽniro ajirũgũaja mʉ. To bajiri, “ ‘Dione ñaami Jesúre ĩre cõar'i’ yimasiato ĩna” yigʉ, ĩna ĩaro rĩjorojʉa yʉ yimasirotire mʉre sẽniaja yʉ —Diore yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","To yigajanogʉ̃ne, tutuase avasãcami Jesús yuja: —Lázaro, budiaya mʉ —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","To bajiro ĩ yirone, bajirocar'ire ĩna yujer'i ñaboarine, budicoadicami Lázaro. Ĩ ricarire to yicõari, ĩ rujʉre quẽne sudine dʉrear'i ñacami. Ĩ gʉbori, ĩ rʉjoa quẽne sudine gũmar'i ñacami. To bajiri, —Ĩre õjaña mʉa. Vajaro ĩ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","To bajiro Jesús ĩ yiĩosere ĩacõari, jãjarã jud'io masa, Mar'iare baba cʉticana, Jesúre ĩre ajitirʉ̃nʉ sʉyasʉocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gãjerãma, Jesús ĩ yiĩosere ĩacõari, fariseo masare gotirã vasujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ĩna gotisere ajicõari, fariseo masa, paia ʉjarã rãca rẽjañujarã ĩna. Rẽjacõari, jud'io masa ʉjarãre, Dios ĩ rotimasire gotimasiorimasare quẽne jirẽocõañujarã ĩna. To bajiri ĩna rãca ado bajiro gãmerã ñagõñujarã ĩna: —¿No bajiro ĩre yirãti mani? Bʉto masune ĩaĩañamanire yiĩogʉ̃ yami. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","To bajirone ĩre mani yiboa tʉjajama, masa jediro ĩre ajitirʉ̃nʉrʉarãma. To bajicõari, Diore yirʉ̃cʉbʉoriavire caguereacõarʉarãma romano masa. To yicõari mani ñarimacarire reajeocõarʉarãma ĩna —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ti cʉ̃mare paia ʉjʉ ñamasugʉ̃ Caifás vãme cʉtigʉ ñacami. To bajiro ĩna yisere ajicõari, ado bajiro ĩnare gotiyuju ĩ: —Masibeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mani ye jedirore ĩna reajama, quẽnabetoja. To bajiri ĩaĩañamanire yiĩogʉ̃, manire rijabosato ĩ —yiyuju Caifás. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Ĩ masurione to bajise tʉoĩacõari, yibesuju Caifás. Paia ʉjʉ ñamasugʉ̃ ñari, Dios sʉorine to bajiro gotiyuju, Jesúre ĩre sĩarʉagʉ ñaboarine. “Jud'io masa rĩrene ĩnare rijabosabetirʉcʉmi Jesús. No bojarã Jesúre ĩre ajitirʉ̃nʉrona Dios rĩa ñaronare adi macarʉcʉroanare ĩnare rijabosarʉcʉmi Jesús” yimasibecʉ ñaboajaquẽne, ĩ tʉoĩasere Caifáre cõañuju Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","To bajiri, Caifás ĩ gotiriarʉ̃mʉne, “¿No bajiro yicõari Jesúre ĩre sĩarãti mani?”, gãmerã yisʉoyujarã ĩna, jud'io masa ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","To bajiri, jud'io masa ĩna ñarorema ñacudibeticami Jesús yuja. To ñabecʉne, yucʉ́ manojʉ ñarimaca, Efra'in vãme cʉti macajʉa yʉare ũmato vacoacami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pascua boserʉ̃mʉ ĩna yiroto mojoroaca rʉyacoadicajʉ ti. To bajiri, jãjarã masa vacama Jerusalénjʉ, “‘Rojose mana ñaja mʉa yuja’ manire yiĩato Dios” yirã, paia ĩna yirotirere yirã vana. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tojʉre ejacõari, Jesúre macaboayujarã ĩna. Ĩre macaboana, Diore yirʉ̃cʉbʉoriavijʉre ejacõari ado bajiro gãmerã sẽniĩañujarã ĩna, Jesús ĩ ejabetijare: —¿Mʉma no bajiro tʉoĩati mʉ? ¿Boserʉ̃mʉ vadibetimasucõagʉ̃ yiguida? —gãmerã yiyujarã ĩna, Jesús ĩ ejabetijare. ");
INSERT INTO bsnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo masa, to yicõari, paia ʉjarã quẽne, “Jesúre mʉa ĩabʉjajama, yʉare gotiba. Ĩre ñiarʉarã yaja yʉa”, yiyujarã ĩna, masare. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cojomo cõro, coja jẽnituarirʉ̃mʉri Pascua boserʉ̃mʉ ñaroti ti rʉyarũtuato Betania vãme cʉti macajʉ vacajʉ yʉa, Jesúrãca. Lázaro ĩ ñarimaca ñacajʉ ti maca Betania. To ñacajʉ Lázarore, bajirocaboar'irene Jesús ĩre ĩ catiocato. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesús ĩ ejaro ĩacõari, ĩre rʉ̃cʉbʉorã ĩre bare quẽnoecacama toana rõmiri. Lázaro bedeo, Marta ñacamo, yʉare bare jeogo. Lázaro quẽne ñacami, yʉa rãca bagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yʉa bañarone sʉtiquẽnase nardo vãme cʉtisere ãmiejacamo Lázaro bedeo ñatʉsago, Mar'ia vãme cʉtigo. Trescientos gramos cõro ñacajʉ ti. Jairo vaja cʉtise ñacajʉ. Tine Jesús gʉborire yuetucamo so. Yuetucõari so joa ñajone tire vejacarocamo so. Vi jʉ̃mʉrone sʉtijʉ̃mʉcoacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tone ñacami Judas Iscariote quẽne. Ĩ quẽne yʉare bajirone Jesús buegʉ ñacami. Ĩ ñañumi Jesúre ĩaterãre ĩsirocarocʉ. Jesús gʉborire so yueturo ĩacõari, ado bajiro sore yicami: ");
INSERT INTO bsnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Tire sʉtiquẽnasere ĩsicõari, trescientos ñaritiiri juaroco ñaboayumo so. Ti vaja juacõari, maioro bajirãre ĩnare mani ĩsijama, quẽnaboyuja ti —sore yicami Judajʉama. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Maioro bajirãre maibetiboarine to bajiro yicõacami ĩ. Juarudirimasʉ ñari to bajise yicami ĩ. Ĩ ñarũgũcami yʉa gãjoare juabosarimasʉ. To bajiro yica yigʉne yʉa gãjoare juarudicõarũgũñumi ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","To bajiri Judas to bajise sore ĩ yijare, ado bajiro ĩre yicami Jesús: —Tone yicõato. Yʉre ĩna yujeroto rĩjoro yuejeo rĩjoro cʉtigo yamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maioro bajirã mʉa rãca ñacõa ñarũgũrʉarãma, mʉa ejarẽmorona. Yʉma, mʉa rãca ñacõa ñabetirʉcʉja —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","“Betania macajʉ ñaami Jesús” ĩna yisere ajicõari jud'io masa jãjarã ejacama. Jesús sĩgʉ̃rene ĩre ĩarã ejarã me, bajicama ĩna. Lázarore, Jesús ĩ catior'ire ĩarã rãcane vayuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lázarore quẽne sĩarʉayujarã ĩna paia ʉjarã, ĩre Jesús ĩ catiore sʉorine, jãjarãbʉsa Jesújʉare ajitirʉ̃nʉ sʉyacõari, ĩnare ĩna cãmotadise ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Jerusalénjʉ Pascua boserʉ̃mʉ ĩna yiñarore ĩarã, jãjarã masa ejayuma ĩna. To bajiri Mar'ia Jesúre so yuetucatirʉ̃mʉ beroagarʉ̃mʉ ñacajʉ tirʉ̃mʉma. To bajiri tirʉ̃mʉrene Jesús ĩ ejarotire ajicõari, jejejũ ũni rujañoquerire jasurejuacõari Jesúre bocacama. Ĩre bocarã, ado bajiro yiavasã variquẽnacama ĩna: —¡“Rotimʉorʉ̃gõrʉcʉmi” yigʉ, Dios ĩ cõar'i ñaami! ¡Quẽnase ĩre yivariquẽnato mani! ¡Diore rotibosagʉ quẽnaro ĩ yigʉ ñaami! —Jesúre ĩre yiavasã variquẽnacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","To bajiro ĩna yi vatone, burro vãme cʉtigʉre ĩre bʉjacõari, ĩre vajejacami Jesús, “To bajirone bajirʉcʉmi” Dios oca, masa ĩna yiucamasire ñajare. Ado bajiro yiucamasiñuma ĩna: ");
INSERT INTO bsnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mʉa Jerusalén macana, güibetirʉarãja mʉa. Mʉa ʉjʉ ñarocʉ burro vãme cʉtigʉ joejʉ jesacõari, vadirʉcʉmi”, yiucamasiñuma. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Maji to bajiro ĩna yiucamasirere ajimasibeticajʉ yʉa, ĩ buerimasa. Jesús masare rijabosacõari Dios ĩ ñarojʉ ĩ tudimʉjato bero, “Dios ocare masa ĩna ucamasire, Jesús ĩ vadirotirene gotiyuja ti”, yimasicajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jẽre ĩna yujerijʉre Lázarore Jesús ĩ catiocatire ĩacana, masa jedirorene gotibatocõañuma. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","To bajiri, ĩaĩañamanire Jesús ĩ yiĩocatire ajicõari Jesúre ĩarã ejacama jãjarã masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","To bajiro masa ĩna yisere ĩacõari fariseo masa ĩna masune gãmerã ñagõñujarã ĩna: —Ĩaña. Masa jediro ĩ ocare ĩre ajitirʉ̃nʉama ĩna yuja. No yiriaro maja mani —gãmerã yiyujarã fariseo masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua boserʉ̃mʉre Jerusalénjʉ Diore rʉ̃cʉbʉorã vana rãca sĩgʉ̃ri vʉsacama griego masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Felipere sẽniĩarã ejayujarã ĩna. Galilea sita Betsaida vãme cʉti macagʉ ñacami Felipe. Jesús buegʉ ñacami ĩ quẽne. Ado bajiro Felipere yiyujarã ĩna: —Jesúrãca ñagõrʉaja yʉa —Felipere ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","To bajiro ĩna yisere ajicõari, Andrére ĩre gotigʉ vasuju Felipe. To bajiri ĩna jʉarã Jesúre gotirã ejacama, yʉa tʉjʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ĩna gotisere ajicõari, ado bajiro yicami Jesús, ĩnare: —Yʉ ñaja Dios ĩ roticõacacʉ. Yʉre ĩna sĩarotirʉ̃mʉ cõñaja ti. Yʉre ĩna sĩaro bero, “Rẽtoro quẽnagʉ̃ ñaami”, yʉre yimasirʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ñamasusere riojo mʉare gotiaja yʉ: Yʉ rijabosabetijama, masa ñajediro, Diorãca quẽnaro ñabeticõari, ĩna bajirearo bero, rojose tãmʉotʉjabetiriarojʉ varʉarãma. Trigo aje oteriarore bajirone bajiaja ti. Trigo ajea, sita ẽñeroca tiare ĩna coacũbetijama, judibetoja ti. Tiare ĩna coacũjama, judicõari, jairo rica cʉtirʉaroja ti. To bajirone bajirʉaroja yʉre quẽne. Yʉre ĩna yujejare, yʉ sʉorine ĩna rijato bero quẽnaro catijedicõa ñarũgũrʉarãma jãjarã yʉre ajitirʉ̃nʉrona. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","No bojarã, no ĩna bojarone ñare cʉtirãma adi macarʉcʉro ñasere ĩavariquẽnacõari, Diore tʉoĩamenama, Dios ĩ catisere cʉomena ñarʉarãma ĩna. To bajiboarine, yʉre ajitirʉ̃nʉrã, “Ĩ oca yʉa gotise ñajare, yʉare ĩna sĩacõajama, quẽnacõaroja” yirãma, Dios ĩ catisere cʉorã ñarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","No bojagʉ yʉ bojasere yirʉagʉ, quẽnaro yʉre ajitirʉ̃nʉ sʉyaroti ñaja. To bajiro bajigʉma, yʉ rãca ñacõa ñarũgũrʉcʉmi. To bajiro bajigʉrema quẽnaro ĩre rʉ̃cʉbʉorʉcʉmi yʉ jacʉ —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","To bajiro yicõari, ado bajiro ñagõcami Jesús quẽna: —Bʉto tʉoĩasʉtiritiaja yʉ. ¿No bajiro yigʉti yʉ? ¿“ ‘Cacʉ rojose tãmʉoromi’ yigʉ, yʉre matabosaya”, yigʉti yʉ? To bajiro yibetirʉcʉja yʉ. Tire tãmʉorʉne vadicacʉ ñaja yʉ —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","To bajiro yicõa, Diojʉare sẽnicami yuja: —Cacʉ, mʉ bojarore bajirone bajiato. Masa mʉre rʉ̃cʉbʉorãjaro —Diore ĩre yicami Jesús yuja. To bajiro ĩ yirone, õ vecajʉ ocaruyucajʉ: —Mʉ sʉori “Masa quẽnaro yʉre yirʉ̃cʉbʉoato” yigʉ, yicoadicajʉ yʉ. To bajiri, yirʉcʉja yʉ quẽna, mʉ bajirotire —yi ocaruyucajʉ õ vecajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tire ajirãne, —Bʉjo ñaromi —yicajʉ yʉa sĩgʉ̃ri. Gãjerãma: —Ángel ĩre ñagõgʉ̃ yiromi —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","To bajiro masa ĩna yisere ajicõari, ado bajiro yicami Jesús: —“Yʉre yiro me”, yi ocaruyuaja ti. Mʉare “Ajiato” yiro, yaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yucʉacane rojose yʉre yirãre ĩabesesʉorʉcʉmi Dios. To bajiro ĩ yisʉorone masare ĩnare rojose yirotigʉre yirẽtorʉ̃gʉ̃rʉcʉja yʉ. To yʉ yirone, masare ĩ rotirũgũboasere rotimasibetirʉcʉmi ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yucʉ́tẽrojʉ masa yʉre ĩna jajutuse sʉorine masa ñajediro ʉjʉ ñarʉcʉja yʉ yuja. To bajiro yʉ bajise sʉorine, “Dios macʉ, yʉ ʉjʉ ñarʉcʉja mʉ, mʉ masise rãca yʉre ejarẽmorocʉ”, yirʉarãma jãjarã adi macarʉcʉroana. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","To bajiro ĩ yijama, “Ado bajiro sĩaecorʉcʉja” yigʉ yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","To bajiro ĩ yijare, ado bajiro ĩre cʉdicama masa: —Dios ocare masa ucamasire ti gotijama, “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõarocʉ bajirocabetirʉcʉmi”, yigotiaja ti. To bajiro ti yigotiboajaquẽne, ¿no yigʉ, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõagʉ̃re yʉre jajuturʉarãma ĩna”, yati mʉ? ¿Ñimʉjʉa Dios ĩ roticõar'i masuma ñati? —Jesúre ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","To bajiro ĩna yijare, ado bajiro cʉdicami Jesús: —Yʉ sʉorine riojo ñamasusere masiama masa, ĩna masirʉajama. Yoaro mene mʉare vaveogʉagʉ yaja yʉ. To bajiri yʉre quẽnaro ajitirʉ̃nʉtʉsaya mʉa, “Ĩ yirore bajirone yirãsa mani” yirã. To bajise mʉa yijama, rojose tãmʉotʉjabetiriarojʉ vabetirʉarãja mʉa. Diore masimenajʉama, rojose tãmʉotʉjabetiriarojʉ ĩna varotire masibeama. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","To bajiri, mʉa rãca yʉ ñarone yʉre ajitirʉ̃nʉña, “Ĩre bajirone Diore masicoarʉarãja mani” yirã —ĩnare yicami Jesús. To bajiro masare ĩnare yigotigajanocõa, ĩna masibetojʉa vacõari, ĩnare yayicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús, jairo ĩaĩañamanire ĩnare ĩ yiĩoboajaquẽne, ĩre ajitirʉ̃nʉbeticama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","“To bajiro bajirʉaroja ti” Isa'ias ñamasir'i, ĩ yimasire ñajare, bajicajʉ ti. Ado bajiro yiucamasiñumi: “Yʉa ʉjʉ, mʉre yʉa gotirẽtobosasere ajiboarine, to yicõari, mʉ yiĩosere ĩaboarine, mʉre ajitirʉ̃nʉgʉ̃ maami”, yiucamasiñumi Isa'ias ñamasir'i. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Dios ĩ cõarocʉre ajitirʉ̃nʉbetironare yigʉ ado bajiro ucamasiñumi Isa'ias ñamasir'i quẽna: ");
INSERT INTO bsnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ĩre ĩna ajitirʉ̃nʉbeti vaja ĩna masiboasere ĩnare masiriojeocõarʉcʉmi Dios. To bajiro ĩ yise ñajare, ĩre ajimasibetirʉarãma. Riojo ĩna ajimasijama, rojose ĩna yirũgũsere tʉoĩasʉtiriticõari, tʉoĩavasoaborãma ĩna. Yʉre ĩna sẽnijama, yʉre ĩna cãmotadicõa tʉjaborotire ĩnare yirẽtobosabogʉja yʉ, yigotiami Dios”, yiucamasiñumi Isa'ias ñamasir'i. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","“Cristo rẽtoro ñamasugʉ̃ maami” Dios ĩ yiĩosere ĩacõari, to bajiro yiucamasiñumi Isa'ias. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","“To bajiro bajirʉaroja” Isa'ias ĩ yiucamasire ñaboajaquẽne jãjarã jud'io masa, to yicõari ĩna ʉjarã quẽne sĩgʉ̃ri Jesúre ĩre ajitirʉ̃nʉcama ĩna. To bajirã ñaboarine, masa ĩna ajiro rĩjorojʉa, “Jesúre ajitirʉ̃nʉrã ñaja”, yibeticama ĩna bajirãjʉma, fariseo masa, “Jesúre ajitirʉ̃nʉrãre sãjarotibetirʉarãja mani, Dios ocare mani buerivijʉre” ĩna yire ñajare. To bajiri ĩnare güirã, “Yʉare masiroma” yirã, tire gotibeticama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","To bajiro yirã ñari, Dios ye rẽtobʉsaro masa yejʉare rʉ̃cʉbʉorere bojacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ruyugoaro goticami Jesús: —Yʉre ajitirʉ̃nʉrãma, yʉ sĩgʉ̃rene ajitirʉ̃nʉrã me yama. Yʉ jacʉ yʉre cõacacʉre quẽne ajitirʉ̃nʉrã yama. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yʉre ĩarãma, yʉ jacʉre quẽne ĩarã yama. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉ sʉorine Diore masiama masa. Adi macarʉcʉrojʉre vadicajʉ yʉ, “Yʉre ajitirʉ̃nʉcõari, rojose yitʉjato” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yʉ ocare ajiboarine yʉre ĩna ajitirʉ̃nʉbetijama, yʉ me ñaja rojose tãmʉotʉjabetiriarojʉ ĩnare cõarocʉma. Adi macarʉcʉroanare rojose yigʉagʉ vadicacʉ me ñaja yʉma. Yʉre ajitirʉ̃nʉrãre ĩna ñaro cõrone rojose tãmʉotʉjabetiriarojʉ ĩna vaborotire ĩnare yirẽtobosagʉagʉ vadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","To bajiboarine, yʉre rʉ̃cʉbʉobeticõari, yʉ ocare ajitirʉ̃nʉmenama, ñatʉsarirʉ̃mʉ rojose tãmʉotʉjabetiriarojʉ varʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉ masurione tʉoĩacõari, tire gotigʉ me yaja yʉ. Yʉ jacʉ yʉre cõacacʉ ĩ gotirotise rĩne gotiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Yʉ jacʉ ĩ rotisere ĩna ajitirʉ̃nʉjama, ĩna rijato berojʉ, tudirijabeticõari, yʉ rãca quẽnaro ñacõa ñarũgũrʉarãma ĩna”, yimasiaja yʉ. To bajiri yʉ gotijama, yʉ jacʉ yʉre ĩ yirotirore bajirone gotiaja yʉ —masare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Pascua boserʉ̃mʉ yʉa batʉsaroto rĩjoro, jẽre, “Yʉ jacʉ tʉjʉ adi macarʉcʉrore yʉ vaveoroto mojoroaca rʉyaja yuja”, yimasicõacami Jesús. Simón macʉre, Judas Iscariotere, “Jesús vajanare ĩnare ocasãrʉcʉja yʉ, ‘Ĩre ñiato ĩna’ yigʉ” yirere ĩre cõañumi ĩ, vãtia ʉjʉ. Jẽre tire masicõañumi Jesús. “Dios tʉjʉ vadicacʉ ñaja yʉ. To bajiri ĩ tʉjʉ quẽna tudiarʉcʉja yʉ. Rẽmojʉne, ‘No yiyamagʉ̃ ñaja mʉ. No mʉ bojasere yimasiaja mʉ’ yʉre yicoadicami Dios”, yimasicõacami Jesús. Rẽmojʉne adi macarʉcʉroanare, ĩre ajitirʉ̃nʉcanare, yʉare maicoadicami “Mʉare maimasucõaja yʉ” yigʉ, ado bajiro bajicami Jesús adi macarʉcʉrojʉre ĩ ñatʉsacatirʉ̃mʉri. Tire mʉare gotigʉagʉ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yʉa batʉsañarone, vʉ̃mʉrʉ̃gʉ̃cõari, joeado ĩ sãñaritore veacami Jesús. To yicõari, ĩ rujʉ gʉdarecore toallare siatucami. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","To yicõari, rujabajajʉ ocore jiocami. Jiojeo, yʉa gʉborire coecami Jesús. Coecõari, toalla rãca yʉa gʉborire carocami. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pedro gʉborire ĩ coegʉadone, ado bajiro ĩre boca yicami: —¿Yʉ ʉjʉ ñaboarine, yʉ gʉborire coegʉagʉ yati mʉ? —yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","To bajiro ĩ yijare, ado bajiro ĩre cʉdicami Jesús: —Yucʉacarema mʉa gʉborire yʉ coesere tʉoĩamasibeaja mʉa maji. Bero tire ajimasirʉarãja mʉa —yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","To bajiro ĩ yiboajaquẽne: —Yʉ gʉborire coebetirʉcʉja mʉ —Jesúre ĩre yicami Pedro. To bajiro ĩ yirone, —Mʉ gʉborire yʉ coebetijama, yʉ rãcagʉ me ñarʉcʉja mʉ —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdicami Pedro: —To mʉ yiro ũnoma yʉ gʉbori rĩne coebesa. Yʉ ãmorire quẽne, yʉ rʉjoare quẽne coeya —Jesúre ĩre yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdicami Jesús: —Jẽre guacõar'irema, jediro ĩ rujʉre coere maja. Gʉbori rĩne coejama, quẽnaja. Ʉeri manare bajiro bajirã ñaja mʉa. To bajiboajaquẽne sĩgʉ̃ ñaami mʉa rãcagʉ ʉeri cʉtigʉre bajiro bajigʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","“Ĩ ñaami yʉre ĩsirocarocʉ” yimasicõari, “Mʉa jedirone ʉeri mana ñajedicõa bajibeaja mʉa”, yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yʉa gʉborire coegajanocõari, quẽna ĩ veacũcatiasere sãñacami Jesús. To yigajano, quẽna gãme ejarũjucõari ado bajiro yʉare goticami Jesús: —¿Mʉa gʉborire yʉ coesere ajimasiati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Yʉare gotimasiogʉ̃, yʉa ʉjʉ”, yʉre yaja mʉa. Ĩ masune ñaja yʉ. To bajiro yʉre mʉa yijama, quẽnaja. Riojone yaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yʉ, mʉa ʉjʉ, mʉare gotimasiogʉ̃ ñaboarine, mʉa gʉborire yʉ coejare, mʉa masu quẽne, mʉa gãmerã gʉbori coejama, quẽnaja. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Yʉ yirore bajirone yato ĩna” yigʉ, mʉare yiĩogʉ̃ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ñamasusere riojo mʉare gotiaja yʉ: Sĩgʉ̃ moabosarimasʉ ñamasugʉ̃ me ñaami ĩ. Ĩ ʉjʉjʉama ñamasugʉ̃ ñaami. Sĩgʉ̃ gãji ĩ cõar'i ĩ ñajama, ñamasugʉ̃ me ñaami. Ñamasugʉ̃jʉama ĩre cõar'i ñaami. To bajiri mʉa ʉjʉ ñari, “Yʉ yirore bajirone mʉa masu quẽne gãmerã ejarẽmoña mʉa”, mʉare yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yʉ gotisere ajicõari, quẽnaro mʉa yijama, variquẽnarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mʉa jedirorene yigʉ me yaja yʉ adirema. Yʉ besecanare, mʉare quẽnaro masiaja yʉ. Yucʉacane yʉ bajiroti Dios ĩ goticũcati ejarʉaroja ti. Ado bajiro yigotiaja ti, Dios ocare masa ucamasire: “Yʉ rãca bagʉ ñaboarine yʉre ĩsirocarocʉ ñaami”, yigotiaja Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ti bajiroto rĩjoroaca mʉare gotiaja yʉ. To bajiro ti bajiro ĩacõari, “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami”, yʉre yiajitirʉ̃nʉrʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ñamasusere riojo mʉare gotiaja yʉ: Yʉ cõarãre ajitirʉ̃nʉrãma, yʉre quẽne ajitirʉ̃nʉrʉarãma. No bojarã yʉre ajitirʉ̃nʉrãma, yʉre cõacacʉre quẽne ajitirʉ̃nʉama —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","To bajiro yigoticõari bero, bʉto tʉoĩasʉtiriticami Jesús. To bajiri quẽnaro riojo yʉare goticami: —Ñamasusere riojo mʉare gotiaja yʉ. Sĩgʉ̃ mʉa rãcagʉ, yʉre ĩaterãre yʉre ĩsirocarʉcʉmi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","To bajiro ĩ yisere ajicõari, yʉa ĩ buerimasa, yʉa masune gãmerã ĩacajʉ yʉa, “¿Ñimʉjʉare yati?” yirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yʉre ĩ buegʉre bʉto yʉre maicami Jesús. To bajiri yʉa batʉsacatire ĩ tʉaca barujicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","“‘¿Ñimʉjʉare yati mʉ?’ ĩre yisẽniĩato” yigʉ, yʉre sõjucami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","To bajiro ĩ yiro ĩacõari, Jesús tʉbʉsaca vʉrʉacajʉ yʉ, ĩre sẽniĩagʉ̃: —Yʉ ʉjʉ, ¿ñimʉjʉa ñati mʉre ĩaterãre ĩsirocarocʉma? —ĩre yisẽniĩacajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","To yʉ yirone, ado bajiro yʉre cʉdicami Jesús: —Pan yosecõari, yʉ ĩsigʉ̃ne ñarʉcʉmi yʉre ĩsirocarocʉma —yicʉdicami Jesús. To yicõa yuja, Simón macʉ Judas Iscariotere, ĩsicami ĩ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tire bocaãmicõari, ĩ barone ĩ ʉsʉjʉre vãtia ʉjʉ sãjacoa ruyucami Judare. To bajiro ĩ bajijare, ado bajiro ĩre yicami Jesús: —Mʉ yirʉa tʉoĩasere yidaya mʉ —Judare ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ĩ rãca barujicana sĩgʉ̃jʉama to bajiro ĩ yisere ajimasibeticajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yʉa ye gãjoare coderimasʉ ĩ ñajare, “‘Boserʉ̃mʉ ñaro mani baroti vaja yiaya’ ĩre yigʉ yigʉmi Jesús”, yitʉoĩaboacajʉ yʉa sĩgʉ̃ri. Gajeyerema, “‘Maioro bajirãre gãjoa ĩsiaya’ yigʉ yigʉmi ĩ yijama”, yicõacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bagajano, vacoacami Judas yuja. Jẽre ñamijʉ ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ĩ budiato bero, ado bajiro yʉare yicami Jesús: —Yucʉacane, “Quẽnamasugʉ̃ ñaami Dios ĩ roticõacacʉ”, yimasiroti ñaja. To bajiro yʉre yirã ñari, “Quẽnamasugʉ̃ ñaami Dios quẽne”, yimasiroti ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Diore masa ĩna rʉ̃cʉbʉojama, yʉre quẽne, “Ĩre rʉ̃cʉbʉorʉarãma”, yirʉcʉmi Dios. Yoaro mene to bajiro yigʉagʉ yami Dios. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ rĩare bajiro bajirã ñaja mʉa. Mʉa rãca yoaro ñacõa ñabetirũgũrʉcʉja yʉ. Yʉre macaboarʉarãja mʉa. Cãnʉ jud'io masa ʉjarãre yʉ gotimasirore bajirone mʉare quẽne gotiaja yʉ. “Yʉ varotore vamasimenaja mʉa”, mʉare yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yucʉne mame rotisere mʉare gotiaja yʉ: Ado bajiro bajiñama mʉa: Mʉare yʉ ĩamaiadicatore bajirone mʉa quẽne gãmerã ĩamaiña. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉa gãmerã ĩamairo ĩacõari, “Jesús buerimasa ñaama”, mʉare yiĩarʉarãma ĩna, masa jediro —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","To bajiro ĩ yisere ajicõari, Jesúre sẽniĩacami Pedro: —Yʉ ʉjʉ, ¿nojʉa vacʉ yati mʉ? —ĩre yicami Pedro. To bajiro ĩ yijare, —Yucʉacarema yʉ varotojʉre vamasibecʉja mʉma maji. Ado berojʉ yʉre sʉyarʉcʉja mʉ —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","To bajiro ĩ yirone, —Yʉ ʉjʉ, ¿no bajijare yucʉacarema mʉ rãca sʉyamasibecʉada yʉ? Mʉ sĩaecoroti ñaboajaquẽne, yʉjʉa sĩaecorʉcʉja yʉ —Jesúre yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","To bajiro ĩ yirone, ado bajiro ĩre cʉdicami Jesús: —¿Socabetiboatime mʉ? Ñamasusere riojo mʉre gotiaja yʉ: Gãjabocʉ ĩ ñagõroto rĩjoro idiaji, “Jesúre ĩre masibeaja yʉ”, yirʉcʉja mʉ —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","To bajiro Pedrore ĩre yigajanocõari ado bajiro yʉare yigoticami Jesús quẽna: —Bʉto tʉoĩarejaibeticõaña mʉa. Diore ĩre ajitirʉ̃nʉcõari, yʉre quẽne ajitirʉ̃nʉña. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉ jacʉ ya vijʉre jairo mʉa ñarotijaʉri ñaja ti. To ti bajibetijama, mʉare gotibetibogʉja yʉ. Tojʉ mʉa ñarotire mʉare quẽnoyugʉ varʉ bajiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tojʉ mʉa ñarotijaʉrire quẽnogajanocõari, quẽna gãme vadirʉcʉja yʉ. “Tojʉre yʉ ñaro yʉ rãca ñarãjaro” yigʉ mʉare juagʉ ejarʉcʉja yʉ quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yʉ vaejarotore masiaja mʉa. To bajiri tojʉ vaejaria maare masiaja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","To bajise ĩ yiboajaquẽne, ado bajirojʉa ĩre yicami Tomás: —Yʉa ʉjʉ, mʉ varotore masibeaja yʉa. ¿No bajiro yicõari, to varia maare masirʉarãda yʉa? —Jesúre ĩre yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","To bajiro ĩ yirone ado bajiro ĩre yicʉdicami Jesús: —Yʉne ñaja varia maare bajiro bajigʉma. Yʉ sʉorine Dios tʉjʉre ejare ñaja ti. Yʉ sʉorine riojo ñamasusere masire ñaja ti. “Ĩna rijato berojʉ tudirijabeticõato” yigʉ, Dios ĩ catisere masare ĩnare ĩsigʉ̃ ñaja yʉ. To bajiri, yʉre ajitirʉ̃nʉrã rĩne yʉ jacʉ tʉjʉre ejarʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yʉre mʉa masijama, yʉ jacʉre quẽne ĩre masirʉarãja mʉa. Yʉre ĩarã ñari, “Ĩ jacʉre masiaja yʉa”, yimasirʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","To bajiro ĩ yirone, ado bajiro ĩre yicami Felipejʉama: —Yʉa ʉjʉ, mʉ jacʉre yʉare ĩoña mʉ. To mʉ yicõarojʉ, “Riojo gotiami yʉare”, yimasirʉarãja yʉa yuja —Jesúre ĩre yicami Felipe. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","To bajiro Felipe ĩ yijare, —Tirʉ̃mʉjʉne mʉa rãca ñacõa sʉoadicajʉ yʉ. ¿No yigʉ to yʉ bajiboajaquẽne yʉre ĩamasibeati mʉ maji? No bojagʉ yʉre ĩagʉ̃ma, yʉ jacʉre ĩagʉ̃ ñaami. To bajiri, “Mʉ jacʉre yʉare ĩoña”, yibeticõaña mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Yʉ jacʉ rãcane ñacõaja yʉ. Ĩ quẽne yʉ rãca ñaami”, mʉare yaja yʉ. Tire ajicõari, ¿“Riojone gotiami”, yʉre yibetimasucõati mʉa, yʉre ajitirʉ̃nʉrã? Mʉare yʉ gotirũgũserema yʉ masune yʉ tʉoĩase mere mʉare gotiaja yʉ. Yʉ jacʉ, yʉ rãcane ñacõarũgũgʉ̃ ĩ yise ñajare, jediro yicoadicajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Yʉ jacʉ rãcane ñaja yʉ. Ĩ quẽne yʉ rãcane ñaami” yʉ yisere yʉre ajitirʉ̃nʉña. Yʉ gotisere ajicõaboarine yʉre mʉa ajitirʉ̃nʉbetijama, ĩaĩañamanire yʉ yiĩoadirũgũcatire tʉoĩacõari, yʉre ajitirʉ̃nʉña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ñamasusere riojo mʉare gotiaja yʉ: No bojagʉ “ ‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami” yʉre yiajitirʉ̃nʉgʉ̃ma, yʉ yirore bajirone yirʉcʉmi. Yucʉacane yʉ jacʉ tʉ vagʉagʉ yaja yʉ. Dios tʉ yʉ tudiajare, ĩaĩañamani yʉ yiĩocati rẽtobʉsaro ĩaĩañamanire yiĩorʉarãja mʉa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yʉre ajitirʉ̃nʉrã ñari, güimenane sẽnirũgũma mʉa. To bajiro mʉa yijama, no mʉa bojasere mʉa sẽniro cõrone mʉare ĩsirũgũrʉcʉja yʉ, “‘Quẽnamasugʉ̃ ñaami’ yʉ jacʉre yimasiato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yʉre ajitirʉ̃nʉrã ñari, güimenane yʉre mʉa sẽnijama, no mʉa sẽnirore bajirone mʉare cʉdirʉcʉja yʉ —ĩ buerãre yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","To bajiro yigajanocõari, ado bajiro yʉare goticami Jesús quẽna: —Yʉre mʉa maimasucõajama, yʉ rotisere cʉdirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","To bajiro mʉa yijama, yʉ jacʉre ĩre sẽnirʉcʉja yʉ, “Yʉre ñavasoarocʉre ĩre cõato ĩ” yigʉ. Ĩ cõarocʉ ñaami Esp'iritu Santo riojo gotigʉ. Mʉa rãca ñacõarũgũrʉcʉmi, mʉare yirẽmogʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Diore ajimena Dios ĩ cõagʉ̃ Esp'iritu Santore masibeama ĩna. To bajiri ĩna ʉsʉrijʉre ĩre sãjarotimasibeama. Mʉa rãca ĩ ñajare, ĩre masirã ñaja mʉama. Mʉa ʉsʉrijʉre ñacõarũgũrʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Vagʉagʉ yaja yʉ. Mʉa rãca ñagʉ̃ vadirʉcʉja yʉ quẽna. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yucʉacane vagʉagʉ yaja yʉ. To bajiri yʉre ajimenama, yʉre ĩabetirʉarãma. Mʉa rãca yʉ ñarũgũrotire masirʉarãja mʉama. Yʉ rijato bero quẽna gãme caticõarocʉ yʉ ñajare mʉa quẽne, yʉre ajitirʉ̃nʉrã, mʉa rijato berojʉ quẽna gãme caticõari ñacõarũgũrʉarãja mʉa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yʉ jacʉ rãca ñacõaja yʉ. Mʉa rãca quẽne ñacõaja yʉ. Mʉajʉa quẽne, “Yʉ rãcane ñacõaja mʉa” yʉ yirore bajirone, yʉ tudicatirirʉ̃mʉ, “Socʉ mene yiyumi Jesús”, yimasirʉarãja mʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ rotisere cʉdigʉma, yʉre maigʉ̃ ñaami. Yʉre maigʉ̃rene ĩre mairʉcʉmi yʉ jacʉ quẽne. Yʉ quẽne ĩre mairʉcʉja yʉ. Ĩre maicõari, ĩ rãca ñagʉ̃ ejarʉcʉja yʉ. To yʉ bajiro yʉre ĩabetiboarine ĩ rãcane yʉ ñasere “Masiato” yigʉ ĩre rotirʉcʉja yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","To bajiro ĩ yisere ajicõari, Judas Iscariote me, gãji Judas vãme cʉtigʉ, ado bajiro ĩre sẽniĩacami: —Yʉa ʉjʉ, ¿no yigʉ gãjerãre ĩnare yiĩobecʉne, yʉa rĩrene yʉare yiĩorʉcʉada mʉ? —Jesúre ĩre yisẽniĩacami Judas. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","To bajiro ĩ yirone, ado bajiro cʉdicami Jesús: —No bojarã yʉre mairã, yʉ gotisere ajitirʉ̃nʉrʉarãma. To bajiri yʉ jacʉ ĩnare mairʉcʉmi. To bajiri yʉ quẽne, yʉ jacʉ quẽne, ĩna tʉ ñarã vadirʉarãja yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","No bojagʉ yʉre maibecʉma, yʉ gotisere ajitirʉ̃nʉbecʉmi. Mʉare yʉ gotisema yʉ masune yʉ tʉoĩarujeose mere mʉare gotiaja yʉ. Yʉ jacʉ yʉre cõacacʉ ĩ gotirotisere gotiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Maji mʉa rãca ñagʉ̃ ñari, tire mʉare gotiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yʉre ñavasoarocʉre, Esp'iritu Santore ĩre cõarʉcʉmi yʉ jacʉ. Ñajediro mʉare yʉ gotiadicatire, “Masiritiroma” yigʉ, mʉare ejarẽmorʉcʉmi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Gajeye quẽna ado bajiro yʉare goticami Jesús: —Mʉare vare gotigʉagʉ yaja yʉ. Mʉare yʉ rijabosaroti ñajare, Diorãca quẽnaro ñarʉarãja mʉa. Yʉre ajimenajʉama, “Ado bajiro mani yijama, quẽnaro ñarʉarãja mani” yiboarine, Diorãca quẽnaro ñamasibetirʉarãma. To bajiri, tʉoĩarejaibesa mʉa. To bajicõari, güibesa. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Vagʉagʉ yaja yʉ. To bajiboarine mʉa rãca ñagʉ̃ vadirʉcʉja yʉ quẽna” yʉ yisere ajibʉ mʉa. Socarã mene yʉre mʉa maijama, “Yʉ jacʉ tʉjʉre vagʉagʉ yaja yʉ” yʉ yisere ajicõari, quẽnaro variquẽnaboriarãja mʉa. Ĩ ñaami yʉ rẽtobʉsaro ñagʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yʉ bajiroto rĩjoro tire mʉare gotiaja yʉ. To bajiri to ti bajiro ĩacõari, bʉtobʉsa yʉre ajitirʉ̃nʉrʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gajeye jairo mʉare ñagõrẽmobetirʉcʉja yʉ. Diore ajimenare rojose yirotigʉ, vãtia ʉjʉ, jẽre vadicoagʉmi. To bajiboarine, yʉre rotimasigʉ̃ me ñaami ĩma. ");
INSERT INTO bsnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yʉ jacʉ ĩ rotirore bajirone yaja yʉ. To bajiro yʉ yisere ĩacõari, “Ĩ jacʉre maigʉ̃ masune ñacõaami”, yimasirʉarãma masa —yʉare yicami Jesús. To bajiro yigajanocõari, —Ita. Vajaro mani —yʉare yicami Jesús yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Ʉyebʉ ñamasuribʉre bajiro bajigʉ ñaja yʉ. Tibʉre ĩatirʉ̃nʉgʉ̃re bajiro bajigʉ ñaami yʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","To bajiri tibʉ rʉjʉri ti rica manijama, jasurereacõarʉcʉmi. Ti rica cʉtijama, quẽnaro ĩatirʉ̃nʉrʉcʉmi. “Jairobʉsa rica cʉtiato” yigʉ, sĩnirirʉjʉrirema, tire bejareacõarʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Rica cʉti rʉjʉrire bajiro bajirã ñaja mʉa, mʉare yʉ gotimasiosere ajitirʉ̃nʉrã ñari. To bajiri yʉ jacʉ sʉorine jẽre rojose mana ñacoadicajʉ mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Quẽnaro yʉ rãca ñacõarũgũma mʉa. To bajiro mʉa bajijama, mʉa rãcane ñacoarũgũrʉcʉja yʉ. Ʉyebʉ rʉjʉ tibʉjʉre ti tuyabetijama, rica manoja ti. To bajirone bajirʉarãja mʉa. Yʉ rãca mʉa ñabetijama, quẽnase yimasibetirʉarãja mʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yʉ ñaja ʉyebʉre bajiro bajigʉma. Tibʉ rʉjʉrire bajiro bajirã ñaja mʉa. No bojarã yʉ rãca ñarãma, ĩna rãca yʉ ñajare, quẽnase rĩne yirʉarãma ĩna. To bajiro ĩna bajijama, jairo rica cʉtirãre bajiro bajirã ñarʉarãma ĩna. Yʉ manijama, ĩna masurione Dios ĩ ĩavariquẽnasere yimasibetirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","No bojagʉ yʉ rãca ñabecʉrema ĩre rocacõarʉcʉmi yʉ jacʉ. Sĩnirirʉjʉre ãmicõari, jeamejʉ tĩarocagʉre bajiro ĩre yicõarʉcʉmi yʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yʉ rãcane ñacõari, mʉare yʉ gotimasiosere masiritibeticõari, mʉa bojasere yʉre mʉa sẽniro cõrone mʉare ĩsirʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Quẽnase rĩne mʉa yirũgũsere ĩacõari, yʉ jacʉre quẽnase ĩre yirʉ̃cʉbʉorʉarãma masa. To bajiri, “Jesúre ĩre ajitirʉ̃nʉrã ñaama”, mʉare yimasirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉ jacʉ yʉre ĩ mairore bajirone mʉare quẽne maiaja yʉ. Yʉ mairã ñaja mʉa. To bajiri quẽnase rĩne yirũgũña mʉa, yʉ bojarore bajirone yirã. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ rotisere mʉa cʉdirũgũjama, yʉ mairã ñarũgũrʉarãja mʉa. To bajirone yaja yʉ quẽne. Yʉ jacʉ yʉre ĩ rotisere cʉdirũgũaja yʉ. To bajiri yʉre mairũgũami yʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Yʉre bajirone quẽnaro variquẽnaro ñato ĩna” yigʉ mʉare gotiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ado bajiro mʉare rotiaja yʉ: Mʉare yʉ maiadicatore bajirone gãmerã maiña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sĩgʉ̃ ĩ babare maigʉ̃ ñari, ĩ rijabosajama, tijʉa ñaja ñamasuse gãmerã maireayema. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yʉ rotirore bajiro mʉa cʉdijama, yʉ babarã ñarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","To bajiri, “Yʉre moabosarimasa ñaja mʉa”, mʉare yibeaja yʉ yuja. Moabosarimasama ĩna ʉjʉ ĩ yisere masimenama ĩna. “Yʉ babarã ñaja mʉa”, mʉare yaja yʉ yuja. Jediro yʉ jacʉ yʉre ĩ gotiadicatire mʉare gotimasiocoadicajʉ yʉ. To bajiri yʉ babarã ñaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yʉre besecana me ñaja mʉama. Yʉjʉa mʉare besecajʉ yʉ. “Quẽnase rĩne yato ĩna” yigʉ, mʉare besecajʉ yʉ. To bajiro mʉa yijama, gãjerã mʉare ĩacõari, mʉare ajicõari yʉre ajitirʉ̃nʉrʉarãma ĩna quẽne. To bajiri Dios ĩ catisere cʉorʉarãma ĩna quẽne. To bajiri, quẽnase mʉa yijama, yʉre mʉa sẽnirore bajirone mʉare ĩsirʉcʉmi yʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ado bajiro mʉare rotiaja yʉ: Gãmerã ĩamaiña mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Quẽna ado bajiro yʉare gotimasiocami Jesús: —Diore ajimena mʉare ĩna ĩatud'ijama, “Yʉa rĩrene ĩatud'irã me yirãma ĩna. Jesúre quẽne ĩre ĩatud'icoadicama ĩna”, yitʉoĩamasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Diore ajimenama, ĩnare bajiro tʉoĩarãre maiama ĩna. To bajiri ĩnare bajiro mʉa tʉoĩajama, mʉare quẽne maiboriarãma ĩna. Diore ajimena rãca mʉa ñarore mʉare besecajʉ yʉ, “Tʉoĩavasoacõari, yʉre ajitirʉ̃nʉrãjaro” yigʉ. To bajiri mʉare ĩatud'iama Diore ajimena yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mʉare yʉ gotisere masiritibesa mʉa: “Moabosarimasʉma, ñamasugʉ̃ me ñaami. Ʉjʉjʉama ñamasugʉ̃ ñaami ĩma” yigʉ, mʉare gotibʉ yʉ. Diore ajimenama, mʉa ʉjʉre, yʉre rojose yisʉyarũgũama. To bajiri mʉare quẽne rojose yisʉyarʉarãma. To bajiboarine tʉoĩavasoacõari, yʉ gotimasiosere cʉdirũgũama. To bajiri mʉare quẽne mʉare cʉdirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yʉre cõacacʉre quẽne masibeama Diore ajimena. To bajiri yʉre ajitirʉ̃nʉrã mʉa ñajare, mʉare quẽne rojose yisʉyarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Masare gotimasiogʉ̃ yʉ vadibetijama, “Rojose yirã ñaja mani. Dios ĩ rotiriarore bajirone cʉdibeaja”, yimasibetiboriarãma, Diore ajimena. Ĩnare yʉ gotimasioro bero ñajare, “Rojose mana ñaja”, yimasibeama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","No bojarã yʉre ĩatud'irã, yʉ jacʉre quẽne ĩatud'irã yama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ĩna ĩaro rĩjorojʉa Dios ĩ masise rãca ĩaĩañamanire yʉ yiĩobetijama, “Yʉare Dios ĩ masise rãca ĩaĩañamanire ĩ yiĩobetijare, ‘Dios ĩ cõar'i, Cristo ñaami’ ĩre yimasibeaja yʉa”, yiboriarãma ĩna. Dios ĩ masise rãca ĩaĩañamanire yʉ yiĩoro ĩacana ñaama ĩna. Tire ĩacana ñaboarine ĩna ĩatirʉ̃nʉbeti vaja rojose ĩnare ñacõa ñaja. To bajiri, yʉre ĩateama ĩna. Yʉ jacʉre quẽne ĩre teama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dios ocare masa ĩna ucamasire ti gotirore bajirone bajiaja ti yuja, yucʉrirema. Ado bajise gotiaja ti: “Ñie manone yʉre ĩateama ĩna”, yigotiaja ti —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","To bajiro yicõari, gajeyere quẽna ado bajiro yʉare gotimasiocami Jesús: —Dios ĩ cõagʉ̃ Esp'iritu Santore socabecʉre mʉare cõarʉcʉja yʉ, yʉ gotimasirũgũsere “Ajimasiato” yigʉ, mʉare ejarẽmorocʉre. ");
INSERT INTO bsnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yʉ gotimasiosʉorojʉne yʉ rãcane ñacoadicajʉ mʉa. To bajiri, yʉ gotimasiocatire ajicana ñari, ĩaĩañamanire yʉ yiĩocatire ĩacana ñari, masare gotimasiomasirʉarãja mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Quẽna ado bajiro yʉare gotimasiorũtuacami Jesús: —“Yʉre ajiquejeroma” yigʉ, adire mʉare gotiaja yʉ: ");
INSERT INTO bsnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dios ocare mani buerũgũrivijʉ mʉa ñarore mʉare bucõarʉarãma ĩna. To bajiro yicõari mʉare sĩarãne, “Dios ĩ bojasere bajiro ãnoare ĩre sĩabosaja mani”, yitʉoĩaboarʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","To bajiro ĩna yijama, yʉre quẽne, yʉ jacʉre quẽne masimena ñari, yirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“‘“To bajiro masune bajirʉaroja ti” yiquĩda ĩ Jesús’ yitʉoĩamasirãjaro ĩna” yigʉ, mʉare gotiaja yʉ. Rẽmojʉre mʉare gotisʉogʉ, mʉare gotibeticajʉ yʉ maji, “Ĩna rãca ñarʉcʉja yʉ maji” yigʉ ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yʉre cõacacʉ tʉjʉ vagʉagʉ yaja yʉ yuja. To yʉ bajiboajaquẽne, “¿Nojʉ vagʉagʉ yati mʉ?”, yʉre yisẽniĩabeaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sẽniĩamenane, mʉare yʉ yigotiserene tʉoĩasʉtiritiaja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","To bajiri, riojo mʉare gotiaja yʉ. Yʉ vacoajama, mʉare quẽnarʉaroja. Yʉ vabetijama, mʉare ejarẽmorocʉ, Esp'iritu Santo mʉa rãca ñagʉ̃ vadibetibogʉmi. Yʉ vajama, ĩre cõarʉcʉja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Esp'iritu Santo ĩ vadijama, ĩ ejarẽmose rãca, “Riojo manire yiyumi Dios. Rojose yirã ñaja mani”, yimasirʉarãma masa. Ĩ ejarẽmose rãca quẽnase masune yirere masirʉarãma ĩna. Gajeye quẽne, ĩ ejarẽmose rãca ado bajiro tʉoĩamasirʉarãma masa: “Diore mani cʉdibeti vaja rojose tãmʉotʉjabetiriarojʉ manire cõarʉcʉmi Dios”, yimasirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yʉre ĩna ajitirʉ̃nʉbeti vaja rojose tãmʉotʉjabetiriarojʉ ĩna varotire Esp'iritu Santo ĩ ejarẽmose rãca masirʉarãma. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉ jacʉ ĩ ñarojʉre yʉ varoti ti ñajare, yʉre ĩabetirʉarãja mʉa. Yʉ jacʉ tʉ ñacõari, yʉ cõagʉ̃ Esp'iritu Santo ĩ ejarẽmose rãca, “Quẽnaro riojo yigʉ ñañumi”, yimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“Masare rojose yirotigʉre vãtia ʉjʉre rojorojʉ, rojose tãmʉoato” yigʉ, ĩre yʉ cõarotire Esp'iritu Santo ĩ ejarẽmose rãca masirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","To bajiro yigajanocõari, ado bajiro yʉare yigotimasiocami Jesús: —Jairo mʉare yʉ gotiroti ñaboaja ti. To ti bajiboajaquẽne yucʉne mʉare yʉ gotijeocõajama, ajimasimenaja mʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dios ĩ cõagʉ̃ Esp'iritu Santo mʉa tʉ ejacõari, ĩ ejarẽmose rãca riojo masu ajimasijeorʉarãja mʉa. Ĩ sĩgʉ̃ ĩ ejarẽmose rĩne bajibetirʉaroja. Yʉ jacʉ ĩ rotise rãca ejarẽmorʉcʉmi. To yicõari, “Ado bajiro bajirʉaroja” ĩ yise rãca ajimasirʉarãja. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","To yicõari, mʉa rãca yʉ yiñarũgũcatire mʉa ajimasirotire mʉare ejarẽmorʉcʉmi Esp'iritu Santo, “‘Jesús, quẽnamasugʉ̃ ñaami’ ĩre yirʉ̃cʉbʉoato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ñajedirone yʉ jacʉ yʉre ĩ rotirore bajirone mʉare gotiaja yʉ quẽne. To bajiri, “Mʉa rãca yʉ yiadicatire mʉare gotimasiorʉcʉmi Esp'iritu Santo”, mʉare yibʉ yʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","To yigʉne, quẽna ado bajiro goticami Jesús: —Yucʉne yʉ jacʉ tʉjʉ vagʉagʉ yaja yʉ. To bajiri yʉre ĩabetirʉarãja mʉa. To bajiboarine quẽna yoaro mene yʉre ĩacõarʉarãja mʉa —ĩ buerãre yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","To bajiro ĩ yisere ajicõari, sĩgʉ̃ri ĩ buerã, ado bajiro gãmerã yisẽniĩacajʉ yʉa: —¿No yire ũnire yigʉ yati ĩ? —gãmerã yicajʉ yʉa. —“Yʉ jacʉ tʉjʉ vagʉagʉ yaja yʉ. To bajiri yʉre ĩabetirʉarãja mʉa. To bajiboarine quẽna yoato mene yʉre ĩacõarʉarãja mʉa”, manire yami —gãmerã yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—“Yoato mene yʉre ĩarʉarãja” manire ĩ yijama, ¿no bajiro bajirʉ yati? “Tire yigʉ yami”, yiajimasibeaja mani —gãmerã yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","To yʉa yiñarone, “Yʉre sẽniĩarʉama ĩna”, yimasicõacami Jesújʉama. To bajiri ado bajiro yʉare yicami: —“Yoaro mene yʉre ĩabetiroana yaja mʉa. To bajiboarine quẽna yoato mene yʉre ĩacoarʉarãja mʉa”, mʉare yibʉ yʉ. To bajiro yʉ yiserene, ¿mʉa masune gãmerã sẽniĩati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Riojo ñamasusere mʉare gotiaja yʉ. Tʉoĩasʉtiritirã ñari, otirʉarãja mʉa. Diore ajimenama, variquẽnarʉarãma ĩna. Mʉama, tʉoĩasʉtiritirã ñaboarine yoaro mene quẽna variquẽnacoarʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Adire bajiro bajirʉaroja ti: Sĩgõ rõmio, macʉ cʉtigoago, tʉoĩasʉtiritigomo so, “Josari tãmʉorʉocoja” yigo. So macʉ cʉtiro berojʉma, tire tʉoĩasʉtiritibecone, variquẽna masiriocõagõmo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tire bajirone mʉa quẽne yucʉrema tʉoĩasʉtiritiaja mʉa. To bajiboarine quẽna mʉare ĩagʉ̃ vadirʉcʉja yʉ. Yʉre ĩacõari, bʉto variquẽnarʉarãja mʉa quẽna. To bajiro mʉa variquẽnasere gãji, “Variquẽnabeticõaña mʉa”, yibetirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tirʉ̃mʉ ti ejarone yuja, ñiejʉare yʉre sẽniĩabetirʉarãja mʉa yuja. Jẽre masicõarʉarãja mʉa. Riojo ñamasusere mʉare gotiaja yʉ: “‘Rotimʉorʉ̃gõrʉcʉmi’ yigʉ, Dios ĩ cõar'i ñaami” yʉre yiajitirʉ̃nʉrã ñari, yʉ jacʉre mʉa sẽnijama, mʉa sẽniro cõrone mʉare ĩsirʉcʉmi. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","“Jesúre ajitirʉ̃nʉrã ñaja yʉa”, yisẽnibeticajʉ mʉa maji, yʉ jacʉre. Ado beroma yuja, “Jesúre ajitirʉ̃nʉrã ñaja yʉa”, yisẽnirũgũña mʉa. To bajiro mʉa yijama, mʉare ĩsirʉcʉmi yʉ jacʉ, “Quẽnaro variquẽnato ĩna” yigʉ —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Gajeye quẽna ado bajiro yʉare yigoticami Jesús: —Mʉare yʉ gotijama, gotimasiore rãca mʉare goticoadicajʉ yʉ maji. Bero mʉare yʉ gotijama, gotimasiore rãca me mʉare gotirʉcʉja yʉ. To bajiro yʉ jacʉ yere mʉare yʉ gotijare, quẽnaro ajimasirʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yʉ jacʉ tʉjʉ yʉ tudiejato berone, “Yʉare sẽnibosaya mʉ”, yʉre yibetirʉarãja mʉa. Mʉa masune, yʉ jacʉre güimenane, “Jesúre ajitirʉ̃nʉrã ñaja yʉa”, ĩre yisẽnirũgũrʉarãja mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mʉare maiami yʉ jacʉ, yʉre mʉa maijare. “Dios ĩ cõar'i ñaami” mʉa yiajitirʉ̃nʉjare, mʉare maiami ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉ jacʉ tʉ ñar'i, adi macarʉcʉrojʉre vadicajʉ yʉ. To bajiri adi macarʉcʉroanare vaveocoarʉcʉja yʉ, quẽna yʉ jacʉ tʉ tudiacʉ —yʉare yicami Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","To bajiro ĩ yisere ajicõari ĩre cʉdicajʉ yʉa yuja: —Yucʉrema gotimasiore rãca me, mʉ gotisere quẽnaro ajimasiaja yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","“Ñajediro masigʉ̃ ñaja mʉ”, yiĩamasiaja yʉa yuja. Mʉre yʉa sẽniĩaroto rĩjorojʉne jẽre yʉa sẽniĩarotire masicõaja mʉ. To bajiri, “Dios tʉ vadir'i ñaja mʉ”, mʉre yiajitirʉ̃nʉaja yʉa yuja —Jesúre ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","To bajiro yʉa yijare, ado bajiro yʉare cʉdicami Jesús: —¿Socarã mene, “Quẽnaro mʉre ajitirʉ̃nʉaja yʉa”, yʉre yati mʉa? ");
INSERT INTO bsnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Riojo mʉare gotiaja yʉ: Yucʉne yʉre cãmotadijedicoarʉarãja mʉa. To bajiro mʉa bajiboajaquẽne, sĩgʉ̃ne ñabetirʉcʉja yʉ. Yʉ rãcane ñacõa ñarʉcʉmi yʉ jacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ti jediro mʉare gotiaja yʉ, “Yʉre ajitirʉ̃nʉcõari, quẽnaro ñacõarʉarãja mʉa” yigʉ. Adi macarʉcʉroana, Diore ajimena, rojose mʉare ĩna yijare, rojose tãmʉorʉarãja mʉa. To bajiboarine, tʉoĩatĩmama: Masa rojose yʉre ĩna yiboajaquẽne, rojose yibeticõari, Dios ĩ bojasejʉare yicoadicajʉ yʉ. To bajiri, mʉa quẽne yʉre bajirone yimasirʉarãja mʉa —yʉare yicami Jesús, ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","To bajiro yicõari bero, õ vecajʉare ĩamʉocõari, ado bajiro yicami Jesús: —Cacʉ, mʉ tʉjʉ yʉ tudiaroti mojoroaca rʉyaja ti yuja. Masa, “Quẽnamasugʉ̃ ñaami” yʉre ĩna yimasirotire yigʉ, ejarẽmoña. To bajiro mʉ yijama, yʉ sʉorine, “Quẽnamasugʉ̃ ñaami”, mʉre quẽne yirʉarãma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mʉ macʉ ñaja yʉ. “Masare ñajedirore rotimasiato ĩ” yigʉ yʉre cõacajʉ mʉ. Mʉ sʉorine yʉre ajitirʉ̃nʉrã, “Ĩna rijato bero quẽnaro catijedicõa ñarũgũrãjaro” yigʉ yʉre cõacajʉ mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ado bajiro bajiama ĩna tudirijabetirere cʉorãma: Dios ñamasugʉ̃re, mʉre masiama. To yicõari, mʉ roticõacacʉre quẽne yʉre masiama. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Adi macarʉcʉrojʉ yʉ ñaro, yʉ sʉorine quẽnase mʉre yirʉ̃cʉbʉocoadicama ĩna masa. Yʉre mʉ yirotirũgũro cõrone jẽre mʉre yibosagajanoaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Adi macarʉcʉro ti ruyuaroto rĩjorojʉne mʉre bajirone rʉ̃cʉbʉo ecogʉ ñacoadicajʉ yʉ. To bajiri, mʉ tʉjʉ yʉ tudiejaro, quẽna yʉre ĩna yirʉ̃cʉbʉorotire yigʉ, yʉre yirẽmoña mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yʉ buerimasa mʉre ajimena rãca ĩna ñarore mʉ besecana ñama. Ĩnare besecõari, yʉre ĩsicajʉ mʉ. To bajiri yʉ sʉorine mʉre masiama ĩna yuja. Mʉ yarã ñacõari, mʉ ocare cʉdirã ñaama. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","To bajiri jediro yʉ gotimasiose, to yicõari, ĩaĩañamani yʉ yiĩosere ĩacõari, “Dios sʉorine yami”, yimasiama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mʉ ocare yʉre mʉ gotiroticatore bajirone ĩnare goticoadicajʉ yʉ. Tire ajicõari, “Dios tʉ vadir'i, Dios ĩ cõar'i ñaami”, yʉre yimasiama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mʉre ĩnare sẽnibosaja yʉ. Mʉre ajimenarema ĩnare mʉre sẽnibosabeaja yʉ. Yʉre mʉ ĩsicana ñajare, sẽnibosaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yʉ yarã ñarã ñari, mʉ yarãne ñarã bajiama. Ĩna sʉorine yʉre quẽnase yirʉ̃cʉbʉoama masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yucʉacane mʉ rãca ñagʉ̃ vagʉagʉ yaja yʉ. To bajiri adi macarʉcʉrore vaveoacʉ yaja yʉ yuja. Yʉre ajitirʉ̃nʉrãma, adi macarʉcʉrojʉ tujacõarã yama ĩna. Cacʉ, rojose yigʉ me ñaja mʉ. Mʉ masise, yʉre mʉ ĩsicati rãcane ãnoare ĩnare ĩatirʉ̃nʉña. Cojoro cõro tʉoĩarã ñaja mani. Manire bajirone ĩna quẽne “Sĩgʉ̃re bajirone tʉoĩato ĩna” yigʉ, ĩnare ĩatirʉ̃nʉña. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Adi macarʉcʉrojʉre ĩna rãca ñagʉ̃ yʉ yimasirotire yʉre mʉ ĩsicati ñajare, quẽnaro ĩnare ĩatirʉ̃nʉcoadicajʉ yʉ. “Sĩgʉ̃ rojose tãmʉotʉjabetiriarojʉ vatomi” yigʉ quẽnaro ĩnare ĩatirʉ̃nʉcoadicajʉ yʉ. To bajiboarine sĩgʉ̃ ñaami rojose tãmʉotʉjabetiriarojʉ varocʉ. “To bajiro bajirʉaroja” mʉ yicatire masa ĩna ucamasicati ti goticatore bajirone yigʉ bajirʉcʉmi ĩma. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yucʉacane mʉ tʉ vagʉagʉ yaja yʉ yuja. Adi macarʉcʉrojʉre ñagʉ̃ maji adire mʉre sẽniaja yʉ, “Yʉre ajitirʉ̃nʉrã, yʉ variquẽnarore bajirone ĩna quẽne quẽnaro variquẽnajedicõato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ãnoa yʉ buerã, yʉre mʉ gotiroticatire ajicõari tʉoĩavasoacana ñaama ĩna. To bajiri mʉre ajimena ĩna tʉoĩare bajirone tʉoĩabeama ĩna yuja. Yʉre bajirone tʉoĩarã ñama. To bajiro bajirã ĩna ñajare, ĩnare ĩateama masa, mʉre ajimena. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yʉre ajitirʉ̃nʉrãre, “‘Mʉre ajimena rãca vatoajʉ ñabeticõato ĩna’ yigʉ, ĩnare juacoasa mʉ”, mʉre yibeaja yʉ. Ado bajirojʉa mʉre sẽniaja yʉ. Quẽnaro ĩnare yirẽmoña, “Vãtia ʉjʉre ĩre cʉdiroma ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mʉre ajimena ĩna tʉoĩarore bajirone tʉoĩagʉ̃ me ñaja yʉ. To bajiri, yʉre ajitirʉ̃nʉrã quẽne, mʉre ajimena ĩna tʉoĩarore bajiro tʉoĩarã me ñaama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Riojo ñamasuse ñaja ti mʉ oca. To bajiri yʉre ajitirʉ̃nʉrãre ĩnare yirẽmoña mʉ, mʉ ocare “Quẽnaro ajimasiato ĩna” yigʉ. Mʉ ocare ajimasicõari, “Quẽnase rĩne yirã ñato” yigʉ, ĩnare yirẽmoña. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mʉre ajimena vatoajʉre yʉre cõacajʉ mʉ. Yʉ quẽne, to bajirone mʉre ajimena vatoajʉre yʉre ajitirʉ̃nʉrãre ĩnare cõagʉagʉ yaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","“Yʉ bajirotire mʉ tʉoĩacatore bajirone bajirʉaroja ti”, mʉre yaja yʉ, “Yʉ sʉorine quẽnase ĩnare ejarʉaroja” yimasigʉ̃ ñari. To bajiro mʉre yaja yʉ, “Yʉre ĩacõari, ‘Dios ocare socabetire Jesús ĩ cʉdirore bajirone cʉdirãsa mani’ yato ĩna” yigʉ —yicami Jesús, Diore sẽnigʉ̃. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Gajeye ado bajiro Diore sẽnicami Jesús: —Yʉ rãca ñacõari, yʉre ajitirʉ̃nʉrã rĩrene ĩnare sẽnibosagʉ me yaja yʉ. Ãnoa ĩna gotimasiose ti ñajare, “Gãjerã quẽne, yʉre ajitirʉ̃nʉrʉarãma” yigʉ, ĩnare quẽne sẽnibosaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","“Yʉre ajitirʉ̃nʉrã ñajediro sĩgʉ̃re bajiro ñato ĩna” yigʉ, mʉre sẽniaja yʉ, to yicõari, “Mani rãca quẽne ñacõa ñato ĩna” yigʉ. Cacʉ, yʉ rãca ñaja mʉ. Yʉ quẽne, mʉ rãca ñaja. To mani bajirore bajirone sĩgʉ̃re bajiro ĩna ñasere bojaja yʉ. To bajiro ĩna bajiro ĩacõari, “Socʉ mene Dios ĩ cõar'i ñañumi Jesús”, yitʉoĩavasoarʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“‘Diorãca ñaami’ masa yʉre yirʉ̃cʉbʉoato” yigʉ, yʉre ejarẽmoadicajʉ mʉ. To bajirone yʉre ajitirʉ̃nʉrãre quẽne, yʉre mʉ ejarẽmocatore bajirone ĩnare ejarẽmorʉcʉja yʉ, masa, ĩnare ĩacõari “‘Diorãca ñaama’ ĩnare yirʉ̃cʉbʉoato” yigʉ. To bajiro ĩnare yirʉcʉja yʉ, mani bajirore bajirone, “Sĩgʉ̃re bajiro ñato ĩna” yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ĩna rãca ñarũgũaja yʉ. Mʉ quẽne, yʉ rãca ñarũgũaja mʉ. To bajiri sĩgʉ̃re bajirone tʉoĩarʉarãma ĩna. To bajiro ĩna bajiro ĩacõari, “Dios ĩ cõar'ine ñañumi Jesús”, yimasirʉarãma masa. “Ĩ macʉre ĩ mairore bajirone ĩnare quẽne maiami Dios”, yimasirʉarãma masa. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Cacʉ, yʉre ajitirʉ̃nʉrã yʉre mʉ ĩsicana ñaama ĩna. To bajiri yʉ rãca ĩna ñarotire bojaja yʉ, mʉ rãca yʉ rotiñarore “Ĩarãjaro ĩna” yigʉ. To bajiri, mʉ rãca yʉ rotisere ĩacõari, “Adi macarʉcʉro ti ruyuaroto rĩjorojʉne Jesúre maicoayumi Dios” ĩna yimasirotire bojaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Cacʉ rojose yigʉ me ñaja mʉ. Mʉre ajimenama, mʉre masibeama ĩna. Yʉma, mʉre masiaja yʉ. Ãnoa yʉ buerã quẽne, “Dios ĩ cõar'ine ñaami”, yʉre yimasiama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","“Ado bajiro bajigʉ ñaami Dios”, ĩnare yigotimasiocoadicajʉ yʉ, yʉre ajitirʉ̃nʉrãre. To bajirone ĩnare gotimasiocõaja yʉ maji, yʉre mʉ mairore bajirone “Gãjerãre maiato ĩna” yigʉ. To yicõari, “Ĩna rãca yʉ ñacõa ñarũgũrotire masiato ĩna” yigʉ to bajiro yʉre ajitirʉ̃nʉrãre ĩnare gotimasioaja yʉ —Diore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","To bajiro Diore Jesús ĩ yisẽniro bero, Cedrón vãme cʉti cora gajejacatʉajʉ vacajʉ yʉa, ĩ rãca. To vanane, olivo vãme cʉtisere oteriavesejʉre jiacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tocãrãcajine ti vesejʉre rẽjacajʉ yʉa. To bajiri Judas, Jesúre ĩaterãre ĩsirocacacʉ quẽne, yʉa rãca rẽjarũgũcacʉ ñari, tojʉre quẽnaro masicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","To bajiri ti vesere masigʉ̃ ñari, surarare, to yicõari, Diore yirʉ̃cʉbʉoriavi coderimasare ũmato ejacami Judas. Paia ʉjarã, to yicõari, fariseo masa ĩna cõariarã ñacama. Jariaserine besu cʉocama ĩna. Sĩgʉ̃ri sĩabusuoriari, gãjerã mʉjorijãirire bajise sĩare cʉocama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jẽre, “To bajirone yʉre yirʉarãma” yigoticacʉ ñari, ĩnare bocagʉacami Jesús. Ĩnare bocacõari ado bajiro ĩnare sẽniĩacami: —¿Ñimʉre macati mʉa? —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","To bajiro ĩ yirone, —Jesús Nazaret macagʉre macaja yʉa —ĩre yicʉdicama ĩna. To bajiro ĩna yirone, —Yʉne ñaja —ĩnare yicʉdicami ĩjʉama. Judas, Jesúre ĩaterãre gotiyiror'i quẽne ĩna rãca ñacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Yʉne ñaja yʉ” Jesús ĩ yirone, jʉdavẽjacoacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","To ĩna bajirone, ĩnare tudisẽniĩacami Jesús: —¿Ñimʉre macarã bajiati mʉa? —ĩnare yicami Jesús. To bajiro ĩ yirone, —Jesús Nazaret macagʉre macaja yʉa —yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","To bajiro ĩna yisere ajicõari: —“Yʉne ñaja yʉ”, jẽre mʉare yibʉ yʉ. Yʉrene mʉa macajama, yʉ rãcanare ĩnare varotiya maji —ĩnare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","To bajiro ĩ yijama, “‘To bajirʉaroja ti’ ĩ yigoticatore bajiro bajiato” yigʉ yicami. Ado bajise Diore ĩre yicami: “Cacʉ, yʉre mʉ ĩsicanare quẽnaro ĩnare ĩatirʉ̃nʉcoadicajʉ yʉ, ‘Sĩgʉ̃ bajiyayiromi’ yigʉ”, yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jesúre ĩna ñiarʉaro ĩacõari, ĩ jariasere yoveacami Pedro. Tiasene paia ʉjʉ ñamasugʉ̃re moabosarimasʉre, Malco vãme cʉtigʉre riojojacatʉaga gãmorore ĩre jatarocacõacami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","To bajiro ĩ yijare, ado bajiro Pedrore ĩre yicami Jesús: —Mʉ jariasere tudisuacõaña quẽna. Rojose yʉ tãmʉorotire yʉ jacʉ ĩ bojacatire, “Tãmʉorʉabecʉmi”, ¿yʉre yiboatime mʉ? —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","To bajiro ĩ yirone surara, ĩna ʉjʉ rãca, Diore yirʉ̃cʉbʉoriavi coderimasa quẽne Jesúre ñiacama ĩna. Ĩre ñiacõari, ĩ ãmobearire siacama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","To yicõari, Anás ya vijʉ ĩre ãmicoacama ĩna yuja. Caifás ũmañicʉ ñacami Anás. Ti cʉ̃mare paia ʉjʉ ñamasugʉ̃ ñacami Caifás. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás ñañuju: “Ĩre mani sĩabetijama, mani ñaro cõrone sĩajeocõarʉarãma ĩna romano masa. To bajiri manire rijabosagʉre bajirone bajiato ĩ”, yigotir'i ñañuju ĩ. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pedro rãca, Jesúre ĩna ãmivato sʉyacajʉ yʉa. Paia ʉjʉ ñamasugʉ̃re quẽnaro ĩ masigʉ̃ ñacajʉ yʉ. To bajiri josari mene paia ʉjʉ ya vi ta biberiasãniro rẽtosãjacoacajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrojʉama ta biberiasãniro sʉyarojʉajʉne sãjabecʉne tujacoacami. To bajiri paia ʉjʉ ñamasugʉ̃re masigʉ̃ ñari, ta biberiasãnirore coderimaso rãca ñagõgʉ̃ tudibudicoacajʉ yʉ. To yicõari Pedrore ĩre jisõcajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","To cõrone ta biberiasãnirore coderimaso, Pedrore ĩre sẽniĩacamo so: —¿Jesús buerimasa rãcagʉ me ñati mʉ? —ĩre yicamo so, Pedrore. To so yirone, —Ĩ me ñaja yʉ —sore yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ti ʉsajare, paia ʉjʉ ñamasugʉ̃re moabosarimasa, Diore yirʉ̃cʉbʉoriavi coderimasa quẽne jea riocõari, sũmañacama ĩna. Pedro quẽne ĩna rãca sũmañacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jesúre ĩna ãmiejaro, ĩacõari, paia ʉjʉ ñamasugʉ̃, ado bajiro ĩre sẽniĩañuju: —¿Nocãrãcʉ ñati mʉ buerã? ¿Ñie ũnire ĩnare gotimasiorũgũati mʉ? —ĩre yisẽniĩañuju ĩ, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","To bajiro ĩ yijare, ado bajiro cʉdiyuju Jesús: —Masa ĩaro rĩjorojʉa gotisʉoadicajʉ yʉ, Diore yirʉ̃cʉbʉoriavijʉre, to yicõari, ĩ ocare mani buerũgũrivirijʉre quẽne. Disejʉane yayioroaca yʉ gotimasiore maja. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿No yigʉ yʉjʉare sẽniĩati mʉ? Yʉre ajicanajʉare ĩnare sẽniĩaĩasaque. Yʉ gotirũgũcatire mʉre gotirʉarãma ĩna. Tire masirãma ĩna —ĩre yiyuju Jesús, paia ʉjʉ ñamasugʉ̃re. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","To bajiro Jesús ĩ yisere ajicõari, sĩgʉ̃, Diore yirʉ̃cʉbʉoriavi coderimasʉ Jesús riogare jayuju. Ĩre jacõari, —To bajiro mʉ yicʉdijama, paia ʉjʉ ñamasugʉ̃re ĩre rʉ̃cʉbʉogʉ me yaja mʉ —Jesúre ĩre yiyuju Diore yirʉ̃cʉbʉoriavi coderimasʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","To bajiro ĩ yirone, ĩre cʉdiyuju Jesús: —Riojo me yʉ yijama, “Ado bajiro yaja mʉ”, yʉre yigotiya mʉ. Riojo yʉ yiboajaquẽne, ¿no yigʉ yʉre jati mʉ? —ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","To bajiro ĩre yisẽniĩacõari bero, ĩre ĩna siarere jojiorotibecʉne paia ʉjʉ ñamasugʉ̃ Caifás vãme cʉtigʉ tʉjʉare Jesúre cõañuju Anás. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","To ĩna yiñaro ũnone jea sũmacõa ñacami Pedro. Ĩ rãca jea sũmañarã ado bajiro ĩre yisẽniĩacama ĩna: —¿Ĩ buerimasʉ me ñati mʉ quẽne? —ĩre yisẽniĩacama ĩna. To bajiro ĩna yirone, —Bajibeaja. Ĩ me ñaja yʉ —yicami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","To bajiro ĩ yirone, sĩgʉ̃ paia ʉjʉre moabosarimasʉ Pedrore ĩre sẽniĩacami: —Olivo vãme cʉtisere oteriavesejʉ, ĩ rãca mʉ ñaro, mʉre ĩamʉ yʉ —ĩre yicami. Ĩ ñacami Pedro ĩ gãmoro jatacacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","To bajiro ĩ yisẽniĩasere ajicõari, —Ĩ me ñaja yʉ —yicõacami quẽna Pedro. To bajiro ĩ yirirĩmarone, gãjabocʉ ñagõcõacami yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tijʉ bero, Caifás ya vi ñariarã, Pilato ya vijʉare Jesúre ĩre ãmivacama. Jud'io masa ʉjʉ ñaboarine, Roma vãme cʉti macagʉ ñacami Pilato. To cõrone busumʉjacoacajʉ yuja. Ĩ ya vire sãjabeticama ĩna jud'io masa, “Gãjerã masa ya vi mani sãjajama, Pascua bare bamasimenaja mani” yitʉoĩarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","To bajiri, Pilato ĩna rãca ñagõrʉ budiacami ĩ yuja: —¿Ñie rojose ĩ yise sʉori ĩre ocasãti mʉa? —yicami Pilato, jud'io masare. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","To bajiro ĩ yisẽniĩarone, ado bajiro ĩre cʉdicama ĩna: —Rojose ĩ yibetijama, mʉ tʉ ĩre ãmiejobetiboriarãja yʉa —ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","To bajiro ĩna yirone, —Ĩre ãmicoasa mʉa. Mʉa masune rojose ĩ yisere ĩacõĩajeocõari, rojose ĩ yise vaja rojose ĩre yiba mʉa yuja —ĩnare yiboacami Pilato, jud'io masare. To bajiro ĩnare ĩ yirone, —Yʉa, jud'io masama, masare sĩamasibeaja —Pilatore ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","“Yucʉ́tẽrojʉ yʉre jajutusĩacõarʉarãma masa” Jesús ĩ yicatore bajirone bajicajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Quẽna sãjacõari, Jesúre ĩre jiyuju Pilato. To yicõari, ado bajiro Jesúre ĩre yisẽniĩañuju: —¿Jud'io masa ʉjʉ masune ñati mʉ? —Jesúre ĩre yiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","To bajiro ĩ yirone, —¿Mʉ masu tʉoĩarine, to bajise yʉre yisẽniĩati mʉ? ¿Gãjerã mʉre ĩna gotijare, to bajise yʉre sẽniĩatique mʉ? —ĩre yiyuju Jesús, Pilatore. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","To bajiro ĩ yijare, —Jud'io masʉ me ñaja yʉ, tia. Mʉ yarãne, paia ʉjarã rãca, yʉ tʉ mʉre ãmiejoama ĩna. ¿Ñie ũni rojose yirori mʉ? —Jesúre ĩre yiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdiyuju Jesús: —Masa ʉjʉ mʉ yigʉre bajiro bajigʉ me ñaja yʉ. To bajiro bajigʉ yʉ ñajama, yʉre sʉyarimasa yʉre ĩaterãre ĩna rãca gãmerã quẽaboriarãma ĩna, “Yʉre ñiaroma ĩna” yirã. To bajiri, masa ʉjʉ mʉ yigʉre bajiro bajigʉ me ñaja yʉ. Yʉre rotise adone ñabeaja —Pilatore ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","To bajiro ĩ yirone, —To yijama, ¿ʉjʉ ñati mʉ? —yiyuju Pilato. To bajiro ĩ yirone ĩre cʉdiyuju Jesús: —Mʉ yirore bajirone bajiaja yʉ. Ʉjʉne ñaja yʉ. Adi macarʉcʉrojʉre vadicõari ruyuacajʉ, riojo ñamasusere gotirʉ. No bojarã yʉ gotisere ajivariquẽnarãma, yʉre ajitirʉ̃nʉrã ñaama —Pilatore ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","To bajiro ĩ yirone, —¿Ñie ũnire yigʉ yati mʉ, ñamasuse ñaja mʉ yiserema? —Jesúre ĩre yiyuju Pilato. To bajiro Jesúre ĩre yisẽniĩa gajanocõari, budiejacami Pilato, jud'io masare gotigʉagʉ quẽna: —Yʉ ĩajama, ñie rojose yigʉ me ñaami. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tocãrãca cʉ̃mari Pascua mʉa yiro cõro, sĩgʉ̃ tubibe ecor'ire mʉare bubosarũgũaja yʉ. To bajiri, ¿mʉa jud'io masa ʉjʉre yʉ bubosasere bojati mʉa? —ĩnare yicami Pilato, jud'io masare. ");
INSERT INTO bsnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","To bajiro ĩnare ĩ yijare, ado bajiro ĩre avasãcʉdicama ĩna: —¡Ĩrema bubesa mʉ! ¡Barrabájʉare ĩre bucõaña! —yiavasãcama ĩna, Pilatore. Barrabájʉama, juarudirimasʉ ñañuju. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","To bajiro ĩna yisere ajicõari, Jesúre ĩre bajerotiyuju Pilato yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jesús rʉjoa joere jotabedo suariabedo ĩre jeoyujarã surara. To yicõari, ʉjarã ĩna sãñarito ũnore sũarivʉjorore ĩre sãñujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","To bajiro ĩre yigajanocõa, ĩ tʉbʉsa ejarʉ̃gʉ̃cõari, ado bajiro ĩre yiyujarã ĩna: —Jud'io masa ʉjʉre mʉre quẽnarotiaja yʉa yuja —yiajatud'iyujarã ĩna, Jesúre. To yicõari ĩ riogare ĩre jayujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","To bajiro ĩna yiro bero quẽna budiejacõari jud'io masare ado bajiro ĩnare yicami Pilato yuja: —¡Ĩaña mʉa! Yʉ ĩajama, ñiejʉa rojose yigʉ me ñaami. Mʉa quẽne ĩre ĩacõari, “Yʉre bajiro tʉoĩato” yigʉ, ĩre buaja yʉ —ĩnare yicami Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","To bajiro ĩ yirone, jotabedo jesacõari, sũarivʉjorore sãñacõari budiadicami Jesús. To cõrone yuja ado bajiro masare yicami Pilato: —¡Ĩaña mʉa! Ãni ñaami ĩ yuja —ĩnare yicami Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","To bajiro ĩ yirone, Jesús ĩ budiadore ĩacõari ado bajiro avasãcama ĩna paia ʉjarã, Diore yirʉ̃cʉbʉoriavi coderimasa quẽne: —¡Yucʉ́tẽrojʉ ĩre jajutuya! ¡Ĩre jajutuya! —yiavasãcama ĩna. To bajiro ĩna yirone, —¡Mʉa masune ĩre ãmivacõari yucʉ́tẽrojʉ ĩre jajutuaya mʉa! Yʉjʉa yʉ ĩajama, ñiejʉa rojose yigʉ me ñaami —ĩnare yicami Pilato, jud'io masare. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","To bajiro ĩ yisere ajicõari, ado bajiro ĩre cʉdicama jud'io masa: —Yʉa ñicʉa ĩna rotimasiriarore bajirone yirã “Rijacoajaro” yaja yʉa, “Dios macʉ ñaja yʉ” ĩ yise vaja —Pilatore ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","To bajiro ĩna yisere ajicõari bʉtobʉsa güiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","To bajiri quẽna vijʉ ĩre jicõari ĩre sẽniĩañuju Pilato: —¿Noagʉ masu ñati mʉ? ĩre yisẽniĩañuju Pilato. To bajiro ĩ yisẽniĩaboajaquẽne —ĩre cʉdibesuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","To bajiri quẽna ĩre tudisẽniĩañuju Pilato: —¿Yʉre cʉdibeatime mʉ? Gãjerãre mʉre yucʉ́tẽrojʉ yʉ jajuturotirʉajama, jajutu rotimasiaja yʉ. Mʉre yʉ burʉajaquẽne bucõamasiaja yʉ. ¿Tire masibeatique mʉ? —Jesúre ĩre yiyuju Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","To bajiro ĩ yirone, —No bajiro yicõari rotimasibetibogʉja mʉ, Dios ĩ bojabetijama. Masare rotirocʉre mʉre cũcami Dios. To bajiri mʉ tʉjʉre yʉre cõagʉ̃re, mʉ rẽtoro rojose masu ñacõaja ti —Pilatore ĩre yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","To bajiro ĩ yisere ajicõari, “¿No bajiro yicõari, Jesúre ĩre bucõaroti ñaboati ti?”, yitʉoĩañuju Pilato yuja. To bajiro ĩ yitʉoĩaboajaquẽne, ado bajiro yiavasãcama jud'io masa: —Ĩre mʉ bucõajama, ʉjʉ ñamasugʉ̃ César vãme cʉtigʉ rãcagʉ me ñarʉcʉja mʉ. No bojagʉ ĩre sẽnibecʉne, “Ʉjʉ ñarʉcʉja yʉ” yigʉma, César ĩ ĩategʉ ñaami. To bajiri, ĩre mʉ bujama, quẽnabeaja —Pilatore ĩre yiavasãcama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","To bajiro ĩna yisere ajicõari, Jesúre ĩre jiburoticami Pilato yuja. To yicõari, rotigʉ ĩ rujirijʉre ejarũjũcoacami Pilato. Gabata vãme cʉticajʉ hebreo ocarema. “Gʉ̃tane bʉoriajʉ” yire ũni ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua boserʉ̃mʉ bare basʉoriarʉ̃mʉ rĩjoroagarʉ̃mʉ, ñacajʉ ti. Ʉ̃mʉrecaji ñaro ado bajiro ĩnare yicami Pilato, jud'io masare: —Ãni ñaami mʉa ʉjʉ —ĩnare yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","To bajiro ĩ yisere ajicõari, bʉto avasãcama ĩna quẽna: —¡Sĩacõaroti ñaja! ¡Sĩacõaroti ñaja! ¡Yucʉ́tẽrojʉ ĩre jajutusĩarotiya mʉ! —Pilatore ĩre yiavasã cʉdicama ĩna. To bajiro ĩre ĩna yise ñajare, ado bajiro ĩnare yicami Pilato: —¿No yigʉ mʉa ʉjʉre jajutusĩarotigʉada yʉ? —ĩnare yicami Pilato. To bajiro ĩ yijare, ado bajiro ĩre cʉdicama paia ʉjarã: —César sĩgʉ̃ne ñaami yʉa ʉjʉma. Ñimʉjʉa gãji maami —yicama ĩna, Pilatore. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","To bajiro ĩna yisere ajicõari, “Yucʉ́tẽrojʉ ĩre jajusĩato ĩna” yigʉ, Jesúre ĩnare ĩsicami Pilato. To bajiri Jesúre ĩre ãmicoacama ĩna yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ĩre ĩna ãmiato, yʉa quẽne sʉyacajʉ yʉa. Ĩre ãmivacõari, yucʉ́tẽrore ĩre gajaroticama ĩna. Hebreo ocama Gólgota vãme cʉti burojʉ ĩre ãmivacama ĩna. “Rʉjoco Buro” yire ũni ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tojʉ ĩre ãmiejacõari, Jesúre yucʉ́tẽrojʉ ĩre jajutucama ĩna. Ĩ tʉ gãjerã jʉarã ĩnare jajutucama. Sĩgʉ̃re ĩ riojojacatʉa, gãjire ĩ gãcojacatʉa ĩnare jajutucama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jesús ĩ tuyaritẽrojʉre ĩ rʉjoa vecare ĩ vãmere ucaturotiyumi Pilato. Ado bajise yituyacajʉ: “Jesús Nazaret macagʉ, jud'io masa ʉjʉ” yiucature ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jãjarã jud'io masa tire ĩacama ĩna. Maca tʉacane ñacajʉ ti, Jesúre ĩna jajutucato. Ĩ rʉjoa veca vãme tuyase griego oca, hebreo oca, lat'in oca quẽne ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","To bajiri jud'io masa paia ʉjarã ado bajiro ĩre yicama, Pilatore: —“Jud'io masa ʉjʉ ñaami” mʉ yiucarotiboare quẽnabeaja ti. “‘Jud'io masa ʉjʉ ñaja yʉ’ yiboami”, yiucavasoarotiya mʉ —Pilatore ĩre yicama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","To bajiro ĩna yiboajaquẽne, ado bajiro ĩnare cʉdicami Pilato: —Jẽre uca ecocoamʉ. To bajiro ñacõato —ĩnare yicami Pilato. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yucʉ́tẽrojʉ Jesúre jajutugajanocõari, ĩ sudi sãñaboarere juacama ĩna surara. Babaricãrãcajʉ vocõari, gãmerã batocama ĩna. To bajiri, cojasene rʉyacajʉ ti, ĩna ãmirotiase. Jesús ĩ sãñarito joeado tiayamano ñacajʉ ti. Riojone suamʉjagajanoriaro ñacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","To bajiri ado bajiro gãmerã yicama surara: —Tiasere vobeticõato mani. “Ñimʉjʉa tiasere ĩ ãmiʉjaro ĩarãsa mani” yirã, gʉ̃tariacane reacũĩacama ĩna. To bajiro ĩna yijama, Dios ocare masa ĩna ucamasire ti gotiriarore bajirone bajicajʉ ti yuja, ado bajiro ti yimasire ñajare: “Yʉ ye sudire gãmerã batorʉarãma ĩna. ‘Ñimʉjʉa tiasere ĩ ãmiʉjaro ĩaĩarãsa mani’ yirʉarãma ĩna. To yirãne gʉ̃tariacane reacũĩarʉarãma ĩna”, yigotiaja Dios ocare masa ĩna ucamasire. To bajiri, to bajirone yicama surara. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús yucʉ́tẽrojʉ ĩ tuyaro tʉjʉ adocãrãcʉ ñacajʉ yʉa: Ĩ jaco, to yicõari, so yo Cleofas manajo Mar'ia vãme cʉtigo, gajeo Mar'ia Magdalena, ñacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yʉ Jesús ĩ buecacʉ, ĩ maigʉ̃ quẽne ñacajʉ yʉ. Ĩ jaco rãca yʉ ñasere ĩacõari ado bajiro yicami Jesús: —Caco, ĩ ñarʉcʉmi mʉ macʉre bajiro bajigʉ —sore yicami Jesús, yʉjʉare. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","To yicõari, yʉjʉare ado bajiro yicami: —Mʉ jacore bajiro bajigo ñarʉocomo so —yʉre yicami Jesús. To bajiro ĩ yise ñajare, yʉ ya vijʉ sore ũmato ñarũgũcajʉ yʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesús, to bajise yʉare ĩ yiro bero, “Dios ĩ bojadicatore bajirone jẽre adi macarʉcʉrojʉre yijeocõaja yʉ yuja” yigʉ ñari, Dios ocare masa ĩna ucamasire, “Ti gotirore bajirone bajiato ti” yigʉ, —Bogoaja yʉre —yicami Jesús yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","To ñacajʉ ʉye oco jiase. Tire, sudiro bʉrʉane ñiabiacõari, hisopo vãme cʉtiricʉ gajane siatucama ĩna, tibʉrʉare. To yicõari, Jesús rise tʉjʉre ñumʉotucama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ʉye oco jiase veroĩacõari ado bajiro yicami Jesús: —Dios ĩ roticõacatore bajirone jẽre yijeocõaja yʉ yuja. To cõrone ñaja —yicami Jesús. To yigʉne, murocayo, ʉsʉtadicõa tʉjacami Jesús yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua boserʉ̃mʉ bare basʉoriarʉ̃mʉ rĩjoroagarʉ̃mʉ ñacajʉ ti. Gajerʉ̃mʉ yʉa jud'io masa ʉsʉsãjariarʉ̃mʉ ñacajʉ. To bajiri yucʉ́tẽrojʉ rijariarã rujʉri tuyasere bojabeticama ĩna. To bajiri Pilatore ĩre sẽniñujarã jud'io masa ʉjarã: —Yucʉ́tẽrojʉ tuyarãre ĩna ñicʉgʉ̃ri gõare jatʉ̃rerotiya mʉ, “Guaro rijacoajaro” yigʉ. To yicõari ĩna rujʉrire rujio rotiya —ĩre yiyujarã ĩna, jud'io masa ʉjarã. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","To bajiri Pilato ĩ rotijare, ĩ yarã surara vacõari, yucʉ́tẽrojʉ Jesús tʉjʉ jʉarã tuyarãre ĩna ñicʉgʉ̃ri gõare jatʉ̃recama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesús tʉjʉre ejarʉ̃gʉ̃cõari, “Jẽre ʉsʉtadicoasumi ãnima”, ĩre yiĩacama ĩna. To bajiri ĩ ñicʉgʉ̃ri gõare jatʉ̃rebeticama ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","To bajiboarine Jesús varubʉre sĩgʉ̃ surara sarejoracami. Ĩ sarejorarone, ri'i, oco rãca budicajʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yʉ, tire gotigʉ, tire ĩacacʉ masune ñacõaja yʉ. “Riojo gotiaja tire”, yimasiaja yʉ. Mʉare quẽne, quẽnabʉsaro “ ‘Jesús ñaami Dios macʉ mani ʉjʉ, ĩ masise rãca manire ejarẽmogʉ̃’ yimasiato ĩna” yigʉ, riojo tire gotiaja yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","To bajiro ti bajijama, Dios ocare masa ĩna ucamasire ti gotirore bajirone jediro bajicajʉ ti. Ado bajiro gotiaja Dios oca: “Cojo gõaro ĩre gõaro jajeabetirʉarãma ĩna”, yigotiaja ti Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gajejʉ Dios oca ti gotijama, ado bajiro gotiaja: “Sarejora ecor'ire ĩarʉarãma masa”, yigotiaja Dios oca. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","To ĩna yiro bero, Arimatea vãme cʉti macagʉ José, Jesús rujʉrire ãmirʉ Pilatore sẽniñuju ĩ. Jesúre ĩre ajitirʉ̃nʉcacʉ ñacami José. To bajiboarine gãjerãre gotibatobeticami, jud'io masa ʉjarãre güigʉ. To bajiri, “Ãmiña” Pilato ĩ yijare, Jesús rujʉrire rujiogʉ vasuju José. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo ñamijʉ Jesúrãca ñagõgʉ̃ ejar'i quẽne ejayuju. Treinta y cuatro kilo cõro rʉ̃cʉse sʉtiquẽnasere juaejayuju ĩ. Mirra vãme cʉtise, áloe vãme cʉtise rãca vʉore ñañuju ti sʉtise. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","To bajiri José, Nicodemo rãca, Jesús rujʉrire rujiocõari sudijãiri botiquẽnarijãirine sʉtisere tucõari, ĩre gũmañujarã ĩna. Yʉa jud'io masa, to bajiro yirũgũcajʉ yʉa, bajirearãre yujerã. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesúre yucʉ́tẽrojʉ ĩna jajutusĩacato, ote vese tʉjʉ ñacajʉ ti. Ti vesejʉre masa yujeriavi gʉ̃tavi mame quẽnoriavijʉre ĩ rujʉrire cũñujarã. Gãjerãre yujeĩañamanivi ñañuju ti vi. ");
INSERT INTO bsnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ʉsʉsãjariarʉ̃mʉ, Pascua bare basʉoriarʉ̃mʉ ti ejaroto mojoroaca rʉyacajʉ ti. To bajiri ti vijʉ Jesús rujʉrire cũñujarã ĩna, sõjʉ me ti ñajare. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gaje semana ĩna moasʉoriarʉ̃mʉ busurijʉ jẽjʉ rẽtiabʉsarojʉne vasuju so Mar'ia Magdalena. Jesúre ĩna yujeriavi tʉ ejacõari, so ĩajama, gʉ̃ta tũnuobibeboaria mañuju. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","To ti bajiro ĩacõari, ũmadi, yʉa tʉjʉ ejacamo so. Pedro, yʉ, Jesús bʉto ĩ maicacʉ, ñacajʉ yʉa. Yʉa tʉjʉre ejacõari, ado bajiro yʉare goticamo so: —Mani ʉjʉ rujʉrire ãmicoasuma ĩna. “Tojʉ ĩ rujʉrire cũriarãma ĩna”, yimasibeaja yʉ —yʉare yicamo so. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","To so yisere ajicõari, Pedro rãca ĩarã vacoacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yʉa jʉarã, cojoro cõro ũmacajʉ yʉa. Pedro rẽtobʉsaro ũmacajʉ yʉjʉa. To bajiri, yʉjʉa ĩ rĩjoro ejacoacajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mubiacõari, ti vire ĩasõcajʉ yʉ. Ĩre ĩna gũmaboare rĩne ñacajʉ. Sãjabeticajʉ yʉ, bajigʉjʉma. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉ berojʉ ejacami Pedrojʉama. Ĩma ĩre ĩna yujeriavijʉ sãjacoacami. Ĩ quẽne, Jesúre ĩna gũmaboare rĩrene ĩacami. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesús rʉjoare ĩna gũmariaro ricatijʉ ti jesaro ĩacami. Ĩre ĩna dʉreariaboare gajerojʉ jesacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","To cõrone yʉ quẽne ĩ rĩjoro ejasʉocacʉ quẽne sãjacoacajʉ yʉ. Tire ĩacõari, “Tudicaticoasumi Jesús”, yimasicajʉ yʉ yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","“Rijacoaboarine tudicaticoarʉcʉmi Jesús” Dios ocare masa ĩna ucamasire ti yigotisere ajimasibeticajʉ yʉa maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","To bajicõa, yʉa ya vijʉ tudicoacajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mar'ia Magdalenama, Jesúre ĩna yujeriavi tʉjʉne oticõa tujasumo so. Otiñagõne, mubiacõari, ti vire ĩasõcõañuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ĩasõcõagõne, jʉarã ángel mesa, botiquẽnase sãñacõari rujirãre ĩañuju so. Sĩgʉ̃ Jesús rʉjoa ñariarojʉare rujiyuju ĩ. Gãji, ĩ gʉbori ñariarojʉare rujiyuju. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","So otiñaro ĩacõari, sore sẽniĩañujarã ĩna, Mar'ia Magdalenare: —¿No yigo otiati mʉ? —sore yiyujarã ángel mesa. To bajiro ĩna yirone, —Yʉ ʉjʉ rujʉrire ãmicoasuma ĩna. “Tojʉ ĩ rujʉrire cũriarãma ĩna”, yimasibeaja yʉ —yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","To bajiro ĩnare yigotigajanocõari, jʉdarʉ̃gʉ̃gõne Jesúre ĩañuju so. Ĩre ĩaboarine, “Jesúne ñaami”, yimasibesuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","To cõrone ĩjʉa sore sẽniĩañuju ĩ: —¿No yigo otiati mʉ? ¿Ñimʉre macati mʉ? —sore yiyuju Jesús. “Adi vese coderimasʉ ñagʉ̃mi”, yitʉoĩacõañuju so. To bajiri ado bajiro ĩre yiyuju so: —Ĩ rujʉrire mʉ ãmicũjama, “To cũmʉ yʉ”, yʉre yigotiya. Ãmigõ varʉo yaja yʉ —ĩre yiyuju so. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","To so yirone, ado bajiro sore yiyuju Jesús yuja: —Mar'ia —sore yiyuju. To bajiro ĩ yirone hebreo ocane ado bajiro ĩre yiyuju so: —Rabuni —yiyuju so. “Gotimasiogʉ̃” yire ũni ñaja ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","To so yirone, ado bajiro sore cʉdiyuju Jesús: —Yʉre moaĩabesa maji. Yʉ jacʉ tʉjʉ mʉjabeaja yʉ maji. Vasa. Yʉ yarãre ĩnare gotiaya: “Dios mani jacʉ, mani rʉ̃cʉbʉogʉ, ĩ ñarojʉ vacʉ yimi”, ĩnare yigotiaya —sore yigotirotiyuju Jesús, Mar'ia Magdalenare. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","To bajiro ĩ yirio, yʉare gotigo ejacamo so. “Mani ʉjʉre ĩamʉ yʉ”, yʉare yicamo so. To yicõari, Jesús ĩ gotiroticõariarore bajirone yʉare goticamo. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Moasʉoriarʉ̃mʉ rãioati ñamire yʉa Jesús ĩ buecana vijʉre rẽjacõari, ñacajʉ yʉa. Yʉa yarã jud'io masare ĩnare güirã ñari, sojere tubibecõari ñacajʉ yʉa. To bajiro yʉa bajiñaro yʉa vatoane ruyuarʉ̃gʉ̃cõacami Jesús: —¿Ñati mʉa? Quẽnaro ñaña mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","To yigʉne, ĩ ãmorire ĩna jajucatire, ĩ varubʉre ĩna sarecatire yʉare ĩocami Jesús. Yʉa ĩ buecana yʉa ʉjʉre ĩacõari, bʉto variquẽnacajʉ yʉa yuja. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","To bajiri quẽna ado bajiro yʉare gotirũtuacami Jesús: —Quẽnaro ñaña mʉa. Yʉ jacʉ masa tʉjʉ yʉre ĩ cõacatore bajirone yʉ quẽne mʉare cõaja yʉ yuja —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","To yigʉne, yʉare jutijeocami. Jutijeogʉne, ado bajiro yicami: —Dios ĩ cõagʉ̃re Esp'iritu Santore bocaãmiña mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ĩre bocaãmicõari, gãjerã rojose ĩna yisere mʉa masiriojama, Dios quẽne rojose ĩna yisere masiriorʉcʉmi. Rojose ĩna yisere mʉa masiriobetijama, Dios quẽne rojose ĩna yisere masiriobetirʉcʉmi —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yʉare Jesús ĩ ruyuaĩororema, Tomás yʉa rãcagʉ cojoji ruyuarãne, jʉarã ruyuar'i yʉa yicacʉ manicami maji. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesús ĩ ruyuaĩoro bero Tomáre ĩabʉjacõari, “Mani ʉjʉre ĩre ĩamʉ yʉa”, ĩre yiboacajʉ yʉa. To bajiro ĩre yʉa yiboajaquẽne ado bajiro yʉare boca cʉdicami Tomás: —Ĩ ãmorire ĩre ĩna jajucati gojerire ĩacõari yʉ tõmeĩabetijama, to yicõari ĩ varubʉre ĩna sarecatijʉre yʉ moaĩabetijama, “Ĩne ñaami”, yimasibecʉja yʉ —yʉare boca yicami Tomás. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Cojomo cõro idia jẽnituarirʉ̃mʉri bero quẽna rẽjacajʉ yʉa. Tirʉ̃mʉ yʉa rẽjarirʉ̃mʉre Tomás quẽne ñacami yuja. Soje turiaro ti ñaboajaquẽne yʉa vatoane ruyuarʉ̃gʉ̃cami Jesús quẽna. —¿Ñati mʉa? Quẽnaro ñaña mʉa —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","To yicõa, ado bajiro Tomáre ĩre yicami: —Yʉ ãmorire ĩacõari, mʉ ãmo vãsoane yʉre tõmeĩaña mʉ. Mʉ ãmo vãsoane yʉ varubʉre ĩna saremasirijʉre tõmeĩaña. “Ĩ me ñagʉ̃mi”, yibeja yuja. “Ĩne ñaami”, yimasiña mʉ yuja —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","To bajiro ĩre ĩ yirone, —Yʉ ʉjʉ, Dione ñaja mʉ —Jesúre yicami Tomás. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","To bajiro ĩ yirone, ado bajiro ĩre cʉdicami Jesús: —Tomás, yʉre ĩagʉ̃ ñari, “Ĩne ñaja mʉ”, yʉre yaja mʉ. Gãjerãma yʉre ĩabetiboarine mʉ yirore bajirone yʉre ĩna yijama, quẽnaro variquẽnarʉarãma ĩna —Tomáre ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Gajeye jairo ĩaĩañamanire yiĩocami Jesús, yʉare ĩ buerãre. Ti ñaro cõrone ucajeobeaja yʉ, adi queti ucagʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yʉ ucasema, “Mani rijato berojʉ, rojose tãmʉotʉjabetiriarojʉ mani vaborotire manire yirẽtobosacõari, ĩ rotirotire yigʉ, Dios ĩ cõar'i, to yicõari, ĩ macʉ ñagʉ̃mi Jesús” mʉa yitʉoĩarotire yigʉ, ucaja yʉ. To bajiro Jesúre mʉa yitʉoĩajama, mʉa rijato berojʉ, “Tudirijabeticõato” yigʉ, Dios ĩ catisere ĩsiecorʉarãja mʉa quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tijʉ bero, quẽna yʉare ruyuaĩocami Jesús, ĩ buecanare. Tiberias vãme cʉtira tʉsarojʉ yʉare ruyuaĩocami ĩ. Ado bajiro bajicami: ");
INSERT INTO bsnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Adocãrãcʉ ñacajʉ yʉa, rẽjacana: Simón Pedro vãme cʉtigʉ, Tomás yʉa rãcagʉ cojoji ruyuarãne, jʉarã ruyuar'i yʉa yicacʉ, Natanael, Galilea sitagʉ Caná vãme cʉti macagʉ, yʉa Zebedeo rĩa, gãjerã jʉarã Jesús ĩ buecana ñacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","To yʉa bajiñarone, ado bajiro yicami Pedro: —Vai vayagʉacʉ yaja yʉ —yicami. To bajiro ĩ yijare, —Yʉa quẽne mʉ rãca vana yaja —ĩre yicajʉ yʉa. To yi, ĩ rãca vacoacajʉ yʉa. Va, cũmua vasãjacajʉ yʉa. Ti ñamire vai vaya ñamicʉtiboacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ti busumʉjadone ʉtabʉcʉra tʉne yʉare ruyuaĩocõacami Jesús. To ĩ bajiboajaquẽne, “Ĩne ñagʉ̃mi”, yimasibeticajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ado bajise yʉare yicami: —¿Vai sĩabeati mʉa? —yʉare yicami Jesús. To bajiro ĩ yijare, —Vai vayaboaja yʉa. Sãjabeama —ĩre yicajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","To yʉa yirone, —¡Cũmua riojojacatʉare bajiʉre rocaroaya mʉa! To bajiro mʉa yijama, vai sĩarʉarãja mʉa —yʉare yicami Jesús. To ĩ yirotirore bajirone yicajʉ yʉa. Jãjarã vai ĩna sãjajare, no yi tʉ̃amʉo sãtĩmabeticajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tire ĩaboacʉ, yʉ, Jesús ĩ maicacʉ ado bajiro ĩre yicajʉ yʉ, Pedrore: —Mani ʉjʉne ñaami —ĩre yicajʉ yʉ. Tire ajicõari, ĩ sudiro veacũcatiasere guaro sãña, jatirocaroa, bacõa jãjacami ĩ, Jesús ĩ ñarojʉare. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Cien metros cõro vijariarojʉre jayacajʉ yʉa. To bajiri jabua cʉtojʉre bajiʉre sãjacanare vaire vejajãjacajʉ yʉa. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jãjaeja, majacõari, jeame ʉ̃jʉrime vecare vai jesarãre ĩnare ĩacajʉ yʉa. To bajicõari, pan quẽne jesacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yʉa ejaro ĩacõari ado bajiro yʉare yicami Jesús: —Gãjerã vai juadirẽmoña yucʉacane mʉa vayasĩarãre —yʉare yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","To bajiro ĩ yisere ajicõari, cũmuajʉre ejasãjacami Pedro. To yicõari, bajiʉre boejʉ vejamocũcami, jacarã vai sãñaricʉre. Ciento cincuenta y tres ñarirãcʉ ñacama vai ñajediro. Jãjarã ĩna ñaboajaquẽne, surebeticajʉ ti, bajiʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","To ĩ yiro bero, ado bajiro yʉare yicami Jesús: —Bayujiroaya —yʉare yicami Jesús. “¿Ñimʉ ñati mʉ?”, ĩre yisẽniĩabeticajʉ yʉa, “Mani ʉjʉne ñaami” yirã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","To yicõa, yʉa tʉjʉ ejarʉ̃gʉ̃, panre yʉare ĩsibatocami. Vaire quẽne, to bajirone yicami. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Idiaji yʉare ruyuaĩocoacami, ĩ sĩaecocato bero tudicaticõari. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yʉa bayujigajanoro bero, Pedrore ĩre sẽniĩacami Jesús: —¿Mʉ rãcana yʉre ĩna mairo rẽtoro yʉre maiati mʉ Pedro, Jonás macʉ? —ĩre yisẽniĩacami Jesús. To bajiro ĩ yirone, —Yʉ ʉjʉ mʉre maiaja yʉ. Mʉre yʉ maisere masiaja mʉ —Jesúre ĩre yicami Pedro. To bajiro ĩ yijare, —¡Oveja rĩare ĩna ecarũgũriarore bajirone yʉ yarãre yʉre gotimasiobosaba mʉ! —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Quẽna tudisẽniĩacami Jesús, Pedrore: —¿Yʉre maimasucõati mʉ Pedro, Jonás macʉ? —ĩre yicami Jesús. To bajiro ĩ yirone Pedrojʉama: —Yʉ ʉjʉ mʉre maiaja yʉ. Mʉre yʉ maisere masiaja mʉ —Jesúre ĩre yicami Pedro quẽna. To bajiro ĩ yijare, —¡Ovejare coderiarore bajirone yʉ yarãre yʉre codebosaba mʉ! —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","To yicõa, quẽna ĩre tudisẽniĩaquẽnocami Jesús: —¿Yʉre maiati mʉ Pedro, Jonás macʉ? —ĩre yicami Jesús. Idiaji, “¿Yʉre maiati mʉ?” Jesús ĩ yisere ajicõari, sʉtiriticoacami Pedro yuja. To bajiri ado bajiro Jesúre ĩre yicami Pedro: —Yʉ ʉjʉ, ñajediro masigʉ̃ ñaja mʉ. Mʉre yʉ maisere masiaja mʉ —Jesúre ĩre yicami Pedro. To bajiro ĩ yijare, —Ovejare ĩna ecarũgũrore bajirone yʉ yarãre yʉre gotimasiobosaba mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Socʉ mene mʉre gotiaja yʉ. Tirʉ̃mʉjʉ mamʉ ñagʉ̃jʉma sudi sãñacõari, no mʉ bojarone vacudirũgũcajʉ mʉ maji. Bʉcʉ mʉ ñatone mʉ ãmorire siacõari, mʉ varʉabetojʉre mʉre ãmirʉarãma ĩna —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","To bajise Pedrore ĩ yijama, ĩ sĩaecoroti vãmere gotimasiogʉ̃ yicami. To bajiro mʉ yiecosere ĩacõari, “Diore rʉ̃cʉbʉorʉarãma masa” yigʉ, to bajise goticami Jesús, Pedrore. To yigajanogʉ̃ne, —Vayá yʉ rãca. Yʉre ajitirʉ̃nʉ sʉyaya —ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jʉdati ĩacõari ĩnare yʉ sʉyaro yʉre ĩacami Pedro. Yʉ ñacajʉ Jesús ĩ buecacʉ, bʉto ĩ maicacʉ. Yʉne ñaja Jesús, Pascua boserʉ̃mʉ yʉare ĩ ũmato batʉsacatirʉ̃mʉ ĩ tʉbʉsaca ñacõari, “¿Ñimʉ ñati, mʉre ĩaterãre ĩsirocarocʉma?” Jesúre yisẽniĩacacʉ. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yʉre ĩacõari, ado bajiro Jesúre ĩre yisẽniĩacami Pedro: —Yʉ ʉjʉ, ãnima, ¿no bajiro bajirijariquĩda? —Jesúre ĩre yisẽniĩacami Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","To bajiro ĩ yirone, ado bajiro ĩre cʉdicami Jesús: —Quẽna yʉ tudivadirotojʉ ĩ catirotire yʉ bojajama, caticõa ñarũgũrʉcʉmi maji. No bajiro mʉre yibeaja ti, mʉ masibetijaquẽne. Mʉma yʉre ajitirʉ̃nʉ sʉyaya mʉ —Pedrore ĩre yicami Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","To bajiro ĩ yirone, yʉjʉarema, “‘Rijabetirʉcʉmi’ yigʉ yigʉmi” yirene masicõacama ĩna. To bajiboarine Jesújʉama, “Rijabetirʉcʉmi”, yibeticami. Ado bajirojʉa yicami ĩ: “Yʉ tudiejarijʉjʉ ĩ catisere yʉ bojajama, caticõarʉcʉmi maji. Tire mʉ masibetijama, no yibeaja mʉre” yigʉ yicami Jesús. Tire quẽnaro ajimasibeticõari, “Rijabetirʉcʉmi Juan” yire queti gotibatoyuma ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Juan ñaja yʉ, Jesús ĩ buecacʉ. Yʉne ñaja, adi paperare ucagʉ. Yʉ gotisere, “Riojo gotiaja ti”, yimasiaja mani. ");
INSERT INTO bsnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gajeye jairo ñaja Jesús ĩ yiĩocati. Jediro Jesús ĩ yirũgũcatire mani ucajeocõajama, adi macarʉcʉrore tĩjabetiboroja paperatutiri. To cõrone ñaja.");
INSERT INTO bsnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","¿Teófilo, ñaboati mʉ? Tirʉ̃mʉ mʉre papera cõasʉocajʉ yʉ. Ti papera rãca Jesús ĩ yisʉorere masare ĩ gotimasiorere mʉre ucacõacajʉ yʉ. Ĩ bueriarã yʉre ĩna goticato cõro ucajeocõacajʉ yʉ. Ĩ ruyuarere ucasʉocajʉ yʉ. To yicõari, ĩ sĩaecorere, tudicaticõari õ vecajʉ ĩ mʉjarere quẽne ucacajʉ yʉ. Õ vecajʉ ĩ mʉjaroto rĩjoro, ĩ bueriarãre ĩnare gotimasioroticõagʉ̃, Esp'iritu Santo ĩ ejarẽmose rãca, “Ado bajiro yiba mʉa” ĩnare ĩ yigoticũrere ucacajʉ yʉ. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ĩ rijato bero, tudicaticõari ĩ cõaronare cojoji me ĩnare ruyuaĩoñuju Jesús. To bajicõari, cuarenta ñarirʉ̃mʉri ĩna rãca ñagʉ̃, ĩnare ĩ ũmato yirũgũriarore bajiro ĩnare ũmato yicõa ñañuju, “Ĩne ñaami” ĩna yimasirotire yigʉ. To bajiñagʉ̃, “Yʉ rijabosare sʉorine yʉre ajitirʉ̃nʉrãre ĩavariquẽnaami Dios yuja”, ĩnare yigotimasioñuju. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ĩna rãca ñagʉ̃jʉ, ado bajiro ĩnare gotiyuju Jesús maji: —Adone ñacõama maji, Jerusalénne. Dios mani jacʉ ĩ gotirere bajirone ĩ cõagʉ̃ Esp'iritu Santo ejarotire yuba mʉa. Tire mʉare yʉ goticatire ajicajʉ mʉa. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tirʉ̃mʉjʉ oco rãca mʉare bautizacami Juan, “Dios ĩ bojabeti yirʉabeaja” mʉa yitʉoĩajare. To bajiri, yoaro mene Esp'iritu Santore mʉare cõarʉcʉmi Dios, mʉa rãca ñarocʉre, “Dios ĩ bojarore bajirone yimasiato” yirocʉre —ĩnare yiyuju Jesús. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","To bajiri, Jesúrãca rẽjarã ado bajiro sẽniĩañujarã ĩna: —Tirʉ̃mʉjʉ romano masa, mani Israel ñamasir'i jãnerabatia ye sitare ẽmacõari, moarotisʉoadimasiñuma ĩna. ¿Yucʉrema, ĩnare bucõari, “‘Rotimʉorʉ̃gõrʉcʉja mʉ’ yigʉ, Dios ĩ cõagʉ̃ ñaja yʉ”, yigotigʉti mʉ? —Jesúre ĩre yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","To bajiro ĩna yijare, ado bajiro ĩnare cʉdiyuju Jesús: —No bajiro yicõari, masimenaja mʉama. Dios mani jacʉma ĩ masise rãca ĩ yirotire, ĩ sĩgʉ̃ne masiami. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","To bajiboarine, Dios ĩ cõagʉ̃ Esp'iritu Santo ĩ vado, ĩ masise mʉare ejarʉaroja ti. To bajiri, gãjerã masa tʉjʉ vacõari yʉre gotibosarã varʉarãja mʉa. Jerusalénjʉre, adi maca Judea sita jediro, Samaria sitajʉ quẽne, macarʉcʉro ñaro cõrone yʉre gotibatocudibosarʉarãja mʉa —ĩnare yiyuju Jesús ĩ buerãre. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","To bajiro ĩnare gotigajanogʉ̃ne, ĩre ĩna ĩañarone mʉjacoasuju Jesús. Buerigasero ejacʉne yayicoasuju. To bajiro ĩ bajiro bero ĩre tudiĩabesujarã yuja. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ĩ mʉjaveoro bero to bajirone vecajʉre ĩamʉocõa ñañujarã ĩna maji. To ĩna bajirone ĩna vatoajʉ jʉarã ángeles ruyuarʉ̃gʉ̃cõañujarã ĩna. Bʉto botise sudi sãñarã ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","To bajicõari, ado bajiro ĩnare gotiyujarã ĩna: —Mʉa Galileana, ¿ñiere yirã ʉ̃mʉagaserojʉare ĩamʉocõa ñati? Jesús, mʉa rãca ñar'i, ʉ̃mʉagaserojʉ ĩ mʉjato mʉa ĩarore bajirone tudirujiadirʉcʉmi quẽna —Jesús bueriarãre yiyujarã ángeles. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","To bajiri, Olivo vãme cʉti buro ñañujarã ĩna, Jesús ĩ bueriarã, ĩ cõarona. To bajiri Jerusalénjʉ tudicoasujarã ĩna yuja. Ti buro tʉacane ñañuju ti, ti maca. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ti macajʉ ejacõari, vijʉ vecaga sõajʉre ñañujarã ĩna. Ado bajise vãme cʉtiyujarã ĩna: Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, gãji Santiago Alfeo macʉ ñañuju ĩ. Gãji Simón Celote ĩna yigʉ ñañuju. Gãji, Santiago macʉ Judas ñañuju ĩ. Tocãrãcʉ ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sĩgʉ̃re bajirone tʉoĩacõari, rẽjarũgũñujarã ĩna, Diore sẽnirã. Jesús bederã, ĩ jaco Mar'ia, gãjerã rõmia quẽne ñañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tirʉ̃mʉrire ĩna rãca rẽjarũgũñujarã ĩna, Jesúre ajitirʉ̃nʉrã. Ciento veinte cõro ñariarãma ĩna. Ĩna vatoajʉ vʉ̃mʉrʉ̃gʉ̃cõari, ado bajiro ĩnare gotiyuju Pedro: ");
INSERT INTO bsnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Ajiya mʉa, yʉ yarã. Tirʉ̃mʉjʉ Esp'iritu Santo ĩ ejarẽmose rãca Judas ĩ bajirotire ucamasiñuju, mani ñicʉ David ñamasir'i, Jesúre ĩre ñiacanare ũmato ejacacʉre. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","To bajiri Judas yʉa rãcagʉ ñaboacami. Ĩ ye moare quẽne ñaboacajʉ ti. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas, ĩ masune rojose yicõari, rijacoasuju ĩ. Ĩ rʉjoajʉane quediruji, tʉ̃asiarocayocõa tʉjasuju. To baji, tuvagʉa potogʉne, ĩ gʉdamisi budibatecoasuju ti. To ĩ bajiro bero, rojose ĩ yire vaja gãjoa ñarãre juacõari, ti sitare vaja yiyujarã ĩna gãjerã. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","To bajiri to ĩna yijare, Jerusalén ñarã, Acéldame vãme yiyujarã ĩna, ti sitare. Ĩna ocarema ri'i vese yire ũni ñañuju ti. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“To bajiro bajirʉaroja” David ñamasir'i ĩ yimasire socase me ñañuja, ado bajiro ĩ ucamasirema: “Masa mano ñato ĩ ya vi. To bajiro bajicõari ĩ ye moare ñaboarere, gãji moavasoato”, Diore yiucabosayuju David ñamasir'i, Judas ĩ bajirotire goti rĩjoro yigʉ. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","To bajiro David ñamasir'i ĩ yiucamasire ti ñajare, Judare ĩre vasoagʉ, Jesús ĩ rijato bero quẽna ĩ tudicatiro ĩacacʉre, Juan, Jesúre ĩ tuñĩabiaro ĩacacʉre, yʉa Jesús ĩ cõasʉocana rãca vacudicacʉre macato mani —yiyuju Pedro. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","To bajiro ĩ yiro bero, jʉarãre ʉ̃mʉare beseyujarã ĩna. “José vãme cʉtigʉ quẽnagʉ̃mi” yicõari, “Gãji, Mat'ias vãme cʉtigʉ quẽnagʉ̃mi”, yiyujarã ĩna. Josére, Justo ĩre yiyujarã gãjerã. Gaje vãmerema, Barsabás ĩre yiyujarã. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","To bajiro yicõari, ado bajiro Jesúre ĩre sẽniñujarã ĩna: —Jesús yʉa ʉjʉ, mʉ masiaja ñajediro masa ĩna tʉoĩasere. To bajiri ãnoare, “Nijʉa ñati mʉ besegʉ” yʉare ĩoña mʉ. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judare vasoarocʉ yʉa rãca moarocʉre ĩoña yʉare. Rojose yirʉ Judas yʉare vaveocami. To bajiri yucʉrirema rojose ĩ yicati vaja, rojose tãmʉotʉjabetiriarojʉ ñagʉ̃mi —yisẽniñujarã ĩna, Jesúre. ");
INSERT INTO bsnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","To yigajano, José vãme ucatuyujarã ĩna, gʉ̃tajʉre. To yicõari, gajea gʉ̃tare Mat'ias vãme ucatuyujarã. “Tiarire reacũĩato mani, ¿ñimʉjʉa ñati Dios ĩ besegʉma?”, yiyujarã ĩna. Gʉ̃tarire reacũĩacõari, “Mat'iane ñaami Dios ĩ besegʉma”, yimasiñujarã ĩna. To bajiri, jʉaãmo cõro, coja gʉbo jẽnituarirãcʉ ñañujarã maji. To bajiri, Mat'ias rãca ñarã, jʉaãmo cõro jʉa jẽnituarirãcʉ ñañujarã yuja. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés boserʉ̃mʉre Jesúre ajitirʉ̃nʉrã rẽjañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","To bajiro ĩna bajiñarone, ñaro tʉsarone bʉsi ocaruyuayuju õ vecajʉ. Bʉto mino cʉtiejarore bajiro ejayuju, ĩna ñarivijʉre. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","To bajicõari, jea ʉ̃jʉsere bajise ruyuayuju. To bajicõari tocãrãcʉrene ĩnare quedireajeoyuju. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","To bajiro ti bajirone, Dios ĩ cõagʉ̃, Esp'iritu Santo ĩnare ejayuju, tocãrãcʉrene. Ejacõari, ĩna ñagõmasirotire ĩnare ʉjoyuju. To bajiro ĩ yijare, tocãrãcʉne ricatiri rĩne ñagõjedicoasujarã ĩna, gãjerã masa yere. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pentecostés boserʉ̃mʉ ñaro, jud'io masa Jerusalén macajʉre boserʉ̃mʉ ĩarã ejariarã ñañujarã, Diore rʉ̃cʉbʉorã. Jud'io masa ñaboarine, ricatiri rĩne ñagõrã ñañujarã, gaje macariana vadiriarã ñari. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","To bajiri mino vatore bajiro ti bʉsisere ajicõari, jãjarã masa rẽjañujarã ĩna, ti bʉsirojʉre. To ejacõari ĩna ajijama, ricati oca ñagõrã ñaboarine, sĩgʉ̃ rʉyariaro mano ĩna ocare ajiyujarã ĩna. To bajiri, no bajiro yimasiña mañuju ĩnare. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","No yimasibeticõari, ĩna masune ado bajiro gãmerã yiyujarã ĩna: —¿Galileana me ñati, mʉa ĩajama? ");
INSERT INTO bsnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Galileana, mʉa ocare, yʉa ocare quẽne ñagõmasimena ñaboarine, ãnoajʉama, ¿no bajiro yicõari, mani ocare ñagõmasiati ĩna yuja? ");
INSERT INTO bsnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Adocãrãca sitana vadiriarã ñaja mani: Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, Frigia, Panfilia, Egipto, to yicõari, Cirene maca adojʉana Africana quẽne, Roma macajʉ vadiriarã sĩgʉ̃ri jud'io masa quẽne ñaama. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","To yicõari, gãjerã jud'io masare bajiro Diore rʉ̃cʉbʉorã Roma macajʉ vadiriarã ñaama ĩna quẽne. Creta, Arabia vadiriarã quẽne ñaama. To bajiro mani bajiboajaquẽne, Dios quẽnaro manire ĩ yiñasere mani oca rãca manire gotiama, Galileana ñaboarine —gãmerã yiyujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","To bajiro yitʉoĩarejaica yirã, no bajiro yimasibesujarã ĩna. To bajiri ado bajiro gãmerã yicõa ñañujarã: —¿Ñie ũnire yirã, to bajiro yati ĩna? —gãmerã yisẽniĩañujarã ĩna. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gãjerãjʉama: —Mecʉrã yama, yiajatud'iyujarã ĩna —Jesús buerimasa ñariarãre. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","To bajiro ĩna yiajatud'isere ajicõari, jʉaãmo cõro, coja jẽnituarirãcʉ ñarã rãca vʉ̃mʉrʉ̃gʉ̃ñuju Pedro. Vʉ̃mʉrʉ̃gʉ̃cõari, bʉto tutuase rãca ado bajiro gotiyuju Pedro, to rẽjarã ĩna ajijediro: —Quẽnaro ajiya yʉ yarã, yʉ gotisere, Jerusalén ñarã quẽne. ");
INSERT INTO bsnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Mecʉrã yaja mʉa”, yʉare yirãja mʉa. Mecʉrã me yaja yʉa. Busurijʉaca ñaja maji. Masa mecʉriajʉ ejabeaja maji. ");
INSERT INTO bsnNT_vpl VALUE