﻿USE sofia;
DROP TABLE IF EXISTS sofia.bsj_vpl;
CREATE TABLE bsj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bsj_vpl WRITE;
INSERT INTO bsj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Bifimer naniya Yecu Kiritti bibwe Dauda, bibwe Abrahame. ");
INSERT INTO bsj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abram co te Icaku, Icaku te Yakub, Yakub te Yahuda kange Yitub ceb. ");
INSERT INTO bsj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda co te Farica Kange Jera fiye Tamar wiye, Farica nyori te Hacruna. Hacarua co te Arame. ");
INSERT INTO bsj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram co te Aminadabe, Aminadab co te Nacone, Nacon co te Calmone. ");
INSERT INTO bsj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Calmon co te Buaja fiye Rahab wiye, Boaja co te Obida fiye Rut nine. Obida co te Yeece. ");
INSERT INTO bsj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yecce co te Liya Dauda, Liya Dauda co te Culemanu fiye wii Yuriya wiye. ");
INSERT INTO bsj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Culemanu co te Rehobwame, Rehobwam co te Abija, Abija co te Aca. ");
INSERT INTO bsj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aca co te Yehocafa. Yehocafa co te Yorame, Yorame cote Uziya. ");
INSERT INTO bsj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya co te Yotame, Yotam co te Ahaze, Ahaz co te Hezekiya. ");
INSERT INTO bsj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya co te Manacca. Manacca co te Amone, nyori Amon co te Yociya. ");
INSERT INTO bsj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yociya co te Yekoniya kange yitub cebo, dong-dong fiya cuwo ci yem ci, ci yaaken kici biten Babila. ");
INSERT INTO bsj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bwiko ci yem ci, ci yaken ci biten Babila. Yekoniya co te Ceyaltiyele. Ceyaltiyele co te Zarubabele. ");
INSERT INTO bsj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabel co te Abihudu. Abihudu co te Eliyakime, nimre Eliyakim co te Azuru. ");
INSERT INTO bsj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azuru co te Caduku. Caduku co te Akimu, nire Akimu co te Aliyudu. ");
INSERT INTO bsj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyudu co te Ali'azara, Ali'azara co te Matana. Nimre Matana co te Yakube. ");
INSERT INTO bsj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu co te Yucubu bwe Maryamu wo fiye ci wiye ci bo Yecu wo ci cuwo ti ki Almaciu. ");
INSERT INTO bsj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Core tau Ibrahim nin yaken ciko Dauda nineu kaltito kwob culombo naar, kange wo tau fiye yeka ciko ci yaken ki ci Babilau yaken ciko Kiritti nin, kaldo kwob culombo naar. ");
INSERT INTO bsj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bor Yecu Kiritti ko bwi nyo wo. Nece Maryamu ciya an nam Yucufu, naci nakangiri Maryamu kweri tum fer yuwa tangbe wucake. ");
INSERT INTO bsj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yucufu bwece nii cakcake, cuibo ci neco kwenduwe nuwe nobe, nyori cuiti naci nyangum kang cinen daar. ");
INSERT INTO bsj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","La ci kwa diker buro tiri, bibwe tomange kwama wucake cerkangu cinen mor dukume. yi coti “Yucufu bi bwe Dauda nuware tai, tum Maryamu wimwe, wori dike ci tum ciko fwereu ca fiya yuwa tangbe wucake nen. ");
INSERT INTO bsj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","can do bwe, mwa cuwo dencere ki Yecu, co ca fulo nubo ti fiye bwiran ker ciye. ");
INSERT INTO bsj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gwam wo an bwi na dim diker teluwe be toke nyii nii tomange, tokti ki, ");
INSERT INTO bsj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“To bubya an tu fwer, naci bo bwe ciya cuwo den cero ki Imanuel” Dike dendo nungeu “Kwama wi kange bo”. ");
INSERT INTO bsj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yucufu kwenu dumbo nineu, maani na wo bwe tomange kwama yiceu, cin kuni con tu wice. ");
INSERT INTO bsj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yucufu Nyomombo wice wi co bom bwe La con co dendo Yecu. ");
INSERT INTO bsj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bwikako ci bo Yecu Baitalami biten Yahudiya ki core wo Hirudu Liyau, Kangem nob nyomka bifumer kwama bo Urcalima. Tokti ki. ");
INSERT INTO bsj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Fee wo ci bo Liya Yahudawa? nyon to bitiren cero twar, nya bo na nyi wabka. ");
INSERT INTO bsj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","La Liya Hiridu nuwa nyori, kwom co kambo ken kange hwam nubo Urcalima. ");
INSERT INTO bsj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hiridu mwer Liyab wabe kwama gwam kange nob mulankab nibe. me ci “kiriti a bo fe?” Cin yi co. ");
INSERT INTO bsj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“ Mor Baitalami Yahudiya nyo won co dike bibei tomange kwama mulange”. ");
INSERT INTO bsj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Mo Baitalami mor biten Yahudiya mo kebo wo duwal-duwali tiber Liyab yahudiya. more mwe an fiya nii a ca Liyar tiye wo a yila nii biyuwar nobo Lomi Iciraila”. ");
INSERT INTO bsj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","La Hiridu cwo nob nyomka bifumer reu, yurangum Yurange, me ci “Fiyang bitiren do cerkanguwe?”. ");
INSERT INTO bsj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Con twom ci Baitalami, yiciti, “Kom ya ki fuwa bwe biduware ki Lima ki Lima, no kom fiya ri, ko bou kom yiye, na mo ken nan ya nan wabco.” ");
INSERT INTO bsj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bwikako ci nuwa diker Liya yi ciye ri cin kwen ci ta nure, bitiren do wo ci to twareu yakenti ka ci ya yan titi dor luwe bwe bi duware wiye. ");
INSERT INTO bsj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","La ci to bitirndo ri cin bilangi ki bilankako dur. ");
INSERT INTO bsj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cin do mor luwe, nen cin to bwe bi duwareu kange nece Maryamu. cin cung bitine cin wabco. cin kwim cwaye ciye neco Lima nerek, mwinek kange lubban kange mor. ");
INSERT INTO bsj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kwama yi ci mor dukume, ciya yilare fiye Hiridu nine. yori cin yilaken bitine ciye nure kange. ");
INSERT INTO bsj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bwikako ci kweneu cin to nii tomange teluwe cerkangu Yucufu nin yi co, “Kwen tu bwe bi duwae wo kange bece cwa cu ciko biten Masare. ");
INSERT INTO bsj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kume cuwo Yucufu tu bweu kange nece u Masar. yi ken firen yinen di na nimre, wori Huridu cuiti na twalum bweu. ");
INSERT INTO bsj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Cin yike fire Hiridu Bwiyati. Wo na dim diker teluwe be tokeu nyi nii tomange, “Min cuwou bi bwemi Masar”. ");
INSERT INTO bsj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hiridu to nob nyomka Bifumereu bwanten bo ker cero ri mam funer ducce, cin twomi a twalangum bi bei nabarubbe bi duwartini gwam, wo Baitalami kange buro bi dom kange ce tati coro yob yirau ciko bitine. ");
INSERT INTO bsj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Fiya cuwo la dike nii tomange Irimiya toke dimme. ");
INSERT INTO bsj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Cin nuwa diro kange Rama ci wiye ti kinero fir cilong-cilonge, Rahila ci wiye dor bi beiyo locer. Mani ca fiya birum nere ti wo mani. ");
INSERT INTO bsj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Fiya cuwo Hiridu bwiyame, nii tomange teluwe cerkangu Yucufu nin mor dukume mansar. yi co, ");
INSERT INTO bsj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kweni tu bwe bi duwarewo kange nece yakan Iciraila, nyori niwo do dume bwetiye bwiyam”. ");
INSERT INTO bsj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yucufu kweni tu bwe bi duware kane nece cu biten Iciraila. ");
INSERT INTO bsj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","La ci nuwa Akilayu bi bwe Hiridu Ca liyar ti biten Yafudiya, con nuwa tai lakako firen. Bwikako kwama yi co ker mor dukume, cin tiyangum biten Galili. ");
INSERT INTO bsj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yiken fiye kange ci cuwo ti ki Nazaret wo na dim dike ci toki nyii nob tomange ki, “Ciya cuwo co ki bwe nazare re. ");
INSERT INTO bsj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kume ni wo Yuwana yu mwem kwamam tiyeu yau ne fulen ker kwama ro ti. ");
INSERT INTO bsj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ko yiloten wori, liyar do lo kwama dadom. ");
INSERT INTO bsj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","won co wo nii dukume kaya tok kerce reu, “Dir nii kanger co bi cor ti kii, toki, “ko Yuwel Teluwe nin nureceu, fuwak ceko atim. ");
INSERT INTO bsj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuwana merum ki belle yiri teleme, bwam ki dk teak fer cer. Cari ceu, kwake kange yuiti to kiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Co rubo Urcalima kange wo Yahudiya gwam, kange bitine tinim bo kong Urduneu, ci bou ti ka bo ka tuje co wiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na ci yuu cinen mwem kwamam caji Urdun, kambo ci tok bwira kerer ce tiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","La co to Faricawa kange cadukiyawa kila cirangum ti na co yu'u cinen mwem kwamamedi co ca ciye, “Kom berin nacuwe ki mwan neu, we wer kom ko cuam funero wo au tiye. ");
INSERT INTO bsj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ko ne bituti wo a nung yila ka kume ko tiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ku kware mor ne kume kom ki Abram te kume! be ma yi kom ti, kwama wi kibi kwan do wo a kung Abram nin bibeiti fo tetendo wuro neneu. ");
INSERT INTO bsj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na wonyeu yoti biteye dimer tiniro nan, na cori tiyowo ne bo bituti keneti, an tom co na merken mor kire. ");
INSERT INTO bsj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ma Yukumen mwem kwamam bo ki mwem, ya ciko yo laka kumekeu. Niwo bouti bui mi yeu layeki dur, woro ta ceu ma labo nan tu'u. co ca yu'u kumen mwem kwamam bo ki yuwa tangbe kwama, kange kira. ");
INSERT INTO bsj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kwele yu'u ka ceko tam kang cek, can nyinagum teneu wiyak, na murom bikateceu na yo ken binico.” ");
INSERT INTO bsj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","La Yecu bou biten Galili, ya caji Urdun fintange Yuwana nen, na yu'u cinen mwem kwamam. ");
INSERT INTO bsj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","La Yuwana mani naco kicim co, tok ti ki, mo wo ma cuiti na yu'u mwem kwamam meu, mom bou minen?”. ");
INSERT INTO bsj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yecu yila yi co a ma nyo na dim cak-cakeu gwam. Co Yuwana ciya cinene. ");
INSERT INTO bsj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Buiko ci yu'u cinen mwem kwamam be di, Yecu cerum can duwo mor mwenge, La dii kwama wo cinen. La co to yuwa tangbe kwamako yirau ti docer na nagumfiye, yira yiti dorcer. ");
INSERT INTO bsj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","La diro kange lo kwama ceru toki, wo bi bwemi ma cui cuiyeu, ma nuwa luma cek ti. ");
INSERT INTO bsj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","La yuwa tangbek kwamako tu Yecu yaken ciko mor yere na bwekelkele na cuwaco. ");
INSERT INTO bsj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bwiko co yi yim Ngakem kakuko kwini na'ar kumeu kwini na'ar di wura tam co. ");
INSERT INTO bsj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nii cuwa kako bou cinen yico ki, “No mo bibwe kwamari yi tero wo ayilam cari”. ");
INSERT INTO bsj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yecu yila yic mulagum mulange, Nii mani a dwiti ki cari ki kwace ce kange ker kwamar. ");
INSERT INTO bsj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","La bwekelkele to co yaken ciko mor cinan lor wucakeu. La kung ken co dor ku waber. ");
INSERT INTO bsj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","La yii co ki “No mo bibwe kwama ri, mwou bitine wori mulangum-mulange, ki “Can yi bibei tomange ce wucakeu na cer nen” La ci an kungum nen dii mor kani ciye. be na mo kware na mwek ter”. ");
INSERT INTO bsj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yecu yi ten co mulangum mulange mani mwa cuwa teluwe mwe kwama ti ko. ");
INSERT INTO bsj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tak, di Bwekelkele tu co kungken co bang ko wo cwem-cwemeu, La nung cenen Liyar do kaleweu gwam kange duktanka ciye ko. ");
INSERT INTO bsj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","La yico ki dike wo gwam man neken nen no mon cung cunge mo wab yeri. ");
INSERT INTO bsj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","La Yecu yico ki “kubom fou bwekelkele be mulangum mulange, Wab ka teluwe mwe kwama co win. ");
INSERT INTO bsj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","La bwekelkele dobco, La wo bibei tomange wucakeu bou cinen (wabco). ");
INSERT INTO bsj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","La Yecu nuwa cin tam Yuwanari, con cerum yilan ken Galili. ");
INSERT INTO bsj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Co dubom Najaret cin yaken Kafanahum, wuro knog caji Galiliyeu, yii ka bitinek Jebulun Kange naftali. ");
INSERT INTO bsj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","wo ma nye na dim kero Icaya nii dukume tokeu. ");
INSERT INTO bsj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","biten Jebulune biten Nabtali wo kong Cajiyeu, kange dinge caji Urdun neu, Galili nob kumtacili. ");
INSERT INTO bsj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nubo wuro yim kumtacili yeu, cin to filanko dur, la buro yim wi fiyeceu, knage kakulok bware keu, dor cir fiya filanko ti kweni. ");
INSERT INTO bsj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","La fiyaco di Yecu yoten fulonka ker kwama ro, ko yolaten wori liyaro loh Kwama biyeken bidom.” ");
INSERT INTO bsj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","co yakenti knog caji Galili, con to yitob butib yob, cimon wo co tiki Bitru, kange Andrawu yii ce mer biliyar ti mor caji, cin nobtaka jingeb. ");
INSERT INTO bsj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yecu yii ci, kom bou ko buang menten, an yo ka ta men nob. ");
INSERT INTO bsj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dang jang ci dubom liyar cero cin buang ten co. ");
INSERT INTO bsj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","La Yecu dubom wi yaken tiri con to ten yitobbo kange ci yob, Yakubu bi bwe Jabali knage Yuwana yii ce, ci yim mor nabire mwenge kange jabal Tee ciye yulang biliyar ceroti. ");
INSERT INTO bsj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Con co ci dang jang cin dubom nabire mwengeu kange jabali tee ciye, cim bwang ten co. ");
INSERT INTO bsj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yecu kentangum Galili gwam, merang cinen ti mor bikur waber, tok fulen ker liyar kwamaro ti twa'a mwanti tiire ti gwam kange nubo nuwabo lumau. ");
INSERT INTO bsj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","La fulen kere ro dor cereu yake kale mor nubo ciriya, co nubo co ci bou cinen ki nubo wo kalati ki wang ki wang kange kwirom bwi kange buro kelkelibo o cinen ti bwiyeu, kange nob juibe, kange nubo kani kange nani bwiyarangumeu, Yecu twm ci. ");
INSERT INTO bsj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nubo nawo kila kilau bwang cinen ten Galili kange dika foli kange Urcalima kange biten Yahudiya, yaken ciko dinge Urdun neu. ");
INSERT INTO bsj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kambo Yecu to mwerkang ka nubo ducceri kwiken dor bang-er. La cin yikenwi, nob bwankacebo bou cinen. ");
INSERT INTO bsj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wumom mor nerer ciro takri to merang cinen. ");
INSERT INTO bsj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Bi bwiyer kiniwo bwini na yuwa tangbeceu nyori liyar kwama ki cii. ");
INSERT INTO bsj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bibwiyer kiniwo kibwatummeu, wori ciyatin macinen dangnee. ");
INSERT INTO bsj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bibwiyer ki nubo wo ki kunne wori kwalito dorbitinero ki cii. ");
INSERT INTO bsj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Biwiyer ki nub wurab kange dulo mwe wucakke wori atin bwam ki cii. ");
INSERT INTO bsj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bibwiyer ki nub cika bwinib wori, atinci bwinicito. ");
INSERT INTO bsj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bibwiyer ki nubo nero wucakkeu, wori ciyen to kwama. ");
INSERT INTO bsj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bibwiyer ki nubo ki fuwer nerereu, wori a cociki bi biylo kwama. ");
INSERT INTO bsj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","bibwiyer ki nubo wuro cii ne cii dotangeti ker caccaker, liyar kwama ki cii. ");
INSERT INTO bsj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Bibwiyer ki kom no nubo to komtiri, yila cii ne kom dotange ti ka kaa cii kwakomti kiner kan-nge bi kulentito bwir wo cuwer keceu, kermin. ");
INSERT INTO bsj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kom ma bilangtum bo man ki dii kau, wori Bitininge kumeu na dur dii kwama. Nan wo nubo ne bibei tomange dotange biro yii kaale na nyime komeu. ");
INSERT INTO bsj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kom mam dor bitinerembo cano mambo lem lumacekori, bi'amanyi na yilau cuko tak? mani ani yilamti kinan'ngen tak dila atin cutan wi na fuwarangum kina nubek. ");
INSERT INTO bsj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kom filang dor bitinero kowo cinar loro tom bidukleu mani yurangek. ");
INSERT INTO bsj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nubo mani kwer talkire tire dokken mor bulene, nyori ca kunnyii cayo fiye tikacek nane nubo luweu filang. ");
INSERT INTO bsj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","No nyori filang kume k acera kabum nubem ciya tom yorak na ngenek kumekotiyeu naci caklang tee kume wo dii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Km kware komki mabou nan bubam werfun nobto mangebo. ma boubo nan bubamci Dila nan dimci. ");
INSERT INTO bsj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wori bilenker miyi komti, diko kange bitineu an dim dila kiker biduwar kakaa denka win wo mani dimti mor bolang atin dim dikero kang. ");
INSERT INTO bsj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nawori niwo kimwo duwal duwale mor werfunen wonine kakaa ci merang kangum ciya manyeri, aciioco nawo duwal-duwale mor liyar kwamar. ");
INSERT INTO bsj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lari miyi komti miki “cawo-cawo cakcake kumeu tano labo cakcake nob mulangkab kange faricawbori, mani kakadokanti liyar kwamareu. ");
INSERT INTO bsj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kom nuwa kam inyi nubo nan duweu, kom taide dor, cano wo twaldoreri cikino cito warka. ");
INSERT INTO bsj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","La min yi kom ti woma funer kange keceri, kino mor cito warka. woyi kece, mun nifiro bwireri! cikino mor cito doka mor kirak kwamak. ");
INSERT INTO bsj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nawo nyori mwane funer nerer ti. tanyi landi kwabi kemwe wiki kwomka dorek kange mori, ");
INSERT INTO bsj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Dubom luman nerok kabum tan nyi lanem, yaa yam mwem. ki kabana, fuwang kangum kange kemwe na nyi me nabou na ne funer nerer mwero. ");
INSERT INTO bsj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Maa yuelka kange nii kiyangnye mwe kambo mudor nurer yaa kabum bolangem, ka nii kiyange mwe neken nen nii bolange nin nibolange an neken nen nii tomange ciyatin merkennen furcina. ");
INSERT INTO bsj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bilinker mi yinenti, mani mwa certi wi firen dila mwatin yati kemero ci bwang mwenten tieu. ");
INSERT INTO bsj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kom nuwa toki mare buraka. ");
INSERT INTO bsj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dila miyi komti, tona niwo to nawi ye, ki dilanka nuwa keri, cin kweri cin mam buroka kange co mor nerece. ");
INSERT INTO bsj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ca no nuwa me cacciyoro an dok nen kottankari, kurangum co, minangwi fiye muwiyeu. La diker win mor ayak cam, ca merbo curen buyet mwero gwam mor kira kwamak. ");
INSERT INTO bsj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kakaa kom mweko cacciyero tano atin atim dok nen kottang kari, mwattumco miranwi fiye muwiyeu. wori in La diker win mor a yakcam, kange merka buye mweko gwam kirak kwama. ");
INSERT INTO bsj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yilam to ki niwo ywa wice ri, a neco bifumer nyaka kangeko. ");
INSERT INTO bsj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dila miyi komti tano wo ywa wiceri, cano nobo dor kangka diker kayakardi, cin yilam kico ni burokak. ");
INSERT INTO bsj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kom nuwa ten cin yi ki nubo burombo nan duwoo kom werde weri cwerke, dila kwama werka kumeko kwamanin. ");
INSERT INTO bsj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dila miyi kom ti komti kom werde weri di kwamaka wori Nkunjala kwama; ");
INSERT INTO bsj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kakaa kange dorbitiner fititim nanice, kakaa Wurcalima, wori biten liya dur. ");
INSERT INTO bsj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ca bu nano ka werweri ki dor kumerdi, la mani ka dolti kom yilam ki yiri duwekume fuwoje kakaa fije. ");
INSERT INTO bsj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dila Ker kumero a yilam NYO Nyo, nonindi 'Nyonin, nyonin. Cano dikero cumweri, kino bwirkonin. ");
INSERT INTO bsj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kom nuwa toki ki, Nuwe nyii nue nundo tak nyii nunne. ");
INSERT INTO bsj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dila miyi komti kom mare Kwobkangka kange niwo na bwireu, nyiyoco nyeu, no cii malicom dan-nge cattiyereri, kom yilam cinen wineu ken. ");
INSERT INTO bsj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No ni kannge wii a yakenti ki kiyange kume kabum boulangem meriwori naci yo belle kueri kom netten nii wo lalan kumeko. ");
INSERT INTO bsj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cano ni dokkom yam nako kwininugri kom ya kannyace yob. ");
INSERT INTO bsj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Komne nii wo mekomeu, tak kom kware niwo do naan ti kumeneu. ");
INSERT INTO bsj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kom nuwa dike tokeu, mwan cii ni bidome mweu mwanko ni kiye mweu. ");
INSERT INTO bsj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dila min yi kom ti kom cii nob kiyeb kume bo, kom kwob nubo nekom dotannge tiye nin dilo kom ma nubowuri, cil komenin bibuyer, komma nubo wo ko kom tiyeu nin dikoro ken. ");
INSERT INTO bsj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Naweu nakom yilam bibiyo lo tekume wo dikwamau. wori dok kakuko wennii bwirninti kannge nii ken twom wucakke kannge nii maakenin mwom dikwamati. ");
INSERT INTO bsj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wori cano kom ki cwi nubowuri cwikom tiyeri, nyii dikedde kom fiya? kebonyo nob yoka doreko matiya? ");
INSERT INTO bsj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kume keneu tano kom yarum ka 'Kebkumebri, yekamani la tangece? kobonyo nubo nyombo kwamau matiya? ");
INSERT INTO bsj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dila naweu nyi lam nyo kom yilam cikocok nawo tekumu wodiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kom yilam yiber dover ko mare luma kume ko kabum nubem be naci tokom, no kom ma nyori, mani ka fiya cuneti fiye tee kume wo dii kwama wiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","La naweu, no kama luma tiri kom cure cume kambo nubo bwirko mati ku wabe kannge dor nurereu wori na nubo caklang ci. Bilinker miyi kmo ti cin fiyam nyii diker cero. ");
INSERT INTO bsj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","La tano kama luma tiri kam kume moutkeu anyomde dike kango cattiyero matiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wori na lumake meko na yilam yurangum yurannge. Tee kume wuro to dikeroti yuragum yurangeu, atin makumen cuner. ");
INSERT INTO bsj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tano kmbo ka kwob diloti takeri, kom yilam de na nubo bwirko, wori ci cwikwoka diloti timotiye ku wabece kannge cuga nurek tak, wori na nubo toci. bilenker miyi kom ti cinn fiyam cuner ceko fou kale. ");
INSERT INTO bsj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","La tano kom kakwob dilotiri, kom doken mor kuwe. Kom nungum nyiloko, kom kwobdilo Tee kume wo yurangum yurange an nekom cuner kumero. ");
INSERT INTO bsj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ca no ka kwob dilotiri, kom libride diker manki nagenneu. nawo nubo nyombo kwama matiyeu. wori kwanererceu ciyatin cuwa tuuki keticro dukceu. ");
INSERT INTO bsj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Na weu ko yilamde naci wo Tee kume nyimoum bwini kumero kikinning nanyime kom kenco. ");
INSERT INTO bsj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Na wori kom kwobdilo nawo Tee bewo dii kwamau, ane den mwero dur wucak. ");
INSERT INTO bsj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Liyar mwero a dou ner nuber. ");
INSERT INTO bsj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ne nyo carto na dume ce kume -kume. ");
INSERT INTO bsj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dob Nyinen bwirang kert nyero. nawo nyi dob nubowo ma yinentiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yare kinya Fiye cuwaka, dila cok nyo nii bwir konin (kanng Liyar kannge bikom liyaret kange duktanka ka na mwe diri diri ati nyo). ");
INSERT INTO bsj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wori no kom dob nubori bwira kerer cirori, Tee kume wo dii kwamau an dobkumen ken. ");
INSERT INTO bsj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ca no ka dobbo nubonen bwirang keretinin cirori Tee kume mani a dob kumen ti. ");
INSERT INTO bsj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nyotak, no kama nyak tiri, kom yilam kitikob na nuwoma mwamangtu tiye kambo nubo bwirko matiyeu, wori ci kwuob kang yirom cimboti wori naci dannyi kabum nubem mwincimen Nyak ti. Bilenker miyi kom ti ci fiyam cuner cero. ");
INSERT INTO bsj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dilacano kom ma Nyak tiri kom beltu nuwan der kom nirum tikob kumebo. ");
INSERT INTO bsj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","La nanubo nyumde kom ma Nyak ti, lakan Tee kume wo to dikero kom matiyeu yurangumeu ati makumen. ");
INSERT INTO bsj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kom mwerde dor kumero nii cuweka for dor bitinet, fiye kerkere kange cnkume a kanngum tiyeu, fiye nob kubbo bani werti do kuumme. ");
INSERT INTO bsj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nyiyoco Nyeu, kom mwer dor kumer kange nii cuwaka firen dii kwama fiye kerkere kannge cankume mani yeu. nawo a kanngum tiye fiye tak nuu kuyee mani werti na kumme. ");
INSERT INTO bsj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Fiye cuweka mweu wiyeu ner mwero ki nowi ken. ");
INSERT INTO bsj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nuweu co talkire bwiyeu. Nawori cno nuwemweu yorari, bwiyo kwarub dimki filang. ");
INSERT INTO bsj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","la cano nuwemweu dikero kendi bwiyo kwarub dimki kumtacile. ");
INSERT INTO bsj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nii mani bwiya bwnagten, Tee yobe La catin ciya wi ci ko win mani nyori can ciya kanyenin win ci cuyekangum wiceu. ");
INSERT INTO bsj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","La na weu, miyi kom ti kom kwomre dor yimer kumer kidiki kacati yeu, kannge diker na netiye kakaa bwikume dike kama kulenti cikeu. Naweu dume labo carita, bwiyo labo kulanda. ");
INSERT INTO bsj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kom to bilibenti dii kwama maci fi fik kakaa biyeka maci mwerank tak mor bine, Tee kume wo diyeu. No nyori kalancibo yorankka. ");
INSERT INTO bsj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","we more kume a cob dorcero ninten cwemka kumetik kiker dikerowo kwom cotiye? ");
INSERT INTO bsj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","La nya ko kwom dor kumeroti ker kulenerer? kom to funti nimbo kiyeu, kambo ci dwitiyeu. maci du kulent. ");
INSERT INTO bsj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gwam kange wuru miti kom ti, culemanu ken mor dukktanka mabo nawin more birombonen. ");
INSERT INTO bsj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cano kwma maa yera ko kiyenen bwa yilendi, wuro duwei notiyeu firuri ciyan merken yiri infe Danka Yorakko. kom dobbo dubo ki bwini bilin kerereu? ");
INSERT INTO bsj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nawo nyeu ko kwomde kom ki “Ye ba catiye, Ye ba dutiye ");
INSERT INTO bsj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Na weu nubo nyombo kwama wuyak ci do dukum kulenenmbo woti, Tee kume wo diyeu nyimom kom ti citi. ");
INSERT INTO bsj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dila kom do liyar cero ki kaba kannge ladi kulendowo kwarub ciyan nekom. ");
INSERT INTO bsj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nawue. kom kwomre dor kumer ko bwikume kwarub kumeniu ci dontanngece. ");
INSERT INTO bsj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kom mare warka, na cii makumende Warka. ");
INSERT INTO bsj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ki Warkako kom ki wardeu, ciya warmwen ki kwele mwa cuwa, ki kwele cu ciya cuwamwen cuko ");
INSERT INTO bsj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ye bwi muto cukkum bwatiye ti nure kemwe dila mutobo we mweu nure mwe? ");
INSERT INTO bsj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kaka ca manyi mwayi kemweti Berin cok mwe be dikoro nuwe mwe, wendi cuktom bwatiyeu wo nuwemwe? ");
INSERT INTO bsj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mwo nii bwir teri cokum cuktum bwatiyeu nuwe mwe, na yimde mwatin dolum mwan tom yor, kambo mwa cukom cuktum watiye ti nuwe kum mwe ");
INSERT INTO bsj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kom nere bicurle dikerowo wucak wucakkeu. la ki kom merde bilerinin cari bwayilenner kumer kebo nyo ri ciya fuawrumci. ");
INSERT INTO bsj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kii ni ciya necom do mwatin fiya kwabi tak, an womwen. ");
INSERT INTO bsj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ca niwo keneri atin yo, wo kwaberi atin wom ci nen. ");
INSERT INTO bsj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kakaa weni more kume, bibwece a kenco Tilitari la a ne co ta tiye? ");
INSERT INTO bsj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kakaa no kenco jinge tiri a ne co na cuwetiye? ");
INSERT INTO bsj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyori ca no kom bwirembo, ko yumum kambo kane bibiyo lokume lumako tiye, kambo Tee kume diyeu a ne kom dikero kentiye. ");
INSERT INTO bsj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Na woro di gwamra dikero kom ci ti nubo amakume neu, kom macinen ken. ");
INSERT INTO bsj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kom doken nure wo dwaldwaleu, wori nure buareu kuya in nurewo bwaibo doka nob dokabo moreceu ci kila kabo. ");
INSERT INTO bsj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Di la nureu yaken dumeu kwati kabo, nureu na wo bwai doka nub fiya kaceco kila bou. ");
INSERT INTO bsj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kom nyimi ki nob tomangeb dukumeb cuer kobe burombo bokumentiki curen kwamereu, bilinke cin nyece-nyece burombo kuyamtiye. ");
INSERT INTO bsj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka tin nyumom ci kibi tuttuice nubo cok mwembo twiber ko bwi cuike kakaa nying bwi cilannge ka. ");
INSERT INTO bsj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nyo kwarub Tini yoken kitu bi tuttuie ken tiyo bwirko ki tuttuice bwir. ");
INSERT INTO bsj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tiyo yoryoreu mani tu bi tuttwi bwirti, yo tak tiyo bwir mani tu bi tuttwiy ken. ");
INSERT INTO bsj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tano tiyowo mani ne bituttuti kentiyeri laciya tom ciya merken mor kire. ");
INSERT INTO bsj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","La nyori kin duku bibiyem bowo anyomcitiye. ");
INSERT INTO bsj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kebo nubo wuyak yiye tiki Tee, Tee adokenti o kwama dila niwo bwanteng ker tee mire dii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ki ka koko wo ducce an yi ki Tee, tee nyori nyamabo ker dukkumer kiden mwer nya cobo niya kiden mwer. nya mabo nangen do durbitineu ducce kiden mwera? ");
INSERT INTO bsj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","La man yici ma yomkombo ko dubomye, kom nob make bwira kerer. ");
INSERT INTO bsj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","La naweu Manang cemen cukotakeu, can dang kengco na ni nyomka wuro mu kuceu bangereu. ");
INSERT INTO bsj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","La mwembo cuweri yuwako kunou kwa luweu dila yarbo wori ci muco dor bangek. ");
INSERT INTO bsj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Di la niwo nuwa kermirori mabo nange cike, ciya dan co kannge kulenii wo mu loceu dorbi ti nere. ");
INSERT INTO bsj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mwembo cuire mwem wurmamkako bou dila yuwa ko kwenu kwa luwe yalam bukti. ");
INSERT INTO bsj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","La kambo Yecu dim tokka keti ceri mwerkan kako nyimang merang ka ceko. ");
INSERT INTO bsj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","wori meran ci nen ti ki bi kwan liyarer, kebona mulangkab. ");
INSERT INTO bsj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","kambo Yecu yirau do doweri nubbo ducce bwancinenten. ");
INSERT INTO bsj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","La nii ki wale kung diro kibi kwan ki no mwi ciu tiri mwatin yilam kimo wucak. ");
INSERT INTO bsj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","La Yecu tar kang ceko kico ri ki “miki cui”. La yilam wuccak, la dang jang dang jang cii yilam wucak ki wale ceu nen. ");
INSERT INTO bsj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yecu yico “yire nii ka nge diker” tame nureu ya nung dormwero nii wabenin na mwi ne lumacere ko werful muca ko tokeu. wo buka kanger ce ko. ");
INSERT INTO bsj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","kambo ci yilau ti kafanahum meri, nii dur nob kweneo bou cinen ken coti. ");
INSERT INTO bsj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","La ki Te luwe bwe canga dam lo kilen di la nuwa dotange ti kambo ken. ");
INSERT INTO bsj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Di la Yecu yi c o “Matin bou nami twam co” ");
INSERT INTO bsj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nii dur nob kweneb bo ciya co ki “Teluwe mi labo wo mwi bou to lo miyeu. Tok kaker dila bwe canga ni atin twam. ");
INSERT INTO bsj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","wori no mo ken min nii ciyo dur biwan keret, tag ri min wiki nob kwenebo min dur dor cere. Miki yi w miki ya ri ci yaken, ki kanage 'bou ri ci bow kange ki canga mi, ma wuro dila cimam. ");
INSERT INTO bsj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kamo Yecu nuwa weri, cin nyi mangi la cin yi biro bwang cinnen ten tiyeu, “bilenker mi yi kom ti mi fiya bo kange win wo ki bilenker nawo mor Iciraila.” ");
INSERT INTO bsj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Min yi kom, kila atin bou twaar kange me la ciyan ca wari kange Ibrahim, Icaku kange Yakubu mor Liyar kwamar. ");
INSERT INTO bsj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yilo bibei liyareu atin cor ke mor kumta cilero kiring kiring fiye cika wiyek kange kika nuneg? ");
INSERT INTO bsj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yecu yi dur nor kwenebo, “ya nawo mwi le bilenkeu, la a mamwen nyo dila cnagau twam ki kwama don-dong (Yila mwenyo). ");
INSERT INTO bsj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","kambo Yecu bow mor lo Bitruce ri cin to fer Bitruce nawi yeu dam da nuwa luma ki kwi bwi. ");
INSERT INTO bsj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yecu tai kang cekori la kwirom bwim bo dubom co. Dila cin kweni cin ter maka cinen carito. ");
INSERT INTO bsj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kambo meu dome ri nubo bow Yecu ki nubo kila wo ki kelkelitini yeu. Ciin cikangum yuwa tangbe tinito ki ker yila cin twam wiyak biro nuwabo lumau. ");
INSERT INTO bsj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ki nure wo la diim digero toku nyi kaya nii tomange, tokti ki “co ciki bwico yem bwii nuwa ka luma beko ri yila cin tum twirak beko”. ");
INSERT INTO bsj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","L kambo Yecu to mwerkako duce ken tangum ceri cin neci nyal naci yabken kong wimak ko Galili. ");
INSERT INTO bsj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","La ni mulankak bow cinen di to ki ki, “nii meraanka, matin bwang mwentn {Bwen no mwiki yang fye mwi yakenti wiyeu gwam feri}”. ");
INSERT INTO bsj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yecu yi co ki” wiki buwak cek, kange bilibetinim wo dii kwamau wiki lo cece dila bi bwe nii fire mani ki fiye wo ci yom dor tiye.” ");
INSERT INTO bsj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","kange mor nub bwang kab cebo yico, “Teluwe dob ye bwiri nan ya nami fwerum teni”. ");
INSERT INTO bsj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Di la Yecu yi co ki “Bwangmenten na dob nubo bwiyamen na fwerum bar cero. ");
INSERT INTO bsj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kambo Yecu dogen tukom bwatiyeri, nob bwangka cebo bwang ci nen ten more ce. ");
INSERT INTO bsj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","La yuwako durko kwenu mor wima, tokum bwantiyebo cimon ki yuwa mwengeb. La yecu dam dum. ");
INSERT INTO bsj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nob bwang kab ceko bow cinen di yunco tokti ki “Cer nyo Teluwe, yan bwiya rangum. ");
INSERT INTO bsj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yecu yi ci “Ye bwi kom cua tai tiye, kom wo ki bilenkere biduwaru?” Di la cin kweni la werang yuwako knge wimau. la cinge dur tam. ");
INSERT INTO bsj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nubo nyimangi la ciki “nage nii ko wini wuro, wo ki yuwa ce kange wima nuwa co tiye?”. ");
INSERT INTO bsj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kambo Yecu bow dinge wineu kange mor biten gadara nubo yob wo ki ninga tininyeu wab kam co. ciki ceru mor tuwe, la ci bwi kabo wo nob yameb mani cu nure wiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","La cin kwa kiyakye ki dir cin yi ki “ye yo nen kange nye, bibwe kwama? mwi bo fo namwi nenyo dotange nanyumde kwama nye lauwa?” ");
INSERT INTO bsj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","La nyere tini duce ca canak ti fiye co, kwitangbo ducce kange fiye ci niyeu. ");
INSERT INTO bsj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ninga tini tii kinito Yecu nin ciki “No mwi coknyori, tungen nwo mor nyere tini. ");
INSERT INTO bsj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yecu yi ci “ko ya” la ninga tininu ceru yila dogen mor bentilen nyeretini, la bentilen nyeretiniu yirarangu kulor dugleroni di corge mor wima cin bwirangum mor mwege. ");
INSERT INTO bsj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nubo to nyere tiyeu cin cua cin cu dila cin yaken mor cinar lor la cin yici digero bwiyeu wiyak. diger fiya nubowo ki ninga tiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","La cinartoro wiyak ceru naci wabkan Yecu. kambo ci to ceuri cin kinong co ca dubom cunga ceko. ");
INSERT INTO bsj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yecu dogen nabire mege, yabken dingeri la cin bou mor cinanlor cer. ");
INSERT INTO bsj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","La cin bo cinen ki kilen niir dam dor bicirit ki, toka bilen keret cero ri, Yeu yi kilen mire, “Bwe, bim ner. bwiran keretini mweron tabum cuko. ");
INSERT INTO bsj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","La knagem nob mulangab toki bwiti ci, “nii wo na dur ti”. ");
INSERT INTO bsj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yecu nyumom diger ci kwati ner cereu cn yiki “Ye bwi kom kwa digero bwiti ner kumere? ");
INSERT INTO bsj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na wini bweibe, a tokki bwiran kertni meu tabum, kaka a tiki 'Kweni ti na ya yambo?' ");
INSERT INTO bsj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Di la nako nyimori bibwe nii fire wiki bikwan keret dur kaler na tabum bwirangker, “ci yi kiledo, “Kwenti tum biciri mweu na yaken lomo”. ");
INSERT INTO bsj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Di la nii cou kweni lan cu gen loco. ");
INSERT INTO bsj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kambo nubo mwe rumweu to eri, cin cwatai ri cin duktan kwama, wo ne nubo bikwan nerero naweu. ");
INSERT INTO bsj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kambo Yecu cuken fiye ceri, cin to nii dndo Matta yim fi yime nob yoka nob yoka dorekke. cin yico “Cin yi co bwangmenten” la cin kwani cin tiri cin bwangcinnenten. ");
INSERT INTO bsj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nawo Yecu yiken caka cari mor luweri, dila nob yoka dorego duce nob bwangketi bow la ca wori kange Yecu kange nob bwangkab cero. ");
INSERT INTO bsj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kambo nob diklingebo to weri cin yi nob bwangkabo ceko “Ye bwi nii merangka kume ko ati wari kange nob yoka dorek kange nob bwirangkere?”. ");
INSERT INTO bsj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kambo Yecu nuwa na weri, cin ki nubo we kwamer mor bwiyam mani cui nii twaka, kanco nubo wo nuwa bo lumau. ");
INSERT INTO bsj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yom ya na kom merang digero wo nung tiyeu: “Miki cui nuwa ka bwinik la kebo twika nuwange go ficange. ma boubo nan co cakcak na yiloten, dila nob bwirangkereb. ");
INSERT INTO bsj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","La nob bwangka Yuwanako bow cinen, ciki, “Ye bwi nyo kange nob diklingebo yiti ngag kang kangri la nob bwangka mwe ko mani yiti ngag ngage? ");
INSERT INTO bsj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yecu yici “Bibei nange ne ku duklume tin ci wiye ki kwamawo nii bineu wari kange ciye? Di la kumetini ber wo ciya tum nii bincu ti cine neu la ciya tin yi ngag ngag. ");
INSERT INTO bsj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nii mani a yoten fiti kwele fwirti dor kwilenero car wori fiye tabeu atin woram bwi kwileneniu rila worakako atin bwira. ");
INSERT INTO bsj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaka nubo kiyo mwem bituituinbo fwir mor bantilando car. No ci mani nyori, bantilando atin wurom ri mwem bo tuituinbo atin curi la bantillando wurom. nyori ciki yo bwem bi tuituinbo fwir ko mor bantilando fir ri naci lere kange ce. ");
INSERT INTO bsj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kambo Yecu tok digero biro tiyeri, la nii dur bow cung cinen. riki” bwe bubiya miu bwam na wonyo dila bow yoti kang mweko cinenn naci kwenim. ");
INSERT INTO bsj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","La Yecu kweni bang cinenten kange nob bwangka ceko. ");
INSERT INTO bsj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","La nawiye kange wo kala ti cor ka bwiyalecu coro kwob cilombo yobeb bow bwingob Yecu la cin ke nyi kwilencero. ");
INSERT INTO bsj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ri cin yi dor cero, “tano matin teyim ka kwilencerori man yilam kwamer”. ");
INSERT INTO bsj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Di la Yecu yila kangi lan to co, “Bwe Bubiya” bim ner, bilenke mweu twamnen”. la nawiyeu fiya twaka dangjang. (Ki kwama co.) ");
INSERT INTO bsj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kambo Yecu bou lo nii durreu, cinto nubo cu lira tiyeu kange nubo dimeu ma dike ti duce. ");
INSERT INTO bsj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ciki “ko yakenti Bubiyau bwiyabo, dila ciki da dum. “Di la ciin nunco ki cuekanka. ");
INSERT INTO bsj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kambo ci cokken nubo kaleri, cin dogen kuwenin la cin tau co ki kang, la Bubiyau kwenim. ");
INSERT INTO bsj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","La kerowo yalati cinanlor cunga ko cuew. ");
INSERT INTO bsj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kambo Yecu cungenti fiye ceri, fugma tini yob bwang cinen ten. cin tii kwaka direko la ciki, “nuwa bwini nyero, Bi bwe Dauda? ");
INSERT INTO bsj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kambo Yecu bow mor leuweri, fugma tinimbo bow cinen. Yecu yici, “Kom ne bilenke matin ma diker wa?” cin yico ki “Og Teluwe”. ");
INSERT INTO bsj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Di la Yecu ke nuwe cue ri ki a yila kumen dong dong bikwan bilenkerer kumer”. ");
INSERT INTO bsj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","La nuwe cue womagum Di Yecu neci bi werer kibi kwan, “Nii kange a nyomde diker dor wo” ");
INSERT INTO bsj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","La nubo yobeu cerken wam kero dor dikero wo cunga ko cuo nin. ");
INSERT INTO bsj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kambo nubo co yobeb yaken tiri cin bou Yecu nen ki nii wo tabang tabange ker ti ki ningau. ");
INSERT INTO bsj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kambo ci cukom nigari nii wo tok ker la na nubo dimmeu nyimangi ri, “Nii tombo dikero wo wi biten Iciraila?” ");
INSERT INTO bsj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","La nob diklingebo tok ki “ki bi kwan iyar niga ci cikang ninga tiye.” ");
INSERT INTO bsj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yecu bwangten cinar lor gwam kange cunukur cin cakaba ki meranka mor bi kur wabka ci tok fulen ker liyaret kange twakak dimer ni twirakeo gwam kange lumako nubo neneu gwam. ");
INSERT INTO bsj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kabo cito mwerka nubekeri cin nuwa bwini cero, cin nuwa dotange tiri cin cwam tai. ki “Kwama wo man ki nii toci tiye. ");
INSERT INTO bsj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Cin yi nob bwanka ce ko “Biyeka bitok ko duce ri la dob nangenebo kilabo. ");
INSERT INTO bsj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","La nyori ko kwob dilo wulom Teluwe beka, ko bitok ko nii nacin tung nob nagenebo mor biye ka bi tok ceko nin. ");
INSERT INTO bsj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeco co nob bwangka wari, la cin neci bikwan keret dor yuwa tangbeko bwir naci cukangwi ci, kane naci twam tuwirantini gwam kange nuwarangka luma ko maniyeu gwam. ");
INSERT INTO bsj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","La den nubo tomangebo kwob cilombo yobeu co buro ki kabou Cimon (wo ci cou tak ki Bitru) kange Andirawu kece, Yakubu bi bwe Zabadi, kange kece Yuwana. ");
INSERT INTO bsj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibu, kange batalamawu, Toma, kange Matiyu nii yoka dorek, Yakubu bi bwe Alfa, Kange Taddawu. ");
INSERT INTO bsj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Caminu Bakairawau, kange Yahuza Ickarioti wo miyem Ceu. ");
INSERT INTO bsj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kwobcilombo yobeu wo Yecu tomci cin yici ki nyal la ciki, “Ko yare fiye kange wo nubo yim kumtacileu, kom dore kange cinanlor nubo Camariya. ");
INSERT INTO bsj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ko ya nyori kwame wo lo Iciraila lem meu. ");
INSERT INTO bsj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","La kambo kom ya kom yii fulenker kom ki Liyar kwamak bow bidom. ");
INSERT INTO bsj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ko Twam wo nuwabo lumau, kon kungum wo bwiayameu, nako cokum ten ninga. lima nee ko yoke ko neken ki lima neek. ");
INSERT INTO bsj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ko tur kange mwin, azurfa kaka tagulla mor cuwaye kime. ");
INSERT INTO bsj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ko ture cuwaye Yam kimembo ce, kaka kulen, kaka taa wori nii nagenne daten cari cor. ");
INSERT INTO bsj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ki cinan loro kaka mwan loro ka doweri, ko do nii datenne more ce, ko cer locona nyim de ko dob fiye co. ");
INSERT INTO bsj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kambo ko do mor luweri, ko ma yarume. ");
INSERT INTO bsj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No luweu da tendi kom dob fur neret kumeu ayirati, no ci datenbori fur neret kumero ayilau kumen. ");
INSERT INTO bsj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nubo wo yo kombo kaka cuwa tu nuwa ker kimereu, Kambo kom cerum luwe nen kaka cinan lor cero ri kom fugom kwerdo nakume keu nen. ");
INSERT INTO bsj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bi lenke miyi komti Biten codoma kange Gomara atin fiya jire duwe ki kakuk bolanger kange cinan loro co. ");
INSERT INTO bsj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","To min Tomkom na kwame mor ngece ngece, ko yilam kiyiilam na nacuwe tini ri la ko wii re na nagum fe? ");
INSERT INTO bsj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ki yi ki bati kange nubo, ciyan neken kob kan nob yimnom dila ciya tin malliki kom mor bikur wabeb cer. ");
INSERT INTO bsj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ciyan bou ki kom kabum nob bolangeb kanage liya, ker mir na warkan cinen kange nubo yim kuntacileu. ");
INSERT INTO bsj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kambo ci neken komeri kom kwom de ki kambo kange dikero ko tok tiye, wori atin nekom di diker ko tok tiyeu ka kwama co. ");
INSERT INTO bsj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","wori kebo kom ko tok ker tiye, dila yuma tangbe te kume a tok kerti kumene. ");
INSERT INTO bsj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kece atin ne ken kece nai twalum, dila Tee ceu bibwe ce. Bibeyo atin kwinag Teb cebo nen tien ci doki ci twallagum cii. ");
INSERT INTO bsj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nubo duce an ko kom ker denen miir. Dila wo mwirom yaken ciko di ka ri ni cou atin fulo ka. ");
INSERT INTO bsj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No ci nekom dotange cinar lor wori koom cuaken cinan loro bdomeu, la miyi km bilenke ti, mani kom kentange cinan loro Iciraila ti wiyak nangimde bibwe nifire n bou. ");
INSERT INTO bsj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ni bwanka duwi bo la nii merrang cinen tiyeu kaka canga dor Teeluwe ce. ");
INSERT INTO bsj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dong dong ni bwanka a ylam a nii merang a ceko, kange caga na teluwe ce. Ta no cin cou Tee luweu Ba'al zabuba ri, la an bwira dendo wo ciya com numo loceu ti cike. ");
INSERT INTO bsj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nyori, ko cua cire, wori yurke mani wo mnaiya tok tiye, kange dikero mni wo yurangum yurangeri mani a coku ti yanglang. ");
INSERT INTO bsj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Di kero mayi kom kumta cileu ko toki ki Kakkuk kange dikero mwi nuwa bi luma mor tuwe meu, toki ki dir dor lor. ");
INSERT INTO bsj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cuwa re nubo wo twallum bwiyo ri la mani a twal dume tiyeu. Na wori cwa ni wo a twallum bwiyo ti kange dume mor kira kwama. ");
INSERT INTO bsj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kebo bilibe yob ci miyeti dor wina? Duwal kange ce man o a yarti bilineri kebo ymka Teku mek. ");
INSERT INTO bsj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","La yiri duwe kumeu kiyem kiye. ");
INSERT INTO bsj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ko cuwa re tai km la bilibetini yroka. ");
INSERT INTO bsj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","La nyori gwam niwo ne warke me nuwe nuberi matin na warke ce ken kabum temim wo dii kwamau. ");
INSERT INTO bsj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Niwo ko neka warke dor miir kabum nuberi mo ken man neka warke dor ceer ka Tee mii wo dii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ko kware komki min yau ri nami bou ki fuwor neret dor bitinr. I yau bo nabi bou ki fuwor neret, dila kulen. ");
INSERT INTO bsj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Min bou na mi dok nii kiye kange tece, kange Kiye biber bubiyak kange nece kange bifire bwe bubiya kiye kange fer e nawiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nii kiye niu atin yilam co wo mor luwe ceu. ");
INSERT INTO bsj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Co wwo cui tece kaka nece laye re ri daten bo na mii wo ciu bwe kaka bwe bubiyaceu, layere da ten bo na mii. ");
INSERT INTO bsj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Co wo tu bo kwoblom bwatiye ce na bwang men teneri daten bo mii. ");
INSERT INTO bsj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nii wo cui ti naci fulo dume ceri, an lem dume ceu. la wii dume ceu kermireri an fiyam co. ");
INSERT INTO bsj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wo yokomeri yo mo, dila nii wo yo yerri, yo co wo tomou yereu. ");
INSERT INTO bsj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wo yo nii tomange ki den nii tomangeri an yo cuner nii tomangero, la co wo yo nii cak cakke ki den nii cak-cakke ri atin yo cuner niiwo cak-cakeu. ");
INSERT INTO bsj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","wo ne win more bi duwartini buru kwel mwenge yibe nano ki den ni bwangkake ri, bilenke mi yi komti mani a le cuner cero ti”. ");
INSERT INTO bsj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bwikako Yecu dim biweret bi bei tomange ceri, cin dibom bi kole cua na co merang, na cin yi ci fulen ker kwama cinnr lor cer. ");
INSERT INTO bsj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","La Yuwana nuwa co fiya co, ci fucinu dikero Yecu matiyeu, con tom bi bei tomange ceu na co yi co. ");
INSERT INTO bsj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mon co nii boutiye kaka nyo ningtang kange ka? ");
INSERT INTO bsj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yecu yi ci ki, kom ya ko yico dika ka towe kange dike ka nuwa! ");
INSERT INTO bsj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Fukma ti toi, kilendo yayamti, walebo cin twam ci nubo mani nuwareu to nuwai ci kung nubo bweyameu ti nob bunebo ci neci fulen kerero ti. ");
INSERT INTO bsj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nii wo nuwabo funer kange me ri nob bibwiyer. ");
INSERT INTO bsj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kambo nubo wuro cuweri Yecu yi nubo mwerumeu ker dor Yuwanar. ");
INSERT INTO bsj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ye no kom cer yerak di kom ki tore, Yerako Yuwako moktiya? lan ye ka ciri ka towe nii dum ki kulendo fila-fila? Bilenker nubo dum ki kulendo Fila-fila ki daa lo liyabe. ");
INSERT INTO bsj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ye ka ceri ri ka towe bwe tomange kwama? ong mi yikomti, bwe tomange kwama. ");
INSERT INTO bsj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wo cowo ci mulang dorcer ki “to mi tom kimen nii tomange miti ka kom nuwe kime, wo a Yulang nure mwe tiye. ");
INSERT INTO bsj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Min yikom bilenke ba kange ci kung more kime wo natum bowe la Yuwana nii yuka mweme ke. Nyori bi duware gwam mor liyar kwamareu laco. ");
INSERT INTO bsj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ta ti kumeni Yuwanan nii yu mwemtiye yau ciko caneu, liyar kwamaro nuwa dotange kwiklki-kwilkiye, nob wilki-wilkiro tu kibi kwang. ");
INSERT INTO bsj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Fiya na Yuwana na bou gwam nob tomangeb kwamaro kange werfundo tak ker dukumero woti. ");
INSERT INTO bsj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","No mwan ciya mo yuwo ri con Iliya wo a boutiye. ");
INSERT INTO bsj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","wo ki tuweri a nuwa. ");
INSERT INTO bsj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma bonkan kwaldo wo ki ye? ci nabi ma lor ti fiye miyeka dike, wuro yirongm cuwo butici tiye. ");
INSERT INTO bsj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Toki bin cii mwen lira mwa yelbo yila. Nyo yi kwan bwa, mwe cibo wiye. ");
INSERT INTO bsj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wo Yunana bou mani ca cari, ma no nyom kom yi ki to ciki bwekelkele. ");
INSERT INTO bsj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bibwe nifire bou, ti cai ti noi ri, kom ki to wi ki nii kucunu knge ni o nyom tiye, far nob yuwaka kiyeme kange nob bwiranke! Nyori yilang ki fiya yuwoka ki nangendo co matiye. ");
INSERT INTO bsj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","La Yecu yoten werang cianr loro wo co man diker nyimankar wiyeu ducceu wori cin yiloka. ");
INSERT INTO bsj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","kwamen mo karangcimun kwamanen mo Baptcaida naki diker nyimankaro wori ci ma kimeneu, cimam taaya kange cindo di, kin yiloten kutan -kutange mor yakca yilanga kange bi tuwam. ");
INSERT INTO bsj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na cuwori an la Tayanin kange cidon dor kimer, kakuk bolanger. ");
INSERT INTO bsj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mo kafanahum, mo kwatiri man fiya duktonka lo kwama ka? or ong an cukken nen bitine, hadec. mo codom naki nyimangeu manue, ma muneg di, no ki wi duwal. ");
INSERT INTO bsj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mi yikomti a yilam bwai biten codome min, na kimeu. ");
INSERT INTO bsj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ki fiya co Yecu toki, “Min cakakom ti, Tebe, teluwe lo kwama kange kaleu, wori kom yurangen dike buro ka fiya nob yalannereu kange nyomka, la ka wom biyeyo bi dwartini nineu. ");
INSERT INTO bsj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ong, te wuro yori kaba nuwe mwe. ");
INSERT INTO bsj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dikero gwam cin neken ye fiye temi wiya ni kange mani wo a nyom bwe tiye, nyombo teu, nyo tak ni kange mani wo a nyom teu na bi bwece, kange wo co cokum naci nun cinene. ");
INSERT INTO bsj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bou minen kom wo ki nuwa dotange tiye, wo ki kulendo tutue, nan ne kom fubi. ");
INSERT INTO bsj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tu kulen miro, ki merangi mineng, wori mi lom-com, miki nero yiber mwan fiya fobka dume mwe. ");
INSERT INTO bsj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wori kulen miro bwaibo, takeu kulen miro tubo. ");
INSERT INTO bsj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ki fiya cuwa, Yecu kwen yam ki kakuk fobka mor tankini. Bibei tomange ceu nuwa wura ti, la ci kwer dor cangero ti citi cai. ");
INSERT INTO bsj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","La fariciyawa to nyori, cin yii Yecu, “To be bei tomange mweu diker ci matiye werfundo ciyabo a mani ki kakuk fobka. ");
INSERT INTO bsj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","La Yecu yi ci ki ka karanta bo diker Dauda mane kange nobo loce ki fiya cuwo ci nuwa wura tiya? ");
INSERT INTO bsj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Con doken bi kur kwamar, con ca cari wiye wo werundo ciya cinenbo kange nobo cineneu, ciyam kin nob wabeb koni. ");
INSERT INTO bsj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ka mor werfuna, ki kakuk fobka, nob wabbe kwama mor kikur kwamare ma dike werfundo ciyanbe, nyori, ci tacibe ki kero bwia? ");
INSERT INTO bsj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Min yi kom niwo la bikur kwamareu wo fo. ");
INSERT INTO bsj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Na ki ka nyimom ye wuro nuntiyeri, 'miki cwi cire duwe kebo twika nuwange ko wucake, no kom ki warbo ker dor niwo man ki bwiran kereu. ");
INSERT INTO bsj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bibwe nifire co teluwe kakuk fobka ke. ");
INSERT INTO bsj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","La Yecu dubom bikole cuwo, doken bi kur wabbero Urcalimau. ");
INSERT INTO bsj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","wori, nii kange kanko nom nowe wini. Fariciyawa me Yecu dong dongka a twa ni ki kakuk fobka ka? o na cin taco ki ker bwiranke. ");
INSERT INTO bsj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yecu yi ci we fo more kume no kwame ce yarken bouk ki kakuk fobka ri mani a tau ti cokumme? ");
INSERT INTO bsj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na wine la kece kwame kaka nifir? nyori werfundo ciya a ma diker ken ki kakuk fobka. ");
INSERT INTO bsj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","La Yecu yi niwo, “Taruu kangeko, la con taruu kang ceko, la kango yilaken kwamer na wineu. ");
INSERT INTO bsj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","La fariciyawa erken kale cin mwer kangi dor Yecu. ciki do nure ciya twalum Yecu tiye. ");
INSERT INTO bsj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yecu to nyori co ci dubom bi kole cuwe. nuwe. nubo ducce bwanteng ce, con twam ci. ");
INSERT INTO bsj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Con yi ciki nyial ciya yire nii. ");
INSERT INTO bsj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","wo na ci dim dike ci tok nyii nii wabe kwabe Icaya, tokti ki. ");
INSERT INTO bsj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Too Yii tomange me wo ma cok ceu, ma bilankange ceu, Man ne co yuwa tangbek miko naci yii nubo wo kebo Yahudawa. ");
INSERT INTO bsj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mani ca kwobkan ker ti, Mani ca ci wiye ti ki diir, mani a nuwa dircer ti nure. ");
INSERT INTO bsj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma ca kyan dike fwinongum ti, ma ca dom kra ko dadom bwiyakau, can ya ki warka turani. ");
INSERT INTO bsj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mor dene ce nubo kumtacile an fiya yim yo neri. ");
INSERT INTO bsj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nyori cin bou ki nii kange, fukma, mani nuwa tuu, wiki ninga fiye Yecu wiye. Con twam cona wo Nyori nii cuwo tok ker, ti toi tak. ");
INSERT INTO bsj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nubo wmerkangum gwamme nuwa nyimangka la me, wo co bibwe Dauda ka? ");
INSERT INTO bsj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","La fariciyaa nuwa diker nyimankako Yecu maneri cin yi ki, “Nii wo ki cok ninga kin bahalzabu liya kelkelebe. ");
INSERT INTO bsj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","La Yecu nyimom dike ci kwati ner cere, yi ci ki, Liyar do wo yalkangum me ri, mani a ti-ti cinar lor tikangum yobe mani a titi, kako luwe fwemme ri, an wurom. ");
INSERT INTO bsj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","No bwekelkele cok bwekele ri ki maa kiiye ki dor cero. La a mangyi na liyar do wo ti? ");
INSERT INTO bsj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","No miki cok ninga kin Ba'alzabu ri, bi bei kimeu ki cok ki ye? nyori ci ciya yila warka kimek tiye. ");
INSERT INTO bsj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","No miki cok ninga ki yuwa tangbe kwama wucake ri, nangi liyar kwamaro bou kimen. ");
INSERT INTO bsj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A man nyii nii doken lo nii bikwanne na ku kwi, co co bwam cobo ri? na nimre kange me ri ki ma kiiye kange mo, takeu, niwo mwerbo kange me ri, ki watangken. ");
INSERT INTO bsj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Na wori mi yi kom ti, “bwirangke kange dilanka gwam an curanwi. La dilanka yuwatangbeko wucake mani a curang ti wi. ");
INSERT INTO bsj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni wuro tok dikro bwir dor bibwenifireu a cutang wi wo tok kero bwir dor yuwa tangbe wucakeu a curang cinen ti wi fo kale wo kange wo boutiye. ");
INSERT INTO bsj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ywel tiyo a yori, bi tuti ce an yori kaka ywel tiyo a bwira bi tuti ce a bwira. ");
INSERT INTO bsj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kom bi bei na cuwe, kom nubobwir a ma nyii ka tok dikero keng tiye? Mor dikero ducce nereu co nyiiyo toktiye. ");
INSERT INTO bsj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ni ken ki coku dikero kendo ner cereu, nii bwir ki cok dikero bwir ko ner cereu. ");
INSERT INTO bsj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mi yikom ti ki kakuk warka nubo an ne warke dor dikero bwir ko ci toke. ");
INSERT INTO bsj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ki kero nyii mweu an coknen ki kero nyii mweu an kuwa nen. ");
INSERT INTO bsj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nyori kangem nob mulang kar kange Fariciyawa ciya Yecu nin ki “nii merangka, nyi cwiti nayi to yirom muneng” ");
INSERT INTO bsj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","la Yecu yi ci ki, “Kom nubo bwir, kom nob burotumbo kaldo weu, ko do yirom ti mani k fiya ti no kebo ka wo Yunana nii tomangeu ce ri. ");
INSERT INTO bsj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nyori Yunana da kuma taar, kakuko taar mor fwer jingi dur, na cuwo bi bwe nii an daa kume taar, kakuko taar mor bitine. ");
INSERT INTO bsj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nubo niniba a kweni an tii kange nubo kaldo we ki kakuk wara, ci an kuwa ci wori cin yiloten ki fulen kerek Yunana ro, la to nii kange wo la Yunana wo. ");
INSERT INTO bsj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Liya bangeu an kweni kane nobo kaldo, an kuwaa ci. ca bou cile kale wo na ci nuwa yilen Culemanu ro, la to nii kange wo laa Culemanuweu wo. ");
INSERT INTO bsj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","No yuwa tangbe ko bwir cerum nii nen di ki yaya fiyeni wo mwem mani yeu na ci fiya fobke, mani ca fiyati. ");
INSERT INTO bsj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","La yi ki man yilaken lomiyo ma cerueweu. No ci yilaken di, can fiya luwa, nyinangum Yulangum yora. ");
INSERT INTO bsj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","La con tuten kange kebceb niber wo bwira la ceu bou ciko na ci yi nyo, la cwile nii wo an bwira la wo fiyau, a yila nyo kange kaldo bwir ko wuro. ");
INSERT INTO bsj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","La Yecu dibo tokka kereko nubo mwerum cineneu ri, nece kange yitobcebo bou tim kale, cwiti na cin to co. ");
INSERT INTO bsj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kange yico, “To nemwe kange yitub mweb tirangum kale, cwiti na ci tok ker kange mo. ");
INSERT INTO bsj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yecu yi co nii wo yico kereu, we nemi, we yitub mibo? ");
INSERT INTO bsj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","La con taar kang ceko fiye be bei tomange ce nineu yico, “To” buro co nemi kange yitob mibo. ");
INSERT INTO bsj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","No nii wo ma diker temi wo di kwama cwitiye ri, nii cuwo co nemi co nemi kange yitob mib. ");
INSERT INTO bsj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ki kume cuwo Yecu cerum luwe nen, yan yiken kong caji. ");
INSERT INTO bsj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nubo kila, kila mwerkani cinen la con doken mor na bire mwenge con yiken more ce tangne nubo ducce tiranken konge. ");
INSERT INTO bsj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","La Yecu yici dikero kila-kila or dangke. Con yi ci “Nii fike kange yaken fik dumek. ");
INSERT INTO bsj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kambo co fi tiye ri, kangum dumembo yarangken nure, bilibatine bou cibangum cuwo. ");
INSERT INTO bsj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kangumbo yaranken fiye terentiyeu bitine mani yorau tabbo bwi cin kim wori bitine cuwabo. ");
INSERT INTO bsj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","La kakuko kwiuri cin comam wori ci manki niyeten cin kucom. ");
INSERT INTO bsj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kangum dumembo yaranken tiber cuiyaktini, la cuiyakko dwiyangum di cakkangum ci. ");
INSERT INTO bsj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kangum dumembo yarangken bitine ken, ma nuni kangumbo kwini kwob, kangumbo kwini nukkun, angumbo kwini taar. ");
INSERT INTO bsj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Niwo ki tuweri ca nuwa” ");
INSERT INTO bsj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bibei tomange bou yi Yecu “Ye bwi mo yi nubowo keroti mor dangke?” ");
INSERT INTO bsj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yecu yii ci “Kom wi ki nure wo ka nyimom yurke liyare loh kwama, la ciye ci nencibo. ");
INSERT INTO bsj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Niwo cike an neten co naci fiya ducce, La nii wo mancike, bi dure cinneu an yumom cinnen. ");
INSERT INTO bsj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","wori co dike bwi mi yici keroti ki dangke. To na ci ti toi ri mani ciya toti, tano citi nuwei ri ma ciya nuwati kaka nyimom. ");
INSERT INTO bsj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cine neu dike Icaya to tokeu dim. Wo tokki, no mo nuwatiri, mwan nuwa la mani mo nyomti, toka kan to mani ka nyomti. ");
INSERT INTO bsj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wori ner nubo wori wi ki kumtacile bwai na ci nuwa, cin kumom nuwe ciye naci tore ki nuwe ciye kaka ci nuwa ki tui ci kaka ci nyimom ki ner cir, la naci yilau nan twam ci. ");
INSERT INTO bsj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nuwe kime iker bibwiyer wori cin to, tu kime wori cin nua. ");
INSERT INTO bsj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bilenke mi yi komti nob dukumeb kange nubo wucake ducce cin cui naci to dike ka towe, ci tobo, cui naci nuwa diker ka nuwa ci nuwa bo. ");
INSERT INTO bsj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kom nuwa dangke niwo ya fi fikeu. ");
INSERT INTO bsj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","No kangumbo fulen liyar kwamar nyombe ri, nii bi cirene an bou bo yuwom dike ci finer cereu. won co dumbo ci fi nureu. ");
INSERT INTO bsj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","W ci fi fiye bitine ki terentiye, co niwo nuwa kero ri yuwa wulom-wulom ki for neret. ");
INSERT INTO bsj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","La wori ci man ki niye bwici can ti biduwar la no co fiya kalaka kange dotange ri, wulom-wulom co yarum. ");
INSERT INTO bsj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wori ci fi mor cuiyakeu co niwo nuw kereu la cuikko kalek kange kiyemer cakacangum kero la co mabo. ");
INSERT INTO bsj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dumbo wo ci fi bitine keneu, co nii wo nuwa kero ri, nyimome ma ken kange kwini kwob, kange kwini nukkun, kange kwini taar no wo ci fi ciyeu. ");
INSERT INTO bsj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yecu bo cinenten ki kang dangke. con toki, “Liyar kwamaro ki no na nii wo fi dumbo kem takeceu. ");
INSERT INTO bsj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","La nubo da dumtiri, nii kiye ce bou fiti yerako wi mor bikate ce, la cu ce. ");
INSERT INTO bsj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kambo Cuiko duyom meri, la ma ce bitwiti ceu ken ");
INSERT INTO bsj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cangam nii take bou yi co, nii dur, mwe fi bo dumbo ken take mwe ka? Man nyi yerako wiye? ");
INSERT INTO bsj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Con yi ci “nii kiye ma we” cangam cebo yi co, la muki cui nyo ya nyo kubangum ka? ");
INSERT INTO bsj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nii take kii, O-ong, no com kubang yerako tiri kang kubangum ten kange bi kateu. ");
INSERT INTO bsj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kom dobci gwam ciya dwi nyo gwam ya cinko bika. La no lam bito ri man yi nob bitobbo, “Kom kwon yerako ki kaba, kom bwam ki blak na kom twim, kom mwer bikateu mor bini mi. ");
INSERT INTO bsj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","La Yecu bo cinen ten ki kange dangke. con toki kii, Liyar kwamaro nan nun bikate (Musta) wo nii kange tu ya fi ta kece. ");
INSERT INTO bsj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nuni wo co bi duware gwam tannen nunim bo nin. La no dui ri la tannem nunim bo gwam, yilam ti wo bilibe dii kwama an yulng loni ciye kani ce nin. ");
INSERT INTO bsj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yecu yi ci kange danke tak, co tur duwo mim taca taare na fuu ci gwam. ");
INSERT INTO bsj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gwam dike boro Yecu yi nubo mwerume kin dangke, co cibo kange diker wo kebo dangke. ");
INSERT INTO bsj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wuro na yilam dike ci toke nyii nob tomangeb, ba na dim, wo co yi ki, “man wumon Nyii mi mor dangke. Man tok dikero wo yurangum. yurange nawo a yom fer-kur kalereu. ");
INSERT INTO bsj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yecu dobom nubo mwerumeu. doken mor luwe. Bibei tomage ceu cinen cin yi co, Fwetan nyinen dangke yere wo takeu”. ");
INSERT INTO bsj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ciya la yici “wo fi dumbo keneu, so bi bwe nii fireu. ");
INSERT INTO bsj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Takeu so dor bitinero, la dumbo ken ko ci bi bei liyar kwamaro. yerako co bi bei nii kiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ni kiyeu fi fikkeu so bwekelkeleu. Bitou so cuile kaleu, nob bitobbo ci nob tomangeeb kwama wusake. ");
INSERT INTO bsj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nyori yerako ci macangum ci tuimeu co cuile kaleu. ");
INSERT INTO bsj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bi bwe nifir an tom nob tomangeb kwama wusakeu ci an bwabangum naci cokum liyar kwamar gwam dike buro dok bwiran ketiye kange buro wo mani bwanten werfun tiye. ");
INSERT INTO bsj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ci an merken ci mor kra cillen, fiye ciya ci wiyeti kange kironka nunnek. ");
INSERT INTO bsj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","La ubo wusakeu ci an buwa na kakuk mor liyar kwama teciye. wo ki tuweri, can nuwa. ");
INSERT INTO bsj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Liyar kwama nan cweka yurangum yurange takeu. Nii kange fiyari yurangum cu ki bilangtum, yan miyem dike co cikeu gwam. La tiyenum take wo. ");
INSERT INTO bsj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Takeu, liyar kwamaro na nii kyeme do yoryore tiye. ");
INSERT INTO bsj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","No co fiya kange wo yoryore ri, co ya ci miyem dike co cike gwam co tiyenum. ");
INSERT INTO bsj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nyo tak liyar kwama nan bi liyar ci mer wima, la mweru dikero ducce. ");
INSERT INTO bsj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","La dim ri nii taka jinge ko kwou konge, La con yiken con mwerum kenko mor kole, Bwirtinim bo ci miranwi firen. ");
INSERT INTO bsj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","An yila nawo fiya co kaleu a bou ti cwileu. nob tomangeb kwama wasake an bou chokum nubo bwirko mor nubo wussake nen. ");
INSERT INTO bsj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ciyan merkeng ci mor kira cilong-cilonge fiye ciya ci ti ka wiye kange kironka nunek. ");
INSERT INTO bsj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka Nyimom dike wuro gwam ka? Bibei tomange ceu ciya co, “Ong” ");
INSERT INTO bsj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","La Yesu yici “Nyori nob merankar werunero, wo yilam bibei tomange liyr kwamareu, ci nan nii ki luwe wo yeu dikero sarko kange fwirko mor kwene ceu. ");
INSERT INTO bsj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","i fo nyori Yesu dim dangke brori, dubom fiye curo. ");
INSERT INTO bsj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","La Yesu doken biten ce, meran nobo nen mor bi kur wabero Ursalimau. Nyori cin nyimange ciki “Nii wo fiya nyomka kange yileng do wo fe? ");
INSERT INTO bsj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nii wo kebo bi bwe nii kwaka luwe ka? kebo nece ci cuwo ti ki Maryamu? Ale yakubu kange Yusufu kange Saminu, kange Yahuza kebo yitub ceb ka? ");
INSERT INTO bsj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ale yitub ceb natubo kebo wo kange be ka? ca dikero wo fe? ");
INSERT INTO bsj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cin kangum ner ducce dor cer. La Yesu yi ci “Nii tomange kwama mani fiya dur loco kange mor nubo loce. ");
INSERT INTO bsj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ca mabo nyimanke ducce wori ci nebo bilinke. ");
INSERT INTO bsj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ki kwama curo Hiridus Liya nuwa fulen Yesu. ");
INSERT INTO bsj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yi canga ce kange Yuwana wo yu mwemti wusakeu kwenu tuwe, wori Bikwando wo ma nage tiki co. ");
INSERT INTO bsj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wori Hiridus tam Yuwana bwam co ta ke merken co furcuna, ki ker Hirodiya wi yi ce Filibus. ");
INSERT INTO bsj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yi co ki daba nyo tu co na wi mwe. ");
INSERT INTO bsj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridus kin twalum co di laki cwa tai nobe, wori cin tu co na nii tmange to dukum tire. ");
INSERT INTO bsj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Di kakuk boka Hiridus kentanguu bi bwe Hirodiya yel yila kwo yoryore kabum Hiridus. ");
INSERT INTO bsj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Co ma cinen mor kange weri ki ca ken dike co cwitiye can ne co. ");
INSERT INTO bsj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bwiko co nuwa ker necerori con ya coki aneco dor Yowana wo yu mwemtiye mor fantilaner. ");
INSERT INTO bsj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Liya mam funer ki keni cero kweri wori weri co mane, nobo wari kange co fiye cika nin co bwi co yi ki a ma nye. ");
INSERT INTO bsj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Con twom mwati ka dor Yuwana ro furcina. ");
INSERT INTO bsj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","To mi a mwatu doro co ya ci boki dor cere mor fantilane ci ne bubya co ya na neken nece. ");
INSERT INTO bsj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bibei tomange ce to ci tu bilendo ya cin fwerum. Kambo naceu Cin ya la cin yi Yesu. ");
INSERT INTO bsj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu nuwa nyori cerum tkum mwengem bo nin ya yiken ki kwace fiye kange. mwe kankanko nuwa nyori cin bwang cinen ten ki na mor cinan lor. ");
INSERT INTO bsj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu bo kabum cem to tenanka mwerka nobe ko, cii cimen, co twam nubo nuwabo luma mo re ciye. ");
INSERT INTO bsj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ki Yo me bi bei tomange ce bo ci yi co, fiye wuro kiye kume no kweri fim, yo mwerka ko wo na ci ya cunnukur na ci tik dur ciyero nen cari. ");
INSERT INTO bsj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Di la Yesu yici ki wifini yame ciye man kom necci dige ciya ca tiye. ");
INSERT INTO bsj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Cin yi ki nyori carito cwendo nung kange jinge yob koni. ");
INSERT INTO bsj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu yi ci ki kom bu men ciko. ");
INSERT INTO bsj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesu yi mwerka nobe ciya yiken dor yeret co tu carito nunge kange jinge yobe, con kunge dii kwama yoti bibwiro wi, con ne bi bei tomange ce. ");
INSERT INTO bsj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gwam ciye cin ca cin bwam, ci to fiti cari kange jinge bulendo kwob cilombo yob. ");
INSERT INTO bsj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nubo ca, nabarubbo bikate nung, kiyebo kange natubo. kange bibeiyo ");
INSERT INTO bsj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Can nawo con yi bibei tomange ce ciya doken mor tokum mwengem bo, na ci yabken dinge wineu. nimde co beri na co yo mwerkako. ");
INSERT INTO bsj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bwiko co yo mwerkako cuwe, co ci kwiken dor bange kwobka dilo kume fim co firen ki kwace. ");
INSERT INTO bsj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Can nawe tokom mwemero ki no tiber wimar, bwayum kaka koti ki mwelanka mwengero kange Yuako ne ci dotangeti. ");
INSERT INTO bsj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ki kume (kene tar na kume ce) Yesu meru dor cinen yauti dor mwenger. ");
INSERT INTO bsj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bibei tomange ceu to co yakenti dor mwenger cin cwa ciko ciye ke keno kelkeli, ci kwa kiyange mor tai ye. ");
INSERT INTO bsj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Di la Yesu yi ci ker can nawo co ki kom ma bi kwan neret, mo kom nuware tai. ");
INSERT INTO bsj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bitrus kari ki teluwe tano mo ri dok ye bo fiye muneneu dor mwenger. ");
INSERT INTO bsj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu yi co bo, Bitrus ceru mor nabire mwenge yauti dor mwemer Yesu nen. ");
INSERT INTO bsj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bitrus to Yuwa ko taito tam co fiya co ter dikako co teluwe fulo ye. ");
INSERT INTO bsj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Can nawo Yesu tarkanko tau Bitrus, yico ki mo nii bilenke bi dob, ye bwi ner mwero oktiye? ");
INSERT INTO bsj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bwiko Yesu kange Bitrus donken nabire mwenge co yuko yiloten makake. ");
INSERT INTO bsj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","La bibei tomange ce mor nabire mwenge ci wab Yesu ci yiti ki bi cum mo bi bwe Kwama. ");
INSERT INTO bsj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ci yabum cin lau biten Janisata. ");
INSERT INTO bsj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nubo wiye nyomom Yesu, co ci tom tomange mor cinanlor, take ci bo cinen ki nubo ki buwarakeu. ");
INSERT INTO bsj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Cin ken co, ca ciya cimen na cin tai bwi belle ceu, gwam wo tai ceri fiyam luma. ");
INSERT INTO bsj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kangeb nob dinglib kange nob mulanka ci bou fiye Yesu wiye, fire Ursalima ci yi ki. ");
INSERT INTO bsj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ye bwi bi bei tomange mue kim diye nobo dur biro matiye? mani ci nir kanci nime ci ca cari. ");
INSERT INTO bsj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kari me ci, kume ye bwi kom kim werfuner kwamare ki dike kom bwangten tiye? ");
INSERT INTO bsj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwama tok ki Nee tee mwe dur kange ne mwe. Nawo tok kro bwir dor tecer. kaka nece ri, tam ca bwiya. ");
INSERT INTO bsj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Di la kom ki gwam wo yi Tece kak Nece ki, tikali mo fiyati minen naweu luma kwama nen. ");
INSERT INTO bsj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ni wo cwi bo co ne tece dur nure kom tu ker kwama yilam manki nage ker dike kom bwantentiye. ");
INSERT INTO bsj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kom kulendo bwir, dong dong Ishaya tok ker dor kumer. ");
INSERT INTO bsj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yi ki nubo wure ki niye dur fo tol niyeyer, ner ciyero kutan kange mo. ");
INSERT INTO bsj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ciki wabye kone, wori ci merang werfuner nober, yi dige a bwanten tiki ciye. ");
INSERT INTO bsj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","La co merkangka nobek fiye co wiye con yi ci kom ta cini kom nyomom. ");
INSERT INTO bsj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kebo dige doti nyi nii yilati ki duyie dige ceruri nyi nii, co no yilanti dutiye. ");
INSERT INTO bsj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bibei tomange ceu bo co mo nyomom nob dinglibo nuwabo luma ci nuwa kero wa? ");
INSERT INTO bsj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kari yi ci fikko wo kebo Temi diye fiye, an kwom co. ");
INSERT INTO bsj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kom dobti nyo cin fukma ti kabo tiye. tana fukma ta kece fukma nin cweri, gwam ciye ciyan yarken buwak. ");
INSERT INTO bsj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bitrus kari yi Yesu, fwetang nyinen dang kewo. ");
INSERT INTO bsj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu tok ki kom ken kom yomba? ");
INSERT INTO bsj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kom toba dige doti nyi gwam yakenti fureu, nyo a erti yaken tek bunak. ");
INSERT INTO bsj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dike ceruti nyi ki ceru mor nere, co dige nii yilati ki dutiye. ");
INSERT INTO bsj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","mor nee kwabanka digero bwir cirutiye, twal ka duwe, kayaka, Bwirangtum, kwii warkere cwerke kange tor kanganka. ");
INSERT INTO bsj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kangem bo co diger kang nii tiye ca ka kange buni nerka kange mni kang nii. ");
INSERT INTO bsj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu cokbon wi yaken yare cinan lor taya kange Sidon. ");
INSERT INTO bsj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Knage nawiya kan aiya bo wi fiye cuwo, kun diro kibi kwan ki nuwa cire duwe mi teluwe bi bwe Dauda, bwe bubya mi ki ni mor dotange fir kange bwekelkle. ");
INSERT INTO bsj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu kar cienbo ker, bibi tomange ce bo kenan co ciki yoken co bwang binen ti ki kiyange. ");
INSERT INTO bsj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kari tok ki ci tomyebo fiye kange wiye, ci tom ye kwamae lemle wo lo Israila. ");
INSERT INTO bsj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Con bo con cunge kanbom cem, co tok ki ki Teuwe tekang ye, kari tok ki daten a tu tii bibeiye a ne birin bi cuwe. ");
INSERT INTO bsj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","co ki nyo Teluwe birin bicuwe ki cam fitiwo curu kan nii luwe. ");
INSERT INTO bsj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu kari, yico nawiye bilenke mwe tenangi kabo. na yilamwen kambo mo cwitiye. Bubya ce fiya luma dang cang. ");
INSERT INTO bsj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu dobom fiye cuwo yaken bi dom kange wima Galili, co kwiken diale la yikenwi. ");
INSERT INTO bsj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mwerkankako dutce bo cinen bo cinen ki, nobo mani nuwatu tiye, fukma, kilen kange nobo nyiyo tamtabe, nubo dutce. Kange nuo nuwa bo luma cin bo ki ki kabum yesu co ci twam twirak ciyeko. ");
INSERT INTO bsj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nyo nubo kila yimati ki wo ci to nu o nyi tamtabe tok ket tiye. kilendo la yayamti kungando fiya luma fukma ti toi co ci dukton kwama ");
INSERT INTO bsj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu c bibei tomange ce cinen la tok ki ma ci noboti ci wari kange mo kume taar, ci manki diye ci a catiye, ma cwibo nyo ci cabo cari kari ci fumom nure. ");
INSERT INTO bsj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","abibei tomange ce kar cinen ba fiya carito fe, wo alam na bom nubo wo tiye. ");
INSERT INTO bsj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ki cirito kwem to nyi kom cike ciki niber kange jinge kilabo. ");
INSERT INTO bsj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Co Yesu ii nubo a yiken bitine. ");
INSERT INTO bsj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tu carito wo niber kange jinge, bwi koko coma buka kange, con wuangum curito co, ci ne bibei tomange ce, bibei tmnge ne nobe. ");
INSERT INTO bsj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nubo gwam ca cin bwam, ci mweran fiti cai bulendo niber dim. ");
INSERT INTO bsj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nubo ca ci bi kate naw ka nabarub, kiyebo natib kange bibei. ");
INSERT INTO bsj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu yo nubo doken nabire mwenge taken yare magadan ");
INSERT INTO bsj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nob dingli kange Sadukiya ci b cinen, ci cwiti na cin cwa co, cin kenc co ca nung cinen yirombo ii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kari yi ci ki meri, kom ki fiye an lumi wori dii kwama fiye je. ");
INSERT INTO bsj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta ke ki bwiri kom ki fiye lombo, wuro dii kwama fiyeje, dim dii ka? kom ynomom kabel yirom dii kwama la kom fwe ki jyomka keneko. ");
INSERT INTO bsj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kaldo bwir, nubo man ki taka bwiti, ci do yiromti di la yirom kange man wo a nungtiye ka wo Yunusa ce”. Yesu cu. ");
INSERT INTO bsj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bibei tomange ce bo dinge wureno di la cin tabum ci tu bo cirato. ");
INSERT INTO bsj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu yi ci kom cibi kom yiki bati, kange dige fuu nob dinlibo kange Sadukiyawa. ");
INSERT INTO bsj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bibei tomange ce yateen ti tokkan bwiti ci, keno wori cari mani di. ");
INSERT INTO bsj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu nyomom co yi ci ki kom nob bwinin bilenke, ye bwi kom tokkan ti bwiti kume, keno ker carito bo, bocikeri? ");
INSERT INTO bsj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kom nyombo kom bulangbo carito cendo nung wo ca ki nobe bi kate nunge, bulen di nyi kom mwere? ");
INSERT INTO bsj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","kaka carito cwendo niber, nubo bikate na'ar, kange bulendo niber, nubo bikate na'r kange bulendo nyi kom tume? ");
INSERT INTO bsj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ye bwi kom fwe ki nyomkako kom ki kebo cari ma kom cubi kom ka bati ki camfuwam, nob dinlibo kange Sadukiyawa. ");
INSERT INTO bsj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","La wo ciya bulangti, tok bo amfuwambo mor cariye di la ki yi ci ciya cub merangka nob dinglibo kange Sadukiyawa. ");
INSERT INTO bsj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Fiya Yesu bo kai cariya Filibus me bibei tomange ce, wobo ki tok bi bwe nifire nyi? ");
INSERT INTO bsj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","La ci ki “Knagem ki yi ki Yuwana nii yuka mwenge, kangembo ki Iliya, kangembo ki Irimiya, kka win mor nob tomange. ");
INSERT INTO bsj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yi ci, kume we kom yi ti ki me? ");
INSERT INTO bsj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saminu Bitrus ciya kari mo Almaciya, Bibwe kwama ki dume.” ");
INSERT INTO bsj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kari yi co nibi bwiyer mo Saminu bibwe Yunusa, kebo nange kange bwiyale fwetang mn dige we Te mi mor dii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma yinenti mo Bitrus dur tere do wo ma mo bikur wabe mi tiye. Nyilo bwiyare man a fiya turinikiditti dor cer. ");
INSERT INTO bsj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Man nenen yilo dii kwama ko diker mo bwabi fo kaleri, yilam bwambwabe firen dii kwama. Dikero mo kwim fo kale, yilam kwim firen dii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu yi bi bei tomange ce ci ya yide nii con Almasihu. ");
INSERT INTO bsj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tabti fo Yesu ter yika bibei tomange ce tamyo co ya Ursalima co nuwa dotange dutce kan nubo durko nen kange nubo dur wabero, kange nob mulangka werfunedo, ci twallum co an kun co dume bwiko kume wari. ");
INSERT INTO bsj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","La Bitrus yaken ki co cungagin werangco, ki wuro a kutangi kange mo teluwe, wuro mani a bwiti kange mo. ");
INSERT INTO bsj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Di Yesu yila Bitrus, yila kenbwi mi, bwekelkele. mo ter kottanka minen, wori kwom nen bo kange diker na kwama ce ka na nubo ce. ");
INSERT INTO bsj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu yi bibei tomange ce ki ni wo cwiti na bwagmentneri ca ko dor cer na co tu bwatiye bware ce na co bwangmenten. ");
INSERT INTO bsj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","wuro cwiti naco fulo dume ce ri, co lemco, Wo lem dume ceri dormire di can fiya ti. ");
INSERT INTO bsj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ye yori ni na fiyam kaleo na lem dume ce? Bibwe nii an bo mor duktanka Te cer wari kange nob tomange cak-cak ke, nimde na ya nubo gwam dor dike mo mane. ");
INSERT INTO bsj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bibwe nii an bou ki luma te ceko kange bibie tomange ce, an ne nii dikero ca mani fo kaleweu. ");
INSERT INTO bsj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bilenker mi yi komti, kangem komem bo tim feu na mani twi bwarti, Di ci an to bibwe nifire boti mor liyar cer. ");
INSERT INTO bsj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ki kume nukkundi Yesu tu Bitrus kange Yakubu kange Yuwana yiciye yaken ki co bangko cweem cwemeu, ki bwico. ");
INSERT INTO bsj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yirom cembo tii ba kabum ciyembo tikob cebo, ti bibai na kakuk, kange bellece ti tibai na filang. ");
INSERT INTO bsj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Katten di Musa kange Iliya cerkangu cinen, tak. ");
INSERT INTO bsj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bitru kari, yi Yecu Teluwe yori bo fo fiye wo bo wiye. Tona mon cwitiri man ywel bi kurdo tar, win kimo win ki Musa, win ki Iliya ");
INSERT INTO bsj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Co mor takka kerer biloro tia nyi cumo co diro coro bi loromi yici kiwo bi bwini mi cwiye coni fumen nen tiye kom nuco. ");
INSERT INTO bsj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","La bibei tomange ce nuwa yori cin mwelken dorcero bitene wori cin cwatai. ");
INSERT INTO bsj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yecu bo ke ci yici ki kweni kom nuware tai. ");
INSERT INTO bsj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ci kum dore ciyero, cito bo nii. ");
INSERT INTO bsj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Fiyaci yirouti bang Yecu nyiki kom yire ni dukkum bowo fico bi bwe nii kwanen. ");
INSERT INTO bsj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bi bei bwangka ce me ki yebwe ni mulanka a tok ti ki Iliya yo boteye? ");
INSERT INTO bsj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yecu diye cinen ki Iliya an boragu ki dikero. ");
INSERT INTO bsj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Di miyi kom ti iliya kweri bou dila ci yomkombo nyori cin macinen diker ci cwiye. nurewo, bi bwe nifire an nuwa dotange kan ciye. ");
INSERT INTO bsj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","wo bi bei tomangece ci nyme ki tok cine kero tok Yuhana nii yuka mogen. ");
INSERT INTO bsj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ci law fiye mwirkanka ko weyenri kange nii bo cine, cunguge kabumce toki. ");
INSERT INTO bsj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Teluwe ci bi bwemi wori ki juwe takeu, nuwa dotangeti kwabi ki yalti mwem kange kira ngit. ");
INSERT INTO bsj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Maboki ci bi bei tomange nin cin dor bo twaka. ");
INSERT INTO bsj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yecu, Kari tokki nom bwini birinke kange cwatanka kle fiya fiyang mayi ti ki kome ko bo ki co fiye mi wiye. ");
INSERT INTO bsj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yecu kwenancinenten la ning bwice celum bwi fiya tai ka? ");
INSERT INTO bsj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bi bei tomange ce bo Yecu nen yulum yurang me ki yebi nyo fweki co kake? ");
INSERT INTO bsj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yecu yiciki bilenker kumero nyo bi duwar mi yi kom ti naki kam wii ki beilenker na nun bi katairi kam nyi tiyo kamki kwam yaken fire tiyo an kom dike kange mani wo ala bi gwamm ki matiye. ");
INSERT INTO bsj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","La iren kelkeliyo wo mani a certi ciya kwobka dilo. ");
INSERT INTO bsj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ciyim Galili, Yecu yi bei tomange ce ki ciyan ne bi bweni kan nii. ");
INSERT INTO bsj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ci nyi mom twirum co ki kume tar an kwenum bibei tomange ceu nero kayam. ");
INSERT INTO bsj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ci lam Kafanahum nubo yo dortiyeu wumer cekeltiyeu cin bo Bitru. ciki nii merankakumeko, ne wumer cekeliti. Na dore ce? ");
INSERT INTO bsj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Co toki ong dila Bitru do ken mor luwe Yecu ter kero kange co, nye mo kwatiye Saminu? liyam karero ciki nyo kemer doren wine kika kemer mweng fiye nobfuwai. ");
INSERT INTO bsj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bitru kar cinen fiye Fabubo wiye Yecu yic nyori citu nob finyige keben yakako dila kari. ");
INSERT INTO bsj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bi don nyo ka doreka bwirangke, kam ya wima, mam ker bibumo kom tau jinge wo ter bo kakeri. tano kom wom niceri, komfiya cekelo kumtu kone nubo yodoro tiyeu mi kange mwin. ");
INSERT INTO bsj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ki kwama co bibe bwingka Yecu me ki co wining durko mor di kwama. ");
INSERT INTO bsj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","La Yecu co bwi bi duren kange tiber ciyer. ");
INSERT INTO bsj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ki miyi kom ti na kam yirambo na bi bitiuttiri mani kom kuti di kwama. ");
INSERT INTO bsj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na ni wo yoken dur cero na bwi bi duwareri cu dikero dur ko di kwama. ");
INSERT INTO bsj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","No kom yo bwibi duware wo ki den mir di kom yomye. ");
INSERT INTO bsj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wuro dok win mor bibeiyo wo ne bilengke bwiranke, la diker a ye cinnen ti ter nerer kwir cer, na merken. Co wima cuwa. ");
INSERT INTO bsj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gwam dor bitinero, wo kwantangka a fiya ciye gwam wiwo kume ni wo abotiye. ");
INSERT INTO bsj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na kangmweko kaka namweko an donen kotankeri mwatum co di mirangco wi. Na wori La mwen diker kange wo ciya tunken nen ti kira ki kanko yobeu, Lamwen diker do lokwama ki kanko win ko nako win. ");
INSERT INTO bsj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na nuwe mweu an dok nen kwentanka ri cokum co na mirank cowi fiye mwi wiyeu an lamwen diker mo doken dume ki nuwe win kange yarka mor kira ki nuwe yob. ");
INSERT INTO bsj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kom burange kom cwinkande bibei bi durti nen bo bibwe tomange kwama to ti com tii ciwo di kwama. ");
INSERT INTO bsj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bi bwe ni bou na cok dike lemeu. ");
INSERT INTO bsj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ni ye burangeka kime bou? na nii ki kwamagwini kom win la win reb maciya dubam tenwini ter cuo tereti naco dou woreme ka? ");
INSERT INTO bsj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na fiyam wo winenri miyi kom ti furner cero an lawo kuni tereo co dobeu. ");
INSERT INTO bsj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yo na wori yori kebo di wo tekume wo dii kwama nuge naco kun mor bi durdunen dowo na bwiyam. ");
INSERT INTO bsj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tano kenmwe kom mwendi yico tiber kumer mokange co kub biyo tano nunenddi moyirau. ");
INSERT INTO bsj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tano kam nukang bo bwitikimiri, kiya ki nubo yo kaka tar naci yiram warke, fi nob warka ko yau be kaka tare nunge kiro gwam dong dong. ");
INSERT INTO bsj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na ko nuwa ka ciye kori ya cuko nob kwama bone nako na nuwa ciri. tuken co na nubo yombo kwama. ");
INSERT INTO bsj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mi yi kom ti dike kom bwam bitineu bwam bwabe di kwama kike kom wineri gwin-gwine di kwama. ");
INSERT INTO bsj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mi yi kom ti na nubo yau an ciya ki dike kom kinantiyeu te mi wo di kwama an makimen. ");
INSERT INTO bsj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Fiye nubo yau kaka, taar ci mwerum ki denmireri mi we kange ci. ");
INSERT INTO bsj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bitrus bow Yecu nen ki kwama kiri to nyi kemi ama men burang ke manciten wiye? in lam kirito ni bwirka? ");
INSERT INTO bsj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yecu diye cinen ki mi yi nen bo mii kirito niber, miki niber kiriti kwini niber. ");
INSERT INTO bsj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nyori liyar kwamaro kino na liya kange o cwii naci kiyem kemer cereu knage cangam cere. ");
INSERT INTO bsj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kambo ci ter ri cin bow cinen ki canga kange wo ci bwang tenti talent do bikate kwobbe. ");
INSERT INTO bsj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dila kambo ci man ki nureu ci yam tiyeri, te kuwece ne wrfunendo ca a myim co, kange wii ce kange bibeyo kange dikero ci cikeu gwam dila na yam nan cero. ");
INSERT INTO bsj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","La cangau yarken bitine, cungi kabum cem la ki “Teluwe, ma biner kange mo, dila man yi nen dikero gwam. ");
INSERT INTO bsj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","La teluwe canga co kambo cin dim ki cikakeu nyem kang cinen di la citang cinen nan cero wi. ");
INSERT INTO bsj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Dila canga co cei ya fiya kange kece canga, wo ci bwang ten denani ti kwini kwob wiine cin tam co ri yoten bukka ceko la ciki yam ye dikero mi bwang mwne ten tiye. ");
INSERT INTO bsj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Di la kece cangau yarken bitine la kinog co ki “nuwa bi neri kange mo, ri man ya tinen wi”. ");
INSERT INTO bsj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Di la canga wo ki kaba ko, Nyori, cin ya ci merken co mor fucina no cin yam co dikero ci bwang cinen ten tiye nyimde. ");
INSERT INTO bsj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kambo kebcebo canga bo to dikero bwiyeuri, cin kangum ner duce cin bou la cin yi teluwe ce dikero bwiyeu gwam. ");
INSERT INTO bsj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","La Teluwe canga co, cou co rila yico “mo bwe canga bwir, mi tab mwen dikero mi bwang mweng ten tiyeu gwam, wori mwin kinong ye. ");
INSERT INTO bsj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","No mwiki nungbo kemwe nin cireduwa, na wo min nung mwen cireduwe? ");
INSERT INTO bsj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Teluwe ceu knagum ner duce la neken co kang nubo ne dotange tiye no ciyam gwam dikero ci bwang cinen ten tiyeri nyimde. ");
INSERT INTO bsj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","La nyo Te me di kwama ama kimen tiye ken no kom cutangbo kebkumebo nin wi mor nere kumer ri.” ");
INSERT INTO bsj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lam bou kambo Yecu dimkero buro di co ca dubom Galili con yaken ti yii kar Yahudiya, dinge caji Urdune. ");
INSERT INTO bsj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nubo kila-kila bwan cinneten con twan ci finange cuwo. ");
INSERT INTO bsj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Faricawau bouragum cinen ci cuwancoti ciki “daten nyo nii kambo wer funen nageu, ni a twal wii ce nin naaka ki kange dikerka? ");
INSERT INTO bsj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yecu Yii ci ka kiye bi wika tok ki co ni wo fule ci fiya kabu fuel, ci yob bwayile kaange nawiye. ");
INSERT INTO bsj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Co niwo fule ciyeu tok ki kiwuro nii an dubom Teece kange Nee ce na murom kange wee ce, ci yobeu cin yilam win. ");
INSERT INTO bsj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ci man yob tak la buiyo win Na nyori dike kwama mureu, kange nii a yalkande. ");
INSERT INTO bsj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Co ci yice, “La ye bui Musa yinyo ki nyiyal nyo tual nawiye nin na'aka nyo ywaco take? ");
INSERT INTO bsj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","La co yici bikwan nerer kumer, co dok muca ciya kumen ko tual nawiyenin Na'aka ki kaba kebo nyo. ");
INSERT INTO bsj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma yi kom ti nii wo tual wii ce nin neu naka, na kebo borutom. ");
INSERT INTO bsj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bibei tomangeceu yico nawo nyo nii kange wii ce di, yorbo a na'aka. ");
INSERT INTO bsj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","La Yecu yi ki “Kebo kwarub a yo merang kako tiye, la kan co nubo cia cinen cia yowe. ");
INSERT INTO bsj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kangem wii wuro bou ci Teeni (Combilome) Nyo tak di kangem wi buro yilamTeeniu ki ker Liyaro lo kwama. wo a yo merangka ko wo tiyeu ayo. ");
INSERT INTO bsj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Co ci bou cinen ki bibeiyo biduwatinim na ci yo cinenkang dor, kwob cinen dilo, “La bi bei tomange ceu erang ci ti. ");
INSERT INTO bsj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","La Yecu Yii ci, ko dob bibeiyo bidu wattinum bo ko ywa cire bou kako kami wori liyaro lo kwamau ki wang ciko. ");
INSERT INTO bsj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","La con yoti ka'ani ceu dor cir na nimde co dob fiye co. ");
INSERT INTO bsj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","La nii kange bou fiye Yecu wiye tok ki “Nii meranka, nangen do ken do wini ma matiye nan fiya dume dii yeu? ");
INSERT INTO bsj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yecu yi co ye bwi mo meye kerti dor nangen nero kene? win cuwab dong dong, no mo cuiti mo do ken mor dumedi, bwnag ten wer funero, ");
INSERT INTO bsj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","nii co yii co ki wer funero wini? Yecu yico “Tuwalde nii mare buro tum, kuure kwi, ma'are warke niyer ker, ");
INSERT INTO bsj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ne Tee mwe kange Nee mwe dur, na cui nii bi dom kange mweu na dor mwer. ");
INSERT INTO bsj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bwe bwantn yile wo yi co, mim man buro gwam yee ma mati take? ");
INSERT INTO bsj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yecu yii co, na mo cuiti na yilam dong dong di, ya'a miyem dike mo cike gwam, na kabkang nob bune bo nen di na mon fiya ciwekako dii Nimde na bou na bwanten ten ");
INSERT INTO bsj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","La be bwa yile wo ki fir nerer wori con nii cuwe cuwe. ");
INSERT INTO bsj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yecu yi bi bei tomange ceu, Bi com ma yikom ti, a yilam bwai yo na nii cuiwe-cuiwe na do liyar kwamar. ");
INSERT INTO bsj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yila ma yi ten komti an la telem bo min a doken buwak bilifirak kange wo nii cuiwe -cuiwe a do liyar kwamar tiyeu” ");
INSERT INTO bsj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","bibei tomange ceu nuwa nyori, yila cinen ki nyomanka bicom cikii we a fiya cerka tiye? ");
INSERT INTO bsj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yecu to ti cici, fiye nubo wiye man i a mati, la fiye Kwama wiyeu dikero gwam ki maman. ");
INSERT INTO bsj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bitru karu ki, Nyon dubom dikero gwam nyon bwangten nen. La ye ya fiya tiye? ");
INSERT INTO bsj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yecu yici bi com ma yikom ti, kom wo ka bwang men teneu, ki boro fuir ko kwama wo bi bwe Nii a yi kenti kutile Duktangka ceu, kom keneu ka yii dor kutileni kwob cilombo yobe nin, kom ma tuwe luweu kwob cilombo yobeu Iciraila nin bolangti. ");
INSERT INTO bsj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na nubo dubom loni, yitob cib, bayilob natub, Tee Nee, bibei kange tanki ni ki den miredi, an fiya kirito kwini kwob can fiya dume dii ri Yeu. ");
INSERT INTO bsj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","La nubo ducce buro kabou na weu ci an yilam buiyok, nubo ducce wo buiyeu ci an yilam kabak. ");
INSERT INTO bsj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","liyar do kwama ki na nii Ta'ake kange wo cerki kimuomje do nob nangeneb buro ama nangenti taake ceu ");
INSERT INTO bsj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","kombo ci tokka ngum kange nob nangenebbo ti naiyo win ki diye, ci tung ci taake cecia ma nangendo ");
INSERT INTO bsj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","lacon certen ki kam kaneko tereu lacon to nob nangeneb kangem tirangum konimiye kulenek ");
INSERT INTO bsj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","laco yici ko ya'a tabke mi man ne kom dike dong dongeu co ci ya cima nangende. ");
INSERT INTO bsj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","yika con certen tak ki kang keneko kwob yob, con fiya kangem co ma na kabau ");
INSERT INTO bsj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","yila con certen ka kiyaka naku ked, co ya con fiye kange nob tiram koni laco yici ye bui ka tirangum koni na kwam kakuko we? ");
INSERT INTO bsj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","won kange nii mani wo tu'u nge. lacon yici kom keneu ko ya ta'a ke mi ");
INSERT INTO bsj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","kanbo mee lame di nii ta'akeu cou betomangene ceu nob nangeneb na ya'a ci nan nangener ciyero, terti nubo cuwa bwireu naya ciko nobkababo. ");
INSERT INTO bsj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","kambo nob nangerneb wo ca tu'u ciki kumji yadi lane ci naiyo win-win. ");
INSERT INTO bsj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","kambo nob nangeneb kababo bou weri, cikwati cina ocum nyo la ci keneu cone ci naiyo win-win. ");
INSERT INTO bsj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","kambo ciyom nan nangener ciyereri, laci ti funan dor nii ta'a ke donin ");
INSERT INTO bsj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","cikii nob nangenebbo wo cowa bwireu ma kan kenko wimbiwine fiye nangne la yila mon tu'u kenci dong-dong kange nyo, wo nya twal bwiyeu kange cilon. ");
INSERT INTO bsj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","la nii ta'a ke kari yiciki farub, ma ma kumembo kange dike kebo dong-dong geu ka ciya men bo kama naiyo win-win ka? ");
INSERT INTO bsj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tamdike na mweu na ta nure mweu. macui co ma ne nob nange nibo cuwa bwireu dong-dong, na wo mane komeu. ");
INSERT INTO bsj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","wendi kebo dong- dong nama dike cuiye ki dike namiye ka? kaka kor kamatiye ki dike mamani dong donge ka? ");
INSERT INTO bsj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","cuwo nyo, nob bwikob cia yila nob kabab, nob kababo ayila nobo cuwa bwireu. conubo duccu nubo biduwar kwakwabe cokcoke ");
INSERT INTO bsj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","kanbo Yeecu yakenti wurcalima di con yaten kange kwob cilombo yobeu cungeca, dor mirer laco yici. ");
INSERT INTO bsj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ko to bo ki kwin mor wurcalima, an ne ken bibwe nifire kan liya nob wabeb kange tual kak ");
INSERT INTO bsj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","cian neken co kang nubo kumtacilib na ci buo cona malli co, na kungum co ");
INSERT INTO bsj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","la weebe beyo lo Jabadiu bou Yeecu nin kange bibei bayulobe ce yobe beu co cung cunge naco la con me kange diker cinen. ");
INSERT INTO bsj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeecu yico yee no cuitiye / lacon, toki moki bibeyo lomi wo yobe ayi, win kangko catiyere win kangko mokere, mor liyare mwe. ");
INSERT INTO bsj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","la Yeecu yico mo nyom dike wo mo metiyeu. mon dolum mo nomki kwelmwenge woma dadom nokaka? lacin yii co nyan dolum. ");
INSERT INTO bsj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","co yii ci kwelmwenge miu cuwo kan dolum noka, layimbo kangko catiyere kange mokeu, ke bo ma ne tiye, na nubo buro na ciye teemi yuelum yuele. ");
INSERT INTO bsj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","kambo tanggnim bibei tomangeceu kwobeu mwo wodi, cin man funer kange yitob bo wo yobeu ");
INSERT INTO bsj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","la Yeecu coci fiye cowiyeu yii ci kom nyom liyabbo tam ki nubo kuntacili yeu nung cinen liyarti, nubo dorko cinen loreu nung cinen bikwanti ");
INSERT INTO bsj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","mani ayilati nyo tiber kumer. tano nayori nii wo cuiti na co yilam du'ur more kumedi tamcan yila canga kume. ");
INSERT INTO bsj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","la nii wo cuiti na co yilam nii kaba kumedi co a yilam canga kume ");
INSERT INTO bsj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kanbo bi bwe nifire boubo na ci co dur, lana cone dur na co ne ken ten dume ce fanka nubo kila-kilau. ");
INSERT INTO bsj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","la ci cer jenko, mwerkanka nubeko ducce bwang cinen tene ");
INSERT INTO bsj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","la cin to fukmatini yob yirongum kong nure, la fukmatinim bo nuwa Yeecu ciu tiyedi, lacin kung dirciro citi toki, Teluwe bi bwe Dauda nuwa cini nyeu. ");
INSERT INTO bsj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","la nubo ca cinen tor yii ci cia kamangum. kico nyeu, fukmatinim bou wo, yokten kung ka direk ciko laã wo kwatti yeu, tokti Teluwe bi bwe Dauda nuwa cini nyeu. ");
INSERT INTO bsj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","la Yeecu tin cok, cok, doki cin cou ci, la me ci ye co cuiti nan ma kume ne? ");
INSERT INTO bsj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","co ci yii ce, Teluwe nyo cuiti na nyo fiye to ka fiye ");
INSERT INTO bsj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","la Yeecu bulangi ciko neercer, coke nuwe ciyeu. ca canduwo cin fiye toka fiyek. yila cin bwang ten co ");
INSERT INTO bsj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","kanbo Yeecu kange bi bei tomangeceu dadom kange wurcalimari, ci yaken betafaji fiye bang jaitun ne. co Yeecu tuom bibei tomange ce ci yob. ");
INSERT INTO bsj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","co yii ci ko doken muan loro kakumeu, kan to kelba kange be ce ci wari. ko kwiu ci kom bou men ciko. ");
INSERT INTO bsj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","na kange nii yii kom dike kange dor nyo di, ko yi co Teluwe cui citi. nii co an tomu kom kici danjang. ");
INSERT INTO bsj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","wo mani nyo na din dukum nii duku membo toke ");
INSERT INTO bsj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ko yi bi butobo ci yo na, ko to liya kume bouti kumen nii cukka duwek yim dor kelbar dor be lunjuge kelbar. ");
INSERT INTO bsj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","co bi bei tomangeceu cu yaci ma dike Yeecu yi ciye. ");
INSERT INTO bsj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ya cin ki kelbau kange be kelbau ci miranti kulenciro cere, Yeecu kwii la yii ti dor kulenro nin. ");
INSERT INTO bsj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","dur nuber mirang ti kulen ciyero dor nurer, kangem bo kiyangu alu tiniu cin miranti nure. ");
INSERT INTO bsj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","nubo mwerum we kaco kange buiceu, cin kung dirciyero citi toki Hocana fiye bi bwe Dauda wiye, ni bibuiyere co, wuro bou ti mor dene Teluweu. Hocana fiye Teluwe wiyeu, ");
INSERT INTO bsj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","kambo Yeecu doken wurcalima cinarloro dim, la ci merangi we wo? ");
INSERT INTO bsj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","nubo lankar cinen, won Yeecu, nii durkume wo Najaret mor Galili. ");
INSERT INTO bsj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","co Yeecu, doken mor bi kurwabere, con yuwabkan nubo miyaran diker tiye kange buro ten dikerti moreu. co yalangum dengila nubo wo fuion kiyemer tiyeu, kange kutile nubo miye nagum fiye tiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","con yii mulangum mulange lomi a yila lo dilor, lakom yilam buwak nob kub ciko. ");
INSERT INTO bsj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","co fukmatini kange kilenti bourangu cinene mor bi kur waber, con twan ci. ");
INSERT INTO bsj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","lanob bi wabero durko kange nob meranka werfunereu, cin to diker nyumankaro wo co manange cin nuwa tenbibeyo ci kun dirciro ti mor bikur waber, tokti Hocana fiye bibwe Dauda wiyeu, cin nuwa buwarum nem. ");
INSERT INTO bsj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","coki yii ce, mo nuwa dike ci tok tiye? Yeecu ciya ci oo laka nuwambowika, nyibibeyo bi du wadinim an buro no yiir tiyeu man dokti dur tangkako wi? ");
INSERT INTO bsj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","la Yeecu dubom ci cerum mor cinan lor yaken betani kuma co ca da'a wi. ");
INSERT INTO bsj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","la con buri kanbo ca yilau cinan loreri co nuwa wuranti ");
INSERT INTO bsj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","la con to tii nyingcin kong nure, con ya dimertironin laca fiya bituti mani kan layu. lacon yii tiye, betuti no nin we munen tak, danjang ko cuwo tii nyingcin dor kwicim ");
INSERT INTO bsj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","bibei tomange ceu tonyori, cin nyumangi ciki manyi tii nying cindo kwiddim dangjang nye. ");
INSERT INTO bsj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeecu yila yii ci, bicom ma yii kom tii na kom wiki bilanke kwaneri manidi, kebo ka ma tii nyingcin do nine ka ma tiye, lakom toki bwen nan co bang ko wori, kom ki akom co dii, na mob ken mor caji, la an manyo ");
INSERT INTO bsj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","bwen na yeka keneri, kone bilenkerirti, kam nyo. ");
INSERT INTO bsj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","kambo Yeecu bou mor kur bi waberedi, liya wabe nubo dur nubero bonrangn cinen kambo co ma meranka tiyeu, cin toki, ki bikwan kerero wuni moma dike buro tiye, we nenen bikwan kero ce? ");
INSERT INTO bsj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","la Yeecu yii ci, na miu keneu man me kom ker. na kom yii yeri, man yii kom keno ki bi kwan kerero wini ma manan dike buro ti cike. ");
INSERT INTO bsj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yuka mwengek yuwanako yau fe? yau dii kwama kaka, yau nubo nin? la cin tokkangi bwiti ci, ciki na bou yii boki dii kwama an yibo, ye bwi ka ne nebo bilener kange ce? ");
INSERT INTO bsj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","bwen bo yi bou ki bou nubo nindi, bou cuwa nuboti, wori ci gwam citu Yuwana na nii dukume. ");
INSERT INTO bsj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","co co la ci yii Yeecu ciki nya nyombo. co keneu con yii ci, mikeneu mani ma yii komti keno kibi kwando wini ma manangum dike buroti yeu. ");
INSERT INTO bsj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","lan ye ka kwabe? nii wi manangen do take duwen ");
INSERT INTO bsj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","bweu yii co mani ma ya ti, la ki con fulong nercero con yaken. ");
INSERT INTO bsj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","la nii wo ya be yobe nin tok dike co yiwo kabau. lacon manciya Tee laco yabo. ");
INSERT INTO bsj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","wemor be beyo wo ma dike teciye cuitiye? ciki wo kabau, Yeecu yii ci, bicom ma yii kom ti nuboyo dorti kange nob burotume an do kenten liyar kwamaro namimde kom. ");
INSERT INTO bsj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yawana bou kumen kin nure cak-cak ka ne bo bilenker kange co nubo yõ dor tiyeu. kange natub ma burotum tiyeu ne bilenker cinen. lakume bwiko wo ka tom dike wo mane, ka yoloten bo ki bui nako ne bilenker kange co. ");
INSERT INTO bsj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ko cuwa tu kange danke. ma kange ni take, con fi fik take nin, con kwarum takeu, con wob bicunge yamka inabikowi, con mu dengila cuwen cuweme wo atom take tiyeu, lacon neken nubo kangem takeu kambo ci tokkangum kiyemereu, lacon cu kange bitine kange. ");
INSERT INTO bsj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","kambo cuwa kiye inabi ko lameri con tom canga ce kangem na yo cinen carin cari to co mor takeu. ");
INSERT INTO bsj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","la nob nangenebo wo tacanga buro buk wineu, ci tualum wineu, mobang wine ki ter ");
INSERT INTO bsj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","nii ta'ake tung ten kangem cangam, lawo ki kabau, la nob nange nebo ma cinen na wo ki kabau. ");
INSERT INTO bsj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","bwiko cuwo nii taãke tuom ten bibwe ce, cinenr, tokti ");
INSERT INTO bsj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kambo nob nagenebo to bibwi nii ta'ake di citi tokkangi buiti ci, won co nii aca kwali to tiyeu kom bou bi twalum cona bou cam kwalito, ");
INSERT INTO bsj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","la cin tam bweu, ci mobkenco buim taken laci tualum co. ");
INSERT INTO bsj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","la nii ta'akeu boudi, ye cama nob nangenebo wuro nin tiye? ");
INSERT INTO bsj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","la cin yico, an tualangum, na yila ta'ake ne nangene bo bwirko buro ki mare cilong cilonge, na yila ta'ake ne kangem nob nageneb buro a yam co tiki cuakiyar inabikeu. ");
INSERT INTO bsj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeecu yii ci ka tobo mor bifimere, tero wo nobo nin kuweti koweu, coyilan ter culangere. woki no Teeluwe nin, la yilam diker nyiman kar nuwebe? ");
INSERT INTO bsj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","na weu ma yi komti, antum liyar kwamaro kumer, na bitine wo ne bituti tiyeru. ");
INSERT INTO bsj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","nii wo yarti dor terero wori can yakcangum ki fiti. la nii wo tero yae cineti dore di ankuwan co. ");
INSERT INTO bsj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","la nii liya re kange faricawa cin kwa ki dike ci toktiyeri la cin nyom ki tok kange ci. ");
INSERT INTO bsj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ci do tika cekori, lacin cuwa tai nubo mwerum meu, wori nubo tum co con nii dukume. ");
INSERT INTO bsj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","kiritti yila yici kerti ki dangke. cuki ");
INSERT INTO bsj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","liyar kwamaro wi tami liya kange wo yulang bi bwece nin ci ka nakakke. ");
INSERT INTO bsj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","nyi bi bei canga ce bou ker na kakko, la cin ko boka. ");
INSERT INTO bsj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","la nyori liyar yila tomten ci kangem nob canga, cokikere ki yi nubo wuro ci yi ci kere to, min fweten cikka ko min biye nenne kange bi cit biyeti tak direro gwam fiyam na cikka ce ");
INSERT INTO bsj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","la nubo tubo kero ki bilangka cin tab ka nure ciye kange take ce kange fiye tiyen ka kange miyeka. ");
INSERT INTO bsj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","tang nim bo cin cangam liya. cin nuwa cinen cin twal ci ");
INSERT INTO bsj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","la liya nuwa funet. con tomi ciya cuwo cinen nob bwaka dekeb ciya twallangum nubo twal nube naci twim cinar lor ciyero. ");
INSERT INTO bsj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","la cin cangace cika dim fwelka di. nubo wo fiya tomange ci datenbo ");
INSERT INTO bsj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","na no nyori kom nure kom cangangu nubo kwarub wo kom fiya ");
INSERT INTO bsj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","wo yori nyeu kange yorbe lo liyaro dim ki nob kambo ken. ");
INSERT INTO bsj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","kambo liya bou naci to fabubeu cin to niwo dor bo kulen cika ");
INSERT INTO bsj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","di liya nyi co farmi mu manyi mu doufo fiye wuro kulen cika mani ye? ni curo fwe ki ker tokk. ");
INSERT INTO bsj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","laliyar yi bi bai canga ki bwam ni wuro kang kange cna naki merken co mwor kumtacili fiye wuro manki wiye kange kuka nunek. ");
INSERT INTO bsj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","nyo nubo ducce ci cuwowe la bidob ci cokke. ");
INSERT INTO bsj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","dila nob dinglib cin fuwau kutume kanbo ciya taco ti tokka kercere. ");
INSERT INTO bsj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","la cin tung ciclen bi bai canga ciyeu hirudiyawa cin yi kiritti. ni merangka nyin yumom mu ni bilinke yulo mu merang nubonin kero kenti yonen bo wi kange ker nuber nyo tok mu man ki cuika darek mwor diber nober ");
INSERT INTO bsj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","di la nyo kermwero? daten yi ya dorer kai care kakka yi yare ka? ");
INSERT INTO bsj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","lan Kiritti nyi mom funer ceyiro yici ye bwi kom me yeti nyo we kom nubo bwir. ");
INSERT INTO bsj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","kom nungmen culom ki yemero curo la cin bo cinen ki kiyemero ");
INSERT INTO bsj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kiritti yici nyo komne ");
INSERT INTO bsj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","kaicar dige yilam nace kwama dige. yilam nace ");
INSERT INTO bsj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","kambo ci nuwa nyeri yila ci men ki, nyi mangka, la cin dob co cin cu ");
INSERT INTO bsj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","nyo yinidi nob bwiran kerero kangem wo liyabo kange kwenka kaleka cin bou cin nen cin meco ");
INSERT INTO bsj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ciki ni meranka muja tokki no ni na nacoiye bwiyam man ki bwedi yice na yi kange wice na bo bibwi ");
INSERT INTO bsj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kangem ciyem bo wi nyo nukkun wo ki kaba na lan bwiya kam ci man kibi bei yeu dob kechenin wice ");
INSERT INTO bsj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","yice wo yobeu co kenneu co manyo la wo tereu yaken cuko nubo ni beri nin. ");
INSERT INTO bsj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","wi bwi gwam ciye la na wi yeu bwi gwam di la ki kakuki kwenka nob bwareb na wi yeu ca yilam wi we mwor nubo nukku nin? nyo gwam ciye na co ");
INSERT INTO bsj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","la Kiritti ci ya yici ki, kom lem, dige biwiyeu kom nyombo bifumer kakka bi kwan kwama ");
INSERT INTO bsj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","dige bwiyeu kwenka nob bwarebo naka mani la mani ciya mwer kang citi naka. ");
INSERT INTO bsj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","nona curo nyori ciki nona bibei tomange di kwama. ");
INSERT INTO bsj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","tano dige yilam kange kwenka nob bware yikom bwangtenbo dige kwama yikoma ");
INSERT INTO bsj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","cuci kwama a brame kwama Icaku kange kwama Yakubu? kwaka kebo kwama nubo bwiya kwama nubo ki dume tinin. ");
INSERT INTO bsj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","kambo tare nuwa nyeri ci men ki nyi manka. ");
INSERT INTO bsj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","dii kambo fariciyawa nuwa kiritti ywa cudu ki yawa di la cin mwer dorciyero ");
INSERT INTO bsj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ki bwo fwer ciyer kange nubo nyimom bwo langeu cin cuwa co ki meke na ci nyimom co. ");
INSERT INTO bsj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","nimerenka fwer funka mwor bwolang? ");
INSERT INTO bsj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kiritti yico bilang kwama mwe ki bi kwan mwero gwam kange mer mwero gwam kange mwor ner mwero gwam ");
INSERT INTO bsj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","wuro co wer fundo kendo ");
INSERT INTO bsj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","werfundo wo yobeu tami na mwe bilang niwo bi dom kang mwe na dume mwe ");
INSERT INTO bsj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","dor werfundo gwam dawi kere ci tikeu nin. ");
INSERT INTO bsj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","kanbo bi bei faracayawa ci murangum fiye wine kiritti meci ker ");
INSERT INTO bsj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tokki, nye kom kwati kange bi bwe kwama? co bi bwe we? cin yico bi bwe Dauda ");
INSERT INTO bsj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","kiritti yi ci la manyi Dauda mwor yuwa tangbe cuwo ce bi bwe tokki ");
INSERT INTO bsj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","bi bwe kwama yi bi bwe kwama yi kangko catiyer mer. la mai yila ke ki nob ki ye mwe ki no fiye fuwa namwek ");
INSERT INTO bsj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ni kange mani wo kar cine kange ni kar ciriren bo kerwi kange meco bo wi tak ka ciko dicire ");
INSERT INTO bsj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","la kiritti yi tartare kange bi bei tomangece ");
INSERT INTO bsj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","coki nob werfundo kange faricawa ciyim fiye muca ");
INSERT INTO bsj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","la nyori gwam dige ci yikom makerii kom mani wuro diger kimer ki tam yora dila kom mare dige ci manang tiye wori ci tkang dige ti mani ci manangti cuko. ");
INSERT INTO bsj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","cibwa kulen tunyoti, wuro bwai tukakke ci tu mwer nubo nin lakgwom la ciyeuw ki bwi ci mani ciya tar biwure ciyeti tu ");
INSERT INTO bsj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","gwam nanange ciyero cikin manin nubo nato ciki cur bi la ciye bi fumer ciyero ce ki tokko ci kwirang cunga tinin beileti. ");
INSERT INTO bsj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ki cwi yulangka fiye ti nin yimem ciyem tolnyiyer kange yulangka fiye yime ciyeu bikur kwama ");
INSERT INTO bsj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","kange yarume yaruma na wa kungum dore fiye miyeka kange tiyenka na ciya cuwo citi kini meranka ");
INSERT INTO bsj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","la kebo wo ciya cuwo kom tini meranka nyonin dige bwiyeu ni meren kakko win kom cike, kom gwam kom bi yitinim. ");
INSERT INTO bsj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ki cuwore ni kange teki kume fo kalewo dige biyeu tee win kom cike, diki nodi ");
INSERT INTO bsj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","kom ciya ciwo kom de nobbifime dige bwiyeu ni bi fimer ki merowin co bi bwe kwama ");
INSERT INTO bsj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","di ni wo yilam dur tiber ki nureu na yilam canga kime ");
INSERT INTO bsj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","gwam niwo kung dor mwor dige gwam niwo tubo dorr cere ci kebo kange ni dur ");
INSERT INTO bsj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","di la daten bo nyo nob mulanka kange faricawa nubo bwit kom ten nubo nin yilok doka lo kwama kom dobo kom dobbo nubo cwi doka tiyeu na dou ");
INSERT INTO bsj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","daten bo nyo kom nob mulanka kange faricawa nyo kom nuwa natub kwilibti do tange ");
INSERT INTO bsj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","da ten bo nyo kom mulanka kange faricawa nobo bwit kom bwilangti digge wimer kange tineni du wonka ni merangka win bi wine na ki kom fiyam kom mamco konidi lengtidi yulan kumero nyo di yilam ni kere ne kom ");
INSERT INTO bsj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","da ten bo nyo kom fukma bo yame kom wuro kom tokti niwo werum kange ku kwamari kebo kange diger lagwam niwo werum kange mwindo ku kwamari weri ce fiyem fiye yime. ");
INSERT INTO bsj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","kom kula fukwa tinim na wini la bidwi yere mwindo kakka ku kwama wiyeu na wo manki dwitiye mwindo ");
INSERT INTO bsj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","tano wo werum kange tanjilandowu cakke kebo diger tano niwo werum ki kiye mero ci yoti dor cereri weri ceu tomco ");
INSERT INTO bsj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","kom fukma ti nimbo na wini wo durke kimer ku kwama kakka win mwabe wuro mwer kwama nin kiyemer tiye? ");
INSERT INTO bsj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","tano nyo gwam niwo werunki tanjilando wucakke werum gwam co kange dige dorcere ");
INSERT INTO bsj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","tano niwo werum ki kwamari werum kango co wo fwer cereu ");
INSERT INTO bsj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","tano gwam niwo werum ki di kwamari liyar kwama kange wo yim dor cereu ");
INSERT INTO bsj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","daten bo faricawa kange nob mulang kanb nobo bwit kom cokkom luma renek ywerek kange kule kange lam cur la kom mirang bilengke wuro tu nyo weu. yona wucak, cire duwe, bitinke cu wura daten ka matiye kebo na wuro kom cutang. tang nini bo wiye ");
INSERT INTO bsj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","fukma yame mwem nuwa kungkunge nin kange dige kangem nyori mwon mim tecembo ");
INSERT INTO bsj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","daten bo kom nob mulangka kange faricawa nubo bwit kom nir bwim kwimkwelmwengeti kange kwele la mordi dimka bwirangke kange fitrerer ");
INSERT INTO bsj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","no fukma nubo bwit ter yiwelka bwim kwele kwelmweu na bwim ciyemba yimki yorak ");
INSERT INTO bsj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","daten bo kom nob mulankab kange faricawa nubo bwit na tuweti nim kumembo tami bitine fwor wiye kum ma curo nobo to yaran kume ko kale firer mwordi kom kuk nubo bwiyam kanga dwiti dimer kidimen ");
INSERT INTO bsj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","nyo fo nuwe nobo kom la firer mwor di kang bwirankeret kange nero fit mwor. ");
INSERT INTO bsj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","daten bo nyo kom nob mulang kab kange faricawa kom ki tuwe nob dugumeb la kom yulangum tuwe nob bilike ");
INSERT INTO bsj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","kom tokti komki no yitin nowi ki kwama teb nyebe nin nonyiti necibo filan curka bwi yale nob dugume ");
INSERT INTO bsj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","na curo nyeu nung dor kimero kom bi bei kwalka nob dugume ");
INSERT INTO bsj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","di la okm dim cuwa ka kwama ");
INSERT INTO bsj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","na cweti nini kom bi nob bwit mana ka dorti nokom bwolang kwama ");
INSERT INTO bsj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","tano nyodi to, mitom ki men nob dugumeti, kange kange kanlangnbo kom twalangum kangukab ci naci kulkenki kam ma kangam bo benjange kurbi wubit kumer kom bwanten citi cinat lor cinar lot ");
INSERT INTO bsj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","maka ko nyeu dige kom manange dwiti bwile nobo kendo gwam wo curi fo kaleweu yileken fo dor kimer tau fo bwiyale tabila yaken cuko zakka bi bwa bara kiya wuro kom twqlum co tiber kur bi wubir kange tanjilan do wuca ke ");
INSERT INTO bsj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","bilinke miyikom tiye gwam niwe ca kung kutume ti dor nubo kalewo ");
INSERT INTO bsj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","urucalima, urucalima mwo wuro twanong nob tomange miyila mu bang nubo ci tom mwemeu ki terertini kiritti nyi min cwi nan murangu nen na wuro bi cake ki muragu de bi bei yo loce tibir tangum ceme munko ");
INSERT INTO bsj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","nwo cin nob kimen lokume fwengteng ");
INSERT INTO bsj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","minyu mi yikoti mana ka toyeti tok, no ki diye ki tokkeri, bibwiroyo ati dor niwo bouti kiden teluwereu. ");
INSERT INTO bsj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yecu cire bi kurwaber ta nure ce, bibei tomange ce bõ ci, nung cinen muka bi kurwabero ti ");
INSERT INTO bsj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","di, kari ciya, kom tõ dige wo gwamma? ke ti, kange ter meni na wo a dorke cer wo mani awertiye. ");
INSERT INTO bsj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","fiye co yim dor kang zaitun, bi bei tomangece bo cin yuranum yurange, ciki ye a yila yirom boka mwetiye kange dika cwile kale. ");
INSERT INTO bsj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yecu ciya, yi ci kom de kom tiyangum. ");
INSERT INTO bsj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","nobo durce an bõ ki denmir ci yan to ki kimo almacihu, take ciyan dok kangem kila tiya ngum. ");
INSERT INTO bsj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","kan nuwa fulen kwerer kang ka dir kwener, kom cubi, okm nuwa tai, tamyo dig buro bwi, dila cwila bwiri, ");
INSERT INTO bsj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ber an kwenan kange ber nin ten liyar an kwenang liyar nin ten an ma wura kange mulcaka bitinek fiye kidimen ki dimen. ");
INSERT INTO bsj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","di gwam buro kabak buwarum bõ ka koni ");
INSERT INTO bsj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","biko wo, ci an niken kom dotange nin, ci twalum kom gwam bero an kwer kom ki ker denemir ");
INSERT INTO bsj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","fo dang tang kila a kottang tiye, ciyan kwerkom bwiti, ci ko ciya ka bwiti ");
INSERT INTO bsj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","no curkebo kila a kwenu tiye ciya dur kali to tiyangum. ");
INSERT INTO bsj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","timi bi cirin cwika ko kila anyibom. ");
INSERT INTO bsj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","dila wo mwirumum meri an fiya fuloka. ");
INSERT INTO bsj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","an tok fulan diyar dorbitinero gwam, be na yilam warka dor nobo nyombo kwama. nimde cwile bõ ");
INSERT INTO bsj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","di na kom to dige wo nidurkume Danieltok ker cere, tim fiye wucak ke ni kiyetiye na nyimi ");
INSERT INTO bsj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","buro yahudiya ciya cukken dor, bangnge, ");
INSERT INTO bsj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","wuro dor luwe diye ca yirare na co to kange diye mor luwece ");
INSERT INTO bsj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","niwo take ca yilau de lo bõ na co tũbeke ce dur ko ");
INSERT INTO bsj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","kwan nobo tom ki bi bi bei kange nobo nẽ yir tiye fo kumeni wo ");
INSERT INTO bsj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","kom kwob dila cwaki kume ko a yilare yuko bau kange bi diye kume fobka acabaci ");
INSERT INTO bsj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","an ma dotange tẽnan tenange wo mambo wi ka cik fwelka kale wo yau ciko dwen. o-on mana wuro ti tak. ");
INSERT INTO bsj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","na kebowo ci mwatum kumeri na kange nii man bũũtiye, ker nobo wo ci cukange, ci mwatum kume. ");
INSERT INTO bsj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","tano kange yiki tõ almacihu wo kaka almacihu wuren, wo kom nere bilenkẽ ");
INSERT INTO bsj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","wob curkebo kange almacian curke ci an bõ ci nung yirom kange deger nyomamka, an ci bol ");
INSERT INTO bsj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","nubo kila yana kangi tana anmam di kange wo cukange. kom towa, mam yim kom tiya an bou. ");
INSERT INTO bsj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","nyona cuwo, naci yi kom wuren kii kaka wuren yurangum kũũkom nere bilenka ");
INSERT INTO bsj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","na wo mulankako tibati twar yaken cuko mẽ, nyo boko bi bwe nifiri a yila tiye ");
INSERT INTO bsj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","fiye nange buyan buya wiye co fiye bicabuni ki mwer kande. ");
INSERT INTO bsj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","di can cando wo bwiko kumeni dotange wo, kakuko an fin kumta cili, cwakko mani a nẽ filancekoti, bitirendo an yarangu firen dii kwama, bikwan wo nii kwama cin muka, ");
INSERT INTO bsj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","nimde yerom bibwe nii firo an cirkangu for dii kwama, gwam nobo kalewo ciyan ma fir neret. cia to bi bwe nifire a bõmor bilore kibi kwan kange duktangka wo dwi nyeu ");
INSERT INTO bsj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","an tom bibei tomange ce wo wucakke ki dir cumer kwamkwame, nobo co kwabe mor culangko na'ar tati wile dii kwama yaken coki wine nin ");
INSERT INTO bsj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","kom tu merangka tii nyingcin do nin tana kan ceko yoten fuka, ter neka laluweko, kan nyomon tirakkon dadom ");
INSERT INTO bsj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","nyo tano kom to dige wo gwam ko nyomom dadom, kino nyilok ");
INSERT INTO bsj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","mayi kom bilenketi, kaldowo mani a cuti, dige wo gwam an bwi ");
INSERT INTO bsj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","dii kwama kange bitine an cum, dii ker miro mani a cuti ");
INSERT INTO bsj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","di la ker diye do ni mani wo nyome, nob tomange bo wucak dii kwama, kange bwe, kan Tẽẽ win ");
INSERT INTO bsj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","nawo kume ni nuhu, ayila tiye ki boka bi bwe nifire ");
INSERT INTO bsj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","kume ni wureno, nimde mwem cufana bau, nobo ti cai noi, citi nai, ci nakenti, diye nuhu doken nabire mweme ");
INSERT INTO bsj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","cin nyombo kange diker, la mwembo, bo cam ci, nyo boka bi bwe nifire a yila tiye ");
INSERT INTO bsj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","nobo you tim take, an tom win dobti win bwi ");
INSERT INTO bsj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","natubo yob kwa nirti dor kannya an tom win dobti yim baim, wori kom yombo dige teluwe kume a botiye ");
INSERT INTO bsj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","kom nyomom wuro, na nii kuwe nyomom fiyang nii kuye a boutiyeri na kin yi ki bati, mani a dob loceti, ci wuri ci doken. ");
INSERT INTO bsj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kom yiki bati, bi bwe nii an bõ fiye kom man ki nyomka ");
INSERT INTO bsj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","we canga ken wo ki yilen ne, wo luweti, na neci cariti kambo datenni? nibi bwiyere canga, teluwece bo a fiya coti ");
INSERT INTO bsj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","we canga ken wo ki yilen ne wo teluwe ce yo na to cinen luwe anneci, cariti kambo daten ne? ");
INSERT INTO bsj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","nibibwiyere canga, teluwece bo a fiya coti ");
INSERT INTO bsj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","mayi okm bilenketi teluwe ce an yoti co dor dige co cike gwam ");
INSERT INTO bsj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","tana canga bwirko yi mor nerece, teluweme tabum bwi ");
INSERT INTO bsj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","coter bukka tannum cangabo, co cati coti noi, kange tangnum nob nukabo ");
INSERT INTO bsj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Teluwe canga wo an yilau kakuko canga wo manki bati, fiya cuwo co nyombo ");
INSERT INTO bsj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","teluwece an torangum co yob, cwile ce an yilam dong dong kange nii bwir tinim a yoco fiye cin wiye ti ka kuka nuneke. ");
INSERT INTO bsj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","la liyar kwamaro na bi butobbo kwobbeu wo tu talkire ce la cin yaken naci to nii kibineu ");
INSERT INTO bsj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","nung more ce kuletini rila nug more ce yula kabo ");
INSERT INTO bsj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","la kambo kuletini bi butobe tutal kire ceu ci tubo nuwango kange cinen dila bi butobo yula nyeu tu nuwanger cero kange calkiretini ceu ");
INSERT INTO bsj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","lakambonii ki bineu tabum bwiyeri ci dugo dumti gwamceri cin darangum dum ");
INSERT INTO bsj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","dila kina cii kumeri cin nuwa kwaka diregi to nii bineu ko ceri, nakom co gwam wabkanco, ");
INSERT INTO bsj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","dila bi butobo co gam kwinangiri la cin ywellangum talkiretini ceu ");
INSERT INTO bsj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","la kule bi butobeu yi nubo yula, kon ne nyinen nuwang kumeko bi duwar wori talkire nyeu lombamti ");
INSERT INTO bsj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","dila buro yula nyeu ciya cinen wori mani a la nyinenti kange kumen ko ya nubo miye tiye nin ko te nu kumeu ");
INSERT INTO bsj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","kambo ci yake tiyenkakeri nii ki bineu begen dila nubo ki batiyeu cu tange co fiye nakakonin dila cin nungum nyilogo ");
INSERT INTO bsj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","kutang bori tangni bi bibutoi, bow la ciki te luwe, teluwe wom nyi nen ");
INSERT INTO bsj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","dila cin ciya ciki bilenke mi yi komti mi yom kom bo ");
INSERT INTO bsj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","nyori ko yi ki bati wori kon yombo diye kaka kwama ");
INSERT INTO bsj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","la kino na nii wo darum na yaken mor bitine kange. cin co canga tini ceuri lacin neken dige ci cikeu kanceg ");
INSERT INTO bsj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","win more ce cin ne talen ti nung, ki kange cine yeuri la ki kange tak cin ne talenti wiin la ci yorang talenti dong ikwan cer yila nii co yaken yamcembo ");
INSERT INTO bsj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","la wo yo talenti nungeu yaken cuko win dor ken cii mor nangene lacin fiya mwem talntibo kange nung ");
INSERT INTO bsj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","nyo takri wo yo talenti yobeu fiyau bo yob ");
INSERT INTO bsj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","dila canga wo yo talenti win neu cu ya wob buwakko bitineri lacin yurangum kiyeme teluwe cero ");
INSERT INTO bsj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","kambo kutangeri tee luwe cangetini co yilau naci kiye kemero kange ci ");
INSERT INTO bsj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","cange wo yo talenti nungeu, bou ki mwem talenti nung tak. ciki te luwe mwi neye talenti nung. to min fiyau mwembo talenti nung tak ");
INSERT INTO bsj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","teluwe ce yico ki yori kabo canga ken ki bilenke mwin ma bilnke dor digero bi dobeu matin yo nen dur dor digero duce dogen mor lumor talen mwek canga wo yo talen ti yobeb yau rki, ");
INSERT INTO bsj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","teluwe mwin neye talenti bokange yob too min fiyau ten mwemb talent bo kange yob ");
INSERT INTO bsj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","teluwe yico ki yori kabo canga ken ki bilenke mwin ma bilenke dor digero biduware matin yo nen dor digentiro duce digen mor luma te luwe mwek ");
INSERT INTO bsj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","la canga no yo talenti wiineu yau la cin yiki teluwe min nyimom mwin cilongi nye. lamwiki biyem fye mwi fiibe nyori mwiki mwerumnyo fiye wo watangbe ");
INSERT INTO bsj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","min cuwam tai rila ya min yurangum talenti meu mor bitine to wo digero na meu ");
INSERT INTO bsj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","dila teluwe ce ciya lanyi co ki mo canga bwir, kange dilime mwin nyumom miki biyem fiye mi fibe take miki mwerum nyofiye me watang be ");
INSERT INTO bsj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nyeu mokin neken nubo ma nangen ti ben keme, mi yilau na weu miki yom kiyemer miro ki mwem ");
INSERT INTO bsj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","nyori yom talenti cinen di na kom neken canga wo ki talenti kwobbeu ");
INSERT INTO bsj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","la gwam niwo cikeri/ atin cobcinen ten la can yilam cuko duco. cike. dila kinii wo manki digereu, digero cimeneu atin tum cinen ");
INSERT INTO bsj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","kom merken canga bwirko kale mor kumta cii fiye ciya ci wiyeti ki kika nunekeu ");
INSERT INTO bsj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ki kwama bi bwe nii fiye bow mor duktangka ceke kange nob tomangebo kangeceu, dila cin yii dor kutile duktangka ");
INSERT INTO bsj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ka bumcem an mweru bitinetini gwam, ");
INSERT INTO bsj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ca tin cikangum nubo win nawo nii bicire cokum dekwama mor nibetiniye catai yoken kwameu kamko cattiker, dila nebetini kanga mokke. ");
INSERT INTO bsj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","dila liyau an yi burowo kango cattiyer ceu ko bou wo ko fiyer temi nineu, ca kwali liyarreko ci ywel kumen ki kwama wo ci yo kwar kalereweu ");
INSERT INTO bsj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","wori min nuwa wura la kom neyi cari, min nuwa dilomwe la kom neye noka, min bow fabe la kom doken ki mo mor ");
INSERT INTO bsj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","min ya kwancer la kom dumen kwileni min nuwa bo lumauri kom cib ye mi lofucina kom ya mini ");
INSERT INTO bsj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","dila nubo cak -cakkeu an ciya ciki teluwe, fiyang we tonen ki wura la nyi camkimwe? kaka mwi nuwa dilo mwe tiri nyi nenen noka? ");
INSERT INTO bsj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","fiyang nyi tonen faberi nyi cib nene? kaka mwi kwancer di nyi du mwilene? ");
INSERT INTO bsj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","fiyang nyi to wi nuwa bo lumari kaka lofucinari nyi bou mwinene? ");
INSERT INTO bsj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","la liyau atin ciya na yiciki bilenke mi yi komti dige wo kom ma wii mor-mor kebmibo bidu war tininbo wuro ninu, ko man ki mo ");
INSERT INTO bsj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","la can yi buro kanko mor cekkeu, ko kubom min, kom wo ciikau ko yaken mor kire wo manki dikako ci ywel bwe kelkelenin kange nob bwangkab cekeu, ");
INSERT INTO bsj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","worimin nuwa wura dila kom neye bo cari, min nuwa dilo mwe, dila komneye bo noka, ");
INSERT INTO bsj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","min ya fabe, dila kom dobo kimo mor luwe, kwancer, dilakom dumen bo kulen, dam twirem kange lo fucina dila kom cib yebo ");
INSERT INTO bsj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","la ciyan ciyaken ki teluwe, fyang nyi to ki wuro kaka ki dilomwe, kaka fabe, kwancer, kaka nuwabo luma, kaka focina rila nyi mwen bo nangenne? ");
INSERT INTO bsj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","la can ciya cinen ciki, bilenke mi yikom, diger wo ko mabo kange nin wii mor bi duwar tininbo weri, kom ma membo ");
INSERT INTO bsj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","buro atin go gen mor mwe kako manki dige dila nubo cak -caeu mor dume manki dika. ");
INSERT INTO bsj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","kombo Yeecu dim tok ke ti towo kange ciyeri co ca yii bei tomangeceu, ");
INSERT INTO bsj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","kon nyomom kum kume yob na duklume yabkako na lami, laci an ne ken bibweni na ci kulken co ");
INSERT INTO bsj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","lanob wabeko durko kange, nubo dur nubero cin mwerkangi karak nii wabero durko coti kikayafa. ");
INSERT INTO bsj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","cin tokkangum nure ci tam Yeecu ti yurangum yurange na ci tallum co. ");
INSERT INTO bsj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","la ci ti tokiki kebo ki duklumeu kati kwalkanke kweni tiber niber, ");
INSERT INTO bsj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","kamob Yeecu ki no betanya lob caminu waleu ");
INSERT INTO bsj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","dong dong kambo co yim cunga kobiomero ci cam. cori tiyeri, co nawiye kange dou kiwer nuwanger wo kikiyemereu cor Yeecu nin ti dorcer ");
INSERT INTO bsj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kambo bibei tomange cru to wo nyeri nercer. ron kaya, kim yebwi a yakcang wo ti nye? ");
INSERT INTO bsj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","woro tin miyem ki kiyemero ducce na neken nob bune bou ");
INSERT INTO bsj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","la Yeecu nyomom wuro lam yii ci, ye bwi ka ne nawiye wo dotange tinye? wo con mamen dikero yor yore ");
INSERT INTO bsj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","kom kir-kir kange nob bunebo, la maka fiya, yeti kir-kir. ");
INSERT INTO bsj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","na wo co corti nuwangko wo bwimi yeu, co mamna furka miko ce. ");
INSERT INTO bsj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","bi com ma yii komti na fe atok fulen ke do wo tiye fo dor bitinero wo dike nawiye wo mane an toki ken na kwa ki co. ");
INSERT INTO bsj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","la win mor kwob cilom bo yobenin coti Yuhuda kar yoti yeu yaken liya wabe nin. ");
INSERT INTO bsj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","con toki, yemo cuiti mwa neye tiye naneken niwo kangmuek di? cin cuwa cinen mwin do kwini ta'ar. ");
INSERT INTO bsj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","la nyeu con ta do ka nureko wo ca neken coti kang cikeu, ");
INSERT INTO bsj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","la kume kaba wo duklume yabkako neu bi bei tomange ceu bou cinen, la ci me co, fe mo cuiti nyo yulangum na mo camcari durlume yabkaro we? ");
INSERT INTO bsj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","co yii ci kom durlume cinan lor, kan fiya nii kange, ko yii co ni do mor ka toknyo kangkene takako dom, maca cari durlumer yabkaro lomo bibei tomangemiu. ");
INSERT INTO bsj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","bibei tomange ceu mani kanbo co yii ciyeu, ci yuelagum cari duklume yabkaro. ");
INSERT INTO bsj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","la ki mee con yii kange bibei tomange ceu kweb cilombo yobeu na ci can cari to. ");
INSERT INTO bsj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","kanbo ci ca cari to tiyeri, con yici, bicom ma yii komti win more kume an miyem ye ");
INSERT INTO bsj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","cin ma fir neorer, cinter meka ceko kiwinti min nyumom ke bomo na teluwe? ");
INSERT INTO bsj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","la co yii ci, wuro dor kangti kange mo mor kwele wineu co nii a miye yetiye ");
INSERT INTO bsj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","bibwe nifire an u kanbo mulangi dorcereu la kwanco nii kercer ci miye bibwe nii ye tin yor ni conin na cibou co bo di. ");
INSERT INTO bsj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuda wo a miye co tiyeu me co, ma nii merangka? la con yi co, mon tokum ki bwimi. ");
INSERT INTO bsj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","kanbo cica carito tiyeri, Yeecu tu carito yoten bibwiyer an kabkangum. con ne bibei tomange ceu, con tu cam wuro bwimi, ");
INSERT INTO bsj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","con tu kwelmwenge, con ma buka kangek co ca nee ciye, yii ci ko nom gwam kume ");
INSERT INTO bsj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","won bwiyalemi wo noro ceu wo corena tab ka bwiran kerer nubo kila-kila ");
INSERT INTO bsj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","la ma yii komti, mani ma no mwem inabim bo wo ti tak mano kange okm fuije mor liyare Teemi. ");
INSERT INTO bsj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","la ci okm nuweu, co ci cu bang jaitune ");
INSERT INTO bsj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","la Yeecu yii ci, gwam kume kan kottangi ker mir ki kume wo, wori mulangum mulange. man tumom nii to tiyeu, kwame ten do an yalam ");
INSERT INTO bsj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","la bwiko wo ma kwenunmeri, man yaken ten kumen Galili. ");
INSERT INTO bsj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bitru yii co bwentano tangnim bo anyarangum ker mwer di, mi mani ma yarti ");
INSERT INTO bsj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeecu yii co bicom ma yinenti mor kume wo bicake na manb kiyangeri mon yi moki mo nyom yebo kirito ta'ar ");
INSERT INTO bsj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitru yii co, bwentano ma bweya kange mori, mani ma yiti mi ma nyomnenbo la tangunim bi bei tomange cembo tokti nyo ken ");
INSERT INTO bsj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","co Yeecu yaken kange ci fiye wo co tike Getca maniyeu laco yii bi bei tomangeceu ka yim fo miki yankab ma koub dilo ");
INSERT INTO bsj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","con tu Bitru kange bibeyo lo Jabadi yobeu, kange co, con ter bulankako kange tutum nerem ");
INSERT INTO bsj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","la co yii ci, dumemi ki no mor bulanka wo a lamti ki mo bwareu ka yim for koma corka kange mo ");
INSERT INTO bsj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","con kutaken tenkab biduwar la con yarken ki tikob ceb. laco kob dilo con toki, mo Teemi na an mamdi, kweie wo a cum ye, kebo mi a bwang tentiye la an bwanten dike mo cuiyeu. ");
INSERT INTO bsj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","con yila bibei tomang ce nin co fiya ci dam dum lacon yii Bitru mo maka cor ti kange mo bwen na nang kenoko wina? ");
INSERT INTO bsj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","kom cori kom kwob dilo kati ko yarken cuwaka, yuwa tangbe kwama kom ciya, la bwiyo kwambo ");
INSERT INTO bsj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","coca yila yobece co kob dilo, con tok mo Teemi nona kwele wo cunin man nocori, be dike mo cuiti ye a mani ");
INSERT INTO bsj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","con yilau ten co fiya ci da dumti wori nuwe ciyeu tu'u kabo ");
INSERT INTO bsj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","con dubangum ci tak nako ta'areu, co kob dilo ti co tok tika dike kitanca tokeu ");
INSERT INTO bsj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yeecu yila bi bei tomangkace nin, la con yii ci, ko damdum duwal komti fuobi? koto kwama con dadom, la cin neken bi bwe nifire kange nob bwiran ker. ");
INSERT INTO bsj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ko kwen bi ya to niwo a miye yetiyeu won lambi dom ");
INSERT INTO bsj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","kambo co tok keretiyeu, yafuda win mor kwob cilom bo yobeu kange nubo dur nubero. cin bou ki kulenti kange kulki ");
INSERT INTO bsj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","na weu, nii wo amiye Yeecu tiyeu tiibum ci yii ci nii wo ma teiceri co, ko tam co ");
INSERT INTO bsj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","na con bou Yeecu nin con toki, yarume nii merangka laco tei bwiciu ");
INSERT INTO bsj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeecu yii co, farmi, ma dike mo bo makau, co ci bouwe ciyoti kanko dor Yeecu de laci tamco. ");
INSERT INTO bsj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","la kange, kange Yeecu ter kan ceko coku kulendo cuwalum tu'u canga nii wabe durko, ");
INSERT INTO bsj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","co Yeecu yii ce dokken kulen mwero fiye ce loco nubo wo tu kulene di a dwiya kin kulen ");
INSERT INTO bsj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","mo kwatiri mani maco tee mi ti ya, la can tommer dike cum wenange kwob cilombo yobeu wo nob tomangeb cebo wucakkeu? ");
INSERT INTO bsj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","la a ma nyi na bifumero na dim na wo tam nar ma nyeu? ");
INSERT INTO bsj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","la Yeecu yii nubo dim wiyeu, ka bou kin kulen kange kulki bou ko ta ye na nii kwiye? mati yii ma meranti kir-kir kur waber la ka ta yebo. ");
INSERT INTO bsj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","wo gwam ma nyo na dike nob dukumero na dimla bi bei tomange ceu gwam dubom co cuakkanyi cu. ");
INSERT INTO bsj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","nubo buro ta co Yeecu yaken ki co kayafa nin nii wabe durko, fiye nob muiangkabo kange nubo durko mwerkangum wari yeu ");
INSERT INTO bsj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","la Bitru bwang cinen tenti ku tan kange karak nii wabere durko con do ken mor co yii na co to dike a matiye ");
INSERT INTO bsj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","na weu laya wabeu kange nob tikali cebo ki to warke cuerker dor Yeecu na ci tualum co. ");
INSERT INTO bsj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","la fiya bo win wo. na duwaleu nob warker cwerkero kila bou kab. ");
INSERT INTO bsj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","la ciki nii wo ki canwerum kur wabe kwamaro na co muti mor kume ta'ar. ");
INSERT INTO bsj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","nii wabe kwen titiye lanme, co, mo man ki diker kar kaka? warke wini ci war ti dor mwere ");
INSERT INTO bsj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","la Yeecu kumom. nii wabe durko yii co mo yii nen ti ki nyal kange kwama wo ki dumeu, yii kenon mo kritti bi bwe kwama ");
INSERT INTO bsj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeecu karcenen, mon to kum ki ko kab mon to bi bwenii yim kang ko catiyer bikwanrd, la yiranti dor bi loro dii kwama. ");
INSERT INTO bsj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","la nii wabe durko worbangum belleceu, ki tok kero bwir, ye bwi bou do nob warker ti dualla? koto na wo kom nuwam kero bwirko. ");
INSERT INTO bsj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ye ko kwatiye? cin ciya ciki con daten buar ");
INSERT INTO bsj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ci tuom cinen ti bi tom bo tikob, yila cibukten co. ci kwabanco ki kani ceyeu. ");
INSERT INTO bsj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","la ciki, yii bo ker dukumer mo kiritti. we wo kwa nene? ");
INSERT INTO bsj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","la Bitru yim kale mor karake, la bubya kange canga bou cinen yii mo ki no kange Yeecu wo Galiliu” ");
INSERT INTO bsj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","la Bitru kanangum kabum ciyem gwam tokti ki, ma nyombo dike motokker ti dorce reu. ");
INSERT INTO bsj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","kanbo co cerken nyi lo ko kaleri, kange bubya toco la yii nubo wiyeu, nii wo ken kino kange Yeecu bunajare. ");
INSERT INTO bsj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","yila con kanangum ten kange weri, ma nyom bo nii co ");
INSERT INTO bsj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kakten nyo bi budar di nubo wo tirangum wiyeu bou yii Bitru, bicom mon wi more ciye ken wori kero mo tok tiyeu nugum nen. ");
INSERT INTO bsj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","la con yoten kan cilka kange weri manyombo nii co, ladanjang bi cukeu mob kiya ngeu, ");
INSERT INTO bsj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bitru kwabi ki kero Yeecu tokeu. bicake na mob kiyangeu mwan kanang ye kiro ta'ar. la con cerken kale cociwiye kefir neerer. ");
INSERT INTO bsj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","kambo fini celummeri, liya wabe kanga nubo dur nubero cin fuwakang nureu ciya tam Yeecu ti naci twalumceu. ");
INSERT INTO bsj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","cin bwanco, cin neken liya dur ko Bilatu ");
INSERT INTO bsj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","dila ya fuda niwo nekenceu, kokacito ci war Yeecu nin bolang twal keri in do yiloka-yilotak yila cimen ki nungeu kwini ta'ar durem faricawanin kannge nubo dur ");
INSERT INTO bsj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","yii ki mimmam bwirang ke ma neken buyale wo mabo bwirang keu la cin toki kii, ye yonyo wiye? nuwa ciko dor mwer? ");
INSERT INTO bsj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","dila cutang culom nungemwi bitine ku wabe liyan dob ci, yaken yan yeiken dor cero ");
INSERT INTO bsj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","dila ni durwabero tu culom nungembo yiki, kebo dnggdong mor werfuner ");
INSERT INTO bsj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","la ci fuwakam keroco tibercer, kemero lacin te num ka fiye nii muka tinngek nin yilam fiye tuwe fabube bi ye kenwo mor tinnyere, kemer buyalr ka ");
INSERT INTO bsj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","won co dike bwici cuo fi coti toti nyii Irimiya di duwenne kowo ");
INSERT INTO bsj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","dila dike toki nyii Iremiya nii du kumeu diim cin tu culom nungem kwini ta'ar wo fene bibei Iccere, la yo dor ciro nin neu, ");
INSERT INTO bsj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","cin neken na tenka bitinek nii tinngeret, nawo kwama yi yeureu ");
INSERT INTO bsj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","dila Yeecunti kabum liya durko, liyadurko meco, mun liya yafudawarka? Yeecu ciya, nyoo mwa toke ");
INSERT INTO bsj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","dila nob webebbo durko kange nubo durko cin mwelcinen, tokbo ker, ");
INSERT INTO bsj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","dila Bilatu yico ki, mwo nuwabo mwelka tinim bowo ci mamen tiye ka? ");
INSERT INTO bsj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","dila yicobo ker winwo, dike liya durko nyimanyi kambo ken ");
INSERT INTO bsj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","liya durko nyamkang niwin nin nii wo nubo ma dacenneu ");
INSERT INTO bsj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ki kwama wuro cin wiki kange nii furcina deco Barnaba. ");
INSERT INTO bsj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","la kaci muromere, dila Bilatu yici ki we kom cuiti a nya kumen kannge? Barnaba, kaka a wo ci cuwoti ki Yeecu kiritti ka? ");
INSERT INTO bsj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","wori cin nyimwom cibomkico na kiyerce ");
INSERT INTO bsj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","kanbo ciyim kutile twomcinen twomange ki, cirom nii wo nin nii manki bwaranke wuro min cokkan mor dukume kambo ken kercer. ");
INSERT INTO bsj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ki kwwamawo durem liya wabembo kannge nubo durko cin bolum nubo cin yi ki a nyani nen kange Barnaba nin, a twalum Yeecu ");
INSERT INTO bsj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","dila dur liya meci kom cuiti a nya kumen kange? cin yi ki, Barnaba ");
INSERT INTO bsj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatu yi ci ye ma ma Yeecu ninti woci cuwoti kiritti dila gwamceu cii ciya akulken co. ");
INSERT INTO bsj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","lan yii ci, ye bwiye, bwiran kererde camane? di cin ciya ki diro duro dur, akulkenco ");
INSERT INTO bsj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","kambo Bilatu to manica doldiker tiyeri wori kwobkanke atin kweni, duu mwembo nirim kemceko kabum nubem, yiki, mimanki bwiranke dor buyale niwo manki kwirankru komma dike komcuiye. ");
INSERT INTO bsj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","nubo kwarub yiki, dila buyaleceu a yii ken dor nyo kange bi beyo lokyeun ");
INSERT INTO bsj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","la nya cinen Banaba dila ma Yeecu nin balyanyeri neken co cinen na yekom co ");
INSERT INTO bsj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","la nob dakkeb liya dureko cintu Yeecu cin yaken ciko mor luwe liyako dur, lacin murou tangne nob dukkebo ducce ");
INSERT INTO bsj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","cin marancinen meke na nyime ci dokcinen kulendo fiyere. ");
INSERT INTO bsj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","cin me cinen lalam duwek cuakkek cin dok cinenti dorcer, yila cineco dango ciya tam kamce ko cal ciyere cin cunyii kabumce ci ma ci nen buuomti, ci yi ti ki dume mweu akutan nyi liya yafudawar' ");
INSERT INTO bsj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","cin tuomcinenti betuombo bwitak, ci yom damngo ci mweco ciko dor ");
INSERT INTO bsj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","kam cidim buo kace keri, cin cokum lalango cin dok ci nen kulencero, cin cin ca cin kaba ya ken kica fiye ciya kulen cotiyeu ");
INSERT INTO bsj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","kambo ci ciro kalere, cin kwabti bue ni bakurame kange dencero caminu, woci dokco ayakangeci natum bwatiye kulkake ");
INSERT INTO bsj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","cin lau fiye kange ci cuotiki goltau, wuro yitiye, kweldu wee, ");
INSERT INTO bsj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","cine neco mwem mwerum kange dike tweitweyeu naci nom kanbo citwiyeri lako nobo ");
INSERT INTO bsj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","kanbo ci kulken ceri, cin kabkannyum belleceu kimaka dacenek dor cer ");
INSERT INTO bsj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","lacin yiken ci too coti ");
INSERT INTO bsj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","cin mulang dike kange cin yei ci nenti dor cer yiiki wonco liya yafudane ");
INSERT INTO bsj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","cin yenkeco wari kange nob kub nyo yob, win neu kango cacci yerece wneu kango mwokece ");
INSERT INTO bsj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","burombo cutiyeu too co t, fok doroti, ");
INSERT INTO bsj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","laciti tokii, mwo muki mwom wurom lo kwamau yila mu mum mor kume ta'ar fulom dor mwero cile no munbi bwe kwamari yarau cuktom bwatiye nin ");
INSERT INTO bsj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","nyoken durem nob wabebo macinen kange nob mulamgkab kange liyab bo durembo, ciyi tiki, ");
INSERT INTO bsj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","fulom kangumbo la fueki fuloka dorek ceko co liya jorilawa. ciya yirau dor cuktum bwatiyem nabi ne bilinke fiye ciwuyeu ");
INSERT INTO bsj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","kambo ca ciya kange kwama. kwama a cerco wori cinyi ciki cimbi bwe kwama ");
INSERT INTO bsj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","nyo naco nob kubbowo nyo yob ci kulkenci wari yeu ci toce. ");
INSERT INTO bsj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","46","ki kakukce kumta cileu cumuom bitineu kwarub yalam kene ta'ar na meece. ki kene taareri, Yeecu kun diro kibi kwan yikii, eli-eli lama cabak tani? ki tokki, kwamanin, kwamami, yebwi mu mirannye wiye? ");
INSERT INTO bsj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","kanbo birombo timbo dmmen muwari nyeri, lacin yiki, nyi bicuor Iliyaro ");
INSERT INTO bsj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","dangjang dangjang kange woom nacwak yatuu cukko dokti mor munge fuwar dokti dor damge tarcinen ciya nom ");
INSERT INTO bsj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","latangneceu, dubomco nabito keno Iliya anbou na fulomcori ");
INSERT INTO bsj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","la Yeecu kundiro kibi kwan cii neyee cola nyam kang yuwa tangbek ceko nin ne ");
INSERT INTO bsj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","dila kuwabe kwama woram moro yob tamdi yiraken ciko bitini. bitrneu mikan nyi, bangtinimbo yaranngum, ");
INSERT INTO bsj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tuwe tinimbo wumangum, birombo wucakkeu darangum dameu cin kunangum ");
INSERT INTO bsj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","cin cirangum mor tuwe tinim kanbo ca kwenum meri, cin doken cinar loro wu cakke cin yau nubo nin kila. ");
INSERT INTO bsj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ka dur nob dakkebo kange nubo wuro to Yeecu cin cwamtai kibi mikaka bitineko kange diko bwiyeuri, cin cwamtai kibi cuom cin yiki, bilinke wobi bwe kwama ");
INSERT INTO bsj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","na tubo killa wofo Galili birombo bwangten Yeecu naci too ceu cin citi toi kutan ");
INSERT INTO bsj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","morece mar yamu magdaliya, maryamu nee Yeecu kange yucufu, kange nii bibwe zabadi ");
INSERT INTO bsj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","kimeri lani cwekaka ko kange inni armatiya bou, dencoro yucufu cekeneu inni bwanka Yeecu ");
INSERT INTO bsj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ya bilatunin me aneco bwi Yeecu dila Bilatu ne nyaldo aneco ");
INSERT INTO bsj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yucufu tu bwi Yeecu cumuom ki lalango wucekke, ");
INSERT INTO bsj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","la dokkenco mor tuweco ca wobi fwijeu mor la cin tungti tero nyi tuwe co cuwi ");
INSERT INTO bsj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu Magdaliya kange Maryamu wineu ciyim cunga ko wineri ");
INSERT INTO bsj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","cilfiniceu nawo kume yulangka ko cumeu, liya wabe kange faricawa cin muri kange Bilatu. ");
INSERT INTO bsj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","cin yiki, tee luwe nyim kwabi ki kwama wo ni bibolero wuro kidu meu toki kii ki kume taardi ");
INSERT INTO bsj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","man kwenum nyori ne nyaldo a to tuweti na kume yo bbece kebo nyori nob bwanka cebo anbou kumco, laci yi nubo, in kwennm tuwe. la buoko an la kaba ko ceu bwiraka ");
INSERT INTO bsj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatu yici kom tu nob to kabo kamma tokako kibi kwan kumer gwam ");
INSERT INTO bsj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","la ci ya cito tuweti cin cumuom tuweu cin titi to ka kaning ");
INSERT INTO bsj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ki kume kakuk fobka fiini, dadonm celti na kume winneu mor nibere. maryamu makdaliya kange maryamu, ya naci tuwe Yeecu ");
INSERT INTO bsj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","la bitine muka ducce, wori yuwa tangbe kwama wucake yirau di kwama bou tungum tero, yiti dor cer ");
INSERT INTO bsj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","yirom cembo na milbangka, la kulen cero na cuno ");
INSERT INTO bsj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","nubo to tuwe tiyeu cwa tai duccu, cin yilam na bilenti nibe ");
INSERT INTO bsj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","nob tomangem kwama wucake yi natubo wuro ki, kom cware tai min yimom kom ki do Yeecu wo ci yei bwatiyeu ");
INSERT INTO bsj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","mani fo, kwenum na woco tokeu, tofiye teluwe daa wiye ");
INSERT INTO bsj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","kom ya wulom, wulom kiyibi bei tomange ceu, kwenum nin, to wii kakom yakenti Galili ka fiya co firen to min yi kom. ");
INSERT INTO bsj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","natubo wo wulom-wulom dubom tuweu, ki tai kange for nerero dur, cin cwa na ciyi bi bei tomange. ");
INSERT INTO bsj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","la Yeecu fiya ci, ci ki yarume natubo bou tam naceko, wabco ");
INSERT INTO bsj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeecu yici, kom nuware tai ki ya kom yi yitob mibo ciya yaa Galilin ciya toye firen ");
INSERT INTO bsj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","fiye natubo wuro mor yameri. nobo to tuwe tiye doken cinar lor, cin yi liya nob wabeko dike maneugwam, ");
INSERT INTO bsj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","nob wabe kwama mwerkangi kange nubo durko, cin tokkan dike wo cange ci, cin ne nob toka tuweko kyemer duccu ");
INSERT INTO bsj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","cin yi ci tanne nubeu, be bei tomange ceu bou bon kum bilen cero, fiya cuwo kom da dumti ");
INSERT INTO bsj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","tona kero wo lam liya durkori, nyan ken co na daken ki ner cere fiye ki wiye ");
INSERT INTO bsj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","nyori nob toka tuwe ko wo yuwo kyemero la cin mani na wo ci yi ciyeu kero wuro wati mor yahudawa yaken ciko duwen ");
INSERT INTO bsj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","la ci bei tomange kwob culombo wiineu yaken Galili dor bangero Yeecu yi ciyeu ");
INSERT INTO bsj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","la cin to cori, cin wab co, di kangumbo ciyabo ");
INSERT INTO bsj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeecu bou cinen, yi ci ker ki, bi kwamer liyaret cin neye dii kwama kange dor biitiner. ");
INSERT INTO bsj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","kom ya ki dok nobo a yilam bi bei tomange ka le wo gwam kom yu'u cinen mwem ki den te, kange bwe kange yuwa tangbe wucake ");
INSERT INTO bsj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kom meran cinen ciya bwangten dikero gwam wo ma yi kom ki nyial leu to mikange kom ya ciko cwile kale. ");
INSERT INTO bsj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wo co terka fulen kerer Yecu kritti bi bwe kwama. ");
INSERT INTO bsj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nawo mulangnum mwor icaya nii tomangeu, To mi tung nii tomange mii ti kabum mwem wuro a ywel mwen nure tiyeu. ");
INSERT INTO bsj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Diro wo cuo bi cuor ti mwor yere ywelum nure kwamau, kom ywel nure cew na tiken cer. ");
INSERT INTO bsj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","kambo ci yilau kafanaum kume tini biduwar cumeu lan nuwam ki cii wii lo. ");
INSERT INTO bsj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ducce mweri wi wo fiye kumbo wiyeu ki nyilocek, la Yecu yicii kero. ");
INSERT INTO bsj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","La Yecu yila ten mor bikur waber la nikange wo Yecu kanko nom-nokeu. ");
INSERT INTO bsj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nubo kangem cii cinen ten niwe naci to keno can tam niwo ki kakon fobka di na ci mwelcinen ti dor. ");
INSERT INTO bsj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","La con ter merankako kong caji. nubo kilakila mwrum wi kentangum co, ta con doken mor nabire menge mor caji con yiken morcer. Nubo mwerum wiyeu yim ciye dukle kong caji. ");
INSERT INTO bsj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","La co merang cinen dikero ducce ki dangke, mor merangka ceko con yiki. ");
INSERT INTO bsj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cin beken dinge caciyo wineu mor Gerasenes. ");
INSERT INTO bsj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na wo dang Cang, la Yecu yiram mor nabire kange nii kidwiti yuwa cerou mor twe tinin con wakanco. ");
INSERT INTO bsj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nobom ci con dou cinanlorciye, bi bei tomange ceu bwangu co. ");
INSERT INTO bsj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bi diye fobkako bo con do bilkur waber co merang cimenti. Nubo duce nuwa meranka ceko diger nyomanka tam ci. ciki fiya merankakowo fee? Yilen do wini kwama nece nye? nangen nyomanka ko wini co mati ki kang ceke? ");
INSERT INTO bsj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kebo bibwe nii kwanka kuweko wabi bwe maryamu, yii Yakubu kage Yoci kange Yahuda kange Caminu? Kebce bo natubo wo bo wari kange ci? ci nuwa bo luma nerciyer ki Yecu. ");
INSERT INTO bsj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Faricawa muri yecunin kange nob mulankabo firen Urcalima ");
INSERT INTO bsj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ki kumetin dowo, nakali mwer kangka nubek, laciman kicari ");
INSERT INTO bsj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yecu cwo nob bwang kaceb yiciki mici bwini nubo wuroti wuri lamkume taar ciwari kan-nge moo cari mani. n ");
INSERT INTO bsj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","non yokenci miniya yilarenggen loci cari maniri ciyan cuwela nure wori loniceu kutagnyii kabo. ");
INSERT INTO bsj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","nob bwangka cebo ciya yiki, ba fiya tillita wurofe mor kiye wuro alam nubo wuro nyeu? ");
INSERT INTO bsj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","cin yici bibicum min yikom kangem ki membo wii timfo mani ciya to bwar ti na nimde ci to liyar kwama bou cinen kibi kwan, ");
INSERT INTO bsj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","kume nugkun cume Yecu tu yowana filibu kange Yakubu kange co dii dor banger do cwemet ki kwaci ");
INSERT INTO bsj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","la fulongum bwici kabum ciye ni kulendo bwiceu fuwo kulek miblanti miblanti cum na dige kange forkalewo ");
INSERT INTO bsj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeecu dubonm fiye cure yakin chinge biten urdun la nubo nya cinen co meran cinen kambo yilam na dum ci ceyerm be. ");
INSERT INTO bsj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lafaricawa bou ci nen citokki, dong dongka nina twal wice nin naka? me kewo cimane naci cuwa co. ");
INSERT INTO bsj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ciya cimen nye mu ca yi ko na kom ma ne? ");
INSERT INTO bsj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Muca ki mulang bifumer twalka naka yiken wi mweca cirli. ");
INSERT INTO bsj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","nawo cibo Urcalima cibi dom kange Betafaji kange Betanya fiye bang zaituneke. yeecu tom bi bei tomange ce yob ");
INSERT INTO bsj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yi ci ki kom domor cunkurdo wo bi dom kange be, yo kodoti nyori kan to beikelba tekum, wo nii kwimbo wiye, kom kwiu combõmen ciko ");
INSERT INTO bsj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tano kange yi co kom ki nye bweiye, kom yi co kom ki teluwe co cwitiye, an yilau ciko comnawo ");
INSERT INTO bsj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yecu yo meranka cinenti ki dange, coki nii kange wii twi take ce, kwarum, con wob buwak yamka? biti kam no maka naneg mor take. lam cuken bitine. ");
INSERT INTO bsj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cwakiya law con tom kange ya ayocinen bitungtunge mor take. ");
INSERT INTO bsj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nom takebo taco buk cu ywico kam koni. ");
INSERT INTO bsj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yecu Ceru bikurwab wiin mor nom bukacebor yi cui ni meranka. to iker yumaka yabraka terek ko wo kange yobraka luwatimuwo. ");
INSERT INTO bsj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yicu ki, mun to yobraka luweinbowura? bero nakye man wu a dob ti dr kece, mana buubatiye. ");
INSERT INTO bsj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Duklume yabka, wo carito camfuwmbo maniye kum kume yob, durtinin nob wabebo, kange nob mulangkab werfunero cin do kambo ciya tam Yecu tiyeu yurangum yurange na cin bwalum co la. ");
INSERT INTO bsj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ciki kebo ki duklume kari bouki kyan tiber neber. ");
INSERT INTO bsj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","La ki kwomceri nubo durko cin mwerkanye kange nubo dur mulanka, kange nubo durko. Cin tam Yecu cinyo cou kab, cin neken cou kan Bilatu. ");
INSERT INTO bsj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatu mee cou mwo dur liyar Yahudawa ka? con ciya ci kii ywo nawo mwa tikeu. ");
INSERT INTO bsj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","La nubo dur firitoci cin bou kii cwarum cembo ci ma co Yecu neneu. ");
INSERT INTO bsj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kambo diye fufkako lame di Mari kange Magdaline nee Jame, colomi tenou nowan beltika wo ciya belti Yecu nen tiyeu. ");
INSERT INTO bsj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kii kwamce kume wine na kume nibere, cin yari tuwe wumom na nimde kakoko curou. ");
INSERT INTO bsj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nubo ɗuce wo tum nangen mulangka dor digero wo tim ɗong ɗong more beu, ");
INSERT INTO bsj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nawo bou binen kang nubo wo kaba tom nuwe kanga nuweu kange cangatini kereu. ");
INSERT INTO bsj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","La yilam yarak tak minen wori min fuwam ɗigero wiyak ki kaba, nan mulang mwen ɗigero wo wank ki wank nii la ɗureu Tiyofila. ");
INSERT INTO bsj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nyori na mwi nyimon bilenke dikero ci merang mweneu. ");
INSERT INTO bsj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ki kumeni Hiridu liya Yahuda, nii wabe kange wi dendo Zakariya wo mwanlor Abija; Wice Alicabatu ken naniyak Haruna. ");
INSERT INTO bsj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Gwam ce ci cak-cak ka kwama (ci manki) kurom mor werfun kange bidoti te luwe. ");
INSERT INTO bsj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dila ciman ki bwe wori Alicabatu Combilome, ri cin cirarangum gwance. ");
INSERT INTO bsj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","La kambo Zakariya ka kwama ma nangentini nii waberti wo bwangten cokka ce keu. ");
INSERT INTO bsj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ki nure ciki bwangten de naci cok nii wabe wo a wabtiyeu, la cin cok co ki dajen naci doken mor bi kur wabe Teluwe naci tui nuwanko ficange. ");
INSERT INTO bsj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mwerka nibe ko gwam kuob dilo ti kale ki kwama wo nuwanko ficangeu tui tiye. ");
INSERT INTO bsj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","La bwetomange Teluweu cer cinen lan tiken cattiyer tancilan ficanger. ");
INSERT INTO bsj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kambo Zakariya toceri, kwomco, la taito tanco. ");
INSERT INTO bsj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dila bwe tomange kwama yico “Cuware tai Zakariya, wori cin nuwam dilo mweu. Wi mwe Alicabatu an bo mwen bwe. Mwi Co dencero Yowana. ");
INSERT INTO bsj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mwan yikam ki bilangtum kange fuwor nere, la nubo kila a bilangti ki borcere. ");
INSERT INTO bsj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wori Canyi lan ki dur kabuni Te-luwe. Mani co no mwem bi tuittuibti kaka diker no karo kwam kwame, Catin din ki yiwa tangbe ko wucakeu mor fwiye nece. ");
INSERT INTO bsj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naniyak Iciraila ko duce wo a yila cuko Teluwe kwama Cenen. ");
INSERT INTO bsj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Can ya kabum Teluwe mo yu wa tangbo kange bikwan Iliyak, Na yilau ki ner tebembo bibeyo nen kange wo bongi nyeu na ya mor nyomka cak-cake -na ci Ywel te luwe nin nubo wo ci cok cineneu.” ");
INSERT INTO bsj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya yi Bwetanange wucake “Ma nyom dike wo nyi? wori min cele ri wimi coro kilam”. ");
INSERT INTO bsj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nii tomangeu wucakeu Ciya yicoki “Mo Jibrai'lu, wo tire kabum kwamau. Cin tomu ye nami yinen ker, nan bo mwen ki kero lomlome. ");
INSERT INTO bsj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","La to! Mwan yilam cōk, mani mwa dol tokka kere ti, dila diya dikero buro dimmeri ntimade. Wori mwi nebo bilenker ker miro nin, wo a diiti ki kwama dong-donge ");
INSERT INTO bsj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La nubo ningtang Zakariya ti. Cin nyimangi wori cinti lenger mor bikur waber. ");
INSERT INTO bsj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dila ki kwa'ma ci ceruweri, dolbo yici ker. La ciin nyimom ki cin to dukum ki kwamawo ci mor bikur-wabereu. La cin nungkancinen ti ki kank worimani citok ker ti. ");
INSERT INTO bsj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","La yilam kambo kumeni nanger cero cume ri, cin cu lo co. ");
INSERT INTO bsj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kambo kume ni wo cumeri, wice Alicabatu tum fwer la cin yu rangum dorceri na cuwako nunge ce. Cin yiki, ");
INSERT INTO bsj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wo lo diker kwama mamene kambo ci toye ki corciniyeu, naci tum kwenduwe miu ka nobe. ");
INSERT INTO bsj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ki ciwako nukkune, kwama tom nii tomange wuccake Jibrailu mor Cinanlor Galili ci coti ki Nazaret, ");
INSERT INTO bsj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","bubiya nin wo cine ken nii kange wo den cero Yucufu, wo naniyak Dauda, la bubiya dendo Maryamu. ");
INSERT INTO bsj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Cin bow Cinenri ciki, “A Ysrumnen, mo wo fiya cini ducce! Teluwe wi kange mo”. ");
INSERT INTO bsj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","La cin kulongum duce, ki kercero la cin kwabi, ya rume ye wo. ");
INSERT INTO bsj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bwe tomange wuccake yicoki, “Cuware tai, Maryamu, wori mwin fiya cini kwama nin. ");
INSERT INTO bsj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","To, mwan tu fwed ri na mwi bo bwe. Mwa cun den cero 'Yecu'. ");
INSERT INTO bsj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Can yilam nii dur la ci cuu ki Bibwe nii dur re. Teluwe kwama atin ne co kuti le liyare Tekwace Dauda. ");
INSERT INTO bsj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Can ma liyar dor lo Yakubu diiri, Liyar cero manki dika”. ");
INSERT INTO bsj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamu me bibwetomange wuccake ki; “Dike wo a bwinyi la mi nyumumbo nii na bare wiyeu?” ");
INSERT INTO bsj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bibwe tomange kwaama ciya ri yi co ki, “Yuwa tangba kwamako an bow mwinen, ri bi kwan nii dur reu atin bow dor mwer. La wucakke wo mwi bo tiyeu a coki Bibwe kwama. ");
INSERT INTO bsj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","To, na niya mweko Alicabatu tu fwer ki ciraka ceko. Wo co cuwiyak ceko mukkune, co wo no ci cuoti ki combilomeu. ");
INSERT INTO bsj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Di kero kange mani wo mani a mati kabum kwama”. ");
INSERT INTO bsj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamu yi ki, “To, min bubiya canga kwama. A yila men na tomange meu”. Dila bwe tomange kwama dob co. ");
INSERT INTO bsj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dila Maryamu kweni ki kume tini co wulom wulom yaken mor bi ten kongtini, yaken bi ten Yahuda. ");
INSERT INTO bsj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ciin yaken mor luwe Zakariya ri cin yarum Alicabatu. ");
INSERT INTO bsj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yilam kambo Alicabatu nuwa yarume Maryamu ri bwe mor fwe ce mokangi la Alicabatu diim ki yuwa tangbako wucake. ");
INSERT INTO bsj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ciin kung dir cero kibi kwan ciki, “Mwin nii bi bwiyere mor natube, ri nii bwiyere bwe wo mor fwiye meu. ");
INSERT INTO bsj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ye bwi wo fiya yenye, la ne Te luwe mi a bou ti mi nene? ");
INSERT INTO bsj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","La ta kambo diir yaru mer mwero bou tu miyeri bwe fwe. ");
INSERT INTO bsj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nii bi bwiyere co nawiye wo ne bilenke ki digero wo ciyi co fiye kwama wiye atin dii me. ");
INSERT INTO bsj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamu yiki “Dume miu caklang Te luwe ");
INSERT INTO bsj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","re, yuwa tangba miu bilangi kwama nii cyer yerenin. ");
INSERT INTO bsj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wori cin to cukka dorek bubiya canga ce. La to, nawo kange kab kaltini gwam a co yeki nii bi bwiyere. ");
INSERT INTO bsj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wori co, wo nii bi kwaneu, ma men digero dur, la den cero wucak. ");
INSERT INTO bsj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jire duwe ceu tii nyo kal ya ciko kaleu ki buro wo nuwa taicero tiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cin nung bi kwancero ki kank cek, cin yalum buro ki kunka duwek keu ki dike ci kwati neer cere. ");
INSERT INTO bsj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cin cukkangum bi bei liyabbe dor kutile cero nin, la cin kungum nob fuebbo. ");
INSERT INTO bsj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Cin cam ki nob wurabbo ki diketi no ken, dila nubo cuwe cuweu cin yoken ci kang kwicer. ");
INSERT INTO bsj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cin ne canga ce Iciraila tikali, nyori naci kwabi naci nung jire duwe ");
INSERT INTO bsj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Nawo ci yi tebbe beu) ciyi Ibrahim kange naniyak ceke diri. ");
INSERT INTO bsj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryamu yi kange Alicabatu cuyako ta'ar ri cin yilaken lo co. ");
INSERT INTO bsj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","La kwama bou na Alicabatu a bom bwi bwece, la cin bou bwe bwayile. ");
INSERT INTO bsj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nubo bi dom kange ca kange na niyak ceko nuwa ki kwama nung cinen Jire duwe ce durko, la cin bilangi kange co. ");
INSERT INTO bsj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","La yilam ki diye naruberi cin bow naci mwatum lar bwero. Ciikin cuom co “Zakariya”, na den te cero. ");
INSERT INTO bsj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dila neele ciya ki o, onga. “A cuoco ki Yuwana” ");
INSERT INTO bsj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cin yicoki, “Nii kange man mor naniya kumek wo cico tiki dendo we”. ");
INSERT INTO bsj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cin nung tece ninki kang kambo ci cuiti naci ne co dendeu. ");
INSERT INTO bsj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tece me ci ya neco ter mulankar la cin mulangi, “Den cero Yohanna”. Cin nyimangi gwam dor dikero wo. ");
INSERT INTO bsj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dangjang dangjang nyi ceu wumom ri la biyen cero fiya cyer ka. cin tok ker la cin cak lang kwama. ");
INSERT INTO bsj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Taito bou dor nubo gwam wo yim Cunga cekeu. Kerowo yalati gwam mor biten kongni Yahuda. ");
INSERT INTO bsj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nubo gwam wo nuwa ri, yoken mor nere ce, tokti ki “La ye bwewo a yila tiye?” La kang Te luwe ko wi kange co. ");
INSERT INTO bsj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tece Zakariya diim ki yuwa tangbe ko wuccake la tok ker dukumer, ki ");
INSERT INTO bsj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Caklanka fiye Teluwe wiye, kwama Iciraila, cin bow naci ma tikali la cinma nob cebo nin cerka. ");
INSERT INTO bsj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Cin kung binek cume fuloka lo canga ce Dauda, ");
INSERT INTO bsj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(nawo ci tokki nyi nob tomange ceu kwattiye), ");
INSERT INTO bsj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","fuloka nob kiyeb beu kange nubo wo kwerbo nyeu. ");
INSERT INTO bsj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Can ma wuro naci nung, tebbe bo nin jire duwe ri la naci kwa nor cero wucak keu, ");
INSERT INTO bsj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","weri wo ci yii tebo Ibrahim. ");
INSERT INTO bsj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Cii weri naci nebo co kambo ci cokum bo kange nob kiyeb bekeri, nabi bwangci nenten kibi kwan neret ");
INSERT INTO bsj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mor wucakke kange cak-cake kabum cem ki kumetinibeu kale we nin gwam. ");
INSERT INTO bsj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O, kange mo, bwe, ciya co nen ki bwe tomange nii durre, la mwan yaken kabum tikobe Te-luwe ri na mwi ywel nure ceu, na mwi ywel nubo ki boka ceko ");
INSERT INTO bsj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na ne nob cebo nyom ka fulokak ki tab ka bwirank kerer cero. ");
INSERT INTO bsj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wo an bwi wori jire duwe kwama beu duwi kabo, wo kercer di filango ceru dii yeu atin bou na tikangbo, ");
INSERT INTO bsj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na ne filang ki nubo wo yim kumta cilenen kange kakulok bwareke. Ca tin ma wuro na bwangten ki nabe ko mor nure lima nereke ");
INSERT INTO bsj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","La bweu dwi la yilam ki bi kwan mor yuwa tangba, la ciki no mor yere na nyimde diye ci ter cerkako yanglang Iciraila. ");
INSERT INTO bsj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","La ki kumetini co, kaicar Augusta tung tomange cin toki ciki a kiyeu nubo gwam wo yim dor bitinereu. ");
INSERT INTO bsj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Won co kiye ka kaba maneu ki kwama wo kiriyuc ma liyar ti curiya. ");
INSERT INTO bsj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","La nubo gwam yarangen cinanlor cer naci mulangum ki kiye kakor. ");
INSERT INTO bsj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yucufu ken kwenu Galili wo mor cinanlor Nazaret la cin yaken Yahuza, cinanlor Dauda, wo cuoti Baitalomi, wori ciki no naniyak Dauda. ");
INSERT INTO bsj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cin yaken wi naci mulangum dercero kange Maryamu wo ci bob beu la ki fwer. ");
INSERT INTO bsj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","La kambo ci wi ye ri, kwama lam wo ci bom bwe tiye lam. ");
INSERT INTO bsj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cii bo bwe bibare, bwe kaba ce, la cin kwomum co ki yilang ko cuwe mer la yoken co mor tokum nennem wori ci man ki fiye wi. ");
INSERT INTO bsj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","La nob biyuwareb bo wi cungako co ci dami ner bitibere to bi cir cero ti ki kume. ");
INSERT INTO bsj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bwe tomange Te luweu cer cinen, la duktangka Te luwek ko tebum cunga ceko, la cin dim ki tai ducce. ");
INSERT INTO bsj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dila Bwe tomange kwama yici “Ko cuware tai, wori mi bo kumen ki kero ken wo a bou hi ki fuwor nerero dur nubo nin gwame. ");
INSERT INTO bsj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Duwen cin bo kimen nii fuloka mor cinan lor Dauda! Cin Kiritti Te luwe! ");
INSERT INTO bsj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wo co yirombo wo ci nekom tiye, kam fiya bweu kumon mor yilango cuwemer, yom mor tokum nennem. ");
INSERT INTO bsj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dangjang ri bwe tomange kwama kange mwer kamka dur ko dii kwa'ma caklang kwama ti ciki ");
INSERT INTO bsj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Duktanka ki kwama firen dii, rila fuwor nere a fiya tiber nubero co (Kwama) ciyacike. ");
INSERT INTO bsj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","La yilam kambo bi bei tomange kwama dubom ci yilaken dii lo kwamari, nob bi warebbo yi bwiti ci, “na weu ko biya Baitalami nabi to dikero wo bwiyeu, wo Teluwe nung bi neneu” ");
INSERT INTO bsj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","cin cu wulom-wulom wii dila cin fiya Maryamu, Yucufu kange bwe fiyerko dam mor tokume. ");
INSERT INTO bsj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kambo ci tom ceri, cin yi nubo dikero cii yi cii dor bwe fiyerko weu. ");
INSERT INTO bsj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Gwam wo nuwari, ma nyimanka dor dikero nob bi yuwarebbo yi ci yeu. ");
INSERT INTO bsj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dila Maryamu ki bulangi dor digero ci nuwa gwam, la cin yoken mor nerece. ");
INSERT INTO bsj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nob bi yuwarebo yilaken ci duktangi ri ci caklank kwama ti ki dikero gwam woci nuwau kange wo ci toweu dong-dong nawo ci yi ciyeu. ");
INSERT INTO bsj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kambo kume narube dimeri, fiyaco ci biye cinen lareu cin ne co dendo Yecu, dendo bwe tomange kwama ne na nyinde cii tu fwer cereu. ");
INSERT INTO bsj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kambo kumeni wucakeu ce cumeri, na wo mor wer fun mucaro, ciin bou ki co bikur waber mor Urucalima naci neken co kwama nin. ");
INSERT INTO bsj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nawo mulangum mor werfun Te luwe “Gwam bwe kabo wo bwayileri, atin cokum co ki dimen, cina kwama ce. ");
INSERT INTO bsj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","La cin ma wabka nawo ci toki mor werfun Te luwe re, “nagum fe yob kakaa kalti nawurmero yab” ");
INSERT INTO bsj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","La Nii kange wi Urucalima wu dencero cimon ne, ni wo cak cak laci ne dor bwanka kwama. Ciki ningtan nii a bii Iciraila nin neer tiye, la yuwa kange kwamak wi kange co. ");
INSERT INTO bsj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","La yuwa tangbe kwamako nungcine ki mani ci bwiyati ne citom Kiritti Teeluweri nyinde. ");
INSERT INTO bsj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","La yuwa tangbe kwamako ya ki co mor bi kur waber. Kambo Teb bwe fiyerko Yeco bou kice, naci macinen nawo werfundo nungeu, ");
INSERT INTO bsj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","cin tu beu kangcek ri cin caklang kwama, ciki, ");
INSERT INTO bsj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","na weu dob bwe canga meu akubo ki fuwor neret Teluwa nawo mori tokeu. ");
INSERT INTO bsj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","La nuwe mi tom fuloka mweko, ");
INSERT INTO bsj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wo mwi yweli nuwe nubo gwammer: ");
INSERT INTO bsj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","filang dukumek wo nubo kumta cili cee kange duktangka wo nubo lomwe Iciraila ce. ");
INSERT INTO bsj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tee ce kange nee ce ma nyimankka ki dike ci toki dorce reu. ");
INSERT INTO bsj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Cimon yocinen bibwiyer, ri yi Maryamu nece ki “Nuwa Yora, bwewo cin co ki na boki yare kange kwenka nubo duce Iciraila na yirome wo ci kowe ");
INSERT INTO bsj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kange kulen wo abiye ken mor nere mwetiye rila bi kwarum nerem bo kila atim ceruu”. ");
INSERT INTO bsj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nawiye tomange kwama ci cuo ti ki Anna wiwi. Cibi bwe Panuel naniya Acar. La cin duyom ki cotini duce, cin yi kange bwece coro kwini niber, ");
INSERT INTO bsj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","la cin nawi ye kwale coro kwini narub-cilombo na'ar. La mani ci dob mor bi kur wabe ri ci wab kwama ki ngak ngake kange dilo kume kange kakuk. ");
INSERT INTO bsj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ki kwama co dondong cin kwitau laidom kange ci, ri cin ter buka kau kwama, la cin yi nubo ningtang fuloka Urcalima kotiye ker dor bwero nin. ");
INSERT INTO bsj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kambo ci dim digero da ter cin matiye nawo mulangum mor werfun Teluwere di, cin yila keu Galili mor cinanlor ceer Nazaret. ");
INSERT INTO bsj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","La bwen duyom yilam kibi kwan, kange nyomka, la luma kwama wii cinen. ");
INSERT INTO bsj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ki cor teb ce bo ki yam nyo Urucalima ki duklume yabka. ");
INSERT INTO bsj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ki kwamawo ci dim coro kwabcilom bo yebeu, cin yaken tag duklumenin. ");
INSERT INTO bsj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","La kambo ci diim kumeni duklume gwame ri, cin ter yila kako loweu. La beu Yecu tim ce bwi mor Urucalima ri la teb cebo nyombo. ");
INSERT INTO bsj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ci kwotiri ciki no mor mwerka nube kowo ci yaken ti wari yeu. La cin ya yam kume wiine. Di cin ter doka ceko mor naniya cek kange farub cek. ");
INSERT INTO bsj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kambo ci fiya ceberi, cin yila ken mor Urucalima la cin ter doka ceko wi. ");
INSERT INTO bsj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La bwiko kume taare ri cin fiyamco mor bikur waber, yim tiber nob merangkab merangci ke tiniti. ");
INSERT INTO bsj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","La gwam wo nuwa ce ri, ma nyimangka ki nyomka ceko kange ciyaka ceko. ");
INSERT INTO bsj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kambo ci toceri, nyimankako tamci, la nee ce yico ki ““ye bwi mwa manyo nye? To, tee mwe kange mo nyi do nen ti ki kwomka duce.” Cin yici, “Ye bwi kom doye tiye? Ko nyombo kambo mamanangen mira?” ");
INSERT INTO bsj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Con yi ci, ye bwi kom do ye tiye? kom nyomba tam nyo ma nangen Temera? ");
INSERT INTO bsj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Di ci nyombo dike co yi ti kange kero co toke. ");
INSERT INTO bsj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","La cin yaken lo kange ci mor Nazaret la ci nee ci dur ti. Nee ce yoken diker buro gwam mor nere ce. ");
INSERT INTO bsj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dila Yecu ki duwi mor nyomka kange cuwemka la cin fiya cor cini kwama nin kange nob. ");
INSERT INTO bsj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mor coro kwob cilombo nung wo liyar Tibariyuc, la Bilatu Buntu bwangtentiki Yahuda, Hiridu co liya Galili, yice Filibu liya cungako Ituriya kange Tirakonitic, la Licaniyac liya Abiliya, ");
INSERT INTO bsj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ki kwama Annac kange kayafa nob wabe bo dur keu - ker kwamaro bou Yohana bibwe Zakariya nin mor yere. ");
INSERT INTO bsj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Cin ya mor bitenni gwam wo cunga caji Urdun ne. Ne fulen ker yika mwenge yilokati na fiya tab ka bwiran kerer. ");
INSERT INTO bsj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nawo mulangum mor bi fumer Icaya nii tomange dukumeu, “Diro wo cuo bicor timor yere ko ywelum nure Teluwe, kom tim ki nure ceu ciyer. ");
INSERT INTO bsj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bunglunge gwam atim dim, la bangtini gwam kange dukletini atin daken, nureni nyon langi nyeu atin tiken ciyer, fiye bweyang bweyangeu atim twilangum na yilam nure, ");
INSERT INTO bsj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","la nubo gwami auto fuloka kwama”. ");
INSERT INTO bsj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","La Yohanna ji nubo bouti cinen naci yu cinen mwembeu “Kom biwei fangeb! we yi com ki kom cuwa funer wo yautiye? ");
INSERT INTO bsj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nyori, kom ne bibeyo wo daten yilaka kumeke, la ko yire dor kimero kom ki “nyin wi tee nye Ibrahim”. La mi yi komti, kwama atin kung Ibrahim nin naniya teren ti wo nin. ");
INSERT INTO bsj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wo na weu, biliyeu yom niti tiyer. La tiyo wo nebo bi tuttiyeri atin tom na merken mor kire. ");
INSERT INTO bsj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dila nubo ti meka ceko “Ye nya matiye?” ");
INSERT INTO bsj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Cin ciya cinen ciki, “No kange kume wi ki belle yob ri, ca ti kangum kange nii womancike, wo ki cariyeri a mani nyo ken”. ");
INSERT INTO bsj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nob yoka doreb bou ken naci yu cinen mwembo, la cin yi co ki “Nii merangka, ye nyi matiye? ");
INSERT INTO bsj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ciin yi ci, “Ko yore kemero a cure dike ci yi kom ko yoweu” ");
INSERT INTO bsj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kangem nob kweneb me co ken ki “La nyeu? Ye nyi matiye?” Cin yi ci “Ko yore kemer nii nin kibi kwam ri, ko mwelde nii nin ker ki cuwerke. Ko bulang ki kemer cuwakek kumeko ");
INSERT INTO bsj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","La kambo nubo ningtang bo ka Kiritti tiye ri gwam ce ki kwai mor nere ce dor Yohanna keno co Kritti ri. ");
INSERT INTO bsj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohanna ciya cinen gwam, “Miu, miki yu kumen bwembo ki mwem la kange wi ber wo laye bikwaner, ma labo wo ma kiwi duka ta ceko tiyeu. Ca yu kumen mwembo ki yuwa tangbe kwama kange kira. ");
INSERT INTO bsj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kwel yuka ceko kino kang cek na nyinangum tene ceu na mwerken bikate mor bini. La ca tin twim fwirito ki kirako man ki domka”. ");
INSERT INTO bsj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ki weranka duce tak, Yohanna yi nubo fulen kerero ken ti. ");
INSERT INTO bsj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kambo ci werank Hiru liya ki naka wi yi ceko Hirudiya, kange dikero bwiir tini kangem bo Hiridu maneu. ");
INSERT INTO bsj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cin cob ten ki buro gwam, ri cin kum Yohanna fucina. ");
INSERT INTO bsj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","La kambo nubo gwam yum mwem beri, cin yu Yecu nin mwembo ken. La ki kwama ci kwob dilo tiyeri dii kwama wumom, ");
INSERT INTO bsj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dila yuwa tangbe kwamako yirau cinen na nagumfe, la diro ceru dii kwama “Mwi bwe nere mii, mi nuwa luma mwek ti? ");
INSERT INTO bsj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ki kwamawo Yecu ter nangen cere, can lam coro kwini ta'ar. Cir bi bwe (nawoci kwabi bereu) Yucufu, bi bwe Heli, ");
INSERT INTO bsj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","bi bwe matat, bi bwe Lewi, bi bwe Malaki bi bwe Yanna bi bwe Yucufu. ");
INSERT INTO bsj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yucufu bi bwe Mattatiya, bibwe Amoc, bi bwe Nahum, bi bwe Idacli, bibwe Najjaya, ");
INSERT INTO bsj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","bibwe Ma'ata, bibwe Mattatiya, bibwe Climeya bibwe Yoceku, yo ceku bibwe Yoda ");
INSERT INTO bsj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda bibwe Yowana, bibwe Reca bibwe Zerubbila bibwe Ciyeltiyele, bibwe Niri ");
INSERT INTO bsj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","bibwe Malki, bibwe Addi, bibwe Kocama, bibwe Almadama, bibwe Er, ");
INSERT INTO bsj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","bibwe Yoci, bibwe Aliyeza bibwe Yorima, bibwe Matat, bibwe Lawi, ");
INSERT INTO bsj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","bibwe Caminu, bibwe Yahuda, bibwe Yucufu, bibwe Yohanna, bibwe Aliyakima, ");
INSERT INTO bsj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","bibwe Malaya, bibwe Mainana, bibwe Matata, bibwe Natan, bibwe Dauda, ");
INSERT INTO bsj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","bibwe Yesse, bibwe Obida, bibwe Calmon, bibwe Nacon. ");
INSERT INTO bsj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","bibwe Amminadab, bibwe Adimi, bibwe Arama, bibwe Hezruna, bibwe Feresa, bibwe Yahuda, ");
INSERT INTO bsj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","bibwe Yakubu, bibwe Icaku, bibwe Ibrahim, bibwe Tera, bibwe Nahor, ");
INSERT INTO bsj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","bibwe Cerug, bibwe Reyu, bibwe Feleg, bibwe Abiru, bibwe Cela. ");
INSERT INTO bsj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","bibwe Kainana, bibwe Arfakcada, bibwe Cem, bibwe Nuhu, bibwe Lamek, ");
INSERT INTO bsj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","bibwe Methucela, bibwe Anuhu, bibwe Yaret, bibwe Mahalel, bibwe Kainana, ");
INSERT INTO bsj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","bibwe Enoc, bibwe Citu, bibwe Adamu, bibwe Kwama. ");
INSERT INTO bsj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","La Yeecu dim ki Yuwa tangbe kwama, yilam firen caji Urdun la yuwa tangbe kwama ko tu co yakanciko yerak. ");
INSERT INTO bsj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Fiye kume kwini na'ar bwekelkele cuwaco tiyeu. co ca diker ki kumeni co, la ni connuwa wura. ");
INSERT INTO bsj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bwekelkel yii, na mo bibwe kwamri yii tero wo a yilam cari, ");
INSERT INTO bsj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeecu yii co, mulangum mulange “ke bo ka cari ni ama dumetiye”. ");
INSERT INTO bsj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","La bwekelkele kung ken Yeecu dii nung cinen liyaro kaleweu gwam. ");
INSERT INTO bsj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bwekelkele yii co, “man neken nen Bikwankero gwam kange duktanka ceko, wori cin neyen dike buri gwam, la man weken nii wo ma cuitiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na ceu na mwan cung cunge mo wab yeri gwam ka mwe”. ");
INSERT INTO bsj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","La Yeecu karci nen yiico, mulangum mulange mwa wab “Teluwe kwama mwe, co ki kwace mwa- Bwangtentiye”. ");
INSERT INTO bsj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","So bwekelkele yakan ki Yeecu Urucalima, kung ken co diiku'u wabe la yii co na mo bi bwe kwama di yarubitine ");
INSERT INTO bsj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","wori mulangum mulange, can ne be bei tomange wucakke cenin dor mwer bou na cer nen. ");
INSERT INTO bsj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","La ci an kungum nen dii na mo fwere biwure, tero nin. ");
INSERT INTO bsj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","La Yeecu yii co, “tokum toke, mani mwa cuwa Teluwe mwe kwama ti”. ");
INSERT INTO bsj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","La kambo bwekelkele dim cuwa Yeecu keri, concu dubomco biduwar bwiri. ");
INSERT INTO bsj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","La Yeecu yilaken Galili ki kwan yuwa tangber kwamari. La fulen dor ce reu curongi cinanloro kentangum wiye. ");
INSERT INTO bsj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","La can yoten merengkako bi kur waber, La gwam caklang co ti. ");
INSERT INTO bsj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","La con bou Nazaret fiye ci yom co wiyeu la kambo ci lerum maka, con doken mor bi kur waber kakuk folokak, la kwen con titiye na kiye kiye ka ki dir. ");
INSERT INTO bsj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Cinne co bifumer Nii Dukume kaya, la con fiye wo mulangi, ");
INSERT INTO bsj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yuna tangber kwamaka wi dor miri wou cin cor meu timuwang dor na ne fulen kerero ken fiye nob bwen wiyeu. con tuom ye nan kwa dir fiye nubo ci tabangtabangeu, kange nee ka tokak fukmatinimbonin na kwin nubo ci neten dotange tiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nan kwa dir cor cini kwamar ");
INSERT INTO bsj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","La con cumom bifumer ne riwo timwiyeu. La con yii ken, nuwe nubo gwam bi kur wabero rime ki tokanco. ");
INSERT INTO bsj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","La con yoten kan co yii ci keroti duwen bifumer wo dim fo ki nuwaka kumek. ");
INSERT INTO bsj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nubo gwamwi tok kero ken dor cer la citi Nyumangi kange luma kereko ceru ti Nyiceu. La cin me”wo kebo bi bwe Yucufu ka?” ");
INSERT INTO bsj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","La con yii ci, “Bicom kam yii dangke wo kom ki Nii Twaka Twam dor mwero. Dikewo ma duwa ma ma kafarnam meu, ma dong=dong nyo cinan lormwer. ");
INSERT INTO bsj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","La con toki Bicom ma yii komti, nii Dukume kange win wo fiyom bo yoka we cinan lor cer. ");
INSERT INTO bsj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","La mor bilenker ma yii komti, natub kwalebo kila kabo mer Icraila, tiberoco Iliya wiyeu, la biloro mungum na coro ta'areceu kange cuiyakko mukkun, la wura dor bou bitine corin. ");
INSERT INTO bsj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","La ci tun bo Iliya win ciye nin. La tunco Jerefat cidone, nawiye kwale kange yimwiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Walebo kala kabo mor Icraila kwama Ilica nii dukumeu, win wo ci twabo, kan Na'aman wo ciria. ");
INSERT INTO bsj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nubo gwam mor bikur wabereu funero tamci kambo cinuwa kero weri. ");
INSERT INTO bsj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Cin kweri cin cokken co buiko cinan lore ci ya ken kico kong cueli wo ci mum cinan lor ciro dor cereu na ci tungu co bitine. ");
INSERT INTO bsj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","La ca ci cum tiber ciyer co yaken kange fiye. ");
INSERT INTO bsj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","La con yiraken kafarram cinan loro kange mor Galili, la con yoten kange co merang cinenti ki kakuk fobkak. ");
INSERT INTO bsj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Cin ma nyumanka ki merankaceko, wori co ki tok kero ki Bikwanked. ");
INSERT INTO bsj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","La mor bi ker waber nii kange wi wo ki yuwa kelkelike, la con cii ki dira dur. ");
INSERT INTO bsj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","E' ye nya mam ti ki mo Yeecu Banajara, mo bou na mo twalangum ne? min nyumom mo co nii wucak kwama ce. ");
INSERT INTO bsj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeecu ca kelkeliyomin tor, yii, tok re ker, ceru mor nii wo. kambo kelkeliyo jwa nii wo mer ken bitine tiber ciyer la ce rum mor nii wo, nuwa cinen bo tura ki kange nure. ");
INSERT INTO bsj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nubo gwam ti nyumangi, citi tokkami buiti ciye lan ker ye na wo? Co yii kelkeliyo kero ki nyial kange bi kwankered lan cerum. ");
INSERT INTO bsj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","La nyou, cin ter tokka fulen cero cinan loro kantangum wiye gwam. ");
INSERT INTO bsj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","La Yeecu dubom bikur waber ro doken lo cimonne, la fer cimon kalati ki kwirom bwi, la ci ken keri dor cer. ");
INSERT INTO bsj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","La kwen con titye dor cer, co ca kwirum bwi min tor, kwirum buiyo dubomco, dandang con kwemim con ta maka yiroko. ");
INSERT INTO bsj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kambo kakuko yar ken tiye ni, rubo bou cinenti kirubo nuwa bo luman tuirako ki dimen ki dimen, con yo ti kang ceko dor ciyer gwam con twam ci. ");
INSERT INTO bsj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kelkelibo cerangu mor nubo kila kila ken. Cii wiyeti ci ti toki, “mo bi bwe kwama,” Yeecu ca kelkelibo ca dob ci bo tok ker, wori cin nyumem con co Kritti. ");
INSERT INTO bsj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kambo fini celumen con cokum dor ce ki kwace fiye nob mani yeu, nubo ducce docoti co lo ci bou fiye co wiye, cin mani na ci kicim na dob cire. ");
INSERT INTO bsj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","La con yii ci man nee fulen kerer liyar kwamaro tangrim cinan Lorenbo. Won co dike bwi ci tumum ye fe. ");
INSERT INTO bsj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","La con ter neka fuleneko mor bi kur wabero Yuhudiya gwam. ");
INSERT INTO bsj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","La yilam kambo nubo mwerum fiye Yeecu wiyeri ci nuwa ker kwamaro, la co tim kang catiyo Janisarat deu. ");
INSERT INTO bsj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Con to na bire mwenge yo tirangum wi kong caji nin, nubo ta'a jinge cerangum morece nir biliyar ciyer ti. ");
INSERT INTO bsj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeecu kwiken mor Nabire mwengek ro win wuro ki cimonreu, la con yii co a kutaka ten ki nabira mwenge bi dob mor mwenge. La con yii ken mor nabire mwengek ronin, la co merang nubo ninti. ");
INSERT INTO bsj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kambo co dim kere di, con yi cimon, kob babire mwenge yaken ciko fiye cuwa cuwau, na mer ken biliyar mwero na taka jinge koce. ");
INSERT INTO bsj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Cimon yii co “Teluwe, nyo ma nangen kume del nyo taba kange diker wi. La ki ker mwero mamer ken biyaro mor. ");
INSERT INTO bsj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kambo ci maweri, ci ta jinge ducce la biliyar ciyero ti biyetangi. ");
INSERT INTO bsj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Coci ken farub nangeneb ci bo buro nabire mwenge wineu bo na tikanci, cin bou cin dirongum nalire mwengeu ciro yabcite, la cin teri kulkako. ");
INSERT INTO bsj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","La Bitru kambo to Yeecu ri, yarken bitine duwen yeelur la coki, kubom minen, wori min nii Bwiran ke “Teluwe”, ");
INSERT INTO bsj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","wori con nyumami, kange nubo buro kange ceu, ki kilaka jinge ko ci tabe. ");
INSERT INTO bsj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wuro mwerum kange Yakubu kange Yuwana bi beyo lo Jabadi farub nangeneb cimaneh. Yeecu yii ciman cuware tai, wori nawo kange kab mwa ta nob. ");
INSERT INTO bsj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kambo ci cokum nabire mor mwengecin yoken konge, cin dubom dikero gwam cin buangcinenten. ");
INSERT INTO bsj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kambo co ki no win mor cinan lonironineu, kange nii wi dim ki tuirak walek, kambo co to Yeecu ri con yar ken ki tikob ceb la conken co, tokti, “Teluwe” Namo ti ci ri mwantuamye cerum”. ");
INSERT INTO bsj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","La Yeecu ta'ar, kang ce ko keco toki mati cui, yilam wucak, dangjang waleu dubom co. ");
INSERT INTO bsj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","La con yi nii co a yi kange nii, la yii co, ya mure mwe, na nung dor mwero nii waber nin na ne tii kako ficang ngeu. Wo nir mwe ko ceu kambo muca tokeu, na warkero ce cinen. ");
INSERT INTO bsj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","La kero dor cereu yaken ten kutan, la nuba kila kilau bou wari cinen na ci nuwa co ti merangi na twam ten ci twirani ciyeu. ");
INSERT INTO bsj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","La mani co cerum ki kwace co yaken ki kob diloti ");
INSERT INTO bsj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yilam win mor kumeniwo co merangkatiyeu faricawa, kange nob merangka wer funer ci yiirongum wi buri ci bourangu muan loro Galili kange Yahudiya kange Urchalima gwam. Bekwan Teluwero wi kange co na co twam. ");
INSERT INTO bsj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","La nubo kange tu kilen do kange dor bilirir, la ci to nure wo ci a dokenti co moreu, na cin yoken co bitine kabum Yeecu. ");
INSERT INTO bsj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","La ci fiyabo nure ci a dor ti ke ceu wori nubo dim kabo, la cin kwiken dor lor la ci cuku co kibi cirico yirau ciko tiber nuber, dong-dong kaa Yeecu. ");
INSERT INTO bsj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","La co to bilenker ciyereri, Yeecu toki nii luwe, cutan mwen bwiran ker mwero wi. ");
INSERT INTO bsj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nob mulankabo kange faricawa ter meranka keko wo, we wo tok ker Dila karo wo tiye? we a cutan bwiran keti wi kebo kwama win di? ");
INSERT INTO bsj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","La Yeecu nyam dike ci kwatiyeu, kari yii ci, yebwi ka me wo ti neer kumere? ");
INSERT INTO bsj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Co wini bwai be na toke, bwiran ke mweu cutang mwenwi, kwen titi ye yayambo. ");
INSERT INTO bsj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","La na kom nyumom bi bwe “Nifire” we ki be kwan kere ro for dor bitininer na cutang biriran ker wi, con yii kilendo, man yii nen kwen, tu bicirimeu, na yaken lomo. ");
INSERT INTO bsj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dangjang ko co, co kweri ka bum ciyem la tubiciri ceu wo co dam dor cereu. La cu loco, duktankwama ti. ");
INSERT INTO bsj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nubo gwam wi ti Nyumangi, la ci duktang, kwama cin dim ki tai citi toki, loon to diker nyumankar. ");
INSERT INTO bsj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kambo dike buro ma nyeri, Yeecu cerum kateb con to ni yo der tiyeu dencero Levi yii ku'u yoka duwek, Lacon yii co bwang menten. ");
INSERT INTO bsj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Co Levi kwenti bwang cinen ten dubom tangnimdikerenbo gwam ");
INSERT INTO bsj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","La Levi co cika dur loco, la nob yo ka doreko wi kange tangnim nubembo, kentangum fiye caka carikeu ca carito ti kange ci. ");
INSERT INTO bsj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","La fariciwa kange nob mulangekab ciyebo wi fuen bibei tomange ceminti toki, ye bwi ko co ko no kange nob yoka duwek kange nob bwirang kere? ");
INSERT INTO bsj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeecu karci nen, Nubo buro kwamereu mani a do nii Twa ka ti kan co buro nuwa lumau? ");
INSERT INTO bsj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma buobo na nubo dong dongeu, lan nob bwiran kerek na ci yiloten. ");
INSERT INTO bsj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Cin yii co, bibei tomange Yuwana ki, yim, yim Ngak nyo, ki kuom dilo nyo la bi bei tomange faricawa ki manyo ken. La mweu bi bei tomange meu ti cai ti noi. ");
INSERT INTO bsj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeecu yiici, Nii kange wi wo adok farub bwa yilo na nawite na yii Ngakke, la bwayile na nawiyeu wi kange ci? ");
INSERT INTO bsj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","La kumeni wi bouti wo ci a tum bwayile ti cineneu, la ki kumeni co ci an yii Ngak. ");
INSERT INTO bsj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","La Yeecu yiten ci ker Nyuman kar, nii mani a wor fiti kulenti kulen do fuir na curum carko ciko na co ma nyori, can wobrangum kulendo fuir ko, fiti kulene fuir ko mani a datenti carko nin. ");
INSERT INTO bsj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","La ni kange mani wo a cor ten mwem inabim bo fuir ti mor kole care, naco mani nyo nyori, mwem inabim bo fuir ko an corum koltiye an wuroragum. ");
INSERT INTO bsj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","La tam a cor inabi fuir mor koltinon fuir. ");
INSERT INTO bsj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nii kange mani wo nuwa kum mwem inabim bofuir tiye, na kweri con nom car kori. La can toki carko la fuir ko ");
INSERT INTO bsj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","la ma nyo kakuk fobka ko kange, Yeecu yakenti mor to cang ko kange, kange bibei tomange ceu, ci kyang dor canger ti citi kui ");
INSERT INTO bsj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","la kangem mor faricawa tokiki, ye bwi ka ma dike yorbo ti a mani bi diye kukuk, ka kiye for ka? ");
INSERT INTO bsj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeecu kar cinen, toti, ka kiye ba dike Dauda mani kwama co co nuwa wuri ti co kange nubo wari kange ceu? ");
INSERT INTO bsj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ya mor luwe kwama, con tu cari to tanji laneu ca morece, con nabarubo wari kange ceu ciu cam, bwen no na mam kin nob wabereu ki kwaci cia ca ");
INSERT INTO bsj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","la con yii ci, bibwe nifire co teluwe kankuk fobka ko ");
INSERT INTO bsj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","kange bi diye kakuk fobka con doken mor bi kur waber la co meranmbo minti wi, nii kange wi wi wuro kance ko catiyero bwiyam-bwiya ");
INSERT INTO bsj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","nob mulangkabo kange faricawa to co tibi dor kero can twa nii ni kakuk fobkari na cin fiyan mure wo ci a tamco tiyeu, ");
INSERT INTO bsj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","la con nyumom dike ci kwa tiyeu la con yii nii wo kangko bwiyame kwen ti fo tiber nubero gwam la nii wo kweni titi wi. ");
INSERT INTO bsj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeecu me ci yori kebo bi diye kakuk fobka a dike yor yoreu, kaka a ma dike wo yorbeu a cok dume kaka a tual dume? ");
INSERT INTO bsj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","la con cto ci gwam la co yii nii wo yarken kangmweko, la con manyo, la kang cebo twam ");
INSERT INTO bsj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","la neer ciyero kayaragum, lacin tok kanti bwiti ciye dike ca ma Yeecu nin tiyeu ");
INSERT INTO bsj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","lan yilam mor kumeni wo con ceri con yaken bang ca kob dilo con ta kobka dilo kume del co ken kwama ti ");
INSERT INTO bsj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ki kakuk la con co bibei tomange ceu cinen la con cokum kwob cilom bo yobeu, wo co co cibitikali, ");
INSERT INTO bsj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","denti bi beitomange ceu co buro cimon wo co caten tak, Bitru  kange yii Andrawu, Yakubu, Yuwawana, Filibu, Bartalomi, ");
INSERT INTO bsj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Toma, Yakubu bibwe Afa, cimon wo ca co Jaloti ");
INSERT INTO bsj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yafuja, bi bwe Yakubu, kange Yafuja ckaryoti wo miye co tiyeu, ");
INSERT INTO bsj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","la Yeecu yirau dor banged kange ci laci tim fiye tuared deu, kange bi bwi tomange ce wila kange nubo kila wo borongu Yafudiya kange wurcalima kange nubo kong caji taya ");
INSERT INTO bsj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ci bou na ci buro wo nuwa co na co twam twirani ciyeu, nubo buro nuwa dotange ti ki yuwa kelkelikeu con twam ci ken. ");
INSERT INTO bsj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","nubo mwerkangum we gwameu dotina ci kem co wori bikwan twa ka ro ceru ti cinen, la con twan ci gwam. ");
INSERT INTO bsj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","la con to bi bei tomangeceu. con yii ci bibuyer kume kom wo nob bune beu la na kume liyar kwamaro ");
INSERT INTO bsj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","bi buyero an kume, kom wo konuwa wurati naweu, la ci an bwa kumen fuer bibuyer na kume, kom wo ko ci wiye tina weu, la kan nung nungi ");
INSERT INTO bsj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","bibuyero na kume to kom la ci ko denkumero na dikero bwir, ki ker bi bwe nir ");
INSERT INTO bsj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ko bilangi diye co ko yilam ki for neerer, wori kan fiya cuner dikwama nubo carem cim ma nob du kumebo nin nawo ");
INSERT INTO bsj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","la kwan nen mo nii mwa cuwe-cuweu, la mom yom mwe dangne mweu ");
INSERT INTO bsj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","kwan kom nubo wo fuero bwam bwabeu, kan ci wura for kob kwan kom wo ko nung nungi ti na weu, yii kan buwa kan ci wiye ki bui. ");
INSERT INTO bsj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","kwan kom na nubo tok ti ki wo dong dong di, nubo carem cimbo tok nyo nob dukumeb cwerkebo ");
INSERT INTO bsj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","la ma yii komti nubo ko nuwa ye tiyeu, cui nii bi dom kange mweu, na ma nubo konene nin dike ro ken ");
INSERT INTO bsj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yo nubo cilnen tiye nin bibuyer, na kob nubo buro culong nen ti dor bilenkereu ");
INSERT INTO bsj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","wo na kwanen ki kang tangal do wineri, neco wineu na kange tum belle mweri tamde mwe ");
INSERT INTO bsj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ne nuwa wuro meneneu gwam na kange tum dike kangen na mweri me core moki a bou mwen ciko ");
INSERT INTO bsj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","kambo mo cuilti nubo a ma mweneri, mo keneu ma ci nen nyo ");
INSERT INTO bsj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","na moki cuim ka co ka co nubo cuinen tiyeri, in jye yokka fiye mo wiye? bwen na nob bwirang kerer di cui nubo cui ci tiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","na moki mam dikero ken kan co nubo ma mwen dikero ken tiyeri ye yokka fiye weye? bwen no nob bwirang keri ki mam nyo ken ");
INSERT INTO bsj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","na wo ki ne cen kan nubo mo totiri an yam neneri, ye yokka munen? bwen no nob buiran kerer di ki nem nob bwiram kerero nyou na ci fiya dike ci ne dng-dong ");
INSERT INTO bsj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","la cui koneneu, na ma cinen dike dong-dong ngeu. ne ken kware kange diker yilau ti, la cuner, kumero na dur, kan yilam bi beyo lo nii dii ko na co con ni lomjome fiye nubo man ki buka kangek kange nubo bwirko ");
INSERT INTO bsj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","yilam ki cini na wo tee kume nii ciniu ");
INSERT INTO bsj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","kom mare buolang la mani a ma kumen buolang ti kom kuwa re mani a kuwa komti, tab kangem bo la mweu an tab mwen ");
INSERT INTO bsj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","kom ne la an ne kom kwele dimdiye, cuwam cuwa, ki bi funger ti con ci an cor kumer ti kan bellik ki kwele ka cuwameu a cuwa kumen ciko ");
INSERT INTO bsj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","la yila con yii ten ci dangke kange, con toki, fukma an ta fukma nin kangka? na co ma nyon, yaramken buwar gwam citi cimanin nyoka? ");
INSERT INTO bsj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","bwe tomange labo nii merang ka ceu dur la nubo gwam an yilam na nii merang kako na merang cinendi ");
INSERT INTO bsj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ye bwi mo toti ka be yere nuwa kemwe, lamwa tobo cuwemero wo nuwe mweu ");
INSERT INTO bsj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","mwa yii yimwe myi, moki yii mi tumwen be yere dam mor nuweu, lamoki bwi mwa tobo kukko cuwe mero dam mor nuwe mweu? kom nubo bwir, teri cokum batiye durko nuwe mweu na mo tom yora na mo cokum be yere nuwe yiim weu ");
INSERT INTO bsj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","la tiyo kendo kange mani wo tu bi tutiyo fuyem fuye tiye, kaka tiyo wo fuyemeu na ne betuti ken ");
INSERT INTO bsj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","wori tiyo moki nyomco kin bitutico tutiyeu la nubo mani we bituti nying cire ti cuiya ke kaka nubo inabi fiye cilange ");
INSERT INTO bsj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","nii ken mor dikero kendo dume ceu a bou dikero yor yoreu, nyou nii bwirko mor dikero bwirko mor neere ceu, a bou dikero bwir wori dikero bwirko ducce mor neere ceu co ci ceu toktiye ");
INSERT INTO bsj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ye bwikaco yeti kom ki, teluwe laka bwantenbo dike ma tok tiyeu? ");
INSERT INTO bsj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","nii wo na bou minen la nuwa ker mereu laco bwang tenen, man yii dii ke co cerkange ");
INSERT INTO bsj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","co ki no nan nii luwe tiye, woru wobken cuwa mor bitinen la co mu kwar loro ki terenti kwamer lana mwembo dur bouri la came mwegweu kwanan kwar kumeroti laluwe cuwo mani a muka ti wori mum co yora ");
INSERT INTO bsj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","la nii nuwa ker miro bwang ten beu no nan co nii wo mu luwe dor bitinereu man ki kwar ca na came mwem bo kwanan kwar kuro di la can can duwo an yarum, yarke luwe kowo ");
INSERT INTO bsj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","bwiko Yeecu dim dikero gwam ca yi nobo tiye cin do ken kafarnaum ");
INSERT INTO bsj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","fiya cuwo nii kwene durko nuwa diker dor Yeecu ri, contwom nobo dur yahudawa ro, a ken co na bou na twam canga ceu ");
INSERT INTO bsj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","la cin bou Yeecu nin cin ken co yi co ti ki “nii wo lam wo ma macinen wo tiye ");
INSERT INTO bsj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","wori ci cwi bitene nye ti co ca munyinen bi kur kwamaro urcalimau ");
INSERT INTO bsj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nyori Yeecu bwan cinen ten. la fiya cuwo ci dadom kange kuweri, nii kwene durko twom farub cebo a yi co, teluwe kwom de dor mwero, wori ma labo wo mwabouti lomiyeu ");
INSERT INTO bsj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","nyori ma tubo dor miro na nii wo lami mwa bouti cinen, tok ka ker koni, canga mi an kwam. ");
INSERT INTO bsj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","mo keneu, mi nii woki bi kwang kere dor nob kwenebo kang mikeu, nyi wo mi yari, co ya kange mi bouri, co bou, canga miu no ca ma wori can mani ");
INSERT INTO bsj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","la Yeecu nuwa wori, co nyiman nii wo, con yila nobo bwan cinententiye, con yii ci, “miyi komti, mor kiraila gwam, ma fiyobo nii ki bilen ke na weu. ");
INSERT INTO bsj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","fiya cuwo nobo ca twome a yilaure loweri, ci fiya canga wo twam ");
INSERT INTO bsj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","kutanbo bwiko cuwori ");
INSERT INTO bsj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yeecu yaken cinar loro kange ci cuwoti ki Naim, nob tomange cebo fiya nob ducce woya kange ceu ");
INSERT INTO bsj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","la ci bi dom kangenyilo cinar loreu di, cin ki nii kange wo bwiyam meu, cobwe wiin nece nin wuro nawiye kwale nubo ducce cinar loron wo kange co. ");
INSERT INTO bsj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yeecu to cori, cin bunang co cin yii co, “ciire wiye” ");
INSERT INTO bsj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","la conyaa con tei kwanni wo ci tuu bilen do cika nobo tum ki bilen nen tim cok con yico, bwe, mi kwenu” ");
INSERT INTO bsj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","bilen do kwenum, nyoten tok ka kereko, Yeecu neken co nece nin ");
INSERT INTO bsj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","la tai to tam ci gwam, cin yoten ci caklang kwama ti,” nii tomange kwama dur kwennu more nye kwama to nobo loceu ");
INSERT INTO bsj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","fulen kere wo dor Yeecu yalti bi ten yahudiya gwam kange buro bi dom kange ceu ");
INSERT INTO bsj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","bibei tomange yuwana yi co dike buro gwam ");
INSERT INTO bsj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","la yuwana cuwo bi bei tomange ce yob, tom ciYeecu nin ciya me co” mo nii bou tiye kakaa nyo nintang kane? ");
INSERT INTO bsj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","cin bo bidom Yeecu nin di cin toki, “yuwana nii yuu mwem tiye tom nyo munen ki nyi me, “mo wo bou tiye kakaa nyi nintang kange?” ");
INSERT INTO bsj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tabbo cin twabangum nubo ki twira kange wo ki yuwa kelkeleb beu, nobon fukmau, cin neci toka fiye.” ");
INSERT INTO bsj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","la Yeecu ciya cinen ki, kom ya ko yi yuwana, dike nuwa kime towe kange dike ka nuwa fukma tofiyeti kilendo ya yamti, walebbo cin twam, nubo mani nuwa tiye ti nuwai, nobo bwiyame kwennum, fuwabbo nuwa fulen keret ");
INSERT INTO bsj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","nii wo ne bilen keret dikero mi matiyeri nii bibwiyer, ");
INSERT INTO bsj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","bwiko bi bei tomange yuwana cuwe, Yeecu yici kerdor yuwana,”ye ka crr yera ka totiye? yerayuwana moktiye ka ");
INSERT INTO bsj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ye ka cer yera ka owe? nii ki kulendo twaba nyeu to, nubo ki kulenkyemereu, ci nuwa lima ti loni liyabe ");
INSERT INTO bsj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ye ka ya yera ka towe? nii tomange kwama ong mi yi komti la nii tomange ");
INSERT INTO bsj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","wuro co nii ci mulangi cer ki “to mi tom mweu ni tomange ti kaa mo wo a ywelmwen nuretiye ");
INSERT INTO bsj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","mi yi komti mor nubo natub bowe, mani na yuwana, nyori nii wo na bi duware mor liyar kwama reu laco ");
INSERT INTO bsj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","la nubo gwam, ki nob yuwana kyemerek nuwa nyori, cin ciya kwama nii wucake, wori cin yuu cinenen mwembo ki yuu mwemer yuwana ");
INSERT INTO bsj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","la fariciyawa kange nubo nyimom werfundeu cin dike kwama yo keb dor circu, nyori ci yuu cinen bo mwem yuwanam bo tiye? cinan ye? ");
INSERT INTO bsj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“kange ye ma mwer nubo kaldo wo canne tiye? cinanye? ");
INSERT INTO bsj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","cina bi bei malorti fiye miyeka dikereu, wo yim yiye la cuwo kange yi co ki,”min cuu lira mwa yelbo yila, min ka nuwe bware, mwa cibo wiye ");
INSERT INTO bsj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","nyo yuwana nii yuu mwem tiye bou mani cati, mani noti, ki wi ki ninga “ ");
INSERT INTO bsj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","bi bwe nifire bou, ti cai ti noi ri, kom ki kucunu kange nii no nyom tiye, farnob yuwana kyeme kange nii ki bwiran kere, ");
INSERT INTO bsj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","nyore yuleng bi beyo loce ki warke ");
INSERT INTO bsj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","na wori, wiin mor fariciyawa cuwo Yeecu na ci ca cari wari la bwiko Yeecu doken lon fariciyawari, cin yiken fiye caka carik, na cincam cartori, ");
INSERT INTO bsj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","nawiye kange wii cinar lor wo nii bwiran ke kambo cin nyimom Yeecu doken loh bwe fariciyawa ca kacarik di, cin bou ki nuwan alabata, kundo limi yeu ");
INSERT INTO bsj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","contibidom kange Yeecu fiye na ceko wiye co ci wiyeti, con yoten yibong na Yeecu ko ti ki mwem num cem, belti nuwang na cek ");
INSERT INTO bsj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","la fariciyawa wo cuwo Yeecu, to nyori, co ti kwabi ner cer ki, na nii wo bwe tomange ri no cikin nyimom we nawiye tiye nii bwiran ke' ");
INSERT INTO bsj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeecu yi co cmon min wi dike ma yi nen tiye, ciki toki nii meranka ");
INSERT INTO bsj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeecu ki nii neka cennek ne nubo yob cend, wiindinari kwini kwob nung, wiineu nung ");
INSERT INTO bsj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","la cin fwe ki yakako, cin dobcinen gwam nyori we more ciye co cwiti wo ducce? ");
INSERT INTO bsj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ciman ciya ki, “mi kwatiri nii wo co dob cin kyemero ducceu. Yeecu yico co ki munwarker dong-dong ");
INSERT INTO bsj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yeecu yila nawiye wonin yi ciman, mun to nuwiye wamin do lomo, mwe ne yebo mwem nirka nam, na wiye wo yibong namiko mwem num ceu, con ki yiri co ");
INSERT INTO bsj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","mwa ma membo ka cikko ma dou feu na wiye wo dobbo beitika na miko ");
INSERT INTO bsj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","mwa beltimen bo nuwandor, nawiye belti menti nuwan dor ");
INSERT INTO bsj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","nyori mi yinenti bwiran kece ducceu cutan wi, wori con nan cwikaducce nii wo cicutan bwiran kece bi duware ri, cwika ceko bi duwar ");
INSERT INTO bsj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","la con,” yi co, bwiran kemwe cin cutang wi ");
INSERT INTO bsj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","nubo ci yim wariyeu yotan tokkan kerek butici, we woro cutan bwiran ke tiye ");
INSERT INTO bsj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeecu yi nawiye wo, bilenke mwe coknen, ya ki nero fwor ");
INSERT INTO bsj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","la yilam nyo kambo Yeecu ter yam cembo cinar lor kange mwanti lore ki kang ki wang, tok fulen kereroti kange fulen liyar kwama kwob culombo yobeu wi kange co, ");
INSERT INTO bsj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kange natubo kange wo ca twam ci yuwako kwir kange twira kila-kila. maryamu wo ci cuwo ti ki makdaliya, wo ci cokten ninga nibereu, ");
INSERT INTO bsj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","kange yuwana wii kuza, nawiye tomange hiridu, cuzanatu, kange kangumbo kila nyeu, kin dike kang cike ci ma mangen ti cikr ");
INSERT INTO bsj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","la nubo ducce mwekangu ti, kange kangum nob bouti cinar lor-cinar lor reu, cin yii ci dangke, ");
INSERT INTO bsj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","nii fike kange ciri a fii dum la coti fii ri kangum bo yarken kong nure, cin fawarangum ki na, bilibeu diyeu yirau bon com. ");
INSERT INTO bsj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","kangumbo yar dor terenti, la kii ri kucom, dula mani ");
INSERT INTO bsj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","kangumbo yarken mor cwiyaka la cwiyak kii kange dumbo ri, cwiyakko cakkangum co ");
INSERT INTO bsj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","la kangumbo yar bitine kenneu ma ken, wo lam kiriti kwini kwobbe. bwiko Yeecu dim tokka kere keu, cuwo ci, “ki tu nuwaka kere, ca nuwa ");
INSERT INTO bsj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","bi bei tomange ce meco dang kewo nuntiye con yici, la kangum bo ciye me yici ki dangka, nyori ci ti toi maci toti citi nuwai ma ci nyomti ");
INSERT INTO bsj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","con yici, nyomka yurke liyar kwamar cin nekom, la kangum bo ciye ma yi ci ki dangka, nyomti ");
INSERT INTO bsj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","dike dangka nuntiyeu co wo, dumbo ker kwamar ");
INSERT INTO bsj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","buro yar nureu, wori nuwa ri bwekelkele bou yuwom kero ner cireu, nyo na ci nere bilenke naci fiya fuloka ");
INSERT INTO bsj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","buro yar do terentiyeu, co buro no ci nuwa kero dici yuwo ki nero for, la ci man ki niti, cin ne bilenke, kutan bori, cuwakako bou ri ci yarum. ");
INSERT INTO bsj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","dumbo wo yar mor cwiyakeu, ci nobo wo nuwa ri, la ci yakenti ri, cwika kalek, kyemer kange nuwaka lima ca kkangum ci la ci mabo ken ");
INSERT INTO bsj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","woro dor bitinero keneu, ci buro ki bilnka kange nero kenne, tam yoran, ma dikero ken mor birum nere. ");
INSERT INTO bsj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","nii mani a kwer kirati na cumom, kakaa yoken bok kwannik, ca yo codor diker, na nobo doutiye to kirako ");
INSERT INTO bsj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","mani dikero yurangum yurange mani a nyomtiye, kakaa yurke kange wii wo ba nyombe a bou ti kira ");
INSERT INTO bsj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","nyori nuwa, yora, nii wo ki diker ducceu ri an yok cinen ten woro man cikeu, bi duwar ci cikeu an yuwom cinen. ");
INSERT INTO bsj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","la nece kange yitub ceb bou, cinen, la ma ciya fiya nure lakati cinen, wori nubo ducce ");
INSERT INTO bsj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","cin yi co, nemwe kange yitub mwem tim kale, cwiti na ci tonen” ");
INSERT INTO bsj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeecu ciya ci yi ci, nemi kange yitub mib co nobo wuro nuwa ker kwama di ma namgen cike. ");
INSERT INTO bsj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","bi con doken mor nabire mweme kange be bei tomange ce, con ci,”bi yabken dinge wure no cin yoten yambo, ");
INSERT INTO bsj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","la ciyakentiri, co dam dum yuwa kibi kwama kwennuncayi, mwembo yoten dim na bire mwenge ciyeuti, ciki no nyi kware. ");
INSERT INTO bsj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","la bi bei tomange Yeecu bou cinen cin yunco, ciki “teluwe, nyo nyi bware con kweni, yuwako kange mwelanka mwemek ko, wori cin tim ");
INSERT INTO bsj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","la con yi ci ki fe ke kimeu? cin nuwa tai ci myimam dike woti ci me buti citi we nii wuro werang yuwati kange mwembo ki nyial neco dure? ");
INSERT INTO bsj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","la cin yaken Garacinawa wo kino dinge caji Galili ");
INSERT INTO bsj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","fiya cuwo Yeecu doken bitene, cowari, con wabkan nii kange cerum cinar loreu ki ninga kwutangi cinen la wormangum kulen cero. mani dã lo ki dã tiber tuwetini ");
INSERT INTO bsj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","la con Yeecu ri con kwa dir yarkan ka Yeecu, cin tok ker kwang ka, ki mo Yeecu bi bwe kwama nii duktonka, mi kennenti neyere dotange ");
INSERT INTO bsj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","wori Yeecu cokkan yuwakeliko ki nyial nii cuwo nin kiritti ducce ki ta core bwentano cin bwam cori cin yoti nii atocotiri, kiyangum diker bwakaro, ningau ywa co yaken ciko yera ");
INSERT INTO bsj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","la Yeecu me co, “we den mwero? ki dencero muri, wori kelkelibo ducce do bwiciye ");
INSERT INTO bsj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ci ken Yeecu ti a ywa cire ki nyial mor buwoke ");
INSERT INTO bsj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","na wen, ngiyere ducce ca cariti fir banger ninga buro ken co ca dob ci ciya doken bwi ceru la cin ne ci nure ");
INSERT INTO bsj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","nyori ninga buro ceru bwi nii wuro doranken bwi ngiyere tini cin cwakkangi yaranken mor mweme cin bwiyarangum ");
INSERT INTO bsj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","la nubo to ngiyere buro tiye, dike wo mane ri, cin cwakkan ken mor cinar lor cin yi nubo dikewo bwiyeu ");
INSERT INTO bsj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","la nubo cecu naci to dikero maneu, cin bou Yeecu nin, cin fiya nii wo cokten ningau yim bi dom na Yeecu, dumki kulen, wo kwamer tak. lacin cwa tai ");
INSERT INTO bsj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","la nubo to dikero maneu, yi dike maneu, yuwa kelkelibo wo cerum bwi nii we ");
INSERT INTO bsj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","la nubo gwam biten Garacinawau yi Yeecu a dobom bitine ciyeu wori taito dur tamci nyori cin doken nabire mwenge naci yilaken bwi. ");
INSERT INTO bsj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","nii woci cokten ningau ken Yeecu na cin ya wari, la Yeecu yi co, ");
INSERT INTO bsj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","yilaken lo na yii nubo dike kwama ma cineneu nii woro kentangum cinar loro gwam, tok dike Yeecu ma cinenu ");
INSERT INTO bsj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","na weu Yeecu yilaken neu nubo duccu nawo yuwoce, no ci nintang coti ");
INSERT INTO bsj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","la nikange wi dendo ki Yariyu, ciki no mor nubo durer kwamaro Urcalima, bou bidom kange Yeecu cungen naa Yeecu, con ken co ca ya loco, ");
INSERT INTO bsj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wori, bi bwece bwebubya, coro kwob culombo yob, kan co wiin cineneu ki no nyi kware laYeecu yaken tiri nubo ducce tunkanti bwiti ciye kentangum co ");
INSERT INTO bsj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","la nawiye kange wo cor gwam dike ci cikeu bwiyale ti coro kwob culomo yobe, twalum gwam dike ci cikeu, co fiyabo twaka nii kange nin ");
INSERT INTO bsj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","co bou bwi Yeecu con tei nyii belliceu, wii dancan kwiyele ceu tim. ");
INSERT INTO bsj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","la Yeecu yiki we kece? la nii wo ciya cinen wii more ciye gwam di, bituru yi co, nii merangka, nubo duccu kantangum mo, tunkanti bwimi ");
INSERT INTO bsj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yeecu yi co “kange nii ke ye, min yimom, bikwan ceri minen. ");
INSERT INTO bsj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","na wiye wo to nyo ma ca fiye cerka ti ri con bou fiye Yeecu wiye, cungi kaco, nuwe nube gwan, con tok ca fiya dikero gwam wo dok co ca ke ce, la nyoro, ca kfiya twaka ");
INSERT INTO bsj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","la con yi co, “bwe, bilenke mwam nen, yaa ki for nerek ");
INSERT INTO bsj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","con wi co tok ker ti duwal di kange bou bi kur kwama nubo dure, ki bi bwe mwe bwiyam, ki nere ni meranka dotange tak ");
INSERT INTO bsj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeecu nuwa wori, con ciya yariyu nin nuwari tai neka bilenke, bi bwemwe atwam ");
INSERT INTO bsj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","la ca ya luwe cori ca dobbo nii a do mor kange co kange Bitru kange Yuwana kange Yakubu te kange ne bweu ");
INSERT INTO bsj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","nubo wiye ci ti wori bweu bwiyami la con yi ci kom cire wiye co bwiyabo, ki dadum ");
INSERT INTO bsj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","la cin mung co, wori cin nyimom bwiyam ");
INSERT INTO bsj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","co tu bwe kang cer, cin cuwo ki bi kwang bwenu yi ci ciya fiya cinen dike ca catiye ");
INSERT INTO bsj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","dume ce yilaken, dancan con kwenu con yi ci ciya fiya cinen dike ca catiye ");
INSERT INTO bsj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","teekange nece nyimangi, con yici ciya yi re nii dike wo maneu. ");
INSERT INTO bsj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","con cuwo bi bei tomange ce kwob culombo yob, neci bikwang kange bikwang keret naci cokum ningga gwam, ci twam tiratini ");
INSERT INTO bsj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","con twom ci kele na ci tok fulen keret liyar kwamaro, naci twam nubo nuwabo liman ");
INSERT INTO bsj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","con yi ci kom ture diker yam kimembo nin dang mani cwaye mani, cari mani, kyemer mani tak ko ture diker kwabkar yob ");
INSERT INTO bsj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","luwe wo ka dowe ri, ko yi wii yaken ciko diye ka dubom tiye ");
INSERT INTO bsj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","fiye ci yuwo kom be ri no ka dob ninar loro cuwo tiri ko bum kwero na kime keu warke dor cir ");
INSERT INTO bsj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","nyori cin kweni, ci bwanten cung-nukur, cunkur ci tok fulen kerero ti, twa nob ti fiye gwam ");
INSERT INTO bsj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","la Hiridus liyau nuwa dike ydken tiye ri, ma nyimantum, wori kangum bo tiki kin Yuwana kwenu bware ");
INSERT INTO bsj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","kangum bo ki Iliya cerkangu we, kangum tak ki wiin more nob tomangeb bo fiya cuwo kutaneu kwenuwe ");
INSERT INTO bsj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hiridu ki, min mwatum dor Yuwanaro, we wori mi nuwa dikero woti dor cere? nyori con do nure ca to co tiye ");
INSERT INTO bsj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","la be bei tomange Yeecu yilauri, cin co dikero gwam ci maneu la con cin yaken yurangum, yurange cinar loro ci cuwo tiki Batsaidau ");
INSERT INTO bsj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","la nubo mwerumem nuwa dike wuro nyori cin bwangten co con yuwo ci, con ci diker dor liyar kwamare, com twam buro cwi twaka tiyeu ");
INSERT INTO bsj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","lakume dadom a bouti cwile, kwob culombo yobe bou cinen, cin yico,”yi noboro ci yaken mwan loro buro mor tangini naci fiya fiye dame kange cari nyori fiye biwiye nob mani ");
INSERT INTO bsj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","la con yi ci, “ko neci dike ciya ca tiye. ciki, be dike nyo cikeu cwen carito nug kange jinge yob ma nya fiye carito wo a lam nubo wuro ti gwame ");
INSERT INTO bsj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","nubo lam bikate nung ka nabarub con yi bi bei tomange ceu ki yi nubo a yiken ki mwam, kimwam nubo kwini nung, kwini nung ");
INSERT INTO bsj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","nyori cin mani nyo, yo nubo yiken yiye ");
INSERT INTO bsj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","co n tu cwen tiyero nungeu nunge jinge yobe, cin kunken nuwe ce di kwama, yo cin nenti bi bwiyer wi con wulangum ka bi duwartini con ne bi bei tomange ceu naci tikange nubo mwerume nin ");
INSERT INTO bsj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","cin ca gwam ciye cin bwam, tanne ceu numeu, cin yee bulendo kwob culombo yob ");
INSERT INTO bsj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","la kakuko kange Yeecu kwob diloti ki kwace, bi bei tomange ce wi cinen con me ci ki nubo wuro mweru meu ki yii ki min wee? ");
INSERT INTO bsj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","cin ciya co yuwana nii yuu mwem tiye, kangumbo ki Iliya, la kanugumbo ki kange wiin mor nob tomangebo nanduwe ");
INSERT INTO bsj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","con me ci la kime kom ki yi ki min wee? Bitru ciya cinen kiritti bi bwe kwama ");
INSERT INTO bsj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","cin werang ci ciya tok re wo nikange nin ");
INSERT INTO bsj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","yi citi bi bwe nifire an nuwa dotange dike ducce, ko co, ci an twalum co, ki bi kume taare an kwenum ");
INSERT INTO bsj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","con yi ci gwam, nii wo cwiti na bwanten yereu, an ko dor cero, can tun bentilen bwantiyer ki cero, ki ca kicatecca bwan teng ");
INSERT INTO bsj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ni wo cwiti na ci fiya dume ce ri an lem dume ce, wo lem dume ce ki 25ker mire ri an fiya dume ceu ");
INSERT INTO bsj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","yee nii a fiya tiye no ci fiyam kale wo gwam la co lem dume ceri ");
INSERT INTO bsj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","wo no nuwa kwenduwe mi kange ker mirro ri, bi bwe nifire an nuwa kwenduwe ce ken diye bi bwe nifire a bou ti mor dukfongka ce, duktongka tee, kange yuwa tangbe kwama wucake ");
INSERT INTO bsj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","mi yikom bilen ke ti, kangembo wii tirangum fo, wo mani a twi bwer tiye nimre ci to liyar kwamaro ");
INSERT INTO bsj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ki kume narub Yeecu tok kero bure ri, cin tuu Bitru, kange Yuwana kange Yakubu, cin kukendor banger na ci kwobdilo ");
INSERT INTO bsj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","la ci mor kwobka dilo ri, tikob ce bo fulongum, kulen cere yilam fwoje ti milbangi ");
INSERT INTO bsj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","nyori, nubo kange yob tokkang ker ti kange co, muca kange Iliya, ");
INSERT INTO bsj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wo cerkengu ki duktonka, tokkan ker kiboka cer ti wom dadom a bou ti cwile urcalima ");
INSERT INTO bsj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitru kange buro kange ceu nuwe ciye tuu ki dum, la cin kweni ri, ci to duktonka kange nobo yob tim kange co ");
INSERT INTO bsj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","fiya cuwo ci dob Yeecu ci yakentiri, Bitru yi co teluwe yor nyinen nyi feu, bi ywel bikur taar, wiin ki mo wiin ki muca, wiin ki Iliya co nyombo dike co tok tiye  ");
INSERT INTO bsj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","la co tok kero ti nyori, bi loro yirau cumom ci, cin nuwa tai kambo bilora kantangum ciyeu. ");
INSERT INTO bsj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","diro kange ceru mor bilore nin ti toki ki, wo bi kwemi ma cikeu, ko nuwa co ");
INSERT INTO bsj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","fiya cuwo diro dim tokka kere keu, Yeecu tim ki kwace la cin kumom ci yi bo nii mor kumeni curo dike ci towe ");
INSERT INTO bsj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","cel fini ri cin yirau dor banger, nobo duccu bou cinen ");
INSERT INTO bsj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","wori nikange mor nibe nin cuwo co ki diri, nii merangka, mi cwiti na to be bweme kange co bweu mi cike ");
INSERT INTO bsj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","yuwa tangbe bwir doken bwici, co ki kwa kang kiyange, mok co ti kibi kwang, funi fwiuti nyii co, bwai na dob co, nuwaran cinen twira ti bwira-bwira ");
INSERT INTO bsj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","min ken be bei tomange na cokum, cin fwe ciko ");
INSERT INTO bsj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","kom kaldo woka tiyangum nure, kom man ki bilen kereu, fiyan ma yiti kange kome, mi mwirimum ner ti kange kome? bou kibi bwe mwe fo ");
INSERT INTO bsj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","la bwe bou boutiri ninga kwa co merken bitine, mor coti kibi kwang Yeecu werang yuwa tangbe ko wo, con twam bweu yila cin neken tece ");
INSERT INTO bsj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","nubo nyimang bi kwan kwamaro laci tokkanti butici dikero gwamco matiye, con yi bi bei tomange ceu, ");
INSERT INTO bsj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","kom dor kero wo a yiraken tuu komi ciyang miyem bi bwe nifire kang nubek ");
INSERT INTO bsj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","la ci nyombo dike co tokeu, yurangum, yurage cinen, laci nyombo dike nuntiye, ci cwa tai ti na ci me co kerowo ");
INSERT INTO bsj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","kwobokanka do tiber ciyer ki kerowo kin we a yila nii dur tiye. ");
INSERT INTO bsj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeecu nyimom dike ci kwati ner cireu, tuub bwe bi duware bi dom kange co. ");
INSERT INTO bsj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","la con yi ci, niwo yuwo bwe bi duware ki den mire ri, yuwo mo, na wo yuwo yere yi, yuwo niwo tomu yereu nii wo bi duwar more kume gwamme co durko ");
INSERT INTO bsj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuwana ciya co, teluwe, nyon to nikange cok ninga ti ki den mwer, co nya ywace wori bwang nyinen ten bo. ");
INSERT INTO bsj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeecu yi ki, ko ywa core, wori nii wo ciya kombe na kume ");
INSERT INTO bsj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","la kumeni kum bi duwar wo ci yilaken diye, con yoken ner yamer urcalima ");
INSERT INTO bsj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","con twom bi bei tomange na yaken ten cinnen, cin ya cin doken mwan lor camariyar na ci ywel cinen fiye firen ");
INSERT INTO bsj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","nii bo wiye yuwo cobo wori ciki yang urcalima ");
INSERT INTO bsj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","la bi bei tomange ceu Yakub kange Yuwana to nyori yi ki, “teluwe muki cwi nyo dor kirako a yirau di kwama na twim ci ka? ");
INSERT INTO bsj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","con yila con werang ci, ");
INSERT INTO bsj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","la ci yaken mwam luwero kange ");
INSERT INTO bsj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ci mor yamme dor nuret, kange. yii co, “mwan bwang mwen ten fiye mo yaken ti wii ye ");
INSERT INTO bsj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeecu yi co, “bi cwe kiye wiki buokti, bi libe di kwama wii ki loci, la bi bwe nifire man ki fiye ca nyom dor tiye ");
INSERT INTO bsj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","la cin yui kange, “bwangmen ten, la con yi co ki, “teluwe dob ye yan fwerum temi buri” ");
INSERT INTO bsj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","cin yi co, dob bilendo cika fwerum bilen ciyer mweu ya kutan kange fiye kwiya kye na tok fulen liyar kwama. ");
INSERT INTO bsj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","dila kange yi ki man bwanten nen kwama dila dob ye yan nem nubo lomembo nanme” ");
INSERT INTO bsj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeecu yi co, ni kange mani a yoton kanti cinonri la yi la yila nuwe bwiye daten bo lokwama. ");
INSERT INTO bsj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bwika dike wuro Yeecu cok kwini niber cilom yoh, co tom ci yob-yob na ci ya cunnukur kange bettinimbo wo co cwija. Ya ka ti wiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","La yi ci bituwe wi dutce di la nob nangnembo biduwa, no nyori kom kwob dilo kom kinong nii take na tom cimen nob nangenembo mor take ce. ");
INSERT INTO bsj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kom ya to man tom kom na be kwame mor bitilo. ");
INSERT INTO bsj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Be kom ture kiyemer, cwaye kange Taa. kom yarumde nii dor nuret. ");
INSERT INTO bsj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Luwe kom do wiyeudi, kom ter tok kako kom ki, funeret a no fo luwe wuro. ");
INSERT INTO bsj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tano ni funeret wi luwe nen di, fu neret kumero an yiti luwe nen, no mani dii fowor neret kumero an yila fiya kom. ");
INSERT INTO bsj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kom yi i luwe co, kom ca kom no, dike ci ne kome. Ni nage do daten cor cero, kom dore luwe-luwe. ");
INSERT INTO bsj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bero ci yo komeri kom ca diker ci ti ki kabum kumene. ");
INSERT INTO bsj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kom twam nubo ki bwarakeu wii bitine cuwo, kom yici liyar kwamaro bo bi dom kange kom. ");
INSERT INTO bsj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bitine wo kom do no ci yokom di yaken dor nuret ciyer, kom yi nubo cuwo kom kii ka kwero bitine kume tam na nye ko. ");
INSERT INTO bsj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nyo ferkumen, co warke dor kumer. Be kom nyom liyar kwamaro bo bi dom kange kom. ");
INSERT INTO bsj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma yi kom bi diye bolange caduma an la bero wo, fiyaka luma. ");
INSERT INTO bsj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kwannen karacinu, kwannen Baitcaida: nangedo tenangi wo ma mo re kume, na cin mani nyo Taya knge cidon di na cikin kiya ciko ki kinin, ci yim mor bituwamekange yilan kangbuwa. ");
INSERT INTO bsj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Di la biye bolang taya kange cidon ci an La kom fiya ka luma. ");
INSERT INTO bsj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mo kenne kafanaum mo kwati moki yaken ciko dii kwama ciya duktang nen tiye? O-ong an cukken nen bwiyar. ");
INSERT INTO bsj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wuro cutu fiye kom wiyedi, cuwantu minen, wo ko kom medi, koye, wo ko yere, ko niwo tomwo yere”. ");
INSERT INTO bsj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ci kwini ibere yilau ki fwor neret, ci yiti ki Teluwe, bwekelkele ken nyo durti. mor denen mwe? ");
INSERT INTO bsj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","La Yeeecu yici man to bwekelkele yaruti dii kwama na miblanka. ");
INSERT INTO bsj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","To min ne kom bi kwan kom fuwa na cwiwetininm kange birngetinim kange bikwan nii kiyer gwam, take ci makom nin ki diger ko bi dob. ");
INSERT INTO bsj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bwen nyeu kom bilangde nyo kom ki yuwa ko bwirko nuwa komti, Di la kom bilangi la den kumer mulangum mor dii kwama. ");
INSERT INTO bsj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na wo ri Yeecu dim ki for neret mor yuwa tangbe ko wucakke, coki man ne nen dur Te Teluwe dii kwama kange bitine. wo mo cumom dige worombo nob Yilenebbo nin kange nyomka, mo na fwetang ci nen nubo worombonin merangbe. na bibei bi dwartinim. Ong, Tee nyo dong dong fiye mon wiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dikero gwam ki no fiye Tee me wiyeu, ba nii win nyom bwe curoweu, La ka Tee win kange kangumbo wo bwe ciya ki nyomom ceu. ");
INSERT INTO bsj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","La cin yilam fiye bibei tomangeb cebo con cogi cunnka. Caklangka ki no nubo wo tom dikere cin toweu. ");
INSERT INTO bsj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Min yii komti nub wabero kange liyab kila ciyan to diker muu toweu, la ma ci to cii ti, ciyan nuwa diker muu nuwau, la ma ciya nuwati ");
INSERT INTO bsj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kange nii merangka bolange Yahudawa na co cwa co, cike na co cuwa co, cike nii meranka, Yeecu ma matiye na fiyam dume diiye? ");
INSERT INTO bsj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeecu yi co ki moki kiye nyi dike mulangi mor bolange? co ciya coki. ");
INSERT INTO bsj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bilang te mwe kwama ki ner mwero gwam, dume mwe gwam, bikwan mwer gam, kange dike mo kwabe gwam, na mo bilang nii bidomeu na dor mwero.” ");
INSERT INTO bsj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeecu ciya co mo tok dong dong, ma wo nyo na fulo ");
INSERT INTO bsj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nii merang ka cwiti na co cukum dorcero, ki Yeecu we nii mi bidome? ");
INSERT INTO bsj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeecu ki nii kange kwen yam Ursalima, yakenti Jeriko. Con yar ken kan nub kwiyeb, ci cukum co, ci yom dike co cike kwarub ci bukco dob co tamwi bwiyam. ");
INSERT INTO bsj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nii wabe kange dou wi nure co, to co di kwen tiyagum cungagin cuken. ");
INSERT INTO bsj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nyo tak ni tikali dur bikur wabe dou wi nure cwo, la to co kwen tiyagum cunaggin cuken. ");
INSERT INTO bsj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Di la kange bwe Basamariya nure tou co wi. ");
INSERT INTO bsj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Con bou fiyentange niwo wiye, bwacinen deti ya ci nuwa cinen neu, belti cinen nuwanko kange mwem bitutti (Inabi) kunn ken co yoken dor kelba cer yaki co fiye dami, na to co. ");
INSERT INTO bsj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ki elfini con boki dinari yob ne ni luwe, yi co ki to twa cinen dero, tano mo twalki cum dige ma ne neri, na yilauri man ya nen. ");
INSERT INTO bsj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mor nubo wuro we nii mo to ci nii bilang kange ce? ");
INSERT INTO bsj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ni merangka ki nii wo nuncinen bilangtum, Yecu yii o ki ya manyo ken. ");
INSERT INTO bsj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Di ci yaekn ti Yecu doken mor conunkur kange nawiye kange dencerro Marta yo co lo co. ");
INSERT INTO bsj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Con wiki korya ce den do Maryamu, wo yi na Teluwe nuwa ti ka dike co toktiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ki ma yiri, la con bo Yecu nen ki Teluwe kwm nen bo, korya mi dob ye ma, m nage do tiki kwami? yi co ca tikang ye, Yecu ciya, la yi co Mart, mo kwon dor mwero dor diker dutce. ");
INSERT INTO bsj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","La Nii durko ciya co ki “Marta mon yumom diker kila. ");
INSERT INTO bsj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Di la diker win tam yo maryamu tom ce diker yor yore, wo, nii mani a yo cimenti. ");
INSERT INTO bsj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bi dikange Yeecu kwob diloti fiye kange, kambo co dimeri, win mor nob bwanka ceko, Teluwe merang nyinen kwob ka dilo ko, na wo yuwana merang nob bwnag ka cebo nineu. ");
INSERT INTO bsj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Con yi ci ki no ka kwob dilo tiri kom tok ki. Te den mwero na tii wucak, Liyar mwero bo. ");
INSERT INTO bsj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ne nyo dike nya ca tiyeu na kakuko ce. ");
INSERT INTO bsj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cutang nyinen bwirang keret nyero, na wo nyo cutang nobo wo ma nyinen bwirang keretiye, yare ki nyo fiye duwaka. ");
INSERT INTO bsj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yecu yi ci ki we more kume ki bi farak, an ya fiye cowiye ki dila la yi co ki farmi niye cen cun cari ta'ar. ");
INSERT INTO bsj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wori kange farmi bo yam can nawo, ma manki dike ma ne coti na ca. ");
INSERT INTO bsj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","La niwo more ciya ki kom yere, kweri man nungum nyilo miko, take mo kange bibeiyo lomi nyon daken. mani ma dol kwenka ti nan nenen carito. ");
INSERT INTO bsj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mi yi kom, bwen co kwen co ne bo cari di, bifarako tiber ciyere mo nua kwenduwe, mo cinti mo kenan coti, an kweni nenen dike mo cuitiye? ");
INSERT INTO bsj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mi ma yi komti, kom keni atam ne kom, kom do kan fiya, kom kwabi an wumkumen. ");
INSERT INTO bsj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wuro kentiye ti yoi wuro dotiye ati fiya, take wuro kwa tiye an womcinen. ");
INSERT INTO bsj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","We Te wuro bibwece kin jinge a ne co nacuwetiye nyi jinge? ");
INSERT INTO bsj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kangeri ken co far di a neco bininge. ");
INSERT INTO bsj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","na wo nyori kom nobo bwit kom nyom kom ne bibeiyo lo kume dike yori nye ye bwi Te kume wo mor dii kwama, an ne kom yuwa tangbe kwamako, nubo ken ce. ");
INSERT INTO bsj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","kange diye Yeecu cok kange bwekelkele nyo tamtabe, la bwekelkele cirum niwo la a tok erti. Dike nyimankar tam nubo. ");
INSERT INTO bsj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kange bo mor nobe ciki, “Kibi kwang Ba'alzabuba liya kelkeli cok kelkeli bo tiye. ");
INSERT INTO bsj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kange bo cuwa co, cin do na cin nung cinen yirom dii kwama. ");
INSERT INTO bsj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yeecu kweri nyomom dike ci kwati ner cire, la yi ci ki “Liyar do ti kangum yoberi, ki ma kiye ki bwiti ci, kayan. Tano luwe tikangum yobri, ki ma kiye an yarum. ");
INSERT INTO bsj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tano bwekelkele tikangum yobri, kiye kange dorce, la liyar cero a ti nyi? kom ki maki cok. bwekelele ki bi kwan Ba'alzabuba. ");
INSERT INTO bsj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tano man cok bwekelkele fiye ba'alzabuba, la kibi we burombo bwan kumen ti cok kelkelito tiye? nyori ci, ciyilam nobo a makumen bolang. ");
INSERT INTO bsj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tano fiye kwama ni ma cok kelkelelito tiyeri, Liyar kwamaro biyeken kumen. ");
INSERT INTO bsj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tano nii bikwangne ki kulen kiyener, ki cum lo cue kulen cere bi bu. ");
INSERT INTO bsj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tano kange nii lamco ki bi kwan kuwam cori, an yom kulen kwener cero. ");
INSERT INTO bsj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","wuro mani wari kange mo, kiye mati kange mo, take woro mani murti kange mo, watanka co matiye. ");
INSERT INTO bsj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tano yuwatangbe ko bwir ko ceri bwi nii, ki do fiye kucer, ki do fiye ca fubom tiye. No fiya bori a yi ki, man yilaken lomi fiye ma do boweu. ");
INSERT INTO bsj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na yilauri co fiya cin nyenum luwe, cin ywelum co. ");
INSERT INTO bsj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ya an tou kange kelkeli niber wuro la co bwiranke ci bo ci yiken wi, cile nii wo an la kabako bwiraka. ");
INSERT INTO bsj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kambo Yeecu tok tiyeri, kange nawiye mor nobe, kung dir cero ki, “Nii bibwiyere fwero bo neneu kange yori mo nowe. ");
INSERT INTO bsj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nob bibwiyere wori nuwa ker kwamaro tiye ci bwnagtenti take. ");
INSERT INTO bsj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Fiya nobo yo ten mwerkako ti la co ki, kallo wo duwo, kallo bwir, do yiromti, bwen duwal yirom mani a nung cinentiye, kan yirom Yunusa. ");
INSERT INTO bsj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na wo Yunusa yilam yirom nubo nineba, nyo bi bwe nifire a yila yirom ti fiye kalllo wo wiye. ");
INSERT INTO bsj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nawiye wo ca liyar kudu an ti na ma bolang kange kaldo wo an twalum ci, ceru fiye kutan na co nuwa yilen suleimanu, la kange wo wuro la suleimanu fo. ");
INSERT INTO bsj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nubo ninea an ti bolang kange nubo kaldo wo an kuwan ci. Cin nuwa fulenke Yunusa, cin yiloten, kange La Yunusa wo. ");
INSERT INTO bsj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nii kan mani a kwer talkeri ti na yurangume, kaka Cimon ki tale, dil au yo denkila, be na ne filang mor kuwe. ");
INSERT INTO bsj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nuwe mwe co talkire bwi mweutana nuwe mwe yora ri, tang num bwiyombo a fiya filang tano nue mani to ti yorari bwi kume a dim ka kumtacile. ");
INSERT INTO bsj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kom ma yora kati filang ko kume nen yilam kumta cili. Tano bwi kume dimka filang di, kumtacile man. ");
INSERT INTO bsj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tano bwi kume gwam dimka, kumtacile man biduwarece, la bwi kume a yilam na talkire wo ne filang cekoti durkumere. ");
INSERT INTO bsj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","kambo Yecu dim kereri, kange nii dingle (Bafarice) cwo co na bo lo cona co cam cari, Yeecu dou yi. ");
INSERT INTO bsj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kambo nii dingli (Bafarice) To Yeecu ca carito ti nirbo kang, la ti nyimange. ");
INSERT INTO bsj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yeecu yi co ki, “Kom nod dinglibo” (Farisawa) kom ki nirum ka bwim kwelem more dimka duti kange chil. ");
INSERT INTO bsj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kom kule nobe, wo ma bwimbe kebo wo ma moreka? ");
INSERT INTO bsj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kom ne nob bwinebo dike more. Dikero gwam na nir kimen. ");
INSERT INTO bsj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kwan kom nob dinglib Farisawa kom yo wine ti dor kwobe na kule, tibi kange tangnim laluwo, dila kom citan wucake kange cwika kwama ko. tam nyo na ma dike dong dong a cwi tangnin dikero tak. ");
INSERT INTO bsj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Gwam kume kom nob dinglib Farisawa kom cwiti a nekom fiye ken mor kurwabe, take a ne kom dur yarume fiye fene. ");
INSERT INTO bsj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gwam kom nob dinglib Farisawa Kom ki no na tuwetinin bo ci yo cinen bo kange diker na yirome nobo ti fuwarangi kebo ki nyomka cek. ");
INSERT INTO bsj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kange nii meranka mor bulange Yahudawa ciya karcinen ki Nii meranka dike mo toke, kangum ner nyera. ");
INSERT INTO bsj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kwan kom nob meranka bulangeb dike kom kung nobo nin kulen do tuu lambi kwan tuka ke. Kom mok bo kulendo kibi wer kange kume. ");
INSERT INTO bsj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kwankom, kom mu diker kulomkati fiye tuwetinin nob tomange kwama bonin. ");
INSERT INTO bsj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bwikoko ten kwanib kumeb twallan ciye. ");
INSERT INTO bsj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yilam ka nyom nangen tenkwanub kumebo, ci twalan nob tomangebo wo kom bulanti ki ciye, ");
INSERT INTO bsj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaldo a tuu tutum bwiyale nob tomangebo gwam wo ci twal fiya kale wo fwele. ");
INSERT INTO bsj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tabti bwile habila ya tam ciko Zakariya ciko wo ci twal tiber tanjilan kwamero fiye wuccak. ong mi yi kom an do dike tam na ciye kaldo wo wiye. ");
INSERT INTO bsj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Gwam kom nob merangka bolangeb wo Yauhdawa ceu, wori kom tom nyilo yomka, kom ki bwikimi kom do bo. kom Yuwan do ka ko doka. ");
INSERT INTO bsj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bwikako Yeecu dob fiye co nob mulankab kange nob dinglib (Farisawa) cin tu kurom kange co cin kwokangi kange co dor diker dutce. ");
INSERT INTO bsj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ci doti na cin cii cimen kore, na ci tam cco mor dike co toktiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kutang bo nyori bwikako nubo dutce mwerkang fwarang bwititi, La con ter tokak kererko kange bibei tomange ceu. Kom cire kange canfuwambo nob diglibo (Farisawa) wo co yulkako. ");
INSERT INTO bsj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Diker mani nawo cummome nawo mani a wom tiye, kange mani nawo yurangume, mani a nyomtiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Diker mani wo ka tokti balumbale, wo mani a nuwati nyanglange, Dike kom toki kiyelange, an kwaki dir fiye gwam. ");
INSERT INTO bsj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Farub mib ma yi komti O-n nure tai wuro a twalum bwiyotiye. bwikako nye ci manki diker makar. ");
INSERT INTO bsj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi makumen biweret, wo ka nuwa tai cero tiye, kom nowo tai wuro twalum di an mwerken kom mor kira. “O” man yi kom ti kom nuwa tai co. ");
INSERT INTO bsj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ke ciki meye berin bilebe nung anini yob? gwam nyo kwama mani a tabti ki wi more ciye. ");
INSERT INTO bsj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kange yirito dor kumere nyomom kilatum ciyembo. Kom nuwa re tai kom la bilibetin do yorka fiye co wiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mi yikom ti Nii wo tok fulen miro kabum nobomeri, Bibwe nifire an warkercer kabum nob tomangeb kwama. ");
INSERT INTO bsj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tak Nii wo koye kabum nobomeri man ko co kabaum nob tomange kwama. ");
INSERT INTO bsj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nii na tok ker kiyer dor bibwe nii fireri an cutan cinenwi. La niwo tok kwilangka dor yuwa tangbeko wucakeri, mani a cutang cinenti. ");
INSERT INTO bsj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tano ci bo ki kom kabom bikur waber di, kange kabum nob bulange kange kabum liyabem kom bwende kange dike ka kartiye nawo ka cerum dor kumerotiye; kange diker ka tok tiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yuwa tangbe ko wucake an meran kumen dike ka tok ti fiya co. ");
INSERT INTO bsj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kange mor mwerkanka nin yi co ki Nii merangka yi kemi na tikangum kwalito kange mo. ");
INSERT INTO bsj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","We yo yi nii bolange, kange nii do kertiye dor kumer? ");
INSERT INTO bsj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kom yilam ki cini kari kom yilam nob kucunu kebo dike nii mweri co la dike yurak mor dumece. ");
INSERT INTO bsj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","La Yeecu yici kero ki danke ki take ni kange ni carito dutce, ");
INSERT INTO bsj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nii wo kwabi neer cer ki, ye ma matiye, wo ma mani ki fiye ma yom carito wo tiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma nyo mom di ma matiye man werum binitin miro na mwirangum na yoken cari mito kang tannung dikro. ");
INSERT INTO bsj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","La na yi dumek mi mike dume mi, mo wi ki diker dutce wo ci yomneneu fubom ca no ma bilantum. ");
INSERT INTO bsj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Di kwama yico nii wo mor kume wo ci ci dume mwetimunen. kulen do mo mweri mo yo dor mwero nineu a yi la na wee? ");
INSERT INTO bsj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nyo niwo mwer dor ceronin cwika, tano co man ki cweka kwamamnin ");
INSERT INTO bsj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yecu yibibei tomangece, Di nyo ma yi ti ki kome, kom bwende ki dume dike ka ca ti kaka wo ka dukti bwiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","dume la cari, bwiyo la kwilen. ");
INSERT INTO bsj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kom to karce nii mani fi fik mani biye bituwe. Ci manki bentini kaka kuni murka carik, dila kwama catikici, kom kon la bilibe yorka? ");
INSERT INTO bsj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","We more kume, ka tii dilanka a yok dor cero nin ten kumeni tiye? tana kom dolbo ko yok dorkumero ninten dikero bi duware. Ye bwi ka kwom dor kumero ti kange tangnim dikereu? ");
INSERT INTO bsj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kom to funti mor kiye kambo ci duyantie. ma ci ma nange, ma ci ma kange diker. Mi yi komti bwen Culeimanu ki bwayilen cero dwal di, du bo kulen do la ciye yerake. ");
INSERT INTO bsj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tano kwama dii yerako nin kulen yori na nyori, den i, fini an dokken co kira, la a bwi nyi kwama a fweti mani ca dukumen kulentiye, kom nubo ki dwal ka bilenkere. ");
INSERT INTO bsj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kom bwende ki dike wo ka catiye kaka wo ka notiye, kom kimang deu. ");
INSERT INTO bsj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nyo nubo dor bitinen gwam ci do dike wuroti, take Te kume nyomom kom ti cwi dike buromboti. ");
INSERT INTO bsj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kom do liyar cero, kullendo wuro ciya yok kumenti. ");
INSERT INTO bsj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kom nuware tai, kom bi beiyo bi duwattinim wori ki bilang tum Te kume a ne kom liyartiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kom miyem dike kom cike kom ne nob fuwabbo. kom ma dor kumero nin bilantin we mani a kayatiye kom yoken di kwama fiye dike cuwo mani a difiye, fiye nob kub mani a dol yaka tiye, nakunkunge mani a kanti. ");
INSERT INTO bsj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Fiye cweka mwe wiye firn nermwero wiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kom mwatumen cwentum kulen kumero ko cakkangum, talkire kume ata cai kang kang. ");
INSERT INTO bsj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kom yilam na nuboro wuro nintan teluwe ciye na yilau lo cika, la tano bo kwa yilokori can can do wo ciya kweni ci wobcicnen yiloko. ");
INSERT INTO bsj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bilenker ma yikom ti an cakkangum kulencer na yo ci yiranken la na ceci carito. ki bwici. ");
INSERT INTO bsj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bwen Teluwe ciya a bo ki kume keno, kaka ki dii ca biyerci ki bati ci ningtan co ti. Nobbibwer cnga buro. ");
INSERT INTO bsj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko nyomom na nii luwe nyomom boka nii kwiye kori, mana a dobti ci wercinen luwe, ci doken. ");
INSERT INTO bsj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kom ti ki bati wari kom nyomom filang Bibwe nii a yilautiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bitru yi co ki teluwe nyo mwo yin danke wotiye, kaka nubo gwam ka? ");
INSERT INTO bsj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Teluwe to ki nii durko wuni ki cini nii yilen wo Teluwe ce ne co canga ceti kangeceke, na to ci na ne ci carito fiya daten ne? ");
INSERT INTO bsj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nii bibwiyer canga wuro Teluwece a fiiya co na dike ci yoce ca mane. ");
INSERT INTO bsj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bilenke mi yikom ti aneken co lo ceu kang cek. ");
INSERT INTO bsj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ta no canga wo toki mor nerci ki Teluwe m lakken boka ko, la con ter bukka tang nim cangambo nabarub kange natub, farub nagenebce. ");
INSERT INTO bsj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Teluwe canga wo an yilau, fiya co nyombo, La torangum co ki mwan ki mwan na mwe co kange nubo manki ciniye. ");
INSERT INTO bsj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Canga wo nyomom mulen Teluwece, di la ka bo bati mabo dike teluwece yoco ca mane diker wo Teluwe cwitiye, a nuwa bibuker kange banjange dutce. ");
INSERT INTO bsj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","La niwo nyombe, la ma dike kebo dong dong, mani a nuwa bi buker kange banjange dutce. Nii wo ci neco dikero ducce a do dikero ducce cinen. Tano ni wo ci neco diker ducce na takako ce, na a do dike ducce kambo ken cinen. ");
INSERT INTO bsj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma bou be na dukti kira dor bitiner, man cwi na ki kweri tam di. ");
INSERT INTO bsj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mo man wi ki yuka mwenge ko wucake wo ciye mamentiye ciko, la ma cwi mwini mam. ");
INSERT INTO bsj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","kom kwa netti, ma bo dor bitiner na boki for neret? ma yi kome o-ong dila yalkanka. ");
INSERT INTO bsj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tabti nawo an fiya nubo nung mor luwe wiin di ciya tikangum, nubo ta'ar makiye ti kange nubo yob, yob makiye ti kange ta'ar, ");
INSERT INTO bsj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bwe kange te ciyan ma kiye kange bwiti ci, bwe an makiye kange Tece, Ne an makiye kange bibwece bobya, bobya kange nece, bifire kange ferce, wi bibwe ce kange ferce. ");
INSERT INTO bsj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yecu yi nubo mwerummeu, no kom to yuwa mwengek kwenu meri komki mwembo an cwe, nyo a matiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tano yuwa ko ceru bangdi komki an ma cillen kambo ken, nyo matiye. ");
INSERT INTO bsj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nubo bwir, kom yumon fwetanka kabal kalero kange dii kwama, dila lakom nyom bo fwetanka dikeko bwiti nawo nyeu? ");
INSERT INTO bsj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ye bwi kom nyombo dike a tikankomtiiye? ");
INSERT INTO bsj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tano mwi yaken ti kubolange kange kobkanka mweri, ken co kom ywellum don nuret kari ya kinen kabum nii bolange. Kari nii bolange neken nen nii wo to fucina tiye mani a nung mwen nyomkankati fucina. ");
INSERT INTO bsj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi yimnen mani mo ceru ti, mon yam kiyemero ci bwangmwen tiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ki kwama curo nubo kangem wi yico ker dor nobo Galiliye wo Bilatu ceikangum bwiyale ceu kange wabi. ");
INSERT INTO bsj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","La kiritti yici, “kom kwatiri Galatiyawambo bwiran kere ka? ");
INSERT INTO bsj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nyonin, min yi komti. No kom dobbori gwam kume kom bwiyarangi na ci. ");
INSERT INTO bsj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kakaa nobo kwobcilombo naurube ciloam wo luwe cwemi nyeu yar cinenti dorceer ci bwiyarangume, kom kwatiri ciin la tangnum nobeu urucalimau biranke? ");
INSERT INTO bsj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","O-ong, miki. Lano gwam niwo ko dobka ri ciyan bwiya rangum. ");
INSERT INTO bsj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kiritti tok dangke wuro,”Nii kange wi ki tii nyongjong wo ci fiken mor take ce la cin bou na ci ca bituttuiyeri la tiyo man ki cari. ");
INSERT INTO bsj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dila nii curo yi nii tokako,'to, coro ta'ar naweu, ma do bituttuiti fo nyongjongo nin di mafiyabo tom co ye bwi ba dob coti ten fiye ti koniye?' ");
INSERT INTO bsj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Co nii tokakko ciya toki neye kumeni nyo bi dob na kam nan yoti cinenti kilongwi ");
INSERT INTO bsj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No mabi tuttidi cortini boti yeri tano mabobi tuttiri nan mwatum co. ");
INSERT INTO bsj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bi di kange Kiriti ma mrngkati fiye bi wabe kange bidiye fob ka. ");
INSERT INTO bsj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Di la naweu kangee bou wo dii curo kwob cilombo narub wiki twirak yuwa bwir gwam kange fwinka mani do taka ti. ");
INSERT INTO bsj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kambo Kiriti to ce cin cuwaco yico cin cukum twirako wo. ");
INSERT INTO bsj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","La kiriti yoti kanko dor ce tabbo. buri can cando cin tarken cet co ter bilonge liyar kwamma. ");
INSERT INTO bsj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Di ni kur biwaro manfunerr dige bwiyeu Kiriti nangen bi Fob ka di ni bi wabiro nyi nubo kume ni wi nyo nukku na nangen do ce kom bow na makimen ddi La kebbo ki bidiko fobka. ");
INSERT INTO bsj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Di la teluwe kar cimen ki kom nubo bwir no nyori mi wor tiber kimer mi kange wo ca ki gelbati na fiye ci tekume nemwem bidiye fobka ka? ");
INSERT INTO bsj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","No nyori wuro bibwe Abrame wo be kelkele no bwamco ki coro kwab culom nanrube, tano nyo mania kwi cati kibi diye fubka ka? ");
INSERT INTO bsj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kambo co tokki nyo weri nubo ma kwab kangka ti kange coweu cin nuwa kwenduwe. Gwam tare al cin ma fur nener ki dikero kendo wuro ci mane. ");
INSERT INTO bsj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kiriti toki kiye ba tak liyar kwama ti cike yilo ye ba dang ti cike? ");
INSERT INTO bsj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wi nyo na nun nying cin wuro ni kange wabi takece Landim nyo gili gili la bilibe tini manag cor tini kani ce nen. ");
INSERT INTO bsj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yila con tokko liyar kwararo ba tok kiye? ");
INSERT INTO bsj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wi nyo ca fuwam di la kange nawiye mwe kange mim murduwe bidigle tar na fumco. ");
INSERT INTO bsj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kiriti ker kan cinar lor kange bwar lor, wi nuro wo yakenti Ucalima ci mernag cinneti. ");
INSERT INTO bsj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","La cin yi co teluwa nubo biro ciya fiya dob kakko bi dob nyo ka? La cin yici. ");
INSERT INTO bsj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ki ma dige dateneu. ki do nure bwa ki do nure bwabwa leli nyori mi nyi kom, nudo ducce ci cwi doka ti di la ci fiyabo doka. ");
INSERT INTO bsj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","No niluwe kwri kwenum nungum yilokko la kan tiken kale kom kwa kwabang nyi lokkoti teluwa, teluwe do nyo nyi do mour di cin ciya cotaki mi nyomkombo keno kom cirou feri. ");
INSERT INTO bsj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Di la ka tok komki nyim ca nyin no for kabum mwem. di la mun merang nyinen dor nure nyim bo nin. ");
INSERT INTO bsj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","La can ciya ci tokki. ");
INSERT INTO bsj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ciyan ci wiye kange kuka nunne ki bidiye kom to muca, kange Isaku kange Yakubu gwam nob dugume firer liyar kwama kumeu ciyan merken kom kale. ");
INSERT INTO bsj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ci ya bo twat mee, bang, kole ci ya ca tokam cari iyar kwama. ");
INSERT INTO bsj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ki nyim comm wuro nob kaba nyim lam nubo cuwa bwire nubo cuwa bwireu co nubo yilam kaba. ");
INSERT INTO bsj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Di kutabo kangem faricawa cin bou ciki Musa, kubom fo dike bwiyeu Hiridus cwi twalka mwekti. ");
INSERT INTO bsj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kirititi tokki com ya Bicura kom ki to min co kom ninga nubo fiya fulo ki di ki kume take cwiti a murangu bibeiyo na wuro bicate ki murang de bi bei loce mwor tangum cem la kom ciyabo. ");
INSERT INTO bsj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","To ci miran lomwe la mi, yikomti mani ka to yeti tano diye ki tokke luma drek tam nyo ki den kwamar. ");
INSERT INTO bsj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Bwentano a manyiri yam mimbo ya kenti duwen, fini cike daten bo ciya twalum teluwe kutom kange Ursalima. ");
INSERT INTO bsj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kom to lo kumeu cin cwutanwi No kom tok kumki luma ki no kan bibwe nii wo bilang kwama yeu. ");
INSERT INTO bsj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Di fubka cin do ko lo ni wo mor farisawa na cin ca cari la nubo cor ci nenten nuwe. ");
INSERT INTO bsj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Di la ikange wo ka co wo ki der na cekke. ");
INSERT INTO bsj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kiriti me nobbi finero durko kange fari cawa daten na fulani bidiye fobka nyo kakka mani nyo ka? ");
INSERT INTO bsj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","La cin kumom Kiriti ta co fulo co di nyico ca yakenti ");
INSERT INTO bsj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","La kiriti me ci wetiber kimer ki bwe kange, bi curan di yraken bwire bidiye fubka la mani ca cokk ti ka? ");
INSERT INTO bsj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Di la dol bo tokker diger buronin. ");
INSERT INTO bsj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","kambo Kritti to nubo ci cuowu d ti ka fiye yime keneu tok kerg dangke ci nen. ");
INSERT INTO bsj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","no ni kange cowonner fiye nakarim yire dur ni kange wi ci cuwoco kenne lanen ki dur. ");
INSERT INTO bsj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Di la no niwo cuwo kom bou an yinen nub niwo mi fiye yimemweu na coyeu mwan kweni mu yiken kutule bi duware. ");
INSERT INTO bsj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","No cin co nen fiyeri, yiken kutule biduware la no niwo co nenu bouri atin tooki farmi kweni yiken fo cwemer na fiya bi duyet nuwe nubo wuro nokom yi wariye. ");
INSERT INTO bsj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gwam nitu dor core ci kebo diker ciyan bilange co tano niwo dor cero cin diker nubo mani a bilank coti. ");
INSERT INTO bsj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kritti yila yi nii wo co cue no mo neni cari na ti na cwentiri yire muki mwan cowo for nener yimom ki namwe, niwo bidom kange mwe di dike ci ca mani nyo. ");
INSERT INTO bsj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","No mwon cuwofiye nakari cuwang kang niwo mani cike fukma, kilen wale kange bibei. ");
INSERT INTO bsj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mwan fiya luma dike bwiyeu ci ma bilantum dikero wo mwa ma cineneu ma ci ya neneti na bilank Yeecu maneu mwan fiya bilanka kibi diye kwenka nob bi bwiyer kwama. ");
INSERT INTO bsj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kambo ni win mor nubo ca carito kom wari kange kiritti nuwa nyori ki lima nubo biro a ca cari liyar kwama. ");
INSERT INTO bsj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","La Kiriti yi co ki ni kange wi cowo nubo ducce ki cika dur ");
INSERT INTO bsj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kambo di cika ko lameri tom cange ceu yaca cowo nubo wuro co ne tomanage ciya bour dikero kwarub ywelu. ");
INSERT INTO bsj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gwam ciye cinter neka dige bwiyeu. wo kiba yico min tiyen takke daten yamman to mi kinong nenti dobye. ");
INSERT INTO bsj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","La ni kange tokki min tiyen nne nung mi cwiti nan cuwa mi konog nenti dobye. ");
INSERT INTO bsj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ni kange ki nia na nawiyeu mani ma dol yakati. ");
INSERT INTO bsj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kambo bwe canga ce bo yi teluwe ceri yaken tiyeri la teluwe ceu mam funer nyi canga ceu ki ya wulom bwangten nure cinar loreu kange wo kebo cinar loreu. congawu, fukma, kilen celeb, waleb. ");
INSERT INTO bsj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","La canga ceu tokki i lomi dike mo tikke timi mam dila corbo bwini. ");
INSERT INTO bsj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Di la ni luweu nyi canga ceu ya bangten nureu cinar loreu kange wo bwar lor bolange ciya dou na ci dim lomi. ");
INSERT INTO bsj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tano nyi mi yi komti win more kume cowo ki kaba bakeu, kange ciye mani a c ci kamiti. ");
INSERT INTO bsj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nyo tere yakenti kange co la con yila bwi yi ci. ");
INSERT INTO bsj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Gwam niwo bou fo fiye weu tano kobo tece, nece, wice, bibiyoloce, yitum cebo nina bare kange wice nyo kange nercero ri, mmani ca yila bibwemiti. ");
INSERT INTO bsj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gwam niwo tuba bwatiye na bwangmenten neri kebo bibwemi. ");
INSERT INTO bsj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","We tiber kumer wo cwi muka luweti la yibo na nyi mom diek ca kwale ki kaba tano cin wi ki kiyemer tak kakkori? ");
INSERT INTO bsj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tano nya ci yo kwar kuwero ci takbo dikakori nubo biro toeu nung coti. ");
INSERT INTO bsj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ci tokti kii niwo ter muka la fwem ki di kakko. ");
INSERT INTO bsj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","No nyori liay wini wo yakenti kange liya kange nyombo bi kwama nubo loce keno nyiri daten bikwan tin mamdi na ci nyi mom keno niwo ki nubo bikeate kwab ki culomeu catin mam kange niwo bikate kwini yoberi. ");
INSERT INTO bsj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tano mani ca doltiri ki kwama kece firen kutaneu ca tom canga na meu yaka nanneko na ka kwendo mani. ");
INSERT INTO bsj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nyori ni kange mani tiber kumer wo ca dubom kulen cero tiri mani ca yila bibwe miti. ");
INSERT INTO bsj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mam dike yora tano carum bitineri mwa ma ye? ");
INSERT INTO bsj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Man ki luma bi tine tano amnyiri dam cutangka gwam niwo kitu nuwa kange ca nuwa ");
INSERT INTO bsj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","La yuwak nob merangkab kange nob yoka kemer doreko bouti Yeecu nen cin nuwacoti. ");
INSERT INTO bsj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisawa kange nob mulangka bo cima fwenati bwitici ciki” Niwo yo nob bwirangkebti ci ca caitoti waritak. ");
INSERT INTO bsj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yeecu tok danke wo yici. ");
INSERT INTO bsj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Canno kange kume ki kwame kumi kwo lawin more ce lem, mani ca dob kwini Teer culombo teere ti naci bwanten meka wuro win lemeu naci fiyam. ");
INSERT INTO bsj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tano ci fiyam ri naci tuu ci yaken Lagwamcem ci no fuwor nerer tiye. ");
INSERT INTO bsj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","No ci yilaudi naci cwo farubcebo kange nubo biom kange ceu, naci yici, kom ti kanye fuwor nerer min fiya kwame mi lemeu. ");
INSERT INTO bsj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Miyikomti nyo a ma fuwor nerer tiye dii kwama don ni bwiranker win kange nobo kiner luma kwini taar culombo teereu wuro dobo ywelka bwirange keu cereu. ");
INSERT INTO bsj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kaka we nawiye, ki kemer nai nyo kwob no lemdi manica wentalkire ti ci nyina yum mor kuwe la citi doi naci fiyam me? ");
INSERT INTO bsj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Noci fiyam laci mwer farubcebo kange nubo bidom kange ceu ciyicii kom tikanye fuwor nerer min fiyam kwame meu. ");
INSERT INTO bsj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nyo mi yi komtiye, diker fuwer nerer nob tomangeb kwamab cano, ni bwinrangke winn dob bwirangkerori. ");
INSERT INTO bsj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","La Yeecu yici “Ni kange wi ki bibei bayilob yob. ");
INSERT INTO bsj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","La bi duwareu yi teece Tee neye miu kwalito mor cuweka mwekonin. Dila Tee ce kabkamm cinen kwalito. ");
INSERT INTO bsj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ki Kumeni kilabori dila bwe biduware murance kwalito yaken biti kange katangi. cin yakcangum kwalito tie nen bikulentiti yakcangum kemero cero noranka diker. ");
INSERT INTO bsj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kambo ci yakcangum kwalitori la cin ma wura kambo ken bitine con ni lam doken bwini. ");
INSERT INTO bsj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yacin neken dorcero nangen ni kange bitineco, la twamom mor tangini ce nacinen Bilerce cariti. ");
INSERT INTO bsj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","La cin cari ca do dike bilerece a catiyeu, wori ni kange mani neco cariti. ");
INSERT INTO bsj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dila kambo yulancero bwiceri yice ki cnga Tee mi cingile cike cari la cinnen bo dila mi fo ma bwiyati ka ker carity. ");
INSERT INTO bsj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Man kweni neken Tee mi in yico “Tee Min ma dikwanin bwirainke min kangmwen. ");
INSERT INTO bsj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma datenbo coya muki bibwemiri yokenye min yilam win mor cangabtinim mweb?”. ");
INSERT INTO bsj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lacin kweni, cibou tecemin. Dila kambo ci kutanneri, la Tee ce tomco cibwini ceto yaki cwak, yan bwabco, lata macinen cuika. ");
INSERT INTO bsj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bweu inyico Tee, mi ma dii kwama nen bwiranke, min kangum mwen. ma labo coten ye muki bi bwemwe. ");
INSERT INTO bsj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Di la Teece yi cangab cebo, kom bouki bellewo yor yoreu, kom ducinen kon dok cinen keneu kange cek kange ta nacek. ");
INSERT INTO bsj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","la ko bou ki neneu mobiyeu kom biyem bima cenen bilengtum ciko. ");
INSERT INTO bsj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na weu bebwemi bwiyam fiyeco dila naweu yilau ki dume. Lem fiyeco dila fiyau. lacin teer cika. ");
INSERT INTO bsj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ki kwama co bibwece durko ki kambo dadom loweri cin nuwa ci kwaban dikerti kange nuwetinin. ");
INSERT INTO bsj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lacin com kange bwe canage loceu meco dikerowo mati loriyeu. neneu mob mobeu wori cin yilau lo kwamer. ");
INSERT INTO bsj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bwe cangau yico kemwe yilau lowe, Tee mwe biyem neneu cin yilau lo kwamer. ");
INSERT INTO bsj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Di la kece bwe durko mam funer ko do kako mor luwe Tee ce ceriu kale kinang co. ");
INSERT INTO bsj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bwe durko ciyace Tee ce ki to ka cotiyowo mi ari kange mo ki komwem bo tomange nii wucak kange wo mune yob be nibeni wo ma cati kange farub mibeu. ");
INSERT INTO bsj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Di la bwe wuro ya cutang bicir mwer dor mun biye cinen kalnenero mob mo bo. ");
INSERT INTO bsj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Di la Teece yico ki “Bibwemi, mu wari kange mo gwam dikero na mi yeri na mwe. ");
INSERT INTO bsj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Di la dong dong cimamwen luma kange fur nerer, wori kemwe wo buyam dila nawori ki dume, fiayco lem la nanweu, bin fiyam. ");
INSERT INTO bsj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeecu yi nobbwankecebo tak, “nii cuwekako kangeni ki ni toman'nye, Lacin kwa kiyan nye ki nii toman nyewo kang cineut cuwekacokob. ");
INSERT INTO bsj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","La nii cuweka wuco yico, “fulan yer minuwa dor mwere? bowki kiyeka tomange mweke, wori mari mwa yila nii tomange mititak. ");
INSERT INTO bsj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Lamitomange toki neren, ma mangi, nilomi anyam tomanyewo kangmik? Wo, mimanki bikwantonet lami cwa kwenduwe meka cekoti. ");
INSERT INTO bsj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Minnyumwom dike ma matiyeu noci cukumye mor tomanye nindi, nubo ayoye lonici. ");
INSERT INTO bsj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dila nitomannye cwuningangum nubo teluwece bwanteng centiyeu, yi nii kaba, Nyi nii lomi bwangmwenten tiye? ");
INSERT INTO bsj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","yiki, 'nuwannye kwini kwob' Isryico, Bifumer mwerowo, canakowo yikenyiye, mulangum kwini nung. ");
INSERT INTO bsj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yilan yikannye, ciki bwangmwentuniyi? Yiki, cwayi bikate kwini kwob, 'bifumerwo mulangum kwini narub'. ");
INSERT INTO bsj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Dila niwo caklang nii bwini bilengewo ki yulancero. Bibeyo kaleweu nyimem maka nyinong nubo ko kaleweu la bibei filange yulang. ");
INSERT INTO bsj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Miyi komti komma bifarak kannge cuweraka kannge buni bilinke, cawo cin dimri, naci yokom lonici wuro manki diks. ");
INSERT INTO bsj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wo madikerti dongdong dor dikero biduwareri, cin nii dongdonge dor dikero dur, wo kebo nii bilinke don dikero bidurure, kebo ni bilinke dor dikero dur. ");
INSERT INTO bsj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tano kommabo dike dongdonge di cuwekako kebo wucakeri, we aciya kumenti kicuweka wabilinkece? ");
INSERT INTO bsj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No komma dike dongdonge ki kemer niidir we anekom kemer kumer tiye? ");
INSERT INTO bsj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kange mami wo a wob nii luweti yobe, catin kowini, ci cui win kakka ci ciya winening, ci cuwe kangum wineu. mani ka wab kwaamatiri kom wab cuwekati. ");
INSERT INTO bsj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kambo faricawabo wuro cui cuwekatiyeu nuwa dikero biombori, cin macinen cuwelangka. ");
INSERT INTO bsj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Inyici, “Kom ko tiki dor kumero kabum nubem, dila kwaama nyumuom nerkumero. Dikero nubo nedurketiye nyeu diker yeika fiye kwaama wiye. ");
INSERT INTO bsj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Biwerer bifumer nob tomangebo inwi yakenciko Yahaya nin. Kwama wuro cin bwanten ker liyar kwaaranarotiye, kwarub kutannyi kwamacuo ci bwangten ker liyar kwaamarotiye, kwanrub ci ma bwi dokka dorekti morece. ");
INSERT INTO bsj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gwamm kangero, atin yilam bwaibo diko kange bitineu nabecum, na diker win nabi weretro na dim. ");
INSERT INTO bsj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Niwo nyankan wucenin naukangeri inma buroka, ken niwo nau nawiyewo cinyam kanngeri inma buroka. ");
INSERT INTO bsj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nii cuwakakko kanngenwi, wo dukulen kemero yoryoreu nuwa luma kalecokoti. ");
INSERT INTO bsj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cin yoken nii kini kannge nyiloco, dencero Liazaru, wo bwiceu ka deti. ");
INSERT INTO bsj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ceu ci cuiti naci bwam fwercero ki fiti cari yarangum ti fiye caka carik nii cuweka nyo kibi cuwetincer bom biyablam bwiceti. ");
INSERT INTO bsj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Laniwo bwiyamri, nobtomangeb kwaamabo tu co yakenciko Ibrayim nin. Ni cuweks buyam, cin fwerumco, ");
INSERT INTO bsj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ci mor Adece ci nuwa dotange ti, la cin kun doro cinto Ibrayim kutan, kan'nge Liazaru cantangcek. ");
INSERT INTO bsj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Lacin cobicoro ciki, Tee Ibrayim, ci bwinni mito, twomun Liazaru adokti biwurece mwem abelti menti biyenmin, wori indotange minuwati mor kirewe. ");
INSERT INTO bsj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dila Ibrayim yico, Bwe, kwabi ki kwamawo mu kalemweu munuwa luma cuweka mwekobi, munyo kulentinimbo ken, La Liazaru nuwati ka dotange. Dila naweu luma cinecotide, mwe munuwa dotangeti. ");
INSERT INTO bsj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nobo nyori dila buwako cuwa cuwau inwi, wori birombi coi yabkati kumeneu nadolde, tak kannge na yabuurefo nyinnen. ");
INSERT INTO bsj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Lamicuweks yiki, Lami kennenti Tee Ibrayim, twornco lo Tee ni- ");
INSERT INTO bsj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wori minweki keb mib bi beibayilobe nyo nung, amincinen biweret kayilo cibuo fiye dotangewo. ");
INSERT INTO bsj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dila Ibrayim yiki, cin wiki Musa kannge kannge nob toman'ngebi nyori ciya nuwaci, ");
INSERT INTO bsj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dilla nii cuweka ciyaki, 'O, on, Tee Ibrayim, cano kan'nge mor birombo biyam biya yacinendi, ciyam yiloten. ");
INSERT INTO bsj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dilla Ibrayim yico, cono ci Musa kan'ge nobtoman'gebo ri, cabunano kan'nge fulou duwendi maciya nuwacoti” ");
INSERT INTO bsj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","La Yeecu yi nob bwankacebe, “nyimaka mami ter kottangka wo adokbo maka bwirank kektiye dila cilkakiniwo a yilam cotiyeu! ");
INSERT INTO bsj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Can nyimiri kin yei cimenti ner kuwaka kwircer amerkanco mor fara kan'nge wo ca yilam diker kottanka biduwatinimbo wuronin. ");
INSERT INTO bsj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kom yabki dor kumer. No kemwe kanngumdi, werangco, cano ciyilotendi dobcinen. ");
INSERT INTO bsj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cano kanmwen kiriti niber kikakukowimdi yilam bou munen kiriti niber yiki, min yiloten, yilam nyo dobcinen” ");
INSERT INTO bsj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dilla nobtoman'gebo cinyi Teeluwe, “cuob nyienten bilingkeu”. ");
INSERT INTO bsj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Teeluwe lanyiki, “Cano komki bilinke duwali na nun bikateri, mwanyi tiyowo, kwomfo, ya kulken mor caji”, atim manyo. ");
INSERT INTO bsj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Canwe more kume carno wiki cawonya wuro cuo cinen tomboti kakaa tocinen kwameti, cano yilam kiri, ayicoti, canokono bouyifo na camcarito? ");
INSERT INTO bsj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mani co yicoti ki mamen diker nan cam, na bwam dak mwekori maman na'nyend benan dimcaka carito kan'nge noko mu'ngeko? ");
INSERT INTO bsj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Manica ma cariya cewonin buka kamin yekti wori madikeci dokco ciya mane, keno am mani nyori? ");
INSERT INTO bsj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nyo, cano kom bwanten ciyikomemri, lakom toki, 'nyin can'nya manki nanyene. Nyim ma dikewo tam kang'eu”. ");
INSERT INTO bsj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kakuko kamnye ciyakenti Wurcalimani lacim bwanteng beten Samariya kan'nge Galili. ");
INSERT INTO bsj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kambo cidokenti cunnuku kan'nyeri, dila bayiloto kan'ngerobo kwob ki wale citim kutan cinkicico. ");
INSERT INTO bsj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lacin kun diro “Yeecu, Tee kwama, cibwini nyeto” ");
INSERT INTO bsj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kaci tociyeri, yici, “yakom dang dor kumero nob waberonin”. Yilam kambo ciyakentiyeri lacin yilam wucak. ");
INSERT INTO bsj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wiri morece kacito cin cerco wucak keri, yilanken, duktang kwama kidiro kwamer. ");
INSERT INTO bsj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Cin yari kabum Yeecu, cin bucinen kamti. Cin ba Samariye. ");
INSERT INTO bsj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeecu in ciya toki, “kebo kwob ci ceri wucakka? infe tanneceu? ");
INSERT INTO bsj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kan'nge mani wo yilam nekwaama durke kanco fabewo kikwaca?” ");
INSERT INTO bsj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lanyico, “Kwoni yayam mwem. Bilinke mweu ceerner”. ");
INSERT INTO bsj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kambo Faricawa meco kwamawo liyar kwamaro aboutiyeu, Yeecu ciya nyiki, “Liyar kwaamaro kobo nyomka maticike. ");
INSERT INTO bsj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mani atokti, 'iriwo!' Kakaa, 'wurenhim!' Wori Liyar kwaamaro kino tiber kumer” ");
INSERT INTO bsj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yeecu yi nob bwankabo, “Kumeni wi bouti nawo ka yoner toka kume win mor kumeni bi bwe niggire, dilla mani ka toti. ");
INSERT INTO bsj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ciyan yikon, “Tofiren! 'Tofuo!' Dila kom yakomtore, kakaa kom bwangten cire. ");
INSERT INTO bsj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nawo meblankako Nefilanti nafo cunya di kwamaka wori ya ken cunya di kwamako wureno, Nyo bi bwe nii a yilanyo ki kume bokaceko. ");
INSERT INTO bsj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dila kang catin nuwe dotangetinim kidimen kidimen bwiriri, nubo kaleweu ankoco. ");
INSERT INTO bsj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kambo bwi kal Nuhu re, nacuwo tak a bwiuti ki kwama bibwe nii aboutiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Citi cai, citi noi, citi nai, cinakenti yaken di ye Nuhu doken Nabire kwama la mwom wermakabo bow twalan'gum ci kwarub gwamm. ");
INSERT INTO bsj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nyo cimani ki kwama lutuwe, citi cai, citi noi, citinenii, citi miyei, ci fi fikkoti, cimuran'ngi. ");
INSERT INTO bsj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dila kikakuko Lutu, cerum Saduma, lakira kwaamako caruu dikwama, twalan'ngum ci gwamm. ");
INSERT INTO bsj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nyotak abwiuti ki kume bibweni aboutiye. ");
INSERT INTO bsj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kikakuko wori, niiwo dor kureu ayiraure kica tu kulencer mor luwe. Nyotak niiwo kiyeu ayilaure. ");
INSERT INTO bsj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Komkwaki wii Lutu. ");
INSERT INTO bsj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Niwo cwidumecetiyeu, anlemco, lano niwo lem dumeceri, anfiyanco. ");
INSERT INTO bsj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Miyikomti, kumewo amfiya nubo yob kwangni win. Atim tumwin nadubomwimeu. ");
INSERT INTO bsj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Atim fiya natubo yob ci kuwa nerti ware. Atim tum win na dubom win.” ");
INSERT INTO bsj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Atim to nubom yob kii, “Antum win nadubom win”. ");
INSERT INTO bsj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yilam netenti dangke kwange ki yori kabo nyirinyir ciya kwo diloti ciya cwaretai, ");
INSERT INTO bsj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","toki, “Bitine kam'nge nii bolan'nge kam'ngenwi baniki tai kwaama, takri manito yorinubek. ");
INSERT INTO bsj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nawiye kwale kam'nge inwi bitineco, wobou cinenneu, yicoki, 'Tikanaye ka ma manob kiyeb mibonin luma tiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Inkutan'nyi mani cwiti citikanyco, dila kibwiri toki mor nerece, cano mani cwatan kwaamati, takri mami mito yorak nubekti, ");
INSERT INTO bsj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kwarub kan'nge wo nwori nawriye kwalewo kwomye, mantikameo nacifiya luma, kambo marice luwayeti kiboko minenneu.” ");
INSERT INTO bsj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dila Tee kwaama jiki, komuwa dikero nii bolangewo manki tokkeu. ");
INSERT INTO bsj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lanawo kwama mani cor nubolocemboni birombo cicnen wiyeti kume kan'nge kakuke bwini citotika? Anmabwi fiye tikalicika? ");
INSERT INTO bsj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Miyikomti, comcorcinen bwimicito wulom. Dilla kambo bibweni bouweri, an kwobti bilam ke nii dor bitinen” ");
INSERT INTO bsj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yilam neten Dankewo kange nubonin birombo ciya ki dorcireu, ki cimnob lumabeb, laci cuwekamten tankne nuboti, ");
INSERT INTO bsj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nubo kan'ngumbo cin doken mor lo kwama naci kwob dilo-win bwe Faricawa, wineu inni nye dotiye. ");
INSERT INTO bsj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Dila bwe Faricawa kweminti, kwodila dor dikero birombo dorcer, kwama, min buwen kang, mikebo natangne nob kwiyeb, nubo mamki cakcakeu, nubo ma burokatiyeu, kakaa namiwo yodotiye. ");
INSERT INTO bsj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mimana kyak kiriti yob mor kume niber. Mine wineuti dorkwobberonin mordike mafiya. ");
INSERT INTO bsj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dila niwa yodiker dorertiyeu tiken kutan, ciyabo nacikun dorcedil, dila kwa cangeang cekoti titokiki, kwaama, ci bruini bwinimito, minni bwiranke. ");
INSERT INTO bsj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Miyikombi, niwo yilaken loco fiyam cerke, kebo nawineu, cawo niwo kunderceri ciyatim yirau kico, lano niwo yiran kidor cero takeri ciyatin kumkenci. ");
INSERT INTO bsj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dila nubo bocinenti kibi beyo naci teici, kambo nob bwankacebo to yeuri cin werankci. ");
INSERT INTO bsj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dila yeecu cuoci fiye ciwiyeu, toki, “komdob bi beyo biduwartinimbo abou fiye niwiye, kom ywacire. Liyar kwaama na kalciroce. ");
INSERT INTO bsj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bilinke miyikomti. canowo yobo liyar kwaamaro bwebi duwari, mani cadoti”. ");
INSERT INTO bsj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kan'age dur nubere kan'nge mecoki nii meranka dike yoryore”, ye ma mati nsa fiya dume mankidike? ");
INSERT INTO bsj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeecu ciyaco, “Yebwi mucoye ni madike yoryoretiye? Nikange mani womadike yoryoretiyo nobons kwaama win cardi. ");
INSERT INTO bsj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mwa nyimom werfudo-mare kayaka, twaldini, kure kwii, cwerde cwerke, ne Tee mwe kan'nge Nee mwe durko”. ");
INSERT INTO bsj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Di liyawo yiki, minmamwo kwarub kikwama min bwebwoyileu”. ");
INSERT INTO bsj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kambo Yeecu nuwa nyeri, yico. Dikero win cwar kumwene. Miyem dike mucikeu kwarub, neken nubowe mancikeu, manfiya lo kwaama-ladina bou nwangmenten.” ");
INSERT INTO bsj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kambo nicuwaka nuwa dikero biromberi, kan'ngum nercerobicom, wori cinni cuweka kamboken. ");
INSERT INTO bsj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kambo Yeecu tonercoro kayommeri, lantoki, “An bwai nob cuwakab nidokin liyar kwaamar. ");
INSERT INTO bsj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Atim yilam bwarinin naa Telemeko nadoken buwak bilifarak, kan'nge ni cuweka doken liyar kwaamar.” ");
INSERT INTO bsj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nubowa nuwa keroweu nyoki, “nokino nyori we abumtiye?” ");
INSERT INTO bsj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeecu ciya, nike lambi kwannifireu, deker makar fiye kwaama nuyeu.” ");
INSERT INTO bsj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","La Bitru intokiki, “Nwo, nyin dubom dike nyicikeu kwarub nyin bwangtennen.” ");
INSERT INTO bsj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeecu nyici, Biki cwom nikan'nge nani dob locuti, kakaa wice, kaka kebcebo, kakaa Teebcebo kakaa bibiyoloceu, ker liyar kwaamar. ");
INSERT INTO bsj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Lamamica fiyati kiriti kiriti fo kalewenin, kan'nge dume diriye kalewo boutiyenin. ");
INSERT INTO bsj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kamboci mwerci kwocilombo yoberi, nyici, “Inno, biyakenti wurcalima, kwarub dikoro ci mulan'ngi dor bi bwe niner kan'nge kang nobtoman'ngeb dukumebeb atim dim. ");
INSERT INTO bsj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ciyar nekanco kan buboko yombo kwaamau, ci buwoco, cineco dofan'nge, citwomcinen bitom. ");
INSERT INTO bsj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ciyam malico, citwalumco, ankwenum ki kume taareu”. ");
INSERT INTO bsj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dilaciyom winwo mor dikerobirombonin, wori kerowo yuran'ngum yuran'nge fiyeciwiyeu, ci yomtenbo dikeci tokeu. ");
INSERT INTO bsj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kambo cidadom Jeriko, ri fukwa kan'nge inwo yimcun'nya nurek, kenkiniti, ");
INSERT INTO bsj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","kacinuwa kalinube cukentiyeri, lacinme nye bweitiye, ");
INSERT INTO bsj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yeecu Banazret cuken tiye. ");
INSERT INTO bsj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dila fukmau kundir kibikwan tokkero, “Yeecu, bibwe Dauda, Cibwini mito. Dala birombo kabeu werangco, ciyicoki kumwom. ");
INSERT INTO bsj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dila kunten diro kibi kwan kamboken inyiki, “Bibwe Dauda cibwini mito. ");
INSERT INTO bsj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","La Yeecu tim inyici ciyaboukico cinen. Kambo fukma bou bidomer, La Yeecu meco, ");
INSERT INTO bsj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ye mu cwitin mamwene? “inyiki, Tee kwaama, micwitin tofiye.” ");
INSERT INTO bsj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Yeecu inyico, “yotoka fiyeko, bilinkemweu nirumnen.” ");
INSERT INTO bsj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wi dangjang fiya toka, kwangteng Yeecu, duktang kwaamati. Cito nyori, lanubo kwarub caklang kwaama. ");
INSERT INTO bsj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeecu do yarico la cukenti morece. ");
INSERT INTO bsj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nikange wi deu cero zakka, dur nobo yo dortiye, nii cwika, ");
INSERT INTO bsj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Con mani no co to keno we yecudi. La co dol bo toka wor, nobo durce, take con nii bi kwen. ");
INSERT INTO bsj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Laco cukken kab ya con kwiken tii nyincin naco tom co, wori Yeecu acuwi fonure cuwonin. ");
INSERT INTO bsj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kambo Yeecu lau weyeri kung nuwe dii layico ki zakka yi rau wulom daten mwo da lomo. ");
INSERT INTO bsj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","La yilau wulumm-wulum yuwo co ki fuwor neret. ");
INSERT INTO bsj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","La gwam ciye cin to wori, ci ma fwennati ki, ya fura lo nii bwiranke. ");
INSERT INTO bsj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka kweni tii, ki to Teluwe, man. Kabkangum cweka miko more yob nane fuwa wine tana man yodiger nii cum wo ma yotiyeri, ma yila neti kiriti na'ar. ");
INSERT INTO bsj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeecu yi coki duwen fuloka bou fo luwe wurini nii co bi bwe Ibrayim. ");
INSERT INTO bsj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bi bwe nii bo na do kange fuloka nobo leme. ");
INSERT INTO bsj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Di di nuwe digewo digewo nyer. Con yoten coti tokki ki danke, wori co bi dom kange Urcalima. Cin tuken liyar kwamaro biyeken nawo. ");
INSERT INTO bsj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","La con yiciki nii dur cu bitine kange, ya ca yo liyar na co yilam. ");
INSERT INTO bsj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Con co, cangace kwob, la yi ciki kom yila kangi, ko tiye kom miye nakom fiya mwen dorcet, mimale yilau. ");
INSERT INTO bsj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","La nobo loce ko co, cin twom nob bwiko cek ki manya ciya ti niwo a ca ciyar dor nyer. ");
INSERT INTO bsj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","La ci ne nii wo liyoro, kambo co bou lo weri co tomi ki ciya cucine ne congetini na co nyomom kiyemero co ne ciyeu ki ciya yila kalakangtiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wi kabako be cinen ki Teluwe fam mwem bo we ma fiya mwen dorcet, fambo kwob. ");
INSERT INTO bsj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Liya yi co ki dong dong canga ken, wuri mo, maken dor dike bi dure, man nenen tako cunnucut do kwob. ");
INSERT INTO bsj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na yobe ce bo yitiki fam mwembo Teluwe ma fiya mwembo fam bo nung. ");
INSERT INTO bsj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Liya yicoki tom cunnukirning mwo tamciko. ");
INSERT INTO bsj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Na taarece bo yitiki, fam mwembo wo man yo ken co yora mor kulene, ");
INSERT INTO bsj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","man nuwa tai mwe to, wori mor ni funere, moki to tike mo yobe, mo biye dige mo fii be. ");
INSERT INTO bsj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Liya yi co ki ki ker mwer ma mamwer bo langtiye, mwo cange bwit mo nyomon moki mo man nii maki to re dike ma yobe, ");
INSERT INTO bsj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ye bwi mo yobo ki kye miro fiye bini kiyeme no bwiko ma bori na yo co ki mwen. ");
INSERT INTO bsj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Liya yi nobo tin wiye, kom yom fam bo co tan cike, kom niken niwo ki fam bo kwobbe. ");
INSERT INTO bsj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ciki Teluwe, wii ki fam bo kwob. ");
INSERT INTO bsj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Miki niwo ki dikereri, cin yok cinen ten, niwo man cikeri an yom tangnin bo cine nen. ");
INSERT INTO bsj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ki nobo biro koki yilare liya ciye kom bo ki ci fiyemi wii na twallangum ci fo kami. ");
INSERT INTO bsj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","La kambo co to kan nyeri cui ken Urcelima. ");
INSERT INTO bsj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kambo cibo bidom kange Betafaji kange Betani dor bange ci coti ki zaitun, co tom nob bwangka coko nyo yob. ");
INSERT INTO bsj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yi ciki, kom ya cuinukur do wureno ka kome. No com yari kanto be gelba kange tekum we kom kwiu. Kom bou men ciko. ");
INSERT INTO bsj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No nii kange me kom ki, 'Ye bwiyi kom kwi tiyeri? kom yi co ki teruwe cuitiye. ");
INSERT INTO bsj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nobo biro cu tom ciyeu yaci, fiya be gelba na wo Yeecu yiciyeu. ");
INSERT INTO bsj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kambo ci kwi be gelba tiyeri, nob gelba me ciki, ye bwi ci kwi gelba tiye? ");
INSERT INTO bsj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ciki teluwe cuii tiye. ");
INSERT INTO bsj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ci bo Yeecu nin ciko, cin miti kuleu ciye ro dor be gelba, co ci kun Yeecu ci yoti dorcere. ");
INSERT INTO bsj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kambo yaken tiyeri cimiten kulen ciyero ti dor nure ");
INSERT INTO bsj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Di con dedom yirakako kong zaitun, la nob tomange ceu cin ter bilantumbo ci wab kwamati ki diro dur wori nangeu nyo mamka ci to we. ");
INSERT INTO bsj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bibwiyer lamiyo fiye liya wiyewo boti den Tere fuwor neret firen dii kwama kange yorkako wo na duk kakoce. ");
INSERT INTO bsj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kangum Fariciyawa mor nob mwe kanka nyico ki ni murangka kwanan nob bwingka mweko. ");
INSERT INTO bsj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeecu yilci miyikum bi rin keti bwenteno nobo biro kumom di terentiyo ki bwiyici ciya bi lange ");
INSERT INTO bsj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Fiya Yeecu bou bidomri la ci lam bero cori la com ciwiyeu dor cer ");
INSERT INTO bsj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","tok ki, waki kom nyomom dike abou ti ki furnare di dila cumom nuwi kime mani ka to ti. ");
INSERT INTO bsj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dila diye boli mwinen, wo nob ki Yeecu mwe, ciyan mu ki yalange kentangum nen, ciyan kwenang mwenten culang ko gwam. ");
INSERT INTO bsj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ciyan kun kom bitine wari kange bi beiyo lomwe. Mani ciya dob kange terti dor kecer wori mo kabo bati fiya kwama cwinco tiken nenen. ");
INSERT INTO bsj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeecu do bicor wabe co la tir yuwanob miyankake, ");
INSERT INTO bsj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","yi ci ti ki mulangum mulange lomi a yila lo diko, kom yilam bwak nob kwiyeb. ");
INSERT INTO bsj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yeecu wi merang kang kang mor bikur waber. Dila dur wabero kange nob mulanka kange nobo dor noberoci cwiti na ci twallumco. ");
INSERT INTO bsj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Di la ci fiya bo nor maka, wori nobo cuwati ti cinen kambo ken. ");
INSERT INTO bsj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kange diye Yeecu merangti mor bi kurwabe, la tok furen kereuti nubo wabereu kange nubo dur ko. ");
INSERT INTO bsj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ci tokeroti ciye coti yiyo kibi kwan kero wini mon mam nan do wotiye. We nenen bi gwamdo woo. ");
INSERT INTO bsj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","La co ciya ciki meki kero mangmekom tiye nyo. ");
INSERT INTO bsj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","kange yuka mwen Yohana yerau di kaka nii fire nenka? ");
INSERT INTO bsj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Cin kobkanti, bwetici ciki tonou biki di kwamari anyiki yebwe bo nebo birinke cinenen. ");
INSERT INTO bsj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na la duwareu bi yi biki nifiro nendi no bo gwam cinye mobangbe ki ter, wori cin ciya mor mereciye Yohana nii to mange ");
INSERT INTO bsj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Cin ciya ciki yombo keno ki no feri. ");
INSERT INTO bsj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeecu yi ciki moken nyo mani yikamti keno kibo gwando wini ma man dike biromtiye. ");
INSERT INTO bsj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yi dubo danke wo kange nii yunkake inabi co ne kange nom tonen toka takeko conyaken bi ti ne kange ya daranyi kutangnyi. ");
INSERT INTO bsj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ki cwakiya bika bituweka ram cuii tom kange ceka ce ayo nob tone bone, beri naci neco mor dikero teige neneu. Di nob tonebo ci bunk, ci yoco kang koni. ");
INSERT INTO bsj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tom cenge ce tak ci bungco, cine co dotange, ci yweco kan koni. ");
INSERT INTO bsj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tomtange na ta'ar ce cin nuwacine der, cin merkeco kare. ");
INSERT INTO bsj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","La nii take Inabi ki, nye ina matiye? ma tom bi bweni macui. ");
INSERT INTO bsj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dila nob tone bo toco citokange bwitici, wo co nii coka gwarito bo twallum na kwalito yilam be. ");
INSERT INTO bsj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ci mwobken co bwiyim taken cin twallum co. Nyen teeluwen taken Inabi amaciticuke. ");
INSERT INTO bsj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","An bou na twallungum nob take bo wo na yila na neke nubo kenge takeu. Kambo ci nuwanyeri ciki, kwama acukum. ");
INSERT INTO bsj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","La Yeecu toci layiki. ");
INSERT INTO bsj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nii wo yar ti dor terero wonineri, an wurorangum. No nii wo tero yelti dorowonineri anfwoyok tamgum co. ");
INSERT INTO bsj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ci nob murangkako kange nobo dur waber cin cui naci tomco nawo wori an nyomom ki tokerewo dor ci, la ci cut an rubero. ");
INSERT INTO bsj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ci derangecoti cin tom nobo atoutiyeu wor ranyonri nubo weceke, na cifiya lentanke mor lekamor kercono ni, naci nekenco borank kange bi gwam nii dure. ");
INSERT INTO bsj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ci meco, ki Nii merangkan nyo yumom muki toka kange meranka dike donge donge tekeu kange nii men nawo dong bwinge kerdiye, muki merangka birin ket dor nure kwama. ");
INSERT INTO bsj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mino werfune ka no ya kemer dor kaicar, nin kaka o ong? ");
INSERT INTO bsj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yeecu nyomom yulkar yici. ");
INSERT INTO bsj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Nugmen dinari wuro wee, takeu munranka we dor cereu? ciki, “ki kaicer dike na kaiceroce komne kwama dike na kwace?” ");
INSERT INTO bsj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nob murangka kange dur tini nob wabe bere cifiya bo diker bitore mur keu ceroni. ");
INSERT INTO bsj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","nubem. Cin nyemruki ki cuka kan cone, ci tobo kangeker. ");
INSERT INTO bsj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kam cadukiyawa cibo ficowege, nobo wo yitiki gwamka tuke mani. ");
INSERT INTO bsj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Cin meco ciki “nii merangka” Musa mulang nye nen ki, no ni yiki no yini bwi yamdi, nii ki nawe la manki bibwe, nyice anan nawiye, afiya nyicenin bwe. ");
INSERT INTO bsj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kakum bi yiten wii niber wo kaboko nab nawe, lam bwe yam menki bwe, ");
INSERT INTO bsj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Inyo wo yobeu. ");
INSERT INTO bsj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wo ta'ar naco, nyo tangka wo nibe re dombo bi beiwi kom cin bweyam. ");
INSERT INTO bsj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ki bwili na wiye bwimken. ");
INSERT INTO bsj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Be diye gwanka duri, wiweco yira tiye. Wori cin nab na weye gwam ciye ");
INSERT INTO bsj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeecu yiciki biberyo dor bi dinene nakangetiye, cine cine citi naka. ");
INSERT INTO bsj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nyo kallo wo abou tiyeu, nobo wuro ne bilenke na kwen ka ko ceci nabaruboci manki na ka nawiye. ");
INSERT INTO bsj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mani ciya bwi yatiki tok, ciya yilam na biwei tonange kwama. ");
INSERT INTO bsj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dila co lam bidom kang bange zaitunedo bei tomangeco lacin teer bi langkako ci cenk lang kwamati ki diro dur. Wori nagen yumankako co mane. ");
INSERT INTO bsj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ci ki bi bwiyet atinyo liyowo aboutin mor den tee bei furneret di kwama kanae yor ka la duntanka. ");
INSERT INTO bsj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kagum Faricawa bor mwerkanka ciyico ki nii merangka, kwameu nob bwankar mwekoninten. ");
INSERT INTO bsj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yeecu ciya ciki, miyikom bi len keti no noboburo kamom di terotinibo andunktange. ");
INSERT INTO bsj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","La Yeecu lambidom ka kange berocori la ciweyeu. ");
INSERT INTO bsj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Naki kom nyom kakuwo kange dikewo abokimenti ki fawor neredi, naweu cin yurangum nuwe kume. ");
INSERT INTO bsj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kakuko we bo ti fiye kom wuyi wo nob kyeb kume bo a mu tiyak tiye, kentangum nen ciyam kwenang mwen ten, culangko gwam. ");
INSERT INTO bsj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cin kacimnen bitine wari kange biweiyo Lomewe, ma ciye tob tero kange dor kecer, wuro mo kabo bati fiya kwama cwiti na co fulone neu. ");
INSERT INTO bsj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yecu do mor bikurwabe la yuwa nob miyeka. ");
INSERT INTO bsj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Yi citi ku mulangum mulange Lomi a yila fiye kwobka dilo, di la kom yilam buwak nob kwiyeb. ");
INSERT INTO bsj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yecu meranti kang kang mor bikurwaber nebo dor wabero kange nob mulankab kange nobo durko cwiti twallum co. Di la ci fiya bo nure, wori nobo cuwatci ti cinen kambo keu. ");
INSERT INTO bsj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeecu, kun nuweri to nobo cuwe cuwe, buro mer luma mor bala yoka lumak. ");
INSERT INTO bsj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","To kange nawiye bune, fuyai mer aniniyoti yob mor. ");
INSERT INTO bsj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bilenke ma yi komti, nawiye bune, fuyai, meri la ciye gwam. ");
INSERT INTO bsj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gwam nobo wuro ne luma ciyeke mor cuweka ciye ko tenange nyeu. La nawiye fuyai bune, mor bune ce co merken kiyemer cero gwam, wo co cike. ");
INSERT INTO bsj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na wo kamenbo tok ker bikurwabe, kambo ci ma cimen bwayileneu ki tero keneu, neka luma. ");
INSERT INTO bsj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Dike wo kom to tiye, kakuko wi boti wo tero mani a yito dor kecereu na wo mani a bubatiye. ");
INSERT INTO bsj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","La cin me co ki, Nii “Meranka, fiyan dike wo a bwitiye? Ye a yilam yitom ti na dike borombo na yoten na bwikari? ");
INSERT INTO bsj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeecu ciya, ki kom ti ki bata, kari kange bol kom, diitce an bou mor dene mi, ci yi ti ki, “Man co”, na we dadom, kom bwang cinentende. ");
INSERT INTO bsj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tano kom nuwa ker kwenerdi kom kange dii bwali, kom cure, tamyo dike borombo a bwi bwiri, dila cwile mani a boiti nyo na wo. ");
INSERT INTO bsj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nyori con yi ci bero an kwenan bero ninten, liyar an kwenan liyaro ninteu. ");
INSERT INTO bsj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","An ma mukaka bitine ko wo tenang tenange fiye ki dimen ki dimen, take an ma wura kange wurolo. An maran yiromtaiyer kange yirombo dur dikwama. ");
INSERT INTO bsj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Fiya na dike wuro gwam, ciyan tam kom, ci ne kom dotange, ciyan neken kom mor kurbiwaber kange loni furcuna, ciyan boki kom kabom liyare kange nobo durtinim ki ker denemir. ");
INSERT INTO bsj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A yila kumen fiye ka tokom fulen miro tiye. ");
INSERT INTO bsj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ko to fo nerkumer, kom kade batito wo ya ko toktiye. ");
INSERT INTO bsj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mo ma nekom kero kange yilendo, wo nob kurome kume gwam, mani ciya dol kobkanka ti kange kome, kaka ci kim kerkume ro. ");
INSERT INTO bsj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kange Te, kange yitub, kange naniyak kange farub, ciyan kan kom, ci twallum kangem kumen. ");
INSERT INTO bsj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nobo gwam ciyan kokom kiker dene mi. ");
INSERT INTO bsj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yiri kume win wo mani a kwob ti, ");
INSERT INTO bsj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mor birum nekume kan fiyau dumetinim. ");
INSERT INTO bsj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tano kom to Urucalima kentangum ki nobo tee kwentiyeri kom nyomom yarka ceko dadom. ");
INSERT INTO bsj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nobo Yahudiya a cu ci yaken diyele kange, nobo tiber cinanlore ciya cu, ciya dobre nobo mwanlore ci dou mor. ");
INSERT INTO bsj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kakuko wo na yaka cunere ce, beri dike ci mulange gwam na dim. ");
INSERT INTO bsj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kwanci nubo ki fwereu kange nobe ne yir tiyeu mor kumetinwo! Annuwa dotange kambo ken wo tenang tenange bitinim. Ki funer fiye nobo wo wiye. ");
INSERT INTO bsj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ciyan yari ki caka kulener take a yaken ki ci canga bitine nin gwam, nobo manki kwama an duwarangum Urucalima ya ciko fiya nobo nyombo kwama ciye a dinitiye ");
INSERT INTO bsj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Atan yirombo mor kakuke kange cwiyak, kange bitiren. Dorbitine tak nobo nyombo kwama cin nuwa dotange, fwer ciyero an burom temi dir mwenger wima. ");
INSERT INTO bsj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","No a fumom ki ten kange kwaka neret dike a bwi dorbitinero, min. An mok kibikwam dii kwamaro. ");
INSERT INTO bsj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nimde ciyan to bibwe Nifire bo ti mor bilore ki bi kwan kange. Duktankako dur. ");
INSERT INTO bsj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dila nimde dike wuro ci ter bwikari. Kweni timtiye, la kun dor kumero dii, wori fuloka kumeko dadom. ");
INSERT INTO bsj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yeecu ne dangke, “To tii nyencen do kange tiini gwam. ");
INSERT INTO bsj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Na ci ter fu ka laluko, kan tom ki bwikom, komki Tirakko dadom tak. ");
INSERT INTO bsj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nyo tano kom to dike wuro ter bwikakori, kom nyomom liyar kwamaro dadom. ");
INSERT INTO bsj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Bilenke ma yi kom ti kaldo wo mani a cuti, dike wuro an bwi gwam. ");
INSERT INTO bsj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dii kok kange bitini an cum dila kermiro mani a cuti. ");
INSERT INTO bsj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Di kom kom ka bati ki dor kume, kati kom ne nerkumero tutum ki kwomka dorbitinero kange norangka, kange komka kwarcek. Dila kakuko an bo bati man. ");
INSERT INTO bsj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mwinin cito. Dila an bo dor nober gwam wo kwarce tikob dor bitinero nin gwam. ");
INSERT INTO bsj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dila kom yi ki bati kang kang, kom kwob diloti bena kom fiya bi kwam do ka torum dike woti gwam a bwitiye, kange kambo katimti kabum Bibwe Nifire”. ");
INSERT INTO bsj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ki kakuk, ki merangi mor bikurwabe, kume del yakenti bang ci cotiki zaitune. ");
INSERT INTO bsj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nobo gwam tura yaka fiye co wiyeki bwiri cin nowa co bikur waber. ");
INSERT INTO bsj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na wo nyori, duklume ma ci ca cari to yoten diker kunkar wiyeu, ci cuwoti yabkau dadom. ");
INSERT INTO bsj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Liyab wabebo kange nob mulangkabo, cin mwerkan dor, na ci fiya ci twalum Yeecu, La ci nuwa tai nibeti. ");
INSERT INTO bsj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","La bwekelkele dokenmor Yahuda Iccariyati, wo wiin mor kwob culombo yobeu. ");
INSERT INTO bsj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuda ya Liyab wabebo kange nabarub kwenebo nin, cin tokkangi kambo ca miyam Yeecu ti cineneu. ");
INSERT INTO bsj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Cin bilangi, takeu cin ciya ciyan ne co kyemer. ");
INSERT INTO bsj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Con ciya, La co do nurewo ca nekeng co ti cinen neu wo kebo tiber nubereu. ");
INSERT INTO bsj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nyori Yecu twom Bituru kange yuwana, yici ti, “kom ya ko ka bati cari yabka ko, wo ba catiye. ");
INSERT INTO bsj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Cin yii co, “Fee mu cwiti nyo ka bati cuwe?” ");
INSERT INTO bsj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Con ciya ci, “to no kom doken cinar lor di, kange wabkan nii kangetum ki tabwir mwenger, ko bwanten co luwe ca domtiye. ");
INSERT INTO bsj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“Ko yii nii luwe kom ki, “nii meranka yinen “fe ku fabubeu, fiye ma cam cari ti kange bi bei tomange me?” ");
INSERT INTO bsj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Can nung kimen kuwe dur ywelum ywela dii. Kom ka batiyo wi. ");
INSERT INTO bsj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","La cin ya, cin fiya dong-dong na wo co yii ciye, cin kam bati cari yabkako. ");
INSERT INTO bsj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Fiya ca ka cariko lam, con yiken kange bi bei tomange ceu. ");
INSERT INTO bsj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Con yii ci, “mi dilanti ducce nan ca corito wo kange kom, nyim re nan nuwa, dotange. ");
INSERT INTO bsj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","min yi kom, “ma ma cati tak yaken ciko bi diye Liyar kwama a dim tiye. ");
INSERT INTO bsj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yeecu tu kweleu, bwikoko ca ne buka kange ri, cin tiki, “tu wo na kom tikangum bwiti kime. ");
INSERT INTO bsj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Min yi kom man ma no mwem bi tutti ti tak yaken ciko bi diye Liyar kwamaro a boutiye, ");
INSERT INTO bsj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yeecu tu carito bwiko ca bu kange ri con wulangum cin neci, yi ci ti, “wo bwimi ci ne komme, ko ma wo na bulanka mi ko ce. ");
INSERT INTO bsj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cin tu kweleu bwiko cariko, con toki, “kwele wo na norro fwir ceu, bwiyale mi wo ci a corti ker kimereu. ");
INSERT INTO bsj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dii ko ti yora, kang niwo ko a miye, ye tiye wii kange mo fiye caka cari. ");
INSERT INTO bsj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bi bwe nifire an cu na wo ci yowe. La kwannen mo nii wo ma miye tiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","La cin yoten ci ti tokkangi bwitici we nii curo a miye co tiye. ");
INSERT INTO bsj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kwalkange kwenu more ciye dor, we nii na dure. ");
INSERT INTO bsj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Con yi ci, Liyab nubo nyombo kwama, teluwe dor cir kange buro ki bi kwang kere dor cireu, ciki cuwo ci ki nubo ma dikero keng tiye. ");
INSERT INTO bsj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mani a yilati nyo kange kom, nyori nii wo na dur more kime ri a yilam bwe biduware, kange nii wo yori La gwammeu, a yilam canga. ");
INSERT INTO bsj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nyori wo na dur gwammeu, co ci yime kaka na wo canga makimen nangen tiye? ");
INSERT INTO bsj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kimeu kom kange mo, cuwa mik. ");
INSERT INTO bsj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Min yoti kom dor liyarek na wo temi yoti ye dor Liyareu, ");
INSERT INTO bsj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","na ko ca, nako no kange mo, mor Liyare mi, kom yi kutile dumbo kwob culombo yob wo Iciraila ceu. ");
INSERT INTO bsj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siman, siman, bulangi, Bwekelkele do a neco mo, na co kwom nen na bi kate. ");
INSERT INTO bsj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Min kwob mwen dilo bilenkere mwe a yarde, no mo yilau tak ri, ne keb mwebo be kwamer. ");
INSERT INTO bsj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bituru yi co, “teluwe min kam bati man ya kange mo Fucina kange bwar. ");
INSERT INTO bsj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeecu yi co, “min yii neng Bituru, fiya na bicake mob kiyange ri, mwan ko nyomka mik kiriti taar. ");
INSERT INTO bsj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","La Yeecu yi ci, “Fiyo cuwo ma twom kom, man ki Liinge, cwaye kime kange tau, ye ka fiya be? Cin ciya co, “Mani” ");
INSERT INTO bsj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","La con yi ci, “caneko, wo ki cwaye kimere ca tu, kange cwaye kulene. Wo man ki yari ca miyem belle ce ca tiyenu. ");
INSERT INTO bsj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mi yii komti, “dike mulangum dor mire an dim. ");
INSERT INTO bsj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","La cin yi co ki, “teluwe, to kero kange wo yob”. Con yi ci, “La dim”. ");
INSERT INTO bsj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yecu cu bang zaitun na wo ciki mare, bi bei tomange ce bwanten co. ");
INSERT INTO bsj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","La ci Lamri, Yecu yi ci, “kom kwob dilo kati kom doken mor cuwaka. ");
INSERT INTO bsj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Con dubam ci kutanbo yora, con cunken bitine, kwob dilo, ");
INSERT INTO bsj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ki. “Te no mun ciya ri, tum kwele wo minen, kebo cwika mik, womweu a mani. ");
INSERT INTO bsj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","La bi bwe tomange kwama wusake cerkangu dii cinen, neco bikwanti. ");
INSERT INTO bsj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","La co mor dotange dur, con yokten kwobka diloko, La mukti cero yilam na bwiyale yaru ti bitine. ");
INSERT INTO bsj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","La con kwenu fiye kwobka diloko nin, con yilaken fiye bi bei tomange ce nin. Co fiya ci da dumti wori ciki fir neret. ");
INSERT INTO bsj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Con me ci, “Ye bwi ki da dumtiye? Ko kwen ko kwob dilo kati kom doken mor cuwala. ");
INSERT INTO bsj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Co tok kero ti wiri, nubo ducce cerkangu kange Yahuda, wiin mor kwob culombo yobe ti cinen kaba. Con bou bidom kange Yecu con korkan co. ");
INSERT INTO bsj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","La Yecu yi co “Yahuda, muki miye bi bwe nifire ki kor kanka ka?” ");
INSERT INTO bsj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","La nubo woro wari kange Yecu to dike wo bwitiye ri, cii ki, “teluwe nyo to ci ki kuleng ka?” ");
INSERT INTO bsj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","La wiin more ciye to canga liya wabe, to cewo caktiyereu mwatam. ");
INSERT INTO bsj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yecu ki, “Cuwati nyo”, con ke tu ceu, nyori twam”. ");
INSERT INTO bsj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yecu yi liya nob wabe kange nubo durko bi kur kwamareu kange nubo durko ci ciya co beu, 'ki, ka ceru ki kulenti kange danti ka ta nii kuye ka? ");
INSERT INTO bsj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Fiya cuwa mika kom kang-kang mor bi kur kwama reu ka yo bo kang minen. Wo kakuk kimek, kange bikwan kumtacile. ");
INSERT INTO bsj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Cin tam co, cin yaken ki co Lo nii wabe durko. Bituru bwen cinen ti kutang. ");
INSERT INTO bsj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Biko ci kwerum kira tiber lor bolange reu, cin cin yironken yiye, Bituru yiken tiber ciyer. ");
INSERT INTO bsj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kange nawiye canga to co, wori ci yim cunga kirak, con to co ti con toki, “Nii wuro wii kange co”. ");
INSERT INTO bsj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","La Bituru webkangum, ki nawiye ma nyom cobo. ");
INSERT INTO bsj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bi cor di, kange to co, yi ki. “Mo wiin more ciye” Bituru ki “bwayile, ma kebo” ");
INSERT INTO bsj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bwiko kene wiineu, kange ywim metenco, “Bilenke, nii wo wii kange co. ");
INSERT INTO bsj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bituru ki, nii man nyom bo dike mo tok tiye”, dancan ca dibo tokka kereko bar bi cake mob kiyange. ");
INSERT INTO bsj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Teluwe, yila to Bituru, La Bituru kwa ki kero Yecu yi ceu, fiya cuwo ci wariyeu, “Fiya na bi cake mob kiyange duwen ri, mwan wengkan ye kiriti taar. ");
INSERT INTO bsj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bituru yaken kale cii wiye kambo ken. ");
INSERT INTO bsj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","La nubo ci yo to Yecu tiye buwo malli co. ");
INSERT INTO bsj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kambo fini celtiye ri, nubo dur nibero mwerkangi fiye wiin, Liya nob wabe bo kange nob mulangkab, cin doken kico fiye nyime ciye, ciki, “no mo kiritti di yi nyo” ");
INSERT INTO bsj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","La con yi ci, “no nyikom di mani ka ciyati”, ");
INSERT INTO bsj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kakaa me kom di kan kar men ti. ");
INSERT INTO bsj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Min yi ki no mwo Krisiti ri yi nyo, La con yi ci ki “No yi komri mani ka yonmti. ");
INSERT INTO bsj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tano mwe kom kerdi mani ka yiye ti ");
INSERT INTO bsj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Fo ya ciko kab, mi bwe nifire an yiken kanko caktiyer kwama. ");
INSERT INTO bsj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","La gwam ciye cin yi co ki, mo bi bwe kwama ka? Yecu kar cinen “Kom ka tiki nye”. ");
INSERT INTO bsj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","La cin toki, “ye bwi ba do kange warke tiye? Bo ki bwibi ban nuwa nyi co” ");
INSERT INTO bsj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","La mwer kanka ceko gwam kweri cin bouki Yecu kabum Bilatu. ");
INSERT INTO bsj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cin teri ci mwel cinen ti, ciki, “nyim fiya nii wo lentang ti ki bi tineu beu, ywam neka dorek ti kaicar nin la ciki toki ciki “Co ki bwico cin kiritti, Liyau” ");
INSERT INTO bsj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatu me co, ki “Mo liya Yahuda wa ka?” Yecu ciya cinen ciki “mwi tok nyo” ");
INSERT INTO bsj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bilatu yi nob wabebo, dortinibo kange mwer kange kako ducce, “Ma fiyabo bwirang ke nii wonin. ");
INSERT INTO bsj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dila ciin tii tokkako ciiki, ci kung nubo nin neer ti, ciki merangi mor Yahuda gwam tabti Galili bou ciki fiye wo nin. ");
INSERT INTO bsj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","La kambo Bilatu nuwa weri, cin me keno Yecu nii Galili ri, ");
INSERT INTO bsj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","kambo ci nyimonki Yecu ki no biten liyare Bilatu weri cin tungken Yecu Bilatu nin, wo ki bwiico yim mor Urucalima ki kumeni curo weu. ");
INSERT INTO bsj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Fiyawo Hiridu to Yecu, cin bilangi wori ci cui, toka Yecu ti ki kwitangka. Cin nuwa ker dorcerla ci cuiti naci to diker nyimankako Yecu ma tiye. ");
INSERT INTO bsj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hiridu merang Yecu kero kila kila dila Yecu karci nen bo ker. ");
INSERT INTO bsj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nob wale bo durtini kange nob mulangkabo tii, mwelco ti kibi kwam. ");
INSERT INTO bsj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hiridu kange nob kweneb ceko torang Yecu, yila ci buo co. La cin du dinen kwilen do yor yore ricin yilaken kico Bilatu nin. ");
INSERT INTO bsj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","La Hiridu kange Bilatu yilam bifarak ki diye curo, no cin nob kiyeb bwitici. ");
INSERT INTO bsj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatu la cou nob wabeb durtimbo kange nob liyare bo wari kange nubo duce. ");
INSERT INTO bsj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","La cin yi ci, “Kom bo men ki nii wo na nii lentangti ki nube, la kom to, min merangco kakom ri mi fiya bo bwiranke cinen dor diker wo kom mwelcinen tiyeu ");
INSERT INTO bsj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mani, Hiridu ken yila binen ki co, la koto, kange diker mani wo nii wo mani lam bwere. ");
INSERT INTO bsj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","La man macinen bi mwerum nami nyem kang cinen”. ");
INSERT INTO bsj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","La nanger Bilatu na cok Yahuda wa nin nii wiin ki duk lume. ");
INSERT INTO bsj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dila gwamce cin kung diiro cuko wiin “ko cu ki nii wo, na ko cok nyinen Barabbal. ");
INSERT INTO bsj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabba nii wo ci dok ken Fucina ki kungka kiyana cinanlor kange twalka nobek. ");
INSERT INTO bsj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatu yiki ker tak, nui ti naci nyengun kang Yecu. ");
INSERT INTO bsj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dila cin kung diro, ciki “kulken co, kulken co”. ");
INSERT INTO bsj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Cin yici tanre ceu, “Ye bwiye, dikero bwirko wuni nii wo man? ma fiya bo bwiranke wo lam bware cinen. La kambo mi macinen bi mwerume ri man nyengum kang cinen” ");
INSERT INTO bsj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","La cin titen ki duro dur cii cuito na kulken co. Diir cero dok Bilatu ciyaka. ");
INSERT INTO bsj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","La Bilatu ciya kini cero, ");
INSERT INTO bsj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ciin nyengum kang wo ci meu nin, wo ci dok ken fucina ki kungka kiyancek kange twalka nubeke. Dila cin neken Yecu ki cuika ceko. ");
INSERT INTO bsj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kambo ci yaken ti kice ri, cin tam nii kange ciman wo kwane, ci ceru cinan lor, dila cin yo cinen ti kwoblom bwatiyem bo duncer, ci bwangten Yecu. ");
INSERT INTO bsj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mwerka nube ko duce kange wo natubo ceu wo ii co Hiridu, ma kang bwaa ti dor cereu. ");
INSERT INTO bsj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dila cin yila cinen di, Yecu yiki, “Bi wutobo Urucalima, kom cire wiye dor miirm dila kom cii wiye dor kumer kange dor bibeyo lakumeu. ");
INSERT INTO bsj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","La kom to, kumeni ber wo ciya tok ti ki, “Bi bwiyer ki nubo burombo combulome kange burom bo ci nom bo yiir cero wiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","La ciya teri ci yi bangtini ko ti, “Yaru dor nyer' kange dunletini, cumom nyo. ");
INSERT INTO bsj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","La no ci yan ma dikero buroki kwama wo tiyo yibereri, ye a bwi tiye no ci kwicimri?” ");
INSERT INTO bsj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nubo kangem bo, nob bwirankereb yob cin yaken kici kange co naci twalci wari. ");
INSERT INTO bsj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ki kwama wo ci bou fiye ci cuo ti ki “Kwace duce” wi ci kui co kange nob bwirangkebo yobeu wiin kanko catiyer cer la wiin mok ceko nin. ");
INSERT INTO bsj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yecu yi ki, “kwama, yabcinen wori, ci nyombo dike ci ma tiyeu”. La ciin mer dacen, ciin tikangum belle ceu. ");
INSERT INTO bsj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nubo tirangum ki toi kambo liyab cebo buwo co ti ken ki “cin cer kangeribo. Ca cer dur cero no cin kiritti kwama, wo ci cokke ri!” ");
INSERT INTO bsj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nob kwenebo nung co ken, bouti cinen, cine co mwembo fuwar ti, ");
INSERT INTO bsj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ciki toki ki “No mo liya Yahudawari cer dor mwero”. ");
INSERT INTO bsj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","La yirome wi dor ceer, “Wo co liya Yahudawa”. ");
INSERT INTO bsj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wiin mor nob bwirangke wo ci kulken ci wari yeu to co ki “Mwi kebo kiritti ya? cer dor mwero kange nyo”. ");
INSERT INTO bsj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dila wincu werank co, ki, “Mani mwi cua tai kwama, kambo mwi mor bolang bwarek ko dong-dong kange ca? ");
INSERT INTO bsj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Be bifo weu dong-dong, wori bi ki yo diker date kange dike bi mane. Dila nii wo mabo dikero kange yorbe” ");
INSERT INTO bsj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","La coki, “Yecu, kwi kimo no miw bou mor liyar mwek ri ");
INSERT INTO bsj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yecu yi co ki “Bilenke ma yinenti, duwen mwan yi kange mo mor dii kwama”. ");
INSERT INTO bsj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","La ki kwama wo kan kene ko nukkune, la kumta ciliu cumom dor bitinero gwam yaken cuko kang kene ko teer, ");
INSERT INTO bsj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kambo meu dome ri, yilanko mor bikur kwama re woran more yob. ");
INSERT INTO bsj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ki wiye ki diro dur Yecu yiki, “Te, min neken dumemi kang mwek”, kambo ci tok we ri, cin bwiyam. ");
INSERT INTO bsj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","La kambo nii dur nob kwenebe to diker maneri cin duktang kwama, ciki, “bicom, wo nii cak-cake”. ");
INSERT INTO bsj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ki kwama mwer kangka nobo duce wo bou na ci to dikero bi mane ri, cin yilaken ci kwa cang-cang ti. ");
INSERT INTO bsj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dila nubo gwam wo nyumom ce, kange natubo bwangu co Galili yeu, cin tim kutan, cii to dikero buroti. ");
INSERT INTO bsj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","La nii kange wi dendo ki Yucufu, wo wii mor nobo dure. Cin nii ken, ri cin nii cak-cake. ");
INSERT INTO bsj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nii wo ciyabo kange dikero ci fuwa kangeu kakaa dikero ci mancu. Ci ceru Arimatiya, bi ten Yahuda, la ciki nintang liyar kwamak. ");
INSERT INTO bsj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nii wo, ya Bilatu nin, la cin keni na neco curen bwi Yecu. ");
INSERT INTO bsj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cin cuku, cin cumon ki yilank linin ko ken. La cin yoken mor tuwe wo ci cuwe cuwe mor tere, wo ci fwerum bo nii wi yeu. ");
INSERT INTO bsj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kakuko co kakuk ywelkak, la kakuk fobka Yahudawa ko dadum. ");
INSERT INTO bsj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Natubo wo bou kange Yecu Galili ye bwangten lacintom tuweu. Kange kambo ci yom bwi ceu. ");
INSERT INTO bsj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cin yilaken la cin ywellang kwilendo Ficange kange nuwang. La ki diye fobka Yahudawak ri cin fubom nawo werfundo to keu ");
INSERT INTO bsj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ki kwomje kikume kume niberece cin bo tuwenim, cinbouki kulen tuika kuneko ficang ficang woci ywelleu. ");
INSERT INTO bsj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ci fiya tero tun ken tunngen cunge tuwek. ");
INSERT INTO bsj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Cin doken morece, dilaci fiyabo bwi Yeecu. ");
INSERT INTO bsj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Inbwiu kambo cimor kwobtangka dikekebwiuweri, nubo yob tirarim kabumci ki kulendo fuwe cukcukke. ");
INSERT INTO bsj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","La natubowo cunken ki dorciro bitine worintai, cin yo natuno, “yebwi komdo nikidumeti nor buware? ");
INSERT INTO bsj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Manifo lan kwennum! kambo ci yimko ker ki kwamawo ci Galili, intoki, ");
INSERT INTO bsj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ciyan nekan bi bwe niffire kang nob bwiran keb la ciyan yei kenco, kikume taare ankwenumtak”. ");
INSERT INTO bsj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","La natubo kwaki kercero! ");
INSERT INTO bsj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lacin dubom tuweu cin yilakeng laciyi kwobculombo winneuwuro dekero birombo kanngu tangneu gwamm. ");
INSERT INTO bsj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maryamu magdaliya, yuwana, Maryamu ne Yakubu, kan'nge tangne natubo ci wariyeu cine nob toman'ngeb cebo fulen dikorowuro bwiyeu. ");
INSERT INTO bsj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dila nobtoman'ngebcebo tu kero muni kebo diker maka nangenek, dila cinebo bilinke natubowonin. ");
INSERT INTO bsj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kwarub kan'nge wo Bituru kweni, cwayya tuwenin, cunken torang moreuti, lacinto lalanggo fuworgo kikwace. Lana nyime Bituru yaken loco, lata nyimang di bweweuti. ");
INSERT INTO bsj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kikakucori, inwonyo yob wo more yakanti cinarloro kan'nge dende Imawu wuro kutankaceko nan. ");
INSERT INTO bsj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Citi fuwakan'ngi ko bwitici kangediwo yaa bwiweu. ");
INSERT INTO bsj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yilam kambo ci fuwakamti wari kange meka kerekeri, Yeecu ki bwico boubidom cinen yakenti kanyeci. ");
INSERT INTO bsj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","La nuweceu dolbo nyobkaceko. ");
INSERT INTO bsj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","“Yeecu yici, inye kom tokkerti dorcere kambo kom yakentiyeu?” Cintinwifiyeco laci cii bwatumbotiwi. ");
INSERT INTO bsj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kaci tun kan'nge morece nendo kiliyobac, lan ciya cinen, “Mwowin cwar niwo Wurcalima wo nyombo dike birombo bwiuwe firen kikabake ki kumenicuo? ");
INSERT INTO bsj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeecu yico, “bikulentito wini?” Cin ciyaco, dikerotin kan'nge Yeecu bwe Nazaret, wuro buwe tomanye, woki dikerotinimbo dur, kan'nge kertinimbo dur fiye kwama wiyeu kan'nge nob. ");
INSERT INTO bsj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ki ciyaka nob wabero dur kan'nge nob li yareb nyebo ci nekenco naci warco naci kulkentencotak. ");
INSERT INTO bsj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dila nyin yoner nyiki cowo a cer Icerelatiyeu. Nyo, nobo nawori, naweu kume Taar dikero birombo bwiuwe. ");
INSERT INTO bsj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dila aa di duweno kowo, kamnyum natubembo nyi wariyeu ma nyinen diker nyimankartinim, ki yancimbo tuwe kiburiceu. ");
INSERT INTO bsj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kambo ci fiyabo bwiceri, cinbom, ciki cikeneu cinto dukum nobtomanyebo burombo yici ki wi kedume. ");
INSERT INTO bsj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kannyum nabarob wuro wari kannye nyeu cinya tuwenin, yafi kwabti nawo natubo tokeu. Dila ci tocibo. ");
INSERT INTO bsj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeecu yici ki, “Kom nob kuleneb nubo nebo bilinke dor dikero nob tomanyeb dukumebo tokeu! ");
INSERT INTO bsj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yilabokang kiritti anuwa dotannge dikero biromba, laken mor duktang kaka?” ");
INSERT INTO bsj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dila kikab wi mucanim yaken ciko nobtoma'ngobonin kwarub. Yeecu futang cinen dikero kaminge co. Wibe fumertinimbonin gwamm. ");
INSERT INTO bsj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kambo cilam cinar loroce fiye ci yakenti wuyeri cabunane Yeecu maa nadike muncan cuken. ");
INSERT INTO bsj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dila cin dokco ki, “yiken kan'ngeci, wori wori meu dadom kakuko do dikati. “La Yeecu ya yiken kan'nge ci. ");
INSERT INTO bsj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bwiuki, kambo ciyiken ci naci cacarite, intu Tiilita, kambo ci yoten bibuyer wiyeri, kiyannyi, lanneci. ");
INSERT INTO bsj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lamwo nuweceu wumwom, kambo cinyimocin ciri, lalem kaci, ");
INSERT INTO bsj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cin yi butice, wendi mani twirangbobo mornerber, kambo citok keroti kan'ngebo dor nurereu, kambo ci wombinen bifumertinnimbeu?” ");
INSERT INTO bsj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lacin kweni ki kwamaco, cin yiken wurcalima. Cinfiya culombo wineuwo wari, kan'nge birombo ciwari kan'nge ciyeu, ");
INSERT INTO bsj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Ki, kibicom kwama kwenum, inbow cimanin”. ");
INSERT INTO bsj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Laci tok dikero birombo bwiu nureu, kan'nge kambo ci fwetang cinen Yeecu kambo kiyan Tilita. ");
INSERT INTO bsj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kambo citikang dikerobirombo tiyeri, dila Yeecun tii tibercir, dilla yici, “fuwer nerer kumer”. ");
INSERT INTO bsj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dilla cin fakla cin dimkitani, cikwatiri cin tom wulo. ");
INSERT INTO bsj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yeecu yiciki yebwi kom kwomdortiye? yebiro meke kunouti morner kumere? ");
INSERT INTO bsj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","To kanimiu kan'nge Nanimiu, la muo kan'nye muo. Teiye nakomto. Wulo manki bwi kan'nge yiri, kambo komto nicikeu”. ");
INSERT INTO bsj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kamboci tokweri, lacin nung cinen kaniceu kan'nge naniceu. ");
INSERT INTO bsj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kamboci dimki fuwer nerereu, kan'nge nyimanka, Yeecu yici, “Komwiki kan'nge cariya?” ");
INSERT INTO bsj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lacin neco jinnge belumbeleu. ");
INSERT INTO bsj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yeecunyo cam kabumcim. ");
INSERT INTO bsj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lanyici, “Kambo miwari kan'nge komeu minyikom miki gwamm nike cimuleng wertun mucar kan'nge nentomanngeb kan'nge zaburau atin dii kang”. ");
INSERT INTO bsj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lacin wumwum nerciro naci nyimwom bifumertininbo. ");
INSERT INTO bsj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yici, “mulangum mulannge, kiritti annuwa dotange, amkwenum an kwenum tuwe ki kume taare. ");
INSERT INTO bsj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Komwab dencero kan'nge dobka bwirang kerer mor denece gwamm mor nube, komteri wurucalima. ");
INSERT INTO bsj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kom nobwarib dikero birombo. ");
INSERT INTO bsj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Too, mi twomutiki nor Teemiro dor kumer. Dila kom cini bitinece, catin tunkumen bikwan firen dii.” ");
INSERT INTO bsj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lananyime Yeecu yaken wari kna'nyeci yaa cilam Betani. Lankun kanceko yocimeti bibwiyerwi. ");
INSERT INTO bsj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yilam kamboci yocinten bibwi yerotiyeri, dubomci lacim tumco cin yakenkico dikwama. ");
INSERT INTO bsj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lacin wabco, cin yilarangum wurucalima kifuwor nerer ducce. ");
INSERT INTO bsj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kicatec cimor lokwama cine dencore bibwiyerti. ");
INSERT INTO bsj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ki kaba kero wii, lakero co kino kange kwama, la kero co kwama ");
INSERT INTO bsj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","co wuro kange kwama ki kaba ");
INSERT INTO bsj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","dikero gulam kebo ci nen la dikero kange mani wo ci mani kebo ci ne ne. ");
INSERT INTO bsj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","dumi kino cinen, la dume cuo co filank nubo ko gwam ");
INSERT INTO bsj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","filanko weni mor kumta cili, la kumta cili labo bi kwan cero. ");
INSERT INTO bsj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","nii kange wi kwama tomu we, wo dencero Yohanna. ");
INSERT INTO bsj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ci bou naci war kedor filangeronin lana nubo gwam na ne bilengke ki warke ceu. ");
INSERT INTO bsj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanna kebo filanko, la ci bou ri naci ne karke dor filankero nin ");
INSERT INTO bsj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","filanko kendo, wo ne nubo gwam filangeu, bou ti dor bi tiner. ");
INSERT INTO bsj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","cin wi dor bitiner, cii ma dor bitinero cinen la dor bitinero nyom co bo. ");
INSERT INTO bsj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","cin bow wo cee nin di, wo ceu yõ co bo. ");
INSERT INTO bsj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","dila gwam wo yoceri, wo ne bilenke ki dencereri, cin ciya cinen cii a yilam bi bei kwama ");
INSERT INTO bsj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","buro ci ka bo ci kebe ki bwiyele kaka a ki cii ka bwiyek kaka cui ka niik la ki cui ka kwama ");
INSERT INTO bsj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","kero wo yimla bwi la yi kange bo. bin tom duktanga ceko, duktanga nawo wiin cuar bow kwamanine, diin ki lima kange bilen ke. ");
INSERT INTO bsj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanna ne warke dorcerla toki kibi kwan ki “wo co wo mitok ker dorcer miki “cuo wo bou bwikom mikeu laye dwika la cin beken ten minen.”' ");
INSERT INTO bsj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","wori mor diika ceko gwambe bin yo luma dor lumar. ");
INSERT INTO bsj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","la werfundo bou kang mucak. luma kange bilenkeu bou kang Yeecu kiritti. ");
INSERT INTO bsj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kange man wo tom kwama wiye, kwama wiin cuar wo yim cunga tee, la cin nung binen kwama ");
INSERT INTO bsj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","won co werka Yohanna, ki kwama Yahudawa mor Urucalima tuom nob wabeb kange lewiyawa cinen naci me co “mwin we?” ");
INSERT INTO bsj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","cin toki, ci cuerbo cuerke, la cin tok bilenke “mi kebo kiritti.” ciki, “mi kebo” cii ki, mo nii tomange dukume?” cin “o-ong” ");
INSERT INTO bsj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","la cin yico ki mwin we, la nanyi fiyam dike nyi yi nubo tuomou nye ti? mwiki tok mwiki ye dor mwer?” ");
INSERT INTO bsj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ciki “min diir, cuo bi cuor ti mor yere, kom ywelum nure kwama ciyer, dong-dong nawo kaya nii tomange dukumeu tokeu.” ");
INSERT INTO bsj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ciin tom kangenbo mor nob dinglingeb, ");
INSERT INTO bsj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","la cin me co, ri cin yi coki, “yebwi mwi yu mwem tiye no mwi kebo kiritti kakaa, Iliya kakaa nii tomange dukumeri?” ");
INSERT INTO bsj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanna ciya cinen ki miki yu mwembo ki mweb. dila kange wi tim more kume wo kom yom beu ");
INSERT INTO bsj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","co wo bou bwi miyeu, duka taceko mi labon kwi. ");
INSERT INTO bsj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ci ma dike buro baitanya dinge urdun ne wi neu, fiye Yohanna yum mwembo tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","cyel fini ceri Yohanna to Yeecu bou ti cinen la ciki, “to, be kweme kwama wiren wo tunm bwirnan ker dor bitineu. ");
INSERT INTO bsj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","co wo mi yi kom miki, wo bou bwikob mike laye, wori ciki no kabum minin ");
INSERT INTO bsj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","mi nyom co bo, la na nung Iciraila nin co, mibou mi yu mwem kwamambo tiki mweme. ");
INSERT INTO bsj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanna ne werke ki min to yuwa tangbeko yirauti dii kwama na nagumfe ri yi ken dor cer. ");
INSERT INTO bsj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","mi nyom cobo, dila cuo wo tom ye ki yu mwem kwamambo ki mwemeu yi ye ki, dor nii woro mwi to yuwa tangbeko a yirauti na yitiyeri, cou wo ayu mwem kwamambo tiki yuwa tangbeke ");
INSERT INTO bsj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","min tom ri. min ne werke wo bi bwe kwama.” ");
INSERT INTO bsj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","tak, ki cel fini, kambo Yohanna tim kange yob mor kwanka ceke, ");
INSERT INTO bsj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","cin to Yeecu cuken ti, dila Yohanna ki to, be kwame kwama,” ");
INSERT INTO bsj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","nob bwankab ceko yobeu nuwam dila ci toke la cin bwangten. Yeecu ");
INSERT INTO bsj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","la Yeecu yila nuwe to cii bwang cinen ten firi ci ki “ye ko cuii tiye?” cin ciya co, “rabbi (wo no yila kangum ri co “nii merangka”), “mwi ki da fe?” ");
INSERT INTO bsj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","cin yici, “kom bou nako to,” la cin bow cin to fiye ci dam tiyeu, cin dam wi kange co ka kuko cou la darum kange kang kenekko teer. ");
INSERT INTO bsj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","wiin mor nubo yobeu wo nuwa Yohanna tok ker di bwangten Yeecu, andiranwuc yi cimon Bitruc. ");
INSERT INTO bsj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","cin terri ci fiyan kece Bitruc la yi co ki” nyin fiyam Almacihu (wo no yilangum ri co; kiritti) ");
INSERT INTO bsj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","cin bou ki co Yeecu nin, la Yeecu to cori ki “mwin ci monbi bwe Yohanna. ci ya co nen ki Kefac “(no yila kangumri Bitruc)” ");
INSERT INTO bsj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ciel fini ce ki kwama wo Yeecu cui naci cu cielili, cin fiya Filibuc lanyi co ki, “bwang menten.” ");
INSERT INTO bsj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","la Filibuc ceru'u Batcaida, cinan lor Andrawuc kange Bitruc. ");
INSERT INTO bsj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibuc fiya Natana'ilu yi coki, “co wo muca mulangi dor cer mur werfuneu, kange nob tomangeb dukumere, nyim fyam co, Yeecu bi bwe Yucufu wo Nazaret.” ");
INSERT INTO bsj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyelyi co ki dikero ken antin ceru mor Nazaret ka? “Filibu yico, “bou na to.” ");
INSERT INTO bsj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeecu to Nataniyel yauti cinen la tok ker dor cer “to nii Iciraila kendo, wo cuwer ke mani cineneu.” ");
INSERT INTO bsj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel yico “ma nyi mwi nyimom yere?” Yeecu ciya co la yico, na nyimde Filibuc co nen ki kwama wo mwi yim dimer tiir nying cine min tom nen.” ");
INSERT INTO bsj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel ciya cinen, nii merangka mwibi bwe kwama mo liya Iciraila “ ");
INSERT INTO bsj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeecu ciya lan yico, wori min yi nen miki min tom nen dimer tiir nying cin, mwi ne bilenke? mwanto dikero dur tini la weu.” ");
INSERT INTO bsj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","la cin yici ciki bilenke, mi yi komti, kom to dii kwama wumom la nob tomangeb kwama ki kwii ki yirai dor bi bwe nii fire.” ");
INSERT INTO bsj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","kanbo kume ta'ar cuineri, naakak wii mor kana wo Galili la nee Yeecu wi wi. ");
INSERT INTO bsj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","la cin yi Yeecu kange nob bwangka cebo naci fiya yaki ken ");
INSERT INTO bsj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","kanbo mwem Inabi dimmeri, nee Yeecu yi co ki “ci manki mwem Inabim.” ");
INSERT INTO bsj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeecu yi co ki, nawiye, ye bwi mwi bou minene? kwama mi la bo bwirin” ");
INSERT INTO bsj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","nee ce yi canga tininbo ki “bwen no ye ci kom meri, ko mani ");
INSERT INTO bsj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","la cir mwenge tereko wi nyo nukkun wo Yahudawa ki manade nangen ciko wo niir kako wuccake ci le rum makake, cikin tuum nyo ceer leer ro kwob-kwob gwance ");
INSERT INTO bsj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeecu yii ci, “ko dirongum ceer mwengero buro ki mwem “la cin diirongum cuko mer-med ");
INSERT INTO bsj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","la cin yi canga tinimbo, “ko bwi naweu ya ki nee duur cika ro la cin bwengten wo yilam mwem Inabi ye, dila ci nyom bo fiye ci bow cikeu (dila cangatinimbo buro tuwau mwembe nyumom). la cin cou nii na nawiyeu ");
INSERT INTO bsj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","la duur cikaro twi bwembo wo yilan mwem Inabi ye, dila ci nyom bo fiye ci bow cikeru (dila cangatinimbo buro tuwau mwembe nyumom) la cin cuo nii na nawiyeu ");
INSERT INTO bsj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","la cin yi co “nubo ki ter neka mweb Inabim bo kenko ki kaba nanum de wo lombo yorau bwangten. dila mwein yoken kenko la mwi coku ti na wonyo” ");
INSERT INTO bsj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","woco diker nyiman kako Yeecu mani mor kaka wo Galili yeu, la cin nung dur tangka ceko, la nob bwangkab ceko nee bilenke cinen ");
INSERT INTO bsj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","bwikom wuro ri Yeecu, nee ce keb cebo, kange nob bwangkab ceko yira ken kafar nahum, cin yi ken wi kume ni bi duwar ");
INSERT INTO bsj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","la dukluma yahudawa ka dadom, Yeecu yaken Urucalima. ");
INSERT INTO bsj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","cin fiya nob miye ka nennek kange kwama kange nawurme mor bikur-waber, kange nubo fulong kemer tiye yirongum wi. ");
INSERT INTO bsj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","la cin ywel belyange ki duka, lacin cikangum ci gwam mor bikur-waber, kange kwama, kange nennetini. cin watangen kemer nubo fulog kemer tiye wi cin tungagum tabur tini ceu ");
INSERT INTO bsj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ki nubo miye nawurme tiye ciki, “kocer ken ki dike buro. ko dubom yila kako ki lo temi fiye miyeka dikere.” ");
INSERT INTO bsj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","nob bwangka ceko kwabi ki mulangum mulange” kor lo mwero cam ner miro “ ");
INSERT INTO bsj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","la nubo dur Yahuda ciya, yi co ki, “yirom bo wuni mwanung nyinenti wori mwi marang digero buro tiye? ");
INSERT INTO bsj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeecu ciya, “ko werum bi kur wabero wo, la mor kume ta'ar mang kung ti ");
INSERT INTO bsj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","la nubo dur tini Yahuda ki bi kur wabero wo to cotiro kwini na'ar culombo nukkun na nyi me ci mu la mwan mum co mor kume ta'ar? ");
INSERT INTO bsj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","la, ciki tok kange bikur-waber bwi cero. ");
INSERT INTO bsj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ki kwama wo cii kungu ki cin co bwanreu, nob bwangka ceko kwabi ki cin tok ker nyo, la cin ne bilenke ki bi fumero kange kero wo Yeecu tokkeu. ");
INSERT INTO bsj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","24","la ki kwama wo Yeecu mor Urucalima ki cika yabka, nubo duce ne bilenke den cero kanbo cii to diger nyimanka ko ci manen la Yeecu ciya bo kange ci wori cin nyimom ci gwam. ");
INSERT INTO bsj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","kange ayi co diker dor niir, la cin nyimom dikero mor niireu. ");
INSERT INTO bsj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","la ni dinglime kange wi wo den cero Nicodemu, nii dur Yahuda. ");
INSERT INTO bsj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","nii wo bow Yeecu nin ki kume la yico, “Rabbi, nyin nyumom mwin nii merangka wo bou kwama nine, wori nii kange mani wo ama diker nyimangkako mwi mane ri no kwama mani kange cori.” ");
INSERT INTO bsj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeecu ciya cinen, “bilenke, no cii bo nii takri, mani ci to liyar kwama ti” ");
INSERT INTO bsj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodimu yi co “ciya boten nii nyi ki kwama ci cirame? mani ca do mor fwiye nee ce ti kiritti yob naci bo ten co, can do wa? ");
INSERT INTO bsj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeecu ciya,”bilenke, bilenke, no ci bo bo nii ki mwem kangi yuwa tangberi mani ci do liyar kwamak ti. ");
INSERT INTO bsj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","wo cii bo mor nange ri nange, la wo cii bo mor yuwatangberi, yuwatenbe. ");
INSERT INTO bsj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Niyimangde wori min yi nen miki tam nyo cia fulongum boka mweko. ");
INSERT INTO bsj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","yiwako ki cui fiye ci fobi, mwan nuwa diir cero, dila mwi nyombo fte cibow wiyeu kaka fiye ci yaken tiyeu. nyo kange nubo gwam wo ci bo co mor yiwu tangbeke.” ");
INSERT INTO bsj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodimu ciya lan yi co “dikero wo a manyi? ");
INSERT INTO bsj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeecu ciya lan yi co “mwin nii meranka Icirailari durwal mwi nyombo digero wa? ");
INSERT INTO bsj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","bilenke, bilengke ma yinenti tok ike nyi nyomeu, nyi nee to-e. di duwal kom yo bo warke nyeu. ");
INSERT INTO bsj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","no min yi nen diker dor kalere mwi ne bo bilenke ri, mwa nee bilenke nyi no yinen dor diker dii kwama ri? ");
INSERT INTO bsj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","nii kange mani wo kwiken dii kwama no cum co wo yirau dii kwamari bi bwe nii fiye. ");
INSERT INTO bsj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","na wo ci yam kung bi bwe nii fiye dii, ");
INSERT INTO bsj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ri la gwam wo nee bilenke atin fiye dume di riye. ");
INSERT INTO bsj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","kwama ciu kale wo ri cin neken bibwe ce wiin cuar, la wo ne bilenke cineneri mani a bwiya ti la wi ki lai dume diriri. ");
INSERT INTO bsj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","kwama tungu bo bwew mor kalewo na kume dor bitinero dila na dor bitinero fiya fuloka fiye ci wiye ");
INSERT INTO bsj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","wo ne bilenke cine neri mani a bwiya ti, wo nebo bilenke cine neri, kweri bwiyam bwiya wiro ci nebo bilenke ki den bi bwe kwama ro wiin cuwareu.” ");
INSERT INTO bsj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Won co dike bwi bolang filang ko bou dor bitiner, nubo cwi kuntacile la filang ko, wori nangen cero cile. ");
INSERT INTO bsj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","No wo ma bwirang keri ko filang ko, bou bo filang nin wori nangen cero nungi yanglang. ");
INSERT INTO bsj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bwen dwal nyiri, niwo ma bilenkeu, bou filang ko nin na nungi yang lang, nangen cero na kwama ce co mane. ");
INSERT INTO bsj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bwikowo Yeesu kange bibei tomange ceu cuu biten Yahudiya, co yim wi lenger kange ci kange yuka mwengek kwamak. ");
INSERT INTO bsj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuwanna yuu mwem ti Ainon bidom kange Salima wori mwembo bidom wi. Nubo bouti cinen con yuu cinen mwembo. ");
INSERT INTO bsj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Fiya Yuwana ci tung bo furcuna bwiri. ");
INSERT INTO bsj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kwalkang ke kweni tiber bibei tomange Yuwana kange Yahudawa, ker maka duklumek. ");
INSERT INTO bsj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Cin ya Yuwana nin cin yi co ki, “nii merangka, nii wuro kange mweu dinge kon caji Jordaneu dor we? mo ware, too, co yuu mwem ti, takeu gwam ci yaken ti ci nin. ");
INSERT INTO bsj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuwana kari, “Nii mani a yoo kange diger ti, tano ci ne co dii kwamari.” ");
INSERT INTO bsj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mo ki bwimi mwan wari, man toki ma kebo Kiristi', dila cin twomou ye nimde co. ");
INSERT INTO bsj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bine ki nii bine, dila fakuwe nii bineu wo ti nuwa ceu, bilange ducce ki dir nii binero, wuro, co bilangtum mimbo kambo ken. ");
INSERT INTO bsj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ca yokten miu man yiram. ");
INSERT INTO bsj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nii wo bou diyeu, la gwam. Nii wo dor bitenereu, ki no dorbitinerer, tok diger ti dor, dorbitinere. Nii wo bou dii kwamau la gwam. ");
INSERT INTO bsj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Co war kerti dor digero co toweu kange co nuwau, dila kange man wo ciya warke ceu. ");
INSERT INTO bsj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nii wo ciya warkeceu, co nungi kwama nii bilenker. ");
INSERT INTO bsj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","La nii wo kwama tun ceu tok ker kwamar ti. Co nebo yuwa tangbe ki cuwaka. ");
INSERT INTO bsj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tee cwi bi bwece, neken co digero gwam kang cak. ");
INSERT INTO bsj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nii wo ne bilenke ki bweri, dume na ce, nii wo nuwabo bweri mani ca to dume ti, cwika kwama ko a yii kange co. ");
INSERT INTO bsj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","kambo Yeecu nyumom tancawa nnwam co fiye ten bi bei tomange ti, co yii' cinen mwem kwama ti lan wo Yuwana ceu, ");
INSERT INTO bsj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(bwen no na kebo Yeecu ki bwici yu cinen mwembo tiyeu, bi bei tomangece.) ");
INSERT INTO bsj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","con dubom Yahudiya con yilaken Galili ");
INSERT INTO bsj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","la tam co tiyangi camariya. ");
INSERT INTO bsj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","la con bou cinen lor camariyaro kange wo coti, cika, bidom kange fiye Yakubu ne bi bwe ce Yucufu. ");
INSERT INTO bsj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","bwir Yakubu ro ki no wi. kanbo luwam Yeecu ki yamcem be ri la con yii ken kong bwirie. dong dong kamg keneko nukkun. ");
INSERT INTO bsj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","nawiye camanya kange bou a tuwa mwem, la Yeecu yii, neye mwembo nan nomwi, ");
INSERT INTO bsj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","nyeu bibei tomange ceu doken mor cinan lor a teyer cari. ");
INSERT INTO bsj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","la nawiye camiriya yii co la a manyi mo mon bayafude mwa me yeti mo min nawiye camariya mwem no kam tiye? Yafudawa mani yabkan na kange camariyawa. ");
INSERT INTO bsj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeecu kar cen cinen na mon nyumom luma kwama ri, kange co nii wo yii nenti ne ye mwem nokameri, namotin ken co yii nentin ne nen mwembo ki dumeu. ");
INSERT INTO bsj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","nawiye yii co, nii merangka, mo manki tabwir, bwiro cuwa kabo, la mwa fiya mwembo ki dume fe? ");
INSERT INTO bsj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","be mwa la bo tenge Yakubu, mon la ca, co woca ne nyo bwireu, co ki bwici con no more ce. bibeyo lo ce no wi, kange bicir cero? ");
INSERT INTO bsj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeecu yii co kange nii wo na no mwembo weri an nuwa dilo mwe tak ");
INSERT INTO bsj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","la nii mane co tiyeri, mani a nuwa dilomwe ti tak. yila nyen, mwembo ma ne co tiyeu an yilam kwen mwenger cinen ti bui yaken ciko dume diinyeu. ");
INSERT INTO bsj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","nawiyeu yii nii merangka neye mwembo wo nari nuware dilomwe tak. nan boure tuwaka mwengek fo. ");
INSERT INTO bsj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeecu yii co, ya cou bwemwe. na kom bou fo. ");
INSERT INTO bsj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","nawiye yii co, mi man ki bwayile. Yeecu yii co mo tok dong-dong, mi man ki bwayile, ");
INSERT INTO bsj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","wori mon nam nabarob lam nung wo mo ciko na weu ke bo bweme. dike “mwa tokeu bilenker. ");
INSERT INTO bsj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","nawiye yii co, “nii merangka, ma to timon nii dukume. ");
INSERT INTO bsj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","tebnye bo wab fo bang ko wo, la mweu moki wurcalima co fiye daten nubo yam wabka ti wiye. ");
INSERT INTO bsj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","nawiye, ne bilenker kwamaco bouti wo mwa wab “Teeti fo dor bangero wo, bwenno wurcalima di. ");
INSERT INTO bsj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","kom ki wab dii ke ka nyombeu. nyeu nyo ki wab dii nya nyumom me wori fulokaka yau Yafudawa nin. ");
INSERT INTO bsj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","na co nyeu, kwama co wi bouti, na weu wo fo nob wabkako kendo an wab “tee mor yuwa tangbekcek kange bilenker. na teeu ki do co nubo buro na yilam nob wabbeceb. ");
INSERT INTO bsj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","kwama yuwa tangbek la nubo buro wabco tiyeu, tam wab co ki yuwa tangbek, ");
INSERT INTO bsj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","nawiyeu yii co “man nyumom kiwo maciya bouti (wori cu wo ti kiritti yeu) na co bou, can fuitang binen dikero gwam. ");
INSERT INTO bsj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeecu yii co, “mo co, ceu yinen ker ti yeu.” ");
INSERT INTO bsj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","la na ceu bibei tomange ceu yilam. la ci nyumangi ye bwi co tok kan kerti kange nawiyeu, la kange ciye tok bo, “ye mo cuitiye? “kaka ye bwi mo tok kerti kange ce? ");
INSERT INTO bsj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","la nawiyeu dubom tabwir mangero, yilam ken mor cinan lor, la yii nubo. ");
INSERT INTO bsj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","bou kom to nii wo yii ye dike wo ma gwameu. wuro yilanin kiritti an yila ka?” ");
INSERT INTO bsj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","cin dubom cinan loro cin bou cinen. ");
INSERT INTO bsj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","na ceu bi bei tomange ceu yii co ti nii merangka cam carito. ");
INSERT INTO bsj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","la con yii ci min wi ki carito ma catiyeu wo ka nyom beu. ");
INSERT INTO bsj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","la bi bei tomange ceu ti tokkangi bwitici, kange nii bou cinen bo diker cakar for, lan wi ka? ");
INSERT INTO bsj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeecu yii ci, canmiti co wo nan ma dike nii wo tomu ye maneu, la nan takum nangen cero. ");
INSERT INTO bsj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ka tok bokum cuiyak na'ar la nanimde cuiyak ko bou ka? ma yii kom ti, kung nuwa ko to tanginiu, kweri bimye na cua kaba bi tokko ce. ");
INSERT INTO bsj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","nii wo biye butuwe tiyeu, yo nan nanger ceroti, la mur bi tutiyo wo ya ken dumen dii riye. wori niwo fiyeu, ci bi langi wari. ");
INSERT INTO bsj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","fo wori min, tokkako, wineu fi, la kange biyemeu bilenker. ");
INSERT INTO bsj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","man tuom kom ko ya biyeka. fiye koma bou nangen wiyeu. kangem bou mam nangendo kumeu kon do ti dotange ciyerin. ");
INSERT INTO bsj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","camariyawa ducce cinan loroco ne bilenker kange co ki ker nawiye wo ne warke dor ce reu. “con yii ye dike ma maneu gwam.” ");
INSERT INTO bsj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","la kambo camariyawa bou cinenu, cin ken co na yii kange, con ciya com dam kange ci kume yob. ");
INSERT INTO bsj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","nubo duccu tok ne com dam kange ci kume yob ");
INSERT INTO bsj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","cin yii nawiyeu, mani nya ne bilenker ti ka kero woma toku, wori nyo ki bwinyi nyon nuwam, la nyumom nii wo co nii fuloka dor bitiner.” ");
INSERT INTO bsj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","bwiko kume yobeko, la con kobum we con yaken Galili ");
INSERT INTO bsj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yeecu ki bwici toki, nii dukume mani fiya dur bitinece. ");
INSERT INTO bsj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","kambo co bou Galiliri, nubo Galili yo co. cin tom dikero co manangi wurcalima, ki duklume, wori cin ya'a duklumeu keu. ");
INSERT INTO bsj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","la yila con bou ten kana mor Galili, fiye yila mwem yilam mwem inabimmeu. kange nii wi wo ma nangen lo liyaru bibwece mor kafarnam nuwa bo luma. ");
INSERT INTO bsj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","kambo co nuwa Yeecu dubom Yufudiya yaken Galili di, co ya'a Yeecu nin la co me co no bou na twam bibwece, woro dadom bwiyakau. ");
INSERT INTO bsj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeecu lam yii co na ka to bo yirom kange diker nyumankardi, ma ka ne bilenkerti. ");
INSERT INTO bsj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","nii nangen ne wo yii co “nii merangka, yirau nanimre bibwe mi bwiyam ");
INSERT INTO bsj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeecu yii co “ya bibwe mwen bum.” nii co ne bilenke kange kero Yeecu. Yeecu yii ceu, la con cu. ");
INSERT INTO bsj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","kambo co yiraken tiyeri, canga ceu wabkang co yii co bibwe bum ki dume, ");
INSERT INTO bsj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","co ca me ciye kang keneko nibereu, kwirum bwiu dubom co. ");
INSERT INTO bsj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","co teeu la nyumom kin co kang keneko co Yeecu yii co, “bibwemwe bum” la co ki bwici kange loceu gwam cinne bilenker. ");
INSERT INTO bsj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","wuron co diker nyuman karo Yeecu manau kambo co ceru Yafudiya co yaken Galili. ");
INSERT INTO bsj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","2","bwiko nyeu duklume Yafudawa wi, la Yeecu yaken wurcalima. wi wurcalima nyilok bi fwa tatik bele caji wi, wo ki nyi Ibraniyawa ki co ki Baitacda, wi ki bitukko nung cumamgum cumange ");
INSERT INTO bsj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","nubo kila-kila buro nuwa lumau, fukma, kilen, bwen co wo nani kange kani bwiyameri da rangum wi. ");
INSERT INTO bsj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","la be tomange kwama wucakeu, ki yam nyo ya bur mwembo kwama ce, la nawo yira kenten mur mwenge bureri fiya twaka bwen non twiraye co kala ticikeri. ");
INSERT INTO bsj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","nii kange wi ni wo nuwa bo luma coro kwini ta'ar cilombo narub. ");
INSERT INTO bsj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","kambo Yeecu toco ca dom wiyeri, la con nyumom nii wo dam wi coti kila-kila, la con yii co, mo cuiti na yilam kwamara? ");
INSERT INTO bsj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","nii nuwa luma toki nii meramgka “ma man ki nii wuro a dokken yeti mor mwenge na ci mok mwembori. nan bou ri kange yira kenten minen. ");
INSERT INTO bsj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeecu yii co “kweni, to kwangni mweu mwa yakenti. ");
INSERT INTO bsj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","dangjang nii con twam lan tu kwani ceu cu. la diye co diye kakuk fobka, ");
INSERT INTO bsj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","la Yafudawa yii nii wa twameu, kakuk fobkak, yorbo tu kwangni mweu, ");
INSERT INTO bsj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","la con yii ci, nii wo twa yereu, yii ye tu kwama ni mwe mwa yakenti ");
INSERT INTO bsj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","cin me co, we nii co yi nen ki tu kwangni mweu mwa yakengtiye? ");
INSERT INTO bsj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","la nii wo ci twa beu nyombo we Yeecu, la Yeecu cerum da'ar, wori nubo kila kabo fiye co. ");
INSERT INTO bsj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","la kaktenri Yeecu ya fiya co kuwabe, la yii co to mon yilam kwamer, mare bwirangke tak na kange dike bwiraneu fiya nen de. ");
INSERT INTO bsj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","nii co cu yan yii Yafudawau, Yeecu twa yere. ");
INSERT INTO bsj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","lan co dike wo Yafudawa ne Yeecu dotange, won co ma nan dii keburo kakuk fobkak. ");
INSERT INTO bsj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeecu yii ci teemi ma nangen ti bwen na wori, mo keneu ma manangenti. ");
INSERT INTO bsj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","co dor Yafudawa do na twalum co ciki kebo ka kanuk fobka ca kimeu, yila con co ten kwama ki te ce, tu dor ceroti dong-dong na kwama ");
INSERT INTO bsj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeecu kar cinen, bicom ki bicom bwe mani a ma diker na dor ceroce kima kima kan co dike ca to tee ma tiyeu, wori dii ke na tee matiyeri, bwe kima co co ciko win. ");
INSERT INTO bsj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","wori tee cui bweti, lan nun dikero gwam wo ca matiyeu, la an nung cinen dike burombo tenang tenangeu wo la buro la na ko nyumangi. ");
INSERT INTO bsj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","kambo teeu kungum nubo bweyarangume yila ne ci dumeu, nyo ken bweu ne dumeti nii wo ca cuiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","la tee ma bo nii nin buolang, la con neken buolangko kang bwek ");
INSERT INTO bsj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","la na nubo gwam na ne bwe dur, kanbo ci nem tee tiyeu. nii wo na nebo bwedurre di nebo teeu wo tuomceu. ");
INSERT INTO bsj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","bicom, bicom nii nuwa ker mire la ne bilenker nii wo tuom yereri wi ki dume diiri yeu, la mani a kangco ti la con cum buar con yabken dume. ");
INSERT INTO bsj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","bicom, bicom ma yi kom kwama co wi bouti, wuro nubo bwiyameu a nuwa dir bi bwe kwamaro tiyeu, la nubo buro nuwa an da. ");
INSERT INTO bsj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","na wo tee wi ki dume coki bwici, la con ne bweu na yilam ki dume ki bwici. ");
INSERT INTO bsj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","la teeu ne ken bweu bikwan kerero na mwatum bolanko wori co bibwe nii fire. ");
INSERT INTO bsj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ko nyuman de ki wo, kwama kange bouti wo nubo wo tuweti numeu an nuwa dircero. ");
INSERT INTO bsj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","la ci an cerangu, buro mana kenneu ki yan kwenka dumek, la buro mana bwireu kiyan kwenka buolangek. ");
INSERT INTO bsj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","mani ma makange diker ti ki bwimi, nawoma nuwau, ma mabuolangko nyo, buolanmiko dong-dong, wori dike ma matiyeu kebo mo, na nii wo tuoma yerece. ");
INSERT INTO bsj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","na man warker dor mir di, warke miumani a yila bilenkeretti. ");
INSERT INTO bsj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kange wi wo awarker ti dor mire. la man nyimom warkeu ca ne ti dor mireu bilenker. ");
INSERT INTO bsj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","kan tuom yuwa na nin, con ne warker bilenkerer. ");
INSERT INTO bsj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","la warke wo ma yoweu kebo nii fir nin, ma tok kere wo na fiya cerka. ");
INSERT INTO bsj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yuwana kira wo titi re filang tiyeu, la kom cuiti na ko ma bilangtum mor filange ce nin biduwar. ");
INSERT INTO bsj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","dual, warke ma cike tenangi la yuwana ceu, ki nangendo wo tee ne ye nan dimeu, nangen do buro matiyeu, warker ti dor mir, nung teeu tuom ye ");
INSERT INTO bsj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","tee wo tuom yereu ki bwici warker dor mir. ka nuwambo dir cer wi ko tom bo cerkanka ceu wi. ");
INSERT INTO bsj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","kercero mani yim mor nee kume, wori ka nebo bilenker ki nii wo ca tuomu weu. ");
INSERT INTO bsj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","kom kiyerang bifumeroti kom kwatiri more ciye kan fiya dume dii ri yeu, wentati cici warkerti dor miro. ");
INSERT INTO bsj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","la kom cui bo ko bou minen nako fiya dume. ");
INSERT INTO bsj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","mani ma yo cak-lanka fiye nubo wiye. ");
INSERT INTO bsj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","la man nyumom ka man ki cuika kwamak neer kumer. ");
INSERT INTO bsj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ma bou mor dene teemi la ka yoyebou, no na kange an bou ki den cer di kan yo co. ");
INSERT INTO bsj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","la ka nebilenker nyi kom wo ciya caklangka bwi ti kumeu, lamanikado caklankako wo bou kwama nin win ki kwaceu ");
INSERT INTO bsj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","kom kware neer fiye teemi wiyeu niiwo muca woka yoneer cineneu. ");
INSERT INTO bsj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","na kom ciyaki mucari, kan ciya kimo, wori con mulangi dor mir. ");
INSERT INTO bsj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","na kom ciya bo ki mulangka cerkori, la kom mani na ko ciya ki kermiro. ");
INSERT INTO bsj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","bwiko dikeburoko, yeecu cu yabken dinge caji galili, wo coti caji tibariya ");
INSERT INTO bsj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","nubo kila-kila bwang cinententi, wori cinto yirome wo ca mati dor nubowonuwa lumau. ");
INSERT INTO bsj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","yeecu kwi ken bang la wi co yii kange, bibei tomange ceu. ");
INSERT INTO bsj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","na weu yabkako, duklume yafudawa dadom. ");
INSERT INTO bsj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","la kambo yeecu kungnuwe to nubo ducce bouti cineneri, la con yii filibu, ba ya fe na bo ten nubo buro nin cari na ci cam. ");
INSERT INTO bsj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","la yeecu tok wo na co cuwa filibu, woricoki bwici con nyomom dike can matiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","filibu yii co carito naiyo kwini kob yobeu mani a lati bwen bidob, bidobri. ");
INSERT INTO bsj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","win mor bibei tomangeceu, andarawu yii cimo bitru yii yeecu. ");
INSERT INTO bsj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","bwe kange wi fo ki kuntulun cari to nung, na bikatece kange jinge yob. i an ye wo, nubo wo kila nyeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","yeecu toki, ki yi nubo a yii ken, la yerako ducce fiye co nin. la bayilobo yii ken, nubo bi kate nung, kila ciko. ");
INSERT INTO bsj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","la yeecu tukuntulen cari ye do la kambo co nem buka kangeri, con ne nubo yirongume. con ma ti nyo ki jingeu, kambo ci cuitiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","kambo fuer nobero bwabangumeu, loco yi bi bei tomangeceu, ko mwerum buro wularangi kumeu na kange na lere. ");
INSERT INTO bsj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","laci mwerum gwam la dim bulendo kwob cilom bo yob, ki wo wularange, mor kutulun cari ye to nungeu, wo kum nubo ca. ");
INSERT INTO bsj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","la kambo nubo to dker nyuman karo wo la maneri la cin toki, bilenker wo co ni dukume a bou ti mor dorbitinereu. ");
INSERT INTO bsj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","kambo yeecu nyumom cin dadom bouka na ci ta co kibi kwan na ci neken co liyau, la con cerum tak, kwi ken bang ki bici. ");
INSERT INTO bsj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","la kambo meu domeri, bi bei tomange ceu yira rang ken caji. ");
INSERT INTO bsj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","cin doken mor nabire mwengek, ci yabken kafarnam la kume fun fiya co yeecu boubo cinen. ");
INSERT INTO bsj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","la yuwa kwam kwam ti cuici, la caji ti mwenlangi. ");
INSERT INTO bsj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","kambo ci ya yambo na kang keneko kwini yob cilombo nung, kaka kwini ta'are di la cin to Yeecu yau dor mwenger caji bouti bi dom kange nabire mwengeu, la cin cuam tai. ");
INSERT INTO bsj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","la con yi ci, “niri mo” kom cuare tai. ");
INSERT INTO bsj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","la cin ciya ci yo co mor nabire mwengekro nin, ko co nabire mwengeu lam konge. ");
INSERT INTO bsj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","celfini, nubo buro tirangum dinge caji wineu, tori kange nabire mwenge mani, wi, la kan co win, la Yeecu do bo mor kange bi beitomangeceu cu ki kwa ci ");
INSERT INTO bsj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","la kangem nabire mwengem bo wi buro nyu tibeya, bi dom kange fiye nubo cam canyeu, bwiko teluwe nem bukakange keu. ");
INSERT INTO bsj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","la kanbo nubo nyumom Yeecu kange bibei tomangeceu mani fiye ceu, ci ki bwici cin doranken nabiren mwengero buro cin cu kafanam doka Yeecu. ");
INSERT INTO bsj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","kambo ci fiya co wi dinge cajiu, la cin yi co, “ni merangka” mwa bou fiyang fo? ");
INSERT INTO bsj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","la Yeecu kar ci nen, bicom kom ki do mo, kebo yirome ka to, wori kon cam carito wo fuer kumero bwam. ");
INSERT INTO bsj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ko dob maka dotangek dor cani to wo kaya ti kaya, la ko ma dotange dor tiyero diiri yeu, la co wo bi bwe nii a ne kom tiye, wori tee kwaama kwa cinen ti kange dor cer. ");
INSERT INTO bsj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","la cin yi co, yee, nya mati na nyo ma nangen kwaamare? ");
INSERT INTO bsj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","la Yeecu kar ci nen, wuro co nangen kwamaro kom ciya ki wo co tomuweu. ");
INSERT INTO bsj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","la cin yi co diker yirome ye mwa mati na nyo to na nyo ne bilenker ki mwe? ");
INSERT INTO bsj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ye mwa ma tiye? ten kuwa nib nyebo ca manna ki na wo ci kiyeu ne ci cari to yirau diiyeu cin cam. ");
INSERT INTO bsj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","co la Yeecu yi ci, “bicom,” bicom” ma yi komti kebo muca ne kom carito co diiyeu, lan tee ne kom cori to wo bilenkero ce lo kwama. ");
INSERT INTO bsj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","cari kwamaro co wo yirauti dii lo kwama, wuro ne dor bitinero dume tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","la cin yi co nii merangka,” mwa ne nyo mwan cari to woti kir-kir. ");
INSERT INTO bsj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeecu yi ci, mo cari dumero, wuro bou mineneri mani a nuwa wurati, la wuro ne bilenker mineneri mani a nuwa dilomweti. ");
INSERT INTO bsj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","la man yi kom, bi com kom tom ye, la ko ne bo bilenker, ");
INSERT INTO bsj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","nii wo tee ne yereri an bou minen nii wo bou mineneri mani ma yuwa coti ki duwar. ");
INSERT INTO bsj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","wo ma yirau bo dii nan ma cuika dor mirek, la dike nii wo tuomu yere, ");
INSERT INTO bsj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","won co cuika nii tuomu yereu, kange a lemde wi win mor nubo ca neyere, la can kung ci diye kwenka liyar kwamak ");
INSERT INTO bsj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","la won co cui ka tee miko, na wi wo to bwe tiyeu la ne bilenker kange ceu an fiya dume diiri yeu, la kun co ki dii ka kumenik. ");
INSERT INTO bsj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","la yafudawa, to kanti ka fitike, dorcer, wori Yeecu toki co tiyo yirauti lo kwama. ");
INSERT INTO bsj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","la ci ti toki wo kebo Yeecu bibwe yakubu we wo teece kange neece nyo nyumom ci ya? la ma nyi com ca tok ki ma yirau lo kwama? ");
INSERT INTO bsj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeecu karci nen, “ko dubom fiti keti to bwiti kom ");
INSERT INTO bsj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","nii mani a bou ti minero, no tee wo tuomu yere cou cori, miu la na kunco kakuk kwen ka liyar kwamak. ");
INSERT INTO bsj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","mulangum mulange mor bifumer nob dukumeb, toki, gwam ciye kwama an merang cinen. nii wo nuwa la merangeri, an bou fiye mi wiyeu, ");
INSERT INTO bsj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","la kebo nubo gwam tom tee, lakan co wo wi tee nineu. co ca to tee. ");
INSERT INTO bsj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","bicom, bicom no nii wo ne bilenkereri, wi ki dume diiriyeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","mou cari dumeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","tebkumebo cin ca manma mor kiye cin buyarangum ");
INSERT INTO bsj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","la cari to wo wo yirau lo kwama, la nii wo ca more ceri la man ki bwiyaka. ");
INSERT INTO bsj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","mo cari to ki dume wo yirau lo kwama, la nii ca cari to weri an fiya dume kwatti diiriyeu. cari to womane tiyeu bwimi wo cerka kaleko wo ce. ");
INSERT INTO bsj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","la yafudawa mam funer bwitici, la cin yoten citi kwobkangi cin toki, la nii wo a nebo nangece nyi na bo wo. ");
INSERT INTO bsj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","la Yeecu yi ci, bicom, bicom na mo wo nange bibwe nii fireri, namo nom bwiyale ceri, mani mwa fiya dumeti bwimwi. ");
INSERT INTO bsj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","nii wom nangemiula nom bwiyale mi yeu wi ki dume diiri yeu, la man kung co, kakuk kwenka liyar kwama. ");
INSERT INTO bsj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","wori nange miu co cari to ki bicomeu, la bwiyalemiu diker no karo bi comeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","nii wo wom nangemiu la nom bwiyalemiyeri a yii more mi mo mi more ce. ");
INSERT INTO bsj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","kanbo tee ki dume tuom yereu, la kambo ma yimeu ma yii co teeu. la nii wo cam yereri, la can yii ker mir. ");
INSERT INTO bsj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","wuro co cari to wo yirau lo kwama, kebo na tebbo ca la bwiyarangumeu, nii wo ca cari to weri an da diiri. ");
INSERT INTO bsj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","la Yeecu tok dike buro kambo co merangti bi kurwabereu kafarnam. ");
INSERT INTO bsj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","la bibei tomange ceu ducce wo nuwari, ki wo tokkako bwaibwaye, we a nuwa tiye? ");
INSERT INTO bsj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeecu lan nyimom ki bwici, kambo bi bei tomange ceu, ti funan bwiti ci yeri, la yi ci, wo yilam kayaka kekka? ");
INSERT INTO bsj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","la ye no kanto bi bwe nii fire kwikenti fiye kwatti co wiyeu? ");
INSERT INTO bsj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","la co yuwa tangbe ko ne dume tiye, bwiyo mani ma kange kero ma yirang komeu yuwa tangbe kwamak, kange dume, ");
INSERT INTO bsj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","la kangem kumem bo wi wone bo bilenkereu, wori ki kaba Yeecu nyimom nubo ne bo bilenkerereu, kange wo a miye co tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","con toki, co dike bwi ma yi kome, kange nii bou nin fiye ma wi, la tee nin ");
INSERT INTO bsj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","bwiko nyeu, ducce mor bi bei tomange ceu yilam ki bwi, ci yatenbo yam kange co tak. ");
INSERT INTO bsj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","la Yeecu yi wo kwob cilombo yobeu, kameu mani ka cu kume ti kenka, kebo nya? ");
INSERT INTO bsj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bitru kar ci nen, “mo teluwe” nyo ki yang we nin? mo moki ker dumero diiriye. ");
INSERT INTO bsj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","nyeu nyon ne bilenker, la nyon nyumom, mo nii wucak ke wo kwamaceu. ");
INSERT INTO bsj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeecu yi ci, kebo mo ma cok kome kwobcilombo yoba? win more kume bwekelkele? ");
INSERT INTO bsj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","la co ki tok kerowo dor yafuda bi bwe cima ne kkaryoti, la co, win mor kwob cilombo yoben, nii wo a miye co tiye. ");
INSERT INTO bsj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","bwiko dike buro gwam, Yeecu bwiylanti mor Galili, nyori ca cwibo na ya Yahudiya, wore Yahudawa cwiti na cin twallumco. ");
INSERT INTO bsj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","la duklume Yahudawa ci cuwo ti dodom. ");
INSERT INTO bsj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","kecebo la yico ki, “dubom fo, yaken Yahudiya, na be tomange na to nangendo mwa maneu, ");
INSERT INTO bsj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","nii kange man wo a ma diker ti yuran yurange no co cwiti na ci nyimom co nyanlang, wori mo ma dike buroti, nang dor mwero kale nin. ");
INSERT INTO bsj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","wori yitub mwebo kene nebo bilenke muneng. ");
INSERT INTO bsj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeecu nyori yi ci, “kume ni mi bou bo buri, kime kange kom kicatec. ");
INSERT INTO bsj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","kale mani a ko komti, an ko ye mi wori mi tok bilenke ti dor cer nangen cero na bwir. ");
INSERT INTO bsj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","kom ya dukulume wo, mani ma ya dukulume ti wori kumeni dibo buri” ");
INSERT INTO bsj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","bwiko co yi ci dici dike bure di con yiken Galili, ");
INSERT INTO bsj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","la yitok ce bo cu fiye dukulumeri, cin bwan cinen ten da'ar. ");
INSERT INTO bsj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yahudawa do coti fiye dukulumi, cikin fe co? ");
INSERT INTO bsj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","kero duccu wo ci tokkanti dor cereu, kangumbo ki con nii kang, kangumbo ki o-ong kebo nii keng bol nubo ti. ");
INSERT INTO bsj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","nyori nii man wo tok ker ti dor cer nyanlange wori ci cwa Yahudawa ti. ");
INSERT INTO bsj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","la dukulume dadom a dii tiri, Yeecu ya bikur kwamar yoten meranka. ");
INSERT INTO bsj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","la Yahudawa nyimanti, ki ma nyii nii wo nyirnom diker ducce.” wori ca yabe fiye meranka. ");
INSERT INTO bsj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeecu ciya ci nen ki “meranka kebo na mi, na nii wo tomu nyere ce.” ");
INSERT INTO bsj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","no nii cwiti na co ma dike co cwitiye co cwiiye di can nyimom meranka ko wo. keno bou kwama nii di, kaka miki tok ker dorek ki dor cere di ki do duktonka dor cer, ");
INSERT INTO bsj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","nii wo do duktonka nii wo tomu ceri nii cuwo nii bilenke bwiranke man cinen. ");
INSERT INTO bsj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","muca ne kambo werfunda ka?” wo nii mani wo bwanteng tiye, ye bwi kom doti na ki twallum yere? ");
INSERT INTO bsj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","nii bo mwerume ciya co, “muki ninga, we do ti na co twalnene? ");
INSERT INTO bsj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeecu ciya ci ki min ma nangen wiin di kom ti myimangi ");
INSERT INTO bsj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","muca nekom mwatika lakeko. wuro nungbo ki na muca ce na teb kime bo ciye kikume fobka kom ki biyere larre. ");
INSERT INTO bsj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","no nii ci biyeten lar bi di fobkari, kebo dikoro bwir werfun mucad. ye'e ka kangum ner wori min twabni ki bi dii fobka ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","kom warde ker diko wo ceru kalleu, ki wer dor bilenkeret ");
INSERT INTO bsj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","kangumbo bou urcalima yi ki, “wo kebo wo ci doti na cin twalume ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","to co tok kerti nyanlang, ci yi cobo diker. kangeri nob bitine bo nyombo ki wo kiritti na ma nyo ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","nyori bon nyimom fiye nii wo bou we. no kiritti bouri, nii mani a nyom fiye ca bouweti. ");
INSERT INTO bsj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","la Yeecu kung dir biur kwama meranti ki “kom nyimom fiye ma bou wiye, ma bou bo ki dor mir, nii wo tomu yere bilenke, ka nyom co bo. ");
INSERT INTO bsj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","min nyimom co wori ma bou fiye cin wiye ");
INSERT INTO bsj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ci cuiti na cin tam co nyori ni yobo kang dor cer wori kumeni bou bo buri. ");
INSERT INTO bsj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ducce mor nubo mwerume ne bilenke cinnen ne, cin tok ki “no kiritti bou ri a ma dike la'a nii wo ce ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","fariciyawa nuwa nubo mwerume ti tokangi dike wuro ti Yeecu ki lima, la liya wabbe kange fariciyawa tom nobo dur ci a tam co. ");
INSERT INTO bsj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeecu yi ci ki kom bi duwar na yilaken fiye nii wo tom yere. ");
INSERT INTO bsj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","“kan doye mani ka fiya ye ti, fiye ma yatiye mani ka yati.” ");
INSERT INTO bsj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudawa yi bwiti ciye ki fiye wiini nii a yati la mani ba nyomtiye? co ki yang fiye Hilenawa watangum na co meran Hilenawa nin ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“ye dike co to keu” kang doye mani ka fiya ye ti, fiye ma yatiye mani ka yati. ");
INSERT INTO bsj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ki bi dii kume cuileri, Yeecu kwani ti, tok ker bki bi kwang, “niwo nuwa dulomwe tiye ri a bou mineng co no mwembo. ");
INSERT INTO bsj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","wuro ne bilenke minen na wo bifumero tokeu ri, “caji mwem dume a ceru fwer cer. ");
INSERT INTO bsj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","wuro ci tok dor yuwa ko wucake wo ne bilenke cinen neri an yuwo, yuwa tangbe wucak cii neu bo, nyori Yeecu fibo duktonka. ");
INSERT INTO bsj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","kangum nobo mor nubo mwerume nuwa kero ri, nyi ki, wuro co nii tomange, ");
INSERT INTO bsj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kangum ki co kiritti, la kangum bo yiki, kiritti ki bou Galili ka ");
INSERT INTO bsj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ale, bifumero tok bo ki kiritti a bou naniya Dauda kange baitalami, loro Dauda wiye ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","la nobo mwerume yalkani yob ker ceu. ");
INSERT INTO bsj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","kangum cin bo no ki tan co, la nii mani wo yoti kang dor cere. ");
INSERT INTO bsj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","la nubo durko yilau liya nob wabebo kange Fariciya nin, wo me ci, “ye bwi ka boubo ki ce?” ");
INSERT INTO bsj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","nii bo durko kar cinen, “nii kange tok bo ker na wo.” ");
INSERT INTO bsj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","nyori Fariciyawa kar cinen ki “ci bol kom bol ken ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","kange wii mor liyabe ne bilenke cinen ne kaka kange Fariciya? ka nubo wuro mwerum nyombo werfune ri ciika ");
INSERT INTO bsj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","nikodimu (wiin mor Fariciyawa wo bou wi cinnen fiya cuwo) yi ci, ");
INSERT INTO bsj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“werfun bero ciya bi ne warka dor nir na nimre bi nuwa cinen na bi nyimom nye ci mane ka? ");
INSERT INTO bsj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","cin kar cinen ki, “mo keneu moki no Galili ka? do na to nii tomange kwama kange bou bo wi Galili. ");
INSERT INTO bsj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","la nubo curangi lo ci. ");
INSERT INTO bsj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeecu ya zaitunek. ");
INSERT INTO bsj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ki kwomjece yilau kuwabi, nubo kwarub bou cinen, yiken meran cinenti. ");
INSERT INTO bsj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","dila nob mulangkabo kan, nge faricawa ciin bo cinen ki nowiye ciitau mor kayakau. ciinyoco tiber. ");
INSERT INTO bsj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","la ciin yico ki ni merangka, nawiye wo mor kayaka. ");
INSERT INTO bsj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","mor bifure, musa ne, nyo nyal kinyi mubang nubowo, mweu yemutoke ");
INSERT INTO bsj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","cii toknyo nacii fiya fiye ciiya tamcoti ki kere, la yeecu cungken bitine mulang dikero kibi wure ce. ");
INSERT INTO bsj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","kambo cii merangco kerotiyeri, yeecu kweniti yicii, niwo more kume manki bwirangkeu ater mobka tereko. ");
INSERT INTO bsj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","yila cungken bitine mulang dikero kibi wureco. ");
INSERT INTO bsj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","kambo ciinuwa nyeri, ciin cira, nyi ki win-wine, terti kidurko. kibwiri ciin dobti yeecu wi kan, nge nawiyewo timtiber ciireu. ");
INSERT INTO bsj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","yeecu kweninti riki, nawiye, infe nubo tauneneu? kan, nge twalnenbo? ");
INSERT INTO bsj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ciki ony, nikan, nge mani kwama yeecu ki, mo keneu mitwal nenbo. ya yommwem. tabti duwen mare bwirang keretak. ");
INSERT INTO bsj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","yeecu yi cii tak, min filang kalek, niwo bwang mentine tiyeri mani ya yamti mor kumtacile dile annoki filang dume. ");
INSERT INTO bsj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","faricawa ki, mune warkati dormwer, warka mweko kebo bilingke. ");
INSERT INTO bsj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","yeecu ciya cii yicii, cano minne warkae dor mirdi, warkemiu bilingke, minnyimom fiye micirou wiyen, min nyimom fiye mi yakenti wiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","kom mabolangkoti ki cwika durek, mi mabo ninin bolang. ");
INSERT INTO bsj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","cano minma bolangdi, bolang miko bilingke wori mikebo miki kwami, dila mi wari kan'nge tee wo twomu yereu. ");
INSERT INTO bsj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ong, mor werfun kemer cii mulangi warke nubo yobeu bilingke. ");
INSERT INTO bsj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","mo mima warke dormittiye takri tee wo twomu yereu ni warketi.” ");
INSERT INTO bsj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","laciki, fe tee mwe? yeecu ciya cii yicii, kom nyomyebo kakaa tee miya, nakayimom yer komkin nymom temi. ");
INSERT INTO bsj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ci tokkerowo bidom kan'nye fiye yoka kikwama cima merangkako mor lo kwaamau, nikange tocobo wori takacoko labo bwiri. ");
INSERT INTO bsj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","yilanyitenci, man yaken kandoye mani kafiyati, kan bwiyam mor bwiramker kumer. fiye miyakentiyewiyeu mani kom yati.” ");
INSERT INTO bsj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","yafudawau yiki, an twalum dor cero, kambo ciyiti fiye ci yakenti wiyeu makom yati ");
INSERT INTO bsj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","yeecu yicii, komki no dorbitiner, mi, u miki no dii komna dor bitineroce, miu mikebo na dor bitineroce. ");
INSERT INTO bsj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","co dikebwi matoki mi bwirangke kume. ");
INSERT INTO bsj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","la ciin meco” we mwo?” yeecu yicii, dike miyikom kikabau. ");
INSERT INTO bsj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","miki dikero duce mayi komtiye, ma makumenten bolangti dor cere. dilanaweu, niwo twomu yereu, nibilingke, dikero manuwa cinenneu, co dike miyi dor bitinero tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","cii nyombo kiyicii kero dor teer ");
INSERT INTO bsj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeecu yi cii kanbo kom kun bibwemi diyeri, lakan nyimom in mo, lami mabo diker dorermir. kambo tee merange, meneu, nyo mitok dikero birombo tiye ");
INSERT INTO bsj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","co nii ci twomu yereu, wiwari kange mo mani dob yeti, wori mima dike fuwociner tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","kambo Yeecu tokkereri, ducce ne bilengke cinen. ");
INSERT INTO bsj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yeecu yi Yafudawa biro nebilengkeu, “nokom yi mor kere miri, kan yilam nob bwangka mib wo bilenke ceu, ");
INSERT INTO bsj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","kan nyimom bilengke, bilenkeu atin cokkom.” ");
INSERT INTO bsj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","cin ciyaco ki, nyin nubo lo Ibrahimeu nyimbo can nyawi kamnik, yebwi mwatokti muki atin cer nye? ");
INSERT INTO bsj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeecu yi cii, bilenke, bilenke, mi yikom nii wo ma bwirankeri canga bwirankerer. ");
INSERT INTO bsj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","canga mani yi lo diri; bweluwe kiyi lo diri. ");
INSERT INTO bsj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","canno bweu ceer nendi, bilenke munfiya ceerka. ");
INSERT INTO bsj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","min nyumom kom nubo lo Abrahime, kom cwiti nakom twallumye wori ker miro manki fiye yime more kume. ");
INSERT INTO bsj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","mitok dike mito Tee minine, kume keneu kom ki madike kom nuwa Tee kume nine.” ");
INSERT INTO bsj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ciin ciya ciiki, “Tee ce Ibrahim.” Yeecu yi cii ki, na kom na Ibrahimece ri komki ma dike Ibrahim maneu. ");
INSERT INTO bsj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Naweu kom cwiti nakom twallum ye, nii wo yikom dike ci nuwa Kwama ninneu. Ibrahim mabo wuro. ");
INSERT INTO bsj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kom ma nangen tee kumerti. Ciiki, “cii bo nyobo mor kayaka, nyi ki tee wiin Kwama. ");
INSERT INTO bsj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeecu nyi cii, “No Kwama Tee kumeri kom ki cwi ye, wori mi bou Kwama nin lamin wo, mi boubo dor miir, co ci tomu yere. ");
INSERT INTO bsj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yebwi kom nyombo ker mire? Wori mani kom dol nuwaka kermiroti. ");
INSERT INTO bsj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kom na tee kume bwe kelkele ce lari kom cwiti nakom dike ner tee kumereti. Cin nii twalka ki kaba dila ci tibo mor bilenke wori bilenke mani more ce. Kambo citok cwerke tiyeri, ciki tok ker dike ci matiye wori cin nii cwerke, tee nob cwerkeb tak. ");
INSERT INTO bsj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wori mitok bilenketi kom ko neka bilenkek fiye mi wiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","We more kume taye ki bwirangke? No matok bilenkeri, ye bwi mani kom ne bilenke tiye? ");
INSERT INTO bsj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","co wona Kwama ceu nuwa ker Kwamarti, kumeu mani kom nuwa ker Kwamaro ti wori kom kebo na Kwama ce.” ");
INSERT INTO bsj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudawa ciya co yiki, “Nyo tokbo bilenke kambo nya yi nyiki mun Nii Camariya la mwiki kelkeli ya?” ");
INSERT INTO bsj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeecu ciyaki, “Mimanki kelkeli, dila miki ne Tee mi dur, la kom neyebo dur. ");
INSERT INTO bsj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","mani mido duktangka dorekmik, nii dotiyeu wi co nii ma warka tiye. ");
INSERT INTO bsj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","bilengke, miyikom, nubo wo bwangten ker miro tiyeu, mani buyati.” ");
INSERT INTO bsj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","la yafudawa yi coki, lanyin nyimom munwi ki kelkeli. Ibrahim kange nob tomangebo buyam, dila muki, niwo bwanteng kermweri mani bwiyati.” ");
INSERT INTO bsj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","mulabo tee nye Ibrahim dwika wuro bwiyameu, munlaca? nob tomangebo buyam. munwe mutu dor miro mwere? ");
INSERT INTO bsj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeecu ciya cii, “no duktang dor miro, duktangka mike na bwir, tee mi kuktang yere. wo kom yi kom kinco kwama kumeu. ");
INSERT INTO bsj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","kom nyomcobo, miu min nyimom co. non nyi miki mi nyom cobori, min yilam kom ni cwerke, nitoco inma fuwer neret.” ");
INSERT INTO bsj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","tee kume Ibrahim mafuwer nere ki toka kaku miko, nitoco, inma fuwor neret.” ");
INSERT INTO bsj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","yafudawa yii, mulabo coro kwini nung burin, muntom Ibrahim wiya? ");
INSERT INTO bsj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeecu ciyacii, “bilengke, bilengke miyi kom, na nyi me ci bo Ibrahim, in mo.” ");
INSERT INTO bsj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ciin yetero cii yam nob co, dila Yeecu yurangum dor cero, cerum lo kwama. ");
INSERT INTO bsj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","la Yeecu cukentiri, con to ni kange ci bo fukma. ");
INSERT INTO bsj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","bi bei tomange ceu me co, “nii meranka we ma bwiran kere, co kaka tebceb ka, ci bo co fukma? ");
INSERT INTO bsj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeeu cicu ci, nii kange mabo bwiran ke, nii wo kaka a tebceb, ma nyo na nangen kwamaro cerkangu cinen. ");
INSERT INTO bsj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tam nyo bi ma nangen niwo tomu yere fiya kakuko wi. kume bouti wo nii mani a nangen tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","mi kale buri yeu, mo mi filang ka ko.” ");
INSERT INTO bsj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","bwiko Yeecu dim tokka kereko wo gwam ri, con twom bitom bitine, luwo muro, con beltiti. nuwe ce. ");
INSERT INTO bsj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","con yi co,”ya nerum karum kacuwe ci loam” (dike dendo nungeu-”tomi) na wori ni wo ya nirum, yilanu ti oi. ");
INSERT INTO bsj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","la nubo bi dom kange niweu wo to co kutangbeu ken kini tiyau, me “kebo niwo ki yire fo ken kini tiya ka? ");
INSERT INTO bsj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kangumbo “kio” kangumbo ki ke cobo cerkangka, la con yi ci, “nmo” ");
INSERT INTO bsj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","cin yi co, “la manyi nuwe mwe wumome?” ");
INSERT INTO bsj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","con karcinen nii wo cuwo ti ki Yeecu, coca luwo muro beltiti nuwe mi, la yiye ki ya yan mirum kacuwe ciloam, o ma ya nirum di ma fiya toka. ");
INSERT INTO bsj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","cin me co, “fe nii cuwo?” cin karcinen ma nyombo. ");
INSERT INTO bsj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","cin bou ki niworu no fukmauFariciyawa nin. ");
INSERT INTO bsj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","la bi di fobka Yeecu luwe bitine wumom nuwe ce cike. ");
INSERT INTO bsj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariciya me co tak, manyii ca fiya toka? con yici, ci yoti mur nuwe, ma nirum cn mi totiye.” ");
INSERT INTO bsj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","kangum Fariciyawa ki, nii wo bou bo kwama nin, wori ca nebo dur diye fobka.” kangum bo ki a manyi nii bwiranke a ma yirombo wotiye? la dor ciro tikangum. ");
INSERT INTO bsj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","la cin me ten fukma wo, ye mwa tok dor niwore, wori co ca wumom nuwe mwe?” fukma wo yici ki con” bwe tomange, kwama.” ");
INSERT INTO bsj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yafudawa bo ciyabo nii wo fukma, la cin fiya toka no teb cebo bou bo ri. ");
INSERT INTO bsj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","cin me tebcebo, “wo co bi bwekime ka bo fukma ka? la cane ko totiya? ");
INSERT INTO bsj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tebcebo ciya ci,” nyon yimom wo bi bwe nye, nya bowe fukma ");
INSERT INTO bsj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","cane ko ci totiyeu nya nyombo kange we wumom nuwe ceu nya nyombo ki me co cin duyom. can tokker dor cer.” ");
INSERT INTO bsj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","tebcebo tok dikero wo nyeu, wori ci cwa tai Yafudawa ti. Yafudawa ciya no nii wo ciya kange co ki kiritti ye ri, ciyan cokum co bi kur kwama urcalima, ");
INSERT INTO bsj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","nyo ri tebcebo yi ci ki “cin duyom, me co” ");
INSERT INTO bsj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","la cin cuwo teng nii wo na yobe ce wo fukma, cin yi co, “caklang kwama, nyon nyimom nii wo nii bwiranke. ");
INSERT INTO bsj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ni wo kar cinen, “ma nyombo no con nii bwirang ke ri, dikero wiin ma nyimeu, “min fukma can miti toi.” ");
INSERT INTO bsj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","la cin yii co, ye co ma mwene?” ca manyi ca wumom nuwe mwe?” ");
INSERT INTO bsj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","con ciya, min yim kom kican, la ka nuwa bo. ye bwi la kom cwiti na nuwa cannen? kom cwibo kom yilam be bei tomange ce, ko ti cwika? ");
INSERT INTO bsj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","29","cin toran co ki, “mon nii tomange e, nyeu nyon nob tomangeb mucar nyin nyimom kwama tok ker kange muca, la nyombo fiye nii wo bou ce wiye. ");
INSERT INTO bsj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","nii wo ciya, ci ki wo la bi kwang” kom ki ka nyombo fiye nii wo bou wiye, la co wumom nuwe miye. ");
INSERT INTO bsj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","nyon nyimom kwama mani nuwa nob bwiran ke, no ci cinti ki a ma cinen dike ci cwitiye ri, an ma cinen. ");
INSERT INTO bsj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ka cikko ci ywel kaleu, ba nuwam bo wi ki kange nii wumom nuwa nii ci bo fukmau. ");
INSERT INTO bsj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","nii wori bou bo kwama nin, ma ca ma kange diker ti.” ");
INSERT INTO bsj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","cin yi co ki, “ci bou nen mor bwiran ke, la muki merangum ki nyoka? la cin ywabken co kale. ");
INSERT INTO bsj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeecu nuwa ki cin ywam co bi kur kwama urcalima ri. con fiya, la con yi co,” mun ciya kange bi bwe nifire ka?” ");
INSERT INTO bsj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","con ciya co ki, “we teluwe cuwo ma ne bilenketi cinene?” ");
INSERT INTO bsj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeecu yi co, “mun tom co, nii wuro yinen ker tiye.” ");
INSERT INTO bsj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","nii cuwo yi co ki, “teluwe min ne bilenke.” la con wab co. ");
INSERT INTO bsj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeecu ki warke bou ki co kale we, na nyori wuor tobe na to kange buro towe an yilam fukma. ");
INSERT INTO bsj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","kangeb Faricawa wo kange ceu, nuwa dike buro ri, me co, “nyon fukma ken ka? ");
INSERT INTO bsj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeecu yi ci, no kom fukma ri mani ka ma bwiran keti, la can kom yi ki kom ti toi, bwiranke kume nyim wi. ");
INSERT INTO bsj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","bilenke, bilenke, ma yi komti, wo na dobo yiloko yaken klan kwamero nineri, la co kwi kange nureri, nii wo nii kwiye kange nii werka. ");
INSERT INTO bsj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","wo do nure co nii mobka kwama ko ");
INSERT INTO bsj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","nii yiloko an wom cinen, kwama nuwa dircero ti, co ki co kwama ki dencir, na ya ki ci kale. ");
INSERT INTO bsj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","kambo co bo ki kale gwame, co tiken kab, kwama bwancinententi, kweri ci nyomom dircero. ");
INSERT INTO bsj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","mani ciya bwang ten fabeti, cwa co, wori ci nyombo dir faber. ");
INSERT INTO bsj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeecu yi ci kero ki dangke, di la ci nyombo dike borombo co yi ci tiye. ");
INSERT INTO bsj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeecu yila yiten ci. bilenke, bilenke, ma yi kom ti mo yilok kwameko. ");
INSERT INTO bsj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","kangem bo nimde mori, nob kub, kange nob werka, la kwama nuwa ci bo. ");
INSERT INTO bsj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","mo yiloko, wo gwam wo alo fiye ma wiye di an fiya fukma, can do co ceri, can fiya fiye cana. ");
INSERT INTO bsj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","nii kwiye mani bower, ki bo kan kwii, co twallum kange kanka. ma bo na ci fiya dume, take na ci fiya dutce. ");
INSERT INTO bsj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","mo nii biyuware kendo, nii biyuware kendo ne dume ceu dor kwamarce. ");
INSERT INTO bsj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","wo bwe tomange, kebo nii biyuware wo kebo nii kwame, tono to bicwara bo tiri an cwa dobti kwame wii, la bicwara tam, kwame, yalumten ci. ");
INSERT INTO bsj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","cwo wori con nii nangen kiyeme, take yo co bo kange kwameru. ");
INSERT INTO bsj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","mo nii biyuware kendo, ma nyomom mi, wo mi nyomom ye. ");
INSERT INTO bsj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","te nyomom ye, mo ken ma nyomom te ma ne dume mi ker kwame. ");
INSERT INTO bsj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","mi wi ki kwame, kebo mor kilan do wo. birombo tam, bo ki ci, ciken ciyan nuwa dirmiro, beri ciya yila kilando win kange nii biyuware win. ");
INSERT INTO bsj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","nyo won co dike te cwiye tiye ma ne dume mi, beri na fiyaten co. ");
INSERT INTO bsj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","kange mani na wo a tum co ti minene, di la miki ne ki beimi. mi wi ki bi kwan ne kako, miwi ki kwan tuka ceko tok. ma you ciya kako te nin? ");
INSERT INTO bsj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","yalkako yila kweni tiber yahudawa dor kero woro ");
INSERT INTO bsj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","dutce more ciye ciki wiki kelkeli, takeu twelum, ye bwi ko nuwa co tiye? ");
INSERT INTO bsj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kangem bo ki wurombo kebo ker nii ki kelkeli an wumom nuwe fukma? ");
INSERT INTO bsj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","duklume wucakke mor urcalima lau. ");
INSERT INTO bsj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","la miyalale, Yeecu yakenti wi karak bikurwabe culaimanu. ");
INSERT INTO bsj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahudawa kentangum co, cin yi co fiyan mwa dob nyo ti mor nyomanka, tano mo mwa Almanciya di nyim nyo nyanglang.” ");
INSERT INTO bsj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeecu yi ci, “ma yi kom di kom ne bo bilenke. nangen do ma ma tiye mor den te mir, ci, ciwarkeroti dor mire. ");
INSERT INTO bsj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kang wo kom ne bo bilenke, dike bwiye kom kebo kwame mi. ");
INSERT INTO bsj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","kwame mi nuwa dir miroti, ma nyomom ci, ci bwang mententi ken. ");
INSERT INTO bsj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","mi ni ci dumeti diri, mani ciya bwiyati, ni mani a yociti kanmik. ");
INSERT INTO bsj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","te mi wo ne ye ciye, la nobo gwam duwi ka, ni mani a yociti kan temi. ");
INSERT INTO bsj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","mo kange te mi win. ");
INSERT INTO bsj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","la Yahudawa tu tero na cin mobang co ciko. ");
INSERT INTO bsj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeecu ciya la yi ci ki, man nung kumen nangendo yoryori dute fiye te mi wiye la co nangendo wini mor nangendo ma mane, kom mobanye tiye? ");
INSERT INTO bsj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahudawa kari ciya, kebo ki ker nangenero ken nyo cwiti, nyo mobangene, dila ker dilaka, mon nifir dila mo to dor mwero mo yilaken na kwama.” ");
INSERT INTO bsj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeecu ciya ciki mani mulangum mulange ka, mor bolange kume, nace kom bwel ka? 36 tano co ci ki bweldi, la wurombo ker kwamaro bo cinene (mani a dolti ki kero mor bifumere) ");
INSERT INTO bsj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kom ki yi niwo te cuki, tungu fo dorbitinereu, mon dillam, wori ma yi miki ma bebwe kwama ka'? ");
INSERT INTO bsj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","tano mani ma, ma nange temiro tiri kom nere bilenke. ");
INSERT INTO bsj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","tano mati mairi, bwen kom ne bo bilenke ki nangendo wori kom nyomom kom futangum kom ki te more mi, mi kenneu ma more te.” ");
INSERT INTO bsj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","cin maten na ci tam co, di la ta yamcem, cirum kangcik. ");
INSERT INTO bsj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","taka yamcem, yaken kab kange caji urdun, fiye Yahuda yum mwem bo wucakke tiye, yiken wii. ");
INSERT INTO bsj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nobo ki la ci bo fiye co wiye. ciki bilenke Yahuda mabo kange yirom, di la gwam dike Yahuda to ki dor mi wuro bilenke. ");
INSERT INTO bsj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","nobo dutce ne bilengke cinen fiye co. ");
INSERT INTO bsj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ni kange wi dendo Liazaru ma' twirak cin ni baitanya, la ki no bwar lor bi Maryamu kange yi tubcebo Mata. ");
INSERT INTO bsj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamu woro beltang teluwe nin nuwang yila nir cinen na ko ki yiri duwece. wuro yice Liyazaro dam ki twiranke. ");
INSERT INTO bsj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","yitub Marta tom tomange kirittin coki, tee, to co ni wo mwo cwitiyeu nuwabo luma. ");
INSERT INTO bsj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","kambo kiritti nuwa, la ci tokki mani yatico bwar, la tuka liyar kwama nyo, dige bwiyeu na bi bwe kwama fiya layar cer cinen.” ");
INSERT INTO bsj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeecu cwi Martati, kange yice kange, Liazaru nuwa luma co ci tiyang yi. ");
INSERT INTO bsj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","na curori cin nyi bi beiyo lo ce, ban ya yafu diya tak ");
INSERT INTO bsj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","la bi beiyo loce cin nyi co, teluwe yafu diya tak ");
INSERT INTO bsj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","la bi bei yo lo co cin nyi co, teluwe yafuda donen ti wi duwal naci ya naci mubangnen ki ter yilo mu cwi yila kati witak?” ");
INSERT INTO bsj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","kiritti ciya kebo kene kwab culombo yob na ka kaku ko win ne ce ka? ");
INSERT INTO bsj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ta no ni yayam ki kumeri an kottange dige bwiyeu filang ko mani kange co? ");
INSERT INTO bsj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","co tok ki na wuro di ki bwi nyori con nyi ci, forkume layijaro daken dum. laman ya na kungum co mwor dume.” ");
INSERT INTO bsj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","co bibeiyo loco nyi ki no dum ci datiyeri cin yuram ");
INSERT INTO bsj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","la kiritti ciyeu ci tok ker bwar Liyazaru dila ci kwetiri ki ker dume wo fubkakko ce. ");
INSERT INTO bsj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","la kiritti fwetang ci nen, “Layazaru bwiyam. ");
INSERT INTO bsj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","mi bilangti ki den kumer. na ki mi mani wiri na kom ne bilingke di la biya cinen.” ");
INSERT INTO bsj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","to wuro ci ciwoti ki bi bwe wo ci bo yob di wine nyi tangnim bi beiyo biya nabi bwiya wari kange kiritti.” ");
INSERT INTO bsj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","kambo kiritti laweu la con kwabti dam kume nar tuwe ");
INSERT INTO bsj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","baitanya yilo ki no bi dom kange uracalima, be yame nyo bidom ti beryer. ");
INSERT INTO bsj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yafudawa ducce cin bou na ci fiya co na ci ma cinen dangneri bibwei yiciye. ");
INSERT INTO bsj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","kambo nuwa ki kiritti bou ti yori yaken na ci fiya co nan di Maryamu yim mwor luwe. ");
INSERT INTO bsj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","matta nyi kiritti. teluwe naki mun wi fori no yimi ti bwiyabo. ");
INSERT INTO bsj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","bwentano can na wori min nyimom gwam dige mu kinongi kang kwamari atin ne nen.” ");
INSERT INTO bsj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","kiritti nyi co, “yimwe atin kwenum kwarce.” ");
INSERT INTO bsj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","la matta nyi co ki min nyimom bidiye kwenka nob bware an kwenum.” ");
INSERT INTO bsj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","kiritti nyi co Matta mo mi kunga nob bware, mo mi dume ni wo ne bilengke, mi neneu bwantano bwiyamri, can kwenum; ");
INSERT INTO bsj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","gwam ni wo ki dume no ci neya bilengkere mani ca bwiyati dong. mon ciya kange wura?” ");
INSERT INTO bsj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","la can nyi co ong min ciya mwo Almaciya, bi bwe kwama wuro bouti fo kalewo.” ");
INSERT INTO bsj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ki kwama co tok ki nyo, la con yilaken con cuwo yice Maryamu dinge win co ki, teluwe biyegen, yilo cu wo nenti.” ");
INSERT INTO bsj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kambo co nuwa nyeri la con kweni con yaken cinen wulom. ");
INSERT INTO bsj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","kiritti kweri doubo bwaror nwi fiye Matta yafiyaco wiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","kange yafudawa wuro ci wari kange Maryamu we in co nubo buro ne ka cekko dangneri to cin ciri mwor luwe. wulom, la cin bwangten co, ci kwatiri cin cu cin ci wiye tuwe. ");
INSERT INTO bsj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","kambo Maryamu lam fiye tuwe wiyeri, la cin yarken kabum nace konin co ki teluwe, naki wo wari kange nyori yiye ti bwiyabo.” ");
INSERT INTO bsj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","kambo kiritti to co ci wiye tiyeri kange Yafudawa wuri ci bwangten ceu, co ci nyimangi yuwa tangbe kange co wi kange co. ");
INSERT INTO bsj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","la co to ki fiye wuni ki daken ci ke?” la cin nyi co ki teluwe bouti.” ");
INSERT INTO bsj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","kiritti ci wiye. ");
INSERT INTO bsj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","la Yafudawa ciki to kambo co cwi Liyazaru tiye; “ ");
INSERT INTO bsj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","dila nubo buro ciki, nii wuro ne fukma toka fiyeu noti kobo bwiyak ni wuroka?” ");
INSERT INTO bsj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","kiritti dim ki yuwa tangbe ki bwici la cin cuken tuwe nin tuwe cim mummuwe nyi tuweu cin comti terowi. ");
INSERT INTO bsj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","la kiritti ki okm tungum tero Matta yi liyazaru wo bwiyame nyi teluwe, can neu bwiyo fuyem ki kume ta'ar can ki bwi yaka cekko.” ");
INSERT INTO bsj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","kiritti tok ki mi nyi nen bono mu ne bilengkari mwan fiya liyar kwama ka?” ");
INSERT INTO bsj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","di la cin kungum tero. kiritti kung nuwe ce dii tokki tee mi, min bumwen kang dige bwiyeu mu nuwa yeti, ");
INSERT INTO bsj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","min nyimom bwen tano ki kwama wuniri mu wari kange timfo ker kangum yere mi tok tiye, mi naci bilengke mwo mo tomuyere.” ");
INSERT INTO bsj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","kambo co tok kero wuro nyeri la con kung diro coki, “Layazaru di cerou. ");
INSERT INTO bsj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","la ni wo bwiyammeu cereu naceko kange kangko bwabe ki yi lang. tigom ce bo yi co canji langum ki yakka yi lange. kiritti ki nyi ci ki kom kwim co na cu.” ");
INSERT INTO bsj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","la nubo ducce mwor Yafudawa nin wo bo maryamu ni nen ci to dige bi bwe kwama mane cin ciya kange co. ");
INSERT INTO bsj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","la kangem bo yi la ken Faricawa nin cin nyi ci dige kiritti mane, ");
INSERT INTO bsj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","la nob werfun durko kange Faricayawa cin mwen dor ciyero, fiye win ci tok ki nye ba matiye, ni wuro madigerti ducce. ");
INSERT INTO bsj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","no bo dobco koni nawori, nubo ducce atin bwangten co. Ramawa an bou yom fiye beu kange bitine beu. ");
INSERT INTO bsj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","gwam nyo tak ni kange wi tiber ciyer, kayafa co ci ni bifumero durko ki coro wuro, nyi ki nyom bo diger.” ");
INSERT INTO bsj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ki nyombo daten ni win na bwiyam ki den nubo ducce na bwiya kange wo kale kwarum a kwenum tiye.” ");
INSERT INTO bsj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","tok digewuro kebo na dor cero la kambo cin dur ni bi wabir, tok kero dur coki deten, kiritti na bwiyam ki den nubem. ");
INSERT INTO bsj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","la kebo ki den nubo kwarub la ki den na murangu bi bei kwama wuro merangum fiye kutanrange nyo weu na mweru ci fiye win. ");
INSERT INTO bsj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","di la ki kume di coru ci ter doka nure wuro ciya twal kiritti tiye. ");
INSERT INTO bsj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","di la na co kiritti mani nyo yanglang tiber Yafudawa dila ci yaken kange fiye bidom kange kii na kange cinar lor kange ci cuwoti Ifraimu. la ci beiyo loce. ");
INSERT INTO bsj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","tano yab karko na Yafudawa lau bidomdi la nubo ducce firin Uracalima nyo bitine dinge wine bidi idi na yulang bwi ci. ");
INSERT INTO bsj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","cin ter doka kiritti ci tikkang ker ti ki kwama ci tirangum tirange ku kwama, tokti. nye kom kwaatiye? mani a bo iditi ka? ");
INSERT INTO bsj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ni dur wabiro kange Faricawa kweri cin neken nyel no ni wo to kiritti ri nyi ci na ci tam co. ");
INSERT INTO bsj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","kum kume nukkun nakwak yabkaka, Yeecu bou betani, fiye Lizaru wiyeu wo Yeecu fulouweu ");
INSERT INTO bsj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","cin macinen cariwi, matta nima carike, Liazaru wi mor nubo yimwiyeu kange Yeecu. ");
INSERT INTO bsj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","dila matta tuwango ficangeu ciyweki nad, ci belti Yeecu ninti nacek. laci wauki yiri duwecek. mor luweu dimki kundo ficang ficangeu. ");
INSERT INTO bsj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yafuda kari yoti wiin mor nob bwankaceb niwo ane konco fiyeu, yiki, ");
INSERT INTO bsj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","yebwe mani miyeu nuwango ficang ficangeti nai kwinikwo ta'arti naneken nubo manki dikere? ");
INSERT INTO bsj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","citok kero wo nobkici cwinubo manki dikereti, wori cin nikuye: cociyo kemerotiye, takri kudike ciyokangce keti. ");
INSERT INTO bsj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeecu yiki, dobco ciya yoken dike cidou na fwekami koceu ");
INSERT INTO bsj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","kwatti kom wari kange nob bwinibi, kommani wari kange mo.” ");
INSERT INTO bsj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","kambo Yafudawa ducce nyumom Yeecu wini yeri la cin bou, kebo Yeecu nin ki kwace, cibou nacin to Liazaru, wo Yeecu fulou buwareu. ");
INSERT INTO bsj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","la liya wabetin do dou nuriti ciya twalum Liayazaru ti kencu, ");
INSERT INTO bsj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","inkercen Yafudawa ducce yane bilnike Yeecu nine. ");
INSERT INTO bsj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","celfiniceri namor ka nubeko ducce cin bou fiye Idii. kaci nuwa ker Yeecu bouti wurcalima, ");
INSERT INTO bsj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","la cin yeu bilu dibin cin ceru'u cin ker co dila cin kun diro citi toki Hosana; be buyer kiniwo bou kiden kwamareu, liya Yafudawa.” ");
INSERT INTO bsj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeecu fiyaube Gelban kwiken dorcer kambo bulangeu, ");
INSERT INTO bsj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","cwaretai mo cihiyona, to liya kume bouti yimdor gelbar.” ");
INSERT INTO bsj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","nob bwankan cebo yombo dikowo kikabe, kambo ci duklang Yeecuri, la cin kwabidikewo mulangi nyo dor Yeecur, la cin ma cinen dikerowo. ");
INSERT INTO bsj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","la nubowo wari kange Yeecu ki kumewo ci cuwo Liyazaru mor tuwe cin fuloucou, cinen bilenke. ");
INSERT INTO bsj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","wonco dike bwi nubo cirou yaercou, wori ciin nuwa cin ma dikewo. ");
INSERT INTO bsj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","la Firicawa yoten kero bwiti ki, “to mani ka ma dike kangeti, komto dorbitinero bwangtenco. ");
INSERT INTO bsj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","morece Helinawa wi birombo yakentiwi fiye wabka Idii. ");
INSERT INTO bsj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","cin yaken Filibu nin, inni becaida yim Galili, “cii ki, nii merangka, nyin cwiti nyin to Yeecu. ");
INSERT INTO bsj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibu yanyi Andirawu yaken wari kange Filibu yacin yi Yeecu. ");
INSERT INTO bsj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeecu ciya yicii, kang keno ko din wo ciya ne bibwe nii duktang tiye. ");
INSERT INTO bsj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","bilenke, bilenke, miyikomti, la nu'u bikateu an yarken bitine na buyam, cannowi cike kwaco, cano cibuyamri, canne bituttitui. ");
INSERT INTO bsj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","niwo cwi dume cetiyeu, an lomco lano ko dumece kalereri atin yoken co dume wo diri diriyeu. ");
INSERT INTO bsj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ni wo wabyetiyeri, la abwang menten. fiye miwiyeu. bwe can nya miu anowinken. niwo wabyeti yeri, kwama an neco duri. ");
INSERT INTO bsj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","naweu dume mi kino mor kwomka, yemama tiye? tee cokye ki kwama wo? wonco dike bwi milau kwama. ");
INSERT INTO bsj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","tee, duktang den mwero “la diro yirau di kwama ki, min duktangce, man duktangcotak. ");
INSERT INTO bsj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","la nyori nubo murom wiyeu nuwa diro, cin yi ki kwama kwabi. kanyembo ki nii tomangeu tokker kange co.” ");
INSERT INTO bsj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeecu ciya ci ki, dirowo boubo minen, bou kumen. ");
INSERT INTO bsj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","naweu ciyatin warkaleu: na weu atin ywa nii liyar kalero. ");
INSERT INTO bsj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","na nyime mo, canno cii kunye dorbitinerdi, man bou ki nubo kwareub fiye mwiyeu” ");
INSERT INTO bsj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ci tokwo nadong dara buwareu ca bwiya tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","nubo ciyaco yiki, nyin nuwa mor werfuner kiritti a yi nyo diri. ye bwi mutok muki atin kun bibweni ye? we bibweni ciro? ");
INSERT INTO bsj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeecu inyici, “kakten biduwardi kam yi ki filang kamyi kange filango ki kwama wo filango wari kange komeu, ka kumtacileu cumomkom. wo yam mor kumtacileu, nyombo fiye ciyakenti wiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","komne bilenke filanko wonin kambo kom wari kange filange nakom yilam bebei filang. Yeecu tokwori colem ya Yuranngum me. ");
INSERT INTO bsj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","cano Yeecu inma diker nyiman kar ducce kabumcim. kwarub kange wo, cinebo bilinki anen. ");
INSERT INTO bsj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","naker dukumer Icayarodin, woki, kwama, we nebilinke ker nyere? kang kwama ko bou wenin?” ");
INSERT INTO bsj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","wonco dike bwi ci nebo bilinker, Icaya toktentak, ");
INSERT INTO bsj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","cin cumom nuweceu, cin kwamum nerciro, wore na ci tore ki nuwece, naci nyomde ki nercer, yilau minen nan nirimci. ");
INSERT INTO bsj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Icaya tok kerowo inwori cinto duktanka Yeecu kon tok ker kangeco. ");
INSERT INTO bsj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","nawo duwoleu, ducce mor duremcin nin nebilinke Yeecu nin dila Faricawa, ci dambo yomka ceko dangla. ");
INSERT INTO bsj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","cin cwi caklangka la caklangka ko bou kwama ninneu. ");
INSERT INTO bsj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeecu kung diro yiki, niwo bilenke mi nen neure keboka minen cine bilenke kange niwo two mu yerou, ");
INSERT INTO bsj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","niwo to yereu, tom niwo two mu yereu. ");
INSERT INTO bsj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","me bou nan filang dor bitiner, canowo nebitinke minendi mani yiti mor kumtacile. ");
INSERT INTO bsj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ni wo nuwa kermiro nebo bilenkeri, mani maci nen bolangti, mi bou bo nan ma dor bitinero nin bolang, bi bou nan fulo dor bitinero. ");
INSERT INTO bsj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","niwo keya, koten kermireu, niwo a maci nen bolangko tiyeu wi kero matokeu an maci nen bolang ki kume cwile. ");
INSERT INTO bsj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ma tokbo ker doret mer inker teero twomu yereu, niwo yiye dike ma matiyeu kange dike matok tiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","min nyimom nyalcero nawo diriye, co dike bwe matoke-nawo tee tokeu, nyo matoke.” ");
INSERT INTO bsj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nyo na nyim de bi caro cuwam bwireu kiritti nyimom kume ce an dim wuro ca dubom kale wotiye cwi nubo buro fo kaleweu cwici gwam. ");
INSERT INTO bsj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","bwekelkele kwerin dor ner Yafuda Ikarouti bi bwe Caminu ne ken kiritti ");
INSERT INTO bsj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","nyimom te kwama neken digero fo kancek di ci bou tenin di ci ki yang tenin. ");
INSERT INTO bsj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","con kwenem caka cari konin con cukom bellece cin tu yilangko con kwarum bwici ciko ");
INSERT INTO bsj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","la con bwi mwembo ki kwel mwengye com ter nirka na bi bei yolo ceu co wamti ki yilangko wo co kwarum bwici cike. ");
INSERT INTO bsj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","cin bo Bitru, Caminu, la Bitru yico ki teluwe mwaten nirmin naka? ");
INSERT INTO bsj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","kiritti ciya yico ki dige mi ma tiyeu mani mwa nyomti can nawonyo di la ki mwan nyimom ");
INSERT INTO bsj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitru yi co ki mani mwa nirmer nati kiritti nyi co ki no mi nirmwen bori mu man ki teluwe ke bo ka namik koni mwa nirtiye la kange kang miko kange nami ko.” ");
INSERT INTO bsj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","kiritti nyi co ki gwam ni wo yum mwengeu di nyo ka na la com manki dwiti cuko win kom nirum dor kumero la kebo gwam ki me. ");
INSERT INTO bsj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","di la bwiye kiritti nyimom niwo aneken co tiye co dige bwi ci tokke kebo gwam ki me man ki dwi tiye.” ");
INSERT INTO bsj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","kambo kiritti nir cinen nakeri tubellece nyinken tak yi ci ki kom dige mi makime na? ");
INSERT INTO bsj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","kom cuwo yeti kom ki teluwe kange kwama kom tok dong dong mina conyo ");
INSERT INTO bsj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","tana teno teluwe kange kwama nir kimen natiri daten kom keneu ki nir bwiti ki min na. ");
INSERT INTO bsj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","nyori min nyikom ki dangke kom ma kambo mi maki meneu. ");
INSERT INTO bsj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","tano nyori mi yi komti canga mani labo teluwe ce ki dwira bwe tomange labo ni wo tomuce ki dwika. ");
INSERT INTO bsj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","no kom nyimom dige buro kom nob lumam tano kom manangen cukori. ");
INSERT INTO bsj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ke bo dor ki mer gwam mi tok kero tiye mi nyimom niwo ma cikeu dina kero.' di dor cer co ni wure cakwel mwengye win kange mowe con kungmen ker. ");
INSERT INTO bsj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","mi yi kom ti can nawo na nimde fiye kom tano fiya komdii kom ne bilengke mo. ");
INSERT INTO bsj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","bilengke mi yi kom tiye ni wo yo wuro mi tomuweri yomo niwo yeri yo ni tomu yere.” ");
INSERT INTO bsj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","kambo kiritti tok ki nyeri yuwa tangbe kwom co cuwa ci yici bilengke mi yi komti win tiber atin neken ye.” ");
INSERT INTO bsj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","bi bei loceu torangti bwitici la ci nyimangti keno dor we ci tok tiyeri. ");
INSERT INTO bsj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","win mwo bi beiloce wuro kiritti cwitiye wi to kombo nin bimumwi can kiritti. ");
INSERT INTO bsj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ci mon Bitru yi tangnim bibeiyo lo yinyo mu tok kange weri. ");
INSERT INTO bsj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","di yila bimtibwici kiritti nin ci tokki teluwe weno le?” ");
INSERT INTO bsj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","co la kiritti ciya co niwo ma dokten cari to bikwen nanne co kom co dokti carito wiyeri la cin ne Yafuda bi bwe cimon Ikariyoti. ");
INSERT INTO bsj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","kambo ci cam carito weri, bwekelkele do co di kiritti yico ki dige mu matiye ma wolom.” ");
INSERT INTO bsj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ni kange mani mwor caritonin wo nyimom dige bwi co yi co nyowe. ");
INSERT INTO bsj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kangebo kwatiri tamwi Yafuda tamki cwaye kiyeme kiritti yi ce mun tiyen dige nyi cwitiye na toka nuwece kangeri me diger ki den celeb. ");
INSERT INTO bsj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","kanbo Yafuda yo cariton di can do wo cerum ki kume. ");
INSERT INTO bsj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","kambo Yafuda cuwe kiritti tokki cin duktong bibwe niifit morece. ");
INSERT INTO bsj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","kwama an dugtang co. co ki bwici yila na dugtung co can na wo. ");
INSERT INTO bsj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","bibei bi dwadti nubo mi wari kange kom nyo bi dob kan doye tak na wuro miyi Yafudawa. fiye ka dolyakati can na weu min yi kom. ");
INSERT INTO bsj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","mi ne kom werfunero fwirti kom cwi bwiti na wuro mi cwi komme dila nyo kom cwibuti. ");
INSERT INTO bsj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","na curo nyo nubo a nyimom kom bi beiyo lomiye no kom cwi bwitiri.” ");
INSERT INTO bsj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","cin mon Bitru nyi co teluwe mu ki yangfe? kiritti ciya cari fiye mi yakentiyeu mani mwa dolyakiti can nawo dila ki bwi mwan bwang menti ");
INSERT INTO bsj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitru nyi co ki teluwe nye bwi mani ma dol bwangka mwerti can nawe? man ne dume mi ki den mwer.” ");
INSERT INTO bsj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","kiritti nyi co ki mwan ne dume mwe ki mwan ki den mirdi? kibi cuwom mi yinenti cire bar bi cake mob ki yeri mwan kanangyi kiritti ta'ar.” ");
INSERT INTO bsj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“dobre ner mwer na kayam kom ne kwama bilengke na kom neye bilengke ");
INSERT INTO bsj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","firen lo temi yime wi ducce naki mani nyori no mitingyi kom dige bwiyeu man cu na ywel kimen fiye. ");
INSERT INTO bsj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","tano nya ywelkumen fiyeri. man yilau nan yo kom nyaken cu ko fiyeco dige bwiyeu fime wiyeu no ka nowiken. ");
INSERT INTO bsj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","na kom nyimom fiye miyakenti wiye ");
INSERT INTO bsj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","toma nyi kiritti ki teluwe nyo yombo fiye mwa yaken tiyeu nyori nya nyom fiye co nyi?” ");
INSERT INTO bsj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","kiritti nyi co mou mi nure mou mi bilengke mou mi dume nii kange mani ya yati tenin ca dou minen. ");
INSERT INTO bsj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","no kom nyimom yeri kom nyimom tee. kambo can nawo nyimom yereu kom tom co.” ");
INSERT INTO bsj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibu nyi kiritti ki teluwe nung nyi nen teu wuro cuwa nyinenu.” ");
INSERT INTO bsj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","kiritti nyi co mi wari kange kom ki kutangka dina wo can neu mu nyomyeba? Filibuc gwam niwo to yereri tom temi mwo tok mwo ki ye? nung nyi nenteu'? ");
INSERT INTO bsj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","mwa nebo bilengke mworte, yilo te mwor mi ra? kero buro mayikom tiyeu, kebo liyar mir kom ticike co teu yim fwermir co ma nangen cero tiye ");
INSERT INTO bsj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","kom bilengke miki no fwerte co tee ki no fwer mira? tano nyori kom ne bilengke nangnan ciyero min. ");
INSERT INTO bsj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","bilengke mi yikom tiye gwam niwo ne bilengke mkange moweu can ma nangen do mi matiye can ma nange do la wure mi miki firen tenin. ");
INSERT INTO bsj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","gwam dige kom ki nonge ki den mireu man mani na caklang tee mwor bwe. ");
INSERT INTO bsj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","no kom me bwentano nye ki den mirdi man mani. ");
INSERT INTO bsj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","no kom cwiyeri can ciya werfumermiro, ");
INSERT INTO bsj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","nan kwab ki men dulo ki tee catin ne kom ni kange wuro a yob ki men nertiye na yi wari kange kom diri. ");
INSERT INTO bsj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","bweldokendo kale daten a yotiyeu, kambo ci tobeu ci yombeu dila kumeu ki nyomco dige bwiyeu ci wari kange kom catin no wari biber ki mer. ");
INSERT INTO bsj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","mani ma dob komti ki kwakom man yilau kimen. ");
INSERT INTO bsj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","tangnim kumenim bikwen ce kale an bwan na toye tak dila kume ki toyeti dige bwiye mi kwarce kume kenen kan fulo. ");
INSERT INTO bsj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ki diye kume wuro kan nyomom miki no fuwet te'e mir kom keneu kom ki no fuwer mir miyu keneu fuwer ki met. ");
INSERT INTO bsj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","co ni wuron ki werfun mireu yilo ci bwangtenti co ci bilangye tiye yilo ni wo cwiyetiye te'emi an no kange co. mo kenneu bilang co nan nung bilangka dor miro cinen. ");
INSERT INTO bsj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yafuda (kebo Ickariyoti ba) can yi kiritti teluwe nye bwi mwa nung dor mweroti yinene la mu nungbo kalenine?” ");
INSERT INTO bsj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","kiritti ciya, yi co wo bi langyetiyeri can tam kermiro yora temi an cwico. banbo cinen na bi yi wari kange co ");
INSERT INTO bsj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ni wo bilangyebeu ci bilangbo taka kermiro kero ci nuwau cerubo minen ceru firen teminin wo to mu yere. ");
INSERT INTO bsj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","min yi kom dege wuro gwam ki kwama bi wari kange kome. ");
INSERT INTO bsj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kan co niwa ki bi bwiyer bi com wo kendo te'e tomu ki dencer na yi kom digero gwam mi yi kome ");
INSERT INTO bsj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ma dob ki fuwarnerer, mi ne kom fuwor nerer. kebo nawo kale tiye netiye nyo ner kumero a kayare yilo ki cware twai. ");
INSERT INTO bsj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","kom nuwam mingyikom. man cu yilo fo kumen, no bilangy yitiri kan fuwor nerer na yaken firen te'e-nin wori te'e laye bi dwiyer ");
INSERT INTO bsj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","can neu min yim kom na yim de bwi, tano bwiri kom ne bilengke. ");
INSERT INTO bsj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","mani ma kwab tokka kerekti kange. kom cho nyeu nii toka kalewuro wi bouti. chi man kibi kwan dormir, ");
INSERT INTO bsj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","na cho nyeu kaleu an nyimom dor cher me chwii teemi, mi ma nyeu cho te'e neye bi kwan kerede. daten bi kwenum chii nabiya na fiye wuro. ");
INSERT INTO bsj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“mo mi ti biyuware bicom te'e mi ni tome. ");
INSERT INTO bsj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","co ki cukom cwangko wo gwam mani ne bi tutti wuro ne bitutti tiyeu an yulangum na ne bitutti yora, ");
INSERT INTO bsj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","com caneu witi mani bwikimi na kere kendo mi yimkom yiye. ");
INSERT INTO bsj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ki yi fwermir mo keneu nan yi fwerkumed. tami kani tiye wuro mani ne bitutti ki kwaco ki no tiwi bwitiyen na numde, nyo kume ken mani ka do makadi ka no bwimi. ");
INSERT INTO bsj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","mo mi te'e kom ki kani ceu. wuro wi bwimiyeri la mo mi bwici, can ne kani ducce, tano mi maniri mani mwa dol digerti. ");
INSERT INTO bsj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","tano ni win ko yika bwimiri catin mirangcowi na cwang di kucum. ");
INSERT INTO bsj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","no mun wi bwimi la kermiro wi munen di, me'e diye mu cwitiye, di ciya tin mamwen. ");
INSERT INTO bsj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","nyo ciki bilangde bi bwiyer temire nakom nyimom bi beiyo lomiye. ");
INSERT INTO bsj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","kombo te'e mi bilang komeu kambo mi bilang kome, kom yi mwor bilangka. ");
INSERT INTO bsj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","no kom bwangten werfundodi, kangyi mwor cwika nawuro mi bwangten mi bwangten werfun te'e miro la min yiken mwor cwikacer. ");
INSERT INTO bsj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","mi yi komti na kulentini dige buro fuwor ner kumero na nowi biber kimet la fuwor ner kumero na dim diye. ");
INSERT INTO bsj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","muro co kermiro na kom cwii buti kumi nawo na wo mi cwi kome. ");
INSERT INTO bsj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ni kange mani cwi kakko cum nawe naco neken ner cero kiden farub ceb. ");
INSERT INTO bsj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","kom farub mib na kom ma digewu miyi komeri. ");
INSERT INTO bsj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ferer kab mani ma yog cuwoka kumeti, bi bei canga dige bwiyeu bwe canga nyombo dige teluwe ce matiye. mi cuwo kom farub mib nan nyi kom dige gwam ma nuwa te'e mi nin ne'e. ");
INSERT INTO bsj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","kebo kom ki cok yere lamo mi cok kome, mi tom kom na kom ya na kom ne bi bei, ma tom kom ki ne bibeiyo na wo cokke. ");
INSERT INTO bsj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ker bifumero mayi kome nakom cwi butikimi. ");
INSERT INTO bsj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","no kale ko komdi, kom nyomom koye na nimde ko kom. ");
INSERT INTO bsj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","na ki kom na kale cedi, no kale tin cwikom tami nace. ");
INSERT INTO bsj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","kom kwa ki kero ma yi koe, ki ciya kermirori la kan ciya kermiro. ");
INSERT INTO bsj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ci yan ma kimen dige tinimbo wuro ki den mir, la ci nyombo niwo tomuyereu. ");
INSERT INTO bsj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","na ki ma bou bo nan nyi ci kerdi no ci manki bwirangke, la canneu ci manki kangke kan bwirangke. ");
INSERT INTO bsj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","gwam ni wo ko yereu ko te'e mi. ");
INSERT INTO bsj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","na ki mi mabo nangendodori no ni kange mani momwi tiber ciyere. no ci manki bwirangke la canneu cintom la cin ko nye kange te'e mi gwam ");
INSERT INTO bsj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","dige wuro ci maneu nadim kero mulangum mwor bifumere, cin koye manki tuwer kercer. ");
INSERT INTO bsj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kambo nii birumreri we ma tomki menti firen tee nin, bilengke bibwiyer woki cetde bwi tee ninne an bo na ne warka dormir ");
INSERT INTO bsj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","kume kom ne warke na wo kom wari kange mo nyo ki kaba. ");
INSERT INTO bsj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“mi yi kom wo ka kom kottangi ");
INSERT INTO bsj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ciyan cokom loniwabi dilla keneber, wuro cano kange twalkom, amkabi ciki ma nangen kwamar. ");
INSERT INTO bsj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ciyan mani nyo wori ci yombo te'eu kaka'a mo. ");
INSERT INTO bsj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","miyi kom dikero brombo cano ki kwama dico abwiutiyeu lamri, kom kwabi min yi kom minyikom. ");
INSERT INTO bsj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","na weu miki yang wo twomuyerenin, kom kwarub more kume kange me yobo. muki yangfe?' ");
INSERT INTO bsj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","wori minyi kom dige birombo, finnerero dimkom. ");
INSERT INTO bsj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","la min yi kom bilengketi. an lakumen diger noncuri. can no mi cubori, nii birim nerembo mani bouti kumen, incuri, man twomuco kumen. ");
INSERT INTO bsj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","no bouri andang kale nin digero bwir kange bwirangke, kange luma, kange warka. ");
INSERT INTO bsj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","la bwirangkeu, wori ci ciyabo kange mo, ");
INSERT INTO bsj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","la lumako, wori miki fiye tee wiyeu, dila mani ka toten yeti, ");
INSERT INTO bsj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","la kange warka, wori cin mwati ni liyar kalero woni warka. ");
INSERT INTO bsj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","dikonwi kila wo ma yi kom tiye, dila mani kanyomti cana ko wo. ");
INSERT INTO bsj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","no wori, kanbo yuwa tambe bilengke bou weri, an bwanteng ki kom mor bilengke kwarub, wori mani tokker dorer certi, kandike can nuwa, catok tike a bwiutiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","anduktangye, wori antu'u digerowo namiyeu yikom. ");
INSERT INTO bsj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","kwarub dige tee cikeu, nami. wonco digebwimiki atu'u dige na miyeu yicom. ");
INSERT INTO bsj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“katen biduwardi, mani kato yeti tak. kakten biduwar takri, kantoye.” ");
INSERT INTO bsj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","la kangum mor nob bwanka cebonin me bwiti ceti, ye wuro yibo tiye, kakten biduwardi mani ka toyeti, kakten biduwardi, kamtoye? takri man yaken teenin?” ");
INSERT INTO bsj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","lauki inye wuro tok tiye,” kakten biduwardi? nya nyombo dige ci yi nyo tiyeu.” ");
INSERT INTO bsj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeecu tori ci cwiti naci meco, lan yici “lakomki me bwiti dikirowo ma toki mii. kakten biduwar mani katoyeti, kakten biduwar takri kantoye'? ");
INSERT INTO bsj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","bilengke, bilengke, mi yi komti, kanciwiye kange bwatum, dila dorbitinero anma fuworneret, kandim ki neret, dila firneret kumero an yilam fuwor neret. ");
INSERT INTO bsj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","no wiye an nuwa buwarum ki kwama bore wori kwama boreu lam. lakambo cibom bweri, mani ca kwati ki buwarum tak, wori cima fuwor nererti cinbo nifir dorbitiner. ");
INSERT INTO bsj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","naweu kom firnerer, la matoten kom, ni kange mani ciyomfuwor nerero wotiye. ");
INSERT INTO bsj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ki ka kuwo, mani kom meye diger. bilengke, miyi komti, kwarub dige komken tee mor den mirori an ne kom. ");
INSERT INTO bsj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","wo diduwene kowo ka kenbo diger mor den mir. ko keni, kanyo, na fuwor nerer kumer yilam cikocok. ");
INSERT INTO bsj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","mi yi kom dige birombo mor danke. dila kume wiber nawo mani ma yentenkom kerti mor danke, nyori mayikom kero denemi lama yibo miman kwobdilo nyamglang dor tee mir. ");
INSERT INTO bsj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ki kakuwo, ka ken kenito mor denemi lama yibo miman kwobdilo nyikom tee minin, ");
INSERT INTO bsj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","wor tee ki bwi komti, wori kom cwiye, kom ne bilengke micirou teenin. ");
INSERT INTO bsj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ma ciro teenin lama dou dorbitinere. man dob dor bitinerowo miki yilang teenin.” ");
INSERT INTO bsj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","nob bwankacebo yiki, to,”can lamu tok keroti nyanglang, kebo mor danke' ");
INSERT INTO bsj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","na weu nyin nyumom mwa nyumom digero kwarub, kange nonin menen. la nyo nya nebilengke mwa coro kwama nin.” ");
INSERT INTO bsj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeecu ciyaci, naweu kane bilengke? ");
INSERT INTO bsj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","to, kwama winber, nyo, kwamaco lam ciya cutangten kom fiweu, kan yilarangen loco, kadobye ki kwami. naweu miki kwami nin tee wi kange mo. ");
INSERT INTO bsj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ma tokwo na kume fuwor nerero dim. kom nuwa dotangeti dor bitiner, dila kom biner wori min can kaba kange dor bitiner.” ");
INSERT INTO bsj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","kambo Yeecu tok nyeri, kun nuweceu dii. yiki, kan keneko lam, duktang bikwe mwe, na bweu duktangnen. ");
INSERT INTO bsj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kambo nuwa neco bikwan dor bibwe nifireu naci necii dume wo mwa neco manki dika. ");
INSERT INTO bsj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","won dume manki dika: ciya nyimom nen, mun kwama wincwar nii bilengke, kangeco mwa twomuweu, Yeecu kiritti. ");
INSERT INTO bsj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","min duktangnen dor bitiner, mindim na'nyendo muneyereu. ");
INSERT INTO bsj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","naweu tee kwama, duktangye wari kange mo kiduktangka ko miciko wari kange mo kikaba nyime dor bitinero no wiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","min fwetang nubowo mwaneye dor bitinereu den mwero. cine mwe, mun neken yeci, cin yo mwero. ");
INSERT INTO bsj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","canneu cin nyimom dikero mwaneyereu munen kwarub, ");
INSERT INTO bsj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","min neken ci kero muneyereu gwam. cin yo cin nyimom ma cirou munen, dicine bilengke mwo mu twom yere. ");
INSERT INTO bsj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","min kwob cinen dilo. miki kwom dilo kici nubo muneyere kebo dor bitiner, wori cina mwe. ");
INSERT INTO bsj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","wuyak dike na mweu nami, dige namiyeu na mwe, min duktangci. ");
INSERT INTO bsj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","naweu mimani dorbitiner, nubowe kino dorbitiner, miki yang munen. ");
INSERT INTO bsj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tee wucakke. tannci mor dene mweu mwaneyereu naci yilam win, kambo bi wiwineu. ");
INSERT INTO bsj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","mi bouti munwn, dila mi tok dikewoti dorbitiner na fuwor nerer miro dim. ");
INSERT INTO bsj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","min neci ker mwero, dila dorbitinero koci wori ci kebo na dorbitineroce, kambo mi kebo na dorbitineroceu. ");
INSERT INTO bsj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","miken nenbo na tumci dorbitiner, dila na tamci yora fiye nubo bwirko wiyeu. ");
INSERT INTO bsj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","cikebo na dorbitineroce, kambo mi kebo na dorbitineroceu, ");
INSERT INTO bsj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","yo kenci nadore mwece dorbilengker. ker mwero bilengke. ");
INSERT INTO bsj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","nawo mu twomye dorbitinreu, mi twomci nyo dorbitiner. ");
INSERT INTO bsj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","min yoken dormiro munen kercir, na cekenciyoken dor ciro ker mwer. ");
INSERT INTO bsj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kebo kawo mi kwob dilo tiye, kange birombo a ne bilinti keti minen ki ker mwereu, ");
INSERT INTO bsj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","naci yilamwin tee kwama kambo mu more miyeu, miti keni naci nowi more be na dorbitinerowo nebilengke mwo mu twomu yere. ");
INSERT INTO bsj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","duktangkako mu neyereu, min naci, yilam win, kambo biwineu. ");
INSERT INTO bsj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ci moremi, mu more me. nabe ci yilam win, na dorbitinero nyumom mwo mu twomyere, na cwici kambo mu cwiyereu. ");
INSERT INTO bsj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","tee mi cwiti nubo muneyereu a no kange mo fiye mi wiyeu, nacito duktangkako mu neyereu. wori mun cwiye ki kabo ywelka dorbiner. ");
INSERT INTO bsj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","tee wucakkeu, dorbitinero nyom nenbo, la min nyumom nen, labirombo nyimwom mwo mu twom yere. ");
INSERT INTO bsj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","min dokci cin nyimwom den mwero, man yitenci na cwikako mu mameneu na morece, mi keneu nan no more ce.” ");
INSERT INTO bsj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","kambo Yeesu tokum kero weni, ceri kange nob bwangka cebo cin yaken cu'nga cunnukur kidiron, fiye fotewiyeu cindo kenwi ci kange nob bwangka cebo. ");
INSERT INTO bsj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","naweu Yafuda niwo a nekoncotiyeu, nyumom fiyeco, wori Yeesu ki bow nyowi kange nob bwangke cebo. ");
INSERT INTO bsj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","la Yafuda, tinobda keboni kaba kange durem cimbo kanye fiye liya wabe ni kange farisawa, cin ki kira wenka kange kulen kiyaned. ");
INSERT INTO bsj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","kambo Yeesu nyimom digero yaken dorcereuri, ciro kab meci, “we ko dotiye?” ");
INSERT INTO bsj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","cin ciya co “Yeesu bwe najanret.” Yeesu yicii, Inmo.” Yafuda niwo neken cen tim kange no dakebo. ");
INSERT INTO bsj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","kambo ciyi cii ki” inmo,” ciin yilanken bwii ciin yarken bitine, ");
INSERT INTO bsj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","yilam meten ci tak, “we kom dotiye?” cin ciyaco Yeesu bwe najaret?” ");
INSERT INTO bsj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeesu ciya ci, min yikom inmo. non mo citiyeri, kom dob birombo a yakenti.” ");
INSERT INTO bsj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","wonadim kero citokeu. “mor nubo mwa neyereu, winwo lebo.” ");
INSERT INTO bsj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Bitrus niwo ki kulenneu, coku kwalum tuwo cacci yere wo bibwetomange nii wabe. den bwetomange co markus. ");
INSERT INTO bsj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeesu inyi Bitrus, dokken kulendo morloco. mani ma no kweelmunge tee neyeretiya?” ");
INSERT INTO bsj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","dila nob dakebo kange duciro kange nob dirlor Yafudawa ko tam Yeesu, ciin bwamco. ");
INSERT INTO bsj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ciin yakico kikaba Annas nen tee kon Kayafas nii wabe durko choroceu. ");
INSERT INTO bsj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas coni ne Yafudawa yuiande ki ladiker nii win abuyam kange nubo kilanyeu. ");
INSERT INTO bsj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Bitrus bwangtang Yeesu, nyo kange nii bwangka mane. nii bwangka kowa nyumom dur webebo, doken kange co mor luwece. ");
INSERT INTO bsj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","dila Bitrus tim nyilo kalek. dila nii bwangka ko nyimom liya wabe durken coru'u kale tokker kange nawiye to nyilok tiyen la dubom Bitrus dom mor. ");
INSERT INTO bsj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","dila nawiye to yilok kotiyeu yi Bitrus, mumani mor nob bwangka niwo ka?” yiki, kebo mo.” ");
INSERT INTO bsj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","naweu can nyabo kange nubo to lowabe tiyeu tirannyumwi, ci cukirati, wari cweto wi Bitrus tim wari kangeci cukirati. ");
INSERT INTO bsj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","dur lowabero me Yeesu nob bwangka cebo kange merangka ceko ");
INSERT INTO bsj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","Yeesu ciyaco minyi dorbitinero kero nyanglang. kwati bak mi ma merangketi mor bikur kwamar fiye Yafudawa mwerumti gwammeu matokbo diger yurangum yurange. ye bwi mu meryere? ye bwi mu merere? me birombo nuwa dige mi tokeu. nubo nubo wuro nyumom dige mitokeu.” ");
INSERT INTO bsj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","kambo Yeesu tok weri, kange mor nobdirlob tim wi cwuwa Yeesu in yiki, mu ciya durwebero ninti nyo.” ");
INSERT INTO bsj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu in ciyaco toki, “nomatok kero bwirdi yiye tano kebo naki yanecer, yebwe mwa cuwatiye? ");
INSERT INTO bsj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","la Hananiya tungen Yeesu Kayafa nin niwabe dur. ");
INSERT INTO bsj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Bitrus tim we cukirati. nubo meco, “mu mani mor nob kwangka ceba? wengkangum ki, kebo mo.” ");
INSERT INTO bsj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","win mor canga ni wabe, inke wiwo ci cwalum tuwo, yiki, mi to nenbo kange co mor foti? ");
INSERT INTO bsj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bitrus wengkangum tak, dangjang bicakeu mob. kiyyangeu. ");
INSERT INTO bsj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","la cin yaken ki Yeesu karak lirya ko durko. kin kwomce, ciki dorcer cidobe karak lirya ko durkonin, wori ci cwibo ci fwe ki caka kwaka ciko. ");
INSERT INTO bsj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","la Bilatu ceru'u bom meci kom bou ciko dor niwore?” ");
INSERT INTO bsj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“cin ciya ciki,” cano nii wo mani ma dige bwira bwiratiri, diger mani a dok yoti nya bouti ki kiyange ce munene.” ");
INSERT INTO bsj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatu yicii, kom yanken kico kibwikom ko warco nawo. warka kume tokeu.” dila Yafudawa yico, nyi man ki bikwan nyin warni nin bolang.” ");
INSERT INTO bsj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","citok wuro nadim kero Yeesu tokeu, wuro dang dorabuwa wo ca matinyeu. ");
INSERT INTO bsj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","la Bilatus yilam doken karak cou Yeesu yico ki, liya Yafudawa?” ");
INSERT INTO bsj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","wontok mwek kaka'a kannyemnob yinen ker miro? ");
INSERT INTO bsj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatus ciya coki mi kebo “Bayafudeka?” innubo lomwe kange liya wabe cibou ki nen, “ye mu mane?” ");
INSERT INTO bsj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu yico, “liyar miro kebo na dorbitineroce. liyar miro na dorbitineroceri, nob bwangka miko kin tekwen katiyolo cinekenye kang Yafudawa liyar miro kebo fo” ");
INSERT INTO bsj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bilatus yico ki “wendi mun liya ka?” Yeesu ciya, nawo mutokeu min liya. wonco dige bwi cii boyere, wonco dige bwi midou dorbitinereu, ci cuwa tuti ker miro nin. ");
INSERT INTO bsj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","kambo cito kweri, Bilatus meco, “kerbilengkeryer?” yilam cerin ya Yafudawa nin yici, mifeyabo niwo ki bwirangke. ");
INSERT INTO bsj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","kom wiki fulendo wo yiki, a womkan nii win nin ki kwama wo kom can kwaka yabkakotiyeu, wekom cwiti nyamka cinene liya Yafudawa ka?” ");
INSERT INTO bsj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ciin kundiro kibikwan cin toki, “kebo niwo, Barnabas” in ni kuye. ");
INSERT INTO bsj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bilatus mali Yeesu. ");
INSERT INTO bsj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","nob gwam nebo ku yilang duwe la cin yo Yeesu neti dor cin mer ciyene beller liyar. ");
INSERT INTO bsj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","cin bo fiye co wiye ciki dumwe a kutange liya Yafudawa. la ci tee co. ");
INSERT INTO bsj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bilatus yila ceri kale yi ci to man bo kumen ki nii co be no kom nyomom mafiya cubo ki kange bwirangke” ");
INSERT INTO bsj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeesu cero ki yilangk duwek cwakek kange kure na liyaro ce Bilatus ki nii co wo. ");
INSERT INTO bsj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","kange nobo dur webero wali kange tikertiyeu cin tam Yeesu, dila ci kwakiyyangti ciki a kulkenso, kulkenso la Bilatu ki kom tuco kom kulken mi mafiya chobo ki kerobwidi.” ");
INSERT INTO bsj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","la Yafudawa ci yi coki yonweki bwirangka kange nurwarka con daten bwar wori cin nyoken dorcero na bi bwe kwama” ");
INSERT INTO bsj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bilatu nuwa kero wo nyori la con cwa coko. ");
INSERT INTO bsj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","yila daten bwar kun gwam na, nyi Yeesu mocelufe?” layecu bciya cinen bo. ");
INSERT INTO bsj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","la Bikatu yico ki mani ma ciyayeti? mo nyombo miweki bigwan inyagum kan mwe, yila ma nyamgu kanti. kurkene ");
INSERT INTO bsj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu diye cine, mo manki be gwam dor mi naci, ne nefiren di kwamari, nyori wo neke ye moneneu co nii bwirangkeu,” ");
INSERT INTO bsj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","dila co nuwa nyori, la Bilatu mani naci yemgum kancine, la Yafudawa kun dir ciyero ciki na mo nyongum nii wo nindi bo kebo farar kaicar no nii wo tuken dor cero na liyari, in kan kaicar ni. ");
INSERT INTO bsj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","la Bilatu nurank kero belonabo la celu ki Yeesu kare nyara. nyike kabum kutirece fiye cico tike fiye bwirangke wo Yafudawa co tiki Gabbata” ");
INSERT INTO bsj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ki kakukowo ci yelank, lank dulubme yamkati, ki kwama kene nukune. la ki kakun, Bilatu yi Yafudawa “liya kume wo” ");
INSERT INTO bsj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","la ci kwadiro yangenki co, yanken ki co. Bilatu nyi ci ki kulken liya kume ka? la nobo dur wabero ki cin manki liya kange no kebo kaicar dii. ");
INSERT INTO bsj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","la Bilatu nici Yeesu naci kulken co. ");
INSERT INTO bsj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","la cin yeken ki Yeesu cero ki beteren bwiti yakenti cuika fiwo Yafudawa coti ki golgota” ");
INSERT INTO bsj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","cin kulken Yeesu fiye co nobo kangum nyob, kulken ci Yeesu la tiber cinyer. ");
INSERT INTO bsj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatu mulangti yurombo dor bentilen bwetiye YEESU BANAZARE, LIYA YAFUDAWA. ");
INSERT INTO bsj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yafuda duco cin kiye yurom bowo wori fiye ci nyom Yeesu wiyeu bi dom kange cinalou. ");
INSERT INTO bsj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","la nobo dur waber Yafudawa, ci yi Bilatu ki mulangti muki liya Yafudawa. mulang moki yiki co liya Yafudawa.”” ");
INSERT INTO bsj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatu ciya, ki dii kewo co. ");
INSERT INTO bsj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","la nob bi gwanem cin kulken Yeesu ci worangum billeceu kifiti nyo nar, nob bigwanebo ki ciye, yilank ciyegu woranm tau dii yanken cu co bitine. ");
INSERT INTO bsj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","la ciyi bwiti tii cike bo worak bilengke ci nyib dige co toke birinka wori kom ki kom ne bilengke ");
INSERT INTO bsj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","nob bigwan nebo balangum dikge wo no Yeesu, kange yitim cobo kange maryamu weikilofa, kange maryamu magadaliya. natuwo tim bidom kange fiye ci nyom Yeesu wii ye. ");
INSERT INTO bsj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","la Yeesu to neceri kange nii bwangka wo co cwitiye tem bidom, yiki to na we to be bweme.” ");
INSERT INTO bsj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","la to nii bwanka, to nemwen nob bwangka ce co tuco yangke co ko lo. ");
INSERT INTO bsj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","na wo nyeu Yeesu nyumom digero mor kwamare ma dim. la nyi ciki co nuwa durometi ");
INSERT INTO bsj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","cwi kanciyen kollo timwe ki mwebo fur cin doti cukko mwero bwotiye kange cin neco nico. ");
INSERT INTO bsj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","la Yeesu cun mobowo furi nyori “laye ciki dim la cunke ki dor cero lademkan dume ce ni. ");
INSERT INTO bsj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","la Yafudawa, wori kakun yerank kari ci domti bwiciye dor bantilank bwe tiye na yaken kaku foka (wori kakun furkako nyori fiyeci weye) cin kinan Bilatu na ciyeco na cugum ci ");
INSERT INTO bsj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","la nob bigwannebo bo. kiyalum na nubo burumbo nii kaba nii yobe bulo ci yuci wori kange Yeesu. ");
INSERT INTO bsj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","cin bou cifiya Yeesu bweyam ci keyanbo na ciyeko. ");
INSERT INTO bsj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","dila wii nob bi gwanne boning gwico kiya dange buyare kange mwebo ti ceri. ");
INSERT INTO bsj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","buro towo ciya yilam nii warka. warka ceco birinke. ");
INSERT INTO bsj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ci tokwo naci dim bifumer kwamaro kunko kange mani wo ciya kiyan tiye.” ");
INSERT INTO bsj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","kange bifumero toki, bon nii wo cikwareu. ");
INSERT INTO bsj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","bwiko dige borumbo, Yusufu nii Armatiya, con wi win mor nob tomange Yeesu, dila temi tai Yafudawa, yaken Bilatu a naco bwi Yeesu. Bilatu neco, Yusufu bõti bwiyo. ");
INSERT INTO bsj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ni ko dimu ken bõ wuro ki kabo bõ Yeesu nin ki dila bõnuwan ficange womur doceu kange alul wo lam tutum cwanka kweni kwabe. ");
INSERT INTO bsj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","dila ci tuti bwi Yeesu ciyoken co yilanforka kange nuko ficen ficenye. naci yimkan bõ na nur banka Yafudawa ceu. ");
INSERT INTO bsj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","fiye ciya ci yumce we kange tekewi, muro tekeu tuwe kangewi woci forumbo nii weye. ");
INSERT INTO bsj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","du waleu kaku yolanka Yafudawa tuwe bi la ci dogken Yeesu borece. ");
INSERT INTO bsj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ki kwamaco kangko win mor kume nibere tangum kumebo we, maryamu Magadaliya bo tuweu ni co fiya cin berum tero tuwenin. ");
INSERT INTO bsj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","yila takacon fiya Saminu Bitrus wari kange nob nanetbowo Yeesu cwitiyeu con yici cin tom teluwe we tuwenin yo yombo ciye ci yomco. ");
INSERT INTO bsj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","la Bitrus wari kange nob tomangeceu cin ceri, yakanke tuwenin, ");
INSERT INTO bsj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","gwam ciye cin tacoke wori, dila win mor bibei bwenkaco yulum Bitrus lakaco tuwe. ");
INSERT INTO bsj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","la tolari fiyaka yilang fwerka la dobo morece. ");
INSERT INTO bsj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","la Saminu Bitrus yauki bwiyi la do tuweni to ka ye lank fwerka yomwi. ");
INSERT INTO bsj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kan yilanko wene dorcero ciyabu wari kange yilan fwerkaka cin kumu cin yoke co ki kwace. ");
INSERT INTO bsj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","dila bei tomangece wo yaken ten wolom tuwetinen danuwe to la ne bilengke. ");
INSERT INTO bsj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yaken ki kwama wo ci nyobo bifumer wo yiki ankanu bore. ");
INSERT INTO bsj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","la bi bei bwonkace cin yelanken lo'o tok. ");
INSERT INTO bsj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","la Maryamu tim we tuwene ciwuyeti. co mor wuyeri cunge to tuweu. ");
INSERT INTO bsj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yeesu yico “Maryamu” laco yilak yico ki a mani ya na “rabboni” nii merangka. ");
INSERT INTO bsj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yeesu yico ki mana wiye meyere, mikubo dii kwama, yauce wifiye kemwebo yici muki yanfiye tekume wiye, kange tekume kwama mi kange kwama kume” ");
INSERT INTO bsj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maryamu Magadaliya yayi bibei kwangka ce ko, man to teluwe” nyila yiki co diroke buro. ");
INSERT INTO bsj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","diye kaba win na kume niberoce, bi beibwangka ceka cin dokenku ciki coya Yafudawa, Yeesu boti tiber ciyer ki bi bwege fu kume.” ");
INSERT INTO bsj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","con to bi bei tomangce wucakeu nyo yob tiram ki kulle do fwewor win tim dorcer, win nacek fiye ci fwerum Yeesu. ");
INSERT INTO bsj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","cin meco ki nawiye yemocitiye? ki wori cin tum teluweceu man yombo fiye ci yamki co weyeu. ");
INSERT INTO bsj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryamu Magadaliya cin bou ci yi bi beitonga cin to teluwe la tokke nyo cinnen. ");
INSERT INTO bsj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Diye co kime, kume win mor nibere nyiloko wo bibei tomange ce wiyeu nungun -nunge, tai Yahudawa ci nuwatiye, Yesu boun ti tiber ciyer, Yii cii fuwor neerer kumen. ");
INSERT INTO bsj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kambo co tok nyeri con nung cinen kang ceko kange cu-nka ceko, bibei tomange bilange kambo ci to Yeesu. ");
INSERT INTO bsj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeesu yi ci ki bibweyed ki no kumen”nawo teluwe tomyere, moma mi tomkomti.” ");
INSERT INTO bsj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","dila Yeesu dim tonkageli la funci ki yuwa komyo tembekoma. ");
INSERT INTO bsj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","nii wo kom citanci nen bwerangke ceu wiyeri, cin citencinen wi, nii wo kan tim bwirangke keceri cin tim bwirangkeceu” ");
INSERT INTO bsj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","tomawin mor kwob cilombo yobe, wo ci cuti ki biboyetagwai, mani ki kwama wo Yeesu bou cinenen. ");
INSERT INTO bsj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","tangnum nob tomangebo yico ki nyo to teluwe” tano ma tõ bo buwak tinim to terangkangce kiri, na dor bi wer kange mi buwak ko terange nineu, take nan dokti kangmico yare cank cank cekdi mani ma ne bilengketi. ");
INSERT INTO bsj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","kume nalub bei bokangceko wuranin mor luwe, toma wi wari cange ci nyiroko nuwang, nuwage cin to Yeesu tiber ciyet ki bi bwiyet ki kom” ");
INSERT INTO bsj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","layi toma to kangmiko. naneu kang mwe ko tenye nabo ne birinke? bi bwiyet ki nii wo toyebe lane birinke mine.” ");
INSERT INTO bsj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","toma ciya ki, teluwe mi kange kwama mi.” ");
INSERT INTO bsj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu yi co ki lamuto comunen bilengke? bi bwiyet kine wo teyebe lane bilengke mine. ");
INSERT INTO bsj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu ma yunbom kilang kilang fiye nob bwangka ce wiye, wo ciye murangbo mor bifumer kwamaro ninen ");
INSERT INTO bsj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","la ci murang wo nyo na kong ne birinke Yeesu co Almacihu, be bwe kwama ki bilengke be boneyeu co bi fiyam dume ki dencere. ");
INSERT INTO bsj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ki bwii nyori dang dorcero nobbwangka cebo ni nyi caji tibariya. Yeesu dang dorcero nawo. ");
INSERT INTO bsj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Bitrus wari kange tomas wo ci cwiti ki dan tangwai, kange Natanai'ilu wuro biten Galiliyeu, bibwe Zabedi kange nob bwangka Yeesu nyo yob. ");
INSERT INTO bsj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Bitrus yiciki,”miki yang taka jinnye.” cikin “nyiki yang wi ken kannyeco.”yacin doken mor tukomem dila citabo diger winwo kume co. ");
INSERT INTO bsj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","kanbo fini dadom celkari Yeesu bou ti kabum munyem, dila nob bwangka cebo nyombo kin Yeesu. ");
INSERT INTO bsj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","la Yeesu meci, Nabbarob, kom wiki dige ka catiya? cin ciya co, mani ");
INSERT INTO bsj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","lamyici, kom merken biliyan kumerofo kangko catiyer tukomero nin, kantau. cin merken bilinyaro la cii dolbo kwoba wori jinye ducce. ");
INSERT INTO bsj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","la ni bwangka ko wo Yeesu cwitiyeu yi Bitrus ki won kwama”kambo Simon Bitrus mor mu nye (wori ci kwanger), yanken mor munye. ");
INSERT INTO bsj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","la tangne nob bwangka cebo bou cinen mor bentilen mwemmer, wori ci kutangbo kange kong munyeu, kutangka ceko nako kuni kwobyob yaken dii ci kwobkang biliyaroti dimki jinnye. ");
INSERT INTO bsj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","kambo ci ceruweri, cnto korkirero jinye kange tiilita yomwe dorcer. ");
INSERT INTO bsj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu yicii ki “ko bou ki jinye kotau canakeweu,” ");
INSERT INTO bsj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","la Simon Bitrus ya kwom biliyaro dimki jinye kadur, 153 morece, kange kilaka cikowo, biliyaro worabo. ");
INSERT INTO bsj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu yicii “bokom camcarito.” Nimani mor nob bwangka cebo nin maco ki “munwe?” cin nyimom kwama ");
INSERT INTO bsj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeesu boutu jinnye kange tiilita neci. ");
INSERT INTO bsj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","wonco taareceu Yeesu bouti nobbwangka cebo ninne kambo ci twenum tuweri. ");
INSERT INTO bsj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","kambo ci cam cariteri, Yeesu yicii, “Simon Bitrus bi bwe Yuwana, mucwiyeti lawa? Bitrus ciya nyo kwama mun nyumom mi cwinenti” Yeesu yico, “munyumom mi cwinenti.” ");
INSERT INTO bsj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","yitenco yõbem, man bibwe Yuwana, mu cwiyeti ya?” nyo kwama munyomom mi cwinenti.” Yeesu yico, Ato kwama niti.” ");
INSERT INTO bsj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","yitenco ta'arecou, “Simon bebwe Yeesu Yuwana, mu cwitiya? ner Bitrus ceco kanyam wo Yeesu meco kiriti ta'ar, “mu cwiyetiya?” la cin toki, “kwama, mun nyumom digero gwam, mun nyumom micwinenti Yeesu in yico, “ne kwamemiu carito. ");
INSERT INTO bsj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","bilengke bilengke, miyinenti, ki kwama mun bwe bwayileu, mu bwador mweronin dakko tiye, nanyime muya fiye mu cwitiye. tano mu ciramdi, mwantar kangmwoko nakange bwamwen dakko, nakinen fiye mu kwabo yaka.” ");
INSERT INTO bsj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeesu tokkerowo na ci dang Bitrunin na nyomom buwaro camatiyeu na duktangka kwama keceu. kambo citoki nyeri lamyi Bitrus, bwangum ye.” ");
INSERT INTO bsj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus yila nuwari to nii bwangkakowo Yeesu cwitiyeu bwangcinentinti, niwo nyimom diger ki kaba dor Yeesur ki kwama wo cica caritori yiki, “kwama we niwo a neken nentiye?” ");
INSERT INTO bsj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bitrus toco lanyi Yeesu, “kwama, inye wuro matiye?” ");
INSERT INTO bsj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu yila yico “no mika ciya nintangye nanbouri, yeyonen wiye? bwouye,” ");
INSERT INTO bsj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","dila kerowo yatti kebcebo nin ki ni bwangkakowo mani buyati, Yeesu yibo Bitrus, ki ni bwangkakowo mani buyati, la cano mi cwiti nayi kange mori yeyonen wiye?” ");
INSERT INTO bsj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","wonco ni bwangka kowo tok keroburombotiye, woci mulangeu, la nyin nyimom kecoro bilengke. ");
INSERT INTO bsj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","dikero kan nyumbo witak wo Yeesu maneu. nacin bulangi kwarub kiwinti kiwintiri, miyi komti nero kibroco mani tu bifumero a mulangtiyeti. ");
INSERT INTO bsj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Bifumero mi mulanyi kika, Theophilus in tok dikero Yesu ter makau la merange. ");
INSERT INTO bsj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Na nyime diye cii tumou yaken dii kwama. Wo kambo cine nob tomangeb cebo cidoweu yuwatangbeke. ");
INSERT INTO bsj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kambo cinuwa dotangeri yadangu dorcero ciinen, ki yiromtinim dukce wo nyomkace. kume kwini naar ci dangu dorcero ciinene yi cii ker liyar kwamar ");
INSERT INTO bsj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kambo ci yi kange cii yeri in yi cii, ciya dobre wursalima dila ciya ningtang nor Teero, woci yiki, “Kom nuwa fiye mi wiyeu” ");
INSERT INTO bsj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yiti ki, cwerke man Yahaya yucinen mwembo kin wmom, dila ayukumen mwembo ki yuwa tangbeko wucakke, kume fo kutangbo”. ");
INSERT INTO bsj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kambo cii wariyeri cin meco Kwama ki kwamawo mwa yilauti ki liyar Israila ka? ");
INSERT INTO bsj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yi cii ki, a keno nakume nakom nyimom kan kenekowo kwama yo morbikwan durcereu. ");
INSERT INTO bsj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dila kom yo bikwando cano yuwatangbe kwamako bou dor kumerdi, lana nyime kan yilam nob wabebkeb min mor wursalima kange mor yahudiya gwam kange samariya, yaken ciko cwile dor bitinere”. ");
INSERT INTO bsj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ki kwama wo kwama Yesu tok kero birombem, kambo cito dii kwamatiyeri, dila cii tumco ciin yaken kico dii kwama, biloro yurangum co nuwece. ");
INSERT INTO bsj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kambo cii to dikwama ciya kenti yeri, dang jang nubo yob tim kaci ki kulendo fuwor. ");
INSERT INTO bsj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kom nabarubbo halili, yebwi kom tirangum fo komto dii kwamatiye? wuro Yesu yaken dii kwama, kambo kom tom yamcembeu dii kwamau ayilaunyo ");
INSERT INTO bsj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kambo cii yilau bany Zaitun cii yoten yilau wursalima wuro bidom kange wursalimau, yam kume nukkune ki dimen. ");
INSERT INTO bsj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kambo cii lameri, ciin yabken tiyak fiye cii yimtiyeu. ciin bi Bitrus, Yahaya, Yakubu, Andirawus, Filibus, Tomas Bartholomew, Matta, Yakubu bibwe Alfa Siman Yahuda bibwe Yakubu. ");
INSERT INTO bsj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gwam ce ciin mwerkang dorceo win, kambo cii ca kaba ki kwob dilo. Matta, Maryamu wo bo Yesu kange kebcoba cii wari. ");
INSERT INTO bsj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ki kume niwo Bitrus kweniti tiber kebceber, nubo kwini kwob toro kwini yob, yi cii. ");
INSERT INTO bsj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","keb mibo nii inwi wo ticiinen kaba ciitam Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wifo morebe lan yom dike naceu dor dike cimaneu. ");
INSERT INTO bsj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Niwo tenum bitine ki kemero cifiyau mor nagen bwirantum nerer cero, cin yaru wi kidor fwercero wurom, yeicero coru kale. ");
INSERT INTO bsj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nubo yimwi wursalima nuwam wo lacii cuwo fiyeco kin yicii “Akeldama” (Kiyiki fiye bwiyale). ");
INSERT INTO bsj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wori cii mulange mor bifumer Zaburad Lafiyeceu ayilam kamlo adobeni ayifiyeco kange atum nangen cero. ");
INSERT INTO bsj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nawori tamnyo win mor nubo wo wari kange bo ki kwama Yesu ma doka kange cerka ceko yeu, morebe. ");
INSERT INTO bsj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Terti ki yuka mu ngek Yahaya yakaken ciko kakukowa cii tumco binenneu yaken dii kwama a yilam, win morebe fiye tokka ker kwenkacek. ");
INSERT INTO bsj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ciin dang nubo yob Yusufu woci choti ki Barsabbas, wotak ci cho dendo ki Justus kange Matthias. ");
INSERT INTO bsj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ciin kwob dilo ciiki, kwama mo mun yob ner nubere. dan nyinen wo mu coke morece yobewo. ");
INSERT INTO bsj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Na tu nyi Yahuda fiye yahuda tiyangum meu yaken fiye” ");
INSERT INTO bsj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ciin mer dacendo dor ciir, dacendo yardor Matiyas dila ciin kiyeti co mor nob tomangeb Sulombo yobeu. ");
INSERT INTO bsj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kambo kume fentikos co bouwori, kwarubce ciin mwerum fiye win. ");
INSERT INTO bsj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nawo nawo diro kange wi dikwama na yuwako dur, yiram dim luweu cii yim wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","labiyondo kange na biyen kiret layiron cilnenti dor. ");
INSERT INTO bsj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ciin dimki yuwa tangbe kwama lacin ter tokka kereki nyini kangum kambo yuwa tangbe kwamako dang cinenneu. ");
INSERT INTO bsj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ki kwama co Yahudawa kangum wi yim wursalima, nob kwamabo fo dorbitiner. ");
INSERT INTO bsj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kambo cii nuwa diroweri, nubo gwam mwerum cii mor ciin nuwa nubo tikkan keroti kin yici. ");
INSERT INTO bsj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ciin to diker nyimankar laciiki, kibi chom birombo kebo Galiliyawaka? ");
INSERT INTO bsj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","manyi bi nuwa citi wiyak wuyakce cii tok nyowo cii bombotiye? ");
INSERT INTO bsj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Fisiyawa kange mediyawa kange Elimawa, kange Yahudawa kange Kafadokiya, mor Pontus kange Asia. ");
INSERT INTO bsj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia kange Pamphylia, mor Masar kange sunga libiya wo sur receu, kange fabubbo Roma. ");
INSERT INTO bsj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yahudawa kange proselyte, cretans kange arabian, be nuwa tokkeroti kin nyibo dor nangebdo durembo kwama maneu. ");
INSERT INTO bsj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gwam ciin nyimangi ciin yi bwiticeu, Yewo toktiye? ");
INSERT INTO bsj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kan nyumbo buwocii ki, ciin diim ki nyom. ");
INSERT INTO bsj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dila Bitrus kweni kange sulombo yobem, kundiro tok kerki “Nubo yahuda kange kom kwarub kom yim wursalima, kom nyimomwo, ko suwatuu ker mironin. ");
INSERT INTO bsj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nubowo ci dimbo diye ki nyom kambo kom kwatiyeu, wori kene Teer na burice koni. ");
INSERT INTO bsj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","dila won co dike toki ywel neneu nii ker dukumer. ");
INSERT INTO bsj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kwama ki nyo a yilati cwile kume, man coru yuwatangbeko dor nuber, bi biyolokumeu bayilob kange natub ciyan tokker dukumer. ");
INSERT INTO bsj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nyo tak dor caan yabmib bayilob kange natub, kikuke tindowe man corum yuwatangbe miko, laciyan tok ker dukumer. ");
INSERT INTO bsj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","man madiker nyimakar dii kwama kange dor bitiner, bwiyale kange kira, kange yilom. ");
INSERT INTO bsj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","kakokko an yilam kumtachile, chuwakko ayilam bwiyale nanyime kume durkowo kwamaceu nabou. ");
INSERT INTO bsj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","an yilam woco den kwama an fiya fuloka. ");
INSERT INTO bsj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nubo Israila kom cuwatuu kero birombonen. Yesu banzared niwo kwama nekom wuro kwama ma nangen durem more kume fiyeci wuyeu, nawo komki bwikom kanyimeu. ");
INSERT INTO bsj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nii wo ciin neken co kan nage kange yobka kwama cii neken co kom keneu kang nubo yombo ker kwamareu cii twalum ki kuldange. ");
INSERT INTO bsj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wo kwama kungun co cokeinen twirak buwareko cinenneu, wo mani natamce. ");
INSERT INTO bsj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dauda tokker donce ki kwamati kami ngir wori cin wi cunga kange cattiyeri katin mikannge. ");
INSERT INTO bsj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lanyori nermiro ma fuwer nerti biyel miro ti bilenke. Labwimiu anyi kibi kwan. ");
INSERT INTO bsj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mani mu minang dumemitiwi manu do wucakke mweti a to fuyenin. ");
INSERT INTO bsj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dang men nure dumeu, nawo tikob mwebo adim yeti ki fuwor nereu. ");
INSERT INTO bsj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Keb mibo man yikom ker nyanglang dor Tee Dauda: buyam ciin furomco dila tuweceu wifo wari kange bo di duwenokowo. ");
INSERT INTO bsj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nyori wori cin nii ker dukumer dila nyimom kwama macinen nor kiweri ki, mor tuwe luwe mwe man yoti kange kutile liyar cero nen. ");
INSERT INTO bsj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Cin tou dikero wo dila tok kero dor kwentka kriti mani cii ma bilankiya kange co fiye morka dumek, bwiceu tobo fuyeka. ");
INSERT INTO bsj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wo Yesu wo kwama kunco wuro wuyakbe bin nyimom. ");
INSERT INTO bsj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyori kambo cii kunco yaken kanka cattiyere kwamau dila nyo mor yuwa tangbe kwamako fiye Tee wiyeu coci corbinenneu wo komtoti takri kom nuwatiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dauda kwibo dii dila yiki kwama dila toki kwama nyi Teeluwemiu yiken kango cattiyeremi. ");
INSERT INTO bsj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Dila man yoken nob kiyeb mwebbo diker fuwaka namwek. ");
INSERT INTO bsj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","La nyori, naweu lo Israila a nyomom kang Yesu wo cii kulkenen kwama yoken co kwama kange kritti. ");
INSERT INTO bsj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cii nuwa nyori la kwerci nercer cii yi Bitrus kange tannineu nob tomangeb cebo. “Keb mibo ye ba matiye?”. ");
INSERT INTO bsj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","La Bitrus yiki Kom dubom bwiranker kumero nakom yumbom, mor den Yesu kristi na wam bwirangker kumero tak kan yo neken yuwatangbek kwama ko. ");
INSERT INTO bsj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wor noro ki kom kange bibeyo lokume, kwarub kange birombo kutaneu, gwam nubo tee be kwama a coutiyeu”. ");
INSERT INTO bsj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kero ducce cii ne warke naci chuwaci ki cii nayiki, “Kom fulom dor kumero mor kalewo bwiranyeu.” ");
INSERT INTO bsj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lakom yo kercero nacii yukumen mwembo, kume ciin fiyaten nubo cabten bikate taar. ");
INSERT INTO bsj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Lacii ca kaba ki merangka no tomangebbo kange yimbo winneu, mor caka tiilita kange dilo. ");
INSERT INTO bsj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Taito bou dorcir la cin ma diker nyimankaro kan ya yiromboti kila fiye nob tomangebo wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Gwam nubo nebilinker cii mwerum fiye win diker ciro na bwiticiyece. ");
INSERT INTO bsj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","La cii tokang dike cii cikeu kang dike cii ciko wiyakkeu laci kabkange dong dong kange cii cwitiyeu cii cikeu. ");
INSERT INTO bsj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Fini win cii ca kabati ki nero mor lo wabe cii kiyan tiilita lonice cii kabkang caritoti bwitice mor fuwor nerer kange kungne necer. ");
INSERT INTO bsj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Cii caklang kwamati ciin fiya yokati kabum nubem gwam. kwama cob cinenten nubowuro fiya dumetiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na wo Bitrus kange Yuwanna yakenti kuwabe kwama ki kwma kwobka dilo kan keno taar. ");
INSERT INTO bsj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ni kange kilen ci bouciko nyo cii ki tuu kwaticobak nabou ciko nyilo kuwabka wo cii coti ki yoryoreu ki ken kim nubo dokenti mor kuwabi kwamau. ");
INSERT INTO bsj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","To Bitrus kange Yuwanna doken mor kuwabi kwama, kenci luma nerer. ");
INSERT INTO bsj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bitrus kange Yuwanna ciin cii cinenten kanuwe Bitrus yiki, “To nyo”. ");
INSERT INTO bsj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","kilendo to cii kwatiki keno can fiya diker ciinen na. ");
INSERT INTO bsj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dila Bitrus yiki cilfa kange mwiin, kange nai mi mani ciko, Dila dike min cikeu co manetiye. mor den Yesu kristi bwe Nazaret, ya yam”. ");
INSERT INTO bsj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bitrus tam kanceko cattiyero kunco nawo nawo naniceu kange kutile naniceu fiyam bikwan. ");
INSERT INTO bsj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","La kilendo kweni tari teryambo doken kuwabe kange Bitrus kange Yuwanna citi fuwai citi mwai ci ne kwama durkoti. ");
INSERT INTO bsj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nubo tou co yayambo, caklang kwama. ");
INSERT INTO bsj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ciin nyimom ki coni kiyire nyilo lo wabi yoryori la ciin dim ki nyimanka ki dikero bweyeu. ");
INSERT INTO bsj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kambo ci tamki kang Bitrus kange Yuwanna nubo kwarub kutauten ciinen, cunnge Tangilang sulemanu Cii ti nyimangi kambo ken. ");
INSERT INTO bsj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kambo Bitrus to nyeri in cinya nubow kom nubo Israila yebwi kom nyimang tiye? Yebwi kom cii nyinenten duwenye, mumi nyo nyi dokco co ciya yambo tiye kibi kwan dorer nyer kaka'a ki luma nyak? ");
INSERT INTO bsj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kwama Ibrahim, kange Ishaku, kange yakubu kwama teebnyebe ne bwe cannya ceu durko Yesu co kom koweu takri ka nekenco kabum Bilatus wo noncwi naci nyam kang cinen neu. ");
INSERT INTO bsj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kom ko niwo wucakeu nii lumake nyori lakomki a nya kumen kang niwo twal dore. ");
INSERT INTO bsj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kom twalum niwo ne dumetiyeu, wo kwama kunnyu tuweu, nye nyim nob neka bilenker dikero bwiyenen. ");
INSERT INTO bsj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","na weu, bilenker ki dencer niwo kom toti takri kom nyimom kinco dende wo cifiya bikwaneu. Bileng mor Yesu neco luma ceko cike cok, kabum kumem. ");
INSERT INTO bsj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kebmibbo min nyimom kom mayeu mor bwini nyomka, kambo liyab kumeb maneu. ");
INSERT INTO bsj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dila gwam dikero kwama tokanyi nob tomangeb dukumemcembou ki, Kristi an nuwa dotange landim. ");
INSERT INTO bsj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nawo yeu kom dubom bwirang ker kumero kom yilau dabe wam bwirang ke kumeu, wori kwama ywelkako fiye kwama wiyeu lam. ");
INSERT INTO bsj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na cii tomuu ki kristi wuro cii yokumen lan, Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Co wuro intam kang dii kwama a yoceu yaken lam tureni bo kacek kange dikero gwam dor dikero kwama toki fiyaco nyi nob tokkaker dukumer wucakeu. ");
INSERT INTO bsj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa tok bilenker yiki Tee kwama an kunkumen kange nii ker dukumer na mo mor kebkumebo. kam nuwa dike cayikomtiyeu gwam. ");
INSERT INTO bsj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","An yilam niwo nuwabo nii ker dukumer wurori ciiyan tungumco ciko win nubo locem ");
INSERT INTO bsj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nyo nob ker dukumebo terti dor samailar kange burom bou bwiko cekeu cin tokker ciin cwungkang kumetinimbo wuro. ");
INSERT INTO bsj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kom bibei nob kerdukumerowo kange noroceu wo cima kange Tengwanub kumubeu, kambo ciyi Ibrahim mor tueluwe dor bitiner gwam ciyan fiya bibwiyer. ");
INSERT INTO bsj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","kambo kwama kun nyum bwe tomange ceri ci ter tomangekaco kumen wori nekom bibwiyer kambo yilam kikom fiya maka bwirankerer. ");
INSERT INTO bsj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kambo Btrus kange Yuwanna cin yi nubo kero tiyeu nii wabeu kange, nii durko kuwabeu, kange Sadukiyawa cin bou dor cer. ");
INSERT INTO bsj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","kwomci bichom wori Bitrus kange Yuwana merang nubo nenti dor Yesu, la ci ne fulen kwenka cekoti buwareu. ");
INSERT INTO bsj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","La cin tam ci cin kuken ci lo kuka na finin celum. wori men dom. ");
INSERT INTO bsj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","La nubo buro nuwa tomange ciyeu cin ne bilenker kilaka nubeko nabarobbo bikate nung wuro ne bilenkere. ");
INSERT INTO bsj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Celfini ceri nubo tam ki ciyeu kange nubo durko kange nob merangkab cin mwerkangi wurcalima. ");
INSERT INTO bsj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ana nii wabe durko wi wi, kange kayafas, kange Yuwana, kange Alexanderi, kange nob naniya nii wabeko durko. ");
INSERT INTO bsj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kambo ci bou ki Bitrus kange Yuwana tiber cer la ci me ci ki bi kwando wini kaka dendo wini ka mam woticike? ");
INSERT INTO bsj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","La Bitrus dim ki yuwa tangbe kwama yi ci, “Kom ko tam ki nobeu kange nubo dur nubero. ");
INSERT INTO bsj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Na nyo duwen kom ki me nyo ker nagenero kendo ma niwo nuwa bo lumanineu-Lama nyi nii wo yilam kwamere? ");
INSERT INTO bsj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","la kom kange nubo Israila la wuro a yilam nyam nyome kimen wo nii wo tim fou ka kom kwamer mor dene Yesu Kiriti wo nazaret deu, wo ka kulkenceu, la kwama kungum co bwar. ");
INSERT INTO bsj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu kiriti cou tero wo culang kuwekeu wo kom nob mukabo ka koweu la co yilam tero culang kuweke. ");
INSERT INTO bsj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Fuloka mani nii kange nen wori dendo kange mani dimer di Kwama wo ci ne niffire na fiya fuloka kercere.” ");
INSERT INTO bsj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kambo ci to bikwan nerer Bitrus kange Yuwana ri cin nyumom fuwai nube koni ma bo kiye ka. La citi nyumangi la cin nyumom Bitrus kange Yuwana cin yii wi kange Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","La cin to nii wo ci twabeu tim kange ci, la ci fue ki diker tokkar. ");
INSERT INTO bsj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","La kambo ciyi nob tomange a dubangum fiye yime nub dirlorembedi. La ci tokkangi bwiti ci. ");
INSERT INTO bsj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba ma nubo buro nyi? kwaka nerer man, nangen nyumankar mani kang chek. La nyumom nyume nubo yim wurcalima nin gwam. La be man kibi kwan do ba kanagum tiye. ");
INSERT INTO bsj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","La kati ta ca kaba ti ki wakako mor nobe labo yi cikero ki nyial, ci a tokre ker kange nii dor denerowo. ");
INSERT INTO bsj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","La cin co Pita kange Yuwana mor cin yi ci kero ki yial cia tokre ker kaka merangka gwam kiden Yesur. ");
INSERT INTO bsj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","La Bitrus kange Yuwana yici keno dong dong nuwe kwama na nyo bwnangten kom la'a kwamari, kom warkero. ");
INSERT INTO bsj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mani nya dob tokka kerti dor dikero nya tomeu, kange wonya nuwameu. ");
INSERT INTO bsj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bwiko ci yiten Bitrus kange Yuwana kero ki nyialri, la cin dob ci cin cu'u. Lafiya bo nure wo ci a tam citi ki kang keu. wori nubo gwam duktang kwama ti ki dikewo bwiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nii wo ki nyumka dukumero wo ki fulokau, chor cero kwini naar. ");
INSERT INTO bsj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","kambo ci nyamkan cineneri, Bitrus kange Yuwana bou nubo lo cinin la ci yii ci dike liya nob wabebo kange nubo durko yi ciyeu gwam. ");
INSERT INTO bsj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","La cin nuwa ri cin kung dir ciyero wari kwama nen cin toki “Teluwe” mo wo mo ma dii kwama moma dor bitinereu, kange caji kange dike more ceu. ");
INSERT INTO bsj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mon tok kero ki yuwa tangbek nyi canga mwe tee nye Dauda, yebwi nubo yim kumtacile? fwingan ti nye la nubo ki kwa kan dikero bwir. ");
INSERT INTO bsj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mon yiki “Liyabbo dor bitinereu mwer kangum dor cer wari la nubo dur cero mwerum na ci ma kiye kange Teluwe”. ");
INSERT INTO bsj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bichom Hiridus kange Pontius Bilatus kange kumta cileyeu kange nubo Israila cin mwerkangi fo mor cinan lor na cin kwobkangi kange canga mweu wucakeu Yesu, wo corten nuwageu. ");
INSERT INTO bsj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Cin mwerkangum wari nacin mam dike kang mweko kange namweko amatiye. ");
INSERT INTO bsj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na weu mo teluwe to kercero ki nyial ne cangab mwebo bi kwan tokka kerek mweko. ");
INSERT INTO bsj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta'aru kang mweko na twam la na ne diker yiromer kange diker nyumangkar a mani ki den canga mwe wucakkeu Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kambo ci dim kwob ka dilokeri, fiye ci mwerum wiyeu muka, cin dim ki yuwa tangbe kwamak cin tok ker kwamaro ki bikwan. ");
INSERT INTO bsj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nubo ducce ne bilekereu dor ciro mwerum mwere. la kange nii yi bo ki diker cer na ce la nyeu dike na ciyeu win. ");
INSERT INTO bsj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ki bikwan nob tomangebo ma kwaka diyek warkerer ciyero dor kwenka teluwe “bwareu, luma ko dur wo dorciyere. ");
INSERT INTO bsj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nii kange mani wo fiyabo dikere wo ci buni kange dikere. wori nubo ki tang kini kange loni miyerangum la bou ki kyemer dikero wo ci miyeu. ");
INSERT INTO bsj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","La cin yotina nob tomangeu nen, la kabkang nubo nen gwam dong dong kange dike ci cwiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu wo nob tomangeb coti Barsaba (bwe bika nerek) Balewi nii Kubrus. ");
INSERT INTO bsj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Miyem take wo na ceu la bou ki kyemero yoti na'a nob tomange nen. ");
INSERT INTO bsj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","La nii kange wi Anatiya wice safiratu, cin miyem take ciyeu. ");
INSERT INTO bsj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ananiya yurangum kangem wi mor kyemer takero (La kin nyom ka wicek) La ci bou ki tangnim kyemembo kabum nob tomangebo nen. ");
INSERT INTO bsj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","La bitrus yi ki “Ananiya ye bwi mwa dob bwekelkele dou ner mwere na cer yuwa tangbek kwama nen cuerke na tam tangim kyemer takero. ");
INSERT INTO bsj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na miyebeu, kebo na mwe, la miyemmeu bikwankero kebo na mweka? we nii coo dokti nangen do wo mor neere mweu? mwa cuerbo nob nen cuerke mwa cuerum ki kwama. ");
INSERT INTO bsj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ki nuwa ka kere kowo Ananiya yari la bwiyam, la taito dur tam nubo wo nuwau gwam. ");
INSERT INTO bsj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bibweyile kange bou tum co chom cinen bwiceu ki lalang ya cin furum cho. ");
INSERT INTO bsj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kambo kang kenero ta'areri wicen dou nyombo dike yaken tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","La Bitrus yii co “yii ye kenoka miye takeu nan nyo cen”. La chon toki ong na nyo ce”. ");
INSERT INTO bsj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","La Bitrus yii cho, la manyi ka ciyam wari na kom cuwa yuwa tangbek Teluwe? To nani nubek kowo ya fuer bwemeu wo nyilo la na tuken nen kale. ");
INSERT INTO bsj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Danjang chon yar ti na cek chon bwiyam. Kambo bibei bayilobeu douweri bocifiya chon bwiyam, la cin tu cho ci cerken ciko kale cifuerti cho cunga bwece ko nen. ");
INSERT INTO bsj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Taito dur bou kuu kwama nen kange dor nubero gwam wo nuwa dike wo gwameu. ");
INSERT INTO bsj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","nangen yiromer kange diker nyumankaro ducce matiye mor nobe kange nob tomangek ci mwer kangum gwam bentilen colomoner. ");
INSERT INTO bsj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","La kangem mani ki bikwan neerer do wo a mwer dorti kange ciye. La cin wi ki bwiyale foh ducce kabum nubem. ");
INSERT INTO bsj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","La nyeu, nubo buro ne bilenker yuktenti Teluwe nen, nubo kila-kila na barub kange natub. ");
INSERT INTO bsj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","La ci turang nubo nuwabo lumau, ci yaken cike kong nure ci yokenci dor kwangnir, kangembo biciri, worina Bitrus cuu tiri, wuloceu cuuti dor kangem. ");
INSERT INTO bsj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nubo ducce borangum ti ci nan lor kentangum wursalima la ci bou tiki nubo nuwa bo lumau, kange buro kelkelibo kwomci tiyeu. lan twam ci gwam. ");
INSERT INTO bsj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","La nii wabe durko kwenu kange nubo wari kange ceu (nubo bwangten Sadukiyawa tiyeu) cin dimki kor ducce. ");
INSERT INTO bsj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Cin tabang nob tomangeu cin kuranken ci lo kuka. ");
INSERT INTO bsj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mor kumeu bwe tomange kwama wucakeu bou wumom nyiloni lo kukako. La cho kuci kale, lan toki. ");
INSERT INTO bsj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kom ya koti kabum nyilom ku wabe koyi nubo ker dumerowo. ");
INSERT INTO bsj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","kambo ci nuwa weri la cin cuu kuh wabe ki celka finik cima merangkati, la nii wabe durko kange nubo loceu cin bou bo cin cho yim kange nob dir loreb, kange nubo dur nubero Israilau, cin tuken ci fiye kuka ");
INSERT INTO bsj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","La nob nangebbo ya lo kuka konen ci fiyabo nii. ");
INSERT INTO bsj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","nyon fiya lo kukako nungum nunge, nob chorkabo tirangum nyilok la wumi ri nya fiyabo nii mor, ");
INSERT INTO bsj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","La nii dukro kuh wabeu kange nob wabebo durko nuwa ketito weu, la ner cero kwenum cin nyombo dike a bangum bwiko tiyeu. La ciki ye ba matiye. ");
INSERT INTO bsj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","La kange bou yici nubo buro ka kumeu tirangum kuh wabe merang nubo nenti. ");
INSERT INTO bsj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","La nii dur ko kuwabeu ya kange nob nangeneb ceu yan bou ki ci. Kebo ki kwobkanka kati yilo nubo mobangci. ");
INSERT INTO bsj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kambo ci bou ki ciyeu cin nung ci kabum nob dir loreb, la nii wabe durko me ci ker. ");
INSERT INTO bsj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Yii ci “Nya yi kombo ki kibikwan tak kom mare merangka mor denewo? la wo kom dim mor wursalima ki merangka kumek La kom doti na ko yo buyalenii wo na yiram dornyer”. ");
INSERT INTO bsj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","La Bitrus kange tangnim nob tomangebo toki tam nyo ne kwama dur kebo nob. ");
INSERT INTO bsj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kwama teb nyebeu kung Yesu woro ka tualumeu ka kulken dor bwatiyer. ");
INSERT INTO bsj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kwama duktangka cho kange catiyere ce na yilam liya kange nii cerka na ne Israila yiloka kange tabkan bwirang kerer. ");
INSERT INTO bsj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nyeu nyon nob warkeb dike bwirangeu nyo yuwa tangbek kwama ko wo kwama ne nubo wo bwanten tiyeu, gwam. ");
INSERT INTO bsj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kambo nob dir lorebo nuwa we di nerciron kayam ki bichom, la cin do na ci twalangum bibei tomangeu. ");
INSERT INTO bsj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","La bafarice kange wi dendo Gamaniel nii merangka werfumer, wo nubo gwam necho durtiye, la chon kweni tok kero ki nyial a chokken bibei tomange kale biduwar bwiri. ");
INSERT INTO bsj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","La chon yici kom nubo Israila ko to yora ki di keko cuiti na ko ma nubo buro neneu. ");
INSERT INTO bsj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ki kumeni wo Theudas kweni tii tu dorcero na kange diker nubo kwini kwob naar bwang cinenten la ci twalumchori nubo bwang cenententiyeu gwam cin yilam kange nii nuwa bo fulen ciyaer wi tak. ");
INSERT INTO bsj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na chori kange nii Galilee dendo Yahuda wo ki kumeni kiyeka bou bolang nubo ducce, cho keneu kayam nubo buro bwang cinen tentiyeu yilam. ");
INSERT INTO bsj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na wo ma yi komti ko dubang nubo buro, ko dob ciki kwaciye, na no yukan ciyero kange nangen ciyero na nubo ciyeri an kayam. ");
INSERT INTO bsj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","La na dike wuro na kwama ceri mani ka kangti kati yilo yilam ko ma kiye ti kange kwama. La cin ciya. ");
INSERT INTO bsj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","La cin cho nob tomangeu mor la ci buk ci la yici kero ki nyial a tok re ker ki den Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","La cin cerum kabum nob dir lorembonen ci ti bilangi wori cin daten ci nuwa dotange ki ker denero. ");
INSERT INTO bsj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bwiko nyeu citi yai kur waber kir-kir. Ci bwang ten ti luwe ci ne fulen ker kwamaro ti, La ci ma merangka ti ci kurong bowi citokti Yesu Cho Kritti. ");
INSERT INTO bsj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","mor kumeniwo kilaka bibei tomange yoktenti la yafudawa yim biten Elenawa cin ter fuenna dor Yafudawa Israila wori ci cuwa bo tu kange natub buneb cibo, fiye kabkanka carik kabkangti kir-kireu. ");
INSERT INTO bsj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kwob chilombo yobeu cho bibei tomangeu kila kila cinen la yici yorbo dubom nangen kwamar na yila kabkanka carik. ");
INSERT INTO bsj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","La nyeu ko chok nubo niber na barubbo more kume, nubo ki ciniyeu din kiyuwa tangbe, kange nyonka, buro ba yotenti dor nangenero weu. ");
INSERT INTO bsj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ka nyeu, kwobka dilo kange tokka kerek ceko kir-kir. ");
INSERT INTO bsj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ker chiyero lom nubo nen gwam, la ci chok Istifanus nii dim ki bilenkere, kange yuwa tangbe kwamak, kange Filibus, kange Prochorus, kange Nicanor, kange Timon, kange Parmenas, kange Nicolaus nii Antakiya wo ma yiloka Yahudanci yeu. ");
INSERT INTO bsj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nubo ne bilenkereu bou ki nubo buro kabum nob tomangeb, la kwob cinen dilo ci yo cinen ");
INSERT INTO bsj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","La ke kwamaro yoten kang ti wai, la kilaka bibei tomangeu wursalima yokten ducce, la nob wabebo ducce yilam nob neka duwek fiye bilenkero wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","La Istifanus dim ki luma kange bikwan ma diker nyumankar ti kange diker yiromer mor nobe. ");
INSERT INTO bsj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","La kangen nob kweni wo na bi kur wabero ce, choti bi kur waber cerka, wo kuramiyawa kange Iskandariyawa, kange biten kili kiya, kange Asiya. Nubo buro kwob kangi kange Istifanus, ");
INSERT INTO bsj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","La cin mani kibi kwan ker nyomkar kange yuwa tangbe ko Istifanus tokkero ti cikeu. ");
INSERT INTO bsj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","La yurangum yurange ci bol nubo ya a tok ki, Nyo nuwa Istifanus tok keti dila kati dor Musa kange kwama. ");
INSERT INTO bsj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Cin bol nubo durko kange nob mulankabor, lan cin lam bidom kange Istifanus cintam cho, cin bou ki cho kabum nob dirlorem. ");
INSERT INTO bsj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chin borangu ki nob warker cuiker, wo toke, nii wo dobbo tokka kereko bwir dor fiye wucakkewo, kange werfuner. ");
INSERT INTO bsj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","La nyon nuwa chon toki Yesu wo najaret reu an wurongum fiye wo na fulongum dam Musam bo dob bineneu. ");
INSERT INTO bsj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nubo gwam yim dir loro neneu yo cinenten nuwe ciyero La chin toh tikob cebou na tikob bibei tomange wucakkeu. ");
INSERT INTO bsj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kambo nii wabe dur tokki mi digenwuri na ken bicom ka? ");
INSERT INTO bsj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen toki yimi kange Teemi, kom nuwaye. Dukum kwamaro wo kange Abraham ki kwama me sopotamia, na nyimde ciyi firen Haran. ");
INSERT INTO bsj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ci nyico ki, dubom bitine mwe kange tengwanim mwembo na yaken biti wuro ma nungmeven tiye. ");
INSERT INTO bsj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dila chon dubom biten chaidean la yim mwor Haran, di wiri bwiyaka tee cekkori kwama bou ki cho mwor takke wo, fiye mu yimwi naweu. ");
INSERT INTO bsj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chon necho kangem nob wuro wari kange ce na Tikange cho. mani bi duware ce, bwen wo mwa fuwam natiye dor cere, la chon tum fou ner bwentano Abraham manki bweri kon matin necho takke wo ca nyimtiye gwam kange ten gwanim cero bwan tano con bwiyam di ");
INSERT INTO bsj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","kwama yico kerti na wuro nubo loca ciya yi bidom bitine nubo kange. Nyo fiyeyinu cho limbo dige bwiye atin bou chinen ki yera na bibei canga catin nuwa dotange na choro kwini kwob naar. ");
INSERT INTO bsj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","La man ma bolang kale kowo neci dotange tiye kwama ki ciya cheruw nacin wab ye fiye wo nen. ");
INSERT INTO bsj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","La kwama ne Abraham diker wabka, di la Abraham yi lam tee Ishaku lan wabum cho ki. kume narube, Ishaku yilam Tee, la Jacob yilam tee bibei yo wab culom bo yobe ");
INSERT INTO bsj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kambo yitub cebu ciyabo kange Joseph la cin miyem cho nab yamembo Egypt La kwama kange cho. ");
INSERT INTO bsj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","La cercho mor dotange cenen. La neeh Joseph fofka kange yomka kabum Pharaoh liya Egypt wo yocho dur nubero gwam mor Egypt kange mor lowenen gwam. ");
INSERT INTO bsj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kambo ci ma wura dure di titen macar kange kan ana kange dotange durko tebbebbo nuwa la ci fiyabo cari. ");
INSERT INTO bsj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","La Jacob wo nuwa carito wini masar di cho ci tom tomange ciya bou ki bwo kabo. ");
INSERT INTO bsj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","kambo chiya boka na yobe ceri, la Yusufu fweltang keb cebonen dor cer ki kwa curo fir auna nyimom yitub Yusufu. ");
INSERT INTO bsj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu yi yitub cebo chiya bou ki tee che Yakubu kange diker ciyero kange bibei yo locheu firen Masar, gwam ciye nubo cibi kwini niber culombou nung. ");
INSERT INTO bsj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu choken yim firen biten Masar la chon bwiyam kange Tee ce. ");
INSERT INTO bsj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chin tucho mor Shechem la chin yoken cho mor tuwi wo Abraham Teni ki kyemer bibwe Hamor nen Shechem. ");
INSERT INTO bsj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","La ki kwama bi bwiyer kwamaro bidomeri Kwama yi Abraham nubo an duwi mor Egypt be. ");
INSERT INTO bsj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","La chin yoh kange liya wi Masar wuro yumbo Yakubu. ");
INSERT INTO bsj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Liya chiro bol nubo ne tebyebbo dotange kambou ken chin dukchi tebyebo ki ciya cukou dor cero fiye dotange mani ciya dobchiti. ");
INSERT INTO bsj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ki kwama wo chi bou Musa, Cho yori kabo nanimde kwama na yocho chuwakko taar mor loh tee ce. ");
INSERT INTO bsj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kambo chi yoken cho kaleri bwebubya Pharaoh's tumcho kung cho na yilam bibwe che. ");
INSERT INTO bsj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa wiki yulang merang biten Egypt kange bikwan keret kange nangen. ");
INSERT INTO bsj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","kambo cho dou choroti kwini naar re ri chin kwabi mor nere ce ki cha tou yice bibei Israila. ");
INSERT INTO bsj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","La chon to nii kange ti Musa tikaan niwa ci nuwa dotange ki twalka bama care. ");
INSERT INTO bsj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kwaneri Musa na ci ciya takali kwama bou cinenne di la mani nyo. Chin yombo Kwamaki kancak cha chok chi la chi yombo. ");
INSERT INTO bsj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chelfini chin bou irsailawa kangumbo ki kwalkangi bwiti chi la chin mani nacho bouchinen ki filang bwiti yichi ki yebwi kom kwerkanti bwitikume? ");
INSERT INTO bsj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dila nii wo ter keceu tuken cho firen yi ki necho liyar do wo more che? ");
INSERT INTO bsj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Muki cwi muki namun twalum yoh kambo mwa twalum Israilawa wure ka? ");
INSERT INTO bsj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa chawaken kambo cha nuwa wori chon yilachinendiker yumankar biten Midian, wo cha yilam Tee bibeiyo yobou. ");
INSERT INTO bsj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kambo choro kwini naare chum meri bibei tomange cher cenen mor Yeri bang sinai ki biyen kiret mor yere. ");
INSERT INTO bsj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kambo Musa toh kirak keri yimanka lan fiyacho, lan chi kutau ten bidom na chi toh yora, chin nuwa dir kwama tok ti ki, Mo mi kwama tee mwe, Ibrahim kange Ishaku, kange Yakubu, kange Masu cwam tai fwe ki kungka dor nacir to. ");
INSERT INTO bsj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","kwama yi cho ki chukom tai mweu fiyemin tim wiyeu. liyar kwama. ");
INSERT INTO bsj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kwama yi cho ki chukom taa mweu namwek fiye mun tim wiyeu nku wabe. ");
INSERT INTO bsj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kebo koni nubo lomi nuwa dotangeti masar la min nuwa fubom ciyembo, no nyori manya na chukom chi sanakowo, bou na twom nen Masar. ");
INSERT INTO bsj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","wuro cho Musa chi kuwe dila kom ki we doknen ni warka dor nyere cho niwo kwama tomou na yilam ni dure kange ni cerka kwama ni bwirer kambo cho tou mor kiye. ");
INSERT INTO bsj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa yaki chi mor masar kambo cha madukum mor chachi ki kume kwini naar. ");
INSERT INTO bsj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa yi nubo Israilawa ki kwaka an yoh kumen nyi wabe dur bitine kume, yotob kumeb na mou. ");
INSERT INTO bsj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Won cho nii wo wari kange nobe mwor kiye ki no tob kange nob dukkumen wuro bwangten ka cho chi mane tokkang ker dor ter Sinail cho wo wari kange teb yebbo wuro cho ni wuro ne nyo ker kwama. ");
INSERT INTO bsj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Won cho niwuro tebyebbo ko neka ko bidwiyere ci chikom cho more ciye, chin ne birum neri chiki yang masar. ");
INSERT INTO bsj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ki kwama chi tokti ki Aruna na ywel chimen kwama wo a yati ki chi mor masar reu. diker Musa ro churou firen masare nya nyombo diker bwikange ceu. ");
INSERT INTO bsj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","La chin ywel be kwame chi bo bi bwitin chukko na ywel kako koce, chin bilangi diker chi mani ki kang chekeu. ");
INSERT INTO bsj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kwama kangum chi la chin ya bilang bitenrendo diye kambo mu langum bifumer nob duktanka kom neye twimen kundo fichangeu. firen ki choro kwini naar wuro kom Israilawa? ");
INSERT INTO bsj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kom ciya kange kwama Molech kange kwama biteiren wo Rephan, kange wolo kom yulange. na kom wabci, man yi kikom firen kah Babila ki den canga. ");
INSERT INTO bsj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tuka kume kibi kur fulen firen ki na nungi chin wi. kambo kwama ma nagen ki Musa ki cha mani na wuro chi nung chineneu. ");
INSERT INTO bsj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wo cho bikur fulendo tuka kume bou chike ki kwama Joshua wuro bou ki kwama chi yo bitine kange wo nubo kange ce wo kwama ywachiye wi kabum tuka kume nen na choro nyo yaken ki kwama Dauda. ");
INSERT INTO bsj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wo fiya bilangka kwama nen diker bwiyeu chin ywel ku wabka kwama ki kwama yakubu ce. ");
INSERT INTO bsj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","La Suleimanu ywel ku kwama. ");
INSERT INTO bsj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Di la nii liyare mani yi fiye nubo yulangi ki kange na wuro nii dukkome tokke. ");
INSERT INTO bsj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Di kwama na liyar ce kalewuro ceu na yoka nanice di la luwe wini ka mumentiye? kwama toki nyowe, kakka fiye wuni wo ma fubomtiye? ");
INSERT INTO bsj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kebo nuremi kom manag diwura? ");
INSERT INTO bsj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","kom nubo ki kwichi duweu, wo nero biyebe kange wuro tuni mani nuware, nachuro nyo kom cwibo bibwiyer bifumero kom mati dike tuka kume mane. ");
INSERT INTO bsj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nob dukkomen wuni tuka kume nebo dotange chin twalangum nob dukommeb wuro baurangu ki kabawuro ki liayre kom yilam nob kange ceb kange nubo twalang chiye. ");
INSERT INTO bsj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kom nob mulang kako, kom yuwou bolange wo nob bi bwiyeror bouchike di kom mabo nangen chiko. ");
INSERT INTO bsj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kambo bibei tomange nuwa nyori nar chero kayam kambo ken, di chin ku mum chiyero ti chi ciyabo ki Istifanus. ");
INSERT INTO bsj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Di la Chi dim ki yuwa tangbek chin kung nuwe ce di kwama, chin duktang kwama mati chin taou kiriti timye kango catiyet wo kwama ce. ");
INSERT INTO bsj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanus toki to mitodi kwama wumom, fou bibwe nifirenen tim tiye foh kang ko chatiyer kwama ce. ");
INSERT INTO bsj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","La nob tareu chin kungi chin kwa diro kibi kwan, la chin kumo tuniciye chu ki keciye win chin kwencinenten. ");
INSERT INTO bsj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Chin chukom cinar lower choci mubang ce ki ter, na nung dike bwiye, la chin cikangum bellen cero durko chi yoti kabum bwe kange chi chuwoti ki Sawulu ");
INSERT INTO bsj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ki kwama mubang Istifanus cho yila chuwoti chi tokti teluwe me Kiriti yo bibwiyer miro. ");
INSERT INTO bsj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chon chungi chon kwa diro kibi kwan choki Tee me kwama tare bwirang kero dor cher kambbo toki nyeri la chin damdum. ");
INSERT INTO bsj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Bulus ciya kange buwero. Kikwamacho dotange chilendo kwenu dor nob kwama miro wursalima, di la nubo nebilenkertiyeu ciin yalam gwamm mor bitine Yahudiya kange samariya, cii dob ka nob tomangeb. ");
INSERT INTO bsj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nabarubbo kibilenke chin furum Stephen laciyi yim kang buwam dorcer. ");
INSERT INTO bsj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Di la Sawulu ma nob kwamabo nen diker kambo ken chiti doi luwe-luwe chi cikangum nabarobboti kange natubo, kumcitak furcina. ");
INSERT INTO bsj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Duwa nubo neken bilenke birombo yalamem, chinen ya chine ker kwamaro. ");
INSERT INTO bsj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus yaken firen Samariya toker Yesuroti. ");
INSERT INTO bsj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kambo nubo nuwa lacitoten dikero Filibus matiyeri, lachin yilaken ki ner chero gwam na nuwau dike chitoktiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Won kelkeliyo bwirko chiranyu bwinubo ducce no nuweceu chin ciwiyeti kidir nubowo kwamang be kange kilentinimbo fiya twaka. ");
INSERT INTO bsj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","La chin ma fuwor nerer ducce bitinecho. ");
INSERT INTO bsj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nii kange wi bitinecho choti ki Siman. wo kikabe chin nikuye latakri chima nubo Samariyamin diker nyimanti nawo chi cho dorceriti ki chin diro kange. ");
INSERT INTO bsj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kwrub Samariya nubo dur kange bibei nuwa choti cikinyi ki “Niwo cho bikwan duret kwamaro wocii choti ki dureu. ");
INSERT INTO bsj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chi nuwa choti wori kutangnyi machinen diker nyimankati ki kwomje- kwomjece. ");
INSERT INTO bsj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","La kambo chi ne bilenke kange ker waber Filibus ceri, wo chi mati ker liya kwama kiden Yesu kriti lachin yuchinen mwem kwamambo gwamce nabarub kange natub. ");
INSERT INTO bsj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Cho siman kibwicho ne bilenke kambo ciyu cinen mwem kwamamberi la chin mwerkang kange Filibus kambo chito cii ma diker nyimanka ti kange nanyendo dureri, la kwomchoti. ");
INSERT INTO bsj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","kambo nob tomangeb wursalima nuwa fulende samariyau yo kerkwamareri cii tuncinen Bitrus kange Yahaya. ");
INSERT INTO bsj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","kacilauweri, ciin kwobcinen dilo naci yo yuwatangbe kwamako. ");
INSERT INTO bsj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wori bwiri yuwatangbe kwamako yiraubo dorcher bwiri, chin yucinen ka mwem kwamambo kiden Tee kwama Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","La Bitrus kange Yahaya cin yo cinenten kanceu dorcer lachin yo yuwa tangbe kwama. ");
INSERT INTO bsj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kambo siman to cii yuwatangbe kwama koti kiyeka kange nob tomangeb dorcerdi lanne chi kyemer. ");
INSERT INTO bsj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Yici, ki “kom neye bikwandowo ken, lawo niwo miyo yo cinenti kanko dorcerei na yo yuwatangbe kwamako. ");
INSERT INTO bsj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Di la Bitrus yicho ki, nawori mweu a yanchang kange mwo. wori muti kwain mwan fiya yuwatangbe kwamake ki chuweka mwek. ");
INSERT INTO bsj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mu manki chuner fou dikero wuronen, wori mor nere mweu kebo dong-dong kwama nen. ");
INSERT INTO bsj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nyori ywelum bwirang ker mwero, di la kwob dilo kwama nen kangeri an dob mwen bwirang ker mwero muyo ner mwereu. ");
INSERT INTO bsj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wori min nyimom mumor kanka nerek tak ri, mor bwaka nerek. ");
INSERT INTO bsj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Siman ciya yiki “kwobka dilo kwama nen kermir, dike kange mor dikerwo mtokeu, a abwire kange mwo. ");
INSERT INTO bsj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kambo Bitrus kange cidim ne kaker kwamareri, chin yilaken wursalima, ciyakenti dor nurer di, cin wab ker kwamaro chinar lor Samariya ducce. ");
INSERT INTO bsj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","naweu bwe tomange kwama yi Filibus ker ki Kweri yaken chunyako bang nure yirau tob kange wursalima yaken Gaza (Nure wo ki no kwechane. ");
INSERT INTO bsj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kweri yaken nikange wo ciro Abaca, in Liyar dur Chunya kandu katu, liya Abaca. cho cima liyar kulen choro tiye gwamme Bou wursalima cama wabkerwi. ");
INSERT INTO bsj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yikenti yimyie diker yamercer kiye, bifumer Ishaya niker dukumer. ");
INSERT INTO bsj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yuwatangbe ko yi Filibus ki “yaten bidom kange kulend kwikarowo”. ");
INSERT INTO bsj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibus cwa yanfiyacho nuwa ci kiye bifumer Ishaya ne ker dukkumerti la ciki mum nyimom dike me kiyetiyeu?” ");
INSERT INTO bsj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Bahabashe yiki “amanye manyumantiye caro kange fwetang membori? ken Filibus adou mor diker kwika ceronen nayi kange cho. ");
INSERT INTO bsj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Won cho dikero Bahabashe kiyeti “Ciin yaken kicho mu kwame fiye biyeka bir-bir tak na be kwame kom nob cangkab, wombo nyi. ");
INSERT INTO bsj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dor yiber dorer cer ci macinen bolang kebo mor luma we ane kercero car kotiye? wor cii tum dukumece dorbitiner. ");
INSERT INTO bsj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","La Tee me filibus yiki, “min kennen yiye we niker dukumerowo tok kero wotiye? kidor cer kaka'a nikange kidumenka? ");
INSERT INTO bsj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filibus Teer kero dor bifumer Ishaya Lan ma cinen ker kwamaro. ");
INSERT INTO bsj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kambo ciyaken nureri, cin lam kong caji kange Tee wuro yiki “To, mwambo wofo, yebwi mani a yumen mwem kwamam botiye? ");
INSERT INTO bsj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibus yiki “No mun ne bilenke win mor nerer mweri, cin yumwen mwem kwamambo. Dila Bahabashe yiki minne bileke. ");
INSERT INTO bsj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","La Bahabashe yiki atim kidiker kwikaro. Lachin yuchinenmwembo. ");
INSERT INTO bsj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kambo chi cherum mwembo nenneri yuwatangbe kwamako dum Filibus Teeu totensobo tak, la yakenti naken bilang tumboti. ");
INSERT INTO bsj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Dila filibus cerkangeu Azotus. Tiyangem bitinecho token ker kwamamaroti bitine cho nen yacin lamciko kaisariya. ");
INSERT INTO bsj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Di la Shawulu yoti kantni tikanka kerek tayek kange twalangka nob bwangka Yesu chere ni wabe durkonen. ");
INSERT INTO bsj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Kentencho bifumer naci yaciko kuwabe kwamamu Dimaskus, wori no fiya ni nanure woceri Bwayile kange nawiye, naci bou kici wursalima naci bwamci. ");
INSERT INTO bsj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","kambo liyakentiyeri chin dadom kange Dimaskus dang jang, dang jang filango yirau di kwama kangtangumcho. ");
INSERT INTO bsj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","lachin yarken bitineri cin nuwa diro kange yichoti “Shawulu, Shawulu yebwi mu neye dotange tiye? ");
INSERT INTO bsj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawulu ciyi toki kii we mwo kwama?” kwama yicho “mo Yesu wuro mune dotange tiyeu.” ");
INSERT INTO bsj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Di la kweni doken mor cinar lorcho ciyam yinen dikerowa tamyo maneu. ");
INSERT INTO bsj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nubowo yakenti kange shawulu tirangum bir-bir cin lem diker tok kar, chi nuwa dirti, dila citobo nii wii. ");
INSERT INTO bsj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawulu kweni bitine kambo chi wom nuwe ceri, mani ci toh dikerti, lacin tacinen kango cinbouki cho mor cinar lor Dimaskus. ");
INSERT INTO bsj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","lam kume taar manici toti manici cati, manici noti. ");
INSERT INTO bsj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nii tomange kange wi Dimaskus dencero Hannaniya, dila kwama tok ker kange cho mor dukumer yicho ki “Hannaniya” ciki To, minwo kwama” ");
INSERT INTO bsj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kwama yicho, Kweni yaken cinarloro choti ki Mikakke, lo niwo choti ki Yahuza me ni bou Tarsus dencero Shawulu, ci kwob diloti. ");
INSERT INTO bsj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Chinto mo dukume nikange douti dendo Hannaniya wi douti dila kun kang yocinenti wori nuweceu na wumom. ");
INSERT INTO bsj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Di la Hannaniya ciya kwama min nuwa fulen nubowin ducce dor niwon kange dara bwiram nanye net cero cima nubo lomwennen wucakeu yim wursalima. ");
INSERT INTO bsj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Liya wabe durko necho nyal naci tam gwamm nubowo chodencerotiyeu.” ");
INSERT INTO bsj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dila kwama yicho ya cho cin kulen nangenner minr min chokum cho choke wo awaden miroti nubo nenneu kange liyabtinib kange Israila. ");
INSERT INTO bsj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wori man dancinen dotange ca nuwati ker denerer miu.” ");
INSERT INTO bsj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","la Hannaniya yaken doken luwecho. yocinenti kanko dor, yiki “kemi shawulu Yesu toki wo dandorcer munen nure kikwama mu boutiyeu, toh muye nati fiya toka fiyek nadimki yuwa tangbeko wucakeu. ");
INSERT INTO bsj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","dang jang dikero kange no wulom dikem nuwe shawulu, la fiyam toka fiyek kwene cin yucinen mwem kwamambo. ");
INSERT INTO bsj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","La chamcharito cho ci necho bikwam neret yi wari kange nob bwangkab wi Dimaskus kumeni kila. ");
INSERT INTO bsj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wi danjang neker Yesurti mor kuwabe yitki incho bibkwe kwama. ");
INSERT INTO bsj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","kwarub nubo nuwa cho tiyeu cin yimangti ciki “wo kebo niwo twalang nubo wursalimatiya choden do wotiyeu ba? ciboufota natamci cineken liya wabe durko.” ");
INSERT INTO bsj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Di la shawulu fiyam bikwan kambo ken ci bouti ki kwamka kange bolka tiber Yafudawar kange nubo yim Dimaskus ki nurewo ci dancimen Yesu incho Kristi. ");
INSERT INTO bsj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ki kumeni kila nawo chumeu, Yafudawa mwer kangi nacin twallum cho. ");
INSERT INTO bsj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Di la Nyomom dike mwertiyeu. Cii chirou choti nyilo kalek cinar lorocho nacin twallum cho. ");
INSERT INTO bsj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Di la ki cin kumeri nob bwankabo tuh cho mor bulene chin dokken cho tiyak. ");
INSERT INTO bsj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kambo chi bou wursalimari, shawulu cwinaci mwerkandor kange nob bwangkab. Di la kwarub ce ci cwachoti wori ci ciyabo chokeneu cin yilam nii bwangkaba. ");
INSERT INTO bsj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","La Barnabas tuh cho bouchiko nob tomangebo nen. yici kambo Shawulu wabkan kange kwama nureu. Di la kwama tok kero kange cho, shawulu ma tok ker Yesu nyang lang Dimaskus. ");
INSERT INTO bsj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wabkanci kwama dotacek kange cerkacek wursalima. In tok ker kwamar nyanglang mor den Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Chin ma kwobkanke kange Yafudawa Helenawa, dila cinti naci to chi twallumcho. ");
INSERT INTO bsj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kambo kebbebo nyimom nyeri, cho ci beken kicho Kaisariya. ci tunkencho Tarsus. ");
INSERT INTO bsj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lana nyime Ekilisiya gwam biten Yafudiya. Galili kange Samariya ci fiya luma kange muka lachi yi yim cimbo ti mor tai kwama, kange birim nerem Yuwatangbe kwamak, nob kwamabo kila chiko chob ten. ");
INSERT INTO bsj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Yilam kambo Bitrus buyelangum chunka bitinen kocho gwam, yilam nob bwanka kwamake yim biten Lydda. ");
INSERT INTO bsj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Cin fiya nii kange dendo Aeneas, wur bwiyo nom nowe, dim choro narub dor kwangnid. ");
INSERT INTO bsj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Birtus yicoki Aeneas, Yesu kiristi twamnen. kweni kun diker damer mwero. nawonyo kweninti. ");
INSERT INTO bsj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","La gwamm nubo biten Lydda kange biten sarona cinto niiwo, dila cin yilau fiye kwama wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naweu ni kwama kange wi yafe dendo tabita, dendo Kinug “Dorcas” Nawiye wo dimki mana nangen do ken cii bwini nubo manki dikereti. ");
INSERT INTO bsj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","In lam kwama wo ci daken twira la cin buyam, kambo ci Yuchinen mwembo ci yokencho luwe diyeu. ");
INSERT INTO bsj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Dila Lydda bidom kange yafa nob bwanka be nuwa Bitrus kinon firen cin twom nubo yob cinen. Cii kenchoti, “Tabre bwi bou nyinen”. ");
INSERT INTO bsj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bitrus kweni yaken kange ci, danjang ci bouri, cho ci yaken kicho luwe diye. La natub bunebo bouti ti bidom chiwiyeti, la chin tuh belendo kange kulendo Dorcas churcineneu ki kwama ciwariyeu. ");
INSERT INTO bsj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus cho kumai gwamm mor kuwe, chunken kwob dilo, dila yila chunya twarek, kii, “Tabita kwenuu”. ci wom nuweceu, cito Bitrus ri chin yiken. ");
INSERT INTO bsj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitrus tar kanceko kunnyu cho lana nyime chou bwanka kwamako kange natub bunebo, cin neci Tabita ki dume. ");
INSERT INTO bsj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dikerowo yilam nubo nyimom gwamm yafa, la nyori nubo ducce ne bilenke kwama nen. ");
INSERT INTO bsj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","La yilam Bitrus yi kumeni kila kange Yafa kange ni kange dendo saminu Majemi ");
INSERT INTO bsj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nii kange nowi biten Kaisariya dendo karnilious cin dur nob kwenebo cii choti ki Istifanus. ");
INSERT INTO bsj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Inni wabe, wo neken dorcero kange loceu bwanka kwamak; ne tikali kemerti ducce Yafudawa nen kwob dilo fiye kwama wiyeu, kir-kir. ");
INSERT INTO bsj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ki kang keneko taar na yimkakumbo ce cin bou cinen mor dukumer bwe tomange kwama bouti cinen dila bwetomange kwama toki ki, “Karnilious”. ");
INSERT INTO bsj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","karnilous cin cii bwetomange kwama ninten nuwe mortaye. inye ni luwe?” Bwe tomange kwama yicho ki “dilo mweu luma nere mweko nune nubo bwinibotiyeu, lam di kwama nan luma nerer diker kwama kabum kwama. ");
INSERT INTO bsj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Naweu, twom nubo aya biten Joppa ciya bou ki nii chuwoti Saminu woci choti ki Bitrus ceu. ");
INSERT INTO bsj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yim kange Saminu nitu tiye, wolocen kino kon chachi. ");
INSERT INTO bsj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","kambo nii to mange wo tok kero ceu yilanken di, Karnilious Chuwo yob mor bibei changa loceu, kange nii kwene win mor tangne cenen wuro bwanten kwama tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Karnilious yici dikero bweuwe gwamm la twomei Jappa. ");
INSERT INTO bsj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Celfinice ki kan keneko nukkune (Kikakuk) ci yakenti kambo cidadom kange cinar loreri Bitrus kwiken luweu diyeu naci kwob dilo. ");
INSERT INTO bsj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","La cin nuwa wura lacin cwiti diker cakarti, lakambo nubo macaritiyeu dila cin toh dukum. ");
INSERT INTO bsj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","La cin toh dikwama wumom dila kangum cembo yirauti, kange diker na lalango dur yirauti dor bitiner, ci chorumti chunga ceko nareuniu. ");
INSERT INTO bsj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Morece biciro fwelfwele nako narreu gwamm wi kange nubo kongti kongeu, dorbitiner kange bilibe tinim dii kwama. ");
INSERT INTO bsj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Di la diro tok ker kange cho Kweni Bitrus, biyeucho. ");
INSERT INTO bsj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Di la Bitrus yike, kebongo kwama wori, micambo dike wucakke wi kange dike yeinyeu”. ");
INSERT INTO bsj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Di la diro bou chinen yobeceutak, “dike kwama mamco wucakkeri chore muki yeikabo. ");
INSERT INTO bsj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Wuro bwiu kinti taar, dila ciin tum kwelen yaken dii kwama. ");
INSERT INTO bsj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kambo Bitrus mor kwomka ki danke dukumembo citoweri, dila nubo Karnilious twomou bou tiran gum nyilok locho, kambo ci mem nureri. ");
INSERT INTO bsj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dila cin ma attifolo cimen nii chuwoti ki Saminu Bitrus ceu yiraufoka. ");
INSERT INTO bsj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kambo Bitrus mor kwakakerek dor dukumer yuwa tangbe kwamako yicho ki “To, nubo yoh donenti. ");
INSERT INTO bsj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kwani yirau yaken kange cii mare bwi yambo nenkange ciyeu wori mo mi twom che”. ");
INSERT INTO bsj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bitrus yirau nubonen yice ki mo komdo tiya. yebwi kom bowe? ");
INSERT INTO bsj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ki dur nub kwenebo ceroti ki karnilious niken wo bwangten kwamatiyeu, nubo Yafuda nyumom cho choniwo bwe tomange kwama wucakkeyeu twomuu na mu bou loche, nuwa tomange munen. ");
INSERT INTO bsj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","La Bitrus chouci ciya dou mor naci yiken kange cho. celfiniceri yaken wari kange ci la kangem bo Yafa yoci nure. ");
INSERT INTO bsj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Celfiniceri cin doken kaisariya Karnilious ningtsng citi, chou kebcebo kange farub cebo bidomeu. ");
INSERT INTO bsj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","kambo Bitrus doweri karnilious takange nuwe kange cho chungi necho dur. ");
INSERT INTO bsj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Di la Bitrus kuncho yichoti kweni ti mo keneu niffir. ");
INSERT INTO bsj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ki kwama Bitrus tokkankerti kangeceu, doken mordi kwabti nubo ducce mwerum fiye win. ");
INSERT INTO bsj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yi ciki “Komki bwikom kom nyimom nii Yafuda mani mma naniyak kaka'a na ya kange nen, kaka'a bitine kange. Dila kwama yiye ki chokeni manki wucakke. ");
INSERT INTO bsj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wo dike bwi mabou nyimanka maniye, kikwama kacou Yereu. la yori minne yebwi kom twomi komkin bowe”. ");
INSERT INTO bsj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Karnilious yiki kumeni naar wo chumeu dong dong kwama wo, mi kwob diloti ki kwama Tee rou, (kang keno taareu) mor luwemi, mintori tinkani ki kulendo fuwor. ");
INSERT INTO bsj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yiki Karnilious kwama nuwam dilomweu tikali mweu nubonen i nkwa kwamanen ki mwo. ");
INSERT INTO bsj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","La nyori twomkange yafa, two min a chomwen nii kangewi dendo Saminu wo ci chotiki Bitrus. kiyi cho saminu ni chu tee tiyeu, yim kong caji. ");
INSERT INTO bsj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na weu cin twom cinen cha bou gwam ce na cin mwerkange wi kabom chem kwama na chi nuwa dikero gwam wo cha yici ki ciya maneu ki dencer Teluwe. ");
INSERT INTO bsj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","La Bitrus karcinen ki Biling ke miu nyimom kwama mani nuwo ki dimen. ");
INSERT INTO bsj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Lan nyori mor nubo gwamm niwo wab chotiyeu kange ni madiker yoryoreu kwama yochoti. ");
INSERT INTO bsj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","kom nyimom tomange cinen Israila ki kwamawo ci yici kero lumer fiye Yesu Kristi wiyeu woncho kwama wucakakeu. ");
INSERT INTO bsj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kom ki bwikom kom nyimom dikero birombo bwiuweu, wo bwiu mor Yafuda terti Galili kambo tomangeYukan munnyek kwama wo Yahaya maneu. ");
INSERT INTO bsj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nannyeng tinim Yesu nii Nazaret kambo kwama yomcho ki yuwa tangbe ceko wucakkeu. kange bikwan duret. Dila yoti kanwi ma nangen lumarti kange twaka nubeko gwamm brombo bwe kelkele bwomeu, wori kwama kange cho. ");
INSERT INTO bsj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nobu tom dikero camaneu gwamm biten Yafudawa kange mor wursalima wuro Yesu wo citwallume, kiyeika dor chilom bwatiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ni wuro kwama kungum cho kikume taare dila yilam nubo nyumom cho. ");
INSERT INTO bsj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kebo nubonen kwarub, dila nubowo kwama choci ki kaba-biki bwibo nubo ba cha bano wari kannge cho kambo kwama kuncho mor tuweu. ");
INSERT INTO bsj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yibo bi yi nubo ker kwamaro biyitenci wocho wuro kwama yo a ma dumeti kange bwar bolang tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nob dukum kerem gwamm dokker cero, wuyak, birom ne bilinke tiyeri nafiyam cherka mor deneche. ");
INSERT INTO bsj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kambo Bitrus tok keroti dor dikero biromberi, yuwa tanbge kwamako yirau dor kwarub nubo yirom wi nuwa ker kwama roti cinen. ");
INSERT INTO bsj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nubo wuro mor mwerkangka nob bangka kwamakeu, cin ciya ki mwati ka lareko, kwarub nubo bou kange Bitrus ceu nuwa nyimanka wori yuwa tangbe kwamako yirau dor nuber. ");
INSERT INTO bsj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Wori cin nuwa nubo biro tok keroti ki nyini kange chicaklang kwamati. Dila Bitrus ciya. ");
INSERT INTO bsj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Kange wi wuro aywam nubowoti yuka mwem kwama keu nabeu? ");
INSERT INTO bsj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lan toki a yucinen mwembo kiden Yesu Kristi Lacin kencho ayi wari kange ci na kumewo. ");
INSERT INTO bsj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nawo nob nangenbo kange kebcebo wo Yahudiya nuwa ki nobo kumtacele ciken cin yo ker kwamaro. ");
INSERT INTO bsj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","La Bitrus bo Ursalima, boro mor nobo mwatum bwi nabarube torang choti. ");
INSERT INTO bsj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Mo mwerkan dor kange nobo biye bo bwi nabarube, mon cha chari kange ci. ");
INSERT INTO bsj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bitrus teri fwetancinen keroti ki. ");
INSERT INTO bsj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","maki kwob dilo mor cinan lor yafa man to dukum bulen do yiraw nyona yilang ko dur wo ci cuku kwama culangko nare yirau kabum mim. ");
INSERT INTO bsj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Man nyo cimenti nuwe wi, take man bulange durcer, man to bi yuwaro nako nwar na dorbitinero ce, biyuwaro bwirko, kange buro kongti konge, kange bilibetinim bo dii kwama. ");
INSERT INTO bsj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Min nuwa diro yiyeti kwemi, Bitrus biyem wom. ");
INSERT INTO bsj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Miki kebo nyo teluwe dike kange mani wo kebo na wucake ce kange wo yai nye do nyi miye. ");
INSERT INTO bsj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Diro ciya firen dii kwama, ki dike kwama chuwo ki wucakke, chuwo moki kebo wucakke. ");
INSERT INTO bsj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","dike bwi Kiriti taar nimde tuh yilanken ciko kwama. ");
INSERT INTO bsj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Can nawo nobo, taar tirangum kabum luwem bo nyo more ceu, ci tom ci firen kaisariya fiye ma wuye. ");
INSERT INTO bsj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yuwa tangbe ko yiye nyo ya ware kange ci, nungka demene men. kebbebo wuro nukken ciya wari kange mo la nyo doken lo nii cuwo. ");
INSERT INTO bsj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yi nyo kambo cho to nii tomange kwama tim mor luwece, yiti ki twom nob taar Yafa, ya ciya cho Saminu wo cuwoti ki Bitrus. ");
INSERT INTO bsj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Chan yi kom tomange wo ka fiya fulokati mo kange lomwe. ");
INSERT INTO bsj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Man ter kiro kange ci, yuwa tangbeko yirau dor cer nawo yira bineneu ki kaba. ");
INSERT INTO bsj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","La man bulangi kange ker Teluwe, nawo cho toke, “Bilenke Yuwanna ma Yuu nub nen mwemti ki kume a ma kumen ki yuwa tangbe. ");
INSERT INTO bsj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tano kwama neci nyomka nawo ne beri, fiya bo ne bilenke fiye teluwe Yesu Almasihu, man we ma kobkanti kange kwama? ");
INSERT INTO bsj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ci nuwe dike wo ri lan bwayum diker tokkaker dila cin duktan kwama cike nobo kumtaceleu kwama neci yiloka ko ciya fiya dume tiye. ");
INSERT INTO bsj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Buro yila, ki ker dotange bwanten bwiko bwar Istifanus, cin kwiya ya lam finikiya, kuburus, kange kuranne, ci ba Antakiya, dila cin tok ker fulener, yesu Yahudawa nen ki kwaci. ");
INSERT INTO bsj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Di la kangem ciyembo nob bo kuburus kange kuranne, kurane, ci, bo Antakiya ci tok ker kange Helenawa, cin yi ci fulenker Teluwe Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Take bikwan Teluwe (Ubangiji) wari kange ci, nobo dutce ne bilenker, cin yilau Teluwe nen. ");
INSERT INTO bsj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Fulen ciyero lam tii nob kwama bo Ursalima so ci tung Barnabas nob kwamabo, cin merang nobo dutce. Wi Antakiya ci ter cho ka nob tomangebo kritta. ");
INSERT INTO bsj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Di cho lau con to luma kwama co ma fuwor neret, chon nece bikwan gwam, ciya tim mor Teluwe, ki nerciyero gwam. ");
INSERT INTO bsj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Wuri chon niken dim ki yuwa tangbe kange bilenke, nobo kila cin yokten Teluwe nen. ");
INSERT INTO bsj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas cu Tarsus na cho do Shawulu. ");
INSERT INTO bsj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Fiyacho, chola bou ki cho Antakiya. cho yi wi Antakiya choro win ci mwerkanti kange nob kwama bo, cin merang nobo dutce. Wi Antakiya ci ter cho ka nob tomangebo Krista. ");
INSERT INTO bsj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mor Kumeni rowo kangem nob nuwa ka dukume, bo Antakiya. ");
INSERT INTO bsj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Win more ciye dencero Agabus Kwini titiye tok ker ki bi kwan yuwa tange ki, an ma tik ka kanga kambo ken dor bitinero nin gwam. Wuro biwi kal Kalaudiya. ");
INSERT INTO bsj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","La nob tomagebo tuki kor neret, wo ni ki ma nyi bi kwane ce, cin tun kebciyebo nin feren yahudiya ki tikali. ");
INSERT INTO bsj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Cin mani nyo, cin tung nobo durko nin ki kyemer, do kan Barnabas kange Shawulu. ");
INSERT INTO bsj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ki kwama wo Hiridus dok kangem nob bwankabo nin kan na co nuwa cinen. ");
INSERT INTO bsj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Chon twallum Yakubu kange Yuwana ki kulen. ");
INSERT INTO bsj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bwiko cho to nyo, lom yahudawa nin con ta Bitrus. ");
INSERT INTO bsj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bwiko cho ta bitrus di chon kum cho Furcuna, chon yoti nobo tee kwentiyeu na a to co ti chon wii ner boka ki cho dukume yabka. ");
INSERT INTO bsj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","La Bitrus kumkume furcuna, kange num kebcebo bwang ten kwamatiye kwob dilo ti kwama nen dor cer. ");
INSERT INTO bsj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","nyo na fini Hiridus a chok cho fiye, mor kume wo, Bitrus dadumti tiber nobo te kwentiye yob, bwambwambe ki gwelmar yab, nob te kwentiyeu tirangum nyilo furcuna. ");
INSERT INTO bsj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nyomka man di la ka nob tomange kwama wucakke cerkangu cinen filan ko tiba kuwe cho, ke Bitrus cungakin kuncho tak ki, Kweni wulom' di la gwelmaro kan ceke cherum. ");
INSERT INTO bsj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ni tomange kwama wucakke yi cho ki, cakkangum kulen mwero dum tameu, Bitrus mani nyo yeyum yilam mweko, bwan men ten. ");
INSERT INTO bsj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bitrus bwanten nii tomange wucakke, cin cerken kale, nyom bo dike nii tomange wucakke matiye, bilenke, ce ki ke dukum. ");
INSERT INTO bsj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Di la cin cum nobo to yiloko wine kange yobe, cin lam yiloko ci ma kyemere, wo to cinanloro tiye; wum cinen ki bwici, cin cerum, ci bwangten nure, wi dangjang nii tomange wucakke dobomcho. ");
INSERT INTO bsj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bitrus yilau mor bwiyece, yiki bilenke man nyom naweu teluwe, tungu nii tomange ce wucakke bo na cok ye kan Hiridus kange dike yahudawa kwatiye. ");
INSERT INTO bsj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cho nyomom yori, cho bou la Maryamu wo bou Yahaya, den Teecero Markus wobo bwanten Yesu tiye mwerkange wi dutce ci kwob dilo ti. ");
INSERT INTO bsj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Di chon kwa yiloko luweko la bubiya mor luwe chou bo na wom yiloko. ");
INSERT INTO bsj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Chon nuwa dir Bitrus bubiya ka timi bilangtum dolbo womka, yila cwa chu kuh na cho ne ci fulen Bitrus tim nyilo. ");
INSERT INTO bsj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Cin cho ki mo twelum twele, bubiya cinti, ki nyo. cike nii tomange ce wucakke ka. ");
INSERT INTO bsj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bitrus titen kwaka yiloko la cin wom nyilokori, ci ton cho la dike nyomankar tamci. ");
INSERT INTO bsj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bitrus nung ciki kang maci nenti ki ciya kumom. cho ci yi ci fulendo kambo teluwe cokce furcuna. coki kom yi Yakub kange kebbcebbo gwam. dike bwiye. cho dob ciye, chu fiye kange. ");
INSERT INTO bsj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Fini celi, kebo be kwalkanka kweni tiber nobo tekwentiye di bwi kange Bitrus. ");
INSERT INTO bsj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bwiko Hiridus do cho fiya cho bo la chon me nobo totiye chon neci nyaldo a twallum ci, la cho yirau yahudiya yaken kaisariya, yi yim cem wi. ");
INSERT INTO bsj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Naweu Hiridus mam funer kange nobo Taya kange Sidon, cin chu fiye cho wiye wari, cinken Bilatus, ni tikali liya, a tikanci, dila cindo ywelka, wori ciki fiya carito bitine ce. ");
INSERT INTO bsj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","bi diye wo ci yomom Hiridus cakkangum ki kulen liyare take yiken dor kuttile liyare, chon ma yiranci ker. ");
INSERT INTO bsj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nobo kwa kiyange, ki wo dir kwamar, kebo na nifiroce. ");
INSERT INTO bsj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wi dangcang nii tomange kwama wucakke kwa cho, wuri co ne bo kwama duktangka wi dangcang na yuwe cam co chon bwiyam. ");
INSERT INTO bsj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ker kwamaro, ti kuyai yoktenti. ");
INSERT INTO bsj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bwiko Barnabas kange Shawulu dim nagen ciyero Ursalima, ci yilauti, ci bo wari, kan Yahaya, woro din te cero markus (Barnabas kange Shawulu) cin yilaken Ursalima. ");
INSERT INTO bsj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","mor nob bwanka kwamanko Antakiya nob nuwaka dukumebo wi, kange nob merangka. ci bi Barnabas, Saminu woro ci (chuti ki Baki) kange lukiya Bakurane kange manayin woro ci (yo ci wari kange Liya Hiridus ni ca liyare) kange Shawulu. ");
INSERT INTO bsj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Di la ci wab kwamati ki yim bo ngak-ngak kange dulomwe, di yuwa tangbeko ki kom cok men Barnabas kange Shawulu dor nangen do ma cu ciye. ");
INSERT INTO bsj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Merka kwob dilo kange ngak-ngak kange dulomwe la ci yo cimenti kanko dur, ci yoci. ");
INSERT INTO bsj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Shawulu kange Barnabas cin bwanten dir yuwa tangbeko wucakke cincu culukiya, wuri cin yabken diyele kuburus. ");
INSERT INTO bsj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Fiya ci cinanlor salomi cin merang ker kwamaro mor kur bi waber Yahudawa, ci wari kange Yahaya Markus ni tikanci tiye. ");
INSERT INTO bsj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bwiko cho chi kentangum diyele gwam, yaken Bafusa, foh ci fiya kange bayahudiya dencero Bar Yesu. nima fulentiye take nii nuwaka dukume cwerke. ");
INSERT INTO bsj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ni fulene wo ci cuwo ti ki Makaddas, cho carju Bulus nii wo ki yilen ne. wuro cuwo co Bulus kange Barnabas co cwiti na cho nuwa ker kwama. ");
INSERT INTO bsj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Di la elima ne fulen (Fwetanka dene ce) kwabkangi kange ci cwiti na co fwem makadda cin bilenke nen. ");
INSERT INTO bsj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","la Shawulu wo ci cho ti ki Bulus dimki yuwa tangbeko wucakke la yo cimen ten nuwe. ");
INSERT INTO bsj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","La chon yiki mo bi bwe bwekelkele mo dimki bibolero kange cil. mo nii kiye dike ken. mani mwa dob werkanka nor Teluwe kwama tim cere tiya? naweu. ");
INSERT INTO bsj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","kang teluwe kwama wo dor mwer, naweu yilam fukma. mani mo to kakuk ti can can do wo. Wi danjang ka bikumta kume kange kumtacele cumom cho chon ter bwelankako do nobo a ti cimen kang ko tiye. ");
INSERT INTO bsj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bwiko Makaddaci to dike bwiri neken bilenke wurico ma nyomanka ki merangka ker kwama. ");
INSERT INTO bsj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bulus kange farce cin tok kangi cin yabken bafuca yaken firjiya kange Bamfiliya mor nabire mwenge. ");
INSERT INTO bsj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bulus kange farubcebo cin chu Firjiya kange Antakiya biten Bidiya fou ci do bikur wabe diye Asabaici cin yiken. ");
INSERT INTO bsj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bwiko kiyeranka werfunero kange nob nuwa ka dukume, nobo du bi kur wabero tun tomange, ki kebyebo na kon wiki tomange na neka bikwan ce di kom toki. ");
INSERT INTO bsj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bulus la kweni nunge ki kang, nobo Israila kange kom ki ne kwama durtiye kom nuwa. ");
INSERT INTO bsj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kwama Israila, chok tenkwanub bebbo, la cin bwi firen Masar, la ki bi kwancer na duktankako ce, ci cokuciye. ");
INSERT INTO bsj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bii ner kange ci kutantum curem kwini naar, ");
INSERT INTO bsj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kambo cho twallum bitine niber wi biten Kan ana. ni tenkwanub bebo kwali. ");
INSERT INTO bsj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dike wo gwam bwi curo kwini kwob na'ar tuddo kwini nung wo cume, kambo wuro kwama neci nob bolangeb, nimde nii dukume Samaila bou. ");
INSERT INTO bsj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nobo keni a ne ci liya, kwama ne ci Shawulu bibwe Kish, ni naniyak Benjamin yilam liya curo kwini na'ar. ");
INSERT INTO bsj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kwma kwmco dor kutile liyare nen, kum dauda yilam liya ciye. Dor Dauda kwama yiki man fiya Dauda bibwe Yesu niwo ner miro cwitiye an ma dike ma cwitiye gwam. ");
INSERT INTO bsj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Fou mor naniya ni wo kwama ceru ki nii fuloka Yesu, na wo co ma noro can mane. ");
INSERT INTO bsj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Wuro bwi nimde Yesu bou yahaya tok ker Yukwamwem kwamambo na yilokako ce wo nobo Israila. ");
INSERT INTO bsj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","WoroYahaya dim nagen cerori co tok ki we kom kwatiye? make bo cho. ");
INSERT INTO bsj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kebmibo bibei mor naniya Ibrahim, kange wo wab kwama ti more kume, ki bo ci tungu fulen folokako. ");
INSERT INTO bsj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ki ker nobo yirangum Ursalima kange nobo tanki ciye, ci nyom cho bou cin dim tok ka nob to dukumtiye wo ci kiyeranti kakuk Asabaici fiye twalka ceko. ");
INSERT INTO bsj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","bwen no dwalleu ci fiya dike bwi wo lam na bware ce dor cer cinken Bilatus a twallum cho. ");
INSERT INTO bsj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kambo ci dim kwarub dike ci mulange dor cere, la cin cukum cho dor bwatiye ci yoken cho mor tuwe. ");
INSERT INTO bsj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Di kwama kum co mor bwiyare. ");
INSERT INTO bsj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nobo bou wari kange ce feren galili kange Ursalima la cin ta to co ti kume kila. Nobo wuro ci warke ce nobonin nawo. ");
INSERT INTO bsj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nyon bou kumen ki fulen wo lamlome, ker norowo ci ma tenkwanubebo neneu. ");
INSERT INTO bsj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Teluwe dobbinen noro. Nyo chon kum Yesu mor tuwe, nawo mor bifumereu Zabura na yobe cemo bi bwemi dwen ma yilam Tee mwe. ");
INSERT INTO bsj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tak dike bwici kun cho tuwe co wo kari, bwi ceu fuyem tok ker nyo, man ne kom bibwiyer dauda wo wucaake bichom. ");
INSERT INTO bsj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Wo cho dike bwi co tok ker mor kange Zabura mani mwa dob nii wucakke mweti fuyem. ");
INSERT INTO bsj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","kambo Dauda ma kwama ni wabe mor nire ce dike kwama cwitikye, ca bwiyam, cin furumco wari kange tenkwanubcebo, con fuyem. ");
INSERT INTO bsj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Di la nii wo kwama kunge to bo fuyeka. ");
INSERT INTO bsj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kebmebo kom yomom fiye niwo wiyeu ci makumen fulen kere cutangka bwirang ke. ");
INSERT INTO bsj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Fiye co wiye gwam nii neken bilenke an fulom mor dike werfener Musa ko mani cokkom ti dor cereu. ");
INSERT INTO bsj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Na wo nyori kom yila ki cini kange dike nob nuwaka dukumeko toke kari bwi dor kumer. ");
INSERT INTO bsj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kom nob cwikanka, kan lentanginker nyomankar take kan dim. wori mama nagen ti morkumeni kume, nangen do maka ciyati bwen ci yi komdi. ");
INSERT INTO bsj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bulus kange Barnabas certiri nobo kenci ciya tok ten kerowo bidiye Asabaici wo botiye. ");
INSERT INTO bsj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kambo wabe dime, Yahudawa kila kange wuro do bwanka Yahudawa co ci ne danne, ciya ma nangen luma kwama. ");
INSERT INTO bsj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Asabaici yilakangu cunnukuru bwirum na ci nuwa ker kwamaro. ");
INSERT INTO bsj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Di la yahudawa to mwer ka nobe ko, la cin dinki kor ci wengngum dike Bulus toke take cin ko. ");
INSERT INTO bsj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Dila Bulus kange Barnabas cin tok ker ki bi kwan manki gtai, ciki tamyo a ter yika kume ko ker kwamaro, Dauda kom tungume, kom nungi kom datenbo dume wo diriye na wo Nyori, nyan yilaken nobo kunmtacele nen. ");
INSERT INTO bsj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nyo Teluwe dok nyo ki, man yo kom filang wiye nobo kuntacele wiye, na kom boki fulonka cwika dorbitinero nen. ");
INSERT INTO bsj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nobo kumtacele nuwa nyori la cin ma bilantum, cin wab ker kwamaro gwam wuro ci ne fiyaka dume diri yiloten. ");
INSERT INTO bsj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ker Teluwe wabi wi yare tinin bo cuwo. ");
INSERT INTO bsj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Dila Yahudawa cuk natubo kange ma wabe, nobo ken, kange nobo durtinim nabarubb wi cinanlore. ");
INSERT INTO bsj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Dila Bulus kange Barnabas fercinen ti kwero naci ke wi. cin cu cinanlor koniya. ");
INSERT INTO bsj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nob bwankabo cin dim ki fuwor neret kange yuwa tangbe. ");
INSERT INTO bsj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ki kwama wo Bulus kange Barnabas doken bikur wabe yahudawa ri cin tok kero kambo numbo duce wo yahudawa kange Helinawa ne bilenke. ");
INSERT INTO bsj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","La yahudawa buro nebo dureu cuuk nubo wo kumceleu ri dukci cin man funer kange keb cebo. ");
INSERT INTO bsj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","La cin yi wi kumeni kila, ci tok ker cero ti kibi kwan neret wori bikwan kwamaro wi kange la cin ne yirome dor luma cero. Cin ma wuro ki yirome diker nyimang katini wo a mati kang Bulus kange Barnabas. ");
INSERT INTO bsj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Di la nubo cinan loreu kitangum kangen bo bwangten yahudawa kangumbo bwnagten nob tomangebo. ");
INSERT INTO bsj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kambo nubo kunta cileu kange Yahudawa (wari kange dubo durtiniceu) cuwa naci neci dotange la naci mubang ci ki ter. ");
INSERT INTO bsj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Dila kambo ci nyumom nyeri, ciin cuwa cin cu cinanlor Likoniya, Listira kange Derbe, kange biten tini kentangum ciyeu. ");
INSERT INTO bsj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Fiye cii yoti kang tok ker kwamako nine. ");
INSERT INTO bsj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","wi Listira, nii kange yim, manki bi kwan nace ko nin wori cin kilen cikko nee ce bou ceu ci yabo yam wi. ");
INSERT INTO bsj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nii wo nuwam Bulus tok ker ti, Bbulus dok ti nuwece wi morece. Bulus fwel cenen ten nu la ci tori ciin bilenke naci fiya luma. ");
INSERT INTO bsj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","La cin yi cho ki diro dur, kwenti dor na mwek.” La cho mwabiri ter yambo ");
INSERT INTO bsj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kambo nubo mwerum duceuto dikero Bulus maneri, cin kung diro kiny Likoniya ciki, “Bweltimbo bou na noob lacin bow binen”. ");
INSERT INTO bsj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ci cuo Barnabas ki “Zafsa” la bulus Hamisa wori co nii ci tok ker tii duceu. ");
INSERT INTO bsj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Liya wabe Zafsa wo bikur wabeer cero kino bwinko cinan loreu bou ti nenne kange funtini cibwati na latereu nyilo, co, kange nubo mwenim neu cui naci twi ciilen dikero ficange. ");
INSERT INTO bsj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Di la kambo nob tomangebo nuwa nyeri, ciinm worum kwilen cero, ri cin cerum mor mwerkanga nube ko nen wulom, ci kwa diroti. ");
INSERT INTO bsj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ki “nubo ye bwi kom ma dikeroburo tiye? nyin nob ken, ki bwiyo dong-dong kange kumeu. Nyiki yi kom kero ken ri nako yilau bwanka dikeertinimbo bwirko buro ri nakom bwang ten kwama wo ki dumeu. ");
INSERT INTO bsj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wo ywel dii kwama, dor bitiner wima kange dikero more ce gwam. ");
INSERT INTO bsj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Gwam kange wuro ci dob bo dor cero warka mani, ki co min mani yora ki mwem bo cine kom dii kwamau kange melako ki bi bwereu cin dim neer kumero ki cari kange bilangtum. ");
INSERT INTO bsj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","La ki kero wo duwal Bulus kange Barnabas fiye bwei nyimde ci tim ki ci twika cinenek nuwanko ficange. ");
INSERT INTO bsj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Di la Yahudawa kangembo Antakiya kange Ikoniya bou la cin kwom neer nubero. ciin nubang Bulus ki ter ri la ciin kwob co ciin yaken kicho bwiko cinarlor, cii kwatiri cin bwiyam. ");
INSERT INTO bsj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Duwal kambo nob bwangka ko tirangum cunga ceke ri cin kwanum la cin doken cinan lor cel finiri cin chu darba kange Barnabas. ");
INSERT INTO bsj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kambo tokka fullen kerero cinan loro curo kange fiya ka nob bwangka ceko ducceri, cin yilaken Listira, kange Ikoniya kange Antakiya. ");
INSERT INTO bsj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ciin ti neka neer nob bwangkako bikwan ti naci ya yam mor bilenke, ki “Tam ban doken mor liyar kwama ki dotange duce. ");
INSERT INTO bsj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kambo ci cikang nubo a bwangtenti kici mor ku wabe gwammeri, la cin kwobcinen dilo ki ngak-ngak ciin neken cii kang kwama, wo cii ne bilelnke cineneu. ");
INSERT INTO bsj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","La cin cuken mor Bicidiya ci lam Bamfiliya. ");
INSERT INTO bsj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kambo ci tokker cero Biriya, cin yira ken Italiya. ");
INSERT INTO bsj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ci dob fiye co tiri, ciin yabken Antakiya mor mwege, fiye wo cii duk cii kang luma kwamak ki nangen do wo cii dim naweu. ");
INSERT INTO bsj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ki kwamawo ci lam Antakiya ri cin mweer nubo ku wabe wariyeu, ciin yici dikero gwam wo kwama mani ki ciyeu, kange kambo ci wumom nure bilenke nubo kumtacileu ni neu. ");
INSERT INTO bsj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Cin yi wi kwitange kange nob bwangkabo. ");
INSERT INTO bsj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","nubo kangembo yirau yahudiya cin bou Antakiya ri, ciin merang kebcebo nen, ki “Tano kom biye bo laro nawo werfun Musa ro tokkeri, mani ko fiya cerkati.” ");
INSERT INTO bsj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Wo dok Bulus kange Barnabas mor kobkangka kane ci. la cin cok Bulus kange Barnabas kange kangembo mre ce na cin ya Ursalima, cin wabkangi kange nobtomange bo, kange nubo durtinimbo dor meke wo. ");
INSERT INTO bsj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","La nubo ku wabeu tom ci, cin cu mor finikiya kange Samariya la ciin yi cii yioka nubeko kumtacileu. ciin bou ki fuwor nerero dur fiye kebcebo wiye. ");
INSERT INTO bsj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ki kwama wo ci bou mor Ursalima, nubo bi kurwabereu yoci kange nob tomangeebo, kange nubo durtinimbo, la cin yici dikero gwam wo kwama mani ki ci yeu. ");
INSERT INTO bsj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Di la nubo kangembo wone bilenke, wo ki more nob ding lingebeu, kweni tiri ciki, “Tamnyo a biye cinan lor, rina neci nyal ri naci bwangten werfuner Musa ro”. ");
INSERT INTO bsj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","La nob bwangkabo kange nubo durko mweri wari naci to dike wor. ");
INSERT INTO bsj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bwiko kwob kanka ko duce ri, Bitrus kweni tii ri, la yi ciki “Kem bibo, kom nyimom ki kwama duce cumeu, kwama ck ni more kume, la nyimi nubo kumtacileu a nuwa fulen kerer certiye, naci ne bilenke. ");
INSERT INTO bsj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","kwama wo nyimom mor nereu, la yici ki yuwa tangbe co wucakke ci nee cii na wo ci ne beu. ");
INSERT INTO bsj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ci tu bobo ki dimen kange ci la cin nirom ner cero ki belinke. ");
INSERT INTO bsj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","La nyori, ye bwi ko cuwa kwama, la kom yo nob bwanka bonen ten tu tum ti, wo tebbeb kaka'a bo dolbo tu kake? ");
INSERT INTO bsj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Dila bin ne bilenke ban fiya fuloka ki luma nere kwama na ci ken. ");
INSERT INTO bsj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nubo gwam tam cinge kambo ci nuwa Barnabas ti kange Bulus yici yirom boti kange diker nyimankako wo kwama mani tiber nubo kumtancileu kange ceke. ");
INSERT INTO bsj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","kambo diim tokka kere kori, Yakubu ciya ki “Kebmibo, ko nuwa ye. ");
INSERT INTO bsj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon tok kambo kwama ki kaba ki lumanek tiikam nubo wo yim kumtacileu ri naci to dorcero nin nob more ce. ");
INSERT INTO bsj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ke tinim nob tomangeb dukumero ciya kange wo, nawo mulangum meu. ");
INSERT INTO bsj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bwiko dikero wo man yilau, ri man mutilo Dauda wi tak, wo yuram bitineu, man yila muti tiyak cekowi, nabi tiken ki cho. ");
INSERT INTO bsj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","La nubo kumeu atin do kwama kange nubo kumta cileu gwam wo cico tiki dem mire. ");
INSERT INTO bsj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","wo cho dike kwama tokkeu, wo ma dikero buro nyumom nanduweu. ");
INSERT INTO bsj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nyori, mi tori bi nere nubo kumta cileu wo yilam kwama nineu dotange. ");
INSERT INTO bsj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Dila kange cinen tam nyo ciya dubom fulendo kange buro tumbo, kange wo ka biciro bwiyam bwiya. ");
INSERT INTO bsj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Wori ci tok ker ti mor werfun Musa mor cinan lor gwam ki kaltiro nanduweu la ciki kiyei mor bikur waber diye fobka gwam. ");
INSERT INTO bsj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","La yor nob tomnagebonen kange nubo durko kange nubo bikur wabe ro nen gwammeu na ci chok Yahuza cwoti ki Barsabbas kange cila buro no nubo dor kebcebeu. la cin tom Antakiya kange Bulus Barnabas. ");
INSERT INTO bsj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","cin mulangi ki kangcek fiye nob tomangebo, kange nubo durko, keb kumebo, ki kebnyebo wo no kumtacileu mor Antakiya, Siriya, Ciliciya, Yarume. ");
INSERT INTO bsj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","wori nyim nuwa kangem nubo ceri fou nyinen, kebo ki yomka nyek, la cin kwomcang kom ki keti ro kange kumen nereu. ");
INSERT INTO bsj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nyitori yori kabo nyo wo nyane dume ne wine nanyi cok nubo kangem ri nanyi tomci kumen kange nubo nyi cui cuiyeu Barnabas kange Bulus. ");
INSERT INTO bsj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nubo wo neken dume ceu ki Teluwer bek Yesu Kiriti. ");
INSERT INTO bsj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","La nyin tom yakubu kange Silas wo, ayikom dike coti win ken ki mor kere ce. ");
INSERT INTO bsj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wori yori kabo yuwa tangbe kwamakonen kang nyo ri, nyi yo kumen deben do dur wo la dikero wo tam a bwang tenneu. ");
INSERT INTO bsj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Di kom dubom dike cii neken bibwiteu, noka bwiyale, woka biciro bwiyam bwiyau, kange buroka. No kom dubom dikero buro ri, kan yi kwamer. ");
INSERT INTO bsj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","La ciin kambo ci yalammeri, yirau antakiya, kambo ci mweru nubo duce wariyeri, ciin neken cii mulangkako. ");
INSERT INTO bsj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ki bwikob kiyekako ri, ciin bilangi ki bikwan nere ro. ");
INSERT INTO bsj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yahuza kange wo nob tomangeb dukumek takeu ne nubo bi kwan neret ki keti duce, ri la cin fiya bi kwan. ");
INSERT INTO bsj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","kambo ci darang kume tini wiyeri, ciin yoken cii ki fuwor neret nubo co nen, na ci yilaken nubo tomou ciye nen. ");
INSERT INTO bsj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Dila cila tori yori kabo ci tim wi. ");
INSERT INTO bsj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Dila Bulus kange Barnabas tim Antakiya (kang tangum kebcebo duce) ci ki merang cinen ti ri, ci tok ker kwamaro ti. ");
INSERT INTO bsj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kambo kume tini ri Bulus yi Barnabas ki' na weu “bi yila nabi yarum kebbebo mor Cinanloro gwam wo ni tok ker kwamareu, nabi to keno ci mati nyi ri”. ");
INSERT INTO bsj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas cui naci tu Yahaya cii cuo ti ki Markus ce kange ci. ");
INSERT INTO bsj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Dila Bulus kwabi ri, ki yorbo cia tu Markus, wo dubom cii mor Bamfiliya ri yabo kab tak kange ci nagen do nineu. ");
INSERT INTO bsj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","La kwob kangkako dou tiber cer, la bou ki yal kanka bwitici, Barnabas tu Markus kane co la yab mwmbo ciin yaken kuburus. ");
INSERT INTO bsj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Dila Bulus cok cica can ciin cu, bwiko dulo ko kebcebo kwocinen, neken cii kang luma kwama. ");
INSERT INTO bsj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","La cin yaken mor Syria kange Cilicia, ci nee nubo bikur wabere bikwan neret ti. ");
INSERT INTO bsj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus tak bou Darbe kange listira, la nii bwankako kange co ti ki Timoti wiwi, bibwe nawiye Yahuda wo nii bilenke, dila Tee ce Baheline. ");
INSERT INTO bsj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Cii tok dikero kenti dorcer nyi nubo wo Listira kange Ikoniya. ");
INSERT INTO bsj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus cui naci ya yam kange co, la cin to cho, cin biye cinen laro ker yahudawa wo fiye tini curo nineu. wori gwamce nyimom ki tece nii heline. ");
INSERT INTO bsj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kambo ci cukenti mor cinanlore, ciin nerang nyal tinimbo nob tomangebo wo kange. nubo dur tinimbo wo mor Ursalima ciya cike ri, naci bwangten. ");
INSERT INTO bsj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","La nubo bikur wabereu fiya bikwan neret mor bilenke la ciin kila cii cobten ti diye ki diye. ");
INSERT INTO bsj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus kange nubo tikan co tiyeu ya mor cungko Phrygia kange Galatiaya, wori yuwa tangbe kwamako ywanmci tokka ker cero cunga ko Asia. ");
INSERT INTO bsj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ki kwama wo cii bow bidom kange Misiyari, cii cuwa na ci do mor Bitiniya, dila yuwa tangbe Yesu ywamci. ");
INSERT INTO bsj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kambo ci dou Mysia ri, ciin yirau mor cinanlor Troas. ");
INSERT INTO bsj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bulus ma dukumbo ki kume; nii Makidoniya tiim wi, kinong coti ki, “Bou fou Makidoniya na mwi tikang nyo”. ");
INSERT INTO bsj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kambo Bulus to dumeri, dangjang do naci yaken Makidoniya, cin kwabi nercer ki kwama cuo nyo nyi tok ker cero Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kambo ci dob mor Troas ri, nyin yaken ciyer nyin yaken Samothrace, la cel fini ceri nyin bow Neapolis. ");
INSERT INTO bsj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","La nyi kwen wiri nyin cuo Philippi, wo co cinan lor Makidoniya, cinan lor la tangnumbo mor biten Roma; La nyin cerum wi cinan lor nen kume ni kila. ");
INSERT INTO bsj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ki diye fobka Yahudawa ri nyin cer ken nyilo cinan lor kong chaci ki kwa nere ki nysn fiya fiye kwobka dilo wi. La nyin yiken ri, nyon tok ker. kange natubo wo mwerum wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nawiye kange dendo ki Lidiya, wo wiye kwilen tiyeu, ci ceru cinan lor Tiyatira, wo wab kwamatiyeu, cuwa tu nuwa nyo. La Teluwe wumom neer cero cin cuwa tu ki dike Bulus tok tiyeu nen. ");
INSERT INTO bsj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kambo co kange nubo loceri, cin kenyo ciki, no kom ciya komki min yilam ki bilenke kwama nin di kom bou ko cerum lomi. “La cin dok nyo nyin ciya. ");
INSERT INTO bsj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nyori, ki kwamawo nyin yaken ti fiye kwob ka diloke, bibuya canga kange woki ninga tokake wab kang nyo. Ci bou teluwe ce nen ti ki kyemer ducce ki to kako ci totiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","La bubiya wo bwnag ten Bulus ti kange nyo la ci kwabang dir, ti ki “Nubo buro cangab kwama dureb. ciki yi kom nure fuloka”. ");
INSERT INTO bsj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ciki mai nyo ki kume tini kila. Dila kambo Bulus kangum neer cero kayam meri, yi kangi la yico “mi nyal nenti ki den Yesu Kiristi, ceru cinen”. La ciin cerum ki kwama co. ");
INSERT INTO bsj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kambo teb teluweb cebo tori yoka neerek fiya ka mweb kemerceu cuwe ri, ciin tam Bulus kange cila kwob kanci yaken ki cii fiye tubo miyem diker tiye kabum nob bolangeb. ");
INSERT INTO bsj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","kambo ci bou ki ci ka bum nob bolangebri, cii ki “Nubo buro kum cnag cinan lor beroti. ciin yahudawa. ");
INSERT INTO bsj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Cii merang nure ti wo kebo dong-dong kange dike nubo Roma ciye ciya cuko naci bwang tenneu. ");
INSERT INTO bsj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","La mwerkan nubo ko gwam kwinang Bulus ce kange Silas, nob bolangebo wob rangum kwilen cero cii nen ri ne nyallo naci makanci ki Belyange kwamangi nyeu. ");
INSERT INTO bsj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kambo malli ciyeri? Ciin dokken cii mor Furcina, ri ciin yi nii to furcina tiyeu na kii ca kum cii yorak. ");
INSERT INTO bsj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","kambo ci yo nyallo weri, nii to ka Furcinako dokken cii kuwe more ri cin kum na tini ceko. ");
INSERT INTO bsj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kina ciinkume Bulus kange Silas, kwob dilo rila cii ka nuwe wabka kwama tii la tangnum nubo furcinau cuwa tuu nuwa ciiti. ");
INSERT INTO bsj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dang jangri ka mikanka dor bitiner wo dok kwar kur furcinau mikangume la danjang nyilok tininmbo gwam womangum kang nubo bwambwabeu kwiya. ");
INSERT INTO bsj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nii to furcinatiyeu yuram dumbo ri, cin to nyiloko wumom, la cin co ku kulen cero ri, cin cui naci twallum dor cero, wori cin kwabi ki nubo furcinau cirangum. ");
INSERT INTO bsj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","La Bulus kwa cinen dir kibi kwan ki, “Nuware dor mwe ro nen twirak, wori nyin wi fou gwam nye. ");
INSERT INTO bsj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nii to furcina tiyeu me naci bo cinen ki kirak, la cin doken mor wulom mor taiye, ciin cungi kabum Bulus kange Silas. ");
INSERT INTO bsj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","La ciin coku ci kaleri, ciki “Nubo dur miik nye ma mati nami fiya fuloka? ");
INSERT INTO bsj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ciin yico ki “Neken bilenke teluwe Yesu nen, namwi fiya fuloka mo kang nubo lomeu gwam. ");
INSERT INTO bsj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ciin yico ker Teluwero, kange nubo loceu gwam. ");
INSERT INTO bsj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","La nii yo furcina tiyeu tu ci ki kume cuo, la cin nirom dercero, ri co loce gwam cin yum mwem kwamam bo dang jang. ");
INSERT INTO bsj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","la kambo ci bou ti Bulus kange Silas loco ri, ci tik cinen carito kaciye, cin bilangi ducce kange nubo mor luwe ceu, wori cin ne bilenke kwama nen. ");
INSERT INTO bsj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","La kambo fini celumeri, nob bolangebo tom nobo to cinanlor tiye nen ker, ciki “Dob nubo co a yaken ti”. ");
INSERT INTO bsj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","nii to furcinan tiyeu yi Bulus kero couki “Nob bolangebo tunguo tomange minen na dob kom ko yakenti. na weu dila kom ceru ri nako yakenti ki luma. ");
INSERT INTO bsj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Dila Bulus kane silas ciya cinen ki “Cii malli nyo nyanglang bolang mani, ri nyi nubo Roma keneu- la ciin mer ken nyo mor furcina. La ciki cui wona weu naci yoken ki yurangka ka? mani nyo! Ciya bou ki bwici naci cok nyo kale”. ");
INSERT INTO bsj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","La nii to kakkawo ya yi nob bolangebo kereburo. Kambo ci nuwa ki Bulus kange Silas nubo Roam ri cin cuwam tai. ");
INSERT INTO bsj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nob bolangebo bou la ciin ken ci rila cii cokangum kale, la cin yici ki ciya cerum mor cinan loro nen. ");
INSERT INTO bsj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","La Bulus kange Silas cerangum furcina ri cin bou to Lidiya. Kambo Bulus kange Silas to nuberi, ciin neci bikwan neret, cin dubom cinan loro. ");
INSERT INTO bsj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kambo cin cum biten Amfibolis kange Aboloniya, cin lam biten Tasaloniya ka, fiye lo kwama yahudawa wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulus, kambo cilerumeu yakenti cinen tokanti kange ci kume nukune kiriti taar, mor bifumer tinim. ");
INSERT INTO bsj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bulus wumom bifumero yici ki, “Atam nyo Kiristi anuwa dotange, an kunum mor tuwe yici ki “inco Yesu miyikom ti inco kiristi. ");
INSERT INTO bsj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kangum Yahudawa ciya cin bwangten Bulus kange Silas, kange Helinawa, Kange nubo kumtacile neken dor cereu duce kange natubo dur tinim kebo bi duwar. ");
INSERT INTO bsj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","yahudawa biro nebo bilenke cin dim ki kurom, cin tokangum nob kutumebo fiye mi yeka kange tenka, cin kum kutumeu mor cinan lor, nubo ducce bwang ten citi. yacin ter kiyando lo Yesu nen, cin cokum Bulus kange Silas kabum nubem. ");
INSERT INTO bsj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Dila citobo Bulus kange Silas cin kwob kangum Yason kange nob bwanka kwamam ko kange yaken kici kabum nob bolonageb mor bitinenceu, ciyiti ki, Birombo nubo kunene nubertiye, wo cin bou binen. ");
INSERT INTO bsj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nubo wuro Yason yociyeu cin fuwam werfun Kaisar, ciyiti liyakange wi dendo Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kambo nubo kange nob bolnagebo nuwa nyeri, lan kwomci. ");
INSERT INTO bsj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","kambo ciyo kenero Yason nir kange tangne nubori, lacin nyamkan cinen. ");
INSERT INTO bsj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mor kumewo nob kwamabo cokum Bulus kang. Silas, cin twomci biten Biriya. kambo ci lameri, cin doken mor lo kwama yahuda. ");
INSERT INTO bsj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nubo Biriya kidimen kange nubo Tasuliska, cin ciya kange ker Bulus cero kinero win. Cifuwa bifumer kwamaro ti kumeni kumeni, wori na cin yimon ker Bulus. Yora. keno bilenkeri. ");
INSERT INTO bsj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Naweu la nubo ducce morece cin ne bilenke wari, kange natub helinawa wo, cin yimom kange nabarubo ducce. ");
INSERT INTO bsj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kambo yahudawa wo tasaloniyawa cinuwa ki Bulus tok ker kwamaroti Biriya cin yaken wi firen, cin kun ner nubero. ");
INSERT INTO bsj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Dang jang nob kwamabo Biriya to Bulus twam ken caji cin dubo silas kange Timoti bwiri. ");
INSERT INTO bsj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Birombo wo yati ki Bulus tuu co kutan biten Antina. kambo ci dob Bulus wiyeri, cin yo tomange, cinen wo Silas ce kange Timoti na cin bou cinen wolum no nure wiri. ");
INSERT INTO bsj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","kambo Bulus ningtan boka Silas koti kange Timoti Atina kangum ner mor nerece, kambo cito bitineco dimki bibwiti tinim. ");
INSERT INTO bsj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Cin fuwanangi kange yahudawa lo kwama kange nubo wab kwamamtiyeu, kange birombo citiye kirkireu, fiye miyake kange tenka. ");
INSERT INTO bsj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dila kange Abikuriyawam nob nyomkab wabkang kange co. Kangumbo yiki “Nyewo niwo tokker nyeu ki tok kiye?” kangembo yiki “Cin cerkan ni kange wo co nubo ti na bwang ten fulendo fwereu,” Wori ci tok ker Yeesu roti kange kwenka ceko tuweu. ");
INSERT INTO bsj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Cin Bulus cin yaken ciko diko Arassa, ciyitiki, mwo nyin yo merangka ko wo mwe fwerko woka? ");
INSERT INTO bsj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kertinimbo mutikan tiyeu, fiye nyinen. Nyi cwiti na nyimom dike kerowo dan tiyeu”. ");
INSERT INTO bsj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Antimiyawa) kange fabubo more ceu, cine dor ciro kang tikangka dikero fwirtinim kange tangnim cem. ");
INSERT INTO bsj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bulus tiken tiber dii Arasa yiki, “Kom nubo Aniniyawa min nyimom kom nob bikwaneb fuleneb. ");
INSERT INTO bsj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Min ynimom kambo kom ki wabre kwama kimeu min bwelangtiyeu, dila minto tang lando kange dikero mulangum wi dorce tokktiki, “Kwama wo wuro cin nyombeu.” Miki tok dike kom wabti mor bwininyomkau. ");
INSERT INTO bsj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","kwama ywel dor bitinero kange dike moreceu, kambi cin co kwamam diyeu kange bitineu, mani yi lo kwama wuro nubo mu ki kang cikeu. ");
INSERT INTO bsj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mani do tikaliti kange wo labou a neco tiyeu, kange fubom kange dikero wuyak. ");
INSERT INTO bsj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nii win nin ci fwel nubo dor bitinere gwam, naci yi dor bitiner, co ci nung kume ciya mati dor bitinere kange yika tini fiye ciya yim tiye. ");
INSERT INTO bsj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Naci do kwama, tano ciya do cori, naci fiya co. Bwenno ci kutangbo beneneu. ");
INSERT INTO bsj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Biyim morece binuwa luma bekti, kambo kange mi nyomka more kume toke. “Bo bibyo loce. ");
INSERT INTO bsj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nno bi bei kwama ri, datenbo bi mwer kang kwama kange mwin kaka no kokaa banatini, kange tini wo ci ywirangeu. ");
INSERT INTO bsj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dila nyori, kwama turingum kumeni bwini nyom ka, dila cin tokker nubokwarub adubom bwinraka kereko. ");
INSERT INTO bsj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kuniwi wo ciyo ca ma dorbitinenereu win bolang tiyeu mor bilenke, ki niiwo ci cokeu. Kwama dang nii co ki kunka ceko tuwe. ");
INSERT INTO bsj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","kambo nubo Atina nuwa ker kwenka tuweri, kangem bo buo Bulus kangem bo ki. “Nyan nuwa tenen tak, dor kerero wonen. ");
INSERT INTO bsj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Lanyori Bulus dubomci. ");
INSERT INTO bsj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dila nabarubo kangum bo morece ciya ki ker kwamaro, cin ne bilenke, mworum kange diyoni Siyus in ni durlor. Dii Arasa kange nawiye kange deudo damaris kangum bo wari, kange ci. ");
INSERT INTO bsj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bwiko dike buro ko gwam di Bulus dubom Antakiya yaken Koranti. ");
INSERT INTO bsj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","La wi ca wab kan kange bayafude kange dendo Akila, bwe bitine Buntus bou ti bowe Italiya kange wice Balkisu. wori kalaudiya tok kero ki nyial Yafudawa a dubom Romawu. Bulus ya cinen. ");
INSERT INTO bsj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","la wori nangen ciro win con yi kange ci co managen. wori cin nob yuwel ka teneb. ");
INSERT INTO bsj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","La nyo Bulus ti yai ku wabe kakuk fobka co cuiti na co fiya ciya Yahudawa kange Elenawa. ");
INSERT INTO bsj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","kambo Silas kang Timoti lam Makidoniya ri, Bulus neken dorcero kero min, warker Yafudawa nen Yesu co Kristi. ");
INSERT INTO bsj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","La kambo Yafudawa kunang cinenten, ci to coti Bulus chokum belle ceu kaci la yii cia bwiyale kumeu a yila dor kumer. Man cerum nawo kange kab maki yan nob kumta cilenen. ");
INSERT INTO bsj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","La chon dobum ci con cu lo Titus, Justus nii wo wab kwamam tiye. Loceu bidom kange ku wabeu. ");
INSERT INTO bsj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ki pu nii dur wuu wabero ne bilenker Teluwe nen, kange nubo loceu, la korangtiyawa dorcereu ne bilenker la cin yuu cinen mwem kwamambo. ");
INSERT INTO bsj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kwma yii Bulus ki kume mor dukume cuwa re tai, tokkero kendo. ");
INSERT INTO bsj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","La min wi kange mo, kange nii mani a nuwa mwen twirak tiye wori min wi ki nob ducce fou mor cinan loro wo. ");
INSERT INTO bsj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bulus da wi na coro win kange cuiyakko nukkun, merang ker kwamamroti more ciye. ");
INSERT INTO bsj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","kambo Galiyo yilam nii tamki Akaya, Yafudawa kwenang Bulus nin ten wo llam ci yaken ki co kabum bolangeu. ");
INSERT INTO bsj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Niwo bolum nubo ti na wab kwama, kidimen kange werfun do. ");
INSERT INTO bsj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","La kambo Bulus ki naco tok keredi, Galiyo toki, yi Yafudawa kom “Yafudawa na ki kero bwirko ca maneu na dur di mitin warkero. ");
INSERT INTO bsj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","la buro kan me ke dor kered kange denti kange wer fun kumer, ko tokkan wo bwitikom. Ma cuibo yila nii bolange dor ketitowo. ");
INSERT INTO bsj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galiyo dok ci a kwenum fiye boulange nen. ");
INSERT INTO bsj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","la nyeu ci ta sactanicu inya bi kur wabero ci buk co kabum kutile buolange. La galiyo karbo diker ci maneu. ");
INSERT INTO bsj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus kambo yiwi kumeni kila nyeu lan dubom kebcebo yaken Suriya. Mor nabire mwenge kange Balkisu kange Akila la na co dob fiye nabire mwenge tum nob ti cankuriyari, con cerum yiri doreceu. wori con tuu nor Banazare. ");
INSERT INTO bsj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kambo ci bou Aficari, Bulus dubom Balkisu kange Akila wi, la ceu bwicui con yaken mor bi kur waber Yafudawar con fuwakangi wari. ");
INSERT INTO bsj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","La cin me Bulus na yim kange ci kumtinidi, la ciyabo. ");
INSERT INTO bsj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ta nure ce dob ci lam yi ci man yila ten kumen na kwama ciyari. La con doken nabire mwenge wi Afisa. ");
INSERT INTO bsj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kambo Bulus Yiram kai cariyari, la con kwi con yarum ku wabeu wursalima la con yira ken Antakiya. ");
INSERT INTO bsj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bwiko co yim wi kumeni kilamri, Bulus taa nure ce yaken cinan loro Galatiyawa kange Firjiya la ne bi bei tomangeu bikwan nerer. ");
INSERT INTO bsj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","La wi kange bayafude dendo Afolos wo ci bou ce Iskandariya bou Afica, chon nii nyomka ker kwamar. ");
INSERT INTO bsj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Afolos Cin ne merangka wo teluwe ceu. Nii bikwan yuwa tangbek. coki tok dong dong dikero dor Yesu reu. la chon nyomom ka yuu ka mwenge yuwanak. ");
INSERT INTO bsj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Afolos ter tok ka kere ki kibi kwan mor bikur waber. La kambo Balkisu, kange Akila nuwa ceri, cin cou cho chunga la cin fwetang cinen nure kwama kambo ken. ");
INSERT INTO bsj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","La kambo cho cwui na cho cuken Akaya la kebcebo ne bo bi kwan neerer, la ci mu lang bibei tomange wo Akaya na ci yoco, kambo ca yiram meri, con Tikan nubo buro ne bilenker ki luma ducce. ");
INSERT INTO bsj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Afolos Yafudawa diker nyumanka kange bikwan do cho cikeu nungi kero nin la Yesu co Kristi ");
INSERT INTO bsj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Afolos firen koranti, Bulus kentangum bitine diyele con bo cinanr lor Afisa. fou tak co fiya kangem nob bwanka. ");
INSERT INTO bsj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Bulus yici kom yo yuwa tangbe ka fiya kom ni bilenke cin ciya, o-ong nyo nuwambo fulen yuwa tangbeko wucakke wi. ");
INSERT INTO bsj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulus la ki yuka mwenge ko wini kom mane, ciki yuka mwenge Yahaya. ");
INSERT INTO bsj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus ciya ki yahaya ma nubo nen yuka mwenge yiloka, yiki kom ne bilenke wo a boti bwiti bwiko cek, Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nubo nuwa nyori, co ci yu cinen mwembo ki den teluwe Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Di la Bulus yoti kanko dor cer dila yuwa tangbeko wucakke, yirau dor cer, cin tok ker kange nyitin kange to ka dukume. ");
INSERT INTO bsj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Cin dim bi kate kwob shilombo yob. ");
INSERT INTO bsj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus doken kor bi waber co merangti ki bi kwan bwiyer na cuka taar ce. bwantenti ci mor fowaka keret, co fwetang nubonenti ciya ne bilenke, dor dike tabi na liyar kwamaro ce. ");
INSERT INTO bsj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Dila kangem yahudawa bongum, cin ko bwankako, di cin yoten kanka nure Almasiya kabum mwerka nobek. Nyori Bulus kwab cinen wari kange nubo ne bilenke, yoten merangkako mor merangka Tyrannus. ");
INSERT INTO bsj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nyo co matiye dim curo yob, yaken biten Asia nuwan ker kwamaro, yahudawa kange Helinawa. ");
INSERT INTO bsj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kwama ma nangen do dur kan Bulus. ");
INSERT INTO bsj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Wo nubo nuwa bo luma fiya luma twirak ciyeko dim. yowako bwiko ciru nubo nen, ninga, kange kelkelito, yuwako bwirko ci cerangum bwi nobe. La cin yo lalang kwabka bwi Bulus ce. ");
INSERT INTO bsj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yahudawa kangem nub bowab wi cin dob fiye co neneu, cin tu dor cero nin na cin ma nange ki den Yesu, ciki nyo dokkom mor den Yesu wo Bulus ma biwerer cerotiye, kom cerum”. ");
INSERT INTO bsj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nubo ma dike wo ci bi neber, bibeyo lo nii wabe durko kange bweyude dendo Sceva wii kibi bei niber wo ma dikero wo tieyu. ");
INSERT INTO bsj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yuwako bwirko kari ki ma nyomom Yesu, ma nyomom bulus la kumeu, bi we? ");
INSERT INTO bsj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","La yuwako bwirko bwirko mor nii kwenancinenten lam ci cok, ci cer wi ku we cuwo kwancer ki deti. ");
INSERT INTO bsj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wuro yilam dike nyomom nyome fiye nubo wiye gwam, Yahudawa kange Helenawa nubo yim Afisa. Cin nuwa tai kambo ken, den teluwwe Yesu fiya duktangka. ");
INSERT INTO bsj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nob bwankabo dutce tak, ci bo ci kiye nangendo bwirko ci mane. ");
INSERT INTO bsj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nob buwabo cin bo ki bifumer ciyero cin twirangum kabum nobem wo ci kiye dike a tatiye, Lam bikate kwini nung na mwindo ce. ");
INSERT INTO bsj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","La ker kwamaro yalati kibi kwan nure dutce. ");
INSERT INTO bsj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kambo Bulus dim nangen cero na bibweret kwamaroce Afisa, yuwa tanbgeko bwanten ki co nure Makidoniya kange Akiya dor nuret, cin yaken Ursalima, co ki, Bwiko ma ferenne, tamyo ya Roma. ");
INSERT INTO bsj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bulus twom bibei tomange ce yob, Timoti, kange Erastus, firen Makidoniya, nobuwo tikan ceu. ");
INSERT INTO bsj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Di la co ki bwici con nintanci firen Asiya nyobi dob. Dila kobkankako dur kweni afisa ker dor nure do wo. ");
INSERT INTO bsj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Knage nii kwabi dendo Dimatrayus wuro Tuu fulen bwiner tiye wo Diyana ce, wo nangendo bo nob kwabi to nin ti fiya ka kambo ken. ");
INSERT INTO bsj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","La cin mwer nub kwabiyo yici ki, kom nyomom ki kwabiyo wo bo fiya kiyemer doka ti dutce. ");
INSERT INTO bsj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kom to, kom nuwa ki kebo ka afisa, dila gwam biten asiya Bulus wo bolom nubo dutce. Yiti ki “Fulen da kange mani ci yweltiki kange”. ");
INSERT INTO bsj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kebo kwabi beto a fiyakomkati ki kwace, dila bikur fulen bero Diyana durku a yilam manki nangen. Nyon ca lem dur cero. Co kange biten Asiya gwam, Kange dorbitiner wabko tiye. ");
INSERT INTO bsj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Di cin nuwa nyori, ci mam funer kambo ken, cin co bi cor ki diro kwamer “Nii dur co Diyana wo Afisa”. ");
INSERT INTO bsj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Cinan loro gwam dim ka bwali, nubo tibranbo yaka fiye mwerka. Fiya cuwo cin tam far yame ce Bulus, Gayus, kange Aristarchus, borombo bou Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus mani naco do mor nobe, di nob bwanka cebo yuwanco. ");
INSERT INTO bsj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nyo farub Bulus cebo kangembo wo nubo durtinim yare Asiya cin tom cinen ki kemi kwam kwame ca dore tare. ");
INSERT INTO bsj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kange nob cuk kange dikerti, kangem ken cuk kange dikerti, wori nobe kweri nero kayam. Dutce more ce nyombo ye bwi ci mwere. ");
INSERT INTO bsj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kangem mor nubo yi Iskandari wo Yahudawa cin tung ti kabbeu, dila Iskandari cerou kung kang ceko ki ciya kumom, cwiti na ci yi nubo mwerom meu ker. ");
INSERT INTO bsj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Di la kambo ci nyomom co Bayahude di gwam ciye cin kun kiyange na kang keneko yobece ci tok ti ki, “Dur ki no fiye Artimas wo Afisa.” ");
INSERT INTO bsj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Di nii mulankako cinanloro cwo nou dor nobere, la co ki, kom nubo Afisa, we nyombo ki Afisa tiberowo fulen (Allaliri) nii dur kange fulen do yaru firen dii kwama? ");
INSERT INTO bsj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Di la ci kanang bo dike weu, daten kom kumom, kom mare kange diker kutti kutti. ");
INSERT INTO bsj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kom bo ki nubo wuro fou ku bolange, kebo dur cin nob kob, na mor bi kur wabe, kaka nob dilakab fiye kwama be wiye. ");
INSERT INTO bsj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tano Damatriyas kange nob kwabito wari kange ciye nan wiki kange ker dor kange ku bolange wi wumom wume, nob bolange bo wiranagi, ci a ya ki kiyange bwitici. ");
INSERT INTO bsj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tano kero kange wi na toka ko ceri an do tiber ciro fou mwerka beko, bo yiti dok-doke. ");
INSERT INTO bsj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bilenke boki no mor bitore kange kwalkanke wo bwi duweneu. bo manki dike ba torti dor dike wo bwiye, co tok nyori co, ci yo nobe. ");
INSERT INTO bsj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kambo ca nuwa nyori la con dob nubo yalkange. ");
INSERT INTO bsj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","kambo kwalkake dimeri Bulus twomi a cou bibei tomange, la con neci bikwan nerer. La con ne ci nacume can dubom ci coki, Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","kambo co ya bitene ceri, con yi nob bwanka bo ker bikwaner, La con biyeken biten Helenawa. ");
INSERT INTO bsj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kambo ca mam cuikko taar wiyeri, yafudawa ma cinen biciren kambo co dadom ca kwina bire mwenge tiye na co yaken Suriya. la con fulogum neer cero yila ken Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nubo yuo cho Asiau, mwerkange Sabatarus, bibwe Buru, Biriya gayus, bibwe Derbi, Timoti kange Antakus, kange Sakundu, gwam ciye nob bwankab Tasalonika, Kange Tikikus, kange Trophimus wo Asia. ");
INSERT INTO bsj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","La nubo buro cuken ten nyinen la ci nintang nyo Taruwasa. ");
INSERT INTO bsj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kambo na do nabire mwenge Filippi bwiko kumerek carito man ki cam fuwam meu. La cin yii wi kume niber. ");
INSERT INTO bsj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kume kaba kumeni kiyang cari teri, Bulus yi nob bwanka bo ker, co cuiti na kubo celfini, la con kwob kercero cuwemje lam cin kume. ");
INSERT INTO bsj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kirako wi kila kuwe diyewo nyo mwerkangum wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","La cerangeu bwe kange yimwi dendo Eutychus, wuro yarken dumbo tu'u cou, kambo Bulus tok keroti cuwemi bwe bwayile wo dam dumeu, yuram, bitine con bwiyam. ");
INSERT INTO bsj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","La Bulus yirau ri toki ki, kange nii akwomde dor cer, dume wi bwiyabo. ");
INSERT INTO bsj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","lacon kwiken luwediyeu tak, cinkabkanghum ci cam.' ");
INSERT INTO bsj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","chin bou ki bweu ki dume lachin fiya birom nere kebo bi duwar. ");
INSERT INTO bsj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","la nyo yakenten Bulus nin kina bire munghe nyon doken Assos, nyon cwi na nyo tum Bulus kina bire. wonco dike cocwi maka, con cwi naco yakina. ");
INSERT INTO bsj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","kambo ci fiya nyo Assos ri nyon tumco mor nabire mwenghe nyin yaken metelina. ");
INSERT INTO bsj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bwiko kwenka nyeko firen celfini ce nyo bou diyele kiyo celfini tak nyon bou cinanloro militu. ");
INSERT INTO bsj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","La Bulus tuken cuu kako Afisa mor na bire mwenghe. kati yilo co tengum dorcer Asiya, wori co kayamti. na mam di bi dii kakuk fenticon na fiya co wursalima. ");
INSERT INTO bsj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Wi militu con tom nabarub ya afisa na cou cinen nubo durko ku wabe. ");
INSERT INTO bsj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kambo ci bou cinenri, con yi ci ki “Kom ki bwikom kom nyumom, Tabti ki diye kaba ma dokum na'a Asiyau, kambo ma twal kumeti kange komeu. ");
INSERT INTO bsj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Min bwang teluwe ninenten ki lomjume nee kange mwem, mor boulange wo fiya yero ki biciren, Yafudawa bou. ");
INSERT INTO bsj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kom nyumom ma nuwa bou tuu ka nan yikom dike a ma kumen tiye, min bwang kumenten luwe ma merang kumen dikero ti yanglang. ");
INSERT INTO bsj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kom nyumom kambo ma werang Yafudawa ti kange Helenawa dor yiloka kwama, kange biten ker fiye teluwe Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","La na weu miki yang wursalima yuwa tangbe kwamako mung men ti nyang lang tam in ya, ma nyombo dike a fiyayeti fireneu. ");
INSERT INTO bsj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","La Yuwa tangbeko nung menti cinan loro gwam bwanka kange dotange nintang ye ti. ");
INSERT INTO bsj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","La ma tubo dumemi wiki kange nangen minen, nan dim cuak ko knage nangen do ma yo fiye teluwe Yesu, na tokka fulen ker luma. ");
INSERT INTO bsj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Na weu kom to, min nyumom kom gwam, bouro ma yiciker liyar kwamareu, mani ka toyeti tak. ");
INSERT INTO bsj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","la min yimkom ki diye no, miman ki bwiyale ni dur mir. ");
INSERT INTO bsj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Wori ma nuwa tutum nan yikom kange dike kwama cuiti kumeneu. ");
INSERT INTO bsj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Na cori ko ta dor kumero kange nob bwangkabo wo yuwa tangbe kwama yokom nubo dur cereu. beko cobi, ko to kuu wabe kwamau, wo ca ten ki bwiyale ceu. ");
INSERT INTO bsj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","man nyumom bwiko ma kubomtiyeu, Bifumeru me kangem an dou (Nob yulaneb) more kume mani cia dob kwama ten do ti. ");
INSERT INTO bsj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Man nyumom bwen no more kumeri kangum nob an kweri an toker kerti to bwirangi nyeu na kom bibei tomange bwiyocik. ");
INSERT INTO bsj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Na ceu ko yi yim cobkam, ko kwabi ki coro taar man dobbo yika kumek kererk. kange mwem kume kange kakuk. ");
INSERT INTO bsj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Na wonyeu ma dob komti kange kwama kange ker luma cero, wo bi kwan mu ka kumekeu, lana ne ten kom kwali wari kange nuboburo wi mor kwama cokum gwammeu. ");
INSERT INTO bsj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ma dillanbo nuwe ki kanan mwin kange kulen. ");
INSERT INTO bsj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mo ki bwimo mom nyumom kanko wo ki ma diker min cuiti mani kange nubo wo kange meu. ");
INSERT INTO bsj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dikero gwam min yikom dikero ka ma tikaliti cikeu, kange dike ka mam nangen do ti cikeu, na kom kwa ki ner kerero wo Teluwe Yesu kibwki cho tokeu, wi ki fiyaka dutce. ");
INSERT INTO bsj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","kambo ca dim tokakeri, chon chungi dor nurer chin kwob dilo ti. ");
INSERT INTO bsj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nub ciwiye wi kila, cin ne Bulus kwendowe kange cwika cek. ");
INSERT INTO bsj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","La cin kangum ner ki dikero wo cha tikeu, ki mani ciya tou choti tak. La chin yo cho mor na bire. ");
INSERT INTO bsj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","kambo nya yalkang kange ciyeri nyon doken mor nabire mwenge nyon ta nure cinanlor koceu. Celfini la nyon lam Rodusa, wi la nyon yaken cinan loro Batara. ");
INSERT INTO bsj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kambo nyo fiya nabire mwenge yab ken ti Phoenicia, la nyon doken. ");
INSERT INTO bsj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kambo nyon tou kibru tiyeu, nyon dubom kan ko mokenyeu, nyon mer dor Suriya, nyo yira cinan lorp Taya, wori nabire mwenge a cer kulen cero wi. ");
INSERT INTO bsj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kambo nyo fiya bibei tomange, la nyo yiwi kume niber, la bibei tomange yii Bulus, ki yuwa tangbe yare wursalima. ");
INSERT INTO bsj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bwiko kumetinen nyon yoten kang yam nyon bo min. gwam ciye kange natub ci bo kange bibeiyo lociyeu cin yo nyo bwim cinan lor. Co la nya cung cungi kong caji nyo kwob dilo. ");
INSERT INTO bsj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nya ne kang na cungme kange ci. La nyon doken nabire mwenge, ci kange natub cibo cin yilaken lo. ");
INSERT INTO bsj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kambo nyo dim yim nyembo taya di nyon lam talamaya. La wi, nyo yar kan kange kebnyebo nya da kume win kange ci. ");
INSERT INTO bsj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Celfini nyon kweni nyon cuu kaisariya. nyo donken lo Philip be nine fulen ker tiye, win mor nobe nibereu, nyon yii kange co. ");
INSERT INTO bsj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","La nii wo wiki bibeyo na'ar, bibutob wo tok ker dukumer tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kambo nyo yii wi kumeni biduwareri, kange nii dukume bou mor Yahudawa den cero Agabus. ");
INSERT INTO bsj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bou nyi nen tuu dak Bulus ko, la bwam nace kange kange ceko, la co toki, yuwa tangbe kwamako toki, nyo Yahudawa a bwa nii dakkewo tiye, la ci an neken cho kang nob kumtacile. ");
INSERT INTO bsj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kambo nya nuwa dikero buro di, nyo kange nubo yim wiyeu ken Bulus a yare wursalima. ");
INSERT INTO bsj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","La Bulus yici, ye kom matiye, ko ci wuyeti kom kimen bikwan nertiye? La min ciya kebo ka bwaka, la nan bwiyam wursalima, ki den “Teluwe” Yesu. ");
INSERT INTO bsj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kambo Bulus mani a ciyatiyeri, nyon dubom ci ka wiyeko, la nyon toki, dike Teluwe cuitiye a ma nyo. ");
INSERT INTO bsj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kambo kumeni wo nyon tu cuayelyeu, nyon kwiker wursalima. ");
INSERT INTO bsj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kangem bibei tomange kaisariya cin bou kange nii ci choti ki Mnason, nii kubru, ni yuloka kabo, wuri nya yiiti kange ceu. ");
INSERT INTO bsj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kambo nya lam wursalima di, kebyebo nyo ki fuwor nerer. ");
INSERT INTO bsj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Celfini ceri, Bulus ya kange nyo fintano Bitrus wiyeu, nubo durco wi gwam. ");
INSERT INTO bsj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Kambo cha yarum ciyeri, la con yii ki winti dike kwama mani mor nubo yim kumtacileu, ki nangen cero. ");
INSERT INTO bsj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kambo ci nuwa di cin duktang kwama la cin yii co mon to yii be mbo bikaten kilam wo ne bilenker kange Yesu mor Yafudawa, na cin bwangten werfunero. ");
INSERT INTO bsj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","La cin yii dor mwer, mo merang yahudaa yim tiber nob kumtacileu ci cutang ker Musa ro wi, la mun yi ci abiyetende lar bibeyero, ci a bwangten de dambo carko. ");
INSERT INTO bsj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ye bama tiye? bicom ci an nuwa mon bou. ");
INSERT INTO bsj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Na cori ma dike nyo yi nentiyeu, nubo na'ar wi yinen wo tum nure. ");
INSERT INTO bsj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Yaken kange nubo buro na nirum dor mwero kange ci na ya cinen dike a ta'a tiyeu, na ci carum dor cero. La nubo gwam an nyimom kero ci tok ti dor mwerue cierke. Ci an nyumom mon nii mo bwangten werfuner tiye. ");
INSERT INTO bsj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Dor nubo kumtacileu buro ne bilenkereu, nyon mulang cinen, nyon yici kero ki nyial, cia cokum dor cero, ki kulen do ci wab fulen do wiyeu. kange bwiyale, kange dike kwamiye, kange burotum. ");
INSERT INTO bsj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","la Bulus tuu nubo, celfini con nirum dor cero kange ci, la cin yaken kuu wabe, na co yici dii ka kume nirka ciyeko. Co diye neka luma ko a ne ci tieyu. ");
INSERT INTO bsj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kambo kumeni niber kiyan dimeu, Yhudawa buro Asiya to Bulus ku wabe, la cin bol nubo mwerkangum meu na tamco. ");
INSERT INTO bsj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ci kwabang diroti nubo Israila ki tikang nyo won co nii wo merang nubo minti fiye gwammeu, dike ma kiyeti kange nubeu. werfuner, kange fiye wuro kebo kawo, la con bou ki Helenawa mor kuu wabe, la con yayamfiye cakcake wo. ");
INSERT INTO bsj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","wori cin to Bulus wi kange Tarifima kange Bulus mor cinan lor ci kwati ki neer kange con bou ciko mor kuu wabe. ");
INSERT INTO bsj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","La cinan loro a yilam ki dike, la nubo cwakang wari ya cin tam Bulus. cin kuuken co kuu wabe kale, la cin mangang yilokoti. ");
INSERT INTO bsj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kambo ci cuiti na ci twalum ceri, fulen kwi lam niin dur nob kwenebo yico wursalima nubo cua tai ki kwalkanka ke. ");
INSERT INTO bsj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","La Con tuu nenkwanebo kange nob bikwanebo cin cuu yiranken fiye nubo wiyeu. Kambo nubo to ni dur kwenebori, la cin dubom buka Bulus ce ko. ");
INSERT INTO bsj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","La nii dur nob kwenebo yan lam tau Bulus, ki kom bwanco ki dukako yob. la cin me co ye mwa mane. ");
INSERT INTO bsj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kangem mor nubo mwerumeu, tok keroti ki dimen. kambo nii durko kwenebo mani nyom bilenker tiyeri, la con toki ki a yaken ki Bulus fiye nangene. ");
INSERT INTO bsj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kambo ci lam kwikari nob kwenebo tum co ker kwalkikwalki. ");
INSERT INTO bsj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","La nubo ducce bwangten kwabang tiki dir a twalum co. ");
INSERT INTO bsj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kambo Bulus darom na lam fiye nangeneri con yi nii dur cero ki man fiya nure nan yii nen ker ka? nii dur ko me co, moki tokum ki Helenaciya ka? ");
INSERT INTO bsj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mwa kebo bwe masare wo kuma cum bwiye mo ter mwer kanka duwek nobek, mo tu nubo bikate na'ar mwa cuu ciko kiya? ");
INSERT INTO bsj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","La Bulus ki min BaIsraile cinan loro Tarsus mor Cilicia min bwe bitine cinan loro dur. Ciyamen nan tokker kange nubowo. ");
INSERT INTO bsj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kambo nii dur ko neco nure di, Bulus kenti dor fiye fuwa naa kung ken kang ceko dii wo nung ti cia kumangumeu, kambo fiye tam cineri, Bulus yi ci kero ki Ibraniyanci. ");
INSERT INTO bsj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Kebmibo kange tebmibo, kom nuwa kaka batiyo wo ma ka ti kumeneu. ");
INSERT INTO bsj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","La kambo nubo mwerume nuwa Bulus yici kero ki nyi Ibraniyanci ri, la cin tam cinen, con toki. ");
INSERT INTO bsj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Min Ba Ibraniya ci bo Tarcus wo cili kili, kiya, la ma ma kiye kako fou mor cinanloro wo naar Gamaniel. Min fiya mwerum kambo ken dor bwangka mor bifumer tebbebo. min wiki ker bwangka kwamak, nawo gwam kumen ko nyo duweneu. ");
INSERT INTO bsj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Min ne dotange ki nure wo yaken ciko bwar, bwaka kange tunka lokuka, nabarub kange natub. ");
INSERT INTO bsj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kambo wabe durko kange nubo durko a ne warketiye. Min yo mulang ka cinen dor kebbebo Dimascus, nan bwauci na bou ciko wursalima. ");
INSERT INTO bsj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","La ki cin kakuke can nawofilanko dur lo kwama yoten nefilang ti. ");
INSERT INTO bsj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","La man yarken bitine, la man nuwa diro yiye, Shawulu, Shawulu, ye bwi mwa neye dotangetiye? ");
INSERT INTO bsj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","La man kari, “we mo Teluwe? la con yiye, co Yesu nazaret, wo mo ne dotange tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nubo kange meu tom filanko, la ci nyombo dir nii woro yiye kereu. ");
INSERT INTO bsj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","la min meco ye ma matiye Teluwe/ teluwse yiye kweni do ken mor Dimascus. ");
INSERT INTO bsj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","La mani ma toti wori filanko wo yem nuwe miu. La nubo wari kange meu tamen kang ko ya kiye Dimascus. ");
INSERT INTO bsj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Wi ma nii dendo Anaiya, nii cwa tai kwama tifiye wer funer nii ken wo Ibraniyawa dam wiyeu gwam tok coti. ");
INSERT INTO bsj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Con bou minen, tii minen, la con man to co. ");
INSERT INTO bsj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","La con yiye, kwama wo tebbebo ciyeu coknen na mo nyumom diker co cuitiyeu. Na tom nubo cak-cak, na nuwam diro ceruti nyiceu. ");
INSERT INTO bsj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","wori mwan yikan nii warke ce nubo nin gwam ki dike mwa toweu kange wo mo nuwau. ");
INSERT INTO bsj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na weu ye bwi mo ning tang tiye? ");
INSERT INTO bsj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kambo ma yilaken wursalima la ma kwob diloti mor kuu waberi, la man yo dukum. ");
INSERT INTO bsj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Min to yi teti kwer wolum na dobum wursalima can candowu, wori mani cia ciya warker mwe dor minreti. ");
INSERT INTO bsj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","La man toki Teluwe, ciki bwici nyumom kuwo man kurangi, man buk nubo buro ne bilenker dor mwerue mor bi kur wabero gwam. ");
INSERT INTO bsj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","kambo bwiyale ni warke mweu Istifanus coreu, ma tim wi mati ciyai ma con kulen nubo buro do twalceu. ");
INSERT INTO bsj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","La con yiye, ya wori man toum nen kutanfiye nubo kumtacile wiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Cin cuwa tuu cinen lamna wo. la cin kung dir ciyero citi toki, atwalum wang nubeko wo dor bitiner la kebo dong-dong ca dam wi. ");
INSERT INTO bsj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kambo ci kwabang diroti, ci mobang kuleng ciroti kange kung ka kwerek. ");
INSERT INTO bsj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nii dur nob kwenibou, toki a dom ki Bulus fiye nangen nob kwenebo. La con toki a me coti ki mallika balyakye, wori co ki bwici na co nyumom ye bwi ci kwabnag dirtikercere. ");
INSERT INTO bsj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kambo ci bwam co dii ki dukkari, Bulus yini bi kwane wo tim cinen, yori kabo werfun na tom nii wo barome wuro bulanko tacobeu? ");
INSERT INTO bsj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","La kambo nii bikwaneu nuwa weri, la con yaken ni dur nob kwenebo nen yico ki “ye ko do ma ka tiye?” la nii wo Romaneu. ");
INSERT INTO bsj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","La ni dur nob kwenebo bou la meci yiye mon Romanka bulus ciyaco, ki “Ong”. ");
INSERT INTO bsj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nii dur nob kwenebo yi coki, kiyemero ducce matiyen yim bwebitineme. La Bulus yico, ci bou ye bwe roma. ");
INSERT INTO bsj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","La nubo buro a meco kerti yeu dubangum co dang jang nii dur nob kwenebo cwam tai ken, kambo co nuwa Bulus bwe Ramon di, wori con bwam co di. ");
INSERT INTO bsj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Celfiniceri nii dur nob kwenebo cuiti na co nyumom bilenker dor dike yafudawa fi Bulus ti cikeu. La con kwim bwaka cko la con yi liya wabeu kange nob dir loro gwam na cin mwerkangi. la con yirau ki abulus yoken co tiber ciyer. ");
INSERT INTO bsj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul to nubo mwerume ri ki, minya yam kange kwam. ");
INSERT INTO bsj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nii dur wabero wo coti ki Ananiya ne nubo bikwan gwam ciya kwanice. ");
INSERT INTO bsj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Dila Paul yi co ki, “Kwama an kwanne mo nii bwir moyim namo mamen warke ki bolang ka, dila moki ciya kwaye ki kang wo kebo dong-dong kange bolang?”. ");
INSERT INTO bsj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nubo tirangum wiyeu ki ye bwi mon torang nii dur nob waber kwama ro tiye? ");
INSERT INTO bsj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul yiki, Yimi ma yombo miki nii dur, molangum molange ki, mani mwa tok bwirang kerti nii dur nubo lokume. ");
INSERT INTO bsj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","La kambo Bulus nyomom kange win bwe Saduciyawa, la con tok kero ki luma wi ki, kebmibbo min nii Farisawa, bibwe farisawa kambo min cuiti na nyomom kwenka ceko tuwe wo man ma bolang cekeu. ");
INSERT INTO bsj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","kambo ca tok nye ri, kwabkang ka bwi bwitici. Farisawa kange Sadukawa kange, mwerenkang kako wo. ");
INSERT INTO bsj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadukawa toki ki, Kwenka mani, bibei tomange mani, yuwatangbeko mani, La nii farisawa nyom gwam. ");
INSERT INTO bsj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kwobkang kako kweni wi bwiti cii, la Farisawa ki ciya to bo dikero bwir fou nii wo nen. Ye a bwiti no yuwa tangbeko toker kange co kaka no Bibei tomangeceu toker kange cori. ");
INSERT INTO bsj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kambo kwobkang kako dur kweni tiber cereri, nii dur nob kwenebbo cwam tai ki kari ci wobrangum Bulus, ki fiti kang cek, la cin dok kwenebo na yira tou co ki bikwan tiber nob durembo na bou ki co fiye ca fiyam corka tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kambo kume kange lauweri, kwama tii cungya cek toki ki, “cware tai cin cuwa nen firen Ursalima naweu. Mwan nii kange fou Roman. ");
INSERT INTO bsj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","kambo fini celum ri, kangum yahudawa ma nero bwir laci nacin co dor ciyero nin chilka ki weri, naci chare kaka, ci no diker no ci twalum Bulus ri, nimde. ");
INSERT INTO bsj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nubo cum kwini na'ar wo yi yimbo bwirko weu. ");
INSERT INTO bsj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","La cin ya ni dur wabero nen kange nubo durko ki, Bin yo dorbero fiye chilka no ba twalbo Bulus diker mani wo ba matiye. ");
INSERT INTO bsj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Na weu bi yi Liya wabero na bou ki co fou bitine na bin fiya co ki dikero bwir ka ceri, cin ciya na twalum co. ");
INSERT INTO bsj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","kambo bibwe hadace bwe bubiya nuwa na weri la ya yi Bulus ki, ");
INSERT INTO bsj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","“Bulus cho kange nii win na ya ki nii wo dur bero nen cin wi ki dike ca toktiye. ");
INSERT INTO bsj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nii wo tim wiyeu tuu bwewo yaciko fiye dur nub wabero wiyeu ki Bulus wo fou mor furcina, cin yiki ki nyon bou ki co monen cin wiki dike ca toktiye. ");
INSERT INTO bsj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","La nii dur nub waber tou co doken mor, la me co ki “Ye mon cuiti namon yi yere?” ");
INSERT INTO bsj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Bwewo yi ki, “Yahudawa ciya ki bouki Bulus fine fiye mwerkangka, cin cuiti na me co diker dor bolnag ceko nen. ");
INSERT INTO bsj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Dila necire cou, nubo wi cum kwini naar wo ci cwiti nacin twallum ceu. Cin yiyim bou wo ciki mani ciya chati, mani ciya noti, kambo ci twalum ceri nimde ci chachari. Bwen naweu, ciki bati ci ning tang diker mwa tok tiyeti.” ");
INSERT INTO bsj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","La nii dur wabero yici ki kom manki kange diker wo ka yii nii wo tiyeu, nii wo yimco dikero gwam. ");
INSERT INTO bsj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","La con cou nob bikwanebo yob ki, ciya cok nob bikwanebo bikwate yob nacin yaken ki co Caesarea, kange nub tuwabbo kwini niber, kange nubo bikate kwini yob, ciya kwenum ki kume taar rewo. ");
INSERT INTO bsj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Con yici ki ciya dou bicirdo wo Bulus a fuhtiye na yaken ki con loh kwarer. ");
INSERT INTO bsj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","La con mulang bifumer nawo ki. ");
INSERT INTO bsj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Claudius Lysias kimo liyar kalero nen Felix, yarum nen ti. ");
INSERT INTO bsj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nii wo Yahudawa tam co, la cin cuiti nacin twalum co. kambo bou cinen ki nub bikwaneb, la man cokceu. min yumom ciki no biten Romane. ");
INSERT INTO bsj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Min cuiti na yunmom diker wo ci tok ti dor cereu. La min ya ki con fiye mwerkang ka. ");
INSERT INTO bsj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Min nyom ci merang co kerti wo yilam na doka ceu. La cin manki diker wo yilam ciya twalum coti, ko ciya tung coti furcina. ");
INSERT INTO bsj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Di la cin yiye ciki, dikero bwirko wi wo ci cwiti na cin ma nii wo nineu, la dangjang min tung kenco monen min toki diker ci ficoti cikeu ciya bou ciko fiye mou wiyeu. Ya kwamer. ");
INSERT INTO bsj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","La nob bikwanebo bwang ten diker cha tikeu. Cin bou ki Bulus ki bikume fou Antipatris. ");
INSERT INTO bsj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kambo kume lauweri nub bkwanebo dubom nob tuwab bo kange cou. lan cin yilanken ce loh. ");
INSERT INTO bsj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kambo nub tuwabbo lam Caesarea ri, cin nee takada wii liyar bitinenen, Cin neken ten Bulus cinen. ");
INSERT INTO bsj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kambo liya bitine tou takada ri, Ye bouki Bulus feh? coki no biten Cilicia. ");
INSERT INTO bsj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Con yiki “Man nuwa nen gwam kambo nubo wo toker tidor mwereu bouri, Con toki ki, ciya yaken ki co kan Liya dur bitenero nen Hiridus firen wabkang ka. ");
INSERT INTO bsj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ki kume nundi, Nii kange wii ciyi cotike ananiya nii dur wabe, kangum nubo dur kange nob yob ka bolange decero, Tertullus yaken wi ki kiyange Bulus ce. kabum nii dur bitineronen. ");
INSERT INTO bsj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ki kwama wo Bulus tim kabum nii liyar Tertullus yoten torank coti kiwe gwamna “Ker mwer nyo fiya, yiblume to kaba, bo ki yulka bitine ben. ");
INSERT INTO bsj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Dike mo maneri nyo ki bukan kangen, nii dur Felis. ");
INSERT INTO bsj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kali nene do tange, miki nanneti nuyen bi dom nan yinen ker. ");
INSERT INTO bsj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Cin fiyam nii wo kan dikeroti kilanye yila cuk nubo Yahudawa kalenen gwam. ciya terkutumeti. ");
INSERT INTO bsj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Mani naco fuyatamin kuwaber, co dike nyo teuce (Nyo cuiti na nyo warcinen wo dong dong kange funereu. ");
INSERT INTO bsj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Dila Lysias boyoco win kibi gwan kanciyen. ");
INSERT INTO bsj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na mume Bulus dikero wo gwam di mwan yumom dike nyi tok ti dorcereu. ");
INSERT INTO bsj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahudawa ciya bwanten ci, chin ciya chiko ki dong dong. ");
INSERT INTO bsj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ki kwama wo nii dur ko ne Bulus filanko na tok kereri, Bulus ciya, “Miyumom ki coti kila mwin nii warke bitinewo nen, ki bilangtum mi nung dor miro ti munen. ");
INSERT INTO bsj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mon yumom cubo kumeni kwob cillombo yob ciko min kwi nami ma wabka mor Ursalima. ");
INSERT INTO bsj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kambo ci fiyaye mor bikur wabereu, ma kwobkang bo kange nii kange, ma kung bo kiyan tiber nuber mor bi kur wabe, kaka, cinan lor. ");
INSERT INTO bsj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mani ciya nung mwen bilenke dike ci toyeti cikeu. ");
INSERT INTO bsj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Dila miyinen, mor dikerowo ci toki kuwabe nyoken mi bwangten kwama nen kwanimin. mine dur mor dike ci mulang mor bifumer durko. ");
INSERT INTO bsj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Min wiki bi kwan nener naceu ken Kwama nen, na nubo buro, fuloka ko bwareu wi, ki nubo cak-cakeu kange nubo bwir gwam. ");
INSERT INTO bsj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","La kang-kang miki mani nami to nermiro kuwayebo, kabum Kwamam, kange niffir. ");
INSERT INTO bsj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","kangum cotinim mi bou nan tinkan kume diker cike kange lumanerer. ");
INSERT INTO bsj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Min tu nyo ner mir mani nyo la yahudawa biten asiay dikero moten wo cenge ku wabe kebo ki mwer kanka ki kutume. ");
INSERT INTO bsj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","daten nubo bulum ciye bo fiye mo wiyeu duwen naci wiki diker tokka dor mwer. ");
INSERT INTO bsj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","na kebo nyori nubo lominbo ciya togki na ci fiye kidire kikwamawo matogti kabum nob mwerkanka Yahudawa. ");
INSERT INTO bsj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","No dor dikewo mi tokki ki dir kabum ciyeu, wori gwamka nob Bwerem. cimen coti ci doti naci moten bolanko. ");
INSERT INTO bsj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felis, wo ci yimco ker dor nureroweu, kungum nuwa kako. Cin yi ki, “No Lysias nii dor, nub kwenebo, yirau Ursalimari, man tok diker amati ki bolang mweko neneu. ");
INSERT INTO bsj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","La co yi nii bikwan ne nob kwenebbo ayoken Bulus kan nob corkab, la co fiya cerka biduwar kati kange mor ferubceb fiyabo nure aneco diker ci cwitiyeti. ");
INSERT INTO bsj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kambo Kumeni kange cumeri, Filibus kange wice Duruskila, wo Bayahudiya La cin twomi na cin bouki Bulus di naci nuwa cinen ker bilenker dor Almasiya Yeesu. ");
INSERT INTO bsj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Di la kambo Bulus bulangi kange co, dor cak-cake, taka dorek, kange bolang ko boutiyeu, Felis cwam tai, La yiki, “Muyaken ti naweu. Dila non fiya filang ki bwiri, min twom mwen.” ");
INSERT INTO bsj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ki kwama wo cun nyoti nerwi ki Bulus a neco kemer ducce kir-kir naco tok ker kange co. ");
INSERT INTO bsj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ki cwuro yob Borkiyas Festas yilam nii dur buwab Filibus, wori ciki do fuwor bwiyat fiye Yahudawa yoten to Bulus ki toka. ");
INSERT INTO bsj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","La Festus do ki kume taar gwam kaisariya yaken Ursalima. ");
INSERT INTO bsj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","La nii dur wabe kange nubo dur yahudawa cin bo ki kwanere dor Bulus cer, la cin kenco. ");
INSERT INTO bsj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Cin me tikali cinen na ci doken Bulus mor dotange - di Festus na cou Bulus Ursalima ri na cin twalumco dor nure ");
INSERT INTO bsj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Dila Festus ciya ciki, Bulus bou firen kaisariya, kutakni coki bweco aniylareken firen. ");
INSERT INTO bsj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nyori wo Ayumom bwikan gekotiyeri. Na bwirank ke kange we kange nii wori ciya toco. ");
INSERT INTO bsj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Dila ki kume narub kaka kwob la nyilake kaisariya. Celfini ceri Nyiken fiye bworange ki ciya bwoki Bulus kabum cem. ");
INSERT INTO bsj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kambo Bulus boweri Yahudawa wo Ursalima tirangum bidom ci yoten ci bwerauti ki kiyage laci fiyabo ken wi. ");
INSERT INTO bsj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulus cokum dorcero ki, ma mabo nii nen bwiranke, kaka Yahudawa, kaka kuwabe kaka kaisar.” ");
INSERT INTO bsj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Dila Festus ki do fuwor bwiyarade fiye Yahudawa wiye, Dila nyori co me Bulus ki mo cuiti namo ya Ursalima. ");
INSERT INTO bsj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulus yiki co tim fiye maka borank kaisar fiye tam ceu. Min ma dike yorbei kom nyumom gwam. ");
INSERT INTO bsj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Na bicom mima burankge mima dike dateng bwerangke mikobo in bwiyam. dila na dike lam na bitoren cwerke nin, nikange cunkange. mi tuwciurkumeti fiye kaisar.” ");
INSERT INTO bsj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","kambo Festus dim fuwakangkako kange nobe ri La ciya ki, mo cu kaisar monyanken kaisar”. ");
INSERT INTO bsj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ki kume kange, liya Agrippa kange Bernice cin yirau Caeserea na cin yacuner Festus ki diker. ");
INSERT INTO bsj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","La lam kumeni, kila Festus nyi liya keti bidarange wo Filibus domti mur kuu kuka. ");
INSERT INTO bsj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ki kwamawo mi Ursalima, kange dur ni wabka kange nubo dur Yahudawa ci boki kiyange ce fiye miwiyeu, cin keni naci twalumco. ");
INSERT INTO bsj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ki woro yi ciki, ke dam Romawa yibo ki aneken bibei nii bibwiyer, La wo ci kwakiyagece cin neco firank naco congum dorcero nob kiyagecenen, naco kiye ker kiyangece. ");
INSERT INTO bsj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","La ciin mwelim kebo ki tiranka kene, celfiniceri miyiken fiye maka bolange minyici ciya boki nii co. ");
INSERT INTO bsj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kambo nob kiyangebo boki kyangeceri, kero ken mani morece. ");
INSERT INTO bsj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Miyumom kwaka kaciyeko na kuwaabece dor Yesu wo bwiyamdi Bulus ki wuki dume. ");
INSERT INTO bsj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mi fwiki kambo ma fuma kerowo matongti lami meco miki monyaken Ursalima na walum kero. ");
INSERT INTO bsj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Dila Bulus do ciya toco, Kaisar walum kero lamitoki ciya yobco men tukco kaisar nen. ");
INSERT INTO bsj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa yi Festus, Min cuiti na nuwa nii wo.” “Fini,” Festus yiki, “Mwan nuwa co.” ");
INSERT INTO bsj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","La ki celfiniceri Agrippa kange Bernice cin bou ki diker chaklang ka, kange nubo durko bitineceu. La Festus toki, ki ciya cokum Bulus fiye ciweyeu. ");
INSERT INTO bsj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus yiki Liya Agrippa kange nubo wi kange ciyeu cin toh nii wo kange nubo mwerum feu nub Yahudawa kange coh Ursalima gwam ci werang coti ki daten bo co yim ki dume. ");
INSERT INTO bsj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ma nyumom mabo bwirang ke daten bwere, Dila wori co twalum kero cou yaken cuko fiye kaisar wiyeu. Nyori ma motum intomken co. ");
INSERT INTO bsj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Di miman ki Kerokange mitontiye miki murank kaisar nen. tomange, ki kerowo mibocuko kakumeu, nawonyon mitonentiyeu mo liya Agrippa. nan fiyam dike mayuktanti muranka mikonen dorcer. ");
INSERT INTO bsj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Fiye miwiyeu Bwira kabo intunin bwiranke mi murankbo bwirang ke co. ");
INSERT INTO bsj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","La agrippa yi Bulus, “Mon nyam coka doremwei la Bulus kunkan ceko yoten condorceroti.” ");
INSERT INTO bsj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Miki Fuwor nerer, liya Agrippa, ki kerowo yahudawa bouti cuko dor mireu. ");
INSERT INTO bsj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nyori mo nii yumka mor den Yahudawa kange yabciebo. Nyori mikenenti. Nyoli bob nermwero kange bwewo. ");
INSERT INTO bsj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Miyi komti gwam yahudawa yubram fiye yim kallemibo fiye wucakke kange Ursalima. ");
INSERT INTO bsj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Cin yubrangum ye ki kaba, daten ciya yumom miyiyen na bafarasawa. ");
INSERT INTO bsj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Naweu miki naci mamen bolang nawo wori nor wa kwama tu tebbyebbo ni nen. ");
INSERT INTO bsj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Wo cou nure ber gero kwab curomboyo yoti ner wiye. ciya wou ki kwamawo ci wabkwamati ki nero win fiye kwama wiyeu kakum kange kume. Ki yoka nerewa, Liya agrippa, yahudawa buranti. ");
INSERT INTO bsj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ye bwikange aburank ti ki diker yumanko kwama akun nob bweyame? ");
INSERT INTO bsj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","La mi burankge ki maka dikero kiden Yesu bana zaret. ");
INSERT INTO bsj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Min ma buranka mor Ursalima, mi ku nob bwika kwamako duce mor Fursuna. Ki bikwan do wo mifiya fiye nob dur wabero wiyeu, kange wo ci twerciti mineci mwerka duwen. ");
INSERT INTO bsj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","neci dotange duce kwab kuh wabe mi cuti nan dongcinen naci ma burkane. Ma ma kiye ciren kangeci minaci dotange yaken cuka bitiye tim bokage. ");
INSERT INTO bsj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ki kwamawo mima buroka boti mi yaken Dimaskus ki ciyaka dur nob wabe. ");
INSERT INTO bsj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mor yame mi, ki kaku, mo liya mito firen dikawama wo la kaku filanken filanko ketenye, kange nubo nyo yakenti wari. ");
INSERT INTO bsj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kabom kwaob nyo yarken bitine, minuwa diro kange tok keroti kange mwoh ki nye Ibranciyawa yiti ki, shawulu, Shawulu ye bwi mon neye dotange tiye? bwikabo na kundike cucuwe. ");
INSERT INTO bsj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","La miki webo teluwe? Teluwe ciya mo Yesu wo mone dotange. ");
INSERT INTO bsj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Naweu kwen titiye ki co kerowo manun dor miro munenen nan yome? na yilam canga kange nii warkere dor dike moyume dormireu nawo kange wuro miyinentiye. fokab. ");
INSERT INTO bsj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Man cuken fiye nobo wiye kange nubo ma to ci fiye mowiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Na mo wumom nuwage ciyeu yilau ki ci kumtacile yilau ki ci filank. na cin fiya cerka fiye yuwako bwirko wiyeu na ci you yuwa kwama, kange fuloka dikero bwir nen wo cha ne nubo bwang ten co tiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","La nyori, liya Agrippa miken kom kangumbo ki dukumbo wamito dikwamau. ");
INSERT INTO bsj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Dila, kabokoce buro mor Dimaskus. kange Ursalima kange biten Yahudawa gwam, kange nob furenebo, mima cinen bwiranke naci yiloten fiye kwama wiyeu, cin ma dike daten yilokau. ");
INSERT INTO bsj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Co dike bwi yahudawa ci tamce mor kuh wabe ci cuiti naci twalum co. ");
INSERT INTO bsj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kwama tikang wo duwin mi tim kabum bibei kange nubo dur, warke dor dike annabawa kange Musa toki abwitiye. ");
INSERT INTO bsj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Dong dong Almasiya a nuwa dotange anyi lam kaba wociyar komti bwere an tok filang fiye yahudawa kange nubo yumbo kwama. ");
INSERT INTO bsj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kambo Bulus dim coka duwek cekori, Festus tok kero ki dir, ki Bulus twaka mani ki nyomka mweka donen twalka. ");
INSERT INTO bsj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Dila Bulus yico, “mitwalbo nii dur Festus kibi kwan nerer mi tok bilenke tiye kange cinen. ");
INSERT INTO bsj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wori liya yum bo dike burombo gwam, co dike bwi mitok keroti kibi kwane, wori miyom dike kange mani wo yurangum yurange. ");
INSERT INTO bsj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mo ne bilenke kange nob tomange dukumbo, ko liya agrippa? mi nyomom mo ne bilenke. ");
INSERT INTO bsj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa ni yi Bulus mor kere biduware muki cui namo bwolye na yilam nii bwanka kwama ka? ");
INSERT INTO bsj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus yiki “miki nanenti kwama, mor kene bi dure kange kene dur, kebo mo ki kwama, gwam kange nubo nuwa yilam na mo. ");
INSERT INTO bsj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Liya kweni ti kange nubo dur kange Bernice, kange nubo gwam yilamom kange. ");
INSERT INTO bsj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","kambo ci dubom ku wabe ri cin ter tok kako kere ko bwiti ci ciki, “Nii wo mabo dike dotange borom kange bwika.” ");
INSERT INTO bsj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa yi Festus ki naki niwo tumbo kiyage yakenbo cuko kaisar nadi noci yamkancinen. ");
INSERT INTO bsj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bwiko ciyaka ko ki nyiki yang italiya ciin neken kange nubo kangembo furcina kang nii dur nub kwenebo ci co ti yuliya wo mor mwan Agustus ke. ");
INSERT INTO bsj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nyin doken nabire mwenge mor Adramatiya, wo ywel bwiti na cii ya bidom kange cunga wima ko Anciya. La nyi yaken mor wima Aristakus wo Tasalonika mor Makidoniya cin yaken kange nyo. ");
INSERT INTO bsj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Cel fini ceri nyi yiram cinanlor sidom, fiye wo Yuliyas nung Bulus nin neer lumare la cin dobco naci ya farub cebo nen di naci yo toka ceko. ");
INSERT INTO bsj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nyi kweni wiri nyin doken mor Wima ri nyon yaken kong mwenge kubruce, wori yuwa ko ne nyo dotange ti. ");
INSERT INTO bsj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ki kwama nyi yabken wima nyi yabken dinge kilikiya kange Bamfiliya nyim la mira, cinan loro Liciya. ");
INSERT INTO bsj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Wii niii nabire nob kwenebo fiya nabire mwenge wo bou Takendariya ri, a yaken ti Italiya cin more ce. ");
INSERT INTO bsj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kambo nyi yakenti kumeni kila nyi yaken biluma, la ki cuile gwam ri nyin lam ki dotange bidom kange cinindu ri la yuwa ko dob nyo bo tak nanyi bwangten cunga ko cou, nyin yaken cunga ko ci kicimkice bidom kange karita bidom kange Salmani. ");
INSERT INTO bsj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nyi yaken cunga konge ki dotange, nyimde nyi bow fiye kange cou ti ki fiye turangka ko ken, wo bidom kange la ciya. ");
INSERT INTO bsj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","na weu nyin tu kumeni kila, la kwama ngag ngake Yuahadwa cum, la naweu yambo yilam ki tai la Bulus werang ci ");
INSERT INTO bsj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Ciki, Nubo matori yambo wo bi ter tiyeu atin yilam ki nuwa ka twirak kange le-ka dikerek duce, kebo kawo kwilendo ceu kange nabire mwenge, dila kange dume beuken. ");
INSERT INTO bsj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","La nii na bire nub kwenebo cuwa tu ka diiir teluwe kange nuu nabire mwengeko nin la cuwa bo ker Bulus cero nin. ");
INSERT INTO bsj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Wori fiye tuka kwilenek na bire mwenge ko bwei yim wiki cukakiya ri nob kwobka nabire mwengeko duce tok ki ciya dubom fiye cou la tano cwika fiyaka ri bi lam cinar lo finikiya, nabi yim (wa kiyauwi). La finikiya co fiye tii mwe nabire mwnege mor karita, wo to kwasalmen ti kange mar to me tiye. ");
INSERT INTO bsj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kambo yuwa bange ko ter cu kako kibi luma ri, nubo kwob nabire mwenge ko tiyeu kwabi neer cer ki ciin fiyam dikero cii cwi tiyeu. Dila ciin cukum duka nabirek mwnegeko la ciin bwangten cunga ko karita bidom kange kong mwenge ko ");
INSERT INTO bsj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","La fiyaco bi duwar di yuwako kwani nyeu wo cii cuwa tiki yuro kilidom yoten buk nyo ti diyelenen. ");
INSERT INTO bsj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","kambo nabire mwengeu fweki cukako fiye ki yuwa wori yuwa ko lambi kwan ceredi, nyin bwang ten nur yuwau. ");
INSERT INTO bsj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","La nyin bwnagten fiye nyi fiyam cerka ko diyele bi duware coti ki kauda, la ki dotange nyi bwam nabire bi duware bwi durko nen. ");
INSERT INTO bsj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kambo cii kongum nabire mwenge bi duware dii yeri, ciin ma nangen ki duka ceko ri ciin bwam bwi nabireko durko cuko. Taito tamci ki cukum dikero a tam nabire ti dor mwengere dila nyin bwang tenti. ");
INSERT INTO bsj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nyin nuwa dotange ducce ki yuwa mwengek wo ki celfiniceri ciin ter cutangka kwileneko wo mor nabire mwengenen wii. ");
INSERT INTO bsj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ki kume taar ri nob nangenebo mor nabire mwengeu cutang kwilendo mor mnabire wi ki kang cek. ");
INSERT INTO bsj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","kambo nyi to bo filang kakukek kaka bitiren kume taare ri, yoka nereko ki nyan fiya ceer kau cerum nyinen. ");
INSERT INTO bsj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","kambo cii ya yambo kwitan cari mani yeri, Bulus kweni tiber nob nangeneb nabire mwengeko ri ciki, “nubo, nakin kom cuwa tu kermiro nen, bi kwenu bo karitari no biki fiyabo twirako buro kange leka kwileko. ");
INSERT INTO bsj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Na weu miyi komnti ko yilam ki birom nerem wori nii mania bwiyati more kume dila ka nabire mwenge bi lem tiye. ");
INSERT INTO bsj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","wori wo min naceu, wo mi wabti takeu bwe tomange ceu tii cunga miik. ");
INSERT INTO bsj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","La ciki cware tai, Bulus tam nyo mwanti kabum kaisar re. la to, kwama mor jire duwece neken gwam nubo wo yaken wari kange mweu. ");
INSERT INTO bsj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","La nyori ko yilam k bikwan neeret nubo, wori min ne bilenke kwama nen atin yilam nawo ci yiyereu. ");
INSERT INTO bsj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","La batin cwa bi kangtangi kange Island. ");
INSERT INTO bsj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kambo kume kwobcilombo naareu dimeri, la cii tung nyo fou kange firen mor wima ko adriyate, ki ciin kume ri nubo fu nabire mwenge tiyeu kwabi ki ciin dadum kange bitine Kange. ");
INSERT INTO bsj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kambo cii cuwa ri, cii fiya nako kwini yob kambo kakten biduwar di ci cuwa ten di nako kwob cilumbo nung. ");
INSERT INTO bsj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Cin tum tai ki kangeri ciyan kwiti teer, la ciin curken duka ko ciin komti cikeu naar cwile nabire mwenge nen, cin kwob dilo fini a celum wulom. ");
INSERT INTO bsj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nob nangeneb nabire mwengebo do nure ciya dubom nabire tiye ri ciin merken nabire mwengeu biduwareu mor wima. ciin mani namwi ci yan merangken duka ko kangembo wo mor nabire mwenge kabum nabire ko nen. ");
INSERT INTO bsj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Dila Bulus yi nii dur nob kwenebo kange tangum cembo “No nubo buro mani a tim ti mor nabire, msni ciys fiya cerka ti.” ");
INSERT INTO bsj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Dila nob kwenebo mwatum dukako cinn dubti yuram. ");
INSERT INTO bsj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kambo fini ter celkakeri Bulus kenci gwam cia can carito. ciki Diye wo co diye kwobcillumbo naareu wo kom mor curka, la kom cabo cari. ");
INSERT INTO bsj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","La mi kinong komti, kom cam carito wori cerka kume ko lam, kange kume mani wiin wo a le yere dore cetiye”. ");
INSERT INTO bsj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bwiko ci tok kero wari ciin tu carito la ciin bu kwama nen kang, ciin duwa carito cin yo cakako. ");
INSERT INTO bsj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Dila gwam ce ciin fiya bikwan neret ri ciin tu carito ken. ");
INSERT INTO bsj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nubo kwini kwob yob turdo kwini niber cilumbo nuukkun ki dume tini nabire mwenge nen. ");
INSERT INTO bsj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kambo cica ci bwameri, cin filam ten ki nabire mwengeu, ");
INSERT INTO bsj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kambo fini celumeri ci nyombo bitineu dila ciin to kum ki konge la ciin tokkangi bwiti no ci yan yila ki nabire mwengeu wiri. ");
INSERT INTO bsj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","La ciin mwatum duka ceko ri ciin dobti mor wima. ki kwama co wiin ciin kwim dukako, yila nabire tiyeu. Dila nabire mwengeu kwiti dor yabum cerum cereu. kambum cembo ywiken wi, la mor kwita kako mani la bi kwan mwelka mani. ");
INSERT INTO bsj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","cin bou fiye wo cajiyo yob mwerkangummeu, la na bire mwenge doken mor yabume. Tangum nabire mwengeu ywiken wi la mani yayamti, La cunga ko ki kyarangi ki mwembo mwelangtieu. ");
INSERT INTO bsj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","La nob kwenebo ci naci twallum nob furcinabo kari kange kwa mwembo cwalem. ");
INSERT INTO bsj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","dila nii dur cero cwi naci cer ki Bulus la cin tim ki dikero cii cui makau, nubo nyumom kwaka mwengek la cin mwabken mor mwenge cin yabken konge. ");
INSERT INTO bsj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Dila tangnum bayilobo na bwangten kange dor bwatiyer kangembo dor nabire nen. Ki nurewo, la gwam nye nyin beken kwamer bitine. ");
INSERT INTO bsj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Fiya cuwo nya yilau kwamere, nyan nuwa den diiyele cuwa ki malta. ");
INSERT INTO bsj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nubo mwan loro cuwa nung yinen luma nerek cin nuwa nyinen kira, cin yuwo nyo gwam ker mwemer kange cwuii ngir-ngireu. ");
INSERT INTO bsj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","La Bulus mwer bwatiye yo ti kirari, kwentibe ceru, wori kirako cwillen cakkan cinen ti kang. ");
INSERT INTO bsj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","La nubo mwan loro cuwo to na cuwe yayim kang cek ri, ci tokkangti bwitici ki, “Nii wo nii twal nob ti ci cuku mor bware caji. Kero dong dongeu ciyabo nii a buuti.” ");
INSERT INTO bsj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","La con waciken na cuwe kira, kii cobo. ");
INSERT INTO bsj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ci nintanti na ci to bwici fum, ki kwirum bwi na yarke bitine na bwiyam. La cin to co fiya kutangi, cin tobo diker fiya cobo di, cin fulongum ner cero, cin yi ki con bwel. ");
INSERT INTO bsj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","La bi dom kange fiye cuwe, take kange wi na nii durece diiyele cuwa, wo ci cuwo ti Babiliya yuwo nyo, ki luma nerek, tam nyo na kume taar ce. ");
INSERT INTO bsj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","La te Babiliya cokkati kiwirum bwi kange teka fiya cuwa Bulus ya cinnen kwob cinen dilo, cin yoti kang dor cer con twam co. ");
INSERT INTO bsj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Bwiko dike woro bwiyeu tangne nube yim diile diile wuro nen nuba. Luma cin bou ken cin twam ci. ");
INSERT INTO bsj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nubo wuro ne nyo dur ti ki dur. La nyon ka bati yamtiri, cin ne nyo dike nyo cwitiyeu. ");
INSERT INTO bsj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bwiko cwak ko taare nyong kwen yambo ki nabire mwenge wo ma tirako wiiye, nsbire Alexandriya, ki bwel do yob ci ywellum tikab dore cike. ");
INSERT INTO bsj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bwiko nya yiram cinanr lor ciranku nyon yim wii kume taar. ");
INSERT INTO bsj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Wii ri nyon yaken cinan lor Rigiyum ki kume wiin di, yuwa ko bangeu kwenu, la mor kume yobeu nyin lam cinan lor, Butiyoli, ");
INSERT INTO bsj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nyon fiya yitub nyebo kange wii, cin cuwo nyong yii kange ci kume niber, nure wo nya yaken Roma. ");
INSERT INTO bsj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nyo firen di yitub nyebo nuwa fulen nyero cin ceru cin yuwo nyo, tati fiye miyeka dike Abiya kange bituk taar. La Bitrus to yitubori, con fiya bikwan neret. ");
INSERT INTO bsj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kambo nya doken Roma ri, cin dob Bitrus na yi ki kwace kange nii kwene wo to co tiye. ");
INSERT INTO bsj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ki kume taar di Bulus cuwo nubo wuro na dur mor Yahudawa. La cin bou ri, con yiki, “yitub me, ma mabo nob nen dikero bwir kaka, dike ka ciya cike wo tembebo ceu, cin taye. Bwiko cin me ya, ci cwiti naci nyam kang minen ci fiya yebo ki bwirangke wo lam twalka. ");
INSERT INTO bsj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Kambo cii merang ye kereri, cin cwi na cin nyemkan minen, wori ci fiya yebo ki bwirang ker wo lam ciya twalye tiye. ");
INSERT INTO bsj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","La Yahudawa tok diker cwika nerek ciyeu, cin dok ye, ya ki kiyange kaisar nin, muni bou ki kiyange bitineu. ");
INSERT INTO bsj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Dor kerero wo ma cuwo kom na to kom na yi kom. Nyo neri Israila ci bwam yere. ");
INSERT INTO bsj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","La cin yi co “nya yuwobo tomange kange Yahudawa dor mwer kaka kange yitubo bou bo nyi nyo dikero bwir dor mwer. ");
INSERT INTO bsj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nyo wcii na yi nuwa muneng ye mo kwatiye dor mwan nibero wo, wori nyon nyimom dike wuro cin toki fiye gwam. ");
INSERT INTO bsj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","cin yo cinen kakuko, nubo ducce bou fiye ci yim wiye con yi ci dikero gwam, con yi cerka liyar kwama, con ken ci dor Yesu ter ti ki Musa ya ciko nob tomangeb ki buri mee doti. ");
INSERT INTO bsj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kangum bo ciya dike co tokkeu, kangumbo ne bo bilenke. ");
INSERT INTO bsj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","La cin ciya kambo kange butici, Bwiko Bulus dim kere di cin cu. “Yuwa tangbeko wusakke tok ker nyii Ishaya nii tomange teb kimeb bo nin. ");
INSERT INTO bsj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Yi ki “ya nubo wuro nen, na yi ci,” ki nuwaka, kan nuwa, la ma ka nyomti, ki toka kan to, maka nyomti. ");
INSERT INTO bsj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","wori ner nibero wuro kuci, ki tuci, bwai naci nuwa, cin kumom nuwe ciye, naci tore ki nuwe ciye, ci nuwa ki tu ci nyimom ki ner cer, na ci yilau na twam ci. ");
INSERT INTO bsj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Nyori kon nyimom fuloka kwamako, cin ya nubo nyumbo kwama, ciya nuwa. ");
INSERT INTO bsj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","La co tokum dike buro di yahudawau kweni, cu lor ki kwobkanka ko dur more ciye. ");
INSERT INTO bsj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus yii wi ki chor kambo co co yim loh Aya, cin wab nubo gwam wo bou cineneu. ");
INSERT INTO bsj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","La ci tok liyar kwamaro ti, ci meran dikero dor Yesu ti kibi kwamer neret ci ywa cobo wii. ");
INSERT INTO bsj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Bulu canga Yesu Almasiya co na yilam nii tomange, take cokom coke na fulen kert Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Won co fulen kere do co ma nore ki kining nob tomangeb dukume ce more bifumero wucakke. ");
INSERT INTO bsj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Dor bi bwece wo bo bowe naniya Dauda mor bwiye. ");
INSERT INTO bsj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Fuye kwenka cek mor nobo tuwe, cin yo co a yilam bi Bwe Kwama bi Kwane ki yuwa tangbe ko wo wucakke- Yesu Almasiya. ");
INSERT INTO bsj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Fiye wo co wiye bin nyo luma kange tomange ker ciyaka bilnke mor nobo kumtacili, ker dene ce. ");
INSERT INTO bsj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mor nobo wuro kumtacili, kom ken cin cuwo kom, kom yilam na Yesu Almasiya ce. ");
INSERT INTO bsj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Bifumero wo ki nobo mor Rome gwam, kom nobo ma cwitiye wo Kwama ce, nobo wo cuwo cowe na yilam wucakke. Di luma ayi wari kange kom, kange fuwor nere Te be Kwama nin kange Teluwe be Yesu Almasiya. ");
INSERT INTO bsj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ki kiba ma bu` Kwama nin kang ti fiye Yesu Almasiya wiye ker kimer gwam wori cii tok fulen bilen ke kumero ti dor bitiner gwam. ");
INSERT INTO bsj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kwama wo ma wabti mor dume mi, mor fulen kerer Bi bweceu co warke mi, wo bwen fiyang di ma tok kom tiye. ");
INSERT INTO bsj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Kang-kang ma ken ti mor dilo mi bwen ki ma nyi ri ki bwiri nan fiya caka kaba boka fiye kom wiye ki ciyaka Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ma cwiti nan to kom nan ne kom ne kako kange na yuwa tangbeko ce, nan ne kom bikwan. ");
INSERT INTO bsj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mi ki nin tangi nan fiya neka bikwanek more kume, fiye bilenke bwiti be, wo kumeu kange miu. ");
INSERT INTO bsj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Na weu ma cwibo kom yilam ki bwini yomka, keb mibo, ma cwi na bou kumen kang-kang, dila no kebo na wori' no cii dob yebo, nami yilam ki bibei wo yuwa tangbe ko ce more kume, kambo ma fiya tangnum nubembo nineu. ");
INSERT INTO bsj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ma tum ki tutum nobo Helina kange tangnum nobembo, wuro ki yilene kange wo manki yilene. ");
INSERT INTO bsj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ma yim ki bati nan tok fulen keret cero kumen kom wuro mor Roma. ");
INSERT INTO bsj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mani ma nuwa kwenduwe tok fullen keret cet ti, bi kwan Kwama wo fulokakoce ki gwam nii wuro ne bilenkere, ki kaba Yahudawa, nimde Helinawa. ");
INSERT INTO bsj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Wuro more ce cak-cake Kwama ceru yanglang fiye bilenke yaciko bilenke, nawo ci mulangeu,” Nii wo cak-cakeu an bu ker bilenke. ");
INSERT INTO bsj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kwama nung funer cero firen dii Kwama dor bwini wabka, kange bwini cak-cake na bi bwe nifiroce, wo bimum bilenke ki fiye bwini wucakke ciye. ");
INSERT INTO bsj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","wori dikero daten cii nyimom dor Kwama re yanglang fiye cii wiye. Wori Kwama fwetang cii nen bilenke. ");
INSERT INTO bsj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Wori kabal cero wo twelum meu, bi kan cero bak-ni-bakeu wi fiya fwelka kale, mor fwelka kwilenti. Nobo buro ci man ki tabanka fiti. ");
INSERT INTO bsj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Dike bwiye, bwentano cii nuwa ti ciin nyumom Kwama, dila cii nebo dur a nyo con Kwama. Kaka cii nung cinen buka kangek. Nyo, lacin ciin yilam kule, mor nere ciye, neer cero manki bulanka kumta cili tam ci. ");
INSERT INTO bsj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Cii tu dor cero ti na nobo ki nyomka, dila ciin yilam kule tini. ");
INSERT INTO bsj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ciin fulongum duktonka Kwama nii diriye ki cer kanka dikero wo mani da diriye, na nii fir, bilibetinim, biyuwaro wo nako na'are kange wo kwob ti ki fwere. ");
INSERT INTO bsj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Last nyo Kwama nekenci fiye dilanka, yeika nerek, cii ne bwiti dotange bwiti cii. ");
INSERT INTO bsj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ciin fulongum bilenke Kwama ki cwerke, take Ciin ma wabka kange bwanka dike wo fwelfwele, nyi Nii Fweli wo diker bilanka diri. A ti nyo. ");
INSERT INTO bsj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Dor dikero wo, Kwama neken cii fite kayaka kange dotange, la natum ciyebo fulongum dam kurambo wo lerumme, la nwiye ki da kange nawiye ");
INSERT INTO bsj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","La nabarum ciyebo ken fulongum dam kurambo lerum nawiye kange bwayile, yilam bwayile kange bwayile cima kayaka ti. Wo co nabarubo dati kange nabarube cii ma nangen yeitumer ti, cii biye dike ci fiye ti. ");
INSERT INTO bsj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Wori cii ciyabo kange Kwama mor yime ciye, Kwama neken cii fiye litanka nerek naci ma dikewo bwira bwira. ");
INSERT INTO bsj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Cii diim ki bwini wucakke, Cil, nung-nung, biciren, kange kiye. Ciin nob koreb, twalkanka, bolkanka kange bwiran neret. ");
INSERT INTO bsj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ciin nob cuwarumeb, kange mwelka, nob kiyeb Kwama, wo kung kiyan tiye, nob kwici duwe, kange nob mwelka dikero bwir, nobo ko bwangka tebcibe. ");
INSERT INTO bsj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Nobo man ki nyomka, cii kebo diker ciyaka, wo mani cwi bwiti, man ki cika bwine. ");
INSERT INTO bsj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ki nyoka cik dike Kwama ki nobo ma dikewo tiye ciin daten warke bwarek. Kebo ka maka dike wo, ciin ti bwaka bwiko nobo matiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Na weu mwi manki taka fiti mo nii fir, mo nii wo ma bolang tiye, dirkero mwi ma warke dor kangere, kuwa nen mwki bwimo. Wori mo nii bolangeu mo ma dii ke cuwo ti. ");
INSERT INTO bsj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Dila bin nyumom bolang kwamako bilenke, an bou yaru dor nobo marang dike wo tiye. ");
INSERT INTO bsj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Dila ti yora, mo nii, wo ma bolang ti dor nobo ma dike wo tiye bwenno mo ki mai ken duwaleu. Mo toti ri mwan kam funer Kwamara? ");
INSERT INTO bsj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kakaa mwiki cuwekang luma ceko, wo bou ki tibranka warke ce, kange birom ne ce? Mo nyombo mwiki luma neceu ki nung na ya kinnen yiloka ka? ");
INSERT INTO bsj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Wori kwici ka duwe mweko kange ner mwero man ki yiloka mo ki tang dor mwero nin funer, bi diye funere, kakuk cerkangka bolang wucakke Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Can ya nobo dong dong dike nii mane. ");
INSERT INTO bsj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ki nobo wuro ma nangen luma man ki kurongka, ciin fiya dor ciyero nin caklangka, bwayilen kange wucake, can ne ci dume diri. ");
INSERT INTO bsj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Dila nobo cwi dor tiye, wuro ko ciyaka bilenke, ri la ciya kange bwini bilenkeu, funer kange kwenanka wo cilong cilonge an bo cii nen. ");
INSERT INTO bsj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kwama an yirau ki dikero bwir kange fir neret ki dume wo ma cile, ater ki Yahudawa ri nimde Helinawa. ");
INSERT INTO bsj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Dila caklanka kange bwayilen, kange fuwor neret ciyan yi kange nobo gwam wo ma nangen do keneu, ater ki Yahudawa nimde Helinawa. ");
INSERT INTO bsj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Wori Kwama kebo nii nanne. ");
INSERT INTO bsj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ki nobo gwam wo ma bwiranke kebo ki bolangeu, ciyan bwiya kebo ki bolang, ki nobo wuro ma bwiranke mor bolage a war cinen ki bolang ");
INSERT INTO bsj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Di kebo nobo nuwa bolangti nobo wucak kabum Kwama me, dila nobo ma dikero bolanka tokke ti ciya kaaka tiye. ");
INSERT INTO bsj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Dila no nobo kumtacili wo nyombo bolange, dila ciin ma dike dong dong daten bolange ce nur yime ce, ciin kwom bolangko dorcer, bwen duwal bolang man dor cireu. ");
INSERT INTO bsj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ki wo, ciin nungi dikero bolanko cwi tiyeu mulangum mulange mor nere ce. Diker mor nere ciye macinen warke ti, dume ne ceu ken neci warketi kange kwa nere ciyeko kua cii kaka tikang ci dor cero nin ");
INSERT INTO bsj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","kange Kwama nin. Wuro an bwi bidiye Kwama a ma bolang dike yurangum yurange wo nobo ce gwam, dor fulen keret Yecu Almasiya. ");
INSERT INTO bsj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Bwen duwal mo co dor mweroti Bayahude la mo yim dor bolange mwi kwilangti ki ki Kwama, ");
INSERT INTO bsj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ri mo nyumom dike co cwitiye, di mon ciya kange dike dong donge wori cin merang mwen mor bolange; ");
INSERT INTO bsj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Bwen no mon ciya moki bwimwi mo nii tika kabak fugmanin ri, filang fiye nobo wo mor kumtacili, ");
INSERT INTO bsj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wo ywel kule tini tiye, nii merangka bi beiyo bi duwatini, la kom wi ki nyomka kange wo bilenke ce mor bolange la wo ke yim kimem bo nyi? ");
INSERT INTO bsj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kom nobo merang kangembo nin tiyeu, kom merangbo dor kimero nina? kom wo kom ma bi weretti kom ki a kure kwiyeu, kom ku kui tiya? ");
INSERT INTO bsj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Kom wo ko tokti kom ki kange a mare kayaka, kom ma kayatum tiya? Kom wo kom ko fulen neu, kom ku kui ti bikur wabe ra? ");
INSERT INTO bsj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kom nubo wo ma bilangtum ti kange kungka duwe ki bolangeu, kom ma Kwama nin bangtu ti ki bwini bwanka bolange ka? ");
INSERT INTO bsj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","La “den Kwama ro fiyabo neka durek nubo kumtacili nin ki ker kumer,” nawo kweri cii mulange. ");
INSERT INTO bsj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nyo biyeka te lareu wiki mwem fiye kom wiye tano kom bwangten bolangko ri, tano kom yilam nobo mani bwangten bolangko tiyeri, biyeka te lau yilam bwini biyeka te larek. ");
INSERT INTO bsj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Tano, nii biye bo te la'u bwangten dikero bolangko cwitiye ri, ma ni ba tuu nii biyebo te la ce ti na nii wo biyem te la ka? ");
INSERT INTO bsj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nii wo biyebo te la ce bwiyeu, di bwangten bolangeu mani a dolti makimen bolang kom nobo biyem te la ra? Wori kom wiki bolangko mulangum mulangeu kange biyeka te la, di duwal kom bwangten bo bolangko! ");
INSERT INTO bsj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Wori ci kebo Bayahudi kale; kaka nii biyem te laak wo diker bwiyereu. ");
INSERT INTO bsj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Dila cin Bayahudi mor, nyo tak ri biyeka te laa ceko nawo mor nere, kange yuwa tangbe ri kebo bifumer. Nii wo caklanka ceko mania bou fiye nubo wiye, dila abou fiye Kwama wiye. ");
INSERT INTO bsj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","La fe lakankawo Bayahude cike? lan fe yokka biyeka te lareko? ");
INSERT INTO bsj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yora ceko wiki nure kila kila. Ki kaba, Ciin ne Yahudawa dukum fiye Kwama wiye. ");
INSERT INTO bsj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","La no kangem Yahudawa nebo blenker di? Bwini bilenke ciro, an kicim bilenker Kwama ro nangen na? ");
INSERT INTO bsj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Mania yila ti nyo. La nyeu, Kwama a yila nii bilenker, bwenno nubbo gwam nob cwerkeb di. Nawo mulangumeu,”na nung mwen nawi yilam nii cak-cake mor kere mwe, la na ma turani no mwi bou fiye bolange ri. ");
INSERT INTO bsj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Dila no bwini cak-cake beu an nung cak-cake Kwama ri, la ba tok biki ye? Ban toki biki Kwama man ki cak-cake wo ca bouti ki funer cero bine na? (miki manangen ki kwobkanka nii firek). ");
INSERT INTO bsj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","La ayilare nyo, la no nyori Kwama a ma dor bitinero nin olang nyi? ");
INSERT INTO bsj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Tano bilenker Kwamar ki cwerke miko yok ten caklanka ce ducce ri, la ye bwi ba men bolangti duwal na bwiranke? ");
INSERT INTO bsj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","La ye bwi ma ko tok ti nawo tokan keti cwerketi dor nyere, nawo kangembo tuken nyon toki nyo,” la nyo ma dikero bwir na kendo na bou wa? Bolang ciyeko dong-dong. ");
INSERT INTO bsj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Lan nye? ban kaa dor bero nin bati ka? ki bi duware ce. Wori kweri bo tom Yahudawa kange Helinawa gwam ce ki yimbo mor bwirang kere. ");
INSERT INTO bsj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nawo mulangeu nii cak-cake mani, mani wiin wo. ");
INSERT INTO bsj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kange nii yomka mani. Kange nii do Kwama tiye mani. ");
INSERT INTO bsj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ciin tiyangum nure gwam ciye. Gwam ciye ciin yilarangum cii man ki nangen, kange nii mani wo madike dong-dongeu, mani wiin wo. ");
INSERT INTO bsj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Miya ciko na tuwe wumom wume, biyenti ceu ka biboler, mwan nyinonger nacuwek kino nyici. ");
INSERT INTO bsj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Biyen ciro diim ki cwilka kange tweika. ");
INSERT INTO bsj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Na ni ceu ki wulom fiye corka bwiyalek ");
INSERT INTO bsj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Nure ceu dotange kange kayaka. ");
INSERT INTO bsj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nubo buro ynombo nur fuwor nerer. ");
INSERT INTO bsj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Tai Kwama mani nuwe ciye. ");
INSERT INTO bsj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","La na weu ban nyumom dikero bolangka tokeu, bolangko ki tok ker kange nubo buro mor bolange keu. ");
INSERT INTO bsj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Wori kange mania fiya cerka ti kabum cer ki nangen bolangek, nuwe ce. La mor bolangek, cin bou ki nyomka bwirangke. ");
INSERT INTO bsj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Na weu kebo kange werfunr, cin nung nyomka cak-ake Kwama. Wuro werfunero kange nob dukumembo warker ti dorcereu. ");
INSERT INTO bsj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Cak-cake Kwama fiye bilenker mor Yecu Almasiya ki nobo wo ne bilenke. Wori cwika dorek man. ");
INSERT INTO bsj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Nobo gwam ma bwirangke la cii fwe ki fiye cak-cake Kwama wiye, ");
INSERT INTO bsj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","La ciin fiya cokka ki luma ca mor fanka ko wo Almasiya Yecu nine. ");
INSERT INTO bsj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","La Kwama neken Yecu Almasiya twika nuwange ko ficangeu ki bilenke mor bwiyale ce. Can neken Almasiya na nung cokka cek, wori ci ciyabo kange bwiranke be wo bwiyeu ");
INSERT INTO bsj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","mor birom nere ceu. Buro mani nyo nung cak-cake ceu, mor kale naweu. Naco nung dorcero cin warke, naco nungi co nii cerka nubeko ki bilenker mor Yecu. ");
INSERT INTO bsj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Lan fe kungka doreko? cin cokum co. Ki ye bwiye? kin nangen ka? o-ong, la kan ker bilenkerer. ");
INSERT INTO bsj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Lan co wo nyo takti nyoki nii fiya cerka mor bilenkerer kebo ki nangen werfuner. ");
INSERT INTO bsj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Kaka Kwama ka Kwama Yahudawa ki kwa ciye ka? La ci kebo Kwama nubo kumtacili kena? ong, ki nubo kumta cili ken. ");
INSERT INTO bsj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","No bicom Kwama wiin di, can cer nii biyem te la-u ki bilenke kange wo biyebeu ki bilenker. ");
INSERT INTO bsj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Bon fulongum werfundo ki bilenkerer ka? La amare nyo! La nyeu, bi tamki werfundo. ");
INSERT INTO bsj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","La ba tok boki ye wo Ibraim, te be mor tebwiye fiya? ");
INSERT INTO bsj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","No Ibraim fiya cerka fiye nangene ri ci kin fiyam ker kungka duwek, la kebo kabum Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","La tak ye bifumro tok tiye? Ibraim ne bilenke Kwama nin, lan kiyeken cak-cake fiye ci wiye. ");
INSERT INTO bsj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Na weu nii wo ma nangen tiyeu, cuner cero mani a kiyeti na luma fiye ci wiye, la dike na ce. ");
INSERT INTO bsj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","La co wo manki nangeneu, lan ne bilenker nii wo cer no bwiran ker tiyeu, bilen ker cero kiye ken na cak-cake cinen. ");
INSERT INTO bsj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dauda tok ker bibwiyer dor nii wo Kwama kiye nii cak-cakeu, ki bwini nangene. ");
INSERT INTO bsj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","La con toki, nob bibwiyereb nobo ci tab ciinen kero bwir ciyereu, buro bwirankereciyeu cumom-cumeu. ");
INSERT INTO bsj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nii bibwiyere wo kibi duware ce Kwwama mani a kiye cinenke ce tiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","La bibwiyero tokeu ki no dor nubo biyem te la'u ki kwa ci, kaka kange cii nubo biyebo te lareu? Wori bon tok kero, “bilenker Ibraim me kiye cak-cake dor cer.” ");
INSERT INTO bsj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","La ci kiye co nyi? Ki bwiko Ibraim biyem tē lāre ce kaka co biyebo ka? Kebo mor biyeka, dila mor bwini biyeka te larek. ");
INSERT INTO bsj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibraim yo yirom biye kam bo wuro co dokka kangek bilenkere co cike fiya ca biye beu. Co bibwiyer yiromero wo, dok co ca yilam tee nubo ne bilenkereu gwam. Bwen duwal ci biyebeu. Nyori dike nungeu a kiye cinen cak-cake. ");
INSERT INTO bsj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Wori nungi con yilam tee nubo biyemeu buro kebo ka tē lā ceu biye meu dila kange nubo buro fuwaten naa ciyeti nur bilenker wo tee be Ibraim fuwau na nimre cii biyem tē lā ceu. ");
INSERT INTO bsj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Wori noro ma Ibraim min kange naniya ceko, can yilam nii kwali dor bitinero boubo werfuneronin la bou cak-cake wo wo bilenkerer mineu. ");
INSERT INTO bsj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nā nubo burona werfundo ceu nob kwalib di, bilenker manki diker, la noro dubangum. ");
INSERT INTO bsj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","La werfunero ki bom nyo ki funer, la fiye ki bwini werfunere di fuwa ka nyalek man. ");
INSERT INTO bsj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Lawo kin bilenker na noro yi dor lumar ri na bwangten naniyak Ibraimek gwam, kebo ka nubo bwangten werfun tiye, dila kange nubo buro yilam ki bilenke Ibraime. Cin Tee be gwam, ");
INSERT INTO bsj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kambo mulangum mulangeu, “min yonen na yilam tee bi tenni, kila kila”. Ibraim kino kabum nii co wo ci ciya cikeu, con Kwama, wo ne nubo bwiya meu dume tiyeu, na cwo diker maniyeu, na bou na no wi. ");
INSERT INTO bsj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Wi yak kange dike bwiti bwiyeu, Ibraim ciya kange Kwama ki bi kwan neret dor kāba cek. La con yilam tee bi tenni kila-kilau kambo yim ceu,”Nyo naniyak mweko a yila tiye.” ");
INSERT INTO bsj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Kebo ki yobka mor bilenker. Ibraim nyumom ki bwiceu dolbo bōka bwek (wori cor cero kiyang kwini kwob) kange ciraka fiye borek wice ko. ");
INSERT INTO bsj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","La ker nore Kwamaro, Ibaim tintang bo mor bwini neke bilenker, lanyeu, con ma bikwan mor bilenker la con ne Kwama duktangka. ");
INSERT INTO bsj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Co diim ki ciyaka Kwama ma cinen nor, la can di cinen. ");
INSERT INTO bsj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Lan kiye wo cak-cake cinen. ");
INSERT INTO bsj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","La kero wo kiye ci ne neu, mukang bo nace na dor ceroce ki kwāce. ");
INSERT INTO bsj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","La mulangum ki bo ken. ki nii wo a kiye cinen tiye, bo nobo ba ne bilenker ki nii wo kung Yecu Tee luwe beu bwareu. ");
INSERT INTO bsj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Won co wuro ci neken co ker bwiran kerebe, lan kung co na fang bo. ");
INSERT INTO bsj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kambo ba fiya fanka fiye Kwama wiye ki bilenke, bon fiya luma kange Tee luwebe Yecu Almaciya. ");
INSERT INTO bsj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ci nen bō ken ban fiya doka ki bilenke mor luma Kwamako wo bo tiim dor cereu, la ma kwilangka bwiyek mor yoka nereko duktanka Kwamake. ");
INSERT INTO bsj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Kebo ka wuro, dila bo ma kwilangka bwiyek ki nuwaka dotangek beko. Bo nyimom bo dotange beu atin dok bo birom nere, ");
INSERT INTO bsj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Birom nere atin bouki mulendo ken, mulendo kendo an bou ki yoka nerek ki ikero a bouti fo kabeu, ");
INSERT INTO bsj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","La yoka nereko wuro mani a nebo kwenduwe ti, wori Kwama cor binen cwika ceko mor nerebe ki yuwa tangbe Kwamako wo ci ne beu. ");
INSERT INTO bsj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","La ki fiyacuwo bo kwambeu, ki kwama dong-dongeu Kiritti bwiyam ker nubo wo man ki Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","La bwei na fiya nii wo a bwiyamti ker nii wo cak-cake, bwen duwaleu kangeri kange nii an cwi naci bwam ker nii kener. ");
INSERT INTO bsj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Dila Kwama nung cwika ceko fiye bo wiye, wori fiyaco bon nob bwirankeu Kiritti bwiyam ker ber. ");
INSERT INTO bsj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","La na weu bo fiya cire duwece ki bwiyale ce, batin fiya cerka funer Kwama ro cinen. ");
INSERT INTO bsj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Dila no fiya cwuo bin nob kiyebeu, ywellum tiber bero kange Kwama ki bwar bi bwe cero, la naweu bo fiyam ywelkangka tibere be kange ceu batin fiya cerka ki dume ceu. ");
INSERT INTO bsj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Kebo kawo, la bon bilangi tak Kwama ker Teebe Yecu Kiritti, wo ker cer bo fiya ywel kangka tiberek beko weu. ");
INSERT INTO bsj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","La, kambo nii wiin nin bwirangke dou dor bitinere, nyo bwaro dou ker bwirang ke. La bwaro yalati nubo nin gwam wori gwam ma bwirangke. ");
INSERT INTO bsj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","La nyimde bolangko dou dor biner di, bwirangke wi dor bitiner dila kiyeka bwiran kere ko mani no bolangko mani ri. ");
INSERT INTO bsj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kange wo ri duwaleu, bwaro ma liyar, terti dor Adamu nimde Muca, la kange dor buro mabo bwiran ke yabka diir nyalek nawo Adamu ce wo yilam dangke ce nii wo a bou tiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Dila luma nereko kebo na bwirangke. La no ki bwirangkee nii wiin nubo kila bwiya rangum ri, luma Kwamak duce kange nekako Kwama nebeu ki luma nii wiin, Yecu kiritti, a cuwe ki nubo ducce. ");
INSERT INTO bsj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","La numa nere ko kebo na dikero bwiranke nii wiine bou cike. Bolang bwareko bwangu bwiranke nii wiine. Dila luma nerek Kwama ko bwangu bwirangke ducce dila bouki cērka. ");
INSERT INTO bsj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","La no ki bwirangke wo wiine bwaro ma liyar kange curo wiine ri, la ayila nyi kange buro yo luma ko ducce kange luma nerek cak-cake ma liyar mor dume kange cuwo wiineu, Yecu Kiritti. ");
INSERT INTO bsj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","La kambo bwirangke nii wiin bou ki bwar dor nubero gwameu, la nyo ken nangen cak-cake nii wiineu, bou ki cer ka kange dume wo nubo gwame ce. ");
INSERT INTO bsj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","La kambo dor bwirangke nii wiineu dok nubo kila yilarangum nob bwirangkebeu, nyo ken dor ki cak-cake nii wiine ri nubo ducce atin yilam cak-cak. ");
INSERT INTO bsj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","La bolangko bou ri na cob ten bwiranke. Dila fiye bwiranke ducce ri, luma Kwama kon duce laco. ");
INSERT INTO bsj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Wo bwi nyori la kambo bwiranke ma liyar ti mor bware, la nyo luma an ma liyar dor cak-cake wo dume diri ye, mor Kiritti Teluwe be. ");
INSERT INTO bsj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ye bo tok ti na we? La ban ti maka bwiran kerekori na luma Kwama ko duwiya? ");
INSERT INTO bsj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","O-ong, mani a mati bo wo bi bwiyam ki maka bwirankeu, ba ma nyi nabi ti yimbo more ce? ");
INSERT INTO bsj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","La ko nyombo kom ki gwam wo yum mwem Kwamam mor Kiritti Yecu cin yum mwembo mor bware ca? ");
INSERT INTO bsj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ciin fwerum bo, fiya cuwo, kange co ki yuka mwengek Kwama ko mor bware. Wo bwi nyori, na yilam kambo Kiritti kwenum mor tuwe ki dume kiriti wiin ki duktanka Tee keu la boken bon yayam ki mor dume fwir ");
INSERT INTO bsj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","wori no bi yilam wiin kange co mor cerkanka bware ceko nin di, ba yilam kange co tak ki kwen ka ceko nin mor tuwe. ");
INSERT INTO bsj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Bi nyimom bo ki nii be car ko cin kulken co ri naci twalum bwiyo wo na bwiranke ce. Wo bwi nyori nabi yila canga bwirankeb. ");
INSERT INTO bsj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Nii wo bwiyameu cin yilam co nii cak-cake fiye bwiranke wiye. ");
INSERT INTO bsj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Dila no bi bwiya kange Kiritti ri, bon ne bilenke yila ban yi wari kange co tak. ");
INSERT INTO bsj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Bon nyimom boki, cin kungum Kiritti mor nubo bwiyarangume, dila naweu cin wiki dume. Bwaro mani ma liyar ti dor cer tak. ");
INSERT INTO bsj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","La ki bwaro coa bwiyam fiye bwiranke wiyeu, co bwa kiriti wiin dor nubo gwam. La yimbo co yimeu, co ki yi ker Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nyori, Kom ke neu, tam kom tu dor kumero nubo bwiyam bwiya bwiranke nin, ri kom ki dume Kwama nin mor Kiritti Yecu. ");
INSERT INTO bsj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","La nyori, kom dobre bwiranke a ma liyar dor cūren bwiye kumero nin wo a dok kom neka dilanka ceko nin dur tiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kom ne kende mwanti bwi kimero ki maka bwiranke, wo ci a yilam kwilen nangen ti wo maka dikero man cak-cake ce. Dila kom neken dor kumero Kwama nin na buro cii coku bwar di cii bou ki cii dumeu, nakom neken mwantini bwi komeu Kwama nin na kwilen nangener ro cak-cakeu. ");
INSERT INTO bsj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kom dob re bwiranke a maliyar dor kumer, wori bolanko mani dor kimer la luma Kwamak dor kumere. ");
INSERT INTO bsj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ye tak? Ban ma bwiranke wori bolanko mani dorber, di luma Kwamak dorbera? O-ong, mani a bwiti nyo. ");
INSERT INTO bsj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ko nyombo kom ki no kom neken dorkumero na cangab ri, kom cangab nii wo kom neco dur tiya? La kom cangab bwiranke wo ayati ki nii bware kaka cangab ki neka durek wo ayati ki nii cak-cake ");
INSERT INTO bsj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Dila buka kangek Kwama nin! Wori no kom cangab bwirankeb, dila kom ne dur mor nere kume nur merankako cii nekome. ");
INSERT INTO bsj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Kom fiya cerka mor bwiranke la kom yilam cangeb cak-cakeb. ");
INSERT INTO bsj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ma tok kero ti kange kom na nii wori, kom man kii kwan bwi kom. la nawo kom neken mwanti bwiyer kumero na cangab diker mani wucake, kange bwini bwanka bolangek kange maka dikero bwira bwira, nyo tak kom neken mwanti bwiyer komero na cangab dikero cak-cake wo nir kako wucake ce. ");
INSERT INTO bsj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Fiyaco kom cangab bwirankeu, cin cer kom ki cak-cake. ");
INSERT INTO bsj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ki kwama cuwo, ye kom fiya ki nangen kuro wo na weu kom nuwa kwenduwe tiye? Wori dikero kom fiya ti nangendo cuwo nineu bwar ");
INSERT INTO bsj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","La na weu kom fiya cērka mor bwiranke ri la kom yilam canga Kwamak, kom wiki dikero kom fiya ki nir ka kumeko wucakeu. Diker kom fita tiye dume diriye. ");
INSERT INTO bsj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Cuner bwiran kerero bwar, dila luma nerek Kwama ko dume diriye Kiritti Yecu Teluwe be. ");
INSERT INTO bsj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Kaka ko nyombo ka, yitub mib (miki tok kange nobo wuro nyomom werfun deu) ki, werfun ca liyar ti dor nii, ya ciko dika dume cek. ");
INSERT INTO bsj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Werfundo bwam nawiye nam nau bwece nin, no bwece ki dume ri, no bwece bwiyam ri, ciin cokum co bwaka werfuner na-ka ceko. ");
INSERT INTO bsj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","La no bwece wi ki dume ri, no co yi kange nii kange ri, a cuwo co ki, “nii burotum.” Dila no bwece bwiyam ri, ciin cokum co werfun do nin, la co kebo nawiye ma burotum tiye no co yim kange nii kangeri. ");
INSERT INTO bsj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nyori yitub mib, cin dok kom kin bwiyam mor werfune nin ken, dor bwiyer Kiritti. Nyori naci mwer kangum kom kange kange, nyori nii wo cii kungum mor nubo bwiya meu nin na kom bō Kwama nin bi bei. ");
INSERT INTO bsj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","No bi mor bwiye ri, dilanka bwiye beko wo werfundo kungu tiyeu, ma nangen ti ki mwantini bwiyer bero nin, na ci bō bwaro nin bi bei. ");
INSERT INTO bsj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Dila naweu, cin cokum kom werfundo nin. Bon bwiyam dor dikero cuwo bwam be. Wuro nyo, nabi bwang cinen ten mor yuwa tangbeko fwir, kebo mor bwite carko. ");
INSERT INTO bsj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ye ba tok ti take? werfundo ki bwici bwiranke ka? A yilare nyo, miki nyom bo bwiranke, nō kebo dor werfuner ri, nō miki nyom bo nung-nung, na kebo wo werfundo ki,” mare nung-nunge di.” ");
INSERT INTO bsj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Bwiranke fiya nure mor werfune nin, la co bou ki nung-nungo gwam minen. No werfundo mani ri, bwirang keu bwiyam. ");
INSERT INTO bsj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Fiya co mi ki dume la bolang ko man, la werfundo bou ri, bwiran ke kwenu ken, la min bwiyam. ");
INSERT INTO bsj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Werfundo wo no a bou ti ki dume, yilam bwar minen. ");
INSERT INTO bsj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Wori bwiranke fiya nure ker werfune ro nin bolye. Fiye Werfundo nin twalum ye. ");
INSERT INTO bsj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nyori bolangko wucak, werfundo wucak, cak-cak ri, yora tak. ");
INSERT INTO bsj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","La dike yilam na keneu bwar mi nen ka? Mani a mati nyo. Dila bwiranke, na nungi cin bwiran ke ki dike yorau, bou ki bwar mi nen. Wuro na nungi ki ker werfuner, bwiranke yi lam bwirankere cum bi kwane. ");
INSERT INTO bsj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","La dike ban nyumom bo ki bolanko ki yuwa tangba, dila mi na bwiye ce. Cin miyem ye bwiranke nin. ");
INSERT INTO bsj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","La dike mi matiye, ma nyombo, dike mi cwiti na maneu, mi mabo, la dike ma cwibeu cwo mi matiye. ");
INSERT INTO bsj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","dila no min ma dike ma cwibo mane ri, min ciya kange werfundo, miki werfundo yori kabo. ");
INSERT INTO bsj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","La caneu, kebo mo matiye, bwiran kere yim minene. ");
INSERT INTO bsj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Min nyimom minen, bwimi, dikero ken yibo mi ne minen. Ner maka dikero ken wi minen, la mani ma mati. ");
INSERT INTO bsj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ken ko micwitiyeu mani mi mati, dila bwirko ma cwibeu co mi matiye. ");
INSERT INTO bsj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nomin ma dike ma cwibe ri, yilam kebo mo ma matiye, la co bwiranke wo yim mi neneu. ");
INSERT INTO bsj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","La min fiya ciyakako minen wo ma cwitin ma dikero keneu, dila dikero bwir ko wi minen. ");
INSERT INTO bsj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Min ma bilangtum mor werfun Kwama kange mor nere nii. ");
INSERT INTO bsj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","La min fiya mor mwanti bwiye mik. Ci ma kiyan ti kange ciyakako fwir ko mor nere miyeu. Tamye na canga ki werfun bwiranke wo mwanti bwiyer mireu. ");
INSERT INTO bsj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Min nii dotange, we a cok yeti bwi bware we? ");
INSERT INTO bsj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mi bū kwama nin kange mor Yecu Kiritti, Tēluwe be, mo ki bwimi min bwangten werfun Kwama ki ner mir, la ki te bwiye ri mo ki bwangten werfun bwiran ke. ");
INSERT INTO bsj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nyori caneu kuwaka Mani nobody would more Kiritti Yecu. ");
INSERT INTO bsj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","wori werfun yuwa dumeko more Yecu neneu cērka dor werfuner bwiranke kange bwar. ");
INSERT INTO bsj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Dike werfundo dolbo maka wori ci man kibi kwan mor bwiyeu, Kwama mani. Con tuwomou bi bwece mor cerkangka bwiran bwiyeko ki bwiranke na yilam twika kira bwiran keret la con twalum bwaro mor bwiye. ");
INSERT INTO bsj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ca mawo na dim dike werfundo tok ti more be wuro mani a yayam ti mor bwiteu, di yati mor yuwa nere keu. ");
INSERT INTO bsj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Nubo wuro yim mor bwiyeu, yo ner ciro dor dikero na bwiye ceu, wuro ya yamti mor yuwa nere keu, yo ner ciro mor dikero na yuwa nereko ceu. ");
INSERT INTO bsj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nero wuro yom bwiyeu, bwar, la nero wuro yom yuwa nerekeu dume kange fwor nerek. ");
INSERT INTO bsj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Nero yom bwiyeu ma kiyeti kwama nin, wori mani ne durti werfun Kwamar, mani mati tak. ");
INSERT INTO bsj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Nubo wo mor bwiyeu, mani a yo Kwama nin ner ti. ");
INSERT INTO bsj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nyori, kom mani mor bwiye, kom no mor yuwa nerek, no kibi cuwom yuwa tangbe yim kimen di. La nii wo manki yuwa tangbe ko wo Kiritti ce ri, co man kange co. ");
INSERT INTO bsj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","No Kiritti yim kimen di, bwiyo bwiyam fiye bwiran keret dumeu. La yuwa Kwama ko mune neu, ki dume fiye bilen kerero wiye. ");
INSERT INTO bsj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","No yuwa Kwama ko wo kung Yecu bwareu yim munen di, co wo co kung Kiritti bwareu, an ne bwi bware kime dume fiye yuwa Kwama ko ni ne, wo yim mune neu. ");
INSERT INTO bsj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nyori kom yitub mib, boki cēn, kebo nawo bwii yeu na bo yati mor bwiye. ");
INSERT INTO bsj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","No yim mor bwiyeri, mon dadum na bwiyam, la no yim mor yuwa Kwama ri, mon twalum nangen bwiyero ri mwa bum. ");
INSERT INTO bsj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Gwam wo yuwa tangbe Kwama bwangten ti ki ciyw ri, cii be bei Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ko yuwo bo yuwa tangbe canga, wo ka yiti mor tāi take. Nyori, kom yo yuwa tangbe yila ka bi beiyek, wo ka cuwo ti,” Abba, Tēe!” ");
INSERT INTO bsj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","YUwa tangbeko ki bwici ne warke kange yuwa tangbe beko ki bon bi bei kwama. ");
INSERT INTO bsj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","No bo bi bei Kwama ri, bo nob Kwalib, nob kwalib Kwama. Takeu nob Kwalib kange Kiritti, no bo nuwa dotange kange co ri, ban fiya duktonka kange co. ");
INSERT INTO bsj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mi toti dotange wuro kale wo caneu, labo wo ba mwerkan coti kange dukton kako wo ca nung binen tiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Wori kuru yoka nerek fwelkau nintang nungka bibei Kwam ti. ");
INSERT INTO bsj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Wori cin yoken fwelkako dikero bwir, kebo ki cwika cek, la na nii wo dokken co ce. Dila yo nere wi duwal. ");
INSERT INTO bsj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","La fwileu ki bwici ciya can cokumco canga na fwiyem, la ciyan bou ki co cēr duktongka bi bei Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","La bon nyimom fwel kako gwam, ki tii nangi, ki dotange bore yau ciko duwen. ");
INSERT INTO bsj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Kebo ka cuwo, bo ki bwibi yeu, wo ter fiya ka yuwa tangbe ki ƙa bau- la bo biki bwibo tii nangi binen, bo nintang yila ka yila bi bei ye koti, cērka bwiye beko. ");
INSERT INTO bsj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Mor yo neri yo wo ba fiya fuloka. Dila yo neri ba to canneu kebo yo neri. We yo ner dike ca tobe? ");
INSERT INTO bsj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","No bo yoner dike bato bwiri ye ri, ban ningtangi ki birum neri. ");
INSERT INTO bsj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nyo tak, yuwa tangbe Kwama ko tikanbo ti mor yiber bwiyer ber, wo ba nyom bo kambo ba kwob dilo tiye, yuwa tangbe ko ki bwici, ken kini ti dor ber ki tinang kako man ki kiyeka. ");
INSERT INTO bsj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Co wuro to nero tiyeu, nyimom kwaka nerek yuwa tangbe Kwama, wo ri ci ken kini dor bi bei Kwama ro wucakke mor cwika Kwamak. ");
INSERT INTO bsj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Dila a nyimom nubo cwi kwama tiyeu, can ma cinen diker gwam wo yor-yore, ki buro ci cuwo ki cwika cekeu ");
INSERT INTO bsj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Nyori wuro ci nyimom cii wulomeu, cin dok cii nacii tū cerkanka bi Bwe ce, na co yilam Bwe kāba mor keb ceb ducce. ");
INSERT INTO bsj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Buro ci dokke, cii buro co coweu. Cii buro ca coweu, cii co cokke, nobo co cokke, cii co duktange. ");
INSERT INTO bsj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ye ba tokti tak dikero buro we? No Kwama kange bori, we a ma kiyeti kange be? ");
INSERT INTO bsj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Co wo dobbo bi bwece neken co ker ber gwam, a manyi mani a cēr boti na nebo dikero gwam me? ");
INSERT INTO bsj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","We a bou ti kiyange dor nubo Kwama coke? Kwam co nii wo ma cokka tiye. ");
INSERT INTO bsj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","We wo war ker tiye? Kiritti co nii wo bwiya ker bere. La lanyo, cin kwenum. Co wuro kangko cattiyer Kwama ke, ci ken kiniti dor ber. ");
INSERT INTO bsj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","We a yalkang bo ti ki cwika Kiritti ye? Dotange, kaka kālaka kaka wura, kaka kwancer, kaka diker taiyer kaka ƙulen ka? ");
INSERT INTO bsj_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nawo ci mulangeu, “Ker mwer cii twalang nyo kica tech. Cii tuken nyo na kwame biye ka. ");
INSERT INTO bsj_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","mor dikero wo gwam nyin la nob turanii mor nii wo cwi bo tiye. ");
INSERT INTO bsj_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Nyori min ciya mor bware, kaka dume, kaka nob tomangeb Kwama wucake, kaka liyar, kaka dikero caneu, kaka dikero a bou tiyeu, kaka bikwan neret, ");
INSERT INTO bsj_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","kaka cwemmer, kaka cuwaka, kaka dikero ci fwel-fweleu, mani ciya dolti ci tikangbo ki cwika Kwamak, wo Tē luwebe Kiritti Yecu ni neu. ");
INSERT INTO bsj_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ma tok bilenke mor Kiritti. Ma cwerbo cwerke, dume ner miro ne warke dor miir mor yuwa tangbe ko wucakke, ");
INSERT INTO bsj_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","La man wiki fir nerero dur kange buwarum ne wo man ki dika mor nere mi. ");
INSERT INTO bsj_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Man cwi na ci cilim ye ri ri naci tikangum ye kange Almaciya ker keb mib bo bwiyeu buro nyi ceru bitine wiineu. ");
INSERT INTO bsj_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Cii Icrailawa, ciin wi ki yilaka bi bei Kwamak, duktangka, nor tini, luma nere bolangek, wabka Kwamak, kange diker co ciya con macineneu. ");
INSERT INTO bsj_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Tenkwanibbo na ce wo Kiritti ceru wi ki te bwi yeu- Co wo cin Kwama dor dikero gwameu. Cak lanka nace diri. A ti nyo. ");
INSERT INTO bsj_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Dila kebo ki nor Kwama ro dii be. Kebo nubo gwam mor Icraila wo nii Icraila bilenke. ");
INSERT INTO bsj_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Kaka naniya Ibraime ko gwam bibeiyo loce ken. Dila “Na niya mweko a cuwo Icaku nen” ");
INSERT INTO bsj_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Bi beiyo tebwiye kebo bi bei Kwamab. Dila be bei nore bo cii ci tuu cii ti bi bei naniya ke. ");
INSERT INTO bsj_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Wo co noro: “ki kwama wo bilang matin bou, Caratu an bō bwe.” ");
INSERT INTO bsj_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Kebo ka wo, Rifkatu tū fwer kange nii kange wiin, tee be Icaku- ");
INSERT INTO bsj_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","la cii bō bo bi beiyo bwiri takeu cii mabo dikero ken kaka dikero bwir, na cwika Kwama ko ki cokka ceko atin dim, kebo ker nangen tini dila ker ker cer wo cuwo bi cuworeu. ");
INSERT INTO bsj_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Cin yi co ki “Durko atin yila canga bi duwareu.” ");
INSERT INTO bsj_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kin na wo cii mulangeu: “Yakubu ma cwi ye, la Icuwa ma kowe.” ");
INSERT INTO bsj_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ye ba tok tiye? bwini cak-cake wi Kwama nina? Mani nyo. ");
INSERT INTO bsj_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Con yi Muca coki,”Man nung cii duwe ki nii wo ma nung ten cii duwe tiye, ta keu man nung bwinang ka ki nii wo ma nung ten bunang ka tiye.” ");
INSERT INTO bsj_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","La kebo cwii ka niik kaka ker nii wo cwa cwake, dila ker Kwama, wo nung cii duwe. ");
INSERT INTO bsj_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","La bifumero yi Fir'auna, “Wo co diker bwi ma kung neneu, nyori nami nung bi Kwan liyare miu monen, tak ri na dor bitinero gwam nuwa den miro. ");
INSERT INTO bsj_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","La Kwama nung cii duwe dor nii co cwi ye, tak ri ciki dok bongtu ki nubo co cwiye. ");
INSERT INTO bsj_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Mon yiye moki,” Ye bwi cito bwirake ti duwale? We ma kwobkanka wi kange dike co cwi tiye?” ");
INSERT INTO bsj_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nii fir, we mo mwa kwobkang ti kange Kwama? Dike ci mu-muweu atin yi nii wo muu ceu,”Ye bwi mwa muuye nya?” ");
INSERT INTO bsj_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","La nii muu kubar tiyeu man ki bi kwan liyare dor kubaro ci lūweu naci muu tilar wo nangendo ken nece kange tilar nangener kangkang lo ki kubaro cuwo wiin ci lūwe ka? ");
INSERT INTO bsj_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nye no Kwama, wo cwiti naci nung funer cer tak ri naci nung bikwan liyare ceu, mwirumom ki biirom nere ducce dukum funero cii yo na twalangka ko ce ri? ");
INSERT INTO bsj_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","La nye, noci ma wuro nyo naci nung cuweka duktangka cek dor nubo co nungten ciire duwe, wo ki ƙaba ci ywel bwice duktangka? ");
INSERT INTO bsj_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","La ta keno ci mam dike wuro ki bo ken, wo co cuwo takeu, kebo ka Yahudawa ki kwaci, dila more nubo kumta cile ken? ");
INSERT INTO bsj_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kambo co toki tak mor Hosea: “Ma tin cuwo cii nubo lo mii, buro kebo nubo lo miyeu, kange nii co wo no kebo wo ma cwiyeu matin cuwo co nawiye ma cwitiye. ");
INSERT INTO bsj_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","La an yilam, fiye ci yicii ki, “kom kebo nubo lo mi, 'wi ci a cuwo cii ki 'bi bei Kwama ki dume.'” ");
INSERT INTO bsj_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Icaya kung diir ker Icraila, “Bwenno kila ka bi bei Icraila kino na yabum mor caji duwaleu, Cwab ce a fiya fulo tiye, ");
INSERT INTO bsj_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Wori Teeluwe atin ma warke dor bitiner, gwam mani a tab bwi ti.” ");
INSERT INTO bsj_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nawo Icaya toki ki kabau, “Na no Teeluwe nob kwene dob nyi nen bo naniyatini ri, nyoki yilam na Caduma, takeu nyoki yilam na Gwamrata.” ");
INSERT INTO bsj_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ye ba tokti kake? Ri nubo kumtaciliu, buro no tibo doka cak-cakeu, fiyam cak-cake, cak-cake fiye bilenke. ");
INSERT INTO bsj_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Dila Icrailawa, buro ti doka werfun cak-cakeu, cii fiya bo. ");
INSERT INTO bsj_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ye bwiye? Wori cii dobo ki bilenke, dila ki nangentini. Ciin kottangi ki ter kottangkar. ");
INSERT INTO bsj_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Na wo mulangum mulangeu, To, ma yo ter kottangkati kange cwela ko dok ȳare tiye Cihiyona. Nii wo ne bilenke dorcere ri, mania nuwa kwen duwe ti. ");
INSERT INTO bsj_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Keb mibbo, cwika nere miko kange kini mito Kwama nineu ki cii, ki fuloka ciyek. ");
INSERT INTO bsj_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Man ne warke dor ciyer miki ciin wiki ner bwanka Kwama, dila keo dor nyom ka. ");
INSERT INTO bsj_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Wori cii nyombo cak-cake Kwama, takeu cii do naci bouki cak-cake dor cero ceu. Ciin ko bwanka cak-cake Kwamau. ");
INSERT INTO bsj_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","La Almaciya co diika werfunero ki cak-cake ker nubo gwam wo ne bilenke. ");
INSERT INTO bsj_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","La Muca mulangi dor cak-cake wo bou fiye werfunereu: “Nii wo ma cak-cake werfuneu atin fiya dume ki cak-cake wo.” ");
INSERT INTO bsj_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Dila cak-cake wo bou fiye bilenke yiki, “Tok re mor nere mwe, 'We a kwiti dii kwama?' (la, na yirau ki Almaciya); ");
INSERT INTO bsj_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","takeu tok re mwiki,' We a yira ti mor bitine?”' (na kungu Almaciya mor nubo bwiyam bwiya), ");
INSERT INTO bsj_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","La ye ci tokke? “Kero kino bi dom kange mo, mor nyi mo, mor nere mwe.” Co ker bilenkero, wo nyo tokkeu. ");
INSERT INTO bsj_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","No mwin tokki ki nyimo moki Yecu Teluwe, ri mwi ne bilenke mor nere mwe moki Kwama kungum co mor nubo bwiyam bwaya ri, mwan fiya fulo ka. ");
INSERT INTO bsj_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Wori nii ki ne bilenke ki ner na fiya cak-cake, takeu nyi ciki tok re naci fiya fuloka. ");
INSERT INTO bsj_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","La bifumero tok ki,” Gwam nii wo ne bilenke ci ne ne ri kani a fiya kwen duwe ti.” ");
INSERT INTO bsj_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Wori nii Yahudiya man ki dimen kange nii kumtacili. Wori Kwama co Kwama nubo gwame, la ci cuwe kabo ki gwam nii wo cuwo ce nin. ");
INSERT INTO bsj_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Gwam nii wo cuwo den Teluwe ri an fiya fuloka. ");
INSERT INTO bsj_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","La cii a cuwo nii wo cii nebo bilenke ci ne ne nyi? Cii a ne bilenke nyi dor nii wo cii nuwam bo kercer wiye? Cii a nuwa nyi no nii tok ka nani ri? ");
INSERT INTO bsj_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","La cii a tok ker cer nyi no ci tuwom cii bo ri? - kambo ci mulangeu, “Yorka ki naa nube ko wo tok ker lumar ti wo dikero kendo ceu!” ");
INSERT INTO bsj_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Dila kebo gwam ciye ciya kange fulen kere. Icaya tokker, “Teluwe, we ciya kange ker nyere?” ");
INSERT INTO bsj_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Bileke ki bou nuwa ka, tak keu nuwa ki ker Almaciya. ");
INSERT INTO bsj_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","La moki, “Cii nuwa bo ka? o-ng, ciin nuwam. “Dir ciyero yake dor bitiner gwam, tak keu ker ciyero yaken cwile dor bitiner.” ");
INSERT INTO bsj_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Takeu, moki, “Icraila nyom bo ka? “ki kaba Muca yiki,”Mon dok kom kor dor buro kebo biten nobeu. Ker bitinero man ki nyomka, matin dok kom funer.” ");
INSERT INTO bsj_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","La Icaya wiki bikwan neret fiya cuwo ci tok ki, “Nubo doye beu fiyam ye. Man cerkangu ki nubo mebo nyom ka miko nin.” ");
INSERT INTO bsj_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","La dor Icraila ciki, “man tar kang miko kume del nubo wo man ki neka dur tak keu bongi nyeu nin.” ");
INSERT INTO bsj_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","La man toki, Kwam ko ko nubo loca? mani a mati nyo. Wori mõ keneu, man Ba-Icraile, naniyak Ibraimek tuwe luwe Bilyaminu. ");
INSERT INTO bsj_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Kwama kobo nubo lo ceu wo ki kaba ca nyimo meu. La kom nyombo dike bifumero toki dor Iliyare, kambo co yaki kiyane Icraila kabum Kwama meu. ");
INSERT INTO bsj_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Teeluwe, cii twalangum nob dukumeb mwebo, ciin bubam fiye wabe meu, miki kwami ma kume, la cii do dumeti. ");
INSERT INTO bsj_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","La Kwama kar cinen kiye? Min wiki nubo bi kate niber buro cung bo Ba'al nin cngeu.” ");
INSERT INTO bsj_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Kebo nyori na weu kum kangembo wi buro ma cokkeu ker cokka lumau. ");
INSERT INTO bsj_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","La naki luma, kebo ki nangen tak, na kebo nyorri luma mani a yila luma ti tak. ");
INSERT INTO bsj_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Lan ye tak? Dike Icraila do tiyeu cii fiyabo, la nubo cok-cokeu ciin fiya co, tangnumbo kwamum ner cero. ");
INSERT INTO bsj_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","La nawo mulangum mulangeu, Kwama neci yuwa tangbe bwini nyomka. nuwe tini wo la nacia tore fiye, tu'u niu wo la mani ci a nuwati, yau ciko diye wo. ");
INSERT INTO bsj_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dauda ki, “Bntilen cero ayilam biliyar, kange ciito, ayilam ter kwaka nāak kange cokka cunek. ");
INSERT INTO bsj_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","La nuwe ce a fikongum kume naci tore. tarye ceu a kuro kure diri. ");
INSERT INTO bsj_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","La man toki, cii kottang kottang naci yari ka? Diker nawo a bwire. La nyeu, yila ka bwiye ko cii yilau, yila fulokako bou nubo kumtacili nin, na dok cii maka korek. ");
INSERT INTO bsj_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","No yila ka bwiyeko cii yilam cweka dorbitiner di, la yare ciyeu cuweka nubo kumtaili yeu, la duwi ka ceko ba cuwa nyi, no ci bou takka ri? ");
INSERT INTO bsj_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Naweu maki tok kero kange kom nubo kumtaciliyeu, wori man nii tomange nubo kumtaciliyeu, maki maka bwik mor nangene miu. ");
INSERT INTO bsj_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Man mani kangeri an dok keb mibbo kor, na nyo cek kange. ");
INSERT INTO bsj_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","No koka ciyeko bouki ywelkangka dor bitinero nin di, yoka ciyeko la a yila nyi, ayila dume fiye bwaro nine. ");
INSERT INTO bsj_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","No bituttui wucak ri, nyo mimbo fuu ri kumeu, no nuti to wucak ri, nyo katini ceu ken. ");
INSERT INTO bsj_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","La no kange kangni tiyeu kangembo kiya rangum di, na kom, ƙani jeitune ken di, wo ci bwabti more ciyeu, la kom ki kwali kange ci, mor ti jeitune co. ");
INSERT INTO bsj_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kom mare bi tē nam dor kanitini nin. La no kom ma bitenam di, kebo kom ko ne niye bikwan tiye, la niye nekom bikwan tiye. ");
INSERT INTO bsj_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Mwan toki moki, “cin kim kangko nan bwab tiye mor. ");
INSERT INTO bsj_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Wuro bilenker, ki bwini bilenker ciyero cin kim cii wi kanko nin, la mo, tim ki bikwan mor bilen kerer kumebo nin, ko ture dor kumero na kange diker, la ko nuwa tai. ");
INSERT INTO bsj_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Lano Kwama dobbo kani kendo ri, mani a dobkom ti. ");
INSERT INTO bsj_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ko to, nangen kange dotange Kwama wo ki dimeneu, ki kangko wineu tak, dotangeu ki bou dor Yahudawa buro yaru meu. La ki kangko wineu, cini Kwama bou monen, no ko ca kaba mor luma ce ri. La no mo kori, an tom nen. ");
INSERT INTO bsj_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","La nyo, na cii yi bo mor bwini bilenker ciyero ri, a yila ken ki cii bwi tini. Wori Kwama an yila ken kici tak. ");
INSERT INTO bsj_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","No cin mwatu nen jigindo wo kiye nin, ri cin mwer kang nen kange tii jigindo luwe ri, la a ma nyi na Yahudawa wo cii kani kwattiyeu, a yilauti ki cii tak mor tii jigin ciyere? ");
INSERT INTO bsj_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Keb mibbo, ma cwibo kom yi mor kumtacili, dor yur kero wuro, kati yilo ki yilam ki yulan mor nere kime. Yur kere wo co kwamka duwek ko kebo nawo diriyeu mani Icraila, nimde nubo kumtacili ou more ce. ");
INSERT INTO bsj_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nyo Icraila gwam ciyan fiya fuloka, nawo mulangum mulangeu: “Mor ciyona nii cēr kako an ceru. Can an nyinangum bwini cak-cakeu Yakubu nin, ");
INSERT INTO bsj_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Wo an yilam nor mir kange cii kambo ma tum bwiran ker ciyereu. ");
INSERT INTO bsj_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Cunga ko kange, ker fulen kerero, cii nob kiyeb nyi kom. Ki cungako kange ki cok ka Kwamak, nubo ca cwi cwiye ker teb ciyeb. ");
INSERT INTO bsj_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Wori nēka Kwamak, kange bi cor Kwama, mani fulonger. ");
INSERT INTO bsj_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","La kom ken no mani kom ne Kwama dur, la naweu, kom fiya cire duwe ker bwini neka durek ciyek. ");
INSERT INTO bsj_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ki nure wo tak keu, Yahudawa buro mani ne dur. Ki cire duwe ci nung kumeneu, naweu nacii yo cire duwe ken. ");
INSERT INTO bsj_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Wori Kwama nungum nubo gwam mor bwini neka durek, na ci nung cire duwe dor nubo gwam. ");
INSERT INTO bsj_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Cuwaka cuweka yilen kange nyoka Kwama! Warka bolangek ceko cum bi kwan fuwaka, nure ce cum kabum nyomkam. ");
INSERT INTO bsj_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","We nyumom dike co kwati nercere kaka we yilam nii kiye kerti kange ce? ");
INSERT INTO bsj_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Kaka we ter neka kwamak dike kange, wo tam nyo Kwama yāa co nan do ce?” ");
INSERT INTO bsj_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","La fiye co wiye kange morce, dikero gwam ceruwe na yilaken cinen. Cinen duktangka diri. Ati nyo. ");
INSERT INTO bsj_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Mi ken kom yi kebmibbo, ki cire duwe Kwama, ko neken bwikimeu na twika nuwange dumek, wucak, diker ciyaka Kwama nin. Wuro co nangen kumero yoryore. ");
INSERT INTO bsj_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Kom bwangten de kale wuro, dila kom fulongum ki bwangka ner kume ro fwir ko. Ko mawuro na kom nyimom ye yora, diker yokar kange yoryore wo Kwama ciya cikeu. ");
INSERT INTO bsj_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Ki lima nereko wo ci neyereu, mi yi kom ti, kange a tūu re dor cero a cure bi kwan, nyori, bi kwarum nere kumeu a yilam ki yilen, dong-dong nawo Kwama ne bo bilenke ki dimeneu. ");
INSERT INTO bsj_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Bon wiki mwantini ducce mor bwiye wiin, la kebo mwantini ro gwam ma nangenti ka wangko ce. ");
INSERT INTO bsj_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nyo takeu, bo wo bi kila nyeu bi bwiyo wiin mor Kiritti, la bon mwantini keb-bebeb ki winti-wintiye. ");
INSERT INTO bsj_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Boki nē kako ki dimen dong-dong kange lumako ci nebeu. No nēka niik ker dukumer ri, ca mani na dong-dong bilenke ci cikeu. ");
INSERT INTO bsj_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","No nē ka niik na nangene ceri, ca mani. No na merang kako ceri, ca merangi. ");
INSERT INTO bsj_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","No na bika nereko ce ri, ka ma birom neti. No na luma nereko ce ri, ca ne nero wiin. No na bwangka ka ce kange nob ri, mani ki ɓati, No na nungka bunangka ri, bunangi ki nero bilangtum. ");
INSERT INTO bsj_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Nyori cwi kako a yila re toka nuweko ce. Kom ko dikero yilam na bwireu, ko tam dikero yilam na keneu. ");
INSERT INTO bsj_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Dor cwika keb-bebeb, Ko cwi buti kime nure dateneu. Dor neka durek, ki ne buti kime dur. ");
INSERT INTO bsj_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Dor kor neret, ki mare bwi maka. Dor yuwa tangbe Kwama, ki yalam ki kuru. Dor Teluwe, kom bwangten co. ");
INSERT INTO bsj_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Ko bilangi mor yōneri ko cikeu, ko mwirumom mor dotange kime, kom ti kwobka dilo. ");
INSERT INTO bsj_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Kom tikan nob Kwama bo wuccake man ki dikereu. Kom do nure kila-kila wo ka yilam ti ki tikaliyeu. ");
INSERT INTO bsj_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Kom yo nubo nekom dotange tiye nin bibwiyer; kom ne bi bwiyer, kom cil de nii. ");
INSERT INTO bsj_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bilangi kange nubo bilang tiyeu, ki ciwiye kange nubo ciwiye tiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ki yilam ki nero wiin bwiti kimi. Ki yilare ki kunka duwe, nyori, kom yo nubo ki lomjome, Ko yila re ki yile mor kwa neri kume ni. ");
INSERT INTO bsj_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ki yare cuner dikero bwir. Kom ma dikero ken nuwe nobe gwam. ");
INSERT INTO bsj_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","No an mani ri, kom yi kwamer kange nubo gwam. ");
INSERT INTO bsj_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ki ya re dor kimero nin cuner, dila ko dob funer Kwamaro nin. Wori mulangum-mulange, '“Cunero ki mo; Matin yām,' nuwa Teluwe.” ");
INSERT INTO bsj_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","“La no nii kiye kime nuwa wura tiri, cam ki co. No ci nuwa dilo mwe tiri, neco mwem na nom. No kom ma wuro tiri, kan yo cinen kor kiret dorcir.” ");
INSERT INTO bsj_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Dikero bwir ko a la kom re, la ko la-m dikero bwirko ki dikero ken. ");
INSERT INTO bsj_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Be gwam kume kob ne nob liyare ki bi kwan kere be dur, wori bikwan kerebe kange mani no boubo Kwama nin ri. Nob bikwan kereb bo foweu, Kwama yo ciye. ");
INSERT INTO bsj_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Nyori nii wo kwobkangi kange nob bikwan kere ri, ci ma kwobkangka kange werfun Kwama; La nob kwob kangka kowo atin yo warke dorcir. ");
INSERT INTO bsj_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Nyori, nob liyarebbo kebo diker cwaka ki nubo ma dikero kentiye nin. La nubo ma dikero bwir tiyeu cwa citi. Mo cwiti na kom cware nii wo do liyare? Kom ma dikero yora, la mon nyo ciyaka ceko. ");
INSERT INTO bsj_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Wori cin canga Kwama fiye mo wiye ker bilenker. Dila no mo ma dike yorbe ri, cwa tai; Wori ci tābo kulen do kang cek koni. Wori cin canga Kwama, nii a yaa cuner ki funer dor nii wo ma dikero bwirreu. ");
INSERT INTO bsj_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Nyori tam ne dur, kebo ka ker funere, dila ker kwa neri kimeu. ");
INSERT INTO bsj_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Co dike bwi kom yā kyemer dore ti take. Wori nob bikwan kere bo cangab Kwama, cii ma nangen do wuro ti kang-kang ");
INSERT INTO bsj_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Kom yam nubo gwam nando cii bwag kimenten tiyeu: Kyemer doret ki nubo yo kyemer doret tiyeu, kyemer cokker ki nubo dateneu, tai ki nii wo daten taiyeu, ne dur ki nii wo daten neka dureke. ");
INSERT INTO bsj_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Dikero yilam nii kange ceu a yire dor mwer no cum cwika keb mwebe ri. Wori wo cwi nii bi dom kange ceri dim bolangko. ");
INSERT INTO bsj_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Werfundo ki: “Mare burotum, twal de nii, kure kui, mare cwilangka,” no werfundo kange wi tak ri, cin mwerken cii mor kero wo; “Cwi nii bi dom kange mweu na dor mwer. ");
INSERT INTO bsj_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Cwika mani a nuwa nii bidome nin ti, nyori cwikako co diika bolangeko. ");
INSERT INTO bsj_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Nyori, kom nyumom kange kene ko, kang kenko daten ko ywiram ti dumeu kiyang dim. Wori naweu fuloka kimeko mani bidom lāwo no kom ne bilenke ki ƙabau ");
INSERT INTO bsj_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Kumeu kwitangi, ls finiu dadum celka. Nyori bo dubom nangen kumtacili ro, la bi dum kwilen kwener filangero. ");
INSERT INTO bsj_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Bo ya yambo daten neu, namwi ki kakuk, kebo mor bilengtum bo bwir kaka mor norangka dikek; Bo yare yam mor burotum kaka mor cwilanka, bo yare mor kiye kange kwobkangka. ");
INSERT INTO bsj_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","La kom yilam ki mulen Teluwe Yecu Kiritti, takeu kom yore mulen te bwiyer, kari ko bwangten mulem cero ti. ");
INSERT INTO bsj_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Kom yo nubo wo kwambo mor bilenkeu, kom mare kwarke dor kwob kangka. ");
INSERT INTO bsj_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Kange wiki bilenke co cam bwenno nyeri, la kange wo bilenke ceu kwambeu ki ca ce ka lalutini. ");
INSERT INTO bsj_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Nii wo ca rang dike gwam a kore wo mani careu; La nii wo mani carang dike gwameu a mare warke dor nii wo ro carangti gwameu. Wori Kwama ciya kange co. ");
INSERT INTO bsj_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Mon we, mo wo mo ma warke ti dor canga nii kangere? Tika ceko kange yàre ceu kino ka bum tēluwe ce. Dila atin dok c o naco tim, wori Tēluwe lam a tim ki co. ");
INSERT INTO bsj_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Kange nii duktang kakuko kange la tangnumbo. Kange ce tú kumeni gwam dong-dong. La nii a yi mor ciyaka nere ce. ");
INSERT INTO bsj_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Wo tū kakuko kange wucake, co tūm ki Teluwe, wo caa bicar tiyeu, ciki caa ker Teluwe, wori cin ne buka kange Kwama nin. Wo caa be ri, co dob cakako ker Teluwe, cin ne buka kange ken Kwama nin. ");
INSERT INTO bsj_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Wori nii kange mani wo yi yim dore ce tiye, takke, kange mani bwiya bwar ker dore ce. ");
INSERT INTO bsj_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","No bo yim ki dume ri, bo ki yi ker Teluwer, bwenno bin bwiyam ri, bo bwiya bwar ker Kwamak. La bwenno boki dume kaka bon bwiyam ri, bona Kwama ce. ");
INSERT INTO bsj_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Wo co dike bwi Almaciya bwiya. takeu, kenum ki dumetak, na co yilam Teluwe dur wo nubo bwiyam me ce kange nubo wo ki dume. ");
INSERT INTO bsj_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","La mo, ye bwi ko ma kebmwemo bo nin bolang tiye? mo keneu, ye bwi mo cwekang kemwe tiye? La gwabe be ban ti kabum kutile bolange Kwama. ");
INSERT INTO bsj_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Wori mulangum mulange, “Min werum,” nuwa Teluwe,”duwendo gwam atin cunge men, takeu, biyen do wiyak atin ne Kwama caklangka.” ");
INSERT INTO bsj_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Wori, gwam be bon tok dike ba maneu Kwama nin. ");
INSERT INTO bsj_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nyori, bi dumen to ka bwiranke keb-bebbo, dila kom ma wuro, kange be ayila re kece nin diker kottanka kaka yila kece nin cito yare. ");
INSERT INTO bsj_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Min nyimom, min ciya cuko tak Teluwe Yecu nin, dike kanke man wo kebo wucak ki bwico. La nii wo tūken dike kange ner cer ki mani wucak di, cinen dike cuwo mani wucak. ");
INSERT INTO bsj_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Tano ker carit kemwe nuwa nin luma ri, mani kom ya yamti mor cwi kanka bwiti tak. Kom twalde keb kimebo wo Almaci bwiya ker ciyereu ker bicaret. ");
INSERT INTO bsj_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Nyori dob re dike mwa to tiri na keneu ayilam diker bitoret kangem bo nin. ");
INSERT INTO bsj_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Wori liyar Kwama ro kebo dor carit kange diker nōkar, dila cak-cake, kange, dam nerem, kange fwor neret mor Yuwa tangbe ko wucakke. ");
INSERT INTO bsj_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Nii wo bwanten Kwama ki nure weri, diker yokar Kwama nin takeu, nubo ciya cuko. ");
INSERT INTO bsj_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nyori, bo bwangten diketini a bouti ki dam neremeu, kange wuro a bouti ki mūka bwiti be keu. ");
INSERT INTO bsj_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Kom kangum de nangen Kwama ro ki ker carit. Dikero gwam wucak, dila an yilam dikero bwir no nii an ca câri to a dok co yāre tiye ri. ");
INSERT INTO bsj_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Yori kabo wore nange kaka mwem inabim, kaka mare dike kange wo a dok kemwe ti mani a nuwa luma tiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Bilenke wo mo cikeu, tam co tiber mwer kange Kwama. Bi bwiyer ki nii wo ner cero kuwa cobo ki dikero co ciya cike. ");
INSERT INTO bsj_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Nii wo ner cero yob-yob dor diker di ca'u, ma bwiranke. Wori kebo ki bilenke ci cā. La dike kebo bilenke ceu bwiranke. ");
INSERT INTO bsj_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Naweu bo biki bikwaneu daten bi cii bwini kebbebo buro kwam beu, yorbo bi nung cwika durek. ");
INSERT INTO bsj_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Bi fuwo nubo bi dom kange be nin ner ki dikero ken, na mum co. ");
INSERT INTO bsj_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Wori Almaciya ki bwico cwibo dorcer. Nawo ci mulangeu,” Bitor nubero tō neneu yilau dormiir.” ");
INSERT INTO bsj_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Wori dike kweri cii mulangi ki kābau ci mulangi naci kwob tūbe, mor birom nere kange dangne wo bifumero nebo tiyeu bon yilam ki bikwan. ");
INSERT INTO bsj_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Naweu, Kwama wo ki birom nere, kange dangneu a nekom nero wiin wo yimbo wariye ce kange keb kimebo kam Kiritti Yecu. ");
INSERT INTO bsj_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ca ma wuro ri nakom caklange Kwama kange Tee Teluwebe Yecu Kiritti ki nero wiin. ");
INSERT INTO bsj_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nyori kom yo bwiti kime, nawo Kiritti yo kom neke, ki caklangka Kwamak. ");
INSERT INTO bsj_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Wori man yi miki Kiritti yilam canga biyeka tê larek nyi bilenke Kwama, co mawuro na dim noro ci ne teb-be ");
INSERT INTO bsj_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","kange nubo kumtacili naci duktang Kwama ker cire duwe ceu. Kino nawo mulangum-mulangeu, “Naweu matin ne nen caklangka mor nubo yim kumtacile takeu man ƙa nuwe caklangka den mwerek. ");
INSERT INTO bsj_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Cin toki tak, “Kom ma fuwor nerer kom nubo kumtacile gwam, kange nubo loce.” ");
INSERT INTO bsj_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","La tak ri, “Caklang Kwama, kom nubo kumtacile gwam; nubo gwam a caklang co.” ");
INSERT INTO bsj_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Takkeu, Icaiah yiki, “Nii kwali Yesse atin cerkangu, kange wuro a kwenti na ma liyar dor nubo kumtacile. Nubo kumtaciliu an fiya bi kwan nerer ci nen.” ");
INSERT INTO bsj_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Naweu Kwama nii ne bikwan nerer tiyeu a dim kom ki fuwor nerer ducce, kange dam nerem, di na bikwan nerero dim kom fiye bikwan yuwa tangbe ko wucakke. ");
INSERT INTO bsj_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Mo miki bwimi mon ciya kange kom, keb mibbo. Min ciya miki kom kom ki bwikom ko dim ki luma nerek ken, ko dim ki nyomka gwam. Min ciya miki kom lam kom ma bwiti kime nin bimwerum. ");
INSERT INTO bsj_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Dila ma mulang kimen ti kibi kwan neret dor dikero kangem nami kulom kimen tak, ker luma ko wo Kwama neye reu. ");
INSERT INTO bsj_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Luma nereko wo ci neyeri nami yilam canga Kiritti Yecu twòmi mor nubo kumtacile. Nami neci fulen ker Kwama ro na nii wābe. Nami ma wuro di na neka nubo kumtaciliko fiya yoka, wucak Yuwa tangbeko wucakke nin. ");
INSERT INTO bsj_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Luma miko kino Kiritti Yecu nin kange dor dike yilam Kwama ceu. ");
INSERT INTO bsj_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Wori mani ma tok dike kangeti no kebo dike Kiritti māni kang mik ki neka durêk nubo kumtacile ri. Buro co diketini cii maneki ker kange makakeu, ");
INSERT INTO bsj_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Ki bi Kwan yiromer kange diker nyimangkar, kange bi kwan Yuwa tangbeko wucakke. Wo yilam nyo tabti Urucalima, yaken cungako Ilirikum, mon ma nangen fulen keret Kiritti. ");
INSERT INTO bsj_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ki nure wo, dike ma tu mor nere miyeu tokka fulen kerer, dila kebo fiye cii nyimom Kiritti ki deneu, kari yilo ter muuka fiye kange nii yom kwareu. ");
INSERT INTO bsj_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kino nawo mulangum-mulangeu: “Buro ci yim cibo fulen kerer cero wiyeu an to co, kange buro nuwa beu, atin nyimom.” ");
INSERT INTO bsj_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","La ciin yamye bou kako kimeneu kiriti kila-kila. ");
INSERT INTO bsj_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","La naweu, mi man ki fiye kange yāre buro nin, mor cotito ducce mi cwiti nami bou kimen. ");
INSERT INTO bsj_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Mayo ner toka kimek ti, bwen fiya ma cuti nami ya Acbaniya ri na kom yo ye nure, bwiko ma nuwa luma yimeko kange kom bi duwareu. ");
INSERT INTO bsj_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","La naweu yam mi Urucalima nami ma nob bilenkere bo nin nangen. ");
INSERT INTO bsj_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Wori lumang ner nubo Makidoniya kange buro Akaya, naci mwerkang diker tikalir na ne nob fuwabbo more nubo ne bilenke Urucalimau. ");
INSERT INTO bsj_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ōng, luma nere ciyek, takkeu, kibi com, ciiki no na nod ceneb ciyeb. Wori no nubo kumtaciliu ma wer kanka mor diker yuwa tangbe ciyeko nin di, dāten ciken ciya tikang cii ki kwilen titi keen. ");
INSERT INTO bsj_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","No ndim nangendo wo ri, takkeu, no cii yom kwilendo nubo mwerange ri, man cu Acbaniya nami yarum kom nure. ");
INSERT INTO bsj_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Min nyimom ki kwama wo ma bou ti kimeneu, man bou mor diika bi bwiyer Kiritti. ");
INSERT INTO bsj_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Naweu, mi ken kom ti, Kebmibbo, ker Teluwe be Yecu Kiritti, kange cwika ko tangbeko ki nereu, kom tii kange mo mor dilo kime Kwama nin dor mir. ");
INSERT INTO bsj_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Kom kwob dilo nami fiya cerka kang nubo buro ma kiye ti kange bilenke mor Yahudiyau, tak ri na nangen miro dor Urucalima fiya yoka nubo ne bilenke nin. ");
INSERT INTO bsj_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Kom kwob dilo nami fiya bo ka kimen mor fuwor nerer ki ciyaka Kwamak, takkeu namo, kange kom fiya fobka. ");
INSERT INTO bsj_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Kwama nii wo ne luma nerk tiyeu ayi wari kange kom gwam. ");
INSERT INTO bsj_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Min caklang Fibi korya nye kimen, cin canga bikur wābero mor Kankiriya, ");
INSERT INTO bsj_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","na kom yo co mor Kwama. Kom ma wuro ki nure daten wo nob neka bilenkere ce, kom ti kange co, mor dikero ca do kom tiye nin. Wori co ciki bwici yilam nii tikali nube ducce, ki mo ce ken. ");
INSERT INTO bsj_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kom yarum Bilki kange Akila, nob nangeneb kange mo mor Kiritti Yecu. ");
INSERT INTO bsj_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Buro neken dume ce ker dume mireu. Ma bucinen kang ti, dila kebo ka mo, la kange mwer kangka nob Kwama ko wo nubo kumtacili ceu. ");
INSERT INTO bsj_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ko yarum nob Kwama bo wo lociyeu. Yarum Abainitas nii mi cwi tiyeu, wuro yilam co nii ter neka bilenke Kiritti nin Asiya. ");
INSERT INTO bsj_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Ko yarum Maryamu, wo manangen kibi kwan ker kimereu. ");
INSERT INTO bsj_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Kom yarum Andranikus, kange Yuniyas, kebmibbo, kange farum fucina mik. Ciin nubo ko nyumangum cii nyumange mor nob tomangeb, buro nyimangum ten Kiritti mineneu. ");
INSERT INTO bsj_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ko yarum Amfiliyas, wo ma cwi mor Teluwe. ");
INSERT INTO bsj_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Ko yarum Urbanas, far nangene mi mor Kiritti, kange Istakis, nii ma cwiyeu. ");
INSERT INTO bsj_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Ko yarum ten Abalis, nii ken mor Kiritti. Ko yaru buro mor luwe Aristobulus ce. ");
INSERT INTO bsj_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ko yarum Hirudiyan, kemi. Ko yarum nubo lo Narkiss, buro Teluwe nine. ");
INSERT INTO bsj_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ko yarum Tarafina kange Tarafusa, buro manangen kibi kwan neret Kwama nineu. Ko yarum Barsisa nawiye ken, wo manangen do ducce Kwama nine. ");
INSERT INTO bsj_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ko yarum Rufus, wuro Kwama cokkeu, kange nee ce kange wo miu. ");
INSERT INTO bsj_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ko yarum Asinkiritas, Filiguna, Hamisa, Baturabas, Hamas, kange keb-bebbo buro kange ciyeu. ");
INSERT INTO bsj_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ko yarum, Filulugusa, kange Yuliya, Niriyas kange korya ceu, kange Ulumfas, kange nob Kwama buro wari kange ciyeu. ");
INSERT INTO bsj_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ko yarum bwiti kimeu ki kor-kang kako wucakke. Mwer kangka nob Kwama ko gwam yarum kom ti. ");
INSERT INTO bsj_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Naweu mi ken komti, keb-mibbo, na kom kwa nubo buro bouti ki yalkangka kange kottangkau ki ner. Cii tou dikero cum bikwan dike kom merange ti. Kom yila bwim cinen. ");
INSERT INTO bsj_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Wori wang nobeko buro mani cii bwang ten Teluwe be Yeecu Kiritti ti, la mor fwiye ciye. Ki luma nyiye ceko cii bolang nubo ki lom jome duwe ti. ");
INSERT INTO bsj_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Wori dangke neka dure kimeko lam fiye gwam. Min ma bilangtum, dor kimer, dila ma cwiti na kom yilam ki yilen dor dikero yilam na kenneu, kange wucakke ki dikero yilam na bwireu. ");
INSERT INTO bsj_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Kwama wo ne fuwor nerer tiyeu an dok kom nako fuwarangum bwekel-keleu wulom mor na kimek. Luma Teluwe be Yecu Kiritti ati kange kom. ");
INSERT INTO bsj_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti, far nangene mi, yarum kom ti, kange Lukiyas, kange Yason, kange Susibataras, keb mibbo. ");
INSERT INTO bsj_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Mo Tartiyas nii wo mulang bifumero weu, ma yarum kom ti Kwama nin. ");
INSERT INTO bsj_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus nii ciyerka miik kange nob Kwama bo gwam, yarum kom ti. Arastas wo co tinger yoka cinan loro ceu, yarum komti kange ke nye Kawartas, cii yarum kom ti. ");
INSERT INTO bsj_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Luma Teluwe be Yecu Kiritti ati kange kom gwam. Ati nyo. ");
INSERT INTO bsj_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Naweu duktangka nace wo lami na dok kom tim nawo fulen kere miro kange fulen ker Yecu Kiritti, Wo ker nung ka dukumeko wo no kwitangi yurangum-yurangeu, ");
INSERT INTO bsj_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Dila naweu cin wumom, ki mulangka nob tomangeb dukume ko cin yi ber biten tini gwam, ki tokka Kwama diriyeu, ker bwangka bilenker. ");
INSERT INTO bsj_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ki Kwama wiin cwar ki yileneu, fiye Yecu Kiritti wiye, duktangka bak-ni-bak. Ati nyo. ");
INSERT INTO bsj_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Bulus Kwama cho che na ci yilam bwetomange ki chiyaka kwama kange yibe Sosthenes. ");
INSERT INTO bsj_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Fiye nob bwangka kwamako wiye mor Korontiya buro fiya chobka Kiristi Yesu ninneu kange burombo bi cho ki nubo wuchak gwam kange burombo fiye tinin wo chi choti ki den Kiristi Yesu wo yilam Teluwe che kange bou. ");
INSERT INTO bsj_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Nyo fwor nenert kange luma nakume fiye kwama tebe kange tehluwebe Yesu Kiristi. ");
INSERT INTO bsj_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Kang kang mi ne kwama buka kangeti dor kumer kange luma wo Kiristi Yesu ne kommeu. ");
INSERT INTO bsj_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Chon dokkom, kom yilam nub chweka mor fiye gwam, kange mor kere kange nyomanka diker gwam. ");
INSERT INTO bsj_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","nyo nawo tokki dur Kiristi yilam ki bichom bilenkeh more kume. ");
INSERT INTO bsj_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Tano nyori buni neka yuwa tangbeko wuchak kumeneu, kwakkombo nawo kom chen yilaka tehbe Yesu almasiyatie. ");
INSERT INTO bsj_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","La nyori cham chukkom na kom ne bilenke yila na kom tim ki dika kale. Na kom yilam nubo man ki di tor bini cheu ki kakuk bouka tebe Yesu ");
INSERT INTO bsj_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Kwama nii bilenke, wo cho kom mwor mwarkakka bi bweche Yesu Kiristi Teluwe be. ");
INSERT INTO bsj_vpl VALUES ("C11_10","076_1_10","1CO","1","10","11","Naweu mi kenkomti kebmi mwor den Yesu Kiristi wo gwam kume kom chiya chikeu nyo yaklangka dure a fiyare kumen min kenkomti kom mwer dur kume dume ner kumero a yilam win. ki dikero kom kwatiye. lo kulowi bou ki ker kume ki yalkangka dure wi mure kume. ");
INSERT INTO bsj_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Miki yi kange kume yiti ki mi na Bulus cheche kange ki mina Afolos che che, kange ken ki mina Kefas che che kakka mina Alamsiya che. ");
INSERT INTO bsj_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Almasiya yalkang nyika? chin kul Bulus ker kumerka? kakka chi yu kumen mwembo ki den Bulus che ka? ");
INSERT INTO bsj_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Min bukang kwama ma yubo kange kumenin mwem la Istifanus kange Gayus. ");
INSERT INTO bsj_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Mi ma wo Katti kange yiki chi yu chinen mwembo mwor den mir. ");
INSERT INTO bsj_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Min yu mwor luwe Istifanus chenin mwem kebo nyori ma nyombo keno min yu kange nin mwem di. ");
INSERT INTO bsj_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Nyo Almasiya tomyebo nan yu kumen mwem dila nan yi kom fulen keret be tomyebo na tok fulen kere ki nyomka bi bwe nifirek. La nyori katti kulka Almasiyako le liyar Bikwaner chero. ");
INSERT INTO bsj_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Dila nyori fulen kulka bwatiyeko kulum fiye nubo bwiyarangum me. La mwor brombo kwama cherchiye bikwan kwamar. ");
INSERT INTO bsj_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Nyo mulangum -mulange matan chitang nyomka nob nyomkawi man wom nyomka chiko, chi nob nyomkabo. ");
INSERT INTO bsj_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ni Nyomka ki nofe? ni merangka ki nofe? ni bokake ki nofe? wo kale wo ninen. Kwama yilabo nyomka kalekowo na yilare kulendo che. ");
INSERT INTO bsj_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","No nyori kalewo mwor nyomka cheko nyombo kwama. La cho nyom kwama fiye kulen keret na cher nubo ne bilenkereu. ");
INSERT INTO bsj_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Nyori Yahudawa ki do diker nyimangka Helenawa ki do diker nyomka. ");
INSERT INTO bsj_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","La nyori nyo ki tok fulen keret Almasiya wo chi kulken bwatiye bware. Ter kottangka fiye Yahudawa wiye lan kulen fiye Helenawawiye. ");
INSERT INTO bsj_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","La brombo kwama chowe yahudawa kange helenawa nyo ki tok ker almasiya ki bi kwan nyomka kwama. ");
INSERT INTO bsj_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kulen kwama ro la nyomka bibwe nifire kange buni bikwan kwamar la nifir ki bi kwan. ");
INSERT INTO bsj_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Kom to Bichor kumero kebmibo, ke bo gwam kume ki nyomka mor nube, ke gwam kume wi ki bikwan liyare, kebo gwam kume chi bou na cha liyare. ");
INSERT INTO bsj_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","La nyo kwama chok dike yorbe fou kalewo, na ne nob nyomka kwenduwe kwama chok dike wo man ki kwanne fou kaleweu. ");
INSERT INTO bsj_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Kwama chok dike bwiranye kange chinekangume fou kale wo chok dike chi tu kebo dikereu na cho chwikangum dike chiyi na kenne. ");
INSERT INTO bsj_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Cho maworo katti kange fiya kung dur chero kabum chem. ");
INSERT INTO bsj_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","La diker kwama ma nawonnyeu koom ki no mor almasiya Yesu wo yilam benen nyomka fiye kwama wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Yilam nawo bifumero tokke, di nuwo chuk dor chertiye cha chuk dor chero mor Teh be ");
INSERT INTO bsj_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ki kwama ma bou kumeneu kebmibo ma bouki nyomka ker kakka yulan nyomka nawo ma fwetangum dike yurangum dor kwamare. Nawo ma tok ker do kwamareu. ");
INSERT INTO bsj_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Dike bwiyeu min tum fou ner mir na nyomre diker ki kwama Yesu Almasiya wo chi kuli dor bwatiye bwareu. ");
INSERT INTO bsj_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Mi wari kange kom mor kambo tai kange yarka ne duche. ");
INSERT INTO bsj_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Dila tomangemi kange ker miro chi mani wari kange ker nyomkaro wo tu dume ter tiyeu. tano nyori, chin bouki fwetangka yuwa tangbeko kange bikwan liyaret. ");
INSERT INTO bsj_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Tano nyori bilenker kume ayilam de yulan nyomaka nubek la mor bikwan liyare kwama. ");
INSERT INTO bsj_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Nawo nyeu bou kin tokker nyomka yulaner fiye nubo tim yora, la kebo nyomka yulane kalewo kakka kebo nub liyar kalewo brombo chuken tiye. ");
INSERT INTO bsj_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","No nyori bou ki tok nyomka kwama mor bilenker wo yurangum mani ki duktangka kallowe. ");
INSERT INTO bsj_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Kange nii liyar mani wo kallowo nyimom nyomka yulanero wo, na ki chin nyimom ki kwama chori no chi kulbo tehluwe duktangka. ");
INSERT INTO bsj_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","na wuro mulangum diker kange mani wu nuwe to weh tuwo kange nuwa bo, nero kange mani kwabe dike wuro kwama ywel nubo wuro chwi cho tiye. ");
INSERT INTO bsj_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","wuro cho dike yuwatangbe kwama fwetang nubo chwi cho tiye. La yuwatangbeko fiu diker gwam wo chuwa kwama maneh. ");
INSERT INTO bsj_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","La we nyiwo kwaka bibwe nifire? lan cho yuwatangbeko yim mor dume nere che? Lan yuwatangbe kwama. ");
INSERT INTO bsj_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Nyor yobo yuwa tangbe kale, Lan yuwa tangbe ko bou fiye kwama wiye la na bi nyimom dikero nebo koniyeu. ");
INSERT INTO bsj_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nyo ki tok ker dor diker yulando wo nifir mani a nyom tiye, Lan cho dike wo yuwa tangbeko merang nyineneu. kange yulan nyomka cheko. ");
INSERT INTO bsj_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Nii wo mani ki nyomka bifumer kwamake mani nyom dike wuro kebo yuwatangbek kwamake. Dila yilam kulen chinen mani cha nyom chiti dike bwiyeu yuwa tang be kwama a fwetang tiye. ");
INSERT INTO bsj_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Cho nii wo ki nyomka kwamake cho kinwar bolang dor diker gwam. Lan cho mani mor bolang tangnum nubem. ");
INSERT INTO bsj_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","We nyimom mor nere teh re. La cha ma Liyar dor chere? La nye nyon wiki ner nawo Almasiya che. ");
INSERT INTO bsj_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Kebmibo ma nyombo tonka ke na nubo wo ki ker kwamare. Dila na nubo wo nyombo kere na bi bai yo fiyer mor almasiya. ");
INSERT INTO bsj_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ma nekom mwem yirem kebo nage dila kom labo woka nage nawo kom labe. ");
INSERT INTO bsj_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Na wo nyo kom nobbwiyeb ta no kurom kange komkangkang tiber kumer no nyori kom kebo nobbwireb chano kom yaken tii dor chuka no bek. ");
INSERT INTO bsj_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","no chano kange yiki mi no bwokob Bulus mi ki no bwikob Afolos chano nyori keb yim nii firem kom yitiyeka. ");
INSERT INTO bsj_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","La we Afolos kaka we Bulus chi changa wo kom ne bilenke fiye chinen. Gwamchiye kwama nechi nagen ne. ");
INSERT INTO bsj_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Miu fiye. Afolos ne mwem kwama tiki dwiyom me. ");
INSERT INTO bsj_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","La kange nii fiye kange nii neka mwemek kebo diker. La gwam dike dwiyom me. ");
INSERT INTO bsj_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","kange nii fiye kwnag nii neka mwemek gwam chi win. Gwam chiye yo luma nagen da cho mane. ");
INSERT INTO bsj_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Yori bou farum nangen kwama kom take kwama muka kwama tok. ");
INSERT INTO bsj_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","La luma neneng kwama neye liyar nii yomka muka ma kwar kange nii yoti muka wi la yori ki win ti winti nubo chi ya bii kambo yo mukakko. ");
INSERT INTO bsj_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","kange man wou a kul kwarti ki dime ne kange wo kwari kulum me la yeesu almasiya. ");
INSERT INTO bsj_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","nawe nyo kange kunti muka kwar do yori kakka ter waki wakerer kakka tero yori nye kakka bwatiye kakka yerang ka. ");
INSERT INTO bsj_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","nagen chero yilam yanglang ki kakuko cho anto wom chi ata nung cho mor kira ko ata nang yorka nagenek chin ki dimen ki dimen mane. ");
INSERT INTO bsj_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","no wo nagen chero timfrinati yo luma nagen chero. ");
INSERT INTO bsj_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Chano gwam yo nagen mwero twimo mwan lem luma la cho ki bwichi chan fiya chera dila tamwi tiber kerek. ");
INSERT INTO bsj_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","La kom nyombo kom ku'u kwama ka yuwa tangbe yim more kima ka? ");
INSERT INTO bsj_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","No kange kangum ku'u kwama, kwama ati kangum cho di louh kwama fiye wuchake kom ko nyo ken. ");
INSERT INTO bsj_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Be kange a bo de dor cher chano kange more kume chon nii nyomka yulanne ko wo kaldowo la cho yilam kule, wori chon yilam nii nyomka yulannek. ");
INSERT INTO bsj_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","La yomka yualannek kale ko wo kulen fiye kwama wiye wori mulangum mulange nyo. Cho ki taa nob yomka yulannek mor kulenke chiye. ");
INSERT INTO bsj_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Nyo kwama nyumom yulan maka kulenek ko. ");
INSERT INTO bsj_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Nyo kange kungka dorek man ki no ber wori dikero na kume. ");
INSERT INTO bsj_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Bwen no Bulus ko Afolos, ko Kefas, ko Kale ri, dume kange bwar dikero chanawe, dikero bwiti gwam na kume. ");
INSERT INTO bsj_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kom neken na Almasiya che, Almasiya neken na kwama che. ");
INSERT INTO bsj_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Wo cho kambo ka tunyo tiye, tami canga Almasiya kange nob taka yulan kwama. ");
INSERT INTO bsj_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Mwerum kange wuro, ciki cwi nob tomange na yilam nuboken. ");
INSERT INTO bsj_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","La fiye mi wiyeu diker biduware nakom mamen bolang, na kange ku'u bolange wuro na nuboce. Nyori mani ma, mador miro nen bolangti. ");
INSERT INTO bsj_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ma nyombo tano kange kwaneri wi dor mirdi, dila wuro mungbo na dike mi manki bwirangkerer. Kwama niwo amamen bolangtiye. ");
INSERT INTO bsj_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Nawori kom mwatire bolang na nyimde diye ce lam, na kwama yilau, an fwetangum gwam dike yurangum nangen kumtacileu, na yilo chi wubangi kwaner niri na nerece. na nimde nubo kwarub winti-winti na fiya chunenr cehro kwama nen. ");
INSERT INTO bsj_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Kebmibo, mi ki cob deije wuro wi dor mir kange Afolos ki dor kimer, kambo nyo wi nyo chungayek kang merang dikero no tokki kom kumde diker na wo mulangum me. nayilam nyo kati yilo kange tiber kimer ta fwinti ki cin la kange dor kange. ");
INSERT INTO bsj_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","nacho we wo to buni cqika tiber kumer kanhe kangem be? nye kom cike nawo kebo wo ci nekom koni ye? no koniri kom yoweri nyebwi kom kung dorti na dike kebo nye? ");
INSERT INTO bsj_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","kweri kom fiyam diker kom dotiye, kom terum nagen liyaro yilo kebo kange nyo! dong dong bilangtum mimbo nakom fiya liyar, dike bwiye nabi ma liyar warikange kom. ");
INSERT INTO bsj_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ki nung nerermi? nyo nob nangen kwma na dong dong wi tikako cuwam bwire tami na nuboburo na nawo ci mwaticinan bolang bware. chin yilam diker toka fou kalewo, fou nob tomangenin, kange niffir. ");
INSERT INTO bsj_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Bin yilam nubo mani ki yulanne nyo ki almasiya. La kom nob nyomka mwor almasiya. Nyo nob yaretinim wi, La kom nob bi kwaneb, kebo nob yarang ka. ");
INSERT INTO bsj_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Yaken na wruo yeu bika nob wurab kange dulomwe nubo manki belle wuro yoriyeu, min nuwa bibukero bwira bwirau mor luwe. ");
INSERT INTO bsj_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Dotange fiya nyo kambo ken, nyoki manang nangen ki kang yek no ci ko nyori nyo bilangci kambo ci neyo dotange di, nya mwirumbo. ");
INSERT INTO bsj_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Ta no ci kwanyo kineredi, nyo ki tok ken nungi. yon yilam, di nawo ci yilam ki nyo nob. nyimangka fou kalewo kange chinge bowo la dwitiye gwam. ");
INSERT INTO bsj_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","mi mulangbo dike buro nan dokkom kwenduwenen, wori nan makimen ywelka tami nob cwikako bibeiyo lomi. ");
INSERT INTO bsj_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Bwentano kom wi ki nib takako bikate kwob mwor almasiya, kom man ki teb ducce. dikebwieyu min yilam teh kume mwor almasiya Yesu wi wabbero nen. ");
INSERT INTO bsj_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Na weu min dubkom, kom ma namiu. ");
INSERT INTO bsj_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Cho diker bwii man twom nen Timoti bwe ma chwitiye kange ciyaka mik na bi bwenan co Teluwe na nung kumen nure kambo ma merang cinen ku wabeu. ");
INSERT INTO bsj_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Na weu kangum kumenbo yilam nob kunga dorek, ci mati tani mani ma bouti kumen. ");
INSERT INTO bsj_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Dila man bou kumen kebo wuro a kutang tiye. Na teluwe nungi nyori, na nimde kom yumom kange ker nub kung ka doreko. ");
INSERT INTO bsj_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Liyar kwama ro kebo ki tokka la ki filang. ");
INSERT INTO bsj_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Ye mon cwitiye, nbou kimen ka? ki dang ka kaka limer kaka bweldo limer. ");
INSERT INTO bsj_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Nyim nuwaki burotum wi tiber kume, twati burotumero wore chi ciyabo ciko mor nubo nyombo kwama nen. Fulen kerero minuweu incho, kange more kume dati ki wi kece. ");
INSERT INTO bsj_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Kom kundorti kambo tak! kebo firnerer daten komatiya? Co nii wo maniyeu, in tamnyo atin cokumco more kume. ");
INSERT INTO bsj_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ta bwen no mi mani kange kom mor bwiye duwaleu, dila mi wari kange kom yuwa tanbagek, kweri min warum wuro, tamnyo miki nowi. ");
INSERT INTO bsj_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ki kiini kom mwerkangi kiden Te kwama be Yesu di, Yesu tangbe miko wi wari kange kom mor Tekwama Yesu, kweri minma niiwonin bolang. ");
INSERT INTO bsj_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Mi ma nyo natin neken bwe kelkele niiwo twalum bwiyo, na yuwa tangbe ceko fulom ki dume te kwama. ");
INSERT INTO bsj_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Kung ka dorek kumeko yorbo. Ka nyombo kambo cham fuwambo nyo bi duwar ki kanghun mimbo gwam? ");
INSERT INTO bsj_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Kom nirom dor kumero wucak fiye can fuwambo wiyeu, wori nakom yilam na cwen, dila tiilita wuro mani ki ca fuwam. wori Kiristi kwame duklemu yabka beko chin twim fiang kico. ");
INSERT INTO bsj_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","La nyori dila bi more duklumebeu ki camfuwam car, cam fuwambo wuro no ki dambo bwireu. Naweu, bi ma duklume be ki Tiilita mani ki chamfuwam chari bilenkeret. ");
INSERT INTO bsj_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Min mulang kumen mor bifumer tomanger mir mi ki kom mwerkang re dor kange nubo ma kayaka tiye. ");
INSERT INTO bsj_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Kebo nubo ma kayakati dor bitiner mitok tiye, kaka nob nungumgeb, kaka nob kub, kaka nubo bwangten fulen tiye, tam katim dubom biro dorbitinenreru. ");
INSERT INTO bsj_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Dila naweu mi mulang kumenti kom mwerkan dor kange nubo yim mor kayaka, kange nung nung, kange bwanka fulenek, kange nunger, kange norangka. kom care cari kange dwam do wuro. ");
INSERT INTO bsj_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Tala ma manyi naman nubo biro mani lokwama ni bolang? La nyori ke kambo ka ma nubo wabe kwama nin bolang tiya? ");
INSERT INTO bsj_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Dila kwama manubo wuro kaleneu bolang tiye. Ko cokum nii bwirko more kume.” ");
INSERT INTO bsj_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Tano kange more kume kwabkang ti kange ri, dila labo diker cayaken kabum nob bolangeb kange yambo kabum nubo bwangten kwamatiya? kaka kanyombo nubo bwangten kwamatiye ama dor bitinerro nen bolang tiya? ");
INSERT INTO bsj_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Tano ko kama dor bitinero nen bolangtiye ri, dila kamfweki fuwakangka kereko bidumeka? ");
INSERT INTO bsj_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Ka nyomba nibo bama nob tomangeb kwamabonin bolang tiya? la ano nyo mami bama keti yim kalem bo wonin bolangtiye? ");
INSERT INTO bsj_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Tano kom ma ketito duwen kange finiyenin bolangtiri, yebwi kom yakenti ki dwan kerer fiye nubo yumbo kwama wiye? ");
INSERT INTO bsj_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Ma to wuro kom nuwa kwenduwe. kange win mani more kume wuro kiyilen a dol fuwakangka kereti tiber kumera? ");
INSERT INTO bsj_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Dila nii bwangka kwama yakenti ki kiyange kice nii bwangka kwama mubolange kabum, niiwo nyombo kwama. ");
INSERT INTO bsj_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Bwini lomkangkako noti tiber kiristareu dangi fwefwe ciko. Yebwi manikom ciya dotange tiye? Yebwi mani mwa ciya wung likatiye? ");
INSERT INTO bsj_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Komki bwikom komma nninin yorbo kom wunglichiti tak. ");
INSERT INTO bsj_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Ka nyombo nubo mani ki cakcakeu mani fiya kwali lokwamatiya? kom nere bilenke dor cwerker. kange nob kayaka, kange nubo bwnagten fulentiyeu, kange nob burokab, kange nabarubbo burotumer, kange nubo merang buroka tiye. ");
INSERT INTO bsj_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","nob kub, nung-nung, fule, buroka, nabarubo ma buroka tiyeu, nii kange mani morece afiya liyar kwamarti. ");
INSERT INTO bsj_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","kangem kumenbo kino nyo dila chin nirimkom wucak, chin neken kom kwama nen. fiye yuwa tangbe kwama beko wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Dikero gwam dong dong fiye mi wiyeu, dila kebo dikero wucake, diker nagener. Dikero gwam dong dong fiye mi wiye, dila mani maciya dike kange a cumomye tiye. ");
INSERT INTO bsj_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Carito kin morefuye, morfuye kin cariak, Dila kwama an cutang chiwigam. Chi ywelbo bwiyo nama kayaka. Dila nyori ki Tekwama an ne bwiyo diker. ");
INSERT INTO bsj_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Kwama a kung Teh mwe kange kange bo kibikwan dorek cek. ");
INSERT INTO bsj_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Ka nyom bwikumeu kutelti Almasiya? Mantu kutelti kwma ro nan mwerco kange burotuma? kwama a cukum. ");
INSERT INTO bsj_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Ka nyomba wuro murom kange burotumeri, yilam mwerum bwi kange ca? ");
INSERT INTO bsj_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Kambo bifumero tokeu, Chi yobeu chiyan knage yilam nagen win. Dila wuro mwerum kange tekwamari, cin yilam yuwa tangbe ko win ka co. ");
INSERT INTO bsj_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Ko cwam kayakako min, bwiraka kere wuyak niifir mati ki bwice, dila niifiro ma kayaka kotiyeu kima bwiranka lama bwiceu. ");
INSERT INTO bsj_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ka nyom bwikumeu yime yuwa tangbe kwamako wucake, wuro yim more kume, wuro ka fiya kwama nina? ka nyombo kom kebo na dor kumeroce? ");
INSERT INTO bsj_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Chi ten kom ki fene. La nyori, kom duktang kwama ki bwikumeu. ");
INSERT INTO bsj_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","La dor dikero wo kom mulnag meneu, “Yori kabo nii a kere nawiye.” ");
INSERT INTO bsj_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Dila ker cuwakatini dor bwiratum, daten nii a yilam ki wice ri nawiye ken a yilam ki bwece. ");
INSERT INTO bsj_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Bwayileu daten a ne wice dikero wo yilam na wice ceu nyo nawiye ama bwecenen tiye ken. ");
INSERT INTO bsj_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Na wiyeu man ki bikwan keret dor bwiceronen, la bwece cike. Nyo ken nii luweu mani ki bikwan keret dor bwicero nin. dila wice cike. ");
INSERT INTO bsj_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Kom kwak re bwiti wabkanka, no kebo wo kom ciya cuko bwiti kom nawo kumenin bi duware. kom ma wuro na kom neken dor kumero duloh. la nakom wab kangi wari tak, kati tila bwe kelkeleu cuwa komti bwini taka dorek kumeko. ");
INSERT INTO bsj_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Dila mi yikom wuro na neka yulanek kebo na werfun ni ce. ");
INSERT INTO bsj_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Man cwi nubo gwam yilam na mo. Dila kwama nerangbo luma nereko kidimen-kidimen. kange ki wang luma nereko wo kange ce wang ko wurendo. ");
INSERT INTO bsj_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Ki nubo buro nabeu kange natubo nabarub cebo bwiyameu, miki an yor cinen ciya nare na mo. ");
INSERT INTO bsj_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Dila no mani ci ya dol taka dorek tiri, ciya narangum. An la cinen diker ciya narangum kange wo kuruu a tum ci tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ki nubo wo narangumeu ma neci werfundo woti kebo mo, la Tee kwama- Na wiye a kubo kubore lo bwece. ");
INSERT INTO bsj_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Dila no cin kubo bwece nin ri, ca nare kange nii kebo nyori, ca ywel kangum tibercero kange bwece, Nii nabareu a yware wice. ");
INSERT INTO bsj_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","La ki tangnumbo miki, mo kebo Tee kwama no kange nii wi ki nawiye wo nebo bilenkeri, no nawiyeu co ciya can yim kange cori, ca ywaco re. ");
INSERT INTO bsj_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","no nawiye wiki bwece wo nebo bilenkeri no bwece co ciya can yim kange cori ca dob core. ");
INSERT INTO bsj_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","wori, Nii nabareu wo nebo bilenkeu yilam wo cii cokcokeu ker wicer, la nawiye wo nebo bilenkeu yilam wo cii cokcokeu ker bwecer. kebo nyori, bibeyo lokumeu mani a yila ti wucak. Dila kibi com ciin cokumcii coke. ");
INSERT INTO bsj_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Dila no buro bilenkeu curi, dom co a yaken ti no bwi nawori, noro wo nii nabareu teweu kaka nawiyeu, mani dor cer kwama cobo nabi yi mor fuwor neret. ");
INSERT INTO bsj_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Mwa nyom nyi, mo nawiye keno mwan ceer bwe meri? kaka mwa nyom nyi bwayile keno mwan ceer wimweri? ");
INSERT INTO bsj_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Bwenno nyiri, kambo kwama nerangbo dikeor yilam be ki dimeneu, nii a ma nangen do kambo kwama cou cew. wuro werfun miir ki bi kurwabero nin gwam. ");
INSERT INTO bsj_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Kange wi wo biyen biye lar fiya co cii cwo cou naci ne belenke? ca dore naci yilam na nii biye bo lareu. kamnge wi wo biye bo lar ki kwamawo cicwo co mor bilenke? ca biye re lar cero. ");
INSERT INTO bsj_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Biye ka larek kange bwini biyeka larek keb diker kwomkak. Dikero dateneu neak durek ki werfun ");
INSERT INTO bsj_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Nii a titi mor bicoro cii couceu. Fiyaco kwama cwo co naci ne bilenkeu. ");
INSERT INTO bsj_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Mwin changa fiyaco kwama cwo nena? kwom de dor mwer dor cer. Dila no mwan fiya nure ceer kari, mani nyo. ");
INSERT INTO bsj_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Wori nii wo kwama cuo co fiyaco cin cangau fiya ceerka kwama nin. Nyo tak, nii wo kebo canga fiyaco kwama cuo co nanci ne bilenkeu, canga Almasiya. ");
INSERT INTO bsj_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Cii teen kum ki kener ducce, nyori kom yilam de canga nobeb. ");
INSERT INTO bsj_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Kebmibo, bwenno nii fiya dor cero mor ye fiyaco ci cuo co naci ne bilenke ri, bi yilare kwama nen bwin. ");
INSERT INTO bsj_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","dor nubo buro narangum bo wiyeu, ma mamni ki werfun kwama nen. Dila maki tok dikero mato daten ne na nii wo ki cii bwini kwamak, lan ciya ka. ");
INSERT INTO bsj_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Matori ker kungka nerek ko you tiyeu, yori kabo nii a yilam nawo ci yimeu. ");
INSERT INTO bsj_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Mwi bwam ki duka naka nawiye? dore ywaka cek. No mwi manki nawiyeri, dore naka nawiyek. ");
INSERT INTO bsj_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Dila no mwin nam ri, mwi mabo bwirang ke, no bubiya wo nambo wiyeu nam di, ci mabo bwirang ke. Dila buro narangumeu an nuwarang dotange tini ki denmwer-Kidemen, la ma cwiti nami cok kom more ce. ");
INSERT INTO bsj_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Dila wo miki, kembibo kang kene ko da dum cuka, tabti na wo, yaken cuko kab, nubo ki natubeu a yi namwi cii man cuko. ");
INSERT INTO bsj_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Nubo ci wiye tiyeu a mani namwi kebo nubo ci wiye, kange buro ma bilangtum tiyeu namwi kebo nubo ma bilang tum tiye, Nubo tenang diker tiyeu namwi cii man ki diker. ");
INSERT INTO bsj_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","nubo buro ma nangenti ki kale weu a mare namwi ciin neken bikwan ceer maka nangenek ki kaleu, wori wank kale kowo atii dim. ");
INSERT INTO bsj_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ma cwi nakom fiya ceerka ki komka tini. Nii wo na beu, ki bulnag ki diker yilam Tee kwama ce, kambo a ciya ti kange ce. ");
INSERT INTO bsj_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Dila nii wo na meu ki kwama dikero dor bitinenereu kambo ci lunga neer wicero tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Neer cero tikangum. Nawiye wo nabeu kaka'a bubiya ki kwa'a diker yilam kwama ce, kambo ca neken dorceroti bwi kange yuwa tangbe. Dila nawiye nameu ki kwom dor dikero kale neu, kambo bwece a nuwa luma cek tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Ma tok wuro na tikang kom, kemi nan dok kom totange. ma tok wuro ki dikero yor-yore, na kom neken dor kumero Tee kwama nin kambo diker kange mani a kwom kom tiye. ");
INSERT INTO bsj_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Dila no kange kwati ki mani ci ma bubiya conin dikero dateneri, no bubiyau cum cor nakar, takeu no tam nyori, ca ma dike ci cwi tiyeu. Kebo bwirangke ca matiye. Cii ya kangum. ");
INSERT INTO bsj_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Dila no cin tiim kibi kwan ner cerdi no kwom cobo catin tom dor cerori, no cin tum mor nenerce can ma wuro ri, na ci yomre bubiyace ri, can mani yora. ");
INSERT INTO bsj_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","La co nii wo nam bubiyaceu mani dong dong, tak ri, wuro ciya ki mani ca na'a bubiya cetiyeu mani la kece ceu yorak. ");
INSERT INTO bsj_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Bolangko bwam na wiyeu ki kwama wo bwece ki dumeu, Dila no bwece bwiyamri, cin tin nam kange nii wo ca cwitiyeu, la a yilam mor nubo lo Tee kwama. ");
INSERT INTO bsj_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Duwal mor warkemiu, catin nuwa luma duce no ci yiken kambo ci yimmeri, takeu mi kwatiri mo ken man wiki yuwa tangbe kwama. ");
INSERT INTO bsj_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Naweu, dor caritowo bibwitinineu, bin nyumom biki gwam be bin wirangi ki nyomkak. Nyori kako bouti kurka taryek dila cwiuka wi ki muka. ");
INSERT INTO bsj_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Yomkako kwabi ki cii nyumom diker ri, nii cuo nyombo kambo daten ca nyumom tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Dila no kange cwii kwamari, cin nyumom ni cwo. ");
INSERT INTO bsj_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","la ker caka caritoko ca neken ne bi bwititiyeu, Bin nyumom biki bibwiti kalewo kebo dike kane tak ri, kwama kange man cum wo wiineu. ");
INSERT INTO bsj_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Bwenno dike cii cwo tiki bibwiti ni wi dii kwama kaka dor bitiner, (Kambo bibwitini kange teluwe tinim wi rangi kila nyeu. ");
INSERT INTO bsj_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Dila kwama win cwar fiye bi wiyeu wo dikero gwam ceru cineneu, wo kercer bi yimcu, kange Teluwe Yesu Almasiya wiin, wo cinen dikero gwam fiya fwelka, cinen tak bifiya fwelka. ");
INSERT INTO bsj_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","La nyom kakawo kebo nubo gwam cike. Nyori kangembo, fiya co wab fulen, La cin ca carito wo na dikero cii neken bibwitiyeu. La kwarum nere ceu, yilam ki duti wori kwambo. ");
INSERT INTO bsj_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Dila cari mani a yatiki bo kwama nin. Ba bwirabo nobi cabori kaka bi cob co diker nobi caari. ");
INSERT INTO bsj_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Dila ko nhyumom ceerka kume ko yilam bo dikero a dok kangeti wo kwambo mor bilenke kottang ka tiye. ");
INSERT INTO bsj_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ki dangne no yilam nii kange wo bilenke ceu kwambeu to nen mo nii mwiki nyom kau mwin ca cariti mor bikur waber bibwititi mwa dok kwarum nere ceu kwambeu bikwan caka dikero cii neken bibwiti ya? ");
INSERT INTO bsj_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","La ker nyoka ko mwiciko dor bibwitireu nii wo kwambeu, keebe wo Almasiya bwiya kercereu, fiya bwari. ");
INSERT INTO bsj_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Nyori, no mwi ma kebmwebo nin bwerang ke, mwi dok ner cero kwambeu fiya der di, mwin ma Almasiya nin bwirang ke. ");
INSERT INTO bsj_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","No cari atin dok kemi kot tangkari, mani ma wo nange ti tak, kati yila in kwob kebmibo nin yare. ");
INSERT INTO bsj_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ma man ki ceerka ka/ ma kebo nii tomange? Ma to bo Yesu Teluwe ba? Kom kerangbo nangen kaner Tee kwama nina? ");
INSERT INTO bsj_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","No ma kebo nii tomange tangaum nobebo nin di, min co kumen. Wori kom warke nangen tomanger miro Tee kwama nin. ");
INSERT INTO bsj_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Wo co kwicank miko nubo buro cuwaye tiye nin. ");
INSERT INTO bsj_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Ba manki ceerka bi ca bi noo ka? ");
INSERT INTO bsj_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Bi mani ki ceerka na tuu dor bero nin natubo ne bilenke kambo tangnum nob tomangebo kange yitub Tee kwama, kange kefas ca? ");
INSERT INTO bsj_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Kaka ka Barnabas kange mo wo manki bikwan neret naci mare nangen na? ");
INSERT INTO bsj_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","We yilam nii kwene ki kemercer bila ce? we co tola bi tuttuiri cabo bi tutti yo more ce? kaka we yuwa bicir di nobo yir cere? ");
INSERT INTO bsj_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ma tok dikeniti buro kibi kwan neret nii fira? Werfundo tok bo nyo kena? ");
INSERT INTO bsj_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Mulangum mulange mor werfun Musar “Kom dok tende Muzzle nyi nenner ki kwama wo ci fuwa range cam tiyeu.” La nenne kibi com kwama tok ker to dorcere? ");
INSERT INTO bsj_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","kebo dorber ci tok kera? ci mulangum kibo wori nii wo kaka tom tiye ki kaka ki yoka nererk, rila wo fuwarange cam tiyeu a fuwarangi ki yoka nererk can fiya wi. ");
INSERT INTO bsj_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","No nyi fii diker yuwa tangbe more kume ri, la diker bwei bweiye, fiye nyi wiye na nyi fiya kwilen kumena? ");
INSERT INTO bsj_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","No kangem bo ca luma cerka kume ko wuro ri, nyi man ki wo laa wo ceu ka? kawo nyi mabo nangen ki ceerka kowuri la nyori nyim bim ner ki dikero gwam kange. wo nya bou tiki tii ka fulenYesu Almasiya. ");
INSERT INTO bsj_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Kom nyombo komki nubo buro ma nangen do wucakketi mor bikur wabe reu ki fiya cari bikur wabe ra? ko nyom bo nubo ma wabe ti tancilan do wuccake ki fiya carito mor diker ci bouti cuko tancilando wuccaka? ");
INSERT INTO bsj_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","La nyo tak Teluwe kwma tokke ki nubo buro tok fulen kerer cero tiyeu a fiya cari cero ki fulen kerero nin. ");
INSERT INTO bsj_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Dila ma mabo nangen ki ceerka kowo. Takeu ma mulang bo wuro ri nakom ma men diker dor cer. an lamen diker in bwiyam kange wo kange man wo a ywamye bitenan bo wo tiye? ");
INSERT INTO bsj_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","wuri no mi tok fule kerero tiri, ma manki dikero a dok ye bitenam tiye, wori min mawo. A kwann ye no ma tok bo fulen kerer di. ");
INSERT INTO bsj_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","La no mawuro ki cwika miik ri man wiki cuner. Dila no kebo ki cwika mik ri, duwal man wiki nangen do kwama neyereu dor mir. ");
INSERT INTO bsj_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Nye cuner miro? ri kambo ma tok fulen kere ri, matin ne nubo fulen kerero ki luma nerek kebo ki kemer nyori mani ma manengen ti ki ceerka mor fulen kereo nineu. ");
INSERT INTO bsj_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Bwenno min fiya ceerka fiye gwammeu, min yilam canga nubo gwamme ri, nami fiyau ten kangem nubo. ");
INSERT INTO bsj_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Fiye Yahudawa wiyeu, min yilam nii Yahudawa na min fiya ciya ka Yahudawa wak gwam. Ki nubo bolangko ma liyar ceer tiyeu min yilam na ni bolang ma liyar ceertiye nami fiya ciyaka nub bolange. ");
INSERT INTO bsj_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Ki nubo mani mor liyar bolanger reu, min yilam na ni wo mani mor liyar bolangere. bwenno ba cer bo mor bolang kwamak miki bwimiyeu, dila miki no mor bolang Almasiya. Mi ma wuro nami fiya liyarka nubo mani mor bolangekeu. ");
INSERT INTO bsj_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Ki nubo wo kwamang beu, min yilam mi manki bikwan nami fiya ciyaka nubo kwamang beu. min yilam dikeni buro gwam ri bwenno a manyi ri, matin ceer kangembo. ");
INSERT INTO bsj_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Kom nyombo cwaka cwokek. ");
INSERT INTO bsj_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Nubo cwatiyeu ki cwa gwamce, dila nii wi ki yore nan cwake ra? cwa namwi cam nando. ");
INSERT INTO bsj_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Nii lore ki merang taka dorek mor dikero gwam. cii ki ma nyo naci fiya nando kayati kayau, dila beu biki mani nabi yo wuro mani kaya reu. ");
INSERT INTO bsj_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Wo co kando mi cwam tiyeu. kebo na nii wo cwacwak ti koniyeu. Won co kambo ma kwam kang tiye kebo na ni wokwa yuwatiye. ");
INSERT INTO bsj_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","La man dok bwimiu yilam canga, ri kati yilo kambo mi yi kangembo fulen keredi, ki bwiri ci cokum ye. ");
INSERT INTO bsj_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Ma chwibo ki yilam kebo ki nyomka kebmibo tebbebo gwam ki no tob bilorem kange chuu mor wima. ");
INSERT INTO bsj_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Gwam cin yuchinen mwem Musambo more bilore kange wima. ");
INSERT INTO bsj_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Gwam chiye ci cha ti yuwa tangbe wucake win. ");
INSERT INTO bsj_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Gwam chiye chin noo yuwa tangbe wucake nyo wo ci no chwela yuwa tangbe ko bwanchinenten teyeu, chwelaka churo kiristi. ");
INSERT INTO bsj_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","La kwama nuwabo lima ki ducce more ciye la bitenti chiro watangum wi yera. ");
INSERT INTO bsj_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Na weu dike buro yilam nungka binen, na bi yilare nob dilanka bwiyek dor dikero bwir wo bi dilantiye. ");
INSERT INTO bsj_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Bi yilare nob wabe fulene na wo more chiyeci matiye. na wo mulangum mulange, “Nubbo yiken cha, noo la kwen loro”. ");
INSERT INTO bsj_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Bi yilare kayaka, na wo ducce more che mane. Mor kume win nubo bikate kwini yob chilombo taar bwiyam dor cher. ");
INSERT INTO bsj_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Bi chuware Kiristi na wo ducce more chiye mane, La nachuwe twalangum chi. ");
INSERT INTO bsj_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ki mare fwenna na wo ducce more che mane, cin bwiya bwar kang ni tomange kwama wucake. ");
INSERT INTO bsj_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Na weu dike buro machineneu na yilam nungka binen. Mullangum Mulange na yilam werangka, binen wo chile kale wo bo bineneu. ");
INSERT INTO bsj_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Nyori ni wuro toti chin timeri cha ma nyora kari cho yari. ");
INSERT INTO bsj_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","chuwakakako kange mani wo bo kimen mani nubo nin gwamme, wori kwama ni bilenke. mani a dobti ci chuwakom wo a lam bikwan kumero tiye. Ki chuwaka chan ma kumen nure cherka, wo ka mwirumum tie. ");
INSERT INTO bsj_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Nyori kom mi cwiti-cwiyeu, kom cwam fiye fulene. ");
INSERT INTO bsj_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Miki yi kom na nubbo wuro ki nyomka, na kom warker dor dike ma tokkeu. ");
INSERT INTO bsj_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kwele bibwiyere wo nyoten bibwiyer tiyeu, kebo wo ki chike gwam mor bwiyale kiristi ka? Charito wo nya wulangeu, kebo wo bi chiko win mor bwiye Kiristi ka? ");
INSERT INTO bsj_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Wori charito wiin, bo keneu bi ducce bwiyo wiin. Bin cha chari wiin gwam be. ");
INSERT INTO bsj_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ki too israila mor bwiye, kebo nubbo buro twi nuwang tiye cha dikero tangjilanko wucake tiye ka? ");
INSERT INTO bsj_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Ye mi toktiye, ki fulen diker ka? kaka charito ci ne fulen neu diker ka? ");
INSERT INTO bsj_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","La miki tok dike buro nubbo nyombo kwama, nob fulenneb ki ne ninga dike buro, kebo kwama. ma chwibo ki mwerkang dor kange ninga. ");
INSERT INTO bsj_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ma ka noo kwele teluwe ti kange kwele ninga. ");
INSERT INTO bsj_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Kaka biki kang teluwe nin ner mor kiye ka? bin kwami bin lacho ka? ");
INSERT INTO bsj_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","dikero gwam na wo yor yore, la kebo dikero gwam ki tikaliye. “Dikero gwam na wo yor. yore,” La kebo dikero gwam wo muu ni tiye. ");
INSERT INTO bsj_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Kange nii a dore dike yor yore dor chero che komi, nyori cha do dike yori ni chi wariye. ");
INSERT INTO bsj_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Kom cha dikero gwam ci miti fiye miyaka, kom mere bi mer more nere. ");
INSERT INTO bsj_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Wori “Kalewo na Teluwe che kange dike more che”. ");
INSERT INTO bsj_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","No nii nyombo kwama chuwo nen chaka chari di, mwen chiya mo yari, cha dike cho ne nenneu, mere bi mer mor nere. ");
INSERT INTO bsj_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","La no kange yinen ki “wo chin wabum fulen chiko di” chare, ki ker nii wo yi neneu kange ker meka nererk. ");
INSERT INTO bsj_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Meka nerek ni wineu, kebo mweu. Ye a bwiti war neri kange a warkerti dor cherka mike? ");
INSERT INTO bsj_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","No min cha charito ki buka kangek ri, ye bwi chiya toyeti dor dikero wo ma ne buka kangekeu? ");
INSERT INTO bsj_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Nyori, no mo cha kaka noo, kaka dike mo maneu ri, mani gwam dike a bouti ki duktangka kwama ke. ");
INSERT INTO bsj_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Kom yilam dikero manki diker yaret Yahudawa nin, helenawa nin kange mwerkangka nubbo bwan kwama nin tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Nyo tak kom ma dike wuro nubbo gwam a bilangtiye. Ma dobo yokka dor mirek kini, miki do nubbo nin ducce. Ma wuro mna fiya fuloka. ");
INSERT INTO bsj_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Yi yilam nob merangka ki mo, na wo min nii merangka ki Kiristi Yesu. ");
INSERT INTO bsj_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Na weu min chaklang kom wori mor dikero gwam kom kwayeti. Mi chaklang komti wori kom tam kibi kwan dikero ka chiya chikeu dong-dong na wo ma nekome. ");
INSERT INTO bsj_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Teluwe nubbe gwam, teluwe nawiye nii nabare, kwama cho teluwe Kiristi. ");
INSERT INTO bsj_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Nii nabare wo kwob dilo kaka ker dukumer, dor chero chumom chumeri nebo teluwe dur. ");
INSERT INTO bsj_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","La nawiye wo kwob dilo kaka tok ker dukumer dor chero chombo chomeri, nebo teluwe che dur. Won yila na dikero namwi dor chero charum-chare. ");
INSERT INTO bsj_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","No nawiye mani a chwom dor certiri, cha mwatum yiri cheto bi kwenje. No diker kwenduwer nawiye na mwatum yiri duwe cheri kaka charum di, cha chumom dor chero. ");
INSERT INTO bsj_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","nii nabare mani a chumom dor cherti, wori chon cherken kange duktonka kwama, La nawiye duktongka nii nabarek. ");
INSERT INTO bsj_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","wori nii nabare chi fwellu bo nawiye nin, nyori, nawiye chi fwellu nu nabare nine. ");
INSERT INTO bsj_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Chi fwelbo nawiye nin nii nabare, nawiye chi fwellu ki nii nabare. ");
INSERT INTO bsj_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","wuro cho dike bwi nawiye a yilamti ki yirom bikwan keret dor chere ker nobb tomange wuccake. ");
INSERT INTO bsj_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","kebo nyo tak ri, mor teluwe nawiye yibo dor cher fiye nii nabare wiye, nyo nii nabare keneu yibo dor cherfiye nawiye nine. ");
INSERT INTO bsj_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","na wo nawiye bou nii nabare, Nyo nii nabare bou nawiye nin, dikero gwam bou kwamam nin. ");
INSERT INTO bsj_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Kom warkero ki bwikimi, yori kabo nawiye a kwob dilo kwama nin dor chero wumom-wume ka? ");
INSERT INTO bsj_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Kebo nyo yim bembo ki bwichi merang kimen ki no yiri nii nabare chwiyemi ri diker kwenduwer chinene ka? ");
INSERT INTO bsj_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Kebo nyo yim bembo ki bwichi merang kimen, no nawiye ki yirito chwiyem chwiyemeri, duktongka che ka? wori chi necho yirito na yilam diker chomkar. ");
INSERT INTO bsj_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","No kange wi ki kwalkan ke dor dikero wori nyo manki dike kange nyo bwanten kwama. ");
INSERT INTO bsj_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","la mor dike bwangu kero weu, mani ma chaklang komti, wori no kom mwerye kangi ri mani kom ma dikero ken kom ki maka dikero bwir. ");
INSERT INTO bsj_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Ki terka, min nuwa no kom nob kwamab ki mwerkangi ri, yalkanka wi more kume, mor kange min chiya chiko. ");
INSERT INTO bsj_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Wo an tam yalkangka wi muwore kume, na nnyori nubbo chiya chikeu na cheru more kume. ");
INSERT INTO bsj_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","wo no kom mwerkangi ri kebo chari kwaka ki teluwe be kom chatiye. ");
INSERT INTO bsj_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","No kom chatiri, wo ki cha na che na tannebo cha chiye, kangumbo cham. kange nuwa wurati, kange nom ducce. ");
INSERT INTO bsj_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","kom manki luwe ka chati, ka notiwiye ka? kom chweye kangum mwerkangka nob kwamab takeu kom ne nubbo manchike dotange. Ye ma yikom tiye? chaklang kom ka? mani ma chaklang komti wonin. ");
INSERT INTO bsj_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Wori dike ma ywou teluwe be nine cho mi ne kom tiye, teluwe be Yesu kume chi miyem cheu tuu tii Liita. ");
INSERT INTO bsj_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Bwiko cho bu kangeri, cheom wulangi chon yi ki, “Wo bwini chi ne komme, kom mawo na kwakako che kange mo.” ");
INSERT INTO bsj_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Nure wo tak chon tuu kwele bwiko tii llitau, chon yi ki kwelewo na norro fwirko che chi chiya chike mor bwiyale mi. Kom ma wo kir-kir na kwaka miko che. ");
INSERT INTO bsj_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Dike ka cha tii liita we, ka no kwele kom ki kwadir bwaret teluwe be ya chiko bi diye cha boutiye. ");
INSERT INTO bsj_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Nyori nii wo cha tiyowe, noo mor kwele teluwe be ki dike datenbe ri, chin ne dikero doatnge bwir bwi kange bwiyale teluwe be. ");
INSERT INTO bsj_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Nyori kom ter chuwaka dorek kumeko nimre kom cha tii liita, na kom noo mor kwele wo. ");
INSERT INTO bsj_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Wo no cha noo, tikambo bwiyeu, cha noo dor chero nin bolang. ");
INSERT INTO bsj_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Cho muwore kume kangumbo manki bikwan, nuwabo luma, kangum kimembo dam dum. ");
INSERT INTO bsj_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","La no bi chuwa dor bero tiri mani chiya ma binen bolangti. ");
INSERT INTO bsj_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","La no teluwe be ma binen bolangri, biki mwekan, nyori na chi kuwa bore kange kale wo. ");
INSERT INTO bsj_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Nyori kom yitub mibo no kom ningtang bwiti. ");
INSERT INTO bsj_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","No nii wo nuwa wura tiyeri, cha cham lo, la no kom mwerkangi ri, kebo bolang che. dor tanne dikero ka mulangu weu, non bou ri man nung kume nure. ");
INSERT INTO bsj_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Dor neka diker na yuwatangbeko ceu kebmibo, ma cwibo kom manki nyomka. ");
INSERT INTO bsj_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Kom nyimom fiya cuwo kom nyombo kwama, cin bolkom kulen fulenero mani tokkereu, ki nure kila-kila chi yaaki kome. ");
INSERT INTO bsj_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Nyori mi cwiti kom nyimom kange nii mani wo a tok ker yuwatangbe kwama ri, ayitiki,”yesu chilum-chile”, nii mani wo a tok ki,”yesu teluwe, kange yuwa tangbe wuchake ri.” ");
INSERT INTO bsj_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Na weu neka dikero ki dimenti la yuwa tangbeko wiin. ");
INSERT INTO bsj_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Wabe wii ki dimen-ki-dimen la teluwe wiin. ");
INSERT INTO bsj_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","nangen wii ki dimen, la kwama wiin wo na ma nagendo ti gwam mor gwamme. ");
INSERT INTO bsj_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Nubbo nin gwam chin ne bikwan nungka yuwa tangbe nyanglang wo a yilamti ki nangen nubbo nin gwamme. ");
INSERT INTO bsj_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Kange yuwa nyomkar, yuwa tangbeko wiin. ");
INSERT INTO bsj_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Kange nin, chin ne cho bilenke, chon yuwa tangbeko chuwo wiin, kange nin, chin ne cho twaka cho yuwa tangbeko chuwo wiin. ");
INSERT INTO bsj_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Kange nin chin ne nangen nyimantum, kange ker dukumer. kange nin chin ne cho nyomka, yalkangka yuwa tangbetini, kange nin, nyomka nyiini ki dimen-ki-dimen, kange nin fwetanka nyiini ki dimen-ki-dimen. ");
INSERT INTO bsj_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Gwam wuro nangen yuwa tangbe wiin, tikan nubbo nen ti ki winti-winti na wo cha chwiyeu. ");
INSERT INTO bsj_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Na wo bwiyo wiin, la ki mwantiyeu, mwantiyo buro cho bwiyo cho wiinneu, nyo Kiristi nin. ");
INSERT INTO bsj_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Nyo yuwa tangbeko wiin chi bo gwam chi yubinen mwembo gwam mor bwiyo wiin. Yafudawa kaka Heleniyawa, chnaga kaka nii chokkum-choke, gwam chi mabo ba no yuwa tangbeko wiin. ");
INSERT INTO bsj_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Wo bwiyo kebo mwan wiin, kila kabo. ");
INSERT INTO bsj_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","No nako yii ki, “Wori na kebo kang, mi mani mwan bwiyer”. Wo mani ywacho yilaka mwan bwiye. ");
INSERT INTO bsj_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","No tuuwo yi ki, “Wori ma kebo nuwe, ma kebo mwan,” Wo mani a ywacho yilaka mwan bwiyeti. ");
INSERT INTO bsj_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","No bwiyo gwam nuwari, a nuwa kero ki ye? No bwiyo gwam tuu ri, a twi diker kiye? ");
INSERT INTO bsj_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","La kwama ywel manwti bwiyero winti-winti mor bwiye na wo cho chwiyeu. ");
INSERT INTO bsj_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","No chi gwam mwanti wiin di, la bwiyo ki nofe? ");
INSERT INTO bsj_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Wo mwanti bwiye kila, la bwiyo wiin. ");
INSERT INTO bsj_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Nuwe mani a yii kangko ti “ma cwinenbo” kaka doro yii naako, “Machwinenbo”. ");
INSERT INTO bsj_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","La mwanti bwiye toti namwi bukkeu, chi yoryore. ");
INSERT INTO bsj_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Kange mwanti bwiye, yorbo toka, bi nechi durti duche, mwanti bwiyero yoryore wi ki. dur wo la ciye. ");
INSERT INTO bsj_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Channeu mwanti bwiye chwibo dike buro, kwama mwerkang bwiye, ne durti duche mwanti bwiye man chike. ");
INSERT INTO bsj_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Cha ma wo na yilam yalkangka mani mor bwiye, la na mwantiyo tokan bwiti ti kambo keng. ");
INSERT INTO bsj_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","La no mwando wiin nuwa dotange ri, mwantito gwam nuwa dotange wari kaka mwando wiin no chin ne dur di, gwam mwantito bilangi wari. ");
INSERT INTO bsj_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Channeu kom bwi Kiristi kange mwantito bwichiyeu. ");
INSERT INTO bsj_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Kwama yo mor nob mwerkanka chek, wiineu nob tomangeb, yobeu nob dukumeb, taareu nob merangkab, bwanteneu nob maka diker nyimankar, neka twaka, buro ma tikali tiyeu, buro ma nangen kale tiyeu, kange buro nyimom nyiini ki dimen-ki-dimeneu. ");
INSERT INTO bsj_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Gwam che nub tomangeb ka? Gwam che nob dukumeb ka? Gwam che nob merangka ka? Gwam che ki name twaka ka? ");
INSERT INTO bsj_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Gwam che chi tokerti ki nyiini ka? Gwam che fwetang nyiini tiye ka? ");
INSERT INTO bsj_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Do nekako dur ki kor neret. La man nange kimen nure datenneu. ");
INSERT INTO bsj_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Ta bwenno yilam miki tok kero ki biyendi nuber, kange wo nob tomangeb kwama bo cori cano mimanki chwikari, min yilam na dinglinge ki dikereu, kaka nyorako kidineru. ");
INSERT INTO bsj_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Ca bwenno yilam minwiki ker neka dukumeri, dila min nyumom bilenke yurangum yurange, kange nyomka gwamm, cano miki bilenker tenang tenangeu nawuro matungum cwelaktiyero. Tano mi manki cwikari, mi kebo dike kange. ");
INSERT INTO bsj_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Ta bwenno min neken dike micike gwam nacin nob buneberi, nan neten bwimiu naci twime. ");
INSERT INTO bsj_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Cwika wiki yobka nerek kange dikero ken, cwika mani ma kurom kaka cukka dorek. Cwika mani dang kunka dorek. ");
INSERT INTO bsj_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Kaka mani wab dorcer. Mani kang ner wulom, mani kiye tenanka kereko bwir. ");
INSERT INTO bsj_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Mani nyori, ci ma bilangtumti, ki bilinkerer. ");
INSERT INTO bsj_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Cwika binerti mor diker gwam ne bilenketi. diker gwam, we ki ciyaka dikerek gwam, bwa nerti ki diker gwam. ");
INSERT INTO bsj_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Cwika mani dir, Tano tomange dukum tinim wiri, anbou ya cum. Tano biyentinim wiri, ciyan lerangum. Tona nyomka wiri ciya kom. ");
INSERT INTO bsj_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Wori biki nyomka dii-dii takri biki dii-dil. ");
INSERT INTO bsj_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Kambo wuro dimdiyeu boweri ciro dibeu ancum. ");
INSERT INTO bsj_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Min bi bweu, miki tok kero na bwe, miki kwadikero na bwe, miki hujo na bwe. kambo malam niiyeri min cutang bibwetiwowi. ");
INSERT INTO bsj_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Naweu bititoi mwin mor nuwe tirome, dila diye tikob kange tikobe, naweu min nyimom biduwar, dila diyecori man fiya nyomkako dimdiyeu kambbo cii mameu nyumkako dimdiyeu. ");
INSERT INTO bsj_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","lawnaweu dikerewo taareu inwi. neka bilingkek, yoka nerek kange cwika, dila wo teneg moere ceu cwika. ");
INSERT INTO bsj_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Kom bwan cwikako takri kom citi dor dikerowo yuwa tangbe kwamamko nenin nobo, na ker dukumer. ");
INSERT INTO bsj_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","La niwo tokker kibiyenneu tokbo kange nob la konga kwama Dila nii kange mani nuwa coti wori ciki tok kero yurangum yurange mor yuwa tangbe kwama ke. ");
INSERT INTO bsj_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Dila wo tok ker dukumer tiyeu ki tok kange nob naci mumci, naci bikwaneret, naci neci birim nerem tak. ");
INSERT INTO bsj_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Wuro tok keroti kibiyondo kange ki mudorcer, dila nii tok ker dukumertiyeu, ki mu wabe kwama. ");
INSERT INTO bsj_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Naweu mincwi kom tok kerti ki biyentinim. Mincwi kom tok ker dukumero laweu. Wuro tok ker dukumer tiyeu la wuro tok kerti kibiyentiyeu, (No kange fwetangi dob kwama bo nyimiri nanyime). ");
INSERT INTO bsj_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Naweu keb mibo tannonbou kumer mitok kerti ki biyen tinim diri, kafiya dwika nyi kime? mani mati non nyikom ki dukumeri, kaka nyomka kaka ker dukumer, kaka merangka na nyime. ");
INSERT INTO bsj_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Tano kulen kwabanka koworo manag ki dumeu na lirak kange bilifwiyen atin nedir dila mani cenin dirti kidimen kidimenri, kange anyem nyi ki wonco diro lirako kange bilifwiyen netiya? ");
INSERT INTO bsj_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Lano ci cu cumen kidiro datenberi, kange a nyomomtiye? ki nangyo kange kom. ");
INSERT INTO bsj_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Tano kom tokkaero manki nureceri, kange a nyomnyi kiwonco dike kom toke? ka an tokker, dila kange mani nyomti. ");
INSERT INTO bsj_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Nyimanka man biyentito wi dorbitiner kidimen kidimen, dila mani winwo morecer nawo manki dike tokkiye. ");
INSERT INTO bsj_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Tano ni nyombo diki tokkiyeu, mati yilam fabe fiye nii kere wiyeu, ni kereu an yilam fabe mintilak. ");
INSERT INTO bsj_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Kinonyo kumen Dila kambo kom cen boka yuwatangbekotiyeu, kom cidor mor dwika muka lokwamak. ");
INSERT INTO bsj_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Lawo tokkerti ki biyenneu ciya kwob dilo nabe ci fwetangi. ");
INSERT INTO bsj_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Tawo kwob dila ki biyendi, yuwa tangbemiki kwob dilo dila nyomkamika yoktenbo. ");
INSERT INTO bsj_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","La, ye mamatiye? man kwob dilo kiyuwa tangbemik, nan kwobten dilo kinyomka mik. manko nure ki yuwa tangbe mik, nan katen nuwe kinyom ka mik tak. ");
INSERT INTO bsj_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","No nobonyori, tano mu caklang kwama kiyuwatangbe koniri, amangi niiwo kaleu attokki “atiye” dor buka kangko mu dontantiyeu noci nyombo dike mu toktiyeuri? ");
INSERT INTO bsj_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Kom dang buka kangek nyimanka mani, dila kange dwibo ciko. ");
INSERT INTO bsj_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Mibu kwamanin kang ti mi tokkerti, ki biyenim lawo kumen gwamm. ");
INSERT INTO bsj_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Dilanawo min cwi na tokker mor lo wabe kwama nyiyo nung wuri ma nyimommeu na mu kangembo kange ker bikate kwob mor biyenne. ");
INSERT INTO bsj_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Kebmibo, kom yilare bibei bikwanere, nyori kom yilam bibei fiye maka dikero bwir. Dila kwama kume a yilam nubo durece. ");
INSERT INTO bsj_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Mulangum mor bwolange kii man tokker kange nubo biro fiye nob fabub biyenebbo wiyeu, kange toknyireyer fabuber. Kangewo gwam maniciya cuwa tuuti,” in nuwa kwama. ");
INSERT INTO bsj_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","biyentinimbo yirom kebo, fiye nubowo nebilinker tiyenin dila fiye nuboro nebo biling kenin. ker dukumer yirom fiye nubowo nebiling ketiyening kebo fiye nubowuro nebo biling kenin. ");
INSERT INTO bsj_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Dilano lo wabe kwamma atin mwerum fiye win natokker kibiyentinim, birombo kaleu kange birombo nebo bilingke dou mordi nami yiti kimon twelum twele? ");
INSERT INTO bsj_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Tano kom tokker dukumertiri, niwo nebo bilingke douri, kero atin kece ciyatin warcinen warke dor kerero conin. ");
INSERT INTO bsj_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Yurka nerek ceko atin ceru kale, la niyeco catin yarken bitinen ci wab kwama, atim toki kibocom kwama wikange kom. ");
INSERT INTO bsj_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Dila yotak kebmibo? tano kom mwer kang nyiri, kange wiki zabura, merangka dukum biyem tinim, kaka fwetangka. Tokker diker muka lowaber kwamak. ");
INSERT INTO bsj_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Tano kange tokker tokker kibiyendi kilaka ciko afiya nob yob kaka taar, dila ciya toktti kiwinti kiwinti, la kange na a fwetang dikero ciitoketi. ");
INSERT INTO bsj_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Tano wuro a fwetangtiyeu maniri, gwammce ciya kumom lowabe. Dila kwarube ciya yidorciro keroco ki kwace kange kwama. ");
INSERT INTO bsj_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Nyori nobker dukumero yob kaka tarr atokero, tangne ce a cwutuu warii nyomka dikeci toktiyeu. ");
INSERT INTO bsj_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Tano cin nekange nyomka yimwi mor waberi, niwo ki kabau a kumom. ");
INSERT INTO bsj_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Kwarub kume kan tokker dukumer kiwinti kiwinti, na wuyakkume kom merang dikerwi nafiyaen bikwan nerertak. ");
INSERT INTO bsj_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Wori yuwa tangbek nob ker dukumeroo kino wari kange nob ker dukumero, ");
INSERT INTO bsj_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Wori kwama kebo kwama kulomka na nero fuworece. ");
INSERT INTO bsj_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Natubo akumom nyici mor lo wabe kwama wori, cii necibo ciyaka tokka kerek. nyiyeceu ciya neken dor ciro kambo bolang werfundo tokeu. ");
INSERT INTO bsj_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","No dikero kangewi cii cwiti na cii merangeri, ciya me bwetubcibo lo diker kwenduwer, nawiye natok ker mor lo wabe. ");
INSERT INTO bsj_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Ker kwama ro bou kumena? laukumen kom ki kwama? ");
INSERT INTO bsj_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","No kange kwati kicinin tomange dukumeri, kaka cin nii ki dike wuro nyi mulangka cinentiyeu nyal bou fiye teluwe wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Tano wuro ko nuwaka diker kowori, cekeneu a nuwa core. ");
INSERT INTO bsj_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","naweu, kebmibo kom yilam kikuru tokka ker dukumer kambo ken, kom kore tokka. ");
INSERT INTO bsj_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Dila a ma dikero wuyak nure datene. ");
INSERT INTO bsj_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","La naweu kebmibo mi kulomkumen ker kwamaro wuro mu yikom komyo kom manangen cikeno. ");
INSERT INTO bsj_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Won cho ker kwamaro cii ma kumen dumecike no kom tam kero miyi komeu kibi kwana tim yilam nokom nebo bilingke ken dor cerdi nayime. ");
INSERT INTO bsj_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Wori mane kom kwamage dike ro ken wuro ma yoki kaba lamti almasiya bwiya ker bwirang kerber, kambo bifumer cero tokeu. ");
INSERT INTO bsj_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","Ciin fwerum co tak, dila kwenum ki kume taare kambo bifumero tokeu. ");
INSERT INTO bsj_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Dila dang jang dor cero kefas nin na nyime kwobcilombo yobe nin. ");
INSERT INTO bsj_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Kambo nyeri lam dan dor cero nubo kwini nungin cikowin. Biro kangum cimbo wiki dume diduweno koweu, dila kangem cembo damdum. ");
INSERT INTO bsj_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Dila kambo nyeri ya dang dorcero Yakubu nen kange nubo kwarub. ");
INSERT INTO bsj_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Kibwiri, dangu dorcero minen na bwecibo dibe. ");
INSERT INTO bsj_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Wori, mo mi dwel dwel mor nob tomangeb cebo nen. Midatenbo a coye ki nii tomange, wori mine lo wabe kwama dotange. ");
INSERT INTO bsj_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Dila luma nerek teluwe toki ni fiyewo miwi nanweu, luma nere cero moremiyeu kebo koni dilan luma kwama wari kange mo. ");
INSERT INTO bsj_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Dila naweu, mo kaka cii nya tok ker kwamaro nyo ka ne bilenke nyotak. ");
INSERT INTO bsj_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","tano ciin toki ki Yesu kwenum tuweri, cimanyi kangem kumembo tokti ki “Kwenka tuwek maniye?” ");
INSERT INTO bsj_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Tano kwenka tuwek maniri cii kunbo Almasiya ken. ");
INSERT INTO bsj_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Tano almasiya kwenbori ker nyero yilam dikero bwi koni yotak biling keret kumero yilam dikero bwir koni. ");
INSERT INTO bsj_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Nyin yilam nob warkeb cwerkeb dikero kwamab, nyinti nyiki kungum Almasiya tuwe wendi kuncobo. ");
INSERT INTO bsj_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Tano yilam kwenka tuwek maniri, Almasiya keneu ci kuncobo. ");
INSERT INTO bsj_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Tano cii kunbo Almasiya ri, bilinkere kume na bwir komi nawotakeu kom mor bwirang kerer kumer. ");
INSERT INTO bsj_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","La birombo bwiya mor Almasiya yakcamce naweu. ");
INSERT INTO bsj_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Tano kin cho yimbo win cwar biyo neroti Almasiya ninneri, la mor nube gwam bilanci diker cibwinir. ");
INSERT INTO bsj_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Dila naweu, Almasiya kwenum tuwe, wuro dok cho ciyilam bika kabak mor kwenka tuwek. ");
INSERT INTO bsj_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Kambo buwaro dou dor bitiner dor nii wineu kwenka tuweko kino nyoken. ");
INSERT INTO bsj_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Kambo mor Adamu gwam cii buyameu, an fulo cii mor almasiya gwamken. ");
INSERT INTO bsj_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Dila kwarubce wiki nurece; Almasiya, bika kabak, nayime birombo na Almasiya ceu ciyan fulou ki kume bokacek. ");
INSERT INTO bsj_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","na nyime bwiyeko an bwangu, ki kwama Almasiya a neken Tee kwama liyarotiyeu. la na nyime an tungum liyaro gwam, bikwan kerert bikwan duret. ");
INSERT INTO bsj_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","An ma liyar cero na wuro catin yoken nob kurombe cebo fou na tacok bitine. ");
INSERT INTO bsj_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Buwaro co nii kiye bwiko wo ciya twaltiyeu. ");
INSERT INTO bsj_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Dila “naci yoken dikero gwam fou natacok bitine.” Kambo ciyi ciki cinyoken dikero gwam wuro dangum nyanglang mo mwerbo kange wo yoken dikero gwam cineneu. ");
INSERT INTO bsj_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Tano dikero gwam kino kang cari, dila bwe keneu kino kang bikwan Liyare co nii neken dikero gwam kang liyaroken. Wo atim yilam nyo na Tee kwama yilam diker gwam mor diker gwam. ");
INSERT INTO bsj_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Kaka'a ye abwiti kange birombo ci yucinen mwem burweremtiyeu? kwenka tuwek maniri, in yeyorak mungeko yucinentiyeu? ");
INSERT INTO bsj_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Ye bwi bi mor chito kir-kire. ");
INSERT INTO bsj_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Miti buyai kirkir. wuri cowo mitokti kicwikka dorekeu, kebmibo, wuro miciko mor Almasiya Yesu Teluwebe. ");
INSERT INTO bsj_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Ye atikang yetiye nuwe nube, tano bukkani kange Afisari, tano kwenka tuwek maniri, “Naweu bica bino, wori fini ban buyam”. ");
INSERT INTO bsj_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Ciyabol komre wori “mwerka dorek kange nubo bwir kange yimbo kenti”. ");
INSERT INTO bsj_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Ko yi cooki! kom yiyim Cakcakem; kom care kaba ki bwirankeret. wori kangem kumembo manki nomka kwama. Miki tok wuro nan nekom kwenduwe. ");
INSERT INTO bsj_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Dila kange an toki kii kwenka tuweko a manye? Co bwiyo wini ciya kwenti cike? ");
INSERT INTO bsj_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Kom nubo nyombo diker kambo kenei dike mwa fiyeu mani ter dwikati an buyam bwiri. ");
INSERT INTO bsj_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Dike mwe fiyeu kebo bwico a ceruutiye, in nunice komi. Wuro yilabo bikateri ayila dike kange kidimen. ");
INSERT INTO bsj_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Dila kwama amnuce bwiyo kambo ci cwiyeu, wuyak nun diketininmbo kice bwice. ");
INSERT INTO bsj_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Biyo kwarub kebo win. nawori bwiyo wi dwantibo wo bicireceu witak, bwi bilibeu witak, kange bwi jingeu. ");
INSERT INTO bsj_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","bwiyolak nawo dii kwama kange bwiyewo dorbitineroceu. Dila duktangka bwidikwako kidimen duktangka bwidorbitinero ceu, kidimen. ");
INSERT INTO bsj_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Wori, bitirendo kange yilam kidimen fiye duktangka bitirendo wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Kwenka tuweko kinonyo dike cifiyeu diker yakcaker, wuro ci kungeu kebo diker yakcaker. ");
INSERT INTO bsj_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Cii ficobo kiyoracek, ciin kungum cho dotangeka. cii fico mor deti, ciin kungum co mor bikwandoret. ");
INSERT INTO bsj_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Cii fico kibwiyo kendo, cii kung cho mor bwidumer. Ta No bwiye kendo wowiri, bwidume wiken. ");
INSERT INTO bsj_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","nyo ci mulange, Adamu nii kaba yilam nii dume”. Adamu bwiko yilam yuwa tangbe ne dumetiye. ");
INSERT INTO bsj_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Kebo yuwa tangbe ko cou ter boka co bwiyo kendowo, na niyme yuwa tangbeko ceu. ");
INSERT INTO bsj_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Nii kaba cirou bitine, fou dor bitiner. Dila cho nii yobe cirou kwama. ");
INSERT INTO bsj_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","kambo nii cho cirou bitneu kino nyo birombo ci fweleu kinbitine. kambo nii cho kino kwama birombo naceu nyoken. ");
INSERT INTO bsj_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Kambo bikumki bwiyowuro cerkang bitineceu, nyoken bayila niiwo dii kwama tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Ma tok nawuro kebmibo miki nage kange bwiyale mani ciya to liyar kwamaroti. Nyotak, wuro yakcamti yakcau mani ca kwati wuro mani yakcareti. ");
INSERT INTO bsj_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","To, miyikom yurka bilinketi: mani ba buyati gwam dila ciya fulogumbo. ");
INSERT INTO bsj_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Ciya fulongum bo nawo nawo, mor lifranka nuwek, ki cume bwiko. wori ciyan cuu cumeu, nubo bwyameu an kweni ki dume, ciyan fulongum bo tak. ");
INSERT INTO bsj_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Dila wuro kayati kayau in tamnyo can yoti bwiyowuro manki kayakau, bwiyo wuro buyati buya takeu can yoti wuro manki buyakau. ");
INSERT INTO bsj_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Tano bwiyowo kayati kayau ci yoti wuro manki kayakau bwiyati buyau ciyoti wuro manki buyaka wiri, dila dike ci munlangeu andim “Min buwaro mor caka kaba”. ");
INSERT INTO bsj_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","Buwar, fe caka kaba mweko? buwar fe mwan mwero. ");
INSERT INTO bsj_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","La mwan mwero bwirankerer, bikwan bwirankerero in bolang. ");
INSERT INTO bsj_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Dila bua kangek ki kwama wo nebo caka kabak fiye teluwe Yesu Almasiya! ");
INSERT INTO bsj_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","La na weu, kom kebmibo komti yora kom mikanger. Kom titi nangen Tee ronin, kom nyimom nangen kumero fiye Teluwe wiyeu mani bwangten mwemti. ");
INSERT INTO bsj_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","La naweu ker merangka nob kwamabo wucakeu, kambo mayi ku wabiti kwama Galatiya kom manyo. ");
INSERT INTO bsj_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Ki kume kaba wo kume nibereceu. Kwarub kume kayo dikerti, a tiyoi dong dong dolka kumek. kom manyo dila tano bouri kabita murang dikerti ");
INSERT INTO bsj_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","tawon bouri birombo kom ciya kange cheu man neci tomange bifumer naci yaken chiko wursalima. ");
INSERT INTO bsj_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Na nyi non daten mokeneu in yakendi, laci yaken wari kange mo. ");
INSERT INTO bsj_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Manbou kumen kambo matiyangi Makidoniyari, wori mantinyagi Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","kangeri matin yim wi biduwar kangeri manten miyelak wi kange kom nakom tikang ye kange yammimbo, fiye mi yakenti wiyeu, gwam. ");
INSERT INTO bsj_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Ma cwibon tokom kumeni biduwar. Micwitin tuu kumeni kange kom tano Tee kwama ciyari. ");
INSERT INTO bsj_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Dila manti Afisus in lam kume fentakos. ");
INSERT INTO bsj_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","La cin wommen nyiloko kuyakuyau nob kiyebo wi ducce tak. ");
INSERT INTO bsj_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Kambo Timoti ou yafi fulang ka more kumeri, kambo nagen Teluwe cimati nawo ni matiyeu. ");
INSERT INTO bsj_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Kange a cwekancore. Komti kanco mor yamece kinero fuwor, naci yilam minen Wori minto nure bokacekti kange kebceb. ");
INSERT INTO bsj_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","kange ker kebo Afolosero, Min neco bikwanerer a yakumen kange kangneu. Dila manici ciya bokakoti nawo. Atim bou kumen tano kwama bokaceko lauri. ");
INSERT INTO bsj_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Kom yiki bati ko ti yora mor bilenke, komma na nabarub, kom yilam kibi kwan. ");
INSERT INTO bsj_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Kom madikero kom matiyeu kwarub mor cwika ");
INSERT INTO bsj_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Kom nyimom nubo lo Sitefanas ce ter yiloko Akaya, lacin neken dor cero cima nob kwamabo wucakke nangenti. Naweu mikenkomti, kebmibo. ");
INSERT INTO bsj_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Kom bwangten dir ubo wuro kange birombo matikaliti mor nangenne cokkangti wari kange komtakeu. ");
INSERT INTO bsj_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Min ma nero fuwor kiboka Stephanas, kange Fortunatus, kange Achaicus. cin titi nyi yowo kom manifeu. ");
INSERT INTO bsj_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","La cin yobmen yuwa tangbe miko kange kumeu. Naweu, kom nyom nob na birombo. ");
INSERT INTO bsj_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Ki kwama Asiya yarumkomti. Akila kange Bilkisu, wari kange ku kwama lociyeu yarumkomti kiden teluwer. ");
INSERT INTO bsj_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Kebbeb nob kwamabo gwam arumkomti kom yarum bwiti ki korkankako wucakkeu. ");
INSERT INTO bsj_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Mo Bulus, mi mulang wuro ki kang mik. ");
INSERT INTO bsj_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Tano kange cwibo Tee kwamari a yilam cilumcile. Teluwebe, bou! ");
INSERT INTO bsj_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Luma teluwa Yesu ko ati kange kom. ");
INSERT INTO bsj_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Na weu cwika miko ati kange kom gwam mor Almasiya Yesu. (Ati nyo) ");
INSERT INTO bsj_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Bulus nii tomange Yesu Almasiya ki maka kwamak kange yii be Timoti, a ne bikur waber kwamaro wo korintiyawa, kange nubo bwang kwama nin tiyeu gwam mor cinan loro Akayau. ");
INSERT INTO bsj_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Luma kange yim fuwor nerem fiye kwama Tebe kange Teluwe be Yesu Kristi. ");
INSERT INTO bsj_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Kwama Tee Teluwe Yesu a fiya duktang ka, cho kwama cini, kange dangne. ");
INSERT INTO bsj_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Kwama ne bo dangne mor kalaka beko nen gwam, na bo ne nubo buro mor kalaka dangne gwam ciye. Bo ki ne tangnim bo dangne ki dangne wo kwama nebeu. ");
INSERT INTO bsj_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","No kambo dotange Kristi yokten kerbereu, la nyo bii neeri beu an yokten mor Yesu. ");
INSERT INTO bsj_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","La bwentano bo nuwa dotange tiri, na birom neeren bem bo ce kange cerka bek, la nyo na yo bim neeri ker birom nee kumen. dangne kume ma nangen ti na ko bim neer ki dotange wo nya nuwau. ");
INSERT INTO bsj_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Yoneeri yeu, kumeneu man ki mokka wori nyon nyumom kambo bi wari kala kako nineu nyo ba yii ti wari mor birom neerem nyemtiye. ");
INSERT INTO bsj_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Nyo cwi kombo ki bwini nyomka, kebmibo ki dotange wo fiya nyo Asiyau. Chin furankam nyo, wo cum bikwan nyere, wo nyo cokum neer nyan ma dumeu. ");
INSERT INTO bsj_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Bicom nyon nuwa warker bwarer dor nyer bwi nyo katiyico nyo kin nyo. La nyeu kwama nin niwo kung nubo bwiyarangumeu. ");
INSERT INTO bsj_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Con ckumbo nyi bware bwirko nin, con cokten bo tak. yoneri be kino cinen ayila cokten bo. ");
INSERT INTO bsj_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","Can ma wo kambo ko tikang nyo ti mor dilou. nubo ducce an ne buka kangek ker nyer, ki luma nee kaka ko nee nyeu mor dilo nubo kila-kilau. ");
INSERT INTO bsj_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Dike bwi nyo cukti yeu co wo: War ke dume neeyeu nyoki ya wucak kange yimbo ken mor kwama, fou dor bitinerowo. Nyo ma wo kange kom kebo mor nyom ka ko dor bitinenrowo. ");
INSERT INTO bsj_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Nya mulang ki membo dike mani ka kiyeti kaka ka nyomtiye, miki yoneri mwan nyumom gwam. ");
INSERT INTO bsj_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Na wo ka nyumom nyo bi duwareu, kan ma bwi ki nyo ki diye bouka Teluwe bek Yesu, Na- wo ma tiki komeu. ");
INSERT INTO bsj_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","Ki ciyaka kowo mi ciko nhyeu, min curi nan bou kumen ki kabak, na yarume yobeu na makumen nangen. ");
INSERT INTO bsj_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Ma ywabwiti nan yarumkom na ma yaken ti- Makidoniya ri, nan yarum ten kom nan yilau Makidoniya ri, na ko toum ye na ma yilaketi yahudiyari. ");
INSERT INTO bsj_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Kambo ma kwati na weri, kwa neeri ka? ma ki ywel diker cuwaka nifirek, kambo ma yiti ong-di- ong o-ong di -o-ong, ciko win? ");
INSERT INTO bsj_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Na wo kwama nii bilelnkeu, ker nyero kumeneu ke bo ong kange o-ong. ");
INSERT INTO bsj_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Wori bi bwe kwama Yesu Kristi wo Silbama, Timoti kange mo nyo yi kom ker cer tiyeu, kebo ong kange o-ong. ");
INSERT INTO bsj_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Wori mor kwama cinen gwam ong- more ce, nyori fiye co wiye bo touti ati nyo mor duktangka kwamak. ");
INSERT INTO bsj_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Na weu kwama nyumom bo nye kange kom mor Kristi, con cokum bo. ");
INSERT INTO bsj_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","Con kwa kang bek dor ber ne bo yuwa tangbe kwamak mor neere be nyi dike wo a ne bo tiki bwiyeu. ");
INSERT INTO bsj_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","La man co kwama na nii warker mi, dike bwi ma bou bo koritiya na cier kom. ");
INSERT INTO bsj_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Wuro kebo na nyi yilam teluwe bilenkerer kumer, la nyeu bon biyitob kange kom, bilanka kume ko, kambo ka tii mor bilenker kumero nineu. ");
INSERT INTO bsj_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Co nyori man warum ki bwimi, mani ma yati kumen tak, ki dariko wo bwai bwayeu. ");
INSERT INTO bsj_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","nan kang kumen neer di, we a ne ye bikwan neerer tiye, na kebo co wo ma kang ten neeredi? ");
INSERT INTO bsj_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","Ma mulang kumen na wo ma maneu, nan bou kumen di in fiya kang ka neerer fiye nubo wo a fou men neer tiyeu, man wi kibi kwan nerer kumen gwam, fou neerer do ma cikeu, cokumeu gwam. ");
INSERT INTO bsj_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Ma mulang kumen mor kalaka kange kang ka neerek, kange mwem nuwem ducce. mani ma cwiti kang kumen neer tak, La nyeu na kom nyumom cuwaka cwika kume min cikeu. ");
INSERT INTO bsj_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Na kange bou ki diker kangka neerek di kebo ka mo ki kwami co maten tike we, la cnga ko kange ri na kang kumen degwam. ");
INSERT INTO bsj_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Mwerum bou ka ma nii wo nineu, cuwati. ");
INSERT INTO bsj_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","La naweu kebo mwerum, kom cutang cinen wi. kom bi cinen neer ko mani nhyo katiyilo fir neerer dur cengem co. ");
INSERT INTO bsj_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Ma yii komti ko nung cinen cwika kume ko nyang lang. ");
INSERT INTO bsj_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","on co dike bwi ma mulang kumeneu nan cuwa kom, nan nyumom keno kom nob bwangkab di. ");
INSERT INTO bsj_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Na nii ka cutang cinen wiyeri, mi keneu man cutang cinen wi, dike ma cutang wiyeu, na man cutang kange diker wiri ker kumer kabum Kristim. ");
INSERT INTO bsj_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","Won yilam nyo kati bwekelkele bolbo, wori ba man ki kwomtom ki yulsn cero. ");
INSERT INTO bsj_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Kwama wom men nyoliko kambo ma bou taru wasa ma ne fulen ker Kristi wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Ki curo gwam neer miro dabo, wori ma tobo yimi Titus wi. La min dobum ci min yilaken Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","La buka kangek fiye kwama wiyeu wo nebo turani ti mor Kristi kir kir ker nyer ca wa kun finager nyom ka ce fiye gwameu. ");
INSERT INTO bsj_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Bo kun do ficangeu kwama nin mor Yesu. mor nubo buro fulociyeu, kange biro bwiya ti bwiyau. ");
INSERT INTO bsj_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Nubo biro bwiya ti bwiyau kunficanger bwarer yang ciko bwar. Buro fulo-ci ti fuloweu kun ficanger dume yang ciko dume. wedaten dike burowe? ");
INSERT INTO bsj_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Bo kebo na tangnin nubembo buro miyeker kwamar ti na ci fiya ki mwemeu, la nyeu ki neero wucakey bo tou ti mor Yesu na wo kwama toum beu nuwe kwama. ");
INSERT INTO bsj_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Ba ter wabka dor berek tak ka? nyo cqwi bo warke kumen kaka nyinen na mo tangim nobembo matiyeu, kebo nya? ");
INSERT INTO bsj_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Kom ki bwikom kom warke nyeu mulangum mulange mor neere nye, wo nubo gwam nyumom la ti kiyei. ");
INSERT INTO bsj_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","kom nungi kom warke fiye kristi wiyeu nan nangene nyero, mulangbo ki kwekwe, la mulangum ki yuwa tangbe kwamako ki dumeu. mulangbo dor teret, la dor neere nifirer. ");
INSERT INTO bsj_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Won cho bikwan neerero nyo ciko mor Yesu kabum kwamam. ");
INSERT INTO bsj_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Nya manki kange nyumanka dor nyere wo nay yi ti nyoka kange diker bou nyineneu nyomka nyeko ki na kwama nen. ");
INSERT INTO bsj_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Kwama mani nyo yilam canga nyumangum nyumange, wo noro fwirko ce. Noro wo kebo mulangkako ce, la na yuwa tangbe ko ce ne dume tiye. ");
INSERT INTO bsj_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","nangen do wo bou ki bware, mulang kin kwekwe dor terer. Bouki duktangkako wo Israilawa mania to Musa ti tikob cerue, won cho duktangkako diti diyeu. ");
INSERT INTO bsj_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","La nagen duktangkako yuwa tangbe ko a yilam nyi? ");
INSERT INTO bsj_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Na naweu do diti diyeu wiki duktangka ri, La nyi wo bilenkeroceu, a fiya duktangks tiye? ");
INSERT INTO bsj_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Kwa neere man ki dike wo kwati bo to cho ki duktangka, la man ciko wuro nineu co duktangkako wo cum ceu. ");
INSERT INTO bsj_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","La no wo cukeneu wiki duktangkari, la a fiya nyi wo naceu ki duktangka keu? ");
INSERT INTO bsj_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","La bon wiki yorneri weu bo wi ki bikwan bwir. ");
INSERT INTO bsj_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Bo kebo na Musa wo cumom tikob ceb ki lalan kati israilawa to tikob cebo miblangti miblangeu. duktangkako wo cuti cuweu. ");
INSERT INTO bsj_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","La neer ciyero kwamangum duwal na ci kiye noro carko ri yilam ko ciyam tikobeu, wi duwal kwalbo, la fiye Yesu ninen ki kwace a kwaltiye. ");
INSERT INTO bsj_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Bwentano duwen na cin kiye Musa ri, yilan ko cumon neer ciyero. ");
INSERT INTO bsj_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","La nii yilaken teluwe nindi, yilanko cuwon kwalum. ");
INSERT INTO bsj_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Teluweu co yuwa tangbeko fiye yuwa tangbeko wiyeu cerkawi. ");
INSERT INTO bsj_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Na wo gwam be, tikobo combo comeu bo to duktangka teluwe ko ti. Fulongum bo mor duktangkako cho win, ki yim duktangka kabako yaken ciko wuronin. na wo Teluwe nin co yuwa tangbekeu. ");
INSERT INTO bsj_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Wori bo wiki nangen take kambo nyo yom yireduwe nyo cat bo. ");
INSERT INTO bsj_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Nyeu nyo dubom nure na kwenduwe ce gwam, kange wo yurangum, yurangeu, mani nyo yi yim bicirenne, take nyo tabo ker kwamaro ki bilangiya, fiye tokka bilenker, nyo ne dor nyero fiye nobo wuyenin gwam kabum kwama. ");
INSERT INTO bsj_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Di tano fulen keret kwamaro nyero cumom cumeri, cumom cume fiye nubo bwiyati bwiya nine. ");
INSERT INTO bsj_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","kabal ciyero, kwama dor bitinenrowo ciyam nerciyero bwini neka bilenke. ");
INSERT INTO bsj_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Ma nyo tok ker dorcer nyer, ka Yesu, Almasiya ni Teluwe, nyo keneu canga kumek ki ker Yesu. ");
INSERT INTO bsj_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Kwama co nii yiki, Filangko an tiba mor kumtacile! an tiba mor neretbe na ne filang nyomka duktangka kwama kabum Yesu Almasiya. ");
INSERT INTO bsj_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Di la bo wiki cweka cer more ronin, wo a yilamti nyanklang yiti wo la dure bi kwan na kwama ce, kebo nabe. ");
INSERT INTO bsj_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","bo nuwa dotangeti nure nin gwam, ci woo nyobo gwam. Nyon cwam tai di la nyo cok bo ner. cin ne nyo dotange, dila ci yal nyo bo. ");
INSERT INTO bsj_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Ci ne nyo dotange, di la ci merang nyobowi, cin buk nyo di la nyo kayabo. ");
INSERT INTO bsj_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Nyeu kicatec nyo tum ki bwar Yesu mor bwiye nye, na fwetang yim Yesumbo mor bwiye nye tak. ");
INSERT INTO bsj_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Nyo wo kwace ki catec ci neken nyo ti bwar kiker Yesu, na Yesu yilam nyanglang mor bwiye nye, na nii firoce. ");
INSERT INTO bsj_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Bwaro ma nangenti more nye, di la dume ma nangenti more kume. ");
INSERT INTO bsj_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Di la nyo wiki yumatangbe ko wucakke na bilenkerer ce na wo ci mulangge. ma ne bilenke, ma tokki, nyo ken nyom ne bilenke, nyo nya toke. ");
INSERT INTO bsj_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","nyo nyimom nii wo ya kun teluwe Yesu kristi mor tuwe, a yila kun nyo wari kange Yesu. Nyo nyimom an yobe wari kabum cem. ");
INSERT INTO bsj_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","dikero gwam ker kumer bwiye, fiya co wa lumako nubo nin kila, neka buka kangek yokten duktanka kwama konin. ");
INSERT INTO bsj_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Nyo dila nyo cwa bo, duwale kale nyo kayatiye, mor co fulong nyoti kicatec. ");
INSERT INTO bsj_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Di la na wori dotange bi dobe ywelnyoti na tutum duktangka wo bakni bakece wo cum cuwaka. ");
INSERT INTO bsj_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","wori ma nyo to dikero wo bo totiye ti, dila dikero ma bo tiye mani bakni bak, wo mani bo totiye co banki bako ce. ");
INSERT INTO bsj_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Nyo nhyimum tano buwe wo bbo yim wiye wurom di, bo wi ki mukako kange kwama nin. Luwe wuro kebo kange muwe, luwe bakni bake mor di kwama. ");
INSERT INTO bsj_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Wori mor bwiye wo boti tinangi, bo ningtangti a du binen ki fiye yime be wo dii kwama. ");
INSERT INTO bsj_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Bo nintang woti, ki fiye bi duro mani a fiya boti kwancer. ");
INSERT INTO bsj_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Di la nyomanka man kambo bo mor bi kure, bo tinanti, bo ki tutum. ma nyo cwi yim fobka. Nyo co nyo cwi a dum nyo, na dume mim dike bwiya tiye. ");
INSERT INTO bsj_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Ni wo ywel nyoti na dikece kwma. nii wo nyo yuwa tangbeko wucak na nor dike botiye. ");
INSERT INTO bsj_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Di la na nyo yilam kibi kwan bwen fiyandi, Bo cubi kambo bo lika mor bwiyeri, bo kutan kange Teluwe. ");
INSERT INTO bsj_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Di dor bilenke bo yakentiye, ke bo na toka nuwekoce. ");
INSERT INTO bsj_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Nyo bo wiki bikwan na bo yalkangum kange bwiyo, be na bo yi wari kange bwiyo, be na bo yii wari kange Teluwe. ");
INSERT INTO bsj_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Nyo tii nyo yilam tennaka, bwen nyo mor bwiye kaka, kutarn na nyo lomco. ");
INSERT INTO bsj_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Wori tamyo gwambe bo mwerkangi kabum fiye yim liyare bulange Almasiya, be na gwam bo yo nyi cha mane mor bwiye, bwen na ken kaka na bwir. ");
INSERT INTO bsj_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","Wo nyori, ba nyomom tai Teluwe bo kwou noboti. Kwama to boti twelum. mi kwati nyo ken twelum mor nere kume. ");
INSERT INTO bsj_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Nyo kwob kombo be na kom to nyo na nobo ken, nyo nyokin yi la kumen fiye firka, be kom fiya dike ka kar nubo wuro tuu dor chiyero na kange diker, dila kebo nyo mor nere. ");
INSERT INTO bsj_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Tano nyo cherum mor nyomka nyeri, kwama bwi nyo mane. Tano tak nyo mor nyomka nyeri, ker kumer bwiye. ");
INSERT INTO bsj_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Wori chika Almasiya dok nyo, be na nyo nyomom wo, nii win wor nubo gwam byiya. ");
INSERT INTO bsj_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Tak Almasiya biya dor nubo gwam, na wuro kwar cheu, a yire yila chiya yire na dorchero che. nyeu chiya yi yimbo daten na cheu wo bwiya yila chi kungum che. ");
INSERT INTO bsj_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Ki kero wo, naweu ma nya ma kange nin bulmag ti ki chuwa bi bwe nifire nin, bwen dwal biye nyo to Almasiya nyeu na weu nyo yiloten maka kange nin bolange nyo. ");
INSERT INTO bsj_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","nyori gwam wo mor Almasiya, nii fwir, dikero charko chum. To yilamk afwir, ");
INSERT INTO bsj_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Gwam dike buro ki no kwama nin cho ci fuwa ywelbo ki bwichi fiye Almasiya nine, yila ne bo nangen ywelka. ");
INSERT INTO bsj_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Mor Almasiya kwama fuwa ywel kale fiye chine neu, mani ki kiyeka bwiranke chiye dor chir. Dob binen tomange ywelka. ");
INSERT INTO bsj_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Nyo cin chokbo nob tomange Almasiya, nyo mwini kwama cho nuboti fiye bineneu. nyo ken komti ki ker Almasiya kom ywelum yimkumenbo kange kwama. ");
INSERT INTO bsj_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Cho chi fo Almasiya na yilam twika kunek ker bwiranker ber. cho nii mambo bwirangke wiye. Ma nyo na bo yilam wucak na kwama. ");
INSERT INTO bsj_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Bo man nangen do ti wari, maken kom yore, luma kwamako ki bilangiya. ");
INSERT INTO bsj_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Chon toki, ma nuwa fiya luma nawo neyu fuloka man tikankom, nawo luma, to na weu kakuk fuloka. ");
INSERT INTO bsj_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Nyo yobo ter kotangka nure kange nyo cwibo nangen nyero a yilamn abwir. ");
INSERT INTO bsj_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Nyori nyon nung dor nyero nangen nyeronin, nyo channgha kwma. nyon changa che fiye mwirumka, kalaka chotaka, dotange. ");
INSERT INTO bsj_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","Bibukar, furcuna, kyan mor nangen kamboken, mor bwini dume kangem kumentin, mor wura. ");
INSERT INTO bsj_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Mor wucakke nyomka, birumne, ken mor yuwa tangbe wucakke, kange cwika na bilenkerce. ");
INSERT INTO bsj_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","Nyon canga che mor bilenke, mor ciya kwama, nyo wiki kulen kwener na wucakke che kan nyek chatiyer kange mok. ");
INSERT INTO bsj_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Nyo ma nangenti mor bwayilene kange bwini bwayilene, koka, kange chaklangka. chi torang nyoti ki nyo nob bi bolere nyo gwam nyom nob bilenke. ");
INSERT INTO bsj_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Nyo ma nangen do ti tamwi chi nyom nyobo, wo nyo nyomom nyome, chine nyo ma nangenti na nubo bwiyam me, di wo nyo kwarche, nyo manangenti na nobo chi mwatiten bwolnage, dilakebo mwatika bwokang twalka. ");
INSERT INTO bsj_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","nyo managenti na nubo ki fir nenerede, nyo ki fwor neret kangkang, nyo ma nangenti na no nob fuwayeb, wiki diker gwam. ");
INSERT INTO bsj_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Nyon yikom bilenke gwam korintiya ner nyero wumom wome. ");
INSERT INTO bsj_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Nyo kwarbo ner kumero, kom ko kwaryinen nerkumero. ");
INSERT INTO bsj_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Naweu mor cheltangka ko nyeu, ma tok kerti kange kom nyo nabi bei kom womyinen ner kumero. ");
INSERT INTO bsj_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Kom yiire wari kange nubo nebo bilenke, naniyak ye tiber wucakke kange bulange? kaka takeu naniyak yee tiber filanger kange kumtacile? ");
INSERT INTO bsj_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Chiyakankako wini tiber Almasiya kange bwekelkele? Yee mwerkang nubo ne bilenke kange nubo nebo bilenke? ");
INSERT INTO bsj_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Takeu, chiyakankako wini cheu. bonbikur waber kwamaro ki dume, nawo kwama tokeu, “Ma yii more chiye nan ya yam tiber chiyer.” ma yilam kwama chiye, chiyan yilam nobmib. ");
INSERT INTO bsj_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Nyori kom cheru fiye chinene kom chokum bwiko, “Nuwa teluwe kom teire diker kange mani wucakke, man yoo kom. ");
INSERT INTO bsj_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","Man yilam Tee kumen, kom keneu kan yilam bibei bayilobe kange bibutob mi nen, nuwa Teluwe nii bi kwane gwam. ");
INSERT INTO bsj_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Cwika buti kambo bin wiki bilenkeu, nyori bi yulangum bwibeu ki dike wuro a knag binen bwibe tiyeu, kange bilenkebeu. Bido wucakeu mor tai kwama. ");
INSERT INTO bsj_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Kom nebo filang nyo kange bo ni kane nin ner nyo yobo kange min diker na bwirace kakka nyi ma kange min bwiran ker. ");
INSERT INTO bsj_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Kebo kiden yarka kumek mi tokki nyowo dike bwiyeu kweri min yikom miki komti wi neryer, nabi bwiya wari, nabi kweni wari. ");
INSERT INTO bsj_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Min wi ki tikali tiber kumer miki fuwor nerer kange kom. ");
INSERT INTO bsj_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Kom bo bi makidoniya bwibeu fiyabo fobka no tomo nyori, bin do mwar dotange ki nure mwanti kange kayaka nerek kace tai to yoyi nwi mor. ");
INSERT INTO bsj_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","La kwama, ni dang neri kange tikali, cinnung dangne binen ki boka Titus. ");
INSERT INTO bsj_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","kebo ki den boka cek koni kwam nung dangne ceu la ki boka Titus co nung dangne ce kimen. con nyinyo dotange cwika kimeko, fir nerer, cwemwer tikali kumero dormir. mo min ma fuwor nerer kambo ken. ");
INSERT INTO bsj_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Tano nyori tomange miyu, wo kange kimen ner, mi mabo naki min nyimin morece. La kambo mi nyimom tomange kang kimen nereu min ma naki min nyimi. di la kayaka ner kumro yabo kutam. ");
INSERT INTO bsj_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","La Caneu miki fuwor nerer kebo kiden kayaka ner kimenro dila ki kayaka ner ner kumero bou kimen fuloka. kom fiyador kumer mwar tomange na wabice, dila kom yar bo ki den nyer. ");
INSERT INTO bsj_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Kambo kayaka nener fiye kwama wiyeu bouti ki fuloka wuro bouti nure na mani mwa tok nakimin nyimi morece. ");
INSERT INTO bsj_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Ki to kambo dotange fiye kwama wiyeu bokimen cuko more kume, Miki nung dike ner kumere kom mane kom manki bwirang ke. Miki nung biduyer funer kumero, tai kumero ki dokka ner kumero kange maka diker kumero, kange bilangka kom cwiti na makuman dikero kan! wi mor diker kom manti bwirang ke wiye. ");
INSERT INTO bsj_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Tano nyori mi mulang kumeneu mi mulangbo ki den nii bwirang ke. kaka ki den niwo ci manten bwirangkeu? ma mulang diker ner kumereu na fiyam fiye kwama nen. ");
INSERT INTO bsj_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Won cho dike bwiye nyo firkome, kebo mor nangeri nye, yila nyo ma Bilang ka kambo ken ki boka Titus ce ko. ");
INSERT INTO bsj_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Tano nyori mi kung dorti ki kabum cori, mi nuwabo kwenduwe. Wi nyo na cho dike wuro nyo yikome bilenke. Bilangka nyeka na kom to Titus yilam bilenke. ");
INSERT INTO bsj_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Cwika ceko kumen wiki bidwiyer kambo cho yo nerti ker bilenke kumenko gwameu, kambo kom nyocho ki tai kange mukangka bwiyeu, fuwor nerer mi dike bwiyeu fuwor nerer miyu nyoweu. ");
INSERT INTO bsj_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Min wiki bilenke kambo ken, nero win tai mani kange kom. ");
INSERT INTO bsj_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Bi cwiti bwibe na kom nyimom kebmibbo ki tikali kwama wo ci mane mor kuu wabee kwama Makidoniya. ");
INSERT INTO bsj_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Ki kwama dotange dur wo bouwe, filang fuwor nerer kange dotange bwini ciyeu wo bouki filang nake ki kang mor bilangkako ");
INSERT INTO bsj_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","Kambo mi ne bilenke kom ne ki cwika kumek fiye fiyaka kume lame, kom ne cwika ko ki ciyaka mor nere kume. ");
INSERT INTO bsj_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Ki kinong ka ducce na fii nako noci neci filang wuro ciya yayamti mor bwangka kwama nubo manki dwikau. ");
INSERT INTO bsj_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Nyo bwiye kebo nawo nyo kwatiyeu, no tano nyori la cin ter neka dor cero wi Teluwe nen. ");
INSERT INTO bsj_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Di la nyon bwa bwiko Titus ce ko wuro kweri terum maka nange do kiden dii ka, nangendo wo mi neken biyare cunga kume. ");
INSERT INTO bsj_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Dila kom calam mwer diker kwarub, mor bilenke, mor kerer, mor nyumka, mor nangen manki luwaka mor cwika ki mek ki denyer. Tano nyori kom fiya saka kaba mor neka kumek. ");
INSERT INTO bsj_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Mi tok nyo kebo ki den mir kom ki, “bikwan” Tano ynori mi tok nyo nan cuwa bikwan cwika kumeko mi cuwati kange tanin yorka nubembo. ");
INSERT INTO bsj_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Dike bwiyeu kom nyimom ta kila Teluwe kristi Almasiya kambo nyeu ci ni cwika ");
INSERT INTO bsj_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Wi mor dikero wuro man neken yulando wo a tikan kom tiyeu. ki coru wo cumeu, kebo diker koni kom terer dila kom ma kuru na kom mani. ");
INSERT INTO bsj_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Can naweu kom takum kambo ki kaba kom nyoner kom mane ki kwama cure, dila kom ma kibwikom takum ki yulan birim maka kumeko. ");
INSERT INTO bsj_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Non wi nerkumer di, maka nangen do wori dikero ken yuk kumen tak tamnyo dong-dong dike nii cike kebo ki dike ci mani cikeu. ");
INSERT INTO bsj_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Ki den nangen dowo na tuu kumen na kangumbo na fiya yiber. Dila tano nyori na fiya yulang wi. ");
INSERT INTO bsj_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Cwika kumeko ki kwama wo caneu na fiya corka bwini. nyo tak cwika ciyeko na dol corka bwini ciyeko dike bwiyeu na fiya yulang ka? ");
INSERT INTO bsj_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Wii mulangum mulange ki wuro ciko ducce fiya bo dilka wi dikerwi yilo wuro cuka bi duware kebo diker wiin. ");
INSERT INTO bsj_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","Dila buka kange fiye kwama wiye, na wii mor nere Titus ceu neneu Bilangka toka kumeko na yilam minen kumenen. ");
INSERT INTO bsj_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Nyo la kebo ka kinongka beko koni ci yowe dila ca ma kibi com dor cer. ki cwika nere cek. ");
INSERT INTO bsj_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Nyo tano kange yice wuro ci bilang chotiye mor tiber bikur wabe kwama kiden nangen cero wo mor ker bifumer cereu. ");
INSERT INTO bsj_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Kebo kiden do wuro ki kwacho, kiden nubo bikur wabe kwama, na cin ya kange ci fiye dike cho bwi wiyeu. Won cho durko chi ne kwama kange cwika beko. ");
INSERT INTO bsj_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Nyo ki cwa kati yilo kange ni dok nyenti bwirang ke wi mor tikali kume nen. ");
INSERT INTO bsj_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Won cwika yek na nyo ma diker kebo kabum Teluwe ki kwaco, Dila kabum nubem bo ken. ");
INSERT INTO bsj_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Nyo yila nyo tom yii ye wari kange cii kutangi ki cuwaka cek. tak nyo fiya co ki tikali kambo ken. can neu tak cin wiki bikwan fiye mo wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Dila Titus far nangenne mi, kange nii nangene mwe. Chi bibei tomange chi twom che. ");
INSERT INTO bsj_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Tano nyoriKom nug cinen cwika kumeko kati yilo tak nakom nung bikur wabero dike bwi fuwor nerer kumeu wari kange kumeu ");
INSERT INTO bsj_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Kiden nangen kwama na nubo buro manki dwitiye kebo na cho minen na mulang mwen. ");
INSERT INTO bsj_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Min nyumom kuru kume wuro mi ma kungka dor cike kabum nubo Makidoniya. Min nyikom ki choro wo cumeu kweri chi yim ki bati kero. Bikwan kumero kangem kumembo doo maka nangen. ");
INSERT INTO bsj_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Di naweu min twom kumen kebbebo na kati yilo kung ka dorek kumeko kati yilam manki tuwerker cer. dike bwiyeu nakom yim ki bati kambo ma yi kom noo ka matiye. ");
INSERT INTO bsj_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","No tano mani nyori, no kange mor Makidoniya bwangum ten con yumom kom yibo ki batiri, mani nya nuwa kwenduweti na kange kume dike bwiyeu. ");
INSERT INTO bsj_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Dila ma to nyori daten di tung kebmibbo ciya bo kumen kati yilo kwama kene lam. Kom yulangum ki den dike kom yoo nerkumereu. Yilam nyo dike bwiyeu na ywelum kiden neka diker na chaka kabace kebo diker charikar kibikwan. ");
INSERT INTO bsj_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Kero wuro niwo fii -fik ki cwika chekeri a biye ki cwika cek, Niwo fii-fik nero keneri a biye ki caklangka. ");
INSERT INTO bsj_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Gwam kume ka merang kambo kom cwi mor nere kumeu. Mani mwa neti ki kangka nererk yilo tamwi ci dok nen ki bikwan, La nyo kwama ki cwi niwo ne ki nero fuwor. ");
INSERT INTO bsj_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Kwama wi ki bikwan dog ka dike kom nerangeu, na bwiki den kumer, dikero bwiyeu mwo dikero nin gwam, kom fiya na yilam kiden kumer kange nangen kumer. ");
INSERT INTO bsj_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Nyo na wuro ci mulange, ti kan cwika ceko, ne kiden nubo mani cekeu, liyaro wi man ki diker. ");
INSERT INTO bsj_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Ki nii wo doh dum diker na fiiyeu chati fiya chari, la chan fiya dum dikembo ducce wo cha fiitiye. chati yuk nubo ki bilenke nenten ki kwama biyeka kange nubo manki bwarangkeu. ");
INSERT INTO bsj_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Mwan fiya diker kangek fiyentano mwa ma diker wiyeu, wuro a yilam ki buka kangek kwama fiye nyo wiyeu. ");
INSERT INTO bsj_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Maka nangen nebo kebo ka wo mwa ma nubo wo cwitiyeu, kange nubo ne bilenke tiyeu. Manten ki nure wo mwa buo kwama nen kang tiyeu. ");
INSERT INTO bsj_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Dike bwiyeu chin cuwam nen, chin ciya kange nangen mwero mwan fiya chalangka kwama ki bilenke mweu kange yiloka mweko fiye wabe kiristi. mwan chaklang kwama tak. ");
INSERT INTO bsj_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Chiya kwob kumen dilo kange bilangtum dikero kom maneu. ");
INSERT INTO bsj_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Buka kangek kwama nen ki dike bwiyeu neka cheko kabum chem kange fwetang ka cheko. ");
INSERT INTO bsj_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Mo Bulus ki bwimi ma kenan komti ki lomchome kange dangne Alamsiya. man wii ki tiber duwe fiya ma wari kange komme. Di ma ki bikwan bwiyer kumen fiya ma man wari kange kom me. ");
INSERT INTO bsj_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Ma ken komti fiya ma wari kange kom me, ma chwibo yilam ki kun ka duwek, Di ma toti man do na yilam nii kibikwan bwiyer, fiya ma kwabkanti kange nubo wo kwati tamwi nyo yim mor bwiye. ");
INSERT INTO bsj_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Bwen duwal boki yaa mor bwiye, kwen bero kebo na bwiye che bo matiye. ");
INSERT INTO bsj_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Kulen kwenero bwo timti chikeu kebo na bwiyale che, nyiyo chuwa, kulen kwener kwamar kibi kwan bukchanka bikwanti bwekelkele, chi tungum kwobkanka wo bouti ki tiyanka. ");
INSERT INTO bsj_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","Bo bukchangum dikero ti gwam, wo ma kiyeti kange nyomka kwama. Bota bulanka kowo boti ki nuwaka Almasiya. ");
INSERT INTO bsj_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Bo yimki bati na bo warum nagen na kwenduwe ce, ");
INSERT INTO bsj_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","To dike chi yo kabum kume twelume. Tano kange cho nyomom na Almasiya che cha kulom dorcero nin kambo cho na Almasiya che, kambo nyo, nyokene. ");
INSERT INTO bsj_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","Bwen man kwila-nge ki bikwando nyo chike, wo Teluwe nee nye be na nyo firkom, kebo na nyo werum kom chiko, mani ma nuwa kwenduweti. ");
INSERT INTO bsj_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Ma chwibo tamwi maki nekom tai kibi fumer miro. ");
INSERT INTO bsj_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Ka-ngem nob yiti ki, bifumer chero kibikwan kange neeka taiyek, di mo too chori mwini man kibi kwan, ker chero kebo na nuwaka che. ");
INSERT INTO bsj_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Nubo chuwo na nyimom, kero nyo tokti morbifumer fiya nyo maniye, nyo nya matiye tano nyo wiri. ");
INSERT INTO bsj_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Nyeu nyo mwerbo dor nyer kan-nge niikan-nge chaklang dor chertiye, dila chi nungkan dor cherti bwiti chi, chi manki nyomka. ");
INSERT INTO bsj_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","Di la ma nyo kwilang bwiti chum bikwane, nyo cho nya ma chwati dike kwama yo nyo mane, kambo a lamti kume neu. ");
INSERT INTO bsj_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Di la nyo chubo kambo nyo lam kumene. Nyo kabako nyo lam kumen ki fulen keret Almasiya. ");
INSERT INTO bsj_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","nyo kwilang bo bwi wo chum bikwane ki nagen ka-ngem nob nyeu nyo chwiti bilenke kume na yokten, na chunga nangen nyero womten kamboken, dong dong yika cheko nin. ");
INSERT INTO bsj_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Nyo chwiti na chuwo na nyo yaken ki fulen keretdo, yarentinimbo kab kan-nge kommeu, mani nya kwilan bwiti beti ki nangen do ma fiye nii kan-nge che. ");
INSERT INTO bsj_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","Di gwam wo na a kwilang bwitiyeri, cha ma mor Teluwe. ");
INSERT INTO bsj_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Kan -nge nii man wo a war dor chero ninti cho chiya-chiya. Di na wori, la kawo Teluwe warker dor chereu. ");
INSERT INTO bsj_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ma cwiti kom bwam neerkumer kange mo mor kulene bidom bwentano duwal kom bwaneer ti kange meu. ");
INSERT INTO bsj_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Wori min ma korti ker kumer, kor miro na kwama ce kumeno na korti ker tu kumen mor naka nii na baroko wiyeu. Man tum nor na nung kom na bubiya cak-cak kabum Yesu. ");
INSERT INTO bsj_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","La ma cha tai kumeti kangeri nawo nasuwe boul hauwau weu, ki yulan cereu, yilo neer kumero yilam neka duweko kendo Alamsiya nin. ");
INSERT INTO bsj_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","kangeri, nii kange bouki fulen Yesuro kange kebo wo yi komker dor cereri, kaka kom yo yuwa tangbe kange ki dimen kange wo ka yo kabari, kangeri, kom yo fulen kero kange ki dimen kange wo ka yo ki kabau, ciyakako ma dike biro ninenu lam. ");
INSERT INTO bsj_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","Min kwatiri, min kebo bwiko wo mor nubo biro choti ki nob tomangebo dure. ");
INSERT INTO bsj_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Bwen tano ci merang bo tokka keret di, ma manki bwini mwerum mor kiyeka. Ki nure gwam la dike bro gwam nyon kwulum kumen. ");
INSERT INTO bsj_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Mama bwirang ke ka wori man cwuwe kangum dor miro na ko fiya duktangka? wori man yi kom ker kwamaro koni. ");
INSERT INTO bsj_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Man ma tangnim kumenbo kuwabembo nin kwi kiyoka tikali ko cinen nan makumen nangen chiko. ");
INSERT INTO bsj_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Fiya co mikange komeu min fiya dor miro cwika ma yobo kange nii nin tuuka. wori kebbebo bou Makidoniya cor min bwini mito mor die gwam nin cokum dor mir katinyila kumen tu'u tum. Man ca kaba ki makanyo. ");
INSERT INTO bsj_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Na wo bilenke Almasiya more miyeu, mani ma kwomti ki tokka kowo mor biten Akaya gwam. ");
INSERT INTO bsj_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Ye bwiye? wori ma cwikomba? kwama yumom. ");
INSERT INTO bsj_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","dike ma maneu, ma makan co cuwo. Man ma nyo na kisim nubo bro cwiti na cin fiya filang na ci yilam na nyo mor dike bro ci kung dor ti cikeu. ");
INSERT INTO bsj_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Nubo bro nob tomange cwerke, nob bibouler, ci tu dor cero ti na nob tomange Almasiya. ");
INSERT INTO bsj_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Won diker nyuman kar wori bwikelkele tu dor cer na nii tomange wucake filang. ");
INSERT INTO bsj_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Kebo diker nyumankaro dur na canga ce an tu dor cer na canga cak-cakeri, bwiko ciko a yila dong dong kange dike ci maneu. ");
INSERT INTO bsj_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","man yokten tokkako. Kange a tuyere na kule, na kom kwa neer nyori, ko tuye min kule nan kungum dor ciko bi dob. ");
INSERT INTO bsj_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Dike ma tokti dor woreu kab-kab ni kung dor tiyeu kebo ki ciya Teluwek, la maki tok kero na kule. ");
INSERT INTO bsj_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Nubo ducce kung dor ti mor bwiye, man kungi ken. ");
INSERT INTO bsj_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","Ko bilangti na ko mwerkang kange kuletini, kom nob yileneb. ");
INSERT INTO bsj_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","Kom ma dangne ti kange wo a yilam komti cangau, naco yilakangum komri, coki ma nangen ki kom na co fiya, na co kung dor cer di, kaka co kwa kom ki kang ka tikob. ");
INSERT INTO bsj_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","man nii tok ka nyon nuwa kwenduwe wo nya fiya bo bi kwan na nyo kumen nyeu. ");
INSERT INTO bsj_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Cin Yahudawa ka? mo kenenu nyo. cin Israilawaka? mo keneu nyo. Cin Naniyak Ibraniyawak ka? mou keneu nyo. ");
INSERT INTO bsj_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Cin canga Almasiyak ka? man tok kero ti mwini ma man mor nee mi. man la ci. man ma nangen kibi kwan ki Fusuna, kibi buker man ki kiyeka, ki toka bwarek ko wo kila kilau. ");
INSERT INTO bsj_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Kom yahudawa Kristi to nung ci malliye kwini naar win mani. ");
INSERT INTO bsj_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Kiristi ta'ar ci mwek kangeye ki dange. kirito win ci mobang ye ki tere, kiriti ta'ar nabire mwenge win mor ki me. man dam kume win kan diye win mor wima. ");
INSERT INTO bsj_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Man nuwa ki yarang ka yamek, mor dotange caji mor kishika nob kubek. Mor dotange fiye nob mibo wiyeu, kange dotange fiye nob kumtacille neneu, dotange mor cinan lore, dotange mor yerake, mor dotange wima, dotange yitob cwerkebe nin. ");
INSERT INTO bsj_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Man fiya dorminro nagen do bwaiye ki mukki mor kume ni kila manki dum, mor wura kange dilo mwe, mor yim dilomwem, mor dula kange bwini kulen tukar. ");
INSERT INTO bsj_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","Kebo kawo tukako wi dor mir kito tes ki kwomka duwemiko dor ku wabetini. ");
INSERT INTO bsj_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","We yibere, lami ma yilabo yiber dor cere? we ci dokco yare di, buwa yebe? ");
INSERT INTO bsj_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Na man kun dor di ma kung dor ki dike nung bwini bikwane mitiyeu. ");
INSERT INTO bsj_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Kwama kange Teluwe Yesu Kristi wo chin wab bakeu, nyumom kebo cwerke ma cwere. ");
INSERT INTO bsj_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Mor Dimaskus nii durko tam ciko tob kange liya Aistas doki a to cinan loro Aristaseti na ci tamye. ");
INSERT INTO bsj_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","La ci do kuye cerange mor bulene ci meru ye bwilom cinan loro, nimre ma ceri kange ceke. ");
INSERT INTO bsj_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","man kung dor miro bwenno manki yokka dikereu, la man ca kaba ki dukum bo yau Teluwe wemineneu. ");
INSERT INTO bsj_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","man nyumom kange mor kiristi, coti to kwob cilombo na'ar cumeu, keno mor bwiyeri, keno kebo mor bwiye ri, ma nyombo, kwama nyome. Cin tum co yaken chiko dii no bwiri keno mani bwiri, kwama nyumom. ");
INSERT INTO bsj_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","La man nyumom niiwo, keno kino bwiri keno mani bwiri, kwama nyumom. ");
INSERT INTO bsj_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","Cin tum co yaken kico firen kwechang la con nuwa duktangka dikero brombo nii dol min tokka. ");
INSERT INTO bsj_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Ki ker nii wo man kung dor, la ki ker mir mani ma kung dor ti. Na kebo ker cune mirdi. ");
INSERT INTO bsj_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Na ma cwiti na kung dor di, mani ma yila kule ti, wori ma tokka bilenke. La man dubom kung ka duweko, na kange nii kware ki mo cum dike co tomineneu kange wo ca nuwa mineu. ");
INSERT INTO bsj_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Man cwam kung ka duwenin ki dukumbo kwamero bro. cwiyak mor bwiye neye, nii tomange bwekelkele nin na neye dotange, nan kung re dor minro. ");
INSERT INTO bsj_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Kirito ta'ar ma ken Teluwe ti dor wuro na co tum wo minen. ");
INSERT INTO bsj_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","La yiye, luma miko cuwa mwenti la mor cune bikwan ki dire. la ma tum kungka duwek mor cunermi. Na bikwan Kristi ro na yiti minen. ");
INSERT INTO bsj_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","La nyeu, cuwamenti mor cune, mor cuwe kangka mor dotange kuka kange bwentano fiyang ma kwaberi, ma kwamer. ");
INSERT INTO bsj_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","man yilam kule kom ko dok ye nye. na daten fiya caklangka kumeen. Wori ma kebo bwiko mor nob tomange bo, bwentano ma kebo diker duwaleu. ");
INSERT INTO bsj_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","nangen nob tomangebo mani more kume, ki dangne, yirom kange nyumanka. ");
INSERT INTO bsj_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Ma nyi ka yila kwame mor kuni wabeninen, wori ma tu'u kumenbo ka? ");
INSERT INTO bsj_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Ko to man ywelbwi nan bou kumen kiriti ta'areu, mani ma tuu kumenti, la ma dike kange wo na kumeu, kom ma cwitiye, la kebo bibei ayo tebbonin tiye, teb anyo bibeiyo nin tiye. ");
INSERT INTO bsj_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","Man bilangi tikangkom bwen tam neken dume miri, na man cwikomdi. mo ka cwiti bi dobeka? ");
INSERT INTO bsj_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","La na wo nyeu, ma tuu kumenbo kambo man nii yulaneu, mo ma buol kome. ");
INSERT INTO bsj_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","La man tuu kumen ki kange yibe ma tunguwe? ");
INSERT INTO bsj_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","man ken Titus na ya kumen, La man twom kebe wine na ya kange co. Titus tuu kumena? kebo mor yuwa tangbe ko win bo yati kange kome? kebo mor na win bo yati kange kome? ");
INSERT INTO bsj_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Kom kwa tiri na kwome wo nyoki wengang dor nyer kumena? kabum kwamam, mor Kristi nyo yikom dikero ti gwam na ko fiya bikwan. ");
INSERT INTO bsj_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Man cwa kati yilo yari ma fiya kom bo nawo ma cwitiyeu. Ma cwati mani ka fiya yeti na wo ko cwitiyeu. man cwa kwalkange an no wi, kange kor, kungka funerek, cwika duwek, cuwarum, kungka duwek, kange bwini nuwa kangka. ");
INSERT INTO bsj_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Mati cwai bwikowo na yilameri, kwama ni an cukumye kabum kumeu. maticwai man ma fir neerer wori, nubo ducce ma bwiran ke nimre nawo. brombo yilo ten bo bwini wucakeu kange burotum kange kayatum kange nangen dilaka wo ci manue. ");
INSERT INTO bsj_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Won cho kero to ta'areu ma yati kumeneu boki, ciya doka nak nyi nob warkeb yob kaka ta'ar. ");
INSERT INTO bsj_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Kweri man tolum kero bwi dor nobero ma bwiran keu kange tangimbo fiya fiya ce mi kange kom ki yanminbo yobeu, yila ma tokten ti. Nan yilatendi mani ma kwob cinen. ");
INSERT INTO bsj_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ma yi kom woti wori, kom do warke ti, kerenkrsiti tok ker ti ki nyini yeri. Co kebo nii dilime fiye ko wiye. la nyeu con nii bikwane more Kume. ");
INSERT INTO bsj_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Wori ci kulkenco mor dilimka, la co ki dume ki bi kwan kwamar. Bo keneu bo nob dilimeb more ce, la ban yi ki dume kange co mor bikwan kwamar wo more kumeu. ");
INSERT INTO bsj_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Ko cuwa kumero na ko to kano kom ki no mor bilenkerer di. ko ma dor kumero min cuwaka. Ka to bo ki bati Yesu wi more kume ka? wi more kume ati kawo na ci ciya kange kom di. ");
INSERT INTO bsj_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Beri min wi ki bi kwan neerer ko fiya cin ciya nyo. ");
INSERT INTO bsj_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Ma kwob dilo kwama min mani ci a fiya kom ti ki bwireanke. Ma kenbo na fwetangum ki bon cam cuwakako wo. La nyeu ma ki kwob dilo ko ma dike dong dongeu. Na duwal mani mwini nyo to kum cuwakakeu. ");
INSERT INTO bsj_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Wori nyo nyombo maka kange diker yilam kwob kang ka kange bilen kere. La nyo ki ma na bilenkero ce. ");
INSERT INTO bsj_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Nyoki fuwor neerer na yokomdi kom wi kibi kwan, nyo kwob diloti na kom takom. ");
INSERT INTO bsj_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","Ma mulange dike buro fiya cho ma man kange komeu, kambo na makange komeri, mani yila kumen nii tokka ti. Ma cwibo ma nangen ki bikwan do wo kwama neyereu nan yalkangum, la ma mukom muu. ");
INSERT INTO bsj_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Cuwa bwir tiyeu yitobmibo kom ma fuwor neerer kom ma nangen wo fwinno ceu, ko na ma bikwan, ko ciya ki bwiti ko yi yim mor fuwor neere, La kwama cwika kange fuwor neerer an yi kange kom. ");
INSERT INTO bsj_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Kom yarum bwiti ki neero wucakeu. ");
INSERT INTO bsj_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Nubo bwang kwama nin tiyeu yarum komti gwam. ");
INSERT INTO bsj_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","Luma Teluwe be Yesu, kange cwika kwamak, kange mwerkanka duwek yuwa tangbe cek, ciya yi kange kom gwam. ");
INSERT INTO bsj_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Bulus nii tomange-kebo nii tomange nobbe kaka tomange ceu bou bo nii kange nin, dila bou Yecu kiritti nin kange Kwama Tee, wo kungum co bwareu- ");
INSERT INTO bsj_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Kange yitubbo mine neu gwam, ki bi kur wabero Galatiya: ");
INSERT INTO bsj_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Luma Kwamako kumeneu kange dam nerem bo Kwama nin Tēe Teluwe be Yecu Kiritti, ");
INSERT INTO bsj_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","wo neken neken dorcero ker bwirang kere be ri na ci cēer bo fo ki kaldo bwirko ko wo nineu, ki cwika Kwama kange Teebe, ");
INSERT INTO bsj_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","duktangka na ca diri. Ati nyo. ");
INSERT INTO bsj_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Min nyimang ki dob kako wulom-wulom ko dubom co, wo cuwo kom ki luma nere Yesu. Min nyimangi kambo ko yilaken ti fulen kerero kangeu, ");
INSERT INTO bsj_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Kebo wori fullen kere ro kange wiki dimen dila nubo kangenbo wii buro cwiti naci kungkumen nere di ci cwiti naci kangum fullen kerer Kiritti. ");
INSERT INTO bsj_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Dila bwenno nyo kaka nob tomangebo dii Kwamau yikom fullen kerero kangeti kebo wo nyi yikome ri cilkako a bwang cinen ten. ");
INSERT INTO bsj_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Nawo nyi yi kom fiya ceu, yila ma yikom ti nawo tak, “Tano kange yikom fullen kerer Kwamar ki dimen kange wo kom yowe ri ca yilam wo cilim cileu.” ");
INSERT INTO bsj_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","La miki do nan fiya ciyaka fiye nubo wiye kakaa Kwama nin ka? La miki do ciyaka fiye nubo wiye ka? No naeu duwal mado nami fiya ciyaka fiye nubo wiyeri, mike bo bwe canga Kiristi. ");
INSERT INTO bsj_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Wori ma cwiti ko nyimom, keb-mibbo, kom ki fulen kerero wo ma tok tiyeu kebo fulen kerer niir. ");
INSERT INTO bsj_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Ma yobo kange nii nin, kakaa cii merang men merang. Nyori, mor dukume Yecu Kiritti bou minene. ");
INSERT INTO bsj_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Kom nuwam ker dor yime miu fiya cuwo ma bwangten dām Yahudawam bo tiyeu, kambo mane nob bwangka Kwama dotange ti cum bi kwaneu kange kambo ma cwi nami yālangum cii yeu. ");
INSERT INTO bsj_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Min ya kaba mor yim Yahudawam bo nin min la kalti miro, duce mor nubo lomeu. Min wiki kor nere ro Cuum bi kwaneu ker bwangka yimer teb mibo. ");
INSERT INTO bsj_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Dila kambo Kwama, wo cok ye fiyaco mi fwer nee mireu, kange co wo cuwo ye mor luma nere ceke, ");
INSERT INTO bsj_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","Cin ciya cin nung men bibwece nami yi nubo kumtacilieu ker cer, fiyaco dangcang ma dobo nyomka nii ki nange kange bwiyale nin. ");
INSERT INTO bsj_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Ma yabo Urusalima nubo buro yilam ten nob tomangeb Kwama minene nin. Nyori min yaken Arabia nimde ma yila ken Dimaska. ");
INSERT INTO bsj_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","La kambo coro ta'ar cumeri min yaken Urusalima nami fiya nyomka Kefas se, min yi kange co kume Kwob cilombo nung. ");
INSERT INTO bsj_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","La ma tobo kange wiin wo mor tangnum nob tomange no kebo ka Yakubu, yi Tee-luwebe Yecu ri. ");
INSERT INTO bsj_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Mor dikero ma mulang kime neu, mayi kom ti kabum Kwama kebo cwerke ma cwer tiye. ");
INSERT INTO bsj_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Dila min yaken biten Suriya kange Kilikiya. ");
INSERT INTO bsj_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Duwal kange ci nyom ye bo tikom mor nubo nebilenke Kiritti nin Yahudiya. ");
INSERT INTO bsj_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Ciki nuwa nubo ki toki,”nii wo no fiyaco nēbo dotange nyeu, naweu yila ne fullen ker bilenkero no fiyaco ci cwi naci kangum me ti.” ");
INSERT INTO bsj_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","La ciin duktang kwama ker miir. ");
INSERT INTO bsj_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","La bwiko coro kwob cilombo na'ar di min yaken tak Urusalima kange Barnabas, min tuten Titus kange mo. ");
INSERT INTO bsj_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Ma kwiwi ker dukumero Kwama nung men neu, la man yi cii fullen kerero ma tok ti more nubo kumtacili yeu. miin tok yuuke kange buro cii toti nubo dur more ciyeu, nami nung cii nen ma cwabo-kakaa ma cwabo koni. ");
INSERT INTO bsj_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Dila ki Titus ce wo wari kange meu, wo Baheline, ma dok cobo biyeka tē- lāk ki bi kwan. ");
INSERT INTO bsj_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Keb bebo cwerke ceu dou binen kebo ki nyomka bek naci tō fang kakowo ba fiya Yesu Kiritti nineu. Ciin cwi naci yilam ki bo cangab, ");
INSERT INTO bsj_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Dila nyi cuwabo tuu cinen ki biduware ce na bilenke fulen kerero fiya yim kimen. ");
INSERT INTO bsj_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","La buro yilam nubo dur reu (bwenno ciin yē ri kwom ye bo, Kwama mani nung cwika dorek)- buro, miki, wo toti ciin nubo dureu, cobmen ten bo dikero kange. ");
INSERT INTO bsj_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Nyori, ciin tori Kwama neye fulen ker cero nan yi nubo wo biyebo tē lareu, nawo ci ne Bitrus fuien kerero naci ne nubo biyem tē lareu. ");
INSERT INTO bsj_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Wori Kwama, wo manangen ki Bitrus na yilam nii tomange nubo biyem tē lareu, manangen minen ken ki nubo kubtacili nin. ");
INSERT INTO bsj_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Ki Kwama wo Yakubu, Kefas, kange Yohanna wo cii tociti na nubo wo bou ki duwika mor nob bilenkerebo nineu, nyumom luma Kwamako wo cii neyere ri, ciin mwerkan kang, kange Barnabas kange mo. Cii ma wuro ri nanyi yaken nye nubo kumtacili nin ri naci yaken ciye ki nubo biyem tē lare ce nin. ");
INSERT INTO bsj_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Ciin ken nyo na nyi ƙwa nob fuwabbo ki ner, dikero no ma cwiti maneu. ");
INSERT INTO bsj_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Dila fiyaco Bitrus bou Antakiyau, Miin kwinang ci nenten wori ci mabo dong-dong. ");
INSERT INTO bsj_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Nimde nubo kangem bo bou Yakubu nin di, Kefas ca cariti kange nubo kumtacileu. Dila kambo nubo cuwo dou weri, cin dubom, ri cin cerum wi nubo kumtacili nen. Ciki nuwa tai nubo wo cwi biyeka te lare tiyeu. ");
INSERT INTO bsj_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Tangni Yahudawa buro wāri kangeceu bwangten nero bwir ko wuro ken. ");
INSERT INTO bsj_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","La kambo ma to dikero ci maneu bwangtenbo bilenke fulen kere reri, mnyi Kefas kabum ciyem gwam,” No mwin nii Yahudiya dila mwi yi yim mwemboti na nii kumtacile, la kebo na nii Yahudiya ri, mwa dok nubo kumtacile nyi kibi kwan na cii yi na Yahudawa? ");
INSERT INTO bsj_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Bo biki bwibo bin Yahudawa ki bor, la bi kebo nubo kumtacili nob bwirang kebeu; ");
INSERT INTO bsj_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","La bwanno bin nyimom nii mania fiya cērka ki nangen bolangere, dila a fiya ki neka bilenke Yesu Kiritti nin. Bo keneu bin ne bilenke Kiritti Yesu nin di nabi fiya ceerka ki bilenke Kiritti nin dila kebo ki nangen bolanger. Ki nangen bolanger nii kange mani wo a fiya ceerka tiye. ");
INSERT INTO bsj_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","La no, kambo bi cwi nabi fiya cērka Kiritti nineu, bo keneu, bin fiya dor bero nob bwirangkeb ken, La Kiritti ki bwa bwiko bwirangke ra? O-ong, kebo nyo! ");
INSERT INTO bsj_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","La tano nyila muuti dikero no ma wurongum ki ƙaba ri, min nung dormiro min nii bwirangke. ");
INSERT INTO bsj_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Wori kifiye bolangko wiyeu, ma bwiya bwar bolanger, ri nami yi yim Kwama. ");
INSERT INTO bsj_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Ciin kulken ye kange Kirist. Kebo mo ma yim me, la Kiristi yim mi nene. Yimbo ma yim mor curen bwiyer mireu ma yim ki bilenke bi Bwe Kwama nin, wo cwiye ri neken dorcero ker mireu. ");
INSERT INTO bsj_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Ma yoken bo luma Kwama ko cungaken, wori no atin fiya cak-cake ki bwangka bolangeri, Kiristi bwiya bwaro bwir ");
INSERT INTO bsj_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Kom Galatiyawa nubo man ki yulaneu! we tum yulan kimere? Kebo Yesu kiristi wo cii kulkene cii nungi kabum nuwe kima? ");
INSERT INTO bsj_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Wo co dikero wiin cwar macwiti merangi kimeneu: Kom yo yuwa tangbeko ki nangen bolanger kakaa ki nuwaka ker bilenkerer? ");
INSERT INTO bsj_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Bwini yulan kimero lam nya? Kom ter ki yuwa tangbe, la na weu kom cwi na kom takum ki bwiya? ");
INSERT INTO bsj_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Kom nuwa dotange dikero ducce koniya-no kibi com koni ri? ");
INSERT INTO bsj_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Co wo ne kom yuwa tangbe Kwamako ri yila marang diker nyimanka more kimeu ma nyo ki nangen bolanger kakaa ki nuwaka ki kibelenke? ");
INSERT INTO bsj_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Nawo Ibraim “ne bilenke Kwama nin di cii kiye cinenti na cak-cakeu,” ");
INSERT INTO bsj_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Ki nure wo ken ko nyimom, komki buro ne bilenkeu, bi beyo lo Ibraim me. ");
INSERT INTO bsj_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Bifumero tom towe kabumbo Kwama atin ceer nubo kumtacileu ki bilenke, yi Ibraim fullen kere wulom, ciki,” Mwinen, dor bitinero gwam atin fiya bi bwiyer.” ");
INSERT INTO bsj_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","La, buro ki bilenkeu, fiya bi bwiyer wari kange Ibraim, nii ki bilenke. ");
INSERT INTO bsj_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Gwam buro citen nuwe ti ki nangen bolangeri, ciki no mor cilka; la nyo mulangum-mulange, “Nii cii cilom cile wo bwangtenbo dikero gwam wo mulangum mor diker mulanka bolange, ri ci mā cii beu. ");
INSERT INTO bsj_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Na weu bin tom yanglang nii kange mani wo fiya ceerka kabum Kwama ki bwangka bolange ke, wori nii wo cak-cakeu atin fiya dume ki bilenke. ");
INSERT INTO bsj_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","La bolanko kebo na neka bilenke ko ce la,”Nii wo manangen bolanger tiyeu tam ca yi ki cii. ");
INSERT INTO bsj_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Kiristi fang bo mor cilka bolange ki wo ci yilam wo cii cilim cileu ker ber-la mulangum-mulange, “Nii ci cilom cile wo cii kulken dor bwatiyere”- ");
INSERT INTO bsj_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","La na bi bwiyer Ibrahim mero na bou nubo kumtacili nin Yecu Kiriti nin, di nayi lam ki bilenke batin yo nor yuwa tangbeko ceu. ");
INSERT INTO bsj_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Keb mibo, miki tok kero ki diro nii firo ciya cikeu. Bwenno nor nii tu naci mā ne ri, mani ci dobti kakaa ci cobten diker ti dorcer no cin dokum kang noro curo nin di. ");
INSERT INTO bsj_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Naweu noro ci mam ki Ibrahim kange naniya ciyek. Tokbo ki,” naniya tini”, wo nungti ki kila-kilau, dila wiin cwar, “La ki naniya mwek,” wo co Kiristi yeu. ");
INSERT INTO bsj_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Naweu dike ma tok tiyeu co wo: Bolankawo bou ki coro 430 cumeu, la dobbo noro wo Kwama tū ki ƙabau. ");
INSERT INTO bsj_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Na no kwalito bou binen ki bolang di, ci bou bo ki nor tak. Dila Kwama ne Ibrahim ki nor. ");
INSERT INTO bsj_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","20","Nye dike bwi cii ne bolanke? Cii cob ten ki ker bwiranke kumeu nyimde naniyak Ibrahim meko bou, wo ker cer Kwama ne noreu. La bolanko cii neu kang nob tomangebo dii kwama kange nii wo tim tibereu. Naweeu, wo tim tibereu ki nung nii cuum wiin, dila Kwama wiin. ");
INSERT INTO bsj_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","La bolangko ki ma kiye kange nor Kwamar ka? Kebo nyo, kibi duware ce! Nano ki ciin ne bolangko kange wo ane dume tiyeri, lano cak-cakeu an bou ki bolang ko wuro nin. ");
INSERT INTO bsj_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","La bifumer Kwama ro ƙuken dikero gwam kang bwiran ke nin. Kwama ma wuro nyo ri naci nebo nor cēr ka beko ki neka bilenke Yecu Kiristi ninneu na neken nubo ne bilenkeu. ");
INSERT INTO bsj_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","na nimde bilenke bou ri, ciin bwambo ki bolang, bi kum-kuwe, nimde bilenkeu cerkangu. ");
INSERT INTO bsj_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","La bolangko yilam wo corbo tiye na nimde Kiristi bou, ri nabi fiya cerka ki bilenke. ");
INSERT INTO bsj_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Dila na weu bilenkeu bekenneu, bi mani kang nii corkak tak. ");
INSERT INTO bsj_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","La kom gwam bi bei Kwamak ki bilenke ko ne Kiritti Yecu nineu. ");
INSERT INTO bsj_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Gwam buro cii yuten mwem Kwama ko mor Almasiyau, kom duum bwiki meu ki Kiristi yesu. ");
INSERT INTO bsj_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Bwe Yahudiya mani more kime kakaa Bwe Helene, canga mani kakaa wo kebo cangau, nii nabare mani kakaa nawiye, la kom gwam wiin mor Kiristi Yesu. ");
INSERT INTO bsj_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","No kom na Kiristi ce ri, kom naniya Ibrahim mek, nob kwalib ki noro. ");
INSERT INTO bsj_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","mikitok miki tano nii kwale bwe biduware, cimanki dimen kange can-nge, bweno kwalito gwam naceu. ");
INSERT INTO bsj_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Dila ciki no kange nob corkab kange nubo cii ciya cikeu na nyime kumewo tece dan-ngeu. ");
INSERT INTO bsj_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Boken, ki kwama bin bibeyeu ciintambo mor cangab kikulentini kaleweu. ");
INSERT INTO bsj_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Dila kambo kiini diim dong-dong ri, Kwama tomou bi bwece mor boka nawiye bo mor bola-nge. ");
INSERT INTO bsj_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","cimawo naci yialamkibo bi beyo loce. ");
INSERT INTO bsj_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Lawori kom bibei, Kwama twomuu yuwatangbe bibweceko mor nere kume wocotiki,”Abba Te.” ");
INSERT INTO bsj_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","La mukebo ca-nga tak, mu yilam bwe, lano mun bweri, munwi mor nubo acakwali kwama rotiyeu. ");
INSERT INTO bsj_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","dila kikiinico, nokm nyombo kwamau, komyilam ca-ngab kibwanka fulenekowo kebo diker bwankareu. ");
INSERT INTO bsj_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Lanaweu kom nyimom kwamau, kakaa nawo kwama nyimom komeu, yebwi kom yilaken mor yikumembo ficeu mani atikangkomtiye? komki cwinakom yilam ca-ngab taka? ");
INSERT INTO bsj_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Ka nyimom kume kange cwakko fwir kange cwakiya kange cor! ");
INSERT INTO bsj_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Kom neye tai, katiyilo na-ngen miro more kumeu yilam dotange koni. ");
INSERT INTO bsj_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Mikenkomti kebmibo, kom yilam namo, wori mokeneu min yilam nakom. kom mamenbo bwiranke. ");
INSERT INTO bsj_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Dila kom nyimm kerbwini nuwaka luma bwiye dokye min yikom fulen kerero kikaba. ");
INSERT INTO bsj_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Bwenno bwini luma bwiye miko dokkom mor cuwaka duwaleu, kom dobyebo kakaa kom dobyebo. Nyiyoco komyoye na nii toma-nge kwama, na yesu kiristi kibwico. ");
INSERT INTO bsj_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Labibwiyer kumero kinofe naweu? minyikom miki, cwika fiyakari, komki cika-ngu nuwetin kumero koneye. ");
INSERT INTO bsj_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Lamiyilam nii kiye kume wori miyikom bilenke tiya? ");
INSERT INTO bsj_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Cii dotiki korneret na cii kwobken kom fiye cii wiye, dila kebo nalumace. Cii cwiti na cii cokumkom nyinen nakom yilanken cii nen. ");
INSERT INTO bsj_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Yori kabo nii ayilamkikor kang-kang dor diroken, ayilare nomiwari kange komri nyime. ");
INSERT INTO bsj_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Bibeyolomi bidwartinim, minuwa dotange bore bwetitak ker kumer, no kiristi fiyam yim kumendi nyime. ");
INSERT INTO bsj_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Mincwi nanno wari ka-nge kom naweu, nan fulo-ngumg diirmiro wori man fiya kwomka ducce kerkumer. ");
INSERT INTO bsj_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Komyiye komwo komcwiti na balango ma liyar dorkumereu, manikom cuwa tuuri bolango ninna? ");
INSERT INTO bsj_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Mula-ngum mula-nge Ibrahimwiki bibeyo yob wiin bubiya ca-nga nin la wiin nawiye ki cheerkanin. ");
INSERT INTO bsj_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Wineu nawiye ca-nga bo morbwiye, dila wineu na norece nawiye cheerka nin. ");
INSERT INTO bsj_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Nii atintokker dor dikero bironin na dangke, naweu natubo biro yobem kidang nor. Wiin morecee bou bang sinai labo bibeyo birombo ca-ngab be. Wo Hazaratu. ");
INSERT INTO bsj_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Hazaratu ki dang bang sinai wuro Arabiya; ciki dang wurusalima tak wori cikio mor ca-nga wari ka-nge bibwece ");
INSERT INTO bsj_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Dila wurusalima wo diyeu fiya ceerka, cin nebe tak. ");
INSERT INTO bsj_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Mula-ngum mula-nge,”Bila-ngi mwo cwombilome wo bombo bwe wiyeu. Kun diir namob biyalte, mwo wuro nuwambo buwarum bwem wiyeu. Wori bibei nawiye cii koweu la nawiyewo ki bwayile ceu kilaka.” ");
INSERT INTO bsj_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Dila kom, kebmibo, na Ishaku bibei nore. ");
INSERT INTO bsj_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","fiyaco wo cii bo mor bwiyeu ne wuro cii bo mor yuwatangbekeu dota-nge. Kini nyo naweu. ");
INSERT INTO bsj_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","31","Dila ye bifumer Kwama ro tokke?”Ywabken bubiya ca-nga ka-nge bibwece. Wori bibwe bubiya ca-nga mani a ca kwaliti ka-nge bibwe nawiye ceerkati.”Nyori, kebmibo, kebo bibei ca-ngab bubiyak, dila nawiye ki ceerka. ");
INSERT INTO bsj_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Ker ceerka kiristi in ceerbo. Ko tikibi kwan, kociyare komyilam de ca-ngab fiye bolango wiye tak. ");
INSERT INTO bsj_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Komto, mo Bulus miyikomti, nokom ciya cii biye kumen lardi, kiristi mani yilati ki tikali fiye kom wiyeu gwam. ");
INSERT INTO bsj_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Nyotak miyi nubo wiyak wociya cii biye cinen lareu tamco dor can bwangten bolango wiyak. ");
INSERT INTO bsj_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Lakom cerum kiristi nin, komwo ciiya ceerkomti ki bola-ngeu; manikom nuwa luwa Kwama koti tak. ");
INSERT INTO bsj_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Laki yuwatangb Kwama, ki bilenke, biningtang yoka nereko cakcaketi ki nero wiin. ");
INSERT INTO bsj_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Mor kiristi Yesu, wobiyem lar ka-nge wo biyebo lareu cii wiin, dila kan bilenke ma na-ngenti mor cwika ");
INSERT INTO bsj_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Fiyaco kom ca kabati dong-dong. We ywamkom bwangka bilenke? ");
INSERT INTO bsj_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Ciyakakowo boubo niio cokome nin! ");
INSERT INTO bsj_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","camfuwambo biduwar ki dokre mimbo fuka ducce. ");
INSERT INTO bsj_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Min ciya ka-nge kom kabum Kwamam mani kom bwangteng nuri ka-nge ti ki dmen. Co wuro kung kumen nertiyeu can nuwa dota-nge bola-nge bwenno cin we duwal di ");
INSERT INTO bsj_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Kebmibo, tano miki tokker Kwamar dorbiyeka larekri duwal di, yebwi cii neye dota-nge tiye? Lanawori ter kottangkako kwoblom bwatiye kiristim bo kutam. ");
INSERT INTO bsj_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Lanubowo kwomcang komtiyeu, min cwi nacii yala-ngum dor ciiro! ");
INSERT INTO bsj_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Kebmibo, mi cokom ker ceerkar. dikm turo ceerka kumeko nayilam idker na-nger bwiyer. ");
INSERT INTO bsj_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","wori bolango gwam diim kibolango win.”Cwi nii bidom ka-nge mweu na dormwer.” ");
INSERT INTO bsj_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","dila nokom ca na-nge kebkumebe tiri komka bati kati yilo kom twalng bwiti kumeu. ");
INSERT INTO bsj_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Dila mikikom yayam mor yuawtangbe, dila mani kom bwangteng diki bwikume cwitiye ti. ");
INSERT INTO bsj_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","wori dike bwiyo cwitiyeu makiyeti ka-nge dike yuwatangbeko cwitiyeu, dila dikero yuwatangbeko cwitiyeu ma kiyeti ka-nge dike bwiyo cwityeu. ");
INSERT INTO bsj_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Lano yuwatang bwangtenti kikomeri, bolango mani a ma liyarti dorkumer. ");
INSERT INTO bsj_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Na-ngen bwiyero kino ngang-lang: kayaka, duti, fwandiker, bwangka fulenek, ");
INSERT INTO bsj_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","kiye, kwobkangka, kor, funer, bikuwen, kutume, yalkanka, kucuni, ");
INSERT INTO bsj_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","norangka ka-nge tangne dikertinim na biro. Fiyco min werangkom miki, nubo madike birotiyeu mani a doti liyar Kwamar. ");
INSERT INTO bsj_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Dila bibwiyer yuwatngbeko cowo, cwika, fuwor nerek, luma nerek, birom nem, luma nero ken, bilenke, ");
INSERT INTO bsj_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","lomjome, ka-nge taka dorek, bolang mani dor dikero biro. ");
INSERT INTO bsj_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Biro yilam yesu ceu kiristi ceu ciin fwerken kulen bwiyero ka-nge cwika ciiko. ");
INSERT INTO bsj_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","No yimbembo nayutangbeko ceri, daten biyayam kiyutangbe. ");
INSERT INTO bsj_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Biyalamre nob kunka dorek, mwerka dor kebbeb ka-nge nung-nung. ");
INSERT INTO bsj_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Kebmibo, nokom tau nii bwirang keretiye, kom biro ki yuwatangbekeu, kom yilau kico mor yuwatangbeko lomcomeu. Dila ko nyom dorkumero, kati kom doken cuwaka. ");
INSERT INTO bsj_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Kom ci bwini bwitikumero, la-nyeu an diim bolang kiristi ko ");
INSERT INTO bsj_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Tano ka-nge antu dorcero kicin diker dila ci kebori, ci bol dorcer. ");
INSERT INTO bsj_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Nii acuwa na-ngen cero, lana nyime catin diker buulang mor bwiyece kebo ka-nge nii nin. ");
INSERT INTO bsj_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Nii atu na-ngen doret cer ki bwico. ");
INSERT INTO bsj_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Wuro cii merangten dikereu, ca caluma dikeroco ka-nge wo merang ci nen neu. ");
INSERT INTO bsj_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ciiya bol komde, nii mani ayi Kwama mwan kereti, dike nii fiyeu co dike ca biyeetiye. ");
INSERT INTO bsj_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Niiwo fii dum ki cwika bwiyekeri, cabiyee bubaka fiye bwiyo wiye. Nii wo fi dum yuwatangbekeri, ca biye dume fiye yuwatangbeko wiyi. ");
INSERT INTO bsj_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","A luwabore maka dikero ko ken, tano kiini lam dong-dong ri ban biye bituwe, ta bi cokbo nerbero ri ");
INSERT INTO bsj_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Ki kiini biki keka-ngiyeu, bima nubonin dikero ken gwam, nobo nanubowo yilam akwama ce ki bilenke. ");
INSERT INTO bsj_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","To bifumero durko mimukang kumen kikang mikeu. ");
INSERT INTO bsj_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Nubo cwiti nacii dang dang nym mor bwiyeceu, cii ciidokkomti kibikwan nakom biyem lareu. Cii ma-nyeu kati yilo cii ne cii dota-nge ker kwoblom bwatiyem kiristim. ");
INSERT INTO bsj_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","La kebo kanubo biyem lereu bwangteng bolong tiye, dila ciiki cwi kom biyem laro nacii kung dorti mor bwiye kume. ");
INSERT INTO bsj_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","La ayilam de mima bitenamti, nokebo ki kwoblom bwtiyem Teluwe be Yesu kiristi tiri, won co dike bwi cii kulken kalewo fiye mi wiye. ");
INSERT INTO bsj_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Biyeka lareko ka-nge wo biyebeu kebo dike ka-nge fiye miwiye. Kan boro fwir yilam dikero ken fiye miwiye. ");
INSERT INTO bsj_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Birombo yiyimbo ken tiyeu, yobka nerek ka-nge jire dume ayilam cee, ka-nge dor Israila Kwamar ken. ");
INSERT INTO bsj_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Tabti anwo yaken ciko ka-nge a kwomyere, wori mi tumki yirom Yesum bwimi. ");
INSERT INTO bsj_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Luma Teluwebe Yesu abwangten ka-nge yuwatangbe kume ko, kebmibo. Ati nyo. ");
INSERT INTO bsj_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Bulus ni tomange Yeecu Kiriti ki ci yaka fiye kwama, kii nubo coccoke na kwama yim Afisawa borom bo ma bilenketi mor Yeecu. ");
INSERT INTO bsj_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Naweu luma kwama ko ati kange kom kange fuwor nener fiye kwama Tee be kange Tee kwama Yeecu Kiriti. ");
INSERT INTO bsj_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Caklanka ki Tee kwama Yeecu Kiriti co ci nebo bibwiyere ki bibwiyer tinimbo wuyakiwo mor nenero lumako ceu mor dii kwama mor Kritti. ");
INSERT INTO bsj_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Nan yi me felka kaleko mor Yeecu. co kombo nabi yi yimbo wucakke kange yambo maniki duti kaceu. ");
INSERT INTO bsj_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Mor cwika kwama dangi ki naci tumbo nabi yilam bibwece fiye Yeecu Kirirti wiyeu. Ci ma wo kambo ci cwiti naci mane. ");
INSERT INTO bsj_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Cune inco kwama naci yo caklanka wo duktangka luma nererk ko ceu. won co dike nebo kang nyam aya fiya bwe nerece wiye. ");
INSERT INTO bsj_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","La mor bwe nere ci ceerbi fiye bwiyale ce kange tabka bwiran kerer fiye luma nererce ko lalame. ");
INSERT INTO bsj_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Cin ne luma nererkowo, Lama nyo mor nyomka gwam. ");
INSERT INTO bsj_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Kwama yibo bilenke dikero wuro yurangum yurangeu. Ki nyomka ce kange dikero gwam dii kwama kange dor bintiner mor Yeecu. ");
INSERT INTO bsj_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Cin cokbo almasihu nabi yilam nob kwaleb na kwama ce. ");
INSERT INTO bsj_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Mor Kritti cin ma binen ywelka ko wo kika mor ywelka cek, cin ni ma dikeroti gwam nawo nerceroceu. ");
INSERT INTO bsj_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Kwama man yo wori nabi fulom na caklanka duktanka ceko cekoceu. inbo nob kababo bifiya yoka neroko weu mor almacihu. ");
INSERT INTO bsj_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Mor Almacihu kom fiya nuwaka kerbileng kerer, ker dumer ber fiya Yeecu wiye. morece kom nebilenker ci dokkume kang ki Yuwatanbe kwama ko wucakke woci ma kumen mor cereu. ");
INSERT INTO bsj_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Yuwatanbe ko inco ciyaka kwali beko na nyime yabi fiya. wuro na caklanka duktanka cek. ");
INSERT INTO bsj_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Naweu, ki kwama mi nuwau fulen bilenkerer kumero mor Ubangiji Yeecu kange cwikacek yaken ciko kwarub birombo cii cokci kercereu. ");
INSERT INTO bsj_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Ma kurong bo kwaka ki kom mi kwob kimen diloti mor dilotinim. ");
INSERT INTO bsj_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","min kwob kumen dilo miki Tee bwe wo di kwama Yeecu Almasihu Tee wo wucake ane kom yuwa tangba ceko wo ba fiya bukati cikeu kange wo nyomka cek kwarub. ");
INSERT INTO bsj_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Mi kwob diloti na nuwe kume wumom nakom nyimom ciya bicore kumeko. Mikwob diloti nakom nyimom cuweka liyar kwaliero mor birombo ci cokunnaceu. ");
INSERT INTO bsj_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Mi kwob diloti kom yimom liyard cero wuro na dur wuro mankidi more benen wuri bine bilenker dwikako wuro kino fiye nanyer kwaner bikwan nerer cet. ");
INSERT INTO bsj_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","Wonka bikwan durero ci mam nagen ciko mor Almasihu ki kwama wo kwama kunco tuweu yokenco kanko cacciyere mor di kwama. ");
INSERT INTO bsj_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Cin yo kenco dor birbishi kange Liyar, do ka, lo dako wannen irin liyar can yoken Almasihu kebo na kele wuro ce ki kwaco dila kange kalewo bouti yeu. ");
INSERT INTO bsj_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Kwama dokken dikero gwam mor Bibwe kwama cin yonco dur dor dikero nen gwam mor nub bwanka ceko. ");
INSERT INTO bsj_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Nub bwanka ko in bwico, dika niwo dim dikero gwam mor dikero gwam, gwameu. ");
INSERT INTO bsj_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Dila nan duwo kom bwambwa mor bwirang ker kumer kange kanke. ");
INSERT INTO bsj_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","More ce kom yim yim kumem bo wo dor bitinerowo kom bwanten niwo ma yila bikwan tini diyok kwamak, won co yuwako ma nagenti, mor bibei bi kwan doret. ");
INSERT INTO bsj_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Nanduwo gwambe bi mor nubo birombo nebo bilenkere bibwang ten ka dikero bwirko bwibe cwitiyeu. bi matika nagen bwiyer kange dike nerbero katiyeu. fo bwiri bibei wuro daten funer kwamareu, na kangem. ");
INSERT INTO bsj_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Dila kwama nii ci bwini tenagi nye, ni ker wikaro ci cwibo manki dika. ");
INSERT INTO bsj_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","Kambo bibwiyam bwiya mo bwirangke, bouki bo mor nero funer wari kange almasihu. ci fulobo kin luma nerer cek. ");
INSERT INTO bsj_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Kwama kunbo wari dila yobo biyi ari nawo, win mor Almasihu Yeecu. ");
INSERT INTO bsj_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Ci ma wuri ker kaldo wuro bouti yeu. na daang cuyeka luma nerer cko fiye Yeecu wiyeu. Kdang binen wuro kino luma neret cek. ");
INSERT INTO bsj_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Naweu ci ceerbo kin lumanerek wo bilenkeroceu wo kebo fiye kom wiye, luma nerek kwamak. ");
INSERT INTO bsj_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Kebo dor nagenent nawori kange kume a kunde dor. ");
INSERT INTO bsj_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Bin nagen kange kwamar, fwelfwele mor almasihu Yeecu nabima nagen do ken, birombo nanduwo kwama yowau nabi, yi yimbo moreceu. ");
INSERT INTO bsj_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Naweu kom kwabi nanduwo kom nubo yombo kwama ki yim bwiyeme. ci ki cuwoki “nubo biyebo Lave” dike ci coki biye Lave bwiyeu wuri kan nube ko matiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Dila ki kwama wo nacin kab kangum kuke da almasihu. kom fabub nubo Israila nin. ko fabub ker neret. Kom manki yomka dor finir. Kom manki kwama dor bitiner. ");
INSERT INTO bsj_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Di la na weu mor almasihu Yeecu kom wo nanduwo kutan kange kwama, cin bou ki kom bidom fiye buyale almasihu. ");
INSERT INTO bsj_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Cin co fuwor nener bero. La naci yilam win kiyobeu. Mor bwiyece cin bubam tiyak kiyeko wo kab kangum bo kange bwitibou. ");
INSERT INTO bsj_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","La naci tungum warka kowo ki nyaleu kange werfuneu, dila naci fwel nii fwir win more ce. makako nyeu bou ki lumanerek. ");
INSERT INTO bsj_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Ci manyo naci mwer nubo yob mor bwiye wi kange kwama fiye yeikaka. Fiye kwoblom bwatiyeu cin twalum kiye tiber cereu ");
INSERT INTO bsj_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Yeecu bou makimen ker fuwor nener kom wo km kutan kange kom wo kom bidomeu. ");
INSERT INTO bsj_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Na fiye Yeecu wiyeu kwarubbe yobeu win mor yuwa tangbak cek biki nure yakenti Tee nenneu. ");
INSERT INTO bsj_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Naweu kom nubo yombo kwama wni wo, kebo fabub. nawori faub ari knage birombo cokcokeu wo kwama cer farub, nangeneb. ");
INSERT INTO bsj_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Birombo ci mu ci dor kwar nob tomangeb kange nob ker dukumeb. Almasihu Yeecu ki dorcer coci lanrang Tee mukare. ");
INSERT INTO bsj_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Mukako mwer morece kwarub, ci diti na lo kwama mor Ubangiji. ");
INSERT INTO bsj_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Morece ci mu kom tiye gwam kom yilam fiti yim kwama mor yuwa tangbecek. ");
INSERT INTO bsj_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Lana wori, mo Bulus bwe furcina ker almasihu ma kom nubo yombo kwama. ");
INSERT INTO bsj_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Mi kwati kom nuwam don nager do dur ko wo luma kwama ceu neken mor ker kumer. ");
INSERT INTO bsj_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Mi mulankumen dor dukumero ci yi yereu. won co bilnker yurangum yurangeu ma tokker dor cer mor bifumero kange. ");
INSERT INTO bsj_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Kambo ko fiye dor cereu, kan nyimom basira miu mor yuranka bilenker don amlsihu. ");
INSERT INTO bsj_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Wuro kaltiyo nanduwo i yi cibo nubo. la na weu cin dang nob tomangeb bo nen kange nob tomangeb dukumeb. cokum coke mor Yuwa tanbe. ");
INSERT INTO bsj_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Kero wo yurangum yurangeu, in co ker kwarowo dangi nubo nyombo kwama faub kwalib wari kange bo, kutelti mor bwiye win. Farub mwerkankab wari mor nortimin almasihu Yeecu fiye kerkwamari wiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Wonco dike bwi mi yilam canga fiye yomka luma kwama nekye nawo durbi kwaner cero. ");
INSERT INTO bsj_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Kwama neyi nyomka kowe. canno min coni dual duwale mor birombo cokeu na kwamace, nan tok ker kwama nubo nyom bo kwama nin don cuweko almasihu wuro manki dika. ");
INSERT INTO bsj_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Nan fetang nubomin gwam dike kwama ywelcinentiye bilenkero wuro yurangum yurangeu wo coti coti kwama yurangumeu, co cinnir fweldiko gwam. ");
INSERT INTO bsj_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Nawori fiye ku wabero nob bidweb kang nubo ma liyar diko kwama tiyeu, ciyan nyimom yomka kwama fiyeco ki dimen kidimen. ");
INSERT INTO bsj_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Wuro bwi nyo nawo co ci mani mor Almasihu Yecu Tee be kwama. ");
INSERT INTO bsj_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","La mor bibwe kwama bin wiki bikwan nener ducce, kange ciyaka kiker bilenkerbe morece. ");
INSERT INTO bsj_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Naweu mi kenkomti kom cwaretai kiker dotange mi nuwa kerkumereu wo yilam duktang kumen keu. ");
INSERT INTO bsj_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Naweu min cunti ki duwenmir kabum Tee. ");
INSERT INTO bsj_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Wuro fiye ciwuye ci cuwanga nuboti wuro kwama kange bitineu. ");
INSERT INTO bsj_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Mi kwobdilo cin ciya kumn dor cuweka duktankace. kom biner kambo ken ki dur bikwanererowo yuwa tangbanko mineu wo more kumeu. ");
INSERT INTO bsj_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Min kwob diloti Almasihu ayi mor nener kume ki bilenker ke mi ker abdilo ti tak kom tim yora kom mum yora kambo kem mor cwika cek. ");
INSERT INTO bsj_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Kom yilam mor cwika cek wori na nyimom, kange nob bwanka kwama wari wuyak, in ye cuwaka, kange kuyaka, kange cuwemka cwiki almasihu. ");
INSERT INTO bsj_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Mi kwobdiloti na kom nyimom tenanka cwika almasihu wo cum nyonka. Kom mawo naci dimkom ki dika kwamak. ");
INSERT INTO bsj_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Naweu wo ki dur bi kwaner maka dikero bi kenu kaka kwanka nerer bisaga dur bi kwaner cer manangenti more beu. ");
INSERT INTO bsj_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","duktangk a yilam nace mor fiye wabka fiye Yeecu wiyeu yaken ciko ki curom tinin diri diri Atinyo. ");
INSERT INTO bsj_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Nawo ri nawo min mi furcineu ker kwama mi kenkomti kom yi yimbo daten kange bi co kwama makemeneu. ");
INSERT INTO bsj_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Kom yilam ki dikero ken do wu a mati ki dikero ken kange birom nenerem. Kom yo kebkume bo mor cwika. ");
INSERT INTO bsj_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Kom yi yim mwerka dorek mor yuwa tangbek kom morum mor fuwor neret. ");
INSERT INTO bsj_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Bwiyo wi win kange yuwa tangbekko win, kam ci co kom dor yoka nerer ko wineu. ");
INSERT INTO bsj_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Kwama win bilenke win, kange yuka munge kwama win. ");
INSERT INTO bsj_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Kwama win kange Tee gwam. Co ci dor diker wuyake, fiye wuyake, kange mor wuyak. ");
INSERT INTO bsj_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Kwama ci nebo nyomka dong dong kange cuwaka nyka almasihu. ");
INSERT INTO bsj_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Nawo cin bwanten kange cannya mo dotange cin ma nubo ki yomka. ");
INSERT INTO bsj_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","In ye tok tiye, “Cin kwiken” kiyi yiram, yaken bitine more cuwa cuwau. ");
INSERT INTO bsj_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Co ci yiraweu co ci kwiken dikwama ci mawu naci dim dikero gwam. ");
INSERT INTO bsj_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Yeecu Nii ne nub yomka nawuro nyo nob tomangeb, dukume nubo waker cero fiye nubo to kwamatiyeu, kange nob merangkatiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Cima nyo na ywellum nob kwama bo na maka nange neke ce, na mum bwi almaihu. ");
INSERT INTO bsj_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Ci manyo nabi lam yim bilnker bo ken bo kange nyoka bibwe kwama. ci manyo la bi lam dwika, na birombo lam dim dur cero lo Yeecu. ");
INSERT INTO bsj_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Yecu muu wuro nyo kati yelo bi yilam na bi bei. ka cita yilang boti. Wuro nyo kati yoli bi yuwa merangka binen kankak kange buyelangka nob maka cwerkeko. ");
INSERT INTO bsj_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Nyori ban tok bilenker mor cwika wori nabi dwi mor bi kwanner cer, co cin durken mor Yeecu. ");
INSERT INTO bsj_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Yeecu mwerum bwi nob neka bilenker. Bwiyo mwerum mwere fiye kulteltinim bo wiyeu, na bwiyo duyom na mum dencero mor cwika. ");
INSERT INTO bsj_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Naweu nii makumen be wereti mor kwama miki kom cwobtende yimbo na yim nubo nyombo kwama cimati yim azanci bang da wofi wo manki nageneu. ");
INSERT INTO bsj_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Cin fim kumti cile mor kwaka nerer ciko fabub ki dume nawo kwama ceu, fiyu bwin nyo ka cek wo more ceu kange wo kwamka nerer cekeu. ");
INSERT INTO bsj_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Ma ci nuwa kwenduwe ti cin neken dor ciro nagen mor bwiyer maka nangendo yeyeu kange la cin merang kenti ki dikero bwir. ");
INSERT INTO bsj_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","La kebo nyo kom merang nage kwama re. ");
INSERT INTO bsj_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Min kwatiri kom kweri, kom nuwam dorcer. mikwatiri cin merang kumen morece, nawo bilenker Yeecu nyeu. ");
INSERT INTO bsj_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Yii nen ki tam dikero nanduwo mwa merangeu, kom yii yimkumenbo nanduwo, la nii cer nii carko yakcanti ki bwirankeret ceko. ");
INSERT INTO bsj_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Kom minang nii carkowo naci mirim kom fwice mor yuwa tangbe kumek. ");
INSERT INTO bsj_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Kom manyo nakom dum ni fwir wo cerkan kwama ci fwel mor bilenker nere, kange wucak kange bilenke. ");
INSERT INTO bsj_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Na wori kom cutan cwekewi, “Tok bilenke kange nii bidom kange mweu,” wori bin kuteltin bwitibo. ");
INSERT INTO bsj_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","“Kom kanngum ner, dila mare bwiranke”. kom dob re ka kuko ayarum kom kang nerek. ");
INSERT INTO bsj_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Kom nere bwe kelkele nyilo. ");
INSERT INTO bsj_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Ni ku kumtiyeri adubom kuka kuyeko tak. La nyi co liya mananngen manangen ki kanice naci fiya dike catikan nubo kwambe ti cikeu. ");
INSERT INTO bsj_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Kero fwemfweu acirangum nyi kom. No nyori, kom ywelten dor kumero na ne luma nubo nuwatiye. ");
INSERT INTO bsj_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Kom kande yuwatangbe kwamako nin ner fo fiye ciweu ci dok kumen kange nawo kaku ceer kako ceu. ");
INSERT INTO bsj_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Kom cutan fur nerero win, da hasala. fush da tankiya da reny da dukan mugunta. kom ma bwiti kume nen dikiero ken, kom yilam ki nero yiber. ");
INSERT INTO bsj_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Kom dob keb kume bo bwirangker cero kambo kwama kume Yeecu dob kumen bwirang ker kumeru. ");
INSERT INTO bsj_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Nuweu Kom ma meranka ki kwama na be beyo cwitiye. ");
INSERT INTO bsj_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Kom yi yimbo mor cwika nawo Yeecu cwibeu latak neken dor cero dike luma neret kange diker ne kar fiye kwama wiyeu dorber, twika dikero fican fican diker yokar fiye kwama wiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Burotum kange kwarub kayaltum, kange kaya kaya kawowo yei nyeu ciya cuwo kome more ce, nyo daten kinob bwangka kwama. ");
INSERT INTO bsj_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ciya cuwo re batsa ker kulerner kange alfasa birombo daten bem. No nyori biyilam nob buka kangek. ");
INSERT INTO bsj_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Naweu kom nyi mom ni kayaka kange ni mani wucakeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Kangem abolkome kiketito bwir. in co dikero birom bo funer kwamaro boutiye dor bibeyo bonya nyi nyeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Kom mwerkan re dor wari kange ci. ");
INSERT INTO bsj_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Wori naduwo kom kunta cile dila naweu kom filan mo kwama. Dila kom yayambo nabibei filange. ");
INSERT INTO bsj_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Wori nange filange ro co lumako, luma nerek kange bilenke. ");
INSERT INTO bsj_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Kom do dike kwama ma funner nerer ti cikeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","yorekan nange do wo manki yorako ken kange nagen do kumtacile dila yora a womci. ");
INSERT INTO bsj_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Diker kwenduwe kange duka diker ci mani yurangum yurangeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Diker gwam cano filang danciri ciki tom nyo. ");
INSERT INTO bsj_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Wori diker yilam ci to ti filange ri co diker bwi citoki wuram mo ni dume kwenum mor buware, Yeecu atim ne filang dor mwer. ");
INSERT INTO bsj_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","La na weu kom mayora mor timbo kom tim kumentiye. ");
INSERT INTO bsj_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Kom tiyora kange maka nangenek ki kanka neret wori kume cwiku n bwi. ");
INSERT INTO bsj_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Na wori kom yakcare ki nyom wori kang yim nimti lanyori kom dim ki yuwa tangbe kwama wucakkeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Nyori kom nore dikero bwir wo a yokom ti mor dotangeu, daten di kom dim ki yuwatangbe kwama, ");
INSERT INTO bsj_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Kom ki tokkan kero ti bwiti kume kon ki zabura kange nuwe kange nuwetinim mor nerer kom, kanuwe cakkeu ki ner kumer fiye kwama wiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","bak ni bak kom ne bilenker keti wori dikero gwam mor den Yeecu Tee be kwama. ");
INSERT INTO bsj_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Kom Ciya kom tum dotange bwiki kume mor neka kwama ");
INSERT INTO bsj_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Natub kom bwanten dir nabarub kumebo mun kom ki man ki kwama. ");
INSERT INTO bsj_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Wori bwayile co dur wicero nawo almasihu dur nub bwanka kwamak co ni fuloka bwiyeko. ");
INSERT INTO bsj_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Dila kambo nub bwanka kwama ko neken durcero tiye, tamyo natubo ciya bwece dur gwam. ");
INSERT INTO bsj_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Nabarub kom cwit natub kumebo kambo Yecu cwi nub bwanka cekeu. ya neken dor kercer. ");
INSERT INTO bsj_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Ci ma nawo na ciyim ci wucak. Naci nirimbo ki mwom nikam fiye kercero wiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Ci ma oyo naci neken dor cero nub bwanka kwama ko nen wo yoryoreu manki dike kece kulande mani na birombo na wuro dila ca yilam wucak mani ki dwiti. ");
INSERT INTO bsj_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Na woro nabarubo kom ci natub kumeb bo na bwikom wuro cwi wiceri cwi dorcer. ");
INSERT INTO bsj_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Ni mani wo kom bwice wiye. Dila neci raritoti cwiti na wo kwama cwiti nub bwanka cebo matiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","Wori bin kutteli kebbeb. ");
INSERT INTO bsj_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Nyori ni nabare a dubom Tee ce dubo nece citab wice nin ci yob cin yilam nange win. ");
INSERT INTO bsj_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Dike wo yurangum yurangeu tenanin dila miki tok kange nub bwanka kwama. ");
INSERT INTO bsj_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Kange o wuya kom nabarobo mon cwi tatumubo nador kumer nawiye kang can can ne bwece durko. ");
INSERT INTO bsj_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Bibeyo kom bwanten tebkumebo mor kwama wuro dong dong. ");
INSERT INTO bsj_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Ne Tee mwe durko kange Ne mwe” won co werfun kabaro kange nore. ");
INSERT INTO bsj_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","La nye ka ma bi buyer wori, na kumeri kumeu cuwemi dor bitiner”. ");
INSERT INTO bsj_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Nyo Tebbo kom kwomde bibeyo lokume a lamde kanka nerer, dila kom mweci mor mwerum mem kwama kange kwobka tuwek. ");
INSERT INTO bsj_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Kom cangab bo kom bwanten dir Tee luwer kumero wo dor bitinero ceu knage neka durek kange tai kiner bilenker. ma cinen na dimu ki mam ki Tee mwe wo dii kwama. ");
INSERT INTO bsj_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Kom neci durko nobo wori cito kom tiyeu na kom neci fuwor nerer Nyori kom macinen muni kom ki mam ki kwama kom a ker kwama ro mor nere. ");
INSERT INTO bsj_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Kom ma dikero kiner kumero wuyak. muni komti bwnate kwama kebo niffir. ");
INSERT INTO bsj_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Kom nyo diker nimane can fiya yokacek fiya kwama cin nannga ka kaka ci keba. ");
INSERT INTO bsj_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Kom Teeb Luwe bo kom ma cannga kume nen nyo kom necire dotange kom nyi mom co niwo cin Tee ciu kange kom win kino kwama kom nyi manici dong nyimanka. ");
INSERT INTO bsj_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Diker wuyak, kom ne bi kwan nerer mor kwama kange mor dur bi kwaner cer. ");
INSERT INTO bsj_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Kom tu kulen kwener kwamaro gwam na fiya na kom ca kaba dor yulan bwe kelkeler. ");
INSERT INTO bsj_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Wori kwenbero kebo na nangi ce kange buyale. Dila kange bikwan liyarero wo no warkabo dor bitinereu. wori kaldo kumta cile kange nob kweneb cibo fo mor kalewoninen. ");
INSERT INTO bsj_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Nyori kom tukulen kwener kwama gwam na ko do lum kom tim kibi kwan mor kwener wonen. ");
INSERT INTO bsj_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Naweu, kom tim kibi kwan kom bwam dak kumeko mor bilenker kom merumom sulke cak-cakeu. ");
INSERT INTO bsj_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Kom wuro kambo kom bwam nani kume nakom yaken ki ker kwama lumakoceu. ");
INSERT INTO bsj_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Mor dikero gwam kom tu kusanko bilenke ko, wuro katwalum bok tinim nii bwir ko cikeu. ");
INSERT INTO bsj_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Kom tu wambile ker dumero kange kulen yuwa tanbako, wuro ker kwamareu. ");
INSERT INTO bsj_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Wari kange dilo tinim kange kini kom kwob dilo ngir mor yuwatangbeko kin co nero wo kom kicom wuruti ki birim nerem kange kini ker nub kwama gwam. ");
INSERT INTO bsj_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Kom kwob dilona yitomange kambo min wumom yimeu. Kom kwob men dilo nan fiyam bi kwan nerer tok ka bilelnke yurangum yurangeu. ");
INSERT INTO bsj_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Dila na kom nyimom nyim minbo kange kambo mi yimmeu, ");
INSERT INTO bsj_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Tikikus, kemi macwiti cwiyeu, kange ciyaka cannga mor kwama anyikom co dike wiyeu. ");
INSERT INTO bsj_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Wonco dike bwi mi two mu co kumen ne wori nakom nyi mom dike nyi more ceu, na kom fiyam yobka nerer mor nerer kume. ");
INSERT INTO bsj_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Na weu fuwor nener kwama ati kange kom keb mibo ki bilenker wuro Tee kwama kange kwama Yeecu Kritti. ");
INSERT INTO bsj_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Luma kwama ati kange kom birombo cwi Tee kwama Yeecu Kritti wari kange cwika ko mani ki bwiyaka. ");
INSERT INTO bsj_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Bulus ka-nge Timoti cangab kiristi Yeesu yã ciko nob kwamab wucake wo Fillibi ka-nge nubo tam ki nubo bwanten kwama tiye, ka-nge nubo durku lo wabbeu. ka-nge nobo durko ku wabbe. ");
INSERT INTO bsj_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","luma kimen ka-nge fuwor neret tebe kwama nin ka-nge Teluwe Yeesu kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","mi bu kwama nin ka-ngeti diye no ma kwa kom ki nere di. ");
INSERT INTO bsj_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","kir-kir mor dilo minin kimen gwam, mi kwob dilo miti ki nero fuwor. ");
INSERT INTO bsj_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","mi bu ka-ngeti dor nangenero bi mati wari mor fulen kere ka cikko ba teruwe ya ciko na wo. ");
INSERT INTO bsj_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","miki bi kwamer neret wo ter nangen ken kimeneu an yaken ciko cwobka di kakuk Yeesu kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","won digero ken nuwa nyo nure wuro dor kimer gwan, nyori miki kom gwam ner mir. kom yilam far nangene mi mor luma, ki bwaka miko ka-nge cerka dorek mik ka-nge tika ki bi kwan bifumero nin. ");
INSERT INTO bsj_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","kwama warke mi, kuru kime gwam mi ciko mor cwika dur wo Yeesu kiristi ce. ");
INSERT INTO bsj_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","wo co dilo mi, cwika kime ko a yokten kab mor merangka ka-nge, ka-nge nyomko diger gwam. ");
INSERT INTO bsj_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","nyori na ko ciye ki dige yor yore gwam na kom yilam nobo ki bilengke, digero bwir mani kimen ya cika dige kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","dim ki bi tutti wucake wo bouti fiye Yeesu kiristi na duktangka ka-nge caklangka kwama. ");
INSERT INTO bsj_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","mi cwi komti ki nyimi keb mibo, dige fiya yereu matikali fiye yokka fulen keret kwama. ");
INSERT INTO bsj_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","bwaka miko mor kiristi bou ki filang nubo lo liya, nubo tõ nub tiyeu gwam, ka-nge kangum bo fiye ka-nge. ");
INSERT INTO bsj_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","kangum yitub beb, ki kinin yilam ki bi kwan neret mor Teluwebe ker bwaka miko, ciki nero kwamer ciya miko keroti man ki taiye. ");
INSERT INTO bsj_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","kangum bo tok ker kiristi ki kor neret ki kwilki-kwilkiye. kangum bo ki nero ken. ");
INSERT INTO bsj_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","nubo ki biye wo ki ma ki cwika, ki nyomka ci bwayere na yilam kucang fulen keret. ");
INSERT INTO bsj_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","nubo wo bwiye ki tok ker kiristi do mor cwika neret ciye, kebo dor bilen keret. ci kwatiri ciyan neye dotange ki fiya cuwo mi bwambwabe. ");
INSERT INTO bsj_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","“la ye” diger win, mor digero gwam, bwen tano ciki ma ki cwerke kaka bilengke. cin tok fulen kwamaro, nyeu, min nuwa luma, ong min nuwa luma. ");
INSERT INTO bsj_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","min nyimom wo a dok cerkamik mor dilo kime ka-nge tikali yuwa kwaman tangbe wo Yeesu kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","miki kuru kang yo neri mani ma nuwa kwenduwe ti, ka-nge ti ka kibi kwang, can ka-nge kicatecc, kiristi an fiya dur kwimi, bwar kaka'a mor dume. ");
INSERT INTO bsj_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","minen “mu ki dumeri, kiristi, no bwar di yokka. ");
INSERT INTO bsj_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","mor bwiyeri, mi nintang wo ti gwam. ");
INSERT INTO bsj_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","la yilam digero bwaibwaye tiber digero wo yobeu. cwika miko na kũbo na ya'a yi ka-nge Yeesu, wo dige yore gwam, ");
INSERT INTO bsj_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","nyeu yilam ki dume, tam nyo ker kimer. ");
INSERT INTO bsj_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","wo min ciya ciko, min nyimom man yim nan bwanten ka-nge kom gwam dor caka kaba ka-nge bilantum mor bilengke. ");
INSERT INTO bsj_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","nyori fiye mi wiye na kom fiya yokka mor kiristi Yeesu no bou kimen takri. ");
INSERT INTO bsj_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ki ma digero daten fulen keret kiristi, na nyori. no bou mato komri kaka'a mi mani ri, nuwa kimen kom tim kibi kwamer mor yuwa tangbe wucake wiin ki nero wiin, kwilki-kwilki ker fulen keret kwama. ");
INSERT INTO bsj_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ki nuware tai nubo wuro yilam nob kiye kime. wuro yirom cinen na wuroka ciko ce, kime fuloka kime ko-wuro kwama nin ne. ");
INSERT INTO bsj_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","cin nekom yiber ker kiristi, kebo ka neka bilengke cinen ka-nge nuwa ka dotangen ker cer, ");
INSERT INTO bsj_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","na dontang wo ka to mine neu, la can ka tuwe. ");
INSERT INTO bsj_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","no nekangka bi kwannek wiri no birum neri wiri wi wo cwika netiyeri, no mwer ka-ngka duwe mor yuwa tangbe wucake wiri, no cire duwe ka-nge bunangka wiri, ");
INSERT INTO bsj_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ko dok bilantum mini bo a dim, nawo ka yilam nero wiine, kom kicwika wiin, ko mwerka-ngum mor yuwako wucake kom ki dige ka yõ kabawiin. ");
INSERT INTO bsj_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","kom mare diger ki cwika duwe kaka'a diger bi boler, nyori ki taka duwe, tu tang ne nube cin lã nen. ");
INSERT INTO bsj_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","kom tore ka dike kom cwitiye koni, nyori kom to dige kangumbo cwitiyeu. ");
INSERT INTO bsj_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ki nyimom wori ki bwikimi, buro mor kiristi Yeesu. ");
INSERT INTO bsj_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","wori yi yim na kwama dila tũbo dor cerowiin na kwama. ");
INSERT INTO bsj_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","nyori cin tũ dor cero na cang. ci ki bwi nifire, cin tũ dor cero canga cin cerkangu na nifir. ");
INSERT INTO bsj_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","con cukum dor ki co cero, cin yilam ki ne duri wo yo yaken ki co bware, bwaro wo dor bwatiye reu, ");
INSERT INTO bsj_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","nyori kwama neco duktankaku dur, con neco dendo la den gwamme. ");
INSERT INTO bsj_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ci ma wureu, na nyori mor dene Yeesu dwendo gwam an cun-cunge, dwen nobo wo kwamau, ka-nge wo dor bitinereu ka-nge wo mor bitineu ");
INSERT INTO bsj_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ca mawo na biyendo gwam, na toki ki, “Yeesu co kiristi ka-nge Teluwe ker duktongka kwama Teu. ");
INSERT INTO bsj_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","nyori kom keb mibo mi cwitiye, nawo ki ne durti ki ca tecceu nuwen, la can a lã nyo mi maniyeu. ki do fangka kime ko ki tai ka-nge, kwama bwiyek. ");
INSERT INTO bsj_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","wo kwama ma nangen ti more kime ki cwika cek ka-nge nuwa ka luma ce ken. ");
INSERT INTO bsj_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","kom ma diger gwam kebo ki fwenna kaka kwob kanka. ");
INSERT INTO bsj_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","nyori na kom yilam kom man ki kwama man ki diger bitorek ka-nge bilengke, bi bei kwama man ki diger bitorektiber kaldo wo bwira nyonlangum-nyonlangeu, woro ka yilam kira tibati mor kale. ");
INSERT INTO bsj_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","kom tam ker dume, na nyori ki bi diye kiristi na yilam ki nyial ma cwa bo cwak ka-ge nangen koni. ");
INSERT INTO bsj_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","no mwenno ci yumyeti na nuwang twika ka-nge nangen bilen keret di, miki fwor nerek ka-nge bilengka kimen gwam. ");
INSERT INTO bsj_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","nyo takeu, kom ken nuwa luma, naki bilangi ka-nge mo. ");
INSERT INTO bsj_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","nyori muki nyo-neri Teluwe Yeesu nin in twom Timoti kimen kutang bo, na fiya bi kwamar neret no nuwa dige dor kimerdi. ");
INSERT INTO bsj_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","mi mangki nii na co, wori ki bi cwom kwa kom ti ki neri. ");
INSERT INTO bsj_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","wori digero dor cire koni ci nyime kebo digero wo na Yeesu kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ka nyimom yora ceko, wori na bwe te nin, con mamen nangen mor fulen kere. ");
INSERT INTO bsj_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","nyori mi yo nerti na twom co kimen non to dige a yakenti fo ka-nge mer. ");
INSERT INTO bsj_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","miki bi kwamer neret mor Teluwe, mo ki bwimi man bou kutang bo. ");
INSERT INTO bsj_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","min tõ tam yo twom Abafaroditu a wajenku. con ka-nge far nangenne ka-nge far kwene ka-nge nii tome ka-nge canga kime dor dige mi cwitiye. ");
INSERT INTO bsj_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","wori con kung ner dor kimer, na co ya kimen gwam, wori kom nuwa ki co nuwa bo luma. ");
INSERT INTO bsj_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ki cwom ca nuwabo luma, con dadom bwar, la kwama cii dor cero, kebo co ka-nge mo, nyori nan fiyare bwiraka nere dor bwiraka nerek. ");
INSERT INTO bsj_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","nyori miki kuru ducce, twom co no komto co tak ri kan bilangi, mo keneu ner mure an daken. ");
INSERT INTO bsj_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ki yuwo Abafaraditu mor Teluwe ki for nerek gwam. kom ne dur nob na co. ");
INSERT INTO bsj_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","kin ker nangen kiristi ca dadom ca bwiyetiye, con ciya leka dume cek naci mamen nangen do wuro no kom ka matiye. ");
INSERT INTO bsj_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","diger wuyak kebmibo, kom ma fuwor nerer mor kwama nan yilam mulankumenten digero birombo kebo dige ka-nge minen. digero birombo an co kumkom. ");
INSERT INTO bsj_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","kom nyimi kibi cuwentin do. kom nyimi ka-ngi nob nangen nebo bwirko. kom nyimi ka-nge nob wor man ka. ");
INSERT INTO bsj_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","inbo nubo mwatum lare wori inbo bi wab kwamati ki yuwatangbe ceke. inbo nubo bulangti mor kiristi Yeesu, bi manki tai mor bwiye tak. ");
INSERT INTO bsj_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","la duwaleu, mo miki dor mir minwi kibi kwannerer dor bwiyer no ka-nge atin kwabi cin wi ki bi kwannererdi, mo, min laco. ");
INSERT INTO bsj_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ci mwatimen laro ki kume narube, nubo Israila nin, wo duwet lor Biliyaminu, bayahuden Yafudawa, fiye bolange min Bafarisiye. ");
INSERT INTO bsj_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","fiye nannge ne min ne Ikilisiyo dotangi kor luma nerer mor bolange min yilam mimanki diger bitoret. ");
INSERT INTO bsj_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","dila dikero birombo gwam yilam fiyaka fiye miwiyeu, mintu tukenci diger yaret ker Almasihu. ");
INSERT INTO bsj_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","nyo, mi kiyarangen digero woti cin diger yaret ker ni lala nyonka kiristi Yeesu Teebe. wori co mi cam kaba digero gwamme. min yoken ci digero manki nangen fiye miwiyeu wori nan don co ka kaba Almasihu. ");
INSERT INTO bsj_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ciya fiya ye merece. mi manki ka-nge luma doret min oblange. lanyori, min wiki lua fiye bilengke mor kiristi, lumakowo fiye kwama wuyeu wo bilengke wiyeu. ");
INSERT INTO bsj_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Naweu me cwiti nyumom kebi kwandur kwenkacek, ka-nge nuwaka dotangek ceko. nan nyilam naco tak fiye buwaree, ");
INSERT INTO bsj_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","dila cano nyori nayan lam kwenka mor tuwe. ");
INSERT INTO bsj_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ma yibo miki min fiyau digero birom, manyo takri min kweri min yilam wo dim diyeu. dila miki tok miki ci dor nan lam yom wuro kiristi Yeesu couye ker cereu. ");
INSERT INTO bsj_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","kebmibo, matok bo miki min kweri min yom wuro bwiririn dila diger wi win wo min matiye. matabunti kidige bwiyeu, midorti dige wuro kabe nin. ");
INSERT INTO bsj_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","mi doken dorti dor digerowo ci cwoye dorcereu nan fiyam cuner caka kabak wo bi cor kwamaroce diri-diriyeu mor kiristi Yeesu. ");
INSERT INTO bsj_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","gwammebe birombo tanmtabe dor cireu, bi kwaner nure wuro min cano bikwa dige ka-nge kidimendi, kwama atin dang kumen digero wo tak. ");
INSERT INTO bsj_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Dila fiye kweri balamlau, bitamo nyo. ");
INSERT INTO bsj_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","kom yilam nob biltengar rebmib, keb mibo. konto yora birombo yakenti kambo nyi yilam diger meromkar fiye ci wiyeu. ");
INSERT INTO bsj_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","nubo ducce yankenti, co nubo wo miyiki kom fulen cereu, na weu miyikomti tak lakila na nob kiyeb bentilen kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","dila ciyan buyam. wori kwama ceu fwercer, bikwan nerer cere kino mor kwenduwece. nereiro kino kalendo dor bitiner. ");
INSERT INTO bsj_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","labeu fiye yime beu kino dii kwama, fiye bi ningtongum dumetiyeu, kwama Yeesu kiristi. ");
INSERT INTO bsj_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","An fulongum bwibeu wo fuyeti fuyeu na yilam na bwiyo wo yoryoreu, ywelywele kibi kwan duret cereu naci yoken digero gwamcinen. ");
INSERT INTO bsj_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Tano nyori nob neremi yitum mibbo ka-nge wo mi bilangtiyeu, fowor neremi na bilang duwe mi, wi nure curo kom ti yora mwor Teluwe nob nere farubmib. ");
INSERT INTO bsj_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","mi kinong Afodiya, mi konong feneti, kom yilam ki yulando win mwor Teluwe. ");
INSERT INTO bsj_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","manki kwane yila mi konong komi, farub yimem kwobka tuni na bilengke: kom tikan natubo wuro nin dige biwiyeu bin nuwa dotange wari ka-nge ci mwor keret bifumer wari ka-nge kilimas kange tangnim farub mi. wuro den ciyero wi mulan-gum mwor bifumer dume. ");
INSERT INTO bsj_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ma fuwor neri mwor Teluwe kang-kang. yila mi tokti, ma fuwor neri. ");
INSERT INTO bsj_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ki dobti nubo gwam na to-o birim niri kume. Teluwe dadom. ");
INSERT INTO bsj_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","kom yaranda ki ka-nge diger na curoyeu, mwor diger gwam wari ki kwobka dul-lo ki keni-keni, ki buka ka-ngek, wori keni- keni kumen na fiya kwama. ");
INSERT INTO bsj_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","luma kwama, Atin cum gwam nyomka na wo a ywel ner kumero ka-nge nang niri kume mwor Almaciya Yeesu. ");
INSERT INTO bsj_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ki bwiko keb mibbo, gwam dige wuro yilam na bilengke ceu, gwam dige yilam na neka ducce, gwam dige yilam na cakcakkece. gwam dige yilam na kene, gwam dige yilam wo yom yowe, gwam dige bouti ki luma, gwam dige ki digewo yor-yore ci toktiye, non wiki bilengkeri, kwa ki ner dor dige buro nin. ");
INSERT INTO bsj_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","dige buro kom merangeu ki yoweu ki nuwau ki to-o mwor yim mimbo ninne, kom ma nangen ki dige buro. kwama ni luma an no-o wari ka-nge kom. ");
INSERT INTO bsj_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","min ma fuwor neri kambo ken mwor Te-e dige bwiyeu canneu kom fwelum toka kumeko ki mo. kom toye ki nwo fuwor kibo com ki kaba cumeu, dila kom fiyabo filang na tika kali mi ce. ");
INSERT INTO bsj_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","kebo na corka buni ce ma tok wure nan merang dang neri bwentano ki ma nyori. ");
INSERT INTO bsj_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","min nyimom kambo ma yiiti min kambo ma fiyati ki ducce, bwentano ki nure wuni mwor digero gwam min merang yulan kambo ma cati ka-nge kambo ma yimti ki wuran, kambo yilamti ki digero yilo nan yim mwor doka. ");
INSERT INTO bsj_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","man dol maka diger gwam wi cinnen co niwo ci bwamen na tiyeu. ");
INSERT INTO bsj_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","gwam ki na co, kom yii yimbo datenne kange mo'o mwor dotange ");
INSERT INTO bsj_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","yilo kom nyimom, kom Filibiyawa, ki kaba bifumer kere ki kwama ma dubom Makadoniya. ka-nge kurwabi mani wo bwamen na ker yoka ka-nge neka kar kom ki kwa kom. ");
INSERT INTO bsj_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","kakka ki kwama mi Tassalonika, kon tomi ki tikali kumeu wo corka buni ce cum kiristi yob. ");
INSERT INTO bsj_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","kebo ki den miki do na nero timero ba, la wo tano nyori, miki do tikali wuro ki boure ki la ka mwor yoka kumek. ");
INSERT INTO bsj_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","min yo digero gwam, min wi kiki kila rang-ngi kom bwamen fuwer, min nyo wi kang Abafroditus digero kange wi kumen, kunka lima dige muri na ficang fican-nge, yom yowe neniri datenne fo kwama. ");
INSERT INTO bsj_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","kwama mi an dim gwam dokabekko ki dor cer na cwika ceko kambo co ne wi nyo mwor Almaciya Yeesu. ");
INSERT INTO bsj_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","na yeu dobti duktongka la nuwece fo kwama ki tebe in di diiri a tinyo. ");
INSERT INTO bsj_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","yarum gwam nubo na bwangka kwama ce mwor Almasiya Yeesu. gwam yitub mi bbo ci wari ka-nge moweu ci ma yarumeti. ");
INSERT INTO bsj_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","gwam nob bwangka kereko ci mayarumeti, tam in co nubo buro ci yim yiye Kaisare. ");
INSERT INTO bsj_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","dobti luma Teluwe Yeesu Almasiya na yi wari ki yuwa tangbe kume ko. Atinyo. ");
INSERT INTO bsj_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Bulus Nii ttomange Yeecu Kriritti ki maka kwama, kange Timoti yibe. ");
INSERT INTO bsj_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Tom bo ne bilenker kange kebbebo mor Almacifu mor kolosiyawa ba, ciya ki ciyeu, Nyori luma kange fur nener ayi ari kange kom, fiya kwama tebe iyeu. ");
INSERT INTO bsj_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Nyo min ma buka kangek kwama nen, Te teluwe be Yecu Kritti, nyo kwob kumen diloti, kir-kir, ");
INSERT INTO bsj_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Nyon mwa ki bilelnker kume mor Kritti Yeecu, kange ciuka ko kom ciko dor nob kwama bo cak-cakeu. ");
INSERT INTO bsj_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Kom wiki cuika ko wo, wori kom ki yoneri yom na kume lo kwama. Kon nuwa dor yoneriro wo, na nimre mor bilenker, fulen ker. ");
INSERT INTO bsj_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Wuro bou kumeneu, fulen kero ti tui, la ti bui fiyemin gwam dor bitiner. mawo kumen kom ki diye wo ka nuwam co la ka merangum dor luma kwamak bicom. ");
INSERT INTO bsj_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Won co fulenkero na wo mo merang Abafara canga be ba cui cuiyeu won canga kritti tum nyi be nii bilenker. ");
INSERT INTO bsj_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Abafaras ni nyo cuika kume ko mor yuwatangbe kwama. ");
INSERT INTO bsj_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Ker cuika ka ro wo diye nyo nuwameu, nyo dob bo kwob ka dilo dorkumer. Nyo ti mai na ko dim ki nyomka nerer cek, kange ne ka kwamak, kange nyomka yuwa tangbek. ");
INSERT INTO bsj_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Nyo kwob diloti na ko ya yom bo daten kange Teluwe, ki mure wwo a fo cinen tiyeu. nyo kwob diloti nyo ki kan ne bbitutti mor nagenero ken, na ko ii mor nyomka cek. ");
INSERT INTO bsj_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Nyo kwob diloti ko ma bi kwamer nerer mor nyomka ki bi kwan duktangka cek. kange birom nerer kange dange. ");
INSERT INTO bsj_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Nyo kwob diloti kan ma buka kangek fur neerer Tee nin wo doki ka fiya mor kwali nob kwamar mor filang wucakkeu. ");
INSERT INTO bsj_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Con yoo boliyar kumtaciler, yila ken ki bo liyar bi bwece co cui-cuiyeu. ");
INSERT INTO bsj_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Fiye bwe nine bafiya fanka, tabka bwiran kerer. ");
INSERT INTO bsj_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Bweu co cer kang na kwama wo mani fur reu. Bwe kaba dike fwele gwam. ");
INSERT INTO bsj_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","La cinen dikero gwam fwele, buro diyeu kange buro bitineu, wo toti toweu, kange dike wo mani to tiyeu, kaka kange liyar tinnim kange Bikwan kerer, dikero gwam co ca fwel ciye, lana ce. ");
INSERT INTO bsj_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Con wi na nimre dikero gwam, more c la dikero mwerkangume. ");
INSERT INTO bsj_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Lam co dor bwiyer ki wabero, co kabau, kange bwe kabau mor nubo bwiyarangumeu. La con wiki fiye kaba mor dikere gwam. ");
INSERT INTO bsj_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","La kwama ma fur neerer toki dika ceko gwam a yi morece. ");
INSERT INTO bsj_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Na co yuwelkangum fiye bwe wiyeu, dikero gwam cinen. Kwama ma fur neerer, wo buyale ce cori dor koblom batiyem. Kwama yuwelkangum dikero gwam cinen ki bwici. kaka co dikero bitinereu kaka con wo diyeu, ");
INSERT INTO bsj_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Fiya co kom fabub kwama nen nob kiyeb ceb mor neere, kange ma ka dikero bwir. ");
INSERT INTO bsj_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","La na weu, con yuwel kangum kom ki bwiciu fiye bwareu. Co mawo na co neken kom wucak man ki kurom. ");
INSERT INTO bsj_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Na kom ca kaba ti mor bilenker di, kulumkue, Tim tiye buro mani kutar cunga fiye yoneri fulen kerero, a nuwu. Won co fulenkerero yi nubo fwelfwele tob kange lo kwamau, won co fulen kerero mo bulus ma yilam caga. ");
INSERT INTO bsj_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Naweu, miti bilangi ki dotange miu dor kumer, mor bwiye min dim dikero kum mor dotange Almasihu, wo bwiciu, co ku wabeu. ");
INSERT INTO bsj_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Ki woro kuwabeu yila canga, ki nagen do kwama ney dor kumereu, na dim tomange kwama. ");
INSERT INTO bsj_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Wuro co yurke bicome wo yurangum yurange, coti kange kaltinum. La na weu, cin fweltangu nob kwama bo wucak nen. ");
INSERT INTO bsj_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","La cinen kwama cuiti na co fweltangu cuweka duktangka yurke bilenker tiber nob kumta cile. nungi Alamacifu more kume. Nyomka duktangkako botiyeu. ");
INSERT INTO bsj_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Co nyo ne fulen cero tiye, ne ci biwerti kange merangka gwam ciyek ki nyomka gwam, la na bo ne nubo dim diye gwam mor Yeecu. ");
INSERT INTO bsj_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Ki dor wor ma nangenti mi yokten bi kwanti ki bikwan cero wo managen ti minen ki bi kwaneu. ");
INSERT INTO bsj_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Ma cuit na kon yumom kambo ma kala dor kumereu, wori nubo buro lawudi kaya kange burom bo ducce tom tikob mib wi nuwe kange teu. ");
INSERT INTO bsj_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","man ma nagen na neerciro fiya bikwan fiye mwerka ciyek mor cuika, ya ciko cweka ciyen gwam wo bicome kange nyomka yurke bilenker kwama mor Kritti. ");
INSERT INTO bsj_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","More ce fiye yoka Yulanek kange nyomka yukragume. ");
INSERT INTO bsj_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Ma tok wo kati kange kwob kang kom ki keti bibolere. ");
INSERT INTO bsj_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Bwenno ma man kange kom mor nageu, la man wi kange kom mor yuwa tangbe. Mati bilangi, to yimo kom more ceu na ken kange bikwan bilenkerer ero mor Almasifu. ");
INSERT INTO bsj_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Kambo ka yom Almacifu Teluwe, kom ya yam kumem morece. ");
INSERT INTO bsj_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Kom kulum more ce, ko mum morece, ko kulum bilenker na wo merang kumeneu, ko lerum buka kangek. ");
INSERT INTO bsj_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Ko bii yora kati yilo kange kwobkom ki nyomka kange bi beiyo bwir wo dam nubom ki bwangka dikero wo kaleu, kebo na Almasifu ce. ");
INSERT INTO bsj_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","More ce dii ka kwama ko gwam mor bwiye nunge. ");
INSERT INTO bsj_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Kom dim more ce, won co kaba bikwaneko gwam, kange liyar. ");
INSERT INTO bsj_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Mor co ci biye kumen lare, ki biyekako wo kebo nubo fir mani mor cok ka tee bwiyek. La mor biyeka kriti. ");
INSERT INTO bsj_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Fuwerum kom wari mor yuka mwegk kwamak. la more ce ci kung kom mor bilenker kibi kwan kwamar, wo kung co bwareu. ");
INSERT INTO bsj_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","kwatti kom bwiyam mor karika kerek kume kange bwinin biyeka bwikume ko, con yilam ki kom ki dume wari kange co la tab binen ki ketiro ba kangeu. ");
INSERT INTO bsj_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Con nyinangu cen kumero mulangum mulangeu, kange bidoti ciyeu, con tum ciro nunge ki kulka ko koblom bwatiye meu. ");
INSERT INTO bsj_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","con kubangum bikwantini kange liyar tinim, con kwinm kercir nure nube, con turani dor cir ki kulka ko koblom batiyeu. ");
INSERT INTO bsj_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Na nyori kange ama kumen bolang mor caka kange nokar kangeri, cuiyak ko fwir, kaka kakuk fobka. ");
INSERT INTO bsj_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Won co kakilok diker buro boutiyeu. La kendo Almasifu. ");
INSERT INTO bsj_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","kange ni cui cukka duwekti ki wabka nb tomangebo wucakeu a m kumen bolang na ko fiyare cuner kwamaro. mwan nii ro wo ki do mor dike ca toweu, la yilam ni bikwan dorek ki kwaneri ce wo bwiyeu. ");
INSERT INTO bsj_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Mani mwerkangum kange dor. Mor dore bwiyo gwam kange niyetimun ma nagentinye la ci mwerum wari. Tidui ki duikako kwama ne tiyeu. ");
INSERT INTO bsj_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Na ko bwiyam kange Almasifu ki yuwa kelkeliyo dor bitinereri yebo ko da dan kumenti na mwi kom kino tuwer kalere. ");
INSERT INTO bsj_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","ko tare, ko twire, ko kere? ");
INSERT INTO bsj_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Dikero burom bo dika ciyeko kayaka, nama nagen tiki ci ki bidoti kangemerang ka nifirek. ");
INSERT INTO bsj_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Werfun d wo wi ki nyomka wo bwiyoceu, lan bwnakakoce, wo kin koni wo cuwe kanka kange ne ka bwiyek dotange. La ci man ki kange nangen dor diwo bwiyo cuiti yeu. ");
INSERT INTO bsj_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","na kwama kung kom kange Kritti di, ku dika wo diyeu, fiye Kritti yim wi kang ko ctiyer kwamareu. ");
INSERT INTO bsj_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Kwa ki dike wo dii kwamau, kebo dike buro bitineu. ");
INSERT INTO bsj_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","La kom bwiyam dume kume yurangum yurange wari kange Almasifu mor kwama. ");
INSERT INTO bsj_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","kambo Almasifu cer knagu weu, worom co dume kume, la kom kenu kan cerkangi kange co mor duktangka cek. ");
INSERT INTO bsj_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Kom twalum dikang ka nuwe kofo dor bitinereeu, burotum kane kayatum bwini wucake, dilangkako bwir. wuro bwirayeu kange wuro co wbka fulenku. ");
INSERT INTO bsj_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Dor dike buro fumer kwama ro a bou ti dor bibei bongtuuwe. ");
INSERT INTO bsj_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","mor dikero buro ma dam kumenbe, kwatti ko yim more ciyeu. ");
INSERT INTO bsj_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","La caneu tam kom dubom buro, cilonka neererk, funer kwabaan ka ko bwir, torkanka, kange kettito yang-yange nyi kom. ");
INSERT INTO bsj_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Kom ceur de bwiti nn cuirke wori kon cokum nii a, r ko kange naen cero. ");
INSERT INTO bsj_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","Kom merum ni fwir, wo fulonti mor anyo ka ki dimer wo ya felceu. ");
INSERT INTO bsj_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Co fiye bacline man kange bayafude nii biyemeu, kange wo biyebeu. s faabub canga nii cerum cereu, baubawa kenon bacikitiy