﻿USE sofia;
DROP TABLE IF EXISTS sofia.bsc_vpl;
CREATE TABLE bsc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bsc_vpl WRITE;
INSERT INTO bsc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Gër ỹanar, Kaxanu nëcëtëguk orën ol do gë ebar el. ");
INSERT INTO bsc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ebar el er hi bax ŝoɗe-ŝoɗe, do wafërëluŋ. Ecamëɗan fo xëñ bax gër ambëxw atiw̃ax aŋo, do onjën ond Kaxanu oŋ bax xerëkerarand ƴaŋ gër amen. ");
INSERT INTO bsc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kaxanu re ko: «Gil ex angoɓen aŋ!» Ata hik angoɓen aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kaxanu wat ko mëne angoɓen aŋ eyekax ex. Ŝapëreli ko angoɓen aŋ do gë ecamëɗan el. ");
INSERT INTO bsc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kaxanu w̃ac ko angoɓen aŋ «Goyat», do ecamëɗan el «Gëmëɗ». Ata ga w̃ëɗëk do xeyëk, hik akey añanar aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kaxanu re ko: «Gil ex anguxar mërëxand ir amen do ex capëreli amen aŋ ja mërëxand!» ");
INSERT INTO bsc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ata Kaxanu ri ko ƴaŋ anguxar aŋ. Ŝapëreli ko amen and hik ɗila gër anguxar aŋ gë amen and hik ƴaŋ gër anguxar aŋ. Ata hik mondako. ");
INSERT INTO bsc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kaxanu w̃ac ko anguxar aŋ «Orën». Ata ga w̃ëɗëk do xeyëk, hik akey akinëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kaxanu re ko: «Amen and hik ɗila gër anguxar aŋ ɓarërëlex beɓët iɓat, do canayal ex eperëk el.» Ata hik mondako. ");
INSERT INTO bsc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kaxanu w̃ac ko eperëk el «Ebar», do amara and amen aŋ w̃ac ko «Angwëngw». Ata Kaxanu wat ko mëne aye yek. ");
INSERT INTO bsc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kaxanu re ko: «Ebar el dëw̃ëlex ɓeɓëlëg, ondës ond gë eneɗa, gë ɓatëx ɓañamb ƴamb, ɓand gë enëng gë enëng, do gë ɓeneɗa ɓendeɓën ak.» Ata hik mondako. ");
INSERT INTO bsc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ebar el rëw̃ëk ɓeɓëlëg, ondës ond gë ɓeneɗa, ɓatëx ɓañamb ƴamb ɓand gë enëng gë enëng, do gë ɓeneɗa ɓendeɓën ak. Kaxanu wat ko mëne aye yek. ");
INSERT INTO bsc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ata ga w̃ëɗëk do xeyëk, hik akey atasën aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kaxanu re ko: «Gil ex ɓangoɓen gër anguxar and orën, ex pitëndëraxënënd goyat in, do gë gëmëɗ in. Ɓangoɓen ɓaŋo kë hi ɓananganëme ɓand opëna, gë ɓakey, do gë ɓëniy. ");
INSERT INTO bsc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Elod ƴaŋ gër anguxar and orën ŋoɓayindëlex ebar el!» Ata hik mondako. ");
INSERT INTO bsc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kaxanu ri ko ɓangoɓen ɓatëm ɓaki: atëmënak aŋ ex ŋoɓaxënënd goyat, do atil aŋ do gë ow̃al oŋ ex ŋoɓaxënënd gëmëɗ. ");
INSERT INTO bsc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kaxanu xaw̃ ko ɓangoɓen ɓaŋo gër anguxar and orën ex ŋoɓaxënënd ebar el, ");
INSERT INTO bsc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ex ŋoɓaxënënd, aŋo goyat do ɓaŋo gëmëɗ, do ex pitëndëraxënënd angoɓen aŋ do gë ecamëɗan el. Kaxanu wat ko mëne aye yek. ");
INSERT INTO bsc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ata ga w̃ëɗëk do xeyëk, hik akey anaxën aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kaxanu re ko: «Ɓëmacar ɓëŋ ñëmbërëlexëni gër amen, do oŝël ol cëgërayindëlexëni ƴaŋ gër ebar, gër anguxar and orën!» ");
INSERT INTO bsc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kaxanu nëcëtëgu këɓi ɓoñeỹ ɓond gër angwëngw ɓoŋ, gë ɗek ɓeɓëɓëngw do këni ŝangënarand ɓën. Nëcëtëgu këɓi ɓëte ɓeɓër ỹëmbër bax gër amen ɓën, gë ɓenëng ɓendeɓën ak, do gë oŝël ol, gë ɓenëng ɓendeɓën ak. Ata Kaxanu wat ko mëne aye yek. ");
INSERT INTO bsc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kaxanu yël këɓi oɓetak ol and re ko: «Cënarin, ñëmbërin do pëxwin gër amen, polo gër angwëngw. Do oŝël ol ñëmbërëlexëni gër ebar!» ");
INSERT INTO bsc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ata ga w̃ëɗëk do xeyëk, hik akey anjoxën aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kaxanu re ko: «Ebar el dëw̃ëleɓi ɓeɓëɓëngw, gë ɓenëng ɓendeɓën ak: oyel ol, gë ɓanjën ɓaŋ, gë ow̃acar oɓapuỹ ol, er ex yo gë enëng endexëm ak!» Ata hik mondako. ");
INSERT INTO bsc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kaxanu ri këɓi ow̃acar oɓapuỹ ol, gë ɓenëng ɓendeɓën ak; oyel ol gë ɓenëng ɓendeɓën ak; do gë ɗek ɓanjën ɓand gër ebar ɓaŋ, gë ɓenëng ɓendeɓën ak. Ata Kaxanu wat ko mëne aye yek. ");
INSERT INTO bsc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kaxanu re ko: «Dinëɓëne tan ɓela ɓën gër eñaw̃ endeɓi, eni mëndër gë ɓiyi, enëɓi bëñaxënënd oxan or gër angwëngw ol, oŝël or kë ŝëgërand gër orën ol, gë oyel ol; eni bëñaxënënd ebar el ɗek, do gë ɗek ɓanjën ɓand kë ŝangënarand gër ebar ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kaxanu nëcëtëgu këɓi ɓela ɓër ex eñaw̃ endexëm ɓën. Nëcëtëgu këɓi gër eñaw̃ end Kaxanu: asoŝan do gë asoxari. ");
INSERT INTO bsc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kaxanu yël këɓi oɓetak ol and re ko: «Dëw̃ërin mbaŋ, ñëmbërin, ɗëgërayin në er ex yo, do bëñayin ebar el. Bëñayinëɓi oxan or gër angwëngw ol, oŝël or kë ŝëgërand gër orën ol, do gë ɗek ow̃acar or kë ŝangënarand gër ebar ol.» ");
INSERT INTO bsc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ata re ko Kaxanu: «Anëka yël këmun ɗek ondës ond gër ebar oŋ, gë ɓeneɗa ɓendeɓën ak, ɗek ɓatëx ɓañamb ƴamb ɓaŋ, gë ɓeneɗa ɓendeɓën ak, ex gi eƴamb edewën el. ");
INSERT INTO bsc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Emacar end ex yo gër ebar, acël and kë ŝëgërand yo ƴaŋ gër orën, er kë ŝangënarand gër ebar do hik gë onjën yo, ɗek ondës ocëkët oŋ ex eƴamb ƴamb edewën el.» Ata hik mondako. ");
INSERT INTO bsc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kaxanu wat ko ɗek er ri ko in mëne mbaŋ ye bax. Ata ga w̃ëɗëk do xeyëk, hik akey anjongamatën aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mondako faỹ ko Kaxanu edi ed orën, gë ebar el, do gë ɗek ɓeɓër ex polo gër ndeɓën ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Yatir akey anjongakinëm, Kaxanu anëka faỹ baxo ɗek andiyen and ri baxo aŋ. Gë akey anjongakinëm aŋ faỹ baxo Kaxanu andiyen and ri ko aŋ. Ata gë akey anjongakinëm aŋ seyëta ko ɗek andiyen and ri ko aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kaxanu ri ko akey anjongakinëm aŋ akey acëɓax, akey and xwën ko. Gayikwa yatijo seyëta ko ɗek andiyen and enëcëtëgu ed ɓeỹ aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mondako bax endeƴ end orën do gë ebar eŋ and nëcëtëgu ko Kaxanu aŋ. Yatir ri ko Axwën Kaxanu orën ol do gë ebar el, ");
INSERT INTO bsc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ado acëc aŋ dëŋ ax gi bana pere gër ebar. Ɓëte endës gematak ax ɗëg bana pere. Gayikwa Axwën Kaxanu axo mëlaw bana pere tëɓ iŋ gër ebar, do ala ax gi bana ar kë ỹandëra. ");
INSERT INTO bsc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ɓarikan añësa and men bax lejënd gër ebar, do bax xoŝand ɗek añangëỹang and ebar aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Axwën Kaxanu ɓaƴ këŋo asoŝan gë obar ok. Fif këŋo gër ocën onjën ond kë yëlënd aniyan oŋ. Ata hi ko ala aɓëngw. ");
INSERT INTO bsc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Axwën Kaxanu ri ko andëɗa gër ebar ed Eden, gand apën-eñan, do xwët këŋo asoŝan ar ɓaƴ baŋo an. ");
INSERT INTO bsc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Axwën Kaxanu nëcëtëgu ko gër ebar ɗek ɓatëx ɓaŋ, gë ɓenëng ɓendeɓën ak, ɓatëx ɓand ye bax owat, do nënga bax eƴamb. Ata ŝit gër ɓatëx ɓaŋo, lëg bax mërëxand ir andëɗa atëx and kë yëlënd aniyan aŋ, gë atëx and kë yëlënd enang ed enjekax do gë eñëŋënax aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yeɓ ebax na gër ebar ed Eden ir bax ỹëmënd yaɓët oɓëŋa ok, do bax xoŝand andëɗa aŋ. Ata na gër andëɗa ŝapër bax yeɓ ijo ɓambana ɓanax. ");
INSERT INTO bsc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ambana añanar aŋ bani w̃acënd Piŝoŋ. Mëŋ ɓëtak ɗek ebar ed Afila el, gër ed ex kaŋe, ");
INSERT INTO bsc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","kaŋe iw̃ënëk in. Na gër ebar elo fo ex ɓëte angiri ir këni w̃acënd bëdeliyom in do gë ekaỹ ekëɓënaxik ed këni w̃acënd onikës. ");
INSERT INTO bsc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ambana akinëm aŋ bani w̃acënd Gixoŋ. Aŋo ɓëtak ebar ed Kuŝ el. ");
INSERT INTO bsc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ambana atasën aŋ bani w̃acënd Tigër, aŋo bax fesënd apën-eñan and gër ebar ed Asiri. Ambana anaxën aŋ bani w̃acënd Ëfërat. ");
INSERT INTO bsc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Axwën Kaxanu w̃eɗ këŋo asoŝan an, do xwët këŋo gër andëɗa and Eden exo ñanënd do exo nëkonand. ");
INSERT INTO bsc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ata Axwën Kaxanu fel këŋo asoŝan an: «Axor këƴ xor eƴ ƴambënd ɗek ɓatëx ɓand gër andëɗa ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ɓari atëx and kë nangënënd enjekax do gë eñëŋënax aŋ, ax gi ex na moñamb. Gayikwa aŝës këƴ ŝës yatir këƴ ƴamb.» ");
INSERT INTO bsc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ga xucak eŋo, Axwën Kaxanu re ko: «Ax ye ex na wa asoŝan an exo gi gaɓat. Dinëlemo arëcara ar këni ỹana eni paɓërënd.» ");
INSERT INTO bsc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Axwën Kaxanu ɓaƴ këɓi gë obar ɗek ow̃acar or gër apuỹ ol, do gë ɗek ɓacël ɓand kë ŝëgërand gër orën ɓaŋ. Ŝëñëta këɓi end asoŝan eŋ exo wat ba mondake këɓi w̃acëra. Do er gë onjën yo, exo gi gë ow̃ac or këŋo yël asoŝan an. ");
INSERT INTO bsc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Asoŝan an yëlëra këɓi omac ɗek oyel ol, ɗek ɓacël ɓaŋ, do gë ɗek ow̃acar ol. Ɓari emacar gematak aŋo wat bana end kë hi arëcara ar këni ỹana eni paɓërënd. ");
INSERT INTO bsc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Axwën Kaxanu lapan këŋo asoŝan an akwëɗ atëm, asoŝan an raŝ këŋo lëɓ. Ŝosëta ko anjaw̃ amat gër ambëɓ and asoŝan, do w̃aŝ ko oƴas ok. ");
INSERT INTO bsc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gë anjaw̃ and ŝosët ko gër asoŝan aŋ, Axwën Kaxanu ri këŋo asoxari, do w̃ëla këŋo gër asoŝan. ");
INSERT INTO bsc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ata asoŝan an ga wat këŋo, re ko: «Dodo nëkoɗo ngwa ar ex ŝapar ir ŝapar iram an, ar ex eman end eman endam an. Asoxari këno ỹana eno macënd gayikwa gër asoŝan ŝosëtagu këno.» ");
INSERT INTO bsc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mëŋ ex, asoŝan an ŋaw̃ëtaleɓi nëm gë sëm eni ɓaraxën gë asoxari arexëm an, do eni gi eman emat. ");
INSERT INTO bsc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ata asoŝan an do gë asoxari arexëm an hi këni ɓën tak ɓëxi tëɓ gë ɓeman ɓeŋ, ɓari abaɓi ŝëfënandër na. ");
INSERT INTO bsc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Andën aŋ ebax emacar end siti bax nëmëc gër ɗek ow̃acar oɓapuỹ or ɓaƴ këɓi Axwën Kaxanu ol. Akey amat, ga sëka këŋo asoxari an, w̃ëka këŋo: «Kaxanu dëŋ nde rek: “Wën këren ƴambënd na ɗek ɓatëx ɓand gër andëɗa ɓaŋ?”» ");
INSERT INTO bsc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Asoxari an yaka këŋo andën aŋ: «Ɓiyi axor xor këmi mi ƴambënd ɓatëx ɓand gër andëɗa ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ɓarikan atëx and hik mërëxand gër andëɗa aŋ, Kaxanu ga re ko: “Wën këren ƴambëɗ na, këren kwixwëtaɗ na. Ga ƴamb ƴamb kën, and kën ŝës ex ɗe!”» ");
INSERT INTO bsc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ata andën aŋ fel këŋo asoxari an: «Adokiŋ an cës na! ");
INSERT INTO bsc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ɓarikan Kaxanu ga nang ko mëne yatir kën ƴamb, ɓangës ɓandewën ɓaŋ kë watëra. Ata en gi ang Kaxanu fo, en nang enjekax eŋ do gë eñëŋënax eŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Asoxari an wat ko mëne atëx aŋ anënga kë nënga eƴamb el ga yek ako owati ol. Ga ỹandi këŋo onangëran or kë yëlënd ol, xwëca ko do ƴamb ko. Yël këŋo icën indexëm ind xetëna baŋo iŋ; mëŋ ɓëte ƴamb ko. ");
INSERT INTO bsc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ata ɓangës ɓandeɓën ɓaŋ watërak ga foɗët këɓi, ata nang këni mëne tëɓ gë ɓeman ɓeŋ hi këni. Ɓan këni opat od andan do xura këni. ");
INSERT INTO bsc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ata wëlëgu këno Axwën Kaxanu ga ko ɓëtara andëɗa aŋ gë ingoc ind genëka iŋ. Asoŝan an do gë asoxari arexëm an ƴe këni, ỹafëx këni ŝit gër ɓatëx ɓand gër andëɗa, këdi këɓi wat Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Axwën Kaxanu ga këŋo w̃ac asoŝan an, w̃ëka këŋo: «Feye wa hi këƴ?» ");
INSERT INTO bsc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mëŋ yakaw ko: «Ga wëlëgu këmi gër andëɗa, ata yëdara këme gayik tëɓ gë eman eŋ hi këme, awa mëŋ ỹafaxën këme.» ");
INSERT INTO bsc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Axwën Kaxanu re ko: «Noỹo wa nangën ki mëne tëɓ gë eman eŋ hi këƴ? Ba ƴamb këƴ nde atëx and ŝëɓan bami eƴamb aŋ?» ");
INSERT INTO bsc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Yakaw ko asoŝan an: «Asoxari ar w̃ëlanëgu këƴe an, yël ke atëx aŋ, do ƴamb këme.» ");
INSERT INTO bsc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Axwën Kaxanu w̃ëka këŋo asoxari an: «Inew̃a rixën këƴ eŋo?» Yakaw ko asoxari an: «Andën aŋ yifa ke, do ƴamb këme.» ");
INSERT INTO bsc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Axwën Kaxanu re këŋo andën aŋ: «Awa wëj gayikako eŋo ri këƴ, anëka w̃e ki gër oyel ɗek, do gër ow̃acar or gër apuỹ ɗek. Gë acël andeƴ aŋ këƴ ỹana eƴ ŋexërand, do eƴ ɓelënd eɓëkwërëɓëkw el ang kë nëka ɓakey ɓandeƴ ak. ");
INSERT INTO bsc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Wëno kë ri angoỹëra and wëj do gë asoxari aŋ, angoỹëra and andëw̃ëra andeƴ aŋ, do gë andëw̃ëra andexëm aŋ. Ar andëw̃ëra andexëm an ki sëkan ɓëlëɓël gaf in, do wëj eƴo ŋat gër etak.» ");
INSERT INTO bsc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Axwën Kaxanu re këŋo ɓëte asoxari an: «Aɓaŝ këme ɓaŝ toro ind ɓacël ɓandeƴ iŋ, gë aƴambën këƴëɓi ỹana eƴëɓi dëw̃ënd oɓaŝ ol. Oñandi odeƴ ok gër icën indeƴ kë hi, do mëŋ ki w̃ëña.» ");
INSERT INTO bsc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Axwën Kaxanu re këŋo ɓëte asoŝan an: «Gayikako asoxari areƴ an ɓaxët këƴo, do ƴamb këƴ atëx and ŝëɓan bami eƴamb aŋ, ebar el aw̃e kë w̃e në endeƴ; gë aƴambën këƴ ỹana eƴ nëcëtënd eƴamb ƴamb ireƴ in ɗek ɓakey ɓand aniyan andeƴ ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Odëmbën do gë ondës kë ỹana exi ɗëgënd, do ɓeɓëlëg ɓër gër apuỹ këƴ ỹana eƴ ƴambënd. ");
INSERT INTO bsc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Gë asëw̃ëtëw̃a ir dëxas ireƴ in këƴ ỹana eƴ cotënd eƴamb ƴamb in, xali eƴ ɓaka gër ebar ed gër ed nëcëtëgu këmi; gayikwa obar hi këƴ, do gër ebar këƴ ɓaka.» ");
INSERT INTO bsc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ga xucak eŋo, asoŝan an yël këŋo asoxari arexëm an ow̃ac or «Xawa», mëne ngëŋ «Aɓëngw», gayikwa mëŋ ex nëm ir ɗek ɓër kë liyand ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Axwën Kaxanu rin këɓi ɓacuɗ ɓand ɓanar, do asoŝan an gë asoxari an ŝuɗara këni. ");
INSERT INTO bsc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Axwën Kaxanu re ko: «Ala an anëka hi ko ang ɓiyi ak gër enang ed enjekax do gë eñëŋënax. Gërëgako, kërexo kwëca na ɓëte atëx and kë yëlënd aniyan aŋ, exo ƴamb, do exo ɗiya din ir din!» ");
INSERT INTO bsc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Axwën Kaxanu w̃aỹ këɓi asoŝan an do gë asoxari an eni can andëɗa and Eden aŋ, do asoŝan an exo ñanënd ebar ed gër ed nëcëtëgu këŋo el. ");
INSERT INTO bsc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","And w̃aỹ këɓi ɓela aŋ, Axwën Kaxanu xwët këɓi gand apën-eñan and andëɗa and Eden Ocerubeŋ do gë duxuma ir gë okoɗux ir kë ŝenarand. Mondako ŝëng ko fëña ir gër atëx and kë yëlënd aniyan in. ");
INSERT INTO bsc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ga xucak eŋo, Adam, asoŝan an, nangër këni gë alindaw̃ Xawa. Alindaw̃ hi ko gë acël, rëw̃ këŋo itoŝan, do w̃ac këno Kaỹe. Gayikwa are re baxo: «Ala rëw̃ këmo, gë edëca ed Axwën Kaxanu el.» ");
INSERT INTO bsc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Rëw̃ këŋo ɓëte itoŝan, aɓinëm ar Kaỹe, do w̃ac këŋo Abel. Abel hi ko axwël ar oɓeci do gë opeỹ, do Kaỹe hi ko aỹan. ");
INSERT INTO bsc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ga niyitarak, Kaỹe w̃ëlan këŋo Axwën Kaxanu ŝaɗaxa ir er xana baxo gër ebar in. ");
INSERT INTO bsc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel mëŋ ɓëte, w̃ëlan këŋo ŝaɗaxa ir ɓëñanar ɓënd oyel orexëm, gë onil ondeɓën ak. Axwën Kaxanu nëngan këŋo end Abel eŋ, do xana ko ŝaɗaxa irexëm in. ");
INSERT INTO bsc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ɓari aŋo nëngan bana end Kaỹe eŋ, do axo kana bana ŝaɗaxa irexëm in. Ata Kaỹe xoỹ ko mbaŋ, ỹëŋënin ko dëxas irexëm in. ");
INSERT INTO bsc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Axwën Kaxanu w̃ëka këŋo Kaỹe: «Inew̃a xoỹaxën këƴ? Inew̃a ỹëŋëninaxën këƴ dëxas ireƴ in? ");
INSERT INTO bsc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kido ŝenene ri baƴ, arënëta rënëta doƴ. Ɓari gayikako aƴ di ex na ŝenene, eñëŋënax eŋ mokaŝ xaŝ ki gër ebët edeƴ ga ỹandi këŋo exi bëña. Ɓarikan wëj wa ỹapëk eƴo bëña!» ");
INSERT INTO bsc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaỹe yeƴaneli këŋo Abel aɓinëm, ga hi bani gër apuỹ, Kaỹe w̃ëlën këŋo Abel aɓinëm, do law̃ këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ata Axwën Kaxanu w̃ëka këŋo Kaỹe: «Feye exo aɓinëx Abel?» Kaỹe yaka ko: «Ame nang ex na. Ba wëno nde ex anëkona ar aɓaỹe an?» ");
INSERT INTO bsc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Re ko ɓëte Axwën Kaxanu: «Ine ri këƴ? Në ewëleme oŝat or aɓinëx oŋ ga kë xeỹëgund elod gër ebar xali gër ndam ro. ");
INSERT INTO bsc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Gërëgako wëj anëka w̃e ki, caw këƴ h̃awëta ebar ed hëlëk oŝat or aɓinëx el. ");
INSERT INTO bsc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","And këƴ ỹan ebar aŋ, ỹoweỹ aƴ ñana na eƴ kanand. Ar eɗëg këm këƴ hi, asëk aƴexërand fo këƴ ỹana eƴ ƴexërand gër ebar.» ");
INSERT INTO bsc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ata Kaỹe yaka këŋo Axwën Kaxanu: «Amena andam aŋ mbaŋ siɓëk, ame kor na me ɓuŋa. ");
INSERT INTO bsc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Anëka këƴe w̃aỹënd doro, me ŋaw̃ëta ebar ed bame ỹanënd el. Aỹafëra këmi ỹana mi ñafërand, do din ame wat na dëxas ireƴ in. Ar eɗëg këm këme hi, asëk aƴexëra fo këme ỹana me ƴexërand gër ebar. Do angëmëne mi ped gë ala, exe ɗaw̃.» ");
INSERT INTO bsc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Axwën Kaxanu yaka këŋo: «Angëmëne ala eŋo ɗaw̃ Kaỹe, ɓakëlëbëd ɓanjongëɓaki këno w̃aŝan.» Axwën Kaxanu laram ko nanganëme gër Kaỹe eni watënd ɓër këni fedënd ɓën, këdi këno law̃. ");
INSERT INTO bsc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ata Kaỹe ga xani ko eŋo ŋaw̃ëta Axwën Kaxanu, ƴe ko lëgëx ko gër ebar ed Nod, gand apën-eñan ed andëɗa and Eden. ");
INSERT INTO bsc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaỹe nangër këni gë alindaw̃. Ata alindaw̃ hi ko gë acël, rëw̃ këŋo Enok. Kaỹe ɓaƴ ko angol, do w̃acan këŋo asëñiw̃ Enok. ");
INSERT INTO bsc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok hi ko sëm ir Irad, do Irad, sëm ir Mexuyahel. Mexuyahel hi ko sëm ir Metuŝahel, do Metuŝahel, sëm ir Lemek. ");
INSERT INTO bsc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek ỹër këɓi ɓësoxari ɓëxi: aỹanar an Ada, do axinëm an, Tësila. ");
INSERT INTO bsc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada, asoxari aỹanar an, rëw̃ këɓi ɓëtoŝan ɓëki: Yabal do gë Yubal. Yabal hi ko axarëk ar ɓëxwël ɓër oyel do këni rëfarand laŋ. ");
INSERT INTO bsc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Do Yubal mëŋ, hi ko axarëk ar ɓësëmb ɓër ɓemangi do gë ɓëfarix ɓër ɓacëroti an. ");
INSERT INTO bsc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tësila, asoxari axinëm aŋ, rëw̃ këɓi ɓëte ɓëtox ɓëki: itoŝan iŋ Tubal-Kaỹe, do itoxari iŋ, Nahama. Tubal-Kaỹe hi ko asap ar ɗek ɓeɓër ex ƴawale do gë dun. ");
INSERT INTO bsc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Akey amat, Lemek fel këɓi ɓësoxari ɓërexëm ɓën: «Ada do gë Tësila, ɓaxëtin oniw̃ oram ol! Wën ɓësoxari ɓër Lemek ɓën, ɓanëf ɓandewën ɓaŋ wëlëlex eyeƴan edam el! Asoŝan këmo law̃ angëmëne ala exe këm, Itox këmo law̃ angëmëne ala exe tembaỹën. ");
INSERT INTO bsc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ɓakëlëbëd ɓanjongëɓaki këno w̃aŝan Kaỹe, ɓarikan wëno Lemek, ɓakëlëbëd ofëxw ocongoxi gë ɓanjongëɓaki këne w̃aŝan!» ");
INSERT INTO bsc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam, asoŝan an, nangër këni gë alindaw̃ Xawa. Ata Xawa rëw̃ këŋo itoŝan, do w̃ac këŋo Set. Gayikwa are re baxo: «Kaxanu yël ke itoŝan, exo ɓët gër ed ebaxo Abel, ir law̃ këŋo Kaỹe.» ");
INSERT INTO bsc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set rëw̃ këŋo itoŝan do w̃ac këŋo Enoŝ. Ata ɓela ɓën amëd aŋo ỹana këni ecale do gë emac ed Kaxanu Axwën el. ");
INSERT INTO bsc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Mondako ex akayëta and andëw̃ëra and Adam aŋ. Kaxanu, yatir nëcëtëgu këɓi ɓela, ari ri këɓi do wëndër këni gë mëŋ. ");
INSERT INTO bsc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kaxanu nëcëtëgu këɓi asoŝan an do gë asoxari an. Yël këɓi oɓetak ol, yatir nëcëtëgu këɓi dëŋ re ko enëɓi macënd ɓela. ");
INSERT INTO bsc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam ga sëk këŋo ɓëniy këme gë ofëxw osas, rëw̃ këŋo itoŝan ind wëndër këni gë mëŋ, gër eñaw̃ endexëm, do w̃ac këŋo Set. ");
INSERT INTO bsc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam liya ko ɓëniy okeme ocongotas and rëw̃ këŋo Set aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ata ga sëk këŋo ɓëniy okeme ocongonax gë ofëxw osas, Adam ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ga sëk këno ɓëniy keme gë ɓënjo, rëw̃ këŋo Enoŝ. ");
INSERT INTO bsc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set liya ko ɓëniy okeme ocongotas gë ɓënjongëɓëki and rëw̃ këno Enoŝ aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ata ga sëk këŋo ɓëniy okeme ocongonax gë epëxw gë ɓëki, Set ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoŝ ga sëk këŋo ɓëniy ofëxw ocongonax, rëw̃ këŋo Kenaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enoŝ liya ko ɓëniy okeme ocongotas gë epëxw gë ɓënjo and rëw̃ këŋo Kenaŋ aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ata ga sëk këŋo ɓëniy okeme ocongonax gë ɓënjo, Enoŝ ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenaŋ ga sëk këŋo ɓëniy ofëxw ocongoxi, rëw̃ këŋo Maxalalel. ");
INSERT INTO bsc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenaŋ liya ko ɓëniy okeme ocongotas gë ofëxw onax, and rëw̃ këŋo Maxalalel aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ata ga sëk këŋo ɓëniy okeme ocongonax gë epëxw, Kenaŋ ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maxalalel ga sëk këŋo ɓëniy ofëxw ocongeɓat gë ɓënjo, rëw̃ këŋo Yered. ");
INSERT INTO bsc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Maxalalel liya ko ɓëniy okeme ocongotas gë ofëxw osas and rëw̃ këŋo Yered aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ata ga sëk këŋo ɓëniy okeme ocongotas gë ofëxw ocongonax gë ɓënjo, Maxalalel ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yered ga sëk këŋo ɓëniy këme gë ofëxw ocongeɓat gë ɓëki, rëw̃ këŋo Enok. ");
INSERT INTO bsc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yered liya ko ɓëniy okeme ocongotas and rëw̃ këŋo Enok aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ata ga sëk këŋo ɓëniy okeme ocongonax gë ofëxw ocongeɓat gë ɓëki, Yered ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok ga sëk këŋo ɓëniy ofëxw ocongeɓat gë ɓënjo, rëw̃ këŋo Matusalem. ");
INSERT INTO bsc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enok liya ko ang këŋo nënganënd Kaxanu ak, ɓëniy okeme otas, and rëw̃ këŋo Matusalem aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ata Enok sëk këŋo ɓëniy okeme otas gë ofëxw ocongeɓat gë ɓënjo. ");
INSERT INTO bsc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok liya ko ang këŋo nënganënd Kaxanu ak, ata ɓela ɓën nema këno anema fo ga xana këŋo Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalem ga sëk këŋo ɓëniy këme gë ofëxw ocongosas gë ɓënjongëɓëki, rëw̃ këŋo Lemek. ");
INSERT INTO bsc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Matusalem liya ko ɓëniy okeme ocongoki gë ofëxw ocongosas gë ɓëki, and rëw̃ këŋo Lemek aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ata ga sëk këŋo ɓëniy okeme ocongonax gë ofëxw ocongeɓat gë ɓënjongëɓënax, Matusalem ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemek ga sëk këŋo ɓëniy keme gë ofëxw ocongosas gë ɓëki, rëw̃ këŋo itoŝan. ");
INSERT INTO bsc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","W̃ac këŋo Nowe, ga baxo rend cëŋ: «Ajo këɓo racët gër andiyen añëkaxik and këne rinde ene ɗiyaxëne gër ebar ed xare ko Axwën Kaxanu aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lemek liya ko ɓëniy okeme oco gë ofëxw ocongonax gë ɓënjo, and rëw̃ këno Nowe aŋ. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ga sëk këŋo ɓëniy okeme ocongoki gë ofëxw ocongoxi gë ɓënjongëɓëki, Lemek ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowe liya ko ɓëniy okeme oco, and rëw̃ këɓi Ŝem, gë Xam, do gë Yafet aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","And ỹana këni ɓela eñëmbër ed gër ebar aŋ, rëw̃ëra kënëɓi odënaw̃. ");
INSERT INTO bsc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ɓela ɓër ekun ed Kaxanu ɓën wat këni mëne odënaw̃ od ɓela ɓër gër ebar ok mbaŋ ye këni. Sana kënëɓi do ỹërëra kënëɓi ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ata Axwën Kaxanu re ko: «Ala an oñas fo hi ko. Wëno ame teɓ na din ir din onjën ondam oŋ gër ndexëm. Ɓëniy këme gë alapem fo ko ỹana exo ɗiyand.» ");
INSERT INTO bsc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Amëd aŋo hi bani ɓela ɓëŝakax ɓën gër ebar. Ɓëte amëd aŋo fo ɓar bani ɓela ɓër ekun ed Kaxanu ɓën gë odënaw̃ od ɓela ɓër gër ebar ok. Ɓësoxari ɓëjo rëw̃ëra kënëɓi oɓaŝ or hi bax ɓela ɓësëm, ɓangwëlik ɓand akarëk ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Axwën Kaxanu wat ko mëne eñëŋënax end bani rind ɓela gër ebar eŋ axuri xurik. Er xëñ bax gër ow̃ëkw oreɓën wayët ɓanjëlan ɓañëŋënax fo. ");
INSERT INTO bsc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Axwën Kaxanu ŝena këŋo er ɓaƴaxën baɓi ɓela in gër ebar. Gër emëkw edexëm ŝena baŋo endeɓën eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ata re ko Axwën Kaxanu: «Ebar el këme fat eni dëxëtaxën ɓela ɓër ɓaƴ këmëni ɓën. Afat këme fat gë ɓela ak, gë oyel ak, gë ɓanjën ak, do gë oŝël ak. Gayikwa ɗek ŝena ke er ɓaƴaxën bamëni in.» ");
INSERT INTO bsc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ɓarikan Nowe ŝot ko oyekax or Axwën Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Mondako ex andëw̃ëra and Nowe aŋ. Nowe mëŋ cëŋ, ala ar ŝenene do ar ɗal ebaxo. Ang këŋo nënganënd Kaxanu ak baxo liyand, mërëxand ir ɓandëw̃ëra ɓand ɓela ɓër angwën aŋo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowe mëŋ, ocambenjar otas rëw̃ baɓi: Ŝem, gë Xam do gë Yafet. ");
INSERT INTO bsc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ebar el anëka sëmba bax gër owat or Kaxanu. Ɓela ɓën mbaŋ wër bani. ");
INSERT INTO bsc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ebar etëmbak fo baxo watënd Kaxanu, gayikwa ɓela ɓën edi ed ɓetëmbak fo wata bani gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ata Kaxanu fel këŋo Nowe: «Ekwët ed ɓeỹ ɗek el h̃atëguk, ang faỹ këme gër emëkw edam ak. Gayikwa owër fo ex gër ebar në end ɓela ɓësëmbak eŋ. Anemin këmëni nemin ɗek gë ebar ak. ");
INSERT INTO bsc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ɓarikan wëj Nowe, pikanayal akuluŋ and otëx od ax bërënd na. Cetëndëriɗ akuluŋ aŋo ɓaciw̃ ɓaciw̃ do notayiɗ gë otesesan amëlëf do gë amëfac. ");
INSERT INTO bsc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mondako këƴ fika akuluŋ aŋo: acakëŝak in, ometër keme gë ofëxw oco, añangëỹang in, ometër alapem gë oco, do ƴaŋ-ƴaŋ in, ometër epëxw gë oco. ");
INSERT INTO bsc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Pikayiɗ ƴaŋ ang aciw̃ ŝëxw këƴ fo. Do teɓayiɗ amëd and gwër në enëxar fo, në beɓët iɓat. Teɓayiɗ ɓëte ebët në beɓët iɓat. Tëndëndëriɗ gër kuluŋ isëm ijo ɓaciw̃ ɓatas. ");
INSERT INTO bsc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Wëno cëŋ, ata këme w̃ëlaw ampumbuluỹët or këɓi nemin ɗek ɓeɓër ex gë onjën ɓën. Ɗek er ex gë onjën yo gër ebar kë nemi. ");
INSERT INTO bsc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ɓarikan eter këmi yata. Do ɗiliɗën gër akuluŋ aŋo wëj, gë ɓosëñix, gë alindax, do gë ɓolindaw̃ ɓor ɓosëñix. ");
INSERT INTO bsc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ɗëniɗëɓi gër akuluŋ aŋo ɗek ow̃acar oɓëngw ol, enëm gë ecan, eni ɓayixën ɓëɓëngw ang wëj ak. ");
INSERT INTO bsc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Enëng end oŝël end ex yo, gë enëng end ow̃acar or gë osapar onax end ex yo, gë enëng end ow̃acar or xaɗa-xaɗa end ex yo, do gë ɓanjën ɓaŋ, aƴow këni ƴow gër akuluŋ andeƴ, enëm gë ecan, eni ɓayixën ɓëɓëngw. ");
INSERT INTO bsc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ɓariɗ ɗek ɓeɓër kën ỹana en ƴambënd ɓën, gë ɓeɓër këni ỹana eni ƴambënd ɓën. Do mëxwëtayiɗ, en ƴambëraxënënd wëj gë ekun edeƴ el, do gë ow̃acar ol.» ");
INSERT INTO bsc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ata Nowe ri ko ɗek er fel baŋo Kaxanu in, ang fel baŋo ak dëŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Axwën Kaxanu fel këŋo Nowe: «Ɗilin gër akuluŋ wëj do gë ekun edeƴ el ɗek. Gayikwa mërëxand ir ɓandëw̃ëra ɓand ɓela ɓër gë okey oko ɓaŋo, wëj gaɓat wat këmi ar ŝenene an. ");
INSERT INTO bsc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Meɗëlëɓi ow̃acar ocongoxi, enëm gë ecan, gër enëng kala end ow̃acar ow̃ënëk, ɓëte gër ɗek ow̃acar oɓuyaraxik, enëm gë ecan. ");
INSERT INTO bsc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Meɗëlëɓi ɓëte ɓacël ɓanjongëɓaki, anëm gë acan, ex ɓayixën ɓenëng ɓendeɓën ɓeŋ ɗek ebar el. ");
INSERT INTO bsc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Gayikwa ro gë ɓakey ɓanjongëɓaki, tëɓ iŋ këme w̃ëlaw do ex tëɓ gëmëɗ gë goyat, ɓakey ofëxw onax. Mondako këmëni fat gër añangëỹang ir ebar, ɗek ɓeɓër gë onjën do ɓaƴ këmëni ɓën.» ");
INSERT INTO bsc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ata Nowe ri ko ɗek er fel baŋo Axwën Kaxanu in. ");
INSERT INTO bsc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Amëd aŋo, Nowe anëka sëk baŋo ɓëniy okeme ocongiɓat ga ƴowëk ampumbuluỹët aŋ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ata Nowe, gë ɓosëñiw̃, gë alindaw̃, do gë ɓolindaw̃ ɓor ɓosëñiw̃ lil këni gër akuluŋ këdi këɓi law̃ ampumbuluỹët aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ɗek ow̃acar ol, hik ow̃ënëk ol, hik oɓuyaraxik ol, gë oŝël ol, do gë ɗek ɓeɓër kë ƴexërand xaɗa-xaɗa gër ebar ɓën, ");
INSERT INTO bsc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ƴow këni gër akuluŋ and Nowe, ɓeki ɓeki, gë enëm gë ecan, eni ɗilaxën gër akuluŋ, ang fel baŋo Kaxanu Nowe ak. ");
INSERT INTO bsc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ga xucak ɓakey ɓanjongëɓaki, amen aŋ yëpëtak xali xwëcarak ebar el. ");
INSERT INTO bsc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ata yatir sëk këŋo Nowe ɓëniy okeme ocongiɓat, gë opacaw̃ oki, gë ɓakey epëxw gë ɓanjongëɓaki, fëti bax ɗek ɓañësa ɓand men ɓand ex gër ebar ɓaŋ. Men ond ƴaŋ oŋ ỹanak kë yëpëtand ga fërëtayak ɓamëd ɓand gër orën ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tëɓ iŋ kë yëpëtand gër ebar, gëmëɗ gë goyat, xali ɓakey ofëxw onax. ");
INSERT INTO bsc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kwël yatijo fo lil bani gër akuluŋ Nowe, gë ɓosëñiw̃, Ŝem, gë Xam, gë Yafet, gë alindaw̃ arexëm, do gë ɓësoxari ɓësas ɓër ɓosëñiw̃ ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Alil lil bani ɓëte ɗek ɓenëng ɓend ow̃acar or gër apuỹ ɓeŋ, gë ɓend oyel ɓeŋ, gë ɓend ɓanjën ɓand kë ŝangënarand gër ebar ɓeŋ; gë ɓenëng ɓend oŝël ɓeŋ, do gë ɗek ɓend ɓanjën ɓand kë ŝëgërand ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ɗek ɓeɓër gë onjën ɓën, ƴow këni gër Nowe, enëm gë ecan, eni ɗilaxën gër akuluŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ɗek ɓeɓijo ƴow këni, enëm gë ecan, enëng end ex yo, ang re baxo Kaxanu ak. Ata Axwën Kaxanu fëra ko ebët ed akuluŋ el, gër epoƴ ed Nowe. ");
INSERT INTO bsc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ebar el ɗek ỹëmëk xali nëkak ɓakey ofëxw onax. Key yo key bax ỹëmbërënd amen aŋ xali lëɓinak akuluŋ aŋ. Ata kuluŋ aŋ xangëk ƴaŋ gër amen and hi bax gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Amen aŋ ga ɓaŝërëk ƴaŋ gër ebar do ampumbuluỹët aŋ kë w̃ëlarand akuluŋ aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ɓëte kwël dëŋ bax ɓaŝërënd amen aŋ, ata ŝiliparak kwëc ɗek osënd oŝakax or ex gër ebar oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Osënd oŋ ŝiliparak polo gër amen në ometër ocongoki ba ocongotas. ");
INSERT INTO bsc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ɗek ɓeɓër ɓaƴ baɓi Kaxanu do bani ŝangënarand gër ebar ɓën, nemira këni: oŝël ol, gë oyel ol, gë ow̃acar oɓapuỹ ol, gë ɗek ɓanjën ɓand bax ƴexërand gër ebar ɓaŋ, do gë ɗek ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ɗek ɓeɓër ebax gë onjën gër ebar ɓën ŝësëra këni. ");
INSERT INTO bsc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mondako fat këɓi Kaxanu ɗek ɓeɓër gë onjën ɓër bax liyand gër ebar ɓën. Ga ỹana këɓi ɓela ɓën, felata këɓi ow̃acar osëm ol, gë osil ol, gë oŝël ol, do gë ɓanjën ɓaŋ. Fat këɓi ɗek ebar el. Ata ɓayi këni Nowe, do gë ɓër hi bax gë mëŋ gër akuluŋ ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Amen and oỹëm aŋ xwëndak gër ebar xali sëkëk opacaw̃ oco. ");
INSERT INTO bsc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ɓarikan Kaxanu xwita këŋo Nowe gë ɗek ow̃acar oɓapuỹ ol, do gë oyel or hi bani gë mëŋ polo gër akuluŋ ol. Kaxanu w̃ëlaw ko ekoc gër ebar, ata amen aŋ ỹanak ebëxw el. ");
INSERT INTO bsc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ɓañësa ɓand men ɓand gër ebar ɓaŋ lëmayak, do men ond ƴaŋ oŋ seɓëk eyëpëtan el ga fërëtayak ɓamëd ɓand gër orën ɓaŋ. Tëɓ iŋ xanik. ");
INSERT INTO bsc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ata amen aŋ kë wëxënd tëkër tëkër gër ebar. Ga xucak opacaw̃ oco, amen aŋ ỹanak kë ɓaŝëtand. ");
INSERT INTO bsc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yatir sëkëk ɓakey epëxw gë ɓanjongëɓaki, gë facaw̃ icongixinëm in, akuluŋ aŋ rëɗayak gër atënd and Ararat. ");
INSERT INTO bsc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Amen aŋ kwël dëŋ bax wëxënd. Ata gë akey añanar and facaw̃ ir epëxwën aŋ, oyur or osënd oŋ ŝanayak. ");
INSERT INTO bsc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ga xucak ɓakey ofëxw onax, Nowe fërët ko fonetër ir seɓa baxo gër akuluŋ in. ");
INSERT INTO bsc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Seɓët këŋo aŋërak aŋ. And ko ŝëgëraraw aŋ aɓakaw baxo ɓakawënd ɓakëlëbëd ɓandanjëm, xali nand wëxëk amen gër ebar na. ");
INSERT INTO bsc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Seɓët këŋo eɗëxwëte epeŝax el exo nëkonëragu angëmëne amen aŋ aɓaŝëta ɓaŝëtak gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ɓari eɗëxwëte epeŝax el axo cot bana në er ko lapax. Ata kwël ɓakaw ko gër Nowe, polo gër akuluŋ, gayikwa amen aŋ kwël ɓayi bax gër ebar. Ga yën ko ataxan aŋ, Nowe sëraw këŋo eɗëxwëte epeŝax el, do lën këŋo gër ed hi baxo, lëf gër akuluŋ. ");
INSERT INTO bsc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ŝëni ko ɓëte ɓakey ɓanjongëɓaki ɓacëxe, do seɓët këŋo gaŝëxe eɗëxwëte epeŝax el exo can akuluŋ. ");
INSERT INTO bsc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eɗëxwëte epeŝax el w̃aỹigu ko genëka ga yapëgu ko apat acëkët and añarëka! Mondako nang baxo Nowe mëne amen aŋ aɓaŝëta ɓaŝëta bax gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ŝëni ko ɓëte ɓakey ɓanjongëɓaki ɓacëxe, do seɓët këŋo eɗëxwëte epeŝax el. Ɓarikan aŋo, axo ɓakaw ex na gër ndexëm. ");
INSERT INTO bsc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yatir sëk këŋo Nowe ɓëniy okeme ocongiɓat gë imat, gë akey añanar and facaw̃ iỹanar aŋ, men oŋ wëxëk do ebar el ferëk. Nowe laɓët ko ejur ed akuluŋ el, wat ko mëne ebar el anëka ferëk bax. ");
INSERT INTO bsc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ebar el ɗek fer bax yatir sëkëk facaw̃ ixinëm in, ɓakey alapem gë ɓanjongëɓaki. ");
INSERT INTO bsc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ata Kaxanu fel këŋo Nowe: ");
INSERT INTO bsc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Canin gër akuluŋ, wëj, gë asoxari areƴ an, gë ɓosëñix, do gë ɓësoxari ɓëreɓën ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nëcëtëlëɓi ɓëte ɗek ow̃acar ol, gë oŝël ol, gë oyel ol, gë ɓanjën ɓand kë ŝangënarand gër ebar ɓaŋ. Canëlexëni eni ɓeñëta ebar el ɗek, do eni cënarëx!» ");
INSERT INTO bsc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nowe, gë ɓosëñiw̃, gë asoxari arexëm an, do gë ɓësoxari ɓër ɓosëñiw̃ ɓën, ŝan këni gër akuluŋ. ");
INSERT INTO bsc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ɗek ow̃acar ol, gë ɓanjën ɓand kë ŝangënarand gër ebar ɓaŋ, do gë oŝël ol ŝan këni ɓëte, gë enëng gë enëng. ");
INSERT INTO bsc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ata Nowe ri ko angëɓ and eŋo calexënënd Axwën Kaxanu. W̃eɗ këŋo emacar emat gër ɓenëng ɓend ow̃acar ow̃ënëk, do acël amat gër ɓenëng ɓend oŝël ow̃ënëk, do rin këŋo Axwën Kaxanu ŝaɗaxa ir momëlën, ƴaŋ gër angëɓ. ");
INSERT INTO bsc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Axwën Kaxanu ga wëran këŋo otëñer onëngax oŋ, re ko: «Ang nemin këme ebar në end ɓela ak, din ame nemin na. Gayikwa ow̃ëkw or ɓela oŋ eñëŋënax fo nangëk elod amëd and oŝambenjar aŋ. Ang nemin këme er ex gë onjën yo, ɓëte din ame nemin na. ");
INSERT INTO bsc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ang kë nëka yo ebar el, oneɗëran ok do gë ekanaran el, aƴem in do gë aƴëka in ecaŝa el do gë ekol el, goyat in do gëmëɗ in din ir din kë ɓayi.» ");
INSERT INTO bsc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kaxanu ga këɓi yël oɓetak ol Nowe do gë ɓosëñiw̃, re ko: «Dëw̃ërin mbaŋ, ñëmbërin, ɗëgërayin në er ex yo gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Emacar end ex yo gër ebar, gë acël and kë ŝëgërand yo gër orën, gë er kë ŝangënarand yo gër ebar, do gë ekan ed ex yo gër angwëngw, ayëda kënun ỹana enun yëdand, do ahër kënun ỹana enun gërënd: wën xwën këɓi. ");
INSERT INTO bsc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Er kë ŝangënarand do hik gë onjën yo, do gë ɗek ɓeɓëlëg ɓën ex eƴamb ed yël këmun el. ");
INSERT INTO bsc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ɓarikan, këren ƴambënd na ỹas er emacar eŋ gë enjëw̃ endexëm ak, mëne ngëŋ gë oŝat orexëm ak. ");
INSERT INTO bsc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Oŝat orewën oŋ, aniyan andewën aŋ ex. Mëŋ ex emacar end këŋo law̃ yo ala, aw̃ëka këmo w̃ëkaɗ. Ɓëte ala ar këŋo law̃ yo ala aŝandaw̃, aw̃ëka këmo w̃ëkaɗ. Ala kala aw̃ëka këmo w̃ëkaɗ end aniyan and aŝandaw̃ eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ar këŋo law̃ ala an, ala fo këŋo law̃ mëŋ ɓëte. Gayikwa Kaxanu ri këŋo ala an gër eñaw̃ endexëm. ");
INSERT INTO bsc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Do wën, dëw̃ërin mbaŋ do ñëmbërin, ɗëgërayin në er ex yo, do ñëmbërin gër ebar.» ");
INSERT INTO bsc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kaxanu fel këɓi ɓëte Nowe do gë ɓosëñiw̃: ");
INSERT INTO bsc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Wëno cëŋ, eter sana këmun wën, do gë ɓërandëw̃ëra andewën ɓën, ang këni ɓëtëraw gër ebar ak. ");
INSERT INTO bsc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Eter edam elo ahi hik ɓëte ed gë ɗek ɓeɓër gë onjën, gë ɗek oŝël, gë ɗek oyel, do gë ɗek ow̃acar oɓapuỹ el. Wën ɗek ɓër ŝanëguk gër kuluŋ isëm ɓën sana këmun gë eter elo, gë ow̃acar oɓapuỹ ak. ");
INSERT INTO bsc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Paɓ gë eter elo këme rend: “Ɓëte din amëni nemin na gë ampumbuluỹët ɗek ɓeɓër gë onjën ɓën, do din ampumbuluỹët ax pat na ebar el”.» ");
INSERT INTO bsc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Re ko ɓëte Kaxanu: «Watin nanganëme ir eter ed sana këmun wën do gë ɗek ɓeɓër gë onjën ɓër hik gë wën el, ang këni ɓëtëraw ɓandëw̃ëra ɓandëw̃ëra, din ir din ak. ");
INSERT INTO bsc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Aw̃asin këmun ỹana mun masinënd ŝandiw̃ in, ang atumb fo gër ɓaŋar. Ata ŝandiw̃ in ex nanganëme ir eter ed wëno do gë ebar el. ");
INSERT INTO bsc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","And këme ɓar ɓaŋar do ex ɓeɗi orën aŋ, ŝandiw̃ in aŝanaya kë ỹana ex canayand ƴaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ata mondako këme ỹana me pëɓënd eter ed wëno gë wën do gë ɗek ɓeɓër gë onjën el. Men oŋ ax ñana na ex ñëmbërënd xali ex gi ampumbuluỹët and këɓi fat ɗek ɓeɓër gë onjën ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ŝandiw̃ in aŝanaya kë ỹana ex canayand and kë ɓeɗi orën aŋ. Do awat këme ỹana me watënd me pëɓaxënënd eter ed din ir din ed wëno Kaxanu do gë ɗek ɓeɓër gë onjën gër ebar el.» ");
INSERT INTO bsc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ata Kaxanu fel këŋo Nowe: «Ŝandiw̃ in ex nanganëme ir eter ed ri këme wëno gë ɗek ɓër ex gër ebar in.» ");
INSERT INTO bsc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ɓosëñiw̃ ɓor Nowe, Ŝem, gë Xam do gë Yafet, ŝanëgu bax gër kuluŋ isëm. Xam hi ko sëm ir Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ata ocambenjar otas od Nowe oko rëw̃ërëk ɗek ebar el. ");
INSERT INTO bsc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe hi ko aỹan. Ata ri ko andëɗa and reseŋ. ");
INSERT INTO bsc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Akey amat, ga ŝeɓ ko ngoƴ iŋ, ỹaw këŋo. Laki ko tëɓ gë eman eŋ lëf gër aner andexëm. ");
INSERT INTO bsc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Xam, sëm ir Kanahaŋ, sëk këŋo Nowe tëɓ gë eman eŋ. And ŝan ko an, ko reƴaxënd fac gër ɓoɓinëm Ŝem do gë Yafet. ");
INSERT INTO bsc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ŝem do gë Yafet ga wël këni ang ri baxo sëm ireɓën ak, lapara këni acuɗ atëm, sëka këno gë epoƴ el, do laɓ këno. Ga w̃aŝan bano epoƴ el, ano wat ex na tëɓ gë eman eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","And xoc këŋo Nowe ngoƴ ind ỹaw baŋo aŋ, nang ko er ri këŋo ŝambenjar iɓeja irexëm in. ");
INSERT INTO bsc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ata re ko: «Aw̃e këŋo w̃e Kanahaŋ! Xaɗëp ir okaɗëp od ɓoɓinëm ko hi!» ");
INSERT INTO bsc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Re ko ɓëte: «Cëkwayino Axwën Kaxanu, mëŋ ar xwën këŋo Ŝem an, ɓarikan Kanahaŋ hik xaɗëp irexëm in! ");
INSERT INTO bsc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Wëno Kaxanu kë ỹangën ebar ed xwën ko Yafet el! Alëg ko lëg ŋëŝ gër ɓaner ɓand Ŝem, do Kanahaŋ kë hi xaɗëp irexëm in!» ");
INSERT INTO bsc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ga xucak ampumbuluỹët aŋ, Nowe ɓaŝa ko ɓëte ɓëniy okeme otas gë ofëxw oco. ");
INSERT INTO bsc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ata and sëk këŋo ɓëniy okeme ocongonax gë ofëxw oco aŋ, Nowe ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Mondako bax ɓandëw̃ëra ɓand ocambenjar od Nowe Ŝem, gë Xam do gë Yafet ɓaŋ. Ɓëtoŝan rëw̃ëra banëɓi and xucak ampumbuluỹët aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ɓosëñiw̃ ɓor Yafet ebani: Gomer, gë Magog, gë Medi, gë Yafan, gë Tubal, gë Meŝek do gë Tiras. ");
INSERT INTO bsc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ɓosëñiw̃ ɓor Gomer ebani: Aŝëkenas, gë Rifat do gë Togarëma. ");
INSERT INTO bsc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ɓosëñiw̃ ɓor Yafan ebani: Eliŝa do gë Tarësis, gë Ŝipër do gë Rod. ");
INSERT INTO bsc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Oɓaŝ oreɓën ol rëw̃ërëk gër oŝir or ɓenëng ɓend owar oreɓën, do ed ɓamëŋa ɓand ɓangwëngw el. Ala kala gë eyeƴan edexëm el, do gë ebaca edexëm el, lëgëra këni gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ɓosëñiw̃ ɓor Xam ebani: Kuŝ, gë Mitësërayim, gë Put, do gë Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ɓosëñiw̃ ɓor Kuŝ ebani: Seba, gë Afila, gë Sabëta, gë Rama do gë Sabëteka. Ɓosëñiw̃ ɓor Rama ebani: Saba do gë Dedan. ");
INSERT INTO bsc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ata Kuŝ hi ko sëm ir Nimërod. Nimërod ijo ebax angwëlik añanar aŋ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kamara isëm hi baxo ogës od Kaxanu. Mëŋ bani rexënënd ɓela ɓën: «Kamara isëm, ogës od Axwën Kaxanu, ang Nimërod fo.» ");
INSERT INTO bsc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ata Nimërod wun ko gër ɓangol ɓand ebar ed Ŝinehar ɓaŋo: Babilon, gë Erek, gë Akad, do gë Kalëne. ");
INSERT INTO bsc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Akey amat, Nimërod ga xani ko gër ebar elo, ƴe ko gër ed Asiri. Ɓaƴëx ko ɓangol ɓand Ninif, gë Rexobot, do gë Kalax ɓaŋ, ");
INSERT INTO bsc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","do gë angol and Resen aŋ, and ebax fëco Ninif, fëco Kalax, angol atëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ɓosëñiw̃ ɓor Mitësërayim ebani: ɓandëw̃ëra ɓand Lud, gë ɓandëw̃ëra ɓand Anem, gë ɓandëw̃ëra ɓand Lehab, gë ɓandëw̃ëra ɓand Nafëtu; ");
INSERT INTO bsc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","gë ɓandëw̃ëra ɓand Patëros, gë ɓandëw̃ëra ɓand Kasëlu, do gë ɓandëw̃ëra ɓand Kafëtor ɓaŋ. Ofilisëteŋ ok ɓërandëw̃ëra and Kasëlu exëni ɓën ɓëte. ");
INSERT INTO bsc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanahaŋ hi ko sëm ir Sidoŋ, itoŝan iñanar indexëm iŋ, do sëm ir Het. ");
INSERT INTO bsc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Mëŋ fo bax axarëk ar ɓandëw̃ëra ɓand Yebus, gë ɓand Amor, do gë ɓand Girëgaŝ an. ");
INSERT INTO bsc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Mëŋ fo bax ɓëte, axarëk ar ɓërandëw̃ëra and Het, gë ɓand Arëki, gë ɓand Sini, ");
INSERT INTO bsc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","gë ɓërandëw̃ëra and Arëfad, gë ɓand Tësëmar, do gë ɓand Amat an. Ata oɓaŝ or Kanahaŋ ol, mondako ŝapërëra këni ɓandëw̃ëra ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ebar ed oɓaŝ or Kanahaŋ el ỹanak elod gër ebar ed Sidoŋ, gand beɓët ir Gerar, ƴek xali gër Gasa. Do gand beɓët ir Sodom, ƴek ɓëte xali gër Gomor, gër Adëma, gër Tësoboyim, do xali gër Leŝa. ");
INSERT INTO bsc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Mondako hi bani ɓosëñiw̃ ɓor Xam gër owar oreɓën, ebaca gë ebaca, eyeƴan gë eyeƴan, nëng gë nëng. ");
INSERT INTO bsc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ŝem ɓëte gë oɓaŝ ebaxo. Mëŋ ebax itoŝan ikarënak ind Nowe iŋ, do aɓinëm ar Yafet, sëm ir Eber do gë ɓosëñiw̃. ");
INSERT INTO bsc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ɓosëñiw̃ ɓor Ŝem ebani: Elam, gë Asiri, gë Arëpakëŝad, gë Lud do gë Aram. ");
INSERT INTO bsc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ɓosëñiw̃ ɓor Aram ebani: Utës, gë Hul, gë Geter, do gë Maŝ. ");
INSERT INTO bsc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arëpakëŝad rëw̃ këŋo Ŝela, do Ŝela rëw̃ këŋo Eber ");
INSERT INTO bsc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber rëw̃ këɓi ɓëtoŝan ɓëki: ow̃ac or iñanar ol ebax Peleg, gayik gë ɓakey ɓand rëw̃ këno ɓaŋ ŝetërëk ebar el. Do ow̃ac or aɓinëm ol ebax Yokëtaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokëtaŋ rëw̃ këɓi Alëmodad, gë Ŝelef, gë Atësarëmafet, gë Yerax, ");
INSERT INTO bsc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","gë Adoram, gë Usal, gë Dikëla, ");
INSERT INTO bsc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","gë Obal, gë Abimayel, gë Saba, ");
INSERT INTO bsc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","gë Ofir, gë Afila, do gë Yobab. Ɓëjo ɗek ebax ɓosëñiw̃ ɓor Yokëtaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ɓën lëg bax elod gër ebar ed Meŝa, beɓët ir Sefar, xali gër osënd or apën-eñan. ");
INSERT INTO bsc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ɓën ebax ɓosëñiw̃ ɓor Ŝem, ebaca gë ebaca, eyeƴan gë eyeƴan, nëng gë nëng, gër owar oreɓën. ");
INSERT INTO bsc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ata mondako rëw̃ër bani ɓosëñiw̃ ɓor Nowe, ang sëfërëra këni gër ɓandëw̃ëra ɓandeɓën ak, gë ɓenëng ɓendeɓën ɓeŋ. Ɓandëw̃ëra ɓandeɓën ɓaŋ ŝapërëk enëng gë enëng, do ɓeñëta këni ebar el and xucak ampumbuluỹët aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Amëd aŋo, eyeƴan eɓat fo ebax ngwën iŋ ɗek, do elo fo bani yeƴanënd ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ga xaniw këni apën-eñan, sëk këni angëni añangax gër ebar ed Ŝinehar. Ata lëgëra këni na. ");
INSERT INTO bsc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ata ỹana këni këni rend: «Ɓaƴëne tan osingiri do ene bëkaye mo mbëka ex kemaxën!» Gër ed ebax eni ɓaƴ gë oxaỹ, nëmb këni osingiri. Ata këni ɓaƴënd gë eɗaka ed petërol el, gër ed ebax eni ɓaƴ gë simaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Akey amat, re këni: «Angol and këne xwëne këne ɓaƴe, do gë aciw̃ atëndëndër and gë ejur ed kë h̃at ŋëŝ gër orën. Mondako këne hiye ɓangwëlik, do ane capërëraye ex na ɗek ebar el!» ");
INSERT INTO bsc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Axwën Kaxanu feda ko exo nëkon angol aŋ, do gë aciw̃ atëndëndër and bani ɓaƴënd ɓela ɓëjo aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Re ko Axwën Kaxanu: «Watinëɓi ɓela ɓëjo ga hi këni ɓulunda iɓat, do këni yeƴanënd eyeƴan eɓat. Angëmëne mondako ỹana këni, er këni wëlër eni di yo, axor këni xor! ");
INSERT INTO bsc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Awa pedane tan ene bële eyeƴan edeɓën elo, eni tëkwanaxën ewëlër ed andeɓën reɓën el!» ");
INSERT INTO bsc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ata Axwën Kaxanu, mondako ŝapëreli baɓi ɓela ɓëjo, ebar el ɗek, do kwël seɓ këni eɓaƴ ed angol el. ");
INSERT INTO bsc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mëŋ w̃acaxën këni angol aŋo «Babel», mëne ngëŋ «Ambële». Gayikwa Axwën Kaxanu na wël ko eyeƴan eɓat ed ebax ɗek ebar el. Yatijo ŝapëreli këɓi ɓela ɓën do yëcar këni ebar el ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Mondako bax ɓandëw̃ëra ɓand Ŝem ɓaŋ. Ŝem ga sëk këŋo ɓëniy këme, rëw̃ këŋo Arëpakëŝad ga xucak ɓëniy ɓëki elod ga hi bax ampumbuluỹët aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And rëw̃ këŋo Arëpakëŝad aŋ, Ŝem liya ko ɓëniy okeme oco. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arëpakëŝad ga sëk këŋo ɓëniy ofëxw osas gë ɓënjo, rëw̃ këŋo Ŝela. ");
INSERT INTO bsc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And rëw̃ këŋo Ŝela aŋ, Arëpakëŝad liya ko ɓëniy okeme onax gë ɓëtas. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ŝela ga sëk këŋo ɓëniy ofëxw osas, rëw̃ këŋo Eber. ");
INSERT INTO bsc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And rëw̃ këŋo Eber aŋ, Ŝela liya ko ɓëniy okeme onax gë ɓëtas. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber ga sëk këŋo ɓëniy ofëxw osas gë ɓënax, rëw̃ këŋo Peleg. ");
INSERT INTO bsc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And rëw̃ këŋo Peleg aŋ, Eber liya ko ɓëniy okeme onax gë ofëxw osas. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ga sëk këŋo ɓëniy ofëxw osas, rëw̃ këŋo Rehu. ");
INSERT INTO bsc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And rëw̃ këŋo Rehu aŋ, Peleg liya ko ɓëte ɓëniy okeme oki gë ɓënjongëɓënax. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu ga sëk këŋo ɓëniy ofëxw osas gë ɓëki, rëw̃ këŋo Serug. ");
INSERT INTO bsc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And rëw̃ këŋo Serug aŋ, Rehu liya ko ɓëniy okeme oki gë ɓënjongëɓëki. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug ga sëk këŋo ɓëniy ofëxw osas, rëw̃ këŋo Naxor. ");
INSERT INTO bsc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And rëw̃ këŋo Naxor aŋ, Serug liya ko ɓëniy okeme oki. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naxor ga sëk këŋo ɓëniy alapem gë ɓënjongëɓënax, rëw̃ këŋo Terax. ");
INSERT INTO bsc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And rëw̃ këŋo Terax aŋ, Naxor liya ko ɓëniy këme gë epëxw gë ɓënjongëɓënax. Rëw̃ këɓi ɓëte ɓëtoŝan do gë ɓëtoxari. ");
INSERT INTO bsc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terax ga sëk këŋo ɓëniy ofëxw ocongoxi, rëw̃ këɓi ɓëtoŝan ɓëtas: Abëram, gë Naxor, do gë Xaraŋ. ");
INSERT INTO bsc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Mondako bax ɓandëw̃ëra ɓand Terax ɓaŋ. Terax, rëw̃ këɓi ɓëtoŝan ɓëtas: Abëram, gë Naxor do gë Xaraŋ, ar rëw̃ këŋo Lot an. ");
INSERT INTO bsc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ata Xaraŋ ŝësët ko gë sëm Terax, fën gër Ur, gër ebar ed Ɓëkalëde, gër ed rëw̃ këno. ");
INSERT INTO bsc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abëram do gë Naxor ỹër këni. Asoxari ar Abëram an këno w̃acënd Sarayi, do ar Naxor an, Milëka, aɓiw̃ ar Xaraŋ, sëm ir Milëka do gë Yisëka. ");
INSERT INTO bsc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi axo gi bana gë oɓaŝ. Asoxari aɓoroxok ebaxo. ");
INSERT INTO bsc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Akey amat, Terax faỹ ko gër emëkw edexëm exo dëfa. W̃ëlali këɓi: asëñiw̃ Abëram, gë Lot, asëñiw̃ ar Xaraŋ an, do gë aɓiw̃ ar eñër Sarayi, alindaw̃ ar Abëram an. Ɓën ɗek xani bax na gër ebar ed Ur ir Ɓëkalëde, do ƴe këni ond gër ebar ed Kanahaŋ oŋ. Ata ga h̃at këni gër Xaraŋ, lëg këni na. ");
INSERT INTO bsc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terax ga sëk këŋo ɓëniy okeme oki gë ɓënjo gër angol and Xaraŋ, ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Akey amat, Axwën Kaxanu fel këŋo Abëram: «Canël ebar edeƴ el, ebar ed gër ed rëw̃ këni el. Teɓëlëɓi ɓër ekun ed sorix ɓën, do ƴel gër ebar ed këmi w̃asin. ");
INSERT INTO bsc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Wëno ki ri ar gë oɓaŝ or kë rëw̃ër ɓulunda isëm. Wëno ki yël oɓetak ol, wëno ki ri eƴ gi angwëlik. Do paɓ gë wëj këni ɓeta ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ayël këmëni ỹana mëni yëlënd oɓetak ol, ɓër ki yël oɓetak ɓën. Do axare këmëni ỹana mëni karend ɓër ki xare ɓën. Oxun or gër ebar oŋ ɗek kë ɓeta paɓ gë wëj.» ");
INSERT INTO bsc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mondako rëfa baxo Abëram, ang fel baŋo Axwën Kaxanu ak, do Lot sëfa këŋo. Amëd aŋo, Abëram anëka sëk baŋo ɓëniy ofëxw ocongoxi gë ɓënjo, and ŝan ko angol and Xaraŋ aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abëram w̃ëlali këɓi alindaw̃ Sarayi, gë Lot, asëñiw̃ ar aɓinëm, gë ɓela ɓër ekun edexëm ɓër yëc baɓi na gër Xaraŋ ɓën, do gë ɗek ɓeɓër ŝotëra baxo na ɓën. Ata h̃at këni gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","And h̃at këni gër ebar ed Kanahaŋ, Abëram ƴe ko cangët ebar elo, xali gër Siŝem, gër ɓananga ɓand More. Amëd aŋo, ɓërandëw̃ëra and Kanahaŋ ɓën lëgëra bax gër ebar elo. ");
INSERT INTO bsc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Axwën Kaxanu ga ŝanayaxën këŋo Abëram, re ko: «Awël nde, ebar elo ro këmëni yël ɓërandëw̃ëra andeƴ ɓën.» Ata Abëram ri ko angëɓ and eŋo calexënënd Axwën Kaxanu, na gër ed ŝanayaxën baŋo. ");
INSERT INTO bsc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ga xucak eŋo, Abëram ga xani ko na, rëfa ko gër etënd ed apën-eñan ed angol and Bet-El. Ata rix ko ɓaner ɓandexëm ɓaŋ mërëxand: angol and Bet-el aŋ, acëla-eñan, do gë and Ayi aŋ, apën-eñan. Ga ri ko ɓëte na angëɓ and eŋo calexënënd Axwën Kaxanu aŋ, ŝalera këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ga nëkanak, Abëram fakët ko oñe oŋ, akwëndaya gë akwëndaya, gand ladawe ir Negeb. ");
INSERT INTO bsc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ata h̃atëguk enjo na gër ebar ed Kanahaŋ. Abëram rëfa ko gëɗ gër ebar ed Misëra, exo ñëpax ang aliyer fo, gayik enjo eŋ mokuma xuma bax gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ɗam eni ŋat gër ebar ed Misëra, Abëram fel këŋo alindaw̃ Sarayi: «Wëj asoxari ayekax hi këƴ. ");
INSERT INTO bsc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","And këni wat Ɓëmisëra aŋ, ata këni nang mëne asoxari aram hi këƴ. Ata ene ɗaw̃, do wëj eni teɓ. ");
INSERT INTO bsc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Këla deyiɗ mëne aɓaỹe fo hi këƴ, ene mëlayaxën ŝenene, do me pexaxën në endeƴ.» ");
INSERT INTO bsc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And h̃at këni gër Misëra aŋ, Ɓëmisëra ɓën wat këni mëne asoxari an mbaŋ dëŋ ye ko. ");
INSERT INTO bsc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ɓëlëngw ɓër ex ler gër Farawoŋ ɓën ga wat këno ɓën ɓëte asoxari an, këno ŝëkwëxënd gër Farawoŋ. Ata w̃ëla këno asoxari an gër Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Emun end Misëra eŋ likinaxën këŋo mbaŋ Abëram në end asoxari eŋ. Yëlëra këŋo: opeỹ, gë oɓeci, gë oxeƴ, gë opali onëm do gë ocan, gë ogelemba, gë okaɗëp otoŝan do gë okaɗëp otoxari. ");
INSERT INTO bsc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ɓarikan Axwën Kaxanu lapan këɓi oŝëxwëra osëm Farawoŋ do gë ɓër ekun edexëm ɓën në end Sarayi, asoxari ar Abëram an. ");
INSERT INTO bsc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ata Farawoŋ ga w̃ac këŋo Abëram, re ko: «Inew̃a rixën këƴe endeƴ eŋo? Inew̃a ɓayik aƴe pel ex na mëne asoxari areƴ exo? ");
INSERT INTO bsc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Inew̃a felaxën këƴe: “Aɓaỹe ex!” Nëkoɗ gako ga ỹandi baxe mo ñër! Awa gërëgako, nëkoɗo asoxari areƴ an, kanalo en ƴe!» ");
INSERT INTO bsc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farawoŋ ga felëra këɓi ɓela ɓërexëm ɓën, laŋëta kënëɓi Abëram, gë asoxari arexëm an, do gë ɗek ɓeɓër yëlëra baŋo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ga xucak eŋo, Abëram gë alindaw̃ xani këni gëɗ gër ebar ed Misëra, ɓën do gë ɗek ɓeɓër xwën bani ɓën, ɓaka këni gër ladawe ir Negeb. Lot baɓi sëfërand. ");
INSERT INTO bsc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abëram, ar gë napul hi baxo. Mbaŋ ŝotëra baxo: oyel oranjëm, gë koɗi, do gë kaŋe. ");
INSERT INTO bsc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ata Abëram ko ɓakand ed hi bax ɓakwëndaya ɓandexëm el, elod gër ladawe ir Negeb, xali gër Bet-El, gër ed ri baxo ɓaner, fëco Bet-El, fëco Ayi. ");
INSERT INTO bsc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ga sëkëx ko angëɓ and ri baxo aŋ, Abëram ŝale këŋo Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, mëŋ ar baŋo sëfarand Abëram an, aŝotëra ŝotëra baxo ɓëte: opeỹ, gë oɓeci, do gë oxeƴ. Gë ɓaner ɓandexëm pit ebaxo. ");
INSERT INTO bsc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Na gër ed lëg bani Abëram gë Lot, mëreƴ ebax gayik mbaŋ ỹëmb bani oyel oreɓën ol. Ax mënd bana eni ɓayi në ereɓat. ");
INSERT INTO bsc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ɓëte ɓërandëw̃ëra and Kanahaŋ do gë and Perisi ɓën ebax ɓëraketa andeɓën ɓën. Ata akey amat, ɓëxaɗac ɓër oyel or Abëram ɓën sakër këɓi gë ɓër oyel or Lot ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ata Abëram fel këŋo Lot: «Axara xara këmi, wëno gë wëj, këreɓo takër na. Ɓëte ɓëxaɗac ɓër oyel oram ɓën, gë ɓër oyel oreƴ ɓën, këreɓi takër na! Gayik ɓiyi ɓër ekun eɓat hi ke! ");
INSERT INTO bsc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nëkoɗ ebar el, calal gand ed këƴ ƴe, këla capëre. Angëmëne gand ŝame ƴe këƴ, wëno me ƴe gand liw̃. Angëmëne gand liw̃ ƴe këƴ, wëno me ƴe gand ŝame.» ");
INSERT INTO bsc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot ga nëkonara ko, wat ko ɗek ebar ed ler gër yeɓ ir Yurëdeŋ el, ang ed këni xoŝand fo. Mondako bax ebar elo, xali yatir ɓëlën ko Axwën Kaxanu ɓangol ɓand Sodom do gë Gomor ɓaŋ. Ang andëɗa and Axwën Kaxanu fo, ang ebar ed Misëra fo bax, xali gër ingol ind Tësowar. ");
INSERT INTO bsc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ata Lot sana ko ɗek ebar ed ler gër yeɓ ir Yurëdeŋ el, rëfa ko kwël apën-eñan. Mondako ŝapër bani Abëram gë Lot. ");
INSERT INTO bsc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abëram ɓayi ko gër ed hi bani, na gër ebar ed Kanahaŋ. Lot lëgëx ko gër ɓangol ɓand ler gër yeɓ ir Yurëdeŋ. Rix ko ɓaner ɓandexëm ɓaŋ ŋëŝ gër Sodom. ");
INSERT INTO bsc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Xarak, Ɓësodom ɓën, mbaŋ sëmba bani, do mbaŋ bano w̃enanënd Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Akey amat, Axwën Kaxanu fel këŋo Abëram, and ŝapër këni gë Lot aŋ: «Këla, nëkonaral elod na gër ed hi këƴ, gand ambëng, gand ambëtëɓ, gand apën-eñan do gand acëla-eñan. ");
INSERT INTO bsc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ɗek ebar ed këƴ watënd elo, wëno yël këŋun en kwën din ir din, wëj do gë oɓaŝ oreƴ ol. ");
INSERT INTO bsc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aŝënan këmëni ŝënanëɗ oɓaŝ oreƴ ol xali eni ñëmb ang oŝeñi fo. Angëmëne afën këni fënënd oŝeñi oŋ, afën kënëɓi ỹana enëɓi pënënd ɓëte oɓaŝ oreƴ ol. ");
INSERT INTO bsc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ɓëtarayind ebar elo ang ŝakëk ak, do ang ỹangëk ak, ayël këmi yël.» ");
INSERT INTO bsc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abëram ga rëfali ko ɓaner ɓandexëm ɓaŋ, ƴe ko lëgëx ko gër ɓananga ɓand Mamëre, ler gër Ebëroŋ. Ata rix ko angëɓ eŋo calexënënd Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ɓaniy ɓaŋo, wun bani: Amërafel gër Ŝinehar, Arëyok gër Elasar, Këdorëlawomer gër Elam, do Tidal gër Goyim. ");
INSERT INTO bsc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ɓemun ɓeŋo ɓar bax enëɓi mereli Bera, emun end gër Sodom eŋ, gë Birëŝa, emun end gër Gomor eŋ, gë Ŝinehab, emun end gër Adëma eŋ, gë Ŝemeber, emun end gër Tësoboyim eŋ, do gë emun end gër Bela, ir bani w̃acënd ɓëte, Tësowar eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ɓemun ɓeŋo ɗek ɓar baɓi ocoroɗa odeɓën ok gër eɗen ed Sidim, gër ed ɓëtëk doro anjer and gë ongal aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Këdorëlawomer wëña baɓi ɓemun ɓeŋo elod ɓëniy epëxw gë ɓëki. Ɓarikan gë iniy epëxw gë itasën iŋ, h̃ëp këni mbëña iŋo. ");
INSERT INTO bsc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ata gë iniy epëxw gë inaxën iŋ, Këdorëlawomer do gë ɓemun ɓend ɓar baɓi eno ɗaŋëta gër emer ɓeŋ, xor kënëɓi ɓërandëw̃ëra and Rafa ɓën gër Aŝëtarot-Karënayim, gë ɓërandëw̃ëra and Susi ɓër gër Xam ɓën, gë ɓërandëw̃ëra and Emi ɓën, do gë ɓër gër angëni and gër Kiriyatayim ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Xor kënëɓi ɓëte ɓërandëw̃ëra and Hor ɓën, gër etënd edeɓën, gër Seyir. Sëf kënëɓi xali gër etënd ed gër Paraŋ, ler gër ladawe. ");
INSERT INTO bsc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ata këni ɓakand ond gër Eyin-Miŝëpat oŋ, gër ed këni w̃acënd ɓëte Kadeŝ. Fën xorëx banëɓi ɓërandëw̃ëra and Amalek ɓën, ɗek ebar edeɓën el, do gë ɓërandëw̃ëra and Amor ɓër lëg bax gër Xatësatësoŋ-Tamar ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ata ɓemun ɓend gër Sodom, gër Gomor, gër Adëma, gër Tësoboyim ɓeŋ, do gë emun end gër Bela eŋ, mëne ngëŋ Tësowar, ɓarër këni eni meraxën gë ɓën gër eɗen ed Sidim. ");
INSERT INTO bsc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Gë Këdorëlawomer, emun end Elam eŋ, gë Tidal, emun end Goyim eŋ, gë Amërafel, emun end Ŝinehar eŋ, do gë Ariyok, emun end Elasar eŋ bani w̃erënd. Ɓemun ɓenjo bax w̃erënd gë ɓemun ɓenax. ");
INSERT INTO bsc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na gër eɗen ed Sidim elo, mbaŋ ỹëmb bax ɓambëxw ɓand gë eɗaka ed petërol ɓaŋ. And bani hërënd aŋ, emun end Sodom, do gë end Gomor eŋ wëc këni polo. Ata ɓemun ɓecëxe ɓeŋ hër këni end etënd eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ɓër xor baɓi ɓën w̃eɗ këni ɗek napul ir hi bax gër Sodom do gër Gomor in. Ga lëɓinara këni gë ɗek ŝëlafana ireɓën ak, kwël ƴe këni. ");
INSERT INTO bsc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Asërali sërali bano ɓëte Lot, asëñiw̃ ar aɓinëm ar Abëram an, ga lëg baxo cëŋ gër Sodom. Ga ɓoki këno gë ɓacota ɓandexëm ak, kwël ƴe këni. ");
INSERT INTO bsc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ata ala aɓat ga ŝana këɓi, hër ko felëx këŋo Abëram, ar enëng end Eber an. Amëd aŋo lëg baxo Abëram ler gër ɓananga ɓand Mamëre, arandëw̃ëra and Amor an. Ɓoɓinëm ɓorexëm ebani Eŝëkol do gë Aner, oɗawo od Abëram ok. ");
INSERT INTO bsc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abëram sam ga wël ko mëne Lot, asëñiw̃ ar aɓinëm arexëm an, asëra sëra këno, sana këɓi gër okaɗëp odexëm ocambenjar okeme otas gë epëxw gë ocongotas, od rëw̃ kënëɓi gër ekun edexëm. Ga yëlëra këɓi oỹënga or emer oŋ, sëf kënëɓi ɓemun ɓend w̃ëlali baŋo Lot ɓeŋ, xali gër ebar ed Dan. ");
INSERT INTO bsc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ata Abëram ŝetëndër këɓi ɓër laŋëta baŋo gër emer ɓën, ɓenga ɓenga, enëɓi ŋw̃ëlënaxën gëmëɗ ɓemun ɓend banëɓi sëfënd ɓeŋ. Ata ga xor kënëɓi ɓemun ɓeŋo, w̃ayëra kënëɓi xali gër Xoba, angol and ex ambëng and Damas aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ata Abëram ɓakaliw ko ɗek napul ir xanaw baxo in. Ɓakaliw këŋo ɓëte Lot, asëñiw̃ ar aɓinëm arexëm an, gë ɓacota ɓandexëm ak, gë ɓësoxari ɓën do gë ɓela ɓëŝëxe ɓër sërara banëɓi ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ata emun end Sodom eŋ xaca këŋo Abëram, and baxo ɓakawënd ga xorëgu këɓi Këdorëlawomer do gë ɓemun ɓend ɓar baɓi gër emer, gër eɗen ed Ŝafe ɓeŋ. Eɗen elo bani w̃acënd ɓëte, eɗen ed emun. ");
INSERT INTO bsc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melëkisedek, emun end Salem eŋ, xacali këŋo Abëram, ɓamburu do gë ngoƴ. Melëkisedek ijo, aŝaɗaxan ar Kaxanu, mëŋ Ar ex Ƴaŋ an, hi baxo. ");
INSERT INTO bsc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ata Melëkisedek ga këŋo ŝalen Abëram ko rend: «Kaxanu, mëŋ ar ex ƴaŋ an, mëŋ ar rik orën do gë ebar an, yëlëleŋo Abëram oɓetak ol. ");
INSERT INTO bsc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Aye ri ko Kaxanu, mëŋ ar ex Ƴaŋ an, mëŋ ar xorën ki ɓërangoỹëra andeƴ an!» Ata Abëram yëlëra këŋo Melëkisedek, epëxw kala ed ɗek er xanagu baxo el. ");
INSERT INTO bsc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Emun end Sodom eŋ fel këŋo Abëram: «Maŝëguye ɓela ɓën, do ɓayilexi ɓeɓër xanaragu këƴ ɓën.» ");
INSERT INTO bsc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abëram yaka këŋo emun end Sodom eŋ: «Ataxan andam aŋ yën këme exo wat Axwën Kaxanu, mëŋ ar ex ƴaŋ an, mëŋ ar rik orën do gë ebar an. ");
INSERT INTO bsc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Wëno ỹoweỹ axe ɓayi na ɗe. Ado ingux ind apeɗ dëŋ axe ɓayi na këdi këƴ ỹana eƴ dend: “Wëno yëlëra këŋo Abëram hixën ko ar gë napul!” ");
INSERT INTO bsc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wëno ỹoweỹ axe ɓayi na. Er ke ɓayi wayët er këni ƴamb ocambenjar odam in, do gë er këɓi ɓayi oɗawo odam in: Aner, gë Eŝëkol do gë Mamëre. Ɓën cëŋ ɓayileɓi ma indeɓën iŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ga xucak eŋo, Axwën Kaxanu ga këŋo felëra Abëram në lakeli re ko: «Këreƴ yëdara na Abëram! Wëno ex angwak andeƴ aŋ, epupa ed këmi fupa el mbaŋ rafëk.» ");
INSERT INTO bsc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yaka këŋo Abëram: «Axwën Kaxanu, ine ngwa këƴe yël? Itox amo dëw̃ ex na gër aniyan andam. Do Eliyeser iɓ Damas kë ɓëteli ekun edam el.» ");
INSERT INTO bsc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Re ko ɓëte Abëram: «Andëw̃ëra aƴe yël ex na. Ar rëw̃ këno ɓëŝëxe gër iciw̃ indam fo kë ɓëteli ekun edam el.» ");
INSERT INTO bsc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ata re ko gaŝëxe Axwën Kaxanu: «Ax gi ex na mëŋ kë ɓëteli ekun edeƴ el. Ɓarikan ar ex oŝat oreƴ dëŋ kë ɓëteli.» ");
INSERT INTO bsc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ata Axwën Kaxanu ga w̃ëla këŋo Abëram fac, re ko: «Këla, keŋal orën ol eƴ pënaxën ow̃al oŋ, angëmëne axor xor këƴ.» Re ko ɓëte: «Mondako këni ỹëmb ɓërandëw̃ëra andeƴ ɓën.» ");
INSERT INTO bsc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abëram xwëta ko eyeƴan ed Axwën Kaxanu el. Ata Axwën Kaxanu xwët këŋo Abëram ar ŝenene. ");
INSERT INTO bsc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Re ko ɓëte: «Wëno ex Axwën Kaxanu, ar nëcëtëgu ki gër Ur, ebar ed Ɓëkalëde an, mi yëlaxënati oxwën or ebar elo ro ol.» ");
INSERT INTO bsc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ata w̃ëka ko Abëram: «Axwën Kaxanu, gë ine këme nangaxën mëne axwën këme xwën ebar elo?» ");
INSERT INTO bsc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yaka këŋo: «Ŋaŝënële ŝaɗaxa ŝambana ir ixeƴ ir ɓëniy ɓëtas, gë emeci end ɓëniy ɓëtas, gë xondo ir ɓëniy ɓëtas, do gë olëxwëte oxi: eɓat eɓapuỹ, elo ekwëlëxwël.» ");
INSERT INTO bsc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ata Abëram h̃aŝ këɓi ɗek ow̃acar olo. Ŝaxëra këɓi end ex kala mërëxand, do xwët ko obeɓët oki ok ler ler. Ɓarikan aɓi cax bana olëxwëte ol. ");
INSERT INTO bsc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ata oyafe ol kënëɓi lapaxënënd ow̃acar or h̃as baɓi ol. Ɓarikan Abëram këɓi w̃aỹërand. ");
INSERT INTO bsc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ga kë ŝëla eñan eŋ, Abëram raŝ këŋo lëɓ. Anjiỹ atëm do gë acamëɗan xul këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Axwën Kaxanu, fel këŋo Abëram: «Nangël mëne ɓërandëw̃ëra andeƴ ɓën aƴe këni ƴe eni ñëpax ang ɓëliyer fo në ebar ed kënëɓi wëñax. Ɓër lëgëk gër ebar elo ɓën enëɓi di okaɗëp odeɓën do enëɓi torolira xali ex nëka ɓëniy okeme onax. ");
INSERT INTO bsc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ɓarikan anëp këmëni nëpëɗ enëng end ɓër këɓi wëñaɗ eŋ, and këmëni nëcët aŋ, do ɓën eni mëlali napul isëm. ");
INSERT INTO bsc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Do wëj anëka këƴ ŝës ecës ejekax do eni mëxwëta, xarak gë onënga fo xar këƴ. ");
INSERT INTO bsc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Awa ejiw̃ ekënukënu ɓën kë ɓakawëɗ ro gër ebar elo. Gayikwa amëd aŋo, ɓërandëw̃ëra and Amor ɓën anëka këɓi ɓëro edi ed ɓetëmbak el.» ");
INSERT INTO bsc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","And ŝëlak eñan aŋ, wur in ŝamëɗanëk xali xurik. H̃atëguk angoɗux and gë okwëcën, do ang enjeb fo, xucak mërëxand ir ow̃acar or ŝaxëra baɓi Abëram ol. ");
INSERT INTO bsc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ata Axwën Kaxanu, yatijo yata baŋo eter el Abëram. Fel këŋo: «Ebar elo ro, wëno yël këɓi ɓërandëw̃ëra andeƴ ɓën. Añangëỹang irexëm in ỹanak elod gër yeɓ ir gër ebar ed Misëra, do ƴek xali gër yeɓ isëm ir këni w̃acënd Ëfërat in. ");
INSERT INTO bsc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Aƴe ƴek ɓëte xali gër ebar ed ɓërandëw̃ëra and Kayëni, xali gër ed ɓërandëw̃ëra ɓand Keni, do gë Kadëmoni. ");
INSERT INTO bsc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Aƴe ƴek ɓëte xali gër ebar ed ɓërandëw̃ëra and Het, xali gër ed ɓërandëw̃ëra and Perisi, xali gër ed ɓërandëw̃ëra and Rafa. ");
INSERT INTO bsc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Aƴe ƴek ɓëte xali gër ebar ed ɓërandëw̃ëra and Amor, xali gër ed ɓërandëw̃ëra and Kanahaŋ, xali gër ed ɓërandëw̃ëra ɓand Girëgaŝ do gë Yebus.» ");
INSERT INTO bsc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi, alindaw̃ ar Abëram an, itox aŋo dëw̃ën bana. Ɓarikan xaɗëp isoxari iɓ Misëra ŝot baŋo na, do bano w̃acënd Agar. ");
INSERT INTO bsc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ata Sarayi fel këŋo icën indexëm iŋ Abëram: «Gayikako Axwën Kaxanu ri ke ar gë ɓëtox këm, nëkoɗo xaɗëp isoxari iram in. Axara xara këmi ɓarindën angaw̃ amat gë xaɗëp isoxari iram in. Ɓamat paɓ gë mëŋ këmo ŝot itoŝan.» Ata Abëram w̃a ko end fel baŋo Sarayi eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abëram anëka lëg baxo ɓëniy epëxw na gër ebar ed Kanahaŋ and w̃eɗ këŋo Sarayi Agar, xaɗëp isoxari iɓ Misëra irexëm in, do ỹërëndër këɓi gë Abëram, icën indexëm iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ata Abëram ɓar këni angaw̃ amat gë Agar. Agar hi ko gë acël. And wat ko mëne gë acël hi ko aŋ, këŋo yafënd Sarayi, axwën arexëm an. ");
INSERT INTO bsc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ata Sarayi fel këŋo Abëram: «Eŋo amena andeƴ ex! Wëno dëŋ ỹërëndër këŋun wëj gë xaɗëp isoxari iram in. Ɓarikan anëka ke yafënd elod ga nang ko mëne gë acël hi ko. Awa Axwën Kaxanu këɓo xiti wëno gë wëj!» ");
INSERT INTO bsc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abëram yaka këŋo Sarayi: «Xaɗëp isoxari ireƴ ga hi ko wa, gër otaxan odeƴ exo. Dilo ang ki ỹandi ak.» Ata Sarayi ỹana ko këŋo rixërand xali Agar hër ko eŋo canaxën. ");
INSERT INTO bsc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Meleka ir Axwën Kaxanu in sëk këŋo Agar gër ladawe, ler gër andu and hik gër fëña ir Ŝur. ");
INSERT INTO bsc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","W̃ëka këŋo: «Agar, xaɗëp isoxari ir Sarayi in, feye wa xaniw këƴ, do feye wa këƴ ƴend?» Yaka ko Agar: «Ahërëgu hërëgu këmo mo canaxën Sarayi, axwën aram an.» ");
INSERT INTO bsc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Meleka ir Axwën Kaxanu in re ko: «Ɓakal gër axwën isoxari areƴ, do ɓuŋal ang ki rixëra yo.» ");
INSERT INTO bsc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Meleka ir Axwën Kaxanu in re ko ɓëte: «Ɓërandëw̃ëra andeƴ ɓën mbaŋ këmëni ŝënan. Ala ax ñana na exo korënd eɓi pën, gayik mocëna këni ŝëna.» ");
INSERT INTO bsc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ɓaŝ ko ɓëte meleka ir Axwën Kaxanu in: «Nëkoɗ ga ŝot këƴ acël aŋ, itoŝan këƴo rëw̃ do yëliɗo ow̃ac or Isëmayel, (Kaxanu awël ko wëlënd). Gayikwa Axwën Kaxanu awël wël ko oniw̃ oreƴ ol gër ocëmu odeƴ. ");
INSERT INTO bsc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ar këƴo rëw̃ ajo er ko hi ang fali iɓapuỹ fo, ɓela ɗek këɓi ỹana eɓi merelind, ɓëte ɓela ɗek këŋo ỹana eŋo merelind; gaɓat ko ỹana exo ɗiyand, ed timëriŋ el.» ");
INSERT INTO bsc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ata Agar w̃ac këŋo Axwën Kaxanu, mëŋ ar yeƴaneli baŋo an: «Wëj ex El Royi», mëne ngëŋ, «Kaxanu, mëŋ ar ke watënd an.» Gayikwa are baxo rend: «Awat nde ngwa wat këmo ar wat ke an?» ");
INSERT INTO bsc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ata mëŋ këni w̃acaxënënd andu aŋo: «Andu and Laxahi Royi», mëne ngëŋ «Aɓëngw ar ke watënd an». Andu aŋo hik fëco Kadeŝ, fëco Bered. ");
INSERT INTO bsc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar ga ɓaka ko gër iciw̃ ind Abëram, rëw̃ën këŋo itoŝan. Abëram w̃ac këŋo Isëmayel, itoŝan ind rëw̃ën këŋo Agar iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abëram anëka sëk baŋo ɓëniy ofëxw ocongosas gë ɓënjongimat, and rëw̃ këŋo Agar Isëmayel aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Amëd aŋo, Abëram anëka sëk baŋo ɓëniy ofëxw ocongonax gë ɓënjongëɓënax. Axwën Kaxanu ŝanaxën këŋo, do re ko: «Wëno ex Kaxanu, ar fangak an. Ɗiyayind ogës odam ang ke nënganënd ak, do gil ar ɗal. ");
INSERT INTO bsc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Wëno yata ki eter el. Wëno ki yël oɓaŝ oranjëm.» ");
INSERT INTO bsc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ata Abëram lapaya ko mopoxi, eƴiỹ el ŋëŝ gër ebar. Re ko ɓëte Kaxanu: ");
INSERT INTO bsc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Endam eŋ cëŋ, eter ed yata këmi el ex: wëj eƴ gi sëm ir ɓenëng ɓend ɓela ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ow̃ac oreƴ ol ax bo na Abëram. Abëraxam këni ỹana eni macënd, gayikwa wëno yata ki eƴ gi sëm ir ɓenëng ɓendanjëm. ");
INSERT INTO bsc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Oɓaŝ or këƴëɓi rëw̃ ol mbaŋ këni ỹëmb. Wëno ki ŝënan ɓenëng ɓenëng, do ɓemun kë ŝanaya na gër andëw̃ëra andeƴ. ");
INSERT INTO bsc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Wëno yata këŋun eter el, wëj do gë ɗek ɓanjex ɓand ɓërandëw̃ëra andeƴ ɓaŋ. Eter elo ed din ir din kë hi. Mondako këme hi wëno Kaxanu, ar xwën këŋun wëj do gë ɓërandëw̃ëra andeƴ an. ");
INSERT INTO bsc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ayël këmun yël wëj do gë ɓërandëw̃ëra andeƴ ɓën oxwën or ebar ed gër ed ỹëpa kën ang ɓëliyer fo ol. Oxwën or din ir din yël këmun ɗek ebar ed Kanahaŋ el, ene nangaxën mëne wëno ex Kaxanu, wëno ar xwën këŋun an.» ");
INSERT INTO bsc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kaxanu fel këŋo ɓëte Abëraxam: «Wëj ɗëkayal aye eter ed yata këmun wëj do gë ɗek ɓërandëw̃ëra andeƴ el, ang këni ɓëtëraw ɓanjex ɓanjex ak. ");
INSERT INTO bsc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mondako kë hi eter ed yata këmun wëj do gë ɓërandëw̃ëra andeƴ el: itoŝan ind ex yo eno kacënd axac. ");
INSERT INTO bsc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Oxac ol kë hi nanganëme ir eter ed yata këmun in. ");
INSERT INTO bsc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Lëmëta ir këno rëw̃ yo, kacino and këŋo sëk ɓakey ɓanjogëɓatas aŋ. Mondako kën ỹana en dind gë ɓërandëw̃ëra andewën ɓën. Kacindënëɓi ɓëte okaɗëp ok: hi këni od rëw̃ kënëɓi gër iciw̃ nde, hi këni od yëc këƴëɓi gë koɗi në ɓëliyer, gër ɓër ax gi ex na ɓër ekun edeƴ nde. ");
INSERT INTO bsc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kacindëleno ar rëw̃ këno yo gër iciw̃ indeƴ, do gë ar yëc këƴo yo gë koɗi ireƴ an. Oxac ol kë hi gër ɓeman ɓendewën, nanganëme ir eter ed din ir din ed yata këmun el. ");
INSERT INTO bsc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Asoŝan axacërëx an, ar ano kac na an, kërexo ɓayi na gër ɓulunda irewën gayik axo pëɓ ex na eter ed yata këmun el.» ");
INSERT INTO bsc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kaxanu fel këŋo ɓëte Abëraxam: «End Sarayi, alindax eŋ cëŋ, teɓël emac ed Sarayi el, macindo Sara. ");
INSERT INTO bsc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Wëno ayël këmo yël oɓetak ol: mëŋ ki rëw̃ën itoŝan. Ayël këmo yël oɓetak ol, ɓenëng ɓenëng këɓi rëw̃. Ɓemun ɓend ɓenëng ɓendanjëm kë ŝanaya na gër oɓaŝ orexëm.» ");
INSERT INTO bsc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ata Abëraxam lapaya ko mopoxi, eƴiỹ el ŋëŝ gër ebar. Ga këŋo lëŝëgën, ko rend: «Wëno ar sëk ke ɓëniy keme an nde mo dëw̃ itox? Ɓëte Sara arëw̃ nde ko rëw̃, ga sëk këŋo ako ɓëniy ofëxw ocongonax?» ");
INSERT INTO bsc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ata Abëraxam fel këŋo Kaxanu: «Wëno ɗek er xara këmi in ex, exo daf Isëmayel, do eƴo mëlaya!» ");
INSERT INTO bsc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ɓarikan Kaxanu yaka këŋo: «Ax gi na mondako, Sara, alindax, ki rëw̃ën itoŝan, do maciɗo Isak. Wëno këŋo yata eter el, eter ed din ir din ed mëŋ do gë ɓërandëw̃ëra andexëm el. ");
INSERT INTO bsc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","End Isëmayel eŋ cëŋ, awël wël këmi. Ayël këmo yël oɓetak ol, aŝënan këmo ŝënan. Oɓaŝ or këɓi rëw̃ ol mbaŋ këni ỹëmb. Arëw̃ këɓi rëw̃ ɓemun epëxw gë ɓeki, end ex kala, gë ɓulunda irexëm in. Axarëk ar enëng etëm këmo ri. ");
INSERT INTO bsc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ɓarikan eter ed yata këmi el, aɓayi kë ɓayi gë Isak, ar këŋo rëw̃ Sara aniy and kë ƴowënd an, gë amëd and hi këne aŋo dëŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","And h̃ata ko er baŋo felënd Abëraxam aŋ, Kaxanu ŝëg ko kwël ƴaŋ ƴaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ga xucak eŋo, Abëraxam ɓar këɓi asëñiw̃ Isëmayel, gë ɗek ɓësoŝan ɓër ekun edexëm ɓën, gë ɗek okaɗëp od rëw̃ kënëɓi gër iciw̃ indexëm ok, do gë ɗek od yëc këɓi gë koɗi irexëm ok. Yatijo fo xac banëɓi ang fel baŋo Kaxanu ak. ");
INSERT INTO bsc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abëraxam anëka sëk baŋo ɓëniy ofëxw ocongonax gë ɓënjongëɓënax and xac këno aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Asëñiw̃ Isëmayel, anëka sëk baŋo ɓëniy epëxw gë ɓëtas and xac këno aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ata kwël yatijo fo xac banëɓi Abëraxam do gë asëñiw̃ Isëmayel. ");
INSERT INTO bsc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ɓëte kwël yatijo fo xac banëɓi andamat gë mëŋ, ɗek ɓësoŝan ɓër ekun edexëm ɓën: hi këni ɓër rëw̃ kënëɓi na, hi këni ɓër yëc këɓi gë koɗi në ɓëliyer. ");
INSERT INTO bsc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Akey amat, Axwën Kaxanu ŝanaxën këŋo Abëraxam gër ɓananga ɓand Mamëre. Abëraxam aỹëpa ỹëpa baxo gër ebët ed aner andexëm, ga kë ƴëka goyat. ");
INSERT INTO bsc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ga rënëta ko, wat këɓi ɓësoŝan ɓësas ga xwëŝa këni nacët ako gër lëngw irexëm. And wat këɓi aŋ, xaca këɓi gë ongër fo elod gër ebët ed aner andexëm. Ga fed këni, Abëraxam foxi ko eƴiỹ el ŋëŝ gër ebar, ");
INSERT INTO bsc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","do re ko: «Axara xara këmi Axwën, angëmëne ar ŝenene xwët këƴe, këla këreƴ kuca na wa caparëxe gër iciw̃ ind xaɗëp ireƴ! ");
INSERT INTO bsc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Cëniyine tan mun dëmbënëgu tëkër men oŋ, en neɓaraxën osapar oŋ, do en teyëtaxën ɗila gër amol and atëx! ");
INSERT INTO bsc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Cëniyine mun mëlanëgu eƴamb ƴamb en kemaxën. Do gwëre ngwa en kuca fëña irewën in. Gayikwa aŝapagu ŝapagu kën, gër iciw̃ ind wëno ar ex xaɗëp irewën iŋ.» Ata yaka këni: «Aw̃a w̃a këmi, dil ang re këƴ ak.» ");
INSERT INTO bsc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ata Abëraxam w̃ara ko gër aner, fel këŋo Sara: «Awa maral tan eƴ nega pix ind bële iŋ, ɓacariya ɓatas, eƴ gëji ɓambeñe.» ");
INSERT INTO bsc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abëraxam mëŋ w̃ara ko ɓëte gër oyel. Yeɓëgu këŋo engaŝ, end ɓëtëk aye, do fëxwën këŋo xaɗëp iɓat eno ŋaŝaxën. Xaɗëp ijo w̃ëla këŋo engaŝ eŋo ŋaŝëx do eɓi bëkanëgu ỹas eŋ ɓëliyer ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abëraxam w̃eɗ ko ɓëte omër oñënëk, do gë ond xaw̃ëgu këni eceɗ, w̃ëlara ko ɗek gë ỹas er engaŝ end h̃aŝ bano eŋ, do rëɗën këɓi. Ata ɓayi ko mokwëŝa ler gër ed hi bani, ɗila gër amol and atëx and gër ed bani ƴambërand ɓëliyer. ");
INSERT INTO bsc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ata w̃ëka këni: «Feye wa exo alindax Sara?» Yaka ko Abëraxam: «Lëf fën gër aner hi ko.» ");
INSERT INTO bsc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ata re ko ɓëte aɓat: «Aɓaka këme ɓakaw ŝana gër ndewën ro ŝana, ata gë dorogo dëŋ. Ata alindax Sara eŋo dëw̃ itoŝan.» Xarak, Sara aɓaxët baɓi ɓaxëtënd gër ebët ed aner and hi bax gër epoƴ ed Abëraxam. ");
INSERT INTO bsc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Amëd aŋo, Abëraxam do gë Sara mokar xar bani. Sara axo bo bana ga ko wat apacaw̃ andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ata Sara këŋo lëŝëgënënd do ko rend gër emëkw edexëm fo: «Gërëgako anëka xar këme, oñandi nde ngwa ɓayi ke na? Ado axwën ar iciw̃ indam an dëŋ, anëka xar ko.» ");
INSERT INTO bsc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ata Axwën Kaxanu w̃ëka këŋo Abëraxam: «Inew̃a ko lëŝaxënënd Sara, do ko rend: “Axor nde ngwa këme xor mo cot itox, wëno axarëk ajo?” ");
INSERT INTO bsc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ỹeỹ nde ex na er sëkwan ko Axwën Kaxanu? Gë aniy and kë ƴowënd aŋ, gë amëd and fënëta këme aŋ, aɓaka këme ɓakaw gër ndewën ro, do Sara aŝot këŋo ŝot itoŝan.» ");
INSERT INTO bsc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ata Sara ga ko ƴax, ko rend: «Ame ɗëŝ ex na», gayikwa ayëdara yëdara baxo. Ɓarikan Axwën Kaxanu re ko: «Ɗal ex, alëŝ lëŝ këƴ!» ");
INSERT INTO bsc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ɓësoŝan ɓësas ɓën ga xani këni oñe oŋ, faɓ këni end angol and Sodom eŋ. Sëfër këni gë Abëraxam, ga këɓi laŋëta. ");
INSERT INTO bsc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Xarak, Axwën Kaxanu are re baxo: «Er këme ri in, amo con na Abëraxam. ");
INSERT INTO bsc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abëraxam axarëk ar enëng etëm, end gë ojaw̃ otëm, ko hi. Paɓ gë mëŋ këni ɓeta ɗek ɓenëng ɓend gër ebar ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Gayikwa wëno yata këŋo eɓi pelaxënënd oɓaŝ orexëm ol, do gë ɗek ɓër ekun edexëm ɓën, eni ɗiyand ed ang rek ɓapela ɓandam ak, and kë xuca ɓakey ɓandexëm ɓaŋ. Asëƴali këɓi ỹana eɓi tëƴalind edi ed end ŝenene el, do gë er ke ỹandind in. Mondako këmo yëlaxën Abëraxam er ɓeƴa këmo in.» ");
INSERT INTO bsc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ata re ko Axwën Kaxanu: «Abëraxam, awël wël këme mëne Ɓësodom ɓën do gë Ɓëgomor ɓën ɓeñëŋënax ɓetëm këni rind. ");
INSERT INTO bsc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Wëno mëŋ këme ŝëlaxënënd me wat ba ang wël këme ak dëŋ nde ex. Hik ɗal nde, ax gi ex na ɗal nde, anang këme nang.» ");
INSERT INTO bsc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ata xuca këni ɓësoŝan ɓëxi ɓën ond gër Sodom oŋ, ɓarikan Axwën Kaxanu ɓayi ko na. Abëraxam xwëŝa ko gër lëngw irexëm. ");
INSERT INTO bsc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abëraxam sëka këŋo, do re ko: «Enimin, aɓar nde këƴëɓi ɓar eƴëɓi nemin ar ŝenene an do gë aw̃endëran an? ");
INSERT INTO bsc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ɓamat na fo exëni gër angol aŋo ɓela ofëxw oco ɓër ŝenene. Enimin, anemin nde këƴ nemin angol aŋo? Aƴëɓi teɓan na nde në end ɓela ɓër ŝenene ofëxw oco ɓëjo? ");
INSERT INTO bsc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ax mënd ex na eƴ di mondako: eƴëɓi ɓar enemi el, ar ŝenene an do gë aw̃endëran an. Ax mënd ex na eƴ di mondako! Wëj wa ga këɓi xitind ŝenene ɗek ebar el, aƴ di na nde kiti ind ŝenene?» ");
INSERT INTO bsc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yaka ko Axwën Kaxanu: «Angëmëne, asëk sëk këmëni gër Sodom ɓër ŝenene ofëxw oco, në end endeɓën këmëni seɓanaxën ɗek angol aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abëraxam re ko ɓëte: «Axwën, ayëxw yëxw këme mi yeƴaneli wëno ar ex omak do gë eƴëwën fo an. ");
INSERT INTO bsc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ɓamat gër ɓër ŝenene ofëxw oco, ɓëco ɓayik ani gi ex na, anemin nde këƴ nemin ɗek angol aŋ?» Yaka ko Axwën Kaxanu: «Ame nemin na angol aŋ, angëmëne asëk sëk këmëni ɓër ŝenene ofëxw onax gë ɓëco.» ");
INSERT INTO bsc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ɓarikan Abëraxam, kwël dëŋ ɓayi baxo ga këŋo yeƴaneli Axwën Kaxanu. Ata re ko ɓëte: «Ɓamat ɓër ŝenene ofëxw onax fo exëni.» Yaka këŋo: «Në end ɓër ŝenene ofëxw onax ɓëjo, ỹoweỹ ame di na.» ");
INSERT INTO bsc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Re ko ɓëte Abëraxam: «Këla Axwën, këreƴ koỹ na, angëmëne ayeƴan yeƴan këme. Ɓamat ɓër ŝenene ofëxw osas fo exëni.» Yaka ko Axwën Kaxanu: «Ỹoweỹ ame di na angëmëne asëk sëk këmëni ɓër ŝenene ofëxw osas.» ");
INSERT INTO bsc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abëraxam re ko ɓëte: «Axwën, kwël dëŋ ɓayik ga këme yëxw mi yeƴaneli… ɓamat ɓër ŝenene alapem këƴëɓi sëk.» Yaka ko: «Në end ɓër ŝenene alapem ɓëjo, ame nemin na angol aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abëraxam re ko ɓëte: «Këla Axwën, këreƴ koỹ na, angëmëne akëlëbëd aŋo fo yeƴan këme ɓëte: ɓamat ɓër ŝenene epëxw fo exëni.» Yaka ko: «Në end ɓër ŝenene epëxw ɓëjo, ame nemin na angol aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ga h̃ata ko eyakar ed gë Abëraxam el, Axwën Kaxanu ƴe ko kwël. Ata Abëraxam ɓaka ko gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Omeleka oki ok h̃at këni genëka gër Sodom. Xarak Lot, gër ebët ed angol and Sodom ỹëpa baxo. And wat këɓi aŋ, xani ko, xaca këɓi, do foxi ko eƴiỹ el ŋëŝ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ata re ko: «Faba ɓën axara xara këmun, capayin wa gër iciw̃ ind wëno xaɗëp irewën iŋ, eŋun keyëx. Neɓarayin osapar oŋ, gwëre en kuca ecan mopëɗ gëɓër.» Yaka këni ɓën: «Ali, ɓiyi fac këɓo xey gër yangana ir angol.» ");
INSERT INTO bsc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ɓarikan Lot ga nëỹalira këɓi xali, xor këɓi, ata ŝapa këni gër iciw̃ indexëm. Rin këɓi ñambëran, wëkan këɓi ɓamburu ɓand gë lewir këm, do ƴambëra këni. ");
INSERT INTO bsc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ani ɗakira bana pere ga yëlëtaw këni ɓër gër angol and Sodom ɓën. Ɓësoŝan ɓën xeta këni jeƴ iciw̃ ind Lot iŋ, ga ỹanaw këni ocambenjar ok, ɓëtëgu këni ɓëxarëk ɓën. Fëxwëŝërëgu këni ɗek ɓulunda in, gë ar kë ɓayi këm ak. ");
INSERT INTO bsc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ga w̃ac këno Lot, w̃ëka këno: «Feye wa exëni ɓela ɓër h̃atëguk genëka go gër iciw̃ indeƴ ro ɓën? Nëcëtëguyëɓi mi ɗaki gë ɓën!» ");
INSERT INTO bsc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ata Lot ŝan ko, fëraw ko ebët el gand epoƴ edexëm. ");
INSERT INTO bsc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Re ko: «Ɓëmaỹe axara xara këmun, këren di na eñëŋënax etëm eŋo! ");
INSERT INTO bsc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nëkoɗëɓi odënaw̃ oki odam ok, ɓësoŝan anëɓi nang ex na. Ɓën këmun nëcëtënëli, do enëɓi di ang këŋun nëngan ak. Ɓela ɓëjo cëŋ, ỹoweỹ kërenëɓi di na, gayikako gër amol and iciw̃ indam ro ƴow këni.» ");
INSERT INTO bsc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ɓarikan ɓën yaka këni: «Wëj pacanal!» Re këni ɓëte: «Watino aliyer ar ƴowëk ocalaran gër ndeɓi ro, ga ỹandi këŋo eɓo nëp! Gërëgako, ɓiyi wëj këmi nëmba mi di eñëŋënax eŋ nëmëc ɓën!» Ga fim këno Lot, w̃ël këni eni gëbëra epëra el. ");
INSERT INTO bsc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ata omeleka ok sëraw këno Lot, lasëx këno lëf gër iciw̃, do kwël fëra këni ebët el. ");
INSERT INTO bsc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ɓësoŝan ɓër ebax gër ebët ed iciw̃ ɓën cëŋ, lapan kënëɓi oŝiw̃. Ga ỹana kënëɓi ocambenjar ok, ŝiw̃ën kënëɓi xali gë ɓëxarëk ak. Ah̃ëmbarëra fo bani h̃ëmbarërand, ɓari abani wat na ebët el. ");
INSERT INTO bsc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Omeleka ok fel këno Lot: «Ɓela ɓër ekun edeƴ nde exëna gër angol? Hi këni ɓër ỹër këɓi odënaw̃ odeƴ nde, hi këni ɓosëñix nde, hi këni ɓoɓix nde, hi këni ɓëreƴ nde, nëcëtëlëɓi, eƴëɓi ŋaw̃ëtali angol aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ɓiyi mi nemin angol aŋo ro ƴowaxënëgu këmi. Gayikwa Axwën Kaxanu awël wël ko mëne ɓela ɓër lëgëk ro ɓën ɓeñëŋënax ɓetëm këni rind. Mëŋ law̃ënaxënëgu këɓo mi nemin angol aŋo ro.» ");
INSERT INTO bsc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ata Lot ŝan ko eɓi pelëra ɓër ỹër baɓi odënaw̃ odexëm ɓën, gë ɓër nëm baɓi odënaw̃ odexëm od ɓayi bax ok: «Marayin en can angol aŋo ro, gayikwa Axwën Kaxanu anemin ko nemin.» Ɓarikan ɓoỹaraw yëla këni anëxi këɓi nëxind. ");
INSERT INTO bsc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","And h̃atëguk oxeya aŋ, omeleka ok ga këno nëỹali Lot, këni rend: «Wëj kanil eƴ ƴe, meɗëlo alindax do gë odënaw̃ oki od ex ro ok, këdi këŋun w̃ëlali amena and angol aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ɓarikan Lot ko fërërand. Ata sëra kënëɓi dëp gër ɓataxan, mëŋ, gë alindaw̃, do gë odënaw̃ oki odexëm ok, las kënëɓi xali ŝan këni angol aŋ. Gayikwa Axwën Kaxanu aỹandi ỹandi baŋo eɓi pexën. ");
INSERT INTO bsc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","And nëcët kënëɓi angol aŋ, omeleka ok re këni: «Awa ala kala gërëlexo exo pexënaxën gaf irexëm in. Ax gi ex na monëkona, do ax gi ex na mokwëŝa ɗek anen aŋ. Gërin xali gër etënd, en pexaxën këdi këŋun ɓuŝa.» ");
INSERT INTO bsc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ata re ko Lot: «E Axwën, axara xara këmi! ");
INSERT INTO bsc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Axara xara këmi Axwën, wëno xaɗëp ireƴ in, ga xaỹënan ki ako ɓiyi xali yël këƴëɓo oyekax or mi pexaxën ol, ami kor na mi ŋat xali gër etënd elo, tëɓ këɓo fënga etëm eŋ do mi cës. ");
INSERT INTO bsc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Këla nëkoɗa angol aŋo ɗam ro fo ex, ɓëte atil fo ex. Axor këmi xor mi ŋat, mi pexaxën. Ax ɓax na nde angol aŋo?» ");
INSERT INTO bsc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ata yaka ko meleka in: «Awa aw̃a w̃a këme mun yël ɓëte oyekax olo. Angol and xara këƴe aŋo, ame nemin na. ");
INSERT INTO bsc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Awa marayin, gërin xali fën. Gayikwa ỹoweỹ ame kor na me di xali en ŋat.» Mëŋ w̃acaxën këni angol aŋo «Tësowar», mëne ngëŋ «Atil». ");
INSERT INTO bsc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ga kë fën eñan eŋ, bani h̃atënd Lot ɓën gër Tësowar. ");
INSERT INTO bsc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ata Axwën Kaxanu w̃ëlaw ko mungu ind fëtëk xoɗux do sëɓandëra këɓi elod gër orën ɓangol ɓand Sodom do gë Gomor ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ɓëlën ko ɓangol ɓaŋo gë ɗek ebar elo ak, gë ɗek ɓela ɓër lëg bax gër ɓangol ɓaŋo ak, do gë ɓeɓër lëgëra bax gër ebar elo ak. ");
INSERT INTO bsc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Asoxari ar Lot an, ga nëkona ko, nëngwëta ko atox and ongal. ");
INSERT INTO bsc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abëraxam ga xani ko mopëɗ gëɓër, ƴe ko gër ed xwëŝa bani gë Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nëkona ko gand Sodom do gë Gomor, gand ed ex ɗek ebar elo. Wat ko gand angëni ɓokwëcën ɓoŋ ang ɓond apuỹ and kë ỹegënd fo. ");
INSERT INTO bsc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","And baxo neminënd ɓangol ɓand ebar elo ɓaŋ, Axwën Kaxanu xwita ko er xara baŋo Abëraxam in: racët këŋo Lot gër etëm end lapan baɓi ɓër gër ɓangol ɓand gër ed lëg baxo Lot ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot ga yëda ko exo ɗëg gër angol and Tësowar, ƴe ko ỹafëx këni gë odënaw̃ odexëm ok gër etënd, lëf në akel. ");
INSERT INTO bsc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ata endënaw̃ ekarëk eŋ fel këŋo emeja eŋ: «Faba ireɓi anëka xar ko, do asoŝan ar këɓo ỹër ang rëpëk ak, axo gi ex na ro gër ebar ed hi këne. ");
INSERT INTO bsc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ƴow eŋo yële ngoƴ iŋ faba ireɓi, xali eŋo ŋaw̃. Do ɗakinde gë mëŋ eɓo cotënaxën ɓëtox, ex ɓayixën andëw̃ëra andexëm aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ata genëka, yël këno ngoƴ iŋ sëm ireɓën xali ỹaw këŋo. Endënaw̃ ekarëk eŋ laki këni gë sëm irexëm. Ɓari mëŋ ỹoweỹ axo wata bana: axo nang bana nand laki këni gë endënaw̃ ekarëk na, ɓëte axo nang bana nand xani ko endënaw̃ na. ");
INSERT INTO bsc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Në ecan ijo, endënaw̃ ekarëk eŋ fel këŋo emeja eŋ: «Ganëka gëmëɗ gë wëno laki këmi gë faba. Yëlëŋoye ɓëte ngoƴ iŋ exo ceɓ xali eŋo ñaw̃ doro ɓëte. Do gë wëj kën laki eŋo cotënaxëne andëw̃ëra». ");
INSERT INTO bsc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ata genëka ijo ɓëte, yël këno ngoƴ iŋ sëm ireɓën, xali ỹaw këŋo. Endënaw̃ emeja eŋ ƴe ko laki këni gë mëŋ. Ɓari mëŋ ỹoweỹ axo wata bana: axo nang bana nand laki këni na, ɓëte axo nang bana nand xani ko endënaw̃ na. ");
INSERT INTO bsc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Odënaw̃ oki od Lot ok, mondako ŝot bani ɓacël gë sëm ireɓën. ");
INSERT INTO bsc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Endënaw̃ ekarëk eŋ rëw̃ këŋo itoŝan w̃ac këŋo Mohab: mëŋ ex axarëk ar ɓërandëw̃ëra and Mohab an xali doro. ");
INSERT INTO bsc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Endënaw̃ emeja eŋ rëw̃ këŋo ɓëte itoŝan. W̃ac këŋo Ben-Ami, mëne ngëŋ «Asëñiw̃ ar ɓulunda iram»: mëŋ ex, axarëk ar ɓërandëw̃ëra and Amoŋ an xali doro. ");
INSERT INTO bsc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ata Abëraxam ga xani ko na, rëfa ko gand ladawe ir Negeb. Lëgëx këni fëco Kadeŝ, fëco Ŝur. Ga nëkanak, ƴe ko ɓëte oliyer gër ebar ed Gerar. ");
INSERT INTO bsc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","End Sara, asoxari arexëm eŋ, Abëraxam mondako felëx baɓi: «Aɓaỹe ex.» Ata Abimelek, emun end gër Gerar eŋ, re ko eno mëlan Sara. ");
INSERT INTO bsc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ɓarikan Kaxanu ga ƴow ko gëmëɗ në lakeli gër Abimelek, re ko: «Awa wëj aŝës këƴ ŝës në end asoxari ar w̃ëlaw këƴo ajo, gayikwa gë icën exo.» ");
INSERT INTO bsc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ani tëkar bana pere Abimelek do gë asoxari ajo. Abimelek re ko: «Axwën, wëno gë ɓulunda iram in, ami mendëra ex na. Alaw̃ nde këƴo law̃ mondako dëŋ ar ŝenene an? ");
INSERT INTO bsc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Mëŋ Abëraxam dëŋ ga fel ke wa: “Aɓaỹe ex.” Asoxari an re ko mëŋ ɓëte: “Aɓaỹe ex.” Gë emëkw epeŝax w̃ëlaw këmo, do eñëŋënax ame di ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ata Kaxanu yaka këŋo gër lakeli: «Wëno ɓëte anang nang këme mëne gë emëkw epeŝax w̃ëlaw këƴo. Wëno wa sëra ki mëŋ ɓayik aƴe menan ex na. Ami teɓ ex na eƴo tëka asoxari ajo. ");
INSERT INTO bsc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mëŋ ex gërëgako, meɗëlo asoxari ajo eƴo maŝ icën indexëm iŋ. Mëŋ alaw̃ënel aram hi ko. Aŝalen ki ŝalen eƴ ɓayixën ga këƴ liyand. And kën ŝës ex ɗe wëj do gë ɗek ekun edeƴ el, angëmëne aƴo maŝ ex na asoxari an, icën indexëm iŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek xani na mopëɗ gëɓër. W̃ac këɓi ɗek ɓëlëngw ɓër gër owun orexëm ɓën, do sëfëtan këɓi ɗek endeƴ eŋo. Ata yëdara këni mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek w̃ac këŋo Abëraxam do w̃ëka këŋo: «Inew̃a rixën këƴëɓo eŋo? Ba wëno ỹeỹ nde w̃enan këmi na mëŋ lënanaxën këƴëɓo eñëŋënax etëm eŋo, wëno gë ɓulunda iram in? Ɓeɓër rinan këƴe ɓëjo, ax ñap ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek fel këŋo ɓëte Abëraxam: «Ga ri këƴ ako eŋo, ine baƴ ŝaland?» ");
INSERT INTO bsc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ata yaka këŋo Abëraxam: «Wëno ako yëla bame mëne wën ɓela ɓër gër ebar elo ro ɓën ano yëdand na Kaxanu, do mëne alaw̃ këne law̃ në end asoxari aram. ");
INSERT INTO bsc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ɓëte ɗal dëŋ ex mëne aɓaỹe ex gayikako, faba iɓat hi këmi. Ɓarikan asoxari aram hi ko gayik ami gi ex na nëma iɓat. ");
INSERT INTO bsc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","And fel ke Kaxanu me canëgu gër ekun ed faba iram aŋ, fel këmo Sara: “Awël nde oyekax olo këƴe ỹana eƴe dinënd gër ed ke ƴeye yo. Deyind mëne aɓinëx hi këme”.» ");
INSERT INTO bsc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ga xucak eŋo, Abimelek w̃eɗ këɓi oɓeci, gë opeỹ, do gë oxeƴ do yël këŋo Abëraxam. Yël këŋo ɓëte okaɗëp otoŝan do gë okaɗëp otoxari. W̃aŝ këŋo ɓëte Sara, alindaw̃. ");
INSERT INTO bsc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Re ko Abimelek: «Awël nde, nëkoɗ ebar edam el, ɗëgël gër ed këƴ h̃an.» ");
INSERT INTO bsc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Fel këŋo ɓëte Sara: «Anëka yël këmo aɓinëx ɓatama wëli ɓand koɗi. Mondako laɓ këme dëxas ireƴ in eni nangaxën ɓër ekun edeƴ ɓën mëne aƴ mendëra ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ata Abëraxam xara këŋo Kaxanu. Kaxanu fakën këɓi Abimelek, gë alindaw̃, do gë ɗek okaɗëp otoxari odexëm ok, eni koraxën edëw̃ ed oɓaŝ el. ");
INSERT INTO bsc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Gayikwa Axwën Kaxanu ri bax hi këni ɓësoxari ɓëɓoroxok ɗek ekun ed Abimelek el, në end Sara, asoxari ar Abëraxam eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ga xucak eŋo, Axwën Kaxanu yël këŋo oyekax orexëm ol Sara, ang re baxo ak. Axwën Kaxanu ri ko ang ɓeƴa baxo ak. ");
INSERT INTO bsc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ata Sara hi ko gë acël do rëw̃ën këŋo Abëraxam itoŝan gër oxar orexëm dëŋ, nand fënëta baxo Kaxanu na. ");
INSERT INTO bsc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abëraxam w̃ac këŋo asëñiw̃ ar rëw̃ bano mëŋ gë Sara an, Isak, mëne ngëŋ «Olëŝ». ");
INSERT INTO bsc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abëraxam xac këŋo asëñiw̃ Isak yatir sëk këŋo ɓakey ɓanjongëɓatas, ang fel baŋo Kaxanu ak. ");
INSERT INTO bsc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abëraxam anëka sëk baŋo ɓëniy këme and rëw̃ këno asëñiw̃ Isak aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ata re ko Sara: «Kaxanu ri ke alëŝëraɗëŝëra. Ar kë wël yo endeƴ eŋo, alëŝ ke lëŝ.» ");
INSERT INTO bsc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Re ko ɓëte: «Noỹo wa fel doŋo Abëraxam mëne akey amat, wëno Sara ayerin këmëni yerin oɓaŝ? Ɓarikan itoŝan rëw̃ën këmo gër oxar orexëm dëŋ!» ");
INSERT INTO bsc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mondako raf ko lëmëta in xali yapët këŋo. Abëraxam ri ko ofëna osëm yatir yapët këno Isak. ");
INSERT INTO bsc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Akey amat, Sara wat këŋo asëñiw̃ ar Abëraxam an, ar rëw̃ këŋo Agar, xaɗëp isoxari iɓ Misëra an, ga këŋo lëŝ Isak. ");
INSERT INTO bsc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara fel këŋo Abëraxam: «Ŋw̃ayëlëɓi xaɗëp isoxari in, do gë itox indexëm iŋ. Gayikwa itox ind xaɗëp isoxari ijo iŋ do gë Isak, itox indam iŋ, ani ɓëteli na andamat napul ireƴ in!» ");
INSERT INTO bsc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ata Abëraxam ŝus ko mbaŋ eyeƴan elo gayikwa itox iŋo asëñiw̃ ebaxo! ");
INSERT INTO bsc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ɓarikan Kaxanu fel këŋo Abëraxam: «Këreƴ koỹ na end lëmëta eŋ do gë end xaɗëp isoxari ireƴ eŋ. Dil ɗek er ko re Sara in. Gayikwa paɓ gë Isak ko ƴow ar këno w̃ac andëw̃ëra andeƴ an. ");
INSERT INTO bsc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","End asëñix ar ŝot këno gë xaɗëp isoxari ireƴ eŋ cëŋ, ari këmo ri exo gi mëŋ ɓëte ɓulunda, gayikwa arandëw̃ëra andeƴ hi ko.» ");
INSERT INTO bsc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ata Abëraxam xani ko mopëɗ gëɓër, w̃eɗ ko ŝëlafana in, gë amote and men aŋ fëxwën këŋo Agar do fela këŋo. Agar ga rënda këŋo itox iŋ ƴe ko kwël ko nambëraraxënd gër ladawe ir Berëŝeba. ");
INSERT INTO bsc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","And xwëtëk men ond gër amote aŋ, Agar ỹaŋëta këŋo itox indexëm iŋ ɗila në acëc, ");
INSERT INTO bsc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ƴe ko ỹëpax ko nacët, gwër në eɗapan ed ekaỹ. Gayikwa er baxo rend: «Axe ñandi ex na mo wat itox indam iŋ ga ko ŝës.» Ata ỹëpax ko, nacët ako do ko sesënd. ");
INSERT INTO bsc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kaxanu wël ko otes od lëmëta ok. Ata elod gër orën, meleka ir Kaxanu in, w̃ac këŋo Agar, re ko: «Agar in ex wa? Këreƴ yëdara na gayikwa Kaxanu awël wël këŋo lëmëta in fën gër ed exo. ");
INSERT INTO bsc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kanil eƴo meɗëgu lëmëta in, do ɗasëguyo aye, gayikwa wëno këŋo ri exo gi ɓulunda isëm.» ");
INSERT INTO bsc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ata Kaxanu ga foɗët ko ɓangës ɓand Agar ɓaŋ, Agar wat ko andu. Ƴe ko rëmbëgu ko cëm amote aŋ, do yël këŋo itox iŋ ŝeɓ ko. ");
INSERT INTO bsc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mondako hi bani Kaxanu gë lëmëta in, do mëŋ kwël ko rafënd. Lëg ko na gër ladawe, do hi ko kamara ir bax nëxand gë atumb. ");
INSERT INTO bsc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Na gër ladawe ir Paraŋ lëg baxo, do nëm ŝalanëgu këŋo asoxari Amisëra. ");
INSERT INTO bsc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Amëd aŋo, Abimelek do gë Pikol, alëngw ar ocoroɗa odexëm an, ƴow këni gër Abëraxam. Re ko Abimelek: «Kaxanu ki nëkonand gër ɗek ɓeɓër këƴ rind. ");
INSERT INTO bsc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Gërëgako yaŝarël ro dëŋ, gër ow̃ac or Kaxanu mëne din aƴëɓo mereli na wëno, gë oɓaŝ oram ol, gë ɓërandëw̃ëra andam ɓën. Yaŝarël mëne alëkaya këƴ lëkaya eter edeɓi el ang lëkayaw këme wëno gër ebar ed liyerali baƴ.» ");
INSERT INTO bsc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ata re ko Abëraxam: «Awa anëka yaŝar këme.» ");
INSERT INTO bsc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ɓarikan Abëraxam rexëra këŋo Abimelek në end andu and xan bano ɓela ɓërexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Yaka ko Abimelek: «Amo nang ex na ar rik eŋo an. Doro fo këme wëlënd endeƴ eŋo, wëj elod aƴe pel ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abëraxam yeɓëgu këɓi oɓeci, gë opeỹ do gë oxeƴ, yël këŋo Abimelek. Mondako yatar bani eter el ɓën ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abëraxam fit këɓi opeỹ ocongoki. ");
INSERT INTO bsc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ata Abimelek w̃ëka këŋo: «Oko inew̃a fitaxën këƴëɓi opeỹ ocongoki oko?» ");
INSERT INTO bsc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Yaka ko Abëraxam: «Kanalëɓi opeỹ ocongoki oko, ex gixën sede ir mëne wëno nacëk andu aŋo.» ");
INSERT INTO bsc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mëŋ këni w̃acaxënënd na gër ed hi bani Berëŝeba, mëne ngëŋ «Andu and gë eyaŝar», gayik na yaŝar bani ɓën tak ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mondako ri bani eter el gër Berëŝeba. Ga xucak eŋo, Abimelek do gë Pikol emun end ocoroɗa odexëm eŋ xani këni eni ɓakaxën ond gër ebar ed Ofilisëteŋ. ");
INSERT INTO bsc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ata Abëraxam rëɗ ko angwalam na gër Berëŝeba, do ga këŋo ŝale Kaxanu, këŋo w̃acënd Axwën. ");
INSERT INTO bsc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ata Abëraxam ỹëpa ko na gër ebar ed Ofilisëteŋ xali nëkak. ");
INSERT INTO bsc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ga xucak eŋo, Kaxanu ri këŋo atëƴ Abëraxam. Re ko: «Abëraxam!» Yaka ko Abëraxam: «Woy!» ");
INSERT INTO bsc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Re ko ɓëte Kaxanu: «Axara xara këmi, meɗëlo asëñix ar tañ areƴ an, ar h̃an këƴo an, Isak. Mëlalo gër ebar ed Moriya, eƴo dix ŝaɗaxa ir momëlën ƴaŋ gër etënd ed këmi fënëtan.» ");
INSERT INTO bsc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ata Abëraxam xani ko mopëɗ gëɓër, xap këŋo fali in, fel këɓi okaɗëp oki, do gë asëñiw̃ Isak eno ɗaŋëta. Otëx od ŝaɗaxa ir momëlën od ŝapën bano ok, liɓën këno fali in, do kwël ƴe këni ond gër ed fënëtan baŋo Kaxanu oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Yatir akey atasën, Abëraxam ga rënëta ko, wat ko caw ako gër ed fënëtan këŋo Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abëraxam fel këɓi okaɗëp odexëm ok: «Wën cëniyinëɓo ro gë fali in. Wëno do gë lëmëta in, mi ƴe xali ƴaŋ mi caleraw, gwëre mun tëkati.» ");
INSERT INTO bsc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abëraxam w̃eɗ ko otëx od ŝaɗaxa ir momëlën ok, do lëɓin këŋo asëñiw̃ Isak. Lëkaya ko mëŋ dëŋ xoɗux ol do gë icas iŋ. Ata kwël këni ƴend ɓën tak ɓëxi ƴaŋ gër etënd. ");
INSERT INTO bsc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ata Isak w̃ac këŋo sëm: «Faba» Yaka ko Abëraxam: «Woy, asëñiw̃ën!» Re ko ɓëte Isak: «Nëkoɗ xoɗux ol do gë otëx ok, do feye wa exo ifeỹ ir ŝaɗaxa ir momëlën in?» ");
INSERT INTO bsc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Yaka ko Abëraxam: «Asëñiw̃ën, Kaxanu aŝotën këɓo ŝotën ifeỹ ir këŋo riye ŝaɗaxa ir momëlën in!» Do kwël këni ƴend ɓën tak ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","And h̃at këni gër ed w̃asin baŋo Kaxanu aŋ, Abëraxam ri ko angëɓ, do xëɓena ko otëx ok ƴaŋ. Xap këŋo, asëñiw̃ Isak, do ren këŋo gër otëx od ƴaŋ gër angëɓ. ");
INSERT INTO bsc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abëraxam w̃eɗ ko icas iŋ eŋo ŋaŝaxën asëñiw̃. ");
INSERT INTO bsc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ata meleka ir Axwën in ga w̃acëgu këŋo elod gër orën ko rend: «Abëraxam! Abëraxam!» Yaka ko mëŋ: «Woy!» ");
INSERT INTO bsc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Re ko ɓëte meleka ir Axwën in: «Këreƴëŋo kwixwëta na lëmëta in, do ỹoweỹ këreƴëŋo dinan na. Anëka nang këme gërëgako mëne ayëda këƴo yëdand Kaxanu, do ado aƴo ɗëc ex na asëñix ar tañ an.» ");
INSERT INTO bsc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ga rënëta ko Abëraxam, wat këŋo xondo gand epoƴ edexëm ga hënjar ko gë ofarix orexëm oŋ gër acëc. Ata ƴen këŋo do h̃aŝ këŋo ŝaɗaxa ir momëlën in, gër ed ebax eŋo caɗaxa asëñiw̃. ");
INSERT INTO bsc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abëraxam w̃ac ko na gër ed ebani: «Adonayi-Yire», mëne ngëŋ «Axwën Kaxanu aŝotën ko ŝotënënd». Mëŋ ɓayixënëk eyeƴan elo xali doro: «Gër etënd ed Axwën Kaxanu, mocot ex.» ");
INSERT INTO bsc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Meleka ir Axwën Kaxanu in w̃ac këŋo akinëm Abëraxam elod gër orën. ");
INSERT INTO bsc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Re ko: «Në eyaŝar eme gër ow̃ac oram dëŋ (eyeƴan ed wëno Axwën Kaxanu el), gayik ari ri këƴ eŋo, ɓëte gayik aƴe ɗëc ex na asëñix, asëñix ar tañ an, ");
INSERT INTO bsc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ayël këmi yël oɓetak ol. Ɓërandëw̃ëra andeƴ ɓën aỹëmb këni ỹëmb ang ow̃al or gër orën fo, do ang eɗini ed gër ɓëŋa ir angwëngw fo. Ɓërandëw̃ëra andeƴ ɓën kë ỹana ex kwënënd ɓangol ɓand ɓërangoỹëra andeɓën ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ɗek ɓenëng ɓend gër ebar ɓeŋ kë ỹana ex ɗëwarëndërënd oɓetak ol paɓ gë arandëw̃ëra andeƴ aŋ gayik aɓaxët ɓaxët këƴe.» ");
INSERT INTO bsc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ga xucak eŋo, Abëraxam do gë lëmëta in ŝëla këni gër ed seɓëgu banëɓi okaɗëp odexëm. Ata ɓën ɗek sëfër këni do kwël w̃aỹi këni gër Berëŝeba, gayikwa fën lëg baxo Abëraxam. ");
INSERT INTO bsc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ga xucak eŋo, fel këno Abëraxam: «Milëka mëŋ ɓëte, arëw̃ën rëw̃ën këŋo ɓëtoŝan aɓinëx Naxor: ");
INSERT INTO bsc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Utës, itoŝan iñanar iŋ, gë Bus aɓinëm, gë Kemuhel, sëm ir Aram, ");
INSERT INTO bsc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","gë Kesed, gë Aso, gë Pilëdaŝ, gë Yidëlaf, do gë Betuwel». ");
INSERT INTO bsc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel rëw̃ këŋo itoxari, Rebeka. Ɓën ex ɓosëñiw̃ ɓor Naxor, aɓinëm ar Abëraxam, ɓëtoŝan ɓënjongëɓëtas ɓënd rëw̃ këɓi Milëka ɓëŋ. ");
INSERT INTO bsc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Rewuma, asoxari ar ỹëpa bani aỹëpa fo gë Naxor an, arëw̃ rëw̃ këɓi ɓëte oɓaŝ: Teba, gë Gaxam, gë Taxaŝ, do gë Mahaka. ");
INSERT INTO bsc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ga xucak eŋo, Sara sëk këŋo ɓëniy këme gë alapem gë ɓënjongëɓëki. Ɓëniy go liya ko Sara. ");
INSERT INTO bsc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara ŝës ko and lëg bani gër Kiriyat-Arëba, angol and w̃ër bax ow̃ac or Ebëroŋ, gër ebar ed Kanahaŋ aŋ. Ata Abëraxam këŋo ỹaw̃ënd, do ko fëỹëpëỹënd eman end Sara eŋ, ang rëp bax ak. ");
INSERT INTO bsc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abëraxam ga xani ko na gër ed ebax eman end alindaw̃, ƴe ko gër ɓërandëw̃ëra and Het. ");
INSERT INTO bsc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Re ko: «Wëno aliyer fo hi këme, do aỹëpa fo ỹëpa këme gër ndewën ro. Panine ebar ed këme xwën, me dixën ɓanapëra gër ndewën ro, mo mëxwëtaxën asoxari aram ar seɓëta ke an.» ");
INSERT INTO bsc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ata ɓërandëw̃ëra and Het ɓën yaka këno Abëraxam: ");
INSERT INTO bsc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Awël nde faba, wëj emun end sana këŋo Kaxanu ga hi këƴ wa mërëxand ireɓi ro. Mëxwëtalo alindax gër ỹeg ir yexënan ki nëmëc, gër ɓanapëra ɓandeɓi ro. Gaɓatak axi ɗëc na añeg and xwën ko aŋ eƴo mëxwëtaxën alindax.» ");
INSERT INTO bsc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ata xwiriŝ Abëraxam, foxi ko gër lëngw ir ɓër ỹëpaxën bax endeƴ eŋo, gër lëngw ir ɓërandëw̃ëra and Het ɓër lëg bax na gër ebar elo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Re ko: «Angëmëne aw̃a w̃a kën mo mëxwëta asoxari aram ar seɓëta ke an, awël nde ŋatelin okar odam ok gër Efëroŋ, asëñiw̃ ar Tësohar an. ");
INSERT INTO bsc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Panëlexe oxel or Makëpela or xwën ko ol, or hik gër wura ir oŝënga orexëm ol. Panëlexe ang ko fënëta akanji ak, me cotaxën ebar ed këme ri ɓanapëra ɓandam, gër ndewën ro.» ");
INSERT INTO bsc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Xarak, Efëroŋ mëŋ dëŋ na ỹëpa bani gë ɓërandëw̃ëra and Het ɓën. Efëroŋ yaka këŋo Abëraxam, wël këno ɓërandëw̃ëra and Het ɓën, do gë ɗek ɓër bax lilënd gër ebët ed angol andexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Re ko: «Ali faba! Awël nde, wëno ayël fo yël këmi oŝënga ol. Ɓëte ayël fo yël këmi oxel or ex gër wura ol. Anëka yël këmi ogës od ɓër ex ɓulunda iram ok: mëxwëtalëŋo alindax.» ");
INSERT INTO bsc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ata Abëraxam foxi ko na gër lëngw ir ɓela ɓër gër ebar elo. ");
INSERT INTO bsc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Fel këŋo Efëroŋ, na gër ed ɓarër bani ɓulunda ir ebar elo: «Angëmëne aw̃a w̃a këƴ, eƴe ɓaxët, wëno ayël këmi yël akanji and oŝënga aŋ. Kanal axana koɗi in mo mëxwëtaxën asoxari aram an.» ");
INSERT INTO bsc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ɓarikan Efëroŋ yaka këŋo Abëraxam: ");
INSERT INTO bsc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Faba awël nde, ine ngwa ex ebar ed ɓatama okeme onax ɓand koɗi elo? Mëxwëtalëŋo alindax!» ");
INSERT INTO bsc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ata Abëraxam ga wël ko er re baxo Efëroŋ in, fënën këŋo koɗi in ang fënëta baxo ak, ogës od ɓërandëw̃ëra and Het: ɓatama okeme onax ɓand koɗi, ang bani nëmbënd gër ɓëfandëran ak. ");
INSERT INTO bsc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ata Abëraxam yëc ko oŝënga or Efëroŋ ol, or gër Makëpela ol, or mopaɓër gë Mamëre ol, gë oxel ak, do gë ɗek ɓatëx ɓand ex gër ed sëlëk oŝënga ak. ");
INSERT INTO bsc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ata xwën ko ɗek ogës od ɓërandëw̃ëra and Het, do ogës od ɗek ɓër bax lilënd gër ebët ed angol andeɓën. ");
INSERT INTO bsc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ga xucak eŋo, Abëraxam w̃ëxëta këŋo alindaw̃ Sara, lëf gër oxel or gër oŝënga or gër Makëpela, or mopaɓër gë Mamëre ol, mëne ngëŋ gër Ebëroŋ, gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Awa Abëraxam mondako ri baxo ɓanapëra ɓandexëm ɓaŋ gër oxel or hik gër oŝënga or yëc ko gër otaxan od ɓërandëw̃ëra and Het ol. ");
INSERT INTO bsc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ga niyitarak, Abëraxam kwël dëŋ ko xarënd. Axwën Kaxanu yël baŋo oɓetak ol gër ɓeỹ ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Akey amat, Abëraxam w̃ac këŋo axarëk ar okaɗëp od gër ekun edexëm an, ar bax nëkonand ɗek napul irexëm an, do fel këŋo: «Këla, ɗilaliw tan ataxan andeƴ aŋ gër emef endam. ");
INSERT INTO bsc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Awa gërëgako yaŝarël gër ow̃ac or Axwën Kaxanu, mëŋ ar rik orën do gë ebar an, mëne din aƴëŋo cala na asoxari ar asëñiw̃ën an gër odënaw̃ od gër ebar ed Kanahaŋ, ro gër ed lëg këme. ");
INSERT INTO bsc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ƴeyiɗ xali gër ebar edeɓi, gër ed rëw̃ këne fën, eƴo calaw asoxari ar asëñiw̃ën Isak an.» ");
INSERT INTO bsc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yaka këŋo xaɗëp in: «Ɓamat asoxari an, aŋo ñandiɗ na exe tëfëgu xali gër ebar elo ro. Mo ɓakaliɗ nde fën asëñix?» ");
INSERT INTO bsc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Yaka ko Abëraxam: «Adokiŋ, din këreƴëŋo ɓakaliɗ na ɗe! ");
INSERT INTO bsc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Axwën Kaxanu, mëŋ ar ex gër orën an, nëcëtëgu ke gër ekun ed faba, gër ed rëw̃ këne. Mëŋ w̃acëgu ke do yaŝar ko mëne ayël këɓi yël oxwën or ebar elo ro ol, ɓërandëw̃ëra andam ɓën. Mëŋ dëŋ këŋo law̃ënëgu meleka irexëm in exi ɗëngweli. Awa fën këƴo ŝotëguɗ asoxari ar asëñiw̃ën an. ");
INSERT INTO bsc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Eyaŝar ed nëỹali këmi elo, ax bo na ga sëra ki, angëmëne asoxari an aŋo ñandi ex na exi tëfëgu. Ɓari din këreƴëŋo ɓakaliɗ na fën asëñiw̃ën.» ");
INSERT INTO bsc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ata xaɗëp in lilali ko ataxan aŋ gër emef end Abëraxam, axwën arexëm eŋ. Mondako yaŝar baxo mëne ari ko ri er fel këŋo in. ");
INSERT INTO bsc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ga xucak eŋo, xaɗëp in w̃eɗ këɓi ogelemba epëxw gër kece ir ogelemba od axwën arexëm, do kwël ƴe ko, gë ɗek ɓeɓëxëɓënaxik ɓër fëxwëndëra baŋo axwën arexëm ɓën. Ƴe ko kwël ond gër ebar ed Mesopotami oŋ, xali gër angol and Naxor. ");
INSERT INTO bsc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mondako ƴe bani ɓakey ɓakey, h̃ataxën këni ɗam gër angol, ler në andu. Ata xaɗëp in foxin këɓi ogelemba ok eni pedaraxën ɓër enga endexëm ɓën. Amëd aŋo bani ƴowërawënd genëka, ɓësoxari ɓën gër edëmb ed men. ");
INSERT INTO bsc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ata xaɗëp in ŝale ko mondako: «Axwën, wëj ex Kaxanu, ar yata këŋo Abëraxam, axwën aram an. Axara xara këmi, yelex doro fëña iram in, do masinële mondako mëne alëkaya lëkaya këƴ eter ed yata këƴo axwën aram el! ");
INSERT INTO bsc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Wëno ro këme xwëŝa, gër ed këni ƴowënd odënaw̃ od ɓela ɓër gër angol aŋo ok, eni dëmb men oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Endënaw̃ end këmo fel: “Axara xara këmi, ñëw̃ël eput edeƴ el me ceɓaxën men ond lapara këƴ oŋ”, do mëŋ exe yaka: “Awa ceɓël, arëmbën rëmbënëgu ɓëte ogelemba odeƴ ok eni ceɓ!” Gilexo asoxari ar sanan këƴo Isak, xaɗëp ireƴ an! Angëmëne mondako ri këƴ, anang këme nang mëne alëkaya dëŋ lëkaya këƴ eter ed yata këƴo Abëraxam, axwën aram el.» ");
INSERT INTO bsc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Xaɗëp in axo ŋata bana pere cale iŋo ga h̃atëgu ko gë eput el monapara, Rebeka aɓiw̃ ar Betuwel asëñiw̃ ar Milëka, asoxari ar Naxor, aɓaỹe ar Abëraxam an. ");
INSERT INTO bsc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Endënaw̃ end yek mbaŋ ebaxo, emeja fo ɓayi baxo, do gë asoŝan ani nangër bana. Mëŋ ŝëla bax gër andu rëmbëgu ko men oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Xaɗëp in hër ko, fed këni, do re ko: «Axara xara këmi, ñëw̃ël eput edeƴ el, me ceɓaxën men ond lapara këƴ oŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Yaka ko endënaw̃ eŋ: «Ceɓël faba, ceɓël!» Ỹëw̃ ko aỹand eput el, exo ceɓaxën xaɗëp in. ");
INSERT INTO bsc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","And fed këŋo aŋ, endënaw̃ eŋ re ko: «Arëmbën këmëni rëmbënëgu ɓëte ogelemba odeƴ ok eni ceɓ xali eɓi ped.» ");
INSERT INTO bsc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ata xat ko aỹand gër aceɓa men ond ɓayita bax gër eput oŋ. Ɓaka ko aỹand exo dëmbëgu ɓëte polo gër andu. Rëmbëndëra këɓi mondako ɗek ogelemba ok. ");
INSERT INTO bsc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ata asoŝan an ko yëlarand ba Axwën Kaxanu dëŋ nde rik eŋo ex yexën fëña irexëm in. ");
INSERT INTO bsc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","And ŝeɓ këni ogelemba xali fed këɓi aŋ, asoŝan an yëpëtën këŋo anëna atiɓax and kaŋe, gë ɓëŋwën ɓëtiɓax ɓënd kaŋe, do ɓakëra këŋo endënaw̃ eŋ gër onëxar. ");
INSERT INTO bsc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Xaɗëp in w̃ëka ko: «Wëj endënaw̃ end noỹo wa hi këƴ? Axara xara këmi, pelële. Aŝot nde këmi ŝot gër ndewën në er këɓo xey?» ");
INSERT INTO bsc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Yaka ko endënaw̃ eŋ: «Wëno itox ind Betuwel hi këme. Faba iram, asëñiw̃ ar Milëka, alindaw̃ ar Naxor, hi ko.» ");
INSERT INTO bsc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Re ko ɓëte: «Er këni ƴamb ogelemba in ax gi ex na mopaỹ gër ndeɓi. Ɓëte aŝot kën ŝot gër ed këŋun xey.» ");
INSERT INTO bsc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ata asoŝan an ga rëngw ko, foxi ko gër lëngw ir Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Re ko: «Aye ri ko Axwën Kaxanu, mëŋ ar yata këŋo Abëraxam, axwën aram an. Gayikwa alëkaya lëkaya ko eter ed yata këŋo axwën aram el. Axwën Kaxanu w̃ëlaw ke ŝëw̃ gër ɓëmaỹe ɓënd axwën aram.» ");
INSERT INTO bsc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ata endënaw̃ eŋ hër ko eŋo tëfëtanëx nëm ɗek endeƴ eŋo. ");
INSERT INTO bsc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka, imaỹe itoŝan ebaŋo na ind bano w̃acënd Labaŋ. Labaŋ hërëgu ko gër ed ebaxo asoŝan ajo, ler gër andu. ");
INSERT INTO bsc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ga wateli baŋo aɓinëm Rebeka anëna aŋ, gë ɓëŋwën ɓëŋ, do wël baŋo ga ko reƴa ɓend felëgu baŋo asoŝan ajo ɓeŋ, ƴowaxënëgu baxo Labaŋ gër asoŝan ar h̃atëgu bax gë ogelemba ok, ler gër andu. ");
INSERT INTO bsc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ata re ko Labaŋ: «Ƴow wëj ar gë oɓetak or Axwën Kaxanu an! Inew̃a ɓayixën këƴ gër ed h̃atëgu këƴ ro? Ƴene gër ndeɓi, aŝotën këmëni ŝotën ogelemba ok gër ed këni hi.» ");
INSERT INTO bsc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Asoŝan an h̃at ko gër iciw̃. Labaŋ fel këɓi odexëm enëɓi pëtëra ogelemba ok, do enëɓi kwëtindëra olëɓ oŋ. Xoɓëndëran këɓi ondës do gë enenar. Yël këɓi ɓëte asoŝan ajo do gë ɓela ɓër laŋëtagu baŋo ɓën men ond eni neɓaraxën osapar oreɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ata rëɗën kënëɓi ecemar el. Ɓarikan asoŝan ajo re ko: «Wëno pere fo këme reƴa olaw̃ën ol ɗamana mi ƴambëraxën.» Yaka këŋo Labaŋ: «Awa deƴal!» ");
INSERT INTO bsc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ata re ko: «Wëno xaɗëp ir Abëraxam hi këme. ");
INSERT INTO bsc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Axwën Kaxanu mbaŋ yël këŋo oɓetak ol axwën aram an, do ala ar gapak hi ko. Ayël yël këŋo oɓeci, gë opeỹ, gë oxeƴ, gë koɗi, gë kaŋe, gë ogelemba, gë opali, gë okaɗëp otoŝan, do gë okaɗëp otoxari. ");
INSERT INTO bsc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, alindaw̃ ar axwën aram an, gand oxar go dëŋ rëw̃ën këŋo itoŝan. Do axwën aram an, asëñiw̃ ijo yël këŋo ɗek er xwën ko in. ");
INSERT INTO bsc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Wëno ayaŝar yaŝar këme gër axwën aram mëne ari këme ri ang fel ke ak: “Këreƴo calaɗ na asoxari ar asëñiw̃ën an gër odënaw̃ od gër ebar ed Kanahaŋ, gër ed lëg këme ro. ");
INSERT INTO bsc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ɓarikan ƴeyiɗ gër ɓër hi këmi ekun eɓat, gër ɓër ɓar këmi andëw̃ëra. Fën këƴo ŝalagu asoxari ar asëñiw̃ën an.” ");
INSERT INTO bsc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Wëno yaka këmo axwën aram an: “Ɓamat asoxari an axo maɗ na exe tëfëgu.” ");
INSERT INTO bsc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Yaka ke: “Wëno din këme rind er re ko Axwën Kaxanu in, mëŋ dëŋ këŋo law̃ëneliwëgu meleka irexëm in exi dëca ex ye fëña ireƴ in. Calaguɗo asoxari ar asëñiw̃ën an gër ɓër ɓar këmi andëw̃ëra, gër ɓër hi këmi ekun eɓat. ");
INSERT INTO bsc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Angëmëne ah̃at h̃at këƴ gër ɓër ekun edam, ax bo na ga sëra ki eyaŝar ed yaŝar këƴ elo. Ɓëte angëmëne ɓën eni ŋëp eni yëlëgu endënaw̃ eŋ, oŝëɓa ax bo na ga sëra ki gë eyaŝar ed yaŝar këƴ elo.” ");
INSERT INTO bsc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Doro ga h̃atëgu këme gër andu, ŝale këme: Kaxanu, wëj ar yata këŋo Abëraxam, axwën aram an, dëcale ex ye fëña iram in. Axara xara këmi, masinële asoxari ar asëñiw̃ ar axwën aram an. ");
INSERT INTO bsc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nëkoɗ ga xwëŝa këme ler gër andu ro, endënaw̃ end kë ŝanëgu edëmb ed men do wëno mo mëka: Këla ñëw̃ël eput edeƴ el me ceɓaxën men ond lapara këƴ oŋ, ");
INSERT INTO bsc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","do mëŋ exe yaka: “Awa ceɓël, arëmbën këmëni rëmbënëgu ogelemba odeƴ ok eni ceɓaxën ɓën ɓëte!” Gilexo asoxari ar sanan këƴo asëñiw̃ ar axwën aram an! ");
INSERT INTO bsc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ɗamana me ŋata cale indam iŋ, h̃atëgu ko Rebeka, eput el monapara. Ŝëla ko gër andu do rëmbëgu ko men oŋ. Ata wëno re këme: “Axara xara këmi, ñëw̃ël eput edeƴ el me ceɓaxën men ond lapara këƴ oŋ.” ");
INSERT INTO bsc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ỹëw̃ ko aỹand eput ed lapara baxo el, do re ko: “Ceɓël, arëmbën këmëni rëmbënëgu ɓëte ogelemba odeƴ ok eni ceɓ!” Wëno ŝeɓ këme, do ɓëte rëmbënëgu këɓi ogelemba ok ŝeɓ këni. ");
INSERT INTO bsc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","W̃ëka këmo: “Endënaw̃ end noỹo wa hi këƴ?” Yaka ko: “Aɓiw̃ ar Betuwel hi këme! Faba iram, asëñiw̃ ar Naxor hi ko, itoŝan ind rëw̃ këŋo Milëka iŋ.” Wëno ataŋ ɓakëra gë amocën aŋ, do gë ɓëŋwën ɓëŋ gër onëxar. ");
INSERT INTO bsc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Axwën Kaxanu, mëŋ ar yata këŋo Abëraxam, axwën aram an, w̃ëlaw ke sëw̃ wëno ar ocal od asoxari ar asëñiw̃ ar axwën aram an. Mëŋ ŝëxwëndër këɓo gë endënaw̃ end aɓinëm ar axwën aram eŋ. Ata ga rëngw këme, foxi këme gër lëngw ir Axwën Kaxanu, ŝëkwa këmo. ");
INSERT INTO bsc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Awa gërëgako angëmëne kwël lëkaya kën do aɓayeli ɓayeli këŋun aminëmëra and gë axwën aram aŋ, peline. Angëmëne ax gi ex na mondako, ɓëte peline me gi gë enang nang.» ");
INSERT INTO bsc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ata Labaŋ do gë Betuwel yaka këni: «Endeƴ eŋo gër Axwën Kaxanu xaniwëk, ɓiyi ami kor na mi de aw̃a w̃a këmi ba ami ma ex na. ");
INSERT INTO bsc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nëkoɗo Rebeka, meɗëlo en ƴe. Gilexo alindaw̃ ar asëñiw̃ ar axwën areƴ an, ang re ko Axwën Kaxanu ak.» ");
INSERT INTO bsc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Xaɗëp ir Abëraxam in ga wël ko eŋo, foxi ko, gër lëngw ir Axwën Kaxanu, eƴiỹ el ŋëŝ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Yëpëtëgu ko oỹënga or eñaŋënan or koɗi, gë or kaŋe, do gë ɓanjëm, yëlëra këŋo Rebeka. Yëlëra këɓi ɓëte ɓeɓëxëɓënaxik aɓinëm ar Rebeka do gë nëm irexëm. ");
INSERT INTO bsc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ga xucak eŋo, xaɗëp ir Abëraxam in do gë ɓër laŋëtagu baŋo ɓën ƴambëra këni, ŝeɓëra këni, ata lakira këni. Ga xeyëk, and nëngëtara këni aŋ, xaɗëp in re ko: «Teɓine ngwa me ɓaka gër axwën aram.» ");
INSERT INTO bsc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yaka këno aɓaỹe ar endënaw̃ do gë nëm: «Ɓayileɓo wa pere endënaw̃ eŋ ɓakeƴ epëxw, do gwëre ngwa en ƴeɗ.» ");
INSERT INTO bsc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yaka këɓi: «Kërene cac na ɗe gayikako Axwën Kaxanu rik ye ke fëña iram in. Teɓine me maỹi gër axwën aram.» ");
INSERT INTO bsc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yaka këno: «Macënëŋone endënaw̃ eŋ enëŋo mëkaye er yëla ko in.» ");
INSERT INTO bsc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Awa ga w̃ac këno Rebeka, w̃ëka këno: «Ỹandi ki nde en ƴe gë ala ajo?» Yaka ko: «Iyo aỹandi ỹandi ke.» ");
INSERT INTO bsc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ata w̃a këni enëɓi teɓ eni ƴe gë Rebeka, ar ekun edeɓën an, mëŋ do gë xaɗëp isoxari irexëm in. Kwël sëfër këni gë xaɗëp ir Abëraxam in do gë ɓër laŋëtaw baŋo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ɗamana eni ƴexën, ŝalen këno Rebeka mondako: «Wëj aɓaỹe areɓi an, oɓaŝ oreƴ ol gilexëni owëli owëli! Ɓërandëw̃ëra andeƴ ɓën kwënindëlexëni ɓangol ɓand ɓërangoỹëra andeɓën ɓaŋ!» ");
INSERT INTO bsc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka do gë okaɗëp otoxari odexëm ok ga ỹëpara këni ƴaŋ gër ogelemba, kwël sëfa këno asoŝan an. Xaɗëp ijo, mondako w̃ëla baŋo Rebeka. ");
INSERT INTO bsc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Amëd aŋo, rëfa baxo Isak ga hiw ko gër andu and bani w̃acënd Laxahi Rohi gayik gand ladawe ir Negeb lëg baxo. ");
INSERT INTO bsc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Genëka, Isak ŝan ko exo nëkonaraw gër apuỹ. Ga rënëta ko, wat këɓi ogelemba ga këni ƴow endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ata Rebeka ga rënëta ko, wat këŋo Isak. Ga raɗ ko, feda ko gër gelemba, ");
INSERT INTO bsc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","do w̃ëka këŋo xaɗëp ir Abëraxam in: «Noỹo ex wa asoŝan ar gër apuỹ ar këɓo xacagund ajo?» Yaka ko xaɗëp in: «Axwën aram Isak ex.» Ata Rebeka laɓaya ko anjëm and baxo laɓayarand aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","And fed këni aŋ, xaɗëp in sëfëtandëra këŋo Isak ɗek er riw baxo in. ");
INSERT INTO bsc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na ex Isak h̃ateli këŋo Rebeka gër aner and Sara, nëm irexëm. Mondako xana baŋo Rebeka, do mëŋ hi ko alindaw̃ ar h̃an këŋo. Mondako fuŋara baŋo end nëm ir seɓëta baŋo eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ga xucak eŋo, Abëraxam ỹër këŋo ɓëte asoxari ar bano w̃acënd Ketura. ");
INSERT INTO bsc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Rëw̃ën këŋo ɓëtoŝan ɓëŋo: Simëraŋ, gë Yokëŝaŋ, gë Medan, gë Majaŋ, gë Yiŝëbak do gë Ŝuwa. ");
INSERT INTO bsc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokëŝaŋ rëw̃ këɓi Saba do gë Dedan. Ɓosëñiw̃ ɓor Dedaŋ exëni: andëw̃ëra and Aŝur aŋ, gë and Letuŝ aŋ, do gë and Lewum aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ɓosëñiw̃ ɓor Majaŋ exëni: Efa, gë Efer, gë Anok, gë Abida, do gë Elëdaha. Ɓën ɗek ex andëw̃ëra and Ketura aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abëraxam yëlëra këŋo asëñiw̃ Isak ɗek ɓeɓër xwën baxo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","End ɓosëñiw̃ ɓor rëw̃ën bano ɓësoxari ɓër ỹëpa bani aỹëpa fo ɓën cëŋ, Abëraxam yëlëra këɓi ɓeɓërëmar do fel këɓi eni eno ŋaw̃ëta asëñiw̃ Isak. Ata ɓën ƴe këni apën-eñan. ");
INSERT INTO bsc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abëraxam er sëk baŋo, ɓëniy këme gë ofëxw ocongoxi gë ɓënjo. ");
INSERT INTO bsc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","And ŝës ko aŋ, moped fed baŋo oxar or gë onënga ol, ɗamana ɓaraxën këni gë ɓëxarëk ɓërexëm ɓër ŝësëk elod anëka fo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ɓosëñiw̃, Isak do gë Isëmayel, w̃ëxëta këno gër oxel or Makëpela, mopaɓër gë Mamëre, gër oŝënga or Efëroŋ, asëñiw̃ ar Tësohar, arandëw̃ëra and Het an. ");
INSERT INTO bsc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Oŝënga olo yëc baxo Abëraxam gër ɓërandëw̃ëra and Het. Fën w̃ëxëta kënëɓi mëŋ do gë alindaw̃ Sara. ");
INSERT INTO bsc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kaxanu yël këŋo mbaŋ oɓetak ol Isak, asëñiw̃ ar Abëraxam, and ŝës ko sëm aŋ. Amëd aŋo lëg baxo Isak ler gër andu and Laxahi Rohi. ");
INSERT INTO bsc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Mondako ex andëw̃ëra and Isëmayel aŋ, asëñiw̃ ar Abëraxam an, itoŝan ind rëw̃ këno gë Agar, xaɗëp isoxari iɓ Misëra ir Sara iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mondako ex omac od ɓosëñiw̃ ɓor Isëmayel ok, ang sëfër këni gër acël andeɓën ak: Nebayot itoŝan iñanar ind Isëmayel iŋ, gë Kedar, gë Adëbehel, gë Mibësam, ");
INSERT INTO bsc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","gë Miŝëma, gë Duma, gë Masa, ");
INSERT INTO bsc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","gë Xadad, gë Tema, gë Yetur, gë Nafiŝ, do gë Kedëma. ");
INSERT INTO bsc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ɓën ex ɓosëñiw̃ ɓor Isëmayel, gë omac odeɓën ok, gë ɓëngol ɓëndeɓën ɓëŋ, do gë ɓakwëndaya ɓandeɓën ɓaŋ: ɓemun epëxw gë ɓeki, enëng gë enëng. ");
INSERT INTO bsc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isëmayel ga liya ko ɓëniy keme gë ofëxw osas gë ɓënjongëɓëki, ŝës ko. Ata ɓar këni gë ɓëxarëk ɓërexëm ɓër ŝësëk elo anëka fo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ɓërandëw̃ëra and Isëmayel ɓën lëgëra këni, elod gër ebar ed Afila, xali gër ed Ŝur. Ebar elo faɓërëk gë ed Misëra el, gand ed Asiri. Mondako lëgëra bani ɓërandëw̃ëra and Isëmayel ɓën mopaɓër gë ɗek ɓër aminëmëra andeɓën ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Mondako ex andëw̃ëra and Isak, asëñiw̃ ar Abëraxam aŋ. Abëraxam rëw̃ këŋo Isak. ");
INSERT INTO bsc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","And sëk këŋo Isak ɓëniy ofëxw onax aŋ, ỹër këŋo Rebeka, aɓiw̃ ar Betuwel, aɓaỹe ar Labaŋ. Sëm ireɓën ebax Betuwel, arandëw̃ëra and Aram an, do lëg baxo gër ebar ed Padaŋ-Aram. ");
INSERT INTO bsc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak aŝalendëra baŋo ŝalendërand alindaw̃ gër Axwën Kaxanu gayik abaxo rëw̃ na. Ata Axwën Kaxanu yakali këŋo cale indexëm iŋ. Rebeka, alindaw̃, hi ko gë acël. ");
INSERT INTO bsc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ɓëtox ɓëŋ këni h̃ëƴërënd gër acël and nëm ireɓën. Ata nëm ireɓën ko yëlarand ba në end ine këŋo hixënënd mondako. Ƴe ko eŋo mëka Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Axwën Kaxanu yaka këŋo: «Ɓenëng ɓeki hi këni gër acël andeƴ, ɓandëw̃ëra ɓaki kë ŝapër and këni ŝanëgu gër acël andeƴ aŋ. Andëw̃ëra akinëm këŋo xuca ojaw̃ ok añanar aŋ, do andëw̃ëra and aɓejanak aŋ kë wëña and axarënak aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","And h̃atëk orëw̃ aŋ, watik mëne ɓëŝa dëŋ ex gër acël and Rebeka. ");
INSERT INTO bsc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Yatir orëw̃, iñanar iŋ ŝanëgu ko eman eŋ yer omban fo, ang acuɗ and anar fo. W̃ac këno Esawu, mëne ngëŋ «Yer Omban». ");
INSERT INTO bsc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ŝanëgu ko aɓinëm, ga sëraw ko etak ed Esawu el. W̃ac këno Yakob, mëne ngëŋ «Afërëcët». Isak anëka sëk baŋo ɓëniy ofëxw ocongeɓat and rëw̃ kënëɓi aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Oɗëmëta ok raf këni. Esawu hi ko kamara isëm, ar gër apuỹ. Yakob mëŋ cëŋ hi ko, anambik, ar kë ɓayirand gër ɓaner. ");
INSERT INTO bsc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak xwël këŋo Esawu gayik anëngan baŋo nënganënd end ow̃acar or baɓi law̃ëgund eŋ. Rebeka mëŋ, xwël këŋo Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Akey amat, Yakob ko ŝemërand. Ata h̃atëgu ko Esawu ga hiw ko gër apuỹ, aloxo ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esawu re ko: «Yakob, këla dëtënële wa me ƴamb ecemar ed warëgeƴan ed këƴ ŝemand elo, (Iyo ecemar ed warëgeƴan elo) gayikwa ɗek loxo këme.» Mëŋ nëngwëtaxën këno Esawu «Edom», mëne ngëŋ «Warëgeƴan». ");
INSERT INTO bsc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaka këŋo Yakob: «Nëmbëre pere gë oxarënak oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yaka ko Esawu: «Wëno ar kërex cës ajo nde, inew̃a ke feca oxarënak olo?» ");
INSERT INTO bsc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ata re ko Yakob: «Yaŝarël pere.» Esawu yaŝar ko. Esawu, mondako nëmb baŋo Yakob, oxarënak orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ata Yakob rëtën këŋo Esawu ecemar ed gë oŝoɗ el, do gë mburu iŋ. Esawu ƴambëra ko, ŝeɓëra ko, do kwël xani ko ƴe ko. Ata Esawu mondako ƴepën baxo oxarënak orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ga niyitarak, h̃atëguk enjo gër ebar ed Kanahaŋ, nëmëc enjo end hi bax amëd and hi baxo Abëraxam eŋ. Ata Isak ƴe ko exo ñëpax gër Gerar, ebar ed Abimelek, emun end Ofilisëteŋ el. ");
INSERT INTO bsc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Axwën Kaxanu ga ŝanaxën këŋo, re ko: «Ñëpal gër ebar ed këmi fënëtan, këreƴ cëlaɗ na gër Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ɗëgiɗ gër ebar elo ang aliyer fo. Wëno gë wëj këme hi, do ayël këmi yël oɓetak oram ol. Gayikwa wëj do gë ɓërandëw̃ëra andeƴ ɓën yël këmun ɗek owar oŋo. Mondako këme h̃ata er yaŝar këme arin këmo rin sorix Abëraxam in. ");
INSERT INTO bsc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aŝënan këmëni ŝanën ɓërandëw̃ëra andeƴ ɓën ang ow̃al or gër orën fo. Do ɗek owar oŋo këmëni yël. Do ɗek ɓenëng ɓend gër ebar ɓeŋ kë ɓeta paɓ gë andëw̃ëra andeƴ aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Gayikwa Abëraxam aɓaxët baxe ɓaxëtënd, do asëf baxo sëfënd ɓapela ɓaŋ do gë ɓacariya ɓandam ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ata Isak rëfa ko gër ebar ed Gerar. ");
INSERT INTO bsc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ɓësoŝan ɓër lëg bax gër ebar elo ɓën këno w̃ëkarand end alindaw̃ eŋ. Er baɓi yakand: «Aɓaỹe iram ex». Ayëda baxo yëdand exo de: «Asoxari aram ex», këdi këno law̃ ɓësoŝan ɓër ebar elo ɓën në end Rebeka, gayik mbaŋ ye baxo. ");
INSERT INTO bsc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ata Isak nëka ko mbaŋ na gër ebar elo. Akey amat Abimelek, emun end Ofilisëteŋ eŋ, ko ƴëkwand gër fonetër, wat këɓi Isak gë Rebeka, alindaw̃, ga këni nëxira. ");
INSERT INTO bsc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek w̃ac këŋo Isak do re ko: «Awa ajo asoxari areƴ nde ex! Mondake cëŋ rexën këƴ: “Aɓaỹe iram exo!”» Yaka ko Isak: «Wëno mondako yeƴan bame, ga bame yëland mëne alaw̃ këne law̃ në endexëm.» ");
INSERT INTO bsc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ata re ko ɓëte Abimelek: «Ine ex end ri këƴëɓo eŋo? Tëkër fo ɓayi bax asoŝan ar gër ɓulunda iram eni ɗaki gë asoxari areƴ an. Wëj lënanëdoɓo eñëŋënax eŋo!» ");
INSERT INTO bsc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ata Abimelek yël këɓi acariya aŋo ɗek ɓulunda in: «Ar këŋo sëka asoŝan ajo, ba alindaw̃, ar eɗaw̃ ex.» ");
INSERT INTO bsc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ga xucak eŋo, Isak ỹandëra ko na gër ebar elo, ŝotëra ko ɗëm aniy aŋo. Axwën Kaxanu yël baŋo oɓetak ol. ");
INSERT INTO bsc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ata Isak ŝotëra ko. Napul irexëm in kwël dëŋ bax ỹëmbërënd xali hi ko ar gë napul isëm. ");
INSERT INTO bsc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aŝot ŝot baxo okece od oɓeci do gë opeỹ, gë okece od oxeƴ, do gë okaɗëp odanjëm. Ata Ofilisëteŋ ok ỹana këni këɓi ƴakëraxind endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ɗek ɓandu ɓand nac bani angwën and hi baxo Abëraxam, sëm ir Isak ɓaŋ, lëmëra gë obar bani Ofilisëteŋ ok. ");
INSERT INTO bsc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ata Abimelek fel këŋo Isak: «Canël ebar edeɓi el, gayikwa mbaŋ xuca këƴëɓo ojaw̃ ok.» ");
INSERT INTO bsc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isak ƴe ko ŝëxwayax ko gër epesa ed Gerar, do lëgëx ko fën. ");
INSERT INTO bsc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ata Isak lëmëtëra ko ɓandu ɓand nac baxo Sëm Abëraxam ɓaŋ, and ɓayi baxo mopër aŋ. Ofilisëteŋ ok lëmëra bax, and ŝës ko Abëraxam aŋ. Ang w̃acëra baxo sëm ɓandu ɓaŋo ak w̃acëra baxo mëŋ ɓëte. ");
INSERT INTO bsc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Akey amat, okaɗëp od Isak ok bax nacënd ɓëte andu gër epesa. Sëkën këni añësa and gë men ond mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ɓarikan ɓëxaɗac ɓër gër ebar ed Gerar ɓën sakëreli kënëɓi ɓëxaɗac ɓër Isak ɓën. Er bani rend: «Ɓiyi xwënëk men oŋo!» Ata Isak w̃ac ko andu aŋo «Esek», mëne ngëŋ «Atakëra» gayik asakëreli sakëreli bano në end andu aŋo. ");
INSERT INTO bsc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Okaɗëp od Isak ok nac këni ɓëte andu acëxe, sakëreli kënëɓi gaŝëxe. Isak w̃ac ko andu aŋo «Sitëna», mëne ngëŋ «Ekandër». ");
INSERT INTO bsc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ata Isak ga xani ko na, rëfa ko, do nacëx ko andu acëxe, and ala aŋo takëreli bana. W̃ac ko andu aŋo «Rexobot», mëne ngëŋ «Wur iỹangax». Gayikwa are re baxo: «Gërëgako Axwën Kaxanu anëka xwët këɓo gër ed këne xëñe. Axor këne xore ene cotëraye gër ebar elo.» ");
INSERT INTO bsc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isak ga xani ko na, rëfa ko kwël ƴaŋ ƴaŋ, end Berëŝeba eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ata Axwën Kaxanu ŝanayaxën këŋo gëmëɗ ijo, do re ko: «Wëno ex Kaxanu, ar yata këŋo sorix Abëraxam an. Gë wëj hik këme, këreƴ yëdarand na. Wëno ki yël oɓetak ol, do me cënan andëw̃ëra andeƴ aŋ në end Abëraxam, ariyenin aram eŋ». ");
INSERT INTO bsc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ata Isak ri ko na angëɓ, do ŝale këŋo Axwën Kaxanu. Na ri baxo ɓaner ɓandexëm ɓaŋ, do okaɗëp odexëm ok nac këni ɓëte andu. ");
INSERT INTO bsc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek do gë Ahusat, alaŋëtaran arexëm an, do gë Pikol, alëngw ar ocoroɗa odexëm an, nëngaw këno Isak, ga xaniw këni gër ebar ed Gerar. ");
INSERT INTO bsc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ata w̃ëka këɓi Isak: «Inew̃a nëngaxënëgu këne xarak aŝus ŝus këne, do aw̃ayëgu w̃ayëgu këne gër ndewën?» ");
INSERT INTO bsc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yaka këni: «Ɓiyi aye wat këmi mëne Axwën Kaxanu gë wëj hi ko. Mëŋ ƴowaxënëgu këmi mi pel: Axara xara këmi, yatarëne eter wëj gë ɓiyi, eter ed këne yaŝare mëne afëɓ këne fëɓe. ");
INSERT INTO bsc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Yaŝarël mëne wëj aƴëɓo mereli na, gayikwa ɓiyi eñëŋënax gematak ami dinanëgu ex na. Wayët enjekax fo rinëgu këmi, do seɓëgu këmi rëfaw këƴ gë aketëxeta fo. Gërëgako Axwën Kaxanu yël ki oɓetak ol.» ");
INSERT INTO bsc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ata Isak rin këɓi ñambëran, ƴambëra këni do ŝeɓëra këni. ");
INSERT INTO bsc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ga xeyëk, mopëɗ, yatar këni eter el, do yaŝar këni ala kala. Isak seɓ këɓi, kwël ƴe këni gë aketëxeta fo. ");
INSERT INTO bsc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kwël yatijo fo ƴow bani okaɗëp od Isak ok, fel këno end andu and bani nacënd eŋ: «Anëka sëkën këmi men oŋ!» ");
INSERT INTO bsc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isak w̃ac ko andu aŋo «Ŝiba», mëne ngëŋ «Eyaŝar». Mëŋ w̃acaxën këni doro doro angol aŋ «Berëŝeba», mëne ngëŋ «Andu and gë Eyaŝar». ");
INSERT INTO bsc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esawu ga sëk këŋo ɓëniy ofëxw onax, ỹër këɓi odënaw̃ oki od ɓërandëw̃ëra and Het: Yudit, aɓiw̃ ar Beri, do gë Basëmat, aɓiw̃ Eloŋ. ");
INSERT INTO bsc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ɓarikan Isak do gë Rebeka mokoỹ bani xoỹënd end ɓësoxari ɓëjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Amëd aŋo, Isak mbaŋ xar baxo, ɓangës ɓandexëm ɓaŋ aɓaŝëta ɓaŝëta bax: ax bo bana ga ko watëra. Akey amat, ga w̃ac këŋo Esawu, itox ikarëk indexëm iŋ, re ko: «Asëñiw̃ën!» Mëŋ yaka ko: «Woy!» ");
INSERT INTO bsc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Re ko ɓëte Isak: «Wëno anëka xar këme, do ame nang ex na yatir këme ŝës. ");
INSERT INTO bsc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Gërëgako, axara xara këmi meɗël oỹënga or onëxa oŋ, amote andeƴ aŋ, gë atumb andeƴ aŋ, do el gër apuỹ eƴe ɗaw̃ënëgu emacar. ");
INSERT INTO bsc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Cëɗënëguye ỹas eŋ ex nënga, ang h̃an këme ak. Do mëlanëguye me ƴak, mi karanaxën oɓetak ol ɗamana me cës.» ");
INSERT INTO bsc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Xarak, and baŋo felërand Isak mondako asëñiw̃ Esawu aŋ, Rebeka awël wël baŋo. Esawu ƴe ko ngwa gër apuỹ exo nëxaraw, do eŋo ɗaw̃ëgu emacar end këŋo w̃ëlagu eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ata Rebeka fel këŋo asëñiw̃ Yakob: «Awël wël këmo sorix ga këŋo fel aɓinëx Esawu: ");
INSERT INTO bsc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Mëlanëguye emacar, cëɗënëguye ỹas eŋ ex nënga ang h̃an këme ak, me ƴak, do mi karanaxën oɓetak ol gër Axwën Kaxanu ɗamana me cës.” ");
INSERT INTO bsc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Gërëgako asëñiw̃ën, ɓaxëtële mi pel er këƴ ri in. ");
INSERT INTO bsc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Këla ƴel gër eciỹi eƴe yeɓënëgu ɓëpërac ɓënd ŝenene ɓëki. Wëno këŋo ŝëɗën sorix ỹas eŋ ex nënga ang h̃an ko ak. ");
INSERT INTO bsc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Wëj këŋo w̃ëlan sorix exo ƴak, exi karanaxën oɓetak ol ɗamana exo cës.» ");
INSERT INTO bsc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ata Yakob yaka këŋo nëm Rebeka: «Aɓaỹe Esawu yer omban fo ga hi ko wa, xarak eman endam eŋ garëgar ex. ");
INSERT INTO bsc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ɓamat faba alëkëra ke lëkëra, do exo wata mëne në eyifa emo. Eñëŋënax wa ke xaran, ax gi ex na oɓetak.» ");
INSERT INTO bsc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Re ko nëm Rebeka: «Eñëŋënax eŋo wëcaniɗëlexe wëno, asëñiw̃ën! Awël nde, ƴel eƴe yeɓënëgu ɓëpërac ɓëŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ata Yakob ƴe ko yeɓëgu këɓi ɓëpërac ɓëŋ, do w̃ëlaw këɓi gër nëm. Nëm ŝëɗ ko ỹas ereɓën eŋ, nëngak ang h̃an ko Isak ak. ");
INSERT INTO bsc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ata Rebeka w̃eɗ ko ɓacuɗ ɓand Esawu, ŝambenjar ixarëk irexëm ɓaŋ, ɓand xurik ex ye gër iciw̃ ɓaŋ, do ŝuɗëra këŋo Yakob, ŝambenjar iɓeja irexëm in. ");
INSERT INTO bsc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","W̃eɗ ko ɓanar ɓand ɓëpërac ɓaŋ, ŝerira këŋo ed onëxar el, do gër egëla ed garëgar ed asëñiw̃ Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Fëxwën këŋo asëñiw̃ Yakob ỹas er ŝëɗ baxo xali nëngak eŋ, do gë amburu aŋ, eŋo mëlan Isak. ");
INSERT INTO bsc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ata Yakob ga h̃at ko gër sëm, w̃ac këŋo: «Faba!» Yaka ko mëŋ: «Woy! Wëj noỹo ex wa asëñiw̃ën?» ");
INSERT INTO bsc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaka ko Yakob: «Wëno Esawu, itox iñanar indeƴ iŋ ex. Er fel baƴe in ri këme. Axara xara këmi, kanil eƴ ñëpa. Ƴakëral ỹas er emacar end law̃ënëgu këmi eŋ, eƴe karanaxën oɓetak ol.» ");
INSERT INTO bsc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak fel këŋo asëñiw̃: «Ata aỹand aỹand ŝotëgu këƴo ɗe asëñiw̃ën!» Yaka ko Yakob: «Axwën Kaxanu, ar yata ki an, fangacëgu këŋo gër lëngw iram.» ");
INSERT INTO bsc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isak fel këŋo ɓëte Yakob: «Axara xara këmi, tëkawëye tan mi ɗëkëra asëñiw̃ën, me nangaxën aye mëne wëj asëñiw̃ën Esawu dëŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakob sëka këŋo sëm Isak, do mëŋ ga lëkëra këŋo, re ko: «Oniw̃ ol or Yakob ol ex, ɓarikan onëxar oŋ, or Esawu ex.» ");
INSERT INTO bsc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ata aŋo kwita ex na gayik onëxar oŋ yer omban fo bax ang or aɓinëm Esawu fo. Ata xarandëra këŋo na oɓetak ol. ");
INSERT INTO bsc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isak re ko: «Wëj dëŋ nde ex asëñiw̃ën Esawu?» Yaka ko Yakob: «Iyo wëno dëŋ ex.» ");
INSERT INTO bsc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Re ko ɓëte Isak: «Dinëguye tan, me ƴamb ỹas er emacar end law̃ënëgu këƴe wëj asëñiwën eŋ, mi karanaxën oɓetak ol.» Ata Yakob rin këŋo, do ƴambëra ko. W̃ëlanëgu këŋo ngoƴ iŋ, ŝeɓëra ko. ");
INSERT INTO bsc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ata sëm Isak re ko: «Tëkawëye, axara xara këmi, megale, asëñiw̃ën!» ");
INSERT INTO bsc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakob sëka këŋo sëm do w̃ega këŋo. Isak wëran këŋo otëñer ond ɓanjëm ɓandexëm oŋ. Ata xaran këŋo oɓetak ol mondako: «Oko otëñer ond asëñiw̃ën oŋ, er ex ang otëñer ond oŝënga or gë oɓetak or Axwën Kaxanu fo. ");
INSERT INTO bsc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kaxanu yëlëlexi, aŝëɓer ir kë fedawënd gër orën in, do gë napul ir gër ebar in, bële ir mbaŋ, do gë ngoƴ ind mbaŋ! ");
INSERT INTO bsc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ɓenëng ɓend ɓela këƴëɓi ỹana eƴëɓi bëñand, do ɓën eni diyeninënd, ɓenëng kë ỹana ex poxind gër lëngw ireƴ! Gil alëngw ar ɓoɓinëx an, oɓaŝ or norix ol poxindëlexëni gër lëngw ireƴ! Kataleŋo ar ki xarend an, ɓetalexo ar ki xaranënd oɓetak an!» ");
INSERT INTO bsc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak anëka h̃ata baxo ekaran ed oɓetak Yakob el, do Yakob eceɗ-eceɗ ŝapër bani gë sëm. H̃atëgu ko ngwa aɓinëm Esawu, ga hiw ko gër onëxa. ");
INSERT INTO bsc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Mëŋ ɓëte ŝëɗëra ko ỹas eŋ xali nëngak, do w̃ëlanëgu këŋo sëm. Fel këŋo sëm: «Faba kanil eƴ ƴak ỹas er emacar end law̃ënëgu këmi eŋ, eƴe karanaxën oɓetak ol, wëno asëñix!» ");
INSERT INTO bsc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yaka ko sëm Isak: «Wëj noỹo ex wa?» Yaka ko Esawu: «Wëno Esawu ex, itoŝan ikarënak indeƴ iŋ!» ");
INSERT INTO bsc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ata Isak këŋo rëgënënd mbaŋ. Re ko: «Noỹo cëŋ nëxaw këŋo emacar eŋ do w̃ëlanëgu ke ỹas eŋ? Wëno anëka ƴambëra këme, ɗamana eƴ ŋataxënëgu. Anëka xaran këmo oɓetak ol, do mëŋ ɓetak!» ");
INSERT INTO bsc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","And wël ko Esawu eyeƴan ed sëm aŋ, songët ko ga ƴambën këŋo mbaŋ gër emëkw. Fel këŋo sëm: «Wëno ɓëte karanële wa axaran oɓetak ol, faba!» ");
INSERT INTO bsc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yaka ko sëm: «Aɓinëx wa ƴowëk gë njifa, do w̃eɗ ko oɓetak oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu re ko: «Ba gayik Yakob këno w̃acënd nde naŋëtaxën ke ɓakëlëbëd ɓaki? Mëŋ xan ke oxarënak oram ol, do doro xan ke ɓëte oɓetak oram ol!» Ɓaŝ ko Esawu: «Oɓetak aƴe penan ex na nde?» ");
INSERT INTO bsc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak yaka këŋo Esawu: «Wëno anëka ri këmo alëngw areƴ, do anëka yël këmo ɗek ɓoɓinëm eni gi okaɗëp odexëm. Ɓëte anëka ri këmo ar kë ỹana ex cotërand mbaŋ bële do gë ngoƴ: awa ine këme xor mi din asëñiw̃ën?» ");
INSERT INTO bsc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu w̃ëka këŋo sëm: «Oɓetak olo fo nde ŝot baƴ, faba? Wëno ɓëte karanële wa axaran oɓetak ol, faba!» Ata Esawu ko sesënd. ");
INSERT INTO bsc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Sëm Isak yaka këŋo: «Wëj caw kën h̃awëtar gë napul ir gër ebar in, do gë aŝëɓer ir kë fedawënd gër orën in, aŝëɓer ir ƴaŋ in, caw kën h̃awëtar. ");
INSERT INTO bsc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Wëj gë ojaw̃ od duxuma ireƴ ok këƴ ỹana eƴ cotënd er këƴ liyaxën in, do aɓinëx këƴ ỹana eƴo diyeninënd. Ɓarikan ga këƴ ỹana eƴ ƴexërand ƴaƴa fo gër ed yo, aŝana këƴ ŝana mbëña indexëm iŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ga xucak eŋo, Esawu xoỹën këŋo mbaŋ Yakob në end oɓetak or xaran baŋo sëm ireɓën eŋ. Esawu are baxo rend: «Ɓakey ɓand oỹaw̃ or faba ɓaŋ ɗam ex. And kë xuca aŋ këmo law̃ aɓaỹe Yakob.» ");
INSERT INTO bsc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Fel këno Rebeka eyeƴan ed Esawu, ŝambenjar ixarënak irexëm el. Ata Rebeka w̃ac këŋo Yakob, ŝambenjar iɓeja irexëm in, do fel këŋo: «Aɓinëx Esawu cëŋ aỹandi ỹandi këŋo exi ɗaw̃, exi maŝaxën. ");
INSERT INTO bsc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Gërëgako asëñiw̃ën, ɓaxëtële: Ƴel eƴ ñafëx gër aɓaỹe Labaŋ, gër ebar ed Xaraŋ. ");
INSERT INTO bsc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ñëpax gër iciw̃ indexëm ɓëniy, xali aɓinëx eŋo koc oxoỹ orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","And këŋo xoc oxoỹ or xoỹën ki aŋ, do exo kwëya end ri këƴëŋo eŋ, ata këmi w̃aỹiliwëɗ. Inew̃a ke nemëranaxën wën tak ɓëxi akey amat?» ");
INSERT INTO bsc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ga xucak eŋo, Rebeka fel këŋo Isak: «Wëno ax bo ex na ga ke ỹandind me ɗiya në end odënaw̃ od andëw̃ëra and Het oko! Angëmëne Yakob eŋo ñërëgu ɓëte endënaw̃ end gër ebar elo ro, inew̃a këme ɓayixën gër aniyan?» ");
INSERT INTO bsc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ata Isak w̃ac këŋo Yakob, ŝalen këŋo do fel këŋo mondako: «Këreƴëŋo ñërëɗ na ɗe asoxari Aɓëkanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ƴel gër ebar ed Padaŋ-Aram, gër ekun ed Betuwel, sëm ir norix. Fën këƴo ỹërëgu asoxari gër odënaw̃ od Labaŋ, aɓinëx ar norix. ");
INSERT INTO bsc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kaxanu, mëŋ ar xorëk ɓeỹ ɗek an, yëlëlexi oɓetak ol, cënanëlexi, ñëmbënëleɓi oɓaŝ oreƴ ol, do gil amara and ɓenëng ɓendanjëm! ");
INSERT INTO bsc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kaxanu yëlëleŋun oɓetak or Abëraxam ol, wëj do gë ɓërandëw̃ëra andeƴ ɓën, eƴ kanaxën oxwën or ebar elo ro ol, gër ed lëg këƴ ang aliyer fo elo, ebar ed w̃eɗ ko Kaxanu do yël këŋo Abëraxam elo.» ");
INSERT INTO bsc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ata Isak mondako felëra baŋo Yakob exo ƴe gër ebar ed Padaŋ-Aram, gër Labaŋ, asëñiw̃ ar Betuwel, arandëw̃ëra and Aram, aɓinëm ar Rebeka, nëm ir Yakob do gë Esawu an. ");
INSERT INTO bsc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu wat ko mëne Isak, and baŋo xaranënd oɓetak Yakob aŋ, afel fel baŋo exo ƴe gër ebar ed Padaŋ-Aram, eŋo calaw asoxari. Ga këŋo xaran oɓetak ol mondako yeƴan baxo: «Këreƴëŋo ñërëɗ na asoxari Aɓëkanahaŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esawu wat ko mëne Yakob aw̃a w̃a baxo end nëm do gë sëm eŋ, mëŋ ƴexën baxo kwël gër ebar ed Padaŋ-Aram. ");
INSERT INTO bsc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Mondako wata baxo Esawu mëne sëm Isak axoỹën xoỹën baŋo në end ɓësoxari ɓërexëm, ɓër ebar ed Kanahaŋ eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ata ƴe ko gër Isëmayel, asëñiw̃ ar Abëraxam. Ỹërëgu këŋo Mahalat, aɓiw̃ ar Isëmayel, imaỹe itoxari ind Nebayot iŋ. Esawu w̃ëlaw këŋo, do ɓar këɓi gë ɓësoxari ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakob xani ko na gër Berëŝeba, ond gër ebar ed Xaraŋ oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","H̃at ko gër ed këŋo xey gayikwa eñan eŋ anëka ŝëla bax. W̃eɗ ko ekaỹ, xwëtaxën ko gaf irexëm in, do kwël raŝ këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ata ga ko lakeli, wat ko: angwaŋ-gwaŋ ga xaƴ këni elod gër ebar xali gër orën. Wat këɓi omeleka od Kaxanu ok ga këni nëmëcër oko ƴaŋ-ƴaŋ, oko gëɗ-gëɗ. ");
INSERT INTO bsc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Wat këŋo ɓëte Axwën Kaxanu ga xwëŝa ko ƴaŋ do këŋo felënd: «Wëno ex Axwën Kaxanu, ar yata këɓi ejix Abëraxam, do gë Isak an. Ebar ed gër ed laki këƴ elo ayël këmun yël oxwën ol wëj do gë ɓërandëw̃ëra andeƴ ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ɓërandëw̃ëra andeƴ ɓën aỹëmb këni ỹëmb ang oŝeñi fo. Eɗëg edewën el aỹang kë ỹang gand apën-eñan, gand acëla-eñan, gand ambëng, do gand ambëtëɓ. Ɗek ɓenëng ɓend gër ngwëŋ ɓeŋ kë ŝot oɓetak ol paɓ gë wëj do gë andëw̃ëra andeƴ aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Wëno gë wëj këme hi, gër ed këƴ ƴe yo, wëno anëkona këmi ỹana mi nëkonand. Do aɓakaliw këmi ɓakaliw gër ebar elo ro. Gayikwa ah̃ata këme h̃ata end këme rend eŋo, din ami teɓ na.» ");
INSERT INTO bsc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakob ga nëngëta ko, re ko: «Enimin Axwën Kaxanu, ro wa hi ko, do wëno ame nang bana!» ");
INSERT INTO bsc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ga yëdara ko, re ko: «Awa gër ed hi këme ro mbaŋ ỹigënëk! Ro ex iciw̃ ind Kaxanu iŋ, ro ex ebët ed orën el!» ");
INSERT INTO bsc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakob ga xani ko mopëɗ gëɓër, w̃eɗ ko ekaỹ ed xwëtaxën baxo gaf el, rëɗ ko, do xoŝ ko ogu. ");
INSERT INTO bsc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","W̃ac ko na gër ed xey baŋo: «Bet-El», xarak angol and ex ler na aŋ, Lus bani w̃acënd. ");
INSERT INTO bsc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ata Yakob ɓeƴa ko mondako: «Angëmëne Kaxanu gë wëno hi ko, angëmëne axaxa xaxa ke gër fëña iram, angëmëne ayël ke yëlënd eƴamb ƴamb in, do gë ɓanjëm ɓand këme ŝuɗa ɓaŋ, ");
INSERT INTO bsc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","do angëmëne aye fo ɓakaw këme gër faba, ata Axwën an kë hi Kaxanu, ar yata ke an.» ");
INSERT INTO bsc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","«Ekaỹ ed rëɗ këme elo kë hiɗ aciw̃ and Kaxanu aŋ. Do gër ɓeɓër ke yël yo, aw̃eɗën këmo ỹana me meɗënënd dim in.» ");
INSERT INTO bsc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakob ga fakët ko oñe oŋ, faɓ ko gand ebar ed apën-eñan. ");
INSERT INTO bsc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Sëk ko andu gër apuỹ. Wat këɓi ɓëmëxwër ɓëtas ɓënd oɓeci, do gë opeỹ ga seyëtara këni jeƴ gër andu gayik na banëɓi ŝeɓënënd. Gë angaỹ atëm bani sëndënd andu aŋo. ");
INSERT INTO bsc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ɓëxaɗac ɓën, and kënëɓi ɓar ɗek ɓenga ɓend oyel aŋ fo bani sëndëtënd andu aŋ enëɓi dëmbënaxën men oŋ. Ɓëte and këni ŝeɓ ɗek oyel aŋ fo bani sëndënd gaŝëxe. ");
INSERT INTO bsc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ata Yakob w̃ëka këɓi ɓëxaɗac ɓën: «Ɓëmaỹe wën ɓër feye wa hi kën?» Yaka këni: «Ɓiyi ɓër gër Xaraŋ hi këmi.» ");
INSERT INTO bsc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","W̃ëka këɓi ɓëte: «Anang nde nang këno Labaŋ, ejiw̃ ed Naxor?» Yaka këni: «Iyo anang nang këmo.» ");
INSERT INTO bsc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Re ko: «Mocan nde ɓayi ko wa?» Yaka këni: «Mocan ɓayi ko! Nëkoɗo wa ado aɓiw̃ Raŝel ga ko h̃atëgund gë oɓeci orexëm ol.» ");
INSERT INTO bsc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Re ko ɓëte Yakob: «Ƴaŋ ɓayik eñan eŋ, ax ŋat ex na eɓar ed oyel el. Ceɓëninëɓi oɓeci ol do gë opeỹ ok, do enëɓi ɓakalixën gër ondës eni ɓaŝaraw.» ");
INSERT INTO bsc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Yaka këni: «Ami kor na mi di eŋo. And këmëni ɓar ɗek ɓenga ɓend oɓeci do gë opeỹ aŋ fo këmi sëndëtënd andu aŋ, amëd aŋo fo këmëni ŝeɓënënd.» ");
INSERT INTO bsc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ata ga këni yeƴan mondako fo ɓayi bani, ga h̃atëgu ko Raŝel gë oɓeci or sëm ol, mëŋ axaɗac isoxari ebaxo. ");
INSERT INTO bsc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakob watër këni gë Raŝel, endënaw̃ end aỹiw̃ Labaŋ, and h̃atëgu ko na gë oyel or Labaŋ aŋ. Yakob sëka ko andu aŋ do sëndët ko angaỹ aŋ. Rëmbën këɓi oyel or aỹiw̃ Labaŋ ol. ");
INSERT INTO bsc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakob, ga w̃ega këŋo Raŝel, fulët këŋo otes. ");
INSERT INTO bsc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Fel këŋo mëne ar nëng ir sëm exo, do asëñiw̃ ar Rebeka. Ata Raŝel hër ko felëgu këŋo sëm. ");
INSERT INTO bsc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Sam ga wël ko Labaŋ mëne Yakob, asëñiw̃ ar imaỹe itoxari indexëm iŋ h̃atëguk, hërëgu ko eŋo kaca, ata w̃ega këŋo bëxiɓ. H̃ateli këŋo gër iciw̃, do Yakob sëfëtandëra këŋo ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ata Labaŋ fel këŋo: «Wëj ata enimin ŝapar iram dëŋ eƴ.» Yakob ỹëpa ko facaw̃ na gër iciw̃ ind Labaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Akey amat, Labaŋ fel këŋo Yakob: «Ax ñap ex na eƴe diyeninënd ariyenin fo gayik aỹu eƴ. Pelële ba ine kë hi acosa andeƴ aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Xarak, Labaŋ odënaw̃ oki ŝot baɓi: ekarënak eŋ Leya, do emeja eŋ Raŝel. ");
INSERT INTO bsc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ɓangës ɓand Leya ɓaŋ anambi nambi bax, ɓarikan Raŝel, monje ye baxo. ");
INSERT INTO bsc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Awa Yakob ga h̃an baŋo anëka Raŝel, yaka këŋo Labaŋ: «Ɓëniy ɓënjongëɓëki këmi riyenin në end napul ir Raŝel, endënaw̃ emejanak endeƴ eŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ata re ko Labaŋ: «Ɗek yek, wëj fecan ke mi yël gë mo yël aŝëxen, ɓayil gër ndam ro!» ");
INSERT INTO bsc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Mondako riyeni baxo Yakob ɓëniy ɓënjongëɓëki eŋo ñëraxën Raŝel. Ɓëniy ɓënjongëɓëki ɓëŋo er hi bax ang ɓakey ɓapënëfëne fo gayik axuri xuri bax ang h̃an këŋo Raŝel ak. ");
INSERT INTO bsc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ga xucak ɓëniy ɓëŋo, Yakob fel këŋo Labaŋ: «Maŝële ngwa asoxari aram an, ga h̃ata këme ako ɓëniy ɓënd wëlër baxe mi diyenin ɓëŋ, anëka ỹandi ke mi ɓar angaw̃ amat!» ");
INSERT INTO bsc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ata Labaŋ felëra këɓi ɗek ɓëraketa ɓën, do ri ko ofëna or ekana ol. ");
INSERT INTO bsc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Apenëka aŋ w̃eɗ këŋo Leya, endënaw̃ ekarënak endexëm eŋ, do w̃ëlan këŋo Yakob. Ga xana këŋo, ɓar këni angaw̃ amat. ");
INSERT INTO bsc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labaŋ w̃ëlali këŋo gër eñër, Silëpa, xaɗëp isoxari irexëm in hi ko xaɗëp ir aɓiw̃ Leya. ");
INSERT INTO bsc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ga xeyëk, Yakob wat ko mëne Leya ỹër këŋo. Ata w̃ëka këŋo Labaŋ: «Inew̃a rixën këƴe eŋo? Ax gi ex na nde në end Raŝel riyenin këmi? Inecëŋ yifaxën këƴe?» ");
INSERT INTO bsc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Yaka ko Labaŋ: «Ax ỹap ex na gër ndeɓi ro eno ñërët endënaw̃ emejanak eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ŋatayin gë Leya loxo ir ekana in, eƴo kanaxën ɓëte Raŝel. Ɓarikan afo eƴ di ɓëte gër ndam ro ɓëniy ɓënjongëɓëki ɓëcëxe.» ");
INSERT INTO bsc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ata Yakob ri ko mondako, h̃ata këni loxo ir ekana in gë Leya. Labaŋ w̃aŝ këŋo aɓiw̃ Raŝel. ");
INSERT INTO bsc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labaŋ w̃ëlali këŋo gër eñër, Bila, xaɗëp isoxari irexëm in, hi ko xaɗëp ir Raŝel. ");
INSERT INTO bsc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakob ɓar këni ɓëte angaw̃ amat gë Raŝel gayik mëŋ ex asoxari ar h̃an baŋo nëmëc Leya an. Riyeni ko ɓëte na gër Labaŋ ɓëniy ɓënjongëɓëki ɓëcëxe. ");
INSERT INTO bsc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Axwën Kaxanu wat ko mëne Yakob aŋo ŋan ex na Leya ang h̃an këŋo Raŝel ak. Ri këŋo Leya asoxari ar kë rëw̃ënd, do Raŝel, asoxari aɓoroxok. ");
INSERT INTO bsc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya hi ko gë acël. Rëw̃ këŋo itoŝan, w̃ac këŋo Ruben, mëne ngëŋ «Nëkoyino asëñiw̃ën». Gayikwa mondako baxo rend: «Axwën Kaxanu awat wat ko oŝëfën oram ol. Gërëgako ah̃an ke h̃an icën indam iŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leya hi ko ɓëte gë acël, rëw̃ këŋo itoŝan. Re ko: «Axwën Kaxanu awël awël ko mëne icën indam iŋ axe ŋan ex na, ɓarikan yël ke ɓëte itoŝan iŋo ro.» Ata w̃ac këŋo Simewoŋ, mëne ngëŋ «Awël». ");
INSERT INTO bsc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hi ko ɓëte gë acël, rëw̃ këŋo ɓëte itoŝan. Re ko: «Dodo gërëgako, icën indam iŋ monëka ke lëka, gayikako ɓëtoŝan ɓëtas rëw̃ën këmo.» Mëŋ w̃acaxën këŋo Lewi, mëne ngëŋ «Alëka». ");
INSERT INTO bsc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Hi ko ɓëte gë acël, rëw̃ këŋo itoŝan. Ata ŝëkwa këŋo Kaxanu mondako: «Aŋo cëŋ Axwën Kaxanu këmo ŝëkwa.» Mëŋ w̃acaxën këŋo Yuda, mëne ngëŋ «Aŝëkwa». Ata Leya seɓ ko orëw̃ ol. ");
INSERT INTO bsc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raŝel wat ko mëne itox aŋo dëw̃ën ex na Yakob, ƴakëraxi këŋo end aɓinëm Leya eŋ. Ata Raŝel fel këŋo Yakob: «Cotënële fa oɓaŝ, angëmëne ax gi ex na mondako aŝës këme ŝës!» ");
INSERT INTO bsc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ata Yakob ga xoỹën këŋo Raŝel, re ko: «Ba wëno nde ex Kaxanu, mëŋ ar lëc ki oɓaŝ an?» ");
INSERT INTO bsc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Yaka ko Raŝel: «Awa nëkoɗo Bila, xaɗëp isoxari iram in, ɓarin angaw̃ amat exo dëw̃axën gër olëkëna oram. Paɓ gë mëŋ këme hi wëno ɓëte ar gë oɓaŝ!» ");
INSERT INTO bsc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ata Raŝel mondako ỹërëndër baɓi Yakob do gë Bila, xaɗëp isoxari irexëm in. Yakob do gë Bila, ata ɓar këni angaw̃ amat. ");
INSERT INTO bsc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila hi ko gë acël, do rëw̃ën këŋo itoŝan Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ata re ko Raŝel: «Kaxanu w̃aŝan ke. Aɓaxët ɓaxët ke do yël ke itoŝan.» Mëŋ w̃acaxën baŋo asëñiw̃ Dan, mëne ngëŋ «Kiti». ");
INSERT INTO bsc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila, xaɗëp isoxari ir Raŝel in, hi ko ɓëte gë acël, do rëw̃ën këŋo Yakob itoŝan ikinëm. ");
INSERT INTO bsc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Re ko ɓëte Raŝel: «Mbaŋ xaxër këmi gë aɓaỹe Leya, do anëka xor këmo.» Raŝel w̃ac këŋo itoŝan iŋo Nefëtali, mëne ngëŋ «Okaxër». ");
INSERT INTO bsc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya ga wata ko mëne anëka seɓ ko orëw̃ ol, w̃eɗ këŋo Silëpa, xaɗëp isoxari irexëm in, do ỹërëndër këɓi gë Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silëpa, xaɗëp isoxari ir Leya in, rëw̃ën këŋo mëŋ ɓëte itoŝan Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ata re ko Leya: «Oko oyekax olo!» Ata w̃ac këŋo Gad, mëne ngëŋ «Oyekax». ");
INSERT INTO bsc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silëpa, xaɗëp isoxari ir Leya in, rëw̃ën këŋo ɓëte Yakob itoŝan ikinëm. ");
INSERT INTO bsc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Re ko ɓëte Leya: «Oko onënga oram olo! Odënaw̃ ok kë ỹana exe macënd asoxari ar gë onënga!» W̃ac këŋo itoŝan iŋo Aser, mëne ngëŋ «Onënga». ");
INSERT INTO bsc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Amëd and bani xanarand bële aŋ, Ruben ƴe ko gër oŝënga. Ga ŝanan ko andës and bani rind ɓëŝan ɓër ɓësoxari do këni w̃acënd mandëragor aŋ, w̃ëlanëgu këŋo nëm Leya. Ata Raŝel fel këŋo Leya: «Cetële wa mandëragor ir w̃ëlanëgu ki asëñix in.» ");
INSERT INTO bsc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Yaka këŋo: «Axi gi ex na nde gwac ga xan këƴe icën indam iŋ, do ỹandi ki ɓëte mandëragor ir w̃ëlanëgu ke itox indam in.» Ata yaka ko Raŝel: «Awa doro gë wëj këŋun xey, end mandëragor ir asëñix eŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Apenëka aŋ, Yakob ga xaniw ko gër apuỹ ko w̃aỹiwënd. Leya ga xaca këŋo, re ko: «Awa doro gë wëno këɓo xey ɗe. Ayëc yëc këmi gë mandëragor ir asëñiw̃ën in.» Ata gëmëɗ ijo, Yakob do gë Leya ɓar këni angaw̃ amat. ");
INSERT INTO bsc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kaxanu ga yakali këŋo Leya, hi ko gë acël, do rëw̃ën këŋo Yakob itoŝan injoxën iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ata re ko Leya: «Kaxanu ŝos ke, wëno ar ỹërëndër këɓi icën indam iŋ gë xaɗëp isoxari iram an.» W̃ac këŋo itoŝan iŋo Isakar, mëne ngëŋ «Acosa». ");
INSERT INTO bsc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya hi ko ɓëte gë acël, rëw̃ën këŋo Yakob itoŝan injongimatën iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ata re ko Leya: «Kaxanu fupa ke. Dodo aŋo cëŋ, icën indam iŋ afëɓ ke fëɓ, gayik ɓëtoŝan ɓënjongimat rëw̃ën këmo.» W̃ac këŋo itoŝan iŋo Sabuloŋ, mëne ngëŋ «Afëɓ». ");
INSERT INTO bsc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ga xucak eŋo, Leya rëw̃ këŋo ɓëte itoxari do w̃ac këŋo Dina. ");
INSERT INTO bsc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kaxanu xwita këŋo Raŝel, do yakali këŋo cale iŋ. Ata Raŝel hi ko ar kë xor exo dëw̃. ");
INSERT INTO bsc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hi ko gë acël, do rëw̃ këŋo itoŝan. Ata re ko: «Kaxanu anëka rëxët ko oŝëfën oram ol.» ");
INSERT INTO bsc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","W̃ac këŋo itoŝan iŋo Yosef mëne ngëŋ «Aɓaŝa», ga baxo rend: «Axwën Kaxanu ɓaŝëlexe wa itox icëxe!» ");
INSERT INTO bsc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","And rëw̃ këŋo Raŝel Yosef aŋ, Yakob fel këŋo Labaŋ: «Teɓële ngwa me ƴe, me maỹi gër ndeɓi, gër ebar edam. ");
INSERT INTO bsc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Maŝële ɓësoxari ɓëram ɓën, do gë oɓaŝ oram ol me ƴexën gayik në endeɓën riyenin këmi: wëj dëŋ anang nang këƴ ang riyenin këmi ak.» ");
INSERT INTO bsc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ata re ko Labaŋ: «Axara xara këmi ɓayil ro, wëj ex oyekax oram ol. Ɓangoc ɓandam ɓaŋ fel ke mëne Axwën Kaxanu në endeƴ yëlaxën ke oɓetak ol.» ");
INSERT INTO bsc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ɓaŝ ko ɓëte: «Deƴal ba ine kë hi acosa andeƴ aŋ, mi yëlaxënënd.» ");
INSERT INTO bsc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaka ko Yakob: «Wëj dëŋ anang nang këƴ ang riyenin këmi ak, do ang ŝëna këni oyel oreƴ gër otaxan odam ak. ");
INSERT INTO bsc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Gayikwa oyel ofënëpëne or ŝot baƴëɓi and h̃atëgu këme ol, mbaŋ ŝëna këni. Axwën Kaxanu yël ki oɓetak ol elod yatir wëñ këme gër yangana ireƴ ro. Gërëgako nand fe këme ri andiyen andam dëŋ?» ");
INSERT INTO bsc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","W̃ëka ko Labaŋ: «Ine ỹapëk mi yël?» Yaka ko Yakob: «Ỹoweỹ aƴe yël na. Angëmëne aw̃a w̃a këƴ er këmi fel in, aɓakan këme ɓakan oxaɗac or oɓeci oreƴ do gë opeỹ odeƴ ol, axaɗac këmëni xaɗac. ");
INSERT INTO bsc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Doro këme ƴe gër ed exëni ɗek oɓeci oreƴ ol do gë opeỹ odeƴ ok. Pitëlëɓi oɓeci or ỹër-ỹër ol do gë opeỹ od gë ɓambaren ok. Ɓën kë hi acosa andam aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Or ŝenene oram ol ecan kë ŝanaya, and këƴ ƴeli eƴ wat acosa andam aŋ. Emeci end këƴo sëk axo gi ex na ỹër-ỹër yo, areka reka këmo. Ɓëte ifeỹ ir këƴo sëk axo gi ex na gë ɓambaren yo, areka reka këmo.» ");
INSERT INTO bsc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labaŋ re ko: «Awa aw̃a w̃a këme er re këƴ in!» ");
INSERT INTO bsc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ata kwël yatijo fo, fit baɓi Yakob ɗek ɓapëlang ɓand ỹër-ỹër ɓaŋ, gë oɓeci onëm or ỹër-ỹër ol, gë ɗek oɓeci or gë ɓapeŝen ol, do gë ɗek opeỹ od gë ɓambaren ok. Seɓ këɓi gër otaxan od ɓosëñiw̃ enëɓi kaɗacërand pit. ");
INSERT INTO bsc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","H̃awëtali kënëɓi gë mëŋ Yakob në oñe ond ɓamëɗëna ɓatas. Yakob mëŋ këɓi xaɗacërand oɓeci ol do gë opeỹ od ɓayi baŋo Labaŋ ok. ");
INSERT INTO bsc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ata Yakob saw̃ëgu ko ɓënini ɓëcëkët ɓënd aces, gë ɓënd angërëŝa, do gë ɓënd anjang. Xopëtëra ko daɗët daɗët xali kë watind ɓëpeŝen ɓëpeŝen. ");
INSERT INTO bsc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ata ga xoƴ ko oƴand ok gër ed këni ŝeɓënd oɓeci, mar ɓayik wat-wat gër ogës od oɓeci or bax xerarënd gër eceɓ ed men. ");
INSERT INTO bsc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mondako bani xerarënd ler gër ɓënini ɓëŋo. Ata rëw̃ kënëɓi ɓëmeci ɓënd ỹër-ỹër, ɓënd gë ɓambaren, do gë ɓënd gë ɓapeŝen. ");
INSERT INTO bsc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Opeỹ ok cëŋ, Yakob aŝapëreli ŝapëreli baɓi gë oɓeci ol. Do and këɓi ỹandi opeỹ onëm enëɓi kera aŋ fo baɓi sëkalind Yakob okondo od ỹër-ỹër ok, do gë od gë ɓambaren ok. Ata onëm ok rëw̃ kënëɓi ɓënoɓo ɓënd ỹër-ỹër do gë ɓënd gë ɓambaren. Mondako ɓaŝa baɓi Yakob ɓenga ɓend oyel or xwën këɓi ol, do abaɓi ɓar na gë oyel or Labaŋ ol. ");
INSERT INTO bsc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ata Yakob, and këni xerarënd oyel oɓëtëk aŋ fo baxo xoƴënd ɓënini ɓënd xopëtëra baxo daɗët daɗët ɓëŋ, eni wataxënënd. ");
INSERT INTO bsc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ɓarikan and këni xerarënd oyel ofiŝëk aŋ, abaxo xoƴ na. Oyel ofiŝëk ol ɓayi këno Labaŋ, do oɓëtëk ol xwën këɓi Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mondako ŝotëra baxo Yakob napul isëm xali hi ko ar gë opeỹ odanjëm, gë oɓeci oranjëm, gë ogelemba do gë opali odanjëm. Hi ko ɓëte axwën ar okaɗëp otoxari do gë otoŝan odanjëm. ");
INSERT INTO bsc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Akey amat, Yakob wël këɓi oɓaŝ or Labaŋ ol ga këni re: «Yakob w̃eɗek ɗek ɓeɓër xwën baxo faba ireɓi ɓën. Gë ɓeɓër xwën baxo faba ireɓi ɓën ŝotëraxën ko ɗek napul ijo.» ");
INSERT INTO bsc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob wata ko mëne Labaŋ ax bo ex na ga këŋo nëkon gë dëxas iyekax, ang gër ỹanar ak. ");
INSERT INTO bsc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ata Axwën Kaxanu fel këŋo Yakob: «Maỹil ngëŋ gër ebar ed ɓëxarëk ɓëreƴ, gër ed rëw̃ këni. Wëno gë wëj këme hi.» ");
INSERT INTO bsc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakob w̃ac këɓi Raŝel do gë Leya sëkëx këno gër apuỹ, gër ed baɓi xaɗacërand oɓeci do gë opeỹ odexëm. ");
INSERT INTO bsc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Fel këɓi: «Wëno anëka wata këme mëne sorix irewën ax bo ex na ga ke nëkon gë dëxas iyekax, ang gër ỹanar ak. Ɓarikan Kaxanu, mëŋ ar yata këŋo faba iram an, gë wëno hi ko. ");
INSERT INTO bsc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Anang nang kën wën dëŋ mëne mbaŋ riyenin këmo sorix irewën, gë oxor oram ol ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ɓarikan sorix axacërara xacërara këŋo exe ƴamba. Ɓakëlëbëd epëxw nëngwët ko acosa andam aŋ, ɓari Kaxanu aŋo teɓ ex na exe ƴambara. ");
INSERT INTO bsc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","And re ko: “Oyel or gë ɓapeŝen do gë ɓambaren ol kë hi acosa andeƴ aŋ”, onëm ol ɗek kënëɓi rëw̃ënd ɓënoɓo ɓënd gë ɓapeŝen do gë ɓambaren. Ɓëte and re ko: “Oyel or ỹër-ỹër ol kë hi acosa andeƴ aŋ”, onëm ol ɗek kënëɓi rëw̃ënd ɓënoɓo ɓënd ỹër-ỹër. ");
INSERT INTO bsc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kaxanu xan këŋo sorix irewën oyel orexëm ol, do yël ke wëno. ");
INSERT INTO bsc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Awat wat bamëni gëmëɗ në lakeli oyel onëm ol, amëd and baɓi ỹandind enëɓi kera aŋ. Okondo ok kënëɓi xerand opeỹ onëm ok: oko od gë ɓapeŝen do gë ɓambaren, oko od ỹër-ỹër. Opëlang ok kënëɓi xerand oɓeci onëm ol: oko od gë ɓapeŝen do gë ɓambaren, oko od ỹër-ỹër. ");
INSERT INTO bsc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ata kwël gër lakeli fo w̃ac ke meleka ir Kaxanu in: “Yakob!” Yaka këmo: “Woy!” ");
INSERT INTO bsc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Re ko: “Këla, dënëtal eƴëɓi nëkon ɗek okondo od këɓi xerand opeỹ onëm ok, do gë opëlang od këɓi xerand oɓeci onëm ok. Er exëni oko od gë ɓapeŝen do gë ɓambaren, oko od ỹër-ỹër. Gayikwa awat wat këme ang ƴambara ki Labaŋ ak. ");
INSERT INTO bsc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Wëno ex Kaxanu, ar ŝalew këƴo gë eɓeƴa gër Bet-El, gër ed rëɗ këƴ ekaỹ do xoŝ këƴ ogu an. Gërëgako, canël ebar elo ro, eƴ maỹixën gër ebar ed gër ed rëw̃ këni.”» ");
INSERT INTO bsc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raŝel do gë Leya yaka këno: «Ɓiyi cëŋ gër iciw̃ ind faba ireɓi, er këmi ɓëteli aɓo bo ex na. ");
INSERT INTO bsc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ang ɓëliyer fo hi këmi gayikako anëka fan këɓo xali ƴamb ko napul ir ŝotaxën këɓo in. ");
INSERT INTO bsc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ɗek napul ir xana ko Kaxanu gër faba ireɓi in, ɓiyi do gë oɓaŝ oreɓi ol xwënëk. Gërëgako, dil ɗek er fel ki Kaxanu in.» ");
INSERT INTO bsc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ata Yakob fërëƴëtali këɓi ɓolindaw̃ do gë oɓaŝ orexëm ol ƴaŋ gër ogelemba. ");
INSERT INTO bsc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ɓar këɓi ɗek oyel orexëm or ŝot baɓi na gër ebar ed Padaŋ-Aram ol, do gë ɗek ɓacota ɓandexëm ɓaŋ, do kwël ko ɓakand ond gër sëm Isak oŋ, gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Yatijo ƴe baxo Labaŋ gër ekaca ed omban ond opeỹ odexëm. Raŝel reka këŋo atox and ebax eɗaŝ ed sëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ata Yakob mondako sitinaxën baŋo Labaŋ, arandëw̃ëra and Aram an, ga ko w̃aỹi pelarëxe. ");
INSERT INTO bsc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Monaw̃a naw̃a baŋo, do kwël ƴe ko gë ɗek ɓeɓër xwën baxo ɓën. Ga xegëta ko yeɓ in, faɓ ko gand osënd or ebar ed Galahad. ");
INSERT INTO bsc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ga xucak ɓakey ɓatas, fel këno Labaŋ mëne Yakob anëka naw̃a këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labaŋ ga ɓar këɓi ɓër ekun edexëm ɓën, sëf këno Yakob. Ƴe këni ɓakey ɓanjongëɓaki ɗamana sëkaxën këno gër osënd or ebar ed Galahad. ");
INSERT INTO bsc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ɓarikan Kaxanu ŝanayaxën këŋo gëmëɗ në lakeli Labaŋ arandëw̃ëra and Aram an, ɗamana eni paɓëraxën gë Yakob. Fel këŋo: «Këreƴëŋo dexëraɗ na ɗe Yakob.» ");
INSERT INTO bsc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","And h̃at ko Labaŋ gër ebar ed Galahad aŋ, sëkëx këŋo Yakob kap gër etënd, gër ed ri baxo akwëndaya andexëm. Labaŋ do gë ɓër laŋëtaw baŋo ɓën ri këni ɓën ɓëte ler na fo akwëndaya andeɓën aŋ, gër osënd or gër ebar ed Galahad. ");
INSERT INTO bsc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ata Labaŋ w̃ëka këŋo Yakob: «Inew̃a ri këƴ? Asitinaxën sitinaxën këƴe do w̃ëlaw këƴëɓi odënaw̃ odam ok ang ɓësoxari ɓër sëraw këƴëɓi në emer fo! ");
INSERT INTO bsc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Inew̃a naw̃axënëgu këƴe do hërëgu këƴ, pelarëxe? Kido afela felaw baƴe, wëno ata ri dome ofëna or mi pelaraxën gë odënaw̃ odam ok, do ɓela ɓën eni ñëw̃ëra ojëkan od onënga, gë ɓatëmb ɓaŋ, do gë ofarix ol. ");
INSERT INTO bsc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ɓarikan, wëj aƴe teɓ ex na mi pelar momegar gë ŝaca ɓën do gë odënaw̃ odam ok! Ata ang aŝenëk fo ri këƴ ɗe. ");
INSERT INTO bsc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Axor xor këme mun denan eñëŋënax, ɓarikan Kaxanu, mëŋ ar yata këŋo sorix an, fel ke ganëka gëmëɗ: “Këreƴëŋo dexëraɗ na ɗe Yakob!” ");
INSERT INTO bsc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Gërëgako, ga ƴow këƴ or laŋ gayik mbaŋ xofi baxi ekun ed sorix el, ine cëŋ rekaxënëgu këƴ eɗaŝ edam el?» ");
INSERT INTO bsc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob yaka këŋo Labaŋ: «Ayëdara yëdara bame ga bame yëland mëne axan këƴe xan odënaw̃ odeƴ ok. ");
INSERT INTO bsc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ɓarikan end eɗaŝ edeƴ eŋ cëŋ, gër ar këƴ sëk yo, ar ecës ex! Ɓela ɓëreɓi ɓëjo ex ngëŋ otede ok, calal er xwën këƴ in gër akwëndaya andam. Ga wat wat këƴ, kanal!» Yakob axo nang bana mëne Raŝel rekawëk eɗaŝ elo. ");
INSERT INTO bsc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labaŋ lil ko gër aner and Yakob, ɓëte gër and Leya, do gër and okaɗëp otoxari oki, ỹoweỹ axo wat ex na. Ga ŝanëgu ko gër aner and Leya, lil ko gër and Raŝel. ");
INSERT INTO bsc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raŝel w̃eɗ ko eɗaŝ el, lilali ko gër añëmëna and gelemba, do ỹëpaxën ko. Labaŋ xëɓëtëra ko ɗek aner aŋ, ɓari ỹoweỹ axo wat ex na. ");
INSERT INTO bsc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ata Raŝel fel këŋo sëm: «Faba ga wat këƴ ame kani ex na mi pëɓaxën, këreƴ koỹ na, gë apacaw̃ aŋ hi këme.» Aŝalara yo aŝalara, Labaŋ axo wat ex na eɗaŝ edexëm el. ");
INSERT INTO bsc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ata Yakob logën këŋo. Ga këŋo xeỹan Labaŋ, re ko: «Ine ex amena andam aŋ? Eñëŋënax end fe wa ri këme, sëfaxënëgu këƴe gë oxoỹ or go olo? ");
INSERT INTO bsc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","And yëlëxëƴëtëra këƴ ɗek oỹënga oram aŋ, er xwën këƴ nde wat këƴ na? Masinëlëɓi ɓëram ɓën do gë ɓëreƴ ɓën enëɓo dëcaxën ɓiyi ɓëxi! ");
INSERT INTO bsc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ɓëniy alapem ri këme gër iciw̃ indeƴ. Elod ami pel ex na mëne emeci enëm endeƴ, ba ifeỹ inëm ireƴ nacëk. Ɓëte elod amo ƴamb ex na xondo ireƴ. ");
INSERT INTO bsc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ejel ed law̃ këno ow̃acar oɓapuỹ el, elod amo maỹelil ex na. Wëno baŋo nëmbënd gë ejel eɓëngw edam. Wëj anëỹali baƴe nëỹalind mi maŝën ejel ed reka këne hik gëmëɗ, hik goyat el. ");
INSERT INTO bsc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aŝor baxe ŝorënd oyat ok, mbaŋ bame sorond gë aƴem in gëmëɗ, do akwëɗ abame ŝot na. ");
INSERT INTO bsc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ɓëniy alapem ri këme gër iciw̃ indeƴ. Riyenin këmi ɓëniy epëxw gë ɓënax në end napul ir odënaw̃ oki odeƴ eŋ. Ɓëniy ɓënjongimat mëni cotaxën oɓeci oram ol do gë opeỹ odam ok. Ɓarikan wëj nëmbët këƴ ɓakëlëbëd epëxw acosa andam aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kido Kaxanu, mëŋ ar yata këŋo ŝaca iram Abëraxam an, mëŋ ar baŋo rëgënd faba iram Isak an, axe dëca bana, taxan ŝanëgu dome iciw̃ indeƴ iŋ. Kaxanu awat wat ko toro indam iŋ, do gë asëkwëra iram in, do ganëka gëmëɗ mëŋ rëc këɓo.» ");
INSERT INTO bsc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labaŋ yaka këŋo Yakob: «Ɓolindax, odënaw̃ odam ex, oɓaŝ olo, oɓaŝ oram ex, oyel olo, oyel oram ex, do ɗek er këƴ watënd in, wëno xwënëk. Wëno ine këme xor mëni din doro odënaw̃ odam ok, ba oɓaŝ or rëw̃ kënëɓi ol? ");
INSERT INTO bsc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Gërëgako awël nde, yatare eter wëno gë wëj, do eter elo gilex sede ireɓi in!» ");
INSERT INTO bsc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ata Yakob w̃eɗ ko ekaỹ do rëɗ ko. ");
INSERT INTO bsc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ga xucak eŋo, Yakob fel këɓi ɓër ekun edexëm ɓën: «Meɗanëgune oxaỹ.» Ata w̃eɗaraw këni oxaỹ do ɓun këni. Mëŋ gë Labaŋ ƴambëra këni na gër angëɓ and oxaỹ. ");
INSERT INTO bsc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labaŋ w̃ac ko angëɓ aŋo «Yegar Saxaduta», do Yakob mëŋ w̃ac ko «Galehed». ");
INSERT INTO bsc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ata re ko Labaŋ: «Angëɓ and oxaỹ aŋo ex doro sede ir wëj gë wëno in!» Mëŋ ɓayixënëk omac od «Galehed», mëne ngëŋ «Angëɓ and ex sede aŋ», ");
INSERT INTO bsc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","do «Mitësëpa», mëne ngëŋ «Angëɓ and enëkona», gayik Labaŋ are re baxo: «Axwën Kaxanu nëkonaleɓo and ke ŝapëre ro aŋ! ");
INSERT INTO bsc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Angëmëne arixëra këƴëɓi rixërand odënaw̃ odam ok, angëmëne ɓësoxari ɓëŝëxe ɓaŝa këƴëɓi na, ax gi ex na gë ala kën faɓër. Titinal, Kaxanu ex sede ir ɓiyi ɓëxi in.» ");
INSERT INTO bsc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ata Labaŋ fel këŋo Yakob: «Eɓun ed oxaỹ elo, ekaỹ ed xwëŝak elo, wëno rëɗëk mërëxand ir ɓiyi ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Eɓun ed oxaỹ elo do gë ekaỹ ed xwëŝan këme elo, ex otede odeɓi ok: ame kucali na oxaỹ oŋo, me ƴeli gand ed hi këƴ mi dinanaxën eñëŋënax. Do wëj ɓëte aƴ kucagu na oxaỹ oŋo, eƴ ƴeli gand ed hi këme eƴe dinanaxën eñëŋënax. ");
INSERT INTO bsc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kaxanu, mëŋ ar yata këɓi Abëraxam do gë Naxor an, gilexo arëc areɓi an (mëŋ ex Kaxanu, ar yata këŋo axarëk areɓën an).» Ata Yakob yaŝar ko gër ow̃ac or Ar ko rëgaxënënd sëm Isak ol. ");
INSERT INTO bsc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ga xucak eŋo, Yakob ri ko ŝaɗaxa na gër etënd elo. W̃ac këɓi ɓërexëm ɓën gër eƴambëran. Ƴambëra këni do xey këɓi na gër etënd elo. ");
INSERT INTO bsc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ga xeyëk, Labaŋ xani ko mopëɗ, felarëra këni momegar gë ejiw̃ ɓën do gë ɓoɓiw̃. Ga ŝalendëra këɓi, xani ko do kwël w̃aỹi ko gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakob fakët ko fëña irexëm in. Ata ŝanayaxën këno omeleka od Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ga wat këɓi, Yakob re ko: «Ɓëjo ɓër enga end Kaxanu exëni!» W̃ac ko na gër ed ebani «Mahanayim», mëne ngëŋ «Ɓenga ɓeki ɓeŋ». ");
INSERT INTO bsc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob lëngwali këɓi ɓërolaw̃ën gër aɓinëm Esawu, gër Seyir, gër ebar ed Edom. ");
INSERT INTO bsc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Er re baxo: «Mondako këno felëx, Esawu, axwën aram an: “Yakob, xaɗëp ireƴ in, ga re ko: aniyitara niyitaraw ke gër Labaŋ ɓën, ang aliyer fo, do alembeliw lembeliw ke oliyer oram ol xali gërëgako. ");
INSERT INTO bsc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Aŝotëgu ŝotëgu këmëni ɗe oxeƴ, gë opali, gë opeỹ, gë oɓeci, gë okaɗëp otoŝan do gë otoxari. Awa axwën, ɓër ƴelik ɓëjo, ɓërolaw̃ën ɓëram exëni. Wëno law̃ënëli këɓi ga këme yarënd oyekax oreƴ ol, exe kofëtaraxëne.”» ");
INSERT INTO bsc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ɓërolaw̃ën ɓën ga ɓakaw këni fel këno Yakob: «Aƴe ƴe këmi xali gër aɓinëx Esawu. Në ekacaw exi mëŋ ɓëte gë ocambenjar okeme onax.» ");
INSERT INTO bsc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ata Yakob yëdara ko mbaŋ, anjiỹ aŋ xap këŋo mokap dëŋ. Ŝapëreli këɓi ɓela ɓërexëm ɓën ɓenga ɓeki. Mondako fo ŝapëreli baɓi ɓëte oyel ol: opeỹ ok do gë oɓeci ol beɓët iɓat, oxeƴ ol do ogelemba ok beɓët ijo. ");
INSERT INTO bsc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Er baxo rend: «Angëmëne Esawu eɓi ŋw̃ëlën enga emat do eɓi kor, enga ekinëm eŋ aŝana këno ŝana.» ");
INSERT INTO bsc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ata Yakob ko ŝalend mondako: «Axwën Kaxanu, wëj ex ar yata këŋo ŝaca Abëraxam an, ɓëte wëj fo yata këŋo Isak, faba iram. Wëj ex ar fel ke: “Ɓakal gër ebar edeƴ, gër ed rëw̃ këni, do wëno arin këmi rin enjekax eŋ!” ");
INSERT INTO bsc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Emëlaya ed w̃ëlaya këƴe wëno xaɗëp ireƴ el axuri xurik. Ɓëte ɓenjekax ɓend rin këƴe ɓeŋ, axe ñap ex na. And xegëta bame Yurëdeŋ ijo aŋ, oŝët fo lëkaya bame. Ɓarikan doro ɓëram ɓën ɓenga ɓeki exëni. ");
INSERT INTO bsc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Axara xara këmi dacëtële gër otaxan od aɓaỹe Esawu! Gayikwa ayëda këme yëdand ba aƴow ko ƴow exe mereli, eɓi ɗaw̃ëra ɓësoxari ɓën, do gë oɓaŝ ol. ");
INSERT INTO bsc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Wëj ga fel ke wa: “Arin këmi rin enjekax eŋ, do aŝënan këme ŝënan andëw̃ëra andeƴ aŋ ang eɗini ed gër angwëngw fo, ed ala ax kor na exo pën el!”» ");
INSERT INTO bsc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ata yatijo, na xey baŋo Yakob. Sana këɓi gër napul ir ŝot baxo, oyel or këŋo fupaxën aɓinëm Esawu ol. ");
INSERT INTO bsc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Sana këɓi oɓeci onëm okeme oki, do gë ɓapëlang alapem; opeỹ onëm okeme oki, do gë okondo alapem. ");
INSERT INTO bsc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Sana këɓi ɓëte ogelemba onëm ofëxw osas, gë ɓatox ɓand banëɓi yerinënd ak; oxeƴ onëm ofëxw onax, do gë okwëlëkwël epëxw; opali onëm alapem, do ocan ok epëxw. ");
INSERT INTO bsc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Mondako fitëra baɓi oyel olo ɓenga ɓenga, do enga kala gë axaɗac arexëm. Fel këɓi ɓëxaɗac ɓën: «Ɗëngwayin tan, do en teɓëtar moteɓëtar.» ");
INSERT INTO bsc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Fel këŋo axaɗac aỹanar an: «And kën fed gë aɓaỹe Esawu aŋ do exi mëka: “Noỹo xwën ki? Feye këƴ ƴend? Noỹo wa xwën këɓi ɗek oyel or lëngwëna këƴëɓi olo?” ");
INSERT INTO bsc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakayiɗo: “Yakob, xaɗëp ireƴ in, xwën këɓi. Axwën Esawu, er fupaxën ki lëngwaliw ko. Mëŋ dëŋ në etëfëgu eɓo.”» ");
INSERT INTO bsc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ata fel këɓi eŋo fo axaɗac axinëm an, gë asasën an, do gë ɗek ɓër baɓi sëfënd ɓenga ɓend oyel ɓën: «Mondako këno felëɗ Esawu, axwën aram an, and kën fed aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Deyiɗën: “Yakob, xaɗëp ireƴ in, gand emban ɓayiw ko”.» Gayikwa er baxo yëland: «Axoc këŋo xoc oxoỹ orexëm ol gë er fupaxën këmo do lëngwali këme in. Ɓamat aw̃a ko w̃a exe kaca, do mi kofëtar gë onënga fo!» ");
INSERT INTO bsc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ata Yakob mondako lëngwali baɓi oyel or fupaxën baŋo ol, do mëŋ xey këŋo na gër akwëndaya. ");
INSERT INTO bsc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ata yatijo gëmëɗ, Yakob gë ɓësoxari ɓëxi ɓërexëm ɓën, gë okaɗëp otoxari oki od ɓësoxari ɓërexëm ok, do gë ɓëtox epëxw gë imat ɓëndexëm ɓëŋ, xegëta këni lar ir këni w̃acënd Yabok in. ");
INSERT INTO bsc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Aɓar ɓar baɓi, xegëta këni lar in gë ɗek ɓeɓër xwën ko ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yakob ɓayi ko gaɓat ekeg elo. Ata ŝanayaw ko ala do xaxër këni gë mëŋ xali kë wecand. ");
INSERT INTO bsc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ala ajo ga wat ko mëne anëka dëŋ sëkwan këŋo eŋo ɗap in, xëm këŋo gër epem. Ata Yakob lonëta ko nand bani xaxërënd na. ");
INSERT INTO bsc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ata re ko ala ajo: «Teɓële me ƴe, gayikwa anëka kë wecand.» Yaka ko Yakob: «Ami teɓ na eƴ ƴe, xarak aƴe yël ex na oɓetak ol.» ");
INSERT INTO bsc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ala ajo w̃ëka këŋo: «Ake këni w̃acënd?» Yaka ko: «Yakob.» ");
INSERT INTO bsc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Re ko: «Macindëleni gërëgako Isërayel, kërex bo na ga këni w̃acënd Yakob. Gayikwa axaxër xaxër kën gë Kaxanu do gë ɓela ɓën, ɓarikan wëj xor këɓi.» ");
INSERT INTO bsc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakob w̃ëka këŋo: «Këla pelële wa ow̃ac oreƴ ol.» Yaka ko: «Ine këƴe w̃ëkaxënënd ow̃ac oram ol?» Ata yël këŋo oɓetak ol. ");
INSERT INTO bsc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakob w̃ac ko na gër ed xaxër bani «Peniyel», mëne ngëŋ «Dëxas ir Kaxanu in». Gayikwa are re baxo: «Afaɓër faɓër këmi gë Kaxanu, do ɓayi këme aɓëngw.» ");
INSERT INTO bsc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Eñan eŋ anëka bax fënëgund and baxo xucand Yakob Penuwel aŋ. Ata këŋo racëtënd oñe oŋ, ga lonëta ko gër epem. ");
INSERT INTO bsc_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Mëŋ ex xali doro, ɓërandëw̃ëra and Isërayel ɓën ani ƴakënd na angën and gër emef aŋ, gayik gër angën aŋo sembaỹ baxo Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakob ga rënëta ko, watëgu këɓi Esawu do gë ocambenjar okeme onax ok ga këni h̃atëgu. Ŝapëreli këɓi oɓaŝ ol, mar hi këni mërëxand ir Leya do gë Raŝel, mar mërëxand ir okaɗëp otoxari od ɓësoxari ɓërexëm ok. ");
INSERT INTO bsc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Lëngwën këɓi okaɗëp otoxari ok do gë oɓaŝ oreɓën ol. Ɓëtëgu këni Leya do gë oɓaŝ orexëm ol, do felata këni Raŝel do gë Yosef. ");
INSERT INTO bsc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakob mëŋ dëŋ, lëngw ko gër enga eŋo, do foxi ko ɓanjongëɓaki eƴiỹ el ŋëŝ gër ebar, xali sëkar këni gë aɓinëm. ");
INSERT INTO bsc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ata Esawu hër ko fed këni. W̃ega këŋo Yakob bëxiɓ gër egëla, do ses këni ɓën tak ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esawu ga rënëta ko, wat këɓi ɓësoxari ɓën do gë oɓaŝ ol. Ata w̃ëka ko: «Noɓën ex wa ɓëjo?» Yaka ko Yakob: «Ɓëjo ex oɓaŝ or yël ke Kaxanu ol gë oyekax orexëm ol, wëno xaɗëp ireƴ in.» ");
INSERT INTO bsc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Okaɗëp otoxari ok do gë oɓaŝ oreɓën ol sëka këno Esawu, do foxira këni. ");
INSERT INTO bsc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya do gë oɓaŝ orexëm ol sëka këno ɓëte, do foxira këni. Ɓëte Yosef do gë Raŝel sëka këno, do foxira këni. ");
INSERT INTO bsc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ata re ko Esawu: «Do ine ex wa ɗek oyel or fedëgu këmi olo?» Yaka ko Yakob: «Exe kofëtaraxëne gë onënga fo ŝet këmi, faba!» ");
INSERT INTO bsc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Re ko ɓëte Esawu: «Aɓaỹe, aŝotëra ŝotëra këme wëno ɓëte! Er xwën këƴ in, ɓayilexi.» ");
INSERT INTO bsc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaka ko Yakob: «Ali, axara xara këmi, kanal axana er fupa këmi in gayikako gë onënga fo xofëtar ke. Enimin, wëno ga ŝanaya këme gër lëngw ireƴ nangëde gër lëngw ir Kaxanu fo, do xofëtar ke gë onënga fo. ");
INSERT INTO bsc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Këla kanal axana er fupa këmi in, oyel oreƴ ex, gayikako gë oyekax orexëm ol yëlëra ke Kaxanu xali ŝotëra këme ɗek er ebax me cot in.» Yakob nëỹali këŋo Esawu xali w̃a ko. ");
INSERT INTO bsc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esawu re ko: «Awa meɗërane ɗek oỹënga oŋ ene ƴexëne, wëno kë lëngwa.» ");
INSERT INTO bsc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ata yaka ko Yakob: «Faba, anang nang këƴ mëne oɓaŝ ol ani kem ex na. Ɓëte nëkoɗëɓi opeỹ onëm ok, gë oɓeci onëm ol, do gë oxeƴ or gë ɓatox ɓand kë yerind ol. Angëmëne akey amat fo nëỹali kënëɓene oñe oŋ, ɗek këni ŝësëra oyel oɓeja ol. ");
INSERT INTO bsc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Axara xara këmi faba, ɗëngwal wëj. Endëmane endëmane këmi sëfëli wëno xaɗëp ireƴ in, gë oɓaŝ ol do gë oyel ol, xali mi ŋatëli gër ndewën, gër ebar ed Seyir.» ");
INSERT INTO bsc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ata re ko Esawu: «Awa ɓaxëtël mi teɓën ndakaŋ mar ocambenjar odam ok.» Yaka ko Yakob: «Oko në end ine ngwa? Faba, axara xara këmi, teɓanële din!» ");
INSERT INTO bsc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ata kwël yatijo fo, ɓaka baxo Esawu ond gër ebar ed Seyir oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ga xucak eŋo, Yakob ƴe ko kwël ond gër Sukot oŋ. Ɓaƴënayax ko ɓaciw̃, do rindëranëx këɓi ɓaner oyel orexëm ol. Mëŋ w̃acaxën këni fën gër ed hi bani «Sukot», mëne ngëŋ «Ɓaner ɓaŋ». ");
INSERT INTO bsc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ata Yakob mondako h̃at baxo aɓëngw ga xaniw ko gër ebar ed Padaŋ-Aram. H̃at ko gër angol and Siŝem, gër ebar ed Kanahaŋ. Ri ko akwëndaya andexëm aŋ ler gër angol aŋo. ");
INSERT INTO bsc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yakob w̃eɗ ko ɓatama këme ɓand koɗi do yëc ko ebar gër otaxan od ɓosëñiw̃ ɓor Amor, sëm ir Siŝem. Gër ebar elo ri baxo akwëndaya andexëm, ler gër angol and Siŝem. ");
INSERT INTO bsc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yakob ri ko na angëɓ and eŋo caleraxënënd Kaxanu, do w̃ac ko «El-Eloxe-Isërayel», mëne ngëŋ «Kaxanu, Kaxanu, mëŋ ar yata këŋo Isërayel an.» ");
INSERT INTO bsc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Akey amat, Dina endënaw̃ end rëw̃ën këno Leya Yakob eŋ, ƴe ko eɓi nangëgu odënaw̃ od gër ebar elo ok. ");
INSERT INTO bsc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ata Siŝem, asëñiw̃ ar Amor, emun end ebar ed ɓërandëw̃ëra and Het eŋ, wat këŋo Dina. Ga sëra këŋo, w̃ëla këŋo, do lakix këni, xarak ax ñap ex na. ");
INSERT INTO bsc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ata Siŝem lëka këŋo monëka dëŋ Dina, endënaw̃ end Yakob eŋ. Siŝem h̃an këŋo mbaŋ endënaw̃ emeja eŋo. Ɓend ko xwëtaya gër emëkw edexëm fo baŋo felënd endënaw̃ emeja eŋo. ");
INSERT INTO bsc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Siŝem fel këŋo sëm Amor: «Karanële endënaw̃ eŋo, wëno mo ñër ỹandi ke.» ");
INSERT INTO bsc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ata ga nang ko Yakob mëne Siŝem aɓuyarën ɓuyarën këŋo aɓiw̃ Dina, ŝësina ko ƴem xali h̃atëgu këni ɓosëñiw̃ ga hiw këni gër apuỹ, gër oxaɗac or oyel. ");
INSERT INTO bsc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ata Amor, sëm ir Siŝem, ƴow ko gër ed ebaxo Yakob eni ñëpaxën end Dina eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","And bani h̃atëgund ɓosëñiw̃ ɓor Yakob aŋ, ga hiw këni gër apuỹ, nang këni ecëfënaxik eŋo. Hi këɓi nangëde aŝirëra ŝirëra kënëɓi fo, do xoỹ këni xali xurik, gayik Siŝem amena atëm ri baxo paɓ gër ɓërandëw̃ëra and Isërayel, ga laki bani ako gë endënaw̃ end Yakob eŋ, xarak eŋo ax ñap ex na. ");
INSERT INTO bsc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amor fel këɓi: «Asëñiw̃ën Siŝem wa h̃an këŋo endënaw̃ endewën eŋ, yëlino eŋo ñër, axara xara këmun. ");
INSERT INTO bsc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Wën gë ɓiyi axor këne xore ene ɗëkëre paɓ gë oỹër oŋ. Wën enëɓo yëlënd odënaw̃ odewën ok, do enëɓi ñërënd odeɓi ok. ");
INSERT INTO bsc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Andamat këne lëge do ebar el edewën kë hi. Cëxwayayin ro, en pandërand, do en yëcënd owar or kën xwën.» ");
INSERT INTO bsc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siŝem ƴow ko fel këɓi sëm ir endënaw̃ do gë ɓoɓinëm: «Teɓanine! Wëno ayël këmun yël er këne w̃ëka yo. ");
INSERT INTO bsc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Pënëtayin mbaŋ napul ir këmun w̃eɗën in, do gë exëɓënaxik er këmun yël in. Ayël këmun yël er këne w̃ëka yo. Ɓarikan fo, yëline endënaw̃ eŋ mo ñër!» ");
INSERT INTO bsc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ɓosëñiw̃ ɓor Yakob yaka kënëɓi gë osit Siŝem do gë Amor, sëm irexëm, gayik Siŝem aɓuyarën ɓuyarën baŋo Dina, imaỹe itoxari indeɓën iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Fel kënëɓi: «Ax mënd ex na mo yël imaỹe itoxari indeɓi iŋ asoŝan axacërëx: oŝëfën osëm ex eŋo gër enëng endeɓi! ");
INSERT INTO bsc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ɗamana mi maxën end re kën eŋo, afo en ma pere en gi ang ɓiyi ak: asoŝan ar ex yo eno kac axac. ");
INSERT INTO bsc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Aŋo fo këmun yël odënaw̃ odeɓi ok, do ɓiyi ɓëte mëni ñërënd odewën ok. Ata këne lëge në ereɓat, do ene giye ɓulunda iɓat. ");
INSERT INTO bsc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ɓiyi ata këmo w̃eɗ endënaw̃ endeɓi eŋ, do kwël mi dëfa angëmëne anëɓo ɓaxët ex na, angëmëne an ma ex na enun kacënd axac.» ");
INSERT INTO bsc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amor do gë asëñiw̃ Siŝem w̃a këni eyeƴan elo. ");
INSERT INTO bsc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ataŋ ŝambenjar in w̃a ko exo di mondako gayik mbaŋ h̃an baŋo endënaw̃ end Yakob eŋ. Xarak Siŝem, ar gapak ebaxo gër ɗek ekun ed sëm. ");
INSERT INTO bsc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ata Amor do gë asëñiw̃ Siŝem ƴe këni gër ebët ed angol andeɓën. Fel kënëɓi ɓela ɓër lëg bax gër angol andeɓën ɓën: ");
INSERT INTO bsc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Ɓela ɓëjo, ɓër aketëxeta ex ro gër ndeɓi. Ɗëgëlexëni gër ebar edeɓi ro, do eni pandërand. Ebar edeɓi el aỹang ỹangëk, axëñ këni xëñ! Ɓiyi aỹër kënëɓe ỹana enëɓe ñërënde odënaw̃ odeɓën ok, do ɓën enëɓi ñërënd odeɓi ok. ");
INSERT INTO bsc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ɓarikan eni maxën eɗëg ed andamat gë ɓiyi el, emat w̃ëka këni, ene gixëne ɓulunda iɓat. Asoŝan ar ex yo gër ndeɓi ro eno kac axac, ang xac kënëɓi ɓën ak. ");
INSERT INTO bsc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Oyel oreɓën ol, gë napul ireɓën in, do gë ow̃acar oreɓën ol, ax gi ex na nde ata kënëɓe xwëne? Mane wa aw̃a emat end w̃ëka kënëɓo eŋo, ene ɗëgaxëne andamat.» ");
INSERT INTO bsc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ɗek ɓër bax ŝanënd gër ebët ed angol ɓën wël kënëɓi Amor do gë asëñiw̃ Siŝem. Ata ɗek ɓësoŝan ɓër bax ŝanënd gër ebët ed angol ɓën w̃a këni enëɓi kac. ");
INSERT INTO bsc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Yatir akey atasën, xarak anëka këni sorond, Simewoŋ do gë Lewi, ɓosëñiw̃ ɓor Yakob, ɓër acël amat gë Dina ɓën, w̃eɗ këni ala kala duxuma irexëm in. H̃at këni gër angol endëmane fo, ala aɓi wata ex na. Law̃ëra kënëɓi ɗek ɓësoŝan ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","H̃aŝ kënëɓi ɓëte gë oduxuma ok, Amor do gë asëñiw̃ Siŝem. Xanaw këno Dina gër iciw̃ ind Siŝem, do kwël ŝan këni. ");
INSERT INTO bsc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ɓosëñiw̃ ɓor Yakob ɓëjo xoɓa këni gër ɓëŝësëk do xwëcara kënëɓi. Xandëra kënëɓi ɓacota ɓaŋ ɗek angol aŋ, gayik imaỹe itoxari indeɓën iŋ ɓuyarën bano. ");
INSERT INTO bsc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Xandëra kënëɓi oyel oreɓën ol: opeỹ, gë oɓeci, gë oxeƴ, gë opali, gë ɗek er ebax gër angol in, do gë er ocënga in. ");
INSERT INTO bsc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Xandëra kënëɓi ɓacota ɓandeɓën ɓaŋ. Sërara kënëɓi ɓësoxari ɓëreɓën ɓën, gë ɗek ɓër gër oxun oreɓën ɓën, do gë ɗek ɓeɓër ebax gër ɓëciw̃ ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ga xucak eŋo, Yakob fel këɓi Simewoŋ do gë Lewi: «Wën ata etëm eŋ w̃ëlanëgu këne. Awërax këne xwët ɓër lëgëk gër ebar elo ro ɓën, gë ɓërandëw̃ëra and Kanahaŋ ɓën, do gë ɓër and Përisi ɓën. Wëno ɓela ɓëfënëpëne fo ŝot këmëni. Ɓën ata këne ɓarënan ene mereli, do enëɓo ɗaw̃ëra wëno gë ɓër iciw̃ indam ɓën.» ");
INSERT INTO bsc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Simewoŋ do gë Lewi yaka këni: «Aỹap nde ỹapëk eno dixëra imaỹe itoxari indeɓi iŋ ang asoxari aỹacaxik fo?» ");
INSERT INTO bsc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Akey amat, Kaxanu fel këŋo Yakob: «Kanil eƴ dëfa ƴaŋ gër Bet-El, eƴ ɗëgëx fën. Dinëxëɗe angëɓ wëno Kaxanu, ar ŝanayaxën baxi and baƴ hërënd eƴo cana aɓinëx Esawu an.» ");
INSERT INTO bsc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ata Yakob fel këɓi ɓër iciw̃ indexëm ɓën, do gë ɗek ɓër ebax gë mëŋ ɓën: «Ɗapin olaŝ or ex mërëxand irewën do xwëta kën ang Kaxanu fo oŋ. W̃unëtarayin, do nëmbarayin ɓanjëm ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ƴaŋ gër Bet-El këne rëfaye. Fën këmo rinëx angëɓ Kaxanu, mëŋ ar yakali baxe cale yatir ŝëmura baxe an, do mëŋ ar xaxa ke gër fëña iram an.» ");
INSERT INTO bsc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ata fëxwëndëra këno Yakob ɗek olaŝ oreɓën or ebax gër otaxan odeɓën oŋ, do gë ɗek ɓañepe ɓand ɓakara bani gër ɓanëf ɓandeɓën ɓaŋ. Yakob wëg ko ɗek ɓeɓijo, ɗila gër edëp ed ananga and ex ler gër Siŝem. ");
INSERT INTO bsc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ga ri këni mondako, kwël ƴe këni. Kaxanu lapan këɓi anjiỹ atëm ɓër lëgërak gër ɓangol ɓand ler ler na gër ed ebani ɓën. Ata anëɓi tëf ex na ɓosëñiw̃ ɓor Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakob do gë ɗek ɓërexëm ɓën h̃at këni gër Lus, mëne ngëŋ gër Bet-El, gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Rix ko angëɓ do w̃ac ko na gër ed ebani «El-Bet-El», mëne ngëŋ «Kaxanu, ar gër Bet-El an». Gayikwa Kaxanu na ŝanayaxën baŋo Yakob, and baxo hërënd eŋo cana aɓinëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ata Debora, asoxari ar rafën baŋo Rebeka an, ŝës ko. W̃ëxëta këno ler gër Bet-El, ɗila gër aces and nëngwët bani ow̃ac «Atëx and otes». ");
INSERT INTO bsc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ata Kaxanu ŝanayaxën këŋo ɓëte Yakob, ga hiw ko gër ebar ed Padaŋ-Aram. Yël këŋo oɓetak ol. ");
INSERT INTO bsc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ata re ko Kaxanu: «Ow̃ac oreƴ ol Yakob ex, ɓari ax bo na ga këni w̃acënd Yakob. Isërayel këni ỹana eni macënd.» Mondako nëngwët baxo ow̃ac orexëm ol: Isërayel. ");
INSERT INTO bsc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Re ko ɓëte Kaxanu: «Wëno ex Kaxanu, ar xorëk ɓeỹ ɗek an. Dëw̃ëlëɓi oɓaŝ oranjëm, do ñëmbërëlexëni mbaŋ. Enëng do gë amara and ɓenëng kë ŝanëgu gër ndeƴ. Ɓemun kë ŝanaya na gër ɓër këƴëɓi rëw̃. ");
INSERT INTO bsc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ebar ed yël këmëni Abëraxam do gë Isak el, ayël këmun yël, wëj do ɓërandëw̃ëra andeƴ ɓën, and këƴ xuca aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ata Kaxanu ga xani ko, ko ŝëgënd ƴaŋ ƴaŋ na gër ed bani yeƴandërand gë Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakob rëɗ ko ekaỹ na gër ed yeƴaneli baŋo Kaxanu. Xoŝ ko gër ekaỹ ed rëɗ baxo elo ogu do gë ngoƴ ex gixën ekaỹ ecëɓax. ");
INSERT INTO bsc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakob w̃ac ko na gër ed ebani Bet-El, na gër ed yeƴaneli baŋo Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakob gë ɓër ekun edexëm ɓën xani këni na gër Bet-El. Anëka bani saxand gër Efërata, ga rëw̃ëra ko Raŝel. Ɓarikan orëw̃ olo mbaŋ ƴëka baŋo. ");
INSERT INTO bsc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","And baŋo rëw̃ënd itox aŋ, asoxari ar baŋo rëcand gër orëw̃ an, re ko: «Këreƴ yëdara na, lëmëta ŝot këƴo ɓëte.» ");
INSERT INTO bsc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ɗamana exo kotixën, w̃ac këŋo lëmëta in «Ben-Oni», mëne ngëŋ «Asëñiw̃ën ir aƴambën iram». Ɓarikan sëm nëngwët këŋo «Beŋëŝame», mëne ngëŋ «Asëñiw̃ën ir liw̃ iram». ");
INSERT INTO bsc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ga xoti ko Raŝel, w̃ëxëta këno gër fëña ir gër Efërata, mëne ngëŋ ir gër Betëlexem. ");
INSERT INTO bsc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakob rëɗ ko ekaỹ gër ỹeg ir Raŝel. Ata ekaỹ elo na ɓayik xali doro. ");
INSERT INTO bsc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isërayel gë ɓër ekun edexëm ɓën rëfa këni do rix këni akwëndaya andeɓën aŋ yaɓët ebar ed Migëdal-Eder el. ");
INSERT INTO bsc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Amëd and lëg baxo Isërayel na gër ebar elo aŋ, Ruben ƴe ko laki këni gë Bila, asoxari ar ỹëpa bani aỹëpa fo gë sëm an. Ata nang ko Yakob. Ɓosëñiw̃ ɓor Yakob er hi bani epëxw gë ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ɓëtoŝan ɓënd rëw̃ këɓi Leya ɓëŋ: Ruben, iñanar ind Yakob iŋ, gë Simewoŋ, gë Lewi, gë Yuda, gë Isakar do gë Sabuloŋ. ");
INSERT INTO bsc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raŝel mëŋ cëŋ, rëw̃ këɓi Yosef do gë Beŋëŝame. ");
INSERT INTO bsc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bila, xaɗëp isoxari ir Raŝel in, rëw̃ këɓi: Dan do gë Nefëtali. ");
INSERT INTO bsc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silëpa, xaɗëp isoxari ir Leya in, rëw̃ këɓi Gad do gë Aser. Ɓën ex ɓosëñiw̃ ɓor Yakob, ɓër rëw̃ëgu këɓi gër ebar ed Padaŋ-Aram ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ata Yakob gë ɓër ekun edexëm ɓën h̃at këni xali gër sëm Isak, gër Mamëre, ler gër Kiriyat-Arëba, gër ed këni w̃acënd ɓëte Ebëroŋ. Fën lëg bani ang ɓëliyer fo Abëraxam do gë Isak. ");
INSERT INTO bsc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak ga liya ko ɓëniy këme gë ofëxw ocongosas, ");
INSERT INTO bsc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ŝës ko. Ata Isak moped fed baŋo oxar ol, ɗamana ɓaraxën këni gë ɓëxarëk ɓërexëm ɓër ŝësëk elod anëka fo ɓën. Esawu do gë Yakob w̃ëxëta këno. ");
INSERT INTO bsc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Mondako ex andëw̃ëra and Esawu aŋ, mëŋ ar bano w̃acënd ɓëte Edom an. ");
INSERT INTO bsc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu ỹër baɓi odënaw̃ od gër ebar ed Kanahaŋ: Ada aɓiw̃ ar Eloŋ, arandëw̃ëra and Het an, do gë Oxolibama, aɓiw̃ ar Ana, ejiw̃ ed Tësibewoŋ, arandëw̃ëra and Hor an. ");
INSERT INTO bsc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ɓaŝa këŋo ɓëte Basëmat, aɓiw̃ ar Isëmayel, aɓinëm ar Nebayot. ");
INSERT INTO bsc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ata Ada rëw̃ën këŋo Esawu, Elifas. Basëmat mëŋ, rëw̃ën këŋo Rehuwel. ");
INSERT INTO bsc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oxolibama rëw̃ën këŋo: Yewuŝ, gë Yalam, do gë Kore. Ɓën ex ɓosëñiw̃ ɓor Esawu, ɓër rëw̃ kënëɓi na gër ebar ed Kanahaŋ ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Akey amat, Esawu ɓar këɓi ɓësoxari ɓërexëm ɓën, gë ɓosëñiw̃, gë ɓoɓiw̃, do gë ɗek ɓela ɓër iciw̃ indexëm ɓën. Ɓar këɓi ɓëte ɗek oyel orexëm ol, do gë ɓeɓër ŝotëra baxo na gër ebar ed Kanahaŋ ɓën. Ƴe ko kwël orëfa në ebar ecëxe, eni ŋaw̃ëtaraxën gë aɓinëm Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Gayikwa napul ir ŝot baxo ala kala in axuri xuri bax ga ỹëmbëk. Ax mënd bana eni ɗëg në ereɓat. Ɓëte na gër ebar ed ỹëpa bani ang ɓëliyer fo el, oyel oreɓën ol abani xëñ na. ");
INSERT INTO bsc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esawu ƴe ko ỹëpax ko gër ebar ed kap gër etënd ed Seyir. Esawu ex wa Edom. ");
INSERT INTO bsc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Mondako ex andëw̃ëra and Esawu aŋ, sëm ir Edom, gër ebar ed kap gër etënd ed Seyir. ");
INSERT INTO bsc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Omac od ɓosëñiw̃ ɓor Esawu ok ebax: Elifas, ar rëw̃ën këŋo alindaw̃ Ada an, gë Rehuwel, ar rëw̃ën këŋo alindaw̃ Basëmat an. ");
INSERT INTO bsc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ata ɓosëñiw̃ ɓor Elifas hi këni: Teman, gë Omar, gë Tësefo, gë Gatam, do gë Kenas. ");
INSERT INTO bsc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timëna, ebax asoxari ar ỹëpa bani aỹëpa fo gë Elifas, asëñiw̃ ar Esawu an. Timëna ijo rëw̃ën këŋo Amalek. Ata ɓën ex ɓosëñiw̃ ɓor Ada, asoxari ar Esawu an. ");
INSERT INTO bsc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ɓosëñiw̃ ɓor Rehuwel exëni: Nahat, gë Sera, gë Ŝama, do gë Misa. Ɓën ex ɓosëñiw̃ ɓor Basëmat, asoxari ar Esawu an. ");
INSERT INTO bsc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Mondako bax omac od ɓosëñiw̃ ɓor Oxolibama ok, aɓiw̃ ar Ana, asoxari ar Esawu an. Ana ijo ex mëŋ ɓëte aɓiw̃ ar Tësebewoŋ an. Mëŋ rëw̃ën baŋo Esawu: Yewuŝ, gë Yalam, do gë Kore. ");
INSERT INTO bsc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mondako hi bani ɓemun ɓend ɓosëñiw̃ ɓor Esawu ɓeŋ. Gër andëw̃ëra and Elifas, iñanar ind Esawu iŋ: Teman, gë Omar, gë Tësefo, gë Kenas, ");
INSERT INTO bsc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","gë Kore, gë Gatam, do gë Amalek. Ɓën ebax ɓemun ɓend andëw̃ëra and Elifas ɓeŋ, gër ebar ed Edom. Ɓën ex ɓosëñiw̃ ɓor Ada. ");
INSERT INTO bsc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Mondako hi bani ɓemun ɓeŋ gër ɓosëñiw̃ ɓor Rehuwel, asëñiw̃ ar Esawu: Nahat, gë Sera, gë Ŝama, do gë Misa. Ɓën ebax ɓemun ɓend andëw̃ëra and Rehuwel ɓeŋ, gër ebar ed Edom. Basëmat, asoxari ar Esawu an, ebax ejiw̃ edeɓën. ");
INSERT INTO bsc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Mondako hi bani ɓërandëw̃ëra and Oxolibama ɓën, asoxari ar Esawu an. Gër ɓërandëw̃ëra and Oxolibama, aɓiw̃ ar Ana, asoxari ar Esawu an, ɓemun ɓeŋ er hi bani: Yewuŝ, gë Yalam, do gë Kore. ");
INSERT INTO bsc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ɓën ebax ɓosëñiw̃ ɓor Esawu, do ɓën ebax ɓemun ɓendeɓën ɓeŋ. Esawu ex wa Edom. ");
INSERT INTO bsc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Mondako hi bani ɓosëñiw̃ ɓor Seyir, arandëw̃ëra and Hor an. Ɓër lëg bax gër ebar elo na ɓën, er hi bani: Lotaŋ, gë Ŝobal, gë Tësibewoŋ, gë Ana, ");
INSERT INTO bsc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","gë Diŝoŋ, gë Etëser, do gë Diŝaŋ. Ɓën ebax ɓemun ɓend ɓërandëw̃ëra and Hor, do gë ɗek oɓaŝ or Seyir gër ebar ed Edom ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Oɓaŝ or Lotaŋ ol er hi bani: Ori do gë Emam. Imaỹe itoxari ind Lotaŋ iŋ ebaxo Timëna. ");
INSERT INTO bsc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Mondako hi bani ɓosëñiw̃ ɓor Ŝobal: Alëfaŋ, gë Manahat, gë Ebal, gë Ŝefo, do gë Onam. ");
INSERT INTO bsc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Mondako hi bani ɓëte ɓosëñiw̃ ɓor Tësibewoŋ: Afa do gë Ana. Ana isoŝan ijo ŝanan bax añësa and men gër ladawe, and baɓi xaɗacërand opali od sëm Tësibewoŋ aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Mondako hi bani ɓëte oɓaŝ or Ana ol: itoŝan iŋ, Diŝoŋ, do gë itoxari iŋ, Oxolibama. ");
INSERT INTO bsc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Mondako hi bani ɓëte ɓosëñiw̃ ɓor Diŝoŋ: Emëdaŋ, gë Eŝëbaŋ, gë Yitëran, do gë Keran. ");
INSERT INTO bsc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Mondako hi bani ɓosëñiw̃ ɓor Etëser: Bilëxaŋ, Sahafaŋ, Safaŋ, do gë Akan. ");
INSERT INTO bsc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Mondako hi bani ɓosëñiw̃ ɓor Diŝaŋ: Utës do gë Aran. ");
INSERT INTO bsc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Mondako hi bani ɓemun ɓend ɓërandëw̃ëra and Hor ɓeŋ: Lotaŋ, gë Ŝobal, gë Tësibewoŋ, gë Ana isoŝan, ");
INSERT INTO bsc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","gë Diŝoŋ, gë Etëser, gë Diŝaŋ. Ɓën ebax ɓemun ɓend ɓërandëw̃ëra and Hor ɓeŋ, gër ebar ed Seyir. ");
INSERT INTO bsc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mondako hi bani ɓëte ɓemun ɓend ɓëtëraw bax gër ebar ed Edom ɓeŋ, ɗamana eni gixën gë ɓemun ɓërandëw̃ëra and Isërayel ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, asëñiw̃ ar Bewor wun ko gër ebar ed Edom, do ow̃ac or angol andexëm ol ebax Dinaba. ");
INSERT INTO bsc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","And ŝës ko Bela aŋ, Yobab, asëñiw̃ ar Sera, ɓëteli ko owun ol. Do angol andexëm aŋ ebax Botësëra. ");
INSERT INTO bsc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","And ŝës ko Yobab aŋ, Huŝam, ar gër ebar ed ɓërandëw̃ëra and Teman an, ɓëteli ko owun ol. ");
INSERT INTO bsc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","And ŝës ko Huŝam aŋ, Xadad, asëñiw̃ ar Bedad, ɓëteli ko owun ol. Mëŋ w̃ereli baŋo Majaŋ xali xor këŋo gër ebar ed Mohab. Angol andexëm aŋ ebax Awit. ");
INSERT INTO bsc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","And ŝës ko Xadad aŋ, Salëma ir gër Masëreka, ɓëteli ko owun ol. ");
INSERT INTO bsc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","And ŝës ko Salëma aŋ, Sawul ir gër Rexobot Nahar, ɓëteli ko owun ol. ");
INSERT INTO bsc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","And ŝës ko Sawul aŋ, Bahal-Hanaŋ, asëñiw̃ ar Akëbor ɓëteli ko owun ol. ");
INSERT INTO bsc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","And ŝës ko Bahal-Hanaŋ, asëñiw̃ ar Akëbor aŋ, Hadar ɓëteli ko owun ol. Angol andexëm aŋ ebax Pawu, do ow̃ac or alindaw̃ ol, Mehetabel, aɓiw̃ ar Matëred, ejiw̃ ed Mesahab. ");
INSERT INTO bsc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mondako ebax omac od ɓemun ɓend ɓërandëw̃ëra and Esawu ɓeŋ, nëng gë nëng, eɗëg gë eɗëg: Timëna, gë Alëfa, gë Yetet, ");
INSERT INTO bsc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","gë Oxolibama, gë Ela, gë Pinoŋ, ");
INSERT INTO bsc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","gë Kenas, gë Teman, gë Mibëtësar, ");
INSERT INTO bsc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","gë Magëdiyel, do gë Iram. Ɓën ebax ɓemun ɓend gër Edom ɓeŋ, ang lëgëra bani ak, gër ebar ed xwën këni. Esawu ex axarëk areɓën an, axarëk ar ɓërandëw̃ëra and Edom an. ");
INSERT INTO bsc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ata Yakob lëg ko na gër ebar ed Kanahaŋ, gër ebar ed ỹëpa baxo sëm ang aliyer fo el. ");
INSERT INTO bsc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mondako bax andëw̃ëra and Yakob aŋ. Yosef, lëmëta fo ɓayi baxo, do anëka sëk baŋo ɓëniy epëxw gë ɓënjongëɓëki. Oyel ol banëɓi xaɗacërand gë ɓoɓinëm, gë oɓaŝ or Bila ol, gë or Silëpa ol, ɓësoxari ɓër sëm ɓën. Xarak Yosef, ɗek baxo h̃atelind gër sëm ireɓën ang banëɓi renarand ak. ");
INSERT INTO bsc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isërayel moŋan h̃an baŋo Yosef, nëmëc ɗek oɓaŝ orexëm ol, gayik gand oxar rëw̃ baŋo. Aŝalan ŝalan baŋo acuɗ anjekax and ỹër-ỹër. ");
INSERT INTO bsc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ɓoɓinëm wat këni mëne ɗek ang ebani ak Yosef ex itox ind xwël këŋo sëm ireɓën iŋ. Ata ỹana këno ecus el. Laŋ gë xoỹ fo bano yeƴanelind. ");
INSERT INTO bsc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Akey amat, Yosef lakeli ko, do sëfëtan këɓi ɓoɓinëm lakeli in. Ata ŝus këno kaŝ-kaŝ. ");
INSERT INTO bsc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosef re ko: «Ɓaxëtin lakeli ir ri këme in, Axara xara këmun! ");
INSERT INTO bsc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ɓiyi ɗek gër oŝënga bane xapërande olaŋ. Ataŋ eɗaŋ edam el xwëŝak ceg. Olaŋ orewën oŋ, ga xetak jeƴ edam el, foxik gër lëngw ir eɗaŋ edam.» ");
INSERT INTO bsc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ata re këni ɓoɓinëm: «Do ba wëj nde kë hi emun endeɓi eŋ? Wëj nde këɓo xwën?» Ata ŝus këno ɓëte kaŝ-kaŝ në end oɗakeli odexëm eŋ, do në end oyeƴandëran orexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yosef lakeli ko ɓëte gaŝëxe. Ga këɓi sëfëtan ɓoɓinëm, re ko: «Alakeli lakeli këme ɓëte, eñan eŋ, gë facaw̃ in, do gë ow̃al epëxw gë eɓat oŋ, ga foxirak gër lëngw iram.» ");
INSERT INTO bsc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Sëfëtan këŋo ɓëte sëm lakeli ijo, ang sëfëtan baɓi ɓoɓinëm ak. Ata sëm rexëra këŋo mondako: «Inew̃a w̃acayak lakeli ireƴ ijo? Ba wëno, gë norix, do gë ɓoɓinëx nde kë ƴeli mi poxi gër lëngw ireƴ?» ");
INSERT INTO bsc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ata ɓoɓinëm ƴakëraxi këɓi. Ɓarikan sëm ɓayeli këŋo laŋ gër onden oɗakeli oko. ");
INSERT INTO bsc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Akey amat, ɓoɓinëm ɓor Yosef ƴe këni enëɓi kaɗacërax opeỹ ok do gë oɓeci or sëm ireɓën ol ler gër ebar ed Siŝem. ");
INSERT INTO bsc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isërayel fel këŋo Yosef: «Ax gi ex na nde, ɓoɓinëx ler gër Siŝem kënëɓi xaɗacëraxënd oyel ol? Ƴow mi ɗaw̃ën gër ed exëni.» Yaka ko Yosef: «Awa!» ");
INSERT INTO bsc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Re ko ɓëte Isërayel: «Këla, ƴel gër ɓoɓinëx, eƴ nangëgu ba ɓëɓëngw ɓayi këni, ɓën do gë oyel ol. Maỹiwëɗ eƴe pelati.» Mondako law̃ën baŋo elod na gër amora and Ebëroŋ. Yosef ga ƴe ko, h̃at ko xali gër Siŝem. ");
INSERT INTO bsc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ata ga ko ƴexëra gër ocënga, fed këni gë ala. Ala ajo w̃ëka këŋo: «Inew̃a këƴ ŝaland?» ");
INSERT INTO bsc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yaka ko: «Ɓëmaỹe ɓëndam ɓëŋ këmëni ŝaland. Këla pelële, feye kënëɓi xaɗacërand oyel oreɓën ol.» ");
INSERT INTO bsc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Re ko ala ajo: «Ani bo ex na ro, gayik awël wël këmëni ga këni re: “Ƴene gër Dotaŋ.”» Ata Yosef xuca ko gër ocal od ɓoɓinëm. Sëkëx këɓi gër Dotaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ata ɓën watëgu këno caw. Ɗamana exo ŋat gër ed hi bani, wëlër këni eno ɗaw̃. ");
INSERT INTO bsc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Mondako bani rend: «Yo nëkoɗo wa, axwën oɗakeli an ga ko h̃atëgund. ");
INSERT INTO bsc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Gërëgako, ƴowën enëŋo ɗaw̃e, do enëŋo ɗape polo në andu. Gwëre ene deɗe mëne emacar ekeỹax ƴak këŋo. Ata këne nange ba mondake kë hi oɗakeli odexëm oko.» ");
INSERT INTO bsc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben ga wël ko endeƴ eŋo, racët këŋo Yosef gër otaxan odeɓën, re ko: «Kërenëŋo ɗaw̃ ex na ɗe!» ");
INSERT INTO bsc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ɓaŝ ko: «Oŝat kërex car na. Ñëkëtino gër andu and ex gër ladawe aŋ, ɓari ỹoweỹ këreno dinan na.» Eŋo dacët gër otaxan odeɓën, do eŋo ɓakali gër sëm ỹandi baŋo mëŋ yeƴanaxën baxo mondako. ");
INSERT INTO bsc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","And h̃at ko Yosef gër ɓoɓinëm aŋ, ɓën w̃ëlën këno, do ŝuɗët këno acuɗ andexëm, acuɗ and ỹër-ỹër aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ga sëra këno, ỹëkët këno gër andu: andu aŋo ax gi bana gë men. ");
INSERT INTO bsc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ga rixëra këno mondako, ỹëpa këni eni ƴambëra. Ga rënëta këni watëgu kënëɓi enga end Oƴula od ebax ɓërandëw̃ëra and Isëmayel, ga hiw këni gër ebar ed Galahad. Ogelemba odeɓën ok lëɓindëragu kënëɓi ogu onëngax, ond bani w̃ëland gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ata Yuda fel këɓi ɓoɓinëm: «Inew̃a këɓo feca ga alaw̃ law̃ kënëŋone imaỹe indeɓi iŋ do ene condërande ecës edexëm el? ");
INSERT INTO bsc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ƴowën enëŋo pane gër ɓërandëw̃ëra and Isëmayel. Kërenëŋo ɗaw̃ ex na, gayikwa imaỹe indeɓi ex, ŝapar ireɓi exo!» Ata ɓoɓinëm w̃a këni endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Oƴula od ɓërandëw̃ëra and Majaŋ bax xucand. Ata ŝëpëtëgu këno Yosef gër andu. Na fan këno gër otaxan od ɓërandëw̃ëra and Isëmayel, ɓatama alapem ɓand koɗi, do ɓën w̃ëla këno kwël gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","And ɓakaw ko Ruben na gër andu aŋ, nema këŋo Yosef. H̃esëra ko ɓanjëm ɓandexëm ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ga ɓaka ko gër ɓoɓinëm, re ko: «Itox iŋ axo bo ex na! Do wëno feye wa këme ƴe gërëgako?» ");
INSERT INTO bsc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ata w̃eɗ këni acuɗ and Yosef aŋ, nëngëra këni gë oŝat or apëlang and h̃aŝ bano oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Law̃ëneli këni acuɗ aŋ gër sëm ireɓën gë eyeƴan elo: «Nëkoɗ wa er w̃eɗa këmi in. Këla, nëkonël ba acuɗ and asëñix aŋ ex.» ");
INSERT INTO bsc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakob ga wat ko acuɗ aŋ, re ko: «Acuɗ and asëñiw̃ën aŋ ex! Emacar ekeỹax wa w̃anangëtëra këŋo, emacar ekeỹax ƴak këŋo Yosef!» ");
INSERT INTO bsc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ata ga ƴambën këŋo gër yomb, Yakob h̃esëra ko ɓanjëm ɓand ŝuɗa baxo ɓaŋ. Xapa ko jaɓote gër edum, do ko renitarand end asëñiw̃ eŋ xali ɓakey ɓandanjëm. ");
INSERT INTO bsc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ɗek ɓosëñiw̃ do gë ɓoɓiw̃ këno yifarand. Ɓarikan ayifara yo ayifara, h̃ëp ko exo cësina. Er baxo rend: «Arenita këme renita end asëñiw̃ën eŋ xali mo tëkëx gër wur ir ɓëŝësëk!» Mondako sesëra baxo xali. ");
INSERT INTO bsc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Xarak, ɓërandëw̃ëra and Majaŋ ɓën kwël w̃ëla bano Yosef gër ebar ed Misëra. Fanëx këno gër Potifar, alëngw ar ɓënëkona ɓër Farawoŋ an. ");
INSERT INTO bsc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Amëd aŋo, Yuda anacëta nacëta baɓi ɓoɓinëm, do rëfa ko ler gër iciw̃ ar bano ind ar bano w̃acënd Hira, gër angol and Adulam. ");
INSERT INTO bsc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ata Yuda wat këŋo endënaw̃ end Ŝuwa eŋ, Aɓëkanahaŋ. Ga ỹër këŋo, ɓar këni angaw̃ amat. ");
INSERT INTO bsc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Asoxari an hi ko gë acël do rëw̃ këŋo itoŝan. Yuda w̃ac këŋo Er. ");
INSERT INTO bsc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Hi ko ɓëte gë acël, do rëw̃ këŋo itoŝan. W̃ac këŋo mëŋ dëŋ Onan. ");
INSERT INTO bsc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Rëw̃ këŋo ɓëte itoŝan, do w̃ac këŋo Ŝela. And rëw̃ëra ko alindaw̃ aŋ, Yuda gër Kesib hi baxo. ");
INSERT INTO bsc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ata Yuda ŝalan këŋo Er, itoŝan iñanar indexëm iŋ, asoxari ar këno w̃acënd Tamar. ");
INSERT INTO bsc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ang baxo liyand Er, itoŝan iñanar ind Yuda ak, Axwën Kaxanu aŝus ŝus baxo, ata law̃ këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ga ŝës ko Er, Yuda fel këŋo Onan: «Ɓëtelilo asoxari ar aɓinëx an, ang rëpëk ak, exo gixën ar gë oɓaŝ.» ");
INSERT INTO bsc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ata Onan ỹër këŋo asoxari an. Ɓarikan nang ko mëne oɓaŝ or këɓi rëw̃ ol, or aɓinëm kë hi, ani gi na orexëm. And këni ɓar angaw̃ aŋ, Onan exo ɗex gër ebar eneɗa endexëm eŋ, abaxo seɓ na gër asoxari, ga xeƴ këŋo eŋo cotën andëw̃ëra aɓinëm. ");
INSERT INTO bsc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Er baxo rind ijo Axwën Kaxanu aŝus ŝus baxo, ata law̃ këŋo mëŋ ɓëte. ");
INSERT INTO bsc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ata Yuda fel këŋo Tamar, aɓiw̃ ir eñër: «Gayikako asoxari aseɓëta-seɓëta hi këƴ, maỹil gër sorix xali exo daf asëñiw̃ën Ŝela.» Gayikwa Yuda are baxo rend: «Kërexo cës na fa Ŝela ɓëte, ang ɓoɓinëm ak.» Tamar w̃aỹi ko, do ỹëpax ko gër iciw̃ ind sëm. ");
INSERT INTO bsc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ga niyitak, aɓiw̃ ar Ŝuwa, alindaw̃ ar Yuda, ŝës ko. And xucak oỹaw̃ aŋ, Yuda ƴe ko ƴaŋ gër Timëna, gër ɓër baɓi xacanënd omban opeỹ odexëm ok. Sëfër këni gë Hira, lawo irexëm, Aɓëkanahaŋ ar gër Adulam an. ");
INSERT INTO bsc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ata ɓela ɓën fel këno Tamar: «Ayarax isoŝan cëŋ doro ko ƴend ɗe ƴaŋ gër Timëna, gër ekaca ed omban ond opeỹ odexëm.» ");
INSERT INTO bsc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar ŝuɗëtara ko ɓanjëm ɓand ɓësoxari ɓëseɓëta-seɓëta ɓaŋ. Nëmbara ko ɓacëxe, laɓaya ko kwëc dëxas in gë anjëm, do ỹëpa ko ler gër ingol ind Eyinayim, gër fëña ir gër Timëna. Gayikwa awat wat baxo mëne Ŝela anëka dëŋ raf ko, ɓari aŋo ɓëteli bana. ");
INSERT INTO bsc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda, sam ga wat këŋo, yëla ko asoxari aỹacaxik ex, gayik kwëc laɓ baxo dëxas in. ");
INSERT INTO bsc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nangërëxe mëne aɓiw̃ ir eñër ex, re ko: «Awël nde, mëkëñaye ga w̃a w̃a këƴ!» Yaka ko Tamar: «Ine këƴe yël angëmëne aw̃a w̃a këme?» ");
INSERT INTO bsc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Re ko Yuda: «Ipërac këmi yeɓënëgu.» Yaka ko Tamar: «Awa! Ɓarikan pere këƴe seɓën ỹeỹ ɗamana exo ŋataxënëgu.» ");
INSERT INTO bsc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","W̃ëka ko Yuda: «Inew̃a këmi yël?» Yaka ko: «Edëxër ed gë ow̃ac oreƴ ed rëx këƴ elo, do gë acët and lëkaya këƴ aŋo.» Ata ga fëxwën këŋo oỹënga oŋo, laki këni. Mandëk Tamar, yatijo ŝot ko acël aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ga w̃aỹi ko gër ndeɓën, laɓët ko dëxas irexëm in, do ɓakan ko ɓanjëm ɓand ɓësoxari ɓëseɓëta-seɓëta ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ata Yuda law̃ën këŋo lawo irexëm in, Aɓadulam an, eŋo yëlëx ipërac iŋ asoxari ajo, do exo kanaw ɓeɓër seɓënëgu baŋo ɓën. Ɓari mëŋ ga ƴe ko, aŋo wat ex na. ");
INSERT INTO bsc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","W̃ëka këɓi ɓela ɓër lëgëk ler gër Eyinayim na ɓën: «Feye wa exo asoxari aỹacaxik ar bax ỹëpand ler gër fëña an?» Yaka këno: «Ɓiyi elod amo wat ex na ro asoxari aỹacaxik!» ");
INSERT INTO bsc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ga ɓaka ko gër Yuda, re ko: «Wëno amo watëgu ex na ɗe, do ɓër lëgëk ler na ɓën ga re këni mëne elod ano wat ex na na asoxari aỹacaxik!» ");
INSERT INTO bsc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ata re ko Yuda: «Kwëtayaxëlexo oỹënga or seɓënëgu këmo oŋ! Kërexe calaye na fa mocala dëŋ oŝëfën ol. Ayeɓën yeɓën këmo ipërac iŋ, ɓari wëj aƴo watëgu ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ga xucak opacaw̃ otas, ƴow ko ala fel këŋo Yuda: «Awa Tamar, aɓix ar eñër, eñac xwënda ko ɗe. Ado anëka hi ko gë acël gë eñac endexëm eŋ!» Ata re ko Yuda: «Nëcëtëguno enëŋo core!» ");
INSERT INTO bsc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ga këno nëcët, Tamar law̃ën ko gër sëm ir eñër eyeƴan elo: «Gë asoŝan ar xwënëk oỹënga oŋo an ŝot këmi acël aŋ. Këla, nëkonël ba anang këƴo nang ar xwënëk edëxër ed kë ow̃ac elo, do gë acët aŋo an.» ");
INSERT INTO bsc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ga wat ko oỹënga oŋ, re ko: «Awa mëŋ ex ɗe ar ŝenene an, ax gi ex na wëno, gayikako wëno h̃ëpëk eŋo ɓëteli asëñiw̃ën Ŝela.» Ata mondako seɓët bano Tamar, ɓari abani laki na gë Yuda. ");
INSERT INTO bsc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","And h̃atëk orëw̃ aŋ, Tamar nang ko mëne ɓëŝa ex gër acël andexëm. ");
INSERT INTO bsc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Gër orëw̃, itox imat lëngwaliw ko ataxan aŋ. Asoxari ar baŋo rëcand gër orëw̃ an, sëra ko do xap këŋo ingux imbarax. Re ko: «Itox iŋo ex ind ŝanëguk iñanar iŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ɓarikan mëŋ ɓakalix ko ataxan aŋ, ata ŝanëgu ko aɓinëm. Asoxari ar baŋo rëcand gër orëw̃ an, re ko: «Ah̃acan fo h̃acanëgu këŋo aɓinëm!» Ata Yuda yël këŋo ow̃ac ol: Peres, mëne ngëŋ «Amëd.» ");
INSERT INTO bsc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ata ŝanëgu ko aɓinëm gë ingux imbarax iŋ gër ataxan. Yuda yël këŋo ow̃ac ol: Sera, mëne ngëŋ «Awarax». ");
INSERT INTO bsc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","W̃ëla këno Yosef gër ebar ed Misëra. Do Amisëra aɓat, Potifar, alëngw ar ɓënëkona ɓër Farawoŋ, yëc këŋo gër otaxan od ɓërandëw̃ëra and Isëmayel ɓër w̃ëlaw baŋo na. ");
INSERT INTO bsc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Axwën Kaxanu hi këni gë Yosef. Ata er ko ri yo exo kamën. Hi ko gër iciw̃ ind axwën arexëm, Amisëra an. ");
INSERT INTO bsc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Axwën arexëm an wat ko mëne Axwën Kaxanu gë Yosef hi këni: er ko ri yo, exo kamën në end Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ata Potifar, axwën arexëm an, ga baŋo nënganënd mbaŋ end Yosef eŋ, yata këŋo eŋo diyenindërand. Yata këŋo exo gi alëngw ar gër iciw̃ indexëm, do seɓënan këŋo ɗek er xwën ko in. ");
INSERT INTO bsc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sam ga hi ko Yosef alëngw ar iciw̃ do gë ɗek er xwën ko Potifar an, Axwën Kaxanu yël këŋo oɓetak ol Amisëra an në end Yosef. Oɓetak or Axwën Kaxanu ol hik gër ɗek ɓeɓër xwën ko Amisëra ɓën gër iciw̃ do gër ocënga. ");
INSERT INTO bsc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Er xwën ko yo seɓënan baŋo Yosef, ỹoweỹ ax bo bana ga ko ri, ang ax gi ex na eƴambëran el. Xarak Yosef ŝambenjar iyekax ebaxo. ");
INSERT INTO bsc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ga xucak eŋo, asoxari ar axwën arexëm an ỹana ko këŋo nëkonënd Yosef gë aŋana. Akey amat, re ko: «Ƴow exe ɗakiye!» ");
INSERT INTO bsc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yosef h̃ëp ko, do re ko: «Ali, axwën aram an seɓënan ke er xwën ko yo, ỹoweỹ axo dind na gër iciw̃ ro. ");
INSERT INTO bsc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Wëno ala axe kuca ex na or gapak ol gër iciw̃ ro, do ỹoweỹ axe cëɓan ex na, ang ax gi ex na wëj gayik alindaw̃ hi këƴ. Mondake wa këme xor me di amena atëm aŋo? Mondake këmo w̃enan Kaxanu?» ");
INSERT INTO bsc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Asoxari an key yo key baŋo w̃acërand Yosef. Ɓari mëŋ abaŋo yaka na, gayik aŋo ñandi bana eni tëkar do eni ɗaki. ");
INSERT INTO bsc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Akey amat, Yosef lil ko gër iciw̃ exo diyeni, xarak ang exëni ɗek na gër iciw̃ ak, gaɓatak ax ɓayi bana. ");
INSERT INTO bsc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ata asoxari an sëra këŋo Yosef gër acuɗ, do re ko: «Ƴow exe ɗakiye!» Yosef ɓusëta ko acuɗ aŋ gër otaxan odexëm, do hër ko fac. ");
INSERT INTO bsc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","And wat ko mëne anëka ɓusëtan këŋo acuɗ aŋ do hër ko fac aŋ, ");
INSERT INTO bsc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","asoxari an xeỹ ko eɓi macaxën ɓër gër iciw̃ ɓën. Ga h̃atëragu këni, re ko: «Watin icën indam iŋ ga w̃ëlanëgu këɓo arandëw̃ëra and Eber eɓo mëkëñaxënati. Asëka sëkaw baxe mëne mi ɗaki, ɓarikan wëno xeỹ këme mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","And wël ke ga këme xeỹ aŋ, ɓusëta ko acuɗ andexëm aŋ do kwël hër ko fac.» ");
INSERT INTO bsc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ata asoxari an xwëtaya ko acuɗ and Yosef aŋ xali w̃aỹigu ko icën indexëm iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Fel këŋo ɓëte mondako: «Xaɗëp ir arandëw̃ëra and Eber ir w̃ëlanëgu këƴëɓo in, sëka baxe exe mëkëñaxën. ");
INSERT INTO bsc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ga xeỹ këme, ɓusëtan ke acuɗ aŋ gër otaxan odam do kwël hër ko fac.» ");
INSERT INTO bsc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar ɓaxët këŋo alindaw̃ ga këŋo fel: «Mondako rirëli këmi ɗe gë xaɗëp ireƴ in.» Ata Potifar xoỹ ko. ");
INSERT INTO bsc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Re ko eno tëra Yosef, do eno mëla gër epëra, gër ed ebani ɓandepëra ɓand emun. Ata Yosef mondako hixën baxo gër epëra. ");
INSERT INTO bsc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Axwën Kaxanu hi këni gë Yosef, do yël këŋo oyekax ol. Ata alëngw ar ɓënëkona ɓër epëra an xwëta këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Alëngw ar ɓënëkona ɓër epëra an seɓënan këŋo Yosef ɗek ɓandepëra ɓand hi bax na gër epëra ɓaŋ. Mëŋ baɓi nëkonand gër er këni rind yo. ");
INSERT INTO bsc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Alëngw ar ɓënëkona ɓër epëra an, abaxo ŝala na exo nang er ko rind Yosef in, gayik Axwën Kaxanu gë mëŋ hi bani do arëca baŋo rëcand exo kamën er ko ri yo. ");
INSERT INTO bsc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ga xucak eŋo, alëngw ar ɓëxatën ɓër ngoƴ ɓër emun end ebar ed Misëra an, do gë alëngw ar ɓëwëka ɓër mburu an, w̃enan këno axwën areɓën an, emun end ebar ed Misëra eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farawoŋ xoỹën këɓi ɓela ɓër gapak ɓëxi ɓëjo: alëngw ar ɓëxatën ɓër ngoƴ an, do gë alëngw ar ɓëwëka ɓër mburu an. ");
INSERT INTO bsc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Re ko enëɓi tëra tak ɓëxi do enëɓi mëla gër epëra ed baxo nëkonand alëngw ar ɓënëkona an, gër ed fërax bano Yosef. ");
INSERT INTO bsc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Alëngw ar ɓënëkona ɓër epëra an fel këŋo Yosef eɓi ɗëɓand. Ata ɓëlëngw ɓëxi ɓëjo mondako xeyëra baɓi na gër epëra. ");
INSERT INTO bsc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gëmëɗ iɓat, alëngw ar ɓëxatën ɓër ngoƴ an do gë alëngw ar ɓëwëka ɓër mburu ind emun end Misëra an, lakeli këni ala kala, lakeli ir gë end ỹap bax eni nang. ");
INSERT INTO bsc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ga xeyëk gëɓër, sëkar këni gë Yosef, wata ko mëne aŝamina ŝamina këni. ");
INSERT INTO bsc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ata w̃ëka këɓi ɓëlëngw ɓësëm ɓër Farawoŋ ɓëjo: «Inew̃a ŝaminaxën kën doro?» ");
INSERT INTO bsc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yaka këno: «Ɓiyi tak ɓëxi, ala kala, alakeli lakeli këmi do ala ax gi ex na ar këɓo fel er w̃acayak in.» Re ko Yosef: «Ax gi ex na nde Kaxanu xwënëk enangën ed er kë w̃acayand lakeli in? Awël nde, tëfëtanine oɗakeli odewën ok!» ");
INSERT INTO bsc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Alëngw ar ɓëxatën ɓër ngoƴ an ga këŋo sëfëtan Yosef lakeli irexëm in, re ko: «Gër lakeli iram, awat wat këme atëx and reseŋ gër lëngw iram. ");
INSERT INTO bsc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Wat këme ɓëte gër atëx aŋo ɓënini ɓëtas ga nëtëk, fëtëfëtik, rëw̃ëk, do reseŋ in sëgëk. ");
INSERT INTO bsc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Do wataya këme ga lëkaya këme andëmba and Farawoŋ aŋ gër ataxan. Ga xwëc këme reseŋ in, nas këme gër andëmba, do saƴ këmo Farawoŋ gër ataxan.» ");
INSERT INTO bsc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ata re ko Yosef: «Awa ɓaxëtël er w̃acayak in: ɓënini ɓëtas ɓënd reseŋ ɓëŋo, ɓakey ɓatas ex. ");
INSERT INTO bsc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ro gë ɓakey ɓatas, Farawoŋ aseɓët ki seɓët do exi ɓakali gër andiyen andeƴ. Wëj këŋo ỹana eŋo katënënd gaŝëxe ngoƴ iŋ, ang baƴ rind and hi baƴ alëngw ar ɓëxatën ɓër ngoƴ indexëm ak. ");
INSERT INTO bsc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ɓarikan and ki yera aŋ, kwitayiɗe wa axwita, pëɓiɗ wa afëɓ anangëra andeɓi aŋ. Këla, nangëniɗo endam eŋ Farawoŋ. Do dëcayiɗe me can gër epëra elo ro. ");
INSERT INTO bsc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Gayikwa ɓela fo nëỹaliw ke ƴowaxënëgu këme elod gër ed exëni ɓërandëw̃ëra and Eber. Do ɓëte end këne w̃ëlaxënëgu ro gër epëra, ame di ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Alëngw ar ɓëwëka ɓër mburu an, ga wat ko mëne Yosef ŝenene nangën baŋo alëngw ar ɓëxatën ɓër ngoƴ an, er w̃acayak lakeli irexëm in, re ko: «Gër lakeli iram, ɓakange ɓatas ɓand gë mburu sëndëndër bame gër gaf iram. ");
INSERT INTO bsc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Polo gër akange and ƴaŋ ebax ɓamburu ɓand ex yo, ɓand h̃an ko Farawoŋ. Ɓacël ɓaŋ këni xolënd mburu iŋo ƴaŋ gër ed lëɓina këme.» ");
INSERT INTO bsc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ata re ko Yosef: «Awa ɓaxëtël er w̃acayak in: ɓakange ɓatas ɓaŋo, ɓakey ɓatas ex. ");
INSERT INTO bsc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ro gë ɓakey ɓatas, Farawoŋ aseɓët ki seɓët. Ɓarikan are ko re eni kaw̃ ƴaŋ në osëx, do ɓacël ɓaŋ eni kolëra eman endeƴ eŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ata akey atasën aŋ, fedëk gë akey and ekwita ed andëw̃a and Farawoŋ aŋ. Farawoŋ rin këɓi ñambëran ɗek ɓër eyang edexëm ɓën. Law̃ën ko enëɓi teɓëtëgu alëngw ar ɓëxatën ɓër ngoƴ an do gë alëngw ar ɓëwëka ɓër mburu an, ogës od ɓela ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Farawoŋ ɓakali këŋo alëngw ar ɓëxatën ɓër ngoƴ an, gër andiyen andexëm. Ɓakan këŋo xatënënd Farawoŋ ngoƴ iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Alëngw ar ɓëwëka ɓër mburu an cëŋ, re ko eno kaw̃, ang reƴa baxo Yosef w̃acayak lakeli ir wat baxo ak. ");
INSERT INTO bsc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ɓarikan, alëngw ar ɓëxatën ɓër ngoƴ an xwëya këŋo mokwëya dëŋ Yosef. ");
INSERT INTO bsc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ga xucak ɓëniy ɓëki, Farawoŋ lakeli ko. Wataya ko ga xwëŝa ko ler gër yeɓ ir Nil. ");
INSERT INTO bsc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Wat këɓi oxeƴ onëm ocongoxi, oyekax, oɓëtëk, ga ŝëpëtagu këni gër Nil, do këni ƴambërand ondës oŋ na gër ɓëŋa. ");
INSERT INTO bsc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Sëfagu kënëɓi ɓëte oxeƴ onëm oŝëxe ocongoxi oỹëŋënax, ofiŝëk, ga ŝëpëtagu këni ɓën ɓëte gër Nil, do xetëna kënëɓi oxeƴ onëm oỹanar ol, ler gër ɓëŋa. ");
INSERT INTO bsc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Oxeƴ onëm oỹëŋënax ol, ofiŝëk ol, ƴamb kënëɓi oxeƴ onëm ocongoxi oyekax ol, oɓëtëk ol. Ata nëngëta ko Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ga raŝ këŋo gaŝëxe, lakeli ko ɓëte akinëm. Wat ko në añamb amat ɓanjëra ɓanjongëɓaki ɓanjekax, ɓand rëw̃ëk mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ata nëtëguk ɓëte gër añamb aŋo fo ɓanjëra ɓanjongëɓaki ɓañëŋënax, ɓaŋaỹëk, ɓand ŝorëk ekoc eƴëkax ed kë xaniwënd apën-eñan el. ");
INSERT INTO bsc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ɓanjëra ɓañëŋënax ɓaŋ hëlëk ɓanjëra ɓanjekax ɓaŋ. Aŋo nëngëta ko ɓëte Farawoŋ: lakeli iɓat ebax mondako. ");
INSERT INTO bsc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ata gëɓër, Farawoŋ wëlandëra këŋo gër onden ondexëm. W̃ac këɓi ɗek ɓëŝaki ɓën, gë ɗek ɓërenik ɓër ebar ed Misëra ɓën do sëfëtan këɓi oɗakeli odexëm ok. Ɓarikan gaɓatak ax kor bana eŋo pel er w̃acayak lakeli ijo in. ");
INSERT INTO bsc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ata alëngw ar ɓëxatën ɓër ngoƴ an fel këŋo Farawoŋ: «Awël nde, doro afo mi kwitan amena andam aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Akey amat, wëj Farawoŋ xoỹën baɓo ɓiyi ɓëriyenin ɓëreƴ ɓën. Fëra këƴëɓo wëno do gë alëngw ar ɓëwëka ɓër mburu an gër epëra ed alëngw ar ɓënëkona. ");
INSERT INTO bsc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ata gëmëɗ iɓat, lakeli bami wëno do gë mëŋ, ala kala gë lakeli irexëm, do gë er w̃acayak in. ");
INSERT INTO bsc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Icambenjar ind andëw̃ëra and Eber ind ex xaɗëp ir alëngw ar ɓënëkona hik na lëf gër epëra. Ɓiyi ga sëfëtan këmo oɗakeli odeɓi ok, fel këɓo ala kaka er w̃acayak in. ");
INSERT INTO bsc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ata enimin h̃atak ɗek ang faỹën baɓo ak: wëno ɓakaliw këƴe gër andiyen andam ro, do alëngw ar ɓëwëka ɓër mburu an, ŝës ko mokaw̃.» ");
INSERT INTO bsc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ata Farawoŋ re ko eno macëgu Yosef. Nëcëtëgu këno aỹand gër epëra. Ga ŝëk këno lir-lir, nëmbara ko ɓanjëm ɓaŋ h̃ataxën ko gër Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farawoŋ fel këŋo Yosef: «Wëno alakeli lakeli këme, do ala ax kor ex na exe pel er w̃acayak in. Ɓarikan awël wël këme mëne wëj ewël ed lakeli el fo këƴ ŝënind eƴ deƴaxën er w̃acayak in.» ");
INSERT INTO bsc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yaka ko Yosef: «Kaxanu wa këŋo faỹën Farawoŋ lakeli irexëm in xali eŋo nëngan, ax gi ex na wëno!» ");
INSERT INTO bsc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ata Farawoŋ fel këŋo Yosef: «Gër lakeli iram, wëno er xwëŝa bame gër ɓëŋa ir Nil. ");
INSERT INTO bsc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ŝëpëtaw këni gër Nil oxeƴ onëm ocongoxi oyekax, oɓëtëk, do këni ƴambërand ondës oŋ gër ɓëŋa. ");
INSERT INTO bsc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ŝëpëtaw këni ɓëte oxeƴ onëm ocongoxi oŝëxe, ofiŝëk, oỹëŋënax, or ɓayi bax oŝapar fo: oxeƴ or ỹëŋënëk mondako, elod amëni wat ex na ɗek ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Oxeƴ onëm or ɓayi bax oŝapar fo olo, oỹëŋënax olo, ƴamb kënëɓi oxeƴ onëm ocongoxi oỹanar or ɓët bax ol. ");
INSERT INTO bsc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ga hël kënëɓi, ɓacël ɓandeɓën ɓaŋ ɓayik nangëde ỹoweỹ ani ƴamb ex na fo. Ɓayi këni ang ỹëŋën bani gër ỹanar ak. Aŋo nëngëta këme. ");
INSERT INTO bsc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ga raŝ ke gaŝëxe, lakeli këme ɓëte. Wat këme në añamb amat ɓanjëra ɓanjongëɓaki ɓanjekax, ɓand rëw̃ëk mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ata nëtëguk ɓëte gër añamb aŋo fo ɓanjëra ɓanjongëɓaki, ɓaŋaỹëk gayik ekoc eƴëkax ed kë xaniwënd apën-eñan el ŝor bax. ");
INSERT INTO bsc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ɓanjëra ɓaŋaỹëk ɓaŋo hëlëk ɓanjekax ɓaŋ. Lakeli ijo fel këmëni ɓëŝaki ɓën, ɓari gaɓatak ax kor ex na exe pel er w̃acayak in.» ");
INSERT INTO bsc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ata Yosef yaka këŋo Farawoŋ: «Lakeli iɓat wat këƴ, Farawoŋ. Kaxanu nangën ki wëj Farawoŋ er ko ri in. ");
INSERT INTO bsc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Oxeƴ onëm ocongoxi oɓëtëk ol ex ɓëniy ɓënjongëɓëki. Ɓanjëra ɓanjongëɓaki ɓanjekax ɓaŋ ex ɓëte ɓëniy ɓënjongëɓëki. Lakeli iɓat fo ex. ");
INSERT INTO bsc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Oxeƴ onëm ocongoxi or ɓayi bax oŝapar fo ol, oỹëŋënax ol, or ŝëpëtagu bax gër ofoƴ or oxeƴ onëm oỹanar ol, ex ɓëniy ɓënjongëɓëki ɓënd gë enjo. Ɓanjëra ɓanjongëɓaki ɓand gë ɓenjëlir këm ɓaŋ, ɓand ŝorëk ekoc eƴëkax ed apën-eñan ɓaŋ ex ɓëte ɓëniy ɓënjongëɓëki ɓënd gë enjo. ");
INSERT INTO bsc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ata ang fel këmi wëj Farawoŋ ak, Kaxanu nangën ki er ko ri in. ");
INSERT INTO bsc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ɓëniy ɓënjongëɓëki ɓënd gë eƴamb ed mbaŋ kë h̃atëgu na ɗek ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ata ex ɓëtëgu ɓëniy ɓënjongëɓëki ɓënd gë enjo. Mokwëya këni xwëya gër ebar ed Misëra ɓëniy ɓënd gë eƴamb ed mbaŋ ɓëŋ. Enjo eŋo moñepën kë ƴepën ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ɓëniy ɓënd gë eƴamb ed mbaŋ ɓëŋ, ala ax ñana na exo kwitand ro gër Misëra gayik enjo eŋ mokuma kë xuma. ");
INSERT INTO bsc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Awa Farawoŋ, gayikako ɓakëlëbëd ɓaki wat këƴ lakeli ijo, nangël mëne Kaxanu, end faỹ ko mopaỹ dëŋ ex, gogo ko ri eŋo. ");
INSERT INTO bsc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Awa gërëgako Farawoŋ, tanalo ar gë onden, arenik, eƴo di alëngw gër ɗek ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Wëj Farawoŋ, calalëɓi ɓëte gër ebar edeƴ ɓësëf ɓër eƴamb eni kanaxënënd mar gër eƴamb ed këni ŝotëra Ɓëmisëra el gë ɓëniy ɓënjongëɓëki ɓënd gë eƴamb ed mbaŋ ɓëŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ɓarindëlexëni eƴamb ed ex yo gë ɓëniy ɓënd gë eƴamb ɓënd kë h̃atëgu ɓëŋ. Dilexëni gër ɓangol, gë or gapak or këƴëɓi yël wëj Farawoŋ ol, ɓaciw̃ ɓand gër ed këni ỹana eni cacënd bële in, gë eƴamb ed këni ɓar do eni nëkonand el. ");
INSERT INTO bsc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Eƴamb ed këni ɓar elo kënëɓi ŝacën Ɓëmisëra ɓën. Do and kë h̃atëgu ɓëniy ɓënjongëɓëki ɓënd gë enjo aŋ fo kënëɓi nëcëtën, mondako ɓayik enjo eŋ aɓi nemindëra na.» ");
INSERT INTO bsc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ata Farawoŋ do gë ɓër eyang edexëm ɓën nëngan këɓi end eyeƴan elo eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farawoŋ w̃ëka këɓi ɓër eyang edexëm ɓën: «Aŝot nde kënëŋo ŝote ala aŝëxe, ar ang ajo ak, ar gë angoc and Kaxanu?» ");
INSERT INTO bsc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farawoŋ fel këŋo Yosef: «Awa gayikako Kaxanu, wëj nangën ki eŋo ɗek, ar gë onden, ar renik ang wëj ak, axo gi ex na. ");
INSERT INTO bsc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wëj kë hi alëngw ar eyang edam an do ar ɗek ɓulunda iram an, ɓapela ɓandeƴ këni ỹana eni ɓaxëtënd. Gë añëpara and owun aŋ fo këmi ỹëmbëta or gapak ol.» ");
INSERT INTO bsc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ata Farawoŋ fel këŋo ɓëte Yosef: «Awël nde, wëj sana këmi eƴ gi alëngw ar ɗek ebar ed Misëra an.» ");
INSERT INTO bsc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farawoŋ rëxët ko gër eɓasa edexëm anëna and owun aŋ, do lën ko gër eɓasa ed Yosef. Ŝuɗëra këno ɓanjëm ɓanjekax, ɓand xemëk akanji, do rëxën këŋo edëxër ed kaŋe gër egëla. ");
INSERT INTO bsc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Re ko eno ñëpan Yosef ƴaŋ gër wotir ir ar ɓëtëk gër owun orexëm, do eno mëlara. Ɓela ɓër bax lëngwënd ɓën këni xeỹënd: «Pacanayin, pacanayin!» Ata Farawoŋ mondako yata baŋo Yosef hi ko alëngw ar ɗek ebar ed Misëra an. ");
INSERT INTO bsc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farawoŋ fel këŋo ɓëte Yosef: «Wëno ex Farawoŋ! Angëmëne ax gi ex na wëj rek, gaɓatak ax ñana na ex cangënënd imasa indexëm, ba itapar indexëm iŋ, ɗek ebar ed Misëra el.» ");
INSERT INTO bsc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farawoŋ nëngwët ko ow̃ac or Yosef ol: «Tësafënat-Panehax». Ŝalan këŋo asoxari ar këno w̃acënd Asenet, aɓiw̃ ar Poti-Fera, aŝaɗaxan ar eɗaŝ ed bani w̃acënd On el. Aŋo fo xor ko Yosef exo ƴexërand ɗek ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","And w̃ëla këno Yosef gër Farawoŋ, emun end ebar ed Misëra aŋ, anëka sëk baŋo ɓëniy ofëxw osas. Yosef xani ko na gër eyang ed Farawoŋ, ƴexëra ko ɗek ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Gë ɓëniy ɓënjongëɓëki ɓënd gë eƴamb ed mbaŋ ɓëŋ, ebar el këɓi w̃aŝënd aye ɓeneɗa ɓend bani neɗënd ɓeŋ, do këni xanarand ɗëm. ");
INSERT INTO bsc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ata Yosef ko ɓarënd ɗek eƴamb el gë ɓëniy ɓënjongëɓëki ɓënd eƴamb ed ɗëm ɓëŋ, na gër ebar ed Misëra. Aŝac baxo ŝacënd eƴamb el në angol kala, ler gër ocënga od xanaraw këni. ");
INSERT INTO bsc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosef ɓar ko bële in ang eɗini ed gër angwëngw fo. Ang ỹëmb bax ak, axuri xuri bax, xali seɓ këni epën el gayik ax mënd bana eni pën. ");
INSERT INTO bsc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ɗamana ex ŋatëgu iniy iñanar ind gë enjo iŋ, Asenet, alindaw̃ ar Yosef, aɓiw̃ ar Poti-Fera aŝaɗaxan ar eɗaŝ ed On an, anëka rëw̃ baɓi oɗëmëta oki. ");
INSERT INTO bsc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosef w̃ac këŋo lëmëta iỹanar in Manase, mëne ngëŋ «Ekwëya», gayik are baxo rend: «Kaxanu rëca ke xwëya këme ɗek toro indam iŋ, do gë ɗek ekun ed faba ed seɓëgu këme el.» ");
INSERT INTO bsc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","W̃ac këŋo lëmëta ixinëm in Efërayim, mëne ngëŋ «Ecënar», gayikwa are baxo rend: «Kaxanu wa rëca ke këme ŝënand ro gër ebar ed ŝëmura baxe.» ");
INSERT INTO bsc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ɓëniy ɓënjongëɓëki ɓënd gë eƴamb ed mbaŋ na gër ebar ed Misëra ɓëŋ xucak. ");
INSERT INTO bsc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ata ỹanak ngwa ɓëniy ɓënjongëɓëki ɓënd gë enjo ɓëŋ, ang reƴa baxo Yosef ak. Ata enjo eŋ ɓeñëtak ɗek owar oŋ. Ɓarikan gër ebar ed Misëra, eƴamb ƴamb hi bax na. ");
INSERT INTO bsc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","And ỹana këɓi enjo ɗek ebar ed Misëra aŋ, ɓulunda in sesan këno Farawoŋ, eni cotaxën eƴamb ƴamb in. Farawoŋ fel këɓi ɗek ebar ed Misëra el: «Ƴeyin eno wat Yosef, do diyindën ang këŋun fel ak.» ");
INSERT INTO bsc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Enjo eŋ mokuma dëŋ xuma bax ɗek ebar ed Misëra el. Yosef fel këɓi ɓër bax riyenind gë mëŋ ɓën eni përëtëra ɗek ɓaciw̃ ɓand gë eƴamb ed ŝacëra bani ɓaŋ, do enëɓi panënd eƴamb el Ɓëmisëra ɓën. Enjo eŋ kwël dëŋ bax ƴëkand gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ngwën iŋ ɗek bani ƴowërawënd gër ebar ed Misëra, gër Yosef, eni yëcëra eƴamb ƴamb in. Gayikwa enjo eŋ mbaŋ ƴëka bax ɗek ngwën iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakob wël ko mëne eƴamb ƴamb ex na gër ebar ed Misëra. Ata fel këɓi oɓaŝ orexëm ol: «Inew̃a ɓayi kën ro kën nëkondërënd?» ");
INSERT INTO bsc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Re ko: «Awël wël këme mëne eƴamb ƴamb ex na gër Misëra. Cëlayin enëɓo yëcënëgu, ene ɓayixëne ɓëɓëngw, cësërëxe enjo eŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ɓëmaỹe epëxw ɓënd Yosef ŝëla bax gër ebar ed Misëra eni yëcëgu bële in. ");
INSERT INTO bsc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Beŋëŝame, ar acël amat gë Yosef an cëŋ, Yakob aŋo teɓ bana exo ƴe. Are baxo rend: «Ayëda yëda këme eŋo gix etëm.» ");
INSERT INTO bsc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ata ɓosëñiw̃ ɓor Isërayel ƴow këni gër ebar ed Misëra, eni yëcëra eƴamb ƴamb in. Fedër këni gë ɗek ɓela ɓër bax ƴend gë oɓal oko fo ɓën. Gayikwa enjo eŋo ari baɓi rind ɓëte gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Amëd aŋo ebaxo Yosef gofërëne ir ebar ed Misëra in. Mëŋ ebax alëngw ar ɓër baɓi fanënd eƴamb ƴamb ɓulunda in, ɗek ebar ed Misëra an. Ata ga h̃atëgu këni ɓoɓinëm, foxi këni gër lëngw irexëm, eƴiỹ el ŋëŝ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosef ga wat këɓi, xwita këɓi. Ɓarikan ko rind ang ar aɓi nang ex na fo. Ga wërëna ko, w̃ëka këɓi: «Feye wa xaniw kën?» Yaka këni: «Gër ebar ed Kanahaŋ xaniw këmi. Eyëc ed eƴamb eƴamb ƴow këmi.» ");
INSERT INTO bsc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosef aye xwita baɓi ɓoɓinëm, ɓari ɓën ano kwita bana. ");
INSERT INTO bsc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosef xwita ko oɗakeli od lakeli baxo endeɓën ok. Re këɓi ɓëte: «Wën ɓëw̃er ɓësitik wa hi kën! Enang ed ed sitarak ebar edeɓi el ƴow kën!» ");
INSERT INTO bsc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yaka këno: «Adokiŋ axwën! Eyëc ed eƴamb ƴamb ƴow këmi. ");
INSERT INTO bsc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ɓiyi ɗek, araɓat rëw̃ këɓo, ɗal këmi reƴand! Okaɗëp odeƴ hi këmi, ami gi ex na ɓëw̃er ɓësitik!» ");
INSERT INTO bsc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosef re ko: «Anëgwëŝ kën rind! Enang ed ed sitarak ebar edeɓi el ƴow kën!» ");
INSERT INTO bsc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yaka këni: «Ɓiyi ɓela epëxw gë ɓëxi hi këmi gër eɓaỹër edeɓi, ɗek sëm iɓat, fën gër ebar ed Kanahaŋ. Imejanak iŋ ɓayiw këni gë faba, ɓari aɓat axo bo ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Re ko ɓëte Yosef: «Ga fel këmun wa, ɓëw̃er ɓësitik hi kën! ");
INSERT INTO bsc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Me nangaxën ɗal kën reƴand, eŋo kën ri. Gër ow̃ac or Farawoŋ, amun teɓët na xarak axo ƴow ex na pere imejanak indewën iŋ. ");
INSERT INTO bsc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ɗaw̃ënino ngëŋ aɓat eŋo ƴen. Wën ɓër kë ɓayi ɓën, eno cëni gër epëra. Mondako këmun ri me nangaxën ba ɗal reƴa kën. Gër ow̃ac or Farawoŋ, ɓëw̃er ɓësitik hi kën, angëmëne an di ex na mondako!» ");
INSERT INTO bsc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ata mondako fëra baɓi ɓakey ɓatas. ");
INSERT INTO bsc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Yatir akey atasën, Yosef fel këɓi: «Awël nde, mondako kën ri en ɓayixën ɓëɓëngw. Wëno ayëda wa këmo yëdand Kaxanu! ");
INSERT INTO bsc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Angëmëne ɗal dëŋ kën reƴand, ɓayilexo aɓat gër epëra. Wën ɓëjo ƴeyin enëɓi mëlan eƴamb ƴamb in ɓër gër oxun orewën ɓën, në edi eɓi enjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Do mëlanëguɗëne imaỹe imejanak indewën iŋ me nangaxën mëne ɗal ex eyeƴan edewën el, do ata fo ɓayik an cës na.» Ata ri këni mondako. ");
INSERT INTO bsc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ɓën këni rexërënd: «Enimin, ɓiyi mbaŋ w̃enan banëŋone ar eɓaỹër edeɓi an. Gayikwa awat dëŋ bane watënde ang ŝëmu baŋo ak, and baxo rend eɓo kaỹënan endexëm aŋ, ɓari ɓiyi anëŋo ɓaxët baxe na. Mëŋ wa ŝëmuraxën këɓo mondako.» ");
INSERT INTO bsc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Re ko Ruben: «Amun pel bana nde: “Këreno dinan na eñëŋënax itox iŋo!” Ɓari wën ane ɓaxët bana. Gërëgako ecës edexëm el këɓo ɓakaxënënd.» ");
INSERT INTO bsc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ani nang bana mëne ɗek baɓi wëlënd Yosef, gayik and baɓi yeƴanelind aŋ, ala baɓi h̃atelindërënd. ");
INSERT INTO bsc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ata Yosef nacëta këɓi exo tesëgu. Ɓakaw ko eɓi pelëra. Sana këŋo Simewoŋ do re ko eno mëla gër epëra ogës odeɓën. ");
INSERT INTO bsc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosef fel këɓi ɓëriyenin ɓërexëm ɓën eni cël bële in gër ojaɓote od ɓoɓinëm. Fel këɓi ɓëte eni maŝ koɗi ir ala kala in gër ojaɓote, do enëɓi yël ŝëlafana. Ɓëriyenin ɓën ri këni mondako. ");
INSERT INTO bsc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ɓoɓinëm ɓor Yosef xapëra këni ojaɓote od bële ok, lëɓindëra kënëɓi opali odeɓën ok do kwël w̃aỹi këni. ");
INSERT INTO bsc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Gër akwëndaya, aɓat fët ko jaɓote irexëm in eŋo yëlaxën ondës fali irexëm in. Ga fët ko jaɓote in, sëk ko koɗi in ƴaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ata fel këɓi ɓoɓinëm: «Aw̃aŝ w̃aŝ këne koɗi iram in, nëkoɗa ro gër jaɓote!» Ata ga ŝaran këɓi, këɓi rëgënënd anjiỹ aŋ, do këni w̃ëkarënd: «Ine rixëra këɓo mondako Kaxanu?» ");
INSERT INTO bsc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","And h̃at këni gër sëm ireɓën Yakob aŋ, gër ebar ed Kanahaŋ, sëfëtan këno ɗek end sëkëgu këɓi eŋ. Re këni: ");
INSERT INTO bsc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Asoŝan ar hik alëngw ar ebar an rexëraw këɓo gë oxeỹ. Nagaŝan këɓo mëne ɓëw̃er ɓësitik hi këmi, gër ebar edexëm. ");
INSERT INTO bsc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Yaka këmo: “Ɗal këmi reƴand, ami gi ex na ɓëw̃er ɓësitik! ");
INSERT INTO bsc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Epëxw gë ɓëxi hi këmi ɗek sëm imat fo, ɓari aɓat axo bo ex na. Imejanak iŋ ɓayiwëk doro gë faba gër ebar ed Kanahaŋ.” ");
INSERT INTO bsc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mëŋ yaka këɓo: “Mondako këne riye me nangaxën ɗal kën reƴand. Aɓat këno seɓ ro gër ndam, enëɓi mëlanaxën eƴamb ƴamb in ɓër gër oxun orewën ɓën gayikwa anëka këɓi rind enjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Do mëlanëguɗëne imaỹe imejanak indewën iŋ me maxën mëne ɗal kën reƴand, an gi ex na ɓëw̃er ɓësitik. Aŋo fo këmun w̃aŝ imaỹe indewën iŋ, do en korënd en pandëra gër ebar edam ro.”» ");
INSERT INTO bsc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ata fëtëra këni ojaɓote aŋ, ala kala sëk ko imboto ind koɗi irexëm iŋ. Ga wat këni koɗi ijo, yëdara këni ɓën ɗek gë sëm ireɓën ak. ");
INSERT INTO bsc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ata sëm ireɓën Yakob re ko: «Në endewën ke nemëranaxën ɗek oɓaŝ oram ol! Yosef axo bo ex na, ɓëte Simewoŋ axo bo ex na, do ỹandi këŋun ɓëte ene kan Beŋëŝame! Wëno ke wëcanënd ɓeŋo ɗek!» ");
INSERT INTO bsc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben yaka ko: «Ɗaw̃iɗëɓi ɓëtoŝan ɓëki ɓëndam ɓëŋ, angëmëne ami ɓakalinëgu ex na! Kwëtënanële wëno, aye këmo ɓakaliw.» ");
INSERT INTO bsc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaka ko sëm: «Asëñiw̃ën axo ƴe na gë wën gayik aɓinëm aŝës ŝës ko, do gaɓat ɓayi ko. Eŋo gixënd ỹeỹ gër fëña, okoỹ od këmun xoỹën ok ke law̃ ga xor këne ako!» ");
INSERT INTO bsc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ɓarikan enjo eŋ mokuma xuma bax gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","And faỹ këni eƴamb ƴamb ed yëcëgu bani gër Misëra aŋ, sëm ireɓën re ko: «Ɓakayin enëɓo yëcënëgu tëkër eƴamb ƴamb in.» ");
INSERT INTO bsc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yaka ko Yuda: «Alëngw ar ebar ed Misëra an, aye fel baɓo: “Angëmëne an tëfërëgu ex na gë aɓaỹe arewën, ala aŋun teɓëɗ na ene watëre.” ");
INSERT INTO bsc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Awa angëmëne aw̃a w̃a këƴ eƴo teɓ mi tëfër gë aɓaỹe areɓi, aŝëla këmi ŝëla mi yëcënëgu eƴamb ƴamb in. ");
INSERT INTO bsc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ɓari angëmëne aƴ ma ex na eƴo teɓ mi ƴe gë mëŋ, ami ƴe na ngëŋ, gayik ala ajo are re ko: “Ala aŋun teɓ na ene watëre angëmëne aɓaỹe arewën axo gi ex na gë wën”.» ");
INSERT INTO bsc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ata re ko Isërayel: «Inew̃a felaxën bano ala ajo mëne aɓaỹe arewën ɓayiwëk na? Wën w̃enan ke ɗe!» ");
INSERT INTO bsc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yaka këni: «Yama mëŋ ga w̃ëkara këɓo endeɓi eŋ, do gë end gër ed xaniw këmi eŋ nde. Aw̃ëka w̃ëka këɓo: “Ga ko liya nde ɓayi ko sorix irewën? Imaỹe icëxe nde ŝot këno na?” Ɓiyi ayaka fo yaka këmi omëka odexëm ok. Axor nde xorëdomi mi nang mëne ata ko re: “Mëlanëgune aɓaỹe arewën!”» ");
INSERT INTO bsc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ata Yuda fel këŋo Isërayel: «Faba, teɓëlo Beŋëŝame mi tëfër gë wëno. Ƴelemi gë mëŋ ga ỹandi ỹandi këɓo ene ɓayiye ɓëɓëngw, wëj, gë ɓiyi, do gë oxun oreɓi oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Wëno ex anëkona arexëm an, wëno këƴe w̃ëkaɗ endexëm eŋ. Din ir din këmi w̃enan angëmëne ami maỹilinëgu ex na, angëmëne ami maŝati ex na Beŋëŝame. ");
INSERT INTO bsc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nëkoɗa ɓiyi anëka ɓakar domi ɓaki, kido abaƴo h̃ëpeli na.» ");
INSERT INTO bsc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ata Isërayel, sëm ireɓën, re ko: «Gayikako mondako ex, eŋo kën ri: cëlin gër ɓamote ɓandewën ɓeɓër gër ebar edeɓi elo ro ɓën, ɓeɓër këno fupaxënëx ala ajo: ogu onëngax, gë dingën, gë ɓeɓëlamb, do gë ongërëŝa. ");
INSERT INTO bsc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Meɗin nëmëc koɗi in: ir këno w̃aŝëx in, do gë ir kën yëcëraxënëgu in. Ɓakaliyin koɗi ir ŝël bani gër ojaɓote odewën in. Ɓamat axaŝa xaŝa këni. ");
INSERT INTO bsc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Awa tëfërin gë aɓaỹe arewën an, ɓakayin gër ala ajo. ");
INSERT INTO bsc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kaxanu, mëŋ ar xorëk ɓeỹ ɗek an, dilexo gër emëkw ed ala ajo axaỹënan irewën in. Do teɓëtuɗëleŋun en maỹiw gë aɓaỹe arewën ak, do gë Beŋëŝame ak! Wëno cëŋ, angëmëne anemëran këme nemëran wën oɓaŝ oram ol, nemëralexe.» ");
INSERT INTO bsc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ɓosëñiw̃ ɓor Yakob w̃ëlali këni ɓeɓër këno fupaxënëx ala ajo ɓën, ɓakali këni koɗi in në ɓakanji ɓaki, ang ỹap bax ak, do sëfër këni gë Beŋëŝame. Ŝëla këni gër ebar ed Misëra, do h̃at këni gër Yosef. ");
INSERT INTO bsc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","And wat ko Yosef mëne gë Beŋëŝame ak ƴow këni aŋ, fel këŋo alëngw ar iciw̃ indexëm an: «Mëlalëɓi ɓela ɓëjo gër iciw̃. Ŋaŝëlëɓi oyel do cemëranëxëyëɓi. Gayikwa ɓela ɓëjo gë wëno këmi ƴambëra goyat.» ");
INSERT INTO bsc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Asoŝan ajo ri ko end fel baŋo Yosef eŋ, w̃ëla këɓi gër Yosef ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","And w̃ëla kënëɓi gër Yosef ɓën aŋ, yëdara këni do këni rend: «Ga w̃ëlaw kënëɓo ako ro, end koɗi ir w̃aŝ bani gër ojaɓote odeɓi and ƴow bane añanar eŋ ex ɗe. Aw̃ëlën kënëɓo w̃ëlën, enëɓo tërara gë opali ak, do enëɓo di okaɗëp!» ");
INSERT INTO bsc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ata yeƴaneli këno anëkona ar iciw̃ ind Yosef an gër ebët ed iciw̃. ");
INSERT INTO bsc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Re këni: «Axwën, teɓanëlëɓo. Ɓiyi aƴow ƴow bami amat gër eyëc ed eƴamb ƴamb. ");
INSERT INTO bsc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ga këmi w̃aỹi, h̃at këmi gër ed këmi seyëtand. Ga fëtëra këmi olëɓ oreɓi oŋ, sëk këmi ala kala ang w̃ëlaw baxo ak koɗi ir yëcëraxën ko in polo gër jaɓote irexëm. Nëkoɗ ga ɓakaliw këmi koɗi ijo. ");
INSERT INTO bsc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Aw̃ëlaw w̃ëlaw këmi koɗi ir këmi yëcaxën eƴamb in, gë ir w̃aŝ bani gër olëɓ oreɓi in, ɓiyi ami nang ex na ba noỹo w̃aŝ këɓo.» ");
INSERT INTO bsc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yaka ko alëngw an: «Ñëmin, këren yëdara na! Kaxanu, ar xwën këŋun an, Kaxanu ar yata këŋo sorix irewën an, w̃aŝëk koɗi ijo polo gër ojaɓote odewën. Koɗi irewën in, wëno axana xana këme.» Ata ga fërëtëgu këŋo Simewoŋ, sëk këɓi na gër iciw̃. ");
INSERT INTO bsc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ala ajo w̃ëla këɓi lëf gër iciw̃ ind Yosef. Yël këɓi men oŋ do neɓara këni osapar oŋ. Yël këɓi ɓëte opali ok er këni ƴamb in. ");
INSERT INTO bsc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yëpëtëra këni ɓeɓër këno fupaxën Yosef ɓën, ŝënixën këno exo maỹiw goyat. Gayikwa afel fel banëɓi mëne na gër iciw̃ ind Yosef këni ƴambëra. ");
INSERT INTO bsc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","And h̃atëgu ko Yosef aŋ, fupa këno gë ɓeɓër w̃ëlanëgu bano ɓën, do foxi këni ŋëŝ gër ebar gër lëngw irexëm. ");
INSERT INTO bsc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ata ga ŝëma këɓi, w̃ëka këɓi: «Sorix irewën, axarëk ar felëra bane an, aye fo nde seɓëgu këno? Ga ko liyand nde ɓayi ko?» ");
INSERT INTO bsc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yaka këno: «Xaɗëp ireƴ in, faba ireɓi, aye fo seɓëgu këmo. Ga ko liya ɓayi ko!» Ga rëngw këni, foxi këni. ");
INSERT INTO bsc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ata ga rënëta ko Yosef, wat këŋo Beŋëŝame, ar acël amat gë mëŋ an. Re ko: «Ajo nde ex imejanak indewën ind fel bane iŋ?» Ɓaŝ ko: «Kaxanu yëlëlexi oɓetak ol, Asëñiw̃ën!» ");
INSERT INTO bsc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosef anëngan nëngan baŋo gër yomb irexëm ga wat këŋo ar acël amat gë mëŋ an. Ata ỹandi këŋo exo tes. Lil ko ɓoxay në aciw̃, do ko sesëxënd. ");
INSERT INTO bsc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","And rëxasaw ko aŋ, ŝanëgu ko, do ko xemënarand këdi ko ses. Re ko: «Dëtin ecemar el.» ");
INSERT INTO bsc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Rëtën këno mëŋ pit. Rëtën kënëɓi pit ɓoɓinëm, pit Ɓëmisëra ɓër bani ƴambërand ɓën, gayikwa Ɓëmisëra ɓën abani w̃a na eni ƴambëra andamat gë ɓërandëw̃ëra and Eber ɓën, aŝëɓa ŝëɓa baɓi. ");
INSERT INTO bsc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ɓoɓinëm ɓor Yosef ỹëpara këni gër lëngw irexëm. Ỹëpa ko pere ar ebax itoŝan ikarënak an ang ỹapëk oxarënak orexëm ak, felata ko imejanak iŋ, ang ỹapëk ak. Ata këni nëkondërënd ga ŝaran këɓi. ");
INSERT INTO bsc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosef re ko enëɓi yëlëra er rëɗën bano mëŋ in. Edët ed Beŋëŝame el xuca bax ɓanjo ed ala kala el, ɗek ang ebani ak. Mondako ŝeɓëra bani xali ỹawëra këɓi. ");
INSERT INTO bsc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ga xucak eŋo, Yosef fel këŋo alëngw ar iciw̃ indexëm an: «Cëlëral eƴamb ƴamb in gër ojaɓote od ɓela ɓëjo, ang këni xor eni ɗëɓi ak. Ɓëte maŝiɗ koɗi ir ala kala in gër jaɓote irexëm. ");
INSERT INTO bsc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Cëliɗ ɓëte gër jaɓote ir amejanak areɓën an akalama and koɗi andam aŋ, do gë koɗi ir yëcaxën ko eƴamb ƴamb in.» Ata alëngw an ri ko ang fel baŋo Yosef ak. ");
INSERT INTO bsc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Në ecan ijo, seɓ kënëɓi mopëɗ gëɓër ɓosëñiw̃ ɓor Yakob do kwël këni w̃aỹind gë opali odeɓën ok. ");
INSERT INTO bsc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ga këni këni ŝan angol aŋ, ani ŋaw̃ bana pere, Yosef fel këŋo alëngw ar iciw̃ indexëm an: «Tëfëlëɓi ɓela ɓëjo eƴëɓi tëraw. Mëkayiɗëɓi: “Inew̃a w̃aŝënaxën këno eñëŋënax ar rin këŋun enjekax an? ");
INSERT INTO bsc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ax gi ex na nde akalama and ko ŝeɓëraxënënd axwën aram aŋ rekaw kën? Ax gi ex na nde gë aŋo ko ŝakixënënd? End ri kën eŋo, ax ye ex na!”» ");
INSERT INTO bsc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Alëngw an ga sëkëx këɓi ɓoɓinëm ɓor Yosef, felëx këɓi ɗek ɓeŋo. ");
INSERT INTO bsc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yaka këno: «E faba, inew̃a këƴ yeƴanaxënënd mondako? Ɓiyi ax mënd ex na mi di endako rako eŋ, ɓiyi okaɗëp odeƴ ok! ");
INSERT INTO bsc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Elod gër ebar ed Kanahaŋ ga ɓakaliw këmi wa koɗi ir sëk këmi gër ojaɓote odeɓi in. Mondake cëŋ këmi xor mi deka koɗi, ba kaŋe, gër iciw̃ ind axwën areƴ? ");
INSERT INTO bsc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Faba, angëmëne akalama aŋo në ala sëk këƴ na, awa mëŋ ar eɗaw̃ hi ko, do ɓiyi kwënayayiɗëɓo oxaɗëp!» ");
INSERT INTO bsc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yaka këɓi alëngw an: «Awa gilex gërëgako dëŋ, ang re kën ak! Gër ar këme sëk yo, mëŋ kë hi xaɗëp iram in, do wën kwël këmun seɓëɗ en ƴe.» ");
INSERT INTO bsc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ala kala w̃ara ko fedali ko gër ebar eɗëɓi edexëm el, do fët ko jaɓote in. ");
INSERT INTO bsc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Alëngw an ỹana ko ocal ok gër axarënak, felata ko gër aɓejanak. Sëk ko akalama aŋ gër jaɓote ir Beŋëŝame. ");
INSERT INTO bsc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ata ga wat këni eŋo, h̃esëra këni ɓanjëm ɓandeɓën ɓaŋ. Ala kala lëɓindëra këŋo gaŝëxe fali irexëm in, do ɓaka këni gër angol. ");
INSERT INTO bsc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda do gë ɓoɓinëm h̃at këni gër iciw̃ ind Yosef. Ga sëk këno na, foxi këni gër lëngw irexëm dëxas in gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ata w̃ëka këɓi Yosef: «Inew̃a rixën kën eŋo? An nang ex na nde mëne ala ar ang wëno ako awat këme watënd?» ");
INSERT INTO bsc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yaka ko Yuda: «Axwën, ɓiyi ine këmi xor mi de? Mondake këmi yeƴan? Mondake këmi ƴax? Kaxanu ŝonëtëk amena andeɓi aŋ. Awa okaɗëp odeƴ hi këmi, andamat gë ar xana këƴ akalama andeƴ an!» ");
INSERT INTO bsc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Re ko Yosef: «Ɓëtëdëŋ, ame di na eŋo! Gër ar xana këme akalama fo kë hi xaɗëp iram in. Wën cëŋ, maỹiyin aye fo gër sorix irewën.» ");
INSERT INTO bsc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda sëka këŋo Yosef, do re ko: «Teɓanële Axwën aram! Axara xara këmi ɓaxëtële mi pel emat. Këreƴe koỹën na wëno xaɗëp ireƴ in, gayikwa wëj ang Farawoŋ fo hi këƴ! ");
INSERT INTO bsc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Wëj w̃ëka baɓo ɓiyi okaɗëp odeƴ ok ba aɓëngw ɓayi ko faba ireɓi, ba imaỹe ŝot këmo na icëxe.» ");
INSERT INTO bsc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Yaka këmi: «Na ɓayi ko faba, mokar xar ko, do ɓëte imaỹe imejanak ŝot këmo na, itoŝan ind rëw̃ këŋo gër oxar orexëm iŋ. Ar acël amat gë mëŋ an anemi nemi ko, do mëŋ gaɓat ɓayik gër nëm, sëm moŋan h̃an këŋo. ");
INSERT INTO bsc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Wëj fel baɓo: “Mëlanëgune, aỹandi ỹandi ke mo wat.” ");
INSERT INTO bsc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yaka bami: “Awël nde axwën, lëmëta ijo ani ŋaw̃ëtarënd na gë sëm. Angëmëne aŝapër ŝapër këni, sëm ata ko ŝës!” ");
INSERT INTO bsc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Fel baƴëɓo ɓëte: “Angëmëne imaỹe imejanak indewën iŋ axo ƴow ex na gë wën, ala aŋun teɓëɗ na ene watëre gë wëno.” ");
INSERT INTO bsc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","And ɓaka këmi gër faba ireɓi, xaɗëp ireƴ aŋ, sëfëtanëx këmo ɗek ɓend fel baƴëɓo ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Faba ireɓi re ko: “Ɓakayin enëɓo yëcënëgu tëkër eƴamb ƴamb in.” ");
INSERT INTO bsc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Yaka këmo: “Angëmëne ami tëfër ex na gë imaỹe imejanak indeɓi iŋ, ami kor na mi ɓaka. Aɓaka këmi ɓaka, angëmëne gë imaỹe imejanak indeɓi iŋ sëfër këmi. Ɓarikan ami korëɗ na mi watër gë ala ajo angëmëne imaỹe imejanak indeɓi iŋ axo gi ex na gë ɓiyi.” ");
INSERT INTO bsc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Re ko faba: “Anang nang kën mëne alindaw̃ën ɓëtox ɓëki fo ŝotën ke. ");
INSERT INTO bsc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Iñanar iŋ anem nem këmo, do wëndan ke mëne emacar w̃anagëtëra këŋo, xali doro amo wat ex na! ");
INSERT INTO bsc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Angëmëne ene kwëcët ɓëte iŋo ro, do eŋo giw etëm gër fëña, oxoỹ or këmun xoỹën ol ke law̃ ga xar këme ako.” ");
INSERT INTO bsc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Gërëgako, mondake wa këme ɓaka wëno gër faba, xarak ami tëfër ex na gë lëmëta ir lëka këŋo mbaŋ ijo in? ");
INSERT INTO bsc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Ata ko ŝës sam exo wat mëne lëmëta in axo bo ex na. Ɓiyi mbaŋ këmi w̃endëra angëmëne faba ireɓi në end oxoỹ or xoỹën këɓo ŝës ko ga xar ko ako! ");
INSERT INTO bsc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gayikwa wëno xaɗëp ireƴ in ŝanayak anëkona ar lëmëta an. Afel fel bamo: “Faba amena and din ir din këmi w̃enan angëmëne ami ɓakalinëgu ex na!” ");
INSERT INTO bsc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Gërëgako, axwën këla teɓële me nëmba wëno oxaɗëp ol gër ed ebax exo gi lëmëta ijo. Teɓëlo lëmëta in eni maỹi gë ɓoɓinëm! ");
INSERT INTO bsc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Wëno mondake këme xor me ɓaka gër faba angëmëne lëmëta in axo gi ex na? Këreme wat na wa kata ind këŋo wëcan faba iŋ!» ");
INSERT INTO bsc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","And h̃ata ko Yuda aŋ, Yosef ɗek ỹëm baŋo ongwën oŋ gër ɓangës, ogës od ɗek ɓëriyenin ɓërexëm. Ata xeỹ ko: «Wën ɗek canin!» Ariyenin gaɓatak ax ɓayi bana na gë Yosef and xwitar këni gë ɓoɓinëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ga ko ses këno wëlënd Ɓëmisëra ɓën xali gër eyang ed Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosef fel këɓi ɓoɓinëm: «Wëno ex Yosef! Faba ga ko liya nde ɓayi ko?» Ɓarikan, ɓoɓinëm ga yëɓura këɓi, sëkwan këni eno yaka in ga faɓër bani gë mëŋ. ");
INSERT INTO bsc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Re ko ɓëte Yosef: «Axara xara këmun tëkawëne tan.» And sëka këno aŋ, re ko gaŝëxe: «Wëno ex Yosef, aɓaỹe arewën an, ar fan bano do w̃ëlaw këno ɓër yëc bano ɓën ro gër ebar ed Misëra an. ");
INSERT INTO bsc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Gërëgako, këren yëdara na, do këreŋun cena na ba ine fanaxën bane. Gayikwa eni pexaxën ɓela lëngwalixënëgu ke Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yosef fel këɓi ɓëte: «Ɓëniy ɓëki xucak elod ga ỹanak enjo eŋ gër ebar ed Misëra. Ɓëte ɓëniy ɓënjo ɓënd kë ƴowënd ɓëŋ, ala ax ñandëra na, ala ax kanara na. ");
INSERT INTO bsc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kaxanu wa lëngwaligu ke ex ɓayixën enëng endeɓi eŋ gër ebar elo ro, do ene ɓayixëne ɓëɓëngw. Mëŋ wa racët këɓo gë panga itëm. ");
INSERT INTO bsc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Enimin, Kaxanu law̃ënëgu ke ro, ax gi ex na wën. Mëŋ ri ke hi këme sëm ir Farawoŋ, alëngw ar gër iciw̃ indexëm, gofërëner ir ɗek ebar ed Misëra in. ");
INSERT INTO bsc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Marayin en ɓaka ƴaŋ gër faba. And kën h̃at aŋ, deyiɗën ga re ko asëñix Yosef: Kaxanu ri ke alëngw ar ɗek ebar ed Misëra el. Cëlaw gër ndam ro, këreƴ përëraw na. ");
INSERT INTO bsc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gër ebar ed Goŝen këƴ ỹëpati, do mondako këne sëkare wëj gë wëno, gë ɓosëñix, gë ejix ɓën, gë oɓeci ol, gë opeỹ ok, gë oxeƴ ol, gë ogelemba ok, do gë ɗek ɓeɓër xwën këƴ ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ro wëno kë ỹana exi yëlënd er kën liyaxën wëj, gë ɓër iciw̃ indeƴ in, do er xwën këƴ in, geɓatak ax nemi na. Gayikwa ɓëniy ɓënjo ɓayik ɓënd gë enjo ɓëŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yosef re ko ɓëte: «Awat kën watënd gë ɓangës ɓandewën ɓaŋ. Do Beŋëŝame, ar acël amat gë wëno an, awat ko watënd gë ɓangës ɓandexëm ɓaŋ, mëne wëno dëŋ këŋun felërand. ");
INSERT INTO bsc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tëfëtanëxëɗëno faba ɗek enjaran end ŝot këme ro gër ebar ed Misëra eŋ, do gë ɗek ɓeɓër wateli kën ɓën. Awa marayin eno mëlaw ro faba.» ");
INSERT INTO bsc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ata w̃ega këŋo gër egëla Beŋëŝame, ar acël amat gë mëŋ an, këni sesënd mëŋ do gë Beŋëŝame. ");
INSERT INTO bsc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Gë otes fo w̃egara këɓi ɗek ɓoɓinëm. And xofëtar këni mondako aŋ fo, xor bani ɓoɓinëm eno yeƴaneli. ");
INSERT INTO bsc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ata wëlik gër eyang ed Farawoŋ mëne ɓoɓinëm ɓor Yosef h̃atëguk. Farawoŋ do gë ɓër eyang edexëm ɓën nëngan këɓi. ");
INSERT INTO bsc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farawoŋ fel këŋo Yosef: «Pelëlëɓi ɓoɓinëx mondako kën ri: ɗëɓindërayinëɓi opali odewën ok, en ɓakaxën gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Meɗëgunëɓi sorix, do gë ɗek ɓër oxun orewën ɓën, do mëlawënëɓi ler gër ndam ro. Ayël këmun yël gër ed yek nëmëc ro gër ebar ed Misëra. Wën kë ỹana ex ƴambënd ɓeɓër nëngak nëmëc gër ebar elo ro ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Wëj fana këmi eƴëɓi pel: Meɗëyin ocaret ro gër Misëra, enëɓi mëlaxënëgu ɓolindaw̃ ɓorewën, gë oxun orewën oŋ. Mëlawëno ɓëte sorix irewën, dëfawën ro! ");
INSERT INTO bsc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","End ɓeɓër kën seɓëraw eŋ, këren yëlarand na gayik er yek nëmëc ro gër Misëra in wën kë xwën.» ");
INSERT INTO bsc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ɓosëñiw̃ ɓor Isërayel ri këni mondako. Yosef yël këɓi ocaret ang fel baŋo Farawoŋ ak. Yël këɓi ɓëte ocëlafana eni ƴambëx gër fëña. ");
INSERT INTO bsc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yël këɓi ala kala acuɗ angaŝax. Yël këŋo Beŋëŝame ɓatama okeme otas ɓand koɗi, do gë ɓacuɗ ɓangaŝax ɓanjo. ");
INSERT INTO bsc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ata Yosef law̃ëneli këɓi gër sëm, opali epëxw od lëɓindëra banëɓi ɓeɓër nëngak nëmëc gër ebar ed Misëra ɓën, do gë opali onëm epëxw od lëɓindëra banëɓi bële, gë mburu, do gë ɓeɓëƴamb ƴamb. Ɓeɓijo bax ŝëlafana ir ko rixënëgu Yakob ɗamana irexëm in. ");
INSERT INTO bsc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ga xani këni oñe oŋ, Yosef fel këɓi ɓoɓinëm: «Këreŋun takërëx na ɗe gër fëña!» ");
INSERT INTO bsc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Mondako xani bani na gër ebar ed Misëra do h̃at këni gër ed Kanahaŋ, gër Yakob, sëm ireɓën. ");
INSERT INTO bsc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Fel këno Yakob: «Yosef ga ko liya ɓayi ko, axo cës ex na. Mëŋ ex alëngw ar ebar ed Misëra an!» Ɓarikan Yakob ỹoweỹ aŋo gi bana gayik axo ma bana end bano felënd eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Sëfëtandëra këno ɗek ɓend felëgu baɓi Yosef ɓeŋ. Wat ko ocaret od law̃ëneliw baxo Yosef eno mëlaxën ok. Ata sëm ireɓën Yakob fuŋara këŋo gër onden ondexëm. ");
INSERT INTO bsc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isërayel re ko: «Gwac ex go! Asëñiw̃ën Yosef ga ko liya ɓayi ko! Ƴeleme mo watëgu ɗamana me cësaxën!» ");
INSERT INTO bsc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Awa Isërayel ɓarëra ko ngwa ɗek ɓeɓër xwën ko ɓën, do xani ko ond gër Misëra oŋ. H̃at ko gër Berëŝeba do rix ko ocaɗaxa eŋo calexën Kaxanu, ar yata këŋo sëm Isak an. ");
INSERT INTO bsc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ata Kaxanu felëra këŋo Isërayel gëmëɗ në lakeli. W̃ac këŋo: «Yakob! Yakob!» Yaka ko mëŋ: «Woy!» ");
INSERT INTO bsc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Re ko Kaxanu: «Wëno ex Kaxanu, Kaxanu, ar yata këŋo sorix an. Këreƴ yëdara na ga këƴ ŝëland ako gër ebar ed Misëra, gayikwa fën këmëni ŝënanëgu ɓërandëw̃ëra andeƴ ɓën, xali eni gi ɓulunda isëm. ");
INSERT INTO bsc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Wëno alaŋëta këmi laŋëtand gër ebar ed Misëra. Ɓëte wëno fo këɓi nëcëtëguɗ ɓërandëw̃ëra andeƴ ɓën. Yosef kë ɓakali ɓangës ɓandeƴ ɓaŋ gë ataxan andexëm aŋ, yatir këƴ ŝës.» ");
INSERT INTO bsc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakob xani ko na gër Berëŝeba. Ɓosëñiw̃ ɓor Isërayel w̃ëla këno sëm ireɓën, gë ɓësoxari ɓëreɓën ak, do gë oxun oreɓën ak ɗek, gër ocaret od yëlëgu baɓi Farawoŋ enëɓi mëlaxën ok. ");
INSERT INTO bsc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Fac kënëɓi ɓëte oyel ol, do gë ɓeɓër ŝotëra bani gër ebar ed Kanahaŋ ɓën. Yakob do gë ɓërandëw̃ëra andexëm ɓën mondako rëfa bani gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Aw̃ëla w̃ëla baxo gër ebar ed Misëra ɗek andëw̃ëra andexëm aŋ: ɓosëñiw̃, gë ɓoɓiw̃, do gë ɓër ebax ejiw̃ edexëm ɓën, ɓëtoŝan ɓëŋ do gë ɓëtoxari ɓëŋ. ");
INSERT INTO bsc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mondako bax omac od ɓosëñiw̃ ɓor Isërayel ɓor ƴe bax gër ebar ed Misëra ɓën: Yakob do gë ɓosëñiw̃. Itoŝan iñanar ind Yakob iŋ: Ruben. ");
INSERT INTO bsc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ɓosëñiw̃ ɓor Ruben: Enok, gë Palu, gë Hesëroŋ do gë Karëmi. ");
INSERT INTO bsc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ɓosëñiw̃ ɓor Simewoŋ: Yemuwel, gë Yamin, gë Oxad, gë Yakin, gë Tësowar, do gë Sawul, asëñiw̃ ar asoxari aɓëkanahaŋ an. ");
INSERT INTO bsc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ɓosëñiw̃ ɓor Lewi: Gerëŝoŋ, gë Kehat, do gë Merari. ");
INSERT INTO bsc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ɓosëñiw̃ ɓor Yuda: Er, gë Onan, gë Ŝela, gë Peres, do gë Sera. Ɓarikan, Er do gë Onan anëka ŝës bani amëd aŋo gër ebar ed Kanahaŋ. Ɓosëñiw̃ ɓor Peres: Hesëroŋ do gë Hamul. ");
INSERT INTO bsc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ɓosëñiw̃ ɓor Isakar: Tola, gë Pufa, gë Yob, do gë Ŝimëroŋ. ");
INSERT INTO bsc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ɓosëñiw̃ ɓor Sabuloŋ: Sered, gë Eloŋ, do gë Yahëlel. ");
INSERT INTO bsc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ɓën ex oɓaŝ or Leya ol, ɓëtoŝan ɓëŋ, do gë Dina, itoxari iŋ. Ɓën ex ɓër rëw̃ën këŋo Leya Yakob gër ebar ed Padaŋ-Aram ɓën. Ɓën ex ɓosëñiw̃ do gë ɓoɓiw̃, ɗek ang ebani ak: ɓën ɗek, ɓela ofëxw osas gë ɓësas. ");
INSERT INTO bsc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ɓosëñiw̃ ɓor Gad: Tësifiwoŋ, gë Hagi, gë Ŝuni, gë Etësëboŋ, gë Eri, gë Arodi, do gë Areli. ");
INSERT INTO bsc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ɓosëñiw̃ ɓor Aser: Yimëna, gë Yiŝëfa, gë Yiŝëfi, gë Beriya, do gë Sera, imaỹe itoxari indeɓën iŋ. Ɓosëñiw̃ ɓor Beriya: Eber do gë Malëkiyel. ");
INSERT INTO bsc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Mondako hi bani oɓaŝ or rëw̃ banëɓi Yakob do gë Silëpa ol, xaɗëp isoxari ir yël baŋo Labaŋ aɓiw̃ Leya in. Ɓën ex ɓër rëw̃ën këŋo Silëpa Yakob ɓën: ɓën ɗek, ɓela epëxw gë ɓëcongaɓat. ");
INSERT INTO bsc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ɓosëñiw̃ ɓor Raŝel, alindaw̃ ar Yakob: Yosef do gë Beŋëŝame. ");
INSERT INTO bsc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ɓosëñiw̃ ɓor Yosef, ɓër rëw̃ kënëɓi gër ebar ed Misëra gë alindaw̃ Asenet, aɓiw̃ ar Poti-Fera, aŝaɗaxan ar eɗaŝ ed On ɓën: Manase do gë Efërayim. ");
INSERT INTO bsc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ɓosëñiw̃ ɓor Beŋëŝame: Bela, gë Beker, gë Aŝëbel, gë Gera, gë Nahamaŋ, gë Ehi, gë Roŝ, gë Mupim, gë Hupim, do gë Arëd. ");
INSERT INTO bsc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ɓën ex ɓër rëw̃ën këŋo Raŝel Yakob ɓën: ɓën ɗek, ɓela epëxw gë ɓënax. ");
INSERT INTO bsc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Asëñiw̃ ar Dan: Huŝim. ");
INSERT INTO bsc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ɓosëñiw̃ ɓor Nefëtali: Yatësel, gë Guni, gë Yetëser, do gë Ŝilem. ");
INSERT INTO bsc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ɓën ex oɓaŝ or rëw̃ kënëɓi Yakob do gë Bila, xaɗëp isoxari ir yël baŋo Labaŋ Raŝel ol: ɓën ɗek, ɓela ɓëcongëɓëxi. ");
INSERT INTO bsc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ɓër sëfër bani gë Yakob gër ebar ed Misëra do hi bani ɓërandëw̃ëra andexëm ɓën er hi bani ɓën ɗek ɓela ofëxw ocongeɓat gë ɓëcongaɓat. Xarak, ɓolindaw̃ ɓor ɓosëñiw̃ ala aɓi pën bana. ");
INSERT INTO bsc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gë ɓosëñiw̃ ɓor Yosef ɓër rëw̃ kënëɓi gër ebar ed Misëra ɓën: ɓela ɓëxi. Er hi bani ekun ed Yakob el ɗek, ɓela ofëxw ocongoxi ɓër ƴow bax gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakob law̃ën këŋo Yuda gër Yosef, eŋo pelëx exo ɗëngwa gër Goŝen, eŋo kacax fën. Ata Yakob do gë odexëm h̃at këni gër ebar ed Goŝen. ");
INSERT INTO bsc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef w̃eɗ ko ŝaret irexëm in, do ƴe ko ƴaŋ gër Goŝen, gër ekaca ed sëm Isërayel. Sam ga ŝanayaw ko, Yosef w̃ëlën këŋo sëm, w̃ega këŋo bëxiɓ gër egëla, do ses ko xali gër egëla edexëm. ");
INSERT INTO bsc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ata Isërayel fel këŋo Yosef: «Ecës fo ɓayi ke gërëgako, gayikako awat wat këme mëne ga këƴ liya dëŋ ɓayi këƴ!» ");
INSERT INTO bsc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ga xucak eŋo, Yosef ga këni felar gë ɓoɓinëm do gë ɓër ekun ed sëm ɓën, re ko: «Aƴe këme ƴe mo tëfëtandërax Farawoŋ. Afel këmo fel: “Ɓëmaỹe ɓëndam ɓëŋ, do gë ɗek ekun ed faba el, anëka h̃atëgu këni gër ndam ro, ga xaniw këni gër ebar ed Kanahaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ɓëxaɗac ɓër oɓeci, gë opeỹ, gë oxeƴ, do gë ogelemba exëni. Ɓëxwël ɓër oyel exëni, do aw̃ëlaliw w̃ëlaliw kënëɓi oyel oreɓën ol, do gë ɗek ɓeɓër xwën këni ɓën.” ");
INSERT INTO bsc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","And këŋun w̃ac Farawoŋ, do eŋun mëka ba ine ex andiyen andewën aŋ, ");
INSERT INTO bsc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","yakayiɗëno: “Ɓiyi okaɗëp odeƴ ok, ɓëxwël ɓër oyel hi këmi. Aniyan andeɓi aŋ ex ekwël ed oyel, ang ebani ɓëxarëk ɓëreɓi ak.” And kën yeƴan mondako aŋ, ata këŋun fel en ɗëg gër ebar ed Goŝen. Gayikwa Ɓëmisëra ɓën mbaŋ ŝus këni ekwël ed oyel el hi këni opeỹ nde, hi këni oɓeci nde.» ");
INSERT INTO bsc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosef ƴe ko kwël eŋo tëfëtandërax Farawoŋ. Ga h̃at ko, re ko: «Faba do gë ɓëmaỹe ɓëndam ɓëŋ anëka h̃atëgu këni ga xaniw këni gër ebar ed Kanahaŋ. Aw̃ëlali w̃ëlaliw kënëɓi opeỹ ok, gë oɓeci ol, gë oxeƴ ol, do gë ɗek ɓeɓër xwën këni ɓën. Gër ebar ed Goŝen h̃atëgu këni.» ");
INSERT INTO bsc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ɓëmaỹe ɓënjo ɓëndexëm fel baɓi eno ɗaŋëta, eɓi watëgu Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ata Farawoŋ w̃ëka këɓi ɓoɓinëm ɓor Yosef: «Ine ex wa andiyen andewën aŋ?» Yaka këno: «Ɓiyi okaɗëp odeƴ ok, ɓëxwël ɓër oɓeci do gë opeỹ hi këmi, ang ebani ɓëxarëk ɓëreɓi ak.» ");
INSERT INTO bsc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Fel këno ɓëte Farawoŋ: «Oliyer ƴow këmi ro gër ebar edewën. Ondës ax bo ex na ond këni ƴamb oɓeci ol do gë opeỹ odeɓi ok, gayikwa enjo eŋ mbaŋ ƴëkak gër ebar ed Kanahaŋ. Gërëgako, axara xara këmi, teɓëlëɓo mi ñëpa gër ebar ed Goŝen.» ");
INSERT INTO bsc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farawoŋ fel këŋo Yosef: «Sorix gë ɓoɓinëx, gër ndeƴ ro h̃atëgu këni. ");
INSERT INTO bsc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misëra in ɗek, gër otaxan odeƴ ex. Kwëtëlëɓi sorix gë ɓoɓinëx gër ed xurik ex ye. Ɗëgëlexëni gër ebar ed Goŝen. Angëmëne gër enga endeɓën na fo exëni ɓër gapak, dilëɓi ɓëlëngw ɓër ɓëxaɗac ɓër oyel oram.» ");
INSERT INTO bsc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yosef w̃ëla këŋo ɓëte sëm Yakob gër Farawoŋ eni nangër. Ga këni ŝëmar, Yakob, ŝalen këŋo Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ata Farawoŋ w̃ëka këŋo Yakob: «Ɓëniy ɓënjëgwe wa ŝot këƴ?» ");
INSERT INTO bsc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob yaka këŋo Farawoŋ: «Ang nëkak aniyan and wëno ar kë ỹëparand ang aliyer fo gand ed këme ƴe yo, asëk sëk ke ɗe ɓëniy këme gë ofëxw osas. Ɓëniy ɓënd aniyan andam ɓëŋo ax ñëmb ex na do ax ye ex na ang ɓënd ɓëxarëk ɓëram ak ado ga bani ƴexërand ɓën ɓëte ang ɓëliyer fo.» ");
INSERT INTO bsc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakob ŝalen këŋo gaŝëxe Farawoŋ, do kwël ŝapër këni gë Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosef xwët këɓi sëm gë ɓoɓinëm gër ed xurik ex ye, gër ebar ed Misëra, gër ebar ed Ramëses, ang fel baŋo Farawoŋ ak. ");
INSERT INTO bsc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosef baɓi yëlënd eƴamb ƴamb in sëm, gë ɓoɓinëm, do gë ɗek oxun oreɓën oŋ, ang ỹëmb bani ak. ");
INSERT INTO bsc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Eƴamb ƴamb dëŋ ax ɓayi bana gër ed ex yo gër ebar ed Misëra, gayik enjo eŋ mokuri xuri bax. Hik gër Misëra, hik gër ebar ed Kanahaŋ, ɓela ɓën afiŝëra fiŝëra bani enjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ata Yosef xana ko ɗek koɗi ir gër ebar ed Misëra in, do ir gër ebar ed Kanahaŋ in, ir bani yëcaxënënd eƴamb ƴamb in. W̃ëxëta ko gër eyang ed Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","And faỹ këni koɗi Ɓëmisëra do gë Ɓëkanahaŋ aŋ, Ɓëmisëra ɓën ƴe këni gër Yosef, do re këni: «Yëlëlëɓo eƴamb ƴamb in! Ba mi cës ogës odeƴ nde ỹandi ki, gayikako koɗi aɓo bo ex na?» ");
INSERT INTO bsc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yaka këɓi Yosef: «Mëlawënëɓi oyel orewën ol enëɓi nëmb gë eƴamb ƴamb, gayikako koɗi ax gi ex na.» ");
INSERT INTO bsc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ata w̃ëlaraw kënëɓi oyel oreɓën ol gër Yosef, do mëŋ yël këɓi eƴamb ƴamb in. Oyel olo nëmb banëɓi: opanac, gë oɓeci, gë opeỹ, gë oxeƴ do gë opali. Yosef yëlëra këɓi eƴamb ƴamb in aniy aŋo gayik anëmb banëɓi nëmbënd oyel oreɓën ol xali faỹ kënëɓi ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","And xucak aniy aŋo aŋ, ɓakaw këni gër ndexëm. Re këni: «Axwën, ɓiyi ami con na mëne anëka faỹ këmi koɗi in. Ɓëte oyel oreɓi ol, wëj xwën këɓi. Er ɓayi këɓo wayët mi yëlaya ɓiyi dëŋ, do gë owar oreɓi oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ogës odeƴ nde këmi ŝësëra do mi teɓëta owar oreɓi oŋ? Yëcëlëɓo gë owar oreɓi ak, mi cotaxën er këmi ƴamb in. Kwënëleɓo Farawoŋ ɓiyi gë owar oreɓi ak. Yëlëlëɓo ɓeneɗa ɓend këmi ỹandëraxën, mi ɓayixën ɓëɓëngw, ata fo ɓayik ami cësëra na, do owar oreɓi oŋ ax cenëkëra na.» ");
INSERT INTO bsc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ata Yosef mondako yëcën baŋo Farawoŋ ɗek owar or gër Misëra oŋ. Ɓëmisëra ɓën fan baŋo ocënga odeɓën ok, gayik enjo eŋ mokuri xuri bax. Farawoŋ, elod amëd aŋo xwën ko ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ata rëfalira këɓi ɓulunda in gër ɓangol, ga ỹana ko beɓët iɓat h̃ata ko beɓët ijo ɗek ebar ed Misëra el. ");
INSERT INTO bsc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ɓarikan Yosef axo yëc bana owar or ɓëŝaɗaxan oŋ gayik apela ỹëgw baxo na Farawoŋ mëne kërexo yëc na. Gë er re baxo enëɓi yëlënd in fo bani liyand, mëŋ ɓayik ani panaxën bana owar oreɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosef fel këɓi ɓulunda in: «Anëka yëc këmun gë owar orewën ak, doro doro Farawoŋ xwën këŋun. Kanayin eneɗa eŋ en neɗëx gër ocënga. ");
INSERT INTO bsc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","And kën xanara eƴamb aŋ, tëƴiyindën, do acariya anjoxën kala, Farawoŋ xwënëk. Mëxwëtayindën mar er xana kën in en di ɓeneɗa, do mar enëɓi ɗëɓaxënënd ɓër gër ɓëciw̃ ɓëndewën, do gë oxun orewën ɓën.» ");
INSERT INTO bsc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yaka këni Ɓëmisëra ɓën: «Axwën, anëka fexën këƴëɓo. Gayikako oyekax oreƴ ol w̃asin këƴëɓo, aw̃a w̃a këɓi mi gi okaɗëp od Farawoŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ata acariya and ri baxo Yosef aŋo ɓayik xali doro gër ebar ed Misëra: ecoxën ed er ex yo, Farawoŋ xwënëk. Owar or ɓëŝaɗaxan oŋ fo ɓayik axo kwën bana Farawoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isërayel do gë ɓërandëw̃ëra andexëm ɓën ỹëpa këni na gër ebar ed Misëra, gër Goŝen. Yëcëra këni owar, rëw̃ kënëɓi oɓaŝ oranjëm, do kwël dëŋ këni ŝënarënd xali ỹëmb këni mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob liya ko ɓëniy epëxw gë ɓënjongëɓëki gër ebar ed Misëra. Mondako sëk baŋo ɓëniy këme gë ofëxw onax gë ɓënjongëɓëki. ");
INSERT INTO bsc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ga nang ko mëne anëka kë saxëgund ecës edexëm el, Isërayel w̃ac këŋo asëñiw̃ Yosef, do re ko: «Angëmëne ah̃an h̃an këƴe, ɗilaliw ataxan andeƴ aŋ gër emef endam. Axara xara këmi, ɗëkayayiɗ ŝenene end këmi felënd eŋo: këreƴe mëxwëtaɗ na ro gër ebar ed Misëra! ");
INSERT INTO bsc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","And këmi ɓar gër ecës gë ɓëxarëk ɓëram aŋ, nëcëtiɗëne ebar ed Misëra el, do mëlayiɗëne eƴe mëxwëtax gër ỹeg ireɓën.» Ata yaka ko Yosef: «Ari këme ri end fel këƴe eŋo.» ");
INSERT INTO bsc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Re ko ɓëte Yakob: «Awa yaŝarël.» Yosef yaŝar ko. Ata Isërayel foxi ko gand ogaf od angaw̃ andexëm. ");
INSERT INTO bsc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ga xucak eŋo, fel këno Yosef mëne sëm aŝëxwëra ex. Ata w̃ëla këɓi ɓosëñiw̃, Manase do gë Efërayim, gër ed laki baxo. ");
INSERT INTO bsc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Fel këno Yakob: «Asëñix Yosef anëka ƴow ko ɗe exi nëkon.» Isërayel xemënara ko xali xani ko, do ỹëpa ko gër angaw̃ andexëm. ");
INSERT INTO bsc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakob fel këŋo Yosef: «Kaxanu, mëŋ ar Fangak an, ŝanayaxën baxe gër Lus, gër ebar ed Kanahaŋ, do yël ke oɓetak ol. ");
INSERT INTO bsc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Er fel baxe: “Ar gë oɓaŝ oranjëm ri këmi, wëno këɓi ŝënandëra xali. Ɓëte wëno ki ri axarëk ar amara and oɓulunda odanjëm. Ayël këmëni yël ɓërandëw̃ëra andeƴ ɓën, and këƴ xuca wëj aŋ, oxwën or din ir din or ebar elo ro ol.” ");
INSERT INTO bsc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Gërëgako ɓëtoŝan ɓëki ɓënd ŝotëli këƴëɓi ro gër ebar ed Misëra ɗamana me dëfaxënëgu gër ndeƴ ro ɓëŋo, wëno xwën këɓi. Efërayim, do gë Manase, wëno xwën këɓi, ang xwën këmëni Ruben do gë Simewoŋ ak. ");
INSERT INTO bsc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Angëmëne oɓaŝ oŝëxe rëw̃ këƴëɓi na ɓëte, ani gi na oram. Ɓën paɓ gë Efërayim do gë Manase këni ɓëteliɗ eram in. ");
INSERT INTO bsc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","And h̃atëgu këme gër ebar ed Kanahaŋ, ga xaniw këme gër ed Padaŋ aŋ, lap këmo norix Raŝel gër fëña, ɗamana me ŋataxën gër Efërata, gër Betëlexem.» ");
INSERT INTO bsc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","And wat këɓi oɗëmëta od Yosef aŋ, Isërayel w̃ëka ko: «Noɓën ex wa ɓëjo?» ");
INSERT INTO bsc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yaka ko Yosef: «Oɓaŝ or yël ke Kaxanu ro gër ebar ed Misëra ol ex.» Re ko ɓëte Yakob: «Këla tëkaliwëyëɓi gër ndam ro, mëni karanaxën oɓetak ol.» ");
INSERT INTO bsc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Oxar ol anëka dëŋ baŋo ŝotand Isërayel, axo bo bana ga ko watëra ŝenene. Yosef sëkali këɓi ɓosëñiw̃ gër Yakob. Ga lëk këɓi, nëỹaya këɓi ŋëŝ gër emëkw edexëm, do w̃ega këɓi. ");
INSERT INTO bsc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ata Isërayel fel këŋo Yosef: «Wëno abame yëla na awat këme wat gaŝëxe dëxas ireƴ in, ɓarikan Kaxanu anëka w̃asin ke ɓëte andëw̃ëra andeƴ aŋ!» ");
INSERT INTO bsc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yosef fedali këɓi oɗëmëta odexëm od ebax gër olëkëna or sëm ok, do foxi ko eƴiỹ el ŋëŝ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ga xani ko, las këɓi tak oki, Efërayim gë ataxan and liw̃ aŋ, do gand ŝame ir Isërayel, Manase gë ataxan and ŝame aŋ do gand liw̃ ir Isërayel. Yosef sëkali këɓi mondako gër sëm. ");
INSERT INTO bsc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ɓarikan Isërayel nëmbëndër ko otaxan ok: xwët ko ataxan and liw̃ aŋ gër gaf ir Efërayim, xarak mëŋ ebax lëmëta iɓeja in. Ataxan and ŝame aŋ, xwët ko gër gaf ir Manase, lëmëta iỹanar ir Yosef in. ");
INSERT INTO bsc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ata Yakob këŋo xaran oɓetak ol Yosef ko rend: «Kaxanu, mëŋ ar baɓi laŋëtarand ɓëxarëk ɓëram an, Abëraxam do gë Isak, Kaxanu, mëŋ ar ebax nand ex yo axaɗac aram xali doro an, ");
INSERT INTO bsc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mëŋ ar ex Meleka ir racët ke gër eñëŋënax end ex yo an, yëlëleɓi oɓetak ol oɗëmëta oko! Ɓën macindëlenëɓi gë ow̃ac oram ol, gë omac od ɓëxarëk ɓëram Abëraxam do gë Isak ok. Ɓërandëw̃ëra ɓandeɓën ɓën, ñëmbërëlexëni xali eni ɓeñëta ɗek ebar edeɓën el!» ");
INSERT INTO bsc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosef ga wat ko mëne sëm ataxan and liw̃ aŋ xwët ko gër gaf ir Efërayim, ŝus ko eŋo. Rëxët ko ataxan and liw̃ and sëm aŋ gër gaf ir Efërayim exo kwëtaxën gër gaf ir Manase. ");
INSERT INTO bsc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yosef fel këŋo sëm: «Ali faba, ax gi ex na mondako! Ajo ro wa ex lëmëta iỹanar in. Kwëtël ataxan and liw̃ andeƴ aŋ gër gaf irexëm.» ");
INSERT INTO bsc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ɓarikan sëm h̃ëp ko, do re ko: «Anang nang këme asëñiw̃ën, anang nang këme. Mëŋ ɓëte ɓulunda isëm ko hi, mëŋ ɓëte angwëlik ko hi. Ɓarikan lëmëta iɓeja in kë xuri ex gi angwëlik, do andëw̃ëra andexëm aŋ amara and ɓenëng ɓendanjëm kë hi.» ");
INSERT INTO bsc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ata Yakob mondako ŝalendëra baɓi yatijo ga ko re: «Ɓërandëw̃ëra and Isërayel ɓën mondako këni ỹana eni calendërënd: “Kaxanu yëlëlexi oɓetak or Efërayim do gë Manase ol.”» Ata Yakob mondako lëngwën baŋo Efërayim gër Manase. ");
INSERT INTO bsc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Isërayel fel këŋo Yosef: «Wëno gogo këme ŝës, ɓarikan Kaxanu gë wën ko ɓayi. Aɓakali këŋun ɓakali gër ebar ed ɓëxarëk ɓërewën. ");
INSERT INTO bsc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wëno cëŋ, anëka ŝetëgu këmi ebar nëmëc ed ɓoɓinëx gër Siŝem. Ɓërandëw̃ëra and Amor ɓën xan këmëni gë duxuma iram in, do gë atumb andam aŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Akey amat, Yakob ga w̃ac këɓi ɓosëñiw̃, re ko: «Macërëgun mun nangënaxën ala kala er këŋo hi ecan-ecan in.» ");
INSERT INTO bsc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«Ɓarërëgun ene ɓaxët wën ɓosëñiw̃ ɓor Yakob! Ɓaxëtino Isërayel, ɓaxëtino sorix irewën! ");
INSERT INTO bsc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, wëj ex itoŝan iñanar indam iŋ, wëj ex odëw̃ërëw̃en oñanar od ojaw̃ odam ok, wëj nëmëca këɓi ɓoɓinëx gaf in, ojaw̃ ok do gë or gapak ol, ");
INSERT INTO bsc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ola oreƴ ol ang oỹëm fo ex, ɓari ami yël ex na olëngw ol, gayikwa ƴaŋ gër angaw̃ and sorix ɓët ɓaƴ, angaw̃ andam aŋ ɓuyarën këƴ ga ɓët baƴ gër asoxari aram.» ");
INSERT INTO bsc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simewoŋ do gë Lewi, ɓër acël amat exëni, angwëlëra andeɓën aŋ, ang oỹënga or emer fo ex. ");
INSERT INTO bsc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Wëno ami ɓar angwëlëra and edi ed eñëŋënax elo aŋ, ame ɗil na gër amara andeɓën! Gayikwa në end oxoỹ oreɓën law̃ëra kënëɓi ɓela, do në end owër oreɓën saw̃ëra kënëɓi oxeƴ or ɓela. ");
INSERT INTO bsc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kata fo ex oxoỹ oreɓën ol, gayik or gë axaỹënan këm ex! do kata fo ex owër oreɓën ol, gayikwa xoɗux fo ex! Ɓërandëw̃ëra ɓandewën ɓën aŝapëreli këmëni ŝapëreli ŝit gër ɓulunda ir Isërayel, ayic këmëni yic eni ɗëgëra ɗek ebar ed Isërayel el. ");
INSERT INTO bsc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Wëj cëŋ Yuda, ayas këni ỹana eni yasënd ɓoɓinëx, ataxan andeƴ aŋ gër eporëfor ed ɓërangoỹëra andeƴ kë hi, oɓaŝ or sorix ol afoxi këni ỹana eni poxind gër lëngw ireƴ. ");
INSERT INTO bsc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda yëraŋ iɓeja hi këƴ! Gër emaỹi edeƴ këƴ ɓakawënd and ƴambëgu këƴo emacar aŋ, aɓaf këƴ ɓafënd, alaki këƴ lakind, ang yëraŋ inëm fo: noỹo këŋo xanin? ");
INSERT INTO bsc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Acët and owun aŋ, laŋ kë ɓayi gër ekun ed Yuda, Acët and olëngw aŋ, laŋ kë ɓayi gër ɓërandëw̃ëra andexëm, xali exo ŋatëgu Ŝilo, ar xwënëk an, do eno kwëtaxën ɓenëng ɓend ɓela ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Axap këŋo ỹana eŋo kapënd fali irexëm in lëf gër andëɗa and reseŋ, axap këŋo ỹana eŋo kapënd atox and fali inëm aŋ në atëx and reseŋ. Acuɗ andexëm aŋ ko ỹana exo neɓënd gë ngoƴ iŋ, anjëm andexëm aŋ ko ỹana exo neɓënd gë omen od reseŋ ok. ");
INSERT INTO bsc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ngoƴ iŋ kë ỹana ex ɓarënënd ɓangës ɓandexëm ɓaŋ, omër kë ỹana ex peŝënënd oỹënga orexëm oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabuloŋ kë lëg ler gër oɓëŋa od ɓangwëngw, gër ed kë ỹana ex kwëŝand okuluŋ, do ebar ed ko xwën el, ah̃at kë h̃at xali gër ed Sidoŋ. ");
INSERT INTO bsc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar mëŋ cëŋ, fali ir gë ojaw̃ hi ko, alaki ko lakind mërëxand ir ɓakece. ");
INSERT INTO bsc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Awat wat ko mëne gër ed ko seyëtand anënga nëngak, do ebar enëngax ex. Aw̃a w̃a ko eno kap exo ɗëɓixën esiɓax, aw̃a w̃a ko exo diyenind ang xaɗëp fo. ");
INSERT INTO bsc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan këɓi ỹana eɓi kitind ɓulunda irexëm in, ang enëng emat end Isërayel fo. ");
INSERT INTO bsc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan er hi ko ang andën and në fëña fo, ang ekifoxifo ed në lec fo, gër osak këŋo h̃atënd fanac in exo ɗatixën gë eƴiỹ el ar ỹëpaxën këŋo an. ");
INSERT INTO bsc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","(Axwën, ayar këme yarënd apexa andeƴ aŋ!) ");
INSERT INTO bsc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad mëŋ cëŋ, enga end ɓërek ɓëxeỹax këŋo w̃ereli, ɓarikan aw̃er ko w̃er xali eɓi kor, do eɓi ŋw̃ay! ");
INSERT INTO bsc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Gër ebar ed ko xwën Aser, eƴamb el ax gi na mopaỹ, mëŋ kë ỹana eɓi dëɓand ɓemun ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nefëtali ang ebëjare ed kë raɗërand fo hi ko, oyeƴan oyekax ko ỹana exo yeƴanënd. ");
INSERT INTO bsc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosef mëŋ cëŋ, ang atëx and kë rëw̃ënd fo hi ko, ang atëx and lëgëk ler në añësa and men fo hi ko, ɓenini ɓendexëm ɓeŋ yaɓët kece in kë lefënd. ");
INSERT INTO bsc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Aỹanaxën ỹanaxën këno, do aw̃an w̃an këno gë opës odeɓën ok, gë opës odeɓën ok w̃an këno ɓërangoỹëra andexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ɓarikan atumb andexëm aŋ ax yëlora ex na, onëxar orexëm oŋ ɓayik ŋw̃ac-ŋw̃ac. Paɓ gë otaxan od ar fangak ok, ar këŋo yëlënd panga Yakob an (ar ex Axaɗac, do Angaỹ and Isërayel an). ");
INSERT INTO bsc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","«Paɓ gë Kaxanu, ar yata këŋo sorix an (gilexo angwak andeƴ aŋ)! Ar Fangak an, yëlëlexi oɓetak ol, oɓetak or ƴaŋ gër orën ol, oɓetak or gëɗ ebar ol, oɓetak or gër oɓër, do gër acël and asoxari ol!» ");
INSERT INTO bsc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","«Oɓetak or xaran ki sorix ol, nëmëcak oɓetak or gër osënd or angwën ol, or gër ɓëtënd ɓënd akarëk ol. Oɓetak olo, gilex gër gaf ir Yosef, gil ex gër egor ed ar hik emun end ɓoɓinëm an!» ");
INSERT INTO bsc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Beŋëŝame mëŋ cëŋ, yëlemu ixeỹax hi ko, gëɓër këŋo ƴambënd emacar end law̃ këŋo eŋ; genëka, eɓi cetëra er ŝotëgu ko in.» ");
INSERT INTO bsc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ɓosëñiw̃ ɓor Yakob ex ɓëxarëk ɓër ɓenëng epëxw gë ɓeki ɓend Isërayel ɓeŋ. Ɓendeƴ ɓeŋo felëra baɓi sëm ireɓën and baɓi xaran oɓetak aŋ, ala kala gë oɓetak orexëm pit. ");
INSERT INTO bsc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ga xucak eŋo, Yakob fel këɓi ɓosëñiw̃: «Wëno gogo këme ŝës. Mëlayiɗëne ene mëxwëtax gër ỹeg ir w̃ëxëta kënëɓi ɓëxarëk ɓëram, gër oxel or gër oŝënga or Efëroŋ, arandëw̃ëra and Het an, ");
INSERT INTO bsc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","gër oxel or gër oŝënga or Makëpela, ler gër Mamëre, gër ebar ed Kanahaŋ, oŝënga or yëc ko Abëraxam gër Efëroŋ, arandëw̃ëra and Het an, gër oŝënga or xwën ko. ");
INSERT INTO bsc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Fën w̃ëxëta kënëɓi Abëraxam do gë alindaw̃ Sara, gë Isak do gë alindaw̃ Rebeka. Fën w̃ëxëta këmo wëno ɓëte Leya. ");
INSERT INTO bsc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Oŝënga olo do gë oxel ol, Abëraxam yëcëk gër otaxan od ɓërandëw̃ëra and Het.» ");
INSERT INTO bsc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","And h̃ata ko epelëra ed ɓosëñiw̃ aŋ, Yakob ɓaka ko laki ko gër angaw̃, kwël xoti ko do ɓarëx këni gë ɓëxarëk ɓërexëm ɓër ŝësëk elod anëka fo ɓën. ");
INSERT INTO bsc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosef ga lapaya ko gër sëm, w̃ega këŋo, do ko sesënd. Ongwën oŋ kë ŝarënd gër dëxas ir Yakob. ");
INSERT INTO bsc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ga xani ko na, Yosef fel këɓi ɓëxora ɓën eni nëmëra eman end sëm eŋ xali eŋo ɗilër ogu oŋ. Ata ɓëxora ɓën nëmëra këno Isërayel xali lilër këŋo ogu oŋ. ");
INSERT INTO bsc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ɓakey ofëxw onax nëmëra bano mondako ang rëp bax ak, xali lilër këŋo ogu oŋ. Ɓëmisëra ɓën ỹaw këno Yakob ɓakey ofëxw ocongoxi. ");
INSERT INTO bsc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ga xucak ɓakey ɓand ỹaw̃ëra bano Yakob ɓaŋ, Yosef fel këɓi ɓër eyang ed Farawoŋ ɓën: «Angëmëne ah̃an h̃an këne, ŋateliyin eyeƴan edam elo gër Farawoŋ, axara xara këmun.» ");
INSERT INTO bsc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","«Ga re ko Yosef: Faba re bax me yaŝar yatir baxe felërand mëne mëŋ gogo ko ŝës, mëne mo mëlaɗ mo mëxwëtax gër ỹeg ir nacën këno gër ebar ed Kanahaŋ. Gërëgako pelino Farawoŋ mëne axara xara këmo exe teɓ me ƴe ƴaŋ gër ebar ed Kanahaŋ moxwëtaw faba. And këmo w̃ëxëtaw aŋ me ɓakaw.» ");
INSERT INTO bsc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yaka ko Farawoŋ: «Oko ƴel eƴo mëxwëtaw sorix, ang re baxo eƴ yaŝar ari këƴ ri ak.» ");
INSERT INTO bsc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yosef ƴe ko ƴaŋ gër ebar ed Kanahaŋ eŋo mëxwëtax sëm. Laŋëta këno ɗek eyang ed Farawoŋ el do gë ɓëxarëk ɓër iciw̃ indexëm ɓën, gë ɓëxarëk ɓër ebar ed Misëra ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Aƴe ƴe bani ɓëte ɗek ekun ed Yosef el, gë ɓoɓinëm do gë ɗek ekun ed sëm el. Er seɓ banëɓi na gër ebar ed Goŝen wayët ɓësoxari ɓën, gë oɓaŝ ol, gë oɓeci ol, gë opeỹ ok, gë oxeƴ ol, do gë ogelemba ok. ");
INSERT INTO bsc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Yosef aw̃ëla w̃ëla baɓi ɓër gë opanac od bax lasënd ocaret od emer ok: gër enga eŋo aỹëmb ỹëmb bani. ");
INSERT INTO bsc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ga h̃at këni gër angëni and këni w̃acënd Atad, kegët Yurëdeŋ in, ses këni ŝor xali wëlik angoŋ atëm. Yosef mondako ri baxo na oỹaw̃ or sëm ol ɓakey ɓanjongëɓaki. ");
INSERT INTO bsc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ɓër lëg bax na gër ebar ed Kanahaŋ ɓën, ga wël këni angoŋ aŋ gër angëni and Atad, re këni: «Awa oỹaw̃ osëm hi këɓi Ɓëmisëra ɓën!» Mëŋ w̃acaxën këni na gër ed ebani, ekeg Yurëdeŋ in, «Abel-Mitësërayim», mëne ngëŋ «Oỹaw̃ or Ɓëmisëra». ");
INSERT INTO bsc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ata ɓosëñiw̃ ɓor Yakob mondako ri bani er fel baɓi sëm ireɓën in. ");
INSERT INTO bsc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ɓosëñiw̃ w̃aỹeli baŋo Yakob gër ebar ed Kanahaŋ, do w̃ëxëta këno gër oxel or gër oŝënga or Makëpela, gër oŝënga or yëc ko Abëraxam gër Efëroŋ, arandëw̃ëra and Het ol, ler gër Mamëre. Gër osënga olo ri baxo Abëraxam ɓanapëra ɓand ɓër ekun edexëm ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","And w̃ëxëta këno sëm aŋ, Yosef, gë ɓoɓinëm, do gë ɗek ɓër laŋëtaw baɓi gër emëxwëta ed sëm ireɓën ƴaŋ na gër ebar ed Kanahaŋ ɓën, ɓaka këni gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","And wat këni ɓoɓinëm ɓor Yosef mëne anëka ŝës ko sëm ireɓën aŋ, re këni: «Ɓamat Yosef aŝenaxën këɓo ŝënaxën eɓo maŝa ɗek eñëŋënax end ri banëŋone eŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ata law̃ën këni mondako gër Yosef: «Ɗamana exo cësaxën, sorix aseɓën seɓën këɓo eyeƴan elo: ");
INSERT INTO bsc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Axara xara këmi, teɓanëlëɓi ɓoɓinëx eñëŋënax eŋ, do gë amena andeɓën aŋ, gayikwa aw̃enan w̃enan këni! Axara xara këmi, teɓanëlëɓi gërëgako dëŋ okaɗëp od Kaxanu ok, ar yata këŋo sorix an, eñëŋënax end ri këni eŋ”.» Ata Yosef ses ko and fel këno mondako aŋ. ");
INSERT INTO bsc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ata ɓoɓinëm ɓor Yosef ga sëka këno, lapaya këni gër osapar orexëm, do re këni: «Ɓiyi okaɗëp odeƴ hi këmi.» ");
INSERT INTO bsc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yaka këɓi Yosef: «Këren yëdara na: ba wëno nde ex Kaxanu? ");
INSERT INTO bsc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Eñëŋënax end ŝala ban ene di eŋ, Kaxanu nëngwëtëk enjekax, ex gixën er hik doro ijo in, eni pexaxën ɓela ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Gërëgako, këren yëdara na. Arëcara këmun ỹana mun dëcarand, wën do gë oxun orewën oŋ.» Yosef mondako yifara baɓi ɓoɓinëm, xali fuŋara këɓi. ");
INSERT INTO bsc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Mondako lëg bani na gër ebar ed Misëra Yosef do gë ɓër ekun ed sëm ɓën. Yosef liya ko ɓëniy keme gë epëxw. ");
INSERT INTO bsc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosef awat wat baɓi oɓaŝ or Efërayim ol, xali gë ejiw̃ ekënukënu ɓën ak. Oɓaŝ or Makir ol, asëñiw̃ ar Manase, gër olëkëna orexëm rëw̃ banëɓi. ");
INSERT INTO bsc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosef afel fel baɓi ɓoɓinëm: «Awa wëno gogo këme ŝës. Ɓarikan Kaxanu aƴowënëgu këŋun ƴowënëgu. Anëcët këŋun nëcët gër ebar elo ro, eŋun ɓakali gër ebar ed ɓeƴa ko gë eyaŝar mëne ayël yël këɓi oxwën ol Abëraxam, gë Isak, do gë Yakob el.» ");
INSERT INTO bsc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ata Yosef fel këɓi eni yaŝar ɓërandëw̃ëra and Isërayel ɓën mëne ari këni ri end re ko eŋ. Mondako yeƴan baxo: «And këŋun ƴowënëgu Kaxanu aŋ, mëlaliɗën oŝapar oram oŋ.» ");
INSERT INTO bsc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ata Yosef ŝës ko and sëk këŋo ɓëniy keme gë epëxw aŋ. Nëmëra këno ogu oŋ xali lilër këŋo, do xwët këno polo në kes na gër ebar ed Misëra.");
INSERT INTO bsc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mondako ex andëw̃ëra and ɓëxarëk ɓër Yesu Kërisët aŋ, mëŋ ar ex rëw̃is ir Abëraxam, rëw̃is ir Dafid in. ");
INSERT INTO bsc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abëraxam ex sëm ir Isak, Isak sëm ir Yakob, do Yakob sëm ir Yuda do gë ɓoɓinëm. ");
INSERT INTO bsc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ex sëm ir Peres do gë Sera, do nëm ireɓën ex Tamar. Peres ex sëm ir Esërom, do Esërom sëm ir Aram. ");
INSERT INTO bsc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ex sëm ir Aminadab, Aminadab sëm ir Nahason, do Nahason sëm ir Salëma. ");
INSERT INTO bsc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salëma ex sëm ir Bohes, do nëm ir Salëma ex Raxab. Bohes ex sëm ir Yobed, do nëm ir Yobed ex Rut. ");
INSERT INTO bsc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obed ex sëm ir Isayi, do Isayi sëm ir Dafid, emun eŋ. Dafid ex sëm ir Salomoŋ, do nëm ir Salomoŋ ex asoxari ar Uri an. ");
INSERT INTO bsc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoŋ ex sëm ir Roboham, Roboham sëm ir Abiya, do Abiya sëm ir Asa. ");
INSERT INTO bsc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ex sëm ir Yosafat, Yosafat sëm ir Yoram, do Yoram sëm ir Osiyas. ");
INSERT INTO bsc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas ex sëm ir Yohatam, Yohatam sëm ir Akas, do Akas sëm ir Esekiyas. ");
INSERT INTO bsc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyas ex sëm ir Manase, Manase sëm ir Amos, do Amos sëm ir Yosiyas. ");
INSERT INTO bsc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyas ex sëm ir Yekoniyas do gë ɓoɓinëm. Ata angwën aŋo w̃ëla banëɓi Ɓëyisërayel ɓën oxaɗëp ol gër ebar ed Babilon. ");
INSERT INTO bsc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","And seɓëtëgu kënëɓi gër oxaɗëp aŋ, Yekoniyas hi ko sëm ir Salacel, do Salacel sëm ir Sorobabel. ");
INSERT INTO bsc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel ex sëm ir Abihud, Abihud sëm ir Eliyakim, do Eliyakim sëm ir Asor. ");
INSERT INTO bsc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ex sëm ir Sadok, Sadok sëm ir Akim, do Akim sëm ir Elihud. ");
INSERT INTO bsc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud ex sëm ir Elasar, Elasar sëm ir Mataŋ, do Mataŋ sëm ir Yakob. ");
INSERT INTO bsc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob ex sëm ir Yosef, aŝan ar Mari an. Mari ijo rëw̃ këŋo Yesu, ir këno w̃acënd Kërisët. ");
INSERT INTO bsc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Awa er ex ɓandëw̃ëra epëxw gë ɓanax elod Abëraxam xali gër Dafid. Ɓëtëraguk ɓandëw̃ëra epëxw gë ɓanax, elod Dafid xali angwën and oxaɗëp or Ɓëyisërayel gër ebar Babilon aŋ. Ɓëtëraguk ɓëte ɓandëw̃ëra epëxw gë ɓanax, elod gë oxaɗëp or gër ebar Babilon ol xali gër Yesu Kërisët. ");
INSERT INTO bsc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ata mondako bax andëw̃a and Yesu Kërisët aŋ. Mari nëm irexëm, enëm ed Yosef ebaxo. Do ɗamana eni nangër, Mari ŝot ko acël gë panga ind Angoc Amënëk iŋ. ");
INSERT INTO bsc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosef, aŝan arexëm, ga hi baxo cëŋ ar ŝenene, xeƴ këŋo eŋo cëfënin. Ata ko yëlarand ang ko ri eni capëraxën yir fo. ");
INSERT INTO bsc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nand baxo yëlarand mondako na, meleka ir Axwën in ŝanayaxën këŋo në lakeli, do re ko: «Yosef, wëj ar andëw̃ëra and Dafid an, këreƴ yëda na eƴo ŋateli Mari, alindax. Ar gër acël andexëm aŋ, Angoc Amënëk aŋ w̃ëlaw këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lëmëta ex, do and këŋo rëw̃ aŋ, yëliɗo ow̃ac or Yesu gayik mëŋ këɓi racët ɓulunda ir Isërayel in gër ɓeñëŋënax.» ");
INSERT INTO bsc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ata ɗek ɓendeƴ ɓeŋo mondako ex ŋata ang re baxo Axwën ak paɓ gë alaw̃ënel Esayi ak: ");
INSERT INTO bsc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Endënaw̃ emeja kë hi gë acël, do eŋo dëw̃ lëmëta ir këno w̃acëɗ Emanuwel, mëne ngëŋ “Kaxanu nëngaw këɓo”.» ");
INSERT INTO bsc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","And nëngëta ko aŋ, Yosef ri ko ɗek er fel baŋo meleka ir Axwën in. Ata ƴen këŋo alindaw̃ Mari. ");
INSERT INTO bsc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ɓari ani nangër bana xali rëw̃ këŋo lëmëta in. Ata Yosef yël këŋo ow̃ac or Yesu ol. ");
INSERT INTO bsc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","And rëw̃ këno Yesu gër Betëlexem aŋ, Erod wun bax gër ebar ed Yude. Ata ɓëŝaki ɓër xaniw bax gand Apën-eñan, h̃atëgu këni gër Yerusalem, gër eyang ed Erod. ");
INSERT INTO bsc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","W̃ëka këni: «Ro nde exo emun end Ɓëŝëwif end rëw̃ këno eceɗe eŋ? Gayikwa ɓiyi emal edexëm el watëgu këmi elod gand Apën-eñan mëŋ ƴowaxënëgu këmi mi poxi gër lëngw irexëm, mo calexën.» ");
INSERT INTO bsc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ga wël këni eŋo, Erod emun eŋ, gë Ɓëyerusalem ɓën, wëlandëra këɓi xali xurik. ");
INSERT INTO bsc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ata Erod w̃ac këɓi ɗek ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën eɓi mëka ba feye bax eno dëw̃ Afexën an. ");
INSERT INTO bsc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yaka këno: «Gër ebar ed Yude ro dëŋ, gër angol and Betëlexem. Ga ỹëgw ko wa alaw̃ënel an: ");
INSERT INTO bsc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Wëj angol and Betëlexem aŋo, gër ebar ed Yude, Ŝëf gër ɓangol ɓangwëlik ɓand gër ebar ed Yuda hi këƴ, aƴ gi ex na wa angol and toc. Gër ndeƴ na këno rëw̃ ar kë wun gër enëng end Isërayel, ɓulunda iram an.”» ");
INSERT INTO bsc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ata Erod w̃ac këɓi yir fo ɓëŝaki ɓëjo do w̃ëka këɓi eno pënëtan aye amëd and ŝanayak emal elo aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ata ga law̃ën këɓi gër Betëlexem, re ko: «Awa ŋatin tan en mëkaraw aye end lëmëta ijo eŋ. And këno watëgu aŋ, ɓakawëɗën ijo ro ene nangënati mëŋ këme ƴeɗ wëno ɓëte me poxi gër lëngw irexëm mo calew.» ");
INSERT INTO bsc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ga wëlër këni mondako gë emun eŋ, ɓëŝaki ɓën xuca këni ond gër Betëlexem oŋ. Ata emal ed watëgu bani elod apën-eñan el lëngweli këɓi. And h̃atëk gër ed hi baxo lëmëta aŋ, xwëŝak. ");
INSERT INTO bsc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɓëŝaki ɓën ga wat këni emal el, nëngandëra këɓi mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lil këni gër iciw̃ ind bax h̃oɓand emal, sëk kënëɓi lëmëta in gë Mari, nëm irexëm. Na foxira këni do ŝale këno. Fëtëra këni ɓëkwëtaya ɓënd koɗi ɓëŋ do ŝëmaxën këno gë oyël or w̃ëlagu bani oŋ: kaŋe, gë aŝururu ir xwëŝëna bani gë angiri, do gë ogu ond këni w̃acënd mir. ");
INSERT INTO bsc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ata sitin këɓi Kaxanu në lakeli eno ɓeŝ Erod amaỹi w̃aỹi aŋ. Mondako w̃aỹi këni kwël fëña iŝëxe ond gër ebar edeɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","And w̃aỹi këni ɓëŝaki aŋ, meleka ir Axwën in ŝanayaxën këŋo Yosef në lakeli do re ko: «Yosef, kanil eƴëɓi gëreli lëmëta in gë nëm gër ebar ed Misëra. Ñëpaxëɗën fën xali yatir këmi fel en maỹiw. Gayikwa Erod aŝala ko ŝala eŋo ɗaw̃ lëmëta in.» ");
INSERT INTO bsc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ga nëngëta ko Yosef, xanin këɓi kwël gëmëɗ fo lëmëta in gë nëm do w̃ëla këɓi gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Fën ỹëpax bani xali ŝës ko Erod. Ata mondako h̃ata bax er re baxo Axwën Kaxanu paɓ gë alaw̃ënel in: «Asëñiw̃ën w̃acëgu këmo exo canëgu gër ebar ed Misëra.» ");
INSERT INTO bsc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","And wata ko Erod mëne anëka yifa këno ɓëŝaki aŋ, xoỹ ko xali xurik. Ŝëñëta këɓi ocoroɗa odexëm ok eni ƴe gër Betëlexem enëɓi ɗaw̃ërax ɗek ɓëtox ɓëtoŝan ɓëŋ elod ɓënd ɓëniy ɓëki ɓëŋ xali gër ɓënd ɓayik gër oyer. Mondako yëla baxo Erod kë fed gë amëd and fënëtan bano ɓëŝaki aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ata h̃atak er reƴa baxo Yeremi, alaw̃ënel ar Kaxanu in: ");
INSERT INTO bsc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Otes kë wëlind gër angol and Rama, Otes do gë edenitaran kë wëlind, Raŝel këɓi ỹaw̃ënd oɓaŝ orexëm ol, Ayifara yo ayifara, axo ma ex na exo cësina, gayik ani bo ex na, ɗek ŝës këni.» ");
INSERT INTO bsc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","And ŝës ko Erod aŋ, meleka ir Axwën in ŝanayaxën këŋo Yosef në lakeli gër ebar ed Misëra. ");
INSERT INTO bsc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Fel këŋo: «Yosef, gërëgako kanil eƴëɓi maỹeli lëmëta in gë nëm gër ebar ed Isërayel. Ɓër ỹandi baɓi aniyan andexëm ɓën anëka nemira këni.» ");
INSERT INTO bsc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ata Yosef xani ko, w̃eɗ këɓi lëmëta in gë nëm do w̃aỹeli këɓi gër ebar ed Isërayel. ");
INSERT INTO bsc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɓarikan and wël ko mëne Arëkelawos ɓëtelik owun or sëm Erod ol gër ebar ed Yude aŋ, yëda ko eni ɓaka fën. Ata Kaxanu ga sitin këŋo në lakeli, h̃ateli këɓi gër ebar ed Galile. ");
INSERT INTO bsc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ƴe ko ỹëpax këni gër angol and këni w̃acënd Nasaret. Ata h̃atak er re bani ɓëlaw̃ënel in: «Aɓënasaret këno ỹana eno macënd.» ");
INSERT INTO bsc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Amëd aŋo, ŝanayaw baxo Ŝaŋ Batis gër ladawe ir gër ebar ed Yude, do ko femërand end Kaxanu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Er baxo rend: «Nëngwëtin ola orewën ol gayik owun or gër orën ɗam ex!» ");
INSERT INTO bsc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ata Ŝaŋ Batis ex ar baŋo rend alaw̃ënel Esayi an: «Ala exëna ar kë xeỹërand gër ladawe, oniw̃ orexëm ol kë rend: “Ñanin fëña ir Axwën in! Ɗebëtin ɓëpëña ɓënd ko xucaxën ɓëŋ.”» ");
INSERT INTO bsc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ŝaŋ Batis, acuɗ and omban ond gelemba baxo ŝuɗand do baxo xapand enar gër edum. Eƴamb ƴamb irexëm in ebax owure do gë dingën iɓapuỹ. ");
INSERT INTO bsc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓëyerusalem ɓën, do gë ebar ed Yude el ɗek, gë ɗek ebar ed Yurëdeŋ el, aƴe bani ƴend ɓura-ɓura gër ed hi baxo Ŝaŋ Batis. ");
INSERT INTO bsc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Do mëŋ aɓuyi baɓi ɓuyind polo gër Yurëdeŋ ɓër bax futënd poyoma ɓeñëŋënax ɓend ri këni ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ata Ŝaŋ Batis wat këɓi Ofariseŋ do gë Osaduseŋ odanjëm ga ƴow këni gër xoɓuyi. Re ko: «Wën ang ɓandën fo siti kën. Noỹo wa fel këŋun mëne axor ex en kwëỹëta kiti ind Kaxanu ind kë ƴowënd iŋ? ");
INSERT INTO bsc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Diyindën ɗe ari ɓandixa ɓand kë w̃asinënd mëne anëngwëta dëŋ nëngwëtak ola orewën ol. ");
INSERT INTO bsc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ɓari këren yëland na gayikako Abëraxam ex axarëk arewën an kën fexaxën. Kaxanu axor ko xor exo nëngwët oxaỹ oŋo dëŋ ex gi oɓaŝ or Abëraxam. ");
INSERT INTO bsc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ado anëka w̃eɗ ko ecëngwa el exo taw̃axën ɓatëx ɓaŋ ŋëŝ gër oɗëmbët: atëx and ax dëw̃ënd na odëw̃ërëw̃en ojekax yo, asaw̃ ko saw̃ do exo ɗap gër xoɗux. ");
INSERT INTO bsc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wëno aɓuyi këmun ɓuyind gër men ex watixën mëne anëngwët nëngwët kën ola orewën ol. Ɓarikan ar ke sëfëgund an këŋun ỹana eŋun ɓuyind gë panga ind Angoc Amënëk iŋ do gë xoɗux ol. Mëŋ fangak nëmëc wëno: ado wëno axe ñap ex na mo peɗët ɓapeɗ ɓandexëm ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ekëɗa lëkaya ko gër ataxan andexëm exo pelëraxën gër eɓar edexëm. Aw̃ëla ko w̃ëla bële in exo cacëx gër akërukëru andexëm. Ɓarikan enenar eŋ alap ko lap gër xoɗux or ax ɗomind na gë eɗomi.» ");
INSERT INTO bsc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ata Yesu ga xaniw ko gër ebar ed Galile, ƴow ko Yurëdeŋ, gër Ŝaŋ Batis, eŋo ɓuyixën. ");
INSERT INTO bsc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ɓarikan Ŝaŋ Batis ah̃ëp baxo h̃ëpënd do ko rend: «Wëno wa ex ar ỹapëk eƴe ɓuyi an, ecëñëxët ƴow këƴ gër ndam!» ");
INSERT INTO bsc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na re ko Yesu: «Ɓuyile mondako dëŋ gayikwa aỹap ỹapëk exe ŋataye ɗek er ex ŝenene in.» Aŋo fo w̃a ko Ŝaŋ Batis do ɓuyi këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ga ko ŝëpëta Yesu, hik fol orën ol. Wat këŋo Angoc and Kaxanu aŋ ga ko fedaw gër ndexëm ang eɗëxwëte epeŝax fo. ");
INSERT INTO bsc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wëlik oniw̃ gër orën: «Ajo ex Asëñiw̃ën ar pëlot gër yomb iram an. Ata wëno mbaŋ ke nënganënd endexëm eŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ata Angoc Amënëk aŋ w̃ëla këŋo Yesu gër ladawe eŋo dix atëƴ gë ŝaɓucara in. ");
INSERT INTO bsc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","And siw̃i ko Yesu, gëmëd gë goyat xali ɓakey ofëxw onax aŋ, xor këŋo enjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Amëd aŋo, sëkaw këŋo Ayifa an, re ko: «Angëmëne Asëñiw̃ ar Kaxanu eƴ, nëngwëtël oxaỹ oŋo ex gi eƴamb ƴamb.» ");
INSERT INTO bsc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yaka ko Yesu: «Ga ỹëgw këni gër akayëta and Kaxanu: “Ala an aliya ko liyand gë ɗek eyeƴan ed Kaxanu el, ax gi ex na gë eƴamb ƴamb in fo.”» ");
INSERT INTO bsc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ŝaɓucara in w̃ëla këŋo Yesu gër angol amënëk. Ga xwët këŋo ƴaŋ gër ejur ed Aciw̃ and Kaxanu, ");
INSERT INTO bsc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","re ko: «Angëmëne Asëñiw̃ ar Kaxanu eƴ, ɗapayal. Ax gi ex na nde aỹëgw ỹëgw këni: “Afel këɓi fel omeleka odexëm ok endeƴ eŋ do ɓën eni kaka gë otaxan odeɓën ok këdi këƴ lapa në ekaỹ”.» ");
INSERT INTO bsc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yaka ko Yesu: «Ɓëte aỹëgw ỹëgw këni: “Ax gi ex na monëỹali Kaxanu, Axwën areƴ an?”» ");
INSERT INTO bsc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ŝaɓucara in w̃ëla këŋo ɓëte Yesu ƴaŋ në atënd acakax, w̃asindëra këŋo ɗek owar or gër ngwën oŋ gë enjaran endeɓën eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Re ko: «Ayël këmi yël owar oŋo ɗek angëmëne afoxi foxi këƴ gër lëngw iram eƴe cale.» ");
INSERT INTO bsc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yaka ko Yesu: «Wëj Sindan, nacëtale fa, gayikwa aỹëgw ỹëgw këni: “Poxiyind wayët gër lëngw ir Kaxanu, Axwën areƴ an, do caleyindo mëŋ fo.”» ");
INSERT INTO bsc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ata ŝaɓucara in seɓët këŋo Yesu. Sëkaw këno omeleka eno ɗëɓa. ");
INSERT INTO bsc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","And wël ko Yesu mëne anëka sëra këno Ŝaŋ Batis aŋ, nacëta ko gër ebar ed Galile. ");
INSERT INTO bsc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ŝan ko Nasaret in do rëfa ko gër Kafarënawum, ler gër ɓëŋa ir anjer and Galile aŋ, gër ebar ed xwën bani ɓandëw̃ëra ɓand Sabuloŋ do gë Nefëtali. ");
INSERT INTO bsc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mondako h̃ata bax er re baxo alaw̃ënel Esayi in: ");
INSERT INTO bsc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ɓër gër ebar ed Sabuloŋ ɓën do ɓër gër ebar ed Nefëtali ɓën, Ɓër lëgëk gër fëña ir ler gër anjer ɓën, Ɓër lëgëk ekeg ed Yurëdeŋ ɓën, gër ebar ed Galile ir ɓenëng ɓecëxe, ");
INSERT INTO bsc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ɓulunda ir ỹëpak gër ecamëɗan in, watëk angoɓen atëm, gër ɓër ỹëpak gër ebar ed ecamëɗan ɓën, gër ed ỹañëk ecës, ŝanayak angoɓen atëm.» ");
INSERT INTO bsc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ata Yesu, amëd aŋo dëŋ ỹana baxo ko femënd mondako: «Nëngwëtin ola orewën ol gayik owun or gër orën ol ɗam ex!» ");
INSERT INTO bsc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Akey amat, Yesu ko sëfand ɓëŋa ir anjer and Galile in. Wat këɓi Simoŋ, ar nëngwët baŋo Piyer an, do gë Andëre aɓinëm, ga këni lapëra owën gër anjer, ɓëŝëpët ɓër oxan ebani. ");
INSERT INTO bsc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ga sëka këɓi re ko: «Wën tëfëgune tan mun di ɓëɓar ɓër ɓela.» ");
INSERT INTO bsc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ataŋ seɓ këni na owën oŋ do kwël sëf këno. ");
INSERT INTO bsc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ga ƴe këni imbaɗ, wat kënëɓi ɓër aminëmëra ɓëŝëxe, ɓosëñiw̃ ɓor Sebede, Ŝak do gë aɓinëm Ŝaŋ. Aw̃ëxëtëra bani w̃ëxëtërand owën oreɓën oŋ gë sëm ireɓën polo në ikuluŋ. Yesu w̃ac këɓi: ");
INSERT INTO bsc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ataŋ seɓ këni kuluŋ in, gë sëm ireɓën ak, do kwël sëf këno. ");
INSERT INTO bsc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ebar ed Galile el ɗek baxo sëfërand Yesu, do baɓi sëƴalirand Ɓëŝëwif ɓën gër ɓaciw̃ ɓacaleya ɓandeɓën. Atëfëtan and owun or Kaxanu aŋ baxo femërand do afakën baɓi fakënënd ɓela ɓën oŝëxwëra or ex yo do gë oseỹi or ex yo. ");
INSERT INTO bsc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ata mondako wëli bax ow̃ac orexëm ol ɗek ebar ed Siri el. Aw̃ëlanëgu bano w̃ëlanëgund ɗek ɓër bax sorond ɓën, ɓër lëk baɓi ocëxwëra od ex yo ɓën, gë ɓër baɓi soronënd ɓëyël ɓën, gë ɓër gë ŝënan ɓën, do gë ɓëseỹik ɓën. Ɗek baɓi fakënënd. ");
INSERT INTO bsc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ata moñëmb bani ỹëmbënd ɓela ɓër baŋo sëfarand Yesu ɓën, gër ed ko ƴe yo: hik gër ebar ed Galile, hik gër ed Ɓangolepëxw, hik gër ed Yude, hik gër angol and Yerusalem, hik gër ebar ed ekeg ed Yurëdeŋ el. ");
INSERT INTO bsc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Akey amat, Yesu wat këɓi ɓela ɓën ɓamëxwër ɓamëxwër, ga ɓarërëgu këni kap gër etënd. Ga ỹëpa ko, xeta këno ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ata h̃eɓëta ko, këɓi sëƴalind mondako: ");
INSERT INTO bsc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nëngandërayindëleɓi ɓër sitarak gër onden ɓën, gayikwa ɓën xwënëk owun or gër orën ol! ");
INSERT INTO bsc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nëngandërayindëleɓi ɓër kë sesërand gërëgako ɓën, gayikwa Kaxanu ayifara këɓi yifara! ");
INSERT INTO bsc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nëngandërayindëleɓi ɓër nënga këɓi onden ɓën, gayikwa ɓën kë ɓëteli ebar el! ");
INSERT INTO bsc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nëngandërayindëleɓi ɓër ỹandi këɓi ola or ŝenene ang eƴamb-ƴamb fo ɓën, ɓër sel këɓi ang men fo ɓën, gayikwa Kaxanu ayël yël këɓi eni ƴamb or ŝenene ol xali eni med! ayël këɓi yël eni ceɓ xali eɓi ped. ");
INSERT INTO bsc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nëngandërayindëleɓi ɓër gë axaỹënan ɓën, gayikwa Kaxanu axaỹënan këŋo xaỹënan ɓën ɓëte! ");
INSERT INTO bsc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nëngandërayindëleɓi ɓër gë ow̃ëkw ow̃ënëk ɓën gayikwa ɓën ex ɓër këŋo wat Kaxanu ɓën! ");
INSERT INTO bsc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nëngandërayindëleɓi ŝaland aketëxeta ɓën gayikwa ɓën kë hi oɓaŝ or Kaxanu ol! ");
INSERT INTO bsc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nëngandërayindëleɓi ɓër kënëɓi rixërand në end epëɓ ed fëɓ këni end ŝenene ɓën, gayikwa ɓën xwënëk owun or gër orën ol! ");
INSERT INTO bsc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nëngandërayindëleŋun ado enun cirërand, ado enun dixërand, ado enun nagaŝandërand end ex yo në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nëngandërayindëleŋun, mandërayindën onënga ol gayik amaŝën atëm kën sëkëx ƴaŋ gër orën. Enimin mondako banëɓi rixërand ɓëlaw̃ënel ɓër Kaxanu ɓër lëngwatëgu këŋun gër ngwën ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Wën ex ongal ond ebar oŋ. Ɓari angëmëne ongal oŋ axac xacëk, gë ine kë ỹëw gaŝëxe? Alexëx fo ex fac eni bëñërax ɓela ɓën? ");
INSERT INTO bsc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wën ex angoɓen and ngwën aŋ. Angol and ƴaŋ në etënd aŋ ax gind na monem. ");
INSERT INTO bsc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ani pëtënënd na lambo in do eni ŋoɓ gë enëp, ɓarikan ƴaŋ këni xaw̃ënd eɓi ŋoɓaxënënd ɗek ɓër gër iciw̃ ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Awa ola orewën ol ŋoɓayindëleɓi ɓela ɓën, eni wataxënënd ɓenjekax ɓend kën rind ɓeŋ do eno cëkwaxën Sorix irewën Kaxanu, mëŋ ar ex ƴaŋ gër orën an.» ");
INSERT INTO bsc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Këren yëland na mëne anëka ƴow këme me ƴepën Acariya aŋ do gë er reƴa këni ɓëlaw̃ënel in. Ame ƴow ex na me ƴepën, ɓarikan me ŋata. ");
INSERT INTO bsc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ɗal in këmun felënd, enimin, xali ex dëxëta orën ol do gë ebar el, inger gimatak ax dëxëta na gër acariya, xali ex ŋata ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Awa ar kë lif apela and xurik ex ɓa gër acariya do eɓi tëƴalind ɓela ɓën eno tëfëteli an, ajo kë xuri ex ɓa gër owun or ƴaŋ gër orën. Ɓarikan, ar kë rind er rek acariya in do eɓi tëƴalind ɓela ɓën eno tëfëteli an, ajo ar gapak ko hi gër owun or ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mëŋ këmun felaxënënd, angëmëne or ŝenene orewën ol ax nëmëca ex na or ɓëŝalen do gë or Ofariseŋ ol, din an ɗil na gër owun or gër orën.» ");
INSERT INTO bsc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ax gi ex na nde awël wël kën er fel banëɓi ɓëxarëk ɓërewën in: “Ax gi ex na monaw̃ ala. Ar këŋo law̃ yo ala, ar kiti exo.” ");
INSERT INTO bsc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ɓarikan, wëno ga re këme, ar këŋo xoỹën yo aɓaỹe arexëm, ar kiti exo. Ɓëte ar këŋo re yo aɓinëm: “Wëj aŝoỹik eƴ!” Ɓëxarëk ɓër Ɓëŝëwif ɓën ỹapëk eŋo kiti. Ɓëte ar këŋo re aɓinëm: “Wëj afënirëx eƴ!” ar gër xoɗux exo. ");
INSERT INTO bsc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Awa angëmëne ŝaɗaxa ƴe këƴ eƴ di gër angëɓ do fën eƴ kwitaw mëne aɓaỹe areƴ ỹeỹ xoỹën ki na, ");
INSERT INTO bsc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","teɓël ŝaɗaxa ijo na gër angëɓ eƴ mara en ketënëgu pere. Do and kën xetënëgu aŋ, ɓakaw eƴ ŋata ŝaɗaxa ireƴ in. ");
INSERT INTO bsc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Angëmëne eŋun kucar gë ala do en ƴend ond gër kiti oŋ, wëlër in ngëŋ gër fëña këdi kën h̃at exi ɗëxwëx gër axiti do axiti an exo cena eŋo pel anëkona an exi mëla gër përa. ");
INSERT INTO bsc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ɗal in këmi felënd ɗamana eƴ canaxën gër epëra elo, koɗi ireƴ in ɗek këƴ nëcët.» ");
INSERT INTO bsc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ax gi ex na nde awël wël kën er rek acariya in: “Ax gi ex na mondi orekar ol.” ");
INSERT INTO bsc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ɓarikan wëno ga re këme, ar këŋo nëkon yo asoxari do eŋo ỹandi eni ɗakido, anëka ri këni orekar ol gër emëkw edexëm. ");
INSERT INTO bsc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Angëmëne angës and liw̃ aŋ ki lënanënd eñëŋënax eŋ, nongoloƴëtël eƴ ɗap caw! Gayikwa pecanëlexi eƴ ɓayi gë angës amat, gë exi ɗëxw Kaxanu ɗek eman eŋ gër xoɗux or ax ɗomind na gë eɗomi. ");
INSERT INTO bsc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Angëmëne ataxan andeƴ and liw̃ aŋ ki lënanënd eñëŋënax eŋ, kacal eƴ ɗap caw! Pecanëlexi eƴ ɓayi gë ataxan amat gë exi ɗëxw Kaxanu ɗek eman eŋ gër xoɗux or ax ɗomind na gë eɗomi. ");
INSERT INTO bsc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Acariya aŋ rek: “Ar këŋo feland asoxari arexëm an, pëxwënëleŋo kayëta ir ex sede ir acapëra.” ");
INSERT INTO bsc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ɓarikan, wëno ga re këme, ar këŋo fela yo asoxari arexëm xarak ax gi ex na në end orekar, në ecëñëta eŋo gër orekar. Do ar këŋo ỹër yo asoxari ar fela këŋo icën indexëm, në edi exëni orekar ol gë asoxari ajo.» ");
INSERT INTO bsc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Awël wël kën ɓëte mëne afel fel banëɓi ɓëxarëk ɓërewën: “Ax gi ex na monjaŝar, ɓarikan and këƴ yaŝar gër ow̃ac or Axwën, dil ari er re këƴ in.” ");
INSERT INTO bsc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ɓarikan wëno, ga re këme, ax gi ex na dëŋ monjaŝar. Ax gi ex na monjaŝar an: hik orën ol gayik añëpara and owun or Kaxanu aŋ ex. ");
INSERT INTO bsc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ax gi ex na monjaŝaran ebar el gayik ambëñaxën andexëm ex. Ax gi ex na monjaŝaran ɓëte Yerusalem in gayik angol and emun etëm aŋ ex. ");
INSERT INTO bsc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ado gaf ireƴ in dëŋ ax gi ex na monjaŝaran gayik emban gematak aƴ kor na eƴ peŝën, ɓëte aƴ kor na eƴ ɓanëngënin end feŝëk eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gër ed ebax eƴ yaŝar, ga w̃a w̃a këƴ del “Awa”, ɓari ga h̃ëp h̃ëp këƴ del “Ali”. Gë ỹeỹ ɓaŝ këƴ na, awa er ŝaɓucara ex.» ");
INSERT INTO bsc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Ax gi ex na nde awël wël kën er rek acariya in: “Ar këŋo fëtinën yo ala angës, pëtinënëleno mëŋ ɓëte andexëm aŋ! Ɓëte ar këŋo foƴëtën yo ala añënga, poƴëtënëleno mëŋ ɓëte andexëm aŋ!” ");
INSERT INTO bsc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ɓarikan wëno ga re këme mëne axo gi ex na monjaka axeỹax ar ki rixërand an. Angëmëne ala exi cën gër añam and liw̃, ɓexënëlo and ŝame aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ɓëte angëmëne ala exi kwëñexënënd gayik aỹandi ỹandi këŋo exi kan acuɗ atëm aŋ, teɓënëlo gë anëngwën ak. ");
INSERT INTO bsc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Angëmëne ala nëỹali ki na eƴo ɗëɓin eɗëɓ etiɓax në apakan amat ɗëɓinëlo në ɓapakan ɓaki. ");
INSERT INTO bsc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ar ki xarand an, yëlëlo do ar ỹandi këŋo eƴo ñomëx an, këreƴëŋo ɗëc na.» ");
INSERT INTO bsc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ax gi ex na nde awël wël kën er rek acariya in: “Ɓalindëlexi end aŝandax eŋ, do cusëlo arangoỹëra andeƴ an.” ");
INSERT INTO bsc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ɓarikan, wëno ga re këme: ŋanindënëɓi ɓër xoỹër këŋun ɓën, calenindënëɓi ɓër këŋun rixërand ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mondako këni nangëraxën ɓela ɓën mëne wën oɓaŝ or Faba Kaxanu hi kën, mëŋ ar ex ƴaŋ gër orën an. Enimin mëŋ key yo key këɓi h̃oɓand gë eñan endexëm eŋ ɓela ɓën, hi këni ɓëxeỹax, hi këni ɓër ŝenene. Ɓëte aɓi ɗëcënd na tëɓ iŋ, hi këni ɓër ŝenene hi këni ɓësëmbak. ");
INSERT INTO bsc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Angëmëne eŋun ɓalënd end ɓër këɓi ɓalënd endewën ɓën fo, amaŝën and fe wa kën ŝotëx gër Kaxanu? Ax gi ex na nde ɓësëf ɓër ŝagale ɓën dëŋ mondako wata këni? ");
INSERT INTO bsc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Do angëmëne gë ɓëmaỹe ɓëndewën ɓëŋ fo kën ŝëmarënd, ecarax end fe wa kën rind? Ax gi ex na nde ɓësëmbak ɓën dëŋ mondako wata këni? ");
INSERT INTO bsc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ang hi ko ŝenene Kaxanu, Sorix irewën ak, mëŋ ar ex ƴaŋ gër orën an, wën ɓëte giyin ŝenene mondako fo.» ");
INSERT INTO bsc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Angëmëne ɓenjekax kën rind, këren caland na enun wat ɓela ɓën. Angëmëne mama dëŋ kën rind enun wataxën, amaŝën an cotëx na gër Sorix irewën Kaxanu, mëŋ ar ex ƴaŋ gër orën an. ");
INSERT INTO bsc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","And këƴëɓi rëcarand ɓëxaỹënaxik aŋ, këreƴ deƴarand na poyoma eni cëkwaxën ɓela. Ax gi ex na nde mondako këni rind ɓëỹëŋënax ɓër kë laɓayand ɓën gër ɓaciw̃ ɓacaleya do gër opëña ond gër angol enëɓi cëkwaxënënd ɓela ɓën? Ɗal in këmun felënd, mondako kë ŝanënd amaŝën andeɓën aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ɓarikan, wëj and këƴëɓi rëcarand ɓëxaỹënaxik aŋ, ataxan and ŝame aŋ kërex nangënd na er kë rind and liw̃ in. ");
INSERT INTO bsc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dëcarayindëɓi ɓëxaỹënaxik ɓën xarak ɓela ɓën ani watënd na, do Faba Kaxanu mëŋ ar kë watënd er këƴ ŝonënd an, aw̃aŝën ki w̃aŝën.» ");
INSERT INTO bsc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«And kën ŝalend aŋ, kërenëɓi tëfëtelind na ɓëỹëŋënax ɓër kë laɓayand ɓën. Moŋan h̃an cale ind mokwëŝa lëf gër ɓaciw̃ ɓacaleya iŋ, do gë ind gër ocanditëra od opëña od gër angol iŋ enëɓi wataxënënd ɓela ɓën. Wëno ɗal in këmun felënd, mondako kë ŝanënd amaŝën andeɓën aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ɓarikan, wëj and ki ỹandi eƴ cale aŋ, përal ebët ed aciw̃ anakaya andeƴ el, eƴ calexën. Faba Kaxanu, mëŋ ar ki watënd an, ayakali ki yakali er këƴo xarand gër ed ɓeŋ in. ");
INSERT INTO bsc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ɓëte and kën ŝalend aŋ, këreŋun kurelind na eyeƴan el, ɓësëmbak ɓën kë yëland mëne monjeƴan mbaŋ fo ko yakalind Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kërenëɓi tëfëtëlind na! Gayikwa Faba Kaxanu ɗek ko nangënd er ỹandi këŋun in ɗamana eno karaxën. ");
INSERT INTO bsc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ɓaxëtin ang ỹapëk eno calend ak: “Faba ireɓi, wëj ar ex gër orën an, Mënëlex ow̃ac oreƴ ol, ");
INSERT INTO bsc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ƴowëlex owun oreƴ ol. Dil gër ebar er ỹandi ki in ang këƴ rind gër orën ak. ");
INSERT INTO bsc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yëlindëɓo key yo key er këmi ƴamb in, ");
INSERT INTO bsc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Teɓanëlëɓo ɓeɓër këmëni w̃enanënd ɓela ɓën ang këmëni seɓanënd ak ɓiyi ɓëte ɓër këɓo w̃enanënd ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Këreƴëɓo teɓ na eɓo naŋëtarand do mi mendërand. Dacëtëlëɓo gër Aỹëŋënax!” ");
INSERT INTO bsc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Angëmëne wën aseɓan kënëɓi seɓanënd ɓela ɓën ɓamena ɓand kënun w̃enanënd ɓaŋ, Faba Kaxanu, mëŋ ar ex ƴaŋ gër orën an, aseɓan këŋun seɓan wën ɓëte. ");
INSERT INTO bsc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ɓari angëmëne anëɓi teɓanënd na, aŋun teɓan na ɗe wën ɓëte ɓamena ɓandewën ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«And kën siw̃ind aŋ këren kaỹëninand na ang ɓëỹëŋënax ɓër kë laɓayand ak. Ɓën ata dëxas in dëŋ këni ỹëŋëninënd eni nangëraxën ɓela ɓën mëne asiw̃i siw̃i këni. Ɗal in këmun felënd mondako kë ŝanënd amaŝën andeɓën aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ɓarikan wëj and këƴ siw̃ind aŋ, dëxasal aye do eƴ ceƴaya angiri in gë gaf ak. ");
INSERT INTO bsc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ɓela ɓën këreni nang na mëne asiw̃i siw̃i këƴ. Ɓarikan, Faba mëŋ ar ki watënd gër ed ɓeŋ an, aw̃aŝën ki w̃aŝën.» ");
INSERT INTO bsc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Këren kwëjënalind na napul ir ŝot kën gër ebar ro in gayik axor ex ex ƴaner, axor ex eni ñama oyame ol, ɓëte axor ex eni meɗ ɓërek gër ed w̃ëxëta kën. ");
INSERT INTO bsc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ɓarikan, taỹindën napul in gër orën gayik fën ax ƴaner na, oyame ani ñama na, ɓërek ani nëxen na ofëra eni dekaxën lëf gër ed xwët kën. ");
INSERT INTO bsc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Awa gër ed xwët këƴ napul ireƴ in, fën ex anjëlan andeƴ aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ɓangës ɓaŋ ang lambo fo ex gër eman. Do angëmëne ɓandeƴ ɓaŋ ɓamëngw ex ɗek eman endeƴ eŋ xërikërak. ");
INSERT INTO bsc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ɓarikan angëmëne ɓaciw̃ëk ex, ɗek eman endeƴ eŋ ŝamëɗanëk. Awa, angëmëne er këƴ yëland angoɓen ex in ax gi ex na angoɓen, wëj anëka xul ki ecamëɗan el!» ");
INSERT INTO bsc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ala ax kor na exo gi xaɗëp ir ɓëxwën ɓëxi ba eɓi diyeninënd ɓela ɓëxi. Enimin afo eŋo cus aỹanar an do eŋo ŋan axinëm an, eŋo pëɓ aỹanar an do eŋo yaf axinëm an. Mëŋ ex, wën an kor na eŋun ɓalënd gwër fo end Kaxanu eŋ do gë end koɗi eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mëŋ këmun felaxënënd këren dendërand na gër aniyan andewën end er kën ƴamb eŋ, end kën er ŝeɓ eŋ, ba end ɓanjëm ɓand kën ŝuɗa eŋ. Aniyan andewën aŋ xëɓënëk nëmëc eƴamb-ƴamb in, ɓëte eman eŋ xëɓënëk nëmëc ɓanjëm ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ax gi ex na nde aye kënëɓi watënd oŝël ol: ani neɗërand na, ani kanarand na, ɓëte ỹoweỹ ani cacënd na. Ɓarikan Faba Kaxanu, mëŋ ar ex ƴaŋ gër orën an, këɓi lëɓand. Ako nde yëla kën mëne endeɓën eŋ këŋo ɓalënd nëmëc gë endewën eŋ? ");
INSERT INTO bsc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wën ang hi kën ako, noỹo wa kë xor exo ɓaŝa ɓakey gër aniyan andexëm gë odendëran ok?» ");
INSERT INTO bsc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Do ine cëŋ wata kën edendëran ed në end ɓanjëm el? Ax gi ex na nde aye kën watënd opëtëfët od ondës ond gër apuỹ ok: ax diyenind na, ɓëte ax ɓanënd na ɓanjëm. ");
INSERT INTO bsc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ɓarikan, ado Salomoŋ dëŋ gë ɗek enjaran endexëm eŋ, mëŋ ar hi bax gë napul isëm an, ondës oŋo këŋo xucand oye ol. ");
INSERT INTO bsc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gayikako Kaxanu kë ỹaŋënënd mondako ondës ond gër olen oŋ, ond ex ro doro do ecan gër xoɗux oŋ, aŋun din na nde nëmëc enjekax wën? Ata wën ɓër gë ekwëta etil hi kën ɗe. ");
INSERT INTO bsc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Këren dendërand na end er kën ƴamb eŋ, end er kën ŝeɓ eŋ, ba end ɓanjëm ɓand kën ŝuɗa eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ɓeŋo ɗek ɓër aŋo kwëta ex na Kaxanu fo ɓën kë ŝaland wayët ɓeŋo. Ɓarikan Faba, mëŋ ar ex ƴaŋ gër orën an, anang nang ko mëne aỹap ỹapëk en cotëra ɓeɓijo ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Calayindën pere owun ol do gë ola or ŝenene orexëm ol gër aniyan andewën. Ata fo këŋun sënd ɗek ɓeɓër këŋun ỹandi en cot ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Akey and ecan aŋ gë andexëm kë rendëra, wën këren dendërand na. Akey and ex yo, er kën ŝot in, pedindëleŋun.» ");
INSERT INTO bsc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Ax gi ex na mokiti ɓela ɓën këdi këŋun xiti Kaxanu wën ɓëte. ");
INSERT INTO bsc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Enimin, ang kënëɓi xitind ɓela ak këŋun xiti wën ɓëte. Gë acariya and kënëɓi sëƴinënd ɓela aŋ fo këŋun w̃aŝën wën ɓëte. ");
INSERT INTO bsc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Inew̃a këƴ nëkonaxënënd atëxësëx and lëŋa këŋo aɓinëx aŋ do këƴ nemënd mëne wëj yer xëcar in lëŋa ki? ");
INSERT INTO bsc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ba mondake wa këƴ xor eƴo pel aɓinëx: “Ñëmël mi dëxëtën atëxësëx and gër angës aŋ”, xarak wëj yer xëcar in lëŋa ki? ");
INSERT INTO bsc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wëj aỹëŋënax ar kë laɓayand hi këƴ. Dëxëtël wa pere xëcar ir gër angës andeƴ in eƴ wataxën aye atëxësëx and lëŋa këŋo aɓinëx aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Këdi kënun ŝenaxën enun ŋatëra, kërenëɓi yëlënd na ew̃ënëk in oɗaŋët ok. Ɓëte këdi këni wëñëra oƴeri ok, kërenëɓi ɗapënënd na ɓambëxwëbëxw ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Karayindëno Kaxanu eŋun yëlëraxën, calayindën en cotaxën, tëmbindën enun përëtënaxën ebët el. ");
INSERT INTO bsc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Enimin ar kë xarand an, ayël këno yëlënd. Ar kë ŝaland an, aŝot këno ŝotënd. Do ar kë sëmbënd epëra an afërëtën këno fërëtënënd. ");
INSERT INTO bsc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ala nde exëna ang hi kën ro ako, ar këŋo yël itox indexëm ekaỹ and këŋo xara eƴamb-ƴamb aŋ? ");
INSERT INTO bsc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ɓëte ala nde exëna ar këŋo yël andën and këŋo xara ekan aŋ? ");
INSERT INTO bsc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ax gi ex na nde ang xwëj kën yo anang nang kën eyël ed oɓaŝ orewën ɓeɓër yek el? Awa Sorix irewën, mëŋ ar gër orën an, aɓal këŋo ɓalënd nëmëc endewën eŋ do ayël këɓi yël ɓeɓër yek ɓën ɓër këŋo xarand ɓën!» ");
INSERT INTO bsc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Ang këŋun ỹandind enun dinënd ɓela ak, wën ɓëte dinindënëɓi mondako fo. Mondako rek acariya aŋ, gë okayëta od ɓëlaw̃ënel ok. ");
INSERT INTO bsc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ɗilin gër ebët ed mëreƴ, gayikwa ebët ed fëña ir kë w̃ëland gër enemi el aỹang ỹangëk, do ɓëranjëm kë lilënd. ");
INSERT INTO bsc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mëreƴ hik ɗe ebët el do gë fëña ir kë h̃atelind gër aniyan in, ani ñëmb ex na ɓër kë watënd ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Titinayin, ɓëlaw̃ënel ɓënëgwëŝ kë ƴow na. Er këni hi fac-fac in ang opeỹ onambik fo xarak lëf-lëf in ang ojëlemu okeỹax fo hi këni. ");
INSERT INTO bsc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gë odëw̃ërëw̃en odeɓën ok, mëne ngëŋ gë ɓeɓër këni rind ɓën kënëɓi ỹana enëɓi pëlëtënd. Ax gi ex na nde ala ax kwëcand na reseŋ në andëmbën? Ɓëte ala ax kwëcand na ondan në apeɓ? ");
INSERT INTO bsc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Atëx anjekax aŋ, odëw̃ërëw̃en ojekax fo kë rëw̃ënd. Atëx añëŋënax aŋ, odëw̃ërëw̃en oñëŋënax fo kë rëw̃ënd. ");
INSERT INTO bsc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Atëx anjekax aŋ, ax gind na gë odëw̃ërëw̃en oñëŋënax, atëx añëŋënax aŋ ax dëw̃ënd na odëw̃ërëw̃en ojekax. ");
INSERT INTO bsc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ax gi ex na nde atëx and ax dëw̃ënd na odëw̃ërëw̃en ojekax aŋ, asaw̃ këni saw̃ënd do eni ɗap gër xoɗux? ");
INSERT INTO bsc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Awa ɓëlaw̃ënel ɓënëgwëŝ ɓën, gë ɓeɓër këni rind ɓën kënëɓi ỹana enëɓi pëlëtënd.» ");
INSERT INTO bsc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Ax gi ex na ɗek ɓër ke w̃acërand: “Axwën, Axwën” ɓën kë lil gër owun or gër orën, ɓarikan afo ar kë rind oñandi od Faba ir ƴaŋ gër orën an. ");
INSERT INTO bsc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yatir këme ɓakaw gër ngwën ro mëni kiti ɓela ɓën, ɓëranjëm kë ỹana exe denitaxënënd. Ata ɓërëmar eni dend: “Axwën, Axwën ax gi ex na nde paɓ gë ow̃ac oreƴ ol bami yeƴanënd ang ɓëlaw̃ënel, ɓëte paɓ gë ow̃ac oreƴ ol bamëni w̃ayënd ɓëyël ɓën gër ɓela?” Ɓëjo ɓëte: “Axwën, ax gi ex na nde ɓiyi gë ow̃ac oreƴ ol bami rind ɓecarax ɓendanjëm?” ");
INSERT INTO bsc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ɓarikan er këme ỹana mëni yakand: “Wëno amun nang ex na ɗe! Pacanaxëne wën ɓëw̃endëran ɓëjo!”» ");
INSERT INTO bsc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Awa ar kë ɓaxëtënd eyeƴan edam do exo dind ang re këme ak, ang asoŝan arenik ar ɓaƴëk aciw̃ andexëm në aparëfac fo hi ko. ");
INSERT INTO bsc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ga ƴowëk tëɓ iŋ, ofesa oŋ ỹëmëk, ekoc el ŝëñëk aciw̃ aŋo: ɓari ax wëc ex na gayikwa edëɗa edexëm el gër aparëfac hi bax. ");
INSERT INTO bsc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ɓarikan ar kë ɓaxëtënd yo eyeƴan edam do axo dind na er re këme in, er këni wëndër gë afënirëx ar ɓaƴëk aciw̃ andexëm në eɗini fo. ");
INSERT INTO bsc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ata and ƴowëk tëɓ aŋ, oỹëm ol ŝëñëk aciw̃ aŋo. Ataŋ wëcëk do yëcarëk ɗek.» ");
INSERT INTO bsc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","And h̃ata ko Yesu aŋ, ɓela ɓën ɗek ŝaran këɓi ang baɓi sëƴalind ak. ");
INSERT INTO bsc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Enimin gë or gapak baɓi sëƴalind, ax gi ex na ang ɓëŝalen ɓëreɓën ak. ");
INSERT INTO bsc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu ga h̃ata ko ang baɓi sëƴalind kap gër etënd ak, ŝëla ko. Ata amëxwër and ɓela aŋ këno sëfand ɓura-ɓura. ");
INSERT INTO bsc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na xacëraw këŋo ar gë ameỹ, foxi ko gër lëngw irexëm do ko rend: «Axwën, ga ỹandi ỹandi ki, axor këƴ xor eƴe mënën me pak.» ");
INSERT INTO bsc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ga h̃ëmba këŋo, re ko: «Awa aỹandi wa ỹandi ke, mënël!» Ataŋ ala ajo w̃ën ko ga ŝanëk ameỹ aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ata Yesu fel këŋo: «Awa ala këreƴëŋo pel na ɗe! Ɓarikan, ƴel exi nëkon aŝaɗaxan an eƴ dixën ŝaɗaxa ir ew̃unëtan in, ang ỹëgw ko Moyis ak eni nangëraxën ɓela ɓën osede oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ga xucak eŋo, Yesu ko w̃aỹind gër Kafarënawum. Ga ko h̃at, emun end ocoroɗa xacëra këŋo do këŋo xarand: ");
INSERT INTO bsc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Axwën, ariyenin aram an ŝëxwërak gër iciw̃, ata mbaŋ exo.» ");
INSERT INTO bsc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yaka ko Yesu: «Wëno aƴeli këme yeli mo pakën.» ");
INSERT INTO bsc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ata re ko emun end ocoroɗa eŋ: «Axwën, adokiŋ wëj nde eƴ ŋat gër yangana iram? Axe ñap ex na! Ɓarikan, yeƴanël tuŋ emat ata ko fak ariyenin aram an. ");
INSERT INTO bsc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gayikwa wëno dëŋ ariyenin ar ɓëlëngw ɓëram hi këme do ari këme rind ang këne felënd ak. Wëno ɓëte gë ocoroɗa od këmëni lëngwën hi këme. And këmo law̃ën iɓat aŋ, aƴe ko ƴend, and këmo w̃ac iŝëxe aŋ, exe tëkaw. Ɓëte and këmo fel ariyenin aram exe din ỹeỹ aŋ, ari ko rind.» ");
INSERT INTO bsc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu, ga ɓaxët këŋo emun eŋo, nëngan këŋo endexëm eŋ. Ata fel këɓi ɓër baŋo sëfërand ɓën: «Ɗal in këmun felënd, ado gër wën Ɓëyisërayel ro dëŋ, elod amo wat ex na ar gë ekwëta edako rako an. ");
INSERT INTO bsc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ga re këme, akey amat, beɓët yo beɓët këni xaniraw ɓela ɓëranjëm enëɓi ketëna Abëraxam, gë Isak do gë Yakob gër ñambëran ind gër owun or gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ɓarikan oɓaŝ or gër owun ol, aw̃aỹ kënëɓi w̃aỹ gër ecamëɗan ed fac. Mondako këni ỹana eni denitand do eni ŋatënd eɓasa el.» ");
INSERT INTO bsc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ata ga h̃ata ko eŋo, fel këŋo emun end ocoroɗa eŋ: «Maỹil! Ga xwëta këƴe ako, afak ko fak ariyenin areƴ an!» Ata ga yeƴan ko mondako fakëx ko ariyenin an. ");
INSERT INTO bsc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ga xucak eŋo, Yesu ƴe ko gër iciw̃ ind Simoŋ Piyer. Sëk këŋo ayaraw̃ën isoxari ir Simoŋ Piyer ga ŝëxw këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ga h̃ëmba këŋo na, ayaraw̃ën ar Simoŋ Piyer xoc këŋo ataŋ acëxwël aŋ. Ata xani ko xwiriŝ eɓi ɗëɓa. ");
INSERT INTO bsc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Genëka, w̃ëlanëgu këno ɓër gë ɓëyël ɓëranjëm. Ga xeỹan këɓi na, ɓëyël ɓën ŝan këni gër ɓela do fakën këɓi ɓëte ɗek ɓëŝëxwëra ɓër w̃ëlaraw banëɓi ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mondako h̃ata bax er re baxo alaw̃ënel Esayi in end Yesu eŋ: «Mëŋ lëɓinak toro indeɓi iŋ, Mëŋ nëmbak ocëxwëra odeɓi ok.» ");
INSERT INTO bsc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","And wata ko Yesu mëne në eñëmbërëgu exëni ɓela ɓër xeta baŋo ɓën, fel këɓi ɓësëfan ɓërexëm ɓën eni kegëta anjer aŋ! ");
INSERT INTO bsc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ata ga këni ƴe ond gër anjer oŋ, aŝalen aɓat xacëra këɓi do ko rend: «Asëƴali, asëƴali, wëno gër ed këƴ ƴe yo, asëf këmi sëf.» ");
INSERT INTO bsc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yaka këŋo Yesu: «Ax gi ex na nde anang nang këƴ mëne ojakëra ok gë ow̃aỹi exëni, do oŝël or gër orën ol, gë oyël exëni? Ɓari wëno Asëñiw̃ ar ala an, ado gë añombe ak dëŋ axe gi ex na.» ");
INSERT INTO bsc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ata gër amëxwër and ɓësëfan rëw̃ ko ɓëte ala: «Axwën, wëno cëŋ faba nemik! Teɓanële tan me ƴe mo mëxwëtaw pere.» ");
INSERT INTO bsc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ata Yesu yaka këŋo: «Teɓëlëɓi ɓëŝësëk ɓën eni mëxwëtar do wëj tëfëguye wëno!» ");
INSERT INTO bsc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu gë ɓësëfan ɓën fëra këni gër ikuluŋ do këni xegëtand. ");
INSERT INTO bsc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","And hi këni mërëxand gër anjer aŋ, h̃atëguk tëɓ ind gë ekoc etëm. Ata men oŋ kë xanind ɓomeŋ ɓomeŋ xali kë rëmbayand ikuluŋ iŋ. Yesu mëŋ, këŋo raŝënd ƴem. ");
INSERT INTO bsc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ata ɓësëfan ɓën ga ɓu këɓi, sëka këno do këno nëngëtënd: «Axwën, Axwën ecëseleɓo ɗe! Pexënëlëɓo!» ");
INSERT INTO bsc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ga nëngëta ko, w̃ëka këɓi: «Inew̃a yëdaraxën kën go? Inew̃a ex ekwëta etil ed ŝot kën elo?» Ga xani ko na, xeỹan ko anjer aŋ gë ekoc el. Ata yeriri! ");
INSERT INTO bsc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ga ŝaran këɓi ɓësëfan ɓën këni w̃ëkarënd: «E ala ajo? Ado anjer aŋ gë ekoc el dëŋ aɓaxëtën këno ɓaxëtënënd!» ");
INSERT INTO bsc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu gë ɓësëfan ɓën ga xegëta këni, h̃at këni gër ebar ed Ɓëgadara. Ata xacëra kënëɓi ɓësoŝan ɓëxi ɓër gë ɓëyël. Gër oñeg ŝanëgu bani do ỹigën bani xali. Ado ala abax yëxw na exo kuca fëña ir oñeg in. ");
INSERT INTO bsc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ga h̃at këni gër ed hi baxo këni xeỹënd: «Xey wëj Asëñiw̃ ar Kaxanu, inew̃a ƴowaxënëgu këƴ ro? Ba eƴëɓo narën nde ƴow këƴ xarak ax ŋat ex na amëd aŋ?» ");
INSERT INTO bsc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nacët ako, ɓambëxwëbëxw banëɓi xaɗacërand na. ");
INSERT INTO bsc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ata ɓëyël ɓën këno xarand Yesu: «Këla ga w̃a w̃a këƴ, cëñëtalëɓo mëni ɗil ɓambëxwëbëxw ɓaŋo fën!» ");
INSERT INTO bsc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ata re ko Yesu: «Ƴeyin!» Ga ŝan këni gër ɓësoŝan ɓëxi ɓëjo, ɓëyël ɓën lil kënëɓi ɓambëxwëbëxw ɓaŋ. Ɓambëxwëbëxw ɓaŋ hër këni gand engew̃ ler gër ɓëŋa ir anjer, latira këni polo gër men do noỹeli këɓi ɗek kece in. ");
INSERT INTO bsc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ɓëxaɗac ɓën ŝapër këni bër, hërëra këni xali gër angol reƴarax këni ɗek end ɓër gë ɓëyël eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ata ɗek angol aŋ xacëra këno Yesu. Sam ga wat këno, xara këno exo ŋaw̃ëta ebar edeɓën el. ");
INSERT INTO bsc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ata Yesu ɓaka ko polo gër ikuluŋ, xegëta këni gë ɓësëfan ɓën anjer aŋ do kwël w̃aỹi këni gër angol andeɓën. ");
INSERT INTO bsc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na gër ed h̃at bani, lëɓiw këno aseỹik në angaw̃. Gogo nde ga nang ko Yesu mëne ɓëjo axwëta xwëta këno. Fel këŋo aseỹik an: «Asëñiw̃ën kapinal, wëno anëka seɓan këmi ɓamena ɓandeƴ ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ata ɓëŝalen ɓër ebax na ɓën këni rend: «Në ecir eŋo Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ga nang ko Yesu ang bani yëland ak, w̃ëka këɓi: «Wën inew̃a ojëlan oñëŋënax oko gër ow̃ëkw orewën? ");
INSERT INTO bsc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Inew̃a saxëk me de: “Anëka seɓan këmi ɓamena ɓandeƴ ɓaŋ nde”, ba: “Kanil, eƴ ɗëkw ebën edeƴ el eƴ ƴexëra nde?” ");
INSERT INTO bsc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ɓarikan en nangaxën mëne wëno Asëñiw̃ ar ala an, aŝot ŝot këme or gapak or mëni teɓanënd ɓela ɓën gër ebar ro ɓamena ɓaŋ, në epelemo aseỹik an: “Kanil, eƴ meɗ angaw̃ andeƴ aŋ do eƴ maỹi!”» ");
INSERT INTO bsc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ata na dëŋ aseỹik an xani ko xwiriŝ do kwël w̃aỹi ko. ");
INSERT INTO bsc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ga wat këni ecarax eŋo, amëxwër aŋ yëdara këni, ata këno ŝëkwand Kaxanu mëŋ ar yël këɓi ɓela panga itëm ind mondako an. ");
INSERT INTO bsc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","And xani ko Yesu okucan aŋ, wat këŋo asoŝan ar këno w̃acënd Maco ga ỹëpa ko lëf gër aciw̃ and ɓësëf ɓër ŝagale. Fel këŋo: «Wëj tëfëguye!» Ata xwiriŝ Maco do kwël sëf këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ga ỹëpara këni gër iciw̃ ind Maco, ƴowëraw këni ɓësëf ɓër ŝagale do gë ɓëw̃endëran ɓëranjëm eni ƴambëra gë Yesu do gë ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ga wat këni eŋo, ofariseŋ ok kënëɓi hëbandërand ɓësëfan ɓën: «Inew̃a këni ƴambëraxënënd asëƴali arewën an gë ɓësëf ɓër ŝagale ɓën do gë ɓëw̃endëran ɓën?» ");
INSERT INTO bsc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ga wël këɓi Yesu, yaka ko: «Ɓëŝëxwëra ɓën kë ƴend gër axora, ax gi ex na ɓëɓëngw ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ata ƴeyin en tëƴax er w̃acayak eyeƴan elo in: “Er w̃ëka këmun wën ɓulunda iram in, en gi gë axaỹënan do eŋun ɓalërënd, ax gi ex na en dind ocaɗaxa.” Wëno ɓëw̃endëran ƴow këme mëni pel eni nëngwët ola oreɓën ol, ax gi ex na ɓër ŝenene.» ");
INSERT INTO bsc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ata h̃atëgu këni ɓësëfan ɓër Ŝaŋ Batis ɓën, w̃ëka këno Yesu: «Inew̃a ɓayik ani tiw̃ind na ɓësëfan ɓëreƴ ɓën ang këmi siw̃ind laŋ ɓiyi gë ofariseŋ ak?» ");
INSERT INTO bsc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu yaka këɓi: «Oɗawo od ŝambenjar ir kë ỹërënd ok axor nde këni xor eni caminarand xarak gër ekana ɓayi këni? Aƴow kë ƴow ɓakey ɓand këni ŝapër ɓaŋ, amëd aŋo këni siw̃i. ");
INSERT INTO bsc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Ala ax kaɗënd na anjëm akarëk gë angaŝax gayikwa angaŝax aŋ ata kë reg akarëk aŋ do ex ŋesi kaŝ-kaŝ. ");
INSERT INTO bsc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɓëte andamat fo ex, ala ax cëlënd na ngoƴ ingaf në ɓamote ɓakarëk. Angëmëne ala exo di mondako, ɓamote ɓaŋ kë fëtira ex nexënara do ngoƴ iŋ ex ɗexira. Në ɓamote ɓangaŝax ỹapëk mocël ngoƴ ingaf iŋ ex gixën momëxwëta.» ");
INSERT INTO bsc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ga këɓi felëra mondako, h̃atëgu ko alëngw ar aciw̃ acaleya. Foxi ko gër lëngw irexëm ko rend: «Asëƴali endënaw̃ endam eŋ eceɗe-eceɗe xoti ko, ƴeye eƴo ŋëmba ata ko liya gaŝëxe.» ");
INSERT INTO bsc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ata Yesu gë ɓësëfan ɓërexëm ɓën sëfër këni gë ala ajo. ");
INSERT INTO bsc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ata fed këni gër fëña gë asoxari ar baŋo ƴexayaxënënd oŝat elod ɓëniy epëxw gë ɓëki. Ga nëfënëfa ko gër enga, sëkën këŋo Yesu do xwixwëta ko ambana and acuɗ andexëm aŋ gand epoƴ. ");
INSERT INTO bsc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Rixën baxo mondako asoxari ajo, axwëta xwëta baxo: «Exe kaỹënd yo me kwixwëta ɓanjëm ɓand Yesu ɓaŋ afak këme fak.» ");
INSERT INTO bsc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sam ga xwixwëta ko tuŋ, Yesu ŝena ko. Ga wat këŋo asoxari an, re ko: «Aɓiw̃ën kapinal! Ga xwëta këƴe pakël!» Ataŋ kwël na fo fak ko. ");
INSERT INTO bsc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ata h̃at ko Yesu gër iciw̃ ind alëngw ar aciw̃ acaleya. Sëk këɓi ɓëfarix ɓër ɓacëroti do gë amëxwër and ɓela ga këni ɓara ofarix ol gë otes ok. ");
INSERT INTO bsc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ata re ko Yesu: «Pacanayin, endënaw̃ eŋ araŝ fo këŋo raŝënd, axo cës ex na.» Ɓarikan, ga wël këno këni ƴepënënd er re ko in. ");
INSERT INTO bsc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","And nëcëtëra këɓi amëxwër aŋ, Yesu lil ko gër ed ren bano. Ga lëk këŋo gër ataxan, endënaw̃ eŋ xani ko kwengweremët. ");
INSERT INTO bsc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ata wëlik endeƴ eŋo ɗek ebar ed Galile el. ");
INSERT INTO bsc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","And fakët ko Yesu oñe aŋ, ɓëŝiw̃ëk ɓëxi këno sëfand do këni xeỹënd: «Asëñiw̃ ar Dafid, Asëñiw̃ ar Dafid, kaỹënanëlexi wa ɓiyi!» ");
INSERT INTO bsc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ga h̃at ko gër iciw̃, sëka këno. Ata w̃ëka këɓi: «Axwëta nde xwëta këne mëne axor këme xor mun pakën?» Yaka këni: «Axwën, axwëta xwëta këmi.» ");
INSERT INTO bsc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ga këɓi h̃ëmba gër ɓangës ko rend: «Awa ga xwëta këne ako, pakiyin!» ");
INSERT INTO bsc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ga ŝiw̃ëta këni, Yesu xëŋa këɓi eni cësinali eŋo. ");
INSERT INTO bsc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ɓarikan ɓën ga ŝan këni na, gër ed këni ƴe yo bani reƴarand end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","And ƴe këni ɓëŝiw̃ëk aŋ, w̃ëlaw këno ɓëte amuma and lil baŋo ayël. ");
INSERT INTO bsc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu, ga nëcët këŋo ayël ajo, amuma ko yeƴandërand aye. Ata amëxwër aŋ ga ŝaran këɓi, këni rend: «Awa elod ane wat exe na end ako rako eŋ ro gër ebar ed Isërayel!» ");
INSERT INTO bsc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ɓarikan, ofariseŋ ok këni rend: «Gë panga ind emun end ɓëyël iŋ këɓi nëcëtënd ɓëyël ɓën gër ɓela!» ");
INSERT INTO bsc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ga xucak eŋo, Yesu ko sëfërand ɓangol ɓaŋ: ɓatëm ɓaŋ, do gë ɓatil ɓaŋ, do ko femërand Atëfëtan and owun or Kaxanu aŋ gër ɓaciw̃ ɓacaleya. Ɓëte afakën baɓi fakënënd ɓela ɓën oŝëxwëra or ex yo. ");
INSERT INTO bsc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ga wat këɓi ɓela ɓën ɓamëxwër, ɓamëxwër, xaỹënan këŋo gayik er hi bani ang opeỹ od gë axaɗac këm fo. ");
INSERT INTO bsc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ata fel këɓi ɓësëfan ɓërexëm ɓën: «Ekanara ed eƴamb el ɗek ỹëmbëk, ɓari ɓëxana ɓën ani ñëmb ex na. ");
INSERT INTO bsc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Awa caleyino axwën eƴamb eɓi ɓaŝaw.» ");
INSERT INTO bsc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Akey amat, Yesu w̃ac këɓi ɓësëfan epëxw gë ɓëxi ɓërexëm ɓën do yël këɓi panga ind enëɓi nëcëtaxënënd ɓangoc ɓañëŋënax ɓaŋ gër ɓela do ɓëte enëɓi pakënaxënënd oŝëxwëra or ex yo do oseỹi or ex yo. ");
INSERT INTO bsc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mondako ebax omac od oparëxanda epëxw gë oki ok: Simoŋ ar nëngwët baŋo Piyer an, do gë Andëre aɓinëm; Ŝak gë Ŝaŋ ɓosëñiw̃ ɓor Sebede. ");
INSERT INTO bsc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip gë Barëtelemi, gë Toma, gë Maco, asëf ar ŝagale an. Ŝak, asëñiw̃ ar Alëfe an, do gë Tade. ");
INSERT INTO bsc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ aw̃eran an do gë Yuda Isëkariyot, ar lëxw baŋo Yesu an. ");
INSERT INTO bsc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɓën ebax epëxw gë ɓëxi ɓër law̃ën baɓi Yesu ɓën. Ɗamana eni ƴexën, ɓapela ɓaŋo yël baɓi: «Këren ƴend na gër ɓër ax gi ex na Ɓëŝëwif ɓën, ɓëte këren ɗilënd na gër ɓangol ɓand Ɓësamari ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ƴeyindën gër Ɓëyisërayel ɓër nambërak ang oyel fo ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pemërayindën tar fëña in mëne owun or gër orën ol ɗam ex. ");
INSERT INTO bsc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakënindënëɓi ɓëŝëxwëra ɓën, kaninindënëɓi ɓëŝësëk ɓën gër ecës, mënënindënëɓi ɓër gë ameỹ ɓën. Nëcëtindënëɓi ɓëyël ɓën gër ɓela. Ang xaỹënan këŋo Kaxanu wën ak, wën ɓëte kaỹënanindëleŋun mondako fo ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ỹoweỹ këren penand na: ax gi ex na kaŋe, ax gi ex na koɗi, ax gi ex na ƴawale, ax gi ex na weŝeni gër enar end gë ɓëmboto. ");
INSERT INTO bsc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ɓëte ỹoweỹ këren penand na: ax gi ex na ambaɓ, ax gi ex na ɓacuɗ ɓaki, ax gi ex na ɓapeɗ ɓand enëmba, ax gi ex na oŝët. Ax gi ex na nde arandiyen an alëɓa këno lëɓand gër ed ko riyenind?» ");
INSERT INTO bsc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ata re ko ɓëte Yesu: «Gër ed kën h̃at yo hik angol atëm, hik ingol itil, mëkayindën ba ala exëna ar ỹapëk eŋun kwëtaya. Angëmëne ala exëna ar xwëtaya këŋun ɓayiyin gër iciw̃ indexëm xali yatir kën xuca. ");
INSERT INTO bsc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gër iciw̃ ind ɓër kën h̃at, cëmayindënëɓi. ");
INSERT INTO bsc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Angëmëne ɓër gër iciw̃ iŋo ɓën gë emëkw ed ŝenene xwëtaya kënun, aŝot këni ŝot oɓetak orewën ol. Ɓari angëmëne aŋun kwëtaya ex na gë emëkw ed ŝenene, oɓetak ol wën këŋun ɓayi. ");
INSERT INTO bsc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Angëmëne en ŋat në iciw̃ ba në angol do ɓela ɓën eni ŋëp enun kwëtaya in, canin gër iciw̃ iŋo ba gër angol aŋo, pëxwëcayindën obar od lëkak gër osapar orewën ok. ");
INSERT INTO bsc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ɗal in këmun felënd, yatir kiti ind Kaxanu ɓela ɓëjo aƴëka këɓi ƴëka nëmëc Ɓësodom do gë Ɓëgomor ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Awa ga këmun law̃ënënd ako en pemërand end owun or gër orën eŋ, anëka hi kën ang oyel or ŝit në ojëlemu fo. Awa perënayindën ang ɓandën fo, do ɓëngwin ang olëxwëte oxwël kwël fo. ");
INSERT INTO bsc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Titinalindënëɓi Ɓëŝëwif ɓën gayik alëxw kënun ỹana enun ɗëxwënd gër kiti. Ɓëte mbaŋ kënun ỹana enun këmërand gër ɓaciw̃ ɓacaleya ɓandeɓën. ");
INSERT INTO bsc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aw̃ëlara kënun ỹana enun mëlarand gër kiti. Aw̃ëlara kënun ỹana enun mëlarand në end ow̃ac oram gër ɓëlëngw do gër ɓemun en deƴaraxën endam eŋ: gër Ɓëŝëwif, do gër ɓër ani gi ex na Ɓëŝëwif. ");
INSERT INTO bsc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ɓarikan and kënun lëxw gër ɓëxiti aŋ, këreŋun bëlanënd na ang kën yeƴan ak ba ang kën yaka ak. Ata amëd aŋo dëŋ kën ỹana en nangënd ang kën yaka ak. ");
INSERT INTO bsc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Angoc Amënëk and Sorix irewën and ex gër ow̃ëkw aŋ kë ỹana eŋun pelënd ang kën yeƴan ak. ");
INSERT INTO bsc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ɓër hik ekun eɓat ɓën alëxwër këni ỹana eni ɗëxwër gër ecës në end ow̃ac oram: oɓaŝ ol eni ɗëxwër, ɓëxarëk ɓën enëɓi ɗëxwënd oɓaŝ oreɓën ol do oɓaŝ ol enëɓi ɗëxwënd ɓëxarëk ɓëreɓën ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ata në end ow̃ac oram ɓela ɓën ɗek kënun ŝusëra. Ɓarikan, ar kë xemëna an, ar kë lëkaya endam xali gër ecës an, afex ko fex. ");
INSERT INTO bsc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","And kënun narën në angol aŋ, gërin në acëxen. Ɗal in këmun felënd, an paỹ na ɓangol ɓand gër ebar ed Isërayel ɓaŋ me ɓakaw wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Asëfan an aŋo kucand na onëngëran asëƴali arexëm an. Ɓëte xaɗëp in aŋo kucand na or gapak axwën arexëm an. ");
INSERT INTO bsc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gilexo tuŋ asëfan an ang asëƴali arexëm ak, do xaɗëp in ang axwën arexëm ak. Angëmëne wëno axwën an, aŝus ŝus këne xali w̃ac këne Ỹëngëtir, kaŝ kënun ŝus wën ɓëram ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ɓari wën kërenëɓi yëdand na ɓela ɓën gayik er ŝonayak ax bo na, ɗek kë futar. ");
INSERT INTO bsc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ɓëte er këni ŝësinalind ɓela ax bo na nangërarëxe. Mëŋ ex, er këmun felënd gëmëɗ in, deƴarayindën goyat. Do er këmun nëkënëkand in, kwëŝayindën ƴaŋ gër oyur or ɓaciw̃ en pemaxën. ");
INSERT INTO bsc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kërenëɓi camënd na ɓër kë law̃ënd eman fo ɓën xarak ỹow̃eỹ ani koranënd na enjëw̃ eŋ. Camindëno ar kë lapënd enjëw̃ eŋ do gë eman gër xoɗux an. ");
INSERT INTO bsc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ax gi ex na nde gë atama and koɗi amat kënëɓi yëcënd ɓënder ɓëki? Ɓarikan, inder gimatak ax wëcënd na gër ebar xarak ax gi ex na Sorix irewën w̃ak. ");
INSERT INTO bsc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yama mëŋ emat emat ko fënënd omban ond ex gër ogaf odewën oŋ. ");
INSERT INTO bsc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Këren yëdarand na, endewën këŋo xwëɓënanënd nëmëc gë end ɓënder ɓëndanjëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mëŋ ex, ar kë reƴarand yo gër ɓela mëne aram hi ko, wëno ɓëte mondako fo këmo ỹana mo pelënd endexëm eŋ Faba, ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ɓarikan ar ke ƴaxëta yo gër ɓela wëno ɓëte mondako fo këmo ƴaxëta gër Faba ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Këren yëland na mëne angwëlëra w̃ëlaw këme gër ebar ro. Ɓarikan në end ow̃ac oram këɓi ỹana eɓi kucarërand ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sëm in eɓi kucarënd gë asëñiw̃, nëm in gë aɓiw̃, nëm ir eñër in gë alindaw̃ ar asëñiw̃. ");
INSERT INTO bsc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ala ar ex yo, gë ɓër ekun edexëm ɓën dëŋ këɓi ỹana eɓi kucarënd në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Awa ar këŋo ɓal end nëm ba end sëm nëmëc gë endam an, aŋo ñap na exo gi asëfan aram. Ɓëte ar këŋo ɓal end aɓiw̃ ba end asëñiw̃ nëmëc gë endam an, aŋo ñap na exo gi asëfan aram. ");
INSERT INTO bsc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ar këŋo xeƴ exo toro ba exo cës në end ow̃ac oram an, aŋo ñap na exo gi asëfan aram. ");
INSERT INTO bsc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ar këŋo ỹandi exo kwël aniyan andexëm an, anemin ko nemin. Ɓarikan, ar kë nemin aniyan andexëm në end ow̃ac oram an, afexën ko fexën. ");
INSERT INTO bsc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ar këŋun xwëtaya yo në end ow̃ac oram, wëno dëŋ xwëtaya ke. Ɓëte ar ke xwëtaya an, ar law̃ënëgu ke an xwëtaya këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ar këŋo xwëtaya yo alaw̃ënel në end ow̃ac oram, amaŝën and alaw̃ënel ko ŝot. Ɓëte ar këŋo xwëtaya yo ala gayik ar ŝenene exo, amaŝën and ar ŝenene ko ŝot. ");
INSERT INTO bsc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ar këŋo yël yo në end ow̃ac oram, men ond exo ceɓ, ado exo gido ar ɓak gër ɓësëfan, ɗal in këmun felënd, aŝot ko ŝot amaŝën andexëm aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","And h̃ata ko Yesu ɓapela ɓand baɓi yëlënd ɓësëfan epëxw gë ɓëxi aŋ, xani ko do kwël ƴe ko. Eɓi tëƴalirax do exo pemërax end Kaxanu eŋ gë angol, gë angol ebar ed Galile el ỹandi baŋo. ");
INSERT INTO bsc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Xarak amëd aŋo Ŝaŋ Batis gër epëra hi baxo. Ga wël ko ɓecarax ɓend baxo rind Kërisët ɓeŋ, law̃ën këɓi ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","And h̃at këni aŋ, w̃ëka këno Yesu: «Wëj nde ex Afexën ar këmo ŝënind an? Angëmëne ax gi ex na wëj, ba mo cëni nde aŝëxen?» ");
INSERT INTO bsc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu yaka këɓi: «Ƴeyin eno tëfëtanëx Ŝaŋ Batis er kën wëlënd do kën watënd in: ");
INSERT INTO bsc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","në eciw̃ëta exëni ɓëŝiw̃ëk ɓën, në epak exëni ɓëseỹik ɓën, në emën exëni ɓër gë ameỹ ɓën. Ɓëte në ewëlëra exëni ɓër abax wëlëra na ɓën. Ɓëte në ekani exëni gër ecës ɓëŝësëk ɓën do Atëfëtan aŋ në enangën exëni ɓëxaỹënaxik ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Awa, nëngandëraleŋo ar aŋo ŋëpëgënand na endam an.» ");
INSERT INTO bsc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ata ga ɓaka këni ɓërolaw̃ën ɓën, Yesu këɓi w̃ëkand ɓela ɓën end Ŝaŋ Batis eŋ: «Inew̃a watëgu kën gër ladawe? Andës and kë lëfërirand ekoc nde? ");
INSERT INTO bsc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mondake hi ko ar ƴe ban eno watëgu an? Ar ŝuɗak ɓanjëm ɓanjekax nde ex? Ax gi ex na nde ɓër gë ɓanjëm ɓanjekax ɓën gër eyang ed emun hi këni? ");
INSERT INTO bsc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Do inew̃a ƴe ban gër ladawe? Eno watëgu alaw̃ënel ar Kaxanu nde? Ga re këme, ar watëgu këno an nëmëc alaw̃ënel exo. ");
INSERT INTO bsc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","End Ŝaŋ ijo eŋ ỹëgw këni mëne Kaxanu rek: “Awa në eɗëngwalilemo arolaw̃ën an exi ŋacan fëña in.” ");
INSERT INTO bsc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Ɗal in këmun felënd, ala ax gi ex na ar rëw̃ këno mondëw̃ do xuca këŋo Ŝaŋ Batis or gapak ol. Ɓarikan, ar xurik ex ɓa gër owun or gër orën an xuca këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Elod ga ƴow ko Ŝaŋ Batis xali doro, ɓela ɓën në enëyëtëra exëni eni ɗil gër owun or gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gayikwa ɗek okayëta od ɓëlaw̃ënel ok do gë acariya aŋ areƴa reƴak end owun or gër orën eŋ xali gër Ŝaŋ Batis. ");
INSERT INTO bsc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Do angëmëne aw̃a w̃a kën er këmun felënd in, Ŝaŋ ijo ex wa alaw̃ënel Eli ir ebax exo ɓakaw in. ");
INSERT INTO bsc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ax gi ex na nde ɗek fo wël kën? Awa! ");
INSERT INTO bsc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Gë noɓën këmëni w̃atinali ɓela ɓër gë okey oko ɓën? Ata ang oɓaŝ or kë w̃ëkëñarand në yangana ir angol fo hi këni. Mondako kënëɓi rend ɓëcandaw̃ ɓëŋ: ");
INSERT INTO bsc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Farixën këmun acëroti aŋ, an man ex na. Ɓëte ỹëw̃ën këmun ojëkan od oỹaw̃, an tes ex na.” ");
INSERT INTO bsc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ga ƴow ko Ŝaŋ Batis, abaxo ƴamb na ecemar, abaxo ŝeɓ na ngoƴ, wën re kën mëne gë ɓëyël exo. ");
INSERT INTO bsc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ga ƴow këme wëno Asëñiw̃ ar ala an, këme ƴambërand do këme ŝeɓërand, do këne rend: “Ajo ñambëran gë oŝeɓ fo xwënda ko. Ɓëte lawo ir ɓësëf ɓër ŝagale do gë ɓëw̃endëran fo hi ko!” Ɓarikan, orenik or Kaxanu ol gë er ko rind ala arexëm in kë ŝanayand er ŝenene.» ");
INSERT INTO bsc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ga xucak eŋo, Yesu këɓi rexërand ɓela ɓër gër ɓangol ɓand gër ed ri baxo ɓecarax ɓendanjëm ɓën gayik ano kwëta bana, ɓëte ani nëngwët bana ola oreɓën ol. ");
INSERT INTO bsc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Er baxo rend: «Wën ɓër gër ɓangol ɓand Koraseŋ do gë Betësayida ɓën, mbaŋ w̃e këŋun! Kido ɓecarax ɓend wateli këne wën ɓeŋ ɓër gër angol and Tir do gand Sidoŋ ɓën wat bax, aw̃a w̃a doni endam eŋ, ɓëte anëngwët nëngwët doni ola oreɓën ol. Ado gë ojaɓote doni laɓayand, eni kaỹëninand do eni panayand eƴëwën el. ");
INSERT INTO bsc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ga re këme, yatir kiti, ɓër lëgëk gër Tir do gë Sidoŋ ɓën këɓi sax gë wën. ");
INSERT INTO bsc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Do wën ɓër gër angol and Kafarënawum ɓën cëŋ, yëla kën Kaxanu xali ƴaŋ gër orën nde këŋun fela? Ɓëtëdëŋ, gëɗ gër wur ir ɓëŝësëk këŋun lat. Kido ɓecarax ɓend wateli këne wën ɓeŋ ɓër gër angol and Sodom ɓën wat bax, xali doro ɓayi doni. ");
INSERT INTO bsc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ga re këme, yatir kiti, ɓër lëgëk gër ebar ed Sodom ɓën këɓi sax gë wën.» ");
INSERT INTO bsc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ga h̃ata ko eŋo, Yesu re ko: «Faba, wëj Axwën ar orën gë ebar an, aye ri këƴ. Aye ri këƴ ga sana këƴëɓi oɓaŝ eni nang ɓend ŝon këƴëɓi ɓëxarëk do ɓër gë orenik ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eyo Faba aye ri këƴ gayik mondako ỹandi ki ex gi. ");
INSERT INTO bsc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Ɓeỹ ɓën ɗek seɓënan ke Faba, ɓari ala axe nang ex na wëno Asëñiw̃, Faba fo nang ke. Ɓëte ala aŋo nang ex na Faba ang ax gi ex na wëno Asëñiw̃ do gë ar ỹandi ke mo nangën an.» ");
INSERT INTO bsc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ata Yesu fel këɓi ɓela ɓër hi bax na ɓën: «Tëkawëne wën ɗek ɓër sëkwërak do ŝëmura këŋun ɓën, ata këmun rëca en teyëta. ");
INSERT INTO bsc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mayin oxaɗac oram ol, mayin mun tëƴali, gayikwa mbaŋ liki këme, ɓëte mbaŋ nëngak emëkw edam el, ata fo kën seyëtali ɓenjëw̃ ɓendewën ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Oxaɗac oram ol onëngax ex, ɓëte er këmun lëɓin in ax tiɓ ex na.» ");
INSERT INTO bsc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yesu gë ɓësëfan ɓërexëm ɓën bax xucand në ocënga od bële, yatir akey and eteyëta. Ata Ɓësëfan ɓën ga xor këɓi enjo eŋ, këni w̃iŝand ɓanjëra ɓaŋ do këni ƴakënd. ");
INSERT INTO bsc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ofariseŋ ok ga wat kënëɓi na, re këni: «Er këni rind ɓësëfan ɓëreƴ in, ax ñap ex na ɗe yatir akey and eteyëta ang rek acariya ak.» ");
INSERT INTO bsc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ɓarikan Yesu yaka këɓi: «Wën an pën ex na nde er ri baxo Dafid in and ɓot baɓi enjo aŋ mëŋ gë ɓër enga endexëm ɓën? ");
INSERT INTO bsc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ax gi ex na nde alilën lilën baxo gër Aciw̃ and Kaxanu mburu icëɓax iŋ? Do ax gi ex na nde aƴamb ƴamb bani xarak aɓi ñap ex na mëŋ gë ɓër enga endexëm ɓën gayik ani gi bana ɓëŝaɗaxan? ");
INSERT INTO bsc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ɓëte an pën ex na nde gër acariya and Moyis mëne gë ɓakey ɓand eteyëta ɓaŋ ɓëŝaɗaxan ɓën aƴepën këni ƴepënënd oŝëɓa or akey and eteyëta ol, lëf gër Aciw̃ and Kaxanu, xarak ani menënd na? ");
INSERT INTO bsc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ga re këme, wëno nëmëca këɓi or gapak ol ɓëŝaɗaxan ɓën, ɓëte wëno nëmëcak oxwëɓën ol Aciw̃ and Kaxanu aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Er w̃ëka këŋun Kaxanu: en gi gë axaỹënan do eŋun ɓalërënd andewën rewën aŋ, ax gi ex na en dind ocaɗaxa fo. Kido afëni fëni baŋun eyeƴan elo, adonëɓi nëp na ɓësëfan ɓëram ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Enimin wëno Asëñiw̃ ar ala an ex axwën ar akey and eteyëta an.» ");
INSERT INTO bsc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ga xani ko na, ƴe ko gër aciw̃ acaleya and Ɓëŝëwif. ");
INSERT INTO bsc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yatijo ar gë ataxan ateỹik ƴow baxëna gër cale. Ata ɓëŝalen ɓën do gë Ofariseŋ ok ga këni ŝala end këno nagaŝanaxën Yesu eŋ, w̃ëka këno mama dëŋ: «Aỹap nde ỹapëk paɓ gë acariya aŋ epakën ed aŝëxwëra gë akey and eteyëta el?» ");
INSERT INTO bsc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu yaka këɓi: «Wën ɓëte mun mëka ɗamana mun yakaxën. Ar ŝot këŋo ifeỹ iɓat fo an, aseɓ nde këŋo seɓ and lati ko polo në ambëxw gë akey and eteyëta aŋ? Aŋo cëpët na nde mondako dëŋ? ");
INSERT INTO bsc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Xarak ala an wa xëɓënëk nëmëc ejel ed ex yo, mëŋ ex aỹap ỹapëk edi ed enjekax el gë akey and eteyëta aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","And h̃ata ko aŋ, Yesu fel këŋo aseỹik an: «Yënël ataxan aŋ!» Ga yën ko, ataŋ ɓëngwëk ataxan aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ataŋ ŝan këni ofariseŋ ok eni wëlërëx ang këni ri eno ɗaw̃axën Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ga wata ko Yesu, facana ko na, ata sëfa këno ɓëranjëm. Fakëndëra këɓi ɗek ɓër ŝëxwëra bax ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ɓarikan axëŋa baɓi xëŋand eni cësinali endexëm eŋ ");
INSERT INTO bsc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ex ŋataxën er ỹëgw ko alaw̃ënel Esayi endexëm in mëne Kaxanu rek: ");
INSERT INTO bsc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nëkoɗo ariyenin aram an, mëŋ ex ar sana këmo gë onënga an, mëŋ ex ar pëlot gër yomb iram an. Ɓëte mëŋ këmo yël Angoc andam aŋ, eɓi nangënaxën or ŝenene ol ɗek ɓenëng ɓend ɓela ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ani campëre na gë ala, oniw̃ orexëm ax wëli na xali fac gër opëña od gër angol, ala aŋo keỹënaxën na. ");
INSERT INTO bsc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Axo bac na eñamb engëbik eŋ, Enjeb end riw̃ak eŋ axo ɗomin na, xali eɓi kor ɓela ɓën gë or ŝenene ol. ");
INSERT INTO bsc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Do ɓenëng ɓecëxe ɓeŋ endexëm këni ỹana eni yarënd.» ");
INSERT INTO bsc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ga xucak eŋo, w̃ëlagu këno gër Yesu ala ar ŝiw̃ bax, ar gë oniw̃ këm. Ga hi bax ar gë ɓëyël ŝëxwëraxën baxo mondako. Yesu ga fakën këŋo, ala ajo ko yeƴandërand aye ɓëte ko watërand këri-këri. ");
INSERT INTO bsc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ata ɗek amëxwër aŋ ŝaran këɓi xali do këni w̃ëkarënd end Yesu eŋ ba mëŋ ex Asëñiw̃ ar Dafid an. ");
INSERT INTO bsc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ɓarikan ofariseŋ ok ga wël këni eŋo këni rend: «Yama gë panga ind Ỹëngëtir iŋ, emun end ɓëyël eŋ, ga këɓi nëcëtënd nde ɓëyël ɓën gër ɓela.» ");
INSERT INTO bsc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu ga nang ko ang bani yëland ak, re ko: «Angëmëne ɓela ɓër owun oɓat eni merënd, owun olo ala ti kë lati. Ɓëte, angëmëne ɓela ɓër ekun eɓat eni merënd, ekun elo aŝapër kë ŝapër. Do ɓëte ɓër angol amat eni merënd, angol aŋo aŝapër kë ŝapër. ");
INSERT INTO bsc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Angëmëne Sindan eŋo ŋw̃ayënd Sindan, në emer exo gaɓat, ax ɓayi na owun orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Do angëmëne wëno gë panga ind Ỹëngëtir iŋ këmëni nëcëtënd ɓëyël ɓën gër ɓela, oɓaŝ orewën ol cëŋ, gë panga ind noỹo kënëɓi nëcëtënd? Mëŋ ex, ɓën dëŋ kë hi ɓëxiti ɓërewën ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɓarikan angëmëne gë panga ind Angoc and Kaxanu iŋ këmëni nëcëtënd ɓëyël ɓën, awa owun or Kaxanu ol anëka h̃atënëgu këŋun. ");
INSERT INTO bsc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ax gi ex na nde ala ax kor na exo ɗil në iciw̃ ind ar gë ojaw̃ eŋo kandëra ɗek xarak aŋo ɓon ex na? Ax gi ex na nde afo eŋo ɓon pere do eŋo kap aye exo meɗëraxën? ");
INSERT INTO bsc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ar ax ma ex na endam an, arangoỹëra andam hi ko. Ɓëte, ar axe dëcand na eɓar an, në eyëc exo. ");
INSERT INTO bsc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mëŋ këmun felaxënënd amena and ex yo ado ex gido ocir od Kaxanu, gë eteɓan ex. Ɓari emëŝen ed Angoc Amënëk el, ax gi ex na gë eteɓan. ");
INSERT INTO bsc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ar ke yeƴanan eñëŋënax wëno Asëñiw̃ ar ala an, Kaxanu aseɓan këŋo seɓan. Ɓari ar këŋo yeƴanan eñëŋënax Angoc Amënëk an, Kaxanu aŋo teɓan na gër ngwën ind doro ɓëte aŋo teɓan na gër ind ecan. ");
INSERT INTO bsc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ax gi ex na nde atëx anjekax aŋ kë rëw̃ënd odëw̃ërëw̃en ojekax ok do añëŋënax aŋ odëw̃ërëw̃en oñëŋënax ok? Ax gi ex na nde paɓ gë odëw̃ërëw̃en ok kë hind monang atëx aŋ? ");
INSERT INTO bsc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wën ɓandën ɓaŋo, mondake kën xor en yeƴan ɓenjekax, wën ɓëỹëŋënax ɓëjo? Gayikwa er lëɓëk gër ow̃ëkw orewën in kë ŝanënd gër osëỹ orewën. ");
INSERT INTO bsc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ala ar gë emëkw ejekax an, ɓenjekax kë ŝanënd gër etëỹ edexëm. Ɓarikan ar gë emëkw eñëŋënax an, ɓeñëŋënax kë ŝanënd gër etëỹ edexëm. ");
INSERT INTO bsc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ga re këme, yatir kiti, ɓela ɓën aƴëka këɓi ƴëka në end ɓonjeƴan ɓond gë ofëcak këm ɓond bani yeƴandërand eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gayikwa gë eyeƴan edeƴ el këƴ hi ar ŝenene, do eyeƴan edeƴ el ki nëp.» ");
INSERT INTO bsc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ata ɓëŝalen do gë ofariseŋ w̃ëka këno ɓëte Yesu: «Asëƴali, ɓiyi ecarax ỹandi këɓo eƴ di mi wat.» ");
INSERT INTO bsc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu yaka këɓi: «Wën anjex añëŋënax do and kë rind orekar aŋo nde ke w̃ëkand mun masin ecarax? Ecarax an wat na, ang ax gi ex na end alaw̃ënel Yonas eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ang ri baxo Yonas ɓakey ɓatas gër acël and angan and hël baŋo ak, mondako fo këme ri wëno Asëñiw̃ ar ala an ɓakey ɓatas lëf gër emëkw ed ebar. ");
INSERT INTO bsc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ɓëninif ɓën axani këni xaniɗ, yatir kiti do enëɓi nëp ɓela ɓër gë okey oko ɓën gayik anëngwët nëngwët bani ola oreɓën ol and ɓaxët këni epemëra ed Yonas aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Emun etoxari end hi bax gër ebar ed Saba eŋ, caw xaniw baxo eŋo ɓaxët Salomoŋ, emun end gë orenik osëm eŋ. Ɓarikan wëno xuca këŋo or gapak ol Salomoŋ. Awa yatir kiti, emun etoxari eŋo kë xani eŋun nëp.» ");
INSERT INTO bsc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Re ko ɓëte Yesu: «And ko ŝan angoc añëŋënax në ala ar lil baŋo aŋ, gër apuỹ ko ƴend, gër ed timëriŋ, exo calarax në er ko seyëta, ɓari axo cot na. ");
INSERT INTO bsc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ata exo de: “Ɓakaleme tan gër ed ŝanëgu këme, gër aciw̃ andam.” And ko h̃at aŋ exo tëk wafërëluŋ, ga fat këni aye do gë ỹaŋën aye. ");
INSERT INTO bsc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ata eɓi ƴen ɓangoc ɓañëŋënax ɓanjongëɓaki, ɓand xuca këŋo oxeỹ do eni ɗil ɓën ɗek gër ala ajo. Awa ala ajo amëd aŋo ko soro nëmëc gand lil baŋo angoc amat fo aŋ. Eŋo këŋun ɓët wën ɓësëmbak ɓër gë okey oko ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu, ga këɓi felëra mondako amëxwër aŋ, h̃atëgu këni nëm gë ɓoɓinëm. Ga ŝëni këno fac, ỹandi këɓi eni kanar gë mëŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ata re ko ala gër amëxwër: «Axwën, yakalëɓi fac norix gë ɓoɓinëx.» ");
INSERT INTO bsc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu yaka këŋo: «Noỹo ex nëma do noɓën ex ɓëmaỹe ɓëndam?» ");
INSERT INTO bsc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ga w̃asi këɓi ɓësëfan ɓërexëm ɓën, re ko: «Ɓëjo ex nëma do gë ɓëmaỹe ɓëndam ɓëŋ. ");
INSERT INTO bsc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Enimin, ar kë rind yo oñandi od Faba ok, mëŋ ar ƴaŋ gër orën an, ajo ex aɓaỹe, do nëma.» ");
INSERT INTO bsc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kwël yatijo fo, Yesu ŝan ko gër iciw̃ do ƴe ko ỹëpax ko gër ɓëŋa ir anjer and Galile. ");
INSERT INTO bsc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ga ɓarërëgu këni ɓela ɓën amëxwër atëm, xeta këno. Ata mëŋ rëfa ko në ikuluŋ ind hi bax polo gër anjer do ỹëpax ko, xwëŝara këni ɗek gër ɓëŋa. ");
INSERT INTO bsc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu ỹana ko këɓi sëƴalind gë ɓapënëtal ɓandanjëm ko rend: ");
INSERT INTO bsc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","«Mondako ri baxo ar oneɗ ga nëca ko gër oŝënga. Ga fan ko eneɗa aŋ, mar lapak tar fëña in, ata oŝël ol lapara këni, w̃eɗara këni ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mar lapak gër ebar ed gë aparëfac. Ata gogo nde ga lëgëk gayik obar ok ax ñëmb bana. ");
INSERT INTO bsc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ga fëtëk eñan eŋ, ŝorëk do h̃aỹëk ɗek gayik oɗëmbët ok ax tiw̃ bana. ");
INSERT INTO bsc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mar lapak ɓëte ŝit në acëc and gë odëmbën ata lëgëk. Ga kë raf eneɗa aŋ, odëmbën ok xëŝak tëc. ");
INSERT INTO bsc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mar lapak ɓëte gër ebar ejekax. Ga lëgëk, rafëk aye do rëw̃ëk mbaŋ: anjëra amat keme, aŋo ofëxw ocongeɓat do aŋo ofëxw osas. ");
INSERT INTO bsc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ax gi ex na nde ɗek fo wël kën apënëtal aŋo? Awa ɓaxëtin angëmëne gë ɓanëf en!» ");
INSERT INTO bsc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ata ɓësëfan ɓën xeta këno Yesu ga h̃ata ko apënëtal aŋo. W̃ëka këno: «Inecëŋ këƴëɓi sëƴalixënënd ɓela ɓën gë ɓapënëtal?» ");
INSERT INTO bsc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu yaka këɓi: «Ɓend owun or gër orën ɓeŋ, wën ɓësëfan ɓëram ɓën fo ỹapëk en nang, eŋo aɓi yël ex na ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kaxanu aɓaŝ këŋo ɓaŝ ar ŝotërak an exo cotëra nëmëc. Ɓari ar ax cot ex na an, axan këno xan er xaỹ këŋo in dëŋ. ");
INSERT INTO bsc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mëŋ këmëni sëƴalixënënd gë ɓapënëtal gayik ɓën ado eni nëkonënd ani watënd na, ado eni ɓaxëtënd gë tëkërak aɓi pënind na. ");
INSERT INTO bsc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mondako kë h̃atand er ỹëgw ko alaw̃ënel Esayi in: “Ado en wëlënd awël dëŋ, din aŋun pëni na, ado en nëkonënd anëkon dëŋ, din an wat na. ");
INSERT INTO bsc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gayikwa ow̃ëkw or ɓulunda ijo oŋ, mbaŋ farëɗaɗik, ɓanëf ɓaŋ ŝoya këni, do afëɗ fëɗ këni ɓangës ɓaŋ, këdi këni wat gë ɓangës ɓandeɓën ɓaŋ, këdi këni wël gë ɓanëf ɓandeɓën ɓaŋ këdi këɓi fëni gë ow̃ëkw oreɓën oŋ do eni nëngwët ola oreɓën ol do wëno mëni teɓan.” ");
INSERT INTO bsc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ɓarikan, wën nëngandëraleŋun gayik në ewat en gë ɓangës ɓandewën ɓaŋ do në ewël en gë ɓanëf ɓandewën ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ɗal in këmun felënd, ɓëlaw̃ënel ɓëranjëm do gë ɓër ŝenene ɓëranjëm ỹandi baɓi eni wat er kën watënd in, ɓari ani wat ex na. Aỹandi ỹandi baɓi ɓëte eni wël er kën wëlënd in, ɓari ani wël ex na. ");
INSERT INTO bsc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Awa ɓaxëtin mun paỹën apënëtal and ar oneɗ aŋ: ");
INSERT INTO bsc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɓër kë wëlënd eyeƴan ed owun or Kaxanu do aɓi pënind na ɓën er hi këni ang eneɗa end lapak tar fëña eŋ. Ŝaɓucara in kë ƴowënd exo dëxët er neɗ këni gër ow̃ëkw oreɓën in. ");
INSERT INTO bsc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɓëjo ɓëte er hi këni ang ebar ed gë aparëfac ed gër ed lapak eneɗa fo. Ɓën and këni wël eyeƴan aŋ, eni kwëta gë onënga fo. ");
INSERT INTO bsc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ɓari ani teɓënd na ex gi gë oɗëmbët gër ow̃ëkw oreɓën, ani ɗëkayand na eyeƴan elo. And këni sorond ba eni cënd në end eyeƴan elo aŋ, gogo nde eɓi cena do eni ɗap caw ekwëta ed Kaxanu el. ");
INSERT INTO bsc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɓëjo ɓëte er hi këni ang eneɗa end lapak ŝit në acëc and gë odëmbën. Awël wël këni eyeƴan el ɓarikan ocëmu od ro gër aniyan ok, gë aŋana and napul aŋ kë xëŝand eyeƴan el xali ex tëkwan ecënar el. ");
INSERT INTO bsc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɓëjo ɓëte er hi këni ang eneɗa end lapak gër ebar ejekax. Ga wël këni eyeƴan ed Kaxanu el, fëni këɓi, ata ŝënarëk gër ow̃ëkw oreɓën: keme, ofëxw ocongeɓat, ofëxw osas.» ");
INSERT INTO bsc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ga h̃ata ko eŋo, fel këɓi ɓëte apënëtal acëxe: «Ako ex end owun or gër orën eŋ. Ar oneɗ nëca baxëna gër eɗen gë eneɗa emënëk. ");
INSERT INTO bsc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ga fandëra ko ciŝ malu ɓëtëgu ko gëmëɗ arangoỹëra, fan ko wec w̃alu-w̃alu, do kwël ƴe ko. ");
INSERT INTO bsc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","And lëgëk malu aŋ lëgëk ɓëte w̃alu-w̃alu in, rafëk andamat xali ŝanëk do rëw̃ëk. ");
INSERT INTO bsc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ata okaɗëp ok w̃ëka këno axwën eɗen: “Faba, ax gi ex na nde eneɗa emënëk dëŋ fan këƴ gër eɗen? Do feye wa ŝanëguk w̃alu-w̃alu ijo?” ");
INSERT INTO bsc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yaka këɓi: “Arangoỹëra fanëk.” W̃ëka këno ɓëte okaɗëp ok: “Ỹandi ki nde mi bic w̃alu-w̃alu in?” ");
INSERT INTO bsc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yaka këɓi: “Ali, këren bic na këdi kën wiceli bële in. ");
INSERT INTO bsc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Teɓëxën ako xali gë ekol, xali ex ŋat eŋaŝ el. Ɓër eŋaŝ ɓën afel këmëni felëɗ eni ñana w̃alu-w̃alu in do eni kap olaŋ olaŋ me coraxën. Ɓarikan malu in, afel këmëni felëɗ ene mëlan gër acac andam.”» ");
INSERT INTO bsc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu fel këɓi ɓëte apënëtal acëxe: «Mondako ex end owun or gër orën eŋ. Ang enjëlir end mutarëd end neɗ ko ala gër andëɗa andexëm fo ex. ");
INSERT INTO bsc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eneɗa eŋo xurik ex ɓa ɗek ɓeneɗa ɓeŋ. Ɓarikan and kë lëg aŋ, ata kë nëmëcand ɗek ɓeɓëlëg ɓër gër andëɗa ɓën xali oŝël or gër orën ol eni yëlëra gër ɓenini ɓendexëm.» ");
INSERT INTO bsc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu fel këɓi ɓëte apënëtal acëxe: «Ako ex end owun or gër orën eŋ. Ang lewir ir negali ko asoxari gë pix në ɓëndeɓ ɓëtas fo hik, ata fufëk ɗek pix iŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ɓeŋo ɗek sëƴalira baɓi Yesu gë ɓapënëtal. ");
INSERT INTO bsc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ỹoweỹ abaɓi sëƴali na ɓela ɓën gë apënëtal këm, ex ŋataxën er ỹëgw baxo alaw̃ënel in: «Gë ɓapënëtal këmëni ỹana mëni tëƴalind. Afut këme ỹana me putënd ɓend ŝonayak elod ga ỹanak ngwën ɓeŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu ga h̃ata ko end baɓi sëƴalind eŋ, seɓ këɓi amëxwër aŋ ɓaka ko gër iciw̃. Ata ga xeta këno ɓësëfan ɓën re këni: «Paỹënëlëɓo ɓiyi apënëtal and w̃alu-w̃alu aŋ, aɓo pëni ex na.» ");
INSERT INTO bsc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu yaka këɓi: «Ar kë fanënd eneɗa emënëk an, wëno Asëñiw̃ ar ala an ex. ");
INSERT INTO bsc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Eɗen el, ngwën iŋ ex. Eneɗa emënëk eŋ ex oɓaŝ or Owun or Kaxanu ol. W̃alu-w̃alu in ex ɓër këŋo ɓaxëtënd ŝaɓucara ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Arangoỹëra ar fanëk w̃alu-w̃alu an, exo ŝaɓucara in. Eŋaŝ el ex ekwët ed ngwën el, do ɓëh̃aŝ ɓën exëni omeleka ok. ");
INSERT INTO bsc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Awa, ang kë hi moŋaŝ pere w̃alu-w̃alu ak eni coraxën, yatir ekwët ed ngwën, ");
INSERT INTO bsc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","wëno Asëñiw̃ ar ala an këɓi law̃ënëgu omeleka odam ok eni dëxët gër owun oram ɓeɓër kë lënanënd eñëŋënax ɓën, do enëɓi ɓar ɗek ɓëw̃endëran ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","And kënëɓi ɓarëra ɗek aŋ, enëɓi ɗap bëngënj gër angoɗux do ɓën fën këni ỹana eni denitarand do eni ŋatënd eɓasa el. ");
INSERT INTO bsc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Xarak amëd aŋo, ɓërëw̃ak end Kaxanu ɓën, ang eñan fo këni ỹana eni watind jing-jing gër owun or Sëm ireɓën Kaxanu. Ax gi ex na nde ɗek fo wël kën? Awa!» ");
INSERT INTO bsc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu ŝom ko ɓëte: «Owun or gër orën ol er wëndërëk gë endeƴ end napul ir wëg këni në oŝënga fo. Ar ŝananëk an wëg ko gaŝëxe. Ƴe ko gë onënga fo fan ko ɗek acota andexëm aŋ do yëc ko oŝënga olo. ");
INSERT INTO bsc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ɓëte owun or gër orën ol er ex ang ƴula ir kë ŝaland oƴeri od xemëk akanji fo. ");
INSERT INTO bsc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ga sëk ko, ƴe ko fan ko ɗek acota andexëm aŋ do yëc ko oƴeri oko.» ");
INSERT INTO bsc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Owun or gër orën ol er hik ang ebën ed lap këni në anjer fo, ebën ed sëra këɓi oxan or ex yo. ");
INSERT INTO bsc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ata ga fëxw këni, ŝëpët kënëɓi gër ɓëŋa. Ga sana kënëɓi oyekax ol, xwët kënëɓi në ɓakange do lap kënëɓi oỹëŋënax ol. ");
INSERT INTO bsc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mondako kë hi yatir ekwët ed ngwën. Omeleka ok kë ƴow enëɓi cëfëƴët ɓëw̃endëran ɓën gër ɓamara ɓand ɓërëw̃ak end Kaxanu, ");
INSERT INTO bsc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ata enëɓi ɗapëx bëngënj gër angoɗux do ɓën fën këni ỹana eni denitarand do eni ŋatënd eɓasa el.» ");
INSERT INTO bsc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ga h̃ata ko Yesu, w̃ëka këɓi ɓësëfan ɓën: «Dodo ɗek nde fëni këŋun?» Yaka këno: «Iyo.» ");
INSERT INTO bsc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ata re ko: «Mëŋ ex, aŝalen ar fëni këŋo aye end owun or gër orën an, ang ar ŝotërak ɓon napul fo hi ko. Er këɓi sëƴalind ɓela in ko w̃eɗëgund gër emëkw edexëm: ɓengaŝax do gë ɓekarëk.» ");
INSERT INTO bsc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","And h̃ata ko ɓapënëtal ɓaŋo aŋ, Yesu xani ko na do ƴe ko. ");
INSERT INTO bsc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","W̃aỹi ko gër ndeɓën gër Nasaret, ata yatir akey and eteyëta këɓi sëƴaliraxënd ɓela ɓën gër aciw̃ acaleya. Ɗek baɓi ŝaranënd osëƴali orexëm ol, ata këni w̃ëkarënd: «Feye wa sëƴaw ko nangëraxën ko go? Mondake ko xamënënd exo di ɓecarax ɓeŋo? ");
INSERT INTO bsc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ax gi ex na nde mëŋ dëŋ ex asëñiw̃ ar Yosef, afës ar otëx an? Ax gi ex na Mari ex nde wa nëm irexëm? Ɓoɓinëm ɓëtoŝan ɓëŋ ga ex wa Ŝak, gë Yosef, gë Simoŋ do gë Yud. ");
INSERT INTO bsc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ɓëmaỹe ɓëtoxari ɓëŋ ɗek ro ga hi këni wa. Do fe wa sëƴaw ko ɗek ɓeŋo?» ");
INSERT INTO bsc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɓënasaret ɓën, ga w̃ër bano baɓi h̃ëpëgënanaxënënd endexëm eŋ. Ata re ko Yesu: «Alaw̃ënel an gër ebar edexëm fo këno yafënd, ɗek ɗek in gër ɓër ekun eɓat gë mëŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ata axo di bana ɓecarax ɓendanjëm në end oŋëpëgënan odeɓën eŋ. Ɓëngol ɓënd ler ler gër Nasaret ɓëŋ baxo sëfërand eɓi tëƴalirax. ");
INSERT INTO bsc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Amëd aŋo, Erod emun end gër ebar ed Galile eŋ awël baɓi wëlënd ɓela ɓën ga këni yeƴandërand end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ata fel këɓi ɓër gër eyang edexëm ɓën: «Yama Ŝaŋ Batis ga xaniwëk nde gër ecës, mëŋ ŝotaxën ko ojaw̃ od ko xoraxënënd exo di ɓecarax ok.» ");
INSERT INTO bsc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Enimin mëŋ dëŋ sëra baŋo Ŝaŋ Batis, fëra këŋo do fokëra këŋo gë ogweƴele-gweƴele, ga baŋo nëpënd në end Erojad, alindaw̃ ar aɓinëm Filip eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Enimin, Ŝaŋ Batis afel baŋo felënd: «Ax ñap ex na eƴo ñër asoxari ar aɓinëx Filip an.» ");
INSERT INTO bsc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ata mëŋ ỹandixën baŋo Erod eŋo ɗaw̃ Ŝaŋ. Ɓarikan, ayëda baɓi yëdand ɓela ɓën gayik alaw̃ënel ar Kaxanu xwët bano. ");
INSERT INTO bsc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xarak, ga h̃atëguk akey and rëw̃ këno aŋ, Erod ri ko ofëna. Ata aɓiw̃ ar Erojad ko wandërand mërëxand ir ɓëliyer, ata nëngan këŋo Erod. ");
INSERT INTO bsc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mokamën xamën baxo anjar aŋ xali Erod yaŝar ko mëne er këŋo xara yo ayël këŋo yël. ");
INSERT INTO bsc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ata endënaw̃ eŋ ga wëlërëgu këni gë nëm, re ko: «Awa yëluye gaf ir Ŝaŋ Batis in në inëp.» ");
INSERT INTO bsc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ata emun eŋ ŝënd ko, ŝena këŋo ba ine yaŝaraxën baxo xali wël këno ɓëliyer ɓën. Ɓarikan ako dëŋ re ko eno yël endënaw̃ eŋ er w̃ëka këŋo in. ");
INSERT INTO bsc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Na law̃ën këŋo ŝoroɗa foɗëtëgu ko gaf ir Ŝaŋ Batis in lëf gër epëra. ");
INSERT INTO bsc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ga w̃ëlaw ko gaf in në inëp, fëxwën këŋo endënaw̃ eŋ. Ata mëŋ w̃ara ko yëlëx këŋo nëm. ");
INSERT INTO bsc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ɓësëfan ɓër Ŝaŋ ɓën ƴen këni eman eŋ do w̃ëxëta këno. Ata ƴe këni eno pelëx Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ga wël ko endeƴ eŋo, Yesu xani ko na gër ed ebaxo do ko xegëtand gë ikuluŋ iŋ anjer and Galile aŋ exo nacëtaxën në er tëɓ. And nangëra këni amëxwër aŋ, xanira këni gër ɓëngol do sëf këno gë osapar. ");
INSERT INTO bsc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","And baxo ŝëpëtand gër ikuluŋ aŋ, wat këɓi amëxwër aŋ. Ata ga këŋo xaỹënan, fakëndëra këɓi ɓëŝëxwëra ɓëreɓën ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Apenëka aŋ, sëka këno ɓësëfan ɓën do re këni: «Asëƴali, ro në er tëɓ hi këne do në emëɗ ex. Pelalëɓi ɓela ɓën eni capër gër ɓëngol eni yëcërax er këni ƴamb.» ");
INSERT INTO bsc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu yaka këɓi: «Eyo, ɓari ax ñap na eni ƴe mondako fo. Yëlinëɓi wën dëŋ er këni ƴamb.» ");
INSERT INTO bsc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ata yaka këno: «Ɓamburu ɓanjo do gë oxan oxi fo lëkaya këmi.» ");
INSERT INTO bsc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aŋo re ko Yesu: «Mëlawën tan ro», ata w̃ëlanëgu këno. ");
INSERT INTO bsc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ga fel këɓi amëxwër aŋ eni ñëpara gër ondës, w̃eɗ ko ɓamburu ɓanjo ɓaŋ do gë oxan oxi ol, xeŋa ko orën ol do ŝëkwa këŋo Kaxanu. Ata hëbëndër ko, yël këɓi ɓësëfan ɓën eni cet. ");
INSERT INTO bsc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na ƴambëra këni, w̃ed këni ɓën ɗek xali w̃ëlali këni ɓakange epëxw gë ɓaki gë ɓacaxaken ɓand ɓayitara baɓi ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɓër lëɓa baɓi Yesu ɓën, er hi bani në owëli oco ɓësoŝan ɓën fo, ala aɓi pën bana ɓësoxari ɓën gë oɓaŝ ol. ");
INSERT INTO bsc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ga xucak eŋo, Yesu nëỹali këɓi ɓësëfan ɓën eni ɗëngwa ekeg elo gë ikuluŋ iŋ, eni pelaraxën mëŋ gë amëxwër aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","And fela këɓi amëxwër aŋ, ƴe ko ƴaŋ gër etënd exo calex në er nacët. Ga kë xwëyar, ɓayi ko na gaɓat. ");
INSERT INTO bsc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amëd aŋo h̃at këni ɓësëfan ɓën gër ngu, ga h̃awëta këni ebar el, ata men oŋ ga kë xani ɓomeŋ ɓomeŋ kë lëfërirand ikuluŋ iŋ ga fed këni gë ekoc etëm. ");
INSERT INTO bsc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ata gand oxeya, Yesu sëf këɓi do ko ƴend ƴaŋ gër men ang gër ebar fo. ");
INSERT INTO bsc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wat këno ɓësëfan ɓën ga ko wëñët gër men. Wëlandëra këɓi do ga ŝëg këɓi ɓenjëw̃ ɓeŋ këni xeỹënd ŝor: «Oñeỹ ex, oñeỹ ex!» ");
INSERT INTO bsc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ata re ko Yesu: «Wëno ex, wëno ex! Kapinayin, këren yëdara na!» ");
INSERT INTO bsc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyer yaka këŋo: «Axwën, angëmëne enimin wëj ex, pelële me eƴeli ƴaŋ gër men!» ");
INSERT INTO bsc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Re ko Yesu: «Ƴow!» Ata Piyer cëpëŝëpët gër ikuluŋ, ko ƴend ƴaŋ gër men end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ɓarikan, ga nëkon ko ekoc el, yëdara ko. Ata ga këŋo noỹeli, xeỹ ko: «Axwën, Axwën, pexënële!» ");
INSERT INTO bsc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ataŋ Yesu yënën këŋo ataxan aŋ, sëra këŋo do re ko: «Oko Piyer, inew̃a ekwëta etil elo! Inew̃a h̃ëpëgënaxën ki?» ");
INSERT INTO bsc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","And fëra këni gër ikuluŋ aŋ, xucak ekoc el. ");
INSERT INTO bsc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɓësëfan ɓër ebax polo gër ikuluŋ ɓën foxi këni, gër osapar or Yesu do këni rend: «Wëj ex enimin Asëñiw̃ ar Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ga xegëta këni anjer aŋ, h̃at këni gër ebar ed bani w̃acënd Genesaret. ");
INSERT INTO bsc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓër sëk banëɓi na gër ed h̃at bani ɓën, ga xwita këno Yesu, sëfëtëra këni eŋo ɗek Genesaret in. Ata w̃ëlaraw kënëɓi ɗek ɓëŝëxwëra ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Axara bano xarand Yesu eɓi teɓënd eni kwixwëta ndakaŋ ambana and acuɗ andexëm aŋ. Do ɗek ɓër bax xwixwëtand ɓën bax fakënd. ");
INSERT INTO bsc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ata akey amat, ofariseŋ do gë ɓëŝalen xaniw këni gër Yerusalem ƴow këni xali gër ed ebaxo Yesu. W̃ëka këno: ");
INSERT INTO bsc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ɓësëfan ɓëreƴ ɓën, ine cëŋ këni ƴepënaxënënd ɓapela ɓand ɓëxarëk ɓaŋ? Ine këni ƴambëraxënënd neɓarëxe otaxan ok?» ");
INSERT INTO bsc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu yaka këɓi: «Do wën cëŋ, ine kën ƴepënaxënënd apela and Kaxanu aŋ do kën sëfënd and ɓëxarëk ɓërewën aŋ? ");
INSERT INTO bsc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaxanu ga re ko: “Pëɓindëɓi norix gë sorix. Do ar këɓi xare yo nëm gë sëm, ar eɗaw̃ ex.” ");
INSERT INTO bsc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ɓari wën kën rend: “Ar këɓi fel nëm gë sëm mëne er hi bax eɓi dëcaxën in, Kaxanu yël këŋo, axor xor ko eɓi ɗëc.” ");
INSERT INTO bsc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Awa mondako kën ƴepënënd er re ko Kaxanu in në end apela and ɓëxarëk ɓërewën. ");
INSERT INTO bsc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wën ɓëỹëŋënax ɓër kë laɓayand hi kën! Ɗal in ỹëgw ko alaw̃ënel Esayi mëne Kaxanu rek: ");
INSERT INTO bsc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ɓela ɓëjo gë etëỹ el fo këne ŝalend. Ow̃ëkw oreɓën oŋ caw h̃awëta ke. ");
INSERT INTO bsc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ado këne ŝalend, asoro fo këni sorond gayikako ɓend këni yerëtënd ɓeŋ kënëɓi sëƴalind ɓela ɓën.”» ");
INSERT INTO bsc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ata Yesu w̃ac këɓi ɓër gër amëxwër ɓën do re ko: ");
INSERT INTO bsc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","«Ɓaxëtin aye eŋun pënixën eŋo: er kë ŝanënd gër etëỹ ed ala in këŋo ɓuyarënënd, ax gi ex na er ko nënand in.» ");
INSERT INTO bsc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɓësëfan ɓën, and xeta këno aŋ re këni: «Anang nde nang këƴ mëne ofariseŋ ok axoỹën xoỹën këni gë eyeƴan elo?» ");
INSERT INTO bsc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu yaka ko: «Atëx and axo dëɗ ex na yo Faba, mëŋ ar ex ƴaŋ gër orën an, and edët ex. ");
INSERT INTO bsc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Teɓëxënëɓi, ɓëŝiw̃ëk ɓër kë lasërënd exëni. Aŝiw̃ëk eŋo ɗasënd aŝiw̃ëk aŝandaw̃, ɓën tak kë lati në ambëxw.» ");
INSERT INTO bsc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ata Piyer re ko: «Asëƴali, paỹanëlëɓo tan apënëtal aŋo.» ");
INSERT INTO bsc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yaka këŋo: «Oko wën, ba an yëlarand na nde? ");
INSERT INTO bsc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ax gi ex na nde er ko nënand ala in gër acël kë h̃atënd do ex paỹërax gër apuỹ? ");
INSERT INTO bsc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ɓarikan, er kë ŝanënd gër etëỹ in, gër emëkw kë xaniwënd. Ejo këŋo ɓuyarënënd ala an. ");
INSERT INTO bsc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gër emëkw kë xaniwënd ɓanjëlan ɓañëŋënax ɓaŋ: olaw̃ër, orekar, eñac, orek, enëgwëŝ, ocir. ");
INSERT INTO bsc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɓeñëŋënax ɓeŋo këŋo ɓuyarënënd ala an. Ɓari eƴambëra ed neɓarëxe otaxan el ax ɓuyarënënd na.» ");
INSERT INTO bsc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ga xucak eŋo, Yesu ƴe ko gër ebar ed Tir gë Sidoŋ. ");
INSERT INTO bsc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ata asoxari aɓëkanahaŋ, ar lëg bax na gër ebar elo, ƴow ko gër ed hi ko Yesu do këŋo xarand: «Axwën, wëj Asëñiw̃ ar Dafid, kaỹënanëlexi wëno! Aɓiw̃ën gë ɓëyël exo, do mbaŋ këno narëndërand.» ");
INSERT INTO bsc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ɓari Yesu xor ko, ado gë tëkër ak aŋo yaka ex na. Ga xeta këno ɓësëfan ɓërexëm ɓën, w̃ëka këni: «Aƴo ŋw̃ay na nde ajo? Ɓiyi ɗek ŝëŝësan këɓo ang ko xeỹërand gër ofoƴ oreɓi ak!» ");
INSERT INTO bsc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ata Yesu yaka këŋo asoxari an: «Wëno, Ɓëyisërayel ɓër nambërak ang opeỹ ɓën fo ƴow këme mëni cala.» ");
INSERT INTO bsc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɓarikan, asoxari an ga sëka këŋo, foxi ko gër lëngw irexëm do re ko: «Axwën, dëcale ako dëŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu yaka këŋo: «Ax ye ex na enaỹët ed er këni ƴambënd oɓaŝ el eƴëɓi ɗapën ɓëkwërëkwër.» ");
INSERT INTO bsc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ata re ko asoxari an: «Eyo ɗal ex Axwën, ɓarikan ɓëkwërëkwër ɓëŋ aw̃eɗara këni w̃eɗarand ɓeɓër kë wëcënd gër ed këni ƴambërand ɓër xwën këɓi ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aŋo re ko Yesu: «Awa aɓiw̃ën, wëj mbaŋ xwëta këƴe. Gilex ang ỹandi ki ak.» Ata në amëd aŋo dëŋ fak ko aɓiw̃. ");
INSERT INTO bsc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ga xani ko na gër ebar ed Tir gë Sidoŋ, sëfa ko anjer and gër Galile aŋ, h̃at ko ƴaŋ në etënd do ỹëpax ko. ");
INSERT INTO bsc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na ɓarërëgu këni ɓela ɓën ɓamëxwër ɓamëxwër. W̃ëlanëgu këno na: ɓëseỹik, ɓëŝiw̃ëk, ɓamuma, ɓër goɓo do gë ɓëŝëxwëra ɓëranjëm. Xwëtëra kënëɓi gër lëngw irexëm, ata mëŋ fakën këɓi. ");
INSERT INTO bsc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ata ɓamuma ɓaŋ këni yeƴandërand pot-pot; ɓër goɓo ɓën do gë ɓëseỹik ɓën këni ƴexërand aye, ɓëŝiw̃ëk ɓën këni watërand ŝenene. Ga wat kënëɓi, ɓela ɓën ŝaran këɓi xali xurik do këno ŝëkwënd Kaxanu, mëŋ ar xwënëk ɓulunda ir Isërayel an. ");
INSERT INTO bsc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ata Yesu w̃ac këɓi ɓësëfan ɓën do re ko: «Ɗek ke xaỹënanënd ɓela ɓëjo. Elod ɓakey ɓatas këne sëfarand do ani ƴambëra ex na. Axe ñandi ex na mëni pela, eni maỹira gë enjo eŋ, ɓon këni sorox gër fëña.» ");
INSERT INTO bsc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na re këni ɓësëfan ɓën: «Mondake kënëɓe lëɓaye ɗek ɓela ɓëjo tëɓ ro gër apuỹ?» ");
INSERT INTO bsc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu yaka këɓi: «Ɓamburu ɓanjëgwe wa lëkaya kën?» Re këni: «Ɓanjongëɓaki do gë ɓëngan ɓëpënëfëne.» ");
INSERT INTO bsc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na fel këɓi ɓela ɓën eni ñëpara gër ebar. ");
INSERT INTO bsc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ata w̃eɗ ko ɓamburu ɓanjongëɓaki ɓaŋ do gë ɓëngan ɓëŋ. Ga ŝëkwa këŋo Kaxanu, hëbëndër ko do yël këɓi ɓësëfan ɓën enëɓi cetëra ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ang ebani ak, ƴambëra këni ɗek xali w̃ed këni. Er ɓayitara baɓi in, fëxwëk ɓakange ɓanjongëɓaki. Ata ɓësëfan ɓën w̃ëlali këni kwël. ");
INSERT INTO bsc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓër ƴambëra bax ɓën er ebani, ɓësoŝan ɓën fo owëli onax. ");
INSERT INTO bsc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ata Yesu ga fela këɓi ɓela ɓën eni maỹira, mëŋ w̃ara ko polo gër ikuluŋ do ƴe ko gër ebar ed Magadaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Akey amat, ofariseŋ do gë Osaduseŋ ƴow bax gër Yesu eno di atëƴ. W̃ëka këno eɓi din ecarax eni nangaxën mëne gër orën xaniw ko. ");
INSERT INTO bsc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ata Yesu yaka këɓi: «And kë war orën apenëka aŋ, ax gi ex na nde anang kën nangënd mëne wur in xërikërak? ");
INSERT INTO bsc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɓëte gëɓër and kë hi orën ɗëmbëndëruŋ aŋ, ax gi ex na nde anang kën nangënd mëne asëɓ kë sëɓ? Aye kën fitëndërënd er kë hi in and kën wat ang ex orën aŋ do kën sëkwanënd en pitëndër ɓend gë okey oko ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ata wën anjex añëŋënax do and kë rind orekar aŋo nde ke w̃ëkand mun masin ecarax. Ecarax end rin baŋo Kaxanu Yonas eŋ fo këmun w̃asin.» Yesu, ga yaka këɓi na mondako, kwël ƴe ko. ");
INSERT INTO bsc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ga xegëta këni anjer aŋ, ɓësëfan ɓën xwita këni mëne eƴamb ƴamb ani penaw ex na. ");
INSERT INTO bsc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ata re ko Yesu: «Kwëỹëtayindën lewir ir ofariseŋ in do gë ir Osaduseŋ in.» ");
INSERT INTO bsc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na ɓësëfan ɓën yëla këni mëne ga xwëyaw këni ɓamburu ɓaŋ ko yeƴanaxënënd mondako. ");
INSERT INTO bsc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gogo nde ga nang ko Yesu, ata w̃ëka këɓi: «Wën ɓela ɓër gë ekwëta etil ɓëjo, inew̃a kën yëlaxënënd mëne end eƴamb ƴamb ed ɓayik an mëlaw ex na këme yeƴanënd? Awa wën mbaŋ ɓak ɗe ang xwëta këne ak! ");
INSERT INTO bsc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ata wën xali gërëgako aŋun pëni ex na endam eŋ. An kwitand na nde ang lëɓa bamëni ɓela owëli oco gë ɓamburu ɓanjo ak? Ɓakange ɓanjëgwe wa w̃ëlali ban gë er ɓayitara baɓi in? ");
INSERT INTO bsc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɓëte and lëɓa bamëni ɓela owëli onax gë ɓamburu ɓanjongëɓaki aŋ, ɓakange ɓanjëgwe w̃ëlali ban? ");
INSERT INTO bsc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mondake wa ɓayik aŋun pëni ex na mëne ax gi ex na end eƴamb-ƴamb këme yeƴanënd? Ga re këme, kwëỹëtayindën lewir ir ofariseŋ in do gë ir Osaduseŋ in.» ");
INSERT INTO bsc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aŋo fëni këɓi ɓësëfan ɓën mëne abaɓi fel na end eƴamb-ƴamb, ɓarikan eni titinalind osëƴali or ofariseŋ do gë Osaduseŋ ol baxo rend. ");
INSERT INTO bsc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Akey amat, Yesu ƴe ko gër ebar ed Sesare ir Filip. Ata ga h̃at ko, w̃ëka këɓi ɓësëfan ɓërexëm ɓën: «Gër onang or ɓela, noỹo këni rend hi këme wëno Asëñiw̃ ar ala an?» ");
INSERT INTO bsc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yaka këno: «Na fo exëni ɓër kë rend mëne wëj ex Ŝaŋ Batis. Ɓëjo, wëj ex alaw̃ënel Eli, ɓëjo, wëj ex alaw̃ënel Yeremi. Na fo exëni ɓëte ɓër kë rend mëne wëj alaw̃ënel aŝëxe ar Kaxanu hi këƴ.» ");
INSERT INTO bsc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","«Do wën cëŋ, noỹo kën yëland hi këme?» ");
INSERT INTO bsc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ata yaka këŋo Simoŋ Piyer: «Wëj ex Afexën an, Asëñiw̃ ar Kaxanu, mëŋ ar gë aniyan an!» ");
INSERT INTO bsc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ata re ko ɓëte Yesu: «Awa nëngandëralexi, Simoŋ, wëj asëñiw̃ ar Yonas an. Faba Kaxanu, mëŋ ar ex ƴaŋ gër orën an, nangën ki eŋo, ax gi ex na ala. ");
INSERT INTO bsc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ga re këme, Piyer, wëj ang aparëfac fo hi këƴ. Do wëno gër aparëfac aŋo këme rëɗ Amara andam aŋ, do owët or wur ir ɓëŝësëk oŋ ỹoweỹ aŋo koran na. ");
INSERT INTO bsc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wëj këmi fëxwën ɓacoketaya ɓand owun or gër orën ɓaŋ. Ar këƴo seɓan yo gër ebar ro, Kaxanu aseɓan këŋo seɓan gër orën. Ɓëte er ki ỹapan yo gër ebar ro, Kaxanu aỹapan këŋo ỹapan gër orën.» ");
INSERT INTO bsc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ga h̃ata eŋo, Yesu xëŋa këɓi xali ɓësëfan ɓën eni cësinali mëne mëŋ ex Afexën an. ");
INSERT INTO bsc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ata amëd aŋo ỹana baxo Yesu këɓi nangënënd ɓësëfan ɓën mëne afo exo ƴe gër Yerusalem exo torox. Gër otaxan od ɓëŝaɗaxan ɓëlëngw, gër od ɓëŝalen do gër od ɓëxarëk ɓër Ɓëŝëwif ebax exo toro. Ɓën ebax eno tëra, eno narën xali eno ɗaw̃. Ɓarikan, yatir akey atasën exo kani gër ecës. ");
INSERT INTO bsc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ata Piyer nacët këŋo Yesu do këŋo rexërand: «Ali Axwën, Kaxanu axo ma na eŋo! Endako rako eŋ axi gi na!» ");
INSERT INTO bsc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ata ga ri ko wërëŝët Yesu, yaka këŋo Piyer: «Beɗitale fa Sindan! Wëj ang ar ke lënanënd eñëŋënax fo hi këƴ! Ɓanjëlan ɓandeƴ ɓaŋ, ɓand ɓela fo ex, ax gi ex na ɓand Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ata ga h̃ata ko, fel këɓi ɓëte ɓësëfan ɓën: «Ar ỹandi këŋo exe tëf an, teɓëlexo eɓal ed gaf irexëm fo el. Yëxwëlexo toro iŋ ado ex gi alaw̃ këno law̃, exe tëfaxën. ");
INSERT INTO bsc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ar këŋo ɓalënd end gaf irexëm fo an, anemi ko nemi. Ɓarikan, ar kë nemin aniyan andexëm aŋ në end ow̃ac oram an, afex ko fex. ");
INSERT INTO bsc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inew̃a këŋo feca ar kë ŝotëra ɓeỹ ɗek gër ngwën ro an, angëmëne anemin nemin ko enjëw̃ endexëm eŋ? Er xëɓënëk ang enjëw̃ ak ax gi ex na. Do gë ine ko nëmb ala an? ");
INSERT INTO bsc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wëno Asëñiw̃ ar ala an and këme ƴe aŋ, aɓaka këme ɓakaw gër ngwën gë enjaran end Faba eŋ, do gë omeleka odexëm ok. Yatijo, këmo w̃aŝ ala kala er ỹapëk exo cot in ang ko w̃ëlaya aniyan andexëm ak. ");
INSERT INTO bsc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ɗal in këmun felënd, ang xwëŝara kën ro mondako, ɓërëmar ani cësëra na xarak ane wat ex na wëno Asëñiw̃ ar ala an, ga këme ƴow gë owun oram ol.» ");
INSERT INTO bsc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ga xucak ɓakey ɓanjongamat elod ga felëra këɓi end ecës edexëm eŋ, Yesu w̃ac këɓi Piyer, gë Ŝak do gë Ŝaŋ, aɓinëm ar Ŝak. Nacët këɓi ƴaŋ në etënd etëm. ");
INSERT INTO bsc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ƴaŋ gër etënd elo na, ogës odeɓën dëŋ nëngwët baxo Yesu ang baxo watind ak. Ata dëxas irexëm in kë ỹegënd ang eñan fo do ɓanjëm ɓaŋ kë watind jing-jing ang ɓëmal fo. ");
INSERT INTO bsc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ata na bërëxaɗët, ŝanayaw këni Moyis do gë Eli ga këni xanar gë Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyer fel këŋo Yesu: «Axwën, ɓon yedox ɗe ene ɓayiye ro. Ga ỹandi ỹandi ki, wëno ata këme ri ɓaner ɓatas: amat andeƴ, aŋo and Moyis, aŋo and Eli.» ");
INSERT INTO bsc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ga ko yeƴan Piyer mondako, fedawëk aŋar and gë okoɗux, laɓ këɓi kwëc. Ata wëliwëk oniw̃ ga re: «Awa ajo ex Asëñiw̃ën ar pëlot gër yomb iram an. Wëno ɓon ke ɓalënd endexëm eŋ, ɓaxëtindëno aye.» ");
INSERT INTO bsc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ga wël këni oniw̃ olo, anjiỹ aŋ foxin këɓi ɓësëfan ɓësas ɓën oƴiỹ oŋ ŋëŝ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ɓarikan, and sëka këɓi Yesu aŋ, h̃ëmba këɓi do re ko: «Këren yëdara na, kaniyin!» ");
INSERT INTO bsc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ga rënëta këni, wat këno Yesu gaɓat. ");
INSERT INTO bsc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","And bani ŝëland etënd aŋ, Yesu fel këɓi: «Ala këreno pel na ɗe er wat kën in xali wëno Asëñiw̃ ar ala an me kani gër ecës.» ");
INSERT INTO bsc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ata ɓësëfan ɓën w̃ëka këno: «Inecëŋ këni rexënënd ɓëŝalen ɓën mëne afo exo ƴow pere Eli?» ");
INSERT INTO bsc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yaka këɓi: «Ɗal ex mëne afo exo ƴow pere Eli, do exo mëxwëtëra ɓeỹ ɗek gër ɓandëw̃ëra ɓand Yakob. ");
INSERT INTO bsc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ɓarikan ga re këme, Eli anëka ƴow ko, ɓela ɓën fo ɓayik ano kwita ex na mëŋ lëkayaxën këno ang ỹandi këɓi ak. Ɓëte mondako fo këne soron wëno Asëñiw̃ ar ala an.» ");
INSERT INTO bsc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ata ɓësëfan ɓën fëni këɓi mëne Ŝaŋ Batis, baŋo rend. ");
INSERT INTO bsc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","And h̃at këni gëɗ gër etënd aŋ, gër ed ɓarërëgu bani ɓela ɓëranjëm, ŝanayaw ko pëlët asoŝan, foxi ko gër lëngw ir Yesu do ko rend: ");
INSERT INTO bsc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«E Axwën, kaỹënanëlexi lëmëta iram, ŝënan lëk këŋo do mbaŋ ko sorond. Laŋ këŋo reɓërand: ɓandëmar gër xoɗux, ɓaŋo gër men. ");
INSERT INTO bsc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ga w̃ëlaw këmo ro gër ɓësëfan ɓëreƴ, ɓën ani kor ex na eno pakën.» ");
INSERT INTO bsc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ata yaka këŋo Yesu: «Ata wën anjex and ɓela ɓër gë oŋëpëgënan, do ɓësëmbak hi kën! Xali niỹe wa këme ɓayi gë wën? Xali niỹe këmun ɓuŋan? Mëlanëgune ro itox iŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ga xeỹan këɓi na ɓëyël ɓën, ŝan këni ataŋ gër lëmëta, ata fak ko kwël na fo. ");
INSERT INTO bsc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","And ɓayi këni ɓën fo aŋ, ɓësëfan ɓën ga xeta këno Yesu, w̃ëka këno: «Inew̃a sëkwanaxën këmi mëni nëcët ɓëyël ɓën gër itox iŋo?» ");
INSERT INTO bsc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu yaka këɓi: «Ga ɓak ekwëta ed xwëta këno Kaxanu el sëkwanaxën kënëɓi. Ɗal in këmun felënd, ekwëta edewën el ado ex ɓa gwër gë enjëlir end mutarëd, axor xorëdon en de etënd elo: “Wëj etënd nacëtal fa ro!” Ata nacëtadox. Ɓëte ỹow̃eỹ adon sëkwan na en di. ");
INSERT INTO bsc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ɓëyël ɓërako rako ɓën, cale ind gë etiw̃i fo këɓi nëcëtënd.» ");
INSERT INTO bsc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","And bani ƴexërand Yesu gë ɓësëfan ɓërexëm aŋ gë angol gë angol, ɗek ebar ed Galile el, afel baɓi felënd mëne mëŋ Asëñiw̃ ar ala an, alëxw këno lëxw gër otaxan od ɓela ɓëxeỹax. ");
INSERT INTO bsc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Afel baɓi felënd ɓëte mëne alaw̃ këno law̃, ɓari yatir akey atasën axani ko xani gër ecës. Ata ga wël këni ɓeŋo ɗek ɓësëfan ɓën ŝamina këni. ");
INSERT INTO bsc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","And h̃at këni gër Kafarënawum aŋ, Yesu gë ɓësëfan ɓërexëm ɓën fed këni gë ɓësëf ɓër ŝagale ɓën. Ata w̃ëka këno Piyer: «Asëƴali arewën an, aw̃eɗ nde ko w̃eɗënd ŝagale ir Aciw̃ and Kaxanu in?» ");
INSERT INTO bsc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yaka ko: «Iyo, aw̃eɗ ko w̃eɗënd ɗe!» And lil ko Piyer gër iciw̃ aŋ, ɗamana exo yeƴan, Yesu w̃ëka këŋo: «Simoŋ, ɓemun ɓend gër ngwën ro ɓeŋ gër noɓën këni xanand ŝagale in? Gër ɓër lëgëk gër ebar edeɓën nde, ba gër ɓëliyer nde?» ");
INSERT INTO bsc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yaka këŋo: «Gër ɓëliyer.» Ata re ko ɓëte Yesu: «Ɓër lëgëk gër ebar edeɓën ɓën ani meɗënd na ŝagale in. ");
INSERT INTO bsc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ɓarikan, këdi kënëɓo xoỹën, maral gër anjer eƴ ɗap engërëxato eŋ. Ekan eñanar ed kë lëk el, cëpëtëlo, do polo gër etëỹ edexëm këƴ sëk atama and koɗi. Mëlaw eƴëɓi pëxwën ɓësëf ɓër ŝagale ɓën. Atama aŋo gwac kë hi ŝagale ir ɓiyi ɓëxi in.» ");
INSERT INTO bsc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ata amëd aŋo, ɓësëfan ɓën ga xeta këno Yesu, w̃ëka këno: «Pelëlëɓo noỹo hik alëngw an gër owun or gër orën?» ");
INSERT INTO bsc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu w̃acëgu këŋo itox, fela këno, xwët këŋo mërëxand, re ko: ");
INSERT INTO bsc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Ɗal in këmun felënd ar ax nëngwët ex na ola orexëm do exo gi ang itox iŋo an, din axo ɗil na gër owun or gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mëŋ ex ar kë ɓana yo gër ola orexëm ang itox iŋo ak, alëngw ko hi gër owun or gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ɓëte ar këŋo xwëtaya yo itox ind ako në end ow̃ac oram, wëno dëŋ xwëtaya ke.» ");
INSERT INTO bsc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Ɓarikan ar këŋo lënan eñëŋënax ar w̃ak endam an, kiti ind sax doŋo iŋ ex eno dëxën angaỹ aŋoxixën and eƴamb, do eno ɗap gër anjer eŋo noỹilexën. ");
INSERT INTO bsc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kata fo hik gër ngwën ro gayik ɓon ex ɓeɓër kë lënanënd eñëŋënax ɓën. Ekwëỹëta ed eñëŋënax el ax mënd ex na. Ɓarikan, ɓon w̃e këŋo ar këɓi lënanënd eñëŋënax ɓela an. ");
INSERT INTO bsc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Angëmëne ataxan andeƴ aŋ ba sapar ireƴ in ki lënanënd eñëŋënax eŋ, kacal eƴ ɗap caw. Pecanëlexi eƴ ɗil gër aniyan and din ir din gë wal iɓat gë exi ɓayi osapar oxi, ba otaxan oki do exi ɗëxw Kaxanu gër xoɗux or din ir din. ");
INSERT INTO bsc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Angëmëne angës andeƴ aŋ ki lënanënd eñëŋënax eŋ, nongoloƴëtël eƴ ɗap caw. Pecanëlexi eƴ ɗil gë angës amat gër aniyan and din in din gë exi ɓayi tak ɓaki, do Kaxanu exi ɗap gër anjer and xoɗux.» ");
INSERT INTO bsc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Kërenëɓi yafënd na ɓërëw̃ak endam ɓën. Omeleka od këɓi nëkonand ok din këno sëkand Faba ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wëno Asëñiw̃ ar ala an, ɓër nambërak ƴow këme mëni pexën. ");
INSERT INTO bsc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɓaxëtin amatinali aŋo, en yëlaraxën: Ax gi ex na nde ala ar ŝot këɓi opeỹ keme an, eŋo nemënd iɓat, aseɓ këɓi seɓ ofëxw ocongonax gë ocongonax ok gër kece exo ƴexën gër ocal od ir nem këŋo? ");
INSERT INTO bsc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ɗal in këmun felënd, angëmëne awat wat këŋo ifeỹ ir nem baŋo in, aŋo fo këŋo nëngandëra nëmëc, ɓari ax gi ex na në end ofëxw ocongonax gë ocongonax od gër kece eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mondako fo ex end ɓërëw̃ak endam eŋ, gër Faba mëŋ ar gër orën an. Ala gaɓatak aŋo ñandi ex na exo nambëra. ");
INSERT INTO bsc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Angëmëne aɓinëx w̃enan ki, macëlo eƴo pelëra wën ɓëxi fo. Angëmëne aɓaxët ɓaxët ki anëka xana këƴo aɓaỹe ireƴ. ");
INSERT INTO bsc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɓari angëmëne axi ɓaxët ex na, calalëɓi otede oki ba otas eno pelëraxën. ");
INSERT INTO bsc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Angëmëne ah̃ëp h̃ëp ko eŋun ɓaxët in, mëlal endeƴ eŋ gër ɓëlëngw ɓër Amara andewën. Ɓëte ga h̃ëp h̃ëp ko eɓi ɓaxët in, nangël mëne ala ar aŋo nang ex na Kaxanu hi ko. Ata ado ɓeŝindo, asëmbak ex! ");
INSERT INTO bsc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ɗal in këmun felënd, er kën ŝëɓan yo gër ebar ro, Kaxanu aŝëɓan ko ŝëɓan ƴaŋ gër orën. Ɓëte er këŋun ỹapan yo gër ebar ro, Kaxanu aỹapan këŋo ỹapan ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ɗal in këmun felënd, angëmëne ɓela ɓëxi eɓi ket gër ebar eno kara ỹeỹ gër cale, Faba, mëŋ ar ex ƴaŋ gër orën an, ayël këɓi yël. ");
INSERT INTO bsc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mëŋ ex, gër ed këni ɓarër yo ɓela ɓëxi ba ɓësas në end ow̃ac oram, wëno mërëxand ireɓën këme hi.» ");
INSERT INTO bsc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ata Piyer ga sëka këŋo Yesu, w̃ëka këŋo: «Axwën, ɓanjëgwe wa ỹapëk mo teɓanënd aɓaỹe and ke w̃enan aŋ? Ba ɓanjongëɓaki nde?» ");
INSERT INTO bsc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu yaka këŋo: «Ame de ex na ɗe ɓanjongëɓaki, ɓarikan ofëxw ocongoxi ɓakëlëbëd ɓanjongëɓaki. ");
INSERT INTO bsc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mëŋ ex, owun or gër orën ol er wëndërëk gë endeƴ end emun end ɓar baɓi okaɗëp odexëm eɓi mëkëra ba mondake lëkaya këni napul irexëm in. ");
INSERT INTO bsc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ga ko fën koɗi in, w̃ëlanëgu këno xaɗëp ir ɓayir bani añomëx atëm. ");
INSERT INTO bsc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Xarak xaɗëp ijo axo gi bana gë er këŋo w̃aŝën. Ata axwën arexëm an re ko enëɓi pan mëŋ, gë alindaw̃, gë oɓaŝ ol do gë ɗek er ŝot baxo gër ekun edexëm in, exo kanaxën añomëx aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ata xaɗëp ijo lapaya ko mopoxi gër osapar or axwën arexëm ko renitand: “Këla ɓuŋanële pere, ɗek këmi w̃aŝën.” ");
INSERT INTO bsc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ga xaỹënan këŋo, axwën ar xaɗëp an, seɓën këŋo añomëx aŋ do kwël seɓët këŋo exo maỹi. ");
INSERT INTO bsc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","And ŝan ko xaɗëp ijo aŋ, fed këni gë aŝandaw̃ ar ỹomëxa baŋo tëkër koɗi. Ga w̃ëlën këŋo, xër këŋo lëƴ, do ko rend: “Doro afo eƴe maŝ koɗi iram in! Maŝële koɗi iram in!” ");
INSERT INTO bsc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aŝandaw̃ ga ŝana këŋo na, lapaya ko gër osapar orexëm do këŋo xarand: “Këla ɓuŋanële pere, aw̃aŝën këmi w̃aŝën!” ");
INSERT INTO bsc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ɓari mëŋ h̃ëp ko kweŋ, w̃ëla këŋo gër epëra xali yatir këŋo w̃aŝën er ỹomëxa ko in. ");
INSERT INTO bsc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ɓoŝandaw̃ ga wat këni ang ri baxo ak, ƴambën këɓi xali gër ow̃ëkw. W̃ara këni reƴax këni ɗek gër axwën areɓën. ");
INSERT INTO bsc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ata axwën an w̃ac këŋo xaɗëp ijo, re këŋo: “Wëj ata mbaŋ xeỹ këƴ ɗe! Ax gi ex na nde wëno ro seɓan këmi añomëx andeƴ aŋ ga xara këƴe? ");
INSERT INTO bsc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wëj ɓëte ine ɓayik axi kaỹënan ex na aŝandax ang wëno ak?” ");
INSERT INTO bsc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na ga logën këŋo axwën an, fel këɓi eno pëxwën andiyen atiɓax exo maŝaxën er ỹomëxa ko in. ");
INSERT INTO bsc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ata Faba, mëŋ ar ex ƴaŋ gër orën an, mondako këŋun ri angëmëne ang hi kën ak, ala kala aŋo teɓanënd na aɓaỹe irexëm gë emëkw el ɗek.» ");
INSERT INTO bsc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ga h̃ata ko Yesu er baɓi sëƴalind in na gër ebar ed Galile, xani ko xwiriŝ do kwël ƴe ko gër ed Yude, ekeg Yurëdeŋ in. ");
INSERT INTO bsc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ata ɓela ɓën sëfa këno ɓenga, ɓenga. Fën fakëndërax baɓi ɓër ŝëxwëra bax ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ata h̃atëgu këni ofariseŋ eno di atëƴ. W̃ëka këno: «Aỹap nde ỹapëk asoŝan an eŋo pela alindaw̃ nand këŋo ỹandi yo?» ");
INSERT INTO bsc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu yaka këɓi: «Wën an pën ex na nde gër Akayëta and Kaxanu mëne nand ỹanak aniyan na asoŝan gë asoxari ɓaƴ këɓi Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mëŋ ex, asoŝan an afo eɓi ŋaw̃ëta nëm gë sëm, eni ɓaraxën gë alindaw̃ do eni gi eman emat. ");
INSERT INTO bsc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Awa ani ɓayi na gë nëng gë nëng, ŝapar iɓat këni hi. Mëŋ ex, ala an këreɓi capëreli na ɓër ɓar këɓi Kaxanu ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ata re këni ofariseŋ ok: «Do ine cëŋ felaxën këɓo Moyis mëne asoŝan an eŋo pelaxën alindaw̃ ñëgwënëleŋo kayëta ir acapëra?» ");
INSERT INTO bsc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu yaka këɓi: «Në end emëŝ endewën rexën baxo Moyis enëɓi peland ɓolindaw̃ ɓorewën. Ɓari ax gi bana mondako nand ỹanak aniyan na. ");
INSERT INTO bsc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wëno ga re këme, ar këŋo fela yo alindaw̃, xarak ax gi ex na në end orekar do eŋo ñër aŝëxe, në emenan eŋo asoxari aỹanar an. Ado orekar këni rind gë axinëm an.» ");
INSERT INTO bsc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ata re këni ɓësëfan ɓërexëm ɓën: «Angëmëne mondako ex emëlayan ed asoxari el, ofëcak ax gi ex na gër eñër.» ");
INSERT INTO bsc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu yaka këɓi: «Afo ɓër yël këɓi Kaxanu ɓën kë xor eŋo, ax gi ex na ɓela ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gër aniyan aŋo, ɓësoŝan exëna ɓër ani kor na eni ɗaki gë asoxari. Ɓërëmar mondëw̃eli kënëɓi rëw̃elind, ɓëjo ɓela ɓën dëŋ këɓi rind eni gi mondako. Ɓëjo ɓëte në end owun or gër orën këni ɓayixënënd ñërërëxe. Ar kë xor eŋo an, tëfëlexo.» ");
INSERT INTO bsc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ata h̃atëgu këni ɓela na gër ed baxo yeƴanënd Yesu ga w̃ëlanëgu këno oɓaŝ oreɓën ol eɓi calen mokwëtan otaxan ok. Ɓari ɓësëfan ɓën xeỹënaxën kënëɓi. ");
INSERT INTO bsc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ata re ko Yesu: «Teɓinëɓi oɓaŝ ol ene tëka, ɓër ang oɓaŝ ɓën xwënëk owun or gër orën ol, kërenëɓi ŋw̃aỹënd na!» ");
INSERT INTO bsc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","And ŝalen këɓi mokwëtan otaxan aŋ, ƴe ko kwël. ");
INSERT INTO bsc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ga xucak eŋo, h̃atëgu ko ŝambenjar, w̃ëka këŋo Yesu: «Asëƴali, enjekax end fe wa ỹapëk me di me cotaxën aniyan and din aŋ?» ");
INSERT INTO bsc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu yaka këŋo: «Ine këƴe w̃ëkaxënënd end enjekax? Aɓat fo ex ayekax an. Angëmëne aỹandi ỹandi ki eƴ ɗil gër aniyan and din, tëfël ɓapela ɓaŋ.» Ata w̃ëka ko ala ajo: «Ɓand fe wa?» ");
INSERT INTO bsc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yesu yaka këŋo: «Ax gi ex na monaw̃ ala, ax gi ex na mondi orekar, ax gi ex na monëgwëŝan ala, ax gi ex na mondeka. ");
INSERT INTO bsc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pëɓëlëɓi norix gë sorix, ɓalindëlexi end aŝandax eŋ ang ki ɓalënd end gaf ireƴ ak.» ");
INSERT INTO bsc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ata ŝambenjar in re ko: «Aye sëf këme ɗek ɓapela ɓaŋo, ɓëte and fe ɓayik?» ");
INSERT INTO bsc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yaka ko Yesu: «Angëmëne aỹandi ỹandi ki eƴ gi ar ŝenene, ƴel eƴ panëx acota andeƴ aŋ do koɗi eƴ yëlëra ɓëxaỹënaxik ɓën. Ata këƴ ŝot napul isëm ƴaŋ gër orën. And këƴ ri mondako aŋ, ƴow eƴe tëf wëno.» ");
INSERT INTO bsc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ga wël ko eyeƴan elo, ŝambenjar in ɓeɗi ko, ƴe ko kwël gayikwa ar gë napul isëm hi baxo. ");
INSERT INTO bsc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ata Yesu fel këɓi ɓësëfan ɓërexëm ɓën: «Ɗal in këmun felënd, ɓon këŋo ƴëka ar gë napul an exo ɗilaxën gër owun or gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ga re këme, gelemba saxëk exo kuca në imëd ind icëkwër gë exo ɗil ar gë napul an gër owun or gër orën.» ");
INSERT INTO bsc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ɓësëfan ɓën, ga wël këni eŋo, ŝaran këɓi xali. Ata re këni: «Do noỹo ngwa kë fex?» ");
INSERT INTO bsc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ga nëkon këɓi Yesu ang xeta bano ak, re ko: «Gër ɓela eŋo ax mënd ex na. Ɓarikan gër Kaxanu ɓeỹ ɗek wëndëk.» ");
INSERT INTO bsc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aŋo re ko Piyer: «Ɓiyi cëŋ ɓeỹ ɗek seɓëraw këmi, do sëf këmi wëj. Ine këɓo hi?» ");
INSERT INTO bsc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu yaka këɓi: «Ɗal in këmun felënd, and kë h̃at enëngwët ed ɓeỹ ɗek aŋ, wëno Asëñiw̃ ar ala an aỹëpa këme ỹëpa gër añëpara and owun gë enjaran endam eŋ. Ata wën ɓësëfan ɓëram ɓën ke xetëna në ɓañëpara ɓand owun epëxw gë ɓaki enëɓi kitixën Ɓëyisërayel ɓën ang exëni ɓandëw̃ëra epëxw gë ɓaki ak. ");
INSERT INTO bsc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Angëmëne në end ow̃ac oram seɓ këɓi ala: ɓoɓinëm, nëm gë sëm, alindaw̃ gë oɓaŝ orexëm, ɓëciw̃, oŝënga, nëmëc ko ŝotëra, ɓëte ecan ecan exo tënda aniyan and din aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɓëỹanar ɓëranjëm kë hi ɓemban do ɓemban ɓëranjëm ɓëỹanar.» ");
INSERT INTO bsc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Nëkoɗ owun or gër orën ol gë er wëndërëk in. Ala ƴe bax mopëɗ eɓi calaraw ɓërandiyen eno kwëcën reseŋ in gër andëɗa andexëm. ");
INSERT INTO bsc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɓërandiyen ɓëỹanar ɓër sëk këɓi ɓën wëlër këni eɓi cos atama and koɗi amat, ang rëp bax gër amëɗëna ak. Ata re ko eni ƴe gër andëɗa and reseŋ andexëm. ");
INSERT INTO bsc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ƴe ko gër angol eɓi calaw ɓërandiyen ɓëŝëxe and yatënak aŋ. Sëk këɓi ga ỹëpara këni aỹëpa fo. ");
INSERT INTO bsc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ata re ko: “Ƴeyin wën ɓëte gër andëɗa andam, ang ỹapëk ak këmun ŝos.” ");
INSERT INTO bsc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓela ɓëjo ga w̃a këni ƴe këni. Ƴe ko ɓëte gër angol and h̃atëk eñan keŋ gër gaf aŋ. Ɓaka ko and hik eñan poxoŝ gaf aŋ, w̃ëlaw këɓi ɓëte ɓëŝëxe. ");
INSERT INTO bsc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ɓaka ko ɓëte gër angol ɗam ex cëla eñan eŋ. Sëk këɓi ɓela ɓëŝëxe ga ỹëpara këni. Ata fel këɓi: “Wën ine ɓayixën kën ro ciŝ aỹëparand fo?” ");
INSERT INTO bsc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yaka këno: “Ala aɓo meɗ ex na andiyen.” Ata fel këɓi eni ƴe ɓën ɓëte gër andëɗa and reseŋ andexëm. ");
INSERT INTO bsc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ga xwëyarëk, axwën andëɗa and reseŋ an fel këŋo aw̃ëxëta ar koɗi irexëm an: “Macëlëɓi ɓërandiyen ɓën eƴëɓi cosëra, do ñanalëɓi ɓemban ɓën.” ");
INSERT INTO bsc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ga sëka këno ɓër w̃ëlaw baɓi ɗam ex cëla eñan ɓën, ŝot këni ala kala atama amat and koɗi ang rëp bax gër amëɗëna ak. ");
INSERT INTO bsc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Felata këni ɓër w̃ëlaw baɓi elod mopëɗ gëɓër ɓën ga këni yëla mëne nëmëc këɓi ŝos. Ɓarikan, ŝos këɓi ala kala atama amat ang rëpëk gër amëɗëna ak. ");
INSERT INTO bsc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ala kala, and ko xana aŋ, exo ŋunëŋuna end axwën andëɗa eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ata aɓat re ko: “Oko ine cëŋ ŝosaxën këƴëɓo ɓiyi gwër fo gë ɓër riyenik apëxëd amat fo ɓën, xarak ɓiyi ɓuŋak oyat ok ɗek amëɗëna aŋ?” ");
INSERT INTO bsc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yaka këŋo: “Lawo, wëno ỹoweỹ ami menan ex na ɗe! Ax gi ex na nde atama amat wëlër baxe, ang rëpëk gër amëɗëna ak? ");
INSERT INTO bsc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kanal koɗi ireƴ in eƴ maỹi! Wëno wa ỹandi ke mo cos arandiyen afelatar an gwër fo gë wëj. ");
INSERT INTO bsc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ba ame kor na nde me di ang ỹandi ke ak gë napul iram in? Ɓëte ba ga nënga këme nde ki ƴakëraxind wëj?”» ");
INSERT INTO bsc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ata Yesu h̃ata ko: «Mëŋ ex ɓemban ɓën kë hi ɓëỹanar do ɓëỹanar ɓën ɓemban.» ");
INSERT INTO bsc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","And hi këni ɗam gër Yerusalem aŋ, Yesu nacët këɓi ɓësëfan epëxw gë ɓëxi ɓën, re ko: ");
INSERT INTO bsc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ga këne ƴende ako ƴaŋ gër Yerusalem, nangin mëne ɓela ke lëxw na wëno Asëñiw̃ ar ala an gër ɓëŝaɗaxan ɓëlëngw do gër ɓëŝalen. Do ɓën and këne xiti aŋ eɓi ketan ene ɗaw̃. ");
INSERT INTO bsc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓën fo ke lëxw gër ɓela ɓër ɓenëng ɓecëxe. Ata and këne lëŝëra do ene këmëra aŋ, ene ɗaw̃ mo pika në osëx. Ɓari, wëno yatir akey atasën axani këme xani gër ecës.» ");
INSERT INTO bsc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ga xucak eŋo, alindaw̃ ar Sebede, gë ɓosëñiw̃ sëka këno Yesu. Ata foxi ko eŋo kara ỹeỹ. ");
INSERT INTO bsc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu w̃ëka këŋo: «Inew̃a ỹandi ki.» Yaka ko: «Këla tanalëɓi wa ɓosëñiw̃ën ɓoram ɓëjo eni ketëna gër owun oreƴ: aɓat gand liw̃, ajo gand ŝame.» ");
INSERT INTO bsc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na, re ko Yesu: «Wën, an nang ex na er këne xarand in. Axor nde kën xor en toro ang wëno ak?» Yaka këni: «Iyo, axor këmi xor.» ");
INSERT INTO bsc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ata re ko ɓëte Yesu: «Ɗal ex, axor kën xor en toro ang wëno ak. Ɓarikan, end ene ketëna aɓat gand liw̃, ajo gand ŝame eŋ, ax gi ex na wëno kë sanand. Ɓër xëñënan këɓi Faba ɓën xwënëk ɓañëpara ɓaŋo.» ");
INSERT INTO bsc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ga wël këni eŋo ɓësëfan epëxw ɓën xoỹën kënëɓi ɓër gë aɓinëm. ");
INSERT INTO bsc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ata Yesu w̃ac këɓi, re ko: «Anang nang kën mëne ɓëlëngw ɓër ɓenëng ɓecëxe ɓën awun këni wunënd gë mbëña gër ɓela ɓër gër owar oreɓën, do ɓësëm ɓën aw̃asin kënëɓi w̃asinënd or gapak oreɓën ol. ");
INSERT INTO bsc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ɓari gër enga endewën, kërex gi na mondako. Ar ỹandi këŋo yo exo gi alëngw an, gilexo ariyenin ar ɓela ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Do ar ỹandi këŋo yo exo gi aỹanar gër enga endewën an, gilexo xaɗëp irewën. ");
INSERT INTO bsc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wëno Asëñiw̃ ar ala an mondako ƴow këme mun diyenin, ax gi ex na ene diyenin. Ado aniyan andam aŋ w̃eɗ këme ang acosa fo eni pexaxën ɓela ɓëranjëm.» ");
INSERT INTO bsc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu gë ɓësëfan ɓën ga këni ŝan angol and Yeriko aŋ, enga end ɓela baɓi sëfand na ɓura-ɓura. ");
INSERT INTO bsc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Xarak, ɓëŝiw̃ëk ɓëxi ỹëpa baxëna ler gër fëña do këni xararand. And wël këni mëne Yesu kë ƴowënd aŋ, këni xeỹënd: «Axwën, kaỹënanëlexi ɓiyi! Kaỹënanëlexi wa ɓiyi Asëñiw̃ ar Dafid!» ");
INSERT INTO bsc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ata ɓëranjëm kënëɓi xexënd eni cësina. Ɓarikan ɓën aŋo xeỹ këni kaŝ-kaŝ: «Axwën, kaỹënanëlexi ɓiyi! Kaỹënanëlexi wa ɓiyi Asëñiw̃ ar Dafid!» ");
INSERT INTO bsc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ata xwëŝa ko Yesu, w̃ac këɓi. Ga h̃at këni, w̃ëka këɓi: «Inew̃a ỹandi këŋun mun din?» ");
INSERT INTO bsc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yaka këno: «Axwën, mi ciw̃ëta ỹandi këɓo.» ");
INSERT INTO bsc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ga xaỹënan këŋo, Yesu fëɗ këɓi ala kala. And fëɗët këɓi aŋ, watëra këni ataŋ do kwël sëfa këno. ");
INSERT INTO bsc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","And hi këni Yesu gë ɓësëfan ɓërexëm ɗam gër Yerusalem aŋ, h̃at këni gër ingol ind Betëfage, ler gër etënd ed gë ɓañarëka. Aŋo law̃ën këɓi ɓësëfan ɓëxi: ");
INSERT INTO bsc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Ƴeyin gër ingol ind gër lëngw. And kën h̃at aŋ, ata kënëɓi sëk fali inëm mokap do gë ipali ler gër ndexëm. Pëtëgunëɓi ene mëlanëgu. ");
INSERT INTO bsc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Angëmëne ala w̃ëka këŋun na, yakayiɗën mëne Axwën an rek mëni mëla. Ata këŋun seɓën enëɓi mëlaw.» ");
INSERT INTO bsc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ata mondako bax ex ŋata er ỹëgw ko alaw̃ënel in: ");
INSERT INTO bsc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Pelinëɓi ɓër gër angol and Siyoŋ ɓën, Nëkoyino wa emun endewën eŋ ga ko ƴelind. Gë onënga fo ko ƴelind ƴaŋ në fali inëm, Ƴaŋ në ipali ind rëw̃ këŋo emacar end andiyen ỹëpa ko.» ");
INSERT INTO bsc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ata ɓësëfan ɓën ƴe këni, rix këni ang fel baɓi Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ga w̃ëlaw kënëɓi fali inëm in do gë ipali iŋ, laɓëra kënëɓi gë ɓanjëm. Yesu ỹëpaxën këŋo iɓat. ");
INSERT INTO bsc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Do ang ɓarërëgu bani ɓela ɓën moñëmb: mar rendëra këni ɓanjëm ɓandeɓën ɓaŋ gër fëña; ɓëjo fongëtëraw këni opat gër ɓatëx do laɓ këni fëña in tar. ");
INSERT INTO bsc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ata ga këno sëfa Yesu, ɓëjo gand lëngw, ɓëjo gand epoƴ, këno ŝëkwënd do këni xeỹënd: «Hosana, dafëlexo Asëñiw̃ ar Dafid, Ɓetalexo ga ko ƴowënd ako gë ow̃ac or Axwën ol, Wëlilexo xali ƴaŋ gër orën!» ");
INSERT INTO bsc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","And h̃at ko Yesu gër Yerusalem aŋ, angol aŋ ɗek fuli këni. Er bani w̃ëkarënd: «Noỹo ngwa hi ko ala ajo?» ");
INSERT INTO bsc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eni yaka ɓërëmar: «Yama alaw̃ënel ar këno w̃acënd Yesu an ga ex nde! Gër Nasaret xaniw ko, fëco gër ebar ed Galile.» ");
INSERT INTO bsc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","And h̃at ko gër Yerusalem aŋ, Yesu lil ko gër yangana ir Aciw̃ and Kaxanu. W̃ayëra këɓi ɗek ɓër bax fandërand do gë ɓër bax yëcërand na ɓën. Yamëra ko ɓakwëtaya ɓand ɓënëmb ɓër koɗi ɓaŋ do gë ɓañëpara ɓand ɓëfan ɓër olëxwëte ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ata fel këɓi mëne Kaxanu rek: «Aciw̃ andam aŋ and cale ex ɓarikan wën nëngwët kën emaỹi ed ɓërek.» ");
INSERT INTO bsc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na dëŋ gër yangana ir Aciw̃ and Kaxanu, h̃atëraw këni ɓëŝiw̃ëk do gë ɓëseỹik, ata fakën këɓi ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën wat këni ɗek ɓecarax ɓend ri baxo na ɓeŋ. Wël kënëɓi ɓëte oɓaŝ ol ga këni xeỹ gër yangana ir Aciw̃ and Kaxanu: «Hosana, dafëlexo Asëñiw̃ ar Dafid!» ");
INSERT INTO bsc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ata w̃ëka këno Yesu: «Këƴ wëlënd nde er këni rend oɓaŝ in?» Yaka këɓi: «Iyo aye këme wëlënd! Do wën, ba elod an pën ex na nde gër ed ỹëgw këni endam mëne oɓaŝ ol ɗek gë ɓënd gër oyer ak ayas këne yasëɗ.» ");
INSERT INTO bsc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ga yaka ko mondako, seɓ këɓi na, kwël ŝan ko angol and Yerusalem aŋ, ƴe ko gër ingol ind Betani, gër ed hi bax exo ɗakix. ");
INSERT INTO bsc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ga xeyëk, Yesu fëɗar këni enjo. Ata mopëɗ gëɓër, ga ko ɓaka gër Yerusalem, ");
INSERT INTO bsc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","wat ko andan ler gër fëña. Ga ŝapan ko, sëk ko tudëŋ opat fo. Ata re ko: «Wëj atëx aŋo ɓëte din aƴ dëw̃ na!» Andan aŋ h̃ayëk ataŋ! ");
INSERT INTO bsc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","And wat këni ɓësëfan ɓën eŋo aŋ, ŝarandëra këɓi xali do këni w̃ëkarënd: «Mondake wa h̃ayëk andan aŋo ataŋ ataŋ?» ");
INSERT INTO bsc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ata re ko Yesu: «Ɗal in këmun felënd, angëmëne axwëta xwëta këno Kaxanu gë oŋëpëgënan këm, ado etënd elo dëŋ ata kën fel: “Pacanal ro, eƴ ɗapayax gër anjer” ata facanadox etënd el, ax gi ex na eŋaỹën ed andan fo xorëdon. ");
INSERT INTO bsc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nangin mëne ɗek er kën xara yo gë ekwëta gër cale, ayakali këŋun yakali Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","And h̃at ko gër Yerusalem aŋ, Yesu lil ko gaŝëxe gër yangana ir Aciw̃ and Kaxanu. Ga këɓi sëƴalira na ɓela ɓën, h̃atëgu këni ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëxarëk ɓër Ɓëŝëwif ɓën. W̃ëka këno: «Kërëŝ wëj gë or gapak or fe këƴëɓi sëƴalixënënd ɓela ɓën? Noỹo wa yël ki or gapak olo?» ");
INSERT INTO bsc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu yaka këɓi: «Wëno ɓëte, emat fo këmun w̃ëka wën. Angëmëne ayaka yaka këne, afel këmun fel gë or gapak or fe këme rixënënd ɓeỹ ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xoɓuyi or baɓi ɓuyind ɓela Ŝaŋ Batis ol, feye wa xaniw bax? Ba gër orën nde, ba gër ɓela nde?» Ata na ɓën këni nëkënëkërand: «And këne yakaye “Gër orën”, ata këɓo w̃ëka: “Inew̃a ɓayik wën ano kwëta ex na?” ");
INSERT INTO bsc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɓëte angëmëne ene yakaye: “Ɓela ɓën law̃ënëgu baŋo”, awa yëdanëɓene ɗe amëxwër and ɓela aŋ gayik ɓën ɗek Ŝaŋ Batis, alaw̃ënel ar Kaxanu xwët këno.» ");
INSERT INTO bsc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ata yaka këno Yesu: «Ɓiyi ami nang ex na ba noỹo law̃ënëgu baŋo.» Yaka këɓi mëŋ: «Wëno ɓëte amun pel na ba gë or gapak or fe këme rixënënd ɓeŋo.» ");
INSERT INTO bsc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ata Yesu fel këɓi ɓëte: «Ɓaxëtin mun pel end ar gë oɗëmëta oki eŋ. Ga w̃ac këŋo iỹanar in fel ko: “Doro asëñiw̃ën ƴel eƴ diyenix gër andëɗa and reseŋ.” ");
INSERT INTO bsc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yaka ko: “Wëno axe ñandi ex na.” Ɓarikan, ŝena këŋo ƴe ko aƴe dëŋ. ");
INSERT INTO bsc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Fel këŋo ɓëte mondako fo lëmëta ixinëm in. Mëŋ yaka ko: “Oko ado aye këme ƴe Faba!” Ɓari axo ƴe ex na. ");
INSERT INTO bsc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gërëgako, lëmëta ir fe wa ri bax er ỹandi baŋo sëm ireɓën in?» Yaka këni: «Iỹanar in!» Ata re ko Yesu: «Ɗal in këmun felënd ɓësëf ɓër ŝagale ɓën do gë ɓësoxari ɓëỹacaxik ɓën kë h̃atët gër owun or Kaxanu, wën en ɓayi emban eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","And ƴow ko Ŝaŋ Batis eŋun masin fëña ir ŝenene aŋ, ɓësëf ɓër ŝagale ɓën do gë ɓësoxari ɓëỹacaxik ɓën fo xwëta këŋo. Ɓarikan wën ado ga nang kën aye fëña ijo, aŋun cena ex na end ola orewën eŋ gayik ano kwëta ex na.» ");
INSERT INTO bsc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ɓaxëtin mun pel apënëtal acëxe. Mondako ri baxo ala. Ga ri ko andëɗa and reseŋ, xece ko jeƴ. Nac ko ambëxw akaraxën and omen od reseŋ do ɓaƴ ko ɓëte aciw̃ atëndëndër. Na seɓënan këɓi ɓëỹan eni cetërënd gë mëŋ er këni xana in. Do ƴe ko kwël ɗamana. ");
INSERT INTO bsc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","And sëgëk reseŋ aŋ, axwën andëɗa an law̃ënëgu këɓi ɓëriyenin ɓërexëm ɓën eno mëlan oŝet orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ɓarikan ɓëỹan ɓën sëra kënëɓi ɓëriyenin ɓëjo, ŝew̃ëra këno aɓat, law̃ këno ajo do fëtëra këno aŝëxen an. ");
INSERT INTO bsc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Law̃ënëgu këɓi ɓëte ɓëriyenin ɓëŝëxe, nëmëc ang ebani ɓëỹanar ak, ɓëỹan ɓën narëndëra kënëɓi ɓëte xali. ");
INSERT INTO bsc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mondake ko ri axwën andëɗa an, afo ga felata këŋo olaw̃ën ol asëñiw̃ ga baxo yëland mëne afëɓ këno fëɓ. ");
INSERT INTO bsc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ɓarikan, ɓën and watëgu këno ga ko ƴow aŋ, këni rend: “Mëŋ ex ɗe ar kë ɓëteli andëɗa an, marawën enëŋo ɗaw̃e eɓo ɓayixën.” ");
INSERT INTO bsc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ga h̃atëgu ko lëf gër andëɗa and reseŋ, ɓëỹan ɓën ŝonjorëra këno fac-fac do law̃ëx këno. ");
INSERT INTO bsc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Awa gërëgako, and ko ƴow axwën andëɗa and reseŋ aŋ, mondake yëla kën këɓi ri ɓëỹan ɓëjo?» ");
INSERT INTO bsc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yaka këni: «E gë oxoỹ osëm ko h̃atëgu eɓi ɗaw̃ëra ɓela ɓëxeỹax ɓëjo do eɓi teɓënan andëɗa and reseŋ aŋ ɓëỹan ɓëŝëxe, ɓër këŋo ỹana eŋo cetënd aŝet reseŋ in and kë sëg aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na rew ko Yesu: «Awa do wën elod an pën ex na nde Oñëgw Omënëk od rek: “Ekaỹ ed ŝus bani ɓëɓaƴ ɓër aciw̃ el, Ɓakan ko Kaxanu xali hik ekël ed aciw̃ el. Gër Axwën xaniwëk eŋo, Do ɓiyi ɓon këɓo ŝaranënd.” ");
INSERT INTO bsc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mëŋ këmun felaxënënd mëne Kaxanu axan këŋun xan owun or gër orën ol wën Ɓëŝëwif ɓën do eɓi teɓënan enëng end ɓër ax gi ex na Ɓëŝëwif eni ɗëkaya ang ỹandi këŋo ak. ");
INSERT INTO bsc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ekaỹ ed këme rend elo, ar këŋo wëcan an ɓënd-ɓënd ko hi, Ar kë wëcan an, exo gi rongo-rongo Ɓëte ar këŋo wëcan an, momot këŋo ɓot.» ");
INSERT INTO bsc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ga wël këni ɓapënëtal ɓaŋo, ɓëŝaɗaxan ɓëlëngw ɓën do gë ofariseŋ ok fëni këɓi mëne Yesu ɓën dëŋ baɓi rend. ");
INSERT INTO bsc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɗek ỹandi baɓi eno tëra. Ɓarikan amëxwër aŋ banëɓi yëdand gayik ɓëranjëm alaw̃ënel ar Kaxanu xwët bano Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ga xucak eŋo, Yesu këɓi felërand ɓëte gë ɓapënëtal, ko rend: ");
INSERT INTO bsc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Owun or gër orën ol er wëndërëk gë endeƴ end emun end rin baŋo ekana asëñiw̃ fo. ");
INSERT INTO bsc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Law̃ën këɓi ɓëriyenin ɓën enëɓi ƴen ɓër fel baɓi eni ƴowëraw gër ofëna ɓën. Ɓari ɓën h̃ëp këni eni ƴow. ");
INSERT INTO bsc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Law̃ën këɓi ɓëte ɓëriyenin ɓëŝëxe, enëɓi pelëx: “Ogaŝ odam ok do gë opërac odam ok h̃aŝ këmëni anëka ỹënëk ỹas eŋ, wën fo ŝëni këmun.” ");
INSERT INTO bsc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ɓari ɓër fel baɓi eni ƴowëraw ɓën aɓi ɓal bana eŋo. Fecan këɓi eni tëf ɓendeɓën, kwël ŝapër këni: ajo gër oŝënga, ajo gër opane odexëm. ");
INSERT INTO bsc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɓër ɓayi bax na ɓën sëra kënëɓi ɓëriyenin ɓën, xëmëra kënëɓi xali law̃ kënëɓi. ");
INSERT INTO bsc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ga xoỹ ko emun eŋ, law̃ën këɓi ocoroɗa odexëm ok enëɓi ɗaw̃ëra ɓela ɓëjo do eni cor angol andeɓën aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ata emun eŋ fel këɓi ɓëriyenin ɓën: “Ecemar ed ofëna ol, anëka feyëtëra këni, ɓari ɓër fel bamëni eni ƴow ɓën aɓi ñap bana. ");
INSERT INTO bsc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gërëgako ƴeyin gër angol, gër opëña od këni ỹëmbënd ɓela. Gë ar kën fed yo macëguɗëno.” ");
INSERT INTO bsc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɓëriyenin ɓën ŝapër këni gër angol, ed opëña el. Do gë ar fed këni yo, hi ko asëmbak, hi ko ar ŝenene, w̃ac kënëɓi gër ofëna. Ata mondako fëxw bani gër aciw̃ and ofëna. ");
INSERT INTO bsc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ga lilëgu ko emun eŋ eɓi nëkon ɓër w̃acëgu kënëɓi ɓën, wat këŋo ar ɓayik ax cuɗa bana anjëm and ofëna. ");
INSERT INTO bsc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","W̃ëka këŋo: “Lawo, mondake wa lilëgu këƴ ro gë acuɗ and ofëna këm.” Ata ala ajo ŝësinan këŋo ƴem. ");
INSERT INTO bsc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Emun eŋ fel këɓi ɓëriyenin ɓërexëm ɓën: “Kapin osapar oŋ do gë otaxan ok eno yayaxën fac gër ecamëɗan. Tesëxëlexo, ŋatayaxëlexo eɓasa el.”» ");
INSERT INTO bsc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ga h̃ata ko Yesu apënëtal aŋo, re ko ɓëte: «Enimin, ɓëranjëm exëni ɓër w̃ac këɓi Kaxanu ɓën. Ɓarikan tëkër fo exëni ɓër sana këɓi ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ata ofariseŋ ok w̃acër këni eni cala endeƴ end këno w̃ëka Yesu eno ɓonaxën. ");
INSERT INTO bsc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ga ŝot këni, law̃ën kënëɓi ɓësëfan ɓëreɓën ɓën do gë od Erod gër Yesu. Ga h̃at këni re këni: «Asëƴali, anang nang këmi mëne wëj end ɗal fo këƴ reƴand. Enimin, fëña ir Kaxanu in këƴëɓi w̃asinënd ɓela ɓën. Ala aƴo yëdand na, ɓëte aƴo nëkonënd na ala an ba noỹo hi ko eƴo pelëraxën. ");
INSERT INTO bsc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gërëgako, pelëlëɓo er yëla këƴ gër endeƴ eŋo in: Aỹap nde ỹapëk ŝagale ir ko w̃ëkand Sesar in? Mi meɗënd nde, ba mi teɓ emeɗ el nde?» ");
INSERT INTO bsc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ga wata ko Yesu osit oreɓën ol, yaka këɓi: «Wën ɓëỹëŋënax ɓër kë laɓayand hi kën, inew̃a ỹandixën këŋun ene ɓon? ");
INSERT INTO bsc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Masinine koɗi ir kën w̃eɗaxënënd ŝagale in.» Ata fëxwën këno atama amat. ");
INSERT INTO bsc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ga nëkon ko, w̃ëka këɓi ɓër xeta baŋo ɓën: «Dëxas in ir noỹo wa ex?» Yaka këno: «Ir Sesar.» «Do ow̃ac ol cëŋ?» ");
INSERT INTO bsc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yaka këno ɓëte: «Orexëm fo ex.» Ata re ko: «Maŝino Sesar erexëm in, do Kaxanu er xwën ko in.» ");
INSERT INTO bsc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ata ga ŝaran këɓi ang yaka ko ak, kwël ŝapër këni aɓat aɓat. ");
INSERT INTO bsc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kwël yatijo fo, Osaduseŋ ƴow këni ɓëte gër Yesu. Ɓën ex ɓër bax yëland mëne ekani ed gër ecës ax gi ex na. Ata re këni: ");
INSERT INTO bsc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Asëƴali, ɓaxëtël er fel këɓo Moyis in. Angëmëne asoŝan exo cës teɓëtarëxe oɓaŝ, aɓinëm këŋo ɓëteli asoxari an, eŋo dëw̃ënaxën oɓaŝ ar nemik an. ");
INSERT INTO bsc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Xarak, gër ndeɓi ro ocambenjar ocongoki hi baxëna aminëmëra. Iỹanar in ỹër ko, ɓari ŝës ko oɓaŝ këm. Aɓinëm ɓëteli këŋo asoxari ar seɓëta këŋo an. ");
INSERT INTO bsc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nemi ko mëŋ ɓëte oɓaŝ këm. Ako fo hi baɓi ɓën ɓëcongëɓëxi ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga faỹëra këni ɓën ɗek, ŝës ko ɓëte asoxari an. ");
INSERT INTO bsc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Do yatir ekani ed ɓëŝësëk cëŋ, alindaw̃ ar noỹo w̃a ko hi gayikako ɓën ɗek ɓëcongëɓëxi ɓën aỹër ỹër bano?» ");
INSERT INTO bsc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yaka këɓi Yesu: «Wën ata and kën lifënd dëŋ ex ɗe. Aŋun pëni ex na Oñëgw Omënëk ok, ɓëte an nang ex na panga ind Kaxanu iŋ. ");
INSERT INTO bsc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","An nang ex na nde mëne yatir ekani ed ɓëŝësëk, eñër ax gi na? Ɓësoŝan ɓën do gë ɓësoxari ɓën ang omeleka fo këni hi ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","End ekani ed gër ecës eŋ, elod an pën ex na nde er fel këŋun Kaxanu in? Ga re ko: ");
INSERT INTO bsc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Wëno ex Kaxanu, ar yata këŋo Abëraxam an, wëno ex Kaxanu, ar yata këŋo Isak an, ɓëte wëno ex Kaxanu, ar yata këŋo Yakob an.”» Ata re ko ɓëte Yesu: «Awa eŋo w̃asinëdoŋun mëne Kaxanu, Kaxanu ir ɓëɓëngw exo, axo gi ex na ir ɓëŝësëk.» ");
INSERT INTO bsc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ata ɗek ɓër baŋo ɓaxët ɓën, ŝaran këɓi end osëƴali orexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","And wël këni ofariseŋ ok mëne Yesu aɓon ɓon këɓi ɓëte Osaduseŋ ok, fedër këni. ");
INSERT INTO bsc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ata ga ỹandi këɓi eno ɓon Yesu sana këno asëƴali ar acariya and Moyis eŋo mëkara. Ga sëka këŋo w̃ëka këŋo: ");
INSERT INTO bsc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Asëƴali, apela and fe ex anëngw aŋ gër acariya and Moyis?» ");
INSERT INTO bsc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yaka ko Yesu: «“Ŋanëlo Kaxanu, Axwën areƴ an, gë yomb ireƴ ak ɗek, gë enjëw̃ endeƴ ak ɗek, gë anjëlan andeƴ ak ɗek.” ");
INSERT INTO bsc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Apela aŋo ex and xucak ɗek aŋ, mëŋ ex anëngw aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɓaxëtël and ɓëtëk aŋ: “Ɓalindëlexi end aŝandax eŋ ang ki ɓalënd end gaf ireƴ ak.” ");
INSERT INTO bsc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Acariya and Moyis aŋ ɗek do gë osëƴali or ɓëlaw̃ënel ɓër Kaxanu ol ɗek, gër ɓapela ɓaki ɓaŋo ex.» ");
INSERT INTO bsc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Gër ed ɓarër bani ofariseŋ, Yesu w̃ëka këɓi endeƴ eŋo: ");
INSERT INTO bsc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ake yëla kën end Afexën eŋ? Ar andëw̃ëra and noỹo hi ko?» Yaka këno: «Oko, ar andëw̃ëra and Dafid!» ");
INSERT INTO bsc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ata re ko ɓëte Yesu: «Ga ỹëm ko gë panga ind Angoc Amënëk iŋ, Dafid baŋo w̃acënd Afexën an, Axwën arexëm and baxo rend: ");
INSERT INTO bsc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Axwën an fel këŋo Axwën aram an. Ñëpal gand liw̃ iram ro, xali mi korën ɓërangoỹëra and gë wëj ɓën xali eƴëɓi bëña.” ");
INSERT INTO bsc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gayikako Dafid mëŋ dëŋ këŋo w̃acënd Afexën an, Axwën arexëm, mondake cëŋ hi ko Asëñiw̃ arexëm?» ");
INSERT INTO bsc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɓari gaɓatak ax kor bana eŋo yaka. Ata elod yatijo ala bax yëxw na eŋo mëka ỹeỹ. ");
INSERT INTO bsc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Akey amat, Yesu baɓi felërand amëxwër aŋ gë ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ata ko rend: «Ɓëŝalen ɓën gë ofariseŋ ok ɓëtëk gër añëpara and Moyis do kënëɓi sëƴalind ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mëŋ ex, mayindën ang kënun sëƴalind ak. Ɓëte tëfindën er kënun felënd in. Ɓari kërenëɓi tëfëtelind na ang këni rind ak. Ɓën ani dind na er këni sëƴalind in. ");
INSERT INTO bsc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ang ɓër këɓi liɓënënd ɓonëɓ ɓotiɓax ɓela fo hi këni xarak ɓën gë tëkërak anëɓi dëcand na. ");
INSERT INTO bsc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Enëɓi kwitaxënënd ɓela ɓën, imboto këni fugand gër eƴiỹ, do këni ŝuɗand ɓocuɗ ɓond gë oñaŋën. ");
INSERT INTO bsc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mbaŋ h̃an këni eƴe ed në er hik ñambëran el do gë eketëna ed axwën ofëna el. Mbaŋ h̃an këni ɓañëpara ɓand gër lëngw ɓaŋ gër ɓaciw̃ ɓacaleya. Ɓëte gër ed këni ỹëpara mbaŋ këɓi nënganënd enëɓi cëmarand ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɓëte mbaŋ këɓi nënganënd enëɓi macënd “asëƴali.” ");
INSERT INTO bsc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ɓarikan wën këren mand na enun mac “asëƴali.” Asëƴali arewën an aɓat fo ex, do wën ɗek aminëmëra hi kën. ");
INSERT INTO bsc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Do ala këreno macënd na “Faba” gër ebar, gayikwa aɓat fo ex Sorix irewën, Faba ir ƴaŋ gër orën in. ");
INSERT INTO bsc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Këren mand na enun mac alëngw. Wëno Afexën an gaɓat fo hik alëngw arewën an. ");
INSERT INTO bsc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Alëngw arewën an gilexo ariyenin arewën. ");
INSERT INTO bsc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ar kë rafëna an, Kaxanu alat këŋo lat, do ar w̃ak eno bëña an, Kaxanu arafën këŋo rafën.» ");
INSERT INTO bsc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesu ŝom ko: «Wën ɓëŝalen ɓën gë ofariseŋ ok, ɓëỹëŋënax ɓër kë laɓayand hi kën, ata mbaŋ w̃e këŋun. Ebët ed owun or gër orën el kën weɗind. Wën dëŋ an ɗilënd na, ɓëte anëɓi teɓënd na eni ɗil ɓër ỹandi këɓi ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Wën ɓëŝalen ɓën gë Ofariseŋ ok, ɓëỹëŋënax ɓër kë laɓayand hi kën, mbaŋ w̃e këŋun! Wën këɓi ƴambarand ɓësoxari ɓëseɓëta seɓëta ɓën. Ɓëte wën fo watak aŝale, aŝale, aŝale, mëŋ ex kiti indewën iŋ gë pit fo kë ƴëka. ");
INSERT INTO bsc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Aw̃e w̃e këŋun wën ɓëŝalen ɓën do gë ofariseŋ ok, wën ɓër ex ɓëỹëŋënax ɓër kë laɓayand ɓën! Angwëngw and ex yo kën xegëtand, gër ed ex yo gër ebar kën hërënd eno ɗënaxën ala gër cale indewën. Do ala ajo and ko hi aŝalek aŋ, eno di ɓakëlëbëd ɓaki ar gër xoɗux, ar w̃enak nëmëc wën. ");
INSERT INTO bsc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ata mbaŋ w̃e këŋun wën ɓër këɓi lëngwelind ɓela ɓën, xarak ɓëŝiw̃ëk en, ɓëỹëŋënax ɓër kë laɓayand hi kën! Wën këɓi felënd ɓela ɓën mëne ala exo yaŝaranënd Aciw̃ and Kaxanu aŋ, xarak axo di ex na er re ko in, oŝëɓa aŋo ɗëk na. Ɓari angëmëne exo yaŝaranënd kaŋe ir lëf in, xarak axo di ex na er re ko in, alëk këŋo lëk oŝëɓa ol. ");
INSERT INTO bsc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ata and an yëlarand na ex ɗe! Inew̃a xurik ex këɓën: kaŋe in nde, ba Aciw̃ and Kaxanu aŋ nde, mëŋ ar kë w̃ënënënd kaŋe an? ");
INSERT INTO bsc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wën këɓi felënd ɓëte ɓela ɓën mëne ala exo yaŝaranënd angëɓ aŋ xarak axo di ex na er re ko in, ỹow̃eỹ aŋo gi na. Ɓari exo yaŝaranënd ŝaɗaxa ir ex ƴaŋ gër angëɓ in, xarak axo di ex na er re ko in, alëk këŋo lëk oŝëɓa ol. ");
INSERT INTO bsc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ata and an yëlarand na ex ɗe! Inew̃a xucak ex këɓën: ba ŝaɗaxa in nde? Ba angëɓ aŋ nde mëŋ ar kë w̃ënënënd ŝaɗaxa an? ");
INSERT INTO bsc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ar kë yaŝaran angëɓ an, anëka yaŝaran ko ɗek gë er ex ƴaŋ gër angëɓ in. ");
INSERT INTO bsc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ar kë yaŝaran Aciw̃ and Kaxanu an, anëka yaŝaran këŋo Kaxanu mëŋ ar lëgëk na an. ");
INSERT INTO bsc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ar kë yaŝaran orën an, anëka yaŝaran ko añëpara and owun or gër orën aŋ do gë Kaxanu mëŋ ar ỹëpaxënëk an. ");
INSERT INTO bsc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Wën ɓëŝalen ɓën, gë ofariseŋ ok, ɓëỹëŋënax ɓër kë laɓayand hi kën, ata mbaŋ w̃e këŋun! Emeɗ ed dim el aye yek: hik ir esëngëng, hik ir eỹamën, hik ir ongën. Ɓarikan, ola or ŝenene ol, gë axaỹënan in, do gë egi ed ala axwëta xwëta el lëngwëk gër acariya and Moyis. Ɓeŋo doŋun ɓal nëmëc xarak an teɓ ex na emeɗ ed dim el. ");
INSERT INTO bsc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wën ɓëlëngweli ɓëŝiw̃ëk hi kën! Mondake këno hëlënd yer gelemba in, do këno sëpënd eñoŋën eŋ? ");
INSERT INTO bsc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Wën ɓëŝalen ɓën gë Ofariseŋ ok, ɓëỹëŋënax ɓër kë laɓayand hi kën, ata mbaŋ w̃e këŋun! Odëƴamb odewën ok kën w̃ënënënd fac fac in, xarak ed lëf lëf el ɗek ɓuyarëk. Gër ow̃ëkw orewën er xëñëk: orek do gë oñandi oñëŋënax. ");
INSERT INTO bsc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wëj fariseŋ ijo, ang aŝiw̃ëk fo hi këƴ! Neɓël pere odëƴamb ok ed lëf lëf el ɗamana eƴ mënënaxën ed fac fac el! ");
INSERT INTO bsc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wën ɓëŝalen ɓën, gë ofariseŋ ok, ɓëỹëŋënax ɓër kë laɓayand hi kën, ata mbaŋ w̃e këŋun! Ang oñeg od feŝën këni fo fac fac in hi kën. Ɓarikan, polo oŝapar owërëk do ɗek oɓuyaraxik fo fëxwëk. ");
INSERT INTO bsc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ata wën, mondako hi kën: gër ogës od ɓela ang ɓër ŝenene fo xarak ɓëỹëŋënax ɓër kë laɓayand hi kën. Yer ɓetëmbak fo hi kën. ");
INSERT INTO bsc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Wën ɓëŝalen ɓën, gë ofariseŋ ok, ɓëỹëŋënax ɓër kë laɓayand hi kën, ata mbaŋ w̃e këŋun. Wën dëŋ kë ɓaƴënd ɓañeg ɓand ɓëlaw̃ënel ɓër Kaxanu ɓaŋ. Wën kë ỹaŋënënd ɓëte ɓañeg ɓand ɓër ŝenene ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ɓëte wën fo kë rafënand mëne kido angwën and ɓëxarëk ɓërewën aŋ hi ban, an ɓar dona gë ɓën gër eɗaw̃ ed ɓëlaw̃ënel ɓër Kaxanu ɓëjo. ");
INSERT INTO bsc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wën dëŋ kë reƴand osede or këŋun lëxwënd ol ga kën rend ako mëne wën ex oɓaŝ or ɓër law̃ këɓi ɓëlaw̃ënel ɓër Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ata kemënayin ɗe en mendëra, ɓaŝin xali ex dëmbuca eñëŋënax end ɓëxarëk ɓërewën eŋ! ");
INSERT INTO bsc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ata wën ang ɓandën fo hi kën, ang otaw̃-orang fo hi kën! Mondake kën xwëỹëta kiti ind gë xoɗux iŋ? ");
INSERT INTO bsc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mëŋ ex, wëno alaw̃ëneli law̃ëneliw këmun: ɓëlaw̃ënel, gë ɓërenik, do gë ɓëŝalen. Ɓarikan wën, mar alaw̃ kënëɓi law̃, mar fika kënëɓi, mar xëmëra kënëɓi xali gër ɓaciw̃ ɓacaleya ɓandewën, do mar narëndëra kënëɓi xali. Gë angol gë angol kënëɓi ỹana enëɓi tëfërand. ");
INSERT INTO bsc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ata wën awëcan këŋun wëcan kiti iŋ në end oŝat or lexik gër ebar eŋ. Anëp këŋun nëp në end oŝat oŋo. Ga ỹana ỹana ko gër oŝat or Abel, ar ŝenene an, Kaxanu ɗek ko sëf xali gër or Sakari, asëñiw̃ ar Berekiya an, ar law̃ këno fëco angëɓ fëco ebët, lëf gër yangana ir Aciw̃ and Kaxanu an. ");
INSERT INTO bsc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ɗal in këmun felënd, wën ɓela ɓër gë okey oko ɓëjo dëŋ këŋun wëcan ɗek ɓeŋo.» ");
INSERT INTO bsc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«E Ɓëyerusalem, wën këɓi law̃ënd ɓëlaw̃ënel ɓër Kaxanu ɓën. Wën fo këɓi fëtërand gë oxaỹ xali eni cës ɗek ɓër këŋun law̃ëneliwënd ɓën. Wëno ɓandanjëm xacëra ke mun ɓar ang këɓi ɓarënd ecare oɓaŝ orexëm ɗila gër obafe odexëm ak. Ɓari wën an ma ex na. ");
INSERT INTO bsc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ata në eŋo ko ỹaŋëtaxën Kaxanu Aciw̃ andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ga re këme, doro fela këne ewat el xali yatir kën re: “Ɓetalexo ar kë ƴowënd gë ow̃ac or Axwën an!”» ");
INSERT INTO bsc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ata Yesu ga ko ŝan gër Aciw̃ and Kaxanu, ɓësëfan ɓërexëm ɓën re këni: «Asëƴali, nëkonël ɓameŋ ɓand ɓongaỹ ɓaŋ ang yëlëra këni ak, monje yek ɗe.» ");
INSERT INTO bsc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu yaka këɓi: «Ɗal in këmun felënd, ɓameŋ ɓand kën watënd ɓaŋo, ɗek kë yëcar; ekaỹ geɓatak ax ɓayi na eyëlëtërëx!» ");
INSERT INTO bsc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ga h̃at këni gër etënd ed gë ɓañarëka, Yesu ỹëpa ko. Ata ga xeta këno ɓësëfan ɓën, w̃ëka këno: «Asëƴali, pelëlëɓo ba nand fe kë yëcar Aciw̃ and Kaxanu aŋ? Ine këɓo w̃asin mëne anëka kë saxëgund eɓakaw edeƴ el do gë ekwët ed ngwën el?» ");
INSERT INTO bsc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ata Yesu yaka këɓi: «Diyindën gë onden oŋ, ala këreŋun yifaɗ na xali en ma endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ɓela ɓëranjëm kë ƴowëraw gë ow̃ac oram ol do eni dend: “Wëno ex Afexën an.” Ata mondako kënëɓi yifa ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ado awël kën ỹana en wëlënd ow̃er or kë fët gër owar oŋ. Mongwël dëŋ kën ỹana en wëlënd eɗandër el. Ɓari këreŋun dëgënëɗ na! Afo ex kuca pere ɓeŋo, xarak ax gi ex na pere ekwët ed ngwën el. ");
INSERT INTO bsc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Er këɓi ỹana eɓi takërërand ɓela ɓën gë enëng gë enëng, do gë ebar gë ebar. Në ed mar enjo etëm këɓi ỹana eɓi wëcanënd. Ɓëte në ed mar, ebar el kë ỹana ex dëgënd. ");
INSERT INTO bsc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","And kë xuca ɗek ɓeŋo aŋ, nangin mëne aỹana fo ỹanak toro iŋ. ");
INSERT INTO bsc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ata alëxw kënun ỹana enun ɗëxwënd në er kën soro, ɓëte alaw̃ kënun ỹana ɗaw̃ënd. Ɗek ɓenëng ɓend ɓela ɓeŋ kënun ŝusëra në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ɓërëmar gër enga endewën, and këni ỹana eni watënd ɓeŋo ɗek aŋ ah̃ëpëgënan këɓi ỹana eɓi ŋëpëgënanënd endam eŋ. Do ɓëranjëm kë ỹana ex yifarënd, ɓëranjëm kë ỹana ex cusërënd në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɓëlaw̃ënel ɓënëgwëŝ ɓëranjëm kë ŝanayaw na do enëɓi yifand ɓela ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mbaŋ kë ỹëmb eñëŋënax eŋ gër ngwën ro, ata gër ow̃ëkw or ɓela ɓëranjëm aŋana aŋ aɓaŝëta kë ɓaŝëta. ");
INSERT INTO bsc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ɓarikan, ar kë xemëna xali yatir kë xwët endexëm an, afex ko fex. ");
INSERT INTO bsc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Atëfëtan and owun or Kaxanu aŋ afem kë hi mopem ɗek ebar el do gër ed ex yo. Mondako kë hixën osede gër ɓenëng ɓend ɓela. Ata amëd aŋo fo kë xwët ngwën iŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Mëŋ ex and këno watënd aw̃endëran aŝaraxik ar reƴa baxo alaw̃ënel Daniyel mëne aƴow ko ƴow aŋ, lëf gër ed ŝëɓak, awa pënileŋo aye ar kë fënënd akayëta aŋo an. ");
INSERT INTO bsc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mëŋ ex, ɓër lëgëk gër ebar ed Yude ɓën gërëxëɗëlexëni gand osënd. ");
INSERT INTO bsc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɓëte ar kë hi ƴaŋ në ejur ed këɓe an, gërëlexo. Kërexo pedan na ỹeỹ lëf. ");
INSERT INTO bsc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ar kë hi gër oŝënga an, gërëxëlexo. Kërexo ɓakan na ɓanjëm ɓandexëm gër iciw̃. ");
INSERT INTO bsc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Awa amëd aŋo, mbaŋ këni soro ɓësoxari ɓër gë ɓacël ɓën do gë ɓër këɓi yerinënd oɓaŝ ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mëŋ ex caleyindën kërex ŋatëgu na ongër ondewën oŋ amëd and gë aƴem, ba gë akey and eteyëta. ");
INSERT INTO bsc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ata ɓakey ɓand toro itëm kë hi. Elod ga ri ko Kaxanu ngwën iŋ ala ax wat ex na toro indako rako iŋ, ɓëte din ala ax wat na. ");
INSERT INTO bsc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kaxanu aɓaŝëta ko ɓaŝëta ɓakey ɓand toro ɓaŋo, në end ɓela ɓër sana këɓi eŋ. Angëmëne axo ɓaŝëta ex na, ala ax pex na. ");
INSERT INTO bsc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Angëmëne ala eŋun pelënd: “Nëkoɗo ro Afexën an!” ba “Fën exo Afexën an”, këreno kwëta na. ");
INSERT INTO bsc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ɓëlaw̃ënel ɓënëgwëŝ kë ŝanayaw na do eni dend mëne ɓëfexën hi këni. Ari këni ỹana eni dind ɓecarax enëɓi yifaxënënd ɓela ɓën. Kido mokam, ado ɓër sana këmëni wëno ɓën dëŋ ayifa yifa donëɓi. ");
INSERT INTO bsc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Awa ɗamana ex ŋatëgu toro iŋo këmun nangënënd ɓeŋo. ");
INSERT INTO bsc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","And kënun fel mëne Afexën an gër ladawe watëgu këno aŋ, këren ƴeɗ na. Ba enun pel mëne lëf gër ɓaciw̃ ɓanakaya exo, këreno kwëta na. ");
INSERT INTO bsc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Enimin ga re këme, ang kën watënd ebingara el cangët orën ak, mondako këne watëɗ wëno Asëñiw̃ ar ala an yatir këme ɓakaw. ");
INSERT INTO bsc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ax gi ex na nde gër ed ex embër këni ɓarërënd oyafe ol? Mëŋ ex yatir këme ɓakaw, ala ax nem na.» ");
INSERT INTO bsc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ata re ko ɓëte Yesu: «And kë xuca ɓakey ɓand toro ɓaŋo: eñan eŋ aw̃ëɗëw̃ëɗa kë w̃ëɗëw̃ëɗa, facaw̃ in aloɓ kë loɓ, ow̃al oŋ axwëcëta kë ỹana ex kwëcëtand do ɗek ɓeɓër gë panga gër orën ɓën kë sëngërëɓëtara. ");
INSERT INTO bsc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ata amatinali and wëno asëñiw̃ ar ala aŋ aŝanaya kë ŝanaya ƴaŋ gër orën. Do ɓenëng ɓend ɓela ɓeŋ ɗek gër ebar ro kë ỹana ex denitand në end wëno asëñiw̃ ar ala eŋ. Awat këne watëgu gër orën ga këme ŝëlaw gë ɓaŋar ɓaŋ, gë panga iŋ do gë enjaran etëm. ");
INSERT INTO bsc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Meleka kë farix na kereloŋ, and këni wël ocandaw̃ aŋ enëɓi ɓar ɓër yata këmëni ɓën beɓët yo beɓët ir orën, ebar el ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mayin eŋun tëƴali apënëtal and andan aŋ. Ax gi ex na nde and kë nëtënd oɗini aŋ kën nangënd mëne ɗam ex ecaŝa el? ");
INSERT INTO bsc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɓëte wën and kën wat ɗek ɓeŋo aŋ, nangin mëne wëno Asëñiw̃ ar ala an gogo këme ɓakaw, ado gër ebët hi këme. ");
INSERT INTO bsc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ɗal in këmun felënd, an cësëra na ɗek ex ñana toro ind këmun felënd aƴow kë ƴow iŋo. ");
INSERT INTO bsc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Orën ol gë ebar el axuca kë xuca, ɓarikan eyeƴan edam el laŋ kë ɓayi.» ");
INSERT INTO bsc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ata Yesu re ko ɓëte: «End akey eŋ do gë end apëxëd and këme ɓakaw eŋ, ala gaɓatak ax nang ex na: ax gi ex na omeleka od gër orën ok, ax gi ex na wëno Asëñiw̃ ar ala an. Faba Kaxanu gaɓat nangëk. ");
INSERT INTO bsc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ang fënga baɓi ampumbuluỹët aŋ ɓela ɓën angwën and ebaxo Nowe ak, mondako fo këmëni fënga ɓëte wëno Asëñiw̃ ar ala an, yatir këme ɓakaw. ");
INSERT INTO bsc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ɗamana ex ƴow ampumbuluỹët aŋo, ɓela ɓën er xwënda bani: ñambëran, gë oŝeɓ, gë oỹër, do gë eñërëndër ed oɓaŝ oreɓën, xali yatir lil ko Nowe gër akuluŋ. ");
INSERT INTO bsc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ỹoweỹ abani yëla na xali h̃atëguk ampumbuluỹët ga sëɓëk tëɓ itëm, ỹëmeli këɓi kwëc ebar el ɗek. Ata nemira këni ɗek ang ebani ak. Ako fo këɓi ɓët yatir këme ɓakaw wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɓela ɓëxi eni ñandërand në oŝënga, aɓat këmo w̃ëla, mo teɓ ajo. ");
INSERT INTO bsc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Në er këni sëŋërand ɓësoxari ɓëxi, aɓat mo w̃ëla, ajo mo teɓ. ");
INSERT INTO bsc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mëŋ ex, titinayin gayik an nang ex na yatir këme ɓakaw wëno Axwën arewën an. ");
INSERT INTO bsc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aye fëni këŋun mëne axwën iciw̃ an, exo nangënd nand ko ƴow arek na, afer na ko ferëna. Aŋo teɓ na exo tënga iciw̃ indexëm iŋ. ");
INSERT INTO bsc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ga re këme, wën ɓëte giyindën ɓëw̃elëk key yo key gayik wëno Asëñiw̃ ar ala an, and ɓayik an yëland na aɓaka këme ɓakaw aŋ këme ŝanayaw.» ");
INSERT INTO bsc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ata Yesu ɓaŝ ko eyeƴan el re ko: «Xaɗëp ir fe wa hik irenik ir xwëta këŋo axwën arexëm xali seɓënan këŋo andiyen and eɓi ɗëɓand ɓër ekun endexëm ɓën nand ỹapëk na? ");
INSERT INTO bsc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Awa xaɗëp ijo nëngandëraleŋo angëmëne axwën arexëm an asëk sëk këŋo ga ko ri er fel baŋo exo dind in. ");
INSERT INTO bsc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ɗal in këmun felënd, axwën ar xaɗëp ijo an aseɓënan këŋo seɓënan ɗek acota andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ɓarikan angëmëne xaɗëp ir gë emëkw etëmbak exo, ata ko re: “Axwën aram an ɗek nëkaw ko.” ");
INSERT INTO bsc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ata ko xwënda ekëm ed ɓoŝandaw̃, ñambëran do gë oŝeɓ. ");
INSERT INTO bsc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Axwën an aw̃aỹiw ko w̃aỹiw eŋo pënga xaɗëp ijo gë akey and axo yëla bana aɓaka ko ɓakaw aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ata ɗamana eŋo ɗapaxën fac, mbaŋ këŋo ŝëndën ang këɓi ŝëndën Kaxanu ɗek ɓëỹëŋënax ɓër kë laɓayand ak. Fac ko ỹana exo tesëxënd do exo ŋatayaxënd eɓasa el.» ");
INSERT INTO bsc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ata owun or gër orën ol er wëndërëk gë endeƴ end odënaw̃ oɓeja epëxw od w̃eɗ bax oɗambo odeɓën ok eno kacaxën ŝambenjar ir bax ỹërënd fo. ");
INSERT INTO bsc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Odënaw̃ oko er hi bani oco opënirëx do oco od ŝëɗëta baɓi. ");
INSERT INTO bsc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","And bani ƴend gër ekaca aŋ, odënaw̃ opënirëx ok w̃eɗ këni oɗambo odeɓën ok penarëxe ogu ond këni ɓaŝëɗ oŋ. ");
INSERT INTO bsc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ɓarikan odënaw̃ odenik ok fena këni ogu oŋ në ocëlakuŋ. ");
INSERT INTO bsc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ga w̃ëɗeliw këŋo icën iŋ, raŝëra këɓi aɓat aɓat ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Emëɗ ekarëk el, xeỹ ko ala: “Icën iŋ në eŋatëgu exo! Icën iŋ, në eŋatëgu exo! Marayin eno kaca!” ");
INSERT INTO bsc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aŋo nëngëtara këni ɗek odënaw̃ oɓeja ok. Xanira këni ala kala exo nëkon lambo irexëm in. ");
INSERT INTO bsc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ata odënaw̃ opënirëx ok xara kënëɓi od ŝëɗëta baɓi ok: “Cetinëɓo wa tëkër ogu ondewën oŋ, në eɗomi ex oɗambo odeɓi ok.” ");
INSERT INTO bsc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yaka kënëɓi: “Ali aɓo gi na gwac! Ƴeyin en yëcëgu gër ɓëfan.” ");
INSERT INTO bsc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","And ƴe këni aŋ, h̃atëgu ko icën iŋ, odënaw̃ od w̃el bax ok lilëx këni gë mëŋ gër aciw̃ and ofëna do kwël ŝoke këni ebët el. ");
INSERT INTO bsc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Ga nëkanak, odënaw̃ oɓeja od ƴe bax eni yëcëgu ogu ok, h̃atëgu këni do këni w̃acënd gër ebët: “Axwën, Axwën, përëtënëlëɓo!” ");
INSERT INTO bsc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ɓari ŝambenjar ir bax ỹërënd in yakaw këɓi lëf: “Ɗal in këmun felënd, wëno amun nang ex na.”» ");
INSERT INTO bsc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ata ga h̃ata ko Yesu apënëtal aŋo, re ko ɓëte: «Mëŋ ex, wën ɓëte titinayin gayikako an nang ex na akey aŋ do gë apëxëd and këme ɓakaw aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ɓëte ata kë hi ang endeƴ end ala ar ƴe bax ɗamana fo. Ɗamana exo ƴexën w̃ac këɓi ɓëriyenin ɓërexëm ɓën do seɓënan këɓi napul irexëm in eni cënan. ");
INSERT INTO bsc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Er yëlëra baɓi: aỹanar an, okilo oco od kaŋe; axinëm an, okilo oki do asasën an, kilo iɓat. Er hi bax ala kala exo cënan er fëxwën këno in gë oxor orexëm ol. And ri ko mondako aŋ, ala ajo ƴe ko kwël. ");
INSERT INTO bsc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ataŋ ar fëxwën baŋo okilo oco an, ƴe ko gër andiyen. Ŝënan ko kaŋe ir fëxwën baŋo axwën arexëm in, ŝot ko okilo oco ocëxe. ");
INSERT INTO bsc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ɓëte ar fëxwën baŋo okilo oki an, ŝot ko okilo oki ocëxe. ");
INSERT INTO bsc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ɓarikan ar fëxwën baŋo kilo iɓat an, ƴe ko nac ko ambëxw gër ebar, do wëg ko kaŋe ir axwën arexëm in. ");
INSERT INTO bsc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Ga nëkak, axwën ar ɓëriyenin an, w̃aỹiw ko. Ata w̃ac këɓi ɓëriyenin ɓërexëm ɓën eno pelëra ala kala ba mondake ŝënan ko kaŋe ir seɓënan baŋo in. ");
INSERT INTO bsc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ar fëxwën baŋo okilo oco an h̃atëgu ko gë okilo oco ocëxe, re ko: “Axwën, okilo oco seɓënan baƴe. Nëkoɗa ga ŝotëli këme okilo oco ocëxe.” ");
INSERT INTO bsc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Axwën arexëm an yaka ko: “Yo wëj ariyenin ayekax hi këƴ, ar mokwëta mbaŋ hi këƴ. Ɓeɓër seɓënan bami ɓën ax ñëmb bana do lëkayali këƴ ŝenene. Gërëgako ɓeɓëranjëm këmi seɓënan. Ga nëngandëra ke ako, wëj ɓëte anëngandëra ki nëngandëra!” ");
INSERT INTO bsc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ar fëxwën baŋo okilo oki an, h̃atëgu ko ɓëte gë okilo oki ocëxe, re ko: “Axwën, okilo oki seɓënan baƴe. Nëkoɗa ga ŝotëli këme okilo oki ocëxe.” ");
INSERT INTO bsc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ata yaka ko axwën an: “Yo wëj ariyenin ayekax hi këƴ, ar mokwëta mbaŋ hi këƴ. Ɓeɓër seɓënan bami ɓën ax ñëmb bana do lëkayali këƴ ŝenene. Gërëgako, ɓeɓëranjëm këmi seɓënan. Ga nëngandëra ke ako, wëj ɓëte anëngandëra ki nëngandëra!” ");
INSERT INTO bsc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","H̃atëgu ko ngwa ar fëxwën baŋo kilo iɓat an. Ata re ko: “Axwën, anang nang këme mëne wëj mbaŋ xem ki ataxan: asaỹ këƴ sayënd eƴamb el gër ed ɓayik aƴ neɗëra bana. Ɓëte axana këƴ xanand gër ed ɓayik aƴ hiŝ bana. ");
INSERT INTO bsc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ga yëdara bame ŝonaxën bame kaŋe ireƴ in mongwëg gër ebar. Nëkoɗa, kanal er xwën këƴ in.” ");
INSERT INTO bsc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ata yaka ko axwën aŋ: “Ata wëj aƴ ye ex na ɗe! Ar ariyenin axwëlaraxik eƴ! Anang nang këƴ mëne asaỹ këme sayënd gër ed ɓayik ame neɗ bana, axana këme xanand gër ed ɓayik ame hiŝ bana. ");
INSERT INTO bsc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ɓarikan eƴ kwëtëdo kaŋe iram in gër otaxan od ɓëw̃ëxëta ɓër koɗi. Ga ɓakaw këme ako ata xana dome gë er ŝënak.” ");
INSERT INTO bsc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ata na dëŋ fel këɓi ɓërandiyen ɓoŝandaw̃: “Kanino tan kaŋe ir lëkaya ko in eno yël ar gë okilo epëxw an.” ");
INSERT INTO bsc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ar kë ŝënan yo er ŝot ko in, Kaxanu asënd këŋo sënd xali exo cotëra nëmëc. Ɓari ar ɓayik ax cënan ex na an, ado er xaỹ këŋo in dëŋ këŋo xan. ");
INSERT INTO bsc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gërëgako ariyenin axwëlaraxik ajo, pimëxëno fac gër ecamëɗan, gër ed këni sesënd ɓela, gër ed këni h̃atayand eɓasa.» ");
INSERT INTO bsc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«And këme ɓakaw wëno Asëñiw̃ ar ala aŋ, gë enjaran endam eŋ, gë ɗek omeleka odam ok, në añëpara and owun këme ỹëpa. ");
INSERT INTO bsc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ata yatijo, ɓenëng ɓend ɓela ɓeŋ ɗek eni ɓarërëgu gër ed këmi hi. Ata mëni pitëndër ang këɓi fitëtërënd axaɗac opeỹ ok gë oɓeci ak. ");
INSERT INTO bsc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mëni ɓar opeỹ ok gand liw̃ iram do oɓeci ol gand ŝame. ");
INSERT INTO bsc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Wëno emun eŋ dëŋ këɓi felëɗ ɓër gand liw̃ iram ɓën: “Tëkawëne wën ɓër ɓetak gër Faba ɓën. Kanayin owun or xëñënan baŋun elod ga ỹanak ngwën ol. ");
INSERT INTO bsc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","And xor baxe enjo aŋ, wën yël baxe er këme ƴamb in. Sel baxe men, yël këne me eceɓ; hi bame aliyer, xwëtaya këne. ");
INSERT INTO bsc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tëɓ gë eman ebame, ŝuɗëra këne. Ŝëxwëra bame, ƴeli kën ŝëma këne; hi bame gër epëra, ƴëkwali këne.” ");
INSERT INTO bsc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ata ɓër ŝenene ɓën ene mëka: “Axwën, niỹe xor baxi enjo do ɓiyi yël këmi er këƴ ƴamb? Niỹe sel baxi men do yël këmi eƴ ceɓ? ");
INSERT INTO bsc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɓëte niỹe hi baƴ aliyer do ɓiyi xwëtaya këmi? Niỹe ɓayi baƴ tëɓ gë eman eŋ do ŝuɗëra këmi? ");
INSERT INTO bsc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Niỹe ŝëxwëra baƴ do ɓiyi ƴeli këmi mi cëma? Niỹe hi baƴ gër epëra do ƴëkwali këmi?” ");
INSERT INTO bsc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ata mëni yaka wëno emun eŋ: “Ɗal in këmun felënd, nand rin këno yo enjekax gër ga ɓak yo, aɓat gër ɓëmaỹe ɓëndam, wëno rin këne.” ");
INSERT INTO bsc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ɓëte afel këmëni felëɗ ɓër gand ŝame ɓën: “Nacëtaxëne fa, wën ɓër xoỹën këŋun Kaxanu ɓëjo! Ƴeyin gër xoɗux or din ir din ol, or fëtën ko eɓi ɗapaxën ŝaɓucara in do gë omeleka odexëm ok. ");
INSERT INTO bsc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","And xor baxe enjo aŋ, wën ane yël bana er këme ƴamb in. Sel baxe men, ane yël bana me eceɓ. ");
INSERT INTO bsc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hi bame aliyer, ane kwëtaya bana. Hi bame tëɓ gë eman eŋ, ane cuɗëra bana. Ŝëxwëra bame, wën an ƴeli bana ene cëma. Ɓëte hi bame gër epëra, ane ƴëkwali bana.” ");
INSERT INTO bsc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ata eni yaka ɓën ɓëte: “Axwën, niỹe wa xor baxi enjo eŋ, niỹe wa sel baxi men, niỹe wa hi baƴ aliyer; niỹe wa hi baƴ tëɓ gë eman eŋ, niỹe wa hi baƴ gër epëra do ɓiyi ami ɗëɓa bana?” ");
INSERT INTO bsc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ata këmëni yakaɗ: “Ɗal in këmun felënd, nand ɓaƴik ano din ex na enjekax gër ga ɓak yo, ar w̃ak endam an, wëno ɓayik ane dine na.” ");
INSERT INTO bsc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ata ɓër gand ŝame ɓën kë ƴe gër toro ind din. Ɓarikan, ɓër ŝenene ɓën eni ɗil gër aniyan and din.» ");
INSERT INTO bsc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","And h̃ata ko Yesu ɗek ɓend baɓi sëƴalind aŋ, fel këɓi ɓësëfan ɓërexëm ɓën: ");
INSERT INTO bsc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ax gi ex na nde anang nang kën mëne ɓakey ɓaki fo ɓayik ex ŋat Ofëna or Apexa ol. Awa gë ofëna olo këne lëxw wëno Asëñiw̃ ar ala an do ene ɗaw̃ mopika në kërëwa.» ");
INSERT INTO bsc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ata amëd aŋo, ɓarërëgu bani ɓëŝaɗaxan ɓëlëngw ɓën gë ɓëxarëk ɓër Ɓëŝëwif ɓën gër yangana ir Kayif, aŝaɗaxan alëngw ar niy ijo an. ");
INSERT INTO bsc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ga xanar këni, xetan këɓi eno tëra yir fo Yesu eno ɗaw̃axën. ");
INSERT INTO bsc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Er bani rend mëne këreno tëra na wat-wat gë amëxwër aŋ këdi kë wonjo ofëna ol. ");
INSERT INTO bsc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Amëd aŋo, ƴe ko Yesu gër ingol ind Betani, gër iciw̃ ind Simoŋ, ar gë ameỹ an. ");
INSERT INTO bsc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ata gër ed ỹëpara bani, lilëgu ko asoxari do sëka këŋo Yesu gë ŝëlakuŋ ir gë angiri ir xem bax mbaŋ akanji. Ata nand bani ƴambërand na, asoxari an xoŝ këŋo Yesu gë angiri ijo gër gaf. ");
INSERT INTO bsc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ga wat këni eŋo, ɓësëfan ɓën xoỹën këno ba ine neminaxën baxo angiri ijo mondako. ");
INSERT INTO bsc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Akanji and ŝenene hi dox mopan do koɗi enëɓi mocetërado ɓëxaỹënaxik ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ga wata këɓi Yesu, w̃ëka këɓi: «Inew̃a këno hëbandëraxënënd asoxari ajo? Enjekax rin ke wëno. ");
INSERT INTO bsc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wën laŋ gë ɓëxaỹënaxik ɓën ga hi kën wa. Ɓari wëno ane ɓayiye na din. ");
INSERT INTO bsc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ga xoŝ ke ako gë angiri ijo, eman endam eŋ nëm ko gana-gana fo ond gër ỹeg oŋ. ");
INSERT INTO bsc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ɗal in këmun felënd, gër ed këni fem yo Atëfëtan aŋo gër ngwën ro, areƴa këni ỹana eni deƴand ɓëte end er rin ke asoxari ajo eŋ. Ata mondako këno ỹana eno kwitaxënënd.» ");
INSERT INTO bsc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɓësëfan ɓër Yesu ɓën er hi bani epëxw gë ɓëxi. Ata aɓat, ar bano w̃acënd Yuda Isëkariyot an, ƴe ko gër ɓëŝaɗaxan ɓëlëngw. ");
INSERT INTO bsc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ga h̃at ko w̃ëka këɓi ba ine këno yël angëmëne arëca rëca këɓi eno tëra Yesu. Ata yël këno koɗi ɓatama ofëxw osas. ");
INSERT INTO bsc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ata elod amëd aŋo, baxo ŝaland Yuda ang ko ri eŋo ɗëxwaxën Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yatir akey añanar and loxo and bani ƴambënd Ɓëŝëwif ɓën mburu ind gë lewir këm iŋ. Ɓësëfan ɓën ga sëka këno Yesu, w̃ëka këno: «Fe wa ỹandi ki mi cemëra ed Ofëna or Apexa el?» ");
INSERT INTO bsc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu yaka këɓi: «Ƴeyin gër angol, ata kën fed gë ala ar ano nang ex na. Peliɗëno mëne wëno Asëƴali an rek apëxëd andam aŋ anëka h̃atëguk. Ɓëte peliɗëno mëne gër iciw̃ indexëm këme ri Ofëna or Apexa ol gë ɓësëfan ɓëram ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ƴe këni ɓësëfan ɓën rix këni ang fel këɓi Yesu ak do ŝemërax këni ed Ofëna or Apexa el. ");
INSERT INTO bsc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ata genëka, ɓësëfan epëxw gë ɓëxi ɓën xetëna këno Yesu gër eƴambëran. ");
INSERT INTO bsc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nand bani ƴambërand na, Yesu re ko: «Ɗal in këmun felënd, gër enga endewën ro aɓat ex ar ke lëxw an.» ");
INSERT INTO bsc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na wëlandëra këɓi xali, asëfan kala eŋo mëka: «Wëno nde ex, Axwën?» ");
INSERT INTO bsc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu yaka këɓi: «Ar ke lëxw an, ar kë xacand gër edëƴamb edeɓat gë wëno hi ko. ");
INSERT INTO bsc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɗal ex, aŝës këme ŝës wëno Asëñiw̃ ar ala an, ang ỹëgw këni endam ak. Ɓari aŋo ye ex na ar ke lëxw an! Er fecadox din këreno dëw̃ dona.» ");
INSERT INTO bsc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ado Yuda, ar hi bax eŋo ɗëxw an dëŋ, w̃ëka këŋo: «Wëno nde ex Asëƴali?» Yesu yaka këŋo: «Ata go dëŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ga këni ƴambëra, Yesu w̃eɗ ko mburu iŋ, ŝëkwa këŋo Kaxanu do hëbëndër ko. And yël këɓi ɓësëfan aŋ, re ko: «Kanayin en ƴamb, eman endam eŋ ex.» ");
INSERT INTO bsc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","W̃eɗ ko ɓëte akalama and gë ngoƴ aŋ. Ga ŝëkwa këŋo Kaxanu yël këɓi, re ko ɓëte: «Yëlarin wën ɗek, ");
INSERT INTO bsc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","oŝat oram oŋ ex, oŝat or eter ed gë Kaxanu oŋ. Oŝat oŋo kë ŝar eɓi teɓanaxën Kaxanu ɓamena ɓaŋ ɓela ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ɗal in këmun felënd, doro fela këme ngoƴ iŋ xali yatir këne ɓarëxëye gër owun or Faba. Fën këne ŝeɓëxëɗe ingaŝax iŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ata and ỹëw̃ëra këni na ojëkan od cale aŋ, Yesu gë ɓësëfan ɓën ƴe këni kwël ond gër etënd ed gë ɓañarëka oŋ. ");
INSERT INTO bsc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ga h̃at këni, Yesu fel këɓi: «Wën doro gëmëɗ mbaŋ kën yëdara në end ow̃ac oram, wën ɗek ke ŝapëran. Ata mondako kë h̃ata er ỹëgw ko alaw̃ënel ar Kaxanu in mëne: “Axaɗac an këmo fëm ƴem na fo, ata eni capër bër oyel ol.” ");
INSERT INTO bsc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ɓarikan and këme xani gër ecës aŋ, gër ebar ed Galile këme lëngwa ene tëkëx.» ");
INSERT INTO bsc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na re ko Piyer: «Ado eni gër ɓëjo ɗek eni teɓ gaɓat, ax gi ex na gë wëno ak.» ");
INSERT INTO bsc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ata yaka këŋo Yesu: «Ɗal in këmi felënd, doro gëmëɗ, ɗamana exo yata ecare el wëj anëka këƴe ƴaxëta ɓatas.» ");
INSERT INTO bsc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Re ko ɓëte Piyer: «Ado gido ecës el dëŋ faɓër këmi, wëno din ami ƴaxëta na.» Ata ɓësëfan ɓën ɗek soŝanara këni mondako. ");
INSERT INTO bsc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ga xucak eŋo, Yesu gë ɓësëfan ɓën ƴe këni gër ed këni w̃acënd Getësemani. Ga h̃at këni, fel këɓi: «Ñëparayin ro do wëno me nacëta me calew.» ");
INSERT INTO bsc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","W̃ac këɓi Piyer, gë ɓosëñiw̃ ɓor Sebede Ŝak do gë Ŝaŋ, eno ɗaŋëta. Ga h̃at këni, Yesu ỹana ko këŋo wëlandërand xali ŝamina ko. ");
INSERT INTO bsc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ata fel këɓi ɓër laŋëta baŋo ɓën: «Awa enjëw̃ endam eŋ anëka ŝaminak, ecës el fo ɓayi ke. Cëniyine ro, këreŋun daŝ na ɗe!» ");
INSERT INTO bsc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ga nacëta ko tëkër, foxi ko eƴiỹ el ŋëŝ gër ebar. Ata ko ŝalend mondako: «E Faba, eƴ dëxëtëdo, kido awënd wëndëk, akalama and toro and këme ŝeɓ aŋo! Ɓarikan dil ang ỹandi ki ak, ax gi ex na ang ỹandi ke wëno ak.» ");
INSERT INTO bsc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ata ɓaka ko gër ed seɓ baɓi ɓësëfan ɓësas ɓën, sëk këɓi ga këɓi raŝ. Na re ko: «Oko Piyer, wën an kore na nde en ɓayi daŝërëxe apëxëd amat and riw këme aŋo? ");
INSERT INTO bsc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","«Ga re këme perënayin en calexënënd këdi këŋun naŋëta. Ala an gër onden ondexëm këŋo ỹandind exo di enjekax eŋ, ɓarikan në end oñandi od eman ko sëkwanaxënënd exo di in.» ");
INSERT INTO bsc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nacëta ko Yesu gaŝëxe do ko ŝalend ang añanar ak: «E Faba, angëmëne ax mënd ex na eƴ dëxët akalama and toro and këre me ŝeɓ aŋo, dil ang ỹandi ki ak!» ");
INSERT INTO bsc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ga ɓaka ko akinëm, sëk këɓi ɓëte ga këɓi raŝ. Ata ado motëkwan bani sëkwanënd eni kwëw̃ëta in. ");
INSERT INTO bsc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ga seɓ këɓi na, nacëta ko ɓëte gaŝëxe do ko ŝalend atasën ang ɓanëngw ak. ");
INSERT INTO bsc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aŋo ga ɓakaw ko gër ɓësëfan ɓërexëm, fel këɓi: «Wën xali gërëgako nde xwënda kën okwëɗ? Nangin mëne anëka h̃atëguk apëxëd and këne sëra wëno Asëñiw̃ ar ala aŋ do ene ɗëxw gër otaxan od ɓëw̃endëran aŋ! ");
INSERT INTO bsc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ado kaniwën ene ƴeye, ɗam exo ar ke lëxw an!» ");
INSERT INTO bsc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ɗamana ko h̃atand eŋo, ŝanayaw ko pëlët Yuda, asëfan aɓat ang ebani epëxw gë ɓëxi ak. Mëŋ lëngwënëgu baɓi amëxwër and ɓela aŋ eno tëra Yesu. Ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëxarëk ɓër Ɓëŝëwif ɓën law̃ënëgu baɓi. Ata w̃ëlaraw këni ɓëjo oduxuma, ɓëjo okwëlekwële. ");
INSERT INTO bsc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ar baŋo lëxwënd an, fel baɓi amatinali aŋo: «Ar këmo w̃ega an, mëŋ ex, tërayino.» ");
INSERT INTO bsc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ataŋ ga sëka këŋo Yesu, re ko: «Mondake ɓayi këƴ Asëƴali!» Ata w̃ega këŋo. ");
INSERT INTO bsc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ata re ko Yesu: «Xey lawo, er ƴow këƴ eƴ di in dil aỹand!» Na ga w̃ëlën këno, sëra këno. ");
INSERT INTO bsc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ata aɓat ar enga gë Yesu, regëgu ko duxuma irexëm in gër acëmar, saw̃ ko baɗ anëf and xaɗëp ir aŝaɗaxan alëngw in. ");
INSERT INTO bsc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ata re ko Yesu: «Wëj maŝël duxuma in gër acëmar gayik ɗek ɓër kë w̃erënd gë duxuma ɓën, duxuma fo këɓi law̃ ɓëte. ");
INSERT INTO bsc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ba yëla këƴ asëkwan sëkwan këme mo kara Faba mëŋ ar xor dox exe ɗaw̃ëneliw ataŋ ataŋ, omeleka owëli owëli an? ");
INSERT INTO bsc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mondake cëŋ kë h̃ata er rek Oñëgw Omënëk in mëne afo me toro mondako?» ");
INSERT INTO bsc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ata Yesu yeƴaneli këɓi ɓëte ɓër gër amëxwër ɓën: «Wën ƴowëraw kën ene tëra gë oduxuma do gë okwëlekwële, ba arek axeỹax nde hi këme? Ax gi ex na nde key yo key bamëni sëƴalirand ɓela ɓën gër yangana ir Aciw̃ and Kaxanu? Ɓari gaɓatak axe tëra bana. ");
INSERT INTO bsc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ɓarikan ɗek ɓeŋo mondako bax ex gi ex ŋataxën er ỹëgw këni ɓëlaw̃ënel ɓër Kaxanu in.» Aŋo ŝapëran këno ɓësëfan ɓën, hërëra këni ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓër sëra baŋo Yesu ɓën, w̃ëla këno gër ed ɓarër bani ɓëŝalen do gë ɓëxarëk ɓër Ɓëŝëwif, gër iciw̃ ind Kayif, aŝaɗaxan alëngw an. ");
INSERT INTO bsc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ata Piyer këɓi sëfa nacët ako ɓër sëra baŋo Yesu ɓën, xali gër eyang ed aŝaɗaxan alëngw. Lil ko gër yangana do xetëna këɓi ɓënëkona ɓën gër ed ỹëpa këni exo wataxën ba mondake kë h̃ata endeƴ eŋo. ");
INSERT INTO bsc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ata ɓëŝaɗaxan ɓëlëngw ɓën, gë ɗek Amara and ɓëxarëk ɓër Ɓëŝëwif aŋ këni ŝaland er këno nagaŝan Yesu eno ɗaw̃axën. ");
INSERT INTO bsc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɓari ado ga nagaŝandëra bano ɓëranjëm, abani ŝot na etiɓax. Ata ŝanayaw këni ɓela ɓëxi këni rend: ");
INSERT INTO bsc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ajo bax rend mëne axor ko xor exo ñam Aciw̃ and Kaxanu aŋ do exo kanin në ɓakey ɓatas.» ");
INSERT INTO bsc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ata aŝaɗaxan alëngw an xani ko, w̃ëka këŋo: «Wëj ɓendanjëm këni nagaŝanënd, ba aƴ yaka na nde?» ");
INSERT INTO bsc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ɓarikan Yesu xor ko ƴem. Aŋo re ko aŝaɗaxan alëngw an: «Gër ow̃ac or Kaxanu, mëŋ ar gë aniyan an, këme yaŝarënd, pelëlëɓo angëmëne wëj ex Afexën an, Asëñiw̃ ar Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu yaka këŋo: «Iyo go dëŋ ex. Ɓëte ɓaxëtël me ɓaŝ mëne awat këne wat wëno Asëñiw̃ ar ala an ga ỹëpa këme gand liw̃ ir Kaxanu, mëŋ Ar xorëk ɓeỹ ɗek an. Awat këne wat ƴaŋ gër orën ga këme ŝëlaw gë ɓaŋar ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ga logën këŋo aŝaɗaxan alëngw an, h̃esëra ko acuɗ andexëm aŋ do ko rend: «Anëka ŝir këŋo Kaxanu! Anëka ŝir këŋo Kaxanu! Sede nde ɓayik na exo ɓaŝ ỹeỹ? Ine yëla kën?» ");
INSERT INTO bsc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ata yaka këni: «Ajo ar eɗaw̃ ex.» ");
INSERT INTO bsc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kwël na fo ỹana këni këno soronënd: ɓëjo asëpan, ɓëjo aw̃ëŋ, ɓëjo ɓëte aŝën do eno mëka: ");
INSERT INTO bsc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Gayikako wëj rek mëne alaw̃ënel ar Kaxanu eƴ, pelëlëɓo ba noỹo ŝën ki.» ");
INSERT INTO bsc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Xarak amëd aŋo, Piyer fac ɓayi baxo, gër ed ỹëpa ko gër yangana. Ata sëka këŋo endënaw̃, re ko: «Wëj ɓëte ar enga end Yesu, Agalile an hi këƴ!» ");
INSERT INTO bsc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ata ga ko ƴax Piyer yaka ko poyoma: «Wëno ado ame nang ex na er këƴ rend in.» ");
INSERT INTO bsc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ga xani ko, ko ƴend gand ebët ed iciw̃, endënaw̃ ecëxe ɓëte ga wat këŋo këɓi felënd ɓër hi bax na ɓën: «Ajo ar enga end Yesu Iɓënasaret hi ko ɗe.» ");
INSERT INTO bsc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ata yaŝar ko ga ko ƴax gaŝëxe: «Wëno amo nang ex na ɗe ala ajo.» ");
INSERT INTO bsc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ga ɓaŝanak, ɓër xet bani gë Piyer ɓën re këni: «Ɗal ga ex nde, wëj ar enga end ala ajo hi këƴ. Ang këƴ yeƴanënd ak nangaxën këmi mëne Aɓëgalile eƴ.» ");
INSERT INTO bsc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na yaka ko: «Corëlexe Kaxanu angëmëne anang nang këmo ala ajo!» Ata amëd aŋo yata ecare el. ");
INSERT INTO bsc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyer xwita ko er fel baŋo Yesu in mëne ɗamana exo yata ecare el anëka këŋo ƴaxëta ɓatas! Ata xwiriŝ, ŝan ko fac ko sesëxënd ga ŝena këŋo mbaŋ er ri ko in. ");
INSERT INTO bsc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ga wecak gëɓër, ɓëŝaɗaxan ɓëlëngw ɓën gë ɓëxarëk ɓër Ɓëŝëwif ɓën ỹëpaxën këni end Yesu eŋ. Ata xetan këɓi eno ɗaw̃. ");
INSERT INTO bsc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ga xap këno, w̃ëla këno ƴaŋ gër eyang ed Pilat eŋo kitix mëŋ ɓëte. ");
INSERT INTO bsc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ata Yuda, asëfan ar lëxw baŋo Yesu an, ŝena këŋo ga wat ko mëne anëp dëŋ nëp këno. Ɓakali ko ɓatama ofëxw osas ɓand koɗi ir yël bano ɓaŋ gër Amara and ɓëŝaɗaxan ɓëlëngw do gë and ɓëxarëk ɓër Ɓëŝëwif. ");
INSERT INTO bsc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Fel këɓi mëne mbaŋ lif ko ga fan këŋo ala ar ỹow̃eỹ axo men ex na an. Yaka këno: «Wëj nangëk ɗe eŋo, ɓiyi aɓo ɓal ex na!» ");
INSERT INTO bsc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sam ga yaka këno mondako, Yuda ŝeñi ko biŝaw koɗi in lëf gër Aciw̃ and Kaxanu, do ƴe ko kwël xaw̃ayax ko. ");
INSERT INTO bsc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ga w̃eɗara këni koɗi in, ɓëŝaɗaxan ɓëlëngw ɓën re këni mëne ax ñap ex na eni maŝ koɗi ijo gër akwëtaya and oyël or Kaxanu, gayikako akanji and enjëw̃ end ala ex. ");
INSERT INTO bsc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ata xetan këɓi eni yëc oŝënga or aɓaƴ ar ofeƴa an eni dixën oñeg od ɓëliyer. ");
INSERT INTO bsc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mëŋ këni w̃acaxënënd xali doro oŝënga olo «Ebar ed oŝat.» ");
INSERT INTO bsc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mondako h̃ata bax er re baxo Kaxanu paɓ gë Yeremi, alaw̃ënel an: «Ɓëxarëk ɓër Ɓëŝëwif ɓën aw̃eɗ w̃eɗ këni ɓatama ofëxw osas ɓand koɗi ɓaŋ, akanji and Ɓëyisërayel aŋ ang fënëta bano ak. ");
INSERT INTO bsc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ɓëte gë koɗi ijo këni yëcaxën oŝënga or aɓaƴ ar ofeƴa ol ang fel ke Axwën ak.» ");
INSERT INTO bsc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","And h̃ateli këno Yesu gër eyang aŋ, Pilat w̃ëka këŋo: «Wëj nde ex emun end Ɓëŝëwif eŋ?» Yaka ko: «Iyo go dëŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ako nagaŝandëra bano xali ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëxarëk ɓër Ɓëŝëwif ɓën, ɓarikan mëŋ aɓi yaka ex na. ");
INSERT INTO bsc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ata re ko Pilat: «Aƴ wëlënd na nde ɗek ɓend këni nagaŝandërand ɓeŋ?» ");
INSERT INTO bsc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ɓari mëŋ aŋo yaka ex na. Aŋo ŝaran këŋo Pilat xali xurik. ");
INSERT INTO bsc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ofëna or Apexa kala, Pilat aseɓët baŋo seɓëtënd andepëra amat, and këno yata Ɓëŝëwif aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Xarak, andepëra angwëlik hi bax na and bano w̃acënd Yesu Barabas. ");
INSERT INTO bsc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ang ɓarërëgu bani gër aciw̃ and kiti ak, Pilat w̃ëka këɓi: «Noỹo wa ỹandi këŋun mo teɓët doyijo, Barabas nde ba Yesu, ar këno w̃acënd Kërisët an nde?» ");
INSERT INTO bsc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aye nang baxo Pilat mëne në end oƴakërax lëxwaxën bano Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ata and ỹëpa ko Pilat gër aciw̃ and kiti aŋ, alindaw̃ law̃ënëgu ko eŋo pel ako: «Wëj këreƴ ɗil na ɗe gër end ar ŝenene ajo! Wëno cëŋ wec soro këme në endexëm në lakeli!» ");
INSERT INTO bsc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ata ɓëŝaɗaxan ɓëlëngw ɓën do ɓëxarëk ɓër Ɓëŝëwif ɓën ŝoñ kënëɓi ɓela eno nëỹali Pilat eŋo teɓët Barabas do eŋo ɗaw̃ Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na re ko Pilat: «Ɓela ɓëxi ɓëjo, yatayino aɓat!» Yaka këni ŝor: «Barabas yata këmo! Barabas yata këmo!» ");
INSERT INTO bsc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Re ko ɓëte Pilat: «Do mondake këmo ri Yesu, ar këno w̃acënd Kërisët an?» Yaka këni ŝor: «Pikalo, pikalo gër kërëwa!» ");
INSERT INTO bsc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","W̃ëka këɓi ɓëte: «Inew̃a w̃en ko?» Aŋo xeỹ këni kaŝ-kaŝ: «Pikalo, pikalo gër kërëwa!» ");
INSERT INTO bsc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ata Pilat wata ko mëne ax mënd ex na eŋo teɓët Yesu këdi kë wonjo kaŝ-kaŝ angol aŋ. W̃eɗ ko inëp ind gë men do neɓa ko na dëŋ otaxan ok xali wat këno ɓën ɗek. Ga faỹ ko, re ko: «Awa end oŝat or ar ŝenene ajo eŋ, wën nangëk ɗe, wëno ame nang ex na!» ");
INSERT INTO bsc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yaka këni ɓën ɗek: «Eyo, mëkayiɗëleɓo Kaxanu end enjëw̃ end ala ajo eŋ ɓiyi gë oɓaŝ oreɓi ol!» ");
INSERT INTO bsc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilat seɓët këŋo Barabas do fel këɓi ocoroɗa odexëm ok eno cew̃ëra Yesu ɗamana eno pikaxën. ");
INSERT INTO bsc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ata ocoroɗa od Pilat ok nëcët këno Yesu gër yangana ir eyang. Ga ɓarërëgu këni ɓën ɗek, xeta këno. ");
INSERT INTO bsc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ga ŝuɗëtëra këno ɓanjëm ɓandexëm ɓaŋ, nëmb këno ocuɗ ombarax. ");
INSERT INTO bsc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Saw̃ëgu këni ɓëte inini ind atëx and gë odëmbën, ɓor këni ang ekamote fo do ŝëxw këno. Fëxwën këno oŝët exo ɗëkaya gër ataxan and liw̃. And këno sëka aŋ, eni poxi gër lëngw irexëm do eno ɗëŝënd: «Emun end Ɓëŝëwif, aŝëma këmi ŝëmand!» ");
INSERT INTO bsc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ocoroɗa odëmar eno tëpan gër dëxas, oko eno dang gë oŝët ol or fëxwën bano ol. ");
INSERT INTO bsc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","And lëŝëra këno mondako aŋ, ŝuɗët këno ocuɗ ombarax oŋ do w̃aŝ këno ɓanjëm ɓandexëm ɓaŋ eno mëlaxën gër ed këno fikax. ");
INSERT INTO bsc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ata enga end ocoroɗa eŋ këno nëcëtënd Yesu angol and Yerusalem aŋ eno pikax fac. Ga fed këni gë ar bano w̃acënd Simoŋ iɓ Siren, nëyali këno exo ɗapara osëx or këno fikaxënëx Yesu ol. ");
INSERT INTO bsc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na lapara ko osëx ol xali h̃at këni gër itënd bani w̃acënd Golëgota, mëne ngëŋ «Ind ang egor.» ");
INSERT INTO bsc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ata yël këno Yesu ngoƴ ind ɓar bani gë ɓëŝan. And sëƴi ko aŋ, h̃ëp ko exo ceɓ. ");
INSERT INTO bsc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","And fika këno aŋ, ocoroɗa ok ŝetërënd këni ɓanjëm ɓandexëm ɓaŋ. Ɓëñak ri bani eni nangaxën ar kë w̃eɗ an. ");
INSERT INTO bsc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ata ỹëpara këni gër enëkona. ");
INSERT INTO bsc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yaɓët gaf in fika bani ingomb-gomb ind ỹëgwaxën bani mëne «Yesu, emun end Ɓëŝëwif eŋ.» Ejo bax amena and law̃axën bano aŋ. ");
INSERT INTO bsc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Afika fika banëɓi ɓëte gë mëŋ ɓërek ɓëxeỹax ɓëxi: aɓat gand liw̃ ajo gand ŝame. ");
INSERT INTO bsc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ata ɓela ɓër bax xucarand ler gër ed fika banëɓi ɓën, këno ŝirënd Yesu. Sam eni këmëƴëta eni de: ");
INSERT INTO bsc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Yo wëj bax rend mëne axor këƴ xor eƴ ñam Aciw̃ and Kaxanu do eƴ kanin në ɓakey ɓatas. Awa pexënayal doro! Enimin, angëmëne wëj ex Asëñiw̃ ar Kaxanu an, pedaw gër kërëwa mi wat!» ");
INSERT INTO bsc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Alëŝ bano lëŝënd ɓëte ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëŝalen ɓën do gë ɓëxarëk ɓër Ɓëŝëwif ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Er bani rend: «Oko, mëŋ ar baɓi racëtënd ɓela gër toro an nde kë sëkwanënd exo pedaw gër kërëwa! Gayikako mëŋ ex emun end, ɓiyi Ɓëyisërayel eŋ, pedawëlexo enëŋo kwëtaxëne! ");
INSERT INTO bsc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ax gi ex na nde mëŋ ar xwëta këŋo Kaxanu hi ko? Ax gi ex na nde ɓëte Kaxanu ah̃an h̃an këŋo? Ɓëte ax gi ex na nde mëŋ dëŋ kë rend mëne Asëñiw̃ ar Kaxanu exo? Awa gërëgako dacëtëleŋo ngwa!» ");
INSERT INTO bsc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aŝir bano ŝirënd ɓëte ɓërek ɓëxeỹax ɓër fika banëɓi gë mëŋ ɓën. ");
INSERT INTO bsc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ata ebar el ɗek ŝamëɗanëk elod eñan keŋ gër gaf xali hik poxoŝ gaf in. ");
INSERT INTO bsc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ga xucak ɓapëxëd ɓatas, Yesu xeỹ ko acakax: «Eli, Eli lama sabatani! Mëne ngëŋ Kaxanu, Kaxanu, inew̃a seɓaxën këƴe?» ");
INSERT INTO bsc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɓër hi bax ler na ɓën ga wël këno, këni rend: «Wëlino, alaw̃ënel Eli këŋo w̃acënd!» ");
INSERT INTO bsc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na w̃aran ko ala er ñalu-ñalu, ỹëmbëgu ko në ngoƴ iŋerëk, fiŝ ko në oŝët do ỹënën këŋo Yesu exo ƴuŝ. ");
INSERT INTO bsc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ata xeỹënaxën këno ɓër hi bax ler na ɓën: «Xey wëj, teɓëlo ene wate ba aƴow ko ƴow Eli eŋo pexën!» ");
INSERT INTO bsc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu xeỹ ko ɓëte acakax do kwël xoti ko. ");
INSERT INTO bsc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ata lëf gër Aciw̃ and Kaxanu, anjëm amëgax and bax ŝetërënd në ɓaciw̃ ɓaki aŋ h̃esik ciɗët. Rëgëk ɓëte ebar el xali ŝapirak ɓangaỹ ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Oñeg ok fëŋëtayarak do ɓëw̃ënëk ɓëranjëm xanira këni gër ecës gë ɓeman ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓër ŝanëragu bax gër oñeg ɓëjo, lil këni gër Yerusalem, angol amënëk aŋ, do ŝanayaxëndëra kënëɓi ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ata ocoroɗa od baŋo nëkonand Yesu ok, gë alëngw areɓën an, ga wat këni ang rëgëk ebar ak do ɗek ɓeɓër xuca bax na ɓën, yëdara këni, do re këni: «Enimin ajo, Asëñiw̃ ar Kaxanu an ebaxo ɗe!» ");
INSERT INTO bsc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ɓëte ɓësoxari ɓëranjëm ɓarërëgu bax na. Ga xwëŝaraw këni nacët ako këno nëkonënd Yesu. Ɓën elod nand ebaxo gër ebar ed Galile sëfaw bano do bano rëcarand. ");
INSERT INTO bsc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ŝëf gër ɓësoxari ɓëjo hi bani: Mari Madëlen, gë Mari, nëm ir ɓër gë aɓinëm Ŝak gë Yosef do gë nëm ir ɓosëñiw̃ ɓor Sebede. ");
INSERT INTO bsc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ata apenëka aŋ, ala ar gë napul ar xaniw bax gër Arimate do bano w̃acënd Yosef, h̃atëgu ko. Mëŋ ala ar gë napul ebaxo do hi baxo ɓëte asëfan ar Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ata ƴe ko gër Pilat, xaraw këŋo eŋo maŝ eman end Yesu eŋ eno mëxwëta. Ata Pilat fel këɓi ocoroɗa ok eno maŝ. ");
INSERT INTO bsc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosef fedali këŋo, fëlëra këŋo gë këpas iw̃ënëk. ");
INSERT INTO bsc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Do kwël w̃ëla këŋo, w̃ëxëtax këŋo në ỹeg ixaŝax, ir fësën bano mëŋ Yosef dëŋ gër aparëfac. Ga xwët këno lëf gër xatëx, fëŋ ko lilaya in gë angaỹ atëm do kwël w̃aỹi ko. ");
INSERT INTO bsc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nand baŋo w̃ëxëta Yesu na, ler na ỹëpara bani Mari Madëlen gë Mari iŝandaw̃ mopaɓër gë ỹeg in. ");
INSERT INTO bsc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yatir akey and eteyëta, ɓëŝaɗaxan ɓëlëngw ɓën do gë ofariseŋ ok sëfër këni ɓura-ɓura gër eyang ed Pilat. ");
INSERT INTO bsc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ga h̃at këni, fel këno Pilat: «Wëj axwën areɓi an ƴow këmi mi nangën mëne anëgwëŝ ajo, and ɓayi baxo aɓëngw aŋ, are baxo rend mëne and kë xuca ɓakey ɓatas aŋ, axani ko xani gër ecës. ");
INSERT INTO bsc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Awa këdi këni ƴow ɓësëfan ɓërexëm ɓën eni deka eman eŋ do eni deƴarand gër ɓulunda mëne axani xani ko gër ecës, pelëlëɓi ocoroɗa odeƴ ok eni nëkona ỹeg in xali ex kuca ɓakey ɓatas ɓaŋo. Angëmëne ane di ex na mondako, enëgwëŝ eŋo kë xuca eñanar eŋ!» ");
INSERT INTO bsc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ata yaka këɓi Pilat: «Ax gi ex na nde ɓënëkona ŝot kënëɓi na, awa mëlayinëɓi gër ỹeg eni nëkonax ang nang kën ak.» ");
INSERT INTO bsc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ata ɓëŝaɗaxan ɓëlëngw ɓën do gë ofariseŋ ok sëfër këni gë ocoroɗa ok xali gër ỹeg. Ga xër këni oŝëɓa gër angaỹ and fëŋaxën bani ỹeg aŋ, ocoroɗa od seɓ banëɓi na ok këni nëkonand. ");
INSERT INTO bsc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ga xucak akey and eteyëta aŋ, yatir oganjar, mopëɗ gëɓër, Mari Madëlen gë Mari iŝandaw̃ ƴe këni gër ỹeg ir Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ga këni h̃at, ebar el kë rëgënd. Ata fedaw ko elod gër orën meleka ir Axwën, xën ko angaỹ and weɗixën bani lilaya ir ỹeg aŋ, do ỹëpaxën ko. ");
INSERT INTO bsc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ola orexëm ol kë watind ang ebingara fo do ɓanjëm ɓandexëm ɓaŋ feŝëk xali xurik. ");
INSERT INTO bsc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ocoroɗa ok këɓi rëgëndërand. Ga xap këɓi anjiỹ aŋ, këni wëcërand reɓe reɓe ang ɓëŝësëk fo. ");
INSERT INTO bsc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Meleka in fel këɓi ɓësoxari ɓën: «Wën cëŋ këren yëdara na! Aye nang këme mëne Yesu, ar fika bano an, këno ŝaland. ");
INSERT INTO bsc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Axo bo ex na ro, anëka xani ko gër ecës ang reƴa baxo ak. Ƴowën tan en nëkon gër ed xwët bano. ");
INSERT INTO bsc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gërëgako, marayin enëɓi pelëx ɓësëfan ɓërexëm ɓën mëne axani xani ko gër ecës. Anëka lëngwa ko gër ebar ed Galile. Fën këno watëx. Wëno eŋo bax mun nangën!» ");
INSERT INTO bsc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ga wël këni eŋo, Mari Madëlen, gë Mari iŝandaw̃ w̃ara këni gë anjiỹ fo eni ŋaw̃ëta ỹeg in. Er ɓar bax gër ow̃ëkw oreɓën anjiỹ gë onënga osëm. Hër këni eni tëfëtërax gër ɓësëfan. ");
INSERT INTO bsc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ata ga fed këni gë Yesu, ŝëma këɓi. Ɓën ga sëka këno, foxi këni. Ga këno lëkëra gër osapar, ŝale këno. ");
INSERT INTO bsc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ata re ko Yesu: «Këren yëdara na! Ƴeyin enëɓi pelëx ɓëmaỹe ɓëŋ eni mara gër ebar ed Galile. Fën këne watëx.» ");
INSERT INTO bsc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Në fëña fo ɓayi bani Mari Madëlen gë Mari iŝandaw̃ ga h̃at këni gër angol and Yerusalem ocoroɗa od bax nëkonand ỹeg ok. Reƴax këni ɗek gër ɓëŝaɗaxan ɓëlëngw ang xucak ɓeỹ ak. ");
INSERT INTO bsc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ata ɓën w̃acër këni gë ɓëxarëk ɓër Ɓëŝëwif ɓën eni ñëpaxën endeƴ eŋ. Ga wëlër këni na, yël kënëɓi ocoroɗa ok koɗi ir ɓon. ");
INSERT INTO bsc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Afel fel banëɓi ɓëte mondako: «Deƴayindën mëne ɓësëfan ɓër Yesu ɓën ƴowëk gëmëɗ do reka këni eman eŋ nand baŋun raŝënd na. ");
INSERT INTO bsc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Do angëmëne exo wël eŋo Pilat, ɓiyi axor këmo xor mo pel eŋun teɓan, ỹow̃eỹ aŋun gi na.» ");
INSERT INTO bsc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ocoroɗa ok xana këni koɗi in do ri këni ɗek ang fel banëɓi ak. Ata wëlik endeƴ eŋo mondako gër Ɓëŝëwif xali doro. ");
INSERT INTO bsc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɓësëfan epëxw gaɓat ɓën, ƴe këni gër ebar ed Galile, ƴaŋ gër etënd ed fënëtan baɓi Yesu. ");
INSERT INTO bsc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","And wat këno aŋ, foxi këni do këno ŝalend. Ɓarikan ɓërëmar ah̃ëpëgënan baɓi h̃ëpëgënanënd mëne Yesu dëŋ ex. ");
INSERT INTO bsc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ga sëka këɓi, fel këɓi: «Wëno xwënëk owun or gër orën ol, ɓëte wëno xwënëk owun or gër ebar ol! ");
INSERT INTO bsc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ƴeyin gër ɓela gë enëng gë enëng ebar el ɗek, enëɓi di ɓësëfan ɓëram. Ɓuyindënëɓi gër ow̃ac or Faba, gë or Asëñiw̃ do gë or Angoc Amënëk ol. ");
INSERT INTO bsc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tëƴalindënëɓi etëf ed ɗek er fel këmun el. Ata wëno, key yo key, këme hi gë wën xali yatir kë xwët ngwën.»");
INSERT INTO bsc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mondako ỹanak Atëfëtan and Yesu Kërisët, Asëñiw̃ ar Kaxanu an. ");
INSERT INTO bsc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ang ỹëgw ko alaw̃ënel Esayi ak: «Nëkoɗ arolaw̃ën aram an këmo lëngwalilind gër ngwën exi ŋacan fëña in. ");
INSERT INTO bsc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mëŋ kë xeỹënd gër ladawe: “Mëxwëtin fëña ir Axwën in! Ɗebëtin opëña odexëm ok.”» ");
INSERT INTO bsc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ata ŝanayaw ko gër ladawe Ŝaŋ Batis, ar baɓi ɓuyind ɓela an. Afem baxo femënd gër ɓela eni nëngwët ola oreɓën ol, eɓi ɓuyixën do eni cotaxën eteɓan ed ɓeñëŋënax ɓendeɓën el. ");
INSERT INTO bsc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓela ɓën ɗek ebar ed Yude el do gë ɗek Ɓëyerusalem ɓën aƴe bani ƴend gër ndexëm eɓi ɓuyi polo gër yeɓ ir Yurëdeŋ and këni fut poyoma ɓeñëŋënax ɓendexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ŝaŋ Batis, acuɗ and omban ond gelemba baxo ŝuɗand do baxo xapand enar gër edum. Owure baɓi ƴambënd do gë dingën iɓapuỹ. ");
INSERT INTO bsc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mondako baxo femërand: «Ar xuca ke panga kë ƴowënd na. Ado wëno axe ñap ex na me dëngw do me pët ogux od ɓapeɗ ɓandexëm ok. ");
INSERT INTO bsc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wëno gë men këmun ɓuyind, ɓarikan mëŋ këŋun ỹana eŋun ɓuyind gë Angoc Amënëk aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Angwën aŋo, xaniw baxo Yesu gër Nasaret, gër ebar ed Galile, do ƴow ko na eŋo ɓuyi Ŝaŋ Batis polo gër Yurëdeŋ. ");
INSERT INTO bsc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","And baxo ŝëpëtand aŋ, Yesu wat ko fol orën ol do Angoc Amënëk aŋ ga ko fedaw ang eɗëxwëte epeŝax fo xali lapaxën këŋo. ");
INSERT INTO bsc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wëlik oniw̃ gër orën: «Wëj ex Asëñiw̃ aram an! Wëj ex pëlot gër yomb iram do wëno mbaŋ ke ɓalënd endeƴ eŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ataŋ Angoc Amënëk aŋ w̃ëla këŋo Yesu gër ladawe. ");
INSERT INTO bsc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Fën rix baxo ɓakey ofëxw onax do Sindan in axacëra baŋo xacërand eŋo naŋët Yesu. Yesu ŝit gër ow̃acar hi baxo do omeleka baŋo rëcarand. ");
INSERT INTO bsc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yesu ɓaka ko gër ebar ed Galile and fëra këno Ŝaŋ Batis aŋ do ko femëraxënd Atëfëtan and Kaxanu aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Er baxo rend: «Anëka h̃atëguk owun or Kaxanu ol, nëngwëtin ola orewën ol, kwëtayin Atëfëtan aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Akey amat, Yesu ga ko sëfa ɓëŋa ir anjer and gër Galile in, wat këɓi ɓër gë aɓinëm, Simoŋ gë Andëre ga këni lapëra gë owën oreɓën oŋ. Ɓëŝëpët ɓër oxan ebani. ");
INSERT INTO bsc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ata re ko Yesu: «Wën tëfëgune tan mun di ɓëɓar ɓër ɓela.» ");
INSERT INTO bsc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ataŋ seɓ këni owën oreɓën oŋ do kwël sëf këno. ");
INSERT INTO bsc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu ƴe ko ɓëte imbaɗ, wat këɓi ɓëte polo në ikuluŋ, Ŝak asëñiw̃ ar Sebede, do gë aɓinëm Ŝaŋ, ga këni w̃ëxëtëra owën oreɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ataŋ w̃ac këɓi kwël sëf këno. Seɓ kënëɓi na Sebede, sëm ireɓën do gë ɓëriyenin ɓën polo gër ikuluŋ. ");
INSERT INTO bsc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu gë ɓësëfan ɓërexëm ɓën h̃at këni gër Kafarënawum. Ata yatir akey and eteyëta, Yesu ƴe ko gër aciw̃ acaleya and Ɓëŝëwif, do këɓi sëƴalirand end Kaxanu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mbaŋ baɓi ŝaranënd ɓër baŋo ɓaxëtënd ang ko sëƴalind ak ɓën gayik gë or gapak baxo yeƴanënd. Osëƴali orexëm ol ax mëndër bana gë or ɓëŝalen ɓëreɓën ol. ");
INSERT INTO bsc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ata fedëk yatijo, Aŝëwif ar gë angoc añëŋënax ƴow bax na gër aciw̃ acaleya aŋo. And wat këŋo Yesu aŋ, ala ajo ỹana ko ko xeỹënd: ");
INSERT INTO bsc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Inew̃a këƴ ŝaland Yesu Iɓënasaret? Ba eƴëɓo nemin nde ƴow këƴ? Anang wa nang këme mëne wëj ex Aw̃ënëk ar xaniwëk gër Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ata Yesu xeỹënaxën këŋo angoc añëŋënax aŋ: «Xey wëj cësinal! Canël gër ala ajo!» ");
INSERT INTO bsc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Angoc añëŋënax aŋ ỹëngëndëra këno ala ajo, h̃erën këno xali do kwël ŝan ko. ");
INSERT INTO bsc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɗek ɓër ƴowëraw bax gër cale yatijo ɓën ŝarandëra këɓi xali xurik. Ata këni w̃ëkarënd: «Inew̃a ex eŋo? Osëƴali oxaŝax, or gapak nde h̃atënëgu këɓo? Yama ɓangoc ɓañëŋënax ɓaŋ ga këɓi xeỹanënd nde gë panga do këni rind er re ko in!» ");
INSERT INTO bsc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ata wëlik ow̃ac or Yesu ol ɗek ebar ed Galile el. ");
INSERT INTO bsc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga ŝan këni gër aciw̃ acaleya, Yesu gë Ŝak do gë Ŝaŋ sëfër këni gër iciw̃ ind Simoŋ do gë Andëre. ");
INSERT INTO bsc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sëk këno aỹaraw̃ isoxari ar Simoŋ ga ŝëxw këŋo. Fel këno ataŋ Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu ga sëka këŋo, lëk këŋo gër ataxan. Ata xoc këŋo ataŋ acëxwël aŋ do xani ko eɓi ɗëɓa. ");
INSERT INTO bsc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Genëka ga ŝëlak eñan eŋ, w̃ëlaraw kënëɓi gër Yesu ɗek ɓëŝëxwëra ɓën do ɓër gë ɓëyël ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Angol aŋ ɗek ɓarërëgu këni gër ebët ed iciw̃ ind Simoŋ ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu fakëndëra këɓi ɓëranjëm. Ata oŝëxwëra or ex yo bani fakënd. Anëcët nëcët baɓi ɓëte ɓëyël ɓëranjëm gër ɓela, abaɓi seɓ na eni yeƴan gayik aye nang bano. ");
INSERT INTO bsc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Në ecan ijo, mëɗ-mëɗ fo ɓayi bax ga xani ko Yesu do nacëta ko exo calex. ");
INSERT INTO bsc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ata Simoŋ, gë ɓoŝandaw̃ këno ŝalarand. ");
INSERT INTO bsc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","And wat këno aŋ, re këni: «Ɓela ɓën ɗek wëj fo këni ŝaland!» ");
INSERT INTO bsc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɓarikan Yesu yaka këɓi: «Ƴene gër ɓëngol ɓënd ler ro, me pemërax end Kaxanu eŋ gayik në eŋo ƴowaxënëgu këme.» ");
INSERT INTO bsc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mondako baxo sëfërand ebar ed Galile el, gër ed ex yo, do baxo femërand end Kaxanu eŋ gër ɓaciw̃ ɓacaleya. Ɓëte anëcët baɓi nëcëtënd ɓëyël ɓën gër ɓela. ");
INSERT INTO bsc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Akey amat, ar gë ameỹ sëka baŋo na Yesu. Ga foxi ko, xara këŋo: «Angëmëne aỹandi ỹandi ki, axor këƴ xor eƴe mënën me pak!» ");
INSERT INTO bsc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ga xaỹënan këŋo Yesu, h̃ëmba këŋo do re ko: «Aỹandi ỹandi ke, mënël!» ");
INSERT INTO bsc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ameỹ aŋ ŝan këŋo ataŋ do kwël w̃ën ko. ");
INSERT INTO bsc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ata Yesu ga këŋo xëŋa, re ko: ");
INSERT INTO bsc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Cësinalil ɗe endeƴ eŋo. Yel exi nëkonëx aŝaɗaxan an. Do diyiɗ ŝaɗaxa ir angunëtan in ang re ko Moyis ak, mëŋ këni nangëraxën ɓela ɓën osede oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɓarikan ala ajo, sam ga ŝapër këni na, ỹana ko ko reƴarand gër ed ko ƴe yo mëne Yesu fakën këŋo. Në eŋo ɓayik Yesu abaxo xam na exo ŋat në angol wat-wat ir ɓela. Në er tëɓ fo baxo sëlënd do ɓela ɓën beɓët yo beɓët bani xanirawënd, ɓura-ɓura eno kacëra. ");
INSERT INTO bsc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ga rik ɓakey, Yesu ɓaka ko gër Kafarënawum. Ata nangëra këni ɓela ɓën mëne anëka ɓakaw ko gër iciw̃. ");
INSERT INTO bsc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɓarërëgu këni ɓëranjëm ŋëŝ gër ebët xali këni nëñërënd. Do Yesu këɓi felërand end Kaxanu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ata h̃atëgu këni ɓela ɓënax ga lëɓiw këno aseỹik. ");
INSERT INTO bsc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ga ŝënd këni gër ebët, sëkwan këni eno ŋateli ŋëŝ gër Yesu. Sënga këni ƴaŋ ejur ed aciw̃ and gër ed ebaxo Yesu el, do yëla këno gë ebën el aseỹik an. ");
INSERT INTO bsc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ga wat ko Yesu mëne ɓela ɓëjo axwëta xwëta këno, fel këŋo aseỹik an: «Asëñiw̃ën, wëno anëka seɓan këmi ɓeñëŋënax ɓendeƴ ɓeŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ga wël këno ɓëŝalen ɓër ỹëpara bax lëf na ɓën, këni yëlarand: ");
INSERT INTO bsc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Wëni ala ajo inew̃a ko yeƴanaxënd mondako? Në ecir eŋo ɗe Kaxanu! Noỹo wa xorëk eteɓan ed ɓeñëŋënax el angëmëne ax gi ex na Kaxanu gaɓat?» ");
INSERT INTO bsc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ataŋ ga nang ko Yesu gë onden ondexëm oŋ, ang bani yëlarand ak, w̃ëka këɓi: «Inew̃a kën yëlaraxënënd mondako gër ow̃ëkw orewën? ");
INSERT INTO bsc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Inew̃a saxëk? Mo pel aseỹik an mëne anëka seɓan këmo ɓeñëŋënax ɓendexëm ɓeŋ nde gë mo pel: “Wëj kanil, eƴ ɗëkw ebën edeƴ el do eƴ maỹi?” ");
INSERT INTO bsc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ɓarikan en nangaxën mëne wëno Asëñiw̃ ar ala an aŝot ŝot këme or gapak or mëni teɓanënd ɓela ɓën ɓamena ɓandeɓën ɓaŋ gër ebar ro, ");
INSERT INTO bsc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ga re këme wëj aseỹik an, kanil, eƴ ɗëkw ebën edeƴ el do eƴ maỹi!» ");
INSERT INTO bsc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ataŋ xani ko xwiriŝ aseỹik an, lëkw ko ebën el do kwël ŝan ko, ɓela ɓën ɗek wat këno do ŝarandëra këɓi xali. Ga këno ŝëkwa Kaxanu, këni rend: «Awa endeƴ endako rako eŋ, elod ala ax wat na.» ");
INSERT INTO bsc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","And ɓaka ko Yesu gaŝëxe gër ɓëŋa ir anjer and gër ebar ed Galile aŋ, xetax këno amëxwër atëm and ɓela. Ata këɓi sëƴalirand end Kaxanu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga h̃ata ko osëƴali ol, xani ko na do kwël ko ƴend. Wat këŋo Lewi, asëñiw̃ ar Alëfe, ga ỹëpa ko gër aciw̃ and ɓësëf ɓër ŝagale. Fel këŋo: «Wëj, tëfëguye wëno!» Ata xwiriŝ Lewi, sëf këŋo kwël. ");
INSERT INTO bsc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ga xucak eŋo, Yesu gë ɓësëfan ɓërexëm ɓën këni ƴambërand gër iciw̃ ind Lewi gë ɓësëf ɓër ŝagale ɓën do gë ɓëw̃endëran ɓëranjëm. Gër enga end ɓela ɓëjo mbaŋ ebani ɓër baŋo sëfënd Yesu ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga wat këno ɓëŝalen ɓër ebax Ofariseŋ ɓën ga këni ƴambëra gë ɓësëf ɓër ŝagale do gë ɓëw̃endëran ɓën, w̃ëka kënëɓi ɓësëfan ɓën: «Asëƴali arewën an, inew̃a këni ƴambëraxënënd gë ɓësëf ɓër ŝagale do gë ɓëw̃endëran ɓën?» ");
INSERT INTO bsc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ga wël ko Yesu, yaka këɓi: «Ɓëŝëxwëra ɓën kë ƴend gër ed exo axora, ax gi ex na ɓëɓëngw ɓën. Mëŋ ex wëno, ɓela ɓër kë w̃endërand ƴow këme mëni mac, ax gi ex na ɓër ŝenene.» ");
INSERT INTO bsc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ɓësëfan ɓër Ŝaŋ Batis ɓën do gë ɓër Ofariseŋ ɓën asiw̃i bani siw̃ind. Ata akey amat, ƴow këni gër Yesu do w̃ëka këno: «Ɓësëfan ɓër Ŝaŋ Batis ɓën do gë ɓër Ofariseŋ ɓën asiw̃i këni siw̃ind. Inew̃a ɓayik ani tiw̃ixënënd na ɓëreƴ ɓën?» ");
INSERT INTO bsc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ata Yesu yaka këɓi: «Asiw̃i nde këni siw̃ind ɓër këŋo laŋëtënd ŝambenjar ir kë ỹërënd ɓën gër ekana? Ax gi ex na nde gër ga nëka këni yo gë mëŋ ani kor na eni tiw̃i? ");
INSERT INTO bsc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɓarikan yatir këni ŝapër gë icën iŋo, asiw̃i këni siw̃i. ");
INSERT INTO bsc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Këdi kë h̃esi kaŝ anjëm akarëk aŋ, ala ax kaɗënd na gë anjëm angaŝax. ");
INSERT INTO bsc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɓëte gër ɓamote ɓakarëk ala cëlënd na ngoƴ ingaf gayik and ỹana eñën aŋ ata kë fëtin, do ngoƴ iŋ gë ɓamote ɓaŋ ex nemi. Ax gi ex na nde në ɓamote ɓangaŝax këni ŝëlënd ngoƴ ingaf iŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yatir akey and eteyëta baxo xucand Yesu në ocënga od gër ed sëg bax bële. Ata ɓësëfan ɓërexëm ɓën këni w̃iŝand ɓanjëra ɓaŋ do këni ƴakënd. ");
INSERT INTO bsc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ata Ofariseŋ ok w̃ëka këno Yesu: «Inew̃a këni rixënënd ɓësëfan ɓëreƴ ɓën er ɓayik ax ñap ex na yatir akey and eteyëta in?» ");
INSERT INTO bsc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yaka këɓi: «Er ri baxo Dafid ga ɓot këɓi enjo eŋ mëŋ gë ɓër enga endexëm ɓën, amëd and ebaxo Abiyatar, aŝaɗaxan alëngw aŋ, wën elod an pën ex na nde? ");
INSERT INTO bsc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Amëd and ebaxo Abiyatar, aŝaɗaxan alëngw aŋ, ax gi ex na nde Dafid alil lil baxo lëf gër Aciw̃ and Kaxanu ƴambëgu ko mburu ind ỹap këɓi eƴamb ɓëŝaɗaxan fo iŋ xali ŝet këɓi ɓër enga endexëm ɓën?» ");
INSERT INTO bsc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ga h̃ata ko eŋo, ɓaŝ ko ɓëte: «Në end ala rixën ko Kaxanu akey and eteyëta aŋ, ɓari aŋo di ex na ala an në end akey and eteyëta. ");
INSERT INTO bsc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mëŋ ex wëno Asëñiw̃ ar ala an ex axwën ar akey and eteyëta an.» ");
INSERT INTO bsc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ata h̃atëguk akey and eteyëta acëxe, Yesu ƴe ko gër aciw̃ acaleya, sëk këŋo ar gë ataxan ateỹik. ");
INSERT INTO bsc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ata ɓëŝalen ɓën do gë ofariseŋ ok këno sitinalind Yesu ba afakën këŋo fakën gë akey and eteyëta aŋ eni cotaxën end këno nagaŝanaxën. ");
INSERT INTO bsc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ata Yesu fel këŋo ar gë ataxan ateỹik an: «Kaniw eƴ kwëŝa mërëxand ro!» ");
INSERT INTO bsc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aŋo re ko Yesu: «Inew̃a ỹapëk gë akey and eteyëta aŋ? Edi ed enjekax nde ba edi ed eñëŋënax nde? Epexën and ala nde ba eɗaw̃ ed ala nde?» Ɓarikan ɓën ɗek ŝësinara këni ƴem. ");
INSERT INTO bsc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ata Yesu nëkon këɓi gë oxoỹ fo, aŋo nëngan bana end ow̃ëkw or farëɗaɗik oreɓën eŋ. Fel këŋo ar gë ataxan ateỹik an: «Yënël ataxan aŋ!» Ga yën ko, ataŋ ɓëngwëk ataxan aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ofariseŋ ok ŝan këni eni wëlërëx gë od Erod ang këni ri eno ɗaw̃axën Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ata Yesu gë ɓësëfan ɓërexëm ɓën ƴe këni ler gër ɓëŋa ir anjer. Na ɓarërëgu këni ɓela ɓëranjëm ga xaniraw këni elod gër ebar ed Galile, gër ed Yude ");
INSERT INTO bsc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","do xali gër angol and Yerusalem. Na fo bani ɓëte ɓër xaniraw bax gër ebar ed Idume, ekeg ed yeɓ ir Yurëdeŋ el, xali gër owar or Tir do gë Sidoŋ. Amëxwër aŋo er ƴow bani gër Yesu ga bani wëlëxënd ɓeɓër baxo rind ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ata Yesu fel këɓi ɓësëfan ɓërexëm ɓën eni tëkaliw ikuluŋ exo ñëpaxën polo këdi këno fimelira ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Enimin, ga baɓi fakënënd ɓela ɓëranjëm bano raɗënaxënënd ɓëŝëxwëra ɓërëmar eno kwixwëtaxën. ");
INSERT INTO bsc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ɓangoc ɓañëŋënax ɓaŋ, areɓ banëɓi reɓënd ɓela ɓër lil banëɓi ɓën gër osapar or Yesu eni keỹaxën: «Yama wëj ga ex nde Asëñiw̃ ar Kaxanu an.» ");
INSERT INTO bsc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɓarikan Yesu mbaŋ baɓi xeỹënaxënënd eni teɓ edeƴa ed noỹo hi ko el. ");
INSERT INTO bsc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ata Yesu ƴe ko ƴaŋ në etënd. W̃ac këɓi ɓër ỹandi baŋo ɓën do ɓën yaka këno. ");
INSERT INTO bsc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yata këɓi epëxw gë ɓëxi eni gi oparëxanda odexëm eno ɗaŋëtarand do eɓi ɗaw̃ëndërand ");
INSERT INTO bsc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","eni pemërand endexëm eŋ do enëɓi nëcëtënd ɓëyël ɓën gër ɓela gë panga ind yël këɓi iŋ. ");
INSERT INTO bsc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɓër yata baɓi ɓën ebani: Simoŋ ir nëngwët baŋo Piyer, ");
INSERT INTO bsc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ŝak gë Ŝaŋ, asëñiw̃ ar Sebede, do gë aɓinëm Ŝaŋ. Ɓën nëngwët baɓi ow̃ac ol: «Bëwanerëges» mëne ngëŋ Ɓër ang ekëman. ");
INSERT INTO bsc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na fo bani ɓëte: Andëre gë Filip, gë Barëtelemi, gë Maco, gë Toma, gë Ŝak asëñiw̃ ar Alëfe, gë Tade, gë Simoŋ, aw̃er an, ");
INSERT INTO bsc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","do gë Yuda Isëkariyot, ar lëxw baŋo Yesu an. ");
INSERT INTO bsc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","And w̃aỹi këni gër iciw̃ aŋ, ɓela ɓën ɓarërëgu këni gaŝëxe xali hi këni amëxwër atëm. Yesu gë odexëm ani cot bana amëd and këni ỹëpa eni ƴambëraxën. ");
INSERT INTO bsc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ga wël këni endeƴ eŋo ɓërexëm ɓën, ƴow këni eno tëra gayikako bani yëland mëne: oŝen ỹanar këni. ");
INSERT INTO bsc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ata ɓëŝalen ɓër xaniw bax gër Yerusalem ɓën re këni: «Yama Ỹëngëtir, emun end ɓëyël eŋ ga lil këŋo nde. Gë panga indexëm iŋ këɓi nëcëtënd ɓëyël ɓën gër ɓela.» ");
INSERT INTO bsc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ata Yesu w̃ac këɓi eɓi pelëra gë ɓapënëtal ɓaŋo do ko rend: «Mondake hik endeƴ eŋo? Sindan nde këŋo w̃aỹënd Sindan? ");
INSERT INTO bsc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Angëmëne ɓër ebar eɓat eni merënd, ax gi ex na nde ebar edeɓën el aŝapër kë ŝapër? ");
INSERT INTO bsc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɓëte angëmëne ɓër ekun eɓat eni merënd, ax gi ex na nde ekun elo ayëcar kë yëcar? ");
INSERT INTO bsc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Awa angëmëne Sindan eɓi merelind ɓër ex gër owun orexëm ɓën, alati ko lati. Owun orexëm ol aŝapër kë ŝapër do ex kwët endexëm eŋ! ");
INSERT INTO bsc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ala ax kor na exo ɗil në iciw̃ ind ar gë ojaw̃ do eŋo kandëra napul irexëm in. Afo eŋo ɓon pere, do eŋo kap aye exo yëcaxën iciw̃ indexëm iŋ! ");
INSERT INTO bsc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɗal in këmun felënd, Kaxanu aseɓan ko seɓanënd ɓeñëŋënax ɓeŋ do gë ocir od ŝir këno yo! ");
INSERT INTO bsc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ɓarikan ar këŋo ŝir Angoc Amënëk an, eteɓan axo cot na: Gayik anëka ri ko amena and din ir din aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ga bani rend mëne gë angoc añëŋënax hi ko yeƴanaxën baxo mondako Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ata na gër ed bani yeƴandëra mondako, h̃atëgu këni ɓoɓinëm ɓor Yesu do gë nëm. Ga xwëŝaw këni fac, law̃ën këno ala eŋo macëgu. ");
INSERT INTO bsc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɓon ỹëmb bani ɓër xeta bano lëf gër aciw̃ ɓën. Ga ỹëpara këni jeƴ, lilëgu ko ar law̃ënëgu bano an, re ko: «Yakalëɓi fac norix gë ɓoɓinëx, ga këni ŝaland!» ");
INSERT INTO bsc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yaka këŋo: «Noỹo ngwa ex nëma do noɓën ex ɓëmaỹe ɓëndam ɓëŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ga nëkon këɓi ɓër xeta baŋo ɓën, re ko: «Nëkoɗëɓi nëma do gë ɓëmaỹe ɓëndam ɓëŋ. ");
INSERT INTO bsc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ar kë rind er ỹandi këŋo Kaxanu an, ajo ex aɓaỹe do gë nëma.» ");
INSERT INTO bsc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ata Yesu këɓi sëƴalirand gaŝëxe end Kaxanu eŋ gër ɓëŋa ir anjer and Galile. Ga xeta këno amëxwër atëm, Yesu fëra ko polo në ikuluŋ do ỹëpa ko. Ɓela ɓën ɗek xwëŝara këni gër ebar, gër ɓëŋa. ");
INSERT INTO bsc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ata ga këɓi sëƴalira gë ɓapënëtal, nëka ko mbaŋ. Er baxo rend: ");
INSERT INTO bsc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Ɓaxëtin end ala ar nëca bax oneɗ gër oŝënga orexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ga ko yiŝ eneɗa eŋ, mar lapak gër fëña. Ata ƴow këni oŝël ol, hël këni ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mar lapak ɓëte gër aparëfac, gër ed ax ñëmb bana obar, lëgëk ataŋ gayik ax tiw̃ bana. ");
INSERT INTO bsc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","And fëtëk oyat aŋ, h̃ayëk ɗek gayik gë oɗëmbët këm hi bax. ");
INSERT INTO bsc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mar lapak ɓëte ŝit në acëc and gë odëmbën. And lëgëk aŋ odëmbën ok xëŝak, ata sëkwanëk ex dëw̃. ");
INSERT INTO bsc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɓarikan mar lapak ɓëte gër ebar ejekax. Ga lëgëk, rafëk, do rëw̃ëk ɓon: enjëlir emat ofëxw osas, eŋo ofëxw ocongeɓat do eŋo keme.» ");
INSERT INTO bsc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ga h̃ata ko Yesu apënëtal aŋo, re ko: «Awa ar gë anëf an, wëlël exo eŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","And ŝapër këni ɓela aŋ, ɓayi këni Yesu gë oparëxanda epëxw gë oki odexëm ok. Ata w̃ëka këno: «Inecëŋ këƴ sëƴalixënënd gë ɓapënëtal?» ");
INSERT INTO bsc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu yaka këɓi: «Wën fo yël këŋun Kaxanu, en nang end ɗal end ŝonayak end owun orexëm eŋ. Ɓër fac ɓën gë ɓapënëtal fo këni ỹana eni wëlënd. ");
INSERT INTO bsc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mëŋ ex ado eni nëkonënd aye, ani wat na. Ado eni wëlënd, aɓi pëni na, këdi këni nëngwët ola oreɓën ol do eɓi teɓan Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ata re ko ɓëte Yesu: «Angëmëne wën aŋun pëni ex na apënëtal aŋo, mondake këŋun fëni ɗek ɓacëxe ɓaŋ? ");
INSERT INTO bsc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","«Aneɗ an kë neɗënd eyeƴan ed Kaxanu el. ");
INSERT INTO bsc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fëña ir gër ed lapak eneɗa in ex ɓela ɓër sam eni wël eyeƴan elo, ataŋ Sindan exo ƴow exo dëxët ɗek gër ow̃ëkw oreɓën. ");
INSERT INTO bsc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓëte aparëfac aŋ ex ɓela ɓër sam eni wël eyeƴan ed Kaxanu el, gë onënga fo eni ma. ");
INSERT INTO bsc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ɓari ani gi ex na gë oɗëmbët, gogo nde eɓi ƴepan. And këɓi ŝopara aŋ, ba enëɓi cëndën në end eyeƴan elo eŋ, eɓi cena xali eni ɗap caw. ");
INSERT INTO bsc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓëte odëmbën ok ex ɓër sam eni wël eyeƴan ed Kaxanu el, ");
INSERT INTO bsc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","eni teɓ ocëmu od aniyan ok, gë oñandi od napul ok, do gë oñandi od eman ok ex këŝa xali ex tëkwan eɓi nëngwët in. ");
INSERT INTO bsc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Do ebar ejekax el ex ɓela ɓër sam eni wël eyeƴan ed Kaxanu ɓën, eni ma eɓi nëngwët do ex cënar gër ow̃ëkw oreɓën: emat ex dëw̃ ofëxw osas, eŋo ofëxw ocongeɓat, do eŋo keme.» ");
INSERT INTO bsc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ga h̃ata ko apënëtal aŋo, w̃ëka këɓi ɓër baŋo ɓaxët ɓën: «Lambo ir fëtën këni in, ah̃oɓ nde këni h̃oɓënd gë enëp? Axwët nde këni xwëtënd ɗila në angaw̃? Ax gi ex na nde në er ƴaŋ këni xaw̃ënd? ");
INSERT INTO bsc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mëŋ ex, er hi bax yo watërëxe in, awati kë wati. Er hi bax yo eŝon-con in, aŝana kë ŝanaya goyat gër angoɓen! ");
INSERT INTO bsc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Awa ar gë anëf an wëlël exo eŋo!» ");
INSERT INTO bsc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ɓaŝ ko ɓëte: «Ɓalëkënaliyindën end kën wëlënd eŋ. Gë acariya and kënëɓi sëƴinënd ɓela aŋ fo këŋun w̃aŝën wën ɓëte, ado sëf eŋun tënd motënd. ");
INSERT INTO bsc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ar w̃ak eyeƴan elo an, Kaxanu aɓaŝën këŋo ɓaŝën owël ol. Ɓari ar h̃ëpëk an, ỹow̃eỹ aŋo pëni na.» ");
INSERT INTO bsc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ŝom ko ɓëte: «Owun or Kaxanu ol er wëndërëk gë end ala ar kë yiŝënd eneɗa gër oŝënga orexëm fo. ");
INSERT INTO bsc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Këŋo raŝënd nde ba këŋo ferënd nde, hik gëmëɗ hik goyat, eneɗa eŋ alëg kë lëg ex daf xarak mëŋ axwën an axo nang na ba mondake. ");
INSERT INTO bsc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ebar el dëŋ këŋo rëca ex ɗëg ang ondës fo, ex daf bële in xali ex neg do ex can, ɓanjëra ɓaŋ ex dëw̃ aye. ");
INSERT INTO bsc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Do and kë sëg aŋ, eni ŋaŝ gë xorom in and kë h̃at ekanara ed ɓeneɗa aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","W̃ëka këɓi ɓëte Yesu: «Gë ine këne w̃atinaliye owun or Kaxanu ol, gë apënëtal and fe?» ");
INSERT INTO bsc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yaka ko mëŋ fo: «Ang enjëlir end atëx and mutarëd fo hik. Ɗek ɓeneɗa ɓend ex gër ebar ro ɓeŋ, enjëlir eŋo xurik ex ɓa. ");
INSERT INTO bsc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ɓarikan and këni neɗ do ex ɗëg aŋ, ata kë rafënd nëmëc ɗek ɓeɓëlëg ɓeɓër ex gër andëɗa ɓën. Ɓenini ɓeŋ ex ɗerëra xali oŝël or gër orën ol eni yëlëra ƴaŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ata Yesu gë ɓapënëtal ɓaŋo sëfëtan baɓi end Kaxanu eŋ ɓela ɓën ang këni xor eɓi pëni ak. ");
INSERT INTO bsc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Abaɓi sëƴali na gë ɓapënëtal këm. Ɓarikan and këni hi gë ɓësëfan ɓërexëm fo aŋ baɓi faỹënënd ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ata kwël yatijo fo, and genëka aŋ, Yesu fel këɓi odexëm: «Kegëtane anjer aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ga fela këɓi amëxwër aŋ, ɓësëfan ɓën w̃ëla këno Yesu gë ikuluŋ ind gër ed ỹëpa baxo iŋ. Na fo bax ɓëte ɓëkuluŋ ɓëcëxe ɓëndanjëm. ");
INSERT INTO bsc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","And hi këni Yesu gë ɓësëfan ɓën gër ngu aŋ, h̃atëguk angoc etëm. Men oŋ kë xaninënd ɓomeŋ ɓomeŋ xali kë rëmbayand ikuluŋ iŋ. ");
INSERT INTO bsc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ɓarikan Yesu mëŋ ƴem këŋo raŝënd gër epoƴ ed kuluŋ gër akwëtaya and gaf. Ata exo nëngëtaxën in, ɓësëfan ɓën xeỹ këni ŝor: «Asëƴali, doro këne nemiye. Wëj axi ɓal ex na nde?» ");
INSERT INTO bsc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ga nëngëta ko na, xeỹan ko ekoc el gë anjer aŋ: «Xey wën, cësinayin!» Ataŋ seɓëk ekoc el do anjer aŋ ɓëte ỹëmëk ataŋ. ");
INSERT INTO bsc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","W̃ëka këɓi Yesu ɓësëfan ɓën: «Oko inew̃a yëdaraxën kën go? Ba wën xali gërëgako ane kwëta ex na nde?» ");
INSERT INTO bsc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aŋo yëdara këni kaŝ-kaŝ xali do këni w̃ëkarënd: «Noỹo ngwa ex ala ajo? Ekoc el do gë anjer aŋ aw̃a kë w̃and er ko re in?» ");
INSERT INTO bsc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu gë ɓësëfan ɓërexëm ɓën, ga xegëta këni anjer aŋ, h̃at këni gër ebar ed Ɓëŝerasa. ");
INSERT INTO bsc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ataŋ ga ŝëpëta ko Yesu gër ikuluŋ, ŝanëgu ko pëlët gër oñeg, ala ar gë ɓangoc ɓañëŋënax do ko ƴend aped-fed. ");
INSERT INTO bsc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Gër oñeg lëg baxo do ala baŋo xor na eno pokëra gë gweƴele-gweƴele. ");
INSERT INTO bsc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ɓand mar aɓon bano ɓonënd eno pokëra gër otaxan do gër osapar gë gweƴele-gweƴele. Ɓarikan mëŋ ɗek baxo xotënd exo nëtëra dëng-dëng odun ok. Ala ax cot bana ojaw̃ od eŋo ɓonaxën ok. ");
INSERT INTO bsc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Er baxo xeỹërand cis wec gër ɓanapëra ɓand gër osënd. Asembaỹënaya baxo sembaỹënayand eman eŋ gë oxaỹ. ");
INSERT INTO bsc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sam ga watëgu këŋo Yesu caw, hër ko aped-fed do foxi ko gër lëngw irexëm. ");
INSERT INTO bsc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Xeỹ ko: «Inew̃a ỹandi ki gër ndam Yesu, wëj Asëñiw̃ ar Ar-hik-ƴaŋ gër orën an? Këla gër ow̃ac or Kaxanu, këreƴe narën na!» ");
INSERT INTO bsc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Baxo xeỹaxënënd mondako, awël baŋo wëlënd Yesu ga ko re: «Wën ɓangoc ɓañëŋënax, canin gër ala ajo!» ");
INSERT INTO bsc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ata Yesu w̃ëka këŋo: «Mondake këni w̃acënd?» Yaka ko: Wëno «Ɓenga sir-sir» këne w̃acënd gayik ɓangoc ɓandanjëm hi këmi. ");
INSERT INTO bsc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ata ɓangoc ɓañëŋënax ɓaŋo këno xarand Yesu këreɓi ŋw̃aỹ na caw, ga xeƴ këɓi eni ŋaw̃ëta ebar ed Ŝerasa el. ");
INSERT INTO bsc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Xarak ler gër etënd gër ed hi bani na, ɓambëxwëbëxw banëɓi xaɗacërand na. ");
INSERT INTO bsc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ata ga wat kënëɓi, ɓangoc ɓañëŋënax ɓaŋ xara këno Yesu: «Cëñëtalëɓo mëni ɗil ɓambëxwëbëxw ɓaŋo!» ");
INSERT INTO bsc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ata w̃a ko Yesu. Na ɓangoc ɓañëŋënax ɓaŋ ga ŝan këni gër ala, lil kënëɓi ɓambëxwëbëxw ɓaŋ. Do ang hi bani gër ed kwëre kwëre ak, ỹëkëta këni gë ongër fo, lapayax këni gër anjer ɗek kece in, noỹelira këɓi ɗek. Er hi bani në ɓambëxwëbëxw owëli oki. ");
INSERT INTO bsc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ga ŝapër këni ɓëxaɗac ɓën, hërëra këni ɓëjo gër angol, ɓëjo gër ocënga. Reƴarax këni end wat bani eŋ. Ata w̃araraw këni ɓela ɓën, ɓura-ɓura gër onang. ");
INSERT INTO bsc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ga h̃at këni gër ed ebaxo Yesu, wat këno ar gë ɓëyël ar ɓenga ɓenga an, ga ỹëpa ko gë ɓanjëm ɓaŋ. Nang këni mëne aye dëŋ ɓakar këŋo onden oŋ. Yëdara këni xali xurik. ");
INSERT INTO bsc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓër wat bax ɗek er ri baxo Yesu ɓën reƴa këni end ar gë ɓëyël eŋ, do gë end ɓambëxwëbëxw eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ata ỹana këni këno xarand Yesu exo dëxëta na gër ebar edeɓën. ");
INSERT INTO bsc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ga ko ɓaka Yesu polo gër ikuluŋ, ar ebax gë ɓëyël an w̃ëka këŋo: «Aw̃a nde këƴ w̃a me gi ar enga endeƴ?» ");
INSERT INTO bsc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ga h̃ëp ko Yesu, yaka këŋo: «Maỹil gër ndewën, gër iciw̃ indeƴ. Tëfëtanëxëyëɓi ɗek er rin ki Axwën Kaxanu in, do ang xaỹënan këŋo wëj ak.» ");
INSERT INTO bsc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ata ala ajo w̃aỹi ko do ko femëraxënd end Yesu eŋ gër Ɓangolepëxw. Areƴara baxo reƴarand ɗek er rin baŋo Yesu in. Do ɓela ɓën ɗek baɓi ŝarandërand endeƴ eŋo. ");
INSERT INTO bsc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu xegëtaw ko amaka ɓaka gë ikuluŋ iŋ. Ɓarërëgu këni gaŝëxe ɓela ɓën gër ɓëŋa ir anjer. ");
INSERT INTO bsc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","H̃atëgu ko na ar bano w̃acënd Yayëros, alëngw ar aciw̃ acaleya an, lapaya ko gër osapar or Yesu ");
INSERT INTO bsc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","do ko rend: «Asëƴali, ɗam ex exo koti endënaw̃ endam eŋ, axara xara këmi, ƴeye eƴo kwëtan otaxan ok exo pakaxën do exo ɗiyaxën.» ");
INSERT INTO bsc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu sëfër këni kwël gë Yayëros. Enga end ɓela eŋ kënëɓi sëfand do këno fimelirand Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Xarak asoxari ar baŋo ƴexayaxënënd oŝat elod ɓëniy epëxw gë ɓëki ebaxëna gër enga eŋo. ");
INSERT INTO bsc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mbaŋ soro baxo gër otaxan od ɓëxora ɓëranjëm, do faỹ baxo ɗek napul irexëm in gër oxora, ɓari axo pak bana. Ado aŋo hi baŋo kaŝ-kaŝ oŝëxwëra ol. ");
INSERT INTO bsc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ga wël ko mëne Yesu kë xucand, nëfënëfa ko xali sëkën këŋo, do xwixwëta ko acuɗ andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Er yëla baxo mëne ga xaỹ xaỹ këŋo exo kwixwëta ɓanjëm ɓandexëm ɓaŋ ata ko fak. ");
INSERT INTO bsc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sam ga xwixwëta këŋo, oŝat oŋ seɓëk ataŋ ecan el. Nang ko gër eman endexëm mëne afak dëŋ fak ko. ");
INSERT INTO bsc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu nang ko mëne panga indexëm ŝanëk na. Ata xwëŝa ko mërëxand gër amëxwër. Nëkona ko gand epoƴ do w̃ëka ko: «Noỹo xwixwëtak ɓanjëm ɓandam ɓaŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yaka këni ɓësëfan ɓën: «Oko, këƴëɓi watënd ɓela ɓën ga këni fimelirand nde këƴ w̃ëkand noỹo xwixwëta ki?» ");
INSERT INTO bsc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ɓarikan mëŋ kwël këŋo ŝaland ar ri bax eŋo an. ");
INSERT INTO bsc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ata asoxari an këŋo rëgënënd anjiỹ aŋ, ga nang ko er hi baŋo in. W̃ara ko lapaya ko gër osapar or Yesu do reƴa ko ɗek ɗal in. ");
INSERT INTO bsc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ɓarikan Yesu re ko: «Awël nde aɓiw̃ën, ga xwëta këƴe fakaxën këƴ. Maỹil gë emëkw eƴemax do pakël oŝëxwëra oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ga ko yeƴan mondako ɓayi baxo Yesu ga h̃atëgu këni ɓela ɓër hiw bax gër iciw̃ ind alëngw ar aciw̃ acaleya an. Re këni: «Awa anëka xor këŋo endënaw̃ endeƴ eŋ! Ine këƴo soroli mama Asëƴali an?» ");
INSERT INTO bsc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ɓarikan ado ga wël baxo eyeƴan elo, Yesu fel këŋo alëngw ar aciw̃ acaleya an: «Këreƴ yëdara na ngëŋ, kwëtale mondako dëŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Gaɓatak axo ma bana eŋo ɗaŋëta gër iciw̃ ind Yayëros angëmëne ax gi ex na Piyer, gë Ŝak do gë Ŝaŋ, aɓinëm ar Ŝak. ");
INSERT INTO bsc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ga h̃at këni gër iciw̃ ind alëngw ar aciw̃ acaleya, Yesu wat këɓi ɓela ɓën ga këni renitara axeỹënd mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","And lil ko aŋ, w̃ëka këɓi: «Ine kën ŝëŝësinënd go? Inew̃a otes od go ok? Itox iŋ araŝ fo raŝ këŋo, axo cës ex na.» ");
INSERT INTO bsc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ata ga wël këno, ỹana këni këno wërëƴand. Yesu nëcët këɓi ɗek ang ebani ak. Ga w̃ac këɓi nëm gë sëm ir endënaw̃ do gë ɓësëfan ɓër laŋëta baŋo ɓën, lil këni gër ed xwët bano itox. ");
INSERT INTO bsc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ata Yesu lëk këŋo itox iŋ gër ataxan, re ko: «Talita kumi», mëne ngëŋ: Endënaw̃ kanil, ga re këme! ");
INSERT INTO bsc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ataŋ kwengweremët endënaw̃ eŋ, xwëŝa ko ceg do ko yëtënd, anëka sëk baŋo ɓëniy epëxw gë ɓëki. Ɓër wat bax eŋo ɓën ŝëg këɓi ɓenjëw̃ ɓeŋ ga xurik aŝaran in. ");
INSERT INTO bsc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu xëŋara këɓi aye ɓëxwën endënaw̃ eni cësinali endeƴ eŋo. Fel këɓi eno yël er ko ƴamb in. ");
INSERT INTO bsc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ata Yesu xani ko na, w̃aỹi ko kwël gër Nasaret, gër ed raf ko. Sëfër këni gë ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","And h̃atëguk akey and eteyëta aŋ, ƴe ko këɓi sëƴalirand gër aciw̃ acaleya. Ɗek ỹëmb bani ɓër oɓaxët ɓën, do ga këɓi ŝarandëra këni w̃ëkarënd: «Feye wa ŝotëgu ko eŋo? Orenik or mondake wa ŝot ko? Do mondake ko rind ɓecarax ɓendako rako ɓeŋ gë otaxan odexëm ok? ");
INSERT INTO bsc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ax gi ex na nde mëŋ ex afika ar otëx an, asëñiw̃ ar Mari an? Ax gi ex na nde ɓoɓinëm ex Ŝak gë Yose, gë Yud do gë Simoŋ? Do ɓëɓinëm ɓëtoxari ɓëŋ cëŋ, ax gi ex na nde gër ndeɓi ro dëŋ exëni?» Ata në eŋo baɓi h̃ëpëgënanaxënënd endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ata yaka këɓi Yesu: «Alaw̃ënel ar Kaxanu an, gër angol andexëm fo këno yafënd, ado ɗek ɗek in gër ɓërexëm do gë ɓër ekun eɓat gë mëŋ ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ata ecarax gematak aŋo mëndan bana exo di na. Ɓëŝëxwëra ɓëfënëpëne fo fakën baɓi ga h̃ëmbara këɓi. ");
INSERT INTO bsc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mondako ŝaran baŋo Yesu end oŋëpëgënan odeɓën eŋ. Ata Yesu ko sëfërand ɓëngol ɓënd ler gër Nasaret ɓëŋ eɓi tëƴalirax. ");
INSERT INTO bsc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","W̃ac këɓi ɓësëfan epëxw gë ɓëxi ɓën, law̃ën këɓi eni ƴe ɓëxi ɓëxi sam ga yël këɓi panga ind enëɓi nëcëtaxënënd ɓangoc ɓañëŋënax iŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Fel këɓi ɓëte eni mëlayand oŝët fo do këreni mëland na: ax gi ex na eƴamb-ƴamb, ax gi ex na ambaɓ, ax gi ex na koɗi gër ɓëmboto. ");
INSERT INTO bsc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɓarikan eni peɗand ɓapeɗ ɓand xalanj, ɓëte këreni cuɗand na ɓacuɗ ɓaki. ");
INSERT INTO bsc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Afel fel baɓi ɓëte: «Gër iciw̃ ind kën h̃at, ɓayiyindën na xali yatir kën xuca. ");
INSERT INTO bsc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɓëte angëmëne en ŋat në angol, do ɓela ɓën eni ŋëp enun kwëtaya in ba eni ŋëp enun ɓaxët in, pëxwëcayin obar od lëkak gër osapar orewën ok en kucaxën. Obar oko ex osede or këɓi ŝëndën ɓela ɓëjo.» ");
INSERT INTO bsc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ga ƴe këni ɓësëfan ɓën, femërax këni gër ɓela end eni nëngwët aniyan andeɓën eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nëcët kënëɓi ɓëyël ɓëranjëm gër ɓela. Ɓëte ɓëŝëxwëra ɓëranjëm banëɓi nëmërand ogu, do bani fakënd. ");
INSERT INTO bsc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Erod, emun eŋ, wël bax er baxo rind Yesu in gayik ow̃ac or Yesu ol mongwëli wëli bax. Ɓërëmar are bani rend mëne Ŝaŋ Batis, ar baɓi ɓuyind ɓela an xaniwëk gër ecës, mëŋ ŝotaxën ko panga ind ko rixënënd ɓecarax iŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na fo bani ɓër bax rend mëne alaw̃ënel Eli xaniwëk gër ecës. Na fo bani ɓëte ɓër bax rend mëne alaw̃ënel ar Kaxanu aɓat, ang ebani akarëk ak, xaniwëk. ");
INSERT INTO bsc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ɓarikan, Erod ga wël ko ɓeŋo ɗek, re ko: «Yama Ŝaŋ Batis ir foɗëtën bamo gaf ga xaniwëk nde gër ecës.» ");
INSERT INTO bsc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erod mëŋ dëŋ re bax eno tëra Ŝaŋ Batis do eno pokëra gë gweƴele-gweƴele lëf gër epëra gayik anëp nëp baŋo ga watar bani gë Erojad, alindaw̃ ar aɓinëm Filip an. ");
INSERT INTO bsc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Enimin, Ŝaŋ Batis mondako baŋo fëlend Erod: «Ax ñap ex na eƴo kan aɓinëx asoxari arexëm an.» ");
INSERT INTO bsc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ata Erojad mbaŋ ŝus baŋo Ŝaŋ Batis do ỹandi baŋo eno ɗaw̃, ɓari abaxo xor na. ");
INSERT INTO bsc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ado Erod ayëda baŋo yëdand Ŝaŋ Batis ga nang baxo mëne ala ar ŝenene ex, aw̃ënëk ex. Mëŋ ɓayik abaŋo seɓ na eno dixëra. Ɗek baxo ŝëndënd and këŋo wël aŋ xarak anëngan dëŋ baŋo nënganënd oɓaxët ol. ");
INSERT INTO bsc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ata Erod ri ko ofëna or ekwitaxën ed akey and rëw̃ këno. W̃ac këɓi gër ñambëran ɓëlëngw ɓën do gë ɓemun ɓend ocoroɗa ɓeŋ, ebar ed Galile el ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ga lilëgu ko aɓiw̃ ar Erojad gër ed ỹëpara bani, w̃an ko xali nëngan këɓi Erod gë ɓër w̃acëraw baɓi gër ofëna ɓën. Ata Erod, emun eŋ, fel këŋo endënaw̃ eŋ: «Mëkale er ỹandi ki yo, wëno ayël këmi yël.» ");
INSERT INTO bsc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ga yaŝar ko ɓaŝ ko: «Er këƴe xara yo ayël këmi yël, ado ex gido mi cet ja mërëxand ebar ed gër ed wun ko ro el.» ");
INSERT INTO bsc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ata ŝan ko endënaw̃ eŋ, w̃ëkaw këŋo nëm Erojad: «Inew̃a këmo xara emun eŋ?» Yaka këŋo: «Karalo gaf ir Ŝaŋ Batis in, ar këɓi ɓuyind ɓela an.» ");
INSERT INTO bsc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ga wërëŝëtaw ko aỹand lëf gër ed exo emun, xara këŋo: «Er ỹandi ke eƴe yëlëgu gërëgako gaf ir Ŝaŋ Batis in polo në inëp.» ");
INSERT INTO bsc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ata emun eŋ hi këŋo këŋ gër emëkw, ŝena këŋo. Ɓarikan ga yaŝar baxo xali wël këno ɓër ofëna ɓën, ax mënd bana eŋo ɗëc endënaw̃ eŋ er xara ko in. ");
INSERT INTO bsc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Emun eŋ law̃ën këŋo ataŋ anëkona arexëm aɓat exo mëlaw gaf ir Ŝaŋ Batis in. ");
INSERT INTO bsc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ƴe ko, foɗëtëgu ko gaf ir Ŝaŋ Batis in gër ed fëra bano do w̃ëlaw ko në inëp. Fëxwën këŋo endënaw̃ eŋ. Endënaw̃ eŋ ŝena ko yëlëx këŋo nëm. ");
INSERT INTO bsc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ɓësëfan ɓër Ŝaŋ Batis ɓën ga wël këni endeƴ eŋo, ƴen këni eman endexëm eŋ gër epëra do w̃ëxëta këno në ỹeg. ");
INSERT INTO bsc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Oparëxanda ok ga ɓakaraw këni gër Yesu, reƴa këni ɗek ɓeɓër riw bani ɓën do gë ɗek end sëƴaliraw banëɓi ɓela eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ata yaka këɓi Yesu: «Awa ƴowën ene nacëtaye në er tëɓ en teyëtax tëkër!» Mbaŋ ebani ɓela ɓër xeta baɓi ɓën: ɓëjo këni ƴend ɓëjo këni h̃atëgund, ax mënd bana ang këni ƴambëra ak. ");
INSERT INTO bsc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yesu gë ɓësëfan ɓën fëra këni polo në ikuluŋ eni nacëtaxën. ");
INSERT INTO bsc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ata ɓela ɓëranjëm wat kënëɓi ga këni ƴe, xwita kënëɓi. Do angol and ex yo bani xanirawënd eni ƴe olëngët, gogo nde ga h̃atët këni. ");
INSERT INTO bsc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","And bani ŝëpëtand gër ikuluŋ aŋ, Yesu wat këɓi ɓela ga ɓarërëgu këni xali hi këni amëxwër atëm. Aŋo xaỹënan këŋo xali gayik er hi bani ang opeỹ od gë axaɗac këm fo. Na sëƴalira baɓi ɓeɓëranjëm xali nëkak. ");
INSERT INTO bsc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ga kë xwëyar ɓësëfan ɓërexëm ɓën sëka këno Yesu do re këni: «Asëƴali, ro gër ed hi këne apuỹ ex do anëka w̃ëɗëk eñan eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pelalëɓi ɓela ɓën eni capërëra gër ocënga, ed ɓëñëpa el, do gër ɓëngol ɓënd ler ro eni yëcërax er këni ƴamb in.» ");
INSERT INTO bsc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɓarikan mëŋ yaka këɓi: «Yëlinëɓi wën dëŋ er këni ƴamb in!» Yaka këno: «Ba mi ƴe mi yëcëgu mburu në ɓatama okeme oki ɓand koɗi nde, mëni ɗëɓaxën ɗek ako?» ");
INSERT INTO bsc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ata w̃ëka ko Yesu: «Ɓamburu ɓanjëgwe wa lëkaya kën? Ƴeyin en nangëgu!» And w̃ëkaraw këni aŋ, yaka këno: «Ɓamburu ɓanjo do gë oxan oxi.» ");
INSERT INTO bsc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aŋo re ko enëɓi pel ɓela ɓën ɗek eni ñëpara ɓëmëxwër ɓëmëxwër gër ondës ocëkët. ");
INSERT INTO bsc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ata ỹëpara këni ɓëmëxwër ɓënd mar ɓela keme, ɓëŋo ofëxw oco. ");
INSERT INTO bsc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu ga w̃eɗ ko ɓamburu ɓanjo ɓaŋ do gë oxan oxi ol, xeŋa ko orën ol do ŝëkwa këŋo Kaxanu. Ga xwët ko, hëbëndër ko ɓamburu ɓaŋ do yël këɓi ɓësëfan ɓën eni cet. Ɓëte mondako fo ŝet baɓi oxan ol xali ŝot këni ɓën ɗek ang ỹëmb bani ak. ");
INSERT INTO bsc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na ƴambëra këni xali w̃ed këni ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ata ɓar këni ɓësëfan ɓën ɓakange epëxw gë ɓaki ɓacaxaken ɓand mburu ind ɓayëta bax ɓaŋ do gë oxan ol. ");
INSERT INTO bsc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ɓër lëɓa baɓi Yesu ɓën er ebani, ɓësoŝan ɓën fo, owëli oco. ");
INSERT INTO bsc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ataŋ ga xucak eŋo, Yesu nëyali këɓi ɓësëfan ɓërexëm ɓën eni ɗëngwa gë ikuluŋ iŋ ekeg ed anjer, gër Betësayida do mëŋ ɓayi ko na eɓi pela ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","And fela këɓi aŋ, ƴe ko ƴaŋ në etënd exo calex. ");
INSERT INTO bsc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ga ŝëlak eñan eŋ, ɓësëfan ɓën h̃at këni gë ikuluŋ iŋ mërëxand ir anjer xarak ekeg elo ɓayiw baxo Yesu gër ebar. ");
INSERT INTO bsc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wat këɓi ɓësëfan ɓën ga ŝopa këɓi ewac el gayik aped-fed gë ekoc etëm bani xasënd gë ikuluŋ iŋ. Emëɗ ekarëk el, Yesu këɓi sëfand do ko wëñënd ƴaŋ gër men ang gër ebar fo. Ga sëk këɓi, ỹandi këŋo eɓi cand. ");
INSERT INTO bsc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","And wat këno ga ko wëñëta ƴaŋ gër men aŋ, ɓësëfan ɓën yëla këni mëne oñeỹ ex, ax gi ex na mëŋ. Ata ses këni ŝor. ");
INSERT INTO bsc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ga këno nëkon, ɓën ɗek ŝëg këɓi ɓenjëw̃ ɓeŋ. Ataŋ yeƴaneli këɓi Yesu: «Kapinayin! Wëno ex, këren yëdara na.» ");
INSERT INTO bsc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","And hi ko polo gër ikuluŋ aŋ, xucak ekoc el. Ata ɓësëfan ɓën ɗek ŝaran baɓi endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gayikwa ỹoweỹ aɓi pëni bana ecarax end mburu eŋ: ga foɗ baɓi. ");
INSERT INTO bsc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ga xegëta këni anjer aŋ, h̃at këni gër ebar ed Genesaret. ");
INSERT INTO bsc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","And ŝëpëta këni gër ikuluŋ aŋ, ɓela ɓën xwita këno ataŋ Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ata w̃ara këni enëɓi mëlaraw ɓëŝëxwëra ɓën monëɓi gër ɓanakaya ɓandeɓën. Motëfelira bano sëfelirand Yesu gand ed ko ƴe yo. ");
INSERT INTO bsc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gër ed ko lil yo, hik ingol, hik angol atëm, hik oŝënga, tar fëña in banëɓi xwëtënd ɓëŝëxwëra ɓën do bano xarand eɓi teɓ eni kwixwëta ndakaŋ ambana and acuɗ andexëm aŋ. Do ɗek ɓër baŋo xwixwëtand ɓën afak bani fakënd. ");
INSERT INTO bsc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Akey amat, Ofariseŋ do gë ɓëŝalen ƴow bax gër Yesu ga xaniw këni gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ata wat kënëɓi ɓësëfan ɓërexëm ɓërëmar ga xoɓa këni gër eƴambëran gë otaxan oɓuyaraxik, mëne ngëŋ neɓarëxe. ");
INSERT INTO bsc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Xarak Ofariseŋ ok do gë Ɓëŝëwif ɓën ɗek abani ƴambëra na neɓarëxe ŝenene otaxan ok, ang rëp bax gër ɓapela ɓand ɓëxarëk ɓëreɓën ak. ");
INSERT INTO bsc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Angëmëne në akwëndaya and gër angol ƴe bani, and këni w̃aỹi gër iciw̃ aŋ din bani neɓarand aye eni ƴambëraxën. Ɓëte mbaŋ e ebax ɓend akarëk ɓend bani fëɓënd ɓeŋ: eneɓ ed onëp, eneɓ ed ofeƴa el do gë ed ɓandun ɓand ƴawale el. ");
INSERT INTO bsc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ofariseŋ ok gë ɓëŝalen ɓën w̃ëka këno Yesu: «Ɓësëfan ɓëreƴ ɓën inew̃a këni liyaxënënd mondako, ga këni ƴambërand gë otaxan oɓuyaraxik, do ani tëfënd na ɓapela ɓand ɓëxarëk ɓëreɓi ɓaŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ata Yesu yaka këɓi: «Ata alaw̃ënel Esayi ɗal re baxo mëne wën ɓëỹëŋënax ɓër kë laɓayand hi kën. Ga ỹëgw ko wa: “Ɓela ɓëjo gë etëỹ el fo këne fëɓënd, Anjëlan andeɓën aŋ caw h̃awëta ke; ");
INSERT INTO bsc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Asoro fo këni sorond cale indeɓën iŋ, Osëƴali oreɓën ol ɓapela ɓand ɓela fo ex”.» ");
INSERT INTO bsc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ata re ko ɓëte Yesu: «Wën, kë ƴepënënd er re ko Kaxanu in do kën fëɓënd ɓapela ɓand ɓela. ");
INSERT INTO bsc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kën ƴepënënd apela and Kaxanu aŋ do kën fëɓënd amërëw̃ëra andewën. ");
INSERT INTO bsc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ga re ko Moyis: “Wëj ala an pëɓëlëɓi norix gë sorix, Ar këŋo xare yo nëm ba sëm ar eɗaw̃ ex.” ");
INSERT INTO bsc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","«Ɓarikan wën këɓi sëƴalind ɓela ɓën: And ki xara ỹeỹ norix ba sorix aŋ, axor këƴ xor eƴo pel mëne gë er ebax eƴo dëcaxën in “Korëbaŋ” ex, mëne ngëŋ Kaxanu yël këƴo. ");
INSERT INTO bsc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ax gi ex na nde në end apela andewën aŋo, ɓela ɓëranjëm anëɓi dëcand na ɓëxarëk ɓëreɓën ɓën? ");
INSERT INTO bsc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ata mondako kën ƴepënënd eyeƴan ed Kaxanu el gë apela and yerët kën gë andewën dëŋ. Ɓëte awata wata kën ɓemenak ɓend ang eŋo ak.» ");
INSERT INTO bsc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu w̃ac këɓi gaŝëxe ɓela ɓën. Ga sëka këno amëxwër atëm, re ko: «Wën ɗek ɓaxëtine ɗe aye eŋun pënixën. ");
INSERT INTO bsc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ỹoweỹ ax gi ex na er kë lil gër ala do eŋo ɓuyarën. Ɓarikan er kë ŝanënd in këŋo ɓuyarënënd. ");
INSERT INTO bsc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Awa ar gë anëf kala, ɓaxëtëlexo eŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","And lil ko Yesu lëf gër iciw̃ aŋ, ga seɓëgu këɓi fac amëxwër aŋ, ɓësëfan ɓërexëm ɓën w̃ëka këno eɓi paỹën apënëtal aŋo. ");
INSERT INTO bsc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ata re ko: «Oko, wën ɓëte an gi ex na nde gë orenik? Aŋun pëni ex na nde mëne ỹoweỹ ax gi ex na er kë lilënd gër ala do eŋo ɓuyarën? ");
INSERT INTO bsc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Er kë lilënd gër ala in gër acël kë h̃atënd, ax gi ex na gër emëkw. Do and kë hi gër acël aŋ, ex paỹërax gër apuỹ.» Ata gë eyeƴan elo w̃asin baɓi Yesu mëne eƴamb ƴamb ed ex yo aw̃ën w̃ënëk. ");
INSERT INTO bsc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Er re baxo mëne er kë ŝanënd gër ala in këŋo ɓuyarënënd. ");
INSERT INTO bsc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gër emëkw ed ala kë ỹanand xali ex can: ɓanjëlan ɓañëŋënax ɓaŋ, gë eñac eŋ, gë orek ol, gë eɗaw̃ër el; ");
INSERT INTO bsc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gë orekar ol, gë aŋana and koɗi aŋ, gë oxeỹ ol, gë njifa ind ɓela iŋ, gë asëk alakirand fo in, gë oƴakërax ol, gë ocir od Kaxanu ok, gë ndafënan iŋ, do gë ofënirëx ol. ");
INSERT INTO bsc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Eyo gër emëkw kë ỹanand ɓeŋo ɗek, do and kë ŝan aŋ eŋo ɓuyarën ala an. ");
INSERT INTO bsc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ga xucak eŋo, Yesu ƴe ko gër ebar ed këni w̃acënd Tir. H̃at ko yir fo në iciw̃ ga xeƴ këŋo eni nangëra ɓela ɓën mëne mëŋ ƴowëk, ɓarikan gogo nde ga nangëraw këni. ");
INSERT INTO bsc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ga wël ko nëm ir endënaw̃ end hi bax gë angoc añëŋënax, ƴow ko lapaya ko gër osapar or Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Asoxari ajo Agërek ebaxo do xaniw baxo gër Fenisi gand ebar ed Siri. Axara xara baŋo Yesu eŋo nëcët angoc añëŋënax aŋ gër aɓiw̃. ");
INSERT INTO bsc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu yaka këŋo: «Cënil pere eni med oɓaŝ ol. Ecemar ed këni ƴambënd oɓaŝ el ax ye ex na eƴëɓi ɗapën ɓëkwërëkwër.» ");
INSERT INTO bsc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Re ko asoxari an: «Eyo ɗal ex Axwën, ɓarikan ɓëkwërëkwër ɓëŋ ɗila gër ed këni ƴambërand oɓaŝ këni w̃eɗarand ɓëngacan ɓënd këni lapëtarand ɓëŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ata re ko ɓëte Yesu: «Awa në end eyeƴan elo ayakali këmi yakali. Maỹil, angoc añëŋënax aŋ anëka ŝan ko gër aɓix.» ");
INSERT INTO bsc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","And w̃aỹi ko asoxari aŋ, sëkëx ko mëne angoc añëŋënax aŋ anëka ŝan ko gër aɓiw̃, alaki fo alaki baxo gër angaw̃. ");
INSERT INTO bsc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ga xani ko na gër ebar ed Tir, ko w̃aỹind ond gër ebar ed Galile oŋ na do ko xucand gër ed Sidoŋ el. Ɓëŋa ir anjer in baxo sëfand gand beɓët ir «Ɓangolepëxw.» ");
INSERT INTO bsc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Fed këni gë ɓela ga këno w̃ëlanëgu apaxo, ar bax yeƴanënd gë ojaw̃ fo. Na xara këno eŋo ŋëmba exo pakaxën. ");
INSERT INTO bsc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","And nacët këŋo caw gër ed hi bani ɓela aŋ, Yesu ŝo ko ɓanëf ɓand apaxo ɓaŋ, gë oɓasa odexëm ok, do wiŝ këŋo gë ɓato ɓaŋ gër aniw̃. ");
INSERT INTO bsc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","And xeŋa ko orën aŋ, yën ko atëm, re ko: «Efata», mëne ngëŋ Ɗëmëtayayin. ");
INSERT INTO bsc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ataŋ lëmëtayak ɓanëf ɓaŋ do lëkwëtarëk aniw̃ aŋ, apaxo aŋ ỹana ko ko yeƴandërand ŝenene. ");
INSERT INTO bsc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu xëŋa këɓi eni cësinali endeƴ eŋo. Ɓarikan axëŋa yo axëŋa ɓela ɓëjo aŋo bani reƴarand kaŝ-kaŝ. ");
INSERT INTO bsc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mokuri xuri bax ang ŝaran baɓi xali bani rend mëne Yesu ɓecaraxik fo ko rind. Ɓanëf ɓand ɓër ɓapaxo ɓaŋ ko lëmëtënd, do ɓaniw̃ ɓand ɓamuma ɓaŋ ko lëkwëtënd eni yeƴandëraxën. ");
INSERT INTO bsc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Akey amat, ɓela ɓën ga ɓarërëgu këni omëxwër otëm, xeta këno gaŝëxe Yesu. Ga wata ko mëne ɓela ɓëjo er ƴamb in ani cot bana, w̃ac këɓi ɓësëfan ɓërexëm ɓën do re ko: ");
INSERT INTO bsc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nëkoyinëɓi ɓela ɓëjo, ɗek ke xaỹënanënd elod ɓakey ɓatas këne sëfarand, ɓari ani gi ex na gë eƴamb ƴamb. ");
INSERT INTO bsc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","And këmëni fela ƴambërarëxe aŋ, ɓon këni sorox gër fëña gayik ɓërëmar caw xaniw këni. ");
INSERT INTO bsc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yaka këno ɓësëfan ɓën: «Mondake wa kënëɓe lëɓaye tëɓ ro?» ");
INSERT INTO bsc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aŋo w̃ëka këɓi Yesu: «Ɓamburu ɓanjëgwe wa lëkaya kën?» Yaka këni: «Ɓanjongëɓaki.» ");
INSERT INTO bsc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Fel këɓi ɓela ɓën eni ñëpara gër ebar. Ga xana ko ko ɓamburu ɓanjongëɓaki ɓaŋ, ŝëkwa këŋo Kaxanu, hëbëndër ko do yël këɓi ɓësëfan ɓën enëɓi cetëra amëxwër aŋ. Ata ŝet këno ala kala aton ɗek ang ebani ak. ");
INSERT INTO bsc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɓëte ɓëngan ebaxëna, ga xana këɓi Yesu, ŝëkwa këŋo Kaxanu do re ko ɓëte enëɓi cetëra ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na ƴambëra këni xali w̃ed këni. Ɓayitarak mburu iŋ në ɓakange ɓanjongëɓaki. ");
INSERT INTO bsc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɓela ɓër lëɓa baɓi na yatijo ɓën er hi bani në owëli onax. Ata ga ƴambëra këni, Yesu fel këɓi eni maỹira. ");
INSERT INTO bsc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ataŋ mëŋ gë ɓësëfan ɓërexëm ɓën fëra këni gër ikuluŋ do kwël ƴe këni gër ebar ed Dalëmanuta. ");
INSERT INTO bsc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Akey amat, Ofariseŋ ƴow baxëna na eno mëkara Yesu. Ga ỹandi këɓi eno ɓon, w̃ëka këno eɓi masin ecarax emat eni nangaxën mëne gër orën xaniw ko. ");
INSERT INTO bsc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ata ƴepandëra këŋo Yesu gër onden ondexëm endeɓën eŋ, yën ko atëm do re ko: «Wën ɓela ɓëjo, inew̃a këne w̃ëkaxënënd mun masin ecarax en nangaxën mëne gër orën xaniw këme? Ɗal in këmun felënd, ecarax an wat na.» ");
INSERT INTO bsc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","And h̃ata ko eŋo aŋ, Yesu ɓaka ko polo gër ikuluŋ eni kegëtaxën anjer aŋ gë ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ɓësëfan ɓën axwëya xwëya bani eni pena mburu iŋ. Amat fo w̃ëlali bani gër ikuluŋ. ");
INSERT INTO bsc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ata re ko Yesu: «Kwëỹëtayin lewir ir Ofariseŋ in do gë lewir ir od Erod in.» ");
INSERT INTO bsc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ata ga wël këni eŋo, ɓësëfan ɓën këni yëland mëne ga bani gë mburu këm yeƴanaxën baxo mondako Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ga wata ko Yesu mëne mondako këni yëland, w̃ëka këɓi: «Inew̃a kën yëlaxënënd mëne ga hi këne mburu këm yeƴanaxën këme mondako? Xali gërëgako aŋun pëni ex na nde er re këme in? Wën ỹow̃eỹ an kaman ex na nde pere? ");
INSERT INTO bsc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ata wën and mokem xem këŋun ɗe ogaf ok. Gë ɓangës hi kën ɓari an watërand na, gë ɓanëf hi kën, ɓari an wëlërand na. ");
INSERT INTO bsc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","An kwita ex na nde gë ɓamburu ɓanjo lëɓa bamëni ɓela owëli oco? Do ɓacaxaken ɓand ɓayëtara baɓi ɓaŋ, ɓakange ɓanjëgwe ɓar ban?» Yaka këno: «Ɓakange epëxw gë ɓaki.» ");
INSERT INTO bsc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ɓëte an kwita ex na nde and lëɓa bamëni gë ɓamburu ɓanjongëɓaki ɓela owëli onax aŋ? Ɓakange ɓanjëgwe fëxw baŋun ɓacaxaken ɓand ɓayëtara baɓi ɓaŋ? Yaka këno: «Ɓakange ɓanjongëɓaki.» ");
INSERT INTO bsc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ata re ko ɓëte Yesu: «Do wën xali gërëgako, ỹow̃eỹ an kaman ex na nde?» ");
INSERT INTO bsc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu gë ɓësëfan ɓën h̃at këni gër Betësayida. W̃ëlanëgu këno na aŝiw̃ëk do xara këno eŋo pakën. ");
INSERT INTO bsc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ata Yesu lëk këŋo aŝiw̃ëk an gër ataxan do las këŋo xali ŝan këni ingol iŋ. Ga xwëŝa këni, wiŝ këŋo gër ɓangës do fëɗ këŋo. And fëɗët këŋo aŋ, w̃ëka këŋo: «Ỹeỹ nde këƴ watënd na?» ");
INSERT INTO bsc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ga xëw̃ëta ko aŝiw̃ëk an, re ko: «Në ewat mëni ɓela ɓën ang ɓatëx fo, ɓari aƴexëra këni ƴexërand ɗe.» ");
INSERT INTO bsc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu fëɗ këŋo gaŝëxe. And feɗët këŋo aŋ, aŝiw̃ëk an fak ko ataŋ, do ko watërand ŝenene. ");
INSERT INTO bsc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu fel këŋo exo maỹi gër ndeɓën, kërexo ɓaka na gër ingol. ");
INSERT INTO bsc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu gë ɓësëfan ɓërexëm ɓën ƴe bax gër ɓëngol ɓënd ler gër Sesare ir Filip. Gër fëña, w̃ëka këɓi: «Gër onang or ɓela, wëno noỹo këni rend hi këme?» ");
INSERT INTO bsc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yaka këni: «Ɓela exëna ɓër kë rend wëj ex Ŝaŋ Batis; ɓëjo wëj ex alaw̃ënel Eli, do ɓëjo ɓëte wëj ex, alaw̃ënel ar Kaxanu aɓat, ang ɓëtëraw këni ak.» ");
INSERT INTO bsc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«Do wën cëŋ, ine këne rend?» Yaka këŋo Piyer: «Wëj ex Afexën an.» ");
INSERT INTO bsc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ata Yesu xëŋa këɓi xali mëne eŋo ala këreno pelëɗ na. ");
INSERT INTO bsc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ata amëd aŋo ỹana baxo Yesu këɓi felënd ɓësëfan ɓën mëne, mëŋ Asëñiw̃ ar ala an, mbaŋ ko soro. Ɓëxarëk ɓër Ɓëŝëwif ɓën, gë ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën aŝus këno ŝus xali eno ɗëxw gër ecës. Ɓarikan gë akey atasën aŋ, exo kani gër ecës. ");
INSERT INTO bsc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kerët felëra baɓi ɓësëfan ɓën ɓeŋo. Ata Piyer ga nacët këŋo këŋo rexërand. ");
INSERT INTO bsc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ɓarikan Yesu ga nëkona ko gand ɓësëfan ɓërexëm, xeỹan këŋo Piyer: «Nacëtaxële fa Sindan, anjëlan andeƴ aŋo and ɓela fo ex, ax gi ex na and Kaxanu!» ");
INSERT INTO bsc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ata and w̃ac këɓi amëxwër do gë ɓësëfan ɓërexëm aŋ, re ko: «Ar ỹandi këŋo exe tëf an teɓëlexo eɓal ed gaf irexëm fo el. Gilexo aw̃elëk ar exo toro mbaŋ në end ow̃ac oram exe tëfaxën. ");
INSERT INTO bsc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ar kë xwël aniyan andexëm an, anemin ko nemin. Ɓarikan, ar kë nemin aniyan andexëm në end ow̃ac oram do në end Atëfëtan an, afexën ko fexën. ");
INSERT INTO bsc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inew̃a këŋo feca ar kë ŝotëra ɗek ɓeɓër hik gër ngwën ro ɓën xarak axo pexën ex na enjëw̃ endexëm eŋ? ");
INSERT INTO bsc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Do gë inew̃a ko nëmb ala an enjëw̃ endexëm eŋ? ");
INSERT INTO bsc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ar këŋo ŝëfënan yo endam, do gë end eyeƴan edam eŋ, mërëxand ir anjex and kë rind orekar do and ɓëw̃endëran aŋo, wëno Asëñiw̃ ar ala an ɓëte aŝëfënan ke ŝëfënan endexëm eŋ yatir këme ɓakaw gë enjaran end Faba eŋ do gë omeleka omënëk ok.» ");
INSERT INTO bsc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ata re ko ɓëte Yesu: «Ɗal in këmun felënd, ang xwëŝara kën ro ako, ɓërëmar ani cës na watërëxe owun or Kaxanu ol ga ƴowëk gë panga itëm.» ");
INSERT INTO bsc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ga xucak ɓakey ɓanjongamat, Yesu w̃ac këɓi Piyer gë Ŝak do gë Ŝaŋ eno ɗaŋëta ƴaŋ në etënd ecakax. Ga h̃at këni, owati or eman end Yesu ol nëngwëtak gë ogës odeɓën. ");
INSERT INTO bsc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","W̃eɗëk ɓanjëm ɓandexëm ɓaŋ kë ỹegënd jing-jing do feŝëk nëmëc ang ko xorëdoxo ala exo peŝën anjëm gër ebar ro ak. ");
INSERT INTO bsc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ata ɓësëfan ɓësas ɓën wat kënëɓi pëlët Eli gë Moyis ga këni xanar gë Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyer ga faɓ këŋo Yesu, re ko: «Asëƴali, ɓon yedox ene ɓayiye ro! Dine ɓaner ɓatas: amat andeƴ, amat and Moyis do aŋo and Eli.» ");
INSERT INTO bsc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyer abaxo nangënd na er ko rend in, gayikwa anjiỹ aŋ lëk baɓi xali xurik mëŋ do gë ɓoŝandaw̃. ");
INSERT INTO bsc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aŋo fedawëk aŋar do laɓ këɓi kwëc. Wëlik oniw̃ ga kë re: «Awa ajo ex ɗe Asëñiw̃ën, ar pëlot gër yomb iram an, ɓaxëtindëno.» ");
INSERT INTO bsc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ataŋ ɓësëfan ɓësas ɓën nëkonara këni jeƴ, wat këno Yesu gaɓat. ");
INSERT INTO bsc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ga këni ŝëla etënd el, Yesu xëŋa këɓi mëne ala këreno pelëɗ na er watëgu këni in xali mëŋ Asëñiw̃ ar ala an exo kani gër ecës. ");
INSERT INTO bsc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ga xwëtaya këni gër ow̃ëkw eyeƴan elo, këni w̃ëkarënd ɓën ɓësas er w̃acayak ekani ed gër ecës in. ");
INSERT INTO bsc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ga xucak eŋo, ɓësëfan ɓën w̃ëka këno Yesu: «Inecëŋ këni rend ɓëŝalen ɓën mëne afo exo ƴow pere Eli ɗamana exo ƴowaxënëgu afexën an?» ");
INSERT INTO bsc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu yaka këɓi: «Eyo Eli aƴow ko ƴow exo kanindëra ɓeỹ ɗek. Ax gi ex na nde aỹëgw ỹëgw këni ɓëte mëne wëno Asëñiw̃ ar ala an, aŝus këne ŝus ɓela ɓën do ene torondëra mbaŋ? Ine yëla kën wën? ");
INSERT INTO bsc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gërëgako, nangin mëne Eli anëka ƴow ko, ɓarikan ang ỹëgw këni endexëm ak, w̃ëlaya këno ang ỹandi këɓi ak.» ");
INSERT INTO bsc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","And ɓaka këni Yesu, gë Piyer, gë Ŝak do gë Ŝaŋ gër ed ebani ɓësëfan ɓëŝëxe aŋ, sëk kënëɓi amëxwër atëm and ɓela ga xeta kënëɓi do wat kënëɓi ɓëte ɓëŝalen ga këni ŝampëre gë ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ɓela ɓën ga wat këno Yesu, ŝaran këɓi ɓën ɗek do këni xaŝërënd endexëm eŋ eno cëma. ");
INSERT INTO bsc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ata Yesu w̃ëka këɓi ɓësëfan ɓër ŝëni baŋo ɓën: «End inew̃a kën ŝampërend gë ɓëjo?» ");
INSERT INTO bsc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yakaw ko gër amëxwër asoŝan aɓat: «E Asëƴali, lëmëta iram in w̃ëlanëgu këmi. Gë angoc añëŋënax and kë xanënd oniw̃ lapar këni. ");
INSERT INTO bsc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gër ed ex yo këŋo reɓënd do exo h̃atëndërënd oỹënga oŋ, gë ocupërëŝup ok gër etëỹ xali, exo ŋaỹ cemeŋ. Axara xara këmëni ɓësëfan ɓëreƴ ɓën eno nëcët angoc añëŋënax aŋ, ɓari ano kor ex na.» ");
INSERT INTO bsc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ata re ko Yesu: «Ata wën anjex and ɓela ɓër gë oŋëpëgënan hi kën ɗe. Xali niỹe fa këme ɓayi gë wën? Xali niỹe fa këmun ɓuŋan? Mëlanëgune tan lëmëta iŋ!» Ata w̃ëlanëgu këno. ");
INSERT INTO bsc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","And faɓër këni gë Yesu aŋ, angoc añëŋënax aŋ ỹëngëndëra këŋo lëmëta ijo. Wëc ko gër ebar do ko xënëcëtarand gë ocupërëŝup ok gër etëỹ. ");
INSERT INTO bsc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na ex Yesu w̃ëka këŋo sëm ir lëmëta: «Elod niỹe ko hind mondako?» Yaka ko: «Elod imeja. ");
INSERT INTO bsc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eŋo ɗaw̃axën, angoc añëŋënax aŋ alap këŋo lapënd: ɓaŋo gër xoɗux, ɓaŋo gër men. Ɓarikan wëj angëmëne ỹeỹ xor këƴ na, këla kaỹënanëlexi wa, këla dëcalëɓo! Kaỹënanëlexi ɓiyi!» ");
INSERT INTO bsc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yaka këŋo Yesu: «Re këƴ angëmëne ỹeỹ xor këƴ… Gër ar xwëta ke wëno an, ɓeỹ ɗek wëndëk.» ");
INSERT INTO bsc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ataŋ xaka ko sëm ir itox: «Wëno axwëta xwëta këmi. Maraw eƴe dëca wëno ar gë oŋëpëgënan ajo!» ");
INSERT INTO bsc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu wat këɓi ɓela ɓën ga këni w̃araraw ɓura-ɓura endexëm eŋ. Xeỹan këŋo angoc aŋ: «Wëj angoc añëŋënax and kë xanënd oniw̃, canël gër lëmëta ijo ga re këme! Ɓët din këreƴ ɓakaw na.» ");
INSERT INTO bsc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Angoc añëŋënax h̃erëndëra këŋo, ỹëngëndëra këŋo xali lëmëta iŋ do kwël ŝan ko. Ata lëmëta iŋ, ŝet gër ebar, laki ko ang aŝësëk fo. Ɓëranjëm bax rend mëne anëka xoti ko. ");
INSERT INTO bsc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ɓarikan Yesu lëk këŋo gër ataxan. Ga xanin këŋo kwengweremët, itox iŋ xwëŝa ko ceg. ");
INSERT INTO bsc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","And w̃aỹi këni Yesu gë ɓësëfan ɓën gër iciw̃ aŋ, w̃ëkax këno: «Inecëŋ sëkwanaxën këmi monëcët angoc añëŋënax aŋo?» ");
INSERT INTO bsc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu yaka këɓi: «Angoc añëŋënax andako rako aŋ gë cale fo ko ŝanënd!» ");
INSERT INTO bsc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ga xani këni na gër hi ebani, Yesu gë ɓësëfan ɓën ƴe këni cangët ebar ed Galile el. Axeƴ xeƴ baŋo eni nang ɓela ɓën gër ed hi ko. ");
INSERT INTO bsc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ɓësëfan ɓërexëm ɓën baɓi sëƴalirand do baɓi felënd mëne mëŋ Asëñiw̃ ar ala an asëra këno sëra do eno ɗaw̃. Ɓarikan yatir akey atasën axani ko xani gër ecës. ");
INSERT INTO bsc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ayëda bani yëdand Ɓësëfan ɓën eno mëka ba ine ex ekani ed gër ecës. Abaɓi fëni na ine ex eyeƴan elo. ");
INSERT INTO bsc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu gë ɓësëfan ɓën h̃at këni gër Kafarënawum. And hi këni lëf gër iciw̃ aŋ, w̃ëka këɓi: «End inew̃a ban ŝampërewënd gër fëña?» ");
INSERT INTO bsc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ŝësina këni ƴem gayik gër fëña end ba noỹo hik asëfan alëngw an bani xanarëgund. ");
INSERT INTO bsc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","And ỹëpa ko aŋ, Yesu re ko: «Angëmëne ala eŋo ỹandi exo gi alëngw gër enga endam, gilexo aɓemban ar ɗek. Gilexo ɓëte ariyenin ar ɓela ɗek!» ");
INSERT INTO bsc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ata Yesu felaw këŋo itox, xwët këŋo mërëxand, re ko: ");
INSERT INTO bsc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ar këŋo lëkaya yo itox indako rako në end ow̃ac oram, wëno dëŋ lëkaya ke. Ar ke lëkaya an, anëka lëkaya këŋo ɓëte ar law̃ënëgu ke an, ax gi ex na wëno fo lëkaye ke.» ");
INSERT INTO bsc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ga xucak eŋo, asëfan ar bano w̃acënd Ŝaŋ an fel këŋo Yesu: «Asëƴali, ɓiyi ar këɓi nëcëtënd ɓëyël gër ɓela watëgu këmo, xarak axo gi ex na ar enga endeɓi.» ");
INSERT INTO bsc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yaka këŋo Yesu: «Ar kë rind ecarax gë ow̃ac oram an, wën këreno cëɓan na gayik ala ax kor na exo di mondako ɓëte exo cena exe yeƴanan eñëŋënax. ");
INSERT INTO bsc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ar aɓo koỹër ex na an, areɓi ex. ");
INSERT INTO bsc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ar këŋun rëmbën yo men gayik ɓër Kërisët hi kën an, ɗal in këmun felënd, aŝot ko ŝot amaŝën andexëm aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Ɓarikan ar këŋo lënan eñëŋënax aɓat gër ɓër w̃ak endam ado ex gi itox, er feca doŋo eno dëxën angaỹ aŋoxixën and eƴamb, do eno ɗap gër anjer eŋo noỹilexën. ");
INSERT INTO bsc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Angëmëne ataxan andeƴ aŋ ki lënanënd eñëŋënax eŋ, kacal ñot eƴ ɗap! Pecanëlexi eƴ ɗil gër aniyan and din gë ataxan amat gë exi ɓayi tak ɓaki do eƴ ŋat gër xoɗux or ax ɗomind na. ");
INSERT INTO bsc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Fën oỹën ol ani cësënd na, ɓëte xoɗux ol ax ɗomind na. ");
INSERT INTO bsc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Angëmëne sapar ireƴ in ki lënanënd eñëŋënax eŋ, kacal ñot eƴ ɗap! Pecanëlexi eƴ ɗil gër aniyan and din gë sapar iɓat, gë exi ɓayi tak oxi do Kaxanu exi ɗap gër xoɗux or ax ɗomind na. ");
INSERT INTO bsc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Fën oỹën ol ani cësënd na, ɓëte xoɗux ol ax ɗomind na. ");
INSERT INTO bsc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Angëmëne angës andeƴ aŋ ki lënanënd eñëŋënax eŋ, nongoloƴëtël eƴ ɗap! Pecanëlexi eƴ ɗil gër owun or Kaxanu gë angës amat, gë exi ɓayi tak ɓaki do Kaxanu exi ɗap gër xoɗux ax ɗomind na ");
INSERT INTO bsc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Fën oỹën ol ani cësënd na, ɓëte xoɗux ol ax ɗomind na. ");
INSERT INTO bsc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gayikwa ala ar ex yo ang ongal fo ko sëk gë xoɗux ol. ");
INSERT INTO bsc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ongal oŋ er ŝenene ex, ɓarikan and kë xac aŋ, mondake kë ỹëw̃ gaŝëxe? Ñëwël ex ola orewën ol ang ongal fo en cotaxën aketëxeta aŋ gë ɓela ɓëŝëxe ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ga xani ko na, ko ƴend ond gër ebar ed Yude oŋ, ekeg Yurëdeŋ in. Ata ɓarërëgu këni gaŝëxe ɓela ɓën, ɓamëxwër ɓamëxwër, do xeta këno. Do mëŋ ang w̃ër baŋo ak, këɓi sëƴalirand end Kaxanu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ata Ofariseŋ ok ỹandi këɓi eno di atëƴ. Ga sëka këno, w̃ëka këno: «Aỹap nde ỹapëk asoŝan eŋo pela alindaw̃?» ");
INSERT INTO bsc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu yaka këɓi: «Inew̃a fel këŋun Moyis?» ");
INSERT INTO bsc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Re këni: «Moyis ga re ko mëne icën iŋ ñëgwënëleŋo alindaw̃ kayëta ir acapëra eŋo pelaxën.» ");
INSERT INTO bsc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aŋo re ko Yesu: «Në end emëŝ endewën eŋ, ỹëgwënaxën këŋun apela aŋo. ");
INSERT INTO bsc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ɓarikan and ỹanak ngwën aŋ, and ɓaƴ këɓi Kaxanu ɓela aŋ, er ri baɓi asoŝan an gë asoxari an. ");
INSERT INTO bsc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mëŋ ex asoŝan an afo eɓi ŋaw̃ëta nëm gë sëm, do eni ɓar gë alindaw̃. ");
INSERT INTO bsc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ɓën ɓëxi ɓër ỹërërëk ɓën eni gi eman emat, ani bo na gaf gë gaf. ");
INSERT INTO bsc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mëŋ ex, Kaxanu and këɓi ɓar eñër asoŝan gë asoxari aŋ, ax ñap ex na ala eɓi capëreli.» ");
INSERT INTO bsc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","And ɓaka këni gër iciw̃ aŋ, ɓësëfan ɓën w̃ëka këno Yesu eɓi paỹën endeƴ eŋo. ");
INSERT INTO bsc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ata re ko: «Asoŝan ar këŋo fela yo alindaw̃ do eŋo ñër asoxari aŝëxe, në emenan eŋo asoxari aỹanar an gayik orekar këni rind gë axinëm an. ");
INSERT INTO bsc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɓëte angëmëne asoxari eni capër gë icën indexëm iŋ do exo ƴe eŋo ñërëx asoŝan aŝëxe, në emenan eŋo asoŝan aỹanar an gayik orekar këni rind gë axinëm an.» ");
INSERT INTO bsc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɓela w̃ëlaw baɓi na oɓaŝ gër Yesu eɓi calen mokwëtan otaxan ok. Ɓarikan ɓësëfan ɓën xeỹënaxën kënëɓi. ");
INSERT INTO bsc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ata xoỹ ko Yesu ga wat eŋo. W̃ac këɓi ɓësëfan ɓën, re ko: «Teɓinëɓi oɓaŝ ol eni ƴow gër ndam, kërenëɓi pëng na gayik ɓër hik ang oɓaŝ ak ɓën xwënëk owun or Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ɗal in këmun felënd, ar ax ma ex na owun or Kaxanu ol ang itox fo an, axo ɗil na gër owun olo.» ");
INSERT INTO bsc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ata Yesu ga w̃egara këɓi na oɓaŝ olo, ŝalendëra këɓi mokwëtan otaxan ok. ");
INSERT INTO bsc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ata ga ko ƴe Yesu, asoŝan aɓat sëf këŋo gë ongër fo, lapaya ko mopoxi gër osapar orexëm do w̃ëka këŋo: «Asëƴali ar ŝenene, pelële ine ỹapëk me dind me cotaxën aniyan and din aŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu yaka këŋo: «Inew̃a këƴe w̃acaxënënd ar ŝenene? Kaxanu gaɓat ex ar ŝenene an, ala ar ŝenene ax gi ex na. ");
INSERT INTO bsc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ax gi ex na nde anang nang këƴ ɓapela ɓaŋ: “Këreƴo ɗaw̃ na ala, këreƴ dina orekar ol, këreƴ deka na, këreƴo nëgwëŝan na ala, ɓëte këreƴo menan na ala, pëɓëlëɓi norix gë sorix?”» ");
INSERT INTO bsc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yaka ko ala ajo: «Asëƴali, elod icambenjar sëf këme ɓapela ɓaŋo ɗek.» ");
INSERT INTO bsc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ata ga nëkon këŋo, Yesu xëɓënan këŋo end ala ajo eŋ. Fel këŋo: «Emat ɓayi ki. Ƴel eƴ pan ɗek acota andeƴ aŋ eƴëɓi yëlëra koɗi in ɓëxaỹënaxik, ata këƴ ŝot napul isëm ƴaŋ gër orën. And këƴ ri ko mondako aŋ, ƴowëɗ eƴ gi asëfan aram.» ");
INSERT INTO bsc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɓarikan ala ajo ga wël ko eyeƴan elo, ỹëŋënin ko dëxas in do kwël ƴe ko gë oxoỹ fo gayik ar gë napul isëm ebaxo. ");
INSERT INTO bsc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ga nëkon këɓi jeƴ ɓela ɓën, fel këɓi ɓësëfan ɓërexëm ɓën: «Awa ɓër gë napul ɓën ɓon këɓi ƴëka eni ɗilaxën gër owun or Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ata ɓësëfan ɓën wëlandëra këɓi ga wël këni eyeƴan elo. Ɓaŝ ko ɓëte Yesu: «Oɓaŝ oram, ata ɓër gë napul ɓën ɓon këɓi ƴëka eni ɗilaxën gër owun or Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gelemba saxëk exo kuca gër imëd ind icëkwër gë exo ɗil ar gë napul an gër owun or Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ga wël këni ɓëte eŋo, ɓësëfan ɓën wëlandëra ɓëte këɓi kaŝ kaŝ do këni w̃ëkarënd: «Do noỹo ngwa kë xor exo pex?» ");
INSERT INTO bsc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ga nëkon këɓi gaŝëxe, yaka ko: «Gër Kaxanu ɗek wëndëk, ɓari gër wën ɓela ax mënd ex na.» ");
INSERT INTO bsc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aŋo re ko Piyer: «Nëkoɗ ɓiyi ga seɓëraw këmi ako ɗek sëfaxën këmi wëj.» ");
INSERT INTO bsc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu yaka këŋo: «Ɗal in këmun felënd, ar këɓi seɓëgu gër iciw̃, nëm gë sëm, gë ɓoɓinëm gë oɓaŝ orexëm do gë ocënga odexëm në end ow̃ac oram, do në end Atëfëtan andam eŋ, gë tëkër ak axo kaỹën na. ");
INSERT INTO bsc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ata gërëgako dëŋ ko ŝot ɓakëlëbëd keme: Ɓëciw̃, gë ɓëmaỹe ɓëtoŝan, gë ɓëmaỹe ɓëtoxari, gë onëma odanjëm, gë oɓaŝ, gë ocënga, do gë toro, ɓëte ecan ecan, ex tëndaw aniyan and din aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɓëlëngw ɓëranjëm kë hi ɓemban do ɓemban ɓëranjëm kë hi ɓëlëngw.» ");
INSERT INTO bsc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ond ƴaŋ gër Yerusalem oŋ bani ƴend do Yesu lëngw bax fëña in. Ɓësëfan ɓën ɗek yëɓu baɓi. Ɓela ɓër baɓi sëfand ɓën ɓëte ayëdara yëdara bani. Ata Yesu w̃ac këɓi eno tëka gaŝëxe ɓësëfan epëxw gë ɓëxi ɓën eɓi nangën er këŋo h̃atënëgund in. ");
INSERT INTO bsc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Re ko: «Awa nëkoɗ ga këne ƴende ƴaŋ gër Yerusalem. Ala ke lëxwëx na wëno Asëñiw̃ ar ala an gër otaxan od ɓëŝaɗaxan ɓëlëngw do gër od ɓëŝalen. And këne xiti do eɓi ketan ene ɗaw̃ aŋ, ene ɗëxw gër otaxan od ɓër ɓenëng ɓecëxe. ");
INSERT INTO bsc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓër ɓenëng ɓecëxe ɓëjo, ke lëŝëra, ke sëpandëra, ke ŝew̃ëra ɗamana ene ɗaw̃axën. Ɓarikan, and kë xuca ɓakey ɓatas aŋ axani këme xani gër ecës.» ");
INSERT INTO bsc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ŝak gë Ŝaŋ, ɓosëñiw̃ ɓor Sebede, ga sëka këno Yesu, re këni: «Asëƴali, aỹandi ỹandi këɓo ɓiyi eƴëɓo yël er këmi xara in.» ");
INSERT INTO bsc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Re ko: «Inew̃a ỹandi këŋun?» ");
INSERT INTO bsc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yaka këno: «Yëlëlëɓo mi ketëna: aɓat gand liw̃, ajo gand ŝame and këƴ ỹëpa gë enjaran eŋ gër owun oreƴ aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ata re ko Yesu: «Wën an nang ex na er kën xarand in. Axor nde kën xor en ceɓ akalama and toro and këme ŝeɓ aŋ? Ɓëte ayëxw nde kën yëxw enun ɓuyi ang këne ɓuyi ak?» Yaka këno: «Axor këmi xor.» ");
INSERT INTO bsc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Re ko ɓëte Yesu: «Ɗal ex aŝeɓ kën ŝeɓ akalama and këme ŝeɓ aŋ, ɓëte aɓuyi kënun ɓuyi ang këne ɓuyi ak. ");
INSERT INTO bsc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ɓarikan end ene ketëna aɓat gand liw̃ ajo gand ŝame eŋ, ax gi ex na wëno këŋun yël. Kaxanu, ɓër ỹap këɓi ɓën w̃ëxëtan këɓi ɓañëpara ɓaŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ga wël këni eŋo ɓësëfan epëxw ɓën, xoỹën kënëɓi Ŝak gë Ŝaŋ. ");
INSERT INTO bsc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu, w̃ac këɓi ɓën ɗek re ko: «Anang nang kën mëne ɓëlëngw ɓër ɓenëng ɓecëxe ɓën awun këni wunënd gë mbëña gër ɓela ɓër gër owar oreɓën, do ɓësëm ɓën aw̃asin kënëɓi w̃asinënd or gapak oreɓën ol. ");
INSERT INTO bsc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ɓari wën këren dind na mondako gër enga endewën. Ar ỹandi këŋo exo gi ar gapak gër enga endewën an, malexo exo gi ariyenin arewën. ");
INSERT INTO bsc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ɓëte ar ỹandi këŋo exo gi alëngw an, gilexo xaɗëp ir ɓela ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gayikwa wëno Asëñiw̃ ar ala an er ƴow këme mun diyenin do me meɗ aniyan andam aŋ ang acosa and këni fexaxën ɓela ɓëranjëm fo, ame ƴow ex na ene diyenin.» ");
INSERT INTO bsc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu gë ɓësëfan ɓën h̃at këni gër Yeriko. Ga këni xuca angol aŋ, ɓela ɓëranjëm kënëɓi sëfand ɓura-ɓura. Aŝiw̃ëk ar këno w̃acënd Barëtime, asëñiw̃ ar Time, ỹëpa baxëna ler gër fëña do ko xararand. ");
INSERT INTO bsc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ata wël ko mëne Yesu Iɓënasaret h̃atëguk. Na ỹana ko ko xeỹënd: «Yesu, Yesu, Asëñiw̃ ar Dafid, kaỹënanëlexi wa wëno!» ");
INSERT INTO bsc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ata ɓela ɓëranjëm këno xeỹënaxënënd: «Wëji, cësinal fa!» Ɓarikan aŋo ɓaŝ ko okeỹ oŋ: «Asëñiw̃ ar Dafid, Asëñiw̃ ar Dafid, kaỹënanëlexi wëno!» ");
INSERT INTO bsc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ata xwëŝa ko Yesu, re ko: «Macëguno tan!» Ga këno w̃ac, këni rend: «Kapinal eƴ kani, në emac exi.» ");
INSERT INTO bsc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ata xani ko xwiriŝ, lap ko gër ebar acuɗ atëm aŋ do w̃ël ko gand Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ata re ko Yesu: «Inew̃a ỹandi ki mi din?» Yaka këŋo: «Asëƴali, me ciw̃ëta ỹandi ke!» ");
INSERT INTO bsc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ata re ko Yesu: «Awa ga xwëta këƴe ako, ciw̃ëtal!» Ataŋ watëra ko ŝenene do sëf këŋo kwël Yesu gër fëña. ");
INSERT INTO bsc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu gë ɓësëfan ɓërexëm ɓën h̃at këni gër Betëfage do gër Betani, ɓëngol ɓënd ler gër Yerusalem ɓëŋ, ler gër etënd ed gë ɓañarëka. Ata Yesu ga këɓi law̃ën ɓësëfan ɓëxi, ko rend: ");
INSERT INTO bsc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Ƴeyin gër ingol ind gër lëngw, ata këno sëk mokap ipali ind elod ala aŋo ñëpaxën ex na. Pëtëguno ene mëlanëgu. ");
INSERT INTO bsc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Angëmëne ala w̃ëka këŋun ba ine këno fëtaxënënd, yakayiɗën mëne Axwën an ỹandi këŋo. Ataŋ këŋo seɓëtëgu.» ");
INSERT INTO bsc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ga ƴe këni ɓësëfan ɓëxi ɓën, sëk këno ipali iŋ ga xap këno beɗ gër fëña, ler në ebët ed iciw̃. Ata fët këno. ");
INSERT INTO bsc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɓër hi bax na ɓën re këni: «Xey wën, ine kën rind? Inew̃a fëtaxën këno ipali iŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ata yaka këni ang re baxo Yesu ak, seɓën kënëɓi w̃ëla këno. ");
INSERT INTO bsc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","And h̃ateli këno gër Yesu aŋ, laɓëra këni engoỹ end ipali eŋ gë ɓanjëm ɓandeɓën ɓaŋ exo ñëpaxën Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓëte ɓëranjëm rendëra këni tar fëña in: ɓanjëm, do gë opat od fongëtëraw bani gër apuỹ. ");
INSERT INTO bsc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ata xeta këno Yesu: ɓëjo gand lëngw, ɓëjo gand emban. Ga këni ƴe, këni xeỹënd ŝor: «Hosana! Ɓetalexo gë ow̃ac or Axwën ol! Ɓetalexo ar kë ƴowënd an. ");
INSERT INTO bsc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ɓetalex owun or kë ƴowënd ol, owun or axarëk areɓi Dafid ol. Hosana! Awa wëlilex ɗe eŋo xali ƴaŋ gër orën!» ");
INSERT INTO bsc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ga h̃at ko Yesu gër Yerusalem, lil ko gër yangana ir Aciw̃ and Kaxanu. And nëkondëra ko ɗek na aŋ, sëfër këni gë ɓësëfan epëxw gë ɓëxi ɓën ond gër Betani oŋ. Anëka xwëyar bax amëd aŋo. ");
INSERT INTO bsc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga xeyëk, Yesu fëɗar këni enjo eŋ. Ga xani këni na gër Betani eni ɓaka gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wat ko caw andan ga nëtëk aye. Ŝapa ko ngwa exo nang ba arëw̃ rëw̃ëk. Ga h̃at ko, sëk ko tudëŋ opat fo gayik ax ŋat bana nand kë rëw̃ënd ondan na. ");
INSERT INTO bsc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ata re ko: «Ɓëtëdin ala ax kwëca na exo ƴamb odëw̃ërëw̃en odeƴ.» Wël këno ɓësëfan ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu gë ɓësëfan ɓën h̃at këni gër Yerusalem, lëf gër yangana ir Aciw̃ and Kaxanu. Ata ỹana ko këɓi w̃aỹënd ɓër bax fandërand ɓën do gë ɓër bax yëcërand na ɓën. Ỹamëra ko ɓëkwëtaya ɓënd ɓënëmb ɓër koɗi ɓëŋ do gë ɓañëpara ɓand ɓëfan ɓër olëxwëte ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ala abaŋo seɓ na exo mëlarand ỹeỹ na gër yangana ir Aciw̃ and Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","And baɓi sëƴalind aŋ ko rend: «Wën an pën ex na nde er re ko Kaxanu in mëne Aciw̃ and cale and ɓenëng ɓend ɓela ɗek ex? Do wën nëngwët kën emaỹi ed ɓërek.» ");
INSERT INTO bsc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ga wël këno, ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën, këni ŝaland osit or eno ɗaw̃axën. Ɓarikan amëxwër aŋ bani yëdand gayik ɓela ɓën ɗek gër ow̃ëkw baɓi lëkënd osëƴali or Yesu ol. ");
INSERT INTO bsc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","And xwëyarëk aŋ, Yesu gë ɓësëfan ɓërexëm ɓën ŝan këni angol and Yerusalem aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga këni ɓakaw gëɓër, ɓësëfan ɓën wat këni andan aŋ ga h̃aỹëk ɗek gë oɗëmbët ak. ");
INSERT INTO bsc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ata ga xwita ko Piyer er xuca bax në ganëka in, re ko: «Asëƴali, nëkoɗa andan and xare këƴ ganëka aŋ, ɗek h̃aỹëk.» ");
INSERT INTO bsc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yaka ko Yesu: «Kwëtayino Kaxanu! ");
INSERT INTO bsc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ɗal in këmun felënd, ar xwëta këŋo Kaxanu an axor ko xor eŋo pel etënd elo: “Ɓeɗital ro eƴ ɗapayax gër anjer.” Er re ko in ahi kë hi angëmëne aŋo ŋëpëgënan ex na gër emëkw edexëm. ");
INSERT INTO bsc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mëŋ këmun felaxënënd mëne ɗek er kën xara yo gër cale, kwëtayin mëne anëka ŝot kën. Ata ko ri Kaxanu ang xara këno ak. ");
INSERT INTO bsc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ɓarikan and kën xani cale aŋ do en kwita ala fenan këno na oxoỹ, teɓanino eŋun teɓanaxën Sorix irewën ir ex ƴaŋ gër orën wën ɓëte ɓamena ɓandewën ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sorix irewën ir ex gër ƴaŋ orën aŋun teɓan na ɗe ɓamena ɓandewën ɓaŋ, angëmëne wën anëɓi teɓanënd na ɓela ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu gë ɓësëfan ɓën ɓakaw këni gaŝëxe gër Yerusalem, gër yangana ir Aciw̃ and Kaxanu. Yesu ga ko nëkondëra lëf, h̃atëgu këni na ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëŝalen ɓën do gë ɓëxarëk ɓër Ɓëŝëwif ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ata w̃ëka këno: «Kërëŝ wëj gë or gapak or fe këƴëɓi w̃aỹaxënd ɓela ɓën ro? Noỹo wa yël ki or gapak or eƴ dixënënd mondako olo?» ");
INSERT INTO bsc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu yaka këɓi: «Emat fo këmun w̃ëka wën ɓëte. Yakayine ata këmun fel gë or gapak or fe rixën këme eŋo. ");
INSERT INTO bsc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Xoɓuyi or baɓi ɓuyind ɓela Ŝaŋ Batis ol, noỹo wa law̃ënëgu baŋo? Orën ol nde ba ɓela ɓën nde? Yakayine ɗe!» ");
INSERT INTO bsc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ata ɓën këni nëkënëkarënd: «And këne yakaye mëne orën ol law̃ënëgu baŋo, ata exo de ine ɓayik ɓiyi ane kwëta exe na end Ŝaŋ Batis eŋ? ");
INSERT INTO bsc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɓëte and këne yakaye mëne ɓela ɓën law̃ënëgu baŋo, amëxwër aŋ…» Ga banëɓi yëdand ɓela ɓën rexën bani mondako gayik ɓën ɗek w̃a bax mëne Ŝaŋ Batis alaw̃ënel ar Kaxanu ebaxo. ");
INSERT INTO bsc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ata yaka këno: «Ɓiyi ami nang ex na.» Aŋo re ko Yesu: «Wëno ɓëte amun pel na ba gë or gapak or fe këme rixënënd ɓeŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga xucak eŋo, Yesu ga këɓi sëƴali gë ɓapënëtal ɓëlëngw ɓër Ɓëŝëwif ɓën, ko rend: «Mondako ri baxo ala ar gë andëɗa and reseŋ. Ga xece in jeƴ andëɗa and reseŋ aŋ, nac ko gër aparëfac ambëxw and eni karaxënënd omen od reseŋ ok do ri ko ɓëte egaw̃ ed oŝën. And seɓënan këɓi ɓëỹan eni cetërënd gë mëŋ reseŋ in and kë sëg aŋ, ƴe ko kwël ɗamana angol and caw. ");
INSERT INTO bsc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Amëd and kë sëgëdërand reseŋ aŋ, law̃ënëgu këŋo ariyenin aɓat gër ɓëỹan ɓëjo eno yël oŝet orexëm ol gër er rëw̃ bax gër andëɗa and reseŋ. ");
INSERT INTO bsc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɓarikan ga sëra këno ɓëỹan ɓën, ŝew̃ëra këno xali do ŝëñëta këno taxan. ");
INSERT INTO bsc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Law̃ënëgu këŋo ariyenin axinëm. Sam ga h̃atëgu ko, fëmëra këno, ŝirëra këno gë oteɓën seɓën këm. Ga w̃aỹ këno, ɓaka ko ɓëte taxan. ");
INSERT INTO bsc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Law̃ënëgu këŋo ɓëte asasën, law̃ këno. Mondako ɓëtëraw bani ɓëriyenin ɓëranjëm. Ɓarikan, ɓëỹan ɓën rixëra kënëɓi: ɓëjo axëm xali exo tëkwaya; ɓëjo ɓëte alaw̃ momonaw̃. ");
INSERT INTO bsc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Asëñiw̃ arexëm ar pëlot gër yomb irexëm an fo ɓayi baŋo Axwën andëɗa an. Ata law̃ën këŋo ngwa ga yëla ko mëne ɓëỹan ɓën afëɓ këno fëɓ. ");
INSERT INTO bsc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ɓarikan, caw fo ɓayiw baxo ga watëgu këno. Ga w̃acër këni, re ko aɓat: “Yo ajo ex ngëŋ ar kë ɓëteli andëɗa an. Ɗaw̃ënëŋone eɓo ɓayixën andëng aŋ.” ");
INSERT INTO bsc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓëỹan ɓën ga sëra këno na, law̃ këno, do lap këni eman eŋ wëgërëxe yaɓët kece ir andëɗa and reseŋ in. ");
INSERT INTO bsc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Awa mondake yëla kën ko ri axwën andëɗa and reseŋ an? Ax gi ex na nde ata ko ƴow eɓi ɗaw̃ëra ɓëỹan ɓëjo do andëɗa and reseŋ aŋ eɓi teɓënan ɓëŝëxen? ");
INSERT INTO bsc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wën elod an pën ex na nde Oñëgw Omënëk od rek: “Ekaỹ ed ŝus bani ɓëɓaƴ el ɓakan këni xali ri këni ekëla ed aciw̃ el.” ");
INSERT INTO bsc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gër Axwën xaniwëk eŋo do gër ɓangës ɓandeɓi eŝaraxik ex.» ");
INSERT INTO bsc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ata ga wël këni eŋo, ɓëlëngw ɓër Ɓëŝëwif ɓën këni ŝaland eno tëra Yesu ga fëni këɓi mëne ɓën baɓi rend gë apënëtal aŋo. Ɓarikan ga yëda kënëɓi amëxwër aŋ seɓ këno na, do kwël ŝapër këni. ");
INSERT INTO bsc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ga xucak eŋo, ɓëlëngw ɓër Ɓëŝëwif ɓën law̃ën kënëɓi Ofariseŋ do gë od Erod eni tëƴi eno yifa Yesu exo yeƴan er këno cëndënaxën. ");
INSERT INTO bsc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ga h̃at këni, re këni: «Asëƴali, anang nang këmi mëne wëj ar ɗal hi këƴ. Ŝenene fo këƴëɓi sëƴalind ɓela ɓën end Kaxanu eŋ. Wëj ala aƴo yëdand na, aƴ nëkonënd na noỹo ki ɓaxëtënd. Awa gërëgako, pelëlëɓo ngwa ba aỹap nde ỹapëk ŝagale ir Sesar in. Mi meɗënd nde ba mi teɓ emeɗ el nde?» ");
INSERT INTO bsc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ga wata ko Yesu mëne ɓëỹëŋënax ɓër kë laɓayand hi këni, yaka këɓi: «Inew̃a kën ŝaland ene cëndën? Mëlanëgune tan atama and koɗi me nëkon.» ");
INSERT INTO bsc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Fëxwën këno atama amat. Ga xana ko, Yesu w̃ëka këɓi amëxwër aŋ: «Dëxas ir noỹo wa ex gër atama aŋo?» Yaka këni: «Ir Sesar.» «Do ow̃ac ol cëŋ?» Yaka këni ɓëte: «Orexëm ex!» ");
INSERT INTO bsc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aŋo re ko: «Maŝino Sesar er xwën ko in do Kaxanu erexëm in.» Ata ang yaka baxo ak, Ofariseŋ ok do gë od Erod ŝarandëra këɓi xali. ");
INSERT INTO bsc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ata h̃atëgu këni Ɓëŝëwif ɓër kënëɓi w̃acënd Osaduseŋ. Ɓën bax rend mëne ekani ed gër ecës ax gi ex na. Ga sëka këno Yesu, re këni: ");
INSERT INTO bsc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Asëƴali, ɓaxëtël apela and ỹëgwën këɓo Moyis aŋ: “Asoŝan ar këŋo seɓëta alindaw̃ gë itox këm an, aɓinëm dëngileŋo asoxari an eno cotënaxën oɓaŝ ar ŝësëk an.” ");
INSERT INTO bsc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Xarak, ocambenjar ocongoki ebaxëna aminëmëra. Iỹanar in ỹër ko, ŝës ko. Seɓëta këŋo alindaw̃ oɓaŝ këm. ");
INSERT INTO bsc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ata ŝambenjar ixinëm in ɓëteli këŋo asoxari an. Mëŋ ɓëte ŝës ko. Seɓëta këŋo oɓaŝ këm. Mondako fo bax end ŝambenjar isasën eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ŝësëra këni ɓën ɓëcongëɓëxi ɓën ɗek xali gaɓatak aŋo cotën ex na oɓaŝ asoxari ajo. Ata asoxari an ŝës ko mëŋ ɓëte. ");
INSERT INTO bsc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Awa yatir ekani ed ɓëŝësëk cëŋ, alindaw̃ ar noỹo w̃a ko hi asoxari ajo gayikako ocambenjar ocongoki oko aỹër ỹër bano?» ");
INSERT INTO bsc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ata yaka këɓi Yesu: «Ado wën, eɗif ed lif kën el nde. Aŋun pën ex na nde er rek Oñëgw Omënëk in. Ɓëte an nang ex na panga ind Kaxanu iŋ? ");
INSERT INTO bsc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Enimin, amëd and këni xanira ɓela gër ecës aŋ, eñër ax bo na. Asoŝan aŋo cala na asoxari, ɓëte asoxari aŋo ñandi na asoŝan. Er këni hi ɓela ɓën ang omeleka od ƴaŋ gër orën fo. ");
INSERT INTO bsc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","End mëne ɓëŝësëk ɓën axani këni xanind gër ecës eŋ, wën an pën ex na nde gër akayëta and ỹëgw ko Moyis er fel baŋo Kaxanu yatir ŝanayaxën baŋo gër acëc and gë xoɗux in? Ax gi ex na nde mondako re baxo: “Wëno ex Kaxanu ar yata këɓi Abëraxam, Isak do gë Yakob an.” ");
INSERT INTO bsc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kaxanu, Kaxanu ir ɓëɓëngw exo, mëŋ ani terënd na gë ɓëŝësëk. Ata wën Osaduseŋ ok mbaŋ lif kën gër eŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aŝalen ar Ɓëŝëwif wëleli baxëna ecampëre elo. Ga wat ko mëne Yesu ŝenene yaka këɓi Osaduseŋ ok, sëka këŋo, w̃ëka ko: «Pelële ngwa gër ɓapela ɓand Moyis, and fe ex anëngw aŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu yaka këŋo: «And rek: “Ɓaxëtël wëj ar enëng end Isërayel an, Kaxanu, Axwën areɓi an, gaɓat fo hi ko Axwën. ");
INSERT INTO bsc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋanëlo Kaxanu, Axwën areƴ an, Ɗek gë yomb ireƴ ak, gë enjëw̃ endeƴ ak, Ɗek gë panga indeƴ ak, gë aniyan andeƴ ak.” ");
INSERT INTO bsc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«Ɓaxëtël and ɓëtëguk aŋ: “Ɓalindëlexi end ala aŝandax eŋ, ang ki ɓalënd end gaf ireƴ ak.” Ata apela akuca ex na ɓaki ɓaŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ata re ko aŝalen an: «Asëƴali, ɗal reƴa këƴ mëne Kaxanu iɓat fo ex, iŝëxe ax gi ex na. ");
INSERT INTO bsc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ala kala ŋanëlo Kaxanu gë ɗek yomb irexëm ak, gë anjëlan andexëm ak, gë ojaw̃ odexëm ak. Ɓëte ɓalindëlexi end aŝandaw̃ eŋ ang ki ɓalënd end gaf irexëm ak. Edi ed mondako el xucak ɗek ocaɗaxa od momëlën ok do gë ocëxen ok.» ");
INSERT INTO bsc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu ga wat ko mëne ŝenene yaka baŋo aŝalen an fel këŋo: «Wëj ata ɗam gër owun or Kaxanu hi këƴ.» Ɓarikan elod yatijo, gaɓatak abax yëxw na eŋo mëka ỹeỹ. ");
INSERT INTO bsc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Akey amat, Yesu ga këɓi sëƴalira gër Aciw̃ and Kaxanu, w̃ëka këɓi ɓër baŋo ɓaxëtënd ɓën: «Mondake këni rexënënd ɓëŝalen ɓën mëne Afexën an, ejiw̃ ed emun Dafid exo? ");
INSERT INTO bsc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Xarak, Dafid mëŋ dëŋ are baxo rend, ga ỹëm ko gë Angoc Amënëk aŋ: “Axwën an fel këŋo Axwën aram an, ƴow eƴ ñëpa ro gand liw̃ iram, xali mi korën ɓër ŝus ki ɓën eƴëɓi bëñaxën.” ");
INSERT INTO bsc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Nëkoyin mëne Dafid mëŋ dëŋ Axwën këŋo w̃acënd. Mondake cëŋ hi ko ejiw̃?» Ata amëxwër aŋ këno ɓaxëtënd gë onënga fo. ");
INSERT INTO bsc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu ga këɓi sëƴali ɓëte ko rend: «Titinaliyindënëɓi ɓëŝalen ɓën. Monëngan këɓi nënganënd eni ƴexërand gë ɓocuɗ ɓond gëŝëc ɓoŋ, do ɓela ɓën enëɓi cëmarand gër ɓapedëraya. ");
INSERT INTO bsc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Moŋan h̃an këni ɓañëpara ɓand gër lëngw ɓaŋ lëf gër ɓaciw̃ ɓacaleya do ɓand gër ed kë hi ñambëran ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓën xali gër ɓëciw̃ ɓëndeɓën kënëɓi lexëxënd ɓësoxari ɓëseɓëta seɓëta ɓën. Xarak, ɓën watak cale ind aŝak aŝak iŋ enëɓi cëkwaxënënd ɓela ɓën. Mëŋ ex kiti indeɓën iŋ gë pit fo kë ƴëka.» ");
INSERT INTO bsc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ga ỹëpa ko Yesu ler gër akwëtaya and oyël or Kaxanu, këɓi nëkonënd ɓela ɓën ga këni xwët koɗi in. Wat këɓi ɓër gë napul ɓëranjëm ga këni xwët koɗi ir ɓon. ");
INSERT INTO bsc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","H̃atëgu ko na asoxari axaỹënaxik, aseɓëta-seɓëta. Ata xwët ko ɓëtama ɓëki ɓënd ax tëk bana ado biye iɓat. ");
INSERT INTO bsc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ata Yesu w̃ac këɓi ɓësëfan ɓërexëm ɓën do re ko: «Ɗal in këmun felënd, er xwët ko asoxari axaỹënaxik aseɓëta seɓëta ajo gër akwëtaya and oyël in nëmëcak er w̃ëlaraw këni ɗek ɓela ɓëjo in. ");
INSERT INTO bsc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gayikwa ɓela ɓëŝëxe ɓën ga ỹëmb këɓi acota w̃ëlaxënëgu këni er xwët këni in, ɓarikan asoxari ajo ɗek acota andexëm aŋ, do gë er ko ƴambënd exo ɗiyaxënënd in w̃ëlagu ko.» ");
INSERT INTO bsc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ata Yesu gë ɓësëfan ɓërexëm ɓën këni ŝanënd yangana ir Aciw̃ and Kaxanu in. Aŋo re ko asëfan aɓat: «Asëƴali nëkonël ɓameŋ ɓand ɓongaỹ ɓaŋ ang yëlëra këni ak, monje yek ɗe!» ");
INSERT INTO bsc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yaka këŋo: «Wat këƴ nde ɓameŋ ɓand ɓongaỹ ɓaŋo, ado gë ekaỹ geɓatak ax ɓayi na eyëlëtërëxe, ɗek kë yëcar!» ");
INSERT INTO bsc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","And h̃at këni gër etënd ed gë ɓañarëka aŋ, Yesu ỹëpa ko paɓ gë Aciw̃ and Kaxanu aŋ. Ata Piyer, gë Ŝak, gë Ŝaŋ do gë Andëre, ɓën ɓësëfan ɓër ɓayi bax na gë mëŋ ɓën w̃ëka këno: ");
INSERT INTO bsc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Pelëlëɓo wa nand fe kë yëcar Aciw̃ and Kaxanu aŋ? Ɓëte amatinali and fe kë h̃atëgu mi nangaxën mëne ekwët ed ɓeỹ ɗek el h̃atëguk?» ");
INSERT INTO bsc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu yaka këɓi: «Wën titinayin, ala këreŋun yifaɗ na. ");
INSERT INTO bsc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɓëranjëm kë ỹana ex ƴowërawënd gë ow̃ac oram ol, do eni dend: “Wëno ex Afexën an!” do enëɓi nambeli ɓela ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Angëmëne në ewëlëran end olandër gër owar or caw do en wëlënd ɓongëɓër ɓond olandër gër ed lëg kën, këreŋun yëɓuraɗ na gayik ɓetëm ɓendako rako ɓeŋ afo ex ŋatëgu. Ɓari ax gi na pere ekwët ed ngwën el. ");
INSERT INTO bsc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Asakërëra këɓi ỹana eɓi takërërand ɓela ɓën, gë enëng gë enëng, gë ebar gë ebar. Ɓëte obeɓët odëmar arëg kë ỹana ex dëgënd ebar el do ɓela ɓën aŝësëra këni ỹana eni cësërand enjo eŋ. Aỹana fo kë ỹana mondako toro iŋ ang toro ind asoxari ar ỹanar këni orëw̃ ak. ");
INSERT INTO bsc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Wën kapinayin gayik alëxw kënun ỹana enun ɗëxwënd gër kiti në end ow̃ac oram. Axëmëra kënun ỹana enun këmërand gër ɓaciw̃ ɓacaleya në end ow̃ac oram. Aw̃ëlara kënun ỹana enun mëlarand gër ɓëlëngw do gër ɓemun ɓetëm en deƴaraxënënd endam eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Atëfëtan aŋ afo ex gi pere mopemëra gër ɓela ɗek, gë enëng gë enëng. ");
INSERT INTO bsc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nand kënun w̃ëland enun ɗëxwëx gër kiti na, këren dendërand na ang kën yakaɗ ak. Yeƴanindën er kën yëland amëd aŋo in gayik Angoc Amënëk aŋ këŋun ỹana eŋun yëlënd. ");
INSERT INTO bsc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ɓëte alëxwër këni ỹana eni ɗëxwërënd ɓela ɓën gër ecës në end ow̃ac oram: aɓat eŋo ɗëxw imaỹe ind acël amat gë mëŋ iŋ, ajo eŋo ɗëxw itox indexëm iŋ. Ɓëte oɓaŝ ol aw̃ereli kënëɓi ỹana enëɓi merelind ɓëxarëk ɓëreɓën ɓën xali enëɓi ɗaw̃ në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aŝus kënun ŝus ɗek ɓela ɓën në end ow̃ac oram. Ɓarikan ar kë xemëna xali yatir kë xwët endexëm an, afex ko fex. ");
INSERT INTO bsc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","And kën wat ga ŝanayaw ko Aw̃endëran aŝaraxik aŋ gër ed ɓayik ax ñap ex na, ar kë fënënd an pënileŋo aye er re këme in. Ata ar këŋo sëk eŋo gër ebar ed Yude an, gërëxëlexo end osënd eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ar këŋo sëk eŋo ƴaŋ në ejur ed këɓe an, gërëlexo. Kërexo pedanëɗ na ỹeỹ lëf. ");
INSERT INTO bsc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ɓëte ar këŋo sëk eŋo gër oŝënga an, gërëxëlexo. Kërexo ɓakanëɗ na gër iciw̃ acuɗ atëm andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mbaŋ këni soro ɓësoxari ɓër gë ɓacël ɓën do gë ɓër gë ɓëtox ɓënd në oyer ɓëŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Karayino Kaxanu kërex ŋatëgu na toro iŋo amëd and gë aƴem aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ɓakey ɓaŋo, ɓakey ɓand toro itëm ex. Elod ga ri ko Kaxanu ngwën iŋ ala ax wat na toro indako rako iŋ, ɓëte toro indako rako din ax gi na. ");
INSERT INTO bsc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kido Axwën an axo ɓaŝëta bana ɓakey ɓand toro baŋo, ala gaɓatak ax pex dona. Ɓarikan aɓaŝëta ɓaŝëta ko në end ɓela ɓër yata këɓi, në end ɓër fit këɓi gër ebar ro. ");
INSERT INTO bsc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Awa angëmëne ala exo canayaw do exo dend mëne mëŋ ex afexën an, wën këren maɗ na! Ɓëte ala exo canayaw exo dend fën exo afexën an, wën këreno kwëtaɗ na! ");
INSERT INTO bsc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Moñëmb këni ỹëmb ɓëfexën ɓënëgwëŝ ɓën. Ɓëte moñëmb këni ỹëmb ɓëlaw̃ënel ɓënëgwëŝ ɓër kë ŝanayaw ɓën. Ari këni ỹana eni dind ɓecarax, gë ɓërëcaxik enëɓi nambelixën ɓela ɓën. Ata xali gë ɓër yata këɓi Kaxanu ak, nambelidonëɓi kido awënd wënd bax. ");
INSERT INTO bsc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Awa wën titinayin ga nangën këmun ako gana-gana fo ɗek ɓeŋo. ");
INSERT INTO bsc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gë ɓakey ɓand toro ɓaŋo, wur in ɗek kë ŝamëɗan. Eñan eŋ ax yat na, ɓëte facaw̃ in ax peŝ na. ");
INSERT INTO bsc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ow̃al oŋ axwëcëtara kë ỹana ex kwëcëtarawënd, ɗek ɓeɓër gë panga gër orën ɓën kë sëngërëɓëtaraw. ");
INSERT INTO bsc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Amëd aŋo këne watëgu wëno Asëñiw̃ ar ala an ga këme ŝëlaw gë ɓaŋar ɓaŋ, gë panga itëm do gë ɗek enjaran endam eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ata mëni ɗaw̃ën omeleka odam ok eni ƴe: oko apën-eñan, oko acëla-eñan, oko ambataŝ, oko ambëtëɓ. Mondako këne ɓarënëgu ɗek ɓela ɓër yata këmëni ɓën elod gër ed sëlëk ebar, do gër ed sëlëk orën. ");
INSERT INTO bsc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Er këmun sëƴalind ijo, pënileŋun gë apënëtal and andan aŋ. And kë ŝosënd oɗini aŋ do and kë nëtënd opat aŋ, wën anang kë nangënd mëne ecaŝa el ɗam ex. ");
INSERT INTO bsc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Awa andamat fo ex, sam en watënd ɓetëm ɓend fel këmun ɓeŋo ga kë h̃atëgu, nangin mëne ɗam ex me ɓakaw wëno Asëñiw̃ ar ala an. Anëka sëkaw këme xali gër ebët. ");
INSERT INTO bsc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ɗal in këmun felënd, wën an nemira na pere ex ŋataxënëgu ɗek ɓeŋo. ");
INSERT INTO bsc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Orën ol aŝapër kë ŝapër do ebar el ayëcar kë yëcar. Ɓarikan eyeƴan edam el din ir din kë ɓayi. ");
INSERT INTO bsc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Akey aŋ do gë apëxëd and kë h̃atëgu ɓeŋo aŋ, Faba gaɓat nangëk. Omeleka od ƴaŋ gër orën ok ani nang ex na, ɓëte wëno Asëñiw̃ ar ala an ame nang ex na. ");
INSERT INTO bsc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mëŋ ex wën titinayin, perënayin do en calend gayikako an nang ex na niỹe kë hi ɓeŋo. ");
INSERT INTO bsc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Er kë hi ang endeƴ end ala seɓ këɓi ɓëriyenin ɓën gër iciw̃ indexëm fo. Ga ƴe ko kwël ɗamana angol and caw. Ala kala seɓënan këŋo or gapak or ko ỹana exo diyenixënënd, do fel këŋo anëkona ar ebët an kërexo nambinand na. ");
INSERT INTO bsc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Këren nambinand na gayikako an nang ex na nand ko ɓakaw axwën iciw̃ na: ɓamat exo ŋatëgu genëka, ɓamat emëɗ ekarëk el, ɓamat and këni yatand oŝare aŋ, ɓamat gëɓër. ");
INSERT INTO bsc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mëŋ ex kemënayin këdi këmun fënga ga raŝëra këŋun and këme h̃atëgu amëd and ɓayik an yëla bana aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Er fel këmun ijo, ɓela ɗek këmëni felënd: Perënayin!» ");
INSERT INTO bsc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ɓakey ɓaki fo ɓayi bax eɓi ŋat Ɓëŝëwif ɓën Ofëna or Apexa ol, do gë or mburu ind gë lewir këm ol. Ata ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëŝalen ɓën, këni ŝaland osit or eno tëraxën Yesu ol do eno ɗaw̃axën. ");
INSERT INTO bsc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Are bani rend: «Kërenëŋo tëraye na ɗe yatir ofëna këdi kë wonjo do enëɓo mereli ɓela ɓën.» ");
INSERT INTO bsc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Amëd aŋo hi baxo Yesu gër ingol ind Betani, gër iciw̃ ind Simoŋ, ar gë ameỹ an. Aƴambëra baxo ƴambërand lëf ga lilëgu ko asoxari. Ŝëlakuŋ ir ekaỹ ed alëbatër ir gë angiri lëkayaw baxo. Angiri ijo gë opëtëfët od atëx and këni w̃acënd nar ɓar bani do xem bax mbaŋ akanji aŋ. Asoxari ajo, ga foɗët ko na ŝëlakuŋ in, xoŝ këŋo Yesu gë angiri in gër gaf. ");
INSERT INTO bsc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ata xoỹën këno ɓërëmar do këni nëkënëkarënd: «Inew̃a nëxenaxën ko angiri ijo? ");
INSERT INTO bsc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Axor xor doxo exo pan angiri ijo ɓatama okeme otas aŝand do koɗi in eɓi yëlëra ɓëxaỹënaxik ɓën.» Mondako bano renarand asoxari an. ");
INSERT INTO bsc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ɓarikan Yesu re ko: «Wën teɓino ɗe. Inew̃a këno hëbandëraxënënd? An nang ex na nde enjekax rin ke? ");
INSERT INTO bsc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gayikako din gë ɓëxaỹënaxik ɓën hi kën axor kën xor enëɓi din enjekax nand këŋun ỹandi yo, ɓari wëno ame ɓayi na din gë wën. ");
INSERT INTO bsc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Er xor ko exe din in ri ko. Gana gana fo xoŝ ko angiri in gër eman endam ɗamana ene mëxwëtaxën gër ỹeg. ");
INSERT INTO bsc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ɗal in këmun felënd, gër ed këni femëra yo ɓela Atëfëtan andam aŋ gër ngwën ro, areƴa këni ỹana eni deƴanɗ ɓëte er rin ke asoxari ajo in. Mondako këno ỹana eno kwitaxënënd.» ");
INSERT INTO bsc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Isëkariyot, asëfan ar Yesu hi baxo, ang hi bani ɓësëfan epëxw gë ɓëxi ak. Mëŋ ƴe bax gër ɓëŝaɗaxan ɓëlëngw wëlërëgu këni ang këɓi rëca eno tëraxën Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ado gë onënga fo ɓaxët bano do fëna bani mëne koɗi këno yël. Elod amëd aŋo baxo ŝaland Yuda nand kë ỹap eɓi tëran Yesu na. ");
INSERT INTO bsc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yatijo bax akey añanar and bani ƴambënd Ɓëŝëwif mburu ind gë lewir këm aŋ. Ɓëte yatijo fo banëɓi h̃aŝënd opeỹ od ŝaɗaxa ir Apexa ok. Ɓësëfan ɓën w̃ëka këno Yesu: «Feye wa ỹandi ki eƴ ƴambëra ecemar ed Ofëna or apexa el? Pelëlëɓo mëŋ këmi ƴe mi cemërax?» ");
INSERT INTO bsc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na law̃ën këɓi ɓësëfan ɓëxi, re ko: «Ƴeyin gër angol. Ata këno sëk asoŝan ar lëɓinak epeƴa ed gë men, tëfayino. ");
INSERT INTO bsc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gër ed ko lil, wën ɓëte ɗiliɗën eno pel axwën iciw̃ an mëne wëno Asëƴali arewën an w̃ëkak: “Feye ex wa aciw̃ and gër ed këmi ƴambëra ecemar ed Ofëna or apexa el wëno gë ɓësëfan ɓëram aŋ?” ");
INSERT INTO bsc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ata këŋun w̃asin aciw̃ and ƴaŋ gër ed xwëtëra ko ɓeỹ ɗek. Fën kën ŝemërax ecemar ed Ofëna or apexa el.» ");
INSERT INTO bsc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ga ƴe këni ɓësëfan ɓëxi ɓëjo h̃at këni gër angol. Sëkëx këni ɓeỹ ɓën ang fel baɓi ak do ŝemërax këni ed Ofëna or apexa el. ");
INSERT INTO bsc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Apenëka aŋ, Yesu gë ɓësëfan epëxw gë ɓëxi ɓën h̃atëgu këni na. ");
INSERT INTO bsc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ga ỹëpara këni eni ƴambëra, Yesu re ko: «Ɗal in këmun felënd, gër ed këne ƴambërande ro dëŋ hi ko ar enga endewën ar ke lëxw an.» ");
INSERT INTO bsc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ga ŝaminara këni ɓësëfan ɓën, këno w̃ëkand aɓat aɓat: «Wëno nde ex?» ");
INSERT INTO bsc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yaka këɓi: «Ang hi kën epëxw gë ɓëxi ak, ar kë xacand në edëƴamb edeɓat gë wëno hi ko. ");
INSERT INTO bsc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɗal ex wëno Asëñiw̃ ar ala an aŝës këme ŝës ang ỹëgw këni endam ak. Ɓarikan, eñëŋënax etëm këŋo hi ar ke lëxw an. Er saxëdoŋo mëŋ këreno dëw̃ dona.» ");
INSERT INTO bsc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","And bani ƴambërand aŋ, Yesu w̃eɗ ko aton and mburu, ŝëkwa këŋo Kaxanu do hëbëndër ko. Ga yël këɓi ɓësëfan ɓën, re ko: «Cetërin mburu iŋo, eman endam eŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","W̃eɗ ko ɓëte andëmba and gë ngoƴ aŋ, ga ŝëkwa këŋo Kaxanu yël këɓi do yëlar këni ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aŋo re ko: «Ngoƴ ind ŝeɓ kën iŋo ex, oŝat oram oŋ! Oŝat oŋo kë ŝar eni cotaxën ɓela ɓëranjëm eter ed din gë Kaxanu el. ");
INSERT INTO bsc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ɗal in këmun felënd, doro këme feland ngoƴ iŋ xali yatir këme ŝeɓ ingaŝax iŋ gër owun or Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yesu gë ɓësëfan ɓën, ga ỹëw̃ëra këni na od Calemoñëw̃ ok, ƴe këni kwël gër etënd ed gë ɓañarëka. ");
INSERT INTO bsc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ata re ko Yesu: «Wën ɗek kë ŝapër ene teɓ gaɓat, ang ỹëgw ko alaw̃ënel ak: “And këno law̃ axaɗac aŋ, oyel ol eni capër.” ");
INSERT INTO bsc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ɓarikan and këme xani gër ecës aŋ, gër ebar ed Galile këme ƴeɗ mun cënix.» ");
INSERT INTO bsc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ata re ko Piyer: «Ado eni capër ɓëjo ɗek wëno ami teɓ na!» ");
INSERT INTO bsc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu yaka këŋo: «Ɗal in këmi felënd doro gëmëɗ ɗamana exo yata ɓaki ecare el, wëj anëka këƴe ƴaxëta ɓatas.» ");
INSERT INTO bsc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ɓarikan Piyer re ko ɓëte: «Ado ex gido alaw̃ këni law̃ gë wëno ak kënëɓo law̃, din ami ƴaxëta na.» Ata soŝanara këni ɓësëfan ɓën ɗek mondako. ");
INSERT INTO bsc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ga h̃at këni gër ed bani w̃acënd Getësemani, Yesu fel këɓi ɓësëfan ɓërexëm ɓën: «Cëniyine ro me nacëta me calew!» ");
INSERT INTO bsc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","W̃ac këɓi Piyer, gë Ŝak do gë Ŝaŋ eno ɗaŋëta. Ga hi këŋo ñar eman eŋ, lëɓëk anjiỹ atëm gër emëkw edexëm. ");
INSERT INTO bsc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Fel këɓi ɓësëfan ɓën: «Yomb iram in ŝaminak, ecës fo ɓayi ke. Cëniyine ro, ɓarikan këreŋun daŝ na ɗe!» ");
INSERT INTO bsc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","And nacëta ko aŋ, foxi ko. Rën ko eƴiỹ el ŋëŝ gër ebar do ko ŝalend. Ga këŋo xara Kaxanu, eŋo pangacën apëxëd and toro aŋo kido awënd wëndëk. ");
INSERT INTO bsc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ga ko ŝale, ko rend: «Faba, wëj xorëk eƴ di ɓeỹ ɗek, pangacënële toro ind kërexe wëcan iŋo. Ɓarikan dil ɗe ang ỹandi ki wëj ak, ax gi ex na ang ỹandi ke wëno ak.» ");
INSERT INTO bsc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ga ɓaka ko gër ed seɓëgu baɓi Piyer, gë Ŝak do gë Ŝaŋ, sëk këɓi ga këɓi raŝ. Re këŋo Piyer: «Oko Simoŋ, në eɗaŝ exi ɗe. Apëxëd amat and riw këme aŋo nde wëj aƴ kor ex na exi per? ");
INSERT INTO bsc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Perënayin en calexën këdi këŋun naŋëta. Ala an gër onden këno ỹandind exo di er ỹapan këŋo Kaxanu in. Ɓari në end oñandi od eman na ko sëkwanaxënënd.» ");
INSERT INTO bsc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga nacëta ko gacëxe Yesu ko ŝalexënd ang ŝale baxo añanar ak. ");
INSERT INTO bsc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɓakaw ko akinëm, sëk këɓi gaŝëxe Piyer gë ɓoŝandaw̃ ga këni xond, eni këw̃ëtayin dëŋ bani sëkwanënd. Ga nëngëtara këni, ani nang bana mondake këno yaka Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","And ɓakaw ko atasën aŋ, re ko: «Wën daŝëraraleŋun, do teyëtayin. Ɗek ex! Anëka h̃atëguk apëxëd and këne sëra wëno Asëñiw̃ ar ala aŋ do ene ɗëxw gër otaxan od ɓëw̃endëran. ");
INSERT INTO bsc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kaniyin ene ƴeye! Asoŝan ar ke lëxw an në etëkaw exe!» ");
INSERT INTO bsc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Në yeƴan ɓayi baxo Yesu ga h̃atëgu ko Yuda, asëfan arexëm aɓat ang ebani epëxw gë ɓëxi ak. Mëŋ lëngweliw baɓi amëxwër and ɓër w̃ëlaraw bax: ɓëjo oduxuma, ɓëjo okwëlekwële. Ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëŝalen ɓën, do gë ɓëxarëk ɓër Ɓëŝëwif ɓën law̃ënëgu baɓi eno tëra Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ar baŋo lëxwënd an nanganëme ijo fel baɓi: «Ar këmo w̃ega an, mëŋ ex, tërayino eno mëla do eno ɗëkayax aye.» ");
INSERT INTO bsc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ataŋ ga h̃atëgu ko gër Yesu, Yuda re ko: «Asëƴali, ata w̃ega këŋo.» ");
INSERT INTO bsc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɓër lëngwënëgu baɓi ɓën w̃ëlën këno Yesu, sëra ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ata asëfan aɓat regëgu ko duxuma, saw̃ ko baɗ anëf and xaɗëp ir aŝaɗaxan alëngw aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ata re ko Yesu: «Wëno arek nde hi këme er ƴow kën ene tëra gë oduxuma do gë okwëlekwële? ");
INSERT INTO bsc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Key yo key ga bane xetand wa do bamun sëƴalirand gër yangana ir Aciw̃ and Kaxanu, ɓari ane tëra bana. Ɓarikan gërëgako anëka kën h̃atand er rek Oñëgw Omënëk in.» ");
INSERT INTO bsc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ata ɓësëfan ɓën ɗek ŝapëran këno Yesu do hërëra këni. ");
INSERT INTO bsc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ŝambenjar baŋo sëfand Yesu, ga ŝeraya ko gë anjëm fo. Ga sëra këno, ");
INSERT INTO bsc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nëỹëtëra ko, seɓën këɓi anjëm aŋ and ŝeraya baxo aŋ, hër ko tëɓ gë eman eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓër sëra baŋo Yesu ɓën w̃ëla këno gër iciw̃ ind aŝaɗaxan alëngw, gër ed ɓarërëgu bani ɗek ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëxarëk ɓër Ɓëŝëwif ɓën do gë ɓëŝalen ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ata Piyer këɓi sëfand nacët ako xali h̃at ko lëf gër yangana ir aŝaɗaxan alëngw. Ga ỹëpa këni gë ɓënëkona ɓën, ko yesand xoɗux ol. ");
INSERT INTO bsc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɓëŝaɗaxan ɓëlëngw ɓën, gë Amara and ɓëxarëk ɓër Ɓëŝëwif aŋ ɗek bani ŝaland amëd aŋo osede or këno nagaŝanaxën Yesu exo gixën ar eɗaw̃; ɓari ỹow̃eỹ abani ŝot na. ");
INSERT INTO bsc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gayikwa ɓëranjëm bax reƴand osede or ebax enëgwëŝ or këno nëpaxën Yesu. Ɓarikan anëgwëŝëtëndër bani nëgwëŝëtërënd. ");
INSERT INTO bsc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɓërëmar and këni xani aŋ eni dend: ");
INSERT INTO bsc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ɓiyi awël wël këmo ga ko re: “Wëno ayam këme yam Aciw̃ and Kaxanu aŋ, do and kë ri ɓakey ɓatas aŋ me kanin acëxen, and ani ɓaƴ na ɓela”.» ");
INSERT INTO bsc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ɓëte gër endeƴ eŋo dëŋ, anëgwëŝëtëndër bani nëgwëŝëtërënd osede oreɓën ol. ");
INSERT INTO bsc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ata xani ko aŝaɗaxan alëngw an, xwëŝa ko mërëxand gër Amara do w̃ëka këŋo Yesu: «Ba ỹoweỹ aƴ yaka na nde? Aƴ wëlënd na nde ang këni nagaŝandërand ak?» ");
INSERT INTO bsc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu xor ko ƴem. Aŝaɗaxan alëngw an w̃ëka këŋo gaŝëxe: «Ba wëj nde ex Afexën an, Asëñiw̃ ar Kaxanu ir këmo ŝalend ɓiyi an?» ");
INSERT INTO bsc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aŋo yaka ko Yesu: «Iyo, ata go dëŋ ex. Wën awat këne wat wëno Asëñiw̃ ar ala an ga ỹëpa këme gand liw̃ ir Ar gë panga ɗek an. Ɓëte awat këne wat ga këme ŝëlaw gë ɓaŋar ɓand gër orën ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ga logën këŋo na, aŝaɗaxan alëngw an h̃esëra ko ɓanjëm ɓandexëm ɓaŋ do ko rend: «Otede nde ɓayik na enëɓe wële? ");
INSERT INTO bsc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Awël wël kën ang ŝir këŋo Kaxanu ak. End fe wëndan këŋun?» Ata ɓën ɗek nëp këno do këni rend mëne Yesu ar eɗaw̃ ex. ");
INSERT INTO bsc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ata ɓërëmar kwël na fo ỹana këni motëpan Yesu. Ɓëjo eno kap gë anjëm gër dëxas eno bëŋaxën. And këno w̃ëŋ aŋ, eno mëka: «Cakil ba noỹo w̃ëŋ ki!» And fim këno gand ɓënëkona ɓër Aciw̃ and Kaxanu aŋ xanax këno gë ɓacënen. ");
INSERT INTO bsc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Amëd aŋo Piyer, gër ed ỹëpa baxo ɓayi baxo gëɗ gër yangana ir aŝaɗaxan alëngw. Ƴow ko endënaw̃ end bax riyenind na. ");
INSERT INTO bsc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wat këŋo Piyer ga ko yesa, nëkon këŋo aye gër dëxas, re ko: «Wëj ɓëte enga emat hi kën gë Yesu Iɓënasaret.» ");
INSERT INTO bsc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ata Piyer ga ko ƴax ko rend: «Wëno ado ame nang ex na, axe pëni ex na dëŋ er këƴ rend in.» Ga yaka ko mondako kwël ŝan ko, do ƴe ko gër yangana ir lëf. Ata amëd aŋo yata ko ecare el. ");
INSERT INTO bsc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Endënaw̃ eŋ ga wat këŋo gaŝëxe këɓi felënd ɓër hi bax na ɓën: «Ajo ar enga emat gë Yesu exo.» Piyer ƴax ko gaŝëxe. ");
INSERT INTO bsc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga nëkak tëkër, ɓër wël baŋo endënaw̃ ɓën re këno ɓëte Piyer: «Ɗal ex, wëj ar enga eŋo hi këƴ gayikako Aɓëgalile hi këƴ!» ");
INSERT INTO bsc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aŋo yaŝar ko mo njaŝar Piyer: «Angëmëne anang nang këmo ala ajo, corëlexe Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ataŋ ecare el yata ko akinëm, Piyer xwita ko ang fel baŋo Yesu ak: «Ɗamana exo yata ɓaki ecare el, wëj anëka këƴe ƴaxëta ɓatas!» Ata ga ŝan ko na, ko sesëxënd. ");
INSERT INTO bsc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mopëɗ gëɓër, ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëxarëk ɓën do gë ɓëŝalen ɓën ỹëpaxën këni end Yesu eŋ. Amara aŋ ɗek ɓarërëgu bani. Ga xap këno na Yesu, w̃ëla këno eno ɗëxwëx gër Pilat. ");
INSERT INTO bsc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ga h̃ateli këno, Pilat w̃ëka këŋo Yesu: «Wëj nde ex emun end Ɓëŝëwif eŋ?» Yaka ko: «Iyo go dëŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ata na këno nëgwëŝandërand ɓendanjëm ɓëŝaɗaxan ɓëlëngw ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat w̃ëka këŋo gaŝëxe: «Ba ỹoweỹ aƴ yaka na nde? Aƴ wëlënd na nde ɗek ɓend këni nagaŝanënd ɓeŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ɓarikan Yesu gematak axo yaka bana. Eŋo ŝaran baŋo Pilat. ");
INSERT INTO bsc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ofëna or Apexa kala, Pilat aseɓët baŋo seɓëtënd andepëra amat, ar këno yata Ɓëŝëwif an. ");
INSERT INTO bsc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Andepëra hi baxëna and bano w̃acënd Barabas. Gë ɓoŝandaw̃ w̃ereli banëɓi ɓëlëngw ɓëliyer ɓën xali law̃ këno ala, ga wonjok angol aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ga ƴe këni amëxwër and Ɓëŝëwif aŋ ƴaŋ gër eyang ed Pilat, w̃ëka këno eŋo teɓët ar epëra aɓat ang w̃ërën baɓi ak. ");
INSERT INTO bsc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ata w̃ëka këɓi Pilat: «Ỹandi këŋun nde moteɓët emun end Ɓëŝëwif eŋ?» ");
INSERT INTO bsc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mama w̃ëka baɓi mondako ga nang baxo mëne ɓëŝaɗaxan ɓëlëngw ɓën në end oƴakëraxi lëxwaxën bano Yesu. ");
INSERT INTO bsc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɓarikan ɓëŝaɗaxan ɓëlëngw ɓën fel kënëɓi amëxwër aŋ eno nëỹali Pilat eŋo teɓët Barabas. ");
INSERT INTO bsc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ata Pilat w̃ëka këɓi gaŝëxe: «Mondake ỹandi këŋun mo di ar këno rend wën emun end Ɓëŝëwif exo an?» ");
INSERT INTO bsc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yaka këni ŝor: «Pikalo! Pikalo!» ");
INSERT INTO bsc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat w̃ëka këɓi ɓëte: «Inew̃a w̃en ko?» Aŋo xeỹ këni kaŝ-kaŝ: «Pikalo, Pikalo maɓ në osëx!» ");
INSERT INTO bsc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ga ỹandi këŋo eni ŋan endexëm eŋ, Pilat seɓët këŋo Barabas. Seɓ këɓi ocoroɗa ok eno cew̃ëra xali Yesu ɗamana eno mëlaxën gër ed këno fikax. ");
INSERT INTO bsc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ocoroɗa ok ŝonjorëra këno Yesu xali lëf gër yangana ir aciw̃ and kiti, do w̃acërëgu këni ɗek enga eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ga ŝuɗ këno ocuɗ ombarax, fug këno odëmbën gër gaf ang ekamote ed emun fo. ");
INSERT INTO bsc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ata ỹana këni këno ŝëmand: Ake wa ɓayi këƴ wëj emun end Ɓëŝëwif eŋ? ");
INSERT INTO bsc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","And këno rang gë oŝët aŋ, eno tëpan do eni poxi gër lëngw irexëm eƴiỹ el ŋëŝ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","And fed këɓi enarëndëra ed Yesu aŋ, ŝuɗët këno ocuɗ ombarax oŋ. W̃aŝ këno ɓanjëm ɓandexëm ɓaŋ do w̃ëla këno eno pikax gër kërëwa. ");
INSERT INTO bsc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ocoroɗa ok ga këno w̃ëla Yesu, fed këni gë Simoŋ Iɓësiren, sëm ir Alekësandër do gë Rufos, ga hiw ko gër oŝënga. Ata nëỹali këno exo ɗëɓina kërëwa ir Yesu in. ");
INSERT INTO bsc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na w̃ëla këno ƴaŋ gër itënd ind bani w̃acënd Golëgota mëne ngëŋ «Itënd ind ang egor». ");
INSERT INTO bsc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yël këno exo ceɓ ngoƴ ind ɓar bani gë ɓëŝan ɓër këni w̃acënd mir ɓën. Ɓarikan Yesu h̃ëp ko exo ceɓ. ");
INSERT INTO bsc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ga fika këno gër kërëwa, ŝetër këni ɓanjëm ɓandexëm ɓaŋ. W̃eɗ ko ŝoroɗa iɓat and ri këni ɓëñak aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Apëxëd anaxën and gëɓër aŋ h̃at bax and fika këno Yesu aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","End law̃axën bano eŋ ỹëgw bani në ingomb gomb do fikali bani ƴaŋ gër kërëwa: «Emun end Ɓëŝëwif exo.» ");
INSERT INTO bsc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓërek ɓëxeỹax ɓëxi fika banëɓi gë Yesu: aɓat gand liw̃, ajo gand ŝame. ");
INSERT INTO bsc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mondako h̃ata bax er rek Oñëgw Omënëk in: Mërëxand ir ɓëw̃endëran xwët bano. ");
INSERT INTO bsc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ata këno ŝirënd Yesu ɓela ɓër bax xucarand ler na ɓën. Sam eni këmëƴëtara eni de: «Xey ax gi ex na nde wëj bax rend ayam këƴ yam Aciw̃ and Kaxanu aŋ do eƴ kanin and ri ɓakey ɓatas aŋ? ");
INSERT INTO bsc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Awa doro pexënayal gë andeƴ do pedaw gër kërëwa!» ");
INSERT INTO bsc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Alëŝ bano lëŝënd ɓën ɓëte ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën do bani rend: «Oko, mëŋ ga baɓi fexën wa ɓela ɓën do ko sëkwanënd exo pexënaya. ");
INSERT INTO bsc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Awa Kërisët, emun end Isërayel eŋ, pedawëlexo gërëgako gër kërëwa, enëŋo wataxëne do enëŋo kwëtaxëne!» Aŝir bano ŝirënd ɓëte ɓërek ɓër fika banëɓi gë mëŋ ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ga h̃atëk eñan eŋ keŋ gër gaf, ŝamëɗanëk ɗek ebar el xali ɓapëxëd ɓatas gë apenëka aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Amëd aŋo xeỹ ko Yesu: «Eloyi, Eloyi, lama sabatani?» Mëne ngëŋ: Kaxanu Axwën aram, Kaxanu Axwën aram, inew̃a ỹaŋëtaxën këƴe? ");
INSERT INTO bsc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ga wël këno ɓër hi bax na ɓën këni rend: «Ɓaxëtino ga këŋo w̃acënd alaw̃ënel Eli.» ");
INSERT INTO bsc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ata hërën ko aɓat er ñalu-ñalu, ỹëmb ko gër ngoƴ iŋerëk, ga fiŝ ko në oŝët, yën ko xali gër etëỹ ed Yesu exo ƴuŝaxën, do ko rend: «Teɓino ɗe ene wate ba Eli aƴow ko ƴow eŋo pedaliw.» ");
INSERT INTO bsc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ɓarikan, aŋo xeỹ ko gaŝëxe, kwël Yesu xoti ko. ");
INSERT INTO bsc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ata anjëm amëgax and bax weɗind lëngwe ir Aciw̃ and Kaxanu in, h̃esik cangët elod ƴaŋ xali gëɗ. ");
INSERT INTO bsc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Alëngw ar ocoroɗa an, ar xwëŝa baxo ler gër ed fika këno Yesu an, ga wat ko ang xoti ko ak, re ko: «Enimin, ala ajo Asëñiw̃ ar Kaxanu ebaxo!» ");
INSERT INTO bsc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Enga end ɓësoxari xwëŝara bax na nacët ako do këno nëkonënd Yesu. Er ebani: Mari Madëlen, gë Mari nëm ir Ŝak iɓeja do gë Yose, do gë Salome. ");
INSERT INTO bsc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓën ex ɓësoxari ɓër sëfaw baŋo Yesu elod gër ebar ed Galile do bano rëcarand. Na fo bani ɓëte ɓësoxari ɓëŝëxe ɓër xaniw bax gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yatir arajëma, and genëka aŋ, bani xëñënand akey and eteyëta aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ata h̃atëgu ko na, Yosef Iɓarimate. Mëŋ ar gapak ebaxo gër Amara and ɓëlëngw ɓër Ɓëŝëwif. Aŝëni baxo ŝënind ɓëte owun or Kaxanu ol. Ga xapina ko, ƴe ko gër Pilat exo mëkaw eŋo maŝ eman end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat ŝaran këŋo xali ga wël ko mëne anëka xor këŋo Yesu. Ga w̃ac këŋo alëngw ar ocoroɗa an, w̃ëka këŋo ba elod anëka fo xoti ko. ");
INSERT INTO bsc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Alëngw ar ocoroɗa an felëra këŋo na ɗek. Ata Pilat w̃aŝ këŋo Yosef eman end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosef yëcëgu ko këpas. Fedali ko eman end Yesu eŋ gër ed fika bano. Ga fëlëra këŋo gë këpas in, w̃ëxëta këŋo lëf në ỹeg ir fës bani gër aparëfac ang oxel fo do fëŋ ko lilaya in gë angaỹ atëm. ");
INSERT INTO bsc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ata Mari Madëlen do gë Mari, nëm ir Ŝak iɓeja do gë Yose këni nëkonënd gër ed w̃ëxwëta këno. ");
INSERT INTO bsc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","And xucak akey and eteyëta aŋ, Mari Madëlen, gë Mari nëm ir Ŝak iɓeja do gë Salome yëcëgu këni ogu onëngax ond eni koŝaxën eman end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yatir oganjar, akey aỹanar and loxo aŋ, mopëɗ gëɓër, h̃at këni gër ỹeg ga kë fënëgu eñan eŋ. ");
INSERT INTO bsc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ata këni w̃ëkarënd: «Noỹo këɓo rëxëtën angaỹ and gër lilaya ir ỹeg aŋ.» ");
INSERT INTO bsc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ga rënëta këni, wat këni angaỹ aŋ ga weɗitak. ");
INSERT INTO bsc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lil këni gër ỹeg, sëk këno moñëpa gand liw̃ ŝambenjar ir gë acuɗ apeŝax. Ata ŝëg këɓi ɓenjëw̃ ɓeŋ ga xurik anjiỹ aŋ. ");
INSERT INTO bsc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ata re ko ŝambenjar in: «Wën këren yëdara na! Ax gi ex na nde Yesu Iɓënasaret, ar fika bano an këno ŝaland? Anëka xani ko gër ecës, axo bo ex na ro. Nëkoyin wa gër ed xwët bano. ");
INSERT INTO bsc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ɓarikan ƴeyin enëɓi pelëx ɓësëfan ɓërexëm ɓën do gë Piyer mëne anëka lëngwa ko gër ebar ed Galile. Fën këno watëx ang fel baŋun ak.» ");
INSERT INTO bsc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ata ŝan këni, nacëta këni caw ỹeg in gë ongër fo, do këɓi rëgënëraxënd anjiỹ aŋ. Ga xap këɓi anjiỹ aŋ, ala ano pel bana ỹoweỹ. ");
INSERT INTO bsc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu ga xani ko gër ecës mopëɗ gëɓër yatir oganjar, akey aỹanar and loxo aŋ, ŝanayaxën këŋo pere Mari Madëlen, asoxari ar nëcëtën baŋo ɓangoc ɓañëŋënax ɓanjongëɓaki an. ");
INSERT INTO bsc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari Madëlen ƴe ko eɓi pelëx ɓër enga endexëm ɓën, gër ed bani renitarand, gër ed bani sesërand. ");
INSERT INTO bsc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","And wël këno ga ko reƴa mëne Yesu aɓëngw exo do mëne awat wat këŋo aŋ, ani ma bana. ");
INSERT INTO bsc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ga xucak eŋo, Yesu ŝanayaxën këɓi mëŋ dëŋ gë ola oŝëxe ɓësëfan ɓëxi ga këni nëca. ");
INSERT INTO bsc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ata wërëŝëta këni enëɓi tëfëtanëx ɓoŝandaw̃, ɓari ɓën ɓëte anëɓi kwëta bana. ");
INSERT INTO bsc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ata Yesu ŝanayaxën këɓi ɓësëfan epëxw gaɓat ɓën gër ed bani ƴambërand. Arexëra rexëra baɓi mbaŋ në end oŋëpëgënan odeɓën eŋ, do gë në end emëŝ endeɓën eŋ, gayik anëɓi kwëta bana ɓër wat baŋo ang nëngëta ko ɓën. ");
INSERT INTO bsc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ata na re ko Yesu: «Ƴeyin ngwën iŋ ɗek en pemërand Atëfëtan aŋ gër ɓela ɗek. ");
INSERT INTO bsc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ar kë w̃a yo do eno ɓuyi, afex ko fex, ɓari ar kë h̃ëp an, axiti këno xiti. ");
INSERT INTO bsc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Awa ɓecarax ɓeŋo këni ỹana eni dind ɓër kë w̃a endam ɓën: Gë ow̃ac oram ol kënëɓi ỹana enëɓi nëcëtënd ɓangoc ɓañëŋënax ɓaŋ, oyeƴan oxaŝax këni ỹana eni yeƴanënd. ");
INSERT INTO bsc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Asëra kënëɓi ỹana enëɓi tërand ɓandën. Ado eni ceɓ er ebax eɓi ɗaw̃ in, ỹow̃eỹ aɓi gi na. Ah̃ëmba kënëɓi ỹana enëɓi h̃ëmband ɓëŝëxwëra ɓën eni pakaxën.» ");
INSERT INTO bsc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Axwën Yesu, ga felëra këɓi na mondako, ŝëg ko kwël ƴaŋ gër orën do ỹëpax ko gand liw̃ ir Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɓësëfan ɓën ƴexëra këni eni pemëra gër ed ex yo. Axwën Yesu ko riyenind gë ɓën, ata gë ɓecarax ɓend bani rind ɓeŋ baɓi w̃asinënd ɓela ɓën mëne ɗal këni reƴand.");
INSERT INTO bsc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɓëranjëm sëƴik eni ñëgw ɓend Yesu Kërisët ɓeŋ do gë ɓend xucak gër ndeɓi ro ɓeŋ ex gixën Atëfëtan amat. ");
INSERT INTO bsc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ɓër watelik gë ogës odeɓën elod gër ỹanar do hi këni ɓëriyenin ɓër Eyeƴan ed Kaxanu ɓën nangën këɓo ɓeŋo. Ɓën seɓën këɓo ɓend Yesu Kërisët ɓeŋ do gë ɗek ɓeɓër ri ko gër aniyan andexëm ɓën ene deƴaraxënënde gër ɓela ang bani reƴarand ɓën ak. ");
INSERT INTO bsc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Awa wëno ɓëte, gë oɓal osëm w̃ëkara këmëni ɓër nangëk ɓeŋo elod gër ỹanar ɓën. Ata ɓeɓër fel këne ɓën ỹapan ke mi ñëgwënëli Tewofil, wëj ar gapak an, eƴ nangaxën mëne ");
INSERT INTO bsc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ɓeɓër sëƴali këni ɓën mokwëta dëŋ ex. ");
INSERT INTO bsc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Angwën and ebaxo Erod emun end gër ebar ed Yude aŋ, aŝaɗaxan ebax na ar bano w̃acënd Sakari. Gër enga end Abiya ebaxo do alindaw̃ Elisabet ebaxo ɓëte ar andëw̃ëra and Aharoŋ, aŝaɗaxan alëngw aỹanar an. ");
INSERT INTO bsc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakari gë Elisabet ɓër ŝenene ebax gër ogës od Kaxanu. Ŝenene bani sëfënd acariya and Axwën Kaxanu aŋ do gë ɗek ɓapela ɓand re ko aỹap ỹapëk motëf gër aniyan ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɓarikan gë oɓaŝ këm xar bani gayik Elisabet asoxari aɓoroxok ebaxo. ");
INSERT INTO bsc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ɓëŝaɗaxan ɓën arëcar bani rëcarënd, gë enga gë enga, edi ed ocaɗaxa el gër Aciw̃ and Kaxanu. Ata akey amat, enga end Sakari ɓën eŋ ɓët bani. ");
INSERT INTO bsc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ang rëp bax gër andiyen and ocaɗaxa ak, aŝaɗaxan aɓat ebax eno tana gër enga endeɓën exo ɗilaxën lëf gër Aciw̃ and Axwën Kaxanu exo corëgu aŝururu ir xwëŝëna bani gë angiri in. Ata sana këno Sakari. ");
INSERT INTO bsc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","And lil ko aŋ, ŝëni këno fac amëxwër and Ɓëŝëwif aŋ do këni ŝalend ga h̃atëk apëxëd and ecor ed aŝururu ir xwëŝëna bani gë angiri aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ata lëf, meleka ir Axwën ŝanaỹaxën këŋo Sakari. Xwëŝa ko gand liw̃ ir angëɓ and bani ŝoraxënënd aŝururu. ");
INSERT INTO bsc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ga faɓër këni gë meleka in, Sakari yëdara ko xali xurik, do wëlandëra këŋo mbaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ata re ko meleka in: «Sakari, këreƴ yëdara na! Cale indeƴ iŋ yakali ki Kaxanu. Alindax Elisabet gë acël ko hi do eŋo dëw̃ lëmëta ir këƴo w̃acëɗ Ŝaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ata lëmëta ijo kë ƴemën emëkw edeƴ el do exi nëngandëra mbaŋ. Ɓëte ɓëranjëm këɓi nëngandëra and këno rëw̃ aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Lëmëta ijo, ala asëm ko hi gër ogës od Axwën Kaxanu. Mëŋ ex, aŝëɓa këŋo ŝëɓa ngoƴ iŋ do gë eŝeɓëceɓ ir kë ỹaw̃ënd yo. Ado kwël gër acël and nëm fo ko ỹëm gë Angoc Amënëk aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Do and ko raf aŋ, mëŋ këɓi ɓakali Ɓëyisërayel ɓëranjëm eno kwëta Kaxanu, Axwën areɓën an. ");
INSERT INTO bsc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mëŋ ex ar kë lëngwaw an ɗamana exo ŋataxënëgu Axwën an. Kaxanu këŋo yël angoc aŋ do gë panga ind yël baŋo alaw̃ënel Eli iŋ exo ɓakalixënëgu gër Isërayel angwëlëra and oɓaŝ gë ɓëxarëk ɓëreɓën aŋ. Ɓëte ɓër gë ow̃ëkw ow̃ëŝik ɓëranjëm këɓi wërëŝët eni gi ɓër ŝenene. Ata mondako këɓi rëca ɓulunda ir Isërayel in eni këñënara ŝenene eno kacaxën Axwën areɓën ar kë ƴowënd an.» ");
INSERT INTO bsc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakari w̃ëka këŋo meleka in: «Mondake këme nang mëne ahi dëŋ kë hi ɓeɓër këƴe felënd ɓëjo gayikako wëno gë alindaw̃ën anëka xar këmi?» ");
INSERT INTO bsc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yaka ko meleka in: «Aƴ nang ex na nde mëne wëno ex Gabëriyel, ar gër enga end omeleka od hik ler gër Kaxanu an? Do mëŋ ga law̃ënëgu ke mi pel enjekax eŋo, wëj ki h̃ëpëgënanënd. ");
INSERT INTO bsc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awa aƴ ɓayi na gë oniw̃ xali yatir kë h̃ata ɓeɓër fel këmi ɓëjo gayikako aƴe kwëta ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Xarak amëd aŋo fac, Ɓëŝëwif ɓën ɗek ƴëka baɓi oŝën or Sakari ol. Ɗek nemëran baɓi ba në end ine ko nëkaxënëgund go lëf gër Aciw̃ and Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","And ŝanëgu ko aŋ, sëkwan ko eɓi yeƴaneli, ata nang këni mëne ỹeỹ watëgu ko lëf gër Aciw̃ and Kaxanu. Alambacara fo baɓi lambacarand ga ŝanëgu ko gë oniw̃ këm. ");
INSERT INTO bsc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","And faỹ ko ɓakey ɓand ebax exo diyeni gër Aciw̃ and Kaxanu aŋ, Sakari w̃aỹi ko kwël gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ga nëkanak, alindaw̃ Elisabet hi ko gë acël. Ata ỹaf ko opacaw̃ oco. ");
INSERT INTO bsc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Er baxo rend: «Dodo anëka ƴëkwaw ke Axwën Kaxanu. And h̃atan këŋo aŋ, faỹ ko gër emëkw edexëm exo dëxët aŝëfën iram in gër ɓela.» ");
INSERT INTO bsc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anëka bax opacaw̃ ocongiɓat elod ga hi ko Elisabet gë acël. Kaxanu law̃ën këŋo meleka ir këno w̃acënd Gabëriyel in gër ebar ed Galile, gër ingol ind Nasaret. ");
INSERT INTO bsc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Meleka in h̃at ko në endënaw̃ emeja end nëm baŋo Yosef, ŝambenjar ir andëw̃ëra and Dafid, ar ebax emun etëm end gër ebar ed Isërayel an. Endënaw̃ emeja eŋo, Mari bano w̃acënd. ");
INSERT INTO bsc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ga lil ko meleka in gër ed hi baxo, re ko: «Aŝëma ŝëma këmi wëj ar rin ki oyekax Kaxanu an! Axwën an gë wëj hi ko, wëj ye ki!» ");
INSERT INTO bsc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","And wël ko Mari eyeƴan elo aŋ, wëlandëra këŋo do ko yëlarand ba ine w̃acayak ecëmar elo. ");
INSERT INTO bsc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ata re ko meleka in: «Këreƴ yëdara na Mari gayikwa Kaxanu yël ki oyekax orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gë acël këƴ hi do eƴo dëw̃ lëmëta. Yëliɗo ow̃ac or Yesu ol. ");
INSERT INTO bsc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lëmëta ijo, Asëñiw̃ ar Kaxanu exo, mëŋ ar hik ƴaŋ gër orën an. Mondako këno ỹana eno macënd gayik ala asëm ko hi. Ata Axwën Kaxanu, mëŋ këŋo w̃aŝ añëpara and owun or Dafid, axarëk arexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Din ir din ko wun gër enëng end Yakob do owun orexëm ol ax kwët na gë ekwët.» ");
INSERT INTO bsc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ata Mari yaka këŋo meleka in: «Mondake wa kë hi eŋo gayikako wëno asoŝan amo nang ex na?» ");
INSERT INTO bsc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aŋo re ko meleka in: «Angoc Amënëk aŋ kë ƴow gër ndeƴ do panga ind Kaxanu mëŋ ar hik ƴaŋ gër orën iŋ ki laɓ. Mëŋ ex, ar këƴo rëw̃ an, Asëñiw̃ ar Kaxanu këno ỹana eno macënd gayik aw̃ënëk exo. ");
INSERT INTO bsc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nëkoɗa Elisabet ar nëng ireƴ an, mëŋ ɓëte ga hi ko gë acël gë oxar go dëŋ. Anëka sëk këŋo opacaw̃ ocongiɓat mëŋ ar bano rend asoxari aɓoroxok exo an, ");
INSERT INTO bsc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","gayik gër Kaxanu ɓeỹ ɗek wëndëk.» ");
INSERT INTO bsc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ata re ko Mari: «Awa gayikako ex, wëno ariyenin ar Axwën Kaxanu hi këme, dilexo ang fel këƴe ak.» Ata kwël ƴe ko meleka in. ");
INSERT INTO bsc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ata kwël gë ɓakey baŋo fo, Mari ƴe ko aỹand xali gër ebar ed Yude, në angol and ler në osënd. ");
INSERT INTO bsc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","And h̃at ko gër iciw̃ ind Sakari ɓën aŋ, ŝëma këŋo Elisabet. ");
INSERT INTO bsc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet, sam ga wël ko ecëmar ed Mari el, itox ind gër acël andexëm iŋ welëtëra ko onënga ol. Ata Elisabet ỹëm ko gë Angoc Amënëk aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na ɓacan këŋo Mari, ko rend: «Gër ɓësoxari ɗek, wëj ye ki! Asoxari aɓetak hi këƴ, wëj ye ki! Do ar ex gër acël andeƴ an aɓetak exo, wëj ye ki! ");
INSERT INTO bsc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yakayin, nëm ir Axwën aram nëngaw ke, wëno ye ke! ");
INSERT INTO bsc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","And wël këme ecëmar edeƴ aŋ, itox indam iŋ awelëtëra welëtëra ko onënga ol gër acël. ");
INSERT INTO bsc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nëngandëralexi wëj ar w̃ak mëne er fel ki Axwën in ah̃ata kë h̃ata.» ");
INSERT INTO bsc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ata yaka ko Mari: «Gër yomb iram nëngandëra ke mëŋ këmo yasaxënënd Axwën an! ");
INSERT INTO bsc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Iyo gër yomb iram nëngandëra ke end Kaxanu eŋ, mëŋ Afexën aram an! ");
INSERT INTO bsc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gayikwa aƴëkwa ƴëkwaw ke wëno ariyenin arexëm an. Ang këni ɓëtëraw yo ɓela ɓën gër ngwën ro, Din këne ỹana ene macënd asoxari aɓetak. ");
INSERT INTO bsc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kaxanu, mëŋ ar xorëk ɓeỹ ɗek an, rin ke ecaraxik eŋo. Ow̃ac orexëm ol ow̃ënëk ex. ");
INSERT INTO bsc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Do axaỹënan irexëm in din ir din ex gër ɓër këŋo fëɓënd. ");
INSERT INTO bsc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Panga indexëm iŋ nëcët ko; gë panga iŋo ŝapëreli këɓi ɓër gë ɓanjëlan ɓand gë ndafënan ɓën, ");
INSERT INTO bsc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Alat lat këɓi ɓër gapak ɓën gër ɓañëpara ɓand owun, Eni ɓëtaxën gër owun ɓërëtoc ɓën, ");
INSERT INTO bsc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɓër baɓi ƴambën enjo ɓën lëɓa këɓi gë ɓenjekax ɓeŋ xali w̃ed këni, do aw̃aỹ w̃aỹ këɓi taxan ɓër gë napul ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɓiyi Ɓëyisërayel ɓën rëca këɓo, Ɓiyi ɓëriyenin ɓërexëm ɓën. Axwita xwita ko ang këŋo xaỹënanënd ɓiyi ak, ");
INSERT INTO bsc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Axwita xwita ko eɓo din enjekax eŋ, Ang fel baɓi ɓëxarëk ɓëreɓi ak, Ang ɓeƴa baɓi enjekax end din Abëraxam gë oɓaŝ orexëm ak.» ");
INSERT INTO bsc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ata ga xucak eŋo, Mari xeyëra këŋo në opacaw̃ otas gër iciw̃ ind Elisabet ɓën ɗamana w̃ayixën ko gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ga h̃atëk amëd and orëw̃ aŋ, Elisabet rëw̃ këŋo lëmëta. ");
INSERT INTO bsc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɓëraketa ɓën do gë ɓërexëm ɓën ga wël këni mëne Axwën an axaỹënan dëŋ xaỹënan këŋo Elisabet, ɓarërëgu këni gër iciw̃ eɓi nëngandëra andamat gë mëŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yatir sëk këŋo loxo, ɓakaraw këni ɓëte eno kac lëmëta in. Ata yël këno ow̃ac or sëm ol mëne ngëŋ Sakari. ");
INSERT INTO bsc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ɓarikan ga wël ko nëm ow̃ac olo, re ko: «Ali ax gi ex na ɗe mondako? Ŝaŋ ex ow̃ac orexëm ol!» ");
INSERT INTO bsc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yaka këno: «Ine? Gër nëng irewën ala ano macënd na mondako!» ");
INSERT INTO bsc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ata lambaca këno sëm ir lëmëta eni nang ba mondake ỹandi baŋo eŋo mac. ");
INSERT INTO bsc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","W̃asi ko eno mëɗënëgu ingomb gomb. Ga xana ko, ỹëgw ko: «Ŝaŋ ex ow̃ac orexëm ol.» Ata na ŝarandëra këɓi ɗek ang ebani ak. ");
INSERT INTO bsc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ataŋ lëkwëtak iniw̃ ind Sakari iŋ do wëli këŋo oniw̃ ol. Ỹana ko këŋo ŝëkwand Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ata ɓëraketa ɓën ɗek wëlandëra këɓi. Ɓëte ɗek ɓër bax wël endeƴ eŋo ɓën wëlandëra këɓi ebar ed Yude el ɗek xali gër osënd. Ata ɓeŋo fo bani yeƴandërand ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɗek ɓër bax wël ɓeŋo ɓën, gë emëkw el bani ɓaxëtënd do bani w̃ëkarënd ba ine ko hi itox iŋo. Enimin panga ind Axwën Kaxanu iŋ gër ola or itox iŋo ebax. ");
INSERT INTO bsc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakari, sëm ir lëmëta, ga ỹëm ko gë Angoc Amënëk aŋ, ỹana ko ko yeƴanënd ang alaw̃ënel fo do ko rend: ");
INSERT INTO bsc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Cëkwanëŋone Axwën an, mëŋ ar ex Kaxanu, Axwën ar ɓulunda ir Isërayel an, Ga law̃ëneliw këɓo enimin apexa aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aw̃ëlan w̃ëlanëgu këɓo apexa aŋ gër ekun ed Dafid, ariyenin arexëm an. ");
INSERT INTO bsc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eŋo fëna baxo exo di elod ɓëniy okeme okeme ang reƴa këni ɓëlaw̃ënel ɓëw̃ënëk ɓërexëm ak. ");
INSERT INTO bsc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Apexa aŋo këɓo racët gër otaxan od ɓër ŝus këɓo. Ɓëte aɓeƴa ɓeƴa baxo mëne aracët këɓo racët gër otaxan od ɓër ŝus këɓo. ");
INSERT INTO bsc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Në emasin eɓo ang baŋo xaỹënanënd ɓëxarëk ɓëreɓi ak, Ɓëte në emasin eɓo axo kwëya ex na mëne mëŋ dëŋ yata këɓo eter emënëk el. ");
INSERT INTO bsc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ayaŝar yaŝar baxo gër axarëk areɓi Abëraxam mëne, ");
INSERT INTO bsc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Aracët këɓo racët gër toro ind lëxw banëɓo ɓër xoỹër këɓo ɓën do gë anjiỹ këm enëŋo calende ");
INSERT INTO bsc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","gë ola ow̃ënëk do gë or ŝenene, ang kë nëka yo ɓakey ɓandeɓi ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Do wëj itox iŋo, alaw̃ënel ar Kaxanu këni ỹana eni macënd, Alaw̃ënel ar Kaxanu, mëŋ ar hik ƴaŋ gër orën an, Gayik wëj lëngwaliw ki eƴo mëxwëtën fëña in Axwën an. ");
INSERT INTO bsc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wëj këɓo w̃asin ɓiyi ɓër ex ɓulunda irexëm ɓën mi nangaxën apexa and gë eteɓan ed ɓeñëŋënax aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kaxanu, mëŋ ar xwën këɓo an, axaỹënan këŋo xaỹënanënd endeɓi eŋ. Paɓ gë axaỹënan ijo këɓi h̃oɓaxënënd eñan eŋ, ɗek ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Në eƴow exo eɓi ŋoɓa ɓela ɓër kë liyand gër ecamëɗan ɓën, Ɓela ɓër ỹëpak gër ed ỹañëk ecës ɓën. Në eƴow exo eɓo ɗëngweli gër oɓetak.» ");
INSERT INTO bsc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ga xucak ɓeŋo ɗek, lëmëta in kwël ko rafënd do ko firind gë panga ind Angoc Amënëk iŋ. Do në er timëriŋ fo baŋo ỹandind exo gi Xali ex ŋatëgu akey and ko ŝanaya exo pemërand gër ɓulunda ir Isërayel aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ga xucak ɓakey baŋo Sesar Ogisët, emun etëm end gër Rom eŋ, re ko enëɓi ñëgw ɓela ɓën gaf gë gaf ɗek ebar ed xwën baxo el. ");
INSERT INTO bsc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Oñëgw oko, oñanar ok ebax amëd and hi baxo Kurenu, gofërëner in, gër ebar ed Siri. ");
INSERT INTO bsc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɓela ɓën ɗek bani ƴexërand enëɓi ñëgw ala kala gër angol and rëw̃ këno. ");
INSERT INTO bsc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ata Yosef, ar andëw̃ëra and Dafid an, xani ko gër Nasaret, gër ebar ed Galile do w̃aỹi ko gër ed Yude, gër Betëlexem. ");
INSERT INTO bsc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gë Mari, enëm edexëm el sëfër bani enëɓi ñëgwëx, xarak amëd aŋo Mari gë acël akarëk hi baxo. ");
INSERT INTO bsc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nand ebani gër Betëlexem na, Mari ỹanar këni orëw̃ ol. ");
INSERT INTO bsc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ata rëw̃ këŋo lëmëta iỹanar irexëm in, lëf në eciỹi. Ga laɓëra këŋo, ren këŋo në apeɗe gayik anëɓi cotën bana në er këni hi lëf gër aciw̃ and ɓëliyer. ");
INSERT INTO bsc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatir rëw̃ këno Yesu, ɓëxaɗac baɓi nëkonand na gëmëɗ oyel oreɓën ol gër ocënga od gër Betëlexem. ");
INSERT INTO bsc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ata ŝanayaxën këɓi bërëxaɗët meleka ir Axwën in, do enjaran end Kaxanu eŋ h̃oɓaw këɓi. Na yëdara këni xali xurik. ");
INSERT INTO bsc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ata re ko meleka in: «Wën këren yëdara na, Atëfëtan këmun nangënënd! Atëfëtan aŋo, onënga osëm or ɓela ɗek ex. ");
INSERT INTO bsc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nangin mëne doro rëw̃ këno, Kërisët, Axwën an. Marayin en ƴe gër Betëlexem, gër angol and Dafid. ");
INSERT INTO bsc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nanganëme ijo yël këmun: ata këno sëk itox imbarax ga laɓëra këno do ren këno në apeɗe.» ");
INSERT INTO bsc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ata omeleka ocëxe ŝoma këno iŝandaw̃ in, ɓenga ɓenga, elod ƴaŋ gër orën. Do ga këno yas Kaxanu këni rend: ");
INSERT INTO bsc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Cëkwanëŋone Kaxanu, mëŋ ar ex ƴaŋ gër orën an! Ga w̃asin këɓi gër ebar ɓela ɓën enjaran endexëm eŋ, dodo eceɗe këɓi fuŋara wa ɓela ɓën, do eni cotaxën aketëxeta aŋ gër ngwën ro! Awa ɓetalexëni ɓër h̃an këŋo Kaxanu ɓën!» ");
INSERT INTO bsc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","And ɓaka këni omeleka ƴaŋ gër orën aŋ, ɓëxaɗac ɓën felër këni eni ƴe xali gër Betëlexem, eni watëgu er sëfëtan këɓi Axwën in. ");
INSERT INTO bsc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na w̃ara këni xali gër ɓëciw̃. Ga h̃at këni, sëk kënëɓi Mari gë Yosef lëf gër eciỹi ga ren këno lëmëta in polo gër apeɗe. ");
INSERT INTO bsc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sam ga wat këno, sëfëtan kënëɓi ɗek ɓend felëgu baɓi meleka ɓeŋ end lëmëta ijo eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Do ɗek ɓër baɓi ɓaxëtënd ɓëxaɗac ɓëjo ɓën mbaŋ baɓi ŝaranënd end bani reƴand eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari mëŋ, ɗek ɓeŋo baxo w̃ëxëtand gër anëf andexëm do baxo yixëtënd gër onden. ");
INSERT INTO bsc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ata ga këni ɓaka gër ocënga, ɓëxaɗac ɓën këno ŝëkwand Axwën Kaxanu do këno yasëxënd tar fëña in. ");
INSERT INTO bsc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yatir sëk këŋo loxo, xac këno lëmëta in. Yël këno ow̃ac or Yesu ol, ang fel baɓi meleka in eno macëɗ ak ɗamana exo gixën nëm gë acël. ");
INSERT INTO bsc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","And faỹ ko Mari ɓakey ɓand ebax exo w̃unëtara ɓaŋ, ang rëp bax gër acariya and Moyis ak, mëŋ gë Yosef w̃ëla këno lëmëta in gër Yerusalem, eno maŝëx oxwën ol Axwën Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ata mondako sëf bani er ỹëgw këni gër acariya and Axwën in: «Itox itoŝan iñanar yo, Kaxanu yata këŋo.» ");
INSERT INTO bsc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ŝaɗaxa ebax eni di ang re ko Axwën Kaxanu gër acariya ak: olëxwëte oxi, hi këni oxwëlëkwël, hi këni oɓapuỹ. ");
INSERT INTO bsc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Awa gër angol and Yerusalem, axarëk ebaxëna ar bano w̃acënd Simewoŋ. Ala ar ŝenene ebaxo do fëɓ baxo mbaŋ end Kaxanu eŋ. Aŝëni baxo ŝënind ɓëte apexa and enëng end Isërayel aŋ, do ỹëm baxo gë Angoc Amënëk aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Angoc Amënëk aŋ nangën baŋo mëne axo cës na watërëxe Afexën an, ar sana këŋo Axwën Kaxanu an. ");
INSERT INTO bsc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yatijo Angoc Amënëk aŋ fangacëgu baŋo gër Aciw̃ and Kaxanu. Na fed këni gë Mari do gë Yosef ga xwënaw këno lëmëta in, eni di er rek acariya in. ");
INSERT INTO bsc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simewoŋ xana këŋo, xwëna këŋo imëd. Ga këŋo ŝëkwa Kaxanu ko rend: ");
INSERT INTO bsc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Dodo Axwën, kanale wëno xaɗëp ireƴ in, me ƴeli gë emëkw eƴemax ang re baƴ ak, ");
INSERT INTO bsc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","gayikako gë ɓangës ɓandam baŋo dëŋ këmo watënd ar w̃ëlanëgu këɓo apexa an. ");
INSERT INTO bsc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Apexa aŋo xëñënaw këƴ eni wat ɓenëng ɓend ɓela ɗek, ");
INSERT INTO bsc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Apexa aŋo ex angoɓen and këni nangëraxën ɓenëng ɓend ɓela aŋ, Apexa aŋo ex enjaran end Isërayel eŋ, ɓulunda ireƴ in.» ");
INSERT INTO bsc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nëm gë sëm ir lëmëta ɗek baɓi ŝaranënd ga këni wël ang baxo yeƴan Simewoŋ end lëmëta ireɓën ak. ");
INSERT INTO bsc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ata Simewoŋ ga ŝalen këɓi na, fel këŋo Mari: «Në end lëmëta ireƴ ijo, ɓela ɓëranjëm kë lati. Ɓëte ɓëranjëm kë xani gër ɓulunda ir Isërayel. Lëmëta ireƴ ijo këɓi ỹana eɓi nangënënd er ỹandi këŋo exo di Kaxanu in. Awa në eŋo këno ŝusaxën. ");
INSERT INTO bsc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ado wëj dëŋ Mari, ang sënga këni gë duxuma fo ki ƴambën gër emëkw endexëm eŋ. Do mondako kë futaya ojëlan od ɓela ɓëranjëm.» ");
INSERT INTO bsc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɓëte alaw̃ënel asoxari hi baxëna ar bano w̃acënd Ana. Mëŋ aɓiw̃ ar Fanuwel ebaxo, gër andëw̃ëra and Aser, do mbaŋ xar baxo. Endënaw̃ emeja fo ɓayi baxo ga ỹër këno, do liya bani gë icën indexëm iŋ ɓëniy ɓënjongëɓëki ɗamana seɓëtaxën këŋo. ");
INSERT INTO bsc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ga lap këŋo icën iŋ, ɓayi ko asoŝan këm xali sëk këŋo ɓëniy ofëxw ocongosas gë ɓënax. Abaxo h̃awëta na Aciw̃ and Kaxanu aŋ. Er baŋo ŝalend Kaxanu: baŋo gëmëɗ, ɓaŋo goyat. Ado ɓakey ɓandëmar motiw̃i baxo siw̃ind. ");
INSERT INTO bsc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gë mëŋ fed bani ɓëte gë Mari do gë Yosef ga xwëna këno lëmëta in. And wat këɓi aŋ, ỹana ko këŋo ŝëkwand Kaxanu end lëmëta eŋ. Ata kwël na fo ỹana baxo këɓi felërand end lëmëta eŋ ɓër bax ŝënind apexa and Yerusalem ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","And faỹ këni ɗek er ebax eni di aŋ, ang rek acariya and Axwën ak, Yosef gë Mari w̃aỹi këni gë lëmëta in gër ebar ed Galile, gër Nasaret angol andeɓën aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ata lëmëta in kwël ko firind do ko ỹëmënd gë orenik ol, do oyekax or Kaxanu ol hik gër ola orexëm. ");
INSERT INTO bsc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ɓëxarëk ɓër Yesu ɓën aƴe bani ƴend aniy kala ƴaŋ gër Yerusalem, gër ofëna or apexa. ");
INSERT INTO bsc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","And sëk këŋo Yesu ɓëniy epëxw gë ɓëki aŋ, sëfër këni gër ofëna gë ɓëxarëk ɓërexëm ɓën ang rëp bax ak. ");
INSERT INTO bsc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Awa ga xucak ɓakey ɓand ofëna ɓaŋ, ɓëxarëk ɓër Yesu ɓën këni w̃aỹind gër Nasaret nangërëxe mëne anëka seɓëgu këno gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Er yëla bani ba gë ɓëcandaw̃ ɓëŋ lëngwa këni. Ƴe këni ciŝ ɗamana ŝalaraxën këno gër ɓëreɓën do gër ɓër hi bani enga. ");
INSERT INTO bsc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aŝalara yo aŝalara, ano wat ex na. Ata wërëŝëta këni xali gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","And h̃at këni aŋ, ŝalarax këno ɓëte okey otas ɗamana ŝananaxën këno lëf gër Aciw̃ and Kaxanu ga ỹëpa ko mërëxand ir ɓëŝalen ɓër Ɓëŝëwif. Na baɓi ɓaxëtërand do baɓi w̃ëkarand. ");
INSERT INTO bsc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɗek ɓër baŋo wëlënd ɓën baɓi ŝaranënd ang baxo yakand gë orenik osëm er këno w̃ëka yo. ");
INSERT INTO bsc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","And wat këno aŋ, nëm gë sëm ŝaran këɓi xali. Na w̃ëka këŋo nëm: «Oko asëñiw̃ën, inew̃a rixën këƴëɓo endako rako eŋ? Nëkoɗa wëno gë sorix ɗek ɓu baɓo gër ocal odeƴ?» ");
INSERT INTO bsc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ata Yesu yaka ko: «Inew̃a këne ŝalaxënënd? Wën an nang ex na nde mëne aỹap ỹapëk me gi gër Aciw̃ and Faba?» ");
INSERT INTO bsc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ɓarikan ga wël këni ang yaka baxo ak, aɓi pëni bana er baxo rend in. ");
INSERT INTO bsc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ata kwël w̃aỹi këni gë mëŋ ak gër Nasaret. Yesu mbaŋ fëɓ baɓi ɓëxarëk ɓërexëm ɓën. Do Mari mëŋ, ɗek ɓeŋo baxo w̃ëxëtand gër emëkw edexëm. ");
INSERT INTO bsc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ata Yesu kwël ko firind gë orenik ol, gë oyekax or Kaxanu ol do ɓela ɓën mbaŋ baɓi nënganënd endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Amëd aŋo ɓët baxo owun ol gër Rom Tiber Sesar, do sëk baŋo ɓëniy epëxw gë ɓënjo elod ga ỹëpa ko. Ata Poŋës Pilat ebax gofërëner in gër ebar ed Yude do ɓër ebax aminëmëra ɓën wun bani: Erod Antipas, gër ebar ed Galile, Filip, gër ed Iture xali gër ed Tërakoni, do Lisañas, gër ed Abilen. ");
INSERT INTO bsc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Amëd aŋo, An gë Kayif ebax ɓëŝaɗaxan ɓëlëngw ɓën gër Yerusalem. Amëd aŋo fo ɓëte ỹana baxo Ŝaŋ Batis, asëñiw̃ ar Sakari an, epemëra ed eyeƴan ed Kaxanu el gër ladawe. ");
INSERT INTO bsc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ata Ŝaŋ Batis motëfëra baxo sëfërand ɗek ɓëngol ɓënd ler ler gër yeɓ ir Yurëdeŋ ɓëŋ do baxo femërand gër ɓela end xoɓuyi or enëngwët ed ola ol, eɓi teɓanaxën Kaxanu ɓamena ɓandeɓën ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ata mëŋ ebax ar ỹëgw baxo elod anëka fo alaw̃ënel Esayi mëne ala kë ƴow na exo keỹërand gër ladawe: «Ñanin fëña ir Axwën in, Ɗebëtin opëña od ko xucaxën ok. ");
INSERT INTO bsc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Amora and ex yo ɗek kë wëgaya, Etënd ed ex yo, do apan and ex yo ɗek kë yëcar, Fëña ir sëmbak alebëta kë lebëta, Fëña ir ŝëngayak yo ah̃aca këni h̃aca, ");
INSERT INTO bsc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eni nangëraxën ɗek ɓela ɓën apexa and law̃ëneliw këɓo Kaxanu aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ata Ŝaŋ Batis mondako baɓi felënd ɓër bax ƴowënd eɓi ɓuyi ɓën: «Wën ata ang ɓandën fo siti kën ɗe, noỹo wa fel këŋun en kwëỹëta kiti ind Kaxanu ind kë ƴowënd iŋ? ");
INSERT INTO bsc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Diyindën ɗe ɓenjekax ex watixën mëne anëngwët dëŋ nëngwët kën ola orewën ol. Ɓari këren yëland na mëne gayik Abëraxam ex axarëk arewën an kën fexaxën. Kaxanu axor ko xor exo nëngwët oxaỹ oŋo dëŋ ex gi oɓaŝ or Abëraxam. ");
INSERT INTO bsc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ado gogo nde w̃eɗ ko ecëngwa el exo taw̃ gë oɗëmbët ak ɓatëx ɓand ax dëw̃ënd na odëw̃ërëw̃en ojekax ɓaŋ. Ata mondako këɓi weɗit ɓër ɓayik ax nëngwëtënd na ola oreɓën ɓën do eɓi ɗap gër xoɗux.» ");
INSERT INTO bsc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ata amëxwër aŋ w̃ëka këno Ŝaŋ Batis: «Inew̃a ỹapan këŋo Kaxanu mi dind ɓiyi?» ");
INSERT INTO bsc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaka këɓi: «Ar gë ɓacuɗ ɓaki an, cetëleŋo amat ar ax cot ex na an, do ar gë eƴamb ƴamb an, dilexo mondako fo.» ");
INSERT INTO bsc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ƴow këni ɓëte ɓësëf ɓër ŝagale eɓi ɓuyi, w̃ëka këno: «Asëƴali, inew̃a ỹapan këŋo Kaxanu mi dind ɓiyi?» ");
INSERT INTO bsc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yaka këɓi: «Kanayindën ŝagale in ceƴ ang ỹapëk ak, këren mëkand na nëmëc.» ");
INSERT INTO bsc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ƴow këni ɓëte ocoroɗa, w̃ëka këno: «Do ɓiyi cëŋ, ine ỹapan këŋo Kaxanu mi dind?» Yaka këɓi: «Ala këreno nëgwëŝanënd na mama eno kandëraxën. Ɓayindëleŋun acosa andewën aŋ fo.» ");
INSERT INTO bsc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ata angwën aŋo dëŋ bano ŝënind ɗe ɓulunda ir Isërayel in ar këɓi fexën an aw̃ëkar bani w̃ëkarënd ba ax gi ex na Ŝaŋ Batis ex Afexën an. ");
INSERT INTO bsc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ŝaŋ Batis yaka këɓi ɓën ɗek: «Wëno gë men këmun ɓuyind, ɓarikan në eƴow exo ar xuca ke panga an. Ado wëno dëŋ axe ñap ex na mo tëka do me pëtëra ogux od ɓapeɗ ɓandexëm ok. Mëŋ ex ar këŋun ɓuyi gë Angoc Amënëk do gë xoɗux an. ");
INSERT INTO bsc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Apalaŝa lëkaya ko exo mënënaxën eɓar edexëm el, eƴamb el exo mëla gër acac andexëm, do enenar eŋ exo ɗap gër xoɗux or ax ɗomind na gë eɗomi.» ");
INSERT INTO bsc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ata Ŝaŋ Batis mondako baɓi felërand Atëfëtan aŋ Ɓëyisërayel ɓën. Ɓëte ɓendanjëm baɓi sëndënd do baxo rend eni këñënara. ");
INSERT INTO bsc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Erod ir wun bax gër ebar ed Galile watar bani na gë Erojad, asoxari ar aɓinëm an. Ata Ŝaŋ Batis këŋo nëpënd në end eŋo do gë ɗek ɓeñëŋënax ɓend wata baxo ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ɓarikan Erod ijo w̃endëra ko kaŝ-kaŝ ga sëra baŋo Ŝaŋ Batis do w̃ëla këŋo gër epëra. ");
INSERT INTO bsc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Amëd aŋo, ɗek Ɓëyisërayel ɓën bax ƴend gër Ŝaŋ Batis eɓi ɓuyi. Ata ga ƴow ko ɓëte Yesu, ɓuyi këŋo mëŋ ɓëte. Yesu ga ŝëpëta ko, ko ŝalend, ata watik fol orën ol. ");
INSERT INTO bsc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Angoc Amënëk aŋ fedaw ko gër ndexëm ang eɗëxwëte epeŝax fo. Ata wëliwëk oniw̃ ƴaŋ gër orën: «Wëj ex Asëñiw̃ën ar pëlot gër yomb iram an. Wëno ɓon ke ɓalënd endeƴ eŋ!» ");
INSERT INTO bsc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ɓëniy ofëxw osas ebaŋo nand ỹana ko andiyen andexëm na. Er bani yëland ɓela ɓën mëne Yosef, asëñiw̃ ar Eli an, ebax sëm. ");
INSERT INTO bsc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ijo ebax asëñiw̃ ar Matat, do Matat asëñiw̃ ar Lewi. Lewi ebax asëñiw̃ ar Melëki, do Melëki asëñiw̃ ar Yanay. Yanay ebax asëñiw̃ ar Yosef. ");
INSERT INTO bsc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef ebax asëñiw̃ ar Matacas, do Matacas asëñiw̃ ar Amos. Amos ebax asëñiw̃ ar Nahum, do Nahum asëñiw̃ ar Esëli, do Esëli asëñiw̃ ar Nagahi. ");
INSERT INTO bsc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagahi ebax asëñiw̃ ar Mahat, do Mahat asëñiw̃ ar Matacas. Matacas ebax asëñiw̃ ar Semehin, do Semehin asëñiw̃ ar Yose. Yose ebax asëñiw̃ ar Yoda. ");
INSERT INTO bsc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ebax asëñiw̃ ar Yohanan, do Yohanan asëñiw̃ ar Resa. Resa ebax asëñiw̃ ar Sorobabel, do Sorobabel asëñiw̃ ar Ŝehalëcel. Ŝehalëcel ebax asëñiw̃ ar Neri. ");
INSERT INTO bsc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ebax asëñiw̃ ar Melëki, do Melëki asëñiw̃ ar Adi. Adi ebax asëñiw̃ ar Kosam, do Kosam asëñiw̃ ar Elëmadam. Elëmadam ebax asëñiw̃ ar Er. ");
INSERT INTO bsc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ebax asëñiw̃ ar Yesu do Yesu ebax asëñiw̃ ar Eliyeser. Eliyeser ebax asëñiw̃ ar Yorim, do Yorim asëñiw̃ ar Matat. Matat ebax asëñiw̃ ar Lewi. ");
INSERT INTO bsc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ebax asëñiw̃ ar Simewoŋ do Simewoŋ asëñiw̃ ar Yuda. Yuda ebax asëñiw̃ ar Yosef, do Yosef ebax asëñiw̃ ar Yonam. Yonam ebax asëñiw̃ Eliyakim. ");
INSERT INTO bsc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ebax asëñiw̃ ar Meleya, do Meleya asëñiw̃ ar Menan. Menan ebax asëñiw̃ Matata, do Matata asëñiw̃ ar Nataŋ. Nataŋ ebax asëñiw̃ ar Dafid, ");
INSERT INTO bsc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","do Dafid asëñiw̃ Esayi. Isayi ebax asëñiw̃ ar Yobed, do Yobed asëñiw̃ ar Bohes. Bohes ebax asëñiw̃ ar Sala, do Sala asëñiw̃ ar Nahason. ");
INSERT INTO bsc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason ebax asëñiw̃ ar Aminadab, do Aminadab asëñiw̃ ar Adëmin. Adëmin ebax asëñiw̃ ar Arëni, do Arëni asëñiw̃ ar Esëroŋ. Esëroŋ ebax asëñiw̃ ar Peres, do Peres asëñiw̃ ar Yuda. ");
INSERT INTO bsc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ebax asëñiw̃ ar Yakob, do Yakob asëñiw̃ Isak. Isak ebax asëñiw̃ ar Abëraxam, do Abëraxam asëñiw̃ ar Tera. Tera ebax asëñiw̃ ar Naxor. ");
INSERT INTO bsc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naxor ebax asëñiw̃ ar Serug, do Serug asëñiw̃ ar Rehu. Rehu ebax asëñiw̃ ar Peleg, do Peleg asëñiw̃ ar Eber. Eber ebax asëñiw̃ ar Ŝela. ");
INSERT INTO bsc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ŝela ebax asëñiw̃ ar Kayënam, do Kayënam asëñiw̃ ar Arëfaxad. Arëfaxad ebax asëñiw̃ ar Ŝem, do Ŝem asëñiw̃ ar Nowe. Nowe ebax asëñiw̃ ar Lemek. ");
INSERT INTO bsc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ebax asëñiw̃ ar Matusalem, do Matusalem asëñiw̃ ar Enok. Enok ebax asëñiw̃ ar Yered, do Yered asëñiw̃ ar Malelel. Malelel ebax asëñiw̃ ar Kenam. ");
INSERT INTO bsc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenam ebax asëñiw̃ Enoŝ, do Enoŝ asëñiw̃ ar Set. Set ebax asëñiw̃ ar Adam, do Adam asëñiw̃ ar Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu, ga ỹëmëgu ko gë Angoc Amënëk aŋ gër yeɓ ir Yurëdeŋ, ko ƴend gër ladawe gër ed baŋo w̃ëland Angoc Amënëk aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ata ŝaɓucara in xacërara këŋo eŋo yifa në ɓakey ofëxw onax. Ỹoweỹ axo ƴamb bana Yesu ɓakey ɓaŋo ɗek. And xucak aŋ, xor këŋo enjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aŋo sëka këŋo ŝaɓucara in, re ko: «Angëmëne Asëñiw̃ ar Kaxanu eƴ, nëngwëtël ekaỹ elo ex gi ecemar.» ");
INSERT INTO bsc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yaka ko Yesu: «Ga ỹëgw këni: “Ala an axo ɗiyand na gë eƴamb ƴamb fo.”» ");
INSERT INTO bsc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ŝaɓucara in w̃ëla këŋo në er ƴaŋ, do w̃asin këŋo aỹand ɗek owun or gër ebar oŋ, ");
INSERT INTO bsc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","do fel këŋo: «Ayël këmi yël owun or owar oŋo ol, gë enjaran endeɓën ak ɗek, gayik wëno fëxwën këne do ar ỹandi ke yo këmo yël. ");
INSERT INTO bsc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Awa angëmëne aw̃a w̃a këƴ eƴ poxi gër lëngw iram, wëj kë xwën ɗek ako.» ");
INSERT INTO bsc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yaka këŋo ɓëte Yesu: «Ga ỹëgw këni: “Axwën Kaxanu gaɓat ex mopëɓ do gër lëngw irexëm fo ỹapëk epoxi ed cale el!”» ");
INSERT INTO bsc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ŝaɓucara in w̃ëla këŋo ɓëte Yesu gër Yerusalem. Ga xwët këŋo ƴaŋ gër ejur ed Aciw̃ and Kaxanu, re ko: «Angëmëne Asëñiw̃ ar Kaxanu eƴ, ɗapayal. Ax gi ex na nde aỹëgw ỹëgw këni: ");
INSERT INTO bsc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Kaxanu afel këɓi fel omeleka odexëm ok eni nëkona do eni kaka, ");
INSERT INTO bsc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","gë otaxan odeɓën ok këdi këƴ lapa në ekaỹ.”» ");
INSERT INTO bsc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yaka këŋo ɓëte Yesu: «Ga ỹëgw këni ɓëte: “Axo gi ex na mondi atëƴ Kaxanu, Axwën areƴ an.”» ");
INSERT INTO bsc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ata na ŝaɓucara in ga xacërara këŋo mondako eŋo yifa Yesu, nacëta këŋo do ko ŝënind amëd acëxe. ");
INSERT INTO bsc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ga xucak eŋo, Yesu w̃aỹi ko gë panga ind Angoc Amënëk iŋ, ata wëlik ow̃ac orexëm ol ɗek ebar ed Galile el. ");
INSERT INTO bsc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aŋo ỹana ko këɓi sëƴalirand gër ɓaciw̃ ɓacaleya ɓandeɓën do ɓela ɓën ɗek baŋo ŝëkwënd. ");
INSERT INTO bsc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ata akey amat, Yesu ɓaka ko gër ingol ind Nasaret, gër ed raf ko. Do ang w̃ër baŋo ak, ƴe ko gër aciw̃ acaleya, yatir akey and eteyëta; ata fel këno exo kani eɓi pënën. ");
INSERT INTO bsc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Fëxwën këno akayëta and alaw̃ënel Esayi aŋ, and lëkwët ko aŋ ko fënënd gër ed rek: ");
INSERT INTO bsc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Gë Angoc and Axwën aŋ ỹëm këme gayik mëŋ sana ke mëni nangën Atëfëtan aŋ ɓëxaỹënaxik ɓën. Mëŋ law̃ënëgu ke mëni pelëra mëne: ɓër ex okaɗëp ɓën aseɓët kënëɓi seɓët; ɓëŝiw̃ëk ɓën awatëra këni watëra; ɓër kënëɓi wëñarand ɓën aracët këɓi racët. ");
INSERT INTO bsc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mëŋ law̃ënëgu ke me pemëra mëne dohijo ỹanak oyekax or Axwën olo.» ");
INSERT INTO bsc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ga h̃ata ko opën ok, lëkw ko akayëta aŋ, w̃aŝ këŋo aw̃ëxëta an, do ỹëpa ko. Ata aciw̃ acaleya aŋ ɗek faɓ këno mëŋ fo. ");
INSERT INTO bsc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aŋo re ko: «Oñëgw Omënëk od fënën këmun oko, doro dëŋ h̃atak.» ");
INSERT INTO bsc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓën ɗek bax reƴand end osede orexëm eŋ ga këni wël ɓenjekax ɓend baxo yeƴanënd ɓeŋ. Aw̃ëkar bani w̃ëkarënd: «Ax gi ex na nde asëñiw̃ ar Yosef an ex?» ");
INSERT INTO bsc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ɓarikan Yesu re ko: «Ɗal ex mëne wën axwitan këne xwitan eyeƴan ed orenik ed rek: “Wëj axora an pakënayayind gë andeƴ” Ɓëte afel këne fel me di ɓecarax gër angol and raf këme ro ang wël kën këme rind gër Kafarënawum ak.» ");
INSERT INTO bsc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ata re ko ɓëte: «Ɗal in këmun felënd, alaw̃ënel ar Kaxanu an, gër ed rëw̃ këno fo ɓayik ano pëɓënd na. ");
INSERT INTO bsc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɗal in këmun felënd, amëd and ebaxo Eli alaw̃ënel ar Kaxanu gër ebar ed Isërayel aŋ, ɓon ỹëmb bani ɓësoxari ɓëseɓëta seɓëta ɓën. Ga rik ɓëniy ɓëtas gë opacaw̃ ocongiɓat tëɓ ax tëɓ ex na, ata wëcan këɓi enjo eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ɓarikan, Kaxanu seɓ këɓi ɗek ɓësoxari ɓëjo, law̃ën këŋo Eli në asoxari ar lëg bax gër Sarepëta, gër ebar ed Sidoŋ. ");
INSERT INTO bsc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɓëte angwën and ebaxo Elise alaw̃ënel ar Kaxanu gër ebar ed Isërayel aŋ, mbaŋ ebani ɓela ɓër gë ameỹ ɓën. Ɓarikan Namaŋ gaɓat fakën baŋo, xarak gër ebar ed Siri xaniw baxo.» ");
INSERT INTO bsc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ga wël këni eyeƴan elo, ɗek aciw̃ acaleya aŋ logën këɓi. ");
INSERT INTO bsc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xani këni gwaŋ, do ŝonjorëra këno Yesu fac-fac. Nëcët këno angol and Nasaret aŋ xali gër engew̃ eno pimëx. ");
INSERT INTO bsc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ɓarikan, and h̃ateli këno aŋ, Yesu xwëŝa ko. Ata ang fur bano ak, ɓorëta këni, xuca ko mërëxand do kwël ƴe ko. ");
INSERT INTO bsc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu ŝëla ko gër Kafarënawum, angol acëxe and gër ebar ed Galile. Ata yatir akey and eteyëta këɓi sëƴalirand ɓëte ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Gër ow̃ëkw baɓi lëkënd osëƴali orexëm ol gayik gë panga baxo yeƴanënd. ");
INSERT INTO bsc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yatijo ar gë ɓangoc ɓañëŋënax ƴow bax na gër aciw̃ acaleya. Sam ga wat këŋo Yesu, ɓangoc ɓañëŋënax ɓaŋ xeỹ këni: ");
INSERT INTO bsc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Xey Yesu Iɓënasaret, inew̃a yir këɓo? Ba eƴëɓo nemin nde ƴow këƴ? Aye nang këmi mëne wëj ex Aw̃ënëk ar Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ata Yesu xeỹënaxën këɓi ɓangoc ɓaŋ: «Cësinayin, ado canin gër ala ajo!» Ata ɓangoc ɓañëŋënax ɓaŋ reɓa këno ala ajo mërëxand ir amëxwër do kwël ŝan këni, ɓari ano tembaỹën bana. ");
INSERT INTO bsc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ata aciw̃ acaleya aŋ ɗek ŝarandëra këɓi xali xurik, do këni w̃ëkarënd: «Endeƴ end fex ngwa ex eŋo? Gë or gapak, do gë panga këɓi felënd ɓangoc ɓañëŋënax ɓaŋ eni di er ko re in, do kwël këni ŝanënd.» ");
INSERT INTO bsc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ata ɓela ɓën ɗek këni xanarërand end Yesu eŋ ɗek ebar ed Galile el. ");
INSERT INTO bsc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ga ŝan ko na gër aciw̃ acaleya, Yesu ƴe ko gër Simoŋ Piyer ɓën. Sëk këŋo aỹaraw isoxari ar Simoŋ Piyer ga ŝëxw këŋo. W̃ëka këno ataŋ Yesu eŋo pakën. ");
INSERT INTO bsc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ga rëngw ko Yesu gër ed laki baxo, xeỹënaxën ko acëxwël aŋ. Ataŋ fak ko do kwël xani ko eɓi ɗëɓa. ");
INSERT INTO bsc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ga ŝëlak eñan eŋ, w̃ëlaraw kënëɓi na gër Yesu ɗek ɓëŝëxwëra ɓën, do oŝëxwëra or ex yo afak bani fakënd and këɓi h̃ëmba aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɓëte ɓëyël bax ŝanënd na gër ɓela do bani xeỹënd: «Wëj ex Asëñiw̃ ar Kaxanu an.» Ɓarikan Yesu axeỹënaxën baɓi xeỹënaxënënd do abaɓi seɓ na eni yeƴan gayik anang nang bani mëne mëŋ ex Afexën an. ");
INSERT INTO bsc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","And wecak aŋ, Yesu ŝan ko do nacëta ko në er tëɓ. Ata ga ɓarërëgu këni ɓela ɓën ɓamëxwër, ɓamëxwër, këno ŝalarand xali ŝanan këno. Er ỹandi baɓi eno ɗëkaya na këdi ko ƴe eɓi teɓ. ");
INSERT INTO bsc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ɓarikan mëŋ yaka këɓi: «Aỹap ỹapëk me ƴend ɓëte mëni nangëndërax Atëfëtan and owun or Kaxanu aŋ gër ɓangol ɓacëxe gayik eŋo law̃ënaxënëgu ke Faba.» ");
INSERT INTO bsc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mondako baxo femërand Atëfëtan aŋ gër ɓaciw̃ ɓacaleya ɓand Ɓëyude. ");
INSERT INTO bsc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Akey amat, Yesu baɓi sëƴalirand amëxwër aŋ ler gër anjer and Genesaret. Ɓela ɓën ga xeta këno gër oɓaxët or eyeƴan ed Kaxanu, këni fimërërand. ");
INSERT INTO bsc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ata Yesu wat ko ɓëkuluŋ ɓëki gër ɓëŋa. Eceɗe feda bani ɓëŝëpët ɓër oxan ɓën do bani wëŝëtërand owën oreɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ga fëra ko polo gër ikuluŋ ind xwën baxo Simoŋ, xara këŋo exo nacëta tëkër ebar el, gand etiw̃ax. Ata ỹëpa ko, do këɓi sëƴalind amëxwër aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","And h̃ata ko aŋ, fel këŋo Simoŋ: «Mëlal ikuluŋ iŋ gër etiw̃ax en ɗap owën oŋ ata kënëɓi sëra oxan ol.» ");
INSERT INTO bsc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yaka ko Simoŋ: «Asëƴali, ɓiyi wec lapëra këmi, ỹow̃eỹ amo cëpët ex na. Ɓarikan gayik wëj rek alap këmi lap owën oŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ata ga lap këni, sëra kënëɓi oxan ol xali kë h̃esind owën oreɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lambaca kënëɓi ɓëcandaw̃ ɓëndeɓën ɓëŋ eni ƴow enëɓi dëca gë ikuluŋ icëxe iŋ. Oxan ol fëxw këni gër ɓëkuluŋ ɓëki xali kë rëmbënd men oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ata Simoŋ Piyer ga wat ko eŋo, ŝëpëta ko. Ga foxi ko gër lëngw ir Yesu, re ko: «Axwën, inew̃a sëkaxënëgu këƴe wëno aw̃endëran ajo?» ");
INSERT INTO bsc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Anjiỹ aŋ lëk baɓi Simoŋ gë ɓoŝandaw̃ ga wat këni ang ỹëmb bani oxan or sëra kënëɓi ak. ");
INSERT INTO bsc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mondako fo bax end Ŝak do gë Ŝaŋ eŋ, ɓosëñiw̃ ɓor Sebede ɓën, ɓër ɓar bani andiyen amat gë Simoŋ Piyer ɓën. Ata Yesu fel këŋo Simoŋ Piyer: «Këreƴ yëdara na, gërëgako aɓar ar ɓela këƴ hi!» ");
INSERT INTO bsc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ata ga ŝëpët këni ɓëkuluŋ ɓëŋ gër ebar, seɓëra këni na ɗek gër ɓëŋa, do kwël sëf këno Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Akey amat, Yesu bax ƴend në angol. Ata fed këni gë ala ar gë ameỹ. Ala ajo foxi ko gër lëngw irexëm, ŝale ko mondako: «Axwën, ga ỹandi ỹandi ki axor këƴ xor eƴe mënën me pak.» ");
INSERT INTO bsc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ata Yesu ga yën ko ataxan aŋ, h̃ëmba këŋo, re ko: «Awa aỹandi wa ỹandi ke, mënël!» Ataŋ ŝan këŋo ameỹ aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu xëŋa këŋo mondako: «Ala këreƴëŋo pel na ɗe eŋo. Ɓarikan ƴel exi nëkon aŝaɗaxan an. Ɓëte diyiɗ ŝaɗaxa ir ew̃unëtan in ang rek acariya and Moyis ak, eni nangëraxën ɓela ɓën osede oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ata ow̃ac or Yesu ol wëlik kaŝ-kaŝ, do ɓela ɓën ɓamëxwër ɓamëxwër bani ɓarërënd: ɓëjo ɓër oɓaxët, ɓëjo ɓëŝëxwëra ɓër kë ŝaland eni pak. ");
INSERT INTO bsc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ɓarikan Yesu mëŋ ed timëriŋ el baxo nacëtand exo calex. ");
INSERT INTO bsc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Akey amat, Yesu baɓi sëƴalirand ɓela. Gër ɓër baŋo ɓaxëtënd, ofariseŋ do gë ɓëŝalen ỹëpara bax na. Ɓër oɓaxët ɓën ɗek, er xaniraw bani: ɓëjo gër ɓëngol ɓënd gër ebar ed Galile, ɓëjo gër ɓënd Yude, xali gër Yerusalem. Gë panga ind Axwën Kaxanu iŋ baɓi fakëndërand. ");
INSERT INTO bsc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ata h̃atëgu këni na ɓela ɓër w̃ëlaw këŋo aseỹik në angaw̃. Er bani ŝaland eno ɗën lëf gër aciw̃ and hi baxo Yesu, do eno kwëtina gër lëngw irexëm. ");
INSERT INTO bsc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ga ŝënd këni ɓela ɓën gër ebët, wëlan këɓi ang këno lën ak gër ed hi ko Yesu. Ata sënga këni ƴaŋ gër ejur ed aciw̃, do yëla këno gë angaw̃ ak aseỹik an, mërëxand ir amëxwër, gër lëngw ir Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ga wat ko Yesu ang xwëta këno ɓela ɓëjo ak, fel këŋo aseỹik an: «Wëno anëka seɓan këmi ɓamena ɓandeƴ ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɓëŝalen ɓën do gë ofariseŋ ok ga wël këno, këni nëkënëkarënd: «Noỹo ngwa hi ko ar këŋo ŝirënd Kaxanu ajo? Noỹo xorëk eteɓan ed ɓeñëŋënax el ang ax gi ex na Kaxanu gaɓat?» ");
INSERT INTO bsc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ga nang ko Yesu ang bani yëland ɓëŝalen do gë ofariseŋ ak, w̃ëka këɓi: «Inew̃a kën yëlaraxënënd mondako gër ow̃ëkw orewën? ");
INSERT INTO bsc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Inew̃a saxëk, me de: “Anëka seɓan këmi ɓamena ɓandeƴ ɓaŋ nde”, ba me de: “Kanil eƴ ƴexëra nde?” ");
INSERT INTO bsc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Awa, en nangaxën mëne wëno Asëñiw̃ ar ala an aŝot ŝot këme or gapak or eteɓan ed ɓeñëŋënax ol gër ebar ro, këmo felaxënënd aseỹik ajo: “Kanil eƴ meɗ angaw̃ andeƴ aŋ, eƴ maỹi!”» ");
INSERT INTO bsc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ata na dëŋ aseỹik an xani ko xwiriŝ, lëkw ko ebën ed lakixën baxo el. Ga ko w̃aỹi, këŋo ŝëkwaxënd Kaxanu tar fëña in. ");
INSERT INTO bsc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓela ɓër ebax na ɓën ɗek, ga xap këɓi anjiỹ aŋ, këno ŝëkwand Kaxanu këni rend: «Awa ɓiyi eceɗe këne watënde ɓecaraxik ɓendako rako ɓeŋ doro!» ");
INSERT INTO bsc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ga xucak eŋo, Yesu ŝan ko na gër ed ebaxo, ata wat këŋo asëf ar ŝagale, ar bano w̃acënd Lewi, ga ỹëpa ko lëf gër aciw̃ and ɓësëf ɓër ŝagale. Ata fel këŋo: «Wëj, tëfëguye!» ");
INSERT INTO bsc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi xani ko, seɓ ko ɗek na, do kwël sëf këŋo. ");
INSERT INTO bsc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi rin këŋo Yesu ofëna osëm gër iciw̃ indexëm. Ɓësëf ɓër ŝagale ɓëranjëm do gë ɓela ɓëŝëxe ƴowëraw këni do ỹëpara këni gë Yesu gër eƴambëran. ");
INSERT INTO bsc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ata ofariseŋ ok do gë ɓëŝalen ɓëreɓën ɓën ga ƴow këni gë oxoỹ fo na, kënëɓi hëbandërand ɓësëfan ɓër Yesu ɓën: «Wën inew̃a kën ƴambëraxënënd do kën ŝeɓëraxënënd gë ɓësëf ɓër ŝagale ɓën do gë ɓëw̃endëran ɓën?» ");
INSERT INTO bsc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yakaw këɓi Yesu: «Ɓëŝëxwëra ɓën kë ƴend gër axora, ax gi ex na ɓëɓëngw ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wëno ɓëw̃endëran ƴow këme mëni pel eni nëngwët ola oreɓën ol, ax gi ex na ɓër ŝenene.» ");
INSERT INTO bsc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ofariseŋ ok do gë ɓëŝalen ɓën re këni: «Ɓësëfan ɓër Ŝaŋ Batis ɓën do gë ɓëreɓi ɓën laŋ këni siw̃ind ɓëte aŝale këni ŝalend. Ɓarikan ɓësëfan ɓëreƴ ɓën ñambëran do gë oŝeɓ fo xwënda këni.» ");
INSERT INTO bsc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu yaka këɓi: «Wën axor nde kën xor enëɓi tiw̃in oɗawo od ŝambenjar ir kë ỹërënd ok yatir ekana? ");
INSERT INTO bsc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aƴow kë ƴow ɓakey ɓand këni ŝapër ɓaŋ, amëd aŋo këni siw̃i.» ");
INSERT INTO bsc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ata re ko ɓëte Yesu gë apënëtal: «Ala ax ŋesand na anjëm angaŝax exo kaɗaxën na akarëk këdi kë h̃esi kaŝ-kaŝ aŋ. Ado anjëm angaŝax aŋ ax ñapënd na ekaɗ ed në akarëk el. ");
INSERT INTO bsc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɓëte ala ax cëlënd na ngoƴ ingaf në ɓamote ɓakarëk. Angëmëne ala exo di mondako, ngoƴ ingaf iŋ afëtin kë fëtin ɓamote ɓaŋ and kë ỹënënd aŋ, ata ex ɗexira, do ɓamote ɓaŋ ex nëxenara. ");
INSERT INTO bsc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Në ɓamote ɓangaŝax ỹapëk mocël ngoƴ ingaf iŋ. ");
INSERT INTO bsc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ala aŋo ñëw̃an na ngoƴ ingaf iŋ and ko sëƴi iñënëk aŋ. Ata ko re: “Iñënëk iŋ nëngak”.» ");
INSERT INTO bsc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu gë ɓësëfan ɓërexëm ɓën bax xucand në ocënga yatir akey and eteyëta. Ata ɓësëfan ɓën këni w̃iŝand ɓanjëra ɓaŋ, këni ɓoxoxind do këni ƴakënd. ");
INSERT INTO bsc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ofariseŋ odëmar w̃ëka kënëɓi: «Inew̃a kën rixënënd er ɓayik ax ñap ex na yatir akey and eteyëta in?» ");
INSERT INTO bsc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yakaw këɓi Yesu: «Wën an pën ex na nde er ri baxo Dafid in and ŝopar baɓi enjo mëŋ gë ɓër enga endexëm aŋ? ");
INSERT INTO bsc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ax gi ex na nde alilën lilën baxo lëf gër Aciw̃ and Kaxanu, w̃eɗëgu ko mburu ind aɓi ñap bana eni ƴamb iŋ, ŝet këɓi do ƴamb këni ɓën ɗek xarak ɓëŝaɗaxan ɓën fo ỹap baɓi eƴamb el?» ");
INSERT INTO bsc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Re ko ɓëte Yesu: «Awa nangin mëne wëno Asëñiw̃ ar ala an ex axwën ar akey and eteyëta an.» ");
INSERT INTO bsc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","H̃atëguk ɓëte akey and eteyëta acëxe, Yesu ƴe ko gër aciw̃ acaleya, këɓi sëƴalirand end Kaxanu eŋ. Ar gë ataxan and liw̃ ateỹik ƴow bax na. ");
INSERT INTO bsc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ata ɓëŝalen ɓën do gë ofariseŋ ok këno sitinalind Yesu ba afakën këŋo fakën ala ajo gë akey and eteyëta aŋ eni cotaxën end këno nagaŝanaxën. ");
INSERT INTO bsc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gogo nde ga wata ko Yesu ang bani yëland ak. Fel këŋo ar gë ataxan ateỹik an: «Wëj kaniw eƴ kwëŝa mërëxand ro!» Ata xwiriŝ ala ajo, xwëŝa ko. ");
INSERT INTO bsc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ata re ko Yesu: «Ɓaxëtin mun mëka. Inew̃a ỹapëk yatir akey and eteyëta? Edi ed enjekax nde, ba edi ed eñëŋënax nde? Epexën ed ala nde, ba eɗaw̃ ed ala nde?» ");
INSERT INTO bsc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","And nëkon këɓi jeƴ aŋ, fel këŋo ar gë ataxan ateỹik an: «Yënël ataxan aŋ!» Ga yën ko, fakëk ataxan aŋ ataŋ. ");
INSERT INTO bsc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ga xoỹ këni na ɓëŝalen ɓën do gë ofariseŋ ok, këni xanarënd ang këno ri Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ɓakey ɓaŋo, Yesu ƴe ko ƴaŋ në etënd eŋo calex Kaxanu, ata ŝale ko wec. ");
INSERT INTO bsc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gëɓër, w̃ac këɓi ɓësëfan ɓërexëm ɓën, do yata këɓi epëxw gë ɓëxi eni gi oparëxanda odexëm. ");
INSERT INTO bsc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ɓër yata baɓi ɓën ebani: Simoŋ ir nëngwët baŋo Piyer, do gë aɓinëm Andëre. Ŝak do gë Ŝaŋ, Filip do gë Barëtelemi. ");
INSERT INTO bsc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maco do gë Toma. Ŝak, asëñiw̃ ar Alëfe, do gë Simoŋ, aw̃er an. ");
INSERT INTO bsc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yud asëñiw̃ ar Ŝak, do gë Yuda Isëkariyot ar lëxw baŋo Yesu an. ");
INSERT INTO bsc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ata Yesu sëfër këni acëla-ŝëla gë ɓën xali në eŋar, gër ed ɓarërëgu bani amëxwër atëm and ɓësëfan ɓërexëm do gë amëxwër and ɓër xaniraw bax gër ebar ed Yude, gër angol and Yerusalem, xali gër ɓëŋa ir angwëngw, ler gër owar or Tir do gë Sidoŋ. Er ƴowëraw bani gër Yesu: ɓëjo ɓër oɓaxët, do ɓëjo ɓëŝëxwëra ɓër bax ŝaland eni pak. ");
INSERT INTO bsc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Afak bani fakënd ɓëte ɓër bax sorond në end ɓangoc ɓañëŋënax ɓand lil baɓi ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Amëxwër aŋ ɗek bani ŝaland eno kwixwëta Yesu gayik panga bax ŝanënd gër ndexëm do baɓi fakënënd. ");
INSERT INTO bsc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ga faɓ këɓi ɓësëfan ɓërexëm ɓën, re ko: «Nëngandërayindëleŋun wën ɓër sitarak gër onden ɓën, gayikwa wën xwënëk owun or Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nëngandërayindëleŋun wën ɓër këŋun ƴambënënd gërëgako enjo ɓën, gayikwa aw̃ed kën w̃ed. Nëngandërayindëleŋun wën ɓër kë sesërand gërëgako ɓën, gayikwa gër onënga kën hi. ");
INSERT INTO bsc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nëngandërayindëleŋun ado enun ŝus ɓela ɓën, ado enun ŋw̃ayërand aŋ, ado enun cirërand aŋ, ado enun ɓeŝërand në end ow̃ac orewën or këni yëland oỹëŋënax ex, në end ga xwëta këne wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Nëngandërayindëleŋun and kënun rixërand Ɓëŝëwif aŋ, mandërayindën onënga ol gayik amaŝën atëm kën sëkëx ƴaŋ gër orën. Enimin ɓëxarëk ɓëreɓën ɓën mondako banëɓi rixërand ɓëlaw̃ënel ɓër Kaxanu ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wën ɓër gë napul ɓën, aŋun ye ex na! Gayik anëka ŝot kën apexa andewën aŋ, do and gër ebar ro fo ex! ");
INSERT INTO bsc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wën ɓër w̃edëk gërëgako ɓën, aŋun ye ex na gayik axor këŋun xor enjo eŋ! Wën ɓër kë lepërand gërëgako ɓën, aŋun ye ex na, gayik ang ɓër oỹaw̃ fo kën ỹana en denitarand! ");
INSERT INTO bsc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Angëmëne ɓër ŝus ke ɓën kënun ŝëkwënd, aŋun ye ex na! Gayik ɓëxarëk ɓëreɓën ɓën mondako banëɓi ŝëkwënd ɓëlaw̃ënel ɓënëgwëŝ ɓën!» ");
INSERT INTO bsc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ɓarikan ɓaxëtin mun pel wën ɓër ke sëfënd ɓën: ŋanindënëɓi ɓër xoỹër këŋun ɓën, dinindënëɓi enjekax ɓër ŝus këŋun ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Calenindënëɓi ɓër këŋun xarend ɓën, calenindënëɓi ɓër këŋun ŝirërand ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Angëmëne ala exi cën gër añam and liw̃, ɓexënëlo and ŝame aŋ. Angëmëne ala exi kan acuɗ anëngwën aŋ, teɓënëlo gë atëm ak. ");
INSERT INTO bsc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ar ki xarand yo, yëlëlo, do and ko w̃eɗ ala er xwën këƴ aŋ, këreƴ kana na. ");
INSERT INTO bsc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ang këŋun ỹandind enun dinënd ɓela ak, wën ɓëte dinindëɓi mondako fo. ");
INSERT INTO bsc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Angëmëne eŋun ɓalënd end ɓër këɓi ɓalënd endewën ɓën fo, enjekax end fe kënun wateli ɓela ɓën? Ax gi ex na nde ɓëw̃endëran ɓën dëŋ mondako wata këni? ");
INSERT INTO bsc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Angëmëne enëɓi dinënd enjekax ɓër këŋun rinënd enjekax ɓën fo, enjekax end fe wa kënun wateli ɓela ɓën? Ax gi ex na nde ɓëw̃endëran ɓën dëŋ mondako wata këni? ");
INSERT INTO bsc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Do angëmëne enëɓi ñomëxënd ɓër kën yëland aw̃aŝën kënun w̃aŝën ɓën fo, enjekax or fe kënun wateli ɓela ɓën? Ax gi ex na nde ɓëw̃endëran ɓën aỹomëxër këni ỹomëxërënd ɓën ɓëte do këni w̃aŝërënd ceƴ gë ceƴ? ");
INSERT INTO bsc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɓarikan ɓalindëleŋun end ɓërangoỹëra andewën eŋ, dinindënëɓi enjekax. Ñomëxindënëɓi ɓër an yëland na aw̃aŝën kënun w̃aŝën ɓën. Angëmëne mondako kën rind, ɓela ɓën ata këni nang mëne wën oɓaŝ or Kaxanu, hi kën, mëŋ ar hik ƴaŋ aŋ. Ɓon kë xëɓën amaŝën andewën aŋ, gayikako ata kën wëndër gë Ar-hik-ƴaŋ an. Mëŋ këɓi rinënd enjekax eŋ ɓela ɗek, ado eni gi ɓër ano cëkwa na, ado eni gi ɓëxeỹax. ");
INSERT INTO bsc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ang nënga ko Faba Kaxanu ak, giyin wën ɓëte mondako fo.» ");
INSERT INTO bsc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ax gi ex na mokiti ɓela ɓën këdi këŋun xiti Kaxanu wën ɓëte. Ax gi ex na monëp ɓela ɓën këdi këŋun nëp wën ɓëte. Teɓanindënëɓi eŋun teɓanaxën. ");
INSERT INTO bsc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yëlërayindënëɓi ɓela ɓën enun yëlëraxënënd wën ɓëte. Gër amote and kën ɓaxarand kënun ŝëlën: ɗëɓ, mocëŝi, do monexira. Gayikwa gë acariya and kënëɓi sëƴinënd ɓela aŋ fo këŋun w̃aŝën wën ɓëte.» ");
INSERT INTO bsc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ata Yesu fel këɓi ɓëte apënëtal aŋo: «Aŝiw̃ëk axor nde ko xor eŋo ɗas aŝiw̃ëk aŝandaw̃? Ax gi ex na nde ɓën tak kë lati polo në ambëxw? ");
INSERT INTO bsc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Asëfan an aŋo kucand na onangëran ol sëƴali arexëm an, ɓarikan ar faỹëk etëƴa an gwër fo hi këni gë asëƴali arexëm an. ");
INSERT INTO bsc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Inew̃a këƴ nëkonënd atëxësëx and lëŋa këŋo aɓinëx aŋ, do këƴ nemënd mëne wëj yer xëcar in lëŋa ki? ");
INSERT INTO bsc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mondake wa këƴ xorënd eƴo pel aɓinëx: “Ñëmël mi dëxëtën atëxësëx aŋ gër angës”, xarak wëj yer yëcar in lëŋa ki? Wëj aỹëŋënax ar kë laɓayand hi këƴ, dëxëtël wa pere yëcar ir lëŋa ki in eƴ wataxën aye atëxësëx and gër angës and aɓinëx aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Atëx anjekax ax gind na gë odëw̃ërëw̃en oñëŋënax. Do atëx añëŋënax ax gind na gë odëw̃ërëw̃en ojekax. ");
INSERT INTO bsc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Atëx and ex yo, gër odëw̃ërëw̃en odexëm kë hind monang. Ax gi ex na nde ondan oŋ ani kwëcand na në apeɓ? Ɓëte reseŋ in ani kwëcand na në atëx and gë odëmbën? ");
INSERT INTO bsc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ala ar ye këŋo onden an, emëkw edexëm el yek. Do ar ỹëŋën këŋo onden an, emëkw edexëm el ỹëŋënëk. Gër etëỹ ko nëcëtënd ala an er lëɓëk gër emëkw in.» ");
INSERT INTO bsc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Inew̃a këne w̃acëraxënënd “Axwën”, “Axwën”, xarak an dind na er këmun felënd in? ");
INSERT INTO bsc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ar kë ƴow yo exo ɓaxët eyeƴan edam do exo dind ang re këme ak, afel këmun fel gë ar wëndër këni an. ");
INSERT INTO bsc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Gë ar ɓaƴëk aciw̃ wëndër këni: ga nac ko pere gër aparëfac xali siw̃ëk, xwët ko oxaỹ orëɗa oŋ. Ata and ƴowëk tëɓ aŋ, oỹëm ol ƴowëk, men oŋ ŝëñëk aciw̃ aŋo, ɓari ax kor ex na ex ñam, gayik ŝenene ɓaƴ ko. ");
INSERT INTO bsc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ɓarikan ar kë ɓaxët yo eyeƴan edam do axo dind na ang re këme ak, er këni wëndër gë ala ar ɓaƴëk aciw̃ andexëm gër ebar nacërëxe pere gër ed ko xwët oxaỹ orëɗa fo. Ata and ƴowëk tëɓ aŋ, oỹëm ol ŝëñëk aciw̃ aŋo: ataŋ wëcëk do yëcarëk ɗek.» ");
INSERT INTO bsc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu ga h̃ata ko ɓend baɓi sëƴalirand ɓulunda ir baŋo ɓaxët ɓeŋ, w̃aỹi ko gër Kafarënawum. ");
INSERT INTO bsc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Emun end ocoroɗa ŝot baŋo na xaɗëp ir ŝëxwëra bax mbaŋ, exo koti fo ɓayi bax, xarak mëŋ momal baŋo ɓalënd endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Emun eŋo ga wël ko mëne Yesu h̃atëguk, law̃ën këɓi ɓëxarëk ɓër Ɓëŝëwif ɓën eno karaw exo ƴow eŋo pakën xaɗëp irexëm in. ");
INSERT INTO bsc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ɓëxarëk ɓër Ɓëŝëwif ɓën ga h̃at këni këno xarand Yesu mondako: «Ajo aỹap ỹapëk eƴo din er w̃ëka ko in! ");
INSERT INTO bsc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ar h̃anëk enëng endeɓi exo, mëŋ ɓaƴën këɓo aciw̃ acaleya aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ata Yesu sëfër këni kwël gë ɓën. Ɗam eni ŋat gër iciw̃, emun end ocoroɗa eŋ law̃ën këɓi oɗawo odexëm eno kaca Yesu do eno pel: «Axwën, ine ngwa këƴ ƴowaxënëgund gë andeƴ, axuri kë xuri ang këƴe fëɓ ak, ga lil lilëgu këƴ gër yangana iram ro. ");
INSERT INTO bsc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mëŋ ɓayik axe mëndan ex na me ƴeli gë andam gër ed hi këƴ. Ɓarikan, yeƴanël tuŋ emat ata ko fak ariyenin aram an! ");
INSERT INTO bsc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gayikwa wëno dëŋ aw̃a w̃a këme or gapak or ɓëlëngw ɓëram ol. Wëno ɓëte alëngw ar ocoroɗa hi këme do ɓën ari këni rind er këmëni felënd in. And këmo fel ŝoroɗa iɓat: “Ƴel!” ata exo ƴe, ɓëte and këmo w̃ac iŝëxe aŋ: “Ƴow!” Exo ƴow. And këmo fel ariyenin aram aŋ: “Dil ejo!” Exo di.» ");
INSERT INTO bsc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","And wël ko Yesu eyeƴan elo aŋ, nëngan këŋo end emun end ocoroɗa eŋ. Ga ŝena ko gand amëxwër, re ko: «Ga re këme gër wën Ɓëyisërayel elod amo wat ex na ar xwëta ke mondako!» ");
INSERT INTO bsc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ɓër law̃ënëgu baɓi emun end ocoroɗa ɓën ga ɓaka këni gër iciw̃, sëkëx këno ariyenin an ga fak ko ŝenene. ");
INSERT INTO bsc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ga xeyëk, Yesu ko ƴend në angol and bani w̃acënd Nayin. Sëfër këni gë ɓësëfan ɓërexëm ɓën, do gë amëxwër atëm. ");
INSERT INTO bsc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","And bani lil gër angol aŋ, fed këni gë enga end ɓela ga lëɓi këŋo aŝësëk ond gër eɗap oŋ. Aŝësëk ajo, itox imat ind asoxari aseɓëta seɓëta ebaxo. Ata ɓër lëg bax gër angol aŋo ɓën mbaŋ ỹëmb bani ga këno laŋëta. ");
INSERT INTO bsc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Axwën Yesu and wat këŋo asoxari ajo aŋ, xaỹënan këŋo xali. Ata re ko: «Cësinal!» ");
INSERT INTO bsc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","And sëka ko aŋ, lëk ko epël el, ata xwëŝa këni ɓëlëɓi ɓën. Aŋo re ko Yesu: «Ŝambenjar, ga re këme, kanil!» ");
INSERT INTO bsc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Xani ko kwengweremët aŝësëk an, do ko yeƴandërand. Yesu w̃aŝ këŋo nëm. ");
INSERT INTO bsc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ata ɓela ɓën ɗek lëk këɓi anjiỹ atëm. Ga këno ŝëkw Kaxanu këni rend: «Alaw̃ënel asëm ŝanayaxënëgu këɓo. Kaxanu nëngaw këɓo ɓiyi ɓulunda irexëm in.» ");
INSERT INTO bsc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ata wëlik endeƴ eŋo, gë angol gë angol, ɗek ebar ed Yude el xali yaɓët. ");
INSERT INTO bsc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ata Ŝaŋ Batis wël ko ɓeŋo ɗek ga sëfëtandëra këno ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","W̃ac këɓi ɓësëfan ɓëxi do law̃ën këɓi gër Axwën Yesu eno mëkaw: «Wëj nde ex afexën ar kë ƴowënd an? Angëmëne ax gi ex na wëj, mo cëni nde aŝëxen?» ");
INSERT INTO bsc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ga h̃at këni gër Yesu re këni: «Ŝaŋ Batis law̃ënëgu këɓo mi mëka ba wëj ex afexën ar kë ƴowënd an, do ang ax gi ex na wëj, mo cëni nde aŝëxen?» ");
INSERT INTO bsc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ata amëd aŋo dëŋ baxo rind Yesu ɓecarax ɓeŋo: afakën ɓëŝëxwëra do gë ɓëseỹik ɓëranjëm; anëcët ɓangoc ɓañëŋënax gër ɓela; aŝiw̃ët ɓëŝiw̃ëk ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu yaka këɓi: «Gërëgako ƴeyin eno tëfëtaxënëx Ŝaŋ Batis ɓeɓër wateli këne ɓën, do gë ɓend wëleli këne ɓeŋ. Pelëxëno mëne ɓëŝiw̃ëk ɓën në ewatëra exëni, ɓëseỹik ɓën në eƴexëra exëni, ɓër gë ameỹ ɓën në emën exëni, ɓapaxo ɓaŋ në ewëlëra exëni. Pelëxëno ɓëte mëne ɓëŝësëk ɓën në ekani exëni gër ecës do ɓëxaỹënaxik ɓën në nang exëni Atëfëtan aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Awa nëngandëraleŋo ar ɓayik aŋo ŋëpëgënand na endam an.» ");
INSERT INTO bsc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ga ɓaka këni ɓërolaw̃ën or Ŝaŋ Batis ɓën, Yesu ko yeƴanënd en Ŝaŋ Batis eŋ mondako: «Ine ƴe ban en nëkonëgu gër ladawe? Andës and kë lëfërërirand ekoc nde? ");
INSERT INTO bsc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Noỹo wa ƴe ban eno nëkonëgu? Ar ŝuɗarak mokëɓën gë ɓanjëm ɓanjekax nde? Ax gi ex na nde ɓër gë ɓanjëm ɓanjekax ɓën, ɓër ɓetak ɓën, gër eyang ed emun hi këni? ");
INSERT INTO bsc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Do noỹo wa ƴe ban eno nëkonëgu? Ax gi ex na nde alaw̃ënel ar Kaxanu? Eyo ar watëgu këno an, nëmëc alaw̃ënel ar Kaxanu exo. ");
INSERT INTO bsc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Endexëm eŋ ỹëgw këni gër akayëta and Kaxanu: “Nëkoɗ në eɗëngwalilemo arolaw̃ën an Exi ŋacan fëña in.” ");
INSERT INTO bsc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Ɗal in këmun felënd, ŝëf gër ɓër rëw̃ këneɓi mondëw̃ ɓësoxari, gaɓatak aŋo ñëmbëta ex na or gapak ol Ŝaŋ Batis. Ɓarikan ar xurik ex ɓa gër owun or Kaxanu an xuca këŋo.» ");
INSERT INTO bsc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ata gër ɓulunda ir ɓaxët baŋo, do gër ɓësëf ɓër ŝagale ŝanaya bax end ŝenene end Kaxanu eŋ, mëŋ bani ƴexënënd gër ed exo Ŝaŋ Batis eɓi ɓuyix. ");
INSERT INTO bsc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ɓarikan ofariseŋ ok do gë ɓësëƴali ɓër acariya and Moyis ɓën, ga bani h̃ëpënd eɓi ɓuyi Ŝaŋ, ƴepën këni mondako ang ỹandi baŋo Kaxanu eɓi pexën ak. ");
INSERT INTO bsc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Gë noỹo këmëni w̃atinali ɓela ɓër gë okey oko ɓën? Gë noỹo ngwa wëndër këni? ");
INSERT INTO bsc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gë oɓaŝ or ỹëpak në yangana fo wëndër këni. Ga ɓarërëgu këni, imëxwër imat kënëɓi rend imëxwër icandaw̃ iŋ: “Farixën këmun acëroti aŋ, an mane na! Ỹëw̃ën këmun ojëkan od oỹaw̃, an tes ex na.” ");
INSERT INTO bsc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ŝaŋ Batis ga ƴow ko, abaxo ƴamb na ecemar, abaxo ŝeɓ na ngoƴ, ɓarikan wën re këno: “Gë ɓëyël exo.” ");
INSERT INTO bsc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","And ƴow këme wëno Asëñiw̃ ar ala an, këme ƴambërand, këme ŝeɓërand. Ɓarikan këne rend: “Ala ajo ñambëran gë oŝeɓ fo xwënda ko, lawo ir ɓësëf ɓër ŝagale do gë ɓëw̃endëran hi ko.” ");
INSERT INTO bsc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ɓarikan gër ɓela ɓëjo kën nangaxën mëne er ỹandi këŋo Kaxanu in ŝenene ex gayik ɓën aw̃a w̃a këni endam eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseŋ ir bano w̃acënd Simoŋ in w̃ac baŋo Yesu exo ƴe eni ƴambëra gër ndeɓën. Ata Yesu h̃at ko, do ỹëpa këni gër eƴambëran. ");
INSERT INTO bsc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Asoxari aw̃endëran ebax na gër angol. Ga wël ko mëne Yesu ƴowëk na gër iciw̃ ind fariseŋ, w̃ëlanëgu këŋo angiri në ŝëlakuŋ ir ekaỹ ed alëbatër. ");
INSERT INTO bsc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ga ɓuka ko gand epoƴ ed Yesu, ler gër osapar, ko sesënd. Ongwën oŋ kë ŝarënd gër osapar or Yesu or baxo w̃egarand oŋ, do ko fëxwëcërand gë omban ondexëm oŋ. Axoŝ baxo xoŝënd ɓëte gë angiri in. ");
INSERT INTO bsc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ga wat ko eŋo, fariseŋ ir w̃ac baŋo Yesu in, ko yëlarand: «Kido ala ajo, alaw̃ënel ebaxo, anang nang doxo mëne asoxari ar këŋo lëkërand an aw̃endëran hi ko.» ");
INSERT INTO bsc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu re ko: «Simoŋ, ỹeỹ ỹandi ke na mi mëka.» Yaka ko: «Oko asëƴali, mëkale!» ");
INSERT INTO bsc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Re ko ɓëte Yesu: «Mondako ri bani ɓela ɓëxi ga ỹomëxa këni koɗi. Aỹanar an w̃eɗ ko ɓatama keme ɓand koɗi, axinëm an ɓatama ofëxw oco. ");
INSERT INTO bsc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ga sëkwan këni ɓën tak ɓëxi eni maŝ in, ar ỹomëx baɓi an seɓan këɓi. Awa gër ɓela ɓëxi ɓëjo, noỹo wa këŋo h̃an nëmëc ar ebax eno maŝ koɗi an?» ");
INSERT INTO bsc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yaka ko Simoŋ: «Yëla këme ar seɓan këŋo ɓatama keme an.» Re ko ɓëte Yesu: «Ata ŝenene xiti këƴ!» ");
INSERT INTO bsc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","And ŝena ko gand asoxari aŋ, re ko: «Simoŋ, wat këƴo nde asoxari ajo? Gë ongwën ondexëm oŋ neɓ ko osapar oram oŋ, do fëxwëc ko gë omban oŋ. Ɓari wëj aƴe yële na men me neɓara osapar oŋ and lilëgu këme ro gër iciw̃ indeƴ aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɓëte and h̃atëgu këme aŋ, aƴe kaca ex na eƴe mega. Ɓarikan asoxari ajo, elod ga lilëgu këme axo teɓ ex na emegara ed osapar oram el. ");
INSERT INTO bsc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ogu aƴ koŝ ex na gër gaf, ɓarikan mëŋ angiri xoŝ ke gër osapar oram. ");
INSERT INTO bsc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ga re këme ɓamena ɓandanjëm seɓan këmo mëŋ këŋo ɓalaxënënd mondako endam eŋ. Ɓarikan ar seɓan këmo ɓamena ɓapënëfëne an, tëkër fo këŋo ɓal endam eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu fel këŋo ɓëte asoxari an: «Anëka seɓan këmi ɓamena ɓandeƴ ɓaŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓër bani ƴambërand gë Yesu ɓën wël këni eyeƴan elo do këni yëlarand: «Noỹo ngwa hi ko ar kë seɓanënd ɓeñëŋënax ajo?» ");
INSERT INTO bsc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ɓarikan Yesu fel këŋo asoxari an: «Ga xwëta këƴe, fexaxën këƴ! Maỹil gë emëkw eƴemax!» ");
INSERT INTO bsc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ga xucak eŋo, Yesu ko sëfërand gë angol gë angol, hik atëm, hik atil ko femërand do ko reƴarand end Atëfëtan and owun or Kaxanu eŋ. Enga emat hi bani gë ɓësëfan epëxw gë ɓëxi ɓën, ");
INSERT INTO bsc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","gë ɓësoxari ɓër fakën baɓi ga nëcët këɓi ɓëyël ɓën do gë ocëxwëra ok. Asoxari aỹanar aŋ ebaxo: Mari ir bano w̃acënd ɓëte Madëlen ata gër ndexëm nëcët baɓi Yesu ɓëyël ɓëcongëɓëxi. ");
INSERT INTO bsc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Asoxari axinëm an bano w̃acënd Yowana, alindaw̃ ar Cusa, aw̃ëxëta ar koɗi ir Erod an. Asasën an, bano w̃acënd Sisan do gë ɓësoxari ɓëranjëm ɓër bax w̃ëlagund ɓacota ɓandeɓën eno dëcaraxënënd Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ata amëxwër atëm ɓarërëgu këni gër ed hi baxo Yesu, ga xaniraw këni gër ɓangol ɓandanjëm. Ata Yesu fel këɓi apënëtal aŋo: ");
INSERT INTO bsc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mondako ri baxo ar oneɗ ga nëca ko gër oŝënga. Ga ko fan eneɗa eŋ, mar lapak gër fëña, ɓela ɓën wëñëra këni, do oŝël or gër orën ol hël këni ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɓëte mar lapak gër ebar ed gë aparëfac. And lëgëk aŋ h̃aỹëk gayik obar ok ax ñëmb bana. ");
INSERT INTO bsc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɓëte mar lapak gër odëmbën. And lëgëk aŋ, odëmbën ok xëŝak tëc. ");
INSERT INTO bsc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɓëte mar lapak gër ebar ejekax. And lëgëk aŋ, rafëk do rëw̃ëk: anjëra amat keme.» Ga h̃ata ko Yesu apënëtal aŋo, re ko ɓëte: «Ax gi ex na nde ɗek fo wël kën, awa!» ");
INSERT INTO bsc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ata w̃ëka këno ɓësëfan ɓërexëm ɓën eɓi paỹën apënëtal aŋo. ");
INSERT INTO bsc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yaka këɓi: «Wën yël këŋun Kaxanu en nang ɓeconëŝon ɓend owun orexëm ɓeŋ. Ɓarikan ɓëŝëxe ɓën gë ɓapënëtal këni wëlënd do ado eni nëkonënd, ani watënd na, ado eni ɓaxëtënd aɓi pënind na gë tëkër ak. ");
INSERT INTO bsc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Awa ɓaxëtin er w̃acayak apënëtal aŋo in: eneɗa eŋ, eyeƴan ed Kaxanu el ex. ");
INSERT INTO bsc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fëña ir gër ed lapak eneɗa in ex ɓela ɓër kë wëlënd awël dëŋ eyeƴan ed Kaxanu el, ɓarikan ŝaɓucara in exo ƴow exo dëxët gër ow̃ëkw oreɓën ɗek er wël këni in këdi këni w̃a do eni pex. ");
INSERT INTO bsc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ebar ed gë aparëfac el ex ɓela ɓër sam eni wël eyeƴan ed Kaxanu el eni kwëtaya gë onënga fo. Ɓari ani gi ex na gë oɗëmbët, er këni w̃and amëd fo, do and kë h̃atëgu ocëmu aŋ ataŋ këɓi ŝenand eni teɓ wap. ");
INSERT INTO bsc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eneɗa end lapak ŝit gër odëmbën eŋ exëni ɓela ɓër kë wëlënd awël dëŋ eyeƴan ed Kaxanu ɓën, ɓarikan eni teɓ ocëmu ok, ocal od napul ok, do gë ɓenëngax ɓend gër aniyan ɓeŋ ex këŝa eyeƴan elo. Ata er wël këni in ex tëkwan enëngwët ed ola oreɓën el. ");
INSERT INTO bsc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eneɗa end lapak gër ebar ejekax eŋ exëni ɓela ɓër kë wëlënd eyeƴan ed Kaxanu, gë onden, do gë emëkw ejekax ɓën, eni kwëtaya aye do eni ɓalëkënali ŝenene, eni ɗëkaya xali eɓi nëngwëtën ola oreɓën ol. Do and kë h̃atëgu ocëmu aŋ, kemënali.» ");
INSERT INTO bsc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ala ax pëtënënd na lambo do exo ŋoɓ, ba exo ɗilali në angaw̃. Ɓarikan ƴaŋ gër akaw̃aya ko xaw̃ eɓi ŋoɓaxënënd ɓër kë lilënd ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mëŋ ex, er ŝonayak ax bo na, er ɓeŋ ax bo na; ɗek kë xerët angoɓen aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Awa wën titinayindën ang kën ɓaxëtënd ak, gayikwa Kaxanu ayël këŋo yël ar ŝotëk an, ɓari ar ax cot ex na an, axan këno xan er xaỹ këŋo in dëŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nëm gë ɓoɓinëm ɓor Yesu h̃atëgu këni gër ed hi baxo. Ɓari ani kor bana eno tëka në end amëxwër and xeta baŋo eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ata fel këno: «Nëkoɗëɓi fac norix gë ɓoɓinëx, aỹandi ỹandi këɓi ɗe en watër.» ");
INSERT INTO bsc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yaka ko Yesu: «Ɓër kë ɓaxëtënd eyeƴan ed Kaxanu do këni rind ang rek ak ɓën ex nëma iram do gë ɓëmaỹe ɓëndam ɓëŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Akey amat, Yesu gë ɓësëfan ɓërexëm ɓën fëra këni në ikuluŋ, ata re ko Yesu: «Kegëtane anjer aŋ!» Ata këni xegëtand. ");
INSERT INTO bsc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ga këni xas, Yesu këŋo raŝënd. H̃atëguk ekoc etëm do ikuluŋ iŋ kë rëmbayand xali ŝerëcerara këɓi ɓësëfan ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ata këno nëngëtënd Yesu: «Asëƴali, asëƴali, enemilene!» Ga nëngëta ko, Yesu xeỹënaxën ko ekoc el do gë men ond bax xanind ɓomeŋ ɓomeŋ oŋ, ata yeriri anjer aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ata w̃ëka këɓi ɓësëfan ɓën: «Ba wën xali gërëgako ane kwëta ex na nde?» Ɓën ga xap këɓi anjiỹ aŋ, këɓi ŝaranënd do këni w̃ëkarënd: «Noỹo ngwa hi ko ala ajo? Ado ekoc el dëŋ gë men oŋ ari kë rind er ko re in.» ");
INSERT INTO bsc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","And xegëta këni anjer aŋ, Yesu gë ɓësëfan ɓërexëm ɓën h̃at këni gër ebar ed Ɓëŝerasa, ed faɓër bax gë ed Galile el. ");
INSERT INTO bsc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","And baxo ŝëpëtand Yesu aŋ, asoŝan aɓat ko ƴowënd aped-fed ga xaniw ko gër angol. Ala ajo, ɓëyël ɓëranjëm lil baŋo, elod anëka fo hi baxo tëɓ gë eman eŋ, do gër ɓanapëra rëfa baxo, axo bo bana në iciw̃. ");
INSERT INTO bsc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","And sëkar këni gë Yesu aŋ, ala ajo h̃er ko, lapaya ko gër osapar do ko rend: «Inew̃a yir këɓo Yesu, wëj Asëñiw̃ ar Kaxanu an, mëŋ Ar-hik-ƴaŋ gër orën an? Axara xara këmi këreƴëɓo narën na!» ");
INSERT INTO bsc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu are baɓi rend ɓangoc ɓañëŋënax ɓaŋ eni can gër ala ajo ado ga xëda bano elod anëka fo. Laŋ mopokëra bano fokërand gë gweƴele-gweƴele gër otaxan do gër osapar. Ɓarikan dëng-dëng baxo xotërand do ɓëyël ɓën eno cëñëta gër apuỹ. ");
INSERT INTO bsc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ata Yesu w̃ëka këŋo: «Ake këni w̃acënd?» Yaka ko: «Ɓenga sir-sir këne w̃acënd.» Gayikwa, ɓëyël ɓëranjëm lil bax gër ala ajo mëŋ w̃acayaxën baxo mondako. ");
INSERT INTO bsc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ata ɓëyël ɓën këno xarand Yesu këreɓi cëñëta na gër ambëxw and siw̃ëk gë etël këm. ");
INSERT INTO bsc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ler gër ed ebani na, ɓambëxwëbëxw ɓandanjëm banëɓi xaɗacërand na kap gër etënd. Ata ɓëyël ɓën këno xarand Yesu: «Këla, cëñëtalëɓo mëni ɗil ɓambëxwëbëxw ɓaŋo!» Ata w̃a ko Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɓëyël ɓën ga ŝan këni na gër ala ajo, lil kënëɓi ɓambëxwëbëxw ɓaŋ. Ata ang hi bani gër ed kwëre kwëre ak, lapaya këni gër anjer do noỹeli këɓi ɗek kece in. ");
INSERT INTO bsc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ɓëxaɗac ɓën ga wat këni eŋo, ŝapërëra këni bër, do sëfëtërax këni endeƴ eŋo gër angol do gër ocënga. ");
INSERT INTO bsc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ata ɓela ɓën ŝandëra këni do ƴe këni gër onang, gër ed hi baxo Yesu. Ga h̃at këni, sëk këno asoŝan ar lil bano ɓëyël an moñëpa, ga ŝuɗara ko do ɓakar këŋo aye onden oŋ. Ata yëdara këni. ");
INSERT INTO bsc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓër wat bax endeƴ eŋo ɓën, fel kënëɓi mondake fak ko ar gë ɓëyël an. ");
INSERT INTO bsc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ata amëxwër and ɗek Ɓëŝerasa aŋ, w̃ëka këno Yesu exo can ebar edeɓën el, gayikwa ɗek ebani anjiỹ aŋ. Yesu fëra ko gër ikuluŋ do kwël këni w̃aỹind gë ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ata asoŝan ar lil bano ɓëyël an xemëna ko këŋo xarand Yesu exo ma exo gi ar enga endexëm. Ɓarikan Yesu h̃ëp ko do yaka këŋo: ");
INSERT INTO bsc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Maỹil gër ekun edeƴ eƴëɓi tëfëtandërax ɗek er rin ki Kaxanu in.» Ga w̃aỹi ko ala ajo, ko sëfëtëraxënd ɗek angol aŋ er rin këŋo Yesu in. ");
INSERT INTO bsc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","And ɓakaw ko Yesu ekeg elo aŋ, amëxwër atëm xaca këno gayikwa ɓën ɗek baŋo ŝënind. ");
INSERT INTO bsc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ata h̃atëgu ko asoŝan ar bano w̃acënd Yayëros. Mëŋ alëngw ar aciw̃ acaleya hi baxo. Ga lapaya ko gër osapar or Yesu, këŋo xarand exo ma eni tëfër gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Endënaw̃ emat end ŝot baŋo eŋ ŝëxwëra bax mbaŋ xarak eceɗe baŋo sëkënd ɓëniy epëxw gë ɓëki. And bani ƴend aŋ, amëxwër aŋ këno fimelirand Yesu xali ŝëndën këno. ");
INSERT INTO bsc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Do asoxari ebaxëna ŝit gër amëxwër, ar baŋo ƴexayaxënënd oŝat elod ɓëniy epëxw gë ɓëki. Napul irexëm in faỹ baxo ɗek gër ɓëxora, ɓari gaɓatak aŋo pakën bana. ");
INSERT INTO bsc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na nëfënëfa ko xali gër epoƴ ed Yesu, do xwixwëta ko ambana and acuɗ andexëm aŋ. Ata xëɗo këŋo oŝat oŋ kwël na fo. ");
INSERT INTO bsc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aŋo re ko Yesu: «Noỹo wa xwixwëta ke?» Ga këni ƴax ɗek ɓela ɓën, Piyer re ko: «Oko Asëƴali, amëxwër aŋ ga xeta këni do këni fimelirand!» ");
INSERT INTO bsc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ɓarikan Yesu yaka ko: «Ala xwixwëta ke na mëŋ nangaxën këme mëne panga indam ŝanëk na.» ");
INSERT INTO bsc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asoxari an wata ko mëne anëka dëŋ fëlët këŋo Yesu, sëka këŋo gë anjiỹ fo. Lapaya ko gër osapar orexëm, reƴa ko xali këno wëlënd ɗek ɓulunda in në end ine xwixwëtaxën baŋo Yesu do ang fak ko ataŋ ataŋ ak. ");
INSERT INTO bsc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ɓarikan Yesu fel këŋo: «Aɓiw̃ën, ga xwëta këƴe fakaxën këƴ! Maỹil gë emëkw eƴemax!» ");
INSERT INTO bsc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ga ko yeƴan mondako Yesu, h̃atëgu ko ala ga hiw ko gër iciw̃ ind alëngw ar aciw̃ acaleya, ata re ko: «Awa anëka xor këŋo endënaw̃ endeƴ eŋ, ine këƴo soroli mama Asëƴali an.» ");
INSERT INTO bsc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ɓarikan Yesu ga wël ko eŋo, fel këŋo alëngw ar aciw̃ acaleya an: «Kwëtale afak ko fak, këreƴ yëdara na.» ");
INSERT INTO bsc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","And h̃at këni gër iciw̃ aŋ, Yesu, gaɓatak axo ma bana eni ɗil gë mëŋ lëf gër ed ebaxo endënaw̃ ang ax gi ex na Piyer, gë Ŝaŋ, gë Ŝak, gë sëm do gë nëm ir endënaw̃. ");
INSERT INTO bsc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓela ɓër ƴow bax na ɓën ɗek bax sesërand do bano ỹaw̃ërand endënaw̃ eŋ. Ata re ko Yesu: «Këren tes na, axo cës ex na, araŝ fo raŝ këŋo.» ");
INSERT INTO bsc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ata ɓër wël bax ɓën këno ƴepënënd ga nang këni mëne endënaw̃ eŋ aŝës dëŋ ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu lëk këŋo gër ataxan do xeỹ ko: «Aɓiw̃ën, kanil!» ");
INSERT INTO bsc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ga ɓakar këŋo onjën oŋ, ataŋ xani ko kwengweremët. Yesu re ko eno yël eƴamb ƴamb. ");
INSERT INTO bsc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ɓëxarëk ɓër endënaw̃ ɓën ŝaran këɓi xali. Ɓarikan Yesu fel këɓi eni cësinali eŋo do ala këreno pel na. ");
INSERT INTO bsc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Akey amat, Yesu w̃ac këɓi ɓësëfan epëxw gë ɓëxi ɓën do yël këɓi panga iŋ do gë or gapak or enëɓi ŋw̃ayaxënënd ɗek ɓëyël ɓën do enëɓi pakënaxënënd ɓela ɓën oŝëxwëra or ex yo. ");
INSERT INTO bsc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Law̃ën këɓi eni pemërand end owun or Kaxanu eŋ do enëɓi pakënënd ɓëŝëxwëra ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ata re ko: «Gër ed kën ƴe yo, ỹoweỹ këren mëlalind na: ax gi ex na oŝët, ax gi ex na ambaɓ, ax gi ex na ŝëlafana, ax gi ex na koɗi. Ɓëte këren mëlalind na ala kala ɓacuɗ ɓaki. ");
INSERT INTO bsc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gër iciw̃ ind kën h̃at do enun kwëtaya yo, ɓayiyindën na xali yatir kën xuca. ");
INSERT INTO bsc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gër ed këni h̃ëp enun kwëtaya, pëxwëcayindën obar od lëka këŋun gër osapar ok en kucaxën, ata kë hi osede or këɓi ŝëndënëɗ ɓela ɓëjo.» ");
INSERT INTO bsc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ga ƴe këni ɓësëfan ɓën, këni femëraxënd Atëfëtan aŋ, gë angol gë angol, do kënëɓi fakënëxënd ɓëŝëxwëra ɓën gër ed këni ƴe yo. ");
INSERT INTO bsc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erod ir wun bax gër ebar ed Galile, awël baxo wëlënd ɗek ɓeɓër bani rind Yesu gë ɓësëfan ɓërexëm ɓën. Ata wëlandëra këŋo gayik ɓela ɓën are bani rend mëne Ŝaŋ Batis xaniwëk gër ecës, ");
INSERT INTO bsc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ɓëjo mëne alaw̃ën Eli ɓakawëk. Ɓëjo ɓëte mëne alaw̃ënel aɓat ang ebani akarëk ak, xaniwëk gër ecës. ");
INSERT INTO bsc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ɓarikan Erod re ko: «Wëno ga foɗëtën këŋo wa gaf in Ŝaŋ Batis. Do noỹo cëŋ ex ar kë rind ɓend këme wëlënd ɓeŋo an?» Ata ko ŝaland eŋo wat Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Oparëxanda od ƴe bax ok ga ɓakaraw këni gër Yesu, sëfëtandëra këno ɗek ɓeɓër riw bani ɓën. Ata w̃ëla këɓi në er këni hix ɓën fo, ler në ingol ind bani w̃acënd Betësayida. ");
INSERT INTO bsc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ɓarikan ɓela ɓën ga nangëra këni, sëf kënëɓi ɓamëxwër ɓamëxwër. Yesu ga xaca këɓi, këɓi felërand end owun or Kaxanu eŋ do këɓi fakënënd ɓër bax ŝaland eni pak ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Apenëka aŋ, ɓësëfan epëxw gë ɓëxi ɓën xeta këno Yesu do re këni: «Pelalëɓi tan ɓela ɓën eni capërëra gër ɓëngol do gër ocënga od ler ler ro eni calarax në er këni laki do er këni ƴamb gayik ro gër ed hi këne apuỹ ex.» ");
INSERT INTO bsc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu yaka këɓi: «Yëlinëɓi wën dëŋ er këni ƴamb in!» Re këni ɓëte: «Ɓiyi ɓamburu ɓanjo gë oxan oxi fo ŝot këmëni! Angëmëne cëŋ aƴe këne ƴeye ene yëcuye er këni ƴamb ɗek ɓulunda ijo in.» ");
INSERT INTO bsc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Xarak er hi bani ɓësoŝan ɓën fo në owëli oco. Ata Yesu fel ɓësëfan ɓërexëm ɓën: «Pelinëɓi eni ñëpara imëxwër kala ɓela ofëxw oco.» ");
INSERT INTO bsc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ga ri këni mondako ɓësëfan ɓën, ɓela ɓën ỹëpara këni ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu w̃eɗ ko ŋat ɓamburu ɓanjo ɓaŋ do gë oxan oxi ol, ga xeŋa ko orën ol, ŝëkwa këŋo Kaxanu end eƴamb ƴamb eŋ. Hëmbëndër ko ɓamburu ɓaŋ do yël këɓi ɓësëfan ɓën enëɓi cetëra amëxwër aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na ƴambëra këni xali w̃ed këni ɓën ɗek. Ɓësëfan ɓën w̃eɗara këni ɓacaxaken ɓand ɓayitara baɓi ɓaŋ, ɓakange epëxw gë ɓaki. ");
INSERT INTO bsc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Akey amat, Yesu ga ko ŝalera nacët ako, ɓësëfan ɓërexëm sëf këno. And h̃ata ko cale aŋ, w̃ëka këɓi: «Noỹo hi këme wëno? Ine wëleli kënëɓi ɓela ɓën?» ");
INSERT INTO bsc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yaka këno: «Ɓërëmar are këni rend mëne wëj ex Ŝaŋ Batis! Ɓëjo, wëj ex Eli, ɓëjo ɓëte alaw̃ënel ar Kaxanu ar ƴow bax akarëk aŋ do xaniw ko gër ecës hi këƴ.» ");
INSERT INTO bsc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","W̃ëka këɓi ɓëte: «Do wën cëŋ, noỹo kën rend hi këme?» Yaka ko Piyer: «Wëj ex Afexën ar law̃ëneliw këɓo Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ata Yesu ga xëŋa këɓi, re ko mëne ala këreno pel na eŋo. ");
INSERT INTO bsc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ɓaŝ ko mëne mëŋ Asëñiw̃ ar ala an, asoro ko soro mbaŋ, eno cus ɓëxarëk ɓër Ɓëŝëwif ɓën, gë ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën xali eno ɗaw̃. Ɓarikan exo kani gër ecës yatir akey atasën. ");
INSERT INTO bsc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Fel këɓi ɓëte ɓën ɗek: «Angëmëne ala eŋo ỹandi exe tëf, teɓëlexo eɓal ed gaf irexëm fo el. Gilexo key yo key aw̃elëk ar exo toro në end ow̃ac oram do exe tëf. ");
INSERT INTO bsc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ar këŋo ɓal yo end enjëw̃ endexëm fo, anemin ko nemin. Ɓarikan, ar kë nemin enjëw̃ endexëm në end ow̃ac oram an, afexën ko fexën. ");
INSERT INTO bsc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Do inew̃a këŋo feca ar kë ŝotëra ɗek ɓeɓër gër ngwën ro an, xarak anambëra nambëra ko, do enjëw̃ endexëm eŋ ex nemi? ");
INSERT INTO bsc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Enimin, ar këŋo ŝëfënan yo endam, do exo ŋëp er re këme in, wëno Asëñiw̃ ar ala an mondako fo ke ŝëfënanëɗ endexëm eŋ yatir këme ɓakaw gë enjaran endam eŋ, gë end Faba Kaxanu eŋ, do gë end omeleka omënëk eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ɗal in këmun felënd, wën ɓër hik ro ɓëjo, ɓërëmar ani cësëra na watërëxe owun or Kaxanu ol.» ");
INSERT INTO bsc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ata xucak ɓakey ɓanjongëɓatas ga felëra këɓi ɓeŋo, Yesu w̃ac këɓi Piyer, gë Ŝak, do gë Ŝaŋ eno ɗaŋëta ƴaŋ gër etënd exo calex. ");
INSERT INTO bsc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","And baxo ŝalend aŋ, dëxas irexëm in nëngwëtak. Ɓanjëm ɓandexëm ɓaŋ feŝëk xali kë ỹegënd jing-jing. ");
INSERT INTO bsc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ata ŝanayaw këni ɓela ɓëxi, do këni yeƴandërand gë Yesu: Moyis do gë Eli ebax ");
INSERT INTO bsc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","gër enjaran do këni xanarënd gë Yesu end ecës ed baŋo h̃atënëgund gër Yerusalem eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Amëd aŋo Piyer gë ɓoŝandaw̃ ɗek ebani akwëɗ aŋ. Ɓari aɓi daŝ bana ga ŝanayawëk enjaran end Yesu eŋ xali wat kënëɓi ɓela ɓëxi ɓër ɓërëxandi baŋo ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ga këni felar Yesu gë ɓela ɓëxi ɓëjo, Piyer re ko: «Asëƴali, ɓon yek ene ɓayiye ro! Dine ɓaner ɓatas, amat andeƴ, aŋo and Moyis do aŋo and Eli.» Piyer axo nang bana er baxo rend in. ");
INSERT INTO bsc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ga ko yeƴan mondako, fedawëk aŋar do laɓ këɓi kwëc. Ata ɓësëfan ɓësas ɓën ɗek ebani anjiỹ aŋ ga laɓeli këɓi aŋar aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gër aŋar aŋo wëlik oniw̃: «Ajo ex Asëñiw̃ën ar yata këmo an, ɓaxëtindëno!» ");
INSERT INTO bsc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","And ŝësinak oniw̃ aŋ, Yesu ɓayi ko gaɓat. Ata ɓësëfan ɓën ŝësinali këni endeƴ eŋo do gaɓatak ano pel bana ɓakey ɓand ɓëtëraw bax ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ga xeyëk, Yesu gë Piyer, gë Ŝak, do gë Ŝaŋ këni ŝëland etënd el, ata amëxwër atëm and ɓela xaca kënëɓi. ");
INSERT INTO bsc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Gër amëxwër aŋo, xeỹëgu ko ala: «E, Asëƴali, kaỹënanëlexi lëmëta iram in, mëŋ fo ŝot këmo. ");
INSERT INTO bsc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Angoc añëŋënax lil këŋo. And ko ŝangëna aŋ, lëmëta in exo ŋer xali, exo wëc, exo ŋatëndërënd oỹënga oŋ gë ocupërëŝup ok gër etëỹ. And këŋo narëndëra mondako aŋ, mbaŋ kë nëkand eŋo kocaxën. ");
INSERT INTO bsc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Axara xara këmëni ɓësëfan ɓëreƴ ɓën eno ŋw̃ay angoc añëŋënax aŋo, ɓari ano kor ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ata re ko Yesu: «Ata wën anjex and ɓela ɓër gë oŋëpëgënan hi kën ɗe. Xali niỹe fa këme ɓayi gë wën? Xali niỹe fa këmun ɓuŋan? Mëlawëyo ro asëñix!» ");
INSERT INTO bsc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lëmëta in ga këŋo sëka Yesu, ayël an ŝangën këŋo. Reɓa këŋo ŝet, do ko xënëcëtarand gër ebar. Ɓarikan Yesu xeỹënaxën këŋo angoc añëŋënax aŋ, fakën këŋo lëmëta in, do w̃aŝ këŋo sëm. ");
INSERT INTO bsc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɗek ɓër hi bax na ɓën ŝaran këɓi ga wat këni mëne panga ind Kaxanu iŋ itëm ex. Nand baɓi ŝarandëra end ri baxo Yesu mondako na, mëŋ fel këɓi ɓësëfan ɓërexëm ɓën: ");
INSERT INTO bsc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Wën cëŋ ɓaxëtin aye er këmun felënd gërëgako in: Wëno Asëñiw̃ ar ala an, alëxw këne lëxw gër otaxan od ɓela.» ");
INSERT INTO bsc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ɓari ɓësëfan ɓën aɓi pëni bana eyeƴan elo; end ŝonayak ebax gër orenik oreɓën mëŋ sëkwanaxën bani eɓi pëni, do bani yëdand eno mëka eɓi paỹën. ");
INSERT INTO bsc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ata ɓësëfan ɓën këni ŝampërend end ba noỹo ỹap këŋo exo gi alëngw gër enga endeɓën eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ga nang ko Yesu ang bani yëland gër ow̃ëkw oreɓën ak, felaw këŋo itox do xwët këŋo ler gër ndexëm. ");
INSERT INTO bsc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ata re ko: «Ar këŋo xwëtaya yo itox ang iŋo ro ak, në end ow̃ac oram, wëno dëŋ xwëtaya ke. Do ar ke xwëtaya yo, anëka xwëtaya këŋo ar law̃ënëgu ke an. Enimin, ar w̃ak exo ɓana gër enga endewën an, ex alëngw an.» ");
INSERT INTO bsc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ata re ko Ŝaŋ: «Asëƴali, ga watëgu këmo ɓiyi ala ar këɓi w̃ayënd ɓëyël gër ɓela gë ow̃ac oreƴ ol. Afel fel këmo exo teɓ gayik axi tëfënd na ang ɓiyi ak.» ");
INSERT INTO bsc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yaka ko Yesu: «Këreno pel na exo teɓ gayik ar ɓayik aŋun merelind na an, arewën hi ko.» ");
INSERT INTO bsc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ga kë saxëgu ɓakey ɓand ebax exo dëxëta gër ngwën ro ɓaŋ, Yesu faỹ ko gër emëkw exo ƴe ƴaŋ gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ata lëngwali këɓi ɓërolaw̃ën. Ga ƴe këni, h̃at këni në ingol ind gër ebar ed Samari eno këñënaranëx. ");
INSERT INTO bsc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɓari ɓër gër ingol ɓën h̃ëp këni eno kaca Yesu gayik gër Yerusalem baxo ƴend. ");
INSERT INTO bsc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ga wat këni eŋo, ɓësëfan Ŝak do gë Ŝaŋ re këni: «Axwën, ỹandi ki nde mi mac xoɗux or gër orën ol eɓi cor ɓela ɓëjo?» ");
INSERT INTO bsc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu, ga faɓ këɓi, këɓi rexërand. ");
INSERT INTO bsc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ata Yesu gë ɓësëfan ɓën xuca këni në ingol icëxe. ");
INSERT INTO bsc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","And hi bani gër fëña aŋ, aɓat re ko: «Yesu, wëno gër ed këƴ ƴe yo asëf këmi sëf.» ");
INSERT INTO bsc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ata Yesu yaka këŋo: «Ojakëra ok gë ow̃aỹi exëni ɓëte oŝël or gër orën ol gë oyël exëni, ɓari wëno Asëñiw̃ ar ala an, ado gë añombe ak axe gi ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Fel këŋo ɓëte ala aŝëxe: «Wëj tëfëguye wëno.» Yaka ko: «Axwën teɓanële me ƴe pere mo mëxwëtaw faba iram.» ");
INSERT INTO bsc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Re ko Yesu: «Teɓëlëɓi ɓëŝësëk ɓën eni mëxwëtar. Ɓarikan wëj ƴel eƴ tëfëtërax end owun or Kaxanu eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Re ko ala aŝëxe: «Axwën, gër ed këƴ ƴe yo wëno asëf këmi sëf, ɓarikan teɓële mëni pelaw pere gër ndeɓi.» ");
INSERT INTO bsc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yaka ko Yesu: «Ar kë ỹanënd gë ŝariŋ yo do, exo nëkonand gand epoƴ, axo gi ex na ar ŝenene gër owun or Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ga xucak eŋo, Axwën an sana këɓi ɓëte ɓela ofëxw ocongoxi gë ɓëxi ɓëŝëxe do law̃ën këɓi eni ƴe ɓëxi ɓëxi ɗek ɓangol ɓaŋ do ɗek ed ebax exo ƴe mëŋ el. ");
INSERT INTO bsc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Eni ƴexën fel këɓi: «Ekana ed ɓeneɗa el anëka h̃atëk mbaŋ ex andiyen aŋ, ɓari ani ñëmb ex na ɓërandiyen ɓën. Awa karayino Axwën oŝënga an eɓi panaw ɓëte ɓërandiyen ɓëŝëxe. ");
INSERT INTO bsc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ƴeyin, në eɗaw̃ën emun ang opeỹ od ŝit gër ojëlemu fo. ");
INSERT INTO bsc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ỹoweỹ këren mëlalind na: ax gi ex na koɗi gër ɓëmboto, ax gi ex na ambaɓ, ax gi ex na ɓapeɗ. Ɓëte kërenëɓi cëmand na ɓër kën fedënd gër fëña ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gër iciw̃ ind kën h̃at yo deyindën pere: “Cotin oɓetak or w̃ëlanëgu këmun ol!” ");
INSERT INTO bsc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Angëmëne ala exëna ar gë oɓetak, mëŋ kë ŝot oɓetak olo! Angëmëne ala ax gi ex na, eŋun ɓayi. ");
INSERT INTO bsc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɓayiyindën gër iciw̃ iŋo na; ƴambindën do ceɓindën er kënun yël in. Arandiyen an alëɓa këno lëɓand. Këren dëfarand na ɗe gë iciw̃ gë iciw̃. ");
INSERT INTO bsc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gër angol and kën h̃at yo do ɓela ɓën enun kwëtaya, ƴambindën er kënun yël in. ");
INSERT INTO bsc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pakënindënëɓi ɓëŝëxwëra ɓën do pelindënëɓi ɓela ɓën mëne owun or Kaxanu ol h̃atënëgu këɓi. ");
INSERT INTO bsc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ɓarikan gër angol and kën h̃at do ɓela ɓën eni ŋëp enun kwëtaya, ƴeyin gër ɓakwëndaya ɓandeɓën, en de: ");
INSERT INTO bsc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Obar od angol andewën od lëkak gër osapar oreɓi oŋ këmi fëxwëcand. Nangin mëne owun or Kaxanu ol w̃ëlaw bami ŋëŝ gër ndewën ro.” ");
INSERT INTO bsc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ga re këme yatir kiti, ɓër lëg bax gër Sodom ɓën këɓi sax gë ɓela ɓër angol aŋo ɓën». ");
INSERT INTO bsc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Eñëŋënax etëm këŋun wëcan wën ɓela ɓër lëgëk gër ɓëngol ɓënd Koraseŋ do gë Betësayida ɓën! Kido ɓecarax ɓend ri këme gër ndewën ɓeŋ wat bani ɓela ɓër gër owar or Tir do gë Sidoŋ ɓën, anëka fo nëngwët doni ola oreɓën ol do eni denitara në end ɓeñëŋënax ɓendeɓën mocuɗa ojaɓote do moñëpa gër eƴëwën. ");
INSERT INTO bsc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mëŋ ex yatir kiti, ɓela ɓër lëg bax gër owar or Tir do gë Sidoŋ ɓën aɓi copa na ang këŋun ŝopa wën ak. ");
INSERT INTO bsc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Do wën ɓela ɓër gër angol and Kafarënawum ɓën, ako nde yëla kën ƴaŋ gër orën këŋun fela Kaxanu? Ɓëtëdëŋ, gëɗ gër wur ir ɓëŝësëk këŋun lat. ");
INSERT INTO bsc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ar këŋun ɓaxët an wëno ɓaxët ke do ar këŋun ɓeŝ an wëno ɓeŝ ke. Ar ke ɓeŝ an, në eɓeŝ eŋo ar law̃ënëgu ke an.» ");
INSERT INTO bsc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɓësëfan ofëxw ocongoxi gë ɓëxi ɓër law̃ën baɓi Yesu ɓën ɓakaraw këni gë onënga fo do këni rend: «Axwën, ado ɓëyël ɓën dëŋ ari bani rind er këmëni fel gër ow̃ac oreƴ in.» ");
INSERT INTO bsc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu yaka këɓi: «Awat bamo watënd Sindan ga ko latiw elod gër orën ang ebingara fo. ");
INSERT INTO bsc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ayël yël këmun panga iŋ enëɓi bëñaxënënd ɓandën ɓaŋ, oxwël ol, do gë ɗek panga ind arangoỹëra iŋ, do eñëŋënax aŋun gi na. ");
INSERT INTO bsc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɓarikan nëngandëraleŋun end ga ỹëgw ko Kaxanu omac odewën ok ƴaŋ gër orën eŋ, ɓari kërex gi na gayik ɓëyël kë rind er kën re in.» ");
INSERT INTO bsc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Amëd aŋo, Yesu ỹëm ko gë onënga or yël baŋo Angoc Amënëk ol, ata ko rend: «Aŝëkwa këmi ŝëkwand Faba, wëj Axwën ar orën gë ebar an gayik aŝon ŝon këƴëɓi ɓeŋo ɓërenik ɓën, ɓër gë onden ɓën, do nangën këƴëɓi ɓërëtoc ɓën. Eyo, Faba mondako ebax anjëlan andeƴ aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Faba seɓën ke ɗek ɓeỹ ɓën, do ang nang ke wëno Asëñiw̃ ak, ala axe nang ex na mondako. Ɓëte ang nang këmo wëno Asëñiw̃ ak, ala aŋo nang ex na mondako. Wëno do gë ar ỹandi ke mo nangën an fo, nang këmo.» ");
INSERT INTO bsc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ga ŝena ko gand ɓësëfan, fel këɓi: «Nëngandëraleŋun wën ɓër kë watënd er kën watënd in! ");
INSERT INTO bsc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ga re këme, ɓëlaw̃ënel ɓëranjëm do gë ɓemun ɓendanjëm ỹandi baɓi eni wat er kën watënd in, ɓari ani wat ex na. Aỹandi ỹandi baɓi eni wël er kën wëlënd in, ɓari ani wël ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ata ƴow ko na aŝalen eŋo di atëƴ. W̃ëka këŋo: «Asëƴali, inew̃a këme ri me cotaxën aniyan and din aŋ?» ");
INSERT INTO bsc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu yaka këŋo: «Ine ỹëgw këni gër acariya? Wëj ine fën këƴ?» ");
INSERT INTO bsc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yaka ko aŝalen an: «Ŋanëlo Kaxanu, Axwën areƴ an, gë yomb ireƴ ak ɗek, gë anjëlan andeƴ ak ɗek, gë panga indeƴ ak ɗek, gë aniyan andeƴ ak ɗek. Do ɓëte ɓalindëlexi end aŝandax eŋ, ang ki ɓalënd end gaf ireƴ ak.» ");
INSERT INTO bsc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Re ko Yesu: «Ata ŝenene yaka këƴ! Diyind mondako ata këƴ ŝot aniyan and din aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɓarikan aŝalen an ga ỹandi këŋo exo masinaya mëne ar ŝenene hi ko, w̃ëka këŋo Yesu: «Do noỹo wa ex aŝandaw̃ën an?» ");
INSERT INTO bsc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ata Yesu yaka këŋo: «Mondako bax end asoŝan ar xani bax gër Yerusalem do ko ƴend gër Yeriko. H̃at ko në er xaŝ bani ɓërek ɓëxeỹax gër fëña. Ga raɗën këno, sëra këno, xandëra këno ɗek oỹënga oŋ. And xëm këno xali ɓel ko aŋ, seɓ këno ɓëɗëcët gër ebar, në emëkw na fo do kwël ƴe këni. ");
INSERT INTO bsc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nangërëxe eŋo, aŝaɗaxan aɓat ko ƴend ɓëte fëña ir ond gër Yeriko in. Ga ŝanan këŋo ala ajo, ɓeŝ këŋo kwël gë enëkona këm. ");
INSERT INTO bsc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","H̃atëgu ko ɓëte na arandëw̃ëra and Lewi. Ga wat këŋo ala ajo, mëŋ ɓëte ɓeŝ këŋo gë enëkona këm. ");
INSERT INTO bsc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɓarikan and h̃atëgu ko Asamari na gër ed hi baxo ala ajo aŋ, wat këŋo ɓëɗëcët gër ebar. Ata xaỹënan këŋo. ");
INSERT INTO bsc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ga sëka këŋo, fëxwëcëra këŋo gë ngoƴ ed sembaỹëra ko el. Ɓëte nëmëra këŋo gë ogu, fëlëndëran këŋo. Fela këŋo, xwët këŋo ƴaŋ gër fali irexëm, do kwël w̃ëla këŋo gër iciw̃ ind ɓëliyer eŋo korax. ");
INSERT INTO bsc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ga xeyëk, Asamari an yëpët ko ɓatama ɓaki ɓand koɗi yël këŋo axwën iciw̃ ind ɓëliyer an do re ko: “Koranële ala ajo. Angëmëne koɗi ir yël këmi in ax gi ex na gwac, gwëre mi ŋatati yatir këme ɓakaw.”» ");
INSERT INTO bsc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu ga h̃ata ko apënëtal aŋo, w̃ëka këŋo aŝalen an: «Gër ɓela ɓësas ɓër sëk baŋo ala ajo, ar fe wa hik aŝandaw̃ arexëm an?» ");
INSERT INTO bsc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yaka ko aŝalen an: «Ar xaỹënan baŋo an.» Ata re ko Yesu: «Awa wëj ɓëte ƴel eƴ dixënd mondako.» ");
INSERT INTO bsc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ga këni ƴe Yesu gë ɓësëfan ɓërexëm ɓën, h̃at këni në ingol. Ga xaca këɓi asoxari ar bano w̃acënd Marët, w̃ëla këɓi gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marët gë iminëm itoxari ebaxo do bano w̃acënd Mari. Mari ỹëpa ko gër osapar or Axwën do këŋo ɓaxëtënd. ");
INSERT INTO bsc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ata Marët mëŋ ko xëlënd gaɓat gër atoxari. And sëka ko gër Yesu aŋ, re ko: «Axwën, aỹapan nde ỹapan ki ga seɓ ke Mari gaɓat gër atoxari? Pelëlo wa exe dëca.» ");
INSERT INTO bsc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yaka këŋo Axwën an: «Marët, Marët, wëj er këƴ rendërand do këƴ xëlënd gër edi ed ɓeɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xarak emat ỹapëk exi ɓalënd gër aniyan. Eŋo sana ko Mari do ala ax gi ex na ar këŋo xan.» ");
INSERT INTO bsc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Akey amat, Yesu bax ŝalerand gër ed ebani gë ɓësëfan ɓërexëm ɓën. And h̃ata ko aŋ, asëfan aɓat w̃ëka këŋo: «Axwën, tëƴalilëɓo wa cale iŋ ang sëƴali këɓi Ŝaŋ Batis ɓësëfan ɓërexëm ak.» ");
INSERT INTO bsc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ata re ko Yesu: «And kën ŝalend aŋ, deyindën: “Faba, nangëralexëni ɗek mëne ow̃ac oreƴ ol ow̃ënëk ex ƴowëlex owun oreƴ ol! ");
INSERT INTO bsc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yëlindëɓo key yo key er këmi ƴamb in! ");
INSERT INTO bsc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Teɓanindëɓo ɓamena ɓandeɓi ɓaŋ, Ang këmëni seɓanënd ak ɓiyi ɓëte ɓela ɓër këɓo w̃enanënd ɓën. Këreƴëɓo teɓeli na eñëŋënax eŋ”.» ");
INSERT INTO bsc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ɓaŝ ko ɓëte: «Cale iŋ er wëndërëk gë endeƴ end ala ar ƴek gëmëɗ gër lawo irexëm eŋo kara: “Lawo, yëluye wa ɓamburu ɓatas. ");
INSERT INTO bsc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Lawo iram h̃atëguk gër ndeɓi, do amo cotën ex na er ko ƴamb in.” ");
INSERT INTO bsc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Angëmëne lëf gër ed laki ko yakaw ko lawo irexëm mondako: “Wëj, këreƴëɓo nëngëtëra na ɗe, ebët el anëka fëra këmi, wëno gë oɓaŝ oram ol anëka lakira këmi, ame kor na me kani mi yël ɓamburu.” ");
INSERT INTO bsc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ga re këme, ala ajo axani ko xani eŋo yël er këŋo xarand lawo irexëm in. Ga këŋo lëɓëlëɓa ko xanixën eŋo yël ɗek ɓeɓër këŋo xarand ɓën, ɓari ax gi ex na ɗe gayik lawo irexëm exo. ");
INSERT INTO bsc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Do wëno mëŋ këme rexënënd: “Karayindëno Kaxanu eŋun yëlëraxën, calayindën en cotaxën, tëmbindën enun përëtënaxën ebët el.” ");
INSERT INTO bsc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gayikwa ar kë xarand an, ayël këno yëlënd; ar kë ŝaland an, aŝot ko ŝotënd, do ar kë sëmbënd an, afërëtën këno fërëtënënd ebët el. ");
INSERT INTO bsc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ang hi kën ro ako, sëm ir itox nde exëna ir këŋo yël andën asëñiw̃, xarak ekan xara këŋo? ");
INSERT INTO bsc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ba eŋo yël ekwël, xarak eñeŋen xara këŋo? ");
INSERT INTO bsc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Angëmëne ang xwëj kën yo, anang nang kën eyël ed er yek oɓaŝ orewën el, kaŝ ex ngwa Kaxanu, mëŋ ar hik ƴaŋ gër orën an, ayël këɓi yël Angoc Amënëk aŋ ɓër këŋo xarand ɓën.» ");
INSERT INTO bsc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ata Yesu këŋo nëcëtënd angoc añëŋënax në amuma. And ŝan ko angoc añëŋënax aŋ, ala an ỹana ko ko yeƴandërand ŝenene. Ata ɓela ɓën ang ebani amëxwër ak ŝarandëra këɓi. ");
INSERT INTO bsc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ɓarikan ɓërëmar këni rend: «Wëni ba ax gi ex na nde gë panga ind Ỹëngëtir iŋ, emun end ɓëyël eŋ këɓi nëcëtënd ɓëyël ɓën!» ");
INSERT INTO bsc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɓëte ɓëŝëxen këni ŝaland eno di atëƴ. W̃ëka këno eɓi din ecarax eni nanganaxën mëne gër orën xaniw ko. ");
INSERT INTO bsc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ga nang ko Yesu ang bani yëland ak, re ko: «Angëmëne ɓela ɓër owun oɓat eɓi kucarënd, owun olo alati kë lati, do ɓëciw̃ ɓëŋ ex yëcar imat imat. ");
INSERT INTO bsc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Angëmëne Sindan eɓi merelind ɓër ex gër owun orexëm ɓën, mondake ke ɓayi owun orexëm ol gayikako kën rend mëne gë panga ind Ỹëngëtir iŋ këmëni nëcëtënd ɓëyël ɓën? ");
INSERT INTO bsc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Angëmëne wëno gë panga ind Ỹëngëtir iŋ këmëni nëcëtënd ɓëyël ɓën do oɓaŝ orewën ol cëŋ, gë panga ind noỹo kënëɓi nëcëtënd? Mëŋ rexën këme oɓaŝ orewën ol fo këŋun xiti! ");
INSERT INTO bsc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ɓarikan angëmëne gë panga ind Kaxanu iŋ këmëni nëcëtënd ɓëyël ɓën, awa wën anëka h̃atënëgu këŋun owun or Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","And ko nëkonand ala ar gë ojaw̃ aŋ yangana irexëm gë oỹënga or emer aŋ, ɓeɓër ŝotëra ko ɓën aɓayi këŋo ɓayi. ");
INSERT INTO bsc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ɓarikan, angëmëne ala ar xuca këŋo ojaw̃ exo ƴow do eŋo kor, ata këŋo xwëca ɗek oỹënga or emer or xwëta ko eŋ, do eɓi yëlëra ɓela ɓën ɓeɓër xan këŋo ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ar ami ɓar ex na an, ar angoỹëra andam ex. Do ar ɓayik axe dëcand na eɓar an, në eyëc exo.» ");
INSERT INTO bsc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«And ko ŝan angoc añëŋënax në ala aŋ, gër ed timëriŋ ko ƴend exo calarax ateyëtaya. Angëmëne axo cot ex na, ata exo yëlara: “Ɓakaleme tan gër iciw̃ indam, gër ed ŝanëgu këme!” ");
INSERT INTO bsc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","And ko h̃at aŋ exo tëk wacaca, ga fat këni do ỹaŋën këni. ");
INSERT INTO bsc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ata eɓi ƴen ɓangoc ɓanjongëɓaki ɓacëxe ɓand xuca këŋo oxeỹ, eni ɗil, do eni ɗëg lëf gër ala ajo. Awa ala ajo exo torond nëmëc ang baxo sorond añanar ak.» ");
INSERT INTO bsc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ga ko yeƴan mondako Yesu, asoxari aɓat gër amëxwër, ɓacan këŋo: «Nëngandëraleŋo asoxari ar rëw̃ ki do yerin ki an!» ");
INSERT INTO bsc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yaka këŋo Yesu: «Eƴ dedo wa, nëngandëraleɓi ɓër kë ɓaxëtënd eyeƴan ed Kaxanu do këni rind er rek ɓën!» ");
INSERT INTO bsc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amëd aŋo bani ỹëmbërëgund kaŝ-kaŝ ɓela ɓën do këno xetand Yesu. Ata na ỹana ko ko rend: «Ɓela ɓër gë okey oko ɓën ɓëỹëŋënax exëni do këne w̃ëkand ecarax. Ecarax end rin baŋo Kaxanu Yonas eŋ fo këni wat, ax gi ex na ecëxen. ");
INSERT INTO bsc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ang hi baxo Yonas amatinali gër Ɓëninif ak, mondako fo këme hi wëno Asëñiw̃ ar ala an amatinali gër ɓela ɓër gë okey oko. ");
INSERT INTO bsc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Emun etoxari end gër ebar ed Saba eŋ, axani ko xaniɗ yatir këɓi xiti Kaxanu ɓela ɓër gë okey oko ɓën. Anëp këɓi nëpëɗ gayik mëŋ në ebar ed caw xaniw baxo ƴow ko gër Yerusalem eŋo mëkara Salomoŋ, emun end gë orenik osëm eŋ. Xarak wëno Asëñiw̃ ar ala an wa xuca këŋo Salomoŋ. ");
INSERT INTO bsc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɓëninif ɓën axani këni xaniɗ, yatir kiti, enëɓi nëp ɓër gë okey oko ɓën gayik ɓën anëngwët nëngwët bani ola oreɓën ol ga wël këni epemëra ed Yonas el. Xarak wëno Asëñiw̃ ar ala an xuca këŋo Yonas.» ");
INSERT INTO bsc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ala ax pëtënënd na lambo do exo kwët në er ɓeŋ ba exo ŋoɓ gë enëp. Ɓarikan ƴaŋ gër akaw̃aya ko xaw̃ eɓi ŋoɓaxënënd ɓër kë lilënd ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ɓangës ɓandeƴ ɓaŋ ex lambo ir eman in. Angëmëne ɓamëngw ɓayik ɗek eman kë xërikëra. Ɓari angëmëne ax ɓëngw ex na, ɗek eman kë hi gër ecamëɗan. ");
INSERT INTO bsc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Awa titinal këdi kë nëngwëta angoɓen andeƴ aŋ ecamëɗan. ");
INSERT INTO bsc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Angëmëne ɗek eman endeƴ eŋ xërikërak xali gë beɓët iɓatak ax gi ex na gër ecamëɗan, ɗek kë xërikëra ang kë xërikërand sam exi ŋoɓand lambo ak.» ");
INSERT INTO bsc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nand baxo yeƴan Yesu mondako na, fariseŋ iɓat xara këŋo exo ma eni ƴambërax gër ndeɓën. Ga h̃at këni, ỹëpa këni gër añambëraya. ");
INSERT INTO bsc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ata fariseŋ in ŝaran këŋo mbaŋ ga wat ko mëne Yesu axo neɓara bana ang rëp bax ak ɗamana eni ƴambëraxën. ");
INSERT INTO bsc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ata Axwën Yesu re ko: «Wën ofariseŋ ok, ed fac-fac el kën w̃ënënayand ang ar kë neɓënd odëƴamb ed fac-fac el fo, xarak ed lëf-lëf el ɗek ɓuyarëk. Lëf gër ow̃ëkw orewën ñamba ind ɓela, do gë oxeỹ fo xëñëk. ");
INSERT INTO bsc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ata wën ofariseŋ ok and an yëlarand na dëŋ ex ɗe! Ax gi ex na nde Kaxanu ri këŋo ala an gë eman do gë emëkw? ");
INSERT INTO bsc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yëlërayindënëɓi ɓëxaỹënaxik ɓën gë emëkw epeŝax, ata fo kën hi ɓëw̃ënëk. ");
INSERT INTO bsc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ɓari aŋun ye ex na wën ofariseŋ ok! Aw̃aŝ këno w̃aŝënd Kaxanu dim ir esëngëng in, ir egwërend in, gë ir ɗek ɓeɓëlëg ɓeɓër ex në andëɗa ɓën, do kën langanganënd or ŝenene ol do gë aŋana and Kaxanu an! Ɓeŋo don rind nëmëc, kwëyarëxe ɓeɓër ɓayik ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aŋun ye ex na wën ofariseŋ ok gayik ɓon h̃an kën eñëpa ed gër ed kënun wat ɓela ɗek el, lëf gër ɓaciw̃ ɓacaleya. Ɓëte ɓon h̃an kën enun cëmarand gër ɓapedëraya. ");
INSERT INTO bsc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wën aŋun ye ex na gayik ang ɓañeg ɓand lëmayak, do këni wëñërand ɓela nangërëxe fo hi kën!» ");
INSERT INTO bsc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ata aŝalen yeƴaneli këŋo Yesu: «Asëƴali, ang këƴ yeƴanënd ako, ɓiyi ɓëŝalen ɓën këƴëɓo ŝirënd ɓëte.» ");
INSERT INTO bsc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ata yaka këŋo Yesu: «Wën ɓëŝalen ɓën ɓëte, aŋun ye ex na gayik ang kënëɓi sëƴalind ɓela ak mbaŋ siɓëk, xarak wën gë tëkër ak an tëƴind na en tëf er kën rend in. ");
INSERT INTO bsc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wën aŋun ye ex na gayik wën kë ɓaƴënd ɓañeg ɓand ɓëlaw̃ënel ɓër Kaxanu ɓaŋ xarak ɓëxarëk ɓërewën ɓën dëŋ law̃ këɓi! ");
INSERT INTO bsc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Awa wën ex otede od ɓëxarëk ɓërewën ok. Ga kën ɓaƴënd ako ɓañeg ɓaŋ, ah̃an h̃an kën ɓeɓër ri këni ɓën. Ɓën law̃ kënëɓi ɓëlaw̃ënel ɓën, wën kën ɓaƴënd ɓañeg ɓandeɓën ɓaŋ! ");
INSERT INTO bsc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mëŋ rexën ko Kaxanu gë orenik orexëm ol: “Alaw̃ëneli këmëni law̃ëneli ɓëlaw̃ënel ɓëram ɓën do gë oparëxanda odam ok. Ɓarikan mar enëɓi ɗaw̃, mar enëɓi dixëra, ");
INSERT INTO bsc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","mëŋ këmëni xitixën ɓela ɓër gë okey oko ɓën, do mëni mëka end oŝat or ɗek ɓëlaw̃ënel ɓër law̃ëra kënëɓi ɓëxarëk ɓëreɓën eŋ, elod ga ỹanak ngwën iŋ. ");
INSERT INTO bsc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","End oŝat or Abel eŋ këmëni ỹana emëka el do me ŋata end oŝat or Sakari eŋ, mëŋ ar law̃ këno gër yangana ir Aciw̃ and Kaxanu an, fëco angëɓ fëco ebët. Aw̃ëka këmëni w̃ëka ɓeŋo ɓela ɓër gë okey oko ɓën.” ");
INSERT INTO bsc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Etëm hi këŋun wën ɓëŝalen ɓën! Acoketaya and onangëran aŋ rëxët kën. Wën dëŋ an ɗilënd na, ɓëte ɓër ỹandi këɓi eni ɗil ɓën, anëɓi teɓënd na eni ɗil.» ");
INSERT INTO bsc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","And ŝan ko Yesu na gër iciw̃ ind fariseŋ aŋ, ɓëŝalen ɓën do gë ofariseŋ ok ga xoỹën këno xali, ỹana këni këno w̃ëkarand ɓendanjëm. ");
INSERT INTO bsc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mama bano w̃ëkarand mondako exo yakaxën gë etëỹ edexëm el dëŋ end këno ɓonaxën eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ga xucak eŋo, ɓela ɓën ɓarërëgu këni owëli owëli gër Yesu xali hi këni amëxwër atëm, do këni w̃ëñelirënd. Ata këɓi felënd pere ɓësëfan ɓërexëm ɓën mondako: «Kwëỹëtayin lewir ir ofariseŋ in, gayikwa ɓën ɓëỹëŋënax ɓër kë laɓayand hi këni. ");
INSERT INTO bsc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Asorora fo këni sororand, gayik er këni ŝonënd in ax bo na, do end ɓeŋ ax bo na. ");
INSERT INTO bsc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mëŋ ex, end kën yeƴan gëmëɗ eŋ, goyat këni wëlëra; end kën nëkënëkar lëf gër ɓanakaya ɓand lëngwe eŋ, ƴaŋ gër oyur këni femëra. ");
INSERT INTO bsc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wën oɗawo ok këmun felënd: Kërenëɓi camënd na ɓër kë law̃ënd eman fo ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Afel këmun fel ar ỹapëk eno camënd an. Camino ar sam eŋo ɗaw̃ ala an, exo cot or gapak or exo ɗap enjëw̃ eŋ gër xoɗux. Awa ajo ex ar ỹapëk eno camënd an. ");
INSERT INTO bsc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ax gi ex na nde afan kënëɓi fanënd ɓënder ɓënjo ɓatama ɓaki? Ɓari Kaxanu inder gimatak aŋo kwëyand na. ");
INSERT INTO bsc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ado aye nang ko Kaxanu ɓemban ɓenjëgwe hik gër ogaf odewën. Mëŋ ex, këren yëdarand na. Asëfan aɓat aram xurik ex këɓën gë ɓënder ɓëndanjëm.» ");
INSERT INTO bsc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ga re këme, ar kë reƴand yo poyoma mëne aram hi ko, wëno Asëñiw̃ ar ala an mondako fo këme ỹana me deƴand endexëm eŋ gër omeleka od Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ɓarikan, ar ke ƴaxëta poyoma an, mondako fo këmo ƴaxëta gër omeleka od Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Do ar ke yeƴanan yo aỹëŋën, wëno Asëñiw̃ ar ala an, Kaxanu aseɓan këŋo seɓan. Ɓarikan, ar këŋo ŝir Angoc Amënëk an, eteɓan axo cot na. ");
INSERT INTO bsc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","And kënun ỹana enun mëlarand kiti ed ɓaciw̃ ɓacaleya ɓand ɓëŝëwif aŋ, do gër ɓër gapak, këreŋun yëɓund na end mondake kën yakaɗ eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Angoc Amënëk aŋ këŋun felëɗ amëd aŋo dëŋ ang kën yakaɗ ak.» ");
INSERT INTO bsc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Gër amëxwër, ala yeƴaneli baŋo na Yesu, re ko: «Asëƴali pelëlo aɓaỹe exe cet er seɓëtan kënëɓo ɓëxarëk in.» ");
INSERT INTO bsc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu yaka këŋo: «Noỹo ri ke wëno axiti arewën, ba arëc arewën?» ");
INSERT INTO bsc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na ex fel këɓi ɗek ang ebani ak: «Eŋan ed koɗi el ax ye ex na, gër ga ex yo kwëỹëtayin! Ala an, ang këŋo yera yo ax gi ex na napul in kë lëkaya aniyan andexëm aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ata ŝom ko gë apënëtal aŋo: «Mondako ri baxo ar gë napul an. Ga ỹandëra ko, ŝot ko xali eƴamb el. ");
INSERT INTO bsc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wëlan këŋo ang ko w̃ëxëta ak. Ga laki ko gëmëɗ, ko yëlarand: “Mondake këme ri eƴamb elo? Në ine këme w̃ëxëta? ");
INSERT INTO bsc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yo! Anëka nang këme ang këme ri ak. Owur oŋ këme yam me ɓaƴ or nëmëc oŋo ex këñaxën ɗek eƴamb edam el do gë napul iram in. ");
INSERT INTO bsc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","And këme ri mondako aŋ do mo pel enjëw̃ endam eŋ: dodo wëno anëka yera ke! Napul iram in mbaŋ ex, ɓëniy ɓëndanjëm ke nëka. Gogo oŝeɓ do gë aƴamb alaki fo ɓayi ke!” ");
INSERT INTO bsc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Na rew ko Kaxanu: “Ata wëj and aƴ yëlarand na dëŋ ex ɗe! Gëmëɗ go dëŋ këme xana enjëw̃ endeƴ! Do er w̃ëxëta këƴ ijo noỹo wa kë xwën?” ");
INSERT INTO bsc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mondako këŋo hi ar xwëndak eɓar ed napul fo an xarak aŋo ɓalënd na end Kaxanu eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ata Yesu fel këɓi ɓëte ɓësëfan ɓën: «Mëŋ këme rexënënd, këren dendërand na end aniyan andewën eŋ, end er kën ƴamb eŋ, ba end er kën ŝuɗa eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ax gi ex na nde aniyan and ala aŋ xëɓënëk nëmëc gë eƴamb ƴamb in, do eman eŋ nëmëc ɓanjëm ɓaŋ? ");
INSERT INTO bsc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ax gi ex na nde anang nang kënëɓi ɓaŋërak ɓaŋ: ani ñandërand na, ani kanarand na. Ani gi ex na gë owur, ani gi ex na gë ɓacac. Ɓarikan, Kaxanu alëɓa këɓi lëɓand. Xarak, wën xucak ex këɓën gë oŝël ol. ");
INSERT INTO bsc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gako wën ang hi kën ako, noỹo wa kë xor exo ɓaŝa ɓakey gër aniyan andexëm gë odendëran? ");
INSERT INTO bsc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gayikako an kor na en cakën ɓakey ɓandewën ɓaŋ, ine kën rendëraxënënd end ɓeɓër ɓayik eŋ? ");
INSERT INTO bsc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kwitayin ang kë hind opëtëfët od ondës ak, ax diyenind na, ax ɓanënd na ɓacole. Ɓarikan mbaŋ kë yend owat ol. Ado Salomoŋ dëŋ, gë ɗek enjaran endexëm ak, mëŋ emun end gë napul isëm eŋ, abaxo ye na gwër fo gë ondës oŋo. ");
INSERT INTO bsc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wën ata ekwëta etil ŝot kën ɗe! Angëmëne Kaxanu mondako ko fëỹëpëỹënd ondës ond lëgëk doro gër apuỹ oŋ, xarak ecan gër xoɗux këni lap, kaŝ fo këŋun fëỹëpëỹ wën ɓëte! ");
INSERT INTO bsc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Do wën, këreŋun ɓund na ocal od er kën ƴamb, ba er kën ŝeɓ. Këren torond na mama gër ɓanjëlan. ");
INSERT INTO bsc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Enimin, ɓeɓijo ɗek, ɓela ɓër ɓenëng ɓecëxe ɓën këɓi ɓalënd ocal ok. Anang nang ko Sorix irewën Kaxanu mëne aỹap ỹapëk en cot ɓeɓijo. ");
INSERT INTO bsc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kemënayindën ocal od owun or Kaxanu ok, ata këŋun sënd ɓeɓijo ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wën ɓër ex imëxwër ind sëf ke ɓën, këren yëdarand na. Wën yata këŋun Faba gër owun orexëm. ");
INSERT INTO bsc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Panin ɓacota ɓandewën ɓaŋ do koɗi in enëɓi yëlëra ɓëxaỹënaxik. Cëlayayin në er ɓayik ax ŋesi na. Napul irewën in gil ex ir ƴaŋ gër orën gër ed ax kwët na: fën gër ed arek ax gi ex na, oyame ani gi ex na. ");
INSERT INTO bsc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gayikwa gër ed ex napul irewën kë hind ɓëte anjëlan andewën aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Giyindën din ɓëw̃elëk, kapayindën enar eŋ, do oɗambo odewën ok ɓayilex ga kë lëkënd. ");
INSERT INTO bsc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Giyin ang ɓëriyenin ɓër ŝëni këŋo axwën areɓi an ga ƴe baxo ekana. And ko h̃atëgu aŋ, eno përëtënaxën sam exo tëmbëgu gër ebët. ");
INSERT INTO bsc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nëngandërayindëleɓi ɓëriyenin ɓëjo, ɓër këɓi sëk ga ŝëni këno moñëpa ɓën! Ɗal in këmun felënd, axwën an dëŋ kë nëmbara ɓanjëm ɓand andiyen, eɓi pel eni ñëpara gër ed këni ƴambëra, do eɓi ɗëɓara. ");
INSERT INTO bsc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Angëmëne exo ŋatëgu emëɗ ekarëk el, ba oxeya ol do eɓi tëk daŝërëxe, mbaŋ këɓi nëngandëra ɓëriyenin ɓëjo. ");
INSERT INTO bsc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aye fëni këŋun, ar nangëk amëd and ko ƴow arek aŋ, aferëna ko ferëna, aŋo teɓ na exo ɗil gër iciw̃ indexëm. ");
INSERT INTO bsc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wën ɓëte, këñënarayindën key yo key gayik ata këme h̃atëgu wëno Asëñiw̃ ar ala an amëd and an yëla bana na aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na w̃ëka ko Piyer: «Axwën, ɓiyi nde këƴëɓo rend gë apënëtal aŋo, ba ɓela ɗek nde?» ");
INSERT INTO bsc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yaka ko Axwën an: «Axwën an anëngandëra këŋo nëngandëra end aw̃ëxëta ar napul ar gë onden eŋ. Ga xwëta këŋo këŋo seɓënanaxën eƴamb ƴamb in eɓi yëlënd ɓërexëm ɓën in nand kë ỹapënd na. ");
INSERT INTO bsc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aye këŋo nëngandëraɗ ariyenin ar këŋo sëk axwën arexëm an ga ko ri er seɓënan baŋo in. ");
INSERT INTO bsc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ɗal in këmun felënd, ata këŋo xwëtënan ɗek napul irexëm in. ");
INSERT INTO bsc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ɓarikan angëmëne xaɗëp ijo exo dend: “Axwën aram an cëŋ axo bo ex na ngëŋ exo ŋatëgu”, do exo kwënda ekem ed okaɗëp ocandaw̃ otoŝan ok do gë okaɗëp otoxari ok, do exo kwënda ɓëte oŝeɓ, gë ñambëran. ");
INSERT INTO bsc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ata ko w̃aỹiw axwën ar xaɗëp an yatir ɓayik axo yëla bana do në amëd and axo nang ex na. Aŝew̃ëra këŋo ŝew̃ëra do eŋo narëndëra xali ang kënëɓi narënënd ɓër gë oŋëpëgënan ak. ");
INSERT INTO bsc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Xaɗëp ir kë nang aye er h̃an ko axwën arexëm in do exo dind mama dëŋ xali eŋo pënga, ɓacew̃en ɓandanjëm ko ŝot. ");
INSERT INTO bsc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ɓari xaɗëp ir ɓayik ax nang ex na an do exo dind ɓeɓër ax ñap ex na ɓën, axwën aŋ tëkër fo këŋo ŝew̃. Ar seɓënan këno mbaŋ an mbaŋ këno w̃ëka exo deƴa ba mondake ri ko. Do ar xwëta këno mbaŋ do fëxwën këno ɓeɓëranjëm an gë pit fo këno nëỹali.» ");
INSERT INTO bsc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu, ga h̃ata ko eŋo, re ko ɓëte: «Angoɗux ƴow këme me pëtën gër ebar, ako ỹandi ke ex ɗëkëdo anëka. ");
INSERT INTO bsc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xoɓuyi or këme ɓuyi ol, toro ind këme soro iŋ ex. Ɓarikan, monëkan nëkan ke ex ŋatëgu! ");
INSERT INTO bsc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ako nde yëla kën mëne eni cot ɓela ɓën angwëlëra aŋ ƴowaxënëgu këme gër ebar ro? Ɓëtëdëŋ, ga re këme, axucarëra wa këɓi ỹana eɓi kucarërand në end ow̃ac oram! ");
INSERT INTO bsc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mëŋ ex, në ekun ed ɓela ɓëco axucar këɓi xucar: ɓësas enëɓi kel ɓëxi, do ɓëxi enëɓi mereli ɓësas. ");
INSERT INTO bsc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɓëte në ekun eɓat, sëm in eɓi kucar gë asëñiw̃, do nëm in gë aɓiw̃. Ɓëte nëm ir eñër in eɓi kucar gë asoxari ar asëñiw̃ an.» ");
INSERT INTO bsc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu fel këɓi ɓëte amëxwër aŋ: «And kën wat aŋar ga xaniwëk acëla-eñaŋ, ataŋ kën rend: “Në eƴow ex tëɓ iŋ.” Ata ex ŋat go. ");
INSERT INTO bsc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Do and kë xaniw ekoc ambëtëɓ aŋ, are kën rend: “Aƴëka kë ƴëka.” Ata ex ŋat go. ");
INSERT INTO bsc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wën ɓëỹëŋënax ɓër kë laɓayand hi kën, mondake kën xorënd en nang ɓeɓër kën watënd gër orën do gër ebar ɓën, do kën sëkwanënd eŋun pëni ɓeɓër ko rind Kaxanu ɓakey ɓaŋo ɓën? ");
INSERT INTO bsc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Do ine kën sëkwanaxënënd eŋun pëni er ỹapëk en dind in? ");
INSERT INTO bsc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","And këŋun xucar gë ala do en ƴend gër kiti aŋ, kemënal en ketën gër fëña fo. Ketënin ɗamana en ŋat këdi këɓi fel axiti an eni mëla gër alëngw ar ɓënëkona exi përax. ");
INSERT INTO bsc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ga re këme, aƴ can na nëcëtërëxe ɗek koɗi ireƴ in xali gër biye ifelatar.» ");
INSERT INTO bsc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Amëd aŋo, ɓela ƴow bax na fel këno Yesu end Ɓëgalile ɓër law̃ baɓi Pilat eŋ. Er fel bano mëne kwël gër ed ri këni ŝaɗaxa fo ɓar ko Pilat oŝat oreɓën oŋ gë or oyel oreɓën oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ata Yesu yaka këɓi: «Ako nde yëla kën ɓër h̃aŝ kënëɓi ɓëjo xurik ex gi ɓëw̃endëran gër ɗek ebar ed Ɓëgalile el? ");
INSERT INTO bsc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ɓëtëdëŋ! Angëmëne an nëngwët ex na ola orewën ol, wën ɗek mondako fo kën nemi.» ");
INSERT INTO bsc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","W̃ëka këɓi ɓëte: «Ayëla nde yëla kën mëne ɓela epëxw gë ɓënjongëɓësas ɓër nemik ga wëcan këɓi ɓaciw̃ ɓatëndëndër ɓand gër Silowe ɓaŋ, xurik eni mendëra gë ɗek Ɓëyerusalem ɓën?» ");
INSERT INTO bsc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yaka ko mëŋ fo: «Ɓëtëdëŋ! Angëmëne an nëngwët ex na ola orewën ol, wën ɗek mondako fo kën nemi.» ");
INSERT INTO bsc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu fel këɓi ɓëte apënëtal aŋo: «Mondako ri baxo ala ga rëɗ ko andan gër andëɗa and reseŋ andexëm. And niyitak aŋ, ƴow ko exo kwëca ondan oŋ, sëk ko ax dëw̃ ex na. Ƴow ko ɓëte iniy ikënëm sëk ko mondako fo. ");
INSERT INTO bsc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ga ɓakaw ko iniy itasën iŋ sëk ko mëne andan aŋ ax dëw̃ ex na. Ata fel këŋo aŝën ar andëɗa an: “Elod ɓëniy ɓëtas këme ƴowënd gër ekwëca ed fig ɓari ame tëkënd na ga rëw̃ëk. Ŋoŝël tan, ebar fo kë nexënënd.”» ");
INSERT INTO bsc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ata yaka këŋo: «Axwën, and doyijo aŋ, teɓël! Wëno, anac këme nac jeƴ do me di ndëɓur iŋ. ");
INSERT INTO bsc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ɓamat ŝana arëw̃ kë rëw̃. Angëmëne ax dëw̃ ex na, gwëre eƴ ŋoŝëɗ.» ");
INSERT INTO bsc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yatir akey and eteyëta ed Ɓëŝëwif, Yesu baɓi sëƴalind në aciw̃ acaleya. ");
INSERT INTO bsc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yatijo asoxari ar seỹin bano ɓëyël elod ɓëniy epëxw gë ɓënjongëɓëtas ƴow baxëna na. Arëngwën rëngwën bano, do abaxo xor na gë tëkër ak exo dëngwëta. ");
INSERT INTO bsc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu, ga wat këŋo asoxari ajo, re ko: «Wëj, doro këƴ fak!» ");
INSERT INTO bsc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na ex h̃ëmba, ataŋ asoxari an rëngwëta ko, do këŋo ŝëkwand Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ata xoỹ ko alëngw ar aciw̃ acaleya an gayik Yesu afakën fakën këŋo aŝëxwëra an yatir akey and eteyëta. Fel këɓi amëxwër aŋ: «Ɓakey ɓanjongamat ex ɓand andiyen ɓaŋ, ƴowëndën enun pakën ɓakey ɓaŋo, ɓari ax gi ex na gë akey and eteyëta!» ");
INSERT INTO bsc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Axwën Yesu yaka ko: «Wën ɓëỹëŋënax ɓër kë laɓayand hi kën! Ax gi ex na nde ala kala, yatir akey and eteyëta, afët këŋo fëtënd engaŝ endexëm eŋ, ba fali irexëm in eŋo mëla gër añambëraya, do gër ed ko ŝeɓ men? ");
INSERT INTO bsc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Asoxari ajo, ar andëw̃ëra and Abëraxam ex do Sindan fok baŋo mondëngw elod ɓëniy epëxw gë ɓënjongëɓëtas. Mondake wa ɓayik aŋun ñapan ex na mopët yatir akey and eteyëta?» ");
INSERT INTO bsc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ga ko yeƴan mondako Yesu, ŝëfënandëra këɓi ɗek ɓër ŝus baŋo ɓën. Ɓarikan, ɓëranjëm nëngandëra baɓi gër amëxwër ga këni wat ɗek ɓenjekax ɓend baxo rind ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu re ko ɓëte: «Gë ine wëndërëk owun or Kaxanu ol? Gë ine këme w̃atinali? ");
INSERT INTO bsc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Watin gër wëndërëk in: ang enjëlir end mutarëd end neɗ ko ala në andëɗa andexëm fo ex. Ga lëgëk, rafëk, ata oŝël or gër orën ol yëlëra këni gër ɓenini.» ");
INSERT INTO bsc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ŝom ko ɓëte: «Gë ine këme w̃atinali ɓëte owun or Kaxanu ol? ");
INSERT INTO bsc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Watin gër wëndërëk in: ang lewir ir nëgali ko asoxari gë pix ga sëƴi ko okilo otas fo; and wëtëk aŋ fufëk ɗëm.» ");
INSERT INTO bsc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu, ga ko ƴe ond gër Yerusalem oŋ ko xucand ɓangol ɓaŋ: ɓaŋo ɓatil, ɓaŋo ɓatëm, do këɓi sëƴalirand. ");
INSERT INTO bsc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ata w̃ëka ko ala: «Axwën, mbaŋ nde exëni ɓër kë fex ɓën?» Yaka ko Yesu: ");
INSERT INTO bsc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Kemënayin en ɗil gër ebët ed mëreƴ. Ga re këme, ɓëranjëm këɓi xacëraɗ eni ɗil ɓari ani korëɗ na. ");
INSERT INTO bsc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","And ko xani axwën iciw̃ an do exo përa ebët aŋ xarak wën fac ɓayi kën, ata kën ỹana en tëmbënd do eno macënd: “Axwën! Axwën, përëtënëlëɓo!” Ata këŋun yakaw mëŋ: “Wën noɓën ex wa? Wëno amun nang ex na ɗe?” ");
INSERT INTO bsc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Do wën en dend: “Kwital wa, gë ɓiyi ga bane ƴambërande do bane ŝeɓërande andamat, gër opëña od angol andeɓi do baƴëɓo sëƴalirand.” ");
INSERT INTO bsc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ata eŋun yakaw ɓëte: “Ga re këme, ame nang ex na ba feye xaniw kën. Ado pacanaxëne wën ɗek ɓëw̃endëran ɓëjo.” ");
INSERT INTO bsc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Awa and kënëɓi ỹana enëɓi watënd ɓëxarëk ɓërewën aŋ: Abëraxam, gë Isak, gë Yakob do gë ɗek ɓëlaw̃ënel ɓër Kaxanu ɓën lëf gër orën, xarak wën fac lap kënun, ata kën ỹana en tesënd do en ŋatayand eɓasa el. ");
INSERT INTO bsc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓër kë lil gër orën ɓën, er këni ƴowëraw: ɓëjo apën-eñan, ɓëjo acëla-eñan, ɓëjo ambëng, do ɓëjo ambëtëɓ. Ɓën kë hi gër ñambëran. ");
INSERT INTO bsc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Awa mëŋ ex ɓemban ɓën kë hi ɓëlëngw do ɓëlëngw ɓën ɓemban.» ");
INSERT INTO bsc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Amëd aŋo Ofariseŋ sëka baŋo Yesu, do fel këno: «Erod në ecala exi! Angëmëne aƴ gër ex na, alaw̃ ki law̃!» ");
INSERT INTO bsc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu yaka ko: «Ƴeyin eno pelëx yakëra ijo, doro gë ecan në enëcët emëni ɓëyël ɓën gër ɓela, do në epakën emëni ɓëŝëxwëra ɓën, nambik këme h̃ata ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Awa doro gë ecan ỹapëk me kuca, nambik me ŋat gër Yerusalem gayik ax mënd ex na alaw̃ënel ar Kaxanu exo cës në angol acëxe.» ");
INSERT INTO bsc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ata Yesu ko ỹaw̃ënd angol and Yerusalem aŋ: «E Yerusalem, wëj këɓi law̃ënd ɓëlaw̃ënel ɓën do wëj këɓi fëtërand gë oxaỹ xali eni cës ɓër ki law̃ëneligund Kaxanu ɓën. Wëno aỹandi baxe ỹandi mëni ɓar oɓaŝ oreƴ ol ang këɓi ɓarënd ecare oɓaŝ orexëm ɗila gër obafe odexëm ak. Ɓari wën an aŋun ñandi ex na. ");
INSERT INTO bsc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Awa Kaxanu aỹaŋëta ko ỹaŋëta angol andewën aŋ. Ga re këme, ane wat na xali yatir kën reɗ: “Dodo ɓetalexo ar kë ƴowënd gë ow̃ac or Axwën an!”» ");
INSERT INTO bsc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Akey and eteyëta ed Ɓëŝëwif ebax, Yesu ƴe ko në iciw̃ ind alëngw ar ofariseŋ eni ƴambërax. Ɓër ebax na ɓën këno nëkonand aye Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aŝëxwëra hi bax na gër iciw̃ iŋo, ata këno sitinalind ba afakën këŋo fakën. ");
INSERT INTO bsc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ata Yesu w̃ëka këɓi ɓësëƴali ɓëŝalen ɓën do gë ofariseŋ ok: «Mondake rek acariya andeɓi aŋ end akey and eteyëta eŋ? Aỹap nde ỹapëk epakën ed aŝëxwëra el?» ");
INSERT INTO bsc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ata ɓën xor këni. Yesu mëŋ, h̃ëmba këŋo aŝëxwëra an, fakën këŋo do fel këŋo exo maỹi. ");
INSERT INTO bsc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aŋo w̃ëka këɓi ɓëte: «Ang hi kën ro ako, noỹo këŋo seɓ cëpëtërëxe ataŋ asëñiw̃ ba engaŝ endexëm and ko lati polo në andu yatir akey and eteyëta aŋ?» ");
INSERT INTO bsc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kaŝ-kaŝ wëlan baɓi ang këni yaka ak. ");
INSERT INTO bsc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ata Yesu fel këɓi apënëtal ɓër w̃ac banëɓi ñambëran ɓën ga këni xaŝër eno ketëna axwën ofëna an. Re ko: ");
INSERT INTO bsc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«And ki w̃ac ala ñambëran aŋ, këreƴëŋo ketëna na këdi ko h̃atëgu ar xuca ki or gapak. ");
INSERT INTO bsc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mbaŋ ki ŝëfënan and këƴ xani eƴ ñëpax gër ŝaŋ aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɓarikan, and këni w̃ac në ñambëran aŋ, ƴel eƴ ñëpa gër ŝaŋ. And ko h̃atëgu axwën ofëna aŋ, ata ki fel: “E lawo, tëkanaw ro!” Mondako ki rafën ogës od ɗek ɓela ɓër xetëra kën gër eƴambëran ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mëŋ ex ar kë w̃asinayand mëne ar gapak hi ko an, mëŋ fo këŋo ŝëfënan. Ar ɓayik ax dafënand na an, Kaxanu këŋo rafën.» ");
INSERT INTO bsc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu, ga h̃ata ko eŋo fel këŋo axwën ofëna an: «And këƴëɓi w̃ac ɓela en ƴambëra ecemar ed goyat ba ed genëka aŋ, këreƴëɓi macënd na oɗawo odeƴ, ba ɓoɓinëx, ba ɓër nëng ireƴ, ba ɓër gë napul, ba ɓëraketa andeƴ gayik ɓën axor këni xor eni maŝën. ");
INSERT INTO bsc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ɓarikan, macindëɓi ɓëxaỹënaxik, ɓëseỹik, ɓëŝiw̃ëk. ");
INSERT INTO bsc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aye ki nëngandëra gayik ɓën ani cot na er këni w̃aŝën in. Kaxanu ki w̃aŝënëɗ yatir këni xani gër ecës ɓër ŝenene ɓën.» ");
INSERT INTO bsc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ga ɓaxët këno Yesu ga ko yeƴan mondako, rew ko ala: «Nëngandëraleŋo ar kë hixeli gër ñambëran ind gër owun or Kaxanu an.» ");
INSERT INTO bsc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu yaka këŋo: «Mondako ri baxo ala ga w̃ac këɓi ɓëranjëm ñambëran. ");
INSERT INTO bsc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","And feyëtëra këni aŋ, law̃ën këŋo ariyenin aɓat gër ɓër w̃acëgu baɓi eɓi pelëx: “Ƴowën ngwa, anëka feyëtera këni.” ");
INSERT INTO bsc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ɓarikan, aɓat aɓat këni reƴand okaƴa ga xeƴ këɓi eni yaka. Aỹanar an re ko: “Wëno oŝënga yëc këme na do afo me ƴe me nëkonëgu. Axara xara këmi pelëxëyo axwën areƴ aŋ exe teɓan.” ");
INSERT INTO bsc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Axinëm an re ko: “Oxeƴ epëxw or ỹaneỹ yëc këmëni do afo mëni tëƴi ekap el. Axara xara këmi pelëxëyo axwën areƴ aŋ exe teɓan.” ");
INSERT INTO bsc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Re ko ɓëte aŝëxen: “Wëno cëŋ eceɗe fo ỹër këme, mëŋ ɓayik ame kam na me ƴeli.” ");
INSERT INTO bsc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ga ɓaka ko ariyenin an, felëx këŋo ɗek ɓeŋo axwën ofëna an. Ata mëŋ xoỹ ko xali, do re ko: “Awa kucal ataŋ eƴëɓi macëraw ɓela ɓën gër ɓakwëndaya do gër ocanditëra. Macuyëɓi ado eni gi ɓëxaỹënaxik, ɓërëgoɓo, ɓëseỹik, ɓëŝiw̃ëk.” ");
INSERT INTO bsc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ga ɓakaw ko ariyenin an, re ko: “Axwën anëka w̃acëraw këmëni ang re ɓaƴ ak, ɓarikan yer ɓayik ɓañëpara ɓaŋ.” ");
INSERT INTO bsc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ata axwën ofëna an fel këŋo ɓëte ariyenin an: “Tëfël opëña ok, do tar okece ok, nëỹaliwëyëɓi ɓela ɓën eni ƴow xali eni pëxw gër iciw̃ indam ro. ");
INSERT INTO bsc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ga re këme, ɓër felawëk ɓëjo gaɓatak ax tëƴi na ecemar edam el.”» ");
INSERT INTO bsc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Amëxwër atëm baŋo sëfand Yesu. Ata ŝena ko fel këɓi: ");
INSERT INTO bsc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ar ke sëf wëno an, ɓalindëleŋo endam eŋ nëmëc: gë end nëm gë sëm eŋ, gë end alindaw̃ eŋ, gë oɓaŝ orexëm eŋ do gë end ɓoɓinëm eŋ. Ɓalindëleŋo ɓëte endam eŋ nëmëc gë end aniyan andexëm eŋ dëŋ. Aŋo fo ko hixën enim asëfan aram. ");
INSERT INTO bsc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ar këŋo xeƴ yo toro do gë ecës në end ow̃ac oram, axo kor na exo gi asëfan aram. ");
INSERT INTO bsc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ang hi kën ro ako, ar këŋo ỹandi exo ɓaƴ ɓaciw̃ ɓatëndëndër an pere ko ỹëpa exo pën koɗi in, exo nangaxën ba ah̃ataxën ko h̃ataxën oɓaƴ ol. ");
INSERT INTO bsc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Angëmëne exo ñana oɓaƴ ol do exo di mondako dëŋ orëɗa oŋ, do exo takëndër, alëŝ këno ỹana eno ɗëŝënd ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Are këno ỹana eno dend: “Ala ajo anëka sëkwan ko ngëŋ oɓaƴ ol, axo kor ex na exo ŋata.”» ");
INSERT INTO bsc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yesu re ko ɓëte: «Emun end kë ƴend eŋo mereli ecandaw̃ eŋ, anëkon ko nëkon ba awënd wëndëk gë ocoroɗa owëli epëxw odexëm ok eni cëxwar gë ar gë owëli alapem an. ");
INSERT INTO bsc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Angëmëne aŋo mëndan ex na, caw fo ko ɓayiw arangoỹëra an eɓi ɗaw̃ën ɓela eno mëka mondake këni ri angwëlëra aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mëŋ ex, ar ax teɓ ex na ɗek er ŝot ko exe tëfaxën an, axo kor na exo gi enim asëfan aram.» ");
INSERT INTO bsc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ongal oŋ er ŝenene ex, ɓarikan and kë xac aŋ eɗap fo kë ɓayind? ");
INSERT INTO bsc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ongal okacax oŋ ofëcak ax gi ex na gër ebar, ɓëte ax gi ex na ndëɓur, alap fo ex. Awa ar gë anëf an ɓaxëtëlexo.» ");
INSERT INTO bsc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Akey amat, ɗek ɓësëf ɓër ŝagale ɓën, gë ɓëw̃endëran ɓën sëka këno Yesu eno ɓaxët. ");
INSERT INTO bsc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ata Ofariseŋ ok do gë ɓëŝalen ɓën ga këno rena, këni rend: «Ajo er wata ko eɓar ed ɓëw̃endëran eni ƴambëra gë ɓën.» ");
INSERT INTO bsc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ga wata ko Yesu, fel këɓi apënëtal aŋo. ");
INSERT INTO bsc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ang hi kën ro ako, ala eɓi cot opeỹ këme do eŋo nem iɓat. Aɓi teɓ na nde ofëxw ocongonax gë ocongonax ok gër apuỹ eŋo calaxën ir nem këŋo in? ");
INSERT INTO bsc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","And këŋo wat aŋ, ata këŋo weniw gë onënga fo. ");
INSERT INTO bsc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Do and ko h̃at gër iciw̃ aŋ, eɓi macëraw ɓëcandaw̃ ɓëŋ do gë ɓëraketa ɓën, exo de: “Ene mëkëñaraye w̃ac këmun, ifeỹ ir nem bamo in wat këmo!” ");
INSERT INTO bsc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Awa ga re këme, mondako fo këɓi nëngandërand nëmëc Kaxanu gë ɓër hi këni gër orën ɓën end aw̃endëran aɓat ar nëngwëtëk ola orexëm eŋ gë end ɓela ofëxw ocongonax gë ɓëcongëɓënax ɓër ŝenene, ɓër ɓayik aɓi ɓal ex na eni nëngwët ola oreɓën ɓën.» ");
INSERT INTO bsc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Angëmëne asoxari exo cot ɓatama epëxw ɓand koɗi do exo ɗapëta amat lëf gër anakaya, ax gi ex na nde ata ko fëtën lambo exo pat aye iciw̃ iŋ gër ocal? ");
INSERT INTO bsc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","And ko wat aŋ, aw̃ac këɓi w̃ac ɓëcandaw̃ ɓëŋ do ɓësoxari ɓëraketa ɓën, eɓi pel: “Ene mëkëñaraye w̃ac këmun, atama and koɗi and nem bame aŋ wat këme.” ");
INSERT INTO bsc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Awa ga re këme mondako këɓi nëngandërand omeleka ok gër lëngw ir Kaxanu and ko nëngwët aw̃endëran aɓat ola orexëm aŋ, do exo teɓ ɓeñëŋënax ɓend baxo rind ɓeŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ata re ko ɓëte Yesu: «Mondako ri baxo ala ar gë ocambenjar oki. ");
INSERT INTO bsc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Akey amat, ŝambenjar iɓeja in fel këŋo sëm: “Faba, yëlële tan oŝet oram ol gër napul ir këmi ɓëteliɗ in.” Ata sëm ŝetëndër këɓi. ");
INSERT INTO bsc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ga xeyërak, ŝambenjar iɓeja in nëmb ko ɗek er ŝot baxo in gë koɗi, do ƴe ko kwël në ebar ed caw, gër ed nëxendërax baxo napul irexëm in gë eñac. ");
INSERT INTO bsc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","And nexën ko ɗek aŋ, ɓayi ko taxan. Ata fëtëk enjo gër ebar elo. ");
INSERT INTO bsc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Enjo eŋ ga xumak, lil ko oxaɗac or ɓambëxwëbëxw. ");
INSERT INTO bsc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ɓandëmar ɗek baŋo ỹandind exo ƴamb er banëɓi xoɓënënd ɓambëxwëbëxw in, ɓari ala abaŋo yël na. ");
INSERT INTO bsc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amëd aŋo fëris këŋo onden oŋ, ata ỹana ko ko yëlarand: “Aseɓ fo këni seɓënd ecemar el ɓërandiyen ɓën gër ndeɓi. Do wëno këme rind me cës enjo eŋ ro. ");
INSERT INTO bsc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maỹileme saxëk. And këme h̃at aŋ me de: E faba, aw̃enan w̃enan këmo Kaxanu do aw̃enan w̃enan këmi wëj ɓëte. Ado wëno ame bo ex na itox indeƴ! Këreƴe macënd na asëñiw̃ën! ");
INSERT INTO bsc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gileme arandiyen andeƴ fo.” ");
INSERT INTO bsc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ga yëlara ko na mondako, xani ko do kwël w̃aỹi ko. Caw fo ɓayiw baxo ga watëgu këŋo sëm. Ga xaỹënan këŋo, xacëra këŋo gë ongër fo, w̃ega këŋo bëxiɓ gër egëla. ");
INSERT INTO bsc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ata re ko asëñiw̃: “E faba, aw̃enan w̃enan këmo Kaxanu do aw̃enan w̃enan këmi wëj ɓëte. Ado wëno ame bo ex na itox indeƴ! Këreƴe macënd na asëñiw̃ën!” ");
INSERT INTO bsc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ɓarikan, sëm fel këɓi ɓëriyenin ɓën: “Maraliwën acuɗ and gë oñaŋën aŋ. Ɗënino anëna aŋ gër imasa, do peɗino ɓapeɗ ɓaŋ gër osapar. ");
INSERT INTO bsc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yeɓëguno engaŝ ekwëlëxwël eŋ, enëŋo ŋaŝe. Doro ofëna osëm këmo rin asëñiw̃ën. ");
INSERT INTO bsc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ƴowën, er yëla bame anemi nemi ko ɓarikan w̃aỹiw ko aɓëngw. Anem nem bamo ɓarikan anëka wat këmo.” Ata ƴowëraw këni ɓela ɓën gër ofëna. ");
INSERT INTO bsc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Xarak ŝambenjar ixarëk in gër oŝënga hi baxo. And baxo w̃aỹi gër iciw̃ genëka aŋ, wël ko angoŋ aŋ; ɓela ga këni wandëra gër yangana. ");
INSERT INTO bsc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ata w̃ac këŋo ariyenin aɓat eŋo mëka ba ine ex gër iciw̃. ");
INSERT INTO bsc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yaka ko: “Aɓinëx w̃aỹiwëk do gayik aɓëngw fo h̃atëgu ko, sorix h̃aŝën këŋo engaŝ ekwëlëxwël eŋ.” ");
INSERT INTO bsc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mëŋ ga xoỹ ko na, h̃isa ko kwël, h̃ëp ko exo ɗil gër iciw̃. Ata sëm ŝan ko eŋo karaw. ");
INSERT INTO bsc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ga këŋo yifara exo h̃at gër iciw̃, yaka këŋo: “Wëno ɓëniy ɓëndanjëm këmi riyeninënd ang xaɗëp fo, elod ame ŋëp ex na ɓapela ɓandeƴ ɓaŋ, ɓari elod aƴe yël ex na imeci ind këmo ƴak wëno gë ɓëcandaw̃ën ɓëndam ɓëŋ! ");
INSERT INTO bsc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ɓarikan and h̃atëgu ko asëñix aŋ, h̃aŝën këƴo yer engaŝ eŋ, xarak mëŋ ƴambëk napul ireƴ in gë ɓësoxari ɓëŝëxwëpëtaxik.” ");
INSERT INTO bsc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ata re ko sëm: “Oko asëñiw̃ën, wëj elod aƴe teɓ ex na do eram in er eƴ ex! ");
INSERT INTO bsc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ŋatëgu gër ofëna or rin këmo aɓinëx ir yëla bame anemi nemi ko ɓarikan w̃aỹiw ko aɓëngw, anem nem bamo anëka wat këmo!”» ");
INSERT INTO bsc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu fel këɓi ɓëte ɓësëfan ɓën apënëtal aŋo: «Mondako ri baxo ala ar ŝot baŋo aw̃ëxëta ar napul irexëm. Ga wata këno mëne aw̃ëxëta ar napul an në enëxen exo napul in, fut këno gër axwën arexëm. ");
INSERT INTO bsc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Axwën an ga w̃ac këŋo aw̃ëxëta ar napul an do w̃ëka këŋo: “Ine këme wëlënd? Deƴal ang w̃ëlaya këƴ napul iram ak? Ƴeye exe nëkone gayik aƴ ɓayi na aw̃ëxëta ar napul iram!” ");
INSERT INTO bsc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ɗamana exo teɓaxën andiyen, aw̃ëxëta ar napul an re ko: “Mondake këme ri gayikako axwën aram an në ekan exe andiyen and emëlaya ed napul aŋ? Ỹaneỹ in axe yël ex na do okar ok aŝëfën ex.” ");
INSERT INTO bsc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ata re ko: “Yo anëka nang këme ang re këme ak ene dëcaxënënd ɓela ɓën ecan ecan and këme seɓ andiyen and emëlaya ed napul aŋ.” ");
INSERT INTO bsc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ata w̃ac këɓi aɓat aɓat ɓër ỹomëxara bax ɓën. W̃ëka këŋo aỹanar an: “Wëj, yëgwe ỹomëxa baƴo axwën aram an?” ");
INSERT INTO bsc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yaka ko: “Ɓapeƴa keme ɓand ogu ond olif.” Aw̃ëxëta ar napul an re ko: “Awa kanal ikayëta iŋ, gërëgako ɓapeƴa ofëxw oco fo këƴ w̃aŝ.” ");
INSERT INTO bsc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","W̃ëka këŋo axinëm an: “Wëj cëŋ yëgwe ỹomëxa baƴ?” Yaka ko: “Ojaɓote keme od bële.” Fel këŋo: “Kanal ikayëta in, gërëgako ojaɓote ofëxw ocongosas këƴ w̃aŝ.” H̃ata këɓi ɗek mondako. ");
INSERT INTO bsc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ata axwën an ŝëkwa këŋo aw̃ëxëta ar napul asëmbak ajo.» Ata re ko ɓëte Yesu: «Mondako këni rind ɓela ɓër këɓi ɓalënd end aniyan and gë okey oko fo ɓën. Ɓën kë xëñënand end ecan ecan eŋ nëmëc gë ɓër ex gër angoɓen ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mëŋ këme rexënënd calayindënëɓi oɗawo gë napul isëmbak in, ata kën ɓarëxëɗ gë ɓën gër aniyan and din ƴaŋ gër orën. ");
INSERT INTO bsc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ar hik mokwëta gë ɓeɓ ɓeɓësil an mondako fo këŋo ɓal ɓeɓër xëɓënëk. Ar sëmbak gër ɓeɓër ɓayik ax ñëmb ex na an mondako fo ko sëmba gër ɓeɓ ɓëranjëm. ");
INSERT INTO bsc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Awa angëmëne an gi ex na ɓër mokwëta gë napul isëmbak ir gër ngwën ro in, noỹo këŋun seɓënan napul ir ɗal iŋ? ");
INSERT INTO bsc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Awa angëmëne an gi ex na ɓër mokwëta gër er xwën ko ala aŝëxe in, noỹo këŋun xwëtënan enjekax end ɗal eŋ? ");
INSERT INTO bsc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ariyenin gaɓatak axo kor na exo gi xaɗëp ir ɓëxwën ɓëxi. Enimin, afo eŋo ŋan aɓat do eŋo cus ajo an. Afo eni wëlër gë aɓat do eɓi koỹër gë ajo. Mëŋ ex, an kor na enëɓi ɓara Kaxanu gë koɗi in.» ");
INSERT INTO bsc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ata Ofariseŋ ok, ga hi bani ɓëh̃an ɓër koɗi, këno lëŝënd Yesu ga wël këni ɗek er baxo rend in gayik ɓën end koɗi xurixën baɓi. ");
INSERT INTO bsc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ga wata këɓi Yesu, re ko: «Ata wën dëŋ ex ɗe ɓër kë w̃asinayand ang ɓër ŝenene fo gër ogës od ɓela. Ɓarikan, Kaxanu ɗek ko watënd ow̃ëkw orewën oŋ. Er këɓi xëɓënanënd ɓela in ejo ecusëŝus ex gër Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Xali and ƴow ko Ŝaŋ Batis aŋ, er ebax acariya and Moyis aŋ do gë eyeƴan ed ɓëlaw̃ënel el, gërëgako, owun or Kaxanu ol këni femërand ang Atëfëtan fo, ala kala në enëỹëtëra exo exo ɗilaxën. ");
INSERT INTO bsc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Xarak er saxëk ex dëxëta ebar el gë orën ol gë ex pëxwëcaya iñëgw imat gër acariya and Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Asoŝan ar këŋo fela yo alindaw̃ do eŋo ñër aŝëxen, në emenan eŋo aỹanar an gayik orekar këni rind gë axinëm an. Do asoŝan ar këŋo ỹër yo asoxari ar fela këŋo icën indexëm, orekar këni rind gë asoxari ajo.» ");
INSERT INTO bsc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ata re ko ɓëte Yesu: «Mondako ri baxo ar gë napul. Mëŋ ɓanjëm ɓanjekax ɓambarax, gë ɓanjëm ɓand xaf-xaf ɓand xemënëk acanji fo baxo ŝuɗarand. Do key yo key ñambëran fo bax gër iciw̃ indexëm. ");
INSERT INTO bsc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Axaỹënaxik ar bano w̃acënd Lasar bax renarand na gër ebët ed iciw̃ ind ar gë napul. Okejën fo baxo ɗek eman eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ako baŋo ỹandind exo meɗara gër ed baxo ƴambërand ar gë napul an. Ado oɗaŋët fo baŋo sëkand eno ɗaỹëndëra okejën ok. ");
INSERT INTO bsc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Akey amat, axaỹënaxik ajo ŝës ko, w̃ëla këno omeleka ok gër ed hi ko Abëraxam. W̃ëla këno omeleka ok. Ŝës ko ɓëte ar gë napul an do w̃ëxëta këno. ");
INSERT INTO bsc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ata hix këni ɓën tak gër wur ir ɓëŝësëk: axaỹënaxik an gër ed ko Abëraxam do ar gë napul an gër ed ex toro. Ga xeŋa ko, wat këŋo caw Abëraxam ga ɓexena këŋo Lasar. ");
INSERT INTO bsc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ata w̃ac ko: “E ŝaca Abëraxam, kaỹënanëlexi wa wëno! Pelëlo Lasar exo ñëmb eɓasa el gër men do exo ƴow exe taɓinan gër aniw̃. Mbaŋ këme sorond gër xoɗux ro.” ");
INSERT INTO bsc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yaka ko Abëraxam: “Ŝaca, kwital wa ang ɓeta baƴ gër aniyan andeƴ ak, xarak Lasar mëŋ asoro baxo sorond. Gërëgako mëŋ anëka yera këŋo xarak wëj në toro eƴ. ");
INSERT INTO bsc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Adofa ambëxw atiw̃ax fani këɓo na wën gë ɓiyi. Ɓiyi ro ar ỹandi këŋo exo ƴeli an axo kor na ɓëte wën fën ala ax kor na exo ƴow ro.” ");
INSERT INTO bsc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ga wël ko eŋo, w̃ëka ko ɓëte ar gë napul an: “Këla ŝaca Abëraxam, gayik mondako ex, ɗaw̃ënëlo ngwa Lasar gër ndeɓi. ");
INSERT INTO bsc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ɓëmaỹe ɓënjo seɓëtagu këmëni. Mëlanëleɓi osede orexëm ol, këdi këni ƴow ɓën ɓëte ro gër wur ir toro!” ");
INSERT INTO bsc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abëraxam yaka ko: “Oko aŝot ga ŝot kënëɓi wa Moyis do gë ɓëlaw̃ënel ɓën, ɓaxëtindëlenëɓi.” ");
INSERT INTO bsc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ar gë napul an re ko ɓëte: “Ali aɓaɓak eŋo Ŝaca Abëraxam! Angëmëne ar nemik sëkëx këɓi aŋo fo këni w̃a eni nëngwët ola oreɓën ol.” ");
INSERT INTO bsc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Na re ko Abëraxam: “Angëmëne ani tëf ex na er re këni Moyis do gë ɓëlaw̃ënel in, ani gi na ani ma na, ado exo kanido ala gër ecës do eɓi tëkëx, ani ma na.”» ");
INSERT INTO bsc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ga xucak eŋo, Yesu fel këɓi ɓësëfan ɓërexëm ɓën: «Gër aniyan, afo ex gi ɓeɓër kë lënanënd eñëŋënax. Ɓari aŋo ye ex na ar këɓi lënanënd eñëŋënax ɓela an! ");
INSERT INTO bsc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Er sax doŋo eno kapeli gë angaỹ and këni h̃oxixënënd eƴamb do eno ɗap gër ngu, gë eŋo ɗënan eñëŋënax eŋ asëfan aram. ");
INSERT INTO bsc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Diyindën gë onden oŋ! Angëmëne aɓinëx w̃endërak na, pelëralo. Angëmëne anëngwët nëngwët ko ola orexëm ol, teɓanëlo. ");
INSERT INTO bsc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ado exi menan ɓanjongëɓaki gër amëɗëna do exo ƴeli ɓanjongëɓaki exi mëka eƴo teɓan, teɓaniɗo.» ");
INSERT INTO bsc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Oparëxanda od Axwën ok xara këno: «Ɓaŝënëlëɓo wa ekwëta ed Kaxanu el.» ");
INSERT INTO bsc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Axwën Yesu yaka ko: «Ado ex ɓado yo ekwëta edewën el gwër gë enjëlir end mutarëd, axor xor don en de: “Wëj atëx aŋo, bicayal fa eƴ dëɗayax gër ngu.” Ata ridox ang re kën ak. ");
INSERT INTO bsc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Angëmëne ang hi kën ro ak, ala eŋo cot xaɗëp gër oŝënga, ba gër oxaɗac or oyel, do exo ŋatëgu genëka, afel nde këŋo fel exo ñëpa ataŋ gër eƴambëran? ");
INSERT INTO bsc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pere këŋo fel xaɗëp irexëm in: “Nëmbaral fa eƴe cemëranaxën, xali me ƴambëra do me ceɓëra. And këme w̃ed aŋ, wëj ɓëte, axor këƴ xor eƴ ƴambëra do eƴ ceɓëra”. ");
INSERT INTO bsc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Xaɗëp ijo, aŋo cëkwa na gayik er fel baŋo in fo ri ko. ");
INSERT INTO bsc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mondako fo ex endewën eŋ. And kën ri ɗek er fel këŋun Axwën in, deyindën: “Er ỹapëk mi di in ri kën ang okaɗëp fo”.» ");
INSERT INTO bsc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ond gër Yerusalem oŋ ɓayi baxo ga ko ƴe Yesu. Ata ko xucand fëco ebar ed Samari fëco ed Galile. ");
INSERT INTO bsc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ga ko h̃at në angol, xacëra këno ɓela epëxw ɓër gë ameỹ. Caw fo ɓayi bani ga këni re: ");
INSERT INTO bsc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Axwën Yesu, Axwën Yesu, kaỹënanëlexi ɓiyi!» ");
INSERT INTO bsc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sam ga wat këɓi, fel këɓi: «Ƴeyin enun nëkonëx ɓëŝaɗaxan ɓën.» Ata ga këni ƴe, ŝan këɓi ameỹ aŋ do w̃ën këni. ");
INSERT INTO bsc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ga fak këni na ɓën ɗek, aɓat ko xeỹënd ga këŋo ŝëkwa Kaxanu do wërëŝëta ko gër Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ga h̃at ko, foxi ko, rëngw ko eƴiỹ el ŋëŝ gër ebar, gër osapar or Yesu do këŋo ŝëkwand. Asamari ebax. ");
INSERT INTO bsc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ata re ko Yesu: «Ax gi ex na nde ɓela epëxw ɓën ɗek fakën këmëni? Do feye cëŋ exëni ɓëcongëɓënax ɓën? ");
INSERT INTO bsc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ar gër ebar ed Samari ajo fo nde xwitak exo ɓakaw eŋo cëkwa Kaxanu?» ");
INSERT INTO bsc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na fel këŋo ar ɓakaw bax an: «Poxital eƴ maỹi, ga xwëta këƴo Kaxanu fakaxën këƴ!» ");
INSERT INTO bsc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ofariseŋ ok w̃ëka baŋo Yesu eɓi pel ba nand feye kë ƴow owun or Kaxanu ol. Ata yaka këɓi: «Ala ax wata na nand kë ƴow owun or Kaxanu na. ");
INSERT INTO bsc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mëŋ ex, ala ax de na: “Ro ex” ba “Fën ex” enimin owun or Kaxanu ol lëf gër ow̃ëkw orewën ex.» ");
INSERT INTO bsc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ata fel këɓi ɓëte ɓësëfan ɓën: «Në eƴow ex ɓakey ɓand këŋun ỹandiɗ ene wat wëno Asëñiw̃ ar ala ɓaŋ, ɓari ane watëɗ na. ");
INSERT INTO bsc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ata kënun ỹana enun pelënd mëne Asëñiw̃ ar ala an ro exo ba fën exo. Këren kaŝërëɗ na gër ed kënun fënëtan. ");
INSERT INTO bsc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Enimin, ang kë wingarand ciɗët orën ak xali eni watëra ɓela ɓën, mondako fo kë hiɗ yatir këme ɓakaw wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ɓarikan pere fo këme soro mbaŋ do ene cus ɓela ɓër gë okey oko ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ang hi baɓi ɓela ɓën angwën and ebaxo Nowe ak këɓi hi yatir këme ɓakaw wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Er xwënda bani ɓela ɓën: ñambëran, oŝeɓ, eñërër, eñërëndër, xali lil ko Nowe gër Akuluŋ. Fënga këɓi tëɓ itëm, ỹëmëk ebar el do men oŋ nemindëra këɓi ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɓëte ang hi baɓi ɓela ɓën angwën and ebaxo ar bano w̃acënd Lot ak këɓi hi. Er xwënda bani ñambëran, oŝeɓ, opane, ỹaneỹ, eɓaƴ ed ɓaciw̃. ");
INSERT INTO bsc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ɓarikan, yatir hër ko Lot angol and Sodom aŋ, mungu fët bax gër orën do sëɓandëra këɓi xoɗux, law̃ëra këɓi ɓën ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mondako fo kë hiɗ yatir këme ŝanayaw wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yatijo, ar ex ƴaŋ në ejur ed këɓe an xarak oỹënga orexëm oŋ lëf ex, kërexo pedanëɗ na exo gëraxën. Ɓëte ar ex gër apuỹ an kërexo maỹiɗ na, gërëxëɗëlexo. ");
INSERT INTO bsc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kwitayindën end alindaw̃ ar Lot eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ar kë ŝala exo pexën enjëw̃ endexëm an fo, anemin ko nemin. Do ar kë w̃a exo nemin an, afexën ko fexën. ");
INSERT INTO bsc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ga re këme, yatir këme h̃atëgu gëmëɗ ijo fo kë hi mondako: ɓela ɓëxi ɓër kë laki në angaw̃ amat, aɓat mo mëla, ajo mo teɓ. ");
INSERT INTO bsc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Gër ed këni sëŋërand ɓësoxari ɓëxi: aɓat mo mëla, ajo mo teɓ. ");
INSERT INTO bsc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gër ed këni ỹandërand ɓësoŝan ɓëxi: aɓat mo mëla, ajo mo teɓ.» ");
INSERT INTO bsc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ata ɓësëfan ɓën w̃ëka këno Yesu: «Do Axwën, feye wa kë h̃atëgu eŋo?» Yaka këɓi: «Gër ed ex eman embërëk, fën këni ɓarërënd oyafe ol.» ");
INSERT INTO bsc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Axwën Yesu këɓi sëƴalind mëne ax gi ex na motëkwëra cale iŋ. Ata fel këɓi apënëtal aŋo. ");
INSERT INTO bsc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Re ko: «Mondako ri baxo axiti ar hi bax në angol. Mëŋ abaŋo yëda na Kaxanu, ɓëte end ala abaŋo ɓal na. ");
INSERT INTO bsc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɓëte, asoxari aseɓëta seɓëta hi bax na gër angol aŋo, ar bax ƴend key yo key eŋo pel: “Kitilëɓo gë arangoỹëra andam an.” ");
INSERT INTO bsc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Axiti an laŋ baxo h̃ëpënd eŋo yakali, ɓari asoxari an aŋo cena bana. Ata akey amat, axiti an ga lëɓëlëɓa këŋo, yëlara ko: “Wëno amo yëdand na Kaxanu, ɓëte end ala axe ɓalënd na. ");
INSERT INTO bsc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ɓarikan, anëka lëɓëlëɓa ke end asoxari ajo eŋ. Exe teɓaxën afo mëni kiti gë ar xucar këɓi an.”» ");
INSERT INTO bsc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ga h̃ata ko apënëtal aŋ, Axwën an ŝom ko: «Wat kën nde mëne axiti asëmbak ajo ayakali yakali baŋo asoxari an? ");
INSERT INTO bsc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Do Kaxanu aɓi yakali na nde ɓër yata këɓi ɓën? And këno ỹana eno calend ciŝ wec aŋ, aɓi yakali na nde sam eŋo ŋatan? ");
INSERT INTO bsc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ga re këme, ataŋ ataŋ këɓi yakali or ŝenene or këni w̃ëkand ol. Ɓarikan, and këme ɓakaw wëno Asëñiw̃ ar ala aŋ, asëkati nde këme sëkati ekwëta ed Kaxanu el gër ebar ro?» ");
INSERT INTO bsc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ɓërëmar bax yëland ɓën ɓër ŝenene hi këni do banëɓi yafënd ɓoŝandaw̃, Yesu fel këɓi apënëtal aŋo. ");
INSERT INTO bsc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Re ko: «Mondako ri bani ɓela ɓëxi ga ƴe këni eni calex gër Aciw̃ and Kaxanu: fariseŋ do gë asëf ar ŝagale. ");
INSERT INTO bsc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseŋ in ỹana ko ko ŝalend mokwëŝa: “Kaxanu aye ri këƴ gayik wëno ame gi ex na asëmbak ang exëni ɓela ɓëranjëm. Ame dekand na, amëni yifand na ɓela, ame dind na orekar, ado ame gi ex na ang asëf ar ŝagale ajo. ");
INSERT INTO bsc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wëno, ɓaki këme siw̃ind gër loxo do ɗek er ŝot këme yo aw̃ed këme w̃eɗënd dim in.” ");
INSERT INTO bsc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Amëd aŋo fo ɓëte baxo ŝalend nacët ako asëf ar ŝagale an. Ado abaxo yëxw na exo dënëta do exo keŋa orën ol. Emëkw el baxo xëmënd do ko rend: “E Kaxanu, kaỹënanëlexi wëno aw̃endëran ajo!”» ");
INSERT INTO bsc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu, ga h̃ata ko apënëtal aŋ, ŝom ko: «Ga re këme, asëf ar ŝagale an w̃aỹik gër ndeɓën ar ŝenene, xarak ax gi ex na fariseŋ in. Gayikwa ar kë rafënand yo, Kaxanu alat këŋo lat, ɓarikan ar kë ɓanand an arafën këŋo rafën.» ");
INSERT INTO bsc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓela baɓi w̃ëlaw oɓaŝ gër Yesu gë ɓëndoyer ak eɓi calen mokwëtan otaxan ok. Ɓarikan, ɓësëfan ɓën ga wat kënëɓi ɓëjo xeỹënaxën kënëɓi. ");
INSERT INTO bsc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ata w̃ac këɓi Yesu do re ko: «Teɓëgunëɓi oɓaŝ ol eni ƴow gër ndam. Kërenëɓi ŋw̃aỹ na gayik ɓër ex ang ɓën ak ɓën kë xwën owun or Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ɗal in këmun felënd, afo ar w̃ak end Kaxanu ang itox an fo kë lil gër owun olo.» ");
INSERT INTO bsc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ata alëngw ar Ɓëŝëwif w̃ëka këŋo Yesu: «Asëƴali, wëj ar ŝenene an, ine ỹapëk me di me cotaxën aniyan and din aŋ?» ");
INSERT INTO bsc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu yaka këŋo: «Inew̃a këƴe w̃acaxënënd ar ŝenene? Ar ŝenene ax gi ex na, ang ax gi ex na Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wëj anang nang këƴ ɓapela ɓand Moyis ɓaŋo: “këreƴ dind na orekar, ala këreƴo ɗaw̃ëɗ na, këreƴ dekand na, këreƴ nëgwëŝënd na, pëɓindëɓi norix gë sorix.”» ");
INSERT INTO bsc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ata re ko ala ajo: «Elod itox sëf këme ɗek ɓapela ɓaŋo.» ");
INSERT INTO bsc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ga wël ko eŋo Yesu re ko: «Emat ɓayik eƴ di ɓëte. Panël ɗek acota andeƴ aŋ, eƴëɓi yëlëra koɗi in ɓëxaỹënaxik ɓën, ata këƴ ŝot napul ƴaŋ gër orën. And këƴ ri mondako aŋ ƴowëɗ eƴe tëf.» ");
INSERT INTO bsc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","And wël ko eyeƴan elo an, alëngw ar Ɓëŝëwif an hi ko ỹëmërot, gayikwa ar gë napul isëm hi baxo. ");
INSERT INTO bsc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu, ga wat këŋo ỹëmërot, re ko: «Ɓon këɓi ƴëka ɓër gë napul ɓën eni ɗilaxën gër owun or Kaxanu! ");
INSERT INTO bsc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gelemba saxëk exo kuca në imëd ind icëkwër gë exo ɗil ar gë napul gër owun or Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ata ɓër baŋo ɓaxëtënd, re këni: «Do noỹo ngwa kë fex?» ");
INSERT INTO bsc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yaka ko Yesu: «Er ax mënd ex na gër ɓela in, gër Kaxanu awënd wëndëk.» ");
INSERT INTO bsc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na rew ko Piyer: «Do ɓiyi wa ga seɓëraw këmi ako ɗek mi tëfaxën?» ");
INSERT INTO bsc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yaka këŋo: «Ɗal in këmun felënd, ar kë seɓëra ɗek në end owun or Kaxanu eŋ: iciw̃, alindaw̃, oɓaŝ, ɓoɓinëm, nëm gë sëm, afex ko fex. ");
INSERT INTO bsc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Gërëgako dëŋ ko ŝotëra nëmëc ɓeɓër seɓëraw ko ɓën, do ecan ecan, aniyan and din aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ga xucak eŋo, Yesu w̃ac këɓi ɓësëfan epëxw gë ɓëxi ɓën do fel këɓi: «Awa, në ƴene ɗe ƴaŋ gër Yerusalem. Nangin mëne ɗek er ebax exe gi wëno Asëñiw̃ ar ala in, ah̃ata kë h̃ata, ang ỹëgw këni ɓëlaw̃ënel ɓër Kaxanu ak. ");
INSERT INTO bsc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gayikwa alëxw këne lëxw gër ɓër ax gi ex na Ɓëŝëwif, ene ɗëŝëra, ene dixëra do ene tëpandëra. ");
INSERT INTO bsc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","And këne xëmër aŋ ene ɗaw̃. Ɓarikan, axani këme xani gër ecës yatir akey atasën.» ");
INSERT INTO bsc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ga ɓaxët këno Yesu, ɓësëfan ɓën aɓi pëni bana gë tëkër ak er re ko in, eŋo aɓi paỹën bana. ");
INSERT INTO bsc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu ga ko h̃at gër angol and Yeriko, sëk këno aŝiw̃ëk ga ỹëpa ko okararan ler gër fëña. ");
INSERT INTO bsc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aŝiw̃ëk an wël këɓi ɓela ga këni xuca, ata w̃ëka ko ba ine ex. ");
INSERT INTO bsc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yaka këno: «Yesu Iɓënasaret kë xucand.» ");
INSERT INTO bsc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na w̃acar ko: «Yesu, Yesu, Asëñiw̃ ar Dafid, kaỹënanëlexi wa wëno!» ");
INSERT INTO bsc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓër sëfër bani gë Yesu ɓën këno xeỹënaxënënd: «Wëj, cësinal fa!» Ɓarikan mëŋ aŋo ɓaŝ ko okeỹ oŋ: «Asëñiw̃ ar Dafid, Asëñiw̃ ar Dafid, kaỹënanëlexi wa wëno!» ");
INSERT INTO bsc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ga xwëŝa ko Yesu, re ko eno mëlanëgu aŝiw̃ëk an. And h̃ateliw këno aŋ, w̃ëka këŋo: ");
INSERT INTO bsc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wëj, inew̃a ỹandi ki mi din?» Yaka ko: «Axwën me ciw̃ëta ỹandi ke!» ");
INSERT INTO bsc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ata re ko ɓëte Yesu: «Ciw̃ëtal, ga xwëta këƴe ako!» ");
INSERT INTO bsc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ataŋ ataŋ watëra ko, këŋo ŝëkwand Kaxanu do kwël sëfa këŋo Yesu. Ɓulunda in ɗek ga wat këni eŋo, këno ŝëkwand ɓëte Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ata Yesu ko xucand angol and Yeriko aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ala baxëna ar bano w̃acënd Saŝe gër angol aŋo. Mëŋ hi bax alëngw ar ɓësëf ɓër ŝagale an, do hi baxo ar gë napul isëm. ");
INSERT INTO bsc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Gayikako mëŋ mbaŋ rom baxo, wata ko mëne ax mënd bana eŋo wat Yesu ŝit gër enga xarak ɓon ɓal baŋo eŋo nang. ");
INSERT INTO bsc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ata hër ko eŋo kaŝëx ƴaŋ në anak gayik Yesu fëña ijo sëf baxo. ");
INSERT INTO bsc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","And h̃at ko Yesu ɗila gër atëx aŋ, xeŋa ko do w̃ac këŋo: «Saŝe, maral eƴ pedaw doro gër ndewën këme h̃at.» ");
INSERT INTO bsc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ata Saŝe, joc gër ebar do kwël sëfër këni gë Yesu gë onënga fo. ");
INSERT INTO bsc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɗek ɓër ebax na ɓën këni rendërand: «Yama gër iciw̃ ind aw̃endëran ajo nde ko ƴend?» ");
INSERT INTO bsc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","And h̃at këni aŋ, Saŝe xwëŝa ko, ŝena ko gand Yesu, do re ko: «Awël nde Axwën, ja mërëxand këmëni yëlëra koɗi iram in ɓëxaỹënaxik ɓën. Awa, ar ƴamba këmo yo ɓakëlëbëd ɓanax këmo w̃aŝën.» ");
INSERT INTO bsc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yaka ko Yesu: «Awa doro fex kën wëj gë ekun edeƴ el. Wën ɓëte ɓërandëw̃ëra and Abëraxam hi kën. ");
INSERT INTO bsc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ocal od ɓër nemëk fëña ir Kaxanu ok ƴow këme wëno Asëñiw̃ ar ala an, mëni pexënaxën.» ");
INSERT INTO bsc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ga këno ɓaxët ɓër hi bax na ɓën, Yesu reƴa ko apënëtal aŋo, gayik anëka hi bani ɗam gër Yerusalem do ɓela ɓën bani yëland mëne yatijo dëŋ kë ŝanaya owun or Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ata re ko Yesu: «Mondako bax end ar rëw̃ bano në ekun ed ɓër gapak ga ƴe ko në ebar ed caw eno maŝëgu owun ol. ");
INSERT INTO bsc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","W̃ac këɓi ɓela epëxw gër ɓëriyenin ɓërexëm do yël këɓi ala kala kaŋe ir ɓon eni cënan ɗamana exo ɓakaw. ");
INSERT INTO bsc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ɓarikan ɓër angol amat gë mëŋ ɓën aŝus ŝus bano. Ata law̃ën kënëɓi ɓela eno pelëx aɓi ñandi ex na exo mun gër ebar edeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","And w̃aŝëgu këno owun aŋ, w̃aỹiw ko. W̃ac këɓi ɓëriyenin ɓër yël baɓi kaŋe ɓën eni nëkon ala kala ba yëgwe ŝënan ko. ");
INSERT INTO bsc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ata sëka ko aỹanar an re ko: “Axwën, wëno kaŋe ir yël baƴe in ɓakëlëbëd epëxw ŝënan këme.” ");
INSERT INTO bsc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ata yaka këŋo: “Yo ŝenene ex, wëj ariyenin ayekax hi këƴ. Tëkër fo bax er seɓënan bami in, do ga lëkayali këƴ ako aye, ar mokwëta hi këƴ. Wëj owun or ɓangol epëxw këƴ xwën.” ");
INSERT INTO bsc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sëka ko axinëm an, re ko: “Axwën, wëno kaŋe ir yël baƴe in ɓakëlëbëd ɓanjo ŝënan këme.” ");
INSERT INTO bsc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ata yaka këŋo: “Yo wëj kë xwën owun or ɓangol ɓanjo.” ");
INSERT INTO bsc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sëkaw ko ngwa, asasën an, re ko: “Axwën, kanal kaŋe ireƴ in, gë anjëm fel bame me mëxwëtaxën. ");
INSERT INTO bsc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ayëda yëda bame oxem oreƴ ol. Wëj er ɓayik aƴ kwën ex na in ayata këƴ yatand, do gër ed ɓayik aƴ tëw̃ ex na axana këƴ xanand ỹeỹ.” ");
INSERT INTO bsc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yaka këŋo: “Ata gë er re këƴ in fo këmi nëp, wëj xaɗëp ixwëlaraxik ijo! Ga nang baƴ ako mëne ala axemax hi këme, mëne er ɓayik ame kwën ex na in aw̃eɗ këme w̃eɗënd er ɓayik ame kwët ex na, axana këme xanand eneɗa end ɓayik ame neɗ bana eŋ? ");
INSERT INTO bsc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Inew̃a ɓayik aƴ mëla bana kaŋe iram in gër ɓër ŝënanëdox mëŋ xanati dome gë ỹeỹ?” ");
INSERT INTO bsc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ata fel këɓi ɓër hi bax na ɓën: “Kanino fa kaŋe ir lëkaya ko in, eno yël ar ŝënanëk ɓakëlëbëd epëxw an.” ");
INSERT INTO bsc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ata re këni ɓëjo: “Oko, axwën, mëŋ anëka ga ŝot ko wa mbaŋ kaŋe in!” ");
INSERT INTO bsc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yaka këɓi: “Ga re këme ar ŝot an, aɓaŝ këno ɓaŝ, ɓari ar ax cot ex na an, axan këno xan er xaỹ këŋo in dëŋ. ");
INSERT INTO bsc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Gërëgako, tërawënëɓi ɓërangoỹëra andam ɓën, ɓër xeƴ baɓi me mun ɓën. Ŋaŝinëɓi gër ed ỹëpa këme ro dëŋ!”» ");
INSERT INTO bsc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ga h̃ata ko apënëtal aŋ, Yesu lëngw ko ond ƴaŋ gër Yerusalem oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ɓëngol ɓënd bani w̃acënd Betëfage do gë Betani ebaxëna ler gër Yerusalem, gand etënd ed gë ɓañarëka. Ga ko h̃at Yesu, law̃ën këɓi ɓësëfan ɓëxi. ");
INSERT INTO bsc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Re ko: «Ƴeyin gër ingol ind gër lëngw. And kën h̃at aŋ, ata këno sëk mokap ipali ind elod ala aŋo ñëpaxën ex na. Pëtino eno mëlaw. ");
INSERT INTO bsc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Angëmëne ala w̃ëka këŋun ba ine këno fëtaxënënd, deyiɗën mëne Axwën Yesu rek momëlan.» ");
INSERT INTO bsc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɓër law̃ën baɓi ɓën ƴe këni do sëkëx këni ang fel baɓi Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ga këno fët ipali eŋ, ɓëxwën ɓën re këni: «Wën, inew̃a këno fëtaxënënd ipali iŋ?» ");
INSERT INTO bsc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yaka këni: «Axwën Yesu rek momëlan!» ");
INSERT INTO bsc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na wëlan këno ipali iŋ laɓëra këno gë ɓanjëm ɓandeɓën ɓaŋ. Yesu ỹëpa ko ƴaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ga ko ƴe ɓela ɓën këni rendërand ɓanjëm ɓandeɓën ɓaŋ tar fëña in. ");
INSERT INTO bsc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ga këni ŝëla etënd ed gë ɓañarëka el, këni sëkand angol and Yerusalem aŋ. Ɓësëfan ɓën do gë ɓela ɓër hi bax na ɓën këno ŝëkwand Kaxanu ŝor, gë onënga fo ga bani xwita ɗek ɓecarax ɓend wateli bano Yesu ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ata këni rend: «Yo anëka h̃atëgu ko emun eŋ, Ɓetalexo ar ƴowënd gër ow̃ac or Axwën Kaxanu an! Elod ƴaŋ gër orën w̃ëlanëgu këɓo aketëxeta aŋ. Do gë enjaran end Kaxanu eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ata ofariseŋ od wateli bax ok këno rend Yesu: «Asëƴali, kexëlëɓi ɓësëfan ɓëreƴ ɓën!» ");
INSERT INTO bsc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu yaka këɓi: «Ga re këme, ɓën eni ŝësinand yo, oxaỹ oŋ kë ỹana ex keỹënd!» ");
INSERT INTO bsc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ga ko h̃at gër Yerusalem wat ko angol aŋ; ata ỹana ko ko ỹawënd. ");
INSERT INTO bsc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Er baxo rend: «E wën Ɓëyerusalem ɓën, en nangëdo er w̃ëlanëgu këmun in, en nangëdo wa mëne oɓetak ex. Ɓari gërëgako an kor na eŋun pëni. ");
INSERT INTO bsc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gayikwa në eƴow ex ɓakey ɓand kënun xul ang okece fo ɓërangoỹëra andewën ɓën, do an korëɗ na enëɓi cana. ");
INSERT INTO bsc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wën Ɓëyerusalem ɓën, ɗek kënun law̃ëra. Ameŋ and gë oxaỹ anjëlëtërëx ax ɓayi na, ɗek këni yëcëra. Ɓeŋo ɗek këŋun h̃atënëgu gayikako an wata ex na amëd and nëngaw këŋun Kaxanu eŋun dëca aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ga h̃at ko Yesu gër Yerusalem, lil ko gër yangana ir Aciw̃ and Kaxanu. Ga sëk këɓi ɓela ɓër bax fanëndërand na ɓën, w̃aỹ këɓi do ko rend: ");
INSERT INTO bsc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","«Wën ba an wëlënd na nde er re ko Kaxanu gër akayëta andexëm in: “Aciw̃ andam aŋ and cale ex. Do wën nëngwët kën emaỹi ed ɓërek.”» ");
INSERT INTO bsc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mondako baɓi sëƴalirand ɓela ɓën key yo key gër yangana ir Aciw̃ and Kaxanu. Do ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëŝalen ɓën, gë ɓëxarëk ɓër Ɓëŝëwif ɓën aŝala bani ŝaland osit or eno ɗaw̃axën. ");
INSERT INTO bsc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ɓari ani nang bana mondake këno ri gayik ɓulunda in ɗek baɓi h̃axënënd gër oɓaxët. ");
INSERT INTO bsc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Akey amat, Yesu këɓi sëƴalind ɓulunda in do këɓi nangënënd Atëfëtan aŋ, gër Aciw̃ and Kaxanu. Ata h̃atëgu këni ɓëŝaɗaxan ɓëlëngw, gë ɓëŝalen do gë ɓëxarëk ɓër Ɓëŝëwif. ");
INSERT INTO bsc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","W̃ëka këno: «Pelëlëɓo fa ba gë or gapak or fe këƴëɓi sëƴalixënënd ɓela ɓën? Deƴal ba noɓën yël ki or gapak olo?» ");
INSERT INTO bsc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu yaka këɓi: «Wëno ɓëte emat fo këmun w̃ëka. ");
INSERT INTO bsc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Peline ba noỹo yël baŋo Ŝaŋ Batis or gapak or baɓi ɓuyixënënd ɓela ol? Ba Kaxanu nde ba ɓela ɓën nde?» ");
INSERT INTO bsc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɓarikan ɓën, nëkënëkar këni: «And këne yakaye mëne Kaxanu law̃ënëgu baŋo aŋ, ata ko re ine cëŋ ɓayik anëŋo kwëta exe na? ");
INSERT INTO bsc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ɓëte and këne yakaye mëne ɓela ɓën law̃ënëgu baŋo aŋ, ata ɓulunda in ɗek kënëɓo fëtëra xali enëɓo ɗaw̃ gayik aw̃a w̃a këni mëne Ŝaŋ Batis alaw̃ënel ar Kaxanu exo.» ");
INSERT INTO bsc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Awa yaka këno mëne ani nang ex na ba feye xaniw bax or gapak or Ŝaŋ Batis ol. ");
INSERT INTO bsc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ata Yesu re ko: «Wëno ɓëte amun pel na gë or gapak or fe këme rixënënd ɓeŋo.» ");
INSERT INTO bsc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ata ỹana ko ɓëte Yesu këɓi felënd ɓulunda in apënëtal aŋo: «Mondako ri baxo ar gë andëɗa and reseŋ. Ga xani ko ɗamana, seɓënan këɓi ɓëỹan eno cetërënd reseŋ in and kë sëg aŋ. Ata kwël ƴe ko në er caw do nëkaw ko xali. ");
INSERT INTO bsc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ga sëgëk reseŋ in, law̃ën këŋo ariyenin aɓat gër ɓëỹan eno yëlëgu oŝet orexëm ol gër er rëw̃ëk gër andëɗa and reseŋ. Ɓarikan ɓën sëra këno, fëmëra këno do ŝëñëta këno taxan. ");
INSERT INTO bsc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Axwën andëɗa an law̃ën këŋo ɓëte ariyenin aŝëxe. Ga h̃at ko, ŝirëra këno gë oteɓën seɓën këm, fëmëra këno do w̃aỹ këno taxan. ");
INSERT INTO bsc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Law̃ën këŋo ɓëte asasën. Sembaỹëndëra këno do w̃aỹ këno mëŋ ɓëte. ");
INSERT INTO bsc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ata re ko axwën andëɗa and reseŋ an: “E, do wëno mondake këme ri? Asëñiw̃ën ir pëlot gër yomb iram an fo këmo law̃ën. Ɓamat ɓëỹan ɓën afëɓ këno fëɓ mëŋ.” Ata law̃ën këŋo, ƴe ko. ");
INSERT INTO bsc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sam ga watëgu këno, ɓëỹan ɓën xetan këɓi: “Ajo ex ɗe ar kë ɓëteli andëɗa an, ɗaw̃ënëŋone eɓo ɓayixën.” ");
INSERT INTO bsc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ga h̃atëgu ko na, w̃ëlën këno, lap këno yaɓët kece in do law̃ëx këno.» Ga h̃ata ko Yesu apënëtal aŋo, w̃ëka këɓi: «Mondake wa yëla kën këɓi ri axwën andëɗa and reseŋ an ɓëỹan ɓëjo? ");
INSERT INTO bsc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ax gi ex na nde ata ko ƴow eɓi ɗaw̃ëra do eɓi teɓënan andëɗa and reseŋ aŋ ɓëỹan ɓëŝëxe?» Ata ɓër hi bax na ɓën ga wël këno, re këni: «Kar kar, kërex gi na mondako ɗe!» ");
INSERT INTO bsc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu faɓ këɓi do w̃ëka këɓi: «Gër akayëta and Kaxanu, afëni nde fëni këŋun oñëgw od rek: “Ekaỹ ed ŝus bani ɓëɓaƴ el, Hik ekëla ed gër ebaw̃ ed aciw̃ el? ");
INSERT INTO bsc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ar kë wëc gër ekaỹ elo an, exo gëbira. Do ar këŋo wëcan an eŋo tëka ɓëlëɓël.”» ");
INSERT INTO bsc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ga h̃ata ko Yesu eŋo, ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën ỹandi këɓi eno tëra kwël na fo, ɓarikan ɓulunda in banëɓi yëdand. Aye fëni baɓi mëne ɓën dëŋ baɓi rend gë apënëtal aŋo. ");
INSERT INTO bsc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën ỹana këni ocal od osit or eŋo ɓonaxën Yesu ok. Sana kënëɓi ɓela eno tëfërand ang ɓërëw̃ak endexëm fo, eno wëlelixën er këno lëxwaxën gër alëngw, gër or gapak or gofërëner. ");
INSERT INTO bsc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ga sëka këno Yesu, re këni: «Asëƴali, anang nang këmi mëne ŝenene fo këƴëɓi sëƴalind ɓela ɓën. Ado ala aƴo yëdand na, axi kolanënd na eƴo pel ɗal in ar er yo. Ŝenene fo këƴ sëƴalind er re ko Kaxanu in. ");
INSERT INTO bsc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ɓiyi, Sesar, emun etëm end gër Rom eŋ këmo yëlënd niy yo niy ŝagale in. Pelëlëɓo tan ba aỹap nde ỹapëk? Ba mi meɗënd nde ba mi teɓ nde?» ");
INSERT INTO bsc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ga wata ko Yesu osit oreɓën ol, yaka këɓi: «Mëlanëgune tan atama and koɗi.» ");
INSERT INTO bsc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ga fëxwën këno, w̃ëka këɓi: «Dëxas ir noỹo wa ex gër atama aŋo?» Yaka këni: «Ir Emun etëm end gër Rom ex!» «Do ow̃ac ol cëŋ?» Yaka këni: «Or Sesar.» ");
INSERT INTO bsc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ata re ko Yesu: «Awa maŝino Sesar er xwën ko in, do Kaxanu er erexëm in!» ");
INSERT INTO bsc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ata ɓën h̃axën këɓi na poyoma. Mo caran dëŋ ŝaran baɓi ang yaka baxo ak. ");
INSERT INTO bsc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Osaduseŋ ok bax rend mëne ekani ed gër ecës ax gi ex na. Akey amat, ƴow këni mar gër Yesu. W̃ëka këno: ");
INSERT INTO bsc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Asëƴali, Moyis ga ỹëgwën këɓo mëne and ko ŝës asoŝan do eŋo teɓëta alindaw̃ gë itox këm, aɓinëm këŋo ɓëteli. Oɓaŝ or kënëɓi rëw̃ ol, ar ŝësëk an këɓi xwën. ");
INSERT INTO bsc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Awa ɓiyi ỹeỹ wëlan këɓo na. Ocambenjar ocongoki ebax aminëmëra. Iỹanar in ỹër ko, ŝës ko gë oɓaŝ këm. ");
INSERT INTO bsc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ata ɓëteli këŋo ixinëm in asoxari an. ");
INSERT INTO bsc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mondako ŝësëra këni ɓën ɓëcongëɓëxi ɓën ɗek ado gaɓatak aŋo cotën ex na itox. ");
INSERT INTO bsc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ata ŝës ko ɓëte asoxari an. ");
INSERT INTO bsc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gërëgako, yatir ekani ed ɓëŝësëk, alindaw̃ ar noỹo wa ko hi gayikako ɓën ɗek ɓëcongëɓëxi ɓën aỹër ỹër bano?» ");
INSERT INTO bsc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu yaka këɓi: «Gër ebar ro fo ex eñër el. ");
INSERT INTO bsc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ɓarikan, and këni xanira ɓela gër ecës aŋ, ɓër këɓi sana Kaxanu gër aniyan and kë ƴowënd ɓën, ani ñërër na. ");
INSERT INTO bsc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɓëtëdin ani cës na gayik ata këni hi ang omeleka fo. Oɓaŝ or Kaxanu këni hi and këni xani gër ecës aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Enimin, ekani ed gër ecës exëna. Mëŋ w̃acayaxën baxo Axwën an yatir ŝanayaxën baŋo Moyis gër acëc and gë xoɗux: Kaxanu ir Abëraxam, gë ir Isak do gë ir Yakob. ");
INSERT INTO bsc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gër ogës od Kaxanu ado exo cës ala an aɓëngw exo. Mëŋ aɓi kwënënd na ɓëŝësëk.» ");
INSERT INTO bsc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɓëŝalen ɓër hi bax na ɓën, ga wël këno Yesu, re këni: «Asëƴali, ata ŝenene dëŋ yaka këƴ!» ");
INSERT INTO bsc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ata elod yatijo, ala bax yëxw na eŋo mëka ỹeỹ Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu w̃ëka këɓi ɓëte ɓëŝalen ɓëjo: «Mondake wa këni rexënënd ɓela ɓën mëne Afexën an, ejiw̃ ed Dafid ko hi? ");
INSERT INTO bsc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ax gi ex na Dafid dëŋ ỹëgwëk gër akayëta and Calemoñëw̃: “Axwën Kaxanu fel këŋo Axwën aram an: Ƴow eƴ ñëpa ro gand liw̃ iram, ");
INSERT INTO bsc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","xali mëni nëmbëta ɓërangoỹëra andeƴ ɓën eni gi ambëñaxën andeƴ.” ");
INSERT INTO bsc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dafid mëŋ dëŋ ke w̃acënd Axwën arexëm do mondake cëŋ hi këme Asëñiw̃?» ");
INSERT INTO bsc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ga këno ɓaxët ɗek amëxwër aŋ, fel këɓi ɓësëfan ɓën: ");
INSERT INTO bsc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Titinaliyëndënëɓi ɓëŝalen ɓën; ɓën mbaŋ këɓi nënganënd eni ƴexërand gë ɓocuɗ ɓond gëŝëc ɓoŋ, do ɓela ɓën enëɓi cëmarand gër ɓapedëraya. Mbaŋ h̃an këni ɓañëpara ɓand gër lëngw ɓaŋ gër ɓaciw̃ ɓacaleya. Gër ed kë hi ñambëran mbaŋ h̃an këni eketëna ed axwën ofëna el. ");
INSERT INTO bsc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mondako wata këni aŝale aŝale xarak ɓën këɓi lëxëlëxënd ɓësoxari ɓëseɓëta seɓëta ɓën xali gë ɓëciw̃ ak. Mëŋ ex kiti indeɓën iŋ gë pit fo kë ƴëka.» ");
INSERT INTO bsc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ata ga rënëta ko Yesu, wat këɓi ɓër gë napul ɓën ga këni xwët koɗi in gër akwëtaya and oyël gër yangana ir Aciw̃ and Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","H̃atëgu ko asoxari aseɓëta seɓëta, axaỹënaxik. Xwët ko ɓëtama ɓëki ɓënd koɗi. ");
INSERT INTO bsc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu, ga wat këŋo, re ko: «Ɗal in këmun felënd, asoxari aseɓëta seɓëta, axaỹënaxik ajo, xwëtëk nëmëc. ");
INSERT INTO bsc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gayikwa ɓër gë napul ɓëjo, ocandën ok fo w̃ëlaw këni oyël ol, ɓari asoxari ajo, er ko liyaxënënd in w̃ëlaw ko, ado ga xaỹën ko.» ");
INSERT INTO bsc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ata ɓërëmar këni ŝëkwënd Aciw̃ and Kaxanu aŋ. Gë oxaỹ oyekax ɓaƴ bani do ỹaŋën bani gë ɓeɓër w̃ëlaraw bani ɓela gër oyël or Kaxanu ɓën. Ata re ko Yesu: ");
INSERT INTO bsc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Në eƴow ex ɓakey ɓand ax ɓayi na ɓeỹ ɓën ang kën watënd ak. Ekaỹ eyëlëtërëx ax ɓayi na, ɗek kë yëcar.» ");
INSERT INTO bsc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na w̃ëka këno ɓësëfan ɓën: «Asëƴali, nand fe wa kë yëcar Aciw̃ and Kaxanu aŋ? Mondake këmi nangëɗ mëne anëka kë h̃atëgund ɓeŋo? Amatinali nde exëna?» ");
INSERT INTO bsc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yaka këɓi Yesu: «Titinayin, ala këreŋun yifaɗ na. Ɓëranjëm kë ƴow, aɓat aɓat, gë ow̃ac oram ol eni dend: “Wëno ex Afexën an, do anëka saxëguk ekwët ed ngwën el”, Kërenëɓi tëfëɗ na. ");
INSERT INTO bsc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","And kën wël anëka wonjok aniyan aŋ do në emerëra exëni ɓela ɓën, këreŋun yëɓuɗ na gayik afo ex ŋatëgu ɓeŋo. Ɓari ax giɗ na pere ekwët ed ngwën el.» ");
INSERT INTO bsc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Re ko ɓëte Yesu: «Er këni ỹana eni merërand ɓela ɓën, gë enëng gë enëng, do gë ebar gë ebar. ");
INSERT INTO bsc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɓëte ɓangëm-gëm këɓi ỹana eɓi ɗaw̃ërand ɓela ɓën do në ed mar ocëxwëra otëm do gë enjo. Gër orën, aŝanaya kë ỹana ex canayarand ɓeñigënaxik do ɓecarax ɓetëm eni nangaxën ɓela ɓën mëne ɗam ex ekwët ed ngwën el. ");
INSERT INTO bsc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ɓarikan, ɗamana ex ŋatëgu ɓeŋo ɗek, ɓela ɓën axëmëra kënun ỹana enun këmërand do enun narëndërand wën ɓër w̃ak endam ɓën. Ɓëŝëwif ɓën alëxw kënun ỹana enun ɗëxwënd gër ɓaciw̃ ɓacaleya ɓandeɓën, do enun përand. Aw̃ëla kënun ỹana enun mëland gër ɓemun ɓetëm do gër ɓëlëngw në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mondako kën ỹana en deƴaraxënënd osede oram ol. ");
INSERT INTO bsc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Këren yëlarand na gana-gana fo ang kën ỹana en yakand ak. ");
INSERT INTO bsc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wëno këŋun ỹana eŋun yëlënɗ orenik or enëɓi ɓonaxënënd ɗek ɓërangoỹëra andewën ol. ");
INSERT INTO bsc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ɓëxarëk ɓërewën, ɓëmaỹe ɓëndewën, ɓëcandaw̃ ɓëndewën, do gë oɗawo odewën dëŋ këŋun ỹana eŋun ɗëxwënd në end ow̃ac oram, do ang hi kën ak, ɓëranjëm enëɓi ɗaw̃ëra. ");
INSERT INTO bsc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓela ɗek këŋun ŝus në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ɓari ỹow̃eỹ ani koran na ɓenjëw̃ ɓendewën ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ga ɓuŋa ɓuŋa kën, ɓenjëw̃ ɓendewën ɓeŋ kë fex.» ");
INSERT INTO bsc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«And kën wat ga xul këni ocoroɗa Yerusalem aŋ, nangin mëne eyëcar ed angol el h̃atëguk. ");
INSERT INTO bsc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ata ɓër gër ebar ed Yude ɓën gërëxëɗëlexëni gand osënd. Ɓër gër angol and Yerusalem ɓën canëxëɗëlexëni do ɓër gër ocënga ɓën këreni maỹiɗ na gër angol. ");
INSERT INTO bsc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ɓakey ɓand toro ɓand kë h̃atëgu baŋo, kiti ind këɓi xiti Kaxanu ɓela iŋ kë hiɗ ang ỹëgw këni gër akayëta andexëm ak. ");
INSERT INTO bsc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gë ɓakey ɓaŋo, mocopara këɓi ŝopara ɓësoxari ɓër gë ɓacël ɓën do gë ɓër këɓi yerinënd oɓaŝ ɓën. Oxoỹ or Kaxanu ol këɓi wëcan Ɓëyisërayel ɓën do eni toro mbaŋ gër ebar edeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓërëmar enëɓi ɗaw̃ëra gë duxuma, ɓëjo enëɓi capëreli oxaɗëp gër ɗek ɓenëng ɓecëxe. Ata ɓenëng ɓeŋo eni bëñëra Yerusalem in xali ex kwët amëd and këɓi seɓën Kaxanu aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ɓecërëcaxik kë ŝanaya na gër eñan, gër facaw̃ do gër ow̃al. Do gër ebar, ɓenëng ɓend ɓela ɓeŋ eni yëdara xali eɓi bëlandëra sam eni wëlënd ongëɓër ond men ond angwëngw oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ayëdara këni ỹana eni yëdarand ɓela ɓën xali eni takëndërand gër oŝën or etëm end kë h̃atëgu gër ebar ed lëgëra këni el. Gayikwa ɓeɓër gë panga gër orën ɓën kë sëngërëɓëtara. ");
INSERT INTO bsc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ata këne watëgu wëno Asëñiw̃ ar ala an ga këme ŝëlaw gë aŋar aŋ. Do mbaŋ kë ŝanaya panga iŋ do gë enjaran endam eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Awa and kë ỹana eŋatëgu ɓeŋo aŋ, dëngwëtayin do dënëtayin gayik apexa andewën aŋ ɗam ex.» ");
INSERT INTO bsc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu fel këɓi ɓëte apënëtal aŋo: «Nëkoyin andan aŋ do gë ɗek ɓatëx ɓacëxe ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","And kën wat ga nëtërak aŋ aye kën nangënd mëne ecaŝa el ɗam ex. ");
INSERT INTO bsc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ɓëte mondako fo ex, and kën wat ɓecarax ɓetëm gër ngwën ro aŋ, nangindën mëne owun or Kaxanu ol ɗam ex. ");
INSERT INTO bsc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ɗal in këmun felënd, ani cësëra na ɗek ɓela ɓër gë okey oko ɓën ŋatëgurëxe ɓeŋo ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Orën ol gë ebar el axuca kë xuca. Ɓarikan eyeƴan edam el ed din ex. ");
INSERT INTO bsc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Titinayin këren kwënda na ñambëran, gë oŝeɓ, gë odendëran od aniyan, këdi kë siɓ ow̃ëkw orewën oŋ do en nambina, do eŋun pënga akey aŋo. ");
INSERT INTO bsc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Titinayin këdi këŋun h̃atënëgu bërëxaɗët akey aŋo. Gayikwa ang ebën ed oxan fo këɓi xul ɓela ɓën ɗek ebar el. ");
INSERT INTO bsc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Caleyindën key yo key do këren nambinand na ado tëkër ak, en koraxën en cana ɗek er këŋun ƴowënëgund in. Mondako kën hixën ɓëw̃elëk and këme h̃atëgu wëno Asëñiw̃ ar ala an.» ");
INSERT INTO bsc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Goyat baɓi sëƴalirand Yesu ɓela ɓën gër Aciw̃ and Kaxanu do genëka exo maỹi gër etënd ed gë ɓañarëka. ");
INSERT INTO bsc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mopëɗ gëɓër, ɓulunda in ɗek bani ƴend gër Aciw̃ and Kaxanu eno ɓaxët. ");
INSERT INTO bsc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ofëna or mburu ind gë lewir këm, or këni w̃acënd Ofëna or Apexa ol, bax h̃atëgund. ");
INSERT INTO bsc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ata ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën këni ŝaland eno ɗaw̃ yir fo Yesu gayikwa ayëda banëɓi yëdand ɓulunda in. ");
INSERT INTO bsc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ang ebani ɓësëfan ɓër Yesu ɓën epëxw gë ɓëxi ak, aɓat bano w̃acënd Yuda Isëkariyot. Ga lil ko Sindan in gër emëkw ed asëfan ajo ");
INSERT INTO bsc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","xani ko xwiriŝ, ƴe ko gër ed ɓarër bani ɓëŝaɗaxan ɓëlëngw ɓën, do gë ɓemun ɓend ɓënëkona ɓër Aciw̃ and Kaxanu, eni wëlërëx ang ko ri eɓi tëranaxën Yesu ak. ");
INSERT INTO bsc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ga këɓi nëngandëra, xet këɓi eno yël koɗi. ");
INSERT INTO bsc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda ga xana ko, ko ŝaland nand kë ỹap eŋo tëra Yesu xarak amëxwër aŋ ani nang ex na. ");
INSERT INTO bsc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Akey añanar and loxo ir bani ƴamb mburu ind gë lewir këm aŋ ebax. Yatijo banëɓi ŝaɗaxand opeỹ od Ofëna or Apexa ok! ");
INSERT INTO bsc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ata Yesu ga law̃ën këɓi Piyer gë Ŝaŋ, re ko: «Doro ex Ofëna or Apexa ol! Ƴeyin en cemërax ene ƴambëraye.» ");
INSERT INTO bsc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","W̃ëka këno: «Feye wa ỹandi ki mi cemërax?» ");
INSERT INTO bsc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu yaka këɓi: «And kën h̃at gër angol aŋ, ata kën fed gë ala ar lëɓinak epeƴa ed gë men. Tëfiɗëno xali gër iciw̃ ind ko lil. ");
INSERT INTO bsc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Peliɗëno axwën iciw̃ an: “Axwën an ga re ko ba feye ex aciw̃ and gër ed këmi ƴambëra ecemar ed ofëna or Apexa el wëno gë ɓësëfan ɓëram ɓën?” ");
INSERT INTO bsc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aw̃asin këŋun w̃asinëɗ aciw̃ and ƴaŋ and gë ɓeỹ ɗek. Fën kën ŝemërax ed ofëna el.» ");
INSERT INTO bsc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ata Piyer gë Ŝaŋ ƴe këni, sëkëx këni ɓeỹ ɓën ang fel baɓi ak do ŝemërax këni ecemar ed Ofëna or Apexa ol. ");
INSERT INTO bsc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ga h̃atëk apëxëd aŋ, Yesu gë oparëxanda odexëm ok ỹëpara këni gër eƴambëran. ");
INSERT INTO bsc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ata re ko Yesu: «Awël nde, mbaŋ ỹandi baxe ene ƴambëraye andamat ecemar ed Ofëna or Apexa el, ɗamana me toroxën. ");
INSERT INTO bsc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ga re këme, doro këme feland ecemar ed ofëna ar Apexa el xali yatir këne ƴambëraxëye gër owun or Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ga yeƴan ko na mondako, w̃eɗ ko andëmba and gë ngoƴ aŋ. Ŝëkwa këŋo Kaxanu do re ko: «Kanayin ngoƴ iŋo en yëlar wën ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ga re këme, doro fela këme ngoƴ iŋ xali yatir kë h̃atëgu owun or Kaxanu ol.» ");
INSERT INTO bsc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɓëte w̃eɗ ko ŋat amburu amat, ga ŝëkwa këŋo Kaxanu, hëbëndër ko do ŝet këɓi ɓësëfan ɓën. Re ko: «Mburu iŋo ex eman endam end yël këŋun Kaxanu eŋ! Cetërindën ene kwitaxën.» ");
INSERT INTO bsc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","And faỹ këni eƴambëran aŋ, w̃eɗ ko ɓëte ŋat andëmba and gë ngoƴ aŋ, ga yël këɓi eni yëlar, re ko: «Ngoƴ iŋo ex oŝat oram or kë ŝar en cotaxën eter ekaŝax ed gë Kaxanu oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Xarak, ar ke lëxw an gër ed këne ƴambërande ro dëŋ exo! ");
INSERT INTO bsc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Eyo, wëno Asëñiw̃ ar ala an alaw̃ këne law̃ ang ỹëgw këni ak. Ɓarikan kata itëm hi këŋo ar ke lëxw an.» ");
INSERT INTO bsc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ata ɓësëfan ɓën ỹana këni emëkar el ba noỹo ex ar këŋo lëxw Yesu an. ");
INSERT INTO bsc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ga xucak eŋo, ɓësëfan ɓën këni ŝampërend end ba noỹo ex asëfan alëngw eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ata re ko Yesu: «Ɓemun ɓend ɓër ɓenëng ɓecëxe ɓeŋ awëña kënëɓi wëñand ɓela ɓër ex gër owar oreɓën ɓën, do ɓër gapak ɓën are kënëɓi rend “Ɓëyekax exëni”. ");
INSERT INTO bsc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kërex gi na ɗe mondako gër ndewën. Ar gapak an, gilexo ang itox fo. Do alëngw an, diyenindëlexo ang xaɗëp fo. ");
INSERT INTO bsc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Do noỹo wa ex ar gapak an? Ar ỹëpak do këno lëɓand an nde, ba alëɓa an nde? Ax gi ex na nde ar këno rëtënënd an ex ar gapak an? Do wëno cëŋ, ax gi ex na nde ang xaɗëp fo hi këme mërëxand irewën? ");
INSERT INTO bsc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wën xemënak xali doro, ane nacëta ex na gër ocëmu odam. ");
INSERT INTO bsc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mëŋ ex, ang yël ke Faba ");
INSERT INTO bsc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","mëŋ këne ƴambëraxëɗe do ene ceɓëraxëɗe andamat gër owun oram do në ɓañëpara ɓand owun këne xetënaɗ enëɓe kitixëne ɓenëng epëxw gë ɓeki ɓend ɓulunda ir Isërayel ɓeŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ga xucak eŋo, Yesu w̃ac këŋo Piyer: «Simoŋ, Simoŋ, anëka ỹandi këŋo ɗe Sindan eŋun kaɓasa ang bële fo. ");
INSERT INTO bsc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ɓarikan wëno aŝalen ŝalen këmi exi ɓayixën ekwëta ed xwëta këƴe el, kërex capër na ɗek ɗek. Do wëj and këƴ ɓakawëɗ aŋ, kemëniɗëɓi ɓoɓinëx.» ");
INSERT INTO bsc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ata re ko Piyer: «Axwën, wëno aw̃elëk hi këme mi tëf xali lëf gër epëra do xali gër ecës.» ");
INSERT INTO bsc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu yaka këŋo: «Piyer, ga re këme, doro ɗamana exo yata ecare el wëj anëka këƴ ƴaxëta ɓakëlëbëd ɓatas.» ");
INSERT INTO bsc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ga xucak eŋo, Yesu w̃ëka këɓi ɓësëfan ɓën: «And law̃ën bamun en pemëra Atëfëtan aŋ, koɗi këm, ambaɓ këm, ɓapeɗ këm ỹeỹ nde ŝanëx ban na?» Yaka këni: «Ɓëtëdëŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aŋo re ko: «Gërëgako, ar gë koɗi an, cëlayalexo, ar gë ambaɓ an, ɓaxalexo, do ar gë duxuma këm an panëlexo acuɗ andexëm aŋ exo yëcaxën. ");
INSERT INTO bsc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gayikwa afo ex ŋata endam end ỹëgw këni eŋ: “Gë ɓëw̃endëran ɓën ɓar këneɓi enga emat.” Do enimin, er ebax exe gi in në eŋata ex.» ");
INSERT INTO bsc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ata re këni ɓësëfan ɓën: «Axwën, nëkoɗa oduxuma oki.» Yaka këɓi: «Gwac ex go!» ");
INSERT INTO bsc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ga ŝanëgu ko Yesu na gër ed hi bani, ƴe ko ang w̃ër baŋo ak gër etënd ed gë ɓañarëka, ata sëf këno ñët ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ga h̃at këni, fel këɓi: «Caleyin këdi këŋun xor eñëŋënax eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mëŋ ga nacëta këɓi, foxi ko do ko ŝalend: ");
INSERT INTO bsc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Faba, ga ỹandi ỹandi ki pangacënële kata iŋo. Dil ang ỹandi ki wëj ak, kërex gi na ang ỹandi ke wëno ak.» ");
INSERT INTO bsc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ata ŝanayaxënëgu këŋo meleka elod gër orën do ɓaŝën këŋo ojaw̃ ok. ");
INSERT INTO bsc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ga ŝaminak emëkw edexëm el, Yesu xemëna ko nëmëc cale iŋ. Asëw̃ëtëw̃a irexëm in hik ang oŝat fo do kë ŝarënd gër ebar. ");
INSERT INTO bsc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","And foxita ko cale aŋ, ɓaka ko gër ɓësëfan. Sëk këɓi ga raŝëra këɓi ga ɓon këɓi ocëmu ok. ");
INSERT INTO bsc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ata w̃ëka këɓi: «Wën inew̃a këŋun raŝëraxënënd? Kanin en cale, en kwëỹëtaxën eñëŋënax eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ga ko yeƴan ɓayi baxo Yesu ga h̃atëgu këni na enga end ɓela. Ar bano w̃acënd Yuda an, asëfan aɓat ang ebani epëxw gë ɓëxi ak, lëngwënëgu bax. Ga sëkar këni gë Yesu, w̃ega këŋo bëxiɓ. ");
INSERT INTO bsc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ata re ko Yesu: «Oko Yuda, momega nde këƴe lëxwënd wëno Asëñiw̃ ar ala an?» ");
INSERT INTO bsc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ga wat këni er bax h̃atëgund in, ɓësëfan ɓën re këni: «Axwën mëni taw̃ëra nde gë duxuma in?» ");
INSERT INTO bsc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ata aɓat w̃ëlën këɓi, saw̃ këŋo xaɗëp ir aŝaɗaxan alëngw in baɗ anëf and liw̃ aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ɓarikan Yesu re ko: «Teɓin, gwac ex!» Na ga lëk këŋo asoŝan ajo gër anëf, fakën këŋo. ");
INSERT INTO bsc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ata Yesu w̃ëka këɓi ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓemun ɓend ɓënëkona ɓër Aciw̃ and Kaxanu ɓeŋ do gë ɓëxarëk ɓër Ɓëŝëwif ɓën: «Ba arek nde hi këme mëŋ ƴowaxënëgu kën gë oduxuma do gë okwëlekwële ene tëraxën? ");
INSERT INTO bsc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Key yo key ga bane fedërënde wa gër Aciw̃ and Kaxanu do ane tëra bana? Ɓarikan, anëka h̃atëguk apëxëd andewën aŋ do gë and panga ind ecamëɗan aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","And sëra këno Yesu aŋ, w̃ëla këno monas xali gër yangana ir iciw̃ ind aŝaɗaxan alëngw, ata Piyer këɓi sëfëgund nacët ako. ");
INSERT INTO bsc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ga fëtën këni xoɗux mërëxand ir yangana, ỹëpara këni jeƴ gër oyesa do Piyer xetëna këɓi moñëpa. ");
INSERT INTO bsc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ata endënaw̃ emat wat këŋo and h̃oɓa këŋo xoɗux aŋ. Ga faɓ këŋo, re ko: «Ajo gë ar sëra këno ajo ebani.» ");
INSERT INTO bsc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ɓarikan Piyer ga ko ƴax ko rend: «Aɓiw̃ën, wëno amo nang ex na ɗe!» ");
INSERT INTO bsc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ga nëkanak, ala aŝëxe xwita këŋo Piyer do re ko: «Wëj ɓëte ar enga end ar sëra këno ajo hi këƴ ɗe!» Yaka këŋo: «Wëno ame gi ex na ɗe gër enga eŋo!» ");
INSERT INTO bsc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɓëte ga xucak apëxëd amat, ala aŝëxe ko rend: «Enimin, gayikako asoŝan ajo Agalile ex, gë mëŋ ebani.» ");
INSERT INTO bsc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aŋo re ko Piyer: «Wëj er këƴ rend ijo, wëno ame nang ex na!» Ata yata ko ecare el. ");
INSERT INTO bsc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Axwën Yesu nëkona ko gand Piyer, ga faɓër këni, Piyer xwita ko afel fel baŋo mëne doro ɗamana exo yata ecare el, anëka këŋo ƴaxëta ɓakëlëbëd ɓatas. ");
INSERT INTO bsc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyer ŝan ko kwël do ko sesëxënd ga fulët këŋo otes. ");
INSERT INTO bsc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ata ɓër sëra baŋo Yesu ɓën këno lëŝërand do këno xëmërand. ");
INSERT INTO bsc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓandëmar eni pëɗ ɓangës ɓaŋ eno këm do eno mëka: «Wëj alaw̃ënel ar Kaxanu an, nangënëlëɓo ngwa ba noỹo xëm ki!» ");
INSERT INTO bsc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mondako bano ŝirërand gë oteɓën seɓën këm. ");
INSERT INTO bsc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ga wecak, amara and ɓëxarëk ɓër Ɓëŝëwif aŋ, gë ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën w̃ëla këno Yesu gër akwëndaya andeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ata w̃ëka këno: «Angëmëne wëj ex Afexën an, pelëlëɓo!» Yesu yaka këɓi: «And këmun fel aŋ, ane ma na, ");
INSERT INTO bsc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ɓëte and këmun w̃ëka aŋ, ane yaka na. ");
INSERT INTO bsc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Elod gërëgako, nangin mëne awat këne wat wëno Asëñiw̃ ar ala an ga xetëna këmo Kaxanu gand liw̃, gër owun orexëm.» ");
INSERT INTO bsc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ata xeỹ këni ŝor: «Ba wëj nde ex Asëñiw̃ ar Kaxanu an?» Yaka këɓi: «Go dëŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ata re këni ɓëte: «Osede ax bo ex na ene wële. Ax gi ex na nde ɓiyi ɗek dëŋ wël kënëŋone?» ");
INSERT INTO bsc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëŝalen ɓën do gë ɓëxarëk ɓër Ɓëŝëwif ɓën xani këni ɓën ɗek do w̃ëla këŋo Yesu gër Pilat. ");
INSERT INTO bsc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ga këno nagaŝandëra këni rend: «Ɓiyi fënga këŋo ala ajo ga këɓi ŝoñ ɓër enëng endeɓi ɓën eni teɓ emeɗën ed ŝagale owun or Sesar el. Ɓëte gë andexëm ko w̃acayand Afexën do emun endeɓi.» ");
INSERT INTO bsc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ata Pilat w̃ëka këŋo Yesu: «Wëj nde ex emun end Ɓëŝëwif eŋ?» Yesu yaka ko: «Wëj w̃ac ke ɗe mondako!» ");
INSERT INTO bsc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat fel këɓi ɓëŝaɗaxan ɓëlëngw ɓën do gë ɗek amëxwër aŋ: «Wëno amena and këmo nëpaxën ala ajo ame wat ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ɓarikan ɓën ga xemëna këni, këni rend: «Aŝoñ këɓi ŝoñënd ɓela ɓën eni ŋëp owun orewën ol, ɗek ebar ed Yude el këɓi sëƴalind mondako ga ỹanaw ko gër ed Galile, xali gër Yerusalem ro.» ");
INSERT INTO bsc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","And wël ko eŋo aŋ, Pilat w̃ëka këɓi ba Yesu Agalile exo. Yaka këno mëne go dëŋ ex. ");
INSERT INTO bsc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilat ga wata ko mëne Yesu ar gër owun or Erod, emun end gër ebar ed Galile eŋ, hi ko fel këɓi eno mëlan gayik ɓakey ɓaŋo na gër Yerusalem ƴow baxo. ");
INSERT INTO bsc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erod nëngandëra këŋo and wat këŋo Yesu aŋ. Enimin, elod anëka fo ỹandi baŋo eŋo nang gayik awël baxo wëlënd ɓend ko rind ɓeŋ do ayar baxo yarënd eŋo wat ga ko ri ecarax. ");
INSERT INTO bsc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ata Erod w̃ëkara këŋo xali Yesu, ɓari gematak aŋo yaka bana. ");
INSERT INTO bsc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓëŝalen ɓën xemëna këni këno nagaŝandërand Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erod gë ɓënëkona ɓërexëm ɓën rixëra këno eŋo ƴepënaxën. Erod, and lëŝëra këŋo xali fed këŋo aŋ, ŝuɗ këŋo ocuɗ ombarax ang emun fo. And fed këŋo aŋ, ŝëñëta këɓi eno ɓakali gër Pilat. ");
INSERT INTO bsc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yatijo hi bani oɗawo Erod do gë Pilat, xarak ɓërangoỹëra ebani. ");
INSERT INTO bsc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ga h̃ateli këno Yesu, Pilat w̃ac këɓi ɓëŝaɗaxan ɓëlëngw ɓën, gë ɓëxarëk ɓën do gë ɓër hi bax na ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Re ko: «Wën w̃ëlanëgu ke ala ajo do re kën mëne mëŋ këɓi ŝoñënd ɓulunda in. Ax gi ex na nde ogës odewën dëŋ w̃ëkara këmo? Wëno cëŋ amo kor na monëp gë ɓend nagaŝandëra këno wën ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ɓëte Erod dëŋ aŋo korëguw ex na eŋo nëp mëŋ ɓakalixënëgu këŋo gër ndam ro. Amena ax gi ex na and këmo law̃axën. ");
INSERT INTO bsc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ocoroɗa odam ok këmëni seɓën eno cew̃ëra do moteɓët.» ");
INSERT INTO bsc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ata na xeỹ këni ŝor: «Teɓëtëlo Barabas! Teɓëtëlo Barabas do eƴo ɗaw̃ ajo!» ");
INSERT INTO bsc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Xarak Barabas ijo andepëra hi baxo gayik axoỹën xoỹën banëɓi mëŋ gë ɓoŝandaw̃ ɓëlëngw ɓër angol ɓën do w̃ereli banëɓi xali law̃ këno ala. ");
INSERT INTO bsc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat w̃ëka këɓi gaŝëxe ba noỹo sana këno eŋo, xarak mëŋ Yesu ỹandi baŋo eŋo teɓët. ");
INSERT INTO bsc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ata yaka këni ŝor: «Ali, pikalo gër kërëwa! Pikalo gër kërëwa!» ");
INSERT INTO bsc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","W̃ëka këɓi ɓëte atasën aŋ: «Inew̃a w̃en ko? Ga re këme amena amo wateli ex na and këmo law̃axën. Aseɓët këmo seɓët and këno ŝew̃ëra ocoroɗa aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aŋo xeỹ këni kaŝ-kaŝ mëne eŋo pika. ");
INSERT INTO bsc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ata Pilat w̃a ko ex gi ang w̃ëka bani ak. ");
INSERT INTO bsc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilat seɓët këŋo Barabas, ar fëra bano gayik ala law̃ baŋo yatir xanin bani emer gër angol an. End Yesu eŋ cëŋ, seɓ këɓi ocoroɗa ok eno dixëra ang ỹandi këɓi ak. ");
INSERT INTO bsc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ocoroɗa ok ga këno w̃ëla Yesu gër ed këno fikax, fed këni gë Simoŋ Iɓësiren ga hiw ko gër oŝënga. Ga nëỹali këno, lapara ko osëx or këno fikaxën Yesu ol do këŋo sëfand Yesu gë andepoƴ. ");
INSERT INTO bsc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ata enga end ɓela kënëɓi sëfand. Ɓësoxari ɓën ga këno ỹaw̃ Yesu këni renitand. ");
INSERT INTO bsc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu and nëkona këɓi aŋ, re ko: «Wën ɓësoxari Ɓëyerusalem, tesin endewën eŋ do gë end oɓaŝ orewën eŋ, kërene ñaw̃ na wëno! ");
INSERT INTO bsc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Në eƴow ex ɓakey ɓand kën ỹana end dend: “Nëngandëraleɓi ɓësoxari ɓëɓoroxok ɓën, ɓër elod ani dëw̃ ex na do elod ano yerin ex na itox ɓën!” ");
INSERT INTO bsc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Amëd aŋo, ɓela ɓën are këni ỹana eni dend: “Osënd wëcaninëɓo! Ɓëtënd wëginëɓo!” ");
INSERT INTO bsc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ga këne narënënd ako wëno ar ex osëx oŝëkët an, kaŝ kënun narëndëra wën ɓër ex otëx oŋaỹëk ɓën.» ");
INSERT INTO bsc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yatijo, ɓërek ɓëxi banëɓi w̃ëlalind gë Yesu enëɓi ɗaw̃ëx. ");
INSERT INTO bsc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","And h̃at këni gër ed bani w̃acënd «Egor» aŋ, fika këno Yesu mërëxand ir ɓërek ɓëxi: aɓat gand liw̃, ajo gand ŝame. ");
INSERT INTO bsc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ata Yesu ko rend: «Faba teɓanëlëɓi, gayikwa ani nang ex na er këni rind in.» Ocoroɗa ok ri këni ɓëñak eni cetëraxën ɓanjëm ɓandexëm ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓulunda ir Ɓëŝëwif in xwëŝaraw këni ler na do kënëɓi nëkonënd. Ɓarikan ɓëlëngw ɓën ga këno lëŝ Yesu këni rend: «Ga baɓi fexën wa ɓeŝëxen ɓën, pexënayalexo gë andexëm dëŋ angëmëne mëŋ ex ar yata këŋo Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Alëŝ bano lëŝënd ɓëte ocoroɗa ok; and këno sëka aŋ, eno nën ngoƴ iŋerëk ");
INSERT INTO bsc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","do eni dend: «Angëmëne wëj ex emun end Ɓëŝëwif eŋ, pexënayal gë andeƴ dëŋ!» ");
INSERT INTO bsc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oñëgw fikali bani na në ingomb gomb yaɓët gaf irexëm in mondako: «Ajo ro ex emun end Ɓëŝëwif eŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ata arek aɓat gër ɓër fika banëɓi gë Yesu këŋo ŝirënd: «Ax gi ex na nde wëj ex Afexën an? Pexënayal gë andeƴ eƴëɓo pexënaxën ɓiyi ɓëte!» ");
INSERT INTO bsc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɓarikan arek axinëm an këŋo xexënd mondako: «E wëj ba aƴo yëdand na nde Kaxanu? Ax gi ex na nde andamat nëp kënëɓo? ");
INSERT INTO bsc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ɓiyi cëŋ, er hi këɓo ijo ŝenene ex, gayikwa oxeỹ oreɓi fo ɓakaxënënd. Ɓarikan mëŋ ỹoweỹ axo men ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ata re ko ɓëte: «Yesu, këla, kwitayi ɗe axwita wëno yatir këƴ ɓakaw gër ngwën gë owun oreƴ ol.» ");
INSERT INTO bsc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yaka këŋo: «Awël nde, ɗal in këmi felënd, doro dëŋ wëj gë wëno ah̃at ke h̃ate gër araƴen.» ");
INSERT INTO bsc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Anëka bax h̃atënd eñan eŋ keŋ gër gaf ga ŝamëɗanëk ɗek ebar el xali hik poxoŝ gaf in: ");
INSERT INTO bsc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Eñan eŋ aŝilipa ŝilipa bax. Ata h̃esik ciɗët anjëm amëgax and bax weɗind lëngwe ir Aciw̃ and Kaxanu aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aŋo xeỹ ko Yesu: «Faba, anëka këmi w̃aŝëlind angoc andam aŋ.» Ga yeƴan ko na mondako, kwël xoti ko. ");
INSERT INTO bsc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Alëngw ar ocoroɗa an ga wat ko ang ŝës ko Yesu ak, ŝëkwa këŋo Kaxanu mondako: «Enimin, ala ajo ar ŝenene ebaxo.» ");
INSERT INTO bsc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amëxwër and ɓër ƴow bax onëkon aŋ, këni renitaxënd tar fëña in ga wat këni mëne anëka xor këŋo Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ɗek ɓër nang baŋo Yesu ɓën, gë ɓësoxari ɓër laŋëtaraw baŋo elod gër ebar ed Galile ɓën xwëŝara këni nacët ako do këno nëkonënd. ");
INSERT INTO bsc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Gër Amara and ɓëxarëk ɓër Ɓëŝëwif, asoŝan ar gë onden, ar ŝenene ebax na do bano w̃acënd Yosef. ");
INSERT INTO bsc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Gër Arimate, angol and Ɓëŝëwif, xaniw baxo; axo gixeli bana gër ɓër xiti baŋo do narëndëra baŋo Yesu ga baxo ŝënind owun or Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mëŋ ƴe bax gër Pilat xara këŋo eman end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilat ga w̃a ko, Yosef fedali ko eman eŋ. Fëlëra këŋo gë këpas, do w̃ëxëta këŋo në ỹeg ir fës bani në aparëfac, gër ir elod ala ano mëxwëtaxën bana. ");
INSERT INTO bsc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yatijo bax ỹanand akey and eteyëta aŋ do Ɓëŝëwif ɓën anëka bani xëñënarand. ");
INSERT INTO bsc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɓësoxari ɓër laŋëtaw baŋo Yesu elod gër ebar ed Galile ɓën, ga sëfa këno Yosef, wat këni ỹeg in do ang w̃ëxëta këŋo ak. ");
INSERT INTO bsc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ataŋ w̃aỹi këni eni ɓarërax ogu onëngax do gë angiri eni koŝaxënëɗ gër eman end Yesu. Ata ang rek acariya and Moyis ak, fëɓ këni akey and eteyëta aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yatir akey aỹanar and loxo, ɓësoxari ɓër ebax ɓësëfan ɓën ƴe këni mopëɗ gëɓër gër ỹeg ir Yesu ga w̃ëla këni ogu onëngax ond ŝutëra bani oŋ. ");
INSERT INTO bsc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sëk këni angaỹ and weɗi bax lilaya ir ỹeg aŋ ga xënik gë beɓët. ");
INSERT INTO bsc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ga lil këni gër ỹeg, nema këni eman end Axwën Yesu eŋ, ");
INSERT INTO bsc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ata wëlandëra këɓi. Aŋo ŝanayaxën kënëɓi ɓësoŝan ɓëxi gë ɓanjëm ɓand jing-jing. ");
INSERT INTO bsc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ga yëdara këni, ɓësoxari ɓën, rën këni do faɓ këni laŋ ebar el. Ata ɓësoŝan ɓëjo w̃ëka kënëɓi: «Inew̃a këno ŝalaxënënd aɓëngw an gër ɓëŝësëk ro? ");
INSERT INTO bsc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Axo bo ex na ro, anëka xani ko gër ecës. Kwitayin ang baŋun felënd and hi ban gër ebar ed Galile ak. ");
INSERT INTO bsc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ga baŋun felënd mëne afo eno ɗëxw mëŋ Asëñiw̃ ar ala an gër ɓëw̃endëran do eno pika gër kërëwa exo cës. Ɓarikan, axani ebax exo kani gër ecës akey atasën aŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ata xwita këni ɓësoxari ɓën mëne mondako dëŋ felëra baɓi Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ga ŝan këni na gër ỹeg, ɓaka këni eni tëfëtërax ɗek eŋo gër ɓësëfan epëxw gë aɓat do gër ɗek ɓësëfan ɓëŝëxe ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Er hi bani: Mari Madëlen, gë Yowana, gë Mari nëm ir Ŝak do gë ɓësoxari ɓër laŋët baɓi ɓën reƴax këni gër oparëxanda od Yesu mëne go dëŋ ex. ");
INSERT INTO bsc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ɓarikan oparëxanda ok ani kwëta bana eyeƴan ed ɓësoxari el. Er bani yëland anëx ex. ");
INSERT INTO bsc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ata xwiriŝ Piyer hër ko xali gër ỹeg. Ga ƴëkwa ko lëf, wat ko gër ebar eɓun ed ɓënjëm ɓënd ŝeriraxën bano Yesu ɓëŋ. Ata w̃aỹi ko kwël ga ŝaran këŋo endeƴ eŋo. ");
INSERT INTO bsc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Do kwël yatijo fo, ɓësëfan ɓëxi ɓër Yesu xani bax gër Yerusalem këni ƴend gër ingol ind këni w̃acënd Emawus, në ɓapakan epëxw gë amat. ");
INSERT INTO bsc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tar fëña in bani xanarënd ɓend Yesu ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ga këni rendëra, Yesu mëŋ dëŋ ŝoma këɓi do kwël këni sëfërënd. ");
INSERT INTO bsc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aye dëŋ bano watënd ɓarikan afoɗ foɗ baɓi do bani sëkwanënd eno kwita in. ");
INSERT INTO bsc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ata w̃ëka këɓi: «Ɓend ine ngwa kën xanarënd tar fëña in?» Ga logën këɓi, xwëŝa këni. ");
INSERT INTO bsc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yaka ko ar bano w̃acënd Këlewopas an: «Wëj gaɓat ex ar ƴow bax gër Yerusalem an do nem këƴ er xucak ɓakey ɓaŋo in?» ");
INSERT INTO bsc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ata w̃ëka ko ɓëte: «End ine ngwa?» Yaka këno: «End Yesu Iɓënasaret eŋ wa. Gër ogës od Kaxanu do gër od ɓela, alaw̃ënel ar bax rind ɓecarax ebaxo do baɓi sëƴalirand Ɓëyisërayel ɓën gë or gapak. ");
INSERT INTO bsc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ɓëŝaɗaxan ɓëlëngw ɓën do gë ɓemun ɓendeɓi ɓeŋ lëxw baŋo eno nëpaxën do eno ɗaw̃axën mopika gër kërëwa. ");
INSERT INTO bsc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɓiyi cëŋ ako yëla bami mëne mëŋ ex ar law̃ënëgu baŋo Kaxanu an eɓi dacët ɓulunda ir Isërayel in gër otaxan od ɓërangoỹëra andeɓën. Do doro ex akey atasën aŋ elod ga xucak ɓeŋo ɗek. ");
INSERT INTO bsc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɗal ex mbaŋ dëŋ ŝaran këɓo er reƴa këni ɓësoxari ɓërëmar, ɓër enga endeɓi in. Aƴe ƴe bani gëɓër fo gër ỹeg ir Yesu. ");
INSERT INTO bsc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ga nema këni eman endexëm eŋ, ɓakaw këni, felati kënëɓo mëne omeleka ŝanayaxën këɓi do re këni mëne aɓëngw exo. ");
INSERT INTO bsc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aƴe ƴe bani ɓëte ɓësëfan ɓërëmar gër ỹeg do sëk këni ɓeỹ ɓën ang reƴa këni ɓësoxari ak. Ɓari mëŋ ano watëgu ex na.» ");
INSERT INTO bsc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ata re ko Yesu: «Wën and foɗ këŋun dëŋ ex ɗe! Ow̃ëkw orewën oŋ aleg legëk ekwëta ed ɗek ɓend reƴa këni ɓëlaw̃ënel ɓër Kaxanu el! ");
INSERT INTO bsc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ax gi ex na nde ako bax exo toro Afexën an, ɗamana exo ɓakanaxën enjaran endexëm eŋ?» ");
INSERT INTO bsc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ga ỹana ko Yesu gër ɓakayëta ɓand Moyis do gër ɗek ɓand ɓëlaw̃ënel, faỹën këɓi ɓendexëm ɓeŋ eɓi pënixën. ");
INSERT INTO bsc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ga këni h̃at gër Emawus, Yesu ỹandi këŋo exo kuca. ");
INSERT INTO bsc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ata ɓësëfan ɓëxi ɓën xara këno eŋo key na. Re këni: «Ɓayine ro, në ecëla ex eñan eŋ, anëka w̃ëɗëk!» Ata w̃a ko do kwël h̃at këni gër ndeɓën. ");
INSERT INTO bsc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","And ỹëpa këni gër eƴambëran aŋ, Yesu w̃eɗ ko amburu aŋ, ŝëkwa këŋo Kaxanu, hëbëndër ko do ŝet këɓi. ");
INSERT INTO bsc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Amëd aŋo fëɗët këɓi onden oŋ, ata xwita këno, ɓarikan na dëŋ nem këno ɓëɗ-ɓëɗ. ");
INSERT INTO bsc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ata këni w̃ëkarënd: «Abaxi hi na nde ñar gër emëkw and baɓo felërawënd gër fëña aŋ, do and baɓo faỹënënd Oñëgw Omënëk aŋ?» ");
INSERT INTO bsc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ga xani këni na, ɓaka këni kwël gëmëɗ fo gër Yerusalem. Sëkëx kënëɓi ɓësëfan epëxw gaɓat ɓën gër ed ɓarër bani, gë ɓër baɓi sëfarand ɓën. ");
INSERT INTO bsc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ata xacali kënëɓi mëne enimin Axwën Yesu axani dëŋ xani ko gër ecës do mëne Simoŋ ŝanayaxën këŋo. ");
INSERT INTO bsc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɓën ɓëte reƴa këni mëne gë Yesu sëfërëx bani xali h̃at këni gër ndeɓën, do mëne gër eƴambëran fo xwita këno and hëbëndër ko mburu aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ani ŋata bana eŋo, Yesu ŝanayaw ko mëŋ dëŋ mërëxand, do fel këɓi: «Kaxanu yëlëŋun wa aketëxeta aŋ!» ");
INSERT INTO bsc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na lëk këɓi anjiỹ atëm do këɓi rëgëndërand gayik er yëla bani angoc andexëm aŋ ex. ");
INSERT INTO bsc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ɓarikan mëŋ w̃ëka këɓi: «Inew̃a wëlandëraxën këŋun gër ow̃ëkw orewën? Inew̃a ɓayik an kwëta ex na mëne wëno dëŋ ex? ");
INSERT INTO bsc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nëkoyin otaxan ok gë osapar oŋ, wëno dëŋ ex. Ɗëkërayine tan! Aye nang kën mëne angoc axo gi ex na gë eman ang këne watënd ak.» ");
INSERT INTO bsc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","And yeƴaneli këɓi mondako aŋ, w̃asindëra këɓi ɓambënut ɓaŋ gër otaxan do gër osapar. ");
INSERT INTO bsc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ado ga nëngandëra baɓi ani ma ba na pere mëne Yesu dëŋ ex. Ata mëŋ w̃ëka këɓi: «Eƴamb ƴamb nde ex na?» ");
INSERT INTO bsc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yël këno aton and ekan ebëkawëka. ");
INSERT INTO bsc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ga xana ko, ƴak këŋo ogës odeɓën dëŋ. ");
INSERT INTO bsc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ata re ko: «And hi bane në ereɓat aŋ, afel bamun felënd mëne ah̃ata kë h̃ata ɗek ɓeɓër ỹëgw këni gër acariya and Moyis gë ɓëlaw̃ënel ɓër Kaxanu ɓën do er rek gër Calemoñëw̃ endam in.» ");
INSERT INTO bsc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ata na dëŋ fërëtën këɓi onden ond eɓi pënixën er rek akayëta and Kaxanu in. ");
INSERT INTO bsc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ata fel këɓi: «Mondako ga ỹëgw këni gër akayëta and Kaxanu mëne wëno Afexën an, anarëndëra ebax ene narëndëra xali, ene ɗaw̃. Ɓarikan me kani gër ecës yatir akey atasën aŋ. ");
INSERT INTO bsc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Do end enëngwët ed ola eŋ, gë end eteɓan ed ɓeñëŋënax eŋ, ɓësëfan ɓërexëm ɓën afemëra këni ỹana eni pemërand gër ow̃ac orexëm gër ɗek ɓenëng ɓend ɓela, ga ỹana ỹana këni gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wën ɓësëfan ɓën ex ɓër otede ok. ");
INSERT INTO bsc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Er ɓeƴa baŋun Faba in alaw̃ëneli këmun law̃ëneliw. Cëniyin gër angol and Yerusalem xali eŋun yël Kaxanu panga indexëm ind ƴaŋ iŋ.» ");
INSERT INTO bsc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ga xucak eŋo, Yesu w̃ëla këɓi ɓësëfan ɓërexëm ɓën gand ingol ind Betani. Yën ko otaxan ok do këɓi ŝalenënd. ");
INSERT INTO bsc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nand baɓi ŝalenënd na, kwël dëŋ këni seɓëtarënd, ga ko ŝëg end orën eŋ, xali ŝilipax ko. ");
INSERT INTO bsc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Amëd aŋo ŝale këno do ɓaka këni gër Yerusalem gë onënga osëm. ");
INSERT INTO bsc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Key yo key bani fedërënd cale iŋ gër Aciw̃ and Kaxanu do bano ŝëkwand Kaxanu.");
INSERT INTO bsc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Elod gër ỹanar hik eyeƴan el, do Eyeƴan el ebax gë Kaxanu, do Eyeƴan el hik Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Elod gër ỹanar hi këni, Eyeƴan el do gë Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Er ex yo gë mëŋ ri ko Kaxanu, do ỹoweỹ ax gi ex na er ɓayik axo di ex na gë mëŋ. ");
INSERT INTO bsc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Gër eyeƴan elo ŝanëguk aniyan aŋ, do aniyan aŋ ex angoɓen and ɓela aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Angoɓen aŋ h̃oɓak ecamëɗan el, do ecamëɗan el aŋo kwëtaya ex na. ");
INSERT INTO bsc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akey amat, h̃atëgu ko ala, ga law̃ënëgu këŋo Kaxanu, ow̃ac orexëm ol ex Ŝaŋ. ");
INSERT INTO bsc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mëŋ ƴow bax exo gi sede, eni kwëtaxën angoɓen aŋ ɗek ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ŝaŋ aƴow fo ƴow baxo exo gi sede ir angoɓen in axo gi bana mëŋ dëŋ angoɓen aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Eyeƴan el ex angoɓen and ɗal and këŋo h̃oɓand ala ar ex yo aŋ; aƴow ƴow bax gër ngwën. ");
INSERT INTO bsc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aƴow ƴow bax gër ngwën, ɓarikan ngwën iŋ elod aŋo nang ex na, xarak Kaxanu, paɓ gë angoɓen ri ko ngwën iŋ. ");
INSERT INTO bsc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Angoɓen aŋ ƴowëk gër ebar edexëm, do ɓërexëm ɓën h̃ëp këni eno kwëtaya. ");
INSERT INTO bsc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ɓarikan, ɓër xwëta këŋo ɓën ɗek, ɓër xwëtak ow̃ac orexëm ɓën, këɓi yëlënd panga ind eni gixën oɓaŝ or Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kaxanu dëŋ ri këɓi oɓaŝ orexëm gë oñandi odexëm ok, ax gi ex na gë oŝat do gë oñandi od eman, ax gi ex na ang këno rëw̃ënd ala ak, ax gi ex na dëŋ oñandi od ala. ");
INSERT INTO bsc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eyeƴan ed Kaxanu el hik ala, lëg ko gër ebar edeɓi, wat këmi enjaran endexëm eŋ, enjaran en Asëñiw̃ ar tañ, ar xaniwëk gër Faba Kaxanu eŋ, ỹëm ko gë oyekax ol do gë ɗal in. ");
INSERT INTO bsc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ata Ŝaŋ Batis ga ko reƴa poyoma endexëm eŋ, xeỹ ko: «Mëŋ ex ar bame rend: “Ar ke sëfëgund an, lëngwatëgu ke gayik mëŋ anëka hi ko ɗamana me gixën.”» ");
INSERT INTO bsc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ata ɓiyi ɗek këɓo yëlënd ɗek oyekax orexëm ol do këɓo ɓaŝënënd key yo key. ");
INSERT INTO bsc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gayikwa acariya aŋ paɓ gë Moyis ƴowëk gër ngwën, oyekax ol do gë ɗal in ƴowëk gë Yesu Kërisët. ");
INSERT INTO bsc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Elod ala aŋo wat ex na Kaxanu, ɓarikan Asëñiw̃ ar tañ an, ar pëlot gër yomb irexëm an fo nangën këɓo. ");
INSERT INTO bsc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɓaxëtin osede or reƴa baxo Ŝaŋ Batis gër Ɓëŝëwif ɓër xaniw bax elod gër Yerusalem ga law̃ënëgu kënëɓi ɓëŝaɗaxan do gë ɓërandëw̃ëra and Lewi, eno mëkara mondako: «Wëj noỹo wa hi këƴ?» ");
INSERT INTO bsc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ata mëŋ axo ƴax ex na, yaka këɓi fac: «Wëno, ame gi ex na ɗe Afexën an!» ");
INSERT INTO bsc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","W̃ëka këno ɓëte: «Noỹo cëŋ hi këƴ? Ba wëj nde ex Eli?» Yaka këɓi ɓëte: «Ali, ame gi ex na Eli.» Re këni ɓëte: «Do wëj nde ex alaw̃ënel ar Kaxanu ar bax ƴowënd an?» Yaka këɓi: «Ɓëtëɗën!» ");
INSERT INTO bsc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aŋo re këni: «Noỹo wa hi këƴ? Mi ɓakaxën gë eyaka gër ɓër law̃ënëgu këɓo! Wëj dëŋ noỹo këƴ rend hi këƴ?» ");
INSERT INTO bsc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yaka ko Ŝaŋ: «Wëno ex oniw̃ or kë xeỹënd gër ladawe ol, Wëno kë rend: “Ɗëbëtin fëña ir Axwën in”, mondako re baxo alaw̃ënel Esayi». ");
INSERT INTO bsc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ata ɓërolaw̃ën ɓër w̃ëkara ɓën Ofariseŋ ebax. ");
INSERT INTO bsc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","W̃ëka këno: «Ine cëŋ këƴëɓi ɓuyixënënd ɓela ɓën gayikako aƴ gi ex na Afexën an, aƴ gi ex na Eli, aƴ gi ex na ɓëte alaw̃ënel ar kë ƴowënd an?» ");
INSERT INTO bsc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ŝaŋ Batis yaka këɓi: «Wëno gër men këmëni ɓuyind ɓela ɓën. Ɓarikan, ala ex na mërëxand irewën, ar ano nang ex na; mëŋ ke sëfëgund! ");
INSERT INTO bsc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wëno ado axe ñap ex na me pët ogux od ɓapeɗ ɓandexëm ok.» ");
INSERT INTO bsc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mondako xuca bax eŋo gër ingol ind Betani, ekeg Yurëdeŋ in, gër ed baɓi ɓuyirand Ŝaŋ Batis ɓela. ");
INSERT INTO bsc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Në ecan ijo, Ŝaŋ Batis watëgu këŋo Yesu ga ko ƴow. Ata fel këɓi ɓër xeta baŋo ɓën: «Nëkoɗo ar këŋo ŝaɗaxa Kaxanu exo dëxëtaxën amena and ngwën an. ");
INSERT INTO bsc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mëŋ bamo rend: “Ar ke sëfëgund an lëngwatëgu ke gayik mëŋ anëka hi ko ɗamana me gixën.” ");
INSERT INTO bsc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wëno amo nang bana. Eno nangaxën ɓulunda ir Isërayel in këmëni ɓuyixënënd ɓela ɓën gër men.» ");
INSERT INTO bsc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ŝaŋ Batis areƴa reƴa baxo ɓëte: «Awat wat këmo Angoc Amënëk aŋ ga ko fedaw, elod gër orën, ang eɗëxwëte epeŝax fo, lapa ko gër ndexëm, do ɓayi ko laŋ gër ola orexëm. ");
INSERT INTO bsc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Wëno dëŋ amo nang bana. Ar law̃ënëgu ke mëni ɓuyind ɓela an fel baxe: “Ar këƴo wat ga lapaxën këŋo Angoc Amënëk aŋ, do exo ɓayi laŋ gër ola orexëm kë ɓuyind gë Angoc Amënëk aŋ.” ");
INSERT INTO bsc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Awa wëno ga wat këmo këme reƴaxënënd mëne mëŋ ex Asëñiw̃ ar Kaxanu an.» ");
INSERT INTO bsc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Në ecan ijo, Ŝaŋ Batis gë ɓësëfan ɓëxi ɓërexëm ɓaka këni gër ed baɓi ɓuyirand ɓela. ");
INSERT INTO bsc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ata Ŝaŋ Batis, ga wat këŋo Yesu ga ko xuca, re ko: «Nëkoyino wa ar këŋo ŝaɗaxa Kaxanu an!» ");
INSERT INTO bsc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ɓësëfan ɓëxi ɓëjo ga wël këno, sëf këno kwël Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","And nëkona ko aŋ, wat këɓi ga këno sëfa. Ata w̃ëka këɓi: «Inew̃a kën ŝaland?» Yaka këno: «Rabi» (Asëƴali), mi nang gër ed lëg këƴ ỹandi këɓo. ");
INSERT INTO bsc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ata re ko Yesu: «Awa ƴowën en nang.» Ga sëfa këno eni nangëx gër ed lëg ko, ɓayix këni gë mëŋ xali eñan eŋ poxoŝ gaf in. ");
INSERT INTO bsc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andëre, aɓinëm ar Simoŋ Piyer, ebax asëfan aɓat gër ɓëxi ɓër wël baŋo Ŝaŋ Batis do sëfa bano Yesu ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ga ƴen këŋo pere Simoŋ, ar acël amat gë mëŋ an, felëgu këŋo: «Ɓiyi anëka watëgu këmo wa Afexën an» (Kërisët). ");
INSERT INTO bsc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ata Andëre w̃ëlaw këŋo gër Yesu. Ga faɓër këni gë Simoŋ, Yesu re ko: «Wëj ex Simoŋ, asëñiw̃ ar Ŝaŋ! Gërëgako, Kefas nëngwët këmi.» (Ekaỹ). ");
INSERT INTO bsc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Në ecan ijo, Yesu xani ko ond gër ebar ed Galile oŋ, do fed këni gë Filip. Yesu fel këŋo: «Tëfële wëno.» ");
INSERT INTO bsc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip, Abetësayida hi baxo, angol amat gë Andëre do gë Piyer. ");
INSERT INTO bsc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip ga ƴen këŋo Natanayel fel këŋo: «Ɓiyi anëka wat këmo wa ar re këno gër acariya and Moyis do ɓakayëta ɓand ɓëlaw̃ënel an: Yesu Iɓënasaret, asëñiw̃ ar Yosef an.» ");
INSERT INTO bsc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ata re ko Natanayel: «Ine? Enjekax end fe ngwa kë xaniw gër Nasaret?» Yaka ko Filip: «Ƴow eƴo wat!» ");
INSERT INTO bsc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu wat këŋo Natanayel ga ko ƴow gër ndexëm, re ko: «Dodo nëkoyino Ayisërayel ar ɗal an! Anëx ax gi ex na gër ndexëm.» ");
INSERT INTO bsc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","W̃ëka këŋo Natanayel: «Feye ngwa nang këƴe?» Ata re ko Yesu: «Ɗamana exi ƴenëli Filip gogo nde wa wat bami moỹëpa ɗila gër andan.» ");
INSERT INTO bsc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aŋo re ko Natanayel: «Asëƴali, awa wëj ex Asëñiw̃ ar Kaxanu an! Wëj ex emun end ɓulunda ir Isërayel eŋ!» ");
INSERT INTO bsc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Re ko ɓëte Yesu: «Ba gayik afel fel këmi ɗila gër andan wat bami nde xwëtaxën këƴe, awat këƴ wat ɓend xucak eŋo.» ");
INSERT INTO bsc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Re ko ɓëte Yesu: «Ɗal in këmun felënd, awat kën wat orën ol fol do omeleka od Kaxanu ok ga këne semëra wëno Asëñiw̃ ar ala an, oko ƴaŋ ƴaŋ, oko gëɗ gëɗ.» ");
INSERT INTO bsc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ga xucak ɓakey ɓaki, hik ekana gër ingol ind Kana, gër ebar ed Galile. Mari, nëm ir Yesu na baxo. ");
INSERT INTO bsc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ga w̃ac këno Yesu gër ekana elo, ƴow ko mëŋ ɓëte gë ɓësëfan ɓërexëm ak. ");
INSERT INTO bsc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ga xwëtëk ngoƴ iŋ, nëm ir Yesu sëka këŋo, re ko: «Ngoƴ aɓi bo ex na ɗe!» ");
INSERT INTO bsc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yaka këŋo Yesu: «Asoxari, inew̃a ɓar ke wëj gë wëno gër endeƴ eŋo? Apëxëd andam aŋ ax ƴow ex na pere.» ");
INSERT INTO bsc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mari fel këɓi ɓëriyenin ɓën: «Diyiɗën er këŋun fel yo!» ");
INSERT INTO bsc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ata gër iciw̃ iŋo ɓapeƴa ɓanjongamat ɓand oxaỹ ofësëpës hi bax na. Gër ɓapeƴa ɓaŋo bani yifënd men ond bani neɓaraxënënd Ɓëŝëwif oŋ, ang rëp bax ak. Apeƴa kala gwër oɗitër keme aŝand. ");
INSERT INTO bsc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ata re ko Yesu: «Yifin tan men oŋ apeƴa kala cëm.» Yifëra këni cëm cëm. ");
INSERT INTO bsc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Re ko ɓëte: «Dëmbënino gërëgako enjar end ofëna eŋ exo tëƴix.» Rëmbën këno do yëlëx këno. ");
INSERT INTO bsc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","And sëƴi ko enjar end ofëna aŋ, men oŋ nëngwëtak ngoƴ, (axo nang bana feye xaniwëk ngoƴ iŋo, xarak ɓëriyenin ɓër rëmb bax men ɓën anang nang bani). ");
INSERT INTO bsc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Enjar end ofëna eŋ w̃ac këŋo icën iŋ, re ko: «Oko wëj aƴ nang ex na nde mëne and këƴ nëcët ngoƴ inëngax xali eɓi kor ɓela aŋ, anëɓi tëndënd na ɓëte? Do wëj këƴ nëcëtëgund ngoƴ inëngax iŋ xali gërëgako.» ");
INSERT INTO bsc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mondako ri baxo Yesu ecarax eñanar eŋ gër ingol ind Kana, gër ebar ed Galile. Mondako w̃asin baɓi enjaran endexëm eŋ ɓësëfan ɓërexëm ɓën, ata xwëta këno. ");
INSERT INTO bsc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ga xucak ekana el, Yesu ɓaka ko gër angol and Kafarënawum. Sëfër këni gë nëm, gë ɓoɓinëm do gë ɓësëfan ɓërexëm ɓën. Ɓakey ɓapënëfëne fo rix bani. ");
INSERT INTO bsc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ofëna or Apexa or Ɓëŝëwif ol ɗam hi bax. Ata Yesu ko ƴend ƴaŋ gër angol and Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ga h̃at ko, sëk këɓi ɓëfan ɓër oxeƴ, gë ɓër opeỹ, gë ɓër olëxwëte do gë ɓënëmb ɓër koɗi gër yangana ir Aciw̃ and Kaxanu, ɗila në ɓaner. ");
INSERT INTO bsc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na ga lëkw ko ongux w̃ayëra këɓi ɗek eni can yangana ir Aciw̃ and Kaxanu in, gë opeỹ ak, do gë oxeƴ ak. Yamëra ko ɓakwëtaya ɓand ɓënëmb ɓër koɗi ɓaŋ, ata yiŝarëk ɓatama ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Fel këɓi ɓëfan ɓër olëxwëte ɓën: «Nëcëtin ɓeɓijo ro! Ba an nang ex na nde mëne Aciw̃ and Faba aŋ and cale ex, do wën nëngwët kën aciw̃ and apanëraxën?» ");
INSERT INTO bsc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ata ɓësëfan ɓërexëm ɓën xwita këni oñëgw od rek: «Eɓalëkënali ed Aciw̃ andeƴ el, ang xoɗux fo ke ŝorënd!» ");
INSERT INTO bsc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ata ɓëlëngw ɓër Ɓëŝëwif ɓën fel këno Yesu: «Afo eƴ di ecarax mi nangaxën mëne wëj aỹap ỹap ki eƴëɓi ŋw̃aỹënd ɓela ɓën gër Aciw̃ and Kaxanu!» ");
INSERT INTO bsc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yaka këɓi: «Ñamin tan Aciw̃ and Kaxanu aŋo do wëno me kanin në ɓakey ɓatas.» ");
INSERT INTO bsc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Re këni ɓëte ɓëlëngw ɓër Ɓëŝëwif: «Ba aƴ nang ex na nde mëne ɓëniy ofëxw onax gë ɓënjongimat ɓaƴaxën këni Aciw̃ and Kaxanu aŋo? Do wëj këƴ rend ɓakey ɓatas fo këƴ ri kaninaxën?» ");
INSERT INTO bsc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ɓarikan, Yesu ga yaka këɓi mondako end Aciw̃ and Kaxanu and baxo rend eŋ, end eman endexëm eŋ baxo yeƴanënd. ");
INSERT INTO bsc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","And xaniw ko gër ecës aŋ, ɓësëfan ɓërexëm ɓën xwita këni eyeƴan elo, ata xwëta këni Oñëgw Omënëk ok do gë er baɓi fel Yesu in. ");
INSERT INTO bsc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","And hi baxo Yesu gër Yerusalem, gër ofëna or Apexa aŋ, ɓëranjëm xwëta baŋo ga këni wat ɓecarax ɓend baxo rind ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ɓari Yesu aɓi kwëta bana gayik ɗek fo nang baɓi, ");
INSERT INTO bsc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ax gi bana eno pel end ala gayikwa gë andexëm dëŋ baxo nangënd er ex gër emëkw ed ala in. ");
INSERT INTO bsc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Alëngw ar Ɓëŝëwif ebaxëna gër enga end Ofariseŋ ar bano w̃acënd Nikodem. ");
INSERT INTO bsc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Akey amat, ƴe ko gëmëɗ gër Yesu re ko: «Asëƴali, aye nang këmi mëne wëj Kaxanu law̃ënëgu ki eƴëɓo tëƴali endexëm eŋ. Ala ax kor na exo di ɓecarax ɓend wateli këmi ɓeŋ angëmëne ani ɓar ex na gë Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu yaka këŋo: «Ɗal in këmi felënd, ar ano dëw̃ ex na gaŝëxe an axo kor na exo wat owun or Kaxanu ol.» ");
INSERT INTO bsc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ata re ko Nikodem: «Mondake ko xor ala eno dëw̃ gaŝëxe and ko xar aŋ? Axor nde ko xor exo ɓaka gër acël and nëm eŋo dëw̃axën gaŝëxe?» ");
INSERT INTO bsc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yaka këŋo ɓëte Yesu: «Ɗal in këmi felënd, ar ano dëw̃ ex na gë men do gë Angoc an, axo kor na exo ɗil gër owun or Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ar rëw̃ këŋo ala an, ala fo hi ko do ar rëw̃ këŋo Angoc and Kaxanu an, ar angoc hi ko. ");
INSERT INTO bsc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wëj kërexi caran na end re këme afo enun dëw̃ gaŝëxe eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ekoc el gand ed këŋo ỹandi kë xocënd do awël fo këƴ wël ga kë rëm. Ɓari aƴ nang na ba feye xaniwëk do ba feye kë ƴend. Awa mondako fo ex end ar rëw̃ këŋo Angoc and Kaxanu eŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ata w̃ëka ko ɓëte Nikodem: «Mondake kë xor ex gi eŋo?» ");
INSERT INTO bsc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yaka këŋo Yesu: «Oko, wëj këɓi sëƴalind end Kaxanu eŋ ɓulunda ir Isërayel in nde do nem këƴ eŋo? ");
INSERT INTO bsc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ɗal in, këmi felënd ɓiyi end nang këmi këmun sëƴalind, osede oreɓi ol end wat këmi ex! Ɓari wën an mand na er këmi reƴand in. ");
INSERT INTO bsc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Angëmëne në edeƴa me ɓend gër ebar ro ɓeŋ wën an mand na do mondake kën w̃a ɓend ƴaŋ gër orën ɓeŋ? ");
INSERT INTO bsc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Elod ala axo ƴe ex na ƴaŋ gër orën; wëno Asëñiw̃ ar ala an fo fedawëk. ");
INSERT INTO bsc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ang xaw̃ ɓaŋo Moyis andën and ƴawale gër ladawe ak, mondako fo këne xaw̃ wëno Asëñiw̃ ar ala an ");
INSERT INTO bsc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","do ar ke xwëta yo aŝot ko ŝot aniyan and din aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Gayikwa Kaxanu mbaŋ h̃an këɓi ɓela ɓër gër ngwën ro ɓën, mëŋ yëlaxën këɓi Asëñiw̃ ar tañ arexëm an, do ar këŋo xwëta yo exo cot aniyan and din aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Enimin, Kaxanu eɓi pexënaxën ɓela ɓën law̃ënëgu këŋo Asëñiw̃ arexëm an gër ngwën ro, ax gi ex na eɓi nëpaxën. ");
INSERT INTO bsc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ar këŋo xwëta Asëñiw̃ ar Kaxanu an aŋo nëp na. Ɓari ar aŋo kwëta ex na an anëka nëp këŋo gayik axo kwëta ex na ow̃ac or Asëñiw̃ ar tañ ar Kaxanu ol. ");
INSERT INTO bsc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Awa në eŋo këɓi nëpaxën Kaxanu: ga ƴowëk angoɓen aŋ gër ngwën ro, ɓela ɓën ŝus këni, do h̃an këni ecamëɗan el gayik ɓeɓër këni rind ɓën ax ye ex na. ");
INSERT INTO bsc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ata ar kë w̃endërand an kë ŝusënd angoɓen aŋ, do axo tëkand na këdi kë fëlëtar ɓeñëŋënax ɓend ko rind ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ɓarikan, ar kë rind end ɗal an kë sëkand angoɓen aŋ eni wataxën ɓela ɓën mëne ɓeɓër ko rind ɓën gë Kaxanu këni rind.» ");
INSERT INTO bsc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ga xucak eŋo, Yesu gë ɓësëfan ɓërexëm ɓën ƴe këni gër ebar ed Yude, xeyërax këɓi fën ɓakey do kënëɓi ɓuyind ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ŝaŋ Batis, gër ed këɓi ɓuyind ɓela ɓayi baxo gër Enoŋ, ler gër ingol ind Salim gayik mbaŋ ebax men oŋ. Fën bani ƴend ɓela ɓën eɓi ɓuyix. ");
INSERT INTO bsc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Amëd aŋo ano përa bana pere Ŝaŋ Batis. ");
INSERT INTO bsc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ata akey amat, ɓësëfan ɓërexëm ɓën këni ŝampërend gë Aŝëwif aɓat end mondake këni rind ew̃unëtan el. ");
INSERT INTO bsc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ga sëka këno Ŝaŋ Batis, re këni: «Asëƴali, ar ƴow bax ekeg ed Yurëdeŋ xali reƴa baƴ endexëm an, në eɓuyi eɓi ɗe ɓela ɓën do ɗek mëŋ fo këno sëfënd.» ");
INSERT INTO bsc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ata Ŝaŋ Batis yaka këɓi: «Ala an er ŝot ko yo, orën ol yël këŋo. ");
INSERT INTO bsc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wën dëŋ awël wël këne ga këme reƴa mëne ame gi ex na Afexën an, alëngwa fo lëngwaw exe tëfëraxënëgu. ");
INSERT INTO bsc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Icën iŋ wa këŋo xanand endënaw̃ end eñër eŋ, ax gi ex na lawo ir këŋo laŋët in. Alaŋëta an, alaŋët fo këŋo laŋëtënd, do mbaŋ këŋo nëngandëraɗ ga këŋo wëlënd icën iŋ. Mëŋ ex, wëno ɗek hi këme onënga ol. ");
INSERT INTO bsc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ado wëlil exo mëŋ do wëno ene kwëya ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Ar xaniwëk ƴaŋ gër orën an ỹëmbëta këɓi ɗek ɓela ɓën. Ar gër ebar an, ar gër ebar fo ex do end gër ebar fo ko yeƴanënd. Ar xaniwëk ƴaŋ gër orën an nëmëca këɓi ɗek ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Er watëgu ko in do er wëlëgu ko gër orën in ko reƴand. Ala ax ma ex na osede orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɓarikan ar w̃ak osede orexëm an reƴak mëne Kaxanu ɗal exo. ");
INSERT INTO bsc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kaxanu yël këŋo gë etëƴin këm Angoc andexëm aŋ ar law̃ënëgu këŋo an. Mëŋ ex er ko reƴand in gër Kaxanu xaniwëk. ");
INSERT INTO bsc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sëm in ɓon h̃an këŋo Asëñiw̃ do ɓeỹ ɗek seɓënan këŋo. ");
INSERT INTO bsc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ar w̃ak end Asëñiw̃ ar Kaxanu eŋ ŝotëk aniyan and din aŋ. Ar aŋo kwëta ex na an axo cot na aniyan aŋo, do oxoỹ or Kaxanu ol laŋ ex gër ndexëm.» ");
INSERT INTO bsc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ata Axwën Yesu nang ko mëne Ofariseŋ ok wël bax mëne ɓësëfan ɓërexëm ɓën ỹëmbëk nëmëc gë ɓër Ŝaŋ Batis ɓën, ɓëte ɓër këɓi ɓuyind ɓën ỹëmb nëmëc. ");
INSERT INTO bsc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Enimin, ɓësëfan ɓërexëm ɓën baɓi ɓuyind, ax gi ex na Yesu mëŋ dëŋ. ");
INSERT INTO bsc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ata na ga xani ko gër ebar ed Yude w̃aỹi ko gër ed Galile. ");
INSERT INTO bsc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Afo ir ebar ed Samari in ebax exo kuca. ");
INSERT INTO bsc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ga ko ƴe, h̃at ko gër angol and bani w̃acënd Sikar, ler gër oŝënga or Yakob or yël baŋo asëñiw̃ Yosef. ");
INSERT INTO bsc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na bax andu and Yakob aŋ. Yesu, ga sëkwëra ko oñe oŋ, ỹëpa ko ler gër andu, xarak amëd aŋo eñan eŋ keŋ gër gaf hi bax. ");
INSERT INTO bsc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Na ƴow ko asoxari Asamari edëmb ed men. Ata re ko Yesu: «Yëluɗe wa me ceɓ.» ");
INSERT INTO bsc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Xarak, ɓësëfan ɓërexëm ɓën gër angol ƴe bani eni yëcëraw er këni ƴamb in. ");
INSERT INTO bsc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ata re ko asoxari an: «Yama wëj Aŝëwif nde ke xarand men ond eceɓ wëno Asamari?» (Rexën baxo mondako asoxari an, Ɓëŝëwif ɓën abani sëkar na gë Ɓësamari ɓën.) ");
INSERT INTO bsc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ata Yesu yaka këŋo: «Kido anang nang baƴ er ko yëlënd Kaxanu in do kido afëni fëni baxi noỹo hi këme wëno ar ki xarand men ajo an, wëj dëŋ xaradoxe. Ata yël domi men ond kë yëlënd aniyan oŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na re ko asoxari an: «Oko axwën, aƴ gi ex na gë siwo ir këƴ rëmbaxën, do andu aŋ atiw̃ax ex. Feye wa këƴ ŝotëgu men ond kë yëlënd aniyan oŋo? ");
INSERT INTO bsc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yakob, axarëk areɓi an seɓëtan këɓo andu aŋo. Gër aŋo bani ŝeɓënd mëŋ gë ɓosëñiw̃ do gë oyel oreɓën ol. Ba wëj nde xuca këŋo?» ");
INSERT INTO bsc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ata yaka ko Yesu: «Ar kë ŝeɓ yo men oŋo ro, asel këŋo sel gaŝëxe. ");
INSERT INTO bsc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ɓarikan men ond këme yëlënd oŋ, ar kë ŝeɓ an din aŋo tel na. Men oŋo ang epëndin fo kë ỹana ex ɗejënd gër ola orexëm xali gër aniyan and din.» ");
INSERT INTO bsc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ata re ko asoxari an: «Axwën yëlële ngwa men oŋo, mëŋ ɓayik axe ñana na exe telënd din do me teɓ eƴow ed gër andu ro el.» ");
INSERT INTO bsc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Re ko Yesu: «Ƴel eƴo macëgu icën indeƴ iŋ, en tëfërëgu.» ");
INSERT INTO bsc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yaka ko asoxari an: «Ame gi ex na gë icën.» Na re ko Yesu: «Ɗal reƴa këƴ mëne aƴ gi ex na gë icën. ");
INSERT INTO bsc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ɓësoŝan ɓëco ŝapër kën do gë ar ỹëpa kën gërëgako an, axo gi ex na icën indeƴ. Ata ɗal dëŋ reƴa këƴ.» ");
INSERT INTO bsc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na re ko asoxari an: «Axwën, anëka nang këme mëne wëj alaw̃ënel ar Kaxanu hi këƴ. ");
INSERT INTO bsc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɓëxarëk ɓëreɓi ɓën gër etënd elo bano ŝalend Kaxanu, do wën Ɓëŝëwif ɓën kën rend mëne gër Yerusalem fo hi ko mocale.» ");
INSERT INTO bsc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ata re ko Yesu: «Aɓiw̃ën, kwëtale ga re këme, aƴow kë ƴow apëxëd and këno ỹana eno calend Faba në er ex yo, xarak ax gi ex na gër etënd elo fo, ɓëte ax bo na gër Yerusalem fo. ");
INSERT INTO bsc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wën Ɓësamari ɓën, ano nang ex na ar këno ŝalend an. Ɓiyi Ɓëŝëwif ɓën nang këŋo gayik paɓ gë enëng endeɓi eŋ këni fexaxën ɗek ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ɓarikan, në eƴow ex (ado gërëgako dëŋ ex) amëd and ɓër këŋo ŝalend enim Faba, gë angoc do gë ɗal ɓën. Ata ɓër këŋo ŝalend mondako ɓën këɓi ŝaland. ");
INSERT INTO bsc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kaxanu angoc hi ko, do ɓër këŋo ŝalend ɓën, afo eno calend gë angoc aŋ do gë ɗal in.» ");
INSERT INTO bsc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na rew ko asoxari an: «Anang nang këme mëne në eƴow exo Afexën an, (mëne ngëŋ Kërisët). And ko h̃atëgu aŋ, mëŋ këɓo sëfëtan ɓeỹ ɓën ɗek.» ");
INSERT INTO bsc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yaka këŋo Yesu: «Wëno ar ki yeƴanelind ajo dëŋ ex!» ");
INSERT INTO bsc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aŋo h̃atëgu këni ɓësëfan ɓën. Aŝaran ŝaran baɓi ga sëk këno Yesu ga këŋo felëra asoxari end Kaxanu eŋ. Ɓarikan, gaɓatak aŋo mëka bana ba ine baŋo w̃ëkand do ba ine ɓaŋo felëraxënënd. ");
INSERT INTO bsc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ata asoxari an seɓ ko na ipeƴa ind men iŋ, w̃ara ko gër angol felëx këɓi ɓela ɓën: ");
INSERT INTO bsc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ƴowën eno nang ar felëra ke ɗek ɓeɓër ri këme an. Ba axo gi ex na cëŋ Afexën an?» ");
INSERT INTO bsc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ata ga ŝanëgu këni angol aŋ, ƴe këni ɓura-ɓura gër ed hi baxo Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Amëd aŋo, bano felënd ɓësëfan ɓën: «Awël nde Asëƴali, ƴambëral.» ");
INSERT INTO bsc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Re ko: «Eƴamb ƴamb exëna ed an nang ex na.» ");
INSERT INTO bsc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na ɓësëfan ɓën këni w̃ëkarënd ba ala w̃ëlanëgu këŋo na eƴamb ƴamb. ");
INSERT INTO bsc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ata re ko Yesu: «Andiyen and ỹandi këŋo ar law̃ënëgu ke xali me eŋata aŋ ex eƴamb ƴamb iram in. ");
INSERT INTO bsc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ax gi ex na nde are kën rend opacaw̃ onax fo ɓayik ekana ed ɓeneɗa el? Awa ga re këme: Dënëtayin en wataxën ɓeneɗa ɓeŋ ga feŝëk gër ocënga. Ekana fo ɓayik. ");
INSERT INTO bsc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aŝos këno ŝosënd axana ar eneɗa end aniyan and din an eɓi nëngandëraxën andamat aneɗ an do gë axana an. ");
INSERT INTO bsc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gër endeƴ eŋo, enimin, ɗal ex: Aɓat kë neɗënd, aŝëxen kë xanand eƴamb el. ");
INSERT INTO bsc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wëno law̃ën këŋun en kana ɓeneɗa ɓeŋ gër ed an tëw̃ ex na. Ɓëŝëxen riyenik do wën, alil fo lil kënëɓi gër andiyen.» ");
INSERT INTO bsc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Yatijo, gër angol and Ɓësamari aŋo ɓëranjëm w̃a bax end Yesu eŋ ga wël këno asoxari an ga ko reƴa mëne afelëra felëra këŋo ɗek er ri ko gër aniyan andexëm in. ");
INSERT INTO bsc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɓësamari ɓën ga ɓarërëgu këni gër ed hi baxo Yesu, xara këno exo ɓayi yatijo gër angol andeɓën. Ga w̃a ko, xey këŋo ɓakey ɓaki. ");
INSERT INTO bsc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Në eŋo ỹëmbëraxën bani nëmëc ɓër w̃a bax eyeƴan edexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Afel bano felënd asoxari an: «Abo ex na ɗe ga w̃a këmi gayik wëj fel këɓo. Gë andeɓi aŋo dëŋ ɓaxët këmo do nang këmi mëne enimin, mëŋ ex Afexën ar ngwën an.» ");
INSERT INTO bsc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ga xucak ɓakey ɓaki ɓaŋo, Yesu xuca ko ond gër ebar ed Galile oŋ. ");
INSERT INTO bsc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mëŋ dëŋ reƴa bax mëne alaw̃ënel ar Kaxanu an, ano pëɓënd na gër ed rëw̃ këno. ");
INSERT INTO bsc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","And h̃at ko gër ebar ed Galile aŋ, Ɓëgalile ɓën xaca këno gayik awat wat bani ɗek ɓeɓër ri baxo gër Yerusalem ɓën, yatir Ofëna or Apexa. Ɓën ɓëte, aƴe ƴe bani gër ofëna olo. ");
INSERT INTO bsc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Awa Yesu ɓaka ko gër ingol ind Kana gër ebar ed Galile, gër ed nëngwët baxo men oŋ hik ngoƴ. Ata gër angol and Kafarënawum, ar ɓët bax gër emun an ŝëxwërayili baŋo na asëñiw̃. ");
INSERT INTO bsc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gogo nde ga wël ko mëne Yesu ɓakawëk gër Galile, ga xaniw ko gër ebar ed Yude. Ata w̃ara ko eŋo karaw end itox indexëm eŋ gayik në emëkw na fo ɓayi baxo. ");
INSERT INTO bsc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ata re ko Yesu: «Wën angëmëne ane watëlind na ɓecarax do gë ɓecërëcaxik, din ane kwëta na!» ");
INSERT INTO bsc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yaka këŋo ala ajo: «Axwën, cëlaye gër ndeɓi këdi ko nemi itox indam iŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Re ko Yesu: «Maỹil, asëñix anëka ɓëngw ko.» Ga w̃a ko er re ko Yesu in, w̃aỹi ko. ");
INSERT INTO bsc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ga ko ŝëla, fed këni gë ɓëriyenin ɓër gër iciw̃ indexëm ɓën. Fel këno mëne itox indexëm iŋ aɓëngw exo, anëka fak ko. ");
INSERT INTO bsc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","W̃ëka këɓi ba nand fe fak ko. Yaka këno: «Ganëka and hik eñan poxoŝ gaf aŋ, xoc këŋo.» ");
INSERT INTO bsc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ata xwita ko sëm mëne amëd aŋo dëŋ fel ɓaŋo Yesu itox indeƴ iŋ aɓëngw exo. Ata w̃a këni end Yesu eŋ mëŋ gë ekun edexëm el ɗek. ");
INSERT INTO bsc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eŋo bax ecarax ekinëm end ri baxo Yesu gër ebar ed Galile eŋ ga xaniw ko gër ed Yude. ");
INSERT INTO bsc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ga xucak eŋo, hik ɓëte ofëna or Ɓëŝëwif. Yesu ƴe ko ƴaŋ gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Xarak gër Yerusalem, ler gër Ebët ed Opeỹ, anjer hi bax na and bani w̃acënd gë eyeƴan ed Ɓëŝëwif el Betësada. Mokece xece bani do seɓa bani oɗilaya oco. ");
INSERT INTO bsc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ɗila gër oɗilaya oko bani renarand ɓëŝëxwëra ɓëranjëm: ɓëŝiw̃ëk, gë ɓëseỹik, gë ɓërëgoɓo. ");
INSERT INTO bsc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŝëf gër ɓëŝëxwëra ɓëjo, ala baxëna arëgoɓo elod ɓëniy ofëxw osas gë ɓënjongëɓëtas. ");
INSERT INTO bsc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ata Yesu wat këŋo gër ed laki ko. Ga wata ko mëne elod anëka fo ko lakirand na, w̃ëka këŋo: «Wëj, aỹandi nde ỹandi ki eƴ pak?» ");
INSERT INTO bsc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yaka këŋo: «Asoŝan, ame gi ex na gë ar ke lap polo gër anjer and kë ŝangënand men aŋ. Awa nand ke xacërand na, gogo nde exo cëgët aŝëxen.» ");
INSERT INTO bsc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ata Yesu re ko: «Kanil eƴ meɗ anakaya andeƴ aŋ, eƴ ƴe!» ");
INSERT INTO bsc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ataŋ ga fak ko ala ajo, w̃eɗ ko anakaya andexëm aŋ do ko ƴexërand ŝenene. Xarak yatijo akey and eteyëta bax. ");
INSERT INTO bsc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɓëlëngw ɓër Ɓëŝëwif ɓën këno rend ala ar fakëk an: «Xey wëj wa, ba ax gi ex na nde doro ex akey and eteyëta aŋ? Ax ñap ex na eƴ ɗëɓina anakaya andeƴ aŋ!» ");
INSERT INTO bsc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na yaka këɓi: «Ar fakën ke an fel ke ɗe me ɗëɓina anakaya andam aŋ do me ƴe.» ");
INSERT INTO bsc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","W̃ëka këno: «Noỹo wa ex ar fel ki eƴ meɗ anakaya andeƴ do eƴ ƴexëra an?» ");
INSERT INTO bsc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ar fakëk an axo nang bana ba noỹo ex do ɓëte Yesu anëka hi baxo ŝit gër amëxwër and hi bax na. ");
INSERT INTO bsc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ga xucak eŋo, Yesu sëk këŋo ala ajo gër yangana ir Aciw̃ and Kaxanu. Fel këŋo: «Awa gayikako anëka fak këƴ, teɓël emendëran el këdi ki wëcan end nëmëc eŋo.» ");
INSERT INTO bsc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aŋo ƴe ko ala ajo felëx këɓi ɓëlëngw ɓër Ɓëŝëwif ɓën mëne Yesu fakën këŋo. ");
INSERT INTO bsc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ata ɓëlëngw ɓër Ɓëŝëwif ɓën mëŋ bano rixëraxënënd Yesu gayik eŋo baxo rind yatir akey and eteyëta. ");
INSERT INTO bsc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu yaka këɓi: «Faba key yo key ko riyenind, wëno ɓëte mondako fo këme riyenind.» ");
INSERT INTO bsc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ata ɓëlëngw ɓër Ɓëŝëwif ɓën këni ŝaland eno ɗaw̃ Yesu, ga baxo rend cëŋ mëne Kaxanu ex Sëm, er w̃acaya bax mëne gwër fo hi këni gë Kaxanu. Ɓari ax gi ex na gayik aƴepën baxo ƴepënënd fo akey and eteyëta aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ata yaka këɓi Yesu: «Ɗal in këmun felënd, wëno Asëñiw̃ in ỹow̃eỹ ame dind na gë oñandi odam. Ɓarikan, er këmo watelind Faba in këme rind. Do ɗek er ko rind Faba in, mondako fo këme rind wëno Asëñiw̃ in. ");
INSERT INTO bsc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Faba ah̃an h̃an ke wëno Asëñiw̃ in do aw̃asin ke w̃asinënd ɗek ɓeɓër ko rind ɓën. Ɓëte aw̃asin ke w̃asin ɓeɓër nëmëcak ɓeŋo, ado wën aŝaran këŋun ŝaran. ");
INSERT INTO bsc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ata Faba ang këɓi xaninënd ɓëŝësëk do këɓi liyanënd ak, mondako fo këmo liyan wëno Asëñiw̃ in ar ỹandi ke an. ");
INSERT INTO bsc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ɓëte Faba, ala aŋo kitind na, wëno Asëñiw̃ in seɓën ke ɗek kiti iŋ ");
INSERT INTO bsc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ene pëɓaxën ɗek ang fëɓ këno mëŋ ak. Ar axe pëɓ ex na wëno Asëñiw̃ an, aŋo pëɓ ex na Faba, mëŋ ar law̃ënëgu ke an. ");
INSERT INTO bsc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ɗal in këmun felënd, ar ke ɓaxëtënd do eŋo kwëta ar law̃ënëgu ke an, anëka ŝot ko aniyan and din aŋ do axo ƴe na gër kiti. Anëka xuca ko ecës el, do h̃at ko gër aniyan. ");
INSERT INTO bsc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ɗal in këmun felënd, amëd aŋ në eƴow ex, (ado gërëgako dëŋ ex) ɓëŝësëk ɓën awël këni wël oniw̃ or Asëñiw̃ ar Kaxanu ol. Ɓër kë wël ɓën axani këni xani gër ecës do eni ɗiya. ");
INSERT INTO bsc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Enimin, ang exo Faba mëŋ dëŋ aniyan ak, mondako fo yël ke wëno Asëñiw̃ me gi wëno ɓëte aniyan aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wëno yël ke or gapak or mëni kitixën ɓela ol gayik wëno ex Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Këreŋun caran na eŋo: Në eƴow ex amëd and këni wël ɗek ɓër ex gër ɓañeg ɓën oniw̃ oram ol. ");
INSERT INTO bsc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ata eni kanira gër ecës: ɓër bax rind enjekax ɓën eni ƴe gër aniyan and din do ɓër bax rind eñëŋënax ɓën eni ƴe gër kiti. ");
INSERT INTO bsc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Faba, mëŋ ar law̃ënëgu ke an ke felënd ang këmëni xiti ɓela ak, ỹow̃eỹ ame dind na gë oñandi odam ok. Do kiti indam iŋ ind ŝenene ex gayik oñandi od ar law̃ënëgu ke ok këme ŝaland, ax gi ex na odam ok.» ");
INSERT INTO bsc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Angëmëne wëno fo kë reƴand osede or gaf iram ol, end këme reƴand eŋ ax gi ex na ɗal. ");
INSERT INTO bsc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aŝëxen kë reƴand osede oram ol, do anang nang këme, er ko reƴand endam in ɗal ex. ");
INSERT INTO bsc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wën law̃ën baɓi ɓela gër Ŝaŋ Batis. Ga h̃at këni, awël wël bano ga ko reƴa ɗal in. ");
INSERT INTO bsc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wëno cëŋ, end osede oram eŋ, ax gi ex ala kë reƴand, ɓarikan en pexaxën këmun felaxënënd eŋo. ");
INSERT INTO bsc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ŝaŋ, er hi baxo ang lambo ir fëtën këni ex ŋoɓand fo. Do wën anëngandëra nëngandëra këŋun amëd gë angoɓen andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wëno, osede or këme reƴand ol nëmëcak or Ŝaŋ Batis ol gayik ɓeɓër yël ke Faba me dind ɓën këŋun w̃asinënd mëne mëŋ dëŋ law̃ënëgu ke. ");
INSERT INTO bsc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Do Faba mëŋ ar law̃ënëgu ke an dëŋ kë reƴand endam eŋ. Wën, elod an wël ex na oniw̃ orexëm ol, elod an wat ex na dëxas irexëm in. ");
INSERT INTO bsc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Gayikako an ma ex na end wëno ar law̃ënëgu ke eŋ, an kwëtaya ex na eyeƴan edexëm el gër ow̃ëkw orewën. ");
INSERT INTO bsc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Wën kën ɓalëkënalind Oñëgw Omënëk ok ga yëla kën mëne aniyan and din aŋ kën ŝot, xarak oñëgw oko dëŋ kë reƴand endam eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wën aŋun ñandi ex na en yëlaya gër ndam en cotaxën aniyan and din aŋ! ");
INSERT INTO bsc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Wëno ame caland na ene cëkw ɓela. ");
INSERT INTO bsc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ɓari aye nang këme mëne wën ano ŋan ex na Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wëno mëŋ law̃ënëgu ke gë ow̃ac orexëm ol, ɓari wën ane kwëtaya ex na. Ɓarikan angëmëne aŝëxen exo ƴow axwëtaya këno xwëtaya xarak Kaxanu aŋo ɗaw̃ënëguw ex na! ");
INSERT INTO bsc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wën ɓër kë ŝëkwërënd ɓëjo, wën ɓër ax caland na en wat enjaran end Kaxanu fo ɓën, mondake wa kën xor ene kwëta? ");
INSERT INTO bsc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Këren yëla na mëne wëno këŋun lëxw gër Faba. Moyis, mëŋ ar xwëta këno an, këŋun lëxw. ");
INSERT INTO bsc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kido end Moyis eŋ w̃a ban, aw̃a w̃a don ɓëte endam eŋ gayik endam ỹëgw ko. ");
INSERT INTO bsc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɓari angëmëne an ma ex na oñëgw odexëm ok, mondake kën w̃a er këme rend in?» ");
INSERT INTO bsc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ga xucak eŋo, Yesu xegëta ko anjer and Galile and bani w̃acënd ɓëte anjer and Tiberiyad aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɓela ɓëranjëm ɓaŋo sëfand gayik awat bani watënd ɓecarax, ga baɓi fakën ɓëŝëxwëra ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ata Yesu, ga sëfër këni gë ɓësëfan ɓën ƴaŋ në etënd, ỹëparax këni ");
INSERT INTO bsc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","xarak anëka baɓi saxëgund Ofëna or Apexa or Ɓëŝëwif ol. ");
INSERT INTO bsc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu ga nëkona ko, wat këɓi amëxwër atëm ga këni ƴow gand ed hi bani. Ata w̃ëka këŋo Filip: «Feye wa këne yëcëguye er këni ƴamb ɓela ɓëjo in?» ");
INSERT INTO bsc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ga baŋo w̃ëkand mondako, atëƴ fo baŋo rind gayik anang nang baxo er ko ri in. ");
INSERT INTO bsc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ata yaka ko Filip: «Ado ene yëcëgudoye yo mburu iŋ ɓatama ɓand koɗi okeme oki, exo cotaxën ala kala tëkër, ax gi dona gwac.» ");
INSERT INTO bsc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Asëfan aɓat, Andëre, aɓinëm ar Simoŋ Piyer, re ko: ");
INSERT INTO bsc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ake ro inëmëta exëna ɗe ind gë ɓamburu ɓanjo ɓand orëŝ, gë oxan oxi. Ine ngwa kë feca, ɓela ɓër go ɓën?» ");
INSERT INTO bsc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ata re ko Yesu: «Pelinëɓi eni ñëpara gër ebar.» Xarak na gër ed ebani mbaŋ lëg bax ondës oŋ. Er hi bani ɓësoŝan ɓën fo gwër në owëli oco. ");
INSERT INTO bsc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu, ga w̃eɗ ko ɓamburu ɓaŋ, ŝëkwa këŋo Kaxanu do ŝetëra këɓi ɓër hi bax na ɓën. Mondako fo ri baxo gë oxan ol do ar ex kala ƴamb ko xali w̃ed ko. ");
INSERT INTO bsc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","And w̃ed këni aŋ, fel këɓi ɓësëfan ɓën: «Ɓarin ɓacaxaken ɓand ɓayitarak ɓaŋ, ỹow̃eỹ kërex nemi na.» ");
INSERT INTO bsc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ata ga ɓarëra këni, fëxw këɓi ɓakange epëxw gë ɓaki gë ɓacaxaken ɓand mburu ir orëŝ ir ɓayitara baɓi in. ");
INSERT INTO bsc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ga wat këni ecarax end ri baxo Yesu eŋ, ɓela ɓën këni rend: «Enimin, mëŋ ex alaw̃ën ar bax ƴowënd gër ngwën ro an.» ");
INSERT INTO bsc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ata Yesu, ga wata ko mëne aỹandi ỹandi baɓi eno nëỹali exo gi emun endeɓën, nacëta ko gaŝëxe gaɓat ƴaŋ gër etënd. ");
INSERT INTO bsc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Apenëka aŋ, ɓësëfan ɓërexëm ɓën ŝëla këni xali gër ɓëŋa ir anjer. ");
INSERT INTO bsc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ata fëra këni polo në ikuluŋ eni ƴexën gër Kafarënawum, ekeg elo. Anëka xwëyar bax do Yesu aɓi tëfëgu bana pere. ");
INSERT INTO bsc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mbaŋ bax xocënd do men oŋ kë xanind gër anjer ɓomeŋ ɓomeŋ. ");
INSERT INTO bsc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ga xas këni gë ikuluŋ iŋ në ɓapakan ɓanjo, xali ɓanjongamat, watëgu këno Yesu ga ko ƴe ƴaŋ gër men ang gër ebar eŋaỹëk fo. And hi ko ɗam gër ikuluŋ aŋ, ɓësëfan ɓën yëdara këni. ");
INSERT INTO bsc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ata re ko Yesu: «Wëno ex, këren yëdara na!» ");
INSERT INTO bsc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aỹandi ỹandi baɓi ɓësëfan ɓën eno mëlali gër ikuluŋ iŋ. Ɓarikan anëka h̃at bani gër ebar, gër ɓëŋa ir gër ed bani ƴend. ");
INSERT INTO bsc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Në ecan ijo, amëxwër and ɓër ɓayi bax ekeg elo aŋ, xaman këni mëne ikuluŋ imat fo ɓayi bax na gër ed hi bani do mëne Yesu ani ƴe bana gë ɓësëfan ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ata ɓëkuluŋ ocëxe h̃atëguk gër Tiberiyad, ler na gër ed ƴambëra bani mburu ind ỹëmbën baxo Axwën an and ŝëkwa këŋo Kaxanu aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ga wata këni mëne Yesu gë ɓësëfan ɓërexëm ɓën ani bo bana na, fëra këni gër ɓëkuluŋ ɓëŋo do kwël ƴe këni gër Kafarënawum eno calax. ");
INSERT INTO bsc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ga sëkëx këno ekeg elo, w̃ëka këno: «Asëƴali, nand fe wa ƴow këƴ ro?» ");
INSERT INTO bsc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu yaka këɓi: «Ɗal in këmun felënd, ga ƴambëra kën xali w̃ed kën këne ŝalaxënënd, ax gi ex na ga fëni këŋun ɓecarax ɓend këme rind ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Diyenindën end eƴamb ed kë ɓayi xali gër aniyan and din eŋ, ɓari ax gi ex na end eƴamb ed kë nemi ecan ecan eŋ. Eƴamb ed aniyan and din el, wëno Asëñiw̃ ar ala an kë yëlënd gayik wëno yata ke Faba Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɓër gër amëxwër ɓën w̃ëka këno: «Inew̃a ỹapëk mo din Kaxanu gër andiyen andexëm?» ");
INSERT INTO bsc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yaka këɓi: «Er ex andiyen and Kaxanu in, ene kwëta wëno ar law̃ënëgu ke an.» ");
INSERT INTO bsc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","W̃ëka këno ɓëte: «Do ecarax end fe këƴëɓo w̃asin mi kwëtaxën? Ine këƴ ri?» ");
INSERT INTO bsc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ɓëxarëk ɓëreɓi ɓën eƴamb ed bani w̃acënd man el bani ƴambënd gër ladawe, ang ỹeg këni ak: eƴamb ed xaniwëk gër orën el baɓi yëlënd Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ata re ko Yesu: «Ɗal in këmun felënd, Faba baɓi yëlënd eƴamb ed ɗal ed xaniwëk gër orën el ɓëxarëk ɓërewën ɓën, ax gi ex na Moyis. Mëŋ fo këŋun yëlënd ɓëte doro doro eƴamb ed ɗal ed xaniwëk gër orën el. ");
INSERT INTO bsc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gayikwa eƴamb ed ko yëlënd Kaxanu el ex ar fedawëk gër orën an, do ko yëlënd aniyan gër ngwën ro an.» ");
INSERT INTO bsc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ata re këni: «Awa Axwën, yëlindëɓo ngwa din eƴamb elo.» ");
INSERT INTO bsc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu fel këɓi: «Wëno ex eƴamb ed kë yëlënd aniyan el. Ar ke sëf an din aŋo kor na enjo eŋ, ar kë w̃a endam an din aŋo tel na. ");
INSERT INTO bsc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ga re këme, wën awat wat këne, ɓari ane kwëta ex na. ");
INSERT INTO bsc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɗek ɓër ke yël Faba ɓën asëf këne sëf do din amëni ŋw̃aỹ na. ");
INSERT INTO bsc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gayikako gër orën fedaw këme, er ƴow këme me dind oñandi od ar law̃ënëgu ke ok, ax gi ex na me dind oñandi odam. ");
INSERT INTO bsc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Er ỹandi këŋo ar law̃ënëgu ke in ex gaɓatak këremo tak na gër ɓër yël ke: axanin këmo xaninëɗ gër ecës yatir akey apelatar. ");
INSERT INTO bsc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eŋo ex enimin, er ỹandi këŋo Faba in: ar ke wat yo wëno Asëñiw̃ do exe kwëta an aŝot ko ŝot aniyan and din aŋ. Ata këmo xanin gër ecës, yatir akey apelatar.» ");
INSERT INTO bsc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ata Ɓëŝëwif ɓën këni wunëwunand endexëm eŋ ga wël këno ga ko re mëne mëŋ ex eƴamb ed fedawëk gër orën el. ");
INSERT INTO bsc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Er bani rend: «Ajo ba axo gi ex na nde ngwa Yesu, asëñiw̃ ar Yosef? Ax gi ex na nde anang nang kënëɓene nëm gë sëm? Mondake cëŋ ko rend mëne gër orën fedaw ko?» ");
INSERT INTO bsc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu ga wata këɓi, re ko: «Këren ŋunëŋuna na. ");
INSERT INTO bsc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ala ax kor na exo yëlaya gër ndam, ang ax gi ex na Faba, mëŋ ar law̃ënëgu ke an, w̃ëlaw këŋo. Do wëno ata këmo xanin gër ecës, yatir akey apelatar. ");
INSERT INTO bsc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ga ỹëgw këni wa ɓëlaw̃ënel ɓën gër okayëta mëne: Kaxanu këɓi ỹana eɓi tëƴalind ɗek ɓela ɓën. Ar kë ɓaxët osëƴali orexëm an do exo ma, ayëlaya ko yëlaya gër ndam. ");
INSERT INTO bsc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Eŋo ax macaya ex na mëne ala wat këŋo na Faba Kaxanu, ang ax gi ex na ar xaniwëk gër ndexëm an. ");
INSERT INTO bsc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ɗal in këmun felënd, ar w̃ak endam an ŝotëk aniyan and din aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wëno ex eƴamb ed kë yëlënd aniyan el. ");
INSERT INTO bsc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ɓëxarëk ɓërewën ɓën ƴambëguk eƴamb ed këni w̃acënd man el gër ladawe, ɓarikan aŝës ŝës këni. ");
INSERT INTO bsc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nangin mëne ar kë ƴamb eƴamb ed fedawëk gër orën an, axo nemi na. ");
INSERT INTO bsc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wëno ex eƴamb eɓëngw ed ŝëlawëk gër orën el. Angëmëne ala exo ƴamb eƴamb elo, din ir din ko liya, do eƴamb ed këmo yël el ex eman endam eŋ exo ɗiyaxën gër ngwën ro.» ");
INSERT INTO bsc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ga wël këno, Ɓëŝëwif ɓën këni ŝampërend: «Mondake wa ko xor eɓo yël eman endexëm eŋ ene ƴambe?» ");
INSERT INTO bsc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Na re ko Yesu: «Iyo ɗal in këmun felënd: angëmëne an ƴamb ex na eman end wëno Asëñiw̃ ar ala eŋ do an ceɓ ex na oŝat oram oŋ, aniyan ax gi ex na gër ola orewën. ");
INSERT INTO bsc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ar kë ƴamb eman endam do exo ceɓ oŝat oram an kë ŝot aniyan and din aŋ do wëno axanin këmo xaninëɗ gër ecës, yatir akey apelatar. ");
INSERT INTO bsc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Enimin, eman endam eŋ eƴamb ex do oŝat oram oŋ eŝeɓ-ceɓ ex. ");
INSERT INTO bsc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ar kë ƴamb eman endam do exo ceɓ oŝat oram an ke ŝosa do mi gi din araɓat. ");
INSERT INTO bsc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Faba mëŋ ar law̃ënëgu ke an aɓëngw exo do wëno gë mëŋ liya këme. Ar ke ƴamb an gë wëno këmi liya. ");
INSERT INTO bsc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nëkoyin ro eƴamb ed fedawëk gër orën el, ax gi ex na ang ed ƴambëgu këni ɓëxarëk ɓërewën do nemira këni el. Ar ke ƴamb an din ir din ko liya». ");
INSERT INTO bsc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mondako sëƴali baɓi Yesu gër aciw̃ acaleya and gër Kafarënawum. ");
INSERT INTO bsc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ga ɓaxët këno na, ɓësëfan ɓëranjëm gër ɓër ɓaŋo sëfarand re këni: «Eyeƴan elo ɗek siɓëk. Ba noỹo kë xor cëŋ exo ɓaxët?» ");
INSERT INTO bsc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu, ga wata ko mëne ɓësëfan ɓën në eŋunëwuna exëni, w̃ëka këɓi: «Ba end re këme eŋ nde ŝoɗo këŋun? ");
INSERT INTO bsc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Do and këne wat, wëno Asëñiw̃ ar ala an ga këme ɓaka ƴaŋ gër ed hi bame aŋ cëŋ? ");
INSERT INTO bsc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Angoc aŋ kë yëlënd aniyan aŋ, eman eŋ ỹow̃eỹ ax kor na ex di. Ɓend fel këmun ɓeŋo ɓend Angoc ex do ɓeŋo kë yëlënd aniyan aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ɓari ang hi kën ro ako, ɓërëmar ane kwëta ex na.» Gayikwa Yesu aye nang baɓi, elod gër ỹanar ɓër ax ma ex na endexëm ɓën. Ɓëte anang nang baxo noỹo bax ar këŋo lëxw an. ");
INSERT INTO bsc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ata ko rend: «Mëŋ këmun felaxënënd mëne ala ax ƴow na gër ndam ang ax gi ex na Faba w̃ëlaw këŋo.» ");
INSERT INTO bsc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ata elod amëd aŋo, ɓësëfan ɓërexëm ɓëranjëm ɓakana këni gand epoƴ, seɓ këni etëfëra edexëm el. ");
INSERT INTO bsc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ata Yesu w̃ëka këɓi ɓësëfan epëxw gë ɓëxi ɓën: «Do wën cëŋ, aŋun ñandi ex na nde ene teɓ?» ");
INSERT INTO bsc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yaka ko Simoŋ Piyer: «Axwën, ɓiyi gër noỹo wa këmi ƴe? Wëj ga ex wa ar gë eyeƴan ed aniyan and din ir din an. ");
INSERT INTO bsc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Do ɓiyi w̃ak endeƴ eŋ ga nang këmi mëne wëj ex Aw̃ënëk ar Kaxanu an.» ");
INSERT INTO bsc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu yaka këɓi: «Ax gi ex na nde wëno yata këŋun, wën ɓësëfan epëxw gë ɓëxi ɓën? Ɓarikan, aɓat ŝaɓucara exo!» ");
INSERT INTO bsc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yuda, asëñiw̃ ar Simoŋ Isëkariyot, ɓaŋo rend gayikwa gër ɓësëfan epëxw gë ɓëxi, mëŋ ebax ar këŋo lëxw an. ");
INSERT INTO bsc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ga xucak eŋo, Yesu ko sëfërand ebar ed Galile el. Aŋo ñandi bana exo ƴe gër ed Yude gayik ɓëlëngw ɓër Ɓëŝëwif ɓën aŝala bani ŝaland eno ɗaw̃. ");
INSERT INTO bsc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Xarak, ɗam ebax Ofëna or Ɓëŝëwif or ɓaner ol. ");
INSERT INTO bsc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ata ɓoɓinëm ɓor Yesu re këni: «Kanil eƴ ƴe gër ebar ed Yude eni watëx ɗek ɓësëfan ɓëreƴ ɓën ɓeɓër këƴ rind ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ar kë ŝaland eno nang ɓela an, axo dind na ɓeỹ gër ed ano watënd na. Angëmëne ɓecarax ɓeŋo këƴ rind, masiyanal gër ngwën ro.» ");
INSERT INTO bsc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Enimin ɓoɓinëm dëŋ ano kwëta bana. ");
INSERT INTO bsc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ata Yesu yaka këɓi: «Apëxëd andam aŋ ax ŋatëgu ex na pere, ɓarikan andewën aŋ and din ex. ");
INSERT INTO bsc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɓela ɓër gër ngwën ro ɓën ani kor na enun cus. Ɓarikan aŝus ŝus këne wëno gayik areƴa këme reƴand mëne ɓandixa ɓandeɓën ɓaŋ ɓañëŋënax ex. ");
INSERT INTO bsc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ƴeyin ngëŋ wën ƴaŋ gër ofëna. Wëno ame ƴe na gër ofëna olo gayik apëxëd andam aŋ ax ŋat ex na pere.» ");
INSERT INTO bsc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","And re ko eŋo aŋ, Yesu ɓayi ko gër ebar ed Galile. ");
INSERT INTO bsc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","And ƴe këni ɓoɓinëm gër ofëna aŋ, Yesu ƴe ko ɓëte yir fo, aŋo ñandi bana eno wat ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ata ɓëlëngw ɓër Ɓëŝëwif ɓën këno ŝalarand gër ofëna do këni w̃ëkarënd: «Awa feye exo ajo?» ");
INSERT INTO bsc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ata gër ɓëmëxwër, onëkënëkar od në endexëm ok mbaŋ ebax. Ɓërëmar are bani rend: «Ala ar ŝenene exo.» Ɓëŝëxen ɓën: «Ali anambeli këɓi nambelind ɓela ɓën!» ");
INSERT INTO bsc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ɓari ala abax yeƴan na poyoma endexëm eŋ, ga banëɓi yëdand ɓëlëngw ɓër Ɓëŝëwif ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Anëka hi bax loxo ir ofëna in mërëxand and ƴe ko Yesu ƴaŋ gër Aciw̃ and Kaxanu aŋ, gër ed baɓi sëƴalirand ɓela. ");
INSERT INTO bsc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ata ɓëlëngw ɓër Ɓëŝëwif ɓën, ga këɓi ŝaran, këni w̃ëkarënd: «Mondake nang ko Oñëgw Omënëk ok mëŋ ar ax tëƴa ex na an.» ");
INSERT INTO bsc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ata yaka këɓi Yesu: «Osëƴali oram ol, or ar law̃ënëgu ke ex, ɓari ax gi ex na oram. ");
INSERT INTO bsc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ar ex aw̃elëk ar exo di oñandi od Kaxanu an, anang ko nang osëƴali oram ol, ba gër Kaxanu nde xaniwëk ba wëno fo nde kë yeƴandërand. ");
INSERT INTO bsc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ar kë yeƴandërand er yerëtëk ko gë andexëm an, eno cëkwënd ko ŝaland. Ɓarikan, ar kë ŝaland enjaran end ar law̃ënëgu këŋo an, ar ɗal hi ko do osëmbak ax gi ex na gër ndexëm. ");
INSERT INTO bsc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ax gi ex na nde Moyis yël këŋun acariya and Kaxanu aŋ? Ɓarikan wën, gaɓatak ax tëfënd na acariya aŋo. Inew̃a kën ŝalaxënënd ene ɗaw̃?» ");
INSERT INTO bsc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ata amëxwër aŋ yaka këno: «Wëj ar gë ɓëyël eƴ! Noỹo kë ŝaland exi ɗaw̃?» ");
INSERT INTO bsc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu yaka këɓi: «Emat fo ri këme do wën ɗek ŝarandëra këŋun. ");
INSERT INTO bsc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyis sëƴali këŋun oxac or ɓëtox ɓëtoŝan ol, (xarak ax gi ex na Moyis yerëtëk gayikako gër ɓëxarëk xaniwëk). Do ax gi ex na nde wën axac këno xacënd ala an yatir akey and eteyëta dëŋ? ");
INSERT INTO bsc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Angëmëne axac këno xacënd ala yatir akey and eteyëta këdi kën ƴepën acariya and Moyis aŋ, inew̃a xoỹënaxën këne wëno ar fakën këŋo yer ala an gë akey and eteyëta aŋ? ");
INSERT INTO bsc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Teɓin ekiti ed ɓela el ang këŋun wëndanënd wën ak. Kitiyindën ŝenene!» ");
INSERT INTO bsc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ata Ɓëyerusalem ɓërëmar këni rend: «Ax gi ex na nde ajo këno ŝaland eno ɗaw̃? ");
INSERT INTO bsc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ɓarikan nëkoɗo wa ga ko yeƴandërand poyoma, do ala aŋo kexënd na! Anëka nde xwita këno ɓëlëngw ɓën mëne mëŋ dëŋ ex Afexën an? ");
INSERT INTO bsc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ɓarikan, ajo ro anang nang këne gër ed xaniw ko. Xarak Afexën an and ko ƴow aŋ, ala ax nang na gër ed xaniw ko.» ");
INSERT INTO bsc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ata Yesu, ga këɓi sëƴalira ɓela ɓën gër yangana ir Aciw̃ and Kaxanu, xeỹ ko: «Wën anang nang këne do anang nang kën gër ed xaniw këme! Ɓarikan wëno ame ƴow ex na gë oñandi odam. Ar law̃ënëgu ke an ɗal exo, ɓari ano nang ex na. ");
INSERT INTO bsc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wëno anang nang këmo, gayikwa gër ndexëm xaniw këme, do mëŋ law̃ënëgu ke.» ");
INSERT INTO bsc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɓela ɓën këni ŝaland eno tëra, ɓari gaɓatak aŋo tëra bana gayik ax ŋat bana pere apëxëd andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ata gër amëxwër, ɓëranjëm w̃a këni end Yesu eŋ do këni rend: «And ko ƴow Afexën aŋ, ɓecarax ɓend ko ri ɓeŋ anëmëca nde kë nëmëca ɓend ajo ɓeŋ?» ");
INSERT INTO bsc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ofariseŋ ok wël kënëɓi ɓëranjëm gër amëxwër ga këni nëkënëkar end Yesu eŋ. Ata ɓëŝaɗaxan ɓëlëngw ɓën do gë Ofariseŋ ok law̃ën kënëɓi ɓënëkona ɓën eno tëraw. ");
INSERT INTO bsc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ata re ko Yesu: «Në ereɓat ɓayi këne pere imëd, me ɓakaxën gër ar law̃ënëgu ke. ");
INSERT INTO bsc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aŝalara këne ŝalara ɓari ane wat na. Do gër ed këme hi, wën an kor na en ƴeli.» ");
INSERT INTO bsc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ata këni w̃ëkarënd Ɓëŝëwif ɓën: «Feye ngwa ko ƴe do enëŋo neme? Aƴe nde ko ƴe ed ŝapërëra këni Ɓëŝëwif gër ɓër enëng ecëxe, eɓi tëƴalirax ɓër ani gi ex na Ɓëŝëwif ɓën? ");
INSERT INTO bsc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ine ngwa w̃acayak eyeƴan ed wëleli kënëŋo elo: “Aŝalara këne ŝalara ɓari ane wat na. Do gër ed këme hi, wën an kor na en ƴeli.”» ");
INSERT INTO bsc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yatir akey apelatar and ofëna ebax akey atëm aŋ. Ata Yesu, ga xani ko xwiriŝ, xeỹ ko: «Ar sel këŋo an, ƴowëlexo mo yël exo ceɓ. ");
INSERT INTO bsc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ar ke xwëta an, men ond këmo yël oŋ ang oỹëm or men ond aniyan fo kë ỹana ex pesënd gër yomb irexëm, ang rek Oñëgw Omënëk ak.» ");
INSERT INTO bsc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","End Angoc and Kaxanu and ebax eni cot ɓër këŋo xwëta eŋ baxo yeƴanënd mondako. Amëd aŋo, Angoc aŋ axo ƴow bana pere gayik ax ŋat bana and kë ŝanaya enjaran end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɓërëmar gër amëxwër ga wël këni er baxo yeƴanënd in, këni rend: «Enimin, ajo ex Alaw̃ënel an.» ");
INSERT INTO bsc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɓëjo këni rend: «Ajo ex Afexën an!» Ɓëŝëxen re këni: «Ba gër ebar ed Galile nde ebax exo kaniw Afexën an? ");
INSERT INTO bsc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ax gi ex na nde Oñëgw Omënëk dëŋ rek mëne Afexën an ar andëw̃ëra and Dafid ko hi do ar gër Betëlexem, angol and Dafid aŋ?» ");
INSERT INTO bsc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ata ɓër gër amëxwër ɓën xucarëra këɓi në end Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɓërëmar aỹandi ỹandi baɓi eno tëra, ɓari gaɓatak ax yëxw bana eŋo. ");
INSERT INTO bsc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɓënëkona ɓën, ga ɓaka këni gër ɓëŝaɗaxan ɓëlëngw do gër Ofariseŋ, w̃ëkax kënëɓi: «Ine cëŋ ɓayik ano mëlaw ex na?» ");
INSERT INTO bsc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yaka këni ɓënëkona ɓën: «Ar kë yeƴanënd mondako, ɓiyi elod amo wël ex na.» ");
INSERT INTO bsc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ata yaka kënëɓi Ofariseŋ ok: «Wën ɓëte, anëka nde seɓ këno eŋun nambeli? ");
INSERT INTO bsc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Awat nde wat këno alëngw ar Ɓëŝëwif ba fariseŋ ir w̃ak endexëm? ");
INSERT INTO bsc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɓari amëxwër aŋo, ɓër w̃e këɓi exëni, ani nang ex na acariya and Moyis aŋ!» ");
INSERT INTO bsc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ata Nikodem, ar ƴe bax gëmëɗ eni watër gë Yesu an, w̃ëka këɓi: ");
INSERT INTO bsc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Acariya andeɓi aŋ, anëp nde këŋo nëpënd ala xarak ɓëxiti ɓën ano ɓaxët ex na pere do ani nang ex na pere er ri ko in?» ");
INSERT INTO bsc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yaka këno: «Agalile nde hi këƴ wëj ɓëte? Calal aye ata këƴ wat mëne alaw̃ënel gaɓatak ax kaniw ex na gër ebar ed Galile.» ");
INSERT INTO bsc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ata ga xucak eŋo, ala kala w̃aỹi ko gër iciw̃ indexëm. ");
INSERT INTO bsc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ga xucak eŋo, Yesu ƴe ko ƴaŋ gër etënd ed gë ɓañarëka. ");
INSERT INTO bsc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ɓarikan mopëɗ gëɓër, ga ɓaka ko gër Aciw̃ and Kaxanu, ɓarërëgu këni ɗek ɓulunda in. Ga ỹëpa ko, këɓi sëƴalirand. ");
INSERT INTO bsc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ata ɓëŝalen do gë Ofariseŋ sëraw këno asoxari ar fënga këno në orekar. ");
INSERT INTO bsc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ga xwëŝan këno mërëxand, re këni: «Asëƴali, asoxari ajo në orekar fëngaw këmo. ");
INSERT INTO bsc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Acariya and Moyis aŋ ga rek mëne ɓësoxari ɓërako ɓën mopëtëra ỹap këɓi xali eni cës. Awa wëj ake re këƴ?» ");
INSERT INTO bsc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ga re bani eŋo, atëƴ bano rind eno nagaŝanaxën. Ɓarikan Yesu rëngw ko do ko ỹëgwënd gë imasa iŋ gër ebar. ");
INSERT INTO bsc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ga këno nëỹali eɓi pel ang këni ri ak, Yesu ga rëngwëta ko, re ko: «Ar gë eñëŋënax këm an, ñanaleŋo epët el.» ");
INSERT INTO bsc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Rëngw ko gaŝëxe do ko ỹëgwënd ɓëte gër ebar. ");
INSERT INTO bsc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","And wël këni eyeƴan elo aŋ, ŝapërëra këni aɓat aɓat, ga ỹana këni ɓëxarëk ɓën. Ɓayi këni Yesu gë asoxari an na gër ed xwëŝan bano mërëxand. ");
INSERT INTO bsc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ata rëngwëta ko Yesu, w̃ëka këŋo asoxari an: «Oko feye exëni ɓër baxi lëxwënd ɓën? Ala axi nëp ex na nde?» ");
INSERT INTO bsc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yaka ko asoxari an: «Axwën, gaɓatak axe nëp ex na!» Ata re ko Yesu: «Wëno ɓëte ami nëp na. Maỹil, ɓëte din këreƴ mendëra na mondako.» ");
INSERT INTO bsc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu, ga ɓakan ko osëƴali ol, ko rend: «Wëno ex angoɓen and ngwën aŋ, ar ke sëf an angoɓen and kë w̃ëland gër aniyan aŋ ko ŝot, din axo gi na gër ecamëɗan.» ");
INSERT INTO bsc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ga wël këni eŋo, Ofariseŋ ok re këni: «Awa wëj gë andeƴ këƴ reƴand osede oreƴ ol, do osede olo ax gi ex na ɗal.» ");
INSERT INTO bsc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ata Yesu yaka këɓi: «Aỹap ỹapëk ene kwëta ado ga këme reƴand gë andam aŋo dëŋ er eme in. Osede oram ol ɗal ex gayikwa wëno anang nang këme gër ed xaniw këme do gër ed këme ƴend. Ɓari wën, an nang ex na gër ed xaniw këme, ɓëte an nang ex na gër ed këme ƴend. ");
INSERT INTO bsc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wën ɓela fo hi kën do këne xitind. Wëno ala amo kitind na. ");
INSERT INTO bsc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Do angëmëne wëno xiti këŋo ala an, kiti iŋo ind ɗal kë hi gayik ame gi ex na gaɓat: gë Faba, mëŋ ar law̃ënëgu ke an, ɓar këmi. ");
INSERT INTO bsc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aỹëgw ỹëgw këni gër acariya andewën mëne osede or këni reƴa ɓela ɓëxi ɓëjo ɗal ex. ");
INSERT INTO bsc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wëno dëŋ kë reƴand osede or hi këme ol do ɓëte Faba, mëŋ ar law̃ënëgu ke an, në edeƴa exo endam eŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ata w̃ëka këno: «Feye ngwa hi ko sorix?» Yaka këɓi: «Wën ane nang ex na wëno, ɓëte ano nang ex na Faba. Kido anang nang bane, anang nang dono Faba.» ");
INSERT INTO bsc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mondako felëra baɓi Yesu ga këɓi sëƴali ler gër akwëtaya and oyël, gër yangana ir Aciw̃ and Kaxanu. Ɓari gaɓatak aŋo tëra bana gayik ax ŋat bana pere apëxëd andexëm aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu fel këɓi ɓëte: «Ga këme ƴend ako, wën aŝalara këne ŝalara ɓari ane wat na. Awa eñëŋënax endewën eŋ këŋun nemin. An kor na ene tëfëli gër ed këme ƴend.» ");
INSERT INTO bsc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na Ɓëŝëwif ɓën këni rend: «Ga ko rend ako ane kor ex na enëŋo tëfe gër ed ko ƴend, ba alaw̃aya nde ko law̃aya?» ");
INSERT INTO bsc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ata re ko Yesu: «Wën ɓër gëɗ ro hi kën, wëno ar ƴaŋ hi këme, ame gi ex na ar ngwën iŋo ro. ");
INSERT INTO bsc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mëŋ felaxën këmun mëne ɓeñëŋënax ɓendewën ɓeŋ këŋun nemin. Angëmëne an kwëta ex na mëne Wëno ex ar hi këme an, ɓeñëŋënax ɓendewën ɓeŋ këŋun nemin.» ");
INSERT INTO bsc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ata w̃ëka këno: «Do wëj, noỹo ngwa hi këƴ?» Yaka këɓi Yesu: «Ax gi ex na nde elod gër ỹanar felëra këmun? Ado në end inew̃a ngwa këmun yakaxën? ");
INSERT INTO bsc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wëno ɓeɓëranjëm reƴadome endewën eŋ mun kitixën. Ɓarikan, ar law̃ënëgu ke an kë reƴand ɗal in do er wëleli këmo in këme reƴand gër ngwën ro.» ");
INSERT INTO bsc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓela ɓën aɓi pëni bana mëne end Sëm Kaxanu eŋ baɓi felërand mondako. ");
INSERT INTO bsc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ata re ko Yesu: «And këne xaw̃ wëno Asëñiw̃ ar ala aŋ, ata kën nang mëne wëno hik do ỹow̃eỹ ame dind na gë or gapak oram. Er këmun felënd in, Faba sëƴaliw ke. ");
INSERT INTO bsc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wëno gë ar law̃ënëgu ke an ɓar këmi, axe teɓ ex na gaɓat gayik wëno din këme rind er h̃an ko in.» ");
INSERT INTO bsc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ga wël këni eyeƴan elo, ɓëranjëm w̃a këni endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ata Yesu fel këɓi Ɓëŝëwif ɓër w̃a bax endexëm ɓën: «Ga xwëtaya xwëtaya kën gër onden ondewën er këme sëƴalind in, ata kën hi enimin ɓësëfan ɓëram. ");
INSERT INTO bsc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Anang kën nang ɗal in do ɗal ijo këŋun racët gër oxaɗëp.» ");
INSERT INTO bsc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ata yaka këno: «Ɓiyi ɓërandëw̃ëra and Abëraxam ɓën nde këƴëɓo rend aracët këƴëɓo racët gër oxaɗëp? Ɓiyi elod ami gi ex na okaɗëp, mondake cëŋ këƴ xorënd eƴ de: “Ɓër ƴaƴa kën hi”?» ");
INSERT INTO bsc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu yaka këɓi: «Ɗal in këmun felënd, ar kë w̃endërand yo xaɗëp ir eñëŋënax hi ko. ");
INSERT INTO bsc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ar hik asëñiw̃ an kë ɓayind laŋ gër ekun ed rëw̃ këno. Ɓari xaɗëp in axo bond na din. ");
INSERT INTO bsc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Awa angëmëne wëno Asëñiw̃ ar Kaxanu an racët këŋun gër oxaɗëp, ɓëtëdin an bo na okaɗëp. ");
INSERT INTO bsc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Anang wa nang këme mëne wën ɓërandëw̃ëra and Abëraxam hi kën. Ɓarikan në ecalane ene ɗaw̃. Eyeƴan edam el xeƴ këŋun en kwëtaya. ");
INSERT INTO bsc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wëno, er watëgu këme gër Faba in këmun felënd. Do wën, kën rind er wël kën gër sorix irewën in.» ");
INSERT INTO bsc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yaka këno: «Abëraxam ex ɗe, axarëk areɓi an.» Ata re ko ɓëte Yesu: «Angëmëne oɓaŝ or Abëraxam hi kën, diyindën ɓeɓër baxo rind ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ɓarikan gërëgako, wën në ecalan ene ɗaw̃, wëno ar fel këŋun ɗal ir wëlëgu këme gër Kaxanu an. Eŋo, Abëraxam elod axo di ex na. ");
INSERT INTO bsc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wën, ɓeɓër wateli këno sorix irewën ɓën kën rind.» Ata yaka këno: «Ɓiyi ami gi ex na ɗe oɓaŝ or rëw̃ kënëɓi në asëk alakirand fo; Kaxanu gaɓat ex Faba ireɓi.» ");
INSERT INTO bsc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ata re ko Yesu: «Kido Kaxanu ebax Sorix irewën, ah̃an h̃an done gayik gër ndexëm ŝanëgu këme xali ƴow këme. Mëŋ law̃ënëgu ke, ame ƴow ex na aƴow fo. ");
INSERT INTO bsc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Er ɓayik aŋun penixënënd na eyeƴan edam in, an korënd na en ɓaxët. ");
INSERT INTO bsc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ŝaɓucara in ex sorix irewën, mëŋ kën rixënënd oñandi odexëm ok. Mëŋ elod gër ỹanar hi ko anemin ar ɓela. Axo deƴand na ɗal in gayik ado ɗal dëŋ ax gi ex na gër ndexëm. Nand ko nëgwëŝënd yo ola orexëm ol kë ŝanayand gayik anëgwëŝ exo. Gër ndexëm ỹanak enëgwëŝ eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wëno ar këŋun felënd ɗal an, ane kwëta ex na! ");
INSERT INTO bsc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ang hi kën ro ako, noỹo kë xor ex deƴa mëne wëno na w̃endëra këme na? Angëmëne ɗal in këmun felënd, ine cëŋ ɓayik ane kwëtaxënënd na? ");
INSERT INTO bsc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ar Kaxanu an aɓaxët ko ɓaxët eyeƴan ed Kaxanu el. Wën an ɓaxëtënd na gayik an gi ex na ɓër Kaxanu.» ");
INSERT INTO bsc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aŋo yaka këno Ɓëŝëwif ɓën: «Ax gi ex na nde ɗal këmi rend mëne wëj Asamari eƴ, ar gë ɓëyël eƴ?» ");
INSERT INTO bsc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na re ko Yesu: «Ame gi ex na ar gë ɓëyël. Wëno Faba fëɓ këmo, ɓari wën aƴepan këŋun ƴepanënd endam eŋ, ane pëɓ ex na.» ");
INSERT INTO bsc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","«Wëno ame caland na ene cëkw ɓela. Aɓat ex ar kë ŝaland ene cëkw an, do mëŋ ex ar kë xitind an.» ");
INSERT INTO bsc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","«Ɗal in këmun felënd, ar kë xwëtaya eyeƴan edam an, din axo tëƴi na ecës el.» ");
INSERT INTO bsc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ata re këni Ɓëŝëwif ɓën: «Gërëgako, anëka dëŋ nang këmi mëne enimin wëj ar gë ɓëyël eƴ. Abëraxam aŝës ŝës ko, ɓëlaw̃ënel ɓër Kaxanu ɓën ɓëte aŝës ŝës këni, do wëj këƴ rend mëne ar kë xwëtaya eyeƴan ed eƴ an din axo tëƴi na ecës el. ");
INSERT INTO bsc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ba wëj nde xuca këŋo Abëraxam, axarëk areɓi an, gayikako mëŋ aŝës ŝës ko? Ɓëlaw̃ënel ɓën aŝës ŝës këni ɓëte. Wëj noỹo këƴ yëland hi këƴ?» ");
INSERT INTO bsc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ata yaka ko Yesu: «Angëmëne wëno fo kë ŝëkwayand, enjaran endam eŋ xaf-xaf ex. Faba wa ke ŝëkwënd, mëŋ ar kën rend mëŋ ex Kaxanu, ar xwën këŋun an! ");
INSERT INTO bsc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ado wëno wa nang këŋo, wën ano nang ex na. Wëno anëgwëŝ hi dome ang wën ak kido are bame rend mëne amo nang ex na. Ɓarikan, anang wa nang këmo xali xwëtaya këme eyeƴan edexëm el. ");
INSERT INTO bsc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","End Abëraxam, axarëk arewën eŋ cëŋ, gë onënga fo baxo yëlarand end yatir këme ƴow eŋ. Ata and wat ko akey aŋo aŋ fuŋara këŋo.» ");
INSERT INTO bsc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na re këni Ɓëŝëwif ɓën: «Ado wëj axi tëk ex na pere ɓëniy ofëxw oco nde këƴ rend awat wat këƴo Abëraxam.» ");
INSERT INTO bsc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu yaka këɓi: «Ɗal in këmun felënd, ɗamana exo gi Abëraxam wëno hik.» ");
INSERT INTO bsc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ga wël këni eŋo, w̃eɗëra këni ñat oxaỹ oŋ eno pëtëraxën. Na ga ỹaf ko Yesu kwël ŝan ko Aciw̃ and Kaxanu aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Akey amat, Yesu ga ko xuca në ingol wat këŋo ala ar rëw̃eli këno mondew̃eli oŝiw̃. ");
INSERT INTO bsc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","W̃ëka këno ɓësëfan ɓërexëm ɓën: Asëƴali, noỹo wa w̃endërak mëŋ rëw̃axën këno ala ajo aŝiw̃ëk? Ba mëŋ nde ba ɓëxarëk ɓërexëm nde? ");
INSERT INTO bsc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yaka këɓi Yesu: Ax gi ex na mëŋ, ax gi ex na ɓëxarëk ɓërexëm ɓën w̃endërak. Ɓarikan, gë oŝiw̃ orexëm olo këɓi w̃asin Kaxanu ɓela ɓën ɓeɓër ko rind ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Diyenindënëŋone Kaxanu, mëŋ ar law̃ënëgu ke an nand ỹapëk na gayik aƴow kë ƴow amëd and ala ax kor na eŋo diyenin. ");
INSERT INTO bsc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Në amëd and hi këme gër ebar ro na, wëno ex angoɓen and ngwën aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ga yeƴan ko mondako, sëp ko gër ebar. Nega ko obar ok gë ɓato ɓandexëm ɓaŋ do nëm këŋo aŝiw̃ëk an gër ɓangës. ");
INSERT INTO bsc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Fel këŋo: «Ƴel eƴ dëxasax gër anjer and Silowe.» (Ow̃ac olo er w̃acayak Arolaw̃ën). Awa ga ƴe ko, rëxasax ko do nand baxo wërëŝëtand na ŝiw̃ëta ko. ");
INSERT INTO bsc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɓëraketa andexëm ɓën do ɗek ɓër baŋo watërand ga ko xararand ɓën këni w̃ëkarënd: «Ax gi ex na nde ajo bax xararand moñëpa?» ");
INSERT INTO bsc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɓërëmar këni rend: «Mëŋ ex.» Ɓëjo: «Ali, awëndër fo wëndër këni.» Ɓarikan, mëŋ ko rend: «Wëno dëŋ ex ɗe.» ");
INSERT INTO bsc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ata na w̃ëka këno: «Mondake wa ŝiw̃ëta këƴ?» ");
INSERT INTO bsc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yaka ko: «Ar këno w̃acënd Yesu an negak obar, nëm ke gër ɓangës do fel ke me ƴe me dëxasax gër anjer and Silowe. Ga ƴe këme rëxasaw këme, ŝiw̃ëta këme.» ");
INSERT INTO bsc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","W̃ëka këno ɓëte: «Do feye wa exo ala ajo?» Yaka këɓi: «Wëno ame nang ex na.» ");
INSERT INTO bsc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na w̃ëla këno ar ŝiw̃ëtak an gër Ofariseŋ. ");
INSERT INTO bsc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Xarak yatir nega baxo Yesu obar do ŝiw̃ëtaxën këŋo ala ajo akey and eteyëta ebax. ");
INSERT INTO bsc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ata Ofariseŋ ok w̃ëka këno ɓëte ba mondake ŝiw̃ëta ko. Yaka këɓi: «Obar nega baxo gë ɓato ɓandexëm ɓaŋ do nëm ke gër ɓangës, ataŋ ga rëxasa këme, watëra këme.» ");
INSERT INTO bsc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ofariseŋ odëmar are bani rend: «Yesu axo kaniw ex na gër Kaxanu gayikako axo pëɓënd na akey and eteyëta aŋ.» Ɓëte odëmar are bani rend: «Kido aw̃endëran ebaxo adoxo xor na exo di ɓecarax ɓend kënëŋo watelinde ɓeŋ.» Ata në eŋo xucarëra baɓi. ");
INSERT INTO bsc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","W̃ëka këno ɓëte ar ŝiw̃ëtak an: «Do wëj ake yëla këƴ end ar ŝiw̃ët ki ajo eŋ?» Yaka ko: «Alaw̃ënel ar Kaxanu exo.» ");
INSERT INTO bsc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ɓari, ɓëlëngw ɓër Ɓëŝëwif ɓën ani kwëta bana mëne aŝiw̃ dëŋ ŝiw̃ baxo ala ajo. ");
INSERT INTO bsc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ata w̃ëka kënëɓi ɓëxarëk ɓërexëm ɓën: «Ajo nde ex asëñiw̃ arewën ar kën rend mëne aŝiw̃ëk rëw̃ këno an? Do mondake cëŋ ko watërand gërëgako?» ");
INSERT INTO bsc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yaka këni ɓëxarëk ɓërexëm ɓën: «Ɓiyi er nang këmi mëne itox indeɓi exo, do aŝiw̃ëk rëw̃ këmo. ");
INSERT INTO bsc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ɓarikan end mondake ko watërand gërëgako eŋ, ami nang ex na. Ami nang ex na ɓëte ba noỹo ŝiw̃ët këŋo. Mëkayino mëŋ dëŋ, afirik ga exo wa, afel këŋun fel.» ");
INSERT INTO bsc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ga banëɓi yëdand ɓëlëngw ɓër Ɓëŝëwif ɓën yakaxën bani mondako. Awël wël bani mëne ar kë w̃a yo mëne Yesu ex Afexën an, aw̃aỹ këno w̃aỹ gër aciw̃ acaleya andeɓën. ");
INSERT INTO bsc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mëŋ rexën bani ɓëxarëk ɓërexëm ɓën mëne afirik exo, eno mëkara mëŋ dëŋ. ");
INSERT INTO bsc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ofariseŋ ok ga w̃ac këno akinëm ar ŝiw̃ëtak an, re këni: «Cëkwalo Kaxanu. Ala ajo aw̃endëran hi ko. Ɓiyi cëŋ mondako nang këmi.» ");
INSERT INTO bsc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yaka këɓi: «Angëmëne aw̃endëran hi ko wëno ame nang ex na. Emat ex end nang këme eŋ: aŝiw̃ëk hi bame, gërëgako në ewatëra me.» ");
INSERT INTO bsc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ata w̃ëka këno gaŝëxe: «Ake nde ri ki? Mondake ŝiw̃ët ki?» ");
INSERT INTO bsc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yaka këɓi: «Anëka ga fel këmun wa do wën ane ɓaxët ex na. Inew̃a ỹandixën këŋun ene wël gaŝëxe? Ba en gi wën ɓëte ɓësëfan ɓërexëm nde ỹandi këŋun?» ");
INSERT INTO bsc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na ŝirëra këno këni rend: «Wëj wa ex asëfan arexëm an. Ɓiyi cëŋ ɓësëfan ɓër Moyis hi këmi. ");
INSERT INTO bsc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɓiyi er nang këmi mëne Moyis w̃ëlanëgu këɓo eyeƴan ed Kaxanu el. Ɓari ajo, ami nang ex na gër ed xaniw ko.» ");
INSERT INTO bsc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yaka këɓi: «Awa wëno në ecaran exe end mëne wën an nang ex na gër ed xaniw ko eŋ. Ɓarikan mëŋ ŝiw̃ët ke ɗe! ");
INSERT INTO bsc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Anang nang këne mëne Kaxanu aɓi yakalind na cale iŋ ɓëw̃endëran ɓën. Ɓarikan, ar fëɓ këŋo Kaxanu an, ar kë rind oñandi odexëm an, ajo këŋo yakalind cale iŋ. ");
INSERT INTO bsc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Elod ane wël exe na end ala ar këɓi ŝiw̃ëtënd ɓër rëw̃eli kënëɓi oŝiw̃. ");
INSERT INTO bsc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kido ala ajo axo kaniw bana gër Kaxanu, ỹow̃eỹ adoxo xor na exo di.» ");
INSERT INTO bsc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ata yaka këno: «Yama wëj ar rëw̃ këni aỹëŋënax gër ɓeñëŋënax an nde këɓo sëƴalind gërëgako!» Ata w̃aỹ këno exo can. ");
INSERT INTO bsc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ata Yesu wël ko mëne aw̃aỹ w̃aỹ këno ala ajo. Ga fed këni, w̃ëka këŋo: «Wëj axwëta nde xwëta këƴo Asëñiw̃ ar ala an?» ");
INSERT INTO bsc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yaka ko: «Asëƴali, noỹo wa hi ko mëŋ këmo xwëtaxën?» ");
INSERT INTO bsc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na re ko Yesu: «Në ewat dëŋ eƴo, wëno ar ki felarënd ajo.» ");
INSERT INTO bsc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ata re ko ar ŝiw̃ëtak an: «Axwën, axwëta xwëta këmi.» Na foxi ko, do këŋo ŝalend. ");
INSERT INTO bsc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Re ko ɓëte Yesu: «Wëno kiti w̃ëlaw këme gër ngwën ro: ɓëŝiw̃ëk ɓën eni watërand, do ɓër kë watërand ɓën eni ciw̃.» ");
INSERT INTO bsc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ofariseŋ od xeta baŋo ok ga wël këni eyeƴan elo, w̃ëka këno: «Ba ɓiyi ɓëte ɓëŝiw̃ëk nde hi këmi?» ");
INSERT INTO bsc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu yaka këɓi: «Kido aŝiw̃ ŝiw̃ ban, an mendëra dona. Ɓarikan, ga kën rend ako awatëra kën watërand amena andewën aŋ monëka lëka këŋun.» ");
INSERT INTO bsc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ata re ko ɓëte Yesu: «Ɗal in këmun felënd, ar ɓayik ax ɗilënd na gër ebët ed kece ir opeỹ, do ko raɗand mondaɗa an, arek axeỹax exo. ");
INSERT INTO bsc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ɓarikan, ar kë lilënd gër ebët an, mëŋ ex axaɗac ar opeỹ an. ");
INSERT INTO bsc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Anëkona ar ebët an këŋo ŝëngëntënënd exo ɗilaxën, do opeỹ ok axwita këni xwitand oniw̃ orexëm ol. Ata këɓi w̃ac fac opeỹ odexëm ok ir ex kala gë ow̃ac orexëm ol eni can do kwël eno tëfa. ");
INSERT INTO bsc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","And këɓi nëcët ɗek opeỹ odexëm aŋ, exo ɗëngw do ɓën eno tëfand ga w̃ër këni oniw̃ orexëm ol. ");
INSERT INTO bsc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ala ar ano nang ex na an, ado eɓi macërand, ano tëfa na. Ata këni ŝapër eno ŋaw̃ëta gayik ani mër ex na oniw̃ or ɓëliyer ol.» ");
INSERT INTO bsc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Apënëtal aŋo fel baɓi Yesu, ɓari ɓela ɓën aɓi pëni bana er baxo rend in. ");
INSERT INTO bsc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu fel këɓi ɓëte: «Ɗal in këmun felënd, wëno ex ebët ed gër ed këni lilënd opeỹ el. ");
INSERT INTO bsc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɗek ɓër ƴowëk ɗamana me ŋatëgu ɓën ɓërek ɓëxeỹax ex. Ɓari opeỹ ok anëɓi ɓaxët ex na. ");
INSERT INTO bsc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wëno ex ebët el! Ar kë xuca gër ndam an afex ko fex. Alil ko lil, aŝan ko ŝan do exo cot er ko ƴamb in. ");
INSERT INTO bsc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Arek an er ko ƴowënd wayët: orek, eɗaw̃, enëxëndëran. Ɓarikan wëno er ƴow këme eni cot oyel oram ol aniyan aŋ do gë oɓetak or din ol. ");
INSERT INTO bsc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Wëno ex axaɗac ayekax an. Axaɗac ayekax an, ayëlaya ko yëlayand aniyan andexëm aŋ, aw̃elëk hi ko exo cës në end oyel orexëm. ");
INSERT INTO bsc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ɓarikan, ariyenin an axaɗac fo këɓi xaɗacënd oyel ol, aɓi kwën ex na. Sam eɓi watëgu ojëlemu ok, oyel ol këɓi ỹaŋëtand exo gër. Ata ojëlemu ok, oko enëɓi tëra oyel ol, oko enëɓi yëc eni capërëra. ");
INSERT INTO bsc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ariyenin an ahër ko hërënd gayik në end acosa fo këɓi xaɗaxënënd oyel ol, aŋo ɓalënd na endeɓën eŋ. Wëno ex axaɗac ayekax an. ");
INSERT INTO bsc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Anang nang këmëni oyel oram do ɓën anang nang këne; ");
INSERT INTO bsc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ang nangër këmi wëno gë Faba ak. Aw̃elëk hi këme me yëlaya aniyan andam aŋ gër ecës në end oyel oram na. ");
INSERT INTO bsc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oyel oŝëxe ŝot këmëni na or ax gi ex na gër kece ijo ro, afo mëni mëlaw. Oyel olo, awël këni ỹana eni wëlënd oniw̃ oram ol do mëni ɓar eni gi kece iɓat, mëni kaxaɗaxënënd wëno gaɓat. ");
INSERT INTO bsc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Faba iram ah̃an h̃an ke gayik aw̃elëk hi këme me cës në end oyel oram. Ado me yëlaya gër ecës, axana këme xana aniyan andam aŋ and xani gër ecës aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ax gi ex na ala ke law̃, ɓarikan gë andam aŋo dëŋ këme yëlaya. Aŝot ŝot këme ojaw̃ od me teɓaya ene ɗaw̃, ɓëte aŝot ŝot këme ojaw̃ od me kani gër ecës. Mondako ex apela and yëlëgu ke Faba aŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ata xucarëra këɓi gaŝëxe Ɓëŝëwif ɓën ga wël këni eyeƴan elo. ");
INSERT INTO bsc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɓëranjëm këno rend Yesu: «Ajo ar gë ɓëyël exo! Ado aŝenëk ex, inew̃a këno ɓaxëtaxënënd?» ");
INSERT INTO bsc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɓëjo këni rend: «Eyeƴan elo ax gi ex na ɗe ed ar gë ɓëyël. Ɓëyël ɓën anëɓi kor na enëɓi ciw̃ët ɓela.» ");
INSERT INTO bsc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Amëd and gë aƴem isëm aŋ hi bax, ata hik ofëna or Aciw̃ and Kaxanu ol gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ga ƴow ko Yesu gër Aciw̃ and Kaxanu, ko ƴexërand gër yangana, gër lilaya ir w̃acan bano Salomoŋ. ");
INSERT INTO bsc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ata xeta këno jeƴ Ɓëŝëwif ɓën do w̃ëka këno: «Xali niỹe wa këƴëɓo seɓ mi cakirand endeƴ eŋ? Angëmëne wëj ex Afexën an pelëlëɓo fac.» ");
INSERT INTO bsc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu yaka këɓi: «Ga fel këmun wa, ɓari ane kwëta ex na. Er kë reƴand osede oram in ex ɓandixa ɓand këme rind gër ow̃ac or Faba ɓaŋ. ");
INSERT INTO bsc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ɓari wën ane kwëta ex na gayik an gi ex na oyel oram. ");
INSERT INTO bsc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Oyel oram ol aw̃ër aw̃ër këni oniw̃ oram ol. Wëno anang nang këmëni do ɓën asëfa këne sëfand. ");
INSERT INTO bsc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wëno këɓi yëlënd aniyan and din aŋ. Din ani nemi na do ala ax kor na eɓi kwëcët ga lëkaya këmëni ako. ");
INSERT INTO bsc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Faba, mëŋ ar ỹëmbëta këɓi ɓela ɗek an, yël ke oyel olo. Do ala ax kor na eɓi kwëcët gër otaxan odexëm. ");
INSERT INTO bsc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wëno gë Faba, araɓat hi këmi.» ");
INSERT INTO bsc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ata Ɓëŝëwif ɓën ga wël këni eŋo, ñat oxaỹ oŋ gaŝëxe eno pëtëra xali eno ɗaw̃. ");
INSERT INTO bsc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ata re ko Yesu: «Mbaŋ ex ɓenjekax ɓend gër Faba ɓend w̃asin këmun ɓeŋ. Do në end fe ỹandixën këŋun ene pëtëra?» ");
INSERT INTO bsc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ata ɓëlëngw ɓër Ɓëŝëwif ɓën yaka këno: «Wëj ar ex ala fo do këƴ rend mëne Kaxanu hi këƴ, në ecir eƴo Kaxanu. Në eŋo ỹandixën këɓo mi pëtëra, ax gi ex na në end enjekax end ri këƴ.» ");
INSERT INTO bsc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu yaka këɓi: «Ga ỹëgw këni wa gër acariya andewën mëne Kaxanu rek: Wën ɓëte okaxanu hi kën. ");
INSERT INTO bsc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Oñëgw Omënëk mondako w̃ac këɓi okaxanu ɓër w̃ëlanëgu këɓi eyeƴan ed Kaxanu ɓën (do gër Oñëgw Omënëk, gaɓatak ax kor na exo ƴepën). ");
INSERT INTO bsc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wëno yata ke Faba Kaxanu do law̃ënëgu ke gër ngwën ro. Do wën këne rend mëne në ecir emo gayik ako re këme wëno ex Asëñiw̃. ");
INSERT INTO bsc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Angëmëne ame dind na ɓandixa ɓand Faba ɓaŋ, kërene kwëta na! ");
INSERT INTO bsc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ɓarikan, në ediyenin emo Kaxanu ado ɓayik ane kwëta ex na. En mado wa ndakaŋ endam eŋ në end ɓandiyen ɓaŋo. Ata aye nangëdon mëne wëno gë Faba araɓat emi.» ");
INSERT INTO bsc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ata na Ɓëŝëwif ɓën këni ŝaland ɓëte eno tëra Yesu, ɓarikan ŝana këɓi na. ");
INSERT INTO bsc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ga xegëta ko na gaŝëxe Yurëdeŋ in, h̃at ko gër ed baɓi ɓuyirand ɓela Ŝaŋ Batis and anëka fo aŋ, ata ɓayix ko fën. ");
INSERT INTO bsc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɓëranjëm sëfa ɓaŋo do këni rend mëne Ŝaŋ Batis, ecarax gematak axo di exëna; ɓarikan ɗek ɓeɓër reƴa ko end Yesu ɓën ɗal ex. ");
INSERT INTO bsc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ata fën ɓëranjëm w̃ax këni end Yesu eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aŝëxwëra baxëna ar bano w̃acënd Lasar gër ingol ind Betani, gër ed lëg bani mëŋ gë ɓoɓinëm, Mari do gë Marët. ");
INSERT INTO bsc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari ijo ebax asoxari ar xoŝ ɓaŋo Axwën Yesu gë angiri do fëxwëcën baŋo osapar oŋ gë omban ondexëm oŋ. Aɓinëm Lasar ŝëxwëra bax. ");
INSERT INTO bsc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ata ɓër gë aɓaỹe, Mari do gë Marët, law̃ën këni gër Axwën Yesu eno pelëx mëne ar h̃an këŋo an ŝëxwërak. ");
INSERT INTO bsc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu ga wël ko eŋo yaka ko: Oŝëxwëra olo ax gi ex na or ecës, or eni wataxën ɓela ɓën enjaran end Kaxanu ex. Gë oŝëxwëra olo këni wat ola or Kaxanu ol gër Asëñiw̃ arexëm. ");
INSERT INTO bsc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu mbaŋ baŋo ɓalënd end ɓër amimënëra eŋ: Marët, gë Mari do gë Lasar. ");
INSERT INTO bsc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɓarikan, ga wël ko mëne Lasar ŝëxwërak ɓayix ko gër ed hi baxo ɓakey ɓaki. ");
INSERT INTO bsc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gër akey atasën, fel këɓi ɓësëfan ɓën: «Ɓakane gër ebar ed Yude.» ");
INSERT INTO bsc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Re këni ɓësëfan: «E Asëƴali, ax nëka ex na ɓëlëngw ɓër Ɓëŝëwif ga bani ŝaland eni pëtëra gë oxaỹ oŋ do këƴ rend ene ɓakaye fën.» ");
INSERT INTO bsc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ata Yesu yaka këɓi: «Ax gi ex na nde gër amëɗëna ɓapëxëd epëxw gë ɓaki ex? Ar kë ƴexërand goyat an axo naw̃ërand na gayik aye ko watërand gë angoɓen and gër ngwën ro aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ɓarikan ar kë ƴexërand gëmëɗ an anaw̃ëra ko naw̃ërand gayik axo gi ex na gë angoɓen.» ");
INSERT INTO bsc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu, ga h̃ata ko eyeƴan elo, fel këɓi ɓëte ɓësëfan ɓën: «Lasar, lawo ireɓi në okwëɗ exo. Ɓarikan ƴene mo nëngëtëx.» ");
INSERT INTO bsc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ata yaka këno ɓësëfan: «Axwën, angëmëne araŝ raŝ këŋo, afak ko fak.» ");
INSERT INTO bsc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Enimin, er ỹandi baŋo Yesu eɓi pëni mëne Lasar aŝës dëŋ ŝës ko. Er yëla bani ɓësëfan ɓën mëne end okwëɗ fo ko yeƴanënd. ");
INSERT INTO bsc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ata Yesu fel këɓi fac: «Lasar anëka ŝës ko. ");
INSERT INTO bsc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Er nëngan ke ga ŝës ko nand ɓayik ame ƴe bana mëŋ këne xwëtaxën wën. Gërëgako ƴene gër ed exo.» ");
INSERT INTO bsc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ata fel këɓi Toma, ir nëngët bano Didim, ɓësëfan ɓëŝandaw̃: «Ƴene, ɓiyi ɓëte ene cësëxëye gë mëŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu, and h̃at ko gër ingol ind Betani aŋ, sëk ko mëne anëka ri baxo Lasar ɓakey ɓanax gër ỹeg. ");
INSERT INTO bsc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ingol ind Betani iŋ ax ŋaw̃ër bana gë Yerusalem in, në ɓapakan ɓatas fo bax. ");
INSERT INTO bsc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ɓëyude ɓëranjëm bax ƴowënd enëɓi cëma Marët gë Mari ga lap këno imaỹe indeɓën iŋ. ");
INSERT INTO bsc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","And wël ko Marët mëne Yesu kë h̃atëgund aŋ, xacëra këŋo. Mari ɓayi ko moñëpa gër iciw̃. ");
INSERT INTO bsc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ga fed këni gë Yesu, Marët re ko: «Axwën, kido ro hi baƴ aɓaỹe axo cës dona. ");
INSERT INTO bsc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ɓarikan, ado gërëgako dëŋ anang nang këme mëne ɗek er këƴo xara yo Kaxanu aye ki yakali.» ");
INSERT INTO bsc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ata re ko Yesu: «Aɓinëx axani ko xani gër ecës.» ");
INSERT INTO bsc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Re ko Marët: «Anang nang këme mëne axani ko xani gër ecës and këni xanira ɓëŝësëk aŋ yatir akey apelatar.» ");
INSERT INTO bsc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ata re ko Yesu: «Wëno kë xaninënd gër ecës, wëno ke yëlënd aniyan aŋ. Ar kë w̃a endam an gë aniyan ak ko ɓayi ado exo cës. ");
INSERT INTO bsc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ar kë liyand do exe kwëta wëno an, ecës el din aŋo ɗëkaya na. Aw̃a nde w̃a këƴ eŋo?» ");
INSERT INTO bsc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yaka ko Marët: «Iyo, Axwën aw̃a w̃a këme mëne wëj ex Afexën an, Asëñiw̃ ar Kaxanu an, ar ebax ex ƴow gër ngwën ro an.» ");
INSERT INTO bsc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ga h̃ata ko Marët eyeƴan elo, ɓaka ko gër iciw̃. Ata w̃ac këŋo, Mari aɓinëm do nëkënëka këŋo: «Asëƴali aŋ anëka ƴow ko, në emac exi.» ");
INSERT INTO bsc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sam ga wël ko eŋo, Mari xani ko xwiriŝ, w̃ara ko gër ed hi baxo Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu axo ŋat bana pere gër ingol, gër ed fed bani gë Marët fo ɓayi baxo. ");
INSERT INTO bsc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ɓëyude ɓër xetëna baŋo Mari gër iciw̃ do bano yifarand ɓën wat këno ga xani ko aỹand. Ata ga ko ŝan sëfa këno ga yëla bani mëne gër ỹeg ko ƴend exo denitarax. ");
INSERT INTO bsc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","And h̃at ko Mari gër ed hi baxo Yesu aŋ, lapaya ko gër osapar orexëm, ko rend: «E Axwën, kido ro hi ba aƴ aɓaỹe axo cës dona.» ");
INSERT INTO bsc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","And wat ko Yesu mëne në edenita exo Mari aŋ do ɓëte në etes exëni Ɓëyude ɓër sëfaw ɓaŋo ɓën, hi këŋo ñar eman eŋ do ŝamina ko gër onden ondexëm. ");
INSERT INTO bsc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","W̃ëka këɓi: «Feye wa w̃ëxëta këno?» Yaka këni: «Axwën ƴow mi masin.» ");
INSERT INTO bsc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu ses ko. ");
INSERT INTO bsc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ɓëyude ɓërëmar re këni: «E, awa mbaŋ baŋo ɓalënd ɗe end Lasar eŋ!» ");
INSERT INTO bsc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ɓëjo këni rend: «Oko, ax gi ex na nde mëŋ ŝiw̃ët këŋo aŝiw̃ëk an? Axo kor dona nde eŋo pakën Lasar këdi ko ŝës?» ");
INSERT INTO bsc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu, ga hi këŋo na ɓëte ñar eman eŋ, sëka ko ỹeg in. Ỹeg ijo oxel ebax do fëŋ bani lilaya in gë angaỹ. ");
INSERT INTO bsc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ata re ko Yesu: «Dëxëtin tan angaỹ aŋ.» Na rew ko Marët, imaỹe ind aŝësëk iŋ: «Axwën, anëka nëmu ko, akey anaxën aŋ ex doro!» ");
INSERT INTO bsc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yaka ko Yesu: «Ami pel ex na nde ga xwëta xwëta këƴe awat këƴ wat enjaran end Kaxanu eŋ?» ");
INSERT INTO bsc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ata weɗit këni angaỹ aŋ. Yesu ga xeŋa ko orën ol, re ko: «Faba, aye ri këƴ ga yakali këƴe. ");
INSERT INTO bsc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wëno, anang nang këme mëne din këƴe yakalind. Ɓarikan, në end amëxwër and ex ro aŋo këme yeƴanënd eni maxën mëne wëj dëŋ law̃ënëgu ke.» ");
INSERT INTO bsc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","And h̃ata ko aŋ, xeỹ ko: «Lasar, canëgu!» ");
INSERT INTO bsc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ata aŝësëk an ŝanëgu ko, osapar oŋ do gë otaxan ok moceri gë ɓëcole, do dëxasin mopël kwëc gë anjëm. Ata re ko Yesu: «Pëtërayino tan do teɓino exo ƴe.» ");
INSERT INTO bsc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ata Ɓëyude ɓëranjëm, ɓër ƴowëraw bax gër Mari ɓën, ga wat këni er ri ko Yesu in, w̃a këni endexëm eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ɓarikan mar ƴe këni gër Ofariseŋ eni deƴax er ri baxo Yesu in. ");
INSERT INTO bsc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ata ɓëŝaɗaxan ɓëlëngw ɓën do gë Ofariseŋ ok w̃acër këni. Ga ỹëpaxën këni endeƴ eŋ gër Amara këni w̃ëkarënd: «Mondake wa këne riye? Ala ajo cëŋ në eñëmb ex ɗe ɓecarax ɓend ko rind ɓeŋ. ");
INSERT INTO bsc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Angëmëne aseɓ seɓ kënëŋone, ɗek këni w̃a endexëm eŋ. Ata Ɓërom ɓën eni ƴow eni ñam Aciw̃ and Kaxanu aŋ do enëɓo yëcëra enëng endeɓi eŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ata Kayif, mëŋ ar hi bax aŝaɗaxan alëngw niy ijo an, re ko: «Ata wën ỹow̃eỹ an nang ex na ɗe paɓ gë endeƴ eŋo. ");
INSERT INTO bsc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","An nang ex na nde mëne aɓat ỹapëk exo cës në end ɓulunda ir Isërayel ɗek gë ex yëcar enëng endeɓi eŋ.» ");
INSERT INTO bsc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yeƴanaxën baxo mondako in, ax gi bana anjëlan andexëm fo. Ga hi baxo aŝaɗaxan alëngw aniy aŋo, yeƴanaxën baxo ang alaw̃ënel fo mëne Yesu kë ŝës eni pexaxën ɓulunda ir Isërayel in. ");
INSERT INTO bsc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Enimin, eɓi ɓaraxën Kaxanu ekun eɓat oɓaŝ orexëm ol gër ɓenëng ɗek ko ŝësaxën, ax gi ex na në end Ɓëŝëwif fo. ");
INSERT INTO bsc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ata elod yatijo xetan baɓi eno ɗaw̃. ");
INSERT INTO bsc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu aŋo seɓ ko eƴerëxa ed wat-wat gër Ɓëŝëwif el. Ga xani ko na, ƴe ko kwël gand ladawe, në angol bani w̃acënd Efërayim. Fën xeyërax baɓi gë ɓësëfan ɓërexëm ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Anëka saxëgu bax Ofëna or Apexa ol, ata Ɓëŝëwif ɓën këni ƴend ƴaŋ gër Yerusalem eni w̃unëtarax ɗamana ex ŋatëgu Ofëna or Apexa ol. ");
INSERT INTO bsc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ga këno ŝalara Yesu këni w̃ëkarënd gër Aciw̃ and Kaxanu: «Mondake yëla kën, aƴow nde ko ƴow gër ofëna?» ");
INSERT INTO bsc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ɓëŝaɗaxan ɓëlëngw ɓën do gë Ofariseŋ ok afel fel banëɓi ɓela ɓën mëne ar kë nang yo gër ed exo Yesu exo deƴaɗ eno tëraxën. ");
INSERT INTO bsc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ɓakey ɓanjongamat ɓayi bax ofëna or Apexa ol. Ata Yesu ƴe ko gër ingol ind Betani, gër ed lëg baxo Lasar, ar xanin ɓaŋo gër ecës an. ");
INSERT INTO bsc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Fën aŝemëran ŝemëran bano. Ata Marët këɓi lëɓand, do Lasar hi ko ŝëf gër ɓër bax ƴambërand. ");
INSERT INTO bsc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na w̃eɗëgu ko Mari icëlakuŋ ir angiri ir këni w̃acënd nar, ir xem bax akanji mbaŋ. Xoŝ ko osapar or Yesu oŋ, do këŋo fëxwëcënd gë omban ondexëm. Ata otëñer onëngax oŋ xëñëk ɗek iciw̃ iŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aŋo re ko Yuda Isëkariyot, asëfan ar ebax eŋo ɗëxw Yesu an: ");
INSERT INTO bsc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Inew̃a ɓayik ane pan exe na angiri ijo ɓatama okeme otas, do koɗi ir ŝot done in enëɓe dëcaraxëne ɓëxaỹënaxik ɓën.» ");
INSERT INTO bsc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Rexën baxo eŋo mëŋ arek ebaxo, ax gi ex na ɗe ga ɓal ɓaŋo end ɓëxaỹënaxik eŋ. Yama ga baxo ƴambënd nde koɗi ir bano fëxwënënd exo mëxwëta gër imboto in. ");
INSERT INTO bsc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ɓarikan Yesu re ko: «Teɓëlo ɗe, gana-gana fo xoŝ ko eman endam eŋ ond gër ỹeg oŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wën din gë ɓëxaỹënaxik ɓën ga hi kën wa, ɓari wëno ame bo na din gë wën.» ");
INSERT INTO bsc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ga wël këni amëxwër and Ɓëyude aŋ mëne Yesu ƴowëk gër Betani ɓarërëgu këni. Eno wat ɓëte Lasar, ar xanin ɓaŋo gër ecës an ɓarëraxënëgu bani, ax gi ex na në endexëm fo. ");
INSERT INTO bsc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ata ɓëŝaɗaxan ɓëlëngw ɓën xetan këɓi eno ɗaw̃ ɓëte Lasar ");
INSERT INTO bsc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","gayik Ɓëŝëwif ɓëranjëm baɓi h̃awëtand ga bano xwëtand Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ga xeyëk, amëxwër and ɓër ƴowërawëk gër ofëna aŋ wël këni mëne Yesu kë ƴowënd gër Yerusalem. ");
INSERT INTO bsc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ata ga saw̃ëgu këni ɓeniɗ ɓend ɓaŋeỹ, xaca këno do këni sarënd: Hosana, ɓetalexo ar kë ƴowënd gë ow̃ac or Axwën an, Ɓetalexo emun end ɓulunda ir Isërayel eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ata Yesu ỹëpa ko ƴaŋ në ipali. Mondako ŋata baxo er ỹëgw baxo alaw̃ënel ar Kaxanu an endexëm eŋ: ");
INSERT INTO bsc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Këren yëdara na, wën ɓër gër Siyoŋ ɓën, Watino emun endewën eŋ, Në eƴow exo, mo ñëpa ƴaŋ në ipali. ");
INSERT INTO bsc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Amëd aŋo ɓësëfan ɓërexëm ɓën aɓi pëni bana pere eŋo. Ɓarikan, and wat këni enjaran end Yesu aŋ xwita këni mëne end ỹëgw baxo alaw̃ënel eŋ ex. Mëŋ xacaxën bano mondako ɓela ɓën. ");
INSERT INTO bsc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Amëxwër and ɓër ebax yatir w̃ac ɓaŋo Lasar exo canëgu gër ỹeg aŋ areƴa bani reƴand end wateli bano eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Në end ecarax end wël bani ri ko eŋo xacaxën bano Yesu ɓura-ɓura. ");
INSERT INTO bsc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ata Ofariseŋ ok këni rexërënd: «Awat kën watënd mëne ỹow̃eỹ an kor na: ngwën iŋ ɗek mëŋ fo këno sëfënd.» ");
INSERT INTO bsc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɓela ɓër ɓenëng ɓecëxe ƴow bax na gër Ofëna or Apexa gër Yerusalem, eno cale Kaxanu. ");
INSERT INTO bsc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ata sëka këno Filip, asëfan ar lëg bax gër Betësayida an, ingol ind gër ebar Galile. W̃ëka këno: «Asoŝan, ɓiyi Yesu ỹandi këɓo mo wat.» ");
INSERT INTO bsc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ga wël ko eŋo, Filip fel këŋo Andëre, ata ɓën ɓëxi h̃ateli këni endeƴ eŋ gër Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu yaka këɓi: «Dodo anëka h̃atëguk apëxëd and kë ŝanaya enjaran endam eŋ, wëno Asëñiw̃ ar ala an. ");
INSERT INTO bsc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ɗal in këmun felënd, eneɗa end bële end ani wëg ex na gër ebar eŋ, ax cënand na, emat fo kë ɓayind. And këni lap do eni wëg aŋ kë ŝënand ɓon. ");
INSERT INTO bsc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ar kë h̃an nëmëc aniyan andexëm an, anemin ko nemin. Ɓarikan, ar kë ŝus aniyan andexëm and gër ngwën ro an kë ŝot aniyan and din aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ar këŋo ỹandi exe diyeninënd an, tëfëgulexe. Do gër ed këme hi yo na ko hi mëŋ ɓëte. Ar ỹandi këŋo exo gi ariyenin aram an, Faba këŋo w̃aŝën.» ");
INSERT INTO bsc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Gërëgako yomb iram in anëka ŝaminak. Ine këme re? Ba, Faba dacëtële gër toro iŋo nde? Ɓarikan, me toro mondako ƴowaxënëgu këme. ");
INSERT INTO bsc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Faba, dafël ex ow̃ac oreƴ ol gër ɓela!» Ata wëliwëk oniw̃ ƴaŋ gër orën do kë rend: «Anëka rafën këme do arafën këme rafën gaŝëxe.» ");
INSERT INTO bsc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","And wël këni ɓër gër amëxwër ɓën oniw̃ olo aŋ, mar këni rend mëne orën ol xëmak, ɓëjo këni rend: «Meleka yeƴaneli këŋo.» ");
INSERT INTO bsc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ata re ko Yesu: «Në endewën wëlixënëk ɗe oniw̃ olo, ax gi ex na në end ow̃ac oram. ");
INSERT INTO bsc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gërëgako wa ex kiti ind ngwën iŋo iŋ, gërëgako këno w̃aỹ emun end gër ngwën ro eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Do wëno and këne yën ƴaŋ në osëx aŋ këmëni ɓar ɓela ɓën ɗek eni gi ɓëram.» ");
INSERT INTO bsc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ata gë eyeƴan elo nangën baɓi Yesu ang ko ŝës ak. ");
INSERT INTO bsc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yaka këno ɓër gër amëxwër ɓën: «Ɓiyi er fënën kënëɓo gër ɓakayëta ɓand acariya andeɓi mëne Afexën an din ir din ko liya. Mondake cëŋ këƴëɓo felënd mëne Asëñiw̃ ar ala an afika këno fika? Noỹo ngwa ex Asëñiw̃ ar ala ajo?» ");
INSERT INTO bsc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ata Yesu yaka këɓi: «Ga ɓayik ako tëkër angoɓen and këŋun h̃oband aŋ ƴexërayindën në amëd and hi kën gë angoɓen aŋ këdi këŋun fënga ecamëɗan aŋ. Ar kë ƴexërand gër ecamëɗan an axo nangënd na gër ed ko ƴend. ");
INSERT INTO bsc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Në amëd and hi kën gër angoɓen aŋ, kwëtayin angoɓen aŋ, en gixën oɓaŝ or angoɓen.» Ga yeƴan ko mondako Yesu, h̃awëta këɓi do nem këno. ");
INSERT INTO bsc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɓëŝëwif ɓën, ado ga bani watënd awat dëŋ ɓecarax ɓendanjëm ɓend baxo rind Yesu ɓeŋ, ano kwëta bana. ");
INSERT INTO bsc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mondako h̃atak er ỹëgw baxo alaw̃ënel Esayi in: «Axwën, noỹo ngwa w̃ak er reƴa këmi in? Noỹo ngwa watëk panga indeƴ iŋ?» ");
INSERT INTO bsc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ang sëkwanënd bani eno kwëta Yesu ak, Esayi aỹëgw ỹëgw ko ɓëte: ");
INSERT INTO bsc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Axwën Kaxanu fëɗëk ɓangës ɓandeɓën ɓaŋ, Mëŋ xemënëk ogaf odeɓën ok, Këdi këni watëra, këdi këɓi fëni gër onden ondeɓën, Këdi këni nëngwët ola oreɓën ol do eni pak.» ");
INSERT INTO bsc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ejo re baxo Esayi ga wat ko enjaran end Axwën eŋ do Yesu ɓaŋo rend mondako. ");
INSERT INTO bsc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ado ŝëf gër ɓëlëngw dëŋ, ɓëranjëm w̃a bax end Yesu eŋ. Ɓari, ga banëɓi yëdand Ofariseŋ ok, abani reƴara na poyoma këdi kënëɓi w̃aỹ gër aciw̃ acaleya. ");
INSERT INTO bsc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Awa ɓën er këni h̃an ɓela in fecan baɓi gë enjaran end Kaxanu eŋ. ");
INSERT INTO bsc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ata xeỹ ko Yesu: «Ar ke xwëta an anëka w̃a ko ɓëte end ar law̃ënëgu ke eŋ, ax gi ex na wëno fo xwëta ke. ");
INSERT INTO bsc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ar këŋo xëɓënan endam an, end ar law̃ënëgu ke eŋ xëɓënan këŋo ɓëte. ");
INSERT INTO bsc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wëno ex angoɓen aŋ, er ƴow këme gër ngwën ro mëni ŋoɓa ɗek ɓër kë w̃a endam ɓën, këdi këni ɓayi gër ecamëɗan. ");
INSERT INTO bsc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ar kë ɓaxët er këme rend in do axo kwëtaya ex na an, ax gi ex na wëno këŋo nëp gayik ame ƴow ex na mëni nëp ɓela ɓër gër ngwën ro ɓën. Ɓarikan, mëni pexën ƴowaxënëgu këme. ");
INSERT INTO bsc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ar ŝus ke an do exo ŋëp er re këme in ar enëp ex. Eyeƴan edam el fo këŋo nëp yatir akey apelatar. ");
INSERT INTO bsc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","End këme yeƴanënd eŋ ax gi ex na endam, apela and Faba ex, mëŋ ar law̃ënëgu ke an. Mëŋ dëŋ felëgu ke eyeƴan elo do gë er ỹapëk me tëƴalind in. ");
INSERT INTO bsc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Do anang nang këme mëne apela andexëm aŋ kë yëlënd aniyan and din ir din aŋ. Awa er këme rend in, ang felëgu ke Faba ak këme yeƴanënd.» ");
INSERT INTO bsc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Në ecan ɓayi bax Ofëna or Apexa ol, Yesu nang ko mëne anëka h̃atëguk amëd and ko rëxëta gër ngwën ro aŋ exo ɓaka gër Sëm Kaxanu. Mbaŋ h̃an baɓi ɓësëfan ɓërexëm ɓën ado ga baɓi seɓënd gër ebar ro. Ata w̃asin këɓi aŋana aŋo xali gër eŋata. ");
INSERT INTO bsc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ga këni ƴambëra ed genëka el, ŝaɓucara in anëka ŝoñ baŋo gër emëkw Yuda, asëñiw̃ ar Simoŋ Isëkariyot, eŋo ɗëxw Yesu. ");
INSERT INTO bsc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Do Yesu anang nang baxo mëne ɓeỹ ɗek seɓënan këŋo Sëm, gër ndexëm xaniw ko do fën ko ɓaka. ");
INSERT INTO bsc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Gër ed bani ƴambërand na, xani ko xwiriŝ, ŝuɗëta ko acuɗ atëm aŋ do xapa ko anjëm gër edum. ");
INSERT INTO bsc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ata ga rëmb ko men në inëp, ỹana ko këɓi neɓënënd osapar oŋ ɓësëfan ɓën do këɓi fëxwëcënënd gë anjëm and xapa baxo gër edum aŋ. ");
INSERT INTO bsc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na re ko Simoŋ Piyer and h̃at ko gër ndexëm aŋ: «Axwën, yama wëj nde eƴe neɓën osapar oŋ!» ");
INSERT INTO bsc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yaka këŋo Yesu: «Er këme rind in, anang këƴ nang and kë ɓaŝana aŋ, ɓari ax gi ex na gërëgako.» ");
INSERT INTO bsc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ata re ko ɓëte Piyer: «Din ame ma na eƴe neɓën osapar oŋ.» Aŋo re ko Yesu: «Angëmëne ami neɓën ex na yo osapar oŋ, awa ỹow̃eỹ axe ɓar ex na.» ");
INSERT INTO bsc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yaka ko Simoŋ Piyer: «Awa angëmëne mondako ex Axwën, kërex gi na osapar oŋ fo. Neɓënële ɓëte otaxan ok gë gaf in.» ");
INSERT INTO bsc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ata re ko ɓëte Yesu: «Ar ɓuyirak eceɗe an, ɗek eman eŋ w̃ën ko. Osapar oŋ fo ko neɓara. Do wën ɓëw̃ënëk hi kën, ɓari ax gi ex na wën ɗek ɗe.» ");
INSERT INTO bsc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu aye nang ɓaŋo ar këŋo lëxw an, mëŋ rexën baxo mëne ax gi ex na ɓën ɗek w̃ënëk. ");
INSERT INTO bsc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","And faỹ ko eneɓën ed osapar aŋ, Yesu ŝuɗa ko acuɗ atëm aŋ do ɓaka ko gër ed bani ƴambërand. Ata w̃ëka këɓi: «Afëni nde fëni këŋun er rin këmun in? ");
INSERT INTO bsc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wën ke w̃acënd Asëƴali do Axwën, ata ɗal kën reƴand gayik go dëŋ ex. ");
INSERT INTO bsc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Awa angëmëne aneɓën neɓën këmun osapar oŋ wëno ar ex Axwën do Asëƴali arewën an, wën ɓëte aỹap ỹapëk en neɓëndërënd osapar oŋ. ");
INSERT INTO bsc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Amatinali rin këmun, en dixënënd wën ɓëte ang rin këmun ak. ");
INSERT INTO bsc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ɗal in këmun felënd, xaɗëp in aŋo kucand na or gapak axwën arexëm an, parëxanda in aŋo kucaxënd na ar law̃ën këŋo an. ");
INSERT INTO bsc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ga fëni fëni këŋun eŋo, anëngandëra këŋun nëngandëra angëmëne enimin mondako dëŋ kën rind. ");
INSERT INTO bsc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Anang nang këmëni ɓër yata këmëni ɓën, amun dend na ɗe wën ɗek. Ɓarikan afo ex ŋata endam end ex gër Oñëgw Omënëk eŋ: “Ar ɓar këmi enëp eɓat dëŋ ke ŝenaxën.” ");
INSERT INTO bsc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kwël gërëgako fo këmun nangënënd eŋo ɗamana ex ŋatëgu. Do and kë h̃atëgu aŋ, ene kwëtaxën mëne wëno dëŋ ex ar hi këme an. ");
INSERT INTO bsc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ɗal in këmun felënd, ar këŋo xana arolaw̃ën oram an, wëno dëŋ xana ke. Do ar ke xana an, anëka xana këŋo ɓëte ar law̃ënëgu ke an.» ");
INSERT INTO bsc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ga yeƴan ko mondako, Yesu ŝamina ko gër onden ondexëm. Reƴa ko ɓëte: «Ɗal in këmun felënd, wën ɓësëfan ɓëram ɓën, aɓat ke lëxw.» ");
INSERT INTO bsc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ata ɓësëfan ɓën këni nëkonëndërënd do këni yëlarand ba noỹo këŋo rend. ");
INSERT INTO bsc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Asëfan ar lëka baŋo mbaŋ Yesu an, xetëna ɓaŋo gër ed bani ƴambërand. ");
INSERT INTO bsc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoŋ Piyer ga xëw̃a këŋo, fel këŋo eŋo mëka ba noỹo këŋo rend. ");
INSERT INTO bsc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ata asëfan ajo xaƴaxën këŋo Yesu gër emëkw do w̃ëka këŋo: «Axwën, noỹo wa këƴo rend?» ");
INSERT INTO bsc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yaka këŋo Yesu: «Ar këmo fëxwën aton and mburu and ỹesëna këme aŋ, ajo ex ar ke lëxw an.» Ata ỹesëna ko aton aŋ do fëxwën këŋo Yuda, asëñiw̃ ar Simoŋ Isëkariyot. ");
INSERT INTO bsc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sam ga xana ko Yuda aton aŋ, Sindan lil këŋo. Ata Yesu fel këŋo: «Er këƴ rind in, dil aỹand.» ");
INSERT