﻿USE sofia;
DROP TABLE IF EXISTS sofia.bru_vpl;
CREATE TABLE bru_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bru_vpl WRITE;
INSERT INTO bru_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Dâu lứq Yiang Sursĩ tễng paloŏng cớp cutễq tâng pưn manlôc nâi. ");
INSERT INTO bru_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ma cutễq nâi tỡ cỡt roâp riang ntrớu yũah, cớp tỡ va bữn ramứh ntrớu yũah tâng cutễq nâi. Bữn ống dỡq sâng. Ŏ́c canám clũom nheq tâng cloong dỡq. Cớp Raviei Yiang Sursĩ ỡt dớng dĩ ria pỡng dỡq. ");
INSERT INTO bru_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Yiang Sursĩ pai neq: “Cóq bữn poang!” Lứq cỡt poang toâp. ");
INSERT INTO bru_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yiang Sursĩ hữm poang nâi o lứq, cớp án cayoah chíq poang cớp canám. ");
INSERT INTO bru_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Chơ Yiang Sursĩ amứh poang la tangái, ma canám la sadâu. Ngkíq, bữn tabữ bữn tarưp, ki la tangái muoi Yiang Sursĩ tễng. ");
INSERT INTO bru_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Chơ Yiang Sursĩ pai ễn: “Cóq cayoah dỡq cỡt bar pún. Muoi pún tâng cloong cutễq, ma muoi pún ễn tâng paloŏng.” Yiang Sursĩ amứh ntốq mpứng dĩ la taroong. ");
INSERT INTO bru_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tâng taroong ki, án cayoah dỡq ỡt tâng pưn tễ dỡq tâng pỡng. Chơ ranáq ki lứq cỡt ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Yiang Sursĩ amứh taroong ki la paloŏng. Ngkíq, bữn tabữ bữn tarưp, ki la tangái bar Yiang Sursĩ tễng. ");
INSERT INTO bru_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Cớp Yiang Sursĩ pai ễn: “Máh dỡq ỡt pưn paloŏng cóq parỗm muoi ntốq, cớp yỗn mpáh cloong cutễq.” Ki lứq bữn ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Cớp Yiang Sursĩ amứh ntốq khỗ ki la cutễq. Ntốq dỡq parỗm án amứh la dỡq mưt. Cớp Yiang Sursĩ hữm ranáq ki la o lứq. ");
INSERT INTO bru_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Cớp Yiang Sursĩ pai ễn: “Cutễq cóq amia nheq bát bai, dếh bát ca bữn ŏ́c chóh, dếh aluang ca cỡt palâi. Dáh cuplốq léq, cỡt loah ramứh ki.” Chơ ŏ́c ki lứq bữn ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Cutễq amia túc ramứh cuplốq ki. Cớp Yiang Sursĩ hữm ranáq ki la o lứq. ");
INSERT INTO bru_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ngkíq, bữn tabữ bữn tarưp, ki la tangái pái Yiang Sursĩ tễng. ");
INSERT INTO bru_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Cớp Yiang Sursĩ pai ễn: “Cóq bữn máh ramứh poang ỡt tâng paloŏng dŏq tampễq tangái cớp sadâu. Cớp ramứh poang ki táq tếc yỗn cũai dáng noap sadâu, tangái, casâi, cumo. ");
INSERT INTO bru_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Cớp ramứh poang ki claq asễng tễ paloŏng yỗn cỡt poang tâng cutễq.” Ngkíq, ranáq ki lứq bữn ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Chơ Yiang Sursĩ tễng bar ramứh poang toâr lứq. Moat mandang toâr hỡn, chơ Yiang Sursĩ yỗn án sốt tâng tangái. Rliang casâi Yiang Sursĩ yỗn sốt tâng sadâu. Cớp Yiang Sursĩ tễng máh mantỗr hỡ. ");
INSERT INTO bru_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ngkíq Yiang Sursĩ dŏq nheq máh ramứh poang ki ỡt tâng paloŏng yỗn claq asễng toâq pỡ cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Án yỗn máh ramứh ki sốt sadâu cớp tangái, cớp tampễq poang cớp canám. Chơ Yiang Sursĩ hữm ranáq ki la o lứq. ");
INSERT INTO bru_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ngkíq, bữn tabữ bữn tarưp, ki la tangái pỗn Yiang Sursĩ tễng. ");
INSERT INTO bru_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Cớp Yiang Sursĩ pai ễn: “Dỡq cóq bữn tưn-ưn máh acán tamoong. Cớp tâng pỡng cutễq cóq bữn túc ramứh chớm pâr.” ");
INSERT INTO bru_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ngkíq, Yiang Sursĩ tễng charán toâr lứq ỡt tâng dỡq mưt cớp dũ ramứh canŏ́h hỡ ca tamoong tâng dỡq. Cớp Yiang Sursĩ tễng tê dũ ramứh chớm. Chơ Yiang Sursĩ hữm nheq ranáq ki la o lứq. ");
INSERT INTO bru_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Cớp Yiang Sursĩ patâp yỗn nheq charán ki bữn ŏ́c bốn. Án pai neq: “Cóq anhia cỡt rứh sa‑ữi lứq ễn. Máh charán ca ỡt tâng dỡq cớp máh chớm ca pâr tâng paloŏng cóq rứh rưong chưong cỡt sa‑ữi lứq ễn.” ");
INSERT INTO bru_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ngkíq, bữn tabữ bữn tarưp, ki la tangái sỡng Yiang Sursĩ tễng. ");
INSERT INTO bru_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Cớp Yiang Sursĩ pai ễn: “Tâng cutễq cóq bữn túc ramứh charán, dếh charán dống, dếh charán cruang, cớp nheq tữh charán ca pỡq talor tâng cutễq.” Chơ, ranáq ki lứq bữn ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Chơ Yiang Sursĩ tễng nheq tữh charán cruang, charán dống, cớp charán ca talor tâng cutễq. Ngkíq Yiang Sursĩ hữm nheq ranáq ki la o lứq. ");
INSERT INTO bru_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Cớp Yiang Sursĩ pai ễn: “Cóq hái tễng cũai machớng riang hái tê. Chơ, yỗn cũai ki sốt nheq máh sĩaq tâng dỡq, chớm tâng paloŏng, cớp nheq máh charán dống. Cớp yỗn cũai ki sốt dũ cruang tâng cốc cutễq nâi cớp nheq tữh acán tamoong tâng cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ngkíq, Yiang Sursĩ tễng cũai machớng riang án. Yuaq ngkíq, án tễng cũai samiang cớp cũai mansễm. ");
INSERT INTO bru_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Chơ Yiang Sursĩ yỗn cũai ki bữn ŏ́c bốn cớp patâp neq: “Cóq anhia rứh rian tan lưp sa‑ữi lứq ễn toau yỗn chũop nheq cruang cutễq nâi. Têq anhia ndỡm cốc cutễq nâi. Têq anhia sốt nheq máh sĩaq tâng dỡq, cớp nheq máh chớm pâr tâng paloŏng. Cớp têq anhia sốt nheq tữh charán pupỡq tâng cutễq hỡ.” ");
INSERT INTO bru_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Cớp Yiang Sursĩ pai ễn: “Ngkíq, nâi la ramứh crơng sana cứq yỗn anhia cha: Nheq tữh bát bai cớp nheq tữh palâi aluang. ");
INSERT INTO bru_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma nheq tữh ramứh charán ỡt tâng cutễq nâi, charán cruang pupỡq tâng cutễq, nheq chớm pâr tâng paloŏng, cớp nheq charán talor tâng cutễq, ngkíq cứq yỗn alới cha ống bát bai sâng.” Chơ, ranáq ki lứq bữn ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Cớp Yiang Sursĩ hữm nheq máh ranáq án tễng la o lứq. Ngkíq, bữn tabữ bữn tarưp, ki la tangái tapoât Yiang Sursĩ tễng. ");
INSERT INTO bru_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ngkíq, Yiang Sursĩ khoiq tễng moâm paloŏng cớp cutễq, cớp nheq máh ramứh canŏ́h hỡ. ");
INSERT INTO bru_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","3","Toâq tangái tapul án rlu tễ ranáq án khoiq táq. Chơ Yiang Sursĩ satốh ŏ́c bốn yỗn tangái tapul, cớp dŏq miar tễ tangái canŏ́h, cỗ tâng tangái ki án rlu yuaq án khoiq táq moâm máh ranáq án ễ táq. ");
INSERT INTO bru_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","6","Nâi la parnai atỡng tễ Yiang Sursĩ tễng paloŏng cutễq. Bo tangái Yiang Sursĩ tễng paloŏng cutễq, tangái ki tỡ yũah bữn muoi nỡm aluang ntrớu dáh tâng cloong cutễq nâi, cớp sarnóh chóh la tỡ yũah dáh muoi ramứh ntrớu tê. Yiang Sursĩ tỡ yũah yỗn mia sễng pỡ cloong cutễq, cớp tỡ yũah bữn cũai aléq táq sarái tâng cốc cutễq nâi. Ma bữn dỡq talúc táq yỗn thớm chũop cloong cutễq. ");
INSERT INTO bru_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yiang Sursĩ ĩt cutễq, chơ án mial táq rup cũai samiang. Moâm ki án cahỡ amut tâng hŏ́ng múh rup án mial ki. Chơ rup cũai samiang ki lứq bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yiang Sursĩ khoiq táq muoi nưong coah angia mandang loŏh pỡ ntốq ramứh Ê-dên. Yiang Sursĩ yỗn cũai án mbỡiq tễng ỡt tâng nưong ki. ");
INSERT INTO bru_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yiang Sursĩ yỗn máh aluang tâng nưong ki padốh tễ pưn cutễq. Nheq tữh aluang ki la o cớp nêuq lứq cớp palâi la cha ễm. Ma bữn bar nỡm aluang mpha tễ aluang canŏ́h ca dáh tâng mpứng dĩ nưong ki. Muoi nỡm bữn ramứh ‘aluang ca yỗn tamoong mantái’. Ma muoi nỡm ễn bữn ramứh ‘aluang ca yỗn dáng ŏ́c o cớp ŏ́c sâuq’. ");
INSERT INTO bru_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Bữn muoi crỗng hoi tễ cruang Ê-dên yỗn nưong ki cỡt thớm. Chơ crỗng ki tampễq cỡt pỗn song. ");
INSERT INTO bru_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ramứh song muoi la Pi-sôn, song nâi hoi viel cruang Havi-la. ");
INSERT INTO bru_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Tâng cruang ki bữn yễng o, trâm, cớp tamáu moat, têq táq crơng ra‑ỗt. ");
INSERT INTO bru_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ramứh song bar la Ki-hôn, song nâi hoi viel cruang Cut. ");
INSERT INTO bru_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ramứh song pái la Ti-crit, song nâi hoi tễ cruang Asi-ria coah angia mandang loŏh. Cớp ramứh song pỗn la Ơ-phơ-rat. ");
INSERT INTO bru_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Chơ Yiang Sursĩ dững cũai samiang mut ỡt tâng nưong Ê-dên ki, yỗn án asa cớp kĩaq. ");
INSERT INTO bru_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma Yiang Sursĩ patâp cũai ki neq: “Palâi tễ máh nỡm aluang tâng nưong nâi têq mới cha. ");
INSERT INTO bru_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ma bữn muoi nỡm aluang ramứh ‘aluang ca yỗn dáng ŏ́c o cớp ŏ́c sâuq’, ki mới chỗi cha. Khân tangái aléq mới cha palâi tễ nỡm ki, lứq samoât mới cóq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yiang Sursĩ pai: “Cũai samiang ỡt manoaq ki tỡ o. Ngkíq cứq ễ tễng manoaq ễn yỗn chuai án.” ");
INSERT INTO bru_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yiang Sursĩ khoiq mial cutễq tễng cỡt máh charán; moâm án tễng, chơ án atoâq pỡ samiang ki yoc ễ dáng ntrớu samiang nâi amứh máh charán ki. Nŏ́q samiang ki amứh, lứq cỡt ramứh ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Chơ samiang nâi amứh nheq tữh máh charán dống, charán cruang, cớp chớm pâr tâng paloŏng. Mŏ Adam, ki tỡ yũah bữn noau ỡt táq yớu cớp chuai án. ");
INSERT INTO bru_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ngkíq, Yiang Sursĩ táq yỗn Adam bếq langêt lứq. Tữ Adam bếq, án ĩt muoi ntreh nghang bran tễ tỗ Adam, cớp tễng loah sâiq bân ntốq án ĩt nghang bran. ");
INSERT INTO bru_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Chơ Yiang Sursĩ tễng nghang bran tễ Adam cỡt manoaq cũai mansễm. Cớp Yiang Sursĩ dững mansễm ki atoâq yỗn Adam. ");
INSERT INTO bru_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adam pai neq: “Sanua bữn manoaq ĩn tháng cứq! Lứq samoât cũai nâi cỡt tễ nghang cớp sâiq cứq. Ramứh cũai nâi cứq dŏq ‘mansễm’, cỗ án cỡt tễ samiang.” ");
INSERT INTO bru_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yuaq ngkíq, cũai samiang ễ yoah tễ mpiq mpoaq, chơ ỡt parnơi cớp lacuoi án. Ngkíq alới bar náq lacuoi cayac cỡt máh muoi noaq sâng. ");
INSERT INTO bru_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adam cớp lacuoi án ỡt mu rariat, ma alới tỡ bữn sâng casiet ntrớu. ");
INSERT INTO bru_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yiang Sursĩ tễng dũ ramứh charán, ma cusân ki khễuq phếq thũ hỡn tễ máh charán canŏ́h. Cusân nâi toâq pỡ mansễm cớp blớh neq: “Lứq ma tỡ, Yiang Sursĩ khoiq patâp anhia chỗi cha palâi tễ nheq tữh aluang tâng nưong nâi?” ");
INSERT INTO bru_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mansễm ki ta‑ỡi cusân neq: “Hếq têq cha nheq tữh palâi tễ aluang tâng nưong nâi. ");
INSERT INTO bru_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ma bữn muoi nỡm aluang dáh tâng mpứng dĩ nưong, palâi tễ nỡm ki Yiang Sursĩ patâp hếq neq: ‘Anhia chỗi cha cớp chỗi satoaq palâi tễ aluang ki. Khân anhia cha tỡ la satoaq palâi ki, anhia cuchĩt toâp!’” ");
INSERT INTO bru_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma cusân pai loah chóq mansễm ki neq: “Lứq samoât, mới tỡ bữn cuchĩt mŏ. ");
INSERT INTO bru_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yiang Sursĩ dáng, khân mới cha palâi ki, bo ki toâp mứt mới cỡt poang cớp cỡt rangoaiq machớng Yiang Sursĩ tê, têq dáng nheq ŏ́c o cớp ŏ́c sâuq.” ");
INSERT INTO bru_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ngkíq, mansễm ki hữm aluang ki nêuq lứq, cớp palâi tễ aluang ki têq yỗn án cỡt rangoaiq. Chơ mansễm ki kéh cha. Moâm ki án avơi yỗn cayac án cha palâi ki. Chơ cayac án cha tê. ");
INSERT INTO bru_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tữ moâm alới cha palâi ki, alới dáng raloaih sa‑ữi ramứh ễn, cớp alới mbỡiq dáng alới ỡt rariat. Ngkíq alới ĩt sala aluang, mansễm clốh patĩng sala tarúng táq sớn, cớp samiang clốh patĩng sala tarúng táq sarlai. ");
INSERT INTO bru_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Toâq tabữ, Yiang Sursĩ pỡq pha nưong ki. Alới bar náq sâng sưong Yiang Sursĩ. Ngkíq alới tooq Yiang Sursĩ campáng nỡm aluang tâng nưong ki. ");
INSERT INTO bru_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma Yiang Sursĩ arô samiang ki neq: “Adam ơi! Nléq mới ỡt?” ");
INSERT INTO bru_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam ta‑ỡi neq: “Cứq khoiq sâng sưong anhia tâng nưong, ma cứq ngcŏh, cỗ cứq ỡt rariat. Ngkíq, cứq tooq chíq.” ");
INSERT INTO bru_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yiang Sursĩ blớh án neq: “Noau atỡng yỗn mới dáng, pai mới ỡt rariat? Mới khoiq cha palâi aluang cứq patâp chỗi cha ki tỡ?” ");
INSERT INTO bru_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Án ta‑ỡi neq: “Cũai mansễm ca anhia khoiq chiau yỗn cứq, án avơi yỗn cứq cha palâi tễ aluang ki.” ");
INSERT INTO bru_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Chơ Yiang Sursĩ blớh mansễm ki neq: “Mới khoiq táq ntrớu?” Mansễm ki ta‑ỡi: “Cusân ki rathũ cứq. Yuaq ngkíq cứq cha palâi ki.” ");
INSERT INTO bru_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yiang Sursĩ pai chóq cusân ki neq: “Cỗ tian mới khoiq táq ranáq ki, mới roap ŏ́c bap hỡn tễ máh charán canŏ́h, mới cóq pỡq talor níc tũiq anhúq mới. ");
INSERT INTO bru_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Cứq lứq táq yỗn mới cớp mansễm nâi cỡt par‑ũal níc. Cớp cứq yỗn nheq tŏ́ng mới cớp nheq tŏ́ng mansễm nâi cỡt par‑ũal níc tê. Ma lứq bữn manoaq tễ tŏ́ng mansễm nâi, án ki lứq tĩn plỡ mới. Ngkíq mới cỡt pê. Ma mới têq tot candỡl ayững án sâng.” ");
INSERT INTO bru_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Chơ Yiang Sursĩ atỡng mansễm ki neq: “Toâq mới mumiaq, cứq yỗn mới bữn sa‑ữi ramứh túh coat ễn. Cớp toâq tangái léq mới sễt con, cứq yỗn mới chĩuq a‑ĩ lứq. Ma noâng mới yoc ễ bữn cayac mới. Cớp cayac mới cỡt sốt mới.” ");
INSERT INTO bru_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Moâm ki Yiang Sursĩ atỡng Adam neq: “Cỗ tian mới khoiq tamứng parnai lacuoi mới, cớp khoiq cha palâi tễ aluang ca cứq patâp chỗi cha; ngkíq cứq ễ táq yỗn cutễq cỡt coat lứq amia máh bát bai dŏq yỗn cỡt crơng sana mới cha. Cứq táq ngkíq la cỗ tian mới tỡ bữn trĩh. Sốt anhúq mới cóq táq moat ễ khlốh múh ễ padŏ́h, ki nŏ́q bữn sana cha. ");
INSERT INTO bru_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ma cutễq ki, án amia sa‑ữi thữ nỡm sarlia hỡ. Cóq mới cha sa‑ữi thữ bát bai tễ nia sarái. ");
INSERT INTO bru_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Lứq mới têq cha crơng sana máh cutễq amia, ma cóq mới táq sarốh pahũr yũr cumứl, ki nŏ́q bữn crơng sana cha. Cóq mới táq ranáq ntâng níc toau toâq tangái léq mới cỡt loah cutễq sĩa, yuaq cứq khoiq tễng mới tễ cutễq. Cỗ mới cỡt tễ cutễq; ngkíq mới cóq chu loah pỡ cutễq.” ");
INSERT INTO bru_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Moâm Yiang Sursĩ pai ngkíq, Adam amứh lacuoi án ramứh Ê-va, cỗ mansễm nâi cỡt mpiq nheq tữh cũai. Ramứh Ê-va parlong loah la ‘tamoong’. ");
INSERT INTO bru_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Moâm ki, Yiang Sursĩ táq tampâc toâq ngcâr charán yỗn Adam cớp Ê-va tâc. ");
INSERT INTO bru_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yiang Sursĩ pai neq: “Sanua nâi, Adam cỡt machớng hái tê, án dáng ŏ́c ntrớu o cớp ŏ́c ntrớu sâuq. Sanua, cŏh lơ Adam tavoc kéh ĩt cha palâi ‘aluang dŏq tamoong mantái’. Khân án táq ngkíq, ki án bữn tamoong mantái, tỡ bữn cuchĩt noâng.” ");
INSERT INTO bru_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ngkíq Yiang Sursĩ tuih aloŏh Adam tễ nưong Ê-dên, cớp yỗn án táq sarái cái nia tâng cutễq Yiang Sursĩ khoiq tễng án tễ nhũang chơ. ");
INSERT INTO bru_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Moâm Yiang Sursĩ tuih aloŏh Adam, án dŏq máh chê-rup yỗn kĩaq nưong Ê-dên coah angia mandang loŏh. Cớp Yiang Sursĩ dŏq muoi pla dau blữ ĩn ũih cớp ễr níc, yỗn kĩaq rana pỡq chu nỡm ‘aluang ca yỗn tamoong mantái’. ");
INSERT INTO bru_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam cớp Ê-va, lacuoi án, alới táq cha amia apu, canỡt muoi lám con samiang; chơ alới amứh con alới ramứh Ca-in. Ê-va pai neq: “Cứq têq canỡt con samiang nâi la cỗ nhơ Yiang Sursĩ chuai.” ");
INSERT INTO bru_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ntun ễn, Ê-va canỡt a‑ễm Ca-in, ramứh Aben. Toâq alới toâr cỡt carsai, Aben táq ranáq bán cữu, ma Ca-in táq ranáq chóh saro sapua. ");
INSERT INTO bru_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bữn muoi tangái Ca-in dững crơng án chóh ễ chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Aben la yoc ễ sang tê; ngkíq án dững con cữu roah pốh dâu cớp nsễng cữu ki. Yiang Sursĩ sâng bũi cớp Aben, cỗ nhơ tễ máh crơng án chiau sang. ");
INSERT INTO bru_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ma Yiang Sursĩ tỡ bữn sâng bũi chóq Ca-in cớp crơng án chiau sang ki. Yuaq ngkíq, Ca-in sâng ũan lứq tâng mứt án, cớp moat án chốh asễng. ");
INSERT INTO bru_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yiang Sursĩ blớh Ca-in neq: “Nŏ́q mới sâng ũan lứq? Cớp nŏ́q mới chốh moat asễng? ");
INSERT INTO bru_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Khân mới táq ranáq pĩeiq, cứq sâng bũi cớp mới tê. Ma khân mới táq ranáq tỡ bữn pĩeiq, ŏ́c lôih ỡt cheq mới cớp yoc ễ táq mới. Ŏ́c lôih nâi ỡt ríng cheq ngoah toong ariang cula yoc ễ palŏ́ng cáp mới. Ma cóq mới riap tễ ŏ́c lôih ki.” ");
INSERT INTO bru_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Bữn muoi tangái Ca-in pai chóq Aben, a‑ễm án: “Hâi! Hái pỡq chu sarái.” Ma bo alới ỡt tâng sarái, Ca-in palŏ́ng cớp cachĩt Aben. ");
INSERT INTO bru_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yiang Sursĩ blớh Ca-in neq: “Nléq Aben, a‑ễm mới?” Ma Ca-in ta‑ỡi: “Cứq tỡ dáng! Nŏ́q cứq ỡt kĩaq níc án tỡ?” ");
INSERT INTO bru_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Chơ Yiang Sursĩ blớh ễn Ca-in neq: “Mới khoiq táq ntrớu chóq án? Sanua, cutễq nguaiq aham a‑ễm ca mới khoiq cachĩt. Nâi la riang sưong án arô cứq tễ cutễq, sễq yỗn cứq carláh dỡq yỗn án. ");
INSERT INTO bru_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Cỗ tian mới cachĩt án cớp táq aham án tahóc tâng cutễq, mới cóq roap ŏ́c pupap. Cứq ễ tuih aloŏh mới tễ cutễq o nâi. ");
INSERT INTO bru_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Toâq mới chóh ŏ́c ntrớu tâng cutễq mới ỡt, cutễq ki tỡ bữn amia crơng sana yỗn mới bữn. Cớp cóq mới dễq chu nâi chu ki níc toau tũiq anhúq mới.” ");
INSERT INTO bru_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Ca-in atỡng loah Yiang Sursĩ neq: “Nheq tữh máh ramứh túh coat nâi cứq tỡ rơi chĩuq. ");
INSERT INTO bru_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tangái nâi anhia tuih aloŏh cứq tễ cutễq o nâi, cớp tỡ yỗn cứq ỡt noâng choâng moat anhia. Cứq cóq dễq chu nâi chu ki níc tâng cốc cutễq nâi. Khân noau ramóh cứq, án ễ cachĩt cứq.” ");
INSERT INTO bru_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma Yiang Sursĩ atỡng loah Ca-in neq: “Tỡ cỡn ngkíq. Khân bữn cũai aléq ma cachĩt mới, cũai ki cóq roap ŏ́c túh coat clữi tễ mới tapul trỗ ễn.” Chơ Yiang Sursĩ yỗn Ca-in bữn muoi tếc dŏq cũai canŏ́h dáng alới tỡ têq cachĩt án. ");
INSERT INTO bru_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Moâm ki án loŏh tễ Yiang Sursĩ, cớp án dễq níc chu nâi chu ki tâng cruang Not coah angia mandang loŏh nưong Ê-dên. ");
INSERT INTO bru_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Vớt ki, Ca-in cớp lacuoi án, alới táq cha amia apu. Lacuoi án canỡt muoi lám con samiang ramứh Ê-nóc. Bo ki Ca-in ayứng muoi vil. Án amứh vil ki Ê-nóc tũoiq ramứh con samiang án. ");
INSERT INTO bru_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ê-nóc amia con samiang ramứh I-rat. I-rat amia con samiang ramứh Mê-huya-el. Mê-huya-el amia con samiang ramứh Mê-tusa-el. Cớp Mê-tusa-el amia con samiang ramứh Lamec. ");
INSERT INTO bru_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamec ĩt bar lám lacuoi. Lacuoi nỡm ramứh Adáh. Lacuoi cỗiq ramứh Si-láh. ");
INSERT INTO bru_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adáh canỡt con samiang ramứh Yabal. Yabal táq dống aroâiq; án cỡt cũai tễ dâu lứq aloŏh ngê táq ngkíq. Cũai ca ỡt tâng dống aroâiq, alới bán tariac ntroŏq. ");
INSERT INTO bru_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal bữn a‑ễm ramứh Yubal. Cớp Yubal cũai dâu lứq tapáih achúng cớp plóng máh crơng lampỡiq. ");
INSERT INTO bru_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si-láh bữn con samiang, ramứh Tubal Ca-in. Tubal Ca-in la cũai dâu lứq têq dudễr tac. Cớp án bữn amuaq ramứh Nama. ");
INSERT INTO bru_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ngkíq, Lamec atỡng bar lám lacuoi án neq: “Adáh cớp Si-láh, lacuoi cứq ơi! Anhia tamứng santoiq cứq nâi. Cứq khoiq cachĩt manoaq cũai póng ca khoiq táq bớc cứq nhũang, la cũai ca khoiq táq yỗn sâiq cứq cỡt trúc. ");
INSERT INTO bru_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Khân cũai aléq ma cachĩt Ca-in, Yiang Sursĩ lứq carláh dỡq yỗn cũai ki tapul trỗ hỡn tễ ŏ́c túh coat Ca-in cóq roap cỗ án cachĩt chíq Aben. Ma khân cũai aléq cachĩt cứq, ki Yiang Sursĩ ễ carláh dỡq chóq cũai ki tapul chít tapul trỗ hỡn tễ cũai ca cachĩt chíq Ca-in ễn.” ");
INSERT INTO bru_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam cớp lacuoi án, alới amia muoi lám con samiang ễn, chơ Ê-va amứh con ki Sêt, yuaq án pai neq: “Yiang Sursĩ yỗn cứq bữn muoi lám ễn con samiang dŏq pláih loah Aben ma Ca-in khoiq cachĩt chơ.” ");
INSERT INTO bru_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sêt amia muoi lám con samiang tê. Án amứh con ki la Ê-nôih. Tữ ki, máh cũai mbỡiq arô cớp câu nhơ ramứh Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nâi la saráq chĩc atỡng tễ tŏ́ng toiq Adam. Bo Yiang Sursĩ tễng Adam, án tễng machớng riang án tê. ");
INSERT INTO bru_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yiang Sursĩ tễng cũai samiang cớp cũai mansễm, cớp án yỗn alới bữn ŏ́c bốn sa‑ữi. Toâq Yiang Sursĩ tễng alới, án dŏq ramứh alới la ‘cũai’. ");
INSERT INTO bru_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Toâq Adam khoiq bữn muoi culám pái chít cumo, án amia muoi lám con samiang tũoiq roâp án tê. Cớp mứt pahỡm con samiang ki tũoiq mứt pahỡm Adam tê. Adam amứh con ki la Sêt. ");
INSERT INTO bru_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Moâm Adam amia Sêt, án noâng bữn tamoong tacual culám cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ngkíq Adam bữn tamoong nheq tữh la takêh culám pái chít cumo. Moâm ki Adam cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Toâq Sêt khoiq bữn muoi culám sỡng cumo, án amia con samiang ramứh Ê-nôih. ");
INSERT INTO bru_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Moâm Sêt amia Ê-nôih, án noâng bữn tamoong tacual culám tapul cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sêt bữn tamoong nheq tữh la takêh culám muoi chít la bar cumo. Moâm ki Sêt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Toâq Ê-nôih khoiq bữn takêh chít cumo, án amia con samiang ramứh Kê-nan. ");
INSERT INTO bru_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Moâm Ê-nôih amia Kê-nan; án noâng bữn tamoong tacual culám muoi chít la sỡng cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ê-nôih bữn tamoong nheq tữh la takêh culám sỡng cumo. Moâm ki Ê-nôih cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Toâq Kê-nan khoiq bữn tapul chít cumo, án amia con samiang ramứh Maha-lalê. ");
INSERT INTO bru_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Moâm Kê-nan amia Maha-lalê; án noâng bữn tamoong tacual culám pỗn chít cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kê-nan bữn tamoong nheq tữh la takêh culám muoi chít cumo. Moâm ki Kê-nan cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Toâq Maha-lalê khoiq bữn tapoât chít la sỡng cumo, án amia con samiang ramứh Yaret. ");
INSERT INTO bru_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Moâm Maha-lalê amia Yaret, án noâng bữn tamoong tacual culám pái chít cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maha-lalê bữn tamoong nheq tữh la tacual culám takêh chít la sỡng cumo. Moâm ki Maha-lalê cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Toâq Yaret khoiq bữn muoi culám tapoât chít la bar cumo, án amia con samiang ramứh Ê-nóc. ");
INSERT INTO bru_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Moâm Yaret amia Ê-nóc, án noâng bữn tamoong tacual culám tapoât chít la bar cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaret bữn tamoong nheq tữh la takêh culám tapoât chít la bar cumo. Chơ Yaret cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Toâq Ê-nóc khoiq bữn tapoât chít la sỡng cumo, án amia con samiang ramứh Mê-thu-sala. ");
INSERT INTO bru_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ê-nóc bữn muoi mứt cớp Yiang Sursĩ toau sốt nheq dỡi tamoong án. Moâm Ê-nóc amia Mê-thu-sala, cớp án noâng bữn tamoong pái culám cumo ễn, cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ê-nóc bữn tamoong nheq tữh la pái culám tapoât chít la sỡng cumo. ");
INSERT INTO bru_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Cớp án ỡt níc muoi mứt cớp Yiang Sursĩ. Ngkíq, Yiang Sursĩ dững án chu ỡt cớp Yiang Sursĩ. Lứq án tỡ bữn cuchĩt, ma án sarbiet chíq tễ cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Toâq Mê-thu-sala khoiq bữn muoi culám tacual chít tapul cumo, án amia con samiang ramứh Lamec. ");
INSERT INTO bru_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Moâm Mê-thu-sala amia Lamec, án noâng bữn tamoong tapul culám tacual chít cumo ễn. Cớp noâng bữn amia con samiang con mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mê-thu-sala bữn tamoong nheq tữh la takêh culám tapoât chít takêh cumo. Moâm ki Mê-thu-sala cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Toâq Lamec khoiq bữn muoi culám tacual chít la bar cumo, án amia con samiang. ");
INSERT INTO bru_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Án amứh con ki la Nô-ê, cớp án pai neq: “Hái bữn sa‑ữi ŏ́c túh arức toâq hái táq tâng cutễq nâi, cỗ Yiang Sursĩ khoiq pupap cutễq nâi tỡ yỗn amia crơng sana. Ma Nô-ê aliam mứt pahỡm hái, toâq hái táq ranáq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Moâm Lamec amia Nô-ê, án noâng bữn tamoong sỡng culám takêh chít la sỡng cumo ễn, cớp amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamec bữn tamoong nheq tữh la tapul culám tapul chít tapul cumo. Moâm ki Lamec cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Toâq Nô-ê khoiq bữn sỡng culám cumo, án amia pái lám con samiang. Án amứh con ki la: Sem, Ham, cớp Yaphêt. ");
INSERT INTO bru_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Toâq tangái cũai tâng cốc cutễq nâi bữn amia con mansễm clứng chơ. ");
INSERT INTO bru_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Bữn máh cũai samiang cỡt ariang con yiang, cớp alới hữm cũai mansễm ki bữn thán riang la‑ĩat. Chơ samiang ki ĩt mansễm ki táq lacuoi puai mứt pahỡm alới yoc. ");
INSERT INTO bru_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yiang Sursĩ pai neq: “Raviei cứq tỡ bữn noâng yỗn cũai tamoong níc; cóq alới cuchĩt. Tễ nâi chumát cứq tỡ yỗn alới tamoong luat tễ muoi culám bar chít cumo.” ");
INSERT INTO bru_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tâng dỡi ki, dếh dỡi ntun, bữn cũai tỗ chác toâr cớp rêng lứq ỡt tâng cốc cutễq nâi. Tangái ki máh con samiang ca ariang con yiang racoâiq cớp con mansễm cũai; alới táq cha amia apu, chơ bữn con. Cũai tễ mbŏ́q yám máh cũai tỗ chác toâr cớp rêng. Cớp alới clễu ramứh cũai ki hỡ. ");
INSERT INTO bru_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yiang Sursĩ hữm ranáq cũai táq tâng cốc cutễq nâi cỡt pampla cớp loâi la‑ữt. Cớp tâng mứt pahỡm máh cũai chanchớm la sâuq níc. ");
INSERT INTO bru_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yiang Sursĩ sâng ngua lứq án khoiq tễng cũai tâng cốc cutễq nâi, cớp mứt pahỡm án sâng a‑ĩ lứq. ");
INSERT INTO bru_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Chơ Yiang Sursĩ pai neq: “Cứq ễ pupứt nheq tữh cũai cớp nheq tữh charán tễ charán talor toau dếh chớm pâr tâng paloŏng ca cứq khoiq tễng tâng cốc cutễq nâi. Cứq táq ngkíq, la cỗ cứq sâng ngua lứq tian cứq khoiq tễng nheq tữh máh ramứh ki.” ");
INSERT INTO bru_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma Yiang Sursĩ sâng bũi pahỡm cớp ống manoaq Nô-ê sâng. ");
INSERT INTO bru_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tâng dỡi tamoong Nô-ê, ki án cỡt cũai mantoat cớp tanoang tapứng lứq. Nô-ê cỡt muoi mứt cớp Yiang Sursĩ. Ngkíq, tâng choâiq nâi bữn chĩc atỡng tễ Nô-ê. ");
INSERT INTO bru_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nô-ê amia pái lám con samiang, ramứh: Sem, Ham, cớp Yaphêt. ");
INSERT INTO bru_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tangái ki, nheq tữh cũai tâng cốc cutễq nâi la sâuq lứq choâng moat Yiang Sursĩ, cớp dũ náq cũai manoaq táq pampla chóq manoaq. ");
INSERT INTO bru_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ngkíq, Yiang Sursĩ nhêng chu nheq tữh cũai, cớp án dáng alới yoc lứq táq ranáq sâuq. Nheq tữh cũai khoiq puai nheq ngê sâuq tâng cốc cutễq nâi chơ. ");
INSERT INTO bru_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Yiang Sursĩ atỡng Nô-ê neq: “Khoiq cheq toâq chơ tangái cứq ễ pupứt nheq tữh cũai. Ranáq sâuq khoiq pláh chũop cốc cutễq, cỗ tian tễ máh cũai ki táq níc ranáq sâuq. Ngkíq cứq ễ pupứt nheq máh cũai tâng cốc cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Sanua cóq mới táq muoi lám tuoc toâq pian. Tuoc ki, cóq mới táq sa‑ữi clống, cớp atia siet coah clống cớp coah tiah. ");
INSERT INTO bru_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Cóq mới táq tuoc nâi neq: Cuti pái culám coat, la‑a sỡng chít coat, cớp sarỡih pái chít coat. ");
INSERT INTO bru_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Cóq mới táq toong piang yỗn cheq cớp sarpo tuoc, sarỡih muoi coat, la‑a ki puai ratâng tuoc. Ma tâng clống tuoc, ki mới táq cỡt pái tran, cớp táq dŏq muoi lám ngoah toong yáng coah pa tuoc. ");
INSERT INTO bru_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Cứq ễ táq yỗn bữn raloâm dỡq pláh nheq tâng cốc cutễq nâi. Cứq ễ pathréc nheq máh ramứh tamoong tâng pưn paloŏng cutrúq. Chơ dũ ramứh ỡt tâng ki lứq cuchĩt thréc nheq. ");
INSERT INTO bru_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma cứq ễ táq tếc parkhán cớp mới. Cóq mới dững con lacuoi mới cớp cumân mới, chơ nheq tữh anhia mut ỡt tâng tuoc ki. ");
INSERT INTO bru_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Cớp pong máh charán dũ thữ amut tâng tuoc ki. Muoi ramứh muoi lám tôl, muoi lám cán, cớp muoi lám tông, muoi lám atu. Cóq mới bán kĩaq nheq charán ki. Ngkíq dũ ramứh charán toâq pỡ mới yỗn mới chuai alới bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Muoi ramứh charán toâq pỡ mới cỡt cu, dũ thữ chớm, dũ thữ charán talor, cớp dũ thữ charán canŏ́h hỡ. ");
INSERT INTO bru_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Cóq mới dững dũ ramứh crơng sana. Cóq mới dŏq máh sana ki yỗn anhia cớp charán khám cha.” Ki la máh santoiq Yiang Sursĩ atỡng Nô-ê. ");
INSERT INTO bru_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ngkíq, máh ŏ́c Yiang Sursĩ patâp Nô-ê, Nô-ê táq puai nheq dũ ramứh. ");
INSERT INTO bru_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Chơ Yiang Sursĩ atỡng Nô-ê ễn neq: “Mới cớp nheq dống sũ mới cóq mut tâng tuoc, yuaq tâng dỡi nâi cứq dáng mới la cũai tanoang lứq choâng moat cứq. ");
INSERT INTO bru_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Cóq mới dững dũ ramứh charán, charán bráh puai rit cớp charán tỡ bữn bráh puai rit. Máh ramứh charán bráh, cóq mới dững tapul cu, dếh tôl dếh cán. Ma máh ramứh charán tỡ bữn bráh, cóq mới dững muoi cu sâng, tôl cớp cán. ");
INSERT INTO bru_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Cớp cóq mới dững túc ramứh chớm pâr tâng paloŏng, muoi ramứh tapul cu, tông cớp atu hỡ. Ngkíq dŏq patŏ́ng cuplốq tỡ bữn yỗn pứt tễ cốc cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Noâng tapul tangái ễn cứq yỗn mia sễng chu cutễq nâi, pỗn chít tangái pỗn chít sadâu. Cứq táq ngkíq dŏq pupứt nheq máh ramứh tamoong ca cứq khoiq tễng chơ tâng cloong cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ngkíq Nô-ê trĩh nheq máh parnai Yiang Sursĩ patâp yỗn án táq. ");
INSERT INTO bru_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tangái raloâm dỡq toâq tâng cốc cutễq nâi, bo ki Nô-ê khoiq bữn tapoât culám cumo chơ. ");
INSERT INTO bru_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ngkíq Nô-ê cớp con lacuoi án, dếh cumân án hỡ, mut ỡt tâng tuoc yỗn vớt tễ raloâm dỡq. ");
INSERT INTO bru_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Cớp dũ ramứh charán, dếh charán bráh puai rit cớp charán tỡ bữn bráh, dếh charán talor cớp túc ramứh chớm hỡ, nheq tữh ramứh charán ki bữn cỡt cu nheq, bữn tông bữn atu, bữn tôl bữn cán mut tâng tuoc machớng parnai Yiang Sursĩ khoiq patâp Nô-ê. ");
INSERT INTO bru_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Vớt tễ ki, bữn tapul tangái ễn, bữn raloâm dỡq toâq tâng cloong cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Toâq Nô-ê bữn tapoât culám cumo, tangái muoi chít tapul, casâi bar cumo ki, mia tễ paloŏng choân lứq cớp nheq tữh abóc dỡq padŏ́h, cỡt dỡq toâr lứq. ");
INSERT INTO bru_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ngkíq mia sễng tâng cloong cutễq nâi nheq pỗn chít tangái pỗn chít sadâu. ");
INSERT INTO bru_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tâng tangái ki, Nô-ê cớp lacuoi án, pái náq con samiang án ramứh Sem, Ham, cớp Yaphêt, cớp pái náq cumân án, nheq tữh alới mut tâng tuoc. ");
INSERT INTO bru_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Cớp dũ ramứh charán toâq pỡ Nô-ê mut tâng tuoc ki tê. Bữn charán cruang cớp charán dống, charán talor, cớp chớm pâr, dếh dũ ramứh canŏ́h ca bữn khlap hỡ. ");
INSERT INTO bru_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dũ ramứh charán tamoong ki toâq cỡt cu nheq, bữn tông cớp atu, bữn tôl cớp cán. ");
INSERT INTO bru_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Lứq cỡt rapĩeiq ĩn Yiang Sursĩ khoiq patâp Nô-ê chơ. Moâm ki, Yiang Sursĩ catáih chíq toong tuoc. ");
INSERT INTO bru_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nheq pỗn chít tangái raloâm dỡq toâq tâng cloong cutễq nâi. Dỡq chỗn níc. Ngkíq tuoc ki dỗih achỗn luat tễ cloong cutễq. ");
INSERT INTO bru_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dỡq ki coar cớp clưn achỗn pláh nheq cloong cutễq. Tuoc ki dỗih tâng pỡng cloong dỡq. ");
INSERT INTO bru_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Cớp dỡq ki cỡt clưn toâr lứq lơ ễn, chơ án clứp nheq máh cóh sarỡih lứq tâng pưn paloŏng cutrúq nâi. ");
INSERT INTO bru_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dỡq ki clứp luat nheq tễ máh anũol cóh la muoi chít la sỡng coat. ");
INSERT INTO bru_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nheq ramứh tamoong cớp pupỡq tâng cốc cutễq nâi cỡt cuchĩt nheq, dếh chớm, dếh charán dống, dếh charán cruang, dếh charán canŏ́h, cớp dếh máh cũai hỡ. ");
INSERT INTO bru_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nheq tữh ramứh ca tangứh cớp dốq ỡt tâng cutễq cuchĩt nheq. ");
INSERT INTO bru_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ngkíq, Yiang Sursĩ pupứt nheq máh ramứh ỡt tâng cốc cutễq nâi, dếh cũai, dếh chớm, dếh charán talor, cớp dếh máh charán canŏ́h hỡ. Nheq charán ki cuchĩt cỡt pứt nheq tễ cloong cutễq nâi. Ma Nô-ê cớp nheq náq tâng dống sũ án, cớp charán ỡt cớp án tâng tuoc, ống alới toâp noâng bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Raloâm dỡq dớng loah tâng pỡng cloong cutễq nâi nheq muoi culám sỡng chít tangái. ");
INSERT INTO bru_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma Yiang Sursĩ tỡ bữn khlĩr Nô-ê, cớp nheq tữh charán cruang cớp charán dống ca ỡt cớp Nô-ê tâng tuoc ki. Yiang Sursĩ tễng cuyal phát ploaq chũop nheq cloong cutễq nâi. Chơ dỡq mbỡiq sarễt. ");
INSERT INTO bru_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Máh abóc dỡq cỡt laviei loah, cớp dỡq tễ paloŏng la tỡ bữn sễng noâng. Mia la tỡ bữn choân noâng; án yứh ễn. ");
INSERT INTO bru_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Toâq vớt muoi culám sỡng chít tangái tễ raloâm dỡq toâq tâng cutễq nâi, ngkíq dỡq ki ngcuai sarễt muoi tangái bĩq, muoi tangái bĩq. ");
INSERT INTO bru_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tangái muoi chít tapul, casâi tapul, tuoc Nô-ê kiang tâng anũol cóh A-rarat. ");
INSERT INTO bru_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ma dỡq, ki cu rangái muoi tangái bĩq muoi tangái bĩq án sarễt yỗn toau toâq tangái muoi, casâi muoi chít. Tangái ki nŏ́q mpáh loah máh anũol cóh. ");
INSERT INTO bru_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Vớt tễ tangái ki bữn pỗn chít tangái ễn nŏ́q Nô-ê pớh toong án khoiq táq dŏq tâng tuoc ki. ");
INSERT INTO bru_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Cớp án acláh muoi lám chớm ca‑ac. Chớm ki pâr luloah níc toau toâq tangái dỡq sarễt tễ cloong cutễq. ");
INSERT INTO bru_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Chơ Nô-ê acláh muoi lám chớm tariap ễn yỗn pỡq nhêng dỡq sarễt chơ ma tỡ yũah. ");
INSERT INTO bru_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ma chớm tariap nâi tỡ ramóh muoi ntốq léq yỗn án têq póc. Chơ án pâr píh loah chu tuoc sĩa, yuaq dỡq noâng ỡt pláh tâng pỡng cloong cutễq. Nô-ê tavoc cỗp chớm tariap ki, cớp amut loah tâng tuoc. ");
INSERT INTO bru_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tễ tangái ki Nô-ê acoan bữn tapul tangái ễn, ki nŏ́q án acláh sĩa chớm tariap. ");
INSERT INTO bru_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Toâq tabữ, chớm tariap nâi pâr chu loah pỡ tuoc cớp cubỗ muoi liang sala o‑li‑vê ramoong. Ngkíq, Nô-ê dáng lứq samoât raloâm dỡq khoiq sarễt sa‑ữi chơ. ");
INSERT INTO bru_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tễ tangái ki Nô-ê acoan bữn tapul tangái ễn, nŏ́q án acláh loah chớm tariap ki. Tữ án acláh trỗ nâi, chớm tariap ki tỡ bữn chu noâng pỡ án. ");
INSERT INTO bru_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tâng cumo Nô-ê bữn tapoât culám muoi cumo, tangái muoi, casâi muoi, raloâm dỡq ki sarễt tháng tễ cloong cutễq. Moâm ki, Nô-ê tŏ́h nheq sarpo tuoc. Án tapoang nhêng chu nâi chu ki, án hữm cloong cutễq khoiq cheq khỗ chơ. ");
INSERT INTO bru_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tangái bar chít tapul, casâi bar cutễq cỡt khỗ loah nheq. ");
INSERT INTO bru_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yiang Sursĩ atỡng Nô-ê neq: ");
INSERT INTO bru_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Cóq mới dững lacuoi, con, cớp cumân mới loŏh tễ tuoc nâi. ");
INSERT INTO bru_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Cớp cóq mới pong aloŏh tê máh charán mới khoiq amut tâng tuoc, dếh chớm, dếh charán talor, dếh charán dống dŏq yỗn têq cỡt rứh rưong sa‑ữi lứq tâng cloong cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ngkíq Nô-ê cớp lacuoi án, dếh máh con cớp cumân án, nheq náq alới loŏh tễ tuoc. ");
INSERT INTO bru_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Cớp dũ ramứh charán ca tamoong tâng cốc cutễq nâi loŏh tễ tuoc ki tê, dũ ramứh chớm, dũ ramứh charán talor, cớp dũ ramứh charán canŏ́h hỡ. ");
INSERT INTO bru_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Chơ Nô-ê táq muoi lám prông dŏq sang toam Yiang Sursĩ. Án ĩt muoi lám charán cớp muoi lám chớm tễ nheq máh charán bráh puai rit. Án bốh charán ki tâng prông sang dŏq sa‑ỡn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yiang Sursĩ sâng bũi pahỡm toâq án sâng hỡi phuom ki. Cớp án chanchớm tâng mứt neq: “Cứq tỡ bữn pupap noâng cốc cutễq nâi cỗ tian máh cũai táq ranáq sâuq. Cứq dáng mứt pahỡm cũai chanchớm níc ranáq sâuq tễ noâng carnễn. Ma cứq tỡ bữn cachĩt noâng máh ramứh tamoong riang cứq khoiq táq tễ nhũang chơ. ");
INSERT INTO bru_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Lứq samoât, khân noâng bữn cốc cutễq nâi, ki noâng bữn tê máh ranáq neq: Catữ chuchóh cớp catữ susot, cutâu cớp leng, catữ phũac cớp catữ sangễt, tangái cớp sadâu.” ");
INSERT INTO bru_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yiang Sursĩ yỗn Nô-ê cớp con samiang án bữn ŏ́c bốn. Yiang Sursĩ atỡng alới neq: “Cóq anhia amia con acái cỡt clứng lứq ễn táq yỗn chũop nheq cốc cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nheq tữh charán ỡt tâng cốc cutễq nâi cớp nheq tữh chớm pâr tâng paloŏng, nheq tữh ramứh talor tâng cutễq, cớp nheq tữh sĩaq ỡt tâng dỡq mưt, nheq ramứh ki la ngcŏh cớp sốt pỡ atĩ anhia nheq. ");
INSERT INTO bru_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nheq ramứh tamoong cớp pupỡq tâng cutễq, anhia têq cha dũ ramứh ki. Machớng cứq khoiq yỗn anhia cha bát bai tễ nhũang, sanua cứq yỗn anhia têq cha túc ramứh. ");
INSERT INTO bru_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Khân anhia yoc ễ cha sâiq charán, cóq anhia kiac yỗn aham loŏh voai. Chỗi cha aham carchốc cớp sâiq, yuaq aham la ŏ́c tamoong. ");
INSERT INTO bru_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Cũai tỡ la charán ma cachĩt cũai canŏ́h, cứq yỗn án cóq roap tôt. ");
INSERT INTO bru_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Yuaq cứq khoiq tễng cũai machớng riang cứq tê, khân cũai aléq ma cachĩt cũai canŏ́h, ki bữn cũai canŏ́h ễn cachĩt loah cũai ki. ");
INSERT INTO bru_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ma anhia, cóq anhia amia con acái yỗn cỡt clứng lứq ễn, táq yỗn chũop cốc cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Chơ Yiang Sursĩ atỡng ễn Nô-ê cớp con samiang án neq: ");
INSERT INTO bru_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Cứq par‑ữq cớp anhia, cớp nheq tŏ́ng toiq anhia hỡ. ");
INSERT INTO bru_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Cớp machớng dếh túc ramứh charán ca ỡt cớp anhia tâng tuoc ki, dếh charán dống, dếh charán cruang, cớp dếh chớm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Cứq par‑ữq lứq samoât cớp anhia, tễ nâi chumát cứq tỡ bữn táq raloâm dỡq noâng dŏq pupứt dũ ramứh acán tamoong; cớp cứq tỡ bữn táq yỗn raloâm dỡq talốh cốc cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yiang Sursĩ pai ễn neq: “Cứq táq muoi tếc yỗn anhia dáng raloaih ralêng lứq, la cứq pruam cớp anhia, dếh máh tŏ́ng toiq anhia, cớp dũ ramứh charán ca ỡt cớp anhia. ");
INSERT INTO bru_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Cứq dŏq prêng cáng tâng paloŏng. Prêng cáng ki la tếc cứq pruam cớp anhia, cớp dũ ramứh cứq tễng tâng cutễq nâi hỡ. ");
INSERT INTO bru_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Toâq tangái léq cứq parỗm loah ramứl tâng pỡng cloong cutễq cớp prêng cáng ki palooh, ");
INSERT INTO bru_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ngkíq tangái ki cứq sanhữ loah ŏ́c cứq khoiq ữq cớp anhia, cớp dũ ramứh tamoong hỡ. Chơ cứq tỡ bữn yỗn noâng raloâm dỡq dŏq talốh dũ ramứh tamoong tâng cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ngkíq, toâq tangái léq cứq hữm prêng cáng ỡt tâng ramứl, tangái ki cứq sanhữ loah ŏ́c cứq khoiq pruam cớp dũ ramứh tamoong tâng cutễq nâi toau sốt nheq dỡi.” ");
INSERT INTO bru_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Chơ Yiang Sursĩ atỡng Nô-ê ễn neq: “Prêng cáng nâi cỡt tếc cứq khoiq pruam cớp dũ ramứh tamoong tâng cloong cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ngkíq, nheq tữh con samiang Nô-ê loŏh tễ tuoc ki bữn Sem, Ham, cớp Yaphêt. Ham la mpoaq Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Pái náq nâi la con samiang Nô-ê; alới cỡt achúc achiac dũ náq cũai ỡt tâng cốc cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nô-ê la cũai táq sarái cái nia, cớp án la cũai dâu lứq chóh voar nho. ");
INSERT INTO bru_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Toâq Nô-ê nguaiq blŏ́ng tễ palâi nho, án bũl. Chơ án bếq mu rariat tâng clống dống aroâiq án. ");
INSERT INTO bru_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, mpoaq Cana-an, án hữm mpoaq án bếq rariat, chơ án atỡng bar náq sễm ai án ca ỡt yáng tiah. ");
INSERT INTO bru_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ma Sem cớp Yaphêt, alới ĩt muoi ploah ayỡ, chơ alới tíng ayỡ táng apal alới bar náq, cớp pỡq lalín chu ntốq mpoaq alới bếq. Alới acuam ayỡ ki tâng pỡng tỗ mpoaq alới, ma moat alới tỡ bữn nhêng chu mpoaq alới ỡt mu rariat. ");
INSERT INTO bru_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Toâq Nô-ê tamỡ, cớp viei blŏ́ng chơ, án bữn dáng con ralŏ́h khoiq táq ntrớu cớp án. ");
INSERT INTO bru_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Chơ án pai neq: “Cỗ tian Ham nhêng cứq bếq mu rariat, ngkíq cứq pupap Cana-an, con án, yỗn cỡt cũai sũl yỗn máh sễm ai án.” ");
INSERT INTO bru_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Cớp Nô-ê pai ễn neq: “Cóq khễn Yiang Sursĩ la Yiang ca Sem sang. Ma yỗn Cana-an cỡt cũai sũl Sem. ");
INSERT INTO bru_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Cớp sễq Yiang Sursĩ táq yỗn tŏ́ng toiq Yaphêt cỡt clứng lứq, cớp yỗn alới ỡt ratoi cớp tŏ́ng toiq Sem. Ma yỗn Cana-an cỡt cũai sũl Yaphêt.” ");
INSERT INTO bru_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Toâq vớt raloâm dỡq, Nô-ê noâng tamoong pái culám sỡng chít cumo ễn. ");
INSERT INTO bru_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nô-ê bữn tamoong nheq tữh la takêh culám sỡng chít cumo. Chơ án cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nâi la atỡng tễ tŏ́ng toiq pái náq con samiang Nô-ê la Sem, Ham, cớp Yaphêt. Vớt raloâm dỡq, pái náq alới amia loah con acái. ");
INSERT INTO bru_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Con samiang Yaphêt la Cô-mêr, Macoc, Madai, Yavan, Tubal, Mê-siec, cớp Ti-rat. ");
INSERT INTO bru_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Con samiang Cô-mêr ễn la At-canat, Ri-phat, cớp Tô-cama. ");
INSERT INTO bru_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Tỗp con samiang Yavan la E-li-sah, Tar-sit, Kit-tim, cớp Rô-danim. ");
INSERT INTO bru_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nheq tŏ́ng toiq Yaphêt cỡt máh cũai dâu ỡt tâng tor dỡq mưt. Cỗ tễ alới ma cỡt rứh la‑ữt, cỡt sa‑ữi tỗp ngcớt puai tâng miar sâu, miar parnai táq ntỡng cớp miar cruang. ");
INSERT INTO bru_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Con samiang Ham la Cut, Mit-rêm, Put, cớp Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Con samiang Cut la Si-ba, Havi-la, Sap-ta, Ramah, cớp Sap-taca. Cớp con samiang Ramah la Sê-ba cớp De-dan. ");
INSERT INTO bru_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cut bữn muoi lám ễn con samiang, ramứh Nim-rôt. Nim-rôt la cũai dâu lứq rangoaiq rachíl tâng cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nim-rôt cỡt cũai chiang pupán charán hỡ, cỗ Yiang Sursĩ chuai án. Ngkíq, tâng santoiq pali panha pai neq: “Án la machớng Nim-rôt, chiang pupán cỗ nhơ Yiang Sursĩ chuai.” ");
INSERT INTO bru_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Tễ dâu Nim-rôt táq sốt tâng vil Ba-bulôn, E-ret, Acat, cớp vil Cal-nê ỡt tâng cruang Si-nar. ");
INSERT INTO bru_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Tễ cruang ki án pỡq chu cruang Asi-ria. Tâng cruang Asi-ria án ayứng vil tamái la vil Ni-navê, vil Rê-hô-bôt Ir, vil Calah, cớp vil Rê-sen. Vil Rê-sen la vil toâr lứq ỡt mpứng dĩ bar coah vil Ni-navê cớp vil Calah. ");
INSERT INTO bru_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Tŏ́ng toiq Mit-rêm la tỗp Lut, tỗp Anam, tỗp Lê-hap, tỗp Nap-tu, ");
INSERT INTO bru_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","tỗp Patru, tỗp Catlu, cớp tỗp Cap-tôr. Máh cũai Catlu nâi cỡt tỗp Phi-li-tin ễn. ");
INSERT INTO bru_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Con samiang clúng Cana-an la Sadôn. Cana-an la achúc achiac máh cũai Hêt. ");
INSERT INTO bru_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Nheq tŏ́ng toiq tỗp Cana-an bữn máh tỗp Yê-but, Amô-rit, Kir-casit, ");
INSERT INTO bru_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hê-vit, Ar-kit, Si-nit, ");
INSERT INTO bru_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Ar-vat, Sê-marit, cớp Hamat hỡ. Ntun ki nheq máh tŏ́ng toiq Cana-an pỡq pláh chu nâi chu ki. ");
INSERT INTO bru_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ngkíq cutễq tỗp Cana-an bữn tễ vil Sadôn toau toâq vil Casa, coah angia vil Kê-ar. Cớp coah Sadôm, Camô-rơ, At-ma, cớp Sê-bô-im, cutễq Cana-an toâq pỡ vil Lasa. ");
INSERT INTO bru_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ki la máh tŏ́ng toiq Ham. Nheq tữh tŏ́ng toiq ki cỡt mpha sâu, mpha parnai, cớp mpha cruang hỡ. ");
INSERT INTO bru_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem la ai clúng Yaphêt. Cớp án la achúc achiac nheq tŏ́ng Ê-bêr hỡ. ");
INSERT INTO bru_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Con samiang Sem la E-lam, Asur, Apac-sat, Lut, cớp Aram. ");
INSERT INTO bru_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Con samiang Aram la Usơ, Hul, Kê-tơ, cớp Mê-siec. ");
INSERT INTO bru_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apac-sat amia con samiang Sê-lah. Cớp Sê-lah amia con samiang Ê-bêr. ");
INSERT INTO bru_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ê-bêr amia bar lám con samiang la Pê-léc cớp Yôc-tan. Án amứh con án Pê-léc yuaq tâng dỡi tamoong án dũ náq cũai tâng cốc cutễq nâi caryoah cỡt miar tỗp. ");
INSERT INTO bru_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yôc-tan amia con samiang la Amô-dat, Sê-lep, Hasar Mavêt, Yê-rah, ");
INSERT INTO bru_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadô-ram, Usal, Dic-la, ");
INSERT INTO bru_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ô-bal, Abi-mel, Sê-ba, ");
INSERT INTO bru_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ô-phia, Havi-la, cớp Yô-bap. Nheq tữh cũai ki la con samiang Yôc-tan. ");
INSERT INTO bru_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ntốq nheq tữh cũai ki ỡt la coah vil Mê-sa toau toâq vil Sê-phar pỡ máh dũal cớp cóh angia mandang loŏh. ");
INSERT INTO bru_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Alới ki la tŏ́ng toiq Sem ca cỡt miar sâu, miar parnai, cớp miar cruang hỡ. ");
INSERT INTO bru_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Vớt raloâm dỡq, nheq máh tŏ́ng toiq con samiang Nô-ê pỡq pláh chu nâi chu ki chũop nheq cốc cutễq nâi. Alới cỡt sa‑ữi tỗp cớp sa‑ữi cruang ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nheq tữh cũai chũop cruang cutễq nâi táq ntỡng muoi parnai cớp bữn muoi saráq sâng. ");
INSERT INTO bru_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ma toâq alới dễq tễ angia mandang loŏh chuaq ỡt ntốq canŏ́h, alới ramóh muoi ntốq la‑a tapín tâng cruang Si-nar. Chơ alới táq dống sarái tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Chơ alới ki sarhống neq: “Hâi! Hái táq kec, chơ sarốc tâng ũih yỗn khâm.” Dống ntrớu alới yoc ễ táq, ki alới táq toâq kec. Alới tỡ bữn táq toâq tamáu, ma alới atớt kec ki toâq siet yang. Alới tỡ bữn atớt toâq samong. ");
INSERT INTO bru_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Cớp alới pai neq hỡ: “Hái ayứng bữm muoi vil, cớp co táq muoi lám ngôl yỗn sarỡih toâq paloŏng, yỗn ramứh ranoâng hái cỡt parchia parhan dũ ntốq, dŏq hái tỡ bữn pláh chu nâi chu ki noâng tâng cốc cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yiang Sursĩ tapoang hữm alới táq vil cớp ngôl sarỡih. ");
INSERT INTO bru_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Chơ án pai neq: “Khân alới nâi têq táq ranáq salễh ngkíq cỗ alới cỡt muoi tỗp cớp táq ntỡng muoi parnai, ki nỡ‑ra tỡ dáng ntrớu ễn alới ễ táq! ");
INSERT INTO bru_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hâi! Hái sễng salŏ́c chíq parnai, yỗn manoaq tỡ têq dáng noâng parnai manoaq.” ");
INSERT INTO bru_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yuaq ngkíq Yiang Sursĩ táq yỗn máh cũai ki cỡt ratáh ratai pỡq chu nâi chu ki chũop cốc cutễq nâi. Chơ alới tỡ bữn táq noâng vil alới mbỡiq táq ki. ");
INSERT INTO bru_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Alới amứh vil ki Babel, yuaq tâng ntốq ki Yiang Sursĩ táq yỗn cỡt sa‑ữi parnai tâng cốc cutễq nâi. Cớp tễ ntốq ki Yiang Sursĩ táq yỗn alới ki cỡt pláh chũop cốc cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nâi la parnai atỡng tễ tŏ́ng toiq Sem. Vớt bar cumo tễ raloâm dỡq, Sem bữn muoi culám cumo. Chơ án amia muoi lám con samiang ramứh Apac-sat. ");
INSERT INTO bru_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Moâm Sem amia Apac-sat, án noâng tamoong ễn sỡng culám cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Toâq Apac-sat bữn pái chít la sỡng cumo, án amia con samiang ramứh Sê-lah. ");
INSERT INTO bru_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Moâm Apac-sat amia Sê-lah, án noâng tamoong ễn pỗn culám pái chít cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Toâq Sê-lah bữn pái chít cumo, án amia con samiang ramứh Ê-bêr. ");
INSERT INTO bru_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Moâm Sê-lah amia Ê-bêr, án noâng tamoong ễn pỗn culám pái cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Toâq Ê-bêr bữn pái chít la pỗn cumo, án amia con samiang ramứh Pê-léc. ");
INSERT INTO bru_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Moâm Ê-bêr amia Pê-léc, án noâng tamoong ễn pỗn culám pái cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Toâq Pê-léc bữn pái chít cumo, án amia con samiang ramứh Rêu. ");
INSERT INTO bru_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Moâm Pê-léc amia Rêu, án noâng tamoong ễn bar chít takêh cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Toâq Rêu bữn pái chít la bar cumo, án amia con samiang ramứh Sê-ruc. ");
INSERT INTO bru_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Moâm Rêu amia Sê-ruc, án noâng tamoong ễn bar chít tapul cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Toâq Sê-ruc bữn pái chít cumo, án amia con samiang ramứh Nahor. ");
INSERT INTO bru_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Moâm Sê-ruc amia Nahor, án noâng tamoong ễn bar culám cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Toâq Nahor bữn bar chít takêh cumo, án amia con samiang ramứh Thara. ");
INSERT INTO bru_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Moâm Nahor amia Thara, án noâng tamoong ễn muoi culám muoi chít takêh cumo, cớp án amia con samiang con mansễm ễn. ");
INSERT INTO bru_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Toâq Thara bữn tapul chít cumo, án amia pái lám con samiang ramứh Apram, Nahor, cớp Haran. ");
INSERT INTO bru_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nâi la atỡng tễ tŏ́ng toiq Thara. Thara amia pái lám con samiang ramứh Apram, Nahor, cớp Haran. Haran bữn muoi lám con samiang, ramứh Lot. ");
INSERT INTO bru_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran cuchĩt nhũang tễ Thara mpoaq án tâng vil Urơ cruang Caldê, la cruang mpiq án canỡt án. ");
INSERT INTO bru_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Cớp Haran amia bar lám con mansễm hỡ, ramứh Mil-ca cớp It-ca. Apram ĩt Sarai táq lacuoi. Ma Nahor ĩt Mil-ca. ");
INSERT INTO bru_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai la cũai cũt; án tỡ bữn bữn con. ");
INSERT INTO bru_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Thara yoc ễ dễq ỡt pỡ cruang Cana-an ễn. Ngkíq án dững Apram cớp lacuoi Apram la Sarai. Cớp án dững dếh châu án ramứh Lot, con samiang Haran. Nheq tữh alới dễq tễ vil Urơ cruang Caldê ễ pỡq chu cruang Cana-an ễn. Tữ alới toâq pỡ vil Haran, nheq alới ỡt ntốq ki táq dống sarái. ");
INSERT INTO bru_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nheq dỡi Thara bữn bar culám sỡng cumo. Chơ án cuchĩt tâng vil Haran. ");
INSERT INTO bru_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yiang Sursĩ ớn Apram neq: “Cóq mới loŏh tễ cruang mới, tễ sễm ai mới, cớp tễ dống sũ mpoaq mới, chơ pỡq ỡt cruang cứq sadoi yỗn mới. ");
INSERT INTO bru_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Cứq táq yỗn rứh sa‑ữi lứq ễn, chơ cỡt cruang toâr lứq. Cứq ễ yỗn mới bữn ŏ́c bốn sa‑ữi cớp yỗn ramứh ranoâng mới cỡt parchia yỗn nheq tữh cũai dáng cớp yám noap mới. Cớp cứq yỗn mới cỡt nỡm ŏ́c bốn yỗn máh cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","“Cứq ễ satốh ŏ́c bốn yỗn máh cũai ca pai ŏ́c bốn yỗn mới. Ma cứq pupap cũai aléq ca pupap mới. Cứq ễ yỗn ŏ́c bốn pỡ dũ thữ cũai tâng cốc cutễq nâi, la cỗ tễ mới.” ");
INSERT INTO bru_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Chơ Apram loŏh tễ ntốq Haran, táq puai parnai Yiang Sursĩ ớn án táq. Cớp Lot pỡq nứng án. Bo ki, Apram khoiq bữn tapul chít la sỡng cumo chơ. ");
INSERT INTO bru_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Apram dững Sarai, lacuoi án, cớp Lot, ramon án, pỡq chu cruang Cana-an. Án dững nheq máh crơng crớu alới, dếh máh cũai sũl ca alới bữn tâng ntốq Haran hỡ. Ngkíq nheq tữh alới toâq pỡ cruang Cana-an ễn. ");
INSERT INTO bru_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ỡt tâng cruang Cana-an, Apram toâq pỡ ntốq ramứh Se-kem. Tâng Se-kem bữn aluang toâr lứq, noau dŏq Mô-rê. Bo ki, tỗp Cana-an noâng ỡt tâng cruang ki. ");
INSERT INTO bru_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yiang Sursĩ toâq pỡ Apram, atỡng án neq: “Nheq tữh cruang cutễq nâi cứq yỗn tŏ́ng toiq mới ndỡm.” Tâng ntốq nâi, Apram táq muoi lám prông dŏq sang Yiang Sursĩ, khễ sanhữ Yiang Sursĩ toâq pỡ án bân ntốq nâi. ");
INSERT INTO bru_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Tễ ntốq nâi Apram pỡq chu máh dũal cớp cóh coah angia mandang loŏh, choâng cớp vil Bet-el. Án ayứng dống aroâiq bân mpứng dĩ bar vil, ramứh Bet-el cớp A-ai. Vil Bet-el ỡt coah angia mandang pât. Ma vil A-ai ki ỡt coah angia mandang loŏh. Ỡt ntốq ki Apram táq muoi lám ễn prông dŏq sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Vớt ki Apram pỡq sĩa, án sễng pỡ cruang angia coah pưn. ");
INSERT INTO bru_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Toâq tangái tâng cruang Cana-an ŏ́q crơng sana, Apram pỡq angia coah pưn chu cruang Ê-yip-tô. Án ỡt dỡ ngki, yuaq cruang án ŏ́q crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tữ án toâq pỡ raloan cruang Ê-yip-tô, án atỡng Sarai, lacuoi án neq: “Nâi! Cứq dáng chơ mới la mansễm thán riang o. ");
INSERT INTO bru_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Toâq máh cũai samiang Ê-yip-tô hữm mới, ki alới chanchớm mới la lacuoi cứq. Chơ alới cachĩt cứq, ma alới dŏq manoaq mới sâng noâng tamoong. ");
INSERT INTO bru_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Cứq sễq mới táq nan pai mới la a‑ễm cumũr cứq. Ngkíq máh cũai Ê-yip-tô yám noap cứq, cớp cứq tỡ bữn cuchĩt cỗ tian mới.” ");
INSERT INTO bru_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tữ Apram toâq pỡ cruang Ê-yip-tô, máh cũai samiang tâng cruang ki hữm Sarai la‑ĩat tháng. ");
INSERT INTO bru_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Toâq ayững atĩ puo tâng cruang ki hữm Sarai, alới críh khễn mansễm ki choâng moat puo. Chơ alới dững mansễm ki toâq pỡ dống puo. ");
INSERT INTO bru_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Puo táq o lứq chóq Apram, cỗ tễ Sarai. Án yỗn Apram sa‑ữi náq cũai samiang cớp mansễm táq ranáq yỗn Apram. Cớp án yỗn Apram bữn sa‑ữi charán dống, dếh cữu, ntroŏq, aséh dễn tangcáh cớp sang‑ỗng, cớp lac‑da hỡ. ");
INSERT INTO bru_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma Yiang Sursĩ táq yỗn cỡt sa‑ữi túh coat toâq pỡ puo cớp nheq tữh dống sũ án, cỗ tian án ễ bữn Sarai lacuoi Apram. ");
INSERT INTO bru_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Chơ puo arô cớp blớh Apram neq: “Mới khoiq táq ntrớu chóq cứq? Nŏ́q mới tỡ bữn atỡng raloaih mansễm nâi la lacuoi mới? ");
INSERT INTO bru_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Cỗ mới táq ngkíq, cứq ĩt án dŏq táq lacuoi. Nâi lacuoi mới! Dững achu loah án. Chơ anhia loŏh toâp tễ cruang nâi!” ");
INSERT INTO bru_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Chơ puo ớn ranễng án asuoi Apram cớp lacuoi Apram dếh nheq crơng Apram loŏh chíq tễ cruang ki. ");
INSERT INTO bru_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Apram cớp lacuoi án loŏh tễ cruang Ê-yip-tô píh loah chu cruang Cana-an. Án dững dếh Lot ramon án, cớp nheq tữh crơng alới. ");
INSERT INTO bru_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Apram khoiq cỡt sốc bữn lứq. Án bữn sa‑ữi charán, cớp práq yễng hỡ. ");
INSERT INTO bru_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Toâq Apram loŏh tễ cruang Ê-yip-tô, án pỡq ễn, cớp ỡt sa‑ữi ntốq. Chơ án toâq loah pỡ ntốq án ỡt tễ nhũang. Ntốq nâi, la mpứng dĩ bar coah vil Bet-el cớp vil A-ai. ");
INSERT INTO bru_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ntốq ki án khoiq táq prông sang Yiang Sursĩ tễ nhũang. Ỡt ntốq ki Apram sang toam arô ramứh Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","6","Lot, án ca puai Apram, bữn tê sa‑ữi charán, cớp dống sũ án bữn clứng cũai tê. Ngkíq alới bar náq mon nhi tỡ têq ỡt noâng muoi ntốq, yuaq cruang ki tỡ bữn dũ ntốq yỗn alới ỡt parnơi. ");
INSERT INTO bru_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Chơ máh cũai bán charán Apram ralỗih níc cớp máh cũai bán charán Lot. Cớp noâng bữn cũai Cana-an cớp cũai Pê-rasit ỡt tâng cruang ki tê. ");
INSERT INTO bru_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ngkíq Apram atỡng Lot neq: “Mới cớp cứq, hái chỗi ralỗih. Cớp atỡng máh cũai ca bán charán hái chỗi ralỗih tê, yuaq hái la sễm ai muoi tŏ́ng. ");
INSERT INTO bru_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bữn ntốq canŏ́h la‑a lứq têq mới pỡq. Cứq sễq mới yoah tễ cứq. Khân mới rưoh yoc ễ pỡq coah avêr, ki cứq pỡq coah atoam. Ma khân mới rưoh yoc ễ pỡq coah atoam, ki cứq pỡq coah avêr.” ");
INSERT INTO bru_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Chơ Lot tapoang nhêng, án hữm bar coah crỗng Yôr-dan bữn cutễq tapín cớp la‑a lứq. Án hữm cutễq ki thớm dũ ntốq. Bo ki Yiang Sursĩ tỡ yũah talốh vil Sadôm cớp vil Camô-rơ. Ntốq ki o machớng nưong Yiang Sursĩ khoiq tễng tâng cruang Ê-dên, cớp machớng ntốq Sô-a tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ngkíq Lot rưoh ĩt ntốq cutễq tapín cớp la‑a ỡt bar coah crỗng Yôr-dan. Moâm ki, Lot pỡq chu coah angia mandang loŏh. Ngkíq Lot cớp Apram miar pỡq. ");
INSERT INTO bru_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Apram ỡt tâng cruang Cana-an. Ma Lot ỡt cheq máh vil mpễr crỗng Yôr-dan. Án patứng dống aroâiq cheq vil Sadôm. ");
INSERT INTO bru_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ma máh cũai samiang tâng vil Sadôm ki loâi lứq, cớp alới bữn lôih ntâng lứq choâng moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Toâq Lot yoah tễ Apram, Yiang Sursĩ atỡng Apram neq: “Mới carlang nhêng chu nâi chu ki yỗn chũop nheq bân ntốq mới ỡt sanua. ");
INSERT INTO bru_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nheq tữh ntốq mới hữm, nỡ‑ra cứq yỗn mới cớp nheq tŏ́ng toiq mới bữn ndỡm mantái níc. ");
INSERT INTO bru_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Cứq ễ táq yỗn tŏ́ng toiq mới cỡt clứng lứq, ariang cutễq príl, yỗn noau tỡ rơi ngih noâng. Khân têq ngih nheq ŏ́c príl tâng cutễq nâi, ki têq ngih tê con tŏ́ng mới! ");
INSERT INTO bru_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sanua mới pỡq nhêng yỗn chũop dũ ntốq tâng cruang nâi. Nheq cruang nâi cứq ễ yỗn mới ndỡm nheq.” ");
INSERT INTO bru_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ngkíq, Apram dễq sa‑ữi trỗ voai nŏ́q án toâq pỡ ntốq bữn aluang toâr, ramứh Mam-rê ỡt cheq vil Hep-rôn. Tâng ntốq nâi, Apram táq muoi lám prông ễn dŏq sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Tâng dỡi ki, bữn puo pỗn náq neq: Am-raphel táq puo cũai Si-nar, Ariac táq puo cũai E-lasa, Kê-trô-lamơ táq puo cũai E-lam, cớp Ti-dal táq puo cũai Cô-im. Bữn muoi tangái pỗn náq puo ki pruam chíl cớp sỡng náq puo canŏ́h. Ramứh sỡng náq puo ki la neq: Be-ra puo cũai Sadôm, Bir-sa puo cũai Camô-rơ, Si-nap puo cũai At-ma, Sê-mabêr puo cũai Sê-bô-im, cớp puo cũai Bê-la (tỡ la Sô-a). ");
INSERT INTO bru_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Sỡng náq puo nâi parỗm tahan alới yỗn rôm bân avúng Si-dim. Sanua noau dŏq avúng nâi la dỡq mưt Boi. ");
INSERT INTO bru_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nheq muoi chít la bar cumo, sỡng náq puo nâi trĩh parnai puo Kê-trô-lamơ. Ma toâq cumo muoi chít la pái, sỡng náq puo nâi pruam muoi mứt tỡ ễq trĩh noâng parnai puo Kê-trô-lamơ. ");
INSERT INTO bru_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Catâm cumo muoi chít la pỗn Kê-trô-lamơ táq sốt, án cớp pái puo yớu án chíl riap cũai Rê-phêm ỡt pỡ At-tarot Carnêm, cũai Susim ỡt tâng Ham, cớp cũai E-mim ỡt tâng ntốq tapín ramứh Ki-ria-têm. ");
INSERT INTO bru_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Alới chíl riap tê cũai Hô-rit ỡt tâng cóh Sêr, chơ alới rapuai toâq ntốq El Paran cheq ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Moâm ki, pỗn náq puo ki píh chu pỡ ntốq En Mit-pat (tỡ la Cadet). Alới chíl riap, chơ ĩt nheq cutễq cũai A-maléc. Cớp alới chíl riap cũai Amô-rit ỡt tâng ntốq Hasa-sôn Tamar. ");
INSERT INTO bru_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Moâm ki, sỡng náq puo tễ vil Sadôm, Camô-rơ, At-ma, Sê-bô-im, cớp Bê-la toâq chíl cớp pỗn náq puo ỡt pỡ ntốq avúng Si-dim. ");
INSERT INTO bru_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Alới pỗn náq la Kê-trô-lamơ puo E-lam, Ti-dal puo Cô-im, Am-raphel puo Si-nar, cớp Ariac puo E-lasa. Pỗn náq chíl sỡng náq. ");
INSERT INTO bru_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ỡt tâng avúng Si-dim, bữn sa‑ữi prúng noau ĩt siet yang tễ ki. Ngkíq puo Sadôm cớp puo Camô-rơ cỡt pê; alới lúh, chơ sapứl tâng prúng ki; ma máh cũai canŏ́h bữn vớt tễ ntốq ki, chơ lúh chu cóh. ");
INSERT INTO bru_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ngkíq pỗn náq puo ki ĩt pốih nheq crơng crớu, dếh sana sanốc tễ vil Sadôm cớp Camô-rơ. ");
INSERT INTO bru_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Cớp alới cỗp dếh Lot, ramon Apram, yuaq tangái ki Lot ỡt tâng vil Sadôm. Cớp alới ĩt nheq máh crơng crớu án. ");
INSERT INTO bru_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma bữn manoaq lúh vớt tễ ntốq rachíl ki, cớp pỡq atỡng Apram la cũai Hê-brơ tễ máh ranáq ki. Bo ki Apram ỡt cheq aluang toâr khong Mam-rê la cũai Amô-rit. Án bữn bar náq sễm ai, ramứh Et-côn cớp Anơ. Pái náq sễm ai nâi pruam muoi mứt cớp Apram. ");
INSERT INTO bru_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tữ Apram sâng khoiq noau cỗp ramon án, ngkíq án dững alới ca táq ranáq yỗn án, dếh con acái alới ki hỡ, máh cũai ca khoiq rien tễ ngê rachíl; chơ nheq tữh alới pỡq rapuai loah puo ca cỗp ramon án. Tỗp Apram bữn pái culám muoi chít tacual náq. Alới rapuai puo ki toau toâq pỡ vil Dan. ");
INSERT INTO bru_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ỡt ntốq ki Apram tampễq tỗp án. Toâq sadâu alới mut cachĩt tỗp pỗn náq puo ki. Moâm ki Apram mandễt tỗp ki clếc toâq pỡ vil Hô-ba ỡt coah angia pỡng vil Damac. ");
INSERT INTO bru_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Án bữn dũ loah máh crơng crớu alới ki ĩt tễ nhũang. Cớp án dững achu Lot ramon án tê. Cớp án pốh achu loah nheq cũai alới ki cỗp, bữn dếh mansễm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Moâm Apram chíl riap puo Kê-trô-lamơ cớp pái náq puo yớu puo ki, ngkíq puo cũai Sadôm pỡq ramóh án tâng avúng Saveh. (Avúng nâi noau dŏq la avúng Puo). ");
INSERT INTO bru_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Chơ Manchi-sadéc, puo vil Salem, toâq ramóh án, cớp án dững bễng cớp blŏ́ng. Manchi-sadéc la cũai tễng rit sang Yiang Sursĩ, la Yiang sốt clữi nheq tễ canŏ́h. ");
INSERT INTO bru_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Manchi-sadéc câu yỗn Apram neq: “Cứq sễq Yiang Sursĩ, la Yiang sốt clữi nheq tễ canŏ́h, án ca tễng paloŏng cớp cutễq, satốh ŏ́c bốn yỗn mới. ");
INSERT INTO bru_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Cóq hái khễn Yiang Sursĩ, la Yiang sốt clữi nheq tễ canŏ́h, án ca chuai mới yỗn bữn bán rêng cớp chíl riap pỗn náq puo ca rachíl mới.” Moâm Manchi-sadéc pai ngkíq, Apram yỗn Manchi-sadéc pún muoi chít tễ crơng án ĩt tễ pỗn náq puo ki. ");
INSERT INTO bru_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Moâm ki, puo cũai Sadôm atỡng Apram neq: “Sễq mới yỗn chiau loah máh cũai proai cứq sâng, ma máh crơng crớu mới tíng ĩt.” ");
INSERT INTO bru_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Apram ta‑ỡi loah neq: “Cứq sễq arô ramứh Yiang Sursĩ, la Yiang sốt clữi nheq tễ canŏ́h, la Yiang ca tễng paloŏng cutễq, cớp cứq sễq ữq neq: ");
INSERT INTO bru_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Lứq pai muoi ntreh carsán tỡ la muoi ntreh cansái cỡp cadĩ, la cứq tỡ bữn ĩt tễ máh crơng mới. Cứq tỡ ễq; kếq mới pai cứq cỡt sốc bữn la cỗ tian mới. ");
INSERT INTO bru_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sanua cứq ĩt ống crơng sana sâng yỗn tỗp tahan cứq cha. Ma pái náq yớu ca pruam chuai cứq, ki cứq yoc alới bữn pún tê. Ramứh alới pái náq la Anơ, Et-côn, cớp Mam-rê.” ");
INSERT INTO bru_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Vớt tangái ki, Yiang Sursĩ sapáh yỗn Apram, chơ atỡng án neq: “Apram ơi! Mới chỗi ngcŏh ntrớu. Cứq toâp kĩaq níc mới. Cớp cứq yỗn mới bữn cóng toâr lứq.” ");
INSERT INTO bru_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ma Apram ta‑ỡi neq: “Ơ Yiang Sursĩ Ncháu Nheq Tữh Cũai ơi! Anhia têq yỗn cóng acán ntrớu, yuaq cứq la cũai ŏ́q con. Cớp E-lia-se tễ cruang Damac, án ki lứq catứm mun cứq.” ");
INSERT INTO bru_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Cớp Apram pai ễn neq: “Anhia tỡ bữn yỗn cứq bữn con. Ngkíq, cũai táq ranáq tâng dống cứq catứm mun cứq, tỡ cỡn con cứq.” ");
INSERT INTO bru_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Chơ Apram sâng sĩa sưong Yiang Sursĩ atỡng án neq: “Tỡ cỡn. Cũai ki tỡ têq catứm mun mới. Ma con samiang mới toâp ndỡm mun mới.” ");
INSERT INTO bru_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Moâm Yiang Sursĩ pai ngkíq, án dững Apram loŏh yáng tiah, cớp atỡng án neq: “Mới tapoang achỗn chu paloŏng, chơ mới ngih nheq tữh mantỗr. Lứq samoât, tŏ́ng toiq mới lứq cỡt sa‑ữi ariang mantỗr ki tê.” ");
INSERT INTO bru_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Apram sa‑âm Yiang Sursĩ; ngkíq Yiang Sursĩ noap án la cũai tanoang o. ");
INSERT INTO bru_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Chơ Yiang Sursĩ atỡng Apram neq: “Cứq la Yiang Sursĩ khoiq dững mới loŏh tễ Urơ tâng cruang Caldê, yỗn mới bữn ndỡm cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma Apram atỡng loah Yiang Sursĩ neq: “Yiang Sursĩ Ncháu Nheq Tữh Cũai ơi! Nŏ́q cứq têq dáng cứq lứq bữn ndỡm cruang nâi?” ");
INSERT INTO bru_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yiang Sursĩ atỡng Apram neq: “Mới dững chiau sang yỗn cứq muoi lám ntroŏq sang‑ỗng, muoi lám mbễq sang‑ỗng, muoi lám cữu tôl mbỡiq pái cumo, muoi lám chớm cubỗl cớp muoi lám chớm tariap.” ");
INSERT INTO bru_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ngkíq Apram dững nheq máh charán ki. Án saráh cỡt bar ploah, chơ án amóh loah ntroŏq cớp ntroŏq, mbễq cớp mbễq, cữu cớp cữu. Ma máh chớm ki án tỡ bữn saráh. ");
INSERT INTO bru_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Moâm ki calang srúh tâng máh tỗ charán ki, ma Apram atũih. ");
INSERT INTO bru_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Toâq mandang cheq ễ pât, Apram bếq langêt lứq. Án sâng ngcŏh lứq, cỗ canám clũom nheq tỗ án. ");
INSERT INTO bru_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yiang Sursĩ atỡng Apram neq: “Têq mới dáng samoât, nỡ‑ra tŏ́ng toiq mới cóq ỡt tâng muoi cruang canŏ́h alới tỡ bữn ndỡm. Tâng cruang ki alới cỡt sũl nheq pỗn culám cumo, cớp cũai ca ndỡm alới táq alới túh coat lứq. ");
INSERT INTO bru_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ma cứq ễ táq chóq cruang ca táq yỗn tŏ́ng toiq mới cỡt sũl roap tôt ntâng lứq. Vớt ki, tŏ́ng toiq mới bữn loŏh tễ cruang ki, cớp dững aloŏh sa‑ữi mun hỡ. ");
INSERT INTO bru_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mŏ miar tỗ mới, ki mới bữn tamoong dũn lứq, cớp toâq tangái mới cuchĩt, ki mới cuchĩt ien khễ. ");
INSERT INTO bru_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nheq pỗn dỡi cũai, máh tŏ́ng toiq mới tỡ têq chu yũah pỡ cruang nâi, cỗ lôih cũai Amô-rit táq tỡ yũah ntâng lứq. Ma lứq samoât, toâq dỡi cho mới, ki nŏ́q têq chu ỡt loah pỡ cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Toâq moat mandang khoiq ngêt cớp paloŏng cỡt canám lứq, bo ki bữn muoi lo toâr phĩac cusốh achỗn, cớp bữn pla ũih culoâuq tâng máh charán Apram khoiq saráh ki. ");
INSERT INTO bru_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tâng tangái ki Yiang Sursĩ par‑ữq cớp Apram neq: “Cứq yỗn tŏ́ng toiq mới ndỡm cruang nâi tễ crỗng Ê-yip-tô toau toâq crỗng toâr Ơ-phơ-rat. ");
INSERT INTO bru_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Cứq yỗn tŏ́ng toiq mới sốt nheq tữh cũai ỡt tâng cruang nâi. Máh tỗp ki la neq: Kê-nit, Kê-ni-sit, Cat-mô-nit, ");
INSERT INTO bru_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hêt, Pê-rasit, Rê-phêm, ");
INSERT INTO bru_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amô-rit, Cana-an, Kir-casit, cớp Yê-but.” ");
INSERT INTO bru_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai lacuoi Apram la cũai cũt. Ma án bữn muoi noaq mansễm tễ cruang Ê-yip-tô táq ranáq yỗn án. Mansễm ki ramứh Hacar. ");
INSERT INTO bru_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","3","Sarai atỡng Apram neq: “Yiang Sursĩ tỡ yỗn cứq bữn con. Sanua mới ĩt mansễm táq ranáq yỗn cứq táq lacuoi mới; nhơ tễ mansễm nâi, hái bữn con tŏ́ng tê.” Apram pruam cớp santoiq Sarai atỡng. Ngkíq Sarai lacuoi án yỗn án ĩt Hacar táq lacuoi án. Tangái Sarai yỗn Apram ỡt cớp mansễm ki, Apram khoiq ỡt tâng cruang Cana-an muoi chít cumo chơ. ");
INSERT INTO bru_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Apram cớp Hacar táq cha amia apu. Tữ Hacar dáng án ỡt mumiaq, ngkíq án mumat Sarai. ");
INSERT INTO bru_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Chơ Sarai atỡng Apram neq: “Hacar tỡ bữn yám noap cứq noâng. Ŏ́c nâi, cỗ tian mới. Cứq yỗn mansễm táq ranáq cứq cỡt lacuoi mới. Ma tữ án ỡt mumiaq, án ayê cứq. Cứq sễq Yiang Sursĩ toâp parchĩn mới cớp cứq.” ");
INSERT INTO bru_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma Apram ta‑ỡi loah Sarai neq: “Sốt pỡ mới mansễm ki. Tam rangứh mới; ntrớu mới yoc ễ táq chóq án, ki mới táq.” Ngkíq, Sarai carsống Hacar táq yỗn án arức lứq. Chơ Hacar lúh chíq tễ Sarai. ");
INSERT INTO bru_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma ranễng Yiang Sursĩ ramóh Hacar cheq abóc dỡq bân ntốq aiq. Abóc dỡq nâi cheq rana pỡq chu Surơ. ");
INSERT INTO bru_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ranễng Yiang Sursĩ blớh Hacar neq: “Hacar ơi! Mới ca táq ranáq yỗn Sarai, tễ nléq mới toâq? Cớp mới ễ pỡq chu léq?” Hacar ta‑ỡi: “Cứq lúh Sarai, ncháu cứq.” ");
INSERT INTO bru_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ma ranễng Yiang Sursĩ atỡng Hacar neq: “Mới chu loah pỡ ncháu mới, cớp trĩh nheq parnai án.” ");
INSERT INTO bru_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ranễng Yiang Sursĩ atỡng ễn: “Cứq yỗn mới cỡt clứng tŏ́ng toiq, yỗn noau tỡ rơi ngih noâng.” ");
INSERT INTO bru_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Chơ ranễng Yiang Sursĩ atỡng Hacar ễn neq: “Sanua nâi mới ỡt mumiaq. Nỡ‑ra mới canỡt con samiang; chơ mới amứh con ki la It-ma-el. Cỗ Yiang Sursĩ khoiq sâng chơ máh ŏ́c mới chĩuq túh coat. (Ramứh ‘It-ma-el’ parlong loah la ‘Yiang Sursĩ sâng’.) ");
INSERT INTO bru_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Cớp con samiang ki, án bữn mứt pahỡm riang aséh dễn arưih. Án ralỗih níc cớp cũai canŏ́h, ma cũai canŏ́h ralỗih níc tê cớp án. Án tỡ bữn ỡt ien khễ cớp máh sễm ai án.” ");
INSERT INTO bru_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Moâm ki, Hacar amứh Yiang Sursĩ neq: ‘Yiang ca nhêng salĩq cứq’, yuaq án pai: “Cứq khoiq hữm Yiang ca nhêng salĩq cứq.” ");
INSERT INTO bru_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ngkíq dỡq chữong ki noau amứh neq: ‘Dỡq chữong Yiang ca tamoong cớp nhêng salĩq cứq.’ Dỡq chữong nâi ỡt mpứng dĩ bar coah vil Cadet cớp vil Be-ret. ");
INSERT INTO bru_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Chơ Hacar canỡt muoi lám con samiang. Án la con Apram; cớp Apram amứh con ki It-ma-el. ");
INSERT INTO bru_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Tangái Hacar canỡt It-ma-el, bo ki Apram khoiq tacual chít tapoât cumo. ");
INSERT INTO bru_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tữ Apram bữn takêh chít takêh cumo, Yiang Sursĩ sapáh sĩa yỗn án, cớp atỡng án neq: “Cứq la Yiang Sursĩ Sốt Toâr Lứq. Cóq mới ỡt muoi mứt cớp cứq, cớp cóq mới táq ranáq pĩeiq níc. ");
INSERT INTO bru_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Cứq par‑ữq cớp mới, cớp táq yỗn tŏ́ng toiq mới cỡt clứng lứq ễn.” ");
INSERT INTO bru_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Chơ Apram cucốh ap tỗ chu cutễq. Cớp Yiang Sursĩ atỡng ễn Apram neq: ");
INSERT INTO bru_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ŏ́c nâi cứq par‑ữq cớp mới, cứq ễ táq yỗn mới cỡt achúc achiac sa‑ữi cruang. ");
INSERT INTO bru_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ngkíq ramứh mới tỡ bữn noâng Apram. Ma sanua ramứh mới la A-praham ễn, yuaq cứq táq yỗn mới cỡt achúc achiac sa‑ữi cruang. ");
INSERT INTO bru_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Cứq yỗn mới amia con sa‑ữi lứq ễn. Cứq yỗn tŏ́ng toiq mới cỡt sa‑ữi cruang. Cớp máh puo toâq tễ mới tê. ");
INSERT INTO bru_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Máh ŏ́c cứq par‑ữq cớp mới cớp nheq tŏ́ng toiq mới, cứq lứq táq máh ŏ́c ki. Ŏ́c ki la cứq cỡt Yiang Sursĩ anhia, dếh mới, cớp nheq tŏ́ng toiq mới. Ŏ́c cứq par‑ữq cứq yống níc mantái mantái. ");
INSERT INTO bru_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nỡ‑ra cứq yỗn mới, cớp nheq tŏ́ng toiq mới bữn ndỡm cruang Cana-an, la ntốq anhia ỡt sanua ariang cũai tamoi. Lứq samoât, cruang nâi con tŏ́ng anhia ndỡm mantái níc. Cớp cứq lứq cỡt Yiang Sursĩ alới.” ");
INSERT INTO bru_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Chơ Yiang Sursĩ atỡng ễn A-praham neq: “Mới cớp nheq dỡi tŏ́ng toiq mới, cóq anhia yống níc parnai cứq par‑ữq cớp anhia. ");
INSERT INTO bru_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Máh ŏ́c cứq par‑ữq cớp anhia la neq: Nheq tữh tỗp samiang tâng tỗp anhia cóq táq rit cứt. ");
INSERT INTO bru_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Anhia táq rit cứt nâi la tếc cứq par‑ữq cớp anhia. ");
INSERT INTO bru_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Noap tễ con samiang mbỡiq sễt tacual tangái, cóq anhia táq rit cứt yỗn án. Nheq dỡi anhia cóq táq níc rit nâi, dếh yỗn con anhia sễt tâng dống, cớp con anhia chỡng tễ cũai canŏ́h hỡ. ");
INSERT INTO bru_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Máh cũai sũl sễt tâng dống mới, dếh alới mới chỡng la cóq táq ngkíq tê. Cóq anhia táq ngkíq dŏq apáh ŏ́c cứq khoiq par‑ữq ỡt níc cớp anhia. ");
INSERT INTO bru_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Khân cũai samiang aléq ma tỡ bữn pruam táq rit cứt, cũai ki khoiq táh chơ ŏ́c cứq par‑ữq. Lứq cũai ki tỡ têq cỡt noâng cũai proai cứq, yuaq án khoiq táh chíq ŏ́c cứq par‑ữq cớp anhia.” ");
INSERT INTO bru_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yiang Sursĩ atỡng A-praham ễn: “Chỗi dŏq noâng ramứh lacuoi mới Sarai, ma dŏq án ramứh tamái la Sara. ");
INSERT INTO bru_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Cứq yỗn án bữn ŏ́c bốn lứq. Cứq yỗn án canỡt muoi lám con samiang yỗn mới. Ngkíq Sara cỡt mpiq sa‑ữi cruang; cớp bữn sa‑ữi puo toâq tễ Sara.” ");
INSERT INTO bru_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Toâq Yiang Sursĩ pai ngkíq, A-praham sâng dớt lứq. Án ngũq asễng cớp cacháng tâng mứt, chơ án blớh neq: “Cũai samiang khoiq bữn muoi culám cumo chơ, têq án amia con tỡ? Cớp Sara khoiq takêh chít cumo chơ, têq án canỡt con tỡ?” ");
INSERT INTO bru_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A-praham sễq tễ Yiang Sursĩ neq: “Cứq sễq anhia yỗn It-ma-el ễn roap ŏ́c anhia khoiq par‑ữq cớp cứq.” ");
INSERT INTO bru_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma Yiang Sursĩ ta‑ỡi loah án neq: “Lứq samoât Sara, lacuoi mới, bữn canỡt con samiang, cớp cóq mới amứh con ki la I-sac. Chơ cứq par‑ữq cớp I-sac, dếh nheq tŏ́ng toiq án tê. Ŏ́c cứq par‑ữq nâi la noâng mantái níc. ");
INSERT INTO bru_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Cứq sâng chơ máh ŏ́c mới sễq yỗn It-ma-el. Chơ cứq yỗn án bữn ŏ́c bốn tê. Cứq yỗn tŏ́ng toiq án cỡt clứng lứq. Tŏ́ng toiq án bữn muoi chít la bar puo. Cớp cứq táq yỗn án cỡt achúc achiac cruang toâr. ");
INSERT INTO bru_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ma máh ŏ́c cứq par‑ữq cớp mới, ki cứq lứq táq ŏ́c ki yỗn I-sac. Cớp cumo kếq, Sara lứq canỡt I-sac.” ");
INSERT INTO bru_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Moâm Yiang Sursĩ atỡng A-praham ngkíq, chơ án loŏh tễ A-praham. ");
INSERT INTO bru_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tâng tangái ki toâp A-praham trĩh santoiq Yiang Sursĩ khoiq atỡng án. Án dững It-ma-el con án, cớp nheq cũai samiang ỡt tâng dống án, dếh cũai canỡt tâng dống án, cớp cũai án chỡng hỡ. Chơ án táq rit cứt yỗn dũ náq alới. ");
INSERT INTO bru_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tangái A-praham táq rit cứt, án khoiq takêh chít takêh cumo chơ. ");
INSERT INTO bru_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Cớp It-ma-el khoiq bữn muoi chít la pái cumo. ");
INSERT INTO bru_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tâng tangái ki tê A-praham cớp It-ma-el con samiang án táq rit cứt. ");
INSERT INTO bru_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Cớp nheq tữh cũai samiang ỡt tâng dống A-praham la táq machớng ki tê, dếh cũai khoiq sễt tâng dống án, cớp cũai án chỡng tễ cruang canŏ́h hỡ. ");
INSERT INTO bru_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yiang Sursĩ toâq pỡ A-praham pỡ nỡm aluang toâr ramứh Mam-rê. Bo moat mandang toâng, A-praham tacu bân ngoah toong dống aroâiq án. ");
INSERT INTO bru_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A-praham tapoang cớp hữm pái náq samiang ỡt tayứng, ma tỡ bữn yơng tễ án. Tữ án hữm cũai ki, án pỡq chái lứq tễ dống án toâq pỡ cũai ki. Cớp án roap chỗm alới. ");
INSERT INTO bru_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Chơ A-praham atỡng án ca muoi neq: “Achuaih ơi! Khân anhia yám noap cứq, ki sễq anhia chỗi pỡq luat tễ cứq. ");
INSERT INTO bru_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Sễq anhia yỗn cứq ớn cũai dững dỡq yỗn anhia ariau ayững, cớp ỡt rlu nhưp aluang nâi voai. ");
INSERT INTO bru_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Cứq ễ ĩt bĩq crơng sana yỗn anhia cha. Cớp yỗn anhia sarai lakéh voai. Moâm ki, nŏ́q anhia pỡq ễn. Prớh anhia toâq pỡ cứq, ki cứq bũi lứq roap chỗm anhia.” Alới ta‑ỡi A-praham neq: “Ơq. Sễq mới táq riang mới pai.” ");
INSERT INTO bru_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ngkíq A-praham tál mut tâng dống án cớp ớn Sara neq: “Táq chái! Ĩt pái crưo bỗt mi, chơ mới táq bễng.” ");
INSERT INTO bru_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Moâm ki, A-praham lúh pỡ cantóh ntroŏq, chơ rưoh muoi lám ntroŏq con plứm o lứq chiau pỡ cũai táq ranáq án. Cũai ki kiac cớp táq cha toâp sâiq ntroŏq ki. ");
INSERT INTO bru_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Vớt ki, A-praham ĩt dỡq tóh ntroŏq cớp sâiq ntroŏq yỗn alới pái náq ki nguaiq cha. Ngkíq alới ki chi-cha nhưp coâl aluang toâr ki. Ma A-praham partê níc bo alới chi-cha. ");
INSERT INTO bru_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Chơ alới blớh A-praham: “Nléq Sara, lacuoi mới?” A-praham ta‑ỡi: “Án ỡt tâng dống.” ");
INSERT INTO bru_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Bữn manoaq tễ pái náq ki pai neq: “Cumo kếq tâng casâi nâi, cứq ễ toâq loah pỡ mới. Tangái ki, Sara lacuoi mới ễ canỡt muoi lám con samiang.” Bo ki Sara ỡt tayứng cheq ngoah toong dống aroâiq, yáng clĩ cayac án ỡt, cớp án sâng nheq alới táq ntỡng. ");
INSERT INTO bru_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","A-praham cớp Sara khoiq thâu lứq chơ, cớp Sara la khoiq nheq ngư táq ramia. ");
INSERT INTO bru_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Yuaq ngkíq Sara cacháng tâng mứt, cớp án chanchớm neq: “Cứq khoiq thâu chơ, nŏ́q têq cứq táq ramia noâng? Cayac cứq la thâu machớng cứq tê.” ");
INSERT INTO bru_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Chơ Yiang Sursĩ blớh A-praham neq: “Nŏ́q Sara cacháng, pai neq: ‘Cứq thâu lứq chơ; nâng têq nâng tỡ cứq amia con?’ ");
INSERT INTO bru_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Bữn ranáq ntrớu Yiang Sursĩ tỡ têq táq tỡ? Ariang cứq khoiq atỡng anhia, cumo kếq cứq toâq loah pỡ anhia, cớp tangái ki Sara lứq bữn muoi lám con samiang.” ");
INSERT INTO bru_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara sâng ngcŏh lứq, chơ án cakéq neq: “Léq bữn cứq cacháng bớh.” Ma Yiang Sursĩ ta‑ỡi loah Sara neq: “Lứq mới khoiq cacháng chơ.” ");
INSERT INTO bru_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Vớt ki, samiang pái náq ki yuor tayứng loŏh pỡq nhêng chu angia vil Sadôm. A-praham pỡq satoâl alới dĩ ria rana. ");
INSERT INTO bru_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yiang Sursĩ chanchớm neq: “Cứq tỡ ễq cutooq chóq A-praham máh ranáq cứq ntôm ễ táq. ");
INSERT INTO bru_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Máh tŏ́ng toiq án lứq cỡt muoi cruang toâr lứq cớp rêng lứq; cớp dũ cruang cũai bữn roap ŏ́c bốn nhơ tễ án. ");
INSERT INTO bru_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Cứq khoiq rưoh án dŏq catoaih atỡng con acái cớp nheq tữh tŏ́ng toiq án, dŏq alới táq puai níc ngê cứq, chơ táq pĩeiq cớp tanoang tapứng. Khân alới trĩh ngkíq, cứq lứq táq máh ranáq cứq khoiq par‑ữq cớp A-praham dũ ramứh.” ");
INSERT INTO bru_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Chơ Yiang Sursĩ atỡng A-praham neq: “Máh cũai ỡt tâng vil Sadôm cớp vil Camô-rơ nâi, cứq khoiq sâng noau pai alới ki loâi lứq cớp táq ŏ́c lôih ntâng lứq. ");
INSERT INTO bru_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ngkíq cứq ễ pỡq nhêng tâng bar vil ki, yoc ễ dáng máh ŏ́c cứq khoiq sâng ki, la pĩeiq ma tỡ bữn.” ");
INSERT INTO bru_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Moâm ki bar náq ki loŏh pỡq chu vil Sadôm. Ma Yiang Sursĩ noâng ỡt cớp A-praham bân ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","A-praham toâq cheq Yiang Sursĩ cớp blớh neq: “Anhia ễ pupứt cũai tanoang o cớp cũai sâuq muoi prớh loâng, ma tỡ bữn? ");
INSERT INTO bru_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Khân bữn sỡng chít náq cũai tanoang o ỡt tâng vil ki, anhia ễ talốh táh tỡ? Anhia dŏq ma tỡ bữn vil ki cỗ nhơ tễ cũai sỡng chít náq ki? ");
INSERT INTO bru_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Lứq anhia tỡ ễq cũai o ma pứt parnơi cớp cũai sâuq. Anhia tỡ ễq táq cũai tanoang o machớng anhia táq chóq cũai sâuq. Lứq tỡ bữn ngkíq. Án ca rasữq nheq tữh cũai, cóq án táq dũ ranáq yỗn pĩeiq lứq.” ");
INSERT INTO bru_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yiang Sursĩ ta‑ỡi A-praham neq: “Khân cứq ramóh sỡng chít náq cũai tanoang o tâng vil Sadôm, cứq tỡ bữn talốh vil ki.” ");
INSERT INTO bru_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma A-praham sễq ễn neq: “Cứq sễq lôih Ncháu, yuaq cứq la samoât phốn cutễq cớp tỡ bữn ngư blớh anhia. ");
INSERT INTO bru_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ma khân bữn cũai tanoang o pỗn chít la sỡng náq tâng vil ki, anhia noâng ễ pupứt tỡ?” Yiang Sursĩ ta‑ỡi neq: “Khân cứq tamóh pỗn chít la sỡng náq cũai tanoang o, ki cứq tỡ bữn talốh vil ki.” ");
INSERT INTO bru_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Chơ A-praham rasễq ễn sĩa: “Nŏ́q khân bữn ống pỗn chít náq sâng tanoang o tâng vil ki?” Yiang Sursĩ ta‑ỡi: “Khân bữn pỗn chít náq tanoang o, ki cứq tỡ bữn talốh.” ");
INSERT INTO bru_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ma A-praham rasễq ễn neq: “Sễq Ncháu chỗi nhôp cứq, ma cứq ễ sễq sĩa. Khân bữn pái chít náq cũai tanoang o tâng vil ki, anhia ễ talốh táh tỡ?” Yiang Sursĩ ta‑ỡi loah: “Khân cứq tamóh pái chít náq cũai tanoang o tâng vil ki, cứq tỡ bữn talốh mŏ.” ");
INSERT INTO bru_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Chơ A-praham pai ễn neq: “Sễq lôih anhia, Ncháu ơi! Cứq yoc ễ rasễq sĩa tễ anhia. Khân bữn bar chít náq cũai tanoang o tâng vil ki, anhia ễ talốh tỡ?” Yiang Sursĩ ta‑ỡi: “Lứq cứq tỡ bữn talốh, khân bữn bar chít náq cũai tanoang o tâng vil ki.” ");
INSERT INTO bru_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ma A-praham pai ễn: “Sễq Ncháu chỗi nhôp, khân cứq ễ sễq muoi trỗ nâi ễn. Khân bữn ống muoi chít náq sâng cũai tanoang o tâng vil ki, anhia ễ talốh tỡ?” Yiang Sursĩ ta‑ỡi: “Lứq cứq tỡ bữn talốh, cỗ nhơ tễ muoi chít náq cũai tanoang o ỡt tâng vil ki.” ");
INSERT INTO bru_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Moâm Yiang Sursĩ pai ngkíq, án loŏh tễ A-praham. Chơ A-praham chu loah pỡq dống án. ");
INSERT INTO bru_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tabữ ki, toâq bar náq ranễng Yiang Sursĩ toâq pỡ vil Sadôm, ma paloŏng cheq sadâu chơ. Bo ki Lot ỡt tacu cheq ngoah toong viang vil. Án hữm bar náq ranễng ki toâq, chơ án yuor tayứng cớp pỡq ramóh alới. Án ap tỗ chu cutễq cucốh cớp mơi alới neq: ");
INSERT INTO bru_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Sễq bar náq achuaih toâq pỡ dống cứq, ariau ayững cớp bếq nnâi voai sadâu nâi; toâq poang tarưp parnỡ, ki anhia pỡq tễ cláih.” Ranễng ki ta‑ỡi neq: “Tỡ bữn mŏ! Bữ nâi hếq ỡt yáng tiah toâp, bân ntốq noau dốq tampống nâi.” ");
INSERT INTO bru_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma Lot kiauq níc bar náq ranễng ki. Ngkíq alới pỡq cớp Lot mut tâng dống án. Lot aloŏh sana cớp bễng tỡ bữn pluoih yỗn bar náq ki cha; chơ bar náq ranễng ki cha. ");
INSERT INTO bru_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bo bar náq alới ki noâng tamỡ, bữn clứng cũai samiang tễ vil Sadôm, dếh cũai thâu, dếh cũai póng, nheq tữh alới toâq lavíng chũop nheq dống Lot. ");
INSERT INTO bru_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Cớp alới arô Lot neq: “Lot ơi! Nléq chơ samiang tamoi ca toâq pỡ dống mới sadâu nâi? Mới dững alới loŏh ramóh hếq. Hếq yoc ễ langơp cớp yoc ễ bữn alới.” ");
INSERT INTO bru_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ngkíq Lot loŏh tễ dống, cớp catáih chíq ngoah toong. ");
INSERT INTO bru_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Án atỡng alới neq: “Cứq sễq sễm ai chỗi táq ranáq sâuq ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nâi! Cứq bữn bar lám con mansễm noâng plot, yũah bữn cayac. Cứq dững aloŏh alới yỗn anhia. Ntrớu anhia yoc ễ táq chóq alới, ki anhia tíng táq. Ma sễq anhia chỗi táq ntrớu chóq bar náq samiang nâi, yuaq alới la cũai tamoi ca toâq pỡ dống cứq.” ");
INSERT INTO bru_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma clứng cũai ki ta‑ỡi loah Lot neq: “Mới priang yơng! Mới la cũai sarlỗi, ma noâng mới ễ sữq hếq. Sanua hếq táq mới ntâng hỡn tễ alới bar náq ki ễn.” Cũai clứng ki tuam Lot hâp lứq, palŏ́ng yoc talốh ngoah toong. ");
INSERT INTO bru_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma alới bar náq samiang tâng clống dống, satoâp atĩ sadŏ́h Lot amut loah chu dống. Chơ alới catáih chíq ngoah toong. ");
INSERT INTO bru_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma alới bar náq ki táq yỗn cũai samiang clứng ca ỡt yáng tiah ngoah toong cỡt sũt nheq. Ngkíq nheq tữh cũai clứng ki, dếh cũai póng, dếh cũai thâu, alới pê chuaq ngoah toong, ma tỡ tamóh. ");
INSERT INTO bru_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Chơ alới bar náq ki atỡng Lot neq: “Ỡt ntốq nâi mới bữn partiam, tỡ la con samiang, tỡ la con mansễm tỡ? Cóq mới dững aloŏh nheq máh alới tễ ntốq nâi. ");
INSERT INTO bru_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Yuaq hếq ntôm ễ talốh nheq vil nâi; yuaq Yiang Sursĩ khoiq sâng chơ máh cũai tâng ntốq nâi la loâi lứq. Cớp Yiang Sursĩ ớn hếq toâq pỡ nâi, dŏq talốh yỗn pứt nheq vil nâi.” ");
INSERT INTO bru_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Chơ Lot pỡq ramóh bar náq samiang ca cỡt sampuoq bar náq con mansễm án, cớp Lot atỡng bar náq samiang ki neq: “Anhia loŏh toâp tễ ntốq nâi, yuaq Yiang Sursĩ cheq ễ talốh nheq vil nâi.” Ma cũai samiang ki chanchớm Lot atỡng ra‑ac sâng. ");
INSERT INTO bru_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Toâq poang tarưp, ranễng Yiang Sursĩ cartuoih Lot: “Mới yuor chái! Dững lacuoi cớp bar lám con mansễm mới loŏh toâp! Ngcŏh anhia cuchĩt parnơi cớp cũai tâng vil nâi!” ");
INSERT INTO bru_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ma Lot tũt. Ngkíq bar náq ranễng ki tếc Lot, lacuoi Lot, cớp bar náq con mansễm Lot yỗn loŏh vớt tễ vil ki, yuaq Yiang Sursĩ ayooq táq dũ náq cũai tâng dống sũ Lot. ");
INSERT INTO bru_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tữ ranễng Yiang Sursĩ dững alới loŏh vớt chơ tễ vil, ngkíq manoaq ranễng pai neq: “Anhia lúh yỗn vớt, chỗi luliaq chu clĩ. Chỗi tangứt ntốq aléq tâng cutễq tapín la‑a nâi. Lúh chỗn chu cóh toâp, khân anhia ễq yỗn vớt tễ ŏ́c cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lot ta‑ỡi alới neq: “Tỡ têq, achuaih ơi! ");
INSERT INTO bru_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Cứq sa‑ỡn sa‑ữi lứq anhia ayooq cứq, cớp rachuai yỗn cứq bữn tamoong. Sanua cứq tỡ rơi lúh chỗn noâng chu cóh ki. Cŏh lơ ŏ́c cuchĩt satỡm cứq, cớp cứq cuchĩt toâp. ");
INSERT INTO bru_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Achuaih hữm vil cớt cớt tíh tỡ? Vil ki cheq, cớp têq pỡq toâq. Sễq anhia yỗn cứq lúh chu vil cớt ki, chơ cứq bữn plot ien.” ");
INSERT INTO bru_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ranễng Yiang Sursĩ ta‑ỡi Lot neq: “Ơq! Cứq tỡ bữn talốh vil cớt ki, sanŏ́q mới khoiq sễq. ");
INSERT INTO bru_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Anhia pỡq chái! Khân anhia tỡ yũah toâq pỡ ntốq ki, cứq tỡ têq táq ranáq ntrớu.” (Noau dŏq vil ki la Sô-a; ‘sô-a’ parlong loah la ‘cớt’.) ");
INSERT INTO bru_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Toâq mandang mbỡiq loŏh, Lot mut tâng vil Sô-a. ");
INSERT INTO bru_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Chơ Yiang Sursĩ apŏ́ng mữ cớp pla ũih tễ paloŏng ariang mia satooh tâng vil Sadôm cớp vil Camô-rơ. ");
INSERT INTO bru_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ngkíq bar vil ki cat cốiq nheq, dếh ntốq cutễq tapín la‑a cheq ki hỡ, dếh cũai ỡt tâng ki, dếh máh aluang aloai crái samữ hỡ. ");
INSERT INTO bru_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma lacuoi Lot pỡq ntun Lot; án luliaq loah chu clĩ. Bo ki toâp lacuoi Lot cuchĩt cớp cỡt chíq ngooc boi. ");
INSERT INTO bru_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Poang tarưp, A-praham tamỡ tễ cláih. Án pỡq pỡ ntốq án táq ntỡng cớp Yiang Sursĩ tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Án tapoang chu angia vil Sadôm cớp vil Camô-rơ, cớp máh cutễq tapín la‑a ki. Án hữm phĩac cusốh achỗn tễ cutễq ariang loŏh tễ muoi lo ũih toâr lứq. ");
INSERT INTO bru_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ma toâq Yiang Sursĩ talốh nheq máh vil tâng ntốq tapín la‑a ki, án sanhữ A-praham; ngkíq án dững aloŏh Lot tễ ntốq cuchĩt ki. Yiang Sursĩ talốh pữoi nheq vil Lot ỡt tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot sâng ngcŏh ỡt tâng vil Sô-a. Ngkíq án cớp bar lám con mansễm án loŏh tễ vil Sô-a, chơ chỗn tâng cóh cớp ỡt tâng muoi cưp tamáu ");
INSERT INTO bru_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Án ca ỡi atỡng a‑ễm án neq: “Mpoaq hái khoiq thâu chơ, cớp tỡ bữn cũai aléq noâng tâng cutễq nâi têq ĩt hái táq lacuoi puai rit hái. ");
INSERT INTO bru_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ngkíq hái táq yỗn mpoaq cỡt bũl blŏ́ng. Chơ hái bếq cớp án dŏq yỗn hái bữn loah tŏ́ng toiq tễ mpoaq hái ễn.” ");
INSERT INTO bru_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Toâq sadâu, alới saroac blŏ́ng yỗn mpoaq alới cỡt bũl. Moâm ki con mansễm clúng mut bếq cớp mpoaq án. Ma mpoaq án tỡ bữn dáng bo léq con án mut bếq cớp án, cớp án tỡ dáng bo léq con án yuor loah. ");
INSERT INTO bru_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Toâq tangái parnỡ, án ca ỡi atỡng a‑ễm neq: “Bữ hái cứq bếq parnơi cớp mpoaq hái. Chơ sadâu kếq hái táq yỗn mpoaq bũl blŏ́ng sĩa. Chơ mới ễn pỡq bếq parnơi cớp mpoaq. Ngkíq hái bữn loah tŏ́ng toiq tễ mpoaq hái.” ");
INSERT INTO bru_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ngkíq sadâu ki bar náq sễm ỡi táq yỗn mpoaq alới bũl blŏ́ng sĩa. Chơ con ralŏ́h ễn pỡq bếq cớp mpoaq alới. Ma mpoaq alới tỡ bữn dáng bo léq con án bếq cớp án. Cớp án tỡ bữn dáng bo léq con án yuor. ");
INSERT INTO bru_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ngkíq bar lám con mansễm Lot ỡt mumiaq cỗ tễ mpoaq alới. ");
INSERT INTO bru_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Con mansễm clúng canỡt muoi lám con samiang. Án amứh con samiang ki Mô-ap. Mô-ap cỡt achúc achiac nheq tữh cũai Mô-ap toau toâq tangái nâi. ");
INSERT INTO bru_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Án ca a‑ễm ralŏ́h la canỡt muoi lám con samiang tê. Án amứh con samiang ki Ben-ami. Ben-ami cỡt achúc achiac nheq tữh cũai Amôn toau toâq tangái nâi. ");
INSERT INTO bru_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","A-praham loŏh tễ ntốq ki, sễng chu raloan cruang Cana-an, bân mpứng dĩ bar coah vil Cadet cớp vil Surơ. Chơ án pỡq ỡt dỡ tâng ntốq Kê-ar. ");
INSERT INTO bru_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Bo án ỡt ntốq ki án ramóh cũai Kê-ar ca bữn puo ramứh Abi-maléc. A-praham atỡng Abi-maléc tễ Sara lacuoi án, pai Sara la amuaq án. Ngkíq Abi-maléc pỡq coâiq Sara. ");
INSERT INTO bru_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ma Yiang Sursĩ atỡng Abi-maléc toâq parnáu rláu mpáu neq: “Mới cóq cuchĩt, yuaq mansễm mới ĩt nâi khoiq bữn cayac chơ.” ");
INSERT INTO bru_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ma Abi-maléc tỡ yũah táq ntrớu chóq mansễm ki. Ngkíq án atỡng neq: “Yiang Sursĩ ơi! Anhia ễ cachĩt cũai tỡ bữn táq lôih tỡ? ");
INSERT INTO bru_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Lứq samiang ki pai mansễm ki la amuaq án. Cớp mansễm ki ngin samiang ki la lứq amiang án. Ma tễ ranáq nâi, cứq tỡ bữn hữm lôih ntrớu.” ");
INSERT INTO bru_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Yiang Sursĩ atỡng án na rláu mpáu neq: “Ơq. Cứq dáng mứt pahỡm mới tỡ bữn táq lôih tễ ranáq nâi. Ngkíq, cứq khoiq catáng tỡ bữn yỗn mới táq lôih ntrớu chóq cứq. Cứq tỡ bữn yỗn mới táq ntrớu chóq mansễm ki. ");
INSERT INTO bru_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sanua cóq mới culáh loah mansễm ki yỗn cayac án. Samiang ki la cũai tang bỗq cứq. Án têq câu yỗn mới bữn tamoong. Khân mới ma tỡ bữn culáh mansễm ki, lứq samoât mới cớp nheq dống sũ mới cóq cuchĩt nheq.” ");
INSERT INTO bru_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abi-maléc tamỡ tễ cláih, chơ án arô nheq tữh máh cũai ranễng án. Án ruaih loah yỗn alới tamứng máh ramứh án rláu mpáu. Ngkíq nheq tữh cũai ki sâng croŏq lứq tê. ");
INSERT INTO bru_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Chơ Abi-maléc arô A-praham cớp blớh: “Nŏ́q mới táq ngkíq chóq hếq? Mới bữn ŏ́c par‑ũal ntrớu tỡ? Cỗ nŏ́q mới táq yỗn cứq cớp nheq tữh proai cứq bữn lôih toâr lứq? Nŏ́q mới táq chóq cứq ma tỡ cỡt rit?” ");
INSERT INTO bru_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abi-maléc blớh ễn A-praham: “Ntrớu mới chanchớm tâng mứt mới, nŏ́q mới táq ngkíq?” ");
INSERT INTO bru_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A-praham ta‑ỡi neq: “Cứq chanchớm neq: ‘Tâng cruang nâi tỡ bữn noau yám noap Yiang Sursĩ. Ngkíq, alới cachĩt chíq cứq, cỗ yoc ễ bữn lacuoi cứq.’ ");
INSERT INTO bru_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ma lứq samoât mansễm nâi la amuaq cứq tê. Án la con mansễm mpoaq cứq, ma hếq miar mpiq. Ma cứq ĩt án táq lacuoi. ");
INSERT INTO bru_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tữ Yiang Sursĩ yỗn cứq pỡq chu nâi chu ki yơng tễ dống mpoaq cứq, ki cứq pai cớp lacuoi cứq neq: ‘Khân mới lứq ayooq cứq, ntốq aléq hái toâq, mới dŏq cứq la amiang mới.’” ");
INSERT INTO bru_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Moâm ki, Abi-maléc dững cữu cớp ntroŏq, dếh cũai sũl mansễm cớp samiang, chơ yỗn pỡ A-praham. Cớp án culáh loah Sara yỗn A-praham. ");
INSERT INTO bru_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abi-maléc atỡng A-praham neq: “Nâi la cruang cứq ndỡm. Ntốq aléq mới yoc ễ ỡt, têq mới ỡt.” ");
INSERT INTO bru_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abi-maléc atỡng Sara neq: “Cứq yỗn muoi ngin ŏ́c práq pỡ amiang mới. Práq nâi la cứq sadal loah khân ranáq ntrớu ma cứq táq lôih chóq mới. Sanua choâng moat nheq tữh cũai, mới cỡt cũai tỡ bữn táq lôih ntrớu.” ");
INSERT INTO bru_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Moâm ki, A-praham câu sễq Yiang Sursĩ chuai Abi-maléc cớp lacuoi án, cớp nheq mansễm sũl án, yỗn nheq tữh alới ki têq táq ramia loah. ");
INSERT INTO bru_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Yuaq tễ nhũang, Yiang Sursĩ táq yỗn alới ki tỡ têq táq ramia cỗ tian tễ Sara, lacuoi A-praham. Moâm A-praham câu, Yiang Sursĩ chuai nheq tữh cũai ki têq táq ramia loah. ");
INSERT INTO bru_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yiang Sursĩ chuai Sara ariang parnai án khoiq ữq cớp alới chơ. ");
INSERT INTO bru_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Rapĩeiq ngư Yiang Sursĩ khoiq ữq ki, Sara mumiaq cớp canỡt muoi lám con samiang yỗn A-praham; bo ki A-praham khoiq thâu chơ. ");
INSERT INTO bru_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","A-praham amứh con samiang Sara canỡt la I-sac. ");
INSERT INTO bru_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Toâq I-sac bữn tacual tangái, A-praham táq rit cứt yỗn án. Án táq puai ĩn parnai Yiang Sursĩ khoiq patâp án chơ. ");
INSERT INTO bru_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Bo Sara sễt I-sac, A-praham khoiq bữn muoi culám cumo. ");
INSERT INTO bru_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara pai neq: “Yiang Sursĩ khoiq táq yỗn cứq têq cacháng bũi óh. Cớp cũai aléq ca sâng tễ ŏ́c nâi, alới têq cacháng bũi óh tê cớp cứq.” ");
INSERT INTO bru_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sara pai ễn neq: “Tễ nhũang, tỡ bữn noau khớn atỡng A-praham pai cứq ma têq canỡt muoi lám con samiang yỗn án. Ma tam A-praham khoiq thâu, cứq noâng têq sễt con samiang yỗn án.” ");
INSERT INTO bru_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tữ con samiang toâr achỗn cớp táh tóh, A-praham táq muoi pêl toâr cha sa‑ỡn tangái I-sac táh tóh. ");
INSERT INTO bru_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Bữn muoi tangái Sara hữm con samiang Hacar la cũai Ê-yip-tô khoiq sễt yỗn A-praham, cacháng saryễ níc I-sac. ");
INSERT INTO bru_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ngkíq Sara atỡng A-praham neq: “Cóq mới tuih chíq mansễm sũl nâi cớp con samiang án, yuaq con samiang ki tỡ têq rachống mun mới cớp I-sac, con samiang cứq.” ");
INSERT INTO bru_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ma A-praham tỡ bữn bũi tữ án sâng Sara pai ngkíq, yuaq It-ma-el la con samiang án tê. ");
INSERT INTO bru_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma Yiang Sursĩ atỡng A-praham neq: “Mới chỗi ngua ntrớu tễ con samiang mới It-ma-el cớp mpiq án. Máh santoiq Sara atỡng mới, cóq mới táq puai, yuaq nhơ tễ I-sac cứq táq máh ramứh cứq khoiq ữq cớp mới. ");
INSERT INTO bru_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma cứq táq yỗn tŏ́ng toiq It-ma-el cỡt muoi cruang tê, cỗ án la con samiang mới.” ");
INSERT INTO bru_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Toâq poang tarưp, A-praham tamỡ tễ cláih. Án ĩt sanyam cớp muoi aluoi dỡq yỗn Hacar. Án chóq crơng ki tâng apal Hacar, chơ ớn Hacar cớp con samiang án loŏh tễ ntốq ki. Ngkíq bar náq con cán loŏh, cớp pỡq chu nâi chu ki tâng ntốq aiq Bêr-si-ba. ");
INSERT INTO bru_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Toâq dỡq tâng aluoi khoiq nheq chơ, Hacar dŏq con samiang án nhưp prul. ");
INSERT INTO bru_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Chơ án pỡq tacu tâng ntốq canŏ́h, yơng tễ con án ỡt bữn muoi phữn alieiq. Án pai neq: “Cứq tỡ rơi nhêng con cứq cuchĩt.” Tữ án tacu ntốq ki, án nhiam cuclỗiq cucling níc. ");
INSERT INTO bru_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ma Yiang Sursĩ sâng sưong con samiang ki nhiam. Ngkíq, ranễng Yiang Sursĩ arô Hacar tễ paloŏng neq: “Hacar ơi! Nŏ́q mới sâng ngua? Mới chỗi ngcŏh ntrớu, yuaq Yiang Sursĩ khoiq sâng chơ sưong con samiang mới nhiam bân ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mới yuor tayứng, cớp acŏ́q con ki. Lứq samoât, cứq táq yỗn muoi cruang cũai clứng lứq rứh tễ án.” ");
INSERT INTO bru_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Chơ Yiang Sursĩ yỗn Hacar hữm muoi lám dỡq chữong cheq ntốq ki. Án pỡq ŏh dỡq yỗn poân aluoi, chơ án yỗn con án nguaiq. ");
INSERT INTO bru_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Moâm ki, Yiang Sursĩ chuai con samiang ki toâr, cỡt carsai. Án ỡt tâng ntốq aiq, cớp cỡt cũai chiang pán tamĩang. ");
INSERT INTO bru_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tữ án ỡt tâng ntốq aiq ramứh Paran, mpiq án ĩt yỗn án muoi lám lacuoi tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Prôq ki, puo Abi-maléc cớp manoaq sốt tahan án, ramứh Phi-côl, alới bar náq toâq pỡ A-praham cớp atỡng neq: “Lứq Yiang Sursĩ chuai níc mới tễ máh ranáq mới táq. ");
INSERT INTO bru_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ngkíq sanua sễq mới parkhán cớp cứq choâng moat Yiang Sursĩ, tữ nâi chumát mới tỡ bữn táq sâuq ntrớu chóq cứq, dếh nheq tữh tŏ́ng toiq cứq hỡ. Cứq khoiq táq o chóq mới nŏ́q, ngkíq mới cóq táq o loah machớng ki tê chóq cứq, cớp chóq cruang cutễq mới ỡt sanua.” ");
INSERT INTO bru_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","A-praham ta‑ỡi án neq: “Lứq samoât, cứq par‑ữq ngkíq cớp mới.” ");
INSERT INTO bru_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","A-praham tếq Abi-maléc, yuaq cũai táq ranáq yỗn Abi-maléc cheng chíq dỡq chữong A-praham. ");
INSERT INTO bru_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ma Abi-maléc ta‑ỡi A-praham neq: “Cứq tỡ dáng noau táq ngkíq. Mới tỡ bữn atỡng cứq tễ ranáq ki; toau toâq sanua cứq tỡ yũah dáng ntrớu loâng tễ ranáq ki.” ");
INSERT INTO bru_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Moâm ki A-praham dững cữu cớp ntroŏq yỗn Abi-maléc. Ngkíq alới bar náq pruam táq tếc parkhán parnơi. ");
INSERT INTO bru_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","A-praham rưoh dŏq tapul lám cữu tansữ. ");
INSERT INTO bru_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Chơ Abi-maléc blớh A-praham neq: “Mới dŏq tapul lám cữu tansữ nâi táq ntrớu?” ");
INSERT INTO bru_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A-praham ta‑ỡi neq: “Cứq sễq mới roap tapul lám cữu tansữ nâi, dŏq táq tếc cứq toâp píq dỡq chữong nâi.” ");
INSERT INTO bru_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Yuaq ngkíq, noau amứh ntốq ki la Bêr-si-ba, yuaq ntốq ki alới bar náq khoiq táq tếc parkhán parnơi. ");
INSERT INTO bru_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Moâm A-praham cớp Abi-maléc parkhán parnơi pỡ Bêr-si-ba, Abi-maléc cớp Phi-côl, la cũai sốt tahan khong Abi-maléc, alới píh chu loah pỡ dống alới pỡ cruang Phi-li-tin. ");
INSERT INTO bru_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A-praham chóh muoi nỡm aluang mpứl tâng Bêr-si-ba, cớp án câu sễq arô ramứh Yiang Sursĩ, la Yiang tamoong mantái níc. ");
INSERT INTO bru_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ngkíq A-praham ỡt dũn tâng cruang Phi-li-tin. ");
INSERT INTO bru_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bữn muoi tangái Yiang Sursĩ chim A-praham. Yiang Sursĩ arô A-praham; cớp A-praham ta‑ỡi neq: “Cứq ỡt nnâi.” ");
INSERT INTO bru_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Chơ Yiang Sursĩ ớn neq: “Cóq mới dững I-sac, con samiang mới ayooq lứq pỡq chu cruang Mô-ria. Ỡt ntốq ki cóq mới bốh con mới dŏq sang yỗn cứq tâng cóh cứq sadoi yỗn mới.” ");
INSERT INTO bru_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","A-praham tamỡ tễ cláih, chơ thrũan aséh dễn. Án chuaq ũih dŏq bốh crơng sang. Án dững bar náq cũai táq ranáq án, cớp con samiang án I-sac, chơ pỡq chu ntốq Yiang Sursĩ ớn án pỡq. ");
INSERT INTO bru_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Catâm tangái pái, A-praham tapoang achỗn, chơ hữm ntốq Mô-ria noâng yơng tễ alới. ");
INSERT INTO bru_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ngkíq A-praham atỡng bar náq cũai táq ranáq án neq: “Anhia ỡt nâi cớp aséh dễn. Cứq cớp con cứq pỡq chu tíh; hếq pỡq sang Yiang Sursĩ. Moâm ki hếq píh loah pỡ anhia.” ");
INSERT INTO bru_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ngkíq, A-praham ĩt ũih ễ bốh crơng sang; án yỗn I-sac dỗl ũih. Ma A-praham dững ũih blữ cớp yống achũ tâng atĩ. Chơ alới bar náq mpoaq con pruam pỡq. ");
INSERT INTO bru_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","I-sac pai cớp A-praham mpoaq án neq: “Mpoaq ơi!” A-praham ta‑ỡi: “Ntrớu mới ễ bữn, con?” I-sac blớh án neq: “Nâi, nlũiq ũih cớp ũih blữ; ma nléq cữu con hái ễ bốh sang?” ");
INSERT INTO bru_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","A-praham ta‑ỡi neq: “Con ơi! Yiang Sursĩ toâp yỗn cữu con hái ễ bốh sang.” Moâm ki, alới bar náq pỡq sĩa. ");
INSERT INTO bru_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tữ alới toâq pỡ ntốq Yiang Sursĩ ớn alới pỡq, A-praham táq prông. Án chóq ũih tâng prông, chơ án chŏ́q I-sac con án. Moâm ki án adỗt I-sac pỡng ũih tâng prông ki. ");
INSERT INTO bru_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Chơ A-praham thot achũ ễ kiac con án. ");
INSERT INTO bru_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma ranễng Yiang Sursĩ arô án tễ paloŏng neq: “A-praham ơi! A-praham ơi!” A-praham ta‑ỡi: “Ơq, cứq ỡt nnâi.” ");
INSERT INTO bru_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Chơ ranễng Yiang Sursĩ atỡng án neq: “Chỗi cachĩt con mới; chỗi táq ntrớu chóq án. Sanua cứq dáng chơ mới lứq yám noap cứq, yuaq con samiang mới muoi lám sâng, ma noâng mới tỡ bữn pasếq ntrớu sang yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Chơ A-praham tapoang nhêng, án hữm muoi lám cữu tôl cál tacoi tâng prul. A-praham ĩt cữu ki, kiac bốh sang yỗn Yiang Sursĩ dŏq pláih loah con án. ");
INSERT INTO bru_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ngkíq A-praham amứh ntốq ki neq: Yiang Sursĩ Thrũan Dŏq. Toau toâq tangái nâi noau noâng pai santoiq neq: “Tâng cóh Yiang Sursĩ, án thrũan dŏq.” ");
INSERT INTO bru_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Trỗ bar ễn ranễng Yiang Sursĩ arô A-praham tễ paloŏng, cớp atỡng án neq: ");
INSERT INTO bru_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Yiang Sursĩ atỡng neq: Lứq samoât, cứq thễ dũan cớp mới nhơ ramứh cứq toâp, yuaq mới táq ranáq nâi cớp tỡ bữn pasếq con muoi mới ễ sang yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ngkíq, cứq yỗn mới bữn ŏ́c bốn sa‑ữi, cớp cứq yỗn tŏ́ng toiq mới cỡt clứng ĩn mantỗr tâng paloŏng, ĩn chũah tâng tor dỡq mưt. Cớp tŏ́ng toiq mới lứq chíl riap máh cũai par‑ũal alới. ");
INSERT INTO bru_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dũ tỗp cũai pưn paloŏng cutrúq nâi bữn roap ŏ́c bốn la cỗ nhơ tễ tŏ́ng toiq mới. Cứq táq máh ranáq nâi, cỗ mới trĩh santoiq cứq.” ");
INSERT INTO bru_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Moâm Yiang Sursĩ pai ngkíq, A-praham cớp I-sac píh loah chu ntốq bar náq yớu alới ỡt acoan. Chơ alới thrũan cớp píh chu parnơi pỡ Bêr-si-ba. Ỡt ngki A-praham táq dống sarái. ");
INSERT INTO bru_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Toâq vớt ranáq ki, bữn cũai toâq pỡ A-praham cớp atỡng tễ Nahor, a‑ễm án. Lacuoi Nahor, ramứh Mil-ca, khoiq canỡt con samiang yỗn Nahor neq: ");
INSERT INTO bru_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Con clúng Nahor ramứh Usơ. A‑ễm Usơ la But, Camual la mpoaq Aram, ");
INSERT INTO bru_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Khê-set, Hasô, Pil-dat, Yit-lap, cớp Be-thuol. ");
INSERT INTO bru_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Be-thuol la mpoaq mansễm ramứh Rê-be-ca. Ngkíq Mil-ca amia tacual lám con samiang yỗn Nahor, a‑ễm A-praham. ");
INSERT INTO bru_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor bữn lacuoi cỗiq, ramứh Ruma. Án canỡt con samiang ramứh Tê-ba, Caham, Tahat, cớp Maca. ");
INSERT INTO bru_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara bữn tamoong nheq tữh la muoi culám bar chít tapul cumo. ");
INSERT INTO bru_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Chơ án cuchĩt pỡ ntốq Ki-riat Ar-ba (tỡ la Hep-rôn), ỡt tâng cruang Cana-an. A-praham nhiam atếh cớp tanúh cỗ Sara cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Moâm A-praham nhiam Sara cuchĩt, án pỡq atỡng con samiang Hêt neq: ");
INSERT INTO bru_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Cứq la cũai tamoi miat ca tarôq ỡt tâng cruang anhia. Ngkíq cứq sễq anhia dŏq loah yỗn cứq muoi ntốq cutễq tâng cruang anhia, dŏq bữn ntốq cứq tứp cumuiq.” ");
INSERT INTO bru_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Con samiang Hêt ta‑ỡi A-praham neq: ");
INSERT INTO bru_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Achuaih ơi! Sễq achuaih tamứng hếq pai. Achuaih la ariang anha ca noau yám noap lứq. Ngkíq têq achuaih tứp cumuiq tâng ping hếq khoiq táq. Tỡ bữn noau tễ hếq ma pasếq ping mŏ; têq achuaih tứp.” ");
INSERT INTO bru_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Chơ A-praham yuor tayứng cớp cucốh cucũoi choâng moat cũai tâng cruang ki, la tŏ́ng toiq Hêt. ");
INSERT INTO bru_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Án sễq tễ alới neq: “Khân nheq tữh anhia pruam yỗn cứq tứp cũai cuchĩt nâi, ki sễq anhia tamứng santoiq cứq. Cứq sễq cóng rêng anhia sễq tễ Ep-rôn, con samiang Sô-har, ");
INSERT INTO bru_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yỗn án chuai cứq bữn muoi cưp cheq tor ruang án. Cưp ki, ramứh Mac Pala. Cứq culáh loah práq kia cưp ki máh léq án yoc ễ bữn, dŏq yỗn cứq bữn tê muoi ntốq tứp cumuiq cứq tâng cruang anhia nâi.” ");
INSERT INTO bru_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ep-rôn la cũai Hêt tê. Án tacu mpứng dĩ tỗp alới bân ntốq ki tê. Án atỡng A-praham choâng moat nheq tữh cũai Hêt cớp nheq tữh cũai canŏ́h cheq bân ngoah toong viang vil neq: ");
INSERT INTO bru_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Chỗi táq ngkíq achuaih ơi! Sễq achuaih tamứng cứq voai. Cứq ễ yỗn achuaih miat sâng ruang cớp cưp ki. Cứq yỗn ramứh nâi choâng moat nheq tữh cũai. Achuaih têq tứp cumuiq pỡ ntốq ki.” ");
INSERT INTO bru_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ma A-praham cucốh cucũoi choâng moat cũai ỡt tâng cruang ki ");
INSERT INTO bru_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","cớp atỡng Ep-rôn yỗn nheq tữh cũai ki sâng tê neq: “Khân anhia pruam cớp cứq, ki sễq anhia tamứng santoiq cứq. Cứq ễ yỗn kia ruang nâi; cứq sễq anhia roap ĩt práq nâi dŏq cứq tứp cumuiq tâng ki.” ");
INSERT INTO bru_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ep-rôn ta‑ỡi loah A-praham neq: ");
INSERT INTO bru_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Achuaih ơi! Sễq achuaih tamứng santoiq cứq. Muoi mễng cutễq nâi, bữn kia pỗn culám ŏ́c práq panê. Ma tỡ bữn ntrớu, cứq yỗn achuaih miat sâng. Achuaih tỡ bữn túh yỗn práq. Têq achuaih tứp cumuiq tâng ki.” ");
INSERT INTO bru_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tữ A-praham sâng Ep-rôn pai ngkíq, án yỗn pỗn culám ŏ́c práq panê pỡ Ep-rôn choâng moat cũai clứng tỗp Hêt. Práq nâi noau chếq chỡng tâng dỡi ki. ");
INSERT INTO bru_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Ngkíq A-praham chỡng ruang Ep-rôn choâng moat cũai Hêt ca ỡt cheq ngoah toong viang vil ki. Ruang nâi ỡt tâng Mac Pala, cheq Mam-rê. Chơ A-praham bữn ndỡm ruang nâi, dếh cưp, dếh máh aluang aloai tâng ruang ki. ");
INSERT INTO bru_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Moâm ki A-praham tứp Sara lacuoi án tâng cưp pỡ ruang Mac Pala, cheq Mam-rê. Mam-rê bữn ramứh Hep-rôn hỡ. Ntốq Hep-rôn ỡt tâng cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","A-praham bữn ndỡm ruang cớp cưp ki tễ cũai Hêt, yỗn án têq tứp cumuiq. Cũai tỗp Hêt chếq loâng cutễq ki yỗn A-praham. ");
INSERT INTO bru_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","A-praham bữn sa‑ữi cumo, cớp án khoiq thâu lứq chơ. Yiang Sursĩ khoiq yỗn ŏ́c bốn puan máh ranáq án táq. ");
INSERT INTO bru_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","A-praham atỡng cũai ca nhêng salĩq nheq máh ranáq tâng dống án neq: “Mới cóq satoaq atĩ mới tâng nlu cứq, chơ thễ dũan choâng moat Yiang Sursĩ ca tễng paloŏng cutễq. ");
INSERT INTO bru_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Cứq yoc mới thễ dũan nhơ ramứh Yiang Sursĩ neq: Mới tỡ bữn chuaq lacuoi yỗn con cứq tễ mansễm tâng cruang Cana-an, ntốq cứq ỡt sanua. ");
INSERT INTO bru_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ma cóq mới chu pỡ cruang sễm ai cứq ỡt. Chơ chuaq mansễm tễ sễm ai cứq dŏq táq lacuoi I-sac.” ");
INSERT INTO bru_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ma cũai táq ranáq ki pai neq: “Khân mansễm ki tỡ ễq puai cứq toâq pỡ cruang nâi, têq tỡ cứq dững con samiang anhia pỡq chu cruang anhia khoiq loŏh tễ nhũang chơ?” ");
INSERT INTO bru_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","A-praham ta‑ỡi án neq: “Chỗi! Chỗi dững con cứq pỡq chu cruang ki. ");
INSERT INTO bru_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yiang Sursĩ, la Ncháu sốt tâng paloŏng, khoiq dững aloŏh cứq tễ dống mpoaq cớp sâu cứq. Yiang Sursĩ khoiq táq ntỡng cớp par‑ữq cớp cứq, la án ễ yỗn tŏ́ng toiq cứq bữn ndỡm cruang nâi. Lứq Yiang Sursĩ ớn ranễng án tễ paloŏng pỡq nhũang mới, dŏq mới chuaq ramóh lacuoi yỗn I-sac con samiang cứq pỡ ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Khân mansễm ki tỡ ễq puai mới, ki mới têq vớt tễ parnai mới thễ dũan cớp cứq. Ma mới chỗi dững con cứq pỡq pỡ ntốq ki.” ");
INSERT INTO bru_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Chơ cũai ki thễ dũan cớp A-praham la ncháu án, choâng moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Moâm ki, án pỡq ĩt muoi chít lám charán lac‑da khong A-praham. Chơ án chóq tâng charán ki dũ ramứh crơng ngoaih cớp crơng nêuq ca ncháu án khoiq yỗn án dững. Cớp án loŏh pỡq angia pỡng pỡ cruang Mê-sapô-tamia, chơ pỡq pỡ vil Nahor ỡt. ");
INSERT INTO bru_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Bo án toâq pỡ vil ki khoiq cheq sadâu chơ. Yáng tiah vil ki, án yỗn charán lac‑da rlu cheq dỡq chữong. Toâq sadâu nhứm-nhứm bữn máh mansễm loŏh tễ vil ki pỡq ŏh dỡq tễ chữong. ");
INSERT INTO bru_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Cũai ki câu sễq tễ Yiang Sursĩ neq: “Ơ Yiang Sursĩ ơi! Ống anhia toâp la Yiang ncháu cứq, A-praham, sang. Sễq anhia chuai cứq nứng tâng tangái nâi, cớp sễq anhia sâng sarũiq táq chóq A-praham, ncháu cứq. ");
INSERT INTO bru_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Sanua nâi cứq ỡt cheq dỡq chữong, cớp con mansễm cũai tễ vil nâi loŏh ŏh dỡq. ");
INSERT INTO bru_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ngkíq sễq anhia chuaq tễ máh mansễm ca toâq ŏh dỡq nâi, manoaq ca pruam ŏh dỡq yỗn cứq bữn nguaiq, cớp yỗn charán cứq nguaiq hỡ. Khân bữn mansễm ma táq ngkíq, ki sễq yỗn mansễm ki cỡt án ca anhia rưoh dŏq cỡt lacuoi I-sac. Táq ngkíq, anhia apáh yỗn cứq dáng la anhia ayooq táq ncháu cứq.” ");
INSERT INTO bru_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Bo án noâng ỡt câu ngkíq, bữn muoi noaq mansễm ramứh Rê-be-ca, toâq pỡ ki dỗl khang tâng apal. Mansễm nâi la con Be-thuol, cớp châu Nahor; Nahor la a‑ễm A-praham, cớp lacuoi Nahor la Mil-ca. ");
INSERT INTO bru_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rê-be-ca la mansễm thán riang o lứq, cớp noâng cumũr plot. Rê-be-ca sễng ŏh dỡq yỗn poân khang, chơ chỗn loah. ");
INSERT INTO bru_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ranễng A-praham pỡq chái yoc ễ ramóh mansễm ki. Cớp án sễq tễ mansễm ki neq: “Cứq sễq nguaiq bĩq dỡq tễ khang mới.” ");
INSERT INTO bru_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mansễm ki ta‑ỡi neq: “Têq! Nguaiq, achuaih ơi.” Chơ án achúh toâp khang dỡq cớp yỗn cũai ki nguaiq. ");
INSERT INTO bru_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Toâq moâm cũai ki nguaiq dỡq, mansễm ki pai neq: “Têq cứq ŏh dỡq yỗn charán lac‑da mới nguaiq dũ tê.” ");
INSERT INTO bru_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Chơ mansễm ki tốh dỡq tễ khang chóq tâng tapuang, cớp án ŏh ễn dỡq tễ chữong toau charán lac‑da nguaiq dũ nheq. ");
INSERT INTO bru_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Cũai ki tỡ bữn pai ntrớu, ma án cloân níc chu mansễm ki. Cớp án chanchớm tâng mứt neq: Yiang Sursĩ lứq chuai cứq tễ ranáq nâi ma tỡ bữn. ");
INSERT INTO bru_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Moâm charán lac‑da nguaiq dỡq, cũai táq ranáq A-praham dững aloŏh muoi sarcáp yễng chóq tâng múh cớp bar bễng cŏ́ng yễng, chơ án yỗn pỡ mansễm ki. ");
INSERT INTO bru_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Cớp án blớh neq: “Cứq sễq mới atỡng yỗn cứq dáng ramứh mpoaq mới, cớp dống mpoaq mới pỡ ntốq léq. Têq tỡ hếq bếq dống mpoaq mới sadâu nâi?” ");
INSERT INTO bru_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mansễm ki ta‑ỡi neq: “Mpoaq cứq ramứh Be-thuol, con Nahor cớp Mil-ca.” ");
INSERT INTO bru_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Chơ mansễm ki pai ễn: “Hếq tỡ bữn ŏ́q bát yỗn charán mới cớp ntốq yỗn anhia bếq.” ");
INSERT INTO bru_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Chơ ranễng A-praham cucốh sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Cớp án câu neq: “Khễn Yiang Sursĩ, la Yiang A-praham, ncháu cứq sang, yuaq án tỡ bữn táh parnai án khoiq par‑ữq cớp ncháu cứq. Án khoiq dững cứq toâq pỡ dống sễm ai ncháu cứq.” ");
INSERT INTO bru_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Chơ mansễm ki lúh chu pỡ dống, cớp atỡng nheq máh ramứh khoiq toâq pỡ án. ");
INSERT INTO bru_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rê-be-ca bữn manoaq amiang ramứh Laban. ");
INSERT INTO bru_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Toâq Laban hữm sarcáp cớp cŏ́ng tâng atĩ a‑ễm án, cớp sâng santoiq a‑ễm án atỡng tễ cũai samiang ki pai, ngkíq Laban lúh toâq pỡ cũai samiang ki ca noâng ỡt cheq dỡq chữong. ");
INSERT INTO bru_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Chơ Laban atỡng cũai samiang ki neq: “Achuaih ơi! Yiang Sursĩ toâp khoiq chuai achuaih. Sễq mơi achuaih pỡq pỡ dống cứq. Nŏ́q achuaih ỡt yáng tiah vil? Cứq khoiq thrũan chơ, cớp bữn tê ntốq yỗn charán lac‑da achuaih têq ỡt.” ");
INSERT INTO bru_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tữ ranễng A-praham toâq pỡ dống Laban, chơ cũai táq ranáq Laban ruoh crơng tễ cloong lac‑da, cớp yỗn charán ki soc cớp bát. Laban aloŏh dỡq yỗn ranễng A-praham cớp cũai ca pỡq parnơi cớp án ariau ayững atĩ. ");
INSERT INTO bru_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Chơ noau dững aloŏh crơng sana yỗn ranễng A-praham cha. Ma ranễng ki pai neq: “Cứq tỡ ễq cha yũah. Cứq yoc ễ táq ntỡng tễ ranáq cứq toâq pỡ nâi voai. Moâm ki, nŏ́q cứq chi-cha.” Laban ta‑ỡi án neq: “Ơq, têq, âu anhia pai.” ");
INSERT INTO bru_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ngkíq ranễng ki pai neq: “Cứq la cũai táq ranáq yỗn A-praham. ");
INSERT INTO bru_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yiang Sursĩ khoiq yỗn ncháu cứq bữn ŏ́c bốn sa‑ữi. Án yỗn ncháu cứq cỡt cũai sốt toâr, cớp án khoiq yỗn ncháu cứq cỡt sốc bữn; ncháu cứq bữn sa‑ữi lứq ntroŏq, cữu, práq yễng, lac‑da, aséh, cớp bữn mansễm samiang táq ranáq yỗn án clứng lứq. ");
INSERT INTO bru_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara lacuoi ncháu cứq khoiq canỡt muoi lám con samiang yỗn ncháu cứq, bo án khoiq thâu lứq chơ. Cớp ncháu cứq yỗn con samiang ki ễn ndỡm máh mun án. ");
INSERT INTO bru_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ngkíq ncháu cứq ớn cứq thễ dũan choâng moat Yiang Sursĩ neq: ‘Mới chỗi ĩt lacuoi yỗn con cứq tễ mansễm ỡt tâng cruang Cana-an, la ntốq cứq ỡt sanua. ");
INSERT INTO bru_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ma cóq mới pỡq chuaq pỡ sâu mpoaq cứq cớp sễm ai cứq, chơ ĩt lacuoi yỗn con cứq.’ ");
INSERT INTO bru_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Cứq khoiq blớh ncháu cứq neq: ‘Ma khân mansễm ki tỡ ễq puai cứq, ki nŏ́q cứq ễ táq?’” ");
INSERT INTO bru_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Án ta‑ỡi cứq neq: ‘Lứq Yiang Sursĩ ca cứq sang ớn ranễng án tễ paloŏng pỡq cớp mới, yỗn mới bữn tamóh ŏ́c bốn, cớp têq mới ĩt muoi noaq mansễm dŏq cỡt lacuoi con cứq, tễ sâu mpoaq cứq. ");
INSERT INTO bru_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ma khân mới toâq pỡ sễm ai cứq, ma alới tỡ yỗn con mansễm alới pỡq cớp mới, ki mới têq racláh tễ parnai mới khoiq thễ dũan chóq cứq.’ Ngkíq A-praham atỡng cứq. ");
INSERT INTO bru_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Tữ cứq toâq pỡ dỡq chữong tangái nâi, cứq sễq tễ Yiang Sursĩ neq: ‘Ơ Yiang Sursĩ ơi! Anhia la Yiang ncháu cứq A-praham sang. Sễq anhia chuai cứq tâng ranáq cứq ễ táq neq: ");
INSERT INTO bru_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Bo cứq ỡt tayứng cheq dỡq chữong nâi, khân bữn mansễm aléq toâq ŏh dỡq, cớp cứq sễq nguaiq dỡq tễ khang án, ");
INSERT INTO bru_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","khân án yỗn cứq nguaiq, cớp ŏh dỡq yỗn charán lac‑da cứq nguaiq hỡ, ki sễq yỗn mansễm ki toâp cỡt án ca anhia rưoh dŏq cỡt lacuoi yỗn con ncháu cứq.’ ");
INSERT INTO bru_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Bo cứq noâng ỡt câu ngkíq, Rê-be-ca dỗl khang tâng apal án, chơ sễng ŏh dỡq tâng chữong ki. Ngkíq cứq sễq tễ án neq: ‘Cứq sễq nguaiq bĩq dỡq tễ khang mới.’ ");
INSERT INTO bru_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Chơ án achúh toâp khang án, cớp pai neq: ‘Âu nguaiq achuaih, cớp cứq yỗn charán lac‑da achuaih nguaiq tê.’ Ngkíq cứq nguaiq, cớp charán lac‑da cứq la bữn nguaiq tê. ");
INSERT INTO bru_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Moâm ki cứq blớh Rê-be-ca neq: ‘Mới la con noau?’ “Rê-be-ca ta‑ỡi: ‘Cứq la con Be-thuol, con Nahor cớp Mil-ca.’ “Chơ cứq ĩt muoi lám sarcáp chóq tâng múh án, cớp cứq ĩt dŏq cŏ́ng asớp tâng ngcŏ́ng án. ");
INSERT INTO bru_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Chơ cứq cucốh sang Yiang Sursĩ la Yiang A-praham, ncháu cứq sang. Yiang Sursĩ dững cứq pỡq pĩeiq rana yỗn toâq pỡ sễm ai ncháu cứq, dŏq ĩt mansễm tễ con sễm ai ncháu cứq yỗn cỡt cumân án. ");
INSERT INTO bru_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ngkíq sanua khân nheq tữh anhia sâng ayooq táq cớp yoc ễ táq o chóq ncháu cứq, sễq anhia atỡng ŏ́c ki yỗn cứq dáng. Khân anhia tỡ bữn pruam, ki sễq anhia atỡng yỗn cứq dáng.” ");
INSERT INTO bru_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Chơ Laban cớp Be-thuol ta‑ỡi neq: “Ranáq nâi lứq toâq tễ Yiang Sursĩ. Hếq tỡ têq pai ntrớu noâng. Hếq pruam toâp. ");
INSERT INTO bru_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nâi la Rê-be-ca; dững án chu cớp mới tê, dŏq án cỡt lacuoi con ncháu mới, riang Yiang Sursĩ khoiq apáh mới chơ.” ");
INSERT INTO bru_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tữ ranễng A-praham sâng santoiq alới pai ngkíq, án ap cucốh sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Moâm ki, án ĩt aloŏh máh crơng práq yễng, cớp tampâc, chơ án chiau nheq máh crơng ki yỗn Rê-be-ca. Cớp án chiau crơng moat lứq hỡ yỗn amiang cớp mpiq Rê-be-ca. ");
INSERT INTO bru_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Moâm ki án cớp nheq máh cũai ca pỡq cớp án cha nguaiq parnơi, cớp alới bếq muoi sadâu ngki voai. Toâq poang tarưp, ranễng A-praham tamỡ, chơ án atỡng amiang cớp mpiq Rê-be-ca neq: “Cứq sễq chu loah pỡ ncháu cứq.” ");
INSERT INTO bru_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ma amiang cớp mpiq Rê-be-ca pai neq: “Sễq mới yỗn mansễm nâi ỡt loah cớp hếq sám bữn muoi chít tangái voai. Moâm ki têq án pỡq cớp mới.” ");
INSERT INTO bru_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ma ranễng A-praham ta‑ỡi neq: “Anhia chỗi táq yỗn cứq cỡt yũt. Yiang Sursĩ khoiq táq nheq ranáq o yỗn cứq, bo cứq toâq pỡ nâi. Sanua cứq sễq chu toâp pỡ ncháu cứq.” ");
INSERT INTO bru_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Alới ta‑ỡi án neq: “Hếq ễ arô mansễm ki cớp blớh án voai.” ");
INSERT INTO bru_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Chơ alới arô Rê-be-ca cớp blớh án neq: “Mới pruam pỡq cớp cũai nâi sanua tỡ?” Án ta‑ỡi: “Ơq. Cứq pruam.” ");
INSERT INTO bru_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ngkíq, alới yỗn Rê-be-ca pỡq cớp ranễng A-praham cớp máh cũai pỡq cớp án. Cớp bữn manoaq mansễm cũai mantán Rê-be-ca pỡq tê. ");
INSERT INTO bru_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Chơ cũai tâng dống Rê-be-ca patâp án neq: “Lứq mới la amuaq hếq. Hếq ễq yỗn mới cỡt mpiq sa‑ữi ngin cũai. Cớp hếq ễq yỗn nheq tŏ́ng toiq mới riap dũ náq cũai par‑ũal alới.” ");
INSERT INTO bru_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ngkíq, Rê-be-ca cớp máh mansễm táq ranáq yỗn án thrũan pỡq. Alới chỗn tâng cloong charán lac‑da pỡq cớp ranễng A-praham. Chơ ranễng ki dững Rê-be-ca pỡq cớp án. ");
INSERT INTO bru_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ma bo ki I-sac mbỡiq chu tễ dỡq chữong Lahai Roi, yuaq bo ki án ỡt coah angia pưn tâng cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Toâq nhứm-nhứm I-sac tayáh tâng ruang cớp ntôm ỡt chanchớm. Bo án tayáh, án tapoang hữm charán lac‑da toâq. ");
INSERT INTO bru_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rê-be-ca tapoang hữm I-sac, chơ án sễng tễ cloong lac‑da. ");
INSERT INTO bru_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Cớp án blớh ranễng A-praham neq: “Cũai samiang tayáh tâng ruang ki cớp toâq pỡ hái la noau?” Ranễng ki ta‑ỡi neq: “Cũai ki la ncháu cứq.” Ngkíq Rê-be-ca pul chíq mieiq án dŏq yám noap I-sac. ");
INSERT INTO bru_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Chơ ranễng A-praham ruaih loah yỗn I-sac dáng nheq máh ranáq án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Moâm ki, I-sac dững Rê-be-ca mut chu dống aroâiq Sara, mpiq án, cơi ỡt tễ nhũang; cớp án táq yỗn niang cỡt lacuoi án. I-sac ayooq lứq Rê-be-ca, cớp Rê-be-ca aliam I-sac chỗi yỗn án sâng ngua noâng cỗ sanhữ mpiq án khoiq cuchĩt chơ. ");
INSERT INTO bru_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ngkíq A-praham ĩt muoi lám ễn lacuoi, ramứh Kê-tura. ");
INSERT INTO bru_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kê-tura canỡt máh con samiang yỗn A-praham, ramứh Sim-ran, Yôc-san, Mê-dan, Madian, It-bac, cớp Suah. ");
INSERT INTO bru_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yôc-san bữn con samiang ramứh Sê-ba cớp De-dan, cớp De-dan cỡt achúc achiac máh tỗp Asur, Lê-tut, cớp Lê-um. ");
INSERT INTO bru_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madian bữn con samiang ramứh E-pha, E-phơ, Hanoc, Abi-da, cớp El-da. Nheq tữh cũai ki cỡt tŏ́ng toiq Kê-tura. ");
INSERT INTO bru_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","A-praham yỗn I-sac ndỡm nheq máh mun án. ");
INSERT INTO bru_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ma bo án noâng tamoong, án yỗn crơng o yỗn nheq tữh con samiang ca án bữn cớp lacuoi cỗiq. Chơ án ớn máh con ki pỡq ỡt coah angia mandang loŏh, cớp ỡt miar cruang tễ I-sac. ");
INSERT INTO bru_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","A-praham tamoong bữn muoi culám tapul chít la sỡng cumo. ");
INSERT INTO bru_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Anhúq án cuti lứq. Moâm ki án cuchĩt ariang achúc achiac án tễ nhũang tê. ");
INSERT INTO bru_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","I-sac cớp It-ma-el, bar náq con samiang A-praham, tứp mpoaq alới tâng cưp Mac Pala tâng ruang khong Ep-rôn, con samiang Sô-har, cũai tỗp Hêt, cheq ntốq Mam-rê. ");
INSERT INTO bru_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ruang nâi, A-praham khoiq chỡng tễ tỗp Hêt. Ỡt ntốq ki, máh con samiang A-praham tứp án cheq ping Sara lacuoi án. ");
INSERT INTO bru_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Vớt A-praham cuchĩt, Yiang Sursĩ satốh ŏ́c bốn yỗn I-sac ễn. Bo ki I-sac ỡt cheq dỡq chữong ramứh Lahai Roi. ");
INSERT INTO bru_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saráq nâi atỡng tễ tŏ́ng toiq It-ma-el, con samiang A-praham bữn cớp Hacar, la mansễm Ê-yip-tô ca táq ranáq yỗn Sara. ");
INSERT INTO bru_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ramứh con samiang It-ma-el noap tễ con clúng toau toâq con ralŏ́h, la neq: Nê-bayôt, Kê-da, At-bil, Mip-sam, ");
INSERT INTO bru_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mit-ma, Duma, Masa, ");
INSERT INTO bru_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tê-ma, Yê-tur, Naphit, cớp Kêt-ma. ");
INSERT INTO bru_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nheq tữh alới la con samiang It-ma-el. Ramứh vil alới ỡt la tũoiq loah ramứh alới tê. Cớp alới cỡt sốt tâng muoi chít la bar tỗp. ");
INSERT INTO bru_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","It-ma-el tamoong nheq tữh la muoi culám pái chít tapul cumo, chơ án cuchĩt ariang achúc achiac án tê. ");
INSERT INTO bru_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tŏ́ng toiq It-ma-el ỡt tâng cutễq tễ Havi-la toau toâq pỡ ntốq ramứh Surơ. Cutễq nâi ỡt coah angia mandang loŏh tễ cruang Ê-yip-tô choâng coah cruang Asi-ria. Alới ỡt miar ntốq tễ sễm ai alới. ");
INSERT INTO bru_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Parnai nâi atỡng tễ I-sac, con samiang A-praham. ");
INSERT INTO bru_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Bo I-sac bữn pỗn chít cumo, án ĩt Rê-be-ca con Be-thuol táq lacuoi án. Amiang Rê-be-ca ramứh Laban, cớp alới la cũai tễ tỗp Aram ca ỡt tâng cruang Padan Aram. ");
INSERT INTO bru_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rê-be-ca la cũai cũt; ngkíq I-sac câu sễq tễ Yiang Sursĩ chuai lacuoi án. Chơ Yiang Sursĩ yỗn ŏ́c I-sac sễq tễ án; ngkíq Rê-be-ca lacuoi I-sac ỡt mumiaq. ");
INSERT INTO bru_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rê-be-ca sâng con án rachâu rêng lứq tâng púng. Án dớt lứq cớp chanchớm neq: “Nŏ́q ranáq nâi toâq pỡ cứq?” Chơ án câu blớh Yiang Sursĩ tễ ŏ́c nâi. ");
INSERT INTO bru_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yiang Sursĩ atỡng án neq: “Tâng púng mới bữn bar lám con samiang, nỡ‑ra alới cỡt miar cruang. Lứq bữn bar tỗp cũai loŏh tễ tỗ mới. Ma tỗp muoi bữn bán rêng hỡn tễ tỗp bar. Cớp con ndĩ cỡt sốt hỡn tễ con clúng.” ");
INSERT INTO bru_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Toâq ngư Rê-be-ca canỡt con, án bữn con cartuan. ");
INSERT INTO bru_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Con clúng ki loŏh, ma ngcâr án cusâu nheq, cớp bữn sóc muar sa‑ữi lứq, samoât án sớp au táq toâq sóc charán. Ngkíq, alới amứh con ki la Ê-sau. ");
INSERT INTO bru_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Moâm ki a‑ễm án ễn loŏh; ma atĩ án yống candỡl Ê-sau. Ngkíq, alới amứh con ki la Yacốp. Tangái Rê-be-ca canỡt bar lám con samiang nâi, I-sac bữn tapoât chít cumo chơ. ");
INSERT INTO bru_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bar náq sễm ai ki cỡt toâr achỗn. Ê-sau ỡt tâng ruang, cỡt cũai prian pupán. Ma Yacốp ỡt níc tâng dống, cỡt cũai bĩq bỗq. ");
INSERT INTO bru_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yuaq ngkíq, I-sac ma ayooq lứq Ê-sau, yuaq án mác lứq cha sâiq charán Ê-sau pupán. Ma Rê-be-ca ayooq Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Bữn muoi tangái Ê-sau chu tễ ruang, án hữm Yacốp tacooq dũih satong. Án sâng panhieih lứq, ễ catớq tháng. ");
INSERT INTO bru_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Chơ án sễq tễ Yacốp neq: “Chái, chái! Yỗn cứq cha tê crơng sana cusâu ki. Cứq sâng panhieih lứq, ễ catớq tháng.” (Yuaq án pai ngkíq, noau dŏq ramứh án la Ê-dôm. Saráq ‘ê-dôm’ parlong loah la ‘cusâu’.) ");
INSERT INTO bru_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yacốp pai chóq Ê-sau neq: “Sanua hái ralêq; cóq mới yỗn chíq cứq chớc con clúng ca mới bữn.” ");
INSERT INTO bru_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ê-sau ta‑ỡi neq: “Têq! Cứq cheq ễ cuchĩt chơ! Chớc ki tỡ bữn kia ntrớu yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ma Yacốp pai ễn neq: “Sanua cóq mới thễ dũan cớp cứq tễ ramứh nâi.” Ngkíq Ê-sau thễ dũan. Án chếq chíq yỗn Yacốp chớc án cỡt con clúng. ");
INSERT INTO bru_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Moâm ki Yacốp yỗn Ê-sau cha bễng cớp dũih satong cusâu. Chơ Ê-sau cha nguaiq. Vớt ki, án yuor tayứng pỡq chu ntốq canŏ́h ễn. Án tỡ bữn chanchớm ntrớu noâng tễ chớc án cỡt con clúng. ");
INSERT INTO bru_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Chơ tâng cruang ki cỡt loah ŏ́q crơng sana, machớng dỡi A-praham tễ nhũang tê. Yuaq ngkíq I-sac pỡq chuaq crơng sana pỡ Abi-maléc, puo cũai Phi-li-tin ca ỡt tâng ntốq Kê-ar. ");
INSERT INTO bru_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Chơ Yiang Sursĩ toâq pỡ I-sac cớp atỡng án neq: “Mới chỗi sễng pỡ cruang Ê-yip-tô. Cóq mới ỡt tâng ntốq cứq apáh mới nỡ‑ra. ");
INSERT INTO bru_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ma sanua, cóq mới ỡt tâng cruang nâi voai. Cứq lứq ỡt cớp mới, cớp yỗn mới bữn ŏ́c bốn sa‑ữi. Ma nỡ‑ra, cứq yỗn mới cớp tŏ́ng toiq mới bữn ndỡm nheq máh cruang nâi. Cứq táq ariang cứq khoiq par‑ữq cớp A-praham, mpoaq mới. ");
INSERT INTO bru_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Cớp cứq yỗn tŏ́ng toiq mới cỡt clứng lứq ĩn mantỗr tâng paloŏng ca tỡ bữn noau rơi ngih. Cứq yỗn tŏ́ng toiq mới bữn ndỡm nheq cruang nâi, dếh cứq yỗn dũ cruang tâng pưn paloŏng cutrúq nâi roap ŏ́c bốn tê, la cỗ nhơ tễ tŏ́ng toiq mới. ");
INSERT INTO bru_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Cứq táq ngkíq la cỗ A-praham tamứng santoiq cứq, cớp án trĩh nheq máh ŏ́c cứq patâp án cớp nheq phễp rit cứq atỡng.” ");
INSERT INTO bru_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ngkíq, I-sac ỡt tâng Kê-ar. ");
INSERT INTO bru_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Chơ toâq cũai samiang ỡt tâng ki blớh tễ lacuoi án, I-sac ta‑ỡi neq: “Mansễm nâi la amuaq cứq.” Ma án tỡ bữn atỡng raloaih pai Rê-be-ca la lacuoi án, yuaq án ngcŏh cũai samiang ki cachĩt án, cỗ yoc ễ bữn Rê-be-ca; yuaq Rê-be-ca la cũai thán riang o. ");
INSERT INTO bru_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Toâq I-sac ỡt tâng ntốq ki dũn chơ, Abi-maléc la puo Phi-li-tin, tapoang tễ toong piang tâng dống án; chơ án hữm I-sac ra‑ac Rê-be-ca. ");
INSERT INTO bru_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ngkíq, Abi-maléc arô I-sac, cớp blớh neq: “Mansễm ki la lứq lacuoi mới. Ma nŏ́q mới pai án la amuaq mới?” I-sac ta‑ỡi neq: “Cứq pai ngkíq, yuaq cứq ngcŏh noau cachĩt cứq cỗ tễ mansễm nâi.” ");
INSERT INTO bru_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ma Abi-maléc pai neq: “Nŏ́q mới táq chóq hếq ngkíq? Khân bữn manoaq cũai samiang tâng cruang cứq ma pỡq langơp lacuoi mới, ki mới táq yỗn hếq bữn lôih ntâng lứq.” ");
INSERT INTO bru_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Moâm ki Abi-maléc atỡng nheq tữh cũai samiang tâng cruang án neq: “Khân cũai aléq ma táq sâuq chóq samiang ki tỡ la lacuoi án, cứq cachĩt toâp cũai ki.” ");
INSERT INTO bru_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Vớt ki, I-sac trứh ŏ́c tâng cutễq cruang ki. Tâng muoi cumo ki án bữn lơi muoi culám pún tễ ŏ́c ki, yuaq Yiang Sursĩ yỗn án bữn ŏ́c bốn sa‑ữi. ");
INSERT INTO bru_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Chơ I-sac cỡt sốc bữn. Cu rangái án bữn sa‑ữi ễn, toau án cỡt sốc lứq ễn. ");
INSERT INTO bru_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Án bữn sa‑ữi lứq cữu cớp ntroŏq, dếh cũai táq ranáq yỗn án hỡ. Ngkíq cũai Phi-li-tin sa‑on cumíq tễ I-sac. ");
INSERT INTO bru_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Chơ alới cubớl chíq dỡq chữong ca cũai táq ranáq yỗn A-praham, mpoaq án, khoiq píq tễ bo dỡi A-praham. ");
INSERT INTO bru_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abi-maléc atỡng I-sac neq: “Sễq mới dễq chíq tễ tỗp hếq, yuaq mới bữn chớc toâr hỡn tễ hếq.” ");
INSERT INTO bru_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ngkíq I-sac dễq tễ ntốq ki; chơ án ayứng dống aroâiq tâng avúng Kê-ar. ");
INSERT INTO bru_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Án píq loah dỡq chữong tiaq ca A-praham mpoaq án khoiq píq tễ nhũang. Toâq vớt A-praham cuchĩt, tỗp Phi-li-tin khoiq cubớl chíq cutễq tâng dỡq chữong ki. Chơ I-sac amứh dỡq chữong ki machớng mpoaq án khoiq amứh tễ nhũang tê. ");
INSERT INTO bru_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Máh cũai táq ranáq yỗn I-sac píq dỡq chữong tamái tâng avúng ki, cớp alới ramóh ntốq dỡq mec. ");
INSERT INTO bru_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma cũai mantán tễ tỗp Kê-ar ralỗih cớp cũai mantán cữu I-sac neq: “Dỡq nâi la lứq dỡq hếq.” Yuaq ngkíq I-sac amứh dỡq chữong ki E-séc, yuaq santoiq ‘e-séc’ parlong loah la ‘ralỗih’. ");
INSERT INTO bru_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Moâm ki, I-sac píq dỡq chữong bân canŏ́h ễn. Ma alới tampỗr sĩa dỡq chữong ki. Ngkíq I-sac amứh dỡq chữong ki la Sit-na. ");
INSERT INTO bru_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Chơ I-sac táh sĩa dỡq chữong ki, cớp píq pỡ ntốq canŏ́h ễn. Ma tỡ bữn noau tampỗr noâng tễ dỡq chữong ki. Ngkíq án amứh ntốq dỡq chữong ki la Rê-hô-bôt. Chơ án pai neq: “Sanua Yiang Sursĩ táq yỗn hếq bữn ntốq la‑a lứq; chơ hếq cỡt sốc bữn ỡt tâng ntốq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Moâm ki, I-sac pỡq chu ntốq Bêr-si-ba ễn. ");
INSERT INTO bru_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Bữn muoi sadâu Yiang Sursĩ toâq sapáh cớp atỡng án neq: “Cứq la Yiang Sursĩ mpoaq mới sang. Chỗi ngcŏh ntrớu, yuaq cứq lứq ỡt cớp mới. Cứq yỗn mới bữn ŏ́c bốn, cớp cứq chuai tŏ́ng toiq mới yỗn cỡt clứng lứq, cỗ cứq ữq ngkíq chóq A-praham, la cũai táq ranáq cứq.” ");
INSERT INTO bru_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tâng ntốq ki I-sac táq muoi lám prông dŏq sang Yiang Sursĩ, cớp án ayứng dống aroâiq dŏq án ỡt. Tâng ntốq ki, máh cũai táq ranáq án píq muoi lám dỡq chữong. ");
INSERT INTO bru_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ma tỡ bữn dũn tễ ki, Abi-maléc pỡq tễ Kê-ar toâq pỡ I-sac; cớp bữn bar náq Ahu-sat cớp Phi-côl pỡq cớp án tê. Ahu-sat la cũai tĩeih Abi-maléc cớp Phi-côl la sốt nheq tahan Abi-maléc. ");
INSERT INTO bru_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I-sac blớh alới neq: “Cỗ nŏ́q anhia ma bữn toâq pỡ cứq? Tễ nhũang anhia kêt cứq, cớp anhia tuih yỗn cứq loŏh tễ anhia.” ");
INSERT INTO bru_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ma alới ta‑ỡi neq: “Hếq dáng raloaih lứq Yiang Sursĩ ỡt cớp achuaih. Ngkíq, sanua hếq yoc rathễ cớp achuaih. Hếq ễ táq tếc parkhán cớp achuaih. ");
INSERT INTO bru_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Hếq sễq achuaih parkhán neq: Tễ nâi chumát achuaih tỡ bữn táq muoi ramứh sâuq ntrớu chóq hếq, machớng hếq tỡ bữn táq sâuq tê chóq achuaih. Hếq khoiq sarũiq táq achuaih, cớp acláh yỗn achuaih pỡq ien khễ. Cớp sanua anhia khoiq bữn roap ŏ́c bốn tễ Yiang Sursĩ chơ.” ");
INSERT INTO bru_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","I-sac táq yỗn alới muoi pêl dŏq cha bũi; chơ alới nguaiq cha parnơi. ");
INSERT INTO bru_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Toâq poang tarưp alới tamỡ tễ cláih, cớp alới pruam rathễ parnơi. Moâm ki, I-sac satoâl alới chu, cớp alới chu ien khễ. ");
INSERT INTO bru_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tâng tangái ki, máh cũai táq ranáq yỗn I-sac toâq atỡng I-sac tễ máh dỡq chữong alới khoiq píq neq: “Hếq khoiq tamóh dỡq chơ.” ");
INSERT INTO bru_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I-sac amứh dỡq chữong ki la Si-ba. Toau toâq tangái nâi, ntốq ki noâng bữn ramứh Bêr-si-ba. ");
INSERT INTO bru_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Toâq Ê-sau bữn pỗn chít cumo, án ĩt lacuoi tễ tỗp Hêt, ramứh Yudit con Bê-ri. Ê-sau ĩt lacuoi canŏ́h tễ tỗp Hêt hỡ, ramứh Bat-mat con E-lôn. ");
INSERT INTO bru_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bar lám lacuoi Ê-sau táq yỗn mứt pahỡm I-sac cớp Rê-be-ca cỡt ngua lứq. ");
INSERT INTO bru_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Toâq I-sac thâu, moat án tỡ bữn hữm raloaih noâng. Án arô Ê-sau, con clúng án, yỗn toâq pỡ án. Cớp án atỡng Ê-sau neq: “Con ơi!” Ê-sau ta‑ỡi: “Ơq, mpoaq!” ");
INSERT INTO bru_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I-sac atỡng ễn neq: “Sanua cứq khoiq thâu chơ; cứq tỡ dáng tangái léq cứq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sanua, sễq mới ĩt tamĩang cớp sa-ŏ́h saráh, chơ pỡq chu ruang pán charán. ");
INSERT INTO bru_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Moâm ki mới thrũan sâiq táq ễm, máh cứq mác ễ cha, chơ dững yỗn cứq. Moâm ki, cứq ễ câu yỗn mới bữn ŏ́c bốn puai chớc con clúng dốq bữn. Cứq ễ câu yỗn mới nhũang cứq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma Rê-be-ca sâng I-sac atỡng Ê-sau con án ngkíq. Toâq Ê-sau pỡq chu ruang chuaq charán, ");
INSERT INTO bru_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rê-be-ca atỡng Yacốp, con án neq: “Cứq sâng mpoaq mới atỡng Ê-sau ai mới neq: ");
INSERT INTO bru_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Mới pỡq chuaq charán cruang, cớp thrũan táq cha yỗn ễm sâiq charán ki, chơ dững yỗn cứq cha. Moâm ki cứq câu sễq tễ Yiang Sursĩ yỗn mới bữn ŏ́c bốn máh chớc con clúng dốq bữn. Cứq ễ câu ngkíq nhũang cứq cuchĩt.’ ");
INSERT INTO bru_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Con ơi! Mới tamứng santoiq cứq mpiq atỡng yỗn samoât, nơ. ");
INSERT INTO bru_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mới pỡq ĩt bar lám mbễq tễ tỗp charán plứm o. Chơ cứq ễ táq cha yỗn ễm lứq yỗn mpoaq mới cha riang án dốq ễ cha. ");
INSERT INTO bru_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Moâm ki, mới dững sana nâi toâq pỡ mpoaq mới yỗn án cha. Vớt ki, án ễ câu yỗn mới bữn ŏ́c bốn máh con clúng dốq bữn, nhũang án cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yacốp ta‑ỡi Rê-be-ca, mpiq án neq: “Tỗ Ê-sau, ai cứq, bữn sóc muar sa‑ữi lứq; ma cứq bữn sóc muar bĩq sâng. ");
INSERT INTO bru_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ngcŏh lơ mpoaq satoaq tâng tỗ cứq, chơ án chanchớm cứq phếq án. Ngkíq, án tỡ bữn câu yỗn cứq bữn ŏ́c bốn máh con clúng dốq bữn; ma lứq samoât án câu yỗn cứq bữn ŏ́c bap.” ");
INSERT INTO bru_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma mpiq Yacốp ta‑ỡi neq: “Con ơi! Yỗn ŏ́c bap ki satooh pỡ ống cứq mpiq sâng. Sanua mới cóq trĩh parnai cứq mpiq ớn mới. Mới pỡq ĩt toâp mbễq yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ngkíq, Yacốp pỡq ĩt mbễq, cớp dững achu yỗn mpiq án. Chơ mpiq án táq cha sâiq ki yỗn ễm lứq, riang I-sac dốq ễ cha. ");
INSERT INTO bru_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Moâm ki Rê-be-ca ĩt tampâc o khong Ê-sau con clúng án, ca Ê-sau dŏq tâng dống mpiq án. Chơ án yỗn Yacốp con ralŏ́h án ễn tâc. ");
INSERT INTO bru_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Cớp án ĩt ngcâr mbễq chóq tâng atĩ cớp tâng tacong Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Moâm ki, án chiau yỗn Yacốp sana ễm lứq cớp bễng án khoiq thrũan yỗn. ");
INSERT INTO bru_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yacốp dững toâp pỡ mpoaq án, cớp pai neq: “Mpoaq cứq ơi!” I-sac ta‑ỡi: “Ơq, con! Mới la noau?” ");
INSERT INTO bru_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yacốp ta‑ỡi mpoaq án neq: “Cứq la Ê-sau, con clúng mpoaq. Cứq táq ĩn mpoaq ớn cứq táq. Sễq mơi mpoaq yuor cha sâiq charán cứq con chuaq bữn, dŏq mpoaq câu yỗn cứq con bữn ŏ́c bốn máh chớc con clúng dốq bữn.” ");
INSERT INTO bru_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma I-sac blớh loah án neq: “Con ơi! Nŏ́q mới pỡq pupán, ma chái lứq mới ramóh charán?” Yacốp ta‑ỡi neq: “Yiang Sursĩ ca mpoaq sang, án dững charán nâi toâq pỡ cứq.” ");
INSERT INTO bru_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Chơ I-sac táq ntỡng cớp Yacốp neq: “Con ơi! Sễq mới toâq cheq cứq mpoaq. Cứq ễ pupơr tỗ mới, yoc ễ dáng lứq, mới la Ê-sau con cứq ma tỡ bữn.” ");
INSERT INTO bru_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Chơ Yacốp toâq cheq I-sac, mpoaq án. I-sac pupơr tâng tỗ án, cớp pai: “Sưong mới ariang sưong Yacốp, ma bar lám atĩ mới ariang atĩ Ê-sau.” ");
INSERT INTO bru_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ngkíq I-sac tỡ bữn dáng pai Yacốp, yuaq bar lám atĩ án bữn sóc muar ariang atĩ Ê-sau, ai án, tê. Ngkíq, I-sac ễ câu yỗn Yacốp bữn ŏ́c bốn máh con clúng dốq bữn. ");
INSERT INTO bru_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ma I-sac blớh sĩa Yacốp neq: “Lứq samoât, mới la Ê-sau con cứq tỡ?” Yacốp ta‑ỡi neq: “Cứq lứq Ê-sau.” ");
INSERT INTO bru_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I-sac pai neq: “Sễq mới dững sana yỗn cứq mpoaq; cứq ễ cha sâiq charán mới chuaq bữn, chơ cứq câu yỗn mới bữn ŏ́c bốn máh con clúng dốq bữn.” Yacốp dững crơng sana ki toâq pỡ I-sac, cớp án dững dếh blŏ́ng hỡ yỗn I-sac nguaiq. ");
INSERT INTO bru_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Moâm ki, I-sac atỡng Yacốp neq: “Con ơi! Sanua mới sĩc cheq cứq, cớp hũn cứq.” ");
INSERT INTO bru_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yacốp sĩc amut cheq I-sac cớp hũn án. Tữ I-sac sâng phuom tễ tampâc Yacốp, án chớm pai Ê-sau con án, ngkíq án câu ŏ́c bốn neq: “Hỡi phuom tễ tỗ con cứq cỡt ariang hỡi phuom tễ ntốq tâng ruang ca Yiang Sursĩ yỗn sa‑ữi palâi aluang aloai dáh. ");
INSERT INTO bru_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Sễq Yiang Sursĩ yỗn dỡq latac tễ paloŏng sễng thớm nheq cutễq mới, dŏq amia máh saro, dếh bữn moang blŏ́ng chong tễ palâi nho hỡ. ");
INSERT INTO bru_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sễq yỗn máh tỗp cũai táq ranáq yỗn mới, cớp máh cruang cũai yám noap mới. Mới lứq cỡt sốt nheq sễm ai mới, cớp máh tŏ́ng toiq mpiq mới cucốh cucũoi mới tê. Khân cũai aléq pupap mới, ki sễq Yiang Sursĩ táq yỗn ŏ́c bap ki toâp toâq loah pỡ cũai ki. Khân cũai aléq pai ŏ́c bốn yỗn mới, ki sễq Yiang Sursĩ satốh ŏ́c bốn yỗn cũai ki tê.” ");
INSERT INTO bru_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Moâm I-sac câu yỗn Yacốp, chơ Yacốp loŏh tễ I-sac; ngkíq Ê-sau, ai án mbỡiq chu tễ pupán. ");
INSERT INTO bru_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Án táq cha crơng sana yỗn ễm, chơ án dững pỡ mpoaq án, cớp atỡng mpoaq án neq: “Mpoaq ơi! Mới yuor tacu cha sâiq charán cứq con chuaq bữn! Chơ mpoaq câu yỗn cứq con bữn ŏ́c bốn máh con clúng dốq bữn.” ");
INSERT INTO bru_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ma I-sac blớh án neq: “Mới la noau?” Ê-sau ta‑ỡi: “Cứq la Ê-sau, con clúng mới.” ");
INSERT INTO bru_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Toâq I-sac sâng ngkíq, tỗ chác án cỡt cangcoaih nheq, cớp án blớh neq: “Khân ngkíq, noau ca pỡq pupán charán, chơ aloŏh yỗn cứq mpoaq cha tễ adớh? Cứq khoiq cha moâm, cớp khoiq câu moâm chơ yỗn án bữn ŏ́c bốn máh con clúng dốq bữn. Ranáq ki khoiq moâm nheq chơ; án ki toâp lứq bữn roap ŏ́c bốn ki.” ");
INSERT INTO bru_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tữ Ê-sau sâng santoiq mpoaq án pai ngkíq, án u‑ỗi casang lứq, cớp sễq mpoaq án neq: “Mpoaq ơi! Sễq mpoaq câu ŏ́c bốn yỗn cứq con tê.” ");
INSERT INTO bru_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ma mpoaq án ta‑ỡi neq: “A‑ễm mới toâq phếq cứq, cớp tuoiq ĩt chơ ŏ́c bốn mới.” ");
INSERT INTO bru_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ê-sau pai ễn neq: “Pĩeiq chơ noau dŏq ramứh án la Yacốp; yuaq bar trỗ tâng nâi chơ án phếq cứq. Án khoiq cheng ĩt chớc cứq, ca con clúng dốq bữn. Ma sanua, án ĩt ễn ŏ́c bốn mpoaq yoc ễ yỗn cứq.” Chơ Ê-sau blớh mpoaq án neq: “Mpoaq tỡ bữn cayáiq dŏq ŏ́c bốn ntrớu yỗn cứq con tỡ?” ");
INSERT INTO bru_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","I-sac ta‑ỡi án neq: “Cứq khoiq yỗn a‑ễm mới cỡt ncháu mới, dếh cứq yỗn nheq máh sễm ai án táq ranáq yỗn án. Cứq yỗn án bữn saro cớp blŏ́ng chong tễ palâi nho sa‑ữi. Sanua ntrớu ễn cứq mpoaq têq táq yỗn mới?” ");
INSERT INTO bru_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma Ê-sau sễq tễ mpoaq án neq: “Mpoaq ơi! Mới bữn ống máh ki toâp tỡ ŏ́c bốn? Sễq mpoaq pai ŏ́c bốn yỗn cứq con nứng.” Moâm án pai ngkíq, án nhiam casang lứq. ");
INSERT INTO bru_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ngkíq I-sac, mpoaq án ta‑ỡi án neq: “Nỡ‑ra ntốq mới ỡt la ŏ́q cutễq thớm, tỡ têq amia saro sa‑ữi, cớp ŏ́q dỡq latac hỡ. ");
INSERT INTO bru_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ma mới bữn tamoong na dau, cớp mới táq ranáq yỗn a‑ễm mới, yỗn toau mới têq pũot aloŏh chíq raluang tễ tacong mới ca Yacốp cluang.” ");
INSERT INTO bru_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ngkíq, Ê-sau sâng ũan lứq Yacốp, cỗ tian mpoaq án khoiq câu yỗn Yacốp bữn ŏ́c bốn máh con clúng dốq bữn. Án chanchớm neq: “Tangái tanúh mpoaq cuchĩt cheq ễ toâq; moâm ki cứq ễ cachĩt chíq Yacốp.” ");
INSERT INTO bru_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ma tữ Rê-be-ca dáng Ê-sau con clúng án chanchớm ngkíq, án arô Yacốp con ralŏ́h án, cớp atỡng neq: “Nâi! Ê-sau ai mới, chanchớm ễ cachĩt chíq mới. ");
INSERT INTO bru_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Con ơi! Cóq mới táq ĩn parnai cứq mpiq atỡng. Cóq mới lúh chíq pỡ dống Laban, cũq mới ca ỡt pỡ ntốq Haran. ");
INSERT INTO bru_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ỡt cớp án yỗn toau ai mới tỡ bữn ũan mới noâng. ");
INSERT INTO bru_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Toâq án tỡ bữn sanhữ noâng ranáq mới khoiq táq, ki cứq mpiq ớn cũai pỡq atỡng yỗn mới chu loah. Cứq tỡ ễq anhia bar náq ma pứt muoi tangái.” ");
INSERT INTO bru_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rê-be-ca pai cớp I-sac neq: “Cứq sâng panguang tháng Ê-sau ĩt mansễm tễ tỗp Hêt táq lacuoi. Khân Yacốp ễn ĩt cũai tễ tỗp Hêt táq lacuoi, ki cứq tỡ rơi tamoong mŏ.” ");
INSERT INTO bru_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ngkíq I-sac arô Yacốp, câu yỗn án, cớp patâp án neq: “Mới chỗi ĩt mansễm tễ cruang Cana-an táq lacuoi. ");
INSERT INTO bru_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Cóq mới thrũan, chơ pỡq chu cruang Padan Aram toâq pỡ dống Be-thuol, achuaih muq mới. Mới cóq ĩt con mansễm Laban cũq mới dŏq táq lacuoi. ");
INSERT INTO bru_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Sễq Yiang Sursĩ Sốt Toâr Lứq yỗn mới bữn ŏ́c bốn sa‑ữi, cớp yỗn mới cỡt clứng lứq, dŏq anhia cỡt sa‑ữi tỗp cũai. ");
INSERT INTO bru_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Sễq án yỗn mới cớp tŏ́ng toiq mới bữn nheq ramứh án khoiq par‑ữq cớp A-praham tễ nhũang. Ngkíq mới bữn ndỡm cruang mới ỡt sanua, ariang Yiang Sursĩ khoiq ữq cớp A-praham.” ");
INSERT INTO bru_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Chơ I-sac ớn Yacốp loŏh tễ cruang ki, pỡq chu cruang Padan Aram ễn, toâq pỡ dống Laban cũq án. Laban la con samiang Be-thuol cũai Aram; cớp án la amiang Rê-be-ca, mpiq Yacốp cớp Ê-sau. ");
INSERT INTO bru_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ê-sau sâng noau pai I-sac khoiq câu ŏ́c bốn yỗn Yacốp, cớp yỗn Yacốp pỡq chu cruang Padan Aram, dŏq ĩt lacuoi pỡ cruang ki. Cớp Ê-sau sâng noau pai I-sac patâp Yacốp neq: “Chỗi ĩt mansễm tễ cruang Cana-an táq lacuoi.” ");
INSERT INTO bru_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Án dáng Yacốp trĩh parnai mpiq mpoaq, cớp pỡq chu cruang Padan Aram. ");
INSERT INTO bru_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ngkíq, Ê-sau dáng raloaih lứq I-sac mpoaq án tỡ bữn bũi cớp mansễm tễ cruang Cana-an; ");
INSERT INTO bru_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","chơ án pỡq chu dống It-ma-el con A-praham, cớp ĩt muoi lám lacuoi ễn, la con mansễm It-ma-el ramứh Ma-halat, amuaq Nê-bayôt. ");
INSERT INTO bru_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yacốp loŏh tễ Bêr-si-ba pỡq chu cruang Haran. ");
INSERT INTO bru_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tữ án toâq muoi ntốq dĩ ria rana, án tangứt yuaq moat mandang khoiq pât. Án ĩt muoi cốc tamáu táq racỗl, chơ sadâu ki án bếq tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Án rláu mpáu hữm ntruang tễ cutễq chỗn toâq paloŏng. Cớp án hữm ranễng Yiang Sursĩ chỗn sễng luloah tâng ntruang ki. ");
INSERT INTO bru_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Án hữm Yiang Sursĩ tayứng pỡng ntruang cớp pai neq: “Cứq la Yiang Sursĩ achúc achiac mới A-praham cớp mpoaq mới I-sac sang. Tâm cutễq mới bếq nâi, cứq ễ yỗn mới cớp tŏ́ng toiq mới ndỡm. ");
INSERT INTO bru_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nỡ‑ra, tŏ́ng toiq mới cỡt clứng ariang cutễq príl, tỡ bữn noau rơi ngih. Anhia cỡt pláh chũop dũ ntốq tâng cốc cutễq nâi, cớp dũ tỗp tâng cutễq nâi bữn ŏ́c bốn cỗ nhơ tễ tŏ́ng toiq mới. ");
INSERT INTO bru_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Cứq lứq ỡt cớp mới; chu léq mới pỡq, cứq pỡq chu ki tê. Cứq bán kĩaq mới, cớp dững mới chu loah pỡ cruang nâi. Cứq tỡ bữn táh mới toau cứq táq moâm nheq máh ranáq cứq khoiq par‑ữq cớp mới.” ");
INSERT INTO bru_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Toâq Yacốp tamỡ, án pai neq: “Lứq samoât, Yiang Sursĩ ỡt tâng ntốq nâi, ma cứq tỡ bữn dáng.” ");
INSERT INTO bru_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yacốp sâng ngcŏh cớp pai neq: “Ntốq nâi la o ễ ngcŏh lứq! Ntốq nâi la ntốq Yiang Sursĩ ỡt, cớp ntốq la ngoah toong paloŏng.” ");
INSERT INTO bru_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yacốp tamỡ tễ cláih; án ĩt tamáu án tacỗl, chơ ayứng táq ngôl. Moâm ki án tốh dỡq nsễng tâng pỡng tamáu ki, dŏq chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Án amứh ntốq ki Bet-el. Tễ nhũang, ntốq ki la ramứh Lusơ. ");
INSERT INTO bru_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Chơ Yacốp thễ dũan cớp Yiang Sursĩ neq: “Khân anhia lứq ỡt cớp cứq, cớp kĩaq cứq tâng rana cứq pỡq sanua, cớp yỗn cứq bữn sana cha cớp tampâc tâc, ");
INSERT INTO bru_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","toau toâq tangái cứq chu loah ien khễ pỡ dống mpoaq cứq, ki anhia lứq cỡt Yiang Sursĩ cứq níc. ");
INSERT INTO bru_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Cớp tamáu cứq ayứng yỗn cỡt ngôl nâi cỡt ntốq noau sang toam Yiang Sursĩ. Cớp dũ ramứh anhia yỗn cứq bữn, ki cứq sang loah pún muoi chít yỗn anhia.” ");
INSERT INTO bru_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yacốp pỡq toâq pỡ cruang cũq án coah angia mandang loŏh. ");
INSERT INTO bru_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Bo án toâq pỡ ki, án hữm muoi lám dỡq chữong ỡt tâng ruang, cớp bữn pái tỗp cữu ỡt cheq dỡq chữong ki. Máh charán ki dốq nguaiq dỡq tễ chữong nâi. Ma bữn tamáu côl catáng chíq tâng pỡng ngoah chữong. ");
INSERT INTO bru_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Toâq máh tỗp cữu rôm dũ nheq ntốq ki, cũai mantán coŏh cốc tamáu aloŏh tễ ngoah dỡq chữong dŏq yỗn cữu nguaiq. Moâm cữu nguaiq, alới catáng loah tamáu ngoah chữong. ");
INSERT INTO bru_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yacốp blớh cũai mantán cữu ki neq: “Sễm ai ơi! Anhia toâq tễ léq?” Alới ta‑ỡi: “Hếq toâq tễ Haran.” ");
INSERT INTO bru_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yacốp blớh alới ễn: “Anhia dáng tỡ bữn cũai ramứh Laban, châu Nahor?” Alới ta‑ỡi: “Hếq dáng án.” ");
INSERT INTO bru_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Chơ Yacốp blớh ễn: “Án bán sũan tỡ?” Alới ta‑ỡi: “Ơq! Án bán sũan ien khễ. Anhia nhêng chu tíh. Rachel con mansễm Laban cớp cữu án toâq pỡ ki.” ");
INSERT INTO bru_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yacốp pai neq: “Sanua nâi, paloŏng noâng poang, tỡ yũah toâq ngư pong charán chu dống. Nŏ́q anhia tỡ bữn ŏh dỡq yỗn cữu anhia nguaiq voai. Moâm ki anhia cuvêq chu ntốq chuaq cha.” ");
INSERT INTO bru_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tỗp cũai ki ta‑ỡi Yacốp neq: “Hếq tỡ têq táq ngkíq. Cóq coan máh tỗp cữu parỗm dũ nheq voai. Moâm ki, hếq têq coŏh tamáu aloŏh tễ ngoah chữong, chơ ŏh dỡq yỗn cữu nguaiq.” ");
INSERT INTO bru_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Bo Yacốp noâng táq ntỡng cớp cũai mantán ki, Rachel toâq cớp tỗp cữu mpoaq án, yuaq án la cũai bán kĩaq cữu ki. ");
INSERT INTO bru_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tữ Yacốp hữm Rachel con mansễm Laban cũq án, cớp cữu Laban, ngkíq án coŏh tamáu tễ ngoah dỡq chữong, cớp án yỗn cữu cũq án nguaiq. ");
INSERT INTO bru_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Chơ Yacốp hũn Rachel cớp án nhiam, cỗ án sâng ỡn lứq. ");
INSERT INTO bru_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yacốp atỡng Rachel neq: “Cứq la sễm ai mpoaq mới; mpiq cứq la Rê-be-ca.” Toâq Yacốp pai ngkíq, Rachel lúh chu atỡng mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tữ Laban sâng con án atỡng tễ Yacốp, la con amuaq án, ngkíq án lúh pỡq ramóh Yacốp. Laban kĩau Yacốp, cớp hũn hĩt. Chơ án dững Yacốp chu pỡ dống án. Ỡt ntốq ki Yacốp atỡng Laban nheq máh ramứh tễ dống sũ án. ");
INSERT INTO bru_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Cớp Laban atỡng Yacốp neq: “Lứq samoât, mới la sễm ai cứq.” Ngkíq, Yacốp ỡt cớp Laban nheq muoi casâi. ");
INSERT INTO bru_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Moâm ki, Laban atỡng Yacốp neq: “Mới la sễm ai cứq lứq, ma tỡ pĩeiq mới táq miat sâng ranáq yỗn cứq. Sanua mới atỡng cứq, maléq mới yoc ễ bữn práq cóng tễ ranáq mới táq.” ");
INSERT INTO bru_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban bữn bar lám con mansễm. Lê-a la ỡi; Rachel la a‑ễm. ");
INSERT INTO bru_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lê-a bữn moat ieuq. Ma Rachel la cũai nêuq cớp bữn thán riang o. ");
INSERT INTO bru_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ngkíq Yacốp ayooq Rachel cớp án atỡng Laban neq: “Cứq táq ranáq yỗn mới nheq tapul cumo, khân mới yỗn cứq ĩt Rachel con ralŏ́h mới.” ");
INSERT INTO bru_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ta‑ỡi neq: “Ŏ́c ki o; khaq cứq yỗn mới ĩt táq lacuoi, saláng yỗn án ỡt cớp samiang canŏ́h. O lứq mới ỡt cớp cứq.” ");
INSERT INTO bru_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yuaq ngkíq, Yacốp táq ranáq yỗn Laban nheq tapul cumo, cỗ án ễ bữn niang Rachel táq lacuoi. Tapul cumo vớt chái lứq, ariang pai bar pái tangái sâng yỗn Yacốp, cỗ án ayooq lứq Rachel. ");
INSERT INTO bru_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Vớt tapul cumo, Yacốp atỡng Laban neq: “Panát par‑ữq hái pruam khoiq nheq chơ, sanua sễq cũq yỗn cứq bữn lacuoi, dŏq cứq têq ỡt cớp án.” ");
INSERT INTO bru_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ngkíq Laban thrũan rabễng yỗn con án. Án mơi nheq tữh cũai tâng vil, yỗn toâq rôm nguaiq cha bũi. ");
INSERT INTO bru_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ma toâq sadâu, Laban dững Lê-a con mansễm án atoâq pỡ Yacốp, chơ Yacốp bếq cớp Lê-a. ");
INSERT INTO bru_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Cớp Laban yỗn amŏq Sil-pa dŏq táq ranáq yỗn Lê-a. ");
INSERT INTO bru_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Toâq poang tarưp Yacốp hữm niang Lê-a, tỡ cỡn niang Rachel. Ngkíq Yacốp atỡng Laban neq: “Nŏ́q anhia táq chóq hếq nneq? Hếq táq ranáq yỗn anhia nheq tapul cumo, cỗ hếq ễ bữn Rachel táq lacuoi? Nŏ́q anhia phếq hếq?” ");
INSERT INTO bru_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ta‑ỡi neq: “Rit tâng cruang hếq, a‑ễm tỡ têq ĩt cayac nhũang ỡi. Sanua cóq anhia ỡt acoan tapul tangái voai, ki nŏ́q hếq chiau Rachel yỗn anhia tê, ");
INSERT INTO bru_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","khân anhia táq ranáq yỗn hếq tapul cumo ễn.” ");
INSERT INTO bru_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yacốp táq ariang Laban pai. Án táq moâm tapul tangái puai phễp rit rabễng cớp Lê-a. Moâm ki, Laban yỗn Rachel ễn. ");
INSERT INTO bru_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban yỗn amŏq Bil-ha hỡ dŏq táq ranáq yỗn Rachel. ");
INSERT INTO bru_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ngkíq Yacốp bếq cớp Rachel, cớp án ayooq Rachel hỡn tễ Lê-a. Chơ án táq ranáq yỗn Laban nheq tapul cumo ễn. ");
INSERT INTO bru_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yiang Sursĩ hữm Yacốp ayooq Lê-a bĩq sâng. Ngkíq, án yỗn Lê-a bữn con. Ma Rachel cỡt cũai cũt. ");
INSERT INTO bru_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lê-a ỡt mumiaq, chơ án canỡt muoi lám con samiang; án amứh Ruben, yuaq án pai neq: “Yiang Sursĩ dáng cayac cứq tỡ bữn ayooq cứq. Sanua cayac cứq lứq ayooq cứq tê.” ");
INSERT INTO bru_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Vớt ki Lê-a ỡt mumiaq sĩa, cớp án canỡt con samiang ễn. Chơ án pai neq: “Yiang Sursĩ bữn sâng pai noau kêt cứq. Ngkíq, án yỗn cứq bữn con samiang ễn.” Lê-a amứh con ki la Si-mê-ôn. ");
INSERT INTO bru_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Dũn tễ ki Lê-a ỡt mumiaq ễn. Án canỡt con samiang sĩa, cớp án pai neq: “Sanua cayac cứq cỡt muoi mứt cớp cứq, yuaq cứq khoiq canỡt pái lám con samiang yỗn án chơ.” Ngkíq, án amứh con samiang ki la Lê-vi. ");
INSERT INTO bru_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Chơ dũn tễ ki, Lê-a ỡt mumiaq sĩa. Án canỡt con samiang ễn. Cớp án pai neq: “Trỗ nâi cứq ễ khễn Yiang Sursĩ.” Ngkíq, án amứh con ki la Yuda. Chơ tễ ki án tangứt táq ramia voai. ");
INSERT INTO bru_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tữ Rachel dáng án tỡ bữn bữn con; ngkíq án sa‑on tễ ỡi án. Chơ án atỡng Yacốp neq: “Sễq mới yỗn cứq bữn con tê. Khân tỡ bữn ngkíq, cứq yoc ễ cuchĩt chíq.” ");
INSERT INTO bru_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yacốp nhôp Rachel, cớp pai neq: “Nŏ́q cứq têq pláih chớc Yiang Sursĩ tỡ yỗn mới bữn con tỡ? Bữn Yiang Sursĩ toâp yỗn mới cỡt cũt.” ");
INSERT INTO bru_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel atỡng Yacốp neq: “Nâi la Bil-ha, mansễm táq ranáq yỗn cứq; o mới bếq cớp án, yỗn án têq canỡt con yỗn cứq bán.” ");
INSERT INTO bru_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ngkíq Rachel chiau Bil-ha yỗn Yacốp táq lacuoi. Chơ Yacốp bếq cớp Bil-ha. ");
INSERT INTO bru_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bil-ha ỡt mumiaq, cớp án canỡt muoi lám con samiang yỗn Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ngkíq, Rachel pai neq: “Yiang Sursĩ rasữq pĩeiq lứq tễ ranáq cứq. Án sâng sưong cứq câu, cớp án yỗn cứq bữn muoi lám con samiang tê.” Chơ án amứh con ki la Dan. ");
INSERT INTO bru_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bil-ha, la cũai táq ranáq yỗn Rachel, ỡt mumiaq sĩa; cớp án canỡt muoi lám con samiang ễn yỗn Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Chơ Rachel pai neq: “Cứq khoiq tampling cớp ỡi cứq, ma cứq riap chơ.” Ngkíq, án amứh con samiang ki la Nep-tali. ");
INSERT INTO bru_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tữ Lê-a dáng án tỡ bữn canỡt noâng con, ngkíq án yỗn Sil-pa, la cũai táq ranáq yỗn án, yỗn cỡt lacuoi Yacốp tê. ");
INSERT INTO bru_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Chơ Sil-pa canỡt muoi noaq con samiang yỗn Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lê-a pai neq: “Ŏ́c o lứq toâq pỡ cứq.” Ngkíq, án amứh con samiang ki la Cát. ");
INSERT INTO bru_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Chơ Sil-pa canỡt muoi lám con samiang sĩa yỗn Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lê-a pai neq: “Cứq bữn ŏ́c bũi lứq; sanua tỗp mansễm ca hữm cứq pai cứq bũi lứq.” Ngkíq, án amứh con samiang ki la Asêr. ");
INSERT INTO bru_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Toâq muo noau susot, Ruben loŏh pỡ ruang ramóh muoi thữ palâi ca chuai yỗn cũai cũt bữn loah con. Ngkíq án dững achu palâi ki yỗn Lê-a, mpiq án. Chơ Rachel sễq tễ Lê-a neq: “Sễq mới yỗn cứq nứng palâi con samiang mới achu ki.” ");
INSERT INTO bru_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma Lê-a ta‑ỡi Rachel neq: “Nŏ́q mới cheng ĩt cayac cứq, noâng yũah dũ tỡ? Sanua mới noâng ễ bữn ễn palâi tễ con cứq dững achu.” Ma Rachel ta‑ỡi neq: “Khân mới yỗn cứq bữn palâi con mới dững achu, sadâu nâi cứq yỗn cayac hái pỡq bếq cớp mới.” ");
INSERT INTO bru_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Toâq tabữ, bo Yacốp chu tễ sarái, Lê-a pỡq ramóh án, cớp atỡng án neq: “Sadâu nâi cóq mới bếq cớp cứq, yuaq cứq khoiq yỗn Rachel palâi con samiang cứq dững achu. Rachel khoiq pruam cớp cứq.” Chơ sadâu ki Yacốp bếq cớp Lê-a. ");
INSERT INTO bru_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Yiang Sursĩ sâng máh santoiq Lê-a câu. Chơ Lê-a ỡt mumiaq loah, cớp canỡt con samiang yỗn Yacốp sĩa. Nâi la con lám sỡng Lê-a canỡt. ");
INSERT INTO bru_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Chơ Lê-a pai neq: “Yiang Sursĩ yỗn cứq bữn roap cóng chơ, cỗ cứq khoiq yỗn mansễm táq ranáq cứq cỡt lacuoi cayac cứq.” Ngkíq, án amứh con samiang ki la I-sacar. ");
INSERT INTO bru_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Vớt ki Lê-a ỡt mumiaq sĩa, án canỡt con samiang ễn yỗn Yacốp. Chơ Lê-a bữn tapoât náq con samiang cớp Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Chơ Lê-a pai neq: “Yiang Sursĩ yỗn cứq bữn muoi ramứh moat lứq. Trỗ nâi cayac cứq ễ yám noap cứq, cỗ cứq khoiq canỡt con samiang yỗn án tapoât náq chơ.” Ngkíq, án amứh con ki la Sa-bulôn. ");
INSERT INTO bru_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Vớt ki Lê-a canỡt muoi lám con mansễm ễn, ramứh Di-na. ");
INSERT INTO bru_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Chơ Yiang Sursĩ sanhữ loah Rachel, cớp án sâng parnai Rachel câu, chơ án táq yỗn Rachel tỡ bữn cũt noâng. ");
INSERT INTO bru_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rachel ỡt mumiaq, cớp canỡt muoi lám con samiang. Án pai neq: “Yiang Sursĩ khoiq táq yỗn cứq tỡ bữn casiet táq noâng.” ");
INSERT INTO bru_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rachel amứh con samiang ki la Yô-sep, cớp án pai neq hỡ: “Sễq Yiang Sursĩ yỗn cứq bữn muoi lám con samiang ễn.” ");
INSERT INTO bru_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Toâq moâm Rachel canỡt Yô-sep, Yacốp pỡq atỡng Laban neq: “Sanua sễq anhia yỗn hếq píh chu loah pỡ vil viang hếq ỡt tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Hếq khoiq táq ranáq yỗn anhia dũn lứq chơ; sanua hếq ễ dững nheq máh con lacuoi hếq chu. Anhia dáng chơ tễ máh ranáq hếq táq yỗn anhia.” ");
INSERT INTO bru_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ma Laban ta‑ỡi Yacốp neq: “Khân anhia lứq ayooq hếq, ki hếq sễq anhia ỡt cớp hếq voai. Cỗ hếq khoiq mưl chơ, hếq dáng Yiang Sursĩ yỗn hếq bữn ŏ́c bốn cỗ nhơ tễ anhia. ");
INSERT INTO bru_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Sanua anhia tếng maléq práq cóng anhia ễ bữn, chơ hếq yỗn.” ");
INSERT INTO bru_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yacốp ta‑ỡi án neq: “Anhia dáng chơ hếq khoiq chuai ranáq yỗn anhia, cớp charán anhia rứh sa‑ữi cỗ hếq bán. ");
INSERT INTO bru_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tễ nhũang, anhia bữn charán bĩq sâng; ma tữ hếq bán charán anhia, cỡt rứh sa‑ữi lứq. Pỡ léq hếq pỡq, ŏ́c bốn tễ Yiang Sursĩ puai hếq pỡ ki. Ma sanua, hếq yoc ễ bữn crơng crớu dŏq chứm siem con lacuoi hếq tê.” ");
INSERT INTO bru_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban blớh án neq: “Ntrớu o hếq yỗn anhia?” Yacốp ta‑ỡi: “Anhia tỡ bữn túh yỗn hếq ntrớu. Ma khân anhia pruam muoi ramứh, ki hếq noâng rabán charán anhia. ");
INSERT INTO bru_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tangái nâi hếq pỡq nhêng máh tỗp charán. Chơ hếq cayoah máh cữu clor, cữu chĩr, cớp cữu cũm. Cớp hếq cayoah máh mbễq clor, cớp chĩr hỡ. Nheq tữh charán ki cỡt cóng hếq. ");
INSERT INTO bru_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Parnỡ pra têq anhia pỡq nhêng máh ranáq hếq táq, tanoang chóq anhia ma tỡ bữn. Khân anhia tamóh mbễq tỡ bữn clor cớp chĩr, tỡ la cữu tỡ bữn cũm, ki têq anhia pai máh charán ki cỡt charán hếq tuoiq.” ");
INSERT INTO bru_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ta‑ỡi: “Lứq pĩeiq máh santoiq anhia pai. Pĩeiq anhia táq ngkíq.” ");
INSERT INTO bru_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ma tangái ki toâp, Laban cayoah nheq máh mbễq tangcáh clor tỡ la chĩr, cớp máh mbễq sang‑ỗng bữn sóc cloc bĩq. Cớp án cayoah máh cữu cũm hỡ. Chơ án cơiq máh charán ki pỡ máh con samiang án. ");
INSERT INTO bru_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Chơ Laban loŏh tễ Yacốp, cớp án pỡq yơng pái tangái. Ma Yacốp noâng ỡt bán charán pún Laban. ");
INSERT INTO bru_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ntun ki Yacốp ĩt pái thữ aluang, ntreh ca bữn ndŏh cũm, ma tâng clống ki cloc. Chơ án loât pachĩr ndŏh cũm yỗn cỡt cloc. ");
INSERT INTO bru_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Chơ Yacốp dŏq aluang ki choâng moat máh charán pỡ ntốq án nguaiq dỡq tâng tapuang. Tữ charán ki ramoâng, án hữm aluang ki; ");
INSERT INTO bru_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","toâq án roah con, con ki cỡt clor cớp chĩr. Ma con cữu cớt, Yacốp cayoah yỗn ỡt ntốq miar, yỗn án nhêng chu tỗp charán Laban ca clor cớp cũm. ");
INSERT INTO bru_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yacốp cayoah tỗp cữu sang‑ỗng tễ tỗp charán khong Laban. Toâq charán ramoâng, án yỗn ỡt cheq-racheq charán chĩr cớp cũm ca noâng tâng tỗp charán khong Laban dŏq yỗn roah con cỡt chĩr cớp cũm. Táq ngkíq án ễq yỗn charán khong án cỡt rứh sa‑ữi; chơ án dŏq miar tễ charán khong Laban. ");
INSERT INTO bru_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Toâq charán plứm o ramoâng, Yacốp yỗn nhêng chu aluang án pachĩr, chơ charán ki roah con chĩr tũoiq loah aluang ki. ");
INSERT INTO bru_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma charán ieuq, Yacốp tỡ bữn chóq aluang ki. Yuaq ngkíq, charán ieuq cỡt khong Laban; ma charán rêng cỡt khong án. ");
INSERT INTO bru_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Chơ Yacốp cỡt sốc lứq; án bữn charán sa‑ữi lứq. Án bữn sa‑ữi náq táq ranáq yỗn án, dếh mansễm dếh samiang, cớp án bữn charán lac‑da cớp aséh dễn la sa‑ữi lứq tê. ");
INSERT INTO bru_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yacốp sâng noau pai máh con samiang Laban atỡng neq: “Yacốp khoiq ĩt nheq máh mun mpoaq hái. Cỗ nhơ tễ mun mpoaq hái án cỡt sốc bữn.” ");
INSERT INTO bru_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Cớp Yacốp hữm mứt pahỡm Laban, cũq án, tỡ bữn noâng riang tễ tangái nhũang. ");
INSERT INTO bru_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Chơ Yiang Sursĩ atỡng Yacốp neq: “Mới chu loah pỡ cruang achúc achiac cớp sâu mới. Cứq ễ pỡq cớp mới.” ");
INSERT INTO bru_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ngkíq Yacốp ớn noau arô Rachel cớp Lê-a toâq pỡ ruang charán án ỡt. ");
INSERT INTO bru_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yacốp atỡng bar náq ki neq: “Cứq dáng lứq, mpoaq anhia bữn mứt pahỡm tỡ bữn o noâng chóq cứq riang tễ nhũang. Ma toau sanua, Yiang Sursĩ mpoaq cứq sang ỡt níc cớp cứq. ");
INSERT INTO bru_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Anhia dáng lứq tê, nheq rangứh rahỡ cứq táq ranáq yỗn mpoaq anhia, ");
INSERT INTO bru_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ma noâng án lôp cứq sa‑ữi trỗ na án palớt tứng-atooc cóng cứq. Ma Yiang Sursĩ tỡ yỗn án táq ngkíq chóq cứq. ");
INSERT INTO bru_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Khân mpoaq anhia pai charán chĩr cỡt pún cứq, ki máh charán ki la chĩr nheq. Khân mpoaq anhia pai máh charán clor cỡt pún cứq, ki máh charán ki la clor nheq. ");
INSERT INTO bru_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ngkíq Yiang Sursĩ khoiq ĩt máh charán mpoaq anhia, chơ yỗn cứq ễn. ");
INSERT INTO bru_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Bữn muoi trỗ, toâq ngư máh charán ramoâng, cứq rláu mpáu. Tâng rláu mpáu ki cứq hữm mbễq tangcáh clor cớp chĩr ỡt ramoâng cớp mbễq sang‑ỗng. ");
INSERT INTO bru_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tâng parnáu ki, cứq hữm ranễng Yiang Sursĩ atỡng cứq neq: ‘Yacốp ơi!’ “Cứq ta‑ỡi: ‘Ơq! Cứq ỡt nnâi.’ ");
INSERT INTO bru_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Ranễng ki atỡng cứq neq: ‘Mới tapoang achỗn. Cứq táq yỗn máh mbễq tangcáh clor cớp chĩr ramoâng cớp mbễq sang‑ỗng, yuaq cứq dáng tễ ranáq Laban táq chóq mới. ");
INSERT INTO bru_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Cứq la Yiang Sursĩ ca khoiq ramóh mới tâng ntốq Bet-el. Ntốq ki mới khoiq tốh dỡq nsễng tâng ngôl dŏq cỡt tếc chiau sang yỗn cứq, chơ mới parkhán muoi ramứh cớp cứq. Sanua cóq mới thrũan, cớp loŏh toâp tễ cruang nâi chu loah pỡ cruang mpiq mới canỡt mới.’” ");
INSERT INTO bru_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Moâm Yacốp pai ngkíq, Rachel cớp Lê-a pai neq: “Hái tỡ bữn ngcuang roap noâng mun tễ mpoaq hái. ");
INSERT INTO bru_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mpoaq hái nhêng chu hái la nŏ́q cũai tamoi toâq tễ cruang canŏ́h; khoiq án chếq chơ hái, cớp án phŏ́ng talốh nheq máh práq ki. ");
INSERT INTO bru_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dũ ramứh Yiang Sursĩ khoiq ĩt tễ mpoaq hái, ki cỡt khong hái cớp con hái. Sanua dũ ranáq Yiang Sursĩ khoiq ớn mới táq, ki mới táq.” ");
INSERT INTO bru_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Moâm alới pai ngkíq, Yacốp thrũan pỡq chu I-sac mpoaq án, pỡ cruang Cana-an. Án acŏ́q máh con lacuoi án tâng cloong charán lac‑da. Cớp án dững nheq tữh máh crơng crớu, dếh máh charán án mbỡiq bữn tâng Padan Aram hỡ. ");
INSERT INTO bru_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Bo ki Laban loŏh cứt sóc cữu, chơ Rachel tuoiq rup yiang khong mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma Yacốp rathũ Laban, la cũai Aram, na án pỡq luoiq, tỡ bữn yỗn Laban dáng án ễ pỡq. ");
INSERT INTO bru_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Chơ Yacốp cớp nheq dống sũ án lúh loŏh tễ cruang ki; alới yang crỗng Ơ-phơ-rat, ễ pỡq chu máh dũal cớp cóh cruang Ki-liat. ");
INSERT INTO bru_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Catâm tangái pái, bữn cũai toâq atỡng Laban tễ Yacốp khoiq pỡq luoiq. ");
INSERT INTO bru_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ngkíq Laban dững sễm ai án rapuai loah Yacốp. Alới pỡq nheq tapul tangái, chơ satỡm Yacốp tâng máh dũal cớp cóh cruang Ki-liat. ");
INSERT INTO bru_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tâng sadâu ki, Yiang Sursĩ toâq pỡ Laban na rláu mpáu, chơ atỡng Laban, cũai Aram, neq: “Mới chỗi pai muoi ŏ́c ntrớu chóq Yacốp, o tỡ la tỡ o.” ");
INSERT INTO bru_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yacốp khoiq ayứng dống aroâiq tâng máh dũal cớp cóh cruang Ki-liat; ma Laban cớp máh sễm ai án ayứng dống aroâiq tâng cóh ki tê. ");
INSERT INTO bru_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban pai chóq Yacốp neq: “Nŏ́q mới lôp cứq, cớp parỗn con mansễm cứq, táq ariang noau cớp cũai bo rachíl? ");
INSERT INTO bru_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nŏ́q mới loŏh luoiq cớp tỡ bữn atỡng yỗn cứq dáng? Khân cứq dáng, ki cứq táq pêl cha bũi yỗn mới pỡq, na triau cacháng, ũat, cớp plóng crơng lampỡiq hỡ. ");
INSERT INTO bru_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nŏ́q mới tỡ bữn yỗn cứq bữn hũn máh châu cớp con mansễm cứq, dŏq cubán alới? Táq nneq mới khoiq táq ranáq sacũl lứq. ");
INSERT INTO bru_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Cứq bữn chớc têq táq mới. Ma sadâu hái, Yiang Sursĩ achúc achiac mới sang atỡng cứq neq: ‘Mới chỗi pai muoi ŏ́c ntrớu chóq Yacốp, o tỡ la tỡ o chóq Yacốp.’ ");
INSERT INTO bru_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Cứq dáng mới loŏh la cỗ mới yoc ễ chu loah pỡ cruang mpiq mpoaq mới, ma cỗ nŏ́q mới tuoiq ĩt rup yiang dống cứq?” ");
INSERT INTO bru_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yacốp ta‑ỡi neq: “Cứq ngcŏh lứq, yuaq cứq chanchớm anhia ễ ĩt loah con mansễm anhia. ");
INSERT INTO bru_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ma tễ rup yiang anhia, ki anhia chuaq; khân anhia ramóh tâng tỗ cũai aléq, cũai ki cóq chĩuq cuchĩt. Nheq máh sễm ai hái ca ỡt bân ntốq nâi pruam hữm nheq tê; khân anhia tamóh crơng anhia, ki anhia ĩt.” Ma Yacốp tỡ bữn dáng pai Rachel tuoiq ĩt rup yiang ki. ");
INSERT INTO bru_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ngkíq Laban mut tâng dống aroâiq Yacốp, cớp dống aroâiq Lê-a. Án mut tâng bar lám dống aroâiq mansễm táq ranáq alới. Ma án tỡ bữn tamóh ntrớu tâng dống ki. Chơ án loŏh tễ dống Lê-a, mut tâng dống Rachel ễn. ");
INSERT INTO bru_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Rachel khoiq cutooq dŏq rup yiang án tuoiq ĩt ki tâng clống racu lac‑da, chơ án tacu tâng pỡng. Laban chi-chuaq dũ ntốq tâng dống ki ma án tỡ tamóh. ");
INSERT INTO bru_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel pai cớp mpoaq án neq: “Cứq con sễq mpoaq táh lôih cứq tỡ bữn têq tayứng, yuaq cứq miaq toâq prêng.” Moâm nheq Laban chuaq, ma án tỡ tamóh rup yiang dống án. ");
INSERT INTO bru_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yacốp sâng nsóq mứt, chơ án rasuon cớp Laban neq: “Hếq táq lôih ntrớu chóq anhia, ma anhia rapuai hếq nneq? ");
INSERT INTO bru_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Anhia khoiq ravoât nheq tâng máh crơng crớu dống hếq. Anhia bữn ramóh ntrớu khong anhia tỡ? Choâng moat máh sễm ai hái bar coah, sễq anhia aloŏh crơng ki pỡ nâi yỗn alới sữq anhia cớp hếq. ");
INSERT INTO bru_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Hếq khoiq ỡt cớp anhia nheq bar chít cumo chơ, cớp bán charán yỗn anhia. Máh cumo ki, charán anhia tỡ bữn cỡt cupũn ntrớu. Dếh hếq tỡ nai cha muoi lám ntrớu tễ charán anhia. ");
INSERT INTO bru_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Khân bữn charán cruang cáp cuchĩt charán anhia, hếq tỡ nai dững achu charán ki yỗn anhia; ma hếq culáh loah yỗn anhia charán tễ pún hếq ễn. Khân noau tuoiq charán anhia, tangái tỡ la sadâu, ki anhia yỗn hếq tu. ");
INSERT INTO bru_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tâng tangái hếq chĩuq tiang phũac; tâng sadâu hếq chĩuq sangễt. Hếq ỡt trỗl ramỗih níc. ");
INSERT INTO bru_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Cớp nheq bar chít cumo nâi hếq ỡt tâng dống anhia, la ngkíq níc. Hếq táq ranáq yỗn anhia muoi chít la pỗn cumo, cỗ hếq yoc ễ bữn bar lám con mansễm anhia. Cớp tapoât cumo ễn hếq táq ranáq yỗn anhia cỗ hếq yoc ễ bữn charán. Ma anhia palớt tứng-atooc cóng hếq muoi chít trỗ. ");
INSERT INTO bru_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Khân Yiang Sursĩ achúc achiac hếq A-praham cớp I-sac sang ma tỡ bữn rachuai, ngkíq anhia khoiq ễ tuih hếq yỗn pỡq miat tễ dống anhia. Ma Yiang Sursĩ khoiq hữm ŏ́c túh hếq chĩuq. Ngkíq yuaq, Yiang Sursĩ sưoq anhia tâng sadâu hái.” ");
INSERT INTO bru_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Chơ Laban ta‑ỡi Yacốp neq: “Con mansễm nâi la con hếq; máh carnễn nâi la châu hếq; cớp nheq tữh charán nâi la charán hếq. Nheq máh crơng anhia hữm la khong hếq nheq. Ma sanua, ntrớu hếq têq táq yỗn máh con cớp châu hếq? ");
INSERT INTO bru_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Sanua cóq hái parkhán parnơi, cóq anhia cớp hếq pruam táq tếc parkhán parnơi.” ");
INSERT INTO bru_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ngkíq Yacốp ĩt tamáu, chơ án ayứng táq ngôl. ");
INSERT INTO bru_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Cớp án pai chóq sễm ai án neq: “Anhia tỗiq ĩt tamáu dững pỡ nâi!” Ngkíq sễm ai án tỗiq cớp dững cróh tamáu ki muoi ntốq; chơ alới cha pêl bũi parnơi cheq cantróh tamáu ki. ");
INSERT INTO bru_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban amứh ntốq ki la Yê-ca Saha-duta; ma Yacốp amứh ntốq ki la Calit. ");
INSERT INTO bru_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban pai neq: “Tangái nâi, cantróh tamáu nâi cỡt tếc anhia cớp hếq parkhán parnơi.” Yuaq ngkíq alới dŏq ntốq ki la Calit. ");
INSERT INTO bru_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Cớp ntốq ki bữn ramứh Mit-ba hỡ; cỗ Laban pai neq: “Yiang Sursĩ ỡt nhêng anhia cớp hếq, toâq hái ỡt miar ntốq. ");
INSERT INTO bru_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Khân anhia dững túh con mansễm hếq, tỡ la ĩt lacuoi tamái ễn, tam tỡ bữn noau nhêng salĩq, ma cóq anhia sanhữ, lứq bữn Yiang Sursĩ toâp nhêng níc anhia cớp hếq.” ");
INSERT INTO bru_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban atỡng Yacốp ễn neq: “Anhia nhêng chu cantróh tamáu cớp ngôl tamáu nâi, hếq khoiq chóh dŏq tâng mpứng dĩ anhia cớp hếq. ");
INSERT INTO bru_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Cantróh tamáu cớp ngôl tamáu nâi cỡt tếc yỗn hếq tỡ têq luat tễ ntốq nâi pỡq rachíl anhia, cớp anhia tỡ têq luat tễ ntốq nâi pỡq rachíl hếq. ");
INSERT INTO bru_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Sễq Yiang Sursĩ achuaih anhia A-praham sang cớp achuaih cứq Nahor sang rasữq anhia cớp hếq.” Chơ Yacốp thễ dũan nhơ ramứh Yiang Sursĩ mpoaq án I-sac sang. ");
INSERT INTO bru_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yacốp kiac charán dŏq sang yỗn Yiang Sursĩ tâng cruang cóh ki, cớp án mơi nheq tữh sễm ai án toâq cha parnơi. Moâm alới cha, chơ alới bếq loâng ngki tâng sadâu ki. ");
INSERT INTO bru_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban tamỡ tễ cláih. Án hũn máh châu cớp con mansễm án. Cớp án câu yỗn alới bữn ŏ́c bốn hỡ. Moâm ki án loŏh tễ alới, píh chu loah pỡ dống án. ");
INSERT INTO bru_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Bo Yacốp pỡq tâng rana, bữn tỗp ranễng Yiang Sursĩ toâq pỡ án. ");
INSERT INTO bru_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Toâq Yacốp hữm tỗp ranễng ki, án pai neq: “Nâi la ntốq Yiang Sursĩ ỡt.” Ngkíq án amứh ntốq ki la Maha-nêm. ");
INSERT INTO bru_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yacốp ớn cũai pỡq nhũang dững parnai án toâq pỡ Ê-sau, ai án, tâng cruang Ê-dôm, ntốq Sêr. ");
INSERT INTO bru_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yacốp patâp cũai ki neq: “Cóq anhia pỡq atỡng Ê-sau, ncháu cứq, neq: ‘Yacốp cũai táq ranáq anhia khoiq pai neq: Cứq ỡt pỡ dống Laban toau toâq tangái nâi. ");
INSERT INTO bru_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Cứq bữn tỗp ntroŏq, aséh dễn, cữu, cớp mbễq; dếh bữn máh cũai mansễm cớp samiang táq ranáq cứq hỡ. Sanua cứq cơiq crơng nâi yỗn ncháu cứq, dŏq ncháu cỡt bũi pahỡm cớp cứq.’” ");
INSERT INTO bru_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Cũai dững parnai ki chu atỡng Yacốp neq: “Hếq khoiq pỡq chu Ê-sau, ai mới; án yoc ễ ramóh mới, cớp án dững pỗn culám náq cũai samiang pỡq nứng án tê.” ");
INSERT INTO bru_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Moâm alới pai ngkíq, Yacốp sâng ngcŏh cớp croŏq lứq. Ngkíq án tampễq máh cũai pỡq nứng án cỡt bar tỗp, cớp tampễq máh charán, dếh cữu, mbễq, ntroŏq, cớp lac‑da hỡ. ");
INSERT INTO bru_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Án chanchớm neq: “Khân Ê-sau toâq pỡ muoi tỗp, chơ pupứt tỗp ki, noâng bữn muoi tỗp têq lúh vớt.” ");
INSERT INTO bru_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Chơ Yacốp câu neq: “Ơ Yiang Sursĩ ơi! Anhia la Yiang Sursĩ A-praham sang, cớp anhia la Yiang Sursĩ I-sac mpoaq cứq sang. Anhia toâp patâp cứq neq: ‘Cóq mới chu loah pỡ cruang bữm cớp sâu mới bữm, chơ cứq chuai mới.’ ");
INSERT INTO bru_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yiang Sursĩ ơi! Cứq, la cũai táq ranáq anhia, tỡ bữn pĩeiq yỗn anhia chuai níc cứq, cớp yỗn anhia táq máh ŏ́c anhia khoiq par‑ữq cớp cứq. Bo tangái cứq pỡq luat crỗng Yôr-dan, tangái ki cứq dững ống muoi ntreh ralỡng sâng. Ma sanua, cứq bữn cũai cỡt bar tỗp. ");
INSERT INTO bru_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Sễq anhia chuai amoong cứq yỗn vớt tễ atĩ Ê-sau ai cứq, yuaq cứq sâng ngcŏh, ngcŏh án toâq ễ cachĩt cứq cớp con lacuoi cứq. ");
INSERT INTO bru_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ma anhia khoiq pai chơ cớp cứq neq: ‘Cứq ễ táq o níc yỗn mới, cớp yỗn mới bữn tŏ́ng toiq cỡt clứng ĩn ŏ́c chũah, ca tỡ bữn noau rơi ngih.’” ");
INSERT INTO bru_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Moâm Yacốp câu, án bếq ntốq ki tâng sadâu ki, cớp thrũan máh charán yỗn Ê-sau, ai án. ");
INSERT INTO bru_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Máh charán ki la neq: Mbễq sang‑ỗng bar culám, mbễq tangcáh bar chít lám, cữu sang‑ỗng bar culám, cữu tôl bar chít lám, ");
INSERT INTO bru_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","lac‑da sang‑ỗng pái chít lám, cớp máh con lac‑da noâng pu tóh hỡ, ntroŏq sang‑ỗng pỗn chít lám, ntroŏq tangcáh muoi chít lám, aséh dễn cán bar chít lám, cớp aséh dễn tôl muoi chít lám. ");
INSERT INTO bru_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nheq tữh máh charán nâi Yacốp tampễq muoi tỗp pỡ nâi, muoi tỗp pỡ ki, chơ án ớn cũai táq ranáq án neq: “Anhia dững máh charán nâi pỡq nhũang cứq, muoi tỗp pỡq nhũang, muoi tỗp puai ntun, ma yỗn yơng-rayơng, yỗn cỡt huong mpứng dĩ.” ");
INSERT INTO bru_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yacốp ớn án ca pỡq nhũang neq: “Khân Ê-sau, ai cứq, tamóh mới cớp blớh neq: ‘Mới táq ranáq yỗn noau? Mới ễ pỡq chu léq? Cớp charán nâi la khong noau?’, ");
INSERT INTO bru_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","cóq mới ta‑ỡi án neq: ‘Nheq charán nâi la khong Yacốp, án ca táq ranáq anhia, dŏq mpon yỗn Ê-sau. Ma hỡn tễ ki, bữn Yacốp ễn toâq ntun hếq.’” ");
INSERT INTO bru_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Machớng ki tê Yacốp ớn alới ca dững tỗp charán bar, tỗp charán pái, cớp alới ca pỡq ntun hỡ, pai neq: “Toâq anhia tamóh Ê-sau cóq anhia atỡng machớng nheq, neq: ");
INSERT INTO bru_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Yacốp la cũai táq ranáq anhia, án toâq ntun.’” Yacốp pai ngkíq yuaq án chanchớm neq: “Cứq yỗn miat máh crơng nâi pỡq nhũang, dŏq sadal moat ai cứq, yỗn mứt án cỡt laviei toâq cứq ramóh án.” ");
INSERT INTO bru_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yuaq ngkíq, nheq máh ramứh mpon nâi pỡq nhũang, ma sadâu ki Yacốp noâng ỡt loah tâng dống aroâiq án. ");
INSERT INTO bru_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tâng sadâu ki Yacốp tamỡ, cớp án dững bar lám lacuoi án, dếh bar náq mansễm táq ranáq yỗn alới, cớp muoi chít la muoi noaq con samiang án hỡ, chơ yang crỗng Yaboc. ");
INSERT INTO bru_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Moâm án satoâl dũ náq cũai tâng dống sũ án, án cơiq nheq crơng án hỡ yỗn pỡq nhũang án. ");
INSERT INTO bru_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ma Yacốp ỡt manoaq án yáng nâi dỡq, cớp bữn manoaq samiang toâq sansrứm cớp Yacốp toau poang tarưp. ");
INSERT INTO bru_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tữ samiang ki dáng án tỡ riap Yacốp, ngkíq án trứp cuclỗ-clễ Yacốp toau raplễ. ");
INSERT INTO bru_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Chơ samiang ki atỡng Yacốp neq: “Mới acláh yỗn cứq pỡq, yuaq cheq ễ poang chơ.” Ma Yacốp ta‑ỡi neq: “Cứq tỡ bữn acláh mới, khân mới tỡ bữn pai ŏ́c bốn yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Chơ samiang ki blớh Yacốp neq: “Ntrớu ramứh mới?” Yacốp ta‑ỡi: “Cứq ramứh Yacốp.” ");
INSERT INTO bru_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Samiang ki pai ễn neq: “Ramứh mới tỡ bữn noâng Yacốp; ma tễ nâi chumát mới bữn ramứh tamái, la I-sarel; yuaq mới sansrứm cớp Yiang Sursĩ, cớp mới bữn riap.” ");
INSERT INTO bru_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Moâm ki Yacốp blớh loah án neq: “Cứq sễq anhia atỡng tê ramứh anhia yỗn cứq.” Ma án ta‑ỡi neq: “Cỗ nŏ́q mới blớh ramứh cứq?” Moâm án pai ngkíq, án pai ŏ́c bốn yỗn Yacốp, ariang Yacốp khoiq sễq chơ. ");
INSERT INTO bru_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Chơ Yacốp amứh ntốq ki la Pê-niel, cớp án pai neq: “Yuaq cứq khoiq hữm mieiq Yiang Sursĩ, mŏ cứq noâng bữn tamoong.” ");
INSERT INTO bru_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tữ Yacốp pỡq pha Pê-niel, moat mandang khoiq loŏh chơ. Án tayáh pỡq thớl-thớp, thớl-thớp, yuaq nlu án raplễ. ");
INSERT INTO bru_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yuaq ngkíq, cũai I-sarel mŏ tỡ bữn cha sâiq ca tớt cớp nghang cuclỗ-clễ yỗn toau toâq tangái nâi; yuaq Yiang Sursĩ trứp Yacốp ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yacốp tapoang nhêng, chơ án hữm Ê-sau toâq cớp pỗn culám náq cũai samiang. Ngkíq Yacốp tampễq máh con án yỗn Lê-a, Rachel, cớp bar náq mansễm táq ranáq yỗn alới dững. ");
INSERT INTO bru_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Án yỗn bar náq mansễm táq ranáq cớp con alới pỡq nhũang. Vớt ki, án yỗn Lê-a cớp máh con án pỡq tapun. Ntun tháng án yỗn Rachel cớp Yô-sep ễn pỡq. ");
INSERT INTO bru_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Moâm án táq ngkíq, Yacốp pỡq nhũang nheq tữh cũai ki. Tữ án toâq pỡ Ê-sau, án cucốh choâng moat Ê-sau tapul trỗ. ");
INSERT INTO bru_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma Ê-sau lúh palŏ́ng kĩau Yacốp, cớp hũn hĩt án. Chơ alới bar náq mpruam nhiam. ");
INSERT INTO bru_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Chơ Ê-sau tapoang hữm máh mansễm cớp máh carnễn. Án blớh Yacốp neq: “Nheq tữh cũai ỡt cớp mới la noau?” Yacốp ta‑ỡi: “Nâi la máh con Yiang Sursĩ yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Moâm ki, bar náq mansễm táq ranáq yỗn Yacốp cớp máh con alới toâq, cớp alới cucốh Ê-sau. ");
INSERT INTO bru_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Chơ Lê-a cớp máh con án ễn toâq, cớp alới cucốh Ê-sau tê. Chơ parsốt tháng la Yô-sep cớp Rachel toâq cucốh Ê-sau tê. ");
INSERT INTO bru_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ê-sau blớh ễn neq: “Máh cũai cớp tỗp charán cứq khoiq ramóh ki dŏq yỗn noau?” Yacốp ta‑ỡi: “Cứq sễq yỗn ai máh charán ki ễq yỗn ai bũi pahỡm cớp cứq.” ");
INSERT INTO bru_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Ê-sau pai: “Sa‑ỡn mới, a‑ễm ơi! Cứq bữn sa‑ữi tê charán; sanua mới ĩt dŏq loah máh crơng mới.” ");
INSERT INTO bru_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yacốp ta‑ỡi neq: “Tỡ bữn mŏ! Khân ai sâng ayooq táq a‑ễm, sễq ai roap ĩt máh crơng nâi. Cứq hữm moat ai la machớng cứq hữm moat Yiang Sursĩ tê, yuaq ai tabỡp cứq bũi óh lứq. ");
INSERT INTO bru_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngkíq cứq sễq ai roap ĩt máh crơng nâi. Yiang Sursĩ toâp chuai cứq, ngkíq yuaq cứq bữn túc palễc.” Yacốp pasĩt níc Ê-sau, chơ Ê-sau roap ĩt máh crơng ki. ");
INSERT INTO bru_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ê-sau pai neq: “Hái loŏh pỡq parnơi. Cứq pỡq nhũang.” ");
INSERT INTO bru_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yacốp ta‑ỡi neq: “Ai ơi! Ai hữm chơ máh con cứq noâng cớt cớt. Cớp cứq bữn cữu cớp ntroŏq mbỡiq roah con hỡ. Khân hếq cutúh yỗn pỡq chái, ki ống muoi tangái sâng la cuchĩt nheq. ");
INSERT INTO bru_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Sễq ai pỡq nhũang cứq a‑ễm. Chơ cứq ngcuai pỡq, yuaq cứq miaq yũar máh charán cớp con cứq. Nỡ‑ra ễn cứq toâq pỡ dống ai pỡ ntốq Sêr ki.” ");
INSERT INTO bru_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ê-sau ta‑ỡi: “Khân ngkíq, cứq yỗn cũai samiang tễ tỗp cứq pỡq cớp mới, dŏq chuai mới.” Ma Yacốp ta‑ỡi Ê-sau neq: “Tỡ bữn ntrớu! Ai khoiq sarũiq táq cứq sa‑ữi chơ.” ");
INSERT INTO bru_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ngkíq tâng tangái ki Ê-sau píh chu loah pỡ Sêr. ");
INSERT INTO bru_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Yacốp noâng ỡt pỡ ntốq Sucôt. Ỡt ntốq ki, án táq muoi lám dống, cớp táq cuaq yỗn charán án ỡt hỡ. Ngkíq, noau dŏq ramứh ntốq ki la Sucôt. ");
INSERT INTO bru_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Toâq Yacốp loŏh tễ cruang Padan Aram, pỡq pỡ vil Se-kem tâng cruang Cana-an, án tỡ bữn ramóh túh coat ntrớu; chơ án chóh dống tễ ramŏ́h vil ki. ");
INSERT INTO bru_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Cớp án chỡng muoi ntốq cutễq tễ máh con samiang Hamor, la mpoaq Se-kem. Yacốp chỡng cutễq ki muoi culám ŏ́c práq panê. Chơ án ayứng dống aroâiq pỡ ki. ");
INSERT INTO bru_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Pỡ ntốq ki án táq muoi lám prông dŏq sang Yiang Sursĩ. Án amứh prông ki la: El-alô-he I-sarel. ");
INSERT INTO bru_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Con mansễm Lê-a cớp Yacốp, ramứh Di-na, pỡq sa‑óh cũai mansễm tâng cruang ki. ");
INSERT INTO bru_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tữ Se-kem, con samiang Hamor, la cũai sốt tỗp Hê-vit, hữm Di-na, án yoc ễ bữn Di-na; ngkíq án padâm Di-na yỗn bếq cớp án. ");
INSERT INTO bru_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mứt pahỡm samiang ki yoc lứq ễ bữn Di-na con cumũr Yacốp. Chơ án táq ntỡng santoiq ễm lứq cớp cumũr ki. ");
INSERT INTO bru_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Se-kem atỡng Hamor mpoaq án neq: “Sễq mpoaq pỡq sễq mansễm ki yỗn cứq con táq lacuoi.” ");
INSERT INTO bru_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yacốp sâng noau pai samiang ki khoiq táq tỡ o chóq Di-na, con cumũr án, ma bo ki máh con samiang án noâng ỡt tâng ruang bán charán. Ngkíq án tỡ bữn tabỗq ntrớu, toau máh con samiang án chu tễ ruang. ");
INSERT INTO bru_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, mpoaq Se-kem, toâq pỡ Yacốp ễ sarhống cớp án. ");
INSERT INTO bru_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Toâq máh con samiang Yacốp sâng tễ ranáq nâi, alới chu toâp tễ ruang, cớp alới sâng a‑ĩ lứq tâng mứt. Alới sâng ũan lứq samiang ki táq sâuq yỗn nheq tỗp I-sarel, na án mpoat amuaq alới. Ŏ́c nâi lứq tỡ pĩeiq. ");
INSERT INTO bru_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor táq ntỡng cớp alới neq: “Mứt pahỡm Se-kem, con samiang cứq, yoc lứq ễ bữn amuaq anhia. Cứq sễq anhia yỗn amuaq anhia yỗn án cỡt lacuoi con cứq. ");
INSERT INTO bru_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Hếq mơi anhia táq khỡi cuya cớp hếq. Sễq anhia chiau máh amuaq anhia yỗn cỡt lacuoi tâng tỗp hếq; chơ hếq yỗn anhia ĩt máh mansễm tễ tỗp hếq cỡt lacuoi anhia. ");
INSERT INTO bru_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Táq ngkíq, anhia têq ỡt parnơi cớp tỗp hếq; ntốq aléq anhia yoc ễ ỡt, têq anhia ỡt. Pỡ léq anhia ễ pỡq, ki anhia pỡq; cớp têq anhia chỡng cutễq tâng cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Moâm Hamor pai ngkíq, Se-kem ễn atỡng mpoaq cớp amiang mansễm ki neq: “Sễq anhia sarũiq táq cứq nứng; anhia ễ bữn kia máh léq la cứq yỗn. ");
INSERT INTO bru_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Anhia ễ bữn práq kia cớp crơng mpon máh léq la têq. Anhia ễ bữn kia máh léq la cứq yỗn máh ki. Ma sễq anhia chiau mansễm ki yỗn cỡt lacuoi cứq.” ");
INSERT INTO bru_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ma cỗ tian Se-kem táq tỡ o chóq Di-na amuaq alới, ngkíq alới ta‑ỡi phếq Se-kem cớp Hamor, mpoaq án, neq: ");
INSERT INTO bru_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Hếq tỡ têq chiau amuaq hếq yỗn cũai samiang ca tỡ yũah táq rit cứt; ŏ́c ki cỡt ranáq casiet táq yỗn tỗp hếq. ");
INSERT INTO bru_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ma bữn ống muoi ŏ́c sâng hếq têq pruam cớp anhia. Khân anhia táq ĩn hếq pai, ki nheq tữh cũai samiang tâng tỗp anhia cóq táq rit cứt; ");
INSERT INTO bru_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","chơ hếq têq chiau máh amuaq hếq yỗn anhia. Cớp hếq têq ĩt máh mansễm tễ tỗp anhia táq lacuoi. Hếq ễ ỡt parnơi cớp anhia, chơ bar tỗp hái cỡt muoi tỗp sâng. ");
INSERT INTO bru_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ma khân anhia tỡ bữn pruam táq puai phễp rit hếq, ki hếq dững nheq máh mansễm tễ tỗp hếq dễq ỡt pỡ ntốq canŏ́h ễn.” ");
INSERT INTO bru_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Máh santoiq alới pai cỡt pĩeiq pahỡm Hamor cớp Se-kem, con samiang án. ");
INSERT INTO bru_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Se-kem tỡ bữn cro noâng; án táq toâp ranáq ki, yuaq án yoc lứq ễ bữn con mansễm Yacốp. Cớp án cỡt cũai bữn chớc clữi nheq tễ cũai canŏ́h tâng dống sũ mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ngkíq Hamor cớp Se-kem, con samiang án, pỡq chu ngoah toong viang vil, ntốq ki cũai tâng vil dốq rôm sarhống. ");
INSERT INTO bru_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Alới atỡng neq: “Cũai tỗp nâi cỡt yớu ratoi cớp tỗp hái, chơ hái yỗn alới têq chếq chỡng cớp ỡt tâng cruang hái. Cruang hái bữn cutễq la‑a cớp dũ ntốq yỗn alới ỡt. Hái têq ĩt lacuoi tễ tỗp alới, cớp alới têq ĩt lacuoi tễ tỗp hái. ");
INSERT INTO bru_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Alới bũi ỡt cớp tỗp hái, cớp cỡt muoi tỗp cớp tỗp hái, khân hái pruam táq neq: Nheq tữh cũai samiang tâng tỗp hái cóq táq tếc cứt puai phễp rit alới. ");
INSERT INTO bru_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Khân hái pruam táq ngkíq, nheq crơng crớu alới, dếh ntroŏq, dếh crơng canŏ́h, lứq toâq pỡ hái nheq. Ngkíq alới lứq ỡt parnơi cớp hái.” ");
INSERT INTO bru_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Moâm Hamor cớp Se-kem pai ngkíq, nheq tữh cũai samiang tâng vil ki pruam nheq. Chơ alới táq rit cứt. ");
INSERT INTO bru_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ma toâq pái tangái ntun cũai samiang ki táq rit cứt, bo alới noâng sâng a‑ĩ bớc, ngkíq bar náq con samiang Yacốp, ramứh Si-mê-ôn cớp Lê-vi, alới la muoi mpiq cớp Di-na, alới yống dau pỡq cachĩt nheq máh samiang tâng vil ki. ");
INSERT INTO bru_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Alới cachĩt dếh Hamor cớp Se-kem, con samiang án, hỡ. Chơ alới dững Di-na loŏh tễ dống Se-kem. ");
INSERT INTO bru_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Máh tỗp con samiang Yacốp canŏ́h, tữ alới mut tâng vil cớp hữm máh cũai samiang cuchĩt tróh, ngkíq alới pũr ĩt nheq máh crơng tâng vil, yuaq cũai tâng vil ki khoiq táq tỡ o chóq amuaq alới. ");
INSERT INTO bru_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Alới ĩt nheq máh charán, dếh ntroŏq, cớp aséh dễn cớp nheq ramứh canŏ́h tễ vil cớp tễ ruang. ");
INSERT INTO bru_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Chơ alới cỗp nheq con lacuoi cũai tâng vil ki, cớp ĩt dũ ramứh crơng tâng dống cũai ki hỡ. ");
INSERT INTO bru_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ma Yacốp pai chóq Si-mê-ôn cớp Lê-vi neq: “Anhia ntôm táq yỗn cứq tamóh túh coat, na táq yỗn cũai tỗp Cana-an cớp tỗp Pê-rasit, alới ca ndỡm cruang nâi kêt cứq. Hái bữn cũai bĩq náq sâng; khân máh tỗp ki pruam toâq ễ táq hái, ki cứq cớp nheq dống sũ hái lứq cuchĩt nheq tê.” ");
INSERT INTO bru_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Alới ta‑ỡi loah mpoaq alới neq: “Hếq tỡ rơi chĩuq noau táq chóq amuaq hếq ariang mansễm chếq tỗ.” ");
INSERT INTO bru_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Chơ Yiang Sursĩ patâp Yacốp neq: “Mới thrũan, chơ dễq pỡ ntốq Bet-el ễn. Ỡt ntốq ki, cóq mới táq muoi lám prông dŏq sang cứq. Cứq la Yiang Sursĩ ca khoiq ramóh mới, bo mới lúh tễ Ê-sau, ai mới.” ");
INSERT INTO bru_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ngkíq Yacốp atỡng dống sũ án cớp máh cũai ỡt cớp án neq: “Cóq anhia táh nheq máh rup yiang cũai canŏ́h. Táq yỗn tỗ anhia cỡt bráh, cớp thái tampâc, chơ sớp tampâc tamái ễn. ");
INSERT INTO bru_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Moâm ki, hái thrũan dễq pỡq chu vil Bet-el ễn. Ỡt ntốq ki, cứq ễ táq muoi lám prông dŏq sang Yiang Sursĩ, án ca khoiq ta‑ỡi cứq tâng tangái cứq tamóh túh coat, cớp án ca pỡq parnơi cớp cứq dũ ntốq.” ");
INSERT INTO bru_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Máh cũai ki chiau nheq máh rup yiang canŏ́h yỗn Yacốp, dếh sarcáp alới moac tâng cutũr hỡ. Yacốp tứp nheq máh crơng ki nhưp aluang toâr cheq ntốq Se-kem. ");
INSERT INTO bru_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Toâq nheq tữh alới loŏh nheq tễ ntốq ki, Yiang Sursĩ táq yỗn mứt pahỡm cũai ỡt tâng dũ vil mpễr ki cỡt ngcŏh. Ngkíq, máh cũai ki tỡ bữn rapuai carláh dỡq chóq tỗp con samiang Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yacốp cớp dũ náq cũai pỡq nứng án toâq pỡ vil Lusơ, cruang Cana-an. Ntốq ki bữn ramứh Bet-el hỡ. ");
INSERT INTO bru_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ỡt ntốq ki Yacốp táq muoi lám prông, án amứh El Bet-el, yuaq ntốq ki Yiang Sursĩ toâq pỡ án tangái án lúh tễ Ê-sau. ");
INSERT INTO bru_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Cớp tangái ki De-bara la cũai mansễm ca rabán Rê-be-ca cuchĩt. Noau tứp án nhưp nỡm aluang ramứh Alôn Bacut coah angia pưn vil Bet-el. ");
INSERT INTO bru_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Toâq Yacốp loŏh tễ cruang Padan Aram chu ỡt pỡ Bet-el ễn, Yiang Sursĩ toâq pỡ án muoi trỗ ễn, dếh pai ŏ́c bốn yỗn án. ");
INSERT INTO bru_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Cớp Yiang Sursĩ atỡng Yacốp neq: “Ramứh mới la Yacốp, ma tễ nâi chumát tỡ bữn noâng ramứh Yacốp, ma cứq dŏq ramứh mới la I-sarel ễn.” Ngkíq, Yiang Sursĩ amứh ramứh Yacốp la I-sarel. ");
INSERT INTO bru_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yiang Sursĩ atỡng án neq: “Cứq la Yiang Sursĩ Sốt Toâr Lứq. Nỡ‑ra mới bữn tŏ́ng toiq cỡt clứng lứq, cớp cỡt muoi cruang toâr; bữn sa‑ữi tỗp cũai toâq tễ mới, dếh cũai puo hỡ. ");
INSERT INTO bru_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Máh cruang cutễq cứq khoiq pruam ễ yỗn A-praham cớp I-sac, ki cứq ễ yỗn mới cớp tŏ́ng toiq mới ễn bữn ndỡm.” ");
INSERT INTO bru_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Moâm ki Yiang Sursĩ loŏh tễ ntốq án táq ntỡng cớp Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yacốp ayứng muoi lám ngôl tamáu tâng ntốq Yiang Sursĩ khoiq táq ntỡng cớp án. Chơ án tốh blŏ́ng cớp dỡq nsễng tâng ngôl ki, sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yacốp amứh ntốq ki la Bet-el, yuaq Yiang Sursĩ khoiq táq ntỡng cớp án tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Chơ Yacốp cớp cũai ỡt cớp án loŏh tễ Bet-el. Bo alới tỡ yũah toâq pỡ vil Ep-rat, Rachel bếq tapéh, án ramóh coat lứq bo án canỡt con. ");
INSERT INTO bru_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tữ Rachel cheq ễ cuchĩt, bữn cũai mansễm ca chuai án atỡng án neq: “Chỗi croŏq ntrớu. Sanua mới bữn muoi lám con samiang ễn.” ");
INSERT INTO bru_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Toâq Rachel cheq ta-ŏh rangứh, án amứh con samiang ki la Ben-ô-ni. Moâm án pai ngkíq, chơ án ta-ŏh rangứh. Ma mpoaq con ki amứh con la Ben-yamin. ");
INSERT INTO bru_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel cuchĩt, noau tứp án cheq rana pỡq pỡ vil Ep-rat. Ep-rat bữn ramứh Bet-lahem hỡ. ");
INSERT INTO bru_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tâng pỡng ping Rachel, Yacốp ayứng muoi lám mooc dŏq táq tếc sanhữ ntốq án tứp Rachel. Toau tangái nâi mooc ki noâng níc. ");
INSERT INTO bru_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Chơ I-sarel dễq pỡ ntốq canŏ́h ễn, án chóh loah dống aroâiq, ma luat ntốq Mic-dal Ê-dơ. ");
INSERT INTO bru_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Toâq I-sarel ỡt tâng ntốq ki, Ruben con clúng án, mut bếq tuoiq cớp Bil-ha. Bil-ha la lacuoi cỗiq mpoaq án. Vớt ki I-sarel sâng tễ ranáq nâi. Yacốp bữn muoi chít la bar náq con samiang. ");
INSERT INTO bru_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Con samiang Yacốp bữn cớp Lê-a ramứh neq: Ruben (án la con clúng), Si-mê-ôn, Lê-vi, Yuda, I-sacar, cớp Sa-bulôn. ");
INSERT INTO bru_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Con samiang Yacốp bữn cớp Rachel ramứh neq: Yô-sep cớp Ben-yamin. ");
INSERT INTO bru_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Con samiang Yacốp bữn cớp Bil-ha ramứh neq: Dan cớp Nep-tali. Bil-ha la cũai táq ranáq yỗn Rachel. ");
INSERT INTO bru_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Con samiang Yacốp bữn cớp Sil-pa ramứh neq: Cát cớp Asêr. Sil-pa la cũai táq ranáq yỗn Lê-a. Nheq tữh nâi la tỗp con samiang Yacốp canỡt tâng cruang Padan Aram. ");
INSERT INTO bru_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Chơ Yacốp píh chu loah pỡ I-sac, mpoaq án, tâng ntốq Mam-rê, cheq cớp vil Ki-riat Ar-ba. Vil nâi bữn ramứh Hep-rôn hỡ, la ntốq A-praham cớp I-sac khoiq ỡt tễ nhũang, tâng cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","I-sac bữn tamoong muoi culám tacual chít cumo. ");
INSERT INTO bru_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Chơ án cuchĩt. Án cuchĩt riang achúc achiac án cuchĩt tê. Án khoiq thâu lứq, dỡi tamoong án la tanga tangỗih lứq. Bar lám con án, Ê-sau cớp Yacốp tứp án. ");
INSERT INTO bru_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nâi la tŏ́ng toiq Ê-sau; Ê-sau bữn ramứh Ê-dôm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ê-sau ĩt lacuoi tễ cũai cruang Cana-an, ramứh Adáh con E-lôn tỗp Hêt. Cớp án ĩt mansễm canŏ́h ramứh Ô-hô-li-bama con Anah, châu Si-bê-ôn tỗp Hê-vit. ");
INSERT INTO bru_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ê-sau ĩt mansễm ramứh Bat-mat hỡ; án la con It-ma-el cớp amuaq Nê-bayôt. ");
INSERT INTO bru_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adáh canỡt muoi lám con samiang, ramứh E-li-phat; Bat-mat canỡt muoi lám con samiang tê, ramứh Ruol; ");
INSERT INTO bru_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ô-hô-li-bama canỡt pái lám con samiang, ramứh neq: Yuih, Yalam, cớp Cô-ra. Nheq tữh nâi la tỗp con samiang Ê-sau canỡt tâng cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ê-sau dững máh con lacuoi án, cớp nheq tữh cũai tâng dống án, máh tỗp charán, cớp máh mun án ĩt tâng cruang Cana-an hỡ. Chơ án dễq ỡt tâng cruang canŏ́h ễn, yơng tễ a‑ễm án Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Yuaq alới bar náq sễm ai bữn mun sa‑ữi lứq, ngkíq alới tỡ têq ỡt muoi ntốq. Cutễq alới ỡt la tỡ dũ dŏq amia máh sarnóh, cỗ alới bữn sa‑ữi lứq charán. ");
INSERT INTO bru_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ngkíq Ê-sau pỡq ỡt tâng máh dũal cớp cóh cruang Sêr. Ramứh Ê-sau noau dŏq Ê-dôm hỡ. ");
INSERT INTO bru_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nâi la atỡng tễ máh tŏ́ng toiq Ê-sau, la achúc achiac tỗp Ê-dôm ca ỡt tâng cóh Sêr. ");
INSERT INTO bru_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ramứh máh con samiang Ê-sau la neq: E-li-phat la con Adáh, lacuoi Ê-sau. Ruol la con Bat-mat, lacuoi Ê-sau tê. ");
INSERT INTO bru_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","E-li-phat bữn máh con samiang ramứh Tê-man, Ô-mar, Sê-phô, Catam, cớp Kê-na. ");
INSERT INTO bru_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","E-li-phat con samiang Ê-sau bữn lacuoi cỗiq ramứh Tim-na. Tim-na canỡt muoi lám con samiang ramứh A-maléc. Nheq tữh cũai ki la tŏ́ng toiq Adáh, lacuoi Ê-sau. ");
INSERT INTO bru_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ruol bữn máh con samiang ramứh neq: Nahát, Sê-rah, Samah, cớp Mit-sa. Nheq tữh cũai ki la tŏ́ng toiq Bat-mat, lacuoi Ê-sau. ");
INSERT INTO bru_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ô-hô-li-bama, lacuoi Ê-sau, canỡt máh con samiang ramứh Yuih, Yalam, cớp Cô-ra. Ramứh mpoaq Ô-hô-li-bama la Anah, achuaih án ramứh Si-bê-ôn. ");
INSERT INTO bru_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Santoiq nâi atỡng tễ máh tỗp tŏ́ng toiq Ê-sau. Con clúng Ê-sau ramứh E-li-phat. Con samiang E-li-phat bữn máh tỗp neq: Tê-man, Ô-mar, Sê-phô, Kê-na, ");
INSERT INTO bru_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Cô-ra, Catam, cớp A-maléc. Nheq tữh cũai ki la con samiang E-li-phat ca cỡt tỗp tâng cruang Ê-dôm. Alới la tŏ́ng toiq Adáh. ");
INSERT INTO bru_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Máh con samiang Ruol ca cỡt tỗp tâng cruang Ê-dôm bữn ramứh neq: Nahát, Sê-rah, Samah, cớp Mit-sa. Nheq tữh cũai ki la tŏ́ng toiq Ê-sau cớp Bat-mat, lacuoi án. ");
INSERT INTO bru_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nâi la máh ramứh con samiang Ô-hô-li-bama lacuoi Ê-sau canỡt ca cỡt tỗp la neq: Yuih, Yalam, cớp Cô-ra. Ô-hô-li-bama la con Anah. ");
INSERT INTO bru_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Nheq tữh cũai ki la con samiang Ê-sau (tỡ la Ê-dôm), cớp nheq tữh cũai ki cỡt miar tỗp. ");
INSERT INTO bru_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Máh con samiang Sêr tễ tỗp Hô-rit ca ỡt dâu tâng cruang ki bữn ramứh neq: Lô-tan, Sô-bal, Si-bê-ôn, Anah, ");
INSERT INTO bru_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Di-sôn, E-sơ, cớp Di-san. Nheq tữh cũai ki cỡt sâu tỗp Hô-rit tâng cruang Ê-dôm. ");
INSERT INTO bru_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lô-tan amia máh con samiang bữn ramứh neq: Hô-ri cớp Hê-man. Án bữn amuaq ramứh Tim-na. ");
INSERT INTO bru_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sô-bal amia máh con samiang bữn ramứh neq: Al-van, Mana-hat, E-bal, Sê-phô, cớp Ô-nam. ");
INSERT INTO bru_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Si-bê-ôn amia máh con samiang bữn ramứh neq: Ai-ya cớp Anah. Anah nâi la manoaq ca ramóh dỡq mec cutâu tâng ntốq aiq bo án bán aséh Si-bê-ôn mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah amia bar lám con. Muoi la con samiang ramứh Di-sôn. Cớp muoi ễn la con mansễm ramứh Ô-hô-li-bama. ");
INSERT INTO bru_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Di-sôn amia máh con samiang ramứh neq: Hem-dan, Et-ban, I-tran, cớp Khê-ran. ");
INSERT INTO bru_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","E-sơ amia máh con samiang ramứh neq: Bil-han, Savan, cớp Ai-can. ");
INSERT INTO bru_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Di-san amia máh con samiang bữn ramứh neq: Usơ cớp Aran. ");
INSERT INTO bru_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ngkíq ramứh máh sâu cũai Hô-rit la neq: Lô-tan, Sô-bal, Si-bê-ôn, Anah, ");
INSERT INTO bru_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Di-sôn, E-sơ, cớp Di-san. Nheq tữh cũai ki cỡt sâu tỗp Hô-rit tâng cruang Sêr ki. ");
INSERT INTO bru_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nâi la máh ramứh puo ca cỡt sốt tâng cruang Ê-dôm tễ nhũang tỗp I-sarel cỡt sốt cruang alới. ");
INSERT INTO bru_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bê-la con samiang Bê-ô, cỡt puo tâng vil Din-haba. ");
INSERT INTO bru_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Vớt Bê-la cuchĩt, Yô-bap con samiang Sê-rah tễ vil Bô-tra ễn pláih loah án cỡt puo. ");
INSERT INTO bru_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Vớt Yô-bap cuchĩt, Husam, la cũai tễ cruang Tê-man ễn pláih loah án cỡt puo. ");
INSERT INTO bru_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Vớt Husam cuchĩt, Hadat con samiang Be-dat tễ vil Avit ễn pláih loah án cỡt puo. Hadat chíl riap cũai Madian tâng cruang Mô-ap. ");
INSERT INTO bru_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Vớt Hadat cuchĩt, Sam-la, la cũai tễ vil Mat-rê-ca ễn pláih loah án táq puo. ");
INSERT INTO bru_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Vớt Sam-la cuchĩt, Sau-lơ tễ vil Rê-hô-bôt yoah tooh crỗng Ơ-phơ-rat ễn pláih loah án cỡt puo. ");
INSERT INTO bru_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Vớt Sau-lơ cuchĩt, Ba-al Hanan con samiang Ac-bôr ễn pláih loah án cỡt puo. ");
INSERT INTO bru_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Vớt Ba-al Hanan cuchĩt, Hadat tễ vil Pau ễn pláih loah án cỡt puo. Lacuoi Hadat ramứh Mahê-tabêl con Matrêt, châu Mê-sahap. ");
INSERT INTO bru_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nâi la atỡng tễ máh sâu tễ tŏ́ng toiq Ê-sau, puai ramứh sâu cớp ramứh ntốq alới ỡt: Tim-na, Al-va, Yê-het, ");
INSERT INTO bru_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ô-hô-li-bama, E-lah, Pi-nôn, ");
INSERT INTO bru_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kê-na, Tê-man, Mip-sar, ");
INSERT INTO bru_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mac-diel, cớp I-ram. Nheq máh sâu ki tâng cruang Ê-dôm puai ntốq alới ỡt. Ê-sau la achúc achiac nheq tữh cũai Ê-dôm. ");
INSERT INTO bru_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yacốp ỡt tâng cruang Cana-an, la ntốq mpoaq án khoiq ỡt tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nâi la atỡng tễ tŏ́ng toiq Yacốp. Bo Yô-sep bữn muoi chít tapul cumo, án bán cữu parnơi cớp sễm ai án. Yô-sep táq ranáq parnơi cớp con samiang Bil-ha cớp Sil-pa, lacuoi mpoaq án. Án cauq sễm ai án tễ ranáq alới táq sâuq chóq mpoaq alới. ");
INSERT INTO bru_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Cỗ Yô-sep la con I-sarel bữn bo án khoiq thâu chơ, ngkíq I-sarel ayooq Yô-sep hỡn tễ nheq con samiang án canŏ́h. Yuaq ngkíq, I-sarel ớn noau táq muoi ploah au tuar nêuq lứq yỗn Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Máh ai Yô-sep dáng mpoaq alới ayooq Yô-sep hỡn tễ alới. Ngkíq alới kêt lứq Yô-sep, cớp alới tỡ rơi pai muoi ŏ́c o ntrớu chóq Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Bữn muoi sadâu Yô-sep rláu mpáu. Toâq án ruaih yỗn máh ai án tamứng tễ parnáu án rláu mpáu, alới kêt án hỡn tễ nhũang ễn. ");
INSERT INTO bru_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yô-sep pai neq: “Cứq yoc anhia tamứng ŏ́c cứq mpáu. ");
INSERT INTO bru_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nheq tữh hái boq saro tâng sarái, ma bo ki toâp boq saro cứq ayứng tanoang tháng. Ma boq saro anhia rôm nheq mpễr boq saro cứq, cớp boq saro anhia cucốh cucũoi boq saro cứq.” ");
INSERT INTO bru_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Moâm án pai ngkíq, máh mu ai án blớh loah neq: “Nŏ́q mới chanchớm, mới cỡt sốt tỗp hếq tỡ? Cớp cỡt puo tỗp hếq tỡ?” Ngkíq alới kêt án hỡn tễ nhũang ễn, cỗ tian tễ parnáu án rláu mpáu, cớp tễ santoiq án pai. ");
INSERT INTO bru_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bữn muoi trỗ ễn Yô-sep rláu mpáu sĩa, cớp án atỡng yỗn máh ai án tamứng tễ parnáu án rláu mpáu. Án pai neq: “Cứq mpáu sĩa; sễq anhia tamứng. Bữn moat mandang, rliang casâi, cớp muoi chít la muoi ŏ́c mantỗr; chơ nheq máh ramứh ki cucốh cucũoi cứq.” ");
INSERT INTO bru_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Moâm Yô-sep sarŏh parnáu yỗn máh ai án tamứng, án atỡng yỗn mpoaq án dáng tê tễ ramứh ki. Mpoaq án nhôp, cớp blớh án neq: “Ntrớu ma liaq lứq mới mpáu? Nŏ́q mới chanchớm cứq cớp mpiq mới, dếh máh ai mới, la cucốh cucũoi choâng moat mới tỡ?” ");
INSERT INTO bru_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ngkíq máh ai Yô-sep tỡ ễq hữm tháng án; ma Yacốp cayớm dŏq tễ máh ŏ́c nâi tâng mứt. ");
INSERT INTO bru_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Bữn muoi tangái máh ai Yô-sep pỡq bán tỗp cữu mpoaq alới tâng ntốq Se-kem. ");
INSERT INTO bru_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","I-sarel atỡng Yô-sep neq: “Máh ai mới bán tỗp cữu pỡ Se-kem. Sanua mới pỡq chu alới.” Yô-sep ta‑ỡi neq: “Ơq! Cứq pỡq.” ");
INSERT INTO bru_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Chơ Yacốp ớn Yô-sep ễn neq: “Cứq yoc mới pỡq nhêng máh ai mới, alới bữn bán sũan ma tỡ bữn. Cớp tỗp cữu plot-plál ma tỡ bữn. Moâm ki, mới chu atỡng loah cứq.” Chơ Yacốp ớn Yô-sep loŏh tễ avúng Hep-rôn, pỡq pỡ Se-kem. ");
INSERT INTO bru_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ỡt tâng Se-kem bữn muoi noaq cũai samiang ramóh Yô-sep pỡq chu nâi pỡq chu ki tâng ruang, án blớh Yô-sep neq: “Ntrớu mới chuaq?” ");
INSERT INTO bru_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yô-sep ta‑ỡi: “Cứq chuaq máh ai cứq. Sễq mới atỡng cứq, pỡ ntốq aléq alới bán cữu.” ");
INSERT INTO bru_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Samiang ki ta‑ỡi neq: “Alới khoiq loŏh chơ tễ ntốq nâi. Cứq sâng alới pai neq: ‘Hâi! Hái pỡq pỡ Dô-than ễn.’” Ngkíq Yô-sep puai cớp tamóh alới pỡ ntốq Dô-than. ");
INSERT INTO bru_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Toâq máh ai án hữm Yô-sep noâng tễ yơng, alới sarhống ễ táq nŏ́q ma bữn cachĩt chíq Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Manoaq atỡng manoaq neq: “Án ca dốq rláu mpáu toâq pỡ nâi chơ. ");
INSERT INTO bru_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hâi! Hái cachĩt chíq án cớp voang án asễng tâng hŏ́ng loang, chơ hái pai neq: ‘Bữn muoi lám charán cáp án.’ Chơ hái bữn dáng án rláu mpáu cỡt kia ma tỡ bữn.” ");
INSERT INTO bru_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Toâq Ruben sâng santoiq ki, án ễ chuai Yô-sep yỗn vớt tễ atĩ ai. Chơ án pai neq: “Hái chỗi cachĩt án.” ");
INSERT INTO bru_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben atỡng ễn neq: “Chỗi yỗn aham loŏh. Ma hái apŏ́ng chíq án tâng hŏ́ng loang tâng ntốq aiq nâi. Ma anhia chỗi táq bớc chũl ntrớu tỗ án.” Ruben pai ngkíq, yuaq án ễ chuai Yô-sep yỗn chu loah pỡ mpoaq alới. ");
INSERT INTO bru_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tữ Yô-sep toâq pỡ ai án, máh ai án pũar tũot chíq au tuar nêuq sa‑ữi santứm ca án sớp. ");
INSERT INTO bru_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Moâm ki, alới cỗp án cớp apŏ́ng tâng hŏ́ng loang. Ma hŏ́ng ki khỗ, ŏ́q dỡq. ");
INSERT INTO bru_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Moâm ki, máh ai án tacu cha dỗi. Chơ alới tapoang nhêng, hữm muoi tỗp cũai It-ma-el toâq tễ vil Ki-liat. Cũai ki pỡq chếq chỡng; charán lac‑da alới ki patiang trâm cớp crơng phuom tễ siet aluang pỡq chu cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda blớh máh a‑ễm án neq: “Khân hái cachĩt, chơ cutooq aham án, bữn kia ntrớu? ");
INSERT INTO bru_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Sanua hái chếq chíq án yỗn cũai It-ma-el, ma atĩ hái chỗi toân toah ntrớu án, cỗ án la lứq a‑ễm hái cỡt muoi sâiq muoi aham cớp hái.” Chơ alới táq ariang santoiq Yuda pai. ");
INSERT INTO bru_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Moâm ki, bữn muoi tỗp cũai Madian pỡq pha bân ntốq ki. Ngkíq máh ai Yô-sep âc achỗn án tễ hŏ́ng loang ki, chơ chếq án yỗn cũai It-ma-el. Kia Yô-sep la bar chít ŏ́c práq panê. Chơ cũai ki dững Yô-sep chu cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tữ Ruben chu loah pỡ hŏ́ng loang ki, án tỡ bữn hữm noâng Yô-sep. Chơ án háq tampâc án bữm, táq tếc án sâng ngua. ");
INSERT INTO bru_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Chơ án píh chu loah pỡ máh a‑ễm, cớp atỡng neq: “Yô-sep khoiq pứt! Nŏ́q cứq ễ táq sanua?” ");
INSERT INTO bru_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ma máh ai Yô-sep khoiq ĩt chơ au tuar Yô-sep, cớp alới cachĩt muoi lám mbễq tangcáh. Moâm ki alới yớm au tuar Yô-sep tâng aham mbễq. ");
INSERT INTO bru_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Chơ alới cơiq au tuar ki yỗn mpoaq alới, cớp pai neq: “Hếq tamóh au tuar nâi. Sễq mpoaq nhêng. Au tuar nâi la au con mpoaq, ma tỡ cỡn?” ");
INSERT INTO bru_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ngkíq Yacốp nhêng, cớp án sacoal. Chơ án nhiam cớp pai neq: “Au tuar nâi la au con samiang cứq; charán pla khoiq cáp cha sâiq con cứq chơ. Yô-sep khoiq abuoiq nheq chơ charán pla táq.” ");
INSERT INTO bru_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Chơ Yacốp háq chíq tampâc án, cớp án tâc tampâc tanúh, cỗ pứt chíq con án. Ngkíq Yacốp tanúh con samiang án sa‑ữi tangái. ");
INSERT INTO bru_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nheq tữh con samiang cớp con mansễm án toâq pỡ án, yoc ễ aliam án. Ma án tỡ yỗn alới aliam; án pai neq: “Cứq dŏq ŏ́c ngua nâi toau noau tứp cứq, cớp raviei cứq ỡt cớp con cứq.” Yacốp nhiam níc sâng, yuaq con án khoiq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ma bo ki, cũai Madian chếq to loah Yô-sep yỗn Phô-ti-pha, cũai tâng cruang Ê-yip-tô. Cũai ki la ranễng cũai sốt tahan kĩaq puo cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Bữn muoi tangái, Yuda táh sễm ai án pỡq ỡt parnơi cớp manoaq samiang ramứh Hi-ra tễ vil A-dulam. ");
INSERT INTO bru_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ỡt ntốq ki, Yuda hữm con mansễm Sua, cũai cruang Cana-an. Chơ Yuda ĩt mansễm ki táq lacuoi án. ");
INSERT INTO bru_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mansễm ki ỡt mumiaq cớp canỡt muoi lám con samiang. Yuda amứh con ki la E-rơ. ");
INSERT INTO bru_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ntun ki mansễm ki ỡt mumiaq sĩa cớp canỡt muoi lám con samiang ễn. Án amứh con ki Ô-nan. ");
INSERT INTO bru_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Chơ mansễm ki canỡt muoi lám con samiang ễn. Án amứh con ki la Sê-lah. Bo lacuoi án canỡt Sê-lah, Yuda ỡt tâng vil Khê-sip. ");
INSERT INTO bru_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","E-rơ con clúng Yuda toâr achỗn; ngkíq Yuda ĩt lacuoi yỗn án, ramứh Tamar. ");
INSERT INTO bru_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma E-rơ táq ranáq sâuq lứq choâng moat Yiang Sursĩ. Ngkíq Yiang Sursĩ táq yỗn án cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Chơ Yuda atỡng Ô-nan neq: “Puai rit hái, cóq mới ĩt lacuoi ai mới táq lacuoi mới ễn. Cóq mới bếq cớp án, yỗn án bữn con dŏq cỡt con tŏ́ng ai mới.” ");
INSERT INTO bru_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ma Ô-nan dáng tỡ bữn cỡt con tŏ́ng án bữm. Toâq án mut bếq cớp mansễm ki, án táq yỗn tỡ bữn bữn con. Yuaq án tỡ ễq con án cỡt tŏ́ng ai án ễn. ");
INSERT INTO bru_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ma ranáq nâi la sâuq lứq choâng moat Yiang Sursĩ. Ngkíq Yiang Sursĩ táq yỗn án cuchĩt. ");
INSERT INTO bru_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Chơ Yuda atỡng Tamar cumân án neq: “Mới chu loah pỡq dống hoq mới, acoan toau toâq tangái Sê-lah con samiang cứq toâr.” Yuaq Yuda ngcŏh Sê-lah cuchĩt riang ai án tê. Ngkíq Tamar chu pỡ dống hoq án. ");
INSERT INTO bru_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Dũn tễ ki, con mansễm Sua, lacuoi Yuda cuchĩt tê. Moâm tangái Yuda tanúh, án pỡq ramóh cũai cứt sóc cữu án pỡ cruang Tim-nah. Cớp yớu án ramứh Hi-ra, cũai tễ vil A-dulam pỡq cớp án tê. ");
INSERT INTO bru_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Bữn cũai toâq atỡng Tamar neq: “Yacũn mới pỡq chu Tim-nah, yoc ễ cứt sóc tỗp cữu án.” ");
INSERT INTO bru_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ngkíq, Tamar tũot au tếc cán cumai, chơ án pul mieiq yỗn noau tỡ bữn sacoal án. Moâm ki án pỡq tacu cheq ngoah viang vil E-nêm cheq rana pỡq chu Tim-nah. Án táq ngkíq, yuaq án dáng Sê-lah khoiq toâr chơ; ma yacũn án tỡ bữn yỗn án cỡt lacuoi Sê-lah. ");
INSERT INTO bru_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Toâq Yuda hữm Tamar tacu ngki, án tỡ bữn sacoal. Án chớm Tamar la mansễm chếq tỗ, yuaq Tamar pul chíq mieiq. ");
INSERT INTO bru_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda pỡq cheq mansễm ki cớp pai neq: “Cứq yoc ễ bếq cớp mới.” Ma án tỡ bữn dáng pai mansễm ki la cumân án. Mansễm ki ta‑ỡi neq: “Ntrớu mới ễ yỗn cứq, ma yoc ễ bếq cớp cứq?” ");
INSERT INTO bru_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda ta‑ỡi: “Cứq ễ cơiq yỗn mới muoi lám mbễq con tễ tỗp mbễq cứq.” Mansễm ki blớh ễn: “Ntrớu tếc mới ễ yỗn cứq sanua, toau mới cơiq muoi lám mbễq con yỗn cứq?” ");
INSERT INTO bru_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ma Yuda blớh loah mansễm ki: “Tếc ntrớu mới ễ bữn tễ cứq?” Án ta‑ỡi: “Mới yỗn cứq sambễt tếc cớp cansái mới dốq ngcuac, cớp ralỡng mới dốq yống.” Chơ Yuda yỗn mansễm ki máh crơng ki. Cớp án pỡq bếq cớp mansễm ki, cớp mansễm ki cỡt mumiaq. ");
INSERT INTO bru_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Vớt Yuda loŏh, mansễm ki yuor tayứng cớp loŏh tễ ntốq ki. Án tũot chíq au pul mieiq, cớp án sớp loah tampâc tếc cán cumai. ");
INSERT INTO bru_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ntun ễn, Yuda ớn yớu án cũai A-dulam dững yỗn mansễm ki muoi lám mbễq con. Yuda ễ thái loah máh crơng án khoiq táq tếc pỡ mansễm ki. Ma yớu án chuaq tỡ ramóh mansễm ki. ");
INSERT INTO bru_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Yớu ki blớh samiang ỡt tâng ntốq ki neq: “Nléq chơ mansễm ca chếq tỗ, tễ nhũang án tacu cheq rana pỡq chu vil E-nêm?” Cũai ki ta‑ỡi: “Ỡt ntốq nâi ŏ́q mansễm chếq tỗ.” ");
INSERT INTO bru_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ngkíq yớu Yuda chu loah pỡ án, cớp atỡng án neq: “Cứq tỡ bữn tamóh mansễm ki. Cớp cũai ỡt tâng ntốq ki pai ŏ́q mansễm chếq tỗ tâng ntốq ki.” ");
INSERT INTO bru_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda ta‑ỡi loah: “Chơ. Yỗn mansễm ki loâng crơng tếc ki. Hái tỡ ễq cỡt casiet táq cớp cũai canŏ́h. Cứq khoiq cơiq chơ muoi lám mbễq con yỗn án, ma mới chuaq tỡ bữn ramóh mansễm ki.” ");
INSERT INTO bru_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Vớt pái casâi, bữn cũai toâq atỡng Yuda neq: “Tamar, cumân mới, khoiq cỡt ariang mansễm chếq tỗ chơ. Sanua án ỡt mumiaq, la cỗ án táq ngkíq.” Ngkíq Yuda ớn cũai ki neq: “Dững aloŏh án! Chơ bốh chíq!” ");
INSERT INTO bru_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Bo noau ntôm dững mansễm ki loŏh, án cơiq parnai pỡ yacũn án neq: “Samiang ca ndỡm crơng nâi, lứq án toâp táq yỗn hếq cỡt mumiaq. Hếq sễq anhia nhêng sambễt tếc cớp ralỡng nâi la khong noau.” ");
INSERT INTO bru_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda sacoal crơng ki, chơ án pai neq: “Cũai mansễm nâi tanoang lứq, yuaq cứq tỡ bữn yỗn Sê-lah con samiang cứq ĩt án táq lacuoi.” Ma Yuda tỡ bữn bếq noâng cớp mansễm ki. ");
INSERT INTO bru_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Toâq ngư mansễm ki canỡt con, án bữn con samiang cartuan. ");
INSERT INTO bru_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Bo án cheq ễ sễt con, lám muoi aloŏh atĩ, cớp cũai ca chuai mansễm ki, án chŏ́q priei cusâu tâng atĩ con ki, chơ án pai neq: “Carnễn nâi loŏh nhũang.” ");
INSERT INTO bru_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma con ki arũiq loah atĩ amut, ma con bar ki loŏh nhũang. Chơ cũai ca chuai mansễm ki pai neq: “Lứq án khoiq carlíq loŏh nhũang.” Ngkíq Yuda amứh con ki la Pharêt. ");
INSERT INTO bru_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ntun ễn a‑ễm án loŏh tê. Con nâi bữn priei cusâu tâng atĩ án. Ngkíq, Yuda amứh con nâi la Sê-rah. ");
INSERT INTO bru_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Máh cũai It-ma-el khoiq dững Yô-sep pỡ cruang Ê-yip-tô, chơ chếq án yỗn Phô-ti-pha. Phô-ti-pha la cũai sốt tỗp tahan kĩaq puo Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yiang Sursĩ ỡt cớp Yô-sep. Ranáq ntrớu án táq cỡt o nheq. Cỗ ngkíq, cũai ncháu án ma yỗn án ỡt tâng dống ncháu án loâng. ");
INSERT INTO bru_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Cũai ncháu Yô-sep hữm Yiang Sursĩ chuai níc Yô-sep. Ngkíq án dáng samoât la Yiang Sursĩ toâp táq máh ranáq nâi yỗn Yô-sep bữn cỡt kia. ");
INSERT INTO bru_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Phô-ti-pha sâng bũi pahỡm cớp Yô-sep. Ngkíq án chóh Yô-sep cỡt cũai ayững atĩ bữn chớc toâr lứq. Án chiau yỗn Yô-sep nhêng salĩq nheq dống án, cớp máh mun án hỡ. ");
INSERT INTO bru_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Noap tễ tangái ki Phô-ti-pha yỗn Yô-sep nhêng salĩq nheq dống cớp máh sarái án. Ngkíq Yiang Sursĩ yỗn ŏ́c bốn toâq pỡ dống sũ cũai Ê-yip-tô ki, cớp máh mun tâng dống cớp tâng ruang hỡ la cỗ nhơ tễ Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Phô-ti-pha chiau dũ ramứh mun án yỗn Yô-sep nhêng salĩq. Án tỡ bữn lua ntrớu noâng tễ mun án; án nhêng bĩq crơng sana án ễ cha sâng. Yô-sep la cũai thán riang o, cớp án bán rêng lứq. ");
INSERT INTO bru_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bữn muoi tangái, lacuoi cũai ncháu Yô-sep nhêng chu Yô-sep, chơ pai neq: “Cứq yoc ễ bữn mới.” ");
INSERT INTO bru_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yô-sep pai neq: “Cứq tỡ ễq! Ncháu cứq tỡ bữn clơng ntrớu tễ ranáq tâng dống nâi, yuaq án yỗn cứq nhêng salĩq nheq. ");
INSERT INTO bru_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tâng dống nâi, ncháu cứq khoiq chiau yỗn cứq sốt. Ma tỗ mới toâp án tỡ yỗn cứq sốt, cỗ mới la lứq lacuoi án. Nŏ́q khớn cứq táq ranáq sâuq ngkíq, chơ bữn lôih lứq chóq Yiang Sursĩ?” ");
INSERT INTO bru_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Cu rangái mansễm ki rakiauq níc Yô-sep; ma Yô-sep tỡ bữn pruam cớp án, dếh tỡ ễq ỡt cheq án hỡ. ");
INSERT INTO bru_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bữn muoi tangái Yô-sep mut tâng dống ki, ễ táq ranáq án. Tỡ va manoaq cũai samiang táq ranáq ma ỡt tâng dống ki. ");
INSERT INTO bru_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ngkíq lacuoi ncháu án catoâng au án cớp pai neq: “Sanua mới cóq bếq cớp cứq.” Ma Yô-sep croaiq táh chíq au tuar án, cớp án lúh aloŏh yáng tiah dống. ");
INSERT INTO bru_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Toâq mansễm ki hữm Yô-sep táh loâng au tuar tâng atĩ án, cớp lúh aloŏh yáng tiah hỡ, ");
INSERT INTO bru_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","chơ mansễm ki arô cũai samiang táq ranáq tâng dống ki, cớp án pai neq: “Cayac cứq dững amut muoi noaq cũai Hê-brơ nâi, ễq án sarhóng cứq. Án mut tâng clống cứq dốq bếq, chơ án ễ bếq cớp cứq. Ma cứq hễr-hŏh casang lứq. ");
INSERT INTO bru_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tữ cứq hễr, án croaiq táh chíq au án. Chơ án lúh aloŏh yáng tiah dống.” ");
INSERT INTO bru_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ngkíq mansễm ki dŏq au ki toau cayac án chu. ");
INSERT INTO bru_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Chơ mansễm ki atỡng loah santoiq án khoiq atỡng tễ nhũang chơ. Án pai neq: “Cũai samiang tỗp Hê-brơ ca mới dững amut yỗn táq ranáq tâng dống hái, án toâq pỡ cứq yoc ễ bếq cớp cứq. ");
INSERT INTO bru_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ma tữ cứq hễr casang lứq, án croaiq táh chíq au án. Chơ án lúh aloŏh yáng tiah dống.” ");
INSERT INTO bru_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Toâq ncháu Yô-sep sâng santoiq lacuoi án pai: “Cũai samiang ca mới yỗn táq ranáq tâng dống hái, án khoiq táq nneq chóq cứq,” ki án nhôp ngưr tháng. ");
INSERT INTO bru_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Chơ án cỗp Yô-sep, cớp chóq tâng cuaq, la ntốq puo kháng cũai lôih. Yô-sep cỡt cũai tũ tâng cuaq ki tê. ");
INSERT INTO bru_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ma Yiang Sursĩ noâng ỡt cớp Yô-sep cớp chuai Yô-sep. Yiang Sursĩ táq yỗn cũai sốt tâng cuaq ki sâng bũi pahỡm cớp Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ngkíq cũai sốt cuaq ki yỗn Yô-sep nhêng salĩq nheq máh cũai tũ tâng cuaq ki. Cớp cũai sốt cuaq ki chiau yỗn Yô-sep nhêng máh cũai ki. ");
INSERT INTO bru_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Cũai sốt cuaq ki tỡ bữn lua ntrớu tễ máh ranáq án khoiq yỗn Yô-sep táq, cỗ Yiang Sursĩ ỡt cớp Yô-sep, cớp yỗn Yô-sep táq ranáq o níc. ");
INSERT INTO bru_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ntun ki bữn muoi tangái bar náq ayững atĩ puo cruang Ê-yip-tô táq sâuq chóq puo. Án ca muoi la sốt cũai dốq dững crơng yỗn puo nguaiq. Ma án ca bar ễn la sốt cũai táq bễng yỗn puo cha. ");
INSERT INTO bru_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ngkíq puo sâng cutâu lứq tâng mứt án chóq bar náq cũai ayững atĩ ki. ");
INSERT INTO bru_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Puo chóq bar náq ki tâng cuaq tũ bân ntốq Yô-sep ỡt. Cuaq nâi ỡt tâng dống cũai sốt tahan kĩaq puo. Puo ớn cũai sốt ki nhêng bar náq ayững atĩ án hỡ. ");
INSERT INTO bru_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Cũai sốt tahan ớn yỗn Yô-sep nhêng bar náq cũai ayững atĩ ki. Ngkíq Yô-sep nhêng salĩq bar náq ki. Toâq bar náq ki ỡt tũ tâng ntốq ki khoiq dũn, ");
INSERT INTO bru_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","bữn muoi sadâu, alới rláu mpáu; ma alới mpáu miar ramứh. Cớp cũai sốt aloŏh crơng nguaiq mpáu mpha tễ cũai sốt aloŏh bễng mi. ");
INSERT INTO bru_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Poang tarưp, Yô-sep toâq pỡ alới bar náq ki, cớp án hữm alới ngua. ");
INSERT INTO bru_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ngkíq án blớh alới bar náq neq: “Ntrớu ca táq anhia ngua tangái nâi?” ");
INSERT INTO bru_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Alới ta‑ỡi neq: “Hếq rláu mpáu, ma tỡ bữn noau têq atỡng tễ ramứh hếq rláu mpáu ki.” Yô-sep ta‑ỡi alới neq: “Ống Yiang Sursĩ sâng têq atỡng tễ ramứh cũai rláu mpáu. Sễq anhia sarŏh parnáu rláu mpáu yỗn cứq tamứng.” ");
INSERT INTO bru_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Án ca sốt cũai aloŏh crơng nguaiq yỗn puo atỡng Yô-sep tễ án mpáu neq: “Cứq hữm muoi ntreh voar ỡt choâng moat cứq. ");
INSERT INTO bru_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Voar ki cỡt pái abễng. Moâm án dáh, chơ án piar, cớp án cỡt tangcóq palâi nho. ");
INSERT INTO bru_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tâng atĩ cứq yống cachoc puo, cớp cứq kéh palâi nho ki; chơ cứq pát palâi ki yỗn dỡq hoi tâng cachoc puo. Moâm ki cứq avơi cachoc ki yỗn puo.” ");
INSERT INTO bru_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yô-sep atỡng án neq: “Ramứh mới rláu mpáu la neq: Pái abễng ki la sacâm tễ pái tangái. ");
INSERT INTO bru_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Noâng pái tangái ễn puo ễ arô mới yỗn loŏh tễ cuaq nâi, cớp án chóh loah mới ĩn ranáq mới khoiq táq tễ nhũang chơ. Mới lứq bữn avơi cachoc yỗn puo sĩa, machớng mới khoiq táq tễ nhũang chơ. ");
INSERT INTO bru_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Toâq mới bữn cỡt ien khễ chơ, sễq mới chỗi khlĩr cứq nơ. Khân mới saryóq cứq, ki cứq sễq mới atỡng tễ cứq yỗn puo dáng tê. Sễq mới chuai cứq yỗn têq loŏh tễ cuaq nâi. ");
INSERT INTO bru_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Lứq pĩeiq noau parỗn cứq tễ cruang Hê-brơ. Cớp ỡt tâng cruang nâi, cứq tỡ bữn táq ranáq tỡ o ntrớu yỗn noau têq chóq cứq tâng cuaq tũ nâi.” ");
INSERT INTO bru_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tữ án ca sốt cũai aloŏh bễng mi hữm Yô-sep atỡng tễ ŏ́c rláu mpáu lứq pĩeiq, ngkíq án sarŏh tê yỗn Yô-sep tamứng tễ parnáu án mpáu neq: “Cứq mpáu neq: Cứq hữm pái lám padien bễng; padien ki acữn cỡt pái tran tâng plỡ cứq. ");
INSERT INTO bru_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Padien muoi bữn bễng dũ ramứh puo mác cha. Ma bữn chớm srúh tâng padien; án tot cha máh bễng tâng padien tâng pỡng plỡ cứq.” ");
INSERT INTO bru_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yô-sep ta‑ỡi neq: “Lứq samoât, ŏ́c mới rláu mpáu tễ pái lám padien ki, la sacâm tễ pái tangái. ");
INSERT INTO bru_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Noâng pái tangái puo arô mới yỗn loŏh tễ cuaq nâi, ma án ớn noau cŏ́h tacong mới, cớp ayŏ́ng tỗ mới tâng aluang. Chơ chớm toâq tot cha nheq máh sâiq mới.” ");
INSERT INTO bru_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Chơ toâq pái tangái, puo táq muoi pêl toâr yỗn máh cũai ranễng án cha bũi. Tangái ki, alới táq rit sanhữ tangái mpiq puo canỡt án. Chơ án dững aloŏh alới bar náq ayững atĩ, cũai sốt aloŏh crơng nguaiq cớp cũai sốt aloŏh bễng. ");
INSERT INTO bru_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Cũai sốt aloŏh crơng nguaiq, ki puo chóh loah án yỗn táq ranáq riang án khoiq táq tễ nhũang. Chơ cũai ki aloŏh loah cachoc yỗn puo. ");
INSERT INTO bru_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma cũai sốt aloŏh bễng, ki puo ayŏ́ng tỗ án tâng aluang. Ngkíq, santoiq Yô-sep atỡng cỡt rapĩeiq nheq. ");
INSERT INTO bru_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ma cũai sốt aloŏh crơng nguaiq, án tỡ bữn sanhữ noâng Yô-sep. Án khlĩr tháng. ");
INSERT INTO bru_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Vớt bar cumo, puo ễn rláu mpáu. Án mpáu ỡt tayứng tâng tor crỗng Nil. ");
INSERT INTO bru_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Chơ án hữm tapul lám ntroŏq plứm o lứq loŏh tễ crỗng ki. Moâm charán ki loŏh, chơ án cha bát. ");
INSERT INTO bru_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Moâm ki puo hữm tapul lám ễn ntroŏq loŏh tễ crỗng ki. Ntroŏq nâi tỡ bữn plứm o ntrớu; án oiq lứq. Án toâq ỡt parnơi cớp ntroŏq ca toâq tễ nhũang tâng tor crỗng ki. ");
INSERT INTO bru_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ngkíq tỗp ntroŏq oiq ki lưn chíq tỗp ntroŏq plứm o. Moâm ki án satŏh tamỡ. ");
INSERT INTO bru_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Chơ puo bếq loah, cớp án rláu mpáu sĩa. Trỗ nâi án hữm muoi nỡm saro bữn tapul racong chong o lứq. ");
INSERT INTO bru_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Cớp án hữm tapul racong ễn loŏh tapun tapul racong o ki. Tapul racong loŏh ntun ki tatễp, yuaq bữn cuyal ỡt ploaq rêng lứq tâng tapul racong ki. ");
INSERT INTO bru_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ngkíq tapul racong moang tatễp lưn chíq tapul racong chong o ki. Moâm ki, puo satŏh tamỡ loah. Án dáng samoât lứq án rláu mpáu sâng. ");
INSERT INTO bru_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Toâq poang tarưp, án sâng tỡ bữn ien tâng mứt pahỡm. Ngkíq án arô nheq máh cũai mo khớt, cớp máh cũai rangoaiq ỡt tâng cruang Ê-yip-tô. Chơ án atỡng yỗn máh cũai ki tamứng tễ parnáu án rláu mpáu. Ma tỡ bữn cũai aléq têq atỡng tễ ramứh án mpáu ki. ");
INSERT INTO bru_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ma bữn cũai ayững atĩ ca sốt ranáq aloŏh crơng nguaiq yỗn puo atỡng puo neq: “Sanua hếq mbỡiq sanhữ loah, hếq khoiq táq ranáq lôih chơ. ");
INSERT INTO bru_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hếq sanhữ, bo anhia sâng cutâu tâng mứt chóq hếq bar náq ayững atĩ anhia, chơ anhia yỗn cũai sốt tahan kháng hếq tâng cuaq tũ. Bữn hếq cớp cũai sốt aloŏh bễng, hếq bar náq ỡt tâng cuaq tũ pỡ dống cũai sốt tahan. ");
INSERT INTO bru_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ma bữn muoi sadâu hếq bar náq rláu mpáu, ma hếq miar mpáu, manoaq mpha tễ manoaq. ");
INSERT INTO bru_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ma ntốq ki bữn muoi noaq cũai póng tễ tỗp Hê-brơ; án táq ranáq yỗn cũai sốt tahan kĩaq nhêng anhia. Hếq atỡng yỗn cũai Hê-brơ ki tamứng máh ŏ́c hếq khoiq rláu mpáu. ");
INSERT INTO bru_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Án atỡng tễ ramứh hếq mpáu ki pĩeiq lứq. Anhia khoiq chóh loah hếq yỗn táq ranáq anhia ĩn tễ nhũang chơ. Ma ayững atĩ anhia canŏ́h, ki anhia ayŏ́ng tâng aluang.” ");
INSERT INTO bru_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tữ puo sâng santoiq ki, án ớn noau pỡq ĩt Yô-sep dững aloŏh chái tễ cuaq ki. Ngkíq Yô-sep cũah sóc bễc cớp tâc tampâc tamái. Moâm ki, án pỡq ramóh puo. ");
INSERT INTO bru_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Puo atỡng Yô-sep neq: “Cứq rláu mpáu, ma ŏ́q cũai têq atỡng cứq tễ ramứh cứq mpáu ki. Cứq khoiq sâng noau pai têq mới atỡng ŏ́c tễ parnáu rláu mpáu.” ");
INSERT INTO bru_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yô-sep ta‑ỡi neq: “Ranáq têq atỡng ŏ́c tễ parnáu rláu mpáu, cứq tỡ têq táq bữm. Ma lứq Yiang Sursĩ toâp yỗn puo dáng raloaih tễ ramứh ki.” ");
INSERT INTO bru_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Chơ puo sarŏh loah yỗn Yô-sep tamứng neq: “Tâng parnáu cứq rláu mpáu, la cứq tayứng tâng tor crỗng Nil. ");
INSERT INTO bru_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Cứq hữm tapul lám ntroŏq plứm o lứq loŏh tễ crỗng cớp cha bát pễr tor dỡq ki. ");
INSERT INTO bru_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Moâm ki cứq hữm tapul lám ễn ntroŏq loŏh tễ crỗng ki. Ma tỗp ntroŏq nâi tỡ bữn plứm o ntrớu, oiq lứq. Salễh lứq ŏ́c nâi, cứq tỡ nai hữm ntroŏq sâuq lứq ariang tỗp ki tâng cruang Ê-yip-tô nâi. ");
INSERT INTO bru_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ma tỗp ntroŏq sâuq cớp oiq, lưn nheq máh ntroŏq plứm o. ");
INSERT INTO bru_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ma tam tỗp ki lưn nheq máh tỗp ntroŏq loŏh nhũang tễ dỡq ki, ma noâng oiq patoat tiaq sĩa. Moâm ki cứq satŏh tamỡ. ");
INSERT INTO bru_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Chơ cứq bếq loah, ma cứq mpáu sĩa. Cứq hữm tapul racong saro chong o ki loŏh tễ muoi nỡm saro. ");
INSERT INTO bru_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Cớp cứq hữm tapul racong tatễp ễn, loŏh ntun tapul racong chong o ki. Bữn cuyal ỡt ploaq rêng lứq, ngkíq saro ki tỡ o. ");
INSERT INTO bru_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ma racong saro tatễp lưn chíq racong saro chong o. Nheq santoiq nâi cứq khoiq ruaih yỗn máh cũai mo khớt sâng, ma tỡ bữn noau têq atỡng cứq tễ ramứh ki.” ");
INSERT INTO bru_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Moâm puo atỡng ngkíq, Yô-sep ta‑ỡi án neq: “Bar ŏ́c parnáu nâi cỡt muoi ŏ́c sâng. Yiang Sursĩ apáh yỗn puo dáng án ễ táq ntrớu. ");
INSERT INTO bru_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tapul lám ntroŏq plứm o la sacâm tễ tapul cumo. Cớp tapul racong saro chong o la sacâm tễ tapul cumo tê. Bar ŏ́c ki cỡt muoi ramứh sâng. ");
INSERT INTO bru_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Cớp tapul lám ntroŏq sâuq cớp oiq, machớng cớp tapul racong saro tatễp ca cuyal ỡt ploaq rêng lứq, ŏ́c ki sacâm tễ tapul cumo cỡt panhieih khlac tâng cruang nâi. ");
INSERT INTO bru_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Machớng cứq khoiq atỡng anhia, ống Yiang Sursĩ toâp apáh yỗn puo dáng máh ranáq án ễ táq ntun nâi. ");
INSERT INTO bru_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Anhia tamứng o! Bữn tapul cumo cruang Ê-yip-tô bữn khám crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ma tapul cumo ntun ễn, tỡ bữn bữn ntrớu noâng, toau anhia khlĩr nheq tễ tapul cumo bữn sa‑ữi crơng sana, yuaq tapul cumo ntun, cruang nâi cỡt ŏ́q lứq crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ngkíq máh cũai Ê-yip-tô khlĩr chíq cumo bữn crơng sana, yuaq ŏ́c panhieih khlac ki la ntâng lứq. ");
INSERT INTO bru_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ma tễ ŏ́c puo mpáu bar trỗ, ŏ́c nâi la Yiang Sursĩ khoiq anoat chơ, cớp tỡ bữn dũn noâng Yiang Sursĩ táq yỗn ŏ́c nâi toâq. ");
INSERT INTO bru_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Yuaq ngkíq, sễq puo rưoh manoaq rangoaiq, chơ chóh án yỗn nhêng salĩq nheq máh cruang Ê-yip-tô nâi. ");
INSERT INTO bru_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Cớp sễq puo chóh loah máh cũai canŏ́h ễn dŏq parỗm crơng sana tâng tapul cumo bữn pasâi chũop cruang Ê-yip-tô. Yỗn alới ĩt muoi pún tễ sỡng pún, chơ parỗm dŏq. ");
INSERT INTO bru_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ngkíq máh cũai sốt ranáq ki cóq ĩt parỗm máh crơng sana tâng tapul cumo bữn sa‑ữi crơng sana. Chơ cóq alới dŏq crơng sana ki pỡ ntốq puo táq sốt. Cóq alới dŏq crơng sana nâi tâng vil cớp kĩaq yỗn samoât. ");
INSERT INTO bru_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Máh crơng sana nâi cóq thrũan dŏq tâng tapul cumo ntun bo cutễq tỡ têq amia crơng sana ntrớu tâng cruang Ê-yip-tô. Táq ngkíq, máh cũai tâng cruang nâi tỡ bữn cuchĩt cỗ tian ŏ́c panhieih khlac.” ");
INSERT INTO bru_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Moâm Yô-sep atỡng, puo cớp máh cũai ca sâng santoiq ki, alới sâng pĩeiq lứq. ");
INSERT INTO bru_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ngkíq puo atỡng máh cũai ayứng atĩ án neq: “Pỡ léq hái têq chuaq yỗn tamóh ĩn cũai nâi; án bữn Raviei Yiang Sursĩ ỡt cớp án.” ");
INSERT INTO bru_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Chơ puo atỡng Yô-sep neq: “Cỗ Yiang Sursĩ khoiq yỗn mới dáng tễ máh ramứh nâi, lứq samoât tỡ bữn cũai aléq noâng khễuq cớp rangoaiq ariang mới. ");
INSERT INTO bru_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Cứq ễ chóh mới yỗn cỡt cũai nhêng salĩq nheq máh proai cứq, cớp alới cóq trĩh parnai mới. Ống cứq toâp bữn chớc toâr hỡn tễ mới.” ");
INSERT INTO bru_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Chơ puo pai ễn chóq Yô-sep: “Cứq ễ chóh mới yỗn cỡt sốt nheq máh cruang Ê-yip-tô nâi.” ");
INSERT INTO bru_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Moâm ki, puo pũot sambễt tễ atĩ án. Sambễt nâi la tếc chớc puo, chơ án chóq sambễt ki tâng atĩ Yô-sep. Cớp án asớp tampâc táq toâq aroâiq chễp o lứq yỗn Yô-sep, dếh chóq sanoâc yễng tâng tacong Yô-sep hỡ. ");
INSERT INTO bru_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Chơ puo yỗn Yô-sep sễ kĩen bữn bar ayững ariang cũai sốt pưn án dốq bữn. Cớp bữn tahan pỡq nhũang pau neq: “Pang yơng tễ rana, yỗn cũai sốt pỡq!” Na ranáq nâi puo chóh Yô-sep yỗn cỡt cũai sốt chũop cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Chơ puo atỡng Yô-sep neq: “Cứq la puo máh cũai tâng cruang Ê-yip-tô nâi, ma cứq tỡ yỗn cũai aléq táq ntrớu tỡ la pỡq chu nâi chu ki, khân mới ma tỡ bữn yỗn.” ");
INSERT INTO bru_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Puo amứh Yô-sep ramứh tamái ễn la Saphe-nat Pania, cớp án yỗn Yô-sep manoaq mansễm ramứh A-sanat yỗn táq lacuoi. Mpoaq A-sanat ramứh Phô-ti-phê-ra cỡt cũai tễng rit sang tâng vil Ôn. Ngkíq Yô-sep cỡt sốt chũop nheq tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yô-sep bữn pái chít cumo bo án mbỡiq táq ranáq yỗn puo cruang Ê-yip-tô. Án loŏh tễ puo, chơ pỡq sa‑óh chũop nheq tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tâng tapul cumo ca bữn sa‑ữi muo, cutễq amia máh crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Chơ tâng tapul cumo ki Yô-sep parỗm máh crơng sana tâng cruang Ê-yip-tô. Cớp án tampễq dŏq máh crơng sana ki dŏq tâng dũ vil. Máh palâi sarnóh tễ vil léq án yỗn dŏq tâng vil ki loâng. ");
INSERT INTO bru_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yô-sep parỗm bữn sa‑ữi lứq máh crơng sana, toau cỡt ariang chũah tâng tor dỡq mưt. Ngkíq án tỡ rơi ngih noâng, cỗ crơng sana nâi sa‑ữi la‑ỡq. ");
INSERT INTO bru_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nhũang ễ toâq cumo tỡ bữn cỡt muo ntrớu, Yô-sep bữn bar lám con samiang. Mpiq bar lám con ki ramứh A-sanat con Phô-ti-phê-ra, la cũai tễng rit sang tâng vil Ôn. ");
INSERT INTO bru_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yô-sep amứh con clúng án la Ma-nasê, cớp án pai neq: “Cỗ Yiang Sursĩ táq yỗn cứq khlĩr nheq máh ŏ́c túh arức, cớp nheq tữh dống sũ mpoaq cứq.” ");
INSERT INTO bru_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yô-sep amứh con ndĩ la Ep-ra-im, cớp án pai neq: “Yiang Sursĩ khoiq yỗn cứq bữn moang ŏ́c o sâng tâng cruang cứq ramóh ŏ́c túh ngua.” ");
INSERT INTO bru_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tapul cumo ca bữn sa‑ữi máh crơng sana tâng cruang Ê-yip-tô vớt chơ. ");
INSERT INTO bru_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ki toâq tapul cumo ŏ́q lứq ễn crơng sana, cỡt pĩeiq santoiq Yô-sep khoiq pai tễ nhũang chơ. Cớp nheq tữh cruang canŏ́h la ŏ́q tê. Ma dũ ntốq tâng cruang Ê-yip-tô noâng bữn dũ crơng sana cha. ");
INSERT INTO bru_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Toâq cũai Ê-yip-tô cỡt panhieih, alới pỡq susễq crơng sana tễ puo. Ma puo ớn nheq tữh cũai Ê-yip-tô ki neq: “Anhia pỡq chu Yô-sep. Ntrớu án ớn anhia táq, anhia cóq táq ngkíq.” ");
INSERT INTO bru_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ŏ́c panhieih khlac pláh dũ ntốq tâng cruang Ê-yip-tô. Chơ Yô-sep pớh máh dống án dŏq crơng sana, chếq yỗn cũai Ê-yip-tô chỡng. ");
INSERT INTO bru_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ma hỡn tễ ki ễn, bữn cũai tễ dũ cruang canŏ́h toâq pỡ cruang Ê-yip-tô yoc ễ chỡng crơng sana tễ Yô-sep, cỗ tian dũ cruang ŏ́q lứq tê. ");
INSERT INTO bru_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Toâq Yacốp sâng noau pai cruang Ê-yip-tô bữn crơng sana, ngkíq án atỡng con samiang án neq: “Nŏ́q anhia manoaq tacu cloân chu manoaq sâng?” ");
INSERT INTO bru_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Án pai ễn neq: “Cứq sâng noau pai tâng cruang Ê-yip-tô bữn crơng sana. Cóq anhia sễng pỡ ki, chỡng crơng sana yỗn hái têq bữn tamoong cớp vớt tễ cuchĩt khlac.” ");
INSERT INTO bru_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ngkíq, máh ai Yô-sep muoi chít náq sễng pỡ cruang Ê-yip-tô yỗn chỡng crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Ben-yamin a‑ễm Yô-sep, ki Yacốp tỡ yỗn pỡq cớp máh ai án, yuaq án ngcŏh Ben-yamin tamóh ŏ́c croŏq. ");
INSERT INTO bru_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ngkíq máh con samiang I-sarel pỡq pỡ cruang Ê-yip-tô. Cỗ tian tâng cruang Cana-an ŏ́q lứq crơng sana, alới yoc ễ pỡq chỡng crơng sana machớng cũai canŏ́h chỡng tê. ");
INSERT INTO bru_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tangái ki Yô-sep cỡt sốt nheq tâng cruang Ê-yip-tô; ống án toâp têq chếq crơng sana ki yỗn cũai ca toâq pỡ cruang Ê-yip-tô. Ngkíq máh ai Yô-sep toâq pỡ án cớp cucốh cucũoi choâng moat án. ");
INSERT INTO bru_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Toâq Yô-sep hữm máh ai án, án sacoal alới. Ma án táq nan tỡ sacoal. Chơ án táq ntỡng cớp alới canháng lứq. Án blớh alới neq: “Tễ léq anhia toâq?” Alới ta‑ỡi: “Hếq toâq tễ cruang Cana-an, toâq yoc ễ chỡng crơng sana cha.” ");
INSERT INTO bru_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Tam Yô-sep sacoal máh ai án, alới tỡ bữn sacoal noâng án. ");
INSERT INTO bru_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Chơ Yô-sep chanchớm loah tễ ŏ́c án rláu mpáu, toâq án hữm máh ai án. Ngkíq án pai chóq alới neq: “Anhia la cũai pỡq tutuaiq cruang nâi. Anhia toâq pỡ nâi, cỗ yoc ễ dáng ntốq aléq ieuq tâng cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ma máh ai án ta‑ỡi neq: “Cucốh achuaih ơi, tỡ cỡn ngkíq; hếq la cũai táq ranáq yỗn achuaih toâq pỡ nâi cỗ yoc ễ chỡng crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nheq tữh hếq nâi la muoi mpoaq. Hếq la cũai tanoang tapứng. Hếq la tỡ cỡn cũai toâq tutuaiq.” ");
INSERT INTO bru_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ma Yô-sep pai sĩa neq: “Anhia pai tỡ bữn lứq. Anhia toâq yoc ễ nhêng maléq rêng cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ma alới ta‑ỡi loah neq: “Hếq abŏh nâi la muoi chít la bar náq sễm ai. Hếq la muoi mpoaq sâng, ỡt tâng cruang Cana-an. Sanua con ralŏ́h mpoaq hếq noâng ỡt cớp án. Ma bữn muoi lám ễn con samiang án khoiq pứt chơ.” ");
INSERT INTO bru_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yô-sep ta‑ỡi alới neq: “Lứq pĩeiq cứq pai adớh anhia toâq tutuaiq. ");
INSERT INTO bru_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Cứq ễ chim salĩq anhia muoi ŏ́c nâi. Cứq arô ramứh puo cớp thễ dũan cớp anhia neq: Khân anhia tỡ bữn dững a‑ễm ralŏ́h anhia toâq pỡ nâi, ki lứq samoât anhia tỡ têq loŏh tễ nâi. ");
INSERT INTO bru_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ngkíq anhia cóq ớn manoaq tễ tỗp anhia chu coâiq a‑ễm ralŏ́h anhia, yỗn án toâq pỡ nâi. Máh canŏ́h ki cóq ỡt tâng cuaq nâi voai. Cứq chim salĩq parnai anhia pai, lứq ma tỡ bữn. Khân tỡ bữn lứq, ki anhia la cũai toâq tutuaiq ơiq.” ");
INSERT INTO bru_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Chơ Yô-sep ớn noau kháng nheq alới tâng cuaq, pái tangái. ");
INSERT INTO bru_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Vớt pái tangái, Yô-sep atỡng alới neq: “Khân anhia trĩh parnai cứq, ki anhia bữn tamoong. Yuaq cứq yám noap Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Khân anhia ma lứq tanoang, ki yỗn manoaq tễ anhia ỡt loah tâng cuaq nâi. Ma canŏ́h ki, dững achu crơng sana nâi dŏq siem cũai tâng dống sũ anhia. ");
INSERT INTO bru_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ma cóq anhia dững a‑ễm ralŏ́h anhia toâq pỡ cứq. Khân anhia táq ngkíq, máh parnai anhia pai ki lứq pĩeiq, cớp anhia tỡ bữn cuchĩt.” Chơ alới trĩh parnai Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Alới manoaq táq ntỡng cớp manoaq neq: “Lứq samoât, hái khoiq táq lôih chóq a‑ễm hái chơ. Bo ki hái hữm mứt pahỡm án túh ngua lứq; án sễq hái acláh, ma hái tỡ bữn tamứng. Yuaq ngkíq, ŏ́c bap ki toâq loah pỡ hái.” ");
INSERT INTO bru_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma Ruben atỡng alới neq: “Cứq khoiq sưoq anhia pai: Chỗi táq sâuq ntrớu chóq án. Ma anhia tỡ bữn tamứng cứq. Sanua tôt tễ aham án tahóc ễ toâq loah pỡ hái.” ");
INSERT INTO bru_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Máh ai án tỡ bữn dáng pai Yô-sep dáng santoiq alới pai, yuaq bữn cũai parlong parnai yỗn án dáng. ");
INSERT INTO bru_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ngkíq Yô-sep pỡq chíq tễ máh ai án, cớp án nhiam. Moâm ki, án píh loah cớp atỡng alới ễn. Ma án rưoh Si-mê-ôn tễ tỗp alới, cớp án ớn noau chŏ́q Si-mê-ôn choâng moat máh ai án. ");
INSERT INTO bru_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Moâm ki, Yô-sep ớn cũai táq ranáq án tadĩng saro chóq tâng bau ai án. Cớp án ớn noau culáh loah práq tỗp alới. Práq cũai aléq cóq chóq loah tâng bau cũai ki. Dếh yỗn dũ náq bữn sanyam hỡ. Ngkíq nheq ramứh ki noau táq yỗn sễm ai án. ");
INSERT INTO bru_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Chơ alới patiang moâm nheq máh crơng sana tâng cloong aséh dễn. ");
INSERT INTO bru_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tữ toâq pỡ ntốq alới ễ rlu sadâu, bữn manoaq pớh muoi bau yoc ễ yỗn aséh dễn cha. Ngkíq án hữm práq án ỡt tâng ngoah bau ki. ");
INSERT INTO bru_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Chơ án pai cớp sễm ai án neq: “Práq cứq noau culáh loah. Anhia nhêng nâi! Práq nâi ỡt tâng bau cứq.” Ngkíq nheq tữh sễm ai án sâng dớt lứq. Cớp alới croŏq tê. Manoaq blớh manoaq neq: “Ranáq ntrớu Yiang Sursĩ táq chóq hái?” ");
INSERT INTO bru_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Toâq alới chu toâq pỡ Yacốp mpoaq alới pỡ cruang Cana-an, alới atỡng loah máh ramứh alới khoiq hữm chơ. ");
INSERT INTO bru_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Alới pai neq: “Manoaq ca cỡt sốt tâng cruang Ê-yip-tô, án táq ntỡng santoiq canháng lứq chóq hếq. Án pai hếq cỡt cũai pỡq tutuaiq cruang án. ");
INSERT INTO bru_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma hếq ta‑ỡi án neq: ‘Hếq la cũai tanoang lứq. Hếq tỡ cỡn cũai pỡq tutuaiq cruang nâi. ");
INSERT INTO bru_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hếq muoi chít la bar náq la sễm ai muoi mpoaq. Ma bữn manoaq khoiq pứt chơ. Cớp bữn manoaq a‑ễm ralŏ́h ỡt cớp mpoaq hếq sanua tâng cruang Cana-an.’ ");
INSERT INTO bru_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tữ cũai sốt cruang ki sâng ngkíq, án atỡng hếq neq: ‘Khân anhia tanoang tapứng, cóq anhia táq muoi ramứh neq: Yỗn manoaq tễ anhia ỡt loah cớp cứq. Ma canŏ́h, ki yỗn dững achu crơng sana nâi dŏq siem dống sũ anhia. ");
INSERT INTO bru_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ma cóq anhia dững a‑ễm ralŏ́h anhia toâq pỡ cứq. Ngkíq cứq têq dáng anhia tỡ bữn toâq tutuaiq cruang cứq, cớp máh santoiq anhia pai ki lứq pĩeiq. Chơ cứq culáh loah ai anhia, cớp anhia têq chếq chỡng tâng cruang nâi hỡ.’” ");
INSERT INTO bru_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Moâm alới pai ngkíq, alới satốh saro tễ bau. Dũ náq hữm loah caryớm práq alới tâng bau. Tữ alới hữm práq ki, alới cớp mpoaq alới sâng croŏq lứq tâng mứt. ");
INSERT INTO bru_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma Yacốp mpoaq alới pai neq: “Anhia táq yỗn cứq pứt loah con ễn. Yô-sep khoiq pứt chơ. Sanua Si-mê-ôn ễn pứt. Ma noâng anhia yoc ễ ĩt Ben-yamin ễn. Nŏ́q máh ŏ́c tỗiq bap nâi toâq níc pỡ cứq?” ");
INSERT INTO bru_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben atỡng mpoaq án neq: “Khân cứq tỡ bữn dững Ben-yamin chu loah pỡ mpoaq, ki mpoaq cachĩt chíq bar náq con samiang cứq. Sễq mpoaq chiau Ben-yamin yỗn cứq bán kĩaq. Cứq lứq dững án chu loah pỡ mpoaq.” ");
INSERT INTO bru_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Yacốp ta‑ỡi loah án neq: “Cứq tỡ bữn pruam yỗn con samiang cứq nâi pỡq cớp anhia. Ai án khoiq cuchĩt chơ. Ma noâng ống án toâp tễ mpiq ki. Khân án ramóh ŏ́c croŏq tâng rana bo anhia pỡq, ki anhia táq yỗn cứq cũai thâu nâi bữn sâng ngua la‑ỡq. Chơ ễ cuchĩt toâp.” ");
INSERT INTO bru_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Máh cũai tâng cruang Cana-an cỡt panhieih lứq ễn. ");
INSERT INTO bru_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Toâq tangái alới khoiq cha nheq chơ máh crơng sana alới dững achu tễ cruang Ê-yip-tô, ki mpoaq alới ớn neq: “Cóq anhia pỡq chỡng loah crơng sana cha.” ");
INSERT INTO bru_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ma Yuda ta‑ỡi mpoaq án neq: “Cũai sốt ki pai chóq hếq neq: ‘Khân anhia tỡ bữn dững a‑ễm ralŏ́h anhia toâq cớp anhia tê, ki anhia tỡ têq hữm noâng cứq.’ ");
INSERT INTO bru_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ngkíq khân mpoaq tỡ bữn yỗn a‑ễm ralŏ́h pỡq nứng hếq, ki nŏ́q têq hếq sễng chỡng crơng sana yỗn mpoaq? ");
INSERT INTO bru_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Khân mpoaq tỡ yỗn án pỡq, ki hếq tỡ ễq pỡq; yuaq cũai sốt ki khoiq atỡng hếq chơ: ‘Khân anhia tỡ bữn dững a‑ễm ralŏ́h anhia toâq cớp anhia, ki anhia tỡ têq hữm noâng cứq.’” ");
INSERT INTO bru_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Chơ I-sarel blớh neq: “Nŏ́q anhia táq sâuq lứq chóq cứq, anhia atỡng yỗn cũai sốt ki dáng pai anhia bữn a‑ễm ralŏ́h?” ");
INSERT INTO bru_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Alới ta‑ỡi neq: “Yuaq cũai sốt ki blớh níc hếq tễ dống sũ. Án blớh neq: ‘Mpoaq anhia noâng tamoong tỡ? Anhia bữn sễm ai ễn tỡ?’ Ngkíq yuaq hếq ta‑ỡi án máh santoiq án khoiq blớh. Mŏ têq hếq dáng án atỡng hếq: ‘Cóq anhia dững a‑ễm ralŏ́h anhia sễng chu nâi tê’?” ");
INSERT INTO bru_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Chơ Yuda atỡng loah I-sarel mpoaq án neq: “Mpoaq yỗn carnễn nâi pỡq cớp cứq. Chơ hếq thrũan pỡq toâp. Ngkíq hái cớp nheq dống sũ hái tỡ bữn cuchĩt khlac. ");
INSERT INTO bru_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Cứq parkhán tễ a‑ễm nâi ŏ́c ntrớu mpoaq ễ yỗn cứq parkhán. Khân cứq mŏ tỡ bữn dững achu a‑ễm ca ỡt choâng moat mpoaq sanua, ki cứq bũi roap tôt mantái níc tễ mpoaq. ");
INSERT INTO bru_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Khân hếq mŏ tỡ bữn acoan dũn nneq, ki hếq khoiq láp chu trỗ bar chơ tễ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Moâm Yuda pai ngkíq, I-sarel atỡng máh con án neq: “Khân ranáq nâi ma lứq ngkíq, ki cóq anhia táq neq: Dững crơng moat lứq tễ cruang nâi, chơ yỗn miat sâng cũai sốt ki. Cóq anhia dững trâm, dỡq khĩal, crơng phuom, siet aluang, cớp palâi aluang ĩn palâi al-mon. ");
INSERT INTO bru_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Anhia ĩt práq dững sa‑ữi hỡn tễ trỗ nhũang, bar pún ễn. Cóq anhia culáh loah práq noau chóq tâng ngoah bau anhia. Anhia dững nheq máh práq nâi, cŏh lơ noau khlâp práq tâng bau. ");
INSERT INTO bru_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Cóq anhia dững a‑ễm ralŏ́h anhia hỡ. Sanua anhia thrũan, chơ pỡq loah pỡ cũai sốt ki. ");
INSERT INTO bru_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Cứq sễq Yiang Sursĩ Sốt Toâr Lứq táq tâng mứt pahỡm cũai sốt ki yỗn án sarũiq táq anhia, cớp culáh loah ai cớp a‑ễm ralŏ́h anhia. Tễ nhũang cứq ngua lứq pứt con, ma sanua ngcŏh cứq cỡt ngua hỡn tễ ki ễn.” ");
INSERT INTO bru_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ngkíq máh ai Yô-sep dững crơng mpon, cớp dững práq bar pún hỡn tễ nhũang. Alới dững Ben-yamin hỡ, chơ pỡq chái sễng chu cruang Ê-yip-tô. Chơ alới toâq ỡt choâng moat Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tữ Yô-sep hữm Ben-yamin toâq nứng alới, án atỡng cũai sốt ranáq tâng dống án neq: “Anhia dững máh cũai nâi mut tâng dống cứq. Chơ kiac muoi lám charán, táq yỗn alới cha. Toâq mandang toâng yỗn alới cha muoi pêl cớp cứq.” ");
INSERT INTO bru_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Cũai ki trĩh nheq máh parnai Yô-sep ớn. Án dững máh ai Yô-sep mut tâng dống Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Sễm ai ki sâng croŏq lứq noau dững alới toâq pỡ dống Yô-sep; chơ manoaq pai chóq manoaq neq: “Cỗ tian práq noau dŏq tâng bau hái bo ki ma noau dững hái pỡ dống nâi. Cũai sốt nâi yoc ễ cauq, chơ cỗp hái. Moâm ki án yỗn hái cỡt cũai sũl, cớp án ndỡm nheq máh aséh dễn hái hỡ.” ");
INSERT INTO bru_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Bo alới mbỡiq mut cheq ngoah toong Yô-sep, alới atỡng cũai sốt ranáq tâng dống Yô-sep neq: ");
INSERT INTO bru_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Sễq lôih achuaih! Hếq toâq pỡ nâi trỗ nhũang yoc ễ chỡng crơng sana. ");
INSERT INTO bru_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tữ hếq toâq pỡ ntốq rlu sadâu, hếq pớh bau, hữm dũ bau bữn cayớm práq; tỡ dáng noau chóq. Sanua hếq dững asuoi loah máh práq ki, ");
INSERT INTO bru_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","cớp dững dếh práq ễ chỡng loah crơng sana hỡ. Hếq tỡ bữn dáng noau chóq loah práq hếq tâng bau.” ");
INSERT INTO bru_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ma cũai táq ranáq ki atỡng loah alới neq: “Chỗi croŏq ntrớu tễ ŏ́c ki; anhia ỡt ien khễ. Yiang Sursĩ anhia cớp mpoaq anhia sang, lứq án toâp táq yỗn anhia bữn crơng moat tâng bau; práq anhia chỡng sana ki cứq khoiq roap chơ.” Moâm án pai ngkíq, án dững aloŏh Si-mê-ôn toâq pỡ máh sễm ai. ");
INSERT INTO bru_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Chơ cũai ki dững máh sễm ai ki mut tâng dống Yô-sep. Án aloŏh dỡq yỗn alới ariau ayững atĩ, cớp yỗn crơng sana yỗn aséh alới cha hỡ. ");
INSERT INTO bru_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Máh tỗp ai Yô-sep thrũan máh crơng mpon yỗn Yô-sep. Alới acoan toâq moat mandang toâng yỗn Yô-sep chu, yuaq alới sâng noau pai alới bữn cha parnơi cớp án. ");
INSERT INTO bru_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Toâq Yô-sep chu pỡ dống, máh ai án chiau máh crơng mpon alới dững tễ dống yỗn án, cớp alới cucốh cucũoi choâng moat án. ");
INSERT INTO bru_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yô-sep cahan alới neq: “Nŏ́q anhia bán sũan tỡ?” Cớp án blớh ễn: “Nŏ́q mpoaq thâu anhia atỡng cứq tễ nhũang, noâng tamoong tỡ, cớp án bữn bán sũan tỡ?” ");
INSERT INTO bru_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Alới ta‑ỡi: “Ơq! Mpoaq hếq, sũl anhia noâng tamoong, cớp án bán sũan.” Bo alới pai ngkíq, alới cucốh níc. ");
INSERT INTO bru_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tữ Yô-sep nhêng Ben-yamin, a‑ễm án muoi mpiq, chơ án blớh neq: “Nâi la a‑ễm ralŏ́h anhia, riang anhia khoiq atỡng cứq tễ nhũang tỡ?” Cớp án atỡng Ben-yamin neq: “Cứq sễq Yiang Sursĩ táq o níc cớp mới, ai nơ!” ");
INSERT INTO bru_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Moâm ki Yô-sep loŏh chái tễ ntốq ki. Yuaq bo án hữm a‑ễm án, án sâng sarũiq lứq tâng mứt. Ngkíq án mut clống án, chơ án nhiam manoaq. ");
INSERT INTO bru_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Moâm ki án culĩaq moat, chơ án píh loah pỡq ntốq ki sĩa. Án tỡ bữn yỗn alới dáng án nhiam. Chơ án atỡng cũai táq ranáq án neq: “Dững amut crơng sana yỗn hếq cha.” ");
INSERT INTO bru_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ngkíq, máh cũai táq ranáq tễng crơng sana aloŏh sana miar yỗn Yô-sep tễ máh sễm ai án. Cớp cũai Ê-yip-tô ca dốq cha tâng dống ki, alới cha miar, cỗ cũai Ê-yip-tô tỡ ễq cha parnơi cớp cũai Hê-brơ. ");
INSERT INTO bru_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Nheq tữh máh sễm ai Yô-sep tacu ỡt yáng moat án. Noau yỗn alới tacu puai cumo alới sễt, tễ ai clúng toau toâq a‑ễm ralŏ́h. Máh sễm ai Yô-sep manoaq cloân manoaq, cớp alới sâng dớt lứq tâng mứt noau yỗn alới tacu ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Chơ Yô-sep ĩt crơng sana avơi yỗn máh sễm ai án. Ma crơng sana Ben-yamin, ki án yỗn sỡng pún hỡn tễ mu ai. Ngkíq alới nguaiq cha bũi óh lứq cớp Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Chơ Yô-sep ớn cũai táq ranáq án neq: “Chóq poân crơng sana tâng bau cũai ki, maléq rơi alới dững. Cớp dŏq loah práq alới dũ náq tâng ngoah bau alới. ");
INSERT INTO bru_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Chóq cachoc práq khong cứq tâng ngoah bau a‑ễm ralŏ́h. Cớp chóq loah máh práq tâng bau án tê.” Ngkíq cũai táq ranáq ki táq puai ĩn parnai Yô-sep pai. ");
INSERT INTO bru_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Toâq poang tarưp, máh sễm ai ki loŏh tễ ntốq ki cớp aséh dễn alới. ");
INSERT INTO bru_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Alới loŏh tễ vil ki, ma alới pỡq tỡ yũah yơng. Chơ Yô-sep atỡng cũai sốt ranáq tâng dống án neq: “Mới rapuai cũai ki. Toâq mới satỡm alới, ki blớh alới neq: ‘Nŏ́q ncháu cứq táq o chóq anhia, ma anhia táq sâuq chóq án? ");
INSERT INTO bru_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nŏ́q anhia tutuoiq cachoc dỡq ncháu cứq? Cachoc dỡq nâi la cachoc ống ncháu hếq sâng dốq nguaiq dỡq, cớp dốq ễ mumưl. Anhia táq ranáq nâi la sâuq lứq!’” ");
INSERT INTO bru_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ngkíq, cũai táq ranáq yỗn Yô-sep rapuai satỡm máh sễm ai ki; cớp án pai ĩn santoiq Yô-sep khoiq atỡng án. ");
INSERT INTO bru_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ma máh sễm ai ki ta‑ỡi án neq: “Cỗ nŏ́q ncháu hếq pai ngkíq? Lứq samoât, hếq tỡ nai chanchớm ễ táq ranáq sâuq ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Máh práq hếq ramóh loah tâng bau, la hếq dững asuoi loah chơ yỗn anhia tễ cruang Cana-an. Hếq ễ tuoiq táq ntrớu práq tỡ la yễng tễ dống ncháu anhia? ");
INSERT INTO bru_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Khân achuaih chuaq tamóh crơng ki tâng bau cũai aléq tễ tỗp hếq ca táq ranáq achuaih, ki yỗn án ki cuchĩt chíq. Ma hỡn tễ ki ễn, nheq náq hếq pruam cỡt sũl ncháu anhia hỡ.” ");
INSERT INTO bru_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Cũai ki ta‑ỡi neq: “Ơq! Thỗi! Anhia táq ĩn anhia khoiq pai nơ. Cũai aléq ma bữn cachoc ki, lứq án cóq cỡt sũl cứq. Ma aléq ca tỡ bữn bữn cachoc ki, ki anhia tỡ bữn lôih ntrớu.” ");
INSERT INTO bru_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ngkíq, dũ náq alới tál tháng acŏ́q asễng bau pỡ cutễq, cớp pớh bau alới. ");
INSERT INTO bru_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Cũai táq ranáq yỗn Yô-sep chuaq nheq dũ bau alới, tễ bau ai clúng toau toâq bau a‑ễm ralŏ́h. Tữ toâq pỡ bau a‑ễm ralŏ́h, án ramóh muoi lám cachoc ki. ");
INSERT INTO bru_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Máh ai án, alới háq tampâc alới, táq tếc alới sâng ngua lứq. Cớp alới patiang loah bau tâng cloong aséh dễn. Chơ alới píh loah chu vil. ");
INSERT INTO bru_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Chơ Yuda cớp nheq máh sễm ai Yô-sep toâq loah pỡ dống Yô-sep. Ma Yô-sep noâng ỡt tâng dống ki. Nheq náq alới cucốh cucũoi sĩa choâng moat Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yô-sep blớh alới neq: “Nŏ́q anhia táq ranáq nâi? Anhia dáng ma tỡ bữn, cứq bữn ngê mumưl?” ");
INSERT INTO bru_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda ta‑ỡi loah neq: “Nŏ́q hếq ễ ta‑ỡi ncháu? Parnai ntrớu hếq ễ ta‑ỡi? Cớp ranáq ntrớu hếq têq táq yỗn anhia dáng hếq tỡ bữn táq ranáq nâi? Yiang Sursĩ toâp dáng ŏ́c lôih hếq. Nheq náq hếq nâi lứq cỡt cũai sũl anhia, dếh án ca bữn cachoc anhia tâng bau hỡ.” ");
INSERT INTO bru_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Yô-sep ta‑ỡi loah án neq: “Cứq tỡ bữn chanchớm ễ táq ranáq ngkíq. Ma án ca ĩt cachoc cứq, lứq án ki toâp cóq cỡt sũl cứq. Ma máh anhia, ki têq anhia chu ien khễ pỡ dống mpoaq anhia.” ");
INSERT INTO bru_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Moâm Yô-sep pai ngkíq, Yuda toâq pỡ án cớp pai neq: “Cứq sễq lôih ncháu! Cứq sễq tễ ncháu muoi ramứh. Cứq sễq ncháu chỗi nhôp cứq, la cũai táq ranáq anhia. Lứq samoât, ncháu bữn chớc lĩ-ralĩ cớp puo. ");
INSERT INTO bru_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tễ nhũang, ncháu khoiq blớh hếq neq: ‘Anhia noâng bữn mpoaq cớp a‑ễm samiang canŏ́h tỡ?’ ");
INSERT INTO bru_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ngkíq hếq ta‑ỡi ncháu neq: ‘Bữn, bữn mpoaq, ma án khoiq thâu chơ. Cớp hếq bữn muoi lám a‑ễm samiang ralŏ́h. Mpoaq hếq amia án bo mpoaq hếq khoiq thâu chơ. Án ki muoi mpiq cớp a‑ễm hếq ca khoiq cuchĩt. Yuaq ngkíq, mpoaq hếq ma ayooq lứq án, cỗ noâng manoaq án toâp tễ mpiq ki.’ ");
INSERT INTO bru_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Moâm ki ncháu atỡng hếq neq: ‘Cóq anhia dững a‑ễm ralŏ́h toâq pỡ cứq; cứq yoc ễ hữm án!’ ");
INSERT INTO bru_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ma hếq ta‑ỡi ncháu neq: ‘Cũai póng nâi, án tỡ têq ratáh tễ mpoaq. Khân án loŏh, ki mpoaq án cuchĩt toâp.’ ");
INSERT INTO bru_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma ncháu khoiq atỡng hếq neq: ‘Khân anhia tỡ bữn dững án toâq cớp anhia, ki anhia tỡ bữn hữm noâng cứq.’ ");
INSERT INTO bru_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ngkíq, toâq hếq chu pỡ mpoaq hếq, la cũai táq ranáq anhia, hếq atỡng loah yỗn án dáng tễ máh parnai ncháu pai. ");
INSERT INTO bru_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ntun ki mpoaq hếq ớn hếq neq: ‘Cóq anhia pỡq chỡng loah máh crơng sana yỗn hái cha.’ ");
INSERT INTO bru_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ma hếq ta‑ỡi án neq: ‘Hếq tỡ têq pỡq khân a‑ễm ralŏ́h ma tỡ bữn pỡq nứng hếq. Khân hếq pỡq ống hếq, la hếq tỡ têq hữm noâng cũai sốt.’ ");
INSERT INTO bru_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Ngkíq mpoaq hếq ta‑ỡi neq: ‘Anhia khoiq dáng chơ lacuoi cứq Rachel canỡt bar lám con samiang sâng yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Manoaq khoiq loŏh tễ cứq chơ, cớp cứq chanchớm charán pla háq chíq tỗ án. Toau tangái nâi cứq tỡ bữn hữm noâng án. ");
INSERT INTO bru_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Khân anhia ĩt con ralŏ́h nâi ễn tễ cứq, cớp khân án tamóh ŏ́c croŏq ntrớu, ki cứq la cũai thâu lứq sâng ngua, cớp cứq cuchĩt toâp.’ ");
INSERT INTO bru_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Yuaq ngkíq, khân cứq chu loah pỡ mpoaq cứq, ma tỡ bữn cũai póng nâi chu nứng cứq, ki mpoaq cứq cuchĩt toâp, cỗ mứt pahỡm án pasếq lứq cớp con ralŏ́h án. Khân lứq toâq ŏ́c ki, hếq lứq táq yỗn mpoaq hếq cỡt ngua cớp ariang hếq cachĩt chíq án. ");
INSERT INTO bru_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Cứq chĩuq tôt cớp mpoaq cứq, khân a‑ễm nâi ma tỡ bữn chu cớp cứq. Ki cứq bữn lôih mantái níc cớp mpoaq cứq. ");
INSERT INTO bru_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yuaq ngkíq, sễq ncháu yỗn cứq pláih tang a‑ễm nâi cỡt sũl anhia, ncháu ơi. Sễq ncháu acláh yỗn a‑ễm nâi chu cớp sễm ai án. ");
INSERT INTO bru_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Khân a‑ễm nâi ma tỡ bữn chu, nŏ́q khớn cứq chu pỡ mpoaq cứq? Cứq tỡ rơi nhêng mpoaq cứq ma chĩuq ŏ́c tỗiq bap cỗ ŏ́c ngua lứq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Moâm Yuda pai ngkíq, Yô-sep tỡ rơi ót noâng; án nhiam choâng moat máh cũai canŏ́h ỡt mpễr án. Án ớn casang neq: “Yỗn nheq tữh cũai Ê-yip-tô loŏh toâp tễ cứq!” Tữ noau loŏh nheq tễ ntốq ki, Yô-sep atỡng yỗn sễm ai án dáng ramứh án. ");
INSERT INTO bru_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Moâm Yô-sep pai ngkíq, án nhiam casang lứq. Cũai Ê-yip-tô cớp cũai tâng dống puo la sâng tê. ");
INSERT INTO bru_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yô-sep atỡng máh sễm ai án neq: “Cứq la Yô-sep! Mpoaq cứq noâng tamoong tỡ?” Ma sễm ai án dớt lứq, cớp croŏq lứq; alới tỡ têq ta‑ỡi ntrớu. ");
INSERT INTO bru_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yô-sep atỡng ễn sễm ai án neq: “Máh ai ơi! Cứq sễq anhia ỡt cheq cứq.” Ngkíq máh sễm ai án ỡt cheq án. Cớp án atỡng alới neq: “Cứq la Yô-sep, a‑ễm anhia khoiq chếq yỗn cũai cruang Ê-yip-tô nâi. ");
INSERT INTO bru_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma anhia chỗi croŏq ntrớu, cớp chỗi clơng ntrớu tễ máh ranáq anhia khoiq chếq cứq pỡ nâi. Yiang Sursĩ cơiq cứq pỡq nhũang anhia, yỗn cứq têq chuai amoong cũai. ");
INSERT INTO bru_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yuaq khoiq bữn bar cumo chơ cutễq tỡ bữn amia crơng sana, cớp noâng bữn sỡng cumo ễn tỡ bữn cỡt palâi palot ntrớu. ");
INSERT INTO bru_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ma Yiang Sursĩ khoiq yỗn cứq pỡq nhũang anhia, yỗn cứq chuai máh tŏ́ng toiq anhia yỗn têq bữn tamoong tâng cốc cutễq nâi. Cớp cứq chuai anhia viaq vớt tễ ŏ́c cuchĩt khlac tê. ");
INSERT INTO bru_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ngkíq, tỡ cỡn anhia yỗn cứq toâq pỡ nâi, ma Yiang Sursĩ toâp táq ranáq ki. Yiang Sursĩ yỗn cứq cỡt ayững atĩ sốt lứq khong puo. Cứq ndỡm nheq dống án, cớp cỡt sốt nheq tâng cruang Ê-yip-tô nâi. ");
INSERT INTO bru_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Chơ cóq anhia chu chái pỡ dống mpoaq hái cớp atỡng án neq: ‘Nâi la parnai Yô-sep atỡng mpoaq neq: Yiang Sursĩ táq yỗn cứq cỡt sốt nheq tâng cruang Ê-yip-tô. Ngkíq cóq anhia sễng toâp pỡ cứq. Cứq sễq anhia chỗi táq yũt. ");
INSERT INTO bru_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mpoaq têq ỡt tâng vil Cô-sơn, cớp mpoaq têq dững nheq máh mun mpoaq hỡ, dếh tỗp cữu cớp tỗp ntroŏq. Cớp mpoaq dững nheq con samiang cớp máh châu hỡ, chơ ỡt cheq cứq. ");
INSERT INTO bru_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ỡt ngki cứq ễ chứm siem mpoaq, yuaq noâng sỡng cumo ễn cutễq tỡ bữn têq amia crơng sarnóh ntrớu. Ngkíq mpoaq cớp nheq dống sũ mpoaq, dếh máh mun mpoaq têq viaq vớt tễ ŏ́c tỗiq bap ki.’” Yô-sep ớn máh ai án atỡng loah mpoaq alới ngkíq. ");
INSERT INTO bru_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Chơ Yô-sep atỡng sễm ai án ễn: “Nheq tữh anhia, dếh a‑ễm cứq Ben-yamin, lứq moat anhia hữm chơ, cứq la lứq Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ngkíq, cóq anhia atỡng mpoaq cứq máh cũai Ê-yip-tô yám noap lứq cứq. Cớp atỡng tễ máh ramứh anhia khoiq hữm chơ. Moâm ki, anhia dững mpoaq cứq pỡq ỡt toâp pỡ nâi.” ");
INSERT INTO bru_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Moâm Yô-sep pai ngkíq, án kĩau tacong Ben-yamin cớp án nhiam cỗ sâng ayooq lứq. Cớp Ben-yamin táq machớng ki tê cớp Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Chơ Yô-sep kĩau cớp hũn hĩt nheq máh sễm ai án, cớp án nhiam ễn. Moâm ki máh sễm ai Yô-sep táq ntỡng cớp án. ");
INSERT INTO bru_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tữ ranáq nâi han toâq pỡ dống puo, pai máh sễm ai Yô-sep khoiq toâq chơ, ngkíq puo cớp nheq tữh ranễng án sâng bũi tê. ");
INSERT INTO bru_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Puo atỡng Yô-sep neq: “Yỗn mới atỡng sễm ai mới neq: ‘Anhia patiang máh crơng sana tâng cloong aséh, cớp anhia chu loah pỡ cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Anhia dững mpoaq anhia cớp nheq dống sũ anhia toâq loah pỡ cứq. Cứq ễ yỗn anhia bữn cutễq o tâng cruang Ê-yip-tô nâi dŏq charán anhia bữn cha. Cớp têq anhia bữn crơng sana tâng cruang nâi hỡ. ");
INSERT INTO bru_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Cớp cóq anhia trĩh parnai cứq patâp, chơ ĩt sễ kĩen ca bữn pỗn ayững tễ cruang Ê-yip-tô, yỗn dững con lacuoi anhia cớp mpoaq anhia toâq pỡ nâi. ");
INSERT INTO bru_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Anhia chỗi croŏq ntrớu tễ crơng tâc tỡ la sana cha, yuaq dũ ramứh crơng o tâng cruang Ê-yip-tô, lứq anhia bữn tê.’” ");
INSERT INTO bru_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Moâm puo pai ngkíq, nheq con I-sarel táq machớng án patâp. Yô-sep ĩt sễ kĩen yỗn máh sễm ai án ĩn puo khoiq patâp chơ. Cớp Yô-sep yỗn alới sanyam cha bo alới pỡq tâng rana; ");
INSERT INTO bru_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","dếh án yỗn dũ náq bữn tampâc tamái hỡ. Ma Ben-yamin bữn sỡng cu tampâc tamái cớp pái culám ŏ́c práq panê. ");
INSERT INTO bru_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Cớp án cơiq yỗn mpoaq án neq: Muoi chít lám aséh dễn patiang crơng tễ cruang Ê-yip-tô, cớp muoi chít lám aséh dễn cán patiang saro cớp crơng sana canŏ́h dếh sanyam bo mpoaq án pỡq tâng rana sễng chu cruang Ê-yip-tô nâi hỡ. ");
INSERT INTO bru_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yô-sep satoâl máh sễm ai án cớp patâp alới neq: “Anhia pỡq tâng rana chỗi ralỗih ntrớu nơ.” ");
INSERT INTO bru_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Chơ alới loŏh tễ cruang Ê-yip-tô chu loah pỡ cruang Cana-an, ntốq Yacốp mpoaq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Cớp alới atỡng mpoaq alới neq: “Yô-sep noâng tamoong! Sanua án cỡt sốt nheq tâng cruang Ê-yip-tô!” Ma Yacốp sâng dớt lứq; án tỡ bữn noap santoiq alới atỡng. ");
INSERT INTO bru_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ngkíq máh sễm ai ki atỡng ễn yỗn mpoaq alới tamứng máh santoiq Yô-sep patâp. Toâq Yacốp hữm sễ kĩen Yô-sep cơiq dŏq patiang án, ");
INSERT INTO bru_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ngkíq nŏ́q Yacốp noap, chơ án pai neq: “Péq chơ! Yô-sep con samiang cứq, án noâng tamoong. Cứq ễ sễng sa‑óh án tê, nhũang cứq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ngkíq I-sarel tayoâq pỡq, cớp án dững nheq máh crơng án. Án toâq pỡ ntốq Bêr-si-ba. Ỡt ntốq ki án sang Yiang Sursĩ, la Yiang ca I-sac mpoaq án sang. ");
INSERT INTO bru_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bữn muoi sadâu, Yiang Sursĩ sapáh baih yỗn án, cớp arô án neq: “Yacốp! Yacốp ơi!” Yacốp ta‑ỡi: “Ơq! Cứq ỡt nâi!” ");
INSERT INTO bru_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Chơ Yiang Sursĩ atỡng ễn neq: “Cứq la Yiang Sursĩ, la Yiang mpoaq mới sang. Chỗi croŏq ntrớu sễng pỡ cruang Ê-yip-tô, yuaq ntốq ki cứq táq yỗn mới cỡt muoi cruang toâr. ");
INSERT INTO bru_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Cứq pỡq nứng mới pỡ cruang Ê-yip-tô, cớp nỡ‑ra cứq lứq dững mới píh chu loah pỡ cruang nâi. Toâq mới cuchĩt, lứq bữn Yô-sep toâp ỡt cớp mới.” ");
INSERT INTO bru_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Moâm ki, Yacốp loŏh tễ Bêr-si-ba. Con án patiang án, dếh máh con lacuoi alới tâng sễ kĩen puo cơiq yỗn. ");
INSERT INTO bru_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Alới dững tỗp ntroŏq cớp nheq mun alới bữn tâng cruang Cana-an toâq pỡ cruang Ê-yip-tô. Ngkíq, Yacốp cớp nheq sâu án, ");
INSERT INTO bru_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","dếh con samiang, châu samiang, con mansễm, cớp châu mansễm, nheq tữh alới toâq pỡ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nâi la ramứh sâu I-sarel ca mut tâng cruang Ê-yip-tô. Ruben la con clúng Yacốp. ");
INSERT INTO bru_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Máh con samiang Ruben bữn ramứh neq: Hanoc, Palu, Hê-trôn, cớp Car-mi. ");
INSERT INTO bru_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Máh con samiang Si-mê-ôn bữn ramứh neq: Yê-muol, Yamin, Ô-hat, Yakin, Sô-har, cớp Sau-lơ. Mpiq Sau-lơ, la mansễm tễ cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Máh con samiang Lê-vi bữn ramứh neq: Kêr-sôn, Cô-hat, cớp Mê-rari. ");
INSERT INTO bru_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Máh con samiang Yuda bữn ramứh neq: E-rơ, Ô-nan, Sê-lah, Pharêt, cớp Sê-rah. Ma bar lám con samiang E-rơ cớp Ô-nan khoiq cuchĩt tâng cruang Cana-an. Cớp Pharêt bữn máh con samiang ramứh Hê-trôn cớp Hamul. ");
INSERT INTO bru_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Máh con samiang I-sacar bữn ramứh neq: Tô-la, Puah, Yasup, cớp Sim-rôn. ");
INSERT INTO bru_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Máh con samiang Sa-bulôn bữn ramứh neq: Sê-ret, E-lôn, cớp Yalil. ");
INSERT INTO bru_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ngkíq nheq tữh alới ki cớp Di-na con mansễm án, la tŏ́ng toiq Yacốp ca Lê-a lacuoi án canỡt tâng cruang Padan Aram. Nheq tữh máh cũai ki, dếh samiang dếh mansễm la pái chít la pái náq. ");
INSERT INTO bru_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Máh con samiang Cát bữn ramứh neq: Si-phôn, Haki, Suni, Et-bôn, E-ri, Arôt, cớp Arê-li. ");
INSERT INTO bru_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Máh con samiang Asêr bữn ramứh neq: Im-nah, It-va, It-vi, cớp Be-ria. Alới ki bữn muoi noaq amuaq, ramứh Sê-rah. Ma Be-ria bữn tê con samiang ramứh Ê-bêr cớp Mal-kiel. ");
INSERT INTO bru_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Nheq tữh alới ki la tŏ́ng toiq Yacốp cớp Sil-pa. Nheq tữh alới la muoi chít tapoât náq. Sil-pa la mansễm Laban yỗn táq ranáq Lê-a con mansễm án. ");
INSERT INTO bru_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Máh con samiang Rachel, lacuoi Yacốp, bữn ramứh neq: Yô-sep cớp Ben-yamin. ");
INSERT INTO bru_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yô-sep bữn bar lám con samiang tâng cruang Ê-yip-tô, ramứh Ma-nasê cớp Ep-ra-im. Mpiq alới ki ramứh A-sanat con Phô-ti-phê-ra; án cỡt cũai tễng rit sang yỗn cũai ỡt tâng vil Ôn. ");
INSERT INTO bru_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Máh con samiang Ben-yamin ramứh neq: Bê-la, Be-ker, At-bel, Ke-ra, Naman, E-hi, Rôt, Mupim, Hupim, cớp At. ");
INSERT INTO bru_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Nheq tữh alới ki la tŏ́ng toiq Yacốp cớp Rachel. Parỗm nheq tữh alới la muoi chít la pỗn náq. ");
INSERT INTO bru_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan bữn muoi lám con samiang ramứh Husim. ");
INSERT INTO bru_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Máh con samiang Nep-tali bữn ramứh neq: Yasiel, Cuni, Yê-se, cớp Si-lem. Nheq máh alới ki la tŏ́ng toiq Yacốp cớp Bil-ha. ");
INSERT INTO bru_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Parỗm nheq tữh alới ki la tapul náq. Bil-ha la mansễm Laban yỗn táq ranáq chuai Rachel con mansễm án. ");
INSERT INTO bru_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ngkíq, nheq tữh cũai ca mut tâng cruang Ê-yip-tô parnơi cớp Yacốp la tapoât chít tapoât náq. Nâi la máh tŏ́ng toiq Yacốp, ma tỡ bữn noap cumân án. ");
INSERT INTO bru_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Cớp máh con samiang Yô-sep ca sễt tâng cruang Ê-yip-tô bữn bar náq. Ngkíq, nheq tữh cũai ki la tŏ́ng toiq Yacốp. Tữ án mut tâng cruang Ê-yip-tô, alới ki bữn tapul chít náq. ");
INSERT INTO bru_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ngkíq Yacốp ớn Yuda pỡq nhũang pỡ Yô-sep, dŏq blớh Yô-sep tễ rana pỡq chu ntốq Cô-sơn. ");
INSERT INTO bru_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Chơ Yô-sep ớn noau aloap sễ kĩen tâng aséh, cớp án pỡq pỡ Cô-sơn yoc ễ ramóh I-sarel, mpoaq án. Tữ án ramóh mpoaq án, án kĩau cớp án nhiam dũn lứq. ");
INSERT INTO bru_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","I-sarel atỡng Yô-sep neq: “Sanua cứq tỡ bữn ũan cuchĩt noâng, yuaq cứq khoiq hữm loah mới noâng bữn tamoong.” ");
INSERT INTO bru_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Chơ Yô-sep atỡng nheq máh sễm ai án cớp nheq dống sũ mpoaq án neq: “Ngkếq cứq pỡq ramóh puo yỗn án dáng tê tễ ŏ́c nâi. Cứq ễ atỡng án neq: ‘Nheq sễm ai cứq cớp dống sũ mpoaq cứq khoiq toâq pỡ cứq; alới toâq tễ cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Alới la cũai mantán bán charán. Alới táq ranáq bán charán sâng. Cớp alới khoiq dững máh mun alới, dếh cantóh cữu cớp ntroŏq hỡ.’ ");
INSERT INTO bru_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Khân puo arô cớp blớh anhia tễ ranáq anhia táq, ");
INSERT INTO bru_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ki cóq anhia ta‑ỡi án neq: ‘Hếq la cũai bán charán tễ bo hếq noâng póng toau toâq tangái nâi. Hếq cớp achúc achiac hếq táq níc ranáq nâi.’ Toâq anhia pai ngkíq, án yỗn anhia têq ỡt tâng Cô-sơn. Yuaq dốq cũai Ê-yip-tô tỡ ễq hữm máh cũai bán cữu.” ");
INSERT INTO bru_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yô-sep loŏh tễ Cô-sơn pỡq ramóh puo, cớp atỡng neq: “Mpoaq hếq, cớp máh sễm ai hếq, dếh máh mun alới, dếh tỗp cữu cớp tỗp ntroŏq, khoiq toâq pỡ ntốq Cô-sơn chơ.” ");
INSERT INTO bru_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Cớp Yô-sep rưoh sỡng náq tễ tỗp sễm ai án pỡq ramóh puo parnơi cớp án. ");
INSERT INTO bru_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Puo blớh sễm ai ki neq: “Ranáq ntrớu anhia táq?” Alới ta‑ỡi: “Ncháu ơi, hếq la cũai mantán bán charán. Hếq táq machớng achúc achiac hếq khoiq táq tễ nhũang.” ");
INSERT INTO bru_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Cớp sễm ai ki atỡng ễn puo neq: “Hếq toâq pỡ nâi yoc ễ ỡt dỡ sâng, cỗ tâng cruang Cana-an ŏ́q bát bai yỗn tỗp cữu hếq têq chuaq cha. Ỡt tâng cruang Cana-an ki panhieih lứq. Ngkíq hếq sễq ncháu yỗn hếq ỡt tâng ntốq Cô-sơn.” ");
INSERT INTO bru_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Moâm alới pai ngkíq, puo atỡng Yô-sep neq: “Mpoaq mới cớp máh sễm ai mới khoiq toâq chơ pỡ mới. ");
INSERT INTO bru_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ngkíq tâng cruang Ê-yip-tô nâi ntốq léq anhia yoc ễ ỡt, ki anhia ỡt. Yỗn mpoaq mới cớp sễm ai mới ỡt tâng cutễq o hỡn nheq tễ cutễq canŏ́h. Yỗn alới ỡt tâng ntốq Cô-sơn. Khân bữn cũai khễuq tễ tỗp alới, ki yỗn cũai ki bán charán khong cứq hỡ.” ");
INSERT INTO bru_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ntun ki Yô-sep dững Yacốp, mpoaq án, toâq pỡ puo. Ngkíq Yacốp câu yỗn puo bữn ŏ́c bốn. ");
INSERT INTO bru_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Cớp puo blớh Yacốp: “Mới sếq chít cumo chơ?” ");
INSERT INTO bru_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yacốp ta‑ỡi: “Anhúq hếq khoiq muoi culám pái chít cumo chơ. Dỡi tamoong hếq bĩq lứq, cớp hếq ramóh ŏ́c tỗiq bap sa‑ữi. Hếq tỡ bữn tamoong li cớp dỡi mpoaq cớp achuaih hếq tamoong, bo alới noâng ỡt tâng cốc cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Moâm ki, Yacốp câu sĩa yỗn puo, chơ án loŏh tễ puo. ");
INSERT INTO bru_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ma Yô-sep trĩh parnai puo atỡng tễ ntốq mpoaq cớp sễm ai án ỡt. Án yỗn alới bữn cutễq tâng cruang Ê-yip-tô o clữi nheq tễ cutễq canŏ́h. Ntốq ki, ramứh Ram-sê. ");
INSERT INTO bru_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Cớp Yô-sep chứm siem nheq tữh dống sũ mpoaq án, dếh máh sễm ai án hỡ. Án tampễq crơng sana puai sếq bỗq cũai tâng dống. ");
INSERT INTO bru_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ma tâng cruang ki ŏ́q lứq crơng sana, cỗ cutễq tỡ têq amia crơng sarnóh ntrớu. Cũai tâng cruang Ê-yip-tô cớp cruang Cana-an cỡt panhieih khlac nheq, cỗ ŏ́q crơng sana cha. ");
INSERT INTO bru_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ngkíq Yô-sep parỗm nheq máh práq cũai chỡng crơng sana tâng cruang Ê-yip-tô cớp tâng cruang Cana-an. Chơ án dŏq práq ki tâng dống puo. ");
INSERT INTO bru_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Toâq tangái práq tâng cruang Ê-yip-tô cớp cruang Cana-an khoiq nheq chơ, cũai Ê-yip-tô toâq pỡ Yô-sep, cớp sễq tễ án neq: “Hếq sễq crơng sana cha. Hếq cuchĩt khlac choâng moat anhia cỗ hếq nheq chíq práq.” ");
INSERT INTO bru_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yô-sep ta‑ỡi alới neq: “Khân práq anhia khoiq nheq chơ, ki yỗn anhia dững charán ễn yỗn cứq. Chơ cứq yỗn crơng sana.” ");
INSERT INTO bru_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ngkíq máh cũai ki dững charán alới pỡ Yô-sep. Chơ Yô-sep pĩen yỗn alới bữn crơng sana cha. Cumo ki, Yô-sep siem nheq tữh cũai, cỗ alới lêq nheq máh charán alới. ");
INSERT INTO bru_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Toâq cumo ntun ễn, alới toâq loah pỡ Yô-sep, cớp pai neq: “Hếq sễq atỡng ncháu raloaih lứq, máh práq hếq khoiq nheq chơ, cớp máh charán hếq la khoiq cỡt nheq khong anhia chơ. Hếq tỡ bữn ntrớu noâng ễ rapĩen cớp anhia. Hếq noâng bữn ống tỗ cớp cutễq sâng ễ yỗn anhia. ");
INSERT INTO bru_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Hếq cheq ễ cuchĩt choâng moat anhia, cớp cutễq hếq cỡt rangual. Sễq anhia chỡng tỗ hếq cớp cutễq hếq, yỗn hếq têq bữn crơng sana cha. Ngkíq hếq cớp cutễq hếq lứq cỡt khong puo. Moâm ki, sễq anhia yỗn hếq bữn cuplốq, dŏq yỗn hếq bữn tamoong, cớp chỗi dŏq cutễq miat sâng.” ");
INSERT INTO bru_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ngkíq, Yô-sep chỡng nheq máh cutễq tâng cruang Ê-yip-tô yỗn puo, yuaq dũ náq cũai Ê-yip-tô chếq nheq cutễq alới, cỗ tian ŏ́c panhieih toâr lứq tâng cruang ki. Chơ dũ tâm cutễq cỡt khong puo nheq. ");
INSERT INTO bru_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yô-sep táq yỗn dũ náq cũai Ê-yip-tô cỡt cũai sũl ễn. ");
INSERT INTO bru_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ma ống cutễq cũai tễng rit sang sâng Yô-sep tỡ bữn chỡng, cỗ cũai nâi ĩt níc muoi pún crơng sana tễ puo. Ngkíq alới tỡ bữn túh chếq cutễq alới, yoc ễ bữn sana cha. ");
INSERT INTO bru_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yô-sep atỡng máh cũai proai tâng cruang ki neq: “Cứq khoiq chỡng tỗ anhia cớp cutễq anhia chơ yỗn puo ndỡm. Cứq yỗn anhia bữn cuplốq dŏq chóh tâng cutễq ki. ");
INSERT INTO bru_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Toâq catữ sot, khân anhia bữn muoi culám achoiq, cóq yỗn bar chít achoiq pỡ puo; clữi tễ ki anhia dŏq yỗn dống sũ anhia bữn cha, cớp dŏq cuplốq hỡ dŏq anhia bữn chóh loah. Ngkíq nŏ́q con acái anhia bữn sana cha.” ");
INSERT INTO bru_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Moâm Yô-sep pai ngkíq, máh cũai proai ta‑ỡi án neq: “Ncháu khoiq chuai amoong hếq chơ. Sễq ncháu sarũiq táq hếq. Cớp hếq lứq pruam cỡt cũai sũl yỗn puo.” ");
INSERT INTO bru_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tangái ki Yô-sep aloŏh rit tâng cruang Ê-yip-tô cóq parỗm loah muoi pún tễ sỡng pún crơng chóh yỗn pỡ puo. Phễp rit ki noâng níc toau sanua. Ma ống cutễq cũai tễng rit sang sâng, puo tỡ bữn ndỡm. ");
INSERT INTO bru_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ngkíq máh cũai I-sarel ỡt tarôq tâng cruang Ê-yip-tô tâng ntốq Cô-sơn. Tỗp alới bữn mun sa‑ữi tâng cruang ki, cớp cỡt rứh clứng lứq ễn. ");
INSERT INTO bru_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yacốp ỡt tâng cruang Ê-yip-tô muoi chít tapul cumo. Án tamoong bữn muoi culám pỗn chít tapul cumo. ");
INSERT INTO bru_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Toâq tangái án cheq cuchĩt, án arô Yô-sep con samiang án, cớp atỡng neq: “Khân mới lứq ayooq cứq cớp yám noap cứq, ki cứq sễq mới satoaq atĩ mới tâng nlu cứq, chơ parkhán cớp cứq muoi ŏ́c neq: Chỗi tứp cứq tâng cutễq cruang Ê-yip-tô nâi. ");
INSERT INTO bru_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Toâq cứq cuchĩt, cứq sễq mới dững aloŏh cứq tễ cruang Ê-yip-tô nâi, chơ tứp cứq tâng ntốq noau tứp achúc achiac cứq.” Yô-sep parkhán neq: “Lứq samoât, cứq con táq machớng mpoaq patâp.” ");
INSERT INTO bru_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yacốp pai ễn neq: “Cóq mới thễ dũan cớp cứq.” Ngkíq Yô-sep thễ dũan cớp mpoaq án. Moâm ki, I-sarel pũp câu sa‑ỡn Yiang Sursĩ tâng cachơng án bếq. ");
INSERT INTO bru_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ntun ki, bữn cũai atỡng Yô-sep neq: “Mpoaq anhia a‑ĩ.” Ngkíq, Yô-sep pỡq clơ mpoaq án; cớp án dững Ma-nasê cớp Ep-ra-im, bar lám con samiang án. ");
INSERT INTO bru_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tữ Yacốp sâng noau pai Yô-sep con samiang án toâq clơ án, ngkíq I-sarel cutóng yuor tacu tâng cachơng. ");
INSERT INTO bru_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Cớp án atỡng Yô-sep neq: “Yiang Sursĩ Sốt Toâr Lứq toâq pỡ cứq tâng ntốq Lusơ pỡ cruang Cana-an. Yiang Sursĩ yỗn cứq bữn ŏ́c bốn sa‑ữi, ");
INSERT INTO bru_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","cớp án atỡng cứq neq: ‘Cứq ễ táq yỗn mới cỡt rứh clứng lứq. Cứq táq yỗn mới bữn sa‑ữi tỗp, chơ cứq yỗn mới cớp nheq tŏ́ng toiq mới bữn ndỡm cutễq nâi mantái níc.’ ");
INSERT INTO bru_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma bar náq con samiang mới canỡt tâng cruang Ê-yip-tô nhũang cứq sễng pỡ nâi, bar náq ki la ariang con cứq tê. Ngkíq, Ma-nasê cớp Ep-ra-im la cỡt con cứq machớng Ruben cớp Si-mê-ôn tê. ");
INSERT INTO bru_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma máh con canŏ́h mới bữn ntun, ki cỡt con mới; alới bữn roap mun puai ramứh ai alới, Ma-nasê cớp Ep-ra-im. ");
INSERT INTO bru_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tữ cứq loŏh tễ cruang Padan Aram, cứq bữn ŏ́c ngua lứq cỗ tian Rachel cuchĩt dĩ ria rana tâng cruang Cana-an, tỡ yũah toâq pỡ vil Ep-rat. Cứq tứp án cheq rana pỡq chu Ep-rat.” (Ep-rat bữn ramứh Bet-lahem hỡ.) ");
INSERT INTO bru_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Moâm I-sarel pai ngkíq, án hữm bar náq con samiang Yô-sep, chơ án blớh neq: “Noau nâi?” ");
INSERT INTO bru_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yô-sep ta‑ỡi mpoaq án neq: “Nâi la con samiang Yiang Sursĩ khoiq yỗn cứq tâng cruang nâi.” Chơ Yacốp pai ễn neq: “Sễq mới dững alới toâq pỡ cứq. Cứq ễ câu yỗn alới bữn ŏ́c bốn.” ");
INSERT INTO bru_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Cỗ moat I-sarel khoiq sỡm, án hữm práng prưl sâng. Ngkíq, án yoc alới ỡt cheq án. Chơ án kĩau con Yô-sep, cớp án hũn hĩt alới. ");
INSERT INTO bru_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I-sarel atỡng Yô-sep neq: “Tễ nhũang cứq chanchớm tỡ bữn têq hữm noâng moat mới. Ma cứq dớt lứq Yiang Sursĩ yỗn moat cứq noâng bữn hữm con mới hỡ.” ");
INSERT INTO bru_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Moâm I-sarel pai ngkíq, Yô-sep acŏ́q con samiang án tễ racớl I-sarel, cớp án cucốh cucũoi cheq mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yô-sep tếc Ep-ra-im yỗn ỡt coah atĩ avêr I-sarel. Cớp án tếc Ma-nasê yỗn ỡt coah atĩ atoam I-sarel. ");
INSERT INTO bru_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ma I-sarel satoaq atĩ tâng plỡ alới. Atĩ coah atoam án satoaq tâng plỡ Ep-ra-im con ralŏ́h Yô-sep. Ma atĩ coah avêr, án satoaq tâng plỡ Ma-nasê con clúng Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Chơ I-sarel câu yỗn Yô-sep neq: “Cứq sễq Yiang Sursĩ A-praham cớp I-sac sang, la Yiang Sursĩ ca bán kĩaq cứq nheq dỡi tamoong cứq toau toâq tangái nâi, ");
INSERT INTO bru_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","dếh ranễng Yiang Sursĩ ca khoiq chuai cứq yỗn vớt tễ ramứh túh coat, sễq Yiang Sursĩ yỗn con samiang nâi bữn ŏ́c bốn sa‑ữi. Nhơ tễ con samiang nâi, cứq yoc noau sanhữ níc ramứh cứq, cớp ramứh A-praham, I-sac, la achuaih cớp mpoaq cứq. Cớp cứq sễq Yiang Sursĩ yỗn con samiang nâi bữn tŏ́ng toiq cỡt clứng lứq tâng cốc cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Toâq Yô-sep hữm mpoaq án satoaq atĩ atoam tâng plỡ Ep-ra-im, ngkíq án tỡ bữn bũi mpoaq án táq ngkíq. Chơ án ĩt atĩ mpoaq án tễ plỡ Ep-ra-im chóq tâng plỡ Ma-nasê ễn. ");
INSERT INTO bru_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yô-sep atỡng mpoaq án neq: “Tỡ bữn pĩeiq ngkíq, mpoaq ơi! Yuaq con nâi la con clúng. Mpoaq cóq satoaq atĩ atoam tâng plỡ án.” ");
INSERT INTO bru_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ma mpoaq án ta‑ỡi neq: “Cứq dáng chơ, con ơi! Lứq samoât, cứq dáng. Con clúng ki, nỡ‑ra án ndỡm sa‑ữi tỗp cũai cớp cỡt sốt toâr lứq hỡ. Ma án ca a‑ễm nâi, án lứq cỡt toâr hỡn tễ ai án; nỡ‑ra tŏ́ng toiq án cỡt sa‑ữi cruang.” ");
INSERT INTO bru_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tangái ki I-sarel pai ŏ́c bốn yỗn bar náq con samiang Yô-sep neq: “Nỡ‑ra máh cũai I-sarel talếq ramứh anhia dŏq sễq ŏ́c bốn yỗn cũai canŏ́h; alới ễ pai neq: ‘Sễq Yiang Sursĩ táq yỗn anhia cỡt machớng Ep-ra-im cớp Ma-nasê.’” Cỗ Yacốp pai ngkíq, án talếq ramứh Ep-ra-im nhũang ramứh Ma-nasê la con clúng. ");
INSERT INTO bru_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Chơ I-sarel atỡng Yô-sep neq: “Cứq mpoaq cheq ễ cuchĩt chơ. Ma Yiang Sursĩ ễ ỡt níc cớp mới; nỡ‑ra án ễ dững mới chu loah pỡ cruang achúc achiac mới. ");
INSERT INTO bru_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ma hỡn tễ ki ễn, cứq chiau yỗn mới bữn muoi tâm cutễq hỡn tễ sễm ai mới; la cutễq o lứq tâng cuar cóh Se-kem. Cutễq nâi la cutễq cứq cheng ĩt na dau cớp tamĩang tễ cũai Amô-rit.” ");
INSERT INTO bru_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yacốp ớn cũai pỡq coâiq tỗp con samiang án, chơ án pai neq: “Anhia toâq rôm dũ náq. Cứq ễ atỡng yỗn anhia máh ramứh ễ toâq pỡ anhia nỡ‑ra. ");
INSERT INTO bru_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Máh con samiang cứq ơi! Anhia rôm cớp tamứng santoiq cứq. Cứq la I-sarel, mpoaq anhia. ");
INSERT INTO bru_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben la con clúng cứq, bo canỡt mới cứq noâng bán rêng. Cứq amia mới nhũang nheq tễ canŏ́h. Cỗ mới la con clúng, ngkíq mới cỡt sốt cớp bữn chớc hỡn tễ máh a‑ễm mới. ");
INSERT INTO bru_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mới la riang dỡq lampóh tỡ bữn noau têq catáng; ma mới tỡ têq cỡt toâr ntrớu cỗ tian mới cooc lacuoi cỗiq mpoaq mới; ŏ́c nâi táq yỗn cachơng cứq bếq cỡt nhơp lứq. ");
INSERT INTO bru_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Si-mê-ôn cớp Lê-vi la sễm ai muoi mpiq; alới pruam táq lôih. Alới yoc lứq yống crơng choac, chơ pỡq cachĩt cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Cứq mpoaq tỡ bữn pruam cớp ranáq alới táq, dếh cứq tỡ ễq mut tamứng bân ntốq alới toâq rôm, cỗ alới cachĩt máh cũai. Toâq alới sâng nsóq mứt, alới rứl sangcoâng ntroŏq yỗn lahỡi mứt alới. ");
INSERT INTO bru_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cỗ mứt pahỡm alới loâi lứq, cớp yoc lứq táq ranáq plampla, ngkíq cứq pupap tŏ́ng toiq alới yỗn ỡt miar tễ máh tỗp sễm ai alới. Cứq ễ yỗn alới cỡt pláh chap chũop nheq tâng cruang I-sarel. ");
INSERT INTO bru_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda ơi! Nỡ‑ra nheq máh sễm ai mới ễ khễn mới; atĩ mới lứq riap cháp tacong cũai par‑ũal cớp mới. Ngkíq nheq con samiang cứq, alới lứq cucốh cucũoi mới. ");
INSERT INTO bru_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda la ariang cula samín pla. Con ơi! Mới cỡt samoât cula samín mbỡiq táh cha cumáp, chơ chỗn chu cóh. Cớp mới cỡt ariang cula samín cán; tỡ bữn cũai aléq khớn tarôq cheq. ");
INSERT INTO bru_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda tỡ bữn ŏ́q chớc, cớp con châu án la bữn chớc toau sốt nheq dỡi. Ngkíq máh cruang cutễq yám noap án cớp dững crơng mpon yỗn án. ");
INSERT INTO bru_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yuda sốc lứq. Án chŏ́q dŏq aséh dễn tâng voar nho, ma án tỡ bữn sâng pasếq yỗn aséh ki cha voar nho, cỗ án bữn sa‑ữi lứq. Dỡq nho bữn clữi cliei yỗn noau nguaiq, dếh têq ĩt dỡq ki yỗn pooh aroâiq hỡ. ");
INSERT INTO bru_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Án nguaiq dỡq nho, toau táq yỗn moat án cỡt cusâu. Cớp án nguaiq dỡq tóh ntroŏq toau táq yỗn canễng án cloc lứq. ");
INSERT INTO bru_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sa-bulôn ỡt choâng tor dỡq mưt. Bân ntốq ki la parchíh tuoc toâr. Raloan cruang án ỡt choâng cớp vil Sadôn. ");
INSERT INTO bru_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Cutễq I-sacar ỡt mpứng dĩ ntốq noau rabán charán cữu. Ngkíq án la samoât aséh dễn bán rêng lứq, cớp bếq tâng huong mpứng dĩ bar coah cuaq cữu. ");
INSERT INTO bru_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tữ án hữm ntốq cutễq ki phốn phuor o, án pruam táq ranáq cớp dỗl níc crơng ntâng yỗn cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan la cũai rasữq máh cũai proai án, machớng tỗp I-sarel canŏ́h rasữq proai alới tê. ");
INSERT INTO bru_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Cớp án táq ariang cusân ỡt croŏq rana yỗn cũai par‑ũal cớp án. Cusân tur nâi ỡt cáng rana ễ tot ayững aséh, táq yỗn aséh tamprũol. Ngkíq cũai ỡt tâng cloong aséh ki satooh chu cutễq.” ");
INSERT INTO bru_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Chơ Yacốp câu neq: “Ơ Yiang Sursĩ ơi! Cứq ỡt acoan anhia chuai amoong cứq.” ");
INSERT INTO bru_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Cớp Yacốp atỡng sĩa máh con samiang án neq: “Cát, nỡ‑ra bữn cũai toâq ễ talốh crơng án, ma án puai níc ntun clĩ cũai ki, cỗ ễ táq cũai ki. ");
INSERT INTO bru_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asêr, cutễq án amia crơng sana o cớp ễm lứq. Crơng sana ki pĩeiq yỗn dếh puo cha. ");
INSERT INTO bru_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nep-tali la ariang yỡt cán lúh chu nâi chu ki. Án atỡng khễuq cớp ễm tamứng. ");
INSERT INTO bru_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yô-sep cỡt tŏ́ng toiq clứng lứq; án la samoât voar noau chóh cheq dỡq, cớp palâi án bong lứq. Abễng voar ki poar achỗn tâng viang. ");
INSERT INTO bru_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Cũai pán tamĩang toâq chíl ntâng lứq, alới pán apuai Yô-sep. ");
INSERT INTO bru_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ma Yô-sep ỡt dễ tamĩang. Cớp atĩ án sangháiq lứq, cỗ nhơ Yiang Sursĩ Yacốp sang chuai án. Yiang Sursĩ bữn chớc toâr lứq, cớp cỡt cũai mantán o. Ncháu la samoât tamáu côl, dŏq cỡt ntốq yỗn cũai I-sarel campáng. ");
INSERT INTO bru_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yiang Sursĩ ca mpoaq mới sang chuai mới; Yiang Sursĩ Sốt Toâr Lứq yỗn mới bữn ŏ́c bốn tễ paloŏng cớp tễ dỡq, cớp án yỗn mới bữn tŏ́ng toiq sa‑ữi, cớp yỗn máh charán mới cỡt rứh sa‑ữi lứq tê. ");
INSERT INTO bru_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Cứq la mpoaq mới bữn ŏ́c bốn sa‑ữi hỡn tễ achúc achiac cứq khoiq bữn. Ŏ́c bốn nâi la ariang cóh, tỡ nai pứt. Cứq sễq ŏ́c bốn nâi toâq pỡ Yô-sep ễn, án ca cỡt sốt hỡn tễ máh sễm ai án. ");
INSERT INTO bru_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ben-yamin la cũai chiang pỡq rachíl. Án la samoât acho arưih panhieih sana. Tâng tarưp án cha cumáp. Ma toâq tabữ án tampễq crơng tễ án cheng bữn.” ");
INSERT INTO bru_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Nheq tữh máh cũai nâi la muoi chít la bar tỗp tễ cruang I-sarel. Cớp máh santoiq nâi, mpoaq alới atỡng nhũang tễ án cuchĩt. Chơ mpoaq alới câu yỗn alới bữn ŏ́c bốn; dũ náq bữn roap ŏ́c bốn rapĩeiq yỗn án. ");
INSERT INTO bru_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Moâm ki Yacốp patâp con án neq: “Cứq cheq ễ cuchĩt chơ; sễq anhia tứp cứq parnơi cớp achúc achiac hái tâng cưp pỡ ruang Ep-rôn cũai Hêt. ");
INSERT INTO bru_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Cưp nâi cheq ntốq Mac Pala, choâng cớp ntốq Mam-rê, tâng cruang Cana-an. Ruang nâi la A-praham chỡng tễ Ep-rôn cũai Hêt, yỗn án bữn muoi ntốq tứp cumuiq tễ dống sũ án. ");
INSERT INTO bru_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tâng ntốq ki noau tứp A-praham cớp Sara lacuoi án. Cớp noau khoiq tứp I-sac cớp Rê-be-ca lacuoi án. Pỡ ntốq ki cứq tứp Lê-a lacuoi cứq hỡ. ");
INSERT INTO bru_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nheq ntốq ki, dếh ruang dếh cưp, A-praham chỡng tễ cũai Hêt.” ");
INSERT INTO bru_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Moâm Yacốp patâp máh con samiang án ngkíq, chơ án ta-ŏh rangứh. ");
INSERT INTO bru_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yô-sep kĩau mpoaq án, chơ án nhiam cớp hũn hĩt mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Chơ Yô-sep ớn cũai khễuq táq yỗn cumuiq tỡ bữn nsóq, yỗn alới thrũan cumuiq mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nheq pỗn chít tangái ki, cũai ki thrũan cumuiq I-sarel chóq sac án tâng aluang cumuiq. Puai rit tâng cruang ki, cũai Ê-yip-tô tanúh yỗn Yacốp tapul chít tangái. ");
INSERT INTO bru_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Vớt tangái tanúh, Yô-sep atỡng ayững atĩ puo neq: “Khân anhia sâng sarũiq cứq, ki sễq anhia atỡng puo yỗn án dáng tê tễ santoiq cứq atỡng nâi. ");
INSERT INTO bru_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mpoaq cứq pai cớp cứq neq: ‘Cứq cheq cuchĩt chơ. Cóq mới tứp cứq pỡ ntốq cứq khoiq thrũan dŏq tâng cruang Cana-an.’ Chơ cứq thễ dũan cớp án ngkíq. Sanua cứq sễq anhia yỗn cứq chu tứp mpoaq cứq pỡ ntốq ki. Toâq moâm, ki cứq píh chu loah pỡ nâi.” ");
INSERT INTO bru_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Puo ta‑ỡi án neq: “Têq mới pỡq tứp mpoaq mới, ariang mới khoiq thễ dũan cớp án chơ.” ");
INSERT INTO bru_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ngkíq Yô-sep pỡq tứp mpoaq án. Máh cũai ranễng puo, máh cũai sốt dống puo, cớp cũai sốt canŏ́h hỡ tâng cruang Ê-yip-tô pỡq nứng án. ");
INSERT INTO bru_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nheq máh cũai tâng dống sũ Yô-sep, cớp máh cũai tâng dống sũ sễm ai án, dếh cũai canŏ́h tâng dống sũ mpoaq án pỡq tê. Ống carnễn cớp charán sâng noâng ỡt tâng Cô-sơn. ");
INSERT INTO bru_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bữn tahan dững sễ kĩen cớp tahan ỡt aséh hỡ pỡq cớp alới. Nheq tữh alới la clứng lứq. ");
INSERT INTO bru_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tữ alới toâq pỡ ntốq noau dốq púh saro, ramứh Atat, ỡt yáng tooh crỗng Yôr-dan, alới táq rit tứp cumuiq cớp nhiam atếh. Yô-sep tanúh yỗn mpoaq án nheq tapul tangái tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ma tữ cũai Cana-an ỡt tâng ntốq ki hữm alới táq rit tứp cumuiq tâng ntốq Atat, ngkíq cũai Cana-an pai neq: “Rit tứp trỗ nâi la toâr lứq yỗn cũai Ê-yip-tô.” Yuaq ngkíq cũai Cana-an, amứh loah ntốq ki yáng tooh crỗng Yôr-dan la Aben Mit-rêm. ");
INSERT INTO bru_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ngkíq, máh con samiang Yacốp táq puai ĩn parnai án khoiq patâp alới chơ. ");
INSERT INTO bru_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Alới dững loah án pỡ cruang Cana-an, cớp tứp án tâng cưp pỡ ruang Mac Pala, choâng cớp ntốq Mam-rê. Ntốq nâi A-praham khoiq chỡng tễ Ep-rôn cũai Hêt, dŏq án têq tứp cũai cuchĩt tễ dống sũ án. ");
INSERT INTO bru_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Moâm alới tứp mpoaq alới, Yô-sep chu loah pỡ cruang Ê-yip-tô parnơi cớp sễm ai án cớp máh cũai canŏ́h ca pỡq cớp án pỡq tứp mpoaq án. ");
INSERT INTO bru_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ma toâq sễm ai Yô-sep hữm mpoaq alới khoiq cuchĩt chơ, ngkíq alới manoaq atỡng manoaq neq: “Nŏ́q hái ễ táq khân Yô-sep kêt cớp carláh dỡq chóq hái, yuaq hái khoiq táq sâuq chóq án chơ.” ");
INSERT INTO bru_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ngkíq alới cơiq parnai atỡng Yô-sep neq: “Bo mpoaq tỡ yũah cuchĩt, án patâp hếq atỡng loah mới neq: ");
INSERT INTO bru_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Cứq sễq mới táh lôih yỗn máh sễm ai mới khoiq táq sâuq chóq mới tễ nhũang.’ Ma sanua, hếq sễq mới táh lôih yỗn máh ranáq hếq khoiq táq sâuq chóq mới, yuaq hếq la cũai táq ranáq Yiang Sursĩ mpoaq hái sang.” Tữ Yô-sep sâng máh parnai sễm ai án pai, ki án nhiam sĩa. ");
INSERT INTO bru_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Moâm ki, sễm ai toâp toâq pỡ Yô-sep, cớp sacốh racớl choâng moat án, pai neq: “Hếq la cũai sũl anhia.” ");
INSERT INTO bru_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Yô-sep ta‑ỡi loah alới neq: “Anhia chỗi ngcŏh ntrớu. Cứq tỡ têq pláih Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Lứq samoât, anhia táq sâuq chóq cứq. Ma Yiang Sursĩ pĩen ŏ́c ki yỗn cỡt o ễn. Yiang Sursĩ táq ngkíq dŏq chuai amoong clứng cũai. ");
INSERT INTO bru_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ngkíq, anhia chỗi ngcŏh ntrớu. Cứq toâp ễ siem anhia cớp nheq tữh con lacuoi anhia.” Yô-sep pai ngkíq, án aliam loah mứt pahỡm máh sễm ai án. Láih parnai Yô-sep o lứq chóq alới. ");
INSERT INTO bru_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ngkíq Yô-sep cớp nheq tữh cũai tâng dống sũ mpoaq án noâng ỡt tâng cruang Ê-yip-tô. Yô-sep tamoong bữn muoi culám muoi chít cumo. ");
INSERT INTO bru_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Moat án bữn hữm con cớp châu Ep-ra-im. Cớp án ca‑ữ tâng nlu án máh con Makir, la con samiang Ma-nasê. ");
INSERT INTO bru_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Chơ Yô-sep atỡng sễm ai án neq: “Cứq cheq ễ cuchĩt. Ma Yiang Sursĩ lứq chuai anhia, yỗn anhia loŏh tễ cruang nâi, toâq pỡ cruang án khoiq parkhán cớp A-praham, I-sac, cớp Yacốp.” ");
INSERT INTO bru_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Moâm Yô-sep pai ngkíq, án yỗn máh con I-sarel thễ dũan cớp án neq: “Toâq Yiang Sursĩ chuai anhia, cóq anhia dững aloŏh nghang cứq tễ cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yô-sep khoiq bữn muoi culám muoi chít cumo, chơ án cuchĩt. Noau thrũan cumuiq Yô-sep táq tỡ yỗn nsóq, cớp chóq tâng hom tâng cruang Ê-yip-tô.");
INSERT INTO bru_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Sanua nâi ruaih loah tễ dống sũ con samiang Yacốp dễq chu cruang Ê-yip-tô muoi prớh cớp án: ");
INSERT INTO bru_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Si-mê-ôn, Lê-vi, Yuda, ");
INSERT INTO bru_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","I-sacar, Sa-bulôn, Ben-yamin, ");
INSERT INTO bru_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nep-tali, Cát, Asêr. ");
INSERT INTO bru_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Nheq tữh con châu pỡq cớp Yacốp la tapul chít náq. Ma bữn manoaq ỡt nhũang pỡ cruang Ê-yip-tô; ramứh án la Yô-sep. ");
INSERT INTO bru_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ntun ki Yô-sep cớp tỗp sễm ai án, cớp cũai muoi prôq cớp án, la cuchĩt nheq. ");
INSERT INTO bru_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ngkíq cũai I-sarel thrap ntun bữn con châu cỡt rứh sa‑ữi, cớp cỡt rêng lứq. Yuaq ngkíq, alới ỡt pláh dũ ntốq tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Moâm ki puo tamái táq sốt tâng cruang Ê-yip-tô. Án tỡ bữn dáng ntrớu loâng tễ Yô-sep. ");
INSERT INTO bru_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Án atỡng máh cũai ayững atĩ án neq: “Nhêng ki! Cũai I-sarel cu rangái cỡt rứh la‑ữt, cỡt rêng lứq. Cŏh lơ tỗp hái tỡ têq padâm noâng alới. ");
INSERT INTO bru_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Khân bữn yúc bác, cŏh lơ tỗp alới pruam cớp cũai ễ chíl tỗp hái, chơ alới loŏh chíq tễ cruang hái. Sanua nâi cóq hái chuaq ngê táq nŏ́q tỡ yỗn tỗp nâi mŏ cỡt rứh sa‑ữi.” ");
INSERT INTO bru_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ngkíq sốt cũai Ê-yip-tô chóh cũai nhêng salĩq tỗp I-sarel dŏq padâm alới yỗn táq ranáq ntâng lứq, cớp táq yỗn alới cỡt pê pahỡm. Tỗp cũai I-sarel ayứng vil Pi-thôm cớp vil Ram-sê yỗn puo, ien dŏq crơng crớu. ");
INSERT INTO bru_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lứq pai cũai Ê-yip-tô padâm cũai I-sarel ntâng lứq, ma máh ki tê cũai I-sarel cỡt rứh sa‑ữi lứq chũop cruang Ê-yip-tô. Chơ máh cũai Ê-yip-tô sâng croŏq lứq tễ cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Máh cũai Ê-yip-tô táq yỗn dỡi tamoong alới cỡt túh arức lứq. ");
INSERT INTO bru_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Alới padâm tỗp I-sarel cỡt ariang cũai sũl. Alới ễp tỗp I-sarel táq dống sarái yỗn alới, cớp alới ŏ́q ŏ́c sarũiq táq loâng. ");
INSERT INTO bru_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Chơ puo cruang Ê-yip-tô táq ntỡng cớp bar náq mansễm ramứh Si-pra cớp Puah, cũai dốq chuai mansễm cũai Hê-brơ toâq alới canỡt con. Án ớn alới neq: ");
INSERT INTO bru_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Toâq anhia pỡq chuai cũai Hê-brơ canỡt con, khân con samiang, ki anhia cachĩt táh toâp. Ma khân con mansễm, ki anhia dŏq yỗn án bữn tamoong.” ");
INSERT INTO bru_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ma bar náq mansễm ki ngcŏh cớp yám noap Yiang Sursĩ, chơ alới tỡ bữn trĩh máh santoiq puo ớn. Ngkíq alới dŏq yỗn carnễn samiang bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Toâq puo dáng ngkíq, án arô bar náq mansễm ki, cớp án blớh alới neq: “Nŏ́q anhia táq ngkíq? Nŏ́q anhia dŏq carnễn samiang yỗn bữn tamoong?” ");
INSERT INTO bru_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Alới bar náq ta‑ỡi puo neq: “Mansễm cũai Hê-brơ la mpha tễ mansễm cũai Ê-yip-tô. Alới canỡt con khễ lứq. Nhũang hếq ễ toâq chuai, con alới khoiq loŏh chơ.” ");
INSERT INTO bru_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Yuaq ngkíq, cũai I-sarel bữn con châu cỡt rứh sa‑ữi, cớp alới cỡt rêng lứq. Cỗ bar náq mansễm ki ngcŏh cớp yám noap Yiang Sursĩ, ngkíq Yiang Sursĩ táq yỗn bar náq alới bữn bốn puan cớp bữn dống sũ tê. ");
INSERT INTO bru_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Chơ puo ớn nheq tữh proai án neq: “Khân cũai Hê-brơ aléq ma canỡt con samiang, ki yỗn anhia takễl chíq con ki chu crỗng Nil. Khân bữn con mansễm, ki anhia dŏq yỗn án tamoong.” ");
INSERT INTO bru_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Bữn muoi noaq samiang tễ tỗp Lê-vi ĩt mansễm tễ tỗp án bữm táq lacuoi. ");
INSERT INTO bru_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Cớp mansễm ki canỡt muoi lám con samiang. Toâq án hữm thán riang con ki nêuq lứq, án cutooq dŏq con án nheq pái casâi. ");
INSERT INTO bru_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ma toâq án cutooq tỡ clỡp noâng con samiang án, ngkíq án tan ayúng, cớp atia siet aluang yỗn khĩt, yỗn ayúng ki têq dỗih. Chơ án acŏ́q con án chóq tâng ayúng, chơ dững achúh ayúng ki tâng crỗng Nil, cheq tor pỡ ntốq bữn sa‑ữi bát cuti. ");
INSERT INTO bru_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ỡi carnễn ki, án ỡt tayứng yơng bĩq tễ ntốq ki, cớp án tapoang nhêng ranáq ntrớu ễ toâq pỡ a‑ễm án. ");
INSERT INTO bru_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Vớt ki, con cumũr puo sễng mpơi dỡq. Ma mansễm sũl con puo tayáh mpễr tor crỗng ki. Bo con puo ntôm mpơi dỡq, án tapoang hữm ayúng ỡt mpứng dĩ bát cuti ki. Ngkíq án ớn cũai sũl pỡq ĩt yỗn án nhêng. ");
INSERT INTO bru_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Toâq án pớh, án hữm carnễn samiang ỡt nhiam. Ngkíq án sâng sarũiq táq; chơ án pai neq: “Carnễn nâi la con cũai Hê-brơ.” ");
INSERT INTO bru_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Moâm ki, ỡi carnễn ki toâq blớh con puo neq: “Anhia yoc hếq pỡq chuaq mansễm Hê-brơ toâq apu carnễn nâi yỗn anhia tỡ?” ");
INSERT INTO bru_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Chơ con puo ta‑ỡi án neq: “Âu, mới pỡq chuaq yỗn cứq nứng.” Chơ án pỡq coâiq mpiq carnễn ki. ");
INSERT INTO bru_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Con puo ớn mansễm ki neq: “Mới apu chuai carnễn nâi yỗn cứq, chơ cứq culáh cóng yỗn mới.” Ngkíq mpiq con ki roap ĩt, chơ dững achu apu amia. ");
INSERT INTO bru_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Toâq carnễn ki táh tóh, mpiq carnễn ki dững culáh loah yỗn con puo. Chơ con cumũr puo ĩt carnễn ki táq con án. Cớp con puo pai neq: “Yuaq cứq acŏ́q achỗn án tễ dỡq, ngkíq cứq amứh con nâi la Môi-se.” ");
INSERT INTO bru_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Dũn cumo ralua casâi Môi-se toâr achỗn, chơ án chu clơ loah sễm ai án, la cũai Hê-brơ. Án hữm noau padâm alới yỗn táq ranáq ntâng lứq. Cớp án hữm manoaq cũai Ê-yip-tô toân manoaq cũai Hê-brơ, la tỗp sễm ai án bữm. ");
INSERT INTO bru_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tữ Môi-se nhêng chu clĩ chu moat, án tỡ bữn hữm noau. Ngkíq án cachĩt chíq cũai Ê-yip-tô ki, cớp án tứp cutooq cumuiq ki tâng chũah. ");
INSERT INTO bru_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Máh tangái parnỡ ễn, Môi-se toâq loah pỡ ntốq ki, cớp trỗ nâi án ramóh bar náq cũai Hê-brơ carchĩt. Chơ án blớh cũai lôih ki neq: “Nŏ́q mới táq yớu muoi tỗp cớp mới?” ");
INSERT INTO bru_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Cũai ki ta‑ỡi án neq: “Noau chóh mới cỡt sốt cớp parchĩn hếq? Mới ễ cachĩt cứq machớng mới khoiq cachĩt cũai Ê-yip-tô ki tỡ?” Môi-se sâng ngcŏh, cớp án chanchớm neq: “Bữn cũai hữm chơ máh ranáq cứq khoiq táq.” ");
INSERT INTO bru_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Toâq puo dáng tễ ranáq nâi, án chuaq ễ cachĩt Môi-se. Ma Môi-se lúh pỡq ỡt pỡ cruang Madian. Tữ án toâq pỡ ki, án tacu rlu cheq dỡq chữong. ");
INSERT INTO bru_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ỡt pỡ ki, bữn manoaq cũai tễng rit sang yỗn cũai Madian, ramứh Yê-trô. Án bữn tapul náq con mansễm. Tâng tangái ki, tỗp mansễm ki pỡq ŏh dỡq tễ dỡq chữong ki; chơ alới tốh chóq tâng tapuang yỗn tỗp mbễq cớp cữu mpoaq alới nguaiq. ");
INSERT INTO bru_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Bữn máh cũai mantán canŏ́h toâq tuih tỗp mansễm ki. Ma Môi-se mut chuai tỗp mansễm ki, cớp án ŏh dỡq yỗn máh charán mansễm ki hỡ. ");
INSERT INTO bru_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Toâq alới chu pỡ dống, mpoaq alới blớh neq: “Nŏ́q tangái nâi anhia chu cláih lứq?” ");
INSERT INTO bru_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Alới ta‑ỡi neq: “Bữn manoaq cũai Ê-yip-tô toâq chuai hếq yỗn vớt tễ cũai mantán dốq ễ tuih hếq. Ma hỡn tễ ki ễn, án chuai ŏh dỡq yỗn charán hái nguaiq.” ");
INSERT INTO bru_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Chơ mpoaq alới blớh loah neq: “Cũai ki ỡt léq? Cỗ nŏ́q anhia chu táh chíq án? Sanua anhia pỡq coâiq loah án yỗn toâq cha dỗi cớp hái.” ");
INSERT INTO bru_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Chơ Môi-se pruam ỡt cớp alới, cớp Yê-trô chiau con mansễm án, ramứh Si-pô-ra, yỗn Môi-se táq lacuoi. ");
INSERT INTO bru_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Dũn tễ ki, lacuoi Môi-se canỡt muoi lám con samiang. Chơ Môi-se pai neq: “Cứq la cũai mpha cruang, ma cứq pỡq tarôq ỡt cruang noau; ngkíq cứq amứh con samiang cứq la Kêr-sôm.” ");
INSERT INTO bru_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Sa‑ữi cumo tễ ki, puo cũai Ê-yip-tô cuchĩt, ma tỗp proai cũai I-sarel noâng táq sũl cũai Ê-yip-tô. Alới cuclỗiq cucling ễq yỗn noau chuai. Sưong alới cuclỗiq cucling ki chỗn toâq pỡq cutũr Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Yiang Sursĩ sâng samữong alới cuclỗiq cucling, cớp án sanhữ loah tễ máh ŏ́c án khoiq parkhán cớp A-praham, I-sac, cớp Yacốp. ");
INSERT INTO bru_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yiang Sursĩ hữm cũai I-sarel cỡt sũl cũai Ê-yip-tô, ngkíq án sâng sarũiq táq tỗp alới. ");
INSERT INTO bru_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Bữn muoi tangái Môi-se ntôm bán cữu cớp mbễq yacũn án Yê-trô, la cũai tễng rit sang tâng tỗp Madian. Án dững charán ki pỡq luat ntốq aiq, toâq pỡ cóh Si-nai, la cóh khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ỡt tâng ntốq ki bữn manoaq ranễng Yiang Sursĩ sapáh yỗn Môi-se hữm pla ũih tâng prul rambũ. Chơ Môi-se cloân níc chu prul ca bữn pla ũih blữ ma tỡ bữn cat. ");
INSERT INTO bru_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Môi-se chanchớm neq: “Ô! Salễh lứq! Nŏ́q bữn pla ũih tâng prul rambũ ma rambũ ki tỡ bữn cat? Voai! Cứq ễ mut nhêng cheq.” ");
INSERT INTO bru_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Toâq Yiang Sursĩ hữm Môi-se tayáh mut cheq, án arô Môi-se tễ prul rambũ ca bữn pla ũih ki, pai neq: “Môi-se! Ơ Môi-se ơi!” Môi-se ta‑ỡi loah sưong ki: “Ơq! Cứq nâi.” ");
INSERT INTO bru_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Chơ Yiang Sursĩ pai ễn neq: “Chỗi mut cheq. Cóq mới pũot chíq cỡp tễ ayững mới, yuaq mới ntôm tayứng tâng ntốq miar khong cứq. ");
INSERT INTO bru_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Cứq la Yiang Sursĩ achúc achiac anhia A-praham sang, I-sac sang, cớp Yacốp sang.” Ngkíq Môi-se cupât chíq moat án bữm, cỗ án tỡ khớn nhêng chu Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yiang Sursĩ pai ễn neq: “Cứq khoiq hữm chơ noau táq túh coat lứq proai cứq tâng cruang Ê-yip-tô ki. Cứq khoiq sâng sưong alới cuclỗiq cucling yỗn cứq toâq chuai alới yỗn vớt tễ cỡt sũl cũai Ê-yip-tô. Cứq dáng tỗp alới chĩuq túh coat sa‑ữi. ");
INSERT INTO bru_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ngkíq cứq toâq chuai tỗp alới yỗn vớt tễ ranáq túh coat cũai Ê-yip-tô táq. Cớp cứq ễ dững alới loŏh tễ cruang Ê-yip-tô, chơ pỡq chu ntốq cutễq la‑a cớp phốn phuor o. Bân ntốq ki bữn tỗp Cana-an, Hêt, Amô-rit, Pê-rasit, Hê-vit, cớp Yê-but, nheq tỗp alới ỡt tâng cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Cứq bữn sâng samoât samơi sưong tỗp proai cứq, cớp cứq hữm cũai Ê-yip-tô padâm alới. ");
INSERT INTO bru_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Chơ sanua nâi cứq ớn mới pỡq chu puo, yỗn mới ayông proai cứq loŏh tễ cruang ki.” ");
INSERT INTO bru_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ma Môi-se ta‑ỡi loah Yiang Sursĩ neq: “Cứq la cũai miat sâng. Nŏ́q têq cứq pỡq ramóh puo cớp ayông cũai I-sarel loŏh tễ cruang Ê-yip-tô?” ");
INSERT INTO bru_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Yiang Sursĩ pai neq: “Cứq lứq ỡt níc cớp mới. Nâi la tếc yỗn mới dáng samoât samơi cứq ớn yỗn mới pỡq. Toâq mới dững cũai ki loŏh tễ cruang Ê-yip-tô, tỗp mới bữn sang toam cứq tâng cóh nâi toâp.” ");
INSERT INTO bru_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ma Môi-se blớh loah Yiang Sursĩ neq: “Toâq cứq pỡq ramóh proai tỗp I-sarel, cớp toâq cứq atỡng alới neq: ‘Yiang Sursĩ achúc achiac anhia sang, án ớn cứq toâq pỡ anhia,’ ki alới blớh cứq: ‘Ntrớu ramứh án?’ Nŏ́q cứq ễ ta‑ỡi alới?” ");
INSERT INTO bru_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Yiang Sursĩ ta‑ỡi án neq: “Cứq la Cứq toâp. Cớp mới cóq atỡng tỗp I-sarel neq: ‘Án ca bữn ramứh Cứq la Cứq ớn cứq toâq pỡq anhia.’ ");
INSERT INTO bru_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Cóq mới atỡng máh cũai I-sarel neq: ‘Yiang Sursĩ achúc achiac anhia A-praham, I-sac, cớp Yacốp sang, án khoiq ớn cứq toâq pỡ anhia.’ Nâi la ramứh cứq mantái níc, cớp cóq dũ dỡi cũai dŏq cứq ramứh nâi. ");
INSERT INTO bru_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Sanua cóq mới parỗm máh cũai sốt tỗp I-sarel, chơ atỡng yỗn alới dáng neq: Yiang Sursĩ achúc achiac anhia A-praham, I-sac, cớp Yacốp sang khoiq sapáh chóq cứq. Cớp án ớn cứq atỡng anhia neq: ‘Cứq khoiq tapoang nhêng cớp hữm dũ ramứh cũai Ê-yip-tô táq chóq anhia. ");
INSERT INTO bru_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Cứq khoiq chanchớm samoât lứq ễ dững aloŏh anhia tễ cruang Ê-yip-tô, la ntốq noau táq anhia túh coat sa‑ữi lứq. Cớp cứq dững anhia pỡq ỡt pỡ cutễq phuor o. Bân ntốq ki bữn tỗp Cana-an, Hêt, Amô-rit, Pê-rasit, Hê-vit, cớp Yê-but; nheq tỗp alới ỡt tâng cruang ki.’ ");
INSERT INTO bru_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Máh proai cứq, alới lứq trĩh parnai mới pai. Moâm ki, mới cớp máh cũai sốt tỗp I-sarel cóq pỡq ramóh puo cớp atỡng án neq: ‘Yiang Sursĩ tỗp Hê-brơ khoiq sapáh yỗn tỗp hếq chơ. Sanua tỗp hếq sễq tễ puo yỗn hếq têq pỡq pái tangái tâng ntốq aiq dŏq chiau crơng sang yỗn Yiang Sursĩ hếq.’ ");
INSERT INTO bru_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Cứq dáng samoât lứq la puo tỡ yỗn anhia loŏh tễ cruang án, khân cứq ma tỡ bữn ễp án. ");
INSERT INTO bru_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ngkíq nỡ‑ra cứq apáh chớc cứq toâq cứq táq yỗn cũai Ê-yip-tô ramóh túh coat. Cứq táq ranáq salễh yỗn alới ngcŏh, chơ ntun ki, puo ễ acláh yỗn anhia pỡq. ");
INSERT INTO bru_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Cứq ễ táq yỗn cũai Ê-yip-tô yám noap proai cứq. Toâq anhia loŏh tễ cruang ki, anhia tỡ bữn loŏh ống atĩ miat sâng. ");
INSERT INTO bru_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Máh cũai mansễm I-sarel dũ náq cóq pỡq sễq crơng noau táq toâq práq tỡ la yễng cớp tampâc tễ máh cũai Ê-yip-tô ỡt muoi vil, tỡ la muoi dống cớp alới. Chơ cũai I-sarel ĩt máh crơng nâi yỗn con mansễm samiang alới tâc, chơ alới ngcỗi aloŏh mun khong tỗp Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Môi-se ta‑ỡi Yiang Sursĩ neq: “Khân cũai I-sarel ma tỡ bữn sa‑âm cứq, tỡ la tamứng cứq, dếh alới pai anhia tỡ bữn sapáh yỗn cứq hỡ, ki nŏ́q cứq ễ pai?” ");
INSERT INTO bru_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ngkíq Yiang Sursĩ blớh loah Môi-se neq: “Acán ntrớu mới yống?” Môi-se ta‑ỡi loah: “Ơq! Ralỡng.” ");
INSERT INTO bru_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yiang Sursĩ atỡng Môi-se neq: “Mới atáih asễng chu cutễq.” Tữ án atáih, ralỡng ki cỡt cusân. Cớp Môi-se lúh tễ cusân ki. ");
INSERT INTO bru_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Chơ Yiang Sursĩ pai ễn neq: “Âu mới yống soi án!” Ngkíq Môi-se pũp asễng yống soi cusân ki. Chơ cusân ki cỡt loah ralỡng. ");
INSERT INTO bru_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yiang Sursĩ pai chóq Môi-se neq: “Cóq mới táq nneq, yỗn máh cũai I-sarel bữn dáng samoât lứq cứq khoiq sapáh yỗn mới chơ. Cứq la Yiang Sursĩ achúc achiac anhia A-praham, I-sac, cớp Yacốp sang tễ mbŏ́q.” ");
INSERT INTO bru_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yiang Sursĩ ớn Môi-se neq: “Cóq mới amut atĩ mới chu clống au tuar mới sớp ki.” Chơ Môi-se táq ariang Yiang Sursĩ ớn. Toâq án aloŏh loah atĩ, chơ atĩ án cỡt tut cuyal, cloc lứq. ");
INSERT INTO bru_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Chơ Yiang Sursĩ pai ễn neq: “Mới amut loah atĩ mới chu clống au tuar ki.” Chơ Môi-se táq ngkíq. Toâq án aloŏh loah atĩ, ki cỡt loah patoat tiaq. ");
INSERT INTO bru_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yiang Sursĩ pai ễn neq: “Khân alới ma tỡ bữn sa‑âm mới, tỡ la noap ranáq salễh trỗ muoi, pĩeiq alới noap ranáq salễh trỗ bar cống bữn. ");
INSERT INTO bru_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ma khân bar ranáq salễh nâi ma alới tỡ bữn noap, cớp alới tỡ ễq tamứng santoiq mới, ki cóq mới puoc dỡq tễ crỗng Nil, chơ tốh tâng cutễq. Ngkíq dỡq ki cỡt machớng aham.” ");
INSERT INTO bru_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ma Môi-se pai neq: “Yiang Sursĩ ơi! Sễq anhia chỗi ớn cứq pỡq. Cứq la cũai tỡ bữn khễuq táq ntỡng. Tễ bo anhia mbỡiq táq ntỡng cớp cứq toau toâq sanua, la cứq sâng coat lứq ễ táq ntỡng yỗn raloaih.” ");
INSERT INTO bru_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Chơ Yiang Sursĩ blớh Môi-se neq: “Noau tễng bỗq cũai? Noau táq yỗn cũai cỡt túng, tỡ la ngong? Noau táq yỗn cũai cỡt moat poang, tỡ la moat sũt? Ống cứq, la Yiang Sursĩ, toâp táq ranáq ngkíq. ");
INSERT INTO bru_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Môi-se ơi! Sanua cóq mới pỡq. Cứq lứq chuai yỗn mới têq táq ntỡng, cớp cứq atỡng mới ntrớu mới ễ pai.” ");
INSERT INTO bru_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ma Môi-se noâng rasuon neq: “Cứq tỡ ễq pỡq. Sễq Ncháu ớn cũai canŏ́h pỡq táq ranáq nâi.” ");
INSERT INTO bru_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Chơ Yiang Sursĩ sâng cutâu mứt chóq Môi-se, cớp án blớh neq: “Nŏ́q tễ ai mới tỗp Lê-vi, ramứh Arôn? Cứq dáng án khễuq táq ntỡng. Cớp sanua nâi án ntôm toâq ễ ramóh mới. Án sâng bũi pahỡm ramóh loah mới. ");
INSERT INTO bru_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Mới têq atỡng án, chơ ớn án atỡng yỗn cũai canŏ́h. Cứq ễ chuai anhia bar náq yỗn têq táq ntỡng, cớp cứq ớn ranáq anhia cóq táq. ");
INSERT INTO bru_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Bữn Arôn toâp pai tang mới, atỡng cũai I-sarel. Táq ngkíq, mới la samoât Yiang Sursĩ; toâq mới atỡng, án cóq pai ngkíq. ");
INSERT INTO bru_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Cớp mới cóq dững dếh ralỡng nâi. Cỗ nhơ tễ ralỡng nâi têq mới táq ranáq salễh.” ");
INSERT INTO bru_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Chơ Môi-se chu loah pỡ Yê-trô yacũn án, cớp pai neq: “Sễq yỗn hếq chu pỡ sễm ai hếq tâng cruang Ê-yip-tô, yỗn hếq têq dáng alới ỡt bán sũan ma tỡ bữn.” Chơ Yê-trô pruam cớp pai neq: “Anhia pỡq ien khễ, nơ.” ");
INSERT INTO bru_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Bo Môi-se noâng ỡt tâng cruang Madian, Yiang Sursĩ khoiq atỡng án neq: “Cóq mới chu loah pỡ cruang Ê-yip-tô, yuaq dũ náq cũai ca ễ cachĩt mới khoiq cuchĩt nheq chơ.” ");
INSERT INTO bru_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ngkíq, Môi-se yỗn lacuoi cớp máh con samiang án chỗn ỡt tâng cloong aséh dễn, cớp dững alới pỡq chu cruang Ê-yip-tô. Cớp Môi-se yống ralỡng Yiang Sursĩ ớn án dững. ");
INSERT INTO bru_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yiang Sursĩ atỡng Môi-se neq: “Tữ mới toâq pỡ cruang Ê-yip-tô, cóq mới táq lứq samoât máh ranáq salễh choâng moat puo na chớc cứq khoiq chiau yỗn mới. Ma noâng cứq táq yỗn puo tỡ ễq tamứng. Ngkíq án tỡ bữn acláh tỗp I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Chơ cóq mới atỡng puo, cứq la Yiang Sursĩ pai neq: ‘I-sarel nâi la con samiang clúng cứq. ");
INSERT INTO bru_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Cứq khoiq atỡng mới chơ, cóq mới yỗn con samiang cứq pỡq sang toam cứq, ma mới tỡ yỗn. Ngkíq sanua cứq cachĩt chíq con samiang clúng mới.’” ");
INSERT INTO bru_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ntun ễn, tâng ntốq Môi-se cớp con lacuoi án ỡt rlu tâng rana pỡq chu cruang Ê-yip-tô, Yiang Sursĩ ramóh cớp ễ cachĩt Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Ma Si-pô-ra lacuoi Môi-se, án ĩt achũ táq toâq tamáu cớp táq rit cứt yỗn con samiang án; cớp án táq tếc atớt ngcâr ki chóq tâng ayững Môi-se. Cỗ tễ phễp rit táq yỗn aham loŏh, ngkíq yuaq án atỡng Môi-se neq: “Mới cỡt cayac cứq nhơ tễ aham.” Ngkíq Yiang Sursĩ dŏq Môi-se yỗn bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yiang Sursĩ ớn Arôn neq: “Cóq mới pỡq ramóh Môi-se pỡ ntốq aiq.” Ngkíq Arôn pỡq ramóh Môi-se tâng cóh miar khong Yiang Sursĩ, chơ án hũn hĩt Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Chơ Môi-se ruaih loah yỗn Arôn tamứng dũ santoiq Yiang Sursĩ khoiq atỡng toâq ớn án chu pỡ cruang Ê-yip-tô, dếh ranáq salễh Yiang Sursĩ ớn án táq hỡ. ");
INSERT INTO bru_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ngkíq, Môi-se cớp Arôn pỡq pỡ cruang Ê-yip-tô, cớp alới parỗm dũ náq cũai sốt tâng tỗp I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Chơ Arôn atỡng alới dũ ramứh Yiang Sursĩ khoiq atỡng Môi-se. Cớp Môi-se táq dũ ranáq salễh ki choâng moat nheq tữh alới. ");
INSERT INTO bru_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Chơ nheq alới ki sa‑âm. Cớp toâq alới sâng noau pai Yiang Sursĩ khoiq tapoang asễng nhêng salĩq cớp hữm alới ramóh túh arức lứq, ki alới cucốh cớp sang toam Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Vớt ki Môi-se cớp Arôn pỡq ramóh puo, cớp alới atỡng neq: “Yiang Sursĩ, la Ncháu cũai I-sarel, pai neq: ‘Cóq mới acláh proai cứq yỗn alới pỡq chu ntốq aiq dŏq puai rit cha bũi sang toam yám noap cứq.’” ");
INSERT INTO bru_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ma puo blớh neq: “Yiang Sursĩ la noau? Cỗ nŏ́q cứq cóq tamứng án cớp acláh cũai I-sarel pỡq? Cứq tỡ bữn dáng Yiang Sursĩ. Chơ cứq tỡ bữn acláh cũai I-sarel yỗn pỡq.” ");
INSERT INTO bru_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Chơ Môi-se cớp Arôn ta‑ỡi neq: “Yiang Sursĩ tỗp Hê-brơ khoiq sapáh yỗn tỗp hếq chơ. Sanua tỗp hếq sễq puo yỗn hếq têq pỡq pái tangái tâng ntốq aiq dŏq chiau crơng sang yỗn Yiang Sursĩ hếq. Khân tỗp hếq mŏ tỡ bữn pỡq sang Yiang Sursĩ ngkíq, cŏh lơ án cachĩt chíq tỗp hếq na rachíl, tỡ la a‑ĩ ỗn.” ");
INSERT INTO bru_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ma puo ta‑ỡi loah Môi-se cớp Arôn neq: “Nŏ́q anhia khớn yỗn proai cũai I-sarel táh ranáq alới? Cóq nheq cũai sũl ki táq loah ranáq sanua toâp! ");
INSERT INTO bru_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Sanua cũai proai I-sarel cỡt clứng hỡn tễ cũai proai Ê-yip-tô. Ma sanua anhia ễq yỗn alới táh chíq ranáq.” ");
INSERT INTO bru_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tangái ki toâp, puo ớn ranễng ca sốt cũai sũl, cớp cũai I-sarel ca taniap cũai I-sarel canŏ́h táq ranáq, án ớn alới ki neq: ");
INSERT INTO bru_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Anhia chỗi yỗn noâng soc pỡ cũai I-sarel yỗn alới têq táq kec. Cóq anhia ễp yỗn alới pỡq ravoât bữm. ");
INSERT INTO bru_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mŏ sanua nâi cóq cũai I-sarel táq kec ki noap machớng tễ nhũang, tỡ yỗn yeh muoi ŏ́c aléq. Yuaq alới aloah, ngkíq alới cuclỗiq cucling sễq neq: ‘Sễq yỗn hếq pỡq chiau crơng sang yỗn Yiang Sursĩ hếq.’ ");
INSERT INTO bru_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Cóq anhia ravoât ranáq ntâng lứq ễn yỗn tỗp alới táq. Chơ alới tỡ bữn tamứng noâng parnai phếq thũ.” ");
INSERT INTO bru_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Máh ranễng ca sốt cũai sũl, dếh cũai I-sarel ca taniap cũai I-sarel táq ranáq, alới ki toâq pỡ cũai I-sarel cớp pai neq: “Puo pai neq: ‘Cứq tỡ bữn yỗn anhia bữn noâng soc dŏq táq kec. ");
INSERT INTO bru_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Cóq anhia pỡq chuaq bữm soc, ma cóq anhia táq kec sa‑ữi machớng tễ nhũang.’” ");
INSERT INTO bru_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Pân ngkíq, máh cũai I-sarel ma pỡq chuaq bữm soc dũ ntốq tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Cớp máh ranễng puo ca sốt cũai sũl ki, alới ớn níc neq: “Cóq anhia táq dũ ŏ́c kec cu rangái machớng tễ nhũang sĩa, tam tỡ bữn noau yỗn anhia bữn soc.” ");
INSERT INTO bru_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Chơ máh cũai ranễng ki toân máh cũai I-sarel ca taniap tỗp I-sarel táq ranáq. Cớp alới blớh neq: “Cỗ nŏ́q tỗp anhia tỡ bữn táq dũ kec cu rangái machớng anhia khoiq táq tễ nhũang?” ");
INSERT INTO bru_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Chơ máh cũai I-sarel ca taniap tỗp I-sarel táq ranáq, alới pỡq pỡ puo cớp cuclỗiq cucling pai neq: “Cỗ nŏ́q anhia mŏ táq tỗp hếq ngkíq? ");
INSERT INTO bru_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Alới tỡ bữn yỗn hếq soc, ma noâng alới ớn hếq táq kec. Cớp sanua alới toân hếq hỡ. Tỗp anhia toâp tỡ bữn táq pĩeiq.” ");
INSERT INTO bru_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Chơ puo ta‑ỡi neq: “Tỗp anhia aloah, tỡ ễq táq ranáq! Yuaq ngkíq, anhia sễq níc ễ pỡq chiau crơng sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sanua cóq anhia chu loah pỡq táq ranáq machớng tiaq. Tỡ bữn noau yỗn tỗp anhia bữn soc, mŏ cóq anhia táq yỗn dũ máh kec machớng tễ nhũang.” ");
INSERT INTO bru_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ngkíq, máh cũai taniap tỗp proai I-sarel dáng bữn túh coat lứq, yuaq puo anoat cóq táq dũ kec machớng tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Toâq alới loŏh tễ dống puo, chơ alới hữm Môi-se cớp Arôn tayứng acoan alới ngki, ");
INSERT INTO bru_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","cớp tỗp alới nhôp Môi-se cớp Arôn, pai neq: “Yiang Sursĩ dáng chơ máh ranáq anhia khoiq táq. Hếq sễq án yỗn anhia roap tôt, yuaq anhia táq yỗn puo cớp máh ranễng án táq túh coat chóq tỗp hếq. Anhia táq ngkíq, la tỡ bữn mpha ntrớu anhia avơi dau yỗn alới cachĩt chíq hếq.” ");
INSERT INTO bru_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Chơ Môi-se cuclỗiq cucling chóq Yiang Sursĩ neq: “Cucốh Yiang Sursĩ ơi! Nŏ́q anhia tỡ bữn sâng sarũiq táq chóq tỗp proai anhia? Cỗ nŏ́q anhia yỗn cứq toâq pỡ nâi? ");
INSERT INTO bru_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tữ cứq pỡq ramóh puo atỡng nhơ ramứh anhia, ki án táq yỗn proai anhia ramóh túh coat sa‑ữi lứq lơ ễn. Ma cứq tỡ hữm anhia chuai ntrớu tỗp alới.” ");
INSERT INTO bru_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Chơ Yiang Sursĩ ta‑ỡi Môi-se neq: “Tỡ bữn dũn noâng cứq yỗn mới hữm ranáq cứq ễ táq chóq puo. Nhơ tễ chớc cứq, ki cứq ễp yỗn án tuih proai cứq pỡq. Nhơ tễ chớc cứq, án ễ tuih aloŏh alới tễ cruang án.” ");
INSERT INTO bru_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Yiang Sursĩ táq ntỡng cớp Môi-se neq: “Cứq la ramứh Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Cứq khoiq sapáh yỗn A-praham, I-sac, cớp Yacốp dáng cứq la Yiang Sốt Toâr Lứq. Mŏ cứq tỡ bữn yỗn alới dáng ramứh cứq lứq. ");
INSERT INTO bru_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Cớp cứq khoiq parkhán cớp alới ki, ễ chiau cruang Cana-an yỗn alới ndỡm, la cutễq alới tarôq ỡt ariang cũai tễ cruang canŏ́h. ");
INSERT INTO bru_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Cứq bữn sâng sưong cũai proai I-sarel cuclỗiq cucling, yuaq cũai proai Ê-yip-tô táq yỗn alới cỡt sũl. Cớp cứq sanhữ loah parnai cứq khoiq parkhán tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Yuaq ngkíq, cóq mới atỡng proai I-sarel la cứq pai neq: ‘Cứq la Yiang Sursĩ. Nỡ‑ra cứq acláh anhia tễ cỡt sũl cũai Ê-yip-tô. Cỗ nhơ tễ chớc cứq táq ranáq ki, cứq manrap cũai Ê-yip-tô cớp chuai amoong anhia. ");
INSERT INTO bru_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Cứq ễ táq yỗn anhia cỡt proai cứq, cớp cứq cỡt Yiang Sursĩ anhia. Ngkíq anhia dáng cứq la Yiang Sursĩ, la Ncháu anhia, án ca acláh anhia tễ cỡt sũl cũai Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Cứq ễ dững tỗp anhia mut chu cruang cứq khoiq parkhán samoât lứq yỗn achúc achiac anhia la A-praham, I-sac, cớp Yacốp. Cứq chiau cruang cutễq ki yỗn anhia ndỡm. Cứq la Yiang Sursĩ toâp pai santoiq nâi.’” ");
INSERT INTO bru_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Chơ Môi-se atỡng ŏ́c ki yỗn cũai proai I-sarel dáng, ma alới tỡ bữn trĩh parnai Môi-se, yuaq alới pê pahỡm cỗ tian cỡt sũl cớp ramóh túh coat lứq. ");
INSERT INTO bru_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Vớt ki, Yiang Sursĩ atỡng loah Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Cóq mới pỡq atỡng puo, cóq án acláh proai cũai I-sarel yỗn alới loŏh tễ cruang án.” ");
INSERT INTO bru_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ma Môi-se ta‑ỡi Yiang Sursĩ neq: “Cứq la cũai tỡ bữn khễuq táq ntỡng ntrớu. Tỗp I-sarel nâi tỡ sâng ễ tamứng cứq, casỡn puo ễn, dỡi léq án ma tamứng cứq.” ");
INSERT INTO bru_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Chơ Yiang Sursĩ ớn Môi-se cớp Arôn neq: “Cóq anhia atỡng cũai proai I-sarel cớp puo, la cứq toâp rưoh anhia bar náq yỗn dững cũai I-sarel loŏh tễ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tâng pưn nâi atỡng tễ achúc achiac Môi-se cớp Arôn. Ruben la con samiang clúng Yacốp. Ruben bữn máh con samiang pỗn náq neq: Hanoc, Palu, Hê-trôn, cớp Car-mi. Nheq tữh alới la sâu tỗp Ruben. ");
INSERT INTO bru_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Si-mê-ôn bữn con samiang tapoât náq neq: Yê-muol, Yamin, Ô-hat, Yakin, Sô-har, cớp Sau-lơ. Mpiq Sau-lơ la cũai tễ cruang Cana-an. Nheq tữh alới la sâu tỗp Si-mê-ôn. ");
INSERT INTO bru_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lê-vi bữn con samiang pái náq neq: Kêr-sôn, Cô-hat, cớp Mê-rari. Nheq nâi la sâu tỗp Lê-vi. Lê-vi bữn tamoong la muoi culám pái chít tapul cumo. ");
INSERT INTO bru_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kêr-sôn bữn con samiang bar náq cỡt sâu neq: Lip-ni cớp Si-mê. ");
INSERT INTO bru_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Cô-hat bữn con samiang pỗn náq neq: Am-ram, I-sar, Hep-rôn, cớp Usiel. Cô-hat bữn tamoong la muoi culám pái chít la pái cumo. ");
INSERT INTO bru_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mê-rari bữn con samiang bar náq neq: Mali cớp Muchi. Nheq tữh cũai ki tễ tŏ́ng toiq Lê-vi. ");
INSERT INTO bru_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Am-ram ĩt niang Yôc-abet, avia án, táq lacuoi. Cớp lacuoi án bữn con samiang bar náq: Arôn cớp Môi-se. Am-ram bữn tamoong muoi culám pái chít tapul cumo. ");
INSERT INTO bru_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","I-sar bữn con samiang pái náq neq: Cô-ra, Ne-phéc, cớp Si-cri. ");
INSERT INTO bru_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiel bữn con samiang pai náq neq: Mi-sel, El-saphan, cớp Si-tri. ");
INSERT INTO bru_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arôn racoâiq cớp E-li-saba la amuaq Nasôn, con cumũr Ami-nadap. E-li-saba cớp Arôn bữn con samiang pỗn náq neq: Nadap, Abi-hu, E-lia-sơ, cớp I-thamar. ");
INSERT INTO bru_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Cô-ra bữn con samiang pái náq neq: Asir, El-cana, cớp Abia-sap. Nheq nâi la sâu tỗp Cô-ra. ");
INSERT INTO bru_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","E-lia-sơ con samiang Arôn, án ĩt con cumũr Putiel táq lacuoi. Chơ alới bữn con samiang muoi noaq, ramứh Phi-niat. Máh cũai ki la tễ tŏ́ng toiq Lê-vi. ");
INSERT INTO bru_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Arôn cớp Môi-se la tễ tỗp alới ki tê; Yiang Sursĩ ớn alới neq: “Cóq anhia dững máh tỗp I-sarel loŏh tễ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Cớp alới bar náq ki khoiq atỡng puo cóq acláh cũai proai I-sarel yỗn loŏh ien khễ. ");
INSERT INTO bru_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Toâq Yiang Sursĩ atỡng Môi-se tâng cruang Ê-yip-tô, ");
INSERT INTO bru_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","án pai neq: “Cứq Yiang Sursĩ toâp pai santoiq nâi! Cóq mới atỡng puo dũ ramứh cứq atỡng mới.” ");
INSERT INTO bru_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ma Môi-se ta‑ỡi neq: “Yiang Sursĩ ơi! Cứq tỡ bữn khễuq táq ntỡng. Nŏ́q têq puo tamứng cứq?” ");
INSERT INTO bru_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Chơ Yiang Sursĩ ta‑ỡi Môi-se neq: “Nhêng nâi! Cứq táq yỗn mới bữn chớc máh yiang choâng moat puo. Cớp Arôn, ai mới, án cỡt cũai tang bỗq mới. ");
INSERT INTO bru_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Cóq mới atỡng loah Arôn dũ ŏ́c cứq khoiq ớn mới. Cớp Arôn ễn, cóq atỡng loah puo cóq án acláh cũai proai I-sarel yỗn loŏh tễ cruang án. ");
INSERT INTO bru_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ma cứq ễ táq yỗn mứt pahỡm puo cỡt coang tỡ ễq tamứng santoiq mới. Tam cứq táq ranáq salễh sa‑ữi, ");
INSERT INTO bru_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","mŏ puo tỡ bữn noap. Vớt tễ ki cứq ễ manrap cũai proai Ê-yip-tô yỗn ramóh ŏ́c túh coat lứq. Chơ, cứq dững aloŏh máh tỗp I-sarel la proai cứq tễ cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Chơ cũai proai Ê-yip-tô bữn dáng cứq la Yiang Sursĩ, toâq cứq táq túh coat chóq tỗp alới, cớp toâq cứq dững aloŏh cũai I-sarel tễ cruang alới.” ");
INSERT INTO bru_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Chơ Môi-se cớp Arôn trĩh dũ ŏ́c Yiang Sursĩ ớn alới táq. ");
INSERT INTO bru_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Bo alới bar náq pỡq atỡng puo, Môi-se bữn tacual chít cumo, cớp Arôn bữn tacual chít la pái cumo. ");
INSERT INTO bru_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yiang Sursĩ atỡng Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Toâq puo ớn anhia táq ranáq salễh cỗ yoc ễ dáng Yiang anhia lứq ớn anhia toâq, cóq mới ớn Arôn ĩt ralỡng, atáih tâng cutễq yáng moat puo. Chơ ralỡng ki cỡt cusân toâp.” ");
INSERT INTO bru_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ngkíq Môi-se cớp Arôn pỡq ramóh puo, cớp alới táq puai samoât samơi máh parnai Yiang Sursĩ khoiq atỡng chơ. Arôn ĩt ralỡng án, atáih yáng moat puo cớp cũai ayững atĩ puo. Chơ ralỡng ki cỡt cusân. ");
INSERT INTO bru_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Chơ puo arô máh cũai rangoaiq cớp máh cũai mo, yỗn alới táq machớng ki tê na ramoon. ");
INSERT INTO bru_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tỗp alới ĩt ralỡng alới bữm, chơ atáih tâng cutễq. Cớp ralỡng ki cỡt cusân. Mŏ cusân Arôn lưn cha chíq cusân alới. ");
INSERT INTO bru_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ma mứt pahỡm puo noâng coang. Án tỡ bữn tamứng Môi-se cớp Arôn. Ŏ́c ki cỡt machớng Yiang Sursĩ khoiq pai chơ. ");
INSERT INTO bru_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Vớt ki, Yiang Sursĩ atỡng Môi-se ễn neq: “Mứt pahỡm puo noâng coang; án tỡ acláh yỗn cũai proai I-sarel pỡq. ");
INSERT INTO bru_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tarưp parnỡ cóq mới pỡq ramóh loah puo bo án pỡq chu crỗng Nil. Cớp cóq mới dững ralỡng ca cỡt cusân ki, ỡt acoan puo pỡ pứh dỡq. ");
INSERT INTO bru_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Cóq mới atỡng puo neq: ‘Yiang Sursĩ, la Ncháu máh cũai Hê-brơ, ớn cứq toâq atỡng puo neq: Cóq mới acláh máh cũai proai cứq yỗn loŏh tễ cruang nâi pỡq sang cứq tâng ntốq aiq. Ma toau sanua mới noâng tỡ bữn tamứng.’ ");
INSERT INTO bru_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Puo ơi! Sanua Yiang Sursĩ ễ yỗn anhia dáng samoât samơi án toâp la lứq Yiang na án táq ranáq salễh. Nhêng! Ngkếq cứq ĩt ralỡng nâi toân cloong crỗng Nil. Chơ dỡq Nil nâi cỡt chíq aham. ");
INSERT INTO bru_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Chơ sĩaq cuchĩt nheq, dỡq cỡt nsóq, cớp máh cũai Ê-yip-tô tỡ têq nguaiq noâng dỡq ki.” ");
INSERT INTO bru_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới atỡng Arôn yỗn ĩt ralỡng án sadoi chu máh crỗng, dỡq pong hau, cớp dỡq amống tâng cruang Ê-yip-tô. Ngkíq dỡq tâng cruang ki ễ cỡt aham nheq, dếh dỡq tâng aluoi cớp tâng khang tâng dống sũ tỗp proai Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Chơ Môi-se cớp Arôn, alới táq dũ ŏ́c puai máh Yiang Sursĩ atỡng. Yáng moat puo cớp cũai ayững atĩ án, Arôn ĩt ralỡng, chơ toân tâng cloong dỡq Nil. Ngkíq dỡq ki cỡt chíq aham dũ ntốq cu nnơi tâng cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Máh sĩaq cuchĩt nheq, cớp dỡq cỡt nsóq. Dỡq tâng cruang Ê-yip-tô bữn moang aham sâng. Yuaq ngkíq, cũai proai Ê-yip-tô tỡ têq nguaiq. ");
INSERT INTO bru_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Chơ cũai mo táq machớng ki tê na ramoon alới, ma mứt pahỡm puo la noâng coang. Cỡt riang Yiang Sursĩ khoiq pai chơ, puo tỡ ễq tamứng Môi-se cớp Arôn. ");
INSERT INTO bru_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Puo tỡ bữn kễ ntrớu tháng; ma án chu loah chu dống án. ");
INSERT INTO bru_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Chơ cũai proai Ê-yip-tô, alới cóq píq dỡq parníq cheq tor crỗng Nil, yuaq tỗp alới tỡ têq nguaiq noâng dỡq tễ crỗng Nil. ");
INSERT INTO bru_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Tapul tangái khoiq vớt, noap tễ tangái Yiang Sursĩ táq crỗng Nil cỡt aham. ");
INSERT INTO bru_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới pỡq ramóh puo, cớp atỡng án cứq la Yiang Sursĩ pai neq: ‘Cóq mới acláh proai cứq yỗn alới têq pỡq sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Khân mới tỡ bữn acláh alới, cứq ễ táq tâng cruang mới yỗn poân moang acơp. ");
INSERT INTO bru_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Dỡq crỗng Nil ễ poân moang acơp. Acơp ki chỗn tễ dỡq mut tâng dống mới, tâng clống mới bếq, cớp tâng cachơng mới bếq, dếh tâng dống cũai ayững atĩ mới hỡ. Cớp acơp mut dếh tâng lo cớp tâng tapuang noau cunhoau bễng. ");
INSERT INTO bru_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Acơp ki sadáih póc tâng tỗ mới, dếh tâng cũai proai cớp cũai ayững atĩ mới hỡ.’” ");
INSERT INTO bru_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Chơ Yiang Sursĩ atỡng Môi-se ễn neq: “Cóq mới ớn Arôn ĩt ralỡng án sadoi chu máh crỗng, dỡq pong hau, cớp dỡq amống, táq yỗn acơp loŏh tễ dỡq, chơ chỗn tâng cloong cutễq chũop nheq cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ngkíq, Arôn sadoi ralỡng chu máh dỡq tâng cruang Ê-yip-tô ki. Chơ acơp chỗn tễ dỡq, poân nheq dũ ntốq tâng cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ma cũai mo táq machớng ki tê na ramoon alới. Alới táq yỗn acơp chỗn tâng cloong cutễq. ");
INSERT INTO bru_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Vớt ki, puo arô Môi-se cớp Arôn, cớp án pai neq: “Sễq anhia câu chuai yỗn Yiang Sursĩ ĩt loah nheq acơp nâi tễ cứq cớp máh cũai proai cứq. Ngkíq cứq lứq acláh máh tỗp anhia yỗn pỡq chiau crơng sang yỗn Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Môi-se ta‑ỡi neq: “Cứq bũi pahỡm câu chuai yỗn anhia. Cóq anhia atỡng cứq bo léq anhia yoc cứq câu yỗn anhia, cũai proai anhia, cớp ayững atĩ anhia. Cứq lứq câu yỗn acơp ki tỡ bữn ỡt noâng tâng dống anhia, ma ỡt tâng crỗng Nil sâng.” ");
INSERT INTO bru_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Puo ta‑ỡi neq: “Sễq mới câu tangái parnỡ.” Môi-se ta‑ỡi neq: “Pĩeiq ơiq! Cứq lứq táq ariang anhia pai. Ngkíq anhia têq dáng raloaih la tỡ bữn yiang aléq ma machớng Yiang Sursĩ la Yiang tỗp hếq. ");
INSERT INTO bru_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Chơ acơp ki tỡ bữn ỡt noâng tâng dống anhia, tỡ la dống cũai proai anhia cớp cũai ayững atĩ anhia. Ma án noâng ỡt tâng crỗng Nil sâng.” ");
INSERT INTO bru_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Chơ, Môi-se cớp Arôn loŏh tễ puo. Cớp Môi-se câu sễq Yiang Sursĩ ĩt chíq acơp tỡ yỗn táq túh coat noâng puo. ");
INSERT INTO bru_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ngkíq Yiang Sursĩ táq ariang santoiq Môi-se sễq. Nheq tữh acơp tâng dống, tâng nchŏh, cớp tâng ruang bát, la cuchĩt nheq. ");
INSERT INTO bru_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Cũai Ê-yip-tô parỗm máh acơp cỡt bốq toâr lứq, cớp nsóq pláh chũop nheq cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ma toâq puo hữm máh acơp ki tỡ bữn ỡt noâng, ngkíq mứt án cỡt coang loah sĩa. Án tỡ bữn tamứng Môi-se cớp Arôn, ariang Yiang Sursĩ khoiq pai tễ nhũang chơ. ");
INSERT INTO bru_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới ớn Arôn toân cloong cutễq toâq ralỡng án. Moâm án toân, chơ phốn cutễq cỡt chíq anhuaq chũop nheq cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Alới bar náq trĩh santoiq ki. Arôn ĩt ralỡng án cớp toân cloong cutễq. Ngkíq, nheq phốn cutễq tâng cruang Ê-yip-tô cỡt chíq anhuaq. Cớp anhuaq ki brốh máh cũai cớp charán. ");
INSERT INTO bru_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Máh cũai mo chim ễ táq machớng ki tê, ma tỡ têq. Anhuaq ki brốh dũ náq cũai cớp dũ lám charán. ");
INSERT INTO bru_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Máh cũai mo atỡng puo neq: “Ống atĩ Yiang Sursĩ toâp táq ranáq nâi!” Mŏ mứt pahỡm puo noâng coang sĩa. Án tỡ bữn tamứng Môi-se cớp Arôn, cỡt machớng Yiang Sursĩ khoiq pai chơ. ");
INSERT INTO bru_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Chơ Yiang Sursĩ atỡng Môi-se neq: “Tarưp parnỡ cóq mới tamỡ tễ cláih, pỡq ramóh puo bo án pỡq pỡ crỗng, cớp cóq mới atỡng án neq: ‘Cứq Yiang Sursĩ ớn mới cóq acláh máh cũai proai cứq yỗn alới têq pỡq sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Khân mới tỡ bữn acláh proai cứq, ki cứq ễ táq yỗn aluai toâq brốh mới cớp máh cũai proai mới, dếh cũai ayững atĩ mới. Cớp aluai ki poân nheq tâng dống mới cớp tâng dống alới hỡ. Dếh tâng cloong cutễq la poân moang aluai. ");
INSERT INTO bru_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ma cứq táq mpha tâng cruang Cô-sơn, la ntốq máh cũai proai cứq ỡt. Cứq tỡ bữn yỗn aluai mut tâng ntốq ki. Chơ mới têq dáng raloaih cứq Yiang Sursĩ toâp sốt nheq tâng cruang cutễq nâi. ");
INSERT INTO bru_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ranáq ngkíq, la cứq táq mpha yỗn máh cũai proai cứq cớp máh cũai proai mới. Ranáq salễh nâi ễ cỡt tâng tangái parnỡ.’” ");
INSERT INTO bru_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Chơ Yiang Sursĩ táq ranáq ki. Bữn aluai sa‑ữi la‑ỡq mut tâng dống puo cớp tâng dống máh cũai ayững atĩ án. Chũop cruang Ê-yip-tô ki cỡt ralốh nheq cỗ tian tễ aluai. ");
INSERT INTO bru_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ngkíq puo arô sĩa Môi-se cớp Arôn, cớp án pai neq: “Chơ, sanua anhia pỡq chiau crơng sang yỗn Yiang Sursĩ anhia. Ma anhia táq ranáq ki tâng cruang Ê-yip-tô nâi sâng.” ");
INSERT INTO bru_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ma Môi-se ta‑ỡi neq: “Tỡ cỡn ngkíq! Ngcŏh cũai Ê-yip-tô tỡ bữn bũi pahỡm toâq hếq kiac charán chiau sang yỗn Yiang Sursĩ, la Ncháu hếq. Khân hếq chiau sang charán ki bân ntốq alới hữm, cŏh lơ cũai Ê-yip-tô ễ tám tamáu chóq hếq yỗn hếq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Cóq hếq pỡq pái tangái pỡ ntốq aiq dŏq chiau crơng sang yỗn Yiang Sursĩ, la Ncháu hếq, ariang án khoiq ớn hếq táq.” ");
INSERT INTO bru_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ngkíq puo ta‑ỡi neq: “Chơ! Cứq yỗn anhia pỡq chiau crơng sang yỗn Yiang Sursĩ, Ncháu anhia, khân anhia tỡ bữn pỡq yơng. Sanua sễq anhia câu yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Môi-se ta‑ỡi neq: “Vớt hếq loŏh tễ anhia, ki cứq câu sễq tễ Yiang Sursĩ, chơ parnỡ án táq yỗn aluai dễq nheq tễ anhia, tễ cũai ayững atĩ anhia, cớp tễ máh cũai proai anhia. Ma cóq anhia chỗi phếq thũ noâng hếq, tỡ bữn yỗn máh cũai proai pỡq chiau crơng sang yỗn Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Chơ Môi-se loŏh tễ puo, câu sễq tễ Yiang Sursĩ, ");
INSERT INTO bru_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","cớp Yiang Sursĩ táq machớng Môi-se sễq. Aluai ki loŏh nheq tễ puo, máh cũai proai án, dếh cũai ayững atĩ án. Tỡ va muoi lám noâng aluai. ");
INSERT INTO bru_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ma muoi trỗ ễn, puo cỡt mứt coang sĩa. Án tỡ acláh yỗn máh cũai proai pỡq. ");
INSERT INTO bru_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Chơ Yiang Sursĩ atỡng Môi-se ễn neq: “Cóq mới pỡq ramóh puo, cớp atỡng án neq: Yiang Sursĩ la Yiang cũai Hê-brơ pai neq: ‘Cóq mới acláh máh proai cứq yỗn pỡq sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Khân mới noâng catáng cớp tỡ yỗn alới pỡq, ");
INSERT INTO bru_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","cứq ễ táq yỗn máh charán anhia cỡt ỗn; dếh aséh, aséh dễn, lac‑da, ntroŏq, cữu, cớp mbễq cỡt cuchĩt nheq. ");
INSERT INTO bru_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ma cứq táq mpha chóq máh charán cũai I-sarel cớp charán cũai Ê-yip-tô. Charán cũai I-sarel tỡ bữn cuchĩt muoi lám. ");
INSERT INTO bru_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Cứq Yiang Sursĩ anoat ranáq nâi yỗn toâq tâng tangái parnỡ.’” ");
INSERT INTO bru_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Toâq tangái parnỡ, Yiang Sursĩ ễ táq ariang parnai án khoiq pai. Charán cũai Ê-yip-tô cuchĩt nheq, ma charán cũai proai I-sarel tỡ bữn cuchĩt muoi lám loâng. ");
INSERT INTO bru_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Puo ớn cũai blớh tễ ranáq nâi, chơ án dáng charán cũai proai I-sarel tỡ bữn cuchĩt muoi lám loâng. Ma puo noâng coang pahỡm cớp catoâng tỡ yỗn tỗp proai I-sarel pỡq. ");
INSERT INTO bru_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Chơ Yiang Sursĩ atỡng Môi-se cớp Arôn neq: “Cóq mới bỗc ĩt bŏ́h tễ tapéh ũih, bar tỡ la pái carpỗt, chơ yỗn Môi-se prứh achỗn yáng moat puo. ");
INSERT INTO bru_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Chơ bŏ́h ki sapâr achỗn machớng cớp phốn cutễq chũop nheq cruang Ê-yip-tô. Ntốq léq phốn ki satooh, ma pĩeiq tỗ cũai tỡ la charán, lứq cỡt satễng, chơ padŏ́h cỡt bớc prông.” ");
INSERT INTO bru_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Chơ Môi-se cớp Arôn ĩt bŏ́h prứh achỗn yáng moat puo. Bŏ́h ki sapâr achỗn satooh pĩeiq cũai cớp charán, chơ cỡt satễng chũop nheq tỗ cũai cớp charán tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Máh cũai mo tâng cruang Ê-yip-tô, alới tỡ khớn toâq pỡ Môi-se, yuaq tỗ chác alới cỡt nheq satễng, machớng cũai proai Ê-yip-tô tê. ");
INSERT INTO bru_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ma Yiang Sursĩ táq yỗn mứt puo cỡt coang sĩa. Án tỡ bữn tamứng Môi-se cớp Arôn; ranáq nâi cỡt rapĩeiq parnai Yiang Sursĩ khoiq pai chơ. ");
INSERT INTO bru_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Vớt ki Yiang Sursĩ atỡng Môi-se ễn neq: “Tarưp parnỡ tễ cláih mới pỡq ramóh puo, cớp atỡng án neq: ‘Cứq la Yiang Sursĩ, la Ncháu tỗp Hê-brơ. Cứq ớn mới cóq acláh cũai proai cứq yỗn pỡq sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Trỗ nâi cứq tỡ bữn táq túh coat ống cũai ayững atĩ cớp cũai proai mới sâng; ma cứq ễ táq túh coat dếh mới hỡ. Chơ têq mới dáng tâng cutễq nâi tỡ bữn yiang aléq mŏ têq táq ranáq salễh nneq. ");
INSERT INTO bru_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Khân cứq mŏ payư atĩ ễ cachĩt mới cớp cũai proai mới na ỗn, ki tỗp anhia cuchĩt dáp nheq. ");
INSERT INTO bru_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ma cứq noâng dŏq tỗp anhia yỗn bữn tamoong, la cỗ cứq ễ apáh yỗn mới hữm cứq bữn chớc toâr lứq. Cớp cứq yoc dũ cruang tâng cốc cutễq nâi dáng ramứh cứq. ");
INSERT INTO bru_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ma toau sanua mới noâng bữn mứt coang, tỡ yỗn cũai proai cứq pỡq. ");
INSERT INTO bru_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ngkíq, tangái parnỡ máh sanua nâi sĩa, cứq yỗn prễl satooh sa‑ữi lứq. Tỡ nai bữn prễl satooh ariang trỗ nâi tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ngkíq cóq mới ớn noau ĩt crơng crớu cớp pong charán mới tễ ruang, amut chu ntốq bữn capáng. Dũ náq cũai cớp dũ lám charán ỡt yáng tiah pĩeiq ŏ́c prễl satooh chóq, chơ cuchĩt nheq.’” ");
INSERT INTO bru_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Bữn muoi tỗp ayững atĩ puo, alới sâng ngcŏh tễ parnai Yiang Sursĩ pai. Chơ tỗp alới dững charán cớp cũai sũl alới mut chu ntốq bữn capáng. ");
INSERT INTO bru_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ma bữn muoi tỗp canŏ́h, alới tỡ bữn trĩh máh parnai Yiang Sursĩ atỡng. Ngkíq alới dŏq charán cớp sũl alới ỡt yáng tiah. ");
INSERT INTO bru_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Moâm ki, Yiang Sursĩ atỡng Môi-se neq: “Cóq mới sacỡ atĩ achỗn chu paloŏng dŏq prễl satooh asễng pĩeiq cũai cớp charán, dếh crơng sarnóh tâng ruang chũop cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ngkíq Môi-se ĩt ralỡng sadoi chu paloŏng. Chơ Yiang Sursĩ táq yỗn bữn sưong crứm bubữr, bữn prễl satooh, cớp bữn toaih sễng chu cutễq. Yiang Sursĩ táq yỗn ");
INSERT INTO bru_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","prễl satooh asễng sa‑ữi lứq, cớp bữn lalieiq lacang tứng-tooc. Cũai tâng cruang Ê-yip-tô tỡ nai hữm cuyal rasỗ rapŏh ariang nâi. ");
INSERT INTO bru_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tâng cruang Ê-yip-tô dũ ramứh ỡt yáng tiah, dếh cũai, dếh charán la pĩeiq prễl satooh chóq. Cớp sarnóh tâng máh sarái cỡt dớm, dếh dũ ramứh aluang cỡt tacoaih nheq. ");
INSERT INTO bru_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ma ống tâng Cô-sơn la ntốq cũai I-sarel ỡt, prễl tỡ bữn satooh. ");
INSERT INTO bru_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ngkíq puo ớn cũai pỡq coâiq Môi-se cớp Arôn toâq ramóh loah án, cớp pai neq: “Trỗ nâi cứq khoiq táq lôih chơ. Yiang Sursĩ la pĩeiq, ma cứq cớp proai cứq lôih. ");
INSERT INTO bru_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hếq tỡ rơi chĩuq noâng prễl cớp sưong crứm! Sễq anhia câu yỗn Yiang Sursĩ chuai hếq nứng! Cứq ữq samoât lứq ễ acláh yỗn tỗp anhia pỡq. Tỡ bữn túh cóq anhia ỡt noâng tâng cruang nâi.” ");
INSERT INTO bru_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Môi-se ta‑ỡi neq: “Toâq hếq loŏh tễ vil nâi, hếq ễ sacỡ atĩ câu sễq tễ Yiang Sursĩ. Chơ sưong crứm lứq tangứt, cớp prễl tỡ bữn satooh noâng. Ngkíq anhia têq dáng cốc cutễq nâi cỡt khong Yiang Sursĩ toâp. ");
INSERT INTO bru_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ma cứq dáng chơ anhia cớp cũai ayững atĩ anhia tỡ bữn yám noap Yiang Sursĩ, la Ncháu.” ");
INSERT INTO bru_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Bo ki nỡm busín cớp nỡm saro bali cỡt rúng nheq, yuaq saro bali khoiq cỡt palâi chơ, cớp nỡm busín khoiq loŏh piar chơ. ");
INSERT INTO bru_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ma saro mi tỡ bữn rúng, yuaq án tỡ yũah dáh.) ");
INSERT INTO bru_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Toâq Môi-se loŏh tễ puo cớp vil ki, án sacỡ atĩ achỗn cớp câu sễq tễ Yiang Sursĩ. Chơ sưong crứm, prễl, cớp mia tangứt toâp. ");
INSERT INTO bru_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Toâq puo hữm ranáq nâi, án táq lôih sĩa. Mứt pahỡm án cớp cũai ayững atĩ án cỡt coang sĩa. ");
INSERT INTO bru_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Yuaq puo bữn mứt coang, án tỡ bữn acláh tỗp I-sarel pỡq; ranáq nâi cỡt rapĩeiq ariang Yiang Sursĩ khoiq atỡng dŏq na Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Vớt ki, Yiang Sursĩ atỡng Môi-se neq: “Cóq mới pỡq ramóh loah puo sĩa. Cứq khoiq táq yỗn án cớp cũai ayững atĩ án bữn mứt pahỡm coang, la dŏq cứq táq ranáq salễh nâi choâng moat alới, ");
INSERT INTO bru_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","cớp dŏq anhia têq atỡng loah yỗn con châu anhia dáng, la cứq khoiq táq túh coat ntâng lứq chóq cũai Ê-yip-tô bo cứq táq ranáq salễh. Chơ nheq tữh anhia têq dáng samoât, cứq la lứq Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ngkíq Môi-se cớp Arôn pỡq ramóh loah puo, cớp atỡng án neq: “Yiang Sursĩ, la Ncháu tỗp Hê-brơ, pai neq: ‘Noâng dũn maléq mới mantoâr chóq cứq? Cóq mới acláh tỗp proai cứq yỗn alới pỡq sang cứq. ");
INSERT INTO bru_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ma khân mới tỡ bữn trĩh, tâng tangái parnỡ cứq ễ táq yỗn bữn lam mut tâng cruang mới. ");
INSERT INTO bru_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Án toâq cỡt sampứh, cớp póc dũ ntốq cu nnơi chũop cloong cutễq toau tỡ bữn hữm noâng cutễq. Chơ án cáiq nheq máh crơng sarnóh noâng khlâiq tễ prễl púh, dếh aluang noâng tamoong. ");
INSERT INTO bru_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Án mut poân nheq tâng máh dống mới, cớp tâng dống tỗp ayững atĩ mới, dếh tâng dống cũai proai mới hỡ. Ŏ́c salễh nneq, dếh achúc achiac mới tỡ nai hữm yũah.’” Vớt ki, Môi-se chứng clĩ, chơ loŏh tễ ntốq ki. ");
INSERT INTO bru_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Máh tỗp ayững atĩ puo pai chóq án neq: “Maléq dũn noâng hái chĩuq yỗn cũai samiang nâi pakhoq hái? Cóq anhia acláh yỗn samiang tỗp I-sarel pỡq sang Yiang Sursĩ alới. Nŏ́q anhia tỡ bữn dáng, cruang Ê-yip-tô nâi khoiq cỡt ralốh-ralái?” ");
INSERT INTO bru_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Yuaq ngkíq, noau pỡq coâiq Môi-se cớp Arôn yỗn toâq ramóh loah puo. Chơ puo pai neq: “Têq anhia pỡq sang Yiang Sursĩ la Yiang tỗp anhia. Ma noau toâp ễ pỡq?” ");
INSERT INTO bru_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Môi-se ta‑ỡi neq: “Nheq tữh tỗp hếq pỡq nheq, dếh tỗp carnễn cớp tỗp cũai thâu. Cớp hếq ễ dững dếh con samiang con mansễm, cữu, mbễq, cớp ntroŏq hỡ, dŏq táq rit cha bũi sang toam yám noap Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Chơ puo ta‑ỡi neq: “Tỡ têq! Cứq thễ dũan nhơ ramứh Yiang Sursĩ anhia neq: Cứq tỡ yỗn tỗp anhia dững máh mansễm cớp carnễn pỡq nứng anhia. Nâi la ranáq raloaih lứq anhia aloŏh ngê ễ chíl tỗp hếq. ");
INSERT INTO bru_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tỡ têq! Khân tỗp anhia yoc ễ pỡq sang Yiang Sursĩ, ki pỡq ống máh cũai samiang sâng.” Chơ puo ớn noau tuih aloŏh Môi-se cớp Arôn tễ dống án. ");
INSERT INTO bru_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Chơ Yiang Sursĩ atỡng loah Môi-se neq: “Cóq mới payo atĩ mới chu cruang Ê-yip-tô, táq yỗn lam mut cáiq nheq máh crơng sarnóh, cớp dũ ramứh noâng khlâiq tễ prễl púh.” ");
INSERT INTO bru_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ngkíq Môi-se yống ralỡng payo chu ki. Chơ Yiang Sursĩ táq yỗn bữn cuyal tễ angia mandang loŏh phát chu cruang Ê-yip-tô nheq muoi tangái muoi sadâu. Toâq poang tarưp, cuyal phát amut máh lam sa‑ữi lứq chu cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Án póc dũ ntốq tâng cruang Ê-yip-tô. Tễ dỡi nhũang toau toâq dỡi ntun tỡ nai hữm lam sa‑ữi ariang nneq. ");
INSERT INTO bru_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Lam ki pỡq pláh chũop nheq tâng cloong cutễq, toau cutễq cỡt cũm. Máh ramứh tỡ bữn pĩeiq prễl, ki lam cáiq nheq, dếh palâi aluang. Tỡ bữn aluang aloai tỡ la sarnóh ntrớu tâng cruang Ê-yip-tô ma noâng ramoong. ");
INSERT INTO bru_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Chơ puo arô toâp Môi-se cớp Arôn yỗn toâq ramóh loah án. Án pai neq: “Cứq táq lôih chóq Yiang Sursĩ, la Ncháu anhia, cớp chóq tỗp anhia hỡ. ");
INSERT INTO bru_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sanua nâi, sễq anhia táh lôih yỗn cứq muoi trỗ ễn. Cớp sễq anhia câu chuai yỗn cứq tễ Yiang Sursĩ, la Ncháu anhia, yỗn án ĩt loah ranáq cuchĩt nâi yỗn vớt tễ cứq.” ");
INSERT INTO bru_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ngkíq Môi-se loŏh tễ puo, pỡq câu sễq tễ Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Chơ Yiang Sursĩ lêq cuyal tễ angia mandang loŏh, yỗn cỡt cuyal tễ angia mandang pât ễn toâq. Cuyal rapuq dững nheq máh lam chu dỡq mưt Cusâu. Chơ tỡ bữn khlâiq muoi lám noâng lam tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ma Yiang Sursĩ táq yỗn puo bữn mứt coang sĩa, tỡ acláh máh tỗp I-sarel yỗn loŏh tễ cruang ki. ");
INSERT INTO bru_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Vớt ki, Yiang Sursĩ atỡng loah Môi-se neq: “Cóq mới sacỡ atĩ achỗn chu paloŏng, táq yỗn cruang nâi cỡt canám pếc nheq.” ");
INSERT INTO bru_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Môi-se sacỡ atĩ chu paloŏng, chơ tâng cruang Ê-yip-tô cỡt canám pếc, nheq pái tangái. ");
INSERT INTO bru_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tâng clống pái tangái ki, máh cũai Ê-yip-tô manoaq tỡ bữn hữm manoaq, cớp tỡ bữn noau loŏh tễ dống. Ma bân ntốq cũai I-sarel ỡt, ki poang patoat tiaq. ");
INSERT INTO bru_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ngkíq puo arô loah Môi-se cớp atỡng neq: “Têq tỗp anhia pỡq sang Yiang Sursĩ, dững dếh mansễm cớp carnễn. Ma máh charán anhia, ki cóq anhia dŏq nâi.” ");
INSERT INTO bru_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ma Môi-se ta‑ỡi neq: “Tỡ cỡn ngkíq! Cóq anhia yỗn hếq dững charán hếq bữm dŏq chiau sang cớp bốh sang yỗn Yiang Sursĩ, la Ncháu hếq. ");
INSERT INTO bru_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tỗp hếq cóq dững máh charán pỡq tê; tỡ têq muoi lám charán ntrớu noâng ỡt loah. Tỗp hếq cóq rưoh máh charán ễ chiau sang yỗn Yiang Sursĩ, la Ncháu hếq. Cớp toau hếq toâq pỡ ntốq ki, la hếq tỡ dáng rưoh charán lám léq ễ ĩt chiau sang yỗn Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma Yiang Sursĩ táq yỗn puo bữn mứt coang sĩa. Án tỡ bữn yỗn tỗp I-sarel pỡq. ");
INSERT INTO bru_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Puo pai chóq Môi-se neq: “Cóq mới dễq chíq tễ nâi! Chỗi yỗn cứq hữm noâng roâp mới! Khân cứq noâng hữm roâp mới, ki mới cuchĩt toâp!” ");
INSERT INTO bru_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Môi-se ta‑ỡi neq: “Chơ! Pĩeiq ơiq, anhia tỡ bữn hữm noâng cứq.” ");
INSERT INTO bru_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cứq ễ yỗn muoi ŏ́c túh coat ễn toâq pỡ puo cớp cũai proai Ê-yip-tô. Vớt ki nŏ́q puo acláh yỗn tỗp anhia pỡq. Ma hỡn tễ ki ễn, án tuih anhia dũ náq yỗn loŏh nheq tễ cruang nâi. ");
INSERT INTO bru_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sanua cóq mới atỡng máh cũai proai cứq, dếh samiang dếh mansễm, yỗn alới sễq crơng táq toâq práq cớp yễng tễ dống sũ yớu ỡt cheq cớp alới.” ");
INSERT INTO bru_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yiang Sursĩ táq yỗn cũai Ê-yip-tô sâng bũi pahỡm chóq cũai I-sarel. Cớp máh cũai sốt cớp cũai proai yám noap lứq Môi-se tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Chơ Môi-se atỡng puo neq: “Yiang Sursĩ pai neq: ‘Tâng sadâu nâi sám muoi mpứt, cứq ễ pỡq chũop nheq tâng cruang Ê-yip-tô, ");
INSERT INTO bru_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","chơ con clúng cũai Ê-yip-tô dũ dống cuchĩt nheq, dếh con samiang clúng puo, án ca ễ pláih loah puo chumát, toau toâq con clúng cũai sũl mansễm dốq táq bỗt racáu hỡ. Cớp dũ lám charán dống pốh dâu la cuchĩt nheq. ");
INSERT INTO bru_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Sưong noau nhiam ra‑ỗq ramễq chũop dũ ntốq tâng cruang Ê-yip-tô. Yuaq ranáq nâi tỡ nai bữn tễ nhũang tỡ la chumát. ");
INSERT INTO bru_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ma tâng vil cũai I-sarel ỡt tỡ bữn sâng dếh sưong acho crooh cũai tỡ la charán. Chơ mới têq dáng cứq la Yiang Sursĩ cớp táq mpha chóq tỗp Ê-yip-tô cớp tỗp I-sarel.’” ");
INSERT INTO bru_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Parsốt lứq Môi-se pai neq: “Máh cũai ayững atĩ anhia ễ toâq ap cucốh rasễq rasuong níc tễ cứq, ễq cứq dững máh cũai proai cứq loŏh tễ cruang nâi. Vớt ki, cứq pỡq.” Chơ Môi-se loŏh tễ puo; mứt án sâng cutâu lứq. ");
INSERT INTO bru_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yiang Sursĩ atỡng Môi-se neq: “Puo noâng tỡ ễq tamứng mới dŏq yỗn cứq táq ranáq salễh tữm ễn tâng cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Môi-se cớp Arôn táq nheq ranáq salễh nâi yáng moat puo. Ma Yiang Sursĩ táq yỗn mứt puo cỡt coang, tỡ yỗn cũai proai I-sarel loŏh pỡq tễ cruang án. ");
INSERT INTO bru_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yiang Sursĩ atỡng Môi-se cớp Arôn tâng cruang Ê-yip-tô neq: ");
INSERT INTO bru_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Cóq anhia noap casâi nâi la casâi muoi tâng plỡ cumo. ");
INSERT INTO bru_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Cóq anhia atỡng nheq tữh cũai I-sarel dáng neq: Tâng tangái muoi chít, casâi nâi, yỗn cũai samiang dũ dống sũ rưoh ĩt muoi lám cữu con tỡ la muoi lám mbễq con dŏq yỗn dống sũ án bữm. ");
INSERT INTO bru_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Khân dống sũ aléq bữn bĩq náq cũai cha muoi lám charán tỡ nheq, cóq alới chống cớp yớu ỡt cheq. Cớp tampễq táq pún yỗn dũ náq, maléq rơi án cha. ");
INSERT INTO bru_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Cóq anhia rưoh cữu tỡ la mbễq tangcáh mbỡiq muoi cumo, bán rêng cớp ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Tabữ muoi chít la pỗn casâi ki, cóq tỗp I-sarel dũ náq kiac charán alới bữm. ");
INSERT INTO bru_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Cóq máh cũai I-sarel ĩt aham charán ki, chơ poaih aham tâng santŏ́ng cớp sarpoiq cunâi ngoah toong mut loŏh bân ntốq noau cha charán. Cóq alới apoaih coah avêr, coah atoam, cớp tâng pỡng hỡ. ");
INSERT INTO bru_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Sadâu ki yỗn alới cha sâiq áng, bễng mi tỡ bữn pluoih cớp bát ntáng hỡ. ");
INSERT INTO bru_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Anhia chỗi cha sâiq cláu tỡ la sâiq kho; cóq anhia cha ống sâiq áng sâng, dếh plỡ, nlu, cớp crơng clống hỡ. ");
INSERT INTO bru_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Anhia chỗi yỗn sana clữi toau toâq tarưp parnỡ. Khân clữi, cóq anhia bốh táh yỗn cat nheq. ");
INSERT INTO bru_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Cóq anhia cha chái, yuaq anhia cóq thrũan pỡq. Catoân parnoân tâng ngkĩng, sớp au, chóq cỡp tâng ayững, cớp yống ralỡng. Nâi la rit anhia sanhữ Tangái Loŏh, la tangái Yiang Sursĩ chuai yỗn anhia loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Tâng sadâu ki cứq pỡq chũop nheq tâng cruang Ê-yip-tô cớp cachĩt nheq máh con samiang clúng, dếh máh charán tôl pốh dâu. Cớp cứq rasữq dũ ramứh yiang tâng cruang Ê-yip-tô. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Aham tâng santŏ́ng cớp sarpoiq cunâi ngoah toong cỡt tếc yỗn dáng dống anhia ỡt. Toâq cứq pỡq pha ma hữm aham, ki cứq payang tỡ bữn táq anhia bo cứq táq cũai Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Tangái nâi la tangái anoat dŏq cỡt rit sanhữ yỗn dũ dỡi. Cóq anhia cha pêl bũi sanhữ loah tễ ranáq Yiang Sursĩ khoiq chuai anhia.” ");
INSERT INTO bru_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yiang Sursĩ atỡng Môi-se ễn neq: “Tâng tapul tangái cóq anhia cha bễng mi ŏ́q crơng pluoih. Tâng tangái muoi cóq anhia ĩt aloŏh nheq máh crơng pluoih tễ dống anhia. Khân cũai aléq cha bễng mi bữn crơng pluoih tâng tapul tangái ki, chơ cũai ki tỡ têq cỡt noâng cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tâng tangái muoi cớp tangái tapul dũ náq anhia cóq rôm sang cứq. Têq anhia táq cha, ma chỗi táq ranáq canŏ́h tâng bar tangái ki. ");
INSERT INTO bru_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Rit Tangái Cha Bễng Mi Ŏ́q Crơng Pluoih cóq tỗp anhia sanhữ níc, yuaq tâng tangái nâi toâp cứq dững tỗp anhia loŏh tễ cruang Ê-yip-tô. Tangái nâi la tangái cha bũi anoat dŏq cỡt rit yỗn dũ dỡi. ");
INSERT INTO bru_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Tabữ tangái muoi chít la pỗn toau toâq tabữ tangái bar chít la muoi casâi muoi, anhia chỗi cha bễng mi bữn crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Tâng tapul tangái ki anhia chỗi dŏq crơng pluoih tâng dống anhia. Khân aléq ma cha bễng mi bữn crơng pluoih, tam cũai tễ cruang canŏ́h tỡ la cũai I-sarel, cũai ki tỡ têq cỡt noâng cũai proai cứq.” ");
INSERT INTO bru_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Chơ Môi-se arô máh sốt tỗp I-sarel toâq ramóh án, cớp atỡng neq: “Dũ náq anhia cóq rưoh muoi lám cữu con tỡ la mbễq con, chơ kiac charán ki yỗn cũai tâng dống sũ anhia cha sanhữ Tangái Loŏh. ");
INSERT INTO bru_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Cóq anhia ĩt muoi boq bát hi‑sớp, alốq tâng cuban aham charán. Chơ anhia apoaih aham ki tâng santŏ́ng cớp sarpoiq cunâi ngoah toong, yáng pỡng cớp bar coah. Cớp tỡ têq cũai aléq loŏh tễ dống toau toâq tarưp. ");
INSERT INTO bru_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Toâq Yiang Sursĩ pỡq chũop nheq cruang Ê-yip-tô ễ cachĩt máh con clúng cũai Ê-yip-tô, toâq án hữm aham tỗp anhia apoaih tâng santŏ́ng cớp sarpoiq cunâi ngoah toong, chơ án tỡ yỗn ranễng ca dững ŏ́c cuchĩt mut cachĩt tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nheq tữh anhia cớp con châu anhia cóq yống níc ŏ́c cứq patâp nâi toau dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Toâq tỗp anhia mut tâng cruang Yiang Sursĩ khoiq par‑ữq yỗn anhia, ki cóq anhia táq puai máh rit cứq khoiq patâp nâi. ");
INSERT INTO bru_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Toâq con châu anhia blớh anhia neq: ‘Cỗ nŏ́q táq rit nâi?’, ");
INSERT INTO bru_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","cóq anhia ta‑ỡi neq: ‘Nâi la rit Tangái Loŏh dŏq hái cha sanhữ sa‑ỡn Yiang Sursĩ, yuaq án tỡ bữn cachĩt máh cũai I-sarel ỡt tâng cruang Ê-yip-tô bo án cachĩt máh cũai Ê-yip-tô.’” Chơ máh cũai proai I-sarel sacốh racớl sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Moâm ki, alới táq puai dũ ramứh máh Yiang Sursĩ ớn na Môi-se cớp Arôn. ");
INSERT INTO bru_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Muoi mpứt tâng sadâu ki, Yiang Sursĩ cachĩt nheq máh con samiang clúng cũai Ê-yip-tô, noap tễ con samiang puo ca ễ pláih loah án, toau toâq máh con cũai proai, dếh cũai tũ noau crál tâng cuaq pưn cutễq. Cớp án cachĩt dếh con charán pốh dâu hỡ. ");
INSERT INTO bru_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tâng sadâu ki, puo cớp ayững atĩ án, dếh máh cũai proai Ê-yip-tô, nheq náq alới satŏh tamỡ. Chơ bữn sưong nhiam u‑ỗi chũop cruang Ê-yip-tô, yuaq dũ dống sũ bữn cũai cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tâng sadâu ki toâp puo arô Môi-se cớp Arôn, cớp án atỡng alới neq: “Anhia loŏh toâp! Dững nheq máh tỗp proai I-sarel loŏh chíq tễ cruang cứq. Chơ anhia pỡq sang Yiang Sursĩ ĩn anhia khoiq sễq. ");
INSERT INTO bru_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Anhia dững nheq máh cữu, mbễq, ntroŏq anhia, chơ pỡq! Cớp sễq anhia câu ŏ́c bốn yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Cũai Ê-yip-tô ớn cũai I-sarel loŏh chái tễ cruang alới, pai neq: “Khân tỗp anhia tỡ bữn loŏh, ki tỗp hếq cuchĩt nheq!” ");
INSERT INTO bru_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ngkíq cũai I-sarel thrũan bễng mi noâng cláu chóq tâng tapuang cunhoau bỗt mi, ma tỡ yũah chóq crơng pluoih. Chơ alới cayớm tâng tampâc, cớp dỗl pỡq. ");
INSERT INTO bru_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Cũai I-sarel sễq tễ cũai Ê-yip-tô máh crơng táq toâq práq, toâq yễng, cớp tampâc, ĩn Môi-se khoiq atỡng alới. ");
INSERT INTO bru_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yiang Sursĩ táq yỗn cũai Ê-yip-tô sâng bũi pahỡm chóq cũai I-sarel, chơ yỗn máh crơng alới sễq. Ngkíq cũai I-sarel parỗm ĩt nheq sanốc ntữn cũai Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Cũai I-sarel tayáh ayững tễ vil Ram-sê toâq pỡ vil Sucôt. Cũai samiang bữn sám tapoât culám ngin náq, tỡ bữn noap mansễm cớp carnễn. ");
INSERT INTO bru_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Bữn clứng cũai tỡ cỡn cũai I-sarel pỡq nứng alới, cớp bữn dếh cữu, mbễq, cớp ntroŏq hỡ. ");
INSERT INTO bru_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tỗp alới ĩt bễng mi noâng cláu ca dững tễ cruang Ê-yip-tô, chơ áng. Ma bễng mi ki ŏ́q crơng pluoih, yuaq tỡ loâp chóq crơng pluoih nhũang noau tuih yỗn alới loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Cũai I-sarel ỡt tâng cruang Ê-yip-tô dũn pỗn culám pái chít cumo. ");
INSERT INTO bru_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Toâq chuop pỗn culám pái chít cumo, tâng tangái ki toâp máh tỗp proai Yiang Sursĩ loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Yuaq tâng sadâu ki Yiang Sursĩ trỗl dŏq chuai yỗn cũai I-sarel loŏh tễ cruang Ê-yip-tô, ngkíq cũai I-sarel cóq noap sadâu ki la sadâu trỗl dŏq yám noap Yiang Sursĩ toau dũ dỡi. ");
INSERT INTO bru_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yiang Sursĩ atỡng Môi-se cớp Arôn neq: “Nâi la phễp rit sanhữ Tangái Loŏh. Chỗi yỗn cũai cruang canŏ́h cha parnơi tâng tangái anhia táq rit ki. ");
INSERT INTO bru_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ma máh cũai sũl anhia chỡng, khân án khoiq táq rit cứt, têq án cha pêl ki. ");
INSERT INTO bru_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Chỗi yỗn cũai ỡt dỡ, tỡ la cũai tuthễ cha pêl ki. ");
INSERT INTO bru_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Máh sana anhia thrũan, cóq anhia cha tâng dống toâp. Chỗi aloŏh sana ki tễ dống. Chỗi déh nghang charán anhia táq cha pêl ki. ");
INSERT INTO bru_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Dũ náq cũai I-sarel cóq cha pêl bũi nâi. ");
INSERT INTO bru_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Chỗi yỗn cũai tỡ yũah táq rit cứt cha parnơi pêl ki. Khân bữn cũai tễ cruang canŏ́h ỡt parnơi cớp anhia, ma ễ táq tê phễp rit yám noap Yiang Sursĩ, cóq dũ náq samiang ỡt tâng dống án táq rit cứt nhũang voai. Chơ têq án mut cha pêl ki parnơi cớp cũai canỡt tễ cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Nâi la phễp rit yỗn dũ náq cũai I-sarel, cớp dũ náq cũai tễ cruang canŏ́h ca ỡt cớp anhia.” ");
INSERT INTO bru_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Nheq tữh cũai proai I-sarel trĩh cớp táq puai máh santoiq Yiang Sursĩ khoiq ớn na Môi-se cớp Arôn. ");
INSERT INTO bru_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Tâng tangái ki toâp Yiang Sursĩ dững dũ náq cũai I-sarel loŏh tễ cruang Ê-yip-tô puai tâng tỗp alới bữm. ");
INSERT INTO bru_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Cóq tỗp I-sarel chiau sang con samiang clúng alới dũ náq yỗn cứq, cớp dũ lám charán tôl pốh dâu, yuaq án cỡt khong cứq.” ");
INSERT INTO bru_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Chơ Môi-se atỡng cũai proai neq: “Cóq anhia sanhữ tangái nâi la tangái anhia loŏh tễ cruang Ê-yip-tô, tễ ntốq anhia cỡt sũl. Tangái nâi la tangái Yiang Sursĩ chuai tỗp anhia loŏh nhơ chớc toâr lứq tễ án. Ngkíq anhia tỡ têq cha bễng mi bữn crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tâng tangái nâi, la casâi Abip, anhia ntôm loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yiang Sursĩ par‑ữq samoât samơi lứq cớp achúc achiac tỗp anhia, la án ễ chiau yỗn tỗp anhia máh cruang neq: Cana-an, Hêt, Amô-rit, Hê-vit, cớp Yê-but. Toâq Yiang Sursĩ dững tỗp anhia mut tâng cruang bữn cutễq phuor o, tâng dũ cumo tâng casâi nâi cóq anhia táq rit sanhữ tangái nâi. ");
INSERT INTO bru_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Nheq tapul tangái cóq anhia cha bễng mi tỡ bữn bữn crơng pluoih. Cớp tâng tangái tapul cóq anhia táq pêl bũi dŏq yám noap Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tâng tapul tangái ki anhia chỗi cha bễng mi bữn crơng pluoih. Cớp chỗi dŏq crơng táq yỗn bễng cỡt pluoih tâng cruang anhia. ");
INSERT INTO bru_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tâng máh tangái ki, cóq anhia atỡng máh con samiang anhia dáng cỗ nŏ́q anhia táq rit ki, yỗn alới dáng Yiang Sursĩ chuai tỗp anhia loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Rit nâi cỡt tếc dŏq catoaih anhia toâq anhia chŏ́q dŏq tâng ngcŏ́ng, tỡ la chŏ́q tâng caliac. Tếc ki anhoac yỗn anhia ruaih níc phễp rit tễ Yiang Sursĩ, yuaq Yiang Sursĩ toâp dững anhia loŏh tễ cruang Ê-yip-tô cỗ nhơ tễ chớc toâr lứq. ");
INSERT INTO bru_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Cóq anhia táq rit sanhữ nâi tâng dũ cumo toâq pĩeiq loah casâi ki.” ");
INSERT INTO bru_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Chơ Môi-se pai ễn neq: “Lứq samoât, nỡ‑ra Yiang Sursĩ dững tỗp anhia mut chu cruang Cana-an, la ntốq án khoiq par‑ữq ễ chiau yỗn achúc achiac anhia cớp anhia hỡ. ");
INSERT INTO bru_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Toâq anhia mut, cóq anhia chiau sang con samiang clúng yỗn Yiang Sursĩ, dếh charán tôl pốh dâu, yuaq con clúng ki cỡt khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ma máh aséh dễn tôl pốh dâu, cóq anhia ĩt cữu tôl pláih aséh dễn. Khân anhia tỡ ễq pláih, cóq anhia dóh chíq tacong aséh dễn ki. Ma con samiang clúng tâng tỗp anhia, cóq anhia thái loah dũ náq. ");
INSERT INTO bru_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tễ nâi chumát, toâq con samiang tỗp anhia blớh tễ ranáq nâi, anhia atỡng loah neq: ‘Hái táq ngkíq la cỗ nhơ Yiang Sursĩ khoiq chuai tỗp hái loŏh vớt tễ cỡt sũl tâng cruang Ê-yip-tô na chớc toâr lứq tễ án. ");
INSERT INTO bru_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Puo bữn mứt pahỡm coang, cớp án tỡ ễq acláh tỗp hái pỡq. Chơ Yiang Sursĩ cachĩt chíq con samiang clúng cũai Ê-yip-tô dũ náq, dếh charán tôl pốh dâu. Yuaq ngkíq tỗp hái cóq chiau sang charán tôl pốh dâu yỗn Yiang Sursĩ. Ma máh con samiang clúng, ki cóq hái thái loah. ");
INSERT INTO bru_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ngkíq nâi cỡt tếc dŏq catoaih tỗp hái, bo hái chŏ́q dŏq tâng ngcŏ́ng, tỡ la chŏ́q dŏq tâng caliac. Tếc nâi yỗn hái sanhữ loah Yiang Sursĩ dững aloŏh tỗp hái tễ cruang Ê-yip-tô cỗ nhơ tễ chớc toâr lứq tễ án.’” ");
INSERT INTO bru_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Toâq puo yỗn tỗp I-sarel loŏh tễ cruang Ê-yip-tô, Yiang Sursĩ tỡ bữn ayông alới pỡq yáng cruang Phi-li-tin, tam rana ki cheq hỡn. Ma Yiang Sursĩ chanchớm neq: “Cứq tỡ ễq tỗp proai cứq lêq loah mứt pahỡm toâq alới dáng cóq rachíl, chơ píh chu loah pỡ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ngkíq Yiang Sursĩ ayông alới pỡq viel tâng ntốq aiq toau choâng bân dỡq mưt Cusâu. Cũai I-sarel thrũan dŏq dũ ramứh crơng choac bo alới loŏh tễ cruang Ê-yip-tô khễ toâq ễ rachíl. ");
INSERT INTO bru_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Môi-se dững dếh nghang Yô-sep, yuaq Yô-sep khoiq yỗn tỗp I-sarel thễ dũan cóq dững nghang án. Bo ki Yô-sep atỡng alới neq: “Toâq Yiang Sursĩ chuai anhia bữn loŏh, cóq anhia dững aloŏh dếh nghang cứq hỡ.” ");
INSERT INTO bru_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tữ cũai proai I-sarel loŏh tễ vil Sucôt, chơ alới ỡt dỡ tâng E-tham, kễng ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Tâng tangái, Yiang Sursĩ pỡq nhũang tỗp alới na ramứl cỡt ariang sapom, dŏq sadoi rana yỗn alới pỡq. Cớp tâng sadâu án pỡq nhũang alới na pla ũih cỡt ariang sapom tê, dŏq yỗn cỡt poang tâng rana alới ễ pỡq. Ngkíq, têq alới pỡq dếh tangái dếh sadâu. ");
INSERT INTO bru_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Dũ tangái sadâu sapom ramứl cớp sapom pla ũih ki pỡq nhũang níc tỗp alới. ");
INSERT INTO bru_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Chơ Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Cóq mới atỡng máh cũai I-sarel yỗn alới píh loah ỡt dỡ choâng vil Pi Hahi-rot. Vil ki ỡt mpứng dĩ bar coah vil Mic-dôl cớp dỡq mưt Cusâu, ma cheq cớp vil Ba-al Sê-phon. ");
INSERT INTO bru_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Chơ puo chanchớm pai tỗp I-sarel ntôm láp pỡq láp chu tâng cruang ki, yuaq bữn ntốq aiq catáng. ");
INSERT INTO bru_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Cứq ễ táq yỗn puo cỡt mứt coang cớp rapuai tỗp alới. Chơ máh cũai ễ yám noap cứq, toâq alới hữm cứq chíl riap puo cớp tỗp tahan án. Ngkíq cũai Ê-yip-tô têq dáng cứq la Yiang Sursĩ.” Chơ máh cũai I-sarel táq puai máh santoiq patâp ki. ");
INSERT INTO bru_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Toâq puo dáng máh cũai proai I-sarel khoiq loŏh vớt chơ, ki án cớp máh ayững atĩ án, alới lêq mứt pahỡm cớp pai neq: “Cỗ nŏ́q hái ma táq ngkíq? Hái khoiq yỗn tỗp I-sarel loŏh, chơ hái ŏ́q cũai sũl noâng!” ");
INSERT INTO bru_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ngkíq puo thrũan sễ aséh rachíl khong án bữm cớp ớn tahan án thrũan pỡq rapuai. ");
INSERT INTO bru_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Chơ puo dững nheq máh sễ aséh rachíl tâng cruang Ê-yip-tô dếh tapoât culám sễ aséh rachíl khâm lứq hỡ. Cớp dũ lám sễ bữn sốt tahan taniap. ");
INSERT INTO bru_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yiang Sursĩ táq yỗn mứt pahỡm puo cỡt coang sĩa. Chơ án rapuai tỗp I-sarel ca ntôm pỡq lahỡi-latoŏh yuaq alới chanchớm khoiq vớt chơ. ");
INSERT INTO bru_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Cambláng tahan Ê-yip-tô, dếh aséh, sễ aséh rachíl, cớp cũai dững sễ ki, alới rapuai tỗp I-sarel. Chơ alới satỡm pỡ ntốq tỗp I-sarel ỡt dỡ choâng vil Pi Hahi-rot cheq cớp vil Ba-al Sê-phon. ");
INSERT INTO bru_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Toâq máh cũai I-sarel hữm puo cớp poâl tahan án rapuai cheq ễ satỡm, ngkíq alới pứt mứt cỗ sâng ngcŏh lứq. Chơ, alới arô sễq Yiang Sursĩ chuai. ");
INSERT INTO bru_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Tỗp alới pai chóq Môi-se neq: “Nŏ́q tâng cruang Ê-yip-tô ŏ́q ntốq noau tứp cumuiq tỡ? Cỗ nŏ́q anhia dững tỗp hếq toâq cuchĩt pỡ ntốq aiq nâi? Anhia ntôm táq ranáq ntrớu ma dững hếq loŏh tễ cruang Ê-yip-tô? ");
INSERT INTO bru_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Lứq ma tỡ bữn, tỗp hếq khoiq atỡng anhia nhũang chơ neq: ‘Chỗi rabũl cớp tỗp hếq; dŏq yỗn hếq táq sũl cũai Ê-yip-tô ki o hỡn’? Cỡt sũl cũai Ê-yip-tô o hỡn saláng yỗn hếq cuchĩt tâng ntốq aiq nâi!” ");
INSERT INTO bru_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Môi-se ta‑ỡi neq: “Chỗi ngcŏh ntrớu! Cóq anhia bữn mứt pahỡm sabớng o; chơ anhia bữn hữm Yiang Sursĩ chuai anhia tâng tangái nâi toâp! Lứq samoât, anhia tỡ bữn hữm noâng cũai Ê-yip-tô nâi. ");
INSERT INTO bru_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yiang Sursĩ ễ chíl chuai tỗp anhia, cớp tỗp anhia tỡ bữn túh cóq chíl bữm.” ");
INSERT INTO bru_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yiang Sursĩ blớh Môi-se neq: “Cỗ nŏ́q anhia arô yỗn cứq rachuai? Cóq mới ớn cũai proai tíng pỡq. ");
INSERT INTO bru_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Cóq mới yống ralỡng, chơ payo chu dỡq mưt, yỗn dỡq ki cỡt caryoah dŏq máh cũai I-sarel têq pỡq tâng huong ki ariang tayáh tâng cutễq sa‑ỡt dŏq yang dỡq mưt ki. ");
INSERT INTO bru_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Cứq ễ táq yỗn tỗp Ê-yip-tô cỡt mứt pahỡm coang, chơ rapuai tỗp I-sarel. Chơ, máh cũai ễ yám noap cứq, toâq alới hữm cứq chíl riap puo, cambláng tahan án, sễ aséh án, cớp cũai dững sễ ki hỡ. ");
INSERT INTO bru_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Toâq cứq riap máh tỗp alới, chơ máh cũai Ê-yip-tô têq dáng cứq la lứq Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Bo ki ranễng Yiang Sursĩ ca dốq pỡq nhũang tahan tỗp I-sarel, án carlĩu ỡt yáng clĩ ễn, cớp sapom ramứl ca dốq ỡt yáng moat, sanua án atỡi ỡt yáng clĩ ễn. ");
INSERT INTO bru_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Chơ án dớng bân mpứng dĩ bar coah cũai Ê-yip-tô cớp cũai I-sarel ỡt. Ramứl ki catáng coah tỗp Ê-yip-tô yỗn cỡt canám, ma coah tỗp I-sarel cỡt poang. Yuaq ngkíq, nheq sadâu ki alới bar tỗp tỡ bữn ramóh. ");
INSERT INTO bru_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Môi-se aloŏh atĩ chu dỡq mưt; chơ Yiang Sursĩ táq yỗn cuyal rêng lứq toâq tễ angia mandang loŏh. Cuyal ki phát pông brang, táq yỗn cutễq cỡt khỗ. Ngkíq dỡq ki caryoah; ");
INSERT INTO bru_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","chơ tỗp I-sarel têq tayáh pỡq tâng cutễq khỗ, yuaq dỡq caryoah cỡt bar coah ariang paning. ");
INSERT INTO bru_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Máh cũai Ê-yip-tô rapuai cũai I-sarel mut tâng dỡq mưt, dếh máh aséh, sễ aséh rachíl, cớp cũai dững sễ ki. ");
INSERT INTO bru_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Toâq cheq ễ poang, Yiang Sursĩ tapoang asễng tễ sapom ramứl cớp ũih chu máh tahan Ê-yip-tô. Chơ Yiang Sursĩ táq yỗn cambláng tahan Ê-yip-tô dớt sarnớm tỡ dáng nŏ́q ễ táq. ");
INSERT INTO bru_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Cớp án táq yỗn ayững sễ aséh rachíl cál chíq tâng cutễq; chơ sễ pỡq cro lứq. Ngkíq tahan Ê-yip-tô pai neq: “Pĩeiq lứq, Yiang Sursĩ ỡt coah tỗp I-sarel chíl tỗp hái. Hâi dáih! Hái loŏh toâp tễ nâi!” ");
INSERT INTO bru_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới aloŏh atĩ chu dỡq mưt yỗn dỡq calứp chíq cũai Ê-yip-tô, dếh máh sễ aséh rachíl cớp cũai dững sễ ki hỡ.” ");
INSERT INTO bru_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ngkíq Môi-se aloŏh atĩ án chu dỡq mưt. Ma paloŏng mbỡiq rưm-rưm, chơ dỡq ki lalín patoat tiaq loah. Chơ tỗp tahan Ê-yip-tô lúh ễq yỗn vớt, ma Yiang Sursĩ táq yỗn tỗp alới cuchĩt tróh nheq tâng dỡq. ");
INSERT INTO bru_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Dỡq ki hoi loah chu clĩ; chơ án calứp máh sễ aséh rachíl, dếh cũai dững sễ ki, dếh nheq tahan puo ca khoiq puai tỗp I-sarel mut tâng dỡq mưt. Tỡ va manoaq noâng bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ma cũai I-sarel tayáh pỡq tâng cutễq khỗ, yuaq dỡq ki cỡt ariang paning ỡt bar coah. ");
INSERT INTO bru_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tâng tangái ki toâp Yiang Sursĩ chuai máh cũai I-sarel yỗn vớt tễ talang atĩ tỗp tahan Ê-yip-tô. Máh cũai I-sarel hữm cũai Ê-yip-tô cuchĩt radốc racơng tháng pễr tor dỡq mưt. ");
INSERT INTO bru_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Toâq máh cũai I-sarel hữm chớc salễh tễ Yiang Sursĩ chíl chuai yỗn alới riap máh tahan Ê-yip-tô, ki nŏ́q alới ngcŏh cớp yám Yiang Sursĩ. Alới sa‑âm samoât lứq Yiang Sursĩ, cớp alới noap lứq Môi-se, la cũai táq ranáq Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Chơ Môi-se cớp máh cũai I-sarel ũat cansái khễn Yiang Sursĩ neq: “Cứq ễ khễn Yiang Sursĩ, yuaq án khoiq riap chơ tahan cớp aséh tỗp Ê-yip-tô. Án khoiq sarpứt asễng aséh cớp cũai ỡt tâng cloong aséh chu dỡq mưt. ");
INSERT INTO bru_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yiang Sursĩ táq yỗn cứq bán rêng cớp yỗn cứq bữn cansái ũat. Án chuai amoong cứq. Án la Yiang cứq; ngkíq cứq khễn án. Cớp án la Yiang mpoaq cứq; ngkíq cứq khễn án ca bữn chớc toâr lứq. ");
INSERT INTO bru_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ramứh án la Yiang Sursĩ; án la samoât tahan clŏ́q lứq. ");
INSERT INTO bru_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Án sarpứt asễng máh sễ aséh rachíl cớp tahan puo tâng dỡq mưt; cớp máh cũai sốt tahan ca clŏ́q lứq, án yỗn clooc nheq tâng dỡq mưt Cusâu ");
INSERT INTO bru_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Dỡq mưt yarũ lứq clũom chíq tỗp alới; alới dớp riang tamáu asễng chu pưn dỡq. ");
INSERT INTO bru_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Yiang Sursĩ ơi! Atĩ atoam anhia bữn chớc toâr lứq; têq anhia pupứt nheq máh cũai par‑ũal yỗn cỡt abuoiq. ");
INSERT INTO bru_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Anhia khoiq bữn roap ŏ́c yám noap, la cỗ anhia chíl riap cớp pupứt cũai par‑ũal. Anhia chŏ́ng táh chíq tỗp alới machớng noau chŏ́ng soc tê. ");
INSERT INTO bru_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Anhia khoiq phát dỡq mưt táq yỗn án canoâq achỗn; dỡq ki cỡt ariang paning sarỡih. Tâng mpứng dĩ dỡq yarũ cỡt samoât dỡq clưn.” ");
INSERT INTO bru_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Cũai par‑ũal pai neq: ‘Cứq ễ rapuai satỡm alới; cứq thot dau, chơ tráh táh alới. Chơ cứq tampễq crơng sanốc alới, cớp ĩt nheq dũ ramứh cứq ễ bữn.’ ");
INSERT INTO bru_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Yiang Sursĩ cuhũh ống muoi taláp sâng táq yỗn máh tahan Ê-yip-tô dớp asễng nheq tâng dỡq, cỡt samoât trac dớp tâng dỡq canoâq lampóh. ");
INSERT INTO bru_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Bữn yiang aléq ma machớng Yiang Sursĩ? Bữn noau ariang anhia? Anhia bữn chớc toâr clữi nheq tễ canŏ́h. Noau têq táq ranáq salễh machớng anhia táq? ");
INSERT INTO bru_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Toâq anhia aloŏh atĩ atoam chu cutễq, chơ cutễq caha lưn nheq máh cũai par‑ũal hếq. ");
INSERT INTO bru_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Cỗ anhia ayooq mantái níc, ngkíq anhia chuai amoong tỗp proai anhia. Nhơ tễ chớc anhia, anhia ayông alới toâq pỡ ntốq miar khong anhia. ");
INSERT INTO bru_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Toâq dũ cruang bữn sâng, chơ alới cỡt ngcŏh lứq. Cớp cũai Phi-li-tin cangcoaih yứr-yứr tháng. ");
INSERT INTO bru_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Lứq samoât, máh cũai sốt tỗp Ê-dôm, alới sâng ngcŏh lứq. Cũai Mô-ap pla lứq, alới cỡt pứt mứt. Cớp cũai tâng cruang Cana-an, la pứt mứt tê. ");
INSERT INTO bru_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ơ Yiang Sursĩ ơi! Nheq tữh tỗp alới khoiq pứt mứt cỗ sâng ngcŏh lứq. Cỗ nhơ chớc toâr lứq tễ anhia, ngkíq alới ỡt rangiac cỗ sâng ngcŏh lứq, toau máh cũai proai anhia tayáh pha bữn vớt, la máh cũai anhia khoiq yỗn bữn racláh tễ cỡt sũl. ");
INSERT INTO bru_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Anhia dững tỗp alới mut, chơ yỗn alới ayứng ntốq ỡt tâng cóh anhia. Ntốq ki la ntốq anhia khoiq rưoh yỗn alới, la dống sang anhia toâp táq. ");
INSERT INTO bru_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Anhia toâp cỡt Puo sốt mantái mantái.” ");
INSERT INTO bru_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Bo máh tahan aséh, dếh cũai dững aséh rachíl khong puo rapuai asễng chu dỡq mưt, Yiang Sursĩ táq yỗn dỡq mưt cỡt blíng loah dŏq calứp chíq tỗp alới. Ma cũai I-sarel tayáh pỡq tâng cutễq khỗ. ");
INSERT INTO bru_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Chơ ỡi Arôn, ramứh Mi-riam, la cũai tang bỗq Yiang Sursĩ, án yống sacơr cớt pỡq nhũang. Cớp máh mansễm ca puai án toân sacơr cớt dếh alới puan sarai. ");
INSERT INTO bru_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mi-riam ũat khễn neq: “Cóq hái khễn Yiang Sursĩ na cansái ũat khễn, yuaq án chíl khoiq riap chơ. Án takễl tỗp aséh, dếh tahan ỡt tâng cloong aséh, táq yỗn alới cuchĩt tróh nheq tâng dỡq mưt.” ");
INSERT INTO bru_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Chơ Môi-se dững máh tỗp I-sarel loŏh tễ dỡq mưt Cusâu pỡq chu ntốq aiq Surơ. Tỗp alới tayáh pỡq khoiq pái tangái chơ tâng ntốq aiq, ma tỡ bữn ramóh dỡq. ");
INSERT INTO bru_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Vớt ki, tỗp alới toâq pỡ ntốq ramứh Marah, ma dỡq tâng ntốq ki cỡt ntáng lứq, tỡ têq nguaiq. Ngkíq yuaq alới dŏq ntốq ki Marah. (Santoiq ‘marah’ nâi parlong loah la ‘ntáng’.) ");
INSERT INTO bru_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Chơ máh cũai I-sarel bubéq-bubưp chóq Môi-se cớp blớh neq: “Sanua, ntrớu hếq ễ nguaiq?” ");
INSERT INTO bru_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Chơ Môi-se câu sễq nheq rangứh rahỡ chu Yiang Sursĩ. Cớp Yiang Sursĩ apáh yỗn Môi-se hữm muoi béq aluang; chơ án tỗiq ĩt béq aluang ki. Án voang asễng chu dỡq; ngkíq dỡq ki pứt ntáng, têq alới nguaiq loah. Tâng ntốq ki Yiang Sursĩ yỗn máh ŏ́c patâp dŏq alới táq puai. Ma tâng ntốq ki tê Yiang Sursĩ chim alới trĩh án ma tỡ bữn. ");
INSERT INTO bru_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yiang Sursĩ pai neq: “Khân anhia trĩh cớp táq puai máh santoiq cứq atỡng, ki cứq tỡ bữn táq yỗn anhia roap ŏ́c a‑ĩ tacóh, machớng cứq khoiq táq chóq cũai Ê-yip-tô. Ống cứq toâp la Yiang Sursĩ ca têq tahâu yỗn anhia cỡt bán.” ");
INSERT INTO bru_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Vớt ki alới pỡq toâq pỡ ntốq E-lim la ntốq bữn muoi chít la bar ntốq dỡq mec, cớp bữn tapul chít nỡm tarễc. Ngkíq máh cũai I-sarel ỡt dỡ cheq dỡq ki. ");
INSERT INTO bru_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Noap tễ tangái cũai I-sarel loŏh tễ cruang Ê-yip-tô toâq tangái muoi chít la sỡng, casâi bar, nheq tữh alới loŏh tễ ntốq E-lim. Chơ alới pỡq toâq pỡ ntốq aiq ramứh Sín, ỡt mpứng dĩ bar coah E-lim cớp cóh Si-nai. ");
INSERT INTO bru_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ỡt ntốq aiq ki, tỗp alới bubéq-bubưp chóq Môi-se cớp Arôn. ");
INSERT INTO bru_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Tỗp alới pai neq: “Khaq Yiang Sursĩ cachĩt chíq hếq nhũang bo hếq noâng ỡt tâng cruang Ê-yip-tô, la ntốq tỗp hếq bữn cha sâiq cớp sana canŏ́h pasâi lứq, saláng anhia dững tỗp hếq toâq pỡ ntốq aiq nâi, ma ễq tỗp hếq cuchĩt na panhieih khlac.” ");
INSERT INTO bru_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Chơ Yiang Sursĩ atỡng Môi-se neq: “Sanua cứq yỗn crơng sana sễng tễ paloŏng yỗn tỗp anhia bữn cha. Cóq cũai proai pỡq ĩt cu rangái, ma ĩt yỗn dũ cha tâng muoi tangái ki sâng. Táq ngkíq, cứq ễ chim salĩq tỗp anhia trĩh ma tỡ bữn santoiq cứq patâp. ");
INSERT INTO bru_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Tâng tangái tapoât cứq yỗn tỗp anhia ĩt sa‑ữi hỡn tễ máh tangái nhũang muoi pún.” ");
INSERT INTO bru_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Yuaq ngkíq, Môi-se cớp Arôn atỡng máh cũai I-sarel neq: “Tâng sadâu nâi dũ náq anhia bữn dáng samoât samơi la Yiang Sursĩ toâp chuai tỗp anhia loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Poang tarưp tỗp anhia lứq hữm chớc ang‑ữr tễ Yiang Sursĩ. Yiang Sursĩ khoiq sâng sưong tỗp anhia bubéq-bubưp chóq án. Cỗ nŏ́q anhia bubéq-bubưp chóq hếq bar náq? Hếq táq tapun án pai sâng.” ");
INSERT INTO bru_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Môi-se pai ễn neq: “Ống Yiang Sursĩ toâp yỗn tỗp anhia bữn sâiq cha tâng tabữ, cớp bữn sana tâng tarưp, yuaq án khoiq sâng tỗp anhia bubéq-bubưp chóq án. Toâq anhia bubéq-bubưp chóq hếq bar náq, nâi la machớng anhia bubéq-bubưp chóq Yiang Sursĩ toâp.” ");
INSERT INTO bru_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Chơ Môi-se atỡng Arôn neq: “Cóq mới atỡng máh cũai I-sarel yỗn alới toâq tayứng yáng moat Yiang Sursĩ, yuaq án khoiq sâng chơ máh santoiq alới bubéq-bubưp.” ");
INSERT INTO bru_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Bo Arôn ntôm atỡng máh cũai I-sarel, nheq alới nhêng chu ntốq aiq. Chơ alới santar sâng hữm chớc ang‑ữr tễ Yiang Sursĩ tâng ramứl. ");
INSERT INTO bru_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Cứq khoiq sâng chơ sưong máh cũai I-sarel bubéq-bubưp. Cóq mới atỡng alới dáng tabữ kếq tỗp alới bữn sâiq cha, cớp tarưp parnỡ tỗp alới bữn cha sana pasâi. Chơ alới bữn dáng cứq la Yiang Sursĩ, Ncháu alới.” ");
INSERT INTO bru_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Toâq cheq sadâu, bữn tỗp chớm ntrut srúh asễng poân nheq bân ntốq alới ỡt dỡ, cớp toâq tarưp ễn bữn dỡq latac satooh chũop ntốq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Toâq dỡq latac sa‑ỡt nheq chơ, bữn muoi ramứh cada-da cỡt mễng poân nheq tâng cutễq ntốq aiq ariang dỡq latac cỡt pễng. ");
INSERT INTO bru_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Toâq máh cũai I-sarel hữm acán ki, ma alới tỡ dáng acán ntrớu. Ngkíq manoaq blớh manoaq neq: “Acán ntrớu nâi?” Chơ Môi-se atỡng alới neq: “Acán nâi la sana Yiang Sursĩ yỗn tỗp anhia bữn cha. ");
INSERT INTO bru_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yiang Sursĩ khoiq ớn dũ náq anhia cóq parỗm ĩt yỗn dũ cha, muoi noaq bar ki-lô ma yỗn dũ náq cũai tâng dống sũ.” ");
INSERT INTO bru_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Máh cũai I-sarel táq puai parnai ki. Bữn án ca ĩt sa‑ữi, bữn án ca ĩt bĩq. ");
INSERT INTO bru_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Toâq alới cân, án ca ĩt sa‑ữi la tỡ bữn clữi cha. Ma án ca ĩt bĩq, la dũ cha. Ma alới ĩt dũ máh alới cơi cha. ");
INSERT INTO bru_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Môi-se atỡng alới neq: “Chỗi yỗn cũai aléq ĩt dŏq toau toâq tangái parnỡ.” ");
INSERT INTO bru_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ma bữn cũai tỡ bữn trĩh parnai Môi-se atỡng; alới ĩt dŏq sana ki toau toâq tarưp parnỡ. Chơ sana ki cỡt mpang cớp nsóq nheq. Ngkíq Môi-se sâng cutâu chóq cũai ki. ");
INSERT INTO bru_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Cu tarưp dũ náq alới ĩt máh alới yoc ễ cha. Ma toâq moat mandang loŏh bữn phũac cutâu lứq; chơ sana ki yŏ́h dưoiq nheq. ");
INSERT INTO bru_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Tâng tangái tapoât tỗp alới ĩt sana ki bữn bar pún; manoaq ĩt pỗn ki-lô. Máh cũai sốt tâng tỗp I-sarel toâq atỡng tễ ranáq nâi yỗn Môi-se dáng. ");
INSERT INTO bru_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Chơ Môi-se atỡng tỗp alới neq: “Yiang Sursĩ atỡng neq: ‘Tâng tangái parnỡ la Tangái Rlu dŏq sang yỗn Yiang Sursĩ. Ngkíq sana ntrớu anhia yoc ễ áng, yỗn anhia áng tangái nâi toâp. Cớp sana ntrớu anhia yoc ễ ớp, yỗn anhia ớp tangái nâi toâp. Ma sana ntrớu clữi, ki anhia dŏq cha tangái parnỡ.’” ");
INSERT INTO bru_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Alới trĩh parnai Môi-se atỡng. Alới dŏq sana clữi ki toau toâq tangái parnỡ, ma sana ki tỡ bữn nsóq cớp tỡ bữn mpang. ");
INSERT INTO bru_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Chơ Môi-se atỡng neq: “Cóq anhia cha sana clữi ki yỗn nheq tâng tangái nâi toâp, yuaq tangái nâi la Tangái Rlu dŏq sang Yiang Sursĩ. Khân anhia pỡq ravoât sana yáng tiah, ki anhia tỡ bữn ramóh. ");
INSERT INTO bru_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Cóq anhia parỗm máh sana tâng tapoât tangái sâng. Ma tâng tangái tapul, la Tangái Rlu, tỡ bữn bữn mana.” ");
INSERT INTO bru_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ma tâng Tangái Rlu, bữn cũai pỡq ravoât sana, ma alới tỡ bữn ramóh ntrớu tháng. ");
INSERT INTO bru_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Vớt ki, Yiang Sursĩ atỡng Môi-se neq: “Noâng maléq dũn tỗp anhia tỡ ễq trĩh parnai cứq patâp? ");
INSERT INTO bru_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Cóq anhia chanchớm yỗn samoât, cứq la Yiang Sursĩ khoiq yỗn anhia bữn Tangái Rlu. Yuaq ngkíq, tâng tangái tapoât cứq yỗn anhia bữn sana yỗn têq dũ cha tâng bar tangái. Ma tâng tangái tapul, dũ náq anhia cóq ỡt sâng, chỗi loŏh tễ dống.” ");
INSERT INTO bru_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ngkíq máh cũai I-sarel tỡ bữn táq ranáq ntrớu tâng tangái tapul. ");
INSERT INTO bru_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Máh cũai I-sarel amứh crơng sana ki la mana. Mana nâi cỡt ariang ŏ́c lavứng cloc cớp ễm machớng bễng mi carchốc dỡq khĩal. ");
INSERT INTO bru_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Môi-se pai neq: “Yiang Sursĩ khoiq patâp tỗp hái yỗn dŏq bĩq mana, khễ apáh yỗn tŏ́ng toiq tỗp hái nhêng sana Yiang Sursĩ yỗn hái cha tâng ntốq aiq, bo án dững hái loŏh tễ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ngkíq Môi-se atỡng Arôn neq: “Cóq mới ĩt muoi lám cudốm. Chơ dŏq mana bar ki-lô; dŏq khang ki yáng moat Yiang Sursĩ yỗn tŏ́ng toiq hái têq nhêng.” ");
INSERT INTO bru_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Arôn táq puai máh santoiq Yiang Sursĩ khoiq ớn Môi-se; chơ án dŏq loâng cudốm mana ki yáng moat Hĩp Parnai Parkhán. ");
INSERT INTO bru_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Nheq pỗn chít cumo máh cũai I-sarel bữn cha mana, toau alới toâq pỡ cruang Cana-an, la ntốq alới ỡt loâng. ");
INSERT INTO bru_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Noau cân mana muoi tangái muoi ‘ô-mê’ la sám bar ki-lô. Cớp muoi chít ô-mê cỡt muoi ‘ê-pha’.). ");
INSERT INTO bru_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nheq tữh cũai I-sarel loŏh tễ ntốq aiq ramứh Sín. Alới atỡi tễ ntốq nâi pỡq chu ntốq ki puai santoiq Yiang Sursĩ ớn. Alới ỡt dỡ tâng ntốq Rê-phi-dim, ma ŏ́q dỡq nguaiq. ");
INSERT INTO bru_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tỗp alới bubéq-bubưp chóq Môi-se neq: “Chuaq dỡq yỗn hếq nguaiq.” Môi-se ta‑ỡi neq: “Cỗ nŏ́q tỗp anhia ma bubéq-bubưp? Cỗ nŏ́q anhia chim níc Yiang Sursĩ?” ");
INSERT INTO bru_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ma máh tỗp alới sâng ễ khlac dỡq, chơ alới bubéq-bubưp níc chóq Môi-se neq: “Cỗ nŏ́q anhia ma dững tỗp hếq loŏh tễ cruang Ê-yip-tô, cỗ ễq hếq, máh con hếq, dếh máh charán hếq, cuchĩt khlac dỡq tỡ?” ");
INSERT INTO bru_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Chơ Môi-se câu sễq tễ Yiang Sursĩ nheq rangứh rahỡ neq: “Nŏ́q cứq ễ táq cớp máh cũai nâi? Tỗp alới mán ễ tám tamáu chóq cứq.” ");
INSERT INTO bru_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yiang Sursĩ ta‑ỡi Môi-se neq: “Cóq mới dững máh cũai sốt tỗp I-sarel pỡq cớp mới nhũang cũai proai. Cóq mới dững ralỡng mới khoiq toân tâng crỗng Nil tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Cứq ễ tayứng ỡt yáng moat mới cheq côl tamáu tâng cóh Si-nai. Cóq mới toân côl tamáu ki, chơ dỡq loŏh yỗn cũai proai bữn nguaiq.” Choâng moat máh cũai sốt tỗp I-sarel, Môi-se táq puai máh parnai Yiang Sursĩ atỡng án. ");
INSERT INTO bru_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ngkíq Môi-se dŏq ramứh ntốq ki la Masah cớp Mê-ri-ba, yuaq tỗp I-sarel bubéq-bubưp, cớp alới chim Yiang Sursĩ na blớh neq: “Yiang Sursĩ lứq ỡt cớp tỗp hái, ma tỡ bữn?” ");
INSERT INTO bru_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tỗp A-maléc toâq chíl tỗp I-sarel tâng ntốq Rê-phi-dim. ");
INSERT INTO bru_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Môi-se atỡng Yô-sũa neq: “Cóq mới rưoh cũai dŏq loŏh rachíl cớp tỗp A-maléc tâng tangái parnỡ. Cứq ễ tayứng tâng anũol cóh; chơ cứq yống ralỡng Yiang Sursĩ ớn cứq dững.” ");
INSERT INTO bru_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ngkíq Yô-sũa táq puai máh parnai Môi-se atỡng. Án dững máh cũai I-sarel loŏh rachíl cớp tỗp A-maléc. Bo ki Môi-se, Arôn, cớp Hơr chỗn tayứng tâng anũol cóh. ");
INSERT INTO bru_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Bo Môi-se acŏ́q atĩ achỗn, tỗp I-sarel chíl riap, ma bo Môi-se asễng loah atĩ, tỗp A-maléc ễn bữn chíl riap. ");
INSERT INTO bru_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Toâq Môi-se sâng lakiei atĩ, ki Arôn cớp Hơr dững tamáu yỗn Môi-se tacu. Chơ alới tayứng manoaq muoi coah Môi-se, cớp acŏ́q ngcŏ́ng Môi-se achỗn toau toâq moat mandang pât. ");
INSERT INTO bru_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yuaq ngkíq, Yô-sũa bữn chíl riap tahan tỗp A-maléc. ");
INSERT INTO bru_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Vớt ki, Yiang Sursĩ atỡng Môi-se neq: “Cóq mới chĩc dŏq tễ ranáq tỗp anhia chíl riap nâi yỗn têq sanhữ. Cóq mới atỡng yỗn Yô-sũa dáng la cứq ễ pupứt nheq tỗp A-maléc.” ");
INSERT INTO bru_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Chơ Môi-se táq muoi lám prông sang tâng ntốq ki. Án amứh prông ki la ‘Yiang Sursĩ Cỡt Tếc Atỡng Tễ Cứq Chíl Riap’. ");
INSERT INTO bru_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Môi-se atỡng neq: “Cóq anhia patứng achỗn tếc Yiang Sursĩ chíl riap, yuaq Yiang Sursĩ ễ chíl cũai A-maléc mantái níc.” ");
INSERT INTO bru_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yê-trô yacũn Môi-se la cũai tễng rit sang tâng tỗp Madian. Án khoiq sâng tễ ranáq Yiang Sursĩ táq yỗn Môi-se cớp cũai I-sarel bo Ncháu dững tỗp alới loŏh tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ngkíq Yê-trô toâq ramóh Môi-se. Án dững dếh Si-pô-ra lacuoi Môi-se, ca Môi-se cơiq dŏq cớp án, ");
INSERT INTO bru_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","dếh Kêr-sôm cớp E-lia-se, la bar náq con samiang Si-pô-ra. Môi-se khoiq amứh con samiang dâu la Kêr-sôm, yuaq án pai neq: “Cứq la cũai mpha cruang ca tarôq ỡt tâng cruang noau.” ");
INSERT INTO bru_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Cớp con samiang bar án amứh E-lia-se, yuaq án pai: “Yiang Sursĩ mpoaq cứq sang khoiq chuai yỗn cứq bữn vớt tễ talang atĩ puo.” ");
INSERT INTO bru_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Chơ Yê-trô dững lacuoi Môi-se cớp bar náq con samiang Môi-se pỡq chu ntốq aiq; bân ki Môi-se ỡt dỡ pỡ cóh khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Án cơiq parnai yỗn Môi-se dáng nhũang án ễ toâq sa‑óh, dững dếh lacuoi Môi-se cớp bar náq con samiang Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ngkíq Môi-se loŏh roap Yê-trô. Môi-se ap muoi tatứp yáng moat Yê-trô, cớp hũn hĩt án. Chơ alới manoaq blớh manoaq tễ ŏ́c túh coat cớp ŏ́c ien khễ. Moâm ki alới mut tâng dống aroâiq Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Môi-se nsũar loah yỗn Yê-trô tamứng tễ máh ramứh Yiang Sursĩ khoiq táq chóq puo cớp cũai Ê-yip-tô bo án dững aloŏh máh cũai I-sarel. Cớp án atỡng Yê-trô tễ ramứh túh coat alới khoiq chĩuq tâng rana, cớp nŏ́q toâp Yiang Sursĩ chuai amoong alới. ");
INSERT INTO bru_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Toâq Yê-trô sâng cớp dáng dũ ramứh ki, án sâng bũi lứq, ");
INSERT INTO bru_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","cớp pai neq: “Khễn Yiang Sursĩ, án ca khoiq chuai amoong anhia yỗn vớt tễ talang atĩ puo cớp máh cũai Ê-yip-tô, dếh chuai anhia yỗn vớt tễ cỡt sũl. ");
INSERT INTO bru_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sanua nâi hếq dáng samoât lứq la Yiang Sursĩ cỡt sốt clữi nheq tễ yiang canŏ́h, yuaq án táq ranáq nâi chóq cũai ca mumat cũai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Chơ Yê-trô yacũn Môi-se, án kiac charán bốh chiau sang, cớp án ĩt crơng canŏ́h hỡ chiau sang yỗn Yiang Sursĩ. Arôn cớp máh cũai sốt tỗp I-sarel pỡq cha bũi nứng án dŏq sang toam Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Tâng tangái parnỡ Môi-se tacu tâng ntốq noau parchĩn. Án parchĩn parnai yỗn cũai proai tễ tarưp toau sadâu. ");
INSERT INTO bru_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Toâq Yê-trô hữm dũ ranáq Môi-se táq, chơ Yê-trô blớh neq: “Anhia ntôm táq ntrớu yỗn cũai nâi? Cỗ nŏ́q anhia parchĩn parnai ống manoaq sâng, táq yỗn máh cũai nâi ỡt acoan tễ tarưp toau sadâu?” ");
INSERT INTO bru_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Chơ Môi-se ta‑ỡi neq: “Hếq cóq táq, yuaq máh cũai proai nâi toâq pỡ hếq yoc ễ dáng ranáq ntrớu Yiang Sursĩ yỗn alới táq. ");
INSERT INTO bru_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Toâq bữn bar náq tâng tỗp alới ma ralỗih, ki alới toâq pỡ hếq. Ngkíq hếq cóq parchĩn yỗn alới bar coah, noau lôih noau pĩeiq. Cớp hếq atỡng yỗn alới dáng máh ŏ́c patâp cớp phễp rit Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Chơ Yê-trô atỡng Môi-se neq: “Táq ngkíq tỡ pĩeiq. ");
INSERT INTO bru_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Khân ống manoaq anhia sâng táq ranáq nâi ki tỡ rơi, yuaq ntâng lứq, táq yỗn anhia cớp máh cũai proai cỡt lakéh lakiei. ");
INSERT INTO bru_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sanua nâi hếq sễq tĩeih atỡng anhia ranáq o, chơ Yiang Sursĩ lứq ỡt níc cớp anhia. Lứq pĩeiq anhia cỡt cũai tang nheq tữh cũai proai yáng moat Yiang Sursĩ, cớp partoâq máh ŏ́c alới ralỗih pỡ án. ");
INSERT INTO bru_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Cóq anhia arĩen yỗn tỗp alới dáng máh santoiq Yiang Sursĩ patâp. Cớp atỡng yỗn alới dáng ranáq ntrớu o yỗn alới táq, cớp cóq alới táq puai nŏ́q. ");
INSERT INTO bru_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Hỡn tễ ki ễn, cóq anhia rưoh cũai rangoaiq, cớp chóh alới yỗn cỡt sốt cũai proai, dŏq táq sốt muoi ngin náq, muoi culám náq, sỡng chít náq, tỡ la muoi chít náq. Ma nheq tữh cũai anhia rưoh cóq alới yám noap Yiang Sursĩ, cóq cũai canŏ́h têq noap alới, cớp cóq alới tỡ bữn ĩt práq noau sadal. ");
INSERT INTO bru_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Cóq anhia chiau chớc yỗn tỗp alới ễn táq ranáq parchĩn máh cũai ralỗih. Ranáq toâr, ki yỗn alới atoâq pỡ anhia; ma ranáq cớt, yỗn alới parchĩn bữm. Táq ngkíq, ranáq anhia tỡ bữn ntâng noâng, yuaq tỗp alới têq rachuai anhia. ");
INSERT INTO bru_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Khân anhia táq ngkíq, cớp khân Yiang Sursĩ pruam, ki ranáq anhia táq cỡt nghễl. Cớp máh cũai proai nâi bữn chu chái pỡ dống alới, yuaq máh parnai parchĩn khoiq chĩn chơ.” ");
INSERT INTO bru_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Chơ Môi-se trĩh dũ ŏ́c Yê-trô tĩeih án. ");
INSERT INTO bru_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Án rưoh máh cũai rangoaiq tễ tỗp I-sarel, chơ chóh alới cỡt sốt tâng tỗp muoi ngin náq, muoi culám náq, sỡng chít náq, tỡ la muoi chít náq. ");
INSERT INTO bru_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tỗp alới táq níc ranáq parchĩn yỗn cũai proai. Ma alới parchĩn ống ranáq cớt sâng; máh ranáq toâr, ki alới atoâq pỡ Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Chơ, Môi-se cớp Yê-trô manoaq carbán carsũan manoaq, cớp Yê-trô píh chu loah pỡ vil viang án bữm. ");
INSERT INTO bru_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Cũai I-sarel loŏh tễ ntốq Rê-phi-dim pỡq pỡ cóh Si-nai. Noap tễ tangái alới loŏh tễ cruang Ê-yip-tô toau toâq tangái muoi, casâi pái, alới toâq pỡ ntốq aiq cheq cóh Si-nai, chơ ỡt dỡ pỡ ki. ");
INSERT INTO bru_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Chơ Môi-se chỗn pỡ cóh yoc ễ ramóh Yiang Sursĩ. Yiang Sursĩ arô Môi-se tễ anũol cóh, cớp ớn Môi-se atỡng cũai I-sarel, la tŏ́ng toiq Yacốp, neq: ");
INSERT INTO bru_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Anhia khoiq hữm chơ ranáq cứq Yiang Sursĩ táq chóq cũai Ê-yip-tô, cớp khoiq hữm cứq dững anhia toâq pỡ cứq, ariang calang crức dững con án tâng pỡng khlap. ");
INSERT INTO bru_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sanua, khân tỗp anhia trĩh cứq cớp táq puai máh parnai cứq parkhán, ki anhia cỡt cũai proai cứq. Paloŏng cutễq nâi cỡt khong cứq nheq, ma cứq khoiq rưoh tỗp anhia tễ máh tỗp cũai yỗn cỡt tỗp cứq pasếq lứq. ");
INSERT INTO bru_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Anhia cỡt cũai miar yỗn cứq, cớp anhia cỡt cũai tễng rit sang yỗn cứq. Nâi la máh santoiq cóq mới atỡng máh cũai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ngkíq Môi-se sễng tễ cóh. Án arô máh cũai sốt cũai proai toâq ramóh án. Chơ án atỡng loah yỗn alới dũ ŏ́c Yiang Sursĩ khoiq ớn án. ");
INSERT INTO bru_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Máh cũai proai ta‑ỡi muoi prớh neq: “Nheq tỗp hếq pruam ễ táq dũ ramứh Yiang Sursĩ khoiq atỡng.” Chơ Môi-se chỗn atỡng loah Yiang Sursĩ máh santoiq cũai proai ta‑ỡi. ");
INSERT INTO bru_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yiang Sursĩ pai ễn chóq Môi-se neq: “Cứq ễ toâq ramóh mới tễ ramứl pếng-páng dŏq máh cũai proai bữn sâng cứq táq ntỡng cớp mới. Ngkíq nŏ́q, alới noap níc mới.” Chơ Môi-se atỡng loah Yiang Sursĩ tễ máh santoiq cũai proai khoiq ta‑ỡi án. ");
INSERT INTO bru_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới sễng atỡng cũai proai yỗn alới sambráh tỗ chác alới bữm tâng tangái nâi cớp tangái parnỡ, dŏq alới têq sang toam cứq. Yỗn alới pooh tampâc yỗn bráh, cớp ");
INSERT INTO bru_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","thrũan dŏq tangái pra. Yuaq tangái ki cứq ễ sễng pỡ cóh Si-nai bo nheq tữh cũai ỡt nhêng. ");
INSERT INTO bru_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Cóq mới táq canong lavíng pễr cóh ki chỗi yỗn tỗp proai pỡq luat canong ki. Cớp atỡng alới chỗi chỗn chu cóh, tỡ la ỡt cheq yững cóh. Khân cũai aléq ma tayáh luat canong ki, ki án cóq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Cóq cachĩt án na tám chóq tamáu, tỡ la pán chóq saráh. Chỗi yỗn noau satoaq tỗ án. Tỡ bữn pai cũai tỡ la charán, cóq án cuchĩt. Ma toâq anhia sâng sưong lavia, ki têq anhia chỗn chu cóh.” ");
INSERT INTO bru_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Vớt ki Môi-se sễng tễ cóh píh loah chu ntốq cũai I-sarel ỡt, cớp án atỡng yỗn alới thrũan dŏq sang toam Yiang Sursĩ. Chơ alới pooh tampâc. ");
INSERT INTO bru_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Cớp Môi-se atỡng tỗp alới ễn neq: “Cóq anhia thrũan dŏq yỗn tangái pra; mansễm samiang chỗi bếq parnơi tâng máh tangái anhia thrũan.” ");
INSERT INTO bru_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tarưp pra, bữn sưong crứm bubữr cớp bữn lalieiq. Bữn ramứl cubân lứq clũom nheq cóh ki. Cớp bữn sưong lavia casang lứq, táq yỗn máh cũai proai ca ỡt dỡ tâng ntốq ki cỡt ngcŏh cớp cangcoaih. ");
INSERT INTO bru_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Chơ Môi-se dững máh cũai proai loŏh tễ ntốq alới ỡt dỡ, pỡq ramóh Yiang Sursĩ cheq yững cóh ki. ");
INSERT INTO bru_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Chũop cóh Si-nai bữn phĩac, yuaq Yiang Sursĩ sễng na pla ũih tâng anũol cóh ki. Bữn phĩac suol achỗn ariang phĩac loŏh tễ lo ũih toâr lứq. Cớp cóh ki cỡt rachâu rloâm-rlức tháng. ");
INSERT INTO bru_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Bữn sưong lavia bữr casang achỗn ễn. Chơ Môi-se atỡng, cớp Yiang Sursĩ ta‑ỡi án na sưong crứm. ");
INSERT INTO bru_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yiang Sursĩ sễng ỡt tâng anũol cóh Si-nai. Chơ án arô Môi-se yỗn chỗn chu anũol cóh. Ngkíq Môi-se chỗn. ");
INSERT INTO bru_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới sễng atỡng loah máh cũai proai chỗi yỗn alới mut nhêng ntốq Yiang Sursĩ ỡt. Khân alới ma chỗn toâq pỡ nâi, ki sa‑ữi náq chĩuq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dếh cũai tễng rit sang, khân mut cheq cứq, cóq alới sambráh tỗ bữm. Khân tỡ bữn ngkíq, ki cứq ễ táq alới.” ");
INSERT INTO bru_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ma Môi-se ta‑ỡi loah Yiang Sursĩ neq: “Máh cũai proai tỡ têq chỗn chu cóh nâi, yuaq anhia khoiq sưoq hếq neq: ‘Cóh nâi la khong cứq, cóq mới táq tếc yoang savang pễr yững cóh nâi.’” ");
INSERT INTO bru_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yiang Sursĩ ta‑ỡi loah neq: “Cóq mới sễng coâiq Arôn yỗn án chỗn nứng mới. Ma máh tỗp cũai tễng rit sang, cớp máh cũai proai I-sarel, ki tỡ yỗn alới mut chu ntốq nâi. Khân alới mut, cứq ễ táq alới.” ");
INSERT INTO bru_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ngkíq Môi-se sễng tễ cóh pỡq ramóh loah máh cũai proai, cớp atỡng loah dũ ramứh máh Yiang Sursĩ khoiq atỡng án. ");
INSERT INTO bru_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Chơ Yiang Sursĩ atỡng santoiq neq: ");
INSERT INTO bru_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Cứq la Yiang Sursĩ, Ncháu anhia, án ca dững anhia loŏh tễ cỡt sũl tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Máh yiang mpha tễ cứq, ki anhia chỗi sang. ");
INSERT INTO bru_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Chỗi táq rup sang ntrớu tũoiq máh ramứh tâng paloŏng, tâng cutễq, tỡ la tâng dỡq pưn cutễq. ");
INSERT INTO bru_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Chỗi cucốh tỡ la sang rup ki, yuaq cứq la Yiang Sursĩ, Ncháu anhia, tỡ bữn pruam anhia puai yiang canŏ́h. Cứq manrap cũai ca kêt cứq, dếh con châu alới toau pái pỗn dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ma cứq apáh ŏ́c ayooq chóq alới ca ayooq cứq cớp trĩh máh phễp rit cứq, toau toâq ngin dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Chỗi arô ramứh cứq tỡ pĩeiq rana, yuaq cứq Yiang Sursĩ, Ncháu anhia ễ manrap dũ náq cũai ca clễu ramứh cứq dŏq táq ranáq tỡ pĩeiq. ");
INSERT INTO bru_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Cóq anhia sanhữ Tangái Rlu, yỗn cỡt tangái miar dŏq sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Yỗn anhia táq ranáq tâng tapoât tangái, ");
INSERT INTO bru_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ma tâng tangái tapul cóq anhia rlu, dŏq sang toam cứq. Tâng tangái ki anhia chỗi táq ranáq ntrớu; dếh con, dếh sũl, dếh charán, dếh cũai tễ cruang canŏ́h ca ỡt tâng cruang anhia, la táq machớng nheq. ");
INSERT INTO bru_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tâng tapoât tangái, cứq la Yiang Sursĩ khoiq tễng paloŏng cutễq, dỡq mưt, cớp túc ramứh ỡt tâng ki; ma tâng tangái tapul cứq rlu. Yuaq ngkíq, cứq la Yiang Sursĩ, dŏq Tangái Rlu yỗn cỡt tangái miar dŏq cũai sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Cóq anhia yám noap mpiq mpoaq anhia, yỗn anhia têq ỡt cóng tamoong dũn tâng cutễq cứq ễ chiau yỗn anhia. ");
INSERT INTO bru_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Chỗi cachĩt cũai. ");
INSERT INTO bru_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Chỗi cooc lacuoi tỡ la cayac cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Chỗi tutuoiq. ");
INSERT INTO bru_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Chỗi tũn apớt cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Chỗi ễ bữn dống yớu, lacuoi yớu, cũai sũl yớu, ntroŏq yớu, aséh dễn yớu, tỡ la máh crơng crớu yớu.” ");
INSERT INTO bru_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Toâq cũai proai sâng sưong crứm cớp sưong lavia, dếh hữm lalieiq cớp phĩac tâng cóh, chơ tỗp alới sâng ngcŏh cớp cangcoaih. Alới carlũn aloŏh ỡt yơng tễ cóh. ");
INSERT INTO bru_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Alới pai chóq Môi-se neq: “Khân anhia táq ntỡng cớp tỗp hếq, ki hếq tamứng. Ma khân Yiang Sursĩ táq ntỡng cớp tỗp hếq, ki hếq ngcŏh cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Môi-se ta‑ỡi neq: “Chỗi ngcŏh ntrớu. Yiang Sursĩ khoiq toâq ễ chim anhia, cớp án táq yỗn anhia yám noap cớp trĩh án, dŏq anhia tỡ bữn táq lôih.” ");
INSERT INTO bru_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Máh cũai proai ỡt tayứng yơng; bữn ống manoaq Môi-se sâng pỡq cheq ramứl pếng-páng ki, la ntốq Yiang Sursĩ ỡt. ");
INSERT INTO bru_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yiang Sursĩ ớn Môi-se atỡng máh cũai I-sarel neq: “Dũ náq anhia khoiq hữm chơ la cứq Yiang Sursĩ khoiq atỡng anhia tễ paloŏng. ");
INSERT INTO bru_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Anhia chỗi táq rup yiang canŏ́h toâq práq tỡ la yễng, chơ cucốh sang rup ki machớng cớp sang cứq. ");
INSERT INTO bru_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Cóq anhia ĩt cutễq puon táq prông dŏq sang cứq. Tâng pỡng prông ki cóq anhia bốh cữu cớp ntroŏq tangcáh dŏq chiau sang cứq. Cớp cóq anhia chiau sang crơng canŏ́h dŏq cỡt ratoi. Ntốq aléq cứq yỗn anhia sang toam cứq, tâng ntốq ki cứq toâq pỡ anhia cớp satốh ŏ́c bốn yỗn anhia. ");
INSERT INTO bru_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ma khân anhia táq prông sang yỗn cứq toâq tamáu, ki anhia chỗi ĩt tamáu noau cứt toâq tac, yuaq táq ngkíq tỡ pĩeiq dŏq sang toam cứq. ");
INSERT INTO bru_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Chỗi táq prông sang bữn cál ntruang. Cŏh lơ bo anhia chỗn, bữn cũai canŏ́h hữm crơng sarcal anhia.” ");
INSERT INTO bru_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Yiang Sursĩ pai neq: “Cóq mới aloŏh phễp rit yỗn máh cũai I-sarel táq neq: ");
INSERT INTO bru_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Khân anhia chỡng cũai Hê-brơ dŏq cỡt sũl, têq án cỡt sũl anhia nheq tapoât cumo. Tâng cumo tapul cóq anhia acláh yỗn án vớt tễ cỡt sũl, ma án tỡ bữn túh culáh loah kia anhia chỡng án. ");
INSERT INTO bru_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Khân án tỡ yũah bữn lacuoi bo án cỡt sũl anhia, toâq án bữn racláh tễ cỡt sũl, ki án tỡ têq dững lacuoi pỡq nứng án. Ma khân án cỡt sũl anhia ma khoiq bữn lacuoi chơ, ki têq án dững dếh lacuoi pỡq tê. ");
INSERT INTO bru_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ma khân ncháu chuaq yỗn án bữn lacuoi, toâq mansễm ki canỡt con samiang tỡ la mansễm, lacuoi ki cớp nheq con án cỡt khong ncháu. Toâq samiang ki racláh tễ cỡt sũl, án loŏh ống manoaq án. ");
INSERT INTO bru_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ma khân cũai sũl ki atỡng raloaih pai án ayooq cũai ncháu án, lacuoi án, cớp con án, ma án tỡ ễq loŏh tễ cỡt sũl, ");
INSERT INTO bru_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","chơ ncháu cóq dững án toâq pỡ ntốq sang toam. Tâng ntốq ki, cóq án tayứng apớt cutũr tâng santŏ́ng toong, dŏq yỗn ncháu clốh cutũr án. Ngkíq, cũai ki cỡt sũl nheq dỡi tamoong. ");
INSERT INTO bru_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Khân cũai aléq ma chếq con cumũr án yỗn cỡt sũl, ngkíq mansễm ki tỡ bữn cóq acláh ariang cũai samiang. ");
INSERT INTO bru_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ma khân cũai ncháu rưoh mansễm ki ễ táq lacuoi, ma sâng tỡ ễq noâng án, cóq ncháu ki yỗn mpoaq mansễm ki thái loah. Ncháu ki tỡ têq chếq mansễm ki pỡ cũai cruang canŏ́h, yuaq án khoiq táq tỡ pĩeiq chóq mansễm ki. ");
INSERT INTO bru_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Khân samiang aléq ma rưoh mansễm sũl yỗn cỡt lacuoi con samiang án, cóq án táq o cớp mansễm ki machớng án táq chóq con mansễm án bữm. ");
INSERT INTO bru_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Khân samiang aléq ma ĩt lacuoi bar, cóq án chứm siem lacuoi nỡm na crơng sana, na tampâc tâc, cớp cóq án bếq parnơi patoat tễ nling. ");
INSERT INTO bru_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Khân án tỡ bữn táq ngkíq chóq lacuoi nỡm, cóq án acláh mansễm ki pỡq, cớp mansễm ki tỡ bữn túh culáh kia bóc chỡng. ");
INSERT INTO bru_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Khân cũai aléq ma pieih cũai canŏ́h toau cuchĩt, cóq noau cachĩt tê án. ");
INSERT INTO bru_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ma khân án táq lơ, tỡ bữn yoc ễ cachĩt cũai ki, têq án lúh poâng pỡ ntốq cứq anoat dŏq. Chơ têq án ỡt plot o. ");
INSERT INTO bru_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ma khân cũai aléq sâng nsóq mứt cớp cachĩt cũai canŏ́h, tam án lúh poâng pỡ prông sang cứq, ma án cóq cuchĩt tê. ");
INSERT INTO bru_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Cũai aléq ma toân toah mpiq mpoaq án bữm, cóq án roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Cũai aléq ma cỗp tuoiq cũai canŏ́h, tỡ bữn pai án ễ chếq tỡ la yỗn cỡt sũl án, cóq án roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Cũai aléq ma lóc acrieiq mpiq mpoaq án bữm, cũai ki cóq chĩuq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Khân bữn bar náq cũai ma ralỗih ratáq, chơ bữn manoaq ĩt tamáu latớt tỡ la chooc, ma cũai ki tỡ bữn cuchĩt, anhia tỡ têq yỗn cũai ki roap tôt. ");
INSERT INTO bru_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Ma khân án ca pĩeiq noau latớt toâq tamáu, ma chũl cóq bếq tua, chơ vớt tễ ki têq án yuor tayứng cloaq ralỡng tayáh pỡq chu, cũai ca táq án cóq yỗn kia cớp pur-ar toau án cỡt bán. ");
INSERT INTO bru_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Khân cũai aléq ma ĩt aluang pieih sũl án, samiang tỡ la mansễm, ma sũl ki cuchĩt bo ki toâp, án ca pieih ki cóq roap tôt. ");
INSERT INTO bru_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ma vớt muoi tỡ la bar tangái, khân sũl ki noâng tỡ yũah cuchĩt, ncháu ki tỡ bữn roap tôt, yuaq sũl ki la lứq khong án. ");
INSERT INTO bru_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Khân bữn máh cũai samiang carchĩt, ma lơ pĩeiq mansễm ca ỡt mumiaq, chơ con án cuchĩt tâng púng, ma mansễm ki tỡ bữn pân ntrớu, cũai ca táq mansễm ki cóq tu máh cayac án yoc ễ bữn, ma cóq cũai parchĩn parnai hữm pĩeiq puai rit. ");
INSERT INTO bru_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ma khân mansễm ki cuchĩt, cóq anhia ĩt rangứh pláih loah rangứh. ");
INSERT INTO bru_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Moat pláih loah moat, canễng pláih loah canễng, atĩ pláih loah atĩ, cớp ayững pláih loah ayững, ");
INSERT INTO bru_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","mang-al ũih pláih loah mang-al ũih, bớc pláih loah bớc, trúc pláih loah trúc. ");
INSERT INTO bru_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Khân cũai ncháu táq muoi ŏ́c moat cũai sũl, samiang tỡ la mansễm, yỗn cỡt sũt, cóq án acláh cũai sũl ki. Nâi la kia ŏ́c moat. ");
INSERT INTO bru_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Khân án táq yỗn canễng cũai sũl clŏ́h, cóq án acláh cũai sũl ki. Nâi la kia canễng. ");
INSERT INTO bru_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Khân bữn muoi lám ntroŏq tangcáh ma sớc cũai toau cuchĩt, cóq noau cachĩt charán ki na tám chóq tamáu, cớp tỡ têq cha sâiq charán ki. Ma ncháu charán ki tỡ bữn roap tôt. ");
INSERT INTO bru_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ma khân ntroŏq ki dốq sớc cũai, cớp noau khoiq atỡng ncháu ntroŏq ki, ma án tỡ bữn kháng ntroŏq tâng cuaq, chơ ntun ki ntroŏq án sớc sĩa cũai toau cuchĩt, cóq tám tamáu chóq ntroŏq ki yỗn cuchĩt, cớp ncháu ntroŏq cóq roap tôt cuchĩt tê. ");
INSERT INTO bru_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ma khân noau yỗn ncháu charán ki têq tu panôiq cũai ca khoiq cuchĩt ki, cóq án yỗn dũ máh noau ễ bữn. ");
INSERT INTO bru_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Khân ntroŏq tangcáh ma sớc carnễn samiang tỡ la carnễn mansễm cuchĩt, cóq ĩt tâc phễp rit nâi dŏq anoat tôt. ");
INSERT INTO bru_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Khân ntroŏq tangcáh ma sớc cũai sũl cuchĩt, samiang tỡ la mansễm, ki ncháu ntroŏq ki cóq tu panôiq pái chít ŏ́c práq yỗn ncháu cũai sũl. Cớp charán ki cóq cuchĩt na tám chóq tamáu. ");
INSERT INTO bru_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Khân cũai aléq pớh dỡq chữong, tỡ la píq dỡq parníq, ma tỡ bữn catáih dŏq, chơ bữn ntroŏq tangcáh, tỡ la aséh dễn, sapứl tâng chữong ki, ");
INSERT INTO bru_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","cũai ca píq ki cóq culáh kia yỗn ncháu charán. Ma têq án ĩt charán cuchĩt ki cỡt khong án. ");
INSERT INTO bru_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Khân bữn ntroŏq cũai aléq ma sớc ntroŏq cũai canŏ́h cuchĩt, cóq bar náq cũai ki chếq chíq ntroŏq noâng tamoong, chơ tampễq práq ki. Cớp têq alới tampễq sâiq ntroŏq ca khoiq cuchĩt ki hỡ. ");
INSERT INTO bru_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ma khân ncháu ntroŏq dáng chơ ntroŏq án cơi sớc ntroŏq cũai canŏ́h, ma án tỡ bữn kháng dŏq ntroŏq án tâng cuaq, ki cóq án culáh loah muoi lám ntroŏq tamoong yỗn pỡ ncháu ntroŏq cuchĩt. Ma têq án ĩt charán cuchĩt ki, cỡt khong án. ");
INSERT INTO bru_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Khân bữn manoaq cũai tutuoiq ntroŏq tỡ la cữu, ma án cachĩt tỡ la chếq, muoi lám ntroŏq cóq án culáh loah sỡng lám, cớp muoi lám cữu cóq án culáh loah pỗn lám. ");
INSERT INTO bru_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","“Cóq án tu práq máh crơng án tutuoiq ki. Khân án tỡ bữn ntrớu ễ yỗn, ki cóq chếq án yỗn cỡt cũai sũl pláih loah kia crơng án khoiq tuoiq. Khân charán án tuoiq ki, dếh ntroŏq, aséh dễn, tỡ la cữu, ma noâng tamoong cớp ỡt tâng dống án, muoi lám cóq án culáh loah bar lám. “Khân bữn cũai mut tutuoiq tâng dống bo sadâu, cớp noau cachĩt án, cũai ca cachĩt án tỡ bữn lôih ntrớu. Ma khân án táq ngkíq tâng tangái, cũai ca cachĩt án lứq bữn lôih cachĩt cũai. ");
INSERT INTO bru_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Khân bữn cũai aléq acláh charán án pỡq chuaq cha bát tâng sarái tỡ la nia, tỡ la tâng nưong nho, cớp charán ki clŏ́c tỗp, chơ pỡq cha crơng sarnóh tâng sarái cũai canŏ́h, ncháu charán ki cóq tu loah máh sarnóh o tễ sarái án bữm yỗn cũai ncháu sarái ca charán án cha. ");
INSERT INTO bru_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Khân cũai aléq chŏ́ng sarái án, cớp ũih ki trŏ́h cat bát bai tâng sarái cũai canŏ́h, dếh nỡm saro, tỡ la saro noau khoiq roaiq cớp bốq dŏq, cũai ca chŏ́ng ki cóq án tu loah máh sarnóh khoiq cat ki. ");
INSERT INTO bru_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Khân cũai aléq roap ĩt práq tỡ la crơng bữn kia tễ cũai canŏ́h cơiq, ma noau canŏ́h tuoiq tễ dống án, khân án bữn satỡm cỗp cũai tutuoiq, cũai ki cóq culáh loah bar pún. ");
INSERT INTO bru_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ma khân tỡ dáng bữn cỗp cũai tutuoiq ki, cóq noau dững án ca roap crơng ki toâq pỡ ntốq sang Yiang Sursĩ. Tâng ntốq ki cóq án thễ dũan án tỡ bữn tuoiq crơng noau cơiq dŏq pỡ án. ");
INSERT INTO bru_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Dũ trỗ ma bữn ŏ́c tampỗr tễ sanốc ntữn, dếh ntroŏq, aséh dễn, cữu, tampâc, tỡ la crơng crớu pứt, cóq dững bar coah ki pỡ ntốq noau sang Yiang Sursĩ. Án ca Yiang Sursĩ atỡng na cũai parchĩn pai lôih, cóq án tu bar pún yỗn cũai ca tỡ bữn lôih. ");
INSERT INTO bru_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Khân cũai aléq roap bán aséh dễn, ntroŏq, cữu, tỡ la charán canŏ́h tễ yớu, ma bữn muoi lám charán ki cuchĩt, tỡ la bớc, tỡ la noau pong tuoiq ma tỡ bữn noau hữm, ");
INSERT INTO bru_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","án ca roap bán charán ki cóq pỡq pỡ ntốq sang Yiang Sursĩ. Cóq án thễ dũan án tỡ bữn tuoiq charán yớu yỗn bán. Khân charán ki tỡ bữn noau tuoiq, cũai ncháu ki chĩuq pứt, cớp án ca roap bán tỡ bữn túh tu. ");
INSERT INTO bru_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ma khân charán ki noau tuoiq, cóq cũai ca roap bán tu práq kia charán ki. ");
INSERT INTO bru_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Khân bữn charán arưih cáp cuchĩt charán án bán, cóq án ca roap bán dững charán ki cỡt tếc yỗn cũai ncháu dáng. Chơ án tỡ bữn túh tu. ");
INSERT INTO bru_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Khân bữn cũai mian charán tễ yớu, ma charán ki cỡt bớc tỡ la cuchĩt bo ncháu tỡ bữn ỡt ngki, cóq cũai mian ki tu ncháu charán. ");
INSERT INTO bru_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ma khân ncháu charán ki ỡt ngki, án ca mian charán ki tỡ bữn túh tu. Khân án mian charán ma noau ễ bữn kia, cóq án yỗn kia ĩn khoiq pruam, ma án tỡ bữn tu, yuaq práq ki cỡt kia charán. ");
INSERT INTO bru_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Khân bữn manoaq samiang phếq thũ cumũr plot, ca tỡ yũah roap voan noau, cóq samiang ki chóq voan, chơ racoâiq. ");
INSERT INTO bru_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ma khân mpoaq án tỡ bữn pruam yỗn án racoâiq cớp samiang ki, cóq samiang ki yỗn práq machớng cớp práq noau chóq voan cumũr plot. ");
INSERT INTO bru_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Chỗi dŏq yỗn tamoong mansễm ca rien parnân; cóq cachĩt chíq án. ");
INSERT INTO bru_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Chỗi dŏq yỗn tamoong cũai ca bếq parnơi cớp charán; cóq cachĩt chíq án. ");
INSERT INTO bru_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Cóq cachĩt chíq cũai aléq ma sang yiang canŏ́h, ca tỡ cỡn cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Chỗi táq túh coat tỡ la padâm cũai tễ cruang canŏ́h. Cóq anhia sanhữ anhia bữm la cũai tễ cruang canŏ́h tê, bo anhia ỡt tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Chỗi táq túh coat máh con cumuiq cán cumai. ");
INSERT INTO bru_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ma khân anhia táq túh coat alới, cứq la Yiang Sursĩ lứq tamứng toâq alới arô sễq yỗn cứq chuai. ");
INSERT INTO bru_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Khân táq ngkíq, cứq cutâu lứq chóq anhia, cớp ễ cachĩt chíq tỗp anhia tâng ntốq rachíl. Chơ lacuoi tỗp anhia cỡt cumai, cớp con anhia cỡt con cumuiq, ŏ́q mpoaq. ");
INSERT INTO bru_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Khân anhia yỗn cũai proai cứq ca cadĩt mian práq, anhia chỗi táq machớng cũai ca yỗn noau voaq; chỗi ĩt lơi tễ cũai cadĩt. ");
INSERT INTO bru_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Khân alới cơiq dỡ au tuar pỡ anhia, cóq anhia culáh loah au tuar ki nhũang moat mandang pât, ");
INSERT INTO bru_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","yuaq au tuar ki la ariang ayỡ yỗn án bữn ngcuam têq sa‑âm. Khân án bếq ma tỡ bữn ntrớu ễ ngcuam, toâq án arô cứq chuai, cứq lứq tamứng, yuaq cứq sarũiq táq. ");
INSERT INTO bru_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Chỗi acrieiq Yiang Sursĩ, cớp chỗi pupap cũai sốt tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Toâq ngư anhia chiau crơng sang yỗn cứq, cóq anhia dững saro, blŏ́ng nho, cớp dỡq nsễng o‑li‑vê. “Cóq anhia chiau sang máh con samiang clúng yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Cớp cóq anhia chiau con ntroŏq cớp con cữu pốh dâu yỗn cứq. Yỗn charán ki ỡt cớp mpiq án tapul tangái, ma toâq tangái tacual cóq anhia chiau sang charán ki yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Tỗp anhia cỡt cũai miar khong cứq. Ngkíq tỗp anhia tỡ têq cha sâiq charán cumáp. Cóq yỗn chíq acho cha. ");
INSERT INTO bru_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Chỗi táq ntỡng ŏ́c tỡ bữn lứq tễ cũai canŏ́h. Cớp chỗi chuai cũai lôih pai ŏ́c tỡ bữn lứq. ");
INSERT INTO bru_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Chỗi pruam cớp cũai clứng toâq alới táq tỡ pĩeiq, tỡ la alới apáh tếc tỡ bữn lứq yỗn pỡ cũai rasữq. ");
INSERT INTO bru_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Chỗi ỡt coah cũai cadĩt choâng moat cũai sữq khân án lôih. ");
INSERT INTO bru_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Khân mới ramóh ntroŏq tỡ la aséh dễn khong cũai par‑ũal anhia pỡ ntốq canŏ́h, cóq anhia dững asuoi loah yỗn ncháu. ");
INSERT INTO bru_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Khân bữn aséh dễn cũai par‑ũal ma dớm yuaq patiang crơng ntâng, cóq acŏ́q chuai. Chỗi pỡq luat. ");
INSERT INTO bru_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Cóq anhia sữq tanoang tapứng toâq cũai cadĩt tayứng yáng moat cũai sữq, machớng cớp cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Chỗi chuaq santoiq pai tỡ bữn lứq tễ cũai canŏ́h. Cớp chỗi cachĩt cũai ca tỡ bữn táq lôih, yuaq cứq ễ yỗn cũai ca táq ngkíq roap tôt. ");
INSERT INTO bru_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Chỗi roap ĩt máh crơng noau sadal, yuaq crơng noau sadal táq yỗn cũai cỡt riang moat sũt chóq ranáq lứq pĩeiq, cớp tapưo chíq parnai cũai tanoang o. ");
INSERT INTO bru_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Chỗi padâm cũai tễ cruang canŏ́h. Anhia dáng samoât lứq nŏ́q toâp cũai ki sâng tâng mứt, yuaq anhia toâp la cũai tễ cruang canŏ́h bo anhia ỡt tâng cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Tâng tapoât cumo cóq anhia trứh cớp chóh dũ ramứh sarnóh, cớp parỗm loah máh palâi. ");
INSERT INTO bru_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ma tâng cumo tapul, cóq anhia chỗi táq tâm cutễq ki, dŏq ngkíq sâng. Ngkíq cũai cadĩt têq ĩt crơng sana tễ cutễq ki, cớp charán arưih têq cha hỡ. Cóq anhia táq machớng ki cớp nưong nho cớp aluang o‑li‑vê. ");
INSERT INTO bru_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Muoi tốn cóq anhia táq ranáq tâng tapoât tangái, ma anhia chỗi táq ranáq ntrớu tâng tangái tapul dŏq ntroŏq cớp aséh dễn anhia têq rlu. Cớp cũai sũl, dếh cũai tễ cruang canŏ́h ca táq ranáq yỗn anhia bữn rlu tê. ");
INSERT INTO bru_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Cóq anhia trĩh dũ ŏ́c cứq la Yiang Sursĩ khoiq atỡng anhia. Chỗi câu sễq tễ yiang canŏ́h, cớp chỗi arô dếh ramứh yiang ki. ");
INSERT INTO bru_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Cóq anhia ỡn chỡ cha pêl bũi muoi cumo pái trỗ dŏq yám noap cứq. ");
INSERT INTO bru_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tâng casâi Abip, la casâi tỗp anhia khoiq loŏh tễ cruang Ê-yip-tô, cóq anhia táq rit cha bũi Tangái Cha Bễng Mi Ŏ́q Crơng Pluoih ĩn cứq khoiq patâp dŏq. Nheq tâng tapul tangái anhia chỗi cha bễng mi cỡt pluoih. “Chỗi toâq sang toam cứq khân tỡ bữn dững crơng chiau sang. ");
INSERT INTO bru_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Toâq anhia mbỡiq ĩt máh palâi tễ sarnóh, cóq anhia táq rit cha bũi Tangái Susot. “Toâq moâm nheq anhia parỗm máh palâi tễ sarnóh, cóq anhia táq rit cha bũi Tangái Chóh Nloâh. ");
INSERT INTO bru_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Cu cumo tâng pái trỗ cha bũi nâi cóq dũ náq samiang toâq sang toam cứq la Yiang Sursĩ Ncháu Nheq Tữh Cũai. ");
INSERT INTO bru_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Chỗi chiau sang bễng mi bữn crơng pluoih toâq anhia chiau sang charán yỗn cứq. Nsễng tễ charán anhia chiau sang cứq tâng pái trỗ cha bũi ki, chỗi dŏq toau toâq tarưp parnỡ. ");
INSERT INTO bru_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Cu cumo cóq anhia dững pỡ dống sang Yiang Sursĩ, la Ncháu anhia, máh palâi sarnóh anhia ĩt dâu lứq. “Chỗi ớp sâiq cữu con tỡ la mbễq con tâng dỡq tóh mpiq án bữm. ");
INSERT INTO bru_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Cứq ớn ranễng cứq tễ paloŏng pỡq nhũang yỗn bán curiaq tỗp anhia tâng rana, cớp dững asuoi tỗp anhia chu ntốq cứq khoiq thrũan dŏq. ");
INSERT INTO bru_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Cóq anhia tamứng cớp trĩh ranễng ki. Chỗi lớn-sarlớn chóq án, yuaq cứq toâp ớn án toâq. Khân anhia chíl án, ki án tỡ bữn táh lôih anhia táq. ");
INSERT INTO bru_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ma khân tỗp anhia trĩh án cớp táq puai dũ ŏ́c cứq atỡng anhia, cứq ễ chíl cũai par‑ũal chuai tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ranễng cứq lứq pỡq nhũang anhia mut tâng cruang Amô-rit, Hêt, Pê-rasit, Cana-an, Hê-vit, cớp Yê-but. Cứq ễ pupứt nheq tỗp alới. ");
INSERT INTO bru_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Chỗi cucốh sang yiang alới, tỡ la puai rit sang alới. Cóq anhia talốh rup yiang alới cớp pieih táh nheq máh tanũl tamáu alới sang. ");
INSERT INTO bru_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Khân anhia sang toam cứq la Yiang Sursĩ, Ncháu anhia, cứq ễ satốh ŏ́c bốn yỗn anhia bữn sana cha, dỡq nguaiq, cớp yỗn anhia vớt tễ ŏ́c a‑ĩ tacóh dũ ramứh. ");
INSERT INTO bru_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Cớp tâng cruang anhia tỡ bữn noâng mansễm aléq ma bỗr talốh, tỡ la cũt. Lứq samoât, cứq yỗn anhia bữn ỡt cóng tamoong dũn. ");
INSERT INTO bru_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Cứq lứq táq chóq cũai rachíl cớp anhia cỡt ngcŏh cứq. Cứq táq yỗn dũ cruang ca rachíl anhia cỡt clŏ́c clu. Cớp cứq táq chóq cũai par‑ũal yỗn alới carlũn lúh chễr nheq. ");
INSERT INTO bru_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Cứq ễ táq chóq máh cũai par‑ũal anhia cỡt pláh chap nheq. Cứq tuih aloŏh nheq tỗp Hê-vit, Cana-an, cớp Hêt yỗn alới loŏh bo anhia cheq ễ toâq. ");
INSERT INTO bru_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Cứq tỡ bữn tuih alới tâng muoi cumo sâng. Khân cứq táq ngkíq, cruang cutễq ki cỡt rangual. Chơ charán cruang rứh sa‑ữi lứq dŏq yỗn anhia tỡ têq ỡt. ");
INSERT INTO bru_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ngkíq, cứq tuih aloŏh alới chữ bĩq chữ bĩq toau anhia cỡt rứh sa‑ữi têq ndỡm cutễq ki. ");
INSERT INTO bru_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Cứq ễ táq raloan cutễq yỗn anhia ndỡm tễ dỡq mưt Cusâu toau toâq dỡq mưt Mê-di-tarian, cớp tễ ntốq aiq toau toâq crỗng Ơ-phơ-rat. Cứq ễ táq yỗn anhia bữn chớc hỡn tễ cũai cruang ki, cớp têq anhia tuih aloŏh alới bo anhia cheq ễ mut. ");
INSERT INTO bru_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Chỗi táq tếc parkhán cớp alới, tỡ la cớp yiang alới sang. ");
INSERT INTO bru_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Chỗi yỗn alới ỡt tâng cruang anhia; khân anhia yỗn, alới lứq radững anhia táq ranáq lôih chóq cứq. Khân anhia sang yiang alới, nâi la machớng anhia chuat tâng acáp.” ");
INSERT INTO bru_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới cớp Arôn chỗn pỡ cóh toâq pỡ cứq, dếh Nadap, Abi-hu, cớp tapul chít náq cũai thâu bữn chớc tâng tỗp I-sarel hỡ. Bo anhia noâng tễ yơng, cóq anhia cucốh sang toam. ");
INSERT INTO bru_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ống manoaq mới sâng têq toâq cheq cứq. Máh cũai proai tỡ têq chỗn tâng cóh.” ");
INSERT INTO bru_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moâm Môi-se pỡq ruaih loah yỗn cũai proai dáng tễ phễp rit Yiang Sursĩ cớp santoiq án ớn, chơ alới ta‑ỡi muoi prớh neq: “Nheq tữh tỗp hếq pruam táq dũ ramứh Yiang Sursĩ khoiq atỡng.” ");
INSERT INTO bru_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Chơ Môi-se chĩc dŏq dũ ramứh Yiang Sursĩ khoiq ớn. Tarưp parnỡ tễ cláih Môi-se táq muoi lám prông cheq yững cóh. Cớp án patứng muoi chít la bar cốc tamáu, muoi cốc yỗn muoi tỗp cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Vớt ki, án ớn máh cũai póng I-sarel pỡq bốh ntroŏq tangcáh chiau sang yỗn Yiang Sursĩ, dếh ntroŏq chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Môi-se ĩt tadĩ aham máh charán noau kiac chiau sang, chơ chóq tâng máh cuban. Ma tadĩ ễn, án trutrếh tâng prông. ");
INSERT INTO bru_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Chơ án ĩt Tâm Saráq Parkhán ca án khoiq chĩc chơ máh parnai Yiang Sursĩ khoiq atỡng, cớp án doc loah na sưong casang yỗn dũ náq cũai tamứng. Nheq tữh cũai ki ta‑ỡi neq: “Tỗp hếq ễ trĩh Yiang Sursĩ cớp táq puai dũ ramứh án khoiq patâp.” ");
INSERT INTO bru_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Chơ Môi-se ĩt aham tễ máh cuban ki, cớp bo án trutrếh chu cũai proai, án pai neq: “Aham nâi cỡt tếc la Yiang Sursĩ khoiq parkhán cớp anhia toâq án yỗn anhia bữn dũ ŏ́c patâp nâi.” ");
INSERT INTO bru_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Chơ Môi-se, Arôn, Nadap, Abi-hu, cớp tapul chít náq cũai thâu bữn chớc tâng tỗp I-sarel chỗn parnơi pỡ cóh ki. ");
INSERT INTO bru_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Cớp tỗp alới hữm Yiang Sursĩ cũai I-sarel sang. Pưn talang ayững Yiang Sursĩ bữn ariang nchŏh noau sữn toâq tamáu santứm satong. Noau dŏq ramứh tamáu ki la sapĩr. ");
INSERT INTO bru_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yiang Sursĩ tỡ bữn táq ntrớu chóq máh cũai samiang ca sốt tỗp I-sarel. Alới bữn hữm Yiang Sursĩ, ma noâng alới tỡ bữn pân ntrớu. Chơ alới bữn cha nguaiq parnơi cớp yớu alới. ");
INSERT INTO bru_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới chỗn ramóh cứq pỡ anũol cóh. Bo mới ỡt pỡ ki, cứq ễ chiau yỗn mới bar khlễc tamáu cứq khoiq chĩc máh phễp rit cớp ŏ́c patâp yỗn mới atỡng cũai proai.” ");
INSERT INTO bru_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Chơ Môi-se cớp Yô-sũa, cũai chuai ranáq yỗn Môi-se, alới thrũan pỡq. Cớp Môi-se mbỡiq chỗn pỡ cóh Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nhũang Môi-se ễ pỡq án atỡng cũai sốt máh cũai proai neq: “Cóq anhia ỡt acoan tâng ntốq nâi toau hếq chu loah pỡ anhia. Arôn cớp Hơr ỡt nâi cớp anhia; khân bữn cũai aléq ralỗih, têq alới bar náq parchĩn chuai.” ");
INSERT INTO bru_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Toâq Môi-se chỗn pỡ anũol cóh, bữn ramứl clũom nheq cóh ki. ");
INSERT INTO bru_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Ang‑ữr tễ Yiang Sursĩ claq asễng tâng cóh Si-nai. Toâq tỗp I-sarel nhêng chu cóh, alới hữm poang ki machớng pla ũih blữ tâng anũol cóh. Bữn ramứl clũom cóh ki nheq tapoât tangái. Chơ tâng tangái tapul Yiang Sursĩ arô Môi-se tễ ramứl ki. ");
INSERT INTO bru_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Chơ Môi-se chỗn chu anũol cóh cớp mut tâng ramứl. Án ỡt ngki nheq pỗn chít tangái pỗn chít sadâu. ");
INSERT INTO bru_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Chơ Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Cóq mới atỡng cũai I-sarel dững crơng chiau sang yỗn cứq, tam alới sâng yoc. Cóq mới roap máh crơng ki yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Máh crơng alới cóq chiau sang bữn neq: Yễng, práq, sapoan; ");
INSERT INTO bru_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","aroâiq busín; cớp aroâiq noau táq toâq sóc cữu santứm satong, ễng, cớp cusâu; cớp aroâiq noau táq toâq sóc mbễq; ");
INSERT INTO bru_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ngcâr cữu tôl yớm santứm cusâu; ngcâr charán languat cớp o; khlễc pian tễ aluang a-casia; ");
INSERT INTO bru_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","dỡq nsễng o‑li‑vê dŏq chóq tâng chớp tớu; crơng phuom noau carchốc cớp dỡq nsễng dŏq atia cớp dŏq tacât yỗn phuom; ");
INSERT INTO bru_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","tamáu moat noau dŏq o-nic, dếh tamáu moat canŏ́h noau chóq tâng aroâiq ê-phot, cớp aroâiq sadal apơm alễu pỡng ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Máh cũai proai cóq táq Dống Sang Aroâiq yỗn cứq, dŏq cứq têq ỡt mpứng dĩ tỗp alới. ");
INSERT INTO bru_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Cóq alới táq dống ki cớp dũ ramứh tâng clống dống ki yỗn pĩeiq máh cứq ễ apáh mới sanua. ");
INSERT INTO bru_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Cóq mới táq muoi lám hĩp toâq aluang a-casia, cuti bar coat tadĩ, la‑a muoi coat tadĩ, cớp sarỡih muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tâng clống cớp yáng tiah hĩp cóq mới blom toâq yễng muoi chít, cớp táq racoam hĩp ki toâq yễng tê. ");
INSERT INTO bru_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Cóq mới tooc pỗn cutũr toâq yễng cớp atớt tâng pỗn ntốq ayững hĩp ki, muoi coah bar cutũr dŏq ien crang hĩp. ");
INSERT INTO bru_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Cóq mới táq bar lám tong toâq aluang a-casia, cớp blom toâq yễng. ");
INSERT INTO bru_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Cóq mới taróc tong ki tâng bar coah cutũr hĩp. ");
INSERT INTO bru_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Cóq taróc dŏq loâng tong tâng hĩp ki, chỗi bóc aloŏh noâng. ");
INSERT INTO bru_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Chơ cóq mới amut tâng hĩp bar khlễc tamáu cứq yỗn mới. Tâng tamáu ki cứq khoiq chĩc dŏq máh ŏ́c patâp. ");
INSERT INTO bru_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Cóq mới táq cantứp hĩp toâq yễng muoi chít, cuti bar coat tadĩ cớp la‑a muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Cóq mới tooc yễng táq bar lám chê-rup, ");
INSERT INTO bru_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","cớp bar lám chê-rup chóq tâng bar pứp hĩp ki, táq yỗn chê-rup cỡt muoi sâiq cớp cantứp hĩp. ");
INSERT INTO bru_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cóq yỗn bar lám chê-rup ki ỡt rato moat paliang khlap yỗn cadớp cantứp hĩp. ");
INSERT INTO bru_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Cóq mới ĩt bar khlễc tamáu cứq ễ yỗn mới, amut dŏq tâng clống hĩp, chơ catứp. ");
INSERT INTO bru_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Tâng pỡng cantứp ki bân mpứng dĩ bar lám chê-rup, cứq ễ ramóh mới cớp yỗn mới bữn dũ ŏ́c cứq patâp cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Cóq mới táq muoi lám cachơng toâq aluang a-casia, cuti bar coat, la‑a muoi coat, cớp sarỡih muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Cóq mới blom cachơng ki toâq yễng muoi chít, cớp táq racoam cachơng ki toâq yễng tê. ");
INSERT INTO bru_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Cớp cóq mới táq paning toâq yễng sarỡih máh cứm pỗn chũop nheq cachơng ki, chơ táq racoam toâq yễng tâng paning ki hỡ. ");
INSERT INTO bru_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Cóq mới táq pỗn carvang toâq yễng cớp chóq carvang ki tâng pỗn pứp bân ayững cachơng dŏq crang. ");
INSERT INTO bru_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Cóq chóq carvang ki cheq racoam ien taróc cantrang ễ crang. ");
INSERT INTO bru_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Cóq mới táq bar ntreh cantrang toâq aluang a-casia dŏq crang cachơng, cớp blom toâq yễng cantrang ki. ");
INSERT INTO bru_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Cóq mới táq tangan savan cớp tangan chễn, dếh khang cớt cớp cuban dŏq tadỡng toâq hĩng blŏ́ng nho chiau sang yỗn Yiang Sursĩ. Crơng ki táq nheq toâq yễng muoi chít. ");
INSERT INTO bru_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Cóq mới dŏq cachơng ki yáng moat Hĩp Parnai Parkhán, cớp tâng pỡng cachơng cóq mới dŏq bễng mi chiau sang yỗn cứq. Tâng cachơng ki cóq bữn níc bễng. ");
INSERT INTO bru_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Cóq mới táq muoi lám rông khễ dŏq máh chớp tớu; nheq ramứh ki cóq táq toâq yễng muoi chít. Cóq mới tooc ayững cớp tỗ rông ki, cớp tooc rup piar rabỗn cớp paliang tâng tỗ rông ki. Ma nheq ramứh ki cóq mới táq yỗn cỡt muoi sâiq sâng. ");
INSERT INTO bru_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Rông ki cóq bữn tapoât tŏ́ng, muoi coah pái tŏ́ng. ");
INSERT INTO bru_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Dũ tŏ́ng cóq tooc pái lám rup piar noau dŏq al-mon, dếh rabỗn cớp paliang. ");
INSERT INTO bru_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Tâng tỗ rông ki cóq mới tooc pỗn lám piar al-mon, dếh rabỗn cớp paliang. ");
INSERT INTO bru_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Cóq bữn rup piar rabỗn ỡt pưn dũ cáp tŏ́ng ki. ");
INSERT INTO bru_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Máh piar rabỗn, máh tŏ́ng, cớp tỗ rông cóq mới tooc toâq yễng muoi chít yỗn cỡt muoi sâiq. ");
INSERT INTO bru_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Cóq mới táq tapul lám chớp tớu dŏq tâng rông ki, ma chớp tớu ki cóq claq chu moat. ");
INSERT INTO bru_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Cóq mới táq tangcáp takĩap ruaiq chớp tớu, cớp táq tapuang tadỡng raloiq ruaiq tớu. Cóq táq nheq ramứh ki toâq yễng muoi chít. ");
INSERT INTO bru_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Cóq mới ĩt pái chít la sỡng ki-lô yễng muoi chít, chơ táq rông tớu dếh dũ ramứh radỡng. ");
INSERT INTO bru_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ma cóq mới táq yỗn samoât máh cứq apáh yỗn mới hữm tâng cóh nâi sanua. ");
INSERT INTO bru_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Táq Dống Sang Aroâiq toâq aroâiq busín o lứq muoi chít ploah, cớp tan carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu. Cóq chún yỗn o máh rup chê-rup tâng aroâiq ki. ");
INSERT INTO bru_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ma aroâiq dũ ploah cóq li nheq, cuti bar chít tacual coat, la‑a pỗn coat. ");
INSERT INTO bru_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cóq yĩh aroâiq sỡng ploah patĩng parnơi yỗn cỡt muoi ploah sâng, cớp sỡng ploah ễn cóq yĩh machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Cóq yĩh máh cutũr toâq aroâiq santứm satong tâng chễu bar ploah aroâiq la‑a ki. ");
INSERT INTO bru_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Cóq yĩh sỡng chít lám cutũr tâng aroâiq ễ yoang dâu lứq; chơ sỡng chít lám cutũr ễn yĩh tâng aroâiq ploah bar ễ yoang ntun. Nheq cutũr ki cóq ỡt choâng-rachoâng. ");
INSERT INTO bru_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Chơ táq canŏ́q yễng sỡng chít lám dŏq ien cŏ́q tâng cutũr aroâiq bar ploah toâr ki, chơ aroâiq ki cỡt máh muoi ploah sâng. ");
INSERT INTO bru_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Cóq táq aroâiq dŏq acrúq Dống Sang Aroâiq, muoi chít la muoi ploah aroâiq tan toâq sóc mbễq. ");
INSERT INTO bru_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dũ ploah cóq táq machớng nheq, cuti pái chít coat, la‑a pỗn coat. ");
INSERT INTO bru_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Yĩh patĩng parnơi aroâiq sỡng ploah, chơ yĩh patĩng parnơi tapoât ploah canŏ́h ễn. Ma ploah tapoât cóq calâp loah yoah moat Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Cóq yĩh sỡng chít lám cutũr chóq tâng chễu aroâiq parsốt ploah muoi, cớp yĩh sỡng chít lám cutũr ễn chóq tâng chễu aroâiq parsốt ploah bar. ");
INSERT INTO bru_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Chơ cóq táq sỡng chít canŏ́q sapoan dŏq cŏ́q bar ploah aroâiq ki, yỗn partĩng parnơi cỡt aroâiq cutrúq muoi ploah sâng. ");
INSERT INTO bru_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Chơ aroâiq tadĩ ploah ca clữi, ki alứr yáng clĩ Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ma án ca noâng clữi muoi coat tâng bar coah, cóq alứr cutrúq Dống Sang Aroâiq ki. ");
INSERT INTO bru_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Cóq táq cantrúq bar ploah ễn, ploah muoi toâq ngcâr cữu tôl yớm santứm cusâu. Ploah bar táq toâq ngcâr charán languat o dŏq cutrúq yáng tiah. ");
INSERT INTO bru_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Cóq táq máh khuon Dống Sang Aroâiq toâq aluang a-casia, patứng yỗn tanoang. ");
INSERT INTO bru_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dũ khuon sarỡih muoi chít coat, cớp la‑a muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Chơ aloap ayững khuon chóq tâng crơng rayống yỗn ratớt parnơi. Dũ khuon cóq aloap ngkíq nheq. ");
INSERT INTO bru_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Cóq táq bar chít khuon, coah angia pưn, ");
INSERT INTO bru_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","cớp táq crơng rayống ayững khuon toâq práq pỗn chít lám, dŏq aloap ayững khuon, bar lám muoi khuon. ");
INSERT INTO bru_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Cóq táq bar chít khuon dŏq yoah angia pỡng tâng Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","cớp pỗn chít crơng rayống ayững toâq práq, bar lám aloap tâng muoi khuon. ");
INSERT INTO bru_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ma yoah clĩ Dống Sang Aroâiq, yáng angia mandang pât cóq táq tapoât khuon, ");
INSERT INTO bru_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ma bar khuon dŏq táq soq Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ma khuon táq soq cóq patĩng parnơi tễ pưn toau toâq pỡ pỡng. Chơ bar lám soq khuon cóq táq ariang pai nâi. ");
INSERT INTO bru_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ngkíq toâq amóh parnơi cỡt khuon Dống Sang Aroâiq tacual khuon, cớp bữn crơng rayống ayững táq toâq práq muoi chít tapoât lám, dũ khuon bữn bar lám crơng rayống ayững. ");
INSERT INTO bru_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Cóq ĩt aluang a-casia táq prang toar muoi chít la sỡng ntreh. Aluang prang toar sỡng ntreh ki dŏq coah angia pỡng. ");
INSERT INTO bru_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Prang toar sỡng ntreh ễn dŏq coah angia pưn, cớp sỡng ntreh ễn dŏq yoah clĩ Dống Sang Aroâiq yáng angia mandang pât. ");
INSERT INTO bru_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ma bar ntreh prang toar ỡt mpứng dĩ bar coah, cóq alor tễ pứp nâi chu pứp ki. ");
INSERT INTO bru_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Cóq blom khuon cớp táq carvang toâq yễng, dŏq aloap prang toar parnơi yỗn khâm. Ma prang ki cóq blom toâq yễng tê. ");
INSERT INTO bru_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Cóq patứng Dống Sang Aroâiq yỗn pĩeiq máh cứq khoiq apáh yỗn mới hữm pỡ cóh nâi. ");
INSERT INTO bru_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Cóq tan muoi ploah aroâiq catáng toâq priei busín o carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu. Chơ chún máh rup chê-rup tâng aroâiq ki. ");
INSERT INTO bru_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Cóq ayŏ́ng dŏq aroâiq catáng ki, na cŏ́q tâng tanũl aluang a-casia, pỗn tanũl ca blom toâq yễng cớp patứng tâng crơng rayống ayững táq toâq práq. ");
INSERT INTO bru_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Cóq ĩt canŏ́q cŏ́q aroâiq catáng, chơ cŏ́q tâng prang póc yỗn aroâiq ki paliang asễng. Chơ achúh dŏq Hĩp Parnai Parkhán ca bữn bar khlễc tamáu yoah clĩ aroâiq catáng ki. Aroâiq catáng ki táq sangcứt yỗn cỡt bar clống, la Ntốq Tễng Rit cớp Ntốq Cứq Ỡt. ");
INSERT INTO bru_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Cóq ĩt cantứp chơ catứp dŏq Hĩp Parnai Parkhán ki. ");
INSERT INTO bru_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Yáng tiah Ntốq Cứq Ỡt, cóq dŏq cachơng yoah angia pỡng, cớp dŏq rông tớu yoah angia pưn. ");
INSERT INTO bru_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Bân ngoah mut tâng clống Dống Sang Aroâiq cóq táq aroâiq catáng toâq aroâiq busín o carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu, dếh chún hỡ. ");
INSERT INTO bru_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ma aroâiq catáng ki cóq táq sỡng tanũl toâq aluang a-casia. Dũ ntreh tanũl cóq blom toâq yễng, cớp bữn canŏ́q dŏq cŏ́q aroâiq catáng. Cớp tooc crơng rayống ayững tanũl toâq sapoan dŏq achúh tanũl. ");
INSERT INTO bru_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Cóq táq prông sang toâq aluang a-casia. Pỗn coah prông ki cóq táq lĩ-ralĩ nheq: Cuti sỡng coat, la‑a sỡng coat, cớp sarỡih pái coat. ");
INSERT INTO bru_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Cóq táq rup tacoi chóq tâng pỗn ntốq nhoq, cớp táq rup ki cỡt muoi sâiq cớp prông sang. Cóq blom prông ki toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Cóq táq radỡng ien chóq bŏ́h, táq sán, tangan, canŏ́q, cớp radỡng dŏq rahững ũih. Máh crơng nâi cóq táq toâq sapoan nheq. ");
INSERT INTO bru_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Cóq táq muoi khlễc sapoan hỡng ĩn sara chóq tâng prông. Cớp cóq tooc carvang toâq sapoan tâng dũ nhoq crơng ki. ");
INSERT INTO bru_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Cóq chóq khlễc ki coah pưn racoam prông, cớp ayŏ́ng yỗn ỡt dĩ ria tâng mpứng dĩ prông sang. ");
INSERT INTO bru_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Cóq táq cantrang toâq aluang a-casia, ien crang prông, cớp blom toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Moâm ki, cóq taróc cantrang ki chóq tâng carvang ca ỡt bar coah prông ien crang. ");
INSERT INTO bru_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Cóq táq prông toâq pian, ma tâng mpứng dĩ prông cóq bữn taroong ĩn cứq khoiq apáh yỗn mới hữm pỡ cóh ki. ");
INSERT INTO bru_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Tâng Dống Sang Aroâiq cóq bữn nchŏh dŏq rôm sang. Mpễr ntốq ki noau yoang aroâiq táq toâq aroâiq busín o. Aroâiq yoang coah angia pưn cuti muoi culám coat; ");
INSERT INTO bru_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","cớp bữn tanũl sapoan bar chít ntreh ca bữn canŏ́q cớp tong ca bữn coom práq. Cớp bữn bar chít crơng rayống ayững táq toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Coah angia pỡng nchŏh cóq táq machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Coah angia mandang pât cóq bữn aroâiq catáng cuti sỡng chít coat, bữn tanũl muoi chít ntreh, cớp muoi chít lám crơng rayống ayững hỡ. ");
INSERT INTO bru_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Aroâiq catáng lavíng coah angia mandang loŏh cóq la‑a sỡng chít coat tê. ");
INSERT INTO bru_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Dũ coah ngoah toong mut, cóq bữn aroâiq catáng muoi chít la sỡng coat, tanũl pái ntreh, cớp crơng rayống ayững pái lám. ");
INSERT INTO bru_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ngoah toong mut chu nchŏh bân ntốq rôm sang cóq bữn aroâiq catáng ca táq toâq priei busín bar chít coat, tan carchốc cớp sóc cữu santứm satong, santứm ễng, cớp santứm cusâu dếh chún hỡ. Cóq bữn pỗn ntreh tanũl dŏq ien yoang aroâiq catáng, cớp cóq bữn crơng rayống ayững pỗn lám. ");
INSERT INTO bru_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Aluang ca casĩc cutũr aroâiq catáng cóq abác tâng dũ ntreh tanũl lavíng nchŏh dống sang. Cớp cóq bữn coom cớp canŏ́q táq toâq práq, ma crơng rayống ayững tanũl cóq táq toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Cóq táq nchŏh dŏq rôm sang cuti muoi culám coat, la‑a sỡng chít coat, cớp sarỡih sỡng coat. Aroâiq ca yoang cóq táq toâq priei busín o. Cớp crơng rayống ayững tanũl cóq táq toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Máh crơng radỡng tâng Dống Sang Aroâiq, dếh lác téh yỗn khâm cớp lác téh lavíng nheq ntốq rôm cóq táq toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Cóq ớn máh cũai proai I-sarel yỗn alới dững dỡq nsễng o‑li‑vê o lứq chóq tâng chớp tớu, khễ tacât toâq sadâu yỗn cỡt poang. ");
INSERT INTO bru_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Cóq Arôn cớp tỗp con samiang án kĩaq yỗn o chớp tớu ca tacât yáng tiah aroâiq catáng bân Ntốq Cứq Ỡt, la ntốq bữn Hĩp Parnai Parkhán. Cóq alới tacât chớp tớu choâng moat cứq, tễ plỡ tabữ toau toâq poang tarưp. Tỗp I-sarel cớp nheq tŏ́ng toiq alới cóq táq puai yỗn samoât máh ŏ́c patâp ki toau dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Cóq arô Arôn ai mới, cớp tỗp con samiang án toâq pỡ nâi, la Nadap, Abi-hu, E-lia-sơ, cớp I-thamar. Cóq alới yoah ỡt miar tễ cũai proai I-sarel, dŏq alới táq ranáq cứq puai chớc cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Cóq táq tampâc yỗn Arôn ai mới, cỡt tếc chớc án sốt tỗp tễng rit sang; cóq táq tampâc ki dŏq noau canŏ́h yám noap Arôn. ");
INSERT INTO bru_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Cóq arô nheq náq cũai chiang, alới ca cứq khoiq yỗn bữn ŏ́c khễuq táq tampâc, cớp atỡng alới táq tampâc yỗn Arôn dŏq án chiau sang dỡi tamoong án táq ranáq cứq na cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Atỡng tỗp alới táq neq: Aroâiq ê-phot cớp aroâiq sadal apơm ca alễu pỡng ê-phot, au tuar ŏ́q atĩ, au tuar bữn atĩ sa‑ữi santứm, khán-cỡn, cớp aroâiq catoân ngkĩng. Cóq alới táq crơng nâi yỗn Arôn ai mới, cớp yỗn tỗp con samiang án dŏq alới táq ranáq cứq na cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Cóq yỗn cũai chiang ki ĩt priei busín o carchốc cớp sóc cữu santứm satong, ễng, cusâu, cớp dai yễng, dŏq táq máh crơng ki. ");
INSERT INTO bru_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Cóq alới táq aroâiq ê-phot toâq priei busín o carchốc cớp sóc cữu santứm satong, ễng, cusâu, cớp dai yễng, dếh chún. ");
INSERT INTO bru_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Cóq yĩh bar mễng aroâiq bân apal ê-phot, dŏq chŏ́q bar coah cớp au ki. ");
INSERT INTO bru_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ma aroâiq cantoân ngkĩng, cóq ĩt aroâiq busín o, cớp táq sanŏ́q aroâiq ê-phot ki tê; chơ yĩh ratớt cớp ê-phot yỗn cỡt muoi sâiq sâng. ");
INSERT INTO bru_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Cóq ĩt bar ŏ́c tamáu ngoaih o-nic, cớp tốc chĩc tâng tamáu ki máh ramứh muoi chít la bar náq con samiang Yacốp. ");
INSERT INTO bru_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Puai tangái alới canỡt, tốc tapoât ramứh cũai canỡt nhũang tâng tamáu muoi, cớp tốc tapoât ramứh cũai canỡt ntun tâng tamáu bar. ");
INSERT INTO bru_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Yỗn cũai chiang khễuq tốc dŏq máh ramứh muoi chít la bar náq con samiang Yacốp chóq tâng bar ŏ́c tamáu ki, chơ chóq tâng rabŏ́c yễng. ");
INSERT INTO bru_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Bar ŏ́c tamáu ca atỡng tễ muoi chít la bar tỗp cũai I-sarel, cóq atớt tâng aroâiq ê-phot bân apal. Cỗ tễ ranáq nâi, Arôn ma chóq ramứh alới dŏq tâng apal án bữm, dŏq cỡt tếc cứq la Yiang Sursĩ sanhữ níc tễ máh cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Cóq táq bar lám rabŏ́c yễng; ");
INSERT INTO bru_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","cớp táq bar ntreh sanoâc yễng rapĩal parnơi cỡt ariang samữ carsán; cớp atớt tâng rabŏ́c yễng. ");
INSERT INTO bru_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Cóq táq aroâiq sadal apơm dŏq alễu pỡng aroâiq ê-phot yỗn cũai ca sốt tễ rit sang tâc toâq án chuaq yoc ễ dáng ntrớu Yiang Sursĩ yỗn táq. Cóq táq aroâiq ki machớng aroâiq ê-phot tê, la táq toâq priei busín o carchốc cớp sóc cữu santứm satong, ễng, cusâu, dai yễng, chơ pasang machớng ê-phot tê. ");
INSERT INTO bru_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ma máh aroâiq sadal apơm, cóq táq pỗn pứp lĩ-ralĩ, dũ coah muoi satia, chơ calâp bân mpứng dĩ. ");
INSERT INTO bru_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Moâm ki patoi tamáu ngoaih cacoan cỡt pỗn rana tâng aroâiq sadal apơm neq: Rana muoi chóq tamáu moat ramứh rubi, tupat, cớp barũl. ");
INSERT INTO bru_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Rana bar chóq tamáu moat ramứh samar-danô, sapĩr, cớp kim-cưong. ");
INSERT INTO bru_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Rana pái chóq tamáu moat ramứh hua-kin, sar-danuc, cớp amễt. ");
INSERT INTO bru_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Rana pỗn chóq tamáu moat lứq ramứh cru-salit, o-nic, cớp yat-pít. Nheq tữh tamáu ki cóq chóq tâng rabŏ́c yễng. ");
INSERT INTO bru_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Muoi chít la bar thữ tamáu nâi cóq tốc chĩc dŏq máh ramứh con samiang Yacốp, muoi ŏ́c tamáu chóq muoi ramứh, dŏq atỡng tễ muoi chít la bar tỗp cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Cóq táq sanoâc toâq yễng muoi chít, bar ntreh rapĩal parnơi ariang samữ carsán. ");
INSERT INTO bru_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Cóq táq carvang yễng bar carvang, cớp chŏ́q tâng bar coah aroâiq sadal apơm yoah pỡng, ");
INSERT INTO bru_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","dếh chŏ́q bar ntreh sanoâc yễng ki tâng bar coah carvang yoah pỡng. ");
INSERT INTO bru_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Cớp pứp sanoâc yễng muoi coah ễn cóq atớt tâng bar rabŏ́c tâng apal aroâiq ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Cóq táq bar carvang yễng, chơ chŏ́q yỗn cỡt cutũr yoah pưn aroâiq sadal apơm ma coah clống yỗn ratớt cớp aroâiq ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Cóq táq bar carvang yễng ễn, chơ chŏ́q atớt tâng ê-phot cheq santih, cớp coah pỡng parnoân. ");
INSERT INTO bru_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Chŏ́q carvang tâng aroâiq sadal apơm amóh parnơi cớp carvang ê-phot toâq samữ santứm satong, dŏq yỗn aroâiq sadal apơm ratớt pỡng parnoân, táq yỗn án tỡ bữn sarléh. ");
INSERT INTO bru_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Toâq Arôn mut chu Ntốq Tễng Rit, án cóq alễu tâng apơm aroâiq noau tốc máh ramứh tỗp I-sarel, dŏq cỡt tếc cứq la Yiang Sursĩ, sanhữ níc cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Cóq chóq Urim cớp Thumim tâng aroâiq sadal apơm Arôn. Toâq án mut ễ ramóh cứq, cóq án alễu aroâiq ki tâng apơm, dŏq án têq dáng raloaih máh ŏ́c cứq yoc cũai I-sarel táq. ");
INSERT INTO bru_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Au tuar cuti tỡ bữn atĩ ca sớp pưn aroâiq ê-phot, cóq táq toâq aroâiq sóc cữu santứm satong nheq ploah ki. ");
INSERT INTO bru_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Cóq yĩh au nhưt. Chơ patĩng tacong cớp aroâiq cubân dŏq án tỡ bữn chái raháq. ");
INSERT INTO bru_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Tâng chễu au tuar cóq chún rup palâi ỗiq-tâi toâq priei sóc cữu santứm satong, ễng, cớp cusâu. Cớp rup palâi nâi, cóq yĩh carlán cớp ariu yễng. ");
INSERT INTO bru_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Arôn cóq sớp au tuar ki bo án táq ranáq tễng rit sang. Toâq án mut tâng Ntốq Tễng Rit choâng moat cứq, tỡ la loŏh tễ ki, ariu ki bữr dŏq dáng án tỡ bữn cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Cóq táq crơng pasang toâq yễng muoi chít, cớp tốc tâng crơng ki neq: ‘Chiau Sang Yỗn Yiang Sursĩ.’ ");
INSERT INTO bru_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Cóq chŏ́q crơng pasang ki toâq samữ santứm satong atớt yáng moat khán-cỡn. ");
INSERT INTO bru_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Arôn cóq tâc níc crơng pasang ki tâng caliac án. Táq ngkíq, cỡt tếc apáh án roap nheq máh lôih tễ crơng cũai proai I-sarel dững chiau sang. Crơng pasang ki cóq ỡt níc tâng caliac Arôn dŏq cứq la Yiang Sursĩ roap ĩt máh crơng alới chiau sang. ");
INSERT INTO bru_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Cóq tan au tuar bữn atĩ cớp khán-cỡn yỗn Arôn toâq aroâiq busín o. Cớp parnoân la táq machớng ki tê, dếh chún yỗn nêuq o lứq. ");
INSERT INTO bru_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Cóq táq tampâc yỗn o, dếh au tuar, parnoân, cớp khán-cỡn yỗn con samiang Arôn dŏq tỗp alới bữn chớc cỡt cũai tễng rit sang tê. ");
INSERT INTO bru_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Cóq mới asớp máh tampâc nâi yỗn Arôn ai mới, cớp tỗp con samiang án. Chơ chiau tỗp alới na hĩng dỡq nsễng o‑li‑vê tâng plỡ, yỗn alới bữn táq ranáq cứq puai chớc cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Cóq táq cốn alốt na aroâiq busín yỗn alới, cuti tễ ngkĩng yỗn toâq nlu, dŏq pul cutooq tỗ chác alới. ");
INSERT INTO bru_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Arôn cớp máh con samiang án, cóq dŏ́ng níc cốn alốt toâq alới mut tâng Dống Sang Aroâiq, tỡ la ỡt cheq prông sang dŏq táq ranáq tâng Ntốq Tễng Rit Sang. Cóq táq ngkíq dŏq alới tỡ bữn cuchĩt cỗ tian tỡ bữn pul cutooq tỗ chác. “Arôn cớp dũ dỡi tŏ́ng toiq án cóq táq puai níc phễp rit nâi. ");
INSERT INTO bru_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Nâi la ramứh mới cóq táq tễ ranáq chiau Arôn cớp con samiang án yỗn cỡt cũai tễng rit sang cứq. Cóq ĩt muoi lám con ntroŏq tôl cớp bar lám cữu tôl plot o. ");
INSERT INTO bru_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Cóq ĩt bỗt mi o lứq, cớp táq pái thữ bễng mi ŏ́q crơng pluoih. Muoi thữ táq cớp dỡq nsễng o‑li‑vê. Muoi thữ ễn tỡ bữn carchốc cớp dỡq nsễng o‑li‑vê. Cớp muoi thữ ễn táq bễng mi cada atia dỡq nsễng o‑li‑vê. ");
INSERT INTO bru_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Toâq táq moâm chơ, cóq ĩt máh bễng mi ki chóq tâng crưo; chơ dững chiau sang yỗn cứq bo anhia dững bốh sang ntroŏq tôl cớp bar lám cữu tôl. ");
INSERT INTO bru_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Cóq dững Arôn cớp máh con samiang án toâq pỡ ngoah toong mut pỡ ntốq ramóh cứq, cớp yỗn alới táq puai phễp rit mpơi dỡq dŏq sambráh tỗ chác. ");
INSERT INTO bru_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Toâq alới mpơi dỡq moâm chơ, cóq mới asớp tampâc yỗn Arôn neq: Au tuar bữn atĩ cuti, au tuar ŏ́q atĩ, aroâiq ê-phot, aroâiq sadal apơm, cớp parnoân. ");
INSERT INTO bru_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Cóq apưng khán-cỡn yỗn án, ma yáng moat khán ki cóq chŏ́q crơng pasang yễng noau tốc chĩc neq: ‘Chiau Sang Yỗn Yiang Sursĩ.’ ");
INSERT INTO bru_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Moâm ki mới ĩt dỡq nsễng táq tếc chóh cũai yỗn cỡt cũai tễng rit sang, chơ hĩng tâng plỡ Arôn. ");
INSERT INTO bru_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","9","“Cóq dững máh con samiang Arôn, chơ asớp alới au tuar, chóq parnoân tâng ngkĩng, cớp apưng khán-cỡn tâng plỡ hỡ. Cóq mới táq neq dŏq chóh Arôn cớp máh con samiang án. Alới cớp tŏ́ng toiq alới cóq táq níc ranáq cứq na cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Cóq dững ntroŏq tôl toâq pỡ ngoah toong Dống Sang Aroâiq, chơ atỡng Arôn cớp máh con samiang án toâq satoaq atĩ tâng plỡ ntroŏq tôl ki. ");
INSERT INTO bru_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Moâm ki cóq cachĩt ntroŏq ki bân ngoah toong Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Cóq mới ĩt aham ntroŏq, cớp alốq ndễm atĩ tâng aham, chơ apĩac tâng rup tacoi bân pỗn nhoq tâng prông sang. Ma aham noâng clữi, cóq mới tốh bân pưn prông sang. ");
INSERT INTO bru_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Moâm ki, cóq ĩt nsễng tễ crơng clống, luam lia, cớp bar coah carchễl dếh nsễng tớt tâng ki, chơ bốh nheq tâng prông chiau sang yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ma sâiq, ngcâr, cớp crơng clống cóq bốh yoah tiah vil alới ỡt dỡ. Anâi la ranáq chiau sang dŏq pupứt lôih máh cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Cóq ĩt muoi lám cữu tôl dững yỗn Arôn cớp máh con samiang án satoaq atĩ tâng plỡ charán ki. ");
INSERT INTO bru_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Cóq kiac cữu ki, chơ ĩt aham trutrếh tâng pỗn coah mpễr prông sang. ");
INSERT INTO bru_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Cóq cŏ́h cữu ki cỡt mễng, cớp ariau crơng clống cớp nlu yỗn bráh; chơ ĩt máh crơng ki achúh cớp máh mễng canŏ́h hỡ tâng pỡng plỡ charán ki. ");
INSERT INTO bru_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Chơ bốh nheq mễng cữu ki tâng prông, dŏq cỡt crơng chiau sang yỗn cứq. Hỡi phuom chanchức tễ crơng bốh ki táq yỗn cứq bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Moâm ki cóq mới ĩt cữu tôl muoi lám ễn, cớp atỡng Arôn dếh máh con samiang án satoaq atĩ tâng plỡ cữu ki. ");
INSERT INTO bru_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Chơ kiac cữu ki, cớp ĩt aham dŏq apĩac tâng sala cutũr Arôn coah atoam, dếh cutũr con samiang án hỡ; cớp apĩac chóq tâng ngcứm atĩ cớp ngcứm ayững coah atoam alới. Ma aham clữi, trutrếh tâng pỗn coah mpễr prông sang. ");
INSERT INTO bru_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Cóq ĩt aham muoi pún tễ pỡng prông ki, carchốc cớp dỡq nsễng dốq táq tếc, chơ trutrếh chóq tâng tỗ Arôn cớp máh con samiang án, dếh tâng tampâc alới hỡ. Ngkíq tỗ chác Arôn cớp máh con samiang án, dếh tampâc alới tâc, cỡt crơng chiau sang yỗn cứq nheq. ");
INSERT INTO bru_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Cóq bublac nsễng cữu tôl ki bân soi, bân ntốq pul crơng clống, bân luam lia, cớp bân carchễl; cớp ĩt bar ŏ́c carchễl cớp nlu coah atoam hỡ. ");
INSERT INTO bru_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Chơ ĩt muoi lám bễng mi ŏ́q crơng pluoih tễ crưo noau khoiq dững sang yỗn cứq, la neq: Muoi lám carchốc cớp dỡq nsễng o‑li‑vê, muoi lám tỡ bữn carchốc cớp dỡq nsễng o‑li‑vê, cớp muoi lám bễng cada hỡ. ");
INSERT INTO bru_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Cóq ĩt nheq máh crơng sana nâi chóq tâng atĩ Arôn cớp máh con samiang án. Chơ cóq alới apỗng achỗn dũ ramứh ki chiau sang yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Moâm ki cóq ĩt máh sana ki tễ atĩ alới cớp dững bốh tâng prông sang parnơi cớp crơng khoiq bốh sang chơ, dŏq cỡt crơng sang mpon yỗn cứq. Hỡi phuom chanchức tễ crơng sang ki táq yỗn cứq sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Cóq ĩt sâiq apơm cữu tôl ki apỗng chiau sang yỗn cứq. Chơ sâiq ki cỡt pún mới. ");
INSERT INTO bru_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Toâq chóh cũai tễng rit sang, anhia cóq ĩt sâiq apơm cữu tôl cớp savac nlu dŏq cỡt pún Arôn cớp máh con samiang án; chơ apỗng achỗn sâiq ki dŏq cỡt crơng mpon miar sang yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Nâi la ranáq cứq tỡ bữn ralêq noâng. Bo cũai proai cứq chiau sang dŏq cỡt ratoi, sâiq apơm cớp sâiq nlu cữu tôl cỡt pún cũai tễng rit sang. Nâi la crơng cũai proai sang yỗn cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Toâq Arôn cuchĩt, máh tampâc án dốq tâc cỡt sốt cũai tễng rit sang, cóq chiau tampâc ki pỡ máh con samiang án, dŏq alới ễn ĩt tâc toâq chóh alới yỗn cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Con samiang Arôn ca ễ pláih loah Arôn, án ca têq mut pỡ ntốq ramóh cứq cớp táq ranáq tâng Ntốq Tễng Rit, cóq án sớp tampâc nâi nheq tapul tangái. ");
INSERT INTO bru_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Cóq ĩt sâiq cữu tôl noau táq bo chóh Arôn cớp máh con samiang án, dững ớp bân Ntốq Tễng Rit dŏq yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Bân ngoah mut chu Dống Sang Aroâiq, Arôn cớp máh con samiang án cóq cha sâiq ki cớp bễng mi noâng clữi tâng crưo. ");
INSERT INTO bru_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Alới cóq cha máh crơng sana chiau sang táq rit yỗn pứt lôih, bo chóh alới cỡt cũai tễng rit sang. Ống cũai tễng rit sang sâng têq cha, yuaq crơng sana nâi miar dŏq yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Khân sâiq tỡ la bễng mi clữi cha, toâq poang tarưp parnỡ cóq bốh chíq tâng ũih. Tỡ têq cha, yuaq sana ki cỡt crơng miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Cóq táq rit chóh Arôn cớp máh con samiang án yỗn dũ tapul tangái máh cứq khoiq patâp mới. ");
INSERT INTO bru_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dũ rangái mới cóq chiau sang ntroŏq tôl dŏq pupứt lôih. Ranáq chiau sang nâi cỡt ranáq sambráh prông sang. Chơ cóq ĩt dỡq nsễng o‑li‑vê tốh tâng prông sang nâi, dŏq cỡt ntốq miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Cóq táq níc ariang nâi tâng tapul tangái. Chơ, prông sang ki cỡt ntốq miar khong Yiang Sursĩ. Khân cũai aléq tỡ la acán ntrớu, ma tatũih prông sang ki, crơng ki cỡt miar khong Yiang Sursĩ tê. ");
INSERT INTO bru_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Cu rangái tễ nâi chumát, cóq chiau sang tâng prông sang bar lám cữu tôl bữn muoi cumo. ");
INSERT INTO bru_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Cóq dững muoi lám cữu con chiau sang tâng pên tarưp, cớp muoi lám ễn tâng pên tabữ. ");
INSERT INTO bru_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tâng ranáq chiau sang cữu con lám muoi, cóq sang parnơi cớp muoi ki-lô bỗt mi talốc cớp muoi lit dỡq nsễng o‑li‑vê. Cớp cóq tốh chiau sang muoi lit blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ma cữu con lám bar, ca chiau sang pên tabữ táq machớng chiau sang pên tarưp tê. Cóq chiau sang dếh blŏ́ng nho cớp máh thữ racáu hỡ. Nâi la ranáq bốh crơng chiau sang yỗn cứq la Yiang Sursĩ. Hỡi phuom chanchức tễ máh crơng sang ki táq yỗn cứq sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ranáq bốh sang yỗn cứq pỡ ngoah toong mut Dống Sang Aroâiq, cóq anhia cớp nheq tŏ́ng toiq anhia táq puai mantái níc. Bân ntốq nâi toâp, cứq ễ ramóh anhia, cớp táq ntỡng cớp mới. ");
INSERT INTO bru_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tâng ntốq ki cứq ễ ramóh máh cũai I-sarel, cớp ntốq ki ễ cỡt ang‑ữr cỗ nhơ tễ chớc cứq. ");
INSERT INTO bru_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Cứq ễ táq yỗn Dống Sang Aroâiq cớp prông sang cỡt miar tễ canŏ́h. Cớp cứq ễ chóh Arôn cớp máh con samiang án cỡt cũai miar tê, dŏq alới táq ranáq cứq na cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ngkíq, cứq lứq ỡt cớp máh cũai I-sarel, cớp cứq cỡt Yiang Sursĩ alới. ");
INSERT INTO bru_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Alới bữn dáng cứq la Yiang Sursĩ, Ncháu alới, án ca khoiq dững aloŏh alới tễ cruang Ê-yip-tô, dŏq cứq ỡt parnơi cớp alới. Cứq la Yiang Sursĩ, Ncháu alới. ");
INSERT INTO bru_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Cóq táq prông sang toâq aluang a-casia dŏq tacât crơng phuom. ");
INSERT INTO bru_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Prông sang ki cóq táq cỡt pỗn canũt, dũ coah cuti muoi coat, cớp sarỡih bar coat. Tâng pỡng bân nhoq prông cóq táq rup tacoi pỗn lám, cớp táq rup ki cỡt muoi sâiq cớp prông. ");
INSERT INTO bru_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Cóq blom prông ki toâq yễng muoi chít, tâng pỡng cớp tâng pỗn coah, dếh tâng rup tacoi hỡ. Cớp chũop prông táq racoam yễng. ");
INSERT INTO bru_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Cóq táq bar lám carvang dŏq ien crang, cớp chóq carvang ki tâng bar coah yáng pưn racoam, dŏq taróc cantrang ien crang. ");
INSERT INTO bru_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Cóq táq cantrang toâq aluang a-casia, cớp blom toâq yễng. ");
INSERT INTO bru_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Cóq achúh dŏq prông ki choâng moat Hĩp Parnai Parkhán, ma yáng tiah aroâiq sangcứt tâng Ntốq Tễng Rit. Tâng ntốq ki cứq ễ ramóh mới. ");
INSERT INTO bru_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Dũ tarưp toâq Arôn mut asa chớp tớu, cóq án tacât crơng phuom tâng prông ki. ");
INSERT INTO bru_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Cóq án táq machớng ki toâq án tacât chớp tớu tâng sadâu. Crơng phuom nâi cóq tacât níc choâng moat cứq, toau dũ dỡi tŏ́ng toiq anhia. ");
INSERT INTO bru_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Chỗi chiau crơng phuom canŏ́h tâng prông sang ki, tỡ la bốh charán, tỡ la chiau sang máh thữ racáu. Cớp chỗi tốh blŏ́ng nho dŏq chiau sang tâng prông ki. ");
INSERT INTO bru_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Muoi cumo muoi trỗ, cóq Arôn mut aríh aham charán chiau sang tâng pỗn lám tacoi prông dŏq pupứt lôih. Cóq táq níc rit nâi dũ cumo. Prông sang ki la prông sang miar yỗn cứq la Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yiang Sursĩ atỡng Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Toâq mới ngih cũai tâng tỗp I-sarel, cóq dũ náq samiang carsai yỗn práq kia dỡi tamoong alới pỡ cứq, dŏq avĩaq tỡ yỗn ỗn hâp lứq toâq pỡ alới, bo máh tangái mới chĩc thrỗq cũai tâng pơ dống sũ. ");
INSERT INTO bru_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Dũ náq samiang bữn ramứh tâng pơ dống sũ cóq yỗn práq ariang dống sang khoiq anoat dŏq chơ. Dũ náq cũai samiang cóq yỗn práq ariang khoiq pai, dŏq chiau sang yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Dũ náq tễ bar chít cumo achỗn cóq chĩc ramứh tâng pơ dống sũ, cớp chát práq chiau sang yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Toâq yỗn práq kia dỡi tamoong chiau sang yỗn Yiang Sursĩ, cũai sốc la tỡ têq yỗn clữi, cớp cũai cadĩt la tỡ têq yỗn bĩq. ");
INSERT INTO bru_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Cóq ĩt parỗm nheq máh práq nâi tễ cũai proai I-sarel; chơ dững dŏq táq ranáq pỡ Dống Sang Aroâiq. Práq nâi thái loah dỡi tamoong cũai proai I-sarel cớp cỡt tếc cứq sanhữ níc alới.” ");
INSERT INTO bru_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yiang Sursĩ atỡng Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Cóq ĩt sapoan, chơ tooc táq ỗ, dếh táq núc hỡ. Cóq achúh ỗ dŏq bân mpứng dĩ prông sang cớp Ntốq Tễng Rit, cớp chóq dỡq tâng ỗ ki. ");
INSERT INTO bru_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Cóq Arôn cớp máh con samiang án ariau atĩ cớp ayững tễ dỡq ki voai, ");
INSERT INTO bru_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","nhũang alới ễ mut chu Ntốq Tễng Rit, tỡ la mut cheq prông dốq bốh crơng chiau sang, ki nŏ́q alới tỡ bữn cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Cóq alới ariau atĩ cớp ayững, dŏq alới bữn vớt tễ cuchĩt. Arôn cớp dũ dỡi tŏ́ng toiq án cóq táq puai níc phễp rit nâi.” ");
INSERT INTO bru_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Chơ Yiang Sursĩ atỡng Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","24","“Cóq ĩt pỗn lit dỡq nsễng o‑li‑vê carchốc cớp crơng phuom neq: Tapoât ki-lô dỡq phuom noau dŏq mứr, pái ki-lô crơng phuom kễq, pái ki-lô crơng phuom noau dŏq bal-sam, cớp tapoât ki-lô crơng phuom noau dŏq casia. Nheq tữh crơng nâi cóq cân puai canân tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Nheq crơng nâi cóq cũai chiang talốc yỗn cỡt dỡq phuom. Ngkíq dỡq nâi dŏq táq tếc chóh cũai táq ranáq cứq. ");
INSERT INTO bru_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Dỡq nsễng miar nâi cóq hĩng tâng Dống Sang Aroâiq cớp tâng Hĩp Parnai Parkhán, ");
INSERT INTO bru_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tâng cachơng cớp crơng radỡng tâng cachơng, rông, chớp tớu, crơng radỡng chớp tớu, tâng prông dŏq tacât crơng phuom, ");
INSERT INTO bru_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","tâng prông sang dŏq bốh charán chiau sang, dếh máh crơng tâc tâng prông ki, cớp tâng ỗ cớp núc dŏq ỗ hỡ; ");
INSERT INTO bru_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","cóq sang yỗn cứq nheq máh crơng ki ĩn khoiq pai; chơ máh crơng ki cỡt crơng miar khong cứq. Khân cũai aléq tỡ la acán ntrớu ma tatũih máh crơng ki, án cỡt crơng miar yỗn cứq tê. ");
INSERT INTO bru_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Chơ ĩt dỡq nsễng miar ki hĩng tâng plỡ Arôn cớp máh con samiang án, cớp chóh alới yỗn cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Cóq mới atỡng máh cũai I-sarel neq: ‘Nâi la dỡq nsễng miar khong cứq, dŏq ĩt hĩng níc dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Chỗi ĩt dỡq nsễng nâi hĩng tâng plỡ cũai miat, cớp chỗi táq dỡq nsễng canŏ́h tũoiq dỡq nsễng nâi. Yuaq dỡq nsễng nâi cỡt dỡq miar. Ngkíq, cóq anhia dŏq nsễng nâi miar yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Cũai aléq ma tũoiq ngê nâi talốc dỡq nsễng, tỡ la ĩt tâc dỡq nsễng nâi hĩng tâng cũai tỡ cỡn cũai tễng rit sang, cũai ki tỡ têq cỡt noâng cũai proai cứq.’” ");
INSERT INTO bru_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq ĩt máh crơng phuom muoi ramứh muoi pún neq: Aluang phuom, crơng phuom tễ ndŏh clo, siet phuom, cớp trâm. ");
INSERT INTO bru_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Cóq talốc máh crơng nâi táq dỡq phuom machớng cũai chiang dốq talốc. Cóq chóq boi dŏq crơng phuom yỗn cỡt bráh cớp miar dŏq yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Cóq ĩt muoi pún clóh yỗn abuoiq, chơ dững bỗt ki pỡ Dống Sang Aroâiq, chơ aríh coah moat Hĩp Parnai Parkhán. Cóq dŏq crơng phuom nâi cỡt crơng miar yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Cóq anhia noap crơng phuom nâi, cỡt crơng miar dŏq chiau sang yỗn cứq. Cớp chỗi táq tũoiq crơng phuom nâi dŏq anhia tâc bữm. ");
INSERT INTO bru_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Khân cũai aléq ma tũoiq talốc ĩn crơng phuom nâi, tỡ la táq yỗn cũai canŏ́h, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Chơ Yiang Sursĩ atỡng Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Nhêng! Cứq khoiq rưoh Be-salen con samiang Uri, châu Hơr tễ tỗp Yuda, ");
INSERT INTO bru_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","yỗn Raviei cứq cỡt sốt tâng mứt pahỡm án. Cứq yỗn án bữn ŏ́c roan rangoaiq, ŏ́c khễuq, cớp têq táq dũ ramứh crơng pasang. ");
INSERT INTO bru_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Têq án aloŏh ngê dŏq táq yễng, práq, cớp sapoan cỡt crơng nêuq o. ");
INSERT INTO bru_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Án khễuq cứt tamáu moat dũ ramứh chóq tâng rabŏ́c, dếh tốc cớp khũar hỡ. ");
INSERT INTO bru_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Cớp cứq khoiq rưoh Ô-hô-liap dŏq táq ranáq parnơi cớp Be-salen. Ô-hô-liap la con samiang Ahi-samac tễ tỗp Dan. Cứq yỗn cũai chiang canŏ́h khễuq machớng alới tê, dŏq táq dũ ramứh cứq khoiq ớn mới táq neq: ");
INSERT INTO bru_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Dống Sang Aroâiq ca bữn Ntốq Tễng Rit cớp Ntốq Cứq Ỡt; Hĩp Parnai Parkhán, dếh cantứp cớp dũ crơng tâc tâng ntốq ki: ");
INSERT INTO bru_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","cachơng, cớp máh crơng radỡng tâng cachơng; rông cớp chớp tớu táq toâq yễng muoi chít, dếh crơng radỡng chớp tớu; prông dŏq tacât crơng phuom; ");
INSERT INTO bru_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","prông dŏq bốh crơng chiau sang, dếh máh crơng radỡng tâng prông; ỗ cớp núc sapoan; ");
INSERT INTO bru_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","tampâc nêuq o khong Arôn cớp máh con samiang án dŏq tâc toâq alới táq ranáq cỡt cũai tễng rit sang; ");
INSERT INTO bru_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","dỡq phuom miar cớp crơng phuom dŏq sang tâng Ntốq Tễng Rit. Dũ ramứh nâi cóq alới táq yỗn pĩeiq ariang cứq khoiq ớn mới chơ.” ");
INSERT INTO bru_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Chơ Yiang Sursĩ ớn Môi-se atỡng máh cũai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Cóq anhia noap tangái tapul cỡt Tangái Rlu khong cứq, yuaq tangái ki cỡt tếc dŏq yỗn anhia cớp cứq sanhữ mantái níc, dŏq apáh cứq, la Yiang Sursĩ khoiq roap tỗp anhia cỡt cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ngkíq cóq anhia noap Tangái Rlu, yuaq tangái ki la tangái miar. Cũai aléq ma tỡ bữn noap ĩt, cóq án roap tôt cuchĩt. Cớp khân aléq táq ranáq ntrớu tâng Tangái Rlu, cũai ki tỡ têq cỡt noâng cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Anhia têq táq ranáq tâng tapoât tangái, ma tâng tangái tapul cóq anhia noap tangái ki la Tangái Rlu dŏq sang toam cứq. Cũai aléq ma táq ranáq tâng tangái ki, cũai ki roap tôt cóq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ngkíq máh tŏ́ng toiq cũai I-sarel cóq noap ĩt níc Tangái Rlu cỡt tếc anhia parkhán cớp cứq. ");
INSERT INTO bru_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Cứq la Yiang Sursĩ khoiq tễng paloŏng cutễq nâi tâng tapoât tangái, ma catâm tangái tapul cứq tangứt tễ máh ranáq cứq táq, cớp cứq rlu. Ngkíq tangái tapul cỡt tếc yỗn cũai I-sarel cớp cứq sanhữ mantái níc.” ");
INSERT INTO bru_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Toâq moâm Yiang Sursĩ atỡng Môi-se pỡ cóh Si-nai, án yỗn Môi-se bar khlễc tamáu ca atĩ án toâp khoiq chĩc máh ŏ́c patâp. ");
INSERT INTO bru_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Toâq máh cũai I-sarel hữm Môi-se ỡt tâng anũol cóh dũn lứq, ngkíq alới rôm muoi ntốq lavíng Arôn cớp pai chóq án neq: “Tỗp hái tỡ bữn dáng ŏ́c ntrớu toâq pỡ Môi-se, án ca dững tỗp hái loŏh tễ cruang Ê-yip-tô. Sanua hếq sễq mới táq yỗn hếq rup yiang dŏq ayông tỗp hếq.” ");
INSERT INTO bru_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Arôn atỡng alới neq: “Cóq anhia pũot latai yễng tễ cutũr lacuoi, con samiang, cớp con mansễm anhia; chơ dững yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ngkíq máh cũai I-sarel dũ náq pũot latai tễ cutũr alới, chơ yỗn pỡ Arôn. ");
INSERT INTO bru_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Arôn parỗm nheq máh latai yễng ki, chơ án tooc táq muoi lám rup ntroŏq tôl yỗn alới. Vớt ki, máh cũai proai pai neq: “Nheq tữh cũai I-sarel ơi! Nâi la yiang hái, án ca dững tỗp hái loŏh tễ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Chơ Arôn táq muoi lám prông sang yáng moat rup ntroŏq yễng ki, cớp atỡng neq: “Tâng tangái parnỡ, bữn ranáq cha bũi dŏq sang yỗn Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Toâq poang tarưp, tỗp alới bốh charán chiau sang yỗn Yiang Sursĩ, cớp dững máh charán canŏ́h kiac cỡt crơng chiau sang dŏq cỡt ratoi. Máh cũai proai pruam tacu nguaiq cha bũi óh lứq, cớp bũl plêc dếh ayữn ayốq tanghang lứq. ");
INSERT INTO bru_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới sễng chái toâp, yuaq máh cũai proai mới dững aloŏh tễ cruang Ê-yip-tô ntôm táq lôih toâr lứq chóq cứq. ");
INSERT INTO bru_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Chái lứq alới nguai chíq tễ ranáq cứq khoiq ớn alới táq. Alới ĩt yễng dững tooc táq rup ntroŏq tôl, cớp cucốh sang rup ki, dếh chiau sang crơng yỗn rup ki. Máh cũai proai pai neq: ‘Nheq tữh cũai I-sarel ơi! Nâi la yiang hái, án ca dững tỗp hái loŏh tễ cruang Ê-yip-tô.’ ");
INSERT INTO bru_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“Cứq dáng máh cũai nâi la ngian lứq. ");
INSERT INTO bru_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sanua alới catáng mứt pahỡm cứq tỡ yỗn cứq táq alới, cỗ tễ ŏ́c cutâu chóq alới. Cứq ễ pupứt táh nheq tỗp alới. Chơ cứq ễ táq yỗn mới ễn cớp tŏ́ng toiq mới cỡt cruang toâr lứq.” ");
INSERT INTO bru_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ma Môi-se câu sễq tễ Yiang Sursĩ, Ncháu án neq: “Cucốh Yiang Sursĩ ơi! Cỗ nŏ́q anhia ma sâng cutâu mứt lứq chóq cũai proai anhia, cũai anhia dững aloŏh tễ cruang Ê-yip-tô na chớc toâr lứq khong anhia? ");
INSERT INTO bru_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Cỗ nŏ́q ma táq yỗn cũai Ê-yip-tô pai neq: ‘Yiang Sursĩ dững cũai proai án loŏh, la cỗ án ễ cachĩt tỗp alới tâng cóh, na pupứt yỗn tỗp alới pứt nheq?’ Sễq anhia chỗi cutâu noâng chóq cũai proai anhia, cớp ralêq mứt tỡ bữn pupứt noâng tỗp alới. ");
INSERT INTO bru_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Sễq anhia sanhữ cũai táq ranáq anhia, la A-praham, I-sac, cớp Yacốp. Sễq anhia sanhữ loah tễ máh santoiq anhia khoiq parkhán pai ễ yỗn alới bữn tŏ́ng toiq rứh rưong sa‑ữi lứq machớng mantỗr tâng paloŏng; cớp anhia pai ễ yỗn tỗp alới bữn cutễq anhia khoiq par‑ữq yỗn cỡt cruang alới mantái níc.” ");
INSERT INTO bru_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Yuaq ngkíq, Yiang Sursĩ ma lêq loah mứt pahỡm, cớp tỡ bữn dững noâng ŏ́c cuchĩt pứt toâq pỡ cũai proai án, ariang án khoiq pai dŏq. ");
INSERT INTO bru_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Môi-se sễng tễ anũol cóh, cớp án dững asễng dếh bar khlễc tamáu Ncháu khoiq chĩc dŏq máh santoiq patâp tâng bar coah tamáu ki. ");
INSERT INTO bru_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Yiang Sursĩ toâp táq khlễc tamáu ki, cớp chĩc dŏq ŏ́c patâp tâng ki. ");
INSERT INTO bru_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Toâq Yô-sũa sâng cũai proai ntôm hễr cu‑ỗi casang lứq, án táq ntỡng cớp Môi-se neq: “Ariang pai cứq sâng sưong rachíl ratáq pỡ ntốq hái ỡt.” ");
INSERT INTO bru_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Môi-se ta‑ỡi neq: “Tỡ cỡn sưong alới triau cupo cỗ chíl riap, tỡ la sưong cuclỗiq cỗ pê, ma sưong ki la sưong ũat.” ");
INSERT INTO bru_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tữ Môi-se toâq pỡ ntốq cũai proai ỡt cớp hữm rup ntroŏq yễng, dếh cũai proai ntôm ũat ayữn ayốq, ngkíq án sâng cutâu lứq. Án atáih chíq khlễc tamáu án yống bân yững cóh; chơ khlễc tamáu ki pacháh. ");
INSERT INTO bru_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Án ĩt rup ntroŏq con ca cũai proai khoiq táq toâq yễng, chơ án sarpứt rup ki tâng ũih yỗn cat. Án ĩat yỗn mún nheq, cớp apŏ́ng tâng dỡq; chơ án ễp máh cũai I-sarel nguaiq. ");
INSERT INTO bru_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Án blớh Arôn neq: “Cũai proai nâi táq ntrớu chóq mới, ma mới dững alới táq lôih ntâng lứq?” ");
INSERT INTO bru_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arôn ta‑ỡi: “Sễq mới chỗi nhôp cứq. Mới dáng samoât chơ, cũai proai tỗp nâi yoc lứq ễ táq lôih. ");
INSERT INTO bru_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Alới khoiq pai cớp cứq neq: ‘Hếq tỡ bữn dáng ŏ́c ntrớu cỡt cớp Môi-se, án ca dững tỗp hái loŏh tễ cruang Ê-yip-tô. Yuaq ngkíq, sễq mới táq yỗn hếq rup yiang dŏq ayông tỗp hếq.’ ");
INSERT INTO bru_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Cứq ớn alới dững máh crơng ra‑ỗt táq toâq yễng toâq pỡ cứq. Chơ alới ca bữn, ki pũot aloŏh toâp yỗn cứq. Cứq apŏ́ng máh crơng ra‑ỗt ki tâng ũih; tễ crơng ki cỡt muoi lám rup ntroŏq yễng nâi!” ");
INSERT INTO bru_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Môi-se dáng samoât lứq Arôn tỡ bữn catáng cũai proai cớp yỗn alới táq puai mứt sâng yoc. Táq ngkíq Arôn táq yỗn alới cỡt machớng cũai ŏ́q rit yáng moat máh cũai par‑ũal. ");
INSERT INTO bru_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ngkíq Môi-se loŏh tayứng choâng ngoah toong mut vil alới ỡt dỡ, cớp pai neq: “Cũai aléq ma ỡt coah Yiang Sursĩ, yỗn toâq pỡ nâi!” Chơ nheq tữh cũai tễ tỗp Lê-vi toâq ỡt coah Môi-se, ");
INSERT INTO bru_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","cớp án atỡng neq: “Yiang Sursĩ, la Yiang tỗp I-sarel sang, án ớn tỗp anhia dũ náq cóq clễu dau, chơ mut tâng vil tễ coah nâi pỡq chu coah tíh, cớp cachĩt táh nheq máh sễm ai, yớu ratoi, cớp yớu ỡt cheq dống sũ anhia.” ");
INSERT INTO bru_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tỗp Lê-vi táq puai máh santoiq Môi-se atỡng alới; chơ alới cachĩt cũai ống muoi tangái sám pái ngin náq. ");
INSERT INTO bru_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Chơ Môi-se pai chóq alới neq: “Tangái nâi, tỗp anhia chiau tỗ chác yỗn cỡt cũai miar dŏq táq ranáq Yiang Sursĩ na cachĩt máh con samiang cớp sễm ai anhia bữm. Ngkíq Yiang Sursĩ ễ yỗn anhia bữn ŏ́c bốn.” ");
INSERT INTO bru_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Toâq tangái parnỡ ễn, Môi-se atỡng máh cũai proai neq: “Anhia khoiq táq lôih ntâng lứq. Ma sanua cứq ễ chỗn ramóh Yiang Sursĩ sĩa pỡ cóh ki, dŏq sễq án táh lôih yỗn anhia; cŏh lơ án táh lôih yỗn anhia cống bữn.” ");
INSERT INTO bru_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Chơ Môi-se píh pỡq ramóh loah Yiang Sursĩ, cớp án atỡng neq: “Ơ Yiang Sursĩ ơi! Máh cũai proai nâi táq lôih ntâng lứq. Alới ĩt yễng tooc táq rup yiang, cớp alới cucốh sang rup ki. ");
INSERT INTO bru_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sễq anhia táh lôih yỗn alới nứng! Khân tỡ bữn ngkíq, sễq anhia pupứt chíq ramứh cứq tễ pơ anhia khoiq chĩc máh ramứh cũai proai anhia!” ");
INSERT INTO bru_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ma Yiang Sursĩ ta‑ỡi án neq: “Cũai aléq táq lôih chóq cứq, ki cứq pupứt ramứh cũai ki tễ pơ cứq. ");
INSERT INTO bru_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ma sanua, cóq mới ayông máh cũai nâi yỗn pỡq toâq pỡ ntốq cứq khoiq atỡng mới chơ. Ma cóq mới sanhữ, ranễng cứq tễ paloŏng ễ ayông mới pỡq. Ma toâq ngư cứq khoiq anoat dŏq chơ, cứq ễ manrap cũai nâi cỗ tian lôih alới táq.” ");
INSERT INTO bru_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ngkíq, Yiang Sursĩ táq yỗn máh cũai proai cỡt rang‑ĩ tacóh, cỗ tian alới ễp Arôn yỗn táq rup ntroŏq yễng. ");
INSERT INTO bru_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới dễq tễ ntốq nâi, cớp dững máh cũai proai mới khoiq dững aloŏh tễ cruang Ê-yip-tô, chơ pỡq chu ntốq cứq khoiq parkhán cớp A-praham, I-sac, Yacốp, cớp tŏ́ng toiq alới hỡ. ");
INSERT INTO bru_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ranễng cứq tễ paloŏng ễ ayông anhia pỡq, cớp cứq ễ tuih aloŏh nheq máh tỗp Cana-an, Amô-rit, Hêt, Pê-rasit, Hê-vit, cớp Yê-but. ");
INSERT INTO bru_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Anhia ntôm pỡq chu ntốq cutễq la‑a cớp phốn phuor o. Ma cứq tỡ ễq pỡq cớp anhia, cỗ anhia bữn mứt pahỡm ngian; cŏh lơ cứq pupứt táh anhia tâng rana la cống bữn.” ");
INSERT INTO bru_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Toâq cũai proai sâng tễ ŏ́c ki, alới tanúh cớp tỡ bữn noau tâc noâng máh crơng ra‑ỗt. ");
INSERT INTO bru_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yuaq Yiang Sursĩ khoiq ớn Môi-se atỡng alới neq: “Anhia la cũai bữn mứt pahỡm coang. Khân cứq ma pỡq cớp anhia mahúiq sâng, cŏh lơ cứq pupứt anhia yỗn pứt nheq. Ma sanua cóq anhia pũot aloŏh nheq máh crơng ra‑ỗt; chơ cứq chanchớm loah nŏ́q cứq ễ táq chóq anhia.” ");
INSERT INTO bru_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Yuaq ngkíq, toâq cũai I-sarel loŏh tễ cóh Si-nai, alới tỡ bữn chóq crơng ra‑ỗt ntrớu noâng. ");
INSERT INTO bru_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Toâq trỗ léq cũai proai I-sarel táq ntốq ỡt dỡ, ki Môi-se ayứng dống aroâiq miar yơng tễ ntốq alới ỡt. Dống aroâiq nâi amứh Dống Aroâiq Sarhống Cớp Yiang Sursĩ. Cớp cũai aléq ma yoc ễ dáng ntrớu Yiang Sursĩ atỡng, dốq cũai ki loŏh tễ ntốq ỡt, chơ pỡq chu dống aroâiq miar. ");
INSERT INTO bru_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Toâq Môi-se pỡq chu dống aroâiq miar, cũai proai tayứng bân ngoah toong dống aroâiq alới bữm, ễ nhêng Môi-se mut tâng dống aroâiq miar ki. ");
INSERT INTO bru_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Toâq Môi-se mut cloâm chơ tâng dống aroâiq miar, ki bữn sapom ramứl sễng chu pưn cớp tangứt choâng ngoah toong dống aroâiq miar ki. Cớp Yiang Sursĩ táq ntỡng cớp Môi-se tễ sapom ramứl. ");
INSERT INTO bru_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Trỗ léq máh cũai proai hữm sapom ramứl ỡt choâng ngoah toong dống aroâiq, bo ki toâp alới pũp crap bân ngoah toong dống alới bữm. ");
INSERT INTO bru_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yiang Sursĩ ỡt rato moat táq ntỡng cớp Môi-se, machớng muoi noaq cũai táq ntỡng cớp yớu ratoi. Toâq Môi-se chu loah pỡ ntốq cũai proai ỡt, Yô-sũa con samiang Nun noâng ỡt tâng dống aroâiq miar ki. Yô-sũa la cũai póng chuai ranáq yỗn Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Chơ Môi-se táq ntỡng cớp Yiang Sursĩ neq: “Ơ Yiang Sursĩ ơi! Anhia khoiq ớn cứq dững cũai proai tỗp nâi, ma anhia tỡ bữn atỡng cũai aléq têq toâq chuai ranáq cứq. Anhia khoiq pai la anhia dáng cứq samoât lứq, cớp anhia sâng bũi pahỡm cớp cứq. ");
INSERT INTO bru_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ma sanua, khân anhia bũi pahỡm cớp cứq, ki sễq anhia atỡng ngê anhia yỗn cứq dáng, dŏq cứq táq níc ranáq anhia, cớp dŏq anhia sâng bũi níc cớp cứq. Sễq anhia chanchớm loah, anhia khoiq rưoh tỗp nâi dŏq cỡt cũai proai anhia.” ");
INSERT INTO bru_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yiang Sursĩ ta‑ỡi neq: “Cứq toâp lứq ayông mới, cớp yỗn mới ỡt ien khễ.” ");
INSERT INTO bru_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Chơ Môi-se ta‑ỡi neq: “Khân anhia tỡ bữn ayông tỗp hếq pỡq, ki sễq anhia chỗi yỗn hếq loŏh tễ ntốq nâi. ");
INSERT INTO bru_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nŏ́q têq noau dáng pai anhia bũi pahỡm cớp máh cũai proai anhia, cớp bũi pahỡm cớp cứq, khân anhia tỡ bữn ayông tỗp hếq pỡq? Ranáq ki apáh yỗn cũai canŏ́h dáng tỗp hếq mpha tễ dũ tỗp canŏ́h tâng cốc cutễq nâi.” ");
INSERT INTO bru_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yiang Sursĩ atỡng Môi-se neq: “Cứq ễ táq ariang mới sễq, yuaq cứq dáng mới samoât lứq, cớp cứq sâng bũi pahỡm cớp mới.” ");
INSERT INTO bru_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Chơ Môi-se sễq neq: “Cứq sễq anhia yỗn cứq hữm ang‑ữr anhia.” ");
INSERT INTO bru_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yiang Sursĩ ta‑ỡi neq: “Cứq ễ yỗn moat mới hữm máh chớc cứq; cớp cứq talếq ramứh cứq, la Yiang Sursĩ, choâng moat mới. Khân cứq sâng ayooq táq cũai aléq, ki cứq ayooq. Cớp khân cứq sâng sarũiq táq cũai aléq, ki cứq sarũiq. ");
INSERT INTO bru_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ma mới tỡ têq hữm mieiq cứq, yuaq tỡ bữn noau hữm cứq ma têq bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nhêng tíh! Bữn muoi cốc tamáu toâr ỡt yáng coah cứq. Cóq mới pỡq tayứng tâng pỡng cốc tamáu ki. ");
INSERT INTO bru_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Toâq ŏ́c ang‑ữr cứq pha mới, cứq lứq capáng dŏq mới toâq atĩ cứq toâp bân mpứng dĩ raloâc tamáu yỗn toau cứq pỡq vớt. ");
INSERT INTO bru_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Moâm ki cứq ễ yíq loah atĩ; chơ mới bữn hữm yáng clĩ cứq, ma mới tỡ bữn hữm mieiq cứq.” ");
INSERT INTO bru_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới tốc loah bar khlễc tamáu machớng tễ nhũang. Chơ cứq ễ chĩc tâng bar khlễc tamáu ki máh santoiq cứq khoiq chĩc tâng tamáu mới táq pacháh. ");
INSERT INTO bru_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Cóq mới thrũan; tarưp parnỡ cóq mới chỗn ramóh cứq pỡ cóh Si-nai. ");
INSERT INTO bru_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Chỗi yỗn cũai aléq chỗn cớp mới; chỗi yỗn cứq hữm cũai aléq tâng cóh Si-nai. Cớp chỗi yỗn charán cữu, mbễq, tỡ la ntroŏq cha bát tâng yững cóh nâi.” ");
INSERT INTO bru_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ngkíq Môi-se tốc bar khlễc tamáu machớng cớp khlễc nhũang. Toâq tarưp parnỡ tễ cláih án ayễq khlễc tamáu ki chỗn chu cóh Si-nai, machớng Yiang Sursĩ khoiq ớn án. ");
INSERT INTO bru_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yiang Sursĩ sễng tâng ramứl; án tayứng cớp Môi-se tâng ntốq ki. Án atỡng ramứh án la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Chơ Yiang Sursĩ pỡq pha moat Môi-se cớp pai neq: “Cứq la Yiang Sursĩ, Ncháu ca bữn mứt pahỡm sarũiq cớp ayooq; cớp bữn mứt khũn, tỡ bữn coâp nsóq; cớp tanoang tapứng níc. ");
INSERT INTO bru_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Cứq ayooq níc proai cứq toau toâq sa‑ữi ngin dỡi cũai; cứq táh máh ranáq sâuq, ranáq lôih, cớp ranáq tỡ bữn trĩh cứq. Ma cứq noâng yỗn tôt pỡ con châu cũai ca táq lôih chóq cứq toau toâq pái pỗn dỡi cũai.” ");
INSERT INTO bru_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Môi-se pũp crap toâp cớp sang toam yám noap Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Án pai neq: “Ơ Yiang Sursĩ ơi! Khân anhia ma bũi pahỡm cớp cứq, ki sễq anhia ayông hếq. Cũai proai tỗp nâi bữn mứt pahỡm ngian, ma sễq anhia táh lôih máh ranáq sâuq cớp ranáq lôih hếq khoiq táq, cớp sễq anhia roap hếq cỡt cũai proai anhia.” ");
INSERT INTO bru_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yiang Sursĩ atỡng Môi-se neq: “Sanua cứq parkhán cớp máh cũai I-sarel. Cứq ễ táq ranáq toâr tâng tỗp alới, ranáq tỡ nai táq yũah yỗn tỗp aléq tâng cốc cutễq nâi. Nheq tữh cũai proai lứq bữn hữm cứq, la Yiang Sursĩ ễ táq ranáq salễh, yuaq cứq ntôm ễ táq yỗn mới sâng dớt lứq. ");
INSERT INTO bru_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Cóq anhia trĩh máh phễp rit cứq chiau yỗn anhia tâng tangái nâi. Cứq lứq tuih aloŏh máh tỗp Amô-rit, Cana-an, Hêt, Pê-rasit, Hê-vit, cớp Yê-but toâq anhia mut chu máh vil alới. ");
INSERT INTO bru_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Cóq anhia nhêng yỗn o, chỗi parkhán ntrớu cớp cũai tâng cruang anhia ntôm ễ mut ỡt, yuaq ranáq ki cỡt ariang sarnŏ́q ễ chŏ́q anhia bữm. ");
INSERT INTO bru_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ma cóq anhia talốh táh nheq máh prông sang alới, pieih táh nheq ngôl tamáu khớt, cớp tamư nheq tanũl noau dốq sang yiang Asê-ra. ");
INSERT INTO bru_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Chỗi cucốh yiang canŏ́h, yuaq cứq la Yiang Sursĩ tỡ bữn pruam anhia puai yiang canŏ́h. ");
INSERT INTO bru_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Cóq anhia nhêng yỗn o, chỗi parkhán ntrớu cớp cũai tâng cutễq ki, yuaq toâq alới cucốh sang yiang alới, ki alới ễ mơi dếh anhia toâq rôm tê. Ngkíq alới radững anhia cha sana alới sang yỗn yiang alới. ");
INSERT INTO bru_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Khân con samiang anhia racoâiq cớp con cumũr tễ tỗp ki, chơ alới lứq radững con samiang anhia tỡ bữn tanoang tapứng noâng chóq cứq; cớp con samiang anhia lứq nguai chíq tễ cứq, chơ pỡq cucốh sang máh yiang cũai ki ễn. ");
INSERT INTO bru_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Chỗi tooc tac táq rup yiang canŏ́h. ");
INSERT INTO bru_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Tâng casâi Abip, la casâi tỗp anhia khoiq loŏh tễ cruang Ê-yip-tô, cóq anhia táq rit cha bũi Tangái Cha Bễng Mi Ŏ́q Crơng Pluoih, ĩn cứq khoiq patâp dŏq. Nheq tapul tangái anhia chỗi cha bễng mi bữn crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Con samiang clúng dũ náq cớp charán tôl pốh dâu dũ lám cỡt khong cứq nheq. ");
INSERT INTO bru_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ma máh aséh dễn tôl pốh dâu, cóq anhia ĩt cữu pláih loah. Khân anhia tỡ ễq pláih, cóq anhia dóh chíq tacong án. Ma con samiang clúng anhia, cóq anhia thái loah dũ náq. “Chỗi toâq sang toam cứq, khân tỡ bữn dững crơng chiau sang. ");
INSERT INTO bru_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Têq anhia táq ranáq tâng tapoât tangái, ma tâng tangái tapul anhia chỗi táq ranáq ntrớu; tam catữ táq sarái tỡ la sot saro la cóq anhia rlu tâng tangái tapul ki. ");
INSERT INTO bru_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Cóq anhia táq rit cha bũi Tangái Susot saro mi bo anhia mbỡiq ĩt palâi dâu, cớp táq rit cha bũi Tangái Chóh Nloâh, toâq moâm anhia ĩt palâi sarnóh tễ nưong, casâi cheq ễ nheq cumo. ");
INSERT INTO bru_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Tâng cu cumo pái trỗ cha bũi, cóq yỗn samiang dũ náq toâq sang toam cứq la Yiang Sursĩ Ncháu Nheq Tữh Cũai. Cứq la Yiang Sursĩ tỗp I-sarel sang. ");
INSERT INTO bru_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Toâq vớt cứq tuih aloŏh máh tỗp canŏ́h nhũang anhia ễ mut, cứq táq yỗn cruang cutễq anhia cỡt la‑a ễn, cớp tỡ bữn noau têq cheng ĩt cutễq anhia, bo anhia cha bũi tâng pái trỗ nâi. ");
INSERT INTO bru_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Chỗi chiau sang bễng mi bữn crơng pluoih toâq anhia kiac charán sang cứq. Cớp toâq anhia cha pêl bũi táq rit sanhữ Tangái Loŏh, chỗi ĩt dŏq sâiq charán anhia sang toau toâq tarưp parnỡ. ");
INSERT INTO bru_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Cu cumo cóq anhia dững pỡ dống sang Yiang Sursĩ, la Ncháu anhia, máh palâi sarnóh anhia ĩt dâu lứq. “Chỗi ớp sâiq cữu con tỡ la mbễq con tâng dỡq tóh mpiq án bữm.” ");
INSERT INTO bru_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Chơ Yiang Sursĩ atỡng Môi-se ễn neq: “Cóq mới chĩc dŏq máh ŏ́c cứq khoiq atỡng nâi, yuaq santoiq nâi la nỡm ŏ́c cứq parkhán cớp mới, dếh máh cũai I-sarel hỡ.” ");
INSERT INTO bru_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Môi-se ỡt cớp Yiang Sursĩ tâng cóh nheq pỗn chít tangái pỗn chít sadâu; ma án tỡ bữn nguaiq cha ntrớu. Án chĩc dŏq máh ŏ́c parkhán tâng khlễc tamáu, la muoi chít ŏ́c Yiang Sursĩ patâp. ");
INSERT INTO bru_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Toâq Môi-se sễng tễ cóh Si-nai, án ayễq khlễc tamáu chĩc dŏq muoi chít ŏ́c Yiang Sursĩ patâp, ma án tỡ bữn dáng pai mieiq án tráh ang, cỗ án khoiq táq ntỡng cớp Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Toâq Arôn cớp cũai proai hữm mieiq Môi-se claq poang, alới tỡ khớn ỡt cheq án. ");
INSERT INTO bru_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ma Môi-se arô alới; chơ Arôn cớp máh cũai sốt cũai proai toâq cheq, cớp tamứng Môi-se táq ntỡng. ");
INSERT INTO bru_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Vớt ki, nheq tữh cũai proai I-sarel rôm nhêng Môi-se. Chơ án arĩen yỗn cũai proai dáng nheq tễ phễp rit Yiang Sursĩ khoiq chiau yỗn án pỡ cóh Si-nai. ");
INSERT INTO bru_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Toâq moâm Môi-se atỡng, án ĩt aroâiq pul chíq mieiq. ");
INSERT INTO bru_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Dũ trỗ án mut tâng dống aroâiq miar, bân ntốq án táq ntỡng cớp Yiang Sursĩ, án pũot aroâiq pul mieiq toau toâq án loŏh. Toâq án loŏh tễ dống aroâiq miar trỗ léq, ki án atỡng dũ ramứh Yiang Sursĩ patâp yỗn máh cũai I-sarel dáng tê. ");
INSERT INTO bru_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Alới hữm mieiq Môi-se claq poang. Chơ Môi-se ĩt aroâiq pul chíq mieiq án patoat tiaq, yỗn toau án mut ramóh Yiang Sursĩ sĩa. ");
INSERT INTO bru_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Môi-se arô nheq tữh tỗp I-sarel toâq rôm. Án atỡng alới neq: “Nâi la máh santoiq Yiang Sursĩ khoiq patâp yỗn anhia táq puai. ");
INSERT INTO bru_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Cóq anhia táq ranáq tâng tapoât tangái, ma toâq tangái tapul cóq anhia rlu, yuaq tangái ki la tangái miar tễ canŏ́h, cỡt tangái dŏq sang Yiang Sursĩ. Cũai aléq táq ranáq tâng tangái ki, cóq án roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Tâng Tangái Rlu anhia tỡ têq dếh palư ũih.” ");
INSERT INTO bru_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Môi-se atỡng nheq tữh cũai proai I-sarel neq: “Nâi la ŏ́c Yiang Sursĩ patâp. ");
INSERT INTO bru_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Cóq anhia dững crơng crớu chiau sang yỗn Yiang Sursĩ. Cũai aléq ma bũi pahỡm yỗn, ki yỗn án dững máh crơng neq: Yễng, práq, sapoan; ");
INSERT INTO bru_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","aroâiq busín; aroâiq noau táq toâq sóc cữu santứm satong, ễng, cớp cusâu; aroâiq noau táq tễ sóc mbễq; ");
INSERT INTO bru_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ngcâr cữu tôl noau yớm cỡt cusâu; ngcâr charán languat o; cớp aluang a-casia; ");
INSERT INTO bru_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","dỡq nsễng o‑li‑vê dŏq tacât; crơng phuom carchốc táq dỡq nsễng miar, dŏq atia cớp dŏq tacât yỗn phuom; ");
INSERT INTO bru_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","tamáu moat noau dŏq o-nic, dếh tamáu moat canŏ́h noau chóq tâng aroâiq ê-phot, la aroâiq cũai sốt nheq tễ rit sang Yiang Sursĩ sớp, cớp noau chóq tâng aroâiq sadal apơm alễu pỡng ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Máh cũai chiang tễ tỗp anhia cóq toâq táq máh ramứh Yiang Sursĩ ớn neq: ");
INSERT INTO bru_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Dống Sang Aroâiq, aroâiq pul dống sang ki, cớp aroâiq acrúq yáng tiah; canŏ́q, khuon aluang, prang póc, tanũl, cớp crơng rayống ayững tanũl; ");
INSERT INTO bru_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Hĩp Parnai Parkhán, dếh aluang cantrang, cantứp, cớp aroâiq sangcứt catáng Hĩp Parnai Parkhán; ");
INSERT INTO bru_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","cachơng, aluang crang cachơng; cớp crơng radỡng dũ ramứh ỡt tâng cachơng ki; bễng mi sang yỗn Yiang Sursĩ; ");
INSERT INTO bru_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","rông tớu cớp crơng radỡng tâng ki; chớp cớp tớu; ");
INSERT INTO bru_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","prông sang dŏq tacât crơng phuom cớp aluang cantrang prông ki; dỡq nsễng miar dŏq chóh cũai; crơng phuom dŏq chŏ́ng; aroâiq catáng ngoah toong mut chu Dống Sang Aroâiq; ");
INSERT INTO bru_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","prông dŏq bốh crơng sang cớp khlễc sapoan hỡng ĩn sara chóq tâng prông, dếh cantrang crang prông cớp crơng radỡng bữn tâng prông ki; ỗ cớp núc; ");
INSERT INTO bru_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","aroâiq yoang chũop Dống Sang Aroâiq, tanũl cớp crơng rayống ayững tanũl, cớp aroâiq catáng ngoah toong mut chu nchŏh Dống Sang Aroâiq; ");
INSERT INTO bru_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","lác cớp samữ dŏq táq yỗn khâm Dống Sang Aroâiq, dếh aroâiq yoang savĩel mpễr nchŏh Dống Sang Aroâiq; ");
INSERT INTO bru_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","máh tampâc cũai tễng rit sang, dŏq yỗn Arôn cớp máh con samiang án tâc toâq alới mut táq ranáq cứq tâng Ntốq Tễng Rit.” ");
INSERT INTO bru_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Nheq tữh cũai proai I-sarel miar loŏh tễ Môi-se, ");
INSERT INTO bru_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","cớp dũ náq cũai ca bữn mứt pahỡm yoc ễ rachuai, alới dững crơng chiau sang yỗn Yiang Sursĩ dŏq táq Dống Sang Aroâiq. Alới dững dũ ramứh crơng cóq bữn tâng dống sang cớp táq tampâc yỗn cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Dũ náq cũai bũi pahỡm ễ chiau sang yỗn Yiang Sursĩ, dếh mansễm dếh samiang, dững máh crơng ra‑ỗt neq: Canléh ra‑ỗt, latai, sambễt, sanoâc, cớp crơng yễng canŏ́h hỡ. Alới apỗng achỗn chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bữn cũai dững aroâiq busín; priei noau táq tễ sóc cữu santứm satong, ễng, tỡ la cusâu; aroâiq táq tễ sóc mbễq; ngcâr cữu tôl yớm cusâu; cớp ngcâr languat o. ");
INSERT INTO bru_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Án ca bữn práq, tỡ la sapoan, án dững chiau sang yỗn Yiang Sursĩ; cớp cũai bữn aluang a-casia pĩeiq cớp ranáq ki, la án dững tê. ");
INSERT INTO bru_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dũ náq mansễm khễuq casán priei busín, cớp priei sóc cữu santứm satong, ễng, cớp cusâu, ki alới dững priei. ");
INSERT INTO bru_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Cớp alới táq priei toâq sóc mbễq dững chiau sang machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Tỗp cũai sốt ĩt tamáu o-nic cớp tamáu ngoaih canŏ́h dŏq chóq tâng ê-phot cớp aroâiq sadal apơm alễu pỡng ê-phot, ");
INSERT INTO bru_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dếh dững máh crơng phuom cớp dỡq nsễng dŏq chóq tâng chớp tớu, tỡ la táq dỡq nsễng miar dŏq chóh cũai, cớp táq crơng phuom dŏq tacât. ");
INSERT INTO bru_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nheq tữh cũai I-sarel ca bũi pahỡm yỗn, alới dững tê crơng dŏq táq ranáq Yiang Sursĩ khoiq patâp na Môi-se yỗn alới táq. ");
INSERT INTO bru_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Môi-se atỡng máh cũai I-sarel neq: “Yiang Sursĩ khoiq rưoh Be-salen con samiang Uri, châu Hơr tễ tỗp Yuda. ");
INSERT INTO bru_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Raviei Yiang Sursĩ cỡt sốt tâng mứt pahỡm án; ngkíq án bữn ŏ́c roan rangoaiq, ŏ́c khễuq, cớp têq táq dũ ramứh crơng pasang. ");
INSERT INTO bru_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Án têq aloŏh ngê táq yễng, práq, cớp sapoan. ");
INSERT INTO bru_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Án khễuq cứt tamáu moat dũ ramứh ễ chóq tâng rabŏ́c, tỡ la tốc cớp khũar hỡ. ");
INSERT INTO bru_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yiang Sursĩ khoiq yỗn án cớp Ô-hô-liap con samiang Ahi-samac tễ tỗp Dan, têq arĩen tễ ranáq nâi yỗn máh cũai canŏ́h dáng. ");
INSERT INTO bru_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Yiang Sursĩ khoiq yỗn alới bữn ŏ́c roan rangoaiq cớp têq táq ranáq sa‑ữi ramứh neq: Chor pachĩr, aloŏh ngê tễ ranáq, tan aroâiq busín, tan aroâiq sóc cữu santứm satong, ễng, cớp cusâu, cớp tan sa‑ữi ramứh aroâiq canŏ́h hỡ. Alới cỡt cũai chiang dũ ramứh, cớp cỡt cũai rangoaiq aloŏh ngê ễ táq. ");
INSERT INTO bru_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ngkíq Be-salen, Ô-hô-liap, dếh nheq tữh cũai chiang ca Yiang Sursĩ khoiq yỗn alới bữn ŏ́c rangoaiq cớp khễuq, cóq alới táq Dống Sang Aroâiq puai ĩn Yiang Sursĩ khoiq patâp dũ ramứh.” ");
INSERT INTO bru_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Chơ Môi-se arô Be-salen, Ô-hô-liap, dếh cũai canŏ́h Yiang Sursĩ khoiq yỗn bữn ngê khễuq tutáq, alới ca bữn mứt pahỡm yoc ễ rachuai tễ ranáq táq Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Alới ki bữn roap tễ Môi-se máh crơng cũai I-sarel khoiq chiau sang dŏq ayứng Dống Sang Aroâiq. Ma dũ tarưp cũai I-sarel noâng dững níc crơng sang pỡ Môi-se puai mứt pahỡm alới yoc ễ yỗn. ");
INSERT INTO bru_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Chơ, máh cũai chiang ca ntôm táq ranáq ki pỡq ramóh Môi-se, ");
INSERT INTO bru_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","cớp atỡng neq: “Máh cũai proai ntôm dững crơng crớu sa‑ữi hỡn tễ hếq anoat dŏq táq moâm ranáq Yiang Sursĩ ớn hếq táq.” ");
INSERT INTO bru_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ngkíq Môi-se pau atỡng chũop ntốq alới ỡt neq: “Chỗi dững noâng crơng sang pỡ Dống Sang Aroâiq.” Yuaq ngkíq, máh cũai proai ma tỡ bữn dững noâng crơng, ");
INSERT INTO bru_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","yuaq crơng alới khoiq dững ki clữi tễ noau anoat cóq bữn dŏq táq moâm ranáq ki. ");
INSERT INTO bru_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Máh cũai chiang ca khễuq hỡn tễ cũai chiang canŏ́h, alới táq Dống Sang Aroâiq. Alới táq ntốq ki toâq aroâiq busín o lứq muoi chít ploah tan carchốc cớp priei sóc cữu santứm satong, ễng, cớp cusâu, dếh chún rup chê-rup chóq tâng aroâiq ki hỡ. ");
INSERT INTO bru_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ma dũ ploah aroâiq li nheq, cuti bar chít tacual coat, la‑a pỗn coat. ");
INSERT INTO bru_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Alới yĩh aroâiq sỡng ploah patĩng parnơi yỗn cỡt muoi ploah sâng, cớp sỡng ploah ễn alới yĩh machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Alới yĩh táq máh cutũr toâq aroâiq santứm satong tâng chễu bar ploah aroâiq la‑a ki. ");
INSERT INTO bru_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Alới yĩh sỡng chít cutũr tâng aroâiq ễ yoang dâu lứq; chơ sỡng chít cutũr ễn yĩh tâng aroâiq ploah bar ễ yoang ntun. Nheq cutũr ki cóq ỡt choâng-rachoâng. ");
INSERT INTO bru_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Alới táq canŏ́q yễng sỡng chít lám dŏq ien cŏ́q tâng cutũr aroâiq bar ploah toâr ki, chơ aroâiq ki cỡt máh muoi ploah sâng. ");
INSERT INTO bru_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Alới táq aroâiq dŏq acrúq tâng Dống Sang Aroâiq, muoi chít la muoi ploah aroâiq tan toâq sóc mbễq. ");
INSERT INTO bru_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dũ ploah alới táq machớng nheq, cuti pái chít coat, la‑a pỗn coat. ");
INSERT INTO bru_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Alới yĩh patĩng parnơi aroâiq sỡng ploah yỗn cỡt muoi ploah sâng, chơ yĩh patĩng tapoât ploah ễn yỗn cỡt muoi ploah tê. ");
INSERT INTO bru_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Alới yĩh sỡng chít lám cutũr chóq tâng pứp aroâiq ploah muoi, cớp yĩh sỡng chít cutũr ễn chóq tâng pứp aroâiq ploah bar. ");
INSERT INTO bru_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Chơ alới táq sỡng chít canŏ́q sapoan dŏq cŏ́q bar ploah aroâiq ki, yỗn amóh parnơi cỡt muoi ploah sâng. ");
INSERT INTO bru_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Alới táq cantrúq bar ploah ễn, ploah muoi toâq ngcâr cữu tôl yớm santứm cusâu. Cớp ploah bar, táq toâq ngcâr charán languat o dŏq cutrúq yáng tiah. ");
INSERT INTO bru_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Alới táq máh khuon Dống Sang Aroâiq toâq aluang a-casia, patứng yỗn tanoang. ");
INSERT INTO bru_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dũ khuon cuti muoi chít coat, la‑a muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Chơ alới aloap khuon chóq tâng crơng rayống ayững yỗn ratớt parnơi. Dũ khuon cóq aloap machớng ki. ");
INSERT INTO bru_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Alới táq bar chít khuon coah angia pưn, ");
INSERT INTO bru_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","cớp táq crơng rayống ayững toâq práq pỗn chít lám, dŏq aloap ayững khuon bar lám muoi khuon. ");
INSERT INTO bru_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Alới táq bar chít khuon dŏq coah angia pỡng Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","cớp pỗn chít crơng rayống ayững toâq práq, bar lám aloap tâng muoi khuon. ");
INSERT INTO bru_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ma yoah clĩ Dống Sang Aroâiq, la yáng angia mandang pât alới táq tapoât khuon, ");
INSERT INTO bru_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","cớp bar khuon dŏq táq soq Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ma khuon táq soq alới patĩng parnơi tễ pưn toau toâq pỡng. Dũ soq khuon noau táq machớng nheq. ");
INSERT INTO bru_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ngkíq toâq amóh parnơi cỡt khuon Dống Sang Aroâiq tacual khuon cớp muoi chít tapoât crơng rayống ayững táq toâq práq; dũ khuon bữn bar lám crơng rayống. ");
INSERT INTO bru_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Alới ĩt aluang a-casia táq prang toar muoi chít la sỡng ntreh. Sỡng ntreh dŏq coah angia pỡng. ");
INSERT INTO bru_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Ma sỡng ntreh ễn dŏq coah angia pưn, cớp sỡng ntreh ễn dŏq yoah clĩ Dống Sang Aroâiq coah angia mandang pât. ");
INSERT INTO bru_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ma bar ntreh prang toar ỡt mpứng dĩ, alới alor tễ pứp nâi chu pứp ki. ");
INSERT INTO bru_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Alới blom khuon cớp táq carvang toâq yễng, dŏq aloap prang toar. Ma prang ki alới blom toâq yễng tê. ");
INSERT INTO bru_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Alới tan muoi ploah aroâiq catáng toâq priei busín o carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu. Cớp alới chún máh rup chê-rup chóq tâng aroâiq ploah ki. ");
INSERT INTO bru_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Alới ayŏ́ng aroâiq catáng toâq canŏ́q yễng, cớp cŏ́q tâng pỗn tanũl aluang a-casia, dếh blom tanũl ki toâq yễng, cớp patứng dŏq tâng crơng rayống ayững táq toâq práq. ");
INSERT INTO bru_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Bân ngoah mut Dống Sang Aroâiq alới táq aroâiq catáng toâq aroâiq busín carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu, dếh chún tâng aroâiq ki. ");
INSERT INTO bru_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Alới táq tanũl toâq aluang a-casia sỡng ntreh cớp canŏ́q dŏq cŏ́q aroâiq catáng. Alới blom toâq yễng tâng pỡng tanũl cớp chóq coom táq toâq yễng, chơ tooc crơng rayống ayững tanũl toâq sapoan dŏq achúh tanũl. ");
INSERT INTO bru_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Be-salen táq Hĩp Parnai Parkhán toâq aluang a-casia, cuti bar coat tadĩ, la‑a muoi coat tadĩ, cớp sarỡih muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Tâng clống cớp yáng tiah hĩp án blom toâq yễng muoi chít, cớp táq racoam hĩp ki toâq yễng tê. ");
INSERT INTO bru_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Án tooc pỗn lám cutũr toâq yễng cớp atớt tâng pỗn ntốq ayững hĩp ki, muoi coah bar lám cutũr dŏq ien crang. ");
INSERT INTO bru_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Án táq bar ntreh cantrang toâq aluang a-casia, cớp blom toâq yễng. ");
INSERT INTO bru_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Án taróc cantrang ki tâng bar coah cutũr hĩp dŏq crang. ");
INSERT INTO bru_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Án táq cantứp hĩp toâq yễng muoi chít, cuti bar coat tadĩ, la‑a muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Án tooc yễng táq bar lám chê-rup, ");
INSERT INTO bru_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","cớp bar lám chê-rup chóq tâng bar pứp hĩp ki, táq yỗn chê-rup cỡt muoi sâiq cớp cantứp hĩp. ");
INSERT INTO bru_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Bar lám chê-rup ki ỡt rato moat cớp paliang khlap yỗn cadớp cantứp hĩp. ");
INSERT INTO bru_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Be-salen táq muoi lám cachơng toâq aluang a-casia, cuti bar coat, la‑a muoi coat, cớp sarỡih muoi coat tadĩ. ");
INSERT INTO bru_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Án blom cachơng ki toâq yễng muoi chít, cớp táq racoam cachơng ki toâq yễng tê. ");
INSERT INTO bru_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Án táq paning toâq yễng sarỡih máh cứm pỗn chũop nheq cachơng, cớp táq racoam yễng tâng paning ki hỡ. ");
INSERT INTO bru_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Án táq pỗn lám carvang yễng cớp chóq carvang tâng pỗn nhoq bân ayững cachơng dŏq crang. ");
INSERT INTO bru_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Carvang ki ratớt cheq racoam dŏq taróc chóq bar ntreh cantrang dŏq khễ crang. ");
INSERT INTO bru_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Án táq bar ntreh cantrang toâq aluang a-casia, cớp blom toâq yễng. ");
INSERT INTO bru_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Máh crơng radỡng dŏq tâc toâq chiau sang blŏ́ng nho yỗn Yiang Sursĩ la neq: Tangan savan cớp tangan chễn, dếh khang cớt cớp cuban hỡ. Nheq tữh crơng nâi án táq toâq yễng muoi chít. ");
INSERT INTO bru_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Be-salen táq muoi lám rông khễ dŏq máh chớp tớu toâq yễng muoi chít. Án tooc ayững cớp tỗ rông ki, dếh rup piar rabỗn cớp paliang. Ma nheq ramứh ki án táq cỡt muoi sâiq sâng. ");
INSERT INTO bru_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Rông ki bữn tapoât tŏ́ng, muoi coah pái tŏ́ng. ");
INSERT INTO bru_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Dũ lám tŏ́ng bữn pái lám rup piar noau dŏq al-mon, dếh rabỗn cớp paliang. ");
INSERT INTO bru_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Tâng tỗ rông ki bữn pỗn rup piar al-mon, dếh rabỗn cớp paliang. ");
INSERT INTO bru_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Bữn muoi rabỗn ỡt pưn dũ cáp tŏ́ng. ");
INSERT INTO bru_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Máh rabỗn cớp tŏ́ng cớp tỗ rông, án tooc toâq yễng muoi chít, yỗn cỡt muoi sâiq. ");
INSERT INTO bru_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Án táq tapul lám chớp tớu dŏq tâng rông ki. Cớp án táq tangcáp takĩap ruaiq chớp tớu, cớp tapuang tadỡng raloiq ruaiq tớu. ");
INSERT INTO bru_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Nheq máh ramứh ki án táq toâq pái chít la sỡng ki-lô yễng muoi chít. ");
INSERT INTO bru_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Be-salen táq prông sang toâq aluang a-casia dŏq tacât crơng phuom. Dũ coah prông ki án táq cuti muoi coat, sarỡih bar coat. Tâng pỗn nhoq prông ki án táq rup tacoi, cớp án táq rup tacoi ki cỡt muoi sâiq cớp prông. ");
INSERT INTO bru_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Án blom prông ki toâq yễng muoi chít tâng pỡng cớp tâng pỗn coah, dếh tâng rup tacoi hỡ. Cớp chũop prông án táq racoam toâq yễng. ");
INSERT INTO bru_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Án táq pỗn lám carvang, cớp chóq carvang ki tâng bar coah yáng pưn racoam, dŏq taróc cantrang ien crang. ");
INSERT INTO bru_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Án táq cantrang ki toâq aluang a-casia, cớp blom toâq yễng. ");
INSERT INTO bru_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Be-salen talốc dỡq nsễng miar, cớp crơng phuom ĩn cũai chiang dốq talốc dỡq phuom. ");
INSERT INTO bru_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Be-salen táq prông sang toâq aluang a-casia. Prông ki án táq cuti sỡng coat, la‑a sỡng coat, cớp sarỡih pái coat. ");
INSERT INTO bru_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Tâng pỡng prông ki án táq rup tacoi tâng pỗn ntốq nhoq, cớp táq rup ki cỡt muoi sâiq cớp prông. Án blom prông ki toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Án táq crơng radỡng ien chóq bŏ́h, cớp táq sán, tangan, canŏ́q, cớp radỡng dŏq rahững ũih. Máh crơng nâi án táq nheq toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Án táq muoi khlễc sapoan hỡng ĩn sara dŏq tâng tapéh ũih. Án chóq crơng ki ỡt coah pưn tambớr prông, cớp ayŏ́ng yỗn ỡt dĩ ria mpứng dĩ prông. ");
INSERT INTO bru_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Án tooc sapoan táq carvang, chơ chóq tâng dũ nhoq. ");
INSERT INTO bru_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Án táq aluang cantrang toâq aluang a-casia ien crang prông, cớp blom toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Chơ án taróc dŏq tâng carvang ỡt bar coah prông ien crang. Án táq prông ki toâq pian, ma tâng mpứng dĩ prông yỗn cỡt taroong. ");
INSERT INTO bru_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Be-salen ĩt kếng loang khong tỗp mansễm ca táq ranáq bân ngoah toong mut Dống Sang Aroâiq, chơ án táq ỗ cớp núc toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Mpễr nchŏh chũop Dống Sang Aroâiq, Be-salen táq toâq aroâiq busín o. Án táq aroâiq catáng lavíng ntốq ki coah angia pưn cuti muoi culám coat; ");
INSERT INTO bru_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","cớp bữn tanũl sapoan bar chít ntreh cớp crơng rayống ayững táq toâq sapoan bar chít lám; cớp án táq canŏ́q cớp lampong práq dŏq taróc tâng aroâiq catáng. ");
INSERT INTO bru_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Coah angia pỡng nchŏh án táq machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Coah angia mandang pât nchŏh án táq aroâiq catáng cuti sỡng chít coat, tanũl muoi chít ntreh, cớp crơng rayống ayững muoi chít lám. Canŏ́q, cớp tong taróc tâng aroâiq catáng ki táq toâq práq. ");
INSERT INTO bru_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Yoah ngoah toong coah angia mandang loŏh aroâiq catáng lavíng nchŏh, án táq la‑a sỡng chít coat machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Dũ coah ngoah toong án táq aroâiq catáng cuti muoi chít la sỡng coat, tanũl pái ntreh, cớp crơng rayống ayững pái lám. ");
INSERT INTO bru_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Nheq tữh aroâiq catáng chũop Dống Sang Aroâiq la táq toâq aroâiq busín o. ");
INSERT INTO bru_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Crơng rayống tanũl án táq toâq sapoan. Ma canŏ́q, tong taróc tâng aroâiq catáng, cớp pứp tanũl án blom toâq práq. Cớp dũ tanũl chũop Dống Sang Aroâiq bân ntốq rato parnơi án chóq coom táq toâq práq. ");
INSERT INTO bru_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ma aroâiq catáng ngoah toong, ki táq toâq aroâiq busín carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu dếh chún hỡ. Aroâiq catáng ki cuti bar chít coat, sarỡih pỗn coat, machớng cớp aroâiq catáng chũop Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Noau tíng aroâiq catáng ki tâng pỗn tanũl cớp bữn pỗn lám crơng aloap ayững. Ma canŏ́q, pứp tanũl, cớp tong ca taróc tâng aroâiq catáng án táq toâq práq. ");
INSERT INTO bru_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nheq tữh lác dŏq téh chũop Dống Sang Aroâiq cớp nchŏh, la táq toâq sapoan. ");
INSERT INTO bru_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ngih máh crơng noau parỗm dŏq táq Dống Sang Aroâiq, la ntốq noau dŏq bar khlễc tamáu khoiq chĩc dŏq máh ŏ́c Yiang Sursĩ patâp. Máh ramứh khoiq táq, Môi-se ớn tỗp Lê-vi ngih, ma I-thamar con samiang Arôn cỡt sốt ranáq ki. Arôn la cũai sốt tỗp tễng rit sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Be-salen con samiang Uri, châu Hơr tễ tỗp Yuda cỡt cũai táq dũ ramứh máh Yiang Sursĩ khoiq patâp yỗn táq. ");
INSERT INTO bru_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ô-hô-liap con samiang Ahi-samac tễ tỗp Dan cỡt cũai chuai ranáq chor pachĩr, aloŏh ngê táq ranáq, khễuq tan aroâiq busín o, cớp tan aroâiq sóc cữu santứm satong, ễng, cớp cusâu. ");
INSERT INTO bru_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nheq tữh yễng alới chiau sang yỗn Yiang Sursĩ dŏq táq Dống Sang Aroâiq, ntâng muoi ngin ki-lô, puai canân tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Práq tễ nheq tữh cũai ca khoiq chĩc ramứh dống sũ, mán ễ bữn pỗn ngin ki-lô, puai canân tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Práq nâi bữn li cớp práq noau chát tễ dũ náq cũai ca chĩc ramứh dống sũ, puai canân tâng dống sang. Nheq tữh cũai samiang tễ bar chít cumo achỗn la 603,550 náq. ");
INSERT INTO bru_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Be-salen ĩt 3,400 ki-lô tễ práq ki táq muoi culám crơng rayống ayững tanũl dŏq patứng Dống Sang Aroâiq cớp aroâiq catáng; muoi lám crơng rayống ayững ntâng pái chít la pỗn ki-lô. ");
INSERT INTO bru_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ma práq bar chít ki-lô noâng clữi, Be-salen dững tooc táq tong taróc aroâiq catáng, táq canŏ́q dŏq yỗn tanũl, cớp blom pứp cớp coom tanũl. ");
INSERT INTO bru_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ma sapoan alới chiau sang yỗn Yiang Sursĩ cân nheq tữh sám 2,425 ki-lô. ");
INSERT INTO bru_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Nheq tữh sapoan nâi ĩt táq neq: Crơng rayống ayững tanũl yáng ngoah toong mut Dống Sang Aroâiq, prông sang, khlễc hỡng ĩn sara dŏq chóq tâng prông, máh crơng radỡng tâng prông ki, ");
INSERT INTO bru_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","crơng rayống ayững chũop Dống Sang Aroâiq, crơng rayống ayững ngoah toong, lác téh bân Dống Sang Aroâiq, cớp nheq tữh lác téh lavíng nchŏh Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Tỗp Be-salen ĩt aroâiq sóc cữu santứm satong, ễng, cớp cusâu táq tampâc yỗn cũai tễng rit sang têq mut táq ranáq Yiang Sursĩ bân Ntốq Tễng Rit. Chơ alới táq tampâc yỗn Arôn machớng Yiang Sursĩ khoiq atỡng na Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Tỗp alới ĩt priei busín cớp dai yễng tan carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu táq aroâiq ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Alới dễr yễng yỗn dang cỡt khlễc cada, cớp cứt cỡt ntreh cacớt ien tan carchốc cớp priei busín, cớp priei sóc cữu santứm satong, ễng, cớp cusâu. ");
INSERT INTO bru_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Alới yĩh bar mễng aroâiq bân apal ê-phot dŏq atớt bar coah au ki. ");
INSERT INTO bru_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Alới ĩt aroâiq busín o, táq aroâiq cantoân ngkĩng cớp táq sanŏ́q aroâiq ê-phot tê; chơ yĩh atớt cớp ê-phot yỗn cỡt muoi sâiq sâng, machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Alới chóq tamáu ramứh o-nic tâng rabŏ́c yễng la carsĩat lứq, ma cũai khễuq chĩc dŏq máh ramứh muoi chít la bar náq con samiang Yacốp tâng tamáu ki. ");
INSERT INTO bru_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Chơ alới atớt tamáu ki tâng apal ê-phot, dŏq táq tếc Yiang Sursĩ sanhữ muoi chít la bar tỗp cũai I-sarel, machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Alới táq aroâiq sadal apơm machớng cớp aroâiq ê-phot, la priei busín o carchốc cớp priei sóc cữu satong, ễng, cusâu, cớp yễng. Cũai chiang ca khễuq táq aroâiq ki. ");
INSERT INTO bru_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Aroâiq sadal apơm alới táq pỗn pứp lĩ-ralĩ, dũ coah muoi satia, chơ calâp bân mpứng dĩ. ");
INSERT INTO bru_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Alới patoi tamáu ngoaih cacoan cỡt pỗn rana tâng aroâiq sadal apơm neq: Rana muoi chóq tamáu moat ramứh rubi, tupat, cớp barũl. ");
INSERT INTO bru_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Rana bar chóq tamáu moat ramứh samar-danô, sapĩr, cớp kim-cưong. ");
INSERT INTO bru_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Rana pái chóq tamáu moat ramứh hua-kin, sar-danuc, cớp amễt. ");
INSERT INTO bru_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Rana pỗn chóq tamáu moat ramứh cru-salit, o-nic, cớp yat-pít. Nheq tữh tamáu ki alới chóq tâng rabŏ́c yễng. ");
INSERT INTO bru_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Muoi chít la bar thữ tamáu nâi alới tốc chĩc máh ramứh con samiang Yacốp, muoi ŏ́c tamáu muoi ramứh dŏq atỡng tễ muoi chít la bar tỗp cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Alới táq sanoâc yễng bar ntreh rapĩal parnơi ariang carsán. ");
INSERT INTO bru_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Alới táq bar lám rabŏ́c yễng, cớp bar ŏ́c carvang yễng, chơ chŏ́q carvang ki tâng bar pứp pỡng tâng aroâiq sadal apơm, ");
INSERT INTO bru_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","dếh chŏ́q bar ntreh sanoâc yễng tâng bar carvang ki. ");
INSERT INTO bru_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Cớp bar pứp sanoâc yễng muoi coah ễn, ki alới atớt tâng bar lám rabŏ́c tâng apal aroâiq ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Alới táq carvang yễng bar ŏ́c, cớp chŏ́q pứp pưn aroâiq sadal apơm yỗn tớt cớp aroâiq ê-phot. ");
INSERT INTO bru_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Alới táq bar ŏ́c ễn carvang yễng, chơ chŏ́q atớt tâng ê-phot cheq santih, ma coah pỡng parnoân ngkĩng. ");
INSERT INTO bru_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Chơ alới chŏ́q aroâiq sadal apơm amóh parnơi cớp aroâiq ê-phot toâq samữ santứm satong, dŏq yỗn aroâiq sadal apơm ratớt pỡng parnoân, táq yỗn án tỡ bữn sarléh, machớng santoiq Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Au tuar cuti tỡ bữn atĩ noau sớp pưn aroâiq ê-phot, bữn cũai chiang tan toâq aroâiq sóc cữu ống santứm satong sâng. ");
INSERT INTO bru_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Alới yĩh tacong au nhưt toâq aroâiq cubân tỡ yỗn án chái raháq. ");
INSERT INTO bru_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","25","Tâng rapóh au tuar alới chún rup palâi ỗiq-tâi toâq priei sóc cữu santứm satong, ễng, cớp cusâu. ");
INSERT INTO bru_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Alới alễu ariu yễng carlán cớp rup ỗiq-tâi, machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Chơ tỗp alới tan au tuar bữn atĩ yỗn Arôn, cớp yỗn máh con samiang án, ");
INSERT INTO bru_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","dếh táq aroâiq pul plỡ, khán-cỡn, cốn alốt, ");
INSERT INTO bru_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","cớp cantoân toâq aroâiq busín o carchốc cớp sóc cữu santứm satong, ễng, cớp cusâu, dếh chún hỡ, táq puai machớng santoiq Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ma crơng pasang cỡt tếc chiau sang, alới táq toâq yễng muoi chít, dếh tốc chĩc santoiq neq: ‘Chiau Sang Yỗn Yiang Sursĩ.’ ");
INSERT INTO bru_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Alới chŏ́q alễu crơng pasang ki yoah moat khán-cỡn toâq samữ santứm satong, táq puai machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Toâq parsốt tháng, ranáq táq Dống Sang Aroâiq moâm chơ. Cũai proai I-sarel khoiq táq puai dũ ramứh machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Alới dững máh crơng ễ táq Dống Sang Aroâiq yỗn Môi-se nhêng, bữn neq: canŏ́q cŏ́q, khuon, prang póc, tanũl, cớp crơng rayống ayững tanũl; ");
INSERT INTO bru_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ngcâr cữu tôl yớm santứm cusâu dŏq acrúq; ngcâr charán languat o dŏq acrúq, cớp aroâiq catáng; ");
INSERT INTO bru_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Hĩp Parnai Parkhán cớp bữn bar khlễc tamáu, cantrang, cớp cantứp hĩp; ");
INSERT INTO bru_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","cachơng cớp máh crơng radỡng tâng cachơng, dếh bễng mi dŏq sang yỗn Yiang Sursĩ; ");
INSERT INTO bru_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","rông tớu táq toâq yễng muoi chít, máh chớp tớu, tớu noau chóq tâng chớp cớp máh crơng radỡng tâng ki; ");
INSERT INTO bru_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","prông sang táq toâq yễng, dỡq nsễng miar dŏq chóh cũai, crơng phuom dŏq chŏ́ng, aroâiq catáng ngoah toong mut chu Dống Sang Aroâiq; ");
INSERT INTO bru_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","prông sapoan dếh khlễc sapoan hỡng ĩn sara dŏq chóq tâng prông, aluang cantrang dếh máh crơng radỡng tâng prông sang; ỗ ien ariau cớp núc dŏq achúh ỗ; ");
INSERT INTO bru_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","aroâiq yoang chũop Dống Sang Aroâiq, tanũl cớp crơng rayống ayững; aroâiq catáng ngoah toong, samữ, lác téh, cớp nheq máh crơng tâc tâng Dống Sang Aroâiq; ");
INSERT INTO bru_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","máh tampâc cũai tễng rit sang, dŏq yỗn Arôn cớp máh con samiang án tâc toâq alới mut táq ranáq tâng Ntốq Tễng Rit. ");
INSERT INTO bru_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Cũai proai I-sarel khoiq táq puai dũ ramứh machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Chơ Môi-se nhêng tutuaiq dũ ramứh; cớp án hữm alới táq puai máh Yiang Sursĩ khoiq ớn alới táq. Ngkíq, Môi-se pai ŏ́c bốn yỗn alới. ");
INSERT INTO bru_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tâng tangái muoi casâi muoi, cóq mới patứng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Cóq mới ĩt Hĩp Parnai Parkhán ca bữn máh ŏ́c cứq patâp, chơ dŏq tâng ntốq ki, cớp yoang aroâiq catáng chíq. ");
INSERT INTO bru_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Dững amut cachơng cớp dŏq máh crơng radỡng tâng cachơng ki. Chơ amut rông tớu, cớp achúh máh chớp tớu tâng rông. ");
INSERT INTO bru_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Cóq mới achúh prông sang táq toâq yễng yáng moat Hĩp Parnai Parkhán, dŏq tacât crơng phuom sang yỗn Yiang Sursĩ, cớp yoang aroâiq catáng ngoah toong mut pỡ ntốq ramóh cứq. ");
INSERT INTO bru_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Yáng moat ntốq ki, cóq mới achúh prông dŏq bốh crơng sang. ");
INSERT INTO bru_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ma ỗ noau chóq dỡq ien ariau, cóq mới achúh dŏq bân mpứng dĩ bar coah Ntốq Tễng Rit cớp prông sang, cớp ŏh dỡq chóq tâng ki. ");
INSERT INTO bru_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Cóq mới táq aroâiq catáng chũop nheq Dống Sang Aroâiq, cớp táq aroâiq catáng bân ngoah toong. ");
INSERT INTO bru_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Chơ chiau sang Dống Sang Aroâiq cớp nheq tữh máh crơng radỡng noau dŏq tâng Dống Sang Aroâiq ki, na ĩt dỡq nsễng miar atia tâng dũ ramứh ki dŏq cỡt crơng miar yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Cóq mới chiau sang prông cớp crơng radỡng noau dŏq tâng prông yỗn Yiang Sursĩ, na ĩt dỡq nsễng miar atia tâng dũ ramứh ỡt tâng prông dŏq cỡt crơng miar yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Cóq mới chiau sang ỗ cớp núc, na táq machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Cóq mới yỗn noau dững Arôn cớp máh con samiang án toâq pỡ ngoah toong mut Dống Sang Aroâiq, cớp atỡng alới yỗn mpơi dỡq dŏq sambráh tỗ chác yỗn bráh. ");
INSERT INTO bru_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Vớt ki asớp tampâc cũai tễng rit sang yỗn Arôn, cớp ĩt dỡq nsễng miar hĩng tâng plỡ án táq tếc chiau tỗ án dŏq táq ranáq cứq na cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Chơ dững máh con samiang án ễn toâq, cớp asớp tampâc yỗn alới. ");
INSERT INTO bru_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Moâm ki ĩt dỡq nsễng miar, hĩng tâng plỡ alới táq machớng cớp mpoaq alới tê. Ranáq nâi cỡt tếc cứq khoiq rưoh tỗp alới cỡt cũai tễng rit sang mantái níc.” ");
INSERT INTO bru_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Môi-se táq puai dũ ramứh machớng Yiang Sursĩ khoiq patâp án. ");
INSERT INTO bru_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Yuaq ngkíq, tâng tangái muoi, casâi muoi, cumo bar vớt tỗp alới loŏh tễ cruang Ê-yip-tô, alới ayứng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Môi-se achúh crơng rayống ayững tanũl, achúh khuon, aloap prang póc, cớp patứng tanũl. ");
INSERT INTO bru_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Án paliang aroâiq, chơ acrúq Dống Sang Aroâiq; moâm ki ĩt ngcâr ễn acrúq yáng tiah, táq puai machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Án dững bar khlễc tamáu ki dŏq tâng Hĩp Parnai Parkhán. Án taróc cantrang tâng hĩp ki cớp ĩt cantứp, chơ catứp. ");
INSERT INTO bru_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Án dững hĩp ki dŏq pỡ Dống Sang Aroâiq, cớp án yoang aroâiq catáng chíq Hĩp Parnai Parkhán, táq puai machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Án achúh cachơng dŏq tâng Ntốq Tễng Rit coah avêr, yáng tiah aroâiq catáng Ntốq Yiang Sursĩ Ỡt, ");
INSERT INTO bru_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","cớp án ĩt bễng mi achúh tâng pỡng cachơng dŏq sang yỗn Yiang Sursĩ, táq puai machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ma rông tớu án achúh dŏq tâng Ntốq Tễng Rit coah angia pưn, choâng-rachoâng cớp cachơng. ");
INSERT INTO bru_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Án achúh cớp tacât máh chớp tớu ki choâng moat Yiang Sursĩ, machớng Yiang Sursĩ khoiq patâp dŏq chơ. ");
INSERT INTO bru_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Án achúh prông yễng choâng moat aroâiq catáng Ntốq Yiang Sursĩ Ỡt, ");
INSERT INTO bru_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","cớp án tacât crơng phuom tâng prông ki, táq puai machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Án yoang aroâiq catáng bân ngoah toong mut Ntốq Tễng Rit tâng Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","cớp án achúh prông sang dŏq bốh charán yáng tiah tâng nchŏh Dống Sang Aroâiq. Ma tâng prông sang án bốh charán dŏq chiau sang cớp chiau sang máh thữ racáu, táq puai machớng Yiang Sursĩ khoiq patâp. ");
INSERT INTO bru_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Án achúh ỗ ien ariau dŏq bân mpứng dĩ Dống Sang Aroâiq cớp prông sang, cớp ŏh dỡq chóq tâng ki. ");
INSERT INTO bru_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Môi-se cớp Arôn, dếh máh con samiang Arôn, alới ariau ayững atĩ alới tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Dũ trỗ alới ễ mut chu Dống Sang Aroâiq, tỡ la toâq pỡ ntốq prông sang, ki cóq alới ariau ayững atĩ, táq puai machớng Yiang Sursĩ khoiq patâp. ");
INSERT INTO bru_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Môi-se tíng aroâiq savĩel Dống Sang Aroâiq cớp prông sang. Cớp án yoang aroâiq catáng ngoah mut chu nchŏh Dống Sang Aroâiq. Táq ngkíq, án táq dũ ramứh cỡt moâm nheq. ");
INSERT INTO bru_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Vớt ki bữn ramứl clũom nheq Dống Sang Aroâiq, cớp poang ang‑ữr tễ Yiang Sursĩ claq chũop nheq Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ngkíq Môi-se tỡ têq mut chu ki, yuaq ramứl sễng clũom tâng ki, cớp poang ang‑ữr tễ Yiang Sursĩ claq chũop nheq Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Toâq ramứl ki chỗn tễ Dống Sang Aroâiq, máh cũai I-sarel atỡi ntốq ỡt chu canŏ́h ễn. ");
INSERT INTO bru_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Bo léq ma noâng bữn ramứl ỡt clũom tâng ntốq ki, alới tỡ bữn dễq chu léq. ");
INSERT INTO bru_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Dũ ntốq alới pỡq, khân tangái, ki alới bữn hữm níc ramứl ỡt rayư pỡng Dống Sang Aroâiq. Ma khân sadâu, alới hữm ũih blữ tâng sapom ramứl ki.");
INSERT INTO bru_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yiang Sursĩ arô Môi-se tễ Dống Sang Aroâiq, cớp án ");
INSERT INTO bru_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","ớn Môi-se pỡq atỡng cũai I-sarel yỗn táq puai máh phễp rit nâi toâq alới táq rit chiau sang. Án pai neq: “Toâq bữn cũai tễ tỗp anhia dững crơng chiau sang yỗn Yiang Sursĩ, cóq alới dững charán tễ tỗp charán alới; têq alới chiau ntroŏq, cữu, tỡ la mbễq. ");
INSERT INTO bru_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Khân cũai ki dững muoi lám ntroŏq tôl dŏq bốh chiau sang, ntroŏq ki cóq ŏ́q bân tĩq. Cóq án dững charán ki pỡ ngoah toong mut Dống Sang Aroâiq pỡ ntốq ramóh cứq, dŏq cứq roap ĩt tễ ranáq án chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Cũai ca dững charán ki cóq satoaq atĩ tâng plỡ charán ki; chơ cứq roap ĩt charán ki cỡt crơng chiau sang dŏq pupứt lôih cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Cóq án dững kiac ntroŏq tôl bân ntốq ki toâp; chơ máh cũai tễ tŏ́ng toiq Arôn ca cỡt cũai tễng rit sang Yiang Sursĩ cóq ĩt aham charán ki chiau sang yỗn Yiang Sursĩ, cớp tốh aham bân pỗn ntốq nhoq prông yáng ngoah toong mut Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Cóq án satac aloŏh nheq ngcâr charán, cớp cŏ́h cỡt dỗt. ");
INSERT INTO bru_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Máh con samiang Arôn ca cỡt cũai tễng rit sang cóq bốq ũih tâng prông sang cớp palư hỡ. ");
INSERT INTO bru_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Chơ tỗp alới cóq ĩt máh cốc sâiq, dếh plỡ cớp nsễng, bốh nheq tâng ũih. ");
INSERT INTO bru_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ma cóq alới ariau yỗn bráh máh crơng clống cớp nlu, chơ cũai tễng rit sang cóq bốh nheq máh crơng ki tâng prông. Hỡi phuom chanchức tễ crơng chiau sang táq yỗn Yiang Sursĩ bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Khân crơng noau dững bốh dŏq chiau sang la charán cữu, tỡ la mbễq, cóq án ĩt charán tôl plứm cớp ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Cóq án kiac charán ki coah angia pỡng prông sang, cớp máh cũai tễng rit sang cóq tốh aham charán ki bân nheq pỗn coah prông. ");
INSERT INTO bru_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Moâm ki cóq án cŏ́h sâiq charán cỡt dỗt, chơ cũai tễng rit sang cóq ĩt máh sâiq nâi adỗt tâng pỡng nlũiq ũih cớp bốh dếh plỡ cớp nsễng. ");
INSERT INTO bru_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Máh crơng clống cớp nlu, cóq cũai ca dững chiau sang ariau yỗn bráh; chơ cũai tễng rit sang cóq ĩt nheq máh crơng ki bốh sang yỗn Yiang Sursĩ tâng prông sang ki. Hỡi phuom chanchức tễ crơng chiau ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Khân cũai aléq ma chiau sang chớm dŏq cỡt crơng bốh sang, cóq án ĩt chớm tariap tỡ la chớm tapâr. ");
INSERT INTO bru_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Cũai tễng rit sang Yiang Sursĩ cóq dững chớm ki pỡ prông sang, chơ tavĩat tacong chớm ki yỗn cuchĩt. Moâm tavĩat, chơ án kiac yỗn aham loŏh kễng prông. Chơ án bốh plỡ chớm tâng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Cóq án ĩt aloŏh pliem, cớp pũiq nheq sóc, chơ táh bân coah angia mandang loŏh tễ prông ki pỡ ntốq noau tốh bŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Cóq án cáh khlap chớm ki aloŏh, ma tỡ yỗn ratáh tễ tỗ; chơ yỗn cũai tễng rit sang bốh chớm ki tâng prông sang. Hỡi phuom chanchức tễ crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Khân cũai aléq dững máh thữ racáu chiau sang yỗn Yiang Sursĩ, cóq án cliet yỗn cỡt bỗt, chóq dỡq nsễng o‑li‑vê, cớp chóq crơng phuom hỡ. ");
INSERT INTO bru_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Cóq án dững yỗn cũai tễ tŏ́ng toiq Arôn ca cỡt cũai tễng rit sang, chơ cóq cũai ki ĩt muoi carpỗt bỗt cớp dỡq nsễng, cớp nheq crơng phuom. Án ca tễng rit sang cóq dững muoi carpỗt crơng ki, chơ bốh tâng prông dŏq sang yỗn Yiang Sursĩ. Hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ma máh thữ racáu noâng clữi cỡt pún cũai tễng rit sang Yiang Sursĩ, cớp cỡt crơng miar noau bốh chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Khân anhia dững chiau sang bễng padễng tâng lo, cóq táq bễng ŏ́q crơng pluoih, chơ carchốc cớp dỡq nsễng o‑li‑vê; tỡ la táq bễng cada, chơ chóq dỡq nsễng o‑li‑vê tâng bễng tê. ");
INSERT INTO bru_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Khân anhia dững crơng chiau sang cỡt bễng áng tâng noang, cóq anhia táq toâq bỗt carchốc cớp dỡq nsễng o‑li‑vê cớp ŏ́q crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Cóq pĩh bễng mi ki cỡt mễng ngcớt, chơ atia chóq dỡq nsễng toâq anhia ễ dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Khân anhia ễ dững chiau sang bễng ễh tâng adéh atháh, cóq táq toâq bỗt carchốc cớp dỡq nsễng o‑li‑vê, chơ dững ễh. ");
INSERT INTO bru_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Dững bễng ki chiau sang yỗn Yiang Sursĩ, chơ chiau pỡ cũai tễng rit sang yỗn án dững chóq tâng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ma cũai tễng rit sang Yiang Sursĩ, án ĩt muoi pún tễ crơng chiau sang ki bốh tâng prông sang. Hỡi phuom chanchức tễ crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Máh crơng noâng clữi cỡt pún cũai tễng rit sang Yiang Sursĩ; crơng ki cỡt crơng miar dŏq chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Máh thữ racáu anhia dững chiau sang yỗn Yiang Sursĩ, cóq tỡ bữn bữn crơng pluoih. Chỗi chiau sang crơng sana ma bữn crơng pluoih, tỡ la chiau sang dỡq khĩal yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Têq anhia dững bar ramứh nâi bo anhia dững máh palâi anhia ĩt dâu lứq dŏq chiau sang yỗn Yiang Sursĩ, ma crơng sang nâi chỗi bốh tâng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Cóq anhia chóq boi tâng dũ thữ racáu, yuaq boi ki cỡt tếc tễ ŏ́c anhia parkhán cớp Yiang Sursĩ. Cóq anhia ĩt boi chóq tâng crơng sang dũ ramứh. ");
INSERT INTO bru_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Toâq anhia ĩt máh thữ racáu anhia ĩt dâu lứq ễ dững chiau sang yỗn Yiang Sursĩ, cóq anhia sỗng tâng ũih, tỡ la cliet yỗn abuoiq voai, moâm ki dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Cóq anhia chóq dỡq nsễng o‑li‑vê cớp chóq crơng phuom tâng crơng ễ chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Cũai tễng rit sang Yiang Sursĩ cóq bốh muoi pún tễ máh bỗt cớp dỡq nsễng, cớp nheq crơng phuom ễ chiau sang yỗn Yiang Sursĩ dŏq puai rit chiau sang sana. ");
INSERT INTO bru_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Khân cũai aléq ma ễ chiau sang muoi lám charán dŏq cỡt ratoi, cóq án ĩt tễ tỗp charán án bữm ntroŏq tôl tỡ la ntroŏq cán ŏ́q bân tĩq, cớp dững chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Cóq án satoaq atĩ tâng plỡ charán cớp kiac charán ki bân ngoah toong mut Dống Sang Aroâiq. Cũai tễng rit sang tễ tŏ́ng toiq Arôn cóq ĩt aham ntroŏq ki, chơ tốh nheq pỗn nhoq prông sang. ");
INSERT INTO bru_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Chơ cóq cũai ca dững charán chiau sang máh cốc sâiq yỗn Yiang Sursĩ puai rit chiau sang crơng sana, dếh nheq tữh nsễng tớt tâng crơng clống, ");
INSERT INTO bru_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","bar ŏ́c carchễl cớp máh nsễng tớt tâng ki, cớp luam lia. ");
INSERT INTO bru_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Cũai tễng rit sang cóq bốh nheq máh crơng nâi tâng prông, cớp crơng chiau sang canŏ́h hỡ. Hỡi phuom chanchức tễ crơng sana chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Khân cũai aléq ma dững crơng chiau sang dŏq cỡt ratoi, cóq án ĩt con cữu tỡ la mbễq tễ máh mbễq tôl tỡ la cán ca ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Khân án ễ chiau sang muoi lám con cữu yỗn Yiang Sursĩ, ");
INSERT INTO bru_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","cóq án satoaq atĩ tâng plỡ cữu cớp kiac charán ki coah moat Dống Sang Aroâiq. Chơ máh cũai tễng rit sang cóq ĩt aham cữu ki tốh tâng pỗn nhoq prông sang, ");
INSERT INTO bru_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","cớp chiau sang máh cốc sâiq charán ki yỗn Yiang Sursĩ, puai rit chiau sang crơng sana; cóq án blac nheq nsễng tớt bân soi cớp nghang cloong, ");
INSERT INTO bru_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","máh nsễng pul crơng clống, bar ŏ́c carchễl cớp nsễng tớt tâng ki hỡ, dếh luam lia. ");
INSERT INTO bru_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Cóq cũai tễng rit sang ĩt máh crơng ki bốh nheq tâng prông sang, dŏq cỡt crơng sana chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Khân án ễ chiau sang yỗn Yiang Sursĩ muoi lám mbễq, ");
INSERT INTO bru_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","cóq án satoaq atĩ tâng plỡ mbễq cớp kiac mbễq ki yáng moat Dống Sang Aroâiq. Chơ máh cũai tễng rit sang tễ tŏ́ng toiq Arôn cóq ĩt aham mbễq ki tốh tâng pỗn nhoq prông sang, ");
INSERT INTO bru_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","cớp chiau sang máh cốc sâiq charán ki bốh cỡt crơng chiau sang yỗn Yiang Sursĩ, dếh máh nsễng pul crơng clống, ");
INSERT INTO bru_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","bar ŏ́c carchễl dếh nsễng tớt tâng ki cớp luam lia hỡ. ");
INSERT INTO bru_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Cớp cũai tễng rit sang Yiang Sursĩ cóq bốh máh crơng ki tâng prông sang, dŏq hỡi phuom tễ máh crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. Nheq tữh nsễng la khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Chỗi yỗn dũ dỡi cũai tễ tỗp I-sarel cha nsễng tỡ la aham. Nâi la rit cuang tỗp I-sarel cóq táq puai níc, tam tỗp alới ỡt pỡ ntốq léq.” ");
INSERT INTO bru_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","atỡng cũai I-sarel neq: “Khân bữn cũai aléq táq lôih cớp talốh santoiq Yiang Sursĩ patâp, ma án táq lơ sâng, cóq án táq puai máh phễp rit nâi. ");
INSERT INTO bru_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Khân cũai sốt tỗp tễng rit sang Yiang Sursĩ ma táq lôih, la machớng án dững ŏ́c lôih atoâq pỡ cũai proai. Khân án ễq yỗn pứt máh ranáq lôih án khoiq táq, cóq án ĩt muoi lám ntroŏq tôl ŏ́q bân tĩq dững chiau sang yỗn Yiang Sursĩ dŏq án táh lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Cóq án dững ntroŏq tôl ki pỡ ngoah toong mut pỡ Dống Sang Aroâiq, cớp satoaq atĩ tâng plỡ ntroŏq ki, chơ kiac yáng moat Yiang Sursĩ bân ntốq ki toâp. ");
INSERT INTO bru_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Cũai sốt tỗp tễng rit sang Yiang Sursĩ cóq ĩt aham dững amut tâng Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","chơ alốq ndễm atĩ tâng aham, cớp trutrếh tapul taláp yáng moat aroâiq catáng Ntốq Cứq Ỡt. ");
INSERT INTO bru_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Cóq án ĩt aham bĩq ễn apĩac bân pỗn nhoq prông ca chŏ́ng crơng phuom tâng Dống Sang Aroâiq pỡ Ntốq Tễng Rit. Aham noâng clữi, cóq án tốh bân ayững prông noau dốq bốh crơng sang. Prông sang nâi ỡt yáng ngoah toong mut ntốq ki. ");
INSERT INTO bru_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Cóq án blac nheq máh nsễng ntroŏq ki, dếh nsễng pul crơng clống, ");
INSERT INTO bru_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","bar ŏ́c carchễl, cớp luam lia. ");
INSERT INTO bru_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Cũai tễng rit sang cóq blac aloŏh máh nsễng ki bốh tâng prông, dŏq cỡt crơng chiau sang machớng án táq chóq nsễng charán noau kiac dŏq chiau sang yỗn cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ma ngcâr, sâiq, plỡ, nlu, cớp máh crơng clống, ");
INSERT INTO bru_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","cóq án crang aloŏh nheq tễ ntốq alới ỡt, pỡ ntốq khoiq sambráh, chơ tốh tâng ũih yỗn cat nheq. ");
INSERT INTO bru_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Khân nheq tữh cũai I-sarel lơ táq lôih cớp táq claiq santoiq Yiang Sursĩ patâp, lứq pai alới tỡ bữn dáng, ma noâng alới bữn lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Chơ toâq alới dáng bữn lôih, cóq tỗp I-sarel dững muoi lám ntroŏq tôl chiau sang dŏq Yiang Sursĩ pupứt lôih alới. Cóq tỗp alới dững ntroŏq ki pỡ Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Máh cũai sốt tỗp I-sarel cóq toâq satoaq atĩ tâng plỡ ntroŏq ki, cớp kiac yáng moat Yiang Sursĩ bân ntốq ki loâng. ");
INSERT INTO bru_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Chơ cũai sốt tỗp tễng rit sang Yiang Sursĩ cóq ĩt bĩq aham amut tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Cóq án alốq ndễm atĩ tâng aham ki, chơ trutrếh tapul taláp choâng aroâiq catáng Ntốq Cứq Ỡt. ");
INSERT INTO bru_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Cóq án apĩac aham tâng pỗn nhoq prông sang noau chóq dŏq crơng phuom tâng Ntốq Tễng Rit, ma aham clữi, cóq án tốh tâng ayững prông noau dốq bốh crơng chiau sang, yáng tiah ngoah toong mut Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Chơ cũai sốt tỗp tễng rit sang cóq blac aloŏh nheq máh nsễng, chơ dững bốh tâng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Cóq án táq ntroŏq nâi machớng án khoiq táq ntroŏq án dững chiau sang dŏq pupứt lôih án bữm. Cóq án táq machớng nâi tê toâq án dững crơng chiau sang dŏq pupứt lôih cũai proai. Chơ nheq tữh cũai proai bữn racláh tễ lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Chơ cóq án ĩt ntroŏq ki, crang dững bốh yáng tiah ntốq ỡt, machớng án bốh ntroŏq dŏq pupứt lôih án bữm. Ranáq nâi la rit chiau sang dŏq pupứt lôih máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Khân muoi noaq cũai sốt ma lơ táq lôih na án táq claiq santoiq Yiang Sursĩ khoiq patâp, ki án lứq bữn lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Toâq án dáng tễ máh ranáq án táq lôih, cóq án dững chiau sang yỗn Yiang Sursĩ muoi lám mbễq tôl ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Cóq án satoaq atĩ tâng plỡ mbễq ki, cớp kiac mbễq ki yáng angia coah pỡng prông, la ntốq khoiq anoat yỗn kiac charán dŏq chiau sang pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Cóq cũai tễng rit sang alốq ndễm atĩ án tâng aham, chơ apĩac tâng pỗn nhoq prông sang. Ma aham noâng clữi, cóq án tốh tâng ayững prông sang ki. ");
INSERT INTO bru_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Cớp cóq án bốh nheq máh nsễng tâng prông, machớng án dốq bốh nsễng dŏq cỡt ratoi tê. Cũai tễng rit sang Yiang Sursĩ cóq táq ngkíq dŏq chiau crơng sang dŏq pupứt lôih cũai sốt. Chơ cũai sốt bữn racláh tễ lôih án. ");
INSERT INTO bru_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Khân bữn muoi noaq cũai proai lơ táq lôih, cớp táq claiq santoiq Yiang Sursĩ patâp, ki án lứq bữn lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Toâq án dáng tễ ranáq án khoiq táq lôih, cóq án ĩt muoi lám mbễq cán ŏ́q bân tĩq dŏq cỡt crơng chiau sang yỗn pupứt máh lôih án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Cóq án satoaq atĩ tâng plỡ mbễq ki, cớp kiac mbễq ki yáng angia pỡng prông sang, la ntốq khoiq anoat yỗn kiac charán dŏq chiau sang pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Cũai tễng rit sang cóq alốq ndễm atĩ án tâng aham ki, chơ apĩac tâng pỗn nhoq prông sang, cớp tốh aham noâng clữi tâng ayững prông sang ki. ");
INSERT INTO bru_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Chơ cóq án blac aloŏh nheq máh nsễng, machớng án blac nsễng charán án khoiq kiac chiau sang dŏq cỡt ratoi tê. Moâm ki, cóq án bốh nheq máh nsễng ki tâng prông sang. Hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. Machớng nâi tê cũai tễng rit sang Yiang Sursĩ chiau sang dŏq pupứt lôih cũai ki, chơ cũai ki têq racláh tễ lôih án. ");
INSERT INTO bru_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Khân bữn muoi noaq samiang ma dững cữu chiau sang dŏq pupứt lôih, cóq án dững chiau sang yỗn Yiang Sursĩ muoi lám cữu cán con ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Cóq án satoaq atĩ tâng plỡ cữu cán ki, cớp kiac yáng angia pỡng prông sang bân ntốq khoiq anoat yỗn kiac charán dŏq chiau sang pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Cũai tễng rit sang cóq alốq ndễm atĩ tâng aham ki, chơ apĩac tâng pỗn nhoq prông sang. Aham noâng clữi, cóq án tốh tâng ayững prông. ");
INSERT INTO bru_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Chơ cóq án blac aloŏh nheq nsễng, táq machớng án khoiq blac ĩt nsễng cữu noau dững kiac chiau sang dŏq cỡt ratoi ki tê. Chơ, ĩt máh nsễng ki dững bốh tâng prông sang dŏq cỡt crơng sang yỗn Yiang Sursĩ. Machớng ki tê, cũai tễng rit sang táq dŏq pupứt lôih alới khoiq táq. Chơ cũai ki bữn racláh tễ lôih án. ");
INSERT INTO bru_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Cóq cũai chiau sang dŏq pupứt lôih, khân án táq neq: Khân cũai rasữq arô yỗn án toâq atỡng parnai, ma án tỡ ễq atỡng ŏ́c án dáng, tỡ la hữm, tỡ la sâng, ki án lứq bữn lôih. ");
INSERT INTO bru_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Khân cũai aléq ma lơ satoaq crơng tỡ bữn bráh puai phễp rit, dếh máh sac charán, ki án cỡt tỡ bữn bráh puai rit cớp bữn lôih toâq án bữn dáng tễ ranáq lôih án táq. ");
INSERT INTO bru_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Khân cũai aléq ma lơ satoaq cũai tỡ bữn bráh puai phễp rit, ki án lứq bữn lôih tê toâq án bữn dáng tễ ranáq lôih án táq. ");
INSERT INTO bru_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Khân bữn cũai loar bỗq thễ dũan, tam ŏ́c ntrớu án thễ, o tỡ la sâuq, ki án lứq bữn lôih tê toâq án sanhữ loah tễ ranáq án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Toâq bữn cũai táq lôih, cóq án ngin kho máh ŏ́c lôih án táq; ");
INSERT INTO bru_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","cớp cóq án roap tôt tễ ranáq lôih ki; cóq án dững muoi lám cữu cán, tỡ la muoi lám mbễq cán chiau sang yỗn Yiang Sursĩ. Táq ngkíq, cũai tễng rit sang Yiang Sursĩ têq chiau sang dŏq pupứt lôih cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Khân muoi noaq cũai ma cadĩt lứq, ŏ́q cữu tỡ la mbễq, cóq án dững chớm tariap tỡ la bar lám chớm tapâr chiau sang yỗn Yiang Sursĩ dŏq pláih máh ranáq lôih án táq, muoi lám dŏq chiau sang pupứt lôih, muoi lám ễn dŏq bốh chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Cóq án dững chớm lám muoi pỡ cũai tễng rit sang dŏq táq rit pupứt lôih. Cũai tễng rit sang ki cóq tavĩat tacong chớm, chơ kiac, ma tỡ yỗn satáiq tễ tỗ; ");
INSERT INTO bru_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","cớp cóq án trutrếh bĩq aham yáng coah prông sang. Ma aham clữi, cóq án tốh tâng ayững prông. Nâi la ranáq tễ rit sang dŏq pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Cóq án bốh chớm lám bar puai rit bốh chiau sang yỗn Yiang Sursĩ. Cũai tễng rit sang cóq táq ngkíq dŏq chiau sang pupứt lôih cũai canŏ́h. Chơ cũai ki têq racláh tễ ŏ́c lôih án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Khân cũai aléq ma cadĩt lứq, ŏ́q chớm tariap tỡ la chớm tapâr ễ dững chiau sang, cóq cũai ki dững bỗt o lứq muoi ki-lô chiau sang yỗn Yiang Sursĩ dŏq pupứt lôih án. Ma tỡ bữn túh cóq án chóq dỡq nsễng o‑li‑vê tỡ la crơng phuom, cỗ ranáq chiau sang nâi la dŏq pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Cóq án dững bỗt ki yỗn cũai tễng rit sang ĩt muoi carpỗt bỗt, dŏq cỡt tếc chiau sang yỗn Yiang Sursĩ. Cớp cũai tễng rit sang cóq bốh muoi carpỗt bỗt ki tâng prông sang, dŏq táq rit chiau sang crơng sana. Nâi la ranáq chiau sang crơng yỗn têq racláh tễ ŏ́c lôih án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Cũai tễng rit sang cóq táq ngkíq dŏq chiau sang pupứt lôih cũai; chơ cũai ki têq racláh tễ ŏ́c lôih án khoiq táq. Bỗt noâng clữi, cỡt khong cũai tễng rit sang, machớng cớp ranáq chiau sang máh thữ racáu tê.” ");
INSERT INTO bru_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yiang Sursĩ atỡng phễp rit canŏ́h ễn yỗn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Khân bữn cũai tễ anhia ma lơ táq lôih, cỗ án khlĩr yỗn pỡ Yiang Sursĩ crơng án par‑ữq dŏq miar khong Yiang Sursĩ, cóq án dững muoi lám cữu tôl tỡ la mbễq tôl ŏ́q bân tĩq, chơ chiau sang yỗn Yiang Sursĩ dŏq pláih lôih án. Ma kia charán ki cóq li cớp kia noau khoiq anoat tâng dống sang tê. ");
INSERT INTO bru_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Cóq án culáh kia machớng crơng án tỡ bữn yỗn, cớp cóq án yỗn tữm ễn bar pún tễ muoi chít pún. Cóq án culáh crơng nâi yỗn cũai tễng rit sang, chơ cũai tễng rit sang ki cóq chiau sang charán dŏq pláih loah lôih án. Chơ án têq racláh tễ ŏ́c lôih án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Khân bữn cũai aléq lơ táq lôih, na táq claiq santoiq Yiang Sursĩ patâp, ki án lứq bữn ŏ́c lôih cớp cóq roap tôt. ");
INSERT INTO bru_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Cóq án dững chiau sang yỗn Yiang Sursĩ muoi lám cữu tôl tỡ la muoi lám mbễq tôl ŏ́q bân tĩq. Ma kia charán ki cóq li cớp kia khoiq noau anoat tâng dống sang. Cũai tễng rit sang táq rit chiau sang dŏq pláih loah lôih yỗn cũai ki. Chơ cũai ki têq racláh tễ ŏ́c lôih án lơ táq. ");
INSERT INTO bru_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Nâi la ranáq chiau sang yỗn Yiang Sursĩ dŏq pláih loah lôih.” ");
INSERT INTO bru_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yiang Sursĩ atỡng phễp rit canŏ́h ễn yỗn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Khân cũai aléq ma táq lôih chóq Yiang Sursĩ na án tỡ bữn culáh loah máh crơng yớu cơiq pỡ án, tỡ la án tuoiq ĩt muoi ramứh ntrớu tễ alới, tỡ la lôp alới, ");
INSERT INTO bru_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","tỡ la táq ntỡng lauq tễ crơng pứt pai án tỡ bữn hữm. ");
INSERT INTO bru_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Khân bữn cũai aléq ma táq lôih ĩn santoiq khoiq pai ki, cóq án culáh loah dũ máh ramứh án khoiq tuoiq ĩt, tỡ la crơng pứt án khoiq ramóh, ");
INSERT INTO bru_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","tỡ la ŏ́c ntrớu án táq ntỡng lauq. Cóq án culáh loah dũ yỗn cũai ndỡm tâng tangái án chiau sang dŏq pláih loah lôih, cớp yỗn tữm ễn bar pún tễ muoi chít pún. ");
INSERT INTO bru_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Cóq án dững muoi lám cữu tôl, tỡ la muoi lám mbễq tôl ŏ́q bân tĩq yỗn cũai tễng rit sang Yiang Sursĩ, dŏq táq rit chiau sang pláih lôih án. Ma kia charán ki cóq li cớp kia khoiq anoat dŏq tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Cũai tễng rit sang cóq táq rit dŏq pupứt lôih, chơ cũai ki têq racláh tễ lôih án khoiq táq.” ");
INSERT INTO bru_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yiang Sursĩ ớn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Cóq mới pỡq atỡng Arôn cớp tỗp con samiang án, yỗn alới táq puai máh phễp rit nâi tễ ranáq bốh charán dŏq chiau sang. Crơng bốh sang cóq achúh dŏq tâng prông sang pông brang, cớp yỗn ũih blữ níc. ");
INSERT INTO bru_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Chơ cũai tễng rit sang cóq sớp au tuar cớp dŏ́ng cốn alốt táq toâq aroâiq busín, cớp cóq án sŏ́c bŏ́h aloŏh tễ tapéh án bốh crơng tâng prông sang, chơ dững dŏq kễng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Moâm ki, cóq cũai tễng rit sang tâc tampâc canŏ́h, chơ dững tốh bŏ́h ki yáng tiah ntốq alới ỡt, bân ntốq khoiq sambráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Cóq nhêng ũih tâng prông yỗn blữ níc, chỗi yỗn pât. Tâng dũ tarưp cũai tễng rit sang cóq bốq ũih tâng prông sang, thrũan crơng sang cớp bốh nsễng chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Cóq nhêng ũih yỗn blữ níc tâng prông sang, chỗi yỗn pât. ");
INSERT INTO bru_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Nâi la rit chiau sang máh thữ racáu. Cũai tễng rit sang tễ tŏ́ng toiq Arôn, cỡt cũai táq rit chiau sang máh thữ racáu yỗn Yiang Sursĩ yáng moat prông sang. ");
INSERT INTO bru_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Chơ muoi noaq cũai tễng rit sang cóq ĩt muoi carpỗt bỗt cớp dỡq nsễng o‑li‑vê, cớp nheq crơng phuom, chơ pỡq bốh tâng prông sang dŏq cỡt tếc apáh nheq tữh crơng ki khoiq chiau sang yỗn Yiang Sursĩ. Chơ hỡi phuom chanchức tễ crơng sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ma crơng sana noâng clữi têq cũai tễng rit sang cha. ");
INSERT INTO bru_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Cóq táq bễng mi ŏ́q crơng pluoih bân nchŏh Dống Sang Aroâiq, chơ cha bân ki toâp. Yiang Sursĩ khoiq yỗn crơng chiau sang noâng clữi ki cỡt khong cũai tễng rit sang. Machớng cớp crơng chiau sang dŏq pupứt lôih, tỡ la crơng chiau sang dŏq pláih ranáq lôih, nheq crơng ki cỡt khong cứq. ");
INSERT INTO bru_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Toâq dũ dỡi dũ thrap, con châu samiang tễ tŏ́ng toiq Arôn têq ĩt cha muoi pún tễ sana noau chiau sang yỗn Yiang Sursĩ. Khân cũai canŏ́h satoaq crơng sana ki, án cóq ramóh ŏ́c túh coat ntâng lứq, yuaq sana ki cỡt miar khong Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yiang Sursĩ atỡng ŏ́c patâp nâi yỗn Môi-se: ");
INSERT INTO bru_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Toâq anhia ễ chóh cũai tễng rit sang ato loah tễ tŏ́ng toiq Arôn, tâng tangái ki cóq án chiau sang bỗt o lứq muoi ki-lô yỗn Yiang Sursĩ (sa‑ữi bĩq la machớng cớp ranáq án dốq chiau sang máh thữ racáu cu rangái). Cóq án yỗn tadĩ bỗt ki tâng pên tarưp, ma tadĩ ễn tâng pên tabữ. ");
INSERT INTO bru_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Cóq carchốc bỗt ki cớp dỡq nsễng o‑li‑vê, chơ áng tâng noang tac, cớp pĩh cỡt ngcớt, dŏq yỗn hỡi tễ crơng chiau sang máh thữ racáu phuom chanchức táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Dũ dỡi dũ thrap cóq bữn cũai tễ tŏ́ng toiq Arôn cỡt sốt máh cũai tễng rit sang, cóq táq puai níc rit chiau sang nâi. Cóq án bốh máh crơng nâi chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Máh thữ racáu cũai tễng rit sang chiau, cóq bốh táh nheq; tỡ têq cha muoi ramứh ntrớu.” ");
INSERT INTO bru_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yiang Sursĩ ớn Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Cóq mới atỡng Arôn cớp tỗp con samiang án, yỗn alới táq puai níc phễp rit chiau sang dŏq pupứt lôih neq: Charán noau ễ dững chiau sang dŏq pupứt lôih, cóq kiac yáng angia pỡng prông sang, la ntốq dốq kiac charán dŏq bốh sang. Crơng chiau sang ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Cũai tễng rit sang ca táq rit chiau sang cóq cha sâiq charán ki bân nchŏh Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Khân cũai aléq tỡ la acán ntrớu ma tatũih sâiq ki, cóq án roap tôt ntâng lứq. Khân aham charán ki pardáih pĩeiq tampâc, cóq án pooh tampâc ki tâng ntốq ki toâp. ");
INSERT INTO bru_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Adéh cutễq léq ma ớp sâiq ki, cóq pieih táh chíq. Ma khân adéh ki táq toâq tac tỡ la sapoan, cóq sat, chơ ariau yỗn bráh. ");
INSERT INTO bru_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Cũai samiang dũ náq tễ tŏ́ng toiq Arôn têq cha sâiq khoiq chiau sang. Sâiq nâi la cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ma crơng chiau sang dŏq pupứt lôih, ca cũai tễng rit sang ĩt aham dững amut tâng Dống Sang Aroâiq, sâiq ki tỡ têq cha, cóq bốh táh nheq. ");
INSERT INTO bru_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Nâi la ŏ́c patâp tễ ranáq chiau sang dŏq pláih loah lôih. Ranáq ki cỡt ranáq chiau sang miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Charán ễ chiau sang pláih loah lôih cóq kiac yáng angia pỡng prông sang, bân ntốq dốq kiac charán dŏq sang; cớp cóq tốh aham charán tâng pỗn coah prông sang. ");
INSERT INTO bru_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Cóq blac aloŏh máh nsễng charán ki chiau sang nheq tâng prông sang, dếh nsễng tâng soi cớp nsễng tớt tâng crơng clống, ");
INSERT INTO bru_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","bar ŏ́c carchễl dếh nsễng tớt tâng ki hỡ, cớp luam lia. ");
INSERT INTO bru_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Cũai tễng rit sang cóq bốh máh nsễng ki tâng prông sang dŏq cỡt crơng sang yỗn Yiang Sursĩ. Anâi la rit chiau sang dŏq pláih loah lôih cũai. ");
INSERT INTO bru_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Cũai samiang dũ náq tễ dống sũ Arôn têq cha máh sâiq charán khoiq chiau sang, ma cóq cha bân ntốq miar, yuaq crơng sana ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Muoi phễp rit cóq tâc toâq chiau sang dŏq pupứt lôih cớp chiau sang dŏq pláih lôih. Sâiq charán chiau sang ki cỡt khong cũai tễng rit sang ca táq rit chiau sang ki. ");
INSERT INTO bru_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Cũai tễng rit sang aléq ma táq rit chiau sang bốh charán, têq án ĩt ngcâr charán ki cỡt khong án. ");
INSERT INTO bru_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Dũ máh thữ racáu ễ chiau sang ca noau padễng tâng lo, ễh tâng adéh atháh, tỡ la áng tâng noang tac, crơng ki cỡt khong cũai tễng rit sang ca táq rit chiau sang ki. ");
INSERT INTO bru_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ma bỗt noâng cláu, dếh bỗt khoiq talốc cớp dỡq nsễng, tỡ la noâng khỗ, bỗt ki cỡt khong tỗp tễng rit sang tễ tŏ́ng toiq Arôn, chơ cóq alới tampễq lĩ-ralĩ nheq. ");
INSERT INTO bru_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Nâi la máh phễp rit tễ ranáq chiau sang yỗn Yiang Sursĩ dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Khân bữn muoi noaq cũai ma ễ dững crơng chiau sang yỗn Yiang Sursĩ dŏq sa‑ỡn án chuai, cóq án dững parnơi cớp charán dŏq kiac chiau sang la neq: Bễng mi ŏ́q crơng pluoih, bễng táq toâq bỗt mi carchốc cớp dỡq nsễng o‑li‑vê, tỡ la bễng khlễc cada atia chóq dỡq nsễng o‑li‑vê, tỡ la bễng cỡt khlễc táq toâq bỗt carchốc cớp dỡq nsễng o‑li‑vê. ");
INSERT INTO bru_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ma cóq án dững dếh bễng mi khoiq chóq crơng pluoih hỡ toâq chiau sang, dếh dững charán chiau sang sa‑ỡn Yiang Sursĩ hỡ. ");
INSERT INTO bru_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Cóq án dững muoi pún bễng mi tễ dũ ramứh ki dŏq chiau sang yỗn Yiang Sursĩ; chơ bễng mi ki cỡt khong cũai tễng rit sang ca ĩt aham charán tốh tâng ayững prông sang. ");
INSERT INTO bru_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Sâiq charán chiau sang dŏq cỡt ratoi cóq cũai ki cha tâng tangái ki toâp; chỗi dŏq loah toau tarưp parnỡ. ");
INSERT INTO bru_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Khân cũai chiau sang ễ táq puai loah santoiq án khoiq par‑ữq, tỡ la án bữn mứt pahỡm chống yoc ễ chiau sang, yỗn noau cha crơng chiau sang tâng tangái táq rit ki toâp. Ma khân noâng clữi, têq án dŏq cha tangái parnỡ. ");
INSERT INTO bru_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Sâiq noâng clữi toâq tangái pái, cóq bốh táh chíq. ");
INSERT INTO bru_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Khân cũai aléq ĩt cha sâiq ki tâng tangái pái, ngkíq Yiang Sursĩ tỡ bữn roap ĩt ranáq cũai ki chiau sang, yuaq ranáq chiau sang ki cỡt ranáq tỡ bữn bráh puai phễp rit. Ngkíq ranáq chiau sang nâi tỡ bữn cỡt ranáq o, tỡ la pĩeiq mứt pahỡm, cớp cũai ca cha sâiq ki, án roap tôt bữm. ");
INSERT INTO bru_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Sâiq charán ma tớt crơng tỡ bữn bráh puai rit, sâiq ki tỡ têq cha, cóq bốh táh chíq. “Cũai aléq khoiq bráh puai rit, ki têq án cha sâiq ki, ");
INSERT INTO bru_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ma khân cũai aléq tỡ bữn bráh puai rit cha sâiq ki, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Machớng ki tê, khân cũai aléq ma satoaq crơng tỡ bữn bráh puai rit, tỡ bữn pai cũai tỡ la charán, ma cha sâiq chiau sang dŏq cỡt ratoi, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yiang Sursĩ aloŏh phễp rit nâi yỗn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","atỡng cũai I-sarel táq puai neq: “Chỗi cha nsễng ntroŏq, nsễng cữu, cớp nsễng mbễq. ");
INSERT INTO bru_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Nsễng charán cuchĩt bữm, tỡ la charán cruang cáp cuchĩt, têq anhia ĩt táq ranáq canŏ́h, ma anhia tỡ têq cha. ");
INSERT INTO bru_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Khân cũai aléq ĩt cha nsễng khoiq bốh chiau sang yỗn Yiang Sursĩ, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ma hỡn tễ ki ễn, cũai I-sarel dũ náq tỡ têq ĩt aham chớm tỡ la aham charán dŏq cỡt crơng sana. ");
INSERT INTO bru_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Khân cũai aléq ma táq ngkíq, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yiang Sursĩ chiau phễp rit nâi ");
INSERT INTO bru_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","yỗn Môi-se atỡng cũai proai I-sarel táq puai la neq: “Khân cũai aléq ma dững crơng chiau sang dŏq cỡt ratoi, cóq cũai ki dững crơng muoi pún dŏq chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Cóq tỗ án toâp dững crơng ki puai rit chiau sang crơng sana, cớp cóq án dững dếh nsễng cớp sâiq apơm dŏq apỗng chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Cũai tễng rit sang cóq bốh nsễng ki tâng prông, ma sâiq apơm ki cỡt khong cũai tễng rit sang tễ tỗp Arôn. ");
INSERT INTO bru_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Nlu coah atoam cóq cỡt crơng mpon yỗn ");
INSERT INTO bru_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","cũai tễng rit sang ca táq rit chiau sang aham cớp nsễng, táq puai rit chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Yuaq sâiq apơm cớp sâiq nlu coah atoam ca cũai I-sarel chiau dŏq cỡt ratoi, cứq chiau máh ramứh nâi yỗn tỗp cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Máh ramứh nâi khoiq cỡt pún Arôn cớp tỗp con samiang án tâng tangái noau chóh alới cỡt cũai tễng rit sang Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yiang Sursĩ patâp máh cũai I-sarel cóq yỗn crơng ki pỡ cũai tễng rit sang Yiang Sursĩ, tâng tangái noau chóh tỗp alới cỡt cũai tễng rit sang; chơ cóq alới táq puai níc nneq dũ thrap dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Nheq tữh nâi la phễp rit bốh crơng dŏq chiau sang, chiau sang máh thữ racáu, chiau sang dŏq pupứt lôih, chiau sang dŏq pláih loah lôih, chiau sang dŏq chóh cũai tễng rit sang, cớp chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Máh phễp rit nâi Yiang Sursĩ patâp Môi-se tâng cóh Si-nai pỡ ntốq aiq tâng tangái án atỡng cũai proai I-sarel yỗn dững crơng toâq chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yiang Sursĩ pai chóq Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Dững Arôn cớp máh con samiang án toâq pỡ ngoah toong Dống Sang Aroâiq. Cớp dững tampâc khoiq táq dŏq yỗn cũai tễng rit sang, dỡq nsễng miar dŏq chóh cũai, muoi lám ntroŏq tôl dŏq chiau sang pupứt lôih, bar lám cữu tôl, cớp muoi crưo bễng mi ŏ́q crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Chơ arô nheq tữh cũai I-sarel toâq rôm parnơi pỡ ntốq ki.” ");
INSERT INTO bru_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Môi-se táq puai machớng Yiang Sursĩ ớn án. Tữ cũai proai toâq rôm parnơi, ");
INSERT INTO bru_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","chơ án pai chóq tỗp alới neq: “Nâi la máh ranáq Yiang Sursĩ ớn anhia táq puai.” ");
INSERT INTO bru_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moâm ki, Môi-se dững Arôn cớp máh con samiang Arôn loŏh tayứng yoah moat cũai clứng, cớp yỗn alới táq rit mpơi dỡq dŏq cỡt bráh. ");
INSERT INTO bru_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Moâm alới mpơi dỡq, Môi-se ĩt au nhưt cớp au tuar asớp yỗn Arôn, cớp catoân parnoân yỗn án. Chơ Môi-se asớp aroâiq ê-phot, cớp ĩt parnoân táq toâq aroâiq busín o dŏq catoân tữm ễn. ");
INSERT INTO bru_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Chơ Môi-se ĩt aroâiq sadal apơm bữn Urim cớp Thumim chóq tâng ki. ");
INSERT INTO bru_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Chơ án apưng khán-cỡn tâng plỡ Arôn, cớp ĩt khlễc yễng ca cỡt tếc, chơ alễu coah moat khán-cỡn, machớng Yiang Sursĩ khoiq patâp dŏq chơ. ");
INSERT INTO bru_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Môi-se ĩt dỡq nsễng miar, chơ hĩng tâng Dống Sang Aroâiq Yiang Sursĩ, cớp tâng dũ ramứh crơng ỡt tâng ki. Án táq ngkíq yỗn crơng ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Án ĩt bĩq dỡq nsễng miar, chơ trutrếh tapul trỗ tâng prông cớp tâng crơng radỡng tâng prông sang, tâng ỗ cớp tâng núc dŏq chiau sang máh crơng nâi yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Chơ án hĩng dỡq nsễng tâng plỡ Arôn dŏq táq tếc án chóh Arôn cỡt cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moâm ki, Môi-se dững máh con samiang Arôn ễn loŏh tayứng yoah moat cũai clứng, chơ án ĩt au tuar asớp yỗn alới. Án ĩt aroâiq catoân tâng ngkĩng alới, cớp ĩt khán-cỡn apưng tâng plỡ alới, táq puai machớng Yiang Sursĩ khoiq patâp dŏq. ");
INSERT INTO bru_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Chơ Môi-se dững ntroŏq tôl táq rit chiau sang dŏq pupứt lôih Arôn cớp máh con samiang án; chơ án yỗn alới satoaq atĩ tâng plỡ ntroŏq. ");
INSERT INTO bru_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Môi-se kiac ntroŏq ki cớp ĩt muoi pún aham, chơ alốq ndễm atĩ tâng aham cớp apĩac tâng prông bân pỗn nhoq dŏq sambráh prông yỗn cỡt bráh puai rit. Chơ án tốh aham noâng clữi tâng ayững prông. Machớng ki tê án táq rit chiau sang prông dŏq táq bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Môi-se ĩt máh nsễng ntroŏq tâng crơng clống, luam lia, cớp bar ŏ́c carchễl, chơ án bốh máh crơng ki tâng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ma crơng canŏ́h, ngcâr, sâiq, cớp máh crơng clống, án dững bốh yáng tiah ntốq alới ỡt, puai machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Chơ án dững cữu tôl cỡt crơng bốh chiau sang. Arôn cớp máh con samiang Arôn satoaq atĩ tâng plỡ charán ki. ");
INSERT INTO bru_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Chơ Môi-se kiac cữu ki, cớp trutrếh aham tâng pỗn coah prông sang. ");
INSERT INTO bru_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Moâm án cŏ́h cữu ki cỡt mễng, chơ án bốh plỡ cớp nsễng. ");
INSERT INTO bru_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Chơ án ĩt dỡq ariau máh crơng clống cớp nlu, chơ án bốh nheq tâng prông sang, táq puai machớng Yiang Sursĩ khoiq patâp chơ. Hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Moâm ki, Môi-se dững cữu tôl canŏ́h, dŏq táq rit chiau sang dŏq chóh cũai tễng rit sang. Arôn cớp máh con samiang án satoaq atĩ tâng plỡ charán ki, ");
INSERT INTO bru_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","chơ Môi-se kiac cữu ki cớp ĩt aham apĩac tâng sala cutũr Arôn coah atoam, tâng ndễm ngcứm atĩ coah atoam, cớp tâng ndễm ngcứm ayững coah atoam. ");
INSERT INTO bru_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Chơ án dững máh con samiang Arôn loŏh yoah moat cũai clứng, cớp apĩac aham tâng sala cutũr tỗp alới coah atoam, tâng ndễm ngcứm atĩ alới coah atoam, cớp tâng ndễm ngcứm ayững alới coah atoam. Aham noâng clữi, án trutrếh bân pỗn coah prông sang. ");
INSERT INTO bru_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Chơ án ĩt nsễng cớp nsễng tâng soi, nsễng tâng crơng clống, luam lia, bar ŏ́c carchễl cớp nsễng tâng ki, cớp nlu coah atoam. ");
INSERT INTO bru_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Chơ án ĩt muoi lám bễng mi ŏ́q crơng pluoih tễ crưo noau chiau sang yỗn Yiang Sursĩ; muoi lám khoiq noau ễh tâng nsễng, cớp muoi khlễc bễng cada án achúh tâng pỡng nsễng, cớp tâng pỡng nlu coah atoam. ");
INSERT INTO bru_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Án ĩt máh crơng nâi chóq tâng atĩ Arôn cớp atĩ máh con samiang Arôn, chơ yỗn alới apỗng chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Chơ Môi-se ĩt máh crơng ki tễ atĩ alới, cớp dững bốh tâng prông sang; án achúh crơng ki tâng pỡng crơng khoiq bốh nhũang. Nâi la ranáq chóh máh cũai tễng rit sang, cỡt ranáq chiau sang sana. Chơ hỡi phuom chanchức tễ crơng sana ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Chơ Môi-se ĩt sâiq apơm apỗng chiau sang yỗn Yiang Sursĩ. Sâiq nâi cỡt khong Môi-se, yuaq án táq rit chóh cũai tễng rit sang. Án táq dũ ramứh machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Môi-se ĩt dỡq nsễng miar cớp aham tễ prông, chơ án trutrếh tâng tỗ Arôn cớp máh con samiang Arôn, cớp án trutrếh tâng tampâc tỗp alới hỡ. Machớng nâi tê, án táq rit chiau sang tỗp alới cớp tampâc alới tâc yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Môi-se pai chóq Arôn cớp tỗp con samiang Arôn neq: “Cóq anhia ớp sâiq pỡ ngoah toong Dống Sang Aroâiq; chơ ĩt cha cớp bễng mi tễ crưo. Nâi la rit chóh cũai tễng rit sang, táq puai machớng Yiang Sursĩ khoiq patâp chơ. ");
INSERT INTO bru_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Sâiq cớp bễng mi noâng clữi, cóq bốh táh chíq. ");
INSERT INTO bru_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Chơ nheq tữh anhia cóq ỡt cheq ngoah toong mut chu Dống Sang Aroâiq nheq tapul tangái, toau rit chóh cỡt moâm tháng. ");
INSERT INTO bru_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Máh ranáq tỗp hái táq tâng tangái nâi, Yiang Sursĩ toâp patâp yỗn tỗp hái táq, dŏq pupứt ŏ́c lôih tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Cóq anhia ỡt tâng Dống Sang Aroâiq tapul sadâu tapul tangái, táq puai machớng Yiang Sursĩ khoiq patâp. Khân anhia tỡ bữn táq puai, anhia cóq cuchĩt. Nâi la ranáq cứq roap tễ Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Yuaq ngkíq, Arôn cớp máh con samiang án táq puai machớng Yiang Sursĩ patâp na Môi-se dũ ramứh. ");
INSERT INTO bru_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Toâq moâm nheq máh tangái chóh cũai tễng rit sang, Môi-se arô Arôn cớp máh con samiang Arôn, cớp máh cũai sốt tỗp I-sarel hỡ yỗn toâq ramóh án. ");
INSERT INTO bru_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Án atỡng Arôn neq: “Cóq mới ĩt muoi lám ntroŏq tôl cớp cữu tôl ŏ́q bân tĩq, dững chiau sang yỗn Yiang Sursĩ. Ntroŏq tôl cóq chiau sang dŏq pupứt lôih; ma cữu tôl cóq bốh chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Chơ atỡng máh cũai I-sarel cóq alới ĩt muoi lám mbễq tôl dững chiau sang dŏq pupứt lôih alới; cớp ĩt dững dếh muoi lám ntroŏq tôl cớp muoi lám cữu tôl mbỡiq muoi cumo dŏq bốh chiau sang. Nheq tữh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Cóq alới chiau sang muoi lám ntroŏq cớp muoi lám cữu tôl cớp máh bỗt carchốc cớp dỡq nsễng o‑li‑vê dŏq táq rit yỗn cỡt ratoi. Cóq alới táq ngkíq, yuaq Yiang Sursĩ ễ toâq sapáh yỗn alới tâng tangái nâi toâp.” ");
INSERT INTO bru_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ngkíq alới ĩt dũ ramứh machớng Môi-se atỡng, chơ pỡq tayứng yáng moat Dống Sang Aroâiq, cớp nheq tữh alới toâq rôm parnơi dŏq sang toam Yiang Sursĩ tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Môi-se pai neq: “Ranáq nâi Yiang Sursĩ toâp patâp anhia dũ náq cóq táq puai, dŏq têq Yiang Sursĩ apáh ang‑ữr tễ án yỗn tỗp anhia.” ");
INSERT INTO bru_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Chơ Môi-se ớn Arôn neq: “Cóq mới pỡq toâq pỡ prông sang, cớp chiau sang crơng táq rit dŏq pupứt lôih, dếh táq rit bốh chiau sang dŏq pupứt lôih tỗp anhia cớp cũai proai. Cóq anhia dững máh crơng cũai proai ễ chiau sang dŏq pupứt lôih tỗp alới, machớng Yiang Sursĩ khoiq patâp.” ");
INSERT INTO bru_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ngkíq, Arôn pỡq chu prông sang, cớp kiac ntroŏq tôl cỡt crơng sang dŏq pupứt lôih án bữm. ");
INSERT INTO bru_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Máh con samiang án dững aham; chơ Arôn alốq ndễm atĩ tâng aham chơ apĩac tâng prông sang bân pỗn nhoq; chơ án tốh aham noâng clữi tâng ayững prông. ");
INSERT INTO bru_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Án bốh nsễng, bar ŏ́c carchễl cớp luam lia tâng prông sang, táq puai machớng Yiang Sursĩ khoiq patâp na Môi-se. ");
INSERT INTO bru_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Sâiq cớp ngcâr ki án dững bốh yáng tiah ntốq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Arôn kiac charán dŏq bốh chiau sang; máh con samiang án ĩt aham cớp dững pỡ án; chơ án ĩt aham ki trutrếh tâng pỗn coah prông sang. ");
INSERT INTO bru_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Máh con samiang án dững plỡ cớp máh pún canŏ́h yỗn án, chơ án dững bốh tâng prông sang. ");
INSERT INTO bru_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Arôn ariau máh crơng clống cớp nlu charán, chơ án bốh muoi prớh cớp crơng chiau sang tâng prông ki. ");
INSERT INTO bru_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Vớt ki, Arôn chiau sang crơng chuai cũai proai. Án dững mbễq ca cũai proai ễ chiau sang dŏq pupứt lôih, chơ án kiac mbễq ki cớp táq rit chiau sang dŏq pupứt lôih alới, machớng án khoiq táq rit dŏq pupứt lôih án bữm. ");
INSERT INTO bru_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Cớp án dững bar lám charán ki pỡq bốh puai phễp rit dũ ramứh. ");
INSERT INTO bru_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Án chiau sang máh thữ racáu, na ĩt muoi carpỗt bỗt, chơ bốh tâng prông sang. (Ranáq chiau sang nâi la tữm ễn tễ ranáq chiau sang alới táq cu tarưp.) ");
INSERT INTO bru_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Án kiac ntroŏq tôl cớp cữu tôl yỗn máh cũai proai dŏq chiau sang yỗn cỡt ratoi. Máh con samiang án dững aham pỡ án, chơ án trutrếh aham ki tâng pỗn coah prông sang. ");
INSERT INTO bru_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Arôn ĩt nsễng ntroŏq cớp cữu ");
INSERT INTO bru_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","achúh tâng pỡng sâiq apơm charán, cớp dững nheq tữh crơng ki pỡ prông sang. Án bốh máh nsễng ki tâng prông sang, ");
INSERT INTO bru_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ma sâiq apơm cớp nlu coah atoam, ki án apỗng chiau sang yỗn Yiang Sursĩ, cỡt pún cũai tễng rit sang, machớng Môi-se khoiq patâp dŏq chơ. ");
INSERT INTO bru_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Toâq Arôn táq rit chiau sang máh ramứh ki khoiq moâm chơ, án sacỡ atĩ achỗn cớp pai ŏ́c bốn yỗn máh cũai proai; chơ án sễng tễ ntốq prông sang. ");
INSERT INTO bru_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Chơ Môi-se cớp Arôn mut chu Dống Sang Aroâiq. Toâq alới loŏh tễ clống ki, alới pai ŏ́c bốn puan yỗn máh cũai proai. Chơ poang ang‑ữr tễ Yiang Sursĩ sapáh mpứng dĩ máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Bo ki toâp, Yiang Sursĩ táq yỗn ũih sễng tễ paloŏng chŏ́ng cat nheq máh crơng chiau sang, cớp máh nsễng tâng prông. Tữ nheq tữh cũai proai hữm ranáq ki, tỗp alới hễr cu‑ỗi casang cớp pũp mieiq tớt cutễq. ");
INSERT INTO bru_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadap cớp Abi-hu, bar náq con samiang Arôn, alới dững chô alới bữm, cớp chóq rahững ũih tâng ki. Chơ alới yữi crơng phuom tâng ki, cớp dững chiau sang yỗn Yiang Sursĩ. Ma Yiang Sursĩ tỡ bữn ớn alới táq ngkíq. ");
INSERT INTO bru_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Bo ki toâp, Yiang Sursĩ táq yỗn ũih sễng chŏ́ng cat chíq alới yỗn cuchĩt yáng moat án. ");
INSERT INTO bru_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Chơ Môi-se pai chóq Arôn neq: “Yiang Sursĩ pai neq: ‘Dũ náq cũai ca táq ranáq cứq cóq yám noap ŏ́c bráh o tễ cứq. Cứq ễ yỗn cũai proai cứq bữn hữm chớc ang‑ữr tễ cứq.’” Arôn sâng dớt lứq, toau táq ntỡng ntrớu la tỡ luoh noâng. ");
INSERT INTO bru_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Môi-se arô Mi-sel cớp El-saphan, bar náq con samiang Usiel, bac Arôn, cớp atỡng alới neq: “Cóq anhia mut cheq, cớp crang aloŏh cumuiq sễm ai anhia tễ Dống Sang Aroâiq, chơ pỡq dŏq yáng tiah ntốq hái ỡt.” ");
INSERT INTO bru_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ngkíq alới toâq yống tampâc cũai cuchĩt, chơ crang cumuiq ki loŏh yáng tiah ntốq ỡt; alới táq machớng Môi-se khoiq ớn. ");
INSERT INTO bru_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moâm ki, Môi-se pai chóq Arôn cớp bar náq canŏ́h con samiang Arôn, la E-lia-sơ cớp I-thamar neq: “Nheq tữh anhia chỗi prai sóc tỡ la háq tampâc bữm, dŏq apáh anhia tanúh. Khân anhia táq ngkíq, anhia cóq cuchĩt cớp Yiang Sursĩ bữn cutâu mứt chóq nheq tữh cũai proai. Ma máh sễm ai cũai I-sarel canŏ́h têq tanúh cũai ca Yiang Sursĩ cachĩt na ũih ki. ");
INSERT INTO bru_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Cóq anhia ỡt voai; chỗi loŏh tễ ngoah toong Dống Sang Aroâiq; khân tỡ bữn ngkíq, anhia lứq cuchĩt, cỗ noau khoiq hĩng dỡq nsễng chóh anhia dŏq cỡt cũai tễng rit sang Yiang Sursĩ.” Yuaq ngkíq, alới táq puai santoiq Môi-se atỡng. ");
INSERT INTO bru_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yiang Sursĩ atỡng Arôn neq: ");
INSERT INTO bru_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Toâq mới, tỡ la máh con samiang mới, mut tâng Dống Sang Aroâiq, chỗi nguaiq blŏ́ng nho tỡ la máh blŏ́ng canŏ́h; khân anhia táq clốq, anhia cóq cuchĩt. Nheq tữh ŏ́c patâp nâi, cóq tŏ́ng toiq anhia táq puai níc dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Cóq anhia chỗi nguaiq blŏ́ng dŏq anhia têq rưoh tễ crơng dŏq miar khong Yiang Sursĩ, cớp crơng cũai dốq tâc sâng; tễ crơng bráh cớp crơng tỡ bữn bráh puai phễp rit. ");
INSERT INTO bru_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Cóq anhia arĩen cũai proai I-sarel yỗn dáng nheq tễ ŏ́c patâp cứq chiau yỗn anhia na Môi-se.” ");
INSERT INTO bru_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Môi-se pai chóq Arôn cớp bar náq con samiang Arôn, la E-lia-sơ cớp I-thamar, neq: “Cóq anhia ĩt dững achu máh thữ racáu clữi tễ chiau sang yỗn Yiang Sursĩ, chơ táq bễng mi ŏ́q crơng pluoih, cớp cha pỡ kễng prông sang; yuaq crơng chiau sang nâi cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Cóq anhia cha bân ntốq miar, yuaq cỡt pún anhia bữn tễ crơng chiau sang yỗn Yiang Sursĩ. Nâi la ranáq Yiang Sursĩ patâp cứq. ");
INSERT INTO bru_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ma mới cớp nheq dống sũ mới têq cha sâiq apơm ca apỗng achỗn cớp sâiq nlu ca khoiq dŏq miar khong Yiang Sursĩ; pún ki cỡt pún cũai tễng rit sang. Anhia têq cha dũ ntốq khoiq bráh puai phễp rit. Máh crơng chiau sang nâi, chiau yỗn mới cớp tŏ́ng toiq mới, la pún anhia bữn roap tễ cũai proai I-sarel chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Cóq tỗp alới ĩt sâiq nlu cớp sâiq apơm toâq alới dững bốh nsễng, chơ apỗng chiau sang yỗn Yiang Sursĩ. Nâi la pún mới cớp tŏ́ng toiq mới mantái níc, machớng Yiang Sursĩ khoiq patâp chơ.” ");
INSERT INTO bru_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Môi-se blớh loah tễ sâiq mbễq chiau sang dŏq pupứt lôih, chơ án dáng mbễq ki khoiq noau bốh nheq chơ. Ngkíq Môi-se nhôp E-lia-sơ cớp I-thamar cớp blớh alới neq: ");
INSERT INTO bru_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Cỗ nŏ́q anhia tỡ bữn cha sâiq chiau sang dŏq pupứt lôih bân nchŏh dống sang? Sâiq ki la crơng sana miar khong Yiang Sursĩ, cớp Yiang Sursĩ khoiq chiau yỗn tỗp anhia cha sâiq noau chiau sang dŏq pupứt lôih cũai proai. ");
INSERT INTO bru_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Cỗ tian anhia tỡ bữn dững aham charán ki amut tâng Dống Sang Aroâiq, pĩeiq lứq cóq anhia cha crơng sana ki tâng nchŏh dống sang loâng, ariang cứq khoiq ớn chơ.” ");
INSERT INTO bru_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Arôn ta‑ỡi neq: “Tangái nâi khân cứq cha crơng chiau sang dŏq pupứt lôih, ki Yiang Sursĩ sâng bũi chóq cứq tỡ? Tangái nâi cũai proai dững crơng chiau sang dŏq pupứt lôih, cớp tỗp alới dững crơng bốh chiau sang tê. Tam alới khoiq táq ngkíq, ma ranáq túh ngua lứq nâi noâng toâq pỡ cứq.” ");
INSERT INTO bru_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Toâq Môi-se sâng ngkíq, án sâng ien loah. ");
INSERT INTO bru_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yiang Sursĩ chiau phễp rit yỗn Môi-se cớp Arôn, ");
INSERT INTO bru_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","yỗn alới atỡng loah máh cũai proai I-sarel neq: “Máh charán ỡt tâng cutễq, ");
INSERT INTO bru_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","anhia têq cha máh charán bữn canchop parcáh cớp cacap loah. ");
INSERT INTO bru_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Ma anhia chỗi cha charán lac‑da, patut, tỡ la catai. Máh charán nâi bữn canchop parcáh, ma bỗq án tỡ bữn cacap loah. Ngkíq, máh charán nâi tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Chỗi cha sâiq alic, yuaq án cỡt charán tỡ bữn bráh puai rit. Án la charán bữn canchop parcáh, ma án tỡ bữn cacap. ");
INSERT INTO bru_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Chỗi cha máh charán tỗp ki, dếh chỗi satoaq sac án hỡ, yuaq máh charán ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Anhia têq cha sĩaq dũ ramứh bữn canchíh cớp nsễl, ");
INSERT INTO bru_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ma chỗi cha dũ ramứh tamoong tâng dỡq ma ŏ́q canchíh cớp nsễl, ");
INSERT INTO bru_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","yuaq máh charán nâi tỡ bữn o cớp tỡ bữn bráh puai rit. Chỗi cha charán máh charán ki; chỗi satoaq dếh sac charán ki. ");
INSERT INTO bru_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Anhia chỗi cha dũ ramứh charán ỡt tâng dỡq ma ŏ́q canchíh cớp nsễl. ");
INSERT INTO bru_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","“Cớp anhia chỗi cha dũ ramứh chớm ariang neq: Calang aváq, curóq, calang crức, calang cloc, adoc, calang tapâr, ca‑ac, carcũoc, cangcot, boiq panang, plức, cuoq, akễng, atia dỡq, sambĩr cuti, tỡ la asĩap. ");
INSERT INTO bru_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Mpông dũ ramứh ca bữn khlap, la tỡ bữn bráh puai rit, ");
INSERT INTO bru_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ma têq anhia cha máh ramứh ca têq vuat. ");
INSERT INTO bru_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Têq anhia cha lam, abrĩt, tỡ la tier. ");
INSERT INTO bru_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ma máh ramứh mpông canŏ́h ca bữn khlap, cớp talor, tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","“Khân cũai aléq ma satoaq sac charán khoiq cuchĩt, cũai ki cỡt tỡ bữn bráh puai rit toau toâq sadâu. Charán ki la neq: Dũ ramứh charán tỡ bữn canchop parcáh cớp dũ ramứh charán tỡ bữn cacap, cớp máh charán bữn pỗn ayững cớp bữn crễh. Cũai aléq ma crang sac charán ki cóq pooh tampâc, cớp noâng tỡ bữn bráh toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“Máh charán cớt ca pỡq tâng cutễq la tỡ bữn bráh puai rit. Máh charán ki la neq: Cupi, cunâi ngcoong, cunâi cuyĩ, tru, racot, tóc-kễ, cuyŏ́ng, satễn, taluaq, cỗi. ");
INSERT INTO bru_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Cũai aléq ma satoaq máh charán nâi, tỡ la sac án, cũai ki cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Toâq máh charán ki cuchĩt, ma pĩeiq án catễt muoi ramứh ntrớu, ramứh ki cỡt tỡ bữn bráh puai rit, tỡ bữn pai aluang, tampâc tâc, ngcâr charán, tỡ la bau, anhia chỗi ĩt tâc dŏq táq ranáq ntrớu. Cóq yớr tâng dỡq, ma noâng tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Khân sac charán ki satooh pĩeiq tâng adéh cutễq bữn raveh, dũ ramứh tâng adéh la cỡt tỡ bữn bráh nheq; cóq pieih táh chíq adéh ki. ");
INSERT INTO bru_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Crơng sana ca cơi cha, ma nsâu raveh tễ adéh ki satooh pĩeiq sana ki cóq tốh táh, yuaq án cỡt tỡ bữn bráh puai rit; acán ntrớu ma hũiq tễ adéh ki cỡt tỡ bữn bráh tê. ");
INSERT INTO bru_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Khân sac charán cuchĩt ma satooh pĩeiq tâng acán ntrớu, acán ki cỡt tỡ bữn bráh, tỡ bữn pai adéh sa-áp, tỡ la tapéh ũih, cóq pieih táh nheq. ");
INSERT INTO bru_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ma khân pĩeiq sac charán satooh tâng amống dỡq mec tỡ la dỡq chứng dŏq tâng culũng, dỡq ki noâng bráh puai rit; ma cũai aléq satoaq sac ki cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Khân bữn sac charán satooh tâng cuplốq ễ dững trứh, cuplốq ki noâng bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ma khân cuplốq ki noau yớr chơ, ma bữn sac charán satooh chóq, cuplốq ki cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Khân charán anhia têq cha ma cuchĩt bữm, cũai aléq ma satoaq sac charán ki cỡt tỡ bữn bráh toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Khân cũai aléq ma ĩt cha muoi pún ntrớu tễ sac charán, cóq án pooh tampâc án, chơ cỡt tỡ bữn bráh toau toâq sadâu. Cũai aléq ma crang sac charán cuchĩt, cóq án pooh tampâc, ma án tỡ bữn bráh toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Anhia chỗi cha máh charán talor tâng cloong cutễq, ");
INSERT INTO bru_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","cớp anhia chỗi cha dũ ramứh charán talor na púng, tỡ la na pỗn ayững, tỡ la na sa‑ữi ayững, yuaq máh charán ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Anhia chỗi táq yỗn tỗ chác anhia cỡt tỡ bữn bráh cỗ tễ cha máh charán ki. ");
INSERT INTO bru_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Cứq la Yiang Sursĩ, Ncháu anhia. Cóq anhia cỡt cũai bráh o, yuaq cứq la Yiang bráh o. ");
INSERT INTO bru_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Cứq la Yiang Sursĩ, án ca dững aloŏh anhia tễ cruang Ê-yip-tô, dŏq cỡt Yiang Sursĩ anhia. Cóq anhia cỡt bráh o, yuaq cứq la bráh o. ");
INSERT INTO bru_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Máh santoiq nâi la rit atỡng tễ máh charán, chớm, cớp dũ ramứh ỡt tâng dỡq cớp pupỡq tâng cloong cutễq. ");
INSERT INTO bru_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Cóq anhia dáng cayoah yỗn khễuq tễ máh charán tỡ bữn bráh cớp charán bráh puai rit, la máh charán têq cha cớp charán tỡ têq cha.” ");
INSERT INTO bru_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yiang Sursĩ patâp Môi-se ");
INSERT INTO bru_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","yỗn atỡng cũai proai I-sarel neq: “Vớt tapul tangái ntun mansễm sễt con samiang, mansễm ki tỡ bữn bráh puai rit, machớng cớp mansễm toâq prêng tê. ");
INSERT INTO bru_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Tâng tangái tacual, cóq táq rit cứt yỗn carnễn samiang ki. ");
INSERT INTO bru_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Toâq pái chít la pái tangái ễn, mansễm ki cóq pỡq sambráh tỗ chác án puai rit, cỗ aham án khoiq tangứt chơ. Ma án tỡ têq satoaq crơng ntrớu ca cỡt miar khong Yiang Sursĩ, tỡ la pỡq chu Dống Sang Aroâiq, yỗn toau moâm án táq rit sambráh tỗ chác voai. ");
INSERT INTO bru_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Khân án sễt con mansễm, ki án cỡt tỡ bữn bráh puai rit machớng án toâq prêng tê, ma dũn muoi chít la pỗn tangái. Cóq án acoan tapoât chít tapoât tangái ễn toau án táq rit sambráh tỗ chác tễ aham án khoiq tangứt. ");
INSERT INTO bru_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Toâq tangái anoat yỗn pỡq táq rit sambráh tỗ khoiq vớt chơ, tam án bữn con mansễm tỡ la samiang, án cóq dững yỗn cũai tễng rit sang pỡ nchŏh Dống Sang Aroâiq muoi lám cữu mbỡiq muoi cumo, dŏq táq rit bốh chiau sang. Cớp cóq án dững muoi lám chớm tariap tỡ la chớm tapâr dŏq táq rit pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Cũai tễng rit sang cóq dững máh crơng án chiau sang ki yỗn Yiang Sursĩ dŏq táq rit sambráh tỗ mansễm ki. Chơ mansễm ki cỡt bráh puai phễp rit canỡt con. ");
INSERT INTO bru_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Khân mansễm ki ma tỡ têq chiau sang muoi lám cữu, cóq án dững bar lám chớm tariap tỡ la bar lám chớm tapâr, muoi lám dŏq bốh chiau sang, ma muoi lám ễn dŏq chiau sang pupứt lôih. Cũai tễng rit sang cóq táq rit sambráh yỗn mansễm ki, chơ mansễm ki cỡt bráh.” ");
INSERT INTO bru_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yiang Sursĩ atỡng phễp rit nâi yỗn Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Khân bữn cũai aléq ma a‑ĩ tâng ngcâr, tỡ la cỡt paldóng, tỡ la cỡt parlứm tâng ngcâr, cóq noau dững cũai ki ramóh cũai tễng rit sang tễ tŏ́ng toiq Arôn. ");
INSERT INTO bru_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Cóq cũai tễng rit sang nhêng salĩq ntốq a‑ĩ ki. Khân sóc muar cỡt cloc cớp acán a‑ĩ ki mut yarũ luat ngcâr, cóq noap cũai ki cỡt a‑ĩ tâng ngcâr hâp lứq, cớp cóq cũai tễng rit sang pau atỡng pai cũai ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Khân ntốq ki cloc ma acán a‑ĩ ki cha tỡ bữn yarũ luat ngcâr, cớp sóc muar mpễr ntốq a‑ĩ ki la tỡ bữn cloc, cóq cũai tễng rit sang Yiang Sursĩ cayoah cũai ki yỗn loŏh ỡt miar tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Chơ catâm tangái tapul, cóq cũai tễng rit sang nhêng loah muoi trỗ ễn. Khân ŏ́c a‑ĩ ma patoat tiaq cớp tỡ bữn liei chu ntốq canŏ́h, cóq cayoah aloŏh cũai ki yỗn ỡt miar tapul tangái ễn. ");
INSERT INTO bru_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Cũai tễng rit sang Yiang Sursĩ cóq nhêng loah sĩa toâq tangái tapul ễn. Ma khân ŏ́c a‑ĩ ki khaq bĩq, cớp tỡ bữn liei chu ntốq canŏ́h, cũai tễng rit sang cóq pau atỡng pai cũai ki bráh puai rit, yuaq án bữn ống a‑ĩ bĩq tâng ngcâr sâng. Chơ cóq cũai ki dững pooh tampâc án; chơ án cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ma khân vớt cũai tễng rit sang Yiang Sursĩ nhêng, ma ŏ́c a‑ĩ ki liei pláh chũop nheq tỗ, cóq án pỡq ramóh loah cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Cóq cũai tễng rit sang nhêng loah muoi trỗ ễn, chơ khân ntốq a‑ĩ ma liei chu canŏ́h, cũai tễng rit sang cóq pau pai cũai ki tỡ bữn bráh puai rit, cỗ tian a‑ĩ ngcâr ki têq tớt pỡ cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Khân cũai aléq ma a‑ĩ ngcâr hâp lứq, cóq noau dững cũai ki pỡq ramóh cũai tễng rit sang dŏq án nhêng. ");
INSERT INTO bru_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Khân ntốq a‑ĩ ma áih cỡt cloc, cớp táq yỗn sóc muar bân ntốq ki cỡt cloc, bữn dếh dỡq ngoai hỡ, ");
INSERT INTO bru_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ranáq nâi apáh yỗn noau dáng samoât la a‑ĩ ngcâr hâp lứq. Cóq cũai tễng rit sang pau pai cũai ki cỡt tỡ bữn bráh puai rit. Tỡ bữn túh cóq cayoah yỗn án ỡt miar noâng, yuaq khoiq dáng raloaih lứq án cỡt tỡ bữn bráh. ");
INSERT INTO bru_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ma khân a‑ĩ ngcâr ki liei la‑ữt la‑ữi chũop nheq tỗ, tễ plỡ toâq ayững, ");
INSERT INTO bru_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","cũai tễng rit sang cóq nhêng loah tamái. Khân cũai tễng rit sang ma hữm bớc ki liei la‑ữt la‑ữi chũop tỗ, án pau pai cũai ki bráh puai phễp rit. Khân ngcâr cỡt cloc, cũai ki cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ma khân bo léq bớc ma padŏ́h cỡt rapoâq rahỡ, cóq noap cũai ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Cóq cũai tễng rit sang nhêng loah tamái ễn. Khân hữm bớc tamái ki ma cỡt rapoâq rahỡ, cóq án pau pai cũai ki tỡ bữn bráh. Cũai ki bữn a‑ĩ ngcâr hâp lứq, cớp tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ma khân bớc tamái ki ma cỡt cloc, cóq án pỡq ramóh cũai tễng rit sang Yiang Sursĩ ");
INSERT INTO bru_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","yỗn nhêng loah án. Khân bớc ki cỡt cloc, cóq cũai tễng rit sang pau pai cũai ki bráh puai phễp rit. ");
INSERT INTO bru_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Khân cũai aléq cỡt satễng ma khoiq bán chơ, ");
INSERT INTO bru_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","toâq vớt ki, satễng áih cỡt cloc tỡ la cusâu carchốc cớp cloc bân ntốq ki, cóq án pỡq ramóh cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Cóq cũai tễng rit sang nhêng. Khân bân ntốq ki ma yarũ luat tễ ngcâr cớp sóc muar cỡt cloc, cũai tễng rit sang cóq pau pai cũai ki tỡ bữn bráh puai rit. Nâi la a‑ĩ ngcâr hâp lứq, ma mbỡiq palooh tễ satễng. ");
INSERT INTO bru_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ma khân cũai tễng rit sang khoiq nhêng chơ, cớp tỡ ramóh bân ntốq ki, ma bữn sóc muar cloc cớp ntốq a‑ĩ ki tỡ bữn yarũ luat ngcâr, ma án cỡt rangôm sâng, cóq cũai tễng rit sang cayoah cũai ki yỗn loŏh ỡt miar tâng tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Khân a‑ĩ ki ma rơiq la‑ữt la‑ữi tâng ngcâr, cũai tễng rit sang cóq pau pai cũai ki tỡ bữn bráh; ŏ́c a‑ĩ án têq tớt chu cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ma khân ntốq ki patoat tiaq cớp tỡ bữn rơiq la‑ữt la‑ữi, bớc ki cỡt rapit cỗ tian satễng sâng; cũai tễng rit sang cóq pau pai cũai ki bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Khân bữn cũai cat ũih cớp bớc án cỡt cloc, tỡ la cloc carchốc cớp cusâu, ");
INSERT INTO bru_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","cóq cũai tễng rit sang nhêng a‑ĩ ki. Khân sóc muar bân ntốq ki cloc cớp ntốq a‑ĩ ki yarũ luat ngcâr, ŏ́c a‑ĩ ki la a‑ĩ ngcâr hâp lứq cỗ tễ ntốq cat ũih, cớp cũai tễng rit sang cóq pau pai cũai ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ma khân bớc bân ntốq ki sóc muar tỡ bữn cloc, cớp tỡ bữn yarũ luat tễ ngcâr, cớp án cỡt rangôm sâng, cũai tễng rit sang cóq cayoah cũai ki yỗn loŏh ỡt miar tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Toâq tangái tapul, cũai tễng rit sang cóq pỡq nhêng loah; khân ŏ́c a‑ĩ ki ma rơiq la‑ữt la‑ữi chu canŏ́h, ki cỡt a‑ĩ ngcâr têq tớt pỡ cũai canŏ́h, chơ cũai tễng rit sang cóq pau pai cũai ki cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ma khân ntốq ki ma patoat tiaq cớp tỡ bữn rơiq la‑ữt la‑ữi, dếh rangôm hỡ, ŏ́c a‑ĩ ki tỡ cỡn a‑ĩ ngcâr ntâng lứq. Cũai tễng rit sang cóq pau pai cũai ki bráh puai rit, yuaq án cỡt rapit tễ mang-al cat ũih sâng. ");
INSERT INTO bru_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Khân bữn samiang tỡ la mansễm cỡt bớc tâng plỡ tỡ la tâng tabang, ");
INSERT INTO bru_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","cũai tễng rit sang cóq nhêng bớc ki. Khân ntốq a‑ĩ ki ma yarũ luat ngcâr, cớp sóc mpễr ki cỡt rariaq cớp cada, ŏ́c ki apáh yỗn dáng samoât lứq ŏ́c a‑ĩ ki la khoiq hâp chơ. Cũai tễng rit sang cóq pau pai cũai ki cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Khân cũai tễng rit sang nhêng loah ntốq a‑ĩ, cớp ntốq a‑ĩ ki ma tỡ bữn yarũ luat tễ ngcâr, ma sóc la tỡ bữn cỡt cũm loah, cũai tễng rit sang cóq cayoah yỗn cũai ki ỡt miar tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Catâm tangái tapul, cũai tễng rit sang cóq nhêng loah bớc ki. Khân bớc ma tỡ bữn rơiq la‑ữt la‑ữi, sóc muar la tỡ bữn rariaq, cớp ntốq a‑ĩ ki tỡ bữn yarũ luat ngcâr, ");
INSERT INTO bru_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","cóq cũai a‑ĩ ki cũah sóc, ma chỗi cũah mpễr bớc, cớp cóq cũai tễng rit sang cayoah cũai ki yỗn ỡt miar tapul tangái ễn. ");
INSERT INTO bru_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Tâng tangái tapul, cũai tễng rit sang cóq nhêng loah bớc ki. Khân bớc ki tỡ bữn rơiq la‑ữt la‑ữi, dếh tỡ bữn yarũ hỡn tễ ngcâr, cũai tễng rit sang cóq pau pai cũai ki bráh puai phễp rit. Toâq án pooh tampâc, chơ án cỡt bráh. ");
INSERT INTO bru_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ma khân án sambráh tỗ chơ, ma ŏ́c a‑ĩ ki rơiq la‑ữt la‑ữi tâng ngcâr, ");
INSERT INTO bru_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","cóq cũai tễng rit sang nhêng loah bớc ki. Khân ŏ́c a‑ĩ ki ma rơiq la‑ữt la‑ữi, tỡ bữn túh cóq nhêng sóc, rariaq ma tỡ bữn; yuaq khoiq dáng raloaih lứq chơ cũai ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ma khân cũai tễng rit sang hữm ŏ́c a‑ĩ tỡ bữn rơiq la‑ữt la‑ữi, cớp bữn sóc cũm dáh patoat tiaq loah bân ntốq ki, ngkíq ŏ́c a‑ĩ ki khoiq bán; cũai tễng rit sang cóq pau pai cũai ki bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Toâq bữn samiang tỡ la mansễm cỡt tut cuyal tâng ngcâr, ");
INSERT INTO bru_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","cóq cũai tễng rit sang nhêng cũai ki. Khân ngcâr cỡt cloc plúc-plúc, ki tỡ bữn hâp, cớp cỡt parlứm tâng ngcâr sâng; cũai ki bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Khân cũai samiang aléq ma sóc án rapũiq, ");
INSERT INTO bru_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","yoah moat tỡ la yoah clĩ, cũai ki bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ma khân bân ntốq plỡ cala, ma cỡt áih cusâu carchốc cớp cloc, dếh a‑ĩ hỡ, ŏ́c a‑ĩ nâi apáh yỗn dáng raloaih lứq la a‑ĩ ngcâr têq tớt pỡ cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Cóq cũai tễng rit sang nhêng cũai ki. Ma khân mpễr ntốq áih ki cỡt áih cusâu carchốc cloc dếh a‑ĩ hỡ, ");
INSERT INTO bru_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","cũai tễng rit sang cóq pau pai cũai ki tỡ bữn bráh puai rit; yuaq bớc tâng plỡ cũai ki hâp lứq. ");
INSERT INTO bru_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Cũai aléq ma bữn a‑ĩ têq tớt pỡ cũai canŏ́h, cóq án sớp tampâc raháq, tỡ bữn siet sóc, chơ ĩt aroâiq pul tambớr bỗq, cớp pai casang neq: ‘Cứq tỡ bữn bráh! Cứq tỡ bữn bráh!’ ");
INSERT INTO bru_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Cũai tỡ bữn bráh puai rit cỗ án ỡt rang‑ĩ tâng ngcâr hâp lứq, cóq án ỡt yáng tiah ntốq cũai ỡt, yơng tễ cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Bo léq bữn môc tớt tâng tampâc, tỡ la tâng crơng táq toâq sóc cữu, tỡ la aroâiq táq toâq busín, ");
INSERT INTO bru_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","tỡ la tớt tâng muoi ploah aroâiq noau tan toâq sóc cữu, tỡ la aroâiq busín, tỡ la máh ramứh táq toâq ngcâr charán, ");
INSERT INTO bru_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","khân môc ki cỡt santứm ramoong tỡ la cusâu cớp pláh sa‑ữi ntốq, cóq pỡq apáh yỗn cũai tễng rit sang nhêng. ");
INSERT INTO bru_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Cớp yỗn cũai tễng rit sang nhêng môc ki, cớp ĩt crơng ca cỡt môc dững dŏq pỡ ntốq canŏ́h tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Toâq tangái tapul, cóq án nhêng loah. Khân môc ki ma rơiq la‑ữt la‑ữi, crơng ki cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Cóq cũai tễng rit sang bốh táh chíq máh crơng ki, yuaq crơng ki bữn môc ntôm rơiq la‑ữt la‑ữi. Ngkíq cóq bốh chíq tâng ũih. ");
INSERT INTO bru_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Toâq cũai tễng rit nhêng chơ, ma hữm môc ki tỡ bữn rơiq la‑ữt la‑ữi tâng crơng, ");
INSERT INTO bru_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","cóq án ớn noau dững pooh, cớp dŏq tâng ntốq canŏ́h tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Toâq moâm pooh chơ, cóq cũai tễng rit sang nhêng loah sĩa. Khân ntốq cỡt môc ma santứm patoat tiaq, lứq pai án tỡ bữn rơiq la‑ữt la‑ữi, ma noâng án tỡ bữn bráh puai rit; cóq bốh táh chíq crơng ki, tỡ bữn pai tớt yáng clống tỡ la yáng tiah. ");
INSERT INTO bru_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Toâq moâm pooh chơ, ma cũai tễng rit sang nhêng loah hữm ntốq cỡt môc ki khoiq tŏ́h chơ, cóq cũai tễng rit sang háq táh chíq ntốq cỡt môc tễ tampâc, tỡ la tễ ngcâr charán. ");
INSERT INTO bru_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Toâq vớt tễ ki, ma môc palooh loah cớp rơiq la‑ữt la‑ữi, cũai ca ndỡm crơng cóq dững bốh táh chíq. ");
INSERT INTO bru_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Khân án pooh cớp môc ki pứt, cóq án pooh tữm ễn, nŏ́q noap crơng ki cỡt bráh puai rit.” ");
INSERT INTO bru_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Nâi la ŏ́c patâp atỡng tễ rit cóq táq khân tampâc cỡt môc, tỡ bữn pai tampâc táq toâq sóc cữu, tỡ la aroâiq busín, tỡ la táq toâq ngcâr charán. Khân puai rit nâi, têq noau rưoh crơng ntrớu bráh tỡ la tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Táq rit sambráh tỗ chác cũai ca khoiq bán tễ a‑ĩ ngcâr la neq: Tâng tangái noau pai án bráh chơ puai rit, cóq dững án pỡq ramóh cũai tễng rit sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Cóq cũai tễng rit sang pỡq yáng tiah ntốq alới ỡt, cớp nhêng môiq ca khoiq bán ki. Khân ntốq a‑ĩ ki bán, ");
INSERT INTO bru_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","cóq cũai tễng rit sang ớn án dững bar lám chớm bráh puai rit dŏq táq rit sambráh tỗ án, cớp dững crơng neq hỡ: Muoi béq aluang sê-da, muoi ntreh dai cusâu, cớp muoi boq bát noau dŏq hi‑sớp. ");
INSERT INTO bru_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Chơ cóq cũai tễng rit sang kiac muoi lám chớm tâng pỡng tangan cutễq ca bữn dỡq noau ĩt tễ dỡq mec. ");
INSERT INTO bru_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Cóq cũai tễng rit sang ĩt chớm ca noâng tamoong ki, chơ alốq tâng tangan aham, parnơi cớp aluang sê-da, dai cusâu, cớp muoi boq bát hi‑sớp. ");
INSERT INTO bru_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Chơ cóq cũai tễng rit sang trutrếh aham ki tapul trỗ chóq cũai ca toâq sambráh tỗ tễ a‑ĩ ngcâr, cớp pau pai cũai ki cỡt bráh puai rit. Ma chớm ca noâng tamoong, cóq án acláh chớm ki yỗn pâr chu ntốq canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Toâq moâm táq rit, cóq cũai ki pooh tampâc án tâc, cũah sóc bễc, cũah sóc plỡ, cớp mpơi dỡq. Chơ cũai ki cỡt bráh puai rit, cớp têq án mut loah chu ntốq alới ỡt; ma cóq án ỡt yáng tiah dống aroâiq án tapul tangái voai. ");
INSERT INTO bru_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Tâng tangái tapul cóq án cũah sóc plỡ, cũah sóc bễc, cũah sóc acốh moat, cớp cũah nheq sóc muar tâng tỗ chác. Cớp cóq án pooh tampâc án tâc, cớp mpơi dỡq yỗn tỗ chác cỡt bráh o voai; chơ án cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ma tâng tangái tacual cóq án dững crơng dŏq chiau sang neq: Bar lám cữu tôl con, muoi lám cữu cán mbỡiq muoi cumo, dũ lám cóq ŏ́q bân tĩq, cớp bar ki-lô bỗt khoiq talốc cớp muoi pún tễ pái pún tễ muoi lit dỡq nsễng o‑li‑vê dŏq chiau sang máh thữ racáu. ");
INSERT INTO bru_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Cóq cũai tễng rit sang dững cũai ki cớp crơng án chiau sang pỡ ngoah toong mut Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Chơ cóq cũai tễng rit sang ĩt muoi lám cữu tôl con, cớp muoi pún tễ pái pún tễ muoi lit dỡq nsễng o‑li‑vê chiau sang dŏq cỡt crơng sang pláih loah lôih. Crơng nâi cỡt pún cũai tễng rit sang, cớp cóq án apỗng chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Cóq án kiac cữu tôl ki bân ntốq miar ca noau dốq kiac charán dŏq sang yỗn pupứt lôih cớp kiac charán dŏq bốh chiau sang. Yuaq crơng chiau sang dŏq táq rit pláih loah lôih la machớng cớp crơng noau chiau sang dŏq pupứt lôih cỡt pún cũai tễng rit sang; nheq ramứh ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Cóq cũai tễng rit sang ĩt bĩq aham cữu con, chơ apĩac tâng sala cutũr cũai ki coah atoam, chơ atia tâng ngcứm atĩ cớp ngcứm ayững coah atoam cũai ki. Ngkíq án cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Cũai tễng rit sang cóq ĩt bĩq dỡq nsễng o‑li‑vê tễ muoi pún tễ pái pún tễ lit ki, chơ hĩng tâng talang atĩ coah avêr án bữm. ");
INSERT INTO bru_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Chơ cóq án alốq ndễm atĩ án coah atoam tâng dỡq nsễng o‑li‑vê ki, cớp trutrếh tapul taláp choâng moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ma dỡq nsễng tâng talang atĩ noâng clữi, cóq án atia tâng sala cutũr cũai ki coah atoam, dếh tâng ngcứm atĩ cớp ngcứm ayững coah atoam. Cóq án apĩac loah tâng ntốq án khoiq apĩac aham cữu cũai ki khoiq dững chiau sang dŏq pláih loah lôih. ");
INSERT INTO bru_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ma dỡq nsễng noâng clữi tâng talang atĩ cũai tễng rit sang, cóq án atia tâng plỡ cũai ki. Cũai tễng rit sang táq ngkíq, la táq rit sambráh cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Moâm ki, cóq cũai tễng rit sang chiau sang dŏq pupứt lôih cớp táq rit sambráh; cớp cóq án kiac charán án ễ bốh sang ki, ");
INSERT INTO bru_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","chơ chiau sang máh thữ racáu tâng prông sang. Cũai tễng rit sang táq ngkíq, la án táq rit dŏq sambráh; ngkíq cũai ki cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Khân cũai ki la cũai cadĩt, cớp ŏ́q máh charán ki, cóq cũai ki dững muoi lám cữu tôl con dŏq cỡt crơng chiau sang pláih loah lôih. Crơng nâi cỡt pún cũai tễng rit sang, cớp cỡt crơng mpon chiau sang yỗn Yiang Sursĩ. Cóq án dững bỗt khoiq talốc cớp dỡq nsễng o‑li‑vê dŏq cỡt crơng chiau sang máh thữ racáu, cớp cóq án dững dỡq nsễng o‑li‑vê ễn muoi pún tễ pái pún tễ muoi lit. ");
INSERT INTO bru_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Cóq án dững dếh bar lám chớm tapâr tỡ la bar lám chớm tariap, muoi lám dŏq chiau sang dŏq pupứt lôih, ma muoi lám ễn dŏq bốh chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Tâng tangái tacual cóq cũai ki dững máh ramứh ki chiau yỗn cũai tễng rit sang ca táq rit sambráh; cóq án dững chớm ki yỗn cũai tễng rit sang pỡ ngoah toong mut chu Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Cóq cũai tễng rit sang dững cữu tôl con cớp dỡq nsễng o‑li‑vê dŏq cỡt crơng pláih loah lôih. Crơng nâi cỡt pún cũai tễng rit sang, cớp cóq án apỗng chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Án kiac cữu ki cớp ĩt bĩq aham apĩac tâng sala cutũr coah atoam, dếh atia tâng ngcứm atĩ cớp ngcứm ayững coah atoam cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Chơ cũai tễng rit sang cóq hĩng bĩq dỡq nsễng o‑li‑vê tâng talang atĩ án coah avêr, ");
INSERT INTO bru_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","cớp trutrếh dỡq nsễng na ndễm atĩ coah atoam tapul trỗ yoah moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Chơ cóq án ĩt dỡq nsễng tễ talang atĩ atia tâng sala cutũr coah atoam, ngcứm atĩ coah atoam, cớp ndễm ngcứm ayững coah atoam cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ma dỡq nsễng noâng clữi tâng talang atĩ cũai tễng rit sang, cóq án atia tâng plỡ cũai ki dŏq táq rit sambráh tỗ chác puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Moâm ki, cóq án chiau sang muoi lám chớm tapâr tỡ la chớm tariap, ");
INSERT INTO bru_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","cỡt crơng chiau sang dŏq pupứt lôih; ma chớm muoi lám ễn cóq bốh muoi prớh cớp bỗt. Cũai tễng rit sang táq ngkíq, la dŏq táq rit sambráh cũai ki.” ");
INSERT INTO bru_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Nâi la phễp rit yỗn cũai a‑ĩ ngcâr ca cadĩt lứq dŏq têq yỗn án chiau sang ariang khoiq anoat dŏq chơ, toâq táq rit sambráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yiang Sursĩ pai chóq Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Toâq anhia bữn mut tâng cruang Cana-an la ntốq cứq ễ chiau yỗn anhia bữn ndỡm, ma khân cứq táq yỗn cỡt môc tâng muoi lám dống pỡ cruang cutễq ki, ");
INSERT INTO bru_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","cóq cũai ndỡm dống ki pỡq atỡng cũai tễng rit sang pai neq: ‘Cứq ramóh muoi ramứh ariang môc tâng dống cứq.’ ");
INSERT INTO bru_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Chơ cũai tễng rit sang cóq ớn yỗn noau ĩt aloŏh nheq máh crơng tễ dống ki nhũang án mut nhêng. Khân alới tỡ bữn aloŏh, dũ ramứh tâng dống ki cóq cũai tễng rit sang pau pai cỡt tỡ bữn bráh nheq puai rit. Chơ cũai tễng rit sang mut tâng dống ");
INSERT INTO bru_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","cớp nhêng môc. Khân môc tâng ratâng dống cỡt ramoong tỡ la cusâu, cớp môc cáiq cha yarũ lứq, ");
INSERT INTO bru_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","chơ án loŏh tễ dống cớp catáih chíq ngoah toong dống tâng tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Toâq tangái tapul cóq án pỡq nhêng loah dống ki. Khân môc liei la‑ữt la‑ữi, ");
INSERT INTO bru_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","cóq án ớn noau ĩt aloŏh chíq tamáu bân ntốq ramóh môc, chơ voang yáng tiah vil pỡ ntốq noau tốh roac. ");
INSERT INTO bru_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Vớt ki cóq án ớn noau cũah nheq ratâng tâng dống ki, chơ ĩt phốn cũah ki pỡq tốh tâng ntốq tốh roac yáng tiah vil. ");
INSERT INTO bru_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Chơ cóq ĩt cỗc tamáu tamái ễn chóq pláih loah ntốq khoiq curŏh aloŏh, cớp ĩt cupũr culĩer loah ratâng dống. ");
INSERT INTO bru_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Khân ntốq alới khoiq ĩt tamáu, dếh cũah cớp culĩer cupũr tamái chơ, ma noâng cỡt môc sĩa, ");
INSERT INTO bru_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","cũai tễng rit sang cóq toâq nhêng loah. Khân môc ma rơiq la‑ữt la‑ữi tâng ratâng dống, dống ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Cóq alới talốh táh chíq dống ki, máh tamáu, aluang, cớp cupũr ca táq dống ki yỗn ngcỗi dững voang yáng tiah vil, tốh táh bân ntốq noau tốh roac. ");
INSERT INTO bru_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Khân bữn cũai mut bo catáih dống ki, cũai ki cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Cũai aléq ma cha tỡ la bếq tâng dống ki, cóq án pooh tampâc án tâc. ");
INSERT INTO bru_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ma khân cũai tễng rit sang toâq nhêng, ma tỡ bữn hữm noâng môc tâng cupũr tamái, cóq cũai tễng rit sang pau pai dống ki bráh chơ puai rit, yuaq môc khoiq pứt chơ. ");
INSERT INTO bru_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Dŏq sambráh dống ki yỗn cỡt bráh, cóq cũai ndỡm dống dững bar lám chớm, muoi béq aluang sê-da, muoi ntreh dai santứm cusâu, cớp muoi boq bát hi‑sớp. ");
INSERT INTO bru_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Cóq cũai tễng rit sang kiac muoi lám chớm ki tâng tangan cutễq ca bữn dỡq noau ĩt tễ dỡq mec. ");
INSERT INTO bru_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Chơ cóq án dững aluang sê-da, bát hi‑sớp, dai santứm cusâu, cớp chớm noâng tamoong. Cóq alốq tâng aham chớm ca khoiq tadỡng tâng tangan cutễq, chơ trutrếh tâng dống tapul taláp. ");
INSERT INTO bru_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Cũai tễng rit sang táq ngkíq, la dŏq táq rit sambráh dống khoiq bữn môc, na aham chớm cớp dỡq mec, dếh aluang sê-da, bát hi‑sớp, cớp dai santứm cusâu. ");
INSERT INTO bru_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ma chớm noâng tamoong, cóq án acláh yỗn pâr chu ntốq canŏ́h. Án táq ngkíq, la táq rit sambráh dống; chơ dống ki cỡt bráh puai rit.” ");
INSERT INTO bru_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Nâi la máh rit tễ a‑ĩ ngcâr têq tớt chu cũai canŏ́h, ");
INSERT INTO bru_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","a‑ĩ nsoiq, bớc, tỡ la áih; ");
INSERT INTO bru_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","cớp môc ỡt tâng tampâc, tỡ la tâng dống. ");
INSERT INTO bru_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Máh phễp rit nâi atỡng yỗn dáng raloaih lứq tễ crơng cỡt bráh cớp crơng tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yiang Sursĩ pai chóq Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Cóq atỡng loah cũai proai I-sarel neq: Khân bữn cũai samiang ma bữn dỡq hoi tễ sarcal án, dỡq hoi ki cỡt tỡ bữn bráh puai rit, ");
INSERT INTO bru_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","tỡ bữn pai hoi aloŏh tễ sarcal samiang, tỡ la hoi ma noâng kiang tâng clống. ");
INSERT INTO bru_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Cachơng cũai ki bếq tỡ la tacu, la cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Bữn cũai aléq, khân án satoaq cachơng samiang ki bếq, ");
INSERT INTO bru_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","tỡ la tacu tâng cachơng samiang ki khoiq tacu, cũai ki cóq pooh tampâc cớp mpơi dỡq yỗn bráh; ma cũai ki noâng cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Cũai aléq ma satoaq samiang ca sarcal án hoi, cũai ki cóq pooh tampâc cớp mpơi dỡq yỗn bráh; ma án noâng cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Khân samiang aléq ma bữn dỡq hoi tễ sarcal án, ma án cuchóh pĩeiq cũai bráh puai rit; cũai pĩeiq carchóh cóq pỡq pooh tampâc cớp mpơi dỡq; ma án noâng cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Bân ntốq cũai samiang ca bữn dỡq hoi tễ sarcal tacu tâng cloong charán, tỡ la bân ntốq canŏ́h, nheq ntốq ki cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Cũai aléq ma satoaq tâng ntốq cũai samiang tỡ bữn bráh tacu, cũai ki cỡt tỡ bữn bráh puai rit toau toâq sadâu tê. Cũai aléq crang crơng án tacu, cóq cũai ki pooh tampâc cớp mpơi dỡq yỗn tỗ chác bráh; ma án cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Cũai samiang aléq ma bữn dỡq hoi tễ sarcal, ma án satoaq cũai canŏ́h, cớp án tỡ yũah ariau atĩ, cũai án satoaq cóq pooh tampâc cớp mpơi dỡq yỗn tỗ chác cỡt bráh; ma noâng cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Dũ ramứh adéh cutễq, ma pĩeiq cũai tỡ bữn bráh satoaq, adéh ki cỡt tỡ bữn bráh puai rit; cóq pieih táh chíq adéh ki. Cớp máh crơng radỡng táq toâq aluang cóq ariau yỗn bráh. ");
INSERT INTO bru_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Toâq cũai samiang ca bữn dỡq hoi tễ sarcal án cỡt bán chơ, cóq án acoan tapul tangái ễn, ki nŏ́q têq pỡq pooh tampâc cớp mpơi tâng dỡq mec. Chơ án cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Tâng tangái tacual cóq án dững muoi cáp chớm tapâr tỡ la chớm tariap pỡ ngoah toong mut chu Dống Sang Aroâiq, cớp chiau chớm ki yỗn pỡ cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Cũai tễng rit sang cóq ĩt muoi lám tễ bar lám chớm ki chiau sang dŏq pupứt lôih, cớp muoi lám ễn dŏq bốh sang. Cũai tễng rit sang táq ngkíq, la táq rit sambráh cũai ki yỗn cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Khân samiang aléq ma bữn dỡq ramia loŏh, cóq án pỡq mpơi dỡq yỗn tỗ chác cỡt bráh, ma án noâng tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Dũ ramứh crơng pasang aroâiq tỡ la ngcâr, khân pĩeiq dỡq ramia, cóq ariau toâq dỡq, ma noâng tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Toâq vớt bếq parnơi, cũai samiang cớp cũai mansễm cóq mpơi dỡq; ma bar náq ki noâng tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Khân mansễm toâq prêng, án cỡt tỡ bữn bráh tâng tapul tangái. Khân cũai aléq ma satoaq tỗ án, cũai ki cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Bo mansễm ki noâng toâq prêng, ntốq án tacu tỡ la bếq, ntốq ki cỡt tỡ bữn bráh tê. ");
INSERT INTO bru_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Cũai aléq satoaq cachơng án bếq, tỡ la ntốq án tacu, ");
INSERT INTO bru_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","cóq cũai ki pỡq pooh tampâc cớp mpơi dỡq yỗn tỗ chác cỡt bráh, ");
INSERT INTO bru_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ma án noâng cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Khân samiang aléq ma bếq parnơi cớp mansễm bo án toâq prêng, samiang ki cỡt tỡ bữn bráh tê tâng tapul tangái; cachơng án bếq, la cỡt tỡ bữn bráh tê puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Khân mansễm ma aham loŏh sa‑ữi tangái, tỡ bữn noap tangái án toâq prêng, tỡ la khân aham án loŏh luat tangái dốq toâq prêng, cu rangái bữn aham loŏh, mansễm ki cỡt tỡ bữn bráh; án cỡt tỡ bữn bráh toau toâq tangái aham ki yốt machớng án toâq prêng. ");
INSERT INTO bru_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Dũ ntốq mansễm ki bếq, cớp dũ ntốq án tacu bo bữn aham hoi aloŏh, máh ntốq ki cỡt tỡ bữn bráh nheq puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Khân cũai aléq satoaq ntốq ki, án cỡt tỡ bữn bráh tê. Cóq án pooh tampâc cớp mpơi dỡq yỗn cỡt bráh; ma án noâng cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Khân aham mansễm ki yốt chơ, cóq án acoan tapul tangái ễn. Chơ án cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Tâng tangái tacual, cóq án dững bar lám chớm tapâr, tỡ la chớm tariap, yỗn cũai tễng rit sang bân ngoah toong mut chu Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Cũai tễng rit sang cóq chiau sang muoi lám chớm dŏq pupứt lôih, ma muoi lám chớm ễn dŏq bốh chiau sang. Án táq ngkíq, la dŏq táq rit sambráh mansễm yỗn cỡt bráh puai rit.” ");
INSERT INTO bru_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Yiang Sursĩ patâp Môi-se yỗn catoaih atỡng cũai proai I-sarel tễ ranáq tỡ bữn bráh nâi, dŏq alới tỡ bữn táq yỗn Dống Sang Aroâiq la ntốq Yiang Sursĩ ỡt tâng mpứng dĩ alới cỡt tỡ bữn bráh. Khân alới táq yỗn Dống Sang Aroâiq cỡt tỡ bữn bráh, tỗp alới cóq cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Nâi la phễp rit yỗn samiang ca bữn dỡq hoi tễ sarcal samiang, tỡ la dỡq táq ramia loŏh, ");
INSERT INTO bru_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","tỡ la mansễm ca toâq prêng, tỡ la samiang ca bếq cớp mansễm, alới cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Toâq vớt bar lám con samiang Arôn cuchĩt cỗ alới chống mut pỡ ntốq Yiang Sursĩ ỡt, ");
INSERT INTO bru_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","chơ Yiang Sursĩ atỡng Môi-se neq: “Cóq mới pỡq atỡng Arôn ai mới, la án chỗi mut tam pahỡm án sâng yoc tâng Ntốq Cứq Ỡt yáng clĩ aroâiq catáng Hĩp Parnai Parkhán. Khân án tỡ bữn trĩh, cóq án cuchĩt, yuaq ntốq ki la ntốq cứq sapáh chớc cứq tâng ramứl pỡng cantứp Hĩp Parnai Parkhán ki. ");
INSERT INTO bru_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ma toâq ngư án mut pỡ ntốq ki cóq án dững muoi lám ntroŏq tôl chiau sang dŏq pupứt lôih, cớp muoi lám cữu tôl dŏq bốh chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Nhũang Arôn mut chu Ntốq Cứq Ỡt, cóq án mpơi dỡq voai, chơ tâc tampâc busín noau táq yỗn cũai tễng rit sang, la neq: Au tuar, cốn alốt, parnoân, cớp tapưng khán-cỡn. ");
INSERT INTO bru_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Máh cũai I-sarel cóq dững bar lám mbễq tôl yỗn Arôn chiau sang dŏq pupứt lôih alới, cớp muoi lám cữu tôl dŏq bốh chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Cóq án chiau sang muoi lám ntroŏq tôl ki puai rit sang dŏq pupứt lôih án bữm cớp lôih máh cũai tâng dống sũ án. ");
INSERT INTO bru_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Moâm ki, cóq án dững bar lám mbễq tôl pỡ ngoah toong Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Tâng ntốq ki, Arôn cóq ĩt bar lám khlễc crơng séng táq toâq tamáu, khlễc muoi chĩc neq: Dŏq yỗn Yiang Sursĩ. Khlễc bar chĩc neq: Dŏq yỗn Asa-sel. ");
INSERT INTO bru_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ntroŏq lám ca pĩeiq crơng séng, ki cóq Arôn chiau sang yỗn Yiang Sursĩ dŏq pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ma mbễq ca cỡt khong Asa-sel, cóq dững sang mumoong yỗn Yiang Sursĩ, dŏq táq rit pupứt lôih máh cũai proai I-sarel. Chơ acláh mbễq ki pỡq chu ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Toâq Arôn ễ chiau sang ntroŏq tôl dŏq pupứt lôih án bữm cớp cũai tâng dống sũ án, ");
INSERT INTO bru_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","cóq án ĩt adéh bữn rahững ũih tễ prông sang, cớp ĩt bar carpỗt crơng phuom ĩat yỗn abuoiq, chơ dững chu Ntốq Cứq Ỡt. ");
INSERT INTO bru_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ỡt choâng moat Yiang Sursĩ, cóq án ĩt crơng phuom yữi tâng ũih, chơ phĩac suol achỗn capáng chíq cantứp Hĩp Parnai Parkhán dŏq án tỡ bữn hữm hĩp ki, chơ án tỡ bữn cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Cóq án ĩt aham ntroŏq tôl, chơ alốq ndễm atĩ cớp trutrếh chóq yáng moat cantứp Hĩp Parnai Parkhán; moâm ki trutrếh tapul taláp ễn yáng moat Hĩp Parnai Parkhán. ");
INSERT INTO bru_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Vớt ki, cóq án kiac mbễq dŏq pupứt lôih máh cũai proai, cớp dững amut aham mbễq pỡ Ntốq Cứq Ỡt dŏq trutrếh chóq tâng cantứp cớp yáng moat Hĩp Parnai Parkhán, táq machớng cớp trutrếh aham ntroŏq tôl tê. ");
INSERT INTO bru_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Án táq ngkíq la táq rit sambráh bân Ntốq Cứq Ỡt, yuaq máh cũai proai I-sarel tỡ bữn trĩh, cớp alới táq ranáq tỡ bữn bráh. Ngkíq yuaq án cóq táq rit sambráh yỗn Dống Sang Aroâiq, cỗ Dống Sang Aroâiq ỡt mpứng dĩ ntốq alới ỡt, cớp ntốq ki tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Chỗi yỗn cũai aléq ỡt tâng Dống Sang Aroâiq bo Arôn mut tâng Ntốq Cứq Ỡt yỗn toau toâq án loŏh. Tâng ntốq ki, án táq rit sambráh dŏq pupứt lôih án bữm, pupứt lôih máh cũai tâng dống sũ án, cớp pupứt lôih máh cũai I-sarel hỡ. ");
INSERT INTO bru_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Toâq án loŏh yáng tiah, cóq án pỡq chu prông sang dŏq bốh crơng táq rit sambráh prông ki. Cóq án ĩt aham ntroŏq tôl cớp aham mbễq apĩac tâng pỗn nhoq prông. ");
INSERT INTO bru_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Cóq án alốq ndễm atĩ tâng aham, chơ trutrếh tâng prông tapul taláp. Án táq ngkíq, la táq rit sambráh prông sang ki yỗn vớt tễ ŏ́c lôih cũai proai I-sarel khoiq táq, cớp chiau prông sang ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Tữ Arôn táq moâm chơ rit sambráh Ntốq Cứq Ỡt, Ntốq Tễng Rit, cớp prông sang, cóq án dững mbễq noâng tamoong cỡt khong Asa-sel chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Cóq án satoaq bar coah atĩ tâng plỡ mbễq, táq tếc chiau yỗn mbễq ễn roap máh ŏ́c lôih, ranáq sâuq, cớp ŏ́c tỡ bữn trĩh tễ cũai proai táq. Chơ án ngin kho máh ranáq nâi tang cũai I-sarel. Moâm ki, noau yỗn muoi noaq samiang catúh mbễq ki chu ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Mbễq ki roap tôt tang máh ŏ́c lôih tỗp alới, chơ pỡq chu ntốq ŏ́q cũai ỡt. ");
INSERT INTO bru_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Chơ cóq Arôn mut tâng Dống Sang Aroâiq, cớp tũot máh tampâc noau táq toâq aroâiq busín yỗn cũai tễng rit sang, tampâc án khoiq sớp nhũang án mut chu Ntốq Cứq Ỡt, cớp dŏq loah tampâc tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Chơ, cóq án mpơi dỡq sambráh tỗ chác tâng Dống Sang ki toâp, cớp tâc loah tampâc. Moâm ki, cóq án loŏh coah tiah dŏq bốh crơng chiau sang dŏq pupứt lôih án bữm cớp máh cũai proai hỡ. ");
INSERT INTO bru_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Cóq án ĩt nsễng tễ máh charán noau chiau sang dŏq pupứt lôih, chơ bốh tâng prông. ");
INSERT INTO bru_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Cũai ca dững acláh mbễq pỡ ntốq aiq yỗn Asa-sel, cóq án pooh tampâc cớp mpơi dỡq yỗn bráh; chơ têq án píh chu loah pỡ ntốq tỗp alới ỡt. ");
INSERT INTO bru_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ntroŏq tôl cớp mbễq tôl noau khoiq kiac dŏq táq rit chiau sang pupứt lôih, cóq Arôn ĩt aham charán ki dững amut tâng Ntốq Cứq Ỡt dŏq yỗn cứq táh lôih, mŏ charán ki cóq dững aloŏh bốh yáng tiah ntốq alới ỡt, bốh dếh ngcâr, sâiq, cớp máh crơng clống hỡ. ");
INSERT INTO bru_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Cũai ca táq rit bốh crơng ki cóq án pooh tampâc cớp mpơi dỡq sambráh tỗ chác voai. Moâm ki, têq án píh chu pỡ ntốq tỗp alới ỡt. ");
INSERT INTO bru_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Máh phễp rit nâi cóq cũai dũ dỡi táq puai níc. Tâng tangái muoi chít, casâi tapul, máh cũai I-sarel cớp máh cũai tễ cruang canŏ́h ỡt cớp alới cóq sanhữ tangái ót sana, cớp chỗi táq ranáq ntrớu. ");
INSERT INTO bru_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Yuaq tangái nâi cỡt tangái táq rit dŏq pupứt lôih tỗp anhia dŏq yỗn anhia cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Yuaq tâng tangái ki cỡt Tangái Rlu, yỗn nheq tữh anhia noap cỡt tangái miar tễ máh tangái canŏ́h, dŏq cỡt tangái anhia ót sana cớp rlu táq ranáq. Cóq anhia noap tangái ki tâng dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Cũai sốt nheq tễ rit sang, ca noau khoiq chóh na hĩng dỡq nsễng o‑li‑vê tâng plỡ cớp ớn án chiau sang tỗ án yỗn Yiang Sursĩ dŏq pláih loah mpoaq án, cóq án sớp tampâc cũai tễng rit sang cớp táq rit ki. ");
INSERT INTO bru_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Cóq án táq rit dŏq sambráh Ntốq Cứq Ỡt, Ntốq Tễng Rit, prông sang, máh cũai tễng rit sang, cớp máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Cóq táq puai nheq máh phễp rit nâi tâng dũ dỡi cũai mantái níc. Cóq táq rit nâi muoi cumo muoi trỗ dŏq sambráh cũai proai I-sarel tễ ranáq lôih alới khoiq táq.” Ngkíq Môi-se táq puai machớng santoiq Yiang Sursĩ khoiq patâp án dũ ramứh. ");
INSERT INTO bru_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yiang Sursĩ patâp Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Cóq mới chiau phễp rit nâi pỡ Arôn cớp máh con samiang án, dếh dũ náq cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Khân bữn muoi noaq cũai I-sarel kiac ntroŏq, cữu, tỡ la mbễq yoc ễ chiau sang pỡ ntốq án ỡt tỡ la ntốq canŏ́h, ");
INSERT INTO bru_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ma án tỡ bữn dững pỡ ntốq ngoah toong Dống Sang Aroâiq, án bữn lôih, yuaq án táq claiq phễp rit Yiang Sursĩ khoiq patâp, cỗ tian án táq yỗn bữn aham loŏh. Cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Máh cũai proai I-sarel cơi kiac charán sang yáng tiah vil, ma sanua cóq patâp yỗn alới dững charán ễ chiau sang pỡ cũai tễng rit sang bân ngoah toong mut chu Dống Sang Aroâiq, cớp kiac charán ki puai rit chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Cũai tễng rit sang cóq tốh aham charán kễng prông sang choâng ngoah toong mut chu Dống Sang Aroâiq, cớp bốh nsễng. Chơ hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Cóq máh cũai proai I-sarel chỗi táq lôih noâng chóq Yiang Sursĩ na kiac charán sang rup yiang mbễq. Cóq cũai proai I-sarel dũ dỡi táq puai níc phễp rit nâi. ");
INSERT INTO bru_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Khân bữn muoi noaq tễ tỗp I-sarel, tỡ la cũai tễ cruang canŏ́h ỡt cớp alới, ma bốh crơng chiau sang, tỡ la chiau sang crơng canŏ́h, ");
INSERT INTO bru_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ma tỡ bữn dững crơng chiau sang ki pỡ ngoah toong mut chu Dống Sang Aroâiq, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Khân tŏ́ng toiq cũai I-sarel, tỡ la cũai tễ cruang canŏ́h ỡt cớp alới, ma cha sâiq bữn aham, Yiang Sursĩ nguai chíq tễ cũai ki cớp tỡ bữn noap noâng cũai ki cỡt proai án. ");
INSERT INTO bru_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Yuaq dũ ramứh têq tamoong la cỗ nhơ aham; ngkíq yuaq Yiang Sursĩ ớn tốh aham tâng prông sang dŏq pupứt lôih máh cũai proai. Aham têq pupứt ŏ́c lôih, yuaq aham la ŏ́c tamoong. ");
INSERT INTO bru_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Yuaq ngkíq, Yiang Sursĩ atỡng cũai proai I-sarel, tỡ la cũai canŏ́h ỡt cớp alới, chỗi cha sâiq noâng bữn aham. ");
INSERT INTO bru_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Khân bữn muoi noaq cũai I-sarel, tỡ la cũai canŏ́h ỡt cớp alới, ma chuaq cha charán, tỡ la chớm bráh puai rit, cóq án kiac yỗn aham hoi tâng cutễq cớp ĩt phốn cutễq pul chíq. ");
INSERT INTO bru_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Yuaq dũ ramứh tamoong la cỗ nhơ tễ aham. Yuaq ngkíq, Yiang Sursĩ ma atỡng máh cũai proai I-sarel chỗi cha sâiq noâng bữn aham. Khân cũai aléq cha clốq, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Dũ náq cũai, tỡ bữn pai cũai I-sarel tỡ la cũai canŏ́h ỡt cớp alới, ma cha sâiq charán chống cuchĩt bữm, tỡ la pĩeiq charán cruang cáp, cóq án pooh tampâc, mpơi dỡq yỗn bráh, ma án noâng tỡ bữn cỡt bráh puai rit toau toâq sadâu, ki nŏ́q án cỡt bráh loah puai rit. ");
INSERT INTO bru_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Khân án ma tỡ bữn táq puai ngkíq, cóq án roap tôt.” ");
INSERT INTO bru_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yiang Sursĩ patâp Môi-se ");
INSERT INTO bru_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","yỗn atỡng máh cũai proai I-sarel neq: “Cứq toâp la Yiang Sursĩ, Ncháu tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Chỗi táq puai ĩn rit cũai Ê-yip-tô, alới ca ỡt ntốq anhia khoiq ỡt tễ nhũang; cớp tỡ bữn puai rit tỗp Cana-an, alới ca ỡt ntốq cứq ntôm dững anhia pỡq ỡt. ");
INSERT INTO bru_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Cóq anhia trĩh phễp rit cứq, cớp táq puai máh santoiq cứq ớn anhia táq sâng. Yuaq cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Yuaq ngkíq, cóq nheq tữh anhia yống pacái máh phễp rit cứq khoiq chiau yỗn anhia, cớp máh santoiq cứq ớn anhia. Khân anhia táq ngkíq, ki anhia lứq bữn tamoong cỗ nhơ tễ ŏ́c ki. Cứq la Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Yiang Sursĩ pai ễn neq: “Chỗi bếq parnơi cớp sễm ỡi bữm. ");
INSERT INTO bru_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Chỗi táq yỗn mpoaq cỡt casiet cỗ bếq parnơi cớp mpiq bữm. Yuaq án la mpiq, chỗi táq yỗn án cỡt casiet ngkíq. ");
INSERT INTO bru_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Chỗi táq yỗn mpoaq cỡt casiet cỗ tian bếq parnơi cớp lacuoi cỗiq mpoaq. ");
INSERT INTO bru_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Chỗi bếq parnơi cớp ỡi tỡ la a‑ễm, tỡ la cũai anhia noap ỡi tỡ la a‑ễm, tỡ bữn pai anhia ỡt muoi dống, tỡ la tỡ bữn. ");
INSERT INTO bru_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Chỗi bếq parnơi cớp châu bữm; ranáq nâi la tanghang lứq. ");
INSERT INTO bru_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Chỗi bếq parnơi cớp ỡi, tỡ la a‑ễm miar mpoaq tỡ la miar mpiq, yuaq án la ỡi tỡ la a‑ễm anhia tê. ");
INSERT INTO bru_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Chỗi bếq parnơi cớp bac mansễm tỡ la avia, tỡ bữn pai cỡt a‑ễm tỡ la ỡi mpoaq, a‑ễm tỡ la ỡi mpiq anhia. ");
INSERT INTO bru_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Chỗi bếq parnơi cớp lacuoi cũq, yuaq án cỡt cũq mansễm anhia. ");
INSERT INTO bru_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Chỗi bếq parnơi cớp cumân, ");
INSERT INTO bru_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","tỡ la lacuoi ai, tỡ la lacuoi a‑ễm. ");
INSERT INTO bru_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Chỗi bếq parnơi cớp con, tỡ la châu tễ mansễm mới khoiq bếq parnơi chơ; alới ki cỡt con châu anhia tê. Táq ranáq ngkíq, cỡt lôih machớng bếq cớp mansễm chống muoi mpoaq tỡ la mpiq. ");
INSERT INTO bru_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Bo lacuoi anhia noâng tamoong, chỗi ĩt ỡi tỡ la a‑ễm lacuoi táq lacuoi anhia. ");
INSERT INTO bru_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Chỗi bếq parnơi cớp mansễm toâq prêng, yuaq án cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Chỗi bếq cớp lacuoi cũai canŏ́h, yuaq ranáq nâi táq yỗn anhia cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Chỗi chiau sang con châu anhia yỗn cỡt crơng sang yiang Mô-lêc, yuaq ranáq ki dững ŏ́c casiet táq pỡ ramứh Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Samiang chỗi ễ bữn ratuaq samiang, yuaq ranáq ki Yiang Sursĩ kêt lứq. ");
INSERT INTO bru_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Samiang, tỡ la mansễm, chỗi ễ bữn charán; yuaq ranáq ki táq yỗn anhia cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Chỗi táq yỗn tỗ anhia cỡt tỡ bữn bráh na táq ranáq ngkíq, yuaq máh cũai cứq ntôm ễ tuih yỗn loŏh nhũang anhia toâq, la cũai tỡ bữn sa‑âm Yiang Sursĩ dốq táq ranáq ngkíq. ");
INSERT INTO bru_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Máh ranáq alới táq, ki táq yỗn cutễq cỡt tỡ bữn bráh. Yuaq ngkíq, Yiang Sursĩ ễ manrap dếh cutễq ki na tuih aloŏh nheq máh cũai ỡt tâng ki, riang cutễq cuta aloŏh cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nheq tữh cũai I-sarel, cớp máh cũai tễ cruang canŏ́h ỡt cớp anhia, cóq noap ĩt nheq phễp rit cớp santoiq Yiang Sursĩ patâp. ");
INSERT INTO bru_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Máh cũai ỡt tâng cutễq nâi nhũang anhia dốq táq nheq máh ranáq ngkíq; chơ cutễq ki cỡt tỡ bữn bráh. ");
INSERT INTO bru_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Khân anhia táq ngkíq, cutễq ki tuih tê anhia machớng án khoiq tuih cũai ca ỡt tâng cutễq ki tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Anhia cóq dáng samoât samơi la cũai aléq ma táq ranáq sâuq ngkíq, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“Cóq anhia trĩh máh santoiq cứq khoiq patâp anhia. Chỗi táq ariang rit cũai khoiq ỡt nhũang tâng cutễq nâi, cớp chỗi táq yỗn anhia cỡt tỡ bữn bráh na táq puai máh rit cũai ki. Cứq la Yiang Sursĩ, Ncháu anhia.” ");
INSERT INTO bru_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","atỡng cũai I-sarel neq: “Nheq tữh anhia cóq cỡt bráh o, yuaq cứq la Yiang Sursĩ, Ncháu anhia, bráh o. ");
INSERT INTO bru_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Dũ náq cũai cóq yám noap mpiq mpoaq, cớp yám noap Tangái Rlu ĩn cứq khoiq patâp. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Chỗi nguai tễ cứq, chơ pỡq cucốh sang rup yiang canŏ́h. Chỗi ĩt tac tooc táq rup cớp cucốh sang, yuaq cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Toâq anhia kiac charán chiau sang dŏq cỡt ratoi, cóq anhia táq puai máh rit cứq khoiq chiau yỗn anhia; chơ cứq roap ranáq anhia chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Cóq anhia cha nheq sâiq charán tâng tangái anhia kiac sang, tỡ la tangái parnỡ. Ma khân ntrớu noâng clữi, cóq anhia bốh táh chíq; chỗi dŏq toâq tangái pra, ");
INSERT INTO bru_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","yuaq sâiq noâng clữi cỡt tỡ bữn bráh puai rit; khân cũai aléq cha sâiq ki, cứq tỡ bữn roap crơng sang cũai ki. ");
INSERT INTO bru_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Cũai aléq ma cha sâiq ki, cứq noap án bữn lôih tâng ranáq chiau sang, yuaq án táq crơng miar khong cứq cỡt tỡ bữn bráh. Cũai ki tỡ têq cỡt noâng cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Toâq anhia ỡt tâng cutễq cứq ễ yỗn anhia, bo anhia roaiq saro tâng sarái, chỗi roaiq mpễr tor, cớp chỗi muat loah. ");
INSERT INTO bru_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Chỗi píh muat loah tangcóq palâi nho ca khlĩr palễc, tỡ la palâi nho ca satooh tâng cutễq. Cóq anhia táh dŏq saro cớp palâi nho yỗn cũai cadĩt cớp cũai tễ cruang canŏ́h ỡt cớp anhia. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Chỗi tutuoiq, tỡ la phếq thũ, tỡ la táq ntỡng lauq. ");
INSERT INTO bru_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Chỗi thễ dũan talếq ramứh cứq khân anhia tỡ bữn lứq ễ táq; táq ngkíq la anhia dững atoâq ŏ́c tỡ o yỗn ramứh cứq. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Chỗi lôp tỡ la culốq culĩeu, tỡ la pũr crơng cũai canŏ́h. Khân bữn cũai táq ranáq yỗn anhia, chỗi ĩt dŏq práq cóng cũai ki toau tangái parnỡ. ");
INSERT INTO bru_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Chỗi lóc acrieiq cũai túng cutũr, tỡ la bang to rana cũai sũt moat, táq yỗn án tũl, chơ dớm. Ma cóq anhia yám noap cứq; cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Cóq anhia parchĩn parnai yỗn tanoang tapứng lứq. Toâq anhia parchĩn, chỗi apáh ŏ́c sarũiq táq chóq cũai cadĩt, cớp chỗi apáh ŏ́c yám noap chóq cũai sốc. ");
INSERT INTO bru_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Chỗi apớt cũai canŏ́h. Cớp khân noau rasữq tễ ranáq lôih, cóq anhia rapai chuai, khân santoiq anhia pai ma têq chuai yỗn cũai ki tỡ bữn cuchĩt. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Chỗi kêt cũai aléq, ma cóq anhia pỡq mangcra tễ ranáq tỡ bữn ra‑o cớp cũai ki. Táq ngkíq, anhia tỡ bữn cỡt lôih cỗ tian tễ ranáq án táq. ");
INSERT INTO bru_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Chỗi carláh dỡq, tỡ la par‑ũal níc chóq cũai canŏ́h, ma cóq anhia ayooq yớu machớng anhia ayooq tỗ anhia bữm. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Cóq anhia trĩh máh ŏ́c cứq patâp. Chỗi ễ bữn bar thữ charán. Chỗi trứh cuplốq bar ramứh tâng muoi tâm sarái. Chỗi sớp tampâc noau tan toâq bar thữ priei. ");
INSERT INTO bru_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Khân bữn samiang bếq cớp manoaq mansễm cũai sũl noau khoiq pruam yỗn pỡ samiang canŏ́h, ma khân noau tỡ bữn yũah culáh práq tỡ la acláh án, cũai samiang ca bếq parnơi cớp mansễm ki, dếh mansễm, cóq alới chĩuq tôt. Ma chỗi manrap toau cuchĩt, yuaq mansễm ki noâng cỡt cũai sũl. ");
INSERT INTO bru_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ma cũai samiang ki cóq dững muoi lám cữu tôl pỡ ngoah toong Dống Sang Aroâiq, dŏq charán ki cỡt crơng chiau sang pláih loah lôih. ");
INSERT INTO bru_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Cóq cũai tễng rit sang táq rit dŏq sambráh lôih cũai ki; chơ Yiang Sursĩ táh lôih yỗn án. ");
INSERT INTO bru_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Toâq anhia bữn ỡt tâng cruang Cana-an chơ, cớp anhia chóh aluang ca têq cha palâi, cóq anhia noap máh palâi tễ aluang ki cỡt tỡ bữn bráh tâng pái cumo. Bo pai cumo ki anhia chỗi cha palâi aluang ki, yuaq tỡ yũah sambráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ma toâq cumo pỗn, dũ ramứh palâi tễ aluang ki cóq anhia dững chiau sang yỗn cứq, dŏq táq rit sa‑ỡn cứq, la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ma tâng cumo sỡng, têq anhia cha palâi aluang ki. Khân anhia táq puai máh ranáq nâi, ki nỡm aluang anhia cỡt palâi sa‑ữi. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Chỗi cha sâiq noâng bữn aham. Chỗi rien máh ngê parnân. ");
INSERT INTO bru_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Chỗi carái sóc rêng báng, tỡ la carái sóc bễc, ");
INSERT INTO bru_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","tỡ la sỗt ngcâr anhia bữm dŏq táq tếc tanúh yỗn cũai cuchĩt. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Chỗi táq yỗn máh con cumũr anhia cỡt mansễm chếq tỗ tâng dống sang ĩn máh cũai Cana-an. Khân anhia táq ngkíq, la ariang anhia puai yiang canŏ́h chơ, cớp anhia táq yỗn cutễq anhia bữn moang ŏ́c lôih sâng. ");
INSERT INTO bru_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Cóq anhia noap Tangái Rlu, cớp cóq anhia yám noap ntốq noau sang toam cứq. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Chỗi pỡq mumưl sễq ŏ́c tĩeih tễ cũai mo, tỡ la arô raviei cũai khoiq cuchĩt dŏq sarhống. Khân anhia táq ngkíq, anhia cỡt cũai tỡ bữn bráh puai rit. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Cóq anhia ayooq cớp yám noap cũai thâu. Cóq anhia trĩh cớp yám noap cứq. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Chỗi padâm cũai tễ cruang canŏ́h ỡt tâng cutễq anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Cóq anhia táq o chóq alới machớng cớp sễm ai anhia cũai I-sarel canŏ́h tê, cớp cóq anhia ayooq alới machớng anhia ayooq tỗ bữm, yuaq tễ nhũang anhia cơi cỡt cũai tễ cruang canŏ́h ỡt tâng cruang cutễq cũai Ê-yip-tô. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Chỗi lôp cũai canŏ́h na ĩt crơng chiaq ca tỡ bữn pĩeiq, toâq anhia chiaq kéh cuti, ntâng nghễl, tỡ la bĩq sa‑ữi. ");
INSERT INTO bru_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ma cóq anhia ĩt canân cớp crơng chiaq pĩeiq lứq. Cứq la Yiang Sursĩ, Ncháu anhia, án ca dững aloŏh anhia tễ cruang Ê-yip-tô. ");
INSERT INTO bru_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Cóq anhia yống yỗn pacái máh phễp rit cứq, cớp dũ ŏ́c cứq khoiq patâp. Cứq la Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","atỡng tỗp I-sarel neq: “Tâng tỗp anhia, tỡ la tỗp cũai tễ cruang canŏ́h ỡt cớp anhia, khân bữn cũai chiau con samiang tỡ la con mansễm án pỡ yiang Mô-lêc, cóq anhia tám tamáu chóq cũai ki toau cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Khân cũai aléq ma chiau con samiang tỡ la con mansễm án yỗn yiang Mô-lêc, nâi la machớng án táq yỗn dống sang cứq cỡt tỡ bữn bráh, cớp táq yỗn ramứh ranoâng cứq cỡt sâuq. Cứq lứq toâq chíl cũai ki, cớp tỡ bữn noap noâng án la cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ma khân cũai proai tỡ bữn ramíng cớp ranáq cũai ki táq, cớp tỡ bữn cachĩt án, ");
INSERT INTO bru_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","cứq toâp ễ toâq chíl án cớp dống sũ án, dếh dũ náq cũai ca pruam cớp án táq ranáq tỡ bữn pĩeiq chóq cứq. Cỗ tian alới pỡq cucốh sang yiang Mô-lêc, yuaq ngkíq cứq tỡ bữn noap noâng alới cỡt cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Khân cũai aléq ma pỡq rasễq santoiq tĩeih tễ mo cumuiq dŏq arô raviei cũai khoiq cuchĩt yỗn yuor dŏq alới sarhống, cứq lứq toâq chíl cũai ki, cớp tỡ bữn noap noâng án la cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Cóq anhia rabán curiaq tỗ anhia, yỗn mứt anhia cỡt bráh o, yuaq cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Cóq anhia yống pacái máh phễp rit cứq, yuaq cứq la Yiang Sursĩ ca táq yỗn mứt anhia cỡt bráh o. ");
INSERT INTO bru_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Cũai aléq ma lóc acrieiq mpiq mpoaq bữm, cóq án chĩuq cuchĩt. Cóq án chĩuq roap tôt bữm tễ ŏ́c cuchĩt ki. ");
INSERT INTO bru_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Khân samiang aléq ma cooc lacuoi sễm ai tỗp I-sarel, cóq samiang cớp mansễm ki roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Khân bữn muoi noaq samiang ma cooc lacuoi cỗiq mpoaq án, ranáq ki táq yỗn mpoaq án cỡt pứt moat dếh casiet lứq hỡ. Bar náq samiang mansễm ki cóq roap tôt cuchĩt. Alới cóq roap tôt bữm tễ ŏ́c cuchĩt ki. ");
INSERT INTO bru_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Khân bữn muoi noaq samiang ma cooc cumân án, alới bar náq cóq pĩeiq manrap toau cuchĩt, yuaq alới khoiq táq ranáq lôih machớng cớp samiang mansễm muoi mpoaq muoi mpiq tê. Alới lứq roap tôt bữm tễ ranáq alới táq. ");
INSERT INTO bru_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Khân samiang ễ bữn ratuaq samiang, ranáq alới táq la sâuq lứq, cóq alới bar náq roap tôt cuchĩt. Cớp alới roap bữm tôt tễ ranáq alới táq. ");
INSERT INTO bru_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Khân samiang cớp mansễm ma khoiq racoâiq chơ, chơ samiang ki ĩt yacán án hỡ táq lacuoi; cóq bốh alới pái náq mumoong tâng ũih, cỗ tian ranáq casiet alới khoiq táq ki. Chỗi yỗn ranáq nâi cỡt tâng mpứng dĩ tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Khân muoi noaq samiang ma bếq parnơi cớp charán, cũai samiang ki cớp charán ki cóq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Khân muoi noaq mansễm ma bếq parnơi cớp charán, cũai mansễm ki cớp charán ki cóq roap tôt cuchĩt. Alới roap tôt bữm tễ ranáq alới táq. ");
INSERT INTO bru_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Khân bữn samiang ma racoâiq cớp ỡi tỡ la a‑ễm án bữm, tỡ la ỡi a‑ễm miar mpoaq tỡ la miar mpiq, cóq cũai clứng táq yỗn alới sâng lo-lo tễ ranáq alới táq, chơ tuih aloŏh tễ tỗp alới. Yuaq án khoiq bếq parnơi cớp ỡi tỡ la a‑ễm bữm, ngkíq cóq án roap tôt máh ranáq án khoiq táq. ");
INSERT INTO bru_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Khân muoi noaq samiang ma bếq parnơi cớp mansễm toâq prêng, cóq anhia tuih aloŏh alới bar náq tễ ntốq cũai ỡt, yuaq alới khoiq táq claiq phễp rit cớp cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Khân bữn muoi noaq samiang bếq parnơi cớp bac tỡ la avia bữm, cóq manrap alới bar náq machớng cớp samiang mansễm muoi mpoaq mpiq ma bếq parnơi tê. ");
INSERT INTO bru_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Khân bữn muoi noaq samiang ma cooc lacuoi cũq án bữm, án táq yỗn cũq án cỡt casiet táq; chơ án cớp cũq mansễm cóq roap tôt cuchĩt, cớp alới pứt loâng tŏ́ng toiq. ");
INSERT INTO bru_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Khân bữn muoi noaq samiang ma ĩt lacuoi ai táq lacuoi án, bo ai án noâng tamoong, alới bar náq pứt loâng tŏ́ng toiq. Yuaq alới táq ranáq tỡ bữn bráh puai rit, dếh táq ranáq casiet lứq yỗn ai hỡ. ");
INSERT INTO bru_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Cóq anhia táq puai phễp rit cớp santoiq cứq patâp dŏq cutễq Cana-an, la cutễq cứq ntôm ễ ayông anhia mut, tỡ bữn cuta anhia aloŏh. ");
INSERT INTO bru_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Cóq anhia chỗi dững rit cuang cũai ỡt tâng ntốq ki. Cứq ntôm tuih máh cũai ỡt tâng ntốq ki yỗn loŏh nheq, dŏq anhia têq mut ỡt tâng cutễq ki, yuaq tỗp alới táq yỗn cứq sâng ũan lứq chóq rit cuang alới táq tỡ bữn bráh. ");
INSERT INTO bru_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ma cứq khoiq atỡng anhia chơ neq: Cứq ễ chiau cutễq phốn phuor yỗn anhia ndỡm. Cứq lứq yỗn anhia bữn ndỡm cutễq ki. Cứq la Yiang Sursĩ, Ncháu anhia, cớp cứq khoiq cayoah anhia yỗn ỡt miar tễ máh tỗp canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ngkíq, cóq anhia tutuaiq yỗn carsĩat tễ charán cớp chớm bráh tỡ la tỡ bữn bráh puai rit. Chỗi cha charán tỡ la chớm tỡ bữn bráh, yuaq cứq khoiq pai chơ máh charán ki la tỡ bữn bráh; cớp khân anhia cha charán ki, anhia cỡt tỡ bữn bráh tê. ");
INSERT INTO bru_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mứt pahỡm anhia cóq bráh o dŏq yỗn anhia cỡt khong cứq, yuaq cứq la Yiang Sursĩ ca bữn mứt bráh o lứq. Cứq khoiq cayoah yỗn anhia ỡt miar tễ máh tỗp canŏ́h, dŏq yỗn ống anhia sâng cỡt cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Samiang tỡ la mansễm aléq ma arô raviei cũai khoiq cuchĩt cỗ ễ sarhống, cóq noau tám án chóq tamáu toau cuchĩt. Cũai aléq ma táq ngkíq, cóq án roap bữm tôt cuchĩt ki.” ");
INSERT INTO bru_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yiang Sursĩ ớn Môi-se atỡng máh cũai tễng rit sang tễ tŏ́ng toiq Arôn, cớp ớn alới neq: “Chỗi yỗn noau tễ tỗp cũai tễng rit sang Yiang Sursĩ mut rôm parnơi toâq noau táq rit sễm ai alới cuchĩt, yuaq ranáq ngkíq táq yỗn án cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ma têq tê án mut rôm khân cumuiq ki la mpiq, mpoaq, con samiang, con mansễm, ");
INSERT INTO bru_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ai, tỡ la amuaq ca noâng tỡ yũah bữn cayac cớp noâng ỡt muoi dống cớp án. Têq án mut táq rit cumuiq ki, cớp án noâng cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ma án tỡ têq mut rôm parnơi khân cũai cuchĩt la tễ tỗp khỡi cuya, chơ cỡt tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Chỗi yỗn máh cũai tễng rit sang cũah sóc, tỡ la carái sóc bễc, tỡ la sỗt sâiq bữm apáh alới tanúh. ");
INSERT INTO bru_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Cóq alới bữn mứt bráh o chóq Yiang Sursĩ alới, cớp tỡ bữn táq yỗn ramứh Ncháu cỡt tỡ o. Yuaq alới dốq bốh chiau sang crơng cũai chiau sang yỗn Yiang Sursĩ, yuaq cóq alới ỡt bráh o níc. ");
INSERT INTO bru_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Cũai tễng rit sang Yiang Sursĩ tỡ têq racoâiq cớp mansễm chếq tỗ, tỡ la tỡ bữn plot o, tỡ la mpiq riang, yuaq cũai tễng rit la cũai miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Cóq anhia noap alới la cũai bráh o, yuaq alới cỡt cũai táq rit chiau sang crơng sana yỗn cứq. Yuaq cứq la Yiang Sursĩ bữn mứt bráh o lứq; cớp cứq sambráh mứt pahỡm cũai proai cứq yỗn cỡt bráh o lứq tê. ");
INSERT INTO bru_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Khân con cumũr cũai tễng rit sang Yiang Sursĩ ma chếq tỗ tâng dống sang yiang canŏ́h, mansễm ki táq yỗn mpoaq án cỡt casiet. Cóq bốh mumoong mansễm ki. ");
INSERT INTO bru_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Ma án ca sốt nheq tễ rit sang Yiang Sursĩ, la cũai noau khoiq hĩng dỡq nsễng miar tâng plỡ cớp chiau chớc yỗn án têq tâc tampâc cũai tễng rit sang, cóq án chỗi parai sóc, tỡ la háq tampâc dŏq apáh án tanúh. ");
INSERT INTO bru_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Cũai ki tỡ têq mut tâng dống bữn cũai cuchĩt, lứq pai cũai cuchĩt ki la mpoaq tỡ la mpiq án bữm. ");
INSERT INTO bru_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Yuaq án khoiq chiau sang tỗ dŏq táq ranáq cứq, ngkíq án tỡ bữn têq táq muoi ramứh ntrớu táq yỗn án cỡt tỡ bữn bráh puai rit, tỡ la táq yỗn Dống Sang Aroâiq cứq cỡt tỡ bữn bráh tê. ");
INSERT INTO bru_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Cóq án racoâiq cớp cumũr plot o. ");
INSERT INTO bru_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Chỗi yỗn án racoâiq cớp mpiq riang, tỡ la cán cumai, tỡ la mansễm cơi chếq tỗ. Án cóq racoâiq cớp mansễm plot o tễ tỗp án bữm. ");
INSERT INTO bru_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Táq ngkíq, án tỡ bữn táq yỗn con châu án cỡt tỡ bữn bráh puai rit. Cứq la Yiang Sursĩ; cứq toâp chóh án yỗn cỡt cũai sốt nheq tễ rit sang cứq.” ");
INSERT INTO bru_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","atỡng Arôn neq: “Chỗi yỗn cũai aléq tễ tŏ́ng toiq mới ca bữn bân tĩq tâng tỗ mut chiau sang crơng sana yỗn cứq. Santoiq patâp nâi cóq anhia ĩt tâc níc dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Chỗi yỗn cũai samiang ca bữn bân tĩq tâng tỗ án ma mut chiau sang crơng yỗn cứq, la cũai neq: Cũai moat sũt, yỗt ayững, roâp riang sâuq, ayững atĩ cooc ravĩat ");
INSERT INTO bru_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ayững atĩ cỡt luai nheq, ");
INSERT INTO bru_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","cloong tacô, tỡ la dễn luat ngư, a‑ĩ moat, a‑ĩ ngcâr, tỡ la samiang noau lát. ");
INSERT INTO bru_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Cũai tễng rit sang tễ tŏ́ng toiq Arôn ma bữn tỗ chác ngkíq, án tỡ têq toâq chiau sang crơng yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Têq cũai ki cha sana khoiq noau chiau sang yỗn cứq, cớp crơng sana noau chiau sang miar cớp mpon yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ma chỗi yỗn án mut cheq Dống Sang Aroâiq pỡ Ntốq Tễng Rit, tỡ la mut cheq prông sang, dŏq án tỡ bữn táq yỗn máh ntốq ki cỡt tỡ bữn bráh; yuaq cứq la Yiang Sursĩ, án ca tễng tỗp alới yỗn cỡt bráh o.” ");
INSERT INTO bru_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Máh santoiq ki Môi-se atỡng Arôn cớp tỗp con samiang Arôn, dếh dũ náq cũai proai I-sarel hỡ. ");
INSERT INTO bru_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","atỡng Arôn cớp tỗp con samiang Arôn neq: “Cóq anhia nhêng yỗn o tễ crơng mpon cũai proai I-sarel dững chiau sang yỗn cứq, dŏq yỗn anhia tỡ bữn dững ranáq casiet táq pỡ ramứh cứq. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Khân bữn muoi noaq tễ tŏ́ng toiq anhia ma cỡt tỡ bữn bráh puai phễp rit, ma án mut cheq crơng mpon cũai proai I-sarel dững chiau sang yỗn cứq, cũai ki tỡ têq mut noâng táq ranáq cứq pỡ ntốq prông sang. Máh ŏ́c patâp nâi cóq anhia tâc mantái níc. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Khân bữn cũai aléq tễ tŏ́ng toiq Arôn a‑ĩ ngcâr têq tớt pỡ cũai canŏ́h, tỡ la bữn dỡq ngoai loŏh tễ tỗ chác, chỗi yỗn án cha crơng noau chiau sang toau án cỡt bráh puai rit. Cũai tễng rit sang cỡt tỡ bữn bráh tê khân án satoaq crơng tỡ bữn bráh, dếh sac cuchĩt, tỡ la dỡq ramia loŏh tễ sarcal; ");
INSERT INTO bru_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","tỡ la án satoaq cũai tỡ la charán tỡ bữn bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Khân cũai tễng rit sang cỡt tỡ bữn bráh puai rit, án cỡt tỡ bữn bráh toau toâq sadâu. Cớp án tỡ têq cha crơng mpon noau chiau sang, khân án tỡ yũah mpơi dỡq sambráh tỗ chác án voai. ");
INSERT INTO bru_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Toâq mandang ngêt chơ, án cỡt bráh loah, cớp têq án cha loah máh crơng noau chiau sang ca cỡt pún án. ");
INSERT INTO bru_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Chỗi cha sâiq charán aléq chống cuchĩt, tỡ la charán canŏ́h cáp cuchĩt; crơng sana ki táq yỗn anhia cỡt tỡ bữn bráh puai rit. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Ngkíq, nheq máh cũai tễng rit sang cóq táq puai máh phễp rit cứq khoiq chiau yỗn alới. Khân tỡ bữn ngkíq, alới táq lôih cớp alới cóq cuchĩt, yuaq alới táq claiq phễp rit ki. Cứq la Yiang Sursĩ, cớp cứq toâp táq yỗn tỗp alới cỡt bráh o. ");
INSERT INTO bru_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Ống cũai tễ tŏ́ng toiq cũai tễng rit sang sâng têq cha crơng chiau sang; cũai canŏ́h tỡ têq cha, dếh cũai tamoi, dếh cũai ca cũai tễng rit sang khoiq chang yỗn táq ranáq. ");
INSERT INTO bru_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ma cũai sũl ca cũai tễng rit sang khoiq chỡng chơ, tỡ la cũai sũl canỡt tâng dống sũ án, têq alới ki cha sana cũai tễng rit sang roap cỡt pún án. ");
INSERT INTO bru_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Khân con cumũr cũai tễng rit sang khoiq racoâiq cớp cũai tỡ cỡn cũai tễng rit sang, án tỡ têq cha crơng noau chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ma khân con cumũr cũai tễng rit sang ma cỡt cán cumai, tỡ la cỡt mpiq riang tỡ yũah bữn con, cớp án píh chu loah pỡ dống sũ mpoaq án, têq án cha crơng sana mpoaq án bữn roap. Ống cũai ca ỡt tâng dống sũ cũai tễng rit sang sâng têq cha crơng noau chiau sang ki. ");
INSERT INTO bru_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Khân bữn cũai canŏ́h ma lơ cha sana ki, ma án tỡ bữn chanchớm nhũang cha, cóq án yỗn pỡ cũai tễng rit sang kia tễ sana án cha; cớp cóq án culáh tữm ễn bar pún tễ muoi chít pún. ");
INSERT INTO bru_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Cóq cũai tễng rit sang tỡ bữn mumat crơng chiau sang ki, ");
INSERT INTO bru_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","na yỗn cũai canŏ́h cha crơng noau chiau sang. Khân án táq ngkíq, án táq yỗn alới cóq chiau sang crơng pláih loah lôih. Cứq la Yiang Sursĩ, cớp cứq toâp táq yỗn cũai cỡt bráh o.” ");
INSERT INTO bru_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","chiau máh phễp rit nâi yỗn Arôn cớp tỗp con samiang án, dếh máh cũai proai I-sarel hỡ, neq: “Toâq cũai I-sarel, tỡ la cũai tễ cruang canŏ́h ỡt tâng cutễq cũai I-sarel, yoc ễ dững crơng bốh chiau sang yỗn Yiang Sursĩ, tam alới ễ táq puai loah santoiq alới khoiq parkhán, tỡ la cỗ bũi pahỡm yoc ễ yỗn, charán ễ dững sang cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Crơng sang Yiang Sursĩ roap tễ anhia la cóq charán tôl ŏ́q bân tĩq tễ cantóh ntroŏq, cữu, tỡ la mbễq anhia. ");
INSERT INTO bru_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Khân anhia chiau sang charán bữn ntốq tĩq, ki Yiang Sursĩ tỡ bữn roap crơng ki. ");
INSERT INTO bru_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Khân bữn cũai aléq chiau sang crơng dŏq cỡt ratoi, tỡ bữn pai crơng sang ki dŏq táq puai loah máh santoiq khoiq parkhán, tỡ la cỗ mứt pahỡm yoc ễ chiau sang, charán ễ sang cóq tỡ bữn bân tĩq nŏ́q têq Yiang Sursĩ roap. ");
INSERT INTO bru_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Chỗi chiau sang yỗn Yiang Sursĩ charán moat sũt, ayững ralĩh, bữn rapit, bữn panúng tỡ la dỡq ngoai hoi loŏh, cỡt sarang tỡ la cahưon. Chỗi dững charán ngkíq chu prông dŏq cỡt crơng chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ma khân anhia chiau sang cỗ pahỡm sâng yoc, têq anhia chiau sang charán cớt, tỡ la ayững cooc ravĩat; ma khân ễ chiau sang dŏq táq puai loah santoiq án parkhán, ki tỡ têq. ");
INSERT INTO bru_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Chỗi chiau sang charán khoiq pacháiq tarễl, cứt, lát, tỡ la culáiq aloŏh. Chỗi táq ranáq nâi tâng cutễq anhia. ");
INSERT INTO bru_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“Chỗi ĩt charán ngkíq tễ cũai cruang canŏ́h táq rit chiau sang yỗn Yiang Sursĩ, yuaq charán ki bữn ntốq tĩq; ngkíq Ncháu tỡ bữn roap.” ");
INSERT INTO bru_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Khân con ntroŏq, con cữu, tỡ la con mbễq mbỡiq roah, cóq anhia dŏq cớp mpiq án tapul tangái voai; vớt ki, têq anhia dững charán ki táq rit chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Chỗi kiac ntroŏq acán cớp con tỡ la cữu acán cớp con tâng muoi tangái, dŏq dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Toâq anhia táq rit chiau sang dŏq sa‑ỡn Yiang Sursĩ, cóq anhia táq puai rit, dŏq Yiang Sursĩ roap crơng anhia chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Cóq anhia cha crơng chiau sang ki tâng tangái ki toâp, chỗi dŏq toâq tangái parnỡ. Cứq la Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Yiang Sursĩ pai neq: “Cóq anhia yống pacái phễp rit cứq, cớp táq puai, yuaq cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Chỗi dững ŏ́c casiet atoâq pỡ ramứh bráh o cứq; ma yỗn dũ náq cũai proai I-sarel ngin samoât lứq cứq la Yiang Sursĩ bráh o lứq, cớp cứq toâp táq yỗn anhia cỡt bráh o tê. ");
INSERT INTO bru_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Cứq khoiq dững aloŏh anhia tễ cruang Ê-yip-tô dŏq cỡt Yiang Sursĩ anhia. Cứq la Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yiang Sursĩ ớn Môi-se atỡng tỗp ");
INSERT INTO bru_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","cũai proai I-sarel máh phễp rit tễ máh tangái khoiq anoat dŏq toâq rôm sang toam Yiang Sursĩ, neq: ");
INSERT INTO bru_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Cóq anhia táq ranáq tâng tapoât tangái, ma tangái tapul la Tangái Rlu, la tangái dŏq anhia toâq rôm sang toam. Anhia ỡt pỡ ntốq léq, la cóq anhia noap Tangái Rlu la tangái miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Cóq pau atỡng rit cha bũi machớng khoiq anoat dŏq chơ. ");
INSERT INTO bru_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Rit cha bũi sanhữ Tangái Loŏh la tangái dŏq khễn Yiang Sursĩ. Tangái cha bũi ki la tabŏ́q tễ mandang pât tangái muoi chít la pỗn, casâi muoi. ");
INSERT INTO bru_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Cớp tangái muoi chít la sỡng la casâi ki tê, cỡt Tangái Cha Bễng Mi Ŏ́q Crơng Pluoih; chơ nheq tapul tangái cóq anhia chỗi cha bễng mi bữn crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Tâng tangái dâu tễ máh tangái cha bũi, cóq tỗp anhia toâq rôm parnơi dŏq sang toam, cớp chỗi táq ranáq ntrớu tâng tangái ki. ");
INSERT INTO bru_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ma cóq anhia chiau sang crơng sana yỗn Yiang Sursĩ tâng tapul tangái. Ma tâng tangái tapul, cóq anhia toâq rôm parnơi loah muoi trỗ ễn dŏq sang toam, cớp chỗi táq ranáq ntrớu ĩn ranáq anhia dốq táq.” ");
INSERT INTO bru_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yiang Sursĩ ớn Môi-se atỡng ễn chóq cũai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Toâq anhia mut ỡt tâng cutễq Yiang Sursĩ ễ chiau yỗn anhia, cớp toâq anhia ĩt máh palâi tễ cutễq ki, cóq anhia dững racong saro dâu anhia khoiq roaiq, chơ yỗn pỡ cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Cóq cũai tễng rit sang chiau sang racong saro ki dŏq cỡt crơng mpon yỗn Yiang Sursĩ, chơ Yiang Sursĩ lứq roap máh crơng anhia chiau sang. Cũai tễng rit sang cóq táq ngkíq tâng tangái muoi vớt tễ Tangái Rlu. ");
INSERT INTO bru_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Tâng tangái anhia táq rit chiau sang máh thữ racáu, cóq anhia bốh chiau sang muoi lám cữu tôl yỗn Yiang Sursĩ. Cữu ki cóq toâr muoi cumo, plứm o cớp ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Muoi prớh ki, cóq anhia chiau sang bỗt bar ki-lô talốc cớp dỡq nsễng o‑li‑vê dŏq cỡt crơng chiau sang máh thữ racáu. Hỡi phuom chanchức tễ crơng sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. Cớp cóq anhia chiau sang muoi lit blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Chỗi cha saro mi ĩt dâu lứq, khân anhia tỡ yũah chiau sang yỗn Yiang Sursĩ, tỡ bữn pai cha cláu tỡ la ễh, tỡ la padễng yỗn cỡt bễng mi. Máh tŏ́ng toiq anhia cóq noap ĩt máh phễp rit nâi dũ dỡi cũai mantái níc. ");
INSERT INTO bru_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Noap tễ tangái vớt Tangái Rlu cóq anhia dững racong saro dâu lứq toâq apỗng chiau sang yỗn Yiang Sursĩ, cóq anhia noap yỗn dũ tapul tốn ễn. ");
INSERT INTO bru_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Vớt tapul Tangái Rlu ki, máh tangái parnỡ ễn la tangái sỡng chít, cóq anhia dững racáu tamái toâq chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Dũ dống sũ cóq dững bar lám bễng mi dŏq chiau sang cỡt crơng mpon yỗn Yiang Sursĩ. Bễng mi dũ lám cóq táq toâq bar ki-lô bỗt talốc cớp crơng pluoih, cớp apỗng chiau sang yỗn Yiang Sursĩ machớng máh thữ racáu anhia ĩt dâu lứq. ");
INSERT INTO bru_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Muoi prớh cớp bễng mi ki, cóq anhia dững cữu tôl tapul lám mbỡiq muoi cumo, ntroŏq tôl muoi lám, cớp mbễq tôl bar lám, chơ chiau sang. Dũ lám charán ki cóq ŏ́q bân tĩq. Cóq tỗp anhia bốh máh charán ki chiau sang yỗn Yiang Sursĩ muoi prớh cớp chiau sang máh thữ racáu cớp blŏ́ng nho. Hỡi phuom chanchức tễ crơng sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Machớng nâi tê, cóq anhia chiau sang muoi lám mbễq tôl dŏq pupứt lôih, cớp bar lám cữu tôl bữn muoi cumo, chơ chiau sang dŏq cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Cóq cũai tễng rit sang dững bễng mi ki cớp bar lám cữu, chơ apỗng chiau sang yỗn Yiang Sursĩ. Crơng nâi cỡt pún cũai tễng rit sang, cớp cóq án apỗng chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Tâng tangái ki, anhia chỗi táq ranáq ntrớu; cóq anhia rôm sang toam Yiang Sursĩ sâng. Cóq tŏ́ng toiq anhia noap ĩt phễp rit nâi dũ dỡi cũai mantái níc, tam alới ỡt pỡ ntốq léq. ");
INSERT INTO bru_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Toâq anhia roaiq saro tâng sarái, chỗi roaiq mpễr tor, cớp chỗi muat loah. Cóq anhia táh yỗn cũai cadĩt cớp cũai tễ cruang canŏ́h ỡt cớp anhia têq bữn muat. Cứq la Yiang Sursĩ, Ncháu anhia.” ");
INSERT INTO bru_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yiang Sursĩ ớn Môi-se atỡng chóq cũai I-sarel, neq: ");
INSERT INTO bru_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tâng tangái muoi, casâi tapul, cóq anhia noap cỡt tangái miar dŏq rlu. Toâq anhia sâng sưong lavia bữr, cóq nheq tữh anhia toâq rôm parnơi dŏq sang toam Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Chỗi táq ranáq ntrớu tâng tangái ki; cóq anhia bốh crơng chiau sang yỗn Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yiang Sursĩ pai ễn cớp Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Dũ cumo tâng tangái muoi chít, casâi tapul, cóq cũai I-sarel táq rit sang dŏq pupứt lôih puai phễp rit. Tangái ki cóq anhia ót sana, ma cóq anhia toâq rôm sang toam cớp dững crơng dŏq bốh chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Chỗi táq ranáq ntrớu tâng tangái ki, yuaq tangái ki la Tangái Táq Rit Pupứt Lôih choâng moat Yiang Sursĩ, la Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Cũai aléq ma cha acán ntrớu tâng tangái ki, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Khân cũai aléq ma táq ranáq ntrớu tâng tangái ki, cứq táq yỗn cũai ki roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Cóq máh tŏ́ng toiq anhia noap ĩt tangái ki dũ dỡi mantái níc, tam alới ỡt pỡ ntốq léq. ");
INSERT INTO bru_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Noap tễ mandang pât tâng tangái takêh, casâi ki, toau toâq mandang pât tâng tangái muoi chít, cóq anhia noap samoât lứq tangái ki la tangái miar. Tâng tangái ki, chỗi yỗn cũai aléq cha ntrớu.” ");
INSERT INTO bru_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yiang Sursĩ ớn Môi-se atỡng cũai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Rit cha bũi Tangái Chóh Nloâh cóq noap tễ tangái muoi chít la sỡng, casâi tapul, cớp tapul tangái ễn. ");
INSERT INTO bru_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Tâng tangái muoi cóq anhia rôm sang toam Yiang Sursĩ, cớp chỗi táq ranáq ntrớu. ");
INSERT INTO bru_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Cu rangái tâng tapul tangái, cóq anhia bốh crơng chiau sang. Tâng tangái tacual, cóq anhia toâq rôm parnơi sĩa dŏq sang toam cớp chiau crơng sang yỗn Yiang Sursĩ. Tỗp anhia chỗi táq ranáq ntrớu, yuaq tangái ki la tangái dŏq sang toam Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“Máh tangái nâi la tangái táq rit cha bũi, sanhữ loah tễ tangái anhia yám noap dŏq khễn Yiang Sursĩ na rôm sang toam parnơi cớp chiau crơng sang yỗn Yiang Sursĩ neq: Crơng bốh sang, máh thữ racáu, máh crơng sang canŏ́h, cớp blŏ́ng nho; riang khoiq anoat dŏq yỗn táq tâng cu rangái. ");
INSERT INTO bru_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Máh tangái cha bũi nâi dŏq tữm cớp Tangái Rlu; máh crơng chiau sang nâi dŏq tữm cớp crơng anhia dốq chiau sang, crơng chiau sang dŏq táq puai loah santoiq khoiq parkhán, cớp crơng chiau sang tam pahỡm sâng yoc.) ");
INSERT INTO bru_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Vớt anhia ĩt palâi tễ máh sarái chơ, cóq anhia táq rit cha bũi tâng tapul tangái. Cóq anhia tabŏ́q táq rit ki tâng tangái muoi chít la sỡng, casâi tapul. Ma tangái dâu cớp tangái tacual, cóq anhia noap cỡt tangái miar dŏq rlu. ");
INSERT INTO bru_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Tâng tangái muoi cóq anhia dững máh palâi o lứq tễ sarnóh anhia chóh, ngcoong tarễc, cớp abễng bữn sala sa‑ữi; chơ cóq anhia táq puai rit dŏq khễn Yiang Sursĩ, la Ncháu anhia, nheq tapul tangái. ");
INSERT INTO bru_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Cóq anhia táq rit cha bũi tâng tapul tangái tâng cu cumo dŏq sang Yiang Sursĩ. Rit nâi cóq anhia cớp tŏ́ng toiq anhia táq puai níc dũ dỡi cũai. ");
INSERT INTO bru_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Cóq dũ náq cũai proai I-sarel ỡt tâng nloâh tapul tangái, ");
INSERT INTO bru_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","dŏq tŏ́ng toiq anhia têq dáng, la bo Yiang Sursĩ dững aloŏh cũai I-sarel tễ cruang Ê-yip-tô, án yỗn alới ỡt tâng nloâh. Cứq la Yiang Sursĩ, Ncháu anhia.” ");
INSERT INTO bru_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ngkíq Môi-se bữn atỡng yỗn cũai proai I-sarel máh rit cha bũi dŏq yám noap Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","atỡng cũai proai I-sarel neq: “Cóq anhia dững dỡq nsễng o‑li‑vê o lứq dŏq chóq tâng chớp tớu pỡ Dống Sang Aroâiq yỗn têq blữ níc toau tarưp. ");
INSERT INTO bru_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Dũ sadâu Arôn cóq tacât chớp tớu tâng Ntốq Tễng Rit, ma yáng tiah aroâiq ca catáng Hĩp Parnai Parkhán; cớp cóq án yỗn chớp tớu ki blữ níc toau poang tarưp. Cóq anhia noap ĩt phễp rit nâi dũ dỡi cũai mantái níc. ");
INSERT INTO bru_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arôn cóq ramoat yỗn o chớp tớu tâng pỡng rông noau táq toâq yễng muoi chít; cóq án nhêng salĩq yỗn chớp tớu ki blữ níc choâng moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Cóq anhia ĩt bỗt muoi chít la bar ki-lô mial táq bễng mi muoi chít la bar lám. ");
INSERT INTO bru_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Toâq táq moâm, patoi bễng mi cỡt bar rana, muoi rana tapoât lám, chơ chóq tâng cachơng noau blom toâq yễng muoi chít dŏq yáng moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Tâng dũ rana cóq chóq crơng phuom. Crơng ki cỡt tếc apáh khoiq bốh chiau sang bễng mi ki dŏq cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Dũ Tangái Rlu cóq achúh bễng mi choâng moat Yiang Sursĩ yỗn cũai I-sarel. Rit nâi cóq cũai I-sarel noap ĩt mantái níc. ");
INSERT INTO bru_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ma bễng mi ki cỡt pún Arôn cớp tỗp con samiang án; cóq alới cha bân ntốq miar, yuaq crơng ki cỡt crơng miar, cỗ noau khoiq chiau sang yỗn Yiang Sursĩ chơ.” ");
INSERT INTO bru_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Bo ki bữn manoaq samiang, mpoaq án la cũai Ê-yip-tô, mpiq án la cũai I-sarel. Ramứh mpiq án la Sê-lô-mit con cumũr Di-bri, tỗp Dan. Cũai samiang ki ralỗih cớp muoi noaq cũai I-sarel tâng ntốq alới ỡt. Bo alới ralỗih, án acrieiq ramứh Yiang Sursĩ. Yuaq ngkíq, noau dững án pỡq ramóh Môi-se. ");
INSERT INTO bru_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Môi-se ớn kháng samiang ki, acoan Yiang Sursĩ yỗn alới dáng raloaih lứq ễ táq nŏ́q tễ ranáq ki. ");
INSERT INTO bru_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yiang Sursĩ pai chóq Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Dững aloŏh samiang ca lóc acrieiq yáng tiah ntốq cũai ỡt, chơ yỗn dũ náq cũai ca sâng án lóc acrieiq satoaq atĩ tâng plỡ án, dŏq cỡt tếc án lứq táq lôih. Moâm ki, cóq máh cũai I-sarel ỡt tâng ntốq ki tám tamáu chóq án yỗn án cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Cóq mới atỡng cũai I-sarel neq: ‘Khân cũai aléq ma acrieiq Yiang Sursĩ, cóq án roap tôt án bữm; ");
INSERT INTO bru_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","cóq án cuchĩt. Cũai I-sarel tỡ la cũai tễ cruang canŏ́h ỡt cớp cũai I-sarel ma lóc acrieiq ramứh Yiang Sursĩ, cũai ki cóq pĩeiq cũai proai I-sarel tám án chóq tamáu toau cuchĩt.’ ");
INSERT INTO bru_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Cũai aléq ma cachĩt cũai canŏ́h, cóq án roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Cũai aléq ma cachĩt charán, cóq án culáh loah charán canŏ́h yỗn cũai ca ndỡm charán ki. Yuaq rit ki la neq: Mang pláih loah mang. ");
INSERT INTO bru_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Khân cũai aléq táq yỗn tỗ chác cũai canŏ́h bớc chũl, cóq noau táq loah chóq án machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Khân án táq muoi ntreh nghang cũai canŏ́h tacoaih, cóq án pláih loah muoi ntreh nghang án. Khân án táq moat cũai canŏ́h sũt, cóq án pláih loah ŏ́c moat tê. Khân án táq muoi ŏ́c canễng cũai canŏ́h tacoaih, cóq án pláih loah muoi ŏ́c canễng tê. Ntrớu án táq chóq cũai canŏ́h, cóq noau táq loah chóq án machớng ki tê. ");
INSERT INTO bru_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Khân cũai aléq cachĩt charán cũai canŏ́h, cóq án culáh loah charán yỗn cũai canŏ́h ki. Khân cũai aléq cachĩt cũai canŏ́h, án cóq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Dũ náq anhia cóq yống yỗn pacái máh phễp rit nâi, tam cũai I-sarel tỡ la cũai tễ cruang canŏ́h ỡt cớp anhia. Cứq la Yiang Sursĩ, Ncháu anhia.” ");
INSERT INTO bru_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Toâq moâm Môi-se pai santoiq nâi yỗn máh cũai proai I-sarel tamứng, alới dững aloŏh cũai samiang ki yáng tiah ntốq cũai ỡt, cớp tám tamáu chóq án toau cuchĩt. Máh cũai proai I-sarel táq ngkíq, la táq puai machớng Yiang Sursĩ khoiq patâp toâq Môi-se. ");
INSERT INTO bru_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yiang Sursĩ atỡng Môi-se pỡ cóh Si-nai yỗn án ");
INSERT INTO bru_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","atỡng loah cũai proai I-sarel neq: “Toâq tỗp anhia bữn mut ỡt tâng cutễq Yiang Sursĩ ễ chiau yỗn anhia, cóq anhia apáh ŏ́c yám noap Yiang Sursĩ na chỗi píq cutễq tỡ la chóh sarnóh tâng cu cumo tapul. ");
INSERT INTO bru_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Tâng tapoât cumo têq anhia chóh cuplốq, muat palâi nho, cớp parỗm máh sarnóh sarbống. ");
INSERT INTO bru_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ma tâng cumo tapul, cóq anhia yỗn máh cutễq rlu amia sarnóh cỗ anhia chiau sang cumo ki yỗn Yiang Sursĩ. Chỗi chóh sarnóh tâng sarái tỡ la muat palâi nho. ");
INSERT INTO bru_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Chỗi roaiq saro muar, cớp chỗi asa voar nho. Cóq cutễq ki rlu amia sarnóh muoi cumo. ");
INSERT INTO bru_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Tâng cumo ki, tam anhia tỡ bữn táq ma án noâng amia sarnóh sarbống, ki anhia têq bữn cha, dếh máh cũai sũl, dếh máh cũai tuthễ anhia, cớp dếh máh cũai tễ cruang canŏ́h ỡt cớp anhia hỡ; ");
INSERT INTO bru_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","dếh charán anhia bán, cớp charán arưih ỡt tâng cutễq anhia. Dũ ramứh ca toâq tễ cutễq ki, têq anhia ĩt cha. ");
INSERT INTO bru_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Cóq anhia noap tapul cumo rlu, cỡt tapul trỗ tapul cumo, nheq tữh la pỗn chít takêh cumo. ");
INSERT INTO bru_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Tâng cumo ki tangái muoi chít, casâi tapul, la Tangái Táq Rit Pupứt Lôih, cóq anhia ớn máh cũai plóng lavia pỡq pau atỡng chũop cruang. ");
INSERT INTO bru_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ngkíq cóq anhia dŏq cumo sỡng chít yỗn cỡt cumo miar, cớp pau atỡng yỗn cũai proai chũop cruang dũ ntốq dáng cumo nâi cỡt Chuop Sỡng Chít Cumo, la cumo ien khễ. Tâng cumo nâi, máh crơng noau khoiq chếq, cóq án ca chỡng culáh loah yỗn cũai ca ndỡm nhũang, tỡ la yỗn tŏ́ng toiq án; cũai aléq ma noau chỡng dŏq táq sũl, cóq acláh yỗn án chu pỡ dống sũ án bữm. ");
INSERT INTO bru_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Tâng cumo ki, anhia chỗi chóh ntrớu tâng sarái, tỡ la roaiq saro muar, tỡ la muat palâi nho tâng nưong tỡ bữn asa. ");
INSERT INTO bru_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nheq muoi cumo ki cỡt cumo miar; ma têq anhia ĩt cha máh bát bai ca dáh bữm tâng sarái. ");
INSERT INTO bru_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Tâng cumo ki, máh mun noau khoiq chếq, cóq cũai ca chỡng culáh loah yỗn án ca ndỡm nhũang. ");
INSERT INTO bru_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ngkíq, toâq anhia chếq cutễq yỗn cũai I-sarel, la sễm ai muoi tỗp cớp anhia, tỡ la chỡng cutễq tễ alới, chỗi chếq chỡng ma tỡ bữn tanoang tapứng. ");
INSERT INTO bru_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ma kia cutễq, cóq anhia noap puai sếq cumo noâng têq chóh cớp muat sarnóh tâng cutễq ki, nhũang ễ toâq Chuop Sỡng Chít Cumo ễn. ");
INSERT INTO bru_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Khân bữn sa‑ữi cumo, ki yỗn kia tữm ễn; ma khân noâng bĩq cumo, cóq alíh kia tê, yuaq kia cutễq ki puai kia palâi têq bữn tễ cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Chỗi lôp cũai I-sarel, la sễm ai muoi tỗp cớp anhia, cóq anhia trĩh Yiang Sursĩ, la Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Cóq anhia trĩh dũ ŏ́c Yiang Sursĩ ớn cớp patâp, dŏq anhia ỡt tâng cutễq ki bữn plot ien. ");
INSERT INTO bru_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Chơ cutễq lứq amia sarnóh yỗn anhia; cớp anhia têq bữn cha pasâi, dếh ỡt tâng cruang bữn ien khễ hỡ. ");
INSERT INTO bru_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Khân bữn cũai blớh neq: ‘Ntrớu hái ễ ĩt cha tâng cumo tapul, khân hái tỡ bữn chóh ntrớu tâng cutễq, cớp tỡ bữn roaiq ĩt palâi ntrớu?’ ");
INSERT INTO bru_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Cứq lứq satốh ŏ́c bốn tâng cumo tapoât, dŏq têq cỡt palâi sa‑ữi yỗn khám cha tâng bar cumo ntun. ");
INSERT INTO bru_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Toâq anhia chóh sarnóh tâng cumo tacual, anhia noâng bữn cha sana clữi tễ cumo tapoât, cớp anhia bữn dũ cha toau toâq catữ ĩt máh palâi tễ sarnóh chóh tâng cumo ki. ");
INSERT INTO bru_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Cutễq ki anhia tỡ têq chếq loâng, yuaq cutễq ki tỡ cỡn anhia ndỡm, ma cứq ndỡm; cớp anhia cỡt ariang cũai tễ cruang canŏ́h ma cứq yỗn chóh sarnóh dŏq têq bữn cha tâng cutễq ki sâng. ");
INSERT INTO bru_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Nheq tữh cruang cutễq anhia ndỡm, cóq anhia táq yỗn án ca chếq cutễq têq chỡng loah cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Khân cũai I-sarel ma cadĩt, cớp án cóq chếq muoi tâm cutễq, ki sễm ai án ca cheq lứq têq chỡng loah tâm cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Khân cũai aléq ŏ́q sễm ai têq chỡng loah tâm cutễq ki, ma toâq ntun ễn pĩeiq án bữm cỡt sốc cớp bữn dũ práq, têq án chỡng loah tâm cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Khân án ễ táq ngkíq, cóq án noap loah noâng sếq cumo tễ tangái án ễ chỡng toau toâq chuop sỡng chít cumo, chơ cóq án culáh loah kia noâng tu cũai ca khoiq chỡng tâm cutễq ki tễ án. ");
INSERT INTO bru_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ma khân án bữn práq tỡ bữn dũ thái loah tâm cutễq ki, cũai ca chỡng tâm cutễq ki noâng ndỡm yỗn toau toâq loah Chuop Cumo Sỡng Chít chumát ễn. Tữ toâq cumo ki, cóq án culáh loah tâm cutễq nâi yỗn án ca ndỡm tễ nhũang. ");
INSERT INTO bru_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Khân bữn cũai aléq ma chếq dống mpứng dĩ vil ca bữn viang, toâq án chếq, ki têq án chỡng loah khân tâng clống muoi cumo noap tễ tangái án chếq. ");
INSERT INTO bru_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Khân án tỡ bữn thái loah tâng clống muoi cumo, ki án tỡ têq thái loah noâng; cớp dống ki cỡt khong cũai ca chỡng cớp tŏ́ng toiq cũai ki loâng. Toâq Chuop Sỡng Chít Cumo, la án tỡ bữn culáh noâng. ");
INSERT INTO bru_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Khân dống ỡt tâng vil ma ŏ́q viang, cóq anhia noap dống ki machớng cutễq sarái; cũai ca ndỡm nhũang têq chỡng loah cutễq ki, cớp toâq Chuop Sỡng Chít Cumo tâm cutễq ki cóq culáh loah yỗn án ca lứq ncháu. ");
INSERT INTO bru_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ma cũai Lê-vi bữn chớc têq chỡng loah máh mun tâng clống vil alới. Bo léq, la têq alới chỡng loah khân ỡt tâng vil khoiq anoat dŏq yỗn alới. ");
INSERT INTO bru_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Khân manoaq cũai Lê-vi ma chếq dống tâng clống vil tỗp Lê-vi cớp tỡ bữn chỡng loah, toâq Chuop Sỡng Chít Cumo cóq culáh loah dống ki yỗn án, yuaq dống tâng vil tỗp Lê-vi cỡt mun alới mantái níc tâng mpứng dĩ cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ma tâm cutễq mpễr vil cũai Lê-vi, tỡ têq chếq ta-ŏh tháng, yuaq máh tâm cutễq ki cỡt pún tỗp alới mantái níc. ");
INSERT INTO bru_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Khân bữn muoi noaq cũai I-sarel ỡt cheq dống sũ anhia ma cadĩt lứq toau án tỡ dáng ntrớu ễ chứm siem tỗ chác án bữm, cóq anhia chuaq rana chuai án, machớng anhia chuai cũai tễ cruang canŏ́h ỡt cớp anhia tê dŏq án têq ỡt cheq níc anhia. ");
INSERT INTO bru_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Chỗi ĩt lơi tễ án, ma cóq anhia trĩh Yiang Sursĩ, cớp yỗn án ỡt cheq nứng anhia. ");
INSERT INTO bru_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Chỗi ĩt lơi tễ práq anhia yỗn án voaq, cớp chỗi ĩt práq lơi tễ sana anhia chếq yỗn án cha. ");
INSERT INTO bru_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nâi la santoiq cứq patâp anhia; cứq la Yiang Sursĩ, Ncháu anhia, án ca khoiq dững aloŏh anhia tễ cruang Ê-yip-tô dŏq chiau cutễq tỗp Cana-an yỗn anhia, cớp dŏq cỡt Yiang Sursĩ anhia. ");
INSERT INTO bru_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Khân sễm ai cũai I-sarel ỡt cheq anhia ma túh cadĩt lứq toau án chếq tỗ bữm dŏq cỡt sũl anhia, chỗi táq chóq án ariang anhia táq chóq cũai sũl canŏ́h. ");
INSERT INTO bru_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Cóq anhia nhêng án machớng cũai tuthễ, tỡ la cũai ỡt dỡ, cớp yỗn án ỡt táq ranáq anhia toau toâq Chuop Sỡng Chít Cumo chumát. ");
INSERT INTO bru_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ma toâq cumo ki, cóq anhia acláh án cớp con án yỗn alới chu pỡ dống sũ alới, cớp yỗn alới ndỡm loah máh mun achúc achiac alới. ");
INSERT INTO bru_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Máh cũai proai I-sarel la cũai táq ranáq cứq nheq, yuaq cứq khoiq dững tỗp alới loŏh tễ cruang Ê-yip-tô; tỡ bữn noau têq chếq alới yỗn cỡt cũai sũl. ");
INSERT INTO bru_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Chỗi cuhễq alới; ma cóq anhia trĩh Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Khân anhia yoc ễ bữn cũai sũl samiang tỡ la mansễm, têq anhia chỡng tễ cruang ỡt mpễr anhia. ");
INSERT INTO bru_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Cớp têq anhia chỡng con châu cũai tễ cruang canŏ́h ỡt parnơi cớp anhia. Máh carnễn sễt tâng cutễq anhia têq cỡt mun anhia, ");
INSERT INTO bru_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","tỡ la mun con châu anhia nheq dỡi tamoong alới. Ma anhia chỗi catưp máh cũai I-sarel, la cũai muoi tỗp cớp anhia. ");
INSERT INTO bru_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Sacâm bữn muoi noaq cũai tễ cruang canŏ́h ỡt cớp tỗp anhia ma cỡt sốc lứq; cớp bữn muoi noaq tỗp sễm ai cũai I-sarel cỡt túh cadĩt, chơ án chếq tỗ bữm dŏq cỡt sũl cũai sốc ki, tỡ la sũl manoaq canŏ́h tâng sâu án. ");
INSERT INTO bru_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Toâq án chếq tỗ bữm chơ, noâng án bữn chớc têq chỡng loah tỗ bữm. Cớp têq máh sễm ai án thái loah án; ");
INSERT INTO bru_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","têq cũq, tỡ la con ai con a‑ễm, tỡ la máh cũai cỡt sễm ai án, thái loah án; tỡ la khân án bữn práq dũ, têq án thái loah tỗ án bữm. ");
INSERT INTO bru_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Cóq án sarhống cớp cũai ca chỡng án nhũang voai, chơ alới cóq noap cumo tễ tangái án chếq tỗ án cỡt sũl toau toâq Chuop Sỡng Chít Cumo ca ễ toâq. Cóq noau yỗn kia pỡ cũai ca chỡng án li cớp cóng yỗn cũai tuthễ tâng máh cumo ca noâng. ");
INSERT INTO bru_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Khân noâng sa‑ữi cumo cóq án culáh sa‑ữi. ");
INSERT INTO bru_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Khân noâng bĩq cumo toau Chuop Sỡng Chít Cumo, cóq án yỗn bĩq sâng. ");
INSERT INTO bru_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Cóq táq chóq án machớng cũai tuthễ. Chỗi yỗn cũai ca ndỡm án padâm án. ");
INSERT INTO bru_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Khân tỡ bữn acláh án ariang khoiq pai chơ, án cớp con án cóq noau acláh toâq Chuop Sỡng Chít Cumo ca ễ toâq. ");
INSERT INTO bru_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Cũai I-sarel tỡ têq cỡt sũl toau sốt dỡi, cỗ tỗp alới cỡt khong cứq, yuaq cứq khoiq dững aloŏh alới tễ cruang Ê-yip-tô. Cứq la Yiang Sursĩ, Ncháu anhia.” ");
INSERT INTO bru_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Yiang Sursĩ pai neq: “Chỗi táq rup yiang canŏ́h dŏq cucốh sang, tỡ la ayứng rup noau mial, tanũl tamáu, tamáu côl tốc cỡt rup dŏq cucốh sang. Cứq la Yiang Sursĩ, Ncháu anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Cóq anhia noap Tangái Rlu, cớp cóq anhia yám noap ntốq noau sang toam cứq. Cứq la Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Khân anhia puai samoât samơi santoiq cứq patâp cớp ớn, ");
INSERT INTO bru_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","cứq lứq yỗn mia sễng pĩeiq catữ dŏq cutễq têq amia sarnóh, cớp máh aluang têq cỡt palâi bong lêt. ");
INSERT INTO bru_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Máh sarnóh anhia lứq cỡt palâi toau ngư anhia roaiq saro cớp cáiq palâi nho; cớp anhia noâng bữn cáiq palâi nho toau toâq loah catữ trứh hỡ. Anhia têq bữn dũ ramứh sana anhia yoc ễ bữn, cớp anhia bữn ỡt tâng cutễq ki plot ien. ");
INSERT INTO bru_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Cứq yỗn ŏ́c ien khễ toâq pỡ cutễq anhia; chơ anhia têq bếq ien khễ, tỡ bữn clơng ntrớu noâng. Cứq tuih aloŏh nheq máh charán pla ỡt tâng cutễq anhia, cớp tỡ bữn noau toâq rachíl ratáq noâng tâng cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Anhia têq chíl riap máh cũai par‑ũal anhia; alới dớm nheq toâq dau anhia tráh alới. ");
INSERT INTO bru_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Sỡng náq tễ tỗp anhia têq chíl riap muoi culám náq cũai par‑ũal yỗn alới cỡt pê, cớp muoi culám náq tễ tỗp anhia têq chíl riap muoi chít ngin náq cũai par‑ũal yỗn alới cỡt pê. ");
INSERT INTO bru_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Cứq ễ satốh ŏ́c bốn yỗn anhia bữn con châu rứh rưong sa‑ữi; cớp cứq yống pacái níc máh santoiq cứq khoiq par‑ữq cớp anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Anhia têq bữn palâi sa‑ữi, dũ cha tâng bar cumo; cớp anhia ngcỗi aloŏh nheq máh palâi noâng clữi tễ cumo khoiq vớt, chơ dŏq máh palâi anhia mbỡiq kéh tâng cumo tamái ễn. ");
INSERT INTO bru_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Cứq ễ ỡt tâng Dống Sang Aroâiq khong cứq tâng mpứng dĩ tỗp anhia, cớp tỡ bữn chứng clĩ tễ tỗp anhia noâng. ");
INSERT INTO bru_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Cứq lứq ỡt cớp anhia cớp cỡt Yiang Sursĩ anhia; cớp anhia cỡt cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Cứq la Yiang Sursĩ, Ncháu anhia; án ca khoiq dững anhia loŏh tễ cruang Ê-yip-tô dŏq anhia tỡ bữn cỡt noâng sũl cũai Ê-yip-tô. Cứq khoiq thot chíq patu tễ tacong anhia cớp chuai anhia yỗn tayáh pỡq ien khễ.” ");
INSERT INTO bru_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Yiang Sursĩ pai ễn neq: “Ma khân anhia tỡ bữn trĩh santoiq cứq patâp, anhia lứq roap ŏ́c bap. ");
INSERT INTO bru_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Khân anhia calỡih phễp rit cứq khoiq patâp, cớp táq claiq máh santoiq cứq khoiq parkhán cớp anhia, ");
INSERT INTO bru_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","cứq lứq manrap anhia. Cứq ễ dững atoâq ŏ́c cuchĩt pứt pỡ anhia, la a‑ĩ u-áih cớp a‑ĩ ỗn, a‑ĩ ca têq táq yỗn moat anhia cỡt sũt cớp cuchĩt lốp miat sâng. Anhia chóh sarnóh sa‑ữi ramứh, ma anhia tỡ dáng bữn cha palâi; yuaq cũai par‑ũal anhia mut cheng ndỡm chíq, cớp alới ĩt cha máh palâi tễ anhia khoiq pứt cóng chóh. ");
INSERT INTO bru_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Cứq ễ píh toâq chíl anhia, táq yỗn anhia cỡt pê chóq cũai par‑ũal cớp kêt anhia; alới ễ cỡt sốt anhia. Anhia cỡt ngcŏh lứq toau lúh khlỡt, ma tỡ bữn noau rapuai anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Khân cỡt ranáq ariang nâi ma anhia noâng tỡ ễq trĩh cứq, ki cứq manrap anhia tapul trỗ ễn. ");
INSERT INTO bru_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Cứq ễ talốh ŏ́c pampla anhia; cứq táq yỗn paloŏng tỡ bữn mia, cutễq cỡt cahễng, cớp cutễq anhia chóh sarnóh cỡt lêng samoât lantar. ");
INSERT INTO bru_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Anhia táq ranáq ntâng lứq, ma tỡ bữn cỡt kia ntrớu, cỗ cutễq anhia chóh sarnóh tỡ bữn amia acán ntrớu, cớp nỡm aluang tỡ bữn cỡt palâi. ");
INSERT INTO bru_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Khân anhia noâng lớn-sarlớn ễ chíl cớp tỡ ễq trĩh cứq, cứq acữn ŏ́c bap yỗn anhia tapul trỗ ễn. ");
INSERT INTO bru_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Cứq ễ yỗn máh charán pla lứq toâq cachĩt con anhia, cớp talốh táh nheq máh charán anhia bán. Táq ngkíq, cứq pupứt yỗn thréc nheq, toau tâng máh rana tỡ bữn cũai pupỡq noâng. ");
INSERT INTO bru_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Toâq ranáq manrap nâi vớt chơ, ma anhia noâng tỡ bữn trĩh cứq, cớp noâng mumat cứq, ");
INSERT INTO bru_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","cứq lứq píh toâq chíl loah anhia, cớp manrap anhia yỗn ntâng hỡn tễ trỗ nhũang tapul trỗ ễn. ");
INSERT INTO bru_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Cứq ễ dững ranáq rachíl rapoâiq dŏq manrap anhia, cỗ tian anhia táq claiq santoiq hái khoiq parkhán. Khân anhia toâq rôm parnơi pỡ vil ễq yỗn plot-plál, cứq yỗn a‑ĩ áih toâq tâng mpứng dĩ tỗp anhia, cớp cũai par‑ũal ễ ễp anhia yỗn chĩuq pê. ");
INSERT INTO bru_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Cứq ễ catáng chíq sana chứm siem anhia, dŏq muoi chít náq mansễm padễng bễng mi tâng muoi lo sâng. Chơ alới tampễq bễng mi yỗn anhia cha, ma anhia noâng sâng panhieih. ");
INSERT INTO bru_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Toâq máh ranáq nâi vớt chơ, ma noâng anhia coang ngian sĩa, ");
INSERT INTO bru_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","cứq ễ manrap anhia ntâng hỡn tễ nhũang tapul trỗ ễn. ");
INSERT INTO bru_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Anhia cỡt panhieih khlac toau cha dếh con anhia bữm. ");
INSERT INTO bru_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Cứq ễ talốh ntốq anhia sang tâng anũol cóh, cớp sarŏ́q táh nheq prông anhia chiau sang crơng phuom, dếh sarpứt sac anhia tâng rup anhia sang ca rúng ralốh. Máh sóc la cứq tỡ ễq hữm noâng anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Cứq ễ ralêq vil anhia yỗn cỡt vil rangual ễn, cớp cứq ễ talốh táh nheq ntốq anhia cucốh sang, cớp tỡ ễq roap ĩt crơng anhia chiau sang. ");
INSERT INTO bru_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Cứq ễ talốh nheq cutễq anhia, dŏq cũai ca cheng ĩt cutễq ki cỡt ngcŏh, cỗ tian tễ ranáq talốh ki. ");
INSERT INTO bru_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Cứq ễ dững atoâq ranáq rachíl ratáq ntâng lứq pỡ anhia dŏq táq yỗn anhia cỡt pláh chap chu cruang canŏ́h. Cutễq anhia ễ cỡt sŏ́c cớp tỡ bữn acán ntrớu ỡt noâng. Máh vil anhia cỡt rangual cớp ralốh-ralái nheq. ");
INSERT INTO bru_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Chơ cutễq ki ỡn apũol, yuaq cumo ki bữn án rlu amia sarnóh; ma tễ nhũang, anhia tỡ yỗn cutễq ki bữn rlu. Bo cutễq ki cỡt rangual, án bữn rlu, yuaq anhia tarôq ỡt tâng ntốq canŏ́h la cruang cutễq cũai par‑ũal anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Cứq ễ táq yỗn cũai tễ tỗp anhia ca noâng ỡt tâng ntốq ki cỡt pứt mứt. Khân alới sâng sưong cuyal phát ploaq sala aluang, la alới cỡt ngcŏh lứq, ễ lúh toâp tễ ntốq ki. Alới lúh ariang cũai par‑ũal rapuai alới tâng ntốq rachíl; chơ alới dớm, tam tỡ bữn noau rapuai. ");
INSERT INTO bru_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Anhia lúh ratũl bữm, ma tỡ bữn noau rapuai, cớp anhia pê toâq anhia chíl cũai par‑ũal anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Anhia lứq cuchĩt bân ntốq tỡ cỡn cruang anhia, ma tâng cruang cutễq cũai par‑ũal anhia, ariang cutễq ki lưn anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Cũai noâng bữn tamoong, parsốt lứq alới cuchĩt tê, cỗ tian lôih anhia cớp lôih achúc achiac anhia. ");
INSERT INTO bru_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ma chumát tŏ́ng toiq anhia ễ ngin kho lôih alới, cớp lôih achúc achiac alới, la nheq tữh cũai ca chíl cứq cớp ễ cheng sốt cứq. ");
INSERT INTO bru_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Cỗ tễ ranáq ki, cứq píh toâq chíl tỗp alới, cớp yỗn alới ỡt tarôq tâng cruang cutễq cũai par‑ũal alới. Chơ vớt ki, toâq tŏ́ng toiq anhia asễng tỗ cớp roap ŏ́c cứq manrap alới cỗ tian tễ ranáq lôih cớp ranáq tỡ o alới, ");
INSERT INTO bru_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","bo ki cứq sanhữ loah parnai cứq khoiq par‑ữq cớp Yacốp, I-sac, cớp A-praham, la achúc achiac anhia. Cớp cứq cu‑óh loah parnai cứq khoiq par‑ữq ễ chiau cutễq ki yỗn máh cũai proai cứq. ");
INSERT INTO bru_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Dâu lứq, cóq cutễq ki tỡ bữn cũai ỡt, dŏq cutễq rlu amia; cớp tỗp alới cóq roap tôt, yuaq alới khoiq táh phễp rit cớp ŏ́c cứq patâp. ");
INSERT INTO bru_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Tam khoiq cỡt ngkíq chơ, bo alới noâng tarôq ỡt tâng cutễq cũai par‑ũal alới, cứq tỡ bữn táh loâng alới, tỡ la yỗn noau pupứt táh nheq alới. Khân cứq táq ngkíq, la samoât cứq hưoc chíq santoiq cứq khoiq par‑ữq cớp alới. Cứq la Yiang Sursĩ, Ncháu alới. ");
INSERT INTO bru_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ma cứq ễ aloŏh loah parnai cứq par‑ữq cớp achúc achiac alới, toâq cứq khoiq apáh yỗn dũ tỗp cũai hữm chớc cứq bo cứq dững máh cũai proai cứq loŏh tễ cruang Ê-yip-tô. Cứq la Yiang Sursĩ, Ncháu alới.” ");
INSERT INTO bru_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Nheq tữh ŏ́c nâi la phễp rit cớp ŏ́c Yiang Sursĩ patâp na Môi-se tâng anũol cóh Si-nai, dŏq yỗn máh cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yiang Sursĩ chiau yỗn Môi-se ");
INSERT INTO bru_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","máh phễp rit nâi, yỗn án atỡng loah cũai proai I-sarel neq: “Toâq cũai aléq parkhán samoât samơi lứq, pai án ễ chiau sang tỗ án yỗn Yiang Sursĩ, têq án thái loah tỗ án na chiau práq ariang khoiq anoat dŏq tâng dống sang neq: ");
INSERT INTO bru_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Cũai samiang tễ bar chít la sỡng cumo toâq tapoât chít cumo, cóq án chiau práq sỡng chít ŏ́c; ");
INSERT INTO bru_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","cũai mansễm ca bữn cumo máh ki tê, cóq án chiau práq pái chít ŏ́c; ");
INSERT INTO bru_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","samiang sanyỡr tễ sỡng cumo toâq bar chít cumo, cóq án chiau práq bar chít ŏ́c. Cớp mansễm sanyỡr ca bữn cumo máh ki tê, cóq án chiau práq muoi chít ŏ́c; ");
INSERT INTO bru_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","carnễn samiang hỡn tễ sỡng cumo cóq án chiau práq sỡng ŏ́c. Cớp mansễm ca bữn cumo máh ki tê, cóq án chiau práq pái ŏ́c; ");
INSERT INTO bru_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","samiang tapoât chít cumo achỗn, cóq án chiau práq muoi chít la sỡng ŏ́c. Cớp mansễm ca bữn cumo máh ki tê, cóq án chiau práq muoi chít ŏ́c. ");
INSERT INTO bru_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Khân bữn cũai aléq ma túh cadĩt lứq, cớp tỡ dáng ntrớu ễ culáh loah ŏ́c án khoiq ữq chơ, cóq anhia dững cũai ki pỡq ramóh cũai tễng rit sang Yiang Sursĩ, dŏq yỗn cũai tễng rit sang aloŏh phễp rit tamái puai loah máh cũai ki rơi chiau yỗn. ");
INSERT INTO bru_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Khân án par‑ữq ễ chiau muoi lám charán ca pĩeiq puai rit yỗn Yiang Sursĩ, crơng ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Cũai ca khoiq par‑ữq ki tỡ têq ĩt charán canŏ́h ralêq loah charán án khoiq ữq chiau sang. Khân án táq ngkíq bar lám charán ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ma khân án par‑ữq ễ chiau sang charán tỡ bữn bráh puai rit, Yiang Sursĩ tỡ bữn roap charán ki. Cũai samiang ki cóq dững charán ki pỡ cũai tễng rit sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Chơ cũai tễng rit sang cóq atỡng kia charán ki puai charán ki o, tỡ la tỡ o; cũai tễng rit sang atỡng kia máh léq, ki lứq cỡt ngkíq. ");
INSERT INTO bru_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Khân samiang ki yoc ễ chỡng loah charán, cóq án yỗn práq li cớp práq khoiq atỡng chơ, cớp tữm ễn muoi pún tễ sỡng pún. ");
INSERT INTO bru_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Khân bữn cũai aléq chiau sang dống án dŏq cỡt miar khong Yiang Sursĩ, cũai tễng rit sang cóq atỡng kia dống ki puai ramứh o, tỡ la tỡ o. Maléq kia án pai, lứq cỡt ngkíq. ");
INSERT INTO bru_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Khân cũai samiang ca chiau sang dống ma ễ chỡng loah, cóq án yỗn práq máh kia dống ki, cớp tữm ễn muoi pún tễ sỡng pún. ");
INSERT INTO bru_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Khân bữn cũai aléq ma chiau sang muoi tâm cutễq tễ dống sũ án yỗn Yiang Sursĩ, yỗn án tếng kia cutễq ki puai loah cuplốq saro bali ca ễ trứh. Sacâm, khân trứh saro bali tâng cutễq ki bar chít ki-lô, kia cutễq muoi cumo muoi chít ŏ́c práq. ");
INSERT INTO bru_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Khân án ma chiau sang tâm cutễq ki bo mbỡiq vớt Chuop Sỡng Chít Cumo, kia tâm cutễq ki patoat riang tễ dâu. ");
INSERT INTO bru_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ma khân án chiau sang tâm cutễq ntun Chuop Sỡng Chít Cumo, cũai tễng rit sang cóq atỡng kia tam maléq sa‑ữi cumo ca noâng, toau toâq Chuop Sỡng Chít Cumo chumát ễn, cớp alíh kia ariang khoiq anoat dŏq chơ. ");
INSERT INTO bru_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Khân cũai ca khoiq chiau sang tâm cutễq sarái, ma án ễ chỡng loah, án cóq yỗn kia li cớp kia cutễq ki, cớp tữm ễn muoi pún tễ sỡng pún. ");
INSERT INTO bru_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Khân án chếq loâng tâm cutễq ki yỗn cũai canŏ́h, ma án tỡ bữn chỡng loah tễ Yiang Sursĩ nhũang, án tỡ têq chỡng noâng tâm cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Toâq Chuop Sỡng Chít Cumo chumát, sarái ki cỡt mun Yiang Sursĩ loâng, cớp cũai tễng rit sang ễn ndỡm tâm cutễq ki. ");
INSERT INTO bru_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Khân cũai aléq ma ễ chiau sang yỗn Yiang Sursĩ muoi tâm cutễq án khoiq chỡng tễ cũai canŏ́h, ");
INSERT INTO bru_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","cóq cũai tễng rit sang Yiang Sursĩ atỡng kia tâm cutễq ki puai tâng cumo toau toâq Chuop Sỡng Chít Cumo ca ễ toâq, chơ cũai ki cóq yỗn kia tâm cutễq ki tâng tangái ki toâp. Práq ki cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ma toâq Chuop Sỡng Chít Cumo khoiq toâq chơ, tâm cutễq ki cóq culáh loah yỗn án ca ndỡm tễ dâu lứq, tỡ la con châu tễ tŏ́ng toiq án. ");
INSERT INTO bru_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Ranáq atỡng kia tễ máh crơng nâi, cóq anoat puai ariang khoiq anoat tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Dũ lám con charán roah pốh dâu cỡt miar khong Yiang Sursĩ. Yuaq ngkíq, tỡ têq cũai aléq chiau sang charán ki cỗ mứt pahỡm sâng yoc ễ sang. Yuaq con ntroŏq, con cữu, cớp con mbễq pốh dâu cỡt miar khong Yiang Sursĩ chơ. ");
INSERT INTO bru_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ma con charán pốh dâu ca tỡ bữn bráh puai rit, têq chỡng loah puai kia anoat dŏq tâng dống sang, cớp cóq án tữm ễn muoi pún tễ sỡng pún. Khân án tỡ ễq chỡng loah, cóq án chếq yỗn cũai canŏ́h machớng cớp kia khoiq anoat dŏq. ");
INSERT INTO bru_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Khân crơng ntrớu ma khoiq chiau sang loâng yỗn Yiang Sursĩ, cũai ki tỡ têq chỡng loah, lứq pai cũai, tỡ la charán, tỡ la cutễq, yuaq nheq crơng ki cỡt miar khong Yiang Sursĩ mantái níc. ");
INSERT INTO bru_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Cũai aléq ma khoiq chiau sang loâng yỗn Yiang Sursĩ, án tỡ têq chỡng loah. Cũai ki cóq roap tôt noau cachĩt án. ");
INSERT INTO bru_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Pún muoi chít tễ crơng sarnóh, dếh crơng cỡt ŏ́c, tỡ la cỡt palâi, la cỡt miar khong Yiang Sursĩ nheq. ");
INSERT INTO bru_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Khân cũai aléq ma yoc ễ chỡng loah crơng ki, cóq án yỗn kia ariang khoiq anoat dŏq tâng dống sang, cớp tữm ễn muoi pún tễ sỡng pún. ");
INSERT INTO bru_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Máh charán dống, muoi lám tễ muoi chít lám cỡt miar khong Yiang Sursĩ. Toâq anhia noap máh charán ki, muoi lám tễ muoi chít lám cỡt miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Chỗi yỗn cũai ca ndỡm charán rưoh ĩt charán tỡ bữn o, chơ ralêq cớp charán o. Khân án ralêq muoi lám rato muoi lám, bo ki toâp bar lám charán ki cỡt miar khong Yiang Sursĩ, cớp tỡ têq chỡng loah.” ");
INSERT INTO bru_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Nâi la máh ŏ́c Yiang Sursĩ patâp cớp khoiq chiau yỗn Môi-se pỡ cóh Si-nai yỗn án atỡng loah máh cũai proai I-sarel.");
INSERT INTO bru_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Tangái muoi, casâi bar, cumo bar vớt cũai proai I-sarel loŏh tễ cruang Ê-yip-tô, Yiang Sursĩ atỡng Môi-se tâng Dống Sang Aroâiq, pỡ ntốq aiq cheq cóh Si-nai neq: ");
INSERT INTO bru_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","“Cóq mới cớp Arôn chĩc parỗm máh thrỗq cũai I-sarel dũ tỗp, dũ dống sũ. Cóq anhia chĩc nheq máh ramứh cũai samiang têq táq tahan, noap tễ bar chít cumo achỗn. ");
INSERT INTO bru_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Cóq mới parỗm máh cũai sốt dũ tỗp dũ sâu yỗn alới rachuai ranáq anhia.” ");
INSERT INTO bru_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Nâi la máh ramứh cũai chuai ranáq chĩc thrỗq cũai: Tễ tỗp Ruben bữn E-li-sur con samiang Sê-dưr; ");
INSERT INTO bru_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","tễ tỗp Si-mê-ôn bữn Sê-lumiel con samiang Suri-sadai; ");
INSERT INTO bru_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","tễ tỗp Yuda bữn Nasôn con samiang Ami-nadap; ");
INSERT INTO bru_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","tễ tỗp I-sacar bữn Nê-thanel con samiang Suar; ");
INSERT INTO bru_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","tễ tỗp Sa-bulôn bữn E-liap con samiang Hê-lôn; ");
INSERT INTO bru_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","tễ tỗp Ep-ra-im bữn E-li-sama con samiang Ami-hut; tễ tỗp Ma-nasê bữn Ca-maliel con samiang Phê-dasur; ");
INSERT INTO bru_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","tễ tỗp Ben-yamin bữn Abi-dan con samiang Kê-dien-i; ");
INSERT INTO bru_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","tễ tỗp Dan bữn Ahi-sơ con samiang Ami-sadai; ");
INSERT INTO bru_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","tễ tỗp Asêr bữn Pakiel con samiang Oc-ran; ");
INSERT INTO bru_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","tễ tỗp Cát bữn E-lia-sap con samiang Dưol; ");
INSERT INTO bru_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","cớp tễ tỗp Nep-tali bữn Ahi-ra con samiang E-nan. ");
INSERT INTO bru_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Nâi la máh ramứh cũai sốt tâng dũ tỗp dũ sâu, noau rưoh dŏq chuai ranáq chĩc thrỗq cũai. ");
INSERT INTO bru_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Cỗ nhơ ŏ́c rachuai tễ muoi chít la bar náq cũai nâi, tâng tangái muoi, casâi bar, Môi-se cớp Arôn arô nheq tữh tỗp I-sarel toâq rôm, chơ chĩc ramứh dũ náq puai tâng tỗp alới, cớp puai dũ dống sũ. Cũai samiang I-sarel dũ náq ca bữn bar chít cumo achỗn cóq chĩc ramứh. Moâm ki, nŏ́q ngih máh léq sa‑ữi thrỗq cũai, ");
INSERT INTO bru_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","alới táq puai riang Yiang Sursĩ atỡng. Ngkíq, Môi-se chĩc ramứh cũai proai nâi ỡt tâng ntốq aiq cheq cóh Si-nai. ");
INSERT INTO bru_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Máh samiang ca bữn bar chít cumo achỗn têq pỡq tahan cóq chĩc dŏq máh ramứh alới puai tŏ́ng toiq cớp dống sũ; noap tễ tỗp Ruben con clúng Yacốp, nheq tữh thrỗq cũai ki bữn neq: tỗp Ruben bữn 46,500 náq; tỗp Si-mê-ôn bữn 59,300 náq; tỗp Cát bữn 45,650 náq; tỗp Yuda bữn 74,600 náq; tỗp I-sacar bữn 54,400 náq; tỗp Sa-bulôn bữn 57,400 náq; tỗp Ep-ra-im bữn 40,500 náq; tỗp Ma-nasê bữn 32,200 náq; tỗp Ben-yamin bữn 35,400 náq; tỗp Dan bữn 62,700 náq; tỗp Asêr bữn 41,500 náq; tỗp Nep-tali bữn 53,400 náq. Parỗm nheq tữh thrỗq cũai ki la 603,550 náq. ");
INSERT INTO bru_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ma tỗp Lê-vi noau tỡ bữn chĩc amut tâng thrỗq tỗp cũai canŏ́h, ");
INSERT INTO bru_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","yuaq Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Toâq mới chĩc nheq tữh thrỗq cũai têq pỡq tahan, mới chỗi chĩc thrỗq cũai tỗp Lê-vi. ");
INSERT INTO bru_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ma cóq mới chóh alới dŏq nhêng salĩq Dống Sang Aroâiq cớp máh crơng radỡng tâng dống sang ki. Tỗp alới cóq crang Dống Sang Aroâiq cớp máh crơng radỡng. Cớp cóq alới táq dống alới bữm lavíng mpễr dống sang. ");
INSERT INTO bru_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Toâq anhia atỡi ntốq ỡt chu ntốq canŏ́h, cóq tỗp Lê-vi alíh cớp paliang, chơ ayứng loah Dống Sang Aroâiq ntốq tamái ễn. Ma cũai aléq tarôq cheq bân ntốq ki, cũai ki cóq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Máh cũai proai I-sarel tỗp canŏ́h, cóq alới chóh bữm dống alới ỡt mpễr ki, puai tỗp cớp sâu alới. ");
INSERT INTO bru_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ma cũai Lê-vi cóq chóh máh dống alới ỡt lavíng Dống Sang Aroâiq dŏq curiaq, tỡ yỗn noau mut cheq táq yỗn cứq sâng cutâu chóq máh cũai proai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Yuaq ngkíq, cũai proai I-sarel ma táq puai dũ ramứh machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yiang Sursĩ atỡng Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Yỗn cũai proai I-sarel táq ntốq ỡt; dũ náq cóq ỡt puai tỗp alới bữm, cớp yống aroâiq táq tếc puai sâu alới. Cóq alới chóh máh dống aroâiq ỡt lavíng chũop Dống Sang Aroâiq, ma cóq alới ỡt yơng bĩq.” ");
INSERT INTO bru_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","Coah angia mandang loŏh, máh tỗp ca puai aroâiq táq tếc Yuda cóq chóh máh dống aroâiq alới. Cũai ayông máh tỗp ki la neq: Tỗp Yuda: Cũai sốt alới la Nasôn con samiang Ami-nadap. Tỗp alới bữn nheq tữh la 74,600 náq. Tỗp I-sacar: Cũai sốt alới la Nê-thanel con samiang Suar. Tỗp alới bữn nheq tữh la 54,400 náq. Tỗp Sa-bulôn: Cũai sốt alới la E-liap con samiang Hê-lôn. Tỗp alới nheq tữh la 57,400 náq. Parỗm nheq tữh alới la 186,400 náq. Tỗp Yuda nâi cỡt tỗp pỡq nhũang. ");
INSERT INTO bru_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Coah angia pưn, máh tỗp ca puai aroâiq táq tếc Ruben cóq chóh máh dống aroâiq alới puai máh cũai ayông tỗp alới ớn. Cũai ayông ki la neq: Tỗp Ruben: Cũai sốt alới la E-li-sur con samiang Sê-dưr. Tỗp alới bữn nheq tữh la 46,500 náq. Tỗp Si-mê-ôn: Cũai sốt alới la Sê-lumiel con samiang Suri-sadai. Tỗp alới bữn nheq tữh la 59,300 náq. Tỗp Cát: Cũai sốt alới la E-lia-sap con samiang Dũal. Tỗp alới bữn nheq tữh la 45,650 náq. Parỗm nheq tữh tỗp alới ki la 151,450 náq. Tỗp Ruben nâi cỡt tỗp bar pỡq tapun. ");
INSERT INTO bru_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ỡt mpứng dĩ bar tỗp ca pỡq nhũang cớp bar tỗp ca pỡq ntun cóq tỗp Lê-vi crang Dống Sang Aroâiq. Ma dũ tỗp cóq pỡq pĩeiq puai ntốq alới ỡt, cớp yống aroâiq táq tếc sâu alới bữm, machớng cũai sốt ớn alới. ");
INSERT INTO bru_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Coah angia mandang pât máh tỗp ca puai aroâiq táq tếc Ep-ra-im chóh máh dống aroâiq alới puai máh cũai ayông tỗp alới ớn. Máh cũai ayông ki la neq: Tỗp Ep-ra-im: Cũai sốt alới la E-li-sama con samiang Ami-hut. Tỗp alới bữn thrỗq cũai 40,500 náq. Tỗp Ma-nasê: Cũai sốt alới la Ca-maliel con samiang Phê-dasur. Tỗp alới bữn thrỗq cũai 32,200 náq. Tỗp Ben-yamin: Cũai sốt alới la Abi-dan con samiang Kê-dien-i. Tỗp alới bữn thrỗq cũai 35,400 náq. Parỗm nheq tữh tỗp alới la 108,100 náq. Nheq tữh tỗp Ep-ra-im nâi cóq pỡq tapun, cỡt tỗp pái. ");
INSERT INTO bru_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Coah angia pỡng máh tỗp ca puai aroâiq táq tếc Dan cóq chóh máh dống aroâiq puai máh cũai ayông tỗp alới ớn. Máh cũai ayông ki la neq: Tỗp Dan: Cũai sốt alới la Ahi-sơ con samiang Ami-sadai. Tỗp alới bữn nheq tữh la 62,700 náq. Tỗp Asêr: Cũai sốt alới la Pakiel con samiang Oc-ran. Tỗp alới bữn nheq tữh la 41,500 náq. Tỗp Nep-tali: Cũai sốt alới la Ahi-ra con samiang E-nan. Tỗp alới bữn nheq tữh la 53,400 náq. Parỗm nheq tữh tỗp alới la 157,600 náq. Nheq tữh tỗp Dan nâi cóq pỡq tapun, cỡt tỗp parsốt tháng. ");
INSERT INTO bru_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Parỗm nheq tữh cũai proai I-sarel têq cỡt tahan la 603,550 náq. ");
INSERT INTO bru_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ma tỡ bữn noap tỗp Lê-vi amut tâng cũai I-sarel nâi, táq machớng Yiang Sursĩ khoiq patâp Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Yuaq ngkíq, cũai proai I-sarel trĩh santoiq Yiang Sursĩ khoiq atỡng na Môi-se. Dũ náq tâng tỗp alới cóq chóh dống ỡt puai máh cũai ayông tỗp alới ớn. Cớp cóq alới pỡq parnơi cớp sâu, cớp dống sũ alới. ");
INSERT INTO bru_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Nâi la cũai tâng dống sũ Arôn cớp Môi-se bo Yiang Sursĩ táq ntỡng cớp Môi-se pỡ cóh Si-nai. ");
INSERT INTO bru_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arôn bữn con samiang pỗn náq neq: Nadap, ai clúng, Abi-hu, E-lia-sơ, cớp I-thamar. ");
INSERT INTO bru_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Nheq náq alới noau chóh yỗn cỡt cũai tễng rit sang Yiang Sursĩ na hĩng dỡq nsễng o‑li‑vê tâng plỡ. ");
INSERT INTO bru_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ma Nadap cớp Abi-hu pĩeiq cuchĩt na ũih bo alới táq clốq bốh crơng sang yỗn Yiang Sursĩ pỡ ntốq aiq cheq cóh Si-nai. Alới bar náq nâi ŏ́q con. Yuaq ngkíq, bữn ống E-lia-sơ cớp I-thamar sâng cỡt cũai tễng rit sang bo Arôn noâng tamoong. ");
INSERT INTO bru_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Cóq mới dững aloŏh tỗp Lê-vi yỗn tayứng yáng moat; chơ chóh alới yỗn cỡt cũai chuai ranáq Arôn, la cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Alới cóq táq máh ranáq noau khoiq chiau yỗn alới táq pỡ Dống Sang Aroâiq. Cớp cóq alới táq ranáq chuai cũai tễng rit sang, dếh táq chuai nheq tữh cũai. ");
INSERT INTO bru_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Cóq alới nhêng salĩq nheq máh crơng crớu tâng Dống Sang Aroâiq, cớp táq ranáq pláih máh cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Alới cóq táq ranáq chuai Arôn cớp máh con samiang án. ");
INSERT INTO bru_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Cóq mới chóh Arôn cớp tỗp con samiang án yỗn cỡt cũai tễng rit sang cứq. Ma khân cũai canŏ́h chống ễ táq ranáq tâng Ntốq Tễng Rit, án cóq roap tôt cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yiang Sursĩ atỡng Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Lứq cứq toâp rưoh tỗp Lê-vi tễ máh cũai proai I-sarel dŏq cỡt khong cứq. Alới pláih loah máh con clúng cũai proai I-sarel, ");
INSERT INTO bru_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","yuaq tangái cứq cachĩt máh con samiang clúng cũai Ê-yip-tô, cứq dŏq tamoong máh con samiang clúng cũai proai I-sarel, cớp máh con charán pốh dâu dũ lám. Chơ cứq yỗn nheq con dâu cỡt khong cứq. Cứq toâp la Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ỡt tâng ntốq aiq cheq cóh Si-nai, Yiang Sursĩ ớn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Cóq mới ngih máh thrỗq cũai tâng tỗp Lê-vi, puai dống sũ cớp sâu alới. Cóq mới ngih máh samiang muoi casâi achỗn.” ");
INSERT INTO bru_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ngkíq Môi-se táq ranáq ki. ");
INSERT INTO bru_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lê-vi bữn con samiang pái náq, ramứh Kêr-sôn, Cô-hat, cớp Mê-rari. ");
INSERT INTO bru_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Kêr-sôn bữn con samiang bar náq, ramứh Lip-ni cớp Si-mê. ");
INSERT INTO bru_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Cô-hat bữn con samiang pỗn náq, ramứh Am-ram, I-sar, Hep-rôn, cớp Usiel. ");
INSERT INTO bru_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Cớp Mê-rari bữn con samiang bar náq, ramứh Mali cớp Muchi. Tỗp alới cỡt achúc achiac máh cũai ca clễu ramứh alới. ");
INSERT INTO bru_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Tŏ́ng toiq Kêr-sôn bữn sâu Lip-ni cớp sâu Si-mê. ");
INSERT INTO bru_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Máh thrỗq cũai samiang, noap tễ muoi casâi achỗn bữn tapul ngin sỡng culám náq. ");
INSERT INTO bru_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Tŏ́ng toiq nâi cóq ỡt coah clĩ Dống Sang Aroâiq, yáng angia mandang pât. ");
INSERT INTO bru_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Cũai ayông tŏ́ng toiq nâi la E-lia-sap con samiang Lêl. ");
INSERT INTO bru_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Tỗp Kêr-sôn cỡt cũai nhêng salĩq Dống Sang Aroâiq, dếh aroâiq ca pul Dống Sang Aroâiq, cớp aroâiq yoang catáng ngoah toong mut ntốq ki, ");
INSERT INTO bru_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","aroâiq yoang lavíng chũop nheq nchŏh Dống Sang Aroâiq cớp prông, dếh aroâiq catáng ngoah mut nchŏh Dống Sang Aroâiq hỡ. Tỗp alới bữn mpỗl nhêng salĩq nheq máh ramứh nâi. ");
INSERT INTO bru_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Tŏ́ng toiq Cô-hat bữn pỗn sâu ramứh neq: Am-ram, I-sar, Hep-rôn, cớp Usiel. ");
INSERT INTO bru_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Thrỗq cũai samiang tễ muoi casâi achỗn la 8,600 náq. Tỗp alới cóq nhêng salĩq Ntốq Tễng Rit. ");
INSERT INTO bru_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Tŏ́ng toiq Cô-hat nâi cóq ỡt coah angia pưn Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","cớp cũai sốt alới la E-li-saphan con samiang Usiel. ");
INSERT INTO bru_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Tỗp Cô-hat bữn mpỗl nhêng salĩq Hĩp Parnai Parkhán, máh cachơng, rông tớu, prông sang, máh crơng radỡng ca cũai tễng rit dốq tâc tâng Ntốq Tễng Rit, cớp aroâiq catáng toong mut tâng Ntốq Yiang Sursĩ Ỡt. Alới bữn mpỗl nhêng salĩq máh ramứh ki. ");
INSERT INTO bru_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Cũai sốt tâng cũai tễng rit sang Yiang Sursĩ tễ tỗp Lê-vi la E-lia-sơ con samiang Arôn. E-lia-sơ nhêng salĩq máh cũai táq ranáq tâng Ntốq Tễng Rit. ");
INSERT INTO bru_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Tŏ́ng toiq Mê-rari bữn sâu ramứh neq: Mali cớp Muchi. ");
INSERT INTO bru_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Nheq tữh thrỗq cũai samiang tễ muoi casâi achỗn la 6,200 náq. ");
INSERT INTO bru_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Suriel con samiang Abi-hêl sốt tŏ́ng toiq nâi. Alới ỡt yáng angia pỡng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Tỗp Mê-rari bữn mpỗl nhêng salĩq máh ramứh neq: Máh khuon Dống Sang Aroâiq, prang yuang, tanũl, crơng rayống ayững tanũl, cớp dũ ramứh crơng noau tâc tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Cớp alới cóq nhêng salĩq máh crơng neq hỡ: Tanũl, crơng rayống ayững tanũl, lác téh, cớp máh panũar yoang yáng tiah nchŏh Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Môi-se, Arôn, cớp máh con samiang Arôn cóq chóh dống alới choâng moat ngoah toong mut Dống Sang Aroâiq, coah angia mandang loŏh cớp coah moat Dống Sang Aroâiq. Alới bữn mpỗl nhêng salĩq crơng sang tâng Ntốq Tễng Rit tang máh cũai proai I-sarel. Khân cũai canŏ́h chống ễ táq rit nâi, án cóq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Môi-se ngih puai machớng Yiang Sursĩ khoiq ớn, chơ parỗm nheq tữh cũai samiang tâng tỗp Lê-vi tễ muoi casâi achỗn tâng dũ sâu la 22,000 náq. ");
INSERT INTO bru_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yiang Sursĩ pai chóq Môi-se neq: “Cóq mới chĩc nheq máh ramứh con samiang clúng cũai I-sarel, ngih tễ muoi casâi achỗn. ");
INSERT INTO bru_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Cóq anhia dững tỗp Lê-vi yỗn cứq, dŏq pláih loah máh con samiang clúng cũai I-sarel. Cớp yỗn nheq tữh charán cũai Lê-vi pláih loah nheq tữh charán pốh dâu lứq khong cũai I-sarel. Cứq toâp la Yiang Sursĩ!” ");
INSERT INTO bru_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ngkíq Môi-se ngih máh thrỗq con samiang clúng cũai proai I-sarel, machớng Yiang Sursĩ khoiq ớn án. ");
INSERT INTO bru_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Án ngih cũai samiang tễ muoi casâi achỗn, cớp parỗm nheq tữh con samiang clúng ki la 22,273 náq. ");
INSERT INTO bru_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Cớp Yiang Sursĩ atỡng Môi-se neq hỡ: ");
INSERT INTO bru_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Cóq mới dững chiau sang tỗp cũai Lê-vi yỗn cứq dŏq pláih máh con samiang clúng cũai I-sarel. Cớp chiau sang máh charán tỗp Lê-vi pláih máh charán pốh dâu khong máh cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ma cỗ con samiang clúng cũai I-sarel sa‑ữi hỡn tễ con samiang cũai Lê-vi, la bar culám tapul chít la pái náq, ngkíq cóq mới thái loah máh thrỗq cũai noâng clữi. ");
INSERT INTO bru_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Yỗn dũ náq ki cóq mới chiau sỡng ŏ́c práq, puai loah kia noau khoiq anoat tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Chơ cóq mới chiau máh práq ki yỗn Arôn cớp máh con samiang án.” ");
INSERT INTO bru_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ngkíq, Môi-se parỗm dŏq nheq máh práq dŏq thái loah thrỗq cũai hỡn tễ thrỗq cũai Lê-vi. ");
INSERT INTO bru_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Án ĩt práq 1,365 ŏ́c práq, ");
INSERT INTO bru_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","cớp án chiau práq ki yỗn Arôn cớp máh con samiang Arôn. ");
INSERT INTO bru_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yiang Sursĩ atỡng Môi-se cớp Arôn ");
INSERT INTO bru_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","yỗn alới ngih máh thrỗq cũai samiang tâng tỗp Lê-vi tâng sâu Cô-hat, dếh dũ sâu cớt cớp dũ dống sũ. ");
INSERT INTO bru_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Alới cóq ngih nheq tữh máh cũai samiang tễ pái chít cumo toau toâq sỡng chít cumo, la tỗp têq táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ranáq alới táq tâng Dống Sang Aroâiq la nhêng salĩq máh crơng miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Yiang Sursĩ atỡng Môi-se tễ ranáq cũai I-sarel atỡi dống alới; cóq Arôn cớp máh con samiang án mut tâng Dống Sang Aroâiq, chơ alíh asễng nheq aroâiq catáng Hĩp Parnai Parkhán cớp pul hĩp ki. ");
INSERT INTO bru_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Moâm ki, cóq alới ĩt ngcâr languat o ễn pul hĩp ki; chơ ĩt muoi ploah aroâiq santứm satong ễn pul tâng pỡng. Moâm ki alới têq taróc aluang dŏq crang. ");
INSERT INTO bru_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Cóq alới ĩt aroâiq santứm satong sữn tâng cachơng noau achúh bễng mi dŏq chiau sang yỗn Yiang Sursĩ. Moâm ki cóq alới ĩt máh tangan savan, tangan chễn dŏq chóq crơng phuom, tangan chễ dŏq chóq crơng chiau sang, cớp aluoi cutễq dŏq chóq blŏ́ng nho. Ma bễng mi, ki cóq bữn níc tâng cachơng. ");
INSERT INTO bru_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Alới cóq ĩt aroâiq santứm cusâu pul nheq máh crơng ki; chơ ĩt ngcâr o lứq pul loah muoi lưp ễn. Moâm ki, nŏ́q têq taróc aluang crang. ");
INSERT INTO bru_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Cóq alới ĩt aroâiq santứm satong pul tâng lác rông tớu, chớp tớu, caniap takĩap, máh padien sapoan, cớp aluoi chóq tớu tacât. ");
INSERT INTO bru_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Cóq alới ĩt ngcâr languat o dŏq cutúng rông tớu, dếh máh crơng canŏ́h parnơi cớp rông; chơ dững achúh dŏq tâng pỡng aluang cantrang. ");
INSERT INTO bru_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Moâm ki, cóq alới ĩt aroâiq santứm satong pul prông yễng, cớp ĩt ngcâr languat o pul tâng pỡng, chơ taróc aluang cantrang. ");
INSERT INTO bru_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Nheq tữh crơng tâng Ntốq Tễng Rit, cóq alới cutúng toâq aroâiq santứm satong; cớp ĩt ngcâr languat o catúng loah muoi lưp ễn. Moâm ki dững achúh nheq crơng ki dŏq tâng pỡng aluang cantrang. ");
INSERT INTO bru_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Cóq alới ĩt aloŏh chíq bŏ́h tễ prông, chơ ĩt aroâiq santứm ễng pul prông. ");
INSERT INTO bru_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Cóq alới chóq nheq máh crơng radỡng dốq tâc tâng prông sang, bữn neq: Máh radỡng dŏq rahững ũih, máh canŏ́q, máh sán, cớp máh tapuang achúh dŏq tâng pỡng cachơng ki. Moâm ki, ĩt ngcâr languat o lứq pul muoi lưp ễn; chơ taróc aluang crang. ");
INSERT INTO bru_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Toâq ngư atỡi, cóq cũai tễ sâu Cô-hat crang máh crơng tâng Dống Sang Aroâiq. Toâq Arôn cớp máh con samiang án cutúng moâm chơ, cũai tễ sâu Cô-hat tỡ têq satoaq máh crơng nâi. Khân alới satoaq, ki alới cuchĩt. Trỗ léq ma atỡi Dống Sang Aroâiq, cũai tễ sâu Cô-hat bữn mpỗl dững máh crơng nâi. ");
INSERT INTO bru_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","E-lia-sơ con samiang Arôn la cũai tễng rit sang, án cóq nhêng salĩq nheq máh crơng crớu tâng Dống Sang Aroâiq, dếh tớu ien tacât, crơng phuom, máh thữ racáu noau dững chiau sang, dỡq nsễng dŏq táq rit, cớp dũ ramứh crơng khoiq chiau tâng Dống Sang Aroâiq yỗn Yiang Sursĩ hỡ. ");
INSERT INTO bru_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yiang Sursĩ atỡng Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Chỗi yỗn cũai tễ sâu Cô-hat roap tôt cuchĩt ");
INSERT INTO bru_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","cỗ alới ỡt cheq máh crơng miar khong Yiang Sursĩ. Dŏq curiaq tỡ yỗn ranáq nâi cỡt, Arôn cớp máh con samiang án, cóq alới mut Ntốq Tễng Rit, chơ anoat ranáq yỗn dũ náq têq táq, cớp crơng ntrớu alới têq dững. ");
INSERT INTO bru_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Khân cũai aléq tễ sâu Cô-hat ma mut tâng Dống Sang Aroâiq yoc ễ nhêng cũai tễng rit sang thrũan dŏq atỡi máh crơng miar khong Yiang Sursĩ, cũai ki cóq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yiang Sursĩ atỡng Môi-se ễn neq: ");
INSERT INTO bru_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Cóq mới ngih cũai tễ tỗp Lê-vi, sâu Kêr-sôn dũ tỗp cớp dũ dống sũ. ");
INSERT INTO bru_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Cóq mới chĩc nheq máh ramứh cũai samiang tễ pái chít cumo toau toâq sỡng chít cumo, cũai bữn mpỗl têq táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Máh cũai nâi cỡt cũai nhêng salĩq cớp crang dững máh crơng neq: ");
INSERT INTO bru_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Dống Sang Aroâiq, aroâiq pul Dống Sang Aroâiq yáng clống cớp yáng tiah, ngcâr languat o dŏq pul mpuol Dống Sang Aroâiq, aroâiq catáng ngoah toong Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","aroâiq cớp panũar dŏq tíng chũop nchŏh Dống Sang Aroâiq cớp prông sang, aroâiq catáng ngoah toong mut chu nchŏh Dống Sang Aroâiq, cớp máh crơng radỡng tâng ntốq ki. Alới cóq táq dũ ranáq riang khoiq patâp. ");
INSERT INTO bru_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Môi-se cớp Arôn cóq taniap tỗp Kêr-sôn táq máh ranáq nâi, cớp yỗn alới crang dũ ramứh Arôn cớp máh con samiang án chiau yỗn alới crang. ");
INSERT INTO bru_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Nâi la mpỗl cũai tâng sâu Kêr-sôn cóq táq tâng Dống Sang Aroâiq. Cóq alới táq ranáq nâi puai án ca ayông alới, la I-thamar con samiang Arôn, la cũai tễng rit sang Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Yiang Sursĩ atỡng yỗn Môi-se chĩc máh thrỗq cũai tâng sâu Mê-rari tễ dũ tỗp cớp dũ dống sũ. ");
INSERT INTO bru_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Án chĩc máh ramứh cũai samiang tễ pái chít cumo toau toâq sỡng chít cumo, la cũai bữn mpỗl táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Alới cóq crang máh khuon tâng Dống Sang Aroâiq, prang yuang, tanũl, crơng rayống ayững tanũl Dống Sang Aroâiq; ");
INSERT INTO bru_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","lác téh, crơng rayống ayững, cớp panũar yoang chũop nchŏh Dống Sang Aroâiq, dếh máh crơng tâng dống sang ki hỡ. Dũ náq cũai bữn miar ranáq táq. ");
INSERT INTO bru_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Máh cũai tâng sâu Mê-rari cóq nhêng salĩq máh ranáq táq tâng Dống Sang Aroâiq. Cũai ayông alới la I-thamar con samiang Arôn, la cũai tễng rit sang Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Môi-se táq puai ariang Yiang Sursĩ ớn án cớp Arôn, dếh máh cũai sốt cũai proai I-sarel hỡ. Alới chĩc thrỗq cũai Lê-vi tâng pái sâu neq: Cô-hat, Kêr-sôn, cớp Mê-rari. Alới chĩc ramứh cũai samiang tễ pái chít cumo toau toâq sỡng chít cumo, cũai bữn mpỗl têq táq ranáq tâng Dống Sang Aroâiq. Alới ngih dũ tỗp cớp dũ dống sũ, la neq: Sâu Cô-hat bữn 2,750 náq. Sâu Kêr-sôn bữn 2,630 náq. Sâu Mê-rari bữn 3,200 náq. Parỗm nheq tữh la 8,580 náq. ");
INSERT INTO bru_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Cũai Lê-vi dũ náq Yiang Sursĩ yỗn roap mpỗl machớng án khoiq patâp Môi-se, tễ ranáq alới cóq táq, cớp crơng crớu alới cóq crang. Ngkíq Môi-se bữn chĩc nheq máh ramứh cũai ki machớng Yiang Sursĩ khoiq ớn án chơ. ");
INSERT INTO bru_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Cóq mới ớn máh cũai I-sarel yỗn alới tuih aloŏh máh cũai tễ ntốq anhia ỡt la neq: Máh cũai a‑ĩ tâng ngcâr ca têq tớt cũai canŏ́h, tỡ la bữn dỡq hoi loŏh tễ tỗ, tỡ la tỡ bữn bráh puai rit cỗ alới satoaq sac cumuiq. ");
INSERT INTO bru_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Cóq anhia tuih aloŏh máh cũai nâi tễ ntốq anhia ỡt, tỡ bữn pai mansễm tỡ la samiang. Táq ngkíq, dŏq alới tỡ bữn dững atoâq ŏ́c tỡ bữn bráh puai rit toâq pỡ ntốq cứq ỡt tâng mpứng dĩ máh cũai proai cứq.” ");
INSERT INTO bru_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Cũai proai I-sarel trĩh máh parnai Yiang Sursĩ patâp alới; chơ alới tuih aloŏh nheq máh cũai bữn a‑ĩ ngkíq tễ ntốq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yiang Sursĩ atỡng Môi-se yỗn chiau ");
INSERT INTO bru_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","máh santoiq tĩeih atỡng pỡ cũai proai I-sarel. Toâq bữn cũai aléq ma tỡ bữn táq pĩeiq chóq Yiang Sursĩ, tỡ la táq sâuq chóq yớu, ");
INSERT INTO bru_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","án cóq ngin lôih, cớp culáh loah dũ kia pỡ cũai ca án khoiq táq lôih, cớp tữm ễn bar chít pún tễ muoi culám pún. ");
INSERT INTO bru_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Khân cũai án táq ma cuchĩt, cớp ŏ́q sễm ai roap máh kia tễ panôiq, ki cóq án chiau práq ki dŏq pỡ cũai tễng rit sang Yiang Sursĩ. Ma cũai ca táq lôih cóq chiau sang dếh muoi lám cữu tôl hỡ, dŏq táq rit pupứt lôih án. ");
INSERT INTO bru_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Dũ ramứh crơng cũai proai I-sarel dững chiau sang yỗn Yiang Sursĩ cỡt khong cũai tễng rit sang ca táq rit ki. Noâng ống charán bốh sang sâng tỡ bữn cỡt khong cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Cũai tễng rit sang dũ náq cóq roap ĩt crơng chiau sang ki cỡt khong án. ");
INSERT INTO bru_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yiang Sursĩ patâp Môi-se ");
INSERT INTO bru_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","13","yỗn án atỡng santoiq nâi yỗn cũai proai I-sarel. Cŏh lơ bữn samiang tũn lacuoi án tỡ bữn tanoang cớp cooc samiang canŏ́h; ma án tỡ bữn dáng raloaih, cỗ lacuoi án cutooq dŏq, la tỡ bữn noau hữm tếc, cớp tỡ bữn noau ramóh bo alới táq lôih. ");
INSERT INTO bru_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ma khân samiang ki chanchớm lacuoi án tỡ bữn tanoang, pĩeiq lacuoi án táq lôih ma tỡ bữn, ");
INSERT INTO bru_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","cóq cayac ki dững lacuoi án toâq pỡ cũai tễng rit sang. Cớp cóq án dững bỗt bali muoi ki-lô dŏq chiau sang; ma án tỡ têq hĩng dỡq nsễng o‑li‑vê chóq tâng bỗt ki, tỡ la aríh crơng phuom tâng pỡng bỗt ki, yuaq ranáq nâi la ranáq chiau sang máh thữ racáu tễ ŏ́c tỡ yũah dáng samoât dŏq yỗn manoaq dáng raloaih tễ manoaq. ");
INSERT INTO bru_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Cũai tễng rit sang cóq dững mansễm ki tayứng yáng moat prông sang. ");
INSERT INTO bru_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Chơ cóq án hĩng dỡq tễ prông sang tâng aluoi cutễq, cớp ĩt phốn cutễq tễ Dống Sang Aroâiq yữi chóq tâng dỡq. ");
INSERT INTO bru_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Moâm ki, cũai tễng rit sang leh sóc mansễm ki khoiq nhuom, cớp ĩt bỗt cayac án dững chiau sang, chơ chóq tâng rabỗc atĩ mansễm ki. Ma cũai tễng rit sang ki cóq yống tangan dỡq sarnéng ca bữn santoiq pupap. ");
INSERT INTO bru_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Chơ cũai tễng rit sang pai santoiq thễ dũan, cớp yỗn mansễm ki pruam neq: “Khân mới tỡ bữn cooc noau, ki mới lứq bữn vớt tễ dỡq ntáng nâi. ");
INSERT INTO bru_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ma khân mới khoiq cooc noau, ki sễq Yiang Sursĩ táq yỗn ramứh mới cỡt ŏ́c pupap tâng tỗp mới bữm. ");
INSERT INTO bru_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Cớp sễq yỗn án táq sarcar mới cỡt cadễng cớp púng mới cỡt áih. ");
INSERT INTO bru_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Sễq yỗn dỡq sarnéng mut tâng púng mới táq yỗn púng mới cỡt áih, dếh táq yỗn dống carnễn mới cỡt cadễng tê.” Chơ mansễm ki ta‑ỡi neq: “Pĩeiq! Sễq Yiang Sursĩ táq ngkíq ơiq!” ");
INSERT INTO bru_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Chơ cũai tễng rit sang cóq chĩc santoiq pupap; chơ alốq tâng dỡq sarnéng toau chữq ŏ́c pupap ki cỡt pứt nheq. ");
INSERT INTO bru_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Nhũang án ĩt dỡq sarnéng yỗn mansễm ki nguaiq, la dỡq têq táq yỗn mansễm cỡt a‑ĩ, ");
INSERT INTO bru_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","cũai tễng rit sang cóq ĩt tễ atĩ mansễm ki bỗt cayac án dững chiau sang yỗn Yiang Sursĩ pỡ prông sang. ");
INSERT INTO bru_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Chơ cóq án cupoau bỗt ki muoi carpỗt dững bốh tâng prông sang, táq tếc chiau sang bỗt ki yỗn Yiang Sursĩ. Moâm ki, cóq án ĩt dỡq sarnéng yỗn mansễm ki nguaiq. ");
INSERT INTO bru_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Khân mansễm ki khoiq cooc noau, dỡq ki táq yỗn án cỡt a‑ĩ ntâng, púng áih, cớp sarcar cỡt sangot khỗ nheq. Cớp ramứh án lứq cỡt ŏ́c pupap tâng tỗp án bữm. ");
INSERT INTO bru_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ma khân mansễm ki tỡ bữn cooc noau, án têq vớt tễ ŏ́c túh coat nâi; chơ án têq bữn con. ");
INSERT INTO bru_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Nâi la phễp rit tễ manoaq samiang mumu lacuoi án cooc noau. ");
INSERT INTO bru_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Mansễm ki cóq tayứng choâng moat prông sang yáng moat Yiang Sursĩ dŏq cũai tễng rit sang táq rit nâi. ");
INSERT INTO bru_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ma khân pĩeiq án táq lôih, cayac án vớt tễ ŏ́c lôih, ma lacuoi ki cóq roap tôt tễ Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","atỡng máh santoiq nâi yỗn cũai proai I-sarel. Samiang tỡ la mansễm ma parkhán yoc ễ cỡt tỗp Nasa-rit, la cũai chiau sang tỗ yỗn Yiang Sursĩ, ");
INSERT INTO bru_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","cóq án tỡ bữn nguaiq blŏ́ng nho tỡ la crơng canŏ́h ca khoiq lieiq. Cóq án tỡ bữn nguaiq crơng ntrớu noau táq toâq palâi nho, tỡ la cha ống palâi nho chĩn tỡ la khỗ. ");
INSERT INTO bru_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Bo án noâng cỡt tỗp Nasa-rit, án cóq tỡ bữn nguaiq cha máh crơng sana noau táq tễ palâi nho, dếh ŏ́c tỡ la ndŏh hỡ. ");
INSERT INTO bru_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Bo án chiau sang tỗ cỡt tỗp Nasa-rit, án tỡ têq cứt sóc tỡ la cũah sóc bễc. Cóq án táq puai máh ŏ́c án khoiq thễ dũan pai ễ chiau sang tỗ yỗn Yiang Sursĩ, cớp án cóq dŏq yỗn sóc án cỡt cuti. ");
INSERT INTO bru_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Sóc án táq tếc apáh án chiau sang tỗ yỗn Yiang Sursĩ. Ngkíq án tỡ têq mut cheq cumuiq, táq yỗn tỗ án cỡt tỡ bữn bráh puai rit, lứq pai cumuiq ki la mpoaq, mpiq, tỡ la sễm ai sễm ỡi án bữm. ");
INSERT INTO bru_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Bo án noâng cỡt tỗp Nasa-rit, cóq án chiau sang tỗ án loâng yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Khân bữn cũai rangoân cuchĩt toâp cheq cũai Nasa-rit, sóc cũai Nasa-rit ki cỡt tỡ bữn bráh puai rit; án cóq acoan tapul tangái ễn, chơ cũah sóc plỡ. Ki nŏ́q án têq cỡt bráh loah puai rit. ");
INSERT INTO bru_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Tâng tangái tacual cóq án dững chớm tariap tỡ la chớm tapâr, muoi ramứh bar lám, yỗn pỡ cũai tễng rit sang bân ngoah toong mut tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Cũai tễng rit sang ki cóq ĩt muoi lám chớm dŏq táq rit pupứt lôih, ma muoi lám ễn cóq bốh dŏq cỡt crơng chiau sang puai tâng rit sambráh, cỗ tian samiang ki cỡt tỡ bữn bráh noâng yuaq án mut cheq sac cumuiq. Ngkíq án cóq chiau sang sóc án tâng tangái ki toâp. ");
INSERT INTO bru_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Cớp cóq án chiau sang tỗ yỗn Yiang Sursĩ na cỡt cũai Nasa-rit muoi trỗ ễn. Ranáq chiau sang tỗ trỗ nhũang tỡ bữn cỡt kia ntrớu, yuaq sóc bráh ki khoiq cỡt tỡ bữn bráh noâng puai rit. Án cóq dững muoi lám cữu tôl mbỡiq muoi cumo dŏq táq crơng chiau sang pláih loah lôih án. ");
INSERT INTO bru_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Toâq dũ chơ tangái thễ dũan ễ cỡt cũai Nasa-rit, án cóq táq puai phễp rit, la pỡq chu ngoah toong mut Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","cớp chiau sang yỗn Yiang Sursĩ pái lám charán ŏ́q bân tĩq la neq: Muoi lám cữu tôl mbỡiq muoi cumo dŏq bốh chiau sang, muoi lám cữu tôl mbỡiq muoi cumo dŏq táq rit pupứt lôih, cớp muoi lám cữu tôl ễn dŏq táq rit yỗn cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Cóq án dững bễng mi ŏ́q crơng pluoih muoi crưo dŏq cỡt crơng chiau sang neq: Khlễc bễng cubân talốc cớp dỡq nsễng o‑li‑vê, bễng cada talốc cớp dỡq nsễng o‑li‑vê, cớp máh thữ racáu, dếh blŏ́ng nho hỡ dŏq cỡt crơng chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Cũai tễng rit sang cóq chiau sang nheq máh crơng ki yỗn Yiang Sursĩ, dếh crơng dŏq pupứt lôih cớp crơng bốh chiau sang hỡ. ");
INSERT INTO bru_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Án cóq dững cữu tôl dŏq sang yỗn Yiang Sursĩ yỗn cỡt ratoi, dếh muoi crưo bễng mi. Cớp cóq án chiau sang máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Cũai Nasa-rit cóq cũah sóc plỡ bân ngoah toong mut Dống Sang Aroâiq, cớp dững bốh sóc ki parnơi cớp crơng chiau sang yỗn cỡt ratoi. ");
INSERT INTO bru_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Chơ, cũai tễng rit sang cóq ĩt sâiq savac cữu tôl khoiq ớp, dếh muoi mễng bễng mi cubân, cớp bễng mi cada tễ crưo pỡq chóq tâng atĩ cũai Nasa-rit. ");
INSERT INTO bru_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Moâm ki, cũai tễng rit sang cóq apỗng máh crơng nâi chiau sang yỗn Yiang Sursĩ. Máh crơng nâi cỡt miar khong Yiang Sursĩ yỗn cũai tễng rit sang. Cớp án cóq yỗn sâiq apơm cớp nlu charán tôl. Vớt ki, cũai Nasa-rit têq nguaiq blŏ́ng nho. ");
INSERT INTO bru_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Nâi la phễp rit yỗn cũai Nasa-rit. Ma khân bữn muoi noaq cũai Nasa-rit ma par‑ữq ễ chiau sang clữi tễ ki, cóq án táq puai riang án khoiq par‑ữq chơ. ");
INSERT INTO bru_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","atỡng Arôn cớp máh con samiang Arôn, cóq alới pai ŏ́c bốn yỗn cũai proai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Sễq Yiang Sursĩ satốh ŏ́c bốn puan cớp bán curiaq nheq tữh tỗp anhia. ");
INSERT INTO bru_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Sễq Yiang Sursĩ sâng sarũiq táq cớp rachuai níc anhia. ");
INSERT INTO bru_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Sễq Yiang Sursĩ nhêng salĩq anhia cỗ sâng sarũiq táq, cớp yỗn anhia bữn ŏ́c ien khễ.” ");
INSERT INTO bru_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Yiang Sursĩ pai ễn neq: “Khân tỗp alới pai ŏ́c bốn nhơ ramứh cứq, cứq ễ satốh ŏ́c bốn yỗn tỗp alới.” ");
INSERT INTO bru_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Toâq tangái Môi-se táq Dống Sang Aroâiq moâm chơ, án ĩt dỡq nsễng o‑li‑vê hĩng táq tếc chiau sang Dống Sang Aroâiq, dếh máh crơng radỡng hỡ yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Chơ máh cũai sốt tỗp I-sarel, la cũai khoiq chĩc thrỗq nheq tữh cũai, ");
INSERT INTO bru_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","alới dững máh crơng alới bữm toâq chiau sang yỗn Yiang Sursĩ, bữn neq: Sễ kĩen tapoât lám cớp ntroŏq tangcáh tapoât cáp, muoi lám sễ kĩen dŏq yỗn bar náq cũai sốt, ma dũ náq cũai sốt bữn muoi lám ntroŏq tangcáh. Toâq alới dững máh crơng nâi pỡ Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","chơ Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Cóq mới roap ĩt máh crơng sang nâi dŏq tâc tâng Dống Sang Aroâiq; chơ muap yỗn tỗp Lê-vi puai mpỗl alới.” ");
INSERT INTO bru_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Yuaq ngkíq, Môi-se chiau máh sễ kĩen cớp máh ntroŏq ki yỗn tỗp Lê-vi. ");
INSERT INTO bru_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Án chiau kĩen bar lám cớp ntroŏq tangcáh bar cáp pỡ tỗp Kêr-sôn, ");
INSERT INTO bru_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ma kĩen pỗn lám cớp ntroŏq tangcáh pỗn cáp ki án chiau yỗn tỗp Mê-rari. Máh ranáq alới táq la I-thamar con samiang Arôn cỡt sốt. ");
INSERT INTO bru_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ma Môi-se tỡ bữn chiau kĩen cớp ntroŏq yỗn tỗp Cô-hat, yuaq alới cóq kĩaq rabán cớp dỗl crơng pún miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ma máh cũai ayông tỗp I-sarel, alới dững crơng ễ chiau prông sang yỗn Yiang Sursĩ. Toâq alới thrũan ễ chiau sang crơng ki, ");
INSERT INTO bru_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yiang Sursĩ atỡng Môi-se neq: “Cu rangái tâng muoi chít la bar tangái noau ễ chiau sang prông ki, muoi tangái manoaq tễ cũai sốt tâng tỗp cóq án dững bữm máh crơng án ễ chiau sang.” ");
INSERT INTO bru_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Nasôn con samiang Ami-nadap tễ tỗp Yuda dững crơng chiau sang tâng tangái muoi. ");
INSERT INTO bru_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Nasôn con samiang Ami-nadap dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Nê-thanel con samiang Suar tễ tỗp I-sacar dững crơng chiau sang tâng tangái bar. ");
INSERT INTO bru_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân moang crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la crơng Nê-thanel con samiang Suar chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","E-liap con samiang Hê-lôn tễ tỗp Sa-bulôn dững crơng chiau sang tâng tangái pái. ");
INSERT INTO bru_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Crơng án chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng E-liap con samiang Hê-lôn dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","E-li-sur con samiang Sê-dưr tễ tỗp Ruben dững crơng chiau sang tâng tangái pỗn. ");
INSERT INTO bru_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","savan yễng muoi bễng ntâng muoi culám muoi chít ŏ́c práq, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng E-li-sur con samiang Sê-dưr tễ tỗp Ruben dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Sê-lumiel con samiang Suri-sadai tễ tỗp Si-mê-ôn dững crơng chiau sang tâng tangái sỡng. ");
INSERT INTO bru_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Sê-lumiel con samiang Suri-sadai dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","E-lia-sap con samiang Dưol tễ tỗp Cát dững crơng chiau sang tâng tangái tapoât. ");
INSERT INTO bru_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng E-lia-sap con samiang Dưol dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","E-li-sama con samiang Ami-hut tễ tỗp Ep-ra-im dững crơng chiau sang tâng tangái tapul. ");
INSERT INTO bru_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","savan yễng muoi bễng ntâng muoi culám muoi chít ŏ́c práq, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ntroŏq tangcáh muoi lám; cữu tôl muoi lám cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng E-li-sama con samiang Ami-hut dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ca-maliel con samiang Phê-dasur tễ tỗp Ma-nasê dững crơng chiau sang tâng tangái tacual. ");
INSERT INTO bru_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Ca-maliel con samiang Phê-dasur dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Abi-dan con samiang Kê-dien-i tễ tỗp Ben-yamin dững crơng chiau sang tâng tangái takêh. ");
INSERT INTO bru_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ntroŏq tangcáh bar lám cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Abi-dan con samiang Kê-dien-i dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ahi-sơ con samiang Ami-sadai tễ tỗp Dan dững crơng chiau sang tâng tangái muoi chít. ");
INSERT INTO bru_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Ahi-sơ con samiang Ami-sadai dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pakiel con samiang Oc-ran tễ tỗp Asêr dững crơng chiau sang tâng tangái muoi chít la muoi. ");
INSERT INTO bru_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","savan yễng muoi bễng ntâng muoi culám muoi chít ŏ́c práq, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Pakiel con samiang Oc-ran dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ahi-ra con samiang E-nan tễ tỗp Nep-tali dững crơng chiau sang tâng tangái muoi chít la bar. ");
INSERT INTO bru_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Crơng án dững chiau sang la neq: Cuban práq muoi bễng ntâng muoi ki-lô tadĩ; tangan sa‑ỡng práq ntâng tacual culám cram puai noau khoiq anoat dŏq tâng Dống Sang Aroâiq; cuban cớp tangan sa‑ỡng ki bữn poân bỗt mi carchốc cớp dỡq nsễng o‑li‑vê puai tâng rit chiau sang máh thữ racáu; ");
INSERT INTO bru_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","savan yễng muoi bễng ntâng muoi culám muoi chít cram, dếh chóq poân crơng phuom hỡ; ");
INSERT INTO bru_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ntroŏq tangcáh muoi lám; cữu tôl muoi lám; cớp cữu tôl con bỡiq muoi cumo muoi lám dŏq bốh chiau sang; ");
INSERT INTO bru_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","mbễq tangcáh muoi lám dŏq táq rit pupứt lôih; ");
INSERT INTO bru_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ntroŏq tangcáh bar lám; cữu tôl sỡng lám; mbễq tangcáh sỡng lám; cớp cữu tôl sỡng lám bỡiq muoi cumo dŏq chiau sang yỗn cỡt ratoi. Nâi la máh crơng Ahi-ra con samiang E-nan dững chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Parỗm nheq tữh máh crơng tễ cũai sốt muoi chít la bar náq dững chiau sang tâng prông sang, bữn neq: Cuban práq muoi chít la bar bễng, culũng práq muoi chít la bar lám, cớp savan yễng muoi chít la bar lám. ");
INSERT INTO bru_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Cuban muoi chít la bar bễng bữn kia lĩ-ralĩ nheq, la muoi culám pái chít ŏ́c práq, cớp culũng muoi chít la bar lám la bữn kia lĩ-ralĩ tê, la tapul chít ŏ́c práq puai noau anoat tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Muoi chít la bar bễng savan yễng, dếh crơng phuom, bữn kia lĩ-ralĩ nheq, la muoi chít ŏ́c práq puai noau anoat tâng Dống Sang Aroâiq. Nheq tữh kia savan yễng la muoi culám bar chít ŏ́c práq. ");
INSERT INTO bru_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Parỗm nheq tữh charán ca cỡt crơng dŏq bốh chiau sang, la ntroŏq tangcáh muoi chít la bar lám, cữu tôl muoi chít la bar lám, cữu tôl con bỡiq muoi cumo la muoi chít la bar lám, dếh máh thữ racáu dŏq bốh chiau sang; mbễq muoi chít la bar lám dŏq táq rit pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Parỗm nheq tữh charán ca dững chiau sang yỗn cỡt ratoi la neq: Ntroŏq tangcáh bar chít la pỗn lám, cữu tôl tapoât chít lám, mbễq tangcáh tapoât chít lám, cớp cữu tôl con bỡiq muoi cumo tapoât chít lám, dŏq chiau sang yỗn cỡt ratoi. Nheq tữh charán nâi dŏq táq rit tâng tangái noau chiau sang prông yỗn cỡt pún miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Toâq Môi-se mut tâng Dống Sang Aroâiq, án sâng Yiang Sursĩ táq ntỡng cớp án tễ Hĩp Parnai Parkhán, bân mpứng dĩ rup chê-rup. ");
INSERT INTO bru_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yiang Sursĩ ớn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Cóq mới atỡng yỗn Arôn dáng, toâq án achúh tapul lám chớp tớu cóq án dŏq tâng pỡng tŏ́ng rông yỗn poang claq coah moat.” ");
INSERT INTO bru_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Arôn trĩh cớp achúh máh chớp tớu tâng tŏ́ng rông, yỗn án claq coah moat. ");
INSERT INTO bru_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ma tŏ́ng rông tớu ki, tễ rup piar tâng pỡng toau toâq ayững, noau táq toâq yễng noau chor pachĩr cỡt rup machớng Yiang Sursĩ khoiq atỡng Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Cóq mới cayoah cũai Lê-vi tễ cũai I-sarel canŏ́h; chơ sambráh tỗp alới ");
INSERT INTO bru_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","puai tâng rit neq: Ĩt dỡq sambráh, chơ trutrếh chóq alới cớp ớn alới cũah nheq sóc muar tâng tỗ chác cớp pooh máh tampâc. Ki nŏ́q têq noap alới cỡt bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Moâm ki, cóq alới dững chiau sang muoi lám ntroŏq tangcáh cớp máh thữ racáu noau khoiq ĩat cỡt bỗt talốc cớp dỡq nsễng o‑li‑vê; cớp dững muoi lám ễn ntroŏq tangcáh chiau sang dŏq táq rit pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Chơ arô nheq tữh cũai I-sarel toâq rôm parnơi, cớp yỗn tỗp Lê-vi loŏh tayứng yáng moat Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Cóq tỗp I-sarel satoaq atĩ tâng máh plỡ cũai Lê-vi; ");
INSERT INTO bru_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","chơ Arôn cóq chiau sang tỗp alới yỗn cứq dŏq alới têq táq ranáq cứq. ");
INSERT INTO bru_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Moâm ki, cóq tỗp Lê-vi satoaq atĩ tâng plỡ bar lám ntroŏq tangcáh, muoi lám dŏq pupứt lôih, ma muoi lám ễn dŏq bốh chiau sang yỗn cứq dŏq táq rit sambráh tỗp Lê-vi. ");
INSERT INTO bru_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Cóq mới chiau sang tỗp Lê-vi cỡt crơng mpon yỗn cứq, cớp yỗn Arôn, dếh máh con samiang án, cỡt máh cũai nhêng salĩq tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Machớng nâi tê cóq mới cayoah tỗp Lê-vi tễ tỗp I-sarel canŏ́h dŏq alới cỡt khong cứq. ");
INSERT INTO bru_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Toâq moâm mới sambráh cớp chiau sang tỗp alới yỗn cứq, chơ alới têq táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Cứq roap ĩt tỗp alới dŏq pláih máh con samiang clúng tỗp I-sarel, chơ alới cỡt khong cứq toâp. ");
INSERT INTO bru_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Bo cứq cachĩt nheq tữh con samiang clúng cũai Ê-yip-tô, cứq roap máh con samiang clúng tỗp I-sarel cỡt khong cứq, dếh dũ lám charán roah pốh dâu hỡ. ");
INSERT INTO bru_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ma sanua, cứq rưoh tỗp Lê-vi pláih loah máh con samiang clúng cũai proai I-sarel; ");
INSERT INTO bru_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","cớp cứq chiau tỗp Lê-vi yỗn Arôn cớp máh con samiang án, yỗn alới têq táq ranáq bân Ntốq Tễng Rit, dŏq rabán curiaq tỡ yỗn máh cũai I-sarel pỡq cheq Ntốq Tễng Rit. Khân alới pỡq cheq, cóq alới cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Môi-se cớp Arôn, dếh cũai proai I-sarel chiau sang tỗp Lê-vi yỗn Yiang Sursĩ, táq puai santoiq Yiang Sursĩ khoiq ớn tỗp alới táq. ");
INSERT INTO bru_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Tỗp Lê-vi sambráh tỗ chác cớp pooh tampâc, chơ Arôn chiau sang tỗp alới cỡt crơng mpon yỗn Yiang Sursĩ. Moâm ki án táq rit sambráh yỗn tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ngkíq alới táq puai dũ ramứh ariang Yiang Sursĩ khoiq ớn na Môi-se yỗn tỗp Lê-vi. Yuaq ngkíq, tỗp Lê-vi têq táq ranáq tâng Dống Sang Aroâiq, ma Arôn cớp máh con samiang án cỡt cũai sốt tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ống tỗp Lê-vi tễ bar chít la sỡng cumo achỗn sâng têq táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Toâq alới bữn sỡng chít cumo chơ, cóq alới rlu, tỡ bữn táq noâng ranáq ki. ");
INSERT INTO bru_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ma yỗn alới rachuai sễm ai alới tỗp Lê-vi canŏ́h táq ranáq tâng Dống Sang Aroâiq, ma tỡ yỗn alới táq bữm ranáq ki. Nâi la ranáq tỗp Lê-vi cóq táq puai.” ");
INSERT INTO bru_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yiang Sursĩ atỡng Môi-se tâng ntốq aiq cheq cóh Si-nai tâng casâi muoi, cumo bar vớt cũai I-sarel loŏh tễ cruang Ê-yip-tô. Yiang Sursĩ pai neq: ");
INSERT INTO bru_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Toâq moat mandang ngêt tâng tangái muoi chít la pỗn, casâi nâi, ");
INSERT INTO bru_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","cũai I-sarel cóq táq rit cha bũi dŏq sanhữ loah Tangái Loŏh. Cóq táq puai yỗn pĩeiq máh phễp rit nâi.” ");
INSERT INTO bru_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Yuaq ngkíq, Môi-se atỡng cũai proai I-sarel táq rit cha bũi Tangái Loŏh, ");
INSERT INTO bru_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","cớp pên tabữ tangái muoi chít la pỗn, casâi muoi, alới táq rit tâng ntốq aiq cheq cóh Si-nai. Máh cũai proai táq puai dũ ramứh machớng Yiang Sursĩ khoiq ớn na Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ma bữn bĩq náq sâng tỡ bữn bráh puai rit, cỗ alới satoaq sac cumuiq; ngkíq cũai ki tỡ têq táq rit cha bũi sanhữ Tangái Loŏh. Ngkíq alới toâq tayứng yáng moat Môi-se cớp Arôn, ");
INSERT INTO bru_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","chơ blớh neq: “Hếq cỡt tỡ bữn bráh cỗ hếq satoaq sac cumuiq; cỗ nŏ́q hếq tỡ têq chiau crơng sang yỗn Yiang Sursĩ parnơi cớp máh cũai I-sarel canŏ́h?” ");
INSERT INTO bru_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Môi-se ta‑ỡi neq: “Cóq anhia acoan voai, cứq ễ tamứng ntrớu Yiang Sursĩ tĩeih atỡng tễ ranáq nâi.” ");
INSERT INTO bru_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","atỡng máh cũai proai I-sarel neq: “Bo léq anhia, tỡ la con châu anhia, ma cỡt tỡ bữn bráh, cỗ tian satoaq sac cumuiq, tỡ la pỡq rana yơng, ma yoc ễ táq rit cha bũi sanhữ tê Tangái Loŏh, ");
INSERT INTO bru_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ki yỗn anhia cha bũi tâng casâi bar, pên tabữ tangái muoi chít la pỗn casâi ki. Chơ cóq anhia cha bễng mi ŏ́q crơng pluoih cớp cha bát ntáng sâng. ");
INSERT INTO bru_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Chỗi dŏq crơng sana toau toâq tarưp parnỡ, cớp chỗi déh nghang charán. Ma cóq anhia táq puai tâng rit cha bũi sanhữ Tangái Loŏh ĩn khoiq anoat chơ. ");
INSERT INTO bru_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Khân cũai aléq cỡt bráh puai rit, cớp tỡ bữn pỡq rana yơng, ma án tỡ bữn noap rit Tangái Loŏh, cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. Yuaq án tỡ bữn chiau sang yỗn cứq máh crơng khoiq anoat dŏq, ngkíq án cóq chĩuq roap tôt án bữm. ");
INSERT INTO bru_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Khân bữn cũai cruang canŏ́h ỡt cớp anhia ma yoc ễ yám noap tê Tangái Loŏh, alới cóq trĩh phễp rit ki dũ ramứh. Cớp cóq dũ náq cũai noap ĩt phễp rit ki, tỡ cỡn ống cũai I-sarel sâng, ma dếh cũai cruang canŏ́h hỡ, la cóq táq puai tê.” ");
INSERT INTO bru_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Tangái patứng Dống Sang Aroâiq, bữn ramứl sễng clũom cadớp nheq Dống Sang Aroâiq ki. ");
INSERT INTO bru_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Toâq sadâu ramứl ki cỡt cusâu ariang ũih. ");
INSERT INTO bru_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Bo léq ma ramứl yial achỗn tễ Dống Sang Aroâiq, bo ki toâp cũai proai I-sarel atỡi máh dống alới ỡt, chơ patứng loah pỡ ntốq tamái ễn la ntốq ramứl sễng. ");
INSERT INTO bru_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Cũai proai tŏ́h dống aroâiq cớp patứng loah tamái machớng Yiang Sursĩ atỡng alới. Bo ramứl noâng ỡt clũom cadớp dống sang aroâiq, tỗp alới ỡt loâng bân ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Toâq ramứl ỡt clũom cadớp dũn, ki alới sa‑âm cớp trĩh Yiang Sursĩ, cớp tỡ bữn pỡq chu léq. ");
INSERT INTO bru_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ma khân ramứl ỡt clũom cadớp bar pái tangái sâng Dống Sang Aroâiq puai rangứh Yiang Sursĩ ớn, ki alới noâng ỡt ngki, tỡ bữn dễq pỡq chu léq. ");
INSERT INTO bru_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Khân ramứl clũom cadớp tễ pên tabữ toau toâq tarưp parnỡ sâng, bo léq ramứl yial achỗn, alới dễq bo ki toâp. Ramứl yial bo léq, alới dễq bo ki tê. ");
INSERT INTO bru_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tam bar tangái, muoi casâi, muoi cumo, tỡ la dũn, ma bo léq ramứl noâng clũom tâng Dống Sang Aroâiq, bo ki alới tỡ bữn dễq chu léq. Ma bo léq ramứl yial pỡq, alới dễq bo ki toâp tê. ");
INSERT INTO bru_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Alới patứng tỡ la tŏ́h máh dống alới, la táq puai santoiq Yiang Sursĩ atỡng na Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ĩt práq, chơ táq bar lám lavia, khễ plóng arô máh cũai proai yỗn toâq rôm, tỡ la toâq ễ atỡi ntốq ỡt. ");
INSERT INTO bru_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Toâq noau plóng bar lám lavia sưong cuti, cóq nheq tữh cũai proai toâq rôm parnơi cớp mới pỡ ngoah toong mut Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Khân sưong lavia bữr ma ống muoi lám lavia sâng, ki cóq máh cũai sốt tễ dũ sâu toâq rôm parnơi cớp mới. ");
INSERT INTO bru_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ma khân sưong lavia bữr cakéh trỗ muoi, ki yỗn dũ tỗp ỡt coah angia mandang loŏh dễq pỡq. ");
INSERT INTO bru_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ma khân sưong lavia bữr cakéh trỗ bar, ki yỗn máh cũai ỡt coah angia pưn dễq pỡq. Yuaq sưong lavia cakéh cỡt tếc atỡng yỗn atỡi ntốq ỡt. ");
INSERT INTO bru_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Khân ễ yỗn máh cũai toâq rôm parnơi, cóq plóng lavia sưong cuti. ");
INSERT INTO bru_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Máh con samiang Arôn, la cũai tễng rit sang, alới toâp la cũai plóng lavia. “Cóq atỡng máh cũai I-sarel dũ dỡi chumát yỗn noap ĩt cớp táq puai máh phễp rit nâi. ");
INSERT INTO bru_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Bo anhia ễ loŏh rachíl tâng cutễq anhia bữm, dŏq curiaq tỗ anhia yỗn vớt tễ cũai par‑ũal, cóq anhia plóng lavia bar lám nâi dŏq cỡt tếc atỡng tễ rachíl. Cứq la Yiang Sursĩ, Ncháu anhia, cứq ễ rachuai anhia yỗn bữn vớt tễ cũai par‑ũal anhia. ");
INSERT INTO bru_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Cớp dũ trỗ táq rit cha bũi tangái Casâi Loŏh Tamái tỡ la tangái táq rit canŏ́h, toâq anhia bốh crơng chiau sang tỡ la chiau sang yỗn cỡt ratoi, cóq anhia plóng lavia. Chơ cứq lứq rachuai anhia, yuaq cứq la Yiang Sursĩ anhia.” ");
INSERT INTO bru_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Tâng tangái bar chít, casâi bar, cumo bar toâq vớt cũai I-sarel loŏh tễ cruang Ê-yip-tô, ramứl ỡt pỡng Dống Sang Aroâiq yial achỗn. ");
INSERT INTO bru_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Chơ tỗp I-sarel mbỡiq loŏh tễ ntốq aiq cheq cóh Si-nai. Ramứl ki tangứt bân ntốq aiq Paran. ");
INSERT INTO bru_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Trỗ nâi la trỗ muoi cũai I-sarel táh ntốq ỡt, chơ táq puai santoiq Yiang Sursĩ ớn na Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Dũ trỗ alới dễq, tỗp yống aroâiq tếc tỗp Yuda loŏh pỡq nhũang. Cũai sốt alới la Nasôn con samiang Ami-nadap. ");
INSERT INTO bru_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Cũai sốt tỗp I-sacar la Nê-thanel con samiang Suar; ");
INSERT INTO bru_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","cũai sốt tỗp Sa-bulôn la E-liap con samiang Hê-lôn. ");
INSERT INTO bru_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Chơ alới tŏ́h Dống Sang Aroâiq; cớp máh sâu Kêr-sôn cớp Mê-rari cỡt cũai dỗl cớp crang dững dống ki. Chơ alới tayoâq pỡq. ");
INSERT INTO bru_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Moâm ki, tỗp yống aroâiq tếc tỗp Ruben ễn loŏh pỡq. Cũai sốt alới la E-li-sur con samiang Sê-dưr. ");
INSERT INTO bru_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Cũai sốt tỗp Si-mê-ôn la Sê-lumiel con samiang Suri-sadai; ");
INSERT INTO bru_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","cũai sốt tỗp Cát la E-lia-sap con samiang Dưol. ");
INSERT INTO bru_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Chơ máh sâu Cô-hat tễ tỗp Lê-vi, alới cỡt cũai dỗl crang máh crơng radỡng dŏq táq rit, chơ tayoâq pỡq. Tữ tỗp nâi pỡq toâq pỡ ntốq tamái chơ, máh tỗp canŏ́h ca pỡq nhũang, alới khoiq chóh moâm Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ntun ễn, tỗp yống aroâiq tếc tỗp Ep-ra-im ễn loŏh pỡq; cũai sốt alới la E-li-sama con samiang Ami-hut. ");
INSERT INTO bru_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Cũai sốt tỗp Ma-nasê la Ca-maliel con samiang Phê-dasur; ");
INSERT INTO bru_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","cũai sốt tỗp Ben-yamin la Abi-dan con samiang Kê-dien-i. ");
INSERT INTO bru_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Toâq parsốt tháng, la tỗp yống aroâiq tếc tỗp Dan, la tỗp bán curiaq máh tỗp ca ntôm pỡq. Cũai sốt alới la Ahi-sơ con samiang Ami-sadai. ");
INSERT INTO bru_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Cũai sốt tỗp Asêr la Pakiel con samiang Oc-ran; ");
INSERT INTO bru_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","cũai sốt tỗp Nep-tali la Ahi-ra con samiang E-nan. ");
INSERT INTO bru_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Nâi la máh phễp rit pỡq cỡt tỗp cỡt mũ khong cũai proai I-sarel toâq alới dễq pỡq chu ntốq canŏ́h. ");
INSERT INTO bru_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Môi-se mơi Hô-bap con samiang Yê-trô yacũn Môi-se, tễ tỗp Madian neq: “Tỗp hếq ntôm pỡq chu cutễq Yiang Sursĩ ễ chiau yỗn tỗp hếq. Án khoiq par‑ữq ễ yỗn máh tỗp I-sarel cỡt sốc bữn. Yuaq ngkíq, sễq anhia pỡq parnơi cớp tỗp hếq. Hếq ễ tampễq ŏ́c sốc bữn ki yỗn tỗp anhia bữn tê.” ");
INSERT INTO bru_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hô-bap ta‑ỡi neq: “Tỡ bữn mŏ! Hếq ễ píh loah chu vil viang hếq bữm.” ");
INSERT INTO bru_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Môi-se pai ễn neq: “Sễq anhia chỗi táh tỗp hếq; anhia dáng raloaih lứq chơ ntốq léq o yỗn hếq ỡt tâng ntốq aiq, cớp anhia têq cỡt cũai ayông rana dững tỗp hếq pỡq. ");
INSERT INTO bru_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Khân anhia pỡq cớp hếq, ki hếq ễ tampễq ŏ́c bốn Yiang Sursĩ yỗn hếq, yỗn anhia bữn tê.” ");
INSERT INTO bru_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Toâq cũai proai loŏh tễ cóh Si-nai, la cóh khong Yiang Sursĩ, alới pỡq rana dũn pái tangái. Alới crang Hĩp Parnai Parkhán pỡq nhũang dŏq chi-chuaq ntốq têq yỗn alới ỡt. ");
INSERT INTO bru_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Trỗ léq alới atỡi ntốq ỡt, bữn sapom ramứl tễ Yiang Sursĩ ỡt rayư pỡng alới. ");
INSERT INTO bru_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Dũ trỗ toâq alới atỡi Hĩp Parnai Parkhán, Môi-se dốq pai neq: “Cucốh Yiang Sursĩ! Sễq anhia yuor tayứng! Sễq yỗn máh cũai par‑ũal cỡt pláh chap, cớp yỗn máh cũai kêt anhia priang yơng.” ");
INSERT INTO bru_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Toâq alới tangứt pỡq, Môi-se dốq pai neq: “Cucốh Yiang Sursĩ ơi! Sễq anhia píh loah chu cũai proai I-sarel clứng toâq ớc vêu nâi!” ");
INSERT INTO bru_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Máh cũai proai bubéq-bubưp chóq Yiang Sursĩ cỗ alới tamóh túh coat. Toâq Yiang Sursĩ sâng ngkíq, án sâng cutâu lứq; chơ án yỗn ũih sễng pỡ máh cũai proai. Ũih ki cat mpễr ntốq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Chơ máh cũai proai arô Môi-se yỗn toâq chuai; cớp Môi-se câu sễq Yiang Sursĩ chuai, chơ ũih ki pât. ");
INSERT INTO bru_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Yuaq ngkíq, alới amứh ntốq ki la Tabê-ra, yuaq tangái ki ũih tễ Yiang Sursĩ blữ tâng mpứng dĩ tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bữn cũai cruang canŏ́h pỡq parnơi cớp cũai I-sarel. Tỗp alới yoc lứq cha sâiq; ma bữn tỗp I-sarel toâp bubéq-bubưp tê pai tỡ o neq: “Hếq yoc lứq cha sâiq! ");
INSERT INTO bru_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ỡt tâng cruang Ê-yip-tô tỗp hếq cơi cha sĩaq máh pahỡm yoc ễ cha, ma tỡ bữn túh chỡng. Tỗp hếq sanhữ cha kễl yuang, kễl pachoai, sakieu, phác-bỗ, cớp toiq. ");
INSERT INTO bru_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ma sanua ŏ́c bán rêng hếq la khoiq pứt nheq chơ, cu rangái cha níc mana nâi sâng!” ");
INSERT INTO bru_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana nâi cỡt sanŏ́q ŏ́c ngo, santứm rariaq carchốc cloc. ");
INSERT INTO bru_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Tâng sadâu án satooh muoi prớh cớp dỡq latac mpễr ntốq alới ỡt. Toâq poang tarưp máh cũai proai pỡq tỗiq ĩt; chơ ĩat táq bỗt. Moâm ki alới tacooq yỗn chĩn dŏq táq bễng tangkhla ễm riang bễng mi khoiq carchốc cớp dỡq nsễng o‑li‑vê. ");
INSERT INTO bru_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Môi-se sâng máh cũai proai ntôm bubéq-bubưp bo alới tayứng cheq ngoah toong dống aroâiq alới bữm. Án sâng túh lứq tâng mứt, yuaq Yiang Sursĩ sâng cutâu mứt chóq tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Chơ án pai chóq Yiang Sursĩ neq: “Cỗ nŏ́q anhia táq ntâng lứq chóq cứq? Anhia tỡ bữn bũi cớp cứq noâng tỡ? Cỗ nŏ́q anhia yỗn cứq nhêng salĩq máh cũai nâi? ");
INSERT INTO bru_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Cứq tỡ bữn tễng tỡ la canỡt cũai nâi, ma cỗ nŏ́q anhia ma yỗn cứq cỡt riang cũai mantán alới, dŏq rachuai alới ariang ca‑ữ con, dŏq ayông alới toâq pỡ cutễq anhia khoiq par‑ữq cớp achúc achiac alới? ");
INSERT INTO bru_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Pỡ léq cứq ễ ravoât sâiq yỗn dũ máh cũai nâi cha? Tỗp alới toar ễu níc yoc ễ cha sâiq. ");
INSERT INTO bru_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Cứq tỡ têq rabán curiaq máh cũai nâi na bán rêng cứq bữm; ranáq nâi ntâng lứq clữi tễ rêng cứq bữn. ");
INSERT INTO bru_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Khân anhia ma táq nneq chóq cứq, sễq anhia cachĩt táh chíq cứq, yuaq cứq tỡ rơi chĩuq tanhĩr noâng tễ ŏ́c anhia cutâu nâi.” ");
INSERT INTO bru_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới parỗm tapul chít náq mới dáng têq táq ranáq o dŏq ayông cớp taniap cũai I-sarel. Cóq alới toâq pỡ Dống Sang Aroâiq, chơ tayứng cheq mới. ");
INSERT INTO bru_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Cứq ễ sễng táq ntỡng cớp mới bân ntốq ki, cớp cứq ễ ĩt Raviei cứq khoiq yỗn mới, chơ tampễq Raviei ki yỗn alới bữn tê. Chơ tỗp alới têq nhêng salĩq cũai proai parnơi cớp mới, dŏq mới tỡ bữn dỗl mpỗl ống manoaq sâng. ");
INSERT INTO bru_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Sanua cóq mới atỡng máh cũai proai neq: ‘Cóq tỗp anhia sambráh tỗ chác puai rit, yuaq tangái parnỡ anhia bữn cha sâiq. Yuaq Yiang Sursĩ khoiq sâng chơ sưong anhia toar ễu, cớp anhia pai bo anhia ỡt tâng cruang Ê-yip-tô bữn cha sâiq thrưong lứq. Cỗ tian ranáq ngkíq, Yiang Sursĩ ễ táq yỗn anhia bữn cha sâiq, ma cóq anhia cha yỗn nheq máh sâiq ki. ");
INSERT INTO bru_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ma anhia tỡ bữn cha ống muoi tangái, bar tangái, sỡng tangái, muoi chít tangái, tỡ la bar chít tangái sâng; ");
INSERT INTO bru_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ma anhia lứq bữn cha sâiq nheq muoi casâi, toau níl cớp tỡ ễq cha noâng sâiq ki. Ranáq nâi lứq cỡt, yuaq anhia tỡ bữn noap Yiang Sursĩ ca ỡt tâng mpứng dĩ tỗp anhia, cớp anhia bubéq-bubưp chóq án pai neq: “O hỡn hếq tỡ bữn loŏh tễ cruang Ê-yip-tô.”’” ");
INSERT INTO bru_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Môi-se pai chóq Yiang Sursĩ neq: “Cứq ntôm dững cũai proai 600,000 náq ỡt tâng ntốq nâi; cớp anhia pai ễ yỗn tỗp alới cha sâiq nheq muoi casâi, lứq tỡ? ");
INSERT INTO bru_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Tễ léq bữn ntroŏq tỡ la cữu yỗn dũ cũai nâi cha? Nheq tữh sĩaq ỡt tâng dỡq mưt la tỡ khám mŏ yỗn máh cũai nâi cha.” ");
INSERT INTO bru_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yiang Sursĩ ta‑ỡi neq: “Nŏ́q mới chanchớm la bữn ŏ́c ntrớu cứq tỡ têq táq tỡ? Tỡ bữn dũn noâng, mới lứq bữn hữm máh ranáq cứq atỡng mới!” ");
INSERT INTO bru_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ngkíq Môi-se loŏh atỡng loah máh cũai proai tễ máh santoiq Yiang Sursĩ khoiq pai. Chơ án ớn alới tapul chít náq tayứng cỡt rana lavíng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Chơ Yiang Sursĩ sễng tâng sapom ramứl, chơ táq ntỡng cớp Môi-se, cớp án ĩt Raviei án khoiq yỗn Môi-se, chơ tampễq Raviei ki yỗn tapul chít náq ca rôm ki. Toâq Raviei Yiang Sursĩ ỡt cớp alới, nheq náq alới têq atỡng tang bỗq Yiang Sursĩ, ma ntun alới tỡ têq atỡng máh ki noâng. ");
INSERT INTO bru_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Bữn bar náq tễ tỗp tapul chít náq ki, la El-dat cớp Mê-dat noâng ỡt tâng dống alới bữm; alới tỡ bữn mut rôm pỡ Dống Sang Aroâiq. Ma Raviei Yiang Sursĩ sễng pỡ alới tâng ntốq alới ỡt, cớp alới táq ntỡng tang bỗq Yiang Sursĩ tê. ");
INSERT INTO bru_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Bữn manoaq samiang póng lúh pỡq atỡng Môi-se tễ ranáq toâq pỡ El-dat cớp Mê-dat. ");
INSERT INTO bru_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Chơ Yô-sũa con samiang Nun, cũai rachuai ranáq Môi-se tữ án noâng póng, án pai chóq Môi-se neq: “Achuaih ơi! Pỡq atỡng alới yỗn tangứt!” ");
INSERT INTO bru_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ma Môi-se ta‑ỡi neq: “Mới ngcŏh alới ễ cheng chớc cứq tỡ? Cứq ễq Yiang Sursĩ chiau Raviei án yỗn dũ náq cũai proai án, cớp táq yỗn dũ náq alới têq atỡng tang bỗq Yiang Sursĩ.” ");
INSERT INTO bru_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Chơ Môi-se cớp tapul chít náq cũai ayông cớp taniap tỗp I-sarel píh chu loah pỡ dống alới. ");
INSERT INTO bru_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Bo ki toâp, Yiang Sursĩ táq yỗn cuyal rapuq phát dững máh chớm ntrut tễ dỡq mưt; chơ án srúh chũop nheq mpễr ntốq alới ỡt. Máh chớm ki tưn-ưn tháng tâng cloong cutễq sarỡih mán bar coat, cớp ntốq án srúh la‑a hỡn tễ noau têq tayáh tâng muoi tangái. ");
INSERT INTO bru_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ngkíq nheq tangái nheq sadâu cớp tangái ntun hỡ máh cũai proai ki cỗp chớm ntrut; manoaq cỗp tỡ bữn ŏ́q sỡng chít achoiq. Chơ alới dững aloŏh tiang chũop nheq tâng ntốq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Bo alới ntôm cha sâiq ki, Yiang Sursĩ sâng cutâu chóq alới, cớp táq yỗn alới cỡt a‑ĩ sanỗq. ");
INSERT INTO bru_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Alới amứh ntốq ki la Ki-brôt Ha-tava, yuaq ntốq ki la ntốq tứp cũai cuchĩt cỗ alới ham yoc ễ cha sâiq. ");
INSERT INTO bru_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Chơ cũai proai dễq tễ ntốq ki pỡq chu Hasê-rôt ễn, la ntốq alới ỡt dỡ. ");
INSERT INTO bru_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mi-riam cớp Arôn tếq Môi-se yuaq án racoâiq cớp mansễm tễ cruang Cut. ");
INSERT INTO bru_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Alới blớh neq: “Nŏ́q Yiang Sursĩ atỡng ống na manoaq Môi-se sâng? Nŏ́q án tỡ bữn atỡng na hái hỡ?” Yiang Sursĩ sâng santoiq alới pai ngkíq. ");
INSERT INTO bru_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Môi-se la cũai asễng tỗ clữi nheq tễ cũai canŏ́h tâng cloong cutễq nâi.) ");
INSERT INTO bru_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Bo ki toâp Yiang Sursĩ atỡng Môi-se, Arôn, cớp Mi-riam neq: “Cóq anhia pái náq pỡq chu Dống Sang Aroâiq.” Chơ alới pái náq ki pỡq, ");
INSERT INTO bru_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","cớp Yiang Sursĩ sễng tâng sapom ramứl, tayứng bân ngoah toong mut Dống Sang Aroâiq cớp arô neq: “Arôn cớp Mi-riam ơi!” Chơ alới bar náq tayáh loŏh yáng moat, ");
INSERT INTO bru_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","cớp Yiang Sursĩ pai ễn neq: “Cóq anhia tamứng cứq yỗn samoât! Toâq bữn cũai tang bỗq Yiang Sursĩ ỡt tâng mpứng dĩ tỗp anhia, cứq yỗn alới hữm cứq na ŏ́c sapáh tỡ la na rláu mpáu. ");
INSERT INTO bru_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ma toâq cứq táq ntỡng atỡng cớp Môi-se, la cũai táq ranáq cứq, ki cứq táq mpha; tễ cũai proai cứq, án la cũai cứq noap samoât samơi. ");
INSERT INTO bru_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ngkíq cứq táq ntỡng cớp án manoaq rato moat chu manoaq yỗn raloaih lứq. Tỡ bữn ranáq ntrớu ma cứq cutooq; án khoiq hữm dếh roâp riang cứq. Cỗ nŏ́q anhia khớn chíl cũai táq ranáq cứq?” ");
INSERT INTO bru_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yiang Sursĩ nhôp alới ntâng lứq; chơ án pỡq chíq. ");
INSERT INTO bru_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Bo ki toâp ramứl yial achỗn tễ ntốq Dống Sang Aroâiq; cớp bo ki toâp tê Mi-riam cỡt a‑ĩ ngcâr hâp lứq, cloc salĩat. Toâq Arôn nhêng hữm án cỡt a‑ĩ ngkíq, ");
INSERT INTO bru_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","án tál tháng sễq tễ Môi-se neq: “Sễq achuaih chỗi yỗn hếq roap tôt cỗ tian tễ ranáq lôih cớp sacũl máh hếq khoiq táq. ");
INSERT INTO bru_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Chỗi yỗn tỗ Mi-riam cỡt ariang carnễn mbỡiq sễt ma tỡ bữn thŏ́ng; cớp chỗi yỗn tỗ án samoât bỗr cha nheq muoi béq.” ");
INSERT INTO bru_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ngkíq Môi-se arô sễq tễ Yiang Sursĩ neq: “Cucốh Yiang Sursĩ ơi! Sễq anhia tahâu niang yỗn cỡt bán loah!” ");
INSERT INTO bru_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yiang Sursĩ ta‑ỡi neq: “Khân mpoaq án cuchóh chóq tâng mieiq án, ngkíq án casiet táq dũn tapul tangái. Cóq yỗn án ỡt yáng tiah ntốq anhia ỡt tapul tangái. Vớt ki, nŏ́q têq án chu ỡt loah pỡ dống án.” ");
INSERT INTO bru_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Yuaq ngkíq Mi-riam ỡt yáng tiah vil nheq tapul tangái, cớp cũai proai tỡ bữn dễq chu léq noâng toau án píh chu loah. ");
INSERT INTO bru_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Chơ tỗp alới loŏh tễ vil Hasê-rôt, cớp táq ntốq ỡt pỡ ntốq aiq Paran ễn. ");
INSERT INTO bru_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Cóq mới rưoh manoaq cũai ayông tễ dũ tỗp I-sarel; chơ ớn alới pỡq tutuaiq cruang cutễq Cana-an, la ntốq cứq ễ chiau yỗn máh cũai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Môi-se trĩh cớp táq puai máh santoiq ki. Toâq loŏh tễ ntốq aiq Paran, án ớn máh cũai ayông pỡq tutuaiq, la neq: ");
INSERT INTO bru_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Tễ tỗp Ruben la Samua con samiang Sacur. ");
INSERT INTO bru_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Tễ tỗp Si-mê-ôn la Saphat con samiang Hô-ri. ");
INSERT INTO bru_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Tễ tỗp Yuda la Calep con samiang Yê-phunê. ");
INSERT INTO bru_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Tễ tỗp I-sacar la I-cal con samiang Yô-sep. ");
INSERT INTO bru_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Tễ tỗp Ep-ra-im la Hô-sê con samiang Nun. ");
INSERT INTO bru_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Tễ tỗp Ben-yamin la Pal-ti con samiang Raphu. ");
INSERT INTO bru_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Tễ tỗp Sa-bulôn la Cadiel con samiang Sô-di. ");
INSERT INTO bru_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Tễ tỗp Ma-nasê la Cadĩ con samiang Susi. ");
INSERT INTO bru_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Tễ tỗp Dan la Amiel con samiang Kê-mali. ");
INSERT INTO bru_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Tễ tỗp Asêr la Sê-thur con samiang Mi-kêl. ");
INSERT INTO bru_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Tễ tỗp Nep-tali la Nabi con samiang Vôp-si. ");
INSERT INTO bru_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Tễ tỗp Cát la Cual con samiang Maki. ");
INSERT INTO bru_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Nheq tữh cũai nâi, Môi-se ớn alới pỡq tutuaiq cutễq ki. Án amứh Hô-sê con samiang Nun ramứh tamái la Yô-sũa. ");
INSERT INTO bru_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Toâq Môi-se ớn alới pỡq tutuaiq cutễq cruang Cana-an, án atỡng alới neq: “Cóq anhia chỗn chu coah angia pỡng tễ ntốq nâi, mut chu coah angia pưn cruang Cana-an, chơ pỡq chu máh dũal cớp cóh. ");
INSERT INTO bru_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Cóq anhia tutuaiq nhêng yỗn samoât cutễq ki cỡt nŏ́q, bữn cũai proai sa‑ữi máh léq, cớp alới rêng ma ieuq. ");
INSERT INTO bru_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Cớp tutuaiq cruang cutễq nâi phốn phuor o ma tỡ bữn, cớp tâng ntốq nâi bữn viang khâm lavíng vil ma tỡ bữn, tỡ la páh-taláh sâng? ");
INSERT INTO bru_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Cóq anhia tutuaiq nhêng cutễq ki phốn phuor o, tỡ la bữn aluang aloai ma tỡ bữn? Cóq anhia dững achu palâi tễ aluang tâng cutễq ki.” (Catữ ki, la catữ palâi nho mbỡiq chĩn.) ");
INSERT INTO bru_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Yuaq ngkíq, tỗp cũai tutuaiq ki pỡq chu angia pỡng, cớp tutuaiq yỗn dáng samoât máh cruang cutễq pỡ ntốq aiq Sin, tễ coah angia pưn toau toâq rana pỡq chu vil Rê-hop cheq cớp raláp Hamat ỡt coah angia pỡng. ");
INSERT INTO bru_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Tỗp alới pỡq chu angia pưn cruang cutễq ki nhũang. Moâm ki alới toâq pỡ vil Hep-rôn, la ntốq máh tŏ́ng toiq Ahi-man, Sê-sai, cớp Tal-mai ỡt. Máh cũai nâi la tŏ́ng toiq Anac, la cũai tỗ chác toâr ca ỡt tâng ntốq ki. (Vil Hep-rôn nâi noau ayứng tapul cumo nhũang noau ayứng vil Sô-an tâng cruang Ê-yip-tô.) ");
INSERT INTO bru_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Tỗp alới toâq pỡ avúng Et-côn. Tâng ntốq ki alới catráiq muoi abễng tễ voar nho palâi bong lứq. Alới ĩt aluang taróc, chơ bar náq crang. Alới ĩt dếh palâi ỗiq-tâi cớp palâi tarúng hỡ. ");
INSERT INTO bru_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(Ntốq ki noau amứh ‘avúng Et-côn’, cỗ nhơ tỗp I-sarel catráiq ĩt tangcóq palâi nho tâng ntốq ki.) ");
INSERT INTO bru_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Moâm alới tutuaiq nheq cruang cutễq ki dũn pỗn chít tangái, ");
INSERT INTO bru_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","alới píh chu loah pỡ Môi-se, Arôn, cớp máh cũai I-sarel pỡ vil Cadet tâng ntốq aiq Paran. Tỗp alới atỡng nheq tễ máh ramứh alới khoiq hữm, cớp apáh palâi alới dững achu hỡ. ");
INSERT INTO bru_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Alới atỡng Môi-se neq: “Tỗp hếq tutuaiq cruang cutễq ki cớp hữm cruang ki bữn cutễq phốn phuor cớp bữn palâi dũ ramứh. Nâi la palâi aluang tễ ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ma máh cũai proai ỡt tâng ntốq ki, alới bán rêng cớp bữn vil toâr, bữn dếh viang khâm lavíng nheq vil ki hỡ. Ma hỡn tễ ki ễn, hếq khoiq hữm tŏ́ng toiq Anac, la cũai tỗ chác toâr ỡt tâng ntốq ki tê. ");
INSERT INTO bru_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Tỗp A-maléc ỡt coah angia pưn cruang hếq tutuaiq; tỗp Hêt, tỗp Yê-but, cớp tỗp Amô-rit ỡt tâng máh dũal cớp cóh. Ma tỗp Cana-an ỡt mpễr tor dỡq mưt Mê-di-tarian cớp crỗng Yôr-dan.” ");
INSERT INTO bru_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Chơ Calep sưoq máh cũai proai ca bubéq-bubưp nhôp Môi-se yỗn alới tangứt; án pai neq: “Sanua cóq hái mut chíl toâp, cớp cheng ĩt máh cutễq alới; tỗp hái bữn bán rêng têq chíl riap tỗp alới.” ");
INSERT INTO bru_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ma tỗp pỡq nứng Calep ta‑ỡi neq: “Tỡ cỡn ngkíq! Tỗp hái tỡ rơi chíl tỗp alới mŏ. Cũai tâng ntốq ki bữn poâl sa‑ữi hỡn tễ tỗp hái.” ");
INSERT INTO bru_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Yuaq ngkíq, alới atỡng ŏ́c tỡ bữn lứq chũop nheq tâng máh cũai I-sarel tễ cutễq alới pỡq tutuaiq ki, pai neq: “Cutễq ki tỡ bữn bữn crơng sana dũ yỗn máh cũai proai nâi cha. Tỗp hếq hữm moang cũai tỗ chác toâr put lứq, ");
INSERT INTO bru_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","cớp cũai tỗ chác toâr sarỡih tễ tŏ́ng toiq Anac la ỡt tâng ntốq ki tê. Lứq alới nhêng chu tỗp hái cacớt ariang lam sâng.” ");
INSERT INTO bru_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Chơ nheq sadâu ki máh cũai proai miar nhiam cỗ sâng túh ngua lứq. ");
INSERT INTO bru_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Alới bubéq-bubưp chóq Môi-se cớp Arôn neq: “Khân cuchĩt tâng cruang Ê-yip-tô tỡ la tâng ntốq aiq, ki la o hỡn tễ hếq cuchĩt pỡ ntốq nâi! ");
INSERT INTO bru_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Cỗ nŏ́q Yiang Sursĩ dững tỗp hếq toâq pỡ cruang cutễq nâi? Khân hếq cuchĩt tâng ntốq rachíl, chơ máh con lacuoi hếq la noau cỗp nheq. Khân ngkíq, khaq hếq chu loah pỡ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Yuaq ngkíq, alới manoaq táq ntỡng cớp manoaq neq: “Hâi! O hái rưoh manoaq cũai yỗn ayông tỗp hái, chơ hái píh loah chu cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Chơ Môi-se cớp Arôn pũp asễng chu cutễq yáng moat nheq tữh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ma Yô-sũa con samiang Nun, cớp Calep con samiang Yê-phunê, alới bar náq tễ tỗp pỡq tutuaiq, alới háq tampâc bữm cỗ sâng ngua lứq, ");
INSERT INTO bru_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","cớp pai chóq cũai proai neq: “Cutễq tỗp hếq pỡq tutuaiq ki o lứq. ");
INSERT INTO bru_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Khân Yiang Sursĩ bũi pahỡm chóq tỗp hái, án ễ dững tỗp hái toâq pỡ ntốq ki, cớp chiau cutễq phốn phuor cớp bữn dũ ramứh ki yỗn tỗp hái bữn ndỡm. ");
INSERT INTO bru_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Chỗi lớn-sarlớn chóq Yiang Sursĩ, cớp chỗi ngcŏh cũai ỡt tâng ntốq ki. Tỗp hái lứq bữn riap tỗp alới, yuaq Yiang Sursĩ ỡt cớp tỗp hái; cớp án táq nheq tữh yiang dốq curiaq alới cỡt pê nheq. Yuaq ngkíq, chỗi ngcŏh ntrớu.” ");
INSERT INTO bru_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nheq tữh cũai clứng ễ tám tamáu chóq alới yỗn cachĩt chíq. Ma bo ki toâp, cũai proai ki hữm poang tráh ang tễ Yiang Sursĩ sapáh tâng pỡng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yiang Sursĩ pai chóq Môi-se neq: “Noâng máh léq dũn máh cũai proai nâi tỡ bữn yám noap cứq? Tam cứq táq ranáq salễh sa‑ữi ramứh tâng mpứng dĩ tỗp alới, ma noâng alới tỡ ễq sa‑âm cớp trĩh cứq. ");
INSERT INTO bru_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Cứq ễ pupứt táh chíq tỗp alới na ỗn ntâng lứq, ma cứq ễ táq yỗn mới cỡt cruang bữn cũai clứng lứq, cớp bán rêng hỡn tễ alới!” ");
INSERT INTO bru_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Môi-se ta‑ỡi Yiang Sursĩ neq: “Anhia khoiq dững aloŏh máh cũai nâi tễ cruang Ê-yip-tô la na chớc anhia. Toâq cũai Ê-yip-tô sâng tễ ranáq anhia táq chóq cũai proai anhia, ");
INSERT INTO bru_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","alới atỡng loah tễ máh ranáq ki yỗn cũai ỡt tâng cutễq nâi dáng. Cũai proai nâi khoiq dáng chơ anhia la Yiang Sursĩ, án ca ỡt cớp tỗp hếq; cớp anhia sapáh yỗn tỗp hếq hữm na sapom ramứl tangứt choâng bân ntốq hếq ỡt, dŏq ayông tỗp hếq pỡq tâng tangái, cớp na sapom pla ũih ayông hếq pỡq tâng sadâu. ");
INSERT INTO bru_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ma sanua, khân anhia ễ cachĩt táh nheq máh cũai proai anhia, chơ máh cũai cruang canŏ́h bữn sâng tễ ramứh ranoâng anhia, alới ễ pai neq: ");
INSERT INTO bru_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Yiang Sursĩ cachĩt bữm máh cũai proai án pỡ ntốq aiq, cỗ án tỡ rơi dững noâng tỗp alới pỡq chu cutễq án khoiq par‑ữq ễ yỗn alới ndỡm.’ ");
INSERT INTO bru_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Yiang Sursĩ ơi! Yuaq ngkíq, cứq câu sễq anhia apáh chớc salễh, cớp táq máh ŏ́c anhia khoiq par‑ữq dŏq chơ, bo anhia pai neq: ");
INSERT INTO bru_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Cứq la Yiang Sursĩ tỡ nai coâp nsóq mứt; cứq ễ apáh ŏ́c ayooq mantái níc cớp ŏ́c tanoang tapứng, dếh táh lôih yỗn alới ca táq choac chóq cứq. Ma cứq noâng manrap máh con châu cũai ki toau toâq pái pỗn dỡi cũai, cỗ tian ŏ́c lôih mpiq mpoaq alới khoiq táq.’ ");
INSERT INTO bru_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ma sanua Yiang Sursĩ ơi! Cỗ tễ anhia ayooq mantái níc, cớp ŏ́c ayooq ki tỡ nai rapĩen, yuaq ngkíq ma cứq khớn câu sễq yỗn anhia táh lôih máh cũai nâi, machớng anhia khoiq táh lôih yỗn tỗp alới bo alới loŏh tễ cruang Ê-yip-tô.” ");
INSERT INTO bru_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yiang Sursĩ ta‑ỡi neq: “Cứq táh lôih yỗn tỗp alới, ĩn santoiq mới sễq. ");
INSERT INTO bru_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ma cứq parkhán neq: Yuaq cứq tamoong níc, cớp ang‑ữr cứq ỡt chũop nheq tâng cốc cutễq nâi, ");
INSERT INTO bru_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","lứq tỡ va manoaq tễ máh cũai nâi ma bữn tamoong yỗn têq mut ỡt tâng cruang Cana-an. Tỗp alới khoiq hữm poang tráh ang tễ cứq, cớp ranáq salễh cứq khoiq táq pỡ cruang Ê-yip-tô, dếh tâng ntốq aiq. Ma moâm ki alới noâng chim cứq, cớp calỡih tỡ ễq trĩh cứq. ");
INSERT INTO bru_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Tỗp alới tỡ têq bữn mut chu cutễq cứq khoiq par‑ữq ễ chiau yỗn achúc achiac alới. Tỗp calỡih táh cứq, tỡ va manoaq têq mut ỡt tâng cutễq ki. ");
INSERT INTO bru_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ma cỗ nhơ Calep, cũai táq ranáq cứq, bữn mứt pahỡm mpha tễ máh cũai nâi, cớp án tanoang tapứng lứq chóq cứq, ngkíq cứq ễ dững án mut chu cutễq án khoiq pỡq tutuaiq ki. Cớp tŏ́ng toiq án lứq bữn ndỡm cutễq ki. ");
INSERT INTO bru_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Yuaq cũai A-maléc cớp cũai Cana-an ỡt tâng máh avúng cóh sanua, tâng tangái parnỡ cóq anhia píh loah pỡ ntốq aiq tâng rana pỡq chu dỡq mưt Cusâu.” ");
INSERT INTO bru_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yiang Sursĩ pai chóq Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Máh cũai nâi loai bubéq-bubưp níc chóq cứq. Cứq khoiq sâng máh sưong alới bubéq-bubưp khoiq dũn chơ! ");
INSERT INTO bru_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sanua, cóq mới atỡng ŏ́c ta‑ỡi nâi yỗn alới dáng la neq: ‘Cứq la Yiang Sursĩ tamoong mantái níc; lứq samoât cứq pai chóq anhia, la cứq ễ táq ariang cứq khoiq sâng anhia pai. ");
INSERT INTO bru_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Anhia lứq cuchĩt, cớp sac sâiq anhia cỡt parsáng-parsaiq chũop tâng ntốq aiq nâi, la cỗ tian anhia bubéq-bubưp chóq cứq. Cũai tễ tỗp anhia tễ bar chít cumo achỗn, lứq tỡ têq bữn mut ỡt pỡ cutễq ki. ");
INSERT INTO bru_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Cứq khoiq parkhán samoât samơi lứq yỗn anhia bữn ỡt pỡ ntốq ki; ma tễ tỗp anhia ca tamoong sanua, tỡ va manoaq têq bữn mut, ma bữn ống Calep cớp Yô-sũa sâng bữn mut tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Tỗp anhia khoiq pai con châu anhia pĩeiq noau cỗp, ma nỡ‑ra cứq dững alới pỡq chu cutễq anhia tỡ ễq pỡq. Ntốq ki lứq cỡt vil viang alới. ");
INSERT INTO bru_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ma máh tỗp anhia sanua, anhia lứq cuchĩt tâng ntốq aiq nâi. ");
INSERT INTO bru_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Máh tỗp con châu anhia luloah tứng-tooc tâng ntốq aiq nâi nheq pỗn chít cumo; cóq alới chĩuq sa‑ữi ramứh túh coat cỗ tian anhia tỡ bữn tanoang tapứng chóq cứq, yỗn toau cũai parsốt tháng tễ tỗp anhia ma cuchĩt tê. ");
INSERT INTO bru_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Anhia lứq bữn tamóh ŏ́c túh arức nâi dũn pỗn chít cumo, muoi cumo pláih muoi tangái anhia khoiq pỡq tutuaiq cutễq ki. Chơ anhia têq dáng raloaih tễ ranáq anhia chíl cứq la cỡt nŏ́q. ");
INSERT INTO bru_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Cứq khoiq pai ễ táq ngkíq chóq cũai ễ chíl cứq. Dũ náq anhia cóq cuchĩt tâng ntốq aiq. Cứq la Yiang Sursĩ pai santoiq nâi.’” ");
INSERT INTO bru_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Máh cũai samiang ca Môi-se ớn pỡq tutuaiq cutễq ki, alới atỡng ŏ́c tỡ bữn lứq; chơ táq yỗn máh cũai proai bubéq-bubưp pai tỡ o tễ Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Yuaq ngkíq, Yiang Sursĩ táq yỗn alới cỡt rang‑ĩ, chơ cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Tâng tỗp muoi chít la bar náq pỡq tutuaiq bữn ống Yô-sũa con samiang Nun, cớp Calep con samiang Yê-phunê sâng noâng tamoong. ");
INSERT INTO bru_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Toâq Môi-se atỡng cũai proai I-sarel parnai Yiang Sursĩ khoiq ớn, ki alới nhiam atếh cỗ sâng ngua lứq. ");
INSERT INTO bru_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Tarưp parnỡ noâng rưm-rưm, tỗp alới loŏh pỡq chíl tâng máh dũal cớp cóh, cớp alới pai neq: “Sanua hái pruam chơ ễ pỡq chu ntốq Yiang Sursĩ khoiq sadoi yỗn hái. Tỗp hái ngin kho samoât lứq hái khoiq táq lôih chơ.” ");
INSERT INTO bru_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ma Môi-se atỡng neq: “Khân ngkíq, cỗ nŏ́q anhia tỡ bữn tamứng Yiang Sursĩ? Anhia tỡ riap mŏ! ");
INSERT INTO bru_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Chỗi pỡq! Yuaq Yiang Sursĩ tỡ bữn ỡt cớp anhia. Lứq anhia pê chóq cũai par‑ũal anhia. ");
INSERT INTO bru_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Toâq anhia ramóh cũai A-maléc cớp cũai Cana-an, anhia lứq cuchĩt nheq tâng ntốq rachíl ki, yuaq Yiang Sursĩ tỡ bữn ỡt nứng anhia, cỗ tian anhia tỡ bữn trĩh án.” ");
INSERT INTO bru_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ma alới tỡ bữn tamứng, chỗn clốq chu máh dũal cớp cóh; ma Hĩp Parnai Parkhán cớp Môi-se noâng ỡt tâng ntốq alới ỡt. ");
INSERT INTO bru_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Chơ tỗp A-maléc cớp tỗp Cana-an ỡt tâng ntốq ki chíl loah tỗp alới, cớp rapuai tỗp alới toau cỡt pê, cớp alới cuchĩt nheq pỡ vil Hor-ma. ");
INSERT INTO bru_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yiang Sursĩ atỡng Môi-se tễ ");
INSERT INTO bru_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","máh phễp rit cũai proai I-sarel cóq trĩh toâq alới ỡt tâng cutễq Yiang Sursĩ ễ chiau yỗn tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Khân cũai aléq ma ễ chiau sang muoi lám ntroŏq tangcáh, cữu tôl, tỡ la mbễq dŏq cỡt crơng chiau sang yỗn Yiang Sursĩ puai tâng rit bốh charán, tỡ la chiau sang cỗ khoiq parkhán dŏq, tỡ la chiau sang tam pahỡm sâng yoc, tỡ la chiau sang tâng tangái táq rit cha bũi puai tâng rit, chơ hỡi phuom tễ crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Khân cũai aléq dững cữu tỡ la mbễq dŏq bốh chiau sang yỗn Yiang Sursĩ, cóq án dững dếh bỗt muoi ki-lô talốc cớp dỡq nsễng o‑li‑vê muoi lit, ");
INSERT INTO bru_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","puai tâng rit chiau sang máh thữ racáu, cớp blŏ́ng nho muoi lit. ");
INSERT INTO bru_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Toâq chiau sang muoi lám cữu tôl, cóq noau dững crơng chiau sang dếh bỗt o bar ki-lô talốc cớp dỡq nsễng o‑li‑vê tadĩ lit, ");
INSERT INTO bru_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","cớp blŏ́ng nho tadĩ lit. Hỡi phuom chanchức tễ máh crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Toâq noau chiau sang bốh muoi lám ntroŏq tangcáh yỗn Yiang Sursĩ puai tâng rit chiau sang, tỡ la chiau sang cỗ tễ ranáq parkhán dŏq, tỡ la ễq yỗn cỡt ratoi, ");
INSERT INTO bru_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","cóq noau dững máh crơng chiau sang dếh bỗt o pái ki-lô talốc cớp dỡq nsễng o‑li‑vê bar lit, ");
INSERT INTO bru_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","cớp blŏ́ng nho bar lit. Hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Cóq noau táq nneq toâq chiau sang ntroŏq tangcáh, cữu tôl, cữu tôl con, tỡ la mbễq dũ lám. ");
INSERT INTO bru_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Bo léq ma noau chiau sang hỡn tễ muoi lám charán, cóq noau tữm ễn máh crơng chiau sang parnơi cớp tỗ charán. ");
INSERT INTO bru_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Dũ náq canỡt tễ tỗp I-sarel cóq táq puai phễp rit nâi toâq alới dững crơng chiau sang; chơ hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Cớp máh cũai tễ cruang canŏ́h ca ỡt cớp anhia, tỡ bữn pai alới ỡt dỡ tỡ la ỡt loâng, khân alới yoc ễ bốh crơng chiau sang, cóq alới táq puai phễp rit nâi tê. Hỡi phuom chanchức tễ crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Alới cóq táq puai dũ phễp rit parnơi cớp anhia tê, tễ sanua toau toâq sốt dỡi lơi cumo mantái níc. Anhia cớp alới la machớng nheq yáng moat Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Máh phễp rit nâi la machớng yỗn anhia cớp cũai tễ cruang canŏ́h ỡt cớp anhia. ");
INSERT INTO bru_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yiang Sursĩ chiau phễp rit nâi yỗn Môi-se, ");
INSERT INTO bru_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","dŏq án atỡng cũai proai I-sarel yỗn táq puai toâq alới bữn ỡt tâng cutễq Yiang Sursĩ ễ chiau yỗn alới ndỡm. ");
INSERT INTO bru_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Toâq bữn cha palâi tễ dũ ramứh sarnóh tâng cutễq ki, cóq anhia tampễq dŏq cỡt crơng mpon yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Toâq anhia táq bễng mi tễ máh sarnóh anhia ĩt trỗ dâu, cóq anhia ĩt bễng mi lám dâu lứq dŏq cỡt crơng mpon yỗn Yiang Sursĩ, machớng anhia chiau sang máh thữ racáu púh trỗ dâu tê. ");
INSERT INTO bru_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Cóq anhia chiau sang bễng mi anhia táq cỡt crơng mpon yỗn Yiang Sursĩ, toau sốt dũ dỡi cũai mantái níc. ");
INSERT INTO bru_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ma khân bữn manoaq ma lơ tỡ bữn táq puai máh ŏ́c Yiang Sursĩ atỡng na Môi-se, ");
INSERT INTO bru_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tỡ la chumát máh cũai clứng nâi tỡ ễq trĩh tê santoiq Yiang Sursĩ atỡng na Môi-se, ");
INSERT INTO bru_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","cớp khân ŏ́c nâi lứq cỡt cỗ alới tỡ bữn dáng samoât, ki cóq alới dững muoi lám ntroŏq tangcáh dŏq táq rit bốh chiau sang parnơi cớp máh thữ racáu o, cớp blŏ́ng nho hỡ. Hỡi phuom chanchức tễ máh crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. Hỡn tễ ki ễn, alới cóq chiau sang muoi lám mbễq tangcáh dŏq táq rit pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Cũai tễng rit sang cóq táq rit dŏq pupứt lôih yỗn máh cũai proai, ki nŏ́q Yiang Sursĩ táh lôih yỗn tỗp alới, cỗ tian alới táq lơ sang, ma tỡ bữn yoc ễ táq; cớp alới khoiq dững crơng chiau sang dŏq yỗn Yiang Sursĩ táh lôih yỗn alới, puai tâng rit bốh crơng chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Chơ dũ náq cũai proai I-sarel, dếh cũai tễ cruang canŏ́h, nheq tữh alới bữn vớt tễ ŏ́c lôih, yuaq dũ náq alới cỡt lôih machớng nheq, cỗ táq lơ sâng. ");
INSERT INTO bru_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Khân bữn manoaq táq lôih ma án táq lơ sâng, cóq án dững muoi lám mbễq sang‑ỗng bỡiq muoi cumo, dŏq táq rit pupứt lôih. ");
INSERT INTO bru_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Cũai tễng rit sang cóq táq rit pupứt lôih yỗn án pỡ prông sang; chơ Yiang Sursĩ táh lôih yỗn án. ");
INSERT INTO bru_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Dũ náq cũai táq lôih ma táq lơ sâng cóq táq puai phễp rit nâi, tỡ bữn ống cũai I-sarel canỡt tâng cruang ki, ma dếh cũai tễ cruang canŏ́h ỡt parnơi cớp alới. ");
INSERT INTO bru_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Khân bữn cũai aléq, tam cũai I-sarel canỡt tâng cruang ki, tỡ la cũai tễ cruang canŏ́h ỡt parnơi cớp alới, ma táq lôih na acrieiq asáh ramứh Yiang Sursĩ, cóq án chĩuq tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Cỗ tian án palữi Yiang Sursĩ cớp táq claiq phễp rit Yiang Sursĩ patâp, ngkíq án cóq chĩuq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Bữn muoi trỗ, bo tỗp I-sarel noâng ỡt tâng ntốq aiq, ma bữn manoaq samiang táq claiq rit Tangái Rlu cỗ án pỡq chuaq ũih. ");
INSERT INTO bru_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Cũai ca tamóh án dỗl ũih dững án toâq pỡ Môi-se, Arôn, cớp máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Chơ Môi-se ớn noau kháng án tâng cuaq tũ, yuaq tỡ dáng ễ táq nŏ́q chóq án. ");
INSERT INTO bru_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Moâm ki Yiang Sursĩ atỡng Môi-se neq: “Cũai samiang nâi cóq cuchĩt na nheq tữh cũai tám tamáu chóq án yáng tiah vil.” ");
INSERT INTO bru_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Yuaq ngkíq, máh cũai dững aloŏh án yáng tiah vil; chơ alới tám tamáu chóq án toau cuchĩt machớng Yiang Sursĩ khoiq atỡng alới. ");
INSERT INTO bru_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","atỡng cũai proai I-sarel neq: “Cóq táq rampóh tâng chễu au, cớp chŏ́q toâq cansái santứm satong. Cóq dũ thrap cũai táq puai níc rit nâi. ");
INSERT INTO bru_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Rampóh ki cỡt tếc dŏq anhoac mứt pahỡm anhia; cớp dũ trỗ anhia hữm rampóh ki, án chuai yỗn anhia sanhữ loah cớp trĩh máh ŏ́c cứq patâp. Cớp anhia tỡ bữn nguai tễ cứq cớp pỡq táq tam mứt anhia yoc. ");
INSERT INTO bru_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Máh rampóh ki anhoac anhia yỗn rabán o máh ŏ́c cứq patâp; chơ anhia cỡt khong cứq samoât samơi. ");
INSERT INTO bru_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Cứq la Yiang Sursĩ, Ncháu anhia. Cứq khoiq dững aloŏh anhia tễ cruang Ê-yip-tô dŏq cứq cỡt Yiang Sursĩ anhia. Cứq toâp la Yiang Sursĩ!” ");
INSERT INTO bru_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Cô-ra la con samiang I-sar, tỗp Lê-vi, sâu Cô-hat, án chíl loah Môi-se. Cớp bữn pái náq cũai tễ tỗp Ruben ramứh neq: Dathan cớp Abi-ram máh con samiang E-liap, cớp Ôn con samiang Palet, ");
INSERT INTO bru_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","alới pruam cớp Cô-ra. Cớp bữn cũai sốt bar culám sỡng chít náq bữn ramứh parchia parhan lứq tâng mpứng dĩ cũai proai, alới rachuai tỗp Cô-ra hỡ. ");
INSERT INTO bru_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Tỗp alới toâq rôm parnơi yáng moat Môi-se cớp Arôn, cớp tếq pai neq: “Anhia táq khoiq luat ngư chơ! Nheq tữh cũai nâi cỡt khong Yiang Sursĩ, cớp Yiang Sursĩ ỡt cớp tỗp alới dũ náq. Cỗ nŏ́q anhia ma achỗn tỗ bữm ngkíq?” ");
INSERT INTO bru_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Toâq Môi-se sâng santoiq ki, án pũp mieiq tớt cutễq cớp câu chu Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Chơ Môi-se atỡng Cô-ra cớp tỗp Cô-ra neq: “Tâng tarưp parnỡ Yiang Sursĩ ễ sapáh yỗn hái dáng cũai aléq lứq cỡt khong Yiang Sursĩ. Yiang Sursĩ ễ yỗn cũai ki toâq cheq pỡ án; cũai án rưoh têq sĩc amut cheq prông sang. ");
INSERT INTO bru_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Tarưp parnỡ cóq mới cớp tỗp mới ĩt adéh atháh cớp chóq ra‑ớh ũih, yữi chóq crơng phuom, chơ dững pỡ prông sang. Ngkíq tỗp hái dũ náq têq dáng samoât, noau toâp Yiang Sursĩ rưoh tễ tỗp hái. Lứq anhia tỗp proai Lê-vi toâp táq luat ngư!” ");
INSERT INTO bru_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Môi-se atỡng Cô-ra ễn neq: “Tỗp Lê-vi ơi! Anhia tamứng yỗn samoât nơ! ");
INSERT INTO bru_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Nŏ́q anhia chanchớm ranáq nâi cacớt sâng? Lứq Yiang Sursĩ, án ca cũai proai I-sarel sang, án khoiq chóh tỗp anhia miar tễ tỗp canŏ́h, la dŏq anhia ỡt cheq án, cớp táq máh rit tâng Dống Sang Aroâiq, dếh rachuai ranáq máh cũai proai hỡ. ");
INSERT INTO bru_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Án khoiq yỗn tỗp anhia cớp máh cũai Lê-vi canŏ́h bữn roap mpỗl ki. Ma sanua, anhia ntôm ễ roap mpỗl cỡt cũai tễng rit sang hỡ. ");
INSERT INTO bru_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Bo anhia bubéq-bubưp chóq Arôn, la machớng anhia bubéq-bubưp chóq Yiang Sursĩ tê. Ngkíq yuaq anhia ntôm ễ chíl loah sanua.” ");
INSERT INTO bru_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Vớt ki, Môi-se ớn noau pỡq arô Dathan cớp Abi-ram con samiang E-liap toâq ramóh án. Ma alới pai neq: “Hếq tỡ ễq pỡq! ");
INSERT INTO bru_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Achuaih khoiq dững aloŏh hếq tễ cutễq phốn phuor pỡ cruang Ê-yip-tô, cỗ ễq hếq cuchĩt pỡ ntốq aiq nâi. Ŏ́c ki noâng tỡ bữn dũ sĩa tỡ? Nŏ́q sanua achuaih noâng yoc ễ cỡt sốt tỗp hếq ễn tỡ? ");
INSERT INTO bru_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Achuaih tỡ bữn dững tỗp hếq mut pỡ cutễq phốn phuor ca bữn dũ ramứh ki, tỡ la chiau sarái, tỡ la nưong nho yỗn máh tỗp hếq bữn ndỡm. Ma sanua achuaih noâng ễ phếq thũ hếq sĩa. Tỗp hếq tỡ ễq pỡq mŏ!” ");
INSERT INTO bru_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Chơ Môi-se sâng nsóq lứq, cớp pai neq chóq Yiang Sursĩ: “Sễq anhia chỗi roap máh crơng tỗp nâi dững chiau sang. Cứq tỡ bữn táq lôih ntrớu chóq alới, dếh muoi lám aséh dễn la cứq tỡ nai ĩt tễ tỗp alới.” ");
INSERT INTO bru_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Môi-se pai chóq Cô-ra neq: “Tangái parnỡ tỗp anhia bar culám sỡng chít náq cóq toâq pỡ Dống Sang Aroâiq; Arôn cóq pỡq pỡ ki tê. ");
INSERT INTO bru_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Dũ náq anhia cóq dững adéh atháh, cớp chóq ra‑ớh ũih tâng ki, yữi chóq crơng phuom tâng pỡng, chơ dững pỡ prông chiau sang.” ");
INSERT INTO bru_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Yuaq ngkíq, dũ náq ma dững adéh atháh, cớp chóq ra‑ớh ũih, dếh yữi chóq crơng phuom tâng pỡng, chơ dững. Cớp alới ỡt tayứng cheq ngoah toong mut Dống Sang Aroâiq, bữn dếh Môi-se cớp Arôn. ");
INSERT INTO bru_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Chơ Cô-ra parỗm máh cũai án ỡt tayứng yáng moat Môi-se cớp Arôn, choâng toong mut chu Dống Sang Aroâiq. Bo ki toâp, bữn tráh ang tễ Yiang Sursĩ sapáh yỗn nheq tữh cũai proai hữm. ");
INSERT INTO bru_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Chơ Yiang Sursĩ atỡng Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Cóq anhia dễq yơng tễ máh cũai proai nâi; yuaq sanua nâi toâp cứq ễ pupứt nheq tỗp alới!” ");
INSERT INTO bru_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ma Môi-se cớp Arôn pũp crap tớt cutễq cớp pai neq: “Ơ Yiang Sursĩ ơi! Anhia la Yiang ca yỗn nheq tữh cũai bữn tamoong. Toâq manoaq táq lôih, nŏ́q anhia ũan chóq dũ náq cũai?” ");
INSERT INTO bru_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yiang Sursĩ ta‑ỡi Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Cóq mới atỡng máh cũai proai yỗn dễq sanua toâp tễ dống aroâiq khong Cô-ra, Dathan, cớp Abi-ram.” ");
INSERT INTO bru_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Chơ Môi-se cớp máh cũai sốt canŏ́h tâng tỗp I-sarel pỡq ramóh Dathan cớp Abi-ram. ");
INSERT INTO bru_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Án atỡng máh cũai proai neq: “Cóq anhia dễq yơng tễ dống aroâiq máh cũai sâuq nâi, cớp chỗi satoaq muoi ramứh ntrớu crơng alới. Khân tỡ bữn ngkíq, anhia lứq cỡt sarbiet tê, cỗ tian ŏ́c lôih alới.” ");
INSERT INTO bru_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Yuaq ngkíq, máh cũai proai ma dễq nheq tễ dống aroâiq Cô-ra, Dathan, cớp Abi-ram. Dathan cớp Abi-ram, dếh con lacuoi alới loŏh tayứng yáng moat dống aroâiq khong alới bữm. ");
INSERT INTO bru_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Chơ Môi-se pai chóq cũai proai neq: “Na ŏ́c nâi, anhia têq dáng samoât samơi Yiang Sursĩ toâp ớn cứq táq máh ranáq nâi, cứq tỡ bữn rưoh bữm. ");
INSERT INTO bru_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Khân máh cũai nâi ma chống cuchĩt ariang cũai canŏ́h, cớp Yiang Sursĩ tỡ bữn yỗn alới roap tôt ntrớu, ki Yiang Sursĩ tỡ bữn ớn cứq toâq. ");
INSERT INTO bru_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ma khân Yiang Sursĩ yỗn alới roap tôt na ranáq salễh alới tỡ cơi hữm, ki cốc cutễq nâi lứq lưn alới, lưn dếh máh crơng alới hỡ, dŏq yỗn alới pỡq chu ntốq cũai cuchĩt ỡt, toâq ki nŏ́q anhia dáng samoât máh cũai tỗp nâi khoiq táh Yiang Sursĩ chơ.” ");
INSERT INTO bru_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Tữ Môi-se atỡng moâm nheq máh santoiq ki, tâng ntốq Dathan cớp Abi-ram ỡt tayứng, cutễq ki phang. ");
INSERT INTO bru_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Cớp cutễq caha, chơ lưn alới cớp dống sũ alới, dếh Cô-ra cớp cũai puai án, dếh crơng alới hỡ. ");
INSERT INTO bru_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ngkíq alới sễng mumoong pỡ ntốq cũai cuchĩt ỡt, dếh crơng alới hỡ. Chơ alới pứt muoi taláp; bữn cutễq cubớl alới. ");
INSERT INTO bru_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Cũai proai I-sarel dũ náq ỡt bân ntốq ki miar mprieih lúh toâq alới sâng sưong nheq tữh cũai ki hễr. Máh cũai proai la hễr lalal tê neq: “Lúh chái chái! Cutễq caha ễ lưn tỗp hái machớng alới ki tê!” ");
INSERT INTO bru_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Chơ Yiang Sursĩ apŏ́ng ũih yỗn cat nheq cũai bar culám sỡng chít náq ca chiau sang crơng phuom. ");
INSERT INTO bru_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Moâm ki Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Cóq mới atỡng E-lia-sơ con samiang Arôn, la cũai tễng rit sang, yỗn án ĩt ra‑ớh ũih tễ adéh atháh sapoan tễ cũai cat ũih ki; chơ dững takễl chu ntốq canŏ́h, yuaq adéh atháh ki cỡt adéh dŏq táq rit tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Adéh atháh ki cỡt ngkíq la cỗ tian noau dững crơng chiau sang yỗn Yiang Sursĩ pỡ prông sang. Cóq mới ĩt adéh atháh tễ cũai khoiq cuchĩt cỗ tian ŏ́c lôih alới táq. Chơ dững dễr yỗn cỡt khlễc cada, ien cutrúq prông sang, dŏq catoaih mứt pahỡm máh proai I-sarel, yuaq tễ nhũang adéh ki khoiq noau chiau dŏq cỡt crơng miar khong Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Yuaq ngkíq, E-lia-sơ, la cũai tễng rit sang, ma ĩt adéh atháh ki, chơ dễr cỡt khlễc cada, dŏq cutrúq prông sang. ");
INSERT INTO bru_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Khlễc ki cỡt tếc catoaih máh cũai proai I-sarel neq: Chỗi yỗn cũai aléq tarôq cheq khân tỡ cỡn con châu Arôn, toâq chŏ́ng crơng phuom chiau sang yỗn Yiang Sursĩ. Khân tỡ bữn ngkíq, alới lứq tamóh ŏ́c cuchĩt pứt machớng cớp Cô-ra dếh máh tỗp án.” E-lia-sơ táq puai dũ ramứh ĩn Yiang Sursĩ atỡng na Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Toâq tangái ntun ễn, nheq tữh cũai proai bubéq-bubưp chóq Môi-se cớp Arôn neq: “Achuaih khoiq táq yỗn muoi tỗp cũai proai Yiang Sursĩ cuchĩt chơ.” ");
INSERT INTO bru_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Vớt alới parỗm parnơi dŏq ễ pai Môi-se cớp Arôn, chơ dũ náq alới píh nhêng chu Dống Sang Aroâiq. Alới hữm poang tráh tễ Yiang Sursĩ sapáh yỗn alới. ");
INSERT INTO bru_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Môi-se cớp Arôn loŏh tayứng yáng moat Dống Sang Aroâiq, ");
INSERT INTO bru_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","cớp Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Cóq mới carlũn ỡt yơng tễ máh tỗp cũai nâi, yuaq cứq ễ cachĩt táh nheq tỗp alới bân ntốq alới ỡt sanua toâp.” Alới bar náq miar pũp mieiq asễng tớt cutễq, ");
INSERT INTO bru_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","chơ Môi-se atỡng Arôn neq: “Cóq mới ĩt adéh atháh, chơ chóq ra‑ớh ũih tễ prông sang, cớp ĩt crơng phuom yữi chóq tâng pỡng. Âu! Mới táq chái, dŏq táq rit pupứt lôih yỗn máh cũai proai, yuaq Yiang Sursĩ sâng cutâu lứq cớp táq yỗn ỗn toâq chơ.” ");
INSERT INTO bru_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Arôn táq puai Môi-se ớn, án ĩt adéh atháh bữn ra‑ớh noâng blữ; án lúh dững pỡ mpứng dĩ máh cũai proai. Toâq án hữm ỗn ntôm tớt pỡ cũai, án ĩt crơng phuom yữi chóq tâng rahững ũih, dŏq táq rit pupứt lôih yỗn máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Arôn tayứng tâng mpứng dĩ cũai tamoong cớp cũai cuchĩt, chơ ỗn ki tangứt. ");
INSERT INTO bru_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Thrỗq cũai cuchĩt la 14,700 náq, ma tỡ bữn noap dếh alới ca khoiq cuchĩt cỗ tian ranáq Cô-ra. ");
INSERT INTO bru_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Toâq ỗn ki tangứt chơ, Arôn píh loah pỡ Môi-se bân ngoah toong mut chu Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Atỡng cũai proai I-sarel cóq alới dững yỗn pỡ mới muoi chít la bar ntreh ralỡng, muoi noaq muoi ntreh tễ alới ca sốt máh tỗp cũai I-sarel. Cóq mới chĩc ramứh máh cũai sốt tâng dũ ntreh ralỡng ki. ");
INSERT INTO bru_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Chơ chĩc ramứh Arôn chóq tâng pỡng ralỡng tỗp Lê-vi. Máh cũai sốt dũ tỗp cóq bữn ralỡng manoaq muoi ntreh. ");
INSERT INTO bru_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Cóq mới dững máh ralỡng ki pỡ Dống Sang Aroâiq, chơ achúh ralỡng dŏq yáng moat Hĩp Parnai Parkhán bân ntốq cứq dốq ramóh mới. ");
INSERT INTO bru_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Chơ ralỡng khong cũai cứq rưoh, ki án cỡt piar. Na ranáq nâi táq yỗn cũai proai I-sarel tỡ bữn bubéq-bubưp noâng chóq mới.” ");
INSERT INTO bru_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Chơ Môi-se atỡng máh cũai proai I-sarel, máh cũai sốt tâng cu tỗp yỗn alới dững ralỡng manoaq muoi ntreh. Nheq tữh ralỡng ki la muoi chít la bar ntreh, noap dếh ralỡng Arôn. ");
INSERT INTO bru_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Môi-se ĩt máh ralỡng ki dững dŏq tâng Dống Sang Aroâiq, choâng moat Hĩp Parnai Parkhán. ");
INSERT INTO bru_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Toâq tangái parnỡ, Môi-se mut chu ntốq ki, án hữm ralỡng khong Arôn, la cũai tễ tỗp Lê-vi, padốh, amỗm, cháh, cớp bữn palâi al-mon khoiq chĩn. ");
INSERT INTO bru_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Môi-se ĩt máh ralỡng ki dững aloŏh yỗn cũai proai I-sarel nhêng. Tỗp alới hữm máh ranáq cỡt; chơ máh cũai sốt tễ dũ tỗp roap ĩt loah ralỡng alới. ");
INSERT INTO bru_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yiang Sursĩ atỡng Môi-se neq: “Ĩt ralỡng Arôn, chơ achúh dŏq yáng moat Hĩp Parnai Parkhán, dŏq cỡt tếc catoaih anhoac mứt pahỡm máh cũai proai I-sarel ca bữn mứt ễ lớn-sarlớn, khân alới tỡ bữn tangứt loai bubéq-bubưp alới cóq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Môi-se táq puai ariang santoiq Yiang Sursĩ khoiq ớn án dũ ŏ́c. ");
INSERT INTO bru_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Cũai proai I-sarel pai chóq Môi-se neq: “Khân ngkíq, tỗp hếq khoiq toâq ngư parsốt chơ! ");
INSERT INTO bru_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Khân cũai aléq ma mut cheq Dống Sang Aroâiq cóq cuchĩt, ki nheq tữh tỗp hái cóq cuchĩt nơ.” ");
INSERT INTO bru_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yiang Sursĩ atỡng Arôn neq: “Mới cớp máh con samiang mới, dếh nheq tữh cũai Lê-vi, nheq náq anhia bữn roap tôt tễ ranáq lôih anhia táq tâng Dống Sang Aroâiq. Ma ống mới cớp máh con samiang mới sâng cóq roap tôt tễ ranáq lôih máh cũai tễng rit sang táq. ");
INSERT INTO bru_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Cóq mới dững máh sễm ai mới tễ tỗp Lê-vi toâq chuai ranáq mới, toâq anhia mut táq ranáq cứq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Cóq alới táq ranáq rachuai mới, cớp nhêng salĩq nheq máh ranáq tâng Dống Sang Aroâiq; ma tỡ yỗn alới mut cheq crơng dŏq táq rit sang bân Ntốq Tễng Rit, tỡ la prông sang. Khân alới mŏ táq clốq, alới cớp mới cóq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Tỗp alới cóq táq ranáq parnơi cớp mới, cớp nhêng salĩq dũ ranáq tâng Dống Sang Aroâiq. Ma mới chỗi ĩt cũai tỡ bữn bữn mpỗl dŏq táq ranáq cớp mới. ");
INSERT INTO bru_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ống mới cớp tỗp con samiang mới sâng roap mpỗl tễ ranáq tâng Ntốq Tễng Rit cớp ntốq prông sang. Cóq táq ngkíq yỗn ŏ́c cutâu cứq tỡ bữn toâq noâng pỡ cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Lứq cứq toâp rưoh sễm ai mới la cũai Lê-vi tễ máh tỗp cũai I-sarel, dŏq alới cỡt ariang crơng mpon yỗn mới. Cóq mới chiau sang tỗp alới yỗn cứq, dŏq tỗp alới têq táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ma ống mới cớp máh con samiang mới sâng têq cỡt cũai tễng rit sang dŏq táq dũ ranáq bân ntốq prông sang cớp Ntốq Tễng Rit. Máh ranáq nâi la mpỗl mới cóq nhêng salĩq, yuaq cứq chiau chớc cứq yỗn mới cỡt cũai tễng rit sang. Cũai ca tỡ bữn mpỗl, tỡ têq mut cheq Ntốq Tễng Rit ki. Khân án mut cheq, ki án cóq roap tôt cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yiang Sursĩ atỡng Arôn neq: “Cứq toâp yỗn mới nhêng salĩq máh crơng noau dững chiau sang yỗn cứq. Nheq tữh crơng máh cũai I-sarel dững chiau sang yỗn cứq, cứq chiau loah máh crơng ki yỗn cỡt pún mới cớp tŏ́ng toiq mới mantái níc. ");
INSERT INTO bru_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Máh crơng noau chiau sang yỗn cứq, ma tỡ bữn bốh tâng prông sang, crơng ki cỡt khong mới la neq: Máh thữ racáu, crơng sang dŏq táq rit pupứt lôih, cớp máh crơng chiau sang dŏq pláih loah lôih. Dũ ramứh chiau sang cỡt khong mới cớp máh con samiang mới. ");
INSERT INTO bru_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Tỗp anhia cóq cha ramứh nâi pỡ ntốq miar, cớp bữn ống cũai samiang sâng têq cha máh crơng ki. Cóq anhia chanchớm crơng ki la lứq cỡt miar yỗn cứq. ");
INSERT INTO bru_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Ma noâng bữn crơng cũai proai I-sarel dững chiau sang yỗn cứq la cỡt khong mới tê. Cứq chiau crơng ki yỗn cỡt khong mới, con samiang cớp con mansễm mới dũ dỡi. Máh cũai dống sũ mới ca bráh puai rit têq cha máh crơng chiau sang ki. ");
INSERT INTO bru_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Cứq chiau yỗn mới máh palâi sarnóh o ca cũai proai I-sarel ĩt dâu lứq, chơ dững chiau sang yỗn cứq, la neq: Dỡq nsễng o‑li‑vê, blŏ́ng nho, cớp máh thữ racáu hỡ. ");
INSERT INTO bru_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Nheq tữh ramứh ĩt dâu lứq cỡt khong mới, cớp dũ náq cũai ỡt tâng dống sũ mới, têq alới cha máh crơng ki, khân alới bráh puai rit. ");
INSERT INTO bru_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Dũ ramứh tâng cruang I-sarel noau chiau sang yỗn cứq, crơng ki lứq cỡt khong mới. ");
INSERT INTO bru_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Con samiang clúng cũai I-sarel, cớp charán pốh dâu, ca noau dững chiau sang yỗn cứq, la cỡt khong mới tê. Ma cóq anhia thái loah máh con clúng anhia, tỡ la charán pốh dâu ca tỡ bữn bráh puai rit, cóq anhia thái loah. ");
INSERT INTO bru_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Nheq tữh cũai carnễn tễ muoi casâi achỗn cóq thái loah toâq sỡng ŏ́c práq, puai kia khoiq anoat dŏq tâng dống sang. ");
INSERT INTO bru_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ma máh ntroŏq, cữu, cớp mbễq pốh dâu, anhia tỡ têq thái loah. Máh charán ki lứq samoât cỡt khong cứq, cớp cóq anhia kiac sang yỗn cứq. Cóq tốh aham tâng prông sang, cớp bốh nsễng ki táq puai tâng rit chiau sang crơng sana yỗn cứq. Hỡi phuom chanchức tễ crơng sana ki táq yỗn cứq bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ma sâiq ki cỡt khong mới, machớng cớp sâiq apơm cớp sâiq nlu coah atoam ca noau apỗng chiau sang cỡt crơng mpon yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Máh crơng cũai proai I-sarel dững sang yỗn cứq, ki cỡt khong mới cớp tỗp con samiang con mansễm mới dũ dỡi. Ŏ́c parkhán nâi cứq tỡ bữn ralêq noâng.” ");
INSERT INTO bru_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Chơ Yiang Sursĩ atỡng Arôn neq: “Anhia tỡ bữn roap crơng ntrớu dŏq cỡt mun, cớp anhia ŏ́q pún tễ cutễq tâng cruang I-sarel. Cứq la Yiang Sursĩ cỡt mun anhia cớp cỡt túc ramứh anhia ễ bữn.” ");
INSERT INTO bru_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Yiang Sursĩ pai neq: “Cứq khoiq chiau chơ yỗn tỗp Lê-vi pún muoi chít tễ máh crơng proai I-sarel dững chiau sang yỗn cứq. Ŏ́c nâi la culáh loah cóng alới nhêng salĩq Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ma máh cũai proai I-sarel canŏ́h, ki tỡ têq mut cheq Dống Sang Aroâiq. Khân alới mut, alới cóq roap tôt cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Tễ nâi chumát, ống tỗp Lê-vi sâng têq mut nhêng salĩq Dống Sang Aroâiq. Cóq alới bán curiaq samoât samơi ntốq ki. Nâi la phễp rit yỗn tŏ́ng toiq anhia táq puai níc. Máh cũai Lê-vi tỡ bữn bữn mun ntrớu tâng cruang I-sarel, ");
INSERT INTO bru_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","yuaq cứq khoiq chiau yỗn alới pún muoi chít ca cũai proai I-sarel dững chiau sang yỗn cứq dŏq cỡt khong tỗp alới. Yuaq ngkíq, cứq patâp anhia neq: ‘Tỗp alới tỡ bữn bữn mun ntrớu tâng cruang I-sarel.’” ");
INSERT INTO bru_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","atỡng tỗp Lê-vi neq: “Toâq anhia bữn roap pún muoi chít tễ Yiang Sursĩ ca cũai proai I-sarel dững chiau sang yỗn án, cóq anhia chiau sang loah muoi pún tễ máh crơng ki yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Máh pún rachuai miar nâi la noap machớng saro tamái, cớp blŏ́ng nho tamái riang cũai táq sarái tỡ la nưong dững chiau sang tê. ");
INSERT INTO bru_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Machớng nâi tê, cóq anhia chiau sang pún miar khong Yiang Sursĩ, tễ pún muoi chít anhia bữn roap tễ cũai proai I-sarel. Cóq anhia chiau máh pún miar ki pỡ Arôn, la cũai tễng rit sang. ");
INSERT INTO bru_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Cóq anhia ĩt pún o lứq chiau sang loah yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Toâq anhia chiau sang chơ máh crơng o lứq, anhia têq dŏq máh pún noâng clữi, machớng cũai táq nưong dŏq crơng clữi moâm án dững chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Anhia cớp nheq náq tâng dống sũ anhia têq dững crơng ki cha pỡq ntốq canŏ́h. Nâi la cóng anhia táq ranáq tâng Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Trỗ léq anhia dững crơng o lứq dŏq sang yỗn Yiang Sursĩ, tỗp anhia tỡ bữn lôih toâq anhia cha pún anhia bữn roap. Ma chỗi táq yỗn máh crơng cũai I-sarel dững chiau sang yỗn Yiang Sursĩ cỡt tỡ bữn bráh puai rit yuaq anhia cha nhũang crơng o máh alới dững sang. Khân anhia táq clốq, ki anhia roap tôt cóq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Chơ Yiang Sursĩ ớn Môi-se cớp Arôn ");
INSERT INTO bru_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","chiau phễp rit nâi yỗn máh cũai I-sarel. Cóq alới dững ntroŏq sang‑ỗng cusâu ca tỡ nai táq ranáq cớp ŏ́q bân tĩq, ");
INSERT INTO bru_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","dững yỗn E-lia-sơ, la cũai tễng rit sang. Cóq noau dững ntroŏq ki yáng tiah vil, chơ kiac yáng moat E-lia-sơ. ");
INSERT INTO bru_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Chơ E-lia-sơ cóq ĩt muoi pún aham, cớp alốq ndễm atĩ tâng aham ki; moâm ki trutrếh tapul trỗ chu Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Cóq alới bốh charán ki yáng moat cũai tễng rit sang, bốh dếh ngcâr, sâiq, aham, cớp máh crơng clống. ");
INSERT INTO bru_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Chơ cóq án ĩt aluang sê-da, muoi boq sala hi‑sớp, cớp muoi ntreh priei cusâu, chơ apŏ́ng crơng ki tâng ũih. ");
INSERT INTO bru_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Moâm ki, cóq án pooh tampâc cớp mpơi dỡq yỗn cỡt bráh puai rit; ki nŏ́q yỗn án mut chu vil. Ma án noâng tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Cớp samiang ca bốh ntroŏq ki, cóq án pooh tampâc, cớp mpơi dỡq yỗn tỗ chác cỡt bráh machớng ki tê. Ma án noâng tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Chơ cóq manoaq samiang bráh puai rit parỗm bŏ́h ntroŏq sang‑ỗng ki; chơ dững dŏq tâng ntốq bráh puai rit yáng tiah vil, ien cũai proai I-sarel ĩt dỡq, dŏq ariau yỗn pứt lôih puai tâng rit. ");
INSERT INTO bru_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Samiang ca parỗm bŏ́h, cóq án pooh tampâc, ma án noâng tỡ bữn bráh puai rit toau toâq sadâu. Máh cũai I-sarel tỡ la cũai cruang canŏ́h ỡt cớp cũai I-sarel, cóq alới táq puai máh phễp rit ki mantái níc. ");
INSERT INTO bru_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Khân bữn cũai ma yống satoaq sac cumuiq, cũai ki cỡt tỡ bữn bráh puai rit tâng tapul tangái. ");
INSERT INTO bru_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Tâng tangái pái cớp tangái tapul, cóq án táq yỗn bráh tỗ chác án na dỡq bráh puai rit. Ma khân án tỡ bữn ariau tâng tangái pái cớp tangái tapul, án tỡ bữn cỡt bráh yũah. ");
INSERT INTO bru_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Khân cũai aléq satoaq sac cumuiq, ma tỡ bữn ariau tỗ chác, án cỡt tỡ bữn bráh yũah, cỗ án tỡ bữn ĩt dỡq dŏq táq bráh puai rit. Nâi la machớng án ayê ra‑ac Dống Sang Aroâiq Yiang Sursĩ; cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Khân bữn cũai ma cuchĩt tâng dống aroâiq, cũai aléq ỡt tâng dống aroâiq tỡ la mut tâng dống ki, án cỡt tỡ bữn bráh tapul tangái puai tâng rit. ");
INSERT INTO bru_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Khang cớp adéh dũ lám ŏ́q cantứp tâng dống ki, la cỡt tỡ bữn bráh tê. ");
INSERT INTO bru_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Khân bữn cũai aléq ma satoaq sac cũai cachĩt, tỡ la chống ễ cuchĩt yáng tiah dống aroâiq, ma bữn muoi noaq toâq satoaq nghang cumuiq ki, án cỡt tỡ bữn bráh nheq tapul tangái tê. ");
INSERT INTO bru_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Dŏq sambráh cũai tỡ bữn bráh puai rit, cóq ĩt bŏ́h ca bốh ntroŏq sang‑ỗng cusâu, chóq bŏ́h ki tâng tangan, chơ talốc cớp dỡq miat. ");
INSERT INTO bru_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Chơ cóq cũai canŏ́h bráh puai rit ĩt muoi boq sala aluang hi‑sớp, alốq tâng dỡq, chơ trutrếh chóq dống aroâiq, chóq dũ ramứh tâng dống ki, cớp chóq máh cũai tâng dống aroâiq ki hỡ. Ntun ễn, cóq cũai bráh puai rit ĩt dỡq cớp trutrếh chóq cũai ca khoiq satoaq nghang cumuiq, tỡ la sac cumuiq, tỡ la ping cumuiq. ");
INSERT INTO bru_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Tâng tangái pái cớp tangái tapul, yỗn cũai bráh puai rit trutrếh chóq án ca tỡ bữn bráh. Ma tâng tangái tapul cóq án táq rit yỗn cũai tỡ yũah bráh. Cóq cũai tỡ yũah bráh ki pooh tampâc cớp mpơi dỡq; táq ngkíq án cỡt bráh puai rit toâq mandang pât. ");
INSERT INTO bru_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ma khân bữn manoaq tỡ bữn bráh puai rit, cớp án tỡ bữn táq puai rit nâi, noau noap cũai ki la tỡ bữn bráh, yuaq án tỡ bữn ĩt dỡq ariau tỗ án. Án táq yỗn Dống Sang Aroâiq Yiang Sursĩ cỡt tỡ bữn bráh tê. Cũai ki tỡ têq cỡt noâng cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Tỗp anhia cóq trĩh cớp táq puai máh phễp rit nâi dũ dỡi cũai mantái níc. Cũai ca trutrếh dỡq ki, cóq án pooh tê tampâc án. Khân cũai aléq ma chũaiq dỡq ki, án lứq cỡt tỡ bữn bráh puai rit toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Cũai aléq tỡ bữn bráh, ma yống muoi ramứh ntrớu, ramứh ki lứq cỡt tỡ bữn bráh tê; cớp khân bữn cũai ma satoaq crơng tỡ bữn bráh, án cỡt tỡ bữn bráh tê toau toâq sadâu. ");
INSERT INTO bru_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Tâng casâi muoi nheq tữh cũai proai I-sarel toâq pỡ ntốq aiq Sin, chơ alới ỡt dỡ pỡ vil Cadet. Tâng ntốq ki niang Mi-riam cuchĩt, cớp noau tứp án bân ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Bân ntốq alới ỡt dỡ ŏ́q dỡq nguaiq. Yuaq ngkíq máh cũai proai ma toâq rôm tampống parnơi mpễr Môi-se cớp Arôn, ");
INSERT INTO bru_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","cớp alới loai bubéq-bubưp neq: “Khân tỗp hái ma cuchĩt yáng moat Dống Sang Aroâiq parnơi cớp sễm ai hái cũai I-sarel, ki la o hỡn! ");
INSERT INTO bru_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Cỗ nŏ́q anhia dững tỗp hếq toâq pỡ ntốq aiq nâi? Ễq yỗn tỗp hếq cớp charán tỗp hếq cuchĩt tâng ntốq nâi tỡ? ");
INSERT INTO bru_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Cỗ nŏ́q anhia mŏ dững aloŏh tỗp hếq tễ cruang Ê-yip-tô, chơ mut ỡt tâng ntốq túh coat lứq nâi, ŏ́q dếh bát bai dáh? Tâng ntốq nâi ŏ́q dỗi cha, ŏ́q palâi tarúng, ŏ́q palâi nho, cớp ŏ́q palâi ỗiq-tâi, dếh dỡq ễ nguaiq la ŏ́q!” ");
INSERT INTO bru_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Môi-se cớp Arôn tayáh pỡq chíq tễ máh cũai proai, chơ tayứng bân ngoah toong mut chu Dống Sang Aroâiq. Alới pũp moat asễng chu cutễq, cớp bữn poang ang‑ữr tễ chớc Yiang Sursĩ sapáh yỗn alới hữm. ");
INSERT INTO bru_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Cóq mới ĩt ralỡng ca ỡt coah moat Hĩp Parnai Parkhán; chơ cóq mới cớp Arôn arô nheq tữh cũai proai. Cớp pai chóq côl tamáu yáng moat tỗp alới, chơ lứq bữn dỡq loŏh carsễt tễ ki. Ngkíq anhia têq bữn dỡq tễ côl ki, dŏq máh cũai proai cớp máh charán anhia bữn nguaiq.” ");
INSERT INTO bru_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Chơ Môi-se ĩt ralỡng cớp loŏh pỡq machớng Yiang Sursĩ atỡng án. ");
INSERT INTO bru_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Môi-se cớp Arôn parỗm máh cũai proai yỗn ỡt yáng moat tamáu côl, chơ Môi-se pai neq: “Nheq tữh anhia ca táq choac ơi, cóq anhia tamứng! Nŏ́q, cóq hếq ĩt dỡq tễ côl nâi yỗn anhia nguaiq tỡ?” ");
INSERT INTO bru_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Chơ Môi-se acŏ́q ralỡng achỗn cớp côq tamáu côl bar taláp, chơ bữn dỡq loŏh sa‑ữi lứq. Ngkíq nheq tữh cũai cớp charán bữn nguaiq. ");
INSERT INTO bru_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ma Yiang Sursĩ tếq Môi-se cớp Arôn neq: “Cỗ anhia bữn ŏ́c sa‑âm bĩq, anhia tỡ bữn yám noap chớc cứq yáng moat máh cũai proai; ngkíq anhia tỡ têq dững tỗp alới mut chu cutễq cứq khoiq par‑ữq yỗn.” ");
INSERT INTO bru_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ranáq nâi bữn cỡt tâng Mê-ri-ba, la ntốq cũai proai I-sarel bubéq-bubưp chóq Yiang Sursĩ, cớp bân ntốq Yiang Sursĩ sapáh yỗn alới hữm án la bráh o lứq. ");
INSERT INTO bru_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Môi-se ớn cũai ranễng pỡq tễ vil Cadet, chơ pau atỡng yỗn puo cũai Ê-dôm neq: “Sễm ai anhia tỗp I-sarel atỡng neq: Anhia dáng chơ máh ŏ́c túh arức cũai I-sarel ramóh. ");
INSERT INTO bru_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Achúc achiac hếq ỡt tâng cruang Ê-yip-tô sa‑ữi cumo. Tỗp Ê-yip-tô táq túh coat lứq tỗp achúc achiac hái, dếh tỗp hếq hỡ. ");
INSERT INTO bru_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Toâq tỗp hếq nhiam nhit sễq Yiang Sursĩ chuai, án sâng sưong hếq cuclỗiq cucling; chơ án ớn muoi noaq ranễng ayông tỗp hếq loŏh tễ cruang Ê-yip-tô. Sanua tỗp hếq ỡt dỡ tâng vil Cadet, cheq raloan cruang anhia. ");
INSERT INTO bru_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ngkíq hếq sễq pỡq pha cutễq cruang anhia, têq tỡ? Tỗp hếq cớp máh charán hếq tỡ bữn veh loŏh tễ rana, tỡ la mut tâng sarái tỡ la nưong nho anhia. Cớp tỗp hếq tỡ bữn nguaiq dỡq tễ chữong anhia. Nheq tữh hếq sễq pỡq tâng rana put cruang anhia sâng.” ");
INSERT INTO bru_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Máh cũai Ê-dôm ta‑ỡi neq: “Tỗp hếq tỡ bữn pruam yỗn tỗp anhia pỡq pha raloan cruang cutễq hếq! Khân tỗp anhia mut clốq, tỗp hếq ễ dững poâl pỡq chíl tỗp anhia.” ");
INSERT INTO bru_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Cũai proai I-sarel pai neq: “Máh tỗp hếq sễq pỡq pha rana put sâng. Khân hếq tỡ la charán hếq ma nguaiq dỡq anhia, ki tỗp hếq sễq culáh práq yỗn anhia. Ma tỗp hếq sễq pỡq pha cutễq cruang anhia sâng.” ");
INSERT INTO bru_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ma cũai proai Ê-dôm ta‑ỡi neq: “Hếq tỡ bữn pruam yỗn anhia pỡq pha!” Chơ tỗp alới dững poâl tahan bán rêng lứq loŏh chíl cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Cỗ tian máh cũai proai Ê-dôm tỡ yỗn máh cũai proai I-sarel pỡq pha cruang cutễq alới, ngkíq yuaq cũai proai I-sarel veh pỡq rana canŏ́h ễn. ");
INSERT INTO bru_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Nheq tữh cũai I-sarel loŏh tễ vil Cadet, chơ pỡq toâq pỡ cóh Hor, ");
INSERT INTO bru_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","cheq cớp raloan cruang Ê-dôm. Tâng ntốq ki Yiang Sursĩ táq ntỡng cớp Môi-se cớp Arôn neq: ");
INSERT INTO bru_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Arôn tỡ dáng bữn mut chu cruang cutễq cứq khoiq par‑ữq yỗn cũai proai I-sarel. Án lứq cuchĩt, yuaq anhia bar náq tỡ bữn táq puai ŏ́c cứq patâp bo anhia ỡt pỡ Mê-ri-ba. ");
INSERT INTO bru_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Cóq mới dững Arôn cớp con samiang án, ramứh E-lia-sơ, chỗn pỡ cóh Hor. ");
INSERT INTO bru_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ỡt ntốq ki cóq mới tũot aloŏh chíq tampâc tếc cũai tễng rit sang tễ Arôn; chơ asớp yỗn E-lia-sơ ễn. Arôn lứq cuchĩt pỡ ntốq ki.” ");
INSERT INTO bru_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Môi-se táq puai machớng Yiang Sursĩ ớn. Alới chỗn pỡ cóh Hor choâng moat nheq tữh cũai proai, ");
INSERT INTO bru_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","cớp án tũot tampâc chớc cỡt cũai tễng rit sang tễ tỗ Arôn. Chơ án asớp yỗn E-lia-sơ ễn. Arôn cuchĩt tâng anũol cóh ki; chơ Môi-se cớp E-lia-sơ sễng tễ cóh. ");
INSERT INTO bru_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Toâq nheq tữh cũai proai I-sarel dáng Arôn khoiq cuchĩt chơ, ngkíq alới pruam tanúh yỗn án nheq pái chít tangái. ");
INSERT INTO bru_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Toâq puo tỗp Cana-an ca ỡt tâng vil Arat, coah angia pưn raloan cruang ki, bữn sâng tỗp proai I-sarel ntôm pỡq tâng rana chu vil Atha-rim. Ngkíq án dững máh tahan loŏh chíl tỗp alới; cớp án bữn cỗp cũai tễ tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Chơ máh cũai I-sarel parkhán chóq Yiang Sursĩ neq: “Khân anhia ma táq yỗn tỗp hếq chíl riap máh cũai nâi, ki tỗp hếq ễ chiau sang tỗp alới pỡ talang atĩ anhia na talốh táh nheq dũ vil alới ỡt.” ");
INSERT INTO bru_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yiang Sursĩ sâng máh santoiq tỗp I-sarel parkhán ngkíq. Chơ Yiang Sursĩ chuai tỗp alới chíl riap máh cũai Cana-an. Yuaq ngkíq, cũai proai I-sarel ma talốh táh nheq dũ vil cũai ki; chơ amứh cruang ki ramứh tamái ễn la Hor-ma. ");
INSERT INTO bru_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Cũai proai I-sarel loŏh tễ cóh Hor, chơ alới tayoâq pỡq chu angia dỡq mưt Cusâu ễ tayáh viel coah raloan cutễq tỗp Ê-dôm. Ma bo alới pỡq tâng rana, máh cũai proai cỡt pê pahỡm tỡ riap chĩuq noâng, ");
INSERT INTO bru_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","cớp alới bubéq-bubưp chóq Yiang Sursĩ cớp chóq Môi-se hỡ, pai neq: “Cỗ nŏ́q anhia ma dững aloŏh tỗp hếq tễ cruang Ê-yip-tô yỗn hếq cuchĩt pỡ mpứng dĩ ntốq aiq, ŏ́q sana cha cớp dỡq nguaiq? Máh tỗp hếq tỡ rơi chĩuq noâng crơng sana tỡ ễm nâi!” ");
INSERT INTO bru_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Chơ Yiang Sursĩ táq yỗn cusân pla toâq tot cũai proai I-sarel cuchĩt sa‑ữi lứq. ");
INSERT INTO bru_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Máh cũai proai pỡq ramóh Môi-se cớp pai neq: “Tỗp hếq khoiq táq lôih cỗ bubéq-bubưp chóq Yiang Sursĩ cớp chóq anhia hỡ. Sanua sễq anhia câu chuai, yỗn Yiang Sursĩ atũih chíq máh cusân yỗn pỡq toâp.” Ngkíq Môi-se câu sễq loah sĩa yỗn tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Chơ Yiang Sursĩ atỡng Môi-se táq muoi lám rup cusân toâq sapoan, cớp ayŏ́ng dŏq tâng tanũl. Toâq cusân tot cũai, khân cũai ki tapoang nhêng chu rup cusân, ki án cỡt bán toâp. ");
INSERT INTO bru_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ngkíq Môi-se tooc sapoan táq rup cusân, chơ ayŏ́ng dŏq tâng tanũl. Cũai aléq ma pĩeiq cusân tot, khân án tapoang nhêng chu rup cusân sapoan ki, án cỡt bán toâp. ");
INSERT INTO bru_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Tỗp I-sarel atỡi ễn ntốq ỡt; alới ỡt dỡ pỡ ntốq Ô-bôt. ");
INSERT INTO bru_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Toâq tỗp alới loŏh tễ Ô-bôt, alới ỡt dỡ pỡ ntốq rangual, ramứh Aba-rim. Vil nâi ỡt tâng ntốq aiq, coah moat mandang loŏh cruang cũai Mô-ap. ");
INSERT INTO bru_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Vớt ki, tỗp alới pỡq ỡt dỡ cheq avúng Sê-rêt. ");
INSERT INTO bru_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Tễ avúng Sê-rêt tỗp alới atỡi pỡq ỡt dỡ kễng crỗng Ar-nôn, pỡ ntốq aiq toâq pỡ raloan cruang cũai Amô-rit. (Dỡq crỗng Ar-nôn ỡt mpứng dĩ raloan cruang Mô-ap cớp cruang Amô-rit.) ");
INSERT INTO bru_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Cỗ ngkíq, pơ saráq atỡng tễ ranáq rachíl khong Yiang Sursĩ, ma pai neq: “…vil Vahep pỡ ntốq Suphah, cớp máh avúng cóh, crỗng Ar-nôn, ");
INSERT INTO bru_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","cớp máh anũol cóh cuti toâq pỡ vil Ar cớp raloan cruang Mô-ap.” ");
INSERT INTO bru_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Tễ ntốq ki, tỗp alới pruam tayáh pỡq tâng rana toau toâq pỡ ntốq ramứh Bê-ễr. Tâng ntốq ki Yiang Sursĩ atỡng Môi-se neq: “Cóq mới arô nheq tữh cũai proai I-sarel yỗn toâq rôm parnơi, cứq ễ yỗn tỗp alới bữn dỡq nguaiq.” ");
INSERT INTO bru_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Chơ, cũai proai I-sarel ũat cansái neq: “Ơ dỡq chữong ơi! Sễq mới loŏh chái! Hếq táq ntỡng cớp dỡq chữong ki na parnai ũat. ");
INSERT INTO bru_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Hếq ũat tễ dỡq chữong cũai ayông khoiq píq, dếh puo píq toâq ralỡng yễng, cớp cũai proai hỡ píq toâq ralỡng alới.” Chơ tỗp alới dễq tễ ntốq aiq ki atỡi chu ntốq Ma-tana ễn. ");
INSERT INTO bru_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Tễ Ma-tana alới toâq pỡ Naha-liel, cớp tễ Naha-liel toâq pỡ Bamôt, ");
INSERT INTO bru_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","tễ Bamôt toâq avúng cóh tâng cruang Mô-ap, coah pưn anũol cóh Pit-ca, tapoang tễ cóh ki têq hữm ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Chơ cũai proai I-sarel ớn cũai ranễng pỡq atỡng Si-hôn, puo cũai Amô-rit, neq: ");
INSERT INTO bru_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Sễq achuaih yỗn tỗp hếq pỡq pha cruang cutễq achuaih. Tỗp hếq cớp máh charán ễ pỡq ống tâng rana sâng, tỡ bữn mut chu sarái tỡ la nưong nho anhia, cớp tỡ bữn nguaiq dỡq tễ dỡq chữong achuaih. Ma tỗp hếq sễq pỡq ống tâng rana put, toau yỗn vớt cruang achuaih.” ");
INSERT INTO bru_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ma Si-hôn tỡ yỗn cũai proai I-sarel pỡq pha cruang án. Cớp án parỗm máh cũai poâl, chơ alới loŏh pỡq chíl cũai proai I-sarel tâng vil Yahat. ");
INSERT INTO bru_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ma cũai proai I-sarel bữn cachĩt sa‑ữi lứq máh cũai poâl ki pỡ ntốq rachíl. Cớp alới cheng ĩt nheq cruang cutễq cũai ki, noap tễ angia crỗng Ar-nôn toau toâq crỗng Yaboc, cớp toau toâq pỡ raloan cruang tỗp Amôn sâng, yuaq tỗp Amôn ki curiaq catáng raloan cruang alới khâm lứq. ");
INSERT INTO bru_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Yuaq ngkíq, máh cũai I-sarel ma toâq cheng ĩt dũ vil khong cũai Amô-rit, dếh vil Hê-sabôn cớp dũ vil cớt mpễr ki hỡ. Chơ alới ỡt loâng tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hê-sabôn la vil toâr khong Si-hôn, puo cũai Amô-rit. Án khoiq chíl riap puo Mô-ap thrap nhũang, chơ án ễn táq sốt máh cruang cutễq ki yỗn toau toâq pỡ crỗng Ar-nôn. ");
INSERT INTO bru_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Yuaq ngkíq, bữn máh cũai ũat cansái ũat neq: “Sễq mơi anhia toâq pỡ Hê-sabôn, la vil toâr khong puo Si-hôn! Dŏq atức cớp táq loah tamái máh ntốq khoiq rúng ralốh. ");
INSERT INTO bru_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Yuaq bữn muoi trỗ tâng vil Hê-sabôn nâi, poâl tahan Si-hôn pỡq chíl ariang pla ũih taluam cat nheq vil Ar tâng cruang Mô-ap, cat dếh cũai Ar-nôn ca ỡt tâng cóh cỡt plur nheq. ");
INSERT INTO bru_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Bap lứq toâq pỡ anhia la cũai Mô-ap! Ơ anhia ca sang yiang Khê-môt ơi! Anhia khoiq cỡt ralốh chơ! Yiang tỗp anhia khoiq táq yỗn anhia lúh pláh chap nheq. Cớp mansễm tễ tỗp anhia khoiq cỡt cũai sũl yỗn puo tỗp Amô-rit. ");
INSERT INTO bru_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ma sanua, máh tỗp con châu anhia cỡt cuchĩt; cuchĩt radốc racơng tâng rana, tễ vil Hê-sabôn toau toâq vil Di-bôn, tễ vil Nasim toau toâq pỡ vil Nô-pha, la ntốq raloan cheq cớp vil Mê-daba.” ");
INSERT INTO bru_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Yuaq ngkíq, máh cũai proai I-sarel ma bữn ỡt níc tâng cruang cũai Amô-rit. ");
INSERT INTO bru_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Chơ Môi-se ớn cũai pỡq tutuaiq nhêng cỡt nŏ́q tâng rana put, ien ễ mut chíl vil Yasơ. Cũai proai I-sarel chíl riap vil toâr ki cớp máh vil cớt ỡt mpễr ki, cớp alới tuih aloŏh nheq máh cũai proai Amô-rit ca ỡt tâng vil ki. ");
INSERT INTO bru_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Moâm ki cũai I-sarel veh chu rana pỡq pỡ vil Basan. Ma Oc, puo Basan dếh máh tahan án loŏh ễ rachíl tỗp I-sarel tâng ntốq Ê-darê. ");
INSERT INTO bru_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yiang Sursĩ atỡng Môi-se neq: “Chỗi ngcŏh puo Oc; cứq ễ yỗn mới chíl riap puo nâi, dếh máh cũai proai án hỡ; chơ cruang ki cỡt khong anhia ễn. Cóq mới táq chóq Oc machớng mới khoiq táq chóq Si-hôn, puo tỗp Amô-rit, án ca sốt tâng vil toâr Hê-sabôn.” ");
INSERT INTO bru_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Yuaq ngkíq, cũai proai I-sarel bữn cachĩt puo Oc, cớp máh con samiang án. Alới bữn cachĩt dếh máh cũai proai hỡ, tỡ bữn noau têq tamoong noâng; chơ alới ễn táq sốt cruang cutễq ki. ");
INSERT INTO bru_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Máh cũai proai I-sarel atỡi ntốq ỡt dỡ pỡ ntốq tapín cruang Mô-ap, coah angia mandang loŏh crỗng Yôr-dan, choâng cớp vil Yê-ri-cô. ");
INSERT INTO bru_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Toâq Balac con samiang Si-pôr, puo cũai Mô-ap sâng tễ ranáq cũai I-sarel táq chóq cũai proai Amô-rit, cớp án dáng bữn cũai I-sarel sa‑ữi máh léq ỡt tâng ntốq ki, ");
INSERT INTO bru_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","chơ án cớp nheq tữh cũai proai án sâng ngcŏh lứq. ");
INSERT INTO bru_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Cũai proai Mô-ap táq ntỡng cớp cũai sốt tỗp Madian neq: “Tỡ bữn dũn noâng máh cũai proai ki ễ toâq talốh dũ ramứh mpễr hái, riang ntroŏq cha bát tâng ruang.” ");
INSERT INTO bru_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Yuaq ngkíq, Balac ớn ayững atĩ án pỡq mơi Balam con samiang Bê-ô ca ỡt tâng vil Pê-thôr cheq crỗng Ơ-phơ-rat, tâng cutễq vil tiaq án. Chơ Balac pai neq: “Cứq yoc mới dáng tê la bữn muoi tỗp cũai toâq tễ cruang Ê-yip-tô, alới ntôm pỡq chu dũ ntốq, cớp alới canứh ễ cheng cruang hếq. ");
INSERT INTO bru_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Tỗp alới clứng hỡn tễ tỗp hếq. Ngkíq, sễq mới pupap máh tỗp alới chuai tỗp hếq nứng. Khân mới táq ngkíq, cŏh lơ tỗp hếq bữn riap tuih aloŏh máh tỗp ki yỗn vớt tễ cruang cutễq hếq cống bữn. Cứq dáng, bo léq mới câu ŏ́c bốn yỗn máh cũai proai, alới lứq bữn roap ŏ́c bốn ki; cớp toâq mới pupap, máh alới lứq bữn ŏ́c bap toâp.” ");
INSERT INTO bru_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Yuaq ngkíq, máh cũai sốt tỗp Mô-ap, cớp Madian ma pỡq ramóh Balam, alới dững práq ễ yỗn kia táq rit pupap hỡ, cớp alới atỡng loah santoiq Balac khoiq pai. ");
INSERT INTO bru_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balam táq ntỡng cớp tỗp alới neq: “Tâng sadâu nâi cóq anhia bếq ntốq nâi voai; poang tarưp parnỡ cứq ễ atỡng yỗn anhia dáng tễ máh ŏ́c Yiang Sursĩ atỡng cứq.” Yuaq ngkíq, máh cũai sốt tỗp Mô-ap ma bếq parnơi cớp Balam. ");
INSERT INTO bru_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Yiang Sursĩ toâq pỡ Balam, cớp blớh án neq: “Máh cũai ỡt cớp mới nâi, la noau?” ");
INSERT INTO bru_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balam ta‑ỡi neq: “Cũai tễ puo cruang Mô-ap ớn máh cũai nâi atỡng cứq neq: ");
INSERT INTO bru_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Bữn muoi tỗp cũai ntôm pỡq tễ cruang Ê-yip-tô, alới pỡq pláh chũop nheq dũ ntốq tâng cốc cutễq nâi. Án yoc cứq pupap máh cũai ki, yuaq án ễ tuih aloŏh cũai ki.’” ");
INSERT INTO bru_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ma Yiang Sursĩ atỡng Balam neq: “Mới chỗi pỡq noâng cớp tỗp cũai ki. Cớp chỗi pupap ntrớu chóq cũai proai I-sarel, yuaq cứq toâp yỗn tỗp alới bữn ŏ́c bốn.” ");
INSERT INTO bru_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Toâq tarưp parnỡ, Balam pỡq ramóh loah máh cũai ranễng Balac cớp pai neq: “Anhia píh chu loah nơ! Yuaq Yiang Sursĩ tỡ yỗn cứq pỡq cớp anhia.” ");
INSERT INTO bru_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ngkíq máh tỗp alới píh chu pỡ Balac, cớp atỡng án neq: “Balam tỡ ễq pỡq cớp tỗp hếq.” ");
INSERT INTO bru_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Chơ Balac ớn máh cũai sốt canŏ́h ễn pỡq, clứng hỡn cớp sốt hỡn tễ trỗ nhũang. ");
INSERT INTO bru_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Tỗp alới pỡq ramóh Balam, dếh atỡng santoiq Balac neq: “Sễq chỗi yỗn muoi ramứh ntrớu têq catáng mới toâq pỡ cứq! ");
INSERT INTO bru_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Cứq ễ chang cóng mới sa‑ữi lứq, cớp ntrớu mới yoc ễ bữn, ki mới lứq bữn máh ŏ́c ki. Sễq mới pupap máh tỗp ki chuai cứq.” ");
INSERT INTO bru_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ma Balam ta‑ỡi alới neq: “Tam Balac yỗn cứq bữn nheq máh práq yễng tâng dống án, la cứq tỡ têq táq clốq tễ máh parnai Yiang Sursĩ, la Ncháu cứq, khoiq atỡng cứq chơ, tỡ bữn pai ŏ́c ki cớt tỡ la toâr. ");
INSERT INTO bru_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ma sễq anhia ỡt voai tâng sadâu nâi, riang máh cũai ca khoiq toâq nhũang tê. Cŏh lơ Yiang Sursĩ ễ atỡng muoi ramứh ntrớu ễn yỗn cứq.” ");
INSERT INTO bru_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Tâng sadâu ki Yiang Sursĩ toâq pỡ Balam cớp atỡng án neq: “Khân tỗp nâi ma noâng cucốh cucũoi níc yỗn mới pỡq nứng alới, ki mới pỡq. Ma cóq mới táq ống samoât cứq atỡng.” ");
INSERT INTO bru_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Yuaq ngkíq, toâq poang tarưp Balam chóq racu tâng cloong aséh dễn; chơ án pỡq cớp cũai sốt tỗp Mô-ap. ");
INSERT INTO bru_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Yiang Sursĩ sâng cutâu mứt chóq Balam, yuaq án pỡq cớp alới ki. Bo Balam ntôm ỡt aséh dễn pỡq, bữn bar náq cũai táq ranáq án pỡq nứng án tê. Ma ranễng Yiang Sursĩ ỡt tayứng catáng chíq rana. ");
INSERT INTO bru_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Toâq aséh dễn hữm ranễng Yiang Sursĩ ỡt tayứng yống dau tâng ntốq ki, án veh tễ rana pỡq chu ruang ễn. Balam proaih aséh dễn yỗn án pỡq loah tâng rana put. ");
INSERT INTO bru_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Chơ ranễng Yiang Sursĩ toâq tayứng catáng bân nưong nho, ca bữn viang tamáu ỡt bar coah. ");
INSERT INTO bru_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Tữ aséh dễn hữm loah ranễng Yiang Sursĩ, án sarín clúh viang, cớp catễt ayững Balam amớt tâng viang tamáu. Ngkíq Balam proaih sĩa aséh dễn ki. ");
INSERT INTO bru_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Muoi trỗ ễn, ranễng Yiang Sursĩ pỡq nhũang cớp toâq bân ntốq hễp, bar coah rana ki ŏ́q cluang pỡq. ");
INSERT INTO bru_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Tâng trỗ nâi, toâq aséh dễn hữm ranễng Yiang Sursĩ, án púq asễng tâng cutễq. Balam sâng nsóq lứq; chơ án ĩt dũi proaih cloong aséh dễn sĩa. ");
INSERT INTO bru_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Chơ Yiang Sursĩ táq yỗn aséh dễn têq táq ntỡng. Án pai chóq Balam neq: “Ntrớu cứq táq chóq mới, ma mới proaih cứq khoiq pái trỗ nâi chơ?” ");
INSERT INTO bru_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balam ta‑ỡi án neq: “Cỗ mới táq yỗn cứq cỡt casiet, khân cứq bữn dau, cứq lứq tráh mới yỗn cuchĩt sanua toâp.” ");
INSERT INTO bru_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Aséh dễn blớh loah án neq: “Nŏ́q cứq tỡ cỡn aséh dễn mới cơi ỡt níc tỡ? Tễ nhũang, cứq cơi táq nneq chóq mới tỡ?” Balam ta‑ỡi án neq: “Tỡ nai ngkíq!” ");
INSERT INTO bru_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Chơ Yiang Sursĩ táq yỗn Balam hữm ranễng Yiang Sursĩ tayứng yống dau tâng ntốq ki. Ngkíq Balam pũp mieiq asễng tâng cutễq. ");
INSERT INTO bru_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ranễng Yiang Sursĩ blớh án neq: “Cỗ nŏ́q mới proaih aséh dễn mới khoiq pái trỗ chơ? Cứq toâq pỡ nâi dŏq catáng tỡ yỗn mới pỡq, yuaq tỡ pĩeiq mới toâq pỡ nâi. ");
INSERT INTO bru_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ma aséh dễn mới, án hữm cứq, chơ án lúh pái trỗ. Khân aséh dễn mới ma tỡ bữn lúh, cứq ễ cachĩt táh chơ mới, ma dŏq aséh dễn mới ễn bữn tamoong.” ");
INSERT INTO bru_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balam ta‑ỡi ranễng ki neq: “Cứq khoiq táq lôih chơ; cứq tỡ bữn dáng pai anhia ỡt tayứng catáng rana. Ma sanua, khân anhia hữm tỡ o cứq pỡq chu ki, cứq ễ píh chu loah.” ");
INSERT INTO bru_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ma ranễng Yiang Sursĩ atỡng án neq: “Mới têq pỡq cớp tỗp nâi, ma mới cóq táq machớng cứq patâp mới dũ ramứh.” Ngkíq, Balam pỡq nứng tỗp cũai ki. ");
INSERT INTO bru_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Toâq Balac sâng noau pai Balam ntôm toâq, án loŏh pỡq ramóh Balam pỡ vil Ar, la muoi vil ỡt cheq crỗng Ar-nôn, cớp cheq raloan cruang Mô-ap. ");
INSERT INTO bru_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balac blớh án neq: “Cứq khoiq ớn cũai pỡq mơi mới toâq pỡ nâi, ma cỗ nŏ́q mới tỡ bữn toâq? Nŏ́q mới chanchớm cứq tỡ têq culáh cóng yỗn mới tỡ?” ");
INSERT INTO bru_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balam ta‑ỡi loah neq: “Sanua hếq toâq pỡ nâi chơ. Ma hếq ŏ́q chớc tễ máh santoiq hếq ễ pai. Hếq cóq pai ống santoiq Yiang Sursĩ atỡng hếq sâng.” ");
INSERT INTO bru_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Chơ, Balam cớp Balac pỡq chu vil Ki-riat Husôt. ");
INSERT INTO bru_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ỡt ntốq ki, Balac kiac ntroŏq cớp cữu dŏq chiau sang. Án ĩt muoi pún sâiq yỗn Balam cớp máh cũai sốt ca pỡq parnơi cớp án. ");
INSERT INTO bru_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Toâq poang tarưp parnỡ, Balac dững Balam chỗn pỡ vil Bamôt Ba-al. Balam tapoang tễ ntốq ki, án hữm muoi sampứh cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balam atỡng Balac neq: “Cóq anhia táq prông sang yỗn hếq tapul prông, cớp dững tapul lám ntroŏq tangcáh cớp tapul lám cữu tôl yỗn hếq.” ");
INSERT INTO bru_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balac táq puai riang santoiq Balam atỡng. Chơ alới bar náq chiau sang máh ntroŏq tangcáh cớp máh cữu tôl, muoi ramứh muoi lám tâng dũ prông sang. ");
INSERT INTO bru_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Chơ Balam pai chóq Balac neq: “Cóq anhia ỡt tayứng cheq crơng sang khong anhia bữm nơ! Ma hếq ễ pỡq nhêng Yiang Sursĩ yỗn hếq ramóh án, ma tỡ bữn. Chơ hếq ễ píh atỡng yỗn anhia dáng tê, ntrớu Yiang Sursĩ atỡng hếq.” Chơ Balam pỡq pỡ anũol cóh manoaq án toâp. ");
INSERT INTO bru_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Yiang Sursĩ toâq ramóh Balam. Balam atỡng Yiang Sursĩ neq: “Cứq khoiq táq prông sang tapul prông. Moâm ki cứq kiac máh ntroŏq tangcáh cớp máh cữu tôl, chơ dững chóq tâng dũ lám prông.” ");
INSERT INTO bru_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yiang Sursĩ atỡng Balam máh santoiq án cóq pai, cớp Yiang Sursĩ yỗn án píh chu loah pỡ Balac yỗn án dáng tê máh santoiq Yiang Sursĩ atỡng án. ");
INSERT INTO bru_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ngkíq, án píh loah pỡ Balac ca ỡt yáng coah prông sang, dếh máh cũai sốt tỗp Mô-ap hỡ. ");
INSERT INTO bru_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Chơ Balam atỡng sacoâiq neq: “Balac la puo cũai Mô-ap dững cứq toâq pỡ nâi tễ Si-ri, la cruang cóh ỡt coah angia mandang loŏh. Cớp Balac ớn neq: ‘Sễq mới toâq pupap máh cũai proai I-sarel tang cứq!’ ");
INSERT INTO bru_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","“Nŏ́q têq cứq pupap cũai Yiang Sursĩ tỡ bữn pupap? Tỡ la pai tỡ o chóq cũai Yiang Sursĩ tỡ bữn pai tỡ o? ");
INSERT INTO bru_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Cứq têq hữm alới tễ anũol cóh sarỡih, cớp cứq têq nhêng alới cỗ nhơ anũol cóh ki hỡ. Alới la tỗp miar tễ cũai canŏ́h; cớp alới dáng tê la tỗp alới khoiq bữn ŏ́c bốn puan clữi nheq tễ cruang canŏ́h. ");
INSERT INTO bru_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Tŏ́ng toiq I-sarel cỡt riang phốn cutễq, sa‑ữi lứq toau tỡ rơi ngih noâng. Sễq yỗn cứq cuchĩt machớng cũai proai Yiang Sursĩ. Sễq yỗn cứq cuchĩt ien khễ, machớng cũai tanoang o tê.” ");
INSERT INTO bru_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balac ta‑ỡi án neq: “Cỗ nŏ́q mới táq chóq cứq ngkíq? Cứq ớn mới toâq pỡ nâi la yỗn mới pupap máh cũai par‑ũal cứq. Ma nŏ́q mới câu ŏ́c bốn yỗn tỗp alới?” ");
INSERT INTO bru_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Án ta‑ỡi neq: “Hếq têq pai ống santoiq Yiang Sursĩ yỗn hếq pai sâng.” ");
INSERT INTO bru_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ma Balac atỡng Balam neq: “Mới cóq pỡq cớp cứq pỡ ntốq canŏ́h; ỡt ntốq ki mới bữn hữm cũai I-sarel bĩq náq sâng. Tâng ntốq ki cóq mới pupap tỗp alới chuai cứq.” ");
INSERT INTO bru_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Chơ Balac dững Balam pỡq chu ruang Sô-phim, tâng anũol cóh Pit-ca. Ỡt ntốq ki án táq tapul lám prông sang, dŏq chiau sang máh ntroŏq tangcáh cớp máh cữu tôl tâng dũ prông. ");
INSERT INTO bru_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balam atỡng Balac neq: “Anhia cóq tayứng cheq crơng chiau sang khong anhia bữm; ma hếq ễ pỡq ramóh Yiang Sursĩ pỡ tíh.” ");
INSERT INTO bru_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yiang Sursĩ toâq ramóh Balam, cớp atỡng án máh santoiq án yoc ễ pai. Moâm ki, Yiang Sursĩ ớn Balam pỡq atỡng Balac máh parnai án khoiq atỡng yỗn pai. ");
INSERT INTO bru_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Yuaq ngkíq, Balam chu loah pỡ Balac, chơ ramóh loah án ỡt tayứng cheq prông chiau sang, dếh máh cũai sốt tỗp Mô-ap hỡ. Balac blớh án neq: “Ntrớu Yiang Sursĩ atỡng chóq mới?” ");
INSERT INTO bru_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Chơ Balam atỡng sacoâiq neq: “Puo Balac con samiang Si-pôr ơi! Cóq anhia tamứng máh santoiq cứq ễ atỡng. ");
INSERT INTO bru_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Yiang Sursĩ tỡ bữn ariang cũai dốq táq ntỡng lauq. Yiang Sursĩ tỡ nai rapĩen sarnớm ariang cũai dốq rapĩen. Toâq Yiang Sursĩ par‑ữq ramứh ntrớu, án lứq yỗn ramứh ki cỡt. Toâq Yiang Sursĩ pai, án lứq táq. ");
INSERT INTO bru_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Yiang Sursĩ atỡng cứq câu ŏ́c bốn. Toâq án ễ satốh ŏ́c bốn, cứq tỡ têq catáng án. ");
INSERT INTO bru_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Cứq dáng la chumát máh cũai I-sarel tỡ bữn túh ngua ntrớu noâng, yuaq Yiang Sursĩ, Ncháu alới, ỡt níc cớp alới. Alới lứq pau atỡng tễ án la puo alới. ");
INSERT INTO bru_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Yiang Sursĩ khoiq dững alới loŏh tễ cruang Ê-yip-tô. Yiang Sursĩ toâp chíl chuai alới; án rêng lứq machớng sangũr cruang. ");
INSERT INTO bru_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tỡ bữn ramoon ntrớu, tỡ la ngê parnân ntrớu, ma têq ĩt dŏq chíl cũai proai I-sarel. Sanua, bữn máh cũai ễ pai neq tễ cũai I-sarel: ‘Nhêng tíh! Nhêng máh ranáq Yiang Sursĩ khoiq táq!’ ");
INSERT INTO bru_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Cũai proai tỗp nâi yuor achỗn, rêng machớng cula samín; án tỡ bữn rlu toau toâq án háq cha sâiq dũ ramứh ca cỡt crơng sana án, cớp án nguaiq aham alới ca án khoiq cáp cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Chơ Balac pai chóq Balam neq: “Tam mới tỡ ễq pupap cũai proai I-sarel, ma sễq mới chỗi câu noâng ŏ́c bốn yỗn alới!” ");
INSERT INTO bru_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balam ta‑ỡi Balac neq: “Hếq khoiq atỡng anhia chơ, pĩeiq tỡ? Hếq cóq atỡng dũ ramứh Yiang Sursĩ ớn hếq atỡng.” ");
INSERT INTO bru_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balac pai chóq án neq: “Cóq mới pỡq cớp cứq nâi; cứq ễ ayông mới pỡq chu ntốq canŏ́h ễn. Cŏh lơ tâng ntốq ki Yiang Sursĩ sâng bũi pahỡm yỗn mới pupap tỗp alới.” ");
INSERT INTO bru_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ngkíq, án dững Balam pỡq chu anũol cóh Pê-or, la ntốq têq tapoang hữm chu ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balam atỡng Balac neq: “Cóq anhia táq prông sang tâng ntốq nâi tapul prông yỗn hếq. Chơ dững tapul lám ntroŏq tangcáh cớp tapul lám cữu tôl pỡ nâi.” ");
INSERT INTO bru_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ngkíq Balac táq puai máh santoiq Balam atỡng. Án dững tapul lám ntroŏq tangcáh cớp tapul lám cữu tôl, cớp chiau sang tâng dũ lám prông sang. ");
INSERT INTO bru_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Trỗ nâi Balam dáng Yiang Sursĩ ễq án câu ŏ́c bốn yỗn tỗp proai I-sarel. Ngkíq án tỡ bữn pỡq chuaq noâng ramoon, ariang án cơi táq. Án píh mieiq nhêng chu ntốq aiq; ");
INSERT INTO bru_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","án hữm cũai proai I-sarel táq ntốq ỡt cỡt tỗp cỡt mũ. Raviei Yiang Sursĩ cỡt sốt tâng mứt pahỡm án, ");
INSERT INTO bru_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","chơ án atỡng sacoâiq neq: “Nâi la santoiq Balam con samiang Bê-ô, la santoiq cũai ca têq dáng raloaih lứq, ");
INSERT INTO bru_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","cũai ca têq sâng máh santoiq Yiang Sursĩ pai, án ca cloân nhêng hữm ŏ́c sapáh tễ Yiang Sursĩ Sốt Toâr Lứq. ");
INSERT INTO bru_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Máh dống aroâiq tỗp Yacốp la nêuq o lứq, la ntốq tỗp I-sarel ỡt. ");
INSERT INTO bru_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Alới ki la ariang phong la‑a; ariang rô pễr pứh dỡq; ariang nỡm aluang bữn hỡi phuom chanchức tễ Yiang Sursĩ chóh; ariang aluang sê-da ỡt pễr pứh dỡq. ");
INSERT INTO bru_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Tỗp alới bữn roap dỡq mia sa‑ữi, cớp máh crơng sarnóh alới chóh lứq bữn dũ dỡq. Puo tỗp alới ễ cỡt sốt toâr clữi tễ puo Acac, cớp án lứq sốt sa‑ữi cruang hỡ. ");
INSERT INTO bru_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Yiang Sursĩ khoiq dững tỗp alới loŏh tễ cruang Ê-yip-tô; alới bán rêng ĩn sangũr tê. Alới cachĩt táh nheq máh cũai ễ táq alới, cớp déh nghang cũai ki, déh dếh saráh tamĩang yỗn tacoaih nheq. ");
INSERT INTO bru_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Cũai proai cruang nâi la machớng cula samín rêng lứq. Toâq án bếq, tỡ bữn noau ma khớn amoaih án. Cũai aléq ma câu ŏ́c bốn yỗn cũai I-sarel, cũai ki lứq bữn loah ŏ́c bốn. Ma khân cũai léq ma pupap cũai I-sarel, cũai ki cóq roap loah ŏ́c pupap.” ");
INSERT INTO bru_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Chơ Balac cupỗt atĩ cớp yuor tayứng, yuaq án sâng nsóq lứq. Cớp án pai chóq Balam neq: “Cứq sễq mới toâq pỡ nâi la yỗn mới pupap máh cũai ki, ma pái trỗ nâi chơ mới câu ŏ́c bốn yỗn tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Sanua, cóq mới píh chu loah pỡ dống mới! Cứq ữq ễ culáh cóng yỗn mới, ma Yiang Sursĩ tỡ bữn bũi pahỡm yỗn mới roap máh cóng ki.” ");
INSERT INTO bru_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balam ta‑ỡi loah án neq: “Hếq khoiq atỡng chơ cũai anhia yỗn toâq pỡ hếq, ");
INSERT INTO bru_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","tam anhia ễ chiau nheq práq yễng tễ dống sũ puo, la hếq tỡ têq táq puai rangứh hếq bữm. Ma hếq cóq atỡng ariang Yiang Sursĩ yỗn hếq atỡng sâng.” ");
INSERT INTO bru_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Balam atỡng Balac neq: “Sanua, hếq ễ píh chu loah pỡ vil viang hếq bữm. Ma nhũang hếq ễ ratáh tễ anhia, hếq sễq catoaih anhia la chumát máh cũai I-sarel ễ táq chóq máh cũai proai anhia.” ");
INSERT INTO bru_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balam atỡng santoiq sacoâiq neq: “Nâi la santoiq Balam con samiang Bê-ô, la cũai têq atỡng yỗn dáng raloaih lứq. ");
INSERT INTO bru_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Án têq sâng máh santoiq Yiang Sursĩ ntôm pai. Án bữn roap ŏ́c roan rangoaiq tễ Ncháu sốt clữi nheq tễ canŏ́h. Án cloân nhêng cớp hữm ŏ́c sapáh tễ Yiang Sursĩ Sốt Toâr Lứq. ");
INSERT INTO bru_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Chơ cứq nhêng chu ranáq nỡ‑ra. Cứq hữm máh cũai proai I-sarel. Bữn muoi noaq puo ễ toâq tễ tỗp nâi; án cỡt samoât mantỗr claq poang tâng tỗp alới, cỡt samoât ralỡng khong puo ca toâq tễ tỗp I-sarel. Án ễ cachĩt nheq máh cũai sốt tỗp Mô-ap, dếh cũai proai khong Set hỡ. ");
INSERT INTO bru_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Án chíl riap nheq máh cũai cruang Ê-dôm, chơ cheng ĩt cutễq cũai Ê-dôm cỡt khong alới ễn. Ma cũai I-sarel cỡt rêng achỗn; alới chíl riap níc máh cũai par‑ũal alới. ");
INSERT INTO bru_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Máh cũai I-sarel lứq tĩn sarúq máh cũai sâuq, cớp pupứt máh tỗp noâng tamoong.” ");
INSERT INTO bru_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Vớt ki, Yiang Sursĩ sapáh yỗn Balam hữm cũai proai A-maléc, cớp pai neq: “A-maléc la cũai bữn chớc clữi nheq tễ tỗp canŏ́h, ma toâq tangái parsốt chớc ki cỡt pứt nheq.” ");
INSERT INTO bru_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Yiang Sursĩ noâng sapáh yỗn Balam hữm máh cũai proai Kê-nit; chơ án atỡng sacoâiq neq: “Bân ntốq anhia ỡt nâi la khâm lứq; plot ien khễ ariang sóh chớm táq tâng crang cóh. ");
INSERT INTO bru_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ma anhia tỗp Kê-nit, anhia lứq cỡt cuchĩt pứt nheq, tữ tỗp Asi-ria toâq cỗp anhia dững chu ntốq canŏ́h.” ");
INSERT INTO bru_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balam noâng atỡng sacoâiq tữm neq: “Cũai ntôm ỡt tampống coah angia pỡng la tỗp léq? ");
INSERT INTO bru_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Tỗp rachíl ratáq ỡt tâng tuoc toâq tễ Kit-tim; tỗp alới chíl riap tỗp Asi-ria cớp tỗp Ê-bêr, ma toâq tangái parsốt alới cuchĩt dáp nheq.” ");
INSERT INTO bru_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Chơ Balam píh loah chu pỡ vil viang án, ma Balac pỡq chu canŏ́h. ");
INSERT INTO bru_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Toâq cũai proai I-sarel táq ntốq ỡt pỡ Si-tim, máh cũai samiang tỗp I-sarel mbỡiq bếq parnơi cớp cumũr tỗp Mô-ap. ");
INSERT INTO bru_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Máh mansễm nâi mơi alới pỡq cha bũi tangái tutoŏng yiang khong tỗp Mô-ap. Máh cũai proai I-sarel ki cha crơng sana noau khoiq tutức, ");
INSERT INTO bru_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","cớp alới cucốh rup yiang Ba-al tâng Pê-or hỡ. Yuaq ngkíq, Yiang Sursĩ sâng cutâu mứt chóq tỗp alới, ");
INSERT INTO bru_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","cớp án ớn Môi-se neq: “Cóq mới cỗp nheq máh cũai sốt tỗp I-sarel ca táq ranáq lôih ki, chơ cachĩt táh alới yáng moat cũai clứng; ngkíq cứq tỡ bữn sâng cutâu noâng chóq cũai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ngkíq Môi-se ớn máh cũai sốt neq: “Cóq anhia cachĩt táh dũ náq cũai tễ tỗp anhia ca pỡq cucốh yiang Ba-al tâng Pê-or.” ");
INSERT INTO bru_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Bữn muoi noaq cũai I-sarel dững muoi noaq cumũr tỗp Madian mut tâng dống aroâiq khong án choâng moat Môi-se cớp nheq tữh cũai, bo alới ntôm tanúh ỡt tâng ngoah toong mut chu Dống Sang Aroâiq. ");
INSERT INTO bru_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Toâq Phi-niat con samiang E-lia-sơ, châu Arôn, la cũai tễng rit sang, hữm ngkíq, chơ án saváiq ĩt coih cớp yuor loŏh pỡq tễ cũai clứng, ");
INSERT INTO bru_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","cớp rapuai samiang cớp mansễm ca mut tâng dống aroâiq ki. Chơ án toal coih chóq alới bar náq toau sarloâiq yáng clĩ. Cỗ nhơ tễ ranáq nâi, ỗn ca ntôm cachĩt cũai I-sarel cỡt tangứt toâp. ");
INSERT INTO bru_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ỗn ki khoiq táq yỗn máh cũai I-sarel cuchĩt, 24,000 náq chơ. ");
INSERT INTO bru_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Cỗ nhơ tễ ranáq Phi-niat táq, ngkíq cứq tỡ bữn cutâu mứt noâng chóq cũai proai I-sarel. Án táq tanga lứq chóq tỗp alới ca cucốh rup yiang ca tỡ cỡn cứq. Cỗ nhơ tễ ranáq Phi-niat, yuaq cứq ma tỡ bữn cutâu mứt cớp cachĩt táh nheq tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Yuaq ngkíq, cóq mới atỡng Phi-niat neq: Cứq ễ táq muoi ŏ́c parkhán cớp án, cớp ŏ́c ki ỡt mantái níc; ");
INSERT INTO bru_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","án cớp tŏ́ng toiq án lứq cỡt cũai tễng rit sang cứq mantái níc; cỗ nhơ tễ ranáq án táq chóq cũai ca ễ chíl cứq, ngkíq têq cứq táh lôih yỗn máh cũai proai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Cũai samiang tỗp I-sarel ca noau cachĩt muoi prớh cớp mansễm cũai Madian ki, la Sim-ri con samiang Salu, cũai sốt tâng tỗp Si-mê-ôn. ");
INSERT INTO bru_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Cớp cũai mansễm ki la cũai proai tỗp Madian, ramứh Côt-bi con cumũr Sũr. Sũr la cũai sốt tâng muoi tỗp cũai tễ tŏ́ng toiq Madian. ");
INSERT INTO bru_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yiang Sursĩ ớn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Cóq anhia chíl cũai Madian cớp cachĩt táh nheq tỗp alới, ");
INSERT INTO bru_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","yuaq tỗp alới táq sâuq chóq anhia pỡ vil Pê-or, cớp cỗ tian tễ ranáq Côt-bi, án ca noau cachĩt bo cỡt ỗn.” ");
INSERT INTO bru_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Toâq khoiq vớt ỗn chơ, Yiang Sursĩ ớn Môi-se cớp E-lia-sơ con samiang Arôn neq: ");
INSERT INTO bru_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Cóq anhia chĩc thrỗq nheq tữh cũai samiang tâng dũ dống sũ bữn tễ bar chít cumo achỗn ca têq cỡt tahan.” ");
INSERT INTO bru_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Ngkíq, Môi-se cớp E-lia-sơ táq puai machớng Yiang Sursĩ ớn. Alới arô nheq tữh cũai samiang tễ bar chít cumo achỗn, yỗn toâq rôm parnơi. Tỗp alới toâq rôm parnơi pỡ ntốq cutễq tapín Mô-ap, yáng tooh crỗng Yôr-dan choâng vil Yê-ri-cô. Cũai proai I-sarel ca khoiq loŏh tễ cruang Ê-yip-tô, bữn neq: ");
INSERT INTO bru_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Tễ tỗp Ruben (Ruben la con samiang clúng Yacốp) bữn máh sâu neq: Hanoc, Palu, ");
INSERT INTO bru_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hê-trôn, cớp Car-mi. ");
INSERT INTO bru_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Sâu tỗp nâi bữn thrỗq cũai samiang la 43,730 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Máh tỗp con châu chễ Palu la E-liap ");
INSERT INTO bru_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","cớp máh con samiang E-liap neq: Nê-muol, Dathan, cớp Abi-ram. (Dathan cớp Abi-ram nâi la cũai sốt; ma alới lớn-sarlớn chóq Môi-se cớp Arôn. Alới pruam cớp tỗp Cô-ra, ngkíq alới lớn-sarlớn chóq Yiang Sursĩ tê. ");
INSERT INTO bru_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Cutễq caha lưn mumoong chíq alới. Alới cuchĩt parnơi cớp Cô-ra, dếh tỗp cũai bar culám sỡng chít náq hỡ, bo ũih taluam cat ki. Ranáq nâi la dŏq catoaih atỡng nheq tữh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ma bo ki máh con samiang Cô-ra tỡ bữn cuchĩt.) ");
INSERT INTO bru_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Tễ tỗp Si-mê-ôn bữn máh sâu neq: Nê-muol, Yamin, Yakin, ");
INSERT INTO bru_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Sê-rah, cớp Sau-lơ. ");
INSERT INTO bru_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Tâng máh sâu nâi bữn thrỗq cũai samiang la 22,200 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Tễ tỗp Cát bữn máh sâu neq: Sê-phôn, Haki, Suni ");
INSERT INTO bru_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ot-ni, E-ri, ");
INSERT INTO bru_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arôt, cớp Arê-li. ");
INSERT INTO bru_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Tâng máh sâu nâi bữn thrỗq cũai samiang la 40,500 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Tễ tỗp Yuda bữn máh sâu neq: Sê-lah, Pharêt, Sê-rah, Hê-trôn, cớp Hamul. (Bar náq con samiang Yuda la E-rơ cớp Ô-nan, alới khoiq cuchĩt tâng cruang Cana-an.) ");
INSERT INTO bru_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Tâng máh sâu nâi bữn thrỗq cũai samiang la 76,500 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Tễ tỗp I-sacar bữn máh sâu neq: Tô-la, Puah, ");
INSERT INTO bru_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasup, cớp Sim-rôn. ");
INSERT INTO bru_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Tâng máh sâu nâi bữn thrỗq cũai samiang la 64,300 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Tễ tỗp Sa-bulôn bữn máh sâu neq: Sê-ret, E-lôn, cớp Yalil. ");
INSERT INTO bru_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Tâng máh sâu nâi bữn thrỗq cũai samiang la 60,500 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yô-sep bữn con samiang bar náq, Ma-nasê cớp Ep-ra-im. ");
INSERT INTO bru_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Tễ tỗp Ma-nasê bữn Makir con samiang Ma-nasê; án cỡt mpoaq Ki-liat, cớp máh sâu tễ tŏ́ng toiq Ki-liat bữn neq: ");
INSERT INTO bru_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Yasơ, Hê-léc, ");
INSERT INTO bru_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","A-sariel, Se-kem, ");
INSERT INTO bru_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Sê-mi-da, cớp Hê-phêr. ");
INSERT INTO bru_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Sê-lô-phahat con samiang Hê-phêr ŏ́q con samiang, ma án bữn ống con mansễm sâng, ramứh neq: Mah-la, Nô-ê, Hôc-la, Mil-ca, cớp Tir-sa. ");
INSERT INTO bru_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Thrỗq cũai samiang tâng máh sâu nâi la 52,700 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Tễ tỗp Ep-ra-im bữn máh sâu neq: Suthê-la, Be-ker, cớp Tahan. ");
INSERT INTO bru_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Tễ sâu Suthê-la, bữn sâu E-ran hỡ. ");
INSERT INTO bru_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Thrỗq cũai samiang tâng máh sâu nâi la 32,500 náq. Máh sâu nâi toâq tễ tŏ́ng toiq Yô-sep. ");
INSERT INTO bru_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Tễ tỗp Ben-yamin bữn máh sâu neq: Bê-la, At-bel, Ahi-ram, ");
INSERT INTO bru_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Supham, cớp Hupham. ");
INSERT INTO bru_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Tễ tŏ́ng toiq Bê-la bữn sâu At cớp Naman ễn. ");
INSERT INTO bru_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Thrỗq cũai samiang tâng máh sâu nâi la 45,600 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Tễ tỗp Dan bữn sâu Suham. ");
INSERT INTO bru_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Nheq tữh cũai samiang sâu ki la 64,400 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Tễ tỗp Asêr bữn máh sâu neq: Im-nah, It-vi, cớp Be-ria. ");
INSERT INTO bru_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Tễ tŏ́ng toiq Be-ria bữn sâu Ê-bêr cớp Mal-kiel ễn. ");
INSERT INTO bru_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asêr bữn muoi lám con cumũr, ramứh Sê-rah. ");
INSERT INTO bru_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Thrỗq cũai samiang tâng máh sâu nâi la 53,400 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Tễ tỗp Nep-tali bữn máh sâu neq: Yasiel, Cuni, ");
INSERT INTO bru_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yê-se, cớp Si-lem. ");
INSERT INTO bru_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Thrỗq cũai samiang tâng máh sâu nâi la 45,400 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Parỗm nheq tữh cũai samiang tâng tỗp I-sarel la 601,730 náq. ");
INSERT INTO bru_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Cóq mới tampễq cutễq yỗn dũ tỗp cũai I-sarel, puai thrỗq cũai tâng tỗp. ");
INSERT INTO bru_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","“Tâng ranáq tampễq cutễq trỗ nâi, cóq ĩt crơng séng táq tếc tampễq; tỗp aléq ma bữn cũai clứng, cóq tampễq cutễq yỗn tỗp alới sa‑ữi hỡn. Ma tỗp aléq bữn cũai bĩq sâng, cóq tampễq yỗn tỗp alới bĩq tê.” ");
INSERT INTO bru_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Tỗp Lê-vi bữn máh sâu neq: Kêr-sôn, Cô-hat, cớp Mê-rari. ");
INSERT INTO bru_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Tŏ́ng toiq tỗp alới bữn dếh sâu cớt la neq: Lip-ni, Hep-rôn, Mali, Muchi, cớp Cô-ra. Cô-hat la mpoaq Am-ram. ");
INSERT INTO bru_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Lacuoi Am-ram la Yôc-abet con mansễm Lê-vi; án cỡt tâng cruang Ê-yip-tô. Yôc-abet bữn con samiang bar lám cớp Am-ram, ramứh Arôn cớp Môi-se, cớp bữn muoi lám con mansễm hỡ, ramứh Mi-riam. ");
INSERT INTO bru_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Arôn bữn pỗn náq con samiang, ramứh Nadap, Abi-hu, E-lia-sơ, cớp I-thamar. ");
INSERT INTO bru_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadap cớp Abi-hu cuchĩt bo alới chiau sang yỗn Yiang Sursĩ ũih blữ ca tỡ pĩeiq alới táq. ");
INSERT INTO bru_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Máh cũai samiang tỗp Lê-vi tễ muoi casâi achỗn, bữn thrỗq cũai 23,000 náq. Ma noau tỡ bữn noap amut thrỗq alới tâng thrỗq tỗp I-sarel, yuaq alới tỡ bữn chống mun cớp cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Môi-se cớp E-lia-sơ chĩc máh ramứh sâu cớp máh thrỗq cũai I-sarel bo alới ỡt pỡ cutễq tapín Mô-ap, yáng tooh crỗng Yôr-dan choâng vil Yê-ri-cô. ");
INSERT INTO bru_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Máh cũai Môi-se cớp Arôn chĩc dŏq tâng trỗ muoi, bo alới ỡt tâng ntốq aiq cheq cóh Si-nai, tỡ bữn cũai samiang aléq ma noâng bữn tamoong. ");
INSERT INTO bru_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Yuaq Yiang Sursĩ khoiq pai chơ, dũ náq cũai samiang thrap ki cóq cuchĩt nheq tâng ntốq aiq. Dũ ranáq ki lứq cỡt ngkíq; ma ống Calep con samiang Yê-phunê, cớp Yô-sũa con samiang Nun sâng noâng tamoong. ");
INSERT INTO bru_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Alới sỡng náq Mah-la, Nô-ê, Hôc-la, Mil-ca, cớp Tir-sa la con mansễm Sê-lô-phahat con samiang Hê-phêr, châu Ki-liat, chễ Makir, cớp cho Ma-nasê con samiang Yô-sep. ");
INSERT INTO bru_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Tỗp mansễm nâi tayứng yáng moat Môi-se cớp E-lia-sơ, án ca sốt máh cũai tễng rit sang, cớp bữn máh cũai sốt canŏ́h dếh cũai proai ỡt bân ngoah toong mut Dống Sang Aroâiq. Alới rasễq neq: ");
INSERT INTO bru_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Mpoaq tỗp hếq khoiq cuchĩt tâng ntốq aiq, ma án ŏ́q loâng con samiang. Án tỡ cỡn tễ tỗp Cô-ra ca táq ranáq sâuq chóq Yiang Sursĩ, ma án cuchĩt cỗ tian ŏ́c lôih án bữm. ");
INSERT INTO bru_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Cỗ nŏ́q ramứh mpoaq tỗp hếq ma pứt tháng tễ cũai I-sarel, cỗ tian án ŏ́q con samiang? Sễq anhia yỗn tỗp hếq bữn ndỡm cutễq parnơi cớp sễm ai mpoaq hếq nứng!” ");
INSERT INTO bru_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Môi-se dững partoâq máh ranáq nâi pỡ Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Chơ Yiang Sursĩ atỡng án neq: ");
INSERT INTO bru_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Máh con cumũr Sê-lô-phahat pai pĩeiq lứq. Cóq mới yỗn tỗp alới bữn tê cutễq parnơi cớp sễm ai tŏ́ng toiq mpoaq alới. Pún Sê-lô-phahat, ki chiau yỗn tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Cóq mới atỡng cũai proai I-sarel neq: Khân bữn muoi noaq cũai samiang ma cuchĩt, ma án ŏ́q con samiang, cóq chiau mun án yỗn pỡ con cumũr án ễn ndỡm. ");
INSERT INTO bru_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Khân án ma ŏ́q con mansễm, cóq anhia chiau máh mun ki pỡ sễm ai án ễn ndỡm. ");
INSERT INTO bru_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ma khân án ŏ́q ai tỡ la a‑ễm, cóq mới chiau pỡ sễm ai mpoaq án ễn ndỡm mun ki. ");
INSERT INTO bru_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ma khân mpoaq án la ŏ́q tê sễm ai, cóq mới chiau máh mun ki pỡ tŏ́ng toiq cheq lứq, yỗn alới ki ễn ndỡm. Cóq máh cũai proai I-sarel táq puai phễp rit cứq patâp nâi, yuaq cứq la Yiang Sursĩ anhia.” ");
INSERT INTO bru_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới chỗn chu cóh Aba-rim, chơ tapoang nhêng chu máh cutễq cứq ễ chiau yỗn cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Toâq mới bữn hữm chơ, mới lứq cuchĩt machớng Arôn ai mới tê, ");
INSERT INTO bru_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","yuaq anhia bar náq sễm ai tỡ bữn trĩh máh parnai cứq atỡng bo anhia ỡt tâng ntốq aiq Sin. Bo proai I-sarel bubéq-bubưp chóq cứq tâng ntốq Mê-ri-ba ki, mới calỡih táh chớc blễng cứq choâng moat tỗp alới.” (Dỡq mec Mê-ri-ba la ỡt tâng ntốq Cadet pỡ ntốq aiq Sin.) ");
INSERT INTO bru_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Môi-se câu neq: ");
INSERT INTO bru_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Cucốh Yiang Sursĩ ơi! Anhia la Yiang Sursĩ ca tễng dũ ramứh tamoong. Cứq sễq anhia rưoh manoaq cũai dŏq ayông máh cũai proai nâi. ");
INSERT INTO bru_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Cớp têq án ayông tỗp alới pỡq rachíl, dŏq yỗn cũai proai anhia tỡ bữn cỡt ariang máh cữu ŏ́q cũai mantán bán.” ");
INSERT INTO bru_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yiang Sursĩ atỡng Môi-se neq: “Cóq mới pỡq coâiq Yô-sũa con samiang Nun; án la cũai roan rangoaiq, cớp têq án ayông máh cũai proai nâi. Cóq mới satoaq atĩ tâng plỡ án, táq tếc mới chóh án yỗn cỡt cũai sốt. ");
INSERT INTO bru_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Yỗn án loŏh tayứng choâng moat E-lia-sơ, la cũai tễng rit sang, cớp choâng moat nheq tữh cũai proai. Ỡt tâng ki cóq mới atỡng yỗn cũai canŏ́h dáng án ễn cỡt sốt nheq tữh tỗp alới pláih mới. ");
INSERT INTO bru_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Cóq mới chiau muoi pún chớc mới yỗn án, dŏq nheq tữh cũai proai I-sarel trĩh parnai án. ");
INSERT INTO bru_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Cớp án têq poâng E-lia-sơ, la cũai tễng rit sang, toâq án chuaq yoc ễ dáng ngê cứq na tâc Urim cớp Thumim. Nheq tữh nâi la ranáq E-lia-sơ dŏq ayông Yô-sũa cớp máh cũai proai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Môi-se táq puai máh santoiq Yiang Sursĩ ớn án táq. Chơ án yỗn Yô-sũa loŏh tayứng yáng moat E-lia-sơ, la cũai tễng rit sang, cớp yáng moat máh cũai proai hỡ. ");
INSERT INTO bru_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Chơ án satoaq atĩ tâng plỡ Yô-sũa, cớp pau atỡng án chóh Yô-sũa cỡt sốt pláih án, riang Yiang Sursĩ khoiq atỡng chơ. ");
INSERT INTO bru_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yiang Sursĩ ớn Môi-se ");
INSERT INTO bru_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","atỡng máh cũai I-sarel chiau sang crơng sana dŏq táq yỗn Yiang Sursĩ sâng bũi pahỡm. Cóq alới táq puai tangái khoiq anoat dŏq chơ, la neq: ");
INSERT INTO bru_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","“Crơng sana chiau sang yỗn Yiang Sursĩ cóq bốh cu rangái, bữn neq: Bar lám cữu tôl muoi cumo cớp ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Muoi lám cóq anhia chiau sang pên tarưp; muoi lám ễn cóq chiau sang pên tabữ. ");
INSERT INTO bru_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Dũ lám anhia chiau sang cóq bữn dếh bỗt muoi ki-lô talốc cớp dỡq nsễng o‑li‑vê muoi lit. ");
INSERT INTO bru_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ranáq chiau sang cu rangái cóq bốh yỗn cat nheq, táq puai rit chiau sang crơng sana trỗ muoi pỡ cóh Si-nai. Chơ hỡi phuom tễ crơng chiau sang ki táq yỗn Yiang Sursĩ bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Khân chiau sang blŏ́ng nho muoi lit, cóq chiau sang muoi prớh cớp cữu con ki; chơ tốh tâng Ntốq Tễng Rit. ");
INSERT INTO bru_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Cữu con dŏq chiau sang pên tabữ, cóq anhia táq machớng chiau sang pên tarưp tê. Cóq chiau sang dếh blŏ́ng nho cớp máh thữ racáu hỡ. Chơ hỡi phuom chanchức tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Tâng Tangái Rlu cóq anhia chiau sang bar lám cữu tôl con ŏ́q bân tĩq, bữn muoi cumo, dếh bỗt bar ki-lô talốc cớp dỡq nsễng o‑li‑vê, cớp blŏ́ng nho. ");
INSERT INTO bru_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ranáq bốh charán dŏq chiau sang cóq anhia táq cu Tangái Rlu amóh cớp crơng anhia dốq chiau sang tâng cu rangái, cớp bữn dếh blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Tâng tangái muoi dũ plỡ casâi, máh crơng cóq anhia bốh crơng chiau sang yỗn Yiang Sursĩ bữn neq: Ntroŏq tangcáh bar lám, cữu tôl muoi lám, cữu tôl con bỡiq muoi cumo tapul lám. Máh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ma máh thữ racáu anhia chiau sang, cóq anhia táq bỗt, chơ talốc cớp dỡq nsễng o‑li‑vê, bữn neq: Muoi lám ntroŏq tangcáh cóq yỗn bỗt pái ki-lô; muoi lám cữu tôl cóq yỗn bỗt bar ki-lô; ");
INSERT INTO bru_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","muoi lám cữu con cóq yỗn bỗt muoi ki-lô. Máh crơng bốh sang nâi, la cỡt crơng sana chiau sang. Hỡi phuom tễ crơng sana nâi táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ranáq chiau sang blŏ́ng nho, cóq anhia táq neq: Muoi lám ntroŏq tangcáh, cóq chiau blŏ́ng nho pái lit; muoi lám cữu tôl cóq chiau blŏ́ng nho bar lit; cớp muoi lám cữu tôl con cóq chiau blŏ́ng nho muoi lit. Nâi la rit dŏq bốh chiau sang tâng tangái muoi, dũ plỡ casâi toau nheq cumo. ");
INSERT INTO bru_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Cớp ĩt muoi lám mbễq tangcáh bốh chiau sang yỗn Yiang Sursĩ dŏq pupứt lôih. Ranáq nâi miar tễ crơng anhia bốh chiau sang cu rangái cớp blŏ́ng nho anhia dốq chiau sang. ");
INSERT INTO bru_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Tangái muoi chít la pỗn, casâi muoi, la tangái anhia sanhữ loah Tangái Loŏh tễ cruang Ê-yip-tô, cóq anhia táq rit cha bũi dŏq yám noap Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Tangái muoi chít la sỡng cóq tỗp anhia táq rit cha bũi Tangái Cha Bễng Mi Ŏ́q Crơng Pluoih. Cóq anhia táq rit ki tâng tapul tangái, ma nheq tâng tapul tangái ki cóq anhia cha bễng mi ŏ́q crơng pluoih. ");
INSERT INTO bru_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Tâng tangái anhia mbỡiq táq rit cha sa‑ỡn, cóq anhia rôm parnơi dŏq sang Yiang Sursĩ, cớp anhia chỗi táq ranáq ntrớu tâng tangái ki. ");
INSERT INTO bru_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Cóq anhia táq rit bốh chiau sang yỗn Yiang Sursĩ, ma táq puai tâng rit chiau sang crơng sana neq: Ntroŏq tangcáh bar lám, cữu tôl muoi lám, cớp cữu tôl con bữn muoi cumo tapul lám. Máh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ma charán dũ lám, cóq anhia chiau sang muoi prớh máh thữ racáu, la bỗt talốc cớp dỡq nsễng o‑li‑vê, bữn neq: Muoi lám ntroŏq tangcáh cớp bỗt pái ki-lô; muoi lám cữu tôl cớp bỗt bar ki-lô; ");
INSERT INTO bru_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","muoi lám cữu tôl con cớp bỗt muoi ki-lô. ");
INSERT INTO bru_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Cóq anhia chiau sang muoi lám mbễq tangcáh ễn dŏq pupứt lôih, cớp táq rit sambráh lôih yỗn máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Cóq anhia chiau sang máh crơng nâi tữm cớp ranáq bốh chiau sang cu rangái tâng pên tarưp. ");
INSERT INTO bru_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Táq machớng ki tê toâq anhia bốh crơng sana chiau sang yỗn Yiang Sursĩ tâng nheq tapul tangái. Hỡi phuom tễ crơng chiau sang ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. Cóq anhia chiau sang máh crơng ki tữm cớp crơng bốh sang cu rangái, dếh blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Tâng tangái tapul, cóq anhia rôm sang toam parnơi, cớp chỗi táq ranáq ntrớu. ");
INSERT INTO bru_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Tangái táq rit cha bũi Tangái Susot saro mi, toâq anhia chiau sang máh palâi sarnóh anhia ĩt dâu lứq yỗn Yiang Sursĩ, cóq tỗp anhia toâq rôm parnơi dŏq sang toam Yiang Sursĩ, cớp chỗi táq ranáq ntrớu tâng tangái ki. ");
INSERT INTO bru_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Cóq anhia bốh crơng chiau sang yỗn Yiang Sursĩ, bữn neq: Ntroŏq tangcáh bar lám, cữu tôl muoi lám, cớp tapul lám cữu tôl con bỡiq muoi cumo. Nheq tữh charán nâi cóq ŏ́q bân tĩq. Hỡi phuom tễ crơng sana ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Toâq anhia chiau sang máh thữ racáu, cóq anhia chiau bỗt cớp dỡq nsễng o‑li‑vê, la neq: Muoi lám ntroŏq tangcáh cớp pái ki-lô bỗt; muoi lám cữu tôl cớp bar ki-lô bỗt; ");
INSERT INTO bru_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","muoi lám cữu tôl con cớp muoi ki-lô bỗt. ");
INSERT INTO bru_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Cóq anhia chiau sang muoi lám mbễq tangcáh ễn dŏq chiau sang táq rit pupứt lôih yỗn máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Cóq anhia chiau sang nheq máh crơng nâi cớp blŏ́ng nho, tữm tâng crơng bốh chiau sang, cớp máh thữ racáu hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Tangái muoi, casâi tapul, cóq anhia rôm parnơi dŏq sang toam Yiang Sursĩ, cớp chỗi táq ranáq ntrớu. Tangái ki cóq anhia plóng máh lavia. ");
INSERT INTO bru_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Cóq anhia bốh máh crơng chiau sang yỗn Yiang Sursĩ la neq: Muoi lám ntroŏq tôl, muoi lám cữu tôl, cớp tapul lám cữu tôl con bỡiq muoi cumo. Nheq tữh charán nâi cóq ŏ́q bân tĩq. Hỡi phuom tễ crơng sana ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Cóq anhia chiau sang máh thữ racáu khoiq cỡt bỗt talốc cớp dỡq nsễng o‑li‑vê la neq: Muoi lám ntroŏq tangcáh cớp pái ki-lô bỗt; muoi lám cữu tôl cớp bar ki-lô bỗt; ");
INSERT INTO bru_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","cớp muoi lám cữu con cớp muoi ki-lô bỗt. ");
INSERT INTO bru_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Cớp cóq anhia chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih yỗn máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Tâng tangái muoi dũ plỡ casâi, cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh chiau sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. Nâi la crơng chiau sang yỗn Yiang Sursĩ na ũih, cớp hỡi phuom tễ crơng ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Tangái muoi chít, casâi tapul, cóq tỗp anhia rôm parnơi dŏq sang toam Yiang Sursĩ; ma anhia chỗi cha sana cớp chỗi táq ranáq ntrớu tâng tangái ki. ");
INSERT INTO bru_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Cóq anhia bốh crơng dŏq chiau sang yỗn Yiang Sursĩ, bữn neq: Muoi lám ntroŏq tôl, muoi lám cữu tôl, cớp tapul lám cữu tôl con bỡiq muoi cumo. Ma máh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Toâq anhia chiau sang máh thữ racáu, cóq anhia yỗn bỗt talốc cớp dỡq nsễng o‑li‑vê; muoi lám ntroŏq tôl cớp pái ki-lô bỗt; muoi lám cữu tôl cớp bar ki-lô bỗt; ");
INSERT INTO bru_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","muoi lám cữu tôl con cớp muoi ki-lô bỗt. ");
INSERT INTO bru_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Tangái muoi chít la sỡng, casâi tapul, cóq tỗp anhia rôm parnơi dŏq sang toam Yiang Sursĩ. Cóq anhia táq rit cha bũi nâi dŏq yám noap Yiang Sursĩ tâng tapul tangái, cớp chỗi táq ranáq ntrớu. ");
INSERT INTO bru_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Tâng tangái muoi cóq anhia bốh chiau sang crơng sana yỗn Yiang Sursĩ cớp charán neq: Muoi chít la pái lám ntroŏq tangcáh, bar lám cữu tôl, cớp muoi chít la pỗn lám cữu tôl con bỡiq muoi cumo. Nheq tữh charán nâi cóq ŏ́q bân tĩq. Hỡi phuom tễ crơng sana ki táq yỗn Yiang Sursĩ sâng bũi pahỡm. ");
INSERT INTO bru_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Cóq anhia chiau sang máh thữ racáu cỡt bỗt chơ talốc cớp dỡq nsễng o‑li‑vê la neq: Muoi lám ntroŏq tangcáh cớp pái ki-lô bỗt; muoi lám cữu tôl cớp bar ki-lô bỗt; ");
INSERT INTO bru_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","muoi lám cữu tôl con cớp bữn muoi ki-lô bỗt; cớp chiau sang dếh blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Tâng tangái bar cóq anhia chiau sang ntroŏq tangcáh muoi chít la bar lám, cữu tôl bar lám, cớp cữu tôl con bỡiq muoi cumo, muoi chít la pỗn lám. Nheq tữh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Parnơi cớp máh charán ki, cóq anhia chiau sang máh thữ racáu cớp chiau sang blŏ́ng nho puai tâng rit tangái muoi khoiq anoat dŏq chơ. ");
INSERT INTO bru_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Tâng tangái pái, cóq anhia chiau sang ntroŏq tangcáh muoi chít la muoi lám, cữu tôl bar lám, cớp cữu tôl con bỡiq muoi cumo, muoi chít la pỗn lám. Nheq tữh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","22","Parnơi cớp máh charán ki cóq anhia chiau sang racáu cớp blŏ́ng nho; cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Tâng tangái pỗn cóq anhia chiau sang ntroŏq tangcáh muoi chít lám, cữu tôl bar lám, cớp cữu tôl con bỡiq muoi cumo muoi chít la pỗn lám. Nheq tữh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","25","Parnơi cớp máh charán ki cóq anhia chiau sang racáu cớp blŏ́ng nho; cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Tâng tangái sỡng, cóq anhia chiau sang ntroŏq tangcáh takêh lám, cữu tôl bar lám, cớp cữu tôl con bỡiq muoi cumo, muoi chít la pỗn lám. Nheq tữh máh charán ki cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","28","Parnơi cớp máh charán ki cóq anhia chiau sang racáu cớp blŏ́ng nho; cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Tâng tangái tapoât cóq anhia chiau sang ntroŏq tangcáh tacual lám, cữu tôl bar lám, cớp cữu tôl con bỡiq muoi cumo, muoi chít la pỗn lám. Nheq tữh charán ki cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","31","Parnơi cớp máh charán ki cóq anhia chiau sang racáu cớp blŏ́ng nho; cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Tâng tangái tapul, cóq anhia chiau sang ntroŏq tangcáh tapul lám, cữu tôl bar lám, cớp cữu tôl con bỡiq muoi cumo, muoi chít la pỗn lám. Nheq tữh charán ki cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","34","Parnơi cớp máh charán ki cóq anhia chiau sang racáu cớp blŏ́ng nho; cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Tâng tangái tacual, cóq anhia rôm loah parnơi dŏq sang toam Yiang Sursĩ, cớp chỗi táq ranáq ntrớu. ");
INSERT INTO bru_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Cóq anhia bốh máh crơng chiau sang yỗn Yiang Sursĩ, táq puai rit chiau sang crơng sana la neq: Ntroŏq tangcáh muoi lám, cữu tôl muoi lám, cớp tapul lám cữu tôl con bỡiq muoi cumo. Nheq tữh charán nâi cóq ŏ́q bân tĩq. ");
INSERT INTO bru_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","Parnơi cớp máh charán ki cóq anhia chiau sang racáu cớp blŏ́ng nho; cớp cóq anhia bốh chiau sang muoi lám mbễq tangcáh ễn dŏq táq rit pupứt lôih. Cóq anhia chiau sang máh crơng nâi tữm cớp crơng bốh sang tâng cu rangái, dếh máh thữ racáu cớp blŏ́ng nho hỡ. ");
INSERT INTO bru_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Nâi la máh phễp rit tễ ranáq bốh crơng sang, ranáq chiau sang máh thữ racáu, ranáq chiau sang blŏ́ng nho, cớp ranáq chiau sang yỗn cỡt ratoi loah. Máh crơng anhia chiau sang yỗn Yiang Sursĩ puai phễp rit cha bũi khoiq anoat dŏq. Ranáq nâi tữm cớp ranáq chiau crơng sang khoiq par‑ữq dŏq chơ, tỡ la chiau sang puai mứt sâng yoc.” ");
INSERT INTO bru_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ngkíq, Môi-se atỡng máh cũai proai I-sarel yỗn táq puai máh santoiq Yiang Sursĩ khoiq ớn na án. ");
INSERT INTO bru_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Yiang Sursĩ ớn Môi-se atỡng máh cũai sốt tâng tỗp dáng tễ phễp rit yỗn nheq tữh cũai I-sarel táq puai la neq: ");
INSERT INTO bru_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“Toâq cũai samiang aléq ma par‑ữq yoc ễ yỗn crơng ntrớu pỡ Yiang Sursĩ, tỡ la án parkhán ễ ót muoi ramứh, án tỡ têq táh ŏ́c parkhán ki, ma cóq án táq dũ ŏ́c án khoiq pai chơ. ");
INSERT INTO bru_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Toâq bữn cũai cumũr noâng ỡt tâng dống mpoaq án, ma án ữq ễ chiau sang crơng yỗn Yiang Sursĩ, tỡ la án parkhán ễ ót tễ muoi ramứh ntrớu, ");
INSERT INTO bru_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","cóq án táq puai máh ŏ́c án khoiq par‑ữq chơ. Ma khân mpoaq án dáng tễ ranáq ki cớp sưoq tỡ yỗn án táq puai, ");
INSERT INTO bru_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","mansễm ki têq racláh tễ ŏ́c án khoiq parkhán. Lứq Yiang Sursĩ táh lôih yỗn án, yuaq mpoaq án tỡ bữn pruam máh ŏ́c án khoiq par‑ữq. ");
INSERT INTO bru_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Khân bữn cũai mansễm ma tỡ yũah ĩt cayac, ma án lơ thễ dũan, tỡ la par‑ữq ŏ́c ntrớu; ma ntun án ĩt cayac, ");
INSERT INTO bru_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","cóq án táq dũ ramứh án khoiq par‑ữq; khân cayac án dáng tễ ŏ́c ki ma tỡ bữn pai ntrớu, ki cóq án táq puai máh ŏ́c án khoiq par‑ữq. ");
INSERT INTO bru_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ma khân cayac án dáng tễ ŏ́c án par‑ữq, cớp án tỡ bữn pruam yỗn lacuoi án táq, ki lacuoi án tỡ bữn túh cóq táq puai noâng. Cớp Yiang Sursĩ lứq táh lôih yỗn mansễm ki. ");
INSERT INTO bru_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Khân bữn mpiq riang, tỡ la cán cumai thễ dũan ntrớu, cóq án táq puai máh ŏ́c án khoiq thễ dũan, tỡ la ŏ́c ntrớu án khoiq par‑ữq chơ. ");
INSERT INTO bru_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Khân mansễm aléq ma khoiq ĩt cayac chơ, ma án thễ dũan tỡ la par‑ữq ntrớu; ");
INSERT INTO bru_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","toâq cayac án sâng tễ ŏ́c ki ma tỡ bữn pai ntrớu tỡ la sưoq lacuoi án, mansễm ki cóq táq puai dũ ramứh ki. ");
INSERT INTO bru_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ma khân cayac án dáng máh ranáq ki, cớp án tỡ yỗn lacuoi án táq puai máh ŏ́c án khoiq par‑ữq, ngkíq lacuoi án tỡ bữn cóq táq puai noâng ŏ́c ki. Cớp Yiang Sursĩ lứq táh lôih án, cỗ cayac án tỡ yỗn táq puai máh ŏ́c par‑ữq ki. ");
INSERT INTO bru_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Cayac án têq pruam tỡ la pupứt máh ŏ́c lacuoi án khoiq thễ dũan tỡ la khoiq par‑ữq. ");
INSERT INTO bru_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ma khân tangái léq cayac án sâng tễ ranáq ki ma tỡ bữn cartáng, ki mansễm ki cóq táq puai dũ ramứh máh án khoiq thễ dũan tỡ la par‑ữq chơ. Ma tâng tangái cayac án sâng tễ ranáq ki ma tỡ bữn pai ntrớu, ki la machớng án pruam tê. ");
INSERT INTO bru_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ma khân ntun ki cayac án tỡ bữn pruam, chơ cayac án cóq roap nheq máh lôih lacuoi án khoiq táq.” ");
INSERT INTO bru_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Nâi la máh phễp rit dŏq atỡng yỗn cũai mansễm ca tỡ yũah ĩt cayac cớp noâng ỡt parnơi cớp mpiq mpoaq, tỡ la mansễm khoiq ĩt cayac chơ. Máh ranáq nâi la Yiang Sursĩ khoiq chiau yỗn Môi-se atỡng. ");
INSERT INTO bru_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Cóq mới pỡq carláh dỡq chóq máh cũai proai Madian, cỗ tian ranáq alới khoiq táq chóq máh cũai I-sarel chơ. Vớt tễ ki, mới lứq cuchĩt.” ");
INSERT INTO bru_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Yuaq ngkíq, Môi-se atỡng cũai I-sarel neq: “Cóq anhia thrũan pỡq chíl cũai Madian; chơ pupứt nheq máh tỗp alới, cỗ tian ranáq alới khoiq táq chóq Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Tễ dũ tỗp cũai I-sarel, cóq rưoh ĩt muoi ngin náq tahan dŏq pỡq rachíl.” ");
INSERT INTO bru_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Yuaq ngkíq, dũ tỗp cóq rưoh ĩt samiang muoi ngin náq; parỗm nheq tữh la bữn 12,000 thrũan pỡq rachíl. ");
INSERT INTO bru_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Môi-se ớn Phi-niat con samiang E-lia-sơ, la cũai tễng rit sang, dững tỗp tahan ki loŏh pỡq rachíl. Phi-niat bữn mpỗl dŏq nhêng máh crơng tâng Ntốq Tễng Rit cớp máh lavia dŏq plóng atỡng yỗn pỡq rachíl. ");
INSERT INTO bru_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Chơ tỗp alới mut chíl cũai Madian puai santoiq Yiang Sursĩ khoiq ớn na Môi-se. Tỗp alới cachĩt táh nheq máh cũai samiang Madian, ");
INSERT INTO bru_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","cớp sỡng plỡ puo cũai Madian la ramứh neq: E-vi, Rê-kem, Sũr, Hơr, cớp Rê-ba. Tỗp alới bữn cachĩt dếh Balam la con samiang Bê-ô hỡ. ");
INSERT INTO bru_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Tỗp I-sarel cỗp máh cũai mansễm Madian cớp tỗp carnễn; cớp alới ĩt nheq máh ntroŏq, cữu, cớp sanốc ntữn tễ cruang cũai Madian dững achu nheq. ");
INSERT INTO bru_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Chơ alới chŏ́ng talốh nheq máh vil cớp ntốq canŏ́h cũai Madian ỡt. ");
INSERT INTO bru_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Tỗp alới ĩt pốih nheq máh crơng, dếh cũai cớp charán hỡ. ");
INSERT INTO bru_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Chơ alới chiau nheq ramứh ki yỗn Môi-se, E-lia-sơ, cớp máh cũai proai I-sarel ca ỡt tâng ntốq cutễq tapín Mô-ap, yáng tooh crỗng Yôr-dan choâng cớp vil Yê-ri-cô. ");
INSERT INTO bru_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Môi-se, E-lia-sơ, cớp nheq tữh cũai sốt tễ dũ tỗp, alới loŏh tễ vil, dŏq roap chỗm máh tỗp tahan ki chu. ");
INSERT INTO bru_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Môi-se nhôp máh cũai sốt tahan, alới ca sốt muoi ngin náq, cớp alới ca sốt muoi culám náq, toâq alới chu tễ rachíl. ");
INSERT INTO bru_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Án blớh alới neq: “Cỗ nŏ́q anhia dŏq máh mansễm nâi noâng tamoong? ");
INSERT INTO bru_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Nŏ́q anhia tỡ bữn sanhữ tỡ tễ máh mansễm tỗp Madian, alới trĩh santoiq Balam, cớp alới rakiauq táq yỗn cũai proai táq ranáq tỡ pĩeiq yáng moat Yiang Sursĩ tâng cóh Pê-or? Cỗ ngkíq, yuaq bữn ỗn toâq pỡ cũai proai Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ngkíq sanua cóq anhia cachĩt táh nheq máh cũai carnễn samiang cớp dũ náq mansễm ca khoiq bếq parnơi cớp samiang. ");
INSERT INTO bru_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ma máh cũai cumũr noâng plot o, têq dŏq loah yỗn anhia bữm. ");
INSERT INTO bru_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Sanua tỗp anhia ca khoiq cachĩt cũai, tỡ la yống sac cumuiq, cóq anhia loŏh ỡt yáng tiah vil tapul tangái. Ma tâng tangái pái cớp tangái tapul, tỗp anhia cớp máh cũai ca anhia cỗp, cóq nheq tữh anhia sambráh tỗ chác puai rit. ");
INSERT INTO bru_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Cớp cóq anhia táq rit sambráh dếh máh tampâc cớp dũ ramứh crơng táq toâq ngcâr charán, sóc mbễq, tỡ la tễ aluang.” ");
INSERT INTO bru_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","E-lia-sơ la cũai tễng rit sang, án atỡng máh tỗp alới ca mbỡiq chu tễ rachíl ki neq: “Nâi la phễp rit Yiang Sursĩ atỡng na Môi-se. ");
INSERT INTO bru_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Dũ ramứh ũih tỡ têq cat la neq: Yễng, práq, sapoan, tac, lapan, cớp trac, ");
INSERT INTO bru_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","cóq anhia chóq crơng ki tâng ũih dŏq sambráh puai rit. Chơ cóq anhia táq rit sambráh crơng ki na dỡq ễn. Cớp dũ ramứh canŏ́h ca lahĩr ũih cóq anhia táq rit sambráh na dỡq tê. ");
INSERT INTO bru_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Tâng tangái tapul cóq tỗp anhia pooh tampâc yỗn bráh; ki nŏ́q tỗp anhia cỡt bráh puai santoiq Yiang Sursĩ patâp, cớp têq anhia mut loah tâng vil.” ");
INSERT INTO bru_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yiang Sursĩ atỡng Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Mới cớp E-lia-sơ, dếh cũai sốt dũ tỗp hỡ, cóq anhia ngih nheq máh crơng tahan ki khoiq pũr bữn, dếh cũai cớp charán hỡ. ");
INSERT INTO bru_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Chơ cóq anhia tampễq máh ramứh ki cỡt bar pún lĩ-ralĩ, muoi pún yỗn tỗp tahan, ma muoi pún ễn yỗn máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ma tễ pún tahan, cóq dŏq loah yỗn Yiang Sursĩ muoi pún tễ sỡng culám pún, dếh cũai, dếh ntroŏq, aséh dễn, cữu, cớp mbễq. ");
INSERT INTO bru_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Chơ cóq chiau pún nâi pỡ E-lia-sơ la cũai tễng rit sang, yỗn cỡt pún Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ma tễ máh pún cũai proai I-sarel, cóq anhia ĩt dŏq loah muoi pún tễ sỡng chít pún, chơ chiau yỗn tỗp Lê-vi, alới ca nhêng salĩq Dống Sang Aroâiq Yiang Sursĩ. Tỡ bữn tampễq ống cũai sâng, ma tampễq dếh máh ntroŏq, aséh dễn, cữu, cớp mbễq hỡ.” ");
INSERT INTO bru_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Môi-se cớp E-lia-sơ, táq dũ ramứh puai máh santoiq Yiang Sursĩ khoiq ớn alới táq. ");
INSERT INTO bru_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Máh ramứh crơng tỗp tahan khoiq pũr ĩt chơ la neq: Cữu bữn 675,000 lám, ");
INSERT INTO bru_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ntroŏq bữn 72,000 lám, ");
INSERT INTO bru_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","aséh dễn 61,000 lám, ");
INSERT INTO bru_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","cớp máh cumũr la 32,000 náq. ");
INSERT INTO bru_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ma tadĩ pún khong cũai tahan bữn cữu cớp mbễq nheq tữh 337,500 lám. ");
INSERT INTO bru_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Ma 675 lám la dŏq chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ma tễ ntroŏq 36,000, alới dŏq 72 lám chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Cớp tễ aséh dễn 30,500 lám, alới dŏq 61 lám chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Cớp tễ máh cumũr 16,000 náq, alới dŏq 32 náq chiau sang yỗn Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ngkíq Môi-se chiau máh crơng ki yỗn E-lia-sơ la cũai tễng rit sang Yiang Sursĩ, táq puai dũ ramứh machớng Yiang Sursĩ khoiq ớn án táq. ");
INSERT INTO bru_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ma máh pún cũai proai cớp pún tahan bữn lĩ-ralĩ la neq: ");
INSERT INTO bru_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Cữu cớp mbễq 337,500, ");
INSERT INTO bru_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ntroŏq 36,000 lám, ");
INSERT INTO bru_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","aséh dễn 30,500 lám, ");
INSERT INTO bru_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","cớp máh cumũr 16,000 náq. ");
INSERT INTO bru_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Chơ Môi-se ĩt muoi pún tễ sỡng chít pún khong cũai I-sarel, dếh cũai cớp charán hỡ dŏq chiau loah yỗn tỗp Lê-vi, yuaq tỗp nâi nhêng salĩq Dống Sang Aroâiq Yiang Sursĩ. Án táq dũ ramứh puai machớng Yiang Sursĩ ớn án táq. ");
INSERT INTO bru_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Chơ máh cũai sốt tahan pỡq ramóh Môi-se, ");
INSERT INTO bru_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","cớp atỡng án neq: “Achuaih ơi! Tỗp hếq khoiq ngih chơ máh tỗp tahan ca hếq nhêng salĩq; tỡ bữn noau cuchĩt pứt mŏ. ");
INSERT INTO bru_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Yuaq ngkíq, tỗp hếq dững máh crơng ra‑ỗt táq toâq yễng ca hếq pũr ĩt la neq: Cŏ́ng, sarcŏ́ng atĩ, sambễt, latai, cớp sanoâc. Tỗp hếq sễq chiau máh crơng nâi yỗn Yiang Sursĩ thái loah dỡi tamoong hếq.” ");
INSERT INTO bru_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Môi-se cớp E-lia-sơ roap ĩt máh crơng alới dững chiau sang ki la moang crơng yễng. ");
INSERT INTO bru_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Máh crơng yễng cũai sốt tahan dững chiau sang trỗ nâi, khân noau cân, ntâng sám bar culám ki-lô. ");
INSERT INTO bru_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Ma máh tỗp tahan miat sâng, alới miar ĩt dŏq crơng ki cỡt crơng alới bữm. ");
INSERT INTO bru_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Ngkíq, Môi-se cớp E-lia-sơ dững máh yễng ki dŏq pỡ Dống Sang Aroâiq, ễq Yiang Sursĩ bán kĩaq máh cũai proai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Tỗp Ruben cớp tỗp Cát bữn charán sa‑ữi lứq. Toâq alới hữm cruang cutễq Yasơ cớp Ki-liat têq yỗn alới bán máh charán, ");
INSERT INTO bru_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ngkíq tỗp alới pỡq ramóh Môi-se, E-lia-sơ la cũai tễng rit sang, dếh cũai sốt máh cũai proai I-sarel. Chơ alới atỡng neq: ");
INSERT INTO bru_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Máh vil A-tarôt, Di-bôn, Yasơ, Nim-ra, Hê-sabôn, E-lia-le, Sê-bam, Ni-bô, cớp Bien, ");
INSERT INTO bru_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","máh ntốq nâi Yiang Sursĩ yỗn cũai I-sarel chíl riap chơ. Ntốq nâi la o yỗn têq bán máh charán, cớp tỗp hếq bữn sa‑ữi charán. ");
INSERT INTO bru_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Sễq anhia yỗn máh ntốq nâi cỡt cruang cutễq tỗp hếq, cớp chỗi yỗn tỗp hếq yang crỗng Yôr-dan táq dống yáng tooh ki.” ");
INSERT INTO bru_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Môi-se blớh loah tỗp alới neq: “Nŏ́q tỗp anhia yoc ễ tacu níc nâi tỡ, bo sễm ai anhia loŏh pỡq rachíl? ");
INSERT INTO bru_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Cỗ nŏ́q tỗp anhia táq yỗn cũai proai I-sarel pê pahỡm, chơ tỡ ễq yang noâng crỗng Yôr-dan, la ntốq Yiang Sursĩ khoiq par‑ữq ễ yỗn tỗp alới chơ? ");
INSERT INTO bru_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Bo ỡt tâng cruang Cadet Barnia, cứq ớn máh mpoaq anhia pỡq tutuaiq nhêng cruang cutễq ki, ma tỗp alới táq machớng tỗp anhia tê. ");
INSERT INTO bru_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Alới pỡq toâq pỡ avúng Et-côn, chơ alới tapoang nhêng cớp hữm nheq máh cruang cutễq ki. Ma alới píh chu loah cớp táq ntỡng prưt ễq yỗn cũai proai sâng ngcŏh, chơ tỡ khớn mut chu cruang cutễq Yiang Sursĩ khoiq chiau yỗn tỗp alới. ");
INSERT INTO bru_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Tâng tangái ki toâp Yiang Sursĩ sâng cutâu lứq, cớp án thễ dũan pai neq: ");
INSERT INTO bru_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Cứq sễq thễ dũan chóq alới ki neq: Cỗ tỗp alới tỡ bữn tanoang tapứng chóq cứq, tỡ bữn cũai samiang aléq tâng tỗp ca loŏh tễ cruang Ê-yip-tô, noap tễ bar chít cumo achỗn, ma têq mut chu cruang cutễq cứq khoiq par‑ữq yỗn A-praham, I-sac, cớp Yacốp.’ ");
INSERT INTO bru_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ranáq nâi dŏq atỡng yỗn nheq tữh cũai dáng ống Calep con samiang Yê-phunê tễ tỗp Kê-ni-sit, cớp Yô-sũa con samiang Nun, ống alới sâng táq tanoang o chóq Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Yiang Sursĩ sâng cutâu lứq chóq tỗp I-sarel; chơ án táq yỗn alới pỡq viel atứng atooc tâng ntốq aiq nheq pỗn chít cumo toau cuchĩt nheq máh dỡi cũai táq lôih chóq Yiang Sursĩ. ");
INSERT INTO bru_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ma sanua nâi tỗp anhia ntôm ễ táq machớng achúc achiac anhia tê. Cũai thrap tamái nâi táq níc ranáq sâuq sâng choâng moat Yiang Sursĩ. Ngkíq, Yiang Sursĩ sâng cutâu mứt chóq cũai I-sarel sĩa. ");
INSERT INTO bru_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Khân anhia tỗp Ruben cớp tỗp Cát ma tỡ bữn táq puai máh parnai Yiang Sursĩ khoiq atỡng, ki án táh yỗn tỗp nâi ỡt tâng ntốq aiq trỗ bar ễn, cớp anhia lứq roap panôiq toâq cũai I-sarel cỡt ralốh.” ");
INSERT INTO bru_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Chơ tỗp alới mut cheq Môi-se cớp pai neq: “Nhũang lứq, tỗp hếq sễq táq cantruang toâq tamáu dŏq caruang máh charán cữu, cớp táq viang khâm lavíng vil dŏq curiaq con lacuoi hếq. ");
INSERT INTO bru_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Moâm ki tỗp hếq pruam pỡq cớp máh tỗp I-sarel canŏ́h; hếq ễ mut chíl toau bữn cruang cutễq yỗn tỗp alới. Ma bo ki máh con lacuoi hếq bữn ỡt coah nâi tâng vil bữn viang khâm lứq. Chơ alới bữn ỡt ien khễ vớt tễ talang atĩ cũai proai tâng cruang nâi. ");
INSERT INTO bru_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Tỗp hếq tỡ bữn coâp ễ píh chu pỡ dống hếq bữm, toau nheq tữh sễm ai cũai I-sarel bữn roap cruang cutễq cỡt khong alới voai. ");
INSERT INTO bru_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Tỗp hếq tỡ bữn ĩt noâng máh cruang cutễq ỡt yáng tooh crỗng Yôr-dan, yuaq tỗp hếq khoiq bữn chơ cutễq yáng coah angia mandang loŏh.” ");
INSERT INTO bru_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Môi-se ta‑ỡi neq: “Khân lứq tỗp anhia yoc ễ táq ngkíq, cóq anhia pruam ỡt tayứng tâng ntốq nâi yáng moat Yiang Sursĩ. Chơ anhia thrũan crơng choac dŏq pỡq rachíl. ");
INSERT INTO bru_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Máh tỗp tahan tễ anhia dũ náq cóq yang crỗng Yôr-dan; Yiang Sursĩ lứq ayông máh tỗp anhia mut chíl cũai par‑ũal ki, toau toâq Yiang Sursĩ yỗn anhia chíl riap máh tỗp ki, ");
INSERT INTO bru_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","cớp sễm ai anhia bữn ndỡm nheq máh cruang cutễq ki cỡt khong alới ễn. Vớt tễ ki tỗp anhia têq píh chu loah, cỗ nhơ tỗp anhia táq puai máh ŏ́c anhia khoiq par‑ữq chóq Yiang Sursĩ cớp chóq cũai I-sarel hỡ. Ngkíq Yiang Sursĩ ễ yỗn anhia bữn ndỡm cruang coah angia mandang loŏh. ");
INSERT INTO bru_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ma khân tỗp anhia ma tỡ bữn táq puai máh ŏ́c anhia khoiq par‑ữq chơ, cứq sễq catoaih atỡng anhia la anhia táq lôih chóq Yiang Sursĩ. Khân anhia táq ranáq lôih ngkíq, chỗi dớt ntrớu ŏ́c túh coat toâq pỡ anhia. ");
INSERT INTO bru_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Yuaq ngkíq, anhia têq táq vil yỗn tỗp mansễm cớp carnễn, cớp caruang nheq máh charán anhia, ma cóq anhia táq puai dũ ramứh anhia khoiq par‑ữq cớp Yiang Sursĩ!” ");
INSERT INTO bru_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Proai Cát cớp proai Ruben, alới pruam cớp Môi-se cớp pai neq: “Achuaih ơi! Tỗp hếq lứq táq puai machớng achuaih ớn. ");
INSERT INTO bru_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Máh tỗp con lacuoi hếq cớp charán hếq lứq bữn ỡt tâng máh vil cruang Ki-liat nâi. ");
INSERT INTO bru_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ma máh tỗp hếq bữn thrũan pỡq rachíl, táq puai máh santoiq Yiang Sursĩ khoiq ớn chơ. Tỗp hếq ễ yang crỗng Yôr-dan, pỡq rachíl puai santoiq achuaih khoiq ớn.” ");
INSERT INTO bru_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Ngkíq Môi-se ớn E-lia-sơ, Yô-sũa, cớp máh cũai sốt tỗp I-sarel canŏ́h hỡ neq: ");
INSERT INTO bru_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Khân proai Cát cớp proai Ruben yang crỗng Yôr-dan pỡq rachíl táq puai máh santoiq Yiang Sursĩ khoiq ớn, cớp khân alới chíl chuai anhia bữn cruang cutễq nâi, cóq anhia chiau cruang cutễq Ki-liat yỗn cỡt cruang alới. ");
INSERT INTO bru_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ma khân tỗp alới tỡ ễq yang pỡq rachíl chuai tỗp anhia, cóq alới roap cutễq tâng cruang Cana-an machớng anhia tê.” ");
INSERT INTO bru_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Proai Cát cớp proai Ruben ta‑ỡi neq: “Achuaih ơi! Tỗp hếq sễq táq puai máh santoiq Yiang Sursĩ atỡng. ");
INSERT INTO bru_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Cỗ nhơ chớc blễng tễ Yiang Sursĩ, tỗp hếq ễ yang crỗng Yôr-dan, chơ mut chíl tâng cruang Cana-an; ma cutễq hếq yoc ndỡm la cutễq ỡt coah angia mandang loŏh crỗng Yôr-dan nâi.” ");
INSERT INTO bru_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ngkíq, Môi-se chiau cruang cutễq ki yỗn tỗp Cát, tỗp Ruben, cớp tadĩ tỗp Ma-nasê con samiang Yô-sep la neq: Nheq tữh máh cruang cutễq Si-hôn la puo cũai Amô-rit, cớp cruang cutễq Oc la puo cũai Basan, dếh máh vil cớt vil toâr ỡt mpễr ki hỡ. ");
INSERT INTO bru_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Tỗp Cát táq loah tamái máh vil neq: Di-bôn, A-tarôt, Arô-er, ");
INSERT INTO bru_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrôt Sô-phan, Yasơ, Yôc-baha, ");
INSERT INTO bru_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nim-ra, cớp Bet Haran. ");
INSERT INTO bru_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Cớp tỗp Ruben táq loah tamái máh vil neq: Hê-sabôn, E-lia-le, Ki-ria-têm, ");
INSERT INTO bru_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Ni-bô, Ba-al Mi-ôn (máh ramứh vil ki noau amứh tamái ễn), cớp Sip-ma. Tỗp alới amứh ramứh tamái máh vil alới táq loah tamái. ");
INSERT INTO bru_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Tŏ́ng toiq Makir con samiang Ma-nasê, alới mut talốh nheq cruang cutễq Ki-liat, cớp tuih aloŏh nheq cũai proai Amô-rit ca ỡt tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ngkíq Môi-se chiau cruang Ki-liat yỗn tŏ́ng toiq Makir tễ tỗp Ma-nasê, cớp tỗp alới ỡt loâng tâng ntốq ki. ");
INSERT INTO bru_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yai tễ tŏ́ng toiq Ma-nasê, án chíl tê bữn máh vil mpễr ki; chơ án amứh máh vil ki la ‘Máh Vil Yai’. ");
INSERT INTO bru_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Cớp Nô-ba chíl ĩt vil Kê-nat, dếh máh vil cớt ỡt mpễr ki. Chơ án amứh vil ki puai ramứh án bữm, la vil Nô-ba. ");
INSERT INTO bru_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Tâng ntốq nâi ễ atỡng tễ ramứh máh ntốq cũai I-sarel ỡt dỡ bo alới loŏh tễ cruang Ê-yip-tô. Môi-se cớp Arôn ayông rana máh cũai proai pỡq. ");
INSERT INTO bru_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Puai máh santoiq Yiang Sursĩ ớn, chơ Môi-se chĩc dŏq máh ramứh ntốq alới ỡt dỡ bo alới pỡq tâng rana. ");
INSERT INTO bru_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Proai cũai I-sarel loŏh tễ cruang Ê-yip-tô tâng tangái muoi chít la sỡng, casâi muoi, tâng cumo ki. Tangái ki la tangái ntun alới táq rit sanhữ Tangái Loŏh. Nhơ tễ chớc Yiang Sursĩ curiaq rabán, ngkíq tỗp alới loŏh tễ vil Ram-sê, chơ pỡq pha yáng moat cũai Ê-yip-tô, ");
INSERT INTO bru_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","bo cũai Ê-yip-tô ntôm tứp máh con samiang clúng ca Yiang Sursĩ khoiq cachĩt. Yiang Sursĩ táq ngkíq, dŏq apáh yỗn tỗp alới dáng chớc Yiang Sursĩ la sốt toâr clữi tễ máh yiang cũai Ê-yip-tô dốq cucốh sang. ");
INSERT INTO bru_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Cũai proai I-sarel loŏh tễ vil Ram-sê, chơ alới táq ntốq ỡt dỡ tâng vil Sucôt. ");
INSERT INTO bru_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Vớt ki alới táq ntốq ỡt dỡ tâng vil E-tham, kễng ntốq aiq. ");
INSERT INTO bru_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Tễ E-tham tỗp alới píh láp loah chu ntốq Pi Hahi-rot yáng angia mandang loŏh vil Ba-al Sê-phon. Moâm ki, alới táq ntốq ỡt dỡ cheq vil Mic-dôl. ");
INSERT INTO bru_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Tỗp alới loŏh tễ Pi Hahi-rot, chơ pỡq pha dỡq mưt Cusâu cớp mut chu ntốq aiq E-tham. Toâq alới pỡq tâng rana bữn pái tangái chơ, alới táq ntốq ỡt dỡ tâng ntốq Marah ễn. ");
INSERT INTO bru_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Tễ Marah alới pỡq toâq pỡ E-lim la ntốq bữn mec dỡq muoi chít la bar ntốq cớp bữn tapul chít nỡm tarễc. Alới táq ntốq ỡt dỡ tâng ki. ");
INSERT INTO bru_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Tỗp alới loŏh tễ E-lim, chơ táq ntốq ỡt dỡ cheq dỡq mưt Cusâu ");
INSERT INTO bru_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Vớt tễ ki alới táq ntốq ỡt dỡ tâng ntốq aiq Sín. ");
INSERT INTO bru_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Moâm ki, alới táq ntốq ỡt dỡ tâng Dop-ca. ");
INSERT INTO bru_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Tễ Dop-ca alới toâq pỡ Aluih. ");
INSERT INTO bru_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Vớt tễ ki, chơ tỗp alới toâq pỡ Rê-phi-dim, la ntốq ŏ́q dỡq nguaiq. ");
INSERT INTO bru_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Alới loŏh tễ Rê-phi-dim, chơ pỡq ỡt dỡ tâng ntốq aiq Si-nai. ");
INSERT INTO bru_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Alới loŏh tễ ntốq aiq Si-nai, chơ pỡq ỡt dỡ tâng nheq máh ntốq nâi: Ki-brôt Ha-tava, ");
INSERT INTO bru_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Hasê-rôt, ");
INSERT INTO bru_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Rit-ma, ");
INSERT INTO bru_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ri-môn Pharêt, ");
INSERT INTO bru_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Lip-na, ");
INSERT INTO bru_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ri-sa, ");
INSERT INTO bru_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Kê-hê-latha, ");
INSERT INTO bru_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Cóh Sê-phêr, ");
INSERT INTO bru_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Hara-da, ");
INSERT INTO bru_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Makhê-lot, ");
INSERT INTO bru_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Tahát, ");
INSERT INTO bru_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Thara, ");
INSERT INTO bru_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Mit-ca, ");
INSERT INTO bru_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Hat-mô-na, ");
INSERT INTO bru_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Mô-sarot, ");
INSERT INTO bru_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Be-ne Yacan, ");
INSERT INTO bru_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Hor Hakit-cat, ");
INSERT INTO bru_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Yôt-batha, ");
INSERT INTO bru_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Abrô-na, ");
INSERT INTO bru_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Ê-si-ôn Ki-bơ, ");
INSERT INTO bru_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ntốq aiq Sin tâng Cadet, ");
INSERT INTO bru_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","cớp cóh Hor ỡt yáng raloan cruang cutễq cũai Ê-dôm. ");
INSERT INTO bru_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","Tâng ntốq ki Yiang Sursĩ ớn Arôn, la cũai tễng rit sang, chỗn tâng cóh Hor. Chơ án cuchĩt tâng cóh ki la tangái muoi, casâi sỡng, cumo pỗn chít vớt cũai I-sarel loŏh tễ cruang Ê-yip-tô. Arôn khoiq bữn muoi culám bar chít la pái cumo chơ. ");
INSERT INTO bru_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Puo cũai Arat ca ỡt coah angia cadỡp cruang Cana-an, án sâng han cũai I-sarel ntôm pỡq tâng rana, cớp cheq ễ toâq. ");
INSERT INTO bru_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Tễ cóh Hor toau toâq ntốq cutễq tapín Mô-ap, cũai I-sarel táq máh ntốq ỡt dỡ la neq: Sal-mô-na, ");
INSERT INTO bru_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Punôn, ");
INSERT INTO bru_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Ô-bôt, ");
INSERT INTO bru_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ntốq ralốh-ralái noau dŏq Aba-rim, ỡt cheq raloan cruang Mô-ap, ");
INSERT INTO bru_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Di-bôn Cát, ");
INSERT INTO bru_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Al-môn Dip-lathêm, ");
INSERT INTO bru_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","máh cóh Aba-rim cheq cớp cóh Ni-bô, ");
INSERT INTO bru_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","cớp ỡt tâng ntốq cutễq tapín Mô-ap coah crỗng Yôr-dan choâng cớp vil Yê-ri-cô, ");
INSERT INTO bru_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","mpứng dĩ Bet Yê-samôt cớp avúng cóh Aben Si-tim. ");
INSERT INTO bru_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Tâng ntốq cutễq tapín Mô-ap coah kễng crỗng Yôr-dan choâng vil Yê-ri-cô, Yiang Sursĩ ớn Môi-se atỡng máh cũai proai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Toâq tỗp anhia yang crỗng Yôr-dan mut chu cruang Cana-an, ");
INSERT INTO bru_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","cóq tỗp anhia tuih aloŏh nheq máh cũai proai tâng cruang ki. Cóq anhia pieih talốh nheq tanũl tamáu cớp mul rup noau táq toâq tac, dếh ntốq noau cơi sang hỡ. ");
INSERT INTO bru_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Chơ cóq anhia ĩt nheq máh cruang cutễq alới, cớp táq vil viang tâng ntốq ki, bân ntốq cứq khoiq chiau yỗn anhia chơ. ");
INSERT INTO bru_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Cóq anhia tampễq cutễq ki yỗn dũ tỗp dũ sâu tâng tỗp anhia. Cóq anhia séng anhúq neq: Sâu aléq bữn cũai sa‑ữi, cóq anhia tampễq cutễq yỗn tỗp alới bữn la‑a hỡn; ma sâu aléq bữn cũai bĩq, cóq anhia yỗn alới bĩq sâng. ");
INSERT INTO bru_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ma khân tỗp anhia tỡ bữn tuih aloŏh nheq máh tỗp alới ki, nỡ‑ra alới ca noâng khlâiq ki toâp táq yỗn tỗp anhia chĩuq túh coat, cỡt ariang brếh kiang tâng moat cớp sarlia pál tâng tỗ. ");
INSERT INTO bru_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Khân tỗp anhia mŏ tỡ bữn tuih aloŏh alới, cứq ễ pupứt nheq tỗp anhia, machớng cứq khoiq thrũan ễ pupứt tỗp alới tê.” ");
INSERT INTO bru_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yiang Sursĩ ớn Môi-se atỡng máh cũai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Toâq tỗp anhia bữn mut ỡt chơ tâng cruang Cana-an, ntốq cứq ễ chiau yỗn tỗp anhia, máh raloan cruang tỗp anhia la neq: ");
INSERT INTO bru_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Raloan yáng angia coah pưn cuti tễ ntốq aiq Sin toau toâq raloan cruang cũai Ê-dôm; raloan yáng angia mandang loŏh angia coah pưn la noap tễ ntốq dỡq mưt Boi. ");
INSERT INTO bru_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Chơ raloan ki cooc pỡq yáng angia coah pưn, pỡq pha raláp Acra-bim cớp pha ntốq Sin pỡq chu angia coah pưn toau toâq Cadet Barnia. Chơ raloan ki viel achỗn loah coah angia mandang pât coah angia pỡng toau toâq Hasar Adar, cớp toau luat toâq chu At-môn. ");
INSERT INTO bru_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Tâng ntốq ki raloan cutễq veh chu parchon cóh bân raloan cruang Ê-yip-tô, chơ sốt pỡ dỡq mưt Mê-di-tarian. ");
INSERT INTO bru_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Raloan cruang coah angia mandang pât la dỡq mưt Mê-di-tarian. ");
INSERT INTO bru_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Raloan cruang yáng angia coah pỡng ỡt mpễr dỡq mưt Mê-di-tarian toau toâq pỡ cóh Hor; ");
INSERT INTO bru_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","tễ cóh ki toau toâq raláp Hamat, chơ toau toâq pỡ Sê-dat. ");
INSERT INTO bru_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Chơ án pỡq ễn toau toâq pỡ Síp-rôn cớp sốt tâng Hasar E-nan. ");
INSERT INTO bru_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Raloan cruang yáng angia mandang loŏh boi puai tễ rana Hasar E-nan toau toâq Sê-pham. ");
INSERT INTO bru_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Vớt tễ ki, raloan ki luat pỡq chu angia coah pưn toau toâq Rip-la yáng angia mandang loŏh A-in cớp chỗn loah chu anũol cóh ỡt yáng angia mandang loŏh pứh clóng Cali-lê. ");
INSERT INTO bru_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Chơ án pỡq asễng chu angia coah pưn mpễr pứh crỗng Yôr-dan toau toâq dỡq mưt Boi. “Nâi la pỗn coah raloan cruang tỗp anhia.” ");
INSERT INTO bru_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Chơ, Môi-se atỡng cũai I-sarel neq: “Nâi ơiq la máh raloan cruang cutễq tỗp anhia; anhia bữn roap na séng anhúq máh cruang cutễq Yiang Sursĩ khoiq chiau yỗn anhia takêh tỗp tadĩ. ");
INSERT INTO bru_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Ma pún máh tỗp Ruben, Cát, cớp tadĩ tỗp Ma-nasê, alới khoiq miar bữn roap pún léq pún ki chơ, puai thrỗq cũai tâng dống sũ alới, ");
INSERT INTO bru_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","cutễq ỡt yáng angia mandang loŏh yáng crỗng Yôr-dan choâng vil Yê-ri-cô.” ");
INSERT INTO bru_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yiang Sursĩ atỡng yỗn Môi-se neq: ");
INSERT INTO bru_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“E-lia-sơ la cũai tễng rit sang Yiang Sursĩ, cớp Yô-sũa la con samiang Nun, alới bar náq cóq tampễq cutễq yỗn máh cũai proai. ");
INSERT INTO bru_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Cớp cóq mới rưoh ĩt muoi noaq cũai sốt tễ dũ tỗp dŏq rachuai máh ranáq nâi.” ");
INSERT INTO bru_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ramứh cũai sốt tễ dũ tỗp la neq: Calep con samiang Yê-phunê tễ tỗp Yuda; ");
INSERT INTO bru_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Sê-muol la con samiang Ami-hut tễ tỗp Si-mê-ôn; ");
INSERT INTO bru_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","E-li-dat la con samiang Khit-lôn tễ tỗp Ben-yamin; ");
INSERT INTO bru_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki la con samiang Yôc-li tễ tỗp Dan; ");
INSERT INTO bru_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Haniel la con samiang Ê-phot tễ tỗp Ma-nasê; ");
INSERT INTO bru_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Camual la con samiang Sip-tan tễ tỗp Ep-ra-im la con samiang Yô-sep; ");
INSERT INTO bru_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","E-li-saphan la con samiang Parnac tễ tỗp Sa-bulôn; ");
INSERT INTO bru_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Pal-tiel la con samiang Asan tễ tỗp I-sacar; ");
INSERT INTO bru_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahi-hut la con samiang Sê-lô-mi tễ tỗp Asêr; ");
INSERT INTO bru_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pê-dahêl la con samiang Ami-hut tễ tỗp Nep-tali. ");
INSERT INTO bru_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Máh tỗp nâi Yiang Sursĩ ớn tampễq cutễq yỗn máh cũai I-sarel ỡt tâng cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yiang Sursĩ atỡng Môi-se tâng ntốq cutễq tapín Mô-ap yáng coah crỗng Yôr-dan, choâng cớp vil Yê-ri-cô la neq: ");
INSERT INTO bru_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Cóq mới atỡng cũai I-sarel neq: Cóq alới chiau máh vil yỗn tỗp Lê-vi têq ỡt, dếh ruang bát mpễr vil ki hỡ. ");
INSERT INTO bru_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Máh vil nâi cỡt vil tỗp Lê-vi, dŏq tỗp alới bữn ỡt, cớp ruang bát yỗn tỗp alới têq bán máh ntroŏq cớp charán canŏ́h hỡ. ");
INSERT INTO bru_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Dũ coah ruang bát cóq la‑a muoi ngin coat tễ viang vil. ");
INSERT INTO bru_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Yáng tiah vil cóq anhia chiaq bar ngin coat yáng angia mandang loŏh; bar ngin coat yáng angia mandang pât; bar ngin coat yáng angia pỡng cớp bar ngin coat yáng angia pưn; cớp vil ki ỡt mpứng dĩ. Ngkíq alới bữn dếh ruang bát dếh vil. ");
INSERT INTO bru_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Cóq anhia chiau tapoât vil yỗn tỗp Lê-vi dŏq cỡt vil yỗn cũai ca lơ cachĩt cũai canŏ́h têq lúh ỡt poâng. Cóq anhia chiau tữm ễn yỗn tỗp Lê-vi pỗn chít la bar vil. ");
INSERT INTO bru_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Anhia cóq yỗn cũai Lê-vi nheq tữh la pỗn chít tacual vil, dếh ruang bát hỡ. ");
INSERT INTO bru_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Máh vil anhia chiau yỗn tỗp Lê-vi tễ cutễq cũai I-sarel ndỡm, cóq anhia tampễq neq: Tỗp aléq ca bữn sa‑ữi vil, cóq yỗn sa‑ữi hỡn tễ tỗp ca bữn bĩq vil.” ");
INSERT INTO bru_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Yiang Sursĩ ớn Môi-se atỡng cũai proai I-sarel neq: ");
INSERT INTO bru_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Toâq tỗp anhia yang crỗng Yôr-dan mut chu cruang Cana-an, ");
INSERT INTO bru_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","cóq anhia rưoh vil têq ỡt poâng dŏq yỗn cũai ca lơ cachĩt cũai canŏ́h têq lúh ỡt. ");
INSERT INTO bru_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Ỡt tâng vil ki, cũai ki bữn ỡt ien khễ cớp vớt tễ cũai carláh dỡq ễ cachĩt loah án. Cũai noau chống tũn pai án cachĩt cũai canŏ́h, án tỡ bữn roap tôt cuchĩt nhũang cũai sốt tỡ yũah parchĩn parnai. ");
INSERT INTO bru_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Cóq anhia rưoh tapoât vil ki la neq: ");
INSERT INTO bru_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Pái vil ỡt yáng angia mandang loŏh crỗng Yôr-dan, cớp pái vil ễn ỡt tâng cruang Cana-an. ");
INSERT INTO bru_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Máh vil nâi dŏq yỗn cũai proai I-sarel cớp cũai proai tễ cruang canŏ́h ỡt dỡ tỡ la ỡt dũn tâng cruang I-sarel têq poâng. Khân bữn cũai aléq ma lơ cachĩt cũai canŏ́h, ki têq án mut poâng tâng máh vil ki. ");
INSERT INTO bru_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Ma khân cũai aléq ma ĩt crơng noau táq toâq tac, chơ toân cũai canŏ́h toau cuchĩt, noau lứq dŏq án la cũai cachĩt cũai. Chơ cũai ki cóq cuchĩt tê. ");
INSERT INTO bru_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Tỡ la khân cũai aléq ma yống tamáu tâng atĩ ca têq cachĩt cũai, chơ án tám tamáu chóq cũai canŏ́h toau cuchĩt, noau lứq dŏq án la cũai cachĩt cũai. Chơ cũai ki cóq roap tôt cuchĩt tê. ");
INSERT INTO bru_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Khân cũai aléq ma ĩt aluang toân cũai canŏ́h toau cuchĩt, noau lứq dŏq án la cũai cachĩt cũai. Cớp cũai ki cóq cuchĩt tê. ");
INSERT INTO bru_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Sễm ai cũai cuchĩt ki, têq án carláh dỡq chuai sễm ai án. Toâq bo léq án ramóh cũai ki, têq án cachĩt loah. ");
INSERT INTO bru_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“Khân cũai aléq kêt cũai canŏ́h, chơ án cutớl tỡ la voang crơng pla yoc ễ cachĩt cũai ki, ");
INSERT INTO bru_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","tỡ la khân cũai aléq carpỗt atĩ chooc cũai canŏ́h toau cuchĩt, noau lứq dŏq án la cũai cachĩt cũai. Án cóq cuchĩt tê. Sễm ai cũai cuchĩt ki, têq carláh dỡq chuai sễm ai án. Toâq bo léq án ramóh cũai ki, têq án cachĩt loah. ");
INSERT INTO bru_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Ma khân cũai aléq tỡ bữn kêt cũai canŏ́h, ma án lơ cutớl tỡ la voang crơng pla pĩeiq cũai ki toau cuchĩt, ");
INSERT INTO bru_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","tỡ la cũai aléq lơ táq tamáu satooh pĩeiq cũai canŏ́h toau cuchĩt yuaq án tỡ bữn hữm, tỡ la án táq yỗn cũai chũl ma án tỡ bữn ũan ntrớu cũai ki, ");
INSERT INTO bru_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tâng máh ŏ́c ki cũai proai cóq rapai chuai yỗn án ca cachĩt lơ cũai canŏ́h, yỗn án têq vớt tễ sễm ai cũai cuchĩt ki ễ carláh dỡq. ");
INSERT INTO bru_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Máh cũai proai cóq rapai chuai cũai ca cachĩt cũai canŏ́h dŏq yỗn án vớt tễ talang atĩ sễm ai cũai cuchĩt ki. Cớp cóq alới dững án chu vil têq ỡt poâng. Chơ án cóq ỡt tâng vil ki toau cũai sốt nheq tễ rit sang cuchĩt voai. ");
INSERT INTO bru_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ma khân cũai lơ cachĩt cũai yoc ễ dễq tễ vil têq ỡt poâng, ");
INSERT INTO bru_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","cớp khân sễm ai cũai cuchĩt ki pĩeiq ramóh, cŏh lơ án cachĩt loah cũai ki; ŏ́c carláh dỡq nâi la tỡ bữn lôih ntrớu. ");
INSERT INTO bru_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Cũai ca noau tếq pai án bữn lôih cỗ cachĩt cũai canŏ́h, cóq án pỡq ỡt tâng vil têq ỡt poâng toau cũai sốt nheq tễ rit sang cuchĩt voai. Vớt tễ ki têq án píh chu loah pỡ dống án. ");
INSERT INTO bru_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Tam anhia ỡt ntốq léq, cóq anhia cớp máh con châu anhia táq puai níc phễp rit nâi. ");
INSERT INTO bru_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Khân noau tũn cũai aléq cachĩt cũai canŏ́h, cớp anhia yoc ễ cachĩt loah án, ki cóq bữn cũai bar pái náq khoiq hữm ranáq ki. Ma khân ống manoaq sâng hữm, ki anhia tỡ têq cachĩt án. ");
INSERT INTO bru_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Cũai aléq ma cachĩt cũai canŏ́h, cóq cũai ki cuchĩt tê. Khân án yỗn práq ễq yỗn vớt tễ cuchĩt, la tỡ têq. ");
INSERT INTO bru_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Khân bữn muoi noaq cũai lúh mut tâng vil têq ỡt poâng, anhia chỗi pruam cớp cũai ki yỗn án ĩt práq thái loah rangứh án yỗn têq án chu loah chu dống nhũang cũai sốt nheq tễ rit sang tỡ yũah cuchĩt. ");
INSERT INTO bru_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Khân anhia táq ngkíq, anhia táq yỗn cutễq anhia ỡt cỡt tỡ bữn bráh noâng puai rit, yuaq ranáq cachĩt cũai táq yỗn cutễq cỡt tỡ bữn bráh noâng. Cớp ống muoi ranáq sâng têq anhia táq yỗn cutễq anhia cỡt bráh loah, la cóq anhia cachĩt chíq cũai ca cachĩt cũai canŏ́h. ");
INSERT INTO bru_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Chỗi táq yỗn cruang cutễq anhia ỡt cỡt tỡ bữn bráh puai rit, yuaq cứq la Yiang Sursĩ ỡt mpứng dĩ máh cũai I-sarel.” ");
INSERT INTO bru_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Máh cũai sốt dống sũ tễ sâu Ki-liat, con samiang Makir, châu Ma-nasê, chễ Yô-sep, alới pỡq ramóh Môi-se cớp máh cũai sốt tễ dũ tỗp cũai I-sarel. ");
INSERT INTO bru_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Tỗp alới pai neq: “Yiang Sursĩ ớn achuaih tampễq cutễq nâi yỗn cũai proai I-sarel na séng anhúq. Cớp Yiang Sursĩ atỡng tê yỗn achuaih chiau cutễq pún Sê-lô-phahat, la sễm ai hếq, yỗn máh con mansễm án ễn. ");
INSERT INTO bru_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ma khân tỗp alới racoâiq cớp samiang tễ sâu canŏ́h tâng tỗp I-sarel, máh mun alới lứq cỡt khong tỗp ki ễn; chơ pún cutễq tỗp hếq cỡt yeh. ");
INSERT INTO bru_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Toâq Chuop Sỡng Chít Cumo máh tâm cutễq khoiq chếq chơ cóq culáh loah yỗn cũai ca ndỡm nhũang. Ma cutễq mun tỗp con mansễm Sê-lô-phahat, khân puai tâng rit racoâiq, cutễq ki cóq cỡt khong tỗp cayac alới; chơ cutễq tỗp hếq cỡt bĩq lứq ễn.” ");
INSERT INTO bru_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ngkíq, Môi-se atỡng cũai proai yỗn táq puai máh santoiq Yiang Sursĩ ớn la neq: “Tễ ranáq tỗp tŏ́ng toiq Yô-sep pai la lứq pĩeiq. ");
INSERT INTO bru_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ngkíq Yiang Sursĩ pai tễ tỗp con mansễm Sê-lô-phahat, têq alới racoâiq tam mứt alới sâng yoc, ma cóq alới ĩt cớp cũai tâng tỗp bữm. ");
INSERT INTO bru_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Chỗi yỗn cũai I-sarel chiau cutễq khong alới tễ tỗp nâi yỗn tỗp ki. Dũ náq cũai I-sarel cóq dŏq máh cutễq mun tễ achúc achiac alới. ");
INSERT INTO bru_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Dũ náq mansễm ca bữn ndỡm mun tâng muoi tỗp cũai I-sarel, cóq án racoâiq cớp samiang tâng tỗp ki toâp. Táq ngkíq proai I-sarel bữn ndỡm loah máh mun achúc achiac alới. ");
INSERT INTO bru_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Cớp máh mun ki tỡ têq cỡ