﻿USE sofia;
DROP TABLE IF EXISTS sofia.breBRG_vpl;
CREATE TABLE breBRG_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES breBRG_vpl WRITE;
INSERT INTO breBRG_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Levr lignez Jezuz-Krist, Mab David, Mab Abraham. ");
INSERT INTO breBRG_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham a voe tad da Izaak. Izaak a voe tad da Jakob. Jakob a voe tad da Juda ha d'e vreudeur. ");
INSERT INTO breBRG_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda, eus Tamar, a voe tad da Farez ha Zara. Farez a voe tad da Ezrom. Ezrom a voe tad da Aram. ");
INSERT INTO breBRG_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram a voe tad da Aminadab. Aminadab a voe tad da Naason. Naason a voe tad da Salmon. ");
INSERT INTO breBRG_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, eus Rahab, a voe tad da Vooz. Booz, eus Rut, a voe tad da Obed. Obed a voe tad da Jese. ");
INSERT INTO breBRG_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese a voe tad d'ar roue David. Ar roue David a voe tad da Salomon, eus an hini a oa bet gwreg da Uri. ");
INSERT INTO breBRG_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomon a voe tad da Roboam. Roboam a voe tad da Abia. Abia a voe tad da Asa. ");
INSERT INTO breBRG_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a voe tad da Jozafat. Jozafat a voe tad da Joram. Joram a voe tad da Ozia. ");
INSERT INTO breBRG_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozia a voe tad da Joatam. Joatam a voe tad da Achaz. Achaz a voe tad da Ezekia. ");
INSERT INTO breBRG_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia a voe tad da Vanase. Manase a voe tad da Amon. Amon a voe tad da Jozia. ");
INSERT INTO breBRG_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jozia a voe tad da Jekonia ha d'e vreudeur, da vare an ermaeziadeg e Babilon. ");
INSERT INTO breBRG_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ha goude ma voent bet kaset da Vabilon, Jekonia a voe tad da Salatiel. Salatiel a voe tad da Zorobabel. ");
INSERT INTO breBRG_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel a voe tad da Abiud. Abiud a voe tad da Eliakim. Eliakim a voe tad da Azor. ");
INSERT INTO breBRG_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor a voe tad da Sadok. Sadok a voe tad da Achim. Achim a voe tad da Eliud. ");
INSERT INTO breBRG_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud a voe tad da Eleazar. Eleazar a voe tad da Vatan. Vatan a voe tad da Jakob. ");
INSERT INTO breBRG_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob a voe tad da Jozef, pried Mari, ma'z eo bet ganet anezhi Jezuz, galvet Krist. ");
INSERT INTO breBRG_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bez' ez eus eta en holl: eus Abraham betek David, pevarzek rummad; eus David betek an ermaeziadeg e Babilon, pevarzek rummad; hag eus an ermaeziadeg e Babilon betek ar C'hrist, pevarzek rummad. ");
INSERT INTO breBRG_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Setu, ganedigezh Jezuz-Krist a c'hoarvezas evel-henn. Goude ma oa prometet Mari, e vamm, da Jozef, a-raok ma oant asambles, hi en em gavas brazez dre ar Spered-Santel. ");
INSERT INTO breBRG_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jozef, he fried, a oa un den reizh ha ne felle ket dezhañ he mezhekaat; c'hoantaat a reas he c'has kuit e-kuzh. ");
INSERT INTO breBRG_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Evel ma soñje kement-se, setu, un ael eus an Aotrou en em ziskouezas dezhañ, dre e gousk, o lavarout: Jozef, mab David, na'z pez ket aon da gemer ganit Mari, da wreg, rak ar pezh a zo koñsevet enni a zo eus ar Spered-Santel, ");
INSERT INTO breBRG_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","hag e c'hano ur mab, hag e roi dezhañ Jezuz da anv, rak eñ a saveteo e bobl eus e bec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kement-se holl a c'hoarvezas, evit ma vije peurc'hraet ar pezh a oa bet lavaret gant an Aotrou dre gomz ar profed: ");
INSERT INTO breBRG_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Setu, ar werc'hez a vo brazez, hag a c'hano ur mab a vo galvet Emmanuel, da lavarout eo: Doue ganeomp. ");
INSERT INTO breBRG_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jozef, o vezañ dihunet eus e gousk, a reas ar pezh en devoa ael an Aotrou gourc'hemennet dezhañ, hag e kemeras e wreg gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hogen n'anavezas ket anezhi betek ma voe gwilioudet eus he mab kentañ-ganet, hag e roas dezhañ Jezuz da anv. ");
INSERT INTO breBRG_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jezuz o vezañ bet ganet e Betlehem Judea, en amzer ar roue Herodez, setu e teuas majed eus ar sav-heol da Jeruzalem, en ur lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pelec'h emañ an hini a zo ganet da roue d'ar Yuzevien? Rak gwelet hon eus e steredenn er sav-heol, ha deuet omp d'e azeuliñ. ");
INSERT INTO breBRG_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pa glevas ar roue Herodez kement-se, e voe trubuilhet, hag holl Jeruzalem gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O vezañ dastumet an holl veleien vras ha skribed ar bobl, e c'houlennas diganto pelec'h e tlee bezañ ganet ar C'hrist. ");
INSERT INTO breBRG_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Int a lavaras dezhañ: E Betlehem Judea; rak evel-henn eo bet skrivet gant ar profed: ");
INSERT INTO breBRG_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ha te, Betlehem, douar Judea, n'out ket an disterañ e-touez kêrioù pennañ Judea; rak ac'hanout eo, e teuio ur penn a reno va fobl Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Neuze Herodez, o vezañ galvet ar majed e-kuzh, a c'houlennas gant preder diganto e pe amzer e oa en em ziskouezet ar steredenn dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hag, o kas anezho da Vetlehem, e lavaras: It, ha goulennit gant preder pelec'h emañ ar bugel bihan-se; ha pa ho po e gavet, roit din da anavezout, evit ma'z in me ivez d'e azeuliñ. ");
INSERT INTO breBRG_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ar re-mañ, goude bezañ klevet ar roue, a yeas kuit; ha setu, ar steredenn o devoa gwelet er sav-heol, a yae en o raok, betek ma teuas ha ma chomas a-us d'ul lec'h ma oa ar bugel bihan. ");
INSERT INTO breBRG_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pa weljont ar steredenn, e voe karget o c'halonoù gant levenez. ");
INSERT INTO breBRG_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","O vezañ aet en ti, e kavjont ar bugel gant Mari e vamm, hag, oc'h en em stouiñ d'an douar, ec'h azeuljont anezhañ; ha goude bezañ digoret o zeñzorioù, e kinnigjont dezhañ profoù: aour, ezañs ha mir. ");
INSERT INTO breBRG_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","O vezañ bet aliet gant Doue, dre un huñvre, ne zistrojont ket da gavout Herodez; mont a rejont d'o bro dre un hent all. ");
INSERT INTO breBRG_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Goude ma oant aet kuit, setu, un ael eus an Aotrou en em ziskouezas da Jozef, dre un huñvre, en ur lavarout: Sav, kemer ar bugel hag e vamm, tec'h en Ejipt, ha chom eno betek e lavarin dit; rak Herodez a glasko ar bugel evit e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eñ, o vezañ savet, a gemeras ar bugel bihan hag e vamm e-pad an noz, hag en em dennas en Ejipt. ");
INSERT INTO breBRG_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hag e chomas eno betek ma varvas Herodez, evit ma vije peurc'hraet ar pezh en devoa an Aotrou lavaret dre ar profed: Galvet em eus va mab eus Ejipt. ");
INSERT INTO breBRG_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Neuze Herodez, o welout o devoa ar majed graet goap anezhañ, a voe en ur gounnar vras, hag a gasas da lazhañ an holl vugale a zaou vloaz ha yaouankoc'h, e Betlehem hag en e vro a-bezh, hervez an amzer en devoa goulennet gant preder digant ar vajed. ");
INSERT INTO breBRG_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Neuze e voe peurc'hraet ar pezh a oa bet lavaret gant ar profed Jeremia: ");
INSERT INTO breBRG_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Garmoù a zo bet klevet e Rama, hirvoudoù, gouelvan ha klemmvanoù bras: Rachel o ouelañ he bugale; ne fellas ket dezhi bezañ dic'hlac'haret, abalamour n'emaint mui. ");
INSERT INTO breBRG_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Goude marv Herodez, setu, un ael eus an Aotrou en em ziskouezas da Jozef en Ejipt, dre un huñvre, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Sav, kemer ar bugel bihan hag e vamm, ha distro da vro-Israel, rak ar re a glaske ar bugel evit e lazhañ, a zo marv. ");
INSERT INTO breBRG_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hemañ, o vezañ savet, a gemeras ar bugel hag e vamm, hag a zeuas e bro-Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Met, pa glevas e rene Arkelauz e Judea e-lec'h e dad Herodez, en devoe aon da vont di; o vezañ bet aliet gant Doue dre un huñvre, en em dennas e kostezioù Galilea. ");
INSERT INTO breBRG_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chom a reas en ur gêr anvet Nazared, evit ma vije peurc'hraet ar pezh a oa bet lavaret gant ar brofeded: Galvet e vo Nazaredad. ");
INSERT INTO breBRG_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","En deizioù-se, e teuas Yann-Vadezour o prezeg e lec'h distro Judea, hag o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ho pet keuz, rak rouantelezh an neñvoù a zo tost. ");
INSERT INTO breBRG_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Anezhañ eo en deus komzet ar profed Izaia, o lavarout: Mouezh an hini a gri el lec'h distro a lavar: Kempennit hent an Aotrou, plaenit e wenodennoù. ");
INSERT INTO breBRG_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yann a zouge ur sae a vlev kañval hag ur gouriz lêr en-dro d'e groazell; e voued a oa kilheien-raden ha mel gouez. ");
INSERT INTO breBRG_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","An dud eus Jeruzalem, eus an holl Judea hag eus an holl vro war-dro ar Jordan, a yae d'e gavout, ");
INSERT INTO breBRG_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","hag, oc'h anzav o fec'hedoù, e oant badezet gantañ er stêr Jordan. ");
INSERT INTO breBRG_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eñ eta, o welout kalz a farizianed hag a sadukeiz o tont d'e vadeziant, a lavaras dezho: Lignez a naered-gwiber, piv en deus desket deoc'h tec'hel diouzh ar gounnar da zont? ");
INSERT INTO breBRG_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dougit eta frouezh dereat d'ar geuzidigezh, ");
INSERT INTO breBRG_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ha na lavarit ket ennoc'h hoc'h-unan: Ni hon eus evit tad Abraham; rak me a lavar deoc'h, e c'hell Doue ober genel eus ar vein-se bugale da Abraham. ");
INSERT INTO breBRG_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ar vouc'hal a zo a-vremañ lakaet ouzh gwrizioù ar gwez. Pep gwezenn eta na ro ket frouezh mat a ya da vezañ troc'het ha taolet en tan. ");
INSERT INTO breBRG_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me ho padez en dour, evit ar geuzidigezh; met unan all a zeu, galloudusoc'h egedon, ha n'on ket dellezek da zougen e votoù. Eñ ho padezo er Spered-Santel hag en tan. ");
INSERT INTO breBRG_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","E grouer a zo en e zaouarn, naetaat a raio mat e leur, hag e tastumo ar gwinizh en e solier, met ar pell a zevo en tan na varv ket. ");
INSERT INTO breBRG_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Neuze, Jezuz a zeuas eus Galilea d'ar Jordan, da gavout Yann, evit bezañ badezet gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Met Yann ne felle ket dezhañ e ober, o lavarout: Me am eus ezhomm da vezañ badezet ganit, hag e teuez da'm c'havout? ");
INSERT INTO breBRG_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jezuz, en ur respont, a lavaras dezhañ: Na harz ket-se bremañ; rak evel-se eo e tere ouzhimp peurober pep reizhder. Neuze eñ a lezas d'ober. ");
INSERT INTO breBRG_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ha goude ma oa bet badezet Jezuz, e savas raktal eus an dour; ha setu, an neñvoù a oa digoret a-us dezhañ, hag e welas Spered Doue, e doare ur goulm, o tiskenn warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ha setu, ur vouezh eus an neñvoù a lavare: Hemañ eo va Mab karet-mat, ennañ em eus lakaet va holl levenez. ");
INSERT INTO breBRG_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Neuze Jezuz a voe kaset gant ar Spered el lec'h distro, evit bezañ temptet gant an diaoul. ");
INSERT INTO breBRG_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Goude m'en devoe yunet daou-ugent devezh ha daou-ugent nozvezh, en devoe naon. ");
INSERT INTO breBRG_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","An tempter, o vezañ tostaet outañ, a lavaras dezhañ: Mar dout Mab Doue, gourc'hemenn d'ar mein-se dont da vezañ bara. ");
INSERT INTO breBRG_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Met eñ a respontas: Skrivet eo: An den ne vevo ket a vara hepken, met gant pep ger a zeu eus genou Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Neuze an diaoul en kasas er gêr santel, a lakaas anezhañ war lein an templ, ");
INSERT INTO breBRG_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","hag a lavaras dezhañ: Mar dout Mab Doue, en em daol d'an traoñ, rak skrivet eo: Gourc'hemenn a raio d'e aeled kaout evezh ouzhit, ha: dougen a raint ac'hanout etre o daouarn, gant aon na stokfe da droad ouzh ur maen bennak. ");
INSERT INTO breBRG_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jezuz a respontas dezhañ: Skrivet eo ivez: Na dempti ket an Aotrou da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","An diaoul en kasas c'hoazh war ur menez uhel meurbet, a ziskouezas dezhañ holl rouantelezhioù ar bed hag o gloar, ");
INSERT INTO breBRG_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","hag a lavaras dezhañ: An holl draoù-se a roin dit, mar daoulinez da'm azeuliñ. ");
INSERT INTO breBRG_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jezuz a respontas dezhañ: A-dreñv din, Satan! Rak skrivet eo: Azeuliñ a ri an Aotrou da Zoue, ha ne serviji nemetañ. ");
INSERT INTO breBRG_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Neuze an diaoul en lezas; ha setu, aeled a zeuas hag a servijas anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Met pa glevas Jezuz e oa bet lakaet Yann er prizon, en em dennas e Galilea. ");
INSERT INTO breBRG_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O vezañ kuitaet Nazared, e teuas da chom e Kafarnaoum, kêr arvorek, war harzoù Zabulon ha Neftali, ");
INSERT INTO breBRG_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","evit ma vije peurc'hraet ar pezh a oa bet lavaret gant ar profed Izaia: ");
INSERT INTO breBRG_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Douar Zabulon ha douar Neftali, ar vro a zo war hent ar mor, en tu all d'ar Jordan, Galilea ar baganed, ");
INSERT INTO breBRG_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ar bobl a oa azezet en deñvalijenn, he deus gwelet ur sklêrijenn vras; hag ar sklêrijenn a zo savet war ar re a oa azezet e bro hag e skeud ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Adalek neuze, Jezuz en em lakaas da brezeg, ha da lavarout: Ho pet keuz rak rouantelezh an neñvoù a zo tost. ");
INSERT INTO breBRG_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hag, evel ma valee a-hed mor Galilea, e welas daou vreur, Simon a c'halver Pêr, hag Andrev e vreur, o teurel o roued er mor, rak pesketaerien e oant. ");
INSERT INTO breBRG_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Lavarout a reas dezho: Heuilhit ac'hanon, ha me ho raio pesketaerien dud. ");
INSERT INTO breBRG_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kerkent, o lezel o rouedoù, e heuilhjont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hag ac'hano, o vont un tamm a-raokoc'h, e welas daou vreur all, Jakez mab Zebedea, ha Yann e vreur, a oa en ur vag gant Zebedea o zad, o fichañ o rouedoù. Gervel a reas anezho. ");
INSERT INTO breBRG_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Int, raktal, o lezel o bag hag o zad, a heulias anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jezuz a valeas dre holl C'halilea, o kelenn en o sinagogennoù, o prezeg keloù mat ar rouantelezh, hag o yac'haat kement kleñved ha kement mac'hagn a oa e-touez ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ar vrud anezhañ en em skuilhe dre holl Siria, hag e tegasent dezhañ an holl re glañv, re dalc'het gant meur a boan ha gant meur a zroug, re dalc'het gant diaoulien, re loariek, re seizet, hag eñ a yac'hae anezho. ");
INSERT INTO breBRG_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ul lod bras a dud a heulie anezhañ eus Galilea, eus Dekapoliz, eus Jeruzalem, eus Judea, hag eus an tu all d'ar Jordan. ");
INSERT INTO breBRG_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","O welout ar bobl-se, Jezuz a bignas war ur menez, hag, o vezañ azezet, e ziskibien a dostaas outañ. ");
INSERT INTO breBRG_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","O tigeriñ e c'henou, e kelenne anezho, en ur lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Eürus ar re baour er spered, rak rouantelezh an neñvoù a zo dezho! ");
INSERT INTO breBRG_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Eürus ar re a zo er glac'har, rak int a vo frealzet! ");
INSERT INTO breBRG_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Eürus ar re a zo hegarat, rak int a resevo an douar da hêrezh! ");
INSERT INTO breBRG_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Eürus ar re o deus naon ha sec'hed eus ar reizhder, rak int o devo o gwalc'h! ");
INSERT INTO breBRG_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Eürus ar re drugarezus, rak int a gavo trugarez! ");
INSERT INTO breBRG_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Eürus ar re o deus ur galon glan, rak int a welo Doue! ");
INSERT INTO breBRG_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Eürus ar re a zegas ar peoc'h, rak int a vo galvet bugale Doue! ");
INSERT INTO breBRG_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Eürus ar re a zo gwallgaset abalamour d'ar reizhder, rak rouantelezh an neñvoù a zo dezho! ");
INSERT INTO breBRG_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Eürus e viot, pa zeuio an dud d'ho tismegañsiñ, d'ho kwallgas, ha da lavarout dre c'haou pep seurt droug a-enep deoc'h abalamour din. ");
INSERT INTO breBRG_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","En em laouenait, ha tridit gant levenez, rak ho kopr a vo bras en neñvoù; rak evel-se eo bet gwallgaset ar brofeded hag a zo bet araozoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","C'hwi a zo holen an douar; met mar koll an holen e vlaz, gant petra e vo e roet en-dro dezhañ? N'eo mui mat, nemet da vezañ taolet er-maez, ha da vezañ mac'het gant treid an dud. ");
INSERT INTO breBRG_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","C'hwi a zo sklêrijenn ar bed; ur gêr savet war ur menez ne c'hell ket bezañ kuzhet; ");
INSERT INTO breBRG_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ha ne vez ket enaouet ur c'houlaouenn evit he lakaat dindan ar boezell, met evit he lakaat war ur c'hantolor, hag e sklêrijenno holl dud an ti. ");
INSERT INTO breBRG_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ra lugerno evel-se ho sklêrijenn dirak an dud, evit ma welint ho madoberoù, ha ma teuint da reiñ gloar d'ho Tad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Na soñjit ket e vefen deuet evit diskar al lezenn pe ar brofeded; n'on ket deuet evit diskar, met evit peurober. ");
INSERT INTO breBRG_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rak, me a lavar deoc'h e gwirionez, betek ma tremeno an neñv hag an douar, ne dremeno ket eus al lezenn, nag un iota, nag ur poentig a lizherenn, ken na vo peurc'hraet holl. ");
INSERT INTO breBRG_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Piv bennak eta a dorro an disterañ eus ar gourc'hemennoù-mañ, hag a zesko evel-se d'an dud, a vo galvet ar bihanañ e rouantelezh an neñvoù; met piv bennak o miro hag o desko d'ar re all, hennezh a vo galvet bras e rouantelezh an neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rak, me a lavar deoc'h, ma ne da ket ho reizhder dreist hini ar skribed hag ar farizianed, n'antreot ket e rouantelezh an neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Klevet hoc'h eus penaos eo bet lavaret d'ar re gozh: Ne lazhi ket; rak piv bennak a lazho, a vo dleet dezhañ ar varnedigezh. ");
INSERT INTO breBRG_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Met me a lavar deoc'h penaos piv bennak a fuloro ouzh e vreur hep abeg, a vo dleet dezhañ ar varnedigezh; an hini a lavaro d'e vreur: Raka! a zo dleet dezhañ bezañ kastizet gant ar sanedrin; hag an hini a lavaro d'e vreur: Diskiant! a zo dleet dezhañ bezañ kastizet gant tan ar gehenn. ");
INSERT INTO breBRG_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mar degasez eta da brof d'an aoter, hag e teu soñj dit eno en deus da vreur un dra bennak en da enep, ");
INSERT INTO breBRG_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lez eno da brof dirak an aoter, ha kae da gentañ d'en em unvaniñ gant da vreur; ha, goude-se, deus, ha kinnig da brof. ");
INSERT INTO breBRG_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","En em laka a-unvan hep dale gant da enebour, e-pad ma'z emaout en hent gantañ, gant aon na lakafe ac'hanout etre daouarn ar barner, ha na rafe ar barner da reiñ da ofiser ar justis, ha na vefes lakaet er prizon. ");
INSERT INTO breBRG_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","E gwirionez, me a lavar dit, ne zeui ket er-maez ac'hano, ken na vo paeet ganit an diwezhañ liard. ");
INSERT INTO breBRG_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Klevet hoc'h eus penaos eo bet lavaret d'ar re gozh: Ne ri ket avoultriezh. ");
INSERT INTO breBRG_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Met me a lavar deoc'h penaos piv bennak a sell ouzh ur vaouez gant c'hoantegezh anezhi, en deus dija graet avoultriezh ganti en e galon. ");
INSERT INTO breBRG_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ma ra da lagad dehou lakaat ac'hanout da gouezhañ, diframm anezhañ, ha taol anezhañ pell diouzhit; rak gwelloc'h eo dit koll unan eus da izili, eget na vo taolet da holl gorf er gehenn. ");
INSERT INTO breBRG_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ha ma ra da zorn dehou lakaat ac'hanout da gouezhañ, troc'h anezhañ, ha taol anezhañ pell diouzhit; rak gwelloc'h eo dit koll unan eus da izili, eget na vo taolet da holl gorf er gehenn. ");
INSERT INTO breBRG_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Lavaret eo bet ivez: Piv bennak a gaso kuit e wreg, ra roio dezhi ur skrid a dorr-dimeziñ. ");
INSERT INTO breBRG_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Met me a lavar deoc'h, piv bennak a gas kuit e wreg, nemet evit difealded, a laka anezhi da vezañ avoultrerez, ha piv bennak a zimez d'ur wreg a zo bet kaset kuit, a ra avoultriezh. ");
INSERT INTO breBRG_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Klevet hoc'h eus c'hoazh penaos eo bet lavaret d'ar re gozh: Ne doui ket e gaou, met mirout a ri al leoù az po graet da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Met me a lavar deoc'h: Na douit ket a-grenn, na dre an neñv, rak tron Doue eo, ");
INSERT INTO breBRG_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","na dre an douar, rak skabell e dreid eo, na dre Jeruzalem, rak kêr ar Roue bras eo. ");
INSERT INTO breBRG_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na dou ket kennebeut dre da benn, rak ne c'hellez ket ober da ur vlevenn bezañ gwenn pe du. ");
INSERT INTO breBRG_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Met ra vo ho komz, ya, ya, nann, nann; ar pezh a lavarer ouzhpenn a zeu eus an droug. ");
INSERT INTO breBRG_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Klevet hoc'h eus c'hoazh penaos eo bet lavaret d'ar re gozh: Lagad evit lagad, ha dant evit dant. ");
INSERT INTO breBRG_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Met me a lavar deoc'h: Na enebit ket ouzh an hini drouk; d'an hini a sko ac'hanout war ar jod dehou, tro eben outañ. ");
INSERT INTO breBRG_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mar fell da unan bennak prosezañ ouzhit ha kemer da vantell, laosk ivez gantañ da doneg. ");
INSERT INTO breBRG_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mar fell da unan bennak ober dit mont gantañ e-pad ur mil, gra daou vil gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ro d'an neb a c'houlenn ouzhit, ha na zistro ket diouzh an hini a fell dezhañ amprestañ diganit. ");
INSERT INTO breBRG_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Klevet hoc'h eus penaos eo bet lavaret: Karout a ri da nesañ, hag e kasai da enebour. ");
INSERT INTO breBRG_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Met me a lavar deoc'h-hu: Karit hoc'h enebourien, bennigit ar re a villig ac'hanoc'h, grit vad d'ar re a gasa ac'hanoc'h, ha pedit evit ar re ho kwallgas hag hoc'h heskin, ");
INSERT INTO breBRG_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","evit ma viot bugale ho Tad a zo en neñvoù; rak eñ a ra d'e heol sevel war ar re fall ha war ar re vat, hag a laka ar glav da gouezhañ war ar re reizh ha war ar re direizh. ");
INSERT INTO breBRG_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Rak ma ne garit nemet ar re ho kar, peseurt gopr ho po? Ha ne ra ket memes ar bublikaned kement-se? ");
INSERT INTO breBRG_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ha ma ne saludit nemet ho preudeur, petra a rit dreist ar re all? Ha ne ra ket memes ar bublikaned kement-se? ");
INSERT INTO breBRG_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bezit eta parfet, evel ma'z eo parfet ho Tad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lakait evezh na rafec'h ho madoberoù dirak an dud, evit bezañ gwelet ganto; rak n'ho po ket a c'hopr digant ho Tad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pa ri eta aluzen, na son ket an drompilh a-raok ac'hanout, evel ma ra ar bilpouzed er sinagogennoù hag er straedoù, evit bezañ meulet gant an dud. Me a lavar deoc'h e gwirionez, o deus o gopr. ");
INSERT INTO breBRG_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Met pa rez aluzen, gra na ouezo ket da zorn kleiz ar pezh a ra da zorn dehou, ");
INSERT INTO breBRG_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","evit ma vo da aluzen graet e-kuzh; da Dad a wel e-kuzh hag en rento dit dirak an holl. ");
INSERT INTO breBRG_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pa bedit, na vezit ket evel ar bilpouzed; rak int a gar pediñ en o sav er sinagogennoù hag e kornioù ar straedoù, evit bezañ gwelet gant an dud. Me a lavar deoc'h e gwirionez, o deus o gopr. ");
INSERT INTO breBRG_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Met te, pa bedez, kae ez kambr, hag, o vezañ serret an nor, ped da Dad a zo e-kuzh; da Dad a wel e-kuzh hag en rento dit dirak an holl. ");
INSERT INTO breBRG_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pa bedit, n'en em servijit ket a adlavarioù ven, evel ar baganed; rak krediñ a reont ez eo dre galz a gomzoù e vint selaouet. ");
INSERT INTO breBRG_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Na vezit ket eta heñvel outo; rak ho Tad a oar petra hoc'h eus ezhomm, a-raok ma c'houlennit digantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","C'hwi eta, pedit evel-henn: Hon Tad hag a zo en neñv, ra vo santelaet da anv, ");
INSERT INTO breBRG_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ra zeuio da rouantelezh, ra vo graet da volontez war an douar evel en neñv, ");
INSERT INTO breBRG_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ro deomp hiziv hor bara pemdeziek, ");
INSERT INTO breBRG_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","pardon deomp hor pec'hedoù evel ma pardonomp ivez d'ar re o deus manket ouzhimp, ");
INSERT INTO breBRG_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ha n'hon lez ket da gouezhañ en temptadur, met hon diwall diouzh an droug, rak dit eo ar ren, ar galloud hag ar gloar evit kantvedoù ar c'hantvedoù. Amen! ");
INSERT INTO breBRG_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Rak, mar pardonit d'an dud o mankoù, ho Tad neñvel a bardono ivez deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Met ma ne bardonit ket d'an dud o mankoù, ho Tad ne bardono ket kennebeut deoc'h ho re. ");
INSERT INTO breBRG_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Pa yunit, na gemerit ket ur min trist, evel ar bilpouzed; rak dispenn a reont o dremm, evit diskouez d'an dud e yunont. Me a lavar deoc'h e gwirionez, o deus o gopr. ");
INSERT INTO breBRG_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Met te, pa yunez, laka c'hwez-vat war da benn, ha gwalc'h da zremm, ");
INSERT INTO breBRG_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","evit na vo ket gwelet gant an dud e yunez, met hepken gant da'z Tad a zo e-kuzh; da Dad a wel e-kuzh hag en rento dit dirak an holl. ");
INSERT INTO breBRG_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Na zastumit ket teñzorioù deoc'h war an douar, e-lec'h ma'z int distrujet gant ar preñved ha gant ar mergl, hag e-lec'h ma toull al laeron ha ma skrapont; ");
INSERT INTO breBRG_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","met dastumit teñzorioù evidoc'h en neñv, e-lec'h n'int distrujet na gant ar mergl na gant ar preñved, hag e-lec'h na doull ket al laeron, ha na skrapont ket. ");
INSERT INTO breBRG_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Rak el lec'h ma'z emañ da deñzor, eno ivez e vo da galon. ");
INSERT INTO breBRG_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Al lagad eo lamp ar c'horf; mar deo eta da lagad yac'h, da holl gorf a vo sklêrijennet; ");
INSERT INTO breBRG_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","met mar deo fall da lagad, da holl gorf a vo en deñvalijenn. Mar deo eta teñval ar sklêrijenn a zo ennout, pegen bras e vo an deñvalijenn-se! ");
INSERT INTO breBRG_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Den ebet ne c'hell servijañ daou vestr; rak, pe e kasaio unan hag e karo egile, pe en em stago ouzh unan hag e tisprizo egile. Ne c'hellit ket servijañ Doue ha Mammon. ");
INSERT INTO breBRG_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Abalamour da-se e lavaran deoc'h: Na vezit ket nec'het evit ho puhez, petra a zebrot ha petra a evot, nag evit ho korf, gant petra e viot gwisket. Ar vuhez, ha n'eo ket muioc'h eget ar boued, hag ar c'horf, muioc'h eget an dilhad? ");
INSERT INTO breBRG_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sellit ouzh laboused an neñv: ne hadont ha ne vedont ket, ne zastumont netra er solieroù, hag ho Tad neñvel a vag anezho. Ha ne dalvezit ket kalz muioc'h egeto? ");
INSERT INTO breBRG_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Piv ac'hanoc'h a c'hell, gant e holl enkrez, astenn e vuhez eus un ilinad? ");
INSERT INTO breBRG_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Perak ivez oc'h nec'het diwar-benn ho dilhad? Sellit penaos e kresk lili ar parkeier: ne labouront ket, ne nezont ket; ");
INSERT INTO breBRG_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","koulskoude, e lavaran deoc'h, Salomon memes en e holl c'hloar n'eo ket bet gwisket evel unan anezho. ");
INSERT INTO breBRG_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mar gwisk eta Doue evel-se geot ar parkeier, a zo hiziv hag a vo warc'hoazh taolet er forn, pegement muioc'h e wisko ac'hanoc'h, tud a nebeud a feiz? ");
INSERT INTO breBRG_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Na vezit ket nec'het, o lavarout: Petra a zebrimp? Petra a evimp? Gant petra en em wiskimp? ");
INSERT INTO breBRG_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Rak ar baganed eo ar re a glask an holl draoù-se. Ho Tad neñvel a oar hoc'h eus ezhomm anezho. ");
INSERT INTO breBRG_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Klaskit kentoc'h rouantelezh Doue hag e reizhder, hag an holl draoù-se a vo roet deoc'h ouzhpenn. ");
INSERT INTO breBRG_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Na vezit ket eta nec'het gant an deiz war-lerc'h; an deiz war-lerc'h a gemero preder anezhañ e-unan. Da bep devezh eo a-walc'h e boan. ");
INSERT INTO breBRG_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na varnit ket, evit na viot ket barnet; ");
INSERT INTO breBRG_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","rak barnet e viot hervez m'ho po barnet, hag hervez ar muzul a vuzuliot, e vo muzuliet deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Perak e sellez ouzh ar blouzenn a zo e lagad da vreur, ha ne welez ket an treust a zo ez lagad da-unan? ");
INSERT INTO breBRG_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pe, penaos e c'hellez lavarout da'z preur: Va lez da zilemel ar blouzenn a zo e-barzh da lagad, pa'z ac'h eus un treust ez hini? ");
INSERT INTO breBRG_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pilpous, lam da gentañ an treust eus da lagad, ha neuze e weli penaos e lami ar blouzenn eus lagad da vreur. ");
INSERT INTO breBRG_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Na roit ket an traoù santel d'ar chas, ha na daolit ket ho perlez dirak ar moc'h, gant aon n'o mac'hfent, hag, o tistreiñ, na ziskolpfent ac'hanoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Goulennit, hag e vo roet deoc'h; klaskit, hag e kavot; skoit, hag e vo digoret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Rak an neb a c'houlenn, a resev; an neb a glask, a gav; hag an neb a sko, e vez digoret dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Piv ac'hanoc'h a roio ur maen d'e vab, pa c'houlenn digantañ bara? ");
INSERT INTO breBRG_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pe, mar goulenn ur pesk, a roio dezhañ un naer? ");
INSERT INTO breBRG_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mar gouzoc'h eta, ha c'hwi fall, reiñ traoù mat d'ho pugale, pegement muioc'h ho Tad a zo en neñv a roio traoù mat d'ar re o goulenn digantañ! ");
INSERT INTO breBRG_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kement tra a fell deoc'h e rafe an dud deoc'h, grit ivez anezhañ dezho; rak-se eo al lezenn hag ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","It e-barzh dre an nor strizh. Rak ledan eo an nor ha frank eo an hent a gas d'ar gollidigezh, ha kalz a dud a dremen dre eno; ");
INSERT INTO breBRG_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","met strizh eo an nor hag enk eo an hent a gas d'ar vuhez, hag ez eus nebeut a dud hag a dremen drezo. ");
INSERT INTO breBRG_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Diwallit diouzh ar fals-profeded, a zeu d'ho kavout gwisket e deñved, hag a zo en diabarzh nemet bleizi skraperien. ");
INSERT INTO breBRG_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","O anavezout a reot diouzh o frouezh. Ha dastum a reer rezin diwar spern, pe fiez diwar askol? ");
INSERT INTO breBRG_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Evel-se, pep gwezenn vat a zoug frouezh mat, ha pep gwezenn fall a zoug frouezh fall. ");
INSERT INTO breBRG_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ur wezenn vat ne c'hell ket dougen frouezh fall, hag ur wezenn fall ne c'hell ket dougen frouezh mat. ");
INSERT INTO breBRG_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pep gwezenn na zoug ket frouezh mat, a zo troc'het ha taolet en tan. ");
INSERT INTO breBRG_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","O anavezout a reot eta diouzh o frouezh. ");
INSERT INTO breBRG_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kement hini a lavar din: Aotrou, Aotrou, n'aio ket e rouantelezh an neñvoù, met ar re a ra bolontez va Zad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Meur a hini a lavaro din en deiz-se: Aotrou, Aotrou, ha n'hon eus ket profedet ez anv? Ha n'hon eus ket kaset kuit an diaoulien ez anv? Ha n'hon eus ket graet kalz a virakloù ez anv? ");
INSERT INTO breBRG_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Neuze, me a lavaro sklaer dezho: Biskoazh ne'm eus hoc'h anavezet; en em dennit diouzhin, c'hwi en em ro d'ar fallentez. ");
INSERT INTO breBRG_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","An hini eta a glev ar c'homzoù-mañ a lavaran, hag a sent outo, a vo heñvel ouzh un den fur en deus savet e di war ar roc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kouezhet eo ar glav, deuet eo ar stêrioù, ha c'hwezhet o deus an avelioù hag en em roet o deus a-enep an ti-se; n'eo ket kouezhet, abalamour ma oa diazezet war ar roc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Met an hini a glev ar c'homzoù-mañ a lavaran, ha ne sent ket outo, a zo heñvel ouzh un den diskiant en deus savet e di war an traezh. ");
INSERT INTO breBRG_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kouezhet eo ar glav, deuet eo ar stêrioù, ha c'hwezhet o deus an avelioù hag en em roet o deus a-enep an ti-se; kouezhet eo, ha bras eo bet e ziskar. ");
INSERT INTO breBRG_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","P'en devoe Jezuz peurlavaret ar c'homzoù-mañ, ar bobl a oa souezhet gant e gelennadurezh, ");
INSERT INTO breBRG_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","rak o deskiñ a rae evel unan a oa galloud gantañ, ha neket evel ar skribed. ");
INSERT INTO breBRG_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pa voe diskennet eus ar menez, ul lod bras a dud a heulias anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ha setu, un den lovr a zeuas hag en em stouas dirazañ, en ur lavarout: Aotrou, mar fell dit, e c'hellez va glanaat. ");
INSERT INTO breBRG_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jezuz a astennas e zorn, en stokas, hag a lavaras dezhañ: Fellout a ra din, bez glanaet. Ha diouzhtu, e lorgnez a voe glanaet. ");
INSERT INTO breBRG_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Neuze Jezuz a lavaras dezhañ: Kemer evezh na lavari an dra-mañ da zen; met kae hag en em ziskouez d'ar beleg, ha kinnig ar prof en deus Moizez gourc'hemennet, evit ma servijo-se da desteni dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pa voe antreet Jezuz e Kafarnaoum, ur c'hantener a zeuas d'e gavout, ");
INSERT INTO breBRG_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ouzh e bediñ, hag o lavarout: Aotrou, va mevel a zo gourvezet klañv em zi, seizet, hag emañ e gwall boan. ");
INSERT INTO breBRG_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jezuz a lavaras dezhañ: Mont a rin, hag e yac'hain anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ar c'hantener a respontas: Aotrou, n'on ket din e teufes dindan va zoenn; met lavar ur ger hepken, ha va mevel a vo yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Rak me va-unan a zo un den lakaet dindan galloud re all, met dindanon em eus soudarded, hag e lavaran da unan: Kae! hag ez a, d'egile: Deus! Hag e teu, ha da'm mevel: Gra kement-mañ! Hag en gra. ");
INSERT INTO breBRG_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jezuz, pa glevas kement-se, a voe souezhet, hag a lavaras d'ar re en heulie: Me a lavar deoc'h e gwirionez, ne'm eus ket kavet ur feiz ken bras, zoken en Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Evel-se e lavaran deoc'h penaos e teuio meur a hini eus ar sav-heol hag eus ar c'huzh-heol, hag a vo ouzh taol e rouantelezh an neñvoù, gant Abraham, Izaak ha Jakob, ");
INSERT INTO breBRG_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","met bugale ar rouantelezh a vo taolet e deñvalijenn an diavaez, e-lec'h ma vo goueladegoù ha grigoñsadegoù-dent. ");
INSERT INTO breBRG_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Neuze Jezuz a lavaras d'ar c'hantener: Kae, ha ra vo graet dit hervez da feiz. Hag en eur-se memes, e vevel a voe yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jezuz, o vezañ deuet da di Pêr, a welas mamm-gaer Pêr en he gwele, klañv gant an derzhienn. ");
INSERT INTO breBRG_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O vezañ stoket ouzh he dorn, raktal an derzhienn a yeas kuit diouti; hi a savas hag a servijas anezho. ");
INSERT INTO breBRG_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","An abardaez o vezañ deuet, e voe degaset dezhañ meur a hini dalc'het gant diaoulien. Eñ a gasas kuit ar speredoù dre e c'her hag a yac'haas an holl re a oa klañv, ");
INSERT INTO breBRG_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","evit ma vije peurc'hraet ar pezh a oa bet lavaret gant Izaia ar profed: Kemeret en deus e-unan hor mac'hagnoù, ha douget en deus hor c'hleñvedoù. ");
INSERT INTO breBRG_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Met Jezuz, o welout kalz a dud war e dro, a c'hourc'hemennas tremen en tu all. ");
INSERT INTO breBRG_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ur skrib a dostaas hag a lavaras dezhañ: Va mestr, me a heulio ac'hanout e kement lec'h ma'z i. ");
INSERT INTO breBRG_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jezuz a lavaras dezhañ: Al lern o deus toulloù, ha laboused an neñv neizhioù; met Mab an den n'en deus lec'h ebet evit harpañ e benn. ");
INSERT INTO breBRG_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Unan all eus e ziskibien a lavaras dezhañ: Aotrou, lez ac'hanon da vont da gentañ da sebeliañ va zad. ");
INSERT INTO breBRG_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jezuz a lavaras dezhañ: Heul ac'hanon, ha lez ar re varv da sebeliañ o re varv. ");
INSERT INTO breBRG_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pignat a reas en ur vag, hag e ziskibien en heulias. ");
INSERT INTO breBRG_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Neuze e savas ur barrad gwall-amzer bras war ar mor, en hevelep doare ma oa ar vag goloet gant ar c'hoummoù-mor. Hag eñ a gouske. ");
INSERT INTO breBRG_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","E ziskibien a zeuas, hag en dihunas o lavarout: Aotrou, savete ac'hanomp, mont a reomp da goll. ");
INSERT INTO breBRG_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Neuze e lavaras dezho: Perak hoc'h eus aon, tud a nebeut a feiz? Neuze, o vezañ savet, e c'hourc'hemennas an avelioù hag ar mor, hag e voe ur sioulder bras. ");
INSERT INTO breBRG_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","An dud-se a voe souezhet, hag a lavare: Piv eo hemañ, ma sent memes an avelioù hag ar mor outañ? ");
INSERT INTO breBRG_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pa voe tremenet en tu all, e bro ar C'hergezeniz, daou zen dalc'het gant diaoulien, o tont eus ar bezioù, a zeuas d'e gavout. Ken dañjerus e oant, ma ne c'helle den tremen dre an hent-se. ");
INSERT INTO breBRG_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ha setu e krijont en ur lavarout: Petra a zo etre ni ha te, Jezuz, Mab Doue? Ha deuet out amañ evit hor poaniañ a-raok an amzer? ");
INSERT INTO breBRG_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bez' e oa, ur pennad diouzh eno, ur vandenn vras a voc'h o peuriñ. ");
INSERT INTO breBRG_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hag an diaoulien en pedas o lavarout: Mar kasez ac'hanomp kuit, lez ac'hanomp da vont er vandenn voc'h-se. ");
INSERT INTO breBRG_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eñ a lavaras dezho: Kit. Int, o vezañ aet er-maez, a yeas er moc'h; ha setu an holl vandenn en em daolas eus al lec'h uhel-se er mor, hag e varvjont en doureier. ");
INSERT INTO breBRG_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ar re o mesae a dec'has kuit, hag, o vezañ deuet e kêr, e lavarjont an holl draoù-se hag ar pezh a oa c'hoarvezet gant ar re a oa dalc'het gant an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ha setu holl dud kêr a yeas a-raok Jezuz; o vezañ e welet, e pedjont anezhañ da bellaat diouzh o bro. ");
INSERT INTO breBRG_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Neuze, o vezañ aet en ur vag, e treuzas ar mor, hag e teuas en e gêr. ");
INSERT INTO breBRG_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ha setu e tegasjont dezhañ un den seizet gourvezet war ur gwele. Jezuz, o welout o feiz, a lavaras d'an den seizet: Va mab, kemer fiziañs, da bec'hedoù a zo pardonet dit. ");
INSERT INTO breBRG_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Neuze ur re eus ar skribed a soñje en o c'halonoù: Hemañ a wallgomz. ");
INSERT INTO breBRG_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Met Jezuz, oc'h anavezout o soñjezonoù, a lavaras: Perak hoc'h eus soñjoù fall en ho kalonoù? ");
INSERT INTO breBRG_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Petra eo an aesoc'h, lavarout: Da bec'hedoù a zo pardonet dit, pe lavarout: Sav ha bale? ");
INSERT INTO breBRG_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Met evit ma ouiot penaos Mab an den en deus war an douar ar galloud da bardoniñ ar pec'hedoù, -e lavaras d'an den seizet-: Sav, kemer da wele, ha kae da'z ti. ");
INSERT INTO breBRG_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hag e savas, hag ez eas d'e di. ");
INSERT INTO breBRG_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ar bobl, o vezañ gwelet kement-se, a voe souezhet, hag a roas gloar da Zoue m'en devoa roet un hevelep galloud d'an dud. ");
INSERT INTO breBRG_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pa'z eas Jezuz ac'hane, e welas un den anvet Mazhev, azezet e ti ar gwirioù, hag e lavaras dezhañ: Deus war va lerc'h. Eñ, o vezañ savet, en heulias. ");
INSERT INTO breBRG_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jezuz o vezañ ouzh taol en ti, kalz a bublikaned hag a dud a vuhez fall en em lakaas ivez ouzh taol gantañ ha gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ar farizianed, o welout kement-se, a lavaras d'e ziskibien: Perak e tebr ho mestr gant ar bublikaned ha gant an dud a vuhez fall? ");
INSERT INTO breBRG_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jezuz o vezañ klevet-se a lavaras dezho: N'eo ket ar re a zo yac'h o deus ezhomm a vedisin, met ar re a zo klañv. ");
INSERT INTO breBRG_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Met it, ha deskit ar pezh a zo lavaret gant ar c'homzoù-mañ: Trugarez a fell din, ha neket aberzhoù, rak n'on ket deuet evit gervel ar re reizh d'ar geuzidigezh, met ar bec'herien. ");
INSERT INTO breBRG_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Neuze diskibien Yann a zeuas d'e gavout, o lavarout: A-belec'h e teu, ma yun alies ar farizianed ha ni, ha da ziskibien-te ne yunont ket? ");
INSERT INTO breBRG_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jezuz a lavaras dezho: Mignoned ar pried, ha gallout a reont en em c'hlac'hariñ e-pad ma'z emañ ar pried ganto? Met deizioù a zeuio ma vo lamet ar pried diganto, ha neuze e yunint. ");
INSERT INTO breBRG_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Den ne laka un tamm mezher nevez ouzh un dilhad kozh, rak diframmañ a rafe an dilhad, hag ar rog a vefe brasoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne lakaer ket kennebeut gwin nevez e seier-lêr kozh, rak ar seier a ziframmfe, ar gwin en em skuilhfe, hag ar seier-lêr a vefe kollet; met ar gwin nevez a zle bezañ lakaet e seier nevez, hag an daou en em vir a-unan. ");
INSERT INTO breBRG_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Evel ma lavare dezho an traoù-se, setu ur penn a zeuas hag en em stouas dirazañ, en ur lavarout: Va merc'h a zo o paouez mervel; met deus da lakaat da zaouarn warni, hag e vevo ");
INSERT INTO breBRG_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jezuz a savas, hag a yeas war e lerc'h gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Setu ur wreg klañv, daouzek vloaz a oa, gant an diwadañ, a dostaas outañ a-ziadreñv, hag a stokas ouzh bevenn e zilhad. ");
INSERT INTO breBRG_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Rak hi a lavare enni hec'h-unan: Mar gellan hepken stekiñ ouzh e zilhad, e vin yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jezuz, o vezañ distroet, hag o sellout outi, a lavaras: Va merc'h, kemer fiziañs, da feiz he deus da yac'haet. Ha raktal ar wreg a voe yac'haet, adalek an eur-se. ");
INSERT INTO breBRG_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pa voe erruet Jezuz e ti ar penn, ha pa welas ar fleüterien hag un toullad dud oc'h ober trouz, ");
INSERT INTO breBRG_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","e lavaras dezho: It kuit, rak ar plac'h yaouank-mañ n'eo ket marv, met kousket a ra. Hag int a rae goap outañ ");
INSERT INTO breBRG_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Goude ma voe bet kaset an dud-se er-maez, e kemeras dorn ar plac'h yaouank, hag hi a savas. ");
INSERT INTO breBRG_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ar vrud a gement-se a yeas dre an holl vro. ");
INSERT INTO breBRG_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Evel ma'z ae Jezuz pelloc'h, daou zen dall en heulias, o krial hag o lavarout: Az pez truez ouzhimp, Mab David! ");
INSERT INTO breBRG_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pa voe deuet en ti, an dud dall-mañ a zeuas d'e gavout; eñ a lavaras dezho: Ha c'hwi a gred e c'hellfen ober kement-se? Ya, Aotrou! emezo. ");
INSERT INTO breBRG_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Neuze e stokas ouzh o daoulagad, en ur lavarout: Ra vo graet deoc'h hervez ho feiz. ");
INSERT INTO breBRG_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hag o daoulagad a voe digoret; Jezuz a reas dezho an difenn start-mañ: Diwallit na ouefe den an dra-se. ");
INSERT INTO breBRG_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Met int, o vezañ aet er-maez, a gasas ar vrud anezhañ dre an holl vro. ");
INSERT INTO breBRG_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Evel ma'z aent kuit, setu e voe degaset dezhañ un den mut dalc'het gant un diaoul. ");
INSERT INTO breBRG_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pa voe kaset an diaoul kuit, an den mut a gomzas; hag ar bobl souezhet a lavare: Biskoazh n'eo bet gwelet kement all en Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Met ar farizianed a lavare: Kas a ra kuit an diaoulien dre briñs an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jezuz a yae tro-war-dro er c'hêrioù hag er bourc'hioù, o kelenn en o sinagogennoù, o prezeg keloù mat ar rouantelezh, hag o pareañ pep kleñved ha pep mac'hagn e-touez ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","O welout an holl dud-se, en devoe truez outo, abalamour ma oant skuizh ha dianket, evel deñved hep pastor. ");
INSERT INTO breBRG_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Neuze e lavaras d'e ziskibien: An eost a zo bras, met nebeut a zo al labourerien. ");
INSERT INTO breBRG_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pedit eta Mestr an eost evit ma kaso labourerien en e eost. ");
INSERT INTO breBRG_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Neuze e c'halvas e zaouzek diskibl, hag e roas dezho ar galloud da gas kuit ar speredoù hudur, ha da yac'haat pep kleñved ha pep mac'hagn. ");
INSERT INTO breBRG_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Setu anvioù an daouzek abostol: An hini kentañ, Simon anvet Pêr, hag Andrev e vreur; Jakez mab Zebedea, ha Yann e vreur; ");
INSERT INTO breBRG_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ha Bartolome; Tomaz ha Mazhev ar publikan; Jakez mab Alfe, ha Lebbe lesanvet Tadde; ");
INSERT INTO breBRG_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon ar C'hananead, ha Judaz Iskariod, a oa an hini en gwerzhas. ");
INSERT INTO breBRG_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jezuz a gasas an daouzek den-se, goude bezañ roet dezho ar gourc'hemennoù war-lerc'h: N'it ket etrezek ar baganed, ha n'it ket e kêrioù ar Samaritaned; ");
INSERT INTO breBRG_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","met, it kentoc'h etrezek deñved kollet ti Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","En ur vont, prezegit ha lavarit: Rouantelezh an neñvoù a zo tost. ");
INSERT INTO breBRG_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pareit ar re glañv, glanait ar re lovr, adsavit ar re varv da vev, kasit kuit an diaoulien; resevet hoc'h eus evit netra, roit evit netra. ");
INSERT INTO breBRG_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na gemerit nag aour, nag arc'hant, na moneiz en ho kouriz, ");
INSERT INTO breBRG_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","na sac'h evit ar veaj, na daou wiskamant, na botoù, na bazh; rak al labourer a zo dleet dezhañ e voued. ");
INSERT INTO breBRG_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","E peseurt kêr bennak pe bourc'h bennak ma'z eot, goulennit piv a zo din d'ho tegemer, ha chomit eno betek ma'z eot kuit. ");
INSERT INTO breBRG_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","En ur vont e-barzh an ti, saludit-eñ, ");
INSERT INTO breBRG_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ha, mar deo din an ti a gement-se, ra zeuio ho peoc'h warnañ; met, ma n'eo ket din, ra zistroio ho peoc'h deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ha p'en em gavo tud n'ho tegemerint ket, ha ne selaouint ket ho komzoù, pa'z eot kuit eus an ti-se pe eus ar gêr-se, hejit ar poultr eus ho treid. ");
INSERT INTO breBRG_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Me a lavar deoc'h, e gwirionez, penaos e vo dousoc'h da vro Sodom ha Gomora e deiz ar varn, eget d'ar gêr-se. ");
INSERT INTO breBRG_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Setu, e kasan ac'hanoc'h evel deñved e-touez ar bleizi, bezit eta evezhiek evel naered, ha eeun evel koulmed. ");
INSERT INTO breBRG_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Diwallit diouzh an dud, rak ho kas a raint dirak al lezioù-barn hag e skourjezint ac'hanoc'h en o sinagogennoù; ");
INSERT INTO breBRG_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kaset e viot dirak gouarnerien ha dirak rouaned abalamour din, evit reiñ testeni din dirazo ha dirak ar baganed. ");
INSERT INTO breBRG_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Met pa viot lakaet etre o daouarn, n'en em lakait ket en poan eus an doare ma komzot, nag eus ar pezh a lavarot, rak roet e vo deoc'h en eur-se ar pezh ho po da lavarout. ");
INSERT INTO breBRG_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Rak ne vo ket c'hwi a gomzo, met Spered ho Tad eo, a gomzo ennoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ar breur a roio e vreur d'ar marv, hag an tad e vugel; ar vugale en em savo a-enep o zud, hag o lakaint d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kasaet e viot gant an holl abalamour da'm anv, met an hini a gendalc'ho betek ar fin, a vo salvet. ");
INSERT INTO breBRG_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pa viot gwallgaset en ur gêr, tec'hit d'un all; me a lavar deoc'h e gwirionez, n'ho po ket echuet da vont dre holl gêrioù Israel, ma vo deuet Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","An diskibl n'eo ket uheloc'h eget e vestr, nag ar mevel uheloc'h eget e aotrou. ");
INSERT INTO breBRG_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A-walc'h eo d'an diskibl bezañ evel e vestr, ha d'ar mevel bezañ evel e aotrou. Mar o deus galvet mestr an tiegezh Beelzebul, pegement muioc'h ne c'halvint ket tud e diegezh. ");
INSERT INTO breBRG_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","N'ho pet ket aon eta rak int, rak n'eus netra goloet na vo dizoloet, ha netra kuzhet na zle bezañ anavezet. ");
INSERT INTO breBRG_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ar pezh a lavaran deoc'h en deñvalijenn, lavarit-eñ er sklêrijenn, hag ar pezh a lavaran deoc'h e pleg ho skouarn, prezegit-eñ war an toennoù. ");
INSERT INTO breBRG_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","N'ho pet ket aon dirak ar re a lazh ar c'horf ha ne c'hellont ket lazhañ an ene; doujit kentoc'h an hini a c'hell lakaat an ene hag ar c'horf er gehenn. ");
INSERT INTO breBRG_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ha ne werzher ket daou c'holvan evit ur gwenneg? Koulskoude, ne gouezh ket unan anezho war an douar hep bolontez ho Tad. ");
INSERT INTO breBRG_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ha zoken holl vlev ho penn a zo kontet. ");
INSERT INTO breBRG_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","N'ho pet ket aon eta, c'hwi a dalvez muioc'h eget kalz a c'holvaned. ");
INSERT INTO breBRG_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Piv bennak eta a anzavo ac'hanon dirak an dud, ec'h anzavin ivez anezhañ dirak va Zad a zo en neñvoù; ");
INSERT INTO breBRG_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","met an hini a zinac'ho ac'hanon dirak an dud, e tinac'hin ivez anezhañ dirak va Zad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na soñjit ket e vefen deuet da zegas ar peoc'h war an douar; n'on ket deuet da zegas ar peoc'h, met ar c'hleze. ");
INSERT INTO breBRG_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Rak deuet on da lakaat an dizunvaniezh etre ar mab hag e dad, etre ar verc'h hag he mamm, etre ar verc'h-kaer hag he mamm-gaer, ");
INSERT INTO breBRG_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","hag an den en devo evit enebourien tud e diegezh. ");
INSERT INTO breBRG_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","An neb a gar e dad pe e vamm muioc'h egedon, n'eo ket din ac'hanon; hag an neb a gar e vab pe e verc'h muioc'h egedon, n'eo ket din ac'hanon; ");
INSERT INTO breBRG_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","an neb na gemer ket e groaz ha na'm heul ket, n'eo ket din ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","An neb a viro e vuhez, he c'hollo, hag an neb a gollo he buhez abalamour din, he c'havo. ");
INSERT INTO breBRG_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","An neb ho tegemer, am degemer, hag an neb am degemer, a zegemer an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","An neb a zegemer ur profed en anv a brofed, en devo ur gopr a brofed; an neb a zegemer un den reizh en anv a zen reizh, en devo ur gopr a zen reizh. ");
INSERT INTO breBRG_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ha piv bennak a roio ur werennad dour fresk hepken da unan eus ar re vihan-se abalamour ma'z eo va diskibl, en lavaran deoc'h e gwirionez, ne gollo ket e c'hopr. ");
INSERT INTO breBRG_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","P'en devoe Jezuz echuet da reiñ e gemennoù d'e zaouzek diskibl, ez eas ac'hane da gelenn ha da brezeg e kêrioù ar vro. ");
INSERT INTO breBRG_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yann, o vezañ klevet en e brizon komz diwar-benn oberoù ar C'hrist, a gasas daou eus e ziskibien da lavarout dezhañ: ");
INSERT INTO breBRG_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bez' out an hini a dle dont, pe e tleomp gortoz unan all? ");
INSERT INTO breBRG_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jezuz a respontas hag a lavaras dezho: It ha lavarit da Yann ar pezh a glevit hag ar pezh a welit: ");
INSERT INTO breBRG_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ar re dall a wel, ar re gamm a gerzh, ar re lovr a zo glanaet, ar re vouzar a glev, ar re varv a adsav da vev, ar c'heloù mat a zo prezeget d'ar beorien. ");
INSERT INTO breBRG_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Eürus eo an neb ne gavo ket a skouer fall ennon. ");
INSERT INTO breBRG_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Evel ma'z aent kuit, Jezuz en em lakaas da lavarout d'ar bobl diwar-benn Yann: Petra oc'h aet da welout el lec'h distro? Ur bennduenn hejet gant an avel? ");
INSERT INTO breBRG_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Met petra oc'h aet da welout? Un den gwisket gant dilhad kaer? Setu, ar re a zo gwisket gant dilhad kaer a zo e tiez ar rouaned. ");
INSERT INTO breBRG_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Met petra oc'h aet da welout? Ur profed? Ya a lavaran deoc'h, ha muioc'h eget ur profed. ");
INSERT INTO breBRG_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Rak eñ eo an hini ma'z eo skrivet diwar e benn: Setu, e kasan va c'hannad dirak da zremm, hag a ficho an hent a-raok dit. ");
INSERT INTO breBRG_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Me a lavar deoc'h e gwirionez, e-touez ar re a zo bet ganet gant gwragez, n'eus bet savet hini brasoc'h eget Yann-Vadezour; ha koulskoude, ar bihanañ e rouantelezh an neñvoù a zo brasoc'h egetañ. ");
INSERT INTO breBRG_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Adalek amzer Yann betek vremañ, rouantelezh an neñvoù a zo kemeret dre nerzh, hag ar re daer eo he c'hemer. ");
INSERT INTO breBRG_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rak an holl brofeded hag al lezenn o deus diouganet betek Yann; ");
INSERT INTO breBRG_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ha mar fell deoc'h kompren, eñ eo an Elia a dlee dont. ");
INSERT INTO breBRG_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ra selaouo an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ouzh petra e keñverin ar rummad-mañ? Heñvel eo ouzh bugale azezet war al leurgêrioù, hag a gri da vugale all, ");
INSERT INTO breBRG_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","o lavarout: Ni hon eus sonet deoc'h ar fleüt, ha n'hoc'h eus ket dañset; ni hon eus kanet hirvoudoù deoc'h, ha n'hoc'h eus ket douget kañv. ");
INSERT INTO breBRG_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Rak Yann a zo deuet, hep debriñ nag evañ, hag e lavaront: Un diaoul a zo ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mab an den a zo deuet, o tebriñ hag oc'h evañ, hag e lavaront: Setu un debrer hag un ever, ur mignon d'ar bublikaned ha d'an dud a vuhez fall. Met ar furnez a zo bet reishaet gant he bugale. ");
INSERT INTO breBRG_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Neuze en em lakaas d'ober rebechoù d'ar c'hêrioù en devoa graet enno an darn vuiañ eus e virakloù, abalamour ma n'o devoa ket bet keuz. ");
INSERT INTO breBRG_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gwalleur dit, Korazin! Gwalleur dit, Betsaida! Rak ma vije bet graet e Tir hag e Sidon ar mirakloù a zo bet graet ennoc'h, pell zo e vijent kaout keuz, o kemer ar sac'h hag al ludu. ");
INSERT INTO breBRG_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Setu perak, en lavaran deoc'h, e deiz ar varn, e vo dousoc'h da Dir ha da Sidon, eget deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ha te, Kafarnaoum, te a zo bet savet betek an neñv, izelaet e vi betek lec'h ar marv; rak mar vije bet graet e Sodom ar mirakloù a zo bet graet ez kreiz, e vije c'hoazh hiziv en he sav. ");
INSERT INTO breBRG_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Setu perak, en lavaran deoc'h, e deiz ar varn, e vo dousoc'h da Vro-Sodom, eget dit. ");
INSERT INTO breBRG_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","En amzer-se, Jezuz a gemeras ar gomz hag a lavaras: Da veuliñ a ran, o Tad, Aotrou an neñv hag an douar, ma ec'h eus kuzhet an traoù-mañ ouzh ar re fur hag ouzh ar re skiantek, ha ma ec'h eus o diskuliet d'ar vugale! ");
INSERT INTO breBRG_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ya, o Tad, da veuliñ a ran dre ma ec'h eus c'hoantaet evel-se. ");
INSERT INTO breBRG_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pep tra a zo bet roet din gant va Zad, ha den ne oar piv eo ar Mab, nemet an Tad, na piv eo an Tad kennebeut, nemet ar Mab, hag an hini e fell d'ar Mab e ziskuliañ dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Deuit da'm c'havout, c'hwi holl a zo skuizh ha bec'hiet, ha me ho tiboanio. ");
INSERT INTO breBRG_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kemerit va yev warnoc'h ha deskit diganin, rak me a zo dous hag izelek a galon, hag e kavot diskuizh d'hoc'h eneoù; ");
INSERT INTO breBRG_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","rak va yev a zo dous, ha va bec'h a zo skañv. ");
INSERT INTO breBRG_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","En amzer-se, Jezuz a dremenas dre barkeier ed un deiz sabad; e ziskibien, naon ganto, en em lakaas da ziframmañ tañvouezennoù ha d'o zebriñ. ");
INSERT INTO breBRG_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ar farizianed, o welout kement-se, a lavaras dezhañ: Setu, da ziskibien a ra ar pezh n'eo ket aotreet ober e-pad ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eñ a lavaras dezho: N'hoc'h eus ket lennet ar pezh a reas David, p'en devoa naon, eñ hag ar re a oa gantañ? ");
INSERT INTO breBRG_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Penaos ez eas e ti Doue, hag e tebras baraoù a ginnig, a oa arabat dezhañ o debriñ, kennebeut d'ar re a oa gantañ, met d'ar veleien hepken? ");
INSERT INTO breBRG_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pe, n'hoc'h eus ket lennet er lezenn penaos en deizioù sabad, ar veleien a dorr ar sabad en templ, hag ez int divlam? ");
INSERT INTO breBRG_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Met, me a lavar deoc'h, bez' ez eus amañ un dra bennak brasoc'h eget an templ. ");
INSERT INTO breBRG_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mar goufec'h ar pezh a dalv kement-mañ: Kemer a ran plijadur en drugarez ha neket en aberzhoù, n'ho pefe ket kondaonet tud didamall. ");
INSERT INTO breBRG_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Rak Mab an den a zo mestr war ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","O vezañ aet ac'hane, Jezuz a yeas er sinagogenn. ");
INSERT INTO breBRG_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ha setu e oa eno un den en devoa un dorn disec'het. Goulenn a rejont ouzh Jezuz, evit e damall: Hag aotreet eo yac'haat e deizioù ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Eñ a respontas dezho: Pehini ac'hanoc'h, ma n'en deus nemet un dañvad, ha mar kouezh en ur poull e deiz ar sabad, ne zeufe ket d'e dennañ ha d'e sevel? ");
INSERT INTO breBRG_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pegement e dalv muioc'h un den eget un dañvad! Dre-se, e c'heller ober vat e deizioù ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Neuze e lavaras d'an den: Astenn da zorn. Hag ec'h astennas anezhañ, hag e teuas yac'h evel egile. ");
INSERT INTO breBRG_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ar farizianed, o vezañ aet er-maez, a zalc'has raktal kuzul a-enep dezhañ, evit e lakaat da vervel. ");
INSERT INTO breBRG_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Met Jezuz, o c'houzout kement-se, en em dennas ac'hane; kalz a dud a yeas war e lerc'h, hag eñ a yac'haas an holl re glañv. ");
INSERT INTO breBRG_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Gourc'hemenn a rae start dezho na zisklêrjent ket anezhañ, ");
INSERT INTO breBRG_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","evit ma vefe peurc'hraet a pezh a oa bet lavaret gant Izaia ar profed: ");
INSERT INTO breBRG_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Setu va servijer am eus dibabet, va c'haret-mat, ennañ va ene en deus kemeret plijadur; lakaat a rin va Spered warnañ, hag ec'h embanno ar reizhder d'ar broadoù; ");
INSERT INTO breBRG_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ne rioto ket, ne grio ket, ha den ne glevo e vouezh er straedoù; ");
INSERT INTO breBRG_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ne frigaso ket ar raosklenn dorret, ha ne vougo ket al lutigenn a zivoged c'hoazh, ken en devo lakaet ar reizhder da drec'hiñ; ");
INSERT INTO breBRG_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","hag ar broadoù a espero en e anv. ");
INSERT INTO breBRG_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Neuze e voe degaset dezhañ un den dalc'het gant un diaoul, dall ha mut, hag e yac'haas anezhañ, en hevelep doare ma komze ha ma wele. ");
INSERT INTO breBRG_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","An holl bobl, souezhet bras, a lavare: Ha n'eo ket hemañ Mab David? ");
INSERT INTO breBRG_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Met ar farizianed, pa glevjont kement-se, a lavaras: Hennezh ne gas kuit an diaoulien nemet dre Veelzebul, priñs an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jezuz, oc'h anavezout o soñjezonoù, a lavaras dezho: Pep rouantelezh dizunanet ganti hec'h-unan a zeuio da netra, ha pep kêr pe pep ti dizunanet gantañ e-unan ne c'hello ket padout. ");
INSERT INTO breBRG_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mar deu Satan da gas Satan kuit, emañ eta dizunanet gantañ e-unan; penaos e pado e rouantelezh? ");
INSERT INTO breBRG_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mar kasan kuit an diaoulien dre Veelzebul, dre biv o c'has kuit ho mibien? Dre-se e vint ho parnerien. ");
INSERT INTO breBRG_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Met mar kasan kuit an diaoulien dre Spered Doue, eo eta gwir penaos eo rouantelezh Doue deuet betek ennoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pe, penaos e c'hell unan bennak mont e ti un den kreñv ha preizhañ e vadoù, nemet en defe da gentañ ereet an den kreñv-se; neuze hepken e preizho e di. ");
INSERT INTO breBRG_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","An hini n'emañ ket ganin a zo a-enep din, hag an hini na zastum ket ganin a stlabez. ");
INSERT INTO breBRG_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rak-se, me a lavar deoc'h, pep pec'hed ha pep gwallgomz a vo pardonet d'an dud, met ar gwallgomz a-enep ar Spered-Santel, ne vo ket pardonet dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Piv bennak a gomzo a-enep Mab an den, e vo pardonet dezhañ; met piv bennak a gomzo a-enep ar Spered-Santel, ne vo ket pardonet dezhañ, nag er c'hantved-mañ, nag er c'hantved da zont. ");
INSERT INTO breBRG_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Pe lavarit eo mat ar wezenn hag eo mat he frouezh, pe lavarit eo fall ar wezenn hag eo fall he frouezh; rak anavezout a reer ur wezenn diouzh he frouezh. ");
INSERT INTO breBRG_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lignez a naered-gwiber, penaos e c'hellfec'h lavarout traoù mat, fall evel ma'z oc'h? Rak eus leunder ar galon e komz ar genoù. ");
INSERT INTO breBRG_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","An den mat a denn traoù mat eus e deñzor mat en e galon, hag an den fall a denn traoù fall eus e deñzor fall en e galon. ");
INSERT INTO breBRG_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Me a lavar deoc'h, e deiz ar varn, an dud a rento kont eus pep ger didalvez o devo lavaret; ");
INSERT INTO breBRG_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","rak, diwar da gomzoù e vi reishaet, ha diwar da gomzoù e vi kondaonet. ");
INSERT INTO breBRG_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Neuze ur re bennak eus ar skribed hag eus ar farizianed a gemeras ar gomz hag a lavaras: Mestr, ni hor befe c'hoant da welout ur mirakl graet ganit. ");
INSERT INTO breBRG_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Eñ a respontas dezho: Ur rummad fall hag avoultr a c'houlenn ur mirakl; ne vo roet mirakl ebet dezhañ, nemet hini ar profed Jona. ");
INSERT INTO breBRG_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Rak evel ma voe Jona tri devezh ha teir nozvezh e kof ur pesk bras, evel-se e vo Mab an den tri devezh ha teir nozvezh e kalon an douar. ");
INSERT INTO breBRG_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tud Niniv a savo e deiz ar varn gant tud ar rummad-mañ, hag a gondaono anezho, abalamour m'o deus keuz dre brezegenn Jona, ha setu ez eus amañ brasoc'h eget Jona. ");
INSERT INTO breBRG_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Rouanez ar C'hreisteiz a savo e deiz ar varn gant tud ar rummad-mañ, hag a gondaono anezho, abalamour ma teuas eus pellder an douar evit klevout furnez Salomon, ha setu ez eus amañ brasoc'h eget Salomon. ");
INSERT INTO breBRG_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Pa vez aet kuit ur spered hudur eus un den, ez a dre lec'hioù sec'h da glask diskuizh, ha ne gav ket; ");
INSERT INTO breBRG_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","neuze e lavar: Distreiñ a rin da'm zi a-belec'h on deuet; pa zeu, e kav anezhañ goullo, skubet ha kempennet. ");
INSERT INTO breBRG_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Neuze ez a, e kemer gantañ seizh spered all gwashoc'h egetañ, hag ez eont hag e chomont ennañ; ha stad diwezhañ an den-se a zeu gwashoc'h eget an hini gentañ. Evel-se e c'hoarvezo gant ar rummad fall-mañ. ");
INSERT INTO breBRG_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Evel ma komze c'hoazh ouzh ar bobl, setu, e vamm hag e vreudeur, chomet er-maez, a glaske komz outañ. ");
INSERT INTO breBRG_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Unan bennak a lavaras dezhañ: Da vamm ha da vreudeur a zo aze er-maez, hag a glask komz ouzhit. ");
INSERT INTO breBRG_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Met Jezuz a respontas d'an hini en devoa lavaret-se dezhañ: Piv eo va mamm, piv eo va breudeur? ");
INSERT INTO breBRG_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hag, oc'h astenn e zorn war e ziskibien, e lavaras: Setu va mamm ha va breudeur. ");
INSERT INTO breBRG_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Rak piv bennak a ra bolontez va Zad a zo en neñvoù, hennezh eo va breur ha va c'hoar ha va mamm. ");
INSERT INTO breBRG_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","An devezh-se, Jezuz, o vezañ aet er-maez eus an ti, a azezas e-tal ar mor. ");
INSERT INTO breBRG_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ur bobl vras o vezañ en em zastumet en e gichen, e pignas en ur vag hag ec'h azezas; an holl bobl a chomas war an aod. ");
INSERT INTO breBRG_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Komz a reas dezho dre barabolennoù war galz a draoù, hag e lavaras: ");
INSERT INTO breBRG_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Setu, un hader a yeas er-maez da hadañ; hag evel ma hade, ul lodenn eus an had a gouezhas a-hed an hent, hag al laboused a zeuas hag he debras holl. ");
INSERT INTO breBRG_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ul lodenn all a gouezhas war ul lec'h meinek, e-lec'h ma oa nebeut a zouar; ha kerkent e savas, abalamour ne oa ket aet don en douar; ");
INSERT INTO breBRG_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","met pa zeuas an heol, e voe devet, ha dre ma ne oa ket a wrizienn, e sec'has. ");
INSERT INTO breBRG_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ul lodenn all a gouezhas e-touez ar spern; hag ar spern a greskas hag he mougas. ");
INSERT INTO breBRG_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ul lodenn all a gouezhas en douar mat hag e roas frouezh, ur c'hreunenn kant, unan all tri-ugent, hag unan all tregont. ");
INSERT INTO breBRG_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ra selaouo, an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","E ziskibien a dostaas, hag a lavaras dezhañ: Perak e komzez outo dre barabolennoù? ");
INSERT INTO breBRG_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jezuz a respontas dezho: Dre ma'z eo roet deoc'h-hu da anavezout traoù kuzhet rouantelezh an neñvoù, ha ma n'eo ket roet kement-se dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Rak roet e vo d'an neb en deus, hag en devo a-fonn; met an hini n'en deus ket, e vo lamet digantañ memes ar pezh en deus. ");
INSERT INTO breBRG_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rak-se e komzan dezho dre barabolennoù, abalamour o welout ne welont ket, hag o klevout ne glevont ha ne gomprenont ket. ");
INSERT INTO breBRG_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Evito eo peurc'hraet an diougan-mañ lavaret gant Izaia: C'hwi a glevo gant ho tivskouarn, ha ne gomprenot ket. C'hwi a sello gant ho taoulagad, ha ne welot ket. ");
INSERT INTO breBRG_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Rak kalon ar bobl-mañ a zo deuet digizidik; pounnerglevet o deus o divskouarn, ha serret o deus o daoulagad, gant aon na zeufe o daoulagad da welout, o divskouarn da glevout, o c'halon da gompren, ha na yac'hafen anezho. ");
INSERT INTO breBRG_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Eürus eo ho taoulagad, abalamour ma welont, hag ho tivskouarn, abalamour ma klevont. ");
INSERT INTO breBRG_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rak, me a lavar deoc'h e gwirionez, kalz a brofeded hag a dud reizh o deus c'hoantaet gwelout ar pezh a welit, ha n'o deus ket e welet, ha klevout ar pezh a glevit, ha n'o deus ket e glevet. ");
INSERT INTO breBRG_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Selaouit eta ar pezh a dalv parabolenn an hader. ");
INSERT INTO breBRG_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pa selaou un den ger ar rouantelezh ha pa ne gompren ket anezhañ, an hini fall a zeu hag a skrap ar pezh a zo bet hadet en e galon: hennezh eo an hini en deus degemeret an had a-hed an hent. ");
INSERT INTO breBRG_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","An hini en deus degemeret an had el lec'hioù meinek, eo an hini a glev ar ger hag e zegemer kerkent gant joa; ");
INSERT INTO breBRG_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","met n'en deus ket a wrizienn ennañ e-unan, ha ne bad nemet ur pennad; dre-se, pa zeu ar glac'har pe an heskinerezh abalamour d'ar ger, e kav kerkent skouer fall. ");
INSERT INTO breBRG_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","An hini en deus degemeret an had e-touez an drein, eo an hini a glev ar ger; met prederioù ar bed-mañ ha tromplerezh ar pinvidigezhioù, a voug ar ger, hag e laka difrouezh. ");
INSERT INTO breBRG_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","An hini en deus degemeret an had en douar mat, eo an hini a glev ar ger hag en kompren; dougen a ra frouezh, ur c'hreunenn a ro kant, unan all tri-ugent, hag unan all tregont. ");
INSERT INTO breBRG_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kinnig a reas dezho ur barabolenn all, hag e lavaras: Rouantelezh an neñvoù a zo heñvel ouzh un den en deus hadet had mat en e bark. ");
INSERT INTO breBRG_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Met, e-pad ma oa kousket an dud, e enebour a zeuas, a hadas dreog e-touez an ed, hag a yeas kuit. ");
INSERT INTO breBRG_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pa voe kresket ar geot, ha deuet e frouezh, neuze en em ziskouezas ivez an dreog. ");
INSERT INTO breBRG_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mevelien mestr an ti a zeuas da lavarout dezhañ: Aotrou, ha ne'c'h eus ket hadet had mat ez park? Penaos eta ez eus dreog ennañ? ");
INSERT INTO breBRG_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eñ a respontas dezho: Un enebour din en deus graet kement-se. Ar vevelien a lavaras dezhañ: Fellout a ra dit ec'h afemp d'e dennañ? ");
INSERT INTO breBRG_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nann, emezañ dezho, gant aon o tennañ an dreog, na ziwriziennfec'h ivez an ed. ");
INSERT INTO breBRG_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lezit o-daou da greskiñ betek an eost; ha da amzer an eost, e lavarin d'ar vederien: Tennit da gentañ an dreog hag en endrammit evit e zeviñ, met dastumit an ed em solier. ");
INSERT INTO breBRG_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kinnig a reas dezho ur barabolenn all, hag e lavaras: Rouantelezh an neñvoù a zo heñvel ouzh ur c'hreunenn sezo a gemer un den hag a had en e bark; ");
INSERT INTO breBRG_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ar bihanañ eus an holl hadoù eo, met pa'z eo kresket, ez eo brasoc'h eget al louzoù hag e teu da vezañ ur wezenn, en hevelep doare ma teu laboused an neñv da chom en he brankoù. ");
INSERT INTO breBRG_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Lavarout a reas dezho ar barabolenn all-mañ: Rouantelezh a neñvoù a zo heñvel ouzh ur goell a gemer ur wreg, hag a laka e tri muzuliad bleud, betek ma vo an toaz goet holl. ");
INSERT INTO breBRG_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jezuz a lavaras an holl draoù-se d'ar bobl e parabolennoù, ha ne gomze ket outo hep parabolenn, ");
INSERT INTO breBRG_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","evit ma vije peurc'hraet ar pezh a oa bet lavaret gant ar profed: Digeriñ a rin va genou gant parabolennoù, disklêriañ a rin traoù kuzhet abaoe krouidigezh ar bed. ");
INSERT INTO breBRG_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Neuze Jezuz, o vezañ kaset kuit ar bobl, a zeuas en ti. E ziskibien a dostaas outañ, o lavarout: Displeg deomp parabolenn dreog ar park. ");
INSERT INTO breBRG_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Eñ a respontas dezho: An hini a had an had mat, eo Mab an den; ");
INSERT INTO breBRG_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ar park eo ar bed; an had mat eo bugale ar rouantelezh; an dreog eo bugale an droug; ");
INSERT INTO breBRG_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","an enebour en deus e hadet, eo an diaoul; an eost, eo fin ar bed; ar vederien, eo an aeled ");
INSERT INTO breBRG_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Evel ma tenner an dreog, ha ma e daoler en tan, evel-se e c'hoarvezo e fin ar bed. ");
INSERT INTO breBRG_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mab an den a gaso e aeled da dennañ eus e rouantelezh an holl skouerioù fall hag ar re a ra an droug, ");
INSERT INTO breBRG_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","hag e taolint anezho en ur forn-dan, e-lec'h ma vo goueladegoù ha grigoñsadegoù-dent. ");
INSERT INTO breBRG_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Neuze an dud reizh a lugerno evel an heol e rouantelezh o Zad. Ra selaouo, an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Rouantelezh an neñvoù a zo c'hoazh heñvel ouzh un teñzor kuzhet en ur park. Pa gav un den anezhañ, en kuzh; hag en e laouenañ, ez a da werzhañ kement en deus, hag e pren ar park-se. ");
INSERT INTO breBRG_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Rouantelezh an neñvoù a zo c'hoazh heñvel ouzh ur marc'hadour a glask perlez kaer. ");
INSERT INTO breBRG_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kavet en deus ur berlezenn brizius-meurbet; mont a reas da werzhañ kement en devoa, hag en deus he frenet. ");
INSERT INTO breBRG_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Rouantelezh an neñvoù a zo c'hoazh heñvel ouzh ur roued taolet er mor, hag a zastum pesked a bep seurt. ");
INSERT INTO breBRG_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pa'z eo leun, e tenner anezhi war an aod; goude bezañ azezet, e lakaont ar re vat e listri, hag e taolont kuit ar re fall. ");
INSERT INTO breBRG_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Evel-se e c'hoarvezo e fin ar bed; an aeled a zeuio hag a zispartio ar re drouk eus a-douez ar re reizh, ");
INSERT INTO breBRG_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","hag e taolint anezho en ur forn-dan, e-lec'h ma vo goueladegoù ha grigoñsadegoù-dent. ");
INSERT INTO breBRG_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ha komprenet mat hoc'h eus an holl draoù-se? Ya, a respontjont. ");
INSERT INTO breBRG_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hag e lavaras dezho: Dre-se, kement skrib desket diwar-benn ar pezh a sell ouzh rouantelezh an neñvoù, a zo heñvel ouzh ur penn-tiegezh a denn traoù nevez ha traoù kozh eus e deñzor. ");
INSERT INTO breBRG_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Goude m'en devoe Jezuz peurlavaret ar barabolennoù-se, ez eas kuit ac'hano. ");
INSERT INTO breBRG_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","O vezañ deuet en e vro, e kelenne anezho er sinagogenn, en hevelep doare ma oant souezhet ha ma lavarent: A belec'h e teu dezhañ ar furnez hag ar mirakloù-se? ");
INSERT INTO breBRG_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ha n'eo ket mab ar c'halvez? Ha n'eo ket Mari eo e vamm? Jakez, Jozez, Simon ha Jud, ha n'int ket e vreudeur? ");
INSERT INTO breBRG_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E c'hoarezed, ha n'emaint ket holl en hon touez? A belec'h eta e teu dezhañ an holl draoù-se? ");
INSERT INTO breBRG_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hag e kavent tamall ennañ. Met Jezuz a lavaras dezho: Ur profed n'eo disprizet nemet en e vro hag en e di e-unan. ");
INSERT INTO breBRG_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne reas ket kalz a virakloù el lec'h-se, abalamour d'o diskredoni. ");
INSERT INTO breBRG_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","En amzer-se, Herodez an tetrark, o vezañ klevet komz eus Jezuz, a lavaras d'e servijerien: ");
INSERT INTO breBRG_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yann-Vadezour eo! Adsavet eo a-douez ar re varv, ha dre-se eo en em ra mirakloù drezañ. ");
INSERT INTO breBRG_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Rak Herodez en devoa kaset da gemer Yann, hag en devoa e ereet ha lakaet er prizon, abalamour da Herodiaz, gwreg Filip e vreur, ");
INSERT INTO breBRG_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","rak Yann a lavare dezhañ: N'eo ket aotreet dit he c'haout evit gwreg. ");
INSERT INTO breBRG_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","C'hoant en devoa d'e lakaat da vervel, met aon en devoa rak ar bobl, dre ma oa kemeret Yann ganto evit ur profed. ");
INSERT INTO breBRG_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Met da zeiz ganedigezh Herodez, merc'h Herodiaz a zañsas dirak an dud, hag a blijas da Herodez, ");
INSERT INTO breBRG_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","en hevelep doare ma roas e c'her dezhi gant le, penaos e roje dezhi ar pezh a c'houlennje. ");
INSERT INTO breBRG_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aliet gant he mamm, e lavaras: Ro din amañ, war ur plad, penn Yann-Vadezour. ");
INSERT INTO breBRG_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ar roue a voe glac'haret; koulskoude, abalamour d'e le ha d'ar re a oa azezet gantañ, e c'hourc'hemennas e reiñ dezhi, ");
INSERT INTO breBRG_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","hag e kasas da zibennañ Yann er prizon. ");
INSERT INTO breBRG_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","E benn a voe degaset war ur plad, ha roet d'ar plac'h yaouank, hag ar plac'h yaouank e roas d'he mamm. ");
INSERT INTO breBRG_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Diskibien Yann a zeuas hag a gemeras e gorf, hag e sebeilhjont anezhañ.; hag ez ejont d'e lavarout da Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pa glevas Jezuz kement-se, ez eas kuit ac'hano en ur vag evit en em dennañ a-du en ul lec'h distro. Ar bobl o vezañ klevet-se en heulias war droad adalek ar gêrioù. ");
INSERT INTO breBRG_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Neuze Jezuz, o vezañ aet er-maez, a welas ul lod bras a dud; truez en devoe outo, hag e yac'haas o c'hlañvourien. ");
INSERT INTO breBRG_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","An abardaez o vezañ deuet, e ziskibien a dostaas outañ hag a lavaras: Al lec'h-mañ a zo distro, ha diwezhat eo; kas kuit ar bobl, evit ma'z aint er bourc'hioù, da brenañ boued. ");
INSERT INTO breBRG_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jezuz a lavaras dezho: N'o deus ket ezhomm da vont kuit, roit hoc'h-unan da zebriñ dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lavarout a rejont dezhañ: N'hon eus amañ nemet pemp bara ha daou besk. ");
INSERT INTO breBRG_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Eñ a lavaras: Degasit int din. ");
INSERT INTO breBRG_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ober a reas d'ar bobl azezañ war ar geot, kemer a reas ar pemp bara hag an daou besk, hag o sevel e zaoulagad etrezek an neñv, e rentas grasoù. Neuze e torras ar baraoù, hag e roas anezho d'e ziskibien, evit m'o rojent d'ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Debriñ a rejont holl hag o devoa a-walc'h, hag e kasjont ganto daouzek panerad leun eus an nemorantoù. ");
INSERT INTO breBRG_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ar re o devoa debret a oa war-dro pemp mil den, hep ar gwragez hag ar vugale. ");
INSERT INTO breBRG_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kerkent goude, e reas d'e ziskibien mont er vag, hag e ziaraogiñ en tu all, e-pad ma kasje kuit ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","P'en devoe kaset kuit ar bobl, e pignas war ar menez evit pediñ, a-du; an abardaez o vezañ deuet, e oa eno e-unan. ");
INSERT INTO breBRG_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ar vag a oa dija e-kreiz ar mor, gwallgaset gant ar gwagennoù, rak an avel a oa en o enep. ");
INSERT INTO breBRG_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","D'ar bedervet beilhadenn eus an noz e teuas d'o c'havout, o vale war ar mor. ");
INSERT INTO breBRG_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pa welas an diskibien anezhañ, o vale war ar mor, o devoa spont hag e lavarjont: Un teuz eo! Hag e krijont gant ar spont. ");
INSERT INTO breBRG_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kerkent Jezuz a lavaras dezho: Ho pet fiziañs, me eo, n'ho pet ket aon. ");
INSERT INTO breBRG_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pêr a respontas dezhañ: Aotrou, mar deo te, gourc'hemenn ac'hanon da vont da'z kavout war an doureier. ");
INSERT INTO breBRG_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eñ a lavaras dezhañ: Deus! Pêr a ziskennas eus ar vag hag a gerzhas war an doureier, evit mont da gavout Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Met, pa welas e oa kreñv an avel, en devoa aon; hag evel ma tonae en dour, e krias, o lavarout: Aotrou, va savete! ");
INSERT INTO breBRG_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Raktal Jezuz, oc'h astenn e zorn, a grogas ennañ, hag a lavaras dezhañ: Den a nebeut a feiz, perak ac'h eus diskredet? ");
INSERT INTO breBRG_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hag e pignjont er vag, hag an avel a baouezas. ");
INSERT INTO breBRG_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ar re a oa er vag a zeuas hag a azeulas anezhañ, o lavarout: Te eo evit gwir Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","P'o devoe treuzet ar mor, e teujont da vro C'henezared. ");
INSERT INTO breBRG_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tud al lec'h-mañ, o vezañ anavezet Jezuz, a gasas kannaded en holl vro tro-war-dro, hag e voe degaset dezhañ an holl dud klañv. ");
INSERT INTO breBRG_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pediñ a rejont anezhañ d'o lezel da stekiñ hepken ouzh bevenn e zilhad. Ha kement hini a stokas, a voe yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Neuze skribed ha farizianed a zeuas eus Jeruzalem da gavout Jezuz, hag a lavaras dezhañ: ");
INSERT INTO breBRG_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Perak e torr da ziskibien hengoun a re gozh? Rak ne walc'hont ket o daouarn pa zebront o fredoù. ");
INSERT INTO breBRG_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Eñ a respontas dezho: Ha c'hwi, perak e torrit gourc'hemenn Doue gant ho hengoun? ");
INSERT INTO breBRG_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Rak Doue en deus lavaret: Enor da dad ha da vamm, ha: Piv bennak a villigo e dad pe e vamm a vo lakaet d'ar marv; ");
INSERT INTO breBRG_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","met c'hwi a lavar: An hini a lavaro d'e dad pe d'e vamm: Ar pezh am bije gallet reiñ dit a zo ur prof da Zoue, ");
INSERT INTO breBRG_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","n'eo ket dalc'het da enoriñ e dad pe e vamm. C'hwi a gas da netra ger Doue gant ho hengoun. ");
INSERT INTO breBRG_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pilpouzed, Izaia en deus profedet mat diwar ho penn, p'en deus lavaret: ");
INSERT INTO breBRG_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ar bobl-mañ a enor ac'hanon gant he muzelloù, met o c'halonoù a zo gwall bell diouzhin. ");
INSERT INTO breBRG_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Met e ven eo ec'h enoront ac'hanon, pa zeskont kredennoù a zo gourc'hemennoù tud. ");
INSERT INTO breBRG_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Neuze, o vezañ galvet ar bobl, e lavaras dezho: Selaouit, ha komprenit. ");
INSERT INTO breBRG_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","N'eo ket ar pezh a ya er genou a hudura an den, met ar pezh a zeu er-maez eus ar genou eo, a hudura an den. ");
INSERT INTO breBRG_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Neuze e ziskibien a dostaas outañ hag a lavaras dezhañ: Gouzout a rez penaos ar farizianed, o klevout ar pezh ac'h eus lavaret, o deus kavet tamall ennañ? ");
INSERT INTO breBRG_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eñ a respontas: Pep plantenn n'eo ket bet plantet gant va Zad a zo en neñv, a vo diwriziennet. ");
INSERT INTO breBRG_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lezit int; tud dall int, o ren tud dall; mar ren un dall un dall all, e kouezhint o-daou er poull. ");
INSERT INTO breBRG_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pêr, o kemer ar gomz, a lavaras dezhañ: Displeg deomp ar barabolenn-se. ");
INSERT INTO breBRG_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ha Jezuz a lavaras: C'hwi ivez, bez' oc'h c'hoazh hep skiant? ");
INSERT INTO breBRG_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ne gomprenit ket penaos kement a ya er genou, a ziskenn er c'hof, hag a vez taolet el lec'h distro? ");
INSERT INTO breBRG_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Met ar pezh a zeu er-maez eus ar genou, a zeu eus ar galon; ha se eo ar pezh a hudura an den. ");
INSERT INTO breBRG_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Rak eus ar galon e teu ar soñjoù fall, al lazherezhioù, an avoultriezhioù, ar gastaouerezhioù, al laeroñsioù, ar falstestenioù, an droukkomzoù. ");
INSERT INTO breBRG_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Setu aze an traoù a hudura an den; met debriñ hep bezañ gwalc'het an daouarn, an dra-se ne hudura ket an den. ");
INSERT INTO breBRG_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jezuz, o vezañ aet ac'hano, en em dennas da gostezioù Tir ha Sidon. ");
INSERT INTO breBRG_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Setu, ur wreg kananeat deuet eus ar vro-se, a grias, o lavarout: Az pez truez ouzhin, Aotrou, Mab David! Va merc'h a zo gwall-boaniet gant an diaoul. ");
INSERT INTO breBRG_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Eñ ne respontas ket ur ger dezhi, hag e ziskibien a dostaas outañ, o lavarout: Kas anezhi kuit, rak krial a ra war hol lerc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Respont a reas hag e lavaras: N'on bet kaset nemet etrezek an deñved kollet eus ti Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Met hi a zeuas, hag en em stouas dirazañ, o lavarout: Aotrou, sikour ac'hanon! ");
INSERT INTO breBRG_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Respont a reas: N'eo ket mat kemer bara ar vugale, hag e deurel d'ar chas bihan. ");
INSERT INTO breBRG_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Gwir eo Aotrou, emezi, met ar chas bihan a zebr ar bruzun a gouezh eus taol o mestroù. ");
INSERT INTO breBRG_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Neuze Jezuz a lavaras dezhi: Gwreg, da feiz a zo bras. Ra vo graet dit evel ma c'hoantaez. Hag en eur-se memes, he merc'h a voe yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jezuz, o vezañ aet ac'hano, a zeuas tost da vor Galilea. O vezañ pignet war ur menez, ec'h azezas eno. ");
INSERT INTO breBRG_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Neuze ul lod bras a dud a dostaas outañ, ha ganto re gamm, re dall, re vut, re vac'hagnet, ha kalz a re glañv, hag e lakajont anezho ouzh e dreid; eñ o yac'haas, ");
INSERT INTO breBRG_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","en hevelep doare ma voe souezhet an dud pa weljont ar re vut o komz, ar re gamm o kerzhout, ar re dall o welout, ar re vac'hagnet yac'haet; hag e roent gloar da Zoue Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jezuz, o vezañ galvet e ziskibien, a lavaras: Truez am eus ouzh ar bobl-mañ; rak tri deiz a zo emaint em c'hichen, ha n'o deus netra da zebriñ. Ne fell ket din o c'has war yun, gant aon na vankfe o nerzh en hent. ");
INSERT INTO breBRG_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","An diskibien a lavaras: Penaos e c'hellfemp kavout, el lec'h distro-mañ, bara a-walc'h da bredañ kement a dud. ");
INSERT INTO breBRG_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jezuz a c'houlennas outo: Pet bara hoc'h eus? Hag int a lavaras: Seizh, hag un nebeut peskedigoù. ");
INSERT INTO breBRG_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Neuze e reas d'ar bobl azezañ war an douar; ");
INSERT INTO breBRG_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","hag o vezañ kemeret ar seizh bara hag ar pesked, ha trugarekaet, e torras anezho hag o roas d'e ziskibien, hag e ziskibien o roas d'ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hag e tebrjont holl, hag o devoe a-walc'h, hag e tegasjont seizh panerad leun eus an tammoù a oa manet. ");
INSERT INTO breBRG_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ar re o devoa debret a oa war-dro pevar mil den, hep ar gwragez hag ar vugale. ");
INSERT INTO breBRG_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Goude bezañ kaset kuit ar bobl, e pignas er vag, hag e teuas da vro Magadan. ");
INSERT INTO breBRG_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ar farizianed hag ar sadukeiz a dostaas ouzh Jezuz, hag, evit e demptañ, a c'houlennjont outañ diskouez dezho ur mirakl eus an neñv. ");
INSERT INTO breBRG_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jezuz a respontas dezho: Diouzh an abardaez, e lavarit: Brav e vo an amzer rak an oabl a zo ruz; ");
INSERT INTO breBRG_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ha diouzh ar mintin: Arnev a vo rak an oabl a zo teñval-ruz. Pilpouzed, c'hwi a oar anavezout doare an oabl, ha ne c'hellit ket anavezout sinoù an amzerioù! ");
INSERT INTO breBRG_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ar rummad fall hag avoultr-mañ a c'houlenn ur mirakl, ha ne vo roet dezhañ nemet hini Jona. Hag, o vezañ o lezet, ez eas kuit. ");
INSERT INTO breBRG_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","An diskibien, o tremen en tu all, o devoa ankounac'haet kemer bara ganto. ");
INSERT INTO breBRG_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jezuz a lavaras dezho: En em virit gant evezh eus goell ar farizianed hag ar sadukeiz. ");
INSERT INTO breBRG_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","An diskibien a soñje enno o-unan hag a lavare: Abalamour n'hon eus ket a vara eo. ");
INSERT INTO breBRG_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jezuz, o vezañ anavezet kement-se, a lavaras dezho: Perak e soñjit evel-se etrezoc'h, tud a nebeut a feiz, ez eo dre n'hoc'h eus ket kemeret a vara ganeoc'h? ");
INSERT INTO breBRG_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bez' oc'h c'hoazh hep skiant, ha n'hoc'h eus ket soñj eus ar pemp bara hag ar pemp mil den, ha pet panerad ho poa kaset ganeoc'h, ");
INSERT INTO breBRG_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","nag eus ar seizh bara hag ar pevar mil den, ha pet panerad ho poa kaset ganeoc'h? ");
INSERT INTO breBRG_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Penaos eta ne gomprenit ket n'eo ket eus bara em eus komzet, pa em eus lavaret deoc'h: En em virit eus goell ar farizianed hag ar sadukeiz? ");
INSERT INTO breBRG_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Neuze e komprenjont penaos n'en devoa ket lavaret: En em virit eus goell ar bara, met eus kelennadurezh ar farizianed hag ar sadukeiz. ");
INSERT INTO breBRG_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jezuz, o vezañ deuet e douar Kezarea-Filip, a c'houlennas ouzh e ziskibien: Piv a lavar an dud on, me, Mab an den? ");
INSERT INTO breBRG_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Respont a rejont: Darn a lavar out Yann-Vadezour; darn all, Elia; darn all, Jeremia, pe unan ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eñ a lavaras dezho: Ha c'hwi, piv a lavarit ez on-me? ");
INSERT INTO breBRG_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon-Pêr a respontas: Te eo ar C'hrist, Mab an Doue bev. ");
INSERT INTO breBRG_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jezuz, oc'h adkemer ar gomz, a lavaras dezhañ: Eürus out, Simon, mab Jona, rak n'eo ket ar c'hig nag ar gwad o deus diskuliet kement-mañ dit, met va Zad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ha me a lavar dit: Te a zo Pêr, ha war ar roc'h-mañ e savin va Iliz, ha dorioù lec'h ar marv ne drec'hint ket anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Reiñ a rin dit alc'houezioù rouantelezh an neñvoù: ar pezh a erei war an douar a vo ereet en neñvoù, hag ar pezh a zierei war an douar a vo diereet en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Neuze e tifennas gwall start outo lavarout da zen e oa eñ ar C'hrist. ");
INSERT INTO breBRG_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Adalek neuze, Jezuz en em lakaas da zisklêriañ d'e ziskibien e oa ret dezhañ mont da Jeruzalem, gouzañv kalz a draoù a-berzh an henaourien, ar veleien vras, ha ar skribed, bezañ lakaet d'ar marv, hag adsevel a varv d'an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pêr, o vezañ e gemeret a-du, en em lakaas d'e repren, o lavarout: Doue ra viro, Aotrou! Kement-se ne c'hoarvezo ket ganit. ");
INSERT INTO breBRG_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Met Jezuz, o tistreiñ, a lavaras da Bêr: A-dreñv din, Satan! Ur skouer fall out din, rak da soñjezonoù n'emaint ket war an traoù a sell ouzh Doue, met war an traoù a sell ouzh an dud. ");
INSERT INTO breBRG_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Neuze Jezuz a lavaras d'e ziskibien: Mar fell da unan bennak dont war va lerc'h, ra raio dilez anezhañ e-unan, ra gemero e groaz, ha ra heulio ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Rak piv bennak a fello dezhañ saveteiñ e vuhez, he c'hollo; met piv bennak a gollo e vuhez abalamour din, he saveteo. ");
INSERT INTO breBRG_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Rak petra a dalvfe da un den gounit ar bed holl, ma kollfe e ene? Pe petra a rofe an den e trok ouzh e ene? ");
INSERT INTO breBRG_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Rak Mab an den a dle dont e gloar e Dad gant e aeled; ha neuze e roio da bep hini hervez e oberoù. ");
INSERT INTO breBRG_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Me a lavar deoc'h e gwirionez, ez eus hiniennoù eus a-douez ar re a zo amañ, ha ne varvint ket, ken n'o devo gwelet Mab an den o tont en e rouantelezh. ");
INSERT INTO breBRG_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","C'hwec'h devezh goude, Jezuz a gemeras gantañ Pêr, Jakez, ha Yann e vreur, hag o c'hasas a-du war ur menez uhel; ");
INSERT INTO breBRG_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","hag e voe treuzneuziet dirazo; e zremm a lugernas evel an heol, hag e zilhad a zeuas gwenn evel ar goulou. ");
INSERT INTO breBRG_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ha setu, Moizez hag Elia en em ziskouezas dezho, o komz gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pêr, o kemer ar gomz, a lavaras da Jezuz: Aotrou, mat eo deomp chom amañ; mar fell dit, e raimp amañ teir deltenn, unan evidout, unan evit Moizez, hag unan evit Elia. ");
INSERT INTO breBRG_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Komz a rae c'hoazh, pa zeuas ur goabrenn lugernus d'o golo; ha setu, ur vouezh a zeuas eus ar goabrenn, hag a lavaras: Hemañ eo va Mab karet-mat, ennañ em eus lakaet va holl levenez. Selaouit eñ. ");
INSERT INTO breBRG_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pa glevjont ar vouezh-se, an diskibien a gouezhas war o genou, hag o devoe ur spont bras. ");
INSERT INTO breBRG_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Met Jezuz, o tostaat, a stokas outo hag a lavaras dezho: Savit, n'ho pet ket aon! ");
INSERT INTO breBRG_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sevel a rejont o daoulagad, he ne weljont nemet Jezuz e-unan ganto. ");
INSERT INTO breBRG_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Evel ma tiskennent eus ar menez, Jezuz a roas dezho ar gourc'hemenn-mañ: Na gomzit da zen eus ar welidigezh-mañ, ken na vo adsavet Mab an den a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","An diskibien a reas ar goulenn-mañ outañ: Perak eta e lavar ar skribed eo ret da Elia dont da gentañ? ");
INSERT INTO breBRG_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jezuz a respontas dezho: Gwir eo Elia a dle dont da gentañ hag adlakaat pep tra. ");
INSERT INTO breBRG_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Met me a lavar deoc'h penaos Elia a zo dija deuet, ha n'o deus ket e anavezet, met o deus graet dezhañ kement o deus c'hoantaet. Evel-se ivez, e tle Mab an den gouzañv eus o ferzh. ");
INSERT INTO breBRG_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Neuze an diskibien a gomprenas e komze outo diwar-benn Yann-Vadezour. ");
INSERT INTO breBRG_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","O vezañ deuet etrezek ar bobl, un den a dostaas outañ hag en em daolas d'an daoulin dirazañ, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aotrou! Az pez truez ouzh va mab; loariek eo ha gwall boaniet; alies e kouezh en tan, hag alies en dour. ");
INSERT INTO breBRG_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Degaset em eus anezhañ da'z tiskibien, ha n'o deus ket gallet e yac'haat. ");
INSERT INTO breBRG_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","O rummad diskredik ha fall, a respontas Jezuz, betek pegeit e vin ganeoc'h hag e c'houzañvin ac'hanoc'h? Degasit eñ amañ din. ");
INSERT INTO breBRG_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jezuz a c'hourdrouzas an diaoul, hag ez eas er-maez anezhañ; ar bugel a voe yac'haet war an eur memes. ");
INSERT INTO breBRG_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Neuze an diskibien a dostaas ouzh Jezuz hag a lavaras dezhañ a-du: Perak n'hon eus ket gallet kas kuit an diaoul-se? ");
INSERT INTO breBRG_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Abalamour d'ho tiskredoni eo, a lavaras Jezuz dezho. Me a lavar deoc'h, e gwirionez, mar ho pije feiz kement hag ur c'hreunenn sezo, e lavarfec'h d'ar menez-se: Kae ac'hann aze, hag ez afe; netra ne vefe dibosupl deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Met ar seurt diaoulien-se ne c'hellont mont kuit nemet dre ar bedenn hag ar yun. ");
INSERT INTO breBRG_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","E-pad ma'z aent dre C'halilea, Jezuz a lavaras dezho: Mab an den a zle bezañ lakaet etre daouarn an dud; ");
INSERT INTO breBRG_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","e lakaat a raint d'ar marv, ha d'an trede deiz ec'h adsavo a varv. Bez' e voent gwall c'hlac'haret a-se. ");
INSERT INTO breBRG_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pa erruont e Kafarnaoum, ar re a save an didrakm a dostaas ouzh Pêr hag a lavaras dezhañ: Ho mestr, ha ne bae ket an didrakm? ");
INSERT INTO breBRG_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ya, emezañ. Pa voe aet en ti, Jezuz a ziarbennas anezhañ hag a lavaras: Petra a gav dit Simon? Digant piv e kemer, rouaned an douar, an truajoù pe ar gwirioù? Digant o mibien, pe digant an diavaezidi? ");
INSERT INTO breBRG_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Eñ a lavaras dezhañ: Digant an diavaezidi. Jezuz a lavaras dezhañ: Ar vugale eta, a zo diskarg diouto. ");
INSERT INTO breBRG_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Met, evit na roimp ket ur skouer fall dezho, kae d'ar mor, taol an higenn, tenn ar c'hentañ pesk a zeuio, digor e c'henou, hag e kavi ur stater. Kemer anezhañ ha ro eñ dezho evidon hag evidout. ");
INSERT INTO breBRG_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","D'an eur-se, an diskibien a dostaas ouzh Jezuz, hag a lavaras: Piv eta eo ar brasañ e rouantelezh an neñvoù? ");
INSERT INTO breBRG_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jezuz, o vezañ galvet ur bugel bihan, en lakaas en o c'hreiz, ");
INSERT INTO breBRG_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","hag a lavaras: Me a lavar deoc'h e gwirionez, penaos ma ne zistroit ket, ha ma ne zeuit ket heñvel ouzh bugale vihan, ne deot ket e rouantelezh an neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Piv bennak eta en em izelaio evel ar bugel bihan-se, a vo ar brasañ e rouantelezh an neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ha piv bennak a zegemer em anv ur bugel bihan evel hemañ, a zegemer ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Met piv bennak a roio skouer fall da unan eus ar re vihan-se a gred ennon, ez eo gwelloc'h dezhañ e vefe staget ouzh e c'houzoug ur maen milin, hag e vefe taolet e donder ar mor. ");
INSERT INTO breBRG_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gwalleur d'ar bed abalamour d'ar skouerioù fall! Rak ret eo e teufe skouerioù fall, met gwalleur d'an den ma teu drezañ ar skouer fall! ");
INSERT INTO breBRG_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ma ra da zorn pe da droad lakaat ac'hanout da gouezhañ, troc'h anezhañ, ha taol anezhañ pell diouzhit; rak gwelloc'h eo dit mont er vuhez moñs pe gamm, eget kaout daou dorn pe daou droad ha bezañ taolet en tan peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ha ma ra da lagad lakaat ac'hanout da gouezhañ, diframm anezhañ, ha taol anezhañ pell diouzhit; gwelloc'h eo dit mont er vuhez born, eget kaout da zaoulagad ha bezañ taolet e tan ar gehenn. ");
INSERT INTO breBRG_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Diwallit da zisprizañ nikun eus ar vugaligoù-mañ, rak me a lavar deoc'h penaos o aeled en neñvoù a wel dalc'hmat dremm va Zad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Rak Mab an den a zo deuet da saveteiñ ar re a oa kollet. ");
INSERT INTO breBRG_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Petra a soñj deoc'h? Mar en deus un den kant dañvad, hag e teufe unan anezho da vezañ dianket, ha ne lez ket an naontek ha pevar-ugent all war ar menezioù, evit mont da glask an hini a zo dianket? ");
INSERT INTO breBRG_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ha mar kav anezhañ, me a lavar deoc'h e gwirionez, bez' en deus muioc'h a levenez diwar-benn hemañ eget diwar-benn an naontek ha pevar-ugent ha n'int ket bet dianket. ");
INSERT INTO breBRG_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Evel-se, n'eo ket bolontez ho Tad a zo en neñvoù, en em gollfe unan eus ar re vihan-mañ. ");
INSERT INTO breBRG_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mar en deus pec'het da vreur a-enep dit, kae ha tamall anezhañ etre te hag eñ e-unan; mar selaou ac'hanout, ez po gounezet da vreur. ");
INSERT INTO breBRG_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma ne selaou ket ac'hanout, kemer ganit un den pe zaou, evit ma vo an holl dra reizhet war gomz daou pe dri dest. ");
INSERT INTO breBRG_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma ne selaou ket anezho, lavar d'an Iliz, ha ma ne selaou ket kennebeut an Iliz, ra vo evidout evel ur pagan hag ur publikan. ");
INSERT INTO breBRG_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Me a lavar deoc'h e gwirionez, ar pezh a ereot war an douar a vo ereet en neñv, hag ar pezh a ziereot war an douar a vo diereet en neñv. ");
INSERT INTO breBRG_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Me a lavar c'hoazh deoc'h: mar en em laka daou ac'hanoc'h a-unvan war an douar evit goulenn un dra bennak, e vo roet dezho gant va Zad a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Rak e-lec'h ma ez eus daou pe dri dastumet em anv, emaon eno en o c'hreiz. ");
INSERT INTO breBRG_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Neuze Pêr a dostaas outañ hag a lavaras: Aotrou, pet gwech e pardonin da'm breur pa bec'ho em enep? Bez' e vo betek seizh gwech? ");
INSERT INTO breBRG_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jezuz a lavaras dezhañ: Ne lavaran ket dit betek seizh gwech, met betek seizh gwech dek ha tri-ugent. ");
INSERT INTO breBRG_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dre-se, rouantelezh an neñvoù a zo heñvel ouzh ur roue a fellas dezhañ ober rentañ kont d'e servijerien. ");
INSERT INTO breBRG_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","P'en em lakaas da gontañ, e voe degaset dezhañ unan a dlee dek mil talant. ");
INSERT INTO breBRG_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dre ma n'en devoa ket peadra da baeañ, e vestr a roas urzh d'e werzhañ, eñ, e wreg, e vugale, ha kement en devoa, evit paeañ e zle. ");
INSERT INTO breBRG_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ar servijer, oc'h en em strinkañ d'e dreid, a bede anezhañ, o lavarout: Aotrou, ro amzer din hag e paein dit va holl zle. ");
INSERT INTO breBRG_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","O kaout truez outañ, mestr ar servijer-se, en lezas da vont, hag a bardonas dezhañ e zle. ");
INSERT INTO breBRG_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Goude ma voe aet kuit, ar servijer-mañ a gavas unan eus e genvreudeur a dlee dezhañ kant diner; hag, o kregiñ ennañ, e waske e c'houzoug en ur lavarout: pae ar pezh a dleez din. ");
INSERT INTO breBRG_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","E genvreur, oc'h en em deurel d'e dreid, a bede anezhañ en ur lavarout: Ro amzer din hag e paein dit. ");
INSERT INTO breBRG_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Met hemañ ne fellas ket dezhañ; mont a reas d'e deurel er prizon, betek m'en devoa paeet ar pezh a dlee. ");
INSERT INTO breBRG_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","E genvreudeur, o welout ar pezh en devoa graet, a voe glac'haret bras; mont a rejont da gontañ d'e aotrou kement a oa c'hoarvezet. ");
INSERT INTO breBRG_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Neuze ar mestr a reas gervel ar servijer-se hag a lavaras dezhañ: Servijer drouk, pardonet em boa dit da holl zle dre ma ez poa va fedet; ");
INSERT INTO breBRG_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ha ne dlees ket kaout truez ivez ouzh da genvreur, evel ma em boa bet truez ouzhit? ");
INSERT INTO breBRG_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hag e vestr, o kaout droug ennañ, en roas d'ar vourevien, betek m'en devoa paeet kement a dlee. ");
INSERT INTO breBRG_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Evel-se e raio deoc'h va Zad a zo en neñvoù, ma ne bardon ket pep hini ac'hanoc'h, a-greiz e galon, d'e vreur. ");
INSERT INTO breBRG_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","P'en devoe Jezuz peurlavaret ar c'homzoù-se, ez eas kuit eus Galilea, hag e teuas e kostezioù Judea, en tu all d'ar Jordan. ");
INSERT INTO breBRG_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ur bobl vras a heulias anezhañ, hag eno e yac'haas ar re glañv. ");
INSERT INTO breBRG_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ar farizianed a zeuas hag a lavarjont dezhañ evit e demptañ: Hag e c'hell un den kas e wreg kuit, n'eus forzh evit peseurt abeg? ");
INSERT INTO breBRG_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Eñ a respontas: Ha n'hoc'h eus ket lennet penaos ar C'houer, er penn-kentañ, a reas gwaz ha plac'h, ");
INSERT INTO breBRG_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ha penaos en deus lavaret: Setu perak ar gwaz a guitaio e dad hag e vamm, hag en em unano d'e wreg, hag e vint ur c'hig hepken? ");
INSERT INTO breBRG_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Evel-se, ne dint mui daou, met ur c'hig hepken. Arabat eo d'an den disrannañ ar pezh a zo bet unanet gant Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Int a lavaras dezhañ: Perak eta en deus Moizez lezet reiñ d'ar wreg ur skrid a dorr-dimeziñ hag he c'has kuit? ");
INSERT INTO breBRG_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jezuz a respontas dezho: Abalamour da galeter ho kalon eo, en deus Moizez roet galloud deoc'h da gas kuit ho kwragez; er penn-kentañ, ne oa ket evel-se. ");
INSERT INTO breBRG_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Met me a lavar deoc'h, piv bennak a gas kuit e wreg, nemet evit difealded, hag a zimez da unan all, a ra avoultriezh, ha piv bennak a zimez d'ur wreg a zo bet kaset kuit, a ra avoultriezh. ");
INSERT INTO breBRG_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E ziskibien a lavaras dezhañ: Mar deo evel-se doare an den gant e wreg, n'eo ket talvoudus dimeziñ. ");
INSERT INTO breBRG_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Eñ a respontas dezho: An holl ne gomprenont ket ar gomz-se, met hepken ar re a zo bet roet dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Rak bez' ez eus eunuked a zo bet ganet evel-se a gof o mamm, reoù all a zo bet graet eunuked gant an dud, hag ez eus reoù all a zo en em rentet oc'h-unan eunuked, abalamour da rouantelezh an neñvoù. Ra gompreno kement-mañ, an neb a c'hell kompren. ");
INSERT INTO breBRG_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Neuze e voe degaset dezhañ bugale vihan, evit ma lakaje e zaouarn warno, ha ma pedje evito. Met an diskibien o fellae. ");
INSERT INTO breBRG_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ha Jezuz a lavaras: Lezit ar vugale vihan, ha na zifennit ket outo dont davedon; rak rouantelezh an neñvoù a zo d'an nep a zo heñvel outo. ");
INSERT INTO breBRG_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lakaat a reas e zaouarn warno, hag ez eas kuit ac'hano. ");
INSERT INTO breBRG_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ha setu, un den a dostaas hag a lavaras da Jezuz: Mestr, peseurt mad a dlean d'ober evit kaout ar vuhez peurbadus? ");
INSERT INTO breBRG_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Eñ a respontas dezhañ: Perak e c'houlennez ouzhin diwar-benn ar mad? Unan hepken a zo mat, Doue. Mar fell dit mont er vuhez, mir ar gourc'hemennoù. Pere? emezañ. ");
INSERT INTO breBRG_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jezuz a respontas: Ne lazhi ket; Ne ri ket avoultriezh; Ne laeri ket; Ne lavari ket a falstesteni; ");
INSERT INTO breBRG_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Enor da dad ha da vamm; ha: Karout a ri da nesañ eveldout da-unan. ");
INSERT INTO breBRG_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","An den yaouank a lavaras dezhañ: Miret em eus an holl draoù-se adalek va yaouankiz; petra a vank din c'hoazh? ");
INSERT INTO breBRG_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jezuz a lavaras dezhañ: Mar fell dit bezañ parfet, kae, gwerzh kement ac'h eus, en ro d'ar beorien, hag ez po un teñzor en neñv; goude-se deus hag heul ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Goude bezañ klevet ar c'homzoù-se, an den yaouank a yeas gwall-drist, rak madoù bras en devoa. ");
INSERT INTO breBRG_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jezuz a lavaras d'e ziskibien: Me a lavar deoc'h e gwirionez, diaes eo d'un den pinvidik mont e-barzh rouantelezh an neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","En lavarout a ran deoc'h c'hoazh, aesoc'h eo d'ur c'hañval tremen dre graoenn un nadoz eget d'un den pinvidik mont e-barzh rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","An diskibien o vezañ klevet-se, a voe souezhet bras, hag a lavaras: Ha piv eta a c'hell bezañ salvet? ");
INSERT INTO breBRG_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jezuz o sellout outo, a lavaras: Dibosupl eo-se d'an dud, met pep tra a zo posupl da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pêr, o kemer ar gomz, a lavaras: Setu, ni hon eus dilezet pep tra, hag hon eus da heuliet; petra a vo evidomp? ");
INSERT INTO breBRG_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jezuz a respontas dezho: Me a lavar deoc'h e gwirionez penaos, c'hwi hag hoc'h eus va heuliet, en eil c'hinivelezh, pa vo Mab an den azezet war dron e c'hloar, e viot ivez azezet war daouzek tron, hag e varnot daouzek meuriad Israel. ");
INSERT INTO breBRG_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ha piv bennak en devo kuitaet abalamour da'm anv, breudeur, pe c'hoarezed, pe dad, pe vamm, pe wreg, pe vugale, pe zouaroù, pe diez, a resevo kant kement all, hag a herito ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Met kalz a zo ar re gentañ a vo ar re ziwezhañ, ha kalz a zo ar re ziwezhañ a vo ar re gentañ. ");
INSERT INTO breBRG_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Rak rouantelezh an neñvoù a zo heñvel ouzh un den penn-tiegezh a yeas er-maez beure mat, da c'hoprañ labourerien evit e winieg. ");
INSERT INTO breBRG_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ober a reas marc'had ganto eus un diner dre zevezh, hag o c'hasas d'e winieg. ");
INSERT INTO breBRG_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mont a reas er-maez war-dro an deirvet eur, hag e welas re all a oa war ar blasenn, hep ober netra. ");
INSERT INTO breBRG_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lavarout a reas dezho: It ivez da'm gwinieg, hag e roin deoc'h ar pezh a zo reizh. Hag ez ejont. ");
INSERT INTO breBRG_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mont a reas adarre er-maez war-dro ar c'hwec'hvet ha war-dro an navet eur, hag e reas ar memes tra. ");
INSERT INTO breBRG_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","O vezañ aet er-maez war-dro an unnekvet eur, e kavas re all a oa dilabour war ar blasenn, hag e lavaras dezho: Perak en em zalc'hit amañ a-hed an deiz hep ober netra? ");
INSERT INTO breBRG_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Respont a rejont dezhañ: Dre n'en deus den ebet gopret ac'hanomp. It ivez da'm gwinieg, emezañ, hag e roin deoc'h ar pezh a zo reizh. ");
INSERT INTO breBRG_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pa voe deuet an abardaez, mestr ar winieg a lavaras d'e verour: Galv al labourerien ha ro dezho o gopr, en ur vont eus ar re ziwezhañ d'ar re gentañ. ");
INSERT INTO breBRG_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Re an unnekvet eur, o vezañ deuet, o devoe pep a ziner. ");
INSERT INTO breBRG_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ar re gentañ a soñje dezho o divije ouzhpenn; met pep a ziner a resevas ivez ar re-mañ. ");
INSERT INTO breBRG_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ouzh e gemer, e c'hrozmolent a-enep ar penn-tiegezh, ");
INSERT INTO breBRG_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","o lavarout: Ar re ziwezhañ-se n'o deus labouret nemet un eurvezh, hag ec'h eus o lakaet keit ha ni hon eus douget pouez an deiz hag an tommder. ");
INSERT INTO breBRG_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Eñ a respontas da unan anezho: Va mignon, ne ran gaou ebet ouzhit; ne'c'h eus ket graet marc'had ganin evit un diner? ");
INSERT INTO breBRG_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kemer eta ar pezh a zo dit, ha kae kuit; c'hoantaat a ran reiñ d'an hini diwezhañ-mañ kement ha dit. ");
INSERT INTO breBRG_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ha ne c'hellan ket ober ar pezh a fell din eus va madoù? Pe daoust ha da lagad a zo fall abalamour ma'z on mat? ");
INSERT INTO breBRG_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Evel-se, ar re ziwezhañ a vo ar re gentañ, hag ar re gentañ a vo ar re ziwezhañ. Rak kalz a zo galvet, met nebeud a zo dibabet. ");
INSERT INTO breBRG_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","E-pad ma pigne Jezuz da Jeruzalem, e kemeras a-du an daouzek diskibl, hag e lavaras dezho en hent: ");
INSERT INTO breBRG_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Setu, e pignomp da Jeruzalem, ha Mab an den a vo lakaet etre daouarn ar veleien vras ha re ar skribed, hag e kondaonint anezhañ d'ar marv, ");
INSERT INTO breBRG_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","hag e lakaint anezhañ etre daouarn ar baganed, evit ober goap anezhañ, evit e skourjezañ, hag e groazstagañ, met ec'h adsavo a varv d'an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Neuze mamm mibien Zebedea a dostaas ouzh Jezuz gant he mibien, hag en em stouas evit ober ur goulenn digantañ. ");
INSERT INTO breBRG_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eñ a lavaras dezhi: Petra a fell dit? Gra, emezi, ma vo va daou vab a zo amañ, azezet ez rouantelezh unan a-zehou hag egile a-gleiz dit. ");
INSERT INTO breBRG_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jezuz a respontas: N'ouzoc'h ket ar pezh a c'houlennit. Ha gallout e c'hellit evañ an hanaf a dlean evañ ha bezañ badezet eus ar vadeziant ma tlean bezañ badezet ganti? Int a lavaras dezhañ: Ni a c'hell. ");
INSERT INTO breBRG_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lavarout a reas dezho: Gwir eo ec'h evot va hanaf hag e viot badezet eus ar vadeziant am eus da vezañ badezet ganti; met bezañ azezet a-zehou pe a-gleiz din, n'eo ket din da reiñ; roet e vo d'ar re ma'z eo bet kempennet evito gant va Zad. ");
INSERT INTO breBRG_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","An dek all o vezañ klevet kement-se, a yeas droug enno a-enep an daou vreur. ");
INSERT INTO breBRG_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jezuz o galvas hag a lavaras: Gouzout a rit penaos pennoù ar pobloù a vestroni anezho, ha penaos ar re vras a ziskouez o galloud warno. ");
INSERT INTO breBRG_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ne vo ket evel-se en ho touez; met piv bennak a fello dezhañ bezañ bras en ho touez, a vo ho servijer. ");
INSERT INTO breBRG_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ha piv bennak a fello dezhañ bezañ ar c'hentañ en ho touez, a vo ho mevel. ");
INSERT INTO breBRG_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Evel-se eo deuet Mab an den, neket evit bezañ servijet, met evit servijañ hag evit reiñ e vuhez e daspren evit kalz. ");
INSERT INTO breBRG_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pa'z ejont kuit eus Jeriko, ez eas kalz a dud war e lerc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ha setu, daou zen dall, azezet war gostez an hent, a glevas e oa Jezuz o tremen, hag e krijont: Aotrou, Mab David, az pez truez ouzhimp! ");
INSERT INTO breBRG_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ar bobl o gourdrouze, evit ober dezho tevel; met int a grie kreñvoc'h: Mab David, az pez truez ouzhimp! ");
INSERT INTO breBRG_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jezuz, o chom a sav, o galvas, hag a lavaras: Petra a fell deoc'h e rafen evidoc'h? ");
INSERT INTO breBRG_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hag e lavarjont dezhañ: Aotrou, ma tigoro hon daoulagad. ");
INSERT INTO breBRG_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","O kaout truez outo, Jezuz a stokas ouzh o daoulagad, ha raktal e kavjont ar gweled, hag e heuilhjont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Evel ma tostaent ouzh Jeruzalem, ha ma voent e Betfage, tost da Venez an Olived, Jezuz a gasas daou eus e ziskibien, ");
INSERT INTO breBRG_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","o lavarout dezho: It d'ar vourc'h a zo dirazoc'h; kavout a reot kerkent un azenez stag hag un azen yaouank ganti; distagit int, ha degasit int din. ");
INSERT INTO breBRG_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mar lavar unan bennak un dra bennak deoc'h, respontit: An Aotrou en deus ezhomm anezho. Ha raktal o lezo da vont. ");
INSERT INTO breBRG_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kement-se a c'hoarvezas evit ma vije peurc'hraet ar pezh a oa bet lavaret gant ar profed: ");
INSERT INTO breBRG_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Lavarit da verc'h Sion: Setu, da roue a zeu da'z kavout, leun a zouster, ha pignet war un azen, war un azenig, ebeul un azenez. ");
INSERT INTO breBRG_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","An diskibien a yeas hag a reas ar pezh en devoa Jezuz gourc'hemennet dezho. ");
INSERT INTO breBRG_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Degas a rejont an azenez hag an azenig da Jezuz, e lakajont o dilhad warno, hag e rejont dezhañ azezañ warno. ");
INSERT INTO breBRG_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","An darn vuiañ eus an dud a astennas o dilhad war an hent, ha re all a droc'he brankoù gwez, hag a c'holoas ganto an hent. ");
INSERT INTO breBRG_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ar re a valee a-raok, hag ar re a heulie Jezuz, a grie: Hozanna da Vab David! Benniget ra vo an hini a zeu en anv an Aotrou! Hozanna el lec'hioù uhel meurbet! ");
INSERT INTO breBRG_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pa voe aet e Jeruzalem, holl gêr a voe mantret, hag e lavarent: Piv eo hemañ? ");
INSERT INTO breBRG_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ar bobl a respontas: Jezuz eo, ar profed eus Nazared e Galilea. ");
INSERT INTO breBRG_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jezuz, o vezañ aet e templ Doue, a gasas kuit an holl re a werzhe hag a brene en templ; hag e tiskaras taolioù an drokerien-arc'hant, ha kadorioù ar varc'hadourien goulmed. ");
INSERT INTO breBRG_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Lavarout a reas dezho: Skrivet eo: Va zi a vo galvet un ti a bedenn. Met c'hwi hoc'h eus graet anezhañ ur c'havarn laeron. ");
INSERT INTO breBRG_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tud dall ha tud kamm a dostaas outañ en templ, hag o yac'haas. ");
INSERT INTO breBRG_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Met ar veleien vras hag ar skribed, droug enno o welout ar burzhudoù a rae ha bugale a grie en templ: Hozanna da Vab David, ");
INSERT INTO breBRG_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","a lavaras dezhañ: Ha klevout a rez ar pezh a lavaront? Ya, a respontas Jezuz dezho, ha n'hoc'h eus biskoazh lennet ar c'homzoù-mañ: Tennet ec'h eus meuleudi eus genou ar vugale hag ar re a zo ouzh ar vronn? ");
INSERT INTO breBRG_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hag, o vezañ o lezet, ez eas kuit eus kêr, evit mont da Vetania, e-lec'h ma tremenas an noz. ");
INSERT INTO breBRG_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Da vintin, evel ma tistroe e kêr, en devoe naon. ");
INSERT INTO breBRG_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O welout ur wezenn-fiez war an hent, e tostaas outi; met ne gavas enni nemet delioù, hag e lavaras dezhi: Ra ne zeuio biken frouezh ac'hanout! Raktal, ar wezenn-fiez a sec'has. ");
INSERT INTO breBRG_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","An diskibien a welas kement-se, hag a voe souezhet, o lavarout: Penaos eo deuet ar wezenn-fiez-se da vezañ sec'h raktal? ");
INSERT INTO breBRG_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jezuz a respontas dezho: Me a lavar deoc'h e gwirionez, mar ho pije feiz ha ma ne ziskredjec'h ket, n'eo ket hepken ar pezh a zo bet graet d'ar wezenn-fiez e rajec'h, met pa lavarjec'h d'ar menez-se: Sav alese hag en em daol er mor, kement-se en em raje. ");
INSERT INTO breBRG_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kement a c'houlennot gant feiz dre ar bedenn, a vo roet deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jezuz a yeas en templ, hag e-pad ma kelenne, ar veleien vras hag henaourien ar bobl a zeuas da lavarout dezhañ: Dre beseurt galloud e rez an traoù-se, ha piv en deus roet dit ar galloud-se? ");
INSERT INTO breBRG_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jezuz a respontas dezho: Me a c'houlenno ivez un dra ouzhoc'h, ha, mar respontit, e lavarin deoc'h dre beseurt galloud e ran an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Badeziant Yann, a-belec'h e teue? Eus an neñv, pe eus an dud? Int a soñje enno oc'h-unan, o lavarout: Mar lavaromp: Eus an neñv, e lavaro: Perak eta n'hoc'h eus ket kredet ennañ? ");
INSERT INTO breBRG_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ha mar lavaromp: Eus an dud, e tleomp doujañ ar bobl, rak an holl a gred e oa Yann ur profed. ");
INSERT INTO breBRG_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Neuze e respontjont da Jezuz: N'ouzomp ket. Hag eñ a lavaras dezho d'e dro: Ha me kennebeut, ne lavarin ket deoc'h dre beseurt galloud e ran an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Petra a soñjit? Un den en devoa daou vab; o vont etrezek an hini kentañ, e lavaras dezhañ: Va mab, kae hiziv da labourat em gwinieg. ");
INSERT INTO breBRG_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eñ a respontas: Ne din ket. Goude-se, e teuas keuz dezhañ, hag ez eas. ");
INSERT INTO breBRG_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dont a reas ivez etrezek egile, hag e lavaras dezhañ ar memes tra. Hag hemañ a respontas: Mont a ran, aotrou; met ne deas ket. ");
INSERT INTO breBRG_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pehini anezho o-daou en deus graet bolontez e dad? Int a lavaras dezhañ: An hini kentañ. Jezuz a lavaras dezho: Me a lavar deoc'h e gwirionez, penaos ar bublikaned hag ar merc'hed a vuhez fall ho tiaraogo e rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Rak Yann a zo deuet d'ho kavout dre hent ar reizhder, ha n'hoc'h eus ket kredet ennañ. Met ar bublikaned hag ar merc'hed a vuhez fall o deus kredet ennañ. Ha c'hwi, goude bezañ gwelet kement-se, n'hoc'h eus ket bet keuz evit krediñ ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Selaouit ur barabolenn all. Bez' e oa un den penn-tiegezh hag a blantas ur winieg, a reas ur c'harzh en-dro dezhi, a gleuzias enni ur wask, hag a savas enni un tour; neuze e feurmas anezhi da winierien, hag ez eas en ur vro all. ");
INSERT INTO breBRG_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Da amzer ar frouezh e kasas e servijerien etrezek ar winierien, evit resev frouezh e winieg. ");
INSERT INTO breBRG_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Met ar winierien, o vezañ kroget er servijerien, a gannas unan, a lazhas egile, hag a veinatas an trede. ");
INSERT INTO breBRG_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kas a reas adarre servijerien all, kalz muioc'h eget ar re gentañ, hag e rejont dezho ar memes tra. ");
INSERT INTO breBRG_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Da ziwezhañ, e kasas dezho e vab, o lavarout: Doujañ a raint va mab. ");
INSERT INTO breBRG_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Met ar winierien, pa weljont ar mab, a lavaras etrezo: Setu an heritour; deuit, lazhomp eñ, ha kemeromp e heritaj. ");
INSERT INTO breBRG_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hag o vezañ kroget ennañ, e taoljont anezhañ er-maez eus ar winieg, hag en lazhjont. ");
INSERT INTO breBRG_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Bremañ, pa zeuio mestr ar winieg, petra a raio d'ar winierien-se? ");
INSERT INTO breBRG_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Respont a rejont dezhañ: Distrujañ a raio en un doare reuzeudik an dud drouk-se, hag e feurmo e winieg da winierien all a roio dezhañ he frouezh en o amzer. ");
INSERT INTO breBRG_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jezuz a lavaras dezho: Ha n'hoc'h eus biskoazh lennet er Skriturioù: Ar maen taolet kuit gant ar re a vañsone, a zo deuet da vezañ penn ar c'horn. Kement-se a zo bet graet gant an Aotrou, hag un dra marzhus eo d'hon daoulagad? ");
INSERT INTO breBRG_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Setu perak e lavaran deoc'h, penaos rouantelezh Doue a vo lamet diganeoc'h, ha roet d'ur bobl a roio ar frouezh anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","An hini a gouezho war ar maen-se a vo brevet, ha flastret e vo an hini ma kouezho warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Goude bezañ klevet e barabolennoù, ar veleien vras hag ar farizianed a anavezas mat e oa anezho eo e komze Jezuz, ");
INSERT INTO breBRG_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","hag e klaskjont kregiñ ennañ, met aon o devoa rak ar bobl a gemere anezhañ evit ur profed. ");
INSERT INTO breBRG_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jezuz o komz, a lavaras a-nevez dezho dre barabolennoù: ");
INSERT INTO breBRG_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Rouantelezh an neñvoù a zo heñvel ouzh ur roue hag a reas ur goan-eured evit e vab. ");
INSERT INTO breBRG_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kas a reas e vevelien da c'hervel ar re a oa bet pedet d'an eured; met ne felle ket dezho dont. ");
INSERT INTO breBRG_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kas a reas adarre mevelien all, en ur lavarout: Lavarit d'ar re a zo bet pedet: Setu, va lein am eus fichet, lazhet em eus va ejened ha va loened lard, pep tra a zo prest, deuit d'an eured. ");
INSERT INTO breBRG_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Met ne rejont van ebet ouzh kement-se, hag ez ejont, unan d'e bark, unan all d'e genwerzh, ");
INSERT INTO breBRG_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ha re all a grogas en e vevelien, o gwallgasas hag o lazhas. ");
INSERT INTO breBRG_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ar roue a yeas droug ennañ, hag o vezañ kaset e soudarded, e lakaas da vervel al lazherien-se, hag e tevas o c'hêr. ");
INSERT INTO breBRG_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Neuze e lavaras d'e vevelien: An eured a zo prest, met ar re a oa bet pedet dezhi ne oant ket din anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","It eta er c'hroazhentoù, ha galvit d'an eured an holl re a gavot. ");
INSERT INTO breBRG_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","E vevelien, o vezañ aet dre an hentoù, a zastumas kement a gavjont, mat ha fall, ha sal an eured a voe leuniet gant tud ouzh taol. ");
INSERT INTO breBRG_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ar roue, o vezañ deuet evit gwelout ar re a oa ouzh taol, a welas eno un den n'en devoa ket gwisket un dilhad eured. ");
INSERT INTO breBRG_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lavarout a reas dezhañ: Va mignon, penaos out deuet amañ hep kaout un dilhad eured? Eñ a chomas mut. ");
INSERT INTO breBRG_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Neuze ar roue a lavaras d'ar vevelien: Ereit e zaouarn hag e dreid, ha taolit eñ en deñvalijenn a-ziavaez, e-lec'h ma vo goueladegoù ha grigoñsadegoù-dent. ");
INSERT INTO breBRG_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Rak kalz a zo galvet, met nebeut a zo dibabet. ");
INSERT INTO breBRG_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Neuze ar farizianed a yeas d'en em guzuliañ war an doare d'e dapout en e gomzoù. ");
INSERT INTO breBRG_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kas a rejont d'e gavout o diskibien gant an herodianed, da lavarout dezhañ: Mestr, gouzout a reomp penaos out gwirion ha penaos e kelennez hent Doue hervez ar wirionez, hep ober van eus den ebet, rak ne sellez ket ouzh diavaez an dud. ");
INSERT INTO breBRG_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lavar deomp eta petra a soñjez: Ha dleet eo paeañ ar gwir da Gezar, pe n'eo ket? ");
INSERT INTO breBRG_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Met Jezuz, oc'h anavezout o fallentez, a lavaras dezho: Perak e temptit ac'hanon, pilpouzed? ");
INSERT INTO breBRG_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Diskouezit din ar moneiz ma vez paeet ar gwir gantañ. Hag e rojont dezhañ un diner. ");
INSERT INTO breBRG_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Goulenn a reas outo: Eus piv eo ar skeud hag ar skrid-mañ? ");
INSERT INTO breBRG_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Int a lavaras dezhañ: Eus Kezar. Neuze e lavaras dezho: Roit eta da Gezar ar pezh a zo da Gezar, ha da Zoue ar pezh a zo da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Souezhet eus ar pezh a glevjont, e lezjont anezhañ hag ez ejont kuit. ");
INSERT INTO breBRG_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","An hevelep devezh, ar sadukeiz, hag a lavar n'eus ket a adsavidigezh a varv, a zeuas da gavout Jezuz, hag a reas outañ ar goulenn-mañ: ");
INSERT INTO breBRG_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mestr, Moizez en deus lavaret: Mar marv unan bennak hep bugale, e vreur a zimezo d'e intañvez, evit sevel lignez d'e vreur. ");
INSERT INTO breBRG_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bez' e oa en hon touez seizh breur. An hini kentañ a zimezas hag a varvas; hag evel n'en devoa ket a vugale, e lezas e wreg d'e vreur. ");
INSERT INTO breBRG_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","En hevelep doare e c'hoarvezas gant an eil, an trede, betek ar seizhvet. ");
INSERT INTO breBRG_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ha d'an diwezhañ-holl, ar wreg a varvas ivez. ");
INSERT INTO breBRG_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Da behini ar seizh-se e vo gwreg, en adsavidigezh a varv? Rak eo bet dezho holl. ");
INSERT INTO breBRG_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jezuz, a respontas dezho: En dallentez oc'h, dre n'anavezit ket ar Skriturioù, na galloud Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Rak en adsavidigezh a varv, ar wazed n'o devo ket a wragez, nag ar gwragez a ezhec'h, met bez' e vint evel aeled Doue en neñv. ");
INSERT INTO breBRG_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Met diwar-benn an adsavidigezh a varv, ha n'hoc'h eus ket lennet ar pezh en deus Doue lavaret deoc'h: ");
INSERT INTO breBRG_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Me eo Doue Abraham, Doue Izaak, ha Doue Jakob? Doue n'eo ket Doue ar re varv, met Doue ar re vev. ");
INSERT INTO breBRG_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ar bobl a selaoue, hag a voe souezhet gant kelennadurezh Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ar farizianed, o vezañ klevet penaos en devoa lakaet da devel ar sadukeiz, en em zastumas, ");
INSERT INTO breBRG_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","hag unan anezho, doktor eus al lezenn, a reas ar goulenn-mañ outañ, evit e demptañ: ");
INSERT INTO breBRG_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Mestr, pehini eo ar brasañ gourc'hemenn eus al lezenn? ");
INSERT INTO breBRG_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jezuz a respontas dezhañ: Karout a ri an Aotrou da Zoue, eus da holl galon, eus da holl ene, hag eus da holl soñj. ");
INSERT INTO breBRG_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hennezh eo ar c'hentañ hag ar brasañ eus ar gourc'hemennoù. ");
INSERT INTO breBRG_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ha setu an eil a zo heñvel outañ: Karout a ri da nesañ eveldout da-unan. ");
INSERT INTO breBRG_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Eus an daou c'hourc'hemenn-se, e talc'h an holl lezenn hag ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Evel ma oa ar farizianed en em zastumet, Jezuz a reas ur goulenn outo, ");
INSERT INTO breBRG_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","o lavarout: Petra a soñjit eus ar C'hrist? Da biv eo mab? Int a lavaras dezhañ: Da Zavid. ");
INSERT INTO breBRG_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jezuz a lavaras dezho: Penaos eta e c'halv David anezhañ, dre ar Spered, e Aotrou, pa lavar: ");
INSERT INTO breBRG_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","An Aotrou en deus lavaret da'm Aotrou: Azez a-zehou din, betek ma em bo graet eus da enebourien ur skabell dindan da dreid. ");
INSERT INTO breBRG_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mar galv eta David e-unan anezhañ Aotrou, penaos eo-eñ e vab? ");
INSERT INTO breBRG_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ha den ne c'hellas respont ur ger dezhañ. Adalek an deiz-se, hini ne gredas mui ober goulenn ebet outañ. ");
INSERT INTO breBRG_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Neuze Jezuz, o komz d'ar bobl ha d'e ziskibien, a lavaras: ");
INSERT INTO breBRG_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ar skribed hag ar farizianed a zo azezet war gador Moizez. ");
INSERT INTO breBRG_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Grit eta ha mirit kement a lavaront deoc'h; met na rit ket hervez o oberoù. Rak e lavaront, met ne reont ket. ");
INSERT INTO breBRG_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eren a reont bec'hioù pounner ha diaes da zougen, ha o lakaont war divskoaz an dud, met ne fell ket dezho stekiñ outo gant o biz. ");
INSERT INTO breBRG_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","O holl oberoù a reont evit bezañ gwelet gant an dud. Evel-se eo, o deus fulakterioù ledan ha pempilhoù hir ouzh o dilhad; ");
INSERT INTO breBRG_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","karout a reont ar plasoù kentañ er festoù, hag ar c'hadorioù kentañ er sinagogennoù; ");
INSERT INTO breBRG_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","karout a reont bezañ saludet er marc'hallac'hoù, ha bezañ galvet gant an dud: Mestr, Mestr. ");
INSERT INTO breBRG_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Met c'hwi, na rit ket ho kervel mestr, rak unan hepken eo ho Mestr, ar C'hrist, ha c'hwi holl a zo breudeur. ");
INSERT INTO breBRG_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na c'halvit den war an douar ho tad, rak unan hepken eo ho Tad, an hini a zo en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na rit ket ho kervel renerien, rak unan hepken eo ho Rener, ar C'hrist ");
INSERT INTO breBRG_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","An hini brasañ en ho touez a vo ho servijer. ");
INSERT INTO breBRG_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Rak piv bennak en em uhela a vo izelaet, ha piv bennak en em izela a vo uhelaet. ");
INSERT INTO breBRG_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma serrit rouantelezh an neñvoù ouzh an dud, n'oc'h ket hoc'h-unan aet e-barzh, hag hoc'h eus c'hoazh harzet da vont e-barzh ar re a garje bezañ aet. ");
INSERT INTO breBRG_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma dismantrit tiez an intañvezed, hag e rit evit ar gweled pedennoù hir; abalamour da-se, e viot barnet garvoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Rak redek a rit dre ar mor hag an douar evit ober ur prozelit, ha, pa hoc'h eus e c'hounezet, e rit anezhañ ur mab-ifern div wech gwashoc'h egedoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Gwalleur deoc'h, renerien dall! Lavarout a rit: Mar tou unan bennak dre an templ, se n'eo netra; met mar tou unan bennak dre aour an templ, hennezh a dle derc'hel e gomz. ");
INSERT INTO breBRG_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tud diskiant ha dall! Pehini eo ar brasañ, an aour, pe an templ a santela an aour-se? ");
INSERT INTO breBRG_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lavarout a rit c'hoazh: Mar tou unan bennak dre an aoter, se n'eo netra; met mar tou unan bennak dre ar prof a zo war an aoter, hennezh a dle derc'hel e gomz. ");
INSERT INTO breBRG_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tud dall! Pehini eo ar brasañ, ar prof, pe an aoter a santela ar prof-se? ");
INSERT INTO breBRG_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","An neb a dou dre an aoter, a dou dre an aoter ha dre gement a zo warni; ");
INSERT INTO breBRG_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","an neb a dou dre an templ, a dou dre an templ ha dre an Hini a chom ennañ; ");
INSERT INTO breBRG_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","hag an neb a dou dre an neñv, a dou dre dron Doue ha dre an Hini a zo azezet warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma paeit an deog war ar vent, war an aned, ha war ar c'houmin, hag e lezit a-gostez ar pezh a zo ar muiañ talvoudek el lezenn, ar reizhder, an drugarez hag al lealded. Ar re-se a oa an traoù a dleec'h d'ober, hep koulskoude dilezel ar re all. ");
INSERT INTO breBRG_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Renerien dall! Silañ a rit ar fubuenn, hag e lonkit ar c'hañval. ");
INSERT INTO breBRG_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma naetait diavaez an hanaf hag ar plad, met en diabarzh oc'h leun a laeroñsi hag a zireizhder. ");
INSERT INTO breBRG_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizian dall! Naeta da gentañ an diabarzh eus an hanaf hag eus ar plad, evit ma teuio ivez an diavaez da vezañ naet. ");
INSERT INTO breBRG_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma'z oc'h heñvel ouzh bezioù gwennet, en em ziskouez kaer en diavaez, hag a zo leun a eskern tud varv hag a bep dic'hlanded en diabarzh. ");
INSERT INTO breBRG_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Evel-se c'hwi ivez, en diavaez, en em ziskouez reizh d'an dud, met en diabarzh, oc'h leun a bilpouzerezh hag a zireizhder. ");
INSERT INTO breBRG_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma savit bezioù d'ar brofeded ha ma vravait bezioù an dud reizh, ");
INSERT INTO breBRG_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","en ur lavarout: Mar vijemp bet en amzer hon tadoù, ne vijemp ket en em unanet ganto da skuilh gwad ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Testiñ a rit evel-se, a-enep deoc'h hoc'h-unan, penaos oc'h mibien ar re o deus lazhet ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Leuniañ a rit eta muzul ho tadoù. ");
INSERT INTO breBRG_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Naered, lignez a naered-gwiber, penaos e tec'hot diouzh kastiz ar gehenn? ");
INSERT INTO breBRG_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Setu perak e kasan deoc'h profeded, tud fur ha skribed; lazhañ hag stagañ ouzh ar groaz a reot darn, skourjezañ a reot darn all en ho sinagogennoù, hag argas a reot anezho eus an eil kêr d'eben, ");
INSERT INTO breBRG_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","evit ma kouezho warnoc'h an holl wad reizh a zo bet skuilhet war an douar, adalek gwad Abel, an hini reizh, betek gwad Zakaria, mab Barakia, hoc'h eus lazhet etre an templ hag an aoter. ");
INSERT INTO breBRG_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Me a lavar deoc'h e gwirionez, kement-se holl a gouezho war ar rummad-mañ. ");
INSERT INTO breBRG_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruzalem, Jeruzalem, te hag a lazh ar brofeded, hag a veinata ar re a zo kaset dit, pet gwech em eus c'hoantaet dastum da vugale, evel ma tastum ar yar he foñsined dindan he divaskell, ha n'eo ket bet fellet deoc'h! ");
INSERT INTO breBRG_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Setu, ho ti a ya da chom hep den, ");
INSERT INTO breBRG_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","rak me a lavar deoc'h, ne'm gwelot mui pelloc'h, betek ma lavarot: Ra vo benniget an hini a zeu en anv an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Evel ma'z ae Jezuz kuit eus an templ, e ziskibien a dostaas outañ, evit diskouez dezhañ savadurioù bras an templ. ");
INSERT INTO breBRG_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Met eñ a lavaras dezho: Ha gwelout a rit an holl draoù-se? Me en lavar deoc'h e gwirionez, ne chomo ket anezho amañ maen war vaen na vo diskaret. ");
INSERT INTO breBRG_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hag evel ma oa azezet war Venez an Olived, an diskibien a dostaas outañ, a-du, o lavarout: Lavar deomp pegoulz e c'hoarvezo kement-se, ha pehini e vo ar sin eus da zonedigezh hag eus fin ar bed? ");
INSERT INTO breBRG_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jezuz a respontas dezho: Diwallit na dromplfe den ac'hanoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Rak meur a hini a zeuio dindan va anv, o lavarout: Me eo ar C'hrist; hag e tromplint kalz a dud. ");
INSERT INTO breBRG_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Klevout a reot komz eus brezelioù, ha brud eus brezelioù, lakait evezh na vefec'h spontet; rak ret eo e teufe an traoù-se, met kement-se ne vo ket c'hoazh ar fin. ");
INSERT INTO breBRG_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Rak ur bobl a savo a-enep ur bobl all, hag ur rouantelezh a-enep ur rouantelezh all; hag e vo e meur a lec'h, naonegezhioù, bosennoù ha krenoù-douar; ");
INSERT INTO breBRG_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","an traoù-mañ ne vo nemet ar penn-kentañ eus ar gloazioù. ");
INSERT INTO breBRG_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Neuze e roint ac'hanoc'h evit bezañ poaniet, hag e lazhint ac'hanoc'h, hag e viot kasaet gant an holl bobloù, abalamour da'm anv. ");
INSERT INTO breBRG_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Neuze ivez, meur a hini a gouezho, en em drubardo, hag en em gasaio an eil egile. ");
INSERT INTO breBRG_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kalz a fals-profeded a savo, hag a dromplo kalz a dud. ");
INSERT INTO breBRG_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dre ma vo kresket an direizhder, karantez meur a hini a yenaio. ");
INSERT INTO breBRG_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Met an hini a gendalc'ho betek ar fin, a vo salvet. ");
INSERT INTO breBRG_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","An Aviel-mañ eus ar rouantelezh a vo prezeget er bed a-bezh, evit reiñ testeni d'an holl bobloù; neuze e teuio ar fin. ");
INSERT INTO breBRG_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Dre-se, pa welot an euzhusted eus ar glac'har, m'en deus komzet ar profed Daniel anezhi, deuet el lec'h santel (ra gompreno an neb a lenn), ");
INSERT INTO breBRG_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","neuze ar re a vo e Judea, ra dec'hint war ar menezioù, ");
INSERT INTO breBRG_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","an hini a vo war an doenn, ra ne ziskenno ket da gemer ar pezh a zo en e di, ");
INSERT INTO breBRG_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","hag an hini a vo er parkeier, ra ne zistroio ket a-dreñv da gemer e vantell. ");
INSERT INTO breBRG_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gwalleur d'ar gwragez brazez, ha d'ar magerezed en deizioù-se! ");
INSERT INTO breBRG_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pedit evit na erruo ket ho tec'h er goañv, nag e deiz ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Rak bez' e vo neuze ur glac'har ken bras, evel n'eus ket bet adalek penn-kentañ ar bed betek vremañ, ha ne vo biken. ");
INSERT INTO breBRG_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ha ma ne vije ket bet berraet an deizioù-se, den ebet ne vije salvet; met abalamour d'ar re zibabet, an deizioù-se a vo berraet. ");
INSERT INTO breBRG_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Neuze, mar lavar unan bennak deoc'h: Setu, ar C'hrist a zo amañ, pe aze, na gredit ket. ");
INSERT INTO breBRG_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rak fals-kristed ha fals-profeded a savo; hag e raint sinoù ha burzhudoù da dromplañ, ma vije gallet, zoken ar re zibabet. ");
INSERT INTO breBRG_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Setu, em eus e lavaret deoc'h a-raok. ");
INSERT INTO breBRG_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mar lavarer eta deoc'h: Setu, emañ el lec'h distro, n'it ket; setu, emañ er c'hambroù, na gredit ket. ");
INSERT INTO breBRG_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Rak, evel ma teu al luc'hedenn eus ar sav-heol ha ma he gweler betek ar c'huzh-heol, evel-se e vo donedigezh Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","E pep lec'h bennak ma vo ar c'horf marv, eno en em zastumo an erered. ");
INSERT INTO breBRG_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Raktal goude an deizioù a c'hlac'har-mañ, an heol a vo teñvalaet, al loar ne roio ket he sklêrijenn, ar stered a gouezho eus an oabl, ha galloudoù an neñv a vo brañsellet. ");
INSERT INTO breBRG_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Neuze sin Mab an den en em ziskouezo en neñv, holl bobloù an douar a glemmo en ur skeiñ war boull o c'halon, hag e welint Mab an den o tont war goabr an neñv, gant ur galloud hag ur gloar bras; ");
INSERT INTO breBRG_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eñ a gaso e aeled gant an trompilh tregernus, da zastum e re zibabet eus ar pevar avel, adalek ur penn eus an neñv betek ur penn all. ");
INSERT INTO breBRG_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Deskit dre barabolenn ar wezenn-fiez: pa zeu he brankoù da vezañ tener hag he delioù da vountañ, ec'h anavezit eo tost an hañv; ");
INSERT INTO breBRG_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","evel-se ivez, pa welot kement-se oc'h erruout, gouezit Mab an den a zo tost, hag ouzh an nor. ");
INSERT INTO breBRG_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Me a lavar deoc'h e gwirionez, penaos ar rummad-mañ ne dremeno ket, ken na vo c'hoarvezet an holl draoù-se. ");
INSERT INTO breBRG_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","An neñv hag an douar a dremeno, met va gerioù ne dremenint ket. ");
INSERT INTO breBRG_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Evit ar pezh a sell ouzh an deiz hag an eur, den n'o anavez, nag aeled an neñv, nag ar Mab, met an Tad hepken. ");
INSERT INTO breBRG_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ar pezh a c'hoarvezas en amzer Noe, evel-se a c'hoarvezo ivez da zonedigezh Mab an den; ");
INSERT INTO breBRG_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","rak en deizioù a-raok an dour-beuz, an dud a zebre hag a eve, en em zimeze hag a zimeze o bugale, betek an deiz ma'z eas Noe en arc'h, ");
INSERT INTO breBRG_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","hag ne ouezjont netra ken a zeuas an dour-beuz d'o c'has holl gantañ; evel-se e vo ivez da zonedigezh Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Neuze, e vo daou zen en ur park, unan a vo kemeret hag egile lezet, ");
INSERT INTO breBRG_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","e vo div wreg o valañ en ur vilin, unan a vo kemeret hag eben lezet. ");
INSERT INTO breBRG_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chomit dihun eta, rak n'ouzoc'h ket da bet eur e teuio hoc'h Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gouezit mat, ma anavezfe mestr an ti da bet beilhadenn eus an noz e tlefe ar laer dont, e chomfe dihun ha ne lezfe ket toullañ e di. ");
INSERT INTO breBRG_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dre-se, c'hwi ivez, en em zalc'hit prest, rak Mab an den a zeuio d'an eur na soñjit ket. ");
INSERT INTO breBRG_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Piv eo eta ar mevel feal ha poellek a zo bet lakaet gant e aotrou war e dud, evit reiñ dezho boued en amzer dereat? ");
INSERT INTO breBRG_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eürus ar mevel-se, pa zeuio en-dro e aotrou, mar bez kavet gantañ oc'h ober evel-se! ");
INSERT INTO breBRG_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Me a lavar deoc'h e gwirionez, e lakaat a raio war e holl vadoù. ");
INSERT INTO breBRG_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Met, mar deo drouk ar mevel-se, ha ma lavar en e galon: Va aotrou a zale da zont en-dro, ");
INSERT INTO breBRG_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ha ma teu da skeiñ gant e genseurted, ha da zebriñ ha da evañ gant ar vezvierien, ");
INSERT INTO breBRG_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","aotrou ar mevel-se a zeuio d'an deiz na c'hortozo ket ha d'an eur ne ouezo ket, ");
INSERT INTO breBRG_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","hag e tispenno anezhañ, hag e roio dezhañ e lod gant ar bilpouzed; eno eo, e vo goueladegoù ha grigoñsadegoù-dent. ");
INSERT INTO breBRG_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Neuze, rouantelezh an neñvoù a vo heñvel ouzh dek gwerc'hez a gemer o lampoù ganto, hag a ya da ziaraogiñ ar pried. ");
INSERT INTO breBRG_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pemp anezho a oa diskiant, ha pemp a oa fur. ");
INSERT INTO breBRG_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ar re ziskiant, en ur gemer o lampoù, ne gemerjont ket a eoul ganto. ");
INSERT INTO breBRG_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ar re fur a gemeras eoul en o fodoù, gant o lampoù. ");
INSERT INTO breBRG_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Evel ma talee ar pried da zont, e voredjont holl hag e kouskjont. ");
INSERT INTO breBRG_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Met, war-dro hanternoz, e voe klevet ur griadenn: Setu ar pried a zeu, it en e raok! ");
INSERT INTO breBRG_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Neuze an holl werc'hezed-se a savas hag a fichas o lampoù. ");
INSERT INTO breBRG_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ar re ziskiant a lavaras d'ar re fur: Roit deomp eus hoc'h eoul, rak hol lampoù a ya da vougañ. ");
INSERT INTO breBRG_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Met ar re fur a respontas: Gant aon n'hor befe ket a-walc'h evidomp hag evidoc'h, it kentoc'h da gavout ar re a werzh, ha prenit evidoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","E-pad ma'z aent da brenañ, e teuas ar pried; ar re a oa prest a zeuas gantañ d'an eured, hag e voe serret an nor. ");
INSERT INTO breBRG_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Goude-se e teuas ivez ar gwerc'hezed all, hag e lavarjont: Aotrou, aotrou, digor deomp! ");
INSERT INTO breBRG_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Met eñ a respontas: Me a lavar deoc'h e gwirionez, n'anavezan ket ac'hanoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chomit dihun eta, rak n'ouzoc'h nag an deiz nag an eur ma teuio Mab an den en-dro. ");
INSERT INTO breBRG_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Rak heñvel eo ouzh un den a yeas en ur vro bell, a c'halvas e servijerien, hag a lakaas e vadoù etre o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Reiñ a reas pemp talant da unan, daou da unan all, unan da unan all, da bep hini hervez e c'halloud. ");
INSERT INTO breBRG_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Neuze, an hini en devoa resevet ar pemp talant, a yeas hag o lakaas da dalvezout, hag a c'hounezas pemp talant all. ");
INSERT INTO breBRG_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","En hevelep doare, an hini en devoa resevet daou dalant, a c'hounezas daou all. ");
INSERT INTO breBRG_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Met an hini en devoa resevet unan, a yeas d'ober un toull en douar hag a guzhas arc'hant e aotrou. ");
INSERT INTO breBRG_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pell amzer goude, mestr ar servijerien-mañ a zistroas, hag e reas o c'hont ganto. ");
INSERT INTO breBRG_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","An hini en devoa resevet pemp talant, a zeuas hag a zegasas pemp talant all, en ur lavarout: Aotrou, pemp talant ac'h eus roet din, setu pemp talant all am eus gounezet ouzhpenn. ");
INSERT INTO breBRG_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","E vestr a lavaras dezhañ: Mat eo, servijer mat ha leal; dre ma'z out bet leal war nebeut a dra, da lakaat a rin war galz; kae e-barzh levenez da aotrou. ");
INSERT INTO breBRG_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","An hini en devoa resevet daou dalant a zeuas ivez hag a lavaras: Aotrou, daou dalant ac'h eus roet din, setu daou dalant all am eus gounezet ouzhpenn. ");
INSERT INTO breBRG_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","E vestr a lavaras dezhañ: Mat eo, servijer mat ha leal; dre ma'z out bet leal war nebeut a dra, da lakaat a rin war galz; kae e-barzh levenez da aotrou. ");
INSERT INTO breBRG_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","An hini n'en devoa resevet nemet un talant, a zeuas ivez hag a lavaras: Aotrou, gouzout a ran penaos out un den didruez, penaos e vedez e-lec'h na'c'h eus ket hadet, hag e tastumez e-lec'h na'c'h eus ket strewet; ");
INSERT INTO breBRG_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","hag e teuas aon din, hag on aet da guzhat da dalant en douar; setu, e roan dit ar pezh a zo dit. ");
INSERT INTO breBRG_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Met e aotrou a respontas dezhañ: Servijer fall ha diegus, gouzout a ouies penaos e vedan e-lec'h na'm eus ket hadet, hag e tastuman e-lec'h na'm eus ket strewet; ");
INSERT INTO breBRG_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","dleout a rajes eta reiñ va arc'hant d'ar vankerien, ha pa vijen deuet en-dro, em bije tennet va arc'hant gant ar c'hampi. ");
INSERT INTO breBRG_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lamit eta e dalant digantañ, hag roit eñ d'an hini en deus dek talant. ");
INSERT INTO breBRG_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Rak roet e vo d'an neb en deus, hag en devo a fonn; met an hini n'en deus ket, e vo lamet digantañ memes ar pezh en deus. ");
INSERT INTO breBRG_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ha taolit ar servijer didalvoud-se en deñvalijenn a-ziavaez, e-lec'h ma vo goueladegoù ha grigoñsadegoù-dent. ");
INSERT INTO breBRG_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Pa zeuio Mab an den en e c'hloar, gant an holl aeled, ec'h azezo war dron e c'hloar. ");
INSERT INTO breBRG_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","An holl bobloù a vo dastumet dirazañ, hag e tispartio an eil diouzh egile, evel ma tisparti ar mesaer an deñved diouzh ar bouc'hed. ");
INSERT INTO breBRG_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Lakaat a raio an deñved a-zehou dezhañ, hag ar bouc'hed a-gleiz. ");
INSERT INTO breBRG_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Neuze ar Roue a lavaro d'ar re a vo a-zehou dezhañ: Deuit, c'hwi a zo benniget gant va Zad, bezit perc'henn war ar rouantelezh a zo bet kempennet evidoc'h adalek krouidigezh ar bed; ");
INSERT INTO breBRG_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","rak naon am eus bet, ha roet hoc'h eus din da zebriñ; sec'hed am eus bet, ha roet hoc'h eus din da evañ; diavaeziad on bet, ha va degemeret hoc'h eus; ");
INSERT INTO breBRG_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","en noazh e oan, ha va gwisket hoc'h eus; klañv e oan, ha deuet oc'h da'm gwelout; er prizon e oan, ha deuet oc'h da'm c'havout. ");
INSERT INTO breBRG_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Neuze ar re reizh a responto dezhañ, o lavarout: Aotrou, pegoulz hon eus da welet o kaout naon hag hon eus roet dit da zebriñ, pe o kaout sec'hed hag hon eus roet dit da evañ? ");
INSERT INTO breBRG_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pegoulz hon eus da welet diavaeziad hag hon eus da zegemeret, pe en noazh hag hon eus da wisket? ");
INSERT INTO breBRG_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pegoulz hon eus da welet klañv, pe er prizon, hag hon eus deuet da'z kavout? ");
INSERT INTO breBRG_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hag ar Roue a responto dezho: Me a lavar deoc'h e gwirionez, bep gwech ma hoc'h eus graet kement-se e-keñver unan eus ar re zisterañ eus va breudeur, hoc'h eus graet an dra-se din. ");
INSERT INTO breBRG_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Neuze e lavaro d'ar re a vo a-gleiz dezhañ: Tec'hit diouzhin, tud villiget, it en tan peurbadus a zo bet kempennet evit an diaoul hag e aeled; ");
INSERT INTO breBRG_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","rak naon am eus bet, ha n'hoc'h eus ket roet din da zebriñ; sec'hed am eus bet, ha n'hoc'h eus ket roet din da evañ; ");
INSERT INTO breBRG_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","diavaeziad on bet, ha n'hoc'h eus ket va degemeret; en noazh e oan, ha n'hoc'h eus ket va gwisket; klañv hag er prizon e oan, ha n'oc'h ket deuet da'm gwelout. ");
INSERT INTO breBRG_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Neuze int a responto dezhañ, o lavarout: Aotrou, pegoulz hon eus da welet o kaout naon, pe sec'hed, diavaeziad, pe en noazh, klañv, pe er prizon, ha n'hon eus ket da sikouret? ");
INSERT INTO breBRG_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hag e responto dezho: Me a lavar deoc'h e gwirionez, bep gwech ma n'hoc'h eus ket graet kement-se e-keñver unan eus ar re zisterañ-se, n'hoc'h eus ket graet an dra-se em c'heñver. ");
INSERT INTO breBRG_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hag ar re-mañ a yelo er c'hastiz peurbadus, met ar re reizh er vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Goude m'en devoe Jezuz peurlavaret an holl gomzoù-se, e lavaras d'e ziskibien: ");
INSERT INTO breBRG_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Gouzout a rit emañ ar Pask a-benn daou zevezh, ha Mab an den a vo gwerzhet evit bezañ staget ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Neuze ar veleien vras, ar skribed hag henaourien ar bobl en em zastumas e porzh ar beleg-meur, anvet Kaifaz, ");
INSERT INTO breBRG_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","hag en em guzuilhjont evit gouzout penaos kregiñ e Jezuz dre droidell hag e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Met e lavarent: Arabat e vefe e-pad ar gouel, gant aon na savfe un drubuilh bennak e-touez ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jezuz, o vezañ e Betania e ti Simon al lovr, ");
INSERT INTO breBRG_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ur wreg a zeuas d'e gavout gant ul lestr alabastr leun a c'hwezh-vat eus ur priz bras, hag e-pad ma oa ouzh taol, e skuilhas anezhi war e benn. ");
INSERT INTO breBRG_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","An diskibien, o welout-se, a oa droug enno, hag e lavarjont: Perak ar c'holl-se? ");
INSERT INTO breBRG_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Rak gallet e vije bet gwerzhañ ar c'hwezh-vat ker, ha reiñ an arc'hant d'ar beorien. ");
INSERT INTO breBRG_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Met Jezuz, o c'houzout kement-se, a lavaras dezho: Perak e rit poan d'ar wreg-se? Un dra vat he deus graet em c'heñver. ");
INSERT INTO breBRG_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Rak c'hwi ho po bepred peorien ganeoc'h, met n'ho po ket atav ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Rak, pa he deus skuilhet ar c'hwezh-vat-se war va c'horf, he deus graet kement-se evit va beziadur. ");
INSERT INTO breBRG_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Me a lavar deoc'h e gwirionez, penaos el lec'hioù ma vo an aviel-mañ prezeget dre ar bed holl, ar pezh he deus graet a vo ivez lavaret en eñvor anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Neuze unan eus an daouzek, anvet Judaz Iskariod, a yeas da gavout ar veleien vras, ");
INSERT INTO breBRG_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hag a lavaras: Petra a roit din, ha me en lakaio etre ho taouarn? Int a reas marc'had gantañ eus tregont pezh arc'hant. ");
INSERT INTO breBRG_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Diwar neuze e klaskas an tu dereat d'e lakaat etre o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ar c'hentañ deiz eus ar bara hep goell, an diskibien a zeuas da gavout Jezuz hag a lavaras dezhañ: Pelec'h e c'hoantaez e kempennfemp dit evit debriñ ar Pask? ");
INSERT INTO breBRG_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eñ a lavaras: It e kêr da gavout an den-mañ-'n den, ha lavarit dezhañ: Ar Mestr a lavar: Va amzer a zo tost; ober a rin ar Pask ez ti gant va diskibien. ");
INSERT INTO breBRG_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","An diskibien a reas evel m'en devoa Jezuz gourc'hemennet dezho, hag e fichjont ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pa voe deuet an abardaez, en em lakaas ouzh taol gant an daouzek. ");
INSERT INTO breBRG_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","E-pad ma tebrent, e lavaras dezho: Me a lavar deoc'h e gwirionez, unan ac'hanoc'h am gwerzho. ");
INSERT INTO breBRG_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gwall-c'hlac'haret e oant, ha pep hini anezho en em lakaas da lavarout dezhañ: Aotrou, ha me eo? ");
INSERT INTO breBRG_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eñ a respontas dezho: An hini en deus lakaet e zorn ganin er plad, hennezh eo am gwerzho. ");
INSERT INTO breBRG_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mab an den, evit gwir, a ya hervez ar pezh a zo skrivet anezhañ; met gwalleur d'an den ma vo gwerzhet gantañ; gwell e vije d'an den-se, ne vije biken bet ganet. ");
INSERT INTO breBRG_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judaz, an hini en gwerzhe, o komz, a lavaras: Ha me eo, Mestr? Eñ a lavaras dezhañ: Lavaret ec'h eus. ");
INSERT INTO breBRG_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Evel ma tebrent, Jezuz a gemeras bara ha, goude bezañ trugarekaet, e torras anezhañ, hag en roas d'an diskibien, o lavarout: Kemerit, debrit, hemañ eo va c'horf. ");
INSERT INTO breBRG_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kemer a reas ivez an hanaf ha, goude bezañ trugarekaet, en roas dezho, o lavarout: Evit holl dioutañ, ");
INSERT INTO breBRG_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","rak hemañ eo va gwad, ar gwad eus an emglev nevez, skuilhet evit kalz, evit pardon ar pec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Me a lavar deoc'h, n'evin mui eus ar frouezh-se eus ar gwini, betek an deiz ma'c'h evin anezhañ nevez ganeoc'h e rouantelezh va Zad. ");
INSERT INTO breBRG_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Goude m'o devoe kanet ar c'hantikoù, ez ejont da Venez an Olived. ");
INSERT INTO breBRG_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Neuze Jezuz a lavaras dezho: Me a vo evidoc'h holl en noz-mañ un abeg da gouezhañ, rak skrivet eo: skeiñ a rin ar pastor, ha deñved ar bagad a vo stlabezet. ");
INSERT INTO breBRG_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Met goude ma vin adsavet a varv, ho tiaraogin e Galilea. ");
INSERT INTO breBRG_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pêr, o kemer ar gomz, a lavaras dezhañ: Pa vefes un abeg da gouezhañ evit an holl, evidon-me ne vi biken. ");
INSERT INTO breBRG_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jezuz a lavaras dezhañ: Me a lavar dit e gwirionez, penaos en noz-mañ memes, a-raok ma kano ar c'hilhog, te az po va dinac'het teir gwech. ");
INSERT INTO breBRG_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pêr a respontas dezhañ: Ha pa vefe ret din mervel ganit, ne zinac'hin ket ac'hanout. Hag an holl ziskibien a lavare ar memes tra. ");
INSERT INTO breBRG_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Neuze Jezuz a zeuas ganto en ul lec'h galvet Getsemane, hag e lavaras d'e ziskibien: Azezit amañ e-pad ma'z in da bediñ ahont. ");
INSERT INTO breBRG_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kemer a reas gantañ Pêr ha daou vab Zebedea, hag e voe leuniet a dristidigezh hag a anken. ");
INSERT INTO breBRG_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Neuze e lavaras dezho: Trist eo va ene betek ar marv; chomit amañ ha beilhit ganin. ");
INSERT INTO breBRG_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","O vont un tamm a-raokoc'h, en em daolas war e c'henou d'an douar, hag e pedas o lavarout: Va Zad, ma pellaio an hanaf-se diouzhin, mar gell-se bezañ! Koulskoude neket evel ma fell din, met evel ma fell dit. ");
INSERT INTO breBRG_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hag e tistroas da gavout e ziskibien, o c'havas kousket, hag e lavaras da Bêr: Ha n'hoc'h eus ket gallet beilhañ un eur ganin? ");
INSERT INTO breBRG_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Beilhit ha pedit evit na gouezhot ket en temptadur; ar spered a zo buan, met ar c'hig a zo dinerzh. ");
INSERT INTO breBRG_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mont a reas adarre un eil gwech, hag e pedas o lavarout: Va Zad, ma ne c'hell ket an hanaf-se mont e-biou din hep ma'c'h evin anezhañ, ra vo graet da volontez! ");
INSERT INTO breBRG_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O vezañ distroet, o c'havas adarre kousket, rak o daoulagad a oa pounneraet. ");
INSERT INTO breBRG_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O c'huitaat a reas adarre, hag e pedas evit an trede gwech, o lavarout ar memes komzoù. ");
INSERT INTO breBRG_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Neuze e tistroas da gavout e ziskibien hag e lavaras dezho: Kouskit bremañ ha diskuizhit! Setu, an eur a zo tost ha Mab an den a zo lakaet etre daouarn ar bec'herien. ");
INSERT INTO breBRG_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Savit, ha deomp, setu, an hini am gwerzh a dosta. ");
INSERT INTO breBRG_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Evel ma komze c'hoazh, setu Judaz, unan eus an daouzek, a zeuas, ha gantañ ur vandenn vras a dud gant klezeier ha gant bizhier, a-berzh ar veleien vras hag henaourien ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","An hini en gwerzhe en devoa roet ar sin-mañ: An hini a bokin dezhañ, hennezh eo, krogit ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Raktal e tostaas ouzh Jezuz, hag e lavaras dezhañ: Salud, Mestr! Hag e pokas dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jezuz a lavaras dezhañ: Va mignon, evit petra out amañ? Neuze e tostajont, e lakajont o daouarn war Jezuz, hag e krogjont ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ha setu, unan eus ar re a oa gant Jezuz a astennas e zorn, a dennas e gleze, a skoas servijer ar beleg-meur, hag a droc'has e skouarn dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Neuze Jezuz a lavaras dezhañ: Laka da gleze en e lec'h; rak an holl re a gemero ar c'hleze, a varvo dre ar c'hleze. ");
INSERT INTO breBRG_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ha soñjal a rez na c'hellfen ket pediñ va Zad, hag e rofe din raktal ouzhpenn daouzek lejion aeled? ");
INSERT INTO breBRG_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Penaos eta e vefe peurc'hraet ar Skriturioù a lavar e tle an traoù c'hoarvezout evel-se? ");
INSERT INTO breBRG_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","D'an ampoent-se, Jezuz a lavaras d'ar vandenn-se: Deuet oc'h er-maez evel war-lerc'h ul laer, gant klezeier ha gant bizhier, evit kregiñ ennon. Bemdez e oan azezet en ho touez, o kelenn en templ, ha n'hoc'h eus ket va c'hemeret. ");
INSERT INTO breBRG_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Met kement-se a zo c'hoarvezet evit ma vo peurc'hraet ar pezh a zo bet skrivet gant ar brofeded. Neuze e holl ziskibien, o vezañ e zilezet, a dec'has kuit. ");
INSERT INTO breBRG_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ar re o devoa kemeret Jezuz, a gasas anezhañ da di Kaifaz, ar beleg-meur, e-lec'h ma oa en em zastumet ar skribed hag an henaourien. ");
INSERT INTO breBRG_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pêr a heulias anezhañ a-bell betek porzh ar beleg-meur. Hag, o vezañ aet e-barzh, ec'h azezas gant ar vevelien, evit gwelout penaos ec'h echufe kement-se. ");
INSERT INTO breBRG_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Neuze, ar veleien vras, an henaourien, hag an holl sanedrin a glaske ur falstesteni bennak a-enep Jezuz, evit e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hogen ne gavent ket, petra bennak ma teuas meur a fals-test. En diwezh, e teuas daou fals-test, hag a lavaras: ");
INSERT INTO breBRG_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hemañ en deus lavaret: Me a c'hell diskar templ Doue, hag en adsevel e tri devezh. ");
INSERT INTO breBRG_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ar beleg-meur a savas hag a lavaras dezhañ: Ha ne respontez netra? Petra a dest an dud-se en da enep? ");
INSERT INTO breBRG_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Met Jezuz a davas. Ar beleg-meur a lavaras dezhañ: Da bediñ a ran, en anv an Doue bev, da lavarout deomp mar dout ar C'hrist, Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jezuz a lavaras dezhañ: E lavaret ec'h eus; ouzhpenn, e lavaran deoc'h, e welot hiviziken Mab an den azezet a-zehou da c'halloud Doue, hag o tont war goabr an neñv. ");
INSERT INTO breBRG_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Neuze ar beleg-meur a rogas e zilhad, en ur lavarout: Touet en deus! Da betra hon eus mui ezhomm a destoù? Klevet hoc'h eus e ledoued; ");
INSERT INTO breBRG_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","petra a soñjit a-se? Respont a rejont: Din eo da vervel. ");
INSERT INTO breBRG_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Neuze e krañchjont ouzh e zremm hag e rojont dezhañ karvanadoù ha jodadoù, ");
INSERT INTO breBRG_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","o lavarout: Diougan deomp, Krist, piv eo an hini en deus skoet ganit? ");
INSERT INTO breBRG_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Koulskoude, Pêr a oa azezet en diavaez, er porzh; ur vatezh a dostaas outañ en ur lavarout: Te ivez, te a oa gant Jezuz ar Galilead. ");
INSERT INTO breBRG_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Met eñ a nac'has dirak an holl, o lavarout: N'ouzon ket petra a lavarez; ");
INSERT INTO breBRG_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Evel ma'z ae etrezek an nor, ur vatezh all a welas anezhañ, hag a lavaras d'ar re a oa eno: Hemañ a oa ivez gant Jezuz a Nazared. ");
INSERT INTO breBRG_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eñ a nac'has adarre gant ul ledoued: N'anavezan ket an den-se. ");
INSERT INTO breBRG_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ur pennad goude, ar re a oa eno a dostaas hag a lavaras da Bêr: Evit gwir te a zo eus an dud-se, rak da anavezout a reer diouzh da yezh. ");
INSERT INTO breBRG_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Neuze en em lakaas da zroukpediñ ha da douiñ, o lavarout: N'anavezan ket an den-se. Raktal ar c'hilhog a ganas; ");
INSERT INTO breBRG_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ha Pêr en devoe soñj eus ar gomz en devoa Jezuz lavaret: A-raok ma kano ar c'hilhog, ez po va dinac'het teir gwech. Hag o vezañ aet er-maez, e ouelas gant c'hwervder. ");
INSERT INTO breBRG_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pa voe deuet ar mintin, an holl veleien vras hag henaourien ar bobl en em guzulias a-enep Jezuz evit e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","O vezañ e ereet, en degasjont hag en lakajont etre daouarn Poñs-Pilat, ar gouarnour. ");
INSERT INTO breBRG_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Neuze, Judaz, an hini en devoa e werzhet, o welout penaos e oa kondaonet, a zeuas morc'hed dezhañ, hag e tegasas an tregont pezh arc'hant d'ar veleien vras ha d'an henaourien, ");
INSERT INTO breBRG_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","o lavarout: Pec'het em eus o werzhañ ar gwad didamall. Met int a lavaras dezhañ: Petra a ra-se deomp? An dra-se a sell ouzhit. ");
INSERT INTO breBRG_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Goude m'en devoe taolet ar pezhioù arc'hant en templ, ez eas kuit, hag en em grougas. ");
INSERT INTO breBRG_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ar veleien vras o dastumas hag a lavaras: N'eo ket aotreet o lakaat en teñzor, dre ma'z int priz ar gwad. ");
INSERT INTO breBRG_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hag, o vezañ en em guzuliet, e prenjont park ar poder, evit beziañ an diavaezidi. ");
INSERT INTO breBRG_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Setu perak eo galvet ar park-se, Park ar Gwad, betek hiziv. ");
INSERT INTO breBRG_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Neuze e voe peurc'hraet ar pezh a oa bet lavaret gant Jeremia, ar profed: Kemeret o deus an tregont pezh arc'hant, gwerzh an hini a zo bet lakaet e briz, eus an hini a zo bet lakaet e briz gant bugale Israel, ");
INSERT INTO breBRG_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","hag o rojont evit park ar poder, evel m'en deus an Aotrou urzhiet din. ");
INSERT INTO breBRG_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jezuz a voe lakaet dirak ar gouarnour; ar gouarnour a reas ar goulenn-mañ outañ: Bez' out-te roue ar Yuzevien? Jezuz a respontas dezhañ: Te en lavar. ");
INSERT INTO breBRG_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Met pa voe tamallet gant ar veleien vras ha gant an henaourien, ne respontas netra. ");
INSERT INTO breBRG_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Neuze Pilat a lavaras dezhañ: Ha ne glevez ket pegement a draoù a damallont dit? ");
INSERT INTO breBRG_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Met eñ ne respontas ket ur ger dezhañ, en hevelep doare ma oa ar gouarnour souezhet- meurbet. ");
INSERT INTO breBRG_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ar gouarnour en devoa ar c'hiz, da bep gouel, da leuskel d'ar bobl an hini eus ar brizonidi a c'houlennent. ");
INSERT INTO breBRG_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bez' e oa neuze ur prizoniad brudet-bras, a c'halved Barabbaz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Evel ma oant dastumet, Pilat a lavaras dezho: Pehini a fell deoc'h e laoskfen deoc'h, Barabbaz, pe Jezuz a c'halver Krist? ");
INSERT INTO breBRG_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Rak anavezout a rae e oa dre avi o devoa e lakaet etre e zaouarn. ");
INSERT INTO breBRG_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","E-pad ma oa azezet war e gador-varn, e wreg a gasas da lavarout dezhañ: Ra ne vo netra etre an den reizh-se ha te; rak gwall-boaniet on bet hiziv, dre un hunvre, abalamour dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Met ar veleien vras hag an henaourien a alias ar bobl da c'houlenn Barabbaz, ha da lakaat koll Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ar gouarnour, o kemer ar gomz, a lavaras dezho: Pehini an daou a fell deoc'h e laoskfen deoc'h? Int a lavaras: Barabbaz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat a lavaras dezho: Petra a rin eta eus Jezuz a c'halver Krist? Holl a lavarjont: Ra vo staget ouzh ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ar gouarnour a lavaras: Peseurt droug en deus graet? Hag e krient kreñvoc'h, o lavarout: Ra vo staget ouzh ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat, o welout penaos ne c'houneze netra, met e kreske an drubuilh, a gemeras dour hag a walc'has e daouarn dirak ar bobl, o lavarout: Didamall on eus gwad an den reizh-mañ; soñjit-se. ");
INSERT INTO breBRG_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hag an holl bobl a respontas: Ra gouezho e wad warnomp ha war hor bugale! ");
INSERT INTO breBRG_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Neuze e laoskas dezho Barrabaz; ha goude bezañ lakaet skourjezañ Jezuz, en lakaas etre o daouarn evit bezañ staget ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Neuze soudarded ar gouarnour a zegasas Jezuz er pretordi, hag e tastumjont en-dro dezhañ an holl strollad. ");
INSERT INTO breBRG_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","O vezañ e ziwisket, e lakajont warnañ ur vantell ruz-skarlek. ");
INSERT INTO breBRG_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","O vezañ gweet ur gurunenn spern, e lakajont anezhi war e benn, gant ur gorzenn en e zorn dehou, hag o plegañ o glin dirazañ, e raent goap anezhañ, o lavarout: Me a salud ac'hanout, roue ar Yuzevien. ");
INSERT INTO breBRG_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hag o vezañ krañchet outañ, e kemerjont ar gorzenn hag e skojont ganti war e benn. ");
INSERT INTO breBRG_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Goude bezañ graet goap anezhañ, e lamjont ar vantell diwarnañ, e wiskjont dezhañ e zilhad en-dro, hag e kasjont anezhañ evit e lakaat ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Evel ma teuent er-maez, e kavjont un den eus Siren, anvet Simon, hag e lakajont anezhañ da zougen kroaz Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","O vezañ erruet en ul lec'h anvet Golgota, da lavarout eo lec'h ar c'hlopenn, ");
INSERT INTO breBRG_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","e rojont dezhañ da evañ gwinegr mesket gant bestl; ha p'en devoe e dañvaet, ne fellas ket dezhañ evañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Goude bezañ e staget ouzh ar groaz, e lodennjont e zilhad, ouzh o zeurel d'ar sord, evit ma vije peurc'hraet ar pezh a oa bet lavaret gant ar profed: Lodennet o deus va dilhad, ha taolet o deus va sae d'ar sord. ");
INSERT INTO breBRG_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hag, o vezañ azezet, e tiwalljont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lakaat a rejont a-us d'e benn abeg e gondaonidigezh, dre ar skrid: HEMAÑ EO JEZUZ ROUE AR YUZEVIEN. ");
INSERT INTO breBRG_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Neuze e voe kroazstaget gantañ daou laer, unan a-zehou, hag egile a-gleiz dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ar re a dremene dre eno a lavare dismegañsoù dezhañ, o hejañ o fenn, ");
INSERT INTO breBRG_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hag o lavarout: He! Te, an hini a ziskar an templ hag en adsav e tri devezh, en em savete da-unan! Mar dout Mab Doue, diskenn eus ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Evel-se ivez, ar veleien vras, gant ar skribed hag an henaourien, a lavare, en ur c'hoapaat: ");
INSERT INTO breBRG_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Saveteet en deus ar re all, ha ne c'hell ket en em saveteiñ e-unan! Mar deo roue Israel, ra ziskenno bremañ eus ar groaz, hag e kredimp ennañ! ");
INSERT INTO breBRG_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","En em fiziout a rae e Doue, ra zieubo Doue anezhañ bremañ, mar en em blij ennañ; rak lavaret en deus: Mab Doue on! ");
INSERT INTO breBRG_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Al laeron ivez, a oa kroazstaget gantañ, a rae dezhañ an hevelep rebechoù. ");
INSERT INTO breBRG_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Adalek ar c'hwec'hvet eur betek an navet, e voe teñvalijenn war an douar holl. ");
INSERT INTO breBRG_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ha war-dro an navet eur, Jezuz a grias gant ur vouezh kreñv: Eli, Eli, lama sabaktani? Da lavarout eo: Va Doue, va Doue, perak ec'h eus va dilezet? ");
INSERT INTO breBRG_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hiniennoù eus ar re a oa eno, o vezañ e glevet, a lavare: Setu e c'halv Elia. ");
INSERT INTO breBRG_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ha raktal, unan anezho a redas, a gemeras ur spoueenn, hag o vezañ he leuniet a winegr, he lakaas e penn ur gorzenn, hag he roas dezhañ da evañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Met ar re all a lavare: Lez; gwelomp hag-eñ e teuio Elia d'e saveteiñ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Neuze Jezuz, o vezañ taolet adarre ur griadenn vras, a rentas e spered. ");
INSERT INTO breBRG_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ha setu, gouel an templ a rogas e div, adalek krec'h betek traoñ, an douar a grenas, ar reier a frailhas, ");
INSERT INTO breBRG_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ar bezioù a zigoras, ha meur a gorf ar sent a oa marv, a adsavas a varv; ");
INSERT INTO breBRG_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","hag, o vezañ aet er-maez eus o bezioù goude adsavidigezh Jezuz a varv, ez ejont er gêr santel hag en em ziskouezjont da galz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Neuze, ar c'hantener hag ar re a oa gantañ da ziwall Jezuz, o welout ar c'hren-douar ha kement a oa c'hoarvezet, a voe spontet bras hag a lavaras: Hemañ, evit gwir, a oa Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bez' e oa ivez meur a wreg a selle a-bell; heuliet o devoa Jezuz adalek Galilea, ouzh e servijañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","En o-zouez e oa Mari a Vagdala, Mari mamm da Jakez ha da Jozef, ha mamm mibien Zebedea. ");
INSERT INTO breBRG_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Diouzh an abardaez, e teuas un den pinvidik eus Arimatea, anvet Jozef, un den a oa ivez diskibl da Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mont a reas da gavout Pilat, hag e c'houlennas digantañ korf Jezuz. Neuze Pilat a c'hourc'hemennas reiñ ar c'horf. ");
INSERT INTO breBRG_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jozef a gemeras ar c'horf, en goloas gant ul lienenn gwenn, ");
INSERT INTO breBRG_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","hag a lakaas anezhañ en e vez nevez e-unan en devoa toullet er roc'h; ha goude bezañ ruilhet ur maen bras ouzh dor ar bez, ez eas kuit. ");
INSERT INTO breBRG_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari a Vagdala hag ar Vari all, a oa azezet eno, e-tal ar bez. ");
INSERT INTO breBRG_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","An deiz war-lerc'h a oa deiz goude ar c'hempennadur; ar veleien vras hag ar farizianed en em zastumas hag a yeas da gavout Pilat, ");
INSERT INTO breBRG_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hag e lavarjont dezhañ: Aotrou, deuet eo da soñj deomp, penaos an trompler-se a lavare pa oa bev: A-benn tri devezh, ec'h adsavin a varv. ");
INSERT INTO breBRG_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gourc'hemenn eta ma vo diwallet ar bez betek an trede deiz, gant aon na zeufe e ziskibien en noz d'e laerezh ha da lavarout d'ar bobl: Savet eo a-douez ar re varv. An tromplerezh diwezhañ-se a vefe gwashoc'h eget an hini kentañ. ");
INSERT INTO breBRG_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat a lavaras dezho: Gwarded hoc'h eus, it ha diwallit eñ evel ma karot. ");
INSERT INTO breBRG_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mont a rejont eta kuit, hag e lakajont e surentez ar bez, en ur siellañ ar maen, hag o lakaat gwarded war e dro. ");
INSERT INTO breBRG_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pa voe tremenet ar sabad, da darzh an deiz kentañ eus ar sizhun, e teuas Mari a Vagdala hag ar Vari all da welout ar bez. ");
INSERT INTO breBRG_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ha setu e c'hoarvezas ur c'hren-douar, rak un ael eus an Aotrou a ziskennas eus an neñv, a zeuas da ruilhañ ar maen a zirak ar bez, hag a azezas warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","E neuz a oa evel ul luc'hedenn hag e zilhad gwenn evel an erc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ar warded a grene gant ar spont razañ, hag e teujont evel tud varv. ");
INSERT INTO breBRG_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Met an ael a lavaras d'ar gwragez: Evidoc'h-hu, n'ho pet ket aon, rak gouzout a ran e klaskit Jezuz, an hini a zo bet staget ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","N'emañ ket amañ, rak adsavet eo a varv, hervez m'en devoa lavaret. Deuit ha gwelit al lec'h ma oa bet lakaet an Aotrou; ");
INSERT INTO breBRG_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","it raktal, ha lavarit d'e ziskibien penaos eo adsavet a-douez ar re varv; ha setu, ho tiaraogo e Galilea, eno en gwelot; setu, em eus e lavaret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mont a rejont raktal er-maez eus ar bez, gant spont ha levenez vras, hag e redjont da zisklêriañ kement-mañ d'an diskibien. ");
INSERT INTO breBRG_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ha setu, Jezuz a zeuas a-ziarbenn dezho, hag a lavaras: Salud deoc'h. Hag int, o tostaat, a bokas d'e dreid hag en em stouas dirazañ. ");
INSERT INTO breBRG_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Neuze Jezuz a lavaras dezho: N'ho pet ket aon; it ha lavarit da'm breudeur mont e Galilea, eno eo e welint ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pa voent aet kuit, setu, lod eus ar warded a zeuas e kêr hag a zisklêrias d'ar veleien vras kement a oa c'hoarvezet. ");
INSERT INTO breBRG_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ar re mañ o vezañ en em zastumet gant an henaourien, ha goude bezañ en em guzuliet, a roas kalz a arc'hant d'ar soudarded, ");
INSERT INTO breBRG_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","o lavarout: Lavarit: Deuet eo e ziskibien e-pad an noz ha laeret o deus e gorf e-keit ha ma oamp kousket. ");
INSERT INTO breBRG_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mar deu ar gouarnour da glevout kement-se, ni a c'hounezo anezhañ, hag a dennimp ac'hanoc'h a boan. ");
INSERT INTO breBRG_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Int, o vezañ kemeret an arc'hant, a reas evel ma oa bet lavaret dezho. Hag ar vrud-se a zo bet en em skuilhet e-touez ar Yuzevien, betek hiziv. ");
INSERT INTO breBRG_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Met an unnek diskibl a yeas e Galilea, war ar menez a oa bet merket dezho gant Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pa en gweljont, ec'h azeuljont anezhañ; met darn a zouetas. ");
INSERT INTO breBRG_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jezuz a dostaas outo hag a lavaras dezho: Pep galloud a zo bet roet din en neñv ha war an douar. ");
INSERT INTO breBRG_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","It eta, grit diskibien eus an holl vroadoù, o vadeziñ anezho en anv an Tad, ar Mab hag ar Spered-Santel, ");
INSERT INTO breBRG_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","hag o teskiñ dezho mirout kement am eus gourc'hemennet deoc'h; ha setu, emaon ganeoc'h bemdez betek fin ar bed. Amen. ");
INSERT INTO breBRG_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Penn-kentañ Aviel Jezuz-Krist, Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hervez ar pezh a oa bet skrivet er brofeded: Setu e kasan va c'hannad dirak da zremm, da gempenn an hent dirazout; ");
INSERT INTO breBRG_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","mouezh an hini a gri el lec'h distro a lavar: Kempennit hent an Aotrou, plaenit e wenodennoù. ");
INSERT INTO breBRG_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yann a zeuas o badeziñ el lec'h distro, hag o prezeg badeziant ar geuzidigezh evit pardon ar pec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","An holl Judea hag holl dud Jeruzalem a yae d'e gavout, hag e oant badezet gantañ er stêr Jordan, oc'h anzav o fec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yann a zouge ur sae a vlev kañval hag ur gouriz lêr en-dro d'e groazell; e voued a oa kilheien-raden ha mel gouez. ");
INSERT INTO breBRG_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hag e prezege, o lavarout: Dont a ra unan war va lerc'h, hag a zo galloudusoc'h egedon, ha n'on ket dellezek, en ur blegañ, da zieren korreenn e votoù. ");
INSERT INTO breBRG_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Evidon-me, ho padezet em eus en dour, met eñ ho padezo er Spered-Santel. ");
INSERT INTO breBRG_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Erruout a reas, en amzer-se, ma teuas Jezuz eus Nazared e Galilea, hag e voe badezet gant Yann er Jordan. ");
INSERT INTO breBRG_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kerkent, evel ma save eus an dour, e welas an neñvoù digor hag ar Spered-Santel, evel ur goulm, o tiskenn warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ur vouezh a zeuas eus an neñvoù, o lavarout: Te eo va Mab karet-mat, ennout em eus lakaet va holl levenez. ");
INSERT INTO breBRG_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ha raktal ar Spered a gasas Jezuz el lec'h distro. ");
INSERT INTO breBRG_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hag e voe el lec'h distro daou-ugent devezh, o vezañ temptet gant Satan; eno e oa gant al loened gouez, hag an aeled a servije anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Met goude ma voe bet lakaet Yann er prizon, Jezuz a yeas e Galilea, o prezeg Aviel rouantelezh Doue, ");
INSERT INTO breBRG_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","hag o lavarout: An amzer a zo peurc'hraet, ha rouantelezh Doue a zo tost. Ho pet keuz ha kredit en Aviel. ");
INSERT INTO breBRG_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Hag, evel ma valee a-hed mor Galilea, e welas Simon hag Andrev e vreur, o teurel o roued er mor, rak pesketaerien e oant. ");
INSERT INTO breBRG_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Neuze Jezuz a lavaras dezho: Heuilhit ac'hanon, ha me ho raio pesketaerien dud. ");
INSERT INTO breBRG_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kerkent, o lezel o rouedoù, e heuilhjont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hag ac'hano, o vont un tamm a-raokoc'h, e welas en ur vag Jakez mab Zebedea, ha Yann e vreur, o fichañ o rouedoù. ");
INSERT INTO breBRG_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Raktal e c'halvas anezho; hag int, o lezel Zebedea o zad er vag gant an devezhourien, a heulias anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Goude-se ez ejont e Kafarnaoum; Jezuz, o vezañ da gentañ aet er sinagogenn deiz ar Sabad, a gelenne enni. ");
INSERT INTO breBRG_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hag e oant souezhet eus e gelenn; rak o deskiñ a rae evel o kaout galloud, ha neket evel ar skribed. ");
INSERT INTO breBRG_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Neuze, en em gavas er sinagogenn un den dalc'het gant ur spered hudur hag a grias, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ah! Petra a zo etre te ha ni, Jezuz a Nazared? Deuet out evit hor c'holl? Me a oar piv out: Sant Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jezuz a c'hourdrouzas anezhañ o lavarout: Tav, ha kae eus an den-se. ");
INSERT INTO breBRG_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Neuze ar spered hudur en hejas start hag o leuskel ur griadenn vras, a yeas kuit outañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Souezhet bras e voent holl, en hevelep doare ma en em c'houlennent etrezo: Petra eo kement-mañ? Petra eo ar gredenn nevez-mañ? Rak gant galloud e c'hourc'hemenn, memes d'ar speredoù hudur, hag e sentont outañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hag ar vrud anezhañ en em skuilhas kerkent en holl vro en-dro da C'halilea. ");
INSERT INTO breBRG_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kerkent goude, o vezañ aet er-maez eus ar sinagogenn, e teujont gant Jakez ha Yann e ti Simon hag Andrev. ");
INSERT INTO breBRG_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mamm-gaer Simon a oa en he gwele, klañv gant an derzhienn, ha raktal e komzjont outañ diwar he fenn. ");
INSERT INTO breBRG_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Neuze, o tostaat, en ur gemer he dorn e reas dezhi sevel; raktal an derzhienn a yeas kuit diouti, hag e servijas anezho. ");
INSERT INTO breBRG_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","War an abardaez, pa voe kuzhet an heol, e tegasjont dezhañ an holl dud klañv, hag ar re a oa dalc'het gant diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Holl dud kêr a oa dastumet dirak dor an ti. ");
INSERT INTO breBRG_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hag e yac'haas kalz a dud klañv eus meur a gleñved, hag e kasas kuit meur a ziaoul, o tifenn outo lavarout ec'h anavezent anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ar beure, evel ma rae c'hoazh gwall deñval, o vezañ savet, ez eas er-maez, hag o vont en ul lec'h a-du, e pedas eno. ");
INSERT INTO breBRG_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon, hag ar re a oa gantañ a yeas d'e glask. ");
INSERT INTO breBRG_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","O vezañ e gavet, e lavarjont dezhañ: An holl a glask ac'hanout. ");
INSERT INTO breBRG_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Eñ a lavaras dezho: Deomp d'an nesañ bourc'hioù, evit ma prezegin ivez eno; rak evit-se eo on deuet. ");
INSERT INTO breBRG_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hag e prezege en o sinagogennoù, dre an holl C'halilea, hag e kase kuit an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Un den lovr a zeuas d'e gavout, en em daolas war e zaoulin, en pedas hag a lavaras dezhañ: Mar fell dit, e c'hellez va glanaat. ");
INSERT INTO breBRG_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jezuz, o kaout truez outañ, a astennas e zorn, en stokas, hag a lavaras dezhañ: Fellout a ra din, bez glanaet. ");
INSERT INTO breBRG_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hag adalek m'en devoa lavaret-se, al lorgnez a guitaas raktal an den-mañ, hag e voe glanaet. ");
INSERT INTO breBRG_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jezuz a gasas anezhañ kuit raktal, gant gourc'hemennoù start, ");
INSERT INTO breBRG_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","o lavarout dezhañ: Diwall da lavarout netra da zen; met kae hag en em ziskouez d'ar beleg, ha kinnig evit da c'hlanidigezh ar pezh en deus Moizez gourc'hemennet, evit ma servijo-se da desteni dezho. ");
INSERT INTO breBRG_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Met an den-mañ, o vezañ aet kuit, en em lakaas da zisklêriañ uhel an dra ha da skuilhañ ar vrud aze, en hevelep doare na c'helle mui Jezuz mont e kêr dirak an holl; met en em zerc'hel a rae er-maez el lec'hioù distro, hag a bep tu e teued d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Un devezh bennak goude, Jezuz a zistroas da Gafarnaoum, hag e voe klevet e oa en ti. ");
INSERT INTO breBRG_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ha kerkent kement a dud en em zastumas eno, en hevelep doare ma ne oa ket a lec'h a-walc'h dirak an nor evit o derc'hel; eñ a brezege dezho ger Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Neuze e teuas d'e gavout tud o tegas dezhañ un den seizet, douget gant pevar den. ");
INSERT INTO breBRG_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Met evel na c'hellent ket tostaat ouzh an nor abalamour d'an dud niverus, e tistojont an ti ma oa ennañ; hag o vezañ e doullet, e tiskennjont ar gwele war ma oa gourvezet an den seizet warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Neuze Jezuz, o welout o feiz, a lavaras d'an den seizet: Va mab, da bec'hedoù a zo pardonet dit. ");
INSERT INTO breBRG_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ur re eus ar skribed a oa azezet eno, a soñje en o c'halonoù: ");
INSERT INTO breBRG_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Perak e lavar hemañ gwallgomzoù? Piv a c'hell pardoniñ ar pec'hedoù nemet Doue hepken? ");
INSERT INTO breBRG_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jezuz, o vezañ anavezet raktal dre e spered e lavarent evel-se enno o-unan, a lavaras dezho: Perak hoc'h eus ar soñjoù-se en ho kalonoù? ");
INSERT INTO breBRG_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Petra eo an aesoc'h, lavarout d'an den seizet- mañ: Da bec'hedoù a zo pardonet dit, pe lavarout: Sav, kemer da wele, ha bale? ");
INSERT INTO breBRG_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Met evit ma ouiot penaos Mab an den en deus war an douar ar galloud da bardoniñ ar pec'hedoù, -e lavaras d'an den seizet-: ");
INSERT INTO breBRG_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Me a lavar dit, sav, kemer da wele, ha kae da'z ti. ");
INSERT INTO breBRG_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ha kerkent e savas, hag o vezañ kemeret e wele, ez eas er-maez, dirak an holl, en hevelep doare ma oant holl souezhet, ha ma roent gloar da Zoue, o lavarout: Biskoazh n'hon eus gwelet kemend-all. ");
INSERT INTO breBRG_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Neuze Jezuz a zistroas war-zu ar mor; an holl bobl a zeue d'e gavout, hag eñ o c'helenne. ");
INSERT INTO breBRG_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","En ur dremen, e welas Levi, mab Alfe, azezet e ti ar gwirioù, hag e lavaras dezhañ: Deus war va lerc'h. Eñ, o vezañ savet, en heulias. ");
INSERT INTO breBRG_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jezuz o vezañ ouzh taol e ti an den-mañ, kalz a bublikaned hag a dud a vuhez fall en em lakaas ivez ouzh taol gantañ ha gant e ziskibien; rak kalz anezho o devoa heuliet anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ar skribed hag ar farizianed, o welout penaos e tebre gant ar bublikaned ha gant an dud a vuhez fall, a lavaras d'e ziskibien: Perak e tebr hag ec'h ev-eñ gant ar bublikaned ha gant an dud a vuhez fall? ");
INSERT INTO breBRG_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jezuz o vezañ klevet-se a lavaras dezho: N'eo ket ar re a zo yac'h o deus ezhomm a vedisin, met ar re a zo klañv; n'on ket deuet evit gervel ar re reizh d'ar geuzidigezh, met ar bec'herien. ");
INSERT INTO breBRG_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Diskibien Yann ha re ar farizianed a yune alies, hag e teujont hag e lavarjont dezhañ: A-belec'h e teu, ma yun diskibien Yann ha re ar farizianed, ha da ziskibien-te ne yunont ket? ");
INSERT INTO breBRG_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jezuz a lavaras dezho: Mignoned ar pried, ha gallout a reont yunañ e-pad ma'z emañ ar pried ganto? E-pad an holl amzer ma emañ ar pried ganto, ne c'hellont ket yunañ. ");
INSERT INTO breBRG_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Met deizioù a zeuio ma vo lamet ar pried diganto, ha neuze e yunint, en deizioù-se. ");
INSERT INTO breBRG_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Den ne wri un tamm mezher nevez ouzh un dilhad kozh, pe an tamm nevez a ziframmfe an hini kozh, hag ar rog a vefe brasoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Den kennebeut ne lak gwin nevez e seier-lêr kozh; rak ar gwin nevez a dorrfe ar seier, ar gwin en em skuilhfe, hag ar seier-lêr a vefe kollet; met ar gwin nevez a zle bezañ lakaet e seier nevez. ");
INSERT INTO breBRG_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","C'hoarvezout a reas, evel ma tremene Jezuz dre barkeier ed un deiz sabad, penaos e ziskibien, en ur vale, en em lakaas da ziframmañ tañvouezennoù. ");
INSERT INTO breBRG_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ar farizianed a lavaras dezhañ: Sell, perak e reont ar pezh n'eo ket aotreet ober deizioù ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eñ a lavaras dezho: N'hoc'h eus ket biskoazh lennet ar pezh a reas David, p'en devoa ezhomm, ha p'en devoa naon, eñ hag ar re a oa gantañ? ");
INSERT INTO breBRG_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Penaos ez eas e ti Doue, e amzer Abiazar, beleg-meur, hag e tebras baraoù a ginnig, evit ne oa nemet ar veleien a dlee o debriñ, hag e roas lod ivez d'ar re a oa gantañ? ");
INSERT INTO breBRG_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Neuze e lavaras dezho: Ar sabad a zo bet graet evit an den, neket an den evit ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dre-se Mab an den a zo mestr memes war ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jezuz a yeas ur wech all er sinagogenn, hag e oa eno un den en devoa un dorn disec'het. ");
INSERT INTO breBRG_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hag ec'h eveshaent outañ da welout hag eñ a yac'hafe anezhañ, deiz ar sabad, evit e damall. ");
INSERT INTO breBRG_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Neuze e lavaras d'an den en devoa an dorn disec'het: En em zalc'h aze er c'hreiz. ");
INSERT INTO breBRG_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hag e lavaras dezho: Hag aotreet eo ober vad pe droug, e deizioù ar sabad, saveteiñ un den pe e lezel da goll? Hag int a davas. ");
INSERT INTO breBRG_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Neuze, o sellout outo gant fae, hag o vezañ glac'haret eus kaleter o c'halon, e lavaras d'an den-se: Astenn da zorn. Hag ec'h astennas anezhañ, hag e teuas yac'h evel egile. ");
INSERT INTO breBRG_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ar farizianed, o vezañ aet er-maez, a zalc'has raktal kuzul gant an herodianed a-enep dezhañ, evit e lakaat da vervel. ");
INSERT INTO breBRG_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Neuze Jezuz en em dennas gant e ziskibien war-zu ar mor, hag ul lod bras a dud a heulie anezhañ eus Galilea, eus Judea, ");
INSERT INTO breBRG_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","eus Jeruzalem, eus Idumea, hag eus an tu all d'ar Jordan. Hag ar re a oa diwar-dro Tir ha Sidon, o vezañ klevet komz eus an traoù bras a reas, a zeuas e niver bras war-zu ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eñ a lavaras d'e ziskibien derc'hel prest ur vag dezhañ, abalamour d'ar bobl vras-se, gant aon na vije re wasket ganto. ");
INSERT INTO breBRG_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Rak kalz anezho en devoa yac'haet, en hevelep doare ma en em daole warnañ, evit stekiñ outañ, kement en devoa ur c'hleñved. ");
INSERT INTO breBRG_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ha pa wele an speredoù hudur anezhañ, e taoulinent dirazañ hag e krient: Te eo Mab Doue! ");
INSERT INTO breBRG_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Met eñ a c'hourc'hemenne start dezho na zisklêrjent ket anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pignat a reas neuze war ur menez, hag e c'halvas ar re a felle dezhañ, hag e teujont d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hag e lakaas daouzek anezho, da vezañ gantañ, evit o c'has da brezeg, ");
INSERT INTO breBRG_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","hag evit kaout ar galloud da yac'haat ar re glañv ha da gas kuit an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bez' e oant: Simon, ma roas an anv a Bêr dezhañ; ");
INSERT INTO breBRG_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakez mab Zebedea, ha Yann breur Jakez, ma roas an anv a Voanergez dezho, da lavarout eo, mibien ar c'hurun; ");
INSERT INTO breBRG_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrev, Filip, Bartolome, Mazhev, Tomaz, Jakez mab Alfe, Tadde, Simon ar C'hananeat, ");
INSERT INTO breBRG_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ha Judaz Iskariod, a oa an hini en gwerzhas. Neuze e tistrojont d'an ti; ");
INSERT INTO breBRG_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ar bobl en em zastumas a-nevez eno, en hevelep doare ma ne c'hellent ket memes kemer o fred. ");
INSERT INTO breBRG_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","E gerent, o vezañ klevet kement-se, a yeas evit e gemer, rak lavarout a raent: Diskiantet eo. ");
INSERT INTO breBRG_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hag ar skribed, a oa diskennet eus Jeruzalem, a lavare: Trec'het eo gant Beelzebul; kas a ra kuit an diaoulien dre briñs an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Met Jezuz, o vezañ o galvet, a lavaras dezho dre barabolennoù: Penaos e c'hell Satan kas Satan kuit? ");
INSERT INTO breBRG_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mar bez ur rouantelezh a-enep dezhi hec'h-unan, ne c'hell ket ar rouantelezh-se padout; ");
INSERT INTO breBRG_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ha mar bez un ti a-enep dezhañ e-unan, ne c'hell ket an ti-se padout; ");
INSERT INTO breBRG_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","evel-se, mar sav Satan a-enep dezhañ e-unan ha mar deo dizunvan, ne c'hell ket padout, met e ziwezh eo. ");
INSERT INTO breBRG_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Den ne c'hell mont e ti un den kreñv ha preizhañ e vadoù, nemet en defe da gentañ ereet an den kreñv-se; neuze e preizho e di. ");
INSERT INTO breBRG_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Me a lavar deoc'h e gwirionez, penaos pep pec'hed a vo pardonet da vugale an dud, kenkoulz hag ar gwallgomzoù m'o devo touet drezo; ");
INSERT INTO breBRG_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","met piv bennak en devo gwallgomzet a-enep ar Spered-Santel, n'en devo biken a bardon; met dalc'het e vo dindan ar varn peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jezuz a gomze evel-se, abalamour ma lavarent: Dalc'het eo gant ur spered hudur. ");
INSERT INTO breBRG_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E vreudeur hag e vamm a erruas eta, hag oc'h en em zerc'hel er-maez, e kasjont d'e c'hervel; ");
INSERT INTO breBRG_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ar bobl a oa azezet en-dro dezhañ, hag e voe lavaret dezhañ: Setu, da vamm ha da vreudeur a zo er-maez aze o c'houlenn ac'hanout. ");
INSERT INTO breBRG_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Met eñ a respontas: Piv eo va mamm, piv eo va breudeur? ");
INSERT INTO breBRG_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hag o teurel e zaoulagad war ar re a oa en-dro dezhañ, e lavaras: Setu va mamm ha va breudeur. ");
INSERT INTO breBRG_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Rak piv bennak a ra bolontez Doue, hennezh eo va breur ha va c'hoar ha va mamm. ");
INSERT INTO breBRG_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jezuz en em lakaas c'hoazh da gelenn, e-tal ar mor, hag ur bobl vras o vezañ en em zastumet en e gichen, e pignas en ur vag hag ec'h azezas enni, hag an holl bobl a oa war an douar e-tal ar mor. ");
INSERT INTO breBRG_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Deskiñ a rae dezho kalz a draoù, dre barabolennoù, hag e lavare dezho en e gelennadurezh: ");
INSERT INTO breBRG_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Selaouit. Setu, un hader a yeas er-maez da hadañ; ");
INSERT INTO breBRG_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","hag evel ma hade, ul lodenn eus an had a gouezhas a-hed an hent, hag al laboused a zeuas hag he debras holl. ");
INSERT INTO breBRG_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ul lodenn all a gouezhas war ul lec'h meinek, e-lec'h ma oa nebeut a zouar; ha kerkent e savas, abalamour ne oa ket aet don en douar; ");
INSERT INTO breBRG_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","met pa zeuas an heol, e voe devet, ha dre ma ne oa ket a wrizienn, e sec'has. ");
INSERT INTO breBRG_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ul lodenn all a gouezhas e-touez ar spern; hag ar spern a greskas hag he mougas, ha ne roas ket a frouezh. ");
INSERT INTO breBRG_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ul lodenn all a gouezhas en douar mat hag e roas frouezh, o sevel hag o kreskiñ, en hevelep doare ma roas ur c'hreunenn tregont, unan all tri-ugent, hag unan all kant. ");
INSERT INTO breBRG_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hag e lavaras dezho: ra selaouo, an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Met, pa voe e-unan, ar re a oa en-dro dezhañ, gant an daouzek, a c'houlennas digantañ diwar-benn ar barabolenn-se. ");
INSERT INTO breBRG_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Eñ a lavaras dezho: Roet eo deoc'h-hu da anavezout traoù kuzhet rouantelezh Doue; met evit ar re a-ziavaez, pep tra a zo lavaret dre barabolennoù, ");
INSERT INTO breBRG_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","evit o welout, e welont ha n'anavezont ket, hag o klevout, e klevont ha ne gomprenont ket, en aon na zistrofent, ha na vefe pardonet dezho o fec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hag e lavaras dezho: Ha ne gomprenit ket ar barabolenn-se? Ha penaos e komprenot ar re all? ");
INSERT INTO breBRG_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","An hader a had ger Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ar re a zo a-hed an hent, eo ar re ma'z eo hadet ar ger ennañ, met raktal m'o deus e glevet, e teu Satan hag a zilam ar ger a oa bet hadet en o c'halonoù; ");
INSERT INTO breBRG_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ar re a zegemer an had el lec'hioù meinek, eo ar re a glev ar ger, hag e zegemer da gentañ gant joa; ");
INSERT INTO breBRG_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","met n'o deus ket a wrizienn enno oc'h-unan, ha ne badont nemet ur pennad; dre-se, pa zeu ar glac'har pe an heskinerezh abalamour d'ar ger, e kavont kerkent skouer fall. ");
INSERT INTO breBRG_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hag ar re a zegemer an had e-touez an drein, eo ar re a selaou ar ger; ");
INSERT INTO breBRG_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","met prederioù ar bed-mañ, ha tromplerezh ar pinvidigezhioù hag an holl c'hoantoù evit an traoù all o tont, a voug ar ger, hag e laka difrouezh. ");
INSERT INTO breBRG_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Met ar re o deus degemeret an had en un douar mat, eo ar re a selaou ar ger, en degemer, hag a zoug frouezh, ur c'hreunenn tregont, unan all tri-ugent, hag unan all kant. ");
INSERT INTO breBRG_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lavarout a reas dezho c'hoazh: Degas a reer ur c'houlaouenn evit he lakaat dindan ar boezell, pe dindan ar gwele? N'eo ket evit he lakaat war ur c'hantolor? ");
INSERT INTO breBRG_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Rak n'eus netra kuzhet na zle bezañ disklêriet, ha n'eus netra goloet na vo gwelet gant an holl. ");
INSERT INTO breBRG_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mar en deus unan bennak divskouarn da glevout, ra selaouo. ");
INSERT INTO breBRG_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Lavarout a reas dezho c'hoazh: Lakait evezh ouzh ar pezh a glevit. Muzuliet e vo deoc'h gant ar memes muzul ho po muzuliet d'ar re all, ha c'hoazh e vo roet ouzhpenn deoc'h-hu c'hwi a selaou. ");
INSERT INTO breBRG_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Rak roet e vo d'an neb en deus; met an hini n'en deus ket, e vo lamet digantañ memes ar pezh en deus. ");
INSERT INTO breBRG_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Lavarout a reas c'hoazh: Bez' emañ diwar-benn rouantelezh Doue evel ma taolfe un den had en douar; ");
INSERT INTO breBRG_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","pe e kousk, pe e sav, noz pe deiz, an had a ziwan hag a gresk hep ma oar penaos. ");
INSERT INTO breBRG_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Rak an douar a ro anezhañ e-unan, da gentañ ar geot, goude an dañvouezenn, hag ar c'hreunenn en dañvouezenn. ");
INSERT INTO breBRG_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ha pa vez darev ar frouezh, e lakaer raktal ar falz ennañ, dre ma'z eo prest an eost. ");
INSERT INTO breBRG_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Lavarout a reas c'hoazh: Ouzh petra e hañvalin rouantelezh Doue? Pe dre beseurt parabolenn he diskouezimp? ");
INSERT INTO breBRG_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Heñvel eo ouzh ur c'hreunenn sezo; pa he hader, ez eo ar bihanañ eus holl hadoù an douar; ");
INSERT INTO breBRG_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","met goude ma vez hadet, e sav hag e teu brasoc'h eget al louzoù all, hag e taol brankoù, en hevelep doare ma c'hell laboused an neñv chom dindan he skeud. ");
INSERT INTO breBRG_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Disklêriañ a reas dezho ger Doue dre galz a barabolennoù en doare-mañ, hervez ma c'hellent e glevout. ");
INSERT INTO breBRG_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ha ne gomze ket outo hep parabolenn; met a-du, e tisplege pep tra d'e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","En deiz-se, pa voe deuet an noz, e lavaras dezho: Tremenomp en tu all d'an dour. ");
INSERT INTO breBRG_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ha goude bezañ kaset kuit ar bobl, e tegasjont Jezuz er vag, evel ma oa enni; hag e oa ivez bagoù bihan all ouzh e ambroug. ");
INSERT INTO breBRG_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Neuze e savas un taol-avel bras, hag ar c'hoummoù-mor a yeas er vag, en hevelep doare ma leunie. ");
INSERT INTO breBRG_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eñ a oa e diadreñv ar vag, kousket war ur blueg; hag e tihunjont anezhañ o lavarout: Mestr, ha ne rez van ebet eus ma en em gollomp? ");
INSERT INTO breBRG_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eñ, o vezañ dihunet, a c'hourc'hemennas an avelioù, hag a lavaras d'ar mor: Tav, bez sioul. An avel a davas, hag e voe ur sioulder bras. ");
INSERT INTO breBRG_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Neuze e lavaras dezho: Perak hoc'h eus aon? Penaos n'hoc'h eus ket a feiz? ");
INSERT INTO breBRG_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hag o devoe un aon bras, hag e lavarent an eil d'egile: Met piv eo hemañ, ma sent memes an avel hag ar mor outañ? ");
INSERT INTO breBRG_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Erruout a rejont en tu all d'ar mor, e bro ar C'hadareniz. ");
INSERT INTO breBRG_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ha raktal, evel ma tiskennas Jezuz eus ar vag, un den dalc'het gant ur spered hudur a zeuas eus ar bezioù d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chom a rae er bezioù, ha den ne c'helle e zerc'hel ereet, na zoken gant chadennoù; ");
INSERT INTO breBRG_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","rak alies, o kaout an hern ouzh e dreid, hag o vezañ bet ereet gant chadennoù, en devoa torret ar chadennoù ha friket an hern; ha den ne c'helle e zoñvaat. ");
INSERT INTO breBRG_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chom a rae dalc'hmat, noz ha deiz, war ar menezioù hag er bezioù, o krial hag oc'h en em vloñsañ gant mein. ");
INSERT INTO breBRG_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","P'en devoe gwelet Jezuz a-bell, e teredas, e taoulinas dirazañ, ");
INSERT INTO breBRG_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","hag e lavaras, o krial a vouezh uhel: Petra a zo etre te ha me, Jezuz, Mab an Doue uhel-meurbet? Da bediñ a ran dre anv Doue, na boagn ket ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Rak Jezuz a lavare dezhañ: Spered hudur, kae eus an den-se. ");
INSERT INTO breBRG_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ha Jezuz a c'houlennas digantañ: Pe anv ac'h eus? Eñ a respontas: Va anv a zo Lejion; rak kalz omp. ");
INSERT INTO breBRG_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hag e pede start anezhañ na gasje ket anezho er-maez eus ar vro-se. ");
INSERT INTO breBRG_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bez' e oa eno, war ar menezioù, ur vandenn vras a voc'h o peuriñ. ");
INSERT INTO breBRG_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hag an holl diaoulien en pede, o lavarout: Kas ac'hanomp er moc'h-se, evit ma'z aimp enno. ");
INSERT INTO breBRG_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Raktal Jezuz o lezas da vont. Neuze ar speredoù hudur-mañ, o vezañ aet er-maez, a yeas er moc'h, hag ar vandenn voc'h en em daolas eus al lec'h uhel-se er mor, hag e oant beuzet er mor; bez' e oa anezho war-dro daou vil. ");
INSERT INTO breBRG_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ar re a vesae ar moc'h a dec'has kuit da lavarout kement-se e kêr ha war ar maez. An dud a zeuas da welout ar pezh a oa erruet; ");
INSERT INTO breBRG_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","dont a rejont da gavout Jezuz, hag e weljont an hini a oa bet dalc'het gant an diaoul, an hini a oa bet dalc'het gant al lejion, azezet, gwisket hag en e skiant vat; hag o devoe aon. ");
INSERT INTO breBRG_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ar re o devoa gwelet-se a lavaras dezho ar pezh a oa c'hoarvezet gant an hini a oa dalc'het gant an diaoul, ha gant ar moc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Neuze en em lakajont d'e bediñ da bellaat diouzh o bro. ");
INSERT INTO breBRG_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pa oa aet er vag, an hini a oa bet dalc'het gant an diaoul en pedas d'e lezel da vont gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Met Jezuz n'en lezas ket, hag a lavaras dezhañ: Kae da'z ti, etrezek da dud, ha lavar dezho an traoù bras en deus an Aotrou graet dit, ha penaos en deus bet truez ouzhit. ");
INSERT INTO breBRG_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eñ a yeas kuit, hag en em lakaas da embann e Dekapoliz an traoù bras en devoa Jezuz graet dezhañ, hag e oant holl souezhet bras. ");
INSERT INTO breBRG_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jezuz o vezañ, dre ar vag, tremenet en tu all, ul lod bras a bobl en em zastumas en-dro dezhañ; tost d'ar mor e oa. ");
INSERT INTO breBRG_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Unan a vestroù ar sinagogenn, anvet Jairuz, a zeuas, hag o vezañ e welet, en em daolas d'e dreid, ");
INSERT INTO breBRG_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","hag e pedas start anezhañ, o lavarout: Va merc'h vihan a zo ar marv ganti; deus da lakaat da zaouarn warni, evit ma vo yac'haet, hag e vevo. ");
INSERT INTO breBRG_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ha Jezuz a yeas gantañ; ur bobl vras a yeas war e lerc'h, hag a waske anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bez' e oa ur wreg klañv, daouzek vloaz a oa, gant an diwadañ; ");
INSERT INTO breBRG_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","gouzañvet he devoa kalz a boan etre daouarn ar vedisined, ha dispignet he devoa he holl vadoù hep bezañ bet diboan ebet, met aet e oa kentoc'h war gwashaat; ");
INSERT INTO breBRG_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","o vezañ klevet komz eus Jezuz, e teuas e-touez ar vandenn dre ziadreñv, hag e stokas ouzh e zilhad. ");
INSERT INTO breBRG_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Rak hi a lavare: Mar gellan hepken stekiñ ouzh e zilhad, e vin yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Raktal he diwadañ a baouezas, hag e santas, en he c'horf, e oa yac'haet eus he foan. ");
INSERT INTO breBRG_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kerkent, Jezuz, oc'h anavezout ennañ e-unan ar galloud a oa aet er-maez anezhañ, en em droas e-kreiz ar bobl, o lavarout: Piv en deus stoket ouzh va dilhad? ");
INSERT INTO breBRG_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E ziskibien a lavaras dezhañ: Te a wel e wask ar bobl ac'hanout hag e lavarez: Piv en deus stoket ouzhin? ");
INSERT INTO breBRG_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hag e selle en-dro, evit gwelout piv en devoa graet-se. ");
INSERT INTO breBRG_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Neuze ar wreg, spontet hag en ur grenañ, o c'houzout ar pezh a oa bet graet enni, a zeuas hag en em daolas d'e dreid, hag e lavaras dezhañ an holl wirionez. ");
INSERT INTO breBRG_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jezuz a lavaras dezhi: Va merc'h, da feiz he deus da yac'haet; kae e peoc'h, ha bez dizereet eus da gleñved. ");
INSERT INTO breBRG_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Evel ma komze c'hoazh, tud penn ar sinagogenn a zeuas da lavarout dezhañ: Da verc'h a zo marv; na ro ket ken muioc'h a boan d'ar Mestr. ");
INSERT INTO breBRG_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kerkent, evel ma klevas Jezuz kement-se, e lavaras da benn ar sinagogenn: Na'z pez ket aon, kred hepken. ");
INSERT INTO breBRG_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ha ne lezas den da heuliañ anezhañ, nemet Pêr, Jakez, ha Yann, breur Jakez. ");
INSERT INTO breBRG_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","O vezañ erruet e ti penn ar sinagogenn, e welas e raed ennañ un drouz vras, ha tud a ouele, hag a laoske kriadennoù kreñv. ");
INSERT INTO breBRG_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hag o vezañ aet e-barzh, e lavaras dezho: Perak e rit an drouz-se, ha perak e ouelit? Ar bugel n'eo ket marv, met kousket a ra. ");
INSERT INTO breBRG_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hag int a rae goap outañ; met eñ, o vezañ graet dezho holl mont er-maez, a gemeras tad ha mamm ar bugel, hag ar re a oa gantañ, hag ez eas el lec'h ma oa gourvezet. ");
INSERT INTO breBRG_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O kemer he dorn, e lavaras dezhi: Talitha koumi, da lavarout eo: Plac'h yaouank, me a lavar dit, sav. ");
INSERT INTO breBRG_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kerkent ar plac'h yaouank a savas hag en em lakaas da vale, rak oadet e oa a zaouzek vloaz; hag e oant souezhet meurbet. ");
INSERT INTO breBRG_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Neuze e c'hourc'hemennas start dezho na lavarjent kement-se da zen, hag e lavaras reiñ da zebriñ d'ar plac'h yaouank. ");
INSERT INTO breBRG_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jezuz, o vezañ aet ac'hano, a zeuas en e vro, hag e ziskibien a heulias anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pa zeuas ar sabad, en em lakaas de gelenn er sinagogenn; kalz eus ar re en kleve, a oa souezhet hag a lavare: A belec'h e teu an traoù-se d'an den-mañ? Petra eo ar furnez-se a zo bet roet dezhañ, hag ar mirakloù bras en em ra dre e zaouarn? ");
INSERT INTO breBRG_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ha n'eo ket eñ ar c'halvez, mab Mari, breur Jakez, Jozez, Jud ha Simon? E c'hoarezed, ha n'emaint ket amañ en hon touez? Hag e kavent tamall ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Met Jezuz a lavaras dezho: Ur profed n'eo disprizet nemet en e vro, e-touez e gerent hag ar re eus e di e-unan. ");
INSERT INTO breBRG_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne c'hellas ober eno mirakl ebet, nemet e yac'haas un nebeud tud klañv, en ur lakaat e zaouarn warno. ");
INSERT INTO breBRG_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Souezhet e oa eus o diskredoni; hag e valeas ar bourc'hioù war-dro en ur gelenn. ");
INSERT INTO breBRG_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Neuze e c'halvas an daouzek, hag en em lakaas d'o c'has daou ha daou, en ur reiñ dezho ar galloud war ar speredoù hudur; ");
INSERT INTO breBRG_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","hag e c'hourc'hemennas dezho na gemerjent netra evit an hent, nemet ur vazh, na sac'h, na bara, na moneiz er c'houriz, ");
INSERT INTO breBRG_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","met sandalennoù en o zreid, ha na zougjent ket daou wiskamant. ");
INSERT INTO breBRG_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Lavarout a reas ivez dezho: En ti bennak ma'z it, chomit eno betek ma'z eot kuit eus al lec'h-se. ");
INSERT INTO breBRG_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ha pa en em gavo tud n'ho tegemerint ket, ha n'ho selaouint ket, en ur vont ac'hano, hejit ar poultr eus ho treid e testeni a-enep dezho. Me a lavar deoc'h, e gwirionez, penaos e vo dousoc'h da Sodom ha da C'homora e deiz ar varn, eget d'ar gêr-se. ");
INSERT INTO breBRG_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","O vezañ aet eta, e prezegjont d'an dud kaout keuz. ");
INSERT INTO breBRG_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kas a rejont kuit kalz a ziaoulien, hag ec'h eouljont gant eoul kalz a dud glañv, hag e yac'hajont anezho. ");
INSERT INTO breBRG_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ar roue Herodez a glevas komz eus Jezuz, rak e anv a oa dija brudet bras; hag e lavaras: Ar Yann-se, an hini a vadeze, a zo adsavet a-douez ar re varv; setu perak en em ra kalz a virakloù drezañ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Re all a lavare: Elia eo; ha re all: Ur profed eo, pe evel unan eus ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodez eta, o klevout kement-se, a lavaras: Yann eo, an hini am eus graet dibennañ; adsavet eo a varv. ");
INSERT INTO breBRG_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Rak Herodez en devoa kaset da gemer Yann, hag en devoa graet e eren er prizon, abalamour da Herodiaz, gwreg Filip e vreur, dre m'en devoa he dimezet. ");
INSERT INTO breBRG_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ha Yann a lavare da Herodez: N'eo ket grataet dit kaout gwreg da vreur. ");
INSERT INTO breBRG_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Dre-se, Herodiaz he devoa droug outañ, hag e c'hoantae e lakaat d'ar marv; met ne c'helle ket, ");
INSERT INTO breBRG_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","rak Herodez a zouje Yann, oc'h anavezout penaos e oa un den reizh ha santel; prederius e oa en e geñver; ober a rae memes kalz a draoù eus e alioù, hag en selaoue gant plijadur. ");
INSERT INTO breBRG_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Met un devezh mat a zeuas. Herodez, dre ma oa deiz e c'hanedigezh, a roas ur fest da re vras e lez, da vistri e arme, ha da re vras Galilea. ");
INSERT INTO breBRG_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Merc'h Herodiaz, o vezañ deuet, o vezañ dañset, hag o vezañ plijet da Herodez ha d'ar re en devoa pedet, ar roue a lavaras d'ar plac'h yaouank: Goulenn diganin ar pezh a gari hag en roin dit. ");
INSERT INTO breBRG_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ha gant le e lavaras: Kement a c'houlenni a roin dit, betek an hanter eus va rouantelezh. ");
INSERT INTO breBRG_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","O vezañ aet er-maez, hi a lavaras d'he mamm: Petra a c'houlennin? Hag he mamm a lavaras dezhi: Penn Yann-Vadezour. ");
INSERT INTO breBRG_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hag o vezañ deuet buan da gavout ar roue, e reas he goulenn, hag e lavaras: C'hoantaat a ran e rofes din, war ur plad, raktal, penn Yann-Vadezour. ");
INSERT INTO breBRG_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ar roue a voe glac'haret bras; koulskoude, abalamour d'e le ha d'ar re a oa azezet gantañ, ne fellas ket dezhañ nac'hañ outi. ");
INSERT INTO breBRG_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hag e kasas raktal unan eus e warded, hag e c'hourc'hemennas dezhañ degas penn Yann. Ar gward a yeas hag a droc'has e benn er prizon, ");
INSERT INTO breBRG_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hag e zegasas war ur plad, e reiñ a reas d'ar plac'h yaouank, hag ar plac'h yaouank e roas d'he mamm. ");
INSERT INTO breBRG_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Diskibien Yann o vezañ klevet kement-se, a zeuas hag a gemeras e gorf, hag e lakajont anezhañ en ur bez. ");
INSERT INTO breBRG_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","An ebestel a zeuas da gavout Jezuz, hag a lavarjont dezhañ kement o devoa graet, ha kement o devoa kelennet. ");
INSERT INTO breBRG_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Eñ a lavaras dezho: Deuit a-du, en ul lec'h distro, ha diskuizhit un nebeud; rak kement a dud a yae hag a zeue ken n'o devoe ket amzer memes da zebriñ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mont a rejont eta en ur vag, a-du en ul lec'h distro. ");
INSERT INTO breBRG_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Met ar bobl a welas anezho o vont kuit, ha kalz en anavezas; hag o redek, war droad, eus an holl gêrioù, ec'h errujont a-raok dezho, hag en em zastumjont en e gichen. ");
INSERT INTO breBRG_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Neuze Jezuz, o vezañ aet, a welas ul lod bras a dud, hag en devoe truez outo, abalamour ma oant evel deñved hep pastor, hag en em lakaas da zeskiñ dezho meur a dra. ");
INSERT INTO breBRG_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Evel ma oa dija diwezhat, e ziskibien a dostaas outañ hag a lavaras: Al lec'h-mañ a zo distro, ha diwezhat eo; ");
INSERT INTO breBRG_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","kas anezho kuit, evit ma'z aint er c'hêrioùigoù hag er bourc'hioù war-dro, ha ma prenint boued, rak n'o deus netra da zebriñ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eñ a lavaras dezho: Roit hoc'h-unan da zebriñ dezho. Hag e respontjont dezhañ: Mont a rafemp da brenañ evit daou c'hant diner a vara, evit reiñ dezho da zebriñ? ");
INSERT INTO breBRG_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hag e lavaras dezho: Pet bara hoc'h eus? It, ha sellit. P'o devoe gwelet, e lavarjont: Pemp ha daou besk. ");
INSERT INTO breBRG_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Neuze e c'hourc'hemennas dezho ober d'an holl azezañ, a vandennoù, war ar geot glas. ");
INSERT INTO breBRG_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hag ec'h azezjont a renkoù, dre gantadoù ha dre hanter-kantadoù. ");
INSERT INTO breBRG_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jezuz a gemeras ar pemp bara hag an daou besk, hag o sevel e zaoulagad etrezek an neñv, e rentas grasoù, e torras ar baraoù, hag e roas anezho d'e ziskibien, evit m'o rojent d'ar bobl; lodennañ a reas ivez an daou besk kenetrezo holl. ");
INSERT INTO breBRG_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Debriñ a rejont holl hag o devoa a-walc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hag e kasjont ganto daouzek panerad leun eus an nemorantoù bara hag eus ar pesked. ");
INSERT INTO breBRG_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ar re o devoa debret eus ar baraoù-se a oa war-dro pemp mil den. ");
INSERT INTO breBRG_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kerkent goude, e reas d'e ziskibien mont er vag, hag e ziaraogiñ en tu all, etrezek Betsaida, e-pad ma kasje kuit ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ha p'en devoe o c'haset kuit, e pignas war ar menez evit pediñ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","An abardaez o vezañ deuet, ar vag a oa e kreiz ar mor, hag eñ a oa e-unan war an douar. ");
INSERT INTO breBRG_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hag e welas o devoa kalz a boan o roeñvat, rak an avel a oa en o enep; war-dro ar bedervet beilhadenn eus an noz e teuas d'o c'havout, o vale war ar mor; c'hoant en devoa d'o diaraogiñ. ");
INSERT INTO breBRG_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Met pa weljont anezhañ, o vale war ar mor, e kredjont e oa un teuz, hag e krijont. ");
INSERT INTO breBRG_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Rak holl a weljont anezhañ, hag e voent spontet; met kerkent e komzas outo hag e lavaras dezho: Ho pet fiziañs, me eo, n'ho pet ket aon. ");
INSERT INTO breBRG_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hag e pignas d'o c'havout er vag, an avel a baouezas, hag e voent souezhet meurbet o-unan ha leuniet a estlamm, ");
INSERT INTO breBRG_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","rak n'o devoa ket komprenet mirakl ar baraoù, dre ma oa o c'halonoù kaledet. ");
INSERT INTO breBRG_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","P'o devoe treuzet ar mor, e teujont da vro C'henezared, hag e touarjont eno. ");
INSERT INTO breBRG_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pa oant aet er-maez ar vag, re al lec'h-se en anavezas raktal, ");
INSERT INTO breBRG_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","hag e redjont en holl vro tro-war-dro, hag en em lakajont da zougen war gweleoù bihan ar re a oa klañv, e kement lec'h ma klevent lavarout e oa. ");
INSERT INTO breBRG_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E pelec'h bennak ma'z ae, er bourc'hioù, pe er c'hêrioù, pe war ar maez, e lakaent an dud klañv war al leurgêrioù hag e pedent anezhañ d'o lezel da stekiñ, da vihanañ, ouzh bord e sae; hag an holl re a stoke outañ, a oa yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Neuze ar farizianed ha lod eus ar skribed, deuet eus Jeruzalem, a yeas da gavout Jezuz; ");
INSERT INTO breBRG_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","gwelout a rejont ur re bennak eus e ziskibien o kemer o fred gant daouarn lous, da lavarout eo, hep bezañ bet gwalc'het, hag e kavjont da damall. ");
INSERT INTO breBRG_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Rak ar farizianed hag an holl Yuzevien ne zebront ket hep gwalc'hiñ o daouarn betek an ilin, o terc'hel hengoun ar re gozh; ");
INSERT INTO breBRG_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ha pa zeuont eus ar marc'had, ne zebront ket kennebeut hep bezañ en em walc'het. Ha kalz a draoù all a zo ivez, o deus resevet evit o mirout, evel gwalc'hiñ an hanafoù, ar podoù, al listri-arem hag ar gweleoù.) ");
INSERT INTO breBRG_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","War gement-se ar farizianed hag ar skribed a c'houlennas outañ: A-belec'h e teu, ma ne heul ket da ziskibien-te hengoun ar re gozh, ha ma kemeront o fred hep bezañ gwalc'het o daouarn? ");
INSERT INTO breBRG_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Eñ a respontas dezho: Pilpouzed, Izaia en deus profedet mat diwar ho penn, p'en deus lavaret: Ar bobl-mañ a enor ac'hanon a vuzelloù, met o c'halonoù a zo gwall bell diouzhin. ");
INSERT INTO breBRG_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Met e ven eo ec'h enoront ac'hanon, o teskiñ kredennoù a zo gourc'hemennoù tud. ");
INSERT INTO breBRG_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Rak, o lezel gourc'hemenn Doue, e virit hengoun an dud, o walc'hiñ ar podoù hag an hanafoù, hag oc'h ober kalz a draoù all heñvel outo. ");
INSERT INTO breBRG_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lavarout a reas dezho c'hoazh: Gwall-vat e torrit gourc'hemenn Doue evit mirout an hengoun; ");
INSERT INTO breBRG_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","rak Moizez en deus lavaret: Enor da dad ha da vamm, ha: Piv bennak a villigo e dad pe e vamm a vo lakaet d'ar marv; ");
INSERT INTO breBRG_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","met c'hwi a lavar: An hini a lavaro d'e dad pe d'e vamm: Ar pezh am bije gallet reiñ dit a zo Korban, da lavarout eo ur prof da Zoue, ");
INSERT INTO breBRG_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ne lezit ket anezhañ d'ober netra ken evit e dad pe e vamm, ");
INSERT INTO breBRG_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","o kas da netra ger Doue gant ho hengoun hoc'h eus graet; ha kalz a draoù all a rit evel-se. ");
INSERT INTO breBRG_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Neuze, o vezañ galvet an holl bobl, e lavaras dezho: Selaouit holl ac'hanon, ha komprenit kement-mañ: ");
INSERT INTO breBRG_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Netra eus ar pezh a zo er-maez eus an den hag a ya ennañ, ne c'hell e huduraat; met ar pezh a zeu eus an den, ar re-se eo a hudura anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ra selaouo, an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pa voe aet en ti, goude bezañ kuitaet ar bobl, e ziskibien a c'houlennas outañ petra oa ar barabolenn-se. ");
INSERT INTO breBRG_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Eñ a lavaras dezho: Bez' oc'h ivez hep skiant? Ne gomprenit ket penaos netra eus ar pezh a ya eus er-maez an den, ne c'hell e lousaat? ");
INSERT INTO breBRG_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Rak an dra-se ne ya ket er galon, met er c'hof, a belec'h e kouezh el lec'h distro, ar pezh a c'hlana ar boued holl. ");
INSERT INTO breBRG_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lavarout a rae eta: Ar pezh a zeu eus an den, eo ar pezh a hudara anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Rak a-ziabarzh, eus kalon an dud eo, e teu ar soñjoù fall, an avoultriezhioù, ar gastaouerezhioù, al lazherezhioù, al laeroñsioù, ");
INSERT INTO breBRG_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","an avaristed, ar fallentezoù, ar faosoni, al loustoni, al lagad avius, an droukkomz, an ourgouilh, ar follentez. ");
INSERT INTO breBRG_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","An holl fallentezoù-se a zeu eus an diabarzh hag a hudara an den. ");
INSERT INTO breBRG_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hag, o vont ac'hano, ez eas da gostezioù Tir ha Sidon; o vezañ aet en un ti, e felle dezhañ na ouije den kement-se, met ne c'hellas ket chom kuzhet. ");
INSERT INTO breBRG_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Rak ur wreg, a oa trec'het he merc'h gant un spered hudur, o vezañ klevet komz dioutañ, a zeuas hag en em daolas d'e dreid. ");
INSERT INTO breBRG_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ar wreg-mañ a oa gresian, ha sirofenikian a bobl; hag e pedas anezhañ da gas an diaoul kuit eus he merc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jezuz a lavaras dezhi: Lez da gentañ ar vugale da gaout o gwalc'h; rak n'eo ket mat kemer bara ar vugale, hag e deurel d'ar chas bihan. ");
INSERT INTO breBRG_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Met hi a respontas hag a lavaras dezhañ: Gwir eo, Aotrou; koulskoude ar chas bihan a zebr, dindan an daol, bruzun ar vugale. ");
INSERT INTO breBRG_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Neuze eñ a lavaras dezhi: Abalamour d'ar gomz-se, kae, an diaoul a zo aet eus da verc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hag, o vezañ distroet d'he zi, e kavas an diaoul aet kuit, hag he merc'h gourvezet war ar gwele. ");
INSERT INTO breBRG_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jezuz, o vezañ kuitaet kostezioù Tir ha Sidon, a zeuas tost da vor Galilea, o treuziñ bro Dekapoliz. ");
INSERT INTO breBRG_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hag e voe degaset dezhañ un den bouzar ha mut, hag e voe pedet da lakaat e zaouarn warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","O vezañ e dennet eus ar bobl a-du, e lakaas e vizied en e zivskouarn; hag o vezañ kemeret eus e grañch, e stokas e deod, ");
INSERT INTO breBRG_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","hag, o sevel e zaoulagad etrezek an neñv, e huanadas hag e lavaras: Effata, da lavarout eo, digor-te. ");
INSERT INTO breBRG_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kerkent e zivskouarn a voe digoret, e deod a voe dizereet, hag e komze hep poan. ");
INSERT INTO breBRG_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jezuz a zifennas outo na lavarjent kement-se da zen; met mui e tifenne outo, seul vui e vrudent anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Souezhet meurbet e lavarent: Kement a ra a zo burzhudus; d'ar re vouzar e ra klevout, ha d'ar re vut komz. ");
INSERT INTO breBRG_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","En deizioù-se, e oa gant Jezuz un niver bras a dud, hag evel n'o devoa netra da zebriñ, e c'halvas e ziskibien hag e lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Truez am eus ouzh ar bobl-mañ; rak tri deiz a zo bremañ ne'm c'huitaont ket, ha n'o deus netra da zebriñ. ");
INSERT INTO breBRG_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ha mar kasan anezho war yun d'o ziez, o nerzh o dilezo en hent, rak darn anezho a zo deuet a-bell. ");
INSERT INTO breBRG_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","E ziskibien a respontas dezhañ: A belec'h e vefe kavet bara a-walc'h da bredañ anezho el lec'h distro-mañ. ");
INSERT INTO breBRG_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eñ a c'houlennas outo: Pet bara hoc'h eus? Hag int a lavaras: Seizh. ");
INSERT INTO breBRG_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Neuze e reas d'ar bobl azezañ war an douar; hag o vezañ kemeret ar seizh bara, ha trugarekaet, e torras anezho hag o roas d'e ziskibien; an diskibien o lodennas d'ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bez' e oa ivez peskedigoù; ha Jezuz, o vezañ trugarekaet, a c'hourc'hemennas o reiñ ivez dezho. ");
INSERT INTO breBRG_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hag e tebrjont, hag o devoe a-walc'h, hag e tegasjont seizh panerad leun eus an tammoù a oa manet. ");
INSERT INTO breBRG_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ar re o devoa debret a oa war-dro pevar mil; goude-se o c'hasas kuit. ");
INSERT INTO breBRG_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hag, o vont kerkent en ur vag gant e ziskibien, ez eas e kostezioù Dalmanuta. ");
INSERT INTO breBRG_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Eno e teuas ar farizianed, hag en em lakajont da riotal anezhañ, o c'houlenn outañ, evit e demptañ, ur mirakl eus an neñv. ");
INSERT INTO breBRG_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jezuz, o huanadiñ en e spered, a lavaras: Perak e c'houlenn ar rummad-mañ ur mirakl? Me a lavar deoc'h e gwirionez, ne vo roet hini ebet dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hag o vezañ o c'huitaet, ez eas er vag, hag e tremenas en tu all. ");
INSERT INTO breBRG_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Met ankounac'haet o devoa kemer bara ganto, ha n'o devoa nemet ur bara er vag. ");
INSERT INTO breBRG_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eñ a reas outo an difenn-mañ: En em virit gant evezh eus goell ar farizianed, hag eus goell Herodez. ");
INSERT INTO breBRG_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Int a soñje etrezo, o lavarout: Abalamour n'hon eus ket a vara eo. ");
INSERT INTO breBRG_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jezuz, o vezañ anavezet kement-se, a lavaras dezho: Perak e soñjit ez eo abalamour n'hoc'h eus ket kemeret a vara? Bez' oc'h c'hoazh hep skiant? Ha ne gomprenit ket c'hoazh? Bepred eo dall ho kalon? ");
INSERT INTO breBRG_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","O kaout daoulagad, ne welit ket? O kaout divskouarn, ne glevit ket? Ha n'hoc'h eus ket a soñj? ");
INSERT INTO breBRG_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pa dorris pemp bara evit pemp mil den, pet panerad leun a dammoù chomet a zilerc'h ho poa dastumet? Int a lavaras dezhañ: Daouzek. ");
INSERT INTO breBRG_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ha pa dorris ar seizh bara evit ar pevar mil den, pet panerad leun a dammoù ho poa dastumet? Int a lavaras dezhañ: Seizh. ");
INSERT INTO breBRG_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hag e lavaras dezho: Penaos eta ne gomprenit ket? ");
INSERT INTO breBRG_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jezuz o vezañ deuet da Vetsaida, e voe degaset dezhañ un den dall, hag en pedjont da stekiñ outañ. ");
INSERT INTO breBRG_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Neuze e kemeras dorn an dall, hag o vezañ e gaset er-maez eus ar bourc'h, e lakaas krañch war e zaoulagad, hag o vezañ lakaet e zaouarn warnañ, e c'houlennas outañ hag eñ a wele un dra bennak. ");
INSERT INTO breBRG_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eñ, o vezañ sellet, a lavaras: Gwelout a ran tud o vale hag a zo evel gwez. ");
INSERT INTO breBRG_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jezuz a lakaas adarre e zaouarn war e zaoulagad, hag a lavaras dezhañ sellout: hag e oa yac'haet, hag o gwele holl fraezh mat. ");
INSERT INTO breBRG_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hag e kasas anezhañ d'e di, o lavarout dezhañ: N'a ket er bourc'h, ha na lavar ket an dra-mañ da zen eus ar bourc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jezuz a yeas, gant e ziskibien, e bourc'hioù Kezarea-Filip; ha, war an hent, e c'houlennas ouzh e ziskibien: Piv a lavar an dud on-me? ");
INSERT INTO breBRG_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Respont a rejont: Darn a lavar out Yann-Vadezour; darn all, Elia; ha darn all, unan ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eñ a lavaras dezho: Ha c'hwi, piv a lavarit ez on-me? Pêr a respontas dezhañ: Te eo ar C'hrist. ");
INSERT INTO breBRG_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hag e tifennas gwall start outo lavarout kement-se anezhañ da zen. ");
INSERT INTO breBRG_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Neuze en em lakaas da zisklêriañ dezho e oa ret da Vab an den gouzañv kalz a draoù, ha bezañ taolet kuit gant an henaourien, gant ar veleien vras, ha gant ar skribed, bezañ lakaet d'ar marv, hag adsevel a varv tri deiz goude. ");
INSERT INTO breBRG_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hag e lavare ar c'homzoù-se dezho sklaer-mat. Neuze Pêr, o vezañ e gemeret a-du, en em lakaas d'e repren. ");
INSERT INTO breBRG_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Met Jezuz, o tistreiñ hag o sellout ouzh e ziskibien, a c'hourdrouzas Pêr hag a lavaras dezhañ: A-dreñv din, Satan! Rak da soñjoù n'emaint ket en traoù a sell ouzh Doue, met er re a sell ouzh an dud. ");
INSERT INTO breBRG_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hag o c'hervel ar bobl gant e ziskibien, e lavaras dezho: Mar fell da unan bennak dont war va lerc'h, ra raio dilez anezhañ e-unan, ra gemero e groaz, ha ra heulio ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Rak piv bennak a fello dezhañ saveteiñ e vuhez, he c'hollo; met piv bennak a gollo e vuhez abalamour din ha d'an Aviel, he saveteo. ");
INSERT INTO breBRG_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Rak petra a dalvfe d'un den gounit ar bed holl, ma kollfe e ene? ");
INSERT INTO breBRG_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pe petra a rofe an den e trok ouzh e ene? ");
INSERT INTO breBRG_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Rak piv bennak en devo bet mezh ac'hanon hag eus va c'homzoù, e-touez ar rummad avoultr ha pec'her-mañ, Mab an den ivez en devo mezh anezhañ, pa zeuio e gloar e Dad gant an aelez santel. ");
INSERT INTO breBRG_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lavarout a reas dezho ivez: Me a lavar deoc'h e gwirionez, ez eus hiniennoù eus a-douez ar re a zo amañ, ha ne varvint ket, ken n'o devo gwelet rouantelezh Doue o tont gant galloud. ");
INSERT INTO breBRG_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","C'hwec'h devezh goude, Jezuz a gemeras gantañ Pêr, Jakez ha Yann, hag o c'hasas o-unan a-du war ur menez uhel; hag e voe treuzneuziet dirazo. ");
INSERT INTO breBRG_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E zilhad a zeuas da vezañ lugernus, gwenn evel an erc'h, ha kaer skedus ken n'eus kouez ebet war an douar a c'hellfe gwennañ evel-se. ");
INSERT INTO breBRG_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ha Moizez hag Elia en em ziskouezas dezho, o komz gant Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Neuze Pêr, o kemer ar gomz, a lavaras da Jezuz: Mestr, mat eo deomp chom amañ; greomp amañ teir deltenn, unan evidout, unan evit Moizez, hag unan evit Elia. ");
INSERT INTO breBRG_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Rak ne ouie ket petra a lavare, abalamour ma oa spontet. ");
INSERT INTO breBRG_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hag e teuas ur goabrenn a c'holoas anezho; ur vouezh a zeuas eus ar goabrenn, hag a lavaras: Hemañ eo va Mab karet-mat, selaouit eñ. ");
INSERT INTO breBRG_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kerkent an diskibien, o vezañ sellet en-dro dezho, ne weljont den ken nemet Jezuz e-unan ganto. ");
INSERT INTO breBRG_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Evel ma tiskennent eus ar menez, e tifennas outo lavarout da zen ar pezh o devoa gwelet, betek ma vije Mab an den adsavet a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hag e talc'hjont ar gomz-se, o c'houlenn an eil digant egile petra a c'hellje bezañ, adsevel a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hag e rejont ar goulenn-mañ outañ: Perak e lavar ar skribed eo ret da Elia dont da gentañ? ");
INSERT INTO breBRG_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Respont a reas dezho: Gwir eo Elia a dle dont da gentañ hag adlakaat pep tra; ha Mab an den, hervez ma'z eo skrivet diwar e benn, a dle gouzañv kalz a draoù, ha bezañ disprizet. ");
INSERT INTO breBRG_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Met me a lavar deoc'h penaos Elia a zo deuet, ha penaos o deus graet dezhañ kement o deus c'hoantaet, evel ma'z eo skrivet diwar e benn. ");
INSERT INTO breBRG_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","O vezañ deuet etrezek an diskibien all, e welas kalz a bobl en-dro dezho, ha skribed a stourme outo. ");
INSERT INTO breBRG_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Raktal evel ma welas an holl bobl-se anezhañ, e voent souezhet bras, hag o vezañ deredet e saludjont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Neuze eñ a c'houlennas ouzh ar skribed: diwar-benn petra e stourmec'h outo? ");
INSERT INTO breBRG_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hag un den eus ar bobl, o kemer ar gomz, a lavaras: Mestr, degaset em eus dit va mab hag a zo dalc'het gant ur spered mut, ");
INSERT INTO breBRG_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","e pelec'h bennak ma krog ennañ, e taol anezhañ d'an douar, e tispenn anezhañ, hag eñ a eon, a c'hrigoñs e zent, hag en em disec'h; hag em eus pedet da ziskibien d'e gas kuit, met n'o deus ket gallet. ");
INSERT INTO breBRG_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Neuze Jezuz a lavaras dezho: O rummad diskredik, betek pegeit e vin ganeoc'h? Betek pegeit e c'houzañvin ac'hanoc'h? Degasit eñ din. ");
INSERT INTO breBRG_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","E zegas a rejont eta dezhañ; ha raktal ma welas Jezuz, ar spered a zifretas anezhañ gant nerzh, hag e kouezhas d'an douar, hag en em ruilhe oc'h eoniñ. ");
INSERT INTO breBRG_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Neuze Jezuz a c'houlennas ouzh e dad: Pegeit amzer a zo abaoe ma c'hoarvez kement-mañ gantañ? Eñ a respontas: Abaoe e vugaleaj. ");
INSERT INTO breBRG_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hag ar spered en deus e daolet alies en tan hag en dour, evit e lakaat da vervel; met mar gellez un dra bennak, sikour ac'hanomp, hag az pez truez ouzhimp. ");
INSERT INTO breBRG_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jezuz a lavaras dezhañ: Mar gellez! ..., pep tra a c'hell c'hoarvezout evit an hini a gred. ");
INSERT INTO breBRG_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kerkent tad ar bugel a grias gant daeroù: Me a gred, Aotrou, va nerzh em diskredoni! ");
INSERT INTO breBRG_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ha Jezuz, o welout ar bobl o redek a vandenn, a c'hourdrouzas start ar spered hudur hag a lavaras dezhañ: Spered mut ha bouzar, me a c'hourc'hemenn dit, me, kae kuit eus ar bugel-se, ha na da ken ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ar spered a yeas kuit, o tifretañ anezhañ gant nerzh hag o leuskel ur griadenn vras; ar bugel a zeuas evel marv, en hevelep doare ma lavare meur a hini: Marv eo. ");
INSERT INTO breBRG_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Met Jezuz, o kemer e zorn, a reas dezhañ sevel; hag en em zalc'has en e sav. ");
INSERT INTO breBRG_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pa voe aet Jezuz en ti, e ziskibien a c'houlennas digantañ a-du: Perak n'hon eus ket gallet kas kuit an diaoul-se? ");
INSERT INTO breBRG_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eñ a respontas dezho: Ar seurt diaoulien-se ne c'hellont mont kuit nemet dre ar bedenn hag ar yun. ");
INSERT INTO breBRG_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hag, o vezañ aet ac'hano, e treuzjont Galilea; Jezuz ne felle ket dezhañ ec'h anavezje den kement-se. ");
INSERT INTO breBRG_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Rak e kelenne e ziskibien, hag e lavare dezho: Mab an den a vo lakaet etre daouarn an dud, hag e lakaint anezhañ d'ar marv; met goude ma vo bet lazhet, ec'h adsavo a varv an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Met ne gomprenent ket ar c'homzoù-se, ha ne gredent ket goulenn digantañ. ");
INSERT INTO breBRG_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Goude e teujont da Gafarnaoum; hag o vezañ en ti, e c'houlennas outo: Diwar-benn petra en em stourmec'h en hent? ");
INSERT INTO breBRG_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Int a dave; rak en em stourmet o devoa en hent war an hini a vije ar brasañ. ");
INSERT INTO breBRG_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","O vezañ azezet, e c'halvas an daouzek hag e lavaras dezho: Mar c'hoanta unan bennak bezañ ar c'hentañ, e vo an diwezhañ eus an holl, ha servijer an holl. ");
INSERT INTO breBRG_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hag o vezañ kemeret ur bugel bihan, e lakaas anezhañ en o c'hreiz; o terc'hel anezhañ etre e zivrec'h, e lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Piv bennak a zegemer unan eus ar vugale vihan-mañ abalamour da'm anv, a zegemer ac'hanon, ha piv bennak a zegemer ac'hanon, n'eo ket me eo a zegemer, met an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Neuze Yann, o kemer ar gomz, a lavaras dezhañ: Mestr, ni hon eus gwelet unan o kas kuit an diaoulien ez anv, hag hon eus difennet-se outañ, abalamour na heul ket ac'hanomp. ");
INSERT INTO breBRG_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Met Jezuz a lavaras: Na zifennit ket-se; rak n'eus den a rafe mirakloù em anv, hag a c'hellfe kerkent droukkomz ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Rak an hini n'emañ ket a-enep deomp, a zo evidomp. ");
INSERT INTO breBRG_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ha piv bennak a roio deoc'h ur werennad dour em anv, abalamour ma'z oc'h d'ar C'hrist, me a lavar deoc'h e gwirionez, ne gollo ket e c'hopr; ");
INSERT INTO breBRG_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","met piv bennak a roio skouer fall da unan eus ar re vihan-se a gred ennon, ez eo gwelloc'h dezhañ e vefe staget ur maen-milin ouzh e c'houzoug, ha e vefe taolet er mor. ");
INSERT INTO breBRG_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ma ra da zorn lakaat ac'hanout da gouezhañ, troc'h anezhañ; rak gwelloc'h eo dit mont er vuhez, o kaout nemet un dorn, eget kaout daou zorn ha bezañ taolet er gehenn, ");
INSERT INTO breBRG_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","en tan divougus, e pelec'h o freñv ne varv ket, hag an tan ne voug ket. ");
INSERT INTO breBRG_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ha ma ra da droad lakaat ac'hanout da gouezhañ, troc'h anezhañ; gwelloc'h eo dit mont er vuhez, o kaout un troad, eget kaout daou droad, ha bezañ taolet er gehenn, en tan divougus, ");
INSERT INTO breBRG_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","e pelec'h o freñv ne varv ket, hag an tan ne voug ket. ");
INSERT INTO breBRG_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ha ma ra da lagad lakaat ac'hanout da gouezhañ, diframm anezhañ; gwelloc'h eo dit mont e rouantelezh Doue gant ul lagad hepken, eget kaout daou lagad ha bezañ taolet e tan ar gehenn, ");
INSERT INTO breBRG_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","e pelec'h o freñv ne varv ket, hag an tan ne voug ket. ");
INSERT INTO breBRG_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Rak pep hini a vo sallet gant tan, ha pep prof a vo sallet gant holen; ");
INSERT INTO breBRG_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Un dra vat eo an holen, met mar koll e vlaz gant petra e vo e roet dezhañ? Ho pet holen ennoc'h hoc'h-unan, ha bezit e peoc'h etrezoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jezuz, o vont ac'hano, a zeuas e kostezioù Judea, en tu all d'ar Jordan; ar bobl en em zastumas adarre war e dro, hag eñ, evel ma oa e c'hiz, en em lakaas d'o c'helenn. ");
INSERT INTO breBRG_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Neuze ar farizianed a zeuas hag a c'houlennas outañ evit e demptañ: Hag e c'hell un den kas e wreg kuit? ");
INSERT INTO breBRG_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eñ a respontas hag a lavaras dezho: Petra en deus Moizez gourc'hemennet deoc'h? ");
INSERT INTO breBRG_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Int a lavaras: Moizez a lez reiñ ur skrid a dorr-dimeziñ hag he c'has kuit. ");
INSERT INTO breBRG_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Neuze Jezuz a respontas, hag a lavaras dezho: Skrivet en deus deoc'h al lezenn-se abalamour da galeter ho kalon. ");
INSERT INTO breBRG_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Met er penn-kentañ eus ar grouidigezh, Doue ne reas nemet ur gwaz hag ur plac'h. ");
INSERT INTO breBRG_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Setu perak ar gwaz a guitaio e dad hag e vamm, hag en em unano d'e wreg, ");
INSERT INTO breBRG_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hag e vint ur c'hig hepken; evel-se n'int mui daou, met ur c'hig hepken. ");
INSERT INTO breBRG_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ra ne zisranno ket eta an den, ar pezh en deus Doue unanet. ");
INSERT INTO breBRG_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hag an diskibien a c'houlennas c'hoazh digantañ diwar-benn-se e-barzh an ti; ");
INSERT INTO breBRG_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","eñ a lavaras dezho: Piv bennak a gas kuit e wreg hag a zimez da unan all, a ra avoultriezh en he c'heñver; ");
INSERT INTO breBRG_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","hag ar wreg a guita he gwaz hag a zimez da unan all, a ra avoultriezh. ");
INSERT INTO breBRG_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Neuze e voe degaset dezhañ bugale vihan, evit ma stokje outo; met an diskibien a c'hrozmole d'ar re o degase. ");
INSERT INTO breBRG_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ha Jezuz o welout-se, a yeas droug ennañ, hag a lavaras dezho: Lezit ar vugale vihan da zont da'm c'havout, ha na zifennit ket outo; rak rouantelezh Doue a zo d'an neb a zo heñvel outo. ");
INSERT INTO breBRG_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Me a lavar deoc'h e gwirionez, penaos piv bennak ne zegemero ket rouantelezh Doue evel ur bugel bihan, ne yelo ket e-barzh. ");
INSERT INTO breBRG_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hag o vezañ o c'hemeret etre e zivrec'h, e lakaas e zaouarn warno hag o bennigas. ");
INSERT INTO breBRG_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Evel ma oa evit en em lakaat en hent, un den a zeredas, hag, o vezañ daoulinet dirazañ, e c'houlennas digantañ: Mestr mat, petra a dlean d'ober evit kaout ar vuhez peurbadus? ");
INSERT INTO breBRG_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jezuz a lavaras dezhañ: Perak em galvez mat? N'eus hini mat nemet Doue hepken. ");
INSERT INTO breBRG_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Anavezout a rez ar gourc'hemennoù: Na lazh ket; Na ra ket avoultriezh; Na laer ket; Na lavar ket a desteni faos; Na ra ket a faosoni; Enor da dad ha da vamm. ");
INSERT INTO breBRG_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eñ a respontas: Mestr, miret em eus an holl draoù-se adalek va yaouankiz. ");
INSERT INTO breBRG_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ha Jezuz, o teurel e zaoulagad warnañ, e garas hag a lavaras dezhañ: Mankout a ra dit un dra: Kae, gwerzh kement ac'h eus, en ro d'ar beorien, hag ez po un teñzor en neñv; goude-se deus hag heul ac'hanon, o vezañ en em vec'hiet eus ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Glac'haret o klevout-se, ez eas kuit gwall drist, rak madoù bras en devoa. ");
INSERT INTO breBRG_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Neuze Jezuz, o sellout en-dro dezhañ, a lavaras d'e ziskibien: Pegen diaes eo d'ar re o deus madoù mont e-barzh rouantelezh Doue! ");
INSERT INTO breBRG_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","An diskibien a voe souezhet eus ar c'homzoù-se. Met Jezuz, oc'h adkemer ar gomz, a lavaras dezho: Va bugale, pegen diaes eo d'ar re a laka o fiziañs er madoù mont e rouantelezh Doue! ");
INSERT INTO breBRG_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aesoc'h eo d'ur c'hañval tremen dre graoenn un nadoz eget d'un den pinvidik mont e-barzh rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hag e voent c'hoazh muioc'h souezhet, hag e lavarent an eil d'egile: Ha piv eta a c'hell bezañ salvet? ");
INSERT INTO breBRG_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Met Jezuz o sellout outo, a lavaras: Dibosupl eo-se d'an dud, met n'eo ket da Zoue; rak Doue a c'hell pep tra. ");
INSERT INTO breBRG_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Neuze Pêr en em lakaas da lavarout dezhañ: Setu, ni hon eus dilezet pep tra, hag hon eus da heuliet. ");
INSERT INTO breBRG_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ha Jezuz a respontas: Me a lavar deoc'h e gwirionez: N'eus den en defe kuitaet, ti, pe vreudeur, pe c'hoarezed, pe dad, pe vamm, pe vugale, pe zouaroù, abalamour din ha d'an Aviel, ");
INSERT INTO breBRG_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ha ne resevo adalek ar c'hantved-mañ, kant kement all, a diez, a vreudeur, a c'hoarezed, a vammoù, a vugale, hag a zouaroù, gant heskinerezhioù, hag, er c'hantved da zont, ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Met kalz a zo ar re gentañ a vo ar re ziwezhañ, ha kalz a zo ar re ziwezhañ a vo ar re gentañ. ");
INSERT INTO breBRG_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bez' e oant en hent, o pignat da Jeruzalem, Jezuz a valee a-raok dezho; spouronet e oant hag o devoa aon o heuliañ anezhañ. Jezuz, o kemer adarre a-du an daouzek diskibl, en em lakaas da zisklêriañ dezho ar pezh a dlee c'hoarvezout gantañ: ");
INSERT INTO breBRG_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Setu, e pignomp da Jeruzalem, ha Mab an den a vo lakaet etre daouarn ar veleien vras ha re ar skribed, hag e kondaonint anezhañ d'ar marv, hag e lakaint anezhañ etre daouarn ar baganed. ");
INSERT INTO breBRG_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Goap a raint anezhañ, e skourjezañ a raint, hag e krañchint en e vizaj, hag e lakaint anezhañ d'ar marv; met ec'h adsavo a varv d'an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Neuze Jakez ha Yann, mibien Zebedea, a zeuas hag a lavaras dezhañ: Mestr, ni a garfe e rafes deomp ar pezh a c'houlennimp ouzhit. ");
INSERT INTO breBRG_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eñ a lavaras dezho: Petra a fell deoc'h e rafen evidoc'h? ");
INSERT INTO breBRG_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Int a lavaras dezhañ: Ro deomp da vezañ azezet e-barzh da c'hloar, unan a-zehou dit hag egile a-gleiz. ");
INSERT INTO breBRG_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jezuz a lavaras dezho: N'ouzoc'h ket ar pezh a c'houlennit. Ha gallout e c'hellit evañ an hanaf a dlean evañ, ha bezañ badezet eus ar vadeziant ma tlean bezañ badezet ganti? ");
INSERT INTO breBRG_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Int a lavaras dezhañ: Ni a c'hell. Ha Jezuz a lavaras dezho: Gwir eo ec'h evot an hanaf am eus da evañ, hag e viot badezet eus ar vadeziant am eus da vezañ badezet ganti; ");
INSERT INTO breBRG_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","met bezañ azezet a-zehou pe a-gleiz din, n'eo ket din da reiñ; roet e vo d'ar re ma'z eo bet-se kempennet evito. ");
INSERT INTO breBRG_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","An dek all o vezañ klevet kement-se, a yeas droug enno a-enep Jakez ha Yann. ");
INSERT INTO breBRG_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Met Jezuz, o vezañ o galvet, a lavaras dezho: Gouzout a rit penaos ar re a seller evel pennoù ar pobloù a vestroni anezho, ha penaos ar re vras a ziskouez o galloud warno. ");
INSERT INTO breBRG_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na vo ket evel-se en ho touez; met piv bennak a fello dezhañ bezañ bras en ho touez, a vo ho servijer. ");
INSERT INTO breBRG_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ha piv bennak a fello dezhañ bezañ ar c'hentañ en ho touez, a vo mevel an holl. ");
INSERT INTO breBRG_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Rak Mab an den n'eo ket deuet evit bezañ servijet, met evit servijañ hag evit reiñ e vuhez e daspren evit kalz. ");
INSERT INTO breBRG_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Goude e teujont da Jeriko; hag evel ma'z eas kuit ac'hano gant e ziskibien ha kalz a dud, mab Time, Bartime, an dall, a oa azezet war gostez an hent, o c'houlenn an aluzen. ");
INSERT INTO breBRG_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","O vezañ klevet e oa Jezuz a Nazared a dremene, en em lakaas da grial ha da lavarout: Jezuz, mab David, az pez truez ouzhin! ");
INSERT INTO breBRG_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kalz a c'hourdrouze anezhañ, evit ober dezhañ tevel; met eñ a grie c'hoazh kreñvoc'h: Mab David, az pez truez ouzhin! ");
INSERT INTO breBRG_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jezuz o chom en e sav, a lavaras e c'hervel. Gervel a rejont eta an dall, hag e lavarjont dezhañ: Sav, bez kalonek, da c'hervel a ra. ");
INSERT INTO breBRG_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O teurel e vantell, e savas hag e teuas da gavout Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Neuze Jezuz, o kemer ar gomz, a lavaras dezhañ: Petra a fell dit e rafen evidout? An dall a respontas: Mestr, ma kavin ar gweled. ");
INSERT INTO breBRG_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ha Jezuz a lavaras dezhañ: Kae, da feiz he deus da yac'haet. Ha kerkent e kavas ar gweled, hag e heulias Jezuz en hent. ");
INSERT INTO breBRG_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Evel ma tostaent ouzh Jeruzalem, ouzh Betfage, hag ouzh Betania, tost da Venez an Olived, Jezuz a gasas daou eus e ziskibien, ");
INSERT INTO breBRG_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","o lavarout dezho: It d'ar vourc'h a zo dirazoc'h; ha kerkent ha ma viot aet enni, e kavot un azen yaouank stag, ma n'eus bet c'hoazh pignet den warnañ; distagit eñ, ha degasit eñ din. ");
INSERT INTO breBRG_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mar lavar unan bennak deoc'h: Perak e rit an dra-se? Lavarit: An Aotrou en deus ezhomm anezhañ. Ha raktal en lezo da vont. ");
INSERT INTO breBRG_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mont a rejont eta, hag e kavjont an azen a oa stag en-diavaez dirak an nor, etre daou hent; hag e tistagjont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Unan bennak eus ar re a oa eno a lavaras dezho: Perak e tistagit an azenig-se? ");
INSERT INTO breBRG_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Int a respontas evel m'en devoa Jezuz gourc'hemennet dezho; hag e voent lezet da vont. ");
INSERT INTO breBRG_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Degas a rejont an azenig da Jezuz, e lakajont o dilhad warnañ, hag e rejont Jezuz azezañ warnañ. ");
INSERT INTO breBRG_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kalz a astenne o dilhad war an hent, ha re all a droc'he brankoù glas, hag a c'holoe ganto an hent. ");
INSERT INTO breBRG_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ar re a valee a-raok, hag ar re a heulie, a grie o lavarout: Hozanna! Benniget ra vo an hini a zeu en anv an Aotrou! ");
INSERT INTO breBRG_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Benniget ra vo ren David hon tad, ar ren a zeu en anv an Aotrou! Hozanna el lec'hioù uhel-meurbet! ");
INSERT INTO breBRG_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Evel-se Jezuz a yeas e Jeruzalem, hag en templ; hag o vezañ sellet ouzh pep tra, evel ma oa diwezhat, ez eas da Vetania gant an daouzek. ");
INSERT INTO breBRG_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","An deiz war-lerc'h, evel ma'z ae eus Betania, en devoe naon. ");
INSERT INTO breBRG_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O welout a-bell ur wezenn-fiez he devoa delioù, ez eas evit gwelout hag-eñ e kavje un dra bennak enni; hag o vezañ tostaet, ne gavas nemet delioù, rak ne oa ket mare ar fiez. ");
INSERT INTO breBRG_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Neuze Jezuz o kemer ar gomz a lavaras: Ra ne zebro biken den eus da frouezh. Hag e ziskibien a glevas kement-se. ");
INSERT INTO breBRG_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dont a rejont da Jeruzalem; Jezuz o vezañ aet en templ, en em lakaas da gas kuit ar re a werzhe hag a brene en templ, hag e tiskaras taolioù an drokerien arc'hant ha kadorioù ar re a werzhe koulmed. ");
INSERT INTO breBRG_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne leze den da zougen tra ebet dre an templ, ");
INSERT INTO breBRG_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","hag e kelenne en ur lavarout: N'eo ket skrivet: Va zi a vo galvet un ti a bedennoù evit an holl bobloù? Met c'hwi hoc'h eus graet anezhañ ur c'havarn laeron. ");
INSERT INTO breBRG_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ar veleien vras hag ar skribed, o vezañ klevet-se, a glaske an doare d'e lakaat d'ar marv; rak aon o devoa dirazañ, abalamour an holl bobl a oa souezhet bras gant e gelenn. ");
INSERT INTO breBRG_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","An abardaez o vezañ deuet, Jezuz a yeas er-maez eus kêr. ");
INSERT INTO breBRG_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Diouzh ar beure, evel ma tremenent, e ziskibien a welas ar wezenn-fiez sec'het betek ar gwrizioù. ");
INSERT INTO breBRG_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Neuze Pêr, o kaout soñj eus ar pezh a oa c'hoarvezet, a lavaras dezhañ: Mestr, setu, ar wezenn-fiez ac'h eus milliget a zo sec'het. ");
INSERT INTO breBRG_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jezuz, o respont, a lavaras: Ho pet feiz e Doue; ");
INSERT INTO breBRG_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","rak me a lavar deoc'h e gwirionez, penaos piv bennak a lavaro d'ar menez-se: Sav alese hag en em daol er mor, ha kement-se hep argrediñ en e galon, met en ur grediñ e c'hoarvezo, ar pezh a lavar a vo roet dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Setu perak e lavaran deoc'h: Kement a c'houlennot en ur bediñ, kredit e vo roet deoc'h, ha kement-se a c'hoarvezo. ");
INSERT INTO breBRG_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Met pa'z eot evit pediñ, pardonit, mar hoc'h eus un dra bennak a-enep unan bennak, pardonit dezhañ, abalamour d'ho Tad a zo en neñvoù da bardoniñ deoc'h ivez ho pec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Rak ma ne bardonit ket, ho Tad a zo en neñvoù ne bardono ket deoc'h kennebeut ho pec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Distreiñ a rejont c'hoazh da Jeruzalem; hag evel ma'z ae dre an templ, ar veleien vras, ar skribed hag an henaourien a dostaas outañ, ");
INSERT INTO breBRG_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","hag a lavaras dezhañ: Dre beseurt galloud e rez an traoù-se, ha piv en deus roet dit galloud d'ober an traoù-se? ");
INSERT INTO breBRG_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jezuz a respontas dezho: Me a c'houlenno ivez un dra ouzhoc'h; respontit din hag e lavarin deoc'h dre beseurt galloud e ran an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Badeziant Yann, ha dont a rae eus an neñv pe eus an dud? Respontit din. ");
INSERT INTO breBRG_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Int a soñje enno oc'h-unan, o lavarout: Mar lavaromp: Eus an neñv, e lavaro: Perak eta n'hoc'h eus ket kredet ennañ? ");
INSERT INTO breBRG_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ha mar lavaromp: Eus an dud ... Aon o devoa rak ar bobl; an holl a grede e oa Yann ur gwir brofed. ");
INSERT INTO breBRG_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Neuze e respontjont da Jezuz: N'ouzomp ket. Ha Jezuz a lavaras dezho: Ha me kennebeut, ne lavarin ket deoc'h dre beseurt galloud e ran an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Neuze Jezuz en em lakaas da gomz outo dre barabolennoù: Un den, emezañ, a blantas ur winieg, a reas ur c'harzh en-dro dezhi, a gleuzias enni ur wask, hag a savas enni un tour; neuze e feurmas anezhi da winierien, hag ez eas en ur vro all. ");
INSERT INTO breBRG_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Da amzer ar frouezh e kasas unan eus e servijerien etrezek ar winierien, evit kemer diganto frouezh ar winieg. ");
INSERT INTO breBRG_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Met o vezañ kroget ennañ e kannjont anezhañ hag e kasjont anezhañ kuit hep netra. ");
INSERT INTO breBRG_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kas a reas dezho c'hoazh ur servijer all; met e veinata a rejont, e c'hloazjont en e benn, hag e gasjont kuit goude bezañ graet dezhañ meur a zismegañs. ");
INSERT INTO breBRG_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hag e kasas c'hoazh unan all, hag a voe lazhet ganto; ha kalz a re all, ma oa kannet lod ha lazhet lod all ganto. ");
INSERT INTO breBRG_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Da ziwezhañ, o kaout ur mab a gare kalz, e kasas anezhañ dezho, en ur lavarout: Doujañ a raint va mab. ");
INSERT INTO breBRG_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Met ar winierien-mañ a lavaras etrezo: Setu an heritour; deuit, lazhomp-eñ, hag e heritaj a vo deomp. ");
INSERT INTO breBRG_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hag o vezañ kroget ennañ, en lazhjont, hag e taoljont anezhañ er-maez eus ar winieg. ");
INSERT INTO breBRG_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Petra eta a raio mestr ar winieg? Dont a raio, hag e tistrujo ar winierien-se, hag e roio ar winieg da re all. ");
INSERT INTO breBRG_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ha n'hoc'h eus ket lennet ar gomz-mañ er Skritur: Ar maen taolet kuit gant ar re a vañsone, a zo deuet da vezañ penn ar c'horn. ");
INSERT INTO breBRG_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kement-se a zo bet graet gant an Aotrou, hag un dra marzhus eo d'hon daoulagad? ");
INSERT INTO breBRG_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Neuze e klaskjont kregiñ ennañ, rak anavezout a rejont mat en devoa lavaret ar barabolenn-se a-enep dezho, met aon o devoa rak ar bobl; setu perak e lezjont anezhañ hag ez ejont kuit. ");
INSERT INTO breBRG_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kas a rejont dezhañ hiniennoù eus ar farizianed hag eus an herodianed, evit e dapout en e gomzoù. ");
INSERT INTO breBRG_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","O vezañ eta deuet d'e gavout, e lavarjont dezhañ: Mestr, gouzout a reomp penaos out gwirion ha ne rez van a zen ebet; rak ne sellez ket ouzh diavaez an dud, met kelenn a rez hent Doue hervez ar wirionez: Ha dleet eo paeañ ar gwir da Gezar, pe n'eo ket? ");
INSERT INTO breBRG_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","E baeañ a raimp-ni, pe ne raimp ket? Met eñ, oc'h anavezout o filpouzerezh, a lavaras dezho: Perak e temptit ac'hanon? Degasit din un diner, evit ma welin anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hag e tegasjont dezhañ unan. Neuze e lavaras dezho: Eus piv eo ar skeud hag ar skrid-mañ? Int a lavaras dezhañ: Eus Kezar. ");
INSERT INTO breBRG_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ha Jezuz a respontas dezho: Roit eta da Gezar ar pezh a zo da Gezar, ha da Zoue ar pezh a zo da Zoue. Hag e voent souezhet bras gantañ. ");
INSERT INTO breBRG_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Neuze ar sadukeiz, hag a lavar n'eus ket a adsavidigezh a varv, a zeuas d'e gavout, hag a reas outañ ar goulenn-mañ: ");
INSERT INTO breBRG_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mestr, Moizez en deus gourc'hemennet deomp ma teuje breur unan bennak da vervel ha da lezel e wreg hep bugale, e vreur a zimezo d'e intañvez, evit sevel lignez d'e vreur. ");
INSERT INTO breBRG_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bez' e oa seizh breur. An hini kentañ, o vezañ kemeret ur wreg, a varvas hep lezel bugale. ");
INSERT INTO breBRG_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","An eil a gemeras anezhi, hag a varvas, hep lezel kennebeut a vugale. Hag an trede en hevelep doare. ");
INSERT INTO breBRG_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ar seizh breur a gemeras anezhi; ha ne lezjont ket a vugale. Ha d'an diwezhañ-holl, ar wreg a varvas ivez. ");
INSERT INTO breBRG_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Da behini eta anezho e vo gwreg, en adsavidigezh a varv? Rak bet eo gwreg dezho o seizh. ");
INSERT INTO breBRG_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jezuz a respontas dezho: Ha n'oc'h ket en dallentez, dre n'anavezit ket ar Skriturioù, na galloud Doue? ");
INSERT INTO breBRG_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rak pa adsavor a varv, ar wazed n'o devo ket a wragez, nag ar gwragez a ezhec'h, met bez' e vint evel aeled en neñv. ");
INSERT INTO breBRG_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Met diwar-benn an adsavidigezh a varv, ha n'hoc'h eus ket lennet e levr Moizez, penaos Doue a lavaras dezhañ er vodenn loskus: Me eo Doue Abraham, Doue Izaak, ha Doue Jakob? ");
INSERT INTO breBRG_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Doue n'eo ket Doue ar re varv, met Doue ar re vev. En ur fazi bras oc'h eta. ");
INSERT INTO breBRG_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Neuze unan ar skribed en devoa o c'hlevet o riotal; o welout en devoa Jezuz respontet mat dezho, e tostaas hag e c'houlennas outañ: Pehini eo ar c'hentañ eus an holl c'hourc'hemennoù? ");
INSERT INTO breBRG_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jezuz a respontas dezhañ: Ar c'hentañ eus an holl c'hourc'hemennoù eo: Selaou Israel, an Aotrou hon Doue eo an Aotrou hepken. ");
INSERT INTO breBRG_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Karout a ri an Aotrou da Zoue, eus da holl galon, eus da holl ene, eus da holl soñj, hag eus da holl nerzh. Hennezh eo ar c'hentañ gourc'hemenn. ");
INSERT INTO breBRG_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ha setu an eil a zo heñvel outañ: Karout a ri da nesañ eveldout da-unan. N'eus ket a c'hourc'hemennoù all brasoc'h eget ar re-mañ. ");
INSERT INTO breBRG_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hag ar skrib a respontas dezhañ: Mat eo, Mestr, lavaret ec'h eus gant gwirionez, n'eus nemet un Doue, ha n'eus hini all ebet nemetañ, ");
INSERT INTO breBRG_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ha penaos karout anezhañ eus e holl galon, eus e holl soñj, eus e holl ene, hag eus e holl nerzh, ha karout e nesañ eveltañ e-unan a zo mui eget an holl loskaberzhoù hag ar sakrifisoù. ");
INSERT INTO breBRG_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jezuz, o welout en devoa respontet gant furnez, a lavaras dezhañ: N'out ket pell diouzh rouantelezh Doue. Ha neuze den ne gredas mui ober goulenn ebet outañ. ");
INSERT INTO breBRG_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Evel ma kelenne Jezuz en templ, e lavaras: Perak e lavar ar skribed eo ar C'hrist Mab David? ");
INSERT INTO breBRG_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Rak David a lavar e-unan dre ar Spered-Santel: An Aotrou en deus lavaret da'm Aotrou: Azez a-zehou din, betek ma em bo graet eus da enebourien ur skabell dindan da dreid. ");
INSERT INTO breBRG_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mar galv eta David e-unan anezhañ Aotrou, penaos eo-eñ e vab? Ha kalz a dud a selaoue anezhañ gant plijadur. ");
INSERT INTO breBRG_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","En ur gelenn anezho, e lavare ivez dezho: Diwallit diouzh ar skribed a gar pourmen gant saeoù hir ha bezañ saludet er marc'hallac'hioù, ");
INSERT INTO breBRG_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","hag a gar ar c'hadorioù kentañ er sinagogennoù, hag ar plasoù kentañ er festoù; ");
INSERT INTO breBRG_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","dismantrañ a reont tiez an intañvezed, hag e reont evit ar gweled pedennoù hir; bez' o devo ur varnedigezh gwashoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jezuz, o vezañ azezet dirak ar c'hef, a selle penaos e lakae an dud arc'hant er c'hef: kalz a dud pinvidik a daole kalz. ");
INSERT INTO breBRG_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dont a reas ivez un intañvez paour, hag a daolas e-barzh daou bezhig, oc'h ober ur c'hadrin. ");
INSERT INTO breBRG_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Neuze, o vezañ galvet e ziskibien, e lavaras dezho: Me a lavar deoc'h e gwirionez, an intañvez paour-se he deus lakaet muioc'h er c'hef, eget an holl re all o deus lakaet ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Rak holl o deus lakaet eus ar pezh o devoa a-re; met houmañ he deus lakaet eus he dienez, kement he devoa, kement holl a oa chomet ganti evit bevañ. ");
INSERT INTO breBRG_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Evel ma'z ae Jezuz kuit eus an templ, unan eus e ziskibien a lavaras dezhañ: Mestr, sell pebezh mein, ha pebezh tiez! ");
INSERT INTO breBRG_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jezuz a respontas dezhañ: Ha gwelout a rez an holl diez bras-se? Ne chomo ket anezho maen war vaen na vo diskaret. ");
INSERT INTO breBRG_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hag evel ma oa azezet war Venez an Olived, dirak an templ, Pêr, Jakez, Yann hag Andrev a reas a-du ar goulenn-mañ outañ: ");
INSERT INTO breBRG_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Lavar deomp pegoulz e c'hoarvezo kement-se, ha pehini e vo ar sin eus o oberiañs nesañ? ");
INSERT INTO breBRG_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Neuze Jezuz, o respont, en em lakaas da lavarout: Diwallit na dromplfe den ac'hanoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Rak kalz a zeuio em anv, o lavarout: Me eo ar C'hrist; hag e tallint meur a hini. ");
INSERT INTO breBRG_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pa glevot komz eus brezelioù, ha brud eus brezelioù, na spontit ket; rak ret eo e teufe an traoù-se, met kement-se ne vo ket c'hoazh ar fin. ");
INSERT INTO breBRG_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Rak ur bobl a savo a-enep ur bobl all, hag ur rouantelezh a-enep ur rouantelezh all; ha bez' e vo krenoù-douar e meur a lec'h, ha naonegezhioù, ha trubuilhoù; an traoù-mañ a vo ar penn-kentañ eus ar gloazioù. ");
INSERT INTO breBRG_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Met diwallit ouzhoc'h hoc'h-unan, rak ho kas a raint dirak al lezioù-barn, ho skourjezañ a raint en o sinagogennoù, ha mont a reot dirak an ouarnerien ha dirak ar rouaned abalamour din, evit reiñ testeni din dirazo. ");
INSERT INTO breBRG_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Met ret eo e vefe da gentañ prezeget an Aviel d'an holl bobloù. ");
INSERT INTO breBRG_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pa gasint ac'hanoc'h evit ho lakaat etre o daouarn, na vezit ket en poan a-raok eus ar pezh ho po da lavarout, ha na brederit ket anezhañ; met lavarit ar pezh a vo roet deoc'h war an eur-se; rak ne vo ket c'hwi a gomzo, met ar Spered-Santel. ");
INSERT INTO breBRG_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ar breur a roio e vreur d'ar marv, hag an tad e vugel; ar vugale en em savo a-enep o zud, hag o lakaint d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kasaet e viot gant an holl abalamour da'm anv, met an hini a gendalc'ho betek ar fin, a vo salvet. ");
INSERT INTO breBRG_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pa welot an euzhusted eus ar glac'har, m'en deus komzet ar profed Daniel anezhi, deuet el lec'h ne dle ket bezañ (ra gompreno an neb a lenn), neuze ar re a vo e Judea, ra dec'hint war ar menezioù, ");
INSERT INTO breBRG_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","hag an hini a vo war an doenn, ra ne ziskenno ket en ti, ha n'aio ket ennañ da gemer un dra bennak eus e di, ");
INSERT INTO breBRG_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","hag an hini a vo er parkeier, ra ne zistroio ket a-dreñv da gemer e vantell. ");
INSERT INTO breBRG_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Gwalleur d'ar gwragez brazez, ha d'ar magerezed en deizioù-se! ");
INSERT INTO breBRG_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pedit evit na erruo ket ho tec'h er goañv. ");
INSERT INTO breBRG_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Rak bez' e vo en deizioù-se an hevelep glac'har, ken adalek penn-kentañ ar bed en deus Doue krouet betek vremañ, n'en deus ket bet, ha ne vo biken eveltañ. ");
INSERT INTO breBRG_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ha ma n'en divije ket an Aotrou berraet an deizioù-se, den ebet ne vije salvet; met abalamour d'ar re dibabet en deus o berraet. ");
INSERT INTO breBRG_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Neuze, mar lavar unan bennak deoc'h: Setu, ar C'hrist a zo amañ, pe aze, na gredit ket. ");
INSERT INTO breBRG_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rak fals-kristed ha fals-profeded a savo; hag e raint sinoù ha burzhudoù da dromplañ memes ar re dibabet, ma vije gallet. ");
INSERT INTO breBRG_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bezit war evezh eta; setu, em eus lavaret holl deoc'h a-raok. ");
INSERT INTO breBRG_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","En deizioù-se, goude ar glac'har-mañ, an heol a vo teñvalaet, al loar ne roio ket he sklêrijenn, ");
INSERT INTO breBRG_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ar stered a gouezho eus an oabl, hag ar galloudoù a zo en neñv a vo brañsellet. ");
INSERT INTO breBRG_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Neuze e vo gwelet Mab an den, o tont war ar c'hoabr, gant ur galloud hag ur gloar bras; ");
INSERT INTO breBRG_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","hag e kaso e aeled, da zastum e re dibabet eus ar pevar avel, adalek pennoù pell an douar betek pennoù pellañ an neñv. ");
INSERT INTO breBRG_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Deskit dre barabolenn ar wezenn-fiez: pa zeu he brankoù da vezañ tener hag he delioù da vountañ, ec'h anavezit eo tost an hañv; ");
INSERT INTO breBRG_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","evel-se ivez, pa welot kement-se oc'h erruout, gouezit Mab an den a zo tost, hag ouzh an nor. ");
INSERT INTO breBRG_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Me a lavar deoc'h e gwirionez, penaos ar rummad-mañ ne dremeno ket, ken na vo c'hoarvezet an holl draoù-se. ");
INSERT INTO breBRG_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","An neñv hag an douar a dremeno, met va gerioù ne dremenint ket. ");
INSERT INTO breBRG_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Evit ar pezh a sell ouzh an deiz hag an eur, den n'o anavez, nag an aeled a zo en neñv, nag ar Mab, met an Tad hepken. ");
INSERT INTO breBRG_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bezit war evezh, chomit dihun ha pedit; rak n'ouzoc'h ket pegoulz e teuio an amzer-se. ");
INSERT INTO breBRG_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bez' e vo evel un den a ya e beaj, a lez e di, a ro ar gundu anezhañ d'e vevelien, o lakaat da bep hini e labour, hag a c'hourc'hemenn d'ar porzhier bezañ dihun. ");
INSERT INTO breBRG_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chomit dihun eta, rak n'ouzoc'h ket pegoulz e teuio mestr an ti, pe d'an abardaez, pe da hanternoz, pe da gan ar c'hilhog, pe diouzh ar beure, ");
INSERT INTO breBRG_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","gant aon na zeufe en un taol, ha n'ho kavfe kousket. ");
INSERT INTO breBRG_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dre-se, ar pezh a lavaran, a lavaran deoc'h holl: Chomit dihun. ");
INSERT INTO breBRG_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gouel ar Pask hag ar bara hep goell a dlee bezañ daou zevezh goude; ar veleien vras hag ar skribed a glaske an doare da gregiñ e Jezuz dre droidell ha d'e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Met e lavarent: Arabat e vefe e-pad ar gouel, gant aon na savfe un drubuilh bennak e-touez ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jezuz, o vezañ e Betania ouzh taol e ti Simon al lovr, ur wreg a zeuas d'e gavout gant ul lestr alabastr leun a c'hwezh-vat a nard pur hag eus ur priz bras, hag, o vezañ torret al lestr, e skuilhas ar c'hwezh-vat war e benn. ");
INSERT INTO breBRG_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hiniennoù a yeas droug enno o-unan, hag a lavaras: Perak koll evel-se ar c'hwezh-vat-se? ");
INSERT INTO breBRG_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Rak gallet e vije bet gwerzhañ anezhi ouzhpenn tri c'hant diner, hag o reiñ d'ar beorien. Evel-se e krozmolent en he enep. ");
INSERT INTO breBRG_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Met Jezuz a lavaras: Lezit anezhi; perak e rit poan dezhi? Un dra vat he deus graet em c'heñver. ");
INSERT INTO breBRG_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Rak c'hwi ho po atav peorien ganeoc'h, ha bep gwech ma c'hoantaot e c'hellot ober vat dezho, met n'ho po ket atav ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Graet he deus ar pezh a oa en he galloud; balzamet he deus dre ziaraok va c'horf evit va beziadur. ");
INSERT INTO breBRG_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Me a lavar deoc'h e gwirionez, penaos en holl lec'hioù eus ar bed ma vo an aviel-mañ prezeget, ar pezh he deus graet a vo ivez lavaret en eñvor anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Neuze Judaz Iskariod, unan eus an daouzek, a yeas da gavout ar veleien vras evit lakaat Jezuz etre o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Selaou a rejont gant joa, hag e lavarjont reiñ arc'hant dezhañ; diwar neuze e klaskas an tu dereat d'e lakaat etre o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ar c'hentañ deiz eus ar bara hep goell, pa aberzhed ar Pask, e ziskibien a lavaras dezhañ: Pelec'h e c'hoantaez ez afemp da gempenn ar pezh a zo ret evit debriñ ar Pask? ");
INSERT INTO breBRG_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Neuze e kasas daou eus e ziskibien hag e lavaras dezho: It e kêr, hag e kavot dirazoc'h un den o tougen ur podad dour, it war e lerc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","E pe lec'h bennak ma'z aio, lavarit da vestr an ti: Ar Mestr a lavar: Pelec'h emañ al lec'h e tebrin ar Pask ennañ, gant va diskibien? ");
INSERT INTO breBRG_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hag e tiskouezo deoc'h ur gambr uhel, urzhiet ha kempennet mat; fichit eno deomp ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","E ziskibien eta a yeas, hag a zeuas e kêr, hag e kavjont an traoù evel m'en devoa lavaret dezho; hag e fichjont ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pa voe deuet an abardaez, e teuas gant an daouzek. ");
INSERT INTO breBRG_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Evel ma oant ouzh taol, ha ma tebrent, Jezuz a lavaras: Me a lavar deoc'h e gwirionez, unan ac'hanoc'h, unan a zebr ganin, am gwerzho. ");
INSERT INTO breBRG_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Neuze en em lakajont d'en em c'hlac'hariñ; hag e lavarjont dezhañ, an eil goude egile: Ha me eo? ");
INSERT INTO breBRG_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Eñ a respontas dezho: Unan an daouzek eo, ha lakaat a ra e zorn er plad ganin. ");
INSERT INTO breBRG_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mab an den, evit gwir, a ya hervez ar pezh a zo skrivet anezhañ; met gwalleur d'an den ma vo gwerzhet gantañ; gwell e vije d'an den-se, ne vije biken bet ganet. ");
INSERT INTO breBRG_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Evel ma tebrent, Jezuz a gemeras bara ha, goude bezañ trugarekaet, e torras anezhañ, hag en roas dezho, o lavarout: Kemerit, debrit, hemañ eo va c'horf. ");
INSERT INTO breBRG_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kemer a reas ivez an hanaf ha, goude bezañ trugarekaet, en roas dezho, hag ec'h evjont holl dioutañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hag e lavaras dezho: Hemañ eo va gwad, ar gwad eus an emglev nevez, skuilhet evit kalz. ");
INSERT INTO breBRG_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Me a lavar deoc'h e gwirionez, n'evin mui eus frouezh ar gwini, betek an deiz ma'c'h evin anezhañ nevez e rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Goude m'o devoe kanet ar c'hantikoù, ez ejont da Venez an Olived. ");
INSERT INTO breBRG_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Neuze, Jezuz a lavaras dezho: Me a vo deoc'h holl en noz-mañ un abeg da gouezhañ, rak skrivet eo: skeiñ a rin ar pastor, hag an deñved a vo stlabezet. ");
INSERT INTO breBRG_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Met goude ma vin adsavet a varv, ho tiaraogin e Galilea. ");
INSERT INTO breBRG_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ha Pêr a lavaras dezhañ: Pa vefe an holl gwallskoueriet, evidon-me, ne vin ket. ");
INSERT INTO breBRG_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Neuze Jezuz a lavaras dezhañ: Me a lavar dit e gwirionez, penaos hiziv, en noz-mañ, a-raok ma kano ar c'hilhog div wech, te az po va dinac'het teir gwech. ");
INSERT INTO breBRG_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Met eñ a lavare kreñvoc'h c'hoazh: Ha pa vefe ret din mervel ganit, ne zinac'hin ket ac'hanout. Hag holl, e lavarent ar memes tra. ");
INSERT INTO breBRG_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Neuze ez ejont en ul lec'h galvet Getsemane, ha Jezuz a lavaras d'e ziskibien: Azezit amañ e-pad ma pedin. ");
INSERT INTO breBRG_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kemer a reas gantañ Pêr, Jakez ha Yann, hag e voe leuniet a aon hag a anken. ");
INSERT INTO breBRG_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hag e lavaras dezho: Trist eo va ene betek ar marv; chomit amañ ha beilhit. ");
INSERT INTO breBRG_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O vont un tamm a-raokoc'h, en em stouas d'an douar, da bediñ ma c'hellje an eur-se pellaat dioutañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hag e lavare: Abba! Tad! An holl draoù a c'hellez; pella an hanaf-se diouzhin! Koulskoude neket evel ma fell din, met evel ma fell dit. ");
INSERT INTO breBRG_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hag e tistroas, o c'havas kousket, hag e lavaras da Bêr: Simon, kousket a rez! Ne'c'h eus ket gallet beilhañ un eur? ");
INSERT INTO breBRG_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Beilhit ha pedit evit na gouezhot ket en temptadur; ar spered a zo buan, met ar c'hig a zo dinerzh. ");
INSERT INTO breBRG_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mont a reas adarre, hag e pedas, o lavarout ar memes komzoù. ");
INSERT INTO breBRG_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O vezañ distroet, o c'havas adarre kousket, rak o daoulagad a oa pounneraet; ha ne ouient petra da lavarout dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hag e tistroas evit an trede gwech, hag e lavaras dezho: Kouskit bremañ ha diskuizhit! A-walc'h eo! An eur a zo deuet; setu, Mab an den a zo lakaet etre daouarn ar bec'herien. ");
INSERT INTO breBRG_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Savit, ha deomp, setu, an hini am gwerzh a dosta. ");
INSERT INTO breBRG_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ha kerkent, evel ma komze c'hoazh, Judaz, unan an daouzek, a zeuas, ha gantañ ur vandenn vras a dud gant klezeier ha gant bizhier, a-berzh ar veleien vras, ar skribed hag an henaourien. ");
INSERT INTO breBRG_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","An hini en gwerzhe en devoa roet ar sin-mañ: An hini a bokin dezhañ, hennezh eo; krogit ennañ, ha kasit eñ sur. ");
INSERT INTO breBRG_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Raktal eta evel ma oa erruet, e tostaas outañ, hag e lavaras dezhañ: Mestr! Mestr! Hag e pokas dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Neuze e lakajont o daouarn war Jezuz, hag e krogjont ennañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Unan eus ar re a oa eno a dennas e gleze, a skoas servijer ar beleg-meur, hag a droc'has e skouarn dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Neuze Jezuz a gemeras ar gomz hag a lavaras dezho: Deuet oc'h er-maez evel war-lerc'h ul laer, gant klezeier ha gant bizhier, evit kregiñ ennon. ");
INSERT INTO breBRG_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bemdez e oan en ho touez, o kelenn en templ, ha n'hoc'h eus ket va c'hemeret; met bez' eo evit ma vo ar Skriturioù peurc'hraet. ");
INSERT INTO breBRG_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Neuze, o vezañ e zilezet, an holl a dec'has kuit. ");
INSERT INTO breBRG_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Un den yaouank en heulie, goloet hepken gant ul linenn skañv; an dud yaouank a grogas ennañ, ");
INSERT INTO breBRG_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","met eñ a lezas ganto e wiskamant, hag a dec'has en noazh deus etre o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kas a rejont neuze Jezuz da di ar beleg-meur, e-lec'h ma oa en em zastumet an holl veleien vras, an henaourien hag ar skribed. ");
INSERT INTO breBRG_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pêr a heulias anezhañ a-bell betek porzh ar beleg-meur. Hag o vezañ azezet gant ar vevelien, en em domme e-tal an tan. ");
INSERT INTO breBRG_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ar veleien vras hag an holl sanedrin a glaske un testeni a-enep Jezuz, evit e lakaat d'ar marv, hogen ne gavent ket. ");
INSERT INTO breBRG_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rak kalz a roe testeni fals en e enep, met o zestenioù ne oant ket heñvel etrezo. ");
INSERT INTO breBRG_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hiniennoù a savas neuze, hag a zougas ur fals testeni a-enep dezhañ o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ni hon eus e glevet o lavarout: Me a ziskaro an templ-mañ, graet gant dorn an den, hag a-benn tri deiz ec'h adsavin unan all, ha ne vo ket graet gant dorn an den. ");
INSERT INTO breBRG_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Met o zestenioù ne oant ket heñvel etrezo kennebeut. ");
INSERT INTO breBRG_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Neuze ar beleg-meur, o sevel e-kreiz ar sanhedrin, a reas ouzh Jezuz ar goulenn-mañ: Ha ne respontez netra? Petra a destenn an dud-se en da enep? ");
INSERT INTO breBRG_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Met Jezuz a davas ha ne respontas netra. Ar beleg-meur a reas c'hoazh outañ ar goulenn-mañ: Bez' out-te ar C'hrist, Mab an Hini a zo benniget? ");
INSERT INTO breBRG_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ha Jezuz a lavaras dezhañ: Bez' ez on; ha gwelout a reot Mab an den azezet a-zehou da c'halloud Doue, hag o tont war goabr an neñv. ");
INSERT INTO breBRG_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Neuze ar beleg-meur a rogas e zilhad, hag a lavaras: Da betra hon eus mui ezhomm a destoù? ");
INSERT INTO breBRG_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Klevet hoc'h eus al ledoued; petra a soñjit a-se? Holl neuze, e varnjont anezhañ evel din a varv. ");
INSERT INTO breBRG_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hiniennoù en em lakaas da grañchat outañ, da c'holeiñ e vizaj, ha da reiñ dezhañ karvanadoù, o lavarout: Divin! Hag ar vevelien a skoe anezhañ gant bizhier. ");
INSERT INTO breBRG_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pêr a oa e traoñ ar porzh, hag e teuas eno unan eus mitizhien ar beleg-meur; ");
INSERT INTO breBRG_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","hag o welout Pêr oc'h en em dommañ, e sellas outañ hag e lavaras: Te ivez, te a oa gant Jezuz a Nazared. ");
INSERT INTO breBRG_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Met eñ a nac'has anezhañ, hag a lavaras: N'anavezan ket anezhañ, ha n'ouzon ket petra a lavarez; mont a reas er-maez er porzh; hag ar c'hilhog a ganas. ");
INSERT INTO breBRG_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ar vatezh-se, o vezañ e welet adarre, en em lakaas da lavarout d'ar re a oa eno: An den-mañ a zo eus an dud-se. Met eñ e nac'has adarre. ");
INSERT INTO breBRG_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ur penad goude, ar re a oa eno a lavaras da Bêr: Evit gwir te a zo eus an dud-se, rak te a zo Galileat, ha da yezh a zo heñvel ouzh o hini. ");
INSERT INTO breBRG_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Neuze en em lakaas da zroukpediñ ha da douiñ, o lavarout: N'anavezan ket an den-se a gomzit anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Raktal ar c'hilhog a ganas un eil gwech; ha Pêr en devoe soñj eus ar gomz en devoa Jezuz lavaret dezhañ: A-raok ma kano ar c'hilhog div wech, ez po va dinac'het teir gwech. Hag o vezañ aet buan er-maez, e ouelas. ");
INSERT INTO breBRG_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kerkent ha ma voe deiz, ar veleien vras, gant an henaourien hag ar skribed, hag ar sanedrin o vezañ en em guzuliet, a zegasas Jezuz ereet hag en lakajont etre daouarn Pilat. ");
INSERT INTO breBRG_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat a c'houlennas outañ: Bez' out-te roue ar Yuzevien? Jezuz a respontas dezhañ: Te en lavar. ");
INSERT INTO breBRG_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ar veleien vras a damalle anezhañ eus meur a dra. ");
INSERT INTO breBRG_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Met Pilat a reas c'hoazh ar goulenn-mañ outañ, o lavarout: Ne respontez netra dezho? Gwel pegement a draoù a damallont dit. ");
INSERT INTO breBRG_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Met Jezuz ne respontas ken netra, en hevelep doare ma oa Pilat souezhet. ");
INSERT INTO breBRG_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bez' e oa ar c'hiz da leuskel dezho, da bep gouel, an hini eus ar brizonidi a c'houlenne ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hag e oa er prizon unan galvet Barabbaz gant e genseurted, rak graet o devoa ur muntr e-pad un dispac'h. ");
INSERT INTO breBRG_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ar bobl en em lakaas da c'houlenn gant kriadennoù bras, ma vije graet dezho evel m'en devoa atav graet. ");
INSERT INTO breBRG_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat a respontas dezho: Fellout a ra deoc'h e laoskfen deoc'h roue ar Yuzevien? ");
INSERT INTO breBRG_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Rak anavezout a rae e oa dre avi o devoa ar veleien vras e lakaet etre e zaouarn. ");
INSERT INTO breBRG_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Met ar veleien vras a vroude ar bobl da c'houlenn ma vije laosket kentoc'h dezho Barabbaz. ");
INSERT INTO breBRG_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat, oc'h adkemer ar gomz, a lavaras dezho: Petra a fell deoc'h e rafen eta eus an hini e c'halvit roue ar Yuzevien? ");
INSERT INTO breBRG_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Int a grias a-nevez: Ouzh ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat a lavaras dezho: Met peseurt droug en deus graet? Hag e krijont c'hoazh kreñvoc'h: Ouzh ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat eta, o c'hoantaat plijout d'ar bobl, a laoskas dezho Barrabaz; ha goude bezañ lakaet skourjezañ Jezuz, en roas evit bezañ staget ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ar soudarded a zegasas anezhañ e diabarzh ar palez, da lavarout eo er pretordi, hag e tastumjont eno an holl strollad. ");
INSERT INTO breBRG_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hag e wiskjont anezhañ gant ur vantell vouk, hag e lakajont war e benn ur gurunenn spern o devoa gweet. ");
INSERT INTO breBRG_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Neuze en em lakajont d'e saludiñ, o lavarout: Salud, roue ar Yuzevien! ");
INSERT INTO breBRG_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hag e skojont war e benn gant ur gorzenn, hag e krañchjont outañ, hag, o plegañ o glin, e stoujont dirazañ. ");
INSERT INTO breBRG_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Goude bezañ graet goap anezhañ, e lamjont ar vantell vouk diwarnañ, e wiskjont dezhañ e zilhad en-dro, hag e kasjont anezhañ evit e lakaat ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Un den eus Siren, anvet Simon, tad da Aleksandr ha da Rufuz, a dremene dre eno, o tont eus ar parkeier; ober a rejont dezhañ dougen kroaz Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hag e kasjont Jezuz d'ul lec'h anvet Golgota, da lavarout eo lec'h ar c'hlopenn. ");
INSERT INTO breBRG_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hag e kinnigjont dezhañ da evañ gwin mesket gant mir; met ne evas ket anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Goude m'o devoe e staget ouzh ar groaz, e lodennjont e zilhad, o teurel d'ar sord, evit anavezout lod pep hini. ");
INSERT INTO breBRG_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bez' e oa an trede eur, pa en stagjont ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Abeg e gondaonidigezh a oa lakaet dre ar skrid-mañ: ROUE AR YUZEVIEN. ");
INSERT INTO breBRG_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Stagañ a rejont ivez ouzh ar groaz gantañ daou laer, unan a-zehou, hag egile a-gleiz dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Evel-se ar gomz-mañ eus ar Skritur a voe peurc'hraet: Lakaet eo bet e renk an dorfedourien. ");
INSERT INTO breBRG_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ar re a dremene dre eno a lavare dismegañsoù dezhañ, o hejañ o fenn, hag o lavarout: He! Te, an hini a ziskar an templ hag en adsav e tri deiz, ");
INSERT INTO breBRG_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","en em savete da-unan, ha diskenn eus ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Evel-se ivez, ar veleien vras, gant ar skribed, a lavare etrezo, en ur c'hoapaat: Saveteet en deus ar re all, ha ne c'hell ket en em saveteiñ e-unan! ");
INSERT INTO breBRG_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ra ziskenno ar C'hrist, roue Israel, bremañ eus ar groaz, abalamour deomp d'e welout, ha ma kredimp! Hag ar re a oa staget ouzh ar groaz gantañ, a lavare ivez dismegañsoù dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa zeuas ar c'hwec'hvet eur, e voe teñvalijenn war an douar holl, betek an navet eur. ");
INSERT INTO breBRG_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ha d'an navet eur, Jezuz a grias gant ur vouezh kreñv: Eloi, Eloi, lama sabaktani? Da lavarout eo: Va Doue, va Doue, perak ec'h eus va dilezet? ");
INSERT INTO breBRG_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hiniennoù eus ar re a oa eno, o vezañ e glevet, a lavare: Setu e c'halv Elia. ");
INSERT INTO breBRG_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Unan anezho a redas, a leunias ur spoueenn a winegr, he lakaas e penn ur gorzenn, hag he roas dezhañ da evañ, en ur lavarout: Lezit; gwelomp hag-eñ e teuio Elia d'e ziskenn. ");
INSERT INTO breBRG_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Neuze Jezuz, o vezañ taolet ur griadenn vras, a varvas. ");
INSERT INTO breBRG_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gouel an templ a rogas e div, adalek krec'h betek traoñ. ");
INSERT INTO breBRG_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ar c'hantener a oa dirazañ, o welout e oa marvet en ur grial evel-se, a lavaras: Hemañ, evit gwir, a oa Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bez' e oa ivez gwragez a selle a-bell. En o-zouez e oa Mari a Vagdala, ha Mari mamm da Jakez ar Yaouankañ ha da Jozef, ha Salome, ");
INSERT INTO breBRG_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ar re en heulie hag en servije pa oa e Galilea, ha meur a hini all a oa pignet gantañ da Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Diouzh an abardaez, evel ma oa deiz ar c'hempennadur, da lavarout eo deiz kent ar sabad, ");
INSERT INTO breBRG_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jozef a Arimatea, ur c'huzulier enoret a c'hortoze ivez rouantelezh Doue, a zeuas gant hardizhegezh da gavout Pilat, hag a c'houlennas digantañ korf Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat a voe souezhet bras ma oa marv ken buan; hag o vezañ galvet ar c'hantener, e c'houlennas digantañ hag-eñ e oa marv pell a oa. ");
INSERT INTO breBRG_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","O vezañ anavezet kement-se, gant ar c'hantener, e roas ar c'horf da Jozef. ");
INSERT INTO breBRG_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jozef, o vezañ prenet ul lienenn, en diskennas eus ar groaz, en goloas gant ul lienenn, a lakaas anezhañ en ur bez toullet er roc'h, hag a ruilhas ur maen ouzh dor ar bez. ");
INSERT INTO breBRG_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari a Vagdala ha Mari mamm Jozef, a selle pelec'h e oa lakaet. ");
INSERT INTO breBRG_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Goude ma oa ar sabad tremenet, Mari a Vagdala, Mari mamm Jakez, ha Salome, a brenas louzoù a c'hwez-vat evit dont da valzamañ ar c'horf. ");
INSERT INTO breBRG_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Deiz kentañ ar sizhun, da sav-heol, e teujont mintin mat d'ar bez. ");
INSERT INTO breBRG_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hag e lavarent etrezo: Piv a lamo deomp ar maen a zo ouzh dor ar bez? ");
INSERT INTO breBRG_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","O vezañ sellet, e weljont ar maen a oa bet lamet; ha gwall vras e oa. ");
INSERT INTO breBRG_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Neuze, o vezañ aet er bez, e weljont un den yaouank azezet en tu dehou, gwisket gant ur sae wenn; spontet e oant. ");
INSERT INTO breBRG_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Met eñ a lavaras dezho: Na vezit ket spontet; c'hwi a glask Jezuz a Nazared, an hini a zo bet staget ouzh ar groaz; adsavet eo a varv, n'emañ ken amañ; setu al lec'h m'o devoa lakaet anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Met it, ha lavarit d'e ziskibien ha da Bêr ho tiaraogo e Galilea, eno en gwelot, evel m'en deus lavaret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Int a yeas kuit hag a dec'has diouzh ar bez, rak souezhet e oant ha leuniet a aon. Ne lavarjont netra da zen, rak spontet e oant. ");
INSERT INTO breBRG_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jezuz, o vezañ adsavet a varv diouzh ar beure, deiz kentañ ar sizhun, en em ziskouezas da gentañ da Vari a Vagdala, m'en devoa kaset kuit seizh diaoul anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hi a yeas, hag a roas d'e anavezout d'ar re a oa bet gantañ, hag a oa e kañv hag en daeroù. ");
INSERT INTO breBRG_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Met int, o klevout e oa bev, hag he devoa-hi e welet, ne gredjont ket anezhi. ");
INSERT INTO breBRG_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Goude-se, en em ziskouezas en un doare all da zaou anezho a oa en hent, o vont war ar maez. ");
INSERT INTO breBRG_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ar re-mañ a yeas da lavarout d'ar re all ha n'o c'hredjont ket kennebeut. ");
INSERT INTO breBRG_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Da ziwezhañ, en em ziskouezas d'an unnek abostol, evel ma oant ouzh taol, hag e rebechas dezho o diskredoni ha kaleter o c'halon, abalamour n'o devoa ket kredet ar re o devoa e welet adsavet a varv. ");
INSERT INTO breBRG_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hag e lavaras dezho: It dre ar bed holl, ha prezegit an Aviel da bep krouadur. ");
INSERT INTO breBRG_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","An hini a gredo hag a vo badezet a vo salvet; met an hini na gredo ket a vo kondaonet. ");
INSERT INTO breBRG_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ha setu ar mirakloù a heulio ar re o devo kredet: Kas a raint kuit an diaoulien em anv; komz a raint yezhoù nevez; ");
INSERT INTO breBRG_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kemer a raint an naered; mar evont un dra marvus bennak, ne raio ket a boan dezho; lakaat a raint o daouarn war ar re glañv, hag e vint yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","An Aotrou, goude bezañ komzet outo, a voe savet en neñv, hag ec'h azezas a-zehou da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hag int, o vezañ aet, a brezegas dre holl, an Aotrou o kenober ganto, hag o reiñ kred da C'her Doue dre ar mirakloù o heulie. ");
INSERT INTO breBRG_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kalz o vezañ kemeret ar garg da skrivañ istor an traoù c'hoarvezet, hag anavezet mat evit bezañ gwir en hon touez, ");
INSERT INTO breBRG_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","hervez m'o deus degaset deomp ar re o deus o gwelet adalek ar penn-kentañ, hag a zo bet ministred ar Ger, ");
INSERT INTO breBRG_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","kredet em eus ivez, Teofil mat-meurbet, e tleen o skrivañ dit dre urzh, goude bezañ graet un enklask pizh warno holl, gant evezh, ");
INSERT INTO breBRG_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","evit ma'c'h anavezi ar wirionez diwar-benn ar pezh a zo bet desket dit. ");
INSERT INTO breBRG_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","En amzer Herodez, roue Judea, e oa ur beleg anvet Zakaria, eus lignez Abia; e wreg a oa eus lignez Aaron, hag en em c'halve Elizabed. ");
INSERT INTO breBRG_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Reizh e oant o-daou dirak an Aotrou, hag e heulient holl gourc'hemennoù hag urzhioù an Aotrou, en un doare divlam. ");
INSERT INTO breBRG_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","N'o devoa ket a vugale, rak Elizabed a oa gaonac'h, hag o-daou, e oant aet war an oad. ");
INSERT INTO breBRG_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Erruout a reas, evel ma rae Zakaria e garg a veleg dirak Doue, hervez urzh e dro, ");
INSERT INTO breBRG_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ma voe galvet dre ar sord, hervez giz ar velegiezh, da vont e-barzh templ an Aotrou, evit deviñ an ezañs. ");
INSERT INTO breBRG_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","An holl bobl a oa er-maez o pediñ, d'an eur ma teved an ezañs. ");
INSERT INTO breBRG_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Neuze un ael eus an Aotrou en em ziskouezas dezhañ en e sav, en tu dehou da aoter an ezañs. ");
INSERT INTO breBRG_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria, o welout anezhañ, a voe trubuilhet, hag ar spont a grogas ennañ. ");
INSERT INTO breBRG_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Met an ael a lavaras dezhañ: Zakaria, na'z pez ket aon, rak da bedenn a zo bet selaouet, Elizabed a c'hano dit ur mab, hag e roi dezhañ an anv a Yann. ");
INSERT INTO breBRG_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bez' e vo evidout un abeg a joa hag a laouenidigezh, ha kalz en em laouenaio eus e c'hanedigezh. ");
INSERT INTO breBRG_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Rak bras e vo dirak an Aotrou; n'evo na gwin, nag evaj kreñv ebet, ha leuniet e vo eus ar Spered-Santel adalek kof e vamm; ");
INSERT INTO breBRG_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","distreiñ a raio kalz eus bugale Israel d'an Aotrou o Doue, ");
INSERT INTO breBRG_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","hag e valeo dirazañ e spered hag e nerzh Elia, evit treiñ kalonoù an tadoù ouzh ar vugale, hag ar re disentus ouzh furnez ar re reizh, evit aozañ d'an Aotrou ur bobl tuet mat. ");
INSERT INTO breBRG_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria a lavaras d'an ael: A betra ec'h anavezin kement-se? Rak me a zo kozh, ha va gwreg a zo aet war an oad? ");
INSERT INTO breBRG_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","An ael a respontas dezhañ: Me eo Gabriel, an hini a chom dirak Doue; degaset on bet evit komz ouzhit ha disklêriañ dit ar c'heloù mat-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ha setu, te a ya da vezañ mut, ha ne c'helli ken komz, betek an deiz ma c'hoarvezo an traoù-mañ, abalamour ne'c'h eus ket kredet da'm c'homzoù, hag a erruo en o amzer. ");
INSERT INTO breBRG_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Koulskoude, ar bobl a c'hortoze Zakaria, hag a oa souezhet ma talee en templ. ");
INSERT INTO breBRG_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pa voe deuet er-maez, ne c'helle ket komz outo, hag ec'h anavezjont en devoa bet ur welidigezh en templ, rak dre sinoù en roe da gompren dezho; hag e chomas mut. ");
INSERT INTO breBRG_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pa voe echuet deizioù e garg, ez eas d'e di. ");
INSERT INTO breBRG_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Un nebeut amzer goude, Elizabed, e wreg, en em gavas dougerez, hag en em guzhas e-pad pemp miz, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Evel-se eo, en deus graet an Aotrou em c'heñver en deizioù-mañ, m'en deus sellet ouzhin, evit lemel an dismegañs a oa warnon dirak an dud. ");
INSERT INTO breBRG_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Er c'hwec'hvet miz, Doue a gasas an ael Gabriel en ur gêr a C'halilea galvet Nazared, ");
INSERT INTO breBRG_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","d'ur werc'hez a zlee dimeziñ d'un den anvet Jozef, eus tiegezh David; ar werc'hez-se a oa anvet Mari. ");
INSERT INTO breBRG_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","An ael, o vezañ aet el lec'h ma oa, a lavaras dezhi: Da saludiñ a ran, te a zo bet resevet en gras, an Aotrou a zo ganit. Benniget out e-touez ar gwragez. ");
INSERT INTO breBRG_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","O vezañ gwelet an ael, e voe trubuilhet gant e gomzoù, hag e soñje enni ec'h-unan petra a c'helle ar salud-se bezañ. ");
INSERT INTO breBRG_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Neuze an ael a lavaras dezhi: Mari, na'z pez ket aon, rak kavet ec'h eus gras dirak Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Setu, te a vo dougerez, hag e c'hani ur mab, hag e c'halvi e anv Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bras e vo, hag e vo galvet mab an Uhelañ-Meurbet, hag an Aotrou Doue a roio dezhañ tron David e dad. ");
INSERT INTO breBRG_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ren a raio da virviken war diegezh Jakob, hag e ren n'en devo ken a fin. ");
INSERT INTO breBRG_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Neuze Mari a lavaras d'an ael: Penaos e c'hoarvezo kement-se, pa n'anavezan gwaz ebet? ");
INSERT INTO breBRG_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","An ael a respontas dezhi: Ar Spered-Santel a zeuio warnout, ha galloud an Uhelañ-Meurbet a c'holoio ac'hanout gant e skeud; dre-se ar bugel santel a vo ganet ac'hanout a vo galvet Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ha setu, Elizabed da geniterv a zoug ivez ur mab en he c'hozhni, hag hemañ eo ar c'hwec'hvet miz eus an hini a oa galvet gaonac'h. ");
INSERT INTO breBRG_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rak n'eus netra dibosupl da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ha Mari a lavaras: Setu servijerez an Aotrou, ra vo graet din hervez da gomz. Hag an ael a bellaas diouti. ");
INSERT INTO breBRG_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Neuze Mari a savas, hag a yeas buan da vro ar menezioù, en ur gêr eus Bro-Juda, ");
INSERT INTO breBRG_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","hag, o vezañ aet e ti Zakaria, e saludas Elizabed. ");
INSERT INTO breBRG_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kerkent ha ma klevas Elizabed Salud Mari, ar bugel bihan a dridas en he c'hof; hag Elizabed a voe leuniet eus ar Spered-Santel. ");
INSERT INTO breBRG_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hag o sevel he mouezh, e krias: Te a zo benniget e-touez ar gwragez, ha benniget eo frouezh da gof. ");
INSERT INTO breBRG_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A-belec'h e teu kement-mañ din, ma teu mamm va Aotrou etrezek ennon? ");
INSERT INTO breBRG_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rak mouezh da salud n'he deus ket kentoc'h skoet va divskouarn, m'en deus ar bugel bihan tridet gant levenez em c'hof. ");
INSERT INTO breBRG_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Eürus eo an hini he deus kredet, rak graet e vo an traoù a zo bet lavaret dezhi a-berzh an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Neuze Mari a lavaras: Va ene a veul an Aotrou, ");
INSERT INTO breBRG_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ha va spered en em laouena e Doue va Salver, ");
INSERT INTO breBRG_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","abalamour m'en deus sellet ouzh izelded e servijerez. Ha setu, diwar vremañ, e vin galvet eürus gant an holl rummadoù, ");
INSERT INTO breBRG_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","rak an Holl-C'halloudek en deus graet traoù bras din; e anv a zo santel, ");
INSERT INTO breBRG_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","hag e drugarez en em astenn a oad en oad war ar re a zouj anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Diskouezet en deus nerzh e vrec'h; stlabezet en deus ar soñjezonoù a rae ar re lorc'hus en o c'halon. ");
INSERT INTO breBRG_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Didronet en deus ar re c'halloudek, ha savet en deus ar re vihan. ");
INSERT INTO breBRG_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Leuniet en deus a vadoù a re o devoa naon, ha kaset en deus kuit ar re binvidik er goullo. ");
INSERT INTO breBRG_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sikouret en deus Israel e servijer, o kaout soñj eus e drugarez, ");
INSERT INTO breBRG_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","evel m'en devoa e lavaret d'hon tadoù, da Abraham ha d'e lignez da viken. ");
INSERT INTO breBRG_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari a chomas gant Elizabed war-dro tri miz; neuze e tistroas d'he zi. ");
INSERT INTO breBRG_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Neuze, amzer Elizabed o vezañ deuet, e c'hanas ur mab. ");
INSERT INTO breBRG_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","He amezeien hag he c'herent, o vezañ anavezet penaos en devoa an Aotrou diskouezet e drugarez en he c'heñver, en em laouenajont ganti. ");
INSERT INTO breBRG_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","O vezañ deuet an eizhvet deiz evit amdroc'hañ ar bugel, e c'halvjont anezhañ Zakaria, eus anv e dad. ");
INSERT INTO breBRG_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Met e vamm, o kemer ar gomz, a lavaras: Nann, met Yann e vo galvet. ");
INSERT INTO breBRG_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hag e lavarjont dezhi: N'eus den ez kerentiezh hag a zo galvet eus an anv-se. ");
INSERT INTO breBRG_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Neuze e c'houlennjont dre sin ouzh e dad penaos e felle dezhañ e vije galvet. ");
INSERT INTO breBRG_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaria, o vezañ goulennet taolennoùigoù, a skrivas ar gerioù-mañ: Yann eo e anv. Hag an holl a voe souezhet. ");
INSERT INTO breBRG_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kerkent e c'henou a zigoras, e deod a ziereas, hag e komze en ur veuliñ Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","O holl amezeien a voe leuniet a spont, hag an holl draoù-mañ en em vrude dre holl venezioù Judea. ");
INSERT INTO breBRG_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","An holl re o c'hleve, o mire en o c'halon, hag e lavarent: Petra eta e vo ar bugel bihan-se? Ha dorn an Aotrou a oa warnañ. ");
INSERT INTO breBRG_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Neuze Zakaria e dad a voe leuniet eus ar Spered-Santel, hag e tiouganas, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Benniget ra vo an Aotrou, Doue Israel, dre ma'z eo deuet da welout ha da zasprenañ e bobl, ");
INSERT INTO breBRG_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","hag abalamour m'en deus savet deomp ur Salver Galloudek e tiegezh David e servijer, ");
INSERT INTO breBRG_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","evel m'en devoa lavaret dre c'henou e brofeded santel, abaoe penn-kentañ ar bed, ");
INSERT INTO breBRG_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","dre m'en deus hor saveteet a zaouarn hon enebourien, hag eus dorn an holl re a gasae ac'hanomp, ");
INSERT INTO breBRG_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","evit ober trugarez e-keñver hon tadoù, o kaout soñj eus e emglev santel, ");
INSERT INTO breBRG_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","eus al le en devoa graet da Abraham hon tad, ");
INSERT INTO breBRG_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","penaos, o vezañ hon tennet eus dorn hon enebourien, e roje deomp da servijañ anezhañ hep aon, ");
INSERT INTO breBRG_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","er santelezh hag er reizhder dirazañ e-pad holl deizioù hor buhez. ");
INSERT INTO breBRG_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ha te, bugel bihan, ta a vo galvet profed an Uhelañ-Meurbet; rak te a gerzho dirak dremm an Aotrou, evit kempenn e hentoù, ");
INSERT INTO breBRG_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","evit reiñ anaoudegezh ar silvidigezh d'e bobl dre pardon eus o fec'hedoù, ");
INSERT INTO breBRG_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","dre garantez trugarezus hon Doue; drezi, ar sav-heol eus an nec'h en deus hor gwelet, ");
INSERT INTO breBRG_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","evit sklêrijennañ ar re a zo azezet en deñvalijenn hag e skeud ar marv, hag evit ren hor c'hammedoù e hent ar peoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ar bugel bihan a greske hag en em greñvae er spered; hag e chomas el lec'hioù distro betek an deiz ma tlee bezañ diskouezet da Israel. ");
INSERT INTO breBRG_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","En amzer-se e voe embannet ul lezenn a-berzh Kezar-Aogust, evit ma vije graet ar gont eus tud ar bed holl. ");
INSERT INTO breBRG_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ar gont kentañ-se a voe graet e-pad ma oa Kiriniuz gouarner Siria. ");
INSERT INTO breBRG_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dre-se an holl a yae evit lakaat o anv, pep hini en e gêr. ");
INSERT INTO breBRG_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jozef ivez a bignas eus Galilea da Judea, eus kêr Nazared da gêr David anvet Betlehem, dre ma oa eus tiegezh hag eus familh David, ");
INSERT INTO breBRG_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","evit reiñ e anv gant Mari e wreg, hag a oa dougerez. ");
INSERT INTO breBRG_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","E-pad ma oant eno, an amzer ma tlee gwilioudiñ a erruas, ");
INSERT INTO breBRG_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","hag e c'hanas he mab kentañ-ganet, hag e mailhuras anezhañ, hag e lakaas anezhañ en ur c'hraou, abalamour ne oa ket plas evito en ostaleri. ");
INSERT INTO breBRG_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bez' e oa er memes korn-bro mêsaerien a gouske er parkeier, hag a ziwalle o loened e-pad beilhadennoù an noz. ");
INSERT INTO breBRG_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Setu un ael eus an Aotrou en em ziskouezas dezho ha gloar an Aotrou a lugernas en-dro dezho, hag o devoe ur spont bras. ");
INSERT INTO breBRG_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Neuze an ael a lavaras dezho: N'ho pet ket aon, rak setu e tegasan deoc'h ur c'heloù mat, a vo un abeg a levenez vras evit an holl bobl, ");
INSERT INTO breBRG_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","rak ganet eo hiziv deoc'h, e kêr David, ur Salver, hag a zo ar C'hrist, an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Setu amañ ur sin deoc'h: c'hwi a gavo ur bugel bihan mailhuret ha gourvezet en ur c'hraou. ");
INSERT INTO breBRG_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ha kerkent e voe gant an ael ul lod bras eus arme an neñv, o veuliñ hag o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Gloar da Zoue el lec'hioù uhel-meurbet, ha peoc'h war an douar e-touez an dud karet gantañ! ");
INSERT INTO breBRG_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pa voe en em dennet an aeled diganto en neñv, ar vêsaerien a lavaras an eil d'egile: Deomp eta betek Betlehem, ha gwelomp ar pezh a zo c'hoarvezet, hag en deus an Aotrou roet da anavezout deomp. ");
INSERT INTO breBRG_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mont a rejont eta buan di, hag e kavjont Mari, Jozef hag ar bugel bihan a oa gourvezet er c'hraou. ");
INSERT INTO breBRG_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","O vezañ e welet, e tisklêrjont ar pezh a oa bet lavaret dezho diwar-benn ar bugel bihan-se. ");
INSERT INTO breBRG_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","An holl re o c'hleve a oa souezhet bras eus ar pezh a oa bet lavaret dezho gant ar vêsaerien. ");
INSERT INTO breBRG_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari a vire an holl draoù-se, o tistremen anezho en he c'halon. ");
INSERT INTO breBRG_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hag ar vêsaerien a zistroas, en ur reiñ gloar ha meuleudi da Zoue, evit kement o devoa klevet ha gwelet, hervez ma oa bet lavaret dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pa voe deuet an eizhvet devezh evit amdroc'hañ ar bugel, e voe galvet JEZUZ, anv a oa bet roet dezhañ gant an ael, a-raok ma oa koñsevet e kof e vamm. ");
INSERT INTO breBRG_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ha pa voe deuet, hervez lezenn Moizez, an deizioù dezho da vezañ glanaet, e voe kaset ar bugel da Jeruzalem, evit e ginnig d'an Aotrou ");
INSERT INTO breBRG_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(hervez ma'z eo skrivet e lezenn an Aotrou: Pep paotr kentañ-ganet a vo gouestlet da Zoue), ");
INSERT INTO breBRG_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","hag evit kinnig en aberzh, hervez ar pezh a zo skrivet e lezenn an Aotrou, ur re durzhunelled, pe ziv goulmig. ");
INSERT INTO breBRG_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bez' e oa e Jeruzalem un den anvet Simeon; an den-se a oa reizh hag a zouje Doue; gortoz a rae frealz Israel, hag ar Spered-Santel a oa warnañ. ");
INSERT INTO breBRG_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Disklêriet e voe dezhañ a-berzh Doue dre ar Spered-Santel, penaos ne varvje ket, a-raok m'en dije gwelet Krist an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dont a reas en templ dre ar Spered, hag evel ma oa an tad hag ar vamm o tegas ar bugel bihan Jezuz, evit ober en e geñver hervez giz al lezenn, ");
INSERT INTO breBRG_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","e kemeras anezhañ etre e zivrec'h, hag e veulas Doue, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Aotrou, laosk bremañ da servijer da vont e peoc'h, hervez da c'her, ");
INSERT INTO breBRG_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","rak va daoulagad o deus gwelet da silvidigezh, ");
INSERT INTO breBRG_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","an hini ac'h eus graet dirak an holl bobloù, ");
INSERT INTO breBRG_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ar sklêrijenn a dle sklaeriañ an holl dud, ha gloar da bobl Israel. ");
INSERT INTO breBRG_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ha Jozef hag e vamm a oa souezhet eus an traoù a lavared anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon o bennigas, hag a lavaras da Vari, e vamm: Setu, ar bugel-se a zo lakaet da vezañ kouezhadenn hag adsavidigezh evit kalz en Israel, ha da vezañ ur sin eus enebiezh, ");
INSERT INTO breBRG_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","en hevelep doare ma vo soñjezonoù kalon kalz dizoloet; hag evidout-te, ur c'hleze a dreuzo da ene. ");
INSERT INTO breBRG_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bez' e oa ivez eno Anna ar brofedez, merc'h Fanuel, eus meuriad Aser; oadet bras e oa, hag he devoa bevet gant he fried seizh vloaz, abaoe he gwerc'hded. ");
INSERT INTO breBRG_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chomet e oa intañvez, oadet a bevar bloaz ha pevar ugent pe war-dro, n'ae ket er-maez eus an templ, o servijañ Doue noz-deiz er yunoù hag er pedennoù. ");
INSERT INTO breBRG_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","O vezañ deuet d'an eur-mañ, e veule ivez an Aotrou, hag e komze diwar-benn Jezuz ouzh an holl dud eus Jeruzalem a c'hortoze an daspren. ");
INSERT INTO breBRG_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Goude m'o devoe graet pep tra hervez lezenn an Aotrou, e tistrojont e Galilea, da Nazared, o c'hêr. ");
INSERT INTO breBRG_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hag ar bugel a greske hag en em nerzhe e spered, o vezañ leuniet a furnez; ha gras Doue a oa warnañ. ");
INSERT INTO breBRG_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E dad hag e vamm a yae beb bloaz da Jeruzalem, da c'houel ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","P'en devoe Jezuz daouzek vloaz, e pignjont da Jeruzalem, hervez giz ar gouel. ");
INSERT INTO breBRG_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pa voe deizioù ar gouel tremenet, evel ma tistroent ac'hane, ar bugel Jezuz a chomas e Jeruzalem; Jozef hag e vamm n'anavezjont ket-se. ");
INSERT INTO breBRG_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Met, o soñjal e oa en o zouez, e valejont un devezh; neuze e klaskjont anezhañ e-touez o c'herent hag ar re eus o anaoudegezh; ");
INSERT INTO breBRG_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pa n'en kavent ket, e tistrojont da Jeruzalem d'e glask. ");
INSERT INTO breBRG_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hag a-benn tri devezh e kavjont anezhañ en templ, azezet e-touez an doktored, o selaou anezho hag oc'h ober goulennoù outo. ");
INSERT INTO breBRG_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kement hini a gleve anezhañ a oa souezhet gant e furnez hag e respontoù. ");
INSERT INTO breBRG_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pa welas e dud anezhañ, e voent souezhet, hag e vamm a lavaras dezhañ: Va bugel, perak ec'h eus graet evel-se deomp? Setu, da dad ha me, en glac'har, a glaske ac'hanout. ");
INSERT INTO breBRG_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eñ a lavaras dezho: Perak em c'hlaskec'h? N'ouiec'h ket eo ret din bezañ dalc'het gant labourioù va Zad? ");
INSERT INTO breBRG_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Met int ne gomprenjont ket ar pezh a lavare dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mont a reas neuze ganto hag e teuas da Nazared, hag e touje dezho. E vamm a vire an holl draoù-se en he c'halon. ");
INSERT INTO breBRG_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jezuz a greske e furnez, e ment, hag e gras, dirak Doue ha dirak an dud. ");
INSERT INTO breBRG_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ar bemzekvet bloavezh eus impalaerded Tiberius Kezar, Poñs-Pilat o vezañ gouarner Judea, Herodez tetrark Galilea, Filip e vreur tetrark Iturea ha Trakonitiz, Lisaniaz tetrark Abilen, ");
INSERT INTO breBRG_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","dindan belegiezh veur Annaz ha Kaifaz, ger Doue a voe kaset da Yann, mab Zakaria, el lec'h distro. ");
INSERT INTO breBRG_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yann a zeuas en holl vro war-dro ar Jordan, o prezeg badeziant ar geuzidigezh evit pardon ar pec'hedoù, ");
INSERT INTO breBRG_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","evel ma'z eo skrivet e levr lavarioù ar profed Izaia: Mouezh an hini a gri el lec'h distro a lavar: Kempennit hent an Aotrou, plaenait e wenodennoù. ");
INSERT INTO breBRG_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pep traonienn a vo leuniet, pep menez ha krec'hienn a vo izelaet; an hentoù gwariet a vo eeunaet, hag ar re dorgennek a vo kompezet; ");
INSERT INTO breBRG_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ha pep kig a welo silvidigezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lavarout a rae eta d'ar bobl a zeue evit bezañ badezet gantañ: Lignez a naered-wiber, piv en deus desket deoc'h tec'hout diouzh ar gounnar da zont? ");
INSERT INTO breBRG_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dougit eta frouezh dereat d'ar geuzidigezh, ha n'en em lakait ket da lavarout ennoc'h hoc'h-unan: Ni hon eus evit tad Abraham; rak me a lavar deoc'h, e c'hell Doue ober genel eus ar vein-se bugale da Abraham. ");
INSERT INTO breBRG_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ar vouc'hal a zo a-vremañ lakaet ouzh gwrizioù ar gwez. Pep gwezenn eta na ro ket frouezh mat, a ya da vezañ troc'het ha taolet en tan. ");
INSERT INTO breBRG_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Neuze ar bobl a c'houlennas digantañ: Petra a raimp eta? ");
INSERT INTO breBRG_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eñ a respontas dezho: An neb en deus daou gwiskamant, ra roio unan d'an hini n'en deus ket. ");
INSERT INTO breBRG_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dont a reas ivez publikaned evit bezañ badezet, hag e lavarjont dezhañ: Mestr, petra a raimp? ");
INSERT INTO breBRG_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eñ a lavaras dezho: Na gemerit ket en tu-hont d'ar pezh a zo gourc'hemennet deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soudarded a c'houlennas ivez digantañ: Ha ni, petra a raimp? Eñ a lavaras dezho: Na wallgasit den ha na damallit den e gaou, met tremenit gant ho pae. ");
INSERT INTO breBRG_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Evel ma oa ar bobl o c'hortoz, ha ma c'houlenne an holl en o c'halon hag eñ ne oa ket Yann ar C'hrist, ");
INSERT INTO breBRG_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yann en em lakaas da lavarout d'an holl: Me ho padez en dour, met unan all a zeu, galloudusoc'h egedon, ha n'on ket dellezek da zieren korreenn e votoù. Eñ ho padezo er Spered-Santel hag en tan. ");
INSERT INTO breBRG_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","E grouer a zo en e zaouarn, naetaat a raio mat e leur, hag e tastumo ar gwinizh en e solier, met ar pell a zevo en tan na varv ket. ");
INSERT INTO breBRG_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Eñ a lavare meur a gelennadurezh all d'ar bobl, o prezeg dezho an Aviel. ");
INSERT INTO breBRG_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Met Herodez an tetrark, o vezañ bet tamallet gant Yann diwar-benn Herodiaz, gwreg Filip e vreur, ha diwar-benn an holl draoù fall en devoa graet, ");
INSERT INTO breBRG_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","a reas goude an holl draoù fall all, an hini da lakaat Yann er prizon. ");
INSERT INTO breBRG_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Evel ma rae an holl bobl en em vadeziñ gantañ, Jezuz a voe ivez badezet; hag e-pad ma pede, an neñv a zigoras, ");
INSERT INTO breBRG_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","hag ar Spered-Santel a ziskennas warnañ e doare ur c'horf, evel hini ur goulm; hag ur vouezh a zeuas eus an neñv, o lavarout: Te eo va Mab karet-mat, ennout em eus lakaet va holl levenez. ");
INSERT INTO breBRG_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jezuz a oa oadet war-dro tregont vloaz p'en em lakaas da brezeg, hag e oa, evel ma kreded, mab da Jozef, mab Heli, ");
INSERT INTO breBRG_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mab Matat, mab Levi, mab Melki, mab Jannai, mab Jozef, ");
INSERT INTO breBRG_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mab Matatiaz, mab Amoz, mab Nahum, mab Esli, mab Naggai, ");
INSERT INTO breBRG_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mab Maaz, mab Mataziaz, mab Semein, mab Jozef, mab Juda, ");
INSERT INTO breBRG_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mab Joanan, mab Resa, mab Zorobabel, mab Salatiel, mab Neri, ");
INSERT INTO breBRG_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mab Melki, mab Addi, mab Kosam, mab Elmodam, mab Er, ");
INSERT INTO breBRG_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mab Joze, mab Eliezer, mab Jorim, mab Mazat, mab Levi, ");
INSERT INTO breBRG_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mab Simeon, mab Juda, mab Jozef, mab Jonam, mab Eliakim, ");
INSERT INTO breBRG_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mab Melea, mab Mainan, mab Mattaza, mab Natan, mab David, ");
INSERT INTO breBRG_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mab Jese, mab Obed, mab Booz, mab Salmon, mab Naason, ");
INSERT INTO breBRG_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mab Aminadab, mab Aram, mab Joram, mab Ezrom, mab Farez, mab Juda, ");
INSERT INTO breBRG_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mab Jakob, mab Izaak, mab Abraham, mab Tara, mab Nac'hor, ");
INSERT INTO breBRG_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mab Seruk, mab mab Ragav, mab Faleg, mab Eber, mab Sala, ");
INSERT INTO breBRG_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mab Kainam, mab Arpaksad, mab Sem, mab Noe, mab Lamec'h, ");
INSERT INTO breBRG_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mab Matuzala, mab Enoc'h, mab Jared, mab Maleleel, mab Kainan, ");
INSERT INTO breBRG_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mab Enoz, mab Set, mab Adam, mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jezuz, leuniet eus ar Spered-Santel, a zistroas eus ar Jordan, hag a voe kaset gant ar Spered el lec'h distro; ");
INSERT INTO breBRG_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","eno e voe temptet gant an diaoul e-pad daou-ugent devezh, ha ne zebras netra e-pad an deizioù-se; goude ma voent tremenet, en devoa naon. ");
INSERT INTO breBRG_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Neuze an diaoul a lavaras dezhañ: Mar dout Mab Doue, gourc'hemenn d'ar maen-mañ dont da vezañ bara. ");
INSERT INTO breBRG_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jezuz a respontas dezhañ: Skrivet eo: An den ne vevo ket a vara hepken, met gant pep ger a zeu eus Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Neuze an diaoul en kasas war ur menez uhel, a reas dezhañ gwelout en un taol holl rouantelezhioù ar bed, ");
INSERT INTO breBRG_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","hag a lavaras dezhañ: Reiñ a rin dit an holl c'halloud-se ha gloar ar rouantelezhioù-se, rak roet eo bet din, hag e roan anezhañ da neb a fell din. ");
INSERT INTO breBRG_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma taoulinez eta dirazon, an holl draoù-se a vo dit. ");
INSERT INTO breBRG_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jezuz a respontas dezhañ: A-dreñv din, Satan! Rak skrivet eo: Azeuliñ a ri an Aotrou da Zoue, ha ne serviji nemetañ. ");
INSERT INTO breBRG_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kas a reas anezhañ ivez da Jeruzalem, hag e lakaas anezhañ war lein an templ, hag e lavaras dezhañ: Mar dout Mab Doue, en em daol ac'han d'an traoñ, rak skrivet eo ");
INSERT INTO breBRG_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","e c'hourc'hemenno d'e aeled kaout evezh ouzhit, evit da ziwall, ");
INSERT INTO breBRG_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ha penaos e tougint ac'hanout etre o daouarn, gant aon na stokfe da droad ouzh ur maen bennak. ");
INSERT INTO breBRG_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jezuz a respontas dezhañ: Lavaret eo: Na dempti ket an Aotrou da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","An diaoul, o vezañ echuet an holl demptadur, en em dennas dioutañ evit un amzer. ");
INSERT INTO breBRG_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jezuz a zistroas da C'halilea, dindan galloud ar Spered, hag ar vrud anezhañ a redas dre an holl vro tro-war-dro. ");
INSERT INTO breBRG_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kelenn a rae en o sinagogennoù, hag e oa enoret gant an holl. ");
INSERT INTO breBRG_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jezuz a zeuas da Nazared, e-lec'h ma oa bet savet, hag ez eas, hervez e c'hiz, er sinagogenn deiz ar sabad. Sevel a reas evit lenn. ");
INSERT INTO breBRG_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Neuze e voe roet dezhañ levr ar profed Izaia, hag o vezañ displeget al levr, e kavas al lec'h ma oa skrivet ennañ: ");
INSERT INTO breBRG_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Spered an Aotrou a zo warnon; abalamour da-se en deus va eouliet evit prezeg an Aviel d'ar beorien; kaset en deus ac'hanon evit yac'haat ar re o deus ar c'halon flastret, evit embann an dasprenadur d'ar re dalc'het, ha distro ar gweled d'ar re dall, da gas er frankiz ar re gwasket, ");
INSERT INTO breBRG_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ha da embann bloavezh trugarezus an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Goude bezañ pleget al levr hag e roet d'ar servijer, ec'h azezas; daoulagad an holl er sinagogenn a selle pizh outañ. ");
INSERT INTO breBRG_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Neuze en em lakaas da lavarout dezho: Ar gomz-mañ eus ar Skritur a zo peurc'hraet hiziv, hag he c'hlevet hoc'h eus. ");
INSERT INTO breBRG_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","An holl a roe testeni dezhañ, hag a oa souezhet eus ar c'homzoù a c'hras a zeue eus e c'henou, hag e lavarent: N'eo ket hemañ mab Jozef? ");
INSERT INTO breBRG_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eñ a lavaras dezho: Hep mar e lavarot din ar c'hrennlavar-mañ: Medisin, en em yac'ha da-unan; gra ivez amañ, e-barzh da vro, kement hon eus klevet lavarout ac'h eus graet e Kafarnaoum. ");
INSERT INTO breBRG_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Met eñ a lavaras dezho: Me a lavar deoc'h e gwirionez penaos profed ebet n'eo degemeret mat en e vro. ");
INSERT INTO breBRG_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Me a lavar deoc'h e gwirionez: bez' e oa kalz a intañvezed en Israel en amzer Elia, pa voe serret an neñv e-pad tri bloaz ha c'hwec'h miz, kement ken e voe un naonegezh vras dre an holl vro. ");
INSERT INTO breBRG_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Koulskoude Elia ne voe ket kaset da di hini anezho, nemet da di un intañvez eus Sarepta, e Sidon. ");
INSERT INTO breBRG_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bez' e oa ivez kalz a dud lovr en Israel en amzer Elizea ar profed; koulskoude hini anezho ne oa glanaet, nemet Naaman ar Siriad. ");
INSERT INTO breBRG_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","An holl re a oa er sinagogenn, o klevout kement-se, a yeas droug enno. ");
INSERT INTO breBRG_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hag o vezañ savet, e kasjont anezhañ kuit eus o c'hêr, hag e lakajont anezhañ war lein ar menez ma oa savet o c'hêr warnañ, evit e deurel d'an traoñ. ");
INSERT INTO breBRG_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Met eñ, o tremen dre o c'hreiz, a yeas kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Neuze e tiskennas da Gafarnaoum, kêr eus Galilea, hag e kelenne an dud d'an deizioù ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Souezhet e oant eus e gredenn, rak komz a rae gant galloud. ");
INSERT INTO breBRG_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bez' e oa er sinagogenn un den dalc'het gant ur spered a ziaoul hudur, hag a grie gant ur vouezh uhel: ");
INSERT INTO breBRG_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","A! Petra a zo etre te ha ni, Jezuz a Nazared? Ha deuet out evit hor c'holl? Me a oar piv out: Sant Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jezuz a c'hourdrouzas anezhañ, o lavarout: Tav, ha kae eus an den-se. An diaoul, o vezañ e stlapet er c'hreiz, a yeas kuit anezhañ, hep ober droug ebet dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Spouronet e voent holl, hag e lavarent etrezo: Petra eo kement-mañ? Gourc'hemenn a ra gant galloud ha nerzh d'ar speredoù hudur, hag ez eont kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hag ar vrud anezhañ a yeas e pep lec'h er vro tro-war-dro. ");
INSERT INTO breBRG_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jezuz, o vezañ aet er-maez eus ar sinagogenn, a yeas e ti Simon. Mamm-gaer Simon he devoa ur gwall derzhienn, hag e pedjont anezhañ eviti. ");
INSERT INTO breBRG_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","O vezañ eta aet a-us dezhi, e c'hourc'hemennas d'an derzhienn paouez, hag an derzhienn a yeas kuit diouti; kerkent, hi a savas hag a servijas anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pa voe kuzhet an heol, an holl re o devoa re glañv dalc'het gant meur a gleñvedoù, o degase dezhañ; eñ a yac'hae anezho holl en ur lakaat e zaouarn war bep hini anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","An diaoulien ivez a yae er-maez eus kalz, o krial hag o lavarout: Te eo ar C'hrist, Mab Doue; met eñ o gourdrouze, ha ne leze ket anezho da lavarout e ouient e oa ar C'hrist ");
INSERT INTO breBRG_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Adalek ma teuas an deiz, ez eas d'ul lec'h distro; ur bobl vras en klaske hag a zeuas betek ennañ, hag a c'hoantae en derc'hel, evit n'o c'huitaje ket. ");
INSERT INTO breBRG_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Met eñ a lavaras dezho: Ret eo din ivez prezeg keloù mat rouantelezh Doue d'ar c'hêrioù all, rak evit-se eo on bet kaset. ");
INSERT INTO breBRG_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hag e prezege e sinagogennoù Galilea. ");
INSERT INTO breBRG_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Evel ma oa Jezuz war aod lenn Genezared, ar bobl en em daole warnañ evit klevout ger Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Gwelout a reas div vag en tu all d'ar mor; ar besketaerien a oa diskennet hag a walc'he o rouedoù. ");
INSERT INTO breBRG_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pignat a reas en unan eus ar bagoù-se, hini a oa da Simon, hag e pedas anezhañ da bellaat un tamm diouzh an douar; o vezañ azezet, e kelenne ar bobl diwar ar vag. ");
INSERT INTO breBRG_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","P'en devoe paouezet da gomz, e lavaras da Simon: Kae a-raokoc'h en dour don, ha taolit ho rouedoù evit pesketa. ");
INSERT INTO breBRG_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon a respontas dezhañ: Mestr, ni hon eus labouret e-pad an noz hep tapout netra; koulskoude, war da c'her, e taolin ar roued. ");
INSERT INTO breBRG_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","O vezañ en graet, e tapjont un niver bras a besked; evel ma torre o rouedoù, ");
INSERT INTO breBRG_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","e rejont sin d'o c'henvreudeur hag a oa er vag all, da zont d'o sikour. Dont a rejont hag e leugnjont an div vag, en hevelep doare ma'z aent d'ar foñs. ");
INSERT INTO breBRG_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pêr, o vezañ gwelet kement-se, en em strinkas d'an daoulin ouzh treid Jezuz, hag a lavaras: Aotrou, pella diouzhin, rak ur pec'her on. ");
INSERT INTO breBRG_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Rak ar spont a oa kroget ennañ hag en holl re a oa gantañ, abalamour d'ar pesketaerezh o devoa graet, ");
INSERT INTO breBRG_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","kenkoulz evel e Jakez ha Yann, mibien Zebedea, kenvreudeur da Simon. Neuze Jezuz a lavaras da Simon: Na'z pez ket aon, a-vremañ e vi pesketaer tud. ");
INSERT INTO breBRG_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hag o vezañ degaset o bagoù d'an douar, e kuitajont pep tra, hag e heuilhjont anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Evel ma oa en ur gêr eus Galilea, un den goloet a lovrentez, o vezañ gwelet Jezuz, en em strinkas war e c'henou ouzh an douar, hag en pedas, o lavarout: Aotrou, mar fell dit, e c'hellez va glanaat. ");
INSERT INTO breBRG_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jezuz, oc'h astenn e zorn, en stokas hag a lavaras dezhañ: Fellout a ra din, bez glanaet. Ha kerkent al lovrentez a guitaas anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jezuz a zifennas outañ n'en lavarje da zen. Met kae, a lavaras dezhañ, en em ziskouez d'ar beleg ha kinnig evit da c'hlanidigezh ar pezh en deus Moizez gourc'hemennet, evit ma servijo kement-se da desteni dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ar vrud anezhañ en em skuilhe muioc'h-mui, ha kalz a dud en em zastume evit e glevout hag evit bezañ yac'haet gantañ eus o c'hleñvedoù. ");
INSERT INTO breBRG_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Met eñ en em zalc'he a-du el lec'hioù distro, evit pediñ. ");
INSERT INTO breBRG_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Un devezh ma kelenne, ha ma oa azezet eno farizianed ha doktored al lezenn deuet eus holl vourc'hioù Galilea, eus Judea hag eus Jeruzalem, galloud an Aotrou a oberie evit yac'haat ar re glañv. ");
INSERT INTO breBRG_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Neuze e teuas tud a zouge war ur gwele un den seizet, hag e klaskent mont en ti hag e lakaat dirak Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pa ne ouient dre belec'h e gas e-barzh, abalamour d'ar bobl, e pignjont war an ti, hag en diskennjont dre an teol gant e wele, e-kreiz ar bobl, dirak Jezuz; ");
INSERT INTO breBRG_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eñ, o welout o feiz, a lavaras dezhañ: O den, da bec'hedoù a zo pardonet dit. ");
INSERT INTO breBRG_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Neuze ar skribed hag ar farizianed en em lakaas da c'hrozmolat ha da lavarout: Piv eo hemañ hag a wallgomz? Piv a c'hell pardoniñ ar pec'hedoù, nemet Doue hepken? ");
INSERT INTO breBRG_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Met Jezuz, oc'h anavezout o soñjezonoù, a gemeras ar gomz hag a lavaras dezho: Petra a c'hrozmolit en ho kalonoù? ");
INSERT INTO breBRG_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Petra eo an aesoc'h, lavarout: Da bec'hedoù a zo pardonet dit, pe lavarout: Sav ha bale? ");
INSERT INTO breBRG_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Met, evit ma ouiot penaos Mab an den en deus war an douar ar galloud da bardoniñ ar pec'hedoù, -e lavaras d'an den seizet-: Me en lavar dit, sav, doug da wele, ha kae da'z ti. ");
INSERT INTO breBRG_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ha raktal e savas dirazo, e tougas ar gwele ma oa gourvezet warnañ, hag ez eas d'e di, o reiñ gloar da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hag e voent holl souezhet bras, hag e roent gloar da Zoue; leuniet e voent a zoujañs hag e lavarent: Ni hon eus gwelet hiziv traoù burzhudus. ");
INSERT INTO breBRG_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Goude-se, e teuas hag e welas ur publikan anvet Levi, azezet e ti ar gwirioù, hag e lavaras dezhañ: Deus war va lerc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eñ, o kuitaat pep tra, a savas hag a heulias anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi a reas ur fest vras en e di, hag un niver bras a bublikaned hag a dud all a oa ouzh taol ganto. ");
INSERT INTO breBRG_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ar re anezho a oa skribed ha farizianed a c'hrozmole hag a lavare d'e ziskibien: Perak e tebrit hag ec'h evit gant ar bublikaned ha gant an dud a vuhez fall? ");
INSERT INTO breBRG_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jezuz, o kemer ar gomz, a lavaras dezho: N'eo ket ar re a zo yac'h eo ar re o deus ezhomm a vedisin, met ar re a zo klañv. ");
INSERT INTO breBRG_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N'on ket deuet da c'hervel d'ar geuzidigezh ar re reizh, met ar bec'herien. ");
INSERT INTO breBRG_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lavarout a rejont ivez dezhañ: Perak e yun alies diskibien Yann hag e reont pedennoù, kenkoulz evel re ar farizianed, e-lec'h da re-te a zebr hag a ev? ");
INSERT INTO breBRG_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eñ a lavaras dezho: Ha c'hwi a c'hell lakaat da yunañ mignoned ar pried, e-pad ma'z emañ ar pried ganto? ");
INSERT INTO breBRG_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Met deizioù a zeuio ma vo lamet ar pried diganto; neuze e yunint, en deizioù-se. ");
INSERT INTO breBRG_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lavarout a reas ivez dezho ur barabolenn: Den ne laka un tamm eus ur gwiskamant nevez war ur gwiskamant kozh, rak e freuzfe an hini nevez, hag an tamm kemeret eus an hini nevez n'en em rafe ket gant an hini kozh. ");
INSERT INTO breBRG_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Den ne laka gwin nevez e seier-lêr kozh, rak ar gwin nevez a dorrfe ar seier kozh hag en em skuilhfe, hag ar seier a vefe kollet. ");
INSERT INTO breBRG_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Met ar gwin nevez a zle bezañ lakaet e seier nevez, hag an daou en em vir a-unan. ");
INSERT INTO breBRG_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ha n'eus den a ev gwin kozh hag a c'houlenn gwin nevez, rak lavarout a ra: Gwell eo an hini kozh. ");
INSERT INTO breBRG_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","C'hoarvezout a reas, e-pad an eil-kentañ sabad, ma tremene Jezuz dre barkeier ed; e ziskibien a ziframme tañvouezennoù, hag, o vezañ o gwasket en o daouarn, e tebrent anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hiniennoù eus ar farizianed a lavaras dezhañ: Perak e rit ar pezh n'eo ket aotreet ober deizioù ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Neuze Jezuz, o kemer ar gomz, a lavaras dezho: N'hoc'h eus ket lennet ar pezh a reas David hag ar re a oa gantañ, p'o devoa naon? ");
INSERT INTO breBRG_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Penaos ez eas e ti Doue, e kemeras hag e tebras ar baraoù a ginnig, hag o roas memes d'ar re a oa gantañ, petra bennak ne c'helle o debriñ nemet ar veleien hepken? ");
INSERT INTO breBRG_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hag e lavaras dezho: Mab an den a zo mestr memes war ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","C'hoarvezout a reas ivez, un deiz sabad all, ma'z eas er sinagogenn, ha ma kelenne enni; hag e oa eno un den, ma oa disec'het e zorn dehou. ");
INSERT INTO breBRG_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ar skribed hag ar farizianed a selle outañ, evit gwelout hag eñ a yac'hafe deiz ar sabad, evit kaout peadra d'e damall. ");
INSERT INTO breBRG_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Met evel ma'c'h anaveze o soñjezonoù, e lavaras d'an den en devoa an dorn disec'het: Sav hag en em zalc'h aze er c'hreiz. Eñ, o vezañ savet, en em zalc'has en e sav. ");
INSERT INTO breBRG_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jezuz a lavaras dezho eta: Un dra a c'houlennin ouzhoc'h: hag aotreet eo, e deizioù ar sabad, ober vad pe droug, saveteiñ un den pe e lezel da goll? ");
INSERT INTO breBRG_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Neuze, o sellout ouzh an holl re a oa en-dro dezhañ, e lavaras d'an den: Astenn da zorn. Ober a reas, hag e zorn a zeuas yac'h evel egile. ");
INSERT INTO breBRG_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Int a voe leuniet a fulor, hag en em guzulient war ar pezh a c'helljent ober da Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","En amzer-se, Jezuz a yeas war ar menez evit pediñ, hag e tremenas an noz holl o pediñ Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pa voe deuet ar beure, e c'halvas e ziskibien, hag e tibabas daouzek anezho a c'halvas ebestel: ");
INSERT INTO breBRG_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, ma roas an anv a Bêr dezhañ; Andrev e vreur; Jakez ha Yann; Filip ha Bartolome; ");
INSERT INTO breBRG_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mazhev ha Tomaz; Jakez mab Alfe, ha Simon anvet Gredus; ");
INSERT INTO breBRG_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jud kar da Jakez; ha Judaz Iskariod, a oa an hini en gwerzhas. ");
INSERT INTO breBRG_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","O vezañ neuze diskennet ganto, e chomas en ur blaenenn gant e vandenn diskibien, hag ul lod bras a dud eus Judea, eus Jeruzalem, hag eus ar vro arvorek Tir ha Sidon. Deuet e oant evit e glevout hag evit bezañ yac'haet eus o c'hleñvedoù. ");
INSERT INTO breBRG_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ar re a oa dalc'het gant speredoù hudur a oa ivez yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hag an holl bobl a glaske stekiñ outañ, abalamour ma teue anezhañ un nerzh a yac'hae holl. ");
INSERT INTO breBRG_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Neuze Jezuz a savas e zaoulagad war e ziskibien, o lavarout: Eürus oc'h, c'hwi a zo paour, rak rouantelezh Doue a zo deoc'h! ");
INSERT INTO breBRG_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Eürus oc'h, c'hwi hoc'h eus naon bremañ, rak leuniet e viot! Eürus oc'h, c'hwi a ouel bremañ, rak karget e viot gant levenez! ");
INSERT INTO breBRG_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Eürus e viot, pa gasaio an dud ac'hanoc'h, pa gasint kuit ac'hanoc'h eus o zouez, pa lavarint dismegañs deoc'h ha pa daolint hoc'h anv evel fall, abalamour de Vab an den! ");
INSERT INTO breBRG_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","En em laouenait en amzer-se, ha tridit gant ar joa, rak ho kopr a vo bras en neñv, rak evel-se o deus graet o zadoù d'ar brofeded. ");
INSERT INTO breBRG_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Met gwalleur deoc'h-hu, tud pinvidik, rak c'hwi hoc'h eus bet ho kopr! ");
INSERT INTO breBRG_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gwalleur deoc'h-hu, tud leuniet, rak c'hwi ho po naon! Gwalleur deoc'h-hu, ar re a c'hoarzh bremañ, rak c'hwi en em c'hlac'haro hag a ouelo! ");
INSERT INTO breBRG_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Gwalleur deoc'h-hu pa lavaro an holl dud vad ac'hanoc'h, rak o zadoù o deus graet evel-se e-keñver ar fals-profeded! ");
INSERT INTO breBRG_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Met me a lavar deoc'h-hu, c'hwi hag am selaou: Karit hoc'h enebourien, grit vad d'ar re a gasa ac'hanoc'h, ");
INSERT INTO breBRG_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bennigit ar re a villig ac'hanoc'h, ha pedit evit ar re a wallgomz ouzhoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","D'an hini a sko ac'hanout war ur jod, tro eben outañ. D'an hini a zilam da vantell diganit, laosk ivez gantañ da doneg. ");
INSERT INTO breBRG_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ro da biv bennak a c'houlenn diganit, ha mar fell da unan bennak dilemel diganit ar pezh a zo dit, n'en adc'houlenn ket. ");
INSERT INTO breBRG_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ar pezh a fell deoc'h e rafe an dud deoc'h, grit ivez anezhañ dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ma ne garit nemet ar re ho kar, peseurt trugarez a dleer deoc'h? An dud a vuhez fall a gar ivez ar re o c'har. ");
INSERT INTO breBRG_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma ne rit vad nemet d'ar re a ra vad deoc'h, peseurt trugarez a dleer deoc'h? An dud a vuhez fall a ra ar memes tra. ");
INSERT INTO breBRG_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma ne brestit nemet d'ar re digant e c'hortozit kaout diganto, peseurt trugarez a dleer deoc'h? An dud a vuhez fall a brest ivez d'an dud a vuhez fall, evit kaout kement all. ");
INSERT INTO breBRG_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Met karit hoc'h enebourien, grit vad, ha prestit hep gortoz netra, hag ho kopr a vo bras, ha c'hwi a vo bugale an Uhelañ-Meurbet, abalamour ma'z eo mat e-keñver ar re dizanaoudek hag ar re fall. ");
INSERT INTO breBRG_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bezit eta trugarezus, evel ma'z eo ivez ho Tad trugarezus. ");
INSERT INTO breBRG_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na varnit ket, ha ne viot ket barnet; na gondaonit ket, ha ne viot ket kondaonet; pardonit, hag e viot pardonet; ");
INSERT INTO breBRG_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","roit, hag e vo roet deoc'h; roet e vo deoc'h en ho kerc'henn ur muzul mat, stardet hag hejet, a zeuio dreist ar barr; rak muzuliet e vo deoc'h gant an hevelep muzul ma vuzuilhit d'ar re all. ");
INSERT INTO breBRG_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lavarout a reas ivez dezho ur barabolenn: Daoust hag un den dall a c'hell ren un den dall? Ha ne gouezhint ket o daou er poull? ");
INSERT INTO breBRG_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","An diskibl n'eo ket uheloc'h eget e vestr; met pep diskibl mat a vo evel e vestr. ");
INSERT INTO breBRG_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Perak e sellez ouzh ar blouzenn a zo e lagad da vreur, ha ne welez ket an treust a zo ez lagad da-unan? ");
INSERT INTO breBRG_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pe, penaos e c'hellez lavarout da'z preur: Va breur, va lez da zilemel ar blouzenn a zo e-barzh da lagad, te na welez ket an treust ez hini? Pilpous, lam da gentañ an treust eus da lagad, ha neuze e weli penaos e lami ar blouzenn a zo e lagad da vreur. ");
INSERT INTO breBRG_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","N'eus gwezenn vat ebet hag a zougfe frouezh fall, na wezenn fall ebet hag a zougfe frouezh mat. ");
INSERT INTO breBRG_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Rak pep gwezenn a anavezer diouzh he frouezh hec'h-unan. Ne zastumer ket a fiez diwar ar spern, nag a rezin diwar an drez. ");
INSERT INTO breBRG_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An den mat a denn traoù mat eus teñzor mat e galon, hag an den fall a denn traoù fall eus teñzor fall e galon; rak eus leunder ar galon eo e komz ar genou. ");
INSERT INTO breBRG_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Perak eta e c'halvit ac'hanon Aotrou, Aotrou, ha ne rit ket ar pezh a lavaran? ");
INSERT INTO breBRG_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Me a ziskouezo deoc'h ouzh piv eo heñvel pep den hag a zeu da'm c'havout, a selaou va c'homzoù hag a sent outo. ");
INSERT INTO breBRG_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Heñvel eo ouzh un den a sav un ti, hag o vezañ kleuzet ha toullet don, en deus lakaet an diazez war ar roc'h; an doureier o vezañ deuet, ha skoet gant nerzh a-enep an ti-se, n'o deus ket gellet e ziskar, dre ma'z eo diazezet war ar roc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Met an hini a selaou ha ne sent ket, a zo heñvel ouzh un den a sav e di war an douar, hep diazez; an doureier o vezañ skoet gant nerzh a-enep dezhañ, kouezhet eo kerkent, ha diskar an ti-se a zo bet bras. ");
INSERT INTO breBRG_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Goude m'en devoa Jezuz peurlavaret ar c'homzoù-mañ dirak ar bobl a oa ouzh e selaou, ez eas e Kafarnaoum. ");
INSERT INTO breBRG_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mevel ur c'hantener, karet mat gantañ, a oa klañv, hag a yae da vervel. ");
INSERT INTO breBRG_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ar c'hantener, o vezañ klevet komz diwar-benn Jezuz, a gasas d'e gavout henaourien eus ar Yuzevien, da bediñ anezhañ da zont da yac'haat e servijer. ");
INSERT INTO breBRG_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ar re-mañ eta, o vezañ deuet da gavout Jezuz, a bedas anezhañ start en ur lavarout: Din eo ma rafes kement-se dezhañ, ");
INSERT INTO breBRG_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","rak karout a ra hor pobl; eñ eo, en deus lakaet sevel hor sinagogenn deomp. ");
INSERT INTO breBRG_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jezuz eta a yeas ganto. Ha pa ne oa ken pell eus an ti, ar c'hantener a gasas etrezek ennañ mignoned, da lavarout dezhañ: Aotrou, na gemer ket a boan, rak n'on ket din e teufes dindan va zoenn. ");
INSERT INTO breBRG_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Abalamour da-se, ne'm eus ket kavet e oan din va-unan da vont betek ennout; met lavar ur ger, ha va mevel a vo yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Rak me va-unan a zo un den lakaet dindan galloud re all, ha dindanon em eus soudarded, hag e lavaran da unan: Kae! hag ez a; d'egile: Deus! Hag e teu; ha da'm mevel: Gra kement-mañ! Hag en gra. ");
INSERT INTO breBRG_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jezuz, o vezañ klevet kement-se, a voe souezhet, hag, o tistreiñ, a lavaras d'ar bobl en heulie: Me a lavar deoc'h penaos ne'm eus ket kavet ur feiz ken bras, zoken en Israel. ");
INSERT INTO breBRG_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pa zistroas d'ar gêr ar re a oa bet kaset, e kavjont yac'h ar mevel a oa bet klañv. ");
INSERT INTO breBRG_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","An deiz war-lerc'h, Jezuz a yeas d'ur gêr anvet Nain; kalz eus e ziskibien hag ur bobl vras a yae gantañ. ");
INSERT INTO breBRG_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Evel ma tostaent ouzh dor kêr, setu e touged d'an douar unan marv, mab nemetañ e vamm, a oa intañvez; un niver bras a dud eus kêr a oa ganti. ");
INSERT INTO breBRG_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","An Aotrou, o vezañ he gwelet, en devoe truez outi, hag a lavaras dezhi: Na ouel ket! ");
INSERT INTO breBRG_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","O vezañ tostaet, e stokas an arched, hag ar re en douge a arsavas; hag e lavaras: Den yaouank, me en lavar dit, sav! ");
INSERT INTO breBRG_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","An hini marv a azezas hag en em lakaas da gomz. Jezuz en roas d'e vamm. ");
INSERT INTO breBRG_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ar spont a grogas enno holl, hag e rojont gloar da Zoue, en ur lavarout: Ur profed bras a zo bet savet en hon touez, ha Doue a zo deuet da welout e bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ar vrud-se en em skuilhas dre holl Judea, ha dre an holl vro tro-war-dro. ");
INSERT INTO breBRG_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","An holl draoù-mañ a voe lavaret da Yann gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yann a c'halvas daou eus e ziskibien hag o c'hasas da gavout Jezuz evit lavarout dezhañ: Bez' out an hini a dle dont, pe e tleomp gortoz unan all? ");
INSERT INTO breBRG_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","An dud-mañ eta, o vezañ deuet da gavout Jezuz, a lavaras dezhañ: Yann-Vadezour en deus hon degaset da'z kavout evit lavarout dit: Bez' out an hini a dle dont, pe e tleomp gortoz unan all? ");
INSERT INTO breBRG_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","En eur-se zoken, Jezuz a yac'haas kalz a dud eus o c'hleñvedoù, eus o mac'hagnoù hag eus an drouk-speredoù, hag e roas ar gweled da veur a hini dall. ");
INSERT INTO breBRG_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Neuze en ur respont, e lavaras dezho: It ha lavarit da Yann ar pezh hoc'h eus gwelet ha klevet: ar re dall a wel, ar re gamm a vale, ar re lovr a zo glanaet, ar re vouzar a glev, ar re varv a adsav da vev, ar c'helou mat a zo prezeget d'ar beorien. ");
INSERT INTO breBRG_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eürus eo an neb ne gavo ket a skouer fall ennon. ");
INSERT INTO breBRG_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ar re en devoa Yann degaset o vezañ aet kuit, Jezuz en em lakaas da lavarout d'ar bobl diwar-benn Yann: Petra oc'h aet da welout el lec'h distro? Ur bennduenn hejet gant an avel? ");
INSERT INTO breBRG_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Met petra oc'h aet da welout? Un den gwisket gant dilhad kaer? Setu, ar re a zo gwisket gant dilhad kaer hag a vev er plijadurioù, a zo e tiez ar rouaned. ");
INSERT INTO breBRG_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Met petra oc'h aet da welout? Ur profed? Ya a lavaran deoc'h, ha muioc'h eget ur profed. ");
INSERT INTO breBRG_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Eñ eo an hini a zo skrivet diwar e benn: Setu, e kasan va c'hannad dirak da zremm, hag a gempenno an hent a-raok dit. ");
INSERT INTO breBRG_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Me a lavar deoc'h penaos e-touez ar re a zo bet ganet gant gwragez, n'eus profed ebet brasoc'h eget Yann-Vadezour; ha koulskoude, ar bihanañ e rouantelezh Doue a zo brasoc'h egetañ. ");
INSERT INTO breBRG_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","An holl dud o deus e glevet, hag ar bublikaned ivez; disklêriet o deus reizhder Doue o vezañ bet badezet gant badeziant Yann. ");
INSERT INTO breBRG_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Met ar farizianed ha doktored al lezenn, o vezañ n'o deus ket graet o badeziñ gantañ, o deus disprizet menoz Doue evito. ");
INSERT INTO breBRG_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Neuze an Aotrou a lavaras: Ouzh piv e keñverin tud ar rummad-mañ? Ouzh piv int heñvel? ");
INSERT INTO breBRG_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Heñvel int ouzh bugale azezet war al leurgêr, hag a gri an eil d'egile, o lavarout: Ni hon eus sonet deoc'h ar fleüt, ha n'hoc'h eus ket dañset; ni hon eus kanet deoc'h hirvoudoù, ha n'hoc'h eus ket gouelet. ");
INSERT INTO breBRG_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Rak Yann-Vadezour a zo deuet, hep debriñ bara, hag hep evañ gwin, hag e lavarit: Un diaoul a zo ennañ. ");
INSERT INTO breBRG_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mab an den a zo deuet, o tebriñ hag oc'h evañ, hag e lavarit: Setu un debrer hag un ever, ur mignon d'ar bublikaned ha d'an dud a vuhez fall. ");
INSERT INTO breBRG_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Met ar furnez a zo bet reishaet gant he holl vugale. ");
INSERT INTO breBRG_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ur farizian, o vezañ e bedet da zebriñ en e di, Jezuz a yeas e ti ar farizian, hag en em lakaas ouzh taol. ");
INSERT INTO breBRG_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ur wreg eus kêr, ur wreg a vuhez fall, o vezañ gouezet e oa ouzh taol e ti ar farizian, a zegasas ul lestr alabastr, leun a c'hwez-vat, ");
INSERT INTO breBRG_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","hag oc'h en em zerc'hel a-dreñv, ouzh treid Jezuz, o ouelañ, en em lakaas da zourañ e dreid gant he daeroù, ha d'o zorchañ gant blev he fenn; pokat a rae d'e dreid, hag ec'h eoulie anezho gant ar c'hwezh-vat. ");
INSERT INTO breBRG_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ar farizian en devoa e bedet, o welout kement-se, a lavaras ennañ e-unan: Ma vije an den-mañ profed, e ouije piv eo a wreg a stok ennañ, ha penaos eo a vuhez fall. ");
INSERT INTO breBRG_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Neuze Jezuz, o kemer ar gomz, a lavaras dezhañ: Simon, bez' em eus un dra bennak da lavarout dit. Eñ a lavaras dezhañ: Lavar anezhañ, Mestr. ");
INSERT INTO breBRG_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ur c'hredour en devoa daou zleour, unan a zlee dezhañ pemp kant diner, hag egile hanter-kant. ");
INSERT INTO breBRG_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Evel n'o devoa ket peadra da baeañ, eñ a bardonas o dle dezho o-daou. Lavar din eta pehini anezho o-daou en karo ar muiañ. ");
INSERT INTO breBRG_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon a respontas: Me a gav din ez eo an hini a zo bet pardonet ar muiañ dezhañ. Jezuz a lavaras dezhañ: barnet mat ec'h eus. ");
INSERT INTO breBRG_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Neuze, o tistreiñ ouzh ar wreg, e lavaras da Simon: Gwelet a rez ar wreg-mañ? Deuet on ez ti, ha ne'c'h eus ket roet a zour din evit gwalc'hiñ va zreid; met hi he deus o douret gant he daeroù, hag he deus o sec'het gant he blev. ");
INSERT INTO breBRG_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te, ne'c'h eus ket roet ur pok din; met hi, abaoe ma'z on deuet en ti, n'he deus ket paouezet da bokat da'm zreid. ");
INSERT INTO breBRG_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te, ne'c'h eus ket skuilhet a eoul war va fenn; met hi, he deus skuilhet eoul a c'hwezh-vat war va zreid. ");
INSERT INTO breBRG_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dre-se e lavaran dit, he fec'hedoù niverus a zo bet pardonet dezhi, rak karet he deus kalz; met an neb a bardoner nebeut dezhañ, a gar nebeut. ");
INSERT INTO breBRG_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Neuze e lavaras dezhi: Da bec'hedoù a zo pardonet dit. ");
INSERT INTO breBRG_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ar re a oa ouzh taol gantañ en em lakaas da lavarout enno oc'h-unan: Piv eo hemañ, hag a bardon memes ar pec'hedoù? ");
INSERT INTO breBRG_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Met eñ a lavaras d'ar wreg: Da feiz he deus da saveteet; kae e peoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Goude-se, Jezuz a yae eus eil kêr hag eus eil bourc'h d'egile, o prezeg hag o kemenn keloù mat rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","An daouzek a oa gantañ, kenkoulz hag un nebeut gwragez a oa bet yac'haet a zrouk-speredoù hag a gleñvedoù; Mari, anvet a Vagdala, a oa aet kuit seizh diaoul diouti, ");
INSERT INTO breBRG_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Janed, gwreg Chuza, merour Herodez, Suzanna, ha kalz a reoù all, en sikoure gant o madoù. ");
INSERT INTO breBRG_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Evel ma en em zastume kalz a bobl, ha ma teue d'e gavout meur a hini eus an holl gêrioù, e lavaras dezho dre barabolenn: ");
INSERT INTO breBRG_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Un hader a yeas er-maez evit hadañ e had, hag evel ma hade, ul lodenn eus an had a gouezhas a-hed an hent, hag e voe mac'het, ha laboused an neñv he debras holl. ");
INSERT INTO breBRG_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ul lodenn all a gouezhas war ul lec'h meinek, ha pa voe savet, e sec'has abalamour ma n'he devoa ket a c'hlebor. ");
INSERT INTO breBRG_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ul lodenn all a gouezhas e-touez ar spern; ar spern a savas gant ar greun hag o mougas. ");
INSERT INTO breBRG_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ul lodenn all a gouezhas en douar mat, hag, o vezañ savet, e roas frouezh, kant evit unan. O lavarout an traoù-mañ, e krie: Ra selaouo, an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","E ziskibien a c'houlennas digantañ petra e oa ar barabolenn-se. ");
INSERT INTO breBRG_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Respont a reas: Roet eo deoc'h-hu da anavezout traoù kuzhet rouantelezh Doue; met d'ar re all eo komzet dre barabolennoù, en hevelep doare o welout na welont ket, hag o klevout na gomprenont ket. ");
INSERT INTO breBRG_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Setu petra eo ar barabolenn-se: An had eo ger Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ar re a zo a-hed an hent eo ar re en selaou; met an diaoul a zeu hag a zilam ar ger diouzh o c'halon, en aon en ur grediñ na vefent salvet. ");
INSERT INTO breBRG_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ar re a zo war al lec'hioù meinek, eo ar re a glev ar ger, hag e zegemer gant joa; met n'o deus ket a wrizienn ha ne gredont nemet ur pennad; pa zeu an temptadur, e tec'hont kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ar pezh a zo e-touez an drein, eo ar re o deus klevet ar ger, met, en ur vont kuit, en lezont da vezañ mouget gant prederioù, pinvidigezhioù ha plijadurioù ar vuhez-mañ, en hevelep doare ma ne zougont ket a frouezh a zeu da zareviñ. ");
INSERT INTO breBRG_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Met ar pezh a zo kouezhet en un douar mat, eo ar re a glev ar ger gant ur galon onest ha mat, en dalc'h, hag a zoug frouezh gant kendalc'husted. ");
INSERT INTO breBRG_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Den, goude bezañ enaouet ur c'houlaouenn, ne c'holo anezhi gant ul lestr, ha ne laka anezhi dindan ar gwele; met he lakaat a ra war ur c'hantolor, evit ma sklaerio ar re a zeu en ti. ");
INSERT INTO breBRG_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Rak n'eus netra kuzhet na zle bezañ disklêriet, ha n'eus netra goloet na zle bezañ dizoloet hag anavezet gant an holl. ");
INSERT INTO breBRG_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lakait evezh eta penaos e selaouit; rak roet e vo d'an neb en deus; met an hini n'en deus ket, a vo lamet digantañ memes ar pezh a gred en deus. ");
INSERT INTO breBRG_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","E vamm hag e vreudeur a zeuas d'e gavout, met ne c'hellent ket tostaat abalamour d'ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Neuze e voe lavaret dezhañ: Da vamm ha da vreudeur a zo aze er-maez, hag e c'hoantaont da welout. ");
INSERT INTO breBRG_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Met eñ a respontas: Va mamm ha va breudeur eo ar re a selaou ger Doue, hag a sent outañ. ");
INSERT INTO breBRG_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dont a reas un deiz, ma'z eas en ur vag gant e ziskibien, hag e lavaras dezho: Tremenomp en tu all d'al lenn. Hag ez ejont. ");
INSERT INTO breBRG_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","E-pad ma oant er vag, e kouske; un taol-avel bras a savas war al lenn, ar vag en em leunie gant an dour hag e oant e riskl bras. ");
INSERT INTO breBRG_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Neuze e teujont d'e gavout, hag en dihunjont, o lavarout: Mestr, mestr, ez eomp da goll! Met eñ, o vezañ dihunet, a c'hourc'hemennas an avel hag ar mor; ar re-mañ a davas, hag e voe ur sioulder bras. ");
INSERT INTO breBRG_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Neuze e lavaras dezho: Pelec'h emañ ho feiz? Int, leuniet a zoujañs hag a spont, a lavare etrezo: Piv eta eo hemañ, a c'hourc'hemenn memes d'an avelioù ha d'an dour, hag e sentont outañ? ");
INSERT INTO breBRG_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dont a rejont neuze da vro ar C'hadareniz, a zo dirak Galilea. ");
INSERT INTO breBRG_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pa voe Jezuz diskennet d'an douar, e teuas a-raok dezhañ un den eus kêr, a oa dalc'het gant diaoulien pell a oa. Ne zouge ket a zilhad, ha ne chome ket en un ti, met er bezioù. ");
INSERT INTO breBRG_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Adalek ma welas Jezuz, e krias, hag ouzh en em deurel d'e dreid, e lavaras a vouezh uhel: Petra a zo etre me ha te, Jezuz, Mab an Doue Uhelañ-Meurbet? Me az ped, na boagn ket ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Rak Jezuz a c'hourc'hemenne d'ar spered hudur mont kuit eus an den-se; en em gemeret e oa anezhañ abaoe pell a oa; e eren a raed gant chadennoù hag e ziwall a raed gant hualoù, met eñ a dorre an ereoù, hag e oa kaset gant an diaoul el lec'hioù distro. ");
INSERT INTO breBRG_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jezuz a c'houlennas outañ: Pe anv ac'h eus? Hag e respontas: Lejion. Rak kalz a ziaoulien a oa aet ennañ. ");
INSERT INTO breBRG_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Int a bede anezhañ na c'hourc'hemennje ket dezho mont en donder. ");
INSERT INTO breBRG_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bez' e oa eno ur vandenn vras a voc'h o peuriñ war ar menez; hag e pedent anezhañ d'o lezel da vont er moc'h-se; eñ o lezas da vont. ");
INSERT INTO breBRG_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","An diaoulien eta o vezañ aet kuit eus an den, a yeas er moc'h, hag ar vandenn en em daolas eus al lec'h uhel-se er mor, hag a voe beuzet. ");
INSERT INTO breBRG_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ar re o mesae, o welout ar pezh a oa erruet, a dec'has kuit da lavarout kement-se e kêr ha war ar maez. ");
INSERT INTO breBRG_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Neuze an dud a zeuas evit gwelout ar pezh a oa c'hoarvezet. O vezañ deuet da gavout Jezuz, e kavjont an den ma oa aet kuit an diaoulien anezhañ, azezet ouzh treid Jezuz, gwisket hag en e skiant vat; hag e voent leuniet a spont. ");
INSERT INTO breBRG_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ar re o devoa gwelet an traoù-se a lavaras dezho penaos e oa bet yac'haet an hini dalc'het gant an diaoulien. ");
INSERT INTO breBRG_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Holl dud bro ar C'hadareniz en pedas da bellaat diouto, rak kroget e oa ur spont vras enno. Mont a reas eta er vag evit distreiñ. ");
INSERT INTO breBRG_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","An den ma oa aet kuit an diaoulien anezhañ, en pedas d'e lezel da vont gantañ. Met Jezuz a gasas anezhañ kuit, o lavarout: ");
INSERT INTO breBRG_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Distro da'z ti, ha lavar an traoù bras en deus Doue graet dit. Mont a reas eta kuit, oc'h embann dre holl gêr kement en devoa Jezuz graet en e geñver. ");
INSERT INTO breBRG_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pa voe distroet, Jezuz a voe degemeret gant ur bobl vras, rak an holl a c'hortoze anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ha setu, un den anvet Jairuz, hag a oa penn eus ar sinagogenn, a zeuas, hag oc'h en em deurel ouzh treid Jezuz, en pedas da zont en e di, ");
INSERT INTO breBRG_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","rak en devoa ur verc'h nemeti, oadet a zaouzek vloaz pe war-dro, hag a oa o vont da vervel. Evel ma'z ae Jezuz di, e oa gwasket gant ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Neuze ur wreg klañv, daouzek vloaz a oa, gant an diwadañ, hag he devoa dispignet he holl vadoù gant medisined, hep gallout bezañ yac'haet gant hini ebet, ");
INSERT INTO breBRG_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","a dostaas outañ a-ziadreñv, hag a stokas ouzh bevenn e zilhad; raktal he diwadañ a baouezas. ");
INSERT INTO breBRG_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ha Jezuz a lavaras: Piv en deus stoket ouzhin? Evel ma nac'he an holl kement-se, Pêr hag ar re a oa gantañ a lavaras dezhañ: Mestr, an dud a zo en-dro dit a wask ac'hanout, hag e lavarez: Piv en deus stoket ouzhin? ");
INSERT INTO breBRG_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Met Jezuz a lavaras: Unan bennak en deus stoket ouzhin, rak anavezet em eus e oa aet un nerzh er-maez ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Neuze ar wreg, o welout ne oa ket bet kement-se kuzhet outañ, a zeuas en ur grenañ holl, hag oc'h en em deurel d'e dreid, e tisklêrias dirak ar bobl evit petra he devoa stoket outañ, ha penaos e oa bet yac'haet kerkent. ");
INSERT INTO breBRG_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jezuz a lavaras dezhi: Va merc'h, kemer fiziañs, da feiz he deus da yac'haet; kae e peoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Evel ma komze c'hoazh, unan bennak eus ti penn ar sinagogenn a zeuas da lavarout dezhañ: Da verc'h a zo marv; na skuizh ket ar Mestr. ");
INSERT INTO breBRG_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Met Jezuz, o vezañ e glevet, a lavaras da benn ar sinagogenn: Na'z pez ket aon, kred hepken, hag hi a vo yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pa voe deuet en ti, ne lezas den da vont e-barzh, nemet Pêr, Yann ha Jakez, ha tad ha mamm ar plac'hig. ");
INSERT INTO breBRG_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","An holl a ouele hag a hirvoude abalamour dezhi. Met eñ a lavaras: Na ouelit ket, n'eo ket marv, met kousket a ra. ");
INSERT INTO breBRG_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hag int a rae goap outañ, oc'h anavezout e oa marv. ");
INSERT INTO breBRG_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Met, o vezañ graet dezho holl mont er-maez, e kemeras he dorn, hag e krias: Bugel, sav! ");
INSERT INTO breBRG_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","He spered a zistroas, hag e savas kerkent; neuze e c'hourc'hemennas reiñ dezhi da zebriñ. ");
INSERT INTO breBRG_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","He c'herent a voe gwall souezhet; met eñ a c'hourc'hemennas dezho na lavarjent da zen ar pezh a oa c'hoarvezet. ");
INSERT INTO breBRG_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","O vezañ dastumet e zaouzek diskibl, Jezuz a roas dezho nerzh ha galloud war an holl diaoulien, ha da yac'haat ar c'hleñvedoù. ");
INSERT INTO breBRG_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hag e kasas anezho da brezeg rouantelezh Doue, ha da yac'haat ar re glañv. ");
INSERT INTO breBRG_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Lavarout a reas dezho: Na zougit netra evit an hent, na bazh, na sac'h, na bara, nag arc'hant, ha n'ho pet ket daou wiskamant. ");
INSERT INTO breBRG_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","E peseurt ti bennak ma'z eot, chomit ennañ betek ma'z eot kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hag evit ar re na zegemerint ket ac'hanoc'h, o vont kuit eus o c'hêr, hejit ar poultr eus ho treid, e testeni a-enep an dud-se. ");
INSERT INTO breBRG_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","O vezañ aet kuit, ez ajent eus bourc'h e bourc'h, o prezeg an Aviel, hag o yac'haat ar re glañv e pep lec'h. ");
INSERT INTO breBRG_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Koulskoude, Herodez an tetrark a glevas komz eus kement holl a rae Jezuz, ha ne ouie petra da soñjal, abalamour darn a lavare e oa Yann adsavet a-douez ar re varv, ");
INSERT INTO breBRG_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","re all e oa en em ziskouezet Elia, ha re all unan eus ar brofeded kozh a oa adsavet a varv. ");
INSERT INTO breBRG_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodez a lavare: Graet em eus troc'hañ e benn da Yann; met piv eo hemañ a glevan an hevelep traoù diwar e benn? Hag e c'hoantae gwelout anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","An ebestel o vezañ distroet, a lavaras da Jezuz kement o devoa graet. O vezañ o c'hemeret a-du, en em dennas ganto en ul lec'h distro, tost ouzh ur gêr anvet Betsaida. ");
INSERT INTO breBRG_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ar bobl o vezañ klevet-se en heulias; Jezuz o degemeras hag a gomzas outo diwar-benn rouantelezh Doue; yac'haat a reas ivez ar re o devoa ezhomm da vezañ yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Evel ma'c'h izelae an deiz, an daouzek a dostaas outañ hag a lavaras dezhañ: Kas kuit ar bobl, evit ma'z aint er bourc'hioù hag er c'hêrioùigoù en-dro, da lojañ ha da brenañ boued, rak amañ emaomp en ul lec'h distro. ");
INSERT INTO breBRG_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Met eñ a lavaras dezho: Roit hoc'h-unan da zebriñ dezho. Hag int a respontas: N'hon eus ket ouzhpenn pemp bara ha daou besk, nemet mont a rafemp da brenañ boued evit an holl bobl-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Rak bez' e oant war-dro pemp mil den. Neuze e lavaras d'e ziskibien: Lakait anezho da azezañ a renkoù a hanter-kant. ");
INSERT INTO breBRG_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hag e rejont evel-se, o lakajont holl da azezañ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jezuz a gemeras ar pemp bara hag an daou besk, hag o sellout war-zu an neñv, e vennigas anezho, o zorras, hag o roas d'an diskibien, evit m'o rojent d'ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Debriñ a rejont holl hag o devoa a-walc'h, hag e kasjont ganto daouzek panerad leun eus an nemorantoù. ");
INSERT INTO breBRG_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","C'hoarvezout a reas, evel ma pede e-unan, ha ma oa an diskibien gantañ, e c'houlennas outo: Piv a lavar an dud on-me? ");
INSERT INTO breBRG_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Int a respontas: Darn a lavar out Yann-Vadezour; ha darn all, Elia; ha darn all, unan bennak eus ar brofeded adsavet a varv. ");
INSERT INTO breBRG_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eñ a lavaras dezho: Ha c'hwi, piv a lavarit ez on-me? Pêr a respontas: Te eo Krist Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Met e tifennas gwall start outo lavarout kement-se da zen, ");
INSERT INTO breBRG_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","hag e lavaras: Ret eo da Vab an den gouzañv kalz a draoù, ha bezañ taolet kuit gant an henaourien, gant ar veleien vras, ha gant ar skribed, ha bezañ lakaet d'ar marv, hag adsevel a varv an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hag e lavaras d'an holl: Mar fell da unan bennak dont war va lerc'h, ra raio dilez anezhañ e-unan, ra gemero e groaz, ha ra heulio ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Rak piv bennak a fello dezhañ saveteiñ e vuhez, he c'hollo; met piv bennak a gollo e vuhez abalamour din, he saveteo. ");
INSERT INTO breBRG_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Rak petra a dalvfe d'un den gounit ar bed holl, mar en em zistrujfe, pe mar en em gollfe e-unan? ");
INSERT INTO breBRG_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Rak piv bennak en devo mezh ac'hanon hag eus va c'homzoù, Mab an den en devo mezh anezhañ pa zeuio en e c'hloar hag e hini an Tad hag an aelez santel. ");
INSERT INTO breBRG_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Me a lavar deoc'h e gwirionez, ez eus hiniennoù eus a-douez ar re a zo amañ, ha ne varvint ket, ken n'o devo gwelet rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","War-dro eizh devezh goude ar c'homzoù-se, Jezuz a gemeras gantañ Pêr, Yann ha Jakez, hag a bignas war ur menez evit pediñ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","E-pad ma pede, e zremm a droas a zoare, hag e zilhad a zeuas gwenn ha lugernus evel al luc'hed. ");
INSERT INTO breBRG_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ha setu daou zen a gomze gantañ; Moizez hag Elia e oant; ");
INSERT INTO breBRG_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","en em ziskouezjont gant gloar, hag e komzjont eus e varv, a zlee bezañ graet e Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pêr hag ar re a oa gantañ o devoa kement a c'hoant kousket; pa zihunjont, e weljont e c'hloar hag an daou zen a oa gantañ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Evel ma'z ae an dud-mañ kuit digant Jezuz, Pêr a lavaras dezhañ: Mestr, mat eo deomp chom amañ; greomp amañ teir deltenn, unan evidout, unan evit Moizez, hag unan evit Elia. Ne ouie ket mat petra a lavare. ");
INSERT INTO breBRG_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Komz a rae c'hoazh, pa zeuas ur goabrenn d'o golo; hag evel ma c'holoe anezho, ar spont a grogas en diskibien. ");
INSERT INTO breBRG_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ur vouezh a zeuas eus ar goabrenn, hag a lavaras: Hemañ eo va Mab karet-mat, selaouit eñ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pa oa ar vouezh-se o komz, Jezuz en em gavas e-unan. E ziskibien a davas, ha ne lavarjont netra da zen, d'ar c'houlz-se, eus ar pezh o devoa gwelet. ");
INSERT INTO breBRG_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","An deiz war-lerc'h, evel ma tiskennent eus ar menez, ur bobl vras a zeuas a-raok Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Un den, a-douez an dud-se, a grias hag a lavaras: Mestr, me az ped, taol da zaoulagad war va mab, rak va mab nemetañ eo. ");
INSERT INTO breBRG_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ur spered a grog ennañ, ha kerkent e laosk kriadennoù bras; neuze ar spered a hej anezhañ start, en laka da eoniñ, hag a boan e kuita anezhañ, goude bezañ e vrevet holl. ");
INSERT INTO breBRG_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hag em eus pedet da ziskibien d'e gas kuit, met n'o deus ket gallet. ");
INSERT INTO breBRG_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jezuz a respontas: O rummad diskredik ha fall, betek pegeit e vin ganeoc'h hag e c'houzañvin ac'hanoc'h? Degas amañ da vab. ");
INSERT INTO breBRG_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Evel ma tostae, an diaoul en stlapas d'an douar, hag a zifretas start anezhañ; met Jezuz a c'hourdrouzas ar spered hudur, a yac'haas ar bugel, hag en roas d'e dad. ");
INSERT INTO breBRG_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hag e voent holl souezhet eus galloud meurbet Doue. Evel ma oant holl estlammet gant ar pezh a rae Jezuz, eñ a lavaras d'e ziskibien: ");
INSERT INTO breBRG_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Evidoc'h-hu, selaouit mat ar c'homzoù-mañ: Mab an den a zle bezañ lakaet etre daouarn an dud. ");
INSERT INTO breBRG_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Met ne gomprenent ket ar gomz-se; teñval e oa evito, ha ne gomprenent enni netra, met ne gredent goulenn netra outañ war gement-se. ");
INSERT INTO breBRG_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Neuze ur soñj a zeuas dezho, anavezout pehini anezho a vije ar brasañ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jezuz, o welout soñj o c'halon, a gemeras ur bugel bihan, a lakaas anezhañ en e gichen, ");
INSERT INTO breBRG_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","hag a lavaras dezho: Piv bennak a zegemer ar bugel bihan-se em anv, a zegemer ac'hanon, ha piv bennak a zegemer ac'hanon, a zegemer an hini en deus va c'haset. Rak an hini ac'hanoc'h holl eo ar bihanañ, hennezh eo a vo bras. ");
INSERT INTO breBRG_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yann, o kemer ar gomz, a lavaras dezhañ: Mestr, ni hon eus gwelet unan o kas kuit an diaoulien ez anv, hag hon eus difennet-se outañ, abalamour ne heul ket ac'hanomp. ");
INSERT INTO breBRG_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jezuz a lavaras dezhañ: Na zifennit ket outañ; rak an neb n'emañ ket a-enep deomp, a zo evidomp. ");
INSERT INTO breBRG_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Evel ma tostae an amzer ma tlee bezañ savet diwar an douar, en em lakaas en hent, c'hoantek da vont da Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kas a reas tud a-raok dezhañ; o vezañ aet, ec'h antrejont en ur vourc'h eus Samaria, evit kempenn ul lojeiz dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Met ar re-mañ n'en degemerjont ket, abalamour ma'z ae war-zu Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jakez ha Yann, e ziskibien, o welout-se, a lavaras dezhañ: Aotrou, fellout a ra dit e lavarfemp ma tiskennfe an tan eus an neñv evit o deviñ evel ma reas Elia. ");
INSERT INTO breBRG_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hogen Jezuz, o tistreiñ, a c'hourdrouzas anezho hag a lavaras: N'ouzoc'h ket eus peseurt spered oc'h buhezet; ");
INSERT INTO breBRG_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","rak Mab an den n'eo ket deuet evit koll an dud, met evit o saveteiñ. Hag ez ejont da ur vourc'h all. ");
INSERT INTO breBRG_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Evel ma oant en hent, un den a lavaras dezhañ: Me a heulio ac'hanout, Aotrou, e kement lec'h ma'z i. ");
INSERT INTO breBRG_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jezuz a lavaras dezhañ: Al lern o deus toulloù, ha laboused an neñv neizhioù; met Mab an den n'en deus lec'h ebet evit harpañ e benn. ");
INSERT INTO breBRG_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lavarout a reas da unan all: Heul ac'hanon. Hag hemañ a lavaras: Aotrou, lez ac'hanon da vont da gentañ da sebeliañ va zad. ");
INSERT INTO breBRG_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jezuz a lavaras dezhañ: Lez ar re varv da sebeliañ o re varv, met te, kae da brezeg rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Unan all a lavaras dezhañ ivez: Me a heulio ac'hanout, Aotrou, met lez ac'hanon da gentañ da vont da gimiadiñ diouzh ar re a zo em zi. ");
INSERT INTO breBRG_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jezuz a respontas dezhañ: An hini a laka e zorn war an arar hag a sell war e lerc'h, n'eo ket dereat evit rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Goude-se, an Aotrou a lakaas c'hoazh dek ha tri-ugent all, hag o c'hasas daou ha daou a-raok dezhañ, en holl gêrioù hag en holl lec'hioù ma tlee mont e-unan. ");
INSERT INTO breBRG_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hag e lavaras dezho: An eost a zo bras, met nebeut a zo al labourerien. Pedit eta Mestr an eost evit ma kaso labourerien en e eost. ");
INSERT INTO breBRG_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","It, setu e kasan ac'hanoc'h evel oaned e-touez bleizi. ");
INSERT INTO breBRG_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na zougit na yalc'h, na sac'h, na botoù, ha na saludit den en hent. ");
INSERT INTO breBRG_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","E peseurt ti bennak ma'z eot, lavarit da gentañ: Ra vo ar peoc'h war an ti-mañ! ");
INSERT INTO breBRG_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mar bez eno ur bugel a beoc'h, ho peoc'h a chomo warnañ; mar n'eus ket, e tistroio deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chomit en ti-se, o tebriñ hag oc'h evañ ar pezh a vo roet deoc'h; rak al labourer a zo din eus e c'hopr. Na dremenit ket eus un ti da un ti all. ");
INSERT INTO breBRG_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","E peseurt kêr bennak ma'z eot, mar ho tegemerer enni, debrit ar pezh a vo kinniget deoc'h, ");
INSERT INTO breBRG_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","yac'hait ar re glañv a vo eno, ha lavarit dezho: Rouantelezh Doue a zo deuet tost ouzhoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Met e peseurt kêr bennak ma'z eot, mar n'ho tegemerer ket, it er straedoù, ha lavarit: ");
INSERT INTO breBRG_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hejañ a reomp a-enep deoc'h ar poultr a zo staget ouzhimp en ho kêr; gouezit koulskoude penaos rouantelezh Doue a zo tostaet ouzhoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Me a lavar deoc'h, en deiz-se e vo dousoc'h da Sodom eget d'ar gêr-se. ");
INSERT INTO breBRG_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gwalleur dit, Korazin! Gwalleur dit, Betsaida! Rak ma vije bet graet e Tir hag e Sidon ar mirakloù a zo bet graet ennoc'h, pell zo e vijent kaout keuz, o kemer ar sac'h hag al ludu. ");
INSERT INTO breBRG_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Abalamour da-se, e deiz ar varn, e vo dousoc'h da Dir ha da Sidon, eget deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ha te, Kafarnaoum, savet out bet betek an neñv, hogen izelaet e vi betek lec'h ar marv. ");
INSERT INTO breBRG_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","An neb a selaou ac'hanoc'h, a selaou ac'hanon, hag an neb a zispriz ac'hanoc'h, a zispriz ac'hanon; an neb a zispriz ac'hanon, a zispriz an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","An dek ha tri-ugent a zistroas gant levenez, o lavarout: Aotrou, zoken an diaoulien a zouj ac'hanomp ez anv. ");
INSERT INTO breBRG_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eñ a lavaras dezho: Me a wele Satan o kouezhañ eus an neñv evel ul luc'hedenn. ");
INSERT INTO breBRG_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Setu, e roan deoc'h ar galloud da gerzhout war an naered, war ar c'hruged, ha war holl nerzhoù an enebour; ha netra ne c'hello noazout ouzhoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Koulskoude, n'en em laouenait ket eus ma sent ar speredoù ouzhoc'h; met en em laouenait kentoc'h eus ma'z emañ hoc'h anvioù skrivet en neñvoù. ");
INSERT INTO breBRG_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","En eur-se, Jezuz a dridas gant levenez er Spered-Santel hag a lavaras: Da veuliñ a ran, o Tad, Aotrou an neñv hag an douar ma ec'h eus kuzhet an traoù-mañ ouzh ar re fur hag ouzh ar re skiantek, ha ma ec'h eus o disklêriet d'ar vugale! Ya, o Tad, kement-se a zo evel-se dre ma ec'h eus e gavet mat. ");
INSERT INTO breBRG_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pep tra a zo bet roet din gant va Zad, ha den ne oar piv eo ar Mab, nemet an Tad, na piv eo an Tad, nemet ar Mab, hag an hini a fell d'ar Mab e zisklêriañ dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hag, o tistreiñ ouzh e ziskibien, e lavaras dezho, a-du: Eürus eo an daoulagad a wel ar pezh a welit! ");
INSERT INTO breBRG_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Rak, me a lavar deoc'h, kalz a brofeded hag a rouaned o deus c'hoantaet gwelout ar pezh a welit ha n'o deus ket e welout, ha klevout ar pezh a glevit ha n'o deus ket e glevout. ");
INSERT INTO breBRG_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Neuze un doktor eus al lezenn a savas hag a lavaras da Jezuz evit e amprouiñ: Mestr, petra a zlean d'ober evit kaout ar vuhez peurbadus? ");
INSERT INTO breBRG_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jezuz a lavaras dezhañ: Petra a zo skrivet el lezenn, ha petra a lennez enni? ");
INSERT INTO breBRG_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eñ a respontas: Karout a ri an Aotrou da Zoue, eus da holl galon, eus da holl ene, eus da holl nerzh, hag eus da holl soñj, ha da nesañ eveldout da-unan. ");
INSERT INTO breBRG_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jezuz a lavaras dezhañ: Respontet mat ec'h eus; gra kement-se hag e vevi. ");
INSERT INTO breBRG_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Met an den-mañ, o fellout diskouez e oa reizh, a lavaras da Jezuz: Ha piv eo va nesañ? ");
INSERT INTO breBRG_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jezuz, oc'h adkemer ar gomz, a lavaras: Un den a ziskennas eus Jeruzalem da Jeriko, hag a gouezhas etre daouarn laeron a ziwiskas anezhañ; ha goude bezañ e vrevet a daolioù, ez ejont kuit, o lezel anezhañ hanter-varv. ");
INSERT INTO breBRG_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Erruout a reas ma tiskennas ur beleg dre an hent-se, hag o vezañ gwelet an den, a dremenas e-biou. ");
INSERT INTO breBRG_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ul Leviad, o vezañ ivez deuet er memes lec'h, hag o welout anezhañ, a yeas e-biou. ");
INSERT INTO breBRG_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Met ur Samaritan, o tremen e hent, a zeuas da gavout an den-mañ, hag o welout anezhañ en devoe truez outañ. ");
INSERT INTO breBRG_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","O tostaat, e lienas e c'houlioù, hag e lakaas warno eoul ha gwin. Goude e lakaas anezhañ war e varc'h, en kasas da un ostaleri, hag e kemeras preder anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Antronoz, o vont kuit, e tennas daou ziner arc'hant, o roas d'an ostiz, hag e lavaras dezhañ: Az pez preder anezhañ, ha kement a zispign ouzhpenn, me en roio dit pa zistroin. ");
INSERT INTO breBRG_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pehini eta eus an tri-se a gav dit eo bet nesañ an hini a oa kouezhet etre daouarn al laeron? ");
INSERT INTO breBRG_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","An doktor a lavaras: An hini en deus graet trugarez en e geñver eo. Jezuz a lavaras eta dezhañ: Kae, ha gra ivez evel-se. ");
INSERT INTO breBRG_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Evel ma oant en hent, ez eas en ur vourc'h, hag ur wreg anvet Marta en degemeras en he zi. ");
INSERT INTO breBRG_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ur c'hoar he devoa, anvet Mari; homañ, oc'h en em zerc'hel azezet ouzh treid Jezuz, a selaoue e gomzoù. ");
INSERT INTO breBRG_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta a oa prederiet gant al labour en ti; o vezañ deuet, e lavaras: Aotrou, ha n'evezhiez ket penaos va c'hoar am lez da servijañ va-unan? Lavar dezhi eta va sikour. ");
INSERT INTO breBRG_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jezuz a respontas dezhi: Marta, Marta, te en em laka e poan hag en em nec'h gant kalz a draoù; ");
INSERT INTO breBRG_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","met un dra hepken a zo ret; Mari he deus dibabet al lodenn wellañ, ha ne vo ket lamet diganti. ");
INSERT INTO breBRG_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Un deiz ma oa Jezuz o pediñ en ul lec'h bennak, goude m'en devoe echuet, unan eus e ziskibien a lavaras dezhañ: Aotrou, desk deomp pediñ, evel m'en deus Yann desket ivez d'e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hag e lavaras dezho: Pa bedot, lavarit: Hon Tad hag a zo en neñv, ra vo santelaet da anv, ra zeuio da rouantelezh, ra vo graet da volontez war an douar evel en neñv, ");
INSERT INTO breBRG_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ro deomp bemdez hor bara pemdeziek, ");
INSERT INTO breBRG_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","pardon deomp hor pec'hedoù, rak ni a bardon ivez d'an holl re o deus manket ouzhimp, ha n'hon lez ket da gouezhañ en temptadur, met hon diwall diouzh an droug. ");
INSERT INTO breBRG_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Neuze e lavaras dezho: Mar en defe unan ac'hanoc'h ur mignon hag a zeufe d'e gavout da hanternoz da lavarout dezhañ: Va mignon, prest din tri bara, ");
INSERT INTO breBRG_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","rak ur mignon din, o veajiñ, a zo deuet da'm zi, ha ne'm eus netra da ginnig dezhañ; ");
INSERT INTO breBRG_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ha mar respontfe dezhañ an den a zo en e di: Na dregas ket ac'hanon, va dor a zo prennet ha va bugale a zo ganin em gwele, ne c'hellan ket sevel evit o reiñ dit! ");
INSERT INTO breBRG_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Me a lavar deoc'h, pa ne savfe ket da reiñ dezhañ abalamour ma'z eo e vignon, e savfe koulskoude abalamour d'e dregaserezh, hag e rofe dezhañ kement hag en defe ezhomm. ");
INSERT INTO breBRG_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Me ivez a lavar deoc'h: Goulennit, hag e vo roet deoc'h; klaskit, hag e kavot; skoit, hag e vo digoret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Rak an neb a c'houlenn, a resev; an neb a glask, a gav; hag an neb a sko, e vez digoret dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Piv eo an tad en ho touez, a roio ur maen d'e vab, pa c'houlenn digantañ bara? Pe, mar goulenn ur pesk, a roio dezhañ un naer e-lec'h pesk? ");
INSERT INTO breBRG_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pe c'hoazh, mar goulenn digantañ ur vi, a roio dezhañ ur grug? ");
INSERT INTO breBRG_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mar gouzoc'h eta, ha c'hwi fall, reiñ traoù mat d'ho pugale, pegement muioc'h ho Tad a zo en neñv a roio ar Spered-Santel d'ar re en goulenn digantañ! ");
INSERT INTO breBRG_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jezuz a gasas kuit un diaoul mut; pa voe aet an diaoul kuit, an den mut a gomzas, hag ar bobl a oa souezhet. ");
INSERT INTO breBRG_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lod anezho a lavaras: Dre Veelzebul, priñs an diaoulien eo e kas an diaoulien kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Reoù all, evit e amprouiñ, a c'houlenne digantañ ur mirakl eus an neñv. ");
INSERT INTO breBRG_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Met Jezuz, oc'h anavezout o soñjezonoù, a lavaras dezho: Pep rouantelezh dizunanet ganti hec'h-unan a zeuio da netra, hag un ti a vo diskaret. ");
INSERT INTO breBRG_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mar emañ eta Satan dizunanet gantañ e-unan, penaos e pado e rouantelezh, pa lavarit ez eo dre Veelzebul e kasan kuit an diaoulien? ");
INSERT INTO breBRG_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mar kasan kuit an diaoulien dre Veelzebul, dre biv o c'has kuit ho mibien? Dre-se e vint ho parnerien. ");
INSERT INTO breBRG_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Met mar kasan kuit an diaoulien dre viz Doue, eo eta gwir penaos eo deuet rouantelezh Doue betek ennoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pa ziwall un den kreñv hag armet mat e di, kement en deus a zo e peoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Met pa zeu unan all kreñvoc'h egetañ, e tiskar anezhañ, e tilamm digantañ e holl armoù ma fizie enno, hag e lodenn e ziwisk. ");
INSERT INTO breBRG_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","An hini n'emañ ket ganin a zo a-enep din, hag an hini na zastum ket ganin a stlabez. ");
INSERT INTO breBRG_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Pa vez aet kuit ur spered hudur eus un den, ez a dre lec'hioù sec'h, da glask diskuizh, ha ne gav ket; neuze e lavar: Distreiñ a rin da'm zi a-belec'h on deuet; ");
INSERT INTO breBRG_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","pa zeu, e kav anezhañ skubet ha kempennet. ");
INSERT INTO breBRG_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Neuze ez a, e kemer gantañ seizh spered all gwashoc'h egetañ, hag ez eont hag e chomont ennañ; ha stad diwezhañ an den-se a zeu gwashoc'h eget an hini gentañ. ");
INSERT INTO breBRG_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Evel ma lavare an traoù-se, ur weg eus ar bobl a savas he mouezh hag a lavaras dezhañ: Eürus ar c'hof en deus da zouget, hag an divronn ac'h eus sunet! ");
INSERT INTO breBRG_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Met Jezuz a lavaras: Eürusoc'h eo ar re a selaou ger Doue hag a sent outañ! ");
INSERT INTO breBRG_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Evel m'en em zastume ar bobl a vandenn war e dro, Jezuz en em lakaas da lavarout: Ar rummad-mañ a zo fall; goulenn a ra ur mirakl, ha ne vo roet hini ebet dezhañ, nemet hini ar profed Jona. ");
INSERT INTO breBRG_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Rak, evel ma voe Jona ur mirakl evit tud Niniv, Mab an den a vo ivez unan evit ar rummad-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Rouanez ar C'hreisteiz a savo e deiz ar varn gant tud ar rummad-mañ, hag a gondaono anezho, abalamour ma teuas eus pellder an douar evit klevout furnez Salomon, ha setu ez eus amañ brasoc'h eget Salomon. ");
INSERT INTO breBRG_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tud Niniv a savo e deiz ar varn gant tud ar rummad-mañ, hag a gondaono anezho, abalamour m'o deus bet keuz dre brezegenn Jona, ha setu ez eus amañ brasoc'h eget Jona. ");
INSERT INTO breBRG_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Den n'enaou ul lamp evit he lakaat en ul lec'h kuzhet, pe dindan ar boezell; met he lakaat a ra war ar c'hantolor, abalamour d'ar re a zeu en ti da welout ar sklêrijenn. ");
INSERT INTO breBRG_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Al lagad eo lamp ar c'horf; mar deo eta da lagad yac'h, da holl gorf a vo sklêrijennet; met mar deo fall, da gorf a vo en deñvalijenn. ");
INSERT INTO breBRG_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Diwall eta na vefe ket teñvalijenn ar sklêrijenn a zo ennout. ");
INSERT INTO breBRG_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mar deo eta da holl gorf sklêrijennet, ha mar n'en deus lod ebet anezhañ en deñvalijenn, e vo sklêrijennet en e bezh, evel pa sklaer ul lamp ac'hanout gant he sklêrijenn. ");
INSERT INTO breBRG_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Evel ma komze, ur farizian en pedas da leinañ en e di; Jezuz a yeas, hag en em lakaas ouzh taol. ");
INSERT INTO breBRG_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ar farizian a oa souezhet o welout na oa ket en em walc'het a-raok lein. ");
INSERT INTO breBRG_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","An Aotrou a lavaras dezhañ: C'hwi, farizianed, a naeta diavaez an hanaf hag ar plad, met en diabarzh oc'h leun a laeroñsi hag a fallentez. ");
INSERT INTO breBRG_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tud diskiant! An hini en deus graet an diavaez, ha n'en deus ket graet ivez an diabarzh? ");
INSERT INTO breBRG_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Roit, kentoc'h, an aluzen eus ar pezh hoc'h eus, ha pep tra a vo glan evidoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Met gwalleur deoc'h, farizianed! Abalamour ma paeit an deog war ar vent, war ar ru, ha war an holl louzoù, e-pad ma lezit a-gostez ar reizhder ha karantez Doue. Ar re-se a oa an traoù a dleec'h d'ober, hep koulskoude dilezel ar re all. ");
INSERT INTO breBRG_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Gwalleur deoc'h, farizianed! Abalamour ma karit ar c'hadorioù kentañ er sinagogennoù, ha bezañ saludet war al leurgêrioù. ");
INSERT INTO breBRG_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gwalleur deoc'h, skribed ha farizianed, pilpouzed! Abalamour ma'z oc'h heñvel ouzh bezioù na weler ket, ha ma vale an dud warno hep gouzout emaint eno. ");
INSERT INTO breBRG_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Neuze, unan eus doktored al lezenn a gemeras ar gomz, hag a lavaras dezhañ: Mestr, en ur lavarout an traoù-se, e tismegañsez ac'hanomp-ni ivez. ");
INSERT INTO breBRG_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ha Jezuz a lavaras: Gwalleur deoc'h ivez, doktored al lezenn! Abalamour ma sammit an dud gant bec'hioù na c'hellont ket dougen, ha c'hwi hoc'h-unan ne stokit ket outo gant unan eus ho pizied. ");
INSERT INTO breBRG_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gwalleur deoc'h! Abalamour ma savit bezioù d'ar brofeded en deus ho tadoù lakaet d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","C'hwi a zo eta an testoù hag ar c'henoberourien eus ar pezh o deus graet ho tadoù, rak int o deus lazhet ar brofeded, ha c'hwi a sav o bezioù. ");
INSERT INTO breBRG_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Abalamour da-se, furnez Doue he deus lavaret: Kas a rin dezho profeded hag ebestel; hag e lazhint lod anezho, ha lod all a wallgasint, ");
INSERT INTO breBRG_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","evit ma vo goulennet digant ar rummad-mañ gwad an holl brofeded hag a zo bet skuilhet abaoe krouidigezh ar bed, ");
INSERT INTO breBRG_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","adal gwad Abel betek gwad Zakaria, a voe lazhet etre an aoter hag an templ; ya, a lavaran deoc'h, goulennet e vo digant ar rummad-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Gwalleur deoc'h, doktored al lezenn! Rak, o vezañ kemeret alc'houez an anaoudegezh, n'oc'h ket hoc'h-unan aet e-barzh, hag hoc'h eus c'hoazh harzet da vont e-barzh ar re a garje bezañ aet. ");
INSERT INTO breBRG_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hag evel ma lavare an traoù-se dezho, ar skribed hag ar farizianed en em lakaas d'e waskañ start, ha d'ober dezhañ komz war galz a draoù, ");
INSERT INTO breBRG_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","o stignañ pechoù dezhañ, hag o klask pakañ un dra bennak eus e c'henoù evit e damall. ");
INSERT INTO breBRG_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","War gement-se, ar bobl o vezañ en em zastumet dre vilieroù, ken ma kerzhent an eil war egile, Jezuz en em lakaas da lavarout d'e ziskibien: En em virit dreist-holl eus goell ar farizianed, da lavarout eo ar pilpouzerezh. ");
INSERT INTO breBRG_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","N'eus netra goloet na vo dizoloet, ha netra kuzhet na zle bezañ anavezet. ");
INSERT INTO breBRG_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dre-se, an traoù ho po lavaret en deñvalijenn a vo klevet er sklêrijenn, hag ar pezh ho po lavaret er skouarn er c'hambroù, a vo prezeget war lein an tiez. ");
INSERT INTO breBRG_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Hag e lavaran deoc'h, deoc'h-hu va mignoned: N'ho pet ket aon dirak ar re a lazh ar c'horf ha, goude-se, ne c'hellont ober netra ouzhpenn. ");
INSERT INTO breBRG_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Met me a ziskouezo deoc'h piv a zleit doujañ. Doujit an hini en deus, goude bezañ lamet ar vuhez, ar galloud da gas d'ar gehenn; ya, me a lavar deoc'h, hennezh eo an hini a zleit doujañ. ");
INSERT INTO breBRG_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ha ne werzher ket pemp golvan evit daou wenneg? Koulskoude, Doue n'ankounac'ha ket unan hepken anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ha zoken holl vlev ho penn a zo kontet. N'ho pet ket aon eta, c'hwi a dalvez muioc'h eget kalz a c'holvaned. ");
INSERT INTO breBRG_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Lavarout a ran deoc'h: Piv bennak a anzavo ac'hanon dirak an dud, Mab an den en anzavo dirak aeled Doue; ");
INSERT INTO breBRG_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","met an hini a zinac'ho ac'hanon dirak an dud, a vo dinac'het dirak aeled Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ha piv bennak en devo komzet a-enep Mab an den, e vo pardonet dezhañ; met d'an hini en devo gwallgomzet a-enep ar Spered-Santel, ne vo ket pardonet. ");
INSERT INTO breBRG_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pa viot kaset er sinagogennoù, dirak mestroù ar vro hag ar re c'halloudek, n'en em lakait ket en poan eus an doare ma respontot evit ho tifenn, nag eus ar pezh ho po da lavarout, ");
INSERT INTO breBRG_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","rak ar Spered-Santel a zesko deoc'h d'an eur-se ar pezh ho po da lavarout. ");
INSERT INTO breBRG_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Neuze unan eus ar bobl a lavaras dezhañ: Mestr, lavar d'am breur lodennañ ganin hon hêrezh. ");
INSERT INTO breBRG_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eñ a lavaras dezhañ: O den, piv en deus va lakaet ho parner, pe evit ober ho lodennoù? ");
INSERT INTO breBRG_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Neuze e lavaras dezho: Diwallit gant evezh diouzh ar bizhoni; rak un den n'en deus ket ar vuhez diouzh puilhentez e vadoù. ");
INSERT INTO breBRG_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hag e lavaras dezho ar barabolenn-mañ: Douaroù un den pinvidik o devoa roet kalz a frouezh, ");
INSERT INTO breBRG_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","hag e soñje ennañ e-unan, o lavarout: Petra a rin? Rak ne'm eus ket lec'h a-walc'h evit dastum va eost. ");
INSERT INTO breBRG_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Setu ar pezh a rin, emezañ, diskar a rin va solieroù hag e savin reoù vrasoc'h, hag e tastumin enno va holl eost ha va madoù; ");
INSERT INTO breBRG_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","neuze e lavarin da'm ene: Va ene, kalz a vadoù ac'h eus a-du evit meur a vloavezh; en em ziskuizh, debr, ev, ha bez laouen. ");
INSERT INTO breBRG_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Met Doue a lavaras dezhañ: Den diskiant, en noz-mañ memes, da ene a vo goulennet diganit; hag ar pezh ac'h eus dastumet, da biv e viot? ");
INSERT INTO breBRG_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Evel-se emañ gant an hini a zastum madoù evitañ e-unan, ha n'eo ket pinvidik e Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Neuze e lavaras d'e ziskibien: Dre-se, e lavaran deoc'h: Na vezit ket nec'het evit ho puhez, eus ar pezh a zebrot, nag evit ho korf, gant petra e viot gwisket. ");
INSERT INTO breBRG_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ar vuhez a zo muioc'h eget ar boued, hag ar c'horf muioc'h eget an dilhad. ");
INSERT INTO breBRG_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sellit ouzh ar brini: ne hadont ha ne vedont ket, n'o deus na kav na solier, ha Doue o mag; pegement ne dalvezit ket muioc'h eget laboused? ");
INSERT INTO breBRG_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Piv ac'hanoc'h a c'hell, gant e holl enkrez, astenn e vuhez eus un ilinad? ");
INSERT INTO breBRG_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma ne c'hellit ket eta ober memes an traoù bihanañ, perak oc'h nec'het gant ar peurrest? ");
INSERT INTO breBRG_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sellit penaos e kresk al lili: ne labouront ket, ne nezont ket; koulskoude, e lavaran deoc'h penaos Salomon memes en e holl c'hloar, n'eo ket bet gwisket evel unan anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mar gwisk eta Doue evel-se ar geot a zo hiziv er parkeier, hag a vo warc'hoazh taolet er forn, pegement muioc'h e wisko ac'hanoc'h-hu, tud a nebeud a feiz? ");
INSERT INTO breBRG_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ha n'en em lakait ket e poan eus ar pezh a zebrot, pe eus ar pezh a evot, ha na vezit ket nec'het. ");
INSERT INTO breBRG_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Rak tud ar bed eo, a glask an holl draoù-se. Ho Tad a oar hoc'h eus ezhomm anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Klaskit kentoc'h rouantelezh Doue, hag an holl draoù-se a vo roet deoc'h ouzhpenn. ");
INSERT INTO breBRG_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Na'z pez ket aon, tropell bihan, rak plijet eo bet gant ho Tad reiñ deoc'h ar rouantelezh. ");
INSERT INTO breBRG_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gwerzhit ar pezh hoc'h eus, hag roit eñ en aluzen. En em rit yilc'hier deoc'h ha ne goshaint ket, un teñzor en neñv ha ne vanko biken, a-belec'h al laeron ne dostaont ket, hag e-pelec'h ar preñved ne zistrujont ket. ");
INSERT INTO breBRG_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Rak el lec'h ma'z emañ ho teñzor, eno ivez e vo ho kalon. ");
INSERT INTO breBRG_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ra vo ho tivgroazell gourizet, hag ho lampoù war enaou, ");
INSERT INTO breBRG_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ha bezit evel tud a c'hortoz ma tistroio o mestr eus an eured, abalamour pa zeuio ha pa skoio war an nor, e tigorint dezhañ kerkent. ");
INSERT INTO breBRG_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eürus ar servijerien a vo kavet gant o mestr o veilhañ pa erruo! Me a lavar deoc'h e gwirionez, penaos en em c'hourizo, e lakaio anezho ouzh taol, hag e servijo anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mar deu d'an eil pe d'an drede veilhadenn, ha mar o c'hav er stad-se, eürus ar servijerien-se! ");
INSERT INTO breBRG_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anavezout a rit penaos mar goufe mestr an ti da bet eur e tlefe dont al laer, e chomfe dihun ha ne lezfe ket toullañ e di. ");
INSERT INTO breBRG_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","C'hwi eta ivez, bezit prest, rak Mab an den a zeuio d'an eur na soñjit ket. ");
INSERT INTO breBRG_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Neuze Pêr a lavaras dezhañ: Aotrou, pe deomp-ni, pe d'an holl, e lavarez ar barabolenn-se? ");
INSERT INTO breBRG_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hag an Aotrou a lavaras dezhañ: Piv eo ar merour feal ha fur, en deus ar mestr lakaet war e vevelien, evit reiñ dezho en amzer dereat o muzuliad ed? ");
INSERT INTO breBRG_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eürus ar servijer a vo kavet gant e vestr oc'h ober kement-se pa erruo! ");
INSERT INTO breBRG_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Me a lavar deoc'h e gwirionez, e lakaio anezhañ war gement en deus. ");
INSERT INTO breBRG_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Met mar lavar ar merour-se en e galon: Va mestr a zale da zont; ha mar en em laka da skeiñ gant ar vevelien ha gant ar mitizhien, da zebriñ, da evañ, ha d'en em vezviñ, ");
INSERT INTO breBRG_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mestr a merer-se a zeuio en deiz na c'hortoz ket, hag en eur na oar ket, e tilamo anezhañ, hag e roio dezhañ e lod gant ar re disleal. ");
INSERT INTO breBRG_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ar merer hag a anavez bolontez e vestr, ha n'eo ket en em zalc'het prest, ha n'en deus ket graet ar volontez-se, a vo skoet warnañ kalz a daolioù. ");
INSERT INTO breBRG_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Met an hini n'en deus ket hec'h anavezet, hag en deus graet traoù din a gastiz, a vo skoet warnañ nebeutoc'h a daolioù. Goulennet e vo kalz digant an hini en deus bet kalz, hag e vo goulennet muioc'h c'hoazh digant an hini a zo bet fiziet kalz ennañ. ");
INSERT INTO breBRG_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Deuet on da lakaat an tan war an douar; ha petra am eus da c'hoantaat, mar deo dija enaouet? ");
INSERT INTO breBRG_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Met dleout a ran bezañ badezet eus ur vadeziant, ha pegement em eus mall e vefe graet kement-se! ");
INSERT INTO breBRG_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Krediñ a rit on deuet da zegas ar peoc'h war an douar? Nann a lavaran deoc'h, met kentoc'h an dizunvaniezh. ");
INSERT INTO breBRG_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rak en amzer da zont, en un ti, e vo pemp dizunvanet, tri a-enep daou, ha daou a-enep tri. ");
INSERT INTO breBRG_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","An tad a vo a-enep ar mab hag ar mab a-enep an tad, ar vamm a-enep ar verc'h hag ar verc'h a-enep ar vamm, ar vamm-gaer a-enep ar verc'h-kaer hag ar verc'h-kaer a-enep ar vamm-gaer. ");
INSERT INTO breBRG_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Lavarout a reas c'hoazh d'ar bobl: Pa welit ur goumoulenn o sevel diouzh tu ar c'huzh-heol, e lavarit raktal: Dont a raio glav, hag e teu. ");
INSERT INTO breBRG_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ha pa c'hwezh avel ar c'hreisteiz, e lavarit: Tomm e vo, hag e teu da vezañ tomm. ");
INSERT INTO breBRG_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pilpouzed! Anavezout a rit doareoù an neñv hag an douar, penaos eta n'anavezit ket an amzer-mañ? ");
INSERT INTO breBRG_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ha penaos n'anavezit ket ac'hanoc'h hoc'h-unan ar pezh a zo reizh? ");
INSERT INTO breBRG_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pa'z ez gant da enebour dirak ar gouarner, evezhi en hent da ziskargañ digantañ, gant aon na lakafe ac'hanout dirak ar barner, hag ar barner da'z lakaat etre daouarn ar serjant, hag ar serjant da'z lakaat er prizon. ");
INSERT INTO breBRG_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Me a lavar penaos ne zeui ket kuit ac'hane, ken na'z po paeet an diwezhañ gwenneg. ");
INSERT INTO breBRG_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","En amzer-se, hiniennoù eus an dud en em gave eno, a lavaras da Jezuz ar pezh a oa c'hoarvezet da C'halileiz en devoa Pilat mesket o gwad gant hini o aberzhoù. ");
INSERT INTO breBRG_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ha Jezuz, o respont, a lavaras dezho: Ha krediñ a rit e oa ar C'halileiz-se brasoc'h pec'herien eget an holl C'halileiz all, abalamour m'o deus gouzañvet kement-se? ");
INSERT INTO breBRG_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nann, a lavaran deoc'h; met ma n'hoc'h eus ket keuz, e varvot holl evelto. ");
INSERT INTO breBRG_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pe krediñ a rit an triwec'h den ma'z eo kouezhet tour Siloa warno, o lazhañ anezho, a oa brasoc'h pec'herien eget holl dud Jeruzalem? ");
INSERT INTO breBRG_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nann, a lavaran deoc'h; met ma n'hoc'h eus ket keuz, e varvot holl evelto. ");
INSERT INTO breBRG_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lavarout a reas ivez ar barabolenn-mañ: Un den en devoa ur wezenn-fiez plantet en e winieg, hag e teuas da glask frouezh enni, met ne gavas ket. ");
INSERT INTO breBRG_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Neuze e lavaras d'ar gwinier: Setu, tri bloaz a zo ma teuan da glask frouezh er wezenn-fiez-mañ, ha ne gavan ket; troc'h anezhi; perak e talc'h lec'h en aner en douar? ");
INSERT INTO breBRG_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ar gwinier a respontas dezhañ: Aotrou, lez anezhi c'hoazh ar bloaz-mañ, betek ma em bo toullet en-dro dezhi ha ma em bo lakaet teil ganti. ");
INSERT INTO breBRG_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Marteze e tougo frouezh, ha ma ne ra ket, e troc'hi anezhi goude. ");
INSERT INTO breBRG_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Evel ma kelenne Jezuz en ur sinagogenn un deiz sabad, ");
INSERT INTO breBRG_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","en em gavas eno ur wreg dalc'het gant ur spered he c'hlañvae triwec'h vloaz a oa; daoubleget e oa en hevelep doare ma ne c'helle tamm ebet en em eeunañ. ");
INSERT INTO breBRG_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jezuz, o welout anezhi, he galvas hag a lavaras dezhi: Gwreg, yac'haet out eus da gleñved. ");
INSERT INTO breBRG_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Eñ a lakaas e zaouarn warni, ha kerkent en em eeunas, hag e roas gloar da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Met penn ar sinagogenn, droug ennañ eus m'en devoe Jezuz yac'haet un deiz sabad, a gemeras ar gomz hag a lavaras d'ar bobl: C'hwec'h devezh a zo evit labourat; deuit eta en deizioù-se evit bezañ yac'haet, ha neket devezh ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Met an Aotrou a respontas dezhañ: Pilpouzed, pep hini ac'hanoc'h, ha ne zistag ket e ejen pe e azen eus ar c'hraou deiz ar sabad, ha ne gas ket anezhañ d'an dour? ");
INSERT INTO breBRG_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ha ne zleed ket ivez, deiz ar sabad, distagañ eus he chadenn ar verc'h-mañ da Abraham, a oa dalc'het ereet gant Satan triwec'h bloaz a oa? ");
INSERT INTO breBRG_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Evel ma komze evel-se, e holl enebourien a voe mezhek, hag an holl bobl en em laouenae eus an holl draoù glorius a rae. ");
INSERT INTO breBRG_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lavarout a reas c'hoazh: Ouzh petra eo heñvel rouantelezh Doue, pe ouzh petra e hañvalin anezhi? ");
INSERT INTO breBRG_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Heñvel eo ouzh ur c'hreunenn sezo a gemer un den hag a laka en e liorzh; hag e kresk, hag e teu da vezañ ur wezenn vras, en hevelep doare ma teu laboused an neñv da chom en he brankoù. ");
INSERT INTO breBRG_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Lavarout a reas c'hoazh: Ouzh petra e hañvalin rouantelezh Doue? ");
INSERT INTO breBRG_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Heñvel eo ouzh ur goell a gemer ur wreg, hag a laka e tri muzuliad bleud, betek ma vo an toaz goet holl. ");
INSERT INTO breBRG_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jezuz a yae dre ar c'hêrioù ha dre ar bourc'hioù, o kelenn hag o terc'hel hent Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Unan bennak a lavaras dezhañ: Aotrou, ha ne vo salvet nemet nebeud a dud? Eñ a lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Poagnit da vont e-barzh dre an nor strizh; rak, me a lavar deoc'h, penaos kalz a glasko mont e-barzh ha ne c'hellint ket. ");
INSERT INTO breBRG_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pa vo aet mestr an ti, ha m'en devo prennet an nor, ha pa en em lakaot-c'hwi, o vezañ er-maez, da skeiñ ha da lavarout: Aotrou, Aotrou, digor deomp, eñ a responto deoc'h: N'ouzon ket a-belec'h oc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Neuze e lavarot: Ni hon eus debret hag evet dirazout, ha te ac'h eus kelennet en hor straedoù. ");
INSERT INTO breBRG_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hag eñ a responto: Me a lavar deoc'h, n'ouzon ket a-belec'h oc'h; en em dennit diouzhin, c'hwi holl a ra micher a fallentez. ");
INSERT INTO breBRG_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eno e vo goueladegoù ha grigoñsadegoù-dent, pa welot Abraham, Izaak ha Jakob, hag an holl brofeded, e rouantelezh Doue, ha c'hwi taolet er-maez. ");
INSERT INTO breBRG_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hag e teuio tud eus ar sav-heol hag eus ar c'huzh-heol, eus an hanternoz hag eus ar c'hreisteiz, a vo ouzh taol e rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ha setu ez eus re ziwezhañ hag a vo ar re gentañ, hag ez eus re gentañ hag a vo ar re ziwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","En deiz-se, e teuas d'e gavout hiniennoù eus ar farizianed, o lavarout dezhañ: Kae kuit, ha kerzh ac'han, rak Herodez a fell dezhañ da lazhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eñ a lavaras dezho: It, ha lavarit d'al louarn-se: Setu, e kasan kuit an diaoulien hag ec'h echuan da reiñ ar yec'hed d'ar re glañv, hiziv ha warc'hoazh, ha d'an trede deiz e vo peurc'hraet ganin. ");
INSERT INTO breBRG_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Koulskoude, ret eo din bale hiziv, warc'hoazh hag an deiz war-lerc'h, evit na c'hoarvezo ket e varvfe ur profed er-maez eus Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruzalem, Jeruzalem, te hag a lazh ar brofeded, hag a veinata ar re a zo kaset dit, pet gwech em eus c'hoantaet dastum da vugale, evel ma tastum ar yar he c'hlodad dindan he divaskell, ha n'eo ket bet fellet deoc'h! ");
INSERT INTO breBRG_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Setu, ho ti a ya da chom hep den, ha me a lavar deoc'h, ne'm gwelot mui, betek ma lavarot: Ra vo benniget an hini a zeu en anv an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Un deiz sabad, Jezuz a oa aet e ti unan eus pennoù ar farizianed evit debriñ; ar farizianed a selle outañ. ");
INSERT INTO breBRG_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Un den dourgoeñvet a oa dirazañ. ");
INSERT INTO breBRG_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jezuz, o kemer ar gomz, a lavaras da zoktored al lezenn ha d'ar farizianed: Hag aotreet eo yac'haat deiz ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Int a davas. Neuze, o kemer an hini klañv, en yac'haas hag en kasas kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Goude-se, e lavaras dezho: Piv ac'hanoc'h, mar kouezh e vab pe e ejen en ur puñs, na dennfe ket anezhañ er-maez kerkent, deiz ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ha ne c'helljont ket respont dezhañ war gement-se. ");
INSERT INTO breBRG_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lavarout a reas ivez d'ar re a oa pedet ur barabolenn, o welout penaos e klaskent al lec'hioù kentañ; hag e lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Pa vi pedet gant unan bennak d'un eured, n'en em laka ket er c'hentañ plas, gant aon en em gavfe e-touez ar re bedet un den enorusoc'h egedout, ");
INSERT INTO breBRG_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","hag e teufe an hini en deus ho pedet, te hag eñ, ha ne lavarfe dit: Ro al lec'h da hemañ, hag ez afes neuze gant mezh er plas diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Met pa vi pedet, kae d'en em lakaat er plas diwezhañ, abalamour pa zeuio an hini en devo da bedet, e lavaro dit: Va mignon, pign uheloc'h. Neuze, kement-se a roio enor dit dirak ar re a vo ouzh taol ganit. ");
INSERT INTO breBRG_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Rak piv bennak en em uhela a vo izelaet, ha piv bennak en em izela a vo uhelaet. ");
INSERT INTO breBRG_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hag e lavaras d'an hini en devoa e bedet: Pa ri ul lein pe ur goan, na bed ket da vignoned, na da vreudeur, na da gerent, na da amezeien binvidik, gant aon na bedfent ac'hanout d'o zro, ha na rafent dit ar memes tra. ");
INSERT INTO breBRG_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Met pa ri ur fest, ped ar beorien, ar re vac'hagnet, ar re gamm, ar re dall. ");
INSERT INTO breBRG_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hag e vi eürus dre ma ne c'hellont ket e rentañ dit, rak te az po ar pae en adsavidigezh ar re reizh. ");
INSERT INTO breBRG_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Unan eus ar re a oa ouzh taol, o vezañ klevet kement-se, a lavaras dezhañ: Eürus an hini a zebro bara e rouantelezh Doue! ");
INSERT INTO breBRG_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jezuz a lavaras dezhañ: Un den a reas ur goan vras, hag a bedas dezhi kalz a dud; ");
INSERT INTO breBRG_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","da goulz goan, e kasas e vevel da lavarout d'ar re a oa bet pedet: Deuit, rak pep tra a zo prest. ");
INSERT INTO breBRG_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hag en em lakajont holl, a-unan, da zigareziñ. An hini kentañ a lavaras dezhañ: Prenet em eus douar, ha ret eo din mont da welout anezhañ; da bediñ a ran da'm digareziñ. ");
INSERT INTO breBRG_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Unan all a lavaras: Prenet em eus pemp koublad ejened, hag ez an da welout hag int a zo mat; da bediñ a ran da'm digareziñ. ");
INSERT INTO breBRG_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hag unan all a lavaras: Ur wreg am eus kemeret, dre-se ne c'hellan ket mont. ");
INSERT INTO breBRG_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ar mevel, o vezañ distroet, a zisklêrias kement-mañ d'e vestr. Neuze mestr an ti, droug ennañ, a lavaras d'e vevel: Kae buan dre leurioù ha straedoù kêr, ha degas amañ ar beorien, ar re vac'hagnet, ar re dall hag ar re gamm. ");
INSERT INTO breBRG_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Goude, ar mevel a lavaras dezhañ: Aotrou, graet eo bet evel ma ec'h eus gourc'hemennet, ha lec'h a zo c'hoazh. ");
INSERT INTO breBRG_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ar mestr a lavaras d'ar mevel: Kae dre an hentoù hag a-hed ar girzhier, ha gra d'ar re a zo eno mont e-barzh, evit ma vo leuniet va zi. ");
INSERT INTO breBRG_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rak lavarout a ran deoc'h, hini ebet eus ar re a zo pedet ne dañvaio eus va c'hoan. ");
INSERT INTO breBRG_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Evel ma yae ul lod bras a dud gant Jezuz, e tistroas etrezek enno, hag e lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mar deu unan bennak da'm c'havout, ha ne gasa ket e dad, e vamm, e wreg, e vugale, e vreudeur, e c'hoarezed, ha muioc'h c'hoazh e vuhez hec'h-unan, ne c'hell ket bezañ va diskibl. ");
INSERT INTO breBRG_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ha piv bennak ne zougo ket e groaz, ha ne heulio ket ac'hanon, ne c'hell ket bezañ va diskibl. ");
INSERT INTO breBRG_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Rak piv ac'hanoc'h, o c'hoantaat sevel un tour, ne azez ket da gentañ, ne ra ket ar gont eus an dispign evit gwelout hag eñ en deus peadra d'e echuiñ, ");
INSERT INTO breBRG_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","gant aon, goude bezañ lakaet an diazez, na c'hellfe ket e echuiñ, ha na zeufe an holl re en gwelje d'ober goap anezhañ, ");
INSERT INTO breBRG_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ha da lavarout: An den-mañ a zo en em lakaet da sevel un tour, ha n'en deus ket gallet e echuiñ! ");
INSERT INTO breBRG_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pe, piv eo ar roue, o vont en hent evit ober brezel d'ur roue all, ne azez ket da gentañ, ha n'en em c'houlenn ket e-unan hag eñ a c'hell gant dek mil den mont da ziaraogiñ an hini a zeu a-enep dezhañ gant ugent mil? ");
INSERT INTO breBRG_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Anez, pa emañ c'hoazh pell hemañ, e kas dezhañ ur c'hannad da c'houlenn ar peoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Evel-se, piv bennak ac'hanoc'h ivez na zilez ket kement en deus, ne c'hell ket bezañ diskibl din. ");
INSERT INTO breBRG_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Un dra vat eo an holen, met mar koll e vlaz gant petra e vo e roet dezhañ? ");
INSERT INTO breBRG_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","N'eo mat, nag evit an douar, nag evit an teil; e deurel a reer er-maez. Ra selaouo an neb en deus divskouarn da glevout. ");
INSERT INTO breBRG_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","An holl bublikaned hag an dud a vuhez fall a dostae ouzh Jezuz evit e glevout. ");
INSERT INTO breBRG_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ar farizianed hag ar skribed a grozmole, o lavarout: Hemañ a zegemer an dud a vuhez fall hag a zebr ganto. ");
INSERT INTO breBRG_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Met eñ a lavaras dezho ar barabolenn-mañ: ");
INSERT INTO breBRG_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Pehini ac'hanoc'h, mar en deus kant dañvad, ha mar deu da goll unan anezho, ne lez ket an naontek ha pevar-ugent all el lec'h distro, evit mont da glask an hini a zo kollet, betek m'en deus e gavet? ");
INSERT INTO breBRG_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ha piv, o vezañ e gavet, n'en laka war e zivskoaz gant levenez, ");
INSERT INTO breBRG_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hag, o vezañ deuet d'ar gêr, ne c'halv e vignoned hag e amezeien, ha ne lavar dezho: En em laouenait ganin, rak kavet em eus va dañvad a oa kollet? ");
INSERT INTO breBRG_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Me a lavar deoc'h, e vo muioc'h a levenez en neñv evit ur pec'her hepken hag en deus keuz, eget na vo evit naontek ha pevar-ugent ha n'o deus ket ezhomm a geuzidigezh. ");
INSERT INTO breBRG_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pe, piv eo ar wreg, o kaout dek pezh arc'hant, mar koll unan anezho, n'enaou ket ur c'houlaouenn, ne skub ket he zi, ha ne glask ket gant evezh anezhañ betek ma deu d'e gavout, ");
INSERT INTO breBRG_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","hag, o vezañ kavet anezhañ, ne c'halv he mignonezed hag hec'h amezegezed, ha ne lavar dezho: En em laouenait ganin, rak kavet em eus ar pezh arc'hant am boa kollet? ");
INSERT INTO breBRG_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Me a lavar deoc'h, ez eus levenez dirak aeled Doue evit ur pec'her hepken hag en deus keuz. ");
INSERT INTO breBRG_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Lavarout a reas dezho c'hoazh: Un den en devoa daou vab. ");
INSERT INTO breBRG_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","An hini yaouankañ a lavaras d'e dad: Va zad, ro din al lodenn eus ar madoù a zle degouezhout din. Hag an tad a lodennas dezho e vadoù. ");
INSERT INTO breBRG_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Un nebeut deizioù goude, ar mab yaouankañ o vezañ dastumet kement en devoa, a yeas d'ur vro bell hag a zispignas enni e vadoù, o vevañ en diroll. ");
INSERT INTO breBRG_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Goude m'en devoa dispignet holl, e teuas un naonegezh vras er vro-se, hag en em gavas en dienez. ");
INSERT INTO breBRG_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","O vezañ aet, en em lakaas e servij unan eus tud ar vro-se; kaset e voe gantañ en e zouaroù da vesa ar moc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hag en dije karet leuniañ e gof gant ar c'hlosoù a zebre ar moc'h; met den ne roe dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","O vezañ eta deuet ennañ e-unan, e lavaras: Pegement a vevelien a zo gopraet gant va zad hag o deus bara e-leizh, ha me a varv gant an naon! ");
INSERT INTO breBRG_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Sevel a rin hag ez in da gavout va zad, hag e lavarin dezhañ: Va zad, pec'het em eus a-enep an neñv hag a-enep dit, ");
INSERT INTO breBRG_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","n'on ken din da vezañ galvet da vab; degemer ac'hanon evel unan eus da vevelien. ");
INSERT INTO breBRG_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mont a reas eta hag e teuas da gavout e dad. Evel ma oa c'hoazh pell, e dad a welas anezhañ hag en devoe truez outañ, hag, o redek d'e gavout, e lamas d'e c'houzoug hag e pokas dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","E vab a lavaras dezhañ: Va zad, pec'het em eus a-enep an neñv hag a-enep dit, n'on ken din da vezañ galvet da vab. ");
INSERT INTO breBRG_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Met an tad a lavaras d'e vevelien: degasit ar sae gaerañ, hag he gwiskit dezhañ; lakait ur walenn war e viz, ha botoù en e dreid. ");
INSERT INTO breBRG_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Degasit al leue lart ha lazhit anezhañ; debromp hag en em laouenaomp, ");
INSERT INTO breBRG_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","rak ar mab-mañ din a oa marv, hag eo distroet d'ar vuhez; kollet e oa, hag eo adkavet. Hag en em lakajont d'en em laouenaat. ");
INSERT INTO breBRG_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ar mab henañ a oa er parkeier. Pa zistroas ha pa dostaas ouzh an ti, e klevas ar sonerezh hag an dañsoù. ");
INSERT INTO breBRG_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gervel a reas unan eus ar servijerien, hag e c'houlennas digantañ petra a oa kement-se. ");
INSERT INTO breBRG_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ar servijer a lavaras dezhañ: Da vreur a zo distro, ha da dad en deus lazhet al leue lart, abalamour ma'z eo distroet yac'h. ");
INSERT INTO breBRG_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Met hemañ a yeas droug ennañ, ha ne felle ket dezhañ mont en ti. E dad a zeuas er-maez hag en pedas da vont e-barzh. ");
INSERT INTO breBRG_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Met eñ a respontas d'e dad: Setu, ez eus kement a vloazioù abaoe ma servijan ac'hanout hep bezañ biskoazh manket da'z kourc'hemenn, ha ne'c'h eus biskoazh roet din ur c'havrig evit en em laouenaat gant va mignoned. ");
INSERT INTO breBRG_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ha pa'z eo deuet ar mab-mañ dit, an hini en deus debret da vadoù gant merc'hed fall, ec'h eus lakaet lazhañ al leue lart evitañ! ");
INSERT INTO breBRG_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","E dad a lavaras dezhañ: Va mab, te a zo bepred ganin, ha kement am eus a zo dit. ");
INSERT INTO breBRG_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Met ret mat e oa en em laouenaat hag en em sederaat, rak da vreur amañ a oa marv, hag deuet eo d'ar vuhez en-dro; kollet e oa, met adkavet eo. ");
INSERT INTO breBRG_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jezuz a lavaras ivez d'e ziskibien: Un den pinvidik en devoa ur merer a oa tamallet dirazañ da vezañ dispignet e vadoù. ");
INSERT INTO breBRG_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Eñ a c'halvas anezhañ, hag a lavaras dezhañ: Petra a glevan lavarout ac'hanout? Gra din ar gont eus da c'houarnerezh, rak ne c'helli ken gouarn va madoù. ");
INSERT INTO breBRG_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Neuze ar merer-mañ a lavaras ennañ e-unan: Petra a rin, pa lam va mestr diganin gouarnerezh e vadoù? Ne c'hellfen ket labourat an douar; mezh am befe o c'houlenn aluzen. ");
INSERT INTO breBRG_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Gouzout a ran petra a rin evit ma vo tud hag am degemero en o ziez, pa vo lamet va gouarnerezh diganin,. ");
INSERT INTO breBRG_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Neuze e c'halvas hini da hini dleourien e vestr, hag e lavaras d'an hini kentañ: Pegement a dleez da'm mestr? ");
INSERT INTO breBRG_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Eñ a respontas: Kant muzuliad (= kant bat) eoul. Hag ar merer a lavaras dezhañ: Kemer da verk, azez buan, ha skriv hanter-kant. ");
INSERT INTO breBRG_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Neuze e lavaras d'un all: Ha te, pegement a dleez? Eñ a lavaras: Kant muzuliad (= kant kor) gwinizh. Ar merer a lavaras dezhañ: Kemer da verk ha skriv pevar-ugent. ");
INSERT INTO breBRG_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ar mestr a veulas ar merer disleal-se abalamour m'en devoe graet-se gant furnez; rak bugale ar c'hantved-mañ a zo furoc'h e-keñver o rummad eget bugale ar sklêrijenn. ");
INSERT INTO breBRG_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ha me a lavar deoc'h: Grit mignoned gant pinvidigezhioù direizh, abalamour pa zeuint da vankout, e tegemerint ac'hanoc'h en teltennoù peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","An hini a zo leal en traoù bihan, a vo ivez leal en traoù bras; hag an hini a zo disleal en traoù bihan, a vo ivez disleal en traoù bras. ");
INSERT INTO breBRG_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mar n'hoc'h ket bet eta leal er madoù direizh, piv a fizio ennoc'h ar madoù gwirion? ");
INSERT INTO breBRG_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ha mar n'hoc'h ket bet leal er madoù a zo d'ar re all, piv a roio deoc'h ar pezh a zo deoc'h? ");
INSERT INTO breBRG_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mevel ebet ne c'hell servijañ daou vestr; rak, pe e kasaio unan hag e karo egile, pe en em stago ouzh unan hag e tisprizo egile. Ne c'hellit ket servijañ Doue ha Mammon. ");
INSERT INTO breBRG_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ar farizianed, hag a oa tud pizh, a selaoue kement-se, hag a rae goap anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eñ a lavaras dezho: Evidoc'h-hu, c'hwi a fell deoc'h tremen evit reizh dirak an dud, met Doue a anavez ho kalonoù; rak ar pezh a zo uhel dirak an dud, a zo fall bras dirak Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Al lezenn hag ar brofeded a yae betek Yann; adalek an amzer-se rouantelezh Doue a zo prezeget, ha pep hini a ya e-barzh dre nerzh. ");
INSERT INTO breBRG_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Met aesoc'h eo d'an neñv ha d'an douar tremen, eget d'ur varrennig eus ul lizherenn hepken eus al lezenn mankout. ");
INSERT INTO breBRG_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Piv bennak a gas kuit e wreg hag a zimez da unan all, a ra avoultriezh, ha piv bennak a zimez d'ur wreg a zo bet kaset kuit gant he gwaz, a ra avoultriezh. ");
INSERT INTO breBRG_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Bez' e oa un den pinvidik en em wiske gant limestra ha lien fin, hag a veve bemdez en un doare pompadus. ");
INSERT INTO breBRG_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bez' e oa ivez ur paour, anvet Lazar, hag a oa gourvezet ouzh e zor, goloet a c'houlioù; ");
INSERT INTO breBRG_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","c'hoantaat a rae terriñ e naon gant ar bruzhun a gouezhe diwar taol an den pinvidik; hag ar chas zoken a zeue da lipat e c'houlioù. ");
INSERT INTO breBRG_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","En em gavout a reas ma varvas ar paour, hag e voe kaset gant an aeled en askre Abraham. Ar pinvidik a varvas ivez, hag e voe sebeliet; ");
INSERT INTO breBRG_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","o vezañ e lec'h ar marv, er poanioù, e savas e zaoulagad, hag e welas eus pell Abraham, ha Lazar en e askre; ");
INSERT INTO breBRG_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","o krial, e lavaras: Tad Abraham, az pez truez ouzhin, ha kas Lazar, evit ma trempo en dour penn e viz, ha ma freskaio din va zeod, rak gwall-boaniet on er flamm-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham a respontas: Va mab, az pez soñj penaos ec'h eus resevet da vadoù e-pad da vuhez, ha Lazar n'en deus bet nemet poanioù; bremañ eñ a zo diboaniet, ha te a zo er poanioù. ");
INSERT INTO breBRG_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ouzhpenn-se, bez' ez eus ur poull bras etre c'hwi ha ni, en hevelep doare ha pa fellfe d'ar re a zo amañ tremen aze, ne c'hellfent ket, kennebeut ha d'ar re a zo aze dont d'hor c'havout-ni. ");
INSERT INTO breBRG_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ar pinvidik a lavaras: Da bediñ a ran eta, tad Abraham, da gas Lazar da di va zad, rak pemp breur am eus, ");
INSERT INTO breBRG_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","evit testeniañ dezho an traoù-mañ, gant aon na zeufent ivez el lec'h-mañ a boanioù. ");
INSERT INTO breBRG_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham a respontas dezhañ: Bez' o deus Moizez hag ar brofeded; ra selaouint anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ar pinvidik a lavaras: Nann, tad Abraham; met mar da unan bennak eus ar re varv d'o c'havout, o devo keuz. ");
INSERT INTO breBRG_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hag Abraham a lavaras dezhañ: Ma ne selaouont ket Moizez, nag ar brofeded, ne gredint ket kennebeut, ha pa savfe unan bennak a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jezuz a lavaras d'e ziskibien: Ret eo e c'hoarvezfe skouerioù fall; met gwalleur d'an hini ma teuint drezañ. ");
INSERT INTO breBRG_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gwelloc'h eo dezhañ e vefe staget ouzh e c'houzoug ur maen-milin, hag e vefe taolet er mor, eget ma rofe skouer fall da unan eus ar re vihan-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Lakait evezh ouzhoc'h. Mar en deus da vreur pec'het a-enep dit, tamall anezhañ; ha mar en deus keuz, pardon dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mar pec'h seizh gwech an deiz en da enep, ha mar distro seizh gwech an deiz da'z kavout, o lavarout: Keuz am eus, pardon dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","An ebestel a lavaras d'an Aotrou: Kresk deomp hor feiz. ");
INSERT INTO breBRG_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hag an Aotrou a lavaras: Mar ho pije feiz kement hag ur c'hreunenn sezo, e lavarfec'h d'ar wezenn-sikomor-se: En em ziwrizienn alese, hag en em blant er mor; hag e sentfe ouzhoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Piv ac'hanoc'h, mar en deus ur mevel oc'h arat, pe o vesa al loened, a lavaro dezhañ kerkent ha ma tistroio eus ar parkeier: Tost amañ, hag en em laka ouzh taol? ");
INSERT INTO breBRG_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ha ne lavaro ket kentoc'h dezhañ: Aoz koan din, en em c'houriz ha servij ac'hanon, betek ma em bo debret hag evet; ha goude-se e tebri hag ec'h evi. ");
INSERT INTO breBRG_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ha trugarez en devo d'ar mevel-se, abalamour m'en deus graet ar pezh en deus gourc'hemennet dezhañ? Ne gredan ket. ");
INSERT INTO breBRG_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","C'hwi ivez, pa ho po graet kement a zo gourc'hemennet deoc'h, lavarit: Mevelien didalvoudek omp, abalamour n'hon eus graet nemet ar pezh a oa ret deomp ober. ");
INSERT INTO breBRG_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Evel ma'z ae da Jeruzalem, e tremene war harzoù Samaria ha Galilea, ");
INSERT INTO breBRG_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","hag evel ma'z antree en ur vourc'h, e voe diarbennet gant dek den lovr en em zalc'he pell dioutañ. ");
INSERT INTO breBRG_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Int, o sevel o mouezh, a grias: Jezuz, mestr, az pez truez ouzhimp! ");
INSERT INTO breBRG_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","O vezañ o gwelet, e lavaras dezho: It, hag en em ziskouezit d'ar veleien. Hag e c'hoarvezas pa oant o vont kuit, e voent naetaet. ");
INSERT INTO breBRG_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unan anezho, o welout e oa yac'haet, a zistroas o reiñ gloar da Zoue a vouezh uhel. ");
INSERT INTO breBRG_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hag en em daolas ouzh treid Jezuz, e c'henou d'an douar, o trugarekaat. Hemañ a oa Samaritan. ");
INSERT INTO breBRG_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jezuz, o kemer ar gomz, a lavaras: An holl zek, ha n'int ket bet yac'haet? Pelec'h eta emañ an dek all? ");
INSERT INTO breBRG_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","N'eus en em gavet nemet an diavaeziad-mañ hag a zo distroet da reiñ gloar da Zoue? ");
INSERT INTO breBRG_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Neuze e lavaras dezhañ: Sav, kae, da feiz en deus da yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ar farizianed, o vezañ goulennet outañ pegoulz e teuje rouantelezh Doue, e respontas dezho: Rouantelezh Doue ne zeuio ket en un doare sebezus. ");
INSERT INTO breBRG_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ne vo ket lavaret: Emañ amañ, pe: Emañ aze; rak setu, emañ rouantelezh Doue en ho touez. ");
INSERT INTO breBRG_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hag e lavaras d'e ziskibien: Dont a raio un amzer ma ho po c'hoant da welout unan eus deizioù Mab an den, ha n'en gwelot ket. ");
INSERT INTO breBRG_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hag e vo lavaret deoc'h: Setu emañ amañ, pe: Setu emañ aze. N'it ket, ha na heuilhit ket anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Rak evel ma teu ul luc'hedenn da lugerniñ eus ur penn d'an oabl betek ur penn all, evel-se e teuio Mab an den en e zeiz. ");
INSERT INTO breBRG_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Met ret eo dezhañ kent-se gouzañv kalz a draoù, ha bezañ taolet kuit gant ar rummad-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ar pezh a erruas en amzer Noe, a erruo en hevelep doare en amzer Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","An dud a zebre, a eve, a zimeze hag a roe e dimeziñ, betek an deiz ma'z eas Noe en arc'h, hag an dour-beuz a zeuas hag o distrujas holl. ");
INSERT INTO breBRG_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kement-se a erruas c'hoazh en amzer Lot; an dud a zebre, a eve, a brene, a werzhe, a blante hag a save tiez; ");
INSERT INTO breBRG_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","met en deiz ma'z eas Lot kuit eus Sodom, e teuas glav tan ha soufr eus an neñv hag o distrujas holl. ");
INSERT INTO breBRG_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Evel-se e vo ivez en deiz ma teuio Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","En deiz-se, an hini a vo war an doenn hag en devo e draoù e-barzh an ti, arabat e vo dezhañ diskenn evit o c'has gantañ; en hevelep doare, an hini a vo er parkeier, arabat e vo dezhañ mont war-dreñv. ");
INSERT INTO breBRG_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ho pet soñj eus gwreg Lot. ");
INSERT INTO breBRG_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Piv bennak a glasko saveteiñ e vuhez, he c'hollo, ha piv bennak he c'hollo, he c'havo. ");
INSERT INTO breBRG_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Me a lavar deoc'h, penaos en noz-se, eus daou den a vo en un hevelep gwele, unan a vo kemeret hag egile lezet, ");
INSERT INTO breBRG_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","eus div wreg a valo a-gevret, unan a vo kemeret hag eben lezet, ");
INSERT INTO breBRG_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","eus daou den a vo er parkeier, unan a vo kemeret hag egile lezet. ");
INSERT INTO breBRG_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","O respont, e lavarjont dezhañ: Pelec'h e vo, Aotrou? Eñ a lavaras dezho: E-lec'h ma vo ar c'horf, en em zastumo an erered. ");
INSERT INTO breBRG_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jezuz a lavaras ivez dezho ar barabolenn-mañ, evit diskouez penaos eo ret pediñ bepred, hag hep skuizhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Bez' e oa en ur gêr ur barner na zouje ket Doue, ha n'en devoa respet ebet evit den. ");
INSERT INTO breBRG_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bez' e oa ivez er gêr-se un intañvez a zeue d'e gavout, o lavarout: Gra din reizh diouzh va enebour. ");
INSERT INTO breBRG_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","E-pad pell amzer ne c'hoantaas ober netra. Koulskoude e lavaras ennañ e-unan: Petra bennak na zoujan ket Doue, ha na'm eus respet ebet evit den, ");
INSERT INTO breBRG_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","koulskoude, dre ma teu an intañvez-mañ da skuizhañ ac'hanon, e rin reizh dezhi, gant aon na gendalc'hfe da derriñ din va fenn. ");
INSERT INTO breBRG_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hag an Aotrou a lavaras: Selaouit ar pezh a lavar ar barner disleal-se. ");
INSERT INTO breBRG_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Doue, ha ne raio ket reizh d'e re dibabet a gri dezhañ noz-deiz, hag e taleo en o c'heñver? ");
INSERT INTO breBRG_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Me a lavar deoc'h, e raio reizh dezho prest. Met pa zeuio Mab an den, ha kavout a raio feiz war an douar? ");
INSERT INTO breBRG_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lavarout a reas ivez ar barabolenn-mañ, diwar-benn tud a grede enno o-unan e oant tud reizh, hag a zisprize ar re all: ");
INSERT INTO breBRG_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Daou zen a bignas d'an templ da bediñ; unan a oa farizian, hag egile a oa publikan. ");
INSERT INTO breBRG_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ar farizian, oc'h en em zerc'hel en e sav, a bede evel-hen ennañ e-unan: O Doue, da drugarekaat a ran dre ma n'on ket evel an dud all, a zo laeron, direizh, avoultrerien, nag ivez evel ar publikan-se. ");
INSERT INTO breBRG_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yunañ a ran div wech ar sizhun, reiñ a ran an deog eus kement am eus. ");
INSERT INTO breBRG_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Met ar publikan, oc'h en em zerc'hel pell, ne grede ket memes sevel e zaoulagad d'an neñv; met skeiñ a rae war boull e galon, o lavarout: O Doue, az pez truez ouzhin, ur pec'her on! ");
INSERT INTO breBRG_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Me a lavar deoc'h, hemañ a zistroas pardonet d'e di kentoc'h eget egile; rak piv bennak en em uhela, a vo izelaet, ha piv bennak en em izela, a vo uhelaet. ");
INSERT INTO breBRG_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Degaset e voe dezhañ bugale vihan, evit ma stokje outo; met an diskibien, o welout kement-se, a c'hrozmole d'ar re o degase. ");
INSERT INTO breBRG_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jezuz, o c'hervel anezho d'e gavout, a lavaras: Lezit ar vugale vihan da zont da'm c'havout, ha na zifennit ket outo; rak rouantelezh Doue a zo d'ar re a zo heñvel outo. ");
INSERT INTO breBRG_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Me a lavar deoc'h e gwirionez, penaos piv bennak ne zegemero ket rouantelezh Doue evel ur bugel bihan, ne yelo ket e-barzh. ");
INSERT INTO breBRG_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Unan eus ar pennoù a c'houlennas digantañ: Mestr mat, petra a dlean d'ober evit kaout ar vuhez peurbadus? ");
INSERT INTO breBRG_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jezuz a lavaras dezhañ: Perak em galvez mat? N'eus hini mat nemet Doue hepken. ");
INSERT INTO breBRG_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Anavezout a rez ar gourc'hemennoù: Na ra ket avoultriezh; Na lazh ket; Na laer ket; Na lavar ket a falstesteni; Enor da dad ha da vamm. ");
INSERT INTO breBRG_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eñ a lavaras dezhañ: Miret em eus an holl draoù-se adalek va yaouankiz. ");
INSERT INTO breBRG_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jezuz, o klevout kement-se, a lavaras: Mankout a ra dit c'hoazh un dra: Gwerzh kement ac'h eus, en ro d'ar beorien, hag ez po un teñzor en neñv; goude-se deus hag heul ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pa en devoe klevet kement-se, e teuas gwall-drist; rak pinvidik bras e oa. ");
INSERT INTO breBRG_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jezuz, o welout e oa deuet gwall-drist, a lavaras: Pegen diaes eo d'ar re o deus madoù mont e rouantelezh Doue! ");
INSERT INTO breBRG_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aesoc'h eo d'ur c'hañval tremen dre graoenn un nadoz eget d'un den pinvidik mont e-barzh rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ar re en kleve a lavaras: Ha piv a c'hell bezañ salvet? ");
INSERT INTO breBRG_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jezuz a lavaras dezho: Ar pezh a zo dibosupl d'an dud a zo posupl da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pêr a lavaras: Setu, ni hon eus dilezet pep tra, hag hon eus da heuliet. ");
INSERT INTO breBRG_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Eñ a lavaras dezho: Me a lavar deoc'h e gwirionez: N'eus den en defe kuitaet, ti, pe wreg, pe vreudeur, pe gerent, pe vugale, evit rouantelezh Doue, ");
INSERT INTO breBRG_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ha ne resevo kalz muioc'h er c'hantved-mañ, hag er c'hantved da zont, ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jezuz a gemeras neuze a-du an daouzek, hag a lavaras dezho: Setu, e pignomp da Jeruzalem, hag an holl draoù a zo bet skrivet gant ar brofeded diwar-benn Mab an den, a ya da vezañ graet. ");
INSERT INTO breBRG_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Rak lakaet e vo etre daouarn ar baganed, graet e vo goap anezhañ, dismegañset e vo, krañchet e vo outañ, ");
INSERT INTO breBRG_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ha goude ma vo bet skourjezet, e vo lakaet d'ar marv, hag ec'h adsavo a varv d'an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Met ne gomprenent netra e kement-se; ar c'homzoù-se a oa kuzhet evito, ha ne ouient ket ar pezh a oa lavaret dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Evel ma tostae ouzh Jeriko, un den dall a oa azezet war gostez an hent, hag a c'houlenne an aluzen; ");
INSERT INTO breBRG_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","o klevout ar bobl a dremene, e c'houlennas petra a oa kement-se. ");
INSERT INTO breBRG_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Lavaret e voe dezhañ e tremene Jezuz a Nazared. ");
INSERT INTO breBRG_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Neuze e krias: Jezuz, Mab David, az pez truez ouzhin! ");
INSERT INTO breBRG_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ar re a yae a-raok a groze dezhañ evit ma tavje; met eñ a grie c'hoazh kreñvoc'h: Mab David, az pez truez ouzhin! ");
INSERT INTO breBRG_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jezuz, o chom a-sav, a c'hourc'hemennas en degas d'e gavout; ha pa voe tostaet, ");
INSERT INTO breBRG_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","e c'houlennas outañ: Petra a fell dit e rafen evidout? Eñ a respontas: Aotrou, ma'c'h adkavin ar gweled. ");
INSERT INTO breBRG_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ha Jezuz a lavaras dezhañ: Adkav ar gweled, da feiz he deus da yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kerkent ec'h adkavas ar gweled, hag ec'h heulias Jezuz, o reiñ gloar da Zoue. An holl bobl, o welout kement-se, a veulas Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jezuz, o vezañ aet e Jeriko, a dremene dre gêr. ");
INSERT INTO breBRG_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ha setu un den anvet Zake, a oa penn ar bublikaned ha pinvidik, ");
INSERT INTO breBRG_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","a glaske gwelout piv oa Jezuz; met ne c'helle ket abalamour d'ar bobl, rak gwall vihan e oa. ");
INSERT INTO breBRG_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dre-se e redas a-raok, hag e pignas war ur wezenn-sikomor evit e welout, abalamour ma tlee tremen dre eno. ");
INSERT INTO breBRG_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jezuz, o vezañ deuet el lec'h-se, hag o sevel e zaoulagad, a welas anezhañ hag a lavaras dezhañ: Zake, diskenn buan, rak ret eo din lojañ hiziv ez ti. ");
INSERT INTO breBRG_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eñ a ziskennas buan, hag en degemeras gant levenez. ");
INSERT INTO breBRG_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","An holl re a welas kement-se a grozmole, o lavarout e oa aet da lojañ e ti un den a vuhez fall. ");
INSERT INTO breBRG_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Met Zake en em zalc'has dirak an Aotrou, hag a lavaras dezhañ: Aotrou, reiñ a ran an hanter eus va madoù d'ar beorien, ha mar em eus noazet ouzh unan bennak en un dra bennak, e roan dezhañ peder gwech kement all. ");
INSERT INTO breBRG_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jezuz a lavaras dezhañ: Ar silvidigezh a zo deuet hiziv en ti-mañ, abalamour ma'z eo hemañ ivez mab da Abraham. ");
INSERT INTO breBRG_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Rak Mab an den a zo deuet da glask ha da saveteiñ ar pezh a oa kollet. ");
INSERT INTO breBRG_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Evel ma selaouent ar c'homzoù-se, Jezuz, o kenderc'hel, a ginnigas ur barabolenn, abalamour ma oant tost ouzh Jeruzalem, ha ma kredent ez ae rouantelezh Doue d'en em ziskouez prest. ");
INSERT INTO breBRG_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Lavarout a reas neuze: Un den a lignez uhel a yeas d'ur vro bell evit kemer ur rouantelezh dezhañ, ha distreiñ goude. ");
INSERT INTO breBRG_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","O vezañ galvet dek eus e servijerien, e roas dezho dek minenn, hag e lavaras dezho: Lakait anezho da dalvezout, betek ma tistroin. ");
INSERT INTO breBRG_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Met tud e vro a gasae anezhañ, hag e kasjont ur c'hannadur war e lerc'h, evit lavarout: Ne fell ket deomp e renfe hemañ warnomp. ");
INSERT INTO breBRG_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Erruout a reas eta, pa voe distroet goude bezañ kemeret e rouantelezh, ma c'hourc'hemennas lakaat degas e servijerien en devoa roet arc'hant dezho, evit gouzout pegement en devoa gounezet pep hini gantañ. ");
INSERT INTO breBRG_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","An hini kentañ, o vezañ deuet, a lavaras: Aotrou, da vinenn he deus gounezet dek all. ");
INSERT INTO breBRG_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eñ a lavaras dezhañ: Mat eo, servijer mat, abalamour ma'z out bet feal e nebeud a draoù, ez po ar galloud war dek kêr. ");
INSERT INTO breBRG_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","An eil a zeuas hag a lavaras: Aotrou, da vinenn he deus gounezet pemp all. ");
INSERT INTO breBRG_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eñ a lavaras ivez da hemañ: Ha te, az pez ar galloud war bemp kêr. ");
INSERT INTO breBRG_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hag unan all a zeuas, hag a lavaras: Aotrou, setu da vinenn am eus miret paket en ul lienenn; ");
INSERT INTO breBRG_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","rak da zoujañ a ran, gouzout a ran penaos out un den garv, e kemerez e-lec'h na'c'h eus lakaet netra, hag e vedez e-lec'h na'c'h eus ket hadet. ");
INSERT INTO breBRG_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eñ a lavaras dezhañ: Servijer fall, da varn a rin dre da gomzoù da-unan; gouzout a ouies ez on un den garv, a gemer e-lec'h na'm eus lakaet netra hag a ved e-lec'h na'm eus ket hadet. ");
INSERT INTO breBRG_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Perak eta ne'c'h eus ket lakaet va arc'hant en ti-bank, hag em distro, em bije e zilamet gant ar c'hampi? ");
INSERT INTO breBRG_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hag e lavaras d'ar re a oa eno: Lamit digantañ ar vinenn-se, ha roit hi d'an hini en deus dek minenn. ");
INSERT INTO breBRG_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Int a lavaras dezhañ: Aotrou, dija en deus dek minenn. ");
INSERT INTO breBRG_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Me a lavar deoc'h, e vo roet d'an neb en deus; met an hini n'en deus ket, e vo lamet digantañ memes ar pezh en deus. ");
INSERT INTO breBRG_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E-keñver va enebourien, ar re ne felle ket dezho e renjen warno, degasit int amañ, ha lazhit int dirazon. ");
INSERT INTO breBRG_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Goude bezañ lavaret kement-se, e pignas da Jeruzalem, o vont a-raok ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","O vezañ tostaet ouzh Betfage hag ouzh Betania, tost d'ar menez anvet Menez an Olived, e kasas daou eus e ziskibien, ");
INSERT INTO breBRG_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","o lavarout: It d'ar vourc'h a zo dirazoc'h, ha pa viot aet enni, e kavot un azenig stag, ma n'eus bet c'hoazh pignet den warnañ; distagit eñ, ha degasit eñ din. ");
INSERT INTO breBRG_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ha mar goulenn unan bennak ouzhoc'h: Perak e tistagit anezhañ? C'hwi a lavaro dezhañ: abalamour m'en deus an Aotrou ezhomm anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ar re gaset a yeas, hag a gavas pep tra evel m'en devoa lavaret dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Evel ma tistagent an azenig, e vistri a lavaras dezho: Perak e tistagit an azenig-se? ");
INSERT INTO breBRG_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hag e respontjont: An Aotrou en deus ezhomm anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hag e tegasjont anezhañ da Jezuz; o vezañ lakaet o dilhad war an azenig, e lakajont Jezuz da bignat warnañ. ");
INSERT INTO breBRG_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Evel ma tremene, kalz a astenne o dilhad war an hent. ");
INSERT INTO breBRG_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ha pa oa o tostaat d'an diskenn eus Menez an Olived, an holl vandenn diskibien, karget a levenez, en em lakaas da veuliñ Doue a vouezh uhel evit an holl virakloù o devoa gwelet. ");
INSERT INTO breBRG_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hag e lavarent: Benniget ra vo ar Roue a zeu en anv an Aotrou! Peoc'h en neñv, ha gloar el lec'hioù uhel meurbet! ");
INSERT INTO breBRG_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hiniennoù eus farizianed ar vandenn a lavaras dezhañ: Mestr, kroz da ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eñ a respontas hag a lavaras dezho: Me a lavar deoc'h, mar tav ar re-mañ, ar vein a grio. ");
INSERT INTO breBRG_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pa voe tost da gêr, o welout anezhi, e ouelas warni, hag e lavaras: ");
INSERT INTO breBRG_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","O! Ma ez pije anavezet, te ivez, da vihanañ en deiz-mañ a zo roet dit, an traoù a sell ouzh da beoc'h! Met bremañ, kuzhet int da'z taoulagad. ");
INSERT INTO breBRG_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Rak deizioù a zeuio warnout, ma raio da enebourien fozioù en-dro dit, hag e kelc'hint ac'hanout, hag e waskint ac'hanout a bep tu. ");
INSERT INTO breBRG_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hag e tiskarint ac'hanout, te ha da vugale a zo en da greiz, ha ne lezint ket ennout maen war vaen, abalamour na'c'h eus ket anavezet an amzer ma'z out bet gweladennet. ");
INSERT INTO breBRG_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Neuze, o vezañ aet en templ, en em lakaas da gas kuit ar re a werzhe hag a brene e-barzh, ");
INSERT INTO breBRG_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","o lavarout dezho: Skrivet eo: Va zi a vo un ti a bedenn. Met c'hwi hoc'h eus graet anezhañ ur c'havarn laeron. ");
INSERT INTO breBRG_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hag e kelenne bemdez en templ. Ar veleien vras, ar skribed, ha pennoù ar bobl a glaske e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Met ne ouient ket petra d'ober, rak an holl bobl en em stage ouzh e gomzoù. ");
INSERT INTO breBRG_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Un deiz ma kelenne Jezuz ar bobl en templ, ha ma prezege an Aviel, ar veleien vras, ar skribed, hag an henaourien, o vezañ deuet, a gomzas outañ, ");
INSERT INTO breBRG_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","hag a lavaras dezhañ: Lavar deomp dre beseurt galloud e rez an traoù-se, ha piv en deus roet dit ar galloud-se? ");
INSERT INTO breBRG_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Eñ a respontas dezho: Me a c'houlenno ivez un dra ouzhoc'h; lavarit din, ");
INSERT INTO breBRG_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","badeziant Yann, ha dont a rae eus an neñv, pe eus an dud? ");
INSERT INTO breBRG_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hag int a soñje enno oc'h-unan, o lavarout: Mar lavaromp: Eus an neñv, e lavaro: Perak eta n'hoc'h eus ket kredet ennañ? ");
INSERT INTO breBRG_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ha mar lavaromp: Eus an dud, an holl bobl hor meinataio; rak krediñ a reont ez eo Yann ur profed. ");
INSERT INTO breBRG_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dre-se e respontjont ne ouient ket a-belec'h e teue. ");
INSERT INTO breBRG_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ha Jezuz a lavaras dezho: Ha me kennebeut, ne lavarin ket deoc'h dre beseurt galloud e ran an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Neuze en em lakaas da lavarout d'ar bobl ar barabolenn-mañ: Un den a blantas ur winieg, he feurmas da winierien, hag ez eas evit pell amzer en ur vro all. ");
INSERT INTO breBRG_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Da amzer ar frouezh e kasas unan eus e servijerien etrezek ar winierien, evit ma rojent dezhañ frouezh eus ar winieg. Met ar winierien a gannas anezhañ hag e kasjont anezhañ kuit hep netra. ");
INSERT INTO breBRG_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kas a reas dezho c'hoazh ur servijer all; met e kannjont anezhañ, e rejont dezhañ meur a zismegañs, hag e kasjont anezhañ kuit hep netra. ");
INSERT INTO breBRG_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kas a reas c'hoazh un trede, met int a c'hloazas anezhañ ivez, hag e gasas kuit. ");
INSERT INTO breBRG_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mestr ar winieg a lavaras neuze: Petra a rin? Kas a rin va mab karet-mat; marteze, pa en gwelint, e toujint anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Met ar winierien, o vezañ e welet, a soñjas enno o-unan, o lavarout: Setu an heritour; deuit, lazhomp-eñ, evit ma vo an heritaj deomp. ");
INSERT INTO breBRG_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hag o vezañ e daolet er-maez eus ar winieg, e lazhjont anezhañ. Petra eta a raio mestr ar winieg? ");
INSERT INTO breBRG_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dont a raio, hag e tistrujo ar winierien-se, hag e roio ar winieg da re all. O vezañ klevet kement-se, e lavarjont: Ra ne c'hoarvezo ket-se! ");
INSERT INTO breBRG_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Neuze, Jezuz, o sellout outo, a lavaras dezho: Petra eta eo ar pezh a zo skrivet evel-hen: Ar maen taolet kuit gant ar re a vañsone, a zo deuet da vezañ penn ar c'horn? ");
INSERT INTO breBRG_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","An hini a gouezho war ar maen-se a vo brevet, ha flastret e vo an hini ma kouezho warnañ. ");
INSERT INTO breBRG_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Neuze ar veleien vras hag ar skribed a glaskas lakaat o daouarn warnañ d'an eur-se memes, rak anavezet o devoa mat penaos en devoa lavaret ar barabolenn-se a-enep dezho; met aon o devoa rak ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Setu perak, oc'h evezhiañ anezhañ, e kasjont dezhañ tud hag a rae an neuz da vezañ reizh, evit e dapout en e gomzoù, abalamour d'e lakaat e daouarn mestr ar vro hag e galloud ar gouarner. ");
INSERT INTO breBRG_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","An dud-mañ eta a c'houlennas digantañ: Mestr, gouzout a reomp e komzez hag e kelennez gant eeunder ha ne rez van a zen ebet, met e kelennez hent Doue hervez ar wirionez. ");
INSERT INTO breBRG_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ha dleet eo paeañ ar gwir da Gezar, pe n'eo ket? ");
INSERT INTO breBRG_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Met eñ, oc'h anavezout o gwidre, a lavaras dezho: Perak e temptit ac'hanon? ");
INSERT INTO breBRG_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Diskouezit din un diner. Eus piv eo ar skeud hag ar skrid-mañ? Int a respontas: Eus Kezar. ");
INSERT INTO breBRG_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Neuze eñ a lavaras dezho: Roit eta da Gezar ar pezh a zo da Gezar, ha da Zoue ar pezh a zo da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne c'helljont ket e dapout en e gomzoù dirak ar bobl; met, o vezañ souezhet gant e respont, e tavjont. ");
INSERT INTO breBRG_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Neuze hiniennoù a-douez ar sadukeiz, ar re a lavar n'eus ket a adsavidigezh a varv, a dostaas, hag a reas outañ ar goulenn-mañ: ");
INSERT INTO breBRG_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mestr, Moizez en deus gourc'hemennet deomp, ma teuje breur unan bennak da vervel ha da lezel e wreg hep bugale, e vreur a zimezo d'ar wreg, evit sevel lignez d'e vreur. ");
INSERT INTO breBRG_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bez' e oa eta seizh breur. An hini kentañ o vezañ kemeret ur wreg, a varvas hep lezel bugale. ");
INSERT INTO breBRG_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","An eil a zimezas d'e wreg, hag a varvas hep bugale. ");
INSERT INTO breBRG_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","An trede he c'hemeras ivez, hag o seizh holl en hevelep doare, hag e varvjont hep lezel bugale. ");
INSERT INTO breBRG_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ha goude holl ar wreg a varvas ivez. ");
INSERT INTO breBRG_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A behini anezho e vo eta gwreg, en adsavidigezh a varv? Rak bet eo gwreg dezho o seizh. ");
INSERT INTO breBRG_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jezuz a respontas dezho: Bugale ar c'hantved-mañ a zimez, hag a ro da zimeziñ. ");
INSERT INTO breBRG_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Met ar re a vo kavet din da gaout lod er c'hantved da zont en adsavidigezh a-douez ar re varv, ne zimezint ket ha ne roint ket da zimeziñ. ");
INSERT INTO breBRG_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Rak ne c'hellint ket kennebeut mervel, abalamour ma vint heñvel ouzh an aeled, ha ma vint bugale Doue, o vezañ bugale an adsavidigezh a varv. ");
INSERT INTO breBRG_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Met, penaos ar re varv a adsav da vev, kement-se eo a ziskouez Moizez pa c'halv er vodenn loskus an Aotrou, Doue Abraham, Doue Izaak ha Doue Jakob. ");
INSERT INTO breBRG_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Doue n'eo ket Doue ar re varv, met Doue ar re vev; rak an holl a vev evitañ. ");
INSERT INTO breBRG_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hag hiniennoù eus ar skribed, o kemer ar gomz, a lavaras: Mestr, komzet mat ec'h eus. ");
INSERT INTO breBRG_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ha ne gredent ken goulenn netra outañ. ");
INSERT INTO breBRG_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Neuze e lavaras dezho: Perak e lavarer eo ar C'hrist Mab David? ");
INSERT INTO breBRG_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David e-unan a lavar e levr ar Salmoù: An Aotrou en deus lavaret da'm Aotrou: Azez a-zehou din, ");
INSERT INTO breBRG_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","betek ma em bo graet eus da enebourien ur skabell dindan da dreid. ");
INSERT INTO breBRG_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mar galv eta David anezhañ Aotrou, penaos eo eñ e vab? ");
INSERT INTO breBRG_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Evel ma selaoue an holl bobl, e lavaras d'e ziskibien: ");
INSERT INTO breBRG_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Diwallit diouzh ar skribed a gar pourmen gant saeoù hir ha bezañ saludet er marc'hallac'hioù, hag a gar ar c'hadorioù kentañ er sinagogennoù, hag ar plasoù kentañ er festoù; ");
INSERT INTO breBRG_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","int a zismantr tiez an intañvezed, hag a ra evit ar gweled pedennoù hir; bez' o devo ur varnedigezh gwashoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","O vezañ savet e zaoulagad, Jezuz a welas tud pinvidik a lakae o frofoù e teñzor an templ. ");
INSERT INTO breBRG_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Gwelout a reas ivez un intañvez paour, a lakaas e-barzh daou bezhig. ");
INSERT INTO breBRG_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hag e lavaras: Me a lavar deoc'h e gwirionez, an intañvez paour-se he deus lakaet e-barzh muioc'h eget an holl re all. ");
INSERT INTO breBRG_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Rak holl o deus lakaet, e profoù, eus ar pezh o devoa a-re; met houmañ he deus lakaet eus he dienez, kement holl he devoa evit bevañ. ");
INSERT INTO breBRG_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hag evel ma lavare hiniennoù dezhañ e oa savet an templ gant mein gaer ha gant profoù pinvidik, e lavaras: ");
INSERT INTO breBRG_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","C'hwi a sell ouzh an traoù-se! Deizioù a zeuio ma ne chomo ket anezho maen war vaen na vo diskaret. ");
INSERT INTO breBRG_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hag e c'houlennjont outañ: Mestr, pegoulz en em gavo an traoù-se, ha dre beseurt sin e vo anavezet e vint prest da c'hoarvezout? ");
INSERT INTO breBRG_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hag e lavaras: Diwallit na dromplfe den ac'hanoc'h; rak kalz a zeuio em anv, o lavarout: Me eo ar C'hrist, hag an amzer a dosta. N'it ket eta war o lerc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pa glevot komz eus brezelioù, hag eus dispac'hioù, na spontit ket, rak ret eo e teufe an traoù-se a-raok; met ne vo ket kerkent ar fin. ");
INSERT INTO breBRG_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lavarout a reas dezho ivez: Ur bobl a savo a-enep ur bobl all, hag ur rouantelezh a-enep ur rouantelezh all; ");
INSERT INTO breBRG_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","hag e vo krenoù-douar bras e meur a lec'h, ha naonegezhioù, ha bosennoù; hag en em ziskouezo traoù spouronus, ha sinoù bras en neñv. ");
INSERT INTO breBRG_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Met, a-raok an holl draoù-se, e lakaint o daouarn warnoc'h hag e wallgasint ac'hanoc'h, ho kasint en o sinagogennoù hag ho lakaint er prizon, hag ho kasint dirak ar rouaned ha dirak an ouarnerien, abalamour da'm anv. ");
INSERT INTO breBRG_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kement-se a vo evidoc'h ul lec'h da desteniañ. ");
INSERT INTO breBRG_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lakait eta en ho kalon na dleit ket soñjal a-raok en ho tifenn, ");
INSERT INTO breBRG_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","rak me a roio deoc'h ur genou hag ur furnez na c'hellint respont netra hoc'h holl enebourien dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","C'hwi a vo gwerzhet gant ho kerent, gant ho preudeur, gant ho nesañ ha gant ho mignoned, hag e lakaint kalz ac'hanoc'h d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","C'hwi a vo kasaet gant an holl, abalamour da'm anv. ");
INSERT INTO breBRG_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Met n'en em gollo ket ur vlevenn eus ho penn. ");
INSERT INTO breBRG_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Derc'hel a reot hoc'h eneoù dre ho kouzañvusted sioul. ");
INSERT INTO breBRG_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pa welot Jeruzalem kelc'hiet gant armeoù, gouezit eo tost he glac'har. ");
INSERT INTO breBRG_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Neuze ar re a vo e Judea, ra dec'hint war ar menezioù; ar re a vo e-kreiz Jeruzalem, ra en em dec'hint er-maez anezhi; hag ar re a vo er parkeier, ra chomint hep mont e kêr. ");
INSERT INTO breBRG_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Rak bez' e vint deizioù a gastiz, abalamour d'an holl draoù a zo bet skrivet da erruout. ");
INSERT INTO breBRG_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gwalleur d'ar gwragez brazez, ha d'ar magerezed en deizioù-se! Rak ur glac'har bras a vo war ar vro-mañ, ha droug a vo a-enep ar bobl-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kouezhañ a raint dindan dremm ar c'hleze, kaset e vint da sklaved e-touez an holl bobloù, ha Jeruzalem a vo mac'het gant ar bobloù, betek ma vo peurleuniet amzerioù ar bobloù. ");
INSERT INTO breBRG_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Bez' e vo sinoù en heol, el loar hag er stered; ha war an douar, ar bobloù a vo en nec'hamant, ha ne ouezint petra d'ober e-keñver ar mor hag e donnoù oc'h ober un trouz bras. ");
INSERT INTO breBRG_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","An dud a vo prest da rentañ o ene gant ar spont, o c'hortoz an traoù a dle c'hoarvezout er bed, rak galloudoù an neñvoù a vo hejet. ");
INSERT INTO breBRG_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ha neuze e vo gwelet Mab an den, o tont war ur c'hoabr, gant ur galloud hag ur gloar bras. ");
INSERT INTO breBRG_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pa en em lakaio an traoù-se da c'hoarvezout, sellit d'an nec'h, ha savit ho pennoù, rak ho tasprenadur a dosta. ");
INSERT INTO breBRG_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hag e lavaras dezho ur barabolenn: Gwelit ar wezenn-fiez hag an holl wez all: ");
INSERT INTO breBRG_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","pa vountont, ec'h anavezit ac'hanoc'h hoc'h-unan o welout anezho, eo tost an hañv; ");
INSERT INTO breBRG_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","evel-se ivez, pa welot kement-se o c'hoarvezout, gouezit eo tost Rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Me a lavar deoc'h e gwirionez, penaos ar rummad-mañ ne dremeno ket, ken na vo c'hoarvezet an holl draoù-se. ");
INSERT INTO breBRG_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","An neñv hag an douar a dremeno, met va gerioù ne dremenint ket. ");
INSERT INTO breBRG_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Lakait eta evezh ouzhoc'h, gant aon na zeufe ho kalonoù da vezañ pounneraet gant an dirollerezh, ar vezventi, ha gant prederioù ar vuhez-mañ, ha na zeufe an deiz-se warnoc'h a-daol-trumm. ");
INSERT INTO breBRG_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Rak dont a raio evel ur roued, da soupren an holl re a chom war gorre an douar. ");
INSERT INTO breBRG_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Beilhit eta ha pedit e pep amzer, evit ma viot kavet din da dec'hout diouzh an holl draoù a dle c'hoarvezout, ha da chom dirak Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jezuz a gelenne en templ e-pad an deiz, hag en noz ez ae hag en em zalc'he war ar menez galvet Menez an Olived. ");
INSERT INTO breBRG_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ha, da c'houlou-deiz, an holl bobl a zeue d'e gavout evit e selaou. ");
INSERT INTO breBRG_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gouel ar bara hep goell, anvet ar Pask, a dostae. ");
INSERT INTO breBRG_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ar veleien vras hag ar skribed a glaske penaos e c'helljent lakaat Jezuz d'ar marv; rak doujañ a raent ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Met Satan a yeas e Judaz, lesanvet Iskariod, unan eus an daouzek; ");
INSERT INTO breBRG_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","hag ez eas, hag e komzas gant ar veleien vras ha gant pennoù ar warded, diwar an doare ma en lakaje etre o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Laouen e voent a gement-se, hag e tivizjont reiñ arc'hant dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Eñ a roas e c'her, hag e klaske an tu dereat evit e reiñ dezho hep ma ouije ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Koulskoude, deiz ar bara hep goell a zeuas, ma oa ret aberzhañ ar Pask, ");
INSERT INTO breBRG_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ha Jezuz a gasas Pêr ha Yann, o lavarout: It da fichañ deomp ar Pask, evit ma tebrimp anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Int a lavaras dezhañ: Pelec'h e c'hoantaez e fichfemp anezhañ? ");
INSERT INTO breBRG_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eñ a lavaras dezho: Pa'z eot e kêr, ec'h erruo ganeoc'h un den o tougen ur podad dour; heuilhit-eñ en ti ma'z aio ennañ, ");
INSERT INTO breBRG_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ha lavarit da vestr an ti: Ar Mestr a lavar dit: Pelec'h emañ al lec'h ma tebrin ennañ ar Pask gant va diskibien? ");
INSERT INTO breBRG_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hag e tiskouezo deoc'h ur gambr uhel, bras ha kempennet; fichit eno ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Int eta o vezañ aet kuit, a gavas an traoù evel m'en devoa lavaret dezho, hag e fichjont ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pa voe deuet an eur, en em lakaas ouzh taol, hag an daouzek abostol a oa gantañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hag e lavaras dezho: C'hoantaet kalz em eus debriñ ar Pask-mañ ganeoc'h, a-raok ma c'houzañvin. ");
INSERT INTO breBRG_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Rak me a lavar deoc'h, ne zebrin ken anezhañ, betek e vo graet e rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hag o vezañ kemeret an hanaf ha trugarekaet, e lavaras: Kemerit anezhañ ha lodennit anezhañ etrezoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Rak me a lavar deoc'h, n'evin mui eus frouezh ar gwini, ken na vo deuet rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Neuze e kemeras bara hag, o vezañ trugarekaet, e torras anezhañ, hag en roas dezho, o lavarout: Hemañ eo va c'horf, an hini a zo roet evidoc'h; grit kement-mañ en eñvor ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","En hevelep doare, goude bezañ koaniet, e roas dezho an hanaf, o lavarout: An hanaf-mañ eo an emglev nevez em gwad, an hini a zo skuilhet evidoc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Met setu, dorn an hini am gwerzh a zo ouzh an daol-mañ ganin. ");
INSERT INTO breBRG_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Evit ar pezh a zo eus Mab an den, mont a ra, evel ma'z eo merket; met gwalleur d'an den ma'z eo gwerzhet drezañ! ");
INSERT INTO breBRG_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hag en em lakajont da c'houlenn an eil ouzh egile pehini anezho a raje kement-se. ");
INSERT INTO breBRG_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sevel a reas ivez un tabut etrezo, evit gouzout pehini anezho a dlee bezañ galvet ar brasañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Met eñ a lavaras dezho: Rouaned ar bobloù a vestroni anezho, hag ar re o deus galloud warno a zo galvet madoberourien. ");
INSERT INTO breBRG_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Met c'hwi, na rit ket evel-se; ra vo ar brasañ en ho touez evel ar bihanañ, hag an hini a ren evel an hini a servij. ");
INSERT INTO breBRG_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Rak pehini eo ar brasañ, an hini a zo ouzh taol, pe an hini a servij? N'eo ket an hini a zo ouzh taol? Ha koulskoude me a zo en ho touez evel an hini a servij. ");
INSERT INTO breBRG_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","C'hwi eo ar re a zo chomet ganin em amprouadurioù, ");
INSERT INTO breBRG_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ha me a reizh deoc'h ar rouantelezh, evel ma en deus an Tad reizhet din, ");
INSERT INTO breBRG_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","evit ma tebrot ha ma'c'h evot ouzh va zaol em rouantelezh, ha ma viot azezet war dronioù, o varn daouzek meuriad Israel. ");
INSERT INTO breBRG_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","An Aotrou a lavaras ivez: Simon, Simon, setu, Satan en deus goulennet ho tremen dre ar c'hrouer evel ar gwinizh. ");
INSERT INTO breBRG_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Met pedet em eus evidout evit na zesfailho ket da feiz. Te eta, pa vi distroet, kreñva da vreudeur. ");
INSERT INTO breBRG_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pêr a lavaras dezhañ: Aotrou, me a zo prest da vont ganit, ha d'ar prizon ha d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Met Jezuz a lavaras dezhañ: Pêr, me en lavar dit, ar c'hilhog ne gano ket hiziv, na'z po nac'het teir gwech d'anavezout ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Neuze e lavaras dezho: Pa em eus ho kaset hep yalc'h, hep sac'h, hag hep botoù, daoust hag un dra bennak a zo bet manket deoc'h? Int a respontas: Netra. ");
INSERT INTO breBRG_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Met bremañ, emezañ, an hini en deus ur yalc'h, ra he c'hemero, hag en hevelep doare an hini en deus ur sac'h; hag an hini n'en deus ket ur c'hleze, ra werzho e vantell ha preno unan. ");
INSERT INTO breBRG_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Rak me a lavar deoc'h, eo ret c'hoazh d'ar pezh a zo skrivet bezañ peurc'hraet ennon: Lakaet eo bet e renk an dorfedourien. ");
INSERT INTO breBRG_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hag e lavarjont: Aotrou, setu daou gleze. Eñ a lavaras dezho: A-walc'h eo. ");
INSERT INTO breBRG_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Neuze Jezuz, o vezañ aet er-maez, a yeas, hervez e c'hiz, da Venez an Olived, hag e ziskibien a heulias anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pa voe erruet el lec'h-se, e lavaras dezho: Pedit evit na gouezhot ket en temptadur. ");
INSERT INTO breBRG_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Neuze e pellaas diouto war-dro hed un taol-maen, hag, o taoulinañ, e pede, ");
INSERT INTO breBRG_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","o lavarout: Tad, mar fell dit pellaat an hanaf-se diouzhin! Koulskoude, ra ne vo ket graet va bolontez, met da hini. ");
INSERT INTO breBRG_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Un ael eus an neñv en em ziskouezas dezhañ evit e greñvaat. ");
INSERT INTO breBRG_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gwasket gant an anken, e pede kalz startoc'h; hag e teuas dezhañ ur c'hwezenn evel beradennoù gwad, hag a gouezhe war an douar. ");
INSERT INTO breBRG_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","O vezañ savet eus e bedenn, e teuas etrezek e ziskibien, met o c'havas kousket gant an dristidigezh, ");
INSERT INTO breBRG_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","hag e lavaras dezho: Perak e kouskit? Savit ha pedit evit na gouezhot ket en temptadur. ");
INSERT INTO breBRG_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Evel ma komze c'hoazh, ur vandenn a zeuas, hag an hini a c'halved Judaz, unan eus an daouzek, a gerzhe a-raok dezho; hag e tostaas ouzh Jezuz evit pokat dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jezuz a lavaras dezhañ: Judaz, gwerzhañ a rez Mab an den dre ur pok? ");
INSERT INTO breBRG_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ar re a oa en-dro da Jezuz, o welout ar pezh a yae da c'hoarvezout, a lavaras dezhañ: Aotrou, ha skeiñ a raimp gant ar c'hleze? ");
INSERT INTO breBRG_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hag unan anezho a skoas servijer ar beleg-meur, hag a droc'has dezhañ e skouarn dehou. ");
INSERT INTO breBRG_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Met Jezuz, o kemer ar gomz, a lavaras: Paouezit! Hag o vezañ stoket ouzh skouarn ar servijer, e yac'haas anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Neuze Jezuz a lavaras d'ar veleien vras, da gabitened an templ, ha d'an henaourien, a oa deuet a-enep dezhañ: Deuet oc'h gant klezeier ha gant bizhier, evel war-lerc'h ul laer. ");
INSERT INTO breBRG_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bemdez e oan en ho touez en templ, ha n'hoc'h eus ket lakaet ho taouarn warnon. Met houmañ eo hoc'h eur, ha galloud an deñvalijenn. ");
INSERT INTO breBRG_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Neuze e krogjont ennañ, hag e kasjont anezhañ da di ar beleg-meur. Pêr a heulie a-bell. ");
INSERT INTO breBRG_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pa o devoe enaouet tan e-kreiz ar porzh, ha ma voent azezet a-unan, Pêr a azezas en o zouez. ");
INSERT INTO breBRG_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ur vatezh, o welout anezhañ e-kichen an tan, hag o sellout pizh outañ, a lavaras: Hemañ a oa ivez gant an den-se. ");
INSERT INTO breBRG_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Met eñ a zinac'has Jezuz, o lavarout: Gwreg, n'anavezan ket anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Un nebeut goude, unan all, o vezañ e welet, a lavaras: Te a zo ivez eus an dud-se. Met Pêr a lavaras: O den, ned on ket. ");
INSERT INTO breBRG_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","War-dro un eur goude, unan all a destenias o lavarout: A dra sur, hemañ a oa ivez gantañ, rak Galileat eo ivez. ");
INSERT INTO breBRG_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Met Pêr a lavaras: O den, n'ouzon ket petra a lavarez. Ha kerkent, evel ma komze c'hoazh, ar c'hilhog a ganas. ");
INSERT INTO breBRG_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","An Aotrou, o vezañ distroet, a sellas ouzh Pêr; ha Pêr en devoe soñj eus komz an Aotrou, ha penaos en devoa lavaret dezhañ: A-raok ma kano ar c'hilhog, ez po va dinac'het teir gwech. ");
INSERT INTO breBRG_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hag o vezañ aet er-maez, e ouelas gant c'hwervder. ");
INSERT INTO breBRG_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Neuze an dud a zalc'he Jezuz, a rae goap anezhañ, hag a skoe warnañ. ");
INSERT INTO breBRG_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","O vezañ e vouchet, e skoent war e zremm, hag e c'houlennent outañ: Divin piv eo an hini en deus da skoet. ");
INSERT INTO breBRG_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hag e lavarent kalz a draoù a-enep dezhañ, en ur zroukkomz en e enep. ");
INSERT INTO breBRG_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Adalek ma voe deuet an deiz, kuzul henaourien ar bobl, ar veleien vras hag ar skribed en em zastumas hag a reas Jezuz dont dirak ar sanedrin; ");
INSERT INTO breBRG_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","lavarout a rejont dezhañ: Mar dout ar C'hrist, lavar deomp. Eñ a respontas dezho: Mar en lavaran deoc'h, n'en kredot ket, ");
INSERT INTO breBRG_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ha mar goulennan ouzhoc'h ivez, ne respontot ket din, ha ne'm lezot ket da vont. ");
INSERT INTO breBRG_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Diwar vremañ, Mab an den a vo azezet a-zehou da c'halloud Doue. ");
INSERT INTO breBRG_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Neuze e lavarjont holl: Te eo eta Mab Doue? Eñ a respontas dezho: C'hwi a lavar hoc'h-unan, bez' ez on. ");
INSERT INTO breBRG_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Neuze e lavarjont: Da betra hon eus c'hoazh ezhomm a desteni, pa'z eo gwir hon eus e glevet eus e c'henou? ");
INSERT INTO breBRG_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Neuze an holl dud-se, o vezañ savet, a zegasas anezhañ da Bilat. ");
INSERT INTO breBRG_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hag en em lakajont d'e damall, o lavarout: Ni hon eus kavet an den-mañ o tromplañ ar bobl hag o tifenn paeañ ar gwir da Gezar, o lavarout eo ar C'hrist, ar roue. ");
INSERT INTO breBRG_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat a reas outañ ar goulenn-mañ: Bez' out-te roue ar Yuzevien? Jezuz a respontas dezhañ: Te en lavar. ");
INSERT INTO breBRG_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat a lavaras d'ar veleien vras ha d'ar bobl: Ne gavan netra da damall en den-mañ. ");
INSERT INTO breBRG_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Met int a zalc'he, o lavarout: Sevel a ra ar bobl, o kelenn dre holl Judea, o vezañ en graet adalek Galilea, betek amañ. ");
INSERT INTO breBRG_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pa glevas Pilat komz eus Galilea, e c'houlennas hag e oa Galileat an den-se. ");
INSERT INTO breBRG_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hag o vezañ gouezet e oa eus dalc'h Herodez, e kasas anezhañ da Herodez, hag a oa e Jeruzalem en deizioù-se. ");
INSERT INTO breBRG_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodez, pa welas Jezuz, a voe laouen, rak pell e oa en devoa c'hoant d'e welout, abalamour m'en devoa klevet lavarout kalz a draoù diwar e benn, hag e c'hortoze e welout oc'h ober ur mirakl bennak. ");
INSERT INTO breBRG_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ober a reas eta meur a c'houlenn outañ; met Jezuz ne respontas netra dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ar veleien vras hag ar skribed a oa eno, hag a damalle anezhañ gwashañ ma c'hellent. ");
INSERT INTO breBRG_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Met Herodez, gant tud e ward, a zisprizas anezhañ; hag evit ober goap anezhañ, e lakaas gwiskañ dezhañ ur sae splann, hag e tistroas anezhañ da Bilat. ");
INSERT INTO breBRG_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","En deiz-se, Herodez ha Pilat a zeuas da vezañ mignoned; rak a-raok e oant enebourien. ");
INSERT INTO breBRG_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Neuze Pilat, o vezañ dastumet ar veleien vras, mistri ar vro, hag ar bobl, a lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Degaset hoc'h eus din an den-se evel m'en dije savet ar bobl, ha goude bezañ graet goulennoù outañ dirazoc'h, ne'm eus ket e gavet kiriek da hini ebet eus an torfedoù a damallit dezhañ, ");
INSERT INTO breBRG_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","nag Herodez kennebeut, rak ho kaset em eus d'e gavout; ha setu n'en deus graet netra a vefe din a varv. ");
INSERT INTO breBRG_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","O vezañ eta graet e gastizañ, e laoskin anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ret e oa dezhañ leuskel unan dezho e deiz ar gouel. ");
INSERT INTO breBRG_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Neuze e krijont holl a-unan: Laka hemañ d'ar marv, ha laosk deomp Barabbaz. ");
INSERT INTO breBRG_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Hemañ a oa bet lakaet er prizon evit un dispac'h c'hoarvezet e kêr, hag ur muntr. ");
INSERT INTO breBRG_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat, o kaout c'hoant da leuskel Jezuz, a gomzas outo a-nevez. ");
INSERT INTO breBRG_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Met int a grias: Ouzh ar groaz! Ouzh ar groaz! ");
INSERT INTO breBRG_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eñ a lavaras dezho evit an trede gwech: Met peseurt droug en deus graet? Ne'm eus kavet ennañ netra hag a vefe din a varv. E gastizañ a rin hag e laoskin anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Met int a gendalc'he, o c'houlenn gant kriadegoù bras ma vije staget ouzh ar groaz; hag o c'hriadennoù ha re ar veleien vras a greske. ");
INSERT INTO breBRG_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Neuze Pilat a varnas ober evel ma felle dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Leuskel a reas dezho an hini a oa bet lakaet er prizon evit un dispac'h hag evit ur muntr, hag a oa an hini a c'houlennent; hag e lezas Jezuz d'o bolontez. ");
INSERT INTO breBRG_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hag evel ma kasent anezhañ, e kemerjont un den anvet Simon a Siren, a zistroe eus ar parkeier, hag e lakajont anezhañ da zougen ar groaz, war lerc'h Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ur vandenn vras a bobl hag a wragez en heulie, hag en em c'hlac'hare hag a hirvoude diwar e benn. ");
INSERT INTO breBRG_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jezuz, o tistreiñ etrezek enno, a lavaras dezho: Merc'hed Jeruzalem, na ouelit ket diwar va fenn, met gouelit warnoc'h hoc'h-unan ha war ho pugale, ");
INSERT INTO breBRG_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","rak deizioù a zeuio ma vo lavaret: Eürus ar merc'hed difrouezh, ar c'hofoù n'o deus ket ganet, hag an divronn n'o deus ket maget! ");
INSERT INTO breBRG_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Neuze en em lakaint da lavarout d'ar menezioù: Kouezhit warnomp! ha d'ar grec'hiennoù: Goloit ac'hanomp! ");
INSERT INTO breBRG_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Rak ma reer an traoù-mañ d'ar c'hoad glas, petra a vo graet d'ar c'hoad sec'h? ");
INSERT INTO breBRG_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hag e kased ivez daou dorfedour, evit o lakaat da vervel gantañ. ");
INSERT INTO breBRG_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pa voent deuet el lec'h anvet Klopenn, e stagjont anezhañ ouzh ar groaz eno, hag an dorfedourien ivez, unan a-zehou hag egile a-gleiz. ");
INSERT INTO breBRG_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jezuz a lavare: Tad, pardon dezho, rak n'ouzont ket ar pezh a reont. Neuze e lodennjont e zilhad, ouzh o zeurel d'ar sord. ");
INSERT INTO breBRG_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ar bobl en em zalc'he eno, hag a selle. Mistri ar vro hag ar bobl a rae goap anezhañ, o lavarout: Saveteet en deus ar re all, ra en em saveteo e-unan, mar deo ar C'hrist, an hini dibabet gant Doue! ");
INSERT INTO breBRG_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ar soudarded ivez, o tostaat evit kinnig gwinegr dezhañ, a rae goap outañ, ");
INSERT INTO breBRG_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","o lavarout: Mar dout roue ar Yuzevien, en em savete da-unan. ");
INSERT INTO breBRG_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ha bez' e oa a-us d'e benn ar skrid-mañ, e gresianeg, e latin hag en hebraeg: HEMAÑ EO ROUE AR YUZEVIEN. ");
INSERT INTO breBRG_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Unan eus an dorfedourien a oa kroazstaget a zismegañse ivez anezhañ, o lavarout: Mar dout ar C'hrist, en em savete da-unan, ha ni ivez. ");
INSERT INTO breBRG_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Met egile, o krozal dezhañ, a lavaras: Ne zoujez ket eta Doue, rak barnet out d'an hevelep poan? ");
INSERT INTO breBRG_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Evidomp-ni, ez eo gant reizhder, rak e resevomp hervez hon torfedoù, met hemañ n'en deus graet droug ebet. ");
INSERT INTO breBRG_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hag e lavare da Jezuz: Aotrou, az pez soñj ac'hanon, pa zeui ez rouantelezh. ");
INSERT INTO breBRG_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jezuz a lavaras dezhañ: Me en lavar dit e gwirionez, hiziv e vi ganin er baradoz. ");
INSERT INTO breBRG_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bez' e oa war-dro ar c'hwec'hvet eur, hag e voe teñvalijenn war an douar holl, betek an navet eur. ");
INSERT INTO breBRG_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","An heol a deñvalaas, ha gouel an templ a rogas dre e greiz. ");
INSERT INTO breBRG_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ha Jezuz en ur grial a vouezh uhel, a lavaras: Va Zad, lakaat a ran va spered etre da zaouarn! O vezañ lavaret kement-se, e varvas. ");
INSERT INTO breBRG_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ar c'hantener, o welout ar pezh a oa c'hoarvezet, a roas gloar da Zoue, o lavarout: A dra sur, an den-mañ a oa reizh. ");
INSERT INTO breBRG_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","An holl bobl hag a oa en em zastumet eno, o welout kement-se, a yeas kuit en ur skeiñ war boull o c'halon. ");
INSERT INTO breBRG_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","An holl re a anaveze anezhañ, hag ar gwragez o devoa e heuliet adalek Galilea, en em zalc'he a-bell, hag a selle ouzh an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Un den anvet Jozef, ur c'huzulier-meur, un den mat ha reizh, ");
INSERT INTO breBRG_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","un den n'en devoa ket roet e ali d'o diviz na d'o oberoù, o tont eus Arimatea, kêr eus ar Yuzevien, a c'hortoze ivez rouantelezh Doue; ");
INSERT INTO breBRG_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","o vezañ deuet da gavout Pilat, e c'houlennas outañ korf Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","O vezañ e ziskennet eus ar groaz, en goloas gant ul lienenn, hag e lakaas anezhañ en ur bez toullet er roc'h, e-lec'h ne oa bet c'hoazh lakaet den. ");
INSERT INTO breBRG_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bez' e oa deiz ar c'hempennadur, hag ar sabad a zeue. ");
INSERT INTO breBRG_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ar gwragez deuet eus Galilea gant Jezuz, o vezañ heuliet Jozef, a welas ar bez ha penaos e oa lakaet korf Jezuz e-barzh. ");
INSERT INTO breBRG_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hag o vezañ distroet, ec'h aozjont louzoù a c'hwez-vat ha frondoù, hag e tiskuizhjont deiz ar sabad, hervez al lezenn. ");
INSERT INTO breBRG_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Deiz kentañ ar sizhun, e teujont mintin mat d'ar bez, o tegas ganto al louzoù a c'hwez-vat o devoa fichet; hag ur re bennak o heulie. ");
INSERT INTO breBRG_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hag e kavjont e oa bet ruilhet ar maen a-zirak ar bez. ");
INSERT INTO breBRG_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","O vezañ aet ennañ, ne gavjont ket korf an Aotrou Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Evel na ouient petra da soñjal war gement-se, setu, daou zen en em ziskouezas dezho, gwisket gant dilhad lugernus. ");
INSERT INTO breBRG_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Evel ma oant spontet, ha ma plegent o fenn war-zu an douar, e lavarjont dezho: Perak e klaskit e-touez ar re varv an hini a zo bev? ");
INSERT INTO breBRG_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","N'emañ ket amañ, adsavet eo a varv. Ho pet soñj penaos en devoa komzet ouzhoc'h, pa oa c'hoazh e Galilea, ");
INSERT INTO breBRG_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","o lavarout: Ret eo da Vab an den bezañ lakaet etre daouarn ar bec'herien, ha bezañ kroazstaget, hag adsevel a varv an trede deiz. ");
INSERT INTO breBRG_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hag e teuas soñj dezho eus e gomzoù. ");
INSERT INTO breBRG_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","O vezañ distroet eus ar bez, e tisklêrjont an holl draoù-se d'an unnek, ha d'an holl re all. ");
INSERT INTO breBRG_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mari a Vagdala, Janed, Mari mamm Jakez hag ar re all a oa ganto, a oa ar re a lavaras an traoù-mañ d'an ebestel. ");
INSERT INTO breBRG_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Met e kemerent ar pezh a lavarent dezho evel ur sorc'henn. ");
INSERT INTO breBRG_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Koulskoude, Pêr a savas hag a redas d'ar bez; o vezañ pleget, ne welas nemet al lienennoù war an douar; mont a reas kuit, souezhet ennañ e-unan eus ar pezh a oa c'hoarvezet. ");
INSERT INTO breBRG_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","An deiz-se memes, daou anezho a yae d'ur vourc'h anvet Emmaüz, war hed tri-ugent stadenn diouzh Jeruzalem; ");
INSERT INTO breBRG_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","int a gomze etrezo diwar-benn ar pezh a oa c'hoarvezet. ");
INSERT INTO breBRG_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Evel ma komzent, ha ma poellataent, Jezuz e-unan, o vezañ tostaet, en em lakaas da vale ganto. ");
INSERT INTO breBRG_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Met o daoulagad a oa dalc'het, en hevelep doare ma n'anavezjont ket anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eñ a lavaras dezho: Petra eo ar c'homzoù-se a lavarit etrezoc'h, en ur vont en hent, ha perak oc'h ken trist? ");
INSERT INTO breBRG_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unan anezho, anvet Kleopaz, a respontas dezhañ: Te eo an diavaeziad hepken, e Jeruzalem, ha ne oar ket an traoù c'hoarvezet enni en deizioù-mañ? ");
INSERT INTO breBRG_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eñ a lavaras dezho: Ha petra? Int a respontas dezhañ: Ar pezh a zo erruet gant Jezuz a Nazared, ur profed bras, galloudek en oberoù hag e komzoù dirak Doue ha dirak an holl bobl, ");
INSERT INTO breBRG_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ha penaos ar veleien vras ha mistri hor bro o deus e varnet d'ar marv, hag e staget ouzh ar groaz. ");
INSERT INTO breBRG_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ni a espere e oa hennezh an hini a saveteje Israel, ha koulskoude, setu an trede deiz ma'z eo c'hoarvezet an traoù-se. ");
INSERT INTO breBRG_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gwir eo penaos gwragez bennak, eus hon touez, o deus hor gwall souezhet; rak o vezañ bet aet d'ar bez a-raok an deiz, ");
INSERT INTO breBRG_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","n'o deus ket kavet e gorf, hag ez int deuet o lavarout penaos aeled a zo en em ziskouezet dezho, ha lavaret e oa bev. ");
INSERT INTO breBRG_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hiniennoù ac'hanomp a zo aet d'ar bez, hag o deus kavet an traoù evel m'o deus ar gwragez lavaret dezho, met eñ, n'o deus ket e welet. ");
INSERT INTO breBRG_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Neuze e lavaras dezho: O tud hep skiant ha tud a galon gorrek da grediñ kement en deus lavaret ar brofeded! ");
INSERT INTO breBRG_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ha ne oa ket ret d'ar C'hrist gouzañv an traoù-se, ha mont en e c'hloar? ");
INSERT INTO breBRG_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Neuze e tisplegas dezho an holl Skriturioù a gomze outañ adalek Moizez betek an holl brofeded. ");
INSERT INTO breBRG_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Evel-se e tostaent ouzh ar vourc'h e-lec'h ma'z aent, met Jezuz a rae van da vont pelloc'h. ");
INSERT INTO breBRG_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Int a reas dezhañ chom ganto, o lavarout dezhañ: Chom ganeomp, rak an noz a zeu hag an deiz a zo war e ziskenn. Antreal a reas evit chom ganto. ");
INSERT INTO breBRG_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Evel ma oa ouzh taol ganto, e kemeras bara hag e trugarekaas; hag o vezañ e dorret, e roas anezhañ dezho. ");
INSERT INTO breBRG_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Neuze o daoulagad a zigoras hag ec'h anavezjont anezhañ; met eñ a dec'has a-zirak o daoulagad. ");
INSERT INTO breBRG_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Neuze e lavarjont an eil d'egile: Hor c'halon ha ne domme ket ennomp, pa gomze ouzhimp en hent, ha pa zisklêrie deomp ar Skriturioù? ");
INSERT INTO breBRG_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","O sevel en eur-se memes, e tistrojont da Jeruzalem, hag e kavjont an unnek hag ar re a oa ganto dastumet asambles, ");
INSERT INTO breBRG_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","o lavarout: An Aotrou e gwirionez a zo adsavet a varv, hag eo en em ziskouezet da Simon. ");
INSERT INTO breBRG_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","D'o zro, e lavarjont ivez ar pezh a oa erruet ganto en hent, ha penaos o devoa e anavezet p'en devoa torret ar bara. ");
INSERT INTO breBRG_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Evel ma komzent evel-se, Jezuz e-unan en em ziskouezas en o c'hreiz, hag a lavaras dezho: Ar peoc'h ra vo ganeoc'h! ");
INSERT INTO breBRG_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Met int, spontet ha spouronet, a grede gwelout ur spered. ");
INSERT INTO breBRG_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eñ a lavaras dezho: Perak oc'h trubuilhet, ha perak e sav kement a soñjoù en ho kalonoù? ");
INSERT INTO breBRG_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sellit ouzh va daouarn hag ouzh va zreid, rak me va-unan eo. Stokit ennon, ha sellit ouzhin; rak ur spered n'en deus na kig na eskern evel ma welit em eus. ");
INSERT INTO breBRG_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","O lavarout kement-se, e tiskouezas dezho e zaouarn hag e dreid. ");
INSERT INTO breBRG_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Met evel, en o levenez, ne gredent ket c'hoazh, ha ma oant souezhet, e lavaras dezho: Bez' hoc'h eus un dra bennak da zebriñ? ");
INSERT INTO breBRG_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hag e rojont dezhañ un tamm pesk rostet hag un derenn vel. ");
INSERT INTO breBRG_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O vezañ o kemeret, e tebras dirazo. ");
INSERT INTO breBRG_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Neuze e lavaras dezho: Setu ar pezh a lavaren deoc'h pa oan c'hoazh ganeoc'h, e oa ret ma vije peurc'hraet kement a zo bet skrivet diwar va fenn e lezenn Moizez, er Brofeded hag er Salmoù. ");
INSERT INTO breBRG_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Neuze e tigoras dezho o spered, evit ma komprenjent ar Skriturioù. ");
INSERT INTO breBRG_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hag e lavaras dezho: Evel-se eo skrivet, hag evel-se e oa ret, e c'houzañvje ar C'hrist, hag e savje a varv d'an trede deiz, ");
INSERT INTO breBRG_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ha ma vije prezeget en e anv ar geuzidigezh ha pardon ar pec'hedoù, e-touez an holl bobloù, o vont da gentañ dre Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","C'hwi eo an testoù eus an traoù-se, ");
INSERT INTO breBRG_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ha setu, ez an da gas deoc'h ar pezh en deus va Zad prometet. Evidoc'h-hu, chomit e kêr Jeruzalem, ken na viot gwisket gant ar galloud eus an nec'h. ");
INSERT INTO breBRG_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Neuze e tegasas anezho er-maez betek Betania, hag, o vezañ savet e zaouarn, e vennigas anezho. ");
INSERT INTO breBRG_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hag e c'hoarvezas evel ma vennige anezho, e pellaas diouto, hag e voe savet en neñv. ");
INSERT INTO breBRG_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Int, o vezañ e azeulet, a zistroas da Jeruzalem gant levenez vras. ");
INSERT INTO breBRG_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hag e oant dalc'hmat en templ, o veuliñ hag o vennigañ Doue. Amen. ");
INSERT INTO breBRG_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Er penn-kentañ e oa ar Ger, hag ar Ger a oa gant Doue, hag ar Ger a oa Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Er penn-kentañ e oa gant Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","An holl draoù a zo bet graet drezañ, ha netra eus ar pezh a zo bet graet, n'eo bet graet heptañ. ");
INSERT INTO breBRG_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ennañ e oa ar vuhez, hag ar vuhez a oa sklêrijenn an dud. ");
INSERT INTO breBRG_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ar sklêrijenn he deus lugernet en deñvalijenn, hag an deñvalijenn n'he deus ket he degemeret. ");
INSERT INTO breBRG_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bez' e voe un den, anvet Yann, kaset a-berzh Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dont a reas da vezañ test, da reiñ testeni d'ar sklêrijenn, evit ma kredje an holl drezañ. ");
INSERT INTO breBRG_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ne oa ket ar sklêrijenn, met kaset e oa da reiñ testeni d'ar sklêrijenn. ");
INSERT INTO breBRG_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ar sklêrijenn wirion, an hini a sklaera pep den, a oa o tont er bed. ");
INSERT INTO breBRG_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Er bed e oa, hag ar bed a zo bet graet gantañ; met ar bed n'en deus ket e anavezet. ");
INSERT INTO breBRG_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Deuet eo da gavout e re, hag e re n'o eus ket e zegemeret. ");
INSERT INTO breBRG_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Met d'an holl re o deus e zegemeret, en deus roet an droed da vezañ graet bugale da Zoue, da c'houzout eo, d'an holl re a gred en e anv, ");
INSERT INTO breBRG_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ar re n'int ket bet ganet eus ar gwad, nag eus bolontez ar c'hig, nag eus bolontez an den, met eus Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hag ar Ger a zo bet graet kig, hag en deus chomet en hon touez, leun a c'hras hag a wirionez, ha gwelet hon eus e c'hloar, ur gloar evel hini Mab nemetañ an Tad. ");
INSERT INTO breBRG_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yann a roas testeni dezhañ, pa grias o lavarout: Hemañ eo an hini a lavaren diwar e benn: An hini a zeu war va lerc'h a zo dreiston, abalamour ma oa kentoc'h egedon. ");
INSERT INTO breBRG_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ni holl hon eus resevet eus e leunder, ha gras evit gras. ");
INSERT INTO breBRG_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Rak al lezenn a zo bet roet dre Voizez, an drugarez hag ar wirionez a zo deuet dre Jezuz-Krist. ");
INSERT INTO breBRG_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Den n'en deus biskoazh gwelet Doue; ar Mab nemetañ a zo en askre an Tad, eo an hini en deus graet e anavezout. ");
INSERT INTO breBRG_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Setu amañ testeni Yann, pa gasas ar Yuzevien eus Jeruzalem beleien ha levited da c'houlenn outañ: Piv out-te? ");
INSERT INTO breBRG_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Disklêriañ a reas ha ne nac'has ket, disklêriañ a reas: N'on ket-me ar C'hrist. ");
INSERT INTO breBRG_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hag e c'houlennjont outañ: Piv out eta? Bez' out Elia? Eñ a lavaras: N'on ket. Bez' out ar profed? Eñ a respontas: Nann. ");
INSERT INTO breBRG_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Int a lavaras eta dezhañ: Piv out-te? Evit ma roimp respont d'ar re o deus hon degaset. Petra a lavarez ac'hanout da-unan? ");
INSERT INTO breBRG_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eñ a lavaras: Me eo mouezh an hini a gri el lec'h distro: Plaenit hent an Aotrou, evel m'en deus lavaret ar profed Izaia. ");
INSERT INTO breBRG_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ar re a oa bet kaset a oa farizianed. ");
INSERT INTO breBRG_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Goulenn a rejont outañ: Perak e vadezez, ma n'out nag ar C'hrist, nag Elia, nag ar profed? ");
INSERT INTO breBRG_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yann a respontas hag a lavaras dezho: Evidon-me, me a vadez en dour; met unan bennak a zo en ho touez, ha n'anavezit ket anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hennezh eo an hini a zeu war va lerc'h, hag a zo dreiston; ha n'on ket dellezek da zieren korreenn e votoù. ");
INSERT INTO breBRG_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kement-mañ a c'hoarvezas e Betania, en tu all d'ar Jordan, e-lec'h ma vadeze Yann. ");
INSERT INTO breBRG_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","An deiz war-lerc'h, Yann a welas Jezuz o tont d'e gavout, hag a lavaras: Setu Oan Doue, an hini a lam pec'hed ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eñ eo an hini e lavaren diwar e benn: Dont a ra war va lerc'h un den hag a zo dreiston, rak a-raok din e oa. ");
INSERT INTO breBRG_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Evidon-me, n'anavezen ket anezhañ; met deuet on da vadeziñ en dour, evit ma vo disklêriet da Israel. ");
INSERT INTO breBRG_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yann a roas c'hoazh an testeni-mañ, o lavarout: Gwelet em eus ar Spered o tiskenn eus an neñv evel ur goulm, hag o tont warnañ. ");
INSERT INTO breBRG_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Evidon-me, n'anavezen ket anezhañ; met an hini en deus va c'haset da vadeziñ en dour, en deus lavaret din: An hini a weli ar Spered o tiskenn hag o chom warnañ, hennezh eo an hini a vadez er Spered-Santel. ");
INSERT INTO breBRG_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hag em eus gwelet, hag em eus roet testeni eo eñ Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","An deiz war-lerc'h, Yann a oa c'hoazh eno gant daou eus e ziskibien, ");
INSERT INTO breBRG_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","hag o welout Jezuz a valee, e lavaras: Setu Oan Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","An daou ziskibl, o vezañ e glevet o komz evel-se, a heulias Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jezuz o vezañ distroet hag o welout e heulient anezhañ, a lavaras dezho: Petra a glaskit? Respont a rejont dezhañ: Rabbi (da lavarout eo Mestr), pelec'h e chomez? ");
INSERT INTO breBRG_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eñ a lavaras dezho: Deuit ha gwelit. Mont a rejont, hag e weljont pelec'h e chome, hag e chomjont gantañ an deiz-se, rak war-dro an dekvet eur e oa. ");
INSERT INTO breBRG_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrev, breur Simon-Pêr, a oa unan eus an daou o devoa klevet ar pezh en devoa lavaret Yann, hag o devoa heuliet Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrev a gavas da gentañ Simon e vreur, hag a lavaras dezhañ: Ni hon eus kavet ar Mesiaz (da lavarout eo ar C'hrist, an Eouliet). ");
INSERT INTO breBRG_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hag e tegasas anezhañ da Jezuz. Jezuz, o vezañ sellet outañ, a lavaras dezhañ: Te eo Simon, mab Jona; te a vo galvet Kefaz (da lavarout eo Pêr). ");
INSERT INTO breBRG_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","An deiz war-lerc'h, Jezuz a c'hoantaas mont e Galilea, hag e kavas Filip; lavarout a reas dezhañ: Heul ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip a oa eus Betsaida, kêr Andrev ha Pêr. ");
INSERT INTO breBRG_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip a gavas Natanael hag a lavaras dezhañ: Kavet hon eus an hini a zo bet skrivet diwar e benn gant Moizez el lezenn ha gant ar brofeded: Jezuz, mab Jozef, eus Nazared. ");
INSERT INTO breBRG_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael a lavaras dezhañ: Hag eus Nazared e c'hell dont un dra vat bennak? Filip a lavaras dezhañ: Deus ha gwel. ");
INSERT INTO breBRG_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jezuz, o welout Natanael o tont d'e gavout, a lavaras diwar e benn: Setu ur gwir Israelad, ha n'eus ket a droidell ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael a lavaras dezhañ: A-belec'h ec'h anavezez ac'hanon? Jezuz a respontas dezhañ: A-raok ma c'halvas Filip ac'hanout, pa oas dindan ar wezenn-fiez, e welen ac'hanout. ");
INSERT INTO breBRG_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael a respontas dezhañ: Mestr, te eo Mab Doue, te eo roue Israel. ");
INSERT INTO breBRG_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jezuz a respontas dezhañ: Abalamour ma em eus lavaret dit em boa da welet dindan ar wezenn-fiez, e kredez; te a welo traoù brasoc'h eget ar re-mañ. ");
INSERT INTO breBRG_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lavarout a reas ivez dezhañ: E gwirionez, e gwirionez, me a lavar deoc'h: A-vremañ c'hwi a welo an neñv digor, hag aeled Doue o pignat hag o tiskenn a-us da Vab an den. ");
INSERT INTO breBRG_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tri devezh goude, e voe un eured e Kana e Galilea, ha mamm Jezuz a oa eno. ");
INSERT INTO breBRG_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jezuz ivez a voe pedet da vont d'an eured gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ar gwin o vezañ manket, mamm Jezuz a lavaras dezhañ: N'o deus ken a win. ");
INSERT INTO breBRG_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jezuz a respontas dezhi: Gwreg, petra a zo etre te ha me? Va eur n'eo ket c'hoazh deuet. ");
INSERT INTO breBRG_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E vamm a lavaras d'ar re a servije: Grit kement a lavaro deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bez' e oa eno c'hwec'h lestr-maen, lakaet evit glanidigezh ar Yuzevien, o terc'hel pep hini anezho daou pe dri muzuliad. ");
INSERT INTO breBRG_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jezuz a lavaras dezho: Leugnit a zour al listri-se; hag e kargjont anezho leun-barr. ");
INSERT INTO breBRG_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lavarout a reas dezho: Tennit bremañ anezhañ, ha kasit da vestr ar fest. Hag e kasjont. ");
INSERT INTO breBRG_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","P'en devoe mestr ar fest tañvaet an dour troet e gwin (ne ouie ket a-belec'h e teue ar gwin-se, met ar vevelien o devoa tennet an dour a ouie), e c'halvas ar pried, ");
INSERT INTO breBRG_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","hag e lavaras dezhañ: Pep den a ro da gentañ ar gwin mat, hag an hini falloc'h goude ma vefe bet evet kalz; met te ac'h eus miret ar gwin mat betek vremañ. ");
INSERT INTO breBRG_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jezuz a reas ar c'hentañ mirakl-mañ e Kana Galilea, hag e tiskouezas e c'hloar; e ziskibien a gredas ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Goude-se, e tiskennas da Gafarnaoum gant e vamm, e vreudeur hag e ziskibien, ha ne chomjont eno nemet un nebeut devezhioù. ");
INSERT INTO breBRG_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pask ar Yuzevien a oa tost, ha Jezuz a bignas da Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","En templ e kavas ar re a werzhe ejened, deñved ha koulmed, gant an drokerien a oa azezet eno. ");
INSERT INTO breBRG_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O vezañ graet ur skourjez-kerdin, e kasas anezho holl kuit eus an templ, hag an deñved hag an ejened; teurel a reas d'an douar arc'hant an drokerien, hag e tiskaras o zaolioù, ");
INSERT INTO breBRG_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","hag e lavaras d'ar re a werzhe koulmed: Tennit an dra-se ac'han, ha na rit ket eus ti va Zad un ti a varc'had. ");
INSERT INTO breBRG_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Neuze e ziskibien o devoe soñj eo skrivet: An oaz evit da di en deus va devet. ");
INSERT INTO breBRG_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ar Yuzevien, o kemer ar gomz, a lavaras dezhañ: Dre beseurt sin e tiskouezez deomp e c'hellez ober kement-se? ");
INSERT INTO breBRG_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jezuz a respontas hag a lavaras dezho: Diskarit an templ-mañ, ha me a adsavo anezhañ a-benn tri devezh. ");
INSERT INTO breBRG_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ar Yuzevien a lavaras dezhañ: C'hwec'h vloaz ha daou-ugent e oar bet o sevel an templ-mañ, ha te en adsavfe e tri devezh? ");
INSERT INTO breBRG_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Met eñ a gomze eus templ e gorf. ");
INSERT INTO breBRG_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Goude eta ma oa adsavet a-douez ar re varv, e ziskibien o devoe soñj en devoa lavaret an dra-se, hag e kredjont er Skritur ha d'ar ger-se en devoa Jezuz lavaret. ");
INSERT INTO breBRG_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E-pad ma oa e Jeruzalem, da ouel ar pask, kalz a dud a gredas en e anv, o welout ar mirakloù a rae. ");
INSERT INTO breBRG_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Met Jezuz ne fizie ket enno, rak o anavezout a rae holl. ");
INSERT INTO breBRG_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ha n'en devoa ket ezhomm e vije roet testeni dezhañ gant den, rak anavezout a rae e-unan ar pezh a oa en den. ");
INSERT INTO breBRG_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bez' e oa un den, e-touez ar farizianed, anvet Nikodem, unan eus re vras ar Yuzevien. ");
INSERT INTO breBRG_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Hemañ a zeuas, e-pad an noz, da gavout Jezuz hag a lavaras dezhañ: Mestr, ni a oar out un doktor deuet a-berzh Doue, rak den ne c'hell ober ar mirakloù-se a rez, nemet Doue a vefe gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jezuz a respontas dezhañ: E gwirionez, e gwirionez, me a lavar dit, ma ne vez ket ganet un den a-nevez, ne c'hell ket gwelout rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem a lavaras dezhañ: Penaos e c'hell un den bezañ ganet pa'z eo kozh? Hag eñ a c'hell distreiñ e kof e vamm, ha bezañ ganet un eil gwech? ");
INSERT INTO breBRG_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jezuz a respontas: E gwirionez, e gwirionez, me a lavar dit, ma ne vez ket un den ganet a zour hag a Spered, ne c'hell ket mont e rouantelezh Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ar pezh a zo ganet eus ar c'hig, a zo kig, hag ar pezh a zo ganet eus ar Spered, a zo spered. ");
INSERT INTO breBRG_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na vez ket souezhet eus ar pezh am eus lavaret dit: Ret eo ma viot ganet a-nevez. ");
INSERT INTO breBRG_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","An avel a c'hwezh e-lec'h ma kar, hag e klevez an trouz; met n'ouzout ket nag a-belec'h e teu, na pelec'h ez a. Evel-se e c'hoarvez gant pep den a zo ganet eus ar Spered. ");
INSERT INTO breBRG_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem a lavaras dezhañ: Penaos e c'hell an traoù-se en em ober? ");
INSERT INTO breBRG_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jezuz a respontas dezhañ: Te a zo doktor Israel, ha n'ouzout ket an traoù-se? ");
INSERT INTO breBRG_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","E gwirionez, e gwirionez, me a lavar dit: ni a lavar ar pezh a ouzomp, hag e roomp testeni eus ar pezh hon eus gwelet, met ne zegemerit ket hon testeni. ");
INSERT INTO breBRG_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ma ne gredit ket pa em eus komzet deoc'h eus traoù douarel, penaos e kredot pa gomzin deoc'h eus traoù neñvel? ");
INSERT INTO breBRG_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Den n'eo pignet en neñv, nemet an hini a zo diskennet eus an neñv, Mab an den a zo en neñv. ");
INSERT INTO breBRG_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hag evel ma savas Moizez an naer el lec'h distro, evel-se eo ret e vo savet Mab an den, ");
INSERT INTO breBRG_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","evit na vo ket kollet piv bennak a gred ennañ, met ma en devo ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Rak kement en deus Doue karet ar bed, m'en deus roet e Vab nemetañ, evit na vo ket kollet piv bennak a gred ennañ, met m'en devo ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Rak Doue n'en deus ket kaset e Vab er bed evit barn ar bed, met evit ma vo salvet ar bed drezañ. ");
INSERT INTO breBRG_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","An hini a gred ennañ n'eo ket barnet, met an hini na gred ket a zo dija barnet, abalamour n'en deus ket kredet e anv Mab nemetañ Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hag an dra kiriek d'ar varnedigezh eo penaos ar sklêrijenn a zo deuet er bed, ha penaos o deus an dud karet muioc'h an deñvalijenn eget ar sklêrijenn, abalamour ma oa fall o oberoù. ");
INSERT INTO breBRG_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Rak piv bennak a ra an droug a gasa ar sklêrijenn, ha ne zeu ket d'ar sklêrijenn, gant aon na vefe rebechet e oberoù. ");
INSERT INTO breBRG_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Met an hini a ra hervez ar wirionez, a zeu d'ar sklêrijenn, evit ma vo disklêriet e oberoù, abalamour int graet e Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Goude-se, Jezuz a yeas gant e ziskibien war douar Judea, hag eno e chomas ganto hag e vadeze. ");
INSERT INTO breBRG_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yann a vadeze ivez e Enon, tost ouzh Salim, abalamour ma oa eno kalz a zour, hag ez aed di evit bezañ badezet, ");
INSERT INTO breBRG_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","rak Yann ne oa ket bet c'hoazh lakaet er prizon. ");
INSERT INTO breBRG_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bez' e voe un tamall etre diskibien Yann hag ar Yuzevien, diwar-benn ar c'hlanidigezh. ");
INSERT INTO breBRG_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dont a rejont da gavout Yann, hag e lavarjont dezhañ: Mestr, an hini a oa ganit d'an tu all d'ar Jordan, hag ac'h eus roet testeni dezhañ, setu, eñ a vadez, hag an holl a ya d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yann a respontas: Den ne c'hell ober netra, ma n'eo ket bet roet dezhañ eus an neñv. ");
INSERT INTO breBRG_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","C'hwi hoc'h-unan a zo testoù din em eus lavaret: N'eo ket me eo ar C'hrist, met kaset on bet a-raok dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","An hini en deus ar wreg eo an ozhac'h; met mignon an ozhac'h a zo eno hag en selaou; leuniet eo a levenez o klevout mouezh an ozhac'h, hag al levenez-se a zo va hini; mat-tre eo. ");
INSERT INTO breBRG_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ret eo dezhañ kreskiñ ha din bihanaat. ");
INSERT INTO breBRG_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","An hini a zeu eus an nec'h a zo dreist an holl; an hini a zeu eus an douar a zo eus an douar hag a gomz eus an douar; an hini a zeu eus an neñv a zo dreist an holl; ");
INSERT INTO breBRG_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","reiñ a ra testeni eus ar pezh en deus gwelet ha klevet; met den ne zegemer e desteni. ");
INSERT INTO breBRG_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","An hini a zegemer e desteni, en deus siellet penaos eo Doue gwirion. ");
INSERT INTO breBRG_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Rak an hini en deus Doue kaset a lavar komzoù Doue, rak Doue ne ro ket dezhañ ar Spered dre vuzul. ");
INSERT INTO breBRG_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","An Tad a gar ar Mab hag en deus lakaet pep tra etre e zaouarn. ");
INSERT INTO breBRG_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","An hini a gred er Mab en deus ar vuhez peurbadus, met an hini na sent ket ouzh ar Mab ne welo ket ar vuhez, met fulor Doue a chomo warnañ. ");
INSERT INTO breBRG_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","An Aotrou, o vezañ gouezet o devoa ar farizianed klevet e rae hag e vadeze muioc'h a ziskibien eget Yann, ");
INSERT INTO breBRG_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(koulskoude ne oa ket Jezuz e-unan a vadeze, met e ziskibien) ");
INSERT INTO breBRG_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","a guitaas Bro-Judea, hag a zistroas e Galilea; ");
INSERT INTO breBRG_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","met, ret e oa dezhañ tremen dre Samaria. ");
INSERT INTO breBRG_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Erruout a reas eta en ur gêr eus Samaria, anvet Sikar, tost d'an douar en devoa Jakob roet d'e vab Jozef. ");
INSERT INTO breBRG_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eno e oa puñs Jakob. Jezuz eta, skuizh gant an hent, a azezas e-kichen ar puñs; war-dro ar c'hwec'hvet eur e oa. ");
INSERT INTO breBRG_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ur wreg samaritan o vezañ deuet evit tennañ dour, Jezuz a lavaras dezhi: Ro din da evañ. ");
INSERT INTO breBRG_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","E ziskibien a oa aet e kêr, evit prenañ boued. ");
INSERT INTO breBRG_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ar wreg samaritan a respontas dezhañ: Penaos, te hag a zo yuzev, a c'houlenn da evañ diganin-me, ur Samaritanez? (Rak ar Yuzevien ne zarempredont ket gant ar Samaritaned.) ");
INSERT INTO breBRG_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jezuz a respontas hag a lavaras dezhi: Mar anavezjes donezon Doue, ha piv eo an hini a lavar dit: Ro din da evañ, te a c'houlennje da-unan digantañ, hag eñ a roje dit dour bev. ");
INSERT INTO breBRG_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ar wreg a lavaras dezhañ: Aotrou, te ne'c'h eus netra evit tennañ dour, hag ar puñs a zo don; a-belec'h eta ez pefe an dour bev-se? ");
INSERT INTO breBRG_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Brasoc'h out eget hon tad Jakob en deus roet deomp ar puñs-mañ hag en deus evet e-unan anezhañ, kenkoulz evel e vibien hag e loened? ");
INSERT INTO breBRG_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jezuz a respontas dezhi: Piv bennak a ev eus an dour-mañ en devo c'hoazh sec'hed; ");
INSERT INTO breBRG_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","met an hini a evo eus an dour a roin dezhañ n'en devo biken sec'hed; hag an dour a roin dezhañ a zeuio ennañ ur vammenn-dour a strinko evit ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ar wreg a lavaras dezhañ: Aotrou, ro din an dour-se, evit na'm bo ken sec'hed, ha na zeuin ken da dennañ dour amañ. ");
INSERT INTO breBRG_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jezuz a lavaras dezhi: Kae, galv da bried, ha deus amañ. ");
INSERT INTO breBRG_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ar wreg a respontas: Ne'm eus pried ebet. Jezuz a lavaras dezhi: Lavaret mat ec'h eus: Ne'm eus pried ebet; ");
INSERT INTO breBRG_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","rak pemp pried ac'h eus bet; hag an hini a zo ganit bremañ n'eo ket da bried; gwir ac'h eus lavaret e kement-se. ");
INSERT INTO breBRG_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ar wreg a lavaras dezhañ: Aotrou, gwelout a ran out ur profed. ");
INSERT INTO breBRG_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Hon tadoù o deus azeulet war ar menez-mañ, ha c'hwi a lavar penaos al lec'h e pelec'h eo ret azeuliñ eo Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jezuz a lavaras dezhi: Gwreg, kred ac'hanon; an amzer a zeu ma n'azeulor ken an Tad na war ar menez-mañ nag e Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","C'hwi a azeul ar pezh n'anavezit ket; evidomp-ni, ni a azeul ar pezh a anavezomp, rak ar silividigezh a zeu eus ar Yuzevien. ");
INSERT INTO breBRG_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Met an eur a zeu, ha deuet eo dija, ma'c'h azeulo ar gwir azeulerien an Tad e spered hag e gwirionez, rak an Tad a c'houlenn ar seurt azeulerien-se. ");
INSERT INTO breBRG_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Doue a zo Spered, hag eo ret d'ar re en azeul, e azeuliñ e spered hag e gwirionez. ");
INSERT INTO breBRG_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ar wreg a lavaras dezhañ: Gouzout a ran penaos ar Mesiaz, an hini a c'halver Krist, a dle dont; pa vo-eñ deuet, e tisklêrio deomp an holl draoù. ");
INSERT INTO breBRG_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jezuz a lavaras dezhi: Me eo, me, an hini a gomz ouzhit. ");
INSERT INTO breBRG_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","War gement-se, e ziskibien a erruas, hag e oant souezhet dre ma komze gant ur wreg; koulskoude hini anezho ne lavaras dezhañ: Petra a c'houlennez? Pe, perak e komzez ganti? ");
INSERT INTO breBRG_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Neuze ar wreg a lezas he fod-dour, a yeas e kêr, hag a lavaras d'an dud: ");
INSERT INTO breBRG_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Deuit da welout un den en deus lavaret din kement am eus graet; ne vefe ket eñ ar C'hrist? ");
INSERT INTO breBRG_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mont a rejont eta eus kêr, hag ez ejont d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Koulskoude, e ziskibien a bede anezhañ, o lavarout: Mestr, debr. ");
INSERT INTO breBRG_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Met eñ a lavaras dezho: Me am eus da zebriñ ur boued n'anavezit ket. ");
INSERT INTO breBRG_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","An diskibien a lavare eta an eil d'egile: Unan bennak en defe degaset da zebriñ dezhañ? ");
INSERT INTO breBRG_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jezuz a lavaras dezho: Va boued eo ober bolontez an hini en deus va c'haset, ha peurober e oberenn. ");
INSERT INTO breBRG_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ne lavarit ket ez eus c'hoazh pevar miz ac'han d'an eost? Setu, me a lavar deoc'h: Savit ho taoulagad, ha sellit ouzh ar maezioù a wenna dija evit an eost. ");
INSERT INTO breBRG_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","An hini a ved en deus ur gopr, hag a zastum frouezh evit ar vuhez peurbadus, evit m'en em laouenaio an hini a had ivez gant an hini a ved. ");
INSERT INTO breBRG_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Rak e kement-mañ eo gwir ar gomz-mañ: Unan all eo an hader, hag unan all eo ar meder. ");
INSERT INTO breBRG_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me am eus ho kaset e-lec'h n'hoc'h eus ket labouret; reoù all o deus labouret, ha c'hwi a zo aet war o labour. ");
INSERT INTO breBRG_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kalz eus Samaritaned ar gêr-se a gredas ennañ, abalamour da gomz ar wreg; roet he devoa an testeni-mañ: Lavaret en deus din kement am eus graet. ");
INSERT INTO breBRG_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ar Samaritaned eta, o vezañ deuet d'e gavout, a bedas anezhañ da chom ganto; hag e chomas daou zevezh eno. ");
INSERT INTO breBRG_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hag un niver brasoc'h a gredas abalamour d'e gelennadurezh. ");
INSERT INTO breBRG_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hag e lavarent d'ar wreg: N'eo ket abalamour da'z lavar eo e kredomp, rak klevet hon eus anezhañ hon-unan, hag ec'h anavezomp penaos hemañ eo e gwirionez Salver ar bed, ar C'hrist. ");
INSERT INTO breBRG_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Daou zevezh goude, ez eas kuit ac'hano, evit mont e Galilea, ");
INSERT INTO breBRG_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","rak Jezuz e-unan en devoa disklêriet penaos ur profed n'eo ket enoret en e vro. ");
INSERT INTO breBRG_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pa oa erru e Galilea, e voe degemeret mat gant ar C'halileiz o devoa gwelet kement en devoa graet e Jeruzalem deiz ar gouel; rak int ivez a oa aet d'ar gouel. ");
INSERT INTO breBRG_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jezuz a zeuas eta a-nevez da Gana e Galilea, e-lec'h m'en devoa graet gwin gant dour. Ha, bez' e oa e Kafarnaoum un Aotrou a di ar roue a oa klañv e vab. ");
INSERT INTO breBRG_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","An den-mañ, o vezañ anavezet penaos Jezuz a oa deuet eus Judea da C'halilea, a yeas d'e gavout hag a bedas anezhañ da ziskenn evit yac'haat e vab, rak mont a rae da vervel. ");
INSERT INTO breBRG_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jezuz a lavaras: Ma ne welit ket a sinoù hag a virakloù, ne gredit ket. ");
INSERT INTO breBRG_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","An Aotrou-mañ a di ar roue a lavaras dezhañ: Aotrou, diskenn, a-raok ma varvo va bugel. ");
INSERT INTO breBRG_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jezuz a lavaras dezhañ: Kae, da vab a vev. An den-mañ a gredas ar pezh en devoa Jezuz lavaret dezhañ, hag a yeas kuit. ");
INSERT INTO breBRG_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Evel ma tiskenne, e vevelien a zeuas a-raok dezhañ, hag a lavaras dezhañ: Da vab a vev. ");
INSERT INTO breBRG_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eñ a c'houlennas outo da bet eur e oa en em gavet gwelloc'h. Hag int a lavaras dezhañ: Dec'h d'ar seizhvet eur, an derzhienn a guitaas anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hag an tad a anavezas e oa d'an eur-se en devoa Jezuz lavaret dezhañ: Da vab a vev; hag e kredas, eñ hag holl dud e di. ");
INSERT INTO breBRG_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jezuz a reas an eil mirakl-se en e zistro eus Judea da C'halilea. ");
INSERT INTO breBRG_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Goude-se, e teue ur gouel gant ar Yuzevien, ha Jezuz a bignas da Jeruzalem. ");
INSERT INTO breBRG_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bez' e oa e Jeruzalem, tost ouzh dor an Deñved, ur stank, galvet en hebraeg Betesda, hag en devoa pemp porched. ");
INSERT INTO breBRG_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Eno e oa gourvezet un niver bras a dud klañv, dall, kamm ha seizet, a c'hortoze keflusk an dour. ");
INSERT INTO breBRG_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Rak un ael a ziskenne er stank, a amzer-da-amzer, hag a gemmeske an dour. An hini kentañ a yae e-barzh, goude ma vije bet kemmesket an dour, a veze yac'haet, n'eus forzh peseurt kleñved a vije gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bez' e oa eno un den hag a oa klañv abaoe eizh vloaz ha tregont. ");
INSERT INTO breBRG_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jezuz, o welout anezhañ gourvezet hag oc'h anavezout e oa dija klañv abaoe pell amzer, a lavaras dezhañ: Fellout a ra dit bezañ yac'haet? ");
INSERT INTO breBRG_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ar c'hlañvour a respontas dezhañ: Aotrou, ne'm eus den evit va zeurel er stank pa vez kemmesket an dour; hag e-pad m'emaon o vont, unan all a ziskenn a-raok din. ");
INSERT INTO breBRG_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jezuz a lavaras dezhañ: Sav, doug da wele, ha bale. ");
INSERT INTO breBRG_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kerkent, an den a oa yac'haet; hag e kemeras e wele, hag e valeas. Met an deiz-mañ a oa un deiz sabad. ");
INSERT INTO breBRG_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ar Yuzevien eta a lavaras d'an hini a oa bet yac'haet: Ar sabad eo; n'eo ket aotreet dit dougen da wele. ");
INSERT INTO breBRG_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eñ a respontas dezho: An hini en deus va yac'haet, en deus lavaret din: Doug da wele ha bale. ");
INSERT INTO breBRG_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hag int a c'houlennas outañ: Piv eo an den-se en deus lavaret dit: Doug da wele ha bale? ");
INSERT INTO breBRG_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Met an hini a oa bet yac'haet ne ouie ket piv e oa; rak Jezuz a oa en em dennet e-kuzh abalamour ma oa kalz a dud eno. ");
INSERT INTO breBRG_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Goude-se, Jezuz a gavas anezhañ en templ, hag a lavaras dezhañ: Setu, te a zo bet yac'haet; na bec'h ken, gant aon en em gavfe ganit un dra bennak gwashoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","An den-mañ a yeas hag a lavaras d'ar Yuzevien e oa Jezuz en devoa e yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Abalamour da gement-se, ar Yuzevien a heskine Jezuz, hag a glaske e lakaat d'ar marv, dre m'en devoa graet-se deiz ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Met Jezuz a lavaras dezho: Va Zad a labour betek vremañ, ha me a labour ivez. ");
INSERT INTO breBRG_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Abalamour da-se, ar Yuzevien a glaske c'hoazh muioc'h e lakaat d'ar marv, neket hepken dre ma torre ar sabad, met c'hoazh abalamour ma c'halve Doue e Dad, oc'h en em ober e-unan kevatal da Zoue. ");
INSERT INTO breBRG_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jezuz, o kemer ar gomz, a lavaras dezho: E gwirionez, e gwirionez, me a lavar deoc'h: ar Mab ne c'hell netra anezhañ e-unan, nemet en defe gwelet an Tad ouzh e ober; rak kement a ra an Tad, ar Mab ivez en gra eveltañ. ");
INSERT INTO breBRG_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Rak an Tad a gar ar Mab, hag a ziskouez dezhañ kement a ra. Ha diskouez a raio dezhañ oberoù brasoc'h eget ar re-mañ, evit ma viot sabatuet. ");
INSERT INTO breBRG_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Rak, evel ma ro an Tad ar vuhez d'ar re varv, evel-se ivez ar Mab a ro ar vuhez d'ar re a fell dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","An Tad ne varn den, met roet en deus pep barn d'ar Mab, ");
INSERT INTO breBRG_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","evit ma'c'h enoro an holl ar Mab, evel ma'c'h enoront an Tad. An hini na enor ket ar Mab, n'enor ket an Tad en deus e gaset. ");
INSERT INTO breBRG_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","E gwirionez, e gwirionez, me a lavar deoc'h, an hini a selaou va c'homz, hag a gred en hini en deus va c'haset, en deus ar vuhez peurbadus, ha ne zeu ket e barnedigezh, met tremenet eo eus ar marv d'ar vuhez. ");
INSERT INTO breBRG_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","E gwirionez, e gwirionez, me a lavar deoc'h, an amzer a zeu, ha deuet eo dija, ma klevo ar re varv mouezh Mab Doue; hag ar re he c'hlevo, a vevo. ");
INSERT INTO breBRG_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Rak, evel m'en deus an Tad ar vuhez ennañ e-unan, roet en deus ivez d'ar Mab ar galloud da gaout ar vuhez ennañ e-unan, ");
INSERT INTO breBRG_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","hag roet en deus dezhañ ar galloud da varn, abalamour ma'z eo Mab an den. ");
INSERT INTO breBRG_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na vezit ket eta souezhet a gement-se; rak dont a ra an eur ma klevo e vouezh an holl re a zo er bezioù, ha ma'z aint er-maez: ");
INSERT INTO breBRG_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ar re o devo graet mat, en adsavidigezh a vuhez; hag ar re o devo graet fall, en adsavidigezh a varn. ");
INSERT INTO breBRG_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne c'hellan ober netra ac'hanon va-unan, barn a ran diouzh ma klevan, ha va barn a zo reizh, rak ne glaskan ket va c'hoant, met bolontez va Zad en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mar roan testeni ac'hanon va-unan, va zesteni n'eo ket gwir. ");
INSERT INTO breBRG_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bez' ez eus unan hag a ro testeni ac'hanon, ha gouzout a ran an testeni a ro ac'hanon a zo gwir. ");
INSERT INTO breBRG_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kaset hoc'h eus tud da gavout Yann, hag eñ en deus roet testeni d'ar wirionez. ");
INSERT INTO breBRG_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Evidon-me, ne glaskan ket testeni an den, met lavarout a ran kement-mañ evit ma viot salvet. ");
INSERT INTO breBRG_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yann a oa ar c'houlaouenn a zev, hag a sklaera, ha fellet eo bet deoc'h, evit ur pennad, en em laouenaat ouzh e sklêrijenn. ");
INSERT INTO breBRG_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Met me am eus un testeni brasoc'h eget hini Yann, rak an oberoù en deus va Zad roet din da beurober, an oberoù-mañ memes a ran, a ro ac'hanon an testeni-mañ, penaos en deus an Tad va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hag an Tad en deus va c'haset, en deus e-unan roet testeni ac'hanon. C'hwi n'hoc'h eus biskoazh klevet e vouezh, na gwelet e zremm. ");
INSERT INTO breBRG_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hag e c'her ne chom ket ennoc'h, pa'z eo gwir ne gredit ket en hini en deus kaset deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Furchal a rit ar Skriturioù, rak enno e kredit kaout ar vuhez peurbadus, hag int eo ar re a ro testeni ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Koulskoude c'hwi ne fell ket deoc'h dont da'm c'havout, evit kaout ar vuhez. ");
INSERT INTO breBRG_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne dennan ket a c'hloar a-berzh an dud; ");
INSERT INTO breBRG_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","met gouzout a ran n'emañ ket karantez Doue ennoc'h hoc'h-unan. ");
INSERT INTO breBRG_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Deuet on en anv va Zad, ha ne zegemerit ket ac'hanon; mar deu unan all en e anv e-unan, c'hwi a zegemero anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Penaos e c'hellit krediñ, pa dennit ho kloar an eil digant egile, ha pa ne glaskit ket ar gloar a zeu eus Doue hepken? ");
INSERT INTO breBRG_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na soñjit ket eo me ho tamallo dirak an Tad; Moizez, an hini a esperit ennañ, eo an hini ho tamallo. ");
INSERT INTO breBRG_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Rak mar kredjec'h Moizez, e kredjec'h ivez ac'hanon, rak eñ en deus skrivet diwar va fenn. ");
INSERT INTO breBRG_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Met ma ne gredit ket e skridoù, penaos e kredot va c'homzoù? ");
INSERT INTO breBRG_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Goude-se, Jezuz a dremenas en tu all da vor Galilea, pe vor Tiberiaz. ");
INSERT INTO breBRG_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ur bobl vras a heulie anezhañ, abalamour ma welent ar mirakloù a rae war ar re glañv. ");
INSERT INTO breBRG_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jezuz a bignas war ar menez, hag eno ec'h azezas gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Setu, ar Pask, gouel ar Yuzevien, a oa tost. ");
INSERT INTO breBRG_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jezuz eta, o vezañ savet e zaoulagad, hag o welout ul lod bras a dud o tont d'e gavout, a lavaras da Filip: Pelec'h e prenimp bara evit m'o devo an dud-mañ da zebriñ? ");
INSERT INTO breBRG_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Met, eñ a lavare kement-se evit amprouiñ anezhañ, rak gouzout a rae ar pezh edo o vont d'ober. ");
INSERT INTO breBRG_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip a respontas dezhañ: Daou c'hant diner a vara ne vefe ket a-walc'h evit reiñ un tammig da bep hini. ");
INSERT INTO breBRG_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Unan eus e ziskibien, Andrev, breur Simon-Pêr, a lavaras dezhañ: ");
INSERT INTO breBRG_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Bez' ez eus amañ ur paotrig en deus pemp bara heiz, ha daou besk; met petra eo kement-se evit kement a dud? ");
INSERT INTO breBRG_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Koulskoude Jezuz a lavaras: Grit d'an dud azezañ. Bez' e oa kalz a c'heot el lec'h-se. Ar wersed eta a azezas, en niver a war-dro pemp mil. ");
INSERT INTO breBRG_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jezuz a gemeras ar baraoù, hag o vezañ trugarekaet, o roas d'an diskibien, hag an diskibien d'ar re a oa azezet; en hevelep doare e rojont eus ar pesked, kement ha ma fellas dezho. ");
INSERT INTO breBRG_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Goude m'o devoe bet o gwalc'h, e lavaras d'e ziskibien: Dastumit an tammoù a zo manet, evit na vo kollet netra. ");
INSERT INTO breBRG_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dastum a rejont eta anezho hag e leugnjont daouzek paner gant an tammoù eus ar pemp bara heiz, chomet a zilerc'h gant ar re o devoa debret. ");
INSERT INTO breBRG_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","An dud-se, o welout ar mirakl en devoa Jezuz graet, a lavare: Hemañ eo e gwirionez ar profed a dlee dont er bed. ");
INSERT INTO breBRG_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jezuz, oc'h anavezout ez aent da zont d'e gemer evit e lakaat da roue, en em dennas adarre e-unan war ar menez. ");
INSERT INTO breBRG_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pa voe deuet an abardaez, e ziskibien a ziskennas betek ar mor, ");
INSERT INTO breBRG_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","hag o vezañ aet er vag, e fellas dezho mont en tu all d'ar mor, da Gafarnaoum; dija e oa teñval, ha Jezuz ne oa ket c'hoazh deuet d'o c'havout. ");
INSERT INTO breBRG_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dre ma oa kreñv an avel, koummoù ar mor a save. ");
INSERT INTO breBRG_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ha, p'o devoa roeñvet war-dro pemp war-n-ugent pe tregont stadenn, e weljont Jezuz a valee war ar mor hag a dostae ouzh ar vag; hag o devoe aon. ");
INSERT INTO breBRG_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Met eñ a lavaras dezho: Me eo, n'ho pet ket aon. ");
INSERT INTO breBRG_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Degemer a rejont anezhañ eta gant joa er vag, ha kerkent ar vag en em gavas el lec'h ma'z aent. ");
INSERT INTO breBRG_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","An deiz war-lerc'h, ar bobl, hag a oa chomet en tu all d'ar mor, a welas ne oa bet eno bag ebet, nemet an hini ma oa aet e ziskibien enni, ha penaos Jezuz ne oa ket aet e-barzh ganto, met penaos e ziskibien a oa aet kuit o-unan; ");
INSERT INTO breBRG_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","koulskoude bagoù all a oa erruet eus Tiberiaz, tost ouzh al lec'h m'o devoa debret ar bara, goude m'en devoe Jezuz trugarekaet. ");
INSERT INTO breBRG_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pa welas eta ar bobl ne oa na Jezuz nag e ziskibien eno, e pignjont er bagoù hag ez ejont da Gafarnaoum da glask Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hag o vezañ e gavet en tu all d'ar mor, e lavarjont dezhañ: Mestr, pegoulz out en em gavet amañ? ");
INSERT INTO breBRG_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jezuz a respontas dezho hag a lavaras: E gwirionez, e gwirionez, me a lavar deoc'h, c'hwi am c'hlaske, neket abalamour m'hoc'h eus gwelet mirakloù, met abalamour m'hoc'h eus debret bara ha m'hoc'h eus bet ho kwalc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Labourit, neket evit ar boued a ya da goll, met evit an hini a chom betek ar vuhez peurbadus, hag a vo roet deoc'h gant Mab an den; rak Doue, an Tad, en deus e verket gant e siell. ");
INSERT INTO breBRG_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lavarout a rejont eta dezhañ: Petra a raimp evit labourat da oberoù Doue? ");
INSERT INTO breBRG_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jezuz a respontas dezho: Hemañ eo ober Doue, ma kredot en hini en deus kaset. ");
INSERT INTO breBRG_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Neuze e lavarjont dezhañ: Peseurt mirakl a rez eta, evit m'en gwelimp ha ma kredimp ennout? Peseurt labour a rez? ");
INSERT INTO breBRG_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hon tadoù o deus debret ar mann el lec'h distro, hervez ma'z eo skrivet: Roet en deus dezho da zebriñ bara an neñv. ");
INSERT INTO breBRG_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ha Jezuz a lavaras dezho: E gwirionez, e gwirionez, me a lavar deoc'h, Moizez n'en deus ket roet deoc'h bara an neñv, met va Zad a ro deoc'h gwir vara an neñv. ");
INSERT INTO breBRG_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Rak bara Doue eo an hini en deus diskennet eus an neñv, hag a ro ar vuhez d'ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Int a lavaras dezhañ: Aotrou, ro deomp atav eus ar bara-se. ");
INSERT INTO breBRG_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ha Jezuz a respontas dezho: Me eo ar bara a vuhez; an hini a zeuio da'm c'havout n'en devo biken naon, hag an hini a gred ennon n'en devo biken sec'hed. ");
INSERT INTO breBRG_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Met e lavaret em eus deoc'h, gwelet hoc'h eus ac'hanon, ha ne gredit ket. ");
INSERT INTO breBRG_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kement a roio an Tad din a zeuio da'm c'havout, ha ne lakain ket er-maez an hini a zeuio davedon. ");
INSERT INTO breBRG_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Rak diskennet on eus an neñv, neket evit ober va bolontez, met bolontez an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ha setu amañ bolontez an Tad en deus va c'haset, na gollin hini eus ar re a zo bet roet din, met ma'c'h adsavin anezho a varv en deiz diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Houmañ eo bolontez an hini en deus va c'haset, penaos piv bennak a wel ar Mab hag a gred ennañ, en devo ar vuhez peurbadus; ha me en adsavo a varv en deiz diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ar Yuzevien a c'hrozmole eta a-enep dezhañ, abalamour ma lavare: Me eo ar bara diskennet eus an neñv. ");
INSERT INTO breBRG_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hag e lavarent: N'eo ket hemañ Jezuz, mab Jozef, a anavezomp e dad hag e vamm? Penaos eta e lavar: Me a zo diskennet eus an neñv? ");
INSERT INTO breBRG_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jezuz a respontas hag a lavaras dezho: Na c'hrozmolit ket etrezoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Den ne c'hell dont da'm c'havout ma ne vefe sachet gant an Tad en deus va c'haset; ha me en adsavo a varv en deiz diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Skrivet eo er brofeded: Kelennet e vint holl gant Doue. Piv bennak en deus selaouet an Tad hag en deus desket digantañ, a zeu da'm c'havout. ");
INSERT INTO breBRG_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","N'eo ket en defe un den gwelet an Tad; nemet an hini a zeu eus Doue, hennezh nemetken en deus gwelet an Tad. ");
INSERT INTO breBRG_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","E gwirionez, e gwirionez, ma a lavar deoc'h: An hini a gred ennon en deus ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me eo ar bara a vuhez. ");
INSERT INTO breBRG_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ho tadoù o deus debret ar mann el lec'h distro, hag int a zo marv. ");
INSERT INTO breBRG_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amañ eo ar bara a zo diskennet eus an neñv, evit na varvo ket an hini a zebro dioutañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me eo ar bara bev a zo diskennet eus an neñv; mar debr unan bennak eus ar bara-mañ, e vevo da viken; hag ar bara a roin eo va c'hig. Reiñ a rin anezhañ evit buhez ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ar Yuzevien a dabute eta etrezo, o lavarout: Penaos e c'hell an den-mañ reiñ deomp e gig da zebriñ? ");
INSERT INTO breBRG_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jezuz a lavaras dezho: E gwirionez, e gwirionez, me a lavar deoc'h: Ma ne zebrit ket kig Mab an den, ha ma n'evit ket e wad, n'ho po ket ar vuhez ennoc'h hoc'h-unan. ");
INSERT INTO breBRG_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","An hini a zebr va c'hig hag a ev va gwad, en deus ar vuhez peurbadus; hag ec'h adsavin anezhañ a varv en deiz diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Rak va c'hig a zo e gwirionez ur boued, ha va gwad a zo e gwirionez un evaj. ");
INSERT INTO breBRG_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","An hini a zebr va c'horf hag a ev va gwad a chom ennon, ha me ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Evel m'en deus an Tad, hag a zo bev, kaset ac'hanon, ha ma vevan dre an Tad, evel-se an hini a zebr ac'hanon a vevo drezon. ");
INSERT INTO breBRG_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Amañ eo ar bara a zo diskennet eus an neñv. N'eo ket evel ho tadoù; debret o deus ar mann hag int a zo marv; an hini a zebro ar bara-mañ a vevo da viken. ");
INSERT INTO breBRG_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jezuz a lavaras an traoù-mañ, o kelenn e sinagogenn Gafarnaoum. ");
INSERT INTO breBRG_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kalz eus e ziskibien, o vezañ e glevet, a lavaras: Ar ger-se a zo kalet; piv a c'hell e selaou? ");
INSERT INTO breBRG_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Met Jezuz, oc'h anavezout ennañ e-unan e c'hrozmole e ziskibien a gement-se, a lavaras dezho: Skouer fall a gemerit a gement-se? ");
INSERT INTO breBRG_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Petra eta e vo, mar gwelfec'h Mab an den o pignat el lec'h ma oa kent? ");
INSERT INTO breBRG_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ar spered eo a vuhezeka; ar c'hig ne servij da netra. Ar gerioù a lavaran deoc'h a zo spered ha buhez. ");
INSERT INTO breBRG_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Met, bez' ez eus en ho touez lod ha ne gredont ket. Rak Jezuz a ouie adalek ar penn-kentañ pere a oa ar re na gredent ket, ha piv e oa an hini en gwerzhje. ");
INSERT INTO breBRG_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hag e lavare: Abalamour da gement-se eo, em eus lavaret deoc'h penaos den ne c'hell dont da'm c'havout, ma n'eo ket roet kement-se dezhañ gant va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Adalek neuze kalz eus e ziskibien en em dennas, ha n'aent ket ken gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jezuz a lavaras eta d'an daouzek: Ha c'hwi, ne fell ket deoc'h mont kuit ivez? ");
INSERT INTO breBRG_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon-Pêr a respontas dezhañ: Aotrou, da biv ez afemp? Te ac'h eus komzoù ar vuhez peurbadus, ");
INSERT INTO breBRG_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ha ni hon eus kredet, hag hon eus anavezet out ar C'hrist, Mab an Doue bev. ");
INSERT INTO breBRG_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jezuz a respontas dezho: Ne'm eus ket ho tibabet, ho taouzek? Hag unan ac'hanoc'h a zo un diaoul. ");
INSERT INTO breBRG_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Komz a rae diwar-benn Judaz-Iskariod, mab Simon, rak hemañ eo a dlee e werzhañ, evitañ da vezañ unan eus an daouzek. ");
INSERT INTO breBRG_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Goude an traoù-se, Jezuz a valee dre C'halilea, rak ne felle ket dezhañ chom e Judea, abalamour ma klaske ar Yuzevien e lazhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Met, gouel ar Yuzevien, galvet an Teltennoù, a dostae. ");
INSERT INTO breBRG_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","E vreudeur a lavaras dezhañ: Kae ac'han, ha kae e Judea, evit ma welo ivez da ziskibien an oberoù a rez. ");
INSERT INTO breBRG_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Rak den ne ra netra e-kuzh, pa glask bezañ anavezet. Mar rez an traoù-se, en em ziskouez da-unan d'ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rak e vreudeur memes ne gredent ket ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jezuz a lavaras dezho: Va amzer n'eo ket c'hoazh deuet; met hoc'h amzer-hu a zo atav deuet. ");
INSERT INTO breBRG_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ar bed ne c'hell ket ho kasaat; met kasaat a ra ac'hanon, abalamour ma roan testeni anezhañ, penaos eo fall e oberoù. ");
INSERT INTO breBRG_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Evidoc'h-c'hwi, pignit d'ar gouel-mañ; evidon-me, ne bignin ket c'hoazh dezhañ, rak va amzer n'eo ket c'hoazh deuet. ");
INSERT INTO breBRG_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hag o vezañ lavaret kement-se dezho, e chomas e Galilea. ");
INSERT INTO breBRG_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Met, pa voe aet e vreudeur, e pignas ivez d'ar gouel, neket a-wel d'an holl, met evel e-kuzh. ");
INSERT INTO breBRG_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ar Yuzevien eta a glaske anezhañ e-pad ar gouel, hag a lavare: Pelec'h emañ? ");
INSERT INTO breBRG_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hag e voe ur brud diwar e benn e-touez ar bobl. Darn a lavare: Un den mat eo; ha darn all a lavare: Nann, met touellañ a ra ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Koulskoude, den ne gomze frank anezhañ, gant aon rak ar Yuzevien. ");
INSERT INTO breBRG_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","War-dro hanter ar gouel, Jezuz a bignas en templ, hag a gelenne. ");
INSERT INTO breBRG_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ar Yuzevien a oa souezhet hag a lavare: Penaos ec'h anavez an den-mañ ar skriturioù, o vezañ n'en deus ket o desket? ");
INSERT INTO breBRG_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jezuz a respontas dezho: Va c'helennadurezh n'eo ket ac'hanon, met eus an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mar fell da unan bennak ober bolontez Doue, ec'h anavezo hag-eñ eo va c'helennadurezh eus Doue, pe ha me a gomz ac'hanon va-unan. ");
INSERT INTO breBRG_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","An hini a gomz anezhañ e-unan, a glask e c'hloar e-unan; met an hini a glask gloar an hini en deus e gaset, a dle bezañ kredet, ha n'eus ket a zireizhder ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","N'en deus ket Moizez roet al lezenn deoc'h? Hag hini ac'hanoc'h ne vir anezhi. Perak e klaskit va lazhañ? ");
INSERT INTO breBRG_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ar bobl a respontas dezhañ: Un diaoul ac'h eus; piv eo an hini a glask da lazhañ? ");
INSERT INTO breBRG_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jezuz a respontas hag a lavaras dezho: Un oberenn am eus graet, hag oc'h holl souezhet a gement-se. ");
INSERT INTO breBRG_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moizez en deus gourc'hemennet deoc'h an amdroc'h (n'eo ket ma teu eus Moizez, met eus an Tadoù), ha c'hwi a amdroc'h un den deiz ar sabad. ");
INSERT INTO breBRG_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mar bez amdroc'het un den deiz ar sabad, evit na vo ket torret lezenn Voizez, perak en em fulorit a-enep ac'hanon abalamour ma em eus yac'haet un den penn-da-benn deiz ar sabad? ");
INSERT INTO breBRG_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na varnit ket hervez an doare, met barnit hervez ar reizhder. ");
INSERT INTO breBRG_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hag ur re bennak eus Jeruzalem a lavare: n'eo ket an hini a glasker da lakaat da vervel? ");
INSERT INTO breBRG_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ha setu aze e komz frank, ha ne lavarer netra dezhañ. Ar mestroù, hag anavezet o defe ez eo e gwirionez ar C'hrist? ");
INSERT INTO breBRG_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Koulskoude, ni a oar a-belec'h eo hemañ; e-lec'h pa zeuio ar C'hrist, den n'anavezo a-belec'h eo. ");
INSERT INTO breBRG_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ha Jezuz a grie en templ eta, o kelenn, hag o lavarout: C'hwi a anavez ac'hanon, hag ec'h ouzoc'h a-belec'h on. N'on ket deuet ac'hanon va-unan, met an hini en deus va c'haset a zo gwirion, ha c'hwi n'anavezit ket anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me a anavez anezhañ, rak dont a ran eus e berzh, hag eñ eo en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Klask a raent kregiñ ennañ; met den ne grede lakaat e zorn warnañ, abalamour e eur ne oa ket c'hoazh deuet. ");
INSERT INTO breBRG_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Koulskoude, kalz eus ar bobl a gredas ennañ, hag a lavare: Pa zeuio ar C'hrist, hag ober a raio brasoc'h mirakloù eget ma ra hemañ? ");
INSERT INTO breBRG_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ar farizianed, o vezañ klevet ar pezh a lavare ar bobl anezhañ e-kuzh, a gasas, a-unvan gant ar veleien vras, serjanted evit kregiñ ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Setu perak Jezuz a lavaras dezho: Me a zo ganeoc'h c'hoazh evit un nebeut amzer, ha mont a ran da gavout an hini en deus va c'haset; ");
INSERT INTO breBRG_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","klask a reot ac'hanon, ha ne'm c'havot ket; ha c'hwi, ne c'hellit ket dont e-lec'h ma'z on. ");
INSERT INTO breBRG_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ar Yuzevien eta a lavare etrezo: Pelec'h ez aio, na c'hellimp ket kavout anezhañ? Mont a raio etrezek ar re a zo strewet e-touez ar C'hresianed, ha kelenn a raio ar C'hresianed? ");
INSERT INTO breBRG_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Petra eo ar pezh en deus lavaret: C'hwi am c'hlasko, ha ne'm c'havot ket; ha c'hwi ne c'hellit ket dont e-lec'h ma'z on? ");
INSERT INTO breBRG_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","An deiz diwezhañ ha brasañ eus ar gouel, Jezuz en em gave eno, hag a grie: Mar en deus unan bennak sec'hed, ra zeuio da'm c'havout, ha ra evo. ");
INSERT INTO breBRG_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","An hini a gred ennon, stêrioù dour a vuhez a redo eus e askre, evel ma lavar ar Skritur. ");
INSERT INTO breBRG_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Met eñ a lavare kement-se eus ar Spered a dlee resev ar re a gredje ennañ; rak ar Spered-Santel ne oa ket bet c'hoazh roet, abalamour na oa ket bet c'hoazh roet da Jezuz e c'hloar. ");
INSERT INTO breBRG_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kalz eus ar bobl, o vezañ klevet ar gerioù-se, a lavare: Hemañ eo e gwirionez ar profed. ");
INSERT INTO breBRG_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Reoù all a lavare: Ar C'hrist eo. Ha reoù all a lavare: Met ar C'hrist, ha dont a ra eus Galilea? ");
INSERT INTO breBRG_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ar Skritur, ha ne lavar ket e teuio ar C'hrist eus lignez David hag eus bourc'h Betlehem, a-belec'h e oa David? ");
INSERT INTO breBRG_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ar bobl eta a oa lodennet diwar e benn. ");
INSERT INTO breBRG_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hag ur re bennak anezho a c'hoantae kregiñ ennañ, met den ne lakaas e zaouarn warnañ. ");
INSERT INTO breBRG_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ar serjanted eta a zistroas etrezek ar veleien vras hag ar farizianed; ar re-mañ a lavaras dezho: Perak n'hoc'h eus ket e zegaset? ");
INSERT INTO breBRG_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ar serjanted a respontas: Biskoazh den n'en deus komzet evel an den-se. ");
INSERT INTO breBRG_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ar farizianed a lavaras dezho: Bet oc'h-hu ivez touellet? ");
INSERT INTO breBRG_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ha bez' ez eus unan bennak eus ar mestroù pe eus ar farizianed hag en defe kredet ennañ? ");
INSERT INTO breBRG_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Met ar bobl villiget-mañ n'anavez ket al lezenn. ");
INSERT INTO breBRG_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem, an hini a oa deuet en noz da gavout Jezuz hag a oa unan anezho, a lavaras dezho: ");
INSERT INTO breBRG_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ha barn a ra hol lezenn un den hep bezañ e glevet hag hep anavezout ar pezh en deus graet? ");
INSERT INTO breBRG_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Int a respontas dezhañ: Bez' out ivez Galileat? Evesha ha gwel: profed ebet a zo deuet eus Galilea. ");
INSERT INTO breBRG_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ha pep hini en em dennas en e di. ");
INSERT INTO breBRG_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jezuz a yeas da Venez an Olived. ");
INSERT INTO breBRG_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Da c'houlou-deiz e tistroas adarre d'an templ, hag an holl bobl a zeuas d'e gavout; o vezañ azezet e kelenne anezho. ");
INSERT INTO breBRG_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Neuze ar skribed hag ar farizianed a zegasas ur wreg tapet en avoultriezh, hag, o vezañ he lakaet en o c'hreiz, ");
INSERT INTO breBRG_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","e lavarjont dezhañ: Mestr, ar wreg-mañ a zo bet souprenet oc'h ober avoultriezh, ");
INSERT INTO breBRG_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ha Moizez en deus gourc'hemennet deomp meinata an hevelep dud; te eta, petra a lavarez a gement-se? ");
INSERT INTO breBRG_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Lavarout a raent kement-se evit e amprouiñ, evit gallout e damall. Met Jezuz, o vezañ en em bleget, a skrive gant e viz war an douar. ");
INSERT INTO breBRG_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Evel ma talc'hent d'ober goulennoù outañ, e savas hag e lavaras dezho: An hini ac'hanoc'h a zo hep pec'hed, ra daolo ar maen kentañ ganti. ");
INSERT INTO breBRG_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hag o taoublegañ a-nevez, e skrive war an douar. ");
INSERT INTO breBRG_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pa glevjont kement-se, o kaout rebech digant o c'houstiañs, ez ejont kuit an eil goude egile, ar re goshañ da gentañ, betek ar re diwezhañ, ha Jezuz a voe lezet e-unan gant ar wreg chomet eno e-kreiz. ");
INSERT INTO breBRG_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Neuze Jezuz, o vezañ savet, evel na wele den nemet ar wreg, a lavaras dezhi: Gwreg, pelec'h emañ da damallerien? Ha n'en deus den barnet ac'hanout? ");
INSERT INTO breBRG_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hi a respontas: Den, Aotrou. Jezuz a lavaras dezhi: Me ne varnan ket ac'hanout kennebeut; kae ha na bec'h ken. ");
INSERT INTO breBRG_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jezuz a gomzas c'hoazh d'ar bobl, hag a lavaras: Me eo sklêrijenn ar bed; an hini a heul ac'hanon ne valeo ket en deñvalijenn, met bez' en devo sklêrijenn ar vuhez. ");
INSERT INTO breBRG_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ar farizianed a lavaras dezhañ: Te a ro testeni ac'hanout da-unan; da desteni n'eo ket gwirion. ");
INSERT INTO breBRG_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jezuz a respontas dezho: Petra bennak ma roan testeni ac'hanon va-unan, va zesteni a zo gwirion, rak gouzout a ran a-belec'h on deuet, ha pelec'h ez an; met c'hwi, n'ouzoc'h ket a-belec'h e teuan, na pelec'h ez an. ");
INSERT INTO breBRG_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","C'hwi a varn hervez ar c'hig; me ne varnan den. ");
INSERT INTO breBRG_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ha mar barnan, va barnedigezh a zo gwir; rak n'on ket va-unan-penn, met ganin emañ an Tad en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Skrivet eo en ho lezenn penaos testeni daou zen a zo gwir. ");
INSERT INTO breBRG_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me eo a ro testeni ac'hanon va-unan; hag an Tad en deus va c'haset a ro ivez testeni ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lavarout a rejont eta dezhañ: Pelec'h emañ da Dad? Jezuz a respontas: C'hwi n'anavezit na me, na va Zad. Mar anavezfec'h ac'hanon, ec'h anavezfec'h ivez va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jezuz a lavaras ar c'homzoù-mañ el lec'h ma oa an teñzor, o kelenn en templ; ha den ne groge ennañ, rak e eur ne oa ket deuet c'hoazh. ");
INSERT INTO breBRG_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jezuz a lavaras dezho c'hoazh: Mont a ran kuit, ha c'hwi am c'hlasko, hag e varvot en ho pec'hed; ne c'hellit ket dont e-lec'h ez an. ");
INSERT INTO breBRG_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ar Yuzevien a lavare eta: En em lazhañ a raio e-unan, peogwir e lavar: c'hwi ne c'hellit ket dont e-lec'h ez an. ");
INSERT INTO breBRG_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hag eñ a lavaras dezho: C'hwi a zo eus traoñ, me a zo eus krec'h. C'hwi a zo eus ar bed-mañ; me n'on ket eus ar bed-mañ. ");
INSERT INTO breBRG_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Setu perak em eus lavaret deoc'h e varvot en ho pec'hedoù: rak ma ne gredit ket ar pezh emaon, c'hwi a varvo en ho pec'hedoù. ");
INSERT INTO breBRG_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lavarout a rejont eta dezhañ: Piv out-te? Ha Jezuz a lavaras dezho: Ar pezh a lavaran deoc'h abaoe ar penn-kentañ. ");
INSERT INTO breBRG_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kalz a draoù am eus da lavarout ac'hanoc'h ha da varn ennoc'h; met an hini en deus va c'haset a zo gwirion, hag ar pezh am eus klevet digantañ, a lavaran d'ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ne gomprenjont ket e komze dezho eus an Tad. ");
INSERT INTO breBRG_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ha Jezuz a lavaras dezho: Pa ho po savet Mab an den, neuze ec'h anavezot ar pezh emaon, ha penaos ne ran netra ac'hanon va-unan, met e lavaran an traoù evel m'en deus va Zad o desket din. ");
INSERT INTO breBRG_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","An hini en deus va c'haset a zo ganin. Hag an Tad n'en deus ket va lezet va-unan, abalamour ma ran atav ar pezh a blij dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Evel ma lavare Jezuz an traoù-se, kalz a gredas ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jezuz a lavaras eta d'ar Yuzevien o devoa kredet ennañ: Mar chomit em ger, emaoc'h e gwirionez va diskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Anavezout a reot ar wirionez, hag ar wirionez ho tizereo. ");
INSERT INTO breBRG_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Respont a rejont dezhañ: Ni a zo eus lignez Abraham, ha biskoazh n'omp bet mevelien da zen; penaos eta e lavarez: C'hwi a vo lakaet dieub? ");
INSERT INTO breBRG_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jezuz a respontas dezho: E gwirionez, e gwirionez, me a lavar deoc'h, an hini en em ro d'ar pec'hed a zo mevel d'ar pec'hed. ");
INSERT INTO breBRG_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hag ar mevel ne chom ket atav en ti; met ar mab a chom ennañ atav. ");
INSERT INTO breBRG_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mar en deus ar Mab eta ho tizereet, c'hwi a vo e gwirionez dieub. ");
INSERT INTO breBRG_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gouzout a ran oc'h lignez Abraham, met c'hwi a glask va lazhañ abalamour na gav ket va ger a zigor en ho kalon. ");
INSERT INTO breBRG_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me a lavar ar pezh am eus gwelet e ti va Zad; ha c'hwi ivez, c'hwi a ra ar pezh hoc'h eus gwelet e ti ho tad. ");
INSERT INTO breBRG_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Int a respontas dezhañ: Hon tad eo Abraham. Jezuz a lavaras dezho: Ma vijec'h bugale Abraham, c'hwi a raje oberoù Abraham. ");
INSERT INTO breBRG_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Met bremañ, c'hwi a glask va lazhañ, me, un den en deus lavaret deoc'h ar wirionez am eus desket gant Doue; Abraham n'en deus ket graet kement-se. ");
INSERT INTO breBRG_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","C'hwi a ra oberoù ho tad. Lavarout a rejont eta dezhañ: Ni n'omp ket bet ganet eus un avoultriezh; un Tad hepken hon eus, Doue eo. ");
INSERT INTO breBRG_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jezuz a lavaras dezho: Ma vije Doue ho Tad, e karjec'h ac'hanon, abalamour ma'z on deuet eus Doue, hag a-berzh Doue e teuan; rak n'on ket deuet ac'hanon va-unan, met eñ eo an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Perak ne gomprenit ket va lavar? Abalamour da-se, ne c'hellit ket selaou va c'homz. ");
INSERT INTO breBRG_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ho tad, a ziskennit anezhañ, eo an diaoul, ha c'hwi a fell deoc'h ober c'hoantoù ho tad. Lazher-den eo bet adalek ar penn-kentañ, ha n'en deus ket kendalc'het er wirionez, dre ma n'eus ket a wirionez ennañ. Pa lavar ar gaou, e komz eus ar pezh a zo ennañ e-unan, rak gaouiat eo, ha tad d'ar gaou. ");
INSERT INTO breBRG_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Met abalamour ma lavaran ar wirionez, ne gredit ket ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Piv ac'hanoc'h a gendrec'ho ac'hanon a bec'hed? Mar lavaran ar wirionez, perak ne gredit ket ac'hanon? ");
INSERT INTO breBRG_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","An hini a zo eus Doue a selaou komzoù Doue; dre-se c'hwi ne selaouit ket, abalamour n'oc'h ket eus Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ar Yuzevien a respontas dezhañ: Ha n'hon eus ket lavaret mat penaos out ur Samaritan, ha penaos ez eus un diaoul ennout? ");
INSERT INTO breBRG_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jezuz a respontas: Ne'm eus ket un diaoul, met enoriñ a ran va Zad, ha c'hwi a zizenor ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne glaskan ket va gloar, bez' ez eus unan hag e glask, ha barn a ra. ");
INSERT INTO breBRG_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","E gwirionez, e gwirionez, me a lavar deoc'h: mar mir unan bennak va ger, ne welo biken ar marv. ");
INSERT INTO breBRG_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ar Yuzevien a lavaras dezhañ: Anavezout a reomp bremañ ez eus un diaoul ennout; Abraham a zo marv, hag ar brofeded ivez, ha te a lavar: Mar mir unan bennak va ger, ne welo biken ar marv. ");
INSERT INTO breBRG_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ha brasoc'h out eget Abraham hon tad, hag a zo marv? Ar brofeded ivez a zo marv. Da biv e fell dit en em dremen? ");
INSERT INTO breBRG_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jezuz a respontas dezho: Mar tennan gloar ac'hanon va-unan, va gloar n'eo netra; va Zad eo an hini a ro gloar din, an hini a lavarit eo ho Toue. ");
INSERT INTO breBRG_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Koulskoude, n'hoc'h eus ket e anavezet, met me a anavez anezhañ; ha ma lavarfen n'anavezan ket anezhañ, e vefen ur gaouiad eveldoc'h; met anavezout a ran anezhañ hag e viran e c'her. ");
INSERT INTO breBRG_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ho tad en deus tridet gant al levenez, o soñjal e tlee gwelout va deiz; hag e welet en deus, hag eo en em laouenaet. ");
INSERT INTO breBRG_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ar Yuzevien a lavaras dezhañ: Te ne'c'h eus ket c'hoazh hanter kant vloaz, hag ac'h eus gwelet Abraham? ");
INSERT INTO breBRG_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jezuz a lavaras dezho: E gwirionez, e gwirionez, me a lavar deoc'h, a-raok ma voe Abraham, emaon. ");
INSERT INTO breBRG_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Neuze e kemerjont mein evit o zeurel gantañ; met Jezuz en em guzhas hag a yeas er-maez eus an templ o tremen dre o c'hreiz, hag evel-se ez eas kuit. ");
INSERT INTO breBRG_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Evel ma oa Jezuz o tremen, e welas un den a oa dall abaoe e c'hanedigezh. ");
INSERT INTO breBRG_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E ziskibien a c'houlennas digantañ: Mestr, piv en deus pec'het, hemañ pe e gerent, dre ma'z eo ganet dall? ");
INSERT INTO breBRG_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jezuz a respontas: N'eo ket en defe hemañ pe e dud pec'het, met abalamour ma vefe oberoù Doue disklêriet ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","E-pad ma'z eo deiz, eo ret din kas da benn oberoù an hini en deus va c'haset; an noz a zeu, ha den ne c'hell labourat enni. ");
INSERT INTO breBRG_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","E-pad ma'z on er bed, ez on sklêrijenn ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","O vezañ lavaret kement-se, e krañchas d'an douar, hag e reas fank gant e halv; neuze e frotas daoulagad an dall gant ar fank-se, ");
INSERT INTO breBRG_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","hag e lavaras dezhañ: Kae, hag en em walc'h e stank Siloa (da lavarout eo: Kaset). Mont a reas di, en em walc'has, hag ez eas kuit o welout sklaer. ");
INSERT INTO breBRG_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","An amezeien hag ar re o devoa e welet a-raok, pa oa dall, a lavare: N'eo ket hemañ an hini en em zalc'he azezet, hag a c'houlenne an aluzen? ");
INSERT INTO breBRG_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Darn a lavare: Eñ eo; darn all a lavare: Heñvel eo outañ; eñ e-unan a lavare: Me va-unan eo. ");
INSERT INTO breBRG_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Int a lavaras eta dezhañ: Penaos eo bet digoret da zaoulagad dit? ");
INSERT INTO breBRG_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Eñ a respontas: Un den a c'halver Jezuz en deus graet fank, en deus eouliet gantañ va daoulagad, ha lavaret din: Kae da stank Siloa, hag en em walc'h enni. Me a zo eta aet, hag ez on en em walc'het, hag e welan. ");
INSERT INTO breBRG_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Int a lavaras dezhañ: Pelec'h emañ an den-se? Eñ a lavaras: N'ouzon ket. ");
INSERT INTO breBRG_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kas a rejont d'ar farizianed an hini a oa bet dall. ");
INSERT INTO breBRG_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Un deiz sabad e oa, p'en devoa Jezuz graet ar fank, ha p'en devoa digoret e zaoulagad dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ar farizianed a c'houlenne eta digantañ ivez penaos en devoa adkavet ar gweled. Eñ a lavaras dezho: Lakaet en deus fank din war va daoulagad, hag ez on en em walc'het hag e welan. ");
INSERT INTO breBRG_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Neuze hiniennoù eus ar farizianed a lavaras: An den-se n'eo ket a-berzh Doue, peogwir ne vir ket ar sabad. Reoù all a lavare: Penaos e c'hell un den fall ober hevelep mirakloù? Hag e oant dizunvan etrezo. ");
INSERT INTO breBRG_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lavarout a rejont a-nevez d'an dall: Ha te, petra a lavarez diwar e benn, p'en deus digoret dit da zaoulagad? Eñ a respontas: Ur profed eo. ");
INSERT INTO breBRG_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Met ar Yuzevien ne gredjont ket e oa bet an den-se dall, hag e oa digoret e zaoulagad dezhañ, ken ma lakajont gervel e dud. ");
INSERT INTO breBRG_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hag e c'houlennjont diganto, o lavarout: Hennezh eo ho mab, a lavarit eo bet ganet dall? Penaos eta e wel bremañ? ");
INSERT INTO breBRG_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","E dud a respontas: Ni a oar eo hor mab, hag eo bet ganet dall; ");
INSERT INTO breBRG_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","met n'ouzomp ket penaos e wel bremañ, ha n'ouzomp ket piv en deus digoret dezhañ e zaoulagad. Oad en deus, goulennit digantañ, komz a raio e-unan eus ar pezh a sell outañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","E dud a lavare kement-se, abalamour m'o devoa aon rak ar Yuzevien; ar Yuzevien o devoa lakaet en o fenn, penaos piv bennak a anavezje Jezuz evit ar C'hrist, a vije kaset kuit eus ar sinagogenn. ");
INSERT INTO breBRG_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Dre-se e dud a lavaras: Oad en deus, goulennit digantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gervel a rejont eta evit an eil wech an den a oa bet dall, hag e lavarjont dezhañ: Ro gloar da Zoue, ni a oar an den-se a zo ur pec'her. ");
INSERT INTO breBRG_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Eñ a respontas: N'ouzon ket hag-eñ eo ur pec'her; un dra a ouzon eo penaos e oan dall, ha penaos e welan bremañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Int a lavaras c'hoazh dezhañ: Petra en deus graet dit? Penaos en deus digoret da zaoulagad dit? ");
INSERT INTO breBRG_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Eñ a respontas dezho: E lavaret em eus dija deoc'h, ha n'hoc'h eus ket e selaouet? Perak e fell deoc'h e glevout a-nevez? C'hoantaat a rit ivez dont da vezañ e ziskibien? ");
INSERT INTO breBRG_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Neuze e tismegañsjont anezhañ hag e lavarjont: Te eo a zo e ziskibl, evidomp-ni, ni a zo diskibien Moizez. ");
INSERT INTO breBRG_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ni a oar en deus Doue komzet ouzh Moizez, met evit hemañ, n'ouzomp ket a-belec'h eo. ");
INSERT INTO breBRG_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","An den a respontas: Un dra souezhus eo, penaos n'ouzoc'h ket a-belec'h eo; ha koulskoude en deus digoret va daoulagad din! ");
INSERT INTO breBRG_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ha, ni a oar penaos Doue ne selaou ket ar re fall; met mar deu unan bennak da enoriñ Doue ha da ober e volontez, e selaou anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","N'eus bet klevet biskoazh en defe den digoret daoulagad un den ganet dall. ");
INSERT INTO breBRG_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma ne vije ket hemañ eus Doue, ne c'hellje ober netra. ");
INSERT INTO breBRG_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Int a respontas dezhañ: Te a zo bet ganet holl er pec'hed, hag e kelennez ac'hanomp! Hag e kasjont anezhañ kuit. ");
INSERT INTO breBRG_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jezuz a glevas penaos o devoa e gaset kuit, hag o vezañ en em gavet gantañ, e lavaras dezhañ: Ha krediñ a rez e Mab Doue? ");
INSERT INTO breBRG_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Eñ a respontas: Piv eo Aotrou, evit ma kredin ennañ? ");
INSERT INTO breBRG_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ha Jezuz a lavaras dezhañ: Gwelet ec'h eus anezhañ, eñ e-unan eo an hini a gomz ouzhit. ");
INSERT INTO breBRG_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Neuze e lavaras: Krediñ a ran, Aotrou, hag ec'h azeulas anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ha Jezuz a lavaras: Me a zo deuet er bed-mañ da varn, evit ma welo ar re na welont ket, ha ma teuio dall ar re a wel. ");
INSERT INTO breBRG_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hag hiniennoù eus ar farizianed a oa gantañ, o klevout kement-se, a lavaras dezhañ: Ha ni, bez' omp-ni ivez dall? ");
INSERT INTO breBRG_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jezuz a lavaras dezho: Ma vijec'h dall, n'ho pije ket a bec'hed; met bremañ e lavarit: Gwelout a reomp; abalamour da gement-se ho pec'hed a chom. ");
INSERT INTO breBRG_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","E gwirionez, e gwirionez, me a lavar deoc'h, an hini na da ket e kraou an deñved dre an nor, met a bign dre ul lec'h all, a zo ul laer hag ur brigant. ");
INSERT INTO breBRG_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Met an hini a ya dre an nor, eo mesaer an deñved. ");
INSERT INTO breBRG_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ar porzhier a zigor dezhañ an nor, hag an deñved a glev e vouezh; gervel a ra e zeñved e-unan dre o anv, hag e kas anezho er-maez. ");
INSERT INTO breBRG_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ha p'en deus lakaet er-maez e zeñved e-unan, e vale a-raok dezho, hag an deñved a heul anezhañ, abalamour ma'c'h anavezont e vouezh. ");
INSERT INTO breBRG_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Met ne heuilhint ket un diavaeziad, tec'hout a raint kentoc'h dre ma n'anavezont ket mouezh an diavaezidi. ");
INSERT INTO breBRG_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jezuz a lavaras dezho ar barabolenn-se, met ne gomprenjont ket ar pezh a lavare dezho. ");
INSERT INTO breBRG_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jezuz eta a lavaras dezho c'hoazh: E gwirionez, e gwirionez, me a lavar deoc'h, me eo dor an deñved. ");
INSERT INTO breBRG_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","An holl re a zo deuet a-raok din a zo laeron ha briganted, met an deñved n'o deus ket o selaouet. ");
INSERT INTO breBRG_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me eo an nor; mar deu unan bennak e-barzh drezon, e vo salvet; dont ha mont a raio hag e kavo peurvan. ");
INSERT INTO breBRG_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Al laer ne zeu nemet evit laerezh, lazhañ ha distrujañ; met me a zo deuet evit m'o devo va deñved ar vuhez ha ma vint er fonnuster. ");
INSERT INTO breBRG_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Me eo ar mesaer mat; ar mesaer mat a ro e vuhez evit e zeñved. ");
INSERT INTO breBRG_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Met an devezhour n'eo ket ar mesaer, hag an deñved n'int ket dezhañ; pa wel ar bleiz o tont, e tilez an deñved hag e tec'h; ar bleiz a grog en deñved hag a stlabez anezho. ");
INSERT INTO breBRG_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","An devezhour a dec'h, abalamour ma'z eo devezhour, ha ne gemer ket preder eus an deñved. ");
INSERT INTO breBRG_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Me eo ar mesaer mat, me a anavez va deñved, hag anavezet on ganto, ");
INSERT INTO breBRG_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","evel ma'c'h anavez va Zad ac'hanon, hag evel ma'c'h anavezan va Zad; ha reiñ a ran va buhez evit va deñved. ");
INSERT INTO breBRG_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Deñved all am eus ha n'int ket eus an tropell-mañ; ret eo din ivez degas anezho; hag e klevint va mouezh, ha ne vo nemet ur bagad, hag ur mesaer hepken. ");
INSERT INTO breBRG_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Dre-se eo e kar va Zad ac'hanon, abalamour ma roan va buhez evit he adkemer. ");
INSERT INTO breBRG_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Den ne lam anezhi diganin, me a ro anezhi ac'hanon va-unan; ar galloud am eus d'he c'huitaat, hag ar galloud d'he adkemer; an urzh-se am eus bet digant va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Neuze e voe dizunvaniezh adarre etre ar Yuzevien, abalamour d'ar gerioù-se. ");
INSERT INTO breBRG_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kalz anezho a lavare: Un diaoul en deus, diskiantet eo; perak e selaouit anezhañ? ");
INSERT INTO breBRG_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Re all a lavare: Ar gerioù-se n'int ket eus un den dalc'het gant un diaoul. Hag un diaoul a c'hell digeriñ daoulagad ar re dall? ");
INSERT INTO breBRG_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bez' e oa e Jeruzalem gouel an Dedi, hag ar goañv a oa. ");
INSERT INTO breBRG_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Evel ma valee Jezuz en templ, e porched Salomon, ");
INSERT INTO breBRG_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ar Yuzevien en em zastumas eta en-dro dezhañ, hag a lavaras dezhañ: Betek pegeit e talc'hi hor spered en douetañs? Mar dout ar C'hrist, lavar eñ deomp freals. ");
INSERT INTO breBRG_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jezuz a respontas dezho: E lavaret em eus deoc'h, ha ne gredit ket; an oberoù a ran e anv va Zad a ro testeni ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Met c'hwi ne gredit ket abalamour n'oc'h ket eus va deñved, evel ma em eus e lavaret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Va deñved a glev va mouezh, ha me a anavez anezho, hag int a heul ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me a ro dezho ar vuhez peurbadus; ne vint kollet biken, ha den n'o lamo eus va dorn. ");
INSERT INTO breBRG_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Va Zad en deus o roet din, ha brasoc'h eo eget an holl; den ne c'hell o lemel eus dorn va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me hag an Tad a zo unan. ");
INSERT INTO breBRG_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Neuze ar Yuzevien a gemeras a-nevez mein evit e veinata. ");
INSERT INTO breBRG_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ha Jezuz a lavaras dezho: Graet em eus dirazoc'h kalz a oberoù mat, a-berzh va Zad; evit pehini anezho e veinatait ac'hanon? ");
INSERT INTO breBRG_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ar Yuzevien a respontas dezhañ: N'eo ket evit un ober mat e veinataomp ac'hanout, met abalamour d'ur gwallgomz, dre ma n'out nemet un den hag en em rez Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jezuz a respontas dezho: N'eo ket skrivet en ho lezenn: Lavaret em eus: C'hwi a zo doueed? ");
INSERT INTO breBRG_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mar he deus eta galvet doueed ar re ma oa ger Doue kaset dezho (hag ar Skritur ne c'hell ket bezañ torret), ");
INSERT INTO breBRG_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","lavarout a rit-hu e wallgomzan, me an hini en deus an Tad santelaet ha kaset er bed, abalamour ma em eus lavaret: Me eo Mab Doue? ");
INSERT INTO breBRG_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ma ne ran ket oberoù va Zad, na gredit ket ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Met mar o gran, ha pa ne gredfec'h ket ac'hanon, kredit da'm oberoù, evit ma'c'h anavezot ha ma kredot an Tad a zo ennon, hag ez on ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Klask a raent eta c'hoazh kregiñ ennañ, met en em dennañ a reas eus o daouarn. ");
INSERT INTO breBRG_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mont a reas a-nevez en tu all d'ar Jordan, e-lec'h ma oa Yann o vadeziñ da gentañ, hag e chomas eno. ");
INSERT INTO breBRG_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kalz a dud a zeuas d'e gavout, hag e lavarent: Yann, evit gwir, n'en deus graet mirakl ebet; met kement-holl en deus Yann lavaret eus an den-mañ a zo gwir. ");
INSERT INTO breBRG_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ha kalz a gredas ennañ el lec'h-se. ");
INSERT INTO breBRG_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bez' e oa ur c'hlañvour, anvet Lazar, eus Betania, kêriadenn Mari ha Marta he c'hoar. ");
INSERT INTO breBRG_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari a oa an hini a eoulias an Aotrou a c'hwez-vat, hag a dorchas e dreid gant he blev; ha Lazar, he breur, a oa klañv. ");
INSERT INTO breBRG_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ar c'hoarezed eta a gasas da lavarout da Jezuz: Aotrou, an hini a garez a zo klañv. ");
INSERT INTO breBRG_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jezuz, o vezañ klevet kement-se, a lavaras: Ar c'hleñved-se n'eo ket d'ar marv, met evit gloar Doue eo, evit ma vo roet gloar da Vab Doue a gement-se. ");
INSERT INTO breBRG_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jezuz a gare Marta, hag he c'hoar, ha Lazar. ");
INSERT INTO breBRG_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Koulskoude, p'en devoa klevet penaos e oa klañv, e chomas daou zevezh c'hoazh el lec'h ma oa. ");
INSERT INTO breBRG_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Neuze e lavaras d'e ziskibien: Distroomp e Judea. ");
INSERT INTO breBRG_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","An diskibien a lavaras dezhañ: Mestr, ar Yuzevien a glaske, n'eus ket pell, da veinata, hag e tistroez a-nevez di! ");
INSERT INTO breBRG_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jezuz a respontas dezho: Ha n'eus ket daouzek eur en deiz? Mar bale unan bennak e-pad an deiz, ne gouezh ket, abalamour ma wel sklêrijenn ar bed-mañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Met mar bale unan bennak e-pad an noz, e kouezh, abalamour n'eus ket a sklêrijenn ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Komz a reas evel-se, ha goude e lavaras dezho: Lazar, hor mignon, a gousk; met me a ya d'e zihuniñ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E ziskibien a lavaras dezhañ: Aotrou, mar kousk, e vo yac'haet. ");
INSERT INTO breBRG_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Met Jezuz en devoa komzet eus marv Lazar; hag int a grede e komze eus diskuizh ar c'housked. ");
INSERT INTO breBRG_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Neuze Jezuz a lavaras dezho freals: Lazar a zo marv. ");
INSERT INTO breBRG_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hag ez eus joa ganin abalamour deoc'h, dre ne oan ket eno evit ma kredot; met deomp d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaz, galvet Didim, a lavaras d'an diskibien all: Deomp, ni ivez, evit mervel gant Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jezuz, o vezañ erruet, a gavas Lazar er bez abaoe dija pevar devezh. ");
INSERT INTO breBRG_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania a oa war-dro pemzek stadenn eus Jeruzalem, ");
INSERT INTO breBRG_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ha kalz eus ar Yuzevien a oa deuet da-gichen Marta ha Mari, evit o frealziñ diwar-benn o breur. ");
INSERT INTO breBRG_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pa ouezas Marta e teue Jezuz, ez eas a-raok dezhañ; met Mari a chomas azezet er gêr. ");
INSERT INTO breBRG_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ha Marta a lavaras da Jezuz: Aotrou, ma vijes bet amañ, va breur ne vije ket marvet. ");
INSERT INTO breBRG_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Met anavezout a ran penaos bremañ memes, holl gement a c'houlenni digant Doue, Doue en roio dit. ");
INSERT INTO breBRG_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jezuz a lavaras dezhi: Da vreur a adsavo a varv. ");
INSERT INTO breBRG_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta a respontas dezhañ: Gouzout a ran ec'h adsavo da vev da adsavidigezh an deiz diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jezuz a lavaras dezhi: Me eo an adsavidigezh hag ar vuhez; an hini a gred ennon a vevo, memes ha pa vefe marv. ");
INSERT INTO breBRG_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ha piv bennak a vev hag a gred ennon, ne varvo biken. Ha krediñ a rez kement-se? ");
INSERT INTO breBRG_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hi a lavaras dezhañ: Ya, Aotrou, me a gred out ar C'hrist, Mab Doue, an hini a zlee dont er bed. ");
INSERT INTO breBRG_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","P'he devoe lavaret kement-se, ez eas hag e c'halvas Mari, he c'hoar, e-kuzh, hag e lavaras dezhi: Ar Mestr a zo amañ, hag e c'halv ac'hanout. ");
INSERT INTO breBRG_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Houmañ, o vezañ klevet anezhi, a savas buan, hag a zeuas d'e gavout. ");
INSERT INTO breBRG_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jezuz ne oa ket c'hoazh aet er bourc'h, bez' e oa el lec'h ma oa deuet Marta a-raok dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuzevien a oa gant Mari en ti, ouzh he frealziñ; pa weljont e oa savet ken buan, hag e oa aet er-maez, e heuilhjont anezhi, o lavarout: Mont a ra da ouelañ d'ar bez. ");
INSERT INTO breBRG_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pa voe deuet Mari el lec'h ma oa Jezuz, ha pa welas anezhañ, en em daolas d'e dreid, hag e lavaras dezhañ: Aotrou, ma vijes bet amañ, va breur ne vije ket marvet. ");
INSERT INTO breBRG_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pa welas Jezuz anezhi o ouelañ, ha penaos e ouele ivez ar Yuzevien a oa deuet ganti, e huanadas en e spered hag e voe trubuilhet; ");
INSERT INTO breBRG_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","neuze e lavaras: Pelec'h hoc'h eus e lakaet? Int a lavaras dezhañ: Aotrou, deus ha gwel. ");
INSERT INTO breBRG_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jezuz en em lakaas da ouelañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","War gement-se ar Yuzevien a lavaras: Gwelit penaos e kare anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Met hiniennoù anezho a lavaras: Eñ, an hini en deus digoret daoulagad an dall, ha ne c'hellje ket ober ivez na varvje ket hemañ? ");
INSERT INTO breBRG_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Neuze Jezuz, o huanadiñ a-nevez ennañ e-unan, a zeuas d'ar bez: ur c'hev e oa, hag ur maen a oa lakaet warnañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jezuz a lavaras: Lamit ar maen. Marta, c'hoar an hini marv, a lavaras dezhañ: Aotrou, c'hwez fall a zo dija gantañ, rak aze emañ abaoe pevar deiz zo. ");
INSERT INTO breBRG_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jezuz a lavaras dezhi: Ne'm eus ket lavaret dit penaos, mar kredez, e weli gloar Doue? ");
INSERT INTO breBRG_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lemel a rejont eta ar maen eus al lec'h ma oa gourvezet an hini marv. Ha Jezuz, o sevel e zaoulagad war-zu an neñv, a lavaras: Tad, da drugarekaat a ran eus ma ec'h eus va selaouet. ");
INSERT INTO breBRG_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gouzout a raen e selaouez ac'hanon atav, met e lavaret em eus abalamour d'ar bobl-mañ a zo en-dro din, evit ma kredo ec'h eus va degaset. ");
INSERT INTO breBRG_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","P'en devoe lavaret kement-se, e krias a vouezh uhel: Lazar, deus er-maez! ");
INSERT INTO breBRG_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hag an hini marv a zeuas er-maez, e zaouarn hag e dreid ereet gant bandennoù, hag e zremm goloet gant ul lienenn. Jezuz a lavaras dezho: Diereit anezhañ, ha lezit eñ da vont. ");
INSERT INTO breBRG_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kalz eta a-douez ar Yuzevien a oa deuet da welout Mari, hag o devoa gwelet ar pezh en devoa Jezuz graet, a gredas ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Met hiniennoù anezho a yeas da gavout ar farizianed, hag a lavaras dezho ar pezh en devoa Jezuz graet. ");
INSERT INTO breBRG_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Neuze ar veleien vras hag ar farizianed a zastumas ar sanedrin, hag a lavaras: Petra a raimp? Rak an den-se a ra kalz a virakloù. ");
INSERT INTO breBRG_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mar en lezomp d'ober, an holl a gredo ennañ, hag ar Romaned a zeuio, hag a zistrujo al lec'h-mañ hag hor pobl. ");
INSERT INTO breBRG_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Met Kaifaz, unan anezho, hag a oa beleg-meur er bloavezh-se, a lavaras dezho: C'hwi n'ouzoc'h netra; ");
INSERT INTO breBRG_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ha ne soñjit ket eo gwelloc'h da un den hepken mervel evit ar bobl, eget na vefe kollet holl dud ar vro? ");
INSERT INTO breBRG_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hogen ne lavare ket kement-se anezhañ e-unan, met o vezañ beleg-meur er bloaz-se, e tiouganas penaos e tlee Jezuz mervel evit ar bobl; ");
INSERT INTO breBRG_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ha n'eo ket hepken evit ar bobl, met ivez evit dastum en ur c'horf hepken bugale Doue a zo a-stlabez. ");
INSERT INTO breBRG_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Adalek an deiz-se en em guzuilhjont evit e lakaat d'ar marv. ");
INSERT INTO breBRG_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dre-se Jezuz n'en em ziskoueze ket en un doare frank e-touez ar Yuzevien, met mont a reas ac'hane en ur vro tost d'al lec'h distro, d'ur gêr galvet Efraim; hag e chomas eno gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pask ar Yuzevien a oa tost, ha kalz a dud eus ar vro a bigne da Jeruzalem a-raok ar Pask, evit en em c'hlanaat. ");
INSERT INTO breBRG_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Klask a raent eta Jezuz, hag, oc'h en em zerc'hel en templ, e lavarent an eil d'egile: Petra a soñjit? Ne zeuio ket d'ar gouel? ");
INSERT INTO breBRG_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Met ar veleien vras hag ar farizianed o devoa roet urzh, penaos ma ouije unan bennak pelec'h e oa, ra en diskuilhje, evit ma krogjed ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","C'hwec'h devezh a-raok ar Pask, Jezuz a zeuas da Vetania, e-lec'h ma oa Lazar, an hini a oa bet marv hag en devoa adsavet a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Graet e voe dezhañ eno ur goan, Marta a servije, ha Lazar a oa unan eus ar re a oa ouzh taol gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Neuze Mari, o vezañ kemeret ul lur c'hwezh-vat a nard pur, eus ur priz bras, a eoulias ganti treid Jezuz, hag o zorchas gant e blev; an ti a voe leuniet gant c'hwezh an traet-se. ");
INSERT INTO breBRG_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Neuze Judaz Iskariod, mab Simon, unan eus an diskibien, an hini a dlee e werzhañ, a lavaras: ");
INSERT INTO breBRG_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Perak n'eo ket bet gwerzhet ar c'hwezh-vat-se tri c'hant diner, evit o reiñ d'ar beorien? ");
INSERT INTO breBRG_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Lavarout a rae kement-se, n'eo ket m'en dije preder ouzh ar beorien, met abalamour ma oa laer, hag o vezañ ma oa gantañ ar yalc'h, e kemere ar pezh a lakaed enni. ");
INSERT INTO breBRG_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jezuz a lavaras eta dezhañ: Lez anezhi d'ober; miret he deus ar c'hwezh-vat-se evit deiz va beziadur. ");
INSERT INTO breBRG_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Rak c'hwi ho po bepred ar beorien ganeoc'h, met n'ho po ket atav ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Neuze ur vandenn vras a Yuzevien, o vezañ gouezet e oa Jezuz eno, a zeuas di, n'eo ket hepken abalamour da Jezuz, met ivez evit gwelout Lazar, an hini en devoa adsavet a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hag ar veleien vras en em guzulias da lakaat ivez Lazar d'ar marv, ");
INSERT INTO breBRG_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","rak kalz eus ar Yuzevien, abalamour dezhañ, a yae hag a grede e Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","An deiz war-lerc'h, ul lod bras a dud deuet evit ar gouel, o klevout e oa deuet Jezuz e Jeruzalem, ");
INSERT INTO breBRG_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","a gemeras brankoù palmez, hag a yeas a-raok dezhañ, o krial: Hozanna! Benniget ra vo roue Israel, an hini a zeu en anv an Aotrou! ");
INSERT INTO breBRG_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ha Jezuz, o vezañ kavet un azenig, a bignas warnañ eno, hervez ma'z eo skrivet: ");
INSERT INTO breBRG_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Na'z pez ket aon, merc'h Sion: setu, da roue a zeu, pignet war ebeul un azenez. ");
INSERT INTO breBRG_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","E ziskibien ne gomprenjont ket da gentañ kement-se; met pa voe roet gloar da Jezuz, neuze e teuas da soñj dezho penaos e oa bet skrivet an traoù-se diwar e benn, hag e oant bet c'hoarvezet gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ar vandenn a oa gantañ p'en devoa galvet Lazar eus ar bez, ha p'en devoa e adsavet a-douez ar re varv, a roe testeni dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hag abalamour ivez m'en devoa anavezet ar bobl penaos en devoa graet ar mirakl-se eo, e oant aet a-raok dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ar farizianed a lavaras eta etrezo: Gwelout a rit na c'hounezit netra; setu, an holl dud a ya war e lerc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Met, bez' e oa un toullad Gresianed e-touez ar re a oa pignet evit azeuliñ e-pad ar gouel. ");
INSERT INTO breBRG_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dont a rejont da gavout Filip eus Betsaida e Galilea; hag, o pediñ anezhañ, e lavarjont dezhañ: Aotrou, ni a garfe gwelout Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip a zeuas hag a lavaras da Andrev, hag Andrev ha Filip en lavaras da Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ha Jezuz a respontas dezho: An eur a zo deuet ma tle Mab an den resev gloar. ");
INSERT INTO breBRG_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","E gwirionez, e gwirionez, me a lavar deoc'h: ma ne varv ket ar c'hreunenn winizh goude ma vez taolet en douar, e chom hec'h-unan; met mar marv, e toug kalz a frouezh. ");
INSERT INTO breBRG_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","An hini a gar e vuhez he c'hollo, hag an hini a gasa e vuhez er bed-mañ he miro evit ar vuhez peurbadus. ");
INSERT INTO breBRG_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mar servij unan bennak ac'hanon, ra zeuio war va lerc'h; hag e-lec'h ma vin, eno e vo ivez va servijer; ha mar servij unan bennak ac'hanon, an Tad a enoro anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Bremañ va ene a zo trubuilhet; ha petra a lavarin? Tad, savete ac'hanon eus an eur-mañ! Met evit kement-se on deuet en eur-mañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tad, ro gloar da'z anv. Neuze e teuas ur vouezh eus an neñv, hag a lavaras: Roet em eus gloar dezhañ, hag e roin gloar dezhañ c'hoazh. ");
INSERT INTO breBRG_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ar bobl a oa eno, hag o devoa klevet, a lavare e oa ar c'hurun; re all a lavare: Un ael en deus komzet outañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jezuz a gemeras ar gomz hag a lavaras dezho: Ar vouezh-se n'eo ket evidon-me, met evidoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bremañ en em ra barnedigezh ar bed-mañ; bremañ priñs ar bed-mañ a vo taolet er-maez. ");
INSERT INTO breBRG_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ha me, pa vin bet savet eus an douar, a denno an holl dud da'm c'havout. ");
INSERT INTO breBRG_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Met, lavarout a rae kement-se evit merkañ dre beseurt marv e tlee mervel. ");
INSERT INTO breBRG_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ar bobl a respontas dezhañ: Desket hon eus dre al lezenn e tle ar C'hrist chom da viken; penaos eta e lavarez eo ret da Vab an den bezañ savet? Piv eo ar Mab an den-se? ");
INSERT INTO breBRG_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jezuz a lavaras dezho: Ar sklêrijenn a zo c'hoazh ganeoc'h evit un nebeut amzer. Kerzhit e-pad m'hoc'h eus ar sklêrijenn, gant aon na zeufe an deñvalijenn d'ho soupren; rak an hini a gerzh en deñvalijenn ne oar ket pelec'h ez a. ");
INSERT INTO breBRG_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","E-pad m'hoc'h eus ar sklêrijenn, kredit er sklêrijenn evit ma viot bugale ar sklêrijenn. Jezuz a lavaras an traoù-se, ha goude ez eas hag en em guzhas diouto. ");
INSERT INTO breBRG_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hag evitañ da vezañ graet kement a virakloù dirazo, ne gredjont ket ennañ, ");
INSERT INTO breBRG_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","abalamour d'ar ger en devoa ar profed Izaia lavaret da vezañ peurc'hraet: Aotrou, piv en deus kredet d'hor prezegenn? Ha da biv eo bet disklêriet brec'h an Aotrou? ");
INSERT INTO breBRG_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Dre-se, ne c'hellent ket krediñ, rak Izaia en deus lavaret c'hoazh: ");
INSERT INTO breBRG_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dallet en deus o daoulagad ha kaletaet o c'halon, gant aon na welfent gant o daoulagad, ha na gomprenfent gant o c'halon, ha na zistrofent ouzh Doue, ha na yac'hafen anezho. ");
INSERT INTO breBRG_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Izaia a lavaras an traoù-mañ, pa welas e c'hloar, ha pa gomzas anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Koulskoude kalz, memes eus ar re vras, a gredas ennañ; met n'anzavent ket kement-se abalamour d'ar farizianed, gant aon da vezañ kaset kuit eus ar sinagogenn. ");
INSERT INTO breBRG_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rak karout a raent muioc'h ar gloar a zeu eus an dud, eget gloar Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Met Jezuz a grias hag a lavaras: An hini a gred ennon, ne gred ket ennon, met en hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hag an hini a wel ac'hanon, a wel an hini an deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me a zo deuet er bed evel sklêrijenn, evit na chomo ket en deñvalijenn an neb a gred ennon. ");
INSERT INTO breBRG_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ha mar klev unan bennak va gerioù ha ne gred ket ennon, ne varnan ket anezhañ, rak n'on ket deuet evit barn ar bed, met evit e saveteiñ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","An hini na'm degemer ket ha na zegemer ket va gerioù en deus e varner; ar ger am eus prezeget eo, a varno anezhañ en deiz diwezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Rak n'eo ket ac'hanon va-unan em eus komzet, met an Tad en deus va c'haset, en deus gourc'hemennet din ar pezh a dleen lavarout ha prezeg. ");
INSERT INTO breBRG_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hag anavezout a ran penaos e c'hourc'hemenn eo ar vuhez peurbadus. An traoù a lavaran eta, a lavaran evel m'en deus an Tad o lavaret din. ");
INSERT INTO breBRG_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A-raok gouel ar Pask, Jezuz, oc'h anavezout e oa deuet e eur evit tremen eus ar bed-mañ d'an Tad, evel m'en devoa karet e re a oa er bed, o c'haras betek ar fin. ");
INSERT INTO breBRG_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ha da goulz koan (an diaoul o vezañ lakaet e kalon Judaz Iskariod, mab Simon, e werzhañ), ");
INSERT INTO breBRG_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jezuz, oc'h anavezout en devoa an Tad lakaet pep tra etre e zaouarn, hag e oa deuet eus Doue, hag e tistroe da Zoue, ");
INSERT INTO breBRG_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","a savas diouzh koan, a lamas e vantell, hag o vezañ kemeret ul lienenn, en em c'hourizas ganti. ");
INSERT INTO breBRG_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Goude-se e lakaas dour en ur billig, hag en em lakaas da walc'hiñ treid e ziskibien, ha d'o zorchañ gant al lienenn a oa en-dro dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dont a reas eta da Simon-Pêr, hag hemañ a lavaras dezhañ: Te, Aotrou, te a walc'hfe din va zreid! ");
INSERT INTO breBRG_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jezuz a respontas hag a lavaras dezhañ: Te n'ouzout ket bremañ ar pezh a ran; met e c'houzout a ri diwezhatoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pêr a lavaras dezhañ: Biken ne walc'hi din va zreid. Jezuz a respontas dezhañ: Ma ne walc'han ket ac'hanout, ne'z po ket a lod ganin. ");
INSERT INTO breBRG_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Neuze Simon-Pêr a lavaras dezhañ: Aotrou, nann hepken va zreid, met ivez va daouarn ha va fenn. ");
INSERT INTO breBRG_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jezuz a lavaras dezhañ: An hini a zo bet gwalc'het en deus ezhomm e vefe gwalc'het dezhañ e zreid hepken, hag emañ glan penn-da- benn. Ha c'hwi a zo glan, met n'oc'h ket holl. ");
INSERT INTO breBRG_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Rak gouzout a rae piv oa an hini a werzhje anezhañ; abalamour da-se e lavaras: C'hwi n'oc'h ket glan holl. ");
INSERT INTO breBRG_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Goude eta m'en devoa gwalc'het dezho o zreid, ha m'en devoa adkemeret e vantell, o vezañ en em lakaet ouzh taol, e lavaras dezho: Ha gouzout a rit ar pezh am eus graet deoc'h?. ");
INSERT INTO breBRG_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Va c'hervel a rit Mestr hag Aotrou, ha gwir a lavarit, rak bez' ez on. ");
INSERT INTO breBRG_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mar em eus eta gwalc'het deoc'h ho treid, me an Aotrou hag ar Mestr, c'hwi a dle ivez gwalc'hiñ ho treid an eil d'egile. ");
INSERT INTO breBRG_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Rak roet em eus deoc'h ur skouer, abalamour ma reot evel ma em eus graet deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","E gwirionez, e gwirionez, me a lavar deoc'h, ar servijer n'eo ket brasoc'h eget e vestr, nag an hini kaset brasoc'h eget an hini en deus e gaset. ");
INSERT INTO breBRG_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mar gouzoc'h an traoù-se, ez oc'h eürus, mar sentit outo. ");
INSERT INTO breBRG_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ne gomzan ket ac'hanoc'h holl; gouzout a ran ar re am eus choazet. Met ret eo d'ar Skritur bezañ peurc'hraet: An hini a zebr bara ganin en deus savet e droad em enep. ");
INSERT INTO breBRG_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Me en lavar deoc'h adalek bremañ, a-raok ma'c'h erruo an dra, abalamour, pa vo erruet, e kredot ar pezh emaon. ");
INSERT INTO breBRG_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","E gwirionez, e gwirionez, me a lavar deoc'h: an hini a zegemer an hini am bo kaset, a zegemer ac'hanon; hag an hini a zegemer ac'hanon, a zegemer an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","P'en devoe Jezuz lavaret kement-se, e voe poaniet en e spered, hag e roas an testeni-mañ: E gwirionez, e gwirionez, me a lavar deoc'h, unan ac'hanoc'h am gwerzho. ");
INSERT INTO breBRG_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hag an diskibien a selle an eil ouzh egile, o vezañ ne ouient ket a biv eo e komze. ");
INSERT INTO breBRG_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Met, unan anezho, an hini a oa karet gant Jezuz, a oa kousket ouzh taol war-zu askre Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon-Pêr a reas sin dezhañ da c'houlenn eus piv e komze. ");
INSERT INTO breBRG_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eñ, o vezañ pleget a-us kerc'henn Jezuz, a lavaras dezhañ: Aotrou! Piv eo? ");
INSERT INTO breBRG_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jezuz a respontas: An hini a roin dezhañ un tamm soubet. Hag, o vezañ soubet un tamm, e roas anezhañ da Judaz Iskariod, mab Simon. ");
INSERT INTO breBRG_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ha goude m'en devoe Judaz kemeret an tamm, Satan a yeas ennañ. Jezuz a lavaras dezhañ: Gra raktal ar pezh ac'h eus d'ober. ");
INSERT INTO breBRG_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Met hini ebet eus ar re a oa ouzh taol ne gomprenas perak en devoa lavaret kement-se dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Rak hiniennoù a soñje penaos, evel ma oa ar yalc'h gant Judaz, en devoa Jezuz lavaret dezhañ: Pren ar pezh hon eus ezhomm evit ar gouel; pe, ro un dra bennak d'ar beorien. ");
INSERT INTO breBRG_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","O vezañ eta kemeret an tamm, Judaz a yeas kuit raktal. Noz e oa. ");
INSERT INTO breBRG_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pa voe aet kuit, Jezuz a lavaras: Bremañ, roet eo bet gloar da Vab an den, ha roet eo bet gloar da Zoue ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mar deo bet roet gloar da Zoue ennañ, Doue a roio gloar dezhañ ivez ennañ e-unan, hag e roio gloar dezhañ prest. ");
INSERT INTO breBRG_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Va bugale vihan, me a zo c'hoazh ganeoc'h evit un nebeut amzer. C'hwi am c'hlasko, hag, evel ma em eus lavaret d'ar Yuzevien, me en lavar deoc'h-hu ivez bremañ: E-lec'h ma'z an, ne c'hellit ket dont. ");
INSERT INTO breBRG_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Reiñ a ran deoc'h ur gourc'hemenn nevez: Ma en em garot an eil egile; evel ma em eus ho karet, ma en em garot ivez an eil egile. ");
INSERT INTO breBRG_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Eus kement-mañ ec'h anavezo an holl penaos oc'h va diskibien, ma hoc'h eus karantez an eil evit egile. ");
INSERT INTO breBRG_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon-Pêr a lavaras dezhañ: Aotrou, da belec'h ez ez-te? Jezuz a lavaras dezhañ: E-lec'h ma'z an, ne c'hellez ket va heuliañ bremañ; met te am heulio diwezhatoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pêr a lavaras dezhañ: Aotrou, perak ne c'hellan ket da heuliañ bremañ? Me a rofe va buhez evidout-te. ");
INSERT INTO breBRG_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jezuz a respontas dezhañ: Te a rofe da vuhez evidon-me! E gwirionez, e gwirionez, me a lavar dit, ne gano ket ar c'hilhog, na'z po va dinac'het teir gwech. ");
INSERT INTO breBRG_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na vezent ket trubuilhet ho kalonoù. Kredit e Doue, kredit ivez ennon. ");
INSERT INTO breBRG_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bez' ez eus meur a chomaj e ti va Zad; ma ne vije ket, me am bije e lavaret deoc'h. Mont a ran da gempenn ul lec'h deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ha pa vin aet, ha pa em bo kempennet ul lec'h deoc'h, e tistroin hag ho kemerin ganin, evit ma viot c'hwi ivez el lec'h m'emaon. ");
INSERT INTO breBRG_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ha c'hwi a oar pelec'h ez an, hag ec'h ouzoc'h an hent. ");
INSERT INTO breBRG_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaz a lavaras dezhañ: Aotrou, n'ouzomp ket pelec'h ez ez; ha penaos e c'hellfemp anavezout an hent? ");
INSERT INTO breBRG_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jezuz a lavaras dezhañ: Me eo an hent, ar wirionez hag ar vuhez; den ne zeu d'an Tad, nemet drezon. ");
INSERT INTO breBRG_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mar ho pije va anavezet, ho pije anavezet va Zad; hag a-vremañ ec'h anavezit anezhañ, hag hoc'h eus e welet. ");
INSERT INTO breBRG_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip a lavaras dezhañ: Aotrou, diskouez deomp an Tad, hag eo a-walc'h deomp. ");
INSERT INTO breBRG_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jezuz a lavaras dezhañ: Keit all a zo abaoe ma'z on ganeoc'h, ha te ne'c'h eus ket va anavezet! Filip, an hini en deus va gwelet, en deus gwelet an Tad. Penaos eta e lavarez: Diskouez deomp an Tad? ");
INSERT INTO breBRG_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ha ne gredez ket on-me en Tad, hag emañ an Tad ennon? Ar gerioù a lavaran deoc'h, n'o lavaran ket ac'hanon va-unan; met an Tad a chom ennon, a ra e-unan an oberoù a ran. ");
INSERT INTO breBRG_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kredit ac'hanon pa lavaran ez on en Tad, hag emañ an Tad ennon; pe kredit ac'hanon da vihanañ abalamour d'an oberoù-se memes. ");
INSERT INTO breBRG_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","E gwirionez, e gwirionez, me a lavar deoc'h: An hini a gred ennon a raio ivez an oberoù a ran, hag e raio reoù vrasoc'h c'hoazh eget ar re-mañ, abalamour ma'z an da gavout va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ha kement a c'houlennot em anv, me a raio anezhañ, evit ma vo roet gloar d'an Tad er Mab. ");
INSERT INTO breBRG_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mar goulennit un dra bennak em anv, me a raio anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mar karit ac'hanon, mirit va gourc'hemennoù. ");
INSERT INTO breBRG_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ha me a bedo an Tad, hag eñ a roio deoc'h ur Frealzer all, evit chom da viken ganeoc'h, ");
INSERT INTO breBRG_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ar Spered a wirionez, na c'hell ket ar bed degemer anezhañ, dre na wel ket anezhañ, ha n'anavez ket anezhañ; met c'hwi a anavez anezhañ, abalamour ma chom ganeoc'h, ha ma vo ennoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne lezin ket ac'hanoc'h emzivaded; dont a rin d'ho kavout. ");
INSERT INTO breBRG_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","C'hoazh un nebeut amzer, hag ar bed ne'm gwelo ken, met c'hwi am gwelo, abalamour ma vevan, ha ma vevot ivez. ");
INSERT INTO breBRG_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","En deiz-se, ec'h anavezot emaon em Zad, ha c'hwi ennon, ha me ennoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","An hini en deus va gourc'hemennoù, hag a vir anezho, hennezh eo an hini a gar ac'hanon; hag an hini a gar ac'hanon, a vo karet gant va Zad, ha me en karo hag en em roin da anavezout dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judaz, neket an Iskariod, a lavaras dezhañ: Aotrou! A-belec'h e teu ma en em roi da anavezout deomp, ha nann d'ar bed? ");
INSERT INTO breBRG_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jezuz a respontas dezhañ: Mar kar unan bennak ac'hanon, e viro va ger, ha va Zad a garo anezhañ, hag e teuimp d'e gavout, hag e raimp hor chomaj gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","An hini na gar ket ac'hanon, ne vir ket va gerioù; hag ar ger hoc'h eus klevet n'eo ket ac'hanon-me, met eus an Tad en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Lavarout a ran deoc'h an traoù-mañ e-pad ma choman ganeoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Met ar Frealzer, ar Spered-Santel a gaso an Tad em anv, a gelenno deoc'h an holl draoù, hag a zegaso soñj deoc'h e kement am eus lavaret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lezel a ran ganeoc'h ar peoc'h; reiñ a ran deoc'h va feoc'h; ne roan ket anezhi deoc'h evel ma ro ar bed. Na vezet ket ho kalon nec'het, na spontet. ");
INSERT INTO breBRG_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Klevet hoc'h eus em eus lavaret deoc'h: Mont a ran kuit, hag e tistroan davedoc'h. Mar karjec'h ac'hanon, ho pije levenez eus ar pezh am eus lavaret: Mont a ran da gavout an Tad; rak va Zad a zo brasoc'h egedon. ");
INSERT INTO breBRG_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ha me am eus e lavaret deoc'h bremañ, a-raok ma erruo an dra, evit pa vo erruet, e kredot. ");
INSERT INTO breBRG_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ne gomzin ken kalz ganeoc'h, rak priñs ar bed-mañ a zeu; ha n'en deus netra ennon. ");
INSERT INTO breBRG_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Met evit ma'c'h anavezo ar bed penaos e karan va Zad, ha penaos e ran ar pezh en deus an Tad gourc'hemennet din, savit ha deomp ac'hann. ");
INSERT INTO breBRG_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Me eo ar wir winienn, ha va Zad eo ar gwinier. ");
INSERT INTO breBRG_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lemel a ra ac'hanon kement brank na zoug ket a frouezh; hag e tivarr kement brank a zoug frouezh, evit ma tougo c'hoazh muioc'h a frouezh. ");
INSERT INTO breBRG_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Dija oc'h-hu glan, abalamour d'ar gomz am eus lavaret deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chomit ennon, hag e chomin ennoc'h. Evel na c'hell ket ar brank dougen frouezh anezhañ e-unan, ma ne chom stag ouzh ar winienn, c'hwi ne c'hellot ket kennebeut ma ne chomit ket ennon. ");
INSERT INTO breBRG_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Me eo ar winienn, ha c'hwi eo ar brankoù. An hini a chom ennon ha ma choman ennañ, a zoug kalz a frouezh; rak hepdon ne c'hellit ober netra. ");
INSERT INTO breBRG_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma ne chom ket unan bennak ennon, taolet eo er-maez evel ar brank, hag e sec'h; neuze e tastumer ar brankoù, o zaoler en tan hag e tevont. ");
INSERT INTO breBRG_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mar chomit ennon, ha mar chom va gerioù ennoc'h, c'hwi a c'houlenno ar pezh a fello deoc'h, hag ho po anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Roet e vo gloar da'm Zad, mar dougit kalz a frouezh, ha c'hwi a vo va diskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Evel m'en deus an Tad va c'haret, me am eus ivez ho karet; chomit em c'harantez. ");
INSERT INTO breBRG_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mar mirit va gourc'hemennoù, e chomot em c'harantez, evel ma em eus miret gourc'hemennoù va Zad, hag e choman en e garantez. ");
INSERT INTO breBRG_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Lavaret em eus deoc'h an traoù-mañ, evit ma chomo va levenez ennoc'h, ha ma vo ho levenez peurleuniet. ");
INSERT INTO breBRG_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Va gourc'hemenn eo, ma en em garot an eil egile, evel ma em eus ho karet. ");
INSERT INTO breBRG_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Den n'en deus brasoc'h karantez eget an hini a ro e vuhez evit e vignoned. ");
INSERT INTO breBRG_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","C'hwi a vo va mignoned, mar grit kement a c'hourc'hemennan deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N'ho kalvan ken servijerien, rak ar servijer ne oar ket petra a ra e vestr, met ho kervel a ran mignoned, abalamour ma em eus roet deoc'h da anavezout kement am eus klevet gant va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","N'eo ket c'hwi hoc'h eus va choazet, met me eo am eus ho choazet, hag am eus ho lakaet, evit ma'z eot, ha ma tougot frouezh, ha ma vo ho frouezh kendalc'hus, ha ma roio va Zad deoc'h ar pezh a c'houlennot outañ em anv. ");
INSERT INTO breBRG_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ar pezh a c'hourc'hemennan deoc'h eo ma en em garot an eil egile. ");
INSERT INTO breBRG_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mar kasa ar bed ac'hanoc'h, gouezit penaos en deus va c'hasaet a-raok deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mar bijec'h eus ar bed, ar bed a garje ar pezh a vije dezhañ; met abalamour ma n'oc'h ket eus ar bed, met ma em eus ho choazet er bed, abalamour da-se eo e kasa ar bed ac'hanoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ho pet soñj eus ar ger am eus lavaret deoc'h: Ar mevel n'eo ket brasoc'h eget e vestr. Mar o deus va gwallgaset, e wallgasint ivez ac'hanoc'h; mar o deus miret va ger, e virint ivez hoc'h hini. ");
INSERT INTO breBRG_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Met ober a raint deoc'h kement-se holl abalamour da'm anv, rak n'anavezont ket an hini en deus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma ne vijen ket deuet, ha ma ne'm bije ket komzet outo, n'o dije ket a bec'hed; met bremañ n'o deus ket a zigarez evit o fec'hed. ");
INSERT INTO breBRG_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","An hini a gasa ac'hanon, a gasa ivez va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma ne'm bije ket graet en o zouez an oberoù n'en deus graet hini all ebet, n'o dije ket a bec'hed; met bremañ o deus o gwelet, hag o deus kasaet ac'hanon ha va Zad ivez. ");
INSERT INTO breBRG_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Met kement-se a zo evit ma vo peurc'hraet ar ger a zo skrivet en o lezenn: Va c'hasaet o deus hep abeg. ");
INSERT INTO breBRG_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Met pa vo deuet ar Frealzer, a zegasin deoc'h a-berzh an Tad, ar Spered a wirionez a zeu eus an Tad, eñ a roio testeni ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ha c'hwi ivez, c'hwi a roio testeni, abalamour m'emaoc'h ganin adalek ar penn-kentañ. ");
INSERT INTO breBRG_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Lavaret em eus deoc'h an traoù-mañ, evit na gemerot ket a skouer fall. ");
INSERT INTO breBRG_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kas a raint ac'hanoc'h kuit eus o sinagogennoù; an eur a zeu ma kredo piv bennak ho lakaio d'ar marv servijañ Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ober a raint kement-se deoc'h, abalamour n'o deus ket anavezet na va Zad na me. ");
INSERT INTO breBRG_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Met me am eus lavaret deoc'h an traoù-se, evit m'ho po soñj, pa vo deuet an eur, em eus o lavaret deoc'h. Ne'm eus ket lavaret anezho deoc'h abaoe ar penn-kentañ, abalamour ma oan ganeoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Met bremañ ez an da gavout an hini en deus va c'haset, hag hini ac'hanoc'h ne c'houlenn ouzhin: Pelec'h ez ez? ");
INSERT INTO breBRG_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Met, abalamour ma em eus lavaret deoc'h an traoù-mañ, an dristidigezh he deus leuniet ho kalon. ");
INSERT INTO breBRG_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Koulskoude, me a lavar deoc'h ar wirionez, talvoudek eo deoc'h ez afen kuit; rak ma ne dan ket kuit, ar Frealzer ne zeuio ket d'ho kavout; met mar dan kuit, me a gaso anezhañ deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ha pa vo deuet, e kendrec'ho ar bed a bec'hed, a reizhder, hag a varnedigezh: ");
INSERT INTO breBRG_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","a bec'hed, abalamour na gredont ket ennon; ");
INSERT INTO breBRG_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","a reizhder, abalamour ma'z an da gavout va Zad ha ne'm gwelot mui; ");
INSERT INTO breBRG_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","a varnedigezh, abalamour priñs ar bed-mañ a zo dija barnet. ");
INSERT INTO breBRG_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kalz a draoù all am eus c'hoazh da lavarout deoc'h, met n'oc'h ket c'hoazh evit o dougen. ");
INSERT INTO breBRG_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Met pa vo deuet hennezh, ar Spered a wirionez, e reno ac'hanoc'h en holl wirionez, rak ne gomzo ket anezhañ e-unan, met lavarout a raio kement en devo klevet, hag e tisklêrio deoc'h an traoù da zont. ");
INSERT INTO breBRG_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eñ eo an hini a roio gloar din, abalamour ma kemero eus ar pezh a zo din, ha ma en disklêrio deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kement en deus an Tad a zo din; setu perak em eus lavaret e kemero eus ar pezh a zo din, hag en disklêrio deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","C'hoazh un nebeut amzer ha ne'm gwelot mui; hag a-nevez un nebeut amzer goude em gwelot, abalamour ma'z an da gavout va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Hag hiniennoù eus an diskibien a lavaras an eil d'egile: Petra eo ar pezh a lavar deomp: A-benn nebeut amzer, ne'm gwelot mui; hag a-nevez un nebeut amzer goude em gwelot; hag: Abalamour ma'z an da gavout va Zad? ");
INSERT INTO breBRG_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lavarout a raent eta: Petra eo pa lavar: A-benn nebeut amzer? N'ouzomp ket ar pezh a lavar. ");
INSERT INTO breBRG_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jezuz eta, oc'h anavezout e c'hoantaent ober goulennoù outañ, a lavaras dezho: C'hwi a ra goulennoù an eil ouzh egile diwar-benn ar pezh am eus lavaret: A-benn nebeut amzer, ne'm gwelot mui; hag a-nevez un nebeut amzer goude em gwelot. ");
INSERT INTO breBRG_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","E gwirionez, e gwirionez, me a lavar deoc'h, c'hwi a welo hag a hirvoudo, hag ar bed en em laouenaio; c'hwi a vo en dristidigezh, met ho tristidigezh a vo troet e levenez. ");
INSERT INTO breBRG_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pa wilioud ur wreg, he devez poan, abalamour ma vez deuet he amzer; met adalek ma'z eo gwilioudet eus ur bugel, n'he devez ken soñj eus he foan, gant ar joa he deus da vezañ ganet un den er bed. ");
INSERT INTO breBRG_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Evel-se, c'hwi a zo bremañ en dristidigezh; met me ho kwelo a-nevez, hag ho kalon en em laouenaio, ha den ne lamo diganeoc'h ho levenez. ");
INSERT INTO breBRG_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hag en deiz-se, c'hwi ne c'houlennot ken mann ouzhin war netra. E gwirionez, e gwirionez, me a lavar deoc'h, penaos kement a c'houlennot digant an Tad em anv, e roio anezhañ deoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Betek vremañ n'hoc'h eus goulennet netra em anv; goulennit, hag ho po, evit ma vo ho levenez peurleuniet. ");
INSERT INTO breBRG_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Me am eus lavaret deoc'h an traoù-mañ e parabolennoù; met an amzer a zeu na gomzin ken deoc'h e parabolennoù; met me a gomzo deoc'h freals eus an Tad. ");
INSERT INTO breBRG_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","En deiz-se, c'hwi a c'houlenno em anv, ha ne lavaran ket deoc'h e pedin an Tad evidoc'h, ");
INSERT INTO breBRG_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","rak an Tad e-unan ho kar, abalamour m'hoc'h eus va c'haret, ha m'hoc'h eus kredet on deuet eus Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Me a zo deuet eus an Tad, hag on deuet er bed; lezel a ran a-nevez ar bed, hag ez an da gavout va Zad. ");
INSERT INTO breBRG_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","E ziskibien a lavaras dezhañ: Setu, bremañ e komzez freals, ha ne lavarez parabolenn ebet. ");
INSERT INTO breBRG_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bremañ, ni a oar ec'h anavezez an holl draoù, ha ne'c'h eus ket ezhomm e c'houlennfe den netra ouzhit; abalamour da-se eo e kredomp out deuet eus Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jezuz a respontas dezho: C'hwi a gred bremañ? ");
INSERT INTO breBRG_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Setu, an eur a zeu, hag deuet eo dija, penaos e viot stlabezet pep hini ouzh e gostez, ha penaos e lezot ac'hanon va-unan; met me n'on ket va-unan, abalamour va Zad a zo ganin. ");
INSERT INTO breBRG_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lavaret em eus deoc'h an traoù-mañ evit m'ho po ar peoc'h ennon; c'hwi ho po trubuilhoù er bed, met bezit kalonek, me am eus trec'het ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jezuz a gomzas evel-se, hag o sevel e zaoulagad etrezek an neñv, e lavaras: Tad, an eur a zo deuet; ro gloar da'z Mab, evit ma roio gloar da Vab dit, ");
INSERT INTO breBRG_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","hervez ma ec'h eus roet dezhañ galloud war bep kig, evit ma roio ar vuhez peurbadus d'an holl re ac'h eus roet dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hag ar vuhez peurbadus eo, ma'c'h anavezint ac'hanout, te, ar gwir Doue hepken, ha Jezuz-Krist, an hini ac'h eus kaset. ");
INSERT INTO breBRG_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Roet em eus gloar dit war an douar; echuet em eus al labour az poa roet din d'ober. ");
INSERT INTO breBRG_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ha bremañ, ro gloar din, Tad, ez kichen da-unan, eus ar gloar-se am boa tost ouzhit a-raok ma voe graet ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Disklêriet em eus da anv d'an dud ac'h eus roet din eus ar bed; dit e oant, hag ec'h eus o roet din, hag o deus miret da c'her. ");
INSERT INTO breBRG_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Anavezet o deus bremañ penaos kement ac'h eus roet din a zeu ac'hanout. ");
INSERT INTO breBRG_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Rak roet em eus dezho ar gerioù ac'h eus roet din, hag o deus o degemeret, hag o deus anavezet e gwirionez on deuet ac'hanout, hag o deus kredet ec'h eus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pediñ a ran evito, ne bedan ket evit ar bed, met evit ar re ac'h eus roet din, abalamour ma'z int dit. ");
INSERT INTO breBRG_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ha kement a zo din, a zo dit; hag ar pezh a zo dit, a zo din; hag enno e vez roet gloar din. ");
INSERT INTO breBRG_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Me n'on ken er bed, met ar re-mañ a zo er bed, ha me a ya da'z kavout. Tad santel, mir ez anv ar re ac'h eus roet din, evit ma vint unan, eveldomp-ni. ");
INSERT INTO breBRG_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","E-pad ma oan ganto er bed, e tiwallen anezho ez anv. Miret em eus ar re ac'h eus roet din, hag hini ebet anezho n'eo en em gollet, nemet mab ar gollidigezh, evit ma vije ar Skritur peurc'hraet. ");
INSERT INTO breBRG_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ha bremañ, me a ya da'z kavout, hag e lavaran an traoù-mañ er bed, evit ma vo va levenez peurleuniet enno. ");
INSERT INTO breBRG_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Roet em eus dezho da c'her, hag ar bed en deus kasaet anezho, abalamour n'int ket eus ar bed, evel n'on ket va-unan eus ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne bedan ket ac'hanout d'o lemel eus ar bed, met d'o diwall diouzh an droug. ");
INSERT INTO breBRG_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","N'int ket eus ar bed, evel n'on ket va-unan eus ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Santela anezho dre da wirionez; da c'her eo ar wirionez. ");
INSERT INTO breBRG_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Evel ma ec'h eus va c'haset er bed, em eus ivez o c'haset er bed. ");
INSERT INTO breBRG_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ha me en em santela va-unan evito, evit ma vint ivez santelaet dre ar wirionez. ");
INSERT INTO breBRG_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ne bedan ket hepken evito, met ivez evit a re a gredo ennon dre o ger, ");
INSERT INTO breBRG_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","evit ma vint holl unan, evel ma'z out ennon o Tad, hag evel ma'z on ennout, evit ma vint ivez unan ennomp, evit ma kredo ar bed eo te ac'h eus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Roet em eus dezho ar gloar ac'h eus roet din, evit ma vint unan, evel ma'z omp ni unan, ");
INSERT INTO breBRG_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","me enno, ha te ennon, evit ma vint unan en un doare klok, ha ma'c'h anavezo ar bed ec'h eus va c'haset, hag e karez anezho evel ma ec'h eus va c'haret. ");
INSERT INTO breBRG_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tad, me a fell din e vo ganin ar re ac'h eus roet din, el lec'h e vin, evit ma welint ar gloar ac'h eus roet din, rak va c'haret ec'h eus a-raok krouidigezh ar bed. ");
INSERT INTO breBRG_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tad gwirion, ar bed n'en deus ket anavezet ac'hanout; met me am eus anavezet ac'hanout, hag ar re-mañ o deus anavezet eo te ac'h eus va c'haset. ");
INSERT INTO breBRG_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Hag em eus roet da anavezout dezho da anv, hag e roin anezhañ da anavezout dezho, evit ma vo enno ar garantez ac'h eus bet evidon, ha ma vin ivez enno. ");
INSERT INTO breBRG_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Goude m'en devoe Jezuz lavaret an traoù-mañ, ez eas gant e ziskibien en tu all d'ar froud Kedron, e-lec'h ma oa ul liorzh; antreal a reas enni, eñ hag e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judaz, an hini en gwerzhe, a anaveze ivez al lec'h-se, abalamour Jezuz a oa aet alies eno gant e ziskibien. ");
INSERT INTO breBRG_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judaz eta, o vezañ kemeret ur vandenn soudarded ha serjanted ar veleien vras hag ar farizianed, a zeuas eno gant leternioù, gant goulou ha gant armoù. ");
INSERT INTO breBRG_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ha Jezuz, o c'houzout kement a dlee c'hoarvezout gantañ, a yeas en o raok hag a lavaras dezho: Piv a glaskit? ");
INSERT INTO breBRG_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Int a respontas dezhañ: Jezuz a Nazared. Jezuz a lavaras dezho: Me eo. Ha Judaz, an hini en gwerzhe, a oa ivez ganto. ");
INSERT INTO breBRG_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kerkent m'en devoa lavaret dezho: Me eo, e teujont a-dreñv, hag e kouezhjont d'an douar. ");
INSERT INTO breBRG_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Goulenn a reas c'hoazh ur wech outo: Piv a glaskit? Hag int a respontas: Jezuz a Nazared. ");
INSERT INTO breBRG_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jezuz a respontas: Lavaret em eus deoc'h penaos eo me; mar deo eta me a glaskit, lezit ar re-mañ da vont kuit. ");
INSERT INTO breBRG_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kement-mañ a c'hoarvezas evit ma vije peurc'hraet ar gomz-mañ en devoa lavaret: Ne'm eus kollet hini ebet eus ar re ac'h eus roet din. ");
INSERT INTO breBRG_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Neuze Simon-Pêr, a oa gantañ ur c'hleze, a dennas anezhañ, a skoas gantañ ur servijer d'ar beleg-meur, hag a droc'has e skouarn dehou dezhañ; ar servijer-se a oa anvet Malkuz. ");
INSERT INTO breBRG_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Met Jezuz a lavaras da Bêr: Laka da gleze en e c'houin; ha n'evin ket an hanaf en deus an Tad roet din? ");
INSERT INTO breBRG_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Neuze ar vandenn soudarded, ar c'habiten hag an dud kaset gant ar Yuzevien a gemeras Jezuz, a ereas anezhañ, ");
INSERT INTO breBRG_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","hag a gasas anezhañ da gentañ da di Annaz, abalamour ma oa tad-kaer da Gaifaz, beleg-meur ar bloaz-se. ");
INSERT INTO breBRG_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifaz a oa an hini en devoa roet ar c'huzul-se d'ar Yuzevien, penaos e oa talvoudek e varvje un den hepken evit ar bobl. ");
INSERT INTO breBRG_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Met, Simon-Pêr, gant un diskibl all, en devoa heuliet Jezuz. An diskibl-se a oa anavezet gant ar beleg-meur, hag ez eas gant Jezuz e palez ar beleg-meur. ");
INSERT INTO breBRG_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Met Pêr a oa chomet er-maez, e-tal an nor. An diskibl all, hag a oa anavezet gant ar beleg-meur, a yeas eta da gomz ouzh ar borzhierez, hag a lakaas Pêr da vont e-barzh. ");
INSERT INTO breBRG_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Neuze ar vatezh (ar borzhierez) a lavaras da Bêr: N'out ket ivez eus diskibien an den-se? Eñ a lavaras: N'on ket. ");
INSERT INTO breBRG_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ar mevelien hag ar servijerien a oa eno, o vezañ graet tan, abalamour ma oa yen, e tomment. Pêr a oa ganto, hag e tomme. ");
INSERT INTO breBRG_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ar beleg-meur a reas goulennoù ouzh Jezuz diwar-benn e ziskibien, ha diwar-benn e gredenn. ");
INSERT INTO breBRG_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jezuz a respontas dezhañ: Komzet em eus sklaer d'an dud; atav em eus kelennet er sinagogenn hag en templ, e-lec'h m'en em zastum ar Yuzevien eus a bep lec'h, ha ne'm eus lavaret netra e-kuzh. ");
INSERT INTO breBRG_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Perak eta e rez goulennoù ouzhin? Gra da c'houlennoù ouzh a re o deus klevet ar pezh am eus lavaret dezho: an dud-se a oar ar pezh am eus lavaret. ");
INSERT INTO breBRG_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","P'en devoa lavaret kement-se, unan eus ar servijerien a oa eno, a roas ur jodad da Jezuz, en ur lavarout dezhañ: Evel-se eo e respontez d'ar beleg-meur? ");
INSERT INTO breBRG_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jezuz a respontas dezhañ: Mar em eus komzet fall, diskouez ar pezh fall am eus lavaret; met mar em eus komzet mat, perak e skoez ac'hanon? ");
INSERT INTO breBRG_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hag Annaz a gasas anezhañ ereet da Gaifaz ar beleg-meur. ");
INSERT INTO breBRG_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon-Pêr a oa eno, hag en em domme; lavarout a rejont dezhañ: Ha n'out ket te ivez eus e ziskibien? Eñ en nac'has hag a lavaras: N'on ket. ");
INSERT INTO breBRG_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Unan eus mevelien ar beleg-meur, a oa kar d'an hini en devoa Pêr troc'het e skouarn, a lavaras dezhañ: Ha ne'm eus ket da welet el liorzh gantañ? ");
INSERT INTO breBRG_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pêr en nac'has adarre; ha kerkent ar c'hilhog a ganas. ");
INSERT INTO breBRG_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Neuze e kasjont Jezuz eus ti Kaifaz d'ar pretordi; ar mintin e oa, ha n'ejont ket e-barzh ar pretordi o-unan, gant aon d'en em saotrañ, evit ma c'helljent debriñ ar Pask. ");
INSERT INTO breBRG_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilat, o vezañ aet d'o c'havout, a lavaras dezho: Pet tamall a rit a-enep an den-se? ");
INSERT INTO breBRG_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Respont a rejont dezhañ: Ma ne vije ket un torfedour, n'hor bije ket e lakaet etre da zaouarn. ");
INSERT INTO breBRG_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat a lavaras dezho: Kemerit anezhañ hoc'h-unan, ha barnit eñ hervez ho lezenn. Ar Yuzevien a lavaras dezhañ: N'hon eus ket ar galloud da lazhañ den. ");
INSERT INTO breBRG_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kement-mañ a c'hoarvezas evit ma vije peurc'hraet ar pezh en devoa Jezuz lavaret, o verkañ dre beseurt marv e tlee mervel. ");
INSERT INTO breBRG_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Neuze Pilat a zistroas d'ar pretordi hag o vezañ lakaet Jezuz da zont, e lavaras dezhañ: Bez' out-te roue ar Yuzevien? ");
INSERT INTO breBRG_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jezuz a respontas dezhañ: Ac'hanout da-unan eo e lavarez kement-se, pe reoù all o deus e lavaret dit? ");
INSERT INTO breBRG_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat a respontas: Ha Yuzev on-me? Da bobl hag ar veleien vras o deus da lakaet etre va daouarn. Petra ac'h eus graet? ");
INSERT INTO breBRG_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jezuz a respontas dezhañ: Va rouantelezh n'eo ket eus ar bed-mañ; mar bije bet va rouantelezh eus ar bed-mañ, va mevelien o dije stourmet evit na vijen ket lakaet e daouarn ar Yuzevien; met bremañ va rouantelezh n'eo ket ac'han. ");
INSERT INTO breBRG_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Neuze Pilat a lavaras dezhañ: Te a zo eta roue? Jezuz a respontas: E lavarout a rez; roue on, evit-se eo on bet ganet, hag evit-se eo on deuet er bed, evit reiñ testeni d'ar wirionez. Piv bennak a zo eus ar wirionez, a selaou va mouezh. ");
INSERT INTO breBRG_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat a lavaras dezhañ: Petra eo ar wirionez? Ha goude m'en devoa lavaret kement-se, ez eas a-nevez da gavout ar Yuzevien, hag e lavaras dezho: Ne gavan torfed ebet en den-se. ");
INSERT INTO breBRG_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Met, bez' hoc'h eus ur c'hiz en ho touez, ma laoskfen deoc'h unan bennak gant ar Pask. Fellout a ra deoc'h eta e laoskfen deoc'h roue ar Yuzevien? ");
INSERT INTO breBRG_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Neuze an holl a grias a-nevez: Na laosk ket hemañ, met Barabbaz. Ha Barabbaz a oa ul laer. ");
INSERT INTO breBRG_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilat eta a gemeras Jezuz, hag a lakaas anezhañ da vezañ skourjezet. ");
INSERT INTO breBRG_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ar soudarded, o vezañ gweet ur gurunenn spern, a lakaas anezhi war e benn, hag a wiskas anezhañ gant ur vantell vouk. ");
INSERT INTO breBRG_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hag e lavarent dezhañ: Roue ar Yuzevien, ni a salud ac'hanout; hag e roent jodadoù dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat o vezañ aet a-nevez er-maez a lavaras dezho: Setu, e tegasan anezhañ deoc'h er-maez, evit ma ouiot penaos ne gavan torfed ebet ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jezuz a yeas eta er-maez, o tougen ar gurunenn spern hag ar vantell vouk; ha Pilat a lavaras dezho: Setu an den. ");
INSERT INTO breBRG_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Met pa welas ar veleien vras hag ar servijerien anezhañ, e krijont: Ouzh ar groaz! Ouzh ar groaz! Pilat a lavaras dezho: Kemerit anezhañ hoc'h-unan ha kroazstagit anezhañ; rak me ne gavan torfed ebet ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ar Yuzevien a respontas dezhañ: Ni hon eus ul lezenn, hag hervez hol lezenn e tle mervel, abalamour ma'z eo en em raet Mab Doue. ");
INSERT INTO breBRG_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilat, o klevout ar ger-se, en devoe c'hoazh muioc'h a zoujañs. ");
INSERT INTO breBRG_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Distreiñ a reas eta er pretordi, hag e lavaras da Jezuz: A-belec'h out? Met Jezuz ne roas respont ebet dezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Neuze Pilat a lavaras dezhañ: Ne lavarez netra din? N'ouzout ket em eus ar galloud da lakaat kroazstagañ ac'hanout, hag ar galloud da'z leuskel da vont? ");
INSERT INTO breBRG_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jezuz a respontas dezhañ: Te ne'z pije galloud ebet warnon, ma ne vije ket bet roet dit diouzh krec'h; setu perak an hini en deus va lakaet etre da zaouarn en deus graet ur pec'hed brasoc'h. ");
INSERT INTO breBRG_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Adalek neuze Pilat a glaske e leuskel; met ar Yuzevien a grie: Mar laoskez an den-se, n'out ket mignon da Gezar; rak piv bennak en em c'hra roue, en em laka a-enep Kezar. ");
INSERT INTO breBRG_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat, o klevout ar gomz-se, a gasas Jezuz er-maez, hag a azezas war e gador-varn, el lec'h galvet ar Pavez, hag en hebraeg Gabbata ");
INSERT INTO breBRG_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","(met kempennadur ar Pask e oa, ha war-dro ar c'hwec'hvet eur); hag e lavaras d'ar Yuzevien: Setu ho roue. ");
INSERT INTO breBRG_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Met int a grias: Lam anezhañ! Lam anezhañ! Ouzh ar groaz! Pilat a lavaras dezho: Ha kroazstagañ a rin ho roue? Ar veleien vras a respontas: Ni n'hon eus roue all ebet nemet Kezar. ");
INSERT INTO breBRG_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Neuze e roas anezhañ dezho evit bezañ kroazstaget. Kemer a rejont eta anezhañ hag e kasjont Jezuz ganto. ");
INSERT INTO breBRG_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ha Jezuz, o tougen e groaz, a zeuas el lec'h anvet ar C'hlopenn, hag a zo en hebraeg Golgota. ");
INSERT INTO breBRG_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Eno e kroazstagjont anezhañ ha daou all gantañ, unan en un tu, hag unan all en tu all, ha Jezuz er c'hreiz. ");
INSERT INTO breBRG_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat a reas ivez ur skrid, hag en lakaas war ar groaz; ennañ e oa skrivet: JEZUZ A NAZARED, ROUE AR YUZEVIEN. ");
INSERT INTO breBRG_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kalz eus ar Yuzevien a lennas ar skrid-se, abalamour al lec'h ma oa Jezuz kroazstaget a oa tost da gêr; skrivet e oa en hebraeg, e gresianeg hag e latin. ");
INSERT INTO breBRG_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Beleien vras ar Yuzevien a lavaras da Bilat: Na skriv ket: Roue ar Yuzevien, met penaos en deus lavaret: Me eo roue ar Yuzevien. ");
INSERT INTO breBRG_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat a respontas: Ar pezh am eus skrivet, am eus skrivet. ");
INSERT INTO breBRG_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Goude m'o devoe ar soudarded kroazstaget Jezuz, e kemerjont e zilhad, hag e rejont peder lodenn, ul lodenn evit pep hini; kemer a rejont ivez ar sae; met ar sae a oa hep gwri, eus ur wiadenn, adalek krec'h betek traoñ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lavaret a rejont eta etrezo: Na lodennomp ket anezhi, met taolomp ar sord da biv e vo. Evel-se e voe, evit ma vije peurc'hraet ar gomz-mañ eus ar Skritur: Lodennet o deus va dilhad, ha taolet o deus va sae d'ar sord. Evel-se e reas ar soudarded. ");
INSERT INTO breBRG_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mamm Jezuz, ha c'hoar e vamm, Mari gwreg Klopaz, ha Mari a Vagdala, en em zalc'he tost ouzh kroaz Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jezuz eta, o welout e vamm hag en he c'hichen an diskibl a gare, a lavaras d'e vamm: Gwreg, setu da vab. ");
INSERT INTO breBRG_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Neuze e lavaras d'an diskibl: Setu da vamm. Hag adalek an eur-se, an diskibl a gemeras anezhi en e di. ");
INSERT INTO breBRG_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Goude-se, Jezuz, o welout penaos e oa peurc'hraet holl, a lavaras, evit ma vije ar Skritur peurc'hraet: Sec'hed am eus. ");
INSERT INTO breBRG_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Bez' e oa eno ul lestr leun a winegr. Leuniañ a rejont eta ur spoueenn a winegr, hag o vezañ he lakaet e penn ur gorzenn sikadez, e kinnigjont anezhi d'e c'henou. ");
INSERT INTO breBRG_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","P'en devoa Jezuz kemeret ar gwinegr e lavaras: Peurc'hraet eo pep tra! Hag, o vezañ pleget e benn, e roas ar spered. ");
INSERT INTO breBRG_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Met, ar Yuzevien, gant aon na chomfe ar c'horfoù war ar groaz deiz ar sabad (rak kempennadur ar Pask e oa, hag ar sabad-se a oa un deiz bras), a c'houlennjont digant Pilat ma vije torret o divhar d'ar re groazstaget, ha ma vijent tennet ac'hane. ");
INSERT INTO breBRG_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ar soudarded a zeuas eta hag a dorras e zivhar d'an hini kentañ, goude d'an eil a oa kroazstaget gantañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Met pa zeujont da Jezuz, o welout e oa dija marv, ne dorrjont ket dezhañ e zivhar. ");
INSERT INTO breBRG_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Koulskoude unan eus ar soudarded a doullas e gostez dezhañ gant ul lañs, ha kerkent e tilamas anezhañ gwad ha dour. ");
INSERT INTO breBRG_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","An hini en deus gwelet a ro testeni a gement-se (hag e desteni a zo gwirion, hag e oar e lavar gwir), evit ma kredot. ");
INSERT INTO breBRG_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ha kement-se a erruas evit ma vije ar Skritur peurc'hraet: E eskern ne vint ket torret. ");
INSERT INTO breBRG_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hag e lec'h all ar Skritur a lavar c'hoazh: Gwelout a raint an hini o deus toullet. ");
INSERT INTO breBRG_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Goude-se, Jozef a Arimatea hag a oa diskibl da Jezuz, met e-kuzh gant aon rak ar Yuzevien, a c'houlennas digant Pilat lemel korf Jezuz, ha Pilat en lezas d'e gemer. Dont a reas eta hag e lamas korf Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem, an hini, er penn-kentañ, a oa aet en noz da gavout Jezuz, a zeuas ivez, o tegas war-dro kant lur eus ur veskadenn mir hag aloez. ");
INSERT INTO breBRG_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kemer a rejont eta korf Jezuz, hag e c'holojont anezhañ gant bandennoù ha gant al louzoù a c'hwezh-vat, evel m'o devoa ar Yuzevien ar c'hiz da sebeliañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Setu, e oa ul liorzh el lec'h ma oa bet kroazstaget, hag el liorzh ur bez nevez na oa bet c'hoazh lakaet den ennañ. ");
INSERT INTO breBRG_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lakaat a rejont eta Jezuz ennañ, abalamour da gempennadur ar Yuzevien hag ivez dre ma oa tost ar bez. ");
INSERT INTO breBRG_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","An deiz kentañ eus ar sizhun, Mari a Vagdala a zeuas mintin mat d'ar bez, evel ma oa c'hoazh teñval, hag e welas ar maen lamet diwar ar bez. ");
INSERT INTO breBRG_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Redek a reas eta hag e teuas da gavout Simon-Pêr hag an diskibl all a oa karet gant Jezuz, hag e lavaras dezho: Tennet eo an Aotrou eus ar bez, ha n'ouzomp ket pelec'h o deus e lakaet. ");
INSERT INTO breBRG_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Neuze Pêr a yeas er-maez gant an diskibl all, hag ez ejont d'ar bez. ");
INSERT INTO breBRG_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hag e redent o-daou a-unvan, met an diskibl all-se a redas buanoc'h eget Pêr, hag a erruas da gentañ er bez. ");
INSERT INTO breBRG_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O vezañ en em bleget, e welas ar bandennoù war an douar, met ne deas ket e-barzh. ");
INSERT INTO breBRG_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon-Pêr a heulie anezhañ, hag, o vezañ erruet, a yeas er bez; gwelout a reas ar bandennoù war an douar, ");
INSERT INTO breBRG_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","hag al lienenn a oa bet lakaet dezhañ war e benn ha ne oa ket gant ar bandennoù, met pleget en ul lec'h a-du. ");
INSERT INTO breBRG_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","An diskibl all, an hini erruet da gentañ er bez, a yeas ivez ennañ, hag e welas, hag e kredas. ");
INSERT INTO breBRG_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Rak n'o devoa ket c'hoazh komprenet ar Skritur a lavare e tlee Jezuz adsevel a varv. ");
INSERT INTO breBRG_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hag an diskibien a zistroas d'o ziez. ");
INSERT INTO breBRG_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Koulskoude Mari en em zalc'he er-maez, tost ouzh ar bez, o ouelañ; hag evel ma ouele, en em blegas er bez ");
INSERT INTO breBRG_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","hag e welas daou ael gwisket e gwenn, azezet unan ouzh ar penn hag egile ouzh an treid, el lec'h ma oa bet gourvezet korf Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lavarout a rejont dezhi: Gwreg, perak e ouelez? Hi a lavaras dezho: Abalamour ma'z eo tennet ac'han va Aotrou, ha n'ouzon ket pelec'h eo bet lakaet. ");
INSERT INTO breBRG_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hag o vezañ lavaret kement-se, e tistroas, hag e welas Jezuz en e sav; met ne ouie ket e oa Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jezuz a lavaras dezhi: Gwreg, perak e ouelez? Piv a glaskez? Hi, o krediñ e oa al liorzher, a lavaras dezhañ: Aotrou, mar ec'h eus e gaset kuit, lavar din pelec'h ec'h eus e lakaet, hag e kemerin anezhañ. ");
INSERT INTO breBRG_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jezuz a lavaras dezhi: Mari! Hag hi, o vezañ distroet, a lavaras dezhañ: Rabbouni! Da lavarout eo: Mestr! ");
INSERT INTO breBRG_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jezuz a lavaras dezhi: Na stok ket ennon, rak n'on ket c'hoazh pignet etrezek va Zad; met kae da gavout va breudeur, ha lavar dezho penaos e pignan etrezek va Zad hag ho Tad, hag etrezek va Doue hag ho Toue. ");
INSERT INTO breBRG_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari a Vagdala a zeuas da gemenn d'an diskibien penaos he devoa gwelet an Aotrou, ha penaos en devoa lavaret kement-se dezhi. ");
INSERT INTO breBRG_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","An abardaez eus an deiz-se a oa ar c'hentañ eus ar sizhun, an dorioù eus al lec'h ma oa an diskibien en em zastumet o vezañ serret gant aon rak ar Yuzevien, Jezuz a zeuas hag en em ziskouezas en o c'hreiz, hag e lavaras dezho: Ar peoc'h ra vo ganeoc'h! ");
INSERT INTO breBRG_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","P'en devoa lavaret kement-se dezho, e tiskouezas dezho e zaouarn hag e gostez. An diskibien eta, o welout an Aotrou, o devoe ur joa vras. ");
INSERT INTO breBRG_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Lavarout a reas dezho a-nevez: Ar peoc'h ra vo ganeoc'h! Evel m'en deus an Tad kaset ac'hanon, me ho kas ivez. ");
INSERT INTO breBRG_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","P'en devoe lavaret kement-se, e c'hwezas warno hag e lavaras dezho: Degemerit ar Spered-Santel. ");
INSERT INTO breBRG_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","D'ar re e pardonot o fec'hedoù, e vint pardonet dezho, ha d'ar re o dalc'hot, e vint dalc'het dezho. ");
INSERT INTO breBRG_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Met Tomaz, unan eus an daouzek, galvet Didim, ne oa ket ganto pa oa deuet Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","An diskibien all a lavaras dezhañ eta: Ni hon eus gwelet an Aotrou. Met eñ a lavaras dezho: Ma ne welan ket merk an tachoù en e zaouarn, ha ma ne lakaan ket va dorn en e gostez, ne gredin ket. ");
INSERT INTO breBRG_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Eizh deiz goude, e ziskibien a oa a-nevez en ti, ha Tomaz ganto. Jezuz a zeuas, an dorioù o vezañ serret, en em zalc'has en o c'hreiz hag a lavaras: Ar peoc'h ra vo ganeoc'h! ");
INSERT INTO breBRG_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Neuze e lavaras da Domaz: Laka amañ da viz, ha sell ouzh va daouarn; astenn ivez da zorn, ha laka anezhañ em c'hostez, ha na vez ket diskredik, met kred. ");
INSERT INTO breBRG_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaz a respontas hag a lavaras dezhañ: Va Aotrou ha va Doue! ");
INSERT INTO breBRG_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jezuz a lavaras dezhañ: Abalamour ma ec'h eus va gwelet, Tomaz, ec'h eus kredet. Eürus ar re n'o deus ket gwelet hag o deus kredet! ");
INSERT INTO breBRG_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jezuz a reas c'hoazh dirak e ziskibien kalz a virakloù all, met n'int ket skrivet el levr-mañ. ");
INSERT INTO breBRG_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Hag an traoù-mañ a zo bet skrivet, evit ma kredot ez eo Jezuz eo ar C'hrist, Mab Doue, hag evit, o krediñ, m'ho po ar vuhez dre e anv. ");
INSERT INTO breBRG_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Goude-se, Jezuz en em ziskouezas adarre d'e ziskibien tost ouzh Mor Tiberiaz. En em ziskouez a reas en doare-mañ. ");
INSERT INTO breBRG_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon-Pêr, Tomaz anvet Didim, Natanael eus Kana e Galilea, mibien Zebedea, ha daou all eus e ziskibien, a oa asambles. ");
INSERT INTO breBRG_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon-Pêr a lavaras dezho: Mont a ran da besketa. Int a lavaras dezhañ: Ni a ya ivez ganit. Mont a rejont, hag e pignjont er vag; met ne dapjont netra en noz-se. ");
INSERT INTO breBRG_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ar mintin o vezañ deuet, Jezuz en em gavas war an aod, met an diskibien ne ouient ket e oa Jezuz. ");
INSERT INTO breBRG_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jezuz a lavaras dezho: Bugale, ha n'hoc'h eus netra da zebriñ? Int a respontas dezhañ: Nann. ");
INSERT INTO breBRG_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eñ a lavaras dezho: Taolit ar roued en tu dehou d'ar vag, hag e kavot. Teurel a rejont eta anezhi, ha ne c'hellent ken he zennañ er-maez, abalamour d'an niver bras a besked. ");
INSERT INTO breBRG_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Setu perak, an diskibl a oa karet gant Jezuz a lavaras da Bêr: An Aotrou eo! Ha Simon-Pêr, oc'h anavezout e oa an Aotrou, a lakaas e sae war-c'horre (rak en noazh e oa) hag en em daolas er mor. ");
INSERT INTO breBRG_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Met an diskibien all a zeuas gant ar vag, o ruzañ ar roued leun a besked, rak ne oant ket pell diouzh an douar, nemet war-dro daou-c'hant ilinad. ");
INSERT INTO breBRG_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pa voent diskennet d'an douar, e weljont glaou-bev a oa eno, ha pesked warno, ha bara. ");
INSERT INTO breBRG_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jezuz a lavaras dezho: Degasit eus ar pesked-se hoc'h eus tapet bremañ. ");
INSERT INTO breBRG_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon-Pêr a adpignas hag a dennas ar roued d'an douar, leun gant tri hag hanter-kant pesk bras; ha petra bennak ma oa kement, ne dorre ket ar roued. ");
INSERT INTO breBRG_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jezuz a lavaras dezho: Deuit da leinañ. Hag hini ebet eus an diskibien ne grede goulenn outañ: Piv out-te? o c'houzout e oa an Aotrou. ");
INSERT INTO breBRG_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jezuz eta a dostaas, a gemeras bara, hag a roas anezhañ dezho, kenkoulz hag eus ar pesked. ");
INSERT INTO breBRG_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","An deirvet gwech a oa dija ma rae Jezuz en em ziskouez d'e ziskibien, goude bezañ adsavet a-douez ar re varv. ");
INSERT INTO breBRG_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Goude m'o devoa leinet, Jezuz a lavaras da Simon-Pêr: Simon, mab Jona, ha karout a rez ac'hanon muioc'h eget ar re-mañ? Pêr a respontas: Ya, Aotrou, gouzout a rez penaos e karan ac'hanout. Jezuz a lavaras dezhañ: Mesa va oaned. ");
INSERT INTO breBRG_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Lavarout a reas dezhañ un eil gwech: Simon, mab Jona, va c'harout a rez? Pêr a respontas dezhañ: Ya, Aotrou, te a oar penaos e karan ac'hanout. Jezuz a lavaras dezhañ: Mesa va deñved. ");
INSERT INTO breBRG_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Lavarout a reas dezhañ evit un deirvet gwech: Simon, mab Jona, va c'harout a rez? Pêr a voe glac'haret eus m'en devoa goulennet digantañ evit an deirvet gwech: Va c'harout a rez? Met eñ a lavaras dezhañ: Aotrou, anavezout a rez an holl draoù, gouzout a rez e karan ac'hanout. Jezuz a lavaras dezhañ: Mesa va deñved. ");
INSERT INTO breBRG_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","E gwirionez, e gwirionez, me a lavar dit: pa oas yaouank, te en em c'hourize da-unan hag ez aes e-lec'h ma felle dit; met pa vi kozh, ta a astenno da zaouarn, hag unan all a c'hourizo ac'hanout, hag a gaso ac'hanout e-lec'h na fello ket dit mont. ");
INSERT INTO breBRG_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Met, lavarout a rae kement-se, evit merkañ dre beseurt marv Pêr a roje gloar da Zoue. Ha goude bezañ komzet evel-se, e lavaras dezhañ: Heul ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ha Pêr, o vezañ distroet, a welas o tont war e lerc'h an diskibl a oa karet gant Jezuz, an hini a oa gourvezet war askre Jezuz e-pad ar goan, hag en devoa lavaret dezhañ: Aotrou, piv eo an hini a werzh ac'hanout? ");
INSERT INTO breBRG_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pêr eta, o vezañ e welet, a lavaras da Jezuz: Aotrou, hag hemañ, petra a erruo gantañ? ");
INSERT INTO breBRG_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jezuz a lavaras: Mar fell din e chomfe ken a zeuin, petra a ra-se dit? Te, heul ac'hanon. ");
INSERT INTO breBRG_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ar vrud eta en em skuilhas e-touez ar vreudeur, penaos an diskibl-se ne varvje ket. Koulskoude Jezuz n'en devoa ket lavaret dezhañ: Ne varvo ket; met: Mar fell din e chomfe ken a zeuin, petra a ra-se dit? ");
INSERT INTO breBRG_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","An diskibl-se eo, a ro testeni eus an traoù-mañ hag en deus o skrivet, ha ni a oar ez eo gwirion e desteni. ");
INSERT INTO breBRG_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kalz a draoù all c'hoazh a zo bet graet gant Jezuz, ha ma vijent bet skrivet dre ar munud, ne gredan ket e c'hellje ar bed memes kenderc'hel al levrioù a vije skrivet. Amen. ");
ALTER TABLE breBRG_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
