﻿USE sofia;
DROP TABLE IF EXISTS sofia.brb_vpl;
CREATE TABLE brb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES brb_vpl WRITE;
INSERT INTO brb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","អន់នួរ ពន់ឋើមៗ គ្រែដៃ ឡើ ពឝ៉ើត ឡាង ប្រិះ ដើម ឡាង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ទឹង អ៊ែ ឡាង ប្រិះ ណាគ់ ឡើ ឝ៉ក ញឹះ តៃ ឡើ ប៊ិច អង់ង៉ាយ អំម៉ឹះ ឡើ ប៊ិច ឌិវ កឡាំ ពឺង ក្លាង ដាក ឈ្រុៗ ដើម សណើម គ្រែដៃ ឡើ ហើប អង់ហើប ប៉ាគ់ កយឺវ ពឺង ក្លាង ដាក។ ");
INSERT INTO brb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ ឝ៉ាល!» អ៊ែ ឡើ ឝ៉ាល ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","គ្រែដៃ ឡើ តៃ រៀន ឝ៉ាល នែ ចាគ់ ឡើយ អ៊ែ ឡើ កះ ឝ៉ាល តើម ប៊ឹង កឡាំ។ ");
INSERT INTO brb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","គ្រែដៃ ឡើ ជុ ឝ៉ាល អ៊ែ “តង៉ៃ” ណគ់ កឡាំ ឡើ ជុ “មាំងៗ”។ អ៊ែ ឡើ ប៊ិច អំប៊ឹ អ៊ែ ឡើ ប៊ិច ងឹប ហង់អ៊ែ តង៉ៃ ទី មូយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ ប៊ិច ប្រឡា ទុត ឝ៉ិះ ប្លះ កឌី ដាក បក់ លំត្រកះ ត្រឌីវ ដាក!»។ ");
INSERT INTO brb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","អ៊ែ គ្រែដៃ ឡើ ពឝ៉ើត ប្រឡា ទុត ឝ៉ិះ អ៊ែ ឡើ កះ ដាក ឡើ គូ តៃ ក្រូម ប្រឡា តើម ប៊ឹង ដាក ទឹង ពឺង អ៊ែ ឡើ ប៊ិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","គ្រែដៃ ឡើ ជុ ប្រឡា ណគ់ ឡើ ឝ៉ិះ អ៊ែ “ឡាង គ្រែ”។ អ៊ែ ឡើ អំប៊ឹ អ៊ែ ឡើ ងឹប ហង់អ៊ែ តង៉ៃ ទី បារ។ ");
INSERT INTO brb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ ណគ់ ដាក ឡើ គូ កន់ដ្រូម ឡាង គ្រែ លំតមួត មូយ អំប៊ុ អាំ លំប៊ិច ប្រិះ ហរ៉ើង!»។ អ៊ែ ឡើ ប៊ិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","គ្រែដៃ ឡើ ជុ ណគ់ ហរ៉ើងៗ អ៊ែ “ពដិះ” ណគ់ ដាក ឡើ តមួត អ៊ែ ឡើ ជុ “សមុត”។ គ្រែដៃ ឡើ តៃ រៀន អង់ង៉ាយៗ លែក អ៊ែ ចាគ់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ ប្រិះ ហន់ហួន បាត់ ប៊្រី ប៊ូត ចិះ ត្រំ ហំឞ្លិច ណគ់ ម៉ើ ប៊ិច អង់គុង ដើម ហន់ហួន តើម ឡង ឞ ឡើ ប៉្លៃ អាំ មន់ហួន តាម អង់គុង មែ កឡឹ»។ អ៊ែ ឡើ ប៊ិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","អ៊ែ ណគ់ បាត់ ប៊្រី ប៊ូត ចិះ ម៉ើ ប៊ិច អង់គុង តាម ឡើ កឡឹ ដើម ឡង ឞ ម៉ើ ប៊ិច ពឺរ ប៉្លៃ តាម អង់គុង ឡើ កឡឹ ម៉ើ ហួន តើម ប៊ឹង ប្រិះ។ គ្រែដៃ ឡើ តៃ រៀន អង់ង៉ាយៗ លែក អ៊ែ ចាគ់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","អ៊ែ ឡើ អំប៊ឹ អ៊ែ ឡើ ងឹប ហង់អ៊ែ តង៉ៃ ទី ពែ។ ");
INSERT INTO brb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ ប៊ិច ឝ៉ូវ ឝ៉ាល ទឹង ឡាង គ្រែ អ៊ែ លន់កះ តង៉ៃ តើម ប៊ឹង មាំងៗ បក់ ពដៃ ពណោះ ញ៉ាម តង៉ៃ ខៃ ដើម កម៉ ");
INSERT INTO brb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","អាំ ប៊ិច ឝ៉ូវ ឝ៉ាល ទឹង គ្រែ អ៊ែ លំតាល់ ទិ ឡាង ប្រិះ!»។ អ៊ែ ឡើ ប៊ិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","គ្រែដៃ ឡើ ពឝ៉ើត ឝ៉ូវ ឝ៉ាល ទិះៗ បារ ណគ់ ឝ៉ូវ ឝ៉ាល មូយ ឡើ ទិះ ជឺរ អាំ លំពឝ៉ាល តង៉ៃ អ៊ែ ណគ់ ឝ៉ូវ ឝ៉ាល កិៗ ក្រូម អ៊ែ អាំ លំឝ៉ាល តគ់ មាំងៗ ដើម ឡើ ពឝ៉ើត ពតួរ ទុត អើន ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","គ្រែដៃ ឡើ ជុ ឝ៉ូវ ឝ៉ាល ដើម ពតួរ លែក នែ ទឹង ឡាង គ្រែ អ៊ែ មន់ឝ៉ាល ទិ ឡាង ប្រិះ ");
INSERT INTO brb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","បក់ លំឝ៉ាល តង៉ៃ ដើម មាំង អ៊ែ លន់កះ ឝ៉ាល តើម ប៊ឹង កឡាំ។ គ្រែដៃ ឡើ តៃ រៀន អង់ង៉ាយៗ លែក អ៊ែ ចាគ់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","អ៊ែ ឡើ អំប៊ឹ អ៊ែ ឡើ ងឹប ហង់អ៊ែ តង៉ៃ ទី ពួន។ ");
INSERT INTO brb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ ប៊ិច ពត្រូវ មន់គូ ទិ កនុង ដាក អ្រវ៉ក់ អ្រវឹច ទុត អើន ប្រុកៗ ដើម ជែម ចណាយ ទឹង គ្រែ មន់ប៉ារ់ អ្រប៉ើ!»។ ");
INSERT INTO brb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","គ្រែដៃ ឡើ ពឝ៉ើត ពត្រូវ ទុត ទិះ ទិ កនុង សមុត ដើម ពត្រូវ ត្រំ ហំឞ្លិច ម៉ើ គូ ទិ កនុង ដាក អ្រវ៉ក់ អ្រវឹច ប៊ិង ដាក តាម យូ មែ កឡឹ ដើម ឡើ ពឝ៉ើត ជែម ចណាយ ត្រំ ហំឞ្លិច តាម យូ មែ កឡឹ ប៉ាគ់ទឺ។ គ្រែដៃ ឡើ តៃ រៀន អង់ង៉ាយៗ លែក អ៊ែ ចាគ់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","គ្រែដៃ ឡើ ប្រាយ មែ រៀន៖ «ហឹ វន់ពឝ៉ើត ពស៊ឺក កួន ចូវ ទុត អើន ប៊ិង ដាក សមុត អ៊ែ ណគ់ ដើ វែ ជែម ចណាយ វន់ពឝ៉ើត ពស៊ឺក កួន ចូវ ទុត អើន ពឺង ឡាង ប្រិះ នែ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","អ៊ែ ឡើ អំប៊ឹ អ៊ែ ឡើ ងឹប ហង់អ៊ែ តង៉ៃ ទី សើង។ ");
INSERT INTO brb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហឹ លំប៊ិច ពត្រូវ ពឺង ឡាង ប្រិះ តាម យូ មែ កឡឹ លំប៊ិច ពត្រូវ ស៊្រុក ពត្រូវ ឆឡរ វ៉ារ ពត្រូវ អង់គ្លែត អង់ក្លួត ដើម ពត្រូវ ប៊្រី តាម យូ មែ កឡឹ!»។ អ៊ែ ឡើ ប៊ិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","គ្រែដៃ ឡើ ពឝ៉ើត ពត្រូវ ប៊្រី តាម យូ មែ កឡឹ ពត្រូវ ស៊្រុក តាម យូ មែ កឡឹ ពត្រូវ ឆឡរ វ៉ារ ដើម ពត្រូវ អង់គ្លែត អង់ក្លួត តាម យូ មែ កឡឹ។ គ្រែដៃ ឡើ តៃ រៀន អង់ង៉ាយៗ លែក អ៊ែ ចាគ់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","គ្រែដៃ ឡើ ម៉ាង រៀន៖ «អំពឝ៉ើត បនឹះ ប៉ាគ់ អៃ ទឺ បក់ មន់ប៊ិច អាតណាត ពែក ប៉ាក់ ទ្រឺ គីត ទិ សមុត ជែម ចណាយ ណគ់ ម៉ើ ប៉ារ់ ទឹង គ្រែ ពត្រូវ ស៊្រុក ពត្រូវ ប៊្រី ពត្រូវ ឆឡរ វ៉ារ ដើម ពត្រូវ អង់គ្លែត អង់ក្លួត ពឺង ប្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","គ្រែដៃ ឡើ ពឝ៉ើត បនឹះ ប៉ាគ់ ដើ ណគ កឡឹ ទឺ ណគ ឡើ ពឝ៉ើត មែ ប៉ាគ់ ដើ ណគ ទឺ ម៉ាត់ ម៉ាត គ្រែដៃ ឡើ ពឝ៉ើត កឡ ដើម កទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","គ្រែដៃ ឡើ ប្រាយ មែ រៀន៖ «ហឹ វន់ពឝ៉ើត កួន ចូវ អាំ វន់ស៊ឺក តាក ប៊ិង ឡាង ប្រិះ ដើម វន់រន់ឋាប់ ឝ្លាំង ឡាង ប្រិះ ដិ។ វន់ពែក ប៉ាក់ ទ្រឺ ទិ ដាក សមុត ជែម ចណាយ ណគ់ ម៉ើ ប៉ារ់ ទឹង គ្រែ ដើម លែក ដើ ពត្រូវ ណគ់ ម៉ើ ដក់ ពឺង ឡាង ប្រិះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","គ្រែដៃ ឡើ ម៉ាង ឡឹះ រៀន៖ «អន់នែ អៃ អង់អាំ ដើ វែ លែក ដើ បាត់ ប៊្រី ប៊ូត ចិះ ណគ់ ឡើ ប៊ិច អង់គុង ឡើ ហួន ប៊ិង ឡាង ប្រិះ ដើម តើម ឡង ឞ ណគ់ ឡើ ប៊ិច ប៉្លៃ អង់អាំ ដើ វែ វន់ចា។ ");
INSERT INTO brb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","អ៊ែ ណគ់ ដើ ពត្រូវ ប៊្រី ពត្រូវ ស្រ៊ុក ជែម ចណាយ ពត្រូវ ណគ់ ម៉ើ ឆឡរ វ៉ារ ពឺង ប្រិះ ដើម ពត្រូវ អង់គ្លែត អង់ក្លួត លែក ដើ ពត្រូវ ម៉ើ ប៊ិច ក្លើម សើម អៃ អង់អាំ បាត់ ប៊្រី កយ៉ិៗ លែក ដើ អ៊ែ ដើ មែ មន់ចា ប៉ាគ់ទឺ»។ អ៊ែ ឡើ ប៊ិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","គ្រែដៃ ឡើ ឝ្លាំង អង់ង៉ាយៗ លែក ដើ អ៊ែ ណគ់ ណគ ឡើ ពឝ៉ើត ឡើ តៃ រៀន ចាគ់ ទុត ខាក់ ឡើយ។ អ៊ែ ឡើ អំប៊ឹ អ៊ែ ឡើ ងឹប ហង់អ៊ែ តង៉ៃ ទី ត្រូវ។ ");
INSERT INTO brb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ប៉ាគ់ អ៊ែ ឡើយ គ្រែដៃ ឡើ ពឝ៉ើត ឡាង គ្រែ ដើម ឡាង ប្រិះ ដើម អង់ង៉ាយៗ ទឹង ឡាង គ្រែ ដើម ទិ ឡាង ប្រិះ ត្រំ ហំឞ្លិច លែក អិះ ចឹះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","តគ់ តង៉ៃ ទី ប៉ឹះ យ៉ាគ់ គ្រែដៃ ឡើ ពឡូច កាន ណគ ឡើ បើម លែក ឡើយ។ អ៊ែ ឡើ ព្រឹង ឡើ ពឹត យ៉ាវ ប៊ឹង តង៉ៃ ទី ប៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","គ្រែដៃ ឡើ ជុ តង៉ៃ ទី ប៉ឹះ នែ តង៉ៃ ឡើ ចាគ់ ភែង យ៉ើម តៃ ឋាំ យ៉ាក់ តង៉ៃ អ៊ែ គ្រែដៃ ឡើ ពឝ៉ើត លែក ដើ អិះ ចឹះ ឡើយ អ៊ែ ឡើ ព្រឹង ឡើ បើម យ៉ាវ កាន។ ");
INSERT INTO brb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","អន់នែ ឡើយ បាត់ កណើត ឡាង គ្រែ ឡាង ប្រិះ។ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពឝ៉ើត ឡាង គ្រែ ដើម ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ទឹង អ៊ែ ឡាង ប្រិះ នែ ញឹះ តៃ ដាន់ ប៊ិច អំម៉ឹះ តើម ឡង ឞ លំហួន ហឹ ត្រិញ សំយ៉ះ បាត់ មូយ ឡង ណាគ់ តៃ ឡើ ហួន អំម៉ឹះ ប៉ាគ់ទឺ យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច តៃ ដាន់ ឡើ អាំ ប៊ិច អំមឺ ទិ ឡាង ប្រិះ នែ ដើម ញឹះ តៃ ប៊ិច អំម៉ឹះ បនឹះ មន់បើម មឺរ ណា ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","វ៉ិះ ឡើ ប៊ិច ឌិវ អអួត ឡើ ញឺះ តើម ចុ ប្រិះ អ៊ែ ឡើ ប៊ិច ស្រ៊ិវ ឡើ ត្រដាក ប៊ិង ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ចក់ ក្រលៀត អន់ទឹក ប្រិះ ឡើ ម៉ាន បើម បនឹះ ។ ប៊្លី អ៊ែ ឡើ ខូម តមឹត កយឺវ ឆ្រញិវ តៃ ត្រម មុះ ណគ អ៊ែ បនឹះ ឡើ ញិវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ បើម មឺរ ដណាំ ហឹ ប៊្រី ដាក អ៊ែឌែន តៃ ម៉ាត់ តង៉ៃ ឌឹក។ ប៊្លី អ៊ែ ឡើ ចក់ បនឹះ ណគ់ ឡើ ម៉ាន ឡើ ដក់ ជុ អាំ លន់គូ ហឹ មឺរ ដណាំ។ ");
INSERT INTO brb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពហួន តើម ឡង ត្រំ ហំឞ្លិច តើម ប៊ឹង ប្រិះ តើម ឡង នែ ចាគ់ ដអ៊ី ប៉្លៃ ណគ ឡើ ញឹម ដិ។ ទឹង កឌី មឺរ ឡើ ប៊ិច តើម ឡង បារ តើម ឡង មូយ ឡើ បើម អាំ បនឹះ មន់ញិវ ឡូច អន់សច តើម ឡង មូយ ឡើ បើម អាំ បនឹះ មន់ហឝ៉ាវ កាន យូច ត្រ។ ");
INSERT INTO brb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ឡើ ប៊ិច ដណៃ មូយ តើម ប៊ឹង ប៊្រី ដាក អ៊ែឌែន ឡើ លូះ ឈ្រីប ប៉ុះ មឺរ ដណាំ ប៊្លី អ៊ែ ឡើ លូះ អ្រឡះ ពួន ចំបាះ។ ");
INSERT INTO brb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ចំបាះ ដណៃ ទី មូយ នែ ម៉ើ ជុ ពីសុន។ ដណៃ អន់នែ ឡើយ ឡើ លូះ វៀន ប៊្រី ដាក ហាវីឡា ប៊្រី ដាក ឡើ ប៊ិច ឆៀង។ ");
INSERT INTO brb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ឆៀង ប៊្រី ដាក នែ ឡើ ឆៀង គែន។ ទឹង អ៊ែ ឡើ ប៊ិច ឆារ់ ឡង គ្លឹម ដើម គែវ ច្រណាប់ៗ។ ");
INSERT INTO brb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ដណៃ ទី បារ ម៉ើ ជុ ឝីហូន ដណៃ នែ ឡើ លូះ វៀន ប៊្រី ដាក គូះ។ ");
INSERT INTO brb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ដណៃ ទី ពែ ម៉ើ ជុ ហ៊ីឌែគែល។ ដណៃ អន់នែ ឡើ លូះ តៃ ម៉ាត់ តង៉ៃ ឌឹក មួង អាសើរ។ ដណៃ ទី ពួន ម៉ើ ជុ អើប៉្រាត។ ");
INSERT INTO brb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ដក់ ជុ ប្រយ បនឹះ អ៊ែ ម៉ាត់ ណគ អាដាំ លន់គូ ហឹ មឺរ អ៊ែឌែន បក់ អាំ លំពពឹត បបើម ដើម លំរន់ឋាប់ ឝ្លាំង មឺរ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ណគ រៀន៖ «ហន់ចា លែក ដើ ប៉្លៃ ឡង ទឹង មឺរ តាម ឌី ហកឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ហាក់ ប៊ិច មូយ តើម ញ៉ង ហន់ចា ណគ់ តើម ហឝ៉ាវ កាន យូច ត្រ។ ប៉ាគ់ ហន់ចា ប៉្លៃ ឡង អ៊ែ ហន់គែត ម៉ាត់ ម៉ាត »។ ");
INSERT INTO brb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «បនឹះ នែ លន់គូ មូយ រ៉ា ណគ ប៉ាគ់ នែ ប៉ិន អ៊ឺម។ អៃ អំពឝ៉ើត មូយ រ៉ា ឡឹះ បក់ លន់គូ អរែង ដុ អន់ដុ ប៉ូរ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ចក់ ពដិះ ឡើ ម៉ាន លែក ដើ ពត្រូវ ម៉ើ ដក់ ពឺង ឡាង ប្រិះ ត្រំ ហំឞ្លិច ដើម ជែម ចណាយ ត្រំ ហំឞ្លិច ដិ ម៉ើ ប៉ារ់ ទឹង គ្រែ។ ប៊្លី អ៊ែ ឡើ តៀត ពត្រូវ លែក ដើ អ៊ែ ហឹ អាដាំ បក់ លំណោះ រៀន អាដាំ លំជុ ម៉ាត់ ពត្រូវ អ៊ែ ប៉ាគ់ ង៉ាយ កតាម។ ប៉ាគ់ ពអ៊ែ ពត្រូវ លែក អ៊ែ ម៉ើ ប៊ិច ម៉ាត់ តាម អាដាំ ឡើ ជុ។ ");
INSERT INTO brb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","អ៊ែ អាដាំ ឡើ ជុ ម៉ាត់ លែក ពត្រូវ ស៊្រុក ពត្រូវ ប៊្រី ជែម ចណាយ ម៉ើ ប៉ារ់ ទឹង គ្រែ ត្រំ ហំឞ្លិច ហាក់ គ្រែដៃ តៃ ឡើ តៃ អ៊ឺម ពត្រូវ អង់ង៉ាយ លំណោះ គូ ដុ អន់ដុ ប៉ូរ អាដាំ។ ");
INSERT INTO brb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ប៉ាគ់ ពអ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ បើម អាំ អាដាំ ហង់ង៉ាន់ តៀក។ អ៊ែ ឡើ ចក់ កឌឺង ចអ តើម ប៊ឹង ណគ។ ប៊្លី អ៊ែ ឡើ កឈិប ហឹ ទឺ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ចក់ កឌឺង ចអ ណគ់ ណគ ឡើ ហួត តើម ប៊ឹង អាដាំ ឡើ ម៉ាន កទ្រី អ៊ែ ឡើ ដក់ តៀត ហឹ អាដាំ។ ");
INSERT INTO brb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","អ៊ែ អាដាំ ឡើ ម៉ាង រៀន៖ «ណគ់ កឌឺង នែ តើម ប៊ឹង កឌឺង អៃ ណគ់ ច្រឡាត ម៉ាត អន់នែ តើម ប៊ឹង ច្រឡាត ម៉ាត អៃ អ៊ែ អំជុ ណគ រៀន “កទ្រី” យ៉ាក់ កទ្រី នែ គ្រែដៃ ឡើ ម៉ាន តើម ប៊ឹង កឡ »។ ");
INSERT INTO brb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ញ៉ន អ៊ែ ឡើយ មែ កឡ មន់វីះ តើម ប៊ឹង មែគ បើគ ដក់ កី គូ អរែង ប៊ឹង ទ្រី អ៊ែ អំប្រា នែ អំប្រា ចាក់ ដៃ ឌិវ មូយ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ទឹង អ៊ែ អាដាំ អំប្រា ទ្រី ណគ នែ ណាគ់ អំប្រា គូ ហំប្រាតៗ ញឹះ តៃ អំប្រា ណោះ កម៉ាវ អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ប៊ិះ នែ ឡើ ពត្រូវ ប៊ិច ផញ៉ា តបូត ជឺរ ពត្រូវ ប៊្រី អង់គែងៗ ណគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពឝ៉ើត។ អ៊ែ ឡើ ដក់ តង៉ា កទ្រី រៀន៖ «អើយ ណាង ពយ៉ិ ដាវ ឡះ គ្រែដៃ ឡើ កំប៊ែត សប្រា ចា លែក ដើ ប៉្លៃ ឡង ទឹង កនុង មឺរ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","កទ្រី ឡើ ត្រណើវ រៀន៖ «លែក ដើ ប៉្លៃ ទឹង មឺរ ណគ់ អន់នែ ញន់ចា ដូវ ");
INSERT INTO brb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","វ៉ិះ ឌិវ ប៉្លៃ ឡង មូយ តើម ទឹង កឌី មឺរ គ្រែដៃ ឡើ កំប៊ែត រៀន “ញ៉ង សប្រា ចា ញ៉ង សប្រា ពឹត ប៉្លៃ អន់នែ យ៉ឹ ប៉ាគ់ តៃ សប្រា លន់ចាប់ សប្រា លន់គែត”»។ ");
INSERT INTO brb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ប៊ឹង អ៊ែ ប៊ិះ ឡើ ហាយ ដើ កទ្រី រៀន៖ «អ៊ឺម! សប្រា លន់គែត អឹ។ ");
INSERT INTO brb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ហាក់ គ្រែដៃ ឡើ ណោះ រៀន ប៉ាគ់ តង៉ៃ ង៉ាយ សប្រា លន់ចា ប៉្លៃ ឡង នែ អ៊ែ ចនិះ សប្រា លំឝ៉ាល អ៊ែ សប្រា លំប៊ិច អ្រណោះ ប៉ាគ់ គ្រែដៃ ទឺ សប្រា លំហង់ឝ៉ាវ កាន យូច កាន ត្រ»។ ");
INSERT INTO brb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ហំប៊្រុះ ដើ អ៊ែ កទ្រី ឡើ ឝ្លាំង ហឹ តើម ឡង ឡើ តៃ ចាគ់ ដអ៊ី ហន់ដឹប ប៉្លៃ ណគ ហរ៉គ់ លំញឹម បើម ងុញ ចា អ៊ែ លំប៊ិច អ្រណោះ អ្រទីង ហ្រឡិច ហ្រឡាង។ អ៊ែ កទ្រី ឡើ ប៉ិះ ចា ប្រយ ប៉្លៃ ដើម ឡើ អាំ ដើ ក្ល ណគ ឡើ គូ ប៊ឹង ណគ ដិ អ៊ែ ក្ល ណគ ឡើ ចា ប៉ាគ់ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ហំប៊្រុះ ដអ៊ែ ចនិះ អំប្រា ឡើ ឝ៉ាល ប្រយ ដើម អំប្រា ណោះ ចាក់ អំប្រា គូ ហំប្រាតៗ។ អ៊ែ អំប្រា ប៉ិះ ហឡា កប៉ក់ ឝ៉្លិះ បើម ប្រវ៉ើន។ ");
INSERT INTO brb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","តគ់ ឡើ អំប៊ឹ ទឹង កយឺវ ពឹក ហើប អង់ហើប អំប្រា ដុង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ដក់ ទឹង មឺរ អ៊ែ អំប្រា ដក់ ក្រាប់ កដក ចាក់ ប៊ឹង ឡង ទឹង មឺរ ញ៉ង អាំ គ្រែដៃ ឡើ ណាគ់ អន់សច លំតៃ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កឡូវ អាដាំ រៀន៖ «អើយ អាដាំ ហឹ ង៉ាយ ហគូ?»។ ");
INSERT INTO brb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ណគ ឡើ ត្រណើវ រៀន៖ «អៃ អដុង ហៃ ហដក់ ទឹង មឺរ អឌូង ទុត ខាក់ យ៉ាក់ អគូ ហំប្រាតៗ អ៊ែ អក្រាប់»។ ");
INSERT INTO brb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តង៉ា រៀន៖ «មែ ង៉ាយ ម៉ើ ពហាយ ដើ ហៃ ហគូ ហំប្រាត? ហចា ប៉្លៃ ឡង ណគ់ អៃ អកំប៊ែត នែ កឋោះ?»។ ");
INSERT INTO brb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","អាដាំ ឡើ ត្រណើវ រៀន៖ «កទ្រី ណគ់ ហៃ ហអាំ ឡើ គូ ប៊ឹង អៃ ឡើយ ឡើ អាំ ប៉្លៃ ដើ អៃ អ៊ែ អចា»។ ");
INSERT INTO brb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ដើ កទ្រី រៀន៖ «ប៉ិ ឡើ ត្រ ហបើម ប៉ាគ់ នែ?»។ កទ្រី ឡើ ត្រណើវ រៀន៖ «យ៉ាក់ ប៊ិះ ឡើ តបូត អៃ អ៊ែ អចា ប៉្លៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ ប៊ិះ រៀន៖ «យ៉ាក់ ហៃ ហបើម ប៉ាគ់ នែ លែក ទឹង កនុង ពត្រូវ ស៊្រុក ដើម ពត្រូវ ប៊្រី វ៉ិះ ឌិវ ហៃ ឡើយ ហន់ត្រ ពន់ដ្រាយ អៃ។ អ៊ែ ហន់វ៉ារ ដើ គ្រឹក ដើម ហន់ចា ក្រលៀត ប្រិះ ឆា ដើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","អៃ អំបើម អាំ ហៃ ដើម កទ្រី ដើម កួន ចូវ ហៃ ដឹប កួន ចូវ កទ្រី វន់ដ្រម៉ា ប្លះ វែ កួន ចូវ កទ្រី លំឆាន់ ទូះ ហៃ អ៊ែ ហៃ ហន់កាប់ កដើវ ឈឹង កួន ចូវ កទ្រី»។ ");
INSERT INTO brb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ហឹ កទ្រី រៀន៖ «ប៊ឹង ហន់តមែវ ដើម ហន់អន់ឆិ អៃ អំប៉្រៃ អាំ ហៃ ហន់ដុង ឈិ ដុ ធុក ញ៉ាក ប៉ាក ម៉ង តៃ ឋាំ។ ហាក់ ចនិះ ហៃ ណាគ់ ហន់តង កាន ក្ល ដឌែ។ អ៊ែ ដើ ក្ល ហៃ លំបើម កន់ដ្រាគ់ ពឺង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ហឹ អាដាំ រៀន៖ «យ៉ាក់ ហចង់ហៀង ម៉ាង ទ្រី ហៃ ហចា ប៉្លៃ ឡង ណគ់ អៃ អកំប៊ែត នែ អ៊ែ ណគ់ ប្រិះ លំត្រ ពន់ដ្រាយ ញ៉ន ដើ ហៃ។ អ៊ែ ហន់ត្រ ចៀម ចាក់ បើម មឺរ ណា ចះ ប្រិះ អក ឡង ធុក ញ៉ាក ប៉ាក ម៉ង ត្រំ តង៉ៃ ឆា ដើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ណគ់ ប្រិះ លំហួន ម៉ាត់តូវ បាត់ ដើម ឆ្រឡា។ ហន់ត្រ បើម មឺរ ណា អ៊ែ ហន់ចា ដណាំ ដណូយ ណគ់ ឡើ ហួន ទឹង មឺរ ហៃ ។ ");
INSERT INTO brb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ហៃ ហន់ត្រ ដាំង ចា ចៀម ចាក់ តូវ សាវ បះ តះ កូះ ជុះ ផូរ តូរ ដុ ឆា ដើ ប៊ឹះ តង៉ៃ ហន់វឹរ ប្រិះ ទឺ។ យ៉ាក់ អៃ អម៉ាន ហៃ ដើ ប្រិះ អ៊ែ ហន់វឹរ ប្រិះ ទឺ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","អាដាំ ឡើ ជុ ម៉ាត់ ទ្រី ណគ រៀន “អ៊ែវ៉ា” យ៉ាក់ ណាង អ៊ែវ៉ា នែ ឡើយ មែគ បនឹះ លែក រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ចក់ ហំបក ពត្រូវ ឡើ បើម ប្រវ៉ើន ហណក ដើ យ៉ាគ់ អាដាំ អំប្រា ទ្រី ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «ណិះៗ នែ មែ បនឹះ ម៉ើ ហឝ៉ាវ កាន យូច ត្រ ប៉ាគ់ ដើ អៃ ទឺ ឡើយ ប៉ាគ់ ពអ៊ែ តង អំកន់ឌឹង មែ ញ៉ង អាំ មន់ដក់ អវ៉ើន ប៉ិះ ប៉្លៃ តើម ឡង ឆ្រញិវ ឡឹះ អន់ណាវ កឡាគ់ មន់ចា ហន់ណូវ មន់ញិវ ឡូច អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ប៉ាគ់ ពអ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តវីះ អំប្រា តើម ប៊ឹង មឺរ អ៊ែឌែន បក់ អាំ អំប្រា លំពពឹត បបើម ហឹ ប្រិះ ណគ់ គ្រែដៃ ឡើ ចក់ ម៉ាន អាដាំ អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ប៊្លី ឡើ ពន់ឌ្រុះ អំប្រា តើម ប៊ឹង មឺរ អ៊ែឌែន លែវ ឡើយ គ្រែដៃ ឡើ ជុ ជែរូប៊ីន គូ ចាំ ញ៉ាម មឺរ តៃ ម៉ាត់ តង៉ៃ ឌឹក ដើម ប៊ិច តាវ អ៊ុញ ត្រវ៉ិល ប្លះ អ៊ែ កន់ឌឹង ទ្រូង តៃ អាំ បនឹះ មន់ដក់ មឹត ប៉ិះ ប៉្លៃ ឡង ឆ្រញិវ។ ");
INSERT INTO brb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","យ៉ាគ់ អាដាំ ឡើ កី គូ ប៊ឹង ទ្រី ណគ ណាង អ៊ែវ៉ា អ៊ែ ណាង ឡើ តមែវ ប្រយ។ ឡើ អន់ឆិ កួន កឡ មូយ ឡើ ជុ ម៉ាត់ កួន ណគ កាអ៊ីន។ ណាង ឡើ ម៉ាង រៀន៖ «អៃ អប៊ិច កួន កឡ មូយ យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ អាំ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ណាង ឡើ ប៊ិច ឡឹះ កួន កឡ មូយ ឡើ ជុ ម៉ាត់ ណគ អ៊ែបិល អោះ កាអ៊ីន។ តគ់ អំប្រា ទិះ អន់ឆើន អើន កម៉ ឡើយ ដើ អ៊ែបិល ឡើ ពែក បប៊ែ ចៀម អ៊ែ ណគ់ ដើ កាអ៊ីន អន់ណាវ ឡើ បើម មឺរ បើម ណា។ ");
INSERT INTO brb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","តគ់ តង៉ៃ ហង់អ៊ិន កាអ៊ីន ឡើ ចក់ ចិះ ភែ ពឺរ ប៉្លៃ តើម ប៊ឹង មឺរ ណា ណគ អ៊ែ ឡើ ម៉ប ថួយ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","អ៊ែ ដើ អ៊ែបិល ឡើ កជែត កួន បប៊ែ ចៀម ណគ ណគ់ ឡង់ៗ អ៊ែ ឡើ តៀត ច្រឡាត ឝ៉ម ពុក ម៉ប ថួយ ប៉ាគ់ទឺ។ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ញឹម ក្លើម ដើ អ៊ែបិល ដើម ថនួយ ណគ ");
INSERT INTO brb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ហាក់ ឡើ ញឹម ក្លើម អ៊ឺម ដើ កាអ៊ីន ដើម ដើ ថនួយ ណគ។ អ៊ែ កាអ៊ីន ឡើ មាំ ទុត ខាក់ ញឹះ ឡើ ចះ មុះ ម៉ាត់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ដើ កាអ៊ីន រៀន៖ «ប៉ិ ឡើ ត្រ ហមាំ ប៉ាគ់ នែ? ប៉ិ ឡើ ត្រ ហមាំ ញឹះ ចះ មុះ ម៉ាត់ ឞាល់ នែ? ");
INSERT INTO brb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ប៉ាគ់ ហំបើម អន់ចាគ់ អ៊ែ ហន់ញឹម ក្លើម ក្លាក អន់ណាវ ហាក់ ប៉ាគ់ តៃ ហំបើម អន់ចាគ់ អ៊ឺម ឞាប ឡើ ចាំ ម៉ុន ប៊ឹង ឝឡោះ ហៃ បក់ លំពស៊ឹច ហៃ អាំ ហំបើម តាម ណគ ហាក់ ហៃ ហន់ត្រ ពញ៉ម តវឹញ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","តគ់ ប៊្លី អ៊ែ កាអ៊ីន ឡើ ច្រា អោះ ណគ អ៊ែបិល ដក់ ហឹ មឺរ។ ហំប៊្រុះ អំប្រា ប៊ឹះ តគ់ អ៊ែ កាអ៊ីន កអវ ឡើ ដ្រម ជ្រូម ប៊ឹម កជែត ប្រយ អោះ ណគ គែត តាក់។ ");
INSERT INTO brb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តង៉ា កាអ៊ីន រៀន៖ «អើយ កាអ៊ីន ហឹ ង៉ាយ អោះ ហៃ អ៊ែបិល?»។ កាអ៊ីន ឡើ ត្រណើវ រៀន៖ «អណោះ អ៊ឺម អៃ! អៃ ឞិ អក្រនូ ឝ្លាំង ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «ពយ៉ិ ឡើ ត្រ ហបើម ដើ អោះ ហៃ ញឹះ ឞាល់ នែ? អៃ អដុង ឡើយ ផាម ផូរ អោះ ហៃ ឡើ លូះ ទិ ប្រិះ ឡើ ហរ៉ាវ តើម ចុ អ៊ែ ឡើ ប៉្រៃ អៃ អន់តូវ បឹ ឡើ កជែត ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ណិះៗ នែ ហៃ ហន់ត្រ ពន់ដ្រាយ ឡើយ ហៃ ហន់ត្រ វីះ គូ ចង៉ាយៗ តើម ប៊ឹង ប្រិះ ណគ់ ឡើ ឈ្រីប ផាម អោះ ហៃ ណគ់ ហកជែត ដើ ទី ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ប៊ឹង ហំបើម មឺរ ណា ពដិះ លន់ចាគ់ យ៉ាវ ហន់ដូវ អ៊ឺម ដណាំ ដណូយ អ៊ែ ណគ់ ដើ ហៃ ហន់ត្រ បនឹះ វែរ វ៉ារ់ មូយ រ៉ា មូយ រិន ពឺង ឡាង ប្រិះ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","កាអ៊ីន ឡើ ត្រណើវ ប្រម៉ាង គ្រែដៃ ឡើ ណាគ់ អន់សច រៀន៖ «គ្រែដៃ អើយ ហពថូត អៃ ញឹះ ឞាល់ អ៊ិន កយឹក ម៉ៃ ហ៊ែត ឡើយ បក់ អ៊ឺម អៃ ឞាល់ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","តង៉ៃ នែ ហតវីះ អៃ តើម ប៊ឹង ពដិះ អន់នែ អន់ត្រ វីះ ចង៉ាយ តើម ប៊ឹង ម៉ាត់ ហៃ អន់វឹរ បនឹះ វែរ វ៉ារ់ មូយ រ៉ា មូយ រិន ទិ ឡាង ប្រិះ នែ។ ប៉ាគ់ មន់ជូល អៃ អាត មន់កជែត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ដើ ណគ រៀន៖ «អ៊ឺម ប៉ាគ់ មែ ង៉ាយ មន់កជែត ហៃ អៃ អន់កជែត តូវ ពតាង ហៃ ប៉ឹះ រ៉ា អន់ណាវ»។ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ឡច កាអ៊ីន បក់ មន់ហង់ឝ៉ាវ ប៉ាគ់ មន់ជូល ណគ ញ៉ង អាំ មន់កជែត។ ");
INSERT INTO brb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ប៊្លី អ៊ែ កាអ៊ីន ឡើ វីះ ចង៉ាយ តើម ប៊ឹង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ដក់ គូ ហឹ ប៊្រី ដាក ណូត តៃ ម៉ាត់ តង៉ៃ ឌឹក ស្រុក អ៊ែឌែន។ ");
INSERT INTO brb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","យ៉ាគ់ កាអ៊ីន ឡើ កី គូ អរែង ប៊ឹង ទ្រី ណគ អ៊ែ ទ្រី ណគ ឡើ តមែវ ឡើ ប៊ិច កួន កឡ មូយ ឡើ ជុ ម៉ាត់ កួន ណគ ហ៊ែណុក។ ប៊្លី អ៊ែ កាអ៊ីន ឡើ ពឝ៉ើត មួង មូយ ឡើ ជុ មួង អ៊ែ ហ៊ែណុក តាម ប៉ាគ់ ម៉ាត់ កួន ណគ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","យ៉ាគ់ ហ៊ែណុក ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ អ៊ីរ៉ាត អ៊ែ យ៉ាគ់ អ៊ីរ៉ាត ឡើ ពឝ៉ើត មីហ៊ូយែល មីហ៊ូយែល ឡើ ពឝ៉ើត មីទូស៊ែល មីទូស៊ែល ឡើ ពឝ៉ើត ឡាមែក។ ");
INSERT INTO brb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","យ៉ាគ់ ឡាមែក ឡើ ចក់ ទ្រី បារ មូយ ម៉ាត់ ណគ ណាង អាដះ ណគ់ មូយ រ៉ា អន់ណាវ ម៉ាត់ ណគ ណាង ស៊ីឡា។ ");
INSERT INTO brb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ណាង អាដះ ឡើ ពឝ៉ើត កួន កឡ មូយ ម៉ាត់ ណគ យ៉ាបាល ឡើ ត្រ ម៉ិ យ៉ាគ់ បូវ ម៉ើ ខើយ គូ ហន់ណាម កទូប ដើម ម៉ើ ពែក បណាន់។ ");
INSERT INTO brb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","អោះ យ៉ាគ់ យ៉ាបាល ម៉ាត់ ណគ យ៉ាគ់ យូបាល ឡើ ត្រ ម៉ិ យ៉ាគ់ បូវ មែ ម៉ើ ខើយ រ៉ិះ កតិង រ៉ិង ដ្រ ខូម បហវ។ ");
INSERT INTO brb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","អ៊ែ ដើ ណាង ស៊ីឡា អន់ណាវ ឡើ ពឝ៉ើត ប៉ាគ់ទឺ កួន ម៉ាត់ ណគ ទូបាល-កាអ៊ីន ឡើ ត្រ ម៉ិ យ៉ាគ់ កឡា ណោះ សស៊ូក មម៉ាន កង់ ដើម ម៉ាម។ អោះ កទ្រី យ៉ាគ់ ទូបាល-កាអ៊ីន ម៉ាត់ ណគ ណាង ណាអាម៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","យ៉ាគ់ ឡាមែក ឡើ ហាយ ហឹ ទ្រី ណគ លែក បារ រៀន៖ «អាដះ ស៊ីឡា អើយ សប្រា លន់ចង់ហៀង ប្រម៉ាង អៃ យ៉ឹ! ទ្រី ឡាមែក អើយ សប្រា លន់ចង់ហៀង ហឡាក់ៗ ម៉ាង អៃ! អកជែត បឹ តង់កង់ មូយ រ៉ា ញ៉ន ឡើ បើម អំប៊ឺក អៃ។ អកជែត ច្រហើវ មូយ រ៉ា ញ៉ន ដើ ឡើ បឹត អៃ ញឹះ ឡើ ង៉ូម។ ");
INSERT INTO brb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ប៉ាគ់ មែ ង៉ាយ មន់កជែត កាអ៊ីន អ៊ែ គ្រែដៃ លន់កជែត តូវ ប៉ឹះ រ៉ា អន់ណាវ ហាក់ ប៉ាគ់ មែ ង៉ាយ មន់កជែត ឡាមែក អ៊ែ លំត្រ មន់កជែត តូវ ប៉ឹះ ជិត ប៉ឹះ រ៉ា អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","យ៉ាគ់ អាដាំ ឡើ កី គូ ប៊ឹង ទ្រី ណគ អ៊ែ ណាង ឡើ ប៊ិច កួន កឡ មូយ អន់ណាវ ឡើ ជុ ម៉ាត់ ណគ ស៊ែត យ៉ាក់ ណាង ឡើ រៀន៖ «គ្រែដៃ ឡើ អាំ កួន ដើ អៃ មូយ ឡឹះ អន់ណាវ បក់ លំថរ កយ៉ក់ អ៊ែបិល ណគ់ កាអ៊ីន ឡើ កជែត»។ ");
INSERT INTO brb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","យ៉ាគ់ ស៊ែត ឡើ ប៊ិច កួន កឡ មូយ ឡើ ជុ ម៉ាត់ កួន ណគ អ៊ែណុះ។ តើម ប៊ឹង អ៊ែ ឡើយ បនឹះ ម៉ើ ពន់តើម កឡូវ អ៊ឺរ ដាំង ម៉ាត់ គ្រែដៃ ម៉ើ ជុ រៀន គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","អន់នែ ព្រតយ ម៉ាត់ កួន ចូវ យ៉ាគ់ អាដាំ។ ទឹង តង៉ៃ គ្រែដៃ ឡើ ពឝ៉ើត បនឹះ គ្រែដៃ ឡើ ពឝ៉ើត បនឹះ ប៉ាគ់ ណគ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","គ្រែដៃ ឡើ ពឝ៉ើត កឡ ដើម កទ្រី អ៊ែ ឡើ ប្រាយ អាំ ដើ មែ។ ប៊្លី គ្រែដៃ ឡើ ពឝ៉ើត មែ ណគ ឡើ ជុ មែ «បនឹះ»។ ");
INSERT INTO brb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ប៊ឹង យ៉ាគ់ អាដាំ កំប្រាគ់ ណគ មូយ ក្លាំ ពែ ជិត កម៉ អ៊ែ ឡើ ពឝ៉ើត កួន កឡ មូយ ឡើ ហមឺ ប៉ាគ់ ណគ កឡឹ ឡើ សន់ឋៀវ ប៉ាគ់ ចាក់ ណគ កឡឹ ទឺ។ ឡើ ជុ ម៉ាត់ កួន ណគ ស៊ែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ប៊្លី យ៉ាគ់ ស៊ែត ឡើ កើត យ៉ាគ់ អាដាំ ណាគ់ ឡើ ញិវ ថាម ក្លាំ កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ជែន ក្លាំ ពែ ជិត កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","តគ់ យ៉ាគ់ ស៊ែត កំប្រាគ់ ណគ មូយ ក្លាំ សើង កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ អ៊ែណុះ។ ");
INSERT INTO brb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ប៊្លី អ៊ែណុះ ឡើ កើត យ៉ាគ់ ស៊ែត ណាគ់ ឡើ ញិវ ថាម ក្លាំ ប៉ឹះ កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ជែន ក្លាំ ជិត បារ កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","តគ់ យ៉ាគ់ អ៊ែណុះ កំប្រាគ់ ណគ ជែន ជិត កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ កៃណាន។ ");
INSERT INTO brb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ប៊្លី កៃណាន ឡើ កើត ឡើយ យ៉ាគ់ អ៊ែណុះ ណាគ់ ឡើ ញិវ ថាម ក្លាំ ជិត សើង កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ជែន ក្លាំ សើង កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","តគ់ យ៉ាគ់ កៃណាន កំប្រាគ់ ណគ ប៉ឹះ ជិត កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ ម៉ាលែលៀល។ ");
INSERT INTO brb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ប៊្លី យ៉ាគ់ ម៉ាលែលៀល ឡើ កើត ឡើយ យ៉ាគ់ កៃណាន ណាគ់ ឡើ ញិវ ថាម ក្លាំ ពួន ជិត កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ជែន ក្លាំ ជិត កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","តគ់ យ៉ាគ់ ម៉ាលែលៀល កំប្រាគ់ ណគ ត្រូវ ជិត សើង កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ យ៉ារែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ប៊្លី យ៉ាគ់ យ៉ារែត ឡើ កើត ឡើយ យ៉ាគ់ ម៉ាលែលៀល ណាគ់ ឡើ ញិវ ថាម ក្លាំ ពែ ជិត កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ថាម ក្លាំ ជែន ជិត សើង កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ប៊ឹង យ៉ាគ់ យ៉ារែត កំប្រាគ់ ណគ មូយ ក្លាំ ត្រូវ ជិត បារ កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ ហ៊ែណុក។ ");
INSERT INTO brb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ប៊្លី យ៉ាគ់ ហ៊ែណុក ឡើ កើត ឡើយ យ៉ាគ់ យ៉ារែត ណាគ់ ឡើ ញិវ ថាម ក្លាំ កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ជែន ក្លាំ ត្រូវ ជិត បារ កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ប៊ឹង យ៉ាគ់ ហ៊ែណុក កំប្រាគ់ ណគ ត្រូវ ជិត សើង កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ ម៉ាត់ធូសាឡា។ ");
INSERT INTO brb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ប៊្លី យ៉ាគ់ ម៉ាត់ធូសាឡា ឡើ កើត ឡើយ យ៉ាគ់ ហ៊ែណុក ឡើ បើម តាម ប្រម៉ើត គ្រែដៃ លែក ពែ ក្លាំ កម៉ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន ");
INSERT INTO brb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ពែ ក្លាំ ត្រូវ ជិត សើង កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","យ៉ាគ់ ហ៊ែណុក ឡើ បើម តាម ប្រម៉ើត គ្រែដៃ។ តគ់ ប៊្លី អ៊ែ ម៉ើ តៃ យ៉ាវ ណគ យ៉ាក់ គ្រែដៃ ឡើ ប៊្រឹក ឡើយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","តគ់ យ៉ាគ់ ម៉ាត់ធូសាឡា កំប្រាគ់ ណគ មូយ ក្លាំ ថាម ជិត ប៉ឹះ កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ ម៉ាត់ ណគ ឡាមែក។ ");
INSERT INTO brb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ប៊្លី យ៉ាគ់ ឡាមែក ឡើ កើត ឡើយ យ៉ាគ់ ម៉ាត់ធូសាឡា ណាគ់ ឡើ ញិវ ប៉ឹះ ក្លាំ ថាម ជិត បារ កម៉ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ជែន ក្លាំ ត្រូវ ជិត ជែន កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","តគ់ យ៉ាគ់ ឡាមែក កំប្រាគ់ ណគ មូយ ក្លាំ ថាម ជិត បារ កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ មូយ។ ");
INSERT INTO brb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ឡើ ជុ ម៉ាត់ កួន ណគ “ណូអ៊ែ” យ៉ាក់ ឡើ ម៉ាង រៀន៖ «កួន អន់នែ លំពញឹម ក្លើម ង៉ាយ កនុង កាន ពពឹត បបើម សាវបះ តះ កូះ ង៉ាយ ញ៉ន ដើ ប្រិះ គ្រែដៃ ឡើ ប្រាយ ប៊្រិត ពន់ឋើម»។ ");
INSERT INTO brb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ប៊្លី យ៉ាគ់ ណូអ៊ែ ឡើ កើត ឡើយ យ៉ាគ់ ឡាមែក ណាគ់ ឡើ ញិវ សើង ក្លាំ ជែន ជិត សើង កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ប៊ិច កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","លែក ដើ អ៊ែ កំប្រាគ់ ណគ ប៉ឹះ ក្លាំ ប៉ឹះ ជិត ប៉ឹះ កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","តគ់ យ៉ាគ់ ណូអ៊ែ កំប្រាគ់ ណគ សើង ក្លាំ កម៉ អ៊ែ ឡើ ប៊ិច កួន កឡ ពែ រ៉ា សិម ហាំ ដើម យ៉ាភែត។ ");
INSERT INTO brb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ទឹង បនឹះ ម៉ើ ចាំ អើន ចាំ ប៊ិង ឡាង ប្រិះ អ៊ែ ម៉ើ ប៊ិច កួន កទ្រី ទុត អើន ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","បូវ កួន កឡ គ្រែដៃ ម៉ើ តៃ កួន កទ្រី មែ បនឹះ ម៉ើ ត្រចាគ់ ហ្រហ៊ែ ហ្រហាវ អ៊ែ ម៉ើ ចក់ បើម ទ្រី ប្រយ តាម ប្រម៉ើត មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «សណើម ឆ្រញិវ អៃ តៃ លន់គូ អ៊ឺម ប៊ឹង បនឹះ អន់សច យ៉ាក់ មែ ឝ៉ាន់ ម៉ើ បនឹះ មិៗ ចាក់ ដៃ មែ មន់ត្រ គែត សុ។ ណិះៗ នែ អញុ មែ អំជុ ទុត លំអើន ឌិវ មូយ ក្លាំ បារ ជិត កម៉»។ ");
INSERT INTO brb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ទឹង ប៉ាង អ៊ែ ឡើ ប៊ិច បនឹះ ត្រទិះៗ ម៉ើ គូ ពឺង ឡាង ប្រិះ នែ តគ់ ប៊្លី អ៊ែ ណាគ់ ប៊ិច ប៉ាគ់ទឺ។ មែ លែក អ៊ែ ម៉ើ កើត ទឹង ហ្រណើង កួន កឡ គ្រែដៃ ម៉ើ ចក់ កួន កទ្រី បនឹះ ម៉ើ បើម ទ្រី អ៊ែ ម៉ើ ពឝ៉ើត កួន។ កួន មែ លែក អ៊ែ ឡើយ ទឹង ឡៃ មាំង ម៉ើ ប្រិញ ថាំង ដើម ឡើ លឺ អន់តើរ ម៉ាត់ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តៃ រៀន បនឹះ ពឺង ឡាង ប្រិះ ម៉ើ បើម តៃ ចាគ់ ហ៊ែង ចាំ ម៉ៃៗ។ ចនិះ មែ ម៉ើ ឃឹត វ៉ិះ ឌិវ កាន តៃ ចាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ធឹច អំមួញ បនឹះ ណគ់ ណគ ឡើ ពឝ៉ើត ពឺង ឡាង ប្រិះ នែ អ៊ែ ឡើ បើម តង៉ូក ឆ្រុក ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ប៉ាគ់ ពអ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «អៃ អំឈូត តប៉ាត់ បនឹះ ណគ់ អពឝ៉ើត នែ អាំ លែក តើម ប៊ឹង ឡាង ប្រិះ តើម ប៊ឹង បនឹះ ឆា ដើ ប៊ឹះ ពត្រូវ ឈឹង ពួន តើម ប៊ឹង ពត្រូវ វ៉ារ ឆា ដើ ប៊ឹះ ជែម ចណាយ ណគ់ ម៉ើ ប៉ារ់ ទឹង គ្រែ យ៉ាក់ អអំមួញ លហម អពឝ៉ើត មែ»។ ");
INSERT INTO brb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ហាក់ ដើ យ៉ាគ់ ណូអ៊ែ នែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ញឹម ក្លើម ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","អន់នែ កាន បាត់ ក្រាន យ៉ាគ់ ណូអ៊ែ។ ទឹង ប៉ាង យ៉ាគ់ ណូអ៊ែ ឡើ ប៊ិច វ៉ិះ ឌិវ យ៉ាគ់ ណូអ៊ែ អិះ ឡើយ ឡើ បនឹះ ចាគ់ ទឹង ត្រ ញឹះ តៃ ឡើ យូច។ យ៉ាគ់ ណូអ៊ែ នែ ឡើ បើម តាម ប្រម៉ើត គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","យ៉ាគ់ ណូអ៊ែ ឡើ ប៊ិច កួន កឡ ពែ រ៉ា សិម ហាំ ដើម យ៉ាភែត។ ");
INSERT INTO brb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ទឹង ប៉ាង អ៊ែ លែក ដើ បនឹះ ទិ ឡាង ប្រិះ នែ ម៉ើ បើម វ៉ិះ ឌិវ កាន តៃ ចាគ់ ប៊ឹង ងឺរ គ្រែដៃ ដើម ម៉ើ អរាំង មាំ ក្លើម ទិះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","គ្រែដៃ ឡើ ឝ្លាំង ទិ ឡាង ប្រិះ ឡើ តៃ វ៉ិះ ឌិវ ឡើ ប៊ិច កាន តៃ ចាគ់ យ៉ាក់ បនឹះ លែក រ៉ា ទិ ឡាង ប្រិះ នែ ម៉ាត់តូវ ម៉ើ បើម កាន តៃ ចាគ់ លែក រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","គ្រែដៃ ឡើ ពហាយ ដើ យ៉ាគ់ ណូអ៊ែ រៀន៖ «អៃ អងុញ ក្រលឺង បនឹះ ដើម ពត្រូវ លែក តាក់ យ៉ាក់ ឡាង ប្រិះ នែ ឡើ ប៊ិង ដើ កាន អរាំង អរ៉ោះ មែ។ ប៉ាគ់ ពអ៊ែ អៃ អំក្រលឺង ពលែក មែ តើម ប៊ឹង ឡាង ប្រិះ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","មិញ ហន់ចក់ ឡង ហ្រឡាង ហំបើម ឌូក ទិះ ។ ឌូក អ៊ិន ហំបើម អើន ខាន់ អ៊ែ ហន់ចក់ ឆារ់ ហន់ឡច ឡារ អាំ បុ ទិ កនុង ដើម តៃ ដៀក។ ");
INSERT INTO brb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ហំបើម ឌូក អ៊ិន ប៉ាគ់ នែ ឝម៉ុះ ណគ ពែ ក្លាំ តវ៉ូវ ព្រឌឹង សើង ជិត តវ៉ូវ ដើម ចំប៊្រូង ពែ ជិត តវ៉ូវ។ ");
INSERT INTO brb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ដើម ហំបើម ពឌុរ ចំប៊្រូង មូយ តវ៉ូវ ពឺង ចម៉ាក ឌូក។ ហំបើម កម៉ង តៃ ដៀក ហំបើម ឌូក អ៊ែ ពែ អន់ឡើ។ ");
INSERT INTO brb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អំពលែប ឡាង ប្រិះ ដើ ដាក អំក្រលឺង លែក ដើ បនឹះ ចម៉ាវ ដើម ពត្រូវ ណគ់ ម៉ើ ប៊ិច ក្លើម សើម ក្រូម ឡាង គ្រែ។ អង់ង៉ាយៗ ពឺង ឡាង ប្រិះ លំត្រ មន់គែត លែក ");
INSERT INTO brb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ហាក់ អៃ អន់ខណាត ខណាំ ប្លះ បា ហំមឹត ទឹង ឌូក ទិះ អរែង ដើ កួន កឡ ហៃ ទ្រី ហៃ ដើម កួន កម៉ាន់ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ហន់តមឹត ពត្រូវ ត្រំ ហំឞ្លិច ទឹង ឌូក ទិះ ប៉ិន ហំប៊្រុកៗ ហន់ត្រ ចក់ កទ្រី កឡៗ អ៊ែ មន់ញិវ អរែង ដើ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ជែម ចណាយ ពត្រូវ ឈឹង ពួន ដើម ពត្រូវ ឆឡរ វ៉ារ ពឺង ឡាង ប្រិះ នែ ប៉ិន ហំប៊្រុក ត្រំ ហំឞ្លិច តាម យូ មូយៗ មន់ដក់ ដាំង ហៃ អ៊ែ មន់ញិវ។ ");
INSERT INTO brb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ហន់រន់ឋាប់ ជុ ចណង់ ចណា ត្រំ ហំឞ្លិច ហន់តៀត ព្រឌុក ដើ វែ កឡឹ វន់ចង់ ចា ដើម ដើ ពត្រូវ មន់ចា ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","យ៉ាគ់ ណូអ៊ែ ឡើ បើម ត្រំ ហំឞ្លិច ម៉ាត់ ម៉ាត តាម ពន់ដ្រៃ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ យ៉ាគ់ ណូអ៊ែ រៀន៖ «អើយ យ៉ាគ់ ណូអ៊ែ លែក ដើ វែ ទឹង ក្រាន ហៃ វន់មឹត ទឹង ឌូក ទិះ យ៉ឹ យ៉ាក់ អតៃ បនឹះ ទឹង ប៉ាង អន់នែ ឡើ ប៊ិច វ៉ិះ ឌិវ ហៃ នែ ឡើយ ហបនឹះ ចាគ់ ទឹង ត្រ។ ");
INSERT INTO brb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","អ៊ែ ហន់តមឹត ពត្រូវ ឈឹង ពួន ណគ់ ឡើ ត្រ ថួយ ដើ អៃ ប៉ឹះ ហំប៊្រុក ត្រំ ហំឞ្លិច ហន់ចក់ កទ្រី ដើម កឡ អ៊ែ ណគ់ ពត្រូវ តៃ ដូវ ថួយ ដើ អៃ អន់ណាវ ហន់ចក់ វ៉ិះ ឌិវ មូយ ហំប៊្រុក កទ្រី កឡ។ ");
INSERT INTO brb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ដើម ហន់ចក់ ជែម ចណាយ ណគ់ ម៉ើ ប៉ារ់ ទឹង គ្រែ ប៉ឹះ ហំប៊្រុក ប៉ាគ់ទឺ កទ្រី ដើម កឡ បក់ មន់ពឝ៉ើត កួន ចូវ ថរ តាម យូ មែ កឡឹ ទឹង ឡាង ប្រិះ នែ ");
INSERT INTO brb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","យ៉ាក់ តើម ប៊ឹង នែ ណាគ់ ប៉ឹះ តង៉ៃ អំពឌឺះ អំមឺ ទិ ឡាង ប្រិះ នែ ពួន ជិត តង៉ៃ ពួន ជិត មាំង។ អំឈូត តប៉ាត់ អាំ លែក ណគ់ ឡើ ប៊ិច សណើម ណគ់ អៃ អពឝ៉ើត»។ ");
INSERT INTO brb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","យ៉ាគ់ ណូអ៊ែ ឡើ បើម ត្រួយ លែក ដើ ប្រម៉ាង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ទឹង ដាក ឡើ លែប ប៊ិង ឡាង ប្រិះ នែ យ៉ាគ់ ណូអ៊ែ កំប្រាគ់ ណគ ត្រូវ ក្លាំ កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","អ៊ែ យ៉ាគ់ ណូអ៊ែ កួន ទ្រី ណគ ដើម កម៉ាន់ ណគ ម៉ើ មឹត ទឹង ឌូក ទិះ អ៊ែ មន់ក្លើច តើម ប៊ឹង ដាក លែប។ ");
INSERT INTO brb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ប៊ិច លែក ដើ ពត្រូវ ឈឹង ពួន តើម ប៊ឹង ពត្រូវ ណគ់ បនឹះ ម៉ើ ដូវ ថួយ ដើ គ្រែដៃ ដើម ពត្រូវ តៃ ម៉ើ ដូវ ថួយ ដើ គ្រែដៃ ត្រំ ហំឞ្លិច ដើម ជែម ចណាយ ដើម ពត្រូវ ឆឡរ វ៉ារ ");
INSERT INTO brb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","កទ្រី កឡ ប៉ិន ហំប៊្រុកៗ ម៉ើ ដក់ មឹត ទឹង ឌូក គូ អរែង ប៊ឹង យ៉ាគ់ ណូអ៊ែ ប៉ាគ់ គ្រែដៃ ឡើ ប៉្រៃ យ៉ាគ់ ណូអ៊ែ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","តើម ប៊ឹង អ៊ែ ប៉ឹះ តង៉ៃ គ្រែ ឡើ អំមឺ ដាក ឡើ ចាំ ឌឹកៗ អ៊ែ ដាក ឡើ លែប ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ទឹង កម៉ អ៊ែ យ៉ាគ់ ណូអ៊ែ កំប្រាគ់ ណគ ត្រូវ ក្លាំ កម៉ ឡើយ ទឹង ខៃ បារ តង៉ៃ ជិត ប៉ឹះ តង៉ៃ អ៊ែ ឡើយ លែក ដើ ត្រម ដាក ម៉ើ ប៉្លុះ តើម ប៊ឹង ក្រលែង ប្រិះ អ្រចង អ្រចិច ដើម ឡើ អំមឺ ទិះ ឞាល់ ម៉ើ បើក ពហូះ កម៉ង គ្រែ ។ ");
INSERT INTO brb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","គ្រែ ឡើ អំមឺ ទិះ ប្រយ ពួន ជិត តង៉ៃ ពួន ជិត មាំង។ ");
INSERT INTO brb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ទឹង តង៉ៃ អ៊ែ ទឺ យ៉ាគ់ ណូអ៊ែ អំប្រា ទ្រី ណគ ដើម កួន កឡ ណគ យ៉ាគ់ សិម ហាំ យ៉ាភែត ដើម កម៉ាន់ ណគ លែក ពែ រ៉ា ម៉ើ មឹត គូ ទឹង ឌូក ទិះ។ ");
INSERT INTO brb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","លែក ដើ ពត្រូវ ប៊្រី តាម យូ មែ កឡឹ ពត្រូវ ស្រ៊ុក តាម យូ មែ កឡឹ ពត្រូវ ឆឡរ វ៉ារ តាម យូ មែ កឡឹ ជែម ចណាយ លែក អ៊ែ តាម យូ មែ កឡឹ ម៉ើ មឹត អរែង ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","លែក ដើ ពត្រូវ ណគ់ ម៉ើ ប៊ិច ក្លើម សើម ប៉ិន ហំប៊្រុកៗ ម៉ើ ដក់ មឹត គូ អរែង ប៊ឹង យ៉ាគ់ ណូអ៊ែ ទឹង ឌូក ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ឡើ ប៊ិច ពត្រូវ ត្រំ ហំឞ្លិច កទ្រី កឡៗ ម៉ើ ដក់ មឹត ហឹ ឌូក ទិះ ប៉ាគ់ គ្រែដៃ ឡើ ប៉្រៃ យ៉ាគ់ ណូអ៊ែ។ ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពាំង ប្រយ កម៉ង ឌូក រីម។ ");
INSERT INTO brb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ដាក ឡើ លែប ឡាង ប្រិះ ញឹះ ពួន ជិត តង៉ៃ ឡើ លែប ចាំ ឌឹកៗ ឌូក ទិះ ឡើ តើវ ពឺង កណង ដាក។ ");
INSERT INTO brb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ដាក ឡើ ឌឹក ចាំ ម៉ៃៗ ដើម ឡើ ចាំ ឈ្រុ ប៉ាគ់ទឺ អ៊ែ ឌូក ឡើ ហលែវ ពឺង កណង ដាក។ ");
INSERT INTO brb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ដាក ឡើ លែប នែ ចាំ ឌឹកៗ ឋា ដើ លុច លែក ដើ ចន់ឌូ ឈ្រូងៗ ក្រូម ឡាង គ្រែ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ដាក ឡើ លុច បូយ ចន់ឌូ លែក តាក់ តើម ប៊ឹង បូយ ចន់ឌូ ដាក ឡើ ឌឹក ញឹះ ពួន ឡាះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","លែក ដើ ពត្រូវ ណគ់ ម៉ើ ណោះ អំម៉ិះ ពឺង ឡាង ប្រិះ ម៉ើ គែត លែក តៃ ម៉ាង ពត្រូវ ហឡាប ពត្រូវ ស្រ៊ុក ពត្រូវ ប៊្រី ពត្រូវ អ្រណក់ អ្រណិក ពឺង ឡាង ប្រិះ ដើម បនឹះ ចម៉ាវ ម៉ើ គែត លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ណគ់ អង់ង៉ាយៗ ម៉ើ ប៊ិច ក្លើម សើម ម៉ើ ញិវ ពឺង ឡាង ប្រិះ ម៉ើ គែត លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","គ្រែដៃ ឡើ ឈូត តប៉ាត់ លែក ទិ ឡាង ប្រិះ តើម ប៊ឹង បនឹះ ប៊ឹះ ពត្រូវ ស៊្រុក ពត្រូវ ប៊្រី ពត្រូវ ឆឡរ វ៉ារ ជែម ចណាយ ម៉ើ ប៉ារ់ ទឹង វ៉ះ វ៉ាយ ឡាង គ្រែ ឡើ ឈូត តាក់ លែក អិះ។ ឡើ ណាគ់ វ៉ិះ ឌិវ យ៉ាគ់ ណូអ៊ែ ដើម ណគ់ មែ ម៉ើ គូ ទឹង កនុង ឌូក អរែង ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ដាក លែប ឡើ លឹង ឡើយ ពឺង ឡាង ប្រិះ ញឹះ មូយ ក្លាំ សើង ជិត តង៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","អ៊ែ គ្រែដៃ ឡើ ចនិះ ហឹ យ៉ាគ់ ណូអ៊ែ ដើម លែក ដើ ពត្រូវ ណគ់ ម៉ើ គូ ទឹង ឌូក អរែង ប៊ឹង ណគ។ គ្រែដៃ ឡើ បើម អាំ ប៊ិច កយឺវ ពឹក ពឺង ក្លាង ដាក អ៊ែ ដាក ឡើ ចាំ ស្រាក់។ ");
INSERT INTO brb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ត្រម ដាក តើម ចុ ក្រលែង ឡើ អាត់ ដើម កម៉ង គ្រែ ឡើ ពាំង អន់ណាវ អ៊ែ អំមឺ ឡើ ព្រឹង ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ដាក ឡើ ស្រាក់ តើម ប៊ឹង ឡាង ប្រិះ ខយៗ អ៊ែ តគ់ ឡើ ប៊ឹះ មូយ ក្លាំ សើង ជិត តង៉ៃ ឡើយ ណគ់ ចំប៊្រុ ដាក ឡើ ចាំ ទឺះ ឞិត ឞ៊ែត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","តគ់ តង៉ៃ ជិត ប៉ឹះ ខៃ ប៉ឹះ ឌូក ទិះ ឡើ បាក់ ពឺង ឝ៉រ ចន់ឌូ អារ៉ារ៉ាត។ ");
INSERT INTO brb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ប៊្លី អ៊ែ ណគ់ ដាក ឡើ ចាំ ស្រាក់ៗ ឆា ដើ ប៊ឹះ ខៃ ជិត។ តគ់ តង៉ៃ មូយ ខៃ ជិត ហន់ដើម ឌិវ បូយ ចន់ឌូ ម៉ើ ក្លគ់។ ");
INSERT INTO brb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ពួន ជិត តង៉ៃ តើម ប៊ឹង អ៊ែ យ៉ាគ់ ណូអ៊ែ ឡើ ប៉ើក ឝឡោះ ពហើយ ឌូក បណើម ណគ ");
INSERT INTO brb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","អ៊ែ ណគ ឡើ ពរ៉ូះ ប្រយ កអាក មូយ អំប៉ម ឡើ ប៉ារ់ វឹញ ដក់ វឹញ ដក់ ឆា ដើ ប្រិះ ឡើ ស្រាំង ឡើ ជឹ វឹញ យ៉ាវ ហឹ យ៉ាគ់ ណូអ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","អ៊ែ ឡើ ពរ៉ូះ អន់ណាវ ជែម កំប៊ូ យ៉ាក់ ឡើ ងុញ ណោះ រៀន ដាក លំស្រាក់ ឡើយ ឋូវ។ ");
INSERT INTO brb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ហាក់ ជែម កំប៊ូ ឡើ ប៉ារ់ ដាំង ឞន ជ្រឹប តៃ ប៊ិច អំម៉ឹះ យ៉ាក់ ដាក ណាគ់ ឡើ ប៊ិង ឡាង ប្រិះ ដឌែ អ៊ែ ឡើ ជឹ វឹញ ហឹ យ៉ាគ់ ណូអ៊ែ ទឹង ឌូក ទឺ។ យ៉ាគ់ ណូអ៊ែ ឡើ ពយ៉ ទី ឡើ រ៉ាប់ កំប៊ូ ឡើ តមឹត ហឹ ឌូក។ ");
INSERT INTO brb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ឡើ ចាំ ណាគ់ ប៉ឹះ តង៉ៃ អន់ណាវ អ៊ែ ឡើ ពរ៉ូះ ឡឹះ កំប៊ូ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","តគ់ អំប៊ឹ កំប៊ូ ឡើ ជឹ វឹញ ដាំង យ៉ាគ់ ណូអ៊ែ ដើម ឡើ ឝ៉ង់ បិច អូលីវ ដិ ប៉ាគ់ ពអ៊ែ យ៉ាគ់ ណូអ៊ែ ឡើ ណោះ រៀន ដាក ដៀប ឡើ ស្រាក់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","យ៉ាគ់ ណូអ៊ែ ឡើ ចាំ ណាគ់ ប៉ឹះ តង៉ៃ អន់ណាវ អ៊ែ ឡើ ពរ៉ូះ កំប៊ូ កំប៊ូ នែ ឡើ ជឹ វឹញ យ៉ាវ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","តគ់ តង៉ៃ មូយ ខៃ មូយ ទឹង អ៊ែ យ៉ាគ់ ណូអ៊ែ កំប្រាគ់ ណគ ត្រូវ ក្លាំ មូយ កម៉ អ៊ែ ដាក ឡើ ស្រាក់ តើម ប៊ឹង ឡាង ប្រិះ។ យ៉ាគ់ ណូអ៊ែ ឡើ ប៉ើក ពឌុរ ឌូក ណគ ឡើ តៃ ដាក ឡើ ស្រាក់ លែក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","តគ់ តង៉ៃ បារ ជិត ប៉ឹះ ខៃ បារ ឡាង ប្រិះ ឡើ ស្រាំង ហរ៉ើង ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ប៊ឹង អ៊ែ គ្រែដៃ ឡើ ហាយ ដើ យ៉ាគ់ ណូអ៊ែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«មិញ ហន់ញឺះ តើម ប៊ឹង ឌូក ទិះ ដឹប កួន ទ្រី ដើម កម៉ាន់ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ហំពរ៉ូះ លែក ដើ ពត្រូវ ណគ់ ម៉ើ គូ អរែង ប៊ឹង ហៃ ដើម ជែម ចណាយ ដើម ពត្រូវ ឈឹង ពួន ដឹប ពត្រូវ ឆឡរ វ៉ារ អាំ មន់ពឝ៉ើត កួន ចូវ អាំ ស៊ឺក ចាំ អើន មន់គូ ប៊ិង ឡាង ប្រិះ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","អ៊ែ យ៉ាគ់ ណូអ៊ែ ឡើ ញឺះ តើម ប៊ឹង ឌូក ទិះ មែ កួន កឡ ណគ ទ្រី ណគ ដឹប កម៉ាន់ ណគ ម៉ើ ញឺះ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ពត្រូវ ឈឹង ពួន ពត្រូវ ឆឡរ វ៉ារ ដើម ជែម ចណាយ ម៉ើ ញឺះ លែក អិះ តើម ប៊ឹង ឌូក ទិះ តាម យូ មែ កឡឹ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ប៊្លី អ៊ែ យ៉ាគ់ ណូអ៊ែ ឡើ ប៊ូក ព្រឌឺន តម៉ ឡើ បើម ឞន បប៊ុះ ថួយ ទឹង គ្រែដៃ ឡើ ណាគ់ អន់សច។ ឡើ ចក់ បណាន់ ដើម ជែម ចណាយ ត្រំ ហំឞ្លិច ណគ់ បនឹះ ម៉ើ ដូវ ថួយ ដើ គ្រែដៃ អ៊ែ ឡើ ប៊ុះ ពខៀរ ពឃឹក អាំ លែក ពឺង ប្រនូក តម៉ ណគ ឡើ ថួយ ដើ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ើត ដើ ហអម អំពី ថនួយ យ៉ាគ់ ណូអ៊ែ ឡើ ប៊ុះ អ៊ែ ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «អៃ តៃ អំប្រាយ ប៊្រិត យ៉ាវ ឡាង ប្រិះ នែ ញ៉ន ដើ បនឹះ ហម យ៉ះ ចនិះ មែ មន់ឃឹត វ៉ិះ ឌិវ តៃ ចាគ់ តើម ប៊ឹង អង់គ្លែត កតាម ដើម តៃ អន់ក្រលឺង យ៉ាវ ដើ ដាក លែក ដើ មែ ម៉ើ ប៊ិច ក្លើម សើម ទិ ឡាង ប្រិះ នែ ប៉ាគ់ អៃ អបើម ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ទឹង ឡាង ប្រិះ ណាគ់ ឡើ ណាគ់ លំប៊ិច ញ៉ាម ឆមូ ចួយ ញ៉ាម កៀវ ចិះ ញ៉ាម សួត រ៉ិះ លំប៊ិច ញ៉ាម ឝ៉ ញ៉ាម អ៊ឹះ ដើម ញ៉ាម អំមឺ ញ៉ាម ព្រាំង ប៊ិច តង៉ៃ ប៊ិច មាំងៗ លំណាគ់ អន់សច ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","គ្រែដៃ ឡើ ប្រាយ យ៉ាគ់ ណូអ៊ែ ដើម កួន កឡ ណគ ឡើ ម៉ាង រៀន៖ «វន់ពឝ៉ើត កួន ចូវ វន់ស៊ឺក តាក ប៊ិង ឡាង ប្រិះ នែ! ");
INSERT INTO brb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ពត្រូវ ឈឹង ពួន ពឺង ឡាង ប្រិះ ជែម ចណាយ ទឹង វ៉ះ វ៉ាយ ឡាង គ្រែ ពត្រូវ ឆឡរ វ៉ារ ទិ ឡាង ប្រិះ ដើម ទ្រឺ ទិ កនុង ដាក ពត្រូវ លែក ដើ អ៊ែ មន់ឌូង ដើ វែ ទុត ខាក់។ អៃ អន់អាំ ដើ វែ វន់ពែក ប៉ាក់ ពត្រូវ លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","លែក ដើ ពត្រូវ ម៉ើ អំម៉ិះ ម៉ើ ប៊ិច ក្លើម សើម អន់អាំ ដើ វែ វន់ចា ប៉ាគ់ អៃ អអាំ ហឡា បាត់ ប៊្រី ចិះ ភែ ដណាំ ដណូយ វឺៗ វ៉ះៗ ដើ វែ ពន់ឋើម ទឺ ណិះៗ នែ អៃ អន់អាំ ដើ វែ វន់ចា លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ហាក់ ម៉ាត់ ញ៉ង វន់ចា ច្រឡាត ណាគ់ ផាំផាម យ៉ាក់ ដើ ផាម នែ ឡើយ ម៉ើ ញិវ។ ");
INSERT INTO brb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ប៉ាគ់ បនឹះ អង់ង៉ាយ លន់កជែត វែ អៃ អំពថូត ណគ លន់ត្រ គែត អ៊ែ ប៉ាគ់ ពត្រូវ អង់ង៉ាយ លន់កជែត វែ អៃ អំពថូត កជែត ប៉ាគ់ទឺ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«ណគ ង៉ាយ លំពលូះ ផាម បនឹះ ណគ អ៊ែ បនឹះ មន់ពលូះ ប៉ាគ់ទឺ ឡើយ ផាម ណគ យ៉ាក់ អពឝ៉ើត បនឹះ អាំ ត្រ ប៉ាគ់ ដើ អៃ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","អ៊ែ ណគ់ ដើ វែ លែក រ៉ា វន់ពឝ៉ើត កួន ចូវ អាំ អើន វន់ស៊ឺក តាក ឌិ ហឌិ ប៊ិង ឡាង ប្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","គ្រែដៃ ឡើ ហាយ ដើ យ៉ាគ់ ណូអ៊ែ ដើម មែ កួន ណគ អន់ណាវ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«ណិះៗ នែ អៃ អន់ខណាត ខណាំ ប្លះ ង៉ាយ ដើម ដើ កួន ចូវ វែ ហឹ អន់ទុន ");
INSERT INTO brb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ដើម លែក ដើ ពត្រូវ ណគ់ ម៉ើ ប៊ិច ក្លើម សើម ម៉ើ គូ ប៊ឹង វែ ប៉ាគ់ ឡើ ជែម ចណាយ ពត្រូវ ស្រ៊ុក ដើម ពត្រូវ ប៊្រី លែក ដើ ពត្រូវ ណគ់ ម៉ើ ញឺះ តើម ប៊ឹង ឌូក ទិះ អរែង ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","អខណាត ខណាំ ប្លះ ង៉ាយ លែក រ៉ា អៃ អំក្រលឺង យ៉ាវ បនឹះ ដើម ពត្រូវ ដើ ដាក ដើម លំប៊ិច យ៉ាវ ដាក លំលែប ប៊ិង ឡាង ប្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","គ្រែដៃ ឡើ ពហាយ អន់ណាវ ឡើ រៀន៖ «អន់នែ អៃ អំពដៃ កាន ហឝ៉ាវ មូយ ដើ វែ ទឹង គ្រែ បក់ វន់ចនិះ កាន អខណាត ខណាំ ណិះៗ ប្លះ ង៉ាយ ដើម លែក ដើ ពត្រូវ មន់គូ ប៊ឹង វែ កាន ខណាត នែ លំណាគ់ អន់សច ត្រំ ប៉ាង ");
INSERT INTO brb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","អន់ជុ ប្រៀង ទឹង វ៉ះ វ៉ាយ ឡាង គ្រែ បក់ អន់ចនិះ ណគ់ កាន អៃ អខណាត ខណាំ ប្លះ អៃ ប្លះ បនឹះ ដើម ពត្រូវ ណគ់ វ៉ើ គូ ទិ ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ប៊ឹង អន់កសាត់ តមួត យូក ដាក ទឹង វ៉ះ វ៉ាយ ឡាង គ្រែ អ៊ែ ប្រៀង លំញឺះ ប៉ាគ់ទឺ ទឹង វ៉ះ វ៉ាយ ឡាង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ប៊ឹង អ៊ែ ឡើយ អន់ចនិះ ហឹ កាន អខណាត ខណាំ ប្លះ ង៉ាយ ដើម លែក ដើ ពត្រូវ ណគ់ ម៉ើ ប៊ិច ក្លើម សើម អន់ក្រលឺង ពលែប យ៉ាវ បនឹះ ដើម ពត្រូវ ដើ ដាក។ ");
INSERT INTO brb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ត្រំ អន់តៃ ប្រៀង ទឹង វ៉ះ វ៉ាយ ឡាង គ្រែ អន់ចនិះ ហឹ កាន អខណាត ខណាំ ឡើ ប៉ោះ ចាយ អន់សច ប្លះ អៃ ប្លះ បនឹះ ដើម ដើ ពត្រូវ ម៉ើ គូ ទិ ឡាង ប្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","គ្រែដៃ ឡើ ហាយ ដើ យ៉ាគ់ ណូអ៊ែ រៀន៖ «ប្រៀង នែ ឡើយ ឡើ ត្រ កាន ហង់ឝ៉ាវ លំបើម អាំ អៃ អន់ចនិះ ហឹ កាន អខណាត ខណាំ ប្លះ អៃ ដើម លែក ដើ បនឹះ តៃ ម៉ាង លែក ដើ ពត្រូវ ម៉ើ គូ ទិ ឡាង ប្រិះ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","កួន កឡ យ៉ាគ់ ណូអ៊ែ ម៉ើ ញឺះ តើម ប៊ឹង ឌូក ទិះ ម៉ាត់ មែ សិម ហាំ ដើម យ៉ាភែត។ យ៉ាគ់ ហាំ នែ ឡើយ បើគ យ៉ាគ់ កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","មែ នែ ឡើយ កួន កឡ យ៉ាគ់ ណូអ៊ែ ម៉ើ យូ តើម លែក ដើ បនឹះ ទិ ឡាង ប្រិះ នែ ម៉ើ ដក់ គូ ប៊ិង ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","យ៉ាគ់ ណូអ៊ែ ឡើ បើម មឺរ ណគ នែ ឡើយ ឡើ បើម មឺរ ដាំ ប៉្លៃ ឈឹង ជែម អន់នួរ បូវ។ ");
INSERT INTO brb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","អ៊ែ តង៉ៃ ហង់អ៊ិន ឡើ ញែត តវែ ឈឹង ជែម តូវ ឡើ ប៊ូ ឡើ កី ហំប្រាតៗ ប៊ឹង កទូប ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","យ៉ាគ់ ហាំ បើគ យ៉ាគ់ កាណាន ឡើ មឹត ហឹ កទូប ឡើ តៃ បើគ ណគ ឡើ ហង់ង៉ាន់ ហំប្រាតៗ ប៉ាគ់ អ៊ែ អ៊ែ ឡើ ដក់ ពហាយ ដើ អំប្រា អ៊ូគ ណគ អំប្រា គូ ហឹ បយឺង។ ");
INSERT INTO brb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","អ៊ែ សិម អំប្រា យ៉ាភែត អំប្រា ដក់ ចក់ ញុៗ ឝៀង ទិ ប៉ាវ។ អំប្រា ដក់ ពសាប់ បើគ អំប្រា ដើ កណងៗ អំប្រា ហវីវ អ៊ឺម អំប្រា ឝ្លាំង ហឹ ងឺរ អ៊ែ អំប្រា តៃ អ៊ឺម បើគ អំប្រា ឡើ ហង់ង៉ាន់ ហំប្រាតៗ។ ");
INSERT INTO brb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","តគ់ យ៉ាគ់ ណូអ៊ែ ឡើ សះ ប៊ូ តវែ អ៊ែ ឡើ ណោះ កួន អន់សូច ណគ ឡើ អៀល អ៊ឺម ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","អ៊ែ ឡើ ម៉ាង រៀន៖ «កាណាន ហន់ត្រ ពន់ដ្រាយ ឡើយ អ៊ូគ អា ហៃ មន់យួរ ហៃ បើម ក៝ត ហន់ធុក ជឺរ ក៝ត អង់គែង អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","យ៉ាគ់ ណូអ៊ែ ឡើ ម៉ាង ឡឹះ អន់ណាវ រៀន៖ «ឡា ព្រតឹះ ព្រនែ គ្រែដៃ ឡើ ណាគ់ អន់សច ណគ់ គ្រែដៃ សិម ឡើ អៀល បឹះ អាំ កាណាន លន់ក៝ត សិម»។ ");
INSERT INTO brb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","«ឡា គ្រែដៃ អើយ ហង់អាំ យ៉ាភែត លំប៊ិច កួន ចូវ អើនៗ ដើម ប៊្រី ដាក ចាំ ឌឺះ។ អាំ លន់គូ អរែង ប៊ឹង សិម។ ណគ់ ដើ កាណាន អន់ណាវ លន់ក៝ត យ៉ាភែត ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ប៊្លី ដាក ឡើ លែប យ៉ាគ់ ណូអ៊ែ ឡើ ញិវ ពែ ក្លាំ សើង ជិត កម៉ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","យ៉ាគ់ ណូអ៊ែ កំប្រាគ់ ណគ លែក ដើ អ៊ែ ជែន ក្លាំ សើង ជិត កម៉ អ៊ែ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","អន់នែ ព្រតយ ម៉ាត់ កួន យ៉ាគ់ ណូអ៊ែ សិម ហាំ ដើម យ៉ាភែត។ ប៊្លី ដាក ឡើ លែប មែ ពែ រ៉ា នែ ឡើយ ម៉ើ ពឝ៉ើត កួន ចូវ។ ");
INSERT INTO brb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","កួន កឡ យ៉ាគ់ យ៉ាភែត ឡើ ប៊ិច ឝ៉ូមែរ ម៉ាឝ៉ូក ម៉ាដាយ យ៉ាវ៉ាន់ ទូបាល មែស៊ែក ដើម ទីរ៉ះ។ ");
INSERT INTO brb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","កួន កឡ ឝ៉ូមែរ ឡើ ប៊ិច អាគែណះ រីផាត ដើម តូឝ៉ាម៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","កួន កឡ យ៉ាគ់ យ៉ាវ៉ាន់ ឡើ ប៊ិច អ៊ែលីសា តាស៊ិះ គីទីម ដើម ដូដានីម។ ");
INSERT INTO brb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","កួន ចូវ មែ អ៊ែ ឡើយ ម៉ិ យ៉ាគ់ បនឹះ អង់គែងៗ ម៉ើ អ្រឡះ អ្រឡាយ ដក់ គូ បរ ពឹះ សមុត ដើម ទឹង ចូន។ ម៉ើ ដក់ គូ តាម ប៊្រី ដាក មែ កឡឹ តាម ប្រម៉ាង មែ កឡឹ តាម ឆ្រាំង មែ កឡឹ ដើម តាម សុនសាត មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","កួន កឡ យ៉ាគ់ ហាំ ឡើ ប៊ិច គូះ មីតស្រាអ៊ីម ពូត ដើម កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","កួន កឡ គូះ ឡើ ប៊ិច ស៊ែបា ហាវីឡា សាប់តា រ៉ាម៉ា ដើម សាប់ទិកា។ កួន កឡ យ៉ាគ់ រ៉ាម៉ា ឡើ ប៊ិច ស៊ែបា អំប្រា ឌែដាន់។ ");
INSERT INTO brb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","យ៉ាគ់ គូះ ឡើ ពឝ៉ើត ឡឹះ អន់ណាវ កួន កឡ មូយ ឡើ ជុ ម៉ាត់ កួន ណគ នីមរ៉ូត។ យ៉ាគ់ នីមរ៉ូត នែ ឡើយ ឡើ ណាយ បក់ ប្រណើម អន់នួរ បូវ ទិ ឡាង ប្រិះ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ណគ នែ ឡើយ ឡើ ហ្រម៉ត រ៉ត តៃ ឋាំ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច។ ញ៉ន នែ ឡើយ ម៉ើ ខើយ ព្រតឹះ រៀន៖ «ត្រ ហហ្រម៉ត រ៉ត ទុត ខាក់ ឞាល់ នីមរ៉ូត ប៊ឹង ងឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច អន់ណោះ»។ ");
INSERT INTO brb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","អន់នួរៗ ពន់ឋើម នីមរ៉ូត ឡើ ពែក ប៉ាក់ ពួន មួង ហឹ ប៊្រី ដាក ស៊ីណើរ មួង បាបិល មួង អ៊ែរែក មួង អាកាត ដើម មួង កាល់នែ។ ");
INSERT INTO brb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","តគ់ ប៊្លី អ៊ែ ណគ ឡើ ដក់ គូ ហឹ ប៊្រី ដាក អាសើរ ដិ អ៊ែ ឡើ បើម មួង នីនីវែ មួង រែហូបុត មួង កាឡះ ");
INSERT INTO brb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ដើម មួង រែស៊ែន។ មួង រែស៊ែន ឡើ គូ ប្លះ កឌី មួង នីនីវែ អំប្រា មួង កាឡះ។ មួង កាឡះ នែ ឡើ មួង ទិះ តៃ ឋាំ។ ");
INSERT INTO brb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","យ៉ាគ់ មីតស្រាអ៊ីម នែ ម៉ិ យ៉ាគ់ សុនសាត លូឌីម សុនសាត អាណាមីម សុនសាត លែហាប៊ីម សុនសាត ណាប់ធូហ៊ីម ");
INSERT INTO brb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","សុនសាត ប៉ាទ្រូស៊ីម សុនសាត កាលូហ៊ីម (ឡើ ត្រ ម៉ិ យ៉ាគ់ សុនសាត ភីលីសទីន) ដើម សុនសាត កាប់ថូរីម។ ");
INSERT INTO brb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","យ៉ាគ់ កាណាន ឡើ ពឝ៉ើត ស៊ីដូន ឡើ ឡង់ ប៊្លី អ៊ែ ហ៊ែត ");
INSERT INTO brb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ដើម សុនសាត យែប៊ូះ សុនសាត អាម៉ូរី សុនសាត ឝីរឝ៉ាស៊ី ");
INSERT INTO brb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","សុនសាត ហ៊ែវី សុនសាត អារ់គី សុនសាត ស៊ីនី ");
INSERT INTO brb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","សុនសាត អារ់វ៉ាត សុនសាត ស៊ែម៉ារី សុនសាត ហាម៉ាធី។ ប៊្លី អ៊ែ ឆ្រាំង កាណាន ម៉ើ អ្រឡះ ប្រយ ត្រឌីវ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ប៊្រី ដាក សុនសាត កាណាន ណាប់ តើម ប៊ឹង មួង ស៊ីដូន ប៊ឹះ មួង ឝែរ៉ា ឆា ដើ ប៊ឹះ មួង ឝ៉ាសា ដើម ប៊ឹះ មួង សូដំ មួង ឝ៉ូម៉ូរ៉ា មួង អាដាម៉ា មួង ស៊ែបូម ឆា ដើ ប៊ឹះ មួង ឡាសា។ ");
INSERT INTO brb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","អន់នែ ឡើយ កួន ចូវ យ៉ាគ់ ហាំ តាម ឆ្រាំង តាម ប្រម៉ាង តាម ប៊្រី ដាក ដើម តាម សុនសាត មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","អ៊ែ ដើ យ៉ាគ់ សិម អ៊ូគ យ៉ាគ់ យ៉ាភែត ឡើ ប៊ិច ប៉ាគ់ទឺ កួន។ យ៉ាគ់ សិម នែ ម៉ិ យ៉ាគ់ មែ ហ៊ែប៊ែរ។ ");
INSERT INTO brb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","កួន កឡ យ៉ាគ់ សិម ឡើ ប៊ិច អ៊ែឡាំ អាសើរ អារប៉ាក់សាត លូត ដើម អារ៉ាម។ ");
INSERT INTO brb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","កួន កឡ យ៉ាគ់ អារ៉ាម ឡើ ប៊ិច អ៊ូះ ហ៊ូល ឝែថើរ ដើម ម៉ាះ។ ");
INSERT INTO brb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","យ៉ាគ់ អារប៉ាក់សាត ឡើ ពឝ៉ើត ស៊ែឡា អ៊ែ ស៊ែឡា ឡើ ពឝ៉ើត ហ៊ែប៊ែរ។ ");
INSERT INTO brb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ហ៊ែប៊ែរ ឡើ ប៊ិច កួន កឡ បារ រ៉ា មូយ ម៉ាត់ ណគ ផាលែក  (យ៉ាក់ ទឹង ប៉ាង អ៊ែ បនឹះ ម៉ើ គូ ទិ ឡាង ប្រិះ ម៉ើ អ្រឡះ ត្រឌីវ មែ) ម៉ាត់ អោះ ណគ យ៉ុថាន់។ ");
INSERT INTO brb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","យ៉ុថាន់ ឡើ ពឝ៉ើត អាល់ម៉ូដាត ស៊ែលែប ហាសាម៉ាវែត យែរ៉ា ");
INSERT INTO brb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ហាដូរ៉ាម អ៊ូសាល ឌិក្លា ");
INSERT INTO brb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","អូបាល អាប៊ីម៉ាអ៊ែល ស៊ែបា ");
INSERT INTO brb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","អូផៀរ ហាវីឡា ដើម យ៉ូបាប។ មែ លែក អ៊ែ ម៉ាត់តូវ កួន កឡ យ៉ាគ់ យ៉ុថាន់។ ");
INSERT INTO brb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ប៊្រី ដាក មែ នែ តើម ប៊ឹង ស្រុក មែសា ឆា ដើ ប៊ឹះ ស្រុក ស៊ែផារ ទឹង ចន់ឌូ តៃ ម៉ាត់ តង៉ៃ ឌឹក។ ");
INSERT INTO brb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","អន់នែ ឡើយ កួន ចូវ យ៉ាគ់ សិម តាម ឆ្រាំង តាម ប្រម៉ាង តាម ប៊្រី ដាក ដើម តាម សុនសាត មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","អន់នែ ឡើយ ឆ្រាំង កួន ចូវ យ៉ាគ់ ណូអ៊ែ តាម កន់ស៊ែ យូ តាម សុនសាត មែ កឡឹ។ ប៊្លី ដាក ឡើ លែប មែ លែក នែ ឡើយ ម៉ើ ដក់ គូ អ្រឡះ អ្រឡាយ ម៉ើ ពឝ៉ើត លែក ដើ សុនសាត ពឺង ឡាង ប្រិះ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ប៊្លី ដាក លែប លែក ដើ បនឹះ ម៉ើ គូ ទិ ឡាង ប្រិះ នែ ម៉ើ ប៊ិច ប្រម៉ាង ប្រដង់ ឌិវ មូយ ម៉ើ ចជែ ប្រម៉ាង ឌិវ មូយ។ ");
INSERT INTO brb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","តគ់ ម៉ើ វីះ តើម ប៊ឹង ប៊្រី ដាក តៃ ម៉ាត់ តង៉ៃ ឌឹក អ៊ែ ម៉ើ តៃ ប្រយ ត្រិញ ទិ ធែរ ហឹ ប៊្រី ដាក ស៊ីណើរ ម៉ើ ចន់ដ្រា បើម កនូ កនូម ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ប៊្លី អ៊ែ ម៉ើ ចន់ដ្រា ត្រឌីវ មែ រៀន៖ «ញ៉ះ ញំម៉ាន បើម អិត ញំប៊ុះ អាំ ជែន»។ អ៊ែ ម៉ើ ចក់ អិត ម៉ើ ជុ បើម ពតាង តម៉ ដើម ម៉ើ ចក់ ឆារ់ កស៊ូ អយុង យូង តើម ប៊ឹង ពដិះ ម៉ើ ឡារ ព្រទែប អិត។ ");
INSERT INTO brb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ប៊្លី អ៊ែ ម៉ើ ចន់ដ្រា រៀន៖ «ញ៉ះ ញំបើម មួង មូយ ដើ ង៉ាយ កឡឹ ងំគូ ដើម ងំបើម រ៉ូង បួច ឈ្រូង ទូត គ្រែ អ៊ែ ងំប៊ិច ម៉ាត់ លឺ អន់តើរ ញ៉ង អាំ ងន់អ្រឡះ អ្រឡាយ ត្រឌីវ ង៉ាយ ងន់ដក់ គូ ប៊ិង ឡាង ប្រិះ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ទឺះ ឝ្លាំង មួង ដើម រ៉ូង បួច ឈ្រូង ណគ់ បនឹះ ម៉ើ បើម។ ");
INSERT INTO brb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «បូវ មែ នែ មូយ សុនសាត ប្រម៉ាង ប្រដង់ មែ មូយ ប៉ាគ់ទឺ! ប៉ាគ់ មន់បើម កាន អន់នែ លន់កើត ណិះៗ ឡើយ អាត មន់បើម កាន អង់គែង តាម ប្រម៉ើត មែ កឡឹ លំកើត ប៉ាគ់ទឺ ឡើយ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដូវ កំប៊ែត មែ។ ");
INSERT INTO brb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ប៉ាគ់ ពអ៊ែ អន់ទឺះ ពឝ៉្លះ ប្រម៉ាង មែ អាំ មន់ចជែ ដិ អន់ដិ ញ៉ង មន់ណោះ យ៉ាវ ចង់ហៀង ប្រម៉ាង ត្រឌីវ មែ»។ ");
INSERT INTO brb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពឝ៉្លះ ពឝ៉្លាយ មែ អ៊ែ ម៉ើ វីះ តើម ប៊ឹង មួង ហង់អ៊ែ ដក់ គូ ប៊ិង ឡាង ប្រិះ អ៊ែ ម៉ើ ព្រឹង ប្រយ បើម មួង។ ");
INSERT INTO brb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ញ៉ន ដើ អ៊ែ ឡើយ ម៉ើ ជុ មួង ហង់អ៊ែ រៀន “បាបិល” យ៉ាក់ ប៊ឹង អ៊ែ ឡើយ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពឝ៉្លះ ប្រម៉ាង បនឹះ លែក អ៊ែ ញ៉ង អាំ ម៉ើ ណោះ ចង់ហៀង ត្រឌីវ មែ ដើម ឡើ បើម អាំ បនឹះ ម៉ើ អ្រឡះ អ្រឡាយ ដក់ គូ ប៊ិង ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","អន់នែ ព្រតយ ម៉ាត់ កួន ចូវ យ៉ាគ់ សិម។ បារ កម៉ តើម ប៊ឹង ដាក ឡើ លែប ឡាង ប្រិះ យ៉ាគ់ សិម កំប្រាគ់ ណគ មូយ ក្លាំ កម៉ អ៊ែ ឡើ ពឝ៉ើត អារប៉ាក់សាត។ ");
INSERT INTO brb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ប៊្លី អារប៉ាក់សាត ឡើ កើត ឡើយ យ៉ាគ់ សិម ណាគ់ ឡើ ញិវ សើង ក្លាំ កម៉ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ទឹង យ៉ាគ់ អារប៉ាក់សាត កំប្រាគ់ ណគ ពែ ជិត សើង កម៉ អ៊ែ ឡើ ពឝ៉ើត ស៊ែឡា។ ");
INSERT INTO brb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ប៊្លី ស៊ែឡា ឡើ កើត ឡើយ យ៉ាគ់ អារប៉ាក់សាត ណាគ់ ឡើ ញិវ ពួន ក្លាំ ពែ កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","តគ់ យ៉ាគ់ ស៊ែឡា កំប្រាគ់ ណគ ពែ ជិត កម៉ អ៊ែ ឡើ ពឝ៉ើត ហ៊ែប៊ែរ។ ");
INSERT INTO brb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ប៊្លី ហ៊ែប៊ែរ ឡើ កើត ឡើយ យ៉ាគ់ ស៊ែឡា ណាគ់ ឡើ ញិវ ពួន ក្លាំ ពែ កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ទឹង យ៉ាគ់ ហ៊ែប៊ែរ កំប្រាគ់ ណគ ពែ ជិត ពួន កម៉ អ៊ែ ឡើ ពឝ៉ើត ផាលែក។ ");
INSERT INTO brb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ប៊្លី ផាលែក ឡើ កើត ឡើយ យ៉ាគ់ ហ៊ែប៊ែរ ណាគ់ ឡើ ញិវ ពួន ក្លាំ ពែ ជិត កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","តគ់ យ៉ាគ់ ផាលែក កំប្រាគ់ ណគ ពែ ជិត កម៉ អ៊ែ ឡើ ពឝ៉ើត រែហ៊ូ។ ");
INSERT INTO brb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ប៊្លី រែហ៊ូ ឡើ កើត ឡើយ យ៉ាគ់ ផាលែក ណាគ់ ឡើ ញិវ បារ ក្លាំ ជែន កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","តគ់ យ៉ាគ់ រែហ៊ូ កំប្រាគ់ ណគ ពែ ជិត បារ កម៉ អ៊ែ ឡើ ពឝ៉ើត ស៊ែរូក។ ");
INSERT INTO brb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ប៊្លី ស៊ែរូក ឡើ កើត ឡើយ យ៉ាគ់ រែហ៊ូ ណាគ់ ឡើ ញិវ បារ ក្លាំ ប៉ឹះ កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ប៊ឹង យ៉ាគ់ ស៊ែរូក កំប្រាគ់ ណគ ពែ ជិត កម៉ ឡើយ អ៊ែ ឡើ ពឝ៉ើត ណាខូរ។ ");
INSERT INTO brb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ប៊្លី ណាខូរ ឡើ កើត ឡើយ យ៉ាគ់ ស៊ែរូក ណាគ់ ឡើ ញិវ បារ ក្លាំ កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","តគ់ យ៉ាគ់ ណាខូរ កំប្រាគ់ ណគ បារ ជិត ជែន កម៉ ឡើយ អ៊ែ ឡើ ពឝ៉ើត ទែរ៉ះ។ ");
INSERT INTO brb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ប៊្លី ទែរ៉ះ ឡើ កើត ឡើយ យ៉ាគ់ ណាខូរ ណាគ់ ឡើ ញិវ មូយ ក្លាំ ជិត ជែន កម៉ ឡឹះ អន់ណាវ អ៊ែ ឡើ ពឝ៉ើត កួន កទ្រី ដើម កឡ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","តគ់ យ៉ាគ់ ទែរ៉ះ កំប្រាគ់ ណគ ប៉ឹះ ជិត កម៉ ឡើយ អ៊ែ ឡើ ពឝ៉ើត អាប់រ៉ាម ណាខូរ ដើម ហារ៉ាន។ ");
INSERT INTO brb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","អន់នែ ព្រតយ ម៉ាត់ កួន ចូវ យ៉ាគ់ ទែរ៉ះ។ យ៉ាគ់ ទែរ៉ះ ឡើ ពឝ៉ើត កួន កឡ ពែ រ៉ា យ៉ាគ់ អាប់រ៉ាម យ៉ាគ់ ណាខូរ ដើម យ៉ាគ់ ហារ៉ាន។ យ៉ាគ់ ហារ៉ាន ឡើ ពឝ៉ើត យ៉ាគ់ ឡុត។ ");
INSERT INTO brb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","យ៉ាគ់ ហារ៉ាន នែ ឡើ គែត អន់នួរ បើគ ណគ យ៉ាគ់ ទែរ៉ះ ហឹ មួង អ៊ូរ ស្រុក ខាល់ឌែ ឡើ ស្រុក កណើត ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","យ៉ាគ់ អាប់រ៉ាម អំប្រា យ៉ាគ់ ណាខូរ អំប្រា ចក់ ទ្រី។ ទ្រី យ៉ាគ់ អាប់រ៉ាម ម៉ាត់ ណគ ណាង សារ៉ាយ អ៊ែ ទ្រី យ៉ាគ់ ណាខូរ ម៉ាត់ ណគ ណាង មីលកា។ ណាង មីលកា ឡើ ត្រ កួន យ៉ាគ់ ហារ៉ាន យ៉ាគ់ ហារ៉ាន នែ ឡើ ពឝ៉ើត កួន បារ រ៉ា មីលកា អំប្រា យីសាកា។ ");
INSERT INTO brb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ណាង សារ៉ាយ នែ ឡើ ប៊ិច អ៊ឺម កួន ឡើ កន់ដុង។ ");
INSERT INTO brb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","យ៉ាគ់ ទែរ៉ះ ឡើ វីះ តើម ប៊ឹង មួង អ៊ូរ ស្រុក ខាល់ឌែ ឡើ ដក់ ដាំង ស្រុក កាណាន។ ឡើ ច្រា កួន ណគ អាប់រ៉ាម ដើម កម៉ាន់ ណគ ណាង សារ៉ាយ ចូវ ណគ ឡុត កួន យ៉ាគ់ ហារ៉ាន ម៉ើ តូយ ណគ។ ម៉ើ ដក់ ហន់ដើម ឌិវ ស្រុក ខារ៉ាន់ អ៊ែ ម៉ើ បើម កនូ កនូម ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","យ៉ាគ់ ទែរ៉ះ កំប្រាគ់ ណគ បារ ក្លាំ សើង កម៉ ឡើយ អ៊ែ ឡើ គែត ហឹ ស្រុក ខារ៉ាន់។ ");
INSERT INTO brb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","តង៉ៃ ហង់អ៊ិន គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «មិញ ហំវីះ តើម ប៊ឹង ស្រុក ហៃ ហំវីះ តើម ប៊ឹង ក្រាន ឆ្រាំង ដើម ហន់ណាម ក្រាន បើគ ហៃ ហន់ដក់ គូ ហឹ ប៊្រី ដាក ណគ់ អៃ អំពដៃ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","«អៃ អង់អាំ ដើ ហៃ ហំប៊ិច កួន ចូវ ទុត អើន អ៊ែ ហន់វឹរ សុនសាត ទិះ ទុត ឌឺះ។ អំប្រាយ កាន ចាគ់ ដើ ហៃ ដើម អន់អាំ ដើ ហៃ ហំប៊ិច ម៉ាត់ លឺ អន់តើរ។ អ៊ែ ហៃ ឡើយ ហន់កឡា ប្រាយ កាន ចាគ់ ដើ បូវ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","«ណគ់ មែ ង៉ាយ ម៉ើ ប្រាយ កាន ចាគ់ ដើ ហៃ អៃ អំប្រាយ កាន ចាគ់ តូវ ដើ មែ អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ ប្រាយ ប៊្រិត ហៃ អៃ អំប្រាយ ប៊្រិត តូវ មែ ប៉ាគ់ទឺ លែក ដើ សុនសាត ទិ ឡាង ប្រិះ មន់ដូវ កាន ចាគ់ យ៉ម ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ វីះ តើម ប៊ឹង មួង ខារ៉ាន់ តាម ប៉ាគ់ ពន់ដ្រៃ គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ ម៉ន ណគ យ៉ាគ់ ឡុត ឡើ តូយ ប៉ាគ់ទឺ ណគ ទឹង អ៊ែ យ៉ាគ់ អាប់រ៉ាម កំប្រាគ់ ណគ ប៉ឹះ ជិត សើង កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ឡើ ច្រា ទ្រី ណគ សារ៉ាយ អំប្រា យ៉ាគ់ ឡុត ដក់ តូយ ណគ ដើម ឡើ តៀត លែក ដើ រ៉ាះ អំបាះ ណគ ឡើ ដូវ ជុ អន់តង ដើម មែ ក៝ត ណគ ឡើ រួត ហឹ មួង ខារ៉ាន់ តូច ដើ មែ ម៉ើ វីះ ដក់ គូ ហឹ ស្រុក កាណាន។ តគ់ ម៉ើ ប៊ឹះ ស្រុក កាណាន ឡើយ ");
INSERT INTO brb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","យ៉ាគ់ អាប់រ៉ាម ឡើ ដក់ ឡាត់ ស្រុក កាណាន ឆា ដើ ប៊ឹះ ស្រ៊ុក ស៊ីគែម អ៊ែ ឡើ គូ ប្រយ ហឹ ស៊្រុក មែ ដៀក ឞន ឡើ ប៊ិច តើម ឈ្រី យ៉ាគ់ ម៉ូរែ។ (ទឹង ប៉ាង អ៊ែ មែ សុនសាត កាណាន ណាគ់ ម៉ើ គូ ទឹង ស្រុក ហង់អ៊ែ)។ ");
INSERT INTO brb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពដៃ ចាក់ ដើ យ៉ាគ់ អាប់រ៉ាម អ៊ែ ឡើ ហាយ រៀន៖ «អៃ អន់អាំ ប៊្រី ដាក នែ ដើ កួន ចូវ ហៃ»។ ប៊ឹង អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក បក់ លំថួយ អន់ណាំ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ណគ់ ឡើ ពដៃ ចាក់ ដើ ណគ អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ប៊្លី អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ វីះ ដក់ ហឹ ចន់ឌូ តៃ ម៉ាត់ តង៉ៃ ឌឹក ស្រ៊ុក ប៊ែតអ៊ែល ណគ ឡើ បើម កតូ មូយ អំប៊ុ ប្លះ កឌី ស្រ៊ុក ប៊ែតអ៊ែល តៃ ម៉ាត់ តង៉ៃ លុច ដើម ស៊្រុក អាយ តៃ ម៉ាត់ តង៉ៃ ឌឹក។ ណគ ឡើ ប៊ូក ព្រឌឺន ឡឹះ តម៉ មូយ ប្រនូក អន់ណាវ បក់ លំថួយ អន់ណាំ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ ឡើ កឡូវ អ៊ឺរ ដាំង ម៉ាត់ គ្រែដៃ ឡើ ណាគ់ អន់សច ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ប៊្លី អ៊ែ ណគ ឡើ វីះ តើម ប៊ឹង កតូ ហង់អ៊ែ ឡើ បើម កតូ តៃ ណោះ ស៊ិ អំប៊ុ ឆា ដើ ប៊ឹះ ឞន នែឝ៉ិប។ ");
INSERT INTO brb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ទឹង អ៊ែ ឡើ ប៊ិច កាន អឹត ហរុ ទឹង ស្រុក កាណាន។ អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ទឺះ ទិ ស្រុក អ៊ែស៊ីប អន់ណាវ បក់ លន់គូ ហឹ អ៊ែ អន់ដៃ យ៉ាក់ កាន អឹត ហរុ អ៊ែ ឡើ ម៉ៃ ហ៊ែត។ ");
INSERT INTO brb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","តគ់ ដៀប មន់ប៊ឹះ ស្រុក អ៊ែស៊ីប ឡើ ថាន់ ទ្រី ណគ យ៉ាគ់ សារ៉ាយ រៀន៖ «អើយ ហន់ចង់ហៀង អៃ យ៉ឹ ហៃ នែ ឞិះ ហចាគ់ ឞាល់ នែ! ");
INSERT INTO brb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ប៉ាគ់ ពអ៊ែ ប៊ឹង សុនសាត អ៊ែស៊ីប មន់តៃ ហៃ មន់រៀន ទ្រី អៃ ឡើយ ហៃ! អាត មន់កជែត ឡើយ អៃ មន់ពញិវ វ៉ិះ ឌិវ ហៃ តៃ ណោះ។ ");
INSERT INTO brb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ប៉ាគ់ ពអ៊ែ អឡា ហឹ ហៃ ហន់រៀន អោះ អៃ ហៃ យ៉ឹ អ៊ែ មន់បើម អន់ចាគ់ ដើ អៃ ណាគ់ អន់ញិវ យ៉ម ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ហំប៊្រុះ យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ឹះ ស្រុក អ៊ែស៊ីប សុនសាត អ៊ែស៊ីប ម៉ើ តៃ ប្រយ ទ្រី ណគ ឡើ ចាគ់ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","តគ់ បូវ មែ ទិះ ក្រាគ់ ម៉ើ តៃ ទ្រី យ៉ាគ់ អាប់រ៉ាម អ៊ែ ម៉ើ ដក់ ព្រតឹះ ណគ តគ់ ងឺរ សឋិច។ អ៊ែ ម៉ើ តៀត ណាង សារ៉ាយ ឌឹក គូ ទឹង កនូ សឋិច ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","អ៊ែ សឋិច ឡើ បើម អន់ចាគ់ ដើ យ៉ាគ់ អាប់រ៉ាម ញ៉ន ឡើ ពន់ទែប ឡើ រៀន អោះ ណគ អ៊ែ ឡើ អាំ រ៉ាះ អំបាះ ដើ ណគ ប៉ាគ់ ឡើ ចៀម ឝ៉ូ លៀ សារ ដើម យូ អូត ប៉ិន ខកៗ ដើម មែ ក៝ត កទ្រី កឡ ឡើ អាំ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ហាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ បើម អាំ សឋិច ដើម មែ ទឹង ហន់ណាម ក្រាន ណគ ម៉ើ កើត ហអូវ ឈិ ទុត ខាក់ ញ៉ន ឡើ ចក់ បើម ទ្រី ដើ យ៉ាគ់ សារ៉ាយ ទ្រី យ៉ាគ់ អាប់រ៉ាម។ ");
INSERT INTO brb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ប៊ឹង អ៊ែ យ៉ាគ់ សឋិច ឡើ កឡូវ យ៉ាគ់ អាប់រ៉ាម ដក់ ហឹ ណគ ឡើ ម៉ាង រៀន៖ «ប៉ិ ឡើ ត្រ ហបើម ដើ អៃ ប៉ាគ់ នែ? ប៉ិ តៃ ហហាយ រៀន ណាង អន់នែ ទ្រី ហៃ អ៊ែ អន់ណោះ? ");
INSERT INTO brb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ប៉ិ ឡើ ត្រ ហហាយ រៀន អោះ ហៃ អ៊ែ អឌី ចក់ បើម ទ្រី ប៉ាគ់ នែ? ណិ ទ្រី ហនែ សប្រា លំវីះ តើម ប៊ឹង នែ ដ្រិះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","សឋិច ឡើ ប៉្រៃ តហាន ណគ មន់ឈូន ទ្រូង យ៉ាគ់ អាប់រ៉ាម មន់តវីះ អំប្រា ដើម រ៉ាះ អំបាះ ណគ អាំ លែក។ ");
INSERT INTO brb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","យ៉ាគ់ អាប់រ៉ាម អំប្រា ទ្រី ណគ អំប្រា ជឹ វឹញ តើម ប៊ឹង ស្រុក អ៊ែស៊ីប អំប្រា ដក់ គូ ហឹ ឞន នែឝ៉ិប អំប្រា តៀត ដើម រ៉ាះ អំបាះ ប្រនិច អំប្រា។ ម៉ន ណគ យ៉ាគ់ ឡុត ឡើ ជឹ តូយ ប៉ាគ់ទឺ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ិច បណាន់ ប៉ិន ខក ដើម ឡើ ប៊ិច ឆៀង ប៉្រាក់ ទុត អើន ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ប៊្លី អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ដក់ ទុត អើន អំប៊ុ តើម ប៊ឹង កនូ ហឹ ឞន នែឝ៉ិប ឆា ដើ ប៊ឹះ ដៀប ស៊្រុក ប៊ែតអ៊ែល ហឹ កនូ ណគ ឡើ ខើយ បើម កតូ ពន់ឋើម ប្លះ កឌី ស្រ៊ុក ប៊ែតអ៊ែល អំប្រា ស៊្រុក អាយ ");
INSERT INTO brb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ប៊ឹង អ៊ែ ឡើយ ពន់ឋើម យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ូក ព្រឌឺន តម៉ ថួយ អន់ណាំ ដើ គ្រែដៃ។ អ៊ែ ឡើ កឡូវ អ៊ឺរ ដាំង ម៉ាត់ គ្រែដៃ ឡើ ណាគ់ អន់សច ប៊ឹង អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","អ៊ែ ដើ យ៉ាគ់ ឡុត ឡើ ដក់ អរែង ដើ យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ិច បប៊ែ ចៀម ប៊ិច ឝ៉ូ ប៉ិន ខក ដើម ឡើ ប៊ិច កទូប ទុត អើន ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ទឹង ស្រុក ហង់អ៊ែ តៃ ឡើ គុំ អ៊ឺម ឞន ម៉ើ បយ៉ា ពត្រូវ អំប្រា យ៉ាក់ អំប្រា ប៊ិច បណាន់ អើន ហ៊ែត អ៊ែ ឡើ ឆិ អ៊ឺម អំប្រា គូ អរែង។ ");
INSERT INTO brb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","អ៊ែ បូវ មែ កឡា បយ៉ា ពត្រូវ យ៉ាគ់ អាប់រ៉ាម ដើម បូវ មែ កឡា បយ៉ា ពត្រូវ យ៉ាគ់ ឡុត ម៉ើ ព្រសិញ ប្លះ មែ។ (មូយ អន់ណាវ ទឹង អ៊ែ ឡើ ប៊ិច សុនសាត កាណាន ដើម សុនសាត ពែរីស៊ី ម៉ើ គូ ទឹង ប៊្រី ដាក ហង់អ៊ែ ទឺ។) ");
INSERT INTO brb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","យ៉ាគ់ អាប់រ៉ាម ឡើ ចជែ ដើ យ៉ាគ់ ឡុត រៀន៖ «អើយ ម៉ន ញ៉ង បន់ព្រសិញ អ៊ឺម ប្លះ បា ដើម ប្លះ ណគ់ មែ ម៉ើ បយ៉ា បណាន់ បា យ៉ាក់ បា នែ បើ ច្រម៉ូវ មិះ។ ");
INSERT INTO brb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ហន់ឝ្លាំង ហឹ ងឺរ បា តគ់ ម៉ន ប៊្រី ដាក ណាគ់ ទុត ឌឺះ ប៉ាគ់ ពអ៊ែ ណិះៗ បន់អ្រឡះ ឆិ ត្រឌីវ បា។ ប៉ាគ់ ដើ ហៃ ហន់ដក់ គូ តៃ ចម៉ា ដើ អៃ តៃ ចអៀវ ដូវ ប៉ាគ់ ទឺ ប៉ាគ់ ដើ ហៃ តៃ ចអៀវ ដើ អៃ តៃ ចម៉ា ដូវ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","យ៉ាគ់ ឡុត ឡើ បយ៉ើល ឝ្លាំង ឡើ តៃ លែក ដើ ធែរ ទិ ដណៃ យ៉ូរដាន់ ឡើ ប៊ិច ដាក ត្រំ អំប៊ុ ដើម ប៊្រី ដាក ចាគ់ ឃិវ ឞ៊្លែងៗ ឆា ដើ ប៊ឹះ ស៊្រុក សូអារ ឡើ ព្រឌីវ ឞាល់ មឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពឝ៉ើត ឞាល់ ប៊្រី ដាក មែ អ៊ែស៊ីប ទឺ។ (ទឹង អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ បលុ អំម៉ឹះ មួង សូដំ ដើម មួង ឝ៉ូម៉ូរ៉ា)។ ");
INSERT INTO brb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","អ៊ែ យ៉ាគ់ ឡុត ឡើ ងុញ ដក់ គូ បុ ធែរ ដណៃ យ៉ូរដាន់ ឡើ ឡះ តើម ប៊ឹង យ៉ាគ់ អាប់រ៉ាម ឡើ ទឺះ គូ តៃ ម៉ាត់ តង៉ៃ ឌឹក។ ប៉ាគ់ នែ ឡើយ អំប្រា អ្រឡះ ប្លះ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","យ៉ាគ់ អាប់រ៉ាម ឡើ គូ ហឹ ស្រុក កាណាន អ៊ែ ដើ យ៉ាគ់ ឡុត ឡើ គូ ទិ ប្រិះ ធែរ បរ មួង អ៊ែ ឡើ បើម កតូ ដៀក មួង សូដំ ហ្រដូត។ ");
INSERT INTO brb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","បូវ មែ មួង សូដំ ម៉ាត់តូវ បនឹះ អរាំង មាំ ម៉ើ ខើយ បើម កាន តៃ ចាគ់ ទុត កយឹក ទឹង គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ប៊្លី យ៉ាគ់ ឡុត ឡើ វីះ ឡះ តើម ប៊ឹង យ៉ាគ់ អាប់រ៉ាម គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហាយ ដើ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «ហំប៊្រឹក ម៉ាត់ បយ៉ើល ឝ្លាំង ឡាំង លែក ដើ ប៊្រី ដាក ឈុំ ហៃ ហគូ នែ! ");
INSERT INTO brb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","លែក ដើ ប៊្រី ដាក ណគ់ ហៃ ហតៃ នែ អៃ អង់អាំ ដើ ហៃ ដើម ដើ កួន ចូវ ហៃ ហឹ អន់ទុន ឡូច អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","អៃ អំប៉្រៃ កួន ចូវ ហៃ មន់ស៊ឺក តាក ឞាល់ ហទឹក ប្រិះ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដូវ កាវ កួន ចូវ ហៃ ញឹះ ឞាល់ តៃ ម៉ើ ដូវ កាវ ហទឹក ប្រិះ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","មិញ ហន់ដក់ ឡាត់ ព្រឌឹង ប្រយ៉ុង ទឹង ប៊្រី ដាក អន់នែ យ៉ាក់ អៃ អង់អាំ ដើ ហៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ សោះ កទូប ណគ ឡើ ដក់ បើម តគ់ តើម ឈ្រី យ៉ាគ់ ម៉ាមរែ ឡើ ចើម មួង ហ៊ែប្រុន។ ហឹ អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក បក់ លំថួយ អន់ណាំ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ទឹង អ៊ែ ឡើ ប៊ិច សឋិច ពួន រ៉ា ម៉ើ ចន់ដ្រា ដក់ ប្រណើម។ ឡើ ប៊ិច យ៉ាគ់ អាំរ៉ាភែល ឡើ សឋិច ស្រុក ស៊ីណើរ យ៉ាគ់ អារីយ៉ូក ឡើ សឋិច ស្រុក អ៊ែឡាសារ យ៉ាគ់ គែដូឡូមែរ ឡើ សឋិច ស្រុក អ៊ែឡាំ ដើម យ៉ាគ់ ទីដាល ឡើ សឋិច ស្រុក ឝ៉ូយីម។ ");
INSERT INTO brb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","សឋិច លែក ពួន រ៉ា នែ ម៉ើ ចន់ដ្រា ដក់ បឹត យ៉ាគ់ ប៊ែរ៉ា ឡើ សឋិច មួង សូដំ យ៉ាគ់ ប៊ីរសា ឡើ សឋិច មួង ឝ៉ូម៉ូរ៉ា យ៉ាគ់ ស៊ីណាប ឡើ សឋិច មួង អាដាម៉ា យ៉ាគ់ ស៊ែមែប៊ែរ ឡើ សឋិច មួង ស៊ែបូម ដើម សឋិច មួង ប៊ែឡា (មួង អ៊ែ ម៉ើ ជុ សូអារ អន់ណាវ)។ ");
INSERT INTO brb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","សឋិច លែក សើង រ៉ា នែ ម៉ើ ដក់ ជុ តមួត តហាន ប្លះ ធែរ ស៊ីឌីម (តគ់ ប៊្លី អ៊ែ ធែរ នែ ឡើ វឹរ សមុត ដាក ហាំ អន់ណាវ)។ ");
INSERT INTO brb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ពន់ឋើម សឋិច លែក ដើ នែ ម៉ើ គូ កន់ដ្រូម អាតណាត យ៉ាគ់ គែដូឡូមែរ លញ៉ាគ់ ជិត បារ កម៉ ឡើ ត្រ សឋិច ឡើ កាគ់ លៀន ហឹ មែ។ តគ់ ឡើ ក្លើច ជិត បារ កម៉ ឡើយ អ៊ែ ម៉ើ ចន់ដ្រា ត្រឌីវ មែ ម៉ើ អាំ យ៉ាវ សឋិច គែដូឡូមែរ លំពែក ប៉ាក់ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","អ៊ែ តគ់ ជិត ពួន កម៉ យ៉ាគ់ គែដូឡូមែរ ដើម លែក ដើ សឋិច ម៉ើ តមួត អរែង ប៊ឹង ណគ ម៉ើ ចន់ដ្រា ដក់ បឹត សឋិច មួង មែ អ៊ិន។ ដើម ម៉ើ បឹត ពន់ដម មែ ទឹង មួង បរ ទ្រូង ដិ ប៉ាគ់ ឡើ សុនសាត រែភែម ហឹ មួង អាះទែរ៉ូត-កានែម សុនសាត ស៊ូស៊ីម ហឹ មួង ហាំ សុនសាត អ៊ែមីម ហឹ ត្រិញ កៀរយ៉ាធែម ");
INSERT INTO brb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ដើម ម៉ើ បឹត សុនសាត ហូរី ហឹ ឞន ចន់ឌូ សៀរ ម៉ើ យ៉ាវ មែ ឆា ដើ ប៊ឹះ ចរ ចន់ឌូ អ៊ែល-ប៉ារ៉ាន ឡើ ចើម ត្រិញ ផាច ទិះ។ ");
INSERT INTO brb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ប៊្លី អ៊ែ សឋិច លែក ដើ អ៊ែ ម៉ើ ជឹ វឹញ បឹត មួង មែ គែង អន់ណាវ ម៉ើ ដក់ ប៊ឹះ មួង អ៊ែន-មីះផាត (មួង អ៊ែ ម៉ើ ជុ កាឌែះ អន់ណាវ)។ ម៉ើ បឹត ចក់ ពដិះ មែ សុនសាត អាម៉ាលែក ហឹ ស្រុក ហង់អ៊ែ លែក តាក់ ដើម ម៉ើ បឹត សុនសាត អាម៉ូរី ម៉ើ គូ ហឹ មួង ហាសាសូន-តាម៉ារ។ ");
INSERT INTO brb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","តៃ នែ សឋិច មួង សូដំ សឋិច មួង ឝ៉ូម៉ូរ៉ា សឋិច មួង អាដាម៉ា សឋិច មួង ស៊ែបូម ដើម សឋិច មួង ប៊ែឡា (មួង ប៊ែឡា នែ ណិះៗ ម៉ើ ជុ មួង សូអារ អន់ណាវ) ម៉ើ ចន់ដ្រា តមួត បូវ តហាន មែ ដក់ ប្រណើម ដើ សឋិច ពួន រ៉ា ហឹ ធែរ ស៊ីឌីម ");
INSERT INTO brb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ម៉ើ ដក់ ប្រណើម ដើ យ៉ាគ់ គែដូឡូមែរ ឡើ សឋិច ស្រុក អ៊ែឡាំ យ៉ាគ់ ទីដាល ឡើ សឋិច ស្រុក ឝ៉ូយីម យ៉ាគ់ អាំរ៉ាភែល ឡើ សឋិច ស្រុក ស៊ីណើរ ដើម យ៉ាគ់ អារីយ៉ូក ឡើ សឋិច ស្រុក អ៊ែឡាសារ។ លែក ដើ មែ សឋិច ពួន រ៉ា នែ ឡើយ ម៉ើ ដក់ ប្រណើម ដើ សឋិច សើង រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ហឹ ធែរ ស៊ីឌីម ឡើ ប៊ិច លុង ដាក ឆារ់ អយូង ទុត អើន។ ទឹង សឋិច ដើម តហាន មួង សូដំ ដើម មួង ឝ៉ូម៉ូរ៉ា ម៉ើ អន មែ អន់នឺ ម៉ើ គ្លីះ ទិ លុង ដាក ឆារ់ អ៊ែ មែ អន់នឺ អន់ណាវ ម៉ើ អ្រយ៉ាវ ក្លើច ទឹង ចន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ណគ់ ដើ សឋិច ម៉ើ ប្រិញ ប្រណើម អ៊ែ ម៉ើ ចន់ដ្រា បូវ ដក់ ចក់ រ៉ាះ អំបាះ ដើម ចិះ ភែ ចណា ចណាត់ លែក អិះ តើម ប៊ឹង មួង សូដំ ដើម មួង ឝ៉ូម៉ូរ៉ា ប៊្លី អ៊ែ ម៉ើ ជឹ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ម៉ើ រ៉ាប់ យ៉ាគ់ ឡុត ម៉ន យ៉ាគ់ អាប់រ៉ាម ឡើ គូ ទឹង មួង សូដំ ដើម ម៉ើ ចក់ រ៉ាះ អំបាះ ណគ ម៉ើ ជឹ តៀត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ប៊្លី អ៊ែ បូវ មែ ម៉ើ ក្លើច តើម ប៊ឹង ប្រណើម ប៊ិច បឹ មូយ រ៉ា ឡើ ដក់ ពហាយ ដើ យ៉ាគ់ អាប់រ៉ាម ឡើ សុនសាត ហ៊ែប្រើ។ យ៉ាគ់ អាប់រ៉ាម នែ កនូ ណគ ហឹ តើម ឈ្រី យ៉ាគ់ ម៉ាមរែ។ យ៉ាគ់ ម៉ាមរែ នែ ឡើ សុនសាត អាម៉ូរី ឡើ ត្រ អំម៉ោះ អោះ យ៉ាគ់ អ៊ែះកុល អំប្រា យ៉ាគ់ អានែរ បូវ មែ នែ ម៉ើ ផ្រណម ពណូរ ប្លះ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","តគ់ យ៉ាគ់ អាប់រ៉ាម ឡើ ដុង ម៉ើ រ៉ាប់ ម៉ន ណគ ម៉ើ ចក់ ជឹ តៀត បើម ក៝ត អ៊ែ ឡើ ព្រណាក ហក តាវ អាំ ដើ មែ ក៝ត ណគ់ ម៉ើ កើត ទឹង ហន់ណាម ណគ អំម៉ើន ពែ ក្លាំ ជិត ថាម រ៉ា ម៉ាត់តូវ មែ ម៉ើ អ៊ែប ហាត់ ប្រណើម អ៊ែ ម៉ើ យ៉ាវ ឆ្រួយ តៃ ត្រិច មែ សឋិច ពួន រ៉ា ឆា ដើ ប៊ឹះ មួង ដាន់។ ");
INSERT INTO brb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","យ៉ាគ់ អាប់រ៉ាម ឡើ ព្រណាក ក៝ត ណគ ឡើ ជុ ប៉ិន អំប៊ុ តគ់ ទឹង មាំង អ៊ែ ម៉ើ មឹត បឹត មែ សឋិច។ ណគ ឡើ បឹត បូវ មែ ដូវ ឡើយ អ៊ែ ឡើ យ៉ាវ ឋារ ឆ្រួយ ឆា ដើ ប៊ឹះ មួង ហូបា តៃ ព្រឌឹង ម៉ាត់ តង៉ៃ តៃ ចអៀវ មួង ដាម៉ះ។ ");
INSERT INTO brb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ប៊្លី អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ សួរ រ៉ាះ អំបាះ តើម ប៊ឹង មែ ឡើ សួរ ជឹ តៀត ម៉ន ណគ យ៉ាគ់ ឡុត ដើម ប្រនិច ប្រណាក់ ណគ ដិ ដើម ឡើ សួរ លែក ដើ មែ កទ្រី ដើម លែក ដើ មែ ក្លាង ស៊្រុក មួង សូដំ។ ");
INSERT INTO brb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ប៊្លី យ៉ាគ់ អាប់រ៉ាម ឡើ ជឹ តើម ប៊ឹង ប្រណើម ឡើ ប្រិញ ថាំង ជឺរ មែ សឋិច គែដូឡូមែរ ពួន រ៉ា សឋិច មួង សូដំ ឡើ ដក់ យ៉ាវ ព្រតឹះ ព្រនែ យ៉ាគ់ អាប់រ៉ាម ប្លះ ហួម សាវែ (ម៉ើ ជុ ហួម សឋិច ដិ)។ ");
INSERT INTO brb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","អ៊ែ ដើ យ៉ាគ់ ម៉ិលគីសាដិក ឡើ សឋិច មួង សាឡឹម ដើម ឡើ កឡា បប៊ុះ ថួយ ដើ គ្រែដៃ ឡើ ទិះ ឈ្រូង តៃ ឋាំ ឡើ តៀត ណំពាំង ដើម តវែ ឈឹង ជែម ឡើ ដក់ អាំ ដើ យ៉ាគ់ អាប់រ៉ាម។ ");
INSERT INTO brb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","អ៊ែ ឡើ ប្រាយ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «ឡា គ្រែដៃ ហទិះ ឈ្រូង តៃ ឋាំ អើយ ណគ់ ហពឝ៉ើត ឡាង ប្រិះ ឡាង គ្រែ ឡា គ្រែដៃ អើយ ហំប្រាយ កាន ចាគ់ ដើ យ៉ាគ់ អាប់រ៉ាម ");
INSERT INTO brb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ឡា ព្រតឹះ ព្រនែ គ្រែដៃ ទិះ ឈ្រូង តៃ ឋាំ ឡើ ម៉ប មែ ដ្រម៉ា ទឹង ត្រប៉ាង ទី យ៉ាគ់ អាប់រ៉ាម!»។ យ៉ាគ់ អាប់រ៉ាម ឡើ អាំ ដើ យ៉ាគ់ ម៉ិលគីសាដិក ណគ់ រ៉ាះ ណគ ឡើ ដូវ សួរ តើម ប៊ឹង ប្រណើម កនុង ជិត ឡើ ម៉ប មូយ។ ");
INSERT INTO brb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ប៊្លី អ៊ែ សឋិច មួង សូដំ ឡើ ឡា ហឹ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «អឡា ហំម៉ប វ៉ិះ ឌិវ មែ ក្លាង ស៊្រុក ដើ អៃ ណគ់ រ៉ាះ ទឹង មួង អៃ ហៃ ហដូវ សួរ តើម ប៊ឹង មែ សឋិច អ៊ែ ហន់ចក់ ដើ ហៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","យ៉ាគ់ អាប់រ៉ាម ឡើ ត្រណើវ ប្រម៉ាង សឋិច សូដំ រៀន៖ «អៃ អខណាត តប៉ឹន ចាក់ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ទិះ ឈ្រូង តៃ ឋាំ ឡើ ពឝ៉ើត ឡាង ប្រិះ ឡាង គ្រែ ");
INSERT INTO brb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","អៃ អន់ចក់ អ៊ឺម រ៉ាះ ហៃ ណគ់ អៃ អដូវ សួរ សំយ៉ះ ឆមឺ កើប មូយ សាយ ប្រាយ មូយ ឡង ណាគ់ តៃ អន់ចក់ អ៊ឺម ប៉ាគ់ទឺ ហន់ណូវ ហន់រៀន អៃ អំប្រនិច ញ៉ន ដើ រ៉ាះ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","អៃ អឡា ហន់ឈូន វ៉ិះ ឌិវ ចណង់ ចណា មែ ក៝ត អៃ ម៉ើ ចង់ ចា ទឹង ម៉ើ ដក់ ប្រណើម អ៊ែ ណគ់ ដើ បូវ ប៊ែង ម៉ើ ដក់ តូយ អៃ យ៉ាគ់ អានែរ យ៉ាគ់ អ៊ែះកុល ដើម យ៉ាគ់ ម៉ាមរែ មន់ចក់ វ៉ិះ ឌិវ រ៉ាះ ព្រណាក មែ កឡឹ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ប៊្លី អ៊ែ ឡើយ យ៉ាគ់ អាប់រ៉ាម ឡើ តៃ ប្រាវៗ គ្រែដៃ ឡើ ណាគ់ អន់សច ដើម ឡើ ដុង ប្រម៉ាង ណគ ឡើ ហាយ រៀន៖ «អាប់រ៉ាម អើយ ញ៉ង ហឌូង អ៊ឺម! អៃ នែ អបើម ប៉ាគ់ ឃែវ អំពាំង ដុប កុប លែប ហៃ ដើម អង់អាំ កាន ចាគ់ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","យ៉ាគ់ អាប់រ៉ាម ឡើ ត្រណើវ រៀន៖ «ឡា គ្រែដៃ កន់ដ្រាគ់ ហណាគ់ អន់សច អើយ សំយ៉ះ ហន់អាំ អង់ង៉ាយ កតាម ដើ អៃ ណាគ់ តៃ លំប៊ិច ខា ប៉ាគ់ទឺ ឡើយ យ៉ាក់ តៃ អប៊ិច កួន ប៉ាគ់ នែ តគ់ អង់គែត មែ ង៉ាយ ដឹះ មន់រន់ឋាប់ ឝ្លាំង មូន មាំង អៃ វ៉ិះ ឌិវ ក៝ត អៃ អ៊ែលៀស៊ែរ តើម ប៊ឹង មួង ដាម៉ះ ឡើយ លំចក់ ពែក។ ");
INSERT INTO brb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ហន់ឝ្លាំង យ៉ឹ យ៉ាក់ តៃ ហអាំ កួន ដើ អៃ លំថរ អៃ វ៉ិះ ប៊ិច ឌិវ ក៝ត ទឹង ហន់ណាម អៃ ណិះ ឡើយ លំដូវ ចក់ ពែក មូន មាំង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ដុង ប្រម៉ាង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ត្រណើវ រៀន៖ «ត្រ អ៊ឺម ក៝ត ហៃ លំដូវ មូន មាំង ហៃ កួន ហកឡឹ ហំពឝ៉ើត ហវ៉ៃ លំដូវ មូន មាំង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","អ៊ែ គ្រែដៃ ឡើ ច្រា ញឺះ ហឹ បយឺង អ៊ែ ឡើ ប៉្រៃ ណគ រៀន៖ «ហង់ង៉ើយ ឝ្លាំង ឡាំង ទឹង ឡាង គ្រែ ទិ ហង់កាវ ពតួរ ប៉ាគ់ ហបក់! កួន ចូវ ហៃ មន់អើន ឞាល់ ពតួរ ទឺ ទិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","យ៉ាគ់ អាប់រ៉ាម ឡើ ចាប់ មឹង ប្រយ គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ គ្រែដៃ ឡើ ជុ ណគ បនឹះ ចាគ់ ទឹង ត្រ។ ");
INSERT INTO brb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","អ៊ែ គ្រែដៃ ឡើ ហាយ ឡឹះ រៀន៖ «អៃ នែ ឡើយ អគ្រែដៃ ឡើ ណាគ់ អន់សច អច្រា ហៃ ញឺះ តើម ប៊ឹង មួង អ៊ូរ ស្រុក ខាល់ឌែ បក់ អង់អាំ ប៊្រី ដាក នែ ហន់ជុ ដើ ហៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ តង៉ា រៀន៖ «គ្រែដៃ កន់ដ្រាគ់ ហណាគ់ អន់សច អើយ ពយ៉ិ អន់ណោះ រៀន ពដិះ នែ លំត្រ ប្រិះ ប៊្រី អៃ ម៉ាត់ ម៉ាត?»។ ");
INSERT INTO brb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","អ៊ែ គ្រែដៃ ឡើ ហាយ ដើ ណគ រៀន៖ «ហន់ចក់ ឝ៉ូ កទ្រី កំប្រាគ់ ពែ កម៉ បប៊ែ កទ្រី កំប្រាគ់ ពែ កម៉ ចៀម សារ អញុ ពែ កម៉ គុរ ដើម ព្លឹក ចង់ អន់ចង ពត្រូវ លែក ដើ នែ ឡើយ ហន់អាំ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","យ៉ាគ់ អាប់រ៉ាម ឡើ ចក់ ពត្រូវ លែក ដើ អ៊ែ ឡើ ច្រះ តង់បារ ប៊្លី អ៊ែ ឡើ ជុ ហន់ដះៗ ឡើ ម៉ប ដើ គ្រែដៃ វ៉ិះ ជែម ឡើ ច្រះ អ៊ឺម ឡើ ជុ លែក អំប៉ម។ ");
INSERT INTO brb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ហំប៊្រុះ ដើ អ៊ែ បូវ ជែម មិត ម៉ើ ងុញ ទឺះ ក្លក់ ច្រឡាត ម៉ាត ថនួយ ណគ អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ឌ្រុះ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ហំប៊្រុះ ម៉ាត់ តង៉ៃ ដៀប លំលុច យ៉ាគ់ អាប់រ៉ាម ឡើ ហង់ង៉ាន់ តៀក ប្រយ ឡើ ពកី តៃ ឡើ ហ្រង៉ូម ប្ល៊ឹប ប្លះ ណគ អ៊ែ ឡើ បើម ឌូង តូវ ឡើ រឹប ទូះ ឞ៊្រីៗ។ ");
INSERT INTO brb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហាយ ដើ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «បក់ ហន់ណោះ រៀន កួន ចូវ ហៃ មន់គូ ហឹ ស្រុក មែ គែង ប៊្លី អ៊ែ មែ ស្រុក ហឹ អ៊ែ មន់បើម ក៝ត ដើ មែ ដើម មន់ឈិះ ឆាន់ មែ ពួន ក្លាំ កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ហាក់ អៃ អំពថូត សុនសាត ណគ់ មែ ម៉ើ យួរ កួន ចូវ ហៃ បើម ក៝ត។ ប៊្លី អ៊ែ មន់វីះ តើម ប៊ឹង ស្រុក មែ ដើម មន់តៀត រ៉ាះ អំបាះ ទុត អើន ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","អ៊ែ ដើ ហៃ អន់ណាវ យ៉ាគ់ អាប់រ៉ាម ហង់គូ ហ្រនុក ហ្រវ៉ាក តាក កើត ទុត ឌុញ ប៊្លី អ៊ែ ហង់គែត ញឹម សាំង ហន់ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","កួន ចូវ ហៃ ហឹ ខៃ ណូវ មន់គូ ហឹ ស្រុក មែ គែង ប៊ឹះ ពែ ហ្រណើង ពួន ដើ មន់ជឹ វឹញ ហឹ ប៊្រី ដាក អន់នែ ទឺ។ យ៉ាក់ ទឹង អ៊ែ សុនសាត អាម៉ូរី ម៉ើ បើម កាន តៃ ចាគ់ ឡើ ឆិ អំម៉ឹះ អៃ អំពថូត តវីះ មែ តើម ប៊ឹង ប៊្រី ដាក នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","តគ់ ម៉ាត់ តង៉ៃ ឡើ លុច គ្រែ ឡើ កឡាំ ប៊្លឹប ហំប៊្រុះ ដើ អ៊ែ យ៉ាគ់ អាប់រ៉ាម កអវ ឡើ តៃ ត្រប៊ឹន ឡើ ញឺះ អន់ញូយ ដើម អ៊ុញ ឝឞង ឡើ កាត ទី អ្រញី។ អ៊ែ ត្រប៊ឹន ដើម ឝឞង នែ ម៉ើ អន់ឆូវ ប្លះ បឡះ ច្រឡាត ម៉ាត ពត្រូវ ណគ់ ណគ ឡើ ច្រះ។ ");
INSERT INTO brb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ទឹង តង៉ៃ អ៊ែ ឡើយ គ្រែដៃ ឡើ ខណាត ខណាំ ប្លះ ណគ ប្លះ យ៉ាគ់ អាប់រ៉ាម ឡើ ម៉ាង រៀន៖ «អៃ អង់អាំ ប៊្រី ដាក អន់នែ ដើ កួន ចូវ ហៃ តើម ប៊ឹង ដណៃ ស្រុក អ៊ែស៊ីប ឋា ដើ ប៊ឹះ ដណៃ ទិះ ម៉ើ ជុ រៀន ដណៃ អើប៉្រាត ");
INSERT INTO brb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ពដិះ អៃ អង់អាំ នែ ឡើ ត្រ ពដិះ មែ សុនសាត គែនី សុនសាត គែនីស៊ី សុនសាត កាត់ម៉ូនី ");
INSERT INTO brb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","សុនសាត ហ៊ែត សុនសាត ពែរីស៊ី សុនសាត រែភែម ");
INSERT INTO brb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","សុនសាត អាម៉ូរី សុនសាត កាណាន សុនសាត ឝីរឝ៉ាស៊ី ដើម សុនសាត យែប៊ូះ»។ ");
INSERT INTO brb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ទឹង អ៊ែ យ៉ាគ់ សារ៉ាយ ទ្រី យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ិច អ៊ឺម កួន។ ហាក់ ឡើ ប៊ិច ក៝ត មូយ រ៉ា សុនសាត អ៊ែស៊ីប ម៉ាត់ ណគ ណាង ហាឝ៉ារ។ ");
INSERT INTO brb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","យ៉ាគ់ សារ៉ាយ ឡើ ចជែ ហឹ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «អើយ យ៉ាគ់ អន់នែ ហន់ចង់ហៀង អៃ យ៉ឹ យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច តៃ ឡើ អាំ អៃ អប៊ិច កួន ប៉ាគ់ នែ ហង់កី ដើ ក៝ត អៃ អើយ។ អំប តវ៉ើយ ណាគ់ លំប៊ិច កួន អ៊ែ អន់ចក់ ពតាង បើម កួន អៃ កឡឹ»។ អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ចាប់ ប្រយ ប្រម៉ាង ទ្រី ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","អ៊ែ យ៉ាគ់ សារ៉ាយ ឡើ អាំ ប្រយ ក៝ត ណគ ណាង ហាឝ៉ារ សុនសាត អ៊ែស៊ីប ឡើ អាំ ដើ ក្ល ណគ បើម ទ្រី។ ទឹង អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ គូ ហឹ ស្រុក កាណាន ជិត កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","អ៊ែ តគ់ យ៉ាគ់ អាប់រ៉ាម ឡើ កី ដើ ណាង ហាឝ៉ារ អ៊ែ ឡើ តមែវ ប្រយ ដើ យ៉ាគ់ អាប់រ៉ាម។ ប៊ឹង ឡើ ណោះ ចាក់ ណគ ឡើ តមែវ អ៊ែ ឡើ ព្រដ ដើ កន់ដ្រាគ់ ណគ យ៉ាគ់ សារ៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","យ៉ាគ់ សារ៉ាយ ឡើ ម៉ាង ដើ យ៉ាគ់ អាប់រ៉ាម រៀន៖ «ញ៉ន ហៃ នែ ឡើយ អ៊ែ ក៝ត អៃ ឡើ បើម ដើ អៃ ប៉ាគ់ នែ! អអាំ ក៝ត កទ្រី អៃ ដើ ហៃ ហកី អរែង។ តគ់ ឡើ ណោះ ឡើ តមែវ ឡើ ព្រដ ដើ អៃ កឡឹ។ គ្រែដៃ ឡើ ណាគ់ អន់សច លំតាត់ ស៊ិន ប្លះ បា នែ!»។ ");
INSERT INTO brb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","យ៉ាគ់ អាប់រ៉ាម ឡើ ត្រណើវ ម៉ាង យ៉ាគ់ សារ៉ាយ រៀន៖ «ក៝ត នែ ណាគ់ ក៝ត ហៃ ហៃ ឡើយ ហវ៉ៃ ហប៊ិច អាតណាត ពឺង ណគ ប៉ាគ់ ពអ៊ែ ហំបើម ដើ ណគ តាម ប្រម៉ើត ហកឡឹ»។ ណាង សារ៉ាយ ឡើ បើម តំឞាប ណាង ហាឝ៉ារ ឆា ដើ ឡើ រ៉ូះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ណាង ហាឝ៉ារ ឡើ ដក់ ប៊ឹះ ត្រម ដាក តគ់ ទ្រូង ដក់ ហឹ ត្រិញ ស៊ូរ ទឹង ត្រិញ ទិះ ដុ តាវ លៀង អ៊ែ ឞាវ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តៃ ណគ ហឹ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ឞាវ គ្រែដៃ ឡើ តង៉ា រៀន៖ «អើយ ណាង ហាឝ៉ារ ក៝ត ណាង សារ៉ា តើម ប៊ឹង ង៉ាយ ហប៊ឹះ ហឹ ង៉ាយ ហដក់ អន់នែ?»។ ណាង ហាឝ៉ារ ឡើ ត្រណើវ រៀន៖ «អរ៉ូះ តើម ប៊ឹង កន់ដ្រាគ់ អៃ យ៉ាគ់ សារ៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ឞាវ គ្រែដៃ ឡើ ប៉្រៃ ណាង ហាឝ៉ារ រៀន៖ «ហន់ជឹ វឹញ ហឹ កន់ដ្រាគ់ ហៃ កឡឹ អ៊ែ ហន់ចង់ហៀង តាម ប្រម៉ាង ណគ ហឹ អិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ឞាវ គ្រែដៃ ឡើ ហាយ ឡឹះ អន់ណាវ រៀន៖ «អៃ អន់អាំ ដើ ហៃ ហំប៊ិច កួន ចូវ មន់ស៊ឺក តាក ទុត អើន ញឹះ តៃ ប៊ិច មែ ង៉ាយ មន់បក់ កាវ។ ");
INSERT INTO brb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ណិះៗ នែ ហតមែវ ឡើយ ហន់អន់ឆិ កួន ហៃ លន់កឡ ហន់ត្រ ជុ ម៉ាត់ ណគ អ៊ីសម៉ាអ៊ែល  យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ដុង ហៃ ហញឺម ក្រើយ ប៊ឹង ហធុក ញ៉ាក ប៉ាក ម៉ង។ ");
INSERT INTO brb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","«កួន ហៃ អន់នែ មន់ព្រឌីវ ប៉ាគ់ ពត្រូវ ប៊្រី ណគ លំប្រណឹត លែក ដើ បនឹះ អ៊ែ លែក ដើ បនឹះ មន់បឹត តូវ ណគ ប៉ាគ់ទឺ។ ណគ លន់គូ មូយ រ៉ា លំឌី អ៊ឺម លន់គូ ប៊ឹង អំម៉ោះ អោះ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ណាង ហាឝ៉ារ ឡើ ជុ ម៉ាត់ គ្រែដៃ ឡើ ណាគ់ អន់សច ណគ់ ឡើ ចជែ ប៊ឹង ណគ រៀន “គ្រែដៃ អ៊ែលរ៉យ ” យ៉ាក់ ណាង ឡើ ម៉ាង រៀន៖ «អៃ អតៃ គ្រែដៃ ឡើ រន់ឋាប់ ឝ្លាំង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ញ៉ន អ៊ែ ឡើយ តគ់ ប៊្លី អ៊ែ ម៉ើ ព្លូក រន់ឋូវ ប៊ឹង ត្រម ដាក អ៊ែ រៀន “ប៊ែរ ឡាហាយ រ៉យ ”។ រន់ឋូវ អ៊ែ ប្លះ កឌី ស៊្រុក កាឌែះ អំប្រា ស្រ៊ុក បារែត។ ");
INSERT INTO brb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ណាង ហាឝ៉ារ ឡើ អន់ឆិ កួន កឡ មូយ ប៊ឹង យ៉ាគ់ អាប់រ៉ាម អ៊ែ យ៉ាគ់ អាប់រ៉ាម ឡើ ជុ ម៉ាត់ កួន ណគ រៀន “អ៊ីសម៉ាអ៊ែល”។ ");
INSERT INTO brb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ទឹង យ៉ាគ់ អាប់រ៉ាម ឡើ ប៊ិច កួន ប៊ឹង ណាង ហាឝ៉ារ ទឹង អ៊ែ កំប្រាគ់ ណគ ថាម ជិត ត្រូវ កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","តគ់ យ៉ាគ់ អាប់រ៉ាម កំប្រាគ់ ណគ ជែន ជិត ជែន កម៉ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពដៃ ចាក់ ដើ ណគ ឡើ តៃ អ៊ែ ឡើ ហាយ រៀន៖ «អៃ ណិះ ឡើយ អគ្រែដៃ អឆង៉ាត់ ទុត ខាក់ ហន់បើម តាម ប្រម៉ើត អៃ អាំ ត្រៗ ញ៉ង ហំបើម អន់យូច យ៉ឹ។ ");
INSERT INTO brb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","អៃ អន់ខណាត ខណាំ ប្លះ បា អន់អាំ ដើ កួន ចូវ ហៃ មន់ស៊ឺក តាក ឌិ ហឌិ»។ ");
INSERT INTO brb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","យ៉ាគ់ អាប់រ៉ាម ឡើ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ អ៊ែ គ្រែដៃ ឡើ ហាយ ដើ ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«ហន់ឝ្លាំង អៃ អខណាត ខណាំ ប្លះ បា ប៉ាគ់ នែ ទុត អើន សុនសាត មន់បើគ ដើ ហៃ ");
INSERT INTO brb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","មែ មន់ជុ យ៉ាវ ហៃ អាប់រ៉ាម ឡឹះ អៃ អជុ ពលិះ ម៉ាត់ ហៃ អាប្រាហាំ អន់ណាវ យ៉ាក់ អៃ អង់អាំ ដើ សុនសាត ទុត អើន មន់បើម ម៉ិ យ៉ាគ់ ដើ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","អៃ អង់អាំ ដើ ហៃ ហំប៊ិច កួន ចូវ អើន ឌិ ហឌិ សុនសាត ដើម សឋិច ទុត អើន មន់កើត តើម ប៊ឹង ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","អៃ អង់ខណាត ខណាំ ប្លះ បា ដឹប កួន ចូវ ហៃ ត្រំ ប៉ាង។ កាន អខណាត ខណាំ នែ លំណាគ់ ប៊ឹះ ខៃ ណូវ ណាំង អំប៊ី អំម៉ាន អៃ អគ្រែដៃ អន់លវាំង ឝ្លាំង ហៃ ដើម កួន ចូវ ហៃ ហឹ ខៃ ណូវ។ ");
INSERT INTO brb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","លែក ដើ ស្រុក មែ កាណាន ណគ់ ហៃ ហដក់ គូ នែ ហបនឹះ តើម ហឹ គែង អៃ អំម៉ប ដើ ហៃ ដើម ដើ កួន ចូវ ហៃ ហឹ អន់ទុន កួន ចូវ ហៃ មន់ជុ ប្រិះ ប៊្រី ស្រុក អន់នែ ដើ មែ កឡឹ ឡូច អន់សច។ អៃ នែ ឡើយ អគ្រែដៃ អន់កដ្រាគ់ កួន ចូវ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","គ្រែដៃ ឡើ ហាយ ដើ យ៉ាគ់ អាប្រាហាំ រៀន៖ «អ៊ែ ណគ់ ដើ ហៃ អន់ណាវ ហំបើម ត្រួយ កាន បា បើ ខណាត ខណាំ ដើម មែ កួន ចូវ ហៃ ណគ់ មន់កើត ហឹ ប៉ាង អន់ទុន មន់ត្រ បើម ត្រួយ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","អន់នែ ឡើយ កាន បា បើ ខណាត ខណាំ ណគ់ ហៃ ដើម កួន ចូវ ហៃ ហឹ ប៉ាង អន់ទុន តគ់ តង វន់បើម ត្រួយ ណគ់ មែ កឡ តង មន់ចៀត ដម៉ូច ហំបក អាំ លែក រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","លែក ដើ វែ កឡ វន់ត្រ ចៀត ដម៉ូច ហំបក កាន ចៀត ដម៉ូច ហំបក នែ ឡើយ លំពដៃ កាន អៃ អខណាត ខណាំ ប្លះ ង៉ាយ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","លែក ដើ កួន កឡ ណគ់ ម៉ើ កើត ទឹង ក្រាន វែ តៃ ម៉ាង កួន វែ កឡឹ តៃ ម៉ាង កួន ក៝ត វែ តើម ប៊ឹង មន់កើត ដូវ ថាម តង៉ៃ វន់ចៀត ដម៉ូច ហំបក ប្រយ លែក ដើ មែ ត្រំ ប៉ាង។ ហម ក៝ត វន់រួត តើម ប៊ឹង គែង កតាម មន់ចៀត ត្រំ រ៉ា ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","លែក ដើ កួន កឡ មន់កើត ទឹង ហន់ណាម វែ ដើម ក៝ត កឡ វ៉ើ រួត តង វន់ចៀត ដម៉ូច ហំបក។ អ៊ែ វន់ចនិះ ហឹ កាន ខណាត ខណាំ ប្លះ បា យ៉ាក់ លំប៊ិច ទឹង ចាក់ វែ អន់សច ប៊ឹះ ខៃ ណូវ។ ");
INSERT INTO brb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ណគ់ កឡ អង់ង៉ាយ តៃ ឡើ ចៀត ដម៉ូច ហំបក វន់តវីះ តាក់ តើម ប៊ឹង សុនសាត វែ យ៉ាក់ តៃ ឡើ ឌី ត្រួយ កាន បា បើ ខណាត ខណាំ»។ ");
INSERT INTO brb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","គ្រែដៃ ឡើ ម៉ាង ឡឹះ ហឹ យ៉ាគ់ អាប្រាហាំ រៀន៖ «អ៊ែ ណគ់ ដើ សារ៉ាយ ទ្រី ហៃ អន់ណាវ ហន់ជុ យ៉ាវ ណគ “សារ៉ាយ” អន់ទឺ ហន់ជុ ណគ ណាង “សារ៉ា” អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","អៃ អំប្រាយ កាន ចាគ់ ដើ ណាង ដើម អន់អាំ ហៃ ហំប៊ិច កួន កឡ មូយ ប៊ឹង ណគ។ អៃ អំប្រាយ ដើ ណាង អ៊ែ លំម៉ិ យ៉ាគ់ សុនសាត ទុត អើន ដើម លំប៊ិច សឋិច សុនសាត ដិ អន់ដិ មន់កើត តើម ប៊ឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ ឡើ ចអាវ ដើម ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «ពយ៉ិ បនឹះ កំប្រាគ់ ញឹះ មូយ ក្លាំ កម៉ ឞាល់ ដើ អៃ នែ ណាគ់ ផវ អំប៊ិច ឡះ កួន? អ៊ែ ដើ សារ៉ា កំប្រាគ់ ណគ ញឹះ ជែន ជិត កម៉ ឡើយ ពយ៉ិ ណាគ់ លំដូវ ពឝ៉ើត កួន?»។ ");
INSERT INTO brb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","យ៉ាគ់ អាប្រាហាំ ឡើ ឡា ហឹ គ្រែដៃ រៀន៖ «ប៉ាគ់ អ៊ីសម៉ាអ៊ែល លន់ដូវ ពន់ដ្រាយ កាន ចាគ់ ថរ អៃ ឆិ ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ហាក់ គ្រែដៃ ឡើ ត្រណើវ រៀន៖ «អ៊ឺម ទ្រី ហៃ សារ៉ា អ៊ែ លំពឝ៉ើត កួន កឡ មូយ ប៊ឹង ហៃ ម៉ាត់ ម៉ាត! ហន់ជុ ម៉ាត់ កួន ហៃ អ៊ែ “អ៊ីសាគ់”។ អៃ អង់ខណាត ខណាំ ប្លះ ញឺ ដើម ដើ កួន ចូវ ណគ មន់កើត ហឹ អន់ទុន ដិ កាន អខណាត ខណាំ នែ លំណាគ់ អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","«ណគ់ ដើ អ៊ីសម៉ាអ៊ែល អន់ណាវ អៃ អដុង ឡើយ អ្រឡា ហៃ អៃ អំប្រាយ ណគ លំប៊ិច កួន ទុត អើន កួន ចូវ ណគ មន់ស៊ឺក ចាំ អើន ឌិ ហឌិ។ មែ ទិះ ក្រាគ់ ជិត បារ រ៉ា មន់កើត តើម ប៊ឹង ណគ អៃ អន់អាំ ណគ លំវឹរ សុនសាត មូយ ទុត ទិះ។ ");
INSERT INTO brb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ហាក់ កាន អខណាត ខណាំ នែ លំត្រ តគ់ អ៊ីសាគ់ ណគ់ កួន សារ៉ា លំពឝ៉ើត ប៊ឹង ហៃ ហឹ កម៉ អន់ទុន ទឹង ខៃ អន់ណិះ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ប៊្លី គ្រែដៃ ឡើ ហាយ ដើ យ៉ាគ់ អាប្រាហាំ លែវ ឡើយ អ៊ែ ឡើ វីះ តើម ប៊ឹង ណគ ប៉ាត់ តាក់។ ");
INSERT INTO brb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ទឹង តង៉ៃ អន់ទឺ យ៉ាគ់ អាប្រាហាំ ឡើ ច្រា កួន ណគ អ៊ីសម៉ាអ៊ែល ដើម ក៝ត ណគ់ មែ ម៉ើ កើត ទឹង ហន់ណាម ណគ ដើម ក៝ត ណគ ឡើ រួត ដើ ប៉្រាក់ លែក ដើ មែ កឡ ទឹង ហន់ណាម ណគ ម៉ើ បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក តាម ប៉ាគ់ ប្រម៉ាង គ្រែដៃ ឡើ ហាយ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ប៊ឹង យ៉ាគ់ អាប្រាហាំ ឡើ បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក កំប្រាគ់ ណគ ជែន ជិត ជែន កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","អ៊ែ ណគ់ ដើ កួន ណគ អ៊ីសម៉ាអ៊ែល កំប្រាគ់ ណគ ជិត ពែ កម៉ ឡើយ ប៊ឹង ឡើ បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក។ ");
INSERT INTO brb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","យ៉ាគ់ អាប្រាហាំ ដើម អ៊ីសម៉ាអ៊ែល កួន ណគ អំប្រា បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក តង៉ៃ អន់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","អ៊ែ លែក ដើ កឡ ណគ់ ម៉ើ គូ ដើ ណគ ដើម ណគ់ មែ ម៉ើ កើត ទឹង ហន់ណាម ណគ ដឹប ណគ់ ណគ ឡើ រួត ដើ ប៉្រាក់ តើម ប៊ឹង សុនសាត មែ គែង ម៉ើ បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក ប៊ឹង ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","តង៉ៃ ហង់អ៊ិន ទឹង ម៉ាត់ តង៉ៃ ឆុង ដុ ទុត ខាក់ យ៉ាគ់ អាប្រាហាំ ឡើ ដ្រូម ប៊ឹង ឝឡោះ កទូប ណគ ឡើ បើម ដៀក តើម ឈ្រី យ៉ាគ់ ម៉ាមរែ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពដៃ ចាក់ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","យ៉ាគ់ អាប្រាហាំ ឡើ ប៊្រឹក ម៉ាត់ កអវ ឡើ តៃ កឡ ពែ រ៉ា ម៉ើ ឆុង ហឹ ងឺរ ណគ។ ហំប៊្រុះ ឡើ តៃ មែ ឡើ ញឺះ តើម ប៊ឹង កទូប ឡើ ដក់ យ៉ាវ កដាប ហំបះ ប្រយ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ឡើ ម៉ាង រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ប៉ាគ់ ហន់ញឹម ក្លើម ដើ អៃ ញ៉ង ហជឺរ អ៊ឺម អៃ ហង់គូ ប៊ឹង អៃ អន់ដៃ។ ");
INSERT INTO brb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","អំប៉្រៃ មន់ចក់ ដាក ឆះ ឈឹង វែ អឡា វន់ដ្រូម ង៉ូក ហឹ អុះ អូះ តើម ឡង នែ អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","យ៉ាក់ វ៉ើ ប៊ឹះ កទូប អៃ ឡើយ វន់ចាំ អន់ចក់ ចណង់ ចណា កិៗ កគ់ៗ អន់អាំ ដើ វែ វន់ចា ពសូវ អន់ដៃ លែវ អ៊ែ វន់ដក់ ឡឹះ អន់ណាវ»។ ម៉ើ ត្រណើវ រៀន៖ «ហំបើម តាម ប្រម៉ាង ហៃ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","យ៉ាគ់ អាប្រាហាំ ឡើ ដក់ ដ្រិះៗ ប្រយ ហឹ កទូប ឡើ ហាយ ដើ ទ្រី ណគ រៀន៖ «មិញ ហន់ចក់ ភែ ប៊ិះ ណគ់ ញឹមៗ មូយ ឃុ ហំបើម ណុំពាំង អាំ ដ្រិះៗ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ប៊្លី អ៊ែ ឡើ ដក់ អ្រយ៉ាវ ហឹ មែ បយ៉ា បណាន់ ណគ ឡើ ចក់ កួន ឝ៉ូ បិញ ចឡាង មូយ អំប៉ម ឡើ អាំ ហឹ ក៝ត ណគ លន់កជែត បើម កយ៉ិ ដ្រិះៗ។ ");
INSERT INTO brb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","យ៉ាគ់ អាប្រាហាំ ឡើ ចក់ ដាក តោះ ឝ៉ូ ណគ់ ឈុ អន់ឈូគ ដើម កយ៉ិ ច្រឡាត កួន ឝ៉ូ ណគ់ មែ ម៉ើ បើម កយ៉ិ អន់ឌូ ដក់ អាំ ដើ មែ ពែ រ៉ា។ ទឹង ម៉ើ ចង់ ចា ប៊ឹង តើម ឡង ណគ កឡឹ ឡើ ឆុង ដន់ដុ មែ ប៊ឹង អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ប៊្លី អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ «ហឹ ង៉ាយ ទ្រី ហៃ សារ៉ា ឡើ គូ?»។ ឡើ ត្រណើវ រៀន៖ «ហឹ កទូប តគ់ ឡើ គូ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","បឹ មូយ រ៉ា ឡើ ហាយ រៀន៖ «ហឹ កម៉ អន់ទុន ទឹង ខៃ អន់ណិះ ទឺ អន់ដក់ ឡឹះ អន់ណាវ ហឹ នែ ប៊ឹង អ៊ិន ឡើយ សារ៉ា លំប៊ិច កួន កឡ មូយ ម៉ាត់ ម៉ាត»។ យ៉ាគ់ សារ៉ា ឡើ គូ ចង់ហៀង តៃ កណង មែ ប៊ឹង ឝឡោះ កទូប។ ");
INSERT INTO brb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ទឹង អ៊ែ យ៉ាគ់ អាប្រាហាំ អំប្រា យ៉ាគ់ សារ៉ា អំប្រា ក្រាគ់ៗ ម៉ៃ ឡើយ អ៊ែ ណគ់ ដើ យ៉ាគ់ សារ៉ា កំប្រាគ់ ណគ ឡើ ក្លើច ប៊ិច កួន ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","អ៊ែ ឡើ ចអាវ ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «អក្រាគ់ៗ ញឹះ ឞាល់ នែ ឡើយ ណាគ់ ផវ អំប៊ិច ឞិ អិះ កួន? ដើម ក្ល អៃ ឡើ ក្រាគ់ៗ ឡើយ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ដើ យ៉ាគ់ អាប្រាហាំ រៀន៖ «ប៉ិ ឡើ ត្រ សារ៉ា ឡើ ចអាវ ដើម ឡើ ម៉ាង រៀន “ចាក់ អៃ អក្រាគ់ៗ ឞាល់ នែ ឡើយ ណាគ់ អំប៊ិច ឞិ កួន?”។ ");
INSERT INTO brb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","តៃ ប៊ិច កាន អង់ង៉ាយ អ៊ឺម គ្រែដៃ លំបើម តៃ លំដូវ។ តើម ប៊ឹង នែ ណាគ់ ជែន ខៃ អៃ អំប៊ឹះ អន់ណាវ ទិ នែ ប៊ឹង អ៊ិន ឡើយ សារ៉ា លំប៊ិច កួន កឡ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","យ៉ាគ់ សារ៉ា ឡើ ឌូង ទុត ខាក់ អ៊ែ ឡើ ប៉ាវ រៀន៖ «អចអាវ អ៊ឺម ប»។ ហាក់ គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ហចអាវ ម៉ាត់ ម៉ាត ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","លែក មែ ពែ រ៉ា ម៉ើ វីះ តើម ប៊ឹង កនូ យ៉ាគ់ អាប្រាហាំ ម៉ើ ដក់ ពងឺរ ឝ្លាំង ទិ មួង សូដំ។ យ៉ាគ់ អាប្រាហាំ ឡើ ដក់ ឈូន ទ្រូង មែ ឞិត ឞ៊ែត បក់ មន់អ្រឡះ ប្លះ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ប៊ឹង អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ឃឹត រៀន៖ «អន់អំម៉គ់ ឋូវ ដើ យ៉ាគ់ អាប្រាហាំ ណគ់ កាន អៃ អំបើម ដើ មួង សូដំ? ");
INSERT INTO brb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","យ៉ាគ់ អាប្រាហាំ នែ កួន ចូវ ណគ មន់ស៊ឺក តាក អ៊ែ មន់វឹរ សុនសាត មូយ ទុត ទិះ ដើម មន់ប្រិញ ថាំង។ លែក ដើ សុនសាត ទិ ឡាង ប្រិះ មន់ដូវ កាន ចាគ់ យ៉ម ណគ ប៉ាគ់ទឺ ");
INSERT INTO brb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","យ៉ាក់ អៃ អរ៉ើះ ណគ អាំ លំព្រតូវ កួន ដើម ចូវ ណគ ហឹ អន់ទុន អាំ មន់ចង់ហៀង ម៉ាង អៃ អគ្រែដៃ អណាគ់ អន់សច អ៊ែ មន់ណោះ បើម កាន ចាគ់ ទឹង ត្រ។ ប៉ាគ់ មន់ចង់ហៀង អៃ អ៊ែ អង់អាំ ដើ យ៉ាគ់ អាប្រាហាំ តាម ប៉ាគ់ ប្រម៉ាង អៃ អខណាត ដើ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន៖ «ណគ់ ប្រម៉ាង មែ ម៉ើ ចឹន មួង សូដំ ដើម មួង ឝ៉ូម៉ូរ៉ា ឡើ កយឹក ទុត ខាក់ ដើម មែ ទឹង មួង ហង់អ៊ែ ម៉ើ បើម កាន ឞាប ទុត ម៉ៃ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ប៉ាគ់ ពអ៊ែ អន់ទឺះ ឝ្លាំង បក់ អន់ណោះ រៀន កាន តៃ ចាគ់ ណគ់ មែ ម៉ើ បើម អ៊ែ លំដាវ ប៉ាគ់ ប្រម៉ាង មែ ម៉ើ ប៉ច ឋូវ ណោះ ប៉ាគ់ ង៉ាយ។ ដាវ ណោះ តៃ លំដាវ អ៊ែ អន់ណោះ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","អ៊ែ កឡ បារ រ៉ា អំប្រា វីះ ពងឺរ ដក់ ហឹ មួង សូដំ។ អ៊ែ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ណាគ់ ឡើ គូ ប៊ឹង យ៉ាគ់ អាប្រាហាំ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","យ៉ាគ់ អាប្រាហាំ ឡើ ដក់ ចាំ ចើម តគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ ឡើ តង៉ា រៀន៖ «ពយ៉ិ អិះ គ្រែដៃ ហំបលុ ពន់ដម បនឹះ ចនិះ ចាគ់ ទឹង ត្រ ប៊ឹង បនឹះ ចនិះ តៃ ចាគ់ ឡះ? ");
INSERT INTO brb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ប៉ាគ់ ទឹង មួង អ៊ែ លំប៊ិច បនឹះ ចនិះ ចាគ់ ទឹង ត្រ សើង ជិត រ៉ា ប៉ិ គ្រែដៃ ណាគ់ ហំបលុ ដឌែ ឡះ មួង ហង់អ៊ែ? ពយ៉ិ ហន់ឌី អ៊ឺម ឞិ ហន់ស្រុស្រៀត តាក់ ថូត ដើ មែ ញ៉ន បនឹះ ចនិះ ចាគ់ ទឹង ត្រ សើង ជិត រ៉ា អ៊ែ ណគ់ ម៉ើ គូ អរែង ទិ មួង អន់ចុ? ");
INSERT INTO brb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","គ្រែដៃ ហំបើម ប៉ាគ់ នែ ត្រ ឡះ ហន់អាំ បនឹះ ចនិះ ចាគ់ ទឹង ត្រ មន់គែត ដម ប៊ឹង បនឹះ ចនិះ តៃ ចាគ់? ប៉ាគ់ ហំបើម ប៉ាគ់ នែ បនឹះ ចនិះ ចាគ់ ទឹង ត្រ មន់គែត ដម ត្រ អ៊ឺម កឋោះ! ហៃ ឡើយ ហកឡា តាត់ ស៊ិន បនឹះ ទិ ឡាង ប្រិះ នែ ហន់តាត់ ស៊ិន ត្រៗ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ អន់តៃ បនឹះ ចនិះ ចាគ់ ទឹង ត្រ សើង ជិត រ៉ា ទឹង មួង សូដំ អ៊ែ អន់តាក់ ថូត លែក ដើ មែ ទិ មួង អន់ចុ ញ៉ន ដើ បនឹះ ចនិះ ចាគ់ ទឹង ត្រ អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","យ៉ាគ់ អាប្រាហាំ ឡើ ឡា ឡឹះ រៀន៖ «អឡា ឡាប់ ញ៉ម ហៃ គ្រែដៃ កន់ដ្រាគ់ អើយ អុះ អៃ នែ អបនឹះ អន់ទឹក ប្រិះ ទុះ អហាន ច្រម៉ាន ប៊ឹង ហៃ ប៉ាគ់ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ប៉ាគ់ លំប៊ិច បនឹះ ចនិះ ចាគ់ ទឹង ត្រ ពួន ជិត សើង រ៉ា ពយ៉ិ គ្រែដៃ ណាគ់ ហំបលុ ឡះ មួង អន់នែ ញ៉ន បនឹះ ចនិះ ចាគ់ ទឹង ត្រ ឡើ ប៉ាត់ សើង រ៉ា?»។ គ្រែដៃ ឡើ ហាយ រៀន៖ «ប៉ាគ់ អៃ អន់តៃ បនឹះ ចនិះ ចាគ់ ទឹង ត្រ ញឹះ ពួន ជិត សើង រ៉ា អំបលុ អ៊ឺម ប៉ាគ់ទឺ មួង អន់ចុ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","យ៉ាគ់ អាប្រាហាំ ឡើ ឡា ហឹ គ្រែដៃ រៀន៖ «ប៉ាគ់ លំប៊ិច បនឹះ ចនិះ ចាគ់ ទឹង ត្រ ឌិវ ពួន ជិត រ៉ា ណាគ់ ហំបលុ ឡះ?»។ គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ញ៉ន ដើ មែ ពួន ជិត រ៉ា អ៊ែ អៃ តៃ អំបលុ អ៊ឺម មែ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","យ៉ាគ់ អាប្រាហាំ ឡើ ឡាះ ចាក់ រៀន៖ «ឡា គ្រែដៃ កន់ដ្រាគ់ ញ៉ង ហមាំ អ៊ឺម អុះ ដើ អៃ អន់ឡា ណាគ់ មូយ តង អន់ណាវ ហឹ ហៃ។ អំប លំប៊ិច វ៉ិះ ឌិវ ពែ ជិត រ៉ា?»។ គ្រែដៃ ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ លំប៊ិច ពែ ជិត រ៉ា អំបលុ អ៊ឺម ប៉ាគ់ទឺ មែ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","យ៉ាគ់ អាប្រាហាំ ឡើ ឡា រៀន៖ «ឡា គ្រែដៃ កន់ដ្រាគ់ អឡាប់ ញ៉ម ហៃ អុះ អហាន ច្រម៉ាន ប៊ឹង ហៃ អំប លំប៊ិច វ៉ិះ ឌិវ បារ ជិត រ៉ា តៃ ណោះ?»។ គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ លំប៊ិច បារ ជិត រ៉ា អៃ ណាគ់ តៃ អំបលុ អ៊ឺម មួង អន់ចុ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","យ៉ាគ់ អាប្រាហាំ ឡើ ឡាះ ចាក់ រៀន៖ «ឡា គ្រែដៃ កន់ដ្រាគ់ អើយ ញ៉ង ហមាំ អ៊ឺម ដើ អៃ អឡា ណាគ់ មូយ តង ណិះ ឡើយ អំប លំប៊ិច វ៉ិះ ឌិវ ជិត រ៉ា»។ គ្រែដៃ ឡើ ត្រណើវ រៀន៖ «សំ យ៉ះ ជិត រ៉ា កតាម ណាគ់ តៃ អំបលុ ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ប៊្លី គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ចជែ លែវ ឡើយ ឡើ វីះ ប្រយ ខៀង តើម ប៊ឹង យ៉ាគ់ អាប្រាហាំ។ អ៊ែ ដើ យ៉ាគ់ អាប្រាហាំ ឡើ ជឹ វឹញ ហឹ កទូប ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","តគ់ ឡើ អំប៊ឹ ឞាវ គ្រែដៃ បារ រ៉ា អ៊ែ  អំប្រា ប៊ឹះ ហឹ មួង សូដំ ទឹង ប៉ះ យ៉ាគ់ ឡុត ឡើ ដ្រូម ប៊ឹង ឝឡោះ ដ្រក មួង ។ ហំប៊្រុះ យ៉ាគ់ ឡុត ឡើ តៃ អំប្រា ឡើ ឌឹក យ៉ាវ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ឡើ ឡា រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ អច្រា សប្រា លំដក់ មឹត ហឹ ហន់ណាម អៃ អន់ដៃ សប្រា លំឆះ ឈឹង ទី សប្រា លន់កី ប៊ឹង អៃ មូយ មាំង នែ អន់ដៃ ដឹះ ចាំ ប្រណូវ អន់ណាវ សប្រា លំវីះ តើម ភុង មាំង»។ អ៊ែ អំប្រា ត្រណើវ រៀន៖ «អ៊ឺម អំប៊ឹ នែ ញន់ង៉ូក ដ្រូម ហឹ បយឺង មួង ឆិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ញ៉ន យ៉ាគ់ ឡុត ឡើ ច្រា លឡក់ លលៀក អ៊ែ ឞាវ គ្រែដៃ អំប្រា មឹត ប្រយ ហឹ ហន់ណាម ណគ។ អ៊ែ ឡើ បើម ចណង់ ចណា ញឹមៗ ដើម ឡើ ប៊ុះ ណំពាំង តៃ ប៊ិច ប៊ូះ ឡើ អាំ ដើ អំប្រា ចង់ ចា។ ");
INSERT INTO brb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ទឹង អ៊ែ តៃ ដាន់ ម៉ើ ហង់ង៉ាន់ កី អំម៉ឹះ កអវ ឡើ ប៊ិច លែក ដើ កឡ ទឹង មួង សូដំ តៃ ម៉ាង មែ ច្រហើវ ឆា ដើ ប៊ឹះ មែ តង់កង់ ក្រាគ់ ម៉ើ ដក់ វ៉ាង ប្រយ ហន់ណាម យ៉ាគ់ ឡុត។ ");
INSERT INTO brb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","មែ ម៉ើ កឡូវ តង៉ា យ៉ាគ់ ឡុត រៀន៖ «ណគ់ អំប្រា មឹត ហឹ ហន់ណាម ហៃ អំប៊ឹ អន់ឌូ ហឹ ង៉ាយ អំប្រា គូ? ហំពញឺះ អំប្រា ដ្រិះ! ញ៉ើ ងុញ កី តិ អំប្រា»។ ");
INSERT INTO brb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","អ៊ែ យ៉ាគ់ ឡុត ឡើ ញឺះ ហឹ មែ ឡើ ពាំង ដ្រិះៗ ប្រយ កម៉ង តៃ ត្រិច។ ");
INSERT INTO brb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ណគ ឡើ ម៉ាង រៀន៖ «មែ អ៊ូគ ប៉ អើយ អឡា ហឹ វែ ញ៉ង វ៉ើ បើម អ៊ឺម កាន តៃ ចាគ់ ប៉ាគ់ នែ! ");
INSERT INTO brb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","កួន ប្រោះ អៃ បារ រ៉ា តគ់ អំពញឺះ អាំ ដើ វែ ញឹះ តៃ អំប្រា ណោះ កី ដើ កឡ ចណាយ អំម៉ឹះ វន់បើម ប៉ាគ់ ង៉ាយ តមឹង ដើ អំប្រា តាម ឌី វែ កឡឹ ហាក់ អឡា ហឹ វែ ញ៉ង វ៉ើ តំឞាប អឹ តមួយ អៃ នែ យ៉ាក់ អំប្រា មឹត កវាំង ហឹ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","មែ ម៉ើ ត្រណើវ រៀន៖ «ហំវីះ ដ្រិះ!»។ អ៊ែ ម៉ើ ម៉ាង ត្រឌីវ មែ រៀន៖ «នែ វន់ឝ្លាំង បឹ អន់នែ ឡើ បនឹះ តើម តគ់ គែង ឡើ ដក់ មឹត គូ ហឹ ស្រុក ង៉ាយ ណិះៗ នែ ឡើ ងុញ ឌឹក បើម ក្រាគ់ តាត់ កឍី ដើ ង៉ាយ។ ដូវ អ៊ឺម វ៉ើ ណោះ!»។ អ៊ែ ម៉ើ ម៉ាង ដើ យ៉ាគ់ ឡុត រៀន៖ «ប៉ាគ់ ពអ៊ែ ញំបើម ដើ ហៃ ជឺរ ដើ អំប្រា ហឹ កនុង តគ់»។ អ៊ែ ម៉ើ ឝឹ តាក់ យ៉ាគ់ ឡុត ម៉ើ ចន់ដ្រា អង់ឝឹត ឍឹះ ថាក់ កម៉ង។ ");
INSERT INTO brb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ហំប៊្រុះ ដើ អ៊ែ ឞាវ គ្រែដៃ អំប្រា ប៉ើក កម៉ង ញ៉ាក់ យ៉ាគ់ ឡុត តមឹត ហឹ កនុង ប៊្លី អ៊ែ អំប្រា ពាំង កម៉ង រីម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","អ៊ែ អំប្រា ពសូត អន់ដៃ មែ កឡ ម៉ើ គូ ហឹ អរ៉ះ ម៉ើ ហ្រង៉ូម ម៉ាត់ លែក មែ តើម ប៊ឹង មែ ច្រហើវ ឋា ប៊ឹះ មែ តង់កង់ ក្រាគ់ អ៊ែ ម៉ើ បបើត ដាំង កម៉ង មឹត ទឹង ហន់ណាម ណោះ យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ឞាវ គ្រែដៃ អំប្រា តង៉ា យ៉ាគ់ ឡុត រៀន៖ «ប៊ិច មែ ង៉ាយ ដិ ទឹង ក្រាន ហៃ? ប៉ាគ់ ហំប៊ិច កួន ព្រសាវ កួន កឡ ដើម កួន កទ្រី ប៉ាគ់ ហំប៊ិច ព្រឝ៉ើត យូ ទឹង មួង អន់នែ ហន់ច្រា វីះ អាំ លែក។ ");
INSERT INTO brb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ញឺ ដៀប ញំបលុ តាក់ ឡើយ មួង អន់នែ យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ដុង ម៉ើ ប៉ច មួង អន់នែ ម៉ើ បើម កាន តៃ ចាគ់ ទុត កយឹក ទឹង ណគ។ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ញឺ ទឺះ បលុ តាក់ មួង អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","យ៉ាគ់ ឡុត ឡើ ញឺះ ដក់ ពហាយ ដើ កួន ព្រសាវ ណគ ណគ់ ម៉ើ អ្រឡាង ក្រាគ់ ប៊ឹង កួន ណគ ឡើ រៀន៖ «អើយ ញ៉ះ ញន់វីះ តើម ប៊ឹង នែ យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ដៀប លំបលុ តាក់ ឡើយ មួង អន់នែ!»។ ហាក់ កួន ព្រសាវ ណគ ម៉ើ ចាប់ អ៊ឺម ម៉ាង ណគ ម៉ើ ឃឹត រៀន អំប ឡើ ម៉ាង រួយ។ ");
INSERT INTO brb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","តគ់ ឡើ ប្រាង ត្រះ លឹម បលឹម ឞាវ គ្រែដៃ អំប្រា ឡើ ប៉្រៃ កន់សឹត យ៉ាគ់ ឡុត រៀន៖ «មិញ ហន់ឌឹក ហន់ច្រា ទ្រី ហៃ ដើម អំប្រា កួន ប្រោះ ហៃ នែ វន់វីះ អាំ ដ្រិះៗ ញ៉ង អាំ វន់គែត ដម ប៊ឹង ញំបលុ មួង អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ហាក់ ដើ យ៉ាគ់ ឡុត ឡើ វីះ ញ៉ាក់ ពញ៉ាក ដឌែ អ៊ែ ឞាវ គ្រែដៃ អំប្រា រ៉ាប់ ទី ណគ ទី ទ្រី ណគ ដើម អំប្រា កួន ប្រោះ ណគ អំប្រា តៀត តវីះ ហឹ ដៀក មួង ញ៉ង អាំ មន់គែត យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ស្រុស្រៀត ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ទឹង អំប្រា តៀត មែ ក្លើច តើម ប៊ឹង មួង ឡើយ អ៊ែ ឞាវ គ្រែដៃ មូយ រ៉ា ឡើ ប៉្រៃ រៀន៖ «វន់អ្រយ៉ាវ អាំ ក្លើច ដ្រិះ! ញ៉ង វន់ហវីវ ឝ្លាំង អ៊ឺម ហឹ ត្រិច! ញ៉ង វន់ជឹង ប្លះ ត្រិញ ធែរ! វន់ត្រយ៉ាវ អាំ ប៊ឹះ ចន់ឌូ ទិ អ៊ែ ណាគ់ វន់ញិវ»។ ");
INSERT INTO brb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","យ៉ាគ់ ឡុត ឡើ ឡា ហឹ ឞាវ គ្រែដៃ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ បក់ អ៊ឺម ញំបើម ប៉ាគ់ ប្រម៉ាង ហៃ អ៊ិន! ");
INSERT INTO brb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ហញឹម ក្លើម ដើ អៃ ឞាល់ នែ ហស្រុស្រៀត អៃ ញឹះ តៃ ហតាក់ ហហវ៉ាត់ ពញិវ អៃ។ ផវ អឹ អន់ដាន់ អន់អ្រយ៉ាវ ទឹង ចន់ឌូ ទិ កឡាគ់ កាន ខគ់ណាំ លំដាន់ អៃ ឝ៉ាន់ អន់គែត។ ");
INSERT INTO brb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ឡា យ៉ាគ់ កន់ដ្រាគ់ តគ់ ប៊ិច មួង កិ មូយ ឡើ ចើម ប្លះ នែ ហង់អាំ អៃ អន់អ្រយ៉ាវ ដក់ ឆ្រុក ហឹ អ៊ែ អន់ដៃ អ៊ែ ណាគ់ អន់ញិវ! ញ៉ង ហបលុ អ៊ឺម មួង ហង់អ៊ែ យ៉ាក់ ឡើ កិៗ ម៉ាត!»។ ");
INSERT INTO brb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ឞាវ គ្រែដៃ ឡើ ត្រណើវ ណគ រៀន៖ «អំផម ប៉ាគ់ ប្រម៉ាង ហៃ អំបលុ អ៊ឺម ណគ់ មួង កិ ហៃ ហឡា គូ តគ់។ ");
INSERT INTO brb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","មិញ ហន់ត្រយ៉ាវ ដ្រិះៗ អាំ ប៊ឹះ មួង អន់តគ់ ឆិ ទឹង ហូច ហំប៊ឹះ ដូវ អំម៉ឹះ អំបលុ»។ ញ៉ន អ៊ែ ឡើយ ម៉ើ ជុ មួង អ៊ែ រៀន «មួង សូអារ »។ ");
INSERT INTO brb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ទឹង យ៉ាគ់ ឡុត ឡើ មឹត ហឹ មួង សូអារ ម៉ាត់ តង៉ៃ ឡើ ឌឹក ឆិ ថាញ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ហំប៊្រុះ ដើ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កលីះ ក្រលៀត អ៊ុញ តើម ទិ គ្រែ ឡើ បើម ប៉ាគ់ អំមឺ ឡើ គ្លីះ ទិ មួង សូដំ ដើម មួង ឝ៉ូម៉ូរ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ បលុ ចុះ លែក បារ មួង លែក ដើ ត្រិញ ង៉ាវ ឡាវ ឡាំង ដើម លែក ដើ បនឹះ ម៉ើ គូ ទឹង មួង តៃ ម៉ាង ដណាំ ដណូយ បាត់ ប៊្រី ឡើ ហួន ហឹ ត្រិញ ឡើ ប៉ាត់ ពណាត់ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ណគ់ ដើ ទ្រី យ៉ាគ់ ឡុត ឡើ ហវីវ ឝ្លាំង ហឹ ត្រិច អ៊ែ ឡើ កន វឹរ បោះ ឆរ៉ឹង ប្រយ ឡើ គូ។ ");
INSERT INTO brb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","តង៉ៃ អន់ទឺ តៃ នែ យ៉ាគ់ អាប្រាហាំ ឡើ រ៉ៃ តើម ភុង មាំង ឡើ ដក់ ហឹ កនូ ណគ ឡើ ចជែ អរែង ប៊ឹង គ្រែដៃ ឡើ ណាគ់ អន់សច ដមាំង។ ");
INSERT INTO brb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ឡើ បយ៉ើល ឝ្លាំង ប្រយ ទិ មួង សូដំ ដើម មួង ឝ៉ូម៉ូរ៉ា បុ ត្រិញ ង៉ាវ ឡាវ ឡាំង ឡើ តៃ ម៉ាត់តូវ អន់ញូយ ឡើ ឃូយ តើម ប៊ឹង ប្រិះ ឞាល់ ម៉ើ ចុះ មឺរ។ ");
INSERT INTO brb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ទឹង គ្រែដៃ ឡើ បលុ មួង បុ ត្រិញ ង៉ាវ ឡាវ ឡាំង អ៊ែ គ្រែដៃ ឡើ ចនិះ ហឹ អ្រឡា យ៉ាគ់ អាប្រាហាំ អ៊ែ ឡើ ច្រា អន់នួរ យ៉ាគ់ ឡុត វីះ តើម ប៊ឹង មួង រុងរ៉ាយ លែក អ៊ែ អាំ លន់ក្លើច តើម ប៊ឹង កាន គែត។ ");
INSERT INTO brb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","យ៉ាគ់ ឡុត ដើម កួន កទ្រី ណគ លែក បារ រ៉ា ម៉ើ វីះ តើម ប៊ឹង មួង សូអារ ឌឹក គូ ទឹង អ៊ឹបៗ ច្រាង ចន់ឌូ យ៉ាក់ យ៉ាគ់ ឡុត ឡើ មាំ យ៉ាវ គូ ទឹង មួង សូអារ។ ");
INSERT INTO brb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ប៊ឹង អ៊ែ ម៉ុ ណគ ឡើ ចជែ ដើ អោះ ណគ រៀន៖ «ត្រំ ឞន ទឹង ឡាង ប្រិះ នែ បនឹះ ម៉ើ ខើយ ចក់ ទ្រី ក្ល ហាក់ ទឹង ស្រុក អន់នែ ឡើ ប៊ិច អ៊ឺម កឡ មន់ចក់ បា បើម ទ្រី ប៉ាគ់ ដើ មែ ដើម បើគ បា ឡើ ក្រាគ់ៗ ឡើយ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","បាគ់ អើយ បន់ពញែត យូរ បើគ អ៊ែ បន់ដូវ កី ដើ ណគ បក់ បន់ប៊ិច កួន ប៊ឹង ណគ ថរ បើគ បា»។ ");
INSERT INTO brb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","អំប៊ឹ អ៊ែ អំប្រា ពញែត យូរ ប្រយ បើគ អំប្រា។ លែវ អ៊ែ ម៉ុ ណគ ឡើ មឹត កី អន់នួរ ដើ បើគ អំប្រា ហាក់ យ៉ាគ់ ឡុត តៃ ឡើ ណោះ ឍិង ឋាំង យ៉ាវ អ៊ែ ឡើ ណោះ យ៉ាវ កួន ណគ មឹត កី ដើ ណគ ដើម ឡើ ញឺះ តើម ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","តគ់ ប្រណូវ ម៉ុ ណគ ឡើ ម៉ាង ដើ អោះ ណគ រៀន៖ «មាំង អ៊ិន អៃ អដូវ កី គូ ដើ ណគ លែវ ឡើយ មាំង នែ បន់ពញែត យូរ ឡឹះ ណគ អ៊ែ ហៃ អន់ណាវ ហន់កី ដើ ណគ អ៊ែ បន់ប៊ិច កួន ថរ បើគ បា»។ ");
INSERT INTO brb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","មាំង អ៊ែ អំប្រា ពញែត យូរ ឡឹះ អន់ណាវ បើគ អំប្រា អ៊ែ អោះ ណគ អន់ណាវ ឡើ កី ដើ បើគ ណគ ហាក់ ណគ កឡឹ តៃ ឡើ ណោះ ឍិង ឋាំង យ៉ាវ អ៊ែ ឡើ ណោះ យ៉ាវ កួន ណគ មឹត កី ដើ ណគ ដើម ឡើ ញឺះ តើម ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","តគ់ លែវ អ៊ែ កួន យ៉ាគ់ ឡុត អំប្រា តមែវ ប្រយ ដើ បើគ អំប្រា កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ម៉ុ ណគ ឡើ អន់ឆិ កួន កឡ មូយ ឡើ ជុ ម៉ាត់ កួន ណគ “ម៉ូអាប់”។ អន់នែ ឡើយ ម៉ិ យ៉ាគ់ មែ សុនសាត ម៉ូអាប់ ប៊ឹះ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","អោះ ណគ ឡើ អន់ឆិ កួន កឡ មូយ ប៉ាគ់ទឺ ឡើ ជុ ម៉ាត់ កួន ណគ ប៊ែនអាំមី ឡើ ត្រ ម៉ិ យ៉ាគ់ មែ សុនសាត អាំម៉ូន ប៊ឹះ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","យ៉ាគ់ អាប្រាហាំ ឡើ វីះ តើម ប៊ឹង តើម ឈ្រី យ៉ាគ់ ម៉ាមរែ ឡើ ដក់ គូ ហឹ ឞន នែឝ៉ិប។ ឡើ បើម កនូ ប្លះ មួង កាឌែះ អំប្រា ត្រិញ ស៊ូរ។ ប៊្លី អ៊ែ ឡើ ដក់ គូ ហឹ ដៀក មួង ឝែរ៉ា អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","យ៉ាគ់ អាប្រាហាំ ឡើ អំម៉គ់ ទ្រី ណគ យ៉ាគ់ សារ៉ា ឡើ ហាយ ដើ មែ រៀន អោះ ណគ។ អ៊ែ យ៉ាគ់ អាប៊ីម៉ាលែក សឋិច មួង ឝែរ៉ា ឡើ ប៉្រៃ មែ ម៉ើ ដក់ ចក់ យ៉ាគ់ សារ៉ា ដើ ណគ លំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","មាំង ហង់អ៊ិន យ៉ាគ់ សឋិច អាប៊ីម៉ាលែក ឡើ ពកី តៃ គ្រែដៃ ឡើ ហាយ ដើ ណគ រៀន៖ «ហៃ ហង់គែត ញ៉ន ដើ កទ្រី ណគ់ ហៃ ហចក់ បើម ទ្រី យ៉ាក់ ណគ ឡើ ប៊ិច ក្ល ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ហាក់ សឋិច អាប៊ីម៉ាលែក ឡើ កី គូ អំម៉ឹះ ដើ យ៉ាគ់ សារ៉ា អ៊ែ ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ យ៉ាក់ តៃ អបើម យូច អំម៉ឹះ ណាគ់ ហន់កជែត ឡះ អៃ ដើម សុនសាត អៃ នែ សំយ៉ះ ញ៉ើ ចាគ់ ទឹង ត្រ? ");
INSERT INTO brb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","បឹ ហង់អ៊ែ កឡឹ ហវ៉ៃ ឡើ ហាយ ដើ អៃ រៀន ណាង ហង់អ៊ែ អោះ ណគ! អ៊ែ កទ្រី ហង់អ៊ែ ឡើ ហាយ ដើ អៃ រៀន បឹ ហង់អ៊ែ អ៊ូគ ណគ ប៉ាគ់ទឺ។ អៃ អបើម ប៉ាគ់ នែ អឃឹត ឡើ ចាគ់ អងុញ អ៊ឺម អំបើម អន់យូច»។ ");
INSERT INTO brb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","គ្រែដៃ ឡើ ត្រណើវ សឋិច អាប៊ីម៉ាលែក កនុង ពកី អ៊ែ រៀន៖ «អៃ អណោះ ហឡាក់ ប៉ាគ់ទឺ ឡើយ ហៃ ហបើម ប៉ាគ់ អ៊ែ ញ៉ន ហប៊ិច ចនិះ ចាគ់ អ៊ែ អអាំ អ៊ឺម ហៃ ហំបើម កាន ឞាប ហន់យូច ដើ អៃ។ អ៊ែ អពន់ឋូយ អ៊ឺម ហៃ ហកី គូ ដើ ណាង ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ណិះៗ នែ ហន់ឈូន ហំមិញ ណាង អ៊ែ ហឹ ក្ល ណគ កឡឹ យ៉ាក់ ណគ ឡើ កឡា ឈូន ប្រម៉ាង អៃ លំឡា ហឹ អៃ ដើ ហៃ អ៊ែ ណាគ់ ហន់ញិវ។ ហាក់ ប៉ាគ់ តៃ ហន់ឈូន ណាង អ៊ែ ហឹ ក្ល ណគ ហៃ ដើម លែក ដើ មែ ទឹង ក្រាន ហៃ វន់ណោះ ឌិវ គែត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","សឋិច អាប៊ីម៉ាលែក ឡើ រ៉ៃ តើម ភុង មាំង ឡើ កឡូវ លែក ដើ មែ ទិះ ក្រាគ់ ដក់ ហឹ ណគ អ៊ែ ឡើ ប៉ច ពកី ណគ ដើ មែ មែ ទិះ ក្រាគ់ ម៉ើ ឌូង ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ប៊្លី អ៊ែ សឋិច អាប៊ីម៉ាលែក ឡើ កឡូវ យ៉ាគ់ អាប្រាហាំ ដក់ ហឹ ណគ អ៊ែ ឡើ ម៉ាង ពន់ដូះ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ ហបើម ដើ ញ៉ា ប៉ាគ់ នែ? អបើម អន់យូច អង់ង៉ាយ ដើ ហៃ អ៊ែ ហបើម អាំ សាត ញ៉ា ដឹប អៃ ញ៉ើ យូច កយឹក ឞាល់ នែ? ហបើម ដើ អៃ ប៉ាគ់ នែ ត្រ អ៊ឺម ហណោះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ឡើ ម៉ាង ឡឹះ រៀន៖ «ប៉ិ ត្រ ហបើម ប៉ាគ់ នែ ហរៀន ត្រ អ៊ឺម ទ្រី ហៃ ណាង អន់នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «អបើម ប៉ាគ់ នែ យ៉ាក់ អឃឹត រៀន ទឹង ស្រុក អន់នែ អំប មន់អៀល បឹះ អ៊ឺម គ្រែដៃ អាត មន់កជែត ឡើយ អៃ ញ៉ន ដើ ទ្រី អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","មូយ ឡឹះ អន់ណាវ ណាង នែ អោះ អៃ ម៉ាត់ ម៉ាត យ៉ាក់ ណគ នែ កួន បើគ អៃ ប៉ាគ់ទឺ វ៉ិះ ឌិវ មែគ ដិៗ ប្លះ ញឺ អ៊ែ ញ៉ើ ច្រណក់។ ");
INSERT INTO brb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ប៊ឹង គ្រែដៃ ឡើ តៀត អៃ ហឹ ស្រុក មែ គែង វីះ តើម ប៊ឹង ហន់ណាម ក្រាន បើគ អៃ អ៊ែ អថាន់ ទ្រី អៃ រៀន “ប៉ាគ់ បន់ដក់ ហឹ ង៉ាយ កតាម ឡា ហន់ស្រុស្រៀត អៃ អុះ ហន់ហាយ ដើ មែ រៀន អៃ នែ អ៊ូគ ហៃ”»។ ");
INSERT INTO brb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","សឋិច អាប៊ីម៉ាលែក ឡើ ឈូន យ៉ាគ់ សារ៉ា ហឹ ក្ល ណគ កឡឹ ទឺ ដើម ឡើ អាំ ឝ៉ូ ចៀម ប៉ិន ខក ដើម ក៝ត កទ្រី ដឹប កឡ ដើ ប្រណគ។ ");
INSERT INTO brb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","សឋិច ឡើ ម៉ាង រៀន៖ «ហន់ឝ្លាំង ប៊្រី ដាក អៃ នែ ឡើ ឌឺះ ឞាល់ នែ ហន់គូ ប៊ឹង ង៉ាយ កតាម តាម ប្រម៉ើត ហៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","សឋិច អាប៊ីម៉ាលែក ឡើ ម៉ាង ដើ យ៉ាគ់ សារ៉ា រៀន៖ «អៃ អអាំ លៀន ពណាំង ម៉ាត់ ដើ ក្ល ហៃ មូយ ហលិក កាក់ ប៉្រាក់ បក់ លែក ដើ មែ ម៉ើ គូ អរែង ប៊ឹង ហៃ មន់តៃ ហឡាក់ ប៉ាគ់ទឺ ហយូច អ៊ឺម ញឹះ ឆិ ហន់កម៉ាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","យ៉ាគ់ អាប្រាហាំ ឡើ អ៊ឺរ ដាំង ឡា ទឹង គ្រែដៃ ដើ សឋិច អាប៊ីម៉ាលែក។ អ៊ែ គ្រែដៃ ឡើ ពនៀម យ៉ាគ់ សឋិច ដើម ទ្រី ណគ ដើម មែ កទ្រី ក៝ត ណគ តើម ប៊ឹង អ៊ែ លែក ដើ មែ ម៉ើ ដូវ ប៊ិច កួន ចូវ ឡឹះ អន់ណាវ ");
INSERT INTO brb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ បើម អាំ លែក ដើ កទ្រី ទឹង ហន់ណាម ក្រាន យ៉ាគ់ សឋិច អាប៊ីម៉ាលែក ម៉ើ វឹរ កទ្រី កន់ដុង ញ៉ន ឡើ ចក់ យ៉ាគ់ សារ៉ា ទ្រី យ៉ាគ់ អាប្រាហាំ។ ");
INSERT INTO brb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉ូរ យ៉ាគ់ សារ៉ា ឡើ អាំ ប៉ាគ់ ណគ ឡើ ខណាត ពន់ឋើម ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","អ៊ែ យ៉ាគ់ សារ៉ា ឡើ តមែវ ប្រយ ឡើ អន់ឆិ កួន កឡ មូយ ប៊ឹង យ៉ាគ់ អាប្រាហាំ តគ់ ឡើ ក្រាគ់ៗ ឡើ ត្រ ទឹង ខៃ ប៉ាគ់ គ្រែដៃ ឡើ ខណាត ដើ ណគ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","យ៉ាគ់ អាប្រាហាំ ឡើ ជុ ម៉ាត់ កួន ណគ ណគ់ យ៉ាគ់ សារ៉ា ឡើ ពឝ៉ើត អ៊ែ “អ៊ីសាគ់”។ ");
INSERT INTO brb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","តគ់ អ៊ីសាគ់ ឡើ កើត ដូវ ថាម តង៉ៃ ឡើយ អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក ដើ កួន ណគ តាម ប៉ាគ់ គ្រែដៃ ឡើ ប៉្រៃ។ ");
INSERT INTO brb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","តគ់ អ៊ីសាគ់ ឡើ កើត យ៉ាគ់ អាប្រាហាំ កំប្រាគ់ ណគ មូយ ក្លាំ កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ប៊ឹង អ៊ែ យ៉ាគ់ សារ៉ា ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ ប៉្រៃ អៃ អន់ញឹម ក្លើម តូវ អចអាវ ប៉ាគ់ មែ ង៉ាយ មន់ដុង អៃ អប៊ិច កួន មន់ញឹម ក្លើម ដើម មន់ចអាវ ប៉ាគ់ ដើ អៃ កឡឹ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ឡើ ម៉ាង ឡឹះ រៀន៖ «ទឹង ពន់ឋើម តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ ហាយ ដើ យ៉ាគ់ អាប្រាហាំ រៀន តង៉ៃ មូយ យ៉ាគ់ សារ៉ា លំតពុ ឡើយ កួន។ តគ់ ណិះៗ នែ ញ៉ើ ប៊ិច កួន កឡ មូយ សំយ៉ះ ញ៉ើ ក្រាគ់ៗ ម៉ៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","តគ់ អ៊ីសាគ់ ឡើ ទិះ ឆិ ណោះ កំប្រក់ មែគ ណគ ឡើ អាំ យ៉ាវ ពុ។ អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ បើម ឞ៊ុន ចង់ ចា ទុត ទិះ ទឹង តង៉ៃ មែគ ណគ ឡើ អាំ យ៉ាវ ពុ។ ");
INSERT INTO brb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ទឹង អ៊ែ យ៉ាគ់ សារ៉ា ឡើ តៃ អ៊ីសម៉ាអ៊ែល កួន ណាង ហាឝ៉ារ ឡើ សុនសាត អ៊ែស៊ីប ឡើ ពឝ៉ើត ប៊ឹង យ៉ាគ់ អាប្រាហាំ ទឹង ឡើ ប្រលែក ចអាវ។ ");
INSERT INTO brb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","អ៊ែ យ៉ាគ់ សារ៉ា ឡើ ប៉្រៃ យ៉ាគ់ អាប្រាហាំ រៀន៖ «ហំពន់ឌ្រុះ តវីះ ក៝ត កទ្រី អន់នែ ដើម កួន ណគ យ៉ាក់ អអាំ អ៊ឺម កួន ក៝ត នែ លន់ចក់ មូន អរែង ប៊ឹង កួន អៃ អ៊ីសាគ់»។ ");
INSERT INTO brb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ប្រម៉ាង នែ ឡើ បើម អាំ យ៉ាគ់ អាប្រាហាំ ឡើ គ្លីះ ក្លើម ស្រៀវ យ៉ាក់ អ៊ីសម៉ាអ៊ែល នែ កួន ណគ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ហាក់ គ្រែដៃ ឡើ ម៉ាង ដើ យ៉ាគ់ អាប្រាហាំ រៀន៖ «ញ៉ង ហទុត ចនិះ អ៊ឺម ដើ កួន ហៃ អន់នែ ដើម ដើ ក៝ត ហៃ ណាង ហាឝ៉ារ នែ។ ហំបើម តាម ប៉ាគ់ ប្រម៉ាង សារ៉ា អិះ ឡើយ យ៉ាក់ ឌិវ កួន ចូវ អ៊ីសាគ់ អិះ ឡើយ មន់ថរ ម៉ាត់ ហៃ ។ ");
INSERT INTO brb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","អ៊ែ ណគ់ កួន ណាង ហាឝ៉ារ ក៝ត ហៃ អន់ណាវ អៃ អង់អាំ ណគ លំវឹរ មូយ សុនសាត យ៉ាក់ ណគ អ៊ែ កួន ហៃ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","តគ់ ប្រណូវ យ៉ាគ់ អាប្រាហាំ ឡើ រ៉ៃ តើម ភុង មាំង ឡើ រន់ឋាប់ មៀន ចណង់ ចណា ដើម ដាក ព្លូយ ម៉ើ បើម ដើ ហពែក ឡើ អាំ ដើ ណាង ហាឝ៉ារ ឡើ តបាក់ ទិ ប៉ាវ  ប៊្លី អ៊ែ ឡើ ប៉្រៃ អំប្រា វីះ។ ណាង ហាឝ៉ារ អំប្រា កួន ណគ អំប្រា វីះ ប្រយ តើម ប៊ឹង អ៊ែ អ៊ែ ឡើ ដក់ ដវ៉ើ ដវ៉ាយ ប្លះ កឌី ត្រិញ ទិះ ដៀប ស៊្រុក ប៊ែរ ស៊ែបា។ ");
INSERT INTO brb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","តគ់ ឡើ លែក ដាក ណាង ហាឝ៉ារ ឡើ តាក់ កួន ណគ ប៊ឹង តើម ឡង កិៗ ");
INSERT INTO brb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ប៊្លី អ៊ែ ឡើ ដក់ ដ្រូម ចង៉ាយ តើម ប៊ឹង កួន ណគ ឆិ តូវ ប៉ិញ ដើ ស្រាវ ឡើ ឃឹត រៀន៖ «អឌី អ៊ឺម អន់តៃ កួន អៃ លន់គែត ប៊ឹង ម៉ាត់»។ អ៊ែ ឡើ ដ្រូម ញឺម ហរ៉ាវ កឡះ ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","គ្រែដៃ ឡើ ដុង ប្រយ ឆ្រញឺម កួន ណគ អ៊ែ ឞាវ គ្រែដៃ ឡើ កឡូវ ណាង ហាឝ៉ារ តើម ទិ គ្រែ រៀន៖ «ណាង ហាឝ៉ារ អើយ ហប៊ិច កាន ង៉ាយ? ញ៉ង ហឌូង អ៊ឺម យ៉ាក់ គ្រែដៃ ឡើ ដុង ឆ្រញឺម កួន ហៃ ប៊ឹង ហជុ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","មិញ ហន់ឌឹក ដក់ ប៊្រឹក កួន កឡ ហៃ ហន់កន់ទ្រែង ណគ យ៉ាក់ អន់អាំ ដើ ណគ លំវឹរ សុនសាត មូយ ទុត ទិះ»។ ");
INSERT INTO brb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","អ៊ែ គ្រែដៃ ឡើ អាំ ដើ ណាង ហាឝ៉ារ ឡើ តៃ ដាក រន់ឋូវ មូយ ណាង ឡើ ដក់ ឈិត ប្រយ ដាក ប៊ិង ព្លូយ ឡើ ជឹ អាំ ដើ កួន ណគ ញែត។ ");
INSERT INTO brb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","គ្រែដៃ ឡើ លវាំង ឝ្លាំង អង់គ្លែត នែ។ ទឹង ឡើ ទិះ អន់ឆើន អើន កម៉ ឡើយ ឡើ គូ ហឹ ត្រិញ ទិះ ដើម ឡើ ណោះ ពប៉ូត ពប៉ិញ ដើ ស្រាវ ឌិវ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ឡើ គូ ហឹ ត្រិញ ទិះ ប៉ារ៉ាន អ៊ែ មែគ ណគ ឡើ ដក់ យ៉ាគ់វឺ ប្រយ មែ កទ្រី តើម ប៊ឹង ស្រុក អ៊ែស៊ីប លំប្រយ៉ង់ ប៊ឹង កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ទឹង អ៊ែ យ៉ាគ់ សឋិច អាប៊ីម៉ាលែក ដើម យ៉ាគ់ ភីកុល ឡើ ណាយ តហាន ណគ អំប្រា ដក់ ហឹ យ៉ាគ់ អាប្រាហាំ។ សឋិច អាប៊ីម៉ាលែក ឡើ ហាយ ដើ យ៉ាគ់ អាប្រាហាំ រៀន៖ «គ្រែដៃ ឡើ លវាំង ឝ្លាំង ហៃ ត្រំ កាន ហៃ ហបើម។ ");
INSERT INTO brb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ប៉ាគ់ ពអ៊ែ ហន់ខណាត តប៉ឹន ចាក់ ប៊ឹង ងឺរ គ្រែដៃ អរែង ប៊ឹង អៃ ណិះៗ ឡើយ ញ៉ង ហតបូត ហំបើម ត្រៗ ដើ អៃ ដើម ដើ កួន អៃ លឺ ដើ កួន ចូវ អៃ ហឹ ខៃ ណូវ។ ប៉ាគ់ ង៉ាយ ហតៃ អៃ អបើម អន់ចាគ់ ដើ ហៃ អឡា ហៃ ហំបើម អន់ចាគ់ ប៉ាគ់ទឺ អ៊ែ ឡើយ ដើ អៃ ដើម ដើ មែ ទឹង ប៊្រី ដាក អៃ ណគ់ ហៃ ហដក់ គូ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ ម៉ាង សឋិច រៀន៖ «អៃ អន់ខណាត តប៉ឹន ចាក់ តាម ប្រម៉ាង ហៃ ឆិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","អ៊ែ ដើ យ៉ាគ់ អាប្រាហាំ ឡើ ពន់ដូះ យ៉ាគ់ សឋិច អាប៊ីម៉ាលែក កាន ដាក រន់ឋូវ ក៝ត យ៉ាគ់ អាប៊ីម៉ាលែក ម៉ើ ចក់ តើម ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","សឋិច ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ អ៊ិន អណោះ អ៊ឺម ប អៃ យ៉ាក់ ហហាយ អ៊ឺម ដើ អៃ ណោះ មែ ង៉ាយ ម៉ើ បើម ប៉ាគ់ អ៊ិន ហន់ដើម ណិះ ឡើយ អដុង»។ ");
INSERT INTO brb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","យ៉ាគ់ អាប្រាហាំ ឡើ ចក់ ប្រយ ចៀម ដើម ឝ៉ូ ឡើ អាំ ដើ សឋិច អាប៊ីម៉ាលែក អ៊ែ អំប្រា ខណាត ផ្រណម អ្រឡាប់ ប្លះ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ប៊្លី អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ កះ ចៀម កទ្រី បិញ ចឡាង ប៉ឹះ អំប៉ម ឡើ ជុ ដិៗ។ ");
INSERT INTO brb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","សឋិច អាប៊ីម៉ាលែក ឡើ តង៉ា ណគ រៀន៖ «ហកះ បើម ង៉ាយ ចៀម ប៉ឹះ អំប៉ម នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «ចៀម ប៉ឹះ អំប៉ម នែ អម៉ប អាំ ដើ ហៃ ឡើយ។ ប៉ាគ់ ហំផម ចក់ អ៊ែ មន់ណោះ ហឡាក់ រៀន រន់ឋូវ នែ អចះ ដើ ទី អៃ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ញ៉ន អ៊ែ ឡើយ កនូ ប្លះ នែ ម៉ើ ជុ រៀន “ប៊ែរ ស៊ែបា” យ៉ាក់ ប៊ឹង នែ ឡើយ អំប្រា ខណាត តប៉ឹន ចាក់ ប្លះ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ប៊ឹង ប៊ែរ ស៊ែបា អ៊ែ ឡើយ អំប្រា ខណាត ផ្រណម អ្រឡាប់ ត្រឌីវ អំប្រា។ ប៊្លី អ៊ែ សឋិច អាប៊ីម៉ាលែក ដើម ភីកុល ឡើ ណាយ តហាន ណគ អំប្រា ជឹ វឹញ ហឹ ស្រុក ភីលីសទីន ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","យ៉ាគ់ អាប្រាហាំ ឡើ ដាំ ឡង មូយ តើម ហឹ ប៊ែរ ស៊ែបា ប៊ឹង អ៊ែ ឡើយ ឡើ កឡូវ អ៊ឺរ ដាំង គ្រែដៃ ឡើ ណាគ់ អន់សច ម៉ើ ជុ រៀន គ្រែដៃ ឡើ ញិវ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","យ៉ាគ់ អាប្រាហាំ ឡើ គូ ហឹ ស្រុក ភីលីសទីន ណាគ់ ទុត ឌុញ។ ");
INSERT INTO brb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ប៊្លី អ៊ែ គ្រែដៃ ឡើ បឡង ឝ្លាំង ចនិះ យ៉ាគ់ អាប្រាហាំ អ៊ែ ឡើ កឡូវ រៀន៖ «អាប្រាហាំ អើយ!»។ យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «ង៉ាយ យ៉ាគ់ កន់ដ្រាគ់?»។ ");
INSERT INTO brb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","គ្រែដៃ ឡើ ប៉្រៃ ណគ រៀន៖ «ហន់ចក់ កួន ប្រម៉ើត ហៃ អ៊ីសាគ់ អ៊ែ កួន ហៃ មូយ រ៉ា នែ ហន់ច្រា ដក់ ហឹ ស្រុក ម៉ូរីយ៉ា តគ់។ ហឹ អ៊ែ ហន់កជែត ប៊ុះ ថួយ ដើ អៃ ទឹង ចន់ឌូ ណគ់ អៃ អន់ហាយ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","យ៉ាគ់ អាប្រាហាំ ឡើ រ៉ៃ ប្រយ តើម ភុង មាំង អ៊ែ ឡើ កណះ អន់ដ្រិះ លំប៊ុះ ថនួយ ឡើ ព្រឌុក ពឺង កណង សិះ លៀ ណគ អ៊ែ ឡើ ច្រា ប្រយ ក៝ត ច្រហើវ ណគ បារ រ៉ា ពែ ដើ អ៊ីសាគ់ កួន ណគ កឡឹ។ ប៊្លី អ៊ែ ម៉ើ ដក់ ប្រយ ហឹ ឞន គ្រែដៃ ឡើ ហាយ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ម៉ើ ដក់ ញឹះ ពែ តង៉ៃ ឡើយ អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ បយ៉ើល ឝ្លាំង ឡើ តៃ ប្រយ ចន់ឌូ អ៊ែ តើម ប៊ឹង ចង៉ាយៗ។ ");
INSERT INTO brb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","យ៉ាគ់ អាប្រាហាំ ឡើ ថាន់ ក៝ត ណគ ឡើ រៀន៖ «សប្រា លន់ចាំ សិះ លៀ ប៊ឹង ណិះ ឡើយ យ៉ឹ ញឺ កួន អៃ ញន់ឌឹក កដាប ហំបះ គ្រែដៃ ទឹង ចន់ឌូ ទិ ប៊្លី អ៊ែ ញន់ជឹ វឹញ ទិ សប្រា ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ចក់ អន់ដ្រិះ បក់ លំបប៊ុះ ថួយ ឡើ ប៉្រៃ កួន ណគ អ៊ីសាគ់ កួយ ណគ់ ដើ ណគ អន់ណាវ ឡើ តៀត អ៊ុញ ដើម ពីត អ៊ែ អំប្រា ដក់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ប៊ឹង អ៊ែ អ៊ីសាគ់ ឡើ កឡូវ បើគ ណគ ឡើ រៀន៖ «អើយ បើគ!»។ អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «ង៉ាយ កួន?»។ អ៊ីសាគ់ ឡើ តង៉ា រៀន៖ «អន់ដ្រិះ អ៊ុញ បប៊ិច ឡើយ ហឹ ង៉ាយ ដឹះ កួន ចៀម បន់បប៊ុះ ថួយ?»។ ");
INSERT INTO brb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «កួន អើយ គ្រែដៃ កឡឹ លំអាំ ចៀម ដើ បា បន់ថួយ»។ ប៊្លី អ៊ែ អំប្រា ដក់ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","តគ់ អំប្រា ប៊ឹះ ឞន ណគ់ គ្រែដៃ ឡើ ហាយ អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ប៊ូក ព្រឌឺន ប្រយ តម៉ បក់ លំប៊ុះ ថនួយ ណគ ពឺង អ៊ែ ឡើ ចក់ អន់ដ្រិះ ឡើ ប៊ូក ពឺង តម៉ ព្រឌឺន។ ប៊្លី អ៊ែ ឡើ ចង ទី ឈឹង កួន ណគ អ៊ីសាគ់ ឡើ ពឝ៉ី ពឺង ប្រនូក អន់ដ្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ប៊្លី អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ហួត ពីត ឡើ តនែង លំអារ់ ដង់ កួន ណគ អ៊ែ លំថួយ។ ");
INSERT INTO brb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ហំប៊្រុះ ដើ អ៊ែ ឞាវ ឡើ បើម ឞយ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កឡូវ តើម ទិ គ្រែ រៀន៖ «អាប្រាហាំ អាប្រាហាំ អើយ!»។ យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «ង៉ាយ យ៉ាគ់ កន់ដ្រាគ់?»។ ");
INSERT INTO brb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","អ៊ែ ឞាវ គ្រែដៃ ឡើ ម៉ាង រៀន៖ «ញ៉ង ហកជែត អ៊ឺម កួន ហៃ ញ៉ង ហបើម អឹ ដើ ណគ ប៉ាគ់ អ៊ែ យ៉ាក់ ណិះៗ នែ អណោះ ឡើយ ហៃ ហអៀល បឹះ គ្រែដៃ ម៉ាត់ ម៉ាត ទុត កួន ហៃ វ៉ិះ ឌិវ មូយ ណាគ់ ហឌី ថួយ អាំ ដើ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ប៊្រឹក ម៉ាត់ ឡើ តៃ ប្រយ ចៀម សារ ឡើ ឡាន់ តកួយ ប៊ឹង ឡង នុំនូម អ៊ែ ឡើ ដក់ ចក់ កជែត ប៊ុះ ថួយ ពតាង កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","យ៉ាគ់ អាប្រាហាំ ឡើ ជុ ឞន ហង់អ៊ែ រៀន៖ «គ្រែដៃ ឡើ ណាគ់ អន់សច លំអាំ »។ ញ៉ន អ៊ែ ឡើយ ត្រំ តង៉ៃ នែ ម៉ើ រៀន៖ «ទឹង ចន់ឌូ គ្រែដៃ ឡើ ណាគ់ អន់សច ណគ លំអន់ណាំ អាំ»។ ");
INSERT INTO brb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ឞាវ ឡើ បើម ឞយ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កឡូវ ឡឹះ យ៉ាគ់ អាប្រាហាំ តើម ទិ គ្រែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង រៀន “ញ៉ន ហបើម ប៉ាគ់ នែ កួន ហៃ វ៉ិះ ឌិវ មូយ អំប៉ម ណាគ់ ហឌី ថួយ ដើ អៃ អៃ អគ្រែដៃ អណាគ់ អន់សច អន់ខណាត តប៉ឹន ចាក់ អកឡឹ រៀន ");
INSERT INTO brb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","អៃ អំប្រាយ កាន ចាគ់ ទុត អើន ដើ ហៃ ដើម អន់អាំ កួន ចូវ ហៃ មន់ស៊ឺក តាក ឞាល់ ពតួរ ទឹង គ្រែ ដើម ឞាល់ ផាច បរ ពឹះ សមុត។ អ៊ែ ណគ់ ដើ កួន ចូវ ហៃ មន់ប្រិញ ថាំង ជឺរ បូវ ដ្រម៉ា មែ។ ");
INSERT INTO brb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","លែក ដើ មែ សុនសាត ទិ ឡាង ប្រិះ មន់ដូវ កាន ចាគ់ យ៉ម កួន ចូវ ហៃ ញ៉ន ដើ ហចាប់ ម៉ាង អៃ”»។ ");
INSERT INTO brb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","អ៊ែ យ៉ាគ់ អាប្រាហាំ អំប្រា កួន ណគ អំប្រា ជឹ វឹញ ទិ ក៝ត ណគ អន់ណាវ ប៊្លី អ៊ែ ម៉ើ ជឹ ហឹ កតូ ណគ ទឺ ដៀក ស៊្រុក ប៊ែរ ស៊ែបា។ យ៉ាក់ យ៉ាគ់ អាប្រាហាំ កនូ ណគ ហឹ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ប៊្លី អ៊ែ ប៊ិច មែ ម៉ើ ដក់ ប៉ច ដើ យ៉ាគ់ អាប្រាហាំ រៀន៖ «អោះ ហៃ យ៉ាគ់ ណាខូរ អំប្រា ទ្រី ណគ មីលកា អំប្រា ប៊ិច កួន កឡ ទុត អើន ឡើយ ហណោះ»។ ");
INSERT INTO brb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ម៉ាត់ កួន ឡង់ អំប្រា ជុ អ៊ូះ អោះ ណគ ប៊ិច ប៉ាគ់ ឡើ បូះ គែមូអ៊ែល (គែមូអ៊ែល នែ កួន ណគ អារ៉ាម) ");
INSERT INTO brb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","គែស៊ែត ហាសូ ពីលដះ យិតឡាប ដើម ប៊ែធូអ៊ែល។ ");
INSERT INTO brb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","យ៉ាគ់ ប៊ែធូអ៊ែល ឡើ ត្រ បើគ ណាង រែប៊ែកា។ មែ លែក ថាម រ៉ា នែ កួន ណាង មីលកា អំប្រា ក្ល ណគ យ៉ាគ់ ណាខូរ។ យ៉ាគ់ ណាខូរ នែ អោះ យ៉ាគ់ អាប្រាហាំ។ ");
INSERT INTO brb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ណគ់ ដើ ទ្រី ដូច យ៉ាគ់ ណាខូរ ម៉ាត់ ណគ ណាង រែអ៊ូម៉ា ឡើ ប៊ិច ប៉ាគ់ទឺ កួន កឡ ម៉ាត់ កួន ណគ ធែបះ ឝ៉ាហាំ តាហះ ដើម ម៉ាកះ។ ");
INSERT INTO brb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","យ៉ាគ់ សារ៉ា កំប្រាគ់ ណគ មូយ ក្លាំ បារ ជិត ប៉ឹះ កម៉ ឡើយ ");
INSERT INTO brb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","អ៊ែ ឡើ គែត ហឹ មួង កៀរយ៉ាត់-អារបា ម៉ើ ជុ ហ៊ែប្រុន ដិ ហឹ ស្រុក កាណាន។ យ៉ាគ់ អាប្រាហាំ ឡើ ឝ្រង៉ឹត ស្រូក ដើម ឡើ ញឺម ទ្រី ណគ យ៉ាគ់ សារ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ប៊្លី អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ វីះ តើម ប៊ឹង កយ៉ក់ ទ្រី ណគ ឡើ ដក់ ហឹ ឝឡោះ មួង ឡើ ចជែ ហឹ មែ សុនសាត ហ៊ែត រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«អៃ អសុនសាត គែង អដក់ គូ អរែង ប៊ឹង វែ។ អឡា រួត ប្រិះ ចះ កយ៉ក់ មូយ អំប៊ុ ប៊ឹង វែ អំចះ កយ៉ក់ ទ្រី អៃ ណាគ់ ដូវ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","មែ សុនសាត ហ៊ែត ម៉ើ ត្រណើវ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«ហន់ចង់ហៀង ញ៉ា អន់ដៃ យ៉ាគ់ អ ហៃ ឡើយ ហបនឹះ ទិះ ក្រាគ់ ប៊ិច មុះ ម៉ាត ទឹង ញ៉ា ហន់ចះ កយ៉ក់ ទ្រី ហៃ ហឹ ឞន ចនុ កយ៉ក់ ញ៉ា ណគ់ ចាគ់ៗ ប៊ឹង ង៉ាយ កតាម តាម ឌី ហកឡឹ។ លែក ដើ បូវ ញ៉ា តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់រៀន តៃ មន់អាំ ប្រិះ ហន់ចះ កយ៉ក់ ទ្រី ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","យ៉ាគ់ អាប្រាហាំ ឡើ ឌឹក ឆុង អ៊ែ ឡើ កដាប ហំបះ ប៊ឹង ងឺរ មែ សុនសាត ហ៊ែត ម៉ើ គូ ទឹង ស្រុក ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ឡើ ចជែ ហឹ មែ រៀន៖ «ប៉ាគ់ វែ វ៉ើ ផម អន់ចះ ទ្រី អៃ ប៊ឹង នែ ម៉ាត អឡា ហឹ វែ វន់ចជែ ប៉ូរ អៃ ហឹ យ៉ាគ់ អ៊ែប្រូន កួន យ៉ាគ់ សូហារ ដើ អៃ អុះ។ ");
INSERT INTO brb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","អឡា ហឹ ណគ លំអាំ អន់រួត ត្រម តម៉ ម៉ើ ជុ ម៉ាគ់ពែឡា តៃ ទូះ មឺរ ណគ។ អឡា លំហំពួត ត្រម តម៉ ណគ អ៊ែ ដើ អៃ អាំ លំត្រ តាម ច្រណាប់ ពដិះ មឺរ ណគ អ៊ែ វែ លែក រ៉ា វន់តៃ ហឡាក់ ប៉ាគ់ ទឺ។ អ៊ែ អៃ អំប៊ិច ឞន ចនុ កយ៉ក់ ទឹង វែ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","យ៉ាគ់ អ៊ែប្រូន ឡើ ដ្រូម អរែង ប៊ឹង មែ សុនសាត ហ៊ែត ឡើ កឡឹ ទឺ។ អ៊ែ ឡើ ត្រណើវ ប្រម៉ាង យ៉ាគ់ អាប្រាហាំ ប៊ឹង ងឺរ លែក ដើ មែ សុនសាត ណគ កឡឹ ម៉ើ តមួត ប៊ឹង ឝឡោះ ដ្រក មួង ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«អើយ យ៉ាគ់ អ ហន់ចង់ហៀង អៃ អន់ដៃ ប្រិះ មឺរ អៃ ដើម ត្រម តម៉ ទឹង មឺរ អ៊ិន អង់អាំ ដើ ហៃ មែ សុនសាត អកឡឹ ប៊ឹង នែ មន់ដុង ហឡាក់ ប៉ាគ់ទឺ ហន់ចះ កយ៉ក់ ទ្រី ហៃ ហឹ អិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","យ៉ាគ់ អាប្រាហាំ ឡើ កដាប ហំបះ ឡឹះ ប៊ឹង ងឺរ មែ ម៉ើ គូ ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","អ៊ែ ឡើ ចជែ ហឹ យ៉ាគ់ អ៊ែប្រូន ប៊ឹង ងឺរ មែ ក្លាង ស៊្រុក ឡើ រៀន៖ «ឡា ហន់ចង់ហៀង អៃ អន់ណាវ អន់អាំ លៀន ប៉្រាក់ ដើ ហៃ តាម ច្រណាប់ ប្រិះ មឺរ ហៃ អឡា ហន់ចក់ ណិះៗ តើម ប៊ឹង ទី អៃ អ៊ែ អន់ណោះ ចះ កយ៉ក់ ទ្រី អៃ ទឹង អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","អ៊ែ យ៉ាគ់ អ៊ែប្រូន ឡើ ត្រណើវ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«ឡា យ៉ាគ់ អ ហន់ចង់ហៀង អៃ អន់ដៃ។ ប្រិះ នែ ឡើ ប៊ិច ច្រណាប់ វ៉ិះ ឌិវ ពួន ក្លាំ កាក់ ប៉្រាក់ បើម ង៉ាយ អ៊ឺម ប្លះ បា កឡឹ ហន់ចះ ទ្រី ហៃ ហឹ អិះ ឡើយ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","យ៉ាគ់ អាប្រាហាំ ឡើ ផម អរែង ប៊ឹង យ៉ាគ់ អ៊ែប្រូន អ៊ែ ឡើ ទិត ប៉្រាក់ ឡើ អាំ ដើ យ៉ាគ់ អ៊ែប្រូន តាម អំម៉ើន ច្រណាប់ ប៊ឹង ងឺរ មែ សុនសាត ហ៊ែត ឡើ អាំ លៀន ពួន ក្លាំ កាក់ ប៉្រាក់ ឡើ ត្រ តាម កយឹក កាក់ ប៉្រាក់ ម៉ើ ខើយ ររួត ទឹង ប៉ាង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","តើម ប៊ឹង អ៊ែ ប្រិះ មឺរ ត្រម តម៉ ដើម លែក ដើ ឡង ទឹង មឺរ យ៉ាគ់ អ៊ែប្រូន ហឹ ម៉ាគ់ពែឡា តៃ ម៉ាត់ តង៉ៃ ឌឹក ម៉ាមរែ ");
INSERT INTO brb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ឡើ ត្រ ប្រិះ យ៉ាគ់ អាប្រាហាំ ឡើយ។ លែក ដើ មែ សុនសាត ហ៊ែត ម៉ើ តមួត ប៊ឹង ឝឡោះ ដ្រក មួង ម៉ើ តៃ ហឡាក់ៗ លែក ដើ បូវ។ ");
INSERT INTO brb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ប៊្លី អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ជុ កយ៉ក់ ទ្រី ណគ យ៉ាគ់ សារ៉ា ទឹង ត្រម តម៉ ហឹ មឺរ ម៉ាគ់ពែឡា តៃ ម៉ាត់ តង៉ៃ ឌឹក មួង ម៉ាមរែ (ម៉ើ ជុ មួង ហ៊ែប្រុន ដិ) ទឹង ស្រុក កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ប៉ាគ់ អ៊ែ ឡើយ យ៉ាគ់ អាប្រាហាំ ឡើ រួត ប្រិះ មឺរ ដើម ត្រម តម៉ ទឹង អ៊ែ តើម ប៊ឹង សុនសាត ហ៊ែត អ៊ែ ឡើ ត្រ ប្រិះ ណគ ឡើយ ឡើ ជុ ឞន ចនុ កយ៉ក់ ទឹង ក្រាន ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ទឹង អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ ក្រាគ់ៗ ម៉ៃ ឡើយ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ កាន ចាគ់ ដើ ណគ ត្រំ កាន។ ");
INSERT INTO brb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","យ៉ាគ់ អាប្រាហាំ ឡើ ប៉្រៃ ក៝ត ណគ ណគ់ ឡើ ទិះ ក្រាគ់ ជឺរ មែ ឡើ រន់ឋាប់ ឝ្លាំង លែក ដើ ប្រនិច ណគ ឡើ រៀន៖ «មិញ ហន់ជុ ទី ហៃ ក្រូម ប៊្លូ អៃ ");
INSERT INTO brb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","អ៊ែ ហន់តប៉ឹន ចាក់ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច ណគ ឡើ កន់ដ្រាគ់ ពឝ៉ើត ឡាង គ្រែ ដើម ឡាង ប្រិះ ហៃ តៃ ហន់យ៉ាគ់វឺ អ៊ឺម កួន កទ្រី ស្រុក មែ កាណាន ណគ់ អៃ អគូ នែ ដើ កួន អៃ លំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ហន់ដក់ ហឹ ស្រុក អំប៊ី អៃ កឡឹ តគ់ ហឹ ព្រឝ៉ើត យូ អៃ អ៊ែ ហន់យ៉ាគ់វឺ កួន កទ្រី មែ ប៊ឹង កួន អៃ អ៊ីសាគ់ លំបើម ទ្រី»។ ");
INSERT INTO brb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ក៝ត ណគ ឡើ ត្រណើវ រៀន៖ «អាត ណាង ហង់អ៊ិន លំឌី អ៊ឺម ជឹ តូយ អៃ ហឹ ស្រុក អន់នែ ប៉ាគ់ ពអ៊ែ ហន់អាំ កួន កឡ ហៃ លំដក់ តូយ អៃ ហឹ ស្រុក ហៃ អ៊ិន ណាគ់ ហអាំ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន៖ «ញ៉ង ហច្រា អ៊ឺម កួន អៃ លំតូយ ហៃ ដក់ ហឹ អ៊ិន! ");
INSERT INTO brb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កន់ដ្រាគ់ ពឝ៉ើត ឡាង គ្រែ ឡើ ប៉្រៃ អៃ អវីះ តើម ប៊ឹង ហន់ណាម ក្រាន បើគ អៃ ដើម ប្រិះ ប៊្រី ព្រឝ៉ើត យូ អៃ។ ណគ ឡើ ចជែ ប៊ឹង អៃ ដើម ឡើ ខណាត តប៉ឹន ចាក់ ដើ អៃ រៀន លំអាំ ស្រុក អន់នែ ដើ កួន ចូវ អៃ ។ ប៉ាគ់ ពអ៊ែ ណគ លំប៉្រៃ ឞាវ ណគ លំដក់ អន់នួរ ហៃ អ៊ែ លំប៉ូរ ហៃ យ៉ាគ់វឺ កួន កទ្រី មូយ រ៉ា តើម ប៊ឹង ស្រុក ហង់អ៊ិន ប្រយ៉ង់ ប៊ឹង កួន អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ប៉ាគ់ ណាង ហង់អ៊ិន តៃ លំឌី ជឹ តូយ ហៃ អ៊ែ ហន់ក្លើច តើម ប៊ឹង កាន តប៉ឹន ចាក់ ដើ អៃ ហាក់ ញ៉ង ហច្រា អ៊ឺម ឋាយ កួន កឡ អៃ លំដក់ តូយ ហៃ ហឹ ស្រុក ហង់អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","បឹ ក៝ត ណគ ឡើ ជុ ទី ក្រូម ប៊្លូ យ៉ាគ់ អាប្រាហាំ កន់ដ្រាគ់ ណគ ដើម ឡើ តប៉ឹន ចាក់ កាន ណគ់ អន់នែ។ ");
INSERT INTO brb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ក៝ត ណគ អ៊ែ ឡើ រន់ឋាប់ រ៉ាះ ម៉ាត់តូវ ច្រណាប់ៗ តើម ប៊ឹង យ៉ាគ់ អាប្រាហាំ អ៊ែ ឡើ ដក់ ចក់ អូត ជិត អំប៉ម តើម ប៊ឹង បូវ អូត កន់ដ្រាគ់ ណគ អ៊ែ ឡើ ព្រឌុក រ៉ាះ ទឹង អូត  ឡើ វីះ ដក់ ហឹ មួង ណាខូរ ស្រុក មែសូប៉ូតាមី។ ");
INSERT INTO brb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ឡើ ដក់ ទុត ឌុញ តង៉ៃ ឡើយ អ៊ែ ឡើ ប៊ឹះ តគ់ ដាក រន់ឋូវ ដៀក មួង ឡើ ប៉្រៃ លែក ដើ អូត មន់ប៊ូគ។ ប៊ឹង អ៊ែ ឡើ អំប៊ឹ ឡើយ ឡើ ប៊ឹះ ម៉ូង មែ កទ្រី ម៉ើ ទឺះ ឈិត ដាក។ ");
INSERT INTO brb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","អ៊ែ ឡើ អ៊ឺរ ដាំង គ្រែដៃ រៀន៖ «ឡា គ្រែដៃ ហណាគ់ អន់សច ហគ្រែដៃ យ៉ាគ់ អាប្រាហាំ ឡើ កន់ដ្រាគ់ អៃ ឡា ហង់អាំ ដណក់ អៃ លំដាវ ប៉ាគ់ កន់ដ្រាគ់ អៃ ឡើ ងុញ។ អឡា ហំពដៃ ប្រម៉ើត អន់ញ៉ុ ហៃ ដើ យ៉ាគ់ អាប្រាហាំ ឡើ កន់ដ្រាគ់ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","អៃ អឆុង ដៀក ដាក រន់ឋូវ នែ ឡើយ ដើម ឡើ ប៊ិច មែ ប្រោះ មួង អន់នែ ម៉ើ ញឺះ ឈិត ដាក។ ");
INSERT INTO brb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ប៉ាគ់ អៃ អន់ចជែ ហឹ ណាង ប្រោះ អង់ង៉ាយ មូយ អន់ឡា ហឹ ណគ “ណាង ហំពជែង ដាក វ៉ាន់ ហៃ ដើ អៃ អន់ញែត អុះ”។ ប៉ាគ់ ណាង លំត្រណើវ ប្រម៉ាង អៃ រៀន “ញែត ដឹះ យ៉ាគ់ អ អៃ អំឈិត ដាក អាំ ដើ អូត ហៃ មន់ញែត ដិ”។ ឡា អាំ លំត្រ ប៉ុះ ណាង កទ្រី ណគ់ ហៃ ហរ៉ើះ ដើ អ៊ីសាគ់ កន់ដ្រាគ់ អៃ លំបើម ទ្រី។ អ៊ែ អន់ណោះ ហឡាក់ រៀន គ្រែដៃ ហពដៃ កាន ប្រម៉ើត អន់ញ៉ុ ដើ កន់ដ្រាគ់ អៃ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ណាគ់ ទឹង ប៉ះ ឡើ អ៊ឺរ ដាំង គ្រែដៃ តៃ ដាន់ ឡូច អំម៉ឹះ ហំប៊្រុះ ដើ អ៊ែ ឡើ តៃ ប្រោះ មូយ រ៉ា ឡើ ដូល វ៉ាន់ ទិ ប៉ាវ ឡើ ញឺះ តើម ប៊ឹង មួង។ ណាង នែ ម៉ាត់ ណគ រែប៊ែកា ឡើ ត្រ កួន យ៉ាគ់ ប៊ែធូអ៊ែល ចូវ យ៉ាគ់ មីលកា អំប្រា យ៉ាគ់ ណាខូរ ។ យ៉ាគ់ ណាខូរ នែ អោះ យ៉ាគ់ អាប្រាហាំ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ណាង នែ ឡើ ចាគ់ តៃ ឋាំ ញឹះ តៃ ឡើ ណោះ កី ដើ មែ កឡ ចណាយ អំម៉ឹះ។ ឡើ ទឺះ ឈិត ដាក ទិ រន់ឋូវ តគ់ ឡើ ឈិត ដាក ប៊ិង វ៉ាន់ លែវ ឡើយ អ៊ែ ឡើ ឌឹក ឡើ ងុញ លន់ជឹ។ ");
INSERT INTO brb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","អ៊ែ ក៝ត យ៉ាគ់ អាប្រាហាំ ឡើ ដក់ យ៉ាវ ដ្រិះៗ ប្រយ ណាង ឡើ ឡា ដាក ឡើ ម៉ាង រៀន៖ «អើយ ណាង អឡា ដាក វ៉ាន់ ហៃ អន់ញែត កិៗ អន់ដៃ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ណាង ឡើ ត្រណើវ រៀន៖ «ញែត ដឹះ យ៉ាគ់ អ!»។ ណាង ឡើ ប៊្រឺះ ដាក វ៉ាន់ ណគ ដ្រិះៗ ប្រយ ឡើ ពជែង អាំ ដើ ប្រណគ ញែត។ ");
INSERT INTO brb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ប៊ឹង ណាង ឡើ អាំ ណគ ឡើ ញែត ដាក លែវ ឡើយ ឡើ ម៉ាង រៀន៖ «អៃ អន់ដក់ ឈិត ឡឹះ ដាក អន់អាំ ដើ អូត ហៃ មន់ញែត អាំ មន់ផិ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ណាង ឡើ ហ៊ែង ដាក ដ្រិះៗ ប្រយ ទិ ក្រឡោះ ពត្រូវ ប៊្លី អ៊ែ ឡើ ដក់ ឈិត ឡឹះ ដាក ហឹ រន់ឋូវ ឆា ដើ ត្រំ អូត ម៉ើ ញែត។ ");
INSERT INTO brb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ក៝ត នែ ឡើ គូ ឝ្លាំង ហឹ ណាង ញឹះ តៃ ឡើ ចជែ ឡើ ឃឹត ទឹង ចនិះ ណគ រៀន៖ «អន់នែ ឡើយ ឋូវ គ្រែដៃ ឡើ ពដៃ ដណក់ អៃ លំដាវ ប៉ាគ់ ប្រម៉ើត កន់ដ្រាគ់ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","តគ់ អូត ម៉ើ ញែត ដាក ត្រំ ឡើយ បឹ ក៝ត អ៊ែ ឡើ ចក់ ប្រយ កចន ឆៀង ពស៊ិប ប៊ឹង មុះ កយឹក មូយ ជី ហម ដើម ឡើ ចក់ កង់ ឆៀង ទ្រូប ប៊ឹង ទី មូយ ហំប៊្រុក កយឹក ពែ តឡឹង ឡើ អាំ ដើ ណាង។ ");
INSERT INTO brb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ឡើ តង៉ា ណាង រៀន៖ «ណាង កួន ចូវ មែ ង៉ាយ ហៃ នែ? ហង់ហាយ ដើ អៃ ឡាំង។ ហន់ណាម បើគ ហៃ ណាគ់ ឆិ ឡះ ដើ ញ៉ា ញន់ហង់ង៉ាន់ អំប៊ឹ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ណាង ឡើ ត្រណើវ រៀន៖ «អៃ នែ កួន យ៉ាគ់ ប៊ែធូអ៊ែល ចូវ យ៉ាគ់ មីលកា អំប្រា យ៉ាគ់ ណាខូរ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ណាង ឡើ ត្រណើវ ឡឹះ រៀន៖ «ណាគ់ ប៊ិច អន់ណាវ កនី កនូ ដើ វែ អំប៊ឹ នែ ដើម ញ៉ើ ប៊ិច ហ្រលែង ចិះ ដើ អូត មន់កី ដឹប បាត់ ច្រាំ ចណា មែ ទុត អើន ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ហំប៊្រុះ ដអ៊ែ បឹ ក៝ត ឡើ ជឹះ ត្រកូវ ឡើ កដាប ហំបះ ព្រតឹះ ព្រនែ គ្រែដៃ ឡើ ណាគ់ អន់សច ");
INSERT INTO brb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ឡើ រៀន៖ «ព្រតឹះ ព្រនែ គ្រែដៃ ហណាគ់ អន់សច ហគ្រែដៃ យ៉ាគ់ អាប្រាហាំ ឡើ កន់ដ្រាគ់ អៃ ហពដៃ អន់សច កាន ប្រម៉ើត អន់ញ៉ុ ដើម កាន ដាវ ដើ កន់ដ្រាគ់ អៃ! អ៊ែ ណគ់ ដើ អៃ អន់ណាវ ហតៀត ទ្រូង ឆា ដើ ប៊ឹះ ហន់ណាម អំម៉ោះ អោះ កន់ដ្រាគ់ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ណាង នែ ឡើ ជឹ អ្រយ៉ាវ ពហាយ កាន លែក អ៊ែ ទឹង ហន់ណាម ក្រាន មែគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ណាង រែប៊ែកា ឡើ ប៊ិច អ៊ូគ មូយ ម៉ាត់ ណគ ឡាបាន់។ ឡាបាន់ ឡើ ញឺះ ដក់ យ៉ាវ បឹ ក៝ត អ៊ែ ហឹ ដៀក មួង តគ់ ដាក រន់ឋូវ។ ");
INSERT INTO brb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ហំប៊្រុះ ឡើ តៃ កចន ប៊ឹង មុះ ដើម កង់ ប៊ឹង ទី អោះ ណគ ណាង រែប៊ែកា ដើម ឡើ ដុង ឡើ ពប៉ច កាន បឹ ក៝ត អ៊ែ ឡើ ចជែ ប៊ឹង ណគ អ៊ែ អ៊ូគ ណគ ឡើ ទឺះ យ៉ាវ តង៉ា ឡា បឹ ក៝ត ហង់អ៊ែ ឡើ តៃ ណគ ណាគ់ ឡើ ឆុង ដៀក អូត ប៊ឹង រន់ឋូវ។ ");
INSERT INTO brb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","អ៊ែ ឡើ ម៉ាង រៀន៖ «បនឹះ ណគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ កាន ចាគ់ អើយ បះ ជឹ តូយ អៃ ទឹង ហន់ណាម ទិ ហគូ បើម ង៉ាយ ហឹ ដៀក ប៉ាគ់ នែ? អរន់ឋាប់ កនី កនូ លែវ ឡើយ ដើ ហៃ ដើម កនូ ដើ អូត ហៃ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ក៝ត អ៊ែ ឡើ មឹត ប្រយ ហឹ ហន់ណាម អ៊ែ បូវ ក៝ត យ៉ាគ់ ឡាបាន់ ម៉ើ ប៊្រឺះ រ៉ាះ អំបាះ តើម ទិ កណង អូត ប៊្លី អ៊ែ ម៉ើ សើវ ហ្រលែង ចិះ ដើ អូត មន់កី ដើម ម៉ើ អាំ បាត់ ចណា អូត ដិ។ អ៊ែ ម៉ើ អាំ ដាក ដើ ណគ លំឆះ ឈឹង ដើម ដើ មែ ម៉ើ ដក់ អរែង ប៊ឹង ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ប៊្លី អ៊ែ ម៉ើ វ៉ក់ ចណង់ ចណា ម៉ើ ច្រា ណគ លន់ចង់។ ហាក់ ណគ ឡើ ម៉ាង រៀន៖ «ចាំ អំពប៉ច កាន អៃ ដើ វែ អន់ដៃ អ៊ែ អន់ចង់»។ ឡាបាន់ ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ ពអ៊ិន ហំពប៉ច អន់ដៃ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","អ៊ែ បឹ អន់នែ ឡើ ពប៉ច រៀន៖ «អៃ នែ អក៝ត យ៉ាគ់ អាប្រាហាំ។ ");
INSERT INTO brb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ អាំ ដើ កន់ដ្រាគ់ អៃ ត្រំ ហំឞ្លិច អ៊ែ ឡើ ប្រនិច ទុត អើន។ គ្រែដៃ ឡើ អាំ ដើ ណគ ប៊ិច ចៀម ប៊ិច ឝ៉ូ ប៉ិន ខក លៀន ឆៀង ប៉្រាក់ ឡើ ប៊ិច ក៝ត កទ្រី ដឹប កឡ អូត ដើម សិះ លៀ ទុត អើន ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ទ្រី កន់ដ្រាគ់ អៃ យ៉ាគ់ សារ៉ា តគ់ ឡើ ក្រាគ់ៗ ឡើយ ឡើ ពឝ៉ើត កួន កឡ មូយ ប៊ឹង ណគ។ អ៊ែ ប្រនិច ណគ លែក ដើ អ៊ែ ឡើ បយុ ដើ កួន អំប្រា អ៊ិន ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","កន់ដ្រាគ់ អៃ ឡើ ប៉្រៃ អតប៉ឹន ចាក់ ឡើ រៀន “ហៃ តៃ ហន់យ៉ាគ់វឺ អ៊ឺម កទ្រី សុនសាត កាណាន ទឹង ស្រុក អៃ អគូ នែ ដើ កួន អៃ លំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ហន់ដក់ ដាំង ហឹ ហន់ណាម ក្រាន បើគ អៃ ដើម ព្រឝ៉ើត យូ អៃ អ៊ែ ហន់យ៉ាគ់វឺ កទ្រី ទឹង ក្រាន ឆ្រាំង អៃ កឡឹ ដើ កួន អៃ លំបើម ទ្រី”។ ");
INSERT INTO brb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","អត្រណើវ កន់ដ្រាគ់ អៃ រៀន “អាត ណាង ហង់អ៊ិន លំឌី អ៊ឺម តៃ ណោះ លន់ជឹ តូយ អៃ ហឹ ស្រុក អន់នែ”។ ");
INSERT INTO brb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ណគ ឡើ ត្រណើវ ម៉ាង អៃ រៀន “គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ គ្រែដៃ ណគ់ អៃ អបើម ត្រួយ លំប៉្រៃ ឞាវ ណគ ដក់ អរែង អាំ ដណក់ ហៃ លំដាវ អ៊ែ ហន់ដូវ យ៉ាគ់វឺ កទ្រី មូយ រ៉ា ទឹង ព្រឝ៉ើត យូ ដើម ហន់ណាម ក្រាន បើគ អៃ ដើ កួន អៃ លំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ប៊ឹង ហៃ ហន់ដក់ តង៉ា ឡា ព្រឝ៉ើត យូ អៃ ប៉ាគ់ តៃ មន់ឌី អាំ កួន មែ អ៊ែ ហន់ក្លើច តើម ប៊ឹង កាន តប៉ឹន ចាក់ នែ”។ ");
INSERT INTO brb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","អន់ឌូ អប៊ឹះ តគ់ ដាក រន់ឋូវ អ៊ែ អឡា ទឹង គ្រែដៃ រៀន “ឡា គ្រែដៃ ហណាគ់ អន់សច ហគ្រែដៃ យ៉ាគ់ អាប្រាហាំ ឡើ កន់ដ្រាគ់ អៃ ឡា ហន់អាំ ដើ ដណក់ អៃ នែ លំដាវ ប៉ាគ់ ឝ្រងុញ កន់ដ្រាគ់ អៃ ណិះៗ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","អៃ អឆុង ដៀក ដាក រន់ឋូវ នែ ឡើយ ប៉ាគ់ លំប៊ិច មែ ប្រោះ អង់ង៉ាយ មូយ លំទឺះ ឈិត ដាក អ៊ែ អន់ឡា ដាក ហឹ ណគ រៀន “ឡា ណាង អឡា ញែត ដាក វ៉ាន់ ហៃ កិៗ អុះ”។ ");
INSERT INTO brb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","អ៊ែ ប៉ាគ់ ណាង លំត្រណើវ អៃ រៀន “ហន់ញែត ដឹះ យ៉ាគ់ អ អៃ អន់ដក់ ឈិត ដាក អន់អាំ ដើ អូត ហៃ មន់ញែត ប៉ាគ់ទឺ”។ ឡា លំត្រ ប៉ុះ កទ្រី ណគ់ ហៃ ហរ៉ើះ ដើ កួន កន់ដ្រាគ់ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ណាគ់ ទឹង ប៉ះ អអ៊ឺរ ដាំង គ្រែដៃ ទឹង ចនិះ តៃ ដាន់ ឡូច កអវ អតៃ ណាង រែប៊ែកា ឡើ ដូល វ៉ាន់ ទិ ប៉ាវ ឡើ ទឺះ ទិ រន់ឋូវ ឡើ ឈិត ដាក។ អ៊ែ អឡា ដាក ហឹ ណគ រៀន “អើយ ណាង អឡា ដាក ហៃ អន់ញែត ដិ អុះ”។ ");
INSERT INTO brb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ណាង ឡើ ប៊្រឺះ ដ្រិះៗ ប្រយ វ៉ាន់ តើម ទិ ប៉ាវ ឡើ ពជែង ដើម ឡើ ម៉ាង រៀន “ញែត ដឹះ យ៉ាគ់ អ អៃ អន់ឈិត ដាក ដើ អូត ហៃ មន់ញែត ដិ”។ អ៊ែ អញែត ប្រយ ដើម ឡើ អាំ ដើ អូត អៃ ម៉ើ ញែត ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","អៃ អតង៉ា ណាង រៀន “ណាង ហកួន ចូវ មែ ង៉ាយ ហៃ នែ?”។ ណាង ឡើ ត្រណើវ រៀន “អៃ នែ កួន យ៉ាគ់ ប៊ែធូអ៊ែល ចូវ យ៉ាគ់ ណាខូរ អំប្រា យ៉ាគ់ មីលកា”។ យ៉ាក់ អដុង ពអ៊ិន អ៊ែ អពស៊ិប ប្រយ កចន ប៊ឹង មុះ ណគ ដើម អពទ្រូប កង់ ប៊ឹង ទី ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ប៊្លី អ៊ែ អជឹះ ត្រកូវ អកដាប ហំបះ គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ អព្រតឹះ ព្រនែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ គ្រែដៃ យ៉ាគ់ អាប្រាហាំ កន់ដ្រាគ់ អៃ ឡើ ឈូន ពដៃ ទ្រូង ត្រ ម៉ាត ប៊ឹះ ហឹ ហន់ណាម ម៉ន កន់ដ្រាគ់ អៃ បក់ អន់ដូវ យ៉ាគ់វឺ កួន ម៉ន ណគ ដើ កួន ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ណិះៗ នែ ប៉ាគ់ វន់ឌី បើម ចាគ់ៗ ត្រៗ ដើ កន់ដ្រាគ់ អៃ អឡា វន់ហាយ ដើ អៃ អាំ អន់ណោះ ប៉ាគ់ តៃ វន់ឌី បក់ អន់ណោះ ដក់ ហឹ គែង អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","យ៉ាគ់ ឡាបាន់ អំប្រា យ៉ាគ់ ប៊ែធូអ៊ែល អំប្រា តើវ រៀន៖ «កាន នែ ឡើ ញឺះ តើម ប៊ឹង គ្រែដៃ ឡើ ណាគ់ អន់សច យ៉ះ ញន់រៀន ចាគ់ តៃ លន់ចាគ់ ញ៉ើ ណោះ អ៊ឺម ប៉ាគ់ទឺ ");
INSERT INTO brb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","នែ ដឹះ ណាង រែប៊ែកា ប៊ឹង ងឺរ ហៃ ឡើយ ហន់ជឹ តៀត ហឹ អិះ ឡើយ ឆិ វន់ប្រយ៉ង់ ប៊ឹង កួន កឡ កន់ដ្រាគ់ ហៃ ប៉ាគ់ គ្រែដៃ ឡើ ប៉្រៃ អិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ប៊ឹង ក៝ត យ៉ាគ់ អាប្រាហាំ ឡើ ដុង ម៉ើ ម៉ាង ប៉ាគ់ អ៊ែ ឡើ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ ឡើ ព្រតឹះ ព្រនែ ប្រយ គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","អ៊ែ ឡើ ញ៉ាក់ រ៉ាះ បណើម ចាក់ ប្រណាក់ ឈុក ម៉ាត់តូវ ឆៀង ប៉្រាក់ ដើម កដាង អាវ ឡើ អាំ ដើ ណាង រែប៊ែកា ដើម ឡើ អាំ រ៉ាះ ច្រណាប់ៗ ដើ អ៊ូគ ណគ ដឹប ដើ មែគ ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ប៊្លី អ៊ែ ដឹប មែ ម៉ើ តូយ ណគ ម៉ើ ញែត ចង់ ប្រយ។ អំប៊ឹ អ៊ែ ម៉ើ កី ប៊ឹង អិះ ឡើយ។ តគ់ ម៉ើ រ៉ៃ ងឹប ប្រណូវ អ៊ែ ក៝ត យ៉ាគ់ អាប្រាហាំ ឡើ ម៉ាង រៀន៖ «អឡា តាក់ ម៉ាង វែ យ៉ឹ អន់ជឹ វឹញ ហឹ កន់ដ្រាគ់ អៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","អ៊ូគ ណគ អំប្រា មែគ ណគ អំប្រា រ៉ុង រៀន៖ «ញ៉ើ ឡា ណាង រែប៊ែកា លន់គូ លែង ណាគ់ ឞិត ឞ៊ែត អន់ដៃ ប៊ឹង ញ៉ា ទុត លំឌុញ ជិត តង៉ៃ អ៊ែ លន់ជឹ តូយ វែ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ណគ ឡើ តើវ រៀន៖ «គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តៀត ទ្រូង អៃ ដាវ ឡើយ ញ៉ង វ៉ើ រ៉ុង អ៊ឺម អៃ អឡា អន់ជឹ វឹញ ដាំង កន់ដ្រាគ់ អៃ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","អំប្រា ត្រណើវ រៀន៖ «ប៉ាគ់ ពអ៊ិន ញន់កឡូវ តង៉ា ណគ កឡឹ អន់ដៃ ឡាំង»។ ");
INSERT INTO brb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","អ៊ែ អំប្រា កឡូវ ប្រយ ណាង រែប៊ែកា អំប្រា តង៉ា រៀន៖ «អើយ កួន ណាគ់ ហឌី ឡះ ហន់ជឹ តូយ យ៉ាគ់ អន់នែ ណិះៗ ឡើយ?»។ ណាង ឡើ ត្រណើវ រៀន៖ «ឌី អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","អ៊ែ ម៉ើ អាំ អោះ មែ ណាង រែប៊ែកា ដើម ក៝ត កទ្រី មែគ ចនៀម ណគ ជឹ តូយ ក៝ត យ៉ាគ់ អាប្រាហាំ ដើម បូវ ណគ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","មែ ទឹង ក្រាន ណាង រែប៊ែកា ម៉ើ ប្រាយ ណគ រៀន៖ «ឡា គ្រែដៃ អើយ ហំប្រាយ ដើ អោះ ញ៉ា ណាង រែប៊ែកា លំប៊ិច កួន ចូវ ទុត អើន តៃ ណោះ ស៊ិ ហលិក ស៊ិ មឺន ដើម ហង់អាំ កួន ចូវ ណគ មន់ពែក ប៉ាក់ ពឺង បូវ ដ្រម៉ា មែ»។ ");
INSERT INTO brb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ណាង រែប៊ែកា ដើម មែ ក៝ត កទ្រី ណគ ម៉ើ ឌឹក ឈិះ ប្រយ អូត ម៉ើ ជឹ តូយ យ៉ាគ់ ហង់អ៊ែ។ ប៉ាគ់ ពអ៊ែ បឹ ក៝ត ឡើ ជឹ តៀត ប្រយ ណាង រែប៊ែកា។ ");
INSERT INTO brb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","តៃ នែ អ៊ីសាគ់ ឡើ វីះ តើម ប៊ឹង ប៊ែរ ឡាហាយ រ៉យ  ឡើ ដក់ គូ បើម កតូ ហឹ ឞន នែឝ៉ិប។ ");
INSERT INTO brb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","អំប៊ឹ ហង់អ៊ិន ឡើ ចវីះ ដក់ ឃឹត ហឹ ត្រិញ អ៊ែ ឡើ បយ៉ើល ឝ្លាំង ឡើ តៃ ប្រយ បូវ មែ ម៉ើ ឈិះ អូត ម៉ើ ប៊ឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","អ៊ែ ដើ ណាង រែប៊ែកា អន់ណាវ ឡើ ប៊្រឹក ម៉ាត់ ឡើ តៃ អ៊ីសាគ់ អ៊ែ ឡើ ជ្រុះ ប្រយ តើម ប៊ឹង កណង អូត ");
INSERT INTO brb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ឡើ តង៉ា បឹ ក៝ត រៀន៖ «បឹ អង់ង៉ាយ អិះ អន់តគ់ ឡើ ដក់ ទឹង ត្រិញ ពងឺរ ហឹ ង៉ាយ?»។ បឹ ក៝ត ឡើ ត្រណើវ រៀន៖ «អន់តគ់ ឡើយ កន់ដ្រាគ់ អៃ»។ ហំប៊្រុះ ដអ៊ែ ណាង ឡើ ចក់ ហំបាន ឡើ ច្រលូម ប្រយ មុះ ម៉ាត់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","បឹ ក៝ត ឡើ ប៉ច ពហាយ ដើ អ៊ីសាគ់ លែក ដើ កាន ណគ ឡើ បើម អន់ដូវ។ ");
INSERT INTO brb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","អ៊ែ អ៊ីសាគ់ ឡើ ច្រា ប្រយ ណាង រែប៊ែកា ដក់ មឹត ហឹ កទូប កនូ មែគ ណគ យ៉ាគ់ សារ៉ា។ អ៊ែ ឡើ ចក់ បើម ទ្រី ប្រយ ដើ ណាង រែប៊ែកា។ ឡើ ម៉ើត អន់ញ៉ុ ប្រយ ទ្រី ណគ ញ៉ន ដើ ណាង នែ ឡើយ អ៊ែ អ៊ីសាគ់ ឡើ ប៉ាត់ អង់ងឹះ កយ៉ក់ មែគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","យ៉ាគ់ អាប្រាហាំ ឡើ ចក់ ទ្រី ហន់ដើម ម៉ាត់ ណគ កិទូរ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ណគ ឡើ ពឝ៉ើត កួន កឡ ប៊ឹង យ៉ាគ់ អាប្រាហាំ អំប្រា ជុ ម៉ាត់ មែ ស៊ីមរ៉ាន យ៉ុកសាន មីដាន ម៉ាដៀន អ៊ីះបាក់ ដើម យ៉ាគ់ ស៊ូអាះ។ ");
INSERT INTO brb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","យ៉ុកសាន ឡើ ពឝ៉ើត ស៊ែបា ដើម ឌែដាន់ កួន ចូវ ឌែដាន់ នែ ឡើយ ម៉ើ ត្រ សុនសាត អាស៊ូរ លែទូះ ដើម លែអ៊ូម។ ");
INSERT INTO brb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","កួន កឡ ម៉ាដៀន ឡើ ប៊ិច ម៉ាត់ មែ អ៊ែផា អ៊ែផើរ ហ៊ែណុក អាប៊ីដា ដើម អ៊ែលដាអា។ មែ លែក នែ ឡើយ កួន ចូវ យ៉ាគ់ កិទូរ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","យ៉ាគ់ អាប្រាហាំ ឡើ ម៉ប លែក ដើ ប្រនិច ណគ ដើ កួន ណគ អ៊ីសាគ់។ ");
INSERT INTO brb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ទឹង ណាគ់ ឡើ ញិវ ឡើ ប៉ាក ពយួរ រ៉ាះ ដើ កួន កឡ ណគ ប៊ឹង ទ្រី ដូច  ប៊្លី អ៊ែ ឡើ ប៉្រៃ មែ មន់វីះ ដក់ គូ តៃ ស្រុក ម៉ាត់ តង៉ៃ ឌឹក ចង៉ាយ តើម ប៊ឹង កួន ណគ អ៊ីសាគ់។ ");
INSERT INTO brb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","យ៉ាគ់ អាប្រាហាំ កំប្រាគ់ ណគ លែក អ៊ែ មូយ ក្លាំ ប៉ឹះ ជិត សើង កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ទឹង អ៊ែ ឡើ ញិវ ទុត ឌុញ រ៉គ់សំ ឆំតក ញឹម ក្លើម ក្លាក ប៊្លី អ៊ែ ឡើ គែត ឡើ ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","យ៉ាគ់ អ៊ីសាគ់ អំប្រា យ៉ាគ់ អ៊ីសម៉ាអ៊ែល អំប្រា ជុ កយ៉ក់ បើគ អំប្រា ហឹ ត្រម ច្រាង ម៉ាគ់ពែឡា ហឹ មឺរ យ៉ាគ់ អ៊ែប្រូន កួន យ៉ាគ់ សូហារ ឡើ សុនសាត ហ៊ែត។ ត្រម ច្រាង អ៊ែ ឡើ គូ តៃ ម៉ាត់ តង៉ៃ ឌឹក យ៉ាគ់ ម៉ាមរែ។ ");
INSERT INTO brb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","មឺរ នែ យ៉ាគ់ អាប្រាហាំ ឡើ រួត តើម ប៊ឹង សុនសាត ហ៊ែត ពន់ឋើម។ អ៊ែ អំប្រា ជុ កយ៉ក់ បើគ អំប្រា ហឹ ត្រម ច្រាង ប៊ឹង ទ្រី ណគ យ៉ាគ់ សារ៉ា ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ប៊្លី យ៉ាគ់ អាប្រាហាំ ឡើ គែត ឡើយ គ្រែដៃ ឡើ ប្រាយ កាន ចាគ់ ដើ អ៊ីសាគ់ កួន យ៉ាគ់ អាប្រាហាំ។ ទឹង អ៊ែ អ៊ីសាគ់ ឡើ គូ ដៀក ដាក រន់ឋូវ ឡាហាយ រ៉យ ។ ");
INSERT INTO brb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","អន់នែ ឡើយ ព្រតយ ម៉ាត់ កួន ចូវ យ៉ាគ់ អ៊ីសម៉ាអ៊ែល ឡើ ត្រ កួន កឡ យ៉ាគ់ អាប្រាហាំ ប៊ឹង ណាង ហាឝ៉ារ សុនសាត អ៊ែស៊ីប ក៝ត យ៉ាគ់ សារ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","អន់នែ ម៉ាត់ កួន យ៉ាគ់ អ៊ីសម៉ាអ៊ែល ណគ់ ឡង់ៗ នែបាយ៉ូត មែ អោះ ណគ គែដារ អាត់ប៊ែល មីបសាម ");
INSERT INTO brb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","មីះម៉ា ឌូម៉ា ម៉ាសា ");
INSERT INTO brb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ហាដាត់ ទែម៉ា យែទូរ ណាភីះ ដើម គែឌែម៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","មែ ជិត បារ រ៉ា នែ ឡើយ កួន កឡ យ៉ាគ់ អ៊ីសម៉ាអ៊ែល។ លែក មែ នែ ឡើយ ម៉ើ តង់កង់ ទឹង ក្រាន ឆ្រាំង មែ កឡឹ។ តាម ចនុ ម៉ាត់ មែ តង់កង់ ណិះ ឡើយ ម៉ើ ជុ ម៉ាត់ ស្រ៊ុក ម៉ាត់ កតូ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","កំប្រាគ់ យ៉ាគ់ អ៊ីសម៉ាអ៊ែល លែក ដើ អ៊ែ មូយ ក្លាំ ពែ ជិត ប៉ឹះ កម៉ ឡើយ ប៊្លី អ៊ែ ឡើ គែត ឡើ ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ ណគ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","កួន ចូវ យ៉ាគ់ អ៊ីសម៉ាអ៊ែល កនូ មែ តើម ប៊ឹង ស្រុក ហាវីឡា ឆា ដើ ប៊ឹះ ត្រិញ ស៊ូរ។ ត្រិញ ស៊ូរ នែ ឡើ ចើម ស្រុក អ៊ែស៊ីប តៃ ទ្រូង ដក់ ហឹ ស្រុក អាសើរ។ សុនសាត អ៊ីសម៉ាអ៊ែល ម៉ើ គូ ចង៉ាយៗ តើម ប៊ឹង កួន ចូវ អ៊ីសាគ់ អំម៉ោះ អោះ មែ កឡឹ ។ ");
INSERT INTO brb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","អន់នែ ឡើយ បាត់ កួន ចូវ អ៊ីសាគ់ កួន កឡ យ៉ាគ់ អាប្រាហាំ។ យ៉ាគ់ អាប្រាហាំ ឡើ ពឝ៉ើត អ៊ីសាគ់។ ");
INSERT INTO brb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ទឹង អ៊ីសាគ់ កំប្រាគ់ ណគ ពួន ជិត កម៉ អ៊ែ ឡើ ចង់ ដើ ណាង រែប៊ែកា កួន យ៉ាគ់ ប៊ែធូអ៊ែល ឡើ គូ ហឹ ស្រុក មែសូប៉ូតាមី ណាង រែប៊ែកា នែ ឡើ ត្រ អោះ យ៉ាគ់ ឡាបាន់ មែ នែ ម៉ើ សុនសាត អារ៉ាម។ ");
INSERT INTO brb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ណាង រែប៊ែកា ទ្រី អ៊ីសាគ់ នែ ឡើ កន់ដុង ប៊ិច អ៊ឺម កួន អ៊ែ អ៊ីសាគ់ ឡើ អ៊ឺរ ដាំង ឡា ទឹង គ្រែដៃ ឡើ ណាគ់ អន់សច លំអាំ កួន ដើ ទ្រី ណគ។ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ត្រណើវ ប៉ាគ់ អ្រឡា ណគ អ៊ែ ណាង រែប៊ែកា ឡើ តមែវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","អង់អាង ទឹង ពឌិវ អំប្រា អំម៉ិះ ដដាវ តថាក់ ត្រឌីវ អំប្រា អ៊ែ ណាង រែប៊ែកា ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «ប៉ាគ់ ង៉ាយ ឋូវ អៃ អ៊ិន ប៉ាគ់ អ៊ិន?»។ អ៊ែ ឡើ អ៊ឺរ ដាំង តង៉ា គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហាយ ដើ ណគ រៀន៖ «ទឹង ពឌិវ ហៃ ឡើ ប៊ិច បារ ពធែត សុនសាត បារ ដិ អន់ដិ លន់កើត តើម ប៊ឹង ពឌិវ ហៃ អំប្រា លំដ្រម៉ា ប្លះ អំប្រា សុនសាត មូយ លំប្រិញ ជឺរ សុនសាត មូយ អ៊ូគ ណគ លន់គូ កន់ដ្រូម អោះ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","តគ់ ឡើ ណុះ ខៃ អ៊ែ ឡើ អន់ឆិ កួន ណគ បារ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ណគ់ បឹ ឡើ កើត អន់នួរ ចាក់ ណគ ឡើ ចះៗ ឡើ ប៊ិច សក់ មូរ ទុត អើន ប៉ាគ់ ពត្រូវ។ អ៊ែ ម៉ើ ជុ ម៉ាត់ ណគ “អ៊ែសាវ”។ ");
INSERT INTO brb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ប៊្លី អ៊ែ អោះ ណគ ឡើ ទឺះ ឡើ រ៉ាប់ ប៊ឹង កដើវ ឈឹង អ៊ូគ ណគ តាន់ៗ។ ម៉ើ ជុ ម៉ាត់ អោះ ណគ “យ៉ាកុប”។ ប៊ឹង កួន ណគ អំប្រា កើត កំប្រាគ់ អ៊ីសាគ់ ត្រូវ ជិត កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","តគ់ អំប្រា ទិះ អន់ឆើន អើន កម៉ ឡើយ អ៊ែសាវ ឡើ បនឹះ ហ្រម៉ត រ៉ត ពប៉ូត ពប៉ិញ ឡើ វែរ វ៉ារ់ ហឹ ត្រិញ ង៉ាវ ឡាវ ហទុក។ អ៊ែ ដើ យ៉ាកុប អន់ណាវ ឡើ បនឹះ ហន់ណាម មឺរ ឡើ គូ ប៊ឹង កទូប មីបៗ មឹម អំមឹម។ ");
INSERT INTO brb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","យ៉ាគ់ អ៊ីសាគ់ ម៉ៃ ឡើ ម៉ើត អ៊ែសាវ យ៉ាក់ ឡើ អៀល ងុញ ចា ច្រឡាត អ្រលីង ត្រូវ ណគ។ អ៊ែ ណគ់ ដើ យ៉ាគ់ រែប៊ែកា អន់ណាវ ឡើ ម៉ើត យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","តគ់ តង៉ៃ ហង់អ៊ិន យ៉ាកុប ប៉ះ ឡើ បើម កយ៉ិ អ៊ែ ដើ អ៊ែសាវ ឡើ ជឹ តើម ប៊ឹង វែរ ឡើ ពងួត សាវបះ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","យ៉ាគ់ អ៊ែសាវ ឡើ ឡា ហឹ យ៉ាកុប រៀន៖ «អោះ អឡា កយ៉ិ ចះៗ ហៃ អន់ចា អុះ អសូវ យ៉ាវ អៃ អ៊ិន»។ (ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ ម៉ើ ជុ ណគ “អ៊ែដុម”។) ");
INSERT INTO brb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «អឡាន់ ហន់អាំ ស៊ិត កួន ឡង់ ដើ អៃ អន់ដៃ ណិះៗ»។ ");
INSERT INTO brb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","អ៊ែសាវ ឡើ ត្រណើវ រៀន៖ «ហន់ចក់ ដឹះ អពងួត ស្រឹ អង់គែត ឡើយ អៃ អ៊ិន ង៉ាយ អំបើម ដើ ស៊ិត កួន ឡង់?»។ ");
INSERT INTO brb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","យ៉ាកុប ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ ពអ៊ែ ហន់តប៉ឹន ចាក់ ដើ អៃ អន់ដៃ ណិះៗ»។ អ៊ែ អ៊ែសាវ ឡើ តប៉ឹន ចាក់ ប្រយ អាំ ស៊ិត កួន ឡង់ ដើ អោះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","យ៉ាគ់ យ៉ាកុប ឡើ ចក់ ណំពាំង ដើម កយ៉ិ ហន់តាក កញែ ឡើ អាំ ដើ អ៊ូគ ណគ ចា។ យ៉ាគ់ អ៊ែសាវ ឡើ ចង់ ចា ប្រយ ប៊្លី អ៊ែ ឡើ វីះ។ អ៊ែ អ៊ែសាវ ឡើ លលៀវ តតៀវ ស៊ិត ណគ ឡើ កួន ឡង់។ ");
INSERT INTO brb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ទឹង អ៊ីសាគ់ ឡើ គូ ហឹ ស្រ៊ុក ប៊ែរ ឡាហាយ រ៉យ ប៊ិច កាន អឹត ហរុ ទឹង ស្រុក អ៊ែ កាន អឹត ហរុ នែ ដិៗ តើម ប៊ឹង អឹត ហរុ ណគ់ ឡើ កើត ទឹង ប៉ាង យ៉ាគ់ អាប្រាហាំ។ អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ ដក់ គូ ដៀក មួង ឝែរ៉ា ប៊្រី ដាក សឋិច អាប៊ីម៉ាលែក ឡើ សឋិច សុនសាត មែ ភីលីសទីន។ ");
INSERT INTO brb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","តគ់ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពដៃ ចាក់ ដើ ណគ ឡើ រៀន៖ «ញ៉ង ហទឺះ គូ អ៊ឺម ទិ ស្រុក អ៊ែស៊ីប ចុ ហន់គូ ហឹ ស្រុក ណគ់ អៃ អង់ហាយ ដើ ហៃ អ៊ែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ហន់គូ ហឹ ស្រុក អន់នែ អន់ដៃ។ អៃ អន់លវាំង ឝ្លាំង ហៃ អំប្រាយ កាន ចាគ់ ដើ ហៃ។ លែក ដើ ប៊្រី ដាក នែ អៃ អង់អាំ ដើ ហៃ ដើម ដើ កួន ចូវ ហៃ។ អៃ អំបើម តាម ប្រម៉ាង អៃ អខណាត តប៉ឹន ចាក់ ប៊ឹង បើគ ហៃ យ៉ាគ់ អាប្រាហាំ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","អៃ អន់អាំ ដើ កួន ចូវ ហៃ មន់ស៊ឺក តាក ឞាល់ ពតួរ ទឹង គ្រែ ដើម អន់អាំ លែក ដើ ប៊្រី ដាក នែ ដើ កួន ចូវ ហៃ។ លែក ដើ សុនសាត ទិ ឡាង ប្រិះ មន់ដូវ ពន់ដ្រាយ ចាគ់ យ៉ម កួន ចូវ ហៃ ។ ");
INSERT INTO brb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","អៃ អន់អាំ ដើ ហៃ ប៉ាគ់ នែ យ៉ាក់ យ៉ាគ់ អាប្រាហាំ ឡើ ចង់ហៀង ប្រម៉ាង អៃ ណគ ឡើ បើម តាម កាន អថាន់ ណគ ប៉ាគ់ ពន់ដ្រៃ អៃ តាម ពហាយ អៃ ដើម ប៉ាគ់ ចឞាប់ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","អ៊ែ ឡើយ យ៉ាគ់ អ៊ីសាគ់ ឡើ គូ ដៀក មួង ឝែរ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","មែ កឡ ទឹង មួង អ៊ែ ម៉ើ តង៉ា អ៊ីសាគ់ ម៉ើ ម៉ើត ណោះ ណាង រែប៊ែកា ឡើ កួន ទ្រី មែ ង៉ាយ យ៉ាគ់ អ៊ីសាគ់ ឡើ ត្រណើវ រៀន៖ «ណាង នែ អោះ អៃ»។ ឡើ ហាន អ៊ឺម ឡើ ហាយ ដើ មែ រៀន ណាង អន់នែ ទ្រី ណគ យ៉ាក់ ឡើ ឌូង កឡាគ់ មែ កឡ ទឹង មួង នែ មន់កជែត ណគ ញ៉ន ដើ ណាង រែប៊ែកា យ៉ាក់ ឡើ ចាគ់ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","យ៉ាគ់ អ៊ីសាគ់ ឡើ គូ ហឹ អ៊ែ ទុត ឌុញ។ តគ់ តង៉ៃ ហង់អ៊ិន អាប៊ីម៉ាលែក ឡើ សឋិច សុនសាត មែ ភីលីសទីន ឡើ បយ៉ើល ឝ្លាំង តៃ ឝឡោះ ពហើយ អ៊ែ ឡើ តៃ យ៉ាគ់ អ៊ីសាគ់ ឡើ ប្រលែក ដើ ទ្រី ណគ ណាង រែប៊ែកា។ ");
INSERT INTO brb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","យ៉ាគ់ សឋិច អាប៊ីម៉ាលែក ឡើ ប៉្រៃ មែ ម៉ើ ដក់ កឡូវ យ៉ាគ់ អ៊ីសាគ់ ដក់ ហឹ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «ទ្រី ហៃ ហន់ឆា អៃ ប៉ិ ឡើ ត្រ ហរៀន ហអោះ ដើ ណគ?»។ យ៉ាគ់ អ៊ីសាគ់ ឡើ ត្រណើវ រៀន៖ «អៃ អម៉ាង ប៉ាគ់ អ៊ែ អឌូង មន់កជែត អៃ ញ៉ន ដើ ទ្រី អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","យ៉ាគ់ សឋិច អាប៊ីម៉ាលែក ឡើ ម៉ាង រៀន៖ «ពយ៉ិ ឡើ ត្រ ហបើម ប៉ាគ់ នែ ដើ ញ៉ា? ប៉ុះ លំប៊ិច បឹ មូយ រ៉ា ទឹង បូវ ញ៉ា លំកី ដើ ទ្រី ហៃ ហប៉្រៃ ញ៉ា ញន់ថូត ឡើយ ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ប៉ាគ់ ពអ៊ែ នែ សឋិច អាប៊ីម៉ាលែក ឡើ ថាន់ លែក ដើ ប៉ាសាសុន ណគ រៀន៖ «ប៉ាគ់ មែ ង៉ាយ មន់រួយ បឹ អន់នែ លឺ ទ្រី ណគ ណគ់ មែ អ៊ែ អំប៉្រៃ មន់កជែត តាក់»។ ");
INSERT INTO brb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ទឹង ឡើ គូ ហឹ ស្រុក សឋិច អាប៊ីម៉ាលែក យ៉ាគ់ អ៊ីសាគ់ ឡើ បយ៉ិះ ចិះ កម៉ អ៊ែ ឡើ កៀវ ចិះ ឡើ ដូវ ទុត អើន យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ កាន ចាគ់ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","អ៊ែ ឡើ ប៊ិច បាក់ ចាក់ ចៀរ ចាំ អើន ឆា ឡើ បនឹះ ទិះ ប៊ិច។ ");
INSERT INTO brb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ណគ ឡើ ប៊ិច បប៊ែ ចៀម ប៉ិន ខក ឝ៉ូ ប៉ិន ខក ឋឹក ដ្រឋឹក ដើម ឡើ ប៊ិច ក៝ត ទុត អើន ដិ។ អ៊ែ មែ សុនសាត ភីលីសទីន ម៉ើ ចើះ ដើ ណគ ");
INSERT INTO brb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","អ៊ែ ដាក រន់ឋូវ ណគ់ ក៝ត កយ៉ក់ បើគ ណគ យ៉ាគ់ អាប្រាហាំ ម៉ើ ចះ ទឹង ណាគ់ ឡើ ញិវ ម៉ើ កុប ដើ ពដិះ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","សឋិច អាប៊ីម៉ាលែក ឡើ ម៉ាង ដើ អ៊ីសាគ់ រៀន៖ «វន់វីះ តើម ប៊ឹង ស្រុក ញ៉ា យ៉ាក់ វ៉ើ អើន ថាំង ជឺរ ញ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","យ៉ាគ់ អ៊ីសាគ់ ឡើ វីះ ប្រយ តើម ប៊ឹង ស្រុក ហង់អ៊ែ ឡើ ដក់ បើម កតូ ប្លះ ហួម ចន់ឌូ ឝែរ៉ា អ៊ែ ឡើ គូ ហឹ អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","យ៉ាគ់ អ៊ីសាគ់ ឡើ ប៉្រៃ ក៝ត ណគ ម៉ើ ហួរ ហដា ឡឹះ ដាក រន់ឋូវ លែក ដើ អិះ ណគ់ មែ ម៉ើ ចះ ទឹង ប៉ាង បើគ ណគ យ៉ាគ់ អាប្រាហាំ យ៉ាក់ បូវ មែ ភីលីសទីន ម៉ើ កុប ប៊្លី យ៉ាគ់ អាប្រាហាំ ឡើ គែត។ ណគ់ រន់ឋូវ អ៊ែ ឡើ ព្លូក ជុ ប៉ាគ់ ចនុ បើគ ណគ ពន់ឋើម ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","បូវ ក៝ត អ៊ីសាគ់ ម៉ើ ចះ ឡឹះ អន់ណាវ រន់ឋូវ ហន់ដើម ប្លះ ចណោះ អអ៊ូរ ឡើ ត្រ ប៉ុះ ត្រម ដាក ឡើ ញឺះ ប៊ុះ បួះ។ ");
INSERT INTO brb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ទឹង អ៊ែ បូវ ស្រុក ឝែរ៉ា ម៉ើ បយ៉ា បណាន់ ម៉ើ ច្រម៉ាន ដើ បូវ មែ ម៉ើ បយ៉ា បណាន់ អ៊ីសាគ់ ម៉ើ ម៉ាង រៀន៖ «ដាក នែ ដាក ញ៉ា ហវ៉ៃ!»។ អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ ព្លូក រន់ឋូវ នែ រៀន “អ៊ែស៊ែក” យ៉ាក់ ម៉ើ ច្រម៉ាន ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ប៊្លី អ៊ែ បូវ ក៝ត អ៊ីសាគ់ ម៉ើ ចះ ឡឹះ អន់ណាវ រន់ឋូវ មូយ អ៊ែ មែ ស្រុក ឝែរ៉ា ម៉ើ ច្រម៉ាន អន់ណាវ ប៉ាគ់ ពអ៊ែ អ៊ីសាគ់ ឡើ ព្លូក រន់ឋូវ អ៊ែ រៀន “ស៊ីតណា”។ ");
INSERT INTO brb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","អ៊ីសាគ់ ឡើ សោះ កតូ ឡើ ដក់ បើម ហឹ គែង អ៊ែ ឡើ ចះ ឡឹះ អន់ណាវ រន់ឋូវ តៃ ប៊ិច មែ ង៉ាយ យ៉ាវ មន់ច្រម៉ាន ប៊ឹង ណគ។ ឡើ ព្លូក រន់ឋូវ ហង់អ៊ែ រៀន “រែហូបុត” យ៉ាក់ ណគ ឡើ ម៉ាង រៀន៖ «ណិះៗ នែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ អាំ ពដិះ ឌឺះ វឺង ដើ ង៉ាយ ឡើយ ងន់គូ ស៊ឺក តាក ហ្រវ៉ាក ណាយ ឡើយ ទឹង ស្រុក អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ណគ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ហឹ ស៊្រុក ប៊ែរ ស៊ែបា។ ");
INSERT INTO brb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","តគ់ មាំង អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពដៃ ចាក់ ដើ អ៊ីសាគ់ ឡើ រៀន៖ «អៃ អគ្រែដៃ អកន់ដ្រាគ់ យ៉ាគ់ អាប្រាហាំ បើគ ហៃ។ ញ៉ង ហឌូង អ៊ឺម យ៉ាក់ អៃ អលវាំង ឝ្លាំង ហៃ ឡើយ អៃ អំប្រាយ កាន ចាគ់ ដើ ហៃ អៃ អង់អាំ កួន ចូវ ហៃ មន់ស៊ឺក ទុត អើន ញ៉ន អខណាត ដើ យ៉ាគ់ អាប្រាហាំ ឡើ បើម ឞយ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","យ៉ាគ់ អ៊ីសាគ់ ឡើ ប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក ប៊ឹង អ៊ែ បក់ លន់កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ កឡូវ អ៊ឺរ ដាំង ម៉ាត់ គ្រែដៃ ឡើ ណាគ់ អន់សច។ ណគ ឡើ បើម កតូ ហឹ អ៊ែ អ៊ែ មែ ក៝ត ណគ ម៉ើ ចះ រន់ឋូវ ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","អ៊ែ សឋិច អាប៊ីម៉ាលែក ឡើ វីះ តើម ប៊ឹង មួង ឝែរ៉ា ឡើ ដក់ ហឹ យ៉ាគ់ អ៊ីសាគ់ ឡើ ច្រា យ៉ាគ់ អាហ៊ូសាត ឡើ កឡា ពចោះ ប្រម៉ាង ដើ ណគ ដើម យ៉ាគ់ ភីកុល ឡើ ណាយ តហាន ណគ អំប្រា ដក់ អរែង ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","យ៉ាគ់ អ៊ីសាគ់ ឡើ តង៉ា មែ រៀន៖ «កាន ង៉ាយ វ៉ើ ដក់ ដាំង អៃ ប៉ាគ់ នែ យ៉ាក់ វ៉ើ ដ្រម៉ា ឡើយ ដើ អៃ ដឹប វ៉ើ តវីះ អៃ តើម ប៊ឹង ស្រុក វែ ដិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","អ៊ែ ម៉ើ ត្រណើវ រៀន៖ «ញ៉ា ញ៉ើ តៃ ហឡាក់ រៀន គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ លវាំង ឝ្លាំង ហៃ ម៉ាត់ ម៉ាត។ ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ ញ៉ើ ឃឹត រៀន ញ៉ះ ញន់ខណាត តប៉ឹន ចាក់ ប្លះ ង៉ាយ ដើម ងំអ្រឡាប់ ហំពែម រែម រ៉គ់ ត្រឌីវ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","អ៊ែ ណគ់ កាន ងន់ខណាត អ៊ិន ទឹង ណាគ់ ហគូ ប៊ឹង ស្រុក ញ៉ា ញ៉ើ តំឞាប អ៊ឺម ហៃ ញ៉ើ បើម ចាគ់ ដើ ហៃ អន់សច ញ៉ើ អាំ ហៃ ហវីះ ញឹម សាំង ឡើយ តើម ប៊ឹង ញ៉ា ដើ ហៃ ហន់ឡាប់ តប៉ឹន ចាក់ ដើ ញ៉ា ប៉ាគ់ ទឺ ឡើយ ហំបើម អន់ចាគ់ ដើ ញ៉ា។ ណិះៗ នែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ កាន ចាគ់ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ បើម ចណង់ ចណា អ្រឡាប់ ហំពែម រែម រ៉គ់ ដើ មែ ប៊ឹង អ៊ែ អ៊ែ ម៉ើ ចង់ ចា អរែង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","តគ់ ម៉ើ រ៉ៃ តើម ភុង មាំង អ៊ែ អំប្រា តប៉ឹន ចាក់ ប្លះ អំប្រា។ ប៊្លី អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ ប៉្រៃ មែ ម៉ើ ជឹ វឹញ ញឹម សាំង ក្លាំង រ៉ិញ។ ");
INSERT INTO brb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ទឹង តង៉ៃ អន់ទឺ បូវ ក៝ត យ៉ាគ់ អ៊ីសាគ់ ម៉ើ ជឹ ហាយ ដើ ណគ កាន ម៉ើ ចះ ដាក រន់ឋូវ ម៉ើ រៀន៖ «យ៉ាគ់ អ ញ៉ើ ចះ ត្រ ប៉ុះ ត្រម ដាក ឡើយ ហណោះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","យ៉ាគ់ អ៊ីសាគ់ ឡើ ព្លូក រន់ឋូវ អ៊ែ រៀន “ស៊ែបា”។ ញ៉ន អ៊ែ ឡើយ ម៉ើ ជុ មួង ហង់អ៊ែ រៀន “ប៊ែរ ស៊ែបា” ឆា ដើ ប៊ឹះ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","តគ់ យ៉ាគ់ អ៊ែសាវ កំប្រាគ់ ណគ ពួន ជិត កម៉ ឡើ ចក់ ទ្រី សុនសាត ហ៊ែត បារ រ៉ា ទ្រី តើម ណាង យូឌីត កួន យ៉ាគ់ ប៊ែរី ទ្រី ដូច ណគ ណាង បាះម៉ាត់ កួន យ៉ាគ់ អ៊ែឡូន។ ");
INSERT INTO brb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","យ៉ាគ់ អ៊ីសាគ់ អំប្រា យ៉ាគ់ រែប៊ែកា អំប្រា ដុង ស្រៀវ អ្រអូវ តូវ ឡើ ឈូគ ក្លើម ញ៉ន ដើ ទ្រី អ៊ែសាវ លែក បារ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","តគ់ អ៊ីសាគ់ ឡើ ក្រាគ់ៗ ម៉ៃ ឡើយ ម៉ាត់ ណគ ចាំ លឹម បលឹម ឆា តៃ ឡើ ត្រប៉ៃ យ៉ាវ។ តង៉ៃ ហង់អ៊ិន ឡើ ប៉្រៃ ម៉ើ កឡូវ កួន ឡង់ ណគ អ៊ែសាវ លំដក់ ហឹ ណគ។ តគ់ ឡើ ប៊ឹះ ឡើយ ឡើ ម៉ាង រៀន៖ «អើយ កួន!»។ អ៊ែសាវ ឡើ ត្រណើវ រៀន៖ «ង៉ាយ បើគ? នែ អៃ!»។ ");
INSERT INTO brb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ឡើ ហាយ ដើ កួន ណគ រៀន៖ «អៃ នែ អក្រាគ់ៗ ដៀប អង់គែត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ប៉ាគ់ ពអ៊ែ កួន ហន់ចក់ ស្រាវ កាំង ដ្រាំង ចង់កោះ ហន់វែរ ពប៉ូត ពប៉ិញ ហឹ ត្រិញ ង៉ាវ ហន់ជឹ តៀត អ្រលីង ត្រូវ ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ប៊្លី អ៊ែ ហំបើម កយ៉ិ ញឹមៗ តាម ប្រម៉ើត អៃ ហន់ដក់ អាំ ដើ អៃ អន់ចា។ អ៊ែ អំប្រាយ កាន ចាគ់ ដើ ហៃ ទឹង ណាគ់ អញិវ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","អ៊ែ យ៉ាគ់ អ៊ែសាវ ឡើ វីះ វែរ ប្រយ ហឹ ត្រិញ ង៉ាវ ដក់ ប៉ិញ អ្រលីង ត្រូវ លំជឹ តៀត ដើ បើគ ណគ។ យ៉ាគ់ រែប៊ែកា ឡើ ចង់ហៀង ម៉ច ប៉ាគ់ទឺ ប៊ឹង យ៉ាគ់ អ៊ីសាគ់ ឡើ ពហាយ ដើ អ៊ែសាវ។ ");
INSERT INTO brb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","អ៊ែ ឡើ ហាយ ដើ កួន អន់សូច ណគ យ៉ាកុប រៀន៖ «អៃ អដុង បើគ ហៃ ឡើ ចជែ ដើ អ៊ូគ ហៃ អ៊ែសាវ រៀន ");
INSERT INTO brb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“មិញ ហន់ដក់ ប៉ិញ អ្រលីង ត្រូវ ហន់ជឹ តៀត ដើ អៃ ហំបើម កយ៉ិ ញឹមៗ ដើ អៃ អន់ចា។ អ៊ែ អំប្រាយ កាន ចាគ់ ដើ ហៃ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច ទឹង ណាគ់ អញិវ”។ ");
INSERT INTO brb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ណិះៗ នែ កួន អើយ ហន់ចង់ហៀង ប្រម៉ាង អៃ អប៉្រៃ ហៃ ហំបើម។ ");
INSERT INTO brb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","មិញ ហន់ដក់ ចក់ កួន បប៊ែ ណគ់ ទិះៗ បិញៗ បារ អំប៉ម អ៊ែ អំបើម កយ៉ិ ញឹមៗ តាម ប៉ាគ់ ប្រម៉ើត បើគ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ប៊្លី អ៊ែ ហន់ដក់ ឈូន ដើ បើគ ហៃ លន់ចា អ៊ែ លំប្រាយ កាន ចាគ់ ដើ ហៃ ទឹង ណាគ់ ឡើ ញិវ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","យ៉ាកុប ឡើ ត្រណើវ ម៉ាង មែគ ណគ រៀន៖ «ដូវ អ៊ឺម អំបើម ប៉ាគ់ អ៊ិន! អ៊ូគ អ៊ែសាវ ឡើ ប៊ិច សក់ មូរ ប៊ិង ចាក់ ដើ អៃ នែ អហឡិញ។ ");
INSERT INTO brb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ហន់ណូវ បើគ លំបបើត អៃ លំណោះ អៃ អតបូត ណគ ឡើ បើម ប៉ាគ់ អឡា អ្រយ៉វ ណគ អាត អន់ដូវ អ៊ឺម ពន់ដ្រាយ ចាគ់»។ ");
INSERT INTO brb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","មែគ ណគ ឡើ ត្រណើវ រៀន៖ «អើយ កួន ណគ់ កាន អ្រយ៉វ អ៊ែ លន់គ្លីះ ហឹ អៃ ឆិ! អ៊ែ ណគ់ ដើ ហៃ វ៉ិះ ឌិវ ហន់ចង់ហៀង ប្រម៉ាង អៃ អិះ ឡើយ មិញ ហន់ដក់ ចក់ កួន បប៊ែ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","យ៉ាកុប ឡើ ដក់ ចក់ ប្រយ កួន បប៊ែ អាំ ហឹ មែគ ណគ អ៊ែ មែគ ណគ ឡើ បើម កយ៉ិ ទុត ញឹម តាម ប៉ាគ់ ប្រម៉ើត អ៊ីសាគ់។ ");
INSERT INTO brb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ប៊្លី អ៊ែ យ៉ាគ់ រែប៊ែកា ឡើ ដក់ ចក់ ប្រវ៉ើន ហណក ចណុង ចណាគ់ កួន ឡង់ ណគ អ៊ែសាវ ណគ់ អ៊ែសាវ ឡើ ជុ ហឹ ហន់ណាម កណី មែគ ណគ ឡើ អាំ ដើ កួន អន់សូច ណគ យ៉ាកុប លំហក។ ");
INSERT INTO brb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","មែគ ណគ ឡើ ចក់ អ្រឡូត ហំបក បប៊ែ ឡើ តវ៉ាត់ ប៊ឹង ទី ដើម ប្លះ ដង់ យ៉ាកុប ណគ់ ប្លះ ឡើ ហឡិញ។ ");
INSERT INTO brb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ប៊្លី អ៊ែ ឡើ ចក់ កយ៉ិ ទុត ញឹម ដើម ណុំពាំង ណគ់ ណគ ឡើ បើម ឡើ អាំ ដើ កួន ណគ យ៉ាកុប លន់ដក់ ឈូន។ ");
INSERT INTO brb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","យ៉ាកុប ឡើ ដក់ អាំ ប្រយ ដើ បើគ ណគ។ ឡើ កឡូវ រៀន៖ «បើគ!»។ យ៉ាគ់ អ៊ីសាគ់ ឡើ ត្រណើវ រៀន៖ «ង៉ាយ កួន? បឹ អង់ង៉ាយ ហៃ អ៊ិន អ៊ែសាវ យ៉ាកុប?»។ ");
INSERT INTO brb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «អ៊ឺគ អៃ នែ អ៊ែសាវ កួន ឡង់ ហៃ។ អៃ អបើម តាម ហៃ ហប៉្រៃ។ ហន់ឌឹក ដ្រូម បើគ ហន់ចា ច្រឡាត អ្រលីង ត្រូវ នែ អន់ដៃ អ៊ែ ហន់ដូវ ប្រាយ កាន ចាគ់ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","យ៉ាគ់ អ៊ីសាគ់ ឡើ ម៉ាង រៀន៖ «ដ្រិះ ឌិះ កួន អើយ ហដូវ ហជឹ តើម ប៊ឹង ពប៉ិញ!»។ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កន់ដ្រាគ់ ហៃ បើគ ឡើ ប៉ូរ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","យ៉ាគ់ អ៊ីសាគ់ ឡើ ម៉ាង ឡឹះ ដើ យ៉ាកុប រៀន៖ «ចើមៗ ហន់ដក់ ហឹ អៃ នែ អំបបើត តមឹង ណោះ ហន់ត្រ អ៊ែសាវ ណោះ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","យ៉ាកុប ឡើ ដក់ ចើមៗ តគ់ បើគ ណគ អ៊ែ បើគ ណគ ឡើ បបើត ឡើ ម៉ាង រៀន៖ «ប្រម៉ាង អ៊ិន ប្រម៉ាង យ៉ាកុប ហាក់ ទី អ៊ិន ឡើ ត្រ ទី អ៊ែសាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ឡើ ហឝ៉ាវ អ៊ឺម យ៉ាកុប យ៉ាក់ ទី ណគ ឡើ ប៊ិច សក់ មូរ ប៉ាគ់ អ៊ែសាវ ទឺ។ ហាក់ ទឹង ហូច លំប្រាយ កាន ចាគ់ ");
INSERT INTO brb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ណគ ឡើ តង៉ា ពឡាក់ អន់ដៃ រៀន៖ «កួន ហអ៊ែសាវ ម៉ាត់ ម៉ាត ឡះ?»។ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «អៃ ឡើយ បើគ!»។ ");
INSERT INTO brb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","យ៉ាគ់ អ៊ីសាគ់ ឡើ ម៉ាង រៀន៖ «ហន់ជុ កយ៉ិ ហៃ ចើមៗ តគ់ អៃ នែ អន់ចា អ្រលីង ត្រូវ ហៃ ប៊្លី អ៊ែ អំប្រាយ កាន ចាគ់ ដើ ហៃ»។ យ៉ាកុប ឡើ ពយ៉ ហឹ បើគ ណគ លន់ចា ដើម ឡើ អាំ តវែ ឈឹង ជែម ដិ ដើ បើគ ណគ លំញែត។ ");
INSERT INTO brb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ប៊្លី ឡើ ចង់ ចា លែវ ឡើយ អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ ម៉ាង រៀន៖ «អើយ កួន ហន់ដក់ មុក អៃ អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","យ៉ាកុប ឡើ ដក់ ចើមៗ តគ់ បើគ ណគ អ៊ែ ឡើ មុក ប្រយ។ ប៊ឹង អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ ដុង ហអម ខូ អាវ អ៊ែសាវ អ៊ែ ឡើ ប្រាយ រៀន៖ «ហអម ចាក់ កួន អៃ អ៊ិន ផឹ ឞាល់ ហអម ប៉ូច ទឹង មឺរ ប៊្លី ឡើ អំមឺ ណគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ។ ");
INSERT INTO brb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","គ្រែដៃ លំអាំ ដាក ស្រ៊ិវ តើម ទិ គ្រែ ដើ ហៃ ដើម ប្រិះ អ៊ីន ប៊ិច ប៉ូច តារ់ ដិ។ គ្រែដៃ លំអាំ ដើ ហៃ ហំប៊ិច ប៊ូត ហម៉ិះ ចិះ ចើក ដើម តវែ ឈឹង ជែម ហន់ដើម ទុត អើន ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","លំអាំ សុនសាត មែ គែង មន់ក៝ត ហៃ លំអាំ សុនសាត ដិ អន់ដិ មន់កដាប ហំបះ ហៃ! លំអាំ កួន អៃ លំពែក ប៉ាក់ ពឺង អំម៉ោះ អោះ ហៃ លំអាំ អំម៉ោះ អោះ មូយ មែគ មន់កដាប ហំបះ ហៃ! មែ ង៉ាយ មន់យ៉វ ក្លះ ហៃ មែ អ៊ែ មន់ដូវ ដើ អ្រយ៉វ ឡើយ អ៊ែ ណគ់ មែ ង៉ាយ មន់ប្រាយ កាន ចាគ់ ដើ ហៃ មែ អ៊ែ មន់ដូវ ពន់ដ្រាយ ចាគ់ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ប៊ឹង យ៉ាគ់ អ៊ីសាគ់ ឡើ ប្រាយ យ៉ាកុប លែវ ឡើយ អ៊ែ យ៉ាកុប ឡើ វីះ តើម ប៊ឹង បើគ ណគ ប៊្លី អ៊ែ អ៊ែសាវ ឡើ ប៊ឹះ តើម ប៊ឹង វែរ ស្រឹ លំដាន់។ ");
INSERT INTO brb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ណគ ឡើ បើម កយ៉ិ ទុត ញឹម ប៉ាគ់ទឺ ឡើ ដក់ ឈូន ដើ បើគ ណគ។ ឡើ កឡូវ រៀន៖ «អើយ បើគ! ហន់ឌឹក ចា ច្រឡាត អ្រលីង ត្រូវ នែ ប៊្លី អ៊ែ ហន់ដូវ ប្រាយ កាន ចាគ់ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","យ៉ាគ់ អ៊ីសាគ់ ឡើ តង៉ា រៀន៖ «មែ ង៉ាយ ហង់អ៊ិន?»។ អ៊ែសាវ ឡើ ត្រណើវ រៀន៖ «អៃ អ៊ែសាវ កួន ឡង់ ហៃ បើគ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ សសឹរ ចាក់ ទុត ខាក់ ឡើ តង៉ា រៀន៖ «អន់ឌូ មែ ង៉ាយ ដឹះ ម៉ើ ដក់ ឈូន ម៉ាត អ្រលីង ត្រូវ ដើ អៃ? ទឹង តៃ ដាន់ ហប៊ឹះ អចង់ ចា លែក ឡើយ អប្រាយ កាន ចាគ់ ដើ ណគ។ យ៉ើ ណគ អ៊ែ ឌិះ លំដូវ ពន់ដ្រាយ ម៉ាត់ ម៉ាត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","តគ់ អ៊ែសាវ ឡើ ដុង ប្រម៉ាង បើគ ណគ ប៉ាគ់ អ៊ែ ស្រៀវ អ្រអវ ប្រយ ឡើ ដុង ឡើ ហរ៉ាវ ទុត ថាំង អ៊ែ ឡើ ឡា ឡូម ហឹ បើគ ណគ រៀន៖ «បើគ អឡា ហំប្រាយ កាន ចាគ់ ដើ អៃ ដិ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","យ៉ាគ់ អ៊ីសាគ់ ឡើ ត្រណើវ រៀន៖ «ដូវ យ៉ាវ! យ៉ាក់ អោះ ហៃ ឡើ ដក់ តបូត អៃ ឡើ ចក់ ពន់ដ្រាយ កន់តើម តើម ប៊ឹង ហៃ លែវ ឡើយ កួន អើយ!»។ ");
INSERT INTO brb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","អ៊ែសាវ ឡើ ម៉ាង រៀន៖ «ត្រ ឡើយ ម៉ើ ជុ ណគ “យ៉ាកុប” យ៉ាក់ ណគ ឡើ តបូត កន់តើម តើម ប៊ឹង អៃ ញឹះ បារ តង ដើ ណិះ ឡើយ។ ពន់ឋើម ឡើ កន់តើម ស៊ិត កួន ឡង់  ណិះៗ នែ ឡើ ចក់ ពន់ដ្រាយ អៃ ឡឹះ អន់ណាវ! បើគ ណាគ់ៗ ឡះ ពន់ដ្រាយ ហជុ ដើ អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","យ៉ាគ់ អ៊ីសាគ់ ឡើ ម៉ាង អន់ណាវ រៀន៖ «អៃ អប្រាយ ណគ លំពែក ប៉ាក់ ពឺង ហៃ ឡើយ កួន! ដើម អអាំ អំម៉ោះ អោះ ណគ លែក រ៉ា មន់ក៝ត ណគ។ អប្រាយ ណគ លំប៊ិច ប៊ូត ហម៉ិះ ចិះ ចើក ដើម តវែ ឈឹង ជែម ហន់ដើម ដិ។ អណោះ យ៉ាវ កួន អើយ អង់អាំ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","អ៊ែសាវ ឡើ តង៉ា ឡឹះ បើគ ណគ រៀន៖ «បើគ ហប៊ិច ពន់ដ្រាយ ឌិវ មូយ អិះ ឡើយ ឡះ? ឡា ហំប្រាយ កាន ចាគ់ ដើ អៃ ដិ អុះ!»។ ប៊្លី អ៊ែ អ៊ែសាវ ឡើ ញឺម រង់អូក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","យ៉ាគ់ អ៊ីសាគ់ ឡើ ប្រាយ ដើ កួន ណគ រៀន៖ «ហៃ ហន់គូ ចង៉ាយ តើម ប៊ឹង ប្រិះ អ៊ីន ប៊ិច តារ់ ប្រិះ ហៃ លំចង៉ាយ តើម ប៊ឹង ដាក ស្រ៊ិវ តើម ទិ គ្រែ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ហៃ ហន់ចៀម ចាក់ ដើ ប្រណើម ក្រណោះ ដ្រូក សាក ហំក៝ត អោះ ហៃ ហាក់ ទឹង ហូច ហន់ត្រប្លូច អ៊ែក អោះ ហៃ លំជុ ប៊ឹង ដង់ ហៃ អ៊ែ ហន់ក្លើច តើម ប៊ឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","អ៊ែសាវ ឡើ ចនិះ ណាគ់ ញ៉ិកៗ ហៀរៗ ឡើ ចាន យ៉ាកុប ញ៉ន យ៉ាកុប ឡើ ដូវ ពន់ដ្រាយ តើម ប៊ឹង បើគ ណគ។ ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «បើគ អៃ ដៀប លំគែត ឡើយ តគ់ លំគែត អន់កជែត តាក់ យ៉ាកុប»។ ");
INSERT INTO brb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ប៊ិច មែ ម៉ើ ដក់ ពហាយ ដើ យ៉ាគ់ រែប៊ែកា កាន អ៊ែសាវ ឡើ ចាន កជែត អោះ ណគ អ៊ែ ដើ រែប៊ែកា ឡើ ប៉្រៃ មន់កឡូវ យ៉ាកុប ដក់ ហឹ ណគ ឡើ ហាយ រៀន៖ «អ៊ូគ ហៃ អ៊ែសាវ ឡើ ងុញ កជែត ហៃ អ៊ែ លំសះ ក្លើម ណគ ហណោះ។ ");
INSERT INTO brb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ប៉ាគ់ ពអ៊ែ កួន អើយ ហន់ចង់ហៀង ម៉ាង អៃ ហំវីះ ព្រដិច ចាក់ ដ្រិះៗ ហឹ មិះ ហៃ យ៉ាគ់ ឡាបាន់ អ៊ូគ អៃ ហឹ ស្រុក ខារ៉ាន់ តគ់។ ");
INSERT INTO brb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ហន់គូ ហឹ ណគ ឞិត ឞ៊ែត អន់ដៃ ទឹង ហូច អ៊ូគ ហៃ លំប៉ាត់ មាំ។ ");
INSERT INTO brb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","តង៉ៃ ង៉ាយ អ៊ូគ ហៃ លំប៉ាត់ មាំ ដើ ហៃ ដើម លំវឺញ កាន ហៃ ហបើម ដើ ណគ អ៊ែ អៃ អំប៉្រៃ មែ មន់ដក់ ចក់ ហៃ។ អឌី អ៊ឺម សប្រា លំប៉ាត់ មូយ តង៉ៃ ញឹះ លែក សប្រា»។ ");
INSERT INTO brb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ប៊្លី អ៊ែ យ៉ាគ់ រែប៊ែកា ឡើ ហាយ ដើ អ៊ីសាគ់ រៀន៖ «តូវ អទុត ចនិះ អៃ អ៊ិន ញ៉ន ដើ កទ្រី សុនសាត ហ៊ែត នែ។ ប៉ាគ់ យ៉ាកុប លន់ចក់ ទ្រី សុនសាត ហ៊ែត ទឹង ស្រុក អន់នែ ប៉ាគ់ ដើ អ៊ែសាវ ទឺ ណាគ់ ហយ អង់គែត កឋឹះ អៃ អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","យ៉ាគ់ អ៊ីសាគ់ ឡើ កឡូវ កួន ណគ យ៉ាកុប ឡើ ប្រាយ កាន ចាគ់ ដើ ណគ អ៊ែ ឡើ កំប៊ែត រៀន៖ «ញ៉ង ហចក់ អ៊ឺម ទ្រី ទឹង ស្រុក កាណាន នែ។ ");
INSERT INTO brb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","មិញ ហំវីះ ដក់ ដាំង យ៉ាគ់ អ ហៃ យ៉ាគ់ ប៊ែធូអ៊ែល ឆ្រាំង មែគ ហៃ ហឹ ស្រុក មែសូប៉ូតាមី  ហឹ អ៊ែ ហន់ចក់ កួន មិះ ហៃ យ៉ាគ់ ឡាបាន់ ហំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","គ្រែដៃ ឡើ ឆង៉ាត់ ថាំង ទុត ខាក់ លំប្រាយ កាន ចាគ់ ដើ ហៃ លំអាំ ហំប៊ិច កួន ចូវ ចាំ អើន ដើម លំអាំ មន់ស៊ឺក តាក អ៊ែ ហំវឹរ សុនសាត ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","គ្រែដៃ លំអាំ ពន់ដ្រាយ បើគ អៃ យ៉ាគ់ អាប្រាហាំ លំត ឆា ដើ ប៊ឹះ ហៃ ដើម ដើ កួន ចូវ ហៃ ដិ បក់ ហំដូវ ចក់ ប៊្រី ដាក ប្លះ ឞន ហៃ ហពលិះ ពឡាក់ កតូ នែ ណគ់ ប៊្រី ដាក ឡើ អាំ ដើ បើគ អៃ អាប្រាហាំ ពន់ឋើម!»។ ");
INSERT INTO brb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ីសាគ់ ឡើ ប៉្រៃ យ៉ាកុប វីះ។ យ៉ាកុប ឡើ វីះ ប្រយ ហឹ ស្រុក មែសូប៉ូតាមី ហឹ ហន់ណាម មិះ ណគ យ៉ាគ់ ឡាបាន់ កួន យ៉ាគ់ ប៊ែធូអ៊ែល សុនសាត អារ៉ាម ឡើ ត្រ អ៊ូគ យ៉ាគ់ រែប៊ែកា មែគ យ៉ាកុប អំប្រា អ៊ែសាវ។ ");
INSERT INTO brb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","យ៉ាគ់ អ៊ែសាវ ឡើ ដុង បើគ ណគ ឡើ ប្រាយ កាន ចាគ់ ដើ យ៉ាកុប ដើម ឡើ ប៉្រៃ ដក់ ដាំង ទ្រី ហឹ ស្រុក មែសូប៉ូតាមី ដឹប ឡើ ថាន់ ថយ ប៊ឹង ឡើ ប្រាយ អ៊ែ រៀន “ញ៉ង ហចក់ អ៊ឺម ទ្រី ទឹង ស្រុក កាណាន នែ”។ ");
INSERT INTO brb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ណគ ឡើ ដុង យ៉ាកុប ឡើ បើម តាម ពន់ដ្រៃ មែគ បើគ ណគ ឡើ វីះ ហឹ ស្រុក មែសូប៉ូតាមី។ ");
INSERT INTO brb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ប៉ាគ់ ពអ៊ែ ឡើ ណោះ ឡើយ បើគ ណគ ឡើ ដារ់ អ៊ឺម ដើ មែ កទ្រី ទឹង ស្រុក កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","អ៊ែ អ៊ែសាវ ឡើ ដក់ ដាំង មិះ ណគ យ៉ាគ់ អ៊ីសម៉ាអ៊ែល កួន យ៉ាគ់ អាប្រាហាំ ហឹ អ៊ែ ឡើ ចក់ ទ្រី មូយ ឡឹះ អន់ណាវ ម៉ាត់ ណគ ណាង ម៉ាហាឡាត ឡើ ត្រ អោះ យ៉ាគ់ នែបាយ៉ូត ។ ");
INSERT INTO brb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","យ៉ាកុប ឡើ វីះ តើម ប៊ឹង ស៊្រុក ប៊ែរស៊ែបា ដក់ ហឹ ស្រុក ខារ៉ាន់។ ");
INSERT INTO brb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ឡើ ប៊ឹះ តគ់ ឞន លមូយ បអើយ ឡើ លុច ម៉ាត់ តង៉ៃ មាំង អ៊ែ ឡើ កី ប៊ឹង អិះ ប្រយ។ អ៊ែ ឡើ ចក់ តម៉ ឡើ កើវ ទូះ ប៊្លី អ៊ែ ឡើ ហង់ង៉ាន់ តៀក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ឡើ ពកី តៃ អរ៉ង មូយ តើម ប៊ឹង ឡាង ប្រិះ ទូត គ្រែ ឡើ តៃ ឞាវ គ្រែដៃ ម៉ើ អន់ឆូវ ទឺះ ឌឹកៗ តៃ អរ៉ង។ ");
INSERT INTO brb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ហំប៊្រុះ ដើ អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ គូ ដៀក ណគ ឡើ ហាយ រៀន៖ «អៃ នែ ឡើយ អគ្រែដៃ អណាគ់ អន់សច អកន់ដ្រាគ់ យ៉ាគ់ អ ហៃ អាប្រាហាំ ដើម អកន់ដ្រាគ់ បើគ ហៃ អ៊ីសាគ់ ដិ។ អន់អាំ ប៊្រី ដាក ប្លះ ហៃ ហកី នែ ដើ ហៃ ដើម ដើ កួន ចូវ ហៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","កួន ចូវ ហៃ មន់ស៊ឺក អើន ឞាល់ អន់ទឹក ប្រិះ។ ប៊្រី ដាក ហៃ លំចាំ ឌឺះ តៃ ម៉ាត់ តង៉ៃ ឌឹក ម៉ាត់ តង៉ៃ លុច ដើម តៃ ព្រឌឹង ម៉ាត់ តង៉ៃ តៃ ចអៀវ តៃ ចម៉ា ។ ត្រំ ឆ្រាំង ទិ ឡាង ប្រិះ មន់ដូវ ពន់ដ្រាយ ចាគ់ យ៉ម ហៃ ដើម កួន ចូវ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ដាវ ឡើយ អៃ អន់គូ ប៊ឹង ហៃ អន់លវាំង ឝ្លាំង ហៃ ត្រំ ឞន ណគ់ ហៃ ហន់ដក់ អ៊ែ អៃ អន់តៀត ហៃ ហន់ជឹ វឹញ ហឹ ប៊្រី ដាក អន់នែ ទឺ។ អៃ អំពលែក អង់ង៉ាយៗ តាម អខណាត ដើ ហៃ អន់តាក់ អ៊ឺម ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","យ៉ាគ់ យ៉ាកុប ឡើ រ៉ៃ ប្រយ អ៊ែ ឡើ ឃឹត រៀន៖ «គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ គូ ប្លះ នែ ម៉ាត់ ម៉ាត ញឹះ តៃ អណោះ អ៊ឺម!»។ ");
INSERT INTO brb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ឡើ ឌូង អ៊ែ ឡើ ម៉ាង រៀន៖ «ប្លះ នែ ឡើ ខាត់ ឆង៉ាត់ តៃ ឋាំ បើម ឌូង! ឡើ ត្រ កនូ គ្រែដៃ ដើម ឝឡោះ ទឹង ហូង គ្រែដៃ ម៉ាត់ ម៉ាត ប្លះ នែ ឌិះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","យ៉ាគ់ យ៉ាកុប ឡើ រ៉ៃ តើម ភុង មាំង ឡើ ចក់ តម៉ ណគ់ ណគ ឡើ កើវ ទូះ ឡើ បយ៉ុង បើម ឡាក់ ប៊្លី អ៊ែ ឡើ ហ៊ែង ពុក ពឺង អ៊ែ ។ ");
INSERT INTO brb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ឡើ ជុ កនូ ប្លះ នែ រៀន “ប៊ែតអ៊ែល”។ (តើម ពន់ឋើម ម៉ើ ជុ មួង ចើមៗ ប្លះ អ៊ែ រៀន “លូះ”។) ");
INSERT INTO brb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","យ៉ាកុប ឡើ ខណាត ឡាប់ រៀន៖ «គ្រែដៃ អើយ ប៉ាគ់ ហន់គូ ប៊ឹង អៃ ម៉ាត់ ម៉ាត ដើម ហន់លវាំង ឝ្លាំង អៃ តៃ ទ្រូង ណគ់ អៃ អដក់ នែ ប៉ាគ់ ហន់អាំ ចណង់ ចណា ដើម ត្រទ្រូប ហហក ដើ អៃ ");
INSERT INTO brb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ប៉ាគ់ អៃ អន់ជឹ វឹញ ហឹ ហន់ណាម មែគ បើគ អៃ ញឹម សាំង ក្លាំង រ៉ិញ អ៊ែ អន់ចក់ ហៃ ហគ្រែដៃ ឡើ ណាគ់ អន់សច អំបើម កន់ដ្រាគ់ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","តម៉ ណគ់ អៃ អបយ៉ុង បើម ឡាក់ នែ លំត្រ ឞន កដាប ហំបះ គ្រែដៃ។ អង់ង៉ាយៗ តមឹង ហន់អាំ ដើ អៃ កនុង ជិត អៃ អំម៉ប មូយ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","យ៉ាកុប ឡើ វីះ ឡឹះ អន់ណាវ ឡើ ដក់ ហឹ ស្រុក មែ តៃ ម៉ាត់ តង៉ៃ ឌឹក។ ");
INSERT INTO brb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ប៊ឹះ តគ់ អ៊ែ ឡើ តៃ រន់ឋូវ មូយ ទឹង ត្រិញ ដើម ឡើ តៃ បប៊ែ ចៀម ពែ បូវ ម៉ើ បួន ដៀក អ៊ែ ទឺ យ៉ាក់ ម៉ើ ខើយ ឞង ពញែត ដាក ប៊ឹង អិះ ឡើយ។ រន់ឋូវ អ៊ែ ម៉ើ គ្លឹប ដើ តម៉ ទុត ទិះ។ ");
INSERT INTO brb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","តគ់ ម៉ើ តមួត បប៊ែ ចៀម លែក ឡើយ អ៊ែ ម៉ើ ប៉ើក ឝឹ ព្រលូ តម៉ ក្រលឹប រន់ឋូវ អ៊ែ ម៉ើ ពញែត បប៊ែ ចៀម មែ ប៊្លី អ៊ែ ម៉ើ គ្លឹប ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","យ៉ាកុប ឡើ ដក់ តង៉ា មែ ម៉ើ បយ៉ា ចៀម រៀន៖ «អើយ អ៊ូគ ប៉ ស្រុក ង៉ាយ វែ នែ អិះ?»។ មែ ម៉ើ ត្រណើវ រៀន៖ «ញ៉ា នែ ស្រុក ខារ៉ាន់»។ ");
INSERT INTO brb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ឡើ តង៉ា ឡឹះ មែ រៀន៖ «ណាគ់ វ៉ើ ហង់ឝ៉ាវ ឡះ យ៉ាគ់ ឡាបាន់ ចូវ យ៉ាគ់ ណាខូរ?»។ ម៉ើ ត្រណើវ រៀន៖ «ហង់ឝ៉ាវ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","យ៉ាកុប ឡើ តង៉ា មែ រៀន៖ «ណាគ់ ឡើ ឆនឹម ហន់ណាំង ឡះ?»។ ម៉ើ ត្រណើវ រៀន៖ «ឆនឹម ហន់ណាំង អន់ណាវ! តគ់ ដឹះ ណាង រ៉ាជែល កួន ណគ ឡើយ អន់តគ់ ឡើ ឞង បប៊ែ ចៀម តៀត ហឹ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","យ៉ាកុប ឡើ ម៉ាង រៀន៖ «វន់ឝ្លាំង ម៉ាត់ តង៉ៃ ទិ ណាគ់ ឈ្រូងៗ ញ៉ង វ៉ើ តមួត អន់ដិះ ពត្រូវ វែ។ វន់ពញែត ដាក អន់ដៃ ប៊្លី អ៊ែ វន់បយ៉ា ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ម៉ើ ត្រណើវ រៀន៖ «ដូវ អ៊ឺម ញំពញែត ដាក ណិះៗ ចាំ លំស្រូម លែក ដើ បូវ មែ អន់ដៃ អ៊ែ ញំប៉ើក ពញែត»។ ");
INSERT INTO brb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","យ៉ាកុប ទឹង ប៉ះ ឡើ ចជែ ដើ មែ ហំប៊្រុះ ដើ អ៊ែ ណាង រ៉ាជែល ឡើ ប៊ឹះ ប៉ាគ់ ទឺ ឡើ ឞង បប៊ែ ចៀម បើគ ណគ យ៉ាក់ ណគ ឡើ កឡា បយ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ប៊ឹង យ៉ាកុប ឡើ តៃ ណាង រ៉ាជែល កួន យ៉ាគ់ ឡាបាន់ អ៊ូគ មែគ ណគ ដើម បូវ បប៊ែ ចៀម មិះ ណគ អ៊ែ យ៉ាកុប ឡើ ដក់ ប៉ើក ប្រយ រន់ឋូវ ឡើ ឈិត ដាក អាំ ដើ បប៊ែ ចៀម មិះ ណគ មន់ញែត។ ");
INSERT INTO brb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ប៊្លី អ៊ែ ឡើ មុក ណាង រ៉ាជែល ដើម ឡើ ញឺម យ៉ាក់ ឡើ ញឹម ក្លើម។ ");
INSERT INTO brb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","យ៉ាកុប ឡើ ហាយ ដើ ណាង រ៉ាជែល រៀន៖ «បា នែ បើ អំម៉ោះ អោះ មូយ យ៉ាគ់ តៃ បើគ ហៃ អៃ នែ កួន យ៉ាគ់ រែប៊ែកា»។ អ៊ែ ណាង រ៉ាជែល ឡើ ជឹ អ្រយ៉ាវ ពហាយ ហឹ បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","តគ់ យ៉ាគ់ ឡាបាន់ ឡើ ដុង ម៉ន ណគ យ៉ាកុប កួន អោះ កទ្រី ណគ ឡើ ប៊ឹះ ឡើ ដក់ យ៉ាវ អម មុក មុញ ប្រយ អ៊ែ ឡើ ច្រា យ៉ាកុប ជឹ ហឹ ហន់ណាម។ អ៊ែ ឡើ ពប៉ច ដើ មិះ ណគ លែក កាន បាត់។ ");
INSERT INTO brb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","យ៉ាគ់ ឡាបាន់ ឡើ ម៉ាង រៀន៖ «ហៃ នែ កួន អោះ អៃ ម៉ាត់ ម៉ាត ឡើយ!»។ យ៉ាកុប ឡើ គូ ហឹ យ៉ាគ់ ឡាបាន់ ប៊ិង មូយ ខៃ។ ");
INSERT INTO brb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","តង៉ៃ ហង់អ៊ិន យ៉ាគ់ ឡាបាន់ ឡើ តង៉ា យ៉ាកុប រៀន៖ «ហៃ នែ ម៉ន អៃ លហម ប៊ិច អ៊ឺម ញឹះ អំយួរ មិៗ។ ហន់ហាយ ឡាំង ដើ អៃ ដើ ង៉ាយ ហម៉ើត អន់ជែរ ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","បអើយ យ៉ាគ់ ឡាបាន់ ឡើ ប៊ិច កួន កទ្រី បារ រ៉ា ម៉ុ ណគ ណាង លែអា អោះ ណគ ណាង រ៉ាជែល។ ");
INSERT INTO brb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ណាង លែអា ឡើ ចាគ់ ឌិវ មុះ ម៉ាត់ អ៊ែ ដើ ណាង រ៉ាជែល អន់ណាវ ឡើ ចាគ់ សាំ មុះ ម៉ាត់ ដើម ចាក់ ដៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","យ៉ាក់ យ៉ាកុប ឡើ ងុញ ណាង រ៉ាជែល អ៊ែ ឡើ ត្រណើវ រៀន៖ «អង់ង៉ាយ ញឹះ ហន់ជែរ អៃ អំគូលី ហៃ ប៉ឹះ កម៉ អងុញ កួន កទ្រី ហៃ ណាង រ៉ាជែល អំបើម ទ្រី»។ ");
INSERT INTO brb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","យ៉ាគ់ ឡាបាន់ ឡើ ត្រណើវ រៀន៖ «អៃ អម៉ើត ប៉ាគ់ទឺ អន់អាំ កួន ដើ ហៃ ហំប្លះ អង់អាំ ដើ មែ គែង។ ប៉ាគ់ ពអ៊ែ ម៉ន ហន់គូ ប៊ឹង អៃ ណិះ ឡើយ ឆិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","យ៉ាកុប ឡើ ពពឹត បបើម ដើ យ៉ាគ់ ឡាបាន់ ញឹះ ប៉ឹះ កម៉ បក់ លំដូវ ណាង រ៉ាជែល ហរ៉គ់ ឌុញ អ៊ឺម ឡើ តៃ យ៉ាក់ ឡើ ងុញ ណាង រ៉ាជែល ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ប៊្លី អ៊ែ យ៉ាកុប ឡើ ឡា ហឹ យ៉ាគ់ ឡាបាន់ រៀន៖ «មិះ អើយ អពពឹត បបើម ដើ ហៃ ប៉ឹះ កម៉ ឡើយ ណិះៗ នែ អឡា ហឹ ហៃ ហន់អាំ ណាង រ៉ាជែល អំបើម ទ្រី»។ ");
INSERT INTO brb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","យ៉ាគ់ ឡាបាន់ ឡើ ហាយ លែក ដើ មែ ក្លាង ស៊្រុក ដក់ ញែត ច្រណង់ កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","តគ់ ប៊ឹ អំប៊ឹ យ៉ាគ់ ឡាបាន់ ឡើ ដក់ ឈូន ពឝ៉ី ណាង លែអា ប៊ឹង យ៉ាកុប យ៉ាកុប អំប ឡើ រៀន ណាង រ៉ាជែល ឡើយ អំប្រា ហង់ង៉ាន់ កី ប្រាង។ ");
INSERT INTO brb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(យ៉ាគ់ ឡាបាន់ ឡើ អាំ ក៝ត ណគ ណាង ស៊ីលប៉ា ដក់ ដន់ដុ ណាង លែអា)។ ");
INSERT INTO brb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ស៊ី ប្រាង ងឹប យ៉ាកុប ឡើ តៃ ណាង លែអា ឡើ កី ប៊ឹង ណគ។ អ៊ែ ឡើ ដក់ ម៉ាង ដើ ហឝ៉ៃ បើគ ណគ រៀន៖ «ប៉ិ ឡើ ត្រ យ៉ាគ់ អ ឆើ បើម ដើ អៃ ប៉ាគ់ នែ? អៃ អគូ ពពឹត បបើម ដើ ឆារ ញ៉ន អងុញ ណាង រ៉ាជែល ហវ៉ៃ! ប៉ិ ឡើ ត្រ ឆើ តបូត អៃ ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","យ៉ាគ់ ឡាបាន់ ឡើ ត្រណើវ រៀន៖ «ហឹ ស្រុក ញ៉ា នែ ញ៉ើ ខើយ អ៊ឺម អោះ លំប៊ិច ក្ល អន់នួរ ម៉ុ។ ");
INSERT INTO brb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ហន់គូ ពណុះ ប៉ឹះ តង៉ៃ អន់ដៃ ប៊ឹង ណាង លែអា ប៊្លី អ៊ែ អំប្រយ៉ង់ ប៊ឹង ណាង រ៉ាជែល អន់ណាវ ថលែម ហង់គូ ពពឹត ណាគ់ ប៉ឹះ កម៉ ឡឹះ អន់ណាវ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","យ៉ាកុប ឡើ បើម តាម ប្រម៉ាង ហឝ៉ៃ បើគ ណគ ឡើ ពណុះ ប៉ឹះ តង៉ៃ ប៊ឹង ម៉ុ ណគ។ ប៊្លី អ៊ែ យ៉ាគ់ ឡាបាន់ ឡើ អាំ កួន ណគ ណាង រ៉ាជែល ដើ យ៉ាកុប លំបើម ទ្រី អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(យ៉ាគ់ ឡាបាន់ ឡើ អាំ ក៝ត ណគ ណាង ប៊ីលហា ដក់ ដន់ដុ ណាង រ៉ាជែល)។ ");
INSERT INTO brb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","យ៉ាកុប ឡើ កី ប្រយ ប៊ឹង ណាង រ៉ាជែល អន់ណាវ។ ឡើ ម៉ើត ណាង រ៉ាជែល ជឺរ ឡើ ម៉ើត ណាង លែអា។ ប៊្លី អ៊ែ ឡើ ពពឹត បបើម ណាគ់ ប៉ឹះ កម៉ ឡឹះ ដើ ហឝ៉ៃ បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តៃ យ៉ាកុប ឡើ ម៉ើត អ៊ឺម ណាង លែអា អ៊ែ ឡើ អាំ ណគ លំប៊ិច កួន ដើ ណាង រ៉ាជែល អន់ណាវ ឡើ កន់ដុង។ ");
INSERT INTO brb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","លែអា ឡើ តមែវ អ៊ែ ឡើ អន់ឆិ កួន កឡ។ ណគ ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ តៃ កាន ធុក ញ៉ាក អៃ ណិះៗ នែ ក្ល អៃ លំម៉ើត ឡើយ អៃ»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ “រូប៊ែន”។ ");
INSERT INTO brb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","លែអា ឡើ តមែវ ឡឹះ ឡើ អន់ឆិ កឡ ប៉ាគ់ទឺ។ ណគ ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ដុង ក្ល អៃ តៃ ឡើ ម៉ើត អ៊ឺម អៃ អ៊ែ ឡើ អាំ កួន កឡ ឡឹះ ដើ អៃ»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ “ស៊ីមៀន”។ ");
INSERT INTO brb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ប៊្លី អ៊ែ ឡើ តមែវ ឡឹះ អន់ណាវ ឡើ អន់ឆិ កឡ ប៉ាគ់ទឺ។ អ៊ែ ឡើ ម៉ាង រៀន៖ «មូយ តង នែ ក្ល អៃ លំទែប រែប ឡើយ ប៊ឹង អៃ យ៉ាក់ អពឝ៉ើត កួន កឡ ញឹះ ពែ រ៉ា ឡើយ ប៊ឹង ណគ»។ ញ៉ន អ៊ែ ឡើយ ម៉ើ ជុ ម៉ាត់ កួន ណគ រៀន “លែវី”។ ");
INSERT INTO brb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ប៊្លី អ៊ែ ឡើ តមែវ ឡឹះ អន់ណាវ ឡើ អន់ឆិ កឡ ប៉ាគ់ទឺ។ អ៊ែ ឡើ ម៉ាង រៀន៖ «មូយ តង នែ អំព្រតឹះ ព្រនែ គ្រែដៃ ឡើ ណាគ់ អន់សច»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ រៀន “យូដា”។ ប៊្លី អ៊ែ ឡើ ហយ៉ាង អន់ដៃ។ ");
INSERT INTO brb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ប៊ឹង យ៉ាគ់ រ៉ាជែល ឡើ ណោះ រៀន ចាក់ ណគ តៃ ឡើ ប៊ិច កួន ឡើ ចើះ ដើ ម៉ុ ណគ។ អ៊ែ ឡើ ម៉ាង ដើ ក្ល ណគ យ៉ាកុប រៀន៖ «ហន់អាំ ដើ អៃ អំប៊ិច កួន ដិ អុះ ប៉ាគ់ តៃ អំប៊ិច កួន ណាគ់ ហយ អង់គែត អៃ អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","យ៉ាកុប ឡើ មាំ ទុត ខាក់ ដើ ទ្រី ណគ រ៉ាជែល អ៊ែ ឡើ ត្រណើវ រៀន៖ «អូ អៃ ឞិ អគ្រែដៃ? គ្រែដៃ ហវ៉ៃ ឡើ អាំ អ៊ឺម ហៃ ហប៊ិច កួន!»។ ");
INSERT INTO brb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","រ៉ាជែល ឡើ ម៉ាង រៀន៖ «នែ ក៝ត អៃ ណាង ប៊ីលហា នែ ហន់កី ប៊ឹង ណគ។ ប៊ឹង លំប៊ិច កួន អ៊ែ អៃ អំពែក កួន ណគ ឞាល់ កួន អៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","រ៉ាជែល ឡើ អាំ ណាង ប៊ីលហា ក៝ត ណគ ដើ ក្ល ណគ លំបើម ទ្រី អ៊ែ អំប្រា ក្រណី ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ណាង ប៊ីលហា ឡើ តមែវ ឡើ អន់ឆិ កួន កឡ ប៊ឹង យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ប៊ឹង អ៊ែ រ៉ាជែល ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ តាត់ស៊ិន ដើ អៃ ត្រ ម៉ាត់ ម៉ាត ឡើ ចង់ហៀង អ្រឡា អៃ អ៊ែ ឡើ អាំ កួន កឡ ដើ អៃ»។ ញ៉ន អ៊ែ ឡើយ ឡើ ជុ ម៉ាត់ កួន ណគ “ដាន់”។ ");
INSERT INTO brb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ប៊្លី អ៊ែ ណាង ប៊ីលហា ក៝ត រ៉ាជែល ឡើ ប៊ិច ឡឹះ កួន ប៊ឹង យ៉ាកុប ឡើ កឡ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","រ៉ាជែល ឡើ ម៉ាង រៀន៖ «អៃ អព្រឆាំង ដើ ម៉ុ អៃ ទុត ខាក់ ឆា ដើ ដូវ តៃ ទ្រូង អៃ»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ អ៊ែ រៀន “នែបថាលី”។ ");
INSERT INTO brb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","តគ់ លែអា ឡើ ណោះ រៀន ចាក់ ណគ ឡើ ហយ៉ាង អន់ដៃ អ៊ែ ឡើ អាំ ក៝ត ណគ ណាង ស៊ីលប៉ា ដើ យ៉ាកុប លំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ណាង ស៊ីលប៉ា ក៝ត លែអា ឡើ ប៊ិច កួន កឡ មូយ ប៊ឹង យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","លែអា ឡើ ម៉ាង រៀន៖ «អឞ៊ុន ឡើយ អៃ នែ!»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ រៀន “ឝ៉ាត”។ ");
INSERT INTO brb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ណាង ស៊ីលប៉ា ក៝ត លែអា ឡើ ប៊ិច កួន កឡ មូយ អន់ណាវ ប៊ឹង យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","លែអា ឡើ ម៉ាង រៀន៖ «អៃ អញឹម ក្លើម ក្លាក ឡើយ! ណិះៗ នែ លែក ដើ មែ ម៉ិ យូ មន់ម៉ាង ដើ អៃ រៀន អញឹម ក្លើម ក្លាក ឡើយ!»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ “អាស៊ែរ”។ ");
INSERT INTO brb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","តង៉ៃ ហង់អ៊ិន ញ៉ាម កនៀវ ចិះ សាលី រូប៊ែន កួន លែអា ឡើ ដក់ ហឹ មឺរ អ៊ែ ឡើ តៃ ឆ្រាវ ប៊ិច កួន ឡើ ប៉ិះ ជឹ តៀត អាំ ដើ មែគ ណគ។ ប៊ឹង អ៊ែ ណាង រ៉ាជែល ឡើ ឡា ហឹ ម៉ុ ណគ រៀន៖ «ហំព្រណាក ឆ្រាវ ប៊ិច កួន ណគ់ កួន ហៃ ឡើ ប៉ិះ អន់ឌូ ដើ អៃ ដិ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","អ៊ែ លែអា ឡើ ត្រណើវ រៀន៖ «ហៃ ហចក់ ក្ល អៃ ឡើយ កិ ឞិ ហណោះ? ប៉ិ ឡើ ត្រ ណាគ់ ហងុញ ចក់ ឆ្រាវ កួន អៃ អន់ណាវ?»។ រ៉ាជែល ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ ពអ៊ែ មាំង នែ អំប៉្រៃ ណគ លន់កី ប៊ឹង ហៃ ឆិ ពតាង អន់វ៉ាក់ ឆ្រាវ កួន ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","តគ់ ឡើ អំប៊ឹ យ៉ាកុប ឡើ ជឹ តើម ប៊ឹង មឺរ អ៊ែ លែអា ឡើ ដក់ យ៉ាវ ប្រយ ណគ ឡើ ម៉ាង រៀន៖ «អើយ មាំង នែ ឡើ ត្រ ហន់កី ប៊ឹង អៃ យ៉ឹ យ៉ាក់ អជែរ ដើ ឆ្រាវ កួន អៃ ឡើយ ហឹ រ៉ាជែល»។ អ៊ែ យ៉ាកុប ឡើ កី ប្រយ មាំង អ៊ែ ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","គ្រែដៃ ឡើ ដុង អ្រឡា លែអា អ៊ែ ឡើ តមែវ ឡើ អន់ឆិ កួន កឡ ឡឹះ សើង ឡង់ ដើ ណិះ ឡើយ ប៊ឹង យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ណគ ឡើ រៀន៖ «គ្រែដៃ ឡើ អាំ ចនែរ ដើ អៃ ញ៉ន អអាំ ក៝ត អៃ ដើ ក្ល អៃ»។ អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ រៀន “អ៊ីសាខារ” ");
INSERT INTO brb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","លែអា ឡើ តមែវ ឡឹះ អន់ណាវ អ៊ែ ឡើ អន់ឆិ កួន កឡ ត្រូវ ឡង់ ដណិះ ឡើយ ប៊ឹង យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","លែអា ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ អាំ អន់ណាំ ដើ អៃ ញឹះ ទុត ចាគ់ ណិះៗ នែ ក្ល អៃ លំអៀល ម៉ាគ់ ឡើយ អៃ យ៉ាក់ អប៊ិច កួន កឡ ត្រូវ រ៉ា ប៊ឹង ណគ»។ ឡើ ជុ ម៉ាត់ កួន ណគ “សាប់យូឡូន”។ ");
INSERT INTO brb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ប៊្លី អ៊ែ ឡើ ប៊ិច កួន កទ្រី អន់ណាវ ឡើ ជុ ម៉ាត់ ណគ “ឌីណា”។ ");
INSERT INTO brb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","គ្រែដៃ ឡើ វឺញ អ៊ឺម រ៉ាជែល ណាគ់ ឡើ ដុង អ្រឡា ណគ ឡើ អាំ ដើ ណគ ប៊ិច កួន។ ");
INSERT INTO brb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","អ៊ែ ឡើ តមែវ ឡើ អន់ឆិ កួន កឡ មូយ។ ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ តប៉ាត់ កម៉ាវ យួរ អៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ឡើ ជុ ម៉ាត់ កួន ណគ “យ៉ូស៊ែប” យ៉ាក់ ឡើ ម៉ាង រៀន៖ «ឡា គ្រែដៃ ហណាគ់ អនសច ហំអាំ ណាគ់ មូយ អន់ណាវ កួន កឡ ដើ អៃ!»។ ");
INSERT INTO brb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ប៊្លី រ៉ាជែល ឡើ ពឝ៉ើត ឡង់ យ៉ូស៊ែប ឡើយ យ៉ាកុប ឡើ ឡា ហឹ ហឝ៉ៃ បើគ ណគ យ៉ាគ់ ឡាបាន់ រៀន៖ «ឡា យ៉ាគ់ អ អើយ អឡា ជឹ ហឹ ស្រ៊ុក ប្រិះ អៃ កឡឹ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","អឡា កួន ទ្រី អៃ មន់ជឹ តូយ ប៉ាគ់ទឺ។ អៃ អគូ ពពឹត ដើ ឆារ ញ៉ន ដើ អំប្រា នែ ឡើយ។ ឆើ ណោះ ឡើយ អកនូយ ឌី ពពឹត បបើម ដើ ឆារ ឞាល់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","យ៉ាគ់ ឡាបាន់ ឡើ ត្រណើវ រៀន៖ «អឡា ហឹ ឆារ ឆន់ពន់ឋូយ តាម ក្លើម អៃ ញ៉ង ឆន់ជឹ អន់ដិះ។ អៃ អឆឡាំង អណោះ ហឡាក់ ញ៉ន ដើ ឆារ នែ ឡើយ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ អាំ កាន ចាគ់ ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ឆន់ហាយ ដើ អៃ ឡាំង ឞាល់ ង៉ាយ ឆើ ម៉ើត អន់ជែរ ឆារ អ៊ែ អន់ណោះ អាំ»។ ");
INSERT INTO brb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «ឆារ ឆើ ណោះ ឡើយ រៀន អៃ អពពឹត បបើម ដើ ឆារ ប៉ាគ់ ង៉ាយ ដើម អពែក បណាន់ ឆារ ទុត ចាគ់ ប៉ាគ់ ង៉ាយ ឆើ តៃ។ ");
INSERT INTO brb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ទឹង អៃ តៃ ដាន់ អដក់ គូ អំម៉ឹះ ហឹ វែ ឆារ ឆើ ប៊ិច ពត្រូវ កើយៗ ណិះៗ នែ ឡើ ស៊ឺក តាក ទុត អើន ឞាល់ នែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ អាំ ដើ ឆារ ត្រំ ពនឹត អៃ។ ដមិញ អន់ដូវ ពពឹត បបើម ចៀម កួន ទ្រី អៃ កឡឹ អន់ណាវ?»។ ");
INSERT INTO brb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","យ៉ាគ់ ឡាបាន់ ឡើ តង៉ា ណគ រៀន៖ «អង់ង៉ាយ ដឹះ ឆងុញ អង់អាំ ដើ ឆារ?»។ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «សណូវ អ៊ឺម ញឹះ ឆន់អាំ អង់ង៉ាយៗ ដើ អៃ ប៉ាគ់ ឆន់ផម តាម អ្រឡា អៃ អ៊ែ អំពែក ឝ្លាំង បប៊ែ ចៀម ឆារ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","អឡា ហឹ ឆារ តង៉ៃ នែ អៃ អន់ដក់ ហន់នៀប ឝ្លាំង តូច ដើ បប៊ែ ចៀម ប្រនិច ឆារ អង់កះ បប៊ែ ចៀម តូច ដើ អ៊ែ ណគ់ ម៉ើ ប្រូងៗ តលុ អន់ទុ ដើម កួន ចៀម ក្រាំៗ អំកះ តើម ប៊ឹង បប៊ែ ចៀម ឆារ។ អឡា តូច ដើ បប៊ែ ចៀម ហង់អ៊ែ ឡើយ ឆន់ជែរ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ប៉ាគ់ ពអ៊ែ ហឹ ងឺរ តគ់ ប៊ឹង ឆន់ដក់ ឝ្លាំង បណាន់ ណគ់ ឆជែរ អៃ អ៊ែ ឆន់ណោះ រៀន អៃ អបនឹះ ទឹង ត្រ។ ប៉ាគ់ ឆន់តៃ លំប៊ិច បណាន់ តៃ លំប្រូងៗ លឺ លំតលុ អន់ទុ ទឹង បូវ បប៊ែ អៃ ដើម កួន ចៀម តៃ លំក្រាំៗ ទឹង បូវ ចៀម អៃ ប៉ាគ់ ពអ៊ែ អ៊ែ ឆន់ណោះ អៃ អន់តទូង»។ ");
INSERT INTO brb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","យ៉ាគ់ ឡាបាន់ ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ ពអ៊ិន ដូវ ប៉ាគ់ទឺ បើម តាម ប្រម៉ាង ឆារ ឆិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ហាក់ តង៉ៃ អន់ទឺ យ៉ាគ់ ឡាបាន់ ឡើ កះ ណគ់ បប៊ែ សារ់សារ ឡើ ប៊ិច សក់ ហន់ឆៀក ប្លាក តលុ អន់ទុ ដើម បប៊ែ យូ ប្រូងៗ តលុ អន់ទុ លែក ដើ បប៊ែ ម៉ើ ប៊ិច សក់ បកៗ សំយ៉ះ កិៗ កតាម ណាគ់ ឡើ កះ ពញឺះ ប៉ាគ់ទឺ ដឹប លែក ដើ កួន ចៀម ណគ់ ម៉ើ ប៊ិច សក់ ក្រាំៗ ឡើ កះ ដិៗ ឡើ អាំ ដើ កួន កឡ ណគ កឡឹ មន់ពែក។ ");
INSERT INTO brb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ប៊្លី អ៊ែ ម៉ើ វីះ ចង៉ាយៗ តើម ប៊ឹង យ៉ាកុប ពែ តង៉ៃ ដក់។ អ៊ែ ដើ យ៉ាកុប អន់ណាវ ឡើ បយ៉ា បប៊ែ ចៀម ហឝ៉ៃ បើគ ណគ ណគ់ ឡើ ជុ ដើ ណគ លំឝ្លាំង។ ");
INSERT INTO brb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","យ៉ាកុប ឡើ កដោះ កៀង ឡង ពែ នែវ  ឡើ ប្លាត់ អំប្លាត់ ប៉ក ហំបក អ៊ែ កៀង ឡង ឡើ តង់ប្លាត់ អយូង បក។ ");
INSERT INTO brb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ប៊្លី អ៊ែ ឡើ ចក់ កៀង ឡង តងប្លាត់ នែ ដក់ ជុ ទឹង ក្រឡោះ ប៊ឹង ងឺរ បប៊ែ ចៀម បក់ មន់តៃ ប៊ឹង មន់ញែត ដាក ទឹង ក្រឡោះ។ យ៉ាក់ ម៉ើ ចន់ដ្រយ ប៊ឹង ឞន ញែត ដាក អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","អ៊ែ តគ់ បប៊ែ ចៀម ម៉ើ ចន់ដ្រយ ប៊ឹង កៀង ឡង តងប្លាត់ កួន មែ ឡើ តូយ ហន់ឆៀក ប្លាក ប្រូងៗ ដើម តលុ អន់ទុ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","អ៊ែ ណគ់ កួន ចៀម ឡើ ក្រម៉ូយ តូយ យ៉ាកុប ឡើ ជុ ដិៗ ប្រយ។ ណគ់ បប៊ែ ចៀម គែង អ៊ែ ឡើ ជុ ចណារ់ ងឺរ បប៊ែ ចៀម យ៉ាគ់ ឡាបាន់ ណគ់ ឡើ ហន់ឆៀក ប្លាក ដើម ក្រាំៗ។ ឡើ បើម ប៉ាគ់ នែ ឡើយ អ៊ែ ឡើ ពឝ៉ើត បប៊ែ ចៀម មូយ បូវ ដើ ណគ កឡឹ ឡើ ជុ អ៊ឺម អរែង ប៊ឹង បប៊ែ ចៀម ហឝ៉ៃ បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ប៊ឹង យូ ទិះៗ បិញៗ ម៉ើ ដក់ ចន់ដ្រយ អ៊ែ យ៉ាកុប ឡើ ជុ កៀង ឡង តងប្លាត់ ទឹង ក្រឡោះ អាំ មន់តៃ បក់ ណគ់ មែ មន់ចន់ដ្រយ ប៊ឹង អ៊ែ កួន មែ មន់ក្រម៉ូយ តូយ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ហាក់ ប៉ាគ់ យូ ស្រាៗ ម៉ើ ដក់ ចន់ដ្រយ ឡើ ជុ អ៊ឺម កៀង ឡង តងប្លាត់។ ឡើ បើម ពអ៊ែ អ៊ែ បប៊ែ ចៀម ណគ់ ស្រាៗ ឡើ ត្រ បប៊ែ ចៀម យ៉ាគ់ ឡាបាន់ ណគ់ ទិះៗ បិញៗ ឡើ ត្រ បប៊ែ ចៀម ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","តើម ប៊ឹង អ៊ែ យ៉ាកុប ឡើ ប្រនិច ហ៊ែង ចាំ អើន។ ឡើ ប៊ិច ក៝ត កទ្រី ដើម កឡ ឡើ ប៊ិច បប៊ែ ចៀម ទុត អើន ដឹប ឡើ ប៊ិច អូត ដើម សិះ លៀ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","យ៉ាគ់ យ៉ាកុប ឡើ ដុង មែ ហឝ៉ៃ អ៊ូគ អា ណគ កួន យ៉ាគ់ ឡាបាន់ ម៉ើ ចជែ ចំ ណគ រៀន៖ «យ៉ាកុប ឡើ ចក់ លែក ដើ ប្រនិច ប្រណាក់ តើម ប៊ឹង បើគ ង៉ាយ ញ៉ន ដើ ប្រនិច បើគ ង៉ាយ ឡើយ អ៊ែ ឡើ ប៊ិច បាក់ ទុត អើន ឞាល់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","យ៉ាគ់ យ៉ាកុប ឡើ តៃ ហឝ៉ៃ បើគ ណគ ទឹង យ៉ាវ ឡើ ឝ្លាំង ហឹ ណគ ប៉ាគ់ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហាយ ដើ យ៉ាកុប រៀន៖ «មិញ ហន់ជឹ ហឹ ប៊្រី ដាក ម៉ិ បើគ ម៉ិ យ៉ាគ់ ហៃ ហន់ជឹ ដាំង ព្រឝ៉ើត យូ ហៃ អន់ណាវ ណាគ់ អន់លវាំង ឝ្លាំង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","យ៉ាគ់ យ៉ាកុប ឡើ ប៉្រៃ មែ ដក់ កឡូវ ទ្រី ណគ យ៉ាគ់ រ៉ាជែល អំប្រា យ៉ាគ់ លែអា ដក់ ហឹ ត្រិញ ណគ ឡើ បយ៉ា បប៊ែ ចៀម ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","យ៉ាគ់ យ៉ាកុប ឡើ ម៉ាង ហឹ អំប្រា ទ្រី ណគ រៀន៖ «អតៃ យ៉ាគ់ អ ទឹង យ៉ាវ វ៉ើ ឝ្លាំង ហឹ អៃ ប៉ាគ់ រីវ។ ហាក់ គ្រែដៃ ឡើ កន់ដ្រាគ់ បើគ អៃ ណាគ់ ឡើ លវាំង ឝ្លាំង អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","សប្រា ណោះ ឡើយ អខំ ពពឹត បបើម ដើ បើគ សប្រា ញឹះ លែក ដើ ពន់ដ្រិញ ពន់ដ្រួញ ");
INSERT INTO brb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ហាក់ បើគ សប្រា វ៉ើ ពលិះ កាន ជែរ អៃ មូយ តង ប៉ាគ់ អ៊ែៗ ញឹះ ជិត តង ឡើយ វ៉ើ តបូត អៃ។ ហាក់ គ្រែដៃ តៃ ឡើ អាំ អ៊ឺម បើគ សប្រា វន់ឡូប ដូប អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ប៊ឹង បើគ សប្រា វ៉ើ រៀន បប៊ែ ចៀម ណគ់ ឡើ តម៉ាត់ តលុ អន់ទុ វន់ជែរ អៃ អ៊ែ បប៊ែ ចៀម លែក អ៊ែ ម៉ើ ពឝ៉ើត កួន ម៉ាត់តូវ តលុ អន់ទុ ម៉ាត់ ម៉ាត។ អ៊ែ ប៊ឹង វ៉ើ ម៉ាង រៀន ណគ់ ហន់ឆៀក ប្លាក វន់ជែរ អៃ អ៊ែ បប៊ែ ចៀម លែក អ៊ែ ម៉ើ ពឝ៉ើត កួន ម៉ាត់តូវ ហន់ឆៀក ប្លាក ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ប៉ាគ់ អ៊ែ ឡើយ គ្រែដៃ ឡើ ចក់ បណាន់ តើម ប៊ឹង បើគ សប្រា ឡើ អាំ ដើ អៃ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«តគ់ ញ៉ាម បប៊ែ ចៀម ម៉ើ ចន់ដ្រយ អពកី តៃ បប៊ែ ចៀម សារ ម៉ើ ឆ្រយ យូ អ៊ែ ម៉ឹត ម៉ើ តម៉ាត់ លែក អិះ អន់នឺ ហន់ឆៀក ប្លាក អន់នឺ តលុ អន់ទុ អន់នឺ អន់ណាវ ប្រូងៗ។ ");
INSERT INTO brb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","អ៊ែ ឞាវ គ្រែដៃ ឡើ កឡូវ អៃ ទឹង អពកី “អើយ យ៉ាកុប”។ អ៊ែ អត្រណើវ រៀន “ង៉ាយ!”។ ");
INSERT INTO brb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ឞាវ គ្រែដៃ ឡើ ម៉ាង រៀន “តគ់ ហន់ឝ្លាំង លែក ដើ បប៊ែ ចៀម សារៗ ម៉ើ ចន់ដ្រយ ម៉ឹត តូវ ម៉ើ តម៉ាត់ លែក អិះ អន់នឺ ហន់ឆៀក ប្លាក អន់នឺ ប្រូងៗ អន់នឺ អន់ណាវ តលុ អន់ទុ លែក អិះ។ យ៉ាក់ អតៃ ឡើយ លែក ដើ កាន ឡាបាន់ ឡើ បើម ដើ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","អៃ អគ្រែដៃ អពដៃ ចាក់ ដើ ហៃ ហឹ ប៊ែតអ៊ែល  ប៊ឹង ឞន ហៃ ហបយ៉ុង តម៉ ហ៊ែង ពុក ពឺង អ៊ែ ដើម ហខណាត តប៉ឹន ចាក់ ដើ អៃ ដិ។ ណិះៗ នែ ហំវីះ តើម ប៊ឹង ស្រុក អន់នែ ហន់ជឹ ដាំង ស្រុក កណើត ហៃ កឡឹ ហំមិញ”»។ ");
INSERT INTO brb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","យ៉ាគ់ រ៉ាជែល អំប្រា យ៉ាគ់ លែអា អំប្រា ត្រណើវ ក្ល អំប្រា រៀន៖ «ញឺ អាត ញន់ដូវ យ៉ាវ មូន ប្រនិច បើគ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","បើគ ឡើ ជុ ញឺ ឡើ បើម ប៉ាគ់ មែ គែង យ៉ាក់ ណគ ឡើ ហំពួត ឡើយ ញឺ ដើម លៀន ឡើ ដូវ ដើ ញឺ ច្រណង់ ឡើ តប៉ាត់ លែក តាក់ ឡឹះ អន់ណាវ! ");
INSERT INTO brb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","លែក ដើ ប្រនិច បើគ គ្រែដៃ ឡើ សួរ ឡើយ ណិះៗ នែ ឡើ ត្រ ប្រនិច ញឺ អន់ណាវ ដើម ប្រនិច កួន ចូវ ង៉ាយ ដិ។ ប៉ាគ់ ពអ៊ែ ហំបើម តាម ប្រម៉ាង គ្រែដៃ ឡើ ហាយ ដើ ហៃ លែក អិះ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ឌឹក ឆុង ប្រយ អ៊ែ ឡើ ប៊្រឹក ពឈិះ កួន ទ្រី ណគ ពឺង កណង អូត។ ");
INSERT INTO brb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ឡើ ឞង លែក ដើ បណាន់ ដើម ឡើ ចក់ លែក ប្រនិច ប្រណាក់ ណគ ឡើ ដូវ តើម ប៊ឹង ស្រុក មែសូប៉ូតាមី ឡើ ជឹ តៀត អាំ លែក។ ឡើ ជឹ វឹញ ហឹ បើគ ណគ អ៊ីសាគ់ ហឹ ស្រុក កាណាន អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","តង៉ៃ ម៉ើ រន់ឋាប់ យ៉ាគ់ ឡាបាន់ ឡើ គូ អ៊ឺម ប៊ឹង អ៊ែ ឡើ ដក់ កាត់ សក់ ចៀម ឡើយ។ អ៊ែ យ៉ាគ់ រ៉ាជែល ឡើ ចក់ ម៉ច ប្រាគ់ ខាំលុត បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ប៊្លី អ៊ែ យ៉ាកុប ឡើ ជឹ រ៉ូះ តទូង ម៉ច ហឝ៉ៃ បើគ ណគ យ៉ាគ់ ឡាបាន់ សុនសាត អារ៉ាម ញឹះ តៃ ឡើ ហាយ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ឡើ វីះ ជឹ តៀត លែក ដើ មែ ទឹង ក្រាន ណគ ដើម រ៉ាះ អំបាះ ណគ លែក តាក់ ឡើ ក្លង ដណៃ អើប្រាត ឡើ កន់ចុង ដក់ ហឹ ឞន ចន់ឌូ ឝ៉ាឡាត។ ");
INSERT INTO brb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","តគ់ តង៉ៃ ទី ពែ ម៉ើ ហាយ ដើ យ៉ាគ់ ឡាបាន់ រៀន យ៉ាកុប ឡើ ជឹ រ៉ូះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","យ៉ាគ់ ឡាបាន់ ឡើ ច្រា មែ អំម៉ោះ អោះ ព្រឝ៉ើត យូ ណគ ដក់ យ៉ាវ ឆ្រួយ យ៉ាគ់ យ៉ាកុប។ ណគ ឡើ ដក់ តៃ ទ្រូង ញឹះ ប៉ឹះ តង៉ៃ អ៊ែ ឡើ ដាន់ មែ ហឹ ឞន ចន់ឌូ ឝ៉ាឡាត។ ");
INSERT INTO brb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","មាំង អ៊ែ គ្រែដៃ ឡើ បើម អាំ យ៉ាគ់ ឡាបាន់ សុនសាត អារ៉ាម ឡើ ពកី តៃ ណគ ឡើ ទឺះ ថាន់ រៀន៖ «អើយ ឡាបាន់ ហន់លវាំង ចាក់ ហៃ យ៉ឹ ញ៉ង ហតព្រឹង អ៊ឺម យ៉ាគ់ យ៉ាកុប ព្រសាវ ហៃ សំយ៉ះ ហំម៉ាង ញឹម លឺ តៃ ញឹម តមឹង»។ ");
INSERT INTO brb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","យ៉ាគ់ ឡាបាន់ ឡើ ដាន់ ប្រយ យ៉ាគ់ យ៉ាកុប ទឹង ឞន ចន់ឌូ ឝ៉ាឡាត។ យ៉ាគ់ យ៉ាកុប ឡើ បើម កទូប ហឹ ឞន ចន់ឌូ ឝ៉ាឡាត អ៊ែ ដើ យ៉ាគ់ ឡាបាន់ ដើម អំម៉ោះ អោះ ព្រឝ៉ើត យូ ណគ ម៉ើ បើម ប៉ាគ់ទឺ កទូប ទឹង ឞន ចន់ឌូ ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","យ៉ាគ់ ឡាបាន់ ឡើ ដក់ ម៉ាង ដើ យ៉ាកុប រៀន៖ «ឆើ បើម ង៉ាយ ប៉ាគ់ នែ? ប៉ិ ឡើ ត្រ ញឹះ ឆើ វីះ ម៉ច តើម ប៊ឹង អៃ ឆើ ជឹ តៀត ដ្រូក កួន កទ្រី អៃ ញឹះ ឞាល់ ម៉ើ ប្រណើម ក្រណោះ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ប៉ិ ឡើ ត្រ ឆើ ជឹ រ៉ូះ តទូង ម៉ច អៃ? ឆើ អំម៉គ់ ដើ អៃ ញឹះ តៃ អណោះ។ ប៉ាគ់ អន់ណោះ វែ វន់ជឹ ណាគ់ អន់ញែត បយឹ វែ រ៉គ់សំ ឆំតក ក្រស៊ូ សារ រ៉ិះ កតិង រ៉ិង ដ្រ ច្រៀង រាំ អន់ដៃ អ៊ែ វន់ជឹ។ ");
INSERT INTO brb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ញឹះ តៃ ឆអាំ អំមុក មុញ កួន កទ្រី ដើម ចូវ អៃ អន់ដៃ ឆើ បើម ប៉ាគ់ នែ ឆើ អន់ឌ្រូយ ម៉ាត់ ម៉ាត ឡើយ ឆារ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","អៃ អប៊ិច អាតណាត អំពថូត វែ ដូវ ពញ៉ង គ្រែដៃ ឡើ កន់ដ្រាគ់ បើគ ឆារ ឡើ ថាន់ អៃ មាំង អ៊ិន រៀន “អើយ ឡាបាន់ ហន់លវាំង ចាក់ ហៃ យ៉ឹ ញ៉ង ហតព្រឹង អ៊ឺម ព្រសាវ ហៃ យ៉ាគ់ យ៉ាកុប សំយ៉ះ ហំម៉ាង ញឹម លឺ តៃ ញឹម តមឹង”។ ");
INSERT INTO brb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ណិះៗ នែ ប៉ាគ់ ឆើ រៀន ឆជឹ ញ៉ន ដើ អង់ងឹះ ស៊្រុក ប្រិះ បើគ ឆារ បើម ង៉ាយ អ៊ឺម ពញ៉ង ឆើ ជឹ តៀត ម៉ច បើម ង៉ាយ ដើ ប្រាគ់ ខាំលុត អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ ហឝ៉ៃ បើគ ណគ រៀន៖ «អៃ អជឹ រ៉ូះ ប៉ាគ់ នែ ញ៉ន អឌូង ឆន់សួរ កួន ឆារ។ ");
INSERT INTO brb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ហាក់ ប៊ឹង ឆន់សាត ខាំលុត ឆារ ប៉ាគ់ ឆន់តៃ ហឹ មែ ង៉ាយ មែ អ៊ែ មន់ត្រ គែត ឡើយ។ ឆន់សាត ដឹះ ទឹង រ៉ាះ អៃ នែ លែក ដើ មែ អំម៉ោះ អោះ ព្រឝ៉ើត យូ បា មន់កឡា តៃ ណគ់ អង់ង៉ាយ ឆន់តៃ ឡើ ត្រ រ៉ាះ ឆារ ឆន់សួរ ប្រយ»។ យ៉ាគ់ យ៉ាកុប តៃ ឡើ ណោះ អ៊ឺម ទ្រី ណគ រ៉ាជែល ឡើ ចក់ ម៉ច ប្រាគ់ ខាំលុត។ ");
INSERT INTO brb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","យ៉ាគ់ ឡាបាន់ ឡើ មឹត ហឹ កទូប យ៉ាគ់ យ៉ាកុប កទូប យ៉ាគ់ លែអា ដើម កទូប អំប្រា ក៝ត កទ្រី អំប្រា ណាគ់ តៃ ឡើ តៃ អ៊ឺម។ អ៊ែ ឡើ ញឺះ តើម ប៊ឹង កទូប យ៉ាគ់ លែអា ឡើ ដក់ មឹត ហឹ កទូប យ៉ាគ់ រ៉ាជែល។ ");
INSERT INTO brb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","យ៉ាគ់ រ៉ាជែល ឡើ ចក់ ខាំលុត បើគ ណគ អ៊ែ ឡើ ជុ កដក ទឹង កនុង អ៊្យែង អូត អ៊ែ ឡើ ដ្រូម ពឺង អ៊ែ។ យ៉ាគ់ ឡាបាន់ ឡើ សាត លែក ដើ កទូប ណាគ់ តៃ ឡើ តៃ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","យ៉ាគ់ រ៉ាជែល ឡើ ហាយ ដើ បើគ ណគ រៀន៖ «ឡា បើគ ញ៉ង ហមាំ អ៊ឺម ដើ អៃ ដូវ អឹ អៃ អ៊ិន អន់ឌឹក យ៉ាក់ អតៃ ចាក់ កទ្រី»។ យ៉ាគ់ ឡាបាន់ សាវ ឡើ សាត ណាគ់ តៃ ឡើ តៃ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","យ៉ាគ់ យ៉ាកុប ឡើ មាំ ទុត ខាក់ ដើ ហឝ៉ៃ បើគ ណគ អ៊ែ ឡើ ច្រម៉ាន រៀន៖ «អយូច អង់ង៉ាយ អឞាប អង់ង៉ាយ ហឹ ឆារ អ៊ែ ឆើ ខំ ឆ្រួយ អៃ ឞាល់ នែ? ");
INSERT INTO brb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ប៊ឹង ឆើ សាត ឆឆិក លឡិក លែក ដើ រ៉ាះ អំបាះ អៃ នែ អង់ង៉ាយ ដិ ឆើ តៃ ឡើ ត្រ រ៉ាះ តើម ប៊ឹង ហន់ណាម ឆារ? ឆន់ពដៃ ឡាំង ហឹ ងឺរ អំម៉ោះ អោះ ព្រឝ៉ើត យូ បា អ៊ែ បូវ ឆារ ដើម បូវ អៃ មន់តៃ ប៉ាគ់ទឺ បក់ អាំ មែ មន់ចជែ ប៉ូរ តាត់ កឍី ប្លះ បា។ ");
INSERT INTO brb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","លែក បារ ជិត កម៉ អគូ ប៊ឹង ឆារ ចៀម យូ លឺ បប៊ែ យូ ឆារ ញឹះ តៃ ប៊ិច មូយ មន់ហ្រលឹង សំយ៉ះ បប៊ែ សារ ចៀម សារ តៃ ប៊ិច អន់ចក់ ចា អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ប៊ឹះ បប៊ែ ចៀម ណគ់ ពត្រូវ ប៊្រី ម៉ើ កាប់ ចា ណាគ់ តៃ អឈូន អ៊ឺម ហឹ ឆារ អធែន ប្រយ។ អ៊ែ ប៉ាគ់ ប៊ិច មែ ម៉ើ តទូង បណាន់ តង៉ៃ តមឹង មាំងៗ តមឹង ណាគ់ ឆើ ប៉្រៃ អៃ អធែន តូច អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","អខំ ពែក ពត្រូវ ឆារ ឞាល់ អ៊ែ តង៉ៃ អដុង មាំងៗ អដុង ឝ៉ អហង់ង៉ាន់ កី តៃ លិប។ ");
INSERT INTO brb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","អគូ ដើ ឆារ លែក បារ ជិត កម៉ ឡើយ អគូ ពពឹត បបើម ដើ ឆារ ជិត ពួន កម៉ បក់ អន់ដូវ កួន ឆារ លែក បារ អបើម ទ្រី អ៊ែ ណគ់ ត្រូវ កម៉ អន់ណាវ អគូ បក់ អន់ដូវ បប៊ែ ចៀម តើម ប៊ឹង ឆារ។ ហាក់ ឆារ ឆើ ពលិះ ពឡាក់ ឆជែរ អៃ ញឹះ ជិត តង ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","គ្រែដៃ ឡើ កន់ដ្រាគ់ យ៉ាគ់ អាប្រាហាំ យ៉ាគ់ អ អៃ ឡើ ត្រ គ្រែដៃ ណគ់ បើគ អៃ អ៊ីសាគ់ ឡើ អៀល បឹះ ប៉ាគ់ តៃ លំប៉ូរ អៃ នែ អាត ឆន់អាំ អៃ អន់ជឹ ទី មិៗ។ ហាក់ គ្រែដៃ ឡើ តៃ ឡើយ អៃ អធុក ញ៉ាក ដើម អពពឹត សាវបះ ប៊ុន ញ៉ន អ៊ែ ឡើយ មាំង អ៊ិន គ្រែដៃ ឡើ ហាយ ដើ ឆារ ឡើ ចក់ តៃ ទ្រូង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","យ៉ាគ់ ឡាបាន់ ឡើ ត្រណើវ ម៉ាង យ៉ាគ់ យ៉ាកុប រៀន៖ «លែក អំប្រា កទ្រី នែ ម៉ាត់តូវ កួន អៃ កួន ឆារ នែ ម៉ាត់តូវ ចូវ អៃ លែក ដើ បូវ បប៊ែ ចៀម នែ ម៉ាត់តូវ បប៊ែ ចៀម អៃ ណគ់ អង់ង៉ាយៗ ឆារ ឆតៃ ប៊ឹង នែ ម៉ាត់តូវ រ៉ាះ អៃ ប៉ាគ់ទឺ ហាក់ តើម ប៊ឹង តង៉ៃ នែ បក់ យ៉ាវ អំហវីវ ឝ្លាំង ហឹ មែ កួន ចូវ អៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ប៉ាគ់ ពអ៊ែ ណិះៗ នែ បន់ត្រ ខណាត ហំពែម រែម រ៉គ់ ប្លះ បា ដើម ប៊ិច មែ កឡា តៃ ហឡាក់ ប្លះ បា ដិ។ » ");
INSERT INTO brb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ចក់ តម៉ ឡើ បយ៉ុង បើម ឡាក់។ ");
INSERT INTO brb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ដើម ឡើ ប៉្រៃ មែ អំម៉ោះ អោះ ព្រឝ៉ើត យូ ណគ ដក់ រ៉ើះ តម៉។ អ៊ែ ម៉ើ រ៉ើះ ប្រយ តម៉ ម៉ើ ប៊ូក មូយ ប្រនូក ប៊្លី អ៊ែ ម៉ើ ចង់ ចា ដៀក អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","យ៉ាគ់ ឡាបាន់ ឡើ ជុ ប្រនូក អ៊ែ រៀន “យែឝ៉ារ សាហាឌូថា”។ អ៊ែ ដើ យ៉ាកុប ឡើ ជុ ឞន ហង់អ៊ែ រៀន “ឝ៉ាលែត” អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","យ៉ាគ់ ឡាបាន់ ឡើ ម៉ាង រៀន៖ «តង៉ៃ នែ បា នែ បើ ប៊ូក តម៉ បក់ បន់កាំ កាន បា បើ ខណាត ហំពែម រែម រ៉គ់ ប្លះ បា!» ញ៉ន នែ ឡើយ អ៊ែ ម៉ើ ជុ ប្រនូក តម៉ នែ រៀន «ឝ៉ាលែត»។ ");
INSERT INTO brb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","មែ ម៉ើ ជុ ម៉ាត់ ប្រនូក តម៉ អ៊ែ រៀន «មីះប៉ា» ដិ ញ៉ន យ៉ាគ់ ឡាបាន់ ឡើ ម៉ាង រៀន៖ «គ្រែដៃ ឡើ ណាគ់ អន់សច លំអន់ឆយ ឝ្លាំង ប្លះ បា តគ់ បន់គូ ចង៉ាយ ដិ អន់ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","អ៊ែ ឡើ ម៉ាង ហឹ យ៉ាកុប រៀន៖ «ប៉ាគ់ ឆន់បើម តៃ ចាគ់ ដើ កួន អៃ លឺ ឆន់ចក់ ឡឹះ ទ្រី ឆន់លវាំង យ៉ឹ! សំ តៃ ប៊ិច មែ ង៉ាយ កតាម មន់កឡា តៃ ប្លះ បា ណាគ់ គ្រែដៃ លំកឡា តៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","យ៉ាគ់ ឡាបាន់ ឡើ ម៉ាង ឡឹះ រៀន៖ «ឆន់ឝ្លាំង យ៉ឹ តម៉ ប្រនូក ដើម តម៉ បយ៉ុង ណគ់ អៃ អជុ ប្លះ កឌី បា នែ ");
INSERT INTO brb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ប្រនូក តម៉ ដើម តម៉ បយ៉ុង នែ ឡើយ បន់កាំ ប្លះ បា បើ ខណាត រៀន អៃ តៃ អន់ក្លង បើម តៃ ចាគ់ អ៊ឺម ដើ ឆារ អ៊ែ ដើ ឆារ តៃ ឆន់ក្លង បើម តៃ ចាគ់ អ៊ឺម ប៉ាគ់ទឺ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","អ៊ែ ឡើ ឡា រៀន៖ «ឡា គ្រែដៃ ហកន់ដ្រាគ់ យ៉ាគ់ អាប្រាហាំ ឝ្រូ គ្រែ យ៉ាគ់ ណាខូរ ដើម ឝ្រូ គ្រែ ម៉ិ យ៉ាគ់ អំប្រា វន់បើម កឡា តាត់ កឍី ប្លះ ញឺ នែ»។ អ៊ែ យ៉ាកុប ឡើ តប៉ឹន ចាក់ ប៊ឹង ងឺរ គ្រែដៃ ណគ់ បើគ ណគ អ៊ីសាគ់ ឡើ អៀល បឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","យ៉ាគ់ យ៉ាកុប ឡើ កជែត បណាន់ បប៊ុះ ថួយ ដើ គ្រែដៃ ទឹង ចន់ឌូ ឝ៉ាឡាត អ៊ែ ឡើ ច្រា មែ អំម៉ោះ អោះ ព្រឝ៉ើត យូ ណគ ដក់ ចង់ ចា អរែង។ ម៉ើ ចង់ ចា លែវ ឡើយ មាំង អ៊ែ ម៉ើ កី គូ ទឹង ចន់ឌូ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","យ៉ាគ់ ឡាបាន់ ឡើ រ៉ៃ តើម ភុង មាំង ឡើ មុក មុញ កួន ចូវ ណគ ដើម ឡើ ប្រាយ ហ្រនុក ហ្រវ៉ាក ប៊្លី អ៊ែ ឡើ តាក់ ម៉ាង ជឹ វឹញ ហឹ ស៊្រុក ប្រិះ ណគ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","យ៉ាគ់ យ៉ាកុប ឡើ ដក់ ឡឹះ អន់ណាវ ហឹ ងឺរ អ៊ែ ឞាវ គ្រែដៃ ម៉ើ ដក់ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ប៊ឹង ឡើ តៃ មែ យ៉ាគ់ យ៉ាកុប ឡើ ម៉ាង រៀន៖ «ប៊ឹង នែ កនូ កង តហាន គ្រែដៃ ហន់ឆា!»។ ឡើ ជុ កនូ នែ រៀន “ម៉ាហានែម”។ ");
INSERT INTO brb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","យ៉ាគ់ យ៉ាកុប ឡើ ប៉្រៃ មែ ក៝ត ណគ មន់ដក់ ឈូន ប្រម៉ាង ណគ អន់នួរ ហឹ អ៊ូគ ណគ អ៊ែសាវ ឡើ គូ ហឹ ឞន ចន់ឌូ សៀរ ទឹង ស្រុក អ៊ែដុម។ ");
INSERT INTO brb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","យ៉ាគ់ យ៉ាកុប ឡើ ថាន់ ថយ ប៊ឹង មែ រៀន៖ «វែ វន់ហាយ ដើ អ៊ូគ អៃ អ៊ែសាវ រៀន អោះ ហៃ ឡើ គូ ប៊ឹង ហឝ៉ៃ បើគ ណគ យ៉ាគ់ ឡាបាន់ ទុត ឌុញ ប៊ឹះ ណិះៗ ឡើយ ។ ");
INSERT INTO brb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ណគ ឡើ ប៊ិច ក៝ត កទ្រី កឡ ដើម ឝ៉ូ លៀ បូវ បប៊ែ ចៀម។ ឡើ ប៉្រៃ ញ៉ើ ដក់ ហាយ ដើ ហៃ អាំ ហំឡាប់ ឡង ណគ ចាគ់ៗ នៀមៗ»។ ");
INSERT INTO brb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","អ៊ែ មែ ក៝ត ម៉ើ ឈូន ប្រម៉ាង ម៉ើ ដក់ ប្រយ ប៊្លី អ៊ែ ម៉ើ ជឹ វឹញ ហឹ យ៉ាកុប ទឺ ម៉ើ ហាយ រៀន៖ «ញ៉ា ញ៉ើ ដក់ ប៊ឹះ ហឹ អ៊ូគ ហៃ យ៉ាគ់ អ៊ែសាវ ឡើយ។ ណគ ឡើ ដក់ ដាំង ហៃ ប៉ាគ់ទឺ ឡើយ ដើម ឡើ តៀត បូវ ប៊ែង ណគ ម៉ាត់កឡៗ ពួន ក្លាំ រ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","យ៉ាគ់ យ៉ាកុប ឡើ ឌូង ទុត ខាក់ ប្រយ ដើម ឡើ ឝ្រង៉ឹត អ៊ែ ឡើ កះ បូវ ប៊ែង ណគ់ ម៉ើ គូ ប៊ឹង ណគ ដើម បប៊ែ ចៀម ឝ៉ូ អូត ឡើ កះ បើម បារ បូវ ");
INSERT INTO brb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","យ៉ាក់ ឡើ ឃឹត រៀន ប៉ាគ់ យ៉ាគ់ អ៊ែសាវ លំដក់ បឹត មូយ បូវ អ៊ែ ណាគ់ មូយ បូវ អាត មន់ក្លើច។ ");
INSERT INTO brb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ អ៊ឺរ ដាំង គ្រែដៃ រៀន៖ «ឡា គ្រែដៃ ហកន់ដ្រាគ់ យ៉ាគ់ អ អៃ អាប្រាហាំ ដើម ហកន់ដ្រាគ់ បើគ អៃ អ៊ីសាគ់ ឡា គ្រែដៃ ហណាគ់ អន់សច ពន់ឋើម ហហាយ ដើ អៃ រៀន “មិញ ហន់ជឹ វឹញ ហឹ ស្រុក ហៃ ហន់ជឹ ដាំង អំម៉ោះ អោះ ព្រឝ៉ើត យូ ហៃ។ អៃ អំបើម អន់ចាគ់ ដើ ហៃ!”។ ");
INSERT INTO brb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","គ្រែដៃ កន់ដ្រាគ់ អើយ អៃ នែ អបនឹះ កិ ហឡាប ដាប ហឡង់ ឃឺ អ៊ឺម ឌិត ហៃ ហពដៃ ប្រម៉ើត អន់ញ៉ុ ដើម ចនិះ ទឹង ត្រ ដើ អៃ ញឹះ ឞាល់ នែ។ ប៊ឹង អវីះ ក្លង ដាក ដណៃ យ៉ូរដាន់ ពន់ឋើម អប៊ិច វ៉ិះ ឌិវ តង អន់ណើង ហាក់ តគ់ ណិះៗ នែ អប្រនិច ញឹះ បារ បូវ។ ");
INSERT INTO brb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ឡា អុះ គ្រែដៃ អើយ ហំប៉ូរ អៃ អាំ អន់ក្លើច តើម ប៊ឹង ទី អ៊ូគ អៃ អ៊ែសាវ! យ៉ាក់ អឌូង ណគ លំដក់ កជែត ញ៉ា កួន ទ្រី អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ហៃ ហហាយ ដើ អៃ រៀន ហំបើម កាន ចាគ់ ដើ អៃ ដើម ហង់អាំ អំប៊ិច កួន ចូវ មន់ស៊ឺក តាក កាវ តៃ បក់ ឞាល់ ផាច បរ ពឹះ សមុត»។ ");
INSERT INTO brb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","មាំង អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ គូ ប៊ឹង អិះ ឡើយ។ ឡើ កះ បណាន់ ណគ អន់នឺ អាំ ដើ អ៊ូគ ណគ អ៊ែសាវ ");
INSERT INTO brb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","បប៊ែ យូ បារ ក្លាំ អំប៉ម បប៊ែ សារ បារ ជិត អំប៉ម ចៀម យូ បារ ក្លាំ អំប៉ម ចៀម សារ បារ ជិត អំប៉ម។ ");
INSERT INTO brb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","អូត កួន ម៉ិ ពែ ជិត អំប៉ម ឝ៉ូ យូ ពួន ជិត អំប៉ម ឝ៉ូ សារ ជិត អំប៉ម លៀ យូ បារ ជិត អំប៉ម ដើម លៀ សារ ជិត អំប៉ម។ ");
INSERT INTO brb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ឡើ ប៉ាក ពត្រូវ លែក ដើ អ៊ែ ប៉ិន បូវៗ អាំ ដើ ក៝ត ណគ មន់ឞង តាម បូវ មែ កឡឹ ប៊្លី អ៊ែ ឡើ រៀន៖ «ហឹ វន់ដក់ ឞង ពត្រូវ អន់នួរ វន់ដក់ ង៉ាយ ចង៉ាយ ប្លះ វែ ប៉ិន បូវៗ»។ ");
INSERT INTO brb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ឡើ ថាន់ ក៝ត ណគ ណគ់ ឡើ ដក់ អន់នួរ រៀន៖ «ប៉ាគ់ អ៊ូគ អៃ អ៊ែសាវ លំតៃ ហៃ ដើម លំតង៉ា រៀន “មែ ង៉ាយ កន់ដ្រាគ់ ហៃ? ហឹ ង៉ាយ ហដក់? បណាន់ ណគ់ ហៃ ហឞង នែ រ៉ាះ មែ ង៉ាយ?” ");
INSERT INTO brb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","អ៊ែ ហន់ហាយ ដើ ណគ រៀន “លែក ដើ បណាន់ នែ រ៉ាះ អោះ ហៃ យ៉ាកុប ឡើ ប៉្រៃ អដក់ ឈូន បណាន់ នែ អាំ ដើ ហៃ។ ណគ កឡឹ ឡើ ដក់ ប៉ាគ់ទឺ ណាគ់ ឡើ អន់ទុន ញ៉ា”»។ ");
INSERT INTO brb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","យ៉ាគ់ យ៉ាកុប ឡើ ថាន់ បឹ ទី បារ ដើម បឹ ទី ពែ ដឹប លែក ដើ មែ ម៉ើ ដក់ អន់ទុន ណគ់ ម៉ើ ឞង បណាន់ ឡើ រៀន៖ «ប៉ាគ់ វន់តៃ អ៊ូគ អៃ អ៊ែសាវ វន់ហាយ ប៉ាគ់ ប្រម៉ាង បឹ ឡើ ដក់ អន់នួរ ទឺ ឡើយ យ៉ឹ ");
INSERT INTO brb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ដើម វន់ហាយ រៀន “អោះ ហៃ យ៉ាកុប ណាគ់ ហឹ ត្រិច ញ៉ា”»។ យ៉ាគ់ យ៉ាកុប ឡើ បើម ប៉ាគ់ នែ ញ៉ន ឡើ ឃឹត រៀន៖ «រ៉ាះ បណាន់ អៃ អអាំ អន់នួរ នែ អាត អ៊ែសាវ លំប៊្រឺះ ក្លើម ឡើយ ដើ អៃ អ៊ែ ប៊ឹង ញន់ត្រណៃ លំញឹម ក្លើម ប៉ាគ់ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","អ៊ែ មែ ម៉ើ តៀត បណាន់ អណាំ លែក អ៊ែ ម៉ើ ដក់ អន់នួរ ណគ ហាក់ មាំង អ៊ែ យ៉ាគ់ យ៉ាកុប ណាគ់ ឡើ កី ហឹ ស៊ូន។ ");
INSERT INTO brb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ទឹង មាំង អ៊ែ ទឺ យ៉ាគ់ យ៉ាកុប ឡើ រ៉ៃ ឡើ ពង់ឝ៉្លង ទ្រី ណគ លែក បារ ក៝ត កទ្រី ណគ លែក បារ ដឹប កួន កឡ ណគ ជិត មូយ រ៉ា ម៉ើ ក្លង តៃ ច្រឡង ចណោះ យ៉ាបុក។ ");
INSERT INTO brb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ម៉ើ ក្លង ក្លើច ឡើយ អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ប៉្រៃ ម៉ើ ក្លង ប៉ាគ់ទឺ លែក ដើ រ៉ាះ អំបាះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ប៊ឹង អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ គូ មូយ រ៉ា កអវ ឡើ ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ដ្រម ណគ អ៊ែ អំប្រា ចន់ឌ្រូម ត្រឌីវ អំប្រា ឋា ដើ ប្រាង។ ");
INSERT INTO brb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ប៊ឹង អំប្រា ចន់ឌ្រូម បឹ ហង់អ៊ែ ឡើ ដុង តៃ ផ ប្រិញ អ៊ឺម អ៊ែ ឡើ ជិវ យ៉ាកុប ប៊ឹង តើម ប៊្លូ ញឹះ ឡើ ត្រប្លិច ប្រយ ក្រឡាវ តើម ប៊្លូ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","បឹ ហង់អ៊ែ ឡើ ម៉ាង រៀន៖ «អឡា ហន់អាំ អៃ អន់ជឹ ឡើ ប្រាង ឡើយ»។ យ៉ាកុប ឡើ តើវ រៀន៖ «ប៉ាគ់ តៃ ហំប្រាយ កាន ចាគ់ ដើ អៃ អន់អាំ អ៊ឺម ហន់ជឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","បឹ ហង់អ៊ែ ឡើ តង៉ា ណគ រៀន៖ «អង់ង៉ាយ ម៉ាត់ ហៃ?»។ ឡើ ត្រណើវ រៀន៖ «អៃ នែ យ៉ាកុប»។ ");
INSERT INTO brb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","បឹ ហង់អ៊ែ ឡើ រៀន៖ «មន់ជុ យ៉ាវ ហៃ យ៉ាកុប មន់ជុ អ៊ីស្រាអ៊ែល អន់ណាវ យ៉ាក់ ហៃ ហចន់ឌ្រូម ប៊ឹង គ្រែដៃ ដើម ប៊ឹង បនឹះ ណាគ់ ហប្រិញ»។ ");
INSERT INTO brb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","យ៉ាគ់ យ៉ាកុប ឡើ តង៉ា បឹ ហង់អ៊ែ រៀន៖ «ឡា ហន់ហាយ ម៉ាត់ ហៃ ដើ អៃ»។ បឹ ហង់អ៊ែ ឡើ តើវ រៀន៖ «ប៉ិ ត្រ ហតង៉ា ងុញ ណោះ ម៉ាត់ អៃ?»។ ប៊្លី អ៊ែ ឡើ ប្រាយ កាន ចាគ់ ដើ យ៉ាកុប ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","យ៉ាគ់ យ៉ាកុប ឡើ ជុ ម៉ាត់ ប៊ឹង ឞន អ៊ែ រៀន “ពែនីអ៊ែល” យ៉ាក់ ឡើ ម៉ាង រៀន៖ «អៃ អតៃ មុះ ម៉ាត់ គ្រែដៃ ញឹះ ដើ ចន់ដ្រាគ់ ងឺរ ហាក់ ណាគ់ អញិវ»។ ");
INSERT INTO brb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ឆិ ឌឹក ម៉ាត់ តង៉ៃ ឡើយ អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ វីះ តើម ប៊ឹង ពែនីអ៊ែល ឡើ ដក់ វឹឝ្រវឹ យ៉ាក់ ឡើ ត្រប្លិច តើម ប៊្លូ។ ");
INSERT INTO brb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ញ៉ន នែ ឡើយ អ៊ែ មែ កួន ចូវ អ៊ីស្រាអ៊ែល(ម៉ើ ជុ ណគ យ៉ាកុប ដិ) ម៉ើ ក្រាំង ចា ច្រឡាត ម៉ាត ប្លះ ក្រឡាវ តើម ប៊្លូ ប៊ឹះ ណិះ យ៉ាក់ គ្រែដៃ ឡើ ជិវ យ៉ាកុប ប្លះ ក្រឡាវ តើម ប៊្លូ។ ");
INSERT INTO brb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","យ៉ាគ់ យ៉ាកុប ឡើ បយ៉ើល ឝ្លាំង កអវ ឡើ តៃ យ៉ាគ់ អ៊ែសាវ ឡើ ប៊ឹះ ដើម បូវ ណគ ម៉ាត់កឡៗ ពួន ក្លាំ រ៉ា។ យ៉ាគ់ យ៉ាកុប ឡើ ប៉្រៃ កួន ណគ ដក់ ប៊ឹង មែគ មែ កឡឹៗ ដើ លែអា ឡើ ដក់ ប៊ឹង កួន ឡើ កឡឹ ដើ រ៉ាជែល ឡើ ដក់ ប៊ឹង កួន ឡើ កឡឹ អំប្រា កទ្រី ក៝ត អំប្រា ដក់ ប៊ឹង កួន អំប្រា កឡឹ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ឡើ ប៉្រៃ កទ្រី ក៝ត លែក បារ ដឹប កួន អំប្រា ដក់ អន់នួរ ប៊្លី អ៊ែ លែអា ដើម មែ កួន ណគ តគ់ ទុនៗ រ៉ាជែល អំប្រា កួន ណគ យ៉ូស៊ែប។ ");
INSERT INTO brb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","អ៊ែ ណគ កឡឹ ឡើ ដក់ អន់នួរ មែ ឡើ ដក់ ប៉ាគ់ កដាប ហំបះ ត្រងឺវ ទូត ពដិះ ប៉ឹះ តង ឆា ដៀប លំប៊ឹះ អ៊ូគ ណគ អ៊ែសាវ។ ");
INSERT INTO brb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","អ៊ែ ដើ យ៉ាគ់ អ៊ែសាវ ឡើ យ៉ាវ អម មុក មុញ កវ៉ាត់ ប៊ឹង ដង់ កប៉ង់ ប៊ឹង ប៉ាវ ប្រយ អោះ ណគ ដើម អំប្រា ឆ្រញឺម ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","យ៉ាគ់ អ៊ែសាវ ឡើ ប៊្រឹក ម៉ាត់ ឡើ តៃ ប៊ិច មែ កទ្រីៗ ដើម មែ អង់គ្លែត អ៊ែ ឡើ តង៉ា រៀន៖ «មែ ង៉ាយ អន់នែ ដឹះ ម៉ើ ដក់ អរែង ប៊ឹង ហៃ?»។ យ៉ាគ់ យ៉ាកុប ឡើ តើវ រៀន៖ «អ៊ូគ អើយ គ្រែដៃ ឡើ បើម អន់ចាគ់ ឡើ អាំ កួន លែក នែ ដើ អៃ »។ ");
INSERT INTO brb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ក៝ត កទ្រី ទ្រី ណគ បារ រ៉ា ដើម កួន អំប្រា ម៉ើ ដក់ ពន់ចើម ហឹ យ៉ាគ់ អ៊ែសាវ អ៊ែ ម៉ើ កដាប ហំបះ។ ");
INSERT INTO brb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ប៊្លី អ៊ែ យ៉ាគ់ លែអា ដើម កួន ណគ ម៉ើ ដក់ កដាប ហំបះ តគ់ អន់ទុនៗ យ៉ូស៊ែប អំប្រា មែគ ណគ រ៉ាជែល អំប្រា ដក់ កដាប ហំបះ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","យ៉ាគ់ អ៊ែសាវ ឡើ តង៉ា រៀន៖ «លែក ដើ បណាន់ ណគ់ អតៃ អន់ឌូ ហអាំ ពយ៉ិ ដើ អៃ?»។ យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «អ៊ូគ អើយ អអាំ ដើ ហៃ ឡើយ អ៊ែ ហន់ញឹម ក្លើម ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","យ៉ាគ់ អ៊ែសាវ ឡើ ត្រណើវ រៀន៖ «អោះ អើយ អប្រនិច ទុត អើន ឡើយ រ៉ាះ ហៃ អ៊ែ ហន់ជុ ដើ ហកឡឹ អោះ»។ ");
INSERT INTO brb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «ដូវ អ៊ឺម ប៉ាគ់ អ៊ិន ប៉ាគ់ ហន់ញឹម ក្លើម ដើ អៃ ម៉ាត់ ម៉ាត អម៉ើត ហន់ចក់ បណាន់ អៃ អអាំ នែ ឡើយ។ ប៊ឹង អតៃ ហៃ ឡើ បើម ឞាល់ អតៃ គ្រែដៃ ទឺ យ៉ាក់ ហៃ ហឡាប់ អៃ ហញឹម ក្លើម ឞាល់ នែ អ៊ូគ អើយ! ");
INSERT INTO brb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ប៉ាគ់ ពអ៊ែ ឡា អ៊ូគ អើយ ហន់ចក់ បណាន់ អៃ អអាំ ដើ ហៃ នែ យ៉ាក់ គ្រែដៃ ឡើ បើម អន់ចាគ់ ដើ អៃ ដើម អប្រនិច ត្រំ ហំឞ្លិច ឡើយ»។ ញ៉ន យ៉ាគ់ យ៉ាកុប ឡើ អាំ ស៊ុតៗ ដឌែ អ៊ែ យ៉ាគ់ អ៊ែសាវ ឆា ឡើ ចក់ ហឹ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","យ៉ាគ់ អ៊ែសាវ ឡើ ម៉ាង រៀន៖ «ញ៉ះ ញន់ដក់ អន់ណាវ អៃ អន់តៀត ទ្រូង ដើ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «ហៃ ហណោះ ឡើយ មែ អង់គ្លែត ហ៊ែត អំម៉ឹះ ម៉ើ ប្រិញ ដក់ ដើម អប៊ិច បប៊ែ ចៀម ដើម ឝ៉ូ ណាគ់ ម៉ើ ពុ ហម ងន់ខំ ដក់ ប្រិញៗ វ៉ិះ មូយ តង៉ៃ ហន់ណូវ លែក ដើ បណាន់ អៃ មន់គែត។ ");
INSERT INTO brb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ប៉ាគ់ ពអ៊ិន ឡា អ៊ូគ អើយ ហៃ ហន់ដក់ អន់នួរ ឆិ ដើ បា អៃ អន់ដក់ ខយៗ តៃ ត្រិច តាម ប៉ាគ់ បណក់ មែ អង់គ្លែត ដើម បណាន់ ហូច ញំប៊ឹះ កនូ ហៃ ហឹ ស្រុក អ៊ែដុម »។ ");
INSERT INTO brb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","យ៉ាគ់ អ៊ែសាវ ឡើ រៀន៖ «ប៉ាគ់ ពអ៊ិន ហង់អាំ មែ បូវ ប៊ែង អៃ អន់នឺ ឆិ មន់ដក់ អរែង ប៊ឹង ហៃ»។ យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «សណូវ អ៊ឺម អ៊ូគ អើយ យ៉ាក់ ណាគ់ ហញឹម ក្លើម ដើ អៃ ឆិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","តង៉ៃ ហង់អ៊ែ ទឺ ឡើយ យ៉ាគ់ អ៊ែសាវ ឡើ ជឹ វឹញ ហឹ ស្រុក អ៊ែដុម ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ណគ់ ដើ យ៉ាគ់ យ៉ាកុប អន់ណាវ ឡើ ដក់ ដៀក មួង សកូត។ ឡើ បើម ស៊ូន មូយ ដើ ក្រាន ណគ កឡឹ ដើម ឡើ បើម ខក ដើ បណាន់ ណគ ដិ។ ញ៉ន អ៊ែ ឡើយ ម៉ើ ជុ កនូ អ៊ែ រៀន សកូត ។ ");
INSERT INTO brb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","តគ់ យ៉ាគ់ យ៉ាកុប ឡើ ជឹ វឹញ តើម ប៊ឹង ស្រុក មែសូប៉ូតាមី ប៊្លី ឡើ វីះ តើម ប៊ឹង មួង សកូត ឡើ ប៊ឹះ ហឹ មួង ស៊ីគែម ស្រុក កាណាន ចាគ់ៗ នៀមៗ អ៊ែ ឡើ បើម កតូ ចើម មួង ហង់អ៊ែ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ប្រិះ ឡើ បើម កតូ អ៊ែ ឡើ រួត តើម ប៊ឹង មែ កួន កឡ យ៉ាគ់ ហាម៉ូរ ឡើ ត្រ បើគ យ៉ាគ់ ស៊ីគែម ច្រណាប់ មូយ ក្លាំ កាក់ ប៉្រាក់។ ");
INSERT INTO brb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ប៊្លី អ៊ែ ឡើ ប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក បើម ឞន ថនួយ ដើ គ្រែដៃ ប៊ឹង អ៊ែ។ ឡើ ជុ ប្រនូក អ៊ែ រៀន៖ «គ្រែដៃ ឡើ កន់ដ្រាគ់ យ៉ាគ់ អ៊ីស្រាអ៊ែល»។ ");
INSERT INTO brb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","តង៉ៃ ហង់អ៊ិន ណាង ឌីណា កួន ប្រោះ យ៉ាគ់ យ៉ាកុប អំប្រា យ៉ាគ់ លែអា ឡើ ដក់ កវាំង ត្រឌីវ ប្រោះ ទឹង ស្រុក កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ហំប៊្រុះ ស៊ីគែម កួន កឡ យ៉ាគ់ ហាម៉ូរ សុនសាត ហ៊ែវី ឡើ តៃ ណាង ឌីណា ឡើ រ៉ាប់ ដ្រូក កី ប្រយ។ (យ៉ាគ់ ហាម៉ូរ នែ ឡើ កឡា ពែក ប៉ាក់ ស្រុក មែ ហ៊ែវី)។ ");
INSERT INTO brb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ស៊ីគែម ឡើ ម៉ើត ណាង ឌីណា កួន យ៉ាគ់ យ៉ាកុប ទុត ម៉ៃ ដើម ឡើ ងុញ អ៊ែ ឡើ អូរ ញ៉ូម ញឹមៗ ប្រណគ។ ");
INSERT INTO brb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ស៊ីគែម ឡើ ឡា ហឹ បើគ ណគ ហាម៉ូរ រៀន៖ «បើគ ហន់ដក់ យ៉ាគ់វឺ ណាង ឌីណា ដើ អៃ អំបើម ទ្រី»។ ");
INSERT INTO brb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","តៃ នែ យ៉ាគ់ យ៉ាកុប ឡើ ដុង ម៉ើ រៀន ស៊ីគែម ឡើ បើម ឆាំ ឆោះ កួន ណគ ណាង ឌីណា ប៊ឹង អ៊ែ កួន កឡ យ៉ាកុប ណាគ់ ម៉ើ គូ ហឹ ត្រិញ ម៉ើ បយ៉ា បណាន់។ អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ គូ ខៀង អន់ដៃ ឡើ ចាំ មែ កួន ណគ មន់ជឹ។ ");
INSERT INTO brb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ប៊្លី អ៊ែ យ៉ាគ់ ហាម៉ូរ ដើម កួន ណគ ស៊ីគែម អំប្រា ដក់ ហឹ យ៉ាគ់ យ៉ាកុប បក់ អំប្រា លន់ចជែ ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","តគ់ កួន កឡ យ៉ាគ់ យ៉ាកុប ម៉ើ ជឹ តើម ប៊ឹង ត្រិញ អ៊ែ ម៉ើ ដុង ស៊ីគែម ឡើ កី ដ្រូក ដើ អោះ មែ ស្រៀវ ប្រយ ម៉ើ ដុង ដើម ម៉ើ មាំ ទុត ខាក់ យ៉ាក់ ស៊ីគែម ឡើ បើម ប៉ាគ់ នែ ដើ ណាង ឌីណា ដូវ អ៊ឺម បើម កាន តៃ ចាគ់ ប៉ាគ់ នែ ឡើ យូច ទុត កយឹក ឡើយ ដើ មែ យ៉ាគ់ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO brb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","យ៉ាគ់ ហាម៉ូរ ឡើ ឡា ហឹ យ៉ាកុប ដើម មែ កួន ណគ រៀន៖ «ស៊ីគែម កួន អៃ ឡើ ងុញ ណាង ឌីណា ទុត ខាក់ ប៉ាគ់ ពអ៊ែ អឡា ហឹ វែ វន់អាំ ណគ ដើ កួន អៃ លំបើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","អ៊ែ ញន់បើម ចម៉ក់ ណូង ប្លះ ង៉ាយ នែ វន់អាំ កួន កទ្រី វែ ប្រយ៉ង់ ប៊ឹង កួន កឡ ញ៉ា អ៊ែ ណគ់ ដើ វែ វន់ចក់ កួន កទ្រី ញ៉ា វន់បើម ទ្រី ដូវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","អ៊ែ វន់ដូវ គូ អរែង ប៊ឹង ញ៉ា យ៉ាក់ ប្រិះ ប៊្រី ញ៉ា នែ ញន់អាំ ដើ វែ វន់គូ ប្លះ ង៉ាយ កគ់ ដូវ ដើម វន់ដាំង ចា កាប់ រួត ប្រិះ ប៊្រី ទឹង នែ ដូវ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ស៊ីគែម ឡើ ចជែ ប៊ឹង បើគ ណាង ឌីណា ដើម មែ អ៊ូគ អា ណគ រៀន៖ «ឡា អុះ ប៉ាគ់ វន់ផម តាម ចនិះ អៃ ណគ់ អង់ង៉ាយៗ វែ វ៉ើ ឡា ហឹ អៃ អង់អាំ ដើ វែ លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","សំយ៉ះ វន់ប៉្រៃ អៃ អន់លឺង ដាក តោះ ទុត អើន ឞាល់ ង៉ាយ កតាម អៃ អន់អាំ លែក ដើ អិះ ថលែម វន់អាំ ណគ ដើ អៃ អំបើម ទ្រី»។ ");
INSERT INTO brb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ញ៉ន ស៊ីគែម ឡើ បើម ឆាំ ឆោះ អោះ មែ អ៊ែ កួន កឡ យ៉ាគ់ យ៉ាកុប ម៉ើ ត្រណើវ តបូត ម៉ាង ស៊ីគែម ដើម បើគ ណគ យ៉ាគ់ ហាម៉ូរ ម៉ើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","«ដូវ អ៊ឺម ញំផម តាម អ្រឡា សប្រា អ៊ិន ប៉ិ ញន់ណោះ អាំ អោះ កទ្រី ញ៉ា ញំប្រយ៉ង ប៊ឹង កឡ តៃ ឡើ ចៀត ដម៉ូច ហំបក ប៉ាគ់ នែ ញំបើម ប៉ាគ់ នែ ឝ៉ាន់ ញន់កម៉ាវ យួរ។ ");
INSERT INTO brb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","តៃ កា លែក ដើ កឡ វែ មន់ចៀត ដម៉ូច ហំបក ប៉ាគ់ ដើ ញ៉ា ទឺ អ៊ែ ណាគ់ ញំផម ប៉ាគ់ អ្រឡា សប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","អ៊ែ ញន់អាំ កួន កទ្រី ញ៉ា ដើ វែ ណគ់ ដើ ញ៉ា អន់ណាវ ញន់ចក់ កួន កទ្រី វែ បើម ទ្រី ប៉ាគ់ទឺ។ អ៊ែ ងំគូ អរែង ងំវឹរ មូយ សុនសាត អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ហាក់ ប៉ាគ់ តៃ វន់ឌី ចៀត ដម៉ូច ហំបក ញន់សួរ អោះ កទ្រី ញ៉ា ញន់វីះ តើម ប៊ឹង នែ ប្រយ»។ ");
INSERT INTO brb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","យ៉ាគ់ ហាម៉ូរ ដើម កួន ណគ ស៊ីគែម អំប្រា ឌី ប្រយ យ៉ាក់ ឡើ ត្រ ទឹង ប្រម៉ើត អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ស៊ីគែម នែ ដ្រិះៗ ប្រយ ឡើ ងុញ បើម តាម ប្រម៉ាង មែ យ៉ាក់ ឡើ ងុញ កួន ប្រោះ យ៉ាកុប ម៉ៃៗ។ ទឹង ក្រាន យ៉ាគ់ ហាម៉ូរ ម៉ើ អៀល ម៉ាគ់ ស៊ីគែម ជឺរ បូវ។ ");
INSERT INTO brb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","យ៉ាគ់ ហាម៉ូរ អំប្រា កួន ណគ ស៊ីគែម អំប្រា ដក់ ហឹ ឝឡោះ ដ្រក មួង  អ៊ែ អំប្រា ពហាយ ដើ មែ កឡ ទឹង មួង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«បូវ មែ យ៉ាកុប នែ ម៉ើ ងុញ គូ ញឹម សាំង ប៊ឹង ង៉ាយ ប៉ាគ់ ពអ៊ែ ងន់អាំ ដើ មែ មន់គូ ដើម មន់ដាំង ចា អរែង ហឹ ស្រុក ង៉ាយ ណិះ ឡើយ ដើម ពដិះ ង៉ាយ ឡើ ឌឺះ ងន់គូ គូម អរែង ដូវ។ ង៉ាយ ងន់ចក់ ទ្រី ហឹ មែ មែ មន់ចក់ ទ្រី ហឹ ង៉ាយ ដូវ ប៉ាគ់ ទឺ ");
INSERT INTO brb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ហាក់ មែ មន់ឌី គូ ប៊ឹង ង៉ាយ បើម សុនសាត ឌិវ មូយ តៃ កា លែក ដើ ង៉ាយ កឡ ងន់ចៀត ដម៉ូច ហំបក ប៉ាគ់ ដើ មែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ញ៉ាគ់ ញំបើម តាម ប្រម៉ើត មែ អ៊ែ មន់គូ អរែង ប៊ឹង ង៉ាយ។ បប៊ែ ចៀម ដើម ឝ៉ូ រ៉ាះ ប្រនិច មែ ដើម លែក ដើ ពត្រូវ អង់គែងៗ មែ លំត្រ ប្រនិច ង៉ាយ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","លែក ដើ មែ កឡ ទឹង មួង ណគ់ ម៉ើ ចង់ហៀង ប្រម៉ាង យ៉ាគ់ ហាម៉ូរ អំប្រា ស៊ីគែម ប៊ឹង ឝឡោះ ដ្រក មួង ម៉ើ ផម តាម ប៉ាគ់ ប្រម៉ាង អំប្រា។ អ៊ែ មែ កឡៗ ទឹង មួង អ៊ែ ម៉ើ ចៀត ដម៉ូច ហំបក លែក ដើ មែ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","តគ់ តង៉ៃ ហំប្រា មែ កឡ ទឹង មួង អ៊ែ ណាគ់ ប៉ះ ម៉ើ ដ ឈិ កួន យ៉ាគ់ យ៉ាកុប បារ រ៉ា ស៊ីមៀន អំប្រា លែវី អ៊ូគ ណាង ឌីណា អំប្រា ចក់ តាវ មឹត ទឹង មួង។ មែ ទឹង មួង អ៊ែ ម៉ើ ឃឹត រៀន ណាគ់ ឆនឹម ហន់ណាំង។ អ៊ែ អំប្រា កជែត មែ កឡៗ ទឹង អ៊ែ លែក តាក់ ");
INSERT INTO brb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","អំប្រា កោះ កជែត យ៉ាគ់ ហាម៉ូរ ដើម កួន ណគ ស៊ីគែម ដើ តាវ លែវ អ៊ែ អំប្រា សួរ ណាង ឌីណា តើម ប៊ឹង ហន់ណាម ស៊ីគែម អ៊ែ ម៉ើ វីះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","កួន កឡ យ៉ាគ់ យ៉ាកុប មែ គែង អ៊ែ ម៉ើ ចក់ តមួត រ៉ាះ អំបាះ ប៊ឹង ចាក់ កយ៉ក់ ដើម លែក ទឹង មួង  ញ៉ន ម៉ើ តូវ ស៊ីគែម ឡើ បើម ឆាំ ឆោះ អោះ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ម៉ើ ចក់ បប៊ែ ចៀម ឝ៉ូ ដើម លៀ មែ ដឹប លែក ដើ អង់ង៉ាយៗ ទឹង មួង ហង់អ៊ែ ឆា ដើ ប៊ឹះ មឺរ ញ៉ក បក តូង។ ");
INSERT INTO brb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ម៉ើ ចក់ ពន់ដម លែក ដើ ប្រនិច ប្រណាក់ មែ ដើម ម៉ើ រ៉ាប់ មែ កទ្រី ដើម មែ អង់គ្លែត ម៉ើ ឞរ អាំ តូច។ អង់ង៉ាយៗ ទឹង ហន់ណាម មែ ម៉ើ ចក់ ញឹះ សិត បុ ដើ មួង។ ");
INSERT INTO brb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ម៉ាង ដើ ស៊ីមៀន អំប្រា លែវី រៀន៖ «កួន អើយ សប្រា បើម ប៉ាគ់ នែ សប្រា ប៉្រៃ អៃ អឝ្រង៉ឹត ឡើយ យ៉ាក់ ស្រុក អន់នែ សុនសាត មែ កាណាន ដើម សុនសាត មែ ពែរីស៊ី មន់ដ្រម៉ា ឡើយ ដើ អៃ។ ឞិះ បូវ ប៊ែង អៃ នែ ឡើ កើយ សាំ ប៉ាគ់ មន់តមួត បូវ មែ មន់ដក់ បឹត ង៉ាយ តៃ ការ អឹ ងន់គែត លែក ដើ ក្រាន អៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","អំប្រា ត្រណើវ រៀន៖ «យ៉ាក់ ឡើ ឌី បើម ឞាប អោះ ញ៉ា បើម ប៉ាគ់ កទ្រី ឡាក់ លែង»។ ");
INSERT INTO brb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ហាយ ដើ យ៉ាគ់ យ៉ាកុប រៀន៖ «មិញ ហន់ឌឹក ទឹង ស៊្រុក ប៊ែតអ៊ែល ហង់គូ ទឹង អិះ ឡើយ។ អ៊ែ ហំប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក ហំបើម ឞន ថនួយ ដើ អៃ អគ្រែដៃ អពដៃ ចាក់ ដើ ហៃ ប៊ឹង ហរ៉ូះ ដើ អ៊ូគ ហៃ អ៊ែសាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","យ៉ាគ់ យ៉ាកុប ឡើ ហាយ ដើ មែ ទឹង ក្រាន ណគ ដើម ដើ មែ ណគ់ ម៉ើ គូ ប៊ឹង ណគ រៀន៖ «ហ៊ូប ប្រាគ់ មែ សុនសាត គែង ណគ់ វែ វ៉ើ ប៊ិច វន់តាក់ អាំ លែក វន់បើម ឞ៊ុន ពឆ្រះ ចាក់ ដើម វន់ពលិះ ប្រវ៉ើន ហណក វែ យ៉ឹ ");
INSERT INTO brb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ប៊្លី អ៊ែ ងន់រន់ឋាប់ ឌឹក គូ ទឹង ស៊្រុក ប៊ែតអ៊ែល។ ហឹ អ៊ែ អៃ អំប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក អំបើម ឞន ថនួយ ដើ គ្រែដៃ។ គ្រែដៃ នែ ឡើយ ឡើ ត្រណើវ កាន អៃ អឡា តង៉ៃ អប៊ិច កាន ធុក ញ៉ាក ដើម ត្រំ អំប៊ុ ណគ់ អៃ អដក់ ណគ ណាគ់ ឡើ លវាំង ឝ្លាំង អៃ ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","អ៊ែ ម៉ើ ចក់ ហ៊ូប ប្រាគ់ សុនសាត គែង ប្រនិច មែ ដើម ម៉ើ តោះ កចន ខាំលុត ប៊ឹង ត្រពិត មែ ម៉ើ អាំ ហឹ យ៉ាកុប។ យ៉ាគ់ យ៉ាកុប ឡើ ចក់ តើម ប៊ឹង មែ ឡើ ដក់ កុប តាក់ ហឹ តើម ឈ្រី ចើម មួង ស៊ីគែម។ ");
INSERT INTO brb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ប៊្លី អ៊ែ ម៉ើ វីះ ប្រយ។ ណគ់ មួង ឈុំ អ៊ែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ហាន ឆ្រួយ បឹត មែ យ៉ាក់ គ្រែដៃ ឡើ បើម អាំ មែ ម៉ើ ឌូង ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","យ៉ាគ់ យ៉ាកុប ដើម លែក ដើ មែ ណគ់ ម៉ើ គូ ប៊ឹង ណគ ម៉ើ ប៊ឹះ ហឹ ស៊្រុក លូះ ស្រុក កាណាន (ស៊្រុក នែ ម៉ើ ជុ ស៊្រុក ប៊ែតអ៊ែល ដិ)។ ");
INSERT INTO brb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ទឹង អ៊ែ ឡើ ប៊ូក ព្រឌឺន តម៉ មូយ ប្រនូក បើម ឞន ថនួយ ដើ គ្រែដៃ ឡើ ជុ ម៉ាត់ ឞន អ៊ែ រៀន “អ៊ែល ប៊ែតអ៊ែល” យ៉ាក់ ប៊ឹង ឞន ហង់អ៊ែ ឡើយ គ្រែដៃ ឡើ ពដៃ ចាក់ ដើ ណគ ទឹង ឡើ រ៉ូះ ដើ អ៊ូគ ណគ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ទឹង អ៊ែ យ៉ាគ់ ឌែបូរ៉ា មែគ ចនៀម យ៉ាគ់ រែប៊ែកា ឡើ គែត។ ម៉ើ ដក់ ចះ ណគ ក្រូម ស៊្រុក ប៊ែតអ៊ែល ប៊ឹង តើម ឈ្រី។ ញ៉ន អ៊ែ ឡើយ ម៉ើ ជុ តើម ឈ្រី អ៊ែ “តើម ឈ្រី ដាក ម៉ាត់”។ ");
INSERT INTO brb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ប៊្លី យ៉ាគ់ យ៉ាកុប ឡើ ជឹ វឹញ តើម ប៊ឹង ស្រុក មែសូប៉ូតាមី គ្រែដៃ ឡើ ពដៃ ចាក់ ឡឹះ អន់ណាវ ដើ ណគ ដើម ឡើ ប្រាយ កាន ចាគ់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","គ្រែដៃ ឡើ ហាយ រៀន៖ «ម៉ាត់ ហៃ យ៉ាកុប ណិះៗ នែ មន់ជុ យ៉ាវ ហៃ “យ៉ាកុប” មន់ជុ ហៃ “អ៊ីស្រាអ៊ែល” អន់ណាវ»។ អ៊ែ គ្រែដៃ ឡើ ជុ ម៉ាត់ ណគ “អ៊ីស្រាអ៊ែល”។ ");
INSERT INTO brb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","គ្រែដៃ ឡើ ម៉ាង ឡឹះ រៀន៖ «អៃ អគ្រែដៃ អឆង៉ាត់ ទុត ខាក់ ហំពឝ៉ើត កួន ចូវ អាំ វន់ស៊ឺក តាក ហ្រវ៉ាក ណាយ។ លំប៊ិច សុនសាត មូយ ដើម សុនសាត ដិ អន់ដិ មន់កើត តើម ប៊ឹង ហៃ ដើម លំប៊ិច សឋិច ទុត អើន មន់កើត តើម ប៊ឹង កួន ចូវ ហៃ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ណគ់ ប៊្រី ដាក អៃ អអាំ ដើ អាប្រាហាំ អំប្រា អ៊ីសាគ់ អ៊ែ អៃ អន់អាំ ដើ ហៃ អន់ណាវ ប៊្រី ដាក នែ អង់អាំ ដើម ដើ កួន ចូវ ហៃ ណគ់ មន់កើត ហឹ ងឺរ អន់ទុន»។ ");
INSERT INTO brb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","គ្រែដៃ ប៊្លី ឡើ ហាយ ដើ យ៉ាគ់ យ៉ាកុប លែវ ឡើយ ឡើ វីះ ខៀង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","យ៉ាគ់ យ៉ាកុប ឡើ បយ៉ុង តម៉ បើម ឡាក់ ប៊ឹង ឞន គ្រែដៃ ឡើ ហាយ ដើ ណគ អន់ឌូ អ៊ែ ឡើ ហ៊ែង តវែ ឈឹង ជែម ថួយ ដើ គ្រែដៃ ពឺង តម៉ ដើម ឡើ ហ៊ែង ពុក ពឺង អ៊ែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","យ៉ាគ់ យ៉ាកុប ឡើ ជុ ប៊ឹង ឞន ណគ់ គ្រែដៃ ឡើ ហាយ ដើ ណគ អន់ឌូ អ៊ែ “ប៊ែតអ៊ែល”។ ");
INSERT INTO brb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ដើម មែ ទឹង ក្រាន ណគ ម៉ើ វីះ តើម ប៊ឹង ប៊ែតអ៊ែល។ ដៀប មន់ប៊ឹះ ស៊្រុក អ៊ែប៉្រាតា យ៉ាគ់ រ៉ាជែល ឡើ ឈិ អន់ឆិ ឡើ ហង់ឝ៉ិះ យ៉ាក តៃ ឋាំ ");
INSERT INTO brb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ទឹង ណគ ឡើ ឈិ អន់ឆិ ទុត ខាក់ អ៊ែ យ៉ាគ់ បយ ឡើ ហាយ ដើ ណគ រៀន៖ «ញ៉ង ហឌូង អ៊ឺម កួន ហៃ ឡើ កឡ ឡឹះ អន់ណាវ!»។ ");
INSERT INTO brb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","យ៉ាគ់ រ៉ាជែល ទឹង ដៀប ឡើ តាត់ សើម គែត អ៊ែ ឡើ ជុ ម៉ាត់ កួន ណគ រៀន “ប៊ែនអូនី” ហាក់ ដើ ក្ល ណគ ឡើ ជុ កួន ណគ “ប៊ែនយ៉ាមីន”។ ");
INSERT INTO brb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","យ៉ាគ់ រ៉ាជែល ឡើ គែត ឡើយ អ៊ែ ម៉ើ ចះ ណគ ដៀក ទ្រូង ដក់ ហឹ ស៊្រុក អ៊ែប៉្រាតា (ណិះៗ នែ ម៉ើ ជុ ស៊្រុក អ៊ែ ប៊ែថ្លែហិម) ");
INSERT INTO brb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","យ៉ាគ់ យ៉ាកុប ឡើ បយ៉ុង តម៉ បើម ឡាក់ ពឺង លុង កយ៉ក់ ទ្រី ណគ រ៉ាជែល។ តម៉ នែ ឡើ ណាគ់ ប៊ឹះ ណិះៗ ប៊ឹង លុង កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ក្លង ចន់ដ្រាង មីឝ៉ូដាល-អ៊ែដើរ តៃ តគ់ ឡើ បើម កតូ ប្រយ ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ទឹង យ៉ាគ់ អ៊ីស្រាអ៊ែល (ម៉ើ ជុ ណគ យ៉ាកុប ដិ) ឡើ គូ ហឹ អ៊ែ កួន ណគ រូប៊ែន ឡើ កី ដើ ណាង ប៊ីលហា ទ្រី បើគ ណគ អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ដុង ប្រយ កាន នែ។ យ៉ាគ់ យ៉ាកុប ឡើ ប៊ិច កួន កឡ ជិត បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","កួន កឡ យ៉ាគ់ យ៉ាកុប អំប្រា លែអា ម៉ាត់ ណគ រូប៊ែន ឡើ ឡង់ ប៊្លី អ៊ែ ឡើ ប៊ិច ស៊ីមៀន លែវី យូដា អ៊ីសាខារ ដើម សាប់យូឡូន។ ");
INSERT INTO brb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","យ៉ាគ់ រ៉ាជែល កួន ណគ យ៉ូស៊ែប អំប្រា ប៊ែនយ៉ាមីន។ ");
INSERT INTO brb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ណាង ប៊ីលហា ក៝ត យ៉ាគ់ រ៉ាជែល កួន ណគ ដាន់ អំប្រា នែបថាលី។ ");
INSERT INTO brb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ណាង ស៊ីលប៉ា ក៝ត យ៉ាគ់ លែអា កួន ណគ ឝ៉ាត អំប្រា អាស៊ែរ។ មែ លែក នែ កួន កឡ យ៉ាគ់ យ៉ាកុប ម៉ើ កើត ហឹ ស្រុក មែសូប៉ូតាមី។ ");
INSERT INTO brb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ជឹ វឹញ ប៊ឹះ បើគ ណគ អ៊ីសាគ់ ហឹ តើម ឈ្រី យ៉ាគ់ ម៉ាមរែ ចើម មួង កៀរយ៉ាត់-អារបា (មួង នែ ម៉ើ ជុ មួង ហ៊ែប្រុន ដិ) ឡើ ត្រ ឞន យ៉ាគ់ អាប្រាហាំ អំប្រា អ៊ីសាគ់ អំប្រា ខើយ គូ។ ");
INSERT INTO brb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","យ៉ាគ់ អ៊ីសាគ់ កំប្រាគ់ ណគ តូច ដើ អ៊ែ មូយ ក្លាំ ថាម ជិត កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ទឹង អ៊ែ ឡើ ញិវ ទុត ឌុញ រ៉គ់សំ ឆំតក អ៊ែ ឡើ គែត ឡើ ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ ណគ ឡើយ។ អ៊ែ អ៊ែសាវ អំប្រា យ៉ាកុប អំប្រា ដក់ ជុ បើគ អំប្រា ហឹ ត្រម ច្រាង។ ");
INSERT INTO brb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","អន់នែ ចនុ ម៉ាត់ កួន ចូវ យ៉ាគ់ អ៊ែសាវ ម៉ើ ជុ ណគ អ៊ែដុម ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","យ៉ាគ់ អ៊ែសាវ ឡើ ចក់ ទ្រី បារ ហឹ ស្រុក កាណាន ម៉ាត់ អំប្រា ណាង អាដះ កួន យ៉ាគ់ អ៊ែឡូន សុនសាត ហ៊ែត ណាង អូហូលីបាម៉ា កួន យ៉ាគ់ អាណា ចូវ យ៉ាគ់ ស៊ីបៀន ឡើ សុនសាត ហ៊ែវី ");
INSERT INTO brb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ដើម ឡើ ចក់ ទ្រី មូយ អន់ណាវ ណាង បាះម៉ាត់ កួន យ៉ាគ់ អ៊ីសម៉ាអ៊ែល អោះ យ៉ាគ់ នែបាយ៉ូត។ ");
INSERT INTO brb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ណាង អាដះ ឡើ ពឝ៉ើត អ៊ែលីផាះ ប៊ឹង យ៉ាគ់ អ៊ែសាវ ណាង បាះម៉ាត ឡើ ពឝ៉ើត រែហ៊ូល ");
INSERT INTO brb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","អ៊ែ ណាង អូហូលីបាម៉ា ឡើ ពឝ៉ើត យែអ៊ូះ យ៉ាឡាម ដើម កូរ៉ះ។ មែ លែក នែ កួន កឡ យ៉ាគ់ អ៊ែសាវ ណគ់ ម៉ើ កើត ហឹ ស្រុក កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","យ៉ាគ់ អ៊ែសាវ ឡើ ច្រា កួន ទ្រី ដើម លែក ដើ មែ ទឹង ហន់ណាម ក្រាន ណគ បប៊ែ ចៀម ឝ៉ូ ដឹប លែក ដើ ពត្រូវ អង់គែងៗ ណគ ដើម លែក ដើ ប្រនិច ណគ់ ណគ ឡើ ដូវ ដាំង ហឹ ស្រុក កាណាន ឡើ តៀត ដក់ គូ ហឹ ស្រុក លមូយ អន់ណាវ ចង៉ាយ តើម ប៊ឹង អោះ ណគ យ៉ាកុប ");
INSERT INTO brb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","យ៉ាក់ លែក ដើ អំប្រា អំប្រា ប៊ិច បណាន់ អើន ហ៊ែត ដូវ អឹ អំប្រា លន់គូ អរែង។ ណគ់ ស្រុក អំប្រា គូ អ៊ែ ប្រិះ ប៊្រី តៃ ឡើ គុំ អ៊ឺម បាត់ ដើ បណាន់ អំប្រា ម៉ើ ចចា។ ");
INSERT INTO brb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ប៉ាគ់ ពអ៊ែ យ៉ាគ់ អ៊ែសាវ ឡើ ឌឹក គូ ទឹង ឞន ចន់ឌូ សៀរ។ យ៉ាគ់ អ៊ែសាវ នែ ម៉ើ ជុ ម៉ាត់ ណគ អ៊ែដុម ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","យ៉ាគ់ អ៊ែសាវ នែ ឡើ ម៉ិ យ៉ាគ់ សុនសាត អ៊ែដុម។ អន់នែ ចនុ ម៉ាត់ កួន ចូវ យ៉ាគ់ អ៊ែសាវ ម៉ើ គូ ហឹ ឞន ចន់ឌូ សៀរ។ ");
INSERT INTO brb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","អន់នែ ម៉ាត់ កួន កឡ យ៉ាគ់ អ៊ែសាវ អ៊ែលីផាះ កួន ប៊ឹង ទ្រី ណគ អាដះ រែហ៊ូល កួន ប៊ឹង ទ្រី ណគ បាះម៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","កួន កឡ យ៉ាគ់ អ៊ែលីផាះ ម៉ើ ជុ ទែម៉ាន់ អូម៉ារ ស៊ែផូ ឝ៉ាតាម ដើម គែណះ។ ");
INSERT INTO brb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","អ៊ែលីផាះ ឡើ ប៊ិច ទ្រី ដូច ម៉ាត់ ណគ ណាង ទីម៉ូណា ឡើ ពឝ៉ើត កួន កឡ ប៊ឹង យ៉ាគ់ អ៊ែលីផាះ ឡើ ជុ ម៉ាត់ កួន ណគ អាម៉ាលែក។ មែ លែក នែ កួន ចូវ ណាង អាដះ ទ្រី យ៉ាគ់ អ៊ែសាវ។ ");
INSERT INTO brb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","កួន កឡ យ៉ាគ់ រែហ៊ូល ម៉ើ ជុ ណាហាត់ ស៊ែរ៉ះ សាំម៉ា ដើម មីះសា។ មែ លែក នែ កួន ចូវ យ៉ាគ់ អ៊ែសាវ អំប្រា ទ្រី ណគ បាះម៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","យ៉ាគ់ អូហូលីបាម៉ា កួន កឡ ណគ ប៊ឹង យ៉ាគ់ អ៊ែសាវ ម៉ើ ជុ ម៉ាត់ មែ យែអ៊ូះ យ៉ាឡាម ដើម កូរ៉ះ។ យ៉ាគ់ អូហូលីបាម៉ា នែ កួន កទ្រី យ៉ាគ់ អាណា ដើម ចូវ យ៉ាគ់ ស៊ីបៀន ឡើ ត្រ ទ្រី យ៉ាគ់ អ៊ែសាវ។ ");
INSERT INTO brb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","អ៊ែ ណគ់ មែ តង់កង់ ឆ្រាំង កួន ចូវ យ៉ាគ់ អ៊ែសាវ ឡើ ប៊ិច ម៉ាត់ មែ ប៉ាគ់ នែ មែ តង់កង់ ឆ្រាំង កួន កឡ អ៊ែលីផាះ កួន ឡង់ យ៉ាគ់ អ៊ែសាវ ម៉ាត់ មែ យ៉ាគ់ ទែម៉ាន់ យ៉ាគ់ អូម៉ារ យ៉ាគ់ ស៊ែផូ យ៉ាគ់ គែណះ ");
INSERT INTO brb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","យ៉ាគ់ កូរ៉ះ យ៉ាគ់ ឝ៉ាតាម ដើម យ៉ាគ់ អាម៉ាលែក។ មែ លែក នែ ម៉ើ តង់កង់ តៃ ឆ្រាំង យ៉ាគ់ អ៊ែលីផាះ ហឹ ស្រុក អ៊ែដុម ម៉ាត់តូវ កួន ចូវ យ៉ាគ់ អាដះ។ ");
INSERT INTO brb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","អ៊ែ ណគ់ មែ តង់កង់ ឆ្រាំង កួន កឡ យ៉ាគ់ រែហ៊ូល កួន យ៉ាគ់ អ៊ែសាវ ម៉ើ ជុ ម៉ាត់ មែ យ៉ាគ់ ណាហាត់ យ៉ាគ់ ស៊ែរ៉ះ យ៉ាគ់ សាំម៉ា ដើម យ៉ាគ់ មីះសា។ មែ លែក នែ ម៉ើ តង់កង់ ឆ្រាំង យ៉ាគ់ រែហ៊ូល ហឹ ស្រុក អ៊ែដុម ម៉ាត់តូវ កួន ចូវ យ៉ាគ់ បាះម៉ាត់ ទ្រី យ៉ាគ់ អ៊ែសាវ។ ");
INSERT INTO brb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","មែ តង់កង់ ឆ្រាំង កួន កឡ យ៉ាគ់ អូហូលីបាម៉ា ទ្រី យ៉ាគ់ អ៊ែសាវ ម៉ើ ជុ យ៉ាគ់ យែអ៊ូះ យ៉ាគ់ យ៉ាឡាម ដើម យ៉ាគ់ កូរ៉ះ។ មែ លែក នែ ម៉ើ តង់កង់ ឆ្រាំង កួន កឡ យ៉ាគ់ អូហូលីបាម៉ា ទ្រី យ៉ាគ់ អ៊ែសាវ។ យ៉ាគ់ អូហូលីបាម៉ា នែ កួន យ៉ាគ់ អាណា។ ");
INSERT INTO brb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","មែ លែក នែ ម៉ាត់តូវ កួន ចូវ យ៉ាគ់ អ៊ែសាវ ម៉ើ តង់កង់ តាម ឆ្រាំង ម៉ើ កឡឹ។ យ៉ាគ់ អ៊ែសាវ ម៉ើ ជុ ម៉ាត់ ណគ អ៊ែដុម ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","អ៊ែ ណគ់ កួន កឡ យ៉ាគ់ សៀរ ឡើ សុនសាត ហូរី ម៉ើ ខើយ គូ ហឹ ស្រុក សៀរ អំប៊ី អំម៉ាន ឡើយ អន់នួរ អ៊ែសាវ ឡើ ប៊ឹះ ម៉ើ ជុ ម៉ាត់ មែ ឡូថាន សូបាល ស៊ីបៀន អាណា ");
INSERT INTO brb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ឌីសូន អ៊ែសើរ អំប្រា ឌីសាន។ មែ លែក នែ ម៉ើ តង់កង់ ឆ្រាំង សុនសាត ហូរី កួន កឡ យ៉ាគ់ សៀរ ហឹ ស្រុក អ៊ែដុម។ ");
INSERT INTO brb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","កួន កឡ យ៉ាគ់ ឡូថាន ឡើ ប៊ិច ហូរី អំប្រា ហ៊ែម៉ាម។ អោះ កទ្រី ឡូថាន ម៉ាត់ ណគ ណាង ទីម៉ូណា។ ");
INSERT INTO brb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ណគ់ កួន កឡ យ៉ាគ់ សូបាល ម៉ើ ជុ ម៉ាត់ មែ អាល់វ៉ាន ម៉ាណាហាត់ អ៊ែបាល សើផូ ដើម អូណាំ។ ");
INSERT INTO brb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","កួន កឡ យ៉ាគ់ ស៊ីបៀន ម៉ើ ជុ ម៉ាត់ មែ អៃយ៉ា អំប្រា អាណា។ យ៉ាគ់ អាណា នែ ឡើយ ឡើ តៃ ត្រម ដាក ហឹ ត្រិញ ទិះ ទឹង ឡើ បយ៉ា លៀ បើគ ណគ យ៉ាគ់ ស៊ីបៀន។ ");
INSERT INTO brb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","កួន យ៉ាគ់ អាណា ម៉ើ ជុ ឌីះសូន អំប្រា ណាង អូហូលីបាម៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","កួន កឡ យ៉ាគ់ ឌីះសូន ម៉ើ ជុ ម៉ាត់ មែ ហ៊ែមដាន់ អ៊ែះបាន់ យីតរ៉ាន់ ដើម គែរ៉ាន់។ ");
INSERT INTO brb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","កួន កឡ យ៉ាគ់ អ៊ែសើរ ម៉ើ ជុ ម៉ាត់ មែ ប៊ីលហាន់ សាវ៉ាន់ ដើម អាកាន់។ ");
INSERT INTO brb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","កួន កឡ យ៉ាគ់ ឌីសាន ម៉ើ ជុ អ៊ូះ អំប្រា អារ៉ាន់។ ");
INSERT INTO brb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","អន់នែ មែ តង់កង់ សុនសាត ហូរី ម៉ើ ជុ ម៉ាត់ មែ យ៉ាគ់ ឡូថាន យ៉ាគ់ សូបាល យ៉ាគ់ ស៊ីបៀន យ៉ាគ់ អាណា ");
INSERT INTO brb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","យ៉ាគ់ ឌីសូន យ៉ាគ់ អ៊ែសើរ ដើម យ៉ាគ់ ឌីសាន។ មែ លែក នែ ម៉ើ តង់កង់ សុនសាត ហូរី ហឹ ស្រុក សៀរ តាម ឆ្រាំង មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ទឹង ហូច ឡើ ប៊ិច សឋិច មន់ពែក ប៉ាក់ មែ អ៊ីស្រាអ៊ែល សឋិច ណគ់ ម៉ើ ពែក ប៉ាក់ ហឹ ស្រុក អ៊ែដុម ម៉ើ ជុ ម៉ាត់ មែ ប៉ាគ់ នែ ");
INSERT INTO brb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","យ៉ាគ់ ប៊ែឡា កួន កឡ យ៉ាគ់ ប៊ែអូរ ឡើ បើម សឋិច ពែក ប៉ាក់ ស្រុក អ៊ែដុម កនូ ណគ ហឹ មួង ឌីនហាបា។ ");
INSERT INTO brb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","តគ់ យ៉ាគ់ សឋិច ប៊ែឡា ឡើ គែត យ៉ាគ់ យ៉ូបាប កួន កឡ យ៉ាគ់ ស៊ែរ៉ះ ឡើ មួង បូស្រា ឡើ ឌឹក ពែក ប៉ាក់ ថរ សឋិច ប៊ែឡា។ ");
INSERT INTO brb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","តគ់ យ៉ាគ់ សឋិច យ៉ូបាប ឡើ គែត អ៊ែ យ៉ាគ់ ហ៊ូសាំ តើម ប៊ឹង ប៊្រី ដាក ទែម៉ាន់ អន់ណាវ ឡើ ឌឹក បើម សឋិច ថរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","តគ់ យ៉ាគ់ សឋិច ហ៊ូសាំ ឡើ គែត អ៊ែ យ៉ាគ់ ហាដាត់ កួន យ៉ាគ់ ប៊ែដាត់ អន់ណាវ ឡើ ឌឹក បើម សឋិច ថរ ណគ កនូ ណគ ហឹ មួង អាវីត។ សឋិច អន់នែ ឡើយ ឡើ ប្រិញ ប្រណើម ដើ សុនសាត ម៉ាដៀន ហឹ ស្រុក ម៉ូអាប់។ ");
INSERT INTO brb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","តគ់ យ៉ាគ់ សឋិច ហាដាត់ ឡើ គែត អ៊ែ យ៉ាគ់ សាំឡា តើម ប៊ឹង មួង ម៉ាះរែកា ឡើ ឌឹក បើម សឋិច ពែក ប៉ាក់ ថរ យ៉ាគ់ ហាដាត់។ ");
INSERT INTO brb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","តគ់ យ៉ាគ់ សឋិច សាំឡា ឡើ គែត អ៊ែ យ៉ាគ់ សូល តើម ប៊ឹង មួង រែហូបុត ដៀក ដណៃ អើប៉្រាត ឡើ ឌឹក បើម សឋិច ពែក ប៉ាក់ ថរ យ៉ាគ់ សាំឡា។ ");
INSERT INTO brb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","តគ់ សឋិច សូល ឡើ គែត អ៊ែ យ៉ាគ់ បាលហាណាន់ កួន កឡ យ៉ាគ់ អាកាបូរ អន់ណាវ ឡើ ឌឹក បើម សឋិច ថរ យ៉ាគ់ សូល។ ");
INSERT INTO brb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","តគ់ យ៉ាគ់ សឋិច បាលហាណាន់ កួន កឡ យ៉ាគ់ អាកាបូរ ឡើ គែត អ៊ែ យ៉ាគ់ ហាដារ ឡើ ឌឹក បើម សឋិច ពែក ប៉ាក់ ថរ យ៉ាគ់ បាលហាណាន់ កនូ ណគ ហឹ មួង ប៉ាវ។ ទ្រី យ៉ាគ់ សឋិច ហាដារ ម៉ើ ជុ ម៉ាត់ ណគ មែហ៊ែថាប៊ែល កួន យ៉ាគ់ ម៉ារែត ចូវ យ៉ាគ់ មែសាហាប់។ ");
INSERT INTO brb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","អន់នែ មែ តង់កង់ តើម ប៊ឹង យ៉ាគ់ អ៊ែសាវ តាម ឆ្រាំង មែ កឡឹ តាម កនូ មែ កឡឹ ដិ អន់ដិ ម៉ើ ជុ ម៉ាត់ មែ ប៉ាគ់ នែ យ៉ាគ់ ទីម៉ូណា យ៉ាគ់ អាល់វ៉ា យ៉ាគ់ យែធែត ");
INSERT INTO brb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","យ៉ាគ់ អូហូលីបាម៉ា យ៉ាគ់ អ៊ែឡា យ៉ាគ់ ពីណូន ");
INSERT INTO brb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","យ៉ាគ់ គែណះ យ៉ាគ់ ទែម៉ាន់ យ៉ាគ់ មីបសារ ");
INSERT INTO brb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","យ៉ាគ់ ម៉ាក់ដៀល អំប្រា យ៉ាគ់ អ៊ីរ៉ាម។ មែ លែក អ៊ែ ឡើយ ម៉ើ តង់កង់ សុនសាត អ៊ែដុម ទឹង ប៊្រី ដាក មែ កឡឹ តាម កនូ មែ កឡឹ ដិ អន់ដិ។ យ៉ាគ់ អ៊ែសាវ នែ ឡើយ ម៉ិ យ៉ាគ់ សុនសាត អ៊ែដុម។ ");
INSERT INTO brb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","យ៉ាគ់ យ៉ាកុប ណាគ់ ឡើ គូ ដឌែ ហឹ ស្រុក កាណាន ឡើ ត្រ ស្រុក កនូ បើគ ណគ ឡើ ខើយ ដក់ គូ។ ");
INSERT INTO brb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","អន់នែ ឡើយ កាន បាត់ ក្រាន យ៉ាគ់ យ៉ាកុប។ យ៉ូស៊ែប ទឹង អញុ ណគ ជិត ប៉ឹះ កម៉ ឡើ បយ៉ា បប៊ែ ចៀម អរែង ដើ មែ អ៊ូគ ណគ កួន ណាង ប៊ីលហា អំប្រា ណាង ស៊ីលប៉ា ទ្រី ដូច បើគ ណគ។ យ៉ូស៊ែប នែ ប៊ឹង មែ អ៊ូគ អា ណគ ម៉ើ បើម អន់យូច ឡើ ជឹ ប៉ច ហឹ បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","យ៉ាគ់ អ៊ីស្រាអ៊ែល(ម៉ើ ជុ យ៉ាកុប ដិ) ឡើ ម៉ើត ដើ យ៉ូស៊ែប ជឺរ មែ កួន ណគ លែក អ៊ែ យ៉ាក់ កួន ណគ អន់នែ ឡើ កើត តគ់ ណគ ឡើ ក្រាគ់ៗ ឡើយ។ អ៊ែ ឡើ កាត់ អាវ ឌ្រឹម ទុត ចណុង ចណាគ់ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","មែ អ៊ូគ អា ណគ ម៉ើ តៃ បើគ មែ ឡើ ម៉ើត ដើ យ៉ូស៊ែប ម៉ៃ ជឺរ មែ អ៊ែ ម៉ើ រែម អ៊ឺម ដើម ម៉ើ ចជែ តៃ ញឹម យ៉ាវ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ប៊្លី អ៊ែ យ៉ូស៊ែប ឡើ ពកី អ៊ែ ឡើ ពប៉ច ពកី ដើ មែ អ៊ូគ អា ណគ កម៉ាគ់ ដើ អិះ ហ៊ែង ចាំ ម៉ៃ តៃ ម៉ើ រែម ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ឡើ ហាយ ដើ មែ រៀន៖ «អើយ មែ អ៊ូគ វន់ចង់ហៀង អៃ អំប៉ច ពកី អៃ ដើ វែ អន់ដៃ។ ");
INSERT INTO brb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","អពកី អតៃ ង៉ាយ លែក រ៉ា ង៉ើ បវ ចិះ ហឹ ណា។ ហំប៊្រុះ ដើ អ៊ែ ប្រណវ ចិះ អៃ ឡើ ឌឹក ឆុង ទឹងៗ ប៊្លី អ៊ែ ប្រណវ ចិះ វែ ម៉ើ ដក់ វ៉ាង ឈុំ ប្រណវ ចិះ អៃ ដើម ម៉ើ អង់គុះ កដាប ហំបះ ប្រណវ ចិះ អៃ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","មែ អ៊ូគ អា ណគ ម៉ើ ម៉ាង ដើ ណគ រៀន៖ «ហរៀន ហំបើម សឋិច ដើ ញ៉ា ហំកន់ដ្រាគ់ ពែក ប៉ាក់ ញ៉ា ឡះ?»។ ហ៊ែង ដើ អិះ តៃ ម៉ើ រែម ដើ ណគ ញ៉ន កាន ឡើ ពកី ដើម កាន ចជែ មម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ប៊្លី អ៊ែ យ៉ូស៊ែប ឡើ ពកី ឡឹះ អន់ណាវ អ៊ែ ឡើ ប៉ច ដើ មែ អ៊ូគ អា ណគ រៀន៖ «អៃ អពកី ឡឹះ វ៉ើ ណោះ អតៃ ម៉ាត់ តង៉ៃ កើត ដើម ពតួរ ជិត មូយ ម៉ើ អងគុះ កដាប ហំបះ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ប៊្លី អ៊ែ ឡើ ប៉ច ដើ បើគ ណគ ដិ។ បើគ ណគ ឡើ ម៉ាង រៀន៖ «ហពកី ង៉ាយ ហង់អ៊ិន ប៉ាគ់ អ៊ិន កួន អើយ! ប៉ិ ញឺ មែគ ហៃ ដើម អំម៉ោះ អោះ ហៃ ញន់អង់គុះ កដាប ហំបះ ហៃ ត្រងឺវ ទូត ប្រិះ កឋោះ?»។ ");
INSERT INTO brb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","អ៊ូគ អា ណគ ម៉ើ ចើះ ទុត ខាក់ ដើ យ៉ូស៊ែប ណគ់ ដើ បើគ ណគ អន់ណាវ ឡើ កាំ ជុ កាន ពកី អ៊ែ ទឹង ត្រពិត។ ");
INSERT INTO brb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ប៊្លី អ៊ែ អ៊ូគ អា ណគ ម៉ើ ដក់ បយ៉ា បប៊ែ ចៀម បើគ មែ ហឹ ត្រិញ ចើម មួង ស៊ីគែម។ ");
INSERT INTO brb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ហាយ ដើ កួន ណគ យ៉ូស៊ែប រៀន៖ «អ៊ូគ អា ហៃ ម៉ើ ដក់ បយ៉ា បប៊ែ ចៀម ហឹ ស៊ីគែម។ ហន់ដក់ ហឹ មែ កួន»។ យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «អើគ បើគ»។ ");
INSERT INTO brb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ថាន់ កួន ណគ រៀន៖ «ហន់ដក់ ឝ្លាំង ឡាំង មែ អ៊ូគ អា ហៃ ដើម បប៊ែ ចៀម ណាគ់ មន់ប៉្រាល់ ង៉ាះ។ ប៉ាគ់ ហន់តៃ មែ ហន់ជឹ ពហាយ ដើ អៃ យ៉ឹ»។ យ៉ាគ់ យ៉ាកុប ឡើ ហាយ ដើ យ៉ូស៊ែប លំដក់ តើម ប៊ឹង ធែរ ហ៊ែប្រុន។ អ៊ែ យ៉ូស៊ែប ឡើ ដក់ ប៊ឹះ ហឹ ដៀក មួង ស៊ីគែម។ ");
INSERT INTO brb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","តគ់ អ៊ែ យ៉ូស៊ែប ឡើ សាត វឹញ ដក់ៗ មែ អ៊ូគ អា ណគ ប្លះ ត្រិញ។ បឹ មូយ រ៉ា ឡើ ជូល ណគ ឡើ តង៉ា រៀន៖ «អើយ ម៉ន អង់ង៉ាយ ហសាត?»។ ");
INSERT INTO brb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ណគ ឡើ ត្រណើវ រៀន៖ «អដក់ សាត មែ អ៊ូគ អា អៃ ប៉ ណាគ់ ហតៃ ឡះ ហន់ហាយ ដើ អៃ អុះ ណោះ ហឹ ង៉ាយ ម៉ើ បយ៉ា បប៊ែ ចៀម»។ ");
INSERT INTO brb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","បឹ ហង់អ៊ែ ឡើ ហាយ រៀន៖ «ម៉ើ វីះ ឡើយ តើម ប៊ឹង នែ អដុង ម៉ើ ចជែ រៀន “ញ៉ះ ញន់ដក់ បយ៉ា ហឹ ស៊្រុក ដូថាន តគ់ អន់ណាវ”»។ អ៊ែ យ៉ូស៊ែប ឡើ ដក់ ឆ្រួយ មែ អ៊ូគ អា ណគ ឡើ តៃ មែ ចើម ស៊្រុក ដូថាន ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","19","ហំប៊្រុះ ម៉ើ តៃ ណគ តើម ប៊ឹង ចង៉ាយៗ ទឹង ហូច លំប៊ឹះ ហឹ មែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «តគ់ វន់ឝ្លាំង! យ៉ាគ់ ណាយ ពកី ឡើ ប៊ឹះ ឡើយ!»។ អ៊ែ ម៉ើ ទែង កជែត ណគ ម៉ើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","«ណិះៗ ញ៉ាគ់ ងន់កជែត ណគ ងន់កលីះ តាក់ ទិ រន់ឋូវ អង់ង៉ាយ មូយ អ៊ែ ងន់ប៉ច រៀន ពត្រូវ ឆង៉ាគ់ ឡើ កាប់ ណគ។ ងំបើម ប៉ាគ់ អ៊ិន អ៊ែ ងន់ឝ្លាំង សណិច ពកី ណគ លំដាវ ប លឺ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","រូប៊ែន ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ ងុញ ប៉ូរ អោះ ណគ អាំ លំក្លើច តើម ប៊ឹង ទី មែ។ ឡើ ម៉ាង រៀន៖ «ញ៉ង ងន់កជែត អ៊ឺម ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ឡើ ម៉ាង ឡឹះ រៀន៖ «ញ៉ង វ៉ើ កជែត អ៊ឺម ណគ ឝ៉ាន់ វន់កលីះ ណគ ទិ រន់ឋូវ ហឹ ត្រិញ តគ់ ឆិ ឡើយ សណូវ អឹ វន់បើម ដើ ណគ ញឹះ ឆិ គែត»។ ឡើ ម៉ាង ប៉ាគ់ អ៊ិន យ៉ាក់ ឡើ ម៉ើត ប៉ូរ យ៉ូស៊ែប អាំ លំក្លើច តើម ប៊ឹង ទី មែ អ៊ូគ ណគ អ៊ែ លន់ដូវ ជឹ ឈូន ហឹ បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ហំប៊្រុះ យ៉ូស៊ែប ឡើ ប៊ឹះ តគ់ មែ អ៊ូគ អា ណគ ម៉ើ រ៉ាប់ តោះ ប្រយ អាវ ឌ្រឹម ចណុង ចណាគ់ ហណក ណគ ");
INSERT INTO brb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ប៊្លី អ៊ែ ម៉ើ រ៉ាប់ កលីះ ណគ ទិ រន់ឋូវ ណគ់ រន់ឋូវ អ៊ែ ដាក ឡើ ស្រាក់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ប៊្លី អ៊ែ ម៉ើ ដ្រូម ចង់ ចា ប្រយ។ អ៊ែ ម៉ើ បយ៉ើល ឝ្លាំង ម៉ើ តៃ មែ ពន់ដ្រ សុនសាត អ៊ីសម៉ាអ៊ែល មូយ បូវ ម៉ើ ឈិះ អូត ម៉ើ ប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាឡាត។ បូវ មែ អ៊ែ ម៉ើ ព្រឌុក ឆារ់ គ្លឹម ពែ នែវ ម៉ើ ដក់ ហំពួត ហឹ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","យ៉ាគ់ យូដា ឡើ ម៉ាង ហឹ មែ អំម៉ោះ អោះ ណគ រៀន៖ «ប៉ាគ់ ងន់កជែត អោះ ង៉ាយ នែ ងំអំម៉គ់ ដើ បូវ ប៊ិច អ៊ឺម ខា។ ");
INSERT INTO brb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ញ៉ាគ់ ងន់ហំពួត ណគ ហឹ មែ ពន់ដ្រ តគ់ ងន់កជែត អ៊ឺម ណគ យ៉ាក់ ណគ នែ អោះ ង៉ាយ មូយ បើគ ប៉ាគ់ទឺ»។ អ៊ែ ម៉ើ ផម ប្រយ តាម ម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ប៊ឹង មែ ពន់ដ្រ ម៉ើ ប៊ឹះ អ៊ែ មែ អ៊ូគ អា យ៉ូស៊ែប ម៉ើ ប៊្រឹក ណគ តើម ចុ រន់ឋូវ ប៊្លី អ៊ែ ម៉ើ ហំពួត ណគ ហឹ មែ ពន់ដ្រ ច្រណាប់ បារ ជិត កាក់ ប៉្រាក់។ មែ អ៊ែ ម៉ើ តៀត យ៉ូស៊ែប ហឹ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","តគ់ យ៉ាគ់ រូប៊ែន ឡើ ជឹ វឹញ ហឹ រន់ឋូវ ឡើ តៃ យ៉ាវ យ៉ូស៊ែប អ៊ែ ឡើ សាក ប្រវ៉ើន ហណក ណគ កឡឹ យ៉ាក់ ឡើ បើម ទុត ចនិះ ដើម ឡើ ឝ្រង៉ឹត ស្រូក។ ");
INSERT INTO brb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ប៊្លី អ៊ែ ឡើ ដក់ ហឹ មែ អោះ អូយ ណគ ឡើ ហាយ រៀន៖ «ឡើ ប៉ាត់ ឡើយ យ៉ូស៊ែប! ប៉ាគ់ ង៉ាយ អន់ណាវ អំបើម?»។ ");
INSERT INTO brb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","អ៊ែ ម៉ើ កជែត បប៊ែ សារ មូយ ម៉ើ ចក់ អាវ ឌ្រឹម ចណុង ចណាគ់ ហណក យ៉ូស៊ែប ម៉ើ ចូប លុក ឡុំ ដើ ផាម។ ");
INSERT INTO brb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ប៊្លី អ៊ែ ម៉ើ ជឹ ពដៃ អាវ យ៉ូស៊ែប ហឹ បើគ មែ ម៉ើ ហាយ រៀន៖ «ញ៉ា ញ៉ើ តៃ អាវ នែ ហំហន់នៀប ឝ្លាំង ឡាំង ត្រ ឡះ អាវ កួន ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ហឝ៉ាវ អាវ អ៊ែ ឡើ ម៉ាង រៀន៖ «អាវ កួន អៃ ម៉ាត់ ម៉ាត ឡើយ អន់នែ! អាត ពត្រូវ ឆង៉ាគ់ ឡើយ ឡើ កាប់ សាក ញ៉ះ យ៉ូស៊ែប នែ!»។ ");
INSERT INTO brb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","យ៉ាគ់ យ៉ាកុប ឡើ សាក ប្រវ៉ើន ហណក ណគ កឡឹ អ៊ែ ឡើ ចក់ វ៉ើន កប៉ូវ អន់ណាវ ឡើ ឝ្រង៉ឹត ស្រូក ដើ កួន ណគ ទុត ឌុញ។ ");
INSERT INTO brb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","លែក ដើ កួន ចូវ ណគ តៃ ម៉ាង កទ្រី តៃ ម៉ាង កឡ ម៉ើ ដក់ អូរ ពញឹម ក្លើម ណគ ណាគ់ តៃ ឡើ ឌី ចង់ហៀង មែ តាំង ឡើ ឝ្រង៉ឹត ដឌែ។ ឡើ ម៉ាង រៀន៖ «អៃ អង់ឝ្រង៉ឹត ឋា ដើ អំប៊ឹះ កួន អៃ ហឹ មួង កយ៉ក់!»។ អ៊ែ ឡើ ញឺម ក្រវ៉ើយ ក្រើយ អន់ដូង កួន ណគ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","តៃ នែ ណគ់ ដើ យ៉ូស៊ែប មែ ពន់ដ្រ ម៉ើ តៀត ហឹ ស្រុក អ៊ែស៊ីប ហឹ អ៊ែ ម៉ើ ហំពួត ហឹ យ៉ាគ់ ទិះ ក្រាគ់ ឡើ បើម កាន ដើ សឋិច ម៉ាត់ ណគ ប៉ូទីផារ ឡើ ណាយ ដើ មែ ម៉ើ ញ៉ាម។ ");
INSERT INTO brb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ប៊្លី អ៊ែ យ៉ាគ់ យូដា ឡើ វីះ តើម ប៊ឹង អំម៉ោះ អោះ ណគ ឡើ ដក់ គូ ហឹ បឹ មូយ រ៉ា ម៉ាត់ ណគ ហ៊ីរ៉ា ហឹ ស្រ៊ុក អាឌូឡាម។ ");
INSERT INTO brb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ហឹ អ៊ែ ឡើ តៃ កួន កទ្រី យ៉ាគ់ ស៊ូអា សុនសាត កាណាន អ៊ែ ឡើ ចក់ បើម ទ្រី អំប្រា កី គូ អរែង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","អ៊ែ ទ្រី ណគ ឡើ តមែវ ឡើ អន់ឆិ កួន ណគ ឡើ កឡ អ៊ែ យូដា ឡើ ជុ ម៉ាត់ កួន ណគ “អ៊ែរ”។ ");
INSERT INTO brb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ណាង ឡើ តមែវ ឡឹះ អន់ណាវ ឡើ អន់ឆិ កួន ណគ ឡើ កឡ ប៉ាគ់ទឺ ឡើ ជុ “អូណាន់”។ ");
INSERT INTO brb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ណាង ឡើ ប៊ិច អន់ណាវ កួន កឡ ឡើ ជុ ម៉ាត់ កួន ណគ រៀន “ស៊ែឡា”។ ទឹង ឡើ អន់ឆិ ស៊ែឡា ក្ល ណគ ឡើ គូ ណាគ់ ហឹ ស្រ៊ុក គែស៊ីប ។ ");
INSERT INTO brb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","តគ់ កួន ឡង់ ណគ អ៊ែរ ឡើ ច្រហើវ អ៊ែ យ៉ាគ់ យូដា ឡើ ដក់ ឡា ណាង តាម៉ារ ប្រយ៉ង់ ប៊ឹង កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","អ៊ែរ កួន ឡង់ យ៉ាគ់ យូដា នែ ឡើ បនឹះ បើម តៃ ចាគ់ ឡើ ត្រ អ៊ឺម ទឹង ប្រម៉ើត គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហវ៉ើច ក្រម៉ាត ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ប៊្លី អ៊ែ យ៉ាគ់ យូដា ឡើ ប៉្រៃ កួន ណគ អូណាន់ រៀន៖ «កួន ហន់ហ្រដូវ ម៉ី ហៃ អ៊ែ ហំពឝ៉ើត កួន ត ឆ្រាំង កយ៉ក់ អ៊ូគ ហៃ តាម ខណើយ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","យ៉ាក់ អូណាន់ ឡើ ណោះ រៀន ប៉ាគ់ លំប៊ិច កួន ប៊ឹង ម៉ី ណគ ផវ អឹ លំប៊ិច ម៉ាត់ ដើ ណគ កឡឹ ប៉ាគ់ ពអ៊ែ ប៊ឹង ឡើ កី ដើ ម៉ី ណគ ឡើ ពលូះ តាក់ ហឹ គែង អ៊ែ ញ៉ង លំប៊ិច កួន ត ឆ្រាំង កយ៉ក់ អ៊ូគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","កាន តៃ ចាគ់ ណគ់ ឡើ បើម ប៉ាគ់ អ៊ែ ឡើ ត្រ អ៊ឺម ទឹង ប្រម៉ើត គ្រែដៃ ឡើ ណាគ់ អន់សច អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហវ៉ើច ប៉ាគ់ទឺ ណគ ។ ");
INSERT INTO brb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","តគ់ អ៊ែ យ៉ាគ់ យូដា ឡើ ហាយ ដើ កម៉ាន់ ណគ ណាង តាម៉ារ រៀន៖ «ឆន់កម៉ាយ ពអិះ ឡើយ ម៉ាយ ឆន់ជឹ គូ ហឹ ហន់ណាម បើគ ឆារ កឡឹ អន់ដៃ ឆិ ស៊ែឡា កួន អៃ នែ លំទិះ»។ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ញ៉ន ឡើ ឌូង កួន ណគ លំគែត ប៉ាគ់ ដើ អំប្រា អ៊ូគ ណគ ទឺ។ អ៊ែ ណាង តាម៉ារ ឡើ ជឹ គូ ហឹ ហន់ណាម បើគ ណគ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ទុត ឌុញ តើម ប៊ឹង អ៊ែ ទ្រី យ៉ាគ់ យូដា កួន យ៉ាគ់ ស៊ូអា ឡើ គែត។ តគ់ យ៉ាគ់ យូដា ឡើ ប៉ាត់ ឝ្រង៉ឹត ដើ ទ្រី ណគ អ៊ែ ឡើ ដក់ ហឹ ស្រ៊ុក ទីម៉ូណា អរែង ដើ ពន់តក ណគ យ៉ាគ់ ហ៊ីរ៉ា ស្រ៊ុក អាឌូឡាម បក់ អំប្រា លំដក់ ឝ្លាំង មែ ម៉ើ កាត់ សក់ ចៀម ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ប៊ឹង អ៊ែ ប៊ិច មែ ម៉ើ ដក់ ពហាយ ដើ ណាង តាម៉ារ ម៉ើ រៀន ហឝ៉ៃ បើគ ណគ ឡើ ដក់ កាត់ សក់ ចៀម ណគ ហឹ ស្រ៊ុក ទីម៉ូណា នែ ឡើយ ");
INSERT INTO brb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","អ៊ែ ឡើ តោះ តាក់ អន់ដៃ ប្រវ៉ើន ហណក កម៉ាយ ណគ  ឡើ វ៉ើន ហក អង់គែង អន់ណាវ ដើម ឡើ ចក់ ហំបាន ឡើ ច្រលូម មុះ ម៉ាត់ ណគ ប៊្លី អ៊ែ ឡើ ដក់ ដ្រូម ដៀក ទ្រូង ត្រមឹត ស្រ៊ុក អ៊ែណាអ៊ីម ទ្រូង ម៉ើ ដក់ ហឹ ស៊្រុក ទីម៉ូណា។ ណាង ឡើ បើម ប៉ាគ់ នែ ញ៉ន ឡើ ណោះ ស៊ែឡា ឡើ ច្រហើវ ឡើយ យ៉ាគ់ យូដា ណាគ់ តៃ ឡើ អាំ ដឌែ កួន ណគ លំហ្រដូវ។ ");
INSERT INTO brb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ហំប៊្រុះ យ៉ាគ់ យូដា ឡើ តៃ ណាង ឡើ ឃឹត រៀន កទ្រី ឡាក់លែង។ ឡើ ហឝ៉ាវ អ៊ឺម កម៉ាន់ ណគ យ៉ាក់ ឡើ ច្រលូម មុះ ម៉ាត់ ដើ ហំបាន។ ");
INSERT INTO brb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ឡើ ដក់ តគ់ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «អើយ ហន់ដក់ កី ហឹ អៃ វ៉ៃ!»។ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ញ៉ន ឡើ ណោះ អ៊ឺម កម៉ាន់ ឡើ កឡឹ។ ណាង ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ អៃ អន់តូយ ហៃ អង់ង៉ាយ ហង់អាំ ដើ អៃ ដឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ឡើ ត្រណើវ រៀន៖ «អៃ អំតើវ អាំ កួន បប៊ែ ដើ ហៃ»។ ណាង ឡើ ត្រណើវ រៀន៖ «អើគ ឌី ថលែម ហង់ខាំ រ៉ាះ អង់គែង អន់ដៃ ដើ អៃ ទឹង ហូច បប៊ែ លំប៊ឹះ»។ ");
INSERT INTO brb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","អ៊ែ ឡើ ត្រណើវ ប្រម៉ាង ណាង រៀន៖ «ដើ ង៉ាយ ដឹះ ហម៉ើត អន់អាំ ដើ ហៃ?»។ អ៊ែ ណាង ឡើ ត្រណើវ រៀន៖ «អឡា ហន់អាំ ត្រា ប៉ិងឡឹង ដើម ឆមឺ ហៃ អំប្រា តង អន់ណើង ហៃ ណគ់ ហឝ៉ឹន អ៊ែ»។ យ៉ាគ់ យូដា ឡើ អាំ ដើ ណាង អំប្រា ក្រណី ប្រយ។ អ៊ែ ណាង ឡើ ឌឹក ជឹ ហឹ ហន់ណាម ឡើ តោះ ហំបាន ច្រលូម មុះ ម៉ាត់ ណគ ឡើ វ៉ើន ហក កដាង អាវ កម៉ាយ អន់ទឺ។ ណាង តាម៉ារ នែ ឡើ តមែវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","យ៉ាគ់ យូដា ឡើ ផាក ប្រយ កួន បប៊ែ អាំ ដើ ណាង តាម លញ៉ាគ់ ពន់តក ណគ យ៉ាគ់ ហ៊ីរ៉ា ស្រ៊ុក អាឌូឡាម បក់ លំឡោះ រ៉ាះ ណគ ឡើ អាំ ដើ ណាង ពន់ឋើម ហាក់ ពន់តក ណគ ឡើ ដក់ សាត ឡើ តៃ អ៊ឺម កទ្រី អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ណគ ឡើ តង៉ា មែ ស្រ៊ុក ប្លះ អ៊ែ រៀន៖ «ហឹ ង៉ាយ កទ្រី ឡាក់លែង ឡើ ដ្រូម ដៀក ទ្រូង ត្រមឹត ហឹ ស៊្រុក អ៊ែណាអ៊ីម អិះ?» មែ ម៉ើ ត្រណើវ រៀន៖ «ប៊ិច អ៊ឺម ប កទ្រី ឡាក់លែង ទឹង ស្រ៊ុក ញ៉ា នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ឡើ ជឹ ហាយ ដើ យ៉ាគ់ យូដា រៀន៖ «អសាត កទ្រី ឡាក់លែង អតៃ អ៊ឺម មែ ទឹង ស្រ៊ុក ម៉ើ ហាយ ដើ អៃ រៀន “ប៊ិច អ៊ឺម កទ្រី ឡាក់លែង ទឹង ស្រ៊ុក ញ៉ា នែ”»។ ");
INSERT INTO brb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","យ៉ាគ់ យូដា ឡើ ត្រណើវ រៀន៖ «អាំ ដើ ណាង លំចក់ ហឹ អិះ ឡើយ រ៉ាះ អៃ អ៊ែ ញ៉ង ហន់តង៉ា សាត ដាំង យ៉ាវ ឝ៉ាន់ បន់កម៉ាវ យួរ ដើ មែ ក្លាង ស្រ៊ុក អៃ អខំ ឈូន កួន បប៊ែ ដើ ណាង ណាគ់ តៃ ហតៃ អ៊ឺម!»។ ");
INSERT INTO brb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ពែ ខៃ អ្យាង តើម ប៊ឹង អ៊ែ ប៊ិច មែ ម៉ើ ពហាយ ដើ យ៉ាគ់ យូដា រៀន៖ «កម៉ាន់ ហៃ ណាង តាម៉ារ ឡើ បើម ប៉ាគ់ កទ្រី ឡាក់លែង ឡើយ ណិះៗ នែ ដើម ឡើ តមែវ ដិ»។ យ៉ាគ់ យូដា ឡើ ម៉ាង រៀន៖ «វន់ទឹក ពញឺះ ណគ ហឹ អរ៉ះ វន់ប៊ុះ ណគ ញិវៗ អិះ ឡើយ!» ");
INSERT INTO brb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ទឹង ម៉ើ ទឹក ពញឺះ ណគ ហឹ អរ៉ះ ណាង តាម៉ារ ឡើ ប៉្រៃ មែ ជឹ តៀត ពដៃ រ៉ាះ ខណាំ នែ ហឹ យ៉ាគ់ យូដា រៀន៖ «ឡា វន់ប៉្រៃ ហឝ៉ៃ បើគ អៃ រៀន “អៃ អតមែវ ដើ កន់ដ្រាគ់ រ៉ាះ អន់នែ ឡើយ ហន់ឝ្លាំង ត្រា ប៉ិងឡឹង ដឹប ឆមឺ ដើម តង អន់ណើង នែ រ៉ាះ មែ ង៉ាយ?”»។ ");
INSERT INTO brb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","យ៉ាគ់ យូដា ឡើ ហង់ឝ៉ាវ រ៉ាះ ណគ ឡើ ម៉ាង រៀន៖ «យ៉ី! ត្រ ឡើយ ណគ នែ អៃ អយូច ដើ ណគ ញ៉ន តៃ អអាំ កួន អៃ ស៊ែឡា លន់ចក់ បើម ទ្រី»។ យ៉ាគ់ យូដា ឡើ កី ដើ កម៉ាន់ ណគ វ៉ិះ មូយ តង អិះ ឡើយ តើម ប៊ឹង អ៊ែ ឡើ ឌី យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","តគ់ ណាង តាម៉ារ ឡើ ណុះ ខៃ អ៊ែ ម៉ើ ណោះ ឡើ តមែវ ប្លឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","តគ់ ឡើ អន់ឆិ ណគ់ កួន លមូយ ឡើ ញឺះ ទី អន់នួរ អ៊ែ យ៉ាគ់ បយ ឡើ រ៉ាប់ ទី អង់អាង ចង ដើ ប្រាយ ចះ ឡើ ម៉ាង រៀន៖ «កួន អន់នែ ឡើ កើត អន់នួរ»។ ");
INSERT INTO brb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ហាក់ ណគ់ អង់អាង អ៊ែ ឡើ ញ៉ាក់ ទី ណគ ទឹង ទឺ អ៊ែ កួន លមូយ អន់ណាវ ឡើ ទឺះ។ យ៉ាគ់ បយ ឡើ ម៉ាង រៀន៖ «ហៃ នែ ហកន់តើម ទឺះ អន់នួរ!» អ៊ែ ម៉ើ ជុ ម៉ាត់ ណគ “ពែរែះ”។ ");
INSERT INTO brb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ប៊្លី អ៊ែ កួន ណគ់ ម៉ើ ចង ដើ ប្រាយ ចះ អន់ណាវ ឡើ ទឺះ ម៉ើ ជុ ម៉ាត់ ណគ “ស៊ែរ៉ះ”។ ");
INSERT INTO brb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","អ៊ែ ណគ់ ដើ យ៉ូស៊ែប បូវ មែ ពន់ដ្រ ម៉ើ តៀត ណគ ហឹ ស្រុក អ៊ែស៊ីប អ៊ែ ម៉ើ ហំពួត ណគ ហឹ យ៉ាគ់ ទិះ ក្រាគ់ សុនសាត អ៊ែស៊ីប ឡើ បើម កាន ដើ សឋិច ម៉ាត់ ណគ ប៉ូទីផារ ណគ នែ ឡើយ ឡើ ណាយ ដើ មែ ម៉ើ ញ៉ាម ។ ");
INSERT INTO brb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ លវាំង ឝ្លាំង យ៉ូស៊ែប ទឹង ឡើ គូ ហឹ ហន់ណាម កន់ដ្រាគ់ ណគ សុនសាត អ៊ែស៊ីប អ៊ែ កាន ណគ់ អង់ង៉ាយៗ ឡើ បើម ដូវ លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","កន់ដ្រាគ់ ណគ ឡើ តៃ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ លវាំង ឝ្លាំង យ៉ូស៊ែប ដើម ឡើ បើម អាំ កាន ណគ ឡើ ពឹត ចាគ់ លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","អ៊ែ យ៉ាគ់ ប៉ូទីផារ ឡើ ញឹម ក្លើម ដើ យ៉ូស៊ែប ឡើ ពឌឹក ណគ លំបើម ឞយ ដើ ណគ កឡឹ ហន់ដឹប លំបើម ណាយ ដើ មែ ក៝ត ម៉ើ ពពឹត ទឹង ហន់ណាម ក្រាន ណគ។ អ៊ែ យ៉ូស៊ែប ឡើ រន់ឋាប់ ឝ្លាំង លែក ដើ ប្រនិច ប្រណាក់ កន់ដ្រាគ់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","តើម ប៊ឹង យ៉ាគ់ ប៉ូទីផារ ឡើ ពឌឹក យ៉ូស៊ែប ឝ្លាំង កាន យូច ត្រ ទឹង ហន់ណាម ក្រាន ណគ ដើម ប្រនិច ប្រណាក់ ណគ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ អន់ណាំ ដើ ក្រាន យ៉ាគ់ ប៉ូទីផារ សុនសាត អ៊ែស៊ីប ញ៉ន ដើ យ៉ូស៊ែប។ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប្រាយ លែក ដើ ប្រនិច យ៉ាគ់ ប៉ូទីផារ តៃ ម៉ាង ទឹង ហន់ណាម ក្រាន តៃ ម៉ាង ហឹ មឺរ ណា លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ប៉ាគ់ ពអ៊ែ យ៉ាគ់ ប៉ូទីផារ ឡើ អាំ ដើ យ៉ូស៊ែប រន់ឋាប់ ឝ្លាំង លែក ដើ ប្រនិច ណគ ញឹះ តៃ ឡើ លវ៉ឹន ដើ ង៉ាយ យ៉ាវ វ៉ិះ ឌិវ ចណង់ ចណា ណាគ់ ឡើ ឃឹត។ យ៉ាគ់ យ៉ូស៊ែប នែ មុះ ម៉ាត់ ចាក់ ដៃ ណគ ចាគ់ ចង់ឝ្រ៉ាង។ ");
INSERT INTO brb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","តគ់ ប៊្លី អ៊ែ ទ្រី យ៉ាគ់ ប៉ូទីផារ តូវ ឡើ ហង់កៀរ ឝ្លាំង យ៉ូស៊ែប ឡើ ច្រា រៀន៖ «ដក់ ហន់ដក់ កី ហឹ អៃ អើយ!»។ ");
INSERT INTO brb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","យ៉ូស៊ែប ឡើ ឌី អ៊ឺម អ៊ែ ឡើ ម៉ាង ដើ ទ្រី កន់ដ្រាគ់ ណគ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អៃ ឡើ អាំ លែក ដើ ប្រនិច ណគ ដើ អៃ អរន់ឋាប់ ឝ្លាំង ណគ កឡឹ តៃ ឡើ លវ៉ឹន យ៉ាវ ដើ ពនឹត បណើម ទឹង ហន់ណាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ទឹង ហន់ណាម ក្រាន នែ មែ ង៉ាយ អ៊ឺម មន់ទិះ ជឺរ អៃ ឡើ អាំ អៃ អពឹត អង់ង៉ាយៗ ទឹង ហន់ណាម នែ ដូវ លែក អិះ វ៉ិះ ឌិវ ហៃ ឡើយ ឡើ អាំ អ៊ឺម អំរួយ រីង យ៉ាក់ ហៃ នែ ហទ្រី ណគ។ ដូវ អ៊ឺម អៃ អំបើម អន់យូច ទិះ ឞាល់ នែ អំយូច ទឹង គ្រែដៃ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","សំយ៉ះ កទ្រី នែ តាំង ឡើ អៀត មៀង ពន់ទែប យ៉ូស៊ែប ត្រំ តង៉ៃ ច្រា កី ប៊ឹង ណគ យ៉ូស៊ែប ណាគ់ តៃ ឡើ ឌី ដឌែ កី ប៊ឹង ណគ ហម ឡើ ដក់ ពន់ចើម ណាគ់ តៃ ឡើ ឌី ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","តគ់ តង៉ៃ ហង់អ៊ិន យ៉ូស៊ែប ឡើ មឹត បើម កាន ហឹ កនុង ហន់ណាម ទឹង តង៉ៃ អ៊ែ ប៊ិច អ៊ឺម មែ ក៝ត ទឹង ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","អ៊ែ ទ្រី យ៉ាគ់ ប៉ូទីផារ ឡើ រ៉ាប់ យ៉ូស៊ែប ប៊ឹង អាវ ឡើ ម៉ាង រៀន៖ «ហន់ដក់ កី ប៊ឹង អៃ អើយ!»។ យ៉ូស៊ែប ឡើ តាក់ អាវ ណគ ណាគ់ ប៊ឹង ទី ទ្រី យ៉ាគ់ ប៉ូទីផារ ឡើ អ្រយ៉ាវ ញឺះ ហឹ អរ៉ះ។ ");
INSERT INTO brb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ទ្រី យ៉ាគ់ ប៉ូទីផារ ឡើ តៃ យ៉ូស៊ែប ឡើ ញឺះ អ្រយ៉ាវ តាក់ អាវ ប៊ឹង ទី ណគ ប៉ាគ់ អ៊ែ ");
INSERT INTO brb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","អ៊ែ ឡើ កឡូវ បូវ មែ ក៝ត ណគ ឡើ រៀន៖ «អើយ នែ វន់ឝ្លាំង បឹ សុនសាត ហ៊ែប្រើ អន់នែ ណគ់ ក្ល អៃ ឡើ រួត ជឹ តៀត ហឹ ង៉ាយ អាំ ង៉ាយ ងន់ឆាំ ឆោះ ក៝ត អ៊ែ ឡើ មឹត ហឹ អៃ ឡើ ងុញ កី ដ្រូក ដើ អៃ អ៊ែ អហរ៉ាវ ទុត ថាំង។ ");
INSERT INTO brb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","តគ់ ឡើ ដុង អៃ អហរ៉ាវ ថាំងៗ អ៊ែ ឡើ តាក់ អាវ ណគ ប៊ឹង អៃ ឡើ អ្រយ៉ាវ ញឺះ ហឹ អរ៉ះ»។ ");
INSERT INTO brb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ទ្រី យ៉ាគ់ ប៉ូទីផារ នែ ឡើ ជុ អាវ យ៉ូស៊ែប ណាគ់ ហឹ ណគ ឆា ដើ ប៊ឹះ ក្ល ណគ លន់ជឹ។ ");
INSERT INTO brb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","តគ់ ក្ល ណគ ឡើ ជឹ ឡើ ប៉ច ប៉ាគ់ អន់ឌូ ទឺ រៀន៖ «បឹ សុនសាត ហ៊ែប្រើ ណគ់ ហៃ ហរួត ជឹ តៀត បើម ក៝ត ហឹ ង៉ាយ ឡើ មឹត ហឹ អៃ ឡើ ងុញ កី ដ្រូក ដើ អៃ ឡើ បើម អាំ អើ ឆាំ ឆោះ ហណោះ។ ");
INSERT INTO brb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ពញ៉ង អហរ៉ាវ អកឡូវ ថាំងៗ អ៊ែ ឡើ តាក់ អាវ ណគ ប៊ឹង អៃ ឡើ អ្រយ៉ាវ ញឺះ ហឹ អរ៉ះ»។ ");
INSERT INTO brb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","យ៉ាគ់ ប៉ូទីផារ ហំប៊្រុះ ឡើ ដុង ទ្រី ណគ ឡើ ហាយ រៀន ក៝ត ណគ ឡើ ងុញ បើម តៃ ចាគ់ ដើ ទ្រី ណគ អ៊ែ ឡើ មាំ ដើ យ៉ូស៊ែប ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ឡើ ប៉្រៃ មែ ម៉ើ ដក់ រ៉ាប់ យ៉ូស៊ែប ក្រាន់ ទឹង ឃុក ឡើ ត្រ ឃុក មែ ម៉ើ បើម អន់យូច ដើ សឋិច។ ប៊ឹង យ៉ូស៊ែប ឡើ គូ ទឹង ឃុក ");
INSERT INTO brb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","គ្រែដៃ ឡើ ណាគ់ អន់សច ណាគ់ ឡើ លវាំង ឝ្លាំង ណគ ឡើ ពដៃ កាន ស្រុស្រៀត បៀត ឡើ បើម អាំ ណាយ ពចាំ ឃុក លំញឹម ក្លើម ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ណាយ ពចាំ ឃុក ឡើ ប៉្រៃ យ៉ូស៊ែប ឡើ រន់ឋាប់ ឝ្លាំង លែក ដើ មែ ម៉ើ ថូត ដើម លែក ដើ កាន អង់ង៉ាយៗ មែ ម៉ើ ពឹត បើម ទឹង ឃុក។ ");
INSERT INTO brb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ណាយ ពចាំ ឃុក តៃ ឡើ លវ៉ឹន យ៉ាវ ដើ កាន ណគ ណគ់ ឡើ អាំ ដើ យ៉ូស៊ែប ពឹត បើម យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ លវាំង ឝ្លាំង យ៉ូស៊ែប អ៊ែ ណគ់ កាន អង់ង៉ាយៗ យ៉ូស៊ែប ឡើ បើម ដូវ លែក អិះ។ ");
INSERT INTO brb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ប៊្លី អ៊ែ ប៊ិច បនឹះ ទិះ ក្រាគ់ បារ រ៉ា អំប្រា បើម អន់យូច ដើ សឋិច អ៊ែស៊ីប កន់ដ្រាគ់ អំប្រា។ បឹ មូយ រ៉ា ឡើ ណាយ មែ ម៉ើ ឈូន តវែ ដើ សឋិច បឹ លមូយ អន់ណាវ ឡើ ណាយ មែ ម៉ើ បើម ណំពាំង ដើ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","យ៉ាគ់ សឋិច ឡើ មាំ ដើ អំប្រា ទិះ ក្រាគ់ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","អ៊ែ ឡើ ប៉្រៃ មែ ម៉ើ ដក់ រ៉ាប់ អំប្រា ក្រាន់ ទឹង ឃុក ឃុក នែ ឡើ ត្រ ទឹង ហន់ណាម យ៉ាគ់ ឡើ ណាយ ដើ មែ ម៉ើ ញ៉ាម។ ទឹង អ៊ែ ទឺ ម៉ើ ក្រាន់ យ៉ូស៊ែប។ ");
INSERT INTO brb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ណាយ ពចាំ ឃុក ឡើ ប៉្រៃ យ៉ូស៊ែប លំបើម ឞយ អំប្រា។ អ៊ែ អំប្រា នែ អំប្រា គូ ទឹង ឃុក ទុត ឌុញ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","មាំង ហង់អ៊ិន អំប្រា ពកី លែក អំប្រា ហាក់ អំប្រា តៃ ដិ អន់ដិ ប្លះ អំប្រា ដើម នឿណៃ ដិ អន់ដិ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","តគ់ ងឹប ប្រណូវ យ៉ូស៊ែប ឡើ ដក់ ហឹ អំប្រា ឡើ តៃ អំប្រា តង៉ូក ឆ្រុក ហ្រឆូយ ");
INSERT INTO brb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","អ៊ែ យ៉ូស៊ែប ឡើ តង៉ា អំប្រា រៀន៖ «ប៉ិ ឡើ ត្រ តង៉ៃ នែ សប្រា តង៉ូក ឆ្រុក ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","អំប្រា ត្រណើវ រៀន៖ «ញឺ ញ៉ើ ពកី មាំង អ៊ិន ដិ អន់ដិ ប្លះ ញឺ ហាក់ ទឹង នែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ តួង ពកី ញឺ»។ យ៉ូស៊ែប ឡើ ហាយ ដើ អំប្រា រៀន៖ «វ៉ិះ ប៊ិច ឌិវ គ្រែដៃ ឡើ ណោះ នឿណៃ ពកី! ប៉ាគ់ ង៉ាយ ដឹះ សប្រា ពកី សប្រា លំហាយ ឡាំង ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ណាយ មែ ម៉ើ ឈូន តវែ ដើ សឋិច ឡើ ប៉ច ពកី ណគ ដើ យ៉ូស៊ែប រៀន៖ «អពកី អតៃ តើម ឈឹង ជែម មូយ តើម ប៊ឹង ងឺរ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","តើម ឈឹង ជែម អ៊ែ ឡើ ប៊ិច ឝឹង ពែ ឡើ ពន់តង ឡើ ពឺរ ប៉្លៃ ឌុំ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ដើម អឝ៉ឹន ប៊ែង សឋិច អប៉ិះ ប៉្លៃ ឈឹង ជែម អប៉ាត់ ទិ ប៊ែង លែវ អ៊ែ អឈូន ដើ សឋិច»។ ");
INSERT INTO brb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","យ៉ូស៊ែប ឡើ ហាយ ដើ ណគ រៀន៖ «ពកី ហៃ អ៊ិន ឡើ ត្រ ប៉ាគ់ នែ ពែ ឝឹង អ៊ែ ពែ តង៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","តើម ប៊ឹង នែ ណាគ់ ពែ តង៉ៃ សឋិច លំពញឺះ ដើម លំពឌឹក ហៃ បើម កាន អន់ទឺ។ ហៃ ហន់ឈូន តវែ ដើ សឋិច ប៉ាគ់ ហៃ ហខើយ ពន់ឋើម ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ហាក់ តគ់ ហន់ហ្រនុក ហ្រវ៉ាក ឡើយ ញ៉ង ហវឺញ អ៊ឺម ប៉ាគ់ទឺ អៃ ហន់ស្រុស្រៀត អៃ។ ឡា ហំចជែ ប៉ូរ ហឹ សឋិច អាំ លំណោះ កាន អៃ អ៊ែ អន់ដូវ ញឺះ ប៉ាគ់ទឺ តើម ប៊ឹង ឃុក។ ");
INSERT INTO brb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","យ៉ាក់ ម៉ើ រ៉ាប់ តៀត អៃ តើម ប៊ឹង ស្រុក ញ៉ា សុនសាត ហ៊ែប្រើ អគូ ហឹ ស្រុក អ៊ែស៊ីប នែ ប៊ិច អ៊ឺម អំបើម អន់យូច អ៊ែ ឆិ ម៉ើ ជុ អៃ ទឹង ឃុក ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","បឹ ឡើ ណាយ មែ ម៉ើ បើម ណំពាំង ដើ សឋិច ឡើ ដុង យ៉ូស៊ែប ឡើ ពហាយ នឿណៃ ពកី ឡើ ញឹម ប៉ាគ់ នែ អ៊ែ ឡើ ហាយ ប៉ាគ់ទឺ ពកី ដើ យ៉ូស៊ែប រៀន៖ «អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អពកី ប៉ាគ់ទឺ អតៃ អដូល ណុំ ពែ ហនូក។ ");
INSERT INTO brb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ទឹង កនុង ហនូក ពឹង ពឺង ឡើ ប៊ិច ណុំ ត្រំ ហំឞ្លិច ប៉ាគ់ សឋិច ឡើ ខើយ ចា។ ពញ៉ង ឡើ ប៊ិច ជែម ម៉ើ ទឺះ ក្លក់ ណុំ ទឹង ហនូក ពឺង ទូះ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","យ៉ូស៊ែប ឡើ ហាយ ដើ ណគ រៀន៖ «ពកី ហៃ អ៊ិន ឡើ ត្រ ប៉ាគ់ នែ ហនូក លែក ពែ អ៊ែ ពែ តង៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","តើម ប៊ឹង នែ ណាគ់ ពែ តង៉ៃ អន់ណាវ សឋិច លំពញឺះ ហៃ មន់ដក់ ទុង យុង ហៃ ប៊ឹង តើម ឡង អ៊ែ ជែម មន់ទឺះ ក្លក់ ច្រឡាត ម៉ាត ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","តើម ប៊ឹង អ៊ែ ពែ តង៉ៃ ឡើ ត្រ តង៉ៃ ឞ៊ុន កណើត សឋិច យ៉ាគ់ សឋិច ឡើ បើម ឞ៊ុន ទុត ទិះ អាំ លែក ដើ មែ ទិះ ក្រាគ់ មន់ដក់ ញែត ចា។ ប៊ឹង អ៊ែ សឋិច ឡើ ប៉្រៃ មែ ម៉ើ ដក់ តោះ ពញឺះ អំប្រា តៀត ហឹ ងឺរ មែ ទិះ ក្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","សឋិច ឡើ ពឌឹក បឹ ឡើ ណាយ មែ ម៉ើ ឈូន តវែ ដើ ណគ លំបើម កាន ណគ ប៉ាគ់ ពន់ឋើម ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ហាក់ សឋិច ឡើ ប៉្រៃ ម៉ើ ដក់ ចង ទុង យុង បឹ ឡើ ណាយ មែ ម៉ើ បើម ណំពាំង ឡើ ដាវ ប៉ាគ់ ប្រម៉ាង យ៉ូស៊ែប ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","អ៊ែ ណគ់ បឹ ឡើ ណាយ មែ ម៉ើ ឈូន តវែ ដើ សឋិច ឡើ វឺញ ហឹ យ៉ូស៊ែប ខៀង។ ");
INSERT INTO brb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","បារ កម៉ តើម ប៊ឹង អ៊ែ សឋិច អន់ណាវ ឡើ ពកី ឡើ ឆុង ប៊ឹង ពឹះ ដណៃ នីល។ ");
INSERT INTO brb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ឡើ តៃ ឝ៉ូ យូ ប៉ឹះ អំប៉ម ម៉ាត់តូវ ត្រចាគ់ៗ បិញៗ ម៉ើ ញឺះ ឌឹក តើម ចុ ដាក ដណៃ ម៉ើ ចា បាត់ បរ ពឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ប៊្លី អ៊ែ ឡើ តៃ ឝ៉ូ យូ ស្រាៗ វ៉ិះ ឌិវ កឌឺងៗ ប៉ឹះ អំប៉ម អន់ណាវ ម៉ើ ញឺះ ឌឹក តើម ចុ ដាក ដណៃ ម៉ើ ដក់ តៃ ត្រិច ឝ៉ូ ត្រទិះ ម៉ើ គូ បរ ពឹះ ដៀក ឝ៉ូ ត្រទិះ ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ឝ៉ូ យូ ស្រាៗ ឌិវ កឌឺងៗ ម៉ើ លឹន ឝ៉ូ យូ ត្រចាគ់ៗ បិញៗ ប៉ឹះ អំប៉ម លែក តាក់។ អ៊ែ យ៉ាគ់ សឋិច ឡើ រ៉ៃ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ប៊្លី អ៊ែ ឡើ ហង់ង៉ាន់ ឡឹះ អ៊ែ ឡើ ពកី អន់ណាវ។ ឡើ តៃ ចិះ ឡើ ហួន មូយ ឡង ឡើ ប៉្លៃ ប៉ឹះ ហ្រកង់ តូវ ឡើ តំពុំ ចាក់ៗ។ ");
INSERT INTO brb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ប៊្លី អ៊ែ ឡើ តៃ ចិះ ប៉ឹះ ហ្រកង់ អន់ណាវ ឡើ ហួន អន់ទុន តើម ប៊ឹង ឡង អន់ទឺ ឡើ ហួញ ញ៉ិប តូវ ឡើ ច្រាំ ដើ កយឺវ ដុ ឡើ ពឹក តើម ប៊ឹង ម៉ាត់ តង៉ៃ ឌឹក។ ");
INSERT INTO brb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ហ្រកង់ ចិះ ញ៉ិបៗ ឡើ លឹន ហ្រកង់ ចិះ តំពុម ចាក់ៗ ប៉ឹះ ហ្រកង់ លែក តាក់។ យ៉ាគ់ សឋិច ឡើ រ៉ៃ ឡើ ឃឹត រៀន៖ «អូ អពកី ហន់ឆា»។ ");
INSERT INTO brb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","តគ់ ងឹប ប្រណូវ យ៉ាគ់ សឋិច ឡើ តង៉ូក ឆ្រុក ឆ្រូយ ប្រយ អ៊ែ ឡើ កឡូវ លែក ដើ មែ ប៊ិច ឝ្រូ ដើម លែក ដើ មែ ម៉ើ ហ្រឡិច ហ្រឡាង ទឹង ស្រុក អ៊ែស៊ីប ម៉ើ ដក់ ហឹ ណគ អ៊ែ ឡើ ពប៉ច ដើ មែ ហាក់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ តួង ពកី ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ប៊ឹង អ៊ែ បឹ ឡើ ណាយ មែ ម៉ើ ឈូន តវែ ឡើ ហាយ ដើ សឋិច រៀន៖ «តង៉ៃ នែ អៃ អចនិះ ហឹ កាន អបើម អន់យូច ពន់ឋើម ដើម អងុញ ហាយ ដើ ហៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ប៊ឹង ហៃ ហមាំ ដើ ញឺ ហប៉្រៃ មែ ម៉ើ ដក់ រ៉ាប់ អៃ ដើម បឹ ណាយ មែ ម៉ើ បើម ណំពាំង ម៉ើ ក្រាន់ ទឹង ឃុក ឃុក នែ ឡើ ត្រ ទឹង ហន់ណាម យ៉ាគ់ ឡើ ណាយ ដើ មែ ម៉ើ ញ៉ាម។ ");
INSERT INTO brb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","មាំង អ៊ែ ញ៉ើ ពកី លែក ដើ ញឺ ហាក់ នឿណៃ ដិ អន់ដិ ប្លះ ញឺ។ ");
INSERT INTO brb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ទឹង ញ៉ើ គូ ឃុក ប៊ិច ច្រហើវ មូយ រ៉ា ឡើ សុនសាត ហ៊ែប្រើ ឡើ ក៝ត ណាយ មែ ម៉ើ ញ៉ាម ឡើ គូ ឃុក អរែង ប៊ឹង ញឺ។ ញ៉ើ ប៉ច ពកី ញឺ ដើ ណគ អ៊ែ ឡើ ហាយ នឿណៃ ពកី ញឺ មូយ រ៉ាៗ ដិ អន់ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","តគ់ ប៊្លី អ៊ែ ឡើ ដាវ ប៉ាគ់ ប្រម៉ាង ណគ ឡើ ហាយ ម៉ាត់ ម៉ាត អ៊ែ ហៃ ហអាំ អៃ អបើម កាន អន់ទឺ អន់ណាវ បឹ មូយ រ៉ា អន់ណាវ ហប៉្រៃ ម៉ើ ចង ទុង យុង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","យ៉ាគ់ សឋិច ឡើ ប៉្រៃ មែ ម៉ើ ដក់ ចក់ ពញឺះ យ៉ូស៊ែប ដ្រិះៗ ប្រយ តើម ប៊ឹង ឃុក។ អ៊ែ យ៉ូស៊ែប ឡើ កូរ សក់ ម៉ូង កាង ណគ ដើម ឡើ ពលិះ ត្រទ្រូប ហហក ប៊្លី អ៊ែ ម៉ើ តៀត ណគ ហឹ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","សឋិច ឡើ ហាយ ដើ យ៉ូស៊ែប រៀន៖ «ពកី អៃ អ៊ិន តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ តួង។ អដុង ម៉ើ ប៉ច ដើ អៃ រៀន ប៉ាគ់ ម៉ើ ប៉ច ពកី មែ ដើ ហៃ ហៃ ហណោះ តួង»។ ");
INSERT INTO brb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ សឋិច អើយ ត្រ អ៊ឺម អៃ អណោះ តួង ពកី! វ៉ិះ ឌិវ គ្រែដៃ ឡើយ លំណោះ ហាយ នឿណៃ ពកី ហៃ អ៊ែ ហន់ញឹម ក្លើម»។ ");
INSERT INTO brb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ប៊ឹង អ៊ែ យ៉ាគ់ សឋិច ឡើ ហាយ ដើ យ៉ូស៊ែប រៀន៖ «ដើ អៃ អពកី អឆុង ប៊ឹង ពឹះ ដណៃ នីល។ ");
INSERT INTO brb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","អតៃ ឝ៉ូ យូ ប៉ឹះ អំប៉ម ម៉ាត់តូវ ត្រចាគ់ៗ បិញៗ ម៉ើ ញឺះ ឌឹក តើម ចុ ដាក ដណៃ ម៉ើ ចា បាត់ បរ ពឹះ។ ");
INSERT INTO brb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ប៊្លី អ៊ែ អន់ណាវ អតៃ ឝ៉ូ យូ ស្រាៗ វ៉ិះ ឌិវ កឌឺងៗ ប៉ឹះ អំប៉ម ម៉ើ ញឺះ ឌឹក តើម ចុ ដាក ដណៃ តៃ ត្រិច ឝ៉ូ ត្រទិះ។ តើម ពន់ឋើម លែក ទឹង ស្រុក អ៊ែស៊ីប នែ អខើយ អ៊ឺម តៃ ឝ៉ូ ស្រាៗ ញឹះ តៃ ចាគ់ ឞាល់ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ឝ៉ូ ស្រាៗ វ៉ិះ ឌិវ កឌឺងៗ ម៉ើ លឹន ប្រយ ឝ៉ូ យូ ត្រចាគ់ៗ បិញៗ ប៉ឹះ អំប៉ម ណគ់ ម៉ើ ឌឹក អន់នួរ អន់ឌូ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","សំយ៉ះ ឝ៉ូ យូ ស្រាៗ ម៉ើ លឹន ឝ៉ូ ទិះៗ ក្លើច ទិ ពឌិវ ឡើយ ណាគ់ តៃ អតៃ អ៊ឺម មន់ទិះ ម៉ើ ស្រា ប៉ាគ់ អំប៊ី ទឺ ហំប៊្រុះ ដើ អ៊ែ អរ៉ៃ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ប៊្លី អ៊ែ អហង់ង៉ាន់ ឡឹះ អពកី អន់ណាវ អតៃ ចិះ ឡើ ហួន មូយ ឡង ឡើ ប៉្លៃ ប៉ឹះ ហ្រកង់ តូវ ឡើ តំពុំ ចាក់ៗ ");
INSERT INTO brb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ប៊្លី អ៊ែ អតៃ ចិះ ប៉ឹះ ហ្រកង់ អន់ណាវ ឡើ ហួន អន់ទុន តើម ប៊ឹង ឡង អន់ទឺ ឡើ ហួញ ញ៉ិប ឡើ ច្រាំ តូវ ឡើ ខិញ ដើ កយឺវ ដុ ឡើ ពឹក តើម ប៊ឹង ម៉ាត់ តង៉ៃ ឌឹក។ ");
INSERT INTO brb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ហ្រកង់ ចិះ ញ៉ិបៗ ឡើ លឹន ហ្រកង់ ចិះ ចាក់ៗ ប៉ឹះ ហ្រកង់ លែក តាក់។ អប៉ច លហម ដើ មែ ម៉ើ ប៊ិច ឝ្រូ ណាគ់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ ហាយ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","យ៉ាគ់ យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ សឋិច អើយ ពកី ហៃ លែក បារ អ៊ិន ប៉ាគ់ទឺៗ គ្រែដៃ ឡើ ពដៃ ដើ ហៃ អាំ ហន់ណោះ អន់នួរ កាន ណគ ដៀប លំបើម ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ឝ៉ូ យូ ត្រចាគ់ៗ ប៉ឹះ អំប៉ម អ៊ែ ឡើ ត្រ ប៉ឹះ កម៉ អ៊ែ ណគ់ ហ្រកង់ ចិះ ចាក់ៗ ប៉ឹះ ហ្រកង់ អ៊ែ ប៉ឹះ កម៉ ប៉ាគ់ទឺ ពកី ហៃ លែក បារ អ៊ិន ប៉ាគ់ទឺៗ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ឝ៉ូ យូ ស្រាៗ ឌិវ កឌឺងៗ ប៉ឹះ អំប៉ម ម៉ើ ឌឹក អន់ទុន អ៊ែ ដើម ចិះ ប៉ឹះ ហ្រកង់ ញ៉ិបៗ ឡើ ច្រាំ ញ៉ន ដើ កយឺវ ដុ ឡើ ពឹក តើម ប៊ឹង ម៉ាត់ តង៉ៃ ឌឹក អ៊ែ ឡើ ប៊ិច នឿណៃ ឌិវ មូយ ឡើ ត្រ មន់អឹត ហរុ ប៉ឹះ កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","កាន នែ ឡើ ត្រ ប៉ាគ់ អៃ អហាយ ដើ ហៃ អន់ឌូ ឡើយ គ្រែដៃ ឡើ ពដៃ អាំ ហៃ ហន់ណោះ អន់នួរ កាន ណគ ដៀប លំបើម ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","លំប៊ិច ប៉ឹះ កម៉ លែក ដើ ស្រុក អ៊ែស៊ីប មន់ដូវ ចិះ ភែ ផិ ប៊ិង ស៊ិវ សាគ់ ណាគ់ គ្លឺយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ប៊្លី អ៊ែ មន់អឹត ហរុ ប៉ឹះ កម៉ ប៉ាគ់ទឺ កាន អឹត ហរុ នែ លំបើម អាំ មែ ទឹង ប៊្រី ដាក អ៊ែស៊ីប មន់ងួត ឝ៉្លក ស្រក ក្លឹះ តូវ មន់វឺញ ហឹ កាន ផិ ប៊ិង ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","យ៉ាក់ មែ ក្លាង ស្រ៊ុក មន់អឹត ហរុ ម៉ៃ ហ៊ែត អ៊ែ មន់ចនិះ យ៉ាវ ហឹ កម៉ ម៉ើ ប៊ិច ស៊ិវ សាគ់ ណាគ់ គ្លឺយ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ហពកី ញឹះ បារ តង យ៉ាក់ គ្រែដៃ លំបើម កាន នែ ម៉ាត់ ម៉ាត ឡើយ គ្រែដៃ លំបើម អាំ ហឹតៗ។ ");
INSERT INTO brb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ប៉ាគ់ ពអ៊ែ យ៉ាគ់ សឋិច អើយ ណិះៗ នែ ហន់ដាំង បនឹះ មូយ រ៉ា ណគ់ ឡើ ហ្រឡិច ហ្រឡាង អ្រណោះ អ្រទីង ហំពឌឹក ណគ លំរន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប នែ។ ");
INSERT INTO brb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ហន់រ៉ើះ មែ ទិះ ក្រាគ់ អន់នឺ អាំ មន់ឝ្លាំង កាន យូច ត្រ ទឹង ស្រុក អន់នែ បក់ មន់ក្រសៀក ចិះ ភែ ទឹង មែ ក្លាង ស៊្រុក ប៉ាគ់ មែ ប៉ាសាសុន មន់ដូវ សើង រែវ អ៊ែ មន់អាំ ដើ មែ ទិះ ក្រាគ់ មូយ រែវ ទឹង លញ៉ាគ់ ង៉ើ ផិ ប៊ិង ប៉ឹះ កម៉ នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ហំប៉្រៃ មែ ទិះ ក្រាគ់ មន់តមួត ចិះ ភែ ត្រំ កម៉ៗ មន់ដូវ អើន មន់ជុ ទឹង នុក តាម មួង មូយៗ ប៊្លី អ៊ែ មន់ញ៉ាម នុក។ ");
INSERT INTO brb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ចិះ ភែ នែ វន់ជុ រ៉ាក់ ចាក់ ដើ ប៉ាសាសុន ស្រុក អ៊ែស៊ីប បក់ មន់ចង់ ហឹ មន់អឹត ហរុ ប៉ឹះ កម៉ ហឹ ងឺរ តគ់ អ៊ែ ញ៉ង មន់គែត ឝ៉្លក»។ ");
INSERT INTO brb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","យ៉ូស៊ែប ឡើ ពហាយ អ៊ែ ត្រ ទឹង ប្រម៉ើត សឋិច លែក ដើ មែ ទិះ ក្រាគ់ ម៉ើ ញឹម ក្លើម ប៉ាគ់ទឺ ដើ ខនឹត ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","សឋិច ឡើ ពហាយ ដើ មែ ទិះ ក្រាគ់ រៀន៖ «ប៊ិច យ៉ាវ ងន់សាត បនឹះ ហឹ គែង ប៉ាគ់ ដើ បឹ អន់នែ ឡើ ប៊ិច ផវ យ៉ាង គ្រែដៃ ឡើ គូ ប៊ឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","សឋិច ឡើ ហាយ ដើ យ៉ូស៊ែប រៀន៖ «គ្រែដៃ ឡើ ពដៃ ហៃ ហណោះ កាន លែក នែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ប៊ិច ហ្រឡិច ហ្រឡាង អ្រណោះ អ្រទីង ប៉ាគ់ ដើ ហៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ប៉ាគ់ ពអ៊ែ អំប៉្រៃ ហៃ ហំរន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប នែ លែក ដើ ប៉ាសាសុន អៃ មន់ត្រ បើម ត្រួយ តាម ពន់ដ្រៃ ហៃ។ វ៉ិះ ឌិវ អៃ ឡើយ អទិះ ពឺង ហៃ យ៉ាក់ អសឋិច»។ ");
INSERT INTO brb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","សឋិច ឡើ ពហាយ ដើ យ៉ូស៊ែប រៀន៖ «ណិះៗ នែ អំពឌឹក ហៃ ហំរន់ឋាប់ ឝ្លាំង លែក ដើ ស្រុក អ៊ែស៊ីប នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ប៊ឹង អ៊ែ សឋិច ឡើ តោះ ហន់ណក ត្រា តើម ប៊ឹង ទី ណគ ឡើ ពទ្រូប យ៉ូស៊ែប ដើម ឡើ ពហក ណគ ដើ អាវ ចណុង ចណាគ់ អ៊ែ ឡើ តបាក់ សសយ ឆៀង ដិ ");
INSERT INTO brb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ប៊្លី អ៊ែ សឋិច ឡើ អាំ កៀន ប្រណើម ឆនិះ អនុ សឋិច ដើ យ៉ូស៊ែប លំឈិះ អ៊ែ ឡើ ប៉្រៃ មែ តហាន មន់ដក់ អន់នួរ ណគ អាំ មន់ហូ ពហាយ រៀន៖ «ណគ នែ ឡើយ វន់ខរ៉ុប កដាប ហំបះ!»។ ប៉ាគ់ នែ ឡើយ សឋិច ឡើ ពឌឹក យ៉ូស៊ែប ប៉្រៃ រន់ឋាប់ ឝ្លាំង លែក ដើ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","សឋិច ឡើ ម៉ាង ហឹ យ៉ូស៊ែប អន់ណាវ រៀន៖ «អៃ អសឋិច លែក ទឹង កនុង ស្រុក អ៊ែស៊ីប តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ប៊ិច ស៊ិត ពឹត បើម ប៉ាគ់ ញឹះ តៃ គ្លីះ ម៉ាង តើម ប៊ឹង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","យ៉ាគ់ សឋិច ឡើ ជុ ពលិះ ម៉ាត់ យ៉ូស៊ែប “សាភែណាត់-ផាណា” អន់ណាវ អ៊ែ ឡើ យ៉ាគ់វឺ ប៊ឹង ណាង អាះណាត់ ឡើ ត្រ កួន កទ្រី យ៉ាគ់ ប៉ូទីភែរ៉ា ឡើ កឡា បប៊ុះ ថួយ ហឹ មួង អូន ឡើ ប្រយ៉ង់ ប៊ឹង យ៉ូស៊ែប។ អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៊ិច ប្រយ អាតណាត ពឺង មែ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ទឹង យ៉ាគ់ សឋិច ឡើ ពឌឹក យ៉ូស៊ែប ប៉្រៃ រន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប កំប្រាគ់ យ៉ូស៊ែប ពែ ជិត កម៉ ឡើយ។ យ៉ូស៊ែប ឡើ វីះ តើម ប៊ឹង សឋិច អ៊ែ ឡើ ឆវែង ឝ្លាំង បុ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ទឹង លញ៉ាគ់ ប៉ឹះ កម៉ ម៉ើ ផិ ប៊ិង ទឹង ស្រុក អ៊ែស៊ីប ម៉ើ ដូវ ចិះ ភែ ទុត អើន តូវ ស៊ិវ សាគ់ ណាគ់ គ្លឺយ។ ");
INSERT INTO brb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ទឹង ប៉ឹះ កម៉ អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៉្រៃ មែ ទិះ ក្រាគ់ ក្រូម ណគ ម៉ើ ដក់ តមួត ចិះ ភែ បុ ទឹង ស្រុក អ៊ែស៊ីប។ ត្រំ មួង យ៉ាគ់ យ៉ូស៊ែប ឡើ តមួត ជុ ចិះ ភែ ទឹង នុក ណគ់ ម៉ើ ឈូន តើម ប៊ឹង មឺរ ណា បរ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","យ៉ាគ់ យ៉ូស៊ែប ឡើ តមួត ជុ ចិះ ភែ ទុត អើន ឞាល់ ផាច បរ ពឹះ សមុត ញឹះ តៃ បក់ កាវ យ៉ាវ ឋា ម៉ើ ព្រឹង កាវ។ ");
INSERT INTO brb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","តៃ ដាន់ ប៊ឹះ កាន អឹត ហរុ យ៉ូស៊ែប អំប្រា ទ្រី ណគ ណាង អាះណាត់ អំប្រា ប៊ិច កួន កឡ បារ រ៉ា (ណាង អាះណាត់ នែ កួន យ៉ាគ់ ប៉ូទីភែរ៉ា ឡើ កឡា បប៊ុះ ថួយ ហឹ មួង អូន)។ ");
INSERT INTO brb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","យ៉ាគ់ យ៉ូស៊ែប ឡើ ជុ ម៉ាត់ កួន ឡង់ ណគ “ម៉ាណាស៊ែ” យ៉ាក់ ឡើ រៀន៖ «គ្រែដៃ ឡើ អាំ អៃ អវឺញ លែក ដើ កាន ធុក ញ៉ាក ដើម អអង់ងឹះ យ៉ាវ លែក ដើ មែ ទឹង ក្រាន បើគ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ឡើ ជុ ម៉ាត់ កួន អន់សូច ណគ “អ៊ែប៉្រាអ៊ីម” យ៉ាក់ ឡើ រៀន៖ «គ្រែដៃ ឡើ អាំ ដើ អៃ អប៊ិច កួន ទឹង ស្រុក ណគ់ អៃ អធុក ញ៉ាក ប៉ាក ម៉ង ពន់ឋើម»។ ");
INSERT INTO brb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","មែ អ៊ែស៊ីប ម៉ើ ផិ ប៊ិង ស៊ិវ សាគ់ ណាគ់ គ្លឺយ ណុះ ប៉ឹះ កម៉ ឡើយ ");
INSERT INTO brb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","កាន អឹត ហរុ ប៉ឹះ កម៉ អ៊ែ ឡើ ប៊ឹះ ប្រយ ដាវ ប៉ាគ់ ប្រម៉ាង យ៉ាគ់ យ៉ូស៊ែប ម៉ាត។ ទឹង អ៊ែ លែក ដើ ពធែត ឈុំ អ៊ែ ម៉ើ ងួត ទុត ខាក់ វ៉ិះ ឌិវ ស្រុក អ៊ែស៊ីប ណាគ់ ម៉ើ ប៊ិច ចិះ។ ");
INSERT INTO brb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ប៊្លី អ៊ែ លែក ដើ ប៉ាសាសុន ទឹង ស្រុក អ៊ែស៊ីប តគ់ ម៉ើ ងួត ឡើយ អ៊ែ ម៉ើ ដក់ ឡា ចិះ ហឹ សឋិច យ៉ាគ់ សឋិច ឡើ ត្រណើវ រៀន៖ «វន់ដក់ តង៉ា យ៉ាគ់ យ៉ូស៊ែប តគ់ អ៊ែ វន់បើម តាម ណគ លំប៉្រៃ វែ»។ ");
INSERT INTO brb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","លែក ដើ ស្រុក អ៊ែស៊ីប តគ់ ម៉ើ អឹត ហរុ យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៉ើក នុក ត្រំ មួង មូយៗ ឡើ ហំពួត ចិះ ដើ មែ ប៉ាសាសុន ញ៉ន ម៉ើ អឹត ហរុ ចាំ ម៉ៃ ទឹង ស្រុក អ៊ែស៊ីប នែ។ ");
INSERT INTO brb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","បនឹះ ត្រំ ពធែត ឈុំ អ៊ែ ម៉ើ ដក់ ហឹ ស្រុក អ៊ែស៊ីប ម៉ើ រួត ចិះ ហឹ យ៉ូស៊ែប ប៉ាគ់ទឺ យ៉ាក់ លែក ដើ ពធែត ទឹង ឡាង ប្រិះ នែ ម៉ើ អឹត ហរុ ចាំ ម៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ទឹង អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ដុង ទិ ស្រុក អ៊ែស៊ីប ម៉ើ ប៊ិច ចិះ អ៊ែ ឡើ ម៉ាង ហឹ មែ កួន កឡ ណគ រៀន៖ «ពយ៉ិ ឡើ ត្រ មែ កួន អើយ វ៉ើ គូ មិៗ ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ឡើ ម៉ាង ឡឹះ រៀន៖ «អដុង ម៉ើ រៀន ទិ ស្រុក អ៊ែស៊ីប ចុ ម៉ើ ប៊ិច ចិះ។ ប៉ាគ់ ពអ៊ែ កួន វន់ទឺះ ដាំង រួត ចិះ ដើ ង៉ាយ ទិ មែ ចុ អ៊ែ ណាគ់ ងន់ញិវ ញ៉ង ងន់គែត ឝ៉្លក អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","អ៊ែ មែ អ៊ូគ អា យ៉ូស៊ែប លែក ជិត រ៉ា ម៉ើ ទឺះ ដាំង រួត ចិះ ទិ ស្រុក អ៊ែស៊ីប ");
INSERT INTO brb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ហាក់ យ៉ាគ់ យ៉ាកុប ឡើ អាំ អ៊ឺម ប៊ែនយ៉ាមីន អោះ យ៉ូស៊ែប លំតូយ មែ អ៊ូគ អា ណគ យ៉ាក់ ឡើ ឃឹត រៀន កឡាគ់ លំប៊ឺក រ៉ាម ផាម មឹត។ ");
INSERT INTO brb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","កួន កឡ យ៉ាគ់ អ៊ីស្រាអ៊ែល(ម៉ើ ជិ យ៉ាកុប ដិ) ម៉ើ ទឺះ រួត ចិះ ប៉ាគ់ ដើ បូវ ទឺ យ៉ាក់ ម៉ើ អឹត ហរុ ទឹង ស្រុក កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ទឹង អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ រន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប ណគ ឡើយ ឡើ ហន់នៀប ឝ្លាំង មែ ម៉ើ ហំពួត ចិះ លែក ដើ មែ ស្រុក ម៉ើ ដក់ រួត។ មែ អ៊ូគ អា ណគ ហំប៊្រុះ ម៉ើ ប៊ឹះ ចុ អ៊ែ ម៉ើ ដក់ កដាប ហំបះ ណគ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","តគ់ យ៉ាគ់ យ៉ូស៊ែប ឡើ តៃ មែ អ៊ូគ អា ណគ ឡើ ហង់ឝ៉ាវ ប្រយ មែ ហាក់ ឡើ បើម ប៉ាគ់ មែ គែង។ អ៊ែ ឡើ ម៉ាង ក្រាគ់ ដើ មែ រៀន៖ «តើម ប៊ឹង ង៉ាយ វ៉ើ ប៊ឹះ?»។ ម៉ើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ញ៉ើ ប៊ឹះ តើម ទិ ស្រុក កាណាន ញ៉ើ ទឺះ ដាំង រួត ចិះ ទិ វែ»។ ");
INSERT INTO brb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","យ៉ូស៊ែប ណាគ់ ឡើ ហង់ឝ៉ាវ មែ ហាក់ ដើ មែ ម៉ើ ហង់ឝ៉ាវ យ៉ាវ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ហំប៊្រុះ ឡើ តៃ មែ អ៊ូគ អា ណគ ម៉ើ កដាប ហំបះ ណគ អ៊ែ យ៉ូស៊ែប ឡើ ចនិះ ហឹ ណគ ឡើ ពកី ពន់ឋើម ។ អ៊ែ ឡើ ចឹន មែ រៀន៖ «បូវ វែ នែ វ៉ើ ដក់ ស៊ឺប កាន អ៊ែ វ៉ើ ប៊ឹះ ហឹ នែ វ៉ើ ដក់ ឝ្លាំង ឞន ប្លះ ង៉ាយ ឡើ វឺង តៃ ប៊ិច មែ ម៉ើ ញ៉ាម»។ ");
INSERT INTO brb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ម៉ើ ត្រណើវ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ ត្រ អ៊ឺម ប៉ាគ់ អ៊ិន ញ៉ើ ទឺះ ទិ នែ ដាំង រួត ចិះ ម៉ាត់ៗ ។ ");
INSERT INTO brb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ញ៉ា នែ ញ៉ើ អំម៉ោះ អោះ មូយ បើគ ឡើយ ដើម ញ៉ើ បនឹះ ទឹង ត្រ ដិ ត្រ អ៊ឺម ញ៉ើ ដក់ ស៊ឺប កាន»។ ");
INSERT INTO brb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","យ៉ូស៊ែប ឡើ ត្រណើវ មែ រៀន៖ «ចាប់ អ៊ឺម អៃ វ៉ើ ទឺះ ទិ នែ វ៉ើ ម៉ើត ឝ្លាំង ឞន ប្លះ ង៉ាយ ឡើ វឺង តៃ ប៊ិច មែ ម៉ើ ញ៉ាម»។ ");
INSERT INTO brb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","មែ ម៉ើ ត្រណើវ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ ញ៉ា នែ ញ៉ើ ប៊ិច អំម៉ោះ អោះ កឡ ជិត បារ រ៉ា បើគ ញ៉ា ឌិវ មូយ ញ៉ា នែ ញ៉ើ គូ ទឹង ស្រុក កាណាន។ ណិះៗ នែ អោះ អន់សូច ញ៉ា ណាគ់ ប៊ឹង បើគ អ៊ែ ណគ់ អោះ ញ៉ា មូយ អន់ណាវ ឡើ ណាគ់ យ៉ាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","យ៉ូស៊ែប ឡើ ម៉ាង រៀន៖ «អ៊ិន វន់តមឹង ឡើ ត្រ ប៉ាគ់ ប្រម៉ាង អៃ ម៉ាត់ ម៉ាត វែ វ៉ើ ដក់ ស៊ឺប កាន ឡើយ ហង់អ៊ិន! ");
INSERT INTO brb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","អៃ អំបឡង ឝ្លាំង ឡាំង ចនិះ វែ។ អៃ អន់តប៉ឹន ចាក់ ណាគ់ ប៊ឹង ម៉ាត់ សឋិច វន់ដូវ អ៊ឺម ជឹ វឹញ ញឹះ អោះ អន់សូច វែ លំប៊ឹះ អន់ដៃ! ");
INSERT INTO brb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","មិញ វន់ប៉្រៃ បូវ វែ មូយ រ៉ា លន់ជឹ ចក់ អោះ អន់សូច វែ លំទឺះ តៀត ទិ នែ ណគ់ បូវ វែ វ៉ើ ណាគ់ ទិ នែ អង់ក្រាន់ ទឹង ឃុក អន់ដៃ។ អបើម ប៉ាគ់ នែ អបឡង ឝ្លាំង ប្រម៉ាង វែ ដាវ ណោះ តៃ ដាវ។ ប៉ាគ់ តៃ លំដាវ អន់តប៉ឹន ចាក់ ណាគ់ ប៊ឹង ម៉ាត់ សឋិច វែ វ៉ើ ស៊ឺប កាន ម៉ាត់ ម៉ាត ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ប៊្លី អ៊ែ យ៉ូស៊ែប ឡើ ប៉្រៃ ម៉ើ ដក់ ចិះ ឃុក មែ អ៊ូគ អា ណគ លញ៉ាគ់ ពែ តង៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","តគ់ ប៊ឹះ ពែ តង៉ៃ យ៉ូស៊ែប ឡើ ម៉ាង ដើ មែ អ៊ូគ ណគ រៀន៖ «អៃ នែ អអៀល បឹះ គ្រែដៃ ប៉ាគ់ វន់បើម តាម ពន់ដ្រៃ អៃ អ៊ិន អ៊ែ វន់ញិវ។ ");
INSERT INTO brb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ប៉ាគ់ វ៉ើ បនឹះ ទឹង ត្រ ម៉ាត់ ម៉ាត ទឹង បូវ វែ នែ វន់អាំ មូយ រ៉ា លំគូ ទឹង ឃុក ឡឹះ អន់ណាវ អ៊ែ ណគ់ មែ គែង អ៊ែ មន់ជឹ ឈូន ចិះ ភែ ដើ មែ ម៉ើ អឹត ងួត ទឹង ហន់ណាម ក្រាន វែ។ ");
INSERT INTO brb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ប៊្លី អ៊ែ វន់តៀត អោះ អន់សូច វែ ទឺះ ទិ អៃ អ៊ែ អន់ណោះ ហឡាក់ ណគ់ ប្រម៉ាង វែ ណោះ ឡើ ដាវ ណោះ អ៊ឺម។ ប៉ាគ់ វន់បើម ប៉ាគ់ អ៊ិន អ៊ែ ញ៉ង វន់គែត»។ ");
INSERT INTO brb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","អ៊ែ ម៉ើ ផម ប្រយ បើម តាម ប្រម៉ាង ណគ ដើម ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «វ៉ើ តៃ ង៉ើ បើម អន់យូច ដើ អោះ ង៉ាយ ពន់ឋើម ឡើយ ទុត ង៉ើ តៃ ឡើ ធុក ញ៉ាក ដើម ឡើ ឡា ឡូម ហឹ ង៉ាយ ណាគ់ តៃ ង៉ើ ចង់ហៀង អ៊ឺម ណគ។ ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ ង៉ើ ប៊ិច កាន ធុក ញ៉ាក ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","យ៉ាគ់ រូប៊ែន អ៊ូគ មែ ឡើ ម៉ាង រៀន៖ «អៃ អគឹះ ឡើយ វែ ញ៉ង តំឞាប អ៊ឺម អោះ ង៉ាយ វ៉ើ ចង់ហៀង អ៊ឺម ម៉ាង អៃ អកំប៊ែត។ ណិះៗ នែ ង៉ាយ ង៉ើ ត្រ ថូត ញ៉ន ដើ ង៉ើ កជែត អោះ ង៉ាយ ឡើយ អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ម៉ើ ឃឹត យ៉ូស៊ែប លំណោះ អឹ ប្រម៉ាង មែ យ៉ាក់ ប៊ឹង ឡើ ចជែ ដើ មែ ប៊ិច កឡា ពែ ប្រម៉ាង ប្លះ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","យ៉ូស៊ែប ឡើ ចវីះ តើម ប៊ឹង មែ ឞិត ឞ៊ែត អ៊ែ ឡើ ញឺម លូះ ដាក ម៉ាត់ អ៊ែ ឡើ ជឹ វឹញ ចជែ មម៉ាង ឡឹះ អន់ណាវ ហឹ មែ។ ប៊្លី អ៊ែ ឡើ ប៉្រៃ តហាន ណគ មន់រ៉ាប់ ចង ស៊ីមៀន ប៊ឹង ងឺរ អំម៉ោះ អោះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","យ៉ូស៊ែប ឡើ ប៉្រៃ មែ ឞយ ណគ មន់ច្រក ចិះ ទឹង កប៉ូវ ដើ មែ អ៊ូគ ណគ អាំ ប៊ិង ដឹប មន់ជុ លៀន មែ ម៉ើ រួត ចិះ អន់ឌូ ត្រំ កប៉ូវ មែ កឡឹ ទឺ ដើម មន់អាំ ចណង់ ចណា ដើ មែ មន់ចង់ តៃ ទ្រូង ដិ។ អ៊ែ ម៉ើ បើម ត្រួយ ប៉ាគ់ ពន់ដ្រៃ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","មែ អ៊ូគ ណគ ម៉ើ ព្រឌុក ចិះ ទឹង សិះ លៀ ប៊្លី អ៊ែ ម៉ើ ជឹ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","តគ់ ម៉ើ ប៊ឹះ ឞន កណី មែ តៃ ទ្រូង បឹ មូយ រ៉ា ឡើ ពប៉ឹះ កប៉ូវ ចិះ ណគ ឡើ ចក់ ចណា អាំ ដើ សិះ លៀ លន់ចា អ៊ែ ឡើ តៃ ប្រយ លៀន ណគ កឡឹ ទិ ចម៉ាក កប៉ូវ។ ");
INSERT INTO brb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ឡើ ពហាយ ដើ អំម៉ោះ អោះ ណគ រៀន៖ «នែ វន់ឝ្លាំង លៀន អៃ ម៉ើ ជុ ទិ ចម៉ាក កប៉ូវ ទឺ!»។ ហំប៊្រុះ ដើ អ៊ែ ម៉ើ ឌូង សសឹរ ចាក់ អន់ឆាក់ យ៉ាង ប្រយ អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ណោះ កាន ង៉ាយ គ្រែដៃ ឡើ បើម ដើ ង៉ាយ ប៉ាគ់ នែ!»។ ");
INSERT INTO brb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","តគ់ ម៉ើ ប៊ឹះ បើគ មែ យ៉ាគ់ យ៉ាកុប ទឹង ស្រុក កាណាន អ៊ែ ម៉ើ ប៉ច ដើ ណគ លែក ដើ កាន ឡើ កើត ដើ មែ ទិ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ម៉ើ ប៉ច រៀន៖ «កន់ដ្រាគ់ ឡើ រន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប ឡើ ម៉ាង ក្រាគ់ ដើម ឡើ ចឹន ញ៉ា ឡើ រៀន ញ៉ា ញ៉ើ ទឺះ ស៊ឺប កាន ទិ ប៊្រី ដាក ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ញ៉ើ ត្រណើវ ណគ រៀន “ញ៉ា នែ ញ៉ើ បនឹះ ទឹង ត្រ តៃ ត្រ ញ៉ើ កឡា ស៊ឺប កាន អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ញ៉ា ញ៉ើ ប៊ិច អំម៉ោះ អោះ កឡ ជិត បារ រ៉ា បើគ ញ៉ា វ៉ិះ មូយ អិះ ឡើយ អោះ ញ៉ា មូយ រ៉ា តៃ ឡើ ណាគ់ យ៉ាវ អ៊ែ ណគ់ អោះ អន់សូច ញ៉ា ឡើ គូ ណាគ់ ប៊ឹង បើគ ទឹង ស្រុក កាណាន ទិ”។ ");
INSERT INTO brb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","យ៉ាគ់ កន់ដ្រាគ់ ឡើ រន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប ឡើ ហាយ ដើ ញ៉ា អន់ណាវ រៀន “អាំ វន់បើម ប៉ាគ់ នែ អ៊ែ អន់ណោះ វែ វន់បនឹះ ទឹង ត្រ វន់ជុ បូវ វែ មូយ រ៉ា ប៊ឹង អៃ អន់ដៃ ណគ់ ដើ វែ វន់ជឹ ឈូន ចិះ ភែ ទឹង ហន់ណាម ក្រាន វែ ម៉ើ ពងួត អឹត ឝ៉ាន់ ឆិ ចង់ ");
INSERT INTO brb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","លែវ អ៊ែ វន់ទឺះ តៀត អោះ អន់សូច វែ ទិ អៃ នែ។ អ៊ែ អន់ណោះ រៀន វែ វ៉ើ បនឹះ ទឹង ត្រ តៃ វ៉ើ កឡា ស៊ឺប កាន អ៊ឺម អ៊ែ ណាគ់ អំពរ៉ូះ បឹ អន់នែ ឈូន ដើ វែ កឡឹ អ៊ែ វែ វន់ដូវ ឡើយ ទឺះ ហំពួត រួត ទិ ស្រុក អ៊ែស៊ីប នែ”»។ ");
INSERT INTO brb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","តគ់ ម៉ើ ហ៊ែង ចិះ តើម ប៊ឹង កប៉ូវ មែ ម៉ើ តៃ ច្រណូម លៀន មែ កឡឹ ត្រំ រ៉ា។ ប៊ឹង ម៉ើ តៃ លៀន មែ ណាគ់ ស្រូមៗ លែក ដើ មែ ដើម បើគ មែ ម៉ើ ឌូង ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","បើគ មែ យ៉ាគ់ យ៉ាកុប ឡើ ម៉ាង រៀន៖ «វែ វ៉ើ បើម អំប៉ាត់ ឡើយ កួន អៃ យ៉ូស៊ែប ឡើ ប៉ាត់ ស៊ីមៀន ឡើ ប៉ាត់ ណិះៗ នែ វ៉ើ ងុញ តៀត ប៊ែនយ៉ាមីន អន់ណាវ! អៃ នែ ឡើយ អន់តង៉ូក ឆ្រុក ដើ កាន លែក នែ ត្រ អ៊ឺម វែ!»។ ");
INSERT INTO brb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","រូប៊ែន ឡើ ត្រណើវ បើគ ណគ រៀន៖ «បើគ ថលែម ហង់អាំ ប៊ែនយ៉ាមីន ដើ អៃ ណាគ់ អន់ឡាប់ រន់ឋាប់ ឝ្លាំង ណាគ់ អន់ជឹ ឈូន ទឹង ហៃ កឡឹ ទឺ ប៉ាគ់ តៃ អំជឹ ឈូន ហន់កជែត កួន កឡ អៃ លែក បារ រ៉ា ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ម៉ាង រៀន៖ «អ៊ឺម! អន់អាំ យ៉ាវ វន់តៀត កួន អន់សូច អៃ! អ៊ូគ ណគ ឡើ គែត ឡើយ វ៉ិះ ឡើ ណាគ់ ឌិវ មូយ រ៉ា ណគ ណិះ ឡើយ កួន អៃ ប៊ឹង រ៉ាជែល។ អៃ នែ អក្រាគ់ៗ ហ៝ក ប៊ិង ទូះ ឡើយ ប៉ាគ់ លំប៊ិច កាន ប៊ឺក រ៉ាម ផាម មឹត អង់ង៉ាយ មូយ ដើ ណគ តៃ ទ្រូង វែ វន់ដក់ ញ៉ន ដើ វែ ឡើយ អង់គែត ដើ ឝ្រង៉ឹត ស្រូក អន់ដក់ ហឹ មួង កយ៉ក់»។ ");
INSERT INTO brb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","កាន អឹត ហរុ ទឹង ស្រុក កាណាន អ៊ែ ចាំ ម៉ៃៗ។ ");
INSERT INTO brb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ណគ់ ចិះ ម៉ើ ទឺះ រួត ទិ ស្រុក អ៊ែស៊ីប អ៊ែ ម៉ើ ចង់ លែក ឡើយ អ៊ែ អ៊ីស្រាអ៊ែល ឡើ ម៉ាង ដើ មែ កួន ណគ រៀន៖ «មិញ មែ កួន វន់ទឺះ រួត ចិះ ភែ ទិ ស្រុក អ៊ែស៊ីប អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","យូដា ឡើ តើវ បើគ ណគ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ ឡើ រន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប ឡើ ម៉ាង ក្រាគ់ ដើ ញ៉ា រៀន “ប៉ាគ់ តៃ វន់តៀត អោះ អន់សូច វែ អាំ យ៉ាវ វន់ទឺះ ទិ អៃ!”។ ");
INSERT INTO brb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","បើគ ប៉ាគ់ ហន់អាំ អោះ អន់សូច លំតូយ ញ៉ា អ៊ែ ណាគ់ ញន់ទឺះ រួត ឡឹះ ចិះ ដើ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ហាក់ ប៉ាគ់ តៃ ហន់អាំ ណគ លំតូយ ញន់ឌី អ៊ឺម ប៉ាគ់ទឺ ញន់ទឺះ យ៉ាក់ យ៉ាគ់ កន់ដ្រាគ់ ស្រុក ទិ អ៊ែ ឡើ ម៉ាង រៀន ប៉ាគ់ តៃ ញន់តៀត អោះ អន់សូច ញ៉ា នែ ឡើ អាំ យ៉ាវ ញន់ទឺះ ទិ ណគ!»។ ");
INSERT INTO brb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ម៉ាង រៀន៖ «ពយ៉ិ ឡើ ត្រ វ៉ើ តំឞាប អៃ ប៉ាគ់ អ៊ិន វ៉ើ ហាយ បើម ង៉ាយ វ៉ើ រៀន វ៉ើ ប៊ិច អោះ ណាគ់ មូយ?»។ ");
INSERT INTO brb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ម៉ើ ត្រណើវ រៀន៖ «យ៉ាក់ ឡើ តង៉ា ញ៉ា ញឹះ ឆឆិក លឡិក តគ់ ឡើ ប៉្រៃ ញ៉ើ ហាយ អំម៉ោះ អោះ ព្រឝ៉ើត យូ ញ៉ា ដើ ណគ ឡើ រៀន “បើគ វែ ណាគ់ៗ ឡះ? ណាគ់ វ៉ើ ប៊ិច អំម៉ោះ អោះ វែ ណាគ់ មូយ?” អ៊ែ ញ៉ើ ឌី ត្រណើវ ប្រម៉ាង ណគ ត្រ ញ៉ើ ណោះ លំប៉្រៃ ញន់តៀត អោះ ញ៉ា ទិ ណគ អំប?»។ ");
INSERT INTO brb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","យូដា ឡើ ឡា ហឹ បើគ ណគ រៀន៖ «ឡា បើគ អើយ ហង់អាំ អោះ អន់សូច លំតូយ អៃ។ ញន់ទឺះ ណិះៗ ឡើយ អ៊ែ ណាគ់ ងន់ញិវ ដើម ហៃ ដឹប កួន ចូវ ហៃ ញ៉ង ងន់គែត ឝ៉្លក អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ណាគ់ អន់ឡាប់ លវាំង ឝ្លាំង ណគ ទុត ខាក់ ប៉ាគ់ តៃ អន់ជឹ តៀត តវឹញ ណគ ចាគ់ៗ នៀមៗ ទឹង ហៃ អន់ឡាប់ ថូត ដើ ហៃ ឋា ដើ គែត។ ");
INSERT INTO brb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ប៉ាគ់ តៃ ងន់ពញ៉ាក ប៉ាគ់ នែ ញន់ទឺះ ដាំង រួត ចិះ ដូវ បារ ឈឹង ឡើយ ឞាល់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","បើគ មែ ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ ពអ៊ិន ប៉ាគ់ នែ ឆិ ងំបើម! វន់តៀត រ៉ាះ ចង់ហ តើម ប៊ឹង ស្រុក ង៉ាយ នែ វន់ចក់ ឆារ់ គ្លឹមៗ ដិ អន់ដិ ដាក ស៊ុត កិៗ វន់ចក់ អង់គុង អន់ណ ដើម អង់គុង ត្រៀវ វន់ទឺះ អាំ ដើ ណគ ទិ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","វន់តៀត លៀន អើន ជឺរ ឡៃ អន់នួរ មូយ តង ឡឹះ អន់ណាវ ណគ់ លៀន មែ ម៉ើ ជុ ពឺង ចម៉ាក កប៉ូវ វន់ឈូន ដើ មែ កឡឹ ទឺ អំប ម៉ើ ជុ ច្រលឺម។ ");
INSERT INTO brb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","វន់តៀត ដើម អោះ វែ ឆិ វន់ទឺះ ទិ យ៉ាគ់ ហង់អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","គ្រែដៃ ឡើ ឆង៉ាត់ ទុត ខាក់ លន់អន់ណាំ ដើ យ៉ាគ់ ហង់អ៊ិន លំប៊ិច ចនិះ ញឹម ក្លើម ដើ វែ លំអាំ កួន អៃ លមូយ ដើម ប៊ែនយ៉ាមីន អំប្រា លំជឹ អរែង ដើ វែ ទឹង អៃ នែ។ អ៊ែ ណគ់ ដើ អៃ ទឹង នែ ប៉ាគ់ កួន អៃ មន់ប៉ាត់ ពណាត់ អង់គូ ឝ្រង៉ឹត ស្រូក ហឹ ណិះ ឡើយ ឆិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","កួន កឡ យ៉ាគ់ យ៉ាកុប ម៉ើ ទឺះ ទិ ស្រុក អ៊ែស៊ីប ម៉ើ តៀត អន់ណាំ ដើម លៀន ក្រាគ់ ដឹប លៀន ហន់ដើម។ អ៊ែ ម៉ើ ច្រា ប៊ែនយ៉ាមីន ដក់ តូយ មែ ប៊ឹះ ចុ អ៊ែ ម៉ើ ដក់ ហឹ ងឺរ យ៉ាគ់ យ៉ូស៊ែប។ ");
INSERT INTO brb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ហំប៊្រុះ យ៉ូស៊ែប ឡើ តៃ ប៊ែនយ៉ាមីន ឡើ តូយ មែ អ៊ូគ អា ណគ អ៊ែ ឡើ ប៉្រៃ បឹ ឡើ រន់ឋាប់ ឝ្លាំង ហន់ណាម ណគ រៀន៖ «មិញ ហន់ច្រា មែ តគ់ មន់មឹត ហឹ ហន់ណាម អៃ ហន់កជែត បណាន់ ហំបើម ចណង ចណា យ៉ាក់ មែ មន់ចង់ អរែង ប៊ឹង អៃ តង៉ៃ ឆុង នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","បឹ ហង់អ៊ែ ឡើ បើម តាម ពន់ដ្រៃ យ៉ូស៊ែប ឡើ ច្រា ម៉ើ មឹត ហឹ ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","អំម៉ោះ អោះ យ៉ូស៊ែប ម៉ើ តៃ មែ ម៉ើ ច្រា មឹត ហឹ ហន់ណាម អ៊ែ ម៉ើ ឌូង ទុត ខាក់ ម៉ើ ចជែ រៀន៖ «ម៉ើ តៀត ង៉ាយ មឹត ហឹ នែ ញ៉ន ដើ លៀន ម៉ើ ជុ ទឹង កប៉ូវ ង៉ាយ ឡៃ អន់នួរ ឡើយ។ អាត ម៉ើ ងុញ រ៉ាប់ ង៉ាយ មន់បើម ក៝ត ដើម មន់ចក់ សិះ លៀ ង៉ាយ ដិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ហំប៊្រុះ ម៉ើ ប៊ឹះ តគ់ ឝឡោះ ហន់ណាម យ៉ូស៊ែប អ៊ែ ម៉ើ ដក់ ចឹម ចើម តគ់ បឹ ឡើ រន់ឋាប់ ឝ្លាំង ហន់ណាម ម៉ើ ហាយ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«ឡា យ៉ាគ់ អ អើយ ញ៉ា ញ៉ើ ខើយ ទឺះ រួត ចិះ ទិ នែ មូយ តង ឡើយ ឡៃ អន់នួរ។ ");
INSERT INTO brb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","តគ់ ញ៉ើ ប៊ឹះ ប៊ឹង ឞន កណី ញ៉ើ ឡិះ កប៉ូវ ញ៉ើ តៃ លៀន ញ៉ា ត្រំ រ៉ា ណាគ់ ស្រូមៗ ប៊ឹង ចម៉ាក កប៉ូវ។ អ៊ែ ណិះៗ នែ ញ៉ើ ទឺះ ឈូន ទិ ហៃ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ណគ់ លៀន អន់នែ តៃ ញ៉ើ ណោះ អ៊ឺម ណោះ មែ ង៉ាយ ម៉ើ ជុ ទឹង កប៉ូវ ចិះ ញ៉ា ដើម ញ៉ើ តៀត ឡឹះ អន់ណាវ លៀន ញន់រួត ចិះ»។ ");
INSERT INTO brb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","បឹ ហង់អ៊ែ ឡើ ត្រណើវ រៀន៖ «ញ៉ង វ៉ើ ច្រៃ ញ៉ង វ៉ើ ឌូង អ៊ឺម! គ្រែដៃ ឡើ កន់ដ្រាគ់ វែ ដើម ឡើ កន់ដ្រាគ់ បើគ វែ ឡើ ជុ លៀន ទឹង កប៉ូវ វែ។ អ៊ែ ណគ់ លៀន វែ វ៉ើ រួត ចិះ ពន់ឋើម ម៉ើ ឈូន ហឹ អៃ ឡើយ»។ ប៊្លី អ៊ែ ឡើ ដក់ តោះ ពញឺះ ស៊ីមៀន តើម ប៊ឹង ឃុក អាំ លំដក់ ហឹ មែ អំម៉ោះ អោះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","អ៊ែ ឡើ ច្រា មែ ម៉ើ មឹត ហឹ ហន់ណាម យ៉ាគ់ យ៉ូស៊ែប ឡើ អាំ ដាក ដើ មែ មន់ឆះ ឈឹង ដើម ឡើ អាំ បាត់ ច្រាំៗ ដើ លៀ មន់ចា ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ទឹង ហូច យ៉ូស៊ែប លំប៊ឹះ តង៉ៃ ឆុង អ៊ែ ម៉ើ ពប៉ឹះ ញ៉ាក់ អន់ណាំ មន់អាំ ដើ ណគ។ យ៉ាក់ ម៉ើ ដុង រៀន មន់ចង់ ចា អរែង ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","តគ់ យ៉ូស៊ែប ឡើ ជឹ ហឹ ហន់ណាម មែ អំម៉ោះ អោះ ណគ ម៉ើ អាំ រ៉ាះ មែ ម៉ើ តៀត អន់ឌូ ដើម ម៉ើ កដាប ហំបះ ណគ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ណគ ឡើ តង៉ា ឡា មែ ប៊្លី អ៊ែ ឡើ រៀន៖ «ឡៃ អន់នួរ វ៉ើ ហាយ ដើ អៃ រៀន បើគ វែ ឡើ ក្រាគ់ៗ ម៉ៃ ឡើយ ពយ៉ិ ណាគ់ ឡើ ញឹម សាំង ឡះ? ណាគ់ៗ ឡះ ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ម៉ើ ត្រណើវ រៀន៖ «អើគ យ៉ាគ់ កន់ដ្រាគ់ បើគ ញ៉ា ណាគ់ៗ  ណាគ់ ឡើ ញឹម សាំង»។ ម៉ើ ហាយ លែវ ឡើយ អ៊ែ ម៉ើ កដាប ហំបះ ណគ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","យ៉ូស៊ែប ឡើ ឝ្លាំង ឡើ តៃ ប៊ែនយ៉ាមីន អោះ ណគ មូយ ម៉ិ បើគ ឡើ តង៉ា មែ រៀន៖ «អន់នែ ឡើយ ឡះ អោះ វែ វ៉ើ ហាយ ដើ អៃ?»។ ប៊្លី អ៊ែ ឡើ ប្រាយ អោះ ណគ រៀន៖ «គ្រែដៃ លន់អន់ណាំ អន់ណូយ ដើ ហៃ!»។ ");
INSERT INTO brb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ប៊ឹង យ៉ូស៊ែប ឡើ តៃ អោះ ណគ តូវ អ៊ឹកៗ ប៊ឹកៗ ឡើ ងុញ ញឺម អ៊ែ ដ្រិះៗ ប្រយ ឡើ ជឹ មឹត ញឺម ហឹ សួម ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ប៊្លី អ៊ែ ឡើ ហន់ឆាវ ឈូត មុះ ម៉ាត់ ឡើ ញឺះ អន់ណាវ ហឹ មែ ដើម ឡើ ខំ ពឝ៉្លា ដើ មែ ដឹប ឡើ ប៉្រៃ មែ ឞយ ណគ មន់វ៉ក់ ចណង់ ចណា។ ");
INSERT INTO brb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","អ៊ែ ម៉ើ វ៉ក់ ចណង់ ចណា ដើ ណគ ប៊ឹង តូគ ដិៗ ដើ អំម៉ោះ អោះ ណគ ប៊ឹង តូគ ដិៗ ដើ សុនិសាត អ៊ែស៊ីប ណគ់ ម៉ើ ចង់ អរែង ប៊ឹង តូគ ដិៗ យ៉ាក់ សុនសាត អ៊ែស៊ីប ម៉ើ ខើយ អ៊ឺម មន់ចង់ អរែង ប៊ឹង សុនសាត ហ៊ែប្រើ ញ៉ន សុនសាត អ៊ែស៊ីប ម៉ើ ក្រាំង ចង់ អរែង ប៊ឹង មែ។ ");
INSERT INTO brb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៉្រៃ អំម៉ោះ អោះ ណគ ម៉ើ ដ្រូម ចង់ ព្រតយ តាម កំប្រាគ់ មែ អាំ ងឺរ ហឹ ណគ ណាប់ តើម ប៊ឹង បឹ ឡើ ក្រាគ់ អន់នួរ ឆា ដើ ប៊ឹះ បឹ ឡើ អន់សូច អ៊ែ តូវ ម៉ើ បើម ទុត ម៉ើ ឝ្រឡាំង ត្រឌីវ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៉្រៃ ឞយ ណគ ចក់ ចណង់ ចណា តើម ប៊ឹង តូគ ណគ ដក់ អាំ ដើ មែ អំម៉ោះ អោះ ណគ ហាក់ ដើ ប៊ែនយ៉ាមីន អើន ជឺរ មែ អ៊ូគ ណគ ញឹះ សើង តង ឡើ អាំ។ អ៊ែ ម៉ើ ញែត ចង់ បង់ ចលែង រ៉គ់សំ ឆំតក ប៊ឹង យ៉ូស៊ែប អ៊ឹរៗ។ ");
INSERT INTO brb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៉្រៃ បឹ ឡើ រន់ឋាប់ ឝ្លាំង កាន ទឹង ហន់ណាម ណគ រៀន៖ «មិញ ហន់ច្រក ចិះ ទឹង កប៉ូវ មែ នែ អាំ ប៊ិងៗ តាម តមិះ កប៉ូវ មែ ដើម ហន់ជុ លៀន មែ កឡឹ ត្រំ រ៉ា ទឹង ចម៉ាក កប៉ូវ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ហន់ជុ ប៊ែង ប៉្រាក់ អៃ ទឹង ចម៉ាក កប៉ូវ ចិះ បឹ ឡើ អន់សូច ដិ ដើម លៀន ឡើ រួត ចិះ អ៊ែ ហន់ជុ ទឹង ទឺ»។ បឹ ហង់អ៊ែ ឡើ ជុ ប្រយ តាម ពន់ដ្រៃ យ៉ាគ់ យ៉ូស៊ែប។ ");
INSERT INTO brb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","តគ់ ងឹប ប្រណូវ តើម ភុង មាំង ម៉ើ ប៉្រៃ មែ កួន ចូវ យ៉ាគ់ អ៊ីស្រាអ៊ែល មន់ជឹ ដើម លៀ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ម៉ើ វីះ ហន់ដើម ក្លើច មួង ឞិត ឞ៊ែត ឡើយ អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៉្រៃ បឹ ឡើ រន់ឋាប់ ឝ្លាំង កាន ទឹង ហន់ណាម ណគ រៀន៖ «ដ្រិះ ហន់ឆ្រួយ បូវ មែ អន់ឌូ អ៊ែ អាំ ដាន់ អ៊ែ ហន់តង៉ា មែ រៀន “ប៉ាគ់ ង៉ាយ ឡើ ត្រ វ៉ើ បើម តៃ ចាគ់ ដើ កន់ដ្រាគ់ អៃ ដើ ណគ ឡើ បើម ដើ វែ ទុត ចាគ់ ឞាល់ អ៊ែ? ");
INSERT INTO brb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ប៉ិ ឡើ ត្រ វ៉ើ ចក់ តទូង ប៊ែង ឆ្រញែត កន់ដ្រាគ់ អៃ ដើម ឡើ យួរ ឆឆាង ដិ ដើ អ៊ែ? វ៉ើ បើម ប៉ាគ់ នែ ចាគ់ អ៊ឺម វ៉ើ ណោះ”»។ ");
INSERT INTO brb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","បឹ ហង់អ៊ែ ឡើ យ៉ាវ ឆ្រួយ ឡើ ដាន់ ប្រយ មែ អ៊ែ ឡើ ម៉ាង ដើ មែ ប៉ាគ់ យ៉ូស៊ែប ឡើ ថាន់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","មែ ម៉ើ ត្រណើវ ច្រម៉ាន រៀន៖ «ប៉ិ ឡើ ត្រ យ៉ាគ់ កន់ដ្រាគ់ ហម៉ាង ប៉ាគ់ អ៊ិន ដើ ញ៉ា? ញ៉ើ ណោះ អ៊ឺម ប ញំបើម ញឹះ តៃ ចាគ់ ឞាល់ អ៊ិន ។ ");
INSERT INTO brb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ទុត លៀន ញ៉ើ តៃ ទឹង ចម៉ាក កប៉ូវ ចិះ ញ៉ា ណាគ់ ញ៉ើ ដក់ ឈូន តើម ទិ ស្រុក កាណាន ហឹ ហៃ កឡឹ ទឺ ប៉ិ ណាគ់ ញន់តទូង ឡឹះ ឆៀង ប៉្រាក់ ទឹង ហន់ណាម កន់ដ្រាគ់ ហៃ អន់ណាវ ប៉ាគ់ អ៊ិន! ");
INSERT INTO brb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ហឹ ហន់សាត ទឹង បូវ ញ៉ា នែ ប៉ាគ់ ហន់តៃ ទឹង បឹ អង់ង៉ាយ បឹ ហង់អ៊ែ លំត្រ គែត អ៊ែ ណគ់ ដើ ញ៉ា ញន់ក៝ត ហៃ ឆិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","បឹ ហង់អ៊ែ ឡើ តើវ រៀន៖ «ប៉ាគ់ ពអ៊ិន ដូវ ប៉ាគ់ទឺ អំបើម តាម ប្រម៉ាង វែ ឆិ! ប៉ាគ់ អន់តៃ ប៊ែង ទឹង កប៉ូវ បឹ អង់ង៉ាយ បឹ ហង់អ៊ែ លន់ជឹ ក៝ត អៃ ណគ់ មែ គែង អ៊ែ មន់ក្លើច»។ ");
INSERT INTO brb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","អ៊ែ លែក ដើ មែ ម៉ើ ប៊្រឺះ ដ្រិះៗ កប៉ូវ ចិះ ត្រំ មែ ចុ ប្រិះ ម៉ើ ឡិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","បឹ ហង់អ៊ែ ឡើ សាត ដាំង ណាប់ តើម ប៊ឹង កប៉ូវ បឹ ឡើ ក្រាគ់ អន់នួរ មែ ឆា ដើ ប៊ឹះ បឹ ឡើ អន់សូច អ៊ែ ឡើ តៃ ប្រយ ម៉ាត ប៊ែង ទឹង កប៉ូវ បឹ ឡើ អន់សូច ម៉ាត់ ណគ ប៊ែនយ៉ាមីន។ ");
INSERT INTO brb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","មែ អ៊ូគ អា ណគ ម៉ើ បើម ទុត ដើម ឝ្រង៉ឹត ស្រូក អ៊ែ ម៉ើ សាក ប្រយ ប្រវ៉ើន ហណក មែ កឡឹ ប៊្លី អ៊ែ ត្រំ រ៉ា ម៉ើ ហយៀក ព្រឌុក កប៉ូវ ចិះ មែ ទិ សិះ លៀ ម៉ើ ជឹ វឹញ ហឹ មួង ទឺ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","យ៉ាគ់ យូដា ដើម អំម៉ោះ អោះ ណគ ម៉ើ ប៊ឹះ ហឹ ហន់ណាម យ៉ាគ់ យ៉ូស៊ែប ម៉ើ តៃ ណគ ណាគ់ ប៊ឹង អ៊ែ។ អ៊ែ ម៉ើ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","យ៉ាគ់ យ៉ូស៊ែប ឡើ ម៉ាង ក្រាគ់ ដើ មែ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ វ៉ើ បើម ប៉ាគ់ នែ វ៉ើ ណោះ អ៊ឺម ឡះ បនឹះ ម៉ើ ណោះ ឆឡាំង ប៉ាគ់ ដើ អៃ នែ ម៉ើ ណោះ លែក កាន?»។ ");
INSERT INTO brb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","យ៉ាគ់ យូដា ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ញ៉ើ ណោះ យ៉ាវ ញន់ត្រណើវ ម៉ាង ហៃ ញ៉ើ ដាំង ប្រម៉ាង ឡិះ ចាក់ ដូវ យ៉ាវ យ៉ាក់ គ្រែដៃ ឡើ ពដៃ ឡើយ កាន ញ៉ា ញ៉ើ យូច ប៉ាគ់ ពអ៊ែ លែក ដើ ញ៉ា នែ ដើម បឹ ហតៃ ប៊ែង ហៃ ទឹង កប៉ូវ ណគ ញន់ក៝ត ហៃ ហឹ អិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","យ៉ាគ់ យ៉ូស៊ែប ឡើ ម៉ាង រៀន៖ «ដូវ អ៊ឺម អំបើម ញឹះ ឞាល់ អ៊ិន វ៉ិះ ឌិវ បឹ ឡើ ប៊ិច ប៊ែង ទឹង កប៉ូវ អ៊ែ លន់ក៝ត អៃ។ ណគ់ ដើ វែ អន់ណាវ វន់ជឹ វឹញ ទឹង បើគ វែ ញឹម សាំង ក្លាំង រ៉ិញ»។ ");
INSERT INTO brb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ប៊ឹង អ៊ែ យ៉ាគ់ យូដា ឡើ ដក់ ពន់ចើម តគ់ យ៉ាគ់ យ៉ូស៊ែប ឡើ ឡា ឡូម រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ហៃ ហប៊ិច អាតណាត ឞាល់ សឋិច ទឺ ញ៉ើ ឡាប់ ញ៉ម ហៃ អឡា អុះ ហន់ចង់ហៀង ម៉ាង អៃ អន់ដៃ ញ៉ង ហមាំ អ៊ឺម ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ពន់ឋើម ហតង៉ា ញ៉ា រៀន “បើគ វែ ណាគ់ៗ ឡះ? ណាគ់ វ៉ើ ប៊ិច ឡះ អំម៉ោះ អោះ ណាគ់ មូយ?” ");
INSERT INTO brb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","អ៊ែ ញ៉ើ ហាយ ដើ ហៃ រៀន “ប៊ិច បើគ ញ៉ា ឡើ ក្រាគ់ៗ ឡើយ ដើម ញ៉ើ ប៊ិច អោះ អន់សូច ដិ ឡើ កើត តគ់ បើគ ឡើ ក្រាគ់ៗ អ៊ូគ ណគ មូយ ម៉ិ បើគ ឡើ គែត ឡើយ អ៊ែ ណគ់ អំប្រា អំម៉ោះ អោះ មូយ ម៉ិ បើគ នែ ឡើ ណាគ់ មូយ រ៉ា ណគ នែ ឡើយ។ ញ៉ន ដើ អ៊ែ ឡើយ អ៊ែ បើគ ញ៉ា ឡើ ម៉ើត ដើ អោះ អន់សូច ញ៉ា នែ ទុត ខាក់”។ ");
INSERT INTO brb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ហប៉្រៃ ញ៉ា រៀន “វន់តៀត អោះ អន់សូច វែ ទិ អៃ អាំ អន់តៃ ប៉ាគ់ទឺ”។ ");
INSERT INTO brb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ញ៉ើ ហាយ ដើ ហៃ រៀន “អោះ អន់សូច ញ៉ា អ៊ិន ដូវ អ៊ឺម លំវីះ តាក់ បើគ ប៉ាគ់ លំវីះ បើគ ញ៉ា វ៉ិះ លន់គែត ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ហៃ ហម៉ាង ឡឹះ ដើ ញ៉ា រៀន ប៉ាគ់ តៃ ញន់តៀត អោះ អន់សូច ញ៉ា ទិ នែ ហង់អាំ យ៉ាវ ញន់ទឺះ ទិ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","តគ់ ញ៉ើ ជឹ វឹញ ទឹង បើគ ញ៉ា ញ៉ើ ប៉ច ដើ ណគ ប៉ាគ់ ប្រម៉ាង ហៃ ហម៉ាង ប៊ឹង ញ៉ា ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","តគ់ ចិះ ញ៉ា ឡើ លែក ឡើយ អ៊ែ បើគ ញ៉ា ឡើ ប៉្រៃ រៀន “មិញ មែ កួន វន់ទឺះ ដាំង រួត ចិះ ភែ អន់ណាវ ដើ ង៉ាយ”។ ");
INSERT INTO brb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ញ៉ើ ត្រណើវ រៀន “ដូវ យ៉ាវ បើគ ញន់ទឺះ ទិ អ៊ែ តៃ កា អោះ អន់សូច ញ៉ា លំតូយ អ៊ែ ញន់ដូវ ទឺះ ឡឹះ។ ប៉ាគ់ ណគ តៃ លំតូយ បឹ ឡើ រន់ឋាប់ ឝ្លាំង ស្រុក អ៊ែស៊ីប ឡើ អាំ យ៉ាវ ញន់ទឺះ ទិ ណគ”។ ");
INSERT INTO brb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","បើគ ឡើ ម៉ាង ដើ ញ៉ា រៀន “មែ កួន វ៉ើ ណោះ ឡើយ រៀន អប៊ិច កួន ប៊ឹង ទ្រី អៃ រ៉ាជែល វ៉ិះ ឌិវ បារ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","បឹ មូយ រ៉ា ឡើ ប៉ាត់ ឡើយ អឃឹត រៀន អាត ពត្រូវ ឆង៉ាគ់ ឡើយ លំកាប់ ចា សាក ញ៉ះ ណគ អ៊ែ អតៃ យ៉ាវ ណគ ប៊ឹះ ប៉ាគ់ ណិះ។ ");
INSERT INTO brb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ណិះៗ នែ វ៉ើ ងុញ តៀត បឹ អន់សូច តើម ប៊ឹង អៃ អន់ណាវ! ឞិះ អៃ នែ អក្រាគ់ៗ ហ៝ក ប៊ិង ទូះ ឡើយ ឞាល់ នែ ប៉ាគ់ ណគ លំប៊ិច កាន ប៊ឺក រ៉ាម ផាម មឹត អង់ង៉ាយ មូយ ញ៉ន ដើ វែ ឡើយ អង់គែត ដើ ឝ្រង៉ឹត ស្រូក អន់ដក់ ហឹ មួង កយ៉ក់”។ ");
INSERT INTO brb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ប៉ាគ់ ពអ៊ែ តគ់ អន់ជឹ ទឹង បើគ ប៉ាគ់ តៃ អន់ជឹ តៀត កួន អន់សូច ពន់ដ្រង ប៉្រង ចើម ណគ អរែង ប៊ឹង ញ៉ា ");
INSERT INTO brb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","បើគ ញ៉ា វ៉ិះ លន់គែត ឡើយ ញ៉ន តៃ លំតៃ កួន ណគ ជឹ អរែង ប៊ឹង ញ៉ា។ ឞិះ បើគ ឡើ ក្រាគ់ៗ ឡើ ហ៝ក ប៊ិង ទូះ ឡើយ ញ៉ន ដើ ញ៉ា ឡើយ លន់គែត ដើ ឝ្រង៉ឹត ស្រូក លន់ដក់ ហឹ មួង កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","មូយ ឡឹះ អន់ណាវ អៃ កឡឹ អឡាប់ ខណាត ដើ បើគ រៀន អំលវាំង ឝ្លាំង អោះ ញ៉ើ នែ ប៉ាគ់ តៃ អន់ជឹ តៀត ណគ នែ ទឹង បើគ អឡាប់ កាន យូច អៃ ដើ ណគ ឆា ដើ គែត!។ ");
INSERT INTO brb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ប៉ាគ់ ពអ៊ែ ឡា អុះ អឡា អៃ ឆិ អំក៝ត ហៃ ពតាង ណគ ហង់អាំ ណគ លន់ជឹ តូយ មែ អ៊ូគ អា ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ប៉ាគ់ តៃ អន់ដូវ ជឹ តៀត អោះ អន់សូច ញ៉ា មាំ យ៉ាវ អន់ជឹ ទឹង បើគ យ៉ាក់ អកយ៉ូវ អន់តៃ ណគ លំឝ្រង៉ឹត ស្រូក ង៉ូក ដុំ»។ ");
INSERT INTO brb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","យ៉ាគ់ យ៉ូស៊ែប ឡើ បក់ យ៉ាវ ឡើ ពង់អឹត ញឺម ប៊ឹង ងឺរ បូវ ណគ់ ម៉ើ គូ ប៊ឹង ណគ អ៊ែ ឡើ ប៉្រៃ លែក ដើ មែ សុនសាត អ៊ែស៊ីប មន់ចវីះ អន់ដៃ។ ប៊ឹង យ៉ាគ់ យ៉ូស៊ែប ឡើ ហាយ ម៉ាត់ ដើ មែ អំម៉ោះ អោះ ណគ មន់ហង់ឝ៉ាវ ប៊ិច អ៊ឺម មែ គែង ម៉ើ គូ ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","យ៉ាគ់ យ៉ូស៊ែប ឡើ ញឺម កឡះ ហូ ញឹះ មែ សុនសាត អ៊ែស៊ីប ម៉ើ ដុង ដើម ម៉ើ ដក់ ហាយ ដើ មែ ម៉ើ គូ ទឹង ហន់ណាម សឋិច ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","អ៊ែ ឡើ ហាយ ដើ មែ អំម៉ោះ អោះ ណគ រៀន៖ «អៃ នែ ឡើយ យ៉ូស៊ែប! បើគ ង៉ាយ ណាគ់ៗ ឡះ?»។ ហាក់ មែ អំម៉ោះ អោះ ណគ បក់ យ៉ាវ ម៉ើ ត្រណើវ ម៉ាង ណគ ម៉ើ ឌូង តូវ ម៉ើ កុង គឺ ក្រលឺ ក្រឡា យ៉ាក់ ឡើ ច្រមឹ មឺញ ប៊ឹង ងឺរ ហ៊ែត។ ");
INSERT INTO brb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","យ៉ាគ់ យ៉ូស៊ែប ឡើ ម៉ាង រៀន៖ «ឡា វន់ដក់ ចើមៗ ហឹ អៃ នែ»។ អ៊ែ ម៉ើ ដក់ ប្រយ តគ់ ណគ។ ណគ ឡើ ហាយ ដើ មែ រៀន៖ «អៃ នែ ឡើយ យ៉ូស៊ែប អោះ វែ ម៉ាត់ ម៉ាត ណគ់ វែ វ៉ើ ហំពួត អាំ ដើ មែ ម៉ើ តៀត អៃ ហឹ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ណិះៗ នែ ញ៉ង វ៉ើ ឃឹត កំប្រៃ ច្រៃ កនុង អ៊ឺម ដើម ញ៉ង វ៉ើ មាំ អ៊ឺម ដើ ចាក់ វែ កឡឹ ញ៉ន ដើ វ៉ើ ហំពួត អៃ។ យ៉ាក់ គ្រែដៃ ឡើ ប៉្រៃ អៃ អដក់ អន់នួរ វែ ហឹ នែ បក់ អន់ដូវ លវាំង អញុ ឆ្រញិវ បូវ។ ");
INSERT INTO brb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","វន់ឝ្លាំង ឡើ ប៊ិច កាន អឹត ហរុ បារ កម៉ ណិះ ឡើយ ទឹង ស្រុក នែ ហឹ ងឺរ ណាគ់ សើង កម៉ អន់ណាវ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដូវ ឆមូ ចួយ សួត រ៉ិះ ប៉ិះ អំប៉ាង។ ");
INSERT INTO brb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ញ៉ន អ៊ែ ឡើយ គ្រែដៃ ឡើ ប៉្រៃ អៃ ដក់ អន់នួរ វែ បក់ អាំ វែ ណាគ់ វន់ញិវ ដើម វន់ប៊ិច កួន ចូវ ទិ ឡាង ប្រិះ នែ ញ៉ន ដើ កាន ហវ៉ាត់ ទិះ ទុត ខាក់ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ត្រ អ៊ឺម វែ វ៉ើ ប៉្រៃ អៃ អដក់ ហឹ នែ គ្រែដៃ ហវ៉ៃ ឡើ ប៉្រៃ ឡើ ពឌឹក អៃ អបើម ទិះ ក្រាគ់ ប៉ូរ ពចោះ ប្រម៉ាង ដើ សឋិច ដើម អបើម កន់ដ្រាគ់ ដើ មែ ទឹង ហន់ណាម ក្រាន សឋិច ដឹប ឡើ ប៉្រៃ អៃ អពែក ប៉ាក់ លែក ដើ ស្រុក អ៊ែស៊ីប ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ប៉ាគ់ អ៊ែ អ៊ូគ អោះ អើយ វន់ជឹ ហាយ ទឹង បើគ ណិះៗ ឡើយ វន់ហាយ រៀន “កួន ហៃ យ៉ូស៊ែប អ៊ែ គ្រែដៃ ឡើ ពឌឹក ណគ បើម ទិះ ក្រាគ់ ពែក ប៉ាក់ លែក ដើ ស្រុក អ៊ែស៊ីប។ អ៊ែ ឡើ ប៉្រៃ ហៃ ហន់ទឺះ ទិ ណគ ដ្រិះៗ ញ៉ង ហពញ៉ាក អ៊ឺម ");
INSERT INTO brb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ហន់ទឺះ គូ ប្លះ ប៊្រី ដាក ឝ៉ូស៊ែន ចើម ណគ ហៃ ដើម កួន ចូវ ហៃ បណាន់ ហំប៉ង ហៃ ប៉ាគ់ ឡើ បប៊ែ ចៀម ឝ៉ូ លែក ដើ ប្រនិច ហៃ ហន់តៀត អាំ តូច។ ");
INSERT INTO brb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","បើគ អើយ ទិ អ៊ែ យ៉ូស៊ែប លំចៀម ហៃ អាំ ហៃ ដើម មែ ទឹង ហន់ណាម ក្រាន ហៃ ដឹប លែក ដើ ប្រនិច ហៃ ញ៉ង អាំ មន់ប៉ាត់ ពណាត់ យ៉ាក់ កាន អឹត ហរុ នែ ណាគ់ សើង កម៉ អន់ណាវ”»។ ");
INSERT INTO brb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","យ៉ូស៊ែប ឡើ ម៉ាង ឡឹះ រៀន៖ «វែ វ៉ើ តៃ អៃ ដើ ម៉ាត់ ឡើយ ប៊ែនយ៉ាមីន ឡើ តៃ ប៉ាគ់ទឺ អៃ កឡឹ ឡើយ អចជែ អរែង ប៊ឹង វែ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ឡា មែ អ៊ូគ អោះ អើយ វន់ជឹ ប៉ច ដើ បើគ អាំ លំណោះ អៃ អបើម ទិះ ក្រាគ់ ទឹង ស្រុក អ៊ែស៊ីប នែ ដើម លែក ណគ់ អង់ង៉ាយៗ វ៉ើ តៃ វន់ជឹ ប៉ច ដើ ណគ អាំ លែក។ វន់ច្រា ណគ លំទឺះ តូយ វែ ដ្រិះៗ ទិ នែ យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ប៊្លី អ៊ែ យ៉ូស៊ែប ឡើ អម កវ៉ាត់ ប៊ឹង ដង់ អោះ ណគ ប៊ែនយ៉ាមីន ឡើ ញឺម ប្រយ អ៊ែ ដើ ប៊ែនយ៉ាមីន ឡើ ញឺម អម កវ៉ាត់ ប៉ាគ់ទឺ អ៊ូគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ប៊្លី អ៊ែ អន់ណាវ ឡើ អម មុក លែក មែ អ៊ូគ អា ណគ ដើម ឡើ ញឺម ដិ។ អ៊ែ លែក មែ អំម៉ោះ អោះ ម៉ើ ចជែ ប៉្រាច ហំម៉ាច ម៉ាង ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","អំម៉ោះ អោះ យ៉ាគ់ យ៉ូស៊ែប ម៉ើ ប៊ឹះ ហឹ នែ ឡើយ ឡើ លឺ ប៊ឹះ ហឹ ហន់ណាម សឋិច អ៊ែ សឋិច ដើម មែ ទិះ ក្រាគ់ ម៉ើ ញឹម ក្លើម ប៉ាគ់ទឺ ដើ កាន នែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","សឋិច ឡើ ហាយ ដើ យ៉ាគ់ យ៉ូស៊ែប រៀន៖ «ហំប៉្រៃ អំម៉ោះ អោះ ហៃ មន់ព្រឌុក ចិះ ភែ ទិ សិះ លៀ មន់ជឹ ទឹង ស្រុក កាណាន ");
INSERT INTO brb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","អ៊ែ មន់ច្រា បើគ ហៃ ដើម លែក ដើ ក្រាន ណគ មន់ទឺះ គូ ទិ ស្រុក អៃ នែ អ៊ែ អង់អាំ ដើ មែ ប្រិះ ប៊្រី ចាគ់ ជឺរ បូវ ទិ ស្រុក អ៊ែស៊ីប នែ អ៊ែ មន់ដូវ ចិះ ភែ ពឺរ ប៉្លៃ ញឹមៗ ចាគ់ៗ តើម ប៊ឹង ប្រិះ អន់នែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ហំប៉្រៃ មែ អំម៉ោះ អោះ ហៃ មន់ជឹ តៀត កៀន តើម ប៊ឹង ស្រុក អ៊ែស៊ីប នែ បក់ មន់ព្រឌុក អន់ឈូន កួន ទ្រី មែ ដឹប មែ អង់ឝ្លែត អង់អាង ដើម មន់ពឈិះ បើគ វែ ដិ អាំ មន់ទឺះ ទិ នែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ញ៉ង មន់អំមួញ អ៊ឺម ប្រនិច មែ ទឹង អ៊ែ យ៉ាក់ ទិ ស្រុក អ៊ែស៊ីប នែ មន់ដូវ ប៊្រី ដាក ចាគ់ ជឺរ បូវ»។ ");
INSERT INTO brb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","មែ កួន កឡ យ៉ាគ់ អ៊ីស្រាអ៊ែល(ម៉ើ ជុ យ៉ាកុប ដិ) ម៉ើ ចាប់ ប្រយ ពន់ដ្រៃ សឋិច។ អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ អាំ កៀន ដើ មែ តាម ប៉ាគ់ ពន់ដ្រៃ សឋិច ដើម ឡើ អាំ ចណង់ ចណា តៃ ទ្រូង ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ឡើ អាំ ប្រវ៉ើន ហណក ហន់ដើម ដើ មែ អ៊ូគ ណគ ត្រំ រ៉ា មូយ ហំប៊្រុកៗ អ៊ែ ណគ់ ដើ ប៊ែនយ៉ាមីន អន់ណាវ ឡើ អាំ កាក់ ប៉្រាក់ ពែ ក្លាំ កាក់ ដើម ប្រវ៉ើន ហណក ហន់ដើម សើង ហំប៊្រុក ដិ។ ");
INSERT INTO brb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ណគ់ ដើ បើគ ណគ អន់ណាវ យ៉ូស៊ែប ឡើ ផាក សិះ លៀ សារ ជិត អំប៉ម ឡើ ប៉្រៃ ក៝ត ណគ ម៉ើ ព្រឌុក ម៉ាត់តូវ រ៉ាះ ចណុង ចណាគ់ តើម ប៊ឹង ស្រុក អ៊ែស៊ីប ដើម សិះ លៀ យូ ជិត អំប៉ម ម៉ើ ព្រឌុក ចិះ ភែ ចណង់ ចណា អង់គែងៗ ជឹ ឈូន ដើ បើគ ណគ លំចង់ តៃ ទ្រូង។ ");
INSERT INTO brb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ប៊្លី អ៊ែ ឡើ ប៉្រៃ មែ ម៉ើ ជឹ ដើម ឡើ ថាន់ រៀន៖ «ញ៉ង វ៉ើ ព្រសិញ ត្រម៉ាង អ៊ឺម ឋាយ តៃ ទ្រូង»។ ");
INSERT INTO brb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ម៉ើ វីះ តើម ប៊ឹង ស្រុក អ៊ែស៊ីប អ៊ែ ម៉ើ ប៊ឹះ បើគ មែ យ៉ាគ់ យ៉ាកុប ទឹង ស្រុក កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ម៉ើ ប៉ច ប្រយ ដើ បើគ មែ រៀន៖ «អើយ បើគ យ៉ូស៊ែប ណាគ់ ញិវ ហណោះ ណិះៗ ឡើ ពែក ប៉ាក់ លែក ដើ ស្រុក អ៊ែស៊ីប»។ យ៉ាគ់ អ៊ីស្រាអ៊ែល ព្រឺ ហឡឹង ប្រយ ឡើ គូ ឡើ ចាប់ អ៊ឺម ម៉ាង មែ។ ");
INSERT INTO brb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","តគ់ មែ កួន ណគ ម៉ើ ប៉ច លែក ដើ ប្រម៉ាង យ៉ូស៊ែប ឡើ ហាយ ដើម ឡើ តៃ កៀន យ៉ូស៊ែប ឡើ អាំ ដើ មែ ម៉ើ ជឹ ចក់ ណគ ប៊ឹង អ៊ែ ឡើ ដុង ឞ៊្រី ញឹម ក្លើម ភឺង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","អ៊ែ ឡើ ម៉ាង រៀន៖ «ដាវ អចាប់ ឡើយ ម៉ាង វែ កួន អៃ យ៉ូស៊ែប ឡើ ណាគ់ ម៉ាត់ ម៉ាត! អន់ទឺះ ឡើយ អៃ អ៊ិន អ៊ែ អន់តៃ ណគ តាម ណាគ់ អញិវ»។ ");
INSERT INTO brb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ វីះ ប្រយ ឡើ តៀត លែក ដើ ក្រាន លែក ដើ ប្រនិច ណគ។ ហំប៊្រុះ ម៉ើ ប៊ឹះ តគ់ ស៊្រុក ប៊ែរ ស៊ែបា យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ បប៊ុះ ថួយ ប្រយ ដើ គ្រែដៃ ឡើ កន់ដ្រាគ់ បើគ ណគ អ៊ីសាគ់។ ");
INSERT INTO brb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","មាំង អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល (ម៉ើ ជុ ណគ យ៉ាកុប ដិ) ឡើ តៃ ប្រាវៗ គ្រែដៃ ឡើ ពដៃ ចាក់ ឡើ កឡូវ ណគ រៀន៖ «យ៉ាកុប! យ៉ាកុប អើយ!»។ អ៊ែ ឡើ ត្រណើវ រៀន៖ «ង៉ាយ យ៉ាគ់ កន់ដ្រាគ់?»។ ");
INSERT INTO brb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","គ្រែដៃ ឡើ ហាយ ដើ ណគ រៀន៖ «អៃ នែ ឡើយ អគ្រែដៃ អកន់ដ្រាគ់ បើគ ហៃ។ ញ៉ង ហឌូង អ៊ឺម ហន់ទឺះ គូ ទិ ស្រុក អ៊ែស៊ីប យ៉ាក់ ទិ អ៊ែ ឡើយ អៃ អន់អាំ ដើ ហៃ ហំវឹរ សុនសាត ទុត ទិះ។ ");
INSERT INTO brb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","អៃ អន់ដក់ អរែង ប៊ឹង ហៃ ទិ ស្រុក អ៊ែស៊ីប អ៊ែ ហឹ ខៃ ណូវ អំជឹ តៀត តវឹញ កួន ចូវ ហៃ ទឹង ស្រុក អន់នែ ទឺ អន់ណាវ។ តគ់ ហន់គែត យ៉ូស៊ែប លំហ្រលែប ពលិប ម៉ាត់ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ វីះ តើម ប៊ឹង ស៊្រុក ប៊ែរ ស៊ែបា។ កួន កឡ ណគ ម៉ើ ហយៀក ពឌឹក បើគ មែ ទ្រី មែ ដើម កួន អង់គ្លែត មន់ឈិះ កៀន ណគ់ សឋិច ឡើ ផាក ដើ មែ មន់ព្រឈិះ។ ");
INSERT INTO brb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ម៉ើ តៀត បណាន់ ហំប៉ង ដើម ប្រនិច មែ ម៉ើ ដូវ ទឹង ស្រុក កាណាន។ អ៊ែ យ៉ាគ់ យ៉ាកុប ដើម លែក ដើ កួន ចូវ ណគ ម៉ើ ប៊ឹះ ទិ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ឡើ តៀត លែក ដើ កួន កទ្រី កួន កឡ ចូវ កទ្រី ចូវ កឡ លែក ដើ ក្រាន ឆ្រាំង ណគ ម៉ើ ទឺះ គូ ទិ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","អន់នែ ឡើយ ចនុ ម៉ាត់ កួន ចូវ យ៉ាគ់ អ៊ីស្រាអ៊ែល(ម៉ើ ជុ យ៉ាកុប ដិ) ម៉ើ ទឺះ គូ ទិ ស្រុក អ៊ែស៊ីប ឡើ ប៊ិច ណគ កឡឹ ដើម មែ កួន កឡ ណគ។ យ៉ាគ់ យ៉ាកុប កួន ឡង់ កឡ ណគ រូប៊ែន។ ");
INSERT INTO brb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","កួន កឡ យ៉ាគ់ រូប៊ែន ម៉ើ ជុ ម៉ាត់ មែ ហាណុក ប៉ាលូ ហ៊ែតស្រុន ដើម កាមី។ ");
INSERT INTO brb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","កួន កឡ យ៉ាគ់ ស៊ីមៀន ម៉ើ ជុ ម៉ាត់ មែ យែមូអ៊ែល យ៉ាមីន អូហាត់ យ៉ាគីន សូហារ ដើម សូល។ សូល នែ មែគ ណគ សុនសាត កាណាន។ ");
INSERT INTO brb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","កួន កឡ យ៉ាគ់ លែវី ម៉ើ ជុ ម៉ាត់ មែ ឝែរ៉ាសុន គែហាត់ ដើម មែរ៉ារី។ ");
INSERT INTO brb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","កួន កឡ យ៉ាគ់ យូដា ម៉ើ ជុ ម៉ាត់ មែ អ៊ែរ អូណាន់ ស៊ែឡា ពែរែះ ដើម ស៊ែរ៉ះ។ អ៊ែរ អំប្រា អូណាន់ នែ អំប្រា គែត ឡើយ ហឹ ស្រុក កាណាន ។ កួន កឡ យ៉ាគ់ ពែរែះ ម៉ើ ជុ ហ៊ែតស្រុន អំប្រា ហាមុល។ ");
INSERT INTO brb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","កួន កឡ យ៉ាគ់ អ៊ីសាខារ ម៉ើ ជុ ម៉ាត់ មែ តូឡា ពូវ៉ា យ៉ូប ដើម ស៊ីមរ៉ូន។ ");
INSERT INTO brb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","កួន កឡ យ៉ាគ់ សាប់យូឡូន ម៉ើ ជុ ម៉ាត់ មែ ស៊ែរែត អ៊ែឡូន អំប្រា យ៉ាលៀល។ ");
INSERT INTO brb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","មែ លែក នែ កួន ចូវ យ៉ាគ់ យ៉ាកុប ប៊ឹង យ៉ាគ់ លែអា ទឹង ណាគ់ ឡើ គូ ហឹ ស្រុក មែសូប៉ូតាមី។ ដើម ឡើ ប៊ិច កួន កទ្រី មូយ ម៉ាត់ ណគ ណាង ឌីណា។ កួន ដឹប ចូវ កទ្រី កឡ ម៉ើ កើត តើម ប៊ឹង លែអា ប៊ិច លែក អ៊ែ ពែ ជិត ពែ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","កួន កឡ យ៉ាគ់ ឝ៉ាត ម៉ើ ជុ ម៉ាត់ មែ ស៊ែផុន ហាគី ស៊ូនី អិះបូន អ៊ែរី អារ៉ូឌី ដើម អារែលី។ ");
INSERT INTO brb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","កួន កឡ យ៉ាគ់ អាស៊ែរ ម៉ើ ជុ ម៉ាត់ មែ យីមណា យីះវ៉ា យីះវី ប៊ែរៀ ដើម ណាង ស៊ែរ៉ា។ កួន កឡ យ៉ាគ់ ប៊ែរៀ ម៉ើ ជុ ហ៊ែប៊ែរ អំប្រា ម៉ាលកៀល។ ");
INSERT INTO brb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","លែក មែ ជិត ត្រូវ រ៉ា នែ ម៉ើ ត្រ កួន ដើម ចូវ ណាង ស៊ីលប៉ា ប៊ឹង យ៉ាគ់ យ៉ាកុប ណាង ស៊ីលប៉ា នែ ឡាបាន់ ឡើ អាំ ដើ កួន ណគ ណាង លែអា បើម ក៝ត។ ");
INSERT INTO brb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","កួន កឡ រ៉ាជែល ទ្រី យ៉ាគ់ យ៉ាកុប ឡើ ប៊ិច យ៉ូស៊ែប អំប្រា ប៊ែនយ៉ាមីន។ ");
INSERT INTO brb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ហឹ ស្រុក អ៊ែស៊ីប យ៉ូស៊ែប អំប្រា ណាង អាះណាត់ អំប្រា ប៊ិច កួន កឡ បារ រ៉ា ម៉ាត់ អំប្រា ម៉ាណាស៊ែ អ៊ែប៉្រាអ៊ីម។ ណាង អាះណាត់ នែ ឡើ ត្រ កួន យ៉ាគ់ ប៉ូទីភែរ៉ា ឡើ កឡា បប៊ុះ ថួយ ហឹ មួង អូន។ ");
INSERT INTO brb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","កួន កឡ យ៉ាគ់ ប៊ែនយ៉ាមីន ម៉ើ ជុ ម៉ាត់ មែ ប៊ែឡា ប៊ែគែរ អាះបិល ឝែរ៉ា ណាម៉ាន អ៊ែហ៊ី រ៉ូះ មូភីម ហ៊ូភីម ដើម អារ។ ");
INSERT INTO brb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","បូវ មែ នែ កួន ដើម ចូវ ណាង រ៉ាជែល ប៊ឹង យ៉ាគ់ យ៉ាកុប។ កួន ដើម ចូវ លែក អ៊ែ ជិត ពួន រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","កួន កឡ យ៉ាគ់ ដាន់ នែ ម៉ើ ជុ ម៉ាត់ ណគ ហ៊ូស៊ីម។ ");
INSERT INTO brb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","កួន កឡ យ៉ាគ់ នែបថាលី ម៉ើ ជុ ម៉ាត់ មែ យ៉ាសៀល ឝូនី យែស៊ែរ ដើម ស៊ីលែម។ ");
INSERT INTO brb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","លែក ប៉ឹះ រ៉ា នែ កួន ដើម ចូវ ណាង ប៊ីលហា ប៊ឹង យ៉ាគ់ យ៉ាកុប។ ណាង ប៊ីលហា នែ យ៉ាគ់ ឡាបាន់ ឡើ អាំ ដើ កួន ណគ ណាង រ៉ាជែល បើម ក៝ត។ ");
INSERT INTO brb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","កួន ចូវ យ៉ាគ់ យ៉ាកុប ម៉ើ ទឺះ គូ ទិ ស្រុក អ៊ែស៊ីប លែក ដើ អ៊ែ ត្រូវ ជិត ត្រូវ រ៉ា ញឹះ តៃ កាវ កម៉ាន់។ ");
INSERT INTO brb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","យ៉ាគ់ យ៉ូស៊ែប ឡើ ប៊ិច កួន កឡ បារ ហឹ ស្រុក អ៊ែស៊ីប។ ពអ៊ែ ឡើយ លែក ដើ កួន ចូវ យ៉ាគ់ យ៉ាកុប ម៉ើ ទឺះ គូ ទិ ស្រុក អ៊ែស៊ីប ឡើ ប៊ិច ប៉ឹះ ជិត រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ណាគ់ ទឹង ទ្រូង យ៉ាគ់ យ៉ាកុប ឡើ ប៉្រៃ យូដា ដក់ អន់នួរ ហឹ យ៉ូស៊ែប បក់ លំតង៉ា ទ្រូង ដក់ ហឹ ឝ៉ូស៊ែន។ តគ់ ម៉ើ ប៊ឹះ ហឹ ប៊្រី ដាក ឝ៉ូស៊ែន ឡើយ ");
INSERT INTO brb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ តាំ កៀន ប៊ឹង សិះ ដក់ យ៉ាវ បើគ ណគ ហឹ ឝ៉ូស៊ែន ហំប៊្រុះ ឡើ តៃ បើគ ណគ ឡើ អម កវ៉ាត់ ប៊ឹង ដង់ ឡើ ញឺម ទុត ឌុញ។ ");
INSERT INTO brb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ម៉ាង ហឹ យ៉ូស៊ែប រៀន៖ «ណិះៗ នែ កួន អើយ សំ អង់គែត ដូវ ឡើយ យ៉ាក់ អតៃ ឡើយ មុះ ម៉ាត់ ហៃ ណាគ់ ហញិវ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","យ៉ូស៊ែប ឡើ ហាយ ដើ អំម៉ោះ អោះ ណគ ដើម ដើ មែ ទឹង ក្រាន បើគ ណគ រៀន៖ «អៃ អន់ឌឹក ហាយ ដើ សឋិច អន់រៀន “អំម៉ោះ អោះ ដើម ក្រាន បើគ អៃ ណគ់ ម៉ើ ខើយ គូ ទឹង ស្រុក កាណាន ម៉ើ ប៊ឹះ ទិ អៃ នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","បូវ មែ នែ ម៉ើ ខើយ ពែក បណាន់ ប៉ាគ់ ឡើ បប៊ែ ចៀម ឝ៉ូ ណគ់ បណាន់ ដើម លែក ដើ ប្រនិច មែ ម៉ើ តៀត ប៉ាគ់ទឺ”»។ ");
INSERT INTO brb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","យ៉ាគ់ យ៉ូស៊ែប ឡើ ថាន់ អំម៉ោះ អោះ ណគ រៀន៖ «ប៊ឹង សឋិច លំកឡូវ វែ ដក់ ហឹ ណគ ដើម លំតង៉ា វែ រៀន “ប៉ាគ់ ង៉ាយ វ៉ើ ដាំង ចា?” ");
INSERT INTO brb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","អ៊ែ វន់ត្រណើវ រៀន “យ៉ាគ់ សឋិច អើយ ញ៉ា នែ ញ៉ើ ខើយ ពែក បណាន់ តើម ប៊ឹង ញ៉ើ អង់គ្លែត ពន់ឋើម ឆា ដើ ប៊ឹះ ត្រំ តង៉ៃ នែ ប៉ាគ់ ម៉ិ យ៉ាគ់ ញ៉ា ឡៃ មាំង ទឺ”។ ប៉ាគ់ វន់ត្រណើវ ពអ៊ិន អ៊ែ លំអាំ ដើ វែ វន់គូ ហឹ ប៊្រី ដាក ឝ៉ូស៊ែន នែ យ៉ាក់ មែ សុនសាត អ៊ែស៊ីប ម៉ើ ហំម៉ឹ ដើ មែ ម៉ើ ពែក បប៊ែ ចៀម»។ ");
INSERT INTO brb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","អ៊ែ យ៉ូស៊ែប ឡើ ច្រា មែ អំម៉ោះ អោះ ណគ សើង រ៉ា ជឹ តូយ ណគ អ៊ែ ណគ ឡើ ដក់ ហឹ សឋិច ឡើ ហាយ រៀន៖ «យ៉ាគ់ សឋិច អើយ បើគ ដើម អំម៉ោះ អោះ អៃ ម៉ើ ប៊ឹះ តើម ប៊ឹង ស្រុក កាណាន ឡើយ ម៉ើ តៀត បប៊ែ ចៀម ឝ៉ូ ដើម លែក ដើ ប្រនិច មែ ដិ ណិះៗ នែ ម៉ើ គូ ទិ ប៊្រី ដាក ឝ៉ូស៊ែន តគ់ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ ច្រា មែ អំម៉ោះ អោះ ណគ ដក់ កដាប ហំបះ សឋិច អាំ លំហង់ឝ៉ាវ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","សឋិច ឡើ តង៉ា អំម៉ោះ អោះ យ៉ូស៊ែប រៀន៖ «ប៉ាគ់ ង៉ាយ ដឹះ វ៉ើ ខើយ ដាំង ចា?»។ អ៊ែ ម៉ើ ត្រណើវ សឋិច រៀន៖ «យ៉ាគ់ សឋិច អើយ ញ៉ា នែ ញ៉ើ ខើយ ពែក បប៊ែ ចៀម ប៉ាគ់ ដើ ម៉ិ យ៉ាគ់ ញ៉ា ឡៃ មាំង ទឺ »។ ");
INSERT INTO brb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","មែ ម៉ើ ហាយ ឡឹះ ដើ សឋិច រៀន៖ «ញ៉ា ញ៉ើ ទឺះ គូ ទិ ស្រុក ហៃ អន់ដៃ យ៉ាក់ ទឹង ស្រុក កាណាន ឡើ ប៊ិច កាន អឹត ហរុ ទុត ខាក់ ប៊ឹះ បាត់ ដើ បប៊ែ ចៀម ញ៉ា មន់ចា ណាគ់ តៃ ប៊ិច យ៉ាវ។ ប៉ាគ់ ពអ៊ែ ឡា យ៉ាគ់ អ អើយ ញ៉ើ ឡា ហឹ ហៃ ហន់អាំ ញន់គូ ទិ ប៊្រី ដាក ឝ៉ូស៊ែន ចុ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","សឋិច ឡើ ម៉ាង ហឹ យ៉ូស៊ែប រៀន៖ «បើគ ហៃ ដើម អំម៉ោះ អោះ ហៃ ម៉ើ ទឺះ គូ ទិ ហៃ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ហៃ ហរន់ឋាប់ ឝ្លាំង លែក ដើ ស្រុក អ៊ែស៊ីប នែ ហន់អាំ ដើ មែ បើគ ហៃ មន់គូ ហឹ ប៊្រី ដាក ចាគ់ៗ ជឺរ មន់គូ តគ់ ឝ៉ូស៊ែន អ៊ែ ឡើយ ឆិ។ ហន់ឝ្លាំង ទឹង អំម៉ោះ អោះ ហៃ ប៉ាគ់ ហន់តៃ មែ ង៉ាយ មន់ប៊ិច ខនឹត អ្រណោះ អ្រទីង ហំពឌឹក មែ មន់បើម កឡា ពែក បណាន់ អៃ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","យ៉ាគ់ យ៉ូស៊ែប ឡើ ច្រា បើគ ណគ យ៉ាកុប អន់ណាវ ដក់ ហឹ សឋិច បក់ សឋិច លំហង់ឝ៉ាវ ប៉ាគ់ទឺ។ យ៉ាគ់ យ៉ាកុប ឡើ ប្រាយ កាន ចាគ់ ដើ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","អ៊ែ សឋិច ឡើ តង៉ា យ៉ាគ់ យ៉ាកុប រៀន៖ «អើយ យ៉ាគ់ អ ឞាល់ ង៉ាយ ឡើយ កំប្រាគ់ ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","យ៉ាគ់ យ៉ាកុប ឡើ ត្រណើវ រៀន៖ «កំប្រាគ់ អៃ មូយ ក្លាំ ពែ ជិត កម៉ ឡើយ។ អៃ អពលិះ កនូ អន់សច ប៉ាគ់ ម៉ិ យ៉ាគ់ អៃ ទឺ ដើម អជូល កាន ធុក ញ៉ាក ទុត អើន ដិ។ អញុ អៃ តៃ ឝ៉ុះ អ៊ឺម អំញិវ ប៉ោះ អ៊ឺម ឞាល់ ម៉ិ យ៉ាគ់ អៃ ឡៃ មាំង»។ ");
INSERT INTO brb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ប្រាយ ឡឹះ អន់ណាវ កាន ចាគ់ ដើ សឋិច លែវ អ៊ែ ឡើ វីះ តាក់ ម៉ាង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","យ៉ាគ់ យ៉ូស៊ែប ឡើ អាំ ប្រយ ប៊្រី ដាក ទុត ចាគ់ ជឺរ ទឹង ស្រុក អ៊ែស៊ីប ហឹ ប៊្រី ដាក រ៉ាមសិះ ដើ មែ បើគ ណគ មន់គូ តាម ប៉ាគ់ ពន់ដ្រៃ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","យ៉ូស៊ែប ឡើ ចៀម មែ បើគ ណគ ដើម លែក ដើ មែ ទឹង ក្រាន ណគ តាម ប៉ាគ់ អំម៉ើន កួន ចូវ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ទឹង អ៊ែ លែក ដើ ស្រុក អ៊ែស៊ីប ដើម ស្រុក កាណាន ហ៊ែង ចាំ ម៉ៃៗ ម៉ើ អឹត ហរុ ញឹះ តៃ ប៊ិច អង់ង៉ាយ មន់ចា យ៉ាវ។ ត្រំ អប៊ុ ត្រំ ឞន ចាំ តៃ ម៉ើ សូវ ប៉្លុះ ញ៉ន ដើ កាន អឹត ហរុ នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","លែក ដើ លៀន មែ ស្រុក អ៊ែស៊ីប ដើម ស្រុក កាណាន ម៉ើ ដក់ រួត ចិះ ភែ ហឹ យ៉ូស៊ែប យ៉ូស៊ែប ឡើ តមួត ជុ ទឹង ខ្លៀង សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","តគ់ លៀន ប៉្រាក់ មែ ស្រុក អ៊ែស៊ីប ដើម មែ ស្រុក កាណាន ឡើ តូច ឡើយ អ៊ែ លែក ដើ មែ ទឹង ស្រុក អ៊ែស៊ីប ម៉ើ ដក់ ឡា ហឹ យ៉ាគ់ យ៉ូស៊ែប រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ហំពឝ្រ៉ា អាំ ចិះ ដើ ញ៉ា អុះ ប៉ាគ់ តៃ ហំប៉ូរ ញ៉ា ឃឺ ឞិ ញន់គែត ឝ៉្លក ប៊ឹង ងឺរ ហៃ យ៉ាក់ ញ៉ើ ប៊ិច យ៉ាវ លៀន»។ ");
INSERT INTO brb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","យ៉ាគ់ យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ លៀន វែ ឡើ លែក ឡើយ វន់តៀត បណាន់ វែ អន់ណាវ វន់វ៉ាក់ ចិះ អ៊ែ អង់អាំ ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ប៉ាគ់ ពអ៊ែ ម៉ើ តៀត បណាន់ មែ ហឹ យ៉ាគ់ យ៉ូស៊ែប អ៊ែ យ៉ូស៊ែប ឡើ អាំ ចិះ ដើ មែ ម៉ើ វ៉ាក់ ដើ សិះ បប៊ែ ចៀម ឝ៉ូ ដើម លៀ ដិ។ ទឹង កម៉ អ៊ែ ម៉ើ ដូវ ចណង់ ចណា តើម ប៊ឹង យ៉ូស៊ែប ញ៉ន ម៉ើ វ៉ាក់ ដើ បណាន់ មែ។ ");
INSERT INTO brb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","កម៉ អ៊ែ ក្លើច ឡើយ តគ់ កម៉ អន់ទុន ម៉ើ ដក់ ឡឹះ អន់ណាវ ម៉ើ ម៉ាង រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ តៃ ញ៉ើ អំម៉គ់ កដក អ៊ឺម ដើ ហៃ លៀន ប៉្រាក់ ញ៉ា លែក ឡើយ បណាន់ ហំប៉ង ញ៉ើ អាំ ដើ ហៃ លែក ឡើយ ណិះៗ នែ វ៉ិះ ញ៉ើ ប៊ិច ឌិវ ចាក់ ដើម ប្រិះ មឺរ ណា ឡើយ ញំម៉ប ដើ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ប៉ិ លំរ៉គ់ ឞិ ញន់គែត ឝ៉្លក ប៊ឹង ងឺរ ហៃ ដើម ពដិះ បយឺង ញ៉ា លំគូ មិៗ? ណិះៗ នែ ឡា កន់ដ្រាគ់ អើយ ហំរួត ចាក់ ញ៉ា ដើម ប្រិះ មឺរ ណា ញ៉ា នែ ហន់វ៉ាក់ ដើ ចិះ ភែ។ ពដិះ ញ៉ា លំត្រ ពដិះ សឋិច ឡើយ អ៊ែ ណគ់ ញ៉ា កឡឹ ញន់ក៝ត សឋិច ប៉ាគ់ទឺ។ ឡា យ៉ាគ់ កន់ដ្រាគ់ ហន់អាំ ហឌឺវ ចិះ ដើ ញ៉ា ញំដាំ ពឝ៉ើត អ៊ែ ណាគ់ ញន់ញិវ កើត ដើម ពដិះ បយឺង ញ៉ា តៃ លំទឺវ មិៗ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ញ៉ន ដើ ម៉ើ អឹត ហរុ ចាំ ម៉ៃៗ អ៊ែ មែ សុនសាត អ៊ែស៊ីប ម៉ើ ហំពួត ពដិះ មឺរ ណា មែ ត្រំ រ៉ា យ៉ូស៊ែប ឡើ រួត លែក ដើ ពដិះ មែ ឈូន ដើ សឋិច អ៊ែ លែក ដើ ពដិះ ទឹង ស្រុក អ៊ែស៊ីប ឡើ ត្រ ប្រនិច សឋិច ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","អ៊ែ យ៉ូស៊ែប ឡើ បើម អាំ លែក ដើ ប៉ាសាសុន បុ ស្រុក អ៊ែស៊ីប ម៉ើ ក៝ត សឋិច ឡើយ ។ ");
INSERT INTO brb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ឌិវ មែ កឡា បប៊ុះ ថួយ ណាគ់ ឡើ ណាគ់ ពដិះ មែ យ៉ូស៊ែប ឡើ រួត អ៊ឺម យ៉ាក់ សឋិច ឡើ អាំ ចណង់ ចណា ដើ មែ ឆិ ចង់ អ៊ែ ម៉ើ តង កាន អ៊ឺម មន់ហំពួត ពដិះ។ ");
INSERT INTO brb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","យ៉ូស៊ែប ឡើ ហាយ ហឹ មែ ប៉ាសាសុន រៀន៖ «តង៉ៃ នែ អៃ អរួត វែ ដើម ពដិះ មឺរ វែ លែក ឡើយ អឈូន ដើ សឋិច។ នែ អង់គុង ចិះ វន់ដក់ ដាំ ហឹ មឺរ ណា។ ");
INSERT INTO brb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","តគ់ ប៊ឹះ ញ៉ាម កៀវ ចិះ ឡើយ ប៉ាគ់ វន់ដូវ សើង កថាំង វន់អាំ ដើ សឋិច មូយ កថាំង អ៊ែ ណគ់ ពួន កថាំង វន់ជុ អង់គុង ដាំ កម៉ អន់ទុន ដើម វន់ចង់ ចា ទឹង ក្រាន វែ កឡឹ ដើម កួន ចូវ វែ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ម៉ើ ត្រណើវ រៀន៖ «ចាគ់ ឡើយ យ៉ាគ់ កន់ដ្រាគ់ ហពឝ៉្រា ញ៉ា ហអាំ ញ៉ា ញ៉ើ ញិវ ញ៉ា នែ ញ៉ើ ក៝ត សឋិច ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","យ៉ាគ់ យ៉ូស៊ែប ឡើ ហាយ ចឞាប់ ហន់ដើម ដើ មែ ទឹង ស្រុក អ៊ែស៊ីប អាំ មន់បើម ត្រួយ អន់សច ប៊ឹះ ត្រំ តង៉ៃ នែ ឡើ ហាយ រៀន មែ មន់ចក់ ចិះ មន់ដូវ តើម ប៊ឹង មឺរ ណា មែ កនុង សើង កថាំង មន់ដក់ ម៉ប ដើ សឋិច មូយ កថាំង។ វ៉ិះ ឌិវ ពដិះ មឺរ ណា មែ កឡា បប៊ុះ ថួយ ឡើយ ឡើ ត្រ អ៊ឺម ពដិះ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","អ៊ែ មែ អ៊ីស្រាអ៊ែល ម៉ើ គូ ទឹង ស្រុក អ៊ែស៊ីប ប្លះ ប៊្រី ដាក ឝ៉ូស៊ែន ប្រិះ មែ ម៉ើ គូ អ៊ែ ឡើ ត្រ ប្រិះ មែ កឡឹ ឡើយ។ ម៉ើ ស៊ឺក តាក ម៉ើ ប៊ិច កួន ចូវ ចាំ អើនៗ ");
INSERT INTO brb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","យ៉ាគ់ យ៉ាកុប ឡើ គូ ទឹង ស្រុក អ៊ែស៊ីប ជិត ប៉ឹះ កម៉។ កំប្រាគ់ ណគ លែក អ៊ែ មូយ ក្លាំ ពួន ជិត ប៉ឹះ កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","តគ់ ដៀប លន់គែត ឡើយ អ៊ែ ឡើ កឡូវ កួន ណគ យ៉ូស៊ែប ដក់ ហឹ ណគ ឡើ ថាន់ រៀន៖ «ឡា កួន អើយ ប៉ាគ់ ហប៊ិច ក្លើម ចាគ់ ដើ អៃ ម៉ាត់ ម៉ាត ហន់ជុ ទី ក្រូម ប៊្លូ អៃ នែ  ហន់ខណាត រៀន ហំពដៃ ក្លើម ចាគ់ ទឹង ត្រ ដើម ប្រម៉ើត អញ៉ុ ដាវៗ ដើ អៃ តគ់ អង់គែត ញ៉ង ហចះ អ៊ឺម អៃ ទឹង ស្រុក អ៊ែស៊ីប នែ យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","តគ់ អង់គែត ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ អៃ ហំជឹ តៀត អៃ តើម ប៊ឹង អ៊ែស៊ីប នែ ហន់ជុ ហឹ ត្រម ច្រាង កយ៉ក់ ម៉ិ យ៉ាគ់ អៃ»។ យ៉ាគ់ យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «អ៊ឺគ បើគ អៃ អំបើម តាម ប៉ាគ់ ប្រម៉ាង ហៃ អ៊ិន ឡើយ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ហាយ ឡឹះ រៀន៖ «មិញ កួន ហន់ខណាត តប៉ឹន ចាក់ ដើ អៃ ឡាំង»។ យ៉ូស៊ែប ឡើ តប៉ឹន ចាក់ ដើ បើគ ណគ។ ប៊្លី យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ចជែ លែវ ឡើយ ឡើ ប៊ូគ ទិ ទូះ កណី ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","តគ់ ប៊្លី អ៊ែ ប៊ិច មែ ម៉ើ ដក់ ហាយ ដើ យ៉ាគ់ យ៉ូស៊ែប រៀន៖ «បើគ ហៃ ឡើ ឈិ ម៉ៃ ឡើយ»។ អ៊ែ យ៉ូស៊ែប ឡើ ដក់ ឝ្លាំង បើគ ណគ ឡើ តៀត កួន ណគ លែក បារ ម៉ាណាស៊ែ ដើម អ៊ែប្រ៉ាអ៊ីម។ ");
INSERT INTO brb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ប៊ិច មែ ម៉ើ ហាយ ដើ យ៉ាគ់ យ៉ាកុប រៀន៖ «កួន ហៃ យ៉ូស៊ែប ឡើ ប៊ឹះ ឡើយ ហឹ នែ»។ អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ខំ ពន់ដ្រើង ឌឹក ដ្រូម ប៊ឹង ឝ្រែ កណី ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ឡើ ហាយ ដើ យ៉ូស៊ែប រៀន៖ «គ្រែដៃ ឡើ ឆង៉ាត់ ទុត ខាក់ ឡើ ពដៃ ចាក់ ដើ អៃ ទឹង ស៊្រុក លូះ ហឹ ស្រុក កាណាន ឡើ ប្រាយ កាន ចាគ់ ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ឡើ ហាយ ដើ អៃ រៀន “អៃ អន់អាំ ហៃ ហន់ស៊ឺក តាក ហំប៊ិច កួន ចូវ ទុត អើន អ៊ែ ហន់វឹរ សុនសាត ទុត អើន។ អៃ អន់អាំ ពដិះ កាណាន ដើ កួន ចូវ ហៃ ហឹ អន់ទុន មន់ជុ ប្រិះ ប៊្រី មែ កឡឹ ឡូច អន់សច”»។ ");
INSERT INTO brb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","អ៊ីស្រាអ៊ែល ឡើ ហាយ អន់ណាវ រៀន៖ «ណិះៗ នែ កួន ហៃ អ៊ែប្រ៉ាអ៊ីម អំប្រា ម៉ាណាស៊ែ ណគ់ អំប្រា កើត ហឹ ស្រុក អ៊ែស៊ីប តៃ ដាន់ អៃ អប៊ឹះ អំជុ បើម ប៉ាគ់ កួន អៃ ប៉ាគ់ រូប៊ែន អំប្រា ស៊ីមៀន ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","អ៊ែ ណគ់ កួន ហៃ មន់កើត អន់ទុន មន់ត្រ កួន ហៃ កឡឹ ឡើយ មន់ដូវ ប្រិះ មូន មាំង យ៉ម អ៊ែប្រ៉ាអ៊ីម អំប្រា ម៉ាណាស៊ែ។ ");
INSERT INTO brb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","អបើម ប៉ាគ់ នែ យ៉ាក់ ប៊ឹង អជឹ តើម ប៊ឹង ស្រុក មែសូប៉ូតាមី មែគ ហៃ រ៉ាជែល ឡើ គែត តាក់ អៃ តៃ ទ្រូង ចើម ស្រ៊ុក អ៊ែប៉្រាតា ហឹ ស្រុក កាណាន អក្រង៉ឹត អង់ងឹះ ទុត ខាក់ អចះ ណគ ដៀក ទ្រូង ដក់ ហឹ ស្រ៊ុក អ៊ែប៉្រាតា»។ (តគ់ ណិះៗ ម៉ើ ជុ ស្រ៊ុក ប៊ែថ្លែហិម អន់ណាវ)។ ");
INSERT INTO brb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ តៃ កួន យ៉ូស៊ែប អ៊ែ ឡើ តង៉ា រៀន៖ «មែ ង៉ាយ ដឹះ អំប្រា នែ?»។ ");
INSERT INTO brb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","យ៉ាគ់ យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «កួន កឡ អៃ គ្រែដៃ ឡើ អាំ ទឹង អគូ ហឹ ស្រុក អ៊ែស៊ីប ណិះ ឡើយ»។ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ រៀន៖ «មិញ ហំប៉្រៃ អំប្រា លំដក់ ចឹម ចើម ហឹ អៃ នែ អៃ អន់ប្រាយ កាន ចាគ់ ដើ អំប្រា»។ ");
INSERT INTO brb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ទឹង អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល ម៉ាត់ ណគ ឡើ ត្រប៉ៃ លឹម បលឹម យ៉ាក់ ឡើ ក្រាគ់ៗ ម៉ៃ ឡើយ។ យ៉ូស៊ែប ឡើ ច្រា អំប្រា កួន ណគ ដក់ តគ់ បើគ ណគ អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ អម មុក អំប្រា ចូវ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ម៉ាង ហឹ យ៉ូស៊ែប រៀន៖ «ពន់ឋើម អឃឹត អន់តៃ យ៉ាវ មុះ ម៉ាត់ ហៃ។ ណិះៗ គ្រែដៃ ឡើ អាំ អៃ អតៃ ហៃ ដើម កួន ហៃ ដិ!»។ ");
INSERT INTO brb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","យ៉ូស៊ែប ឡើ ទឹក កួន ណគ តើម ប៊ឹង ត្រកូវ យ៉ាគ់ អំប្រា អ៊ែ ឡើ កដាប ហំបះ បើគ ណគ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ប៊្លី អ៊ែ យ៉ូស៊ែប ឡើ តៀត អន់ណាវ អំប្រា កួន ណគ ដក់ តគ់ បើគ ណគ អោះ ណគ អ៊ែប្រ៉ាអ៊ីម ឡើ ជុ តៃ ចអៀវ យ៉ាគ់ អ៊ីស្រាអ៊ែល អ៊ែ ដើ អ៊ូគ ណគ ម៉ាណាស៊ែ ឡើ ជុ តៃ ចម៉ា។ ");
INSERT INTO brb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ត្រវ៉ាត់ ពលិះ ទី ណគ ឡើ ជុ ទី ចម៉ា ណគ ពឺង ទូះ អោះ ណគ អ៊ែប្រ៉ាអ៊ីម ទី ចអៀវ ណគ ឡើ ជុ ពឺង ទូះ អ៊ូគ ណគ ម៉ាណាស៊ែ សំយ៉ះ ឡើ ឡង់។ ");
INSERT INTO brb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ប៊្លី អ៊ែ ឡើ ប្រាយ កាន ចាគ់ ដើ យ៉ូស៊ែប រៀន៖ «ឡា គ្រែដៃ អើយ ណគ់ យ៉ាគ់ អាប្រាហាំ ដើម បើគ អៃ អ៊ីសាគ់ អំប្រា ខើយ បើម ត្រួយ ដើម ហលវាំង ឝ្លាំង អៃ តើម ប៊ឹង អកើត ឆា ប៊ឹះ ត្រំ តង៉ៃ នែ ");
INSERT INTO brb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ហៃ ឡើយ ហប៉ូរ អៃ អក្លើច តើម ប៊ឹង កាន ខគ់ណាំ ត្រំ ហំឞ្លិច ឡា ហំប្រាយ កាន ចាគ់ ដើ កួន កឡ អៃ លែក បារ នែ ឡា ហន់អាំ អំប្រា លំត ម៉ាត់ អៃ ដើម ម៉ាត់ ម៉ិ យ៉ាគ់ អៃ យ៉ាគ់ អាប្រាហាំ ដើម បើគ អៃ អ៊ីសាគ់ ឡា ហន់អាំ អំប្រា លំប៊ិច កួន ចូវ ស៊ឺក តាក ទុត អើន ទិ ឡាង ប្រិះ!»។ ");
INSERT INTO brb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","យ៉ូស៊ែប ឡើ តៃ បើគ ណគ ឡើ ជុ ទី ចម៉ា ពឺង ទូះ អ៊ែប្រ៉ាអ៊ីម ប៉ាគ់ អ៊ែ ឡើ ដុង ស្រៀវ អ្រអវ ប្រយ។ ឡើ រ៉ាប់ ទី ចម៉ា បើគ ណគ ឡើ ឃឹត លំជុ ពលិះ តគ់ ទូះ ម៉ាណាស៊ែ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ដើម ឡើ គឹះ បើគ ណគ រៀន៖ «ត្រ អ៊ឺម បើគ ប៉ាគ់ នែ អ៊ូគ ណគ តៃ នែ ឡើ គូ ហន់ជុ ទី ចម៉ា ហៃ ពឺង ទូះ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","អ៊ែ បើគ ណគ ឡើ ច្រម៉ាន រៀន៖ «អណោះ ឡើយ កួន ម៉ាណាស៊ែ ឡើ ឡង់ ណគ លំវឹរ សុនសាត ទិះ ប៉ាគ់ទឺ។ ហាក់ ដើ អោះ ណគ អ៊ែប្រ៉ាអ៊ីម លំស៊ឺក ជឺរ ណគ អន់ណាវ ដើម កួន ចូវ ណគ មន់វឹរ សុនសាត ទុត អើន»។ ");
INSERT INTO brb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ទឹង តង៉ៃ អន់ទឺ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ប្រាយ លែក ដើ អំប្រា រៀន៖ «ហឹ ប៉ាង ខៃ ណូវ មែ សុនសាត អ៊ីស្រាអ៊ែល មន់យួរ ម៉ាត់ សប្រា ប៊ឹង មន់ប្រាយ បូវ មន់រៀន “គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ ហៃ ប៉ាគ់ ឡើ ប្រាយ អ៊ែប្រ៉ាអ៊ីម អំប្រា ម៉ាណាស៊ែ ទឺ!”»។ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ កឡូវ អន់នួរ អ៊ែប្រ៉ាអ៊ីម ហំប្លះ ម៉ាណាស៊ែ ។ ");
INSERT INTO brb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ ម៉ាង ហឹ យ៉ូស៊ែប រៀន៖ «អៃ នែ ដៀប អង់គែត ឡើយ! ហាក់ គ្រែដៃ ណាគ់ លំគូ ប៊ឹង វែ ដើម លំជឹ តៀត វែ ហឹ ស្រុក ម៉ិ យ៉ាគ់ ង៉ាយ កឡឹ ទឺ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","អៃ អម៉ប ដើ ហៃ ប្រិះ មូយ ពណាក អើន ជឺរ អំម៉ោះ អោះ ហៃ អអាំ ប៊្រី ដាក ស៊ីគែម ដើ ហៃ ណគ់ អៃ អចក់ ដ្រូក តើម ប៊ឹង សុនសាត អាម៉ូរី ដើ តាវ ស្រាវ អៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ កឡូវ មែ កួន កឡ ណគ ឡើ ហាយ រៀន៖ «មិញ វន់ដក់ ពស្រូម អ៊ែ អន់ហាយ ដើ វែ អាំ វន់ណោះ កាន លន់កើត ដើ វែ ហឹ ងឺរ អន់ទុន តគ់។ ");
INSERT INTO brb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«អើយ មែ កួន វន់ពស្រូម ចង់ហៀង បើគ វែ យ៉ាកុប វន់ចង់ហៀង ម៉ាង បើគ វែ អ៊ីស្រាអ៊ែល នែ។ ");
INSERT INTO brb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«អើយ រូប៊ែន ហកួន ឡង់ អៃ អពឝ៉ើត ហៃ អន់នួរ មែ ទឹង ណាគ់ អប៊ិច ពន់ដ្រិញ ពន់ដ្រួញ ញឹម សាំង ហៃ ហទិះ ក្រាគ់ ហប៊ិច អាតណាត ជឺរ មែ អោះ ហៃ ");
INSERT INTO brb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","កួន អើយ ចនិះ ហៃ តៃ ហបក់ ពង់អត់ ចនិះ ហៃ ឡើ បើម ប៉ាគ់ ដាក លូះ ម៉ើ រ៉ាប់ តៃ ដូវ យ៉ាក់ ហកី ដើ ទ្រី ដូច អៃ ហបើម កម៉ាវ ម៉ាត់ អៃ អ៊ែ ហន់ដូវ យ៉ាវ បើម ទិះ ក្រាគ់ ពឺង មែ អោះ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«ស៊ីមៀន លែវី អើយ សប្រា អំម៉ោះ អោះ សប្រា ឆ្រនែវ បើម កាន អរាំង មាំ ញឹះ ដើ តាវ ");
INSERT INTO brb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","អឈែវ អ៊ឺម អៃ ប៊ឹង សប្រា ប្រអៀង ដើ បូវ ដើម តៃ អឌី ប៉ាគ់ទឺ មឹត ពស៊ុំ ប៊ឹង សប្រា យ៉ាក់ ប៊ឹង សប្រា មាំ សប្រា កជែត បនឹះ ប៊ឹង សប្រា រ៉គ់សំ សប្រា កោះ ហហៀល ឆន ឝ៉ូ។ ");
INSERT INTO brb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","អៃ អំប្រាយ ប៊្រិត ប្រមាំ សប្រា យ៉ាក់ ឡើ ឃូយ អុង អៃ អំប្រាយ ប៊្រិត ប្រមាំ សប្រា យ៉ាក់ ឡើ អរាំង អៃ អំប៉្រៃ កួន ចូវ សប្រា មន់ត្រក្លះ ត្រក្លាយ ទឹង មែ កួន ចូវ យ៉ាកុប អៃ អំប៉្រៃ កួន ចូវ សប្រា មន់ប៉្រាះ ប្រាំង ទឹង ស្រុក អ៊ីស្រាអ៊ែល នែ។ ");
INSERT INTO brb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«យូដា អើយ អំម៉ោះ អោះ ហៃ មន់ព្រតឹះ ព្រនែ មន់ដក់ កដាប ហំបះ ហៃ យ៉ាក់ ហំប៊ែ ពឺង ដ្រម៉ា រ៉ះ ហៃ ");
INSERT INTO brb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","យូដា កួន អើយ អំព្រឌីវ ហៃ ឞាល់ គ្លឺ ហំប៊្រុយ ប៊ិញ ចឡាង ឡើ ជឹ តើម ប៊ឹង កាប់ ចា ពត្រូវ អំព្រឌីវ ហៃ ឞាល់ គ្លឺ ហំប៊្រុយ សារ ឡើ បួន ហង់ង៉ាន់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ហាន ដក់ ពរ៉ៃ ហៃ ");
INSERT INTO brb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","កួន ចូវ ហៃ យូដា អើយ មន់បើម សឋិច អន់សច កួន ចូវ ហៃ មន់ពែក ប៉ាក់ តៗ ដឌែ ឆា ដើ សឋិច ដាវ ម៉ាត់ ម៉ាត លំប៊ឹះ ពែក ប៉ាក់ ដើម លែក ដើ សុនសាត មន់ចង់ហៀង ម៉ាង ហៃ ");
INSERT INTO brb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ដណាំ ដណូយ ហៃ លំប៉្លៃ ទុត អើន អ៊ែ ហំប៊ឹក លៀ ហៃ ប៊ឹង តើម ឈឹង ជែម ដើម ហំប៊ឹក កួន លៀ ហៃ ប៊ឹង តើម ឈឹង ជែម ចាគ់ៗ ហំប៊ិច តវែ ឈឹង ជែម តូវ ហំប៉ូច អាវ ហៃ ហំប៊ិច ដាក ប៉្លៃ ឈឹង ជែម តូវ ហំប៉ូច អាវ ទិះ ហៃ ");
INSERT INTO brb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ហំប៊ិច តវែ ឈឹង ជែម ហន់ញែត ញឹះ ចះ ម៉ាត់ ហំប៊ិច ដាក តោះ ឝ៉ូ ហន់ញែត ញឹះ បក ពឹង។ ");
INSERT INTO brb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«សាប់យូឡូន អើយ ហៃ ហន់គូ បរ ពឹះ សមុត កំបុង ហៃ លំចាគ់ លំប៊ិច ឌូក ត្រទិះ មន់ចត ប្រឡា ប៊្រី ដាក សាប់យូឡូន លំឌឺះ ប៊ឹះ មួង ស៊ីដូន។ ");
INSERT INTO brb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«អ៊ីសាខារ អើយ អំព្រឌីវ ហៃ ឞាល់ សិះ លៀ បិញៗ អង់ងីង ឡើ បួន ហង់ង៉ាន់ ដឹប កប៉ូវ ម៉ើ ចវ៉ាក់ ប៊ឹង ណគ ។ ");
INSERT INTO brb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ឞន បនួន ហៃ ហន់តៃ លំចាគ់ ទុត ខាក់ ប៊្រី ដាក អ៊ែ លំចាគ់ រ៉គ់សំ អ៊ែ ហំប៊ូក កដាប អាំ កណង ដើ មែ មន់ចវ៉ាក់ រ៉ាះ មន់យួរ ហៃ ឞាល់ ក៝ត។ ");
INSERT INTO brb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«ដាន់ អើយ ហៃ ហំពែក ប៉ាក់ ប៉ាសាសុន ហៃ កឡឹ ប៉ាគ់ ឆ្រាំង មែ អ៊ីស្រាអ៊ែល មន់ពែក ប៉ាក់ បូវ មែ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ដាន់ អំព្រឌីវ ហៃ ប៉ាគ់ ប៊ិះ ឡើ គូ ប៊ឹង ទ្រូង ទិះ ហំបើម ប៉ាគ់ ប៊ិះ វ៉ាក ឡើ គូ បរ ទ្រូង កិ ឡើ ចាំ កាប់ កដើវ ឈឹង សិះ ឡើ បើម អាំ បនឹះ ម៉ើ ឈិះ មន់គ្លីះ កលឺង ហឹ ត្រិច»។ ");
INSERT INTO brb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ីស្រាអ៊ែល ឡើ អ៊ឺរ ដាំង គ្រែដៃ រៀន៖ «ឡា គ្រែដៃ ហណាគ់ អន់សច អើយ អមឹង ហៃ ហន់ហវ៉ាត់ អៃ!»។ ");
INSERT INTO brb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","អ៊ែ ឡើ ប្រាយ ឡឹះ កួន ណគ រៀន៖ «ឝ៉ាត អើយ មែ ខម៉ូយ មន់ដក់ បឹត ប៊ឹម ហៃ ហាក់ ហៃ ហន់ឆ្រួយ បឹត តូវ បូវ មែ អ៊ែ តៃ ត្រិច។ ");
INSERT INTO brb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«អាស៊ែរ អើយ ប្រិះ ហៃ លំកើត ដណាំ ដណូយ ទុត ចាគ់ កយ៉ិ ហៃ លំញឹម ឞាល់ កយ៉ិ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«នែបថាលី អើយ អំព្រឌីវ ហៃ ប៉ាគ់ ឈូយ យូ ឡើ អន់ឆូវ ដក់ តាម ម៉ើត ដើម ឡើ ពឝ៉ើត កួន ត្រចាគ់ៗ។ ");
INSERT INTO brb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«អ៊ែ ណគ់ ដើ ហៃ យ៉ូស៊ែប អើយ ហំបើម ប៉ាគ់ ឆមឺ ឡើ ចន់ដះ ឡើ ប៉្លៃ ទុត អើន ឡើ ហួន ចាគ់ៗ បរ ពឹះ ដាក កៀង ណគ ឡើ ឌឹក វ៉ារ ឈ្រូង ជឺរ ដ្រក វៀង។ ");
INSERT INTO brb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","មែ ដ្រម៉ា មន់ដាំង ខ ទុត ខាក់ ដើ ហៃ មន់ប៉ិញ ហៃ ដើ ស្រាវ ដើ ចនិះ អរាំង មាំ ");
INSERT INTO brb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ណគ់ ដើ ហៃ ស្រាវ ហៃ លំទឹង ទី ហៃ លំឝ៉ៃ យ៉ាក់ គ្រែដៃ ឡើ ឆង៉ាត់ លំអាំ គ្រែដៃ ហង់អ៊ែ ឡើយ ឡើ កន់ដ្រាគ់ អៃ ឡើ កឡា រន់ឋាប់ ឝ្លាំង ដើម ឡើ លវាំង ង៉ាយ អ៊ីស្រាអ៊ែល ");
INSERT INTO brb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","គ្រែដៃ ឡើ កន់ដ្រាគ់ អៃ លំប៉ូរ ហៃ គ្រែដៃ ឡើ ឆង៉ាត់ ទុត ខាក់ លំប្រាយ អន់ណាំ ដើ ហៃ ហំប៊ិច ដាក អំមឺ តើម ទិ គ្រែ ដើម ដាក លំញឺះ តើម ចុ ត្រម ប្រិះ លំអាំ ហំប៊ិច កួន ចូវ ទុត អើន ដើម បណាន់ ហំប៉ង ហៃ មន់ស៊ឺក តាក ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","កាន អៃ អប្រាយ នែ ឡើ ទិះ ជឺរ ពន់ដ្រាយ ម៉ិ យ៉ាគ់ អៃ ពន់ឋើម ដើម ឡើ ទិះ ឈ្រូង ជឺរ បូយ ចន់ឌូ ណគ់ ឡើ ប៉ោះ ចាយ លែក ដើ ពន់ដ្រាយ នែ អឡា ហឹ គ្រែដៃ អាំ លំគ្លីះ ហឹ ហៃ យ៉ូស៊ែប អើយ ហៃ ឡើយ ហំពែក ប៉ាក់ អំម៉ោះ អោះ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«ប៊ែនយ៉ាមីន អើយ ហអរាំង មាំ អំព្រឌីវ ហៃ ប៊ឹង ច ប៊្រី ប៊ឹង ងឹប ឡើ កាប់ សាក ចា ពត្រូវ តគ់ អំប៊ឹ ឡើ ឝ៉ង់ ព្រណាក ដើ បូវ ប៊ែង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","លែក មែ ជិត បារ រ៉ា នែ ឡើយ ម៉ើ តង់កង់ ឆ្រាំង មែ សុនសាត អ៊ីស្រាអ៊ែល។ បើគ មែ យ៉ាគ់ យ៉ាកុប ឡើ ពហាយ ប៉ាគ់ អ៊ែ ឡើយ ប៊ឹង ឡើ ប្រាយ មែ អ៊ែ លែក ដើ មែ ម៉ើ ដូវ កាន អន់ណាំ តាម ប៉ាគ់ ឡើ ឃឺ ទឹង ចាក់ មែ កឡឹៗ។ ");
INSERT INTO brb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប ឡើ ថាន់ មែ កួន កឡ ណគ រៀន៖ «មែ កួន អើយ អៃ អ៊ិន ដៀប អន់តាក់ វែ ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ អៃ ឡើយ។ អ៊ែ វន់ដក់ ជុ តមួត ប៊ឹង ម៉ិ យ៉ាគ់ អៃ ហឹ ត្រម ច្រាង ទឹង មឺរ យ៉ាគ់ អ៊ែប្រូន ឡើ សុនសាត ហ៊ែត អ៊ែ យ៉ឹ។ ");
INSERT INTO brb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ទឹង មឺរ ម៉ាគ់ពែឡា តៃ ម៉ាត់ តង៉ៃ ឌឹក មួង ម៉ាមរែ ទឹង ស្រុក កាណាន មឺរ យ៉ាគ់ អាប្រាហាំ ឡើ រួត តើម ប៊ឹង យ៉ាគ់ អ៊ែប្រូន ឡើ សុនសាត ហ៊ែត ឡើ ជុ បើម ឞន ចនុ កយ៉ក់ ។ ");
INSERT INTO brb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ទឹង អ៊ែ ឡើយ ម៉ើ ជុ កយ៉ក់ យ៉ាគ់ អ អៃ អាប្រាហាំ អំប្រា ទ្រី ណគ យ៉ាគ់ សារ៉ា កយ៉ក់ បើគ អៃ អ៊ីសាគ់ ដើម កយ៉ក់ មែគ អៃ រែប៊ែកា អ៊ែ ដើ អៃ អជុ កយ៉ក់ ទ្រី អៃ លែអា ប៊ឹង ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","មឺរ ដើម ត្រម ច្រាង ទឹង អ៊ែ យ៉ាគ់ អាប្រាហាំ ឡើ រួត តើម ប៊ឹង មែ សុនសាត ហ៊ែត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","យ៉ាគ់ យ៉ាកុប ឡើ ថាន់ មែ កួន ណគ លែវ ឡើយ អ៊ែ ឡើ ប៊្រឹក ឈឹង កី ប៊ឹង ឝ្រែ ទឺ ប៊្លី អ៊ែ ឡើ តាត់ សើម ជឹ គូ ហឹ កយ៉ក់ ម៉ិ យ៉ាគ់ ណគ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","យ៉ាគ់ យ៉ូស៊ែប ឡើ ញឺម អម មុក មុញ កយ៉ក់ បើគ ណគ ដាក ម៉ាត់ ណគ ឡើ លូះ ទិ មុះ ម៉ាត់ បើគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ប៊្លី អ៊ែ យ៉ូស៊ែប ឡើ ប៉្រៃ បូវ មែ ពែត ណគ កឡឹ មន់រន់ឋាប់ កយ៉ក់ បើគ ណគ ញ៉ង អាំ លំសុ  អ៊ែ ម៉ើ បើម ប្រយ តាម ពន់ដ្រៃ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","មែ ម៉ើ រន់ឋាប់ កយ៉ក់ ញឹះ ពួន ជិត តង៉ៃ តាម ខណើយ មែ ។ ប៉ឹះ ជិត តង៉ៃ ប៉ឹះ ជិត មាំង មែ អ៊ែស៊ីប ម៉ើ ឝ្រង៉ឹត ស្រូក តង៉ូក ឆ្រុក ដើ កយ៉ក់ យ៉ាគ់ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO brb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","តគ់ ប៊្លី ម៉ើ ឝ្រង៉ឹត ស្រូក ដើ កយ៉ក់ លែវ ឡើយ អ៊ែ យ៉ូស៊ែប ឡើ ហាយ ដើ បូវ មែ ទិះ ក្រាគ់ ម៉ើ បើម កាន ដើ សឋិច ឡើ រៀន៖ «ប៉ាគ់ វ៉ើ ញឹម ក្លើម ដើ អៃ ម៉ាត់ ម៉ាត អឡា ហឹ វែ វន់ចជែ ប៉ូរ អៃ ហឹ សឋិច។ ប៉ាគ់ នែ វន់ហាយ ");
INSERT INTO brb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“បើគ អៃ ដៀប ឡើ គែត ឡើយ ឡើ ប៉្រៃ អខណាត តប៉ឹន ចាក់ ដើ ណគ រៀន ប៉ាគ់ លំគែត អន់ឌឹក ជុ ណគ ទឹង ត្រម ច្រាង ណគ់ ណគ ឡើ រន់ឋាប់ ជុ ទឹង ស្រុក កាណាន ទិ ឡើយ។ ប៉ាគ់ ពអ៊ែ អៃ អឡា អន់ឌឹក ជុ កយ៉ក់ បើគ អៃ នែ ទឹង អ៊ែ ឡើយ លែវ អ៊ែ ណាគ់ អន់ជឹ វឹញ ហឹ ទឺ អន់ណាវ”»។ ");
INSERT INTO brb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","អ៊ែ ម៉ើ ដក់ ហាយ ដើ សឋិច ឡើ ត្រណើវ រៀន៖ «ហន់ឌឹក ជុ ទឹង អ៊ែ ឡើយ កយ៉ក់ បើគ ហៃ ប៉ាគ់ ហៃ ហខណាត ឡាប់ ដើ ណគ ពន់ឋើម»។ ");
INSERT INTO brb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","អ៊ែ យ៉ូស៊ែប ឡើ ឌឹក ជុ ប្រយ កយ៉ក់ បើគ ណគ។ លែក ដើ មែ ទិះ ក្រាគ់ ម៉ើ បើម កាន ដើ សឋិច មែ តង់កង់ ក្រាគ់ ម៉ើ រន់ឋាប់ ឝ្លាំង ទឹង ហន់ណាម សឋិច ដើម លែក ដើ មែ តង់កង់ ក្រាគ់ ទឹង ស្រុក អ៊ែស៊ីប ម៉ើ ឌឹក តូយ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","លែក ដើ មែ ទឹង ក្រាន យ៉ូស៊ែប ដើម មែ អំម៉ោះ អោះ ណគ ដើម លែក ដើ ក្រាន បើគ ណគ ម៉ើ ឌឹក ប៉ាគ់ទឺ ម៉ើ ជុ វ៉ិះ ឌិវ មែ អង់គ្លែត ដើម បណាន់ ប៉ាគ់ ឡើ បប៊ែ ចៀម ឝ៉ូ ហឹ ប៊្រី ដាក ឝ៉ូស៊ែន។ ");
INSERT INTO brb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ប៊ិច កង តហាន អន់នឺ ម៉ើ ឈិះ កៀន ណគ់ មែ អន់នឺ អន់ណាវ ម៉ើ ឈិះ សិះ បនឹះ ទុត អើន ទិប ហទីប ម៉ើ ឌឹក តូយ យ៉ូស៊ែប។ ");
INSERT INTO brb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ហំប៊្រុះ ម៉ើ ប៊ឹះ ហឹ បយឺង បឹត ចិះ ម៉ើ ជុ អាថាត ហឹ ពឹះ ដណៃ យ៉ូរដាន់ តៃ តគ់ អ៊ែ ម៉ើ ញឺម ក្រវ៉ើយ ក្រើយ អន់ដូង ទុត ខាក់។ យ៉ាគ់ យ៉ូស៊ែប ឡើ ឝ្រង៉ឹត ដើ បើគ ណគ ញឹះ ប៉ឹះ តង៉ៃ ប៉ឹះ មាំង។ ");
INSERT INTO brb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","មែ សុនសាត កាណាន ណគ់ មែ ម៉ើ គូ ទឹង ស្រុក ហង់អ៊ែ ម៉ើ តៃ ម៉ើ ឝ្រង៉ឹត ទុត ខាក់ ហឹ បយឺង បឹត ចិះ អាថាត ប៉ាគ់ អ៊ែ អ៊ែ ម៉ើ ម៉ាង ត្រឌីវ មែ រៀន៖ «តគ់ វន់ឝ្លាំង បូវ សុនសាត អ៊ែស៊ីប ម៉ើ ឝ្រង៉ឹត ញឺម ទុត ខាក់»។ ញ៉ន អ៊ែ ឡើយ ឡើ ត្រ ម៉ើ ជុ ឞន ប្លះ ដណៃ យ៉ូរដាន់ តៃ ម៉ាត់ តង៉ៃ លុច អ៊ែ រៀន “អ៊ែបិល មីតស្រាអ៊ីម”។ ");
INSERT INTO brb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","កួន កឡ យ៉ាគ់ អ៊ីស្រាអ៊ែល ម៉ើ បើម ត្រួយ តាម បើគ មែ ឡើ ហាយ ពន់ឋើម ");
INSERT INTO brb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ម៉ើ តៀត កយ៉ក់ បើគ មែ ទឹង ស្រុក កាណាន ម៉ើ ជុ ហឹ ត្រម ច្រាង ទឹង មឺរ ម៉ាគ់ពែឡា ណគ់ យ៉ាគ់ អាប្រាហាំ ឡើ រួត តើម ប៊ឹង យ៉ាគ់ អ៊ែប្រូន ឡើ សុនសាត ហ៊ែត។ ឡើ បើម ឞន ចនុ កយ៉ក់ ដៀក មួង ម៉ាមរែ។ ");
INSERT INTO brb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","យ៉ូស៊ែប ឡើ ជុ កយ៉ក់ បើគ ណគ លែវ ឡើយ អ៊ែ ឡើ ជឹ វឹញ ទិ ស្រុក អ៊ែស៊ីប ទឺ អរែង ដើ អំម៉ោះ អោះ ណគ ដើម លែក ដើ មែ ម៉ើ ឌឹក តូយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","តគ់ បើគ មែ ឡើ គែត ឡើយ មែ អ៊ូគ អា យ៉ាគ់ យ៉ូស៊ែប ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «យ៉ូស៊ែប នែ ប៉ាគ់ ណាគ់ លំមាំ ដើ ញ៉ា អាត លំតូវ តៃ ណោះ លែក ដើ កាន ង៉ើ បើម តៃ ចាគ់ ដើ ណគ ពន់ឋើម»។ ");
INSERT INTO brb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ប៉ាគ់ ពអ៊ែ ម៉ើ ប៉្រៃ បឹ មូយ រ៉ា ដក់ ហាយ ហឹ យ៉ាគ់ យ៉ូស៊ែប រៀន៖ «បើគ ញ៉ា ទឹង ហូច ឡើ តាត់ សើម ឡើ ថាន់ រៀន ");
INSERT INTO brb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ឡើ ប៉្រៃ អាំ ញ៉ា ញ៉ើ ហាយ ដើ ហៃ ប៉ាគ់ នែ “ឡា កួន អើយ ហន់តាក់ អ្រយូច តាក់ ឞាប ដើ មែ អ៊ូគ អា ហៃ ម៉ើ បើម តៃ ចាគ់ ដើ ហៃ ពន់ឋើម”។ ប៉ាគ់ ពអ៊ែ ណិះៗ នែ ញ៉ើ ឡា ហន់តាក់ ថូត ដើ ញ៉ា យ៉ាក់ ញ៉ើ ឞយ គ្រែដៃ ណគ់ ឡើ កន់ដ្រាគ់ បើគ ង៉ាយ»។ យ៉ាគ់ យ៉ូស៊ែប ហំប៊្រុះ ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ ញឺម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ប៊្លី អ៊ែ មែ អ៊ូគ អា ណគ ម៉ើ ដក់ ហឹ យ៉ូស៊ែប ម៉ើ កដាប ហំបះ ប៊ឹង ឈឹង ណគ ម៉ើ ឡា រៀន៖ «អោះ អើយ ញន់ក៝ត ហៃ ឡើយ ញ៉ា នែ»។ ");
INSERT INTO brb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","យ៉ូស៊ែប ឡើ ត្រណើវ រៀន៖ «ញ៉ង វ៉ើ ឌូង អ៊ឺម ត្រ អ៊ឺម អៃ នែ អន់ដូវ តាត់ស៊ិន វែ វ៉ិះ ឌិវ គ្រែដៃ លំដូវ! ");
INSERT INTO brb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","មែ អ៊ូគ អើយ វ៉ើ ងុញ បើម តៃ ចាគ់ ដើ អៃ ម៉ាត់ ម៉ាត ហាក់ កាន តៃ ចាគ់ នែ គ្រែដៃ ឡើ ពលិះ បើម កាន ចាគ់ អន់ណាវ បក់ ឡើ ហវ៉ាត់ ពញិវ បនឹះ ទុត អើន ប៉ាគ់ ង៉ើ តៃ ត្រំ តង៉ៃ នែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","យ៉ូស៊ែប ឡើ រៀន៖ «ណិះៗ នែ មែ អ៊ូគ អា អើយ ញ៉ង វ៉ើ ឌូង យ៉ាវ ដើ អៃ ណាគ់ អំរន់ឋាប់ ឝ្លាំង វែ ដើម កួន ចូវ វែ»។ ប៉ាគ់ នែ យ៉ូស៊ែប ឡើ ពញឹម ពន់សាំង មែ អ៊ូគ អា ដើ ប្រម៉ាង ឝ្លីមៗ។ ");
INSERT INTO brb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","យ៉ាគ់ យ៉ូស៊ែប ដើម ក្រាន មែ កួន ចូវ បើគ ណគ ណាគ់ ម៉ើ គូ ហឹ ស្រុក អ៊ែស៊ីប។ កំប្រាគ់ យ៉ូស៊ែប លែក ដើ អ៊ែ មូយ ក្លាំ ជិត កម៉។ ");
INSERT INTO brb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","យ៉ាគ់ យ៉ូស៊ែប នែ ណាគ់ ឡើ ដាន់ តៃ កួន ចូវ អ៊ែប៉្រាអ៊ីម ញឹះ ពែ ព្រឌឹក ដើម ឡើ ដាន់ ចូវ ចិច ណគ កួន ម៉ាកៀរ ចូវ យ៉ាគ់ ម៉ាណាស៊ែ។ មែ កួន ម៉ាកៀរ ចូវ ចិច ណគ យ៉ូស៊ែប ឡើ ជុ បើម ប៉ិន កួន ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","យ៉ាគ់ យ៉ូស៊ែប ឡើ ហាយ ដើ មែ អំម៉ោះ អោះ ណគ រៀន៖ «អៃ អ៊ិន ដៀប អង់គែត ឡើយ ហាក់ គ្រែដៃ ណាគ់ លំប៉ូរ តៀត វែ តើម ប៊ឹង ស្រុក ណគ់ អន់នែ ជឹ វឹញ គូ ហឹ ប្រិះ ប៊្រី ណគ់ ឡើ ខណាត តប៉ឹន ចាក់ ដើ យ៉ាគ់ អាប្រាហាំ យ៉ាគ់ អ៊ីសាគ់ ដើម ដើ បើគ ង៉ាយ យ៉ាកុប»។ ");
INSERT INTO brb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ូស៊ែប ឡើ ថាន់ កួន ចូវ យ៉ាគ់ អ៊ីស្រាអ៊ែល រៀន៖ «អឡា ហឹ វែ វន់ខណាត តប៉ឹន ចាក់ ដើ អៃ តគ់ គ្រែដៃ លំប៉ូរ វែ អ៊ែ វន់ជឹ តៀត កឌឺង អៃ តើម ប៊ឹង នែ ទឹង អ៊ែ ទឺ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","យ៉ាគ់ យ៉ូស៊ែប កំប្រាគ់ ណគ មូយ ក្លាំ ជិត កម៉ ឡើយ អ៊ែ ឡើ គែត។ តគ់ ឡើ គែត អ៊ែ ម៉ើ រន់ឋាប់ ណគ ញ៉ង អាំ លំសុ ម៉ើ ជុ ទឹង ឡូង ហឹ ស្រុក អ៊ែស៊ីប។ ");
INSERT INTO brb_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","ទឹង ប៉ាង ឡៃ មាំង តគ់ មែ ទិះ ក្រាគ់ ម៉ើ តាត់ កឍី លុង ម៉ើ ពែក ប៉ាក់ ប៊្រី ដាក មែ អ៊ីស្រាអ៊ែល ណាគ់ តៃ ឡើ ប៊ិច អំម៉ឹះ សឋិច ឡើ ប៊ិច កាន អឹត ហរុ ទឹង ប៊្រី ដាក នែ។ ទឹង អ៊ែ ឡើ ប៊ិច តង់កង់ មូយ រ៉ា ហឹ ស្រ៊ុក ប៊ែថ្លែហិម ស្រុក យូដា ឡើ ច្រា ទ្រី ដើម អំប្រា កួន កឡ ណគ វីះ ដក់ គូ ហឹ ប៊្រី ដាក ម៉ូអាប់។ ");
INSERT INTO brb_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","តង់កង់ នែ ម៉ាត់ ណគ យ៉ាគ់ អ៊ែលីម៉ាលែក ម៉ាត់ ទ្រី ណគ ណាអូមី ម៉ាត់ កួន អំប្រា ម៉ាឡូន មូយ អន់ណាវ គីលីយ៉ូន។ ក្រាន មែ នែ កួន ចូវ អ៊ែប៉្រាតា ម៉ើ គូ ហឹ ស្រ៊ុក ប៊ែថ្លែហិម ស្រុក យូដា ម៉ើ ដក់ ប៊ឹះ ប៊្រី ដាក ម៉ូអាប់ អ៊ែ ម៉ើ គូ ប្រយ ហឹ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ែលីម៉ាលែក ឡើ គែត អ៊ែ ទ្រី ណគ យ៉ាគ់ ណាអូមី ឡើ ប៊ិច យ៉ាវ ក្ល វ៉ិះ ឡើ ប៊ិច ឌិវ កួន ណគ បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","អ៊ែ អំប្រា កួន ណគ អំប្រា ចក់ ប្រយ ទ្រី សុនសាត ម៉ូអាប់ ទ្រី គីលីយ៉ូន ម៉ាត់ ណគ ណាង អូរប៉ា ទ្រី ម៉ាឡូន ម៉ាត់ ណគ ណាង រូត។ ម៉ើ គូ គូម ហឹ ប៊្រី ដាក ម៉ូអាប់ អ៊ែ ជិត កម៉ អ្យាង។ ");
INSERT INTO brb_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","ប៊្លី អ៊ែ ម៉ាឡូន ដើម គីលីយ៉ូន អំប្រា គែត ប៉ាគ់ទឺ ណាគ់ ឌិវ យ៉ាគ់ ណាអូមី មូយ រ៉ា ក្ល តៃ ប៊ិច កួន តៃ ប៊ិច។ ");
INSERT INTO brb_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","ហឹ ប៊្រី ដាក ម៉ូអាប់ យ៉ាគ់ ណាអូមី ឡើ ដុង មែ ម៉ើ ចជែ រៀន គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ស្រុ ស្រៀត ប៉ាសាសុន ណគ ឡើ អាំ ដាក អំមឺ ដើ មែ អ៊ែ ម៉ើ ប៊ិច ចិះ ភែ ផិ ប៊ិង។ អ៊ែ យ៉ាគ់ ណាអូមី ឡើ រន់ឋាប់ រន់ឋយ លំវីះ តើម ប៊ឹង ប៊្រី ដាក ម៉ូអាប់ ឡើ ជឹ ហឹ ស្រ៊ុក ប្រិះ ឡើ កឡឹ ដើម កម៉ាន់ ណគ លែក បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","យ៉ាគ់ ណាអូមី ឡើ វីះ តើម ប៊ឹង ប៊្រី ដាក មែ ឡើ ជឹ វឹញ ហឹ ស្រុក យូដា ប៊្រី ដាក ណគ កឡឹ ទឺ អន់ណាវ ដើម កម៉ាន់ ណគ លែក បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","អ៊ែ ទឹង ម៉ើ ដក់ តៃ ទ្រូង យ៉ាគ់ ណាអូមី ឡើ ហាយ ដើ អំប្រា កម៉ាន់ ណគ រៀន៖ «ម៉ាយ! សប្រា លន់ជឹ ដាំង ម៉ិ សប្រា កឡឹ ហំមិញ។ ប៉ាគ់ សប្រា ខើយ បើម អន់ចាគ់ ប៊ឹង កយ៉ក់ ក្ល សប្រា ពន់ឋើម ទឺ ដើម ដើ អៃ ដិ អ៊ែ អៃ អន់ឡា ទឹង យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច លំបើម ចាគ់ ដើ សប្រា ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","ឡា យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច លំប្រាយ អាំ ដើ សប្រា លំប៊ិច ក្ល ហន់ដើម ឡឹះ អន់ណាវ អ៊ែ សប្រា លន់គូ ហ្រនុក ហ្រវ៉ាក ទឹង ក្រាន សប្រា ដិ»។ ប៊្លី អ៊ែ យ៉ាគ់ ណាអូមី ឡើ មុក អ្រឡះ កម៉ាន់ ណគ លែក បារ រ៉ា អ៊ែ អំប្រា ញឺម ឆ្រហ៊ី ឆ្រហ៊ឹម ប្រយ ហឝ៉ៃ ម៉ិ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","អ៊ែ អំប្រា កម៉ាន់ ណគ ត្រណើវ រៀន៖ «អ៊ឺម យ៉ាគ់ អ៊ី! ញឺ ញន់តូយ ឆារ ប៉ាគ់ទឺ! ញន់គូ អរែង ដើ សុនសាត ឆារ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","អ៊ែ យ៉ាគ់ ណាអូមី ណាគ់ តៃ ឡើ អាំ ដឌែ ឡើ ប៉្រៃ រៀន៖ «ម៉ាយ សប្រា លន់ជឹ វឹញ យ៉ឹ! សប្រា ងុញ បើម ង៉ាយ តូយ អៃ? អៃ អើ ឡូច ឡង់ កួន ឡើយ តៃ ប៊ិច យ៉ាវ កួន អំប្រយ៉ង់ ប៊ឹង សប្រា។ ");
INSERT INTO brb_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","សប្រា លន់ជឹ វឹញ ហំមិញ អៃ អក្រាគ់ៗ ម៉ៃ ឡើយ ផវ យ៉ាវ អំប៊ិច ក្ល អន់ណាវ ប៉ាគ់ អំមឹង រៀន មាំង នែ អន់ដូវ ចក់ ក្ល អង់កី អរែង ប៊ឹង ណគ ប៉ាគ់ ណាគ់ ផវ អំប៊ិច កួន ម៉ាត់តូវ កឡៗ ");
INSERT INTO brb_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ណាគ់ សប្រា ឌី ឞិ សប្រា លន់ចាំ ឋា ដើ ប៊ឹះ ច្រហើវ? ណាគ់ សប្រា ឌី ឞិ សប្រា លន់គូ តៃ ប៊ិច ក្ល យ៉ាវ ប៉ាគ់ នែ? ញ៉ង ម៉ាយ! ញ៉ង សប្រា ដក់ តូយ យ៉ាវ អៃ! អៃ អធុក ញ៉ាក ជឺរ សប្រា ញ៉ន គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើយ ឡើ ពធុក ពញ៉ាក អៃ»។ ");
INSERT INTO brb_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","ប៊ឹង អ៊ែ កម៉ាន់ ណគ លែក បារ រ៉ា អំប្រា ញឺម ឡឹះ អន់ណាវ។ ណាង អូរប៉ា ឡើ មុក ហឝ៉ៃ ម៉ិ ណគ ឡើ ឡះ ជឹ អ៊ែ ណគ់ ណាង រូត នែ ណាគ់ ឡើ កប៉ង់ ដឌែ ហឝ៉ៃ ម៉ិ ណគ។ ");
INSERT INTO brb_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","អ៊ែ ណាអូមី ឡើ ម៉ាង ដើ កម៉ាន់ ណគ រៀន៖ «តៃ! ដើ អន់ចើវ ឆារ វ៉ើ ជឹ វឹញ ហឹ សុនសាត វ៉ា កឡឹ វ៉ើ ជឹ បើម ប្រះ យ៉ាង សាត វ៉ា កឡឹ ប៉ាគ់ អ៊ែ ម៉ាយ ឆន់ជឹ តូយ អន់ចើវ ឆារ ទឺ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","ណាង រូត ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ អើយ! ញ៉ង ឆើ ពង់ខំ អ៊ឺម អៃ អន់តាក់ ឆារ។ យ៉ះ ឆារ ឆន់ដក់ ហឹ ង៉ាយ អៃ អន់ដក់ ហឹ អិះ ទឺ ឆារ ឆន់គូ ប៊ឹង ង៉ាយ អៃ អង់គូ ប៊ឹង អិះ ទឺ។ សុនសាត ឆារ សុនសាត អៃ ទឺ គ្រែដៃ ឆារ គ្រែដៃ អៃ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","ឆារ ឆន់គែត ប៊ឹង ង៉ាយ អៃ អង់គែត ប៊ឹង ទឺ អ៊ែ មន់កុប អៃ ប៊ឹង អិះ ទឺ។ វ៉ិះ ឌិវ បន់គែត ឡើយ បន់អ្រឡះ ប្លះ បា ដូវ ប៉ាគ់ អវ៉ក អន់តប៉ឹន ចាក់ ឆិ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច លំពថូត អៃ កតាម!»។ ");
INSERT INTO brb_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","ឡើ តៃ កម៉ាន់ ណគ ឝ៉្លិញ ជឹ តូយ ណគ ម៉ៃ ហ៊ែត អ៊ែ ណាអូមី ឡើ គូ ខៀង។ ");
INSERT INTO brb_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","អ៊ែ អំប្រា កម៉ាន់ ណគ អំប្រា ដក់ ប៊ឹះ ស្រ៊ុក ប៊ែថ្លែហិម។ ហំប៊្រុះ អំប្រា ប៊ឹះ ស្រ៊ុក អ៊ែ លែក ដើ មែ ក្លាង ស្រ៊ុក ម៉ើ តៃ អំប្រា ព្រឺ អ្រលី អ្រលឺ ប្រយ ម៉ើ គូ អ៊ែ បូវ មែ កទ្រី ទឹង ស្រ៊ុក ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ម៉ិ អន់តគ់ ណាអូមី ឋូវ?»។ ");
INSERT INTO brb_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","ណាអូមី ឡើ ត្រណើវ រៀន៖ «ញ៉ង វ៉ើ ជុ យ៉ាវ អៃ ណាអូមី ឡឹះ វន់ជុ ម៉ារ៉ា អន់ណាវ យ៉ាក់ គ្រែដៃ ឡើ ឆង៉ាត់ ថាំង ទុត ខាក់ ឡើ បើម អាំ អៃ ធុក ញ៉ាក ប៉ាក ម៉ង ទុត ត្រពិត ម៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","អៃ អវីះ តើម ប៊ឹង នែ អប៊ិច ត្រំ ហំឞ្លិច ពញ៉ង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ អៃ អជឹ វឹញ ទី មិៗ។ ញ៉ង វ៉ើ ជុ យ៉ាវ អៃ ណាអូមី ឡឹះ យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហន់ដិច អៃ គ្រែដៃ ឡើ ឆង៉ាត់ ថាំង ទុត ខាក់ ឡើ ប្រាយ ប៉្រៃ អៃ អធុក ញ៉ាក»។ ");
INSERT INTO brb_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","ប៉ាគ់ នែ ឡើយ ណាអូមី ឡើ ជឹ វឹញ តើម ប៊ឹង ប៊្រី ដាក ម៉ូអាប់ ហឹ ស្រុក ណគ កឡឹ ដើម កម៉ាន់ ណគ ណាង រូត សុនសាត ម៉ូអាប់ ឡើ ជឹ តូយ ណគ។ អ៊ែ អំប្រា ប៊ឹះ ហឹ ស្រ៊ុក ប៊ែថ្លែហិម តគ់ ញ៉ាម កនៀវ ចិះ ច្រគ់។ ");
INSERT INTO brb_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","ណាអូមី ឡើ ប៊ិច ព្រឝ៉ើត មូយ រ៉ា តៃ កយ៉ក់ ក្ល ណគ យ៉ាគ់ អ៊ែលីម៉ាលែក ម៉ាត់ ណគ បូអូះ ឡើ បនឹះ ចាគ់ លឺសា ដើម ឡើ ប៊ិច បាក់ តៃ ឋាំ។ ");
INSERT INTO brb_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","តង៉ៃ ហង់អ៊ិន ណាង រូត សុនសាត ម៉ូអាប់ ឡើ ឡា ហឹ ហឝ៉ៃ ម៉ិ ណគ រៀន៖ «យ៉ាគ់ អ៊ី! អៃ អឡា អន់ដក់ ប៉ើះ ចិះ ហឹ ណា បូវ ប៊ែង យ៉ឹ! អាត លំប៊ិច មែ មន់ស្រុស្រៀត អៃ មន់អាំ អន់ដក់ ប៉ើះ ចិះ តូយ មែ»។ ណាអូមី ឡើ ត្រណើវ រៀន៖ «ឆន់ដក់ ឆិ ម៉ាយ!»។ ");
INSERT INTO brb_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","អ៊ែ ណាង រូត ឡើ ដក់ ប៉ើះ ចិះ ហឹ ណា មែ តៃ ត្រិច បូវ មែ ម៉ើ កៀវ ចិះ បអើយ ឡើ ត្រ ប៉ុះ ណា យ៉ាគ់ បូអូះ ព្រឝ៉ើត យ៉ាគ់ អ៊ែលីម៉ាលែក។ ");
INSERT INTO brb_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","ហំប៊្រុះ ដើ អ៊ែ យ៉ាគ់ បូអូះ ឡើ ប៊ឹះ តើម ប៊ឹង ស្រ៊ុក ប៊ែថ្លែហិម អ៊ែ ឡើ តង៉ា ឡា បូវ មែ ម៉ើ កៀវ ចិះ ឡើ ប្រាយ រៀន៖ «ឡា គ្រែដៃ ឡើ ណាគ់ អន់សច លន់គូ គូម ប៊ឹង វែ លែក រ៉ា»។ មែ ម៉ើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច លំប្រាយ កាន ចាគ់ ប៉ាគ់ទឺ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","យ៉ាគ់ បូអូះ ឡើ តង៉ា ណាយ មែ គូលី កៀវ ចិះ រៀន៖ «កួន ចូវ មែ ង៉ាយ អិះ ណាង អន់តគ់?»។ ");
INSERT INTO brb_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","ណាយ មែ គូលី ឡើ ត្រណើវ រៀន៖ «ណាង អន់តគ់ កទ្រី សុនសាត ម៉ូអាប់ ណគ់ ឡើ ជឹ តូយ យ៉ាគ់ ណាអូមី តើម ប៊ឹង ប៊្រី ដាក មែ ម៉ូអាប់។ ");
INSERT INTO brb_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","ណាង ឡើ ឡា ប៉ើះ អន់តង ចិះ ដឹប ចិះ កនៀវ មែ ណគ់ ឡើ រុះ តៃ ត្រិច មែ ម៉ើ កៀវ។ អ៊ែ ឡើ ប៉ើះ ចិះ តើម ប៊ឹង ងឹប ឋា ដើ ប៊ឹះ ណិះៗ វ៉ិះ ឡើ ព្រឹង ប៊ឹង ហំប៉ាង ឞិត ឞ៊ែត»។ ");
INSERT INTO brb_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","ប៊ឹង អ៊ែ យ៉ាគ់ បូអូះ ឡើ ចជែ ហឹ ណាង រូត រៀន៖ «អើយ ណាង ហន់ចង់ហៀង យ៉ឹ ម៉ាង អៃ ញ៉ង ហដក់ ប៉ើះ អ៊ឺម ចិះ ហឹ ណា មែ គែង ញ៉ង ហវីះ អ៊ឺម តើម ប៊ឹង ណា ណគ់ អន់នែ ហន់គូ អរែង ប៊ឹង កទ្រី គូលី អៃ នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","អ៊ែ ហន់អន់ឆយ ឝ្លាំង មែ គូលី មន់ដក់ កៀវ ហឹ ង៉ាយ ហៃ ហន់ដក់ តូយ មែ ទឺ។ អៃ អថាន់ ឡើយ មែ កឡ តៃ អាំ មន់ពន់តក មន់រួយ រីង ហៃ។ ប៉ាគ់ ហន់ហរៀង ដាក អ៊ែ ហន់ដក់ ញែត ដាក ទឹង វ៉ាន់ ណគ់ មែ គូលី អៃ ម៉ើ ឈិត ជុ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","ប៊ឹង អ៊ែ ណាង រូត ឡើ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ អ៊ែ ឡើ ត្រណើវ រៀន៖ «ពយ៉ិ យ៉ាគ់ អ ណាគ់ ហឌី ស្រុស្រៀត អៃ អើ បនឹះ សុនសាត អង់គែង ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","យ៉ាគ់ បូអូះ ឡើ ត្រណើវ រៀន៖ «អៃ អដុង ឡើយ តើម ប៊ឹង ក្ល ហៃ ឡើ គែត ហបើម ចាគ់ ត្រំ ហំឞ្លិច ដើ ហឝ៉ៃ ម៉ិ ហៃ សាន់ ហតាក់ ម៉ិ បើគ ស្រ៊ុក ប្រិះ ហៃ ហដក់ គូ ហឹ សុនសាត ញ៉ា ញឹះ តៃ ហហង់ឝ៉ាវ អំម៉ឹះ តើម ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","ឡា គ្រែដៃ ឡើ ណាគ់ អន់សច លន់តូវ តវឹញ តាម កាន ហៃ ហើ បើម ឡា គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ គ្រែដៃ សុនសាត អ៊ីស្រាអ៊ែល លំអន់ណាំ អន់ណូយ ដើ ហៃ អាំ ស៊ិវ សាគ់ ណាគ់ គ្លឺយ យ៉ាក់ ហៃ ហដក់ គូ ចំឞាំង គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","ណាង រូត ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ ហៃ ហប៊ិច ក្លើម ចាគ់ ហឝម៉ៃ ដើ អៃ ខាក់ៗ យ៉ះ អៃ អកិ ហឡាប ដាប ហឡង់ ជឺរ គូលី ហៃ កតាម ហៃ ណាគ់ ហម៉ាង ញឹម ហពញឹម ក្លើម អៃ ឡឹះ ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","ទឹង ម៉ើ ចង់ ចា យ៉ាគ់ បូអូះ ឡើ ច្រា ណាង រូត រៀន៖ «ដក់ ចង់ ចា អរែង ប៊ឹង ញ៉ា! ហន់ចក់ ណំពាំង ទុ ទឹង ដាក ចនែវ នែ»។ អ៊ែ ណាង រូត ឡើ ដ្រូម ដៀក មែ គូលី កៀវ ចិះ អ៊ែ យ៉ាគ់ បូអូះ ឡើ អាំ ម៉ក់ ដើ ណគ។ ណាង រូត ឡើ ចង់ ចា ផិ ណគ់ ណាគ់ ឡើ ស៊ិវ ឡើ ជុ។ ");
INSERT INTO brb_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","ប៊្លី អ៊ែ ណាង ឡើ ឌឹក តើម ប៊ឹង ដ្រូម ឡើ ដក់ ប៉ើះ ឡឹះ អន់ណាវ ចិះ។ ប៊ឹង អ៊ែ យ៉ាគ់ បូអូះ ឡើ ប៉្រៃ មែ គូលី ណគ រៀន៖ «វន់អាំ ដើ ណគ លំប៉ើះ ចិះ ប្លះ ចិះ កនៀវ វែ ដិ យ៉ឹ ញ៉ង វ៉ើ កំប៊ែត អ៊ឺម ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","អ៊ែ វន់កលីះ ហ្រកង់ ចិះ អន់នឺ តើម ប៊ឹង កនៀវ វែ អាំ ដើ ណគ លំប៉ើះ ដិ ញ៉ង វ៉ើ ម៉ាង អ៊ឺម ដើ ណគ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","អ៊ែ ណាង រូត ឡើ ប៉ើះ ចិះ ឋា ដើ ប៊ឹះ អំប៊ឹ ងូច ហ្រងូច លែវ អ៊ែ ឡើ បបឹត ចិះ ណគ ឡើ ដូវ មូយ កថាំង អ្យាង។ ");
INSERT INTO brb_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","អ៊ែ ឡើ ដូល ចិះ ជឹ វឹញ ហឹ ស្រ៊ុក។ ហឝ៉ៃ ម៉ិ ណគ ឡើ តៃ ប្រយ ចិះ កម៉ាន់ ណគ ឡើ ប៉ើះ អ៊ែ ណាង រូត ឡើ ពប៉ឹះ ច្រណូម ណគ ឡើ អាំ ដើ ហឝ៉ៃ ម៉ិ ណគ ចណា ណគ់ ឡើ ស៊ិវ តើម ប៊ឹង ណគ ឡើ ចង់ ចា អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","យ៉ាគ់ ណាអូមី ឡើ តង៉ា កម៉ាន់ ណគ រៀន៖ «តង៉ៃ នែ ហឹ ង៉ាយ ឆើ ប៉ើះ ចិះ? ហឹ ណា មែ ង៉ាយ? ឡា គ្រែដៃ ឡើ ណាគ់ អន់សច ហំប្រាយ កាន ចាគ់ ណគ់ ដើ បឹ ឡើ ស្រុស្រៀត កម៉ាន់ អៃ នែ»។ ណាង រូត ឡើ ពប៉ច ដើ ហឝ៉ៃ ម៉ិ ណគ៖ «តង៉ៃ នែ អៃ អដក់ ប៉ើះ ចិះ ហឹ ណា បឹ កឡ មូយ រ៉ា ម៉ាត់ ណគ បូអូះ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","យ៉ាគ់ ណាអូមី ឡើ តើវ ម៉ាង កម៉ាន់ ណគ៖ «ឡា គ្រែដៃ ឡើ ណាគ់ អន់សច ហំប្រាយ កាន ចាគ់ ដើ យ៉ាគ់ បូអូះ! យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ើត ម៉ាត់ ម៉ាត ញឹះ តៃ តាក់ ដើ បនឹះ ញិវ ដើម ដើ បនឹះ គែត»។ យ៉ាគ់ ណាអូមី ឡើ ម៉ាង ឡឹះ រៀន៖ «បឹ ហង់អ៊ែ ឡើ ត្រ ព្រឝ៉ើត បា ណគ ដូវ ទឺ ឡើយ លំលឺង បា តាម ខណើយ សុនសាត ង៉ាយ »។ ");
INSERT INTO brb_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","ណាង រូត សុនសាត ម៉ូអាប់ ឡើ ត្រណើវ រៀន៖ «ណគ ណាគ់ ឡើ ប៉្រៃ អៃ អង់គូ ប៉ើះ ចិះ តៃ ត្រិច មែ គូលី ណគ ឋា ដើ ប៊ឹះ ព្រលឹះ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","ណាអូមី ឡើ ហាយ ដើ កម៉ាន់ ណគ រៀន៖ «ម៉ាយ ឆន់ដក់ ប៉ើះ ចិះ អរែង ដើ មែ កទ្រី គូលី យ៉ាគ់ បូអូះ អន់ណាវ ចាគ់ ឡើយ ប៉ាគ់ ឆន់ដក់ ហឹ ណា មែ គែង អំប មន់រួយ រីង ឆារ»។ ");
INSERT INTO brb_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","អ៊ែ ណាង រូត ឡើ ដក់ ប៉ើះ ចិះ ហឹ ណា យ៉ាគ់ បូអូះ អរែង ដើ មែ កទ្រី គូលី ឋា ដើ ប៊ឹះ ព្រលឹះ។ ណាង រូត ណាគ់ ឡើ គូ ប៊ឹង ហឝ៉ៃ ម៉ិ ណគ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","តង៉ៃ មូយ ណាអូមី ឡើ ចជែ ហឹ ណាង រូត រៀន៖ «ម៉ាយ អៃ អន់ដាំង ហំប៊្រុក ដើ ឆារ អាំ ឆន់ប៊ិច ហន់ណាម ក្រាន អ៊ែ ឆន់ហ្រនុក។ ");
INSERT INTO brb_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","យ៉ាគ់ បូអូះ ណគ់ ឆារ ឆើ គូ ពពឹត បបើម អរែង ដើ មែ កទ្រី គូលី ណគ ហង់អ៊ែ ឡើ ត្រ ព្រឝ៉ើត យូ បា ប៉ាគ់ទឺ ។ ឆន់ចង់ហៀង យ៉ឹ! អំប៊ឹ នែ ណគ លំទឺះ អូម ចិះ ទិ បយឺង បឹត ចិះ។ ");
INSERT INTO brb_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","ម៉ាយ ឆន់ហូម ប៊្លឺ ឆន់បើម ចាក់ អាំ ចាគ់ៗ ឡំ ណាំហម ដើម ទ្រូប ហក អាំ ចាគ់ ទុត ខាក់ ប៊្លី អ៊ែ ឆន់ទឺះ ទិ បយឺង បឹត ចិះ ញ៉ង ឆើ ពដៃ អន់ដិះ ចាក់ ឆារ ដើ ណគ លំតៃ ឋា ដើ លែវ ណគ លំញែត ចង់ អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","ប៊ឹង ណគ លន់កី ឆន់អន់ឆយ កណី ណគ អាំ ហឡាក់ៗ ប៊្លី អ៊ែ ឆន់ដក់ ប៉ើក ញុៗ ណគ តៃ ឈឹង ឆន់កី ប៊ឹង អិះ ទឺ អ៊ែ ណគ កឡឹ លំហាយ ដើ ឆារ អង់ង៉ាយ លំត្រ ឆន់បើម»។ ");
INSERT INTO brb_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","ណាង រូត ឡើ ត្រណើវ រៀន៖ «អ៊ឺគ! អៃ អំបើម តាម ម៉ាង ឆារ ត្រំ ហំឞ្លិច អ៊ិន ដូវ»។ ");
INSERT INTO brb_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","អ៊ែ ណាង រូត ឡើ ទឺះ ទិ បយឺង បឹត ចិះ អ៊ែ ឡើ បើម ត្រំ ហំឞ្លិច តាម ប្រម៉ាង ហឝ៉ៃ ម៉ិ ណគ ឡើ ព្រតូវ។ ");
INSERT INTO brb_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","យ៉ាគ់ បូអូះ ឡើ ចង់ ចា ផិ ប៊ិង រ៉គ់សំ លែវ ឡើយ អ៊ែ ឡើ ពឝ៉ី ចាក់ ហង់ង៉ាន់ តៀក ប្រយ ដៀក មែ ប៊ុច ចិះ។ អ៊ែ ណាង រូត ឡើ ដក់ ខយៗ ឡើ ប៊ឹះ តគ់ អ៊ែ ឡើ ប៉ើក ញុៗ តៃ ឈឹង ប្រណគ អ៊ែ ឡើ កី ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","តគ់ ទឹង មាំង យ៉ាគ់ បូអូះ ឡើ ហ្រលុង ងុញ អ៊ែ ឡើ រ៉ៃ ឡើ ឞ្លាក់ ឡើ តៃ ប្រយ កទ្រី មូយ រ៉ា ឡើ កី តៃ ឈឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","ឡើ តង៉ា រៀន៖ «មែ ង៉ាយ អន់នែ អិះ?»។ ណាង ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ អើយ អៃ ណាង រូត អឡា ចំឞាំង ហឹ ហៃ ហន់ចក់ អៃ ប៉ាគ់ អិះ ឡើយ យ៉ាក់ ហៃ ឡើ ត្រ ព្រឝ៉ើត យូ ក្ល អៃ ហៃ ឡើយ ឡើ ត្រ ហន់លឺង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","យ៉ាគ់ បូអូះ ឡើ ម៉ាង រៀន៖ «ឡា ណាង អើយ យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច លំប្រាយ កាន ចាគ់ ដើ ហៃ ញ៉ន ហពដៃ ចនិះ ចាគ់ ទឹង ត្រ ជឺរ ពន់ឋើម អន់ណាវ យ៉ាក់ តៃ ហឌី ដាំង ក្ល ច្រហើវ អ៊ឺម យ៉ះ មែ ម៉ើ ប៊ិច បាក់ លឺ មែ ម៉ើ ធុក ញ៉ាក កតាម ណាគ់ តៃ ហឌី ចក់ បើម ក្ល អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","ណិះៗ ណាង ញ៉ង ហឌូង អ៊ឺម អង់ង៉ាយៗ ណគ់ ហៃ ហឡា អៃ អំបើម លែក អិះ យ៉ាក់ មែ ក្លាង ស្រ៊ុក លែក រ៉ា ម៉ើ ណោះ ហឡាក់ រៀន ហៃ ហកទ្រី ចាគ់ ស៊ីត ប៊ីត។ ");
INSERT INTO brb_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","ឡើ ត្រ ឡើយ អៃ នែ អព្រឝ៉ើត យូ ហៃ អន់លឺង ហៃ ដូវ ពញ៉ង ណាគ់ ប៊ិច បឹ កឡ មូយ រ៉ា អន់ណាវ ព្រឝ៉ើត សប្រា ចើម ជឺរ អៃ។ ");
INSERT INTO brb_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","ណាង មាំង នែ ហៃ ហំហង់ង៉ាន់ ប៊ឹង ណិះ ឡើយ អន់ដៃ! ចាំ ងឹប ប្រណូវ អន់តង៉ា ណគ ប៉ាគ់ ណគ លំឌី លឺង សប្រា ចាគ់ ឡើយ អាំ ដើ ណគ ហឹ អិះ ឡើយ ប៉ាគ់ ណគ តៃ លំឌី អ៊ឺម អៃ អឡាប់ ខណាត តប៉ឹន ចាក់ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ណាគ់ អន់សច លំតៃ ហឡាក់ រៀន អៃ អន់ឡាប់ លឺង សប្រា ហឝ៉ៃ ម៉ិ ហៃ ម៉ាត់ ម៉ាត ប៉ាគ់ អ៊ែ មាំង នែ ហង់កី ប៊ឹង ណិះ ឡើយ ឋា ដើ ប្រាង»។ ");
INSERT INTO brb_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","ណាង រូត ឡើ កី តៃ ឈឹង យ៉ាគ់ បូអូះ ឋា ដើ ប្រាង អ៊ែ ឡើ រ៉ៃ តើម ភុង មាំង ត្រះ លឹម បលឹម តៃ ដាន់ តៃ អំម៉ឹះ ត្រឌីវ អំប្រា។ យ៉ាគ់ បូអូះ ឡើ រៀន៖ «ញ៉ង អាំ មែ ង៉ាយ មន់ណោះ ប៊ិច កទ្រី មូយ រ៉ា ឡើ មឹត ទឹង បយឺង បឹត ចិះ នែ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","ណគ ឡើ ម៉ាង ឡឹះ អន់ណាវ រៀន៖ «ណាង ហន់តោះ អាវ ទិះ ហៃ ហន់រ៉ាប់ អាំ ឝ៉្រឹត»។ អ៊ែ ណាង ឡើ រ៉ាប់ ឝ៉្រឹតៗ អ៊ែ យ៉ាគ់ បូអូះ ឡើ ហ៊ែង ចិះ មូយ កថាំង ហម ដើម ឡើ ប៊្រឹក ពដូល អាំ ដើ ប្រណគ។ ប៊្លី អ៊ែ យ៉ាគ់ បូអូះ ឡើ ជឹ ហឹ ស្រ៊ុក។ ");
INSERT INTO brb_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","ណាង រូត ឡើ ជឹ ហឹ ហឝ៉ៃ ម៉ិ ណគ។ តគ់ អ៊ែ ណាអូមី ឡើ តង៉ា រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើយ ដឹះ ម៉ាយ?»។ អ៊ែ ណាង រូត ឡើ ពប៉ច ដើ ហឝ៉ៃ ម៉ិ ណគ លែក កាន យ៉ាគ់ បូអូះ ឡើ ហាយ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ណាង ឡើ ពប៉ច ពឡាក់ រៀន៖ «ណគ ឡើ អាំ ចិះ ដើ អៃ មូយ កថាំង ហម ដើម ឡើ ម៉ាង រៀន “ឃឺ អឹ ហន់ជឹ វឹញ ទី មិៗ ហឹ ហឝ៉ៃ ម៉ិ ហៃ!”»។ ");
INSERT INTO brb_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","ណាអូមី ឡើ ម៉ាង រៀន៖ «ម៉ាយ ឆន់ចាំ ឝ្លាំង អន់ដៃ យ៉ឹ ឋា ដើ ប៊ឹះ កាន អន់នែ ឆន់ណោះ រៀន លន់កើត ប៉ាគ់ ង៉ាយ ប៊ិច អ៊ឺម ញឹះ យ៉ាគ់ បូអូះ លន់គូ មិៗ តង៉ៃ នែ អាត លំពឝ៉្លើច ឡើយ កាន នែ»។ ");
INSERT INTO brb_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","អ៊ែ យ៉ាគ់ បូអូះ ឡើ ឌឹក ដ្រូម តគ់ ឝឡោះ ដ្រក ស្រ៊ុក ទឹង នែ ឡើយ មែ ក្លាង ស៊្រុក ម៉ើ ខើយ តាត់ កឍី លុង ។ ហំប៊្រុះ ដើ អ៊ែ ឡើ ប៊ឹះ ប្រយ បឹ កឡ ព្រឝ៉ើត យ៉ាគ់ អ៊ែលីម៉ាលែក ចើម ជឺរ ណគ ណគ់ បឹ អន់នែ ឡើយ ឡើ ប៉ច អំប៉ច ដើ ណាង រូត មាំង អ៊ិន។ យ៉ាគ់ បូអូះ ឡើ ច្រា បឹ ហង់អ៊ែ រៀន៖ «អើយ អ៊ូគ! ហន់ដក់ ដ្រូម ប៊ឹង អៃ អន់ដៃ ដឹះ»។ បឹ ហង់អ៊ែ ឡើ ដក់ ដ្រូម ប្រយ ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","យ៉ាគ់ បូអូះ ឡើ ច្រា មែ តង់កង់ ក្រាគ់ ទឹង ស៊្រុក ជិត រ៉ា រៀន៖ «ឡា អុះ វន់ដក់ ដ្រូម ចង់ហៀង ញឺ នែ»។ អ៊ែ ម៉ើ ដក់ ដ្រូម ប្រយ ប៊ឹង អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","ប៊្លី អ៊ែ ឡើ ហាយ ប្រយ ដើ ព្រឝ៉ើត ណគ៖ «អ៊ូគ! ហណោះ ឡើយ ឡះ ម៉ី ណាអូមី ឡើ ជឹ វឹញ តើម ប៊ឹង ប៊្រី ដាក ម៉ូអាប់ ណគ ឡើ ងុញ ហំពួត ពដិះ ណា កយ៉ក់ អ៊ូគ អ៊ែលីម៉ាលែក អំម៉ោះ អោះ បា។ ");
INSERT INTO brb_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","អៃ អងុញ ហាយ ដើ ហៃ អាំ ហន់ដុង ប៉ាគ់ទឺ។ ណាគ់ ហឌី ឡះ ហន់លឺង ពដិះ ណា នែ ប៉ាគ់ ហឌី មែ តង់កង់ ក្រាគ់ ដើម មែ ក្លាង ស៊្រុក ម៉ើ ដ្រូម អរែង មន់ដុង ប៉ាគ់ទឺ។ អ៊ូគ ប៉ាគ់ ហៃ ហងុញ លឺង ហៃ ឆិ ហន់លឺង ប៉ាគ់ ហរៀន តៃ ហន់ឌី លឺង ហង់ហាយ ដើ អៃ ណិះៗ អ៊ែ អន់ណោះ យ៉ាក់ ទឹង អំម៉ោះ អោះ បា ហៃ ឡើយ ហប៊ិច ស៊ិត ហន់លឺង អន់នួរ អៃ»។ អ៊ែ អ៊ូគ ណគ ឡើ តើវ រៀន៖ «អៃ ឆិ អន់លឺង»។ ");
INSERT INTO brb_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","អ៊ែ យ៉ាគ់ បូអូះ ឡើ រៀន៖ «ប៉ាគ់ ពអ៊ែ តង៉ៃ ង៉ាយ ហៃ ហំរួត ពដិះ ណា កយ៉ក់ អ៊ូគ អ៊ែលីម៉ាលែក ប៊ឹង ម៉ី ណាអូមី នែ តង ហន់ចក់ ហ្រដូវ ណាង រូត ឡើ សុនសាត ម៉ូអាប់ នែ បើម ទ្រី ហំពឝ៉ើត កួន បក់ លំថរ ឆ្រាំង កយ៉ក់ អ៊ូគ អ៊ែ ណាគ់ លំណាគ់ មូន មាំង អំម៉ោះ អោះ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","អ៊ែ យ៉ាគ់ ហង់អ៊ែ ឡើ តើវ រៀន៖ «ប៉ាគ់ ពអ៊ិន ដូវ អ៊ឺម អៃ អន់លឺង យ៉ាក់ តៃ អឌី លំប៉ាត់ មូន ដើ កួន ចូវ អៃ ប៉ាគ់ ពអ៊ែ ហៃ ឆិ ហន់លឺង ដើ បា។ ដូវ អ៊ឺម អៃ អ៊ិន!»។ ");
INSERT INTO brb_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","ទឹង ឡៃៗ មែ អ៊ីស្រាអ៊ែល ប៊ឹង ម៉ើ លឺង មូន មាំង លឺ ម៉ើ វ៉ាក់ រ៉ាះ អំបាះ អង់ង៉ាយ មូយ បឹ មូយ រ៉ា ឡើ តោះ កើប អាំ ដើ ប្រណគ។ ម៉ើ ខើយ បើម ប៉ាគ់ នែ បក់ មែ បូវ មន់តៃ ហឡាក់ រៀន អំប្រា ផ្រណម ត្រឌីវ អំប្រា ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ យ៉ាគ់ ហង់អ៊ែ ឡើ តើវ យ៉ាគ់ បូអូះ រៀន៖ «ប៉ាគ់ អ៊ែ ហៃ ឆិ ហន់រួត ដើ បា»។ អ៊ែ ឡើ តោះ ប្រយ កើប ណគ (ឡើ អាំ ដើ យ៉ាគ់ បូអូះ )។ ");
INSERT INTO brb_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","អ៊ែ យ៉ាគ់ បូអូះ ឡើ ពហាយ ដើ មែ តង់កង់ ក្រាគ់ ដើម ដើ បូវ ប៊ែង ម៉ើ គូ ប៊ឹង មែ រៀន៖ «ឡា បូវ ប៊ែង! តង៉ៃ នែ វែ វ៉ើ កឡា តៃ ឡើយ អៃ អរួត មូន អ៊ែលីម៉ាលែក ដើម មូន គីលីយ៉ូន អំប្រា ម៉ាឡូន ត្រំ ហំឞ្លិច តើម ប៊ឹង ម៉ី ណាអូមី លែក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","តើម ប៊ឹង អ៊ែ ឡឹះ អំចក់ ណាង រូត សុនសាត ម៉ូអាប់ ទ្រី កយ៉ក់ ម៉ាឡូន នែ អៃ អន់ហ្រដូវ ចក់ បើម ទ្រី អ៊ែ ណគ់ មូន មាំង កយ៉ក់ អ៊ែលីម៉ាលែក ណាគ់ លំត្រ រ៉ាះ ណគ កឡឹ ដឌែ។ អ៊ែ អៃ អំពឝ៉ើត កួន ចូវ ដើ ណគ ញ៉ង អាំ លំប៉ាត់ ម៉ាត់ ណគ អ៊ឺម ទឹង ព្រឝ៉ើត យូ ង៉ាយ ដើម ទឹង ស្រ៊ុក ប្រិះ ង៉ាយ ដិ។ តង៉ៃ នែ វែ ត្រំ រ៉ា វ៉ើ ដុង ហឡាក់ ឡើយ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","អ៊ែ មែ តង់កង់ ក្រាគ់ ដើម មែ បូវ ប៊ែង ម៉ើ ចង់ហៀង ម៉ើ ត្រណើវ ហំប៊្រុះៗ លែក បូវ រៀន៖ «ញ៉ា ញ៉ើ ដុង ឡើយ។ ឡា គ្រែដៃ ឡើ ណាគ់ អន់សច លំប្រាយ អាំ កទ្រី លន់គូ ដើ ហៃ អ៊ែ អាំ ប៉ាគ់ យ៉ាគ់ រ៉ាជែល អំប្រា យ៉ាគ់ លែអា អំប្រា ពឝ៉ើត សុនសាត អ៊ីស្រាអ៊ែល ប៉ាគ់ ឡៃ ទឺ ! ឡា ដើវ អុះ ហន់អាំ យ៉ាគ់ បូអូះ លំប្រនិច ប្រណាក់ ត្រំ ហំឞ្លិច ទឹង ស្រ៊ុក អ៊ែប៉្រាតា អ៊ែ ដើម លំប៊ិច ម៉ាត់ លឺ អន់តើរ ទឹង ស្រ៊ុក ប៊ែថ្លែហិម។ ");
INSERT INTO brb_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","ឡា យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច លំអាំ កួន ចូវ ដើ សប្រា ទ្រី ហៃ បក់ លំបើម ប៉ាគ់ ក្រាន យ៉ាគ់ ពែរែះ កួន យ៉ាគ់ យូដា អំប្រា ណាង តាម៉ារ ពន់ឋើម ទឺ កួន ចូវ ណគ ម៉ើ ប៊ិច លឺ សា ទឹង ព្រឝ៉ើត យូ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","អ៊ែ យ៉ាគ់ បូអូះ ឡើ ចក់ ណាង រូត បើម ទ្រី អំប្រា កី គូ អរែង អ៊ែ យ៉ាគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ អាំ កួន ដើ អំប្រា ណាង រូត ឡើ តមែវ ប្រយ ឡើ អន់ឆិ កួន កឡ មូយ។ ");
INSERT INTO brb_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","មែ កទ្រី ទឹង ស្រ៊ុក ម៉ើ ដក់ ហាយ ហឹ យ៉ាគ់ ណាអូមី រៀន៖ «ង៉ាយ លែក រ៉ា ងំព្រតឹះ ព្រនែ គ្រែដៃ ឡើ ណាគ់ អន់សច យ៉ាក់ តង៉ៃ នែ ឡើ អាំ ចូវ កឡ មូយ ដើ ហៃ ណគ នែ ឡើយ លំរ៉ាក់សា ហៃ។ ចូវ ហៃ នែ បក់ លំលឺ កន់ចុង ដុង កន់ឋារ់ ប៊ិង ប៊្រី ដាក អ៊ីស្រាអ៊ែល នែ ហឹ តង៉ៃ អន់ទុន។ ");
INSERT INTO brb_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","ចូវ ហៃ នែ លំពញឹម ក្លើម ហៃ ឡឹះ អន់ណាវ ទឹង ណាគ់ ហញិវ តគ់ ហន់ក្រាគ់ៗ ណគ ឡើយ លន់ចៀម ហៃ ខៃ ណូវ។ កម៉ាន់ ហៃ ណគ់ អន់នែ ឡើ ខា ជឺរ កួន កឡ ប៉ឹះ រ៉ា អន់ណាវ ញ៉ន ឡើ ម៉ើត ហៃ អ៊ែ ឡើ ពឝ៉ើត កួន អាំ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","អ៊ែ ណាអូមី ឡើ ចក់ ក្រប៊ូ ចៀម បូញ អន់ណូញ ពែក ប្រយ ចូវ ណគ ឞាល់ កួន ណគ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","មែ ម៉ិ យូ ហន់ដះ ហន់ណាម ណគ ម៉ើ ជុ ម៉ាត់ កួន ណគ ម៉ើ រៀន៖ «ណាអូមី ឡើ ប៊ិច កួន កឡ មូយ! ម៉ាត់ កួន ណគ “អូប៊ែត”»។ អូប៊ែត នែ ឡើ ពឝ៉ើត អ៊ីសាយ អ៊ីសាយ ឡើ ពឝ៉ើត ដាវីត។ ");
INSERT INTO brb_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","អន់នែ ឡើយ កួន ចូវ យ៉ាគ់ ពែរែះ៖ យ៉ាគ់ ពែរែះ ឡើ ពឝ៉ើត យ៉ាគ់ ហ៊ែតស្រុន។ ");
INSERT INTO brb_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","យ៉ាគ់ ហ៊ែតស្រុន ឡើ ពឝ៉ើត យ៉ាគ់ រ៉ាម យ៉ាគ់ រ៉ាម ឡើ ពឝ៉ើត យ៉ាគ់ អាមីណាដាប់ ");
INSERT INTO brb_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","យ៉ាគ់ អាមីណាដាប់ ឡើ ពឝ៉ើត យ៉ាគ់ ណាសូន យ៉ាគ់ ណាសូន ឡើ ពឝ៉ើត យ៉ាគ់ សាល់ម៉ូន ");
INSERT INTO brb_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","យ៉ាគ់ សាល់ម៉ូន ឡើ ពឝ៉ើត យ៉ាគ់ បូអូះ យ៉ាគ់ បូអូះ ឡើ ពឝ៉ើត យ៉ាគ់ អូប៊ែត ");
INSERT INTO brb_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","យ៉ាគ់ អូប៊ែត ឡើ ពឝ៉ើត យ៉ាគ់ អ៊ីសាយ យ៉ាគ់ អ៊ីសាយ ឡើ ពឝ៉ើត សឋិច ដាវីត។ ");
INSERT INTO brb_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","ហ្រនុក ឡើយ ណគ់ មែ តៃ ម៉ើ ចង់ហៀង ប្រម៉ាង បនឹះ តៃ ចាគ់ ណគ់ មែ តៃ ម៉ើ ឆុង ពទិត ប៊ឹង បនឹះ ប៊ិច ឞាប ណគ់ មែ តៃ ម៉ើ ដ្រូម អរែង ប៊ឹង បនឹះ ឞឞួះ យយ៉ាល់។ ");
INSERT INTO brb_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","ណគ់ ខាក់ៗ មែ នែ ឡើយ ម៉ើ ហ្រនុក ណគ់ មែ ម៉ើ ម៉ើត ចង់ហៀង កាន គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ពង់ហៀន ដើម កាន ណគ ឡើ ប៉្រៃ ម៉ើ ឃឹត ទឹង ចនិះ តង៉ៃ ដើម មាំង។ ");
INSERT INTO brb_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","មែ អ៊ែ ម៉ើ បើម ប៉ាគ់ ឡង ឡើ ហួន ដៀប ដាក ឡើ ប៊ិច ពឺរ ឡើ ប៊ិច ប៉្លៃ តាម ញ៉ាម ហឡា ណគ ញឹះ តៃ ឡើ រ៉ូយ រ៉ាក មែ អ៊ែ ម៉ើ បើម អង់ង៉ាយៗ ដូវ លែក អិះ តូវ ឡើ ឌឹក សាគ់ៗ។ ");
INSERT INTO brb_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","អ៊ែ ណគ់ បនឹះ តៃ ចាគ់ អន់ណាវ ត្រ អ៊ឺម ប៉ាគ់ អ៊ែ ដើ មែ ម៉ើ បើម ប៉ាគ់ ដូច ឡើ តប៉ារ់ ដើ កយឺវ ប៉ាត់ ពណាត់ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","ញ៉ន ដើ អ៊ែ ឡើយ តគ់ គ្រែដៃ លំតាត់ ស៊ិន បនឹះ ប៊ិច ឞាប មន់ក្លើច អ៊ឺម មន់ត្រ ថូត មន់ដូវ អ៊ឺម គូ តមួត អរែង ប៊ឹង បនឹះ ចាគ់ ទឹង ត្រ។ ");
INSERT INTO brb_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","យ៉ាក់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ លវាំង ឝ្លាំង កាន គូ គូម បនឹះ ចាគ់ ទឹង ត្រ អ៊ែ ណគ់ មែ ម៉ើ ដក់ ទ្រូង តៃ ចាគ់ មន់ប៉ាត់ ពណាត់។ ");
INSERT INTO brb_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","ចន់ដ្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ អាំ ដើ កឡា ណាំផា ពន់តក ពន់ត្រ ដើ មែ ម៉ើ ច្រៀង។ ចន់ដ្រៀង នែ ពន់តក ប៊ឹង ឝីធីត ។ ចន់ដ្រៀង នែ សឋិច ដាវីត ឡើ កឡា ខៀន។ អូ គ្រែដៃ ហណាគ់ អន់សច អើយ ហកន់ដ្រាគ់ ញ៉ា ម៉ាត់ ហៃ ឡើ លឺសា ទិះ ទុត ខាក់ ប៊ិង ឡាង ប្រិះ ហៃ ហប៊ិច អាតណាត ទិះ ហពែក ប៉ាក់ ណាគ់ ពឺង ហូង គ្រែ ឡឹះ អន់ណាវ! ");
INSERT INTO brb_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","ប្រម៉ាង ព្រតឹះ ព្រនែ ឡើ ញឺះ តើម ប៊ឹង បួរ មែ អង់គ្លែត ដើម អង់អាង ណាគ់ ម៉ើ ពុ ហយួរ បើម ពន់ដ្រិញ ច្រនឹង ប៊ឹង មែ ម៉ើ ដ្រម៉ា ដើ ហៃ។ អ៊ែ ណគ់ មែ ម៉ើ ព្រឆាន់ ដើ ហៃ មន់ជុះ ក្រាប កដាប ប៊ូគ ហ្រហៀង។ ");
INSERT INTO brb_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","ប៊ឹង អង៉ើយ ហន់នៀប ឝ្លាំង ទឹង គ្រែ ណគ់ ហៃ ហពឝ៉ើត ប៉ាគ់ ឡើ ពតួរ កើត ណគ់ ហៃ ហជុ ទឹង ឡាង គ្រែ ");
INSERT INTO brb_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","អឃឹត រៀន បនឹះ នែ ម៉ើ ប៊ិច ថណាគ់ ឞាល់ ង៉ាយ ឋូវ អ៊ែ ហឃឹត ឃូ ដើ មែ ប៉ាគ់ ង៉ាយ ឋូវ បនឹះ នែ អ៊ែ ឡើ ត្រ ហឌី លវ៉ឹន ដើ មែ ញឹះ ឞាល់ នែ? ");
INSERT INTO brb_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","ហពឝ៉ើត មែ ម៉ើ កិ ក្រូម ឞាវ ហៃ វ៉ិះ កិៗ កគ់ៗ ហពឌឹក មែ ឞាល់ សឋិច ហអាំ មុះ ម៉ាត់ លឺសា ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","ហៃ ហអាំ មែ ម៉ើ ពែក ប៉ាក់ អង់ង៉ាយ ហៃ ហពឝ៉ើត ហជុ អង់ង៉ាយៗ លែក ដើ អ៊ែ ក្រូម ត្រប៉ាង ឈឹង មែ ");
INSERT INTO brb_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","ប៉ាគ់ ឡើ បប៊ែ ចៀម ឝ៉ូ ដើម លែក ដើ ពត្រូវ ប៊្រី ");
INSERT INTO brb_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ដើម ជែម ប៊្រែម ទឹង ឡាង គ្រែ ទ្រឺ ទិ កនុង ដាក សមុត ដើម លែក ដើ ពត្រូវ ណគ់ ម៉ើ គូ ទិ ដាក សមុត។ ");
INSERT INTO brb_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","អូ គ្រែដៃ ហណាគ់ អន់សច អើយ ហកន់ដ្រាគ់ ញ៉ា ម៉ាត់ ហៃ ឡើ លឺសា ទិះ ទុត ខាក់ ប៊ិង ឡាង ប្រិះ! ");
INSERT INTO brb_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","សឋិច ដាវីត ឡើ កឡា ខៀន ចន់ដ្រៀង នែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ កឡា បាន់ អៃ អ៊ែ ញឹះ តៃ អន់តឹត អង់ង៉ាយ អ៊ឺម ។ ");
INSERT INTO brb_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","ណគ ឡើ អាំ អៃ អប៊ូគ បួន ប្លះ បាត់ កយ៉ិៗ ហឹ ត្រិញ ឡើ តៀត អៃ ហឹ ដាក លូះ រន់ស៊ី។ ");
INSERT INTO brb_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","ណគ ឡើ បើម អាំ អៃ អសូវ ឡឹះ អន់ណាវ ណគ ឡើ តៀត អៃ ប៉ុះ ទ្រូង ត្រៗ ចាគ់ៗ តាម អាំ លំឃឺ ទឹង ម៉ាត់ យ៉ូក យ៉ាល់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","សំយ៉ះ អដក់ ឡាត់ ហួម ចន់ឌូ ឡើ ត្រ ឞន គែត កតាម ញឹះ តៃ អឌូង ដើ ខគ់ណាំ អង់ង៉ាយ អ៊ឺម យ៉ាក់ គ្រែដៃ ឡើ គូ ប៊ឹង អៃ ដើម ឡើ ឝ៉ឹន ឡង ក្រដូង ដឹប ឡង កណគ់ ណគ អ៊ែ ណាគ់ អដុៗ។ ");
INSERT INTO brb_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","គ្រែដៃ ឡើ ទែង កាន ញែត ចង់ ទុត ទិះ ដើ អៃ ប៊ឹង ងឺរ ដ្រម៉ា អៃ គ្រែដៃ ឡើ ឡច ណាំចាន់ គ្លឹម ពឺង ទូះ អៃ ដើម ចក អៃ ឡើ តំប៊ិង អន់សច។ ");
INSERT INTO brb_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","អណោះ ទុត ហឡាក់ រៀន ហៃ ហន់អាំ កាន ហ្រនុក ហ្រវ៉ាក ដើម ប្រម៉ើត អន់ញ៉ុ លំគូ ប៊ឹង អៃ ត្រំ តង៉ៃ ឋា ដើ គែត ដើម អង់គូ ទឹង កនូ គ្រែដៃ ឡើ ណាគ់ អន់សច ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","ចន់ដ្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ អាំ ដើ កឡា ណាំផា ពន់តក ពន់ត្រ ដើ មែ ម៉ើ ច្រៀង។ ចន់ដ្រៀង នែ ពន់តក ប៊ឹង មែ ម៉ើ រ៉ិះ ជីង រៀង។ ចន់ដ្រៀង នែ សឋិច ដាវីត ឡើ ខៀន ប៊ឹង មែ មួង ស៊ីប ម៉ើ ដក់ ហាយ ដើ សឋិច សូល រៀន ដាវីត ឡើ កដក ចាក់ ហឹ ញ៉ា តគ់ ឡើយ ។ ឡា គ្រែដៃ អើយ ហំប៉ូរ អៃ ដើ អាតណាត ម៉ាត់ ហៃ អាំ អំក្លើច តើម ប៊ឹង មែ ម៉ើ ដ្រម៉ា ដើ អៃ ឡា ហំបើម កាន អាំ ត្រៗ ដើ អៃ ដើ កាន ឆង៉ាត់ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","ឡា គ្រែដៃ អើយ ហន់ចង់ហៀង អ្រឡា អៃ ឡា ហំចង់ហៀង ឡាក់ៗ ហឹ ប្រម៉ាង អៃ អឡា ឡូម អុះ ");
INSERT INTO brb_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","យ៉ាក់ មែ គែង ម៉ើ ប្រអៀង ដើ អៃ បូវ មែ អរាំង មាំ ម៉ើ ដាំង កជែត អៃ។ ចនិះ បូវ មែ អ៊ែ ម៉ើ វឹនវ៉ាយ អ៊ឺម ហឹ ហៃ គ្រែដៃ អើយ។ ព្រឹង អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","ហាក់ គ្រែដៃ ណាគ់ ឡើ ប៉ូរ អៃ គ្រែដៃ កន់ដ្រាគ់ ណាគ់ ឡើ លវាំង អៃ។ ");
INSERT INTO brb_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","គ្រែដៃ លំតូវ កស៊ុត ហឹ មែ ម៉ើ ដ្រម៉ា ដើ អៃ។ ឡា អុះ ហំតប៉ាត់ មែ អាំ មន់ប៉ាត់ ពណាត់ តាម កាន ចាគ់ ទឹង ត្រ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","ណាគ់ អំបប៊ុះ ថួយ អាំ ដើ ហៃ លែក ដើ ចនិះ។ ឡា គ្រែដៃ ហណាគ់ អន់សច អើយ អៃ អំព្រតឹះ ព្រនែ ម៉ាត់ ហៃ យ៉ាក់ ចនិះ ហៃ ឡើ ចាគ់ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","ហៃ ណាគ់ ហប៉ូរ អៃ អាំ ក្លើច តើម ប៊ឹង កាន ញុក ញ៉ាក ត្រំ ហំឞ្លិច ដើម អតៃ មែ ម៉ើ ដ្រម៉ា ដើ អៃ ម៉ើ ជុះ ក្រាប កដាប ប៊ូគ។ ");
INSERT INTO brb_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","ចន់ដ្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ អាំ ដើ យ៉ាគ់ យែឌូធុន ឡើ កឡា ណាំផា ពន់តក ពន់ត្រ ដើ មែ ម៉ើ ច្រៀង។ ចន់ដ្រៀង នែ សឋិច ដាវីត ឡើ កឡា ខៀន។ វ៉ិះ ប៊ឹង គ្រែដៃ ឡើយ ណាគ់ អដុៗ ណគ ឡើ ហវ៉ាត់ អៃ។ ");
INSERT INTO brb_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","វ៉ិះ ឌិវ មូយ គ្រែដៃ ឡើយ ឡើ បើម ឞាល់ ដដារ ច្រាង ដើម ឡើ ហវ៉ាត់ អៃ។ ណគ ឡើ បើម ឞាល់ ដ្រក វៀង ទុត ឝ៉្រឹត តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់បើម អន់ដូវ អៃ។ ");
INSERT INTO brb_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","ដមិញ វន់ព្រឹង វ៉ើ ដាំង បឹត ប៊ឹម អៃ? លែក ដើ វែ ដមិញ វន់ព្រឹង ដាំង កជែត អៃ? វ៉ើ បើម ប៉ាគ់ នែ ឡើ បើម ប៉ាគ់ វ៉ើ ងុញ ឝឹ ដ្រក អំប៊ី ប៉ះ ឡើ អន់ឌែង ឡើ បើម ប៉ាគ់ វ៉ើ ងុញ រំប៊្លឹ ដ្រក ក្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","វែ វ៉ើ ងុញ កលីះ កឡឹះ អៃ អាំ អំប៉ាត់ លឺសា វែ វ៉ើ ម៉ើត ដើ កាន តបូត វ៉ើ ប្រាយ កាន ចាគ់ វ៉ិះ ឌិវ បួរ ទឹង ចនិះ វ៉ើ យ៉វ ក្លះ។ ព្រឹង អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","ឡា អៃ នែ អុះ វ៉ិះ ប៊ឹង គ្រែដៃ ណាគ់ អដុៗ តើម ប៊ឹង ណគ ឡើយ អប៊ិច កាន មឹង អ៊ីង។ ");
INSERT INTO brb_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","វ៉ិះ ឌិវ មូយ គ្រែដៃ ឡើយ ឡើ បើម ឞាល់ ដដារ ច្រាង ដើម ឡើ ហវ៉ាត់ អៃ។ ណគ ឡើ បើម ឞាល់ ដ្រក វៀង ទុត ឝ៉្រឹត តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់បើម អន់ដូវ អៃ។ ");
INSERT INTO brb_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","គ្រែដៃ ឡើ ហវ៉ាត់ អៃ ដើម ឡើ អាំ អប៊ិច មុះ ម៉ាត់ លឺសា គ្រែដៃ ឡើ បើម ឞាល់ ដដារ ច្រាង ទុត ឝ៉្រឹត អ៊ែ អចំឞាំង ណគ។ ");
INSERT INTO brb_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","ណគ់ វែ វ៉ើ គូ ប៊ឹង អៃ អើយ វន់មឹង គ្រែដៃ អន់សច ដឌែ ណគ់ កាន វែ វ៉ើ វ៉ឹនវ៉ាយ វន់ម៉ប ទឹង គ្រែដៃ ញ៉ះ ញំចំឞាំង គ្រែដៃ យ៉ឹ។ ព្រឹង អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","បនឹះ ទិ ឡាង ប្រិះ ម៉ើ បើម វ៉ិះ ប៉ាគ់ សណើម បនឹះ ទិ ឡាង ប្រិះ នែ ញឹះ តៃ ម៉ើ ខា អ៊ឺម លែក ដើ មែ ប៉ាគ់ មន់ឈិះ ប៊ឹង កឡូ មន់ហយ៉ូច ជឺរ ហដិះ សណើម ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","ញ៉ង វ៉ើ មឹង អ៊ឺម ដើ រ៉ាះ ដ្រូក សាក ញ៉ង វ៉ើ ហអ៊ឹន មឹង អ៊ឺម ដើ រ៉ាះ តទូង ម៉ូម៉ក់ កាន មឹង ហង់អ៊ែ ឡើ ខា អ៊ឺម ហម យ៉ះ វន់ប៊ិច បាក់ ចាំ អើន ញ៉ង វ៉ើ មឹង អ៊ឺម ដើ រ៉ាះ លែក អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","គ្រែដៃ ឡើ ហាយ ដឌែ ដើ អៃ អដុង ឡើ រៀន វ៉ិះ ឌិវ ណគ ឡើយ ឡើ ប៊ិច អាតណាត ឆង៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","គ្រែដៃ អើយ ហៃ ឡើយ ហម៉ើត អន់ញ៉ុ ញឹះ តៃ ហពលិះ លែក ដើ បនឹះ មូយ រ៉ាៗ ហអាំ តាម ប៉ាគ់ មែ ម៉ើ បើម។ ");
INSERT INTO brb_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","ចន់ដ្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ អាំ ដើ កឡា ណាំផា ពន់តក ពន់ត្រ ដើ មែ ម៉ើ ច្រៀង។ ចន់ដ្រៀង នែ ពន់តក ប៊ឹង ជីងរៀង។ ឡា គ្រែដៃ អើយ ហំស្រុស្រៀត បៀត ញ៉ា នែ ហំប្រាយ កាន ចាគ់ ដើ ញ៉ា ដិ អុះ ឡា គ្រែដៃ ហំហន់នៀប ឝ្លាំង ញ៉ា ដើ ចនិះ ចាគ់ ហៃ។ ព្រឹង អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","អាំ លែក ដើ មែ ទិ ឡាង ប្រិះ នែ មន់ហឝ៉ាវ ទ្រូង ហៃ អាំ លែក ដើ សុនសាត មន់ហឝ៉ាវ កាន ហៃ ហើ ហវ៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","ឡា គ្រែដៃ អើយ ហង់អាំ តូច ដើ សុនសាត មន់ព្រតឹះ ព្រនែ ហៃ ឡា ហង់អាំ បនឹះ លែក សាត មន់ព្រតឹះ ព្រនែ ហៃ ");
INSERT INTO brb_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","ឡា ហង់អាំ បនឹះ ត្រំ សាត មន់ច្រៀង រ៉គ់សំ ឆំតក ហូ ត្រោះ ក្រប៉ោះ រាំ យ៉ាក់ ហៃ ហពែក ប៉ាក់ ប៉ាសាសុន ត្រៗ ដើម ហកំព្រែង បនឹះ ទិ ឡាង ប្រិះ នែ។ ព្រឹង អន់ដៃ ");
INSERT INTO brb_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","ឡា គ្រែដៃ អើយ ហង់អាំ តូច ដើ សុនសាត មន់ព្រតឹះ ព្រនែ ហៃ ឡា ហង់អាំ បនឹះ លែក សាត មន់ព្រតឹះ ព្រនែ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","ប្រ៊ី អ៊ីន កើត ចិះ ប្រិះ អ៊ីន កើត ដណាំ ឡា គ្រែដៃ ហកន់ដ្រាគ់ ញ៉ា ហំប្រាយ កាន ចាគ់ ដើ ញ៉ា ! ");
INSERT INTO brb_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","ឡា ហំប្រាយ ម៉ាត់ ម៉ាត កាន ចាគ់ ដើ ញ៉ា ឡា ហង់អាំ លែក ដើ បនឹះ ឆា ដើ ប៊ឹះ ហឹ ព្រទុត ឡាង ប្រិះ មន់អៀល បឹះ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","អន់នែ ចន់ដ្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ សឋិច ដាវីត ឡើ ខៀន គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ហាយ ដើ កន់ដ្រាគ់ អៃ រៀន៖ «ហន់ដ្រូម តៃ ចម៉ា អៃ ទឹង ហូច អៃ អំពញ៉ម ពអន មែ ម៉ើ ដ្រម៉ា ដើ ហៃ អន់ជុ បើម ឝណើវ ឈឹង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","គ្រែដៃ ឡើ ណាគ់ អន់សច លំអាំ អាតណាត ដើ ហៃ ហំពែក ប៉ាក់ ណាប់ តើម ប៊ឹង មួង ស៊ីយ៉ូន ឋា ដើ បុ ឡាង ប្រិះ។ ឡើ រៀន៖ «ហំពែក ប៉ាក់ ពញ៉ម មែ ម៉ើ ដ្រម៉ា ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","តង៉ៃ ណគ លំតមួត តហាន ម៉ាត់តូវ បូវ ប្រិញៗ ណគ់ មែ ម៉ើ តូយ ណគ ម៉ាត់តូវ ឝ្រឡិញ មែ កឡឹ។ តើម ភុង មាំង មែ ច្រហើវ ទុត អើន ទីប ហទីប មន់ដក់ ហឹ ណគ ប្រវ៉ើន ហណក មែ ម៉ាត់តូវ បកៗ ចណុង ចណាគ់។ ");
INSERT INTO brb_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ខណាត តប៉ឹន ចាក់ ញឹះ តៃ លំពលិះ ចនិះ ឡើ រៀន៖ «ហៃ ហកឡា បប៊ុះ ថួយ ឡូច អន់សច តាម ប៉ាគ់ យ៉ាគ់ ម៉ិលគីស៊ែឌែក ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","គ្រែដៃ កន់ដ្រាគ់ ឡើ គូ តៃ ចម៉ា ហៃ។ តគ់ តង៉ៃ គ្រែដៃ លំមាំ លំចង់ឝ៉្លារ ពហិច ពហួច មែ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","គ្រែដៃ លំតាត់ស៊ិន ពថូត លែក ដើ សុនសាត ទឹង ប្រិះ ប៊្រី មែ លំប៊ិង ម៉ាត់តូវ កយ៉ក់ ត្រំ អំប៊ុ ត្រំ ឞន ដើម លំឆាន់ ចង់ឝ៉្លារ មែ កឡា ពែក ប៉ាក់ បុ ឡាង ប្រិះ នែ។ ");
INSERT INTO brb_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","តៃ ទ្រូង លំញែត ដាក ចណោះ អ៊ែ ឡើ ប៊ិច ពន់ដ្រិញ អន់ណាវ ។ ");
INSERT INTO brb_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","តង៉ៃ ហង់អ៊ិន យ៉ាគ់ យ៉ូណះ កួន យ៉ាគ់ អាមីថាយ ឡើ ដុង ប្រម៉ាង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","«ដ្រិះ ហន់ដក់ ហឹ មួង ទិះ នីនីវែ តគ់! ហំពហាយ ពន់ដូះ បនឹះ ទឹង មួង អ៊ែ ហន់រៀន អំពថូត មែ ញ៉ន កាន តៃ ចាគ់ មែ ឡើ លឺ ប៊ឹះ ទឹង អៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","ពញ៉ង យ៉ូណះ ឡើ វីះ ព្រដិច ចាក់ ហឹ មួង តាស៊ិះ អាំ ចង៉ាយ តើម ប៊ឹង គ្រែដៃ ឡើ ណាគ់ អន់សច។ ឡើ ទឺះ ទិ មួង យ៉ុពែ អ៊ែ ឡើ តៃ មែ ដៀប មន់ឈិះ ឌូក ទិះ មន់ដក់ ហឹ មួង តាស៊ិះ អ៊ែ ឡើ ជែរ ឌូក ឡើ ឡា ឈិះ ប៊ឹង មែ អ៊ែ ឡើ ទឺះ ឈិះ វីះ ហឹ មួង តាស៊ិះ ចង៉ាយ តើម ប៊ឹង គ្រែដៃ ឡើ ណាគ់ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ កយឺវ ទិះ ទុត ថាំង ឡើ ពឹក ដាក សមុត អ៊ែ សមុត តូវ ឡើ អន់ជឺច ឌូក ទិះ តូវ ឡើ ព្រឌឹង ប្រយ៉ុង ស្រឹ លំអឡាង ប៉្លះ។ ");
INSERT INTO brb_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","មែ គូលី ឌូក ម៉ើ ឌូង ម៉ើ ហរ៉ាវ កឡះ អ៊ឺរ ដាំង ប្រះ មែ កឡឹៗ ភូះ ចំភូះ រ៉ាះ អំបាះ ម៉ើ ព្រឌុក ម៉ើ កលីះ តាក់ ទិ ដាក សមុត អាំ លំហយ៉ូច ឌូក មែ។ អ៊ែ ដើ យ៉ាគ់ យ៉ូណះ ឡើ ទឺះ ហង់ង៉ាន់ តៀក ឡើយ ទិ កនុង ឌូក។ ");
INSERT INTO brb_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","ហំប៊្រុះ ដើ អ៊ែ ណាយ គូលី ឌូក ឡើ ទឺះ ទិ កនុង ឌូក ឡើ តៃ យ៉ាគ់ យ៉ូណះ ឡើ ហង់ង៉ាន់ ឡើ រៀន៖ «អើយ! ហហង់ង៉ាន់ ង៉ាយ ឞាល់ នែ? ហន់រ៉ៃ ហំមិញ ហន់ឌឹក អ៊ឺរ ដាំង ប្រះ ហៃ កឡឹ អំប ប្រះ ហៃ លំដុង លំស្រុស្រៀត ង៉ាយ អាំ ងន់ក្លើច តើម ប៊ឹង ឡង់ ឡូប នែ»។ ");
INSERT INTO brb_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","ប៊្លី អ៊ែ មែ គូលី ឌូក ម៉ើ ចជែ ត្រឌីវ មែ ម៉ើ រៀន៖ «ញ៉ះ ញំព្រលូក ឡាំង  អ៊ែ ងន់ណោះ មែ ង៉ាយ ម៉ើ ពរ៉ក់ ដើ ង៉ាយ ប៉ាគ់ នែ ឝ៉ាន់ ងន់គែត ប៉ាត់?»។ អ៊ែ ម៉ើ ព្រលូក ប្រយ ឡើ ត្រ ប៉ុះ យ៉ាគ់ យ៉ូណះ។ ");
INSERT INTO brb_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","បូវ មែ គូលី ឌូក ម៉ើ តង៉ា យ៉ាគ់ យ៉ូណះ រៀន៖ «ហង់ហាយ ដើ ញ៉ា មែ ង៉ាយ ឡើ បើម អាំ ង៉ាយ ធុក ញ៉ាក ឞាល់ នែ? ហបើម កាន អង់ង៉ាយ ត្រំ តង៉ៃ នែ? តើម ប៊ឹង ង៉ាយ ហប៊ឹះ? ហឹ ង៉ាយ ប៊្រី ដាក ហៃ? ហសុនសាត ង៉ាយ ហៃ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","យ៉ូណះ ឡើ ត្រណើវ មែ រៀន៖ «អៃ អើ សុនសាត ហ៊ែប្រើ អហំបះ អៀល គ្រែដៃ ឡើ ណាគ់ អន់សច គ្រែដៃ ឡើ គូ ទឹង ហូង គ្រែ ណគ ឡើ ពឝ៉ើត ដាក សមុត ដើម ឡាង ប្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","អ៊ែ យ៉ាគ់ យ៉ូណះ ឡើ ពប៉ច ដើ មែ រៀន ឡើ វីះ ព្រដិច ចាក់ អាំ ចង៉ាយ តើម ប៊ឹង គ្រែដៃ ឡើ ណាគ់ អន់សច។ មែ គូលី ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ ដៃ ប្រយ អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ ហបើម ប៉ាគ់ អ៊ិន ដឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","អ៊ែ សមុត នែ ចាំ ម៉ៃៗ ឡើ អន់ជឺច អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ «ប៉ាគ់ ង៉ាយ ដឹះ ញំបើម ដើ ហៃ អ៊ែ ដាក សមុត នែ លំព្រឹង អន់ជឺច?»។ ");
INSERT INTO brb_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","យ៉ាគ់ យ៉ូណះ ឡើ ហាយ ដើ មែ រៀន៖ «វន់រ៉ាប់ កលីះ អៃ ទិ ដាក ចុ អ៊ែ សមុត លំព្រឹង អន់ជឺច ដើ វែ អណោះ ឡើយ អៃ នែ អបើម អង់យូច អ៊ែ ឡើ កយឺវ ទិះ ដើ វែ ឞាល់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","ម៉ើ ឌី អ៊ឺម ម៉ើ កលីះ ណគ អ៊ែ ម៉ើ ចន់ដ្រា បូវ មែ ខំ វ៉ះ លែក ពន់ដ្រិញ ជឹ ដាំង ពឹះ ទឺ ណាគ់ តៃ ម៉ើ ប៊ឹះ អ៊ឺម ប៉ាគ់ទឺ យ៉ាក់ ដាក ឡើ អន់ជឺច ចាំ ម៉ៃៗ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","ប៊ឹង អ៊ែ ម៉ើ ឡា ឡូម ទឹង គ្រែដៃ ឡើ ណាគ់ អន់សច ម៉ើ រៀន៖ «ឡា គ្រែដៃ ហណាគ់ អន់សច អើយ ញ៉ង ហបើម អង់គែត អ៊ឺម ញ៉ា នែ ប៉ាគ់ ញន់កលីះ បឹ អន់នែ ទិ ដាក សមុត ចុ។ ឡា គ្រែដៃ ហណាគ់ អន់សច អើយ ញ៉ង ហំពថូត អ៊ឺម ញ៉ា ប៉ាគ់ ញន់កជែត បឹ អន់នែ ណោះ ឡើ បើម អង់យូច ណោះ អ៊ឺម! ញ៉ន ហៃ កឡឹ ឡើយ គ្រែដៃ ហណាគ់ អន់សច អើយ ហម៉ើត បើម ប៉ាគ់ នែ!»។ ");
INSERT INTO brb_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","ហំប៊្រុះ ដើ អ៊ែ ម៉ើ រ៉ាប់ កលីះ ប្រយ យ៉ាគ់ យ៉ូណះ ទិ ដាក ទឹង សមុត ឡើ អន់ជឺច ថាំងៗ អ៊ែ សមុត ឡើ ព្រឹង អន់ជឺច ហ្រហៀង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","អ៊ែ បូវ មែ លែក រ៉ា ម៉ើ ឌូង អៀល ប្រយ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ទុត ខាក់ អ៊ែ ម៉ើ ចន់ដ្រា ម៉ប ថួយ អាំ ដើ គ្រែដៃ ឡើ ណាគ់ អន់សច ដើម ម៉ើ ឡាប់ ខណាត ដើ ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ទ្រឺ ទិះ ដក់ លឹន យ៉ាគ់ យ៉ូណះ យ៉ាគ់ យ៉ូណះ ឡើ គូ ទឹង ពឌិវ ទ្រឺ ពែ តង៉ៃ ពែ មាំង។ ");
INSERT INTO brb_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","ទឹង ឡើ គូ ទឹង ពឌិវ ទ្រឺ យ៉ាគ់ យ៉ូណះ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ គ្រែដៃ ណគ។ ");
INSERT INTO brb_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","ណគ ឡើ រៀន៖ «អខគ់ណាំ ស្រឹ អង់គែត អៃ អកឡូវ អ៊ឺរ ដាំង ហៃ គ្រែដៃ ហណាគ់ អន់សច អើយ អ៊ែ ហៃ ហត្រណើវ ម៉ាត ម៉ាង អៃ។ ញឹះ ឞ៊ែត អង់គែត ឡើយ ពញ៉ង ណាគ់ អកឡូវ ដាំង ហៃ អាំ ហំប៉ូរ អៃ អ៊ែ ហដុង អ្រឡា អៃ។ ");
INSERT INTO brb_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","គ្រែដៃ ហកលីះ អៃ ទិ ដាក ឈ្រុៗ ប៊ឹះ ទិ ក្រលែង ដាក សមុត ដាក ឡើ ក្រប៉វ ឈុំ អៃ ហប៉្រៃ ដាក ឡើ អន់ជឺច ពឺង អៃ។ ");
INSERT INTO brb_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","អៃ អឃឹត រៀន ហៃ ហពន់ឌ្រុះ តវីះ អៃ អាំ ចង៉ាយ តើម ប៊ឹង ម៉ាត់ ហៃ ហាក់ អៃ ណាគ់ អមឹង អន់តៃ រ៉ូង ទិះ កដាប ហំបះ ហៃ ឡឹះ។ ");
INSERT INTO brb_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","ដាក សមុត ឡើ មឹត ទឹង មុះ អៃ ញឹះ ឡើ ហាត់ អសើម តៃ បក់ ដាក ឡើ បវ បឹន ចាក់ អៃ ដើម ព្រឺ ដិ វឹន ហវឺន ឡើ បវ ទូះ អៃ។ ");
INSERT INTO brb_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","ប៊ឹង អៃ អក្លាំ ប៊ឹះ ក្រលែង ឋារ ដាក អ៊ែ អៃ អឡាន់ អន់សច ទិ ឞន គែត ពញ៉ង ហៃ ហពឌឹក អៃ តើម ចុ អ៊ែ អ៊ែ ណាគ់ អញិវ ឡា គ្រែដៃ ហណាគ់ អន់សច អើយ ហៃ ឡើយ ហគ្រែដៃ អៃ។ ");
INSERT INTO brb_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","ប៊ឹង អៃ ស្រឹ អន់តាត់ សើម ឡើយ អ៊ែ អចនិះ ភៀក ទឹង ហៃ ហគ្រែដៃ ហណាគ់ អន់សច អើយ អ៊ែ ណគ់ ប្រម៉ាង អៃ អអ៊ឺរ ដាំង ឡើ ប៊ឹះ ទឹង ហៃ ទឹង ហូង ចាគ់ តៃ ឋាំ ហៃ ហគូ។ ");
INSERT INTO brb_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","ណគ់ មែ ម៉ើ ហវ៉ារ់ ម៉ើ តូយ ប្រះ ឆ្រឡិ ឆ្រលួគ ឡើ ឆង៉ាត់ អ៊ឺម ម៉ើ តាក់ កាន ស្រុស្រៀត ហៃ! ");
INSERT INTO brb_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អំបយ៉ុ ព្រតឹះ ព្រនែ គ្រែដៃ ហណាគ់ អន់សច អើយ អំចក់ បណាន់ អន់ដក់ ថួយ ដើ ហៃ ដិ។ អៃ អំបើម ត្រួយ ប្រម៉ាង អៃ អខណាត ដើ ហៃ វ៉ិះ ឌិវ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើយ ឡើ ដូវ ហវ៉ាត់ បនឹះ»។ ");
INSERT INTO brb_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","ប៊្លី អ៊ែ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ទ្រឺ ទិះ ដក់ កអគ់ យ៉ាគ់ យ៉ូណះ ហឹ ពឹះ សមុត។ អ៊ែ ទ្រឺ ទិះ ឡើ កអគ់ ប្រយ យ៉ូណះ តគ់ ពឹះ សមុត។ ");
INSERT INTO brb_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","យ៉ាគ់ យ៉ូណះ ឡើ ដុង ប្រម៉ាង គ្រែដៃ ឡើ ណាគ់ អន់សច មូយ តង ឡឹះ អន់ណាវ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","«ដ្រិះ ហន់ដក់ ហឹ មួង ទិះ នីនីវែ តគ់! អ៊ែ ហំពហាយ ដើ មែ ម៉ើ គូ ទឹង មួង អ៊ែ ណគ់ ប្រម៉ាង អៃ អប៉្រៃ ហៃ!»។ ");
INSERT INTO brb_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","តគ់ មូយ តង នែ យ៉ាគ់ យ៉ូណះ ឡើ ដក់ ហឹ មួង នីនីវែ តាម ប្រម៉ាង គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ណគ។ មួង នីនីវែ នែ ឌឺះ តៃ ឋាំ ប៉ាគ់ ម៉ើ ក្លង ឡាត់ ពែ តង៉ៃ អ៊ែ ម៉ើ ក្លើច។ ");
INSERT INTO brb_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","យ៉ាគ់ យ៉ូណះ ឡើ ដក់ ហាយ ពហាយ ទឹង មួង នែ ប៊ិង មូយ តង៉ៃ  ឡើ រៀន៖ «តើម ប៊ឹង នែ ណាគ់ ពួន ជិត តង៉ៃ អន់ណាវ គ្រែដៃ ឡើ ណាគ់ អន់សច លំថំឡាយ ឡើយ មួង វែ នែ!»។ ");
INSERT INTO brb_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","ប៊្លី អ៊ែ មែ ទឹង មួង នីនីវែ ម៉ើ ចាប់ ប្រយ ប្រម៉ាង គ្រែដៃ មែ លែក រ៉ា ម៉ើ ឈែវ ប្រម៉ាង មន់អឹត ចណង់ ចណា លែក ដើ បូវ ណាប់ តើម ប៊ឹង មែ ទិះ ក្រាគ់ ឋា ដើ ប៊ឹះ មែ ប៉ាសាសុន ធុក ញ៉ាក ម៉ើ វវ៉ើន ហហក ពស្រុ ចាក់ ម៉ើ ពដៃ បក់ មន់ហង់ឝ៉ាវ មែ ម៉ើ ពលិះ ចនិះ ។ ");
INSERT INTO brb_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","ទឹង សឋិច ហឹ មួង នីនីវែ ឡើ ដុង កាន នែ ឡើ ទឺះ ប្រយ តើម ប៊ឹង ទិង មៀង  ឡើ តោះ អាវ ទិះ សឋិច ឡើ ទ្រូប ហក ពស្រុ ចាក់ អន់ណាវ ដើម ឡើ ដ្រូម ប៊ឹង ទុះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","សឋិច ឡើ ប៉្រៃ អាំ មន់ដក់ ពហាយ ពន់ដុង ដើ មែ ប៉ាសាសុន ទឹង មួង នីនីវែ ពន់ដ្រៃ សឋិច នែ រៀន៖ «សឋិច ដើម មែ ទិះ ក្រាគ់ ម៉ើ ប៉្រៃ ប៉ាសាសុន លែក រ៉ា “ញ៉ះ ញន់អត់ ចណង់ ចណា ដើម តៃ ញន់ញញែត អង់ង៉ាយៗ អ៊ឺម ពត្រូវ បណាន់ ទិះ តមឹង កិ តមឹង តង មន់អឹត ចណង់ ចណា ប៉ាគ់ ដើ ង៉ាយ បនឹះ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","ញ៉ះ ញន់វវ៉ើន ហហក ពស្រុ ចាក់ ដើម ញន់តវ៉ារ់ បណាន់ ដើ ហំបាន ពស្រុ ចាក់ ប៉ាគ់ទឺ។ លែក ដើ ង៉ាយ ងំខំ ដាំង គ្រែដៃ អាំ លែក ចនិះ រំឞ៊ិះ ងន់សឡាគ់ តាក់ កាន តៃ ចាគ់ ដើម កាន អរាំង មាំ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","អំប គ្រែដៃ លំប៊្រឺះ ក្លើម លំឌី យ៉ាវ លំអរាំង មាំ ដើ ង៉ាយ អ៊ែ ញ៉ង ងន់គែត”»។ ");
INSERT INTO brb_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","គ្រែដៃ ឡើ តៃ មែ ម៉ើ សឡាគ់ តាក់ អ្រយូច មែ អ៊ែ គ្រែដៃ ឡើ ពលិះ ចនិះ ដើ មែ ឆា យ៉ាវ ឡើ ថំឡាយ មែ ប៉ាគ់ ណគ ឡើ ចាន ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","តគ់ ឡើ តៃ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៊្រឺះ ក្លើម យ៉ាគ់ យ៉ូណះ តៃ ឡើ ញឹម ក្លើម ឃីក ប្រយ ឡើ បើម មាំ។ ");
INSERT INTO brb_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","ណគ ឡើ អ៊ឺរ ដាំង ទឹង គ្រែដៃ ឡើ ណាគ់ អន់សច រៀន៖ «ឡា គ្រែដៃ ហណាគ់ អន់សច អើយ! ណិះៗ នែ កាន ឡើ ដាវ ប៉ាគ់ អៃ អហាយ ណាគ់ តើម ប៊ឹង អគូ ហឹ ប៊្រី ដាក អៃ កឡឹ ញ៉ន ប៉ាគ់ នែ ឡើយ អ៊ែ អវីះ ដក់ ព្រដិច ចាក់ ហឹ មួង តាស៊ិះ ដ្រិះៗ។ យ៉ាក់ អៃ អណោះ ហឡាក់ ឡើយ រៀន ហៃ ហគ្រែដៃ ហបើម អន់ចាគ់ ដើ បនឹះ ហៃ ហស្រុស្រៀត បៀត តៃ ហើ ហឹត មាំ អ៊ឺម ហៃ ហម៉ើត អន់ញ៉ុ ដើ បនឹះ ដើម ហៃ ហប៊្រឺះ ក្លើម តៃ ហឌី យ៉ាវ ពថូត បនឹះ។ ");
INSERT INTO brb_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","អូ គ្រែដៃ ហណាគ់ អន់សច អើយ! ប៉ាគ់ អ៊ែ ឡើយ អឡា ហន់ញ៉ាក់ ក្រម៉ាត ផវ យ៉ាង អៃ ណាគ់ ហយ អង់គែត ហំប្លះ អន់ញិវ»។ ");
INSERT INTO brb_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ដើ យ៉ូណះ រៀន៖ «ពយ៉ិ ហមាំ ប៉ាគ់ នែ ឃឺ ឡះ ហកឡឹ រៀន លឺ តៃ ឃឺ?»។ ");
INSERT INTO brb_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","អ៊ែ យ៉ូណះ ឡើ វីះ តើម ប៊ឹង មួង នីនីវែ ឡើ ដក់ គូ តៃ ម៉ាត់ តង៉ៃ ឌឹក ដៀក មួង។ តគ់ អ៊ែ ណគ ឡើ បើម ដរ៉ើង កិៗ មូយ អ៊ែ ឡើ គូ តៃ ក្រូម អុះ អូះ ឡើ ចាំ ឝ្លាំង គ្រែដៃ លំបើម ប៉ាគ់ ង៉ាយ ដើ មួង នីនីវែ។ ");
INSERT INTO brb_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","ប៊្លី អ៊ែ គ្រែដៃ ណគ់ គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ប៉្រៃ ឆមឺ ហួន ឌឹក វ៉ារ ទឹង ដរ៉ើង ពឺង ទូះ ណគ អាំ លំអូះៗ ដើ ណគ បក់ ញ៉ង យ៉ាគ់ យ៉ូណះ លំមាំ យ៉ាវ។ យ៉ាគ់ យ៉ូណះ ឡើ ញឹម ក្លើម ភឺង ប្រយ ដើ ឆមឺ ឡើ អុះ អូះ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","តគ់ ប្រណូវ តើម ភុង មាំង គ្រែដៃ ឡើ ប៉្រៃ ឌ្រីន មូយ អំប៉ម ដក់ អក់ តង ឆមឺ អ៊ែ ឆមឺ នែ ឡើ រ៉ូយ រ៉ាក លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","តគ់ ម៉ាត់ តង៉ៃ ឌឹក គ្រែដៃ ឡើ ប៉្រៃ កយឺវ ដុ ញឹះ ហ៊ីង ឡើ ពឹក តៃ ម៉ាត់ តង៉ៃ ឌឹក ដឹប ម៉ាត់ តង៉ៃ ឡើ ដុ ឡើ ចាល់ ទិ ទូះ យ៉ាគ់ យ៉ូណះ បើម អាំ ណគ សាវ បះ តូវ ឡើ ហ្រង៉ូម មុះ ម៉ាត់ ណគ ឡើ អ៊ឺរ ឡា គែត ឡើ រៀន៖ «ណាគ់ ហយ អង់គែត អុះ អៃ អ៊ិន ហំប្លះ អន់ញិវ»។ ");
INSERT INTO brb_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","អ៊ែ គ្រែដៃ ឡើ ម៉ាង ដើ យ៉ូណះ រៀន៖ «ហមាំ ញ៉ន ដើ ហអំមួញ ឆមឺ ឡើ រ៉ូយ រ៉ាក ប៉ាគ់ នែ ណាគ់ ឃឺ ឡះ ហតៃ លឺ តៃ ឃឺ?»។ ណគ ឡើ ត្រណើវ រៀន៖ «ដាវ ឡើយ គ្រែដៃ ហណាគ់ អន់សច អើយ! អៃ អំមាំ ឆា ដើ គែត»។ ");
INSERT INTO brb_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","គ្រែដៃ ឡើ ណាគ់ អន់សច ឡើ ម៉ាង ដើ ណគ រៀន៖ «ហង់ឃឹត ឝ្លាំង ឡាំង ហៃ ហអំមួញ ណគ់ ឆមឺ ញឹះ តៃ ប៉ាប ហដាំ តៃ ត្រ ហៃ អ៊ឺម ហពហួន ឡើ ហួន មាំង នែ អំប៊ឹ ប្រណូវ ឡើ គែត ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","ប៉ាគ់ អ៊ែ ដើ អៃ អន់ណាវ ហអាំ អ៊ឺម ឡះ អៃ អអំមួញ មួង នីនីវែ ឡើ មួង ទិះ ឞាល់ នែ ឡើ ប៊ិច បនឹះ ជិត បារ មឺន ហម ញឹះ តៃ ម៉ើ ណោះ ឍិង ឋាំង អ៊ឺម ដើម ម៉ើ ប៊ិច បណាន់ អើន ដិ ទឹង មួង ណគ់ អន់នែ»។");
INSERT INTO brb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","អន់នែ ព្រតយ ម៉ាត់ ម៉ិ យ៉ាគ់ គ្រែដៃ យែស៊ូ គ្រិះ ឡើ ត្រ កួន ចូវ សឋិច ដាវីត សឋិច ដាវីត នែ ឡើ ត្រ កួន ចូវ យ៉ាគ់ អាប្រាហាំ។ ");
INSERT INTO brb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","យ៉ាគ់ អាប្រាហាំ ឡើ ពឝ៉ើត អ៊ីសាគ់ យ៉ាគ់ អ៊ីសាគ់ ឡើ ពឝ៉ើត យ៉ាកុប យ៉ាគ់ យ៉ាកុប ឡើ ពឝ៉ើត យូដា ដើម អំម៉ោះ អោះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","យ៉ាគ់ យូដា ឡើ ពឝ៉ើត ពែរែះ ដើម ស៊ែរ៉ះ ប៊ឹង ណាង តាម៉ារ  យ៉ាគ់ ពែរែះ ឡើ ពឝ៉ើត ហ៊ែតស្រុន យ៉ាគ់ ហ៊ែតស្រុន ឡើ ពឝ៉ើត អារ៉ាម ");
INSERT INTO brb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","យ៉ាគ់ អារ៉ាម ឡើ ពឝ៉ើត អាមីណាដាប់ យ៉ាគ់ អាមីណាដាប់ ឡើ ពឝ៉ើត ណាសូន យ៉ាគ់ ណាសូន ឡើ ពឝ៉ើត សាល់ម៉ូន ");
INSERT INTO brb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","យ៉ាគ់ សាល់ម៉ូន ឡើ ពឝ៉ើត បូអូះ ប៊ឹង ណាង រ៉ាហាប់  យ៉ាគ់ បូអូះ ឡើ ពឝ៉ើត អូប៊ែត ប៊ឹង ណាង រូត  យ៉ាគ់ អូប៊ែត ឡើ ពឝ៉ើត អ៊ីសាយ ");
INSERT INTO brb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","យ៉ាគ់ អ៊ីសាយ ឡើ ពឝ៉ើត សឋិច ដាវីត។ សឋិច ដាវីត ឡើ ពឝ៉ើត សាឡូម៉ូន ប៊ឹង ទ្រី កយ៉ក់ យ៉ាគ់ អ៊ូរី ។ ");
INSERT INTO brb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","សឋិច សាឡូម៉ូន ឡើ ពឝ៉ើត រែហូបូម សឋិច រែហូបូម ឡើ ពឝ៉ើត អាប៊ីយ៉ា សឋិច អាប៊ីយ៉ា ឡើ ពឝ៉ើត អាសា ");
INSERT INTO brb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","សឋិច អាសា ឡើ ពឝ៉ើត យ៉ូសាផាត សឋិច យ៉ូសាផាត ឡើ ពឝ៉ើត យ៉ូរ៉ាម សឋិច យ៉ូរ៉ាម ឡើ ពឝ៉ើត អូសៀះ ");
INSERT INTO brb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","សឋិច អូសៀះ ឡើ ពឝ៉ើត យ៉ូថាម សឋិច យ៉ូថាម ឡើ ពឝ៉ើត អាហះ សឋិច អាហះ ឡើ ពឝ៉ើត ហ៊ែស៊ែកៀះ ");
INSERT INTO brb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","សឋិច ហ៊ែស៊ែកៀះ ឡើ ពឝ៉ើត ម៉ាណាស៊ែ សឋិច ម៉ាណាស៊ែ ឡើ ពឝ៉ើត អាម៉ូន សឋិច អាម៉ូន ឡើ ពឝ៉ើត យ៉ូសៀះ ");
INSERT INTO brb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","សឋិច យ៉ូសៀះ ឡើ ពឝ៉ើត យែកូនៀះ ដើម មែ អោះ ណគ។ ទឹង យ៉ាគ់ យែកូនៀះ ឡើ បើម សឋិច ម៉ើ រ៉ាប់ ជឹ តៀត សុនសាត អ៊ីស្រាអ៊ែល ហឹ ស្រុក បាប៊ីឡូន ។ ");
INSERT INTO brb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ប៊្លី ម៉ើ តៀត មែ ហឹ ស្រុក បាប៊ីឡូន សឋិច យែកូនៀះ ឡើ ពឝ៉ើត សាល់ធៀល យ៉ាគ់ សាល់ធៀល ឡើ ពឝ៉ើត សូរ៉ូបាប៊ែល ");
INSERT INTO brb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","យ៉ាគ់ សូរ៉ូបាប៊ែល ឡើ ពឝ៉ើត អាប៊ីយូត យ៉ាគ់ អាប៊ីយូត ឡើ ពឝ៉ើត អ៊ែលៀគីម យ៉ាគ់ អ៊ែលៀគីម ឡើ ពឝ៉ើត អាសូ ");
INSERT INTO brb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","យ៉ាគ់ អាសូ ឡើ ពឝ៉ើត សាដុក យ៉ាគ់ សាដុក ឡើ ពឝ៉ើត អើគីម យ៉ាគ់ អើគីម ឡើ ពឝ៉ើត អ៊ែលីយូត ");
INSERT INTO brb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","យ៉ាគ់ អ៊ែលីយូត ឡើ ពឝ៉ើត អ៊ែឡាសារ យ៉ាគ់ អ៊ែឡាសារ ឡើ ពឝ៉ើត ម៉ាថាន យ៉ាគ់ ម៉ាថាន ឡើ ពឝ៉ើត យ៉ាកុប ");
INSERT INTO brb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","យ៉ាគ់ យ៉ាកុប ឡើ ពឝ៉ើត យ៉ូស៊ែប ឡើ ត្រ ក្ល ណាង ម៉ារី។ ណាង ម៉ារី នែ ឡើយ ឡើ ពឝ៉ើត យែស៊ូ ម៉ើ ជុ រៀន គ្រែដៃ គ្រិះ។ ");
INSERT INTO brb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ប៉ាគ់ ពអ៊ែ តើម ប៊ឹង យ៉ាគ់ អាប្រាហាំ ប៊ឹះ សឋិច ដាវីត ឡើ ប៊ិច ជិត ពួន ប៉ាង តើម ប៊ឹង សឋិច ដាវីត ឋា ដើ ប៊ឹះ ម៉ើ រ៉ាប់ តៀត សុនសាត អ៊ីស្រាអ៊ែល ហឹ ស្រុក បាប៊ីឡូន ឡើ ប៊ិច ជិត ពួន ប៉ាង តើម ប៊ឹង ម៉ើ រ៉ាប់ តៀត មែ ហឹ ស្រុក បាប៊ីឡូន ប៊ឹះ គ្រែដៃ គ្រិះ ឡើ ប៊ិច ជិត ពួន ប៉ាង ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ប៉ាគ់ នែ ឡើយ កណើត គ្រែដៃ យែស៊ូ គ្រិះ។ មែគ ណគ ណាង ម៉ារី ហន់ដើម ម៉ើ អ្រឡា ប៊ឹង យ៉ូស៊ែប ញឹះ តៃ អំប្រា ក្រណី ក្រនូ អំម៉ឹះ ណាង ម៉ារី ឡើ តមែវ ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","យ៉ូស៊ែប កឡ ណាង ម៉ារី ហន់ដើម ម៉ើ អ្រឡា ឡើ បនឹះ ចាគ់ ទឹង ត្រ ឡើ អាំ អ៊ឺម ណាង ម៉ារី លំឆាំ ឆោះ ដើ បូវ អ៊ែ ឡើ ងុញ លំតាក់ ណាង ម៉ចៗ។ ");
INSERT INTO brb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ទឹង ប៉ះ ឡើ ចនិះ ដើ កាន អន់នែ អ៊ែ ឡើ ពកី តៃ ឞាវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ពដៃ ចាក់ ដើ ណគ ឡើ ហាយ រៀន៖ «យ៉ូស៊ែប កួន ចូវ សឋិច ដាវីត ញ៉ង ហឌូង ច្រៃ អ៊ឺម ហន់ចក់ ណាង ម៉ារី បើម ទ្រី យ៉ាក់ កួន ទឹង ពឌិវ ណាង ឡើ កើត ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ណាង លំអន់ឆិ កួន កឡ មូយ ហន់ជុ ម៉ាត់ ណគ “យែស៊ូ” យ៉ាក់ កួន នែ លំហវ៉ាត់ ប៉ាសាសុន ណគ តើម ប៊ឹង ឞាប»។ ");
INSERT INTO brb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","កាន លែក នែ ឡើ កើត អាំ លំដាវ ប៉ាគ់ គ្រែដៃ កន់ដ្រាគ់ ឡើ ហាយ តាម លញ៉ាគ់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«វន់ឝ្លាំង! ណាង ប្រោះ ឈ្រែង ឆ្រង ស៊ីត ប៊ីត លំតមែវ លំអន់ឆិ កួន កឡ មូយ មន់ជុ ម៉ាត់ ណគ រៀន “អ៊ែម៉ាញូអ៊ែល”»។ ម៉ាត់ នែ ឡើ ប៊ិច នឿណៃ រៀន «គ្រែដៃ ឡើ គូ ប៊ឹង ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","យ៉ូស៊ែប ប៊្លី ឡើ រ៉ៃ ឡើ បើម ត្រួយ តាម ឞាវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ប៉្រៃ ណគ អ៊ែ ឡើ ចក់ ពន់ឆា ណាង បើម ទ្រី។ ");
INSERT INTO brb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ហាក់ ឡើ កី គូ អ៊ឺម ប៊ឹង ណាង ឆា ដើ ប៊ឹះ ណាង ឡើ អន់ឆិ កួន កឡ អ៊ែ យ៉ូស៊ែប ឡើ ជុ ម៉ាត់ កួន អ៊ែ “យែស៊ូ”។ ");
INSERT INTO brb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","តគ់ គ្រែដៃ យែស៊ូ ឡើ កើត ហឹ ស្រ៊ុក ប៊ែថ្លែហិម ស្រុក យូដា ប៉ាង អ៊ែ យ៉ាគ់ ហ៊ែរ៉ូត ឡើ បើម សឋិច។ អ៊ែ ប៊ិច បូវ ម៉ើ ឆឆាង ឝ្លាំង ពតួរ ម៉ើ ប៊ឹះ មួង យែរូសាឡឹម តើម ប៊ឹង ស្រុក ចង៉ាយ តៃ ម៉ាត់ តង៉ៃ ឌឹក។ ");
INSERT INTO brb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ម៉ើ តង៉ា រៀន៖ «សឋិច សុនសាត យូដា ហន់ដើម ឡើ កើត ហឹ ង៉ាយ ឡើ គូ? តៃ ម៉ាត់ តង៉ៃ ឌឹក ញ៉ើ តៃ ពតួរ ឡើ ញឺះ អ៊ែ ញ៉ើ ណោះ សឋិច ហន់ដើម ឡើ កើត ញ៉ើ ដក់ កដាប ហំបះ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ហំប្រ៊ុះ សឋិច ហ៊ែរ៉ូត ឡើ ដុង ប៉ាគ់ អ៊ែ ស្រៀវ អ្រអវ ប្រយ ឡើ គូ ដើម លែក ដើ មែ ទឹង មួង យែរូសាឡឹម ស្រៀវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","អ៊ែ សឋិច ឡើ កឡូវ លែក ដើ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម លែក ដើ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ទឹង សុនសាត យូដា ម៉ើ ដក់ តមួត ហឹ ណគ ឡើ តង៉ា មែ រៀន៖ «ហឹ ង៉ាយ គ្រែដៃ គ្រិះ លំត្រ កើត?» ");
INSERT INTO brb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ម៉ើ ត្រណើវ ប្រម៉ាង សឋិច រៀន៖ «ណគ អ៊ិន ឡើ លំត្រ កើត ហឹ ស្រ៊ុក ប៊ែថ្លែហិម ស្រុក យូដា យ៉ាក់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ ពន់ឋើម ប្រម៉ាង អន់នែ រៀន ");
INSERT INTO brb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“អ៊ែ ណគ់ ហៃ ស៊្រុក ប៊ែថ្លែហិម ប៊្រី ដាក យូដា អើយ លំឃឺ អ៊ឺម មន់ជុ ហៃ ហស៊្រុក កិ តៃ ហ៊ែត ខា ក្រូម ស៊្រុក អង់គែង ទឹង ប៊្រី ដាក យូដា យ៉ាក់ លំប៊ិច កឡា ពង់ឝឹង មូយ រ៉ា លំកើត តើម ប៊ឹង ហៃ ណគ លំពែក ប៉ាក់ ប៉ាសាសុន អៃ សុនសាត អ៊ីស្រាអ៊ែល ”»។ ");
INSERT INTO brb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ប៊្លី អ៊ែ សឋិច ហ៊ែរ៉ូត ឡើ កឡូវ ម៉ចៗ បូវ ម៉ើ ណោះ ឆឆាង ឝ្លាំង ពតួរ បក់ លំតង៉ា ពឡាក់ មែ រៀន ដមិញ ម៉ើ តៃ ពតួរ ឡើ ញឺះ។ ");
INSERT INTO brb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","អ៊ែ សឋិច ឡើ ប៉្រៃ មែ ម៉ើ ដក់ ហឹ ស្រ៊ុក ប៊ែថ្លែហិម ឡើ ម៉ាង រៀន៖ «វន់ដក់ ហឹ អ៊ែ វន់តង៉ា ហឡាក់ៗ កាន អង់អាង អ៊ែ យ៉ឹ។ ប៊ឹង វន់តៃ ឡើយ វន់ជឹ ហាយ ដើ អៃ ដិ បក់ អន់ដក់ កដាប ហំបះ ណគ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","ប្ល៊ី ម៉ើ ចង់ហៀង ប្រម៉ាង សឋិច លែវ ឡើយ ម៉ើ វីះ ប្រយ។ អ៊ែ កអវ ម៉ើ តៃ ពតួរ ណគ់ ម៉ើ តៃ ទឹង ណាគ់ ម៉ើ គូ ហឹ ស្រុក មែ កឡឹ តៃ ម៉ាត់ តង៉ៃ ឌឹក អ៊ែ ម៉ើ ញឹម ក្លើម ក្លាក ទុត ខាក់ ប្រយ។ ពតួរ នែ ឡើ ដក់ អន់នួរ តៃ ងឺរ មែ ឋា ដើ ប៊ឹះ ហ្រទឹង កនូ អង់អាង អ៊ែ ឡើ ជឹង។ ");
INSERT INTO brb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ម៉ើ មឹត ហឹ ហន់ណាម ម៉ើ តៃ អង់អាង ប៊ឹង មែគ ណគ ណាង ម៉ារី អ៊ែ ម៉ើ ជឹះ ត្រកូវ កដាប ហំបះ ណគ។ ប្ល៊ី អ៊ែ ម៉ើ ប៉ើក ហ៊ីប មែ ម៉ើ ញ៉ាក់ រ៉ាះ អំបាះ ម៉ាត់តូវ ច្រណាប់ៗ ម៉ើ អាំ ដើ អង់អាង ប៊ិច ឆៀង ឆារ់ គ្លឹម ដើម ណាំហម។ ");
INSERT INTO brb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ប្ល៊ី អ៊ែ ម៉ើ ជឹ វឹញ ហឹ ស្រុក មែ កឡឹ ទឺ តៃ ទ្រូង អង់គែង យ៉ាក់ គ្រែដៃ ឡើ ហាយ ដើ មែ តាម លញ៉ាគ់ ពកី ញ៉ង អាំ មន់ជឹ វឹញ ហឹ សឋិច ហ៊ែរ៉ូត។ ");
INSERT INTO brb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ប៊្លី បូវ ឆឆាង ម៉ើ ជឹ ក្លើច ឡើយ ហំប៊្រុះ ដើ អ៊ែ ឞាវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ពដៃ ចាក់ ដើ យ៉ូស៊ែប តាម លញ៉ាគ់ ពកី ឡើ រៀន៖ «មិញ ហន់ឌឹក ហំតៀត អំប្រា ក្រមួន ម៉ិ វន់រ៉ូះ ដក់ គូ ហឹ ស្រុក អ៊ែស៊ីប តគ់។ ហន់គូ ហឹ អ៊ែ ញឹះ អំប៉្រៃ ហន់ជឹ យ៉ាក់ សឋិច ហ៊ែរ៉ូត លំដាំង កជែត អង់អាង នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","យ៉ាគ់ យ៉ូស៊ែប ឡើ រ៉ៃ ឡើ តៀត អំប្រា ក្រមួន ម៉ិ រ៉ូះ ហឹ ស្រុក អ៊ែស៊ីប មាំង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ម៉ើ គូ ហឹ អ៊ែ ឆា ដើ សឋិច ហ៊ែរ៉ូត ឡើ គែត អាំ លំដាវ ប៉ាគ់ គ្រែដៃ កន់ដ្រាគ់ ឡើ ហាយ តាម លញ៉ាគ់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ រៀន៖ «អកឡូវ កួន កឡ អៃ លំញឺះ តើម ប៊ឹង ស្រុក អ៊ែស៊ីប »។ ");
INSERT INTO brb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","តគ់ សឋិច ហ៊ែរ៉ូត ឡើ ណោះ បូវ មែ ឆឆាង ម៉ើ តបូត ណគ ឡើ មាំ ទុត ខាក់ អ៊ែ ឡើ ប៉្រៃ មែ តហាន ណគ មន់ដក់ កជែត អង់គ្លែត កឡៗ អាំ លែក តើម ប៊ឹង បារ កម៉ ឆា ដើ ប៊ឹះ មែ អង់គ្លែត ម៉ើ កើត ហន់ដើម ហឹ ស្រ៊ុក ប៊ែថ្លែហិម ដើម លែក ដើ ស្រ៊ុក ឈុំ អ៊ែ ណាប់ តើម ប៊ឹង តង៉ៃ បូវ ឆឆាង ម៉ើ ហាយ ដើ ណគ ម៉ើ តៃ ពតួរ ឡើ ញឺះ។ ");
INSERT INTO brb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","អន់នែ ឡើយ ប្រម៉ាង យ៉ាគ់ យែរែមៀ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ហាយ ពន់ឋើម ឡើ ដាវ ម៉ាត់ ម៉ាត ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«ម៉ើ ដុង ឆ្រញឺម មូយ រ៉ា ហឹ ស៊្រុក រ៉ាម៉ា ឡើ ញឺម ហ្រវ៉ើយ ក្រើយ អន់ដូង ទុត ខាក់ ណគ អ៊ែ ណាង រ៉ាជែល ឡើ ញឺម អង់ងឹះ មែ កួន ណគ ឡើ អាំ អ៊ឺម មែ ង៉ាយ មន់អូរ ពញឹម ក្លើម ណគ យ៉ាក់ កួន ណគ ម៉ើ គែត លែក តាក់ »។ ");
INSERT INTO brb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","តគ់ សឋិច ហ៊ែរ៉ូត ឡើ គែត ឡើយ ឞាវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ពដៃ ចាក់ អន់ណាវ ដើ យ៉ូស៊ែប ហឹ ស្រុក អ៊ែស៊ីប តាម លញ៉ាគ់ ពកី ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«មិញ ហន់ឌឹក ហន់តៀត អង់គ្លែត ដើម មែគ ណគ ជឹ វឹញ ហឹ ស្រុក អ៊ីស្រាអ៊ែល អន់ណាវ យ៉ាក់ ណគ់ មែ ម៉ើ ងុញ កជែត អង់គ្លែត នែ ម៉ើ គែត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","យ៉ូស៊ែប ឡើ រ៉ៃ ឡើ ជឹ តៀត អំប្រា ក្រមួន ម៉ិ ហឹ ប៊្រី ដាក អ៊ីស្រាអ៊ែល ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ហាក់ តគ់ ឡើ ដុង រៀន អាគែឡុះ ឡើ ឌឹក បើម សឋិច ទឹង ស្រុក យូដា ឡើ ថរ បើគ ណគ ហ៊ែរ៉ូត អ៊ែ យ៉ូស៊ែប ឡើ ឌូង លំជឹ ហឹ អ៊ែ។ អ៊ែ ឡើ ដក់ គូ ហឹ ស្រុក ឝ៉ាលីលែ យ៉ាក់ គ្រែដៃ ឡើ ហាយ ដើ ណគ តាម លញ៉ាគ់ ពកី។ ");
INSERT INTO brb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","អ៊ែ ឡើ ដក់ គូ ហឹ ស្រ៊ុក ណាសារែត អាំ លំដាវ ប៉ាគ់ គ្រែដៃ ឡើ ហាយ តាម លញ៉ាគ់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ រៀន៖ «មន់ជុ ណគ ឡើ ស្រ៊ុក ណាសារែត»។ ");
INSERT INTO brb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ទុត ឌុញ កម៉ តើម ប៊ឹង អ៊ែ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ដក់ ហឹ ត្រិញ ក្លៀវៗ ស្រុក យូដា ឡើ ពហាយ ដើ មែ ប៉ាសាសុន រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«វន់ពលិះ ចនិះ យ៉ឹ យ៉ាក់ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដៀប លំប៊ឹះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","កាន យ៉ូហាន នែ ឡើយ យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ រៀន៖ «លំប៊ិច កឡ មូយ រ៉ា លំពហាយ ថាំងៗ ហឹ ត្រិញ ក្លៀវៗ រៀន “មិញ វន់ចឝ៉ះ ពចាគ់ ទ្រូង ដើ គ្រែដៃ កន់ដ្រាគ់ វន់ពន់ទឹង ទ្រូង ដើ ណគ !”»។ ");
INSERT INTO brb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","យ៉ាគ់ យ៉ូហាន ឡើ ហក អាវ ឌ្រឹម ម៉ើ តាញ ដើ សក់ អូត ដើម ឡើ តាន់ សអ៊ែវ ម៉ើ បើម ដើ ហំបក ពត្រូវ។ ឡើ ចា អរ៉ាច ដើម ដាក ស៊ុត។ ");
INSERT INTO brb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","បូវ មែ មួង យែរូសាឡឹម ដើម បុ ដើ ស្រុក យូដា ដឹប លែក ដើ ស្រ៊ុក បរ ដណៃ យ៉ូរដាន់ ម៉ើ ដក់ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ម៉ើ ហំប្លប ចាក់ ម៉ើ ហាយ អ្រយូច មែ អ៊ែ យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក អាំ ដើ មែ ប៊ឹង ដណៃ យ៉ូរដាន់ អ៊ែ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ប៊ឹង យ៉ាគ់ យ៉ូហាន ឡើ តៃ បូវ មែ ផារីស៊ី ដើម បូវ មែ សាឌូស៊ី ទុត អើន ម៉ើ ដក់ បើម ឞ៊ុន ម៉ូច ដាក ហឹ ណគ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «អើយ កួន ចូវ ប៊ិះ ប្រៃ មែ ង៉ាយ ម៉ើ ហាយ ដើ វែ ណាគ់ វន់ដូវ ក្លើច តើម ប៊ឹង កាន មាំ គ្រែដៃ ណាគ់ ឞិតឞ៊ែត លំពដៃ ឡើយ កាន មាំ ណគ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","មិញ វន់បើម អន់ចាគ់ អ៊ែ លំត្រ ទឹង បនឹះ ម៉ើ ពលិះ ចនិះ ក្លើម ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ញ៉ង វ៉ើ អ៊ីង អ៊ឺម រៀន វ៉ើ កួន ចូវ យ៉ាគ់ អាប្រាហាំ អ៊ែ ណាគ់ វន់ក្លើច តើម ប៊ឹង កាន មាំ គ្រែដៃ។ អៃ អន់ហាយ ដើ វែ រៀន គ្រែដៃ លំចក់ លែក ដើ តម៉ នែ លំតវឹរ កួន ចូវ យ៉ាគ់ អាប្រាហាំ ដូវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ប៉ាគ់ បនឹះ ឡើ ជុ ជូង ចុ តើម ឡើ ប្ល៉ៃ តៃ ចាគ់ បក់ លំកូវ ហពៀវ តាក់ ហឹ អ៊ុញ ពអ៊ែ ទឺ ឡើយ ដើ គ្រែដៃ ដៀប លំពថូត បនឹះ ម៉ើ បើម កាន តៃ ចាគ់។ ");
INSERT INTO brb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","អៃ អបើម ឞ៊ុន តម៉ូច វែ ដើ ដាក ពដៃ រៀន វ៉ើ ពលិះ ចនិះ ឡើយ ហាក់ ណគ់ បឹ លំប៊ឹះ អន់ទុន អៃ ណគ អ៊ិន លំខាក់ ជឺរ អៃ។ សំយ៉ះ អន់ឡិះ ឆមឺ កើប ប៊ឹង ឈឹង ណគ ណាគ់ តៃ លំឃឺ។ ណគ អ៊ិន លំតម៉ូច វែ ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ដើម ដើ អ៊ុញ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ណគ អ៊ិន លំបើម ប៉ាគ់ បនឹះ ឡើ ដក់ កសារ ប៉ូះ បយឺង បឹត ចិះ ឡើ ឝ៉ឹន ចង់ឝួរ កឌែ អូម ចិះ ចក់ ឌិវ ចាក់ៗ ឡើ ជុ ទឹង នុក អ៊ែ ណគ់ ញ៉ាបៗ ឡើ តមួត ចុះ តាក់ ទិ អ៊ុញ ឡើ កាត ញឹះ តៃ ប៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ឡើ ដក់ ហឹ យ៉ាគ់ យ៉ូហាន អាំ លំបើម ឞ៊ុន តម៉ូច ដាក ដើ ណគ ប៊ឹង ដណៃ យ៉ូរដាន់។ ");
INSERT INTO brb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ហាក់ យ៉ាគ់ យ៉ូហាន ឡើ ឌី អ៊ឺម អ៊ែ ឡើ រៀន៖ «ហៃ លំត្រ ហំបើម ឞ៊ុន តម៉ូច ដាក ដើ អៃ ប៉ិ ឡើ ត្រ ហប៉្រៃ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ហំបើម ប៉ាគ់ នែ ឡើយ យ៉ាក់ ប៉ាគ់ នែ ឡើយ បន់បើម អ៊ែ លំត្រ ទឹង ក្លើម គ្រែដៃ»។ អ៊ែ យ៉ាគ់ យ៉ូហាន ឡើ ឌី ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","តគ់ យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក ដើ ណគ លែវ ឡើយ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឌឹក តើម ប៊ឹង ដាក។ ហំប៊្រុះ ដើ អ៊ែ គ្រែ កអវ ឡើ ប៉ើក ផូង អ៊ែ ឡើ តៃ ផវ យ៉ាង គ្រែដៃ ឡើ ទឺះ ទិ ណគ បើម ប៉ាគ់ កំប៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","អ៊ែ ម៉ើ ដុង ប្រយ ប្រម៉ាង តើម ទិ គ្រែ ឡើ រៀន៖ «អន់នែ កួន កឡ ប្រម៉ើត អៃ ឡើ ត្រ ទឹង ក្លើម អៃ ទុត ខាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ប្ល៊ី អ៊ែ ផវ យ៉ាង គ្រែដៃ ឡើ តៀត គ្រែដៃ យែស៊ូ ដក់ ហឹ ត្រិញ ក្លៀវៗ អាំ អរ៉ាក់ សតាំង លំពលូង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ប៊្លី ឡើ អឹត ចណង់ ចណា ញឹះ ពួន ជិត តង៉ៃ ពួន ជិត មាំង ឡើយ អ៊ែ ឡើ ពងួត។ ");
INSERT INTO brb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","អ៊ែ អរ៉ាក់ សតាំង ឡើ ណាយ ពលូង ឡើ ដក់ ហឹ ណគ ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ ហកួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត មិញ ហំប៉្រៃ តម៉ នែ មន់វឹរ ណុំពាំង ឡាំង»។ ");
INSERT INTO brb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “បនឹះ តៃ ត្រ ម៉ើ ញិវ វ៉ិះ ដើ ចណង់ ចណា អ៊ឺម ណគ់ ខាក់ៗ ម៉ើ ញិវ លែក ដើ ប្រម៉ាង ឡើ ញឺះ តើម ប៊ឹង គ្រែដៃ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ប្ល៊ី អ៊ែ អរ៉ាក់ សតាំង ឡើ តៀត គ្រែដៃ យែស៊ូ ហឹ មួង យែរូសាឡឹម ឡើ មួង ចាគ់ ភែង យ៉ើម អ៊ែ ឡើ ជុ គ្រែដៃ យែស៊ូ ទិ បូយ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","អរ៉ាក់ សតាំង ឡើ ម៉ាង ពលូង អន់ណាវ រៀន៖ «ប៉ាគ់ ហកួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត ហំជ្រុះ ឡាំង ទិ ប្រិះ ចុ យ៉ាក់ ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “គ្រែដៃ លំប៉្រៃ ឞាវ ណគ មន់លវាំង ឝ្លាំង ហៃ មន់ដើរ ហៃ ដើ ទី ញ៉ង អាំ ឈឹង ហៃ លំត្រ ប៉ុះ តម៉ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ ប៉ាគ់ទឺ រៀន “ញ៉ា បនឹះ ញ៉ង ញំបឡង ឝ្លាំង អ៊ឺម គ្រែដៃ កន់ដ្រាគ់ ឡើ គ្រែដៃ ញ៉ា ”»។ ");
INSERT INTO brb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ប្ល៊ី អ៊ែ អរ៉ាក់ សតាំង ឡើ តៀត គ្រែដៃ យែស៊ូ ទឹង ចន់ឌូ ទុត ឈ្រូង អ៊ែ ឡើ ចង់អូត ពដៃ លែក ដើ ប៊្រី ដាក ទិ ឡាង ប្រិះ នែ ដើម លែក ដើ ប្រនិច ទុត អូងអាត ទឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ ហំជឹះ ត្រកូវ កដាប ហំបះ អៃ អ៊ែ អន់អាំ ដើ ហៃ លែក ដើ ចុ»។ ");
INSERT INTO brb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ អរ៉ាក់ សតាំង រៀន៖ «សតាំង មិញ ហំវីះ តើម ប៊ឹង អៃ! យ៉ាក់ ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “ញ៉ា បនឹះ ញន់ត្រ កដាប ហំបះ គ្រែដៃ កន់ដ្រាគ់ ឡើ គ្រែដៃ ញ៉ា ញន់ត្រ ខរ៉ុប ចាប់ វ៉ិះ ឌិវ ណគ អិះ ឡើយ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","អ៊ែ អរ៉ាក់ សតាំង ឡើ វីះ តើម ប៊ឹង ណគ ហំប៊្រុះ ដើ អ៊ែ បូវ ឞាវ គ្រែដៃ ម៉ើ ដក់ បើម ឞយ ណគ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","តគ់ គ្រែដៃ យែស៊ូ ឡើ ដុង ម៉ើ រ៉ាប់ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ម៉ើ ជុ ទឹង ឃុក អ៊ែ ឡើ ជឹ វឹញ ហឹ ស្រុក ឝ៉ាលីលែ។ ");
INSERT INTO brb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ប៊្លី អ៊ែ ឡើ វីះ តើម ប៊ឹង ស្រ៊ុក ណាសារែត ឡើ ដក់ គូ ហឹ មួង កាផារនុំ មួង នែ បរ សមុត ទឹង ប៊្រី ដាក សាប់យូឡូន អំប្រា នែបថាលី ។ ");
INSERT INTO brb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","កាន នែ ឡើ កើត អាំ ដាវ ប៉ាគ់ យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«អើយ ណគ់ វែ វ៉ើ គូ ហឹ ប្រ៊ី ដាក សាប់យូឡូន ដើម នែបថាលី បរ សមុត វ៉ើ ស្រុក តៃ ម៉ាត់ តង៉ៃ លុច ដណៃ យ៉ូរដាន់ ទឹង ស្រុក ឝ៉ាលីលែ ណគ់ មែ សុនសាត គែង ម៉ើ គូ ");
INSERT INTO brb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","បូវ វ៉ើ គូ ទឹង កឡាំ វន់តៃ ឝ៉ាល លំត្រប៉្រៃ ទុត ថាំង លំប៊ិច ឝ៉ាល លំញឺះ ពឝ៉ាល ដើ វែ វ៉ើ គូ ក្រូម អាតណាត កាន គែត »។ ");
INSERT INTO brb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","តគ់ គ្រែដៃ យែស៊ូ ឡើ ដក់ គូ ហឹ មួង កាផារនុំ តើម ប៊ឹង អ៊ែ ឡើយ ឡើ ពន់តើម ពហាយ ដើ មែ រៀន៖ «មិញ វន់ពលិះ ចនិះ យ៉ាក់ គ្រែដៃ ដៀប លំប៊ឹះ ពែក ប៉ាក់ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ ដក់ បរ ពឹះ សមុត ឝ៉ាលីលែ ឡើ តៃ អំប្រា អំម៉ោះ អោះ ទឹង អំប្រា ឆុក ទិ ដាក សមុត។ បឹ មូយ រ៉ា ម៉ាត់ ណគ ស៊ីម៉ូន ម៉ើ ជុ ពែត្រុះ ដិ ដើម អោះ ណគ អន់ឌ្រែ។ អំប្រា នែ អំប្រា ខើយ ដាំង ចា ដើ ទ្រឺ។ ");
INSERT INTO brb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","គ្រែដៃ យែស៊ូ ឡើ ច្រា អំប្រា រៀន៖ «ដក់ សប្រា លំតូយ អៃ អំប៉្រៃ សប្រា លំសាត ដាំង បនឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","អ៊ែ អំប្រា តាក់ ឆណុក ប៊ឹង អិះ ប្រយ អំប្រា ដក់ តូយ ណគ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ងឺរ ឞិតឞ៊ែត ឡើ តៃ អំប្រា អំម៉ោះ អោះ គែង អ៊ែ អន់ណាវ ម៉ាត់ អំប្រា យ៉ាកុប ដើម យ៉ូហាន កួន យ៉ាគ់ ស៊ែប៊ែឌែ ទឹង ប៉ះ ម៉ើ ឈ្រុល អួន ទឹង ឌូក អរែង ដើ បើគ អំប្រា។ អ៊ែ ឡើ កឡូវ អំប្រា ");
INSERT INTO brb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","អំប្រា តាក់ ឌូក ដើម បើគ អំប្រា អ៊ែ អំប្រា តូយ ប្រយ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ បុ ស្រុក ឝ៉ាលីលែ ដើម ឡើ ពង់ហៀន មែ ទឹង រ៉ូង ពស៊ុំ មែ យូដា ឡើ ពហាយ កាន ចាគ់ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដើម ឡើ ពនៀម ឆនិ មែ ត្រំ ហំឞ្លិច អាំ នៀម។ ");
INSERT INTO brb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","អ៊ែ ឡើ លឺ ប្រយ ម៉ាត់ គ្រែដៃ យែស៊ូ បុ ស្រុក ស៊ីរី។ ម៉ើ តៀត លែក ដើ បនឹះ ឆនិ ត្រំ ហំឞ្លិច ដើម បនឹះ ឈិ កយឹក បនឹះ អរ៉ាក់ មឹត បនឹះ វិត ជុរ ដើម បនឹះ កុង ទី កុង ឈឹង ហឹ គ្រែដៃ យែស៊ូ គ្រែដៃ យែស៊ូ ឡើ ពនៀម ប្រយ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","មែ ប៉ាសាសុន ទុត អើន ឆឹន ហន់ឆឹន វ៉ិន អវែន ម៉ើ តូយ គ្រែដៃ យែស៊ូ។ បូវ មែ នែ ម៉ើ ប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ស្រុក ឌែកាប៉ូល មួង យែរូសាឡឹម ស្រុក យូដា ដើម តើម ប៊ឹង ស៊្រុក បរ ដណៃ យ៉ូរដាន់ ពឹះ តៃ តគ់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","តគ់ គ្រែដៃ យែស៊ូ ឡើ តៃ មែ ប៉ាសាសុន ទុត អើន អ៊ែ ឡើ ឌឹក ទឹង ចន់ឌូ ឡើ ដ្រូម ប៊ឹង អ៊ែ ប្រយ។ មែ លុកស៊ិក ម៉ើ ដក់ តមួត ហឹ ណគ ");
INSERT INTO brb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","អ៊ែ ឡើ ពង់ហៀន មែ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«អើយ ណគ់ មែ ម៉ើ ណោះ តងកាន គ្រែដៃ តៃ ម៉ើ មឹង ចាក់ កឡឹ មន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ គ្រែដៃ លំពែក ប៉ាក់ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ណគ់ មែ ម៉ើ តង៉ូក ឆ្រុក មន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ គ្រែដៃ លំពញឹម ក្លើម មែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ណគ់ មែ ម៉ើ ប៊ិច ចនិះ ស៊ិម បក់ មន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ គ្រែដៃ លំអាំ ឡាង ប្រិះ ដើ មែ មន់បើម មូន។ ");
INSERT INTO brb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ណគ់ មែ ម៉ើ ងុញ កាន ចាគ់ ទឹង ត្រ ឞាល់ ម៉ើ ពងួត ឞាល់ ម៉ើ ហឡាគ់ ដាក មន់ហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ គ្រែដៃ លំអាំ ដើ មែ តូវ មន់ផិ ប៊ិង ដើ កាន ចាគ់ ទឹង ត្រ។ ");
INSERT INTO brb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ណគ់ មែ ម៉ើ ណោះ ស្រុស្រៀត មន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ គ្រែដៃ លំស្រុស្រៀត ប៉ាគ់ទឺ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ណគ់ មែ ម៉ើ ប៊ិច ចនិះ ចាគ់ ស៊ីត មន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ មន់តៃ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ណគ់ មែ ម៉ើ ណោះ ពទែប ពរែប បូវ អាំ ម៉ើ ហំពែម រែម មន់ហ្រុនក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ មែ អ៊ែ គ្រែដៃ លំជុ មែ កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ណគ់ មែ ង៉ាយ បូវ ម៉ើ តំឞាប ញ៉ន ម៉ើ បើម កាន ចាគ់ ទឹង ត្រ មន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ យ៉ាក់ គ្រែដៃ លំពែក ប៉ាក់ មែ»។ ");
INSERT INTO brb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«ប៉ាគ់ មែ ង៉ាយ មន់ឡឹម លៀវ មន់តំឞាប មន់ម៉ាង ពសុ ម៉ុះ ម៉ាត់ វែ ត្រំ ហំឞ្លិច ញ៉ន ដើ អៃ វន់ហ្រនុក ហ្រវ៉ាក់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","មិញ វន់ញឹម ក្លើម ក្លាក រ៉ក់សំ ឆំតក យ៉ាក់ គ្រែដៃ លំអាំ តង់ហវ ទុត ទិះ ទឹង ហូង គ្រែ យ៉ាក់ ណគ់ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ទឹង ប៉ាង ឡៃ មាំង ម៉ើ តំឞាប មែ ប៉ាគ់ នែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«វែ វ៉ើ បើម ប៉ាគ់ បោះ ដើ បនឹះ ទិ ឡាង ប្រិះ នែ ហាក់ ប៉ាគ់ បោះ លំប៉ាត់ តារ់ ប៉ាគ់ ង៉ាយ ងំបើម អ៊ែ លំតារ់ ឡឹះ បោះ នែ លំខា យ៉ាវ វ៉ិះ ឌិវ ងំហវ៉ាក់ តាក់ អ៊ែ បនឹះ មន់ឆាន់។ ");
INSERT INTO brb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","វែ វ៉ើ បើម ប៉ាគ់ អ៊ុញ ឡើ ពឝ៉ាល ដើ បនឹះ ទិ ឡាង ប្រិះ។ ប៉ាគ់ទឺ ឡើយ មួង ម៉ើ បើម ទឹង បូយ ចន់ឌូ ដូវ អ៊ឺម មន់កដក។ ");
INSERT INTO brb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","មូយ អន់ណាវ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ចុះ តកៀង មន់ទ្រូប ដើ រែវ តកៀង នែ មន់ជុ ទិ ឈ្រុង ឈ្រូង អាំ លំឝ៉ាល លែក ដើ មែ ទឹង ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ប៉ាគ់ ពអ៊ែ វន់អាំ ឝ៉ាល វែ លំត្រប៉ៃ ដើ បនឹះ អាំ មន់តៃ កាន ចាគ់ វែ វ៉ើ បើម ដើម អាំ មន់ព្រតឹះ ព្រនែ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«ញ៉ង វ៉ើ ឃឹត អ៊ឺម រៀន អៃ អប៊ឹះ ទិ នែ បក់ អំតប៉ាត់ ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ដើម ប្រម៉ាង មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ អៃ អប៊ឹះ បក់ អំបយ៉ឹះ តាម ប្រម៉ាង ទឹង ពឹម ហវ៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ណគ់ ខាក់ៗ អៃ អន់ហាយ ដើ វែ រៀន ទឹង ឡាង ប្រិះ ឡាង គ្រែ ណាគ់ លំណាគ់ ប៊ិច អ៊ឺម លំប៉ាត់ កន់ដ្រៀះ លឺ ចទុ មូយ ទឹង ពឹម ចឞាប់ គ្រែដៃ ឆា ដើ ប៊ឹះ លែក ដើ ប្រម៉ាង ទឹង ពឹម លំកើត ដាវ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ប៉ាគ់ ពអ៊ែ មែ ង៉ាយ មន់អន់លឺន ពន់ដ្រៃ គ្រែដៃ ហម កិៗ ទឹង ចឞាប់ នែ ដើម មន់ពង់ហៀន បូវ អាំ មន់ត្រួយ តាម មែ មែ អ៊ែ មន់កិ ជឺរ បូវ ទឹង ឞន គ្រែដៃ ឡើ ពែក ប៉ាក់។ អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ បើម ត្រួយ ពន់ដ្រៃ ទឹង ចឞាប់ គ្រែដៃ ដើម មន់ពង់ហៀន អាំ មន់បើម ត្រួយ ចឞាប់ ប៉ាគ់ទឺ មែ អ៊ែ មន់ទិះ ទឹង ឞន គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ តៃ វន់ចាគ់ ទឹង ត្រ ជឺរ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ មែ ផារីស៊ី វែ វន់ដូវ អ៊ឺម មឹត ទឹង ឞន គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«វែ វ៉ើ ខើយ ដុង ឡើយ ម៉ើ ហាយ ដើ មែ ម៉ិ យ៉ាគ់ វែ ឡៃ មាំង រៀន “ញ៉ង កជែត បនឹះ ” ដើម ម៉ើ រៀន “មែ ង៉ាយ ម៉ើ កជែត បនឹះ មែ អ៊ែ លំត្រ មន់តាត់ស៊ិន ពថូត ឡើយ ”។ ");
INSERT INTO brb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អន់ហាយ ដើ វែ រៀន មែ ង៉ាយ ម៉ើ មាំ ដើ បូវ ប៊ែង មែ អ៊ែ មន់ត្រ តាត់ស៊ិន ពថូត ដើម មែ ង៉ាយ មន់ជុ មែ បូវ ប៊ែង រៀន “តៃ ម៉ាត” មែ អ៊ែ មន់ត្រ មែ ទិះ ក្រាគ់ មន់តាត់ស៊ិន ពថូត ដើម មែ ង៉ាយ ម៉ើ ជុ បូវ ប៊ែង រៀន “អន់ឌ្រូយ” មែ អ៊ែ មន់ត្រ គ្លីះ ទិ ហួម អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ប៉ាគ់ ពអ៊ែ ប៊ឹង ហន់តៀត អន់ណាំ ម៉ប ដើ គ្រែដៃ ប៊ឹះ តគ់ ឞន ថនួយ ប៉ាគ់ ហន់ចនិះ ហឹ បូវ ប៊ែង ហៃ ឡើ ប៊ិច កាន តៃ ឆនឹម ដើ ហៃ ");
INSERT INTO brb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ហន់ជុ អន់ណាំ ប៊ឹង អិះ ឡើយ អន់ដៃ ហន់ជឹ ហ្រឡះ ហំប៉ះ ដើ ណគ ប៊្លី អ៊ែ ហន់ដក់ ម៉ប ពន់ឆា អន់ណាវ អន់ណាំ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ប៉ាគ់ ប៊ិច មូយ រ៉ា លន់តៀត ផង ហៃ ហន់ត្រ ហ្រឡះ ហំប៉ះ ត្រឌីវ សប្រា ដ្រិះៗ កឡាគ់ លំឈូន ហៃ ហឹ កឡា តាត់ស៊ិន អ៊ែ កឡា តាត់ស៊ិន លំឈូន ហៃ ហឹ ពលិះ អ៊ែ មែ ពលិះ មន់ជុ ហៃ ទឹង ឃុក។ ");
INSERT INTO brb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ណគ់ ខាក់ៗ អៃ អន់ហាយ ដើ វែ រៀន តៃ កា វន់សៀ ដើ មែ អាំ ណុះ អន់ដៃ អ៊ែ វន់ដូវ ញឺះ តើម ប៊ឹង ឃុក»។ ");
INSERT INTO brb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«វែ វ៉ើ ខើយ ដុង ឡើយ ម៉ើ ហាយ រៀន “ញ៉ង ឡើះ ច្រើន ”។ ");
INSERT INTO brb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ណគ់ ដើ អៃ អន់ណាវ អំហាយ ដើ វែ រៀន បឹ អង់ង៉ាយ ឡើ ឝ្លាំង ហឹ កទ្រី វ៉ិះ ឝ៉ាន់ ឡើ ងុញ កី ទឹង ចនិះ ណគ ឡើ ឡើះ ទ្រី ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ប៉ាគ់ ម៉ាត់ តៃ ចម៉ា ហៃ លំច្រា បើម កាន យូច ហំឝ៉ិច ពៀវ តាក់ ប្រយ ណាគ់ ហយ ហំប៉ាត់ ម៉ាត់ មូយ ច្រះ ហំប្លះ ចាក់ ដៃ ហៃ លំស្រូម ដឹប គ្រែដៃ លំពៀវ ហៃ ទិ ហួម អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ប៉ាគ់ ទី ចម៉ា ហៃ លំច្រា បើម កាន យូច ហន់ឆាល់ ហពៀវ តាក់ ប្រយ ណាគ់ ហយ ហំប៉ាត់ ទី មូយ ច្រះ ហំប្លះ ចាក់ ដៃ ហៃ លំស្រូម ដឹប ហំគ្លីះ ទិ ហួម អ៊ុញ»។ ");
INSERT INTO brb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«យ៉ាគ់ ម៉ូស៊ែ ឡើ ហាយ រៀន “បឹ អង់ង៉ាយ ឡើ ងុញ តាក់ ទ្រី ណគ អ៊ែ តង លំខៀន សំឞ៊ុត តាក់ ទ្រី អាំ ដើ ទ្រី អន់ដៃ ”។ ");
INSERT INTO brb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អំហាយ ដើ វែ រៀន ប៉ាគ់ កទ្រី តៃ លំឡើះ ក្ល ក្ល ណគ លំតាក់ ហង់កាៗ។ អ៊ែ ប៉ាគ់ ទ្រី ណគ លំចក់ ក្ល ហន់ដើម ក្ល តើម ណគ ឡើ បើម ប៉ាគ់ ឡើ ប៉្រៃ ទ្រី ណគ ឡើះ ណគ ឡើយ។ អ៊ែ ណគ់ បឹ អង់ង៉ាយ ឡើ ចក់ កទ្រី ក្ល ណគ ឡើ តាក់ ណគ អ៊ែ ឞាល់ ឡើ កី ដើ ទ្រី មែ គែង ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«វែ វ៉ើ ខើយ ដុង ឡើយ ម៉ើ ហាយ ដើ ម៉ិ យ៉ាគ់ វែ ឡៃ មាំង រៀន “ប៊ឹង វន់តប៉ឹន ចាក់ ញ៉ង វ៉ើ ក្លើច ម៉ាង អ៊ឺម ណគ់ កាន អង់ង៉ាយ វ៉ើ ខណាត តប៉ឹន ចាក់ ប៊ឹង ងឺរ គ្រែដៃ កន់ដ្រាគ់ តង វន់បើម ត្រួយ ម៉ាត់ ម៉ាត ”។ ");
INSERT INTO brb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អន់ហាយ ដើ វែ រៀន ញ៉ង វ៉ើ តប៉ឹន ចាក់ អ៊ឺម ប្រយ។ ញ៉ង វ៉ើ តប៉ឹន ចាក់ ចក់ គ្រែ បើម កឡា តៃ យ៉ាក់ គ្រែ ឡើ ទិងមៀង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ញ៉ង វ៉ើ តប៉ឹន ចាក់ ចក់ ឡាង ប្រិះ បើម កឡា តៃ យ៉ាក់ ឡាង ប្រិះ នែ ឝណើវ ឈឹង គ្រែដៃ ញ៉ង វ៉ើ តប៉ឹន ចាក់ ចក់ មួង យែរូសាឡឹម បើម កឡា តៃ យ៉ាក់ មួង នែ មួង គ្រែដៃ ឡើ សឋិច ទុត ទិះ។ ");
INSERT INTO brb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ញ៉ង វ៉ើ តប៉ឹន ចាក់ ចក់ ទូះ វែ បើម កឡា តៃ យ៉ាក់ វ៉ើ ណោះ អ៊ឺម បើម សក់ វែ លំបក លឺ លំអយូង សំយ៉ះ មូយ ឡង វន់បើម ណាគ់ តៃ ដូវ។ ");
INSERT INTO brb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","តង វន់ចជែ ទឹង ត្រ ប៉ាគ់ លំដាវ វន់រៀន “ដាវ” ប៉ាគ់ តៃ លំដាវ វន់រៀន “តៃ ដាវ”។ អ៊ែ ណគ់ ប្រម៉ាង ពន់ជឺរ អន់ណាវ ម៉ាត់តូវ ឡើ ញឺះ តើម ប៊ឹង អរ៉ាក់ សតាំង»។ ");
INSERT INTO brb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«វែ វ៉ើ ខើយ ដុង ឡើយ ម៉ើ ហាយ រៀន “បឹត ម៉ាត់ ធែន ម៉ាត់ បឹត ពឹង ធែន ពឹង ”។ ");
INSERT INTO brb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អំហាយ ដើ វែ រៀន ញ៉ង វ៉ើ តូវ អ៊ឺម ប៊ឹង បនឹះ ចនិះ តៃ ចាគ់ ប៉ាគ់ មន់តាះ ហៃ តៃ ចម៉ា ហន់អាំ មន់តាះ តៃ ចអៀវ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ប៉ាគ់ មន់តិច ហៃ ម៉ើ ងុញ ចក់ អាវ កនុង ហន់អាំ អាវ ឌ្រឹម ដិ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ប៉ាគ់ ប៊ិច មែ មន់ពង់ខំ ហៃ ប៉្រៃ កួយ រ៉ាះ មែ ចង៉ាយ ទ្រូង មូយ កឡូ ហន់ដក់ ពន់ជឺរ មូយ កឡូ ឡឹះ អន់ណាវ យ៉ឹ។ ");
INSERT INTO brb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ប៉ាគ់ មែ ង៉ាយ មន់ឡា រ៉ាះ ហឹ ហៃ ហន់អាំ ដើ មែ។ អ៊ែ ប៉ាគ់ មែ ង៉ាយ មន់ឡា តង់ ហឹ ហៃ ញ៉ង ហពសាះ អ៊ឺម មែ»។ ");
INSERT INTO brb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«វែ វ៉ើ ខើយ ដុង ឡើយ ម៉ើ ហាយ រៀន “តង វន់ម៉ើត ដើ បូវ ប៊ែង វែ  អ៊ែ ណគ់ មែ ម៉ើ ដ្រម៉ា ដើ វែ ញ៉ង វ៉ើ រែម អ៊ឺម យ៉ឹ”។ ");
INSERT INTO brb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អន់ហាយ ដើ វែ រៀន វន់ម៉ើត ណគ់ មែ ម៉ើ ដ្រម៉ា ដើ វែ ដើម វន់អ៊ឺរ ដាំង គ្រែដៃ ណគ់ ដើ មែ ម៉ើ តំឞាប វែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ប៉ាគ់ នែ វន់បើម អ៊ែ លំត្រ វ៉ើ កួន គ្រែដៃ បើគ ឡើ គូ ទឹង ហូង គ្រែ យ៉ាក់ ណគ ឡើ អាំ ម៉ាត់ តង៉ៃ ឡើ ឌឹក ពឝ៉ាល ដើ បនឹះ ចាគ់ ដើម ដើ បនឹះ តៃ ចាគ់ ដើម ឡើ អាំ ដាក អំមឺ ដើ បនឹះ ទឹង ត្រ ដើម ដើ បនឹះ តៃ ទឹង ត្រ។ ");
INSERT INTO brb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ប៉ាគ់ វន់ម៉ើត វ៉ិះ ឌិវ បនឹះ ណគ់ ម៉ើ ម៉ើត វែ ពយ៉ិ គ្រែដៃ ណាគ់ លំអាំ ឡះ តង់ហវ ដើ វែ? ទុត បនឹះ ម៉ើ កាគ់ លៀន ណាគ់ ម៉ើ ប្រម៉ើត ត្រឌីវ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","អ៊ែ ប៉ាគ់ វន់តង៉ា ឡា ច្រា ចង់ វ៉ិះ ឌិវ បូវ ប៊ែង វែ កឡឹ ពយ៉ិ លំរ៉គ់? ទុត សុនសាត មែ គែង ណាគ់ ម៉ើ ណោះ តង៉ា ឡា ច្រា ចង់ ប៉ាគ់ទឺ ឡើយ ត្រឌីវ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ឡើ ចាគ់ ស៊ីត ប៉ាគ់ ង៉ាយ វែ តង វន់ចាគ់ ស៊ីត ប៉ាគ់ ដើ ណគ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«វន់លវាំង យ៉ឹ ញ៉ង វន់បើម អន់ចាគ់ អ៊ឺម វ៉ិះ ឝ៉ាន់ ប៊ឹង ងឺរ បូវ មន់តៃ។ ប៉ាគ់ វន់បើម ប៉ាគ់ អ៊ែ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ទិ លំអាំ អ៊ឺម តង់ហវ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ប៊ឹង វន់អន់ណាំ ដើ មែ ម៉ូវ ម៉ក ញ៉ង វ៉ើ ពហាយ ពន់ដុង អ៊ឺម បូវ ប៉ាគ់ ដើ មែ ម៉ើ ពឃឺ វ៉ិះ តៃ ពឺង ម៉ើ ពហាយ ទឹង រ៉ូង ពស៊ុំ លឺ តៃ ទ្រូង អូក រង់អូក បក់ បូវ មន់ព្រតឹះ។ ដាវ ម៉ាត់ ម៉ាត អៃ អហាយ ដើ វែ រៀន បូវ មែ អ៊ែ ម៉ើ ដូវ តង់ហវ វ៉ិះ ឌិវ បូវ មន់ព្រតឹះ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ប៊ឹង ទី ចម៉ា វែ លន់អន់ណាំ ដើ មែ ម៉ូវ ម៉ក ញ៉ង វ៉ើ អាំ អ៊ឺម ទី ចអៀវ លំណោះ ");
INSERT INTO brb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","អ៊ែ អន់ណាំ វែ លំវៀក វ៉ិះ ឌិវ គ្រែដៃ បើគ វែ ឡើ កឡា តៃ ត្រំ កាន វៀកៗ លំឡាប់ អាំ អន់ណាំ ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ប៊ឹង វន់អ៊ឺរ ដាំង គ្រែដៃ ញ៉ង វន់បើម អ៊ឺម ប៉ាគ់ ដើ មែ ម៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង ម៉ើ ឍុ ឆុង អ៊ឺរ ដាំង គ្រែដៃ ទឹង រ៉ូង ពស៊ុំ ដើម ប៊ឹង ទ្រូង ច្រឡះ ព្រឌឹង ព្រឡាត់ អាំ បូវ មន់តៃ។ ដាវ ម៉ាត់ ម៉ាត អៃ អហាយ ដើ វែ រៀន បូវ មែ អ៊ែ ម៉ើ ដូវ តង់ហវ វ៉ិះ ឌិវ បូវ មន់ព្រតឹះ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ប៊ឹង វន់អ៊ឺរ ដាំង គ្រែដៃ វន់មឹត ហឹ សួម វន់ពាំង កម៉ង អ៊ែ វន់អ៊ឺរ ដាំង គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ឞន វៀកៗ។ អ៊ែ គ្រែដៃ បើគ វែ ឡើ តៃ ទឹង ឞន វៀកៗ លំឡាប់ អាំ អន់ណាំ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ប៊ឹង វន់អ៊ឺរ ដាំង គ្រែដៃ ញ៉ង វ៉ើ ម៉ាង អ៊ឺម អន់ទឺៗ ទុត ឌុញ តៃ ប៊ិច ឌូរ ប៉ាគ់ ដើ មែ សុនសាត គែង យ៉ាក់ ម៉ើ ឃឹត រៀន មន់ម៉ាង ទុត ឌុញ ឞាល់ អ៊ែ ឡើយ អ៊ែ ឝ្រូគ្រែ មែ មន់ចង់ហៀង។ ");
INSERT INTO brb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ញ៉ង វន់បើម អ៊ឺម ប៉ាគ់ ដើ មែ យ៉ាក់ គ្រែដៃ បើគ វែ ឡើ ណោះ លែក ឡើយ កាន វែ វ៉ើ តងកាន ណាគ់ តៃ ដាន់ វ៉ើ ឡា ហឹ ណគ អំម៉ឹះ សាំ។ ");
INSERT INTO brb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ប៉ាគ់ ពអ៊ែ ប៊ឹង វន់អ៊ឺរ ដាំង ហឹ ណគ ប៉ាគ់ នែ វន់ម៉ាង៖ “ឡា គ្រែដៃ បើគ ញ៉ា អើយ ហគូ ទឹង ហូង គ្រែ អាំ បនឹះ លែក រ៉ា មន់អៀល បឹះ ម៉ាត់ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ឡា ហំប៊ឹះ ពែក ប៉ាក់ បនឹះ ទិ ឡាង ប្រិះ នែ ឡា អាំ លំដាវ តាម ចនិះ ហៃ ទិ ឡាង ប្រិះ នែ ប៉ាគ់ ទឹង ហូង គ្រែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ឡា ហំអាំ ចណង់ ចណា ដើ ញ៉ា ញ៉ើ តងកាន តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ឡា ហន់តាក់ អ្រយូច ដើ ញ៉ា ប៉ាគ់ ញ៉ា ញ៉ើ តាក់ ដើ មែ ម៉ើ បើម អន់យូច ដើ ញ៉ា ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ឡា ញ៉ង ហអាំ អ៊ឺម ញ៉ា ញំគ្លីះ ទឹង កាន ពលូង ណគ់ ខាក់ៗ ហំតោះ ញ៉ា អាំ ក្លើច តើម ប៊ឹង អាតណាត តៃ ចាគ់ យ៉ាក់ ហៃ ឡើយ ហពែក ប៉ាក់ ហប៊ិច អាតណាត ឆង៉ាត់ ដើម កាន អូងអាត តៃ ឋាំ ឡូច អន់សច អាមែន”»។ ");
INSERT INTO brb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«ប៉ាគ់ វន់តាក់ អ្រយូច ដើ មែ ម៉ើ បើម អន់យូច ដើ វែ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ លំតាក់ ប៉ាគ់ទឺ អ្រយូច ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ហាក់ ប៉ាគ់ តៃ វន់តាក់ អ្រយូច ដើ មែ ម៉ើ បើម អន់យូច ដើ វែ គ្រែដៃ បើគ វែ លំតាក់ អ៊ឺម ប៉ាគ់ទឺ អ្រយូច ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ប៊ឹង វន់អឹត ចណង់ ចណា ខរ៉ុប គ្រែដៃ ញ៉ង វ៉ើ បើម អ៊ឺម មុះ ម៉ាត់ ហម៉ើយ ហម៉ិច ប៉ាគ់ ដើ មែ ម៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង។ ម៉ើ បើម ប៉ាគ់ អ៊ែ បក់ បូវ មន់តៃ រៀន មែ អ៊ែ ម៉ើ អឹត ចណង ចណា។ ដាវ ម៉ាត់ ម៉ាត អៃ អហាយ ដើ វែ រៀន មែ អ៊ែ ម៉ើ ដូវ តង់ហវ វ៉ិះ ឌិវ បូវ មន់ព្រតឹះ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ប៊ឹង វន់អឹត ចណង់ ចណា ខរ៉ុប គ្រែដៃ តង វន់ឡច សក់ ទូះ ដើ ណាំហម ដើម វន់ហន់ឆាវ មុះ ម៉ាត់ ដិ ");
INSERT INTO brb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ញ៉ង អាំ បូវ មន់តៃ វែ វ៉ើ អឹត ចណង់ ចណា វ៉ិះ ឌិវ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ឞន វៀកៗ លំតៃ វែ។ អ៊ែ គ្រែដៃ បើគ វែ ឡើ តៃ ទឹង ឞន វៀកៗ លំឡាប់ អាំ អន់ណាំ ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ញ៉ង វ៉ើ អន់តង ជុ អ៊ឺម ប្រនិច ដើ ចាក់ កឡឹ ទិ ឡាង ប្រិះ នែ យ៉ាក់ ឡើ ឞន ប៊ិច កន់តៀរ មូរ ដើម កនែ ខារ់ ដឹប ប៊ិច ខម៉ូយ សោះ មឹត តទូង ចចក់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ណគ់ ខាក់ៗ វន់ត្រ អន់តង ជុ ប្រនិច ទឹង ហូង គ្រែ យ៉ាក់ ទឹង អ៊ែ តៃ ប៊ិច កន់តៀរ លំមូរ តៃ ប៊ិច កនែ លំខារ់ ដើម ប៊ិច អ៊ឺម ខម៉ូយ មន់មឹត តទូង ចចក់។ ");
INSERT INTO brb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","យ៉ាក់ ប្រនិច វែ ហឹ ង៉ាយ ចនិះ វែ ហឹ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«ម៉ាត់ វែ ឡើ បើម ប៉ាគ់ តកៀង ទឹង ចាក់ ដៃ។ ប៉ាគ់ ម៉ាត់ វែ ឡើ ចាគ់ នៀម អ៊ែ លែក ទឹង ចាក់ ដៃ វែ លំឝ៉ាល ប៉ាគ់ទឺ ");
INSERT INTO brb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ហាក់ ប៉ាគ់ ម៉ាត់ វែ តៃ ឡើ ចាគ់ នៀម អ៊ែ លែក ទឹង ចាក់ ដៃ វែ លំហ្រង៉ូម ប៊្រែ ប៉ាគ់ទឺ។ ប៉ាគ់ ត្រប៉ៃ ទឹង ចាក់ វែ លំហ្រង៉ូម អ៊ែ វន់គូ ទឹង ហ្រង៉ូម ប៊្រែ ទុត ខាក់ តៃ ណោះ ប៉ាគ់ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម លំបើម ឞយ បារ កន់ដ្រាគ់ យ៉ាក់ លំម៉ើត ដើ កន់ដ្រាគ់ មូយ តៃ លំរែម ដើ កន់ដ្រាគ់ លមូយ លំអៀល បឹះ ដើ កន់ដ្រាគ់ មូយ ដើ កន់ដ្រាគ់ លមូយ អន់ណាវ លំឝ្លីង ឝ្លាំង រាំង តាក់។ ដូវ អ៊ឺម វន់អៀល បឹះ គ្រែដៃ ដិ វន់ងុញ រ៉ាះ អំបាះ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«ញ៉ន នែ ឡើយ អ៊ែ អហាយ ដើ វែ រៀន ញ៉ង វ៉ើ វ៉ឹនវ៉ាយ អ៊ឺម ដើ កាន ញិវ កើត ប៉ាគ់ ឡើ ចណង់ ចណា ដាក ញែត លឺ ប្រវ៉ើន ហណក។ យ៉ាក់ កាន ញិវ កើត ទិ ឡាង ប្រិះ នែ ឡើ ប៊ិច ខា ជឺរ ចណង់ ចណា អ៊ែ ណគ់ ចាក់ ដៃ វែ ឡើ ប៊ិច ខា ជឺរ ប្រវ៉ើន ហណក អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","វន់ឃឹត ឡាំង ដើ ជែម ម៉ើ ប៉ារ់ ទឹង គ្រែ ញឹះ តៃ ម៉ើ ឆមូ ចួយ ញឹះ តៃ ម៉ើ សួត រ៉ិះ តមួត ជុ ទឹង នុក ហាក់ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ណាគ់ ឡើ ចៀម មែ។ អ៊ែ ណគ់ ដើ វែ អន់ណាវ វ៉ើ ប៊ិច ខា ជឺរ ជែម ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ទឹង បូវ វែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ ពឝ៉ុះ អញុ កឡឹ ញ៉ន ដើ វ៉ឹនវ៉ាយ សំ ឞិតឞ៊ែត ណាគ់ តៃ ដូវ»។ ");
INSERT INTO brb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«ប៉ាគ់ ង៉ាយ ឡើ ត្រ វ៉ើ វ៉ឹនវ៉ាយ ដើ ប្រវ៉ើន ហណក? វន់ឃឹត ឡាំង ដើ ពឺរ ទឹង ត្រិញ ប៉ាគ់ ង៉ាយ វ៉ើ តៃ ឡើ ហួន? ញឹះ តៃ ឡើ ប៉ាប ពពឹត បបើម តតាញ ពប៉ោះ ");
INSERT INTO brb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","អៃ អំហាយ ដើ វែ រៀន ទុត សឋិច សាឡូម៉ូន ឡើ ប៊ិច បាក់ អូងអាត តៃ ឋាំ ប្រវ៉ើន ហណក ណគ ទុត ចាគ់ ឞាល់ អ៊ែ ណាគ់ តៃ ឈែវ លំចាគ់ ឞាល់ ពឺរ។ ");
INSERT INTO brb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ទុត ពឺរ ហឹ ត្រិញ ឡើ ហួន វ៉ិះ មូយ តង៉ៃ តគ់ ប្រណូវ ម៉ើ ប៊ុះ តាក់ ទិ អ៊ុញ គ្រែដៃ ណាគ់ ឡើ ប៉្រៃ ឡាក ចាគ់ៗ។ ឡា បនឹះ ណគ់ វែ តៃ ហ៊ែត ចាប់ មឹង អើយ គ្រែដៃ លំអាំ ប្រវ៉ើន ហណក ដើ វែ ណាគ់ ហម ពឺរ អន់ណាវ វ៉ើ ណោះ។ ");
INSERT INTO brb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ប៉ាគ់ ពអ៊ែ ញ៉ង វ៉ើ វ៉ឹនវ៉ាយ អ៊ឺម រៀន “ហឹ ង៉ាយ ឋូវ ងំតៃ ចណង ចណា ហឹ ង៉ាយ ងំតៃ ដាក ញែត លឺ ប្រវ៉ើន ហណក?” ");
INSERT INTO brb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","មែ សុនសាត គែង ម៉ើ ខំ ដាំង រ៉ាះ លែក អ៊ែ។ អ៊ែ ណគ់ ដើ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ណគ ឡើ ណោះ ឡើយ លែក ដើ កាន វែ វ៉ើ តងកាន។ ");
INSERT INTO brb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ណគ់ ខាក់ៗ វន់ដាំង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដើម កាន ចាគ់ ទឹង ត្រ ណគ ជឺរ រ៉ាះ អង់គែងៗ អ៊ែ លំអាំ កាន លែក នែ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ប៉ាគ់ ពអ៊ែ ញ៉ង វ៉ើ វ៉ឹនវ៉ាយ អ៊ឺម ដើ កាន លំកើត ប្រណូវ កាន ប្រណូវ វន់ចាំ ឃឹត ប្រណូវ យ៉ាក់ មូយ តង៉ៃ ឡើ ប៊ិច កាន ឆិ ប្រយ»។ ");
INSERT INTO brb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ រៀន៖ «ញ៉ង វ៉ើ ពន់ដូះ អ៊ឺម បូវ វន់រៀន ម៉ើ យូច ហន់ណូវ គ្រែដៃ លំពន់ដូះ ប៉ាគ់ទឺ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ប៉ាគ់ វន់ពន់ដូះ មែ វ៉ើ រៀន ម៉ើ យូច គ្រែដៃ លំពន់ដូះ វែ ប៉ាគ់ អ៊ែ ទឺ ឡើយ។ វែ វន់វ៉ាវ អ្រយូច បូវ តាម ចនិះ វែ ប៉ាគ់ ង៉ាយ គ្រែដៃ លំវ៉ាវ វែ តាម ប៉ាគ់ ចនិះ វែ កឡឹ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ពយ៉ិ ឡើ ត្រ ហតៃ កយ៉ាគ់ ទឹង ម៉ាត់ បូវ ប៊ែង ហៃ ហាក់ ហតៃ អ៊ឺម ប៉្រាង ប៊ឹង ម៉ាត់ ហៃ កឡឹ? ");
INSERT INTO brb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ដើ ហៃ ដឹះ ប៉្រាង ប៊ឹង ម៉ាត់ ហៃ ហតៃ អ៊ឺម ប៉ិ ណាគ់ ហហាន ហាយ ដើ បូវ ប៊ែង ហៃ “អៃ ឡាំង អំកវ៉ាយ កយ៉ាគ់ ម៉ាត់ ហៃ”! ");
INSERT INTO brb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","បនឹះ ហពឝ៉្លា វ៉ិះ ឌិវ តៃ ពឺង អើយ! ហន់ញ៉ាក់ ប៉្រាង តើម ប៊ឹង ម៉ាត់ ហៃ កឡឹ អន់ដៃ អ៊ែ ហន់ត្រប៉ៃ ហឡាក់ ហន់ដូវ កវ៉ាយ កយ៉ាគ់ ម៉ាត់ តើម ប៊ឹង បូវ ប៊ែង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«ញ៉ង វ៉ើ អាំ អ៊ឺម រ៉ាះ ឡើ ចាគ់ ភែង យ៉ើម ដើ ច ដើម ញ៉ង វ៉ើ ពៀវ គែវ ពិច ហឹ ងឺរ ជុរ ឝ៉ាន់ ជុរ មន់ពែន ឆាន់ អ៊ែ ច មន់វឹញ ជឹ កាប់ សាក ញ៉ះ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«វន់ឡា ទឹង គ្រែដៃ អ៊ែ លំអាំ ដើ វែ វន់សាត ដាំង អ៊ែ វន់តៃ វន់ឝឝ៉ោះ កម៉ង អ៊ែ លំប៉ើក ដើ វែ ");
INSERT INTO brb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","យ៉ាក់ មែ ង៉ាយ ម៉ើ ឡា មែ អ៊ែ មន់ដូវ មែ ង៉ាយ ម៉ើ ដាំង មែ អ៊ែ មន់តៃ ដើម លំប៉ើក កម៉ង ដើ មែ ម៉ើ ឝឝ៉ោះ។ ");
INSERT INTO brb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ទឹង បូវ វែ ប៉ាគ់ កួន លំឡា ណុំពាំង ហឹ បើគ ណគ ប៊ិច អ៊ឺម ញឹះ លំអាំ តម៉។ ");
INSERT INTO brb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ប៉ាគ់ កួន លំឡា ទ្រឺ ប៊ិច អ៊ឺម ញឹះ បើគ ណគ លំអាំ កយែប។ ");
INSERT INTO brb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ទុត វែ វ៉ើ បនឹះ ចនិះ តៃ ចាគ់ ណាគ់ វ៉ើ ណោះ អាំ រ៉ាះ ចាគ់ៗ ដើ កួន វែ ហ៊ែង ហាយ ដើ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ណាគ់ ហម អ៊ែ លំអាំ រ៉ាះ ចាគ់ៗ ណគ់ ដើ មែ ម៉ើ ឡា ទឹង ណគ!»។ ");
INSERT INTO brb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«វន់ម៉ើត បូវ មន់បើម អន់ចាគ់ ដើ វែ ប៉ាគ់ ង៉ាយ វន់បើម ប៉ាគ់ ចនិះ វែ អ៊ែ ឡើយ ដើ មែ។ អ៊ែ ឡើ ត្រ ប៉ាគ់ ប្រម៉ាង ទឹង ពឹម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ដើម ទឹង ពឹម មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«វន់មឹត តៃ ឝឡោះ កដៀត យ៉ាក់ ឝឡោះ ដើម ទ្រូង ដក់ ហឹ ឞន គែត ឡើ ឌឺះ សំឞាយ ដក់ ទុត ខាក់ ប៊ិច បនឹះ ទុត អើន ម៉ើ ដក់ មឹត តៃ ឝឡោះ ឌឺះ។ ");
INSERT INTO brb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","អ៊ែ ណគ់ ឝឡោះ ដើម ទ្រូង ដក់ ហឹ ឞន ញិវ ឡើ កដៀត ញ៉ាក ដក់ តៃ ឋាំ ប៊ិច បនឹះ វ៉ិះ កើយៗ ម៉ើ ដាំង ទ្រូង ហង់អ៊ែ ម៉ើ តៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«ហឹ វន់លវាំង ដើ បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឆ្រឡិ ឆ្រលួគ ម៉ើ ដក់ ដាំង វែ ម៉ើ ពស៊ិម ពឃឺ បើម ប៉ាគ់ ចៀម កនុង អ៊ែ ចនិះ មែ ម៉ើ អរាំង មាំ ឞាល់ ច ប៊្រី។ ");
INSERT INTO brb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","វែ វន់ហង់ឝ៉ាវ ចនិះ មែ ប៊ឹង ពនឹត បណើម មែ។ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ប៉ិះ ប៉្លៃ ឈឹង ជែម តើម ប៊ឹង តើម រន់ដា លឺ មន់ប៉ិះ លវ៉ា តើម ប៊ឹង ឆមឺ លែន។ ");
INSERT INTO brb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ត្រំ តើម ឡង ចាគ់ ឡើ ប៉្លៃ ចាគ់ ត្រំ តើម ឡង តៃ ចាគ់ ឡើ ប៉្លៃ តៃ ចាគ់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ប៊ិច អ៊ឺម តើម ឡង ចាគ់ លំប៉្លៃ តៃ ចាគ់ អ៊ែ ណគ់ តើម ឡង តៃ ចាគ់ លំប៉្លៃ ចាគ់។ ");
INSERT INTO brb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ត្រំ តើម ឡង ឡើ ប៉្លៃ តៃ ចាគ់ មន់កូវ ពៀវ ហឹ អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ប៉ាគ់ អ៊ែ ទឺ ឡើយ ណគ់ បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឆ្រឡិ ឆ្រលួគ វន់ហង់ឝ៉ាវ ចនិះ មែ ប៊ឹង ពនឹត បណើម មែ»។ ");
INSERT INTO brb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ត្រ អ៊ឺម លែក ដើ មែ ម៉ើ ជុ អៃ “យ៉ាគ់ កន់ដ្រាគ់ៗ” មន់ដូវ មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ វ៉ិះ ឌិវ មែ ម៉ើ បើម ត្រួយ ប្រម៉ើត គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ ទិ មន់ដូវ មឹត។ ");
INSERT INTO brb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","តគ់ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន លំប៊ិច បនឹះ ទុត អើន មន់ជុ អៃ រៀន “អើយ យ៉ាគ់ កន់ដ្រាគ់ៗ ញ៉ើ ខើយ ឈូន ប្រម៉ាង គ្រែដៃ ទឹង ម៉ាត់ ហៃ ដើម ញ៉ើ ខើយ ឌ្រុះ អរ៉ាក់ ញ៉ើ អ៊ីង ដើ ម៉ាត់ ហៃ ដឹប ញ៉ើ ខើយ បើម កាន ឆង៉ាត់ ទុត អើន ញ៉ើ អ៊ីង ដើ ម៉ាត់ ហៃ ប៉ាគ់ទឺ”។ ");
INSERT INTO brb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ប៊ឹង អ៊ែ អៃ អំហាយ ដើ មែ រៀន “ណគ់ បូវ វ៉ើ បើម កាន តៃ ចាគ់ វន់វីះ តើម ប៊ឹង អៃ! អហង់ឝ៉ាវ អ៊ឺម វែ”»។ ");
INSERT INTO brb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«ប៉ាគ់ ពអ៊ែ លែក មែ ម៉ើ ចង់ហៀង ប្រម៉ាង អៃ នែ ដើម ម៉ើ បើម ត្រួយ មែ អ៊ែ ព្រឌីវ ប៊ឹង បឹ ប៊ិច ហ្រឡិច ហ្រឡាង ឡើ បើម ហន់ណាម ពឺង តម៉ ដដារ។ ");
INSERT INTO brb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","អ៊ែ តគ់ ឡើ អំមឺ ដាក ដណៃ ឡើ លែប កយឺវ ឡើ ពឹក ឞាល់ ង៉ាយ កតាម ប៉ុះ ហន់ណាម ហន់ណាម អ៊ែ ឡើ តលឹ អ៊ឺម យ៉ាក់ ឡើ បើម ពឺង តម៉ ដដារ។ ");
INSERT INTO brb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","អ៊ែ លែក ដើ មែ ម៉ើ ចង់ហៀង ប្រម៉ាង អៃ នែ ហាក់ ម៉ើ បើម ត្រួយ អ៊ឺម មែ អ៊ែ ព្រឌីវ ប៊ឹង បឹ តៃ ឡើ ប៊ិច ខនឹត ឡើ បើម ហន់ណាម ពឺង ផាច។ ");
INSERT INTO brb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","អ៊ែ តគ់ ឡើ អំមឺ ដាក ដណៃ ឡើ លែប កយឺវ ឡើ ពឹក ប៉ុះ ហន់ណាម អ៊ែ ហន់ណាម ឡើ តលឹ ត្រសោះ លែក តាក់ ញឹះ តៃ ណាគ់»។ ");
INSERT INTO brb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","តគ់ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង កាន លែក អ៊ែ លែវ ឡើយ មែ ប៉ាសាសុន ម៉ើ បើម ញ៉ម ទុត ខាក់ ដើ ប្រម៉ាង ណគ ឡើ ពង់ហៀន ");
INSERT INTO brb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","យ៉ាក់ ឡើ ពង់ហៀន ឡើ ប៊ិច អាតណាត ត្រ អ៊ឺម ប៉ាគ់ ដើ មែ ណាយឃូ ពង់ហៀន ចឞាប់។ ");
INSERT INTO brb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","តគ់ គ្រែដៃ យែស៊ូ ឡើ ទឺះ តើម ទិ ចន់ឌូ ប៊ិច បនឹះ ទុត អើន ម៉ើ តូយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","បអើយ ប៊ិច បឹ ស៊ិតស៊ូត មូយ រ៉ា ឡើ ដក់ កដាប ហំបះ គ្រែដៃ យែស៊ូ ឡើ ឡា ឡូម រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ ប៉ាគ់ ហន់ឌី ហៃ ឡើយ ហន់ដូវ ពនៀម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","គ្រែដៃ យែស៊ូ ឡើ ពយ៉ ជុ ទី ពឺង បឹ ស៊ិតស៊ូត ដើម ឡើ ម៉ាង រៀន៖ «ឌី ហន់នៀម»។ ហំប៊្រុះ ដើ អ៊ែ ស៊ិតស៊ូត ណគ ឡើ ប៉ាត់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","គ្រែដៃ យែស៊ូ ឡើ ថាន់ ណគ រៀន៖ «ញ៉ង ហប៉ច អ៊ឺម យ៉ឹ ដើ បូវ ហំត្រ ដក់ ពដៃ ចាក់ ហៃ ហឹ យ៉ាគ់ កឡា បប៊ុះ ថួយ ដើម ហំម៉ប អន់ណាំ ដើ គ្រែដៃ តាម ពន់ដ្រៃ យ៉ាគ់ ម៉ូស៊ែ អាំ មែ លែក រ៉ា មន់ណោះ រៀន ចាក់ ហៃ ហនៀម ចាគ់ ម៉ាត់ ម៉ាត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ទឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ ប៊ឹះ មួង កាផារនុំ ប៊ិច ណាយ តហាន រ៉ូម មូយ រ៉ា ឡើ ដក់ ហឹ ណគ ឡើ ឡា ឡូម រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«យ៉ាគ់ កន់ដ្រាគ់ អើយ ឞយ អៃ ឡើ ឈិ ទុត កយឹក តាំង ឡើ កី អង់កី ញឹះ តៃ ឡើ បក់ អំម៉ិះ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណាយ តហាន រៀន៖ «អើគ អន់ដក់ ពនៀម»។ ");
INSERT INTO brb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ណាយ តហាន ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ ឃឺ អ៊ឺម ញឹះ ឌិត ហៃ ហំមឹត ហឹ ហន់ណាម អៃ វ៉ិះ ហំម៉ាង មូយ អំម៉ាង ប៊ឹង ណិះ ឡើយ ឞយ អៃ លំនៀម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","យ៉ាក់ អៃ អគូ ក្រូម អាតណាត មែ ប៉ាគ់ទឺ ដើម អប៊ិច កួន តហាន ម៉ើ គូ ក្រូម អាតណាត អៃ ដិ។ ប៉ាគ់ អប៉្រៃ តហាន អៃ “ដក់” ឡើ ដក់ ប្រយ។ ប៉ាគ់ អប៉្រៃ តហាន អៃ “ជឹ” ឡើ ជឹ ប្រយ។ ប៊ឹង អប៉្រៃ ក៝ត អៃ បើម កាន អង់ង៉ាយ មូយ ឡើ បើម ប្រយ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","គ្រែដៃ យែស៊ូ ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ ញ៉ម ទុត ខាក់ អ៊ែ ឡើ ម៉ាង ហឹ មែ ម៉ើ តូយ ណគ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន អតៃ អ៊ឺម ទឹង បូវ មែ អ៊ីស្រាអ៊ែល មន់ចាប់ មឹង ញឹះ ឞាល់ នែ ហមយ៉ះ មូយ រ៉ា ណាគ់ តៃ អតៃ។ ");
INSERT INTO brb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","អៃ អង់ហាយ ដើ វែ រៀន លំប៊ិច បនឹះ ទុត អើន សាត មន់ប៊ឹះ តើម ប៊ឹង ម៉ាត់ តង៉ៃ ឌឹក តើម ប៊ឹង ម៉ាត់ តង៉ៃ លុច មន់ដក់ ដ្រូម ចង់ ចា អរែង ប៊ឹង យ៉ាគ់ អាប្រាហាំ យ៉ាគ់ អ៊ីសាគ់ ដើម យ៉ាគ់ យ៉ាកុប ទឹង ឞន គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","អ៊ែ ដើ មែ សុនសាត អ៊ីស្រាអ៊ែល មន់ត្រ មឹត ទឹង ឞន គ្រែដៃ ឡើ ពែក ប៉ាក់ គ្រែដៃ លំតវីះ មែ ទុត អើន ហឹ ដៀក ទឹង ហ្រង៉ូម ហឹ ឞន បនឹះ ម៉ើ ញឺម ស៊្រែក កាប់ ក្រៀម ឝលៀម ពឹង»។ ");
INSERT INTO brb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ហឹ ណាយ តហាន រៀន៖ «ហន់ជឹ ហំមិញ អាំ លំដាវ តាម ហៃ ហចាប់ មឹង!» ហំប៊្រុះ ដើ អ៊ែ ឞយ ណគ ហឹ ហន់ណាម ឡើ នៀម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ហន់ណាម យ៉ាគ់ ពែត្រុះ ឡើ តៃ ហឝ៉ៃ ម៉ិ យ៉ាគ់ ពែត្រុះ ឡើ ឝ្រុន កី ប៊ឹង ឝ្រែ។ ");
INSERT INTO brb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","គ្រែដៃ យែស៊ូ ឡើ ពឹត ប៊ឹង ទី ឝ្រុន ណគ ឡើ ប៉ាត់ ប្រយ អ៊ែ ឡើ ឌឹក អាំ ចណង់ ចណា ដើ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","តគ់ ឡើ អំប៊ឹ ម៉ើ ដក់ តៀត បនឹះ អរ៉ាក់ មឹត ទុត អើន ហឹ គ្រែដៃ យែស៊ូ អ៊ែ ឡើ ពន់ឌ្រុះ អរ៉ាក់ ឝ៉ាន់ ឡើ ម៉ាង ដើម ឡើ ពនៀម មែ ម៉ើ ឈិ ម៉ើ នៀម ត្រំ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ឡើ បើម ប៉ាគ់ អ៊ែ អាំ លំដាវ ប៉ាគ់ ប្រម៉ាង យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ រៀន៖ «ណគ លំញ៉ាក់ តាក់ កាន ហអូវ ឈិ តើម ប៊ឹង ង៉ាយ ដើម ឡើ ញ៉ាក់ តាក់ កាន ឆនិ អន់តុ ង៉ាយ ដិ ឡើ ជុ ហឹ ណគ អន់ណាវ »។ ");
INSERT INTO brb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","តគ់ គ្រែដៃ យែស៊ូ ឡើ តៃ មែ ប៉ាសាសុន ទុត អើន ម៉ើ ឝ៉ូមឝែវ ឈុំ ណគ អ៊ែ ឡើ ច្រា មែ លុកស៊ិក ណគ ទឺះ ឈិះ ឌូក មន់ក្លង សមុត តៃ តគ់។ ");
INSERT INTO brb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ទឹង ប៉ះ ម៉ើ ទឺះ ឈិះ ឌូក ប៊ិច ណាយឃូ ពង់ហៀន ចឞាប់ មូយ រ៉ា ឡើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «អើយ យ៉ាគ់ ណាយឃូ អៃ អន់ដក់ តូយ ហៃ សំយ៉ះ ហន់ដក់ ហឹ ង៉ាយ តមឹង ណាគ់ អន់តូយ ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «កស៊ិរ ម៉ើ ប៊ិច ត្រម ជែម ប៊្រែម ម៉ើ ប៊ិច កសូម អ៊ែ ណគ់ ដើ កួន បនឹះ អន់ណាវ ឡើ ប៊ិច អ៊ឺម ឞន កណី កនូ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ប៊ិច លុកស៊ិក ណគ មូយ រ៉ា អន់ណាវ ឡើ ឡា ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ អឡា ហឹ ហៃ អន់ជឹ ចាំ បើគ អៃ លំគែត អន់ចះ កុប ណគ អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «ហន់ដក់ តូយ អៃ តាក់ ដើ មែ ម៉ើ គែត តៃ ផវ យ៉ាង មន់ចះ កុប បនឹះ គែត»។ ");
INSERT INTO brb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","គ្រែដៃ យែស៊ូ ឡើ ទឺះ ឈិះ ឌូក អ៊ែ បូវ លុកស៊ិក ណគ ម៉ើ តូយ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ទឹង ម៉ើ ឈិះ ឌូក ហំប៊្រុះ ដើ អ៊ែ ឡើ ប៊ិច កយឺវ ទិះ ឡើ ពឹក ដាក សមុត ទុត ថាំង អ៊ែ ដាក ឡើ ផង មឹត ទឹង ឌូក មែ ទុត ម៉ៃ។ ណគ់ ដើ គ្រែដៃ យែស៊ូ អន់ណាវ ឡើ ហង់ង៉ាន់ តៀក។ ");
INSERT INTO brb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","បូវ លុកស៊ិក ម៉ើ ដក់ ពរ៉ៃ ណគ រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ឡា ហំប៉ូរ ញ៉ា អុះ ងំគែត ឡើយ ង៉ាយ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «បនឹះ តៃ ហ៊ែត ចាប់ មឹង អើយ ប៉ិ ឡើ ត្រ វ៉ើ ឌូង ញឹះ ឞាល់ នែ?» អ៊ែ ឡើ ឌឹក ឆុង ឡើ ម៉ាង ក្រាគ់ ដើ កយឺវ ដើម ដាក សមុត ហំប៊្រុះ ដើ អ៊ែ កយឺវ ដើម ដាក ឡើ ព្រឹង ហ្រហៀង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","មែ លុកស៊ិក តូវ ម៉ើ ញ៉ម ទុត ខាក់ អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «មែ ង៉ាយ ឋូវ យ៉ាគ់ អន់នែ ទុត កយឺវ ដើម ដាក សមុត ណាគ់ ម៉ើ ចង់ហៀង ម៉ាង ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ដើម មែ លុកស៊ិក ណគ ម៉ើ ប៊ឹះ ពឹះ តៃ តគ់ ស្រុក ឝែរ៉ាស៊ីន  ប៊ិច កឡ បារ រ៉ា អរ៉ាក់ មឹត អំប្រា ញឺះ តើម ប៊ឹង ត្រម ច្រាង ម៉ើ ជុ កយ៉ក់ អំប្រា ដក់ ហឹ គ្រែដៃ យែស៊ូ។ អំប្រា អរាំង ទុត ខាក់ ញឹះ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ហាន ដក់ តៃ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","អ៊ែ អំប្រា ហរ៉ាវ ម៉ាង ថាំងៗ រៀន៖ «កួន កឡ គ្រែដៃ អើយ ប៉ាគ់ ង៉ាយ ហងុញ បើម ដើ ញឺ? ហដក់ តំឞាប ញឺ អន់នួរ លំប៊ឹះ ខណាត ឡះ?» ");
INSERT INTO brb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ង៉ាយ ចង៉ាយ ដៀក អ៊ែ ប៊ិច ជុរ មូយ បូវ ទុត អើន ម៉ើ ចជឹក។ ");
INSERT INTO brb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","បូវ អរ៉ាក់ ម៉ើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «ប៉ាគ់ ហំពន់ឌ្រុះ ញ៉ា ហង់អាំ ញំមឹត ហឹ បូវ ជុរ តគ់»។ ");
INSERT INTO brb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ អរ៉ាក់ រៀន៖ «វន់វីះ ដ្រិះ!» ហំប៊្រុះ ដើ អ៊ែ អរ៉ាក់ ម៉ើ ញឺះ ប្រយ តើម ប៊ឹង អំប្រា ម៉ើ ដក់ មឹត ហឹ ជុរ។ អ៊ែ លែក ដើ ជុរ ម៉ើ អ្រយ៉ាវ តៃ ក្រជែង សាង គ្លីះ ទិ ដាក សមុត ម៉ើ ឡូប គែត លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","មែ កឡា ពែក ជុរ ម៉ើ ជឹ អ្រយ៉ាវ ពហាយ ដើ មែ ទឹង មួង លែក ដើ កាន ឡើ កើត ដើម កាន អំប្រា កឡ អរ៉ាក់ មឹត។ ");
INSERT INTO brb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","អ៊ែ លែក ដើ មែ ទឹង មួង ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ តគ់ ម៉ើ តៃ ណគ ម៉ើ ឡា ឡូម ហឹ ណគ ម៉ើ ប៉្រៃ លំវីះ តើម ប៊ឹង ប៊្រី ដាក មែ។ ");
INSERT INTO brb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ទឺះ ឈិះ ឌូក ក្លង សមុត ជឹ ហឹ មួង កាផារនុំ មួង ណគ ឡើ ខើយ គូ។ ");
INSERT INTO brb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ប៊ឹង អ៊ែ ឡើ ប៊ិច មែ ម៉ើ ទូង បឹ ឡើ កុង ឈឹង ប៊ឹង កយែង ម៉ើ តៀត ហឹ គ្រែដៃ យែស៊ូ។ គ្រែដៃ យែស៊ូ ឡើ តៃ ម៉ើ ចាប់ មឹង ណគ ឞាល់ អ៊ែ ឡើ ម៉ាង ដើ បឹ កុង ឈឹង អ៊ែ រៀន៖ «អើយ ម៉ន ហន់ញឹម ក្លើម ហំមិញ អតាក់ ឡើយ ឞាប ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","បូវ ណាយឃូ ពង់ហៀន ចឞាប់ អន់នឺ រ៉ា ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ ឃឹត ទឹង ចនិះ រៀន៖ «បឹ អន់នែ ឡើ ផម៉ាត់ គ្រែដៃ ឡើយ!» ");
INSERT INTO brb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","គ្រែដៃ យែស៊ូ ឡើ ណោះ ខនឹត មែ អ៊ែ ឡើ ម៉ាង រៀន៖ «ពយ៉ិ ឡើ ត្រ វ៉ើ ប៊ិច ខនឹត តៃ ចាគ់ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ប៉ាគ់ អំបើម អន់នៀម បឹ កុង ឈឹង នែ អំប៉្រៃ ណគ លំឌឹក អន់ឆូវ អ៊ែ វន់ណោះ ហង់ឝ៉ាវ រៀន អៃ អប៊ិច អាតណាត តើម ទិ គ្រែដៃ ដើម អដូវ តាក់ ឞាប ដើ បនឹះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ហាក់ អងុញ អាំ វន់ណោះ រៀន កួន បនឹះ ឡើ ប៊ិច អាតណាត ដូវ តាក់ ឞាប ដើ បនឹះ ទិ ឡាង ប្រិះ នែ»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ បឹ កុង ឈឹង រៀន៖ «មិញ ហន់ឌឹក ឆុង ជឹ តៀត កយែង ហៃ ហឹ ហន់ណាម!» ");
INSERT INTO brb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","បឹ កុង ឈឹង អ៊ែ ឡើ ឌឹក ជឹ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ហំប៊្រុះ មែ ប៉ាសាសុន ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ ឌូង ដើម ម៉ើ ព្រតឹះ ព្រនែ គ្រែដៃ ឡើ អាំ អាតណាត ឆង៉ាត់ ឞាល់ នែ ដើ បនឹះ។ ");
INSERT INTO brb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","តគ់ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ងឺរ ឞិត ឞ៊ែត ឡើ តៃ បឹ មូយ រ៉ា ម៉ាត់ ណគ ម៉ាថាយ ឡើ ដ្រូម កាគ់ លៀន ប៊ឹង ហន់ណាម បណើម កាន ឡើ ច្រា ណគ រៀន៖ «ដក់ ហន់តូយ អៃ!» អ៊ែ ឡើ ឌឹក តូយ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ប្ល៊ី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ចង់ ចា ហឹ ហន់ណាម យ៉ាគ់ ម៉ាថាយ។ ប៊ិច មែ កាគ់ លៀន ដឹប បនឹះ ប៊ិច ឞាប ទុត អើន ម៉ើ មឹត ចង់ ចា អរែង ប៊ឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","បូវ មែ ផារីស៊ី ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ ម៉ាង ដើ លុកស៊ិក ណគ រៀន៖ «ប៉ិ ឡើ ត្រ ណាយឃូ វែ ឡើ ចង់ ចា អរែង ប៊ឹង មែ កាគ់ លៀន ដឹប ប៊ឹង មែ ប៊ិច ឞាប ប៉ាគ់ នែ?» ");
INSERT INTO brb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","គ្រែដៃ យែស៊ូ ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ ម៉ាង រៀន៖ «បនឹះ តៃ ឈិ ម៉ើ តងកាន អ៊ឺម ពែត វ៉ិះ ឌិវ មែ ម៉ើ ឈិ ម៉ើ តងកាន ពែត។ ");
INSERT INTO brb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","វន់ឃឹត ឡាំង ហឹ ប្រម៉ាង យ៉ាគ់ ហូស៊ែ ឡើ ខៀន ជុ រៀន “អងុញ បនឹះ មន់ណោះ ស្រុស្រៀត ត្រឌីវ មែ អងុញ អ៊ឺម បណាន់ បប៊ុះ ថួយ ”។ អដក់ ដាំង អ៊ឺម បនឹះ ចាគ់ ទឹង ត្រ អដក់ ដាំង បនឹះ ប៊ិច ឞាប ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ប៊ឹង អ៊ែ លុកស៊ិក យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ម៉ើ ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ដើ ញ៉ា ដើម បូវ មែ ផារីស៊ី ញ៉ើ អឹត ចណង់ ចណា ខរ៉ុប គ្រែដៃ ឆិញៗ ប៉ិ ឡើ ត្រ ដើ លុកស៊ិក ហៃ ម៉ើ អឹត អ៊ឺម ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «តង៉ៃ ម៉ើ ច្រណង់ ទឹង បឹ កឡា ឡើ ចក់ ទ្រី ណាគ់ ប៊ឹង អ៊ែ ឃឺ ឞិ មែ ម៉ើ ផូវ មន់ឝ្រង៉ឹត ស្រូក? តគ់ តង៉ៃ មន់រ៉ាប់ បឹ កឡា ចក់ ទ្រី តើម ប៊ឹង មែ តង៉ៃ អ៊ែ ឡើយ មន់អឹត ចណង់ ចណា។ ");
INSERT INTO brb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ចក់ ក្រដាគ់ ហន់ដើម មន់ឈិង កដាគ់ ប៊ឹង អាវ ក្រាគ់។ ប៉ាគ់ មន់បើម ប៉ាគ់ អ៊ែ ក្រដាគ់ ហន់ដើម លំក្រស៊ឹន អ៊ែ លំបើម អាំ អាវ ក្រាគ់ លំព្រញាំង ត្រសាក ជឺរ ពន់ឋើម អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ដើម តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ជុ តវែ ឈឹង ជែម ហន់ដើម ទឹង ក្រឌុង ហំបក ក្រាគ់ ប៉ាគ់ មន់បើម ប៉ាគ់ អ៊ែ ក្រឌុង ហំបក ក្រាគ់ លំចឋះ តវែ លំលូះ ដើម ក្រឌុង នែ លំប៉ិន យ៉ាវ។ ឡើ ត្រ មន់ជុ តវែ ហន់ដើម ទឹង ក្រឌុង ហន់ដើម ប៉ាគ់ទឺ អ៊ែ តវែ ដើម ក្រឌុង ហំបក ណាគ់ លំណាគ់»។ ");
INSERT INTO brb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","គ្រែដៃ យែស៊ូ ទឹង ប៉ះ ឡើ ពង់ហៀន កាន នែ ដើ មែ ហំប៊្រុះ ដើ អ៊ែ ប៊ិច យ៉ាគ់ ទិះ ក្រាគ់ រ៉ូង ពស៊ុំ ឡើ ដក់ កដាប ហំបះ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «កួន កទ្រី អៃ ឡើ តាត់ សើម ហន់ដើម អិះៗ ឡា ហន់ដក់ ជុ ទី ប៊ឹង ណគ អុះ អ៊ែ លំញិវ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","គ្រែដៃ យែស៊ូ ឡើ ឌឹក ជឹ តូយ ប្រយ ណគ មែ លុកស៊ិក ម៉ើ តូយ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ទឹង ម៉ើ ដក់ ប៊ិច កទ្រី មូយ រ៉ា ឡើ ពន់ឆិច ញឹះ ជិត បារ កម៉ ឡើយ ឡើ ដក់ តៃ ត្រិច គ្រែដៃ យែស៊ូ ឡើ ពឹត ក្រប៊ុយ អាវ។ ");
INSERT INTO brb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «ប៉ាគ់ អន់ដូវ ពឹត វ៉ិះ ឌិវ អាវ ណគ អន់នៀម ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឡើ តៃ ណាង ឡើ ហាយ រៀន៖ «អើយ ណាង ញ៉ង ហឌូង អ៊ឺម យ៉ាក់ ហមឹង អៃ ហន់នៀម ឡើយ»។ ហំប៊្រុះ ដើ អ៊ែ ឡើ នៀម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តគ់ ហន់ណាម យ៉ាគ់ ទិះ ក្រាគ់ អ៊ែ ឡើ តៃ មែ ក្លាង ស៊្រុក ឈឹង ហឈឹង ភូះ ចំភូះ ដើម ប៊ិច បូវ ម៉ើ ខូម បហវ ផូវ កយ៉ក់  អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«វន់វីះ ណាង នែ ឡើ គែត អ៊ឺម វ៉ិះ ឡើ ហង់ង៉ាន់ តៀក»។ អ៊ែ ម៉ើ ចអាវ តវ៉ក តវ៉ិច ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","តគ់ ឡើ តវីះ មែ ឡើយ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ មឹត ហឹ កនុង ឡើ រ៉ាប់ ប៊ឹង ទី ណាំង ឡើ គែត ហំប៊្រុះ ដើ អ៊ែ ឡើ ញិវ ឌឹក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","កាន នែ ឡើ លឺ បុ ស្រុក ទឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","តគ់ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ប៊ិច កឡ សូត ម៉ាត់ បារ រ៉ា អំប្រា ឆ្រួយ ណគ ដក់ ប៉ាគ់ កឡូវ ណគ ថាំងៗ រៀន៖ «ឡា កន់ស៊ែ យូ សឋិច ដាវីត អើយ ហំស្រុស្រៀត ញឺ អុះ!» ");
INSERT INTO brb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","តគ់ គ្រែដៃ យែស៊ូ ឡើ មឹត ហឹ ហន់ណាម ឡើយ អំប្រា សូត ម៉ាត់ នែ អំប្រា ដក់ តគ់ ណគ គ្រែដៃ យែស៊ូ ឡើ តង៉ា អំប្រា រៀន៖ «ណាគ់ សប្រា ចាប់ មឹង ឡះ អៃ អន់ដូវ ពនៀម ម៉ាត់ សប្រា?» អំប្រា ត្រណើវ រៀន៖ «អ៊ឺគ យ៉ាគ់ កន់ដ្រាគ់»។ ");
INSERT INTO brb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","គ្រែដៃ យែស៊ូ ឡើ ពឹត ប៊ឹង ម៉ាត់ អំប្រា ឡើ ម៉ាង រៀន៖ «អាំ លំដាវ ប៉ាគ់ សប្រា មឹង អៃ អិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ម៉ាត់ អំប្រា ឡើ ត្រប៉ៃ ប្រយ អ៊ែ ឡើ ថាន់ ទុត ខាក់ រៀន៖ «ញ៉ង សប្រា ពហាយ អ៊ឺម យ៉ឹ កាន នែ ដើ បូវ!» ");
INSERT INTO brb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ហំប៊្រុះ អំប្រា វីះ ហ៊ែង អំប្រា ហាយ កាន គ្រែដៃ យែស៊ូ ដើ បូវ បុ ស្រុក ទឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ប្ល៊ី អំប្រា វីះ ប៊ិច ម៉ើ តៀត បឹ មូយ រ៉ា ហឹ គ្រែដៃ យែស៊ូ បឹ អន់នែ អរ៉ាក់ កំប្ល ឡើ មឹត ទឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ពន់ឌ្រុះ អរ៉ាក់ អ៊ែ បឹ កំប្ល ឡើ ណោះ ម៉ាង ប្រយ។ មែ ប៉ាសាសុន តូវ ម៉ើ ញ៉ម ទុត ខាក់ ដើម ម៉ើ ម៉ាង រៀន៖ «ទឹង ស្រុក អ៊ីស្រាអ៊ែល ង៉ើ ខើយ អ៊ឺម តៃ កាន ឆង៉ាត់ ឞាល់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ហាក់ បូវ មែ ផារីស៊ី ម៉ើ ម៉ាង រៀន៖ «ឡើ ដូវ ពន់ឌ្រុះ អរ៉ាក់ យ៉ាក់ ណាយ អរ៉ាក់ ឡើ អាំ អាតណាត ដើ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ បុ ដើ មួង ដើម តាម ស៊្រុក មូយៗ ឡើ ពង់ហៀន មែ ទឹង រ៉ូង ពស៊ុំ ដើម ឡើ ពហាយ កាន ចាគ់ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដើម ឡើ ពនៀម ឆនិ មែ ត្រំ ហំឞ្លិច។ ");
INSERT INTO brb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ តៃ មែ ប៉ាសាសុន ឡើ ស្រុស្រៀត ទុត ខាក់ យ៉ាក់ តៃ ម៉ើ ប៊ិច ឞន មឹង ម៉ើ គូ អ្រម៉ឹ អ្រម៉ើយ ប៉ាគ់ ចៀម តៃ ប៊ិច កន់ដ្រាគ់ ពែក។ ");
INSERT INTO brb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «ចិះ ឡើ ឌុំ ទុត ឌឺះ ហាក់ មែ ម៉ើ កៀវ កើយៗ។ ");
INSERT INTO brb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ប៉ាគ់ ពអ៊ែ វន់ឡា ហឹ កន់ដ្រាគ់ ណា លំដាំង ពអើន មែ គូលី មន់ដក់ កៀវ ចិះ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","គ្រែដៃ យែស៊ូ ឡើ កឡូវ លុកស៊ិក លែក ជិត បារ រ៉ា ដក់ តមួត ហឹ ណគ ឡើ អាំ អាតណាត ពន់ឌ្រុះ អរ៉ាក់ ដើ មែ ដើម អាតណាត ពនៀម ឆនិ ត្រំ ហំឞ្លិច។ ");
INSERT INTO brb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","បូវ ពចាំ កាន ណគ ជិត បារ រ៉ា នែ ម៉ាត់ មែ ប៉ាគ់ នែ៖ ទី មូយ យ៉ាគ់ ស៊ីម៉ូន ម៉ើ ជុ ពែត្រុះ ដិ អំប្រា អោះ ណគ អន់ឌ្រែ ដើម យ៉ាកុប អំប្រា អោះ ណគ យ៉ូហាន អំប្រា នែ កួន យ៉ាគ់ ស៊ែប៊ែឌែ ");
INSERT INTO brb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ភីលីប បារថូឡូមែ ថូម៉ះ ម៉ាថាយ ឡើ កឡា កាគ់ លៀន យ៉ាកុប កួន យ៉ាគ់ អាល់ផាយ ថាឌែ ");
INSERT INTO brb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ស៊ីម៉ូន បូវ មែ កានែន  ដើម យូដះ អ៊ីសការីយ៉ុត បឹ ឡើ ខិច គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ កឡា ពហាយ លែក ជិត បារ រ៉ា នែ ដក់ តាម ស៊្រុក មូយៗ ឡើ ថាន់ រៀន៖ «ញ៉ង វ៉ើ ដក់ អ៊ឺម យ៉ឹ ហឹ សាត មែ គែង ដើម ហឹ ស៊្រុក មែ សុនសាត សាម៉ារី ");
INSERT INTO brb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","វន់ត្រ ដក់ ដាំង សុនសាត អ៊ីស្រាអ៊ែល ណគ់ ម៉ើ បើម ប៉ាគ់ ចៀម ហវ៉ារ់ ម៉ើ ចង៉ាយ តើម ប៊ឹង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","តគ់ វន់ដក់ វន់ពហាយ រៀន “កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដៀប លំប៊ឹះ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ដើម វន់ពនៀម មែ ម៉ើ ឈិ វន់ពញិវ បនឹះ គែត វន់ពនៀម មែ ស៊ិតស៊ូត ដើម វន់ពន់ឌ្រុះ អរ៉ាក់ អាំ វីះ តើម ប៊ឹង បនឹះ។ អាតណាត ឆង៉ាត់ អអាំ មិៗ ដើ វែ វន់ត្រ ប៉ូរ មែ មិៗ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ញ៉ង វ៉ើ តៀត អ៊ឺម លៀន កាក់ ប៉្រាក់ ឆៀង ប៊ឹង ចាក់។ ");
INSERT INTO brb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ដើម ញ៉ង វ៉ើ តៀត ក្រឌុង ប្រណាក់ វ៉ិះ ឌិវ អាវ កើប ប៊ឹង ចាក់ អិះ ឡើយ ដើម តងអន់ណើង ញ៉ង វ៉ើ តៀត យ៉ាក់ ណគ់ មែ ម៉ើ បើម កាន មែ អ៊ែ មន់ត្រ ដូវ ចណង់ ចណា»។ ");
INSERT INTO brb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«ប៊ឹង វន់មឹត ស៊្រុក លឺ មួង មែ ង៉ាយ កតាម វន់ដាំង តង៉ា ណគ់ មែ ង៉ាយ មន់ឌី ឡាប់ វែ វន់គូ ទឹង ហន់ណាម មែ អ៊ែ ឡើយ ឆា ដើ វន់វីះ។ ");
INSERT INTO brb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ប៊ឹង វន់មឹត ទឹង ហន់ណាម មែ ង៉ាយ កតាម វន់តង៉ា ឡា ប្រាយ អាំ កាន ឆនឹម ហន់ណាំង ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ប៉ាគ់ មែ ទឹង ហន់ណាម មន់ឡាប់ វែ អ៊ែ មន់ដូវ កាន ឆនឹម ហន់ណាំង។ ប៉ាគ់ តៃ មន់ឡាប់ វែ អ៊ែ កាន ឆនឹម ហន់ណាំង លំវឹញ ហឹ វែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ប៉ាគ់ តៃ ប៊ិច មែ ង៉ាយ មន់ឌី ឡាប់ វែ ដើម តៃ មន់ឌី ចង់ហៀង ម៉ាង វែ វន់វីះ តើម ប៊ឹង ហន់ណាម ហង់អ៊ែ លឺ តើម ប៊ឹង មួង ហង់អ៊ែ វន់ក្រប៉ូះ ភុកភុយ ប៊ឹង ឈឹង វែ ដិ ។ ");
INSERT INTO brb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន តគ់ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន បនឹះ លំពថូត មួង ហង់អ៊ែ កយឹក ជឺរ មែ មួង សូដំ មួង ឝ៉ូម៉ូរ៉ា អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«អៃ អប៉្រៃ វែ វន់ដក់ ហឹ មែ វ៉ើ បើម ប៉ាគ់ ចៀម មឹត ទឹង បូវ ច ប៊្រី។ ប៉ាគ់ ពអ៊ែ វែ វន់ត្រ លវាំង ចាក់ ប៉ាគ់ ប៊ិះ ដើម វន់ប៊ិច ចនិះ ស៊ិម ប៉ាគ់ កំប៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","វន់លវាំង យ៉ឹ ដើ បនឹះ យ៉ាក់ មែ មន់រ៉ាប់ តៀត វែ ហឹ ទី មែ តង់កង់ ក្រាគ់ តាត់ កឍី មន់បឹត ដើ ឆមឺ ប្រាត់ ទឹង រ៉ូង ពស៊ុំ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","មន់តៀត វែ ហឹ មែ ទិះ ក្រាគ់ ពែក ប៉ាក់ ដើម ហឹ មែ សឋិច មន់តាត់ស៊ិន ញ៉ន ដើ វ៉ើ តូយ អៃ។ កាន នែ លំបើម អាំ វែ វន់ប៊ិច ទ្រូង ពហាយ កាន គ្រែដៃ ដើ មែ ដើម ដើ សុនសាត គែង ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ប៊ឹង មន់តៀត ឈូន វែ ហឹ ទី មែ ញ៉ង វ៉ើ ច្រៃ ឌូង អ៊ឺម ដើ កាន វន់ត្រណើវ លឺ វន់ម៉ាង ប៉ាគ់ ង៉ាយ យ៉ាក់ វន់ត្រណើវ តាម ប្រម៉ាង គ្រែដៃ លំអាំ ដើ វែ ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ត្រ អ៊ឺម វែ វន់ម៉ាង ផវ យ៉ាង គ្រែដៃ បើគ វែ លំម៉ាង តាម លញ៉ាគ់ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«ត អំម៉ោះ អោះ កឡឹ មន់តៀត ហឹ ទី មែ ប៉្រៃ មន់កជែត បើគ លំតៀត កួន កឡឹ ហឹ ទី មែ មន់កជែត អ៊ែ កួន មន់ដ្រម៉ា ដើ មែគ បើគ កឡឹ ដើម មន់តៀត ហឹ ទី មែ មន់កជែត ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","លែក ដើ បនឹះ ញឹះ តៃ មន់រែម ឡាំងៗ ដើ វែ ញ៉ន ដើ វ៉ើ តូយ អៃ។ ហាក់ ណគ់ មែ ង៉ាយ មន់បក់ អុតថុន ឆា ដើ ឡូច មែ អ៊ែ ឡើយ គ្រែដៃ លំហវ៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ទឹង មន់តំឞាប វែ ហឹ មួង អង់ង៉ាយ មូយ វន់វីះ ព្រដិច ដក់ ដាំង មួង ហឹ គែង អន់ណាវ។ ដាវ ម៉ាត់ ម៉ាត អៃ អំហាយ ដើ វែ រៀន កួន បនឹះ លំប៊ឹះ អន់នួរ វែ វន់ដក់ ត្រំ មួង ទឹង ស្រុក អ៊ីស្រាអ៊ែល»។ ");
INSERT INTO brb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«ប៊ិច អ៊ឺម លុកស៊ិក ម៉ើ ប៊ិច ថណាគ់ ជឺរ ណាយឃូ លឺ ក៝ត ម៉ើ ប៊ិច ថណាគ់ ជឺរ កន់ដ្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ប៉ាគ់ មែ លុកស៊ិក មន់ឈែវ ថណាគ់ ប៊ឹង ណាយឃូ អ៊ែ ណគ់ ក៝ត មន់ឈែវ ប៊ឹង កន់ដ្រាគ់ ឆិ ឡើយ ឌិវ អ៊ែ។ ញ៉ន ម៉ើ ជុ កន់ដ្រាគ់ ហន់ណាម “ប៊ែលស៊ែប៊ូល” ឡើ ណាយ អរ៉ាក់ មន់ជុ ណគ់ មែ ទឹង ក្រាន ណគ ហ៊ែង តៃ លំចាគ់ ជឺរ អ៊ែ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ញ៉ង វ៉ើ ឌូង អ៊ឺម ដើ មែ យ៉ាក់ គ្រែដៃ លំពហាយ ពដៃ លែក ដើ កាន ឡើ វៀក ដក ដើម លំពហាយ ពណោះ លែក ដើ កាន បនឹះ ម៉ើ អំម៉គ់។ ");
INSERT INTO brb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ណគ់ អង់ង៉ាយ អៃ អហាយ ដើ វែ វៀកៗ វន់ពហាយ អាំ បនឹះ មន់ដុង អ៊ែ ណគ់ កាន អង់ង៉ាយ អព្រជែះ ប៊ឹង ត្រពិត វែ វន់កឡះ ហូ តើម ទិ បូយ ហន់ណាម យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ញ៉ង វ៉ើ ឌូង អ៊ឺម ដើ មែ ណគ់ ម៉ើ ដូវ កជែត ឌិវ ចាក់ ដៃ ហាក់ ផវ ប្រលឹង ម៉ើ ដូវ អ៊ឺម កជែត វន់ត្រ ឌូង ដើ គ្រែដៃ ឡើ ដូវ ថំឡាយ កជែត ចាក់ ដៃ ដឹប ផវ ប្រលឹង កលីះ ទិ ហួម អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","វ៉ើ ណោះ ឡើយ ម៉ើ ខើយ ហំពួត ជែម ប្រាល បារ អំប៉ម ច្រណាប់ មូយ កាក់។ សំយ៉ះ ឡើ ចម កតាម ប៊ិច អ៊ឺម ជែម ប្រាល មូយ អំប៉ម ញឹះ លំគែត ប៉ាគ់ គ្រែដៃ បើគ វែ តៃ លំអាំ។ ");
INSERT INTO brb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ទុត សក់ ទឹង ទូះ វែ គ្រែដៃ ឡើ កាវ ណាគ់ លែក។ ");
INSERT INTO brb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ប៉ាគ់ ពអ៊ែ ញ៉ង វ៉ើ ឌូង អ៊ឺម យ៉ាក់ វ៉ើ ច្រណាប់ ជឺរ ជែម ប្រាល ប៉ិន បូវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«ត្រំ មែ ង៉ាយ ម៉ើ ហាន ហាយ ចាក់ ម៉ើ ចាប់ មឹង អៃ ប៊ឹង ងឺរ បូវ អៃ អន់ហាយ ប៉ាគ់ទឺ ប៊ឹង ងឺរ គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ ទិ មែ អ៊ែ ម៉ើ បូវ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ កាះ តាក់ អៃ ប៊ឹង ងឺរ បូវ អៃ អង់កាះ តាក់ ប៉ាគ់ទឺ មែ អ៊ែ ប៊ឹង ងឺរ គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ ទិ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«ញ៉ង វ៉ើ ឃឹត អ៊ឺម រៀន អៃ អប៊ឹះ ទិ នែ អាំ បនឹះ ទិ ឡាង ប្រិះ មន់ហំពែម រែម ត្រឌីវ បូវ អប៊ឹះ ទិ នែ អាំ បនឹះ មន់ត្រក្លះ ត្រក្លាយ ត្រឌីវ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","អប៊ឹះ ទិ នែ អាំ កួន កឡ លំត្រក្លះ តើម ប៊ឹង បើគ កួន កទ្រី លំត្រក្លះ តើម ប៊ឹង មែគ កម៉ាន់ លំត្រក្លះ តើម ប៊ឹង ហឝ៉ៃ ម៉ិ។ ");
INSERT INTO brb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","មែ ទឹង ក្រាន មន់ដ្រម៉ា ត្រឌីវ មែ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«មែ ង៉ាយ ម៉ើ ម៉ើត មែគ បើគ ជឺរ ម៉ើ ម៉ើត អៃ មែ អ៊ែ ឃឺ អ៊ឺម មន់លុកស៊ិក អៃ។ មែ ង៉ាយ ម៉ើ ម៉ើត កួន កឡ កួន កទ្រី ជឺរ ម៉ើ ម៉ើត អៃ មែ អ៊ែ ឃឺ អ៊ឺម ប៉ាគ់ទឺ មន់លុកស៊ិក អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","មែ ង៉ាយ តៃ ម៉ើ កួយ ឡង អង់ឝ៉ាង កឡឹ ដើម តៃ ម៉ើ ដក់ តូយ អៃ មែ អ៊ែ ឃឺ អ៊ឺម ប៉ាគ់ទឺ មន់លុកស៊ិក អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","មែ ង៉ាយ ម៉ើ ខំ ដាំង កាន ញិវ មែ អ៊ែ មន់គែត ប៉ាត់ ពណាត់ អ៊ែ ណគ់ មែ ង៉ាយ មន់គែត ញ៉ន ម៉ើ តូយ អៃ មែ អ៊ែ ឡើយ មន់ញិវ»។ ");
INSERT INTO brb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«មែ ង៉ាយ ម៉ើ ឡាប់ វែ មែ អ៊ែ ម៉ើ ឡាប់ អៃ ឡើយ មែ ង៉ាយ ម៉ើ ឡាប់ អៃ មែ អ៊ែ ម៉ើ ឡាប់ កឡា ឡើ ប៉្រៃ អៃ អប៊ឹះ។ ");
INSERT INTO brb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","មែ ង៉ាយ ម៉ើ ឡាប់ឡង កឡា ឈូន ប្រម៉ាង គ្រែដៃ មូយ រ៉ា យ៉ាក់ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ មែ អ៊ែ ឡើយ គ្រែដៃ លំអាំ តង់ហវ ឈែវ ប៊ឹង កឡា ឈូន ប្រម៉ាង គ្រែដៃ ទឺ។ មែ ង៉ាយ ម៉ើ ឡាប់ឡង បនឹះ ចាគ់ ទឹង ត្រ មូយ រ៉ា យ៉ាក់ ឡើ បនឹះ ចាគ់ ទឹង ត្រ មែ អ៊ែ គ្រែដៃ លំអាំ តង់ហវ ឈែវ ប៊ឹង បនឹះ ចាគ់ ទឹង ត្រ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","មែ ង៉ាយ ម៉ើ អាំ ដាក ដើ បនឹះ តៃ ក្រឡាវ បាត់ មូយ រ៉ា យ៉ាក់ ឡើ លុកស៊ិក អៃ ដាវ ម៉ាត់ ម៉ាត អៃ អំហាយ ដើ វែ រៀន មែ អ៊ែ គ្រែដៃ លំអាំ តង់ហវ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","គ្រែដៃ យែស៊ូ ឡើ ថាន់ថយ លុកស៊ិក ណគ លែក ជិត បារ រ៉ា លែវ ឡើយ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ពង់ហៀន ដើម ឡើ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ទឹង ស៊្រុក ឈុំ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ទឹង អ៊ែ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ គូ ឃុក ឡើ ដុង កាន គ្រែដៃ គ្រិះ ឡើ បើម។ អ៊ែ ឡើ ប៉្រៃ លុកស៊ិក ណគ មន់ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«ហៃ នែ ឡើយ ឡះ ណគ់ គ្រែដៃ ឡើ ខណាត ហំប៊ឹះ លឺ ណាគ់ ញន់ចាំ បឹ អង់គែង អន់ណាវ?» ");
INSERT INTO brb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ រៀន៖ «វន់ជឹ ហាយ ដើ យ៉ាគ់ យ៉ូហាន ណគ់ កាន វែ វ៉ើ ដុង ដើម កាន វែ វ៉ើ តៃ នែ៖ ");
INSERT INTO brb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","បនឹះ សូត ម៉ើ ត្រប៉ៃ បនឹះ គែត ឈឹង ទី ម៉ើ បក់ ដក់ បនឹះ ស៊ិតស៊ូត ម៉ើ នៀម មែ ម៉ើ ទុង ម៉ើ ប្រឡុះ បនឹះ គែត ម៉ើ ញិវ ឡឹះ អ៊ែ ណគ់ បនឹះ ម៉ូវ ម៉ក ម៉ើ ដុង កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","មែ ង៉ាយ តៃ ម៉ើ តាក់ ចាប់ មឹង អៃ មែ អ៊ែ ឡើយ មន់ហ្រនុក ហ្រវ៉ាក»។ ");
INSERT INTO brb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ហំប៊្រុះ លុកស៊ិក យ៉ាគ់ យ៉ូហាន ម៉ើ ជឹ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ ប៉ាសាសុន កាន យ៉ាគ់ យ៉ូហាន ឡើ រៀន៖ «ពន់ឋើម វ៉ើ ដក់ ឝ្លាំង អង់ង៉ាយ ហឹ ត្រិញ ក្លៀវៗ? វ៉ើ ដក់ ឝ្លាំង តើម ត្រាង កយឺវ ឡើ ពឹក ឡះ? ");
INSERT INTO brb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","វ៉ើ ដក់ ឝ្លាំង ង៉ាយ ហឹ អ៊ែ? វ៉ើ ដក់ ឝ្លាំង បឹ ឡើ ត្រទ្រូប ហហក ចណុង ចណាគ់ ឡះ? ណគ់ មែ ម៉ើ ត្រទ្រូប ហហក ចណុង ចណាគ់ ម៉ើ គូ ទឹង ហន់ណាម សឋិច ហវ៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","វ៉ើ ដក់ ឝ្លាំង អង់ង៉ាយ ដឹះ ហឹ អ៊ែ? វ៉ើ ដក់ ឝ្លាំង កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡះ? ត្រ ឡើយ! អៃ អង់ហាយ ដើ វែ រៀន យ៉ាគ់ ហង់អ៊ែ ឡើ ខាក់ ជឺរ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡឹះ អន់ណាវ ");
INSERT INTO brb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","យ៉ាក់ កាន យ៉ាគ់ យ៉ូហាន នែ ឡើយ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ រៀន “អៃ អប៉្រៃ ណគ លំដក់ ពហាយ ដើ បូវ អន់នួរ ហៃ ហំប៊ឹះ ណគ លំព្រនៀម ពចាគ់ ទ្រូង អន់នួរ ដើ ហៃ ”។ ");
INSERT INTO brb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន លែក ដើ បនឹះ ម៉ើ កើត ទិ ឡាង ប្រិះ នែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ខាក់ ជឺរ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក។ ហាក់ ណគ់ មែ ង៉ាយ តៃ ម៉ើ ក្រឡាវ បាត់ ជឺរ ទឹង បូវ គ្រែដៃ ឡើ ពែក ប៉ាក់ ណគ់ មែ អ៊ែ ម៉ើ ខាក់ ជឺរ យ៉ាគ់ យ៉ូហាន អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","«តើម ប៊ឹង យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ពង់ហៀន ឋា ប៊ឹះ ត្រំ តង៉ៃ នែ ប៊ិច បនឹះ ម៉ើ ខៀតសាំង ដើ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ បនឹះ ហង់អ៊ែ ម៉ើ អរាំង មាំ ម៉ើ ខំ កន់តើម ចក់ កាន ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","លែក ដើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឆា ដើ ប៊ឹះ ប៉ាង យ៉ាគ់ យ៉ូហាន នែ ម៉ើ ពហាយ អន់នួរ ឡើយ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់។ ទឹង ពឹម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ពហាយ ប៉ាគ់ទឺ កាន នែ។ ");
INSERT INTO brb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ប៉ាគ់ វន់ឌី ចាប់ ម៉ាង មែ នែ អ៊ែ វន់ណោះ រៀន ប៊ឹង ម៉ើ ហាយ យ៉ាគ់ អ៊ែលីយ៉ា លំត្រ ប៊ឹះ ម៉ើ ហាយ កាន យ៉ាគ់ យ៉ូហាន នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង នែ មន់ឃឹត យ៉ឹ!» ");
INSERT INTO brb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ប៊ឹង ង៉ាយ អំព្រឌីវ បនឹះ ប៉ាង អន់នែ? អំព្រឌីវ ប៊ឹង មែ អង់គ្លែត ម៉ើ ដ្រូម កំប្រក់ ទឹង បយឺង ម៉ើ ច្រម៉ាន ត្រឌីវ មែ សគ្រែក រៀន ");
INSERT INTO brb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ញ៉ើ ឝ៉ោះ ឝ៉ង ជីង ណាគ់ តៃ វ៉ើ រាំ ញ៉ើ ញឺម បយ៉ុ បយ៉ាល់ ណាគ់ តៃ វ៉ើ ឌី ញឺម ឝ្រង៉ឹត”។ ");
INSERT INTO brb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ប៉ាគ់ អ៊ែ ទឺ ឡើយ ដើ យ៉ាគ់ យ៉ូហាន ឡើ ក្រាំង ចណង់ ចណា ដើម តវែ ញឹះ តៃ ឡើ ញែត អ៊ែ ម៉ើ រៀន “អរ៉ាក់ ឡើ មឹត ទឹង ណគ”។ ");
INSERT INTO brb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","អ៊ែ ណគ់ ដើ កួន បនឹះ អន់ណាវ ឡើ ប៊ឹះ ទិ នែ ឡើ ញញែត ចចង់ អ៊ែ ម៉ើ រៀន “នែ វន់ឝ្លាំង បឹ អន់នែ ឡើ ក្រហូ សូប ដើម ឡើ ពន់តក ប៊ឹង មែ កាគ់ លៀន ដឹប ប៊ឹង បនឹះ ប៊ិច ឞាប ដិ”។ ហាក់ ប៉ាគ់ មន់ឃឹត ហឹ កាន ញឺ យ៉ាគ់ យ៉ូហាន ញ៉ើ បើម អ៊ែ មន់ណោះ រៀន គ្រែដៃ ឡើ ហ្រឡិច ហ្រឡាង ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពន់ដូះ មួង អន់នឺ យ៉ាក់ តៃ ម៉ើ ឌី ពលិះ ចនិះ ហមយ៉ះ ម៉ើ តៃ កាន ឆង៉ាត់ ណគ ឡើ បើម ទឹង មួង មែ ទុត អើន កតាម ");
INSERT INTO brb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ឡើ រៀន៖ «អើយ ស៊្រុក ខូរ៉ាស៊ីន វន់ត្រ ធុក ញ៉ាក ឡើយ! អើយ ស៊្រុក ប៊ែតសៃដា វន់ត្រ ធុក ញ៉ាក ប៉ាគ់ទឺ ឡើយ! ប៉ាគ់ មែ ទឹង មួង ទីរ៉ុះ ដើម មួង ស៊ីដូន មន់តៃ កាន ឆង៉ាត់ ប៉ាគ់ ដើ វែ នែ មន់ពលិះ ចនិះ ដឹប មន់ត្រទ្រូប ហហក ពស្រុ ចាក់ មន់ដ្រូម ប៊ឹង ទុះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ប៉ាគ់ ពអ៊ែ អៃ អង់ហាយ ដើ វែ រៀន តគ់ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន ដើ ស៊្រុក វែ នែ លំពថូត កយឹក ជឺរ មួង ទីរ៉ុះ ដឹប មួង ស៊ីដូន អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«អ៊ែ ដើ វែ មួង កាផារនុំ អើយ ញ៉ង វ៉ើ មឹង អ៊ឺម វន់ដូវ ឌឹក ទឹង ហូង គ្រែ សរ៉ើម វន់គ្លីះ ហឹ មួង កយ៉ក់។ ប៉ាគ់ មែ ទឹង មួង សូដំ មន់តៃ កាន ឆង៉ាត់ ប៉ាគ់ ដើ វែ នែ មួង សូដំ ណាគ់ មន់ណាគ់ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ញ៉ន ដើ នែ ឡើយ អៃ អហាយ ដើ វែ រៀន តគ់ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន មួង វែ នែ លំពថូត កយឹក ជឺរ មួង សូដំ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «ឡា គ្រែដៃ បើគ អើយ ហកន់ដ្រាគ់ ទឹង ហូង គ្រែ ដឹប ទិ ឡាង ប្រិះ អៃ អព្រតឹះ ព្រនែ ហៃ យ៉ាក់ ហពដៃ កាន លែក នែ ដើ បនឹះ តៃ ណោះ ឌូរ វ៉ារ់ ហាក់ ហអំម៉គ់ ដើ បនឹះ ហ្រឡិច ហ្រឡាង ដើម ដើ បនឹះ អ្រណោះ អ្រទីង។ ");
INSERT INTO brb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ដាវ ឡើយ គ្រែដៃ បើគ អើយ យ៉ាក់ ប្រម៉ើត ហៃ ពអ៊ែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«គ្រែដៃ បើគ អៃ ឡើ ម៉ប អង់ង៉ាយៗ ដើ អៃ លែក អិះ។ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ ហង់ឝ៉ាវ កួន កឡ គ្រែដៃ វ៉ិះ ឌិវ គ្រែដៃ បើគ កឡឹ ឡើ ហង់ឝ៉ាវ ដើម តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ ហង់ឝ៉ាវ គ្រែដៃ បើគ វ៉ិះ ឌិវ កួន កឡ ណគ កឡឹ ឡើ ហង់ឝ៉ាវ។ ប៉ាគ់ ពអ៊ែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ ហង់ឝ៉ាវ គ្រែដៃ បើគ ប៉ាគ់ កួន កឡ ណគ តៃ លំពដៃ ដើ មែ មន់ហង់ឝ៉ាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«លែក ដើ វែ វ៉ើ សាវបះ ដើម វ៉ើ កយឹក កយៀក អើយ! វន់ដក់ ដាំង អៃ អ៊ែ អង់អាំ វន់ហយ៉ូច អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ហឹ វន់ចក់ កួយ អ៊ែក អៃ នែ ដើម វន់ហៀន ប៊ឹង អៃ ដិ អ៊ែ លំហយ៉ូច ដើ វែ យ៉ាក់ អស៊ិម បក់ ដើម អណោះ ពន់ដាប ចាក់។ ");
INSERT INTO brb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","អ៊ែក អៃ ឡើ សំឞាយ កួយ ដើម កាន អជុ ប៊ឹង វែ ឡើ ហយ៉ូច ដិ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ទឹង តង៉ៃ ម៉ើ ព្រឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ ឡាត់ មឺរ អ៊ែ មែ លុកស៊ិក ណគ ម៉ើ កាត់ ចិះ ដក់ ប៉ាគ់ ចា យ៉ាក់ ម៉ើ ពងួត។ ");
INSERT INTO brb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","បូវ ផារីស៊ី ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ ម៉ាង ដើ គ្រែដៃ យែស៊ូ រៀន៖ «នែ ហង់ឝ្លាំង បូវ លុកស៊ិក ហៃ ម៉ើ កាត់ ចិះ យូច ចឞាប់ ហណោះ ង៉ើ បើម ប៉ាគ់ នែ ទឹង តង៉ៃ ព្រឹង»។ ");
INSERT INTO brb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «វ៉ើ អាន អ៊ឺម ឡះ ទឹង ពឹម គ្រែដៃ កាន សឋិច ដាវីត ដើម បូវ ណគ ប៉ាគ់ ង៉ាយ ម៉ើ បើម ប៊ឹង ម៉ើ ពងួត? ");
INSERT INTO brb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","សឋិច ដាវីត ឡើ មឹត ទឹង កទូប កនូ គ្រែដៃ ឡើ ចា ណុំពាំង ម៉ើ បាក ថួយ ដើ គ្រែដៃ ដើម ឡើ អាំ ដើ បូវ ណគ ម៉ើ ចា ដិ។ តាម ចឞាប់ ប៊ិច ឌិវ មែ កឡា បប៊ុះ ថួយ ម៉ើ ដូវ ចា ណុំពាំង អ៊ែ សឋិច ដើម បូវ ណគ ដូវ អ៊ឺម មន់ចា។ ");
INSERT INTO brb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","មូយ អន់ណាវ វ៉ើ អាន អ៊ឺម ឡះ ទឹង ពឹម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ? ទឹង តង៉ៃ ព្រឹង បូវ កឡា បប៊ុះ ថួយ ម៉ើ ពឹត កាន ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ មែ អ៊ែ ម៉ើ អន់លឺន ចឞាប់ តង៉ៃ ព្រឹង ហាក់ ម៉ើ យូច អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","អៃ អង់ហាយ ដើ វែ រៀន ទឹង នែ ប៊ិច មូយ រ៉ា ឡើ ខាក់ ជឺរ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ទឹង ពឹម ម៉ើ ខៀន ជុ រៀន “អងុញ បនឹះ មន់ណោះ ស្រុស្រៀត ត្រឌីវ មែ អងុញ អ៊ឺម បណាន់ បប៊ុះ ថួយ ”។ ប៉ាគ់ វន់ណោះ នឿណៃ ទឹង ប្រម៉ាង នែ អ៊ែ វន់ចឹន ឆ្រឡិ អ៊ឺម បូវ ");
INSERT INTO brb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","យ៉ាក់ កួន បនឹះ ឡើ កន់ដ្រាគ់ ពឺង តងៃ ព្រឹង»។ ");
INSERT INTO brb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ មឹត ហឹ រ៉ូង ពស៊ុំ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ទឹង អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ កុង ទី មូយ ច្រះ។ មែ ទឹង អ៊ែ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «តង៉ៃ ង៉ើ ព្រឹង តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ណាគ់ ដូវ ឡះ ងំពនៀម បនឹះ ម៉ើ ឈិ?» ម៉ើ តង៉ា ប៉ាគ់ អ៊ែ បក់ មន់ប៊ិច ខ រ៉ាប់ អ្រយូច ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «ពយ៉ិ ប៉ាគ់ បឹ មូយ រ៉ា ទឹង បូវ វែ លំប៊ិច ចៀម វ៉ិះ ឌិវ មូយ ចៀម អ៊ែ លំគ្លីះ ទិ រន់ឋូវ លំត្រ ទឹង តង៉ៃ ព្រឹង ពយ៉ិ បឹ ហង់អ៊ែ ណាគ់ លំពឌឹក ចៀម ណគ? ");
INSERT INTO brb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","អ៊ែ ណគ់ ដើ បនឹះ ម៉ើ ខា ជឺរ ចៀម អន់ណាវ។ ប៉ាគ់ ពអ៊ែ តាម ចឞាប់ ង៉ាយ ង៉ើ ប៊ិច ស៊ិត បើម កាន ចាគ់ ទឹង តង៉ៃ ព្រឹង ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ បឹ កុង ទី រៀន៖ «មិញ ហំពយ៉ោះ ទី ហៃ!» បឹ ហង់អ៊ែ ឡើ ពយ៉ោះ ប្រយ ទី ណគ ឡើ នៀម ប៉ាគ់ ទី តៃ លមូយ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ប៊្លី អ៊ែ បូវ ផារីស៊ី ម៉ើ ញឺះ តើម ប៊ឹង រ៉ូង ពស៊ុំ ម៉ើ ចជែ ព្រចួត ប្រម៉ាង ដាំង ទ្រូង កជែត គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","តគ់ គ្រែដៃ យែស៊ូ ឡើ ណោះ ម៉ើ ងុញ កជែត ណគ អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ ដើម ប៊ិច ប៉ាសាសុន ទុត អើន ម៉ើ តូយ ណគ។ គ្រែដៃ យែស៊ូ ឡើ ពនៀម មែ ម៉ើ ឈិ លែក រ៉ា ម៉ើ នៀម។ ");
INSERT INTO brb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ហាក់ ឡើ កំប៊ែត មន់ពហាយ ណគ អ៊ែ ឡើ មែ ង៉ាយ ");
INSERT INTO brb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","អាំ លំដាវ តាម ប្រម៉ាង យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«គ្រែដៃ ឡើ ហាយ រៀន៖ “ណគ នែ ឡើយ ឞយ អៃ អរ៉ើះ ឡើ ត្រ ប្រម៉ើត អៃ អញឹម ក្លើម ដើ ណគ ទុត ខាក់។ អង់អាំ ផវ យ៉ាង អៃ លំគូ ទឹង ណគ អ៊ែ លំពហាយ លែក ដើ សុនសាត អាំ មន់ហង់ឝ៉ាវ ទ្រូង ចាគ់ ទឹង ត្រ។ ");
INSERT INTO brb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ញឹះ តៃ លំព្រសិញ ដើ បូវ ញឹះ តៃ លំពអូក ដើ បួរ ញឹះ តៃ លំប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដុង ប្រម៉ាង ណគ បរ ទ្រូង។ ");
INSERT INTO brb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ទុត តង ទ្រែង ឡើ តឝ៉ាវ យ៉ិង អយ៉ិង ណាគ់ តៃ លំពតាត់ ដើម តៃ លំខូម តប៉ាត់ អ៊ុញ តកៀង ដៀប លំប៉ាត់។ ឆា ដើ ប៊ឹះ កាន ចាគ់ ទឹង ត្រ លំភែ។ ");
INSERT INTO brb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","លែក ដើ សុនសាត មន់មឹង ណគ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ប៊ឹង អ៊ែ ម៉ើ តៀត កឡ មូយ រ៉ា អរ៉ាក់ មឹត អរ៉ាក់ នែ ឡើ បើម អាំ ណគ សូត ដើម ឡើ កំប្ល គ្រែដៃ យែស៊ូ ឡើ ពនៀម ណគ។ អ៊ែ ឡើ ណោះ ចជែ ដើម ឡើ ត្រប៉ៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","លែក ដើ ប៉ាសាសុន ម៉ើ ញ៉ម ទុត ខាក់ ដើម ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «យ៉ាគ់ អន់នែ កួន ចូវ សឋិច ដាវីត តៃ ណោះ!» ");
INSERT INTO brb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","បូវ ផារីស៊ី ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ ម៉ាង រៀន៖ «បឹ អន់នែ ឡើ ដូវ ពន់ឌ្រុះ អរ៉ាក់ ញ៉ន ប៊ែលស៊ែប៊ូល ណាយ អរ៉ាក់ ឡើ អាំ អាតណាត ដើ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","គ្រែដៃ យែស៊ូ ឡើ ណោះ ខនឹត មែ អ៊ែ ឡើ ម៉ាង រៀន៖ «ត្រំ ពធែត ប៉ាគ់ ប៉ាសាសុន មន់ប្រណើម ត្រឌីវ មែ ពធែត អ៊ែ លំប៉ាត់ ពណាត់ អ៊ែ ត្រំ មួង លឺ ទឹង ក្រាន មន់ប៊ិច កាន ព្រសិញ ត្រម៉ាង មន់ណាគ់ យ៉ាវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ប៉ាគ់ អរ៉ាក់ សតាំង លំពន់ឌ្រុះ បូវ ឡើ កឡឹ លំប៊ិច កាន ប្រណើម ទឹង បូវ ណគ អ៊ែ កាន ណគ ឡើ ពែក ប៉ាក់ លំណាគ់ យ៉ាវ កឋោះ! ");
INSERT INTO brb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ប៉ាគ់ អពន់ឌ្រុះ អរ៉ាក់ ដើ អាតណាត ប៊ែលស៊ែប៊ូល ប៉ាគ់ អ៊ិន ប៉ាគ់ ពអ៊ែ លុកស៊ិក វែ ដើ អាតណាត មែ ង៉ាយ អន់ណាវ ម៉ើ អ៊ីង ម៉ើ ពន់ឌ្រុះ អរ៉ាក់? ប៉ាគ់ ពអ៊ែ លុកស៊ិក វែ មន់ពដៃ រៀន ខនឹត វែ យូច ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ហាក់ ប៉ាគ់ អៃ អពន់ឌ្រុះ អរ៉ាក់ អអ៊ីង ដើ អាតណាត ផវ យ៉ាង គ្រែដៃ អ៊ែ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ ប៊ឹះ ទិ វែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","មូយ អន់ណាវ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដូវ មឹត ចក់ រ៉ាះ អំបាះ ទឹង ហន់ណាម បឹ ឡើ ប្រិញ ថាំង តៃ កា មន់រ៉ាប់ ចង ណគ អន់ដៃ អ៊ែ មន់ដូវ ចក់ លែក ដើ រ៉ាះ អំបាះ ទឹង ហន់ណាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","មែ ង៉ាយ ម៉ើ គូ អ៊ឺម តៃ អៃ មែ អ៊ែ ម៉ើ ខៀតសាំង ដើ អៃ ឡើយ មែ ង៉ាយ តៃ ម៉ើ ឌី តមួត បនឹះ មន់តូយ អៃ មែ អ៊ែ ម៉ើ បើម អាំ បនឹះ មន់ប៉្រាះ ព្រាំង ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ប៉ាគ់ ពអ៊ែ អៃ អង់ហាយ ដើ វែ រៀន លែក ដើ ឞាប បនឹះ ម៉ើ បើម ដើម លែក ដើ កាន ម៉ើ ផម៉ាត ផម៉ា គ្រែដៃ ណគ លំតាក់ ថូត លែក អិះ ដូវ ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ផម៉ាត ផវ យ៉ាង គ្រែដៃ គ្រែដៃ លំតាក់ ថូត អ៊ឺម ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ប៉ាគ់ មែ ង៉ាយ ម៉ើ ម៉ាង តៃ ញឹម ដើ កួន បនឹះ មែ អ៊ែ គ្រែដៃ លំតាក់ ថូត ដើ មែ ហាក់ ប៉ាគ់ មែ ង៉ាយ ម៉ើ ម៉ាង តៃ ញឹម ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ មែ អ៊ែ គ្រែដៃ លំតាក់ ថូត អ៊ឺម ដើ មែ សំយ៉ះ ប៉ាង ណិះៗ លឺ ហឹ ងឺរ កតាម»។ ");
INSERT INTO brb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«វន់ឃឹត ឡាំង ប៉ាគ់ តើម ឡង ចាគ់ ឡើ ប៉្លៃ ចាគ់ ប៉ាគ់ទឺ។ អ៊ែ ប៉ាគ់ តើម ឡង តៃ ចាគ់ ប៉្លៃ តៃ ឡើ ចាគ់ ប៉ាគ់ទឺ។ យ៉ាក់ ម៉ើ ហង់ឝ៉ាវ តើម ឡង តាម ប៉្លៃ។ ");
INSERT INTO brb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","បូវ កួន ប៊ិះ ប្រៃ អើយ! ចនិះ វែ តៃ ឡើ ចាគ់ ប៉ាគ់ នែ ពយ៉ិ វន់ដូវ ចជែ ញឹម! យ៉ាក់ បនឹះ ម៉ើ ចជែ ឞ្លៀៗ តាម ឡើ ញឺះ តើម ប៊ឹង ចនិះ មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","បនឹះ ចនិះ ចាគ់ ម៉ើ ពដៃ កាន ចាគ់ យ៉ាក់ ចនិះ មែ ឡើ ចាគ់ អ៊ែ ណគ់ បនឹះ ចនិះ តៃ ចាគ់ ម៉ើ ពដៃ កាន តៃ ចាគ់ យ៉ាក់ ចនិះ មែ តៃ ឡើ ចាគ់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","អៃ អំហាយ ដើ វែ រៀន ហឹ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន បនឹះ គ្រែដៃ លំតាត់ស៊ិន លែក ដើ ប្រម៉ាង ប៊ែត ឆាន់ ណគ់ ម៉ើ ខើយ ចជែ ");
INSERT INTO brb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","យ៉ាក់ គ្រែដៃ ឡើ តៃ វ៉ើ ប៊ិច អ៊ឺម យូច តាម ប៉ាគ់ ប្រម៉ាង វែ កឡឹ ដើម លំពថូត វែ តាម ប៉ាគ់ ប្រម៉ាង វែ កឡឹ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ប៊ឹង អ៊ែ ប៊ិច បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ មែ ផារីស៊ី អន់នឺ រ៉ា ម៉ើ ឡា ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា យ៉ាគ់ ណាយឃូ អើយ ហំពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ ដើ ញ៉ា ញំតៃ អុះ!» ");
INSERT INTO brb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «បនឹះ ប៉ាង ណិះៗ ញឹះ តៃ ម៉ើ ចាគ់ ដើម តៃ ម៉ើ ទឹង ត្រ ដើ គ្រែដៃ ដិ ម៉ើ ងុញ តៃ កាន ហឝ៉ាវ ឆង៉ាត់ ហាក់ គ្រែដៃ លំពដៃ អ៊ឺម កាន ហឝ៉ាវ ឆង៉ាត់ គែង តើម ប៊ឹង កាន ហឝ៉ាវ ប៊ឹង យ៉ាគ់ យ៉ូណះ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ពន់ឋើម ដើ យ៉ាគ់ យ៉ូណះ ឡើ គូ ទឹង ពឌិវ ទ្រឺ ទិះ ពែ តង៉ៃ ពែ មាំង ប៉ាគ់ ង៉ាយ  កួន បនឹះ លំគូ ទិ កនុង ពដិះ ពែ តង៉ៃ ពែ មាំង ប៉ាគ់ អ៊ែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","តគ់ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន មែ ទឹង មួង នីនីវែ មន់ឌឹក ឆុង អរែង ដើ បនឹះ ប៉ាង អន់នែ អ៊ែ មែ នីនីវែ មន់ពថូត មែ យ៉ាក់ ពន់ឋើម មែ មួង នីនីវែ ប៊ឹង ម៉ើ ដុង ប្រម៉ាង យ៉ាគ់ យ៉ូណះ ឡើ ពហាយ ម៉ើ ពលិះ ប្រយ ចនិះ។ ហាក់ ទឹង នែ ប៊ិច មូយ រ៉ា ឡើ ខាក់ ជឺរ យ៉ូណះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","តគ់ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន សឋិច កទ្រី ឡើ ពែក ប៉ាក់ ប៊្រី ដាក ស៊ែបា លំឌឹក ឆុង អរែង ដើ បនឹះ ប៉ាង អន់នែ អ៊ែ លំពថូត មែ យ៉ាក់ ពន់ឋើម សឋិច កទ្រី នែ ឡើ ដក់ តើម ប៊ឹង ស្រុក ចង៉ាយ បក់ លំចង់ហៀង ប្រម៉ាង ហ្រឡិច ហ្រឡាង សឋិច សាឡូម៉ូន ។ ហាក់ ទឹង នែ ប៊ិច មូយ រ៉ា ឡើ ខាក់ ជឺរ សឋិច សាឡូម៉ូន អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ រៀន៖ «តគ់ អរ៉ាក់ ឡើ វីះ តើម ប៊ឹង បនឹះ មូយ រ៉ា ឡើ ដក់ សាត ដាំង កនូ ហឹ ត្រិញ លៀងៗ ឡើ តៃ អ៊ឺម ");
INSERT INTO brb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","អ៊ែ ឡើ ឃឹត រៀន “អន់ជឹ វឹញ គូ ហឹ ហន់ណាម អៃ អវីះ អន់ឌូ កឋោះ”។ អ៊ែ តគ់ ឡើ ប៊ឹះ ឡើ តៃ ហន់ណាម ប៊ិច អំម៉ឹះ ម៉ើ គូ ដើម ម៉ើ ពប៉ូះ សសា រន់ឋាប់ ពរ៉គ់ ពន់សំ។ ");
INSERT INTO brb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","អ៊ែ ឡើ ដក់ ច្រា អរ៉ាក់ ម៉ាត់តូវ អរាំងៗ ជឺរ ណគ ប៉ឹះ រ៉ា អន់ណាវ ម៉ើ ដក់ មឹត គូ ទឹង បនឹះ អ៊ែ ឡើ បើម អាំ បនឹះ អ៊ែ ធុក ញ៉ាក ជឺរ ពន់ឋើម អន់ណាវ។ អ៊ែ ណគ់ បនឹះ ប៉ាង អន់នែ ម៉ើ អរាំង មាំ លំកើត ដើ មែ ប៉ាគ់ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ទឹង ប៉ះ ឡើ ចជែ ដើ មែ ប៉ាសាសុន ហំប៊្រុះ ដើ អ៊ែ មែគ ដើម មែ អោះ កឡ ណគ ម៉ើ ប៊ឹះ ម៉ើ ឆុង តគ់ អរ៉ះ ម៉ើ ងុញ ចជែ ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ប៊ិច បឹ មូយ រ៉ា ឡើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «មែគ ហៃ ដើម មែ អោះ ហៃ ម៉ើ ចាំ ហឹ អរ៉ះ ម៉ើ ងុញ ចជែ ប៊ឹង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ បឹ ហង់អ៊ែ រៀន៖ «មែ ង៉ាយ ដឹះ មែគ អៃ មែ ង៉ាយ ដឹះ អំម៉ោះ អោះ អៃ?» ");
INSERT INTO brb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","គ្រែដៃ យែស៊ូ ឡើ ចង់អូត ហឹ មែ លុកស៊ិក ណគ ឡើ ម៉ាង រៀន៖ «មែ នែ ឡើយ មែគ អៃ ដើម អំម៉ោះ អោះ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","យ៉ាក់ ណគ់ មែ ង៉ាយ ម៉ើ បើម ត្រួយ ប្រម៉ើត គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ មែ អ៊ែ ឡើយ ឡើ ត្រ មែគ អៃ ដើម អំម៉ោះ អោះ អៃ តៃ ម៉ាង កទ្រី តៃ ម៉ាង កឡ»។ ");
INSERT INTO brb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ទឹង តង៉ៃ អន់ទឺ គ្រែដៃ យែស៊ូ ឡើ ញឺះ តើម ប៊ឹង ហន់ណាម ឡើ ដក់ ដ្រូម ពង់ហៀន បូវ តគ់ ពឹះ សមុត។ ");
INSERT INTO brb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ប៊ិច ប៉ាសាសុន ទុត អើន ឆឹន ហន់ឆឹន វ៉ិន អវែន ម៉ើ ដក់ តមួត ឈុំ ណគ អ៊ែ ឡើ ទឺះ ដ្រូម ទិ ឌូក លែក ដើ មែ ប៉ាសាសុន ម៉ើ គូ ប៊ឹង ពឹះ។ ");
INSERT INTO brb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន កាន ទុត អើន ដើ ប្រម៉ាង ចនីរ ឡើ រៀន៖ «វន់ចង់ហៀង យ៉ឹ! ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ប្រាក់ អង់គុង ហឹ មឺរ។ ");
INSERT INTO brb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ទឹង ឡើ ប្រាក់ អង់គុង អន់នឺ ឡើ គ្លីះ ត្រ ប៉ុះ ទ្រូង អ៊ែ ជែម ម៉ើ ទឺះ ក្លក់ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","អង់គុង អន់នឺ អន់ណាវ ឡើ គ្លីះ ទិ តម៉ ដដារ តៃ ហន់ដាគ់ ប៊ិច ប្រិះ អ៊ែ ឡើ ក្លគ់ ដ្រិះៗ យ៉ាក់ ប្រិះ ឡើ ហឌឺង។ ");
INSERT INTO brb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","តគ់ ម៉ាត់ តង៉ៃ ឡើ ឌឹក ដុ ឡើ រ៉ូយ រ៉ាក គែត លែក តាក់ យ៉ាក់ រៀះ ឡើ តូត ឈ្រុ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","អង់គុង អន់នឺ អន់ណាវ ឡើ គ្លីះ ទឹង ប្រិះ ប៊ិច អង់គុង ឆ្រឡា ឆ្រឡា ឡើ ហួន ពុះលំ អ៊ែ ចិះ ឡើ ហឝុះ គែត។ ");
INSERT INTO brb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","អង់គុង អន់នឺ ឡើ គ្លីះ ទឹង ប្រិះ អ៊ីន អ៊ែ ឡើ ប៉្លៃ ហ្រកង់ អន់នឺ ឡើ ប៉្លៃ មូយ ក្លាំ អង់គុង ហ្រកង់ អន់នឺ ត្រូវ ជិត ហ្រកង់ អន់នឺ អន់ណាវ ពែ ជិត។ ");
INSERT INTO brb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង អៃ នែ មន់ឃឹត យ៉ឹ!» ");
INSERT INTO brb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ប៊ឹង អ៊ែ មែ លុកស៊ិក ម៉ើ ដក់ តគ់ គ្រែដៃ យែស៊ូ ម៉ើ តង៉ា ណគ រៀន៖ «ប៉ិ ឡើ ត្រ ហពង់ហៀន មែ ដើ ប្រម៉ាង ចនីរ ប៉ាគ់ អ៊ិន?» ");
INSERT INTO brb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ឡើ ត្រណើវ រៀន៖ «យ៉ាក់ គ្រែដៃ ឡើ អាំ ដើ វែ វន់ណោះ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ណាគ់ ឡើ វៀក ដក អ៊ែ ណគ់ ដើ មែ គែង គ្រែដៃ ឡើ អាំ អ៊ឺម មន់ណោះ។ ");
INSERT INTO brb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ណគ់ មែ ង៉ាយ ម៉ើ ប៊ិច ឡើយ គ្រែដៃ លំអាំ ទឺម ឡឹះ អន់ណាវ អ៊ែ មន់ប៊ិច ស៊ិវ សាគ់ ណាគ់ គ្លឺយ  អ៊ែ ណគ់ មែ ង៉ាយ តៃ ម៉ើ ប៊ិច គ្រែដៃ លំចក់ ពលែក ណគ់ អង់ង៉ាយៗ ម៉ើ ប៊ិច។ ");
INSERT INTO brb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ញ៉ន ដើ អ៊ែ ឡើយ អម៉ាង ចនីរ ដើ មែ អ៊ែ ហម ម៉ើ ឝ្លាំង ណាគ់ តៃ ម៉ើ តៃ ហម ម៉ើ ចង់ហៀង ណាគ់ តៃ ម៉ើ ដុង ដើម តៃ ម៉ើ ណោះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","កាន នែ ឡើ ដាវ ប៉ាគ់ យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន កាន មែ រៀន “វែ វន់ចង់ហៀង លហម ហាក់ វន់ណោះ អ៊ឺម។ វន់ឝ្លាំង លហម ហាក់ វន់តៃ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","យ៉ាក់ ចនិះ សុនសាត មែ នែ ឡើ ឝ៉ិះ ទុត ខាក់ ម៉ើ កឌែត ត្រពិត ដើម ម៉ើ ព្រលិប ម៉ាត់ ម៉ើ កយ៉ូវ មន់តៃ ម៉ើ កយ៉ូវ មន់ដុង ម៉ើ កយ៉ូវ មន់ណោះ កឡាគ់ មន់ដក់ ដាំង អៃ អន់ណាវ អ៊ែ អំឌី ពនៀម មែ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«អ៊ែ ណគ់ ដើ វែ អន់ណាវ វ៉ើ ហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ ម៉ាត់ វែ វ៉ើ តៃ ត្រពិត វែ វ៉ើ ដុង! ");
INSERT INTO brb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម បនឹះ ចាគ់ ទឹង ត្រ ឡៃ មាំង ទុត អើន ម៉ើ ងុញ ម៉ាត់ ម៉ាត មន់តៃ កាន វែ វ៉ើ តៃ ពញ៉ង ម៉ើ តៃ អ៊ឺម ម៉ើ ងុញ ដុង ម៉ាត់ ម៉ាត កាន វែ វ៉ើ ដុង ពញ៉ង ម៉ើ ដុង អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ប៉ាគ់ ពអ៊ែ ណគ់ ដើ វែ អន់ណាវ វន់ចង់ហៀង នឿណៃ ប្រម៉ាង អៃ អចនីរ ប៊ឹង បឹ ឡើ ប្រាក់ ចិះ។ ");
INSERT INTO brb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","កាន អង់គុង ឡើ គ្លីះ ប៉ុះ ទ្រូង អ៊ែ ឡើ ព្រឌីវ ប៊ឹង បនឹះ ម៉ើ ដុង ប្រម៉ាង ឡើ ហាយ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ហាក់ ម៉ើ ណោះ អ៊ឺម ហឡាក់ អ៊ែ អរ៉ាក់ សតាំង ឡើ ដក់ សុក ប្រម៉ាង គ្រែដៃ តើម ប៊ឹង ចនិះ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","អ៊ែ ណគ់ កាន អង់គុង ឡើ គ្លីះ ទឹង តម៉ ដដារ ឡើ ព្រឌីវ ប៊ឹង បនឹះ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ម៉ើ ឡាប់ ដើ ចនិះ ញឹម ក្លើម ក្លាក ដ្រិះៗ ប្រយ ");
INSERT INTO brb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ហាក់ ម៉ើ អាំ អ៊ឺម ប្រម៉ាង គ្រែដៃ លំតូត រៀះ ឈ្រុ ទឹង ចនិះ មែ ម៉ើ ឡាប់ វ៉ិះ ឞិត ឞ៊ែត តគ់ ឡើ ប៊ឹះ កាន ធុក ញ៉ាក ដើម ម៉ើ តំឞាប មែ ញ៉ន ម៉ើ ចាប់ ប្រម៉ាង គ្រែដៃ ម៉ើ តាក់ ដ្រិះៗ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","អ៊ែ ណគ់ កាន អង់គុង ឡើ គ្លីះ ទឹង ឆ្រឡា ឡើ ព្រឌីវ ប៊ឹង បនឹះ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ហាក់ ម៉ើ វ៉ឹនវ៉ាយ ដើ កាន ញិវ កើត ទិ ឡាង ប្រិះ នែ ម៉ើ បូត ងុញ ប្រនិច ចាំ អើន កាន លែក នែ ឡើ ពុះលំ ប្រម៉ាង គ្រែដៃ អ៊ែ ឡើ ហឝុះ ឡើ ពឺរ ប្ល៉ៃ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","អ៊ែ ណគ់ កាន អង់គុង ឡើ គ្លីះ ទឹង ពដិះ អ៊ីន ឡើ ព្រឌីវ ប៊ឹង បនឹះ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ដើម ម៉ើ ណោះ ហឡាក់ មែ នែ ម៉ើ ពឝ៉ើត ពឺរ ប៉្លៃ ប្រយ មែ អន់នឺ ម៉ើ ពឝ៉ើត មូយ ក្លាំ មែ អន់នឺ ត្រូវ ជិត មែ អន់នឺ អន់ណាវ ពែ ជិត»។ ");
INSERT INTO brb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ចនីរ ឡឹះ ដើ មែ ប៉ាសាសុន រៀន៖ «កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ បើម ប៉ាគ់ នែ ប៊ិច កឡ មូយ រ៉ា ឡើ ប្រាក់ ហឌឺវ ទុត ចាគ់ ទឹង ណា ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ទឹង ម៉ើ ហង់ង៉ាន់ តៀក ដ្រម៉ា កន់ដ្រាគ់ ហន់ណាម ឡើ ដក់ ប្រាក់ ព្រឡាប អង់គុង បាត់ តកា ទឹង ណា អ៊ែ ប៊្លី អ៊ែ ឡើ វីះ ប៉ាត់ តាក់។ ");
INSERT INTO brb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","តគ់ ចិះ ឡើ ហួន ឌឹក រ៉ក ម៉ក់ បាត់ តកា ឡើ ឌឹក ហួន រ៉ក ម៉ក់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","មែ ឞយ ម៉ើ ដក់ តង៉ា កន់ដ្រាគ់ ណា រៀន “យ៉ាគ់ កន់ដ្រាគ់ ហប្រាក់ ហឌឺវ ទឹង ណា ហៃ ម៉ាត់តូវ ចាគ់ៗ ហវ៉ៃ តើម ប៊ឹង ង៉ាយ ឡើ ប៊ឹះ បាត់ តកា អ៊ែ?” ");
INSERT INTO brb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","កន់ដ្រាគ់ មែ ឡើ ត្រណើវ រៀន “ប៉ាគ់ ពអ៊ិន ដ្រម៉ា ឡើយ ឡើ ដក់ ប្រាក់”។ មែ ឞយ ណគ ម៉ើ តង៉ា ឡឹះ រៀន “ណាគ់ ហអាំ ឡះ ញំទុច តាក់ បាត់ តកា អ៊ែ?” ");
INSERT INTO brb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","កន់ដ្រាគ់ ឡើ ត្រណើវ រៀន “ញ៉ង វ៉ើ ទុច អន់ដិះ ហន់ណូវ ចិះ លំដម។ ");
INSERT INTO brb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","វន់ជុ លំហួន អរែង ប៉ាគ់ អិះ ឡើយ អន់ដៃ ឆា ដើ ឌុំ តគ់ លំឌុំ អ៊ែ អំហាយ ដើ មែ ម៉ើ កៀវ រៀន វន់កៀវ តមួត បាត់ តកា អន់ដៃ វន់ចង ប៉ិន ប្រណវ វន់ចុះ តាក់ ប្ល៊ី អ៊ែ វន់កៀវ ចិះ តមួត ជុ ទឹង នុក អៃ”»។ ");
INSERT INTO brb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","គ្រែដៃ យែស៊ូ ឡើ ហាយ ចនីរ ឡឹះ ដើ មែ ឡើ រៀន៖ «កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ បើម ប៉ាគ់ អង់គុង ក្លិត គ្លែត បឹ មូយ រ៉ា ឡើ ដក់ ដាំ ទឹង មឺរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","អងគុង អ៊ែ ឡើ គ្លែត ជឺរ អង់គុង អង់គែងៗ លែក អិះ ហាក់ តគ់ ឡើ ហួន ឡើ ឌឹក ប៉ិន តើម ឡង មូយ ឡើ ទិះ ជឺរ ដណាំ អង់គែងៗ អ៊ែ ជែម ប៊្រែម ម៉ើ គូ ឆ្រុក ប៊ឹង ឝឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","គ្រែដៃ យែស៊ូ ឡើ ហាយ កាន ចនីរ មូយ ឡឹះ រៀន៖ «កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ បើម ប៉ាគ់ ប៊ូះ ណគ់ កទ្រី ឡើ ចក់ លុក ទឹង ភែ ប៊ិះ មូយ រែវ ហម បើម ណុំពាំង អ៊ែ ភែ ប៊ិះ ឡើ ឌឹក សូល លែក អិះ»។ ");
INSERT INTO brb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង កាន លែក អ៊ែ ដើ មែ ប៉ាសាសុន ម៉ាត់តូវ ដើ ប្រម៉ាង ចនីរ ឡើ ហាយ អ៊ឺម ឡាក់ៗ។ ");
INSERT INTO brb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ឡើ ម៉ាង ចនីរ ប៉ាគ់ អ៊ែ អាំ លំដាវ តាម ប៉ាគ់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ រៀន៖ «អៃ អំចជែ ហឹ មែ ដើ ប្រម៉ាង ចនីរ ដើម អំពហាយ កាន គ្រែដៃ ឡើ វៀក ដក តើម ប៊ឹង កណើត ពដិះ គ្រែ »។ ");
INSERT INTO brb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","តគ់ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង មែ ប៉ាសាសុន ឡើ មឹត ទឹង ហន់ណាម។ មែ លុកស៊ិក ម៉ើ ដក់ ឡា ហឹ ណគ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ ឡា ហំហាយ នឿណៃ កាន ហចនីរ ប៊ឹង បាត់ តកា ដ្រម៉ា ឡើ ប្រាក់ ទឹង មឺរ អាំ ញំណោះ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «បឹ ឡើ ប្រាក់ ហឌឺវ ចាគ់ ណគ អ៊ែ កួន បនឹះ ");
INSERT INTO brb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ណគ់ ណា ឡើ ត្រ ឡាង ប្រិះ ណគ់ ហឌឺវ ចាគ់ ឡើ ត្រ បនឹះ គ្រែដៃ ឡើ ពែក ប៉ាក់ អ៊ែ ណគ់ បាត់ តកា អន់ណាវ ឡើ ត្រ បនឹះ ម៉ើ តូយ អរ៉ាក់ សតាំង។ ");
INSERT INTO brb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ដ្រម៉ា ឡើ ប្រាក់ បាត់ តកា អ៊ែ អរ៉ាក់ សតាំង ណគ់ ញ៉ាម កនៀវ ឡើ ត្រ តង៉ៃ លំឡូច ឡាង ប្រិះ ឡាង គ្រែ ណគ់ មែ កឡា កៀវ អ៊ែ ឞាវ គ្រែដៃ ។ ");
INSERT INTO brb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","មែ ម៉ើ កៀវ បាត់ តកា ចុះ ទិ អ៊ុញ ប៉ាគ់ ង៉ាយ តគ់ តង៉ៃ លំឡូច ឡាង ប្រិះ ឡាង គ្រែ លំកើត ប៉ាគ់ អ៊ែ ទឺ ឡើយ ");
INSERT INTO brb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ទឹង អ៊ែ កួន បនឹះ លំប្រ៉ៃ បូវ ឞាវ ណគ មន់តមួត ណគ់ មែ ម៉ើ ច្រា បូវ បើម កាន យូច ដើម ណគ់ មែ ម៉ើ អន់លឺន ចឞាប់ គ្រែដៃ មន់តវីះ តើម ប៊ឹង ឞន ណគ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","មន់ពៀវ មែ ទិ ហួម អ៊ុញ ទិ អ៊ែ មន់ញឺម ស៊្រែក កាប់ ក្រៀម ឝលៀម ពឹង។ ");
INSERT INTO brb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","អ៊ែ ណគ់ ដើ មែ ម៉ើ ចាគ់ ទឹង ត្រ អន់ណាវ មន់មឹត ទឹង ឞន គ្រែដៃ បើគ មែ ឡើ ពែក ប៉ាក់ ទឹង អ៊ែ មន់ឝ៉ាល ឞាល់ ម៉ាត់ តង៉ៃ។ មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង នែ មន់ឃឹត យ៉ឹ!» ");
INSERT INTO brb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ បើម ប៉ាគ់ ឆៀង ម៉ើ កុប កដក ទឹង មឺរ ណាគ់ ឡៃ មាំង។ ប៊ិច បឹ មូយ រ៉ា ឡើ តៃ អ៊ែ ឡើ កុប ឡឹះ ទិ ទឺ អន់ណាវ។ ឡើ ញឹម ក្លើម ទុត ខាក់ អ៊ែ ឡើ ជឹ ហំពួត លែក ដើ ប្រនិច ណគ ឡើ ដក់ រួត មឺរ អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«មូយ អន់ណាវ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ប៉ាគ់ នែ ឡើ បើម ប៊ិច បនឹះ ពន់ដ្រ មូយ រ៉ា ឡើ ដាំង រួត ពិច ណគ់ ឡតៗ។ ");
INSERT INTO brb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ហំប៊្រុះ ឡើ តៃ ពិច មូយ ទុត ឡត ច្រណាប់ តៃ ឋាំ ឡើ ជឹ ហំពួត លែក ដើ ប្រនិច ណគ អ៊ែ ឡើ ដក់ រួត»។ ");
INSERT INTO brb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ បើម ប៉ាគ់ អួន ម៉ើ កលីះ ទិ សមុត ម៉ើ អ៊ូះ ឡើ ចួត ទ្រឺ ត្រំ ហំឞ្លិច។ ");
INSERT INTO brb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","តគ់ ម៉ើ តៃ ទ្រឺ ឡើ ចួត ប៊ិង អួន ឡើយ អ៊ែ ម៉ើ អ៊ូះ ពឌឹក ហឹ ពឹះ ប៊្លី អ៊ែ ម៉ើ ដ្រូម រ៉ើះ ទ្រឺ ចាគ់ៗ ម៉ើ ជុ ទឹង ប៊ុង អ៊ែ ណគ់ ទ្រឺ តៃ ប៉ិន ម៉ើ ពៀវ តាក់។ ");
INSERT INTO brb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","តគ់ លំឡូច ឡាង ប្រិះ ឡាង គ្រែ លំត្រ ប៉ាគ់ នែ ទឺ ឡើយ។ ទឹង អ៊ែ បូវ ឞាវ គ្រែដៃ មន់ដក់ កះ បនឹះ បើម តៃ ចាគ់ ពញឺះ តើម ប៊ឹង បនឹះ ចនិះ ចាគ់ ");
INSERT INTO brb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ប៊្លី អ៊ែ មន់ពៀវ បនឹះ ចនិះ តៃ ចាគ់ ទិ ហួម អ៊ុញ ទិ អ៊ែ មន់ញឺម ស៊្រែក កាប់ ក្រៀម ឝលៀម ពឹង»។ ");
INSERT INTO brb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","គ្រែដៃ យែស៊ូ ឡើ តង៉ា លុកស៊ិក ណគ រៀន៖ «ពយ៉ិ ណាគ់ វ៉ើ ណោះ នឿណៃ កាន ព្រឌីវ លែក នែ?» មែ លុកស៊ិក ម៉ើ ត្រណើវ រៀន៖ «អ៊ឺគ ណោះ!» ");
INSERT INTO brb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ណគ ឡើ ម៉ាង ឡឹះ ហឹ មែ រៀន៖ «ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ លែក ដើ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ណគ់ ម៉ើ ដូវ ហៀន ហាំ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ម៉ើ បើម ប៉ាគ់ កន់ដ្រាគ់ ហន់ណាម ឡើ ពញឺះ រ៉ាះ ទុត ច្រណាប់ តើម ប៊ឹង កនុង ហន់ណាម ណគ រ៉ាះ ហន់ដើម ដឹប រ៉ាះ ក្រាគ់»។ ");
INSERT INTO brb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","តគ់ គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន ដើ ប្រម៉ាង ព្រឌីវ លែក នែ លែវ ឡើយ អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ ");
INSERT INTO brb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ឡើ ជឹ វឹញ ហឹ ស៊្រុក ណគ កឡឹ អន់ណាវ។ ហឹ អ៊ែ ឡើ ពង់ហៀន មែ ក្លាង ស៊្រុក ទឹង រ៉ូង ពស៊ុំ មែ មែ ស៊្រុក តូវ ម៉ើ បើម ញ៉ម ប្រយ។ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «តើម ប៊ឹង ង៉ាយ ឋូវ ឡើ ដូវ ហ្រឡិច ហ្រឡាង ដើម ឡើ ប៊ិច អាតណាត បើម កាន ឆង៉ាត់ ឞាល់ នែ? ");
INSERT INTO brb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ពយ៉ិ បឹ អន់នែ កួន បឹ ចៀង ឡង ហវ៉ៃ មែគ ណគ ណាង ម៉ារី អោះ កឡ ណគ យ៉ាកុប យ៉ូស៊ែ ស៊ីម៉ូន យូដះ ហវ៉ៃ! ");
INSERT INTO brb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","លែក ដើ អោះ កទ្រី ណគ ម៉ើ គូ អរែង ទឹង ស៊្រុក ង៉ាយ ទឺ។ ពយ៉ិ តើម ប៊ឹង ង៉ាយ ឋូវ ឡើ ណោះ កាន លែក នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ញ៉ន ដើ អ៊ែ ឡើយ ម៉ើ ឌី អ៊ឺម ចាប់ មឹង ណគ។ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «លែក ដើ មែ ស៊្រុក ហឹ គែង ម៉ើ ខរ៉ុប បឹ កឡា ឈូន ប្រម៉ាង គ្រែដៃ វ៉ិះ ឌិវ មែ ទឹង ស៊្រុក ណគ កឡឹ ដើម មែ ទឹង ក្រាន ណគ តៃ ម៉ើ ឌី ខរ៉ុប!»។ ");
INSERT INTO brb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ទឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ បើម អ៊ឺម កាន ឆង៉ាត់ អឹនអើន យ៉ាក់ តៃ ម៉ើ ឌី ចាប់ មឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ទឹង អ៊ែ សឋិច ហ៊ែរ៉ូត ឡើ ពែក ប៉ាក់ ស្រុក ឝ៉ាលីលែ ឡើ ដុង ម៉ើ ប៉ច កាន គ្រែដៃ យែស៊ូ ");
INSERT INTO brb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","អ៊ែ ឡើ ហាយ ដើ មែ ទិះ ក្រាគ់ ណគ រៀន៖ «បឹ ហង់អ៊ិន យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ញិវ ឡឹះ អន់ណាវ អ៊ែ ឡើ ណោះ បើម កាន ឆង៉ាត់ ឞាល់ អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","សឋិច ហ៊ែរ៉ូត ឡើ ម៉ាង ប៉ាគ់ អ៊ែ យ៉ាក់ ពន់ឋើម ឡើ ប្រ៉ៃ ម៉ើ រ៉ាប់ យ៉ាគ់ យ៉ូហាន តាំ កណោះ ជុ ទឹង ឃុក។ ឡើ បើម ប៉ាគ់ អ៊ែ ញ៉ន ដើ ណាង ហ៊ែរ៉ូដៀះ ទ្រី អោះ ណគ ភីលីប។ ");
INSERT INTO brb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","យ៉ាក់ រីវ យ៉ាគ់ យ៉ូហាន ឡើ គឹះ ពន់ដូះ ហ៊ែរ៉ូត រៀន៖ «ត្រ អ៊ឺម ហណោះ ហសុក ទ្រី អោះ ហៃ ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","សឋិច ហ៊ែរ៉ូត ឡើ ងុញ កជែត យ៉ាគ់ យ៉ូហាន ពញ៉ង ឡើ ឌូង ដើ មែ ប៉ាសាសុន យ៉ាក់ ម៉ើ ជុ ណគ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","តគ់ តង៉ៃ ឞ៊ុន កណើត សឋិច ហ៊ែរ៉ូត កួន ប្រោះ ណាង ហ៊ែរ៉ូដៀះ ឡើ ដក់ មឹត រាំ ប៊ឹង ងឺរ មែ តមួយ ឡើ ត្រ ទឹង ប្រម៉ើត យ៉ាគ់ សឋិច ទុត ខាក់ ");
INSERT INTO brb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ឆា ឡើ ខណាត តប៉ឹន ចាក់ ដើ ណាង រៀន៖ «ហំឡា អង់ង៉ាយ កតាម ហឹ អៃ ណាគ់ អន់អាំ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ណាង ឡើ ហាយ តាម ប្រម៉ាង មែគ ណគ ឡើ ប៉្រៃ ឡើ ម៉ាង រៀន៖ «យ៉ាគ់ សឋិច ហន់អាំ ទូះ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ហន់ជុ ប៊ឹង កថាត ហន់ដក់ ឈូន ដើ អៃ ប៊ឹង ណិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","សឋិច ឡើ ដុង ស្រៀវ ប្រយ ពញ៉ង កាន ឡើ ខណាត តប៉ឹន ចាក់ ក្លើច ឡើយ ដើម មែ តមួយ ម៉ើ ដុង លែក រ៉ា ដិ អ៊ែ ឡើ ប៉្រៃ តហាន ណគ បើម តាម អ្រឡា ណាង។ ");
INSERT INTO brb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","អ៊ែ ឡើ ប៉្រៃ តហាន ណគ ដក់ ឆាល់ ដង យ៉ាគ់ យ៉ូហាន ហឹ ឃុក ");
INSERT INTO brb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ទូះ ណគ ម៉ើ ជុ ប៊ឹង កថាត អាំ ដើ ណាង។ អ៊ែ ណាង ឡើ ជឹ ឈូន ប្រយ ហឹ មែគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ប៊្លី អ៊ែ លុកស៊ិក ណគ ម៉ើ ដក់ ចក់ កយ៉ក់ ហឹ ឃុក ម៉ើ ទូង ចះ កុប។ លែវ អ៊ែ ម៉ើ ដក់ ប៉ច កាន នែ ដើ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","គ្រែដៃ យែស៊ូ ឡើ ដុង ប៉ាគ់ អ៊ែ អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ទឺះ ឈិះ ឌូក ដក់ ហឹ ឞន ក្លៀវៗ ចង៉ាយ តើម ប៊ឹង បូវ។ អ៊ែ ណគ់ ដើ មែ ប៉ាសាសុន ម៉ើ ដុង ឡើ វីះ អ៊ែ បនឹះ តើម ប៊ឹង មួង អង់គែងៗ ម៉ើ ឆ្រួយ ណគ តៃ ប៊្រី។ ");
INSERT INTO brb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ទឺះ តើម ប៊ឹង ឌូក ឡើ តៃ បនឹះ ទុត អើន ទិប ហទីប ឡើ បើម ស្រុស្រៀត មែ ទុត ខាក់ ដើម ឡើ បើម អន់នៀម មែ ម៉ើ ឈិ ទឹង បូវ មែ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ដៀប ឡើ អំប៊ឹ ឡើយ មែ លុកស៊ិក ម៉ើ ដក់ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «ប្លះ នែ ឡើ ក្លៀវ ឞាល់ នែ ដើម ម៉ាត់ តង៉ៃ ដៀប ឡើ លុច ឡើយ ឡា ហំប៉្រៃ បូវ មែ នែ មន់ដក់ ដាំង រួត ចណង់ ចណា តាម ស៊្រុក ចើម នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ហាក់ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «សណូវ អ៊ឺម មន់ដក់ ដាំង រួត វែ កឡឹ វន់អាំ ចណង់ ចណា ដើ មែ»។ ");
INSERT INTO brb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ម៉ើ ត្រណើវ រៀន៖ «ហឹ នែ ញឹះ តៃ ញ៉ើ ប៊ិច អង់ង៉ាយ អ៊ឺម ញ៉ើ ប៊ិច វ៉ិះ ឌិវ ណុំពាំង សើង អំប៉ម ដើម ទ្រឺ ច្រាំ បារ អំប៉ម»។ ");
INSERT INTO brb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «វន់ដក់ ចក់ ណុំពាំង ដើម ទ្រឺ វន់អាំ ហឹ អៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","អ៊ែ ឡើ ប៉្រៃ មែ ប៉ាសាសុន មន់ដ្រូម ពឺង បាត់ ឡើ ចក់ ណុំពាំង លែក សើង អំប៉ម ដើម ទ្រឺ ច្រាំ បារ អំប៉ម អ៊ែ ឡើ ង៉ើយ ទឹង គ្រែ ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ កដោះ ណុំពាំង អាំ ដើ មែ លុកស៊ិក។ អ៊ែ មែ លុកស៊ិក ណគ ម៉ើ ប៉ាក អាំ ដើ មែ ប៉ាសាសុន ម៉ើ ចា។ ");
INSERT INTO brb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ម៉ើ ចា ផិ ប៊ិង ត្រំ រ៉ា។ ប៊្លី អ៊ែ បូវ មែ លុកស៊ិក ម៉ើ រ៉ើះ តមួត ចណា ឡើ ស៊ិវ ញឹះ ជិត បារ ហនូក ម៉ាត់តូវ ប៊ិងៗ។ ");
INSERT INTO brb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","លែក ដើ មែ ម៉ើ ចា សើង ហលិក រ៉ា អ្យាង ម៉ើ កាវ ឌិវ មែ កឡ មែ កទ្រី ដើម មែ អង់គ្លែត ម៉ើ កាវ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ហំប៊្រុះ ដើ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កន់សឹត មែ លុកស៊ិក ណគ ទឺះ ឈិះ ឌូក មន់ក្លង អន់នួរ ណគ ពឹះ តៃ តគ់។ អ៊ែ ដើ ណគ លំប៉្រៃ មែ ប៉ាសាសុន មន់ជឹ វឹញ។ ");
INSERT INTO brb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ប៊្លី មែ ប៉ាសាសុន ម៉ើ ជឹ អ៊ែ ដើ ណគ ឡើ ឌឹក អ៊ឺរ ដាំង គ្រែដៃ ទឹង ចន់ឌូ ឡើ គូ ទឹង អ៊ែ មូយ រ៉ា ឆា ដើ ហ្រង៉ូម។ ");
INSERT INTO brb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ទឹង អ៊ែ ឌូក ឡើ ចង៉ាយ ឡើយ តើម ប៊ឹង ពឹះ អ៊ែ ដាក ឡើ អន់ជឺច ផង ដះ ឌូក នែ ម៉ៃៗ យ៉ាក់ កយឺវ ឡើ ពឹក ចន់ដ្រាគ់ ងឺរ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","អ៊ែ តគ់ ដៀប ប្រាង គ្រែដៃ យែស៊ូ ឡើ ដក់ ពឺង កណង ដាក សមុត ហឹ មែ លុកស៊ិក ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","មែ លុកស៊ិក ហំប៊្រុះ ម៉ើ តៃ ណគ ឡើ ដក់ ពឺង កណង ដាក ប៉ាគ់ អ៊ែ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ អន់ឆាក់ យ៉ាង ប្រយ អ៊ែ ម៉ើ ម៉ាង រៀន៖ «កយ៉ក់ ឡើយ អន់តគ់!»។ ម៉ើ ហរ៉ាវ កឡះ ប្រយ យ៉ាក់ ម៉ើ ឌូង ម៉ៃ ហ៊ែត។ ");
INSERT INTO brb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដ្រិះៗ ដើ មែ រៀន៖ «វន់ពឝ៉ិះ ចនិះ វែ ញ៉ង វ៉ើ ឌូង អ៊ឺម អៃ កឡឹ ហវ៉ៃ!»។ ");
INSERT INTO brb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","អ៊ែ ពែត្រុះ ឡើ ម៉ាង រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ប៉ាគ់ ហៃ ម៉ាត់ ម៉ាត ហំប៉្រៃ អៃ អន់ដក់ ហឹ ហៃ ពឺង កណង ដាក ប៉ាគ់ទឺ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ ពែត្រុះ រៀន៖ «ហន់ដក់ ដឹះ»។ អ៊ែ ពែត្រុះ ឡើ ទឺះ តើម ប៊ឹង ឌូក ឡើ ដក់ ប្រយ ពឺង កណង ដាក ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ហាក់ ពែត្រុះ ប៊ឹង ឡើ តៃ កយឺវ ឡើ ពឹក ទុត ខាក់ ឡើ ឌូង ម៉ៃៗ ឡើ ចាំ ក្លាំ ចាំ ក្លាំ ទិ កនុង ដាក អ៊ែ ឡើ កឡូវ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ ហំហវ៉ាត់ អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","គ្រែដៃ យែស៊ូ ឡើ អវ៉ើន ញ៉ាក់ ណគ ដ្រិះៗ អ៊ែ ឡើ ម៉ាង រៀន៖ «អើយ ហៃ តៃ ហហ៊ែត ចាប់ មឹង ប៉ិ ឡើ ត្រ ណាគ់ ហអ៊ឹន ព្រឹះ ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","តគ់ អំប្រា ឌឹក ឈិះ ឌូក ឡើយ អ៊ែ កយឺវ ឡើ ប៉ាត់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","មែ បូវ ម៉ើ គូ ទឹង ឌូក ម៉ើ កដាប ហំបះ គ្រែដៃ យែស៊ូ ម៉ើ ម៉ាង រៀន៖ «ហៃ នែ ហកួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ក្លង ប៊ឹះ ពឹះ តគ់ ឞន ឝែនែសារែត។ ");
INSERT INTO brb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","បូវ មែ ម៉ើ គូ ទឹង អ៊ែ ម៉ើ ហង់ឝ៉ាវ គ្រែដៃ យែស៊ូ អ៊ែ ម៉ើ ដក់ ពហាយ បុ មែ ឈុំ អ៊ែ។ អ៊ែ មែ ប៉ាសាសុន ម៉ើ ដក់ តៀត លែក ដើ មែ ម៉ើ ឈិ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ម៉ើ ឡា ឡូម ហឹ ណគ លែង លំអាំ មន់ដូវ ពឹត ក្រប៊ុយ អាវ ណគ។ អ៊ែ លែក ដើ មែ ង៉ាយ ម៉ើ ដូវ ពឹត ម៉ើ នៀម ត្រំ រ៉ា ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ទឹង អ៊ែ ប៊ិច បូវ មែ ផារីស៊ី ដើម បូវ មែ ណាយឃូ ពង់ហៀន ចឞាប់ តើម ប៊ឹង មួង យែរូសាឡឹម ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ម៉ើ តង៉ា ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ប៉ាគ់ ង៉ាយ ឡើ ត្រ ដើ មែ លុកស៊ិក ហៃ ម៉ើ ឞ៊ឺន ហ៊ីត ខើយ ម៉ិ យ៉ាគ់ ង៉ាយ ឡៃ មាំង ម៉ើ ចង់ ចា តៃ ម៉ើ ដឌូច ទី អន់ដៃ ប៉ាគ់ នែ ?»។ ");
INSERT INTO brb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «ប៉ិ ឡើ ត្រ ដឹះ ដើ វែ វ៉ើ អន់លឺន ចឞាប់ គ្រែដៃ អ៊ែ វ៉ើ ដូវ ចក់ ហ៊ីត ខើយ វែ កឡឹ អន់ណាវ? ");
INSERT INTO brb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","យ៉ាក់ គ្រែដៃ ឡើ ប៉្រៃ រៀន “វន់ខរ៉ុប មែគ បើគ វែ ” ដើម ឡើ រៀន “មែ ង៉ាយ ម៉ើ ផម៉ាត ផម៉ា មែគ បើគ កឡឹ មែ អ៊ែ លំត្រ មន់កជែត ”។ ");
INSERT INTO brb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","អ៊ែ ណគ់ ដើ វែ អន់ណាវ វ៉ើ រៀន ប៉ាគ់ មែ ង៉ាយ ម៉ើ ហាយ ដើ មែគ បើគ កឡឹ រៀន “ណគ់ អង់ង៉ាយ អន់ត្រ អាំ ប៉ូរ សប្រា ហង់អ៊ែ អជុ អាំ ដើ គ្រែដៃ ឡើយ” ");
INSERT INTO brb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","សណូវ យ៉ាវ លន់ត្រ ខរ៉ុប មែគ បើគ។ កាន វ៉ើ ត្រួយ ហ៊ីត ខើយ វែ កឡឹ នែ ឡើយ អ៊ែ វ៉ើ ឝ្លីង ឝ្លាំង រាំង តាក់ ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","អើយ បនឹះ វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ អន់នួរ កាន វែ ទុត ត្រ ឡើយ ឡើ ហាយ រៀន ");
INSERT INTO brb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“បូវ មែ នែ ម៉ើ អៀល បឹះ អៃ វ៉ិះ ដើ បួរ ហាក់ ចនិះ មែ ម៉ើ ចង៉ាយ តើម ប៊ឹង អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ម៉ើ អៀល បឹះ អៃ ញឹះ តៃ ប៊ិច ខា កាន ម៉ើ ពង់ហៀន នែ វ៉ិះ ពន់ដ្រៃ បនឹះ យ៉ះៗ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ប្ល៊ី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កឡូវ មែ ប៉ាសាសុន ដក់ ហឹ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «វន់ចង់ហៀង ម៉ាង អៃ ដើម វន់ឃឹត អាំ ណោះ ហឡាក់ៗ យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ប៊ិច អ៊ឺម ចណា លំមឹត ទឹង បនឹះ លំបើម អាំ បនឹះ តៃ មន់ចាគ់ ស៊ីត ណគ់ ខាក់ៗ ណគ់ អង់ង៉ាយ ឡើ ញឺះ តើម ប៊ឹង បួរ បនឹះ ហង់អ៊ែ ឡើយ ឡើ បើម អាំ បនឹះ តៃ ម៉ើ ចាគ់ ស៊ីត»។ ");
INSERT INTO brb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ប៊្លី អ៊ែ បូវ មែ លុកស៊ិក ម៉ើ ដក់ ហាយ ដើ ណគ ម៉ើ រៀន៖ «បូវ មែ ផារីស៊ី ម៉ើ ដុង ហម៉ាង ប៉ាគ់ អ៊ែ ម៉ើ មាំ ដើ ប្រម៉ាង ហៃ ទុត ខាក់ ហណោះ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ លំទុច ត្រំ តើម ឡង អង់ង៉ាយ ណគ តៃ ឡើ ដាំ។ ");
INSERT INTO brb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ញ៉ង វ៉ើ លវ៉ឹន អ៊ឺម ដើ មែ អ៊ែ ម៉ើ បនឹះ សូត ម៉ើ ទឹក ទី ឈែវ សូត។ ប៉ាគ់ បនឹះ សូត ឡើ ទឹក បនឹះ សូត អំប្រា លំគ្លីះ ឡើយ ទិ ហ៊ុងហាំង»។ ");
INSERT INTO brb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ប្ល៊ី អ៊ែ ពែត្រុះ ឡើ ឡា រៀន៖ «ហំពហាយ ពឡាក់ ដើ ញ៉ា អុះ ណគ់ កាន ហៃ ហម៉ាង ចនីរ អន់ឌូ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ណាគ់ តៃ វ៉ើ ណោះ ហឡាក់ ប៉ាគ់ ដើ មែ ទឺ ឞិ?។ ");
INSERT INTO brb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","អាត វ៉ើ ណោះ ឡើយ រៀន លែក ដើ ចណា ឡើ មឹត តៃ បួរ ឡើ គ្លីះ ទិ ពឌិវ ប៊្លី អ៊ែ ឡើ ញឺះ តៃ អ៊ិច។ ");
INSERT INTO brb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ហាក់ ណគ់ អង់ង៉ាយ ឡើ ញឺះ តើម ប៊ឹង បួរ ឡើ ញឺះ តើម ប៊ឹង ចនិះ ណគ់ ហង់អ៊ែ ឡើយ ឡើ បើម អាំ បនឹះ តៃ ម៉ើ ចាគ់ ស៊ីត។ ");
INSERT INTO brb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","យ៉ាក់ តើម ប៊ឹង ចនិះ ឡើយ កាន លែក នែ ឡើ ញឺះ ប៉ាគ់ ឡើ ខនឹត តៃ ចាគ់ កាន ក្រជែត ក្រណោះ កាន ឡើះ ច្រើន កាន កី ដើ កទ្រី កឡ គែង តើម ប៊ឹង ទ្រី ក្ល តទូង ចចក់ ប៉ច ពយូច បូវ ឆ្រឡិ ដើម ផម៉ាត ផម៉ា បូវ។ ");
INSERT INTO brb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","កាន អ៊ិន ឡើយ ឡើ បើម អាំ បនឹះ តៃ ម៉ើ ចាគ់ ស៊ីត។ ហាក់ ណគ់ កាន ចង់ ចា តៃ ដឌូច ទី ត្រ អ៊ឺម លំបើម អាំ បនឹះ តៃ មន់ចាគ់ ស៊ីត»។ ");
INSERT INTO brb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ហឹ ឞន លមូយ អន់ណាវ ទឹង ស្រុក មួង ទីរ៉ុះ ដើម មួង ស៊ីដូន។ ");
INSERT INTO brb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","អ៊ែ ម៉ិយូ សុនសាត កាណាន មូយ រ៉ា ទឹង ស្រុក ហង់អ៊ែ ឡើ ដក់ ហឹ មែ ឡើ កឡូវ ឡា ឡូម រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ ហកន់ស៊ែ យូ សឋិច ដាវីត ហំស្រុស្រៀត អៃ អុះ! កួន កទ្រី អៃ អរ៉ាក់ ឡើ មឹត ឡើ បើម តំប៉ាប តំពុន ណគ ម៉ៃៗ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","គ្រែដៃ យែស៊ូ ញឹះ តៃ ឡើ ត្រណើវ អ៊ែ បូវ លុកស៊ិក ម៉ើ ដក់ ឡា ហឹ ណគ រៀន៖ «យ៉ាគ់ ណាយឃូ ហំប៉ូរ កទ្រី អន់តគ់ អ៊ែ លំជឹ យ៉ាក់ តាំង ឡើ កឡូវ ឆ្រួយ តៃ ត្រិច ង៉ាយ ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ណគ ឡើ ត្រណើវ រៀន៖ «គ្រែដៃ ឡើ ប៉្រៃ អៃ អដក់ ដាំង វ៉ិះ ឌិវ សុនសាត មែ អ៊ីស្រាអ៊ែល ណគ់ ម៉ើ បើម ប៉ាគ់ ចៀម ហវ៉ារ់ ម៉ើ ចង៉ាយ តើម ប៊ឹង គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ហាក់ យ៉ាគ់ ម៉ិយូ នែ ឡើ ដក់ តគ់ ណគ អ៊ែ ឡើ ជឹះ ត្រកូវ កដាប ហំបះ ប៊ឹង ងឺរ ណគ ឡើ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ហំប៉ូរ អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ណគ ឡើ ត្រណើវ រៀន៖ «ឃឺ អ៊ឺម អន់ចក់ ចណង់ ចណា មែ កួន ចូវ អំពៀវ អាំ ដើ ច មន់ចា»។ ");
INSERT INTO brb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ម៉ិយូ អ៊ែ ឡើ ត្រណើវ រៀន៖ «ដាវ ឡើយ យ៉ាគ់ កន់ដ្រាគ់ ហាក់ ច ណាគ់ ម៉ើ កក្លៀប ក្រលៀត ឡើ គ្លីះ តើម ប៊ឹង តូក កន់ដ្រាគ់ មែ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «មីក អើយ ហចាប់ មឹង ទុត ខាក់ ឡើយ ប៉ាគ់ ពអ៊ែ អាំ លំដាវ តាម ប៉ាគ់ អ្រឡា ហៃ ឆិ»។ ហំប៊្រុះ ដើ អ៊ែ កួន កទ្រី ណគ ហឹ ហន់ណាម ឡើ នៀម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ បរ ពឹះ សមុត ឝ៉ាលីលែ។ ប្ល៊ី អ៊ែ ឡើ ឌឹក ទឹង ចន់ឌូ អ៊ែ ឡើ ដ្រូម ប៊ឹង អិះ ប្រយ ");
INSERT INTO brb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","មែ ប៉ាសាសុន ទុត អើន ម៉ើ ដក់ ហឹ ណគ ដើម ម៉ើ តៀត បនឹះ ញ៉ច ឈឹង ទី បនឹះ សូត ម៉ាត់ បនឹះ កន់ចក បនឹះ កំប្ល ដើម បនឹះ ឈិ ដិ អន់ដិ ទុត អើន ម៉ើ ដក់ ជុ ប៊ឹង ងឺរ គ្រែដៃ យែស៊ូ អ៊ែ ឡើ ពនៀម ប្រយ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ហំប្រ៊ុះ មែ ប៉ាសាសុន ម៉ើ តៃ បនឹះ កំប្ល ម៉ើ ណោះ ម៉ាង បនឹះ កន់ចក ម៉ើ ចាគ់ នៀម បនឹះ ញ៉ច ឈឹង ម៉ើ បក់ ដក់ បនឹះ សូត ម៉ើ ត្រប៉ៃ អ៊ែ តូវ ម៉ើ បើម ញ៉ម ប្រយ ដើម ម៉ើ ព្រតឹះ ព្រនែ គ្រែដៃ ឡើ កន់ដ្រាគ់ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO brb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កឡូវ មែ លុកស៊ិក ណគ ឡើ ហាយ ដើ មែ រៀន៖ «អស្រុស្រៀត មែ ប៉ាសាសុន នែ ឞាល់ អ៊ិន យ៉ាក់ ម៉ើ គូ អរែង ប៊ឹង អៃ ញឹះ ពែ តង៉ៃ ណិះ ឡើយ ដើម ម៉ើ ប៊ិច អ៊ឺម ចណង់ ចណា។ អឌី អ៊ឺម អំប៉្រៃ មន់ជឹ វឹញ កអឹតៗ កឡាគ់ មន់សូវ អ៊ឺម មន់បង់ ប៉្រះ តៃ ទ្រូង»។ ");
INSERT INTO brb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","មែ លុកស៊ិក ម៉ើ ត្រណើវ រៀន៖ «ប្លះ ក្លៀវៗ ឞាល់ នែ ហឹ ង៉ាយ ឋឹះ ងន់ដូវ ដាំង ចណង់ ចណា ដើ មែ ប៉ាសាសុន ទុត អើន ឞាល់ នែ ឆិ មន់ផិ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «វ៉ើ ប៊ិច ណុំពាំង ស៊ិ អំប៉ម?» ម៉ើ ត្រណើវ រៀន៖ «ប៉ឹះ អំប៉ម ដើម ទ្រឺ គ្លិត អង់គ្លែត វ៉ិះ កិៗ»។ ");
INSERT INTO brb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","អ៊ែ ឡើ ប៉្រៃ មែ ប៉ាសាសុន មន់ដ្រូម ប៊ឹង ប្រិះ ");
INSERT INTO brb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ឡើ ចក់ ណុំពាំង ប៉ឹះ អំប៉ម ដើម ទ្រឺ ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប្ល៊ី អ៊ែ ឡើ កដោះ អាំ ដើ មែ លុកស៊ិក ណគ មែ លុកស៊ិក ម៉ើ ប៉ាក អាំ ដើ ប៉ាសាសុន។ ");
INSERT INTO brb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ប៊្លី ម៉ើ ចា ផិ ប៊ិង លែក រ៉ា ឡើយ មែ លុកស៊ិក ម៉ើ តមួត ចណា ណគ់ ឡើ ស៊ិវ ណាគ់ ប៉ឹះ ហនូក ប៊ិងៗ។ ");
INSERT INTO brb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ណគ់ មែ ម៉ើ ចង់ ចា អ៊ែ ឡើ ប៊ិច ពួន ហលិក រ៉ា ម៉ើ កាវ ឌិវ មែ កឡ ម៉ើ កាវ អ៊ឺម មែ កទ្រី ដើម មែ អង់គ្លែត។ ");
INSERT INTO brb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ប៊្លី គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ ប៉ាសាសុន ម៉ើ ជឹ វឹញ អ៊ែ ឡើ ទឺះ ឈិះ ឌូក ក្លង ដក់ ហឹ ឞន ម៉ាឝ៉ាដាន។ ");
INSERT INTO brb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ទឹង អ៊ែ ប៊ិច បូវ មែ ផារីស៊ី ដើម បូវ មែ សាឌូស៊ី ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ម៉ើ ងុញ បឡង ឝ្លាំង ណគ។ ម៉ើ ឡា ហឹ ណគ លំពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ តើម ទិ ហូង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ហាក់ គ្រែដៃ យែស៊ូ ឡើ តើវ ម៉ាង មែ ឡើ រៀន៖ «ប៊ឹ អំប៊ឹ ប៉ាគ់ វ៉ើ តៃ ឌុំ អារ វ៉ើ រៀន ប្រណូវ លំព្រាំង ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","តគ់ ងឹប ប្រណូវ ប៉ាគ់ វ៉ើ តៃ យូក ឡើ អយូង តូវ ឡើ ងៀវ អ៊ែ វ៉ើ រៀន តង៉ៃ នែ លំអំមឺ ឡើយ។ ប៊ឹង វ៉ើ ឝ្លាំង ទឹង គ្រែ កាន អំមឺ ដុ ណាគ់ វ៉ើ ណោះ ហង់ឝ៉ាវ ពយ៉ិ ដឹះ តៃ វ៉ើ ហង់ឝ៉ាវ អ៊ឺម កាន ឡើ កើត ទឹង ប៉ាង អន់នែ! ");
INSERT INTO brb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","បនឹះ ប៉ាង ណិះៗ ញឹះ តៃ ម៉ើ ចាគ់ ឡាំងៗ ដើម តៃ ម៉ើ ទឹង ត្រ ដើ គ្រែដៃ ដិ ម៉ើ ងុញ តៃ កាន ហឝ៉ាវ ឆង៉ាត់ ហាក់ គ្រែដៃ លំពដៃ អ៊ឺម កាន ហង់ឝ៉ាវ ឆង៉ាត់ គែង តើម ប៊ឹង កាន ហឝ៉ាវ ឆង៉ាត់ ឡើ បើម ប៊ឹង យ៉ាគ់ យ៉ូណះ»។ ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង មែ។ ");
INSERT INTO brb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ប៊ឹង ម៉ើ ក្លង ដាក សមុត មែ លុកស៊ិក ម៉ើ វឺញ តៀត ណុំពាំង។ ");
INSERT INTO brb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","គ្រែដៃ យែស៊ូ ឡើ ថាន់ មែ រៀន៖ «វន់លវាំង អាំ ខាក់ៗ យ៉ឹ ដើ ប៊ូះ បូវ មែ ផារីស៊ី ដើម ប៊ូះ បូវ មែ សាឌូស៊ី»។ ");
INSERT INTO brb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","អ៊ែ បូវ លុកស៊ិក ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ឡើ ម៉ាង ប៉ាគ់ អ៊ិន ញ៉ន តៃ ង៉ើ តៀត ណុំពាំង តៃ ណោះ»។ ");
INSERT INTO brb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","គ្រែដៃ យែស៊ូ ឡើ ណោះ កាន មែ ម៉ើ ចជែ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «បនឹះ តៃ ហ៊ែត ចាប់ មឹង អើយ ពយ៉ិ ឡើ ត្រ វ៉ើ ចជែ កាន តៃ វ៉ើ ប៊ិច ណុំពាំង ប៉ាគ់ អ៊ិន? ");
INSERT INTO brb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ណាគ់ តៃ វ៉ើ ហឝ៉ាវ ហឡាក់ អំម៉ឹះ ឡះ? ប៊ឹង អប៉ាក ណុំពាំង សើង អំប៉ម អអាំ ដើ បនឹះ សើង ហលិក រ៉ា ម៉ើ ចា តគ់ វ៉ើ តមួត ណាគ់ ស៊ិ ហនូក វ៉ើ តៃ ឡើ ស៊ិវ ណាគ់ វ៉ើ កាំ ឡះ? ");
INSERT INTO brb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ប៊ឹង អប៉ាក ណុំពាំង ប៉ឹះ អំប៉ម អអាំ ដើ បនឹះ ពួន ហលិក រ៉ា តគ់ វ៉ើ តមួត ណាគ់ ស៊ិ កតា វ៉ើ តៃ ឡើ ស៊ិវ? ");
INSERT INTO brb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ពយ៉ិ ឡើ ត្រ តៃ វ៉ើ ហឝ៉ាវ ហឡាក់ ប៉ាគ់ នែ អចជែ អ៊ឺម ហវ៉ៃ កាន ណុំពាំង ប៊ឹង អថាន់ វែ អន់ឌូ អប៉្រៃ “វន់លវាំង ដើ ប៊ូះ បូវ ផារីស៊ី ដើម ដើ ប៊ូះ បូវ សាឌូស៊ី”»។ ");
INSERT INTO brb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","តគ់ ហន់ដើម អ៊ែ អ៊ែ ម៉ើ ណោះ ហឡាក់ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ លវាំង ដើ កាន បូវ ផារីស៊ី ដើម បូវ មែ សាឌូស៊ី ម៉ើ ពង់ហៀន ត្រ អ៊ឺម ឡើ ប៉្រៃ មន់លវាំង ដើ ប៊ូះ ម៉ើ ចិះ ទឹង ណុំពាំង។ ");
INSERT INTO brb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","តគ់ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ ឞន មូយ ចើម មួង ស៊ែសារែ ភីលីប  អ៊ែ ឡើ តង៉ា មែ លុកស៊ិក ណគ រៀន៖ «មែ ប៉ាសាសុន ម៉ើ ជុ កួន បនឹះ ឡើ មែ ង៉ាយ?»។ ");
INSERT INTO brb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","មែ ម៉ើ ត្រណើវ រៀន៖ «មែ អន់នឺ ម៉ើ រៀន “យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក” មែ អន់នឺ ម៉ើ រៀន “យ៉ាគ់ អ៊ែលីយ៉ា” មែ អន់នឺ អន់ណាវ ម៉ើ រៀន “យ៉ាគ់ យែរែមៀ លឺ កឡា ឈូន ប្រម៉ាង គ្រែដៃ គែង បូវ មែ អ៊ែ”»។ ");
INSERT INTO brb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ លុកស៊ិក ណគ អន់ណាវ រៀន៖ «ដើ វែ ដឹះ អង់ង៉ាយ វ៉ើ ជុ អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","យ៉ាគ់ ស៊ីម៉ូន ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «ហៃ ហគ្រែដៃ គ្រិះ កួន កឡ គ្រែដៃ គ្រែដៃ អ៊ិន ឡើយ ឡើ ញិវ អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ស៊ីម៉ូន កួន យ៉ាគ់ យ៉ូណះ អើយ ហៃ ហហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ ហណោះ កាន នែ ត្រ អ៊ឺម តើម ប៊ឹង អ្រណោះ បនឹះ គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ ទិ ឡើ អាំ ដើ ហៃ ហណោះ។ ");
INSERT INTO brb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","អៃ អង់ហាយ ដើ ហៃ រៀន ហៃ នែ ពែត្រុះ ប៊ិច នឿណៃ រៀន “តម៉” ពឺង តម៉ ដដារ នែ ឡើយ អំពឝ៉ើត ក្រំ ឆនុំ អៃ។ ហមយ៉ះ កាន គែត ណាគ់ តៃ លំប៊ិច អ៊ឺម អាតណាត តប៉ាត់ ក្រំ ឆនុំ។ ");
INSERT INTO brb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","អៃ អង់អាំ កួន កជែ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដើ ហៃ។ ណគ់ អង់ង៉ាយៗ ហៃ ហចង ទិ ឡាង ប្រិះ នែ គ្រែដៃ ឡើ ចង លែវ ឡើយ ប៉ាគ់ទឺ ទឹង ហូង គ្រែ ទិ អ៊ែ ណគ់ អង់ង៉ាយៗ ហៃ ហឡិះ ទិ ឡាង ប្រិះ នែ គ្រែដៃ ឡើ ឡិះ លែវ ឡើយ ប៉ាគ់ទឺ ទឹង ហូង គ្រែ ទិ»។ ");
INSERT INTO brb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កំប៊ែត ទុត ខាក់ មែ លុកស៊ិក ណគ ញ៉ង មន់ហាយ ដើ មែ គែង មន់ណោះ រៀន ណគ ឡើ គ្រែដៃ គ្រិះ។ ");
INSERT INTO brb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","តើម ប៊ឹង តង៉ៃ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពហាយ ពឡាក់ ដើ លុកស៊ិក ណគ រៀន លំត្រ ដក់ ហឹ មួង យែរូសាឡឹម។ ហឹ អ៊ែ បូវ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ណាយឃូ ពង់ហៀន ចឞាប់ មន់ពធុក ពញ៉ាក បើម អាំ លំចា ឈិ ដុ ទុត អើន ដើម មន់កជែត ដិ ណគ តគ់ តង៉ៃ ទី ពែ លំញិវ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","យ៉ាគ់ ពែត្រុះ ឡើ ច្រា គ្រែដៃ យែស៊ូ ចវីះ តើម ប៊ឹង មែ ឞិត ឞ៊ែត អ៊ែ ឡើ គឹះ ណគ រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ឡា គ្រែដៃ ញ៉ង អាំ កាន អ៊ិន លំកើត ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ហឹ យ៉ាគ់ ពែត្រុះ អ៊ែ ឡើ ម៉ាង រៀន៖ «ញ៉ង ហម៉ាង អ៊ឺម ប៉ាគ់ អ៊ិន អរ៉ាក់ សតាំង ហំវីះ ញ៉ង ហកន់ឌឹង អ៊ឺម ទ្រូង អៃ អន់ត្រ ដក់ ខនឹត ហៃ ឡើ ត្រ អ៊ឺម ខនឹត គ្រែដៃ ឡើ ត្រ ខនឹត បនឹះ មិៗ»។ ");
INSERT INTO brb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ លុកស៊ិក ណគ រៀន៖ «ប៉ាគ់ មែ ង៉ាយ ម៉ើ ងុញ ដក់ តូយ អៃ តង មន់តាក់ ឃឹត ដើ ចាក់ មែ កឡឹ មន់កួយ ឡង អង់ឝ៉ាង មែ កឡឹ អ៊ែ មន់ដក់ តូយ អៃ ");
INSERT INTO brb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","យ៉ាក់ ណគ់ មែ ង៉ាយ ម៉ើ ខំ ដាំង អាំ ញិវ មែ អ៊ែ មន់គែត ប៉ាត់ ពណាត់ ឡើយ ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ឌី តាក់ កាន ញិវ មែ ញ៉ន ដើ អៃ មែ អ៊ែ ឡើយ មន់ញិវ។ ");
INSERT INTO brb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ប៉ាគ់ បនឹះ មូយ រ៉ា លំដូវ ចក់ លែក ដើ ឡាង ប្រិះ នែ លំជុ លំបើម មូន ដើ ណគ កឡឹ ហាក់ តគ់ លំគែត តៃ លំប៊ិច កាន ញិវ ឡូច អន់សច អង់ង៉ាយ លំខា ដើ ណគ? តៃ ប៊ិច ដើ ង៉ាយ អ៊ឺម បនឹះ មន់ដូវ វ៉ាក់ អ៊ែ មន់ដូវ ញិវ ឡូច អន់សច។ ");
INSERT INTO brb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","អៃ អហាយ កាន លែក នែ ដើ វែ យ៉ាក់ តគ់ កួន បនឹះ លំប៊ឹះ អរែង ដើ ឞាវ គ្រែដៃ លំប៊ិច កាន អូងអាត លំឝ៉ាល តើម ប៊ឹង បើគ ណគ តគ់ តង៉ៃ ហង់អ៊ិន កួន បនឹះ លំឡាប់ លែក ដើ បនឹះ តាម ប៉ាគ់ មែ ម៉ើ បើម មូយ រ៉ាៗ។ ");
INSERT INTO brb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន មែ អន់នឺ ណគ់ ម៉ើ គូ ប៊ឹង នែ មន់គែត អំម៉ឹះ ឋា ដើ មន់តៃ កួន បនឹះ លំប៊ឹះ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","តើម ប៊ឹង អ៊ែ ត្រូវ តង៉ៃ គ្រែដៃ យែស៊ូ ឡើ ច្រា យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ាកុប ដើម យ៉ាគ់ យ៉ូហាន អោះ យ៉ាកុប ម៉ើ ឌឹក ទឹង ចន់ឌូ ទុត ឈ្រូង ដិៗ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ម៉ើ ប៊ឹះ ទិ អ៊ែ ប៊ឹង ងឺរ មែ ម៉ើ តៃ ចាក់ ដៃ គ្រែដៃ យែស៊ូ ឡើ វឹរ ដិៗ អន់ណាវ មុះ ម៉ាត់ ណគ តូវ ឡើ ឝ៉ាល ចាល់ ឞាល់ ម៉ាត់ តង៉ៃ ណគ់ ដ្រុនឌ្រូប ហណក ណគ ឡើ វឹរ បក់បក តូវ ឡើ ឝ៉ាល ចាល់។ ");
INSERT INTO brb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ប៊ឹង អ៊ែ មែ លុកស៊ិក កអវ ម៉ើ តៃ យ៉ាគ់ ម៉ូស៊ែ ដើម យ៉ាគ់ អ៊ែលីយ៉ា អំប្រា ចជែ ប៊ឹង គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","យ៉ាគ់ ពែត្រុះ ឡើ ហាយ ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ ង៉ាយ ង៉ើ គូ ប៊ឹង នែ ចាគ់ ឡើយ ប៉ាគ់ ហំឌី អំបើម កទូប ពែ មូយ ដើ ហៃ មូយ ដើ យ៉ាគ់ ម៉ូស៊ែ មូយ ឡឹះ អន់ណាវ ដើ យ៉ាគ់ អ៊ែលីយ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ទឹង យ៉ាគ់ ពែត្រុះ ឡើ ម៉ាង តៃ ដាន់ ឡូច កអវ ឡើ ប៊ិច យូក ឝ៉ាល់ឝ៉ាល ឡើ អន់លឹប មែ អ៊ែ ម៉ើ ដុង ប្រម៉ាង តើម ប៊ឹង យូក ឡើ រៀន៖ «អន់នែ ឡើយ កួន កឡ ប្រម៉ើត អៃ អញឹម ក្លើម ដើ ណគ ទុត ខាក់ វន់ចង់ហៀង យ៉ឹ ម៉ាង ណគ!»។ ");
INSERT INTO brb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","មែ លុកស៊ិក ម៉ើ ដុង ប៉ាគ់ អ៊ែ តូវ ម៉ើ ឌូង អ៊ែ ម៉ើ កដាប ហំបះ ត្រងឺវ ទូត ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ពឹត មែ ដើម ឡើ ម៉ាង រៀន៖ «វន់ឌឹក ហំមិញ ញ៉ង វ៉ើ ឌូង អ៊ឺម!»។ ");
INSERT INTO brb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ហំប៊្រុះ បូវ លុកស៊ិក ម៉ើ ប៊្រឹក ម៉ាត់ ម៉ើ តៃ យ៉ាវ អំប្រា ម៉ើ តៃ វ៉ិះ ឌិវ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ទឹង ម៉ើ ទឺះ តើម ទិ ចន់ឌូ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ថាន់ មែ រៀន៖ «ណគ់ កាន វែ វ៉ើ តៃ អន់ឌូ ញ៉ង វ៉ើ ប៉ច អ៊ឺម ដើ មែ ង៉ាយ យ៉ឹ ឋា ដើ ប៊ឹះ កួន បនឹះ លំញិវ ឡឹះ តើម ប៊ឹង គែត»។ ");
INSERT INTO brb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","បូវ មែ លុកស៊ិក ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ញ៉ន ង៉ាយ អ៊ែ ឡើ ត្រ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ រៀន យ៉ាគ់ អ៊ែលីយ៉ា លំត្រ ប៊ឹះ អន់នួរ គ្រែដៃ គ្រិះ?» ");
INSERT INTO brb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ឡើ ត្រណើវ រៀន៖ «ដាវ ឡើយ យ៉ាគ់ អ៊ែលីយ៉ា លំត្រ ប៊ឹះ អន់នួរ បក់ លំពចាគ់ លែក ដើ កាន អាំ ត្រៗ ប៉ាគ់ ពន់ឋើម ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","អៃ អំហាយ ដើ វែ រៀន យ៉ាគ់ អ៊ែលីយ៉ា អ៊ិន ឡើ ប៊ឹះ ឡើយ ហាក់ តៃ ម៉ើ ហង់ឝ៉ាវ អ៊ឺម ណគ ឡើ មែ ង៉ាយ ដើម ម៉ើ តំឞាប ណគ តាម ប្រម៉ើត មែ ត្រំ ហំឞ្លិច។ អ៊ែ ណគ់ កួន បនឹះ លំត្រ មន់តំឞាប ប៉ាគ់ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ទឹង អ៊ែ មែ លុកស៊ិក ម៉ើ ណោះ ហឡាក់ រៀន គ្រែដៃ យែស៊ូ ឡើ ចជែ កាន យ៉ូហាន តម៉ូច ដាក។ ");
INSERT INTO brb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ទឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ពែ រ៉ា ម៉ើ ប៊ឹះ ហឹ ឞន មែ ប៉ាសាសុន ម៉ើ តមួត ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ឡើ ជឹះ ត្រកូវ កដាប ហំបះ ប៊ឹង ងឺរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ឡើ ម៉ាង រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ ហំស្រុស្រៀត កួន កឡ អៃ ដិ អុះ ឡើ វិត ជុរ ឡើ ឈិ ម៉ៃៗ ឡើ បង់ ទឹង អ៊ុញ ដើម ទិ ដាក ឆិញៗ។ ");
INSERT INTO brb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","អតៀត ឡើយ ណគ ហឹ មែ លុកស៊ិក ហៃ ហាក់ ម៉ើ បើម អន់វីះ អ៊ឺម អរ៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ មែ រៀន៖ «អើយ បនឹះ ប៉ាង ណិះៗ តៃ វ៉ើ ឌី ចាប់ មឹង គ្រែដៃ ដើម វ៉ើ ចនិះ តៃ ចាគ់! ណាគ់ ឌុញ ឞាល់ ង៉ាយ ដឹះ លំត្រ អំគូ ប៊ឹង វែ? ណាគ់ ឌុញ ឞាល់ ង៉ាយ ដឹះ អន់ត្រ ប៉ឹន ក្លើម ដើ វែ? មិញ វន់តៀត អង់គ្លែត អ៊ែ ហឹ អៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ក្រាគ់ ដើ អរ៉ាក់ អ៊ែ អរ៉ាក់ ឡើ វីះ តើម ប៊ឹង អង់គ្លែត ហំប៊្រុះ ដើ អ៊ែ អង់គ្លែត នែ ឡើ នៀម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","តគ់ ម៉ើ ចង៉ាយ តើម ប៊ឹង បូវ ឡើយ អ៊ែ មែ លុកស៊ិក ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ឌិវ មែ ម៉ើ តង៉ា ណគ រៀន៖ «ប៉ាគ់ ង៉ាយ អិះ ឡើ ត្រ ដើ ញ៉ា ញ៉ើ ដូវ អ៊ឺម ពន់ឌ្រុះ អរ៉ាក់ អន់នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «យ៉ាក់ តៃ ហ៊ែត វ៉ើ ចាប់ មឹង។ ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ វន់ចាប់ មឹង គ្រែដៃ ហមយ៉ះ កិៗ វ៉ិះ ឌិត អង់គុង ក្លិត គ្លែត វន់ប៉្រៃ ចន់ឌូ អ៊ែ រៀន “ហំវីះ តើម ប៊ឹង ឞន អន់នែ ហន់ដក់ គូ ហឹ តគ់” អ៊ែ ចន់ឌូ លំដក់ គូ ហឹ អ៊ែ ម៉ាត់ ម៉ាត។ តៃ ប៊ិច កាន អង់ង៉ាយ អ៊ឺម វន់បើម តៃ ដូវ។ ");
INSERT INTO brb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ណគ់ អរ៉ាក់ ប៉ាគ់ នែ ដូវ អ៊ឺម វន់ពន់ឌ្រុះ តៃ កា វន់អ៊ឺរ ដាំង គ្រែដៃ ដើម វន់អឹត ចណង់ ចណា អ៊ែ វន់ដូវ»។ ");
INSERT INTO brb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ទឹង មែ លុកស៊ិក ម៉ើ ពទុំ អរែង ទឹង ស្រុក ឝ៉ាលីលែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «កួន បនឹះ ដៀប លន់ត្រ មន់ឈូន ហឹ ទី មែ ដ្រម៉ា។ ");
INSERT INTO brb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","មន់កជែត ណគ តគ់ តង៉ៃ ទី ពែ លំញិវ ឡឹះ អន់ណាវ»។ មែ លុកស៊ិក ណគ ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ ឝ្រង៉ឹត ស្រូក ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ដើម មែ លុកស៊ិក ណគ ម៉ើ ប៊ឹះ មួង កាផារនុំ មែ កឡា ក្រសៀក លៀន ដើ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ  ម៉ើ ដក់ ហឹ យ៉ាគ់ ពែត្រុះ ម៉ើ តង៉ា ណគ រៀន៖ «ណាយឃូ វែ ណាគ់ ឡើ កគ់ អាំ ឡះ លៀន ដើ មែ ម៉ើ ក្រសៀក?»។ ");
INSERT INTO brb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ឡើ ត្រណើវ រៀន៖ «អ៊ឺគ ឡើ អាំ»។ តគ់ យ៉ាគ់ ពែត្រុះ ឡើ ប៊ឹះ ហឹ ហន់ណាម តៃ ដាន់ ឡើ ហាយ អំម៉ឹះ គ្រែដៃ យែស៊ូ ឡើ តង៉ា អន់នួរ ណគ រៀន៖ «ស៊ីម៉ូន ប៉ាគ់ ង៉ាយ ដើ ហៃ ហឃឹត សឋិច ទិ ឡាង ប្រិះ នែ ម៉ើ កាគ់ លៀន តើម ប៊ឹង មែ ង៉ាយ? តើម ប៊ឹង កួន ចូវ មែ កឡឹ លឺ តើម ប៊ឹង មែ គែង?»។ ");
INSERT INTO brb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «តើម ប៊ឹង មែ គែង»។ គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «ដាវ ឡើយ។ ប៉ាគ់ ពអ៊ែ មែ កួន ចូវ សឋិច ម៉ើ ក្លើច តើម ប៊ឹង កាន អាំ លៀន ដើ មែ ម៉ើ កាគ់ ");
INSERT INTO brb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ហាក់ ញ៉ង អាំ មន់មាំ ដើ បា ហន់ទឺះ អន់សាយ ទិ សមុត ចុ អ៊ែ ហន់ចក់ ទ្រឺ ណគ់ ហៃ ហន់ដូវ អន់នួរៗ ហំពហា បួរ ណគ អ៊ែ ហន់តៃ កាក់ ហន់ចក់ ដក់ អាំ ហឹ មែ ដើ បា!»។ ");
INSERT INTO brb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ប៊ឹង អ៊ែ បូវ មែ លុកស៊ិក ម៉ើ ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ទឹង បូវ មែ ណគ់ គ្រែដៃ ឡើ ពែក ប៉ាក់ មែ ង៉ាយ អិះ ឡើ ទិះ ជឺរ?» ");
INSERT INTO brb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","គ្រែដៃ យែស៊ូ ឡើ កឡូវ អង់គ្លែត មូយ រ៉ា ប៉្រៃ ដក់ ឆុង ទឹង កឌី មែ លុកស៊ិក ");
INSERT INTO brb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អំហាយ ដើ វែ រៀន ប៉ាគ់ តៃ វន់ពលិះ ចនិះ វែ អាំ ប៉ាគ់ មែ អង់គ្លែត ដូវ អ៊ឺម វន់មឹត ទឹង បូវ គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ញ៉ន អ៊ែ ឡើយ ណគ់ មែ ង៉ាយ មន់ពន់ដាប ចាក់ អាំ ប៉ាគ់ អង់គ្លែត នែ មែ អ៊ែ ឡើយ មន់ទិះ ជឺរ ទឹង បូវ គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ ឡាប់ អង់គ្លែត មូយ រ៉ា ឌិត អង់គ្លែត នែ ញ៉ន ម៉ើ តូយ អៃ មែ អ៊ែ ម៉ើ ឡាប់ អៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«ហាក់ ប៉ាគ់ ប៊ិច បនឹះ មូយ រ៉ា លំច្រា ណគ់ មែ ម៉ើ ចាប់ មឹង អៃ មន់បើម កាន យូច ហមយ៉ះ មែ ម៉ើ ចាប់ នែ ម៉ើ កិ ហឡាប ដាប ហឡង់ តមឹង ណគ អ៊ែ ណាគ់ ហយ មន់ចក់ តម៉ កណិន ទុត ទិះ ចង ប៊ឹង ដង់ កលីះ ទិ ក្លង់ សមុត អាំ លំឡូប គែត អ៊ែ លំចាគ់ ជឺរ ហំប្លះ លំញិវ ឝ៉ាន់ លំច្រា មែ មន់បើម កាន យូច! ");
INSERT INTO brb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","បនឹះ ទិ ឡាង ប្រិះ មន់ធុក ញ៉ាក ឡើយ យ៉ាក់ ឡើ ប៊ិច កាន ទុត អើន ឡើ តៀត មែ បើម កាន យូច។ កាន លែក អ៊ែ តង លំប៊ិច ម៉ាត់ ម៉ាត វៀរ តៃ ក្លើច អ៊ឺម ហាក់ ណគ់ មែ ង៉ាយ មន់ច្រា បូវ បើម កាន យូច មែ អ៊ែ មន់ធុក ញ៉ាក ឡើយ!» ");
INSERT INTO brb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«ប៉ាគ់ ទី លឺ ឈឹង ហៃ លំច្រា ហៃ បើម កាន យូច ហំឆាល់ ពៀវ តាក់ អាំ ចង៉ាយ ណាគ់ ហយ ហំប៊ិច ទី លឺ ឈឹង ឌិវ មូយ ច្រះ ដើម ហំប៊ិច ឆ្រញិវ ឡូច អន់សច លំចាគ់ ជឺរ ហំប្លះ ហំប៊ិច ទី ឈឹង លែក បារ ច្រះ ដើម ហំគ្លីះ ទិ អ៊ុញ ឡើ កាត ញឹះ តៃ ណោះ ប៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ប៉ាគ់ ម៉ាត់ ហៃ លំច្រា ហៃ បើម កាន យូច ហំឝ៉ិច ពៀវ តាក់ អាំ ចង៉ាយ ណាគ់ ហយ ហំប៊ិច ម៉ាត់ វ៉ិះ ឌិវ មូយ ច្រះ ដើម ហំប៊ិច ឆ្រញិវ ឡូច អន់សច លំចាគ់ ជឺរ ហំប្លះ ហំប៊ិច ម៉ាត់ លែក បារ ច្រះ ដើម ហំគ្លីះ ទិ ហួម អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«តង វន់លវាំង ញ៉ង វ៉ើ ប៊ែត អ៊ឺម ណគ់ មែ ម៉ើ កិ ហឡាប ដាប ហឡង់ អន់នែ។ អៃ អង់ហាយ ដើ វែ រៀន ទឹង ហូង គ្រែ ឞាវ គ្រែ មែ កិ ហឡាប ដាប ហឡង់ ម៉ើ ប៉ច អន់សច ដើ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","យ៉ាក់ កួន បនឹះ ឡើ ទឺះ ហវ៉ាត់ បនឹះ ណគ់ ម៉ើ ហវ៉ារ់ ប៉ាត់ »។ ");
INSERT INTO brb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«ប៉ាគ់ ង៉ាយ វ៉ើ ឃឹត ប៉ាគ់ ប៊ិច កឡ មូយ រ៉ា លំប៊ិច ចៀម មូយ ក្លាំ ចៀម ណគ មូយ អំប៉ម លំហវ៉ារ់ ប៉ាគ់ ង៉ាយ លំបើម? អាត លំជុ ចៀម ណគ ជែន ជិត ជែន អំប៉ម អ៊ែ ទឹង ចន់ឌូ ប៊្លី អ៊ែ លំដក់ សាត ចៀម ណគ់ ឡើ ហវ៉ារ់។ ");
INSERT INTO brb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ដាវ ម៉ាត់ ម៉ាត អៃ អំហាយ ដើ វែ រៀន ប៉ាគ់ លំតៃ ចៀម ណគ ណគ់ ឡើ ហវ៉ារ់ លំញឹម ក្លើម ដើ ចៀម អន់នែ ជឺរ ដើ ចៀម ណគ ជែន ជិត ជែន អំប៉ម ណគ់ តៃ ម៉ើ ហវ៉ារ់ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ប៉ាគ់ទឺ ឡើយ ដើ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ ទិ ឡើ ងុញ អ៊ឺម ណគ់ មែ ម៉ើ កិ ហឡាប ដាប ហឡង់ ហមយ៉ះ មូយ រ៉ា មន់គែត ប៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«ប៉ាគ់ ទឹង បូវ ម៉ើ ចាប់ គ្រែដៃ ប៊ិច មូយ រ៉ា លំបើម អន់យូច ដើ ហៃ ហន់ដក់ គឹះ ព្រតូវ ណគ ម៉ាត់ សប្រា កឡឹ។ ប៉ាគ់ លំចង់ហៀង ហៃ អ៊ែ ណាគ់ សប្រា លំហំពែម អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ហាក់ ប៉ាគ់ ណគ តៃ លំឌី ចង់ហៀង ម៉ាង ហៃ ហំច្រា មូយ លឺ បារ រ៉ា អន់ណាវ លំដក់ អរែង ប៊ឹង ហៃ បក់ លំត្រ តាម ប៉ាគ់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ខៀន ជុ រៀន ត្រំ ម៉ើ តាត់ កឍី តង លំប៊ិច កឡា ដុង បារ ដាំង ពែ រ៉ា ។ ");
INSERT INTO brb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ប៉ាគ់ ណាគ់ តៃ លំឌី ចង់ហៀង ដឌែ ហន់ដក់ ហាយ កាន នែ ហឹ មែ ក្រំ ឆនុំ ប៉ាគ់ តៃ លំចង់ហៀង ប្រម៉ាង ក្រំ ឆនុំ ហន់ជុ ណគ ប៉ាគ់ បនឹះ សុនសាត គែង តៃ ម៉ើ ហឝ៉ាវ គ្រែដៃ លឺ បនឹះ ប៊ិច ឞាប។ ");
INSERT INTO brb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ដាវ ម៉ាត់ ម៉ាត អៃ អំហាយ ដើ វែ រៀន ណគ់ អង់ង៉ាយៗ វែ វ៉ើ ចង ទិ ឡាង ប្រិះ នែ គ្រែដៃ ឡើ ចង លែវ ឡើយ ប៉ាគ់ទឺ ទឹង ហូង គ្រែ ទិ អ៊ែ ណគ់ អង់ង៉ាយៗ វែ វ៉ើ ឡិះ ទិ ឡាង ប្រិះ នែ គ្រែដៃ ឡើ ឡិះ លែវ ឡើយ ប៉ាគ់ទឺ ទឹង ហូង គ្រែ ទិ។ ");
INSERT INTO brb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","អៃ អង់ហាយ មូយ អន់ណាវ ដើ វែ ណគ់ ត្រៗ ទឹង បូវ វែ ប៉ាគ់ ប៊ិច បារ រ៉ា ទិ ឡាង ប្រិះ នែ អំប្រា លំតមួត ចនិះ អ៊ឺរ ដាំង គ្រែដៃ ឡា កាន អង់ង៉ាយ កតាម ហឹ ណគ គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ ទិ លំអាំ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ហឹ ង៉ាយ កតាម ប៉ាគ់ ប៊ិច បារ ពែ រ៉ា ម៉ើ តមួត ញ៉ន ដើ ម៉ើ ចាប់ មឹង អៃ អៃ អង់គូ អរែង ប៊ឹង មែ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ប៊ឹង អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ដក់ តគ់ គ្រែដៃ យែស៊ូ ឡើ តង៉ា រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ប៉ាគ់ ប៊ិច ទឹង បូវ ឈែវ ចាប់ គ្រែដៃ មន់បើម អន់យូច ដើ អៃ ស៊ិ តង អំតាក់ អ្រយូច ដើ មែ? ឆា ដើ ប៊ឹះ ប៉ឹះ តង ឡះ?» ");
INSERT INTO brb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «អៃ អង់ហាយ ដើ ហៃ ហន់តាក់ អ្រយូច ដើ មែ តៃ ត្រ ឌិវ ប៉ឹះ តង អ៊ែ អ៊ឺម តង ហន់តាក់ អ្រយូច ដើ មែ ម៉ាត់តូវ ប៉ឹះៗ ប៉ឹះ ជិត តង»។ ");
INSERT INTO brb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«អម៉ាង ប៉ាគ់ អ៊ែ យ៉ាក់ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ អព្រឌីវ ប៊ឹង សឋិច មូយ រ៉ា ឡើ ងុញ តមួត ឝ្លាំង ឞន់ជី លៀន អរែង ដើ មែ ទិះ ក្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","តគ់ សឋិច ឡើ ឝ្លាំង ឞន់ជី ម៉ើ តៀត បឹ ទិះ ក្រាគ់ មូយ រ៉ា ឡើ តង់ លៀន ណគ មូយ មឺន តឡង់ ។ ");
INSERT INTO brb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","បឹ ហង់អ៊ែ ឡើ ប៊ិច អ៊ឺម លៀន ធែន អ៊ែ សឋិច ឡើ ប៉្រៃ មន់ហំពួត ចាក់ ណគ ទ្រី ណគ កួន ណគ ដើម រ៉ាះ អំបាះ ណគ់ ណគ ឡើ ប៊ិច អាំ តូច អាំ លំដូវ ធែន។ ");
INSERT INTO brb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","បឹ ហង់អ៊ែ ឡើ ជឹះ ត្រកូវ ត្រងឺវ ទូត ប្រិះ ឡើ ឡា ឡូម ហឹ យ៉ាគ់ សឋិច រៀន “ឡា យ៉ាគ់ សឋិច អើយ ហំចាំ អន់ដាំង លៀន អន់ដៃ អុះ អ៊ែ អន់ធែន ហឹ ហៃ អាំ ណុះ ប្រយ”។ ");
INSERT INTO brb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ប៊ឹង អ៊ែ សឋិច ឡើ ស្រុស្រៀត ណគ ទុត ខាក់ អ៊ែ ឡើ ព្លី ដើម ឡើ តាក់ មិៗ លៀន ប្រណគ ឡើ តង់»។ ");
INSERT INTO brb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«បឹ ហង់អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ តៃ បឹ ឈែវ អំប្រា បើម កាន ណគ់ ឡើ តង់ លៀន ណគ មូយ ក្លាំ ឌីណារី អ៊ែ ឡើ រ៉ាប់ កញ៉ិច ដង់ ប្រយ ឡើ តុ លៀន ណគ ឡើ ម៉ាង រៀន “ណិះៗ ហន់ធែន លៀន អៃ!”។ ");
INSERT INTO brb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ប៊ឹង អ៊ែ ពន់តក ណគ ឡើ ជឹះ ត្រកូវ ត្រងឺវ ទូត ប្រិះ ឡា ឡូម រៀន “ឡា ហំចាំ អន់ដាំង លៀន អន់ដៃ អុះ អ៊ែ អន់ធែន ហឹ ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ហាក់ បឹ ហង់អ៊ែ ឡើ ផម អ៊ឺម អ៊ែ ឡើ រ៉ាប់ ក្រាន់ ប្រណគ ទឹង ឃុក ឆា ដើ លំធែន អាំ ណុះ។ ");
INSERT INTO brb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","អ៊ែ បូវ ណគ ឈែវ ម៉ើ បើម កាន អរែង ប៊ឹង ម៉ើ តៃ ប៉ាគ់ អ៊ែ ស្រៀវ ប្រយ តៃ ម៉ើ ញឹម ក្លើម អ៊ែ ម៉ើ ដក់ ប៉ច លែក ដើ កាន នែ ហឹ សឋិច។ ");
INSERT INTO brb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","អ៊ែ សឋិច ឡើ កឡូវ បឹ ហង់អ៊ែ ឡើ ម៉ាង រៀន “អើយ ឞយ ចនិះ តៃ ចាគ់! ដើ អៃ អតាក់ មិៗ លៀន ហៃ ហតង់ យ៉ាក់ ហឡា ឡូម ហឹ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ដើ អៃ អស្រុស្រៀត ហៃ ពយ៉ិ ដើ ហៃ តៃ ហស្រុស្រៀត អ៊ឺម ប្រហៃ?” ");
INSERT INTO brb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","សឋិច ឡើ មាំ ទុត ខាក់ អ៊ែ ឡើ ប៉្រៃ ម៉ើ ដក់ តៀត ណគ ហឹ មែ កឡា ញ៉ាម ឃុក មន់បឹត ប៊ឹម ឋា ដើ លំធែន អាំ ណុះ។ ");
INSERT INTO brb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ប៉ាគ់ទឺ ឡើយ គ្រែដៃ បើគ អៃ ឡើ គូ ទឹង ហូង គ្រែ លំពថូត វែ ត្រំ រ៉ា ប៉ាគ់ តៃ វន់តាក់ អ្រយូច ដើ បូវ ឈែវ ចាប់ គ្រែដៃ លែក ដើ ចនិះ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង កាន នែ លែវ ឡើយ អ៊ែ ឡើ វីះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ឡើ ដក់ ហឹ ស្រុក យូដា ដើម ឡើ ក្លង ដណៃ យ៉ូរដាន់ តៃ តគ់។ ");
INSERT INTO brb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ប៊ិច មែ ប៉ាសាសុន ទុត អើន ម៉ើ ដក់ តូយ ណគ ហឹ អ៊ែ ឡើ ពនៀម មែ ម៉ើ ឈិ។ ");
INSERT INTO brb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","អ៊ែ បូវ មែ ផារីស៊ី អន់នឺ រ៉ា ម៉ើ ដក់ តង៉ា បឡង ឝ្លាំង គ្រែដៃ យែស៊ូ ម៉ើ រៀន៖ «ពយ៉ិ តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ មែ កឡ មន់តាក់ ទ្រី ណាគ់ ដូវ ឡះ ប៉ាគ់ អំប្រា លំប៊ិច កាន អង់ង៉ាយ មូយ កតាម?»។ ");
INSERT INTO brb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «វ៉ើ អាន អ៊ឺម ឡះ ពឹម គ្រែដៃ ឡើ ហាយ រៀន អន់នួរៗ ពន់ឋើម គ្រែដៃ ឡើ ពឝ៉ើត បនឹះ ប៊ិច កឡ ប៊ិច កទ្រី ");
INSERT INTO brb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ប្ល៊ី អ៊ែ គ្រែដៃ ឡើ ហាយ រៀន “ញ៉ន នែ ឡើយ អ៊ែ មែ កឡ មន់វីះ តើម ប៊ឹង មែគ បើគ មន់ដក់ កី គូ អរែង ប៊ឹង ទ្រី អ៊ែ អំប្រា នែ លំចាក់ ដៃ ឌិវ មូយ ”។ ");
INSERT INTO brb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","អ៊ែ អំប្រា នែ ត្រ យ៉ាវ បារ រ៉ា ចាក់ ដៃ អំប្រា ឌិវ មូយ អន់ណាវ។ ប៉ាគ់ ពអ៊ែ ណគ់ អង់ង៉ាយ គ្រែដៃ ឡើ ពង់ឝ៉ាប់ ឡើយ ញ៉ង អាំ យ៉ាវ បនឹះ មន់ពឝ៉្លះ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","មែ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ប៉ាគ់ ពអ៊ិន ពយ៉ិ ឡើ ត្រ ដើ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ រៀន មែ កឡ មន់ត្រ ខៀន សំឞ៊ុត តាក់ ទ្រី អន់ដៃ អ៊ែ មន់ដូវ តាក់ ទ្រី?»។ ");
INSERT INTO brb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ ម៉ូស៊ែ ឡើ អាំ វែ វ៉ើ តាក់ ទ្រី ញ៉ន វ៉ើ ប៊ិច ចនិះ ឝ៉ិះ ហាក់ អន់នួរៗ ពន់ឋើម ត្រ អ៊ឺម ប៉ាគ់ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","អៃ អង់ហាយ ដើ វែ រៀន កឡ អង់ង៉ាយ ឡើ តាក់ ទ្រី ឡើ ចក់ ទ្រី ហន់ដើម ហាក់ ទ្រី តើម ឡើ ឡើះ អ៊ឺម ណគ កឡ អ៊ែ ឡើ ឡើះ ទ្រី ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","អ៊ែ មែ លុកស៊ិក ម៉ើ ម៉ាង រៀន៖ «ប៉ាគ់ កាន ចក់ ទ្រី ក្ល លំប៉ាគ់ អ៊ិន ណាគ់ ហយ មែ កឡ មន់គូ ហង់ឝ៉ូវ កឋឹះ អ៊ែ លំចាគ់ ជឺរ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «ប៊ិច អ៊ឺម បនឹះ លែក រ៉ា មន់បក់ ឡាប់ ប្រម៉ាង នែ វ៉ិះ ឌិវ មែ ណគ់ គ្រែដៃ ឡើ អាំ អ៊ែ មន់ដូវ ឡាប់។ ");
INSERT INTO brb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","កឡ អន់នឺ តៃ ម៉ើ ណោះ កី ដើ កទ្រី តើម ប៊ឹង ម៉ើ កើត។ កឡ អន់នឺ បនឹះ ម៉ើ លៀត ។ កឡ អន់នឺ តៃ ម៉ើ ចក់ ទ្រី ញ៉ន ម៉ើ ងុញ បើម ឞយ គ្រែដៃ ឡើ កឡា ពែក ប៉ាក់។ មែ ង៉ាយ ម៉ើ ដូវ ណោះ ហឡាក់ កាន នែ មន់ឃឹត យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ប៊្លី អ៊ែ ប៊ិច ម៉ើ តៀត មែ អង់គ្លែត ហឹ គ្រែដៃ យែស៊ូ អាំ លំជុ ទី អ៊ឺរ ដាំង គ្រែដៃ ដើ មែ ហាក់ បូវ លុកស៊ិក ម៉ើ គឹះ មែ ម៉ើ តៀត មែ អង់គ្លែត។ ");
INSERT INTO brb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «វន់អាំ មែ អង់គ្លែត មន់ដក់ ហឹ អៃ ញ៉ង វ៉ើ កំប៊ែត អ៊ឺម មែ យ៉ាក់ វ៉ិះ ឌិវ មែ ម៉ើ ប៊ិច ចនិះ ក្លើម ប៉ាគ់ មែ អង់គ្លែត ណិះ ឡើយ គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","គ្រែដៃ យែស៊ូ ឡើ ជុ ទី ប្រាយ កាន ចាគ់ ដើ មែ អង់គ្លែត លែវ ឡើយ ប៊្លី អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ប៊ឹង អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ឡើ តង៉ា រៀន៖ «យ៉ាគ់ ណាយឃូ អើយ អំបើម កាន ចាគ់ អង់ង៉ាយ អ៊ែ អន់ដូវ កាន ញិវ ឡូច អន់សច?»។ ");
INSERT INTO brb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ពយ៉ិ ហតង៉ា អៃ កាន ណគ់ ឡើ ចាគ់ ប៉ាគ់ អ៊ិន? វ៉ិះ ឌិវ គ្រែដៃ ឡើ ប៊ិច ក្លើម ចាគ់។ ប៉ាគ់ ហម៉ើត ញិវ ឡូច អន់សច ហំបើម ត្រួយ ចឞាប់ ណគ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ណគ ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ចឞាប់ អង់ង៉ាយ ដឹះ?»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ញ៉ង កជែត បនឹះ ញ៉ង ឡើះ ច្រើន ញ៉ង តទូង ចចក់ ញ៉ង ប៉ច ពយូច បូវ ឆ្រឡិ ឆ្រលួគ ");
INSERT INTO brb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","តង ហំខរ៉ុប មែគ បើគ ដើម ហំម៉ើត ដើ បូវ ប៊ែង ឞាល់ ហម៉ើត ដើ ចាក់ ហកឡឹ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","បឹ ច្រហើវ អ៊ែ ឡើ ត្រណើវ រៀន៖ «អៃ អបើម ត្រួយ ឡើយ លែក ដើ ចឞាប់ អ៊ិន ណាគ់ អង់ង៉ាយ ដិ អន់ត្រ បើម?»។ ");
INSERT INTO brb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ប៉ាគ់ ហម៉ើត ហន់ចាគ់ ម៉ាត់ ម៉ាត ហន់ដក់ ហំពួត ប្រនិច ហៃ ហំប៉ាក ដើ មែ ម៉ូវ ម៉ក អ៊ែ ហំប្រនិច ទឹង ហូង គ្រែ ទិ ប៊្លី អ៊ែ ហន់ដក់ តូយ អៃ យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ហំប៊្រុះ បឹ ច្រហើវ នែ ឡើ ដុង ឡើ ម៉ាង ប៉ាគ់ អ៊ែ អ៊ែ ឡើ ជឹ ស្រៀវ ឆ្រញ៉ាំ ប្រយ យ៉ាក់ ឡើ ប្រនិច ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ណគ់ បនឹះ ប៊ិច បាក់ ញ៉ាក ខាក់ៗ មន់មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","អៃ អង់ហាយ ឡឹះ ដើ វែ រៀន ណាគ់ ហយ រោះ លំមឹត ទឹង ត្រម កិះ ហំប្លះ បនឹះ ប៊ិច បាក់ មន់មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ប៊ឹង មែ លុកស៊ិក ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ បើម ញ៉ម ទុត ខាក់ ម៉ើ ម៉ាង រៀន៖ «យ៉ាក់ ប៉ាគ់ អ៊ិន មែ ង៉ាយ ដឹះ មន់ដូវ កាន ហវ៉ាត់?»។ ");
INSERT INTO brb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","គ្រែដៃ យែស៊ូ ឡើ ឝ្លាំង ហឹ មែ អ៊ែ ឡើ ហាយ រៀន៖ «កាន នែ ណោះ អ៊ឺម បនឹះ មន់បើម ហាក់ ដើ គ្រែដៃ ឡើ ណោះ បើម លែក អិះ»។ ");
INSERT INTO brb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ប៊ឹង អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «ហតៃ ឡើយ ដើ ញ៉ា នែ ញ៉ើ តាក់ កាន អង់ង៉ាយៗ លែក អិះ ញ៉ើ ដក់ តូយ ហៃ។ ប៉ាគ់ ពអ៊ែ ដើ ញ៉ា អង់ង៉ាយ ញន់ដូវ?»។ ");
INSERT INTO brb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ហឹ ប៉ាង លំប៊ិច ពដិះ គ្រែ ហន់ដើម ប៊ឹង កួន បនឹះ លំដ្រូម ទិ ទិងមៀង ណគ ទុត អូងអាត យ៉ូក យ៉ាល់ ប៉ាគ់ទឺ ឡើយ ណគ់ វែ វ៉ើ តូយ អៃ វន់ដ្រូម ប៊ឹង ទិងមៀង ជិត បារ មូយ រ៉ា មូយ មូយ រ៉ា មូយ ដើម វន់ពែក ប៉ាក់ ពឺង មែ អ៊ីស្រាអ៊ែល លែក ជិត បារ ឆ្រាំង។ ");
INSERT INTO brb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","លែក ដើ មែ ង៉ាយ ម៉ើ តាក់ ហន់ណាម ក្រាន អំម៉ោះ អោះ មែគ បើគ កួន ចូវ លឺ មឺរ ណា ញ៉ន ម៉ើ តូយ អៃ មែ អ៊ែ កនុង មូយ មន់ដូវ មូយ ក្លាំ អន់ណាវ ដើម មន់ដូវ ញិវ ឡូច អន់សច ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ប៊ិច បនឹះ ទុត អើន ណគ់ ម៉ើ ទិះ ក្រាគ់ តគ់ ហន់ណូវ មន់កិ ហឡាប ដាប ហឡង់ អន់ណាវ អ៊ែ បនឹះ ទុត អើន ណគ់ ម៉ើ កិ ហឡាប ដាប ហឡង់ តគ់ ហន់ណូវ មន់ទិះ ក្រាគ់ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ ព្រឌីវ ប៉ាគ់ នែ ប៊ិច កន់ដ្រាគ់ មឺរ មូយ រ៉ា ឡើ វីះ តើម ប៊ឹង ហន់ណាម តើម ភុង មាំង ឡើ ដក់ ដាំង មែ គូលី មន់ពពឹត បបើម ទឹង មឺរ ឈឹង ជែម ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ឡើ ផម លំជែរ មែ មូយ តង៉ៃ មូយ ឌីណារី  អ៊ែ ឡើ ប៉្រៃ ម៉ើ ដក់ ពពឹត បបើម ទឹង មឺរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","តគ់ ម៉ូង ជែន ងឹប អ្យាង កន់ដ្រាគ់ មឺរ អ៊ែ ឡើ ដក់ ឡឹះ ហឹ តឡាត  ឡើ តៃ មែ អន់នឺ ម៉ើ គូ មិៗ ប៊ិច អ៊ឺម មែ ម៉ើ ជែរ។ ");
INSERT INTO brb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ឡើ ប៉្រៃ មែ រៀន “អើយ មែ នែ វន់ដក់ ពពឹត ហឹ មឺរ អៃ តគ់ អន់ជែរ វែ ត្រៗ”។ ");
INSERT INTO brb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","មែ អ៊ែ ម៉ើ រ៉ិ ប្រយ។ ទឹង ម៉ូង ជិត បារ ដើម ម៉ូង ពែ អំប៊ឹ កន់ដ្រាគ់ មឺរ ឡើ ដក់ ដាំង ឡឹះ មែ គូលី ឡើ ហាយ ដើ មែ ប៉ាគ់ អន់ឌូ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","តគ់ ម៉ូង សើង អំប៊ឹ កន់ដ្រាគ់ មឺរ អ៊ែ ឡើ ដក់ ឡឹះ ហឹ តឡាត ឡើ តៃ អន់ណាវ មែ ម៉ើ គូ មិៗ។ អ៊ែ ឡើ តង៉ា មែ រៀន “ពយ៉ិ ឡើ ត្រ វ៉ើ គូ មិៗ ប៊ឹង នែ ឆា ដើ អំប៊ឹ ឞាល់ នែ ញឹះ តៃ ប៊ិច កាន ពពឹត?” ");
INSERT INTO brb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ម៉ើ ត្រណើវ រៀន “យ៉ាក់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដាំង ជែរ ញ៉ា”។ អ៊ែ ឡើ រៀន “ប៉ាគ់ ពអ៊ែ វន់ដក់ ពពឹត ហឹ មឺរ អៃ តគ់”»។ ");
INSERT INTO brb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«តគ់ ឡើ អំប៊ឹ ឡើយ កន់ដ្រាគ់ មឺរ ឡើ ហាយ ដើ បឹ ឡើ ឝ៉ឹន លៀន ឡើ រៀន “មិញ ហំកឡូវ មែ គូលី អ៊ែ ហន់អាំ លៀន ដើ មែ តើម ប៊ឹង មែ ម៉ើ ពឹត អន់ទុន ឋា ប៊ឹះ មែ ម៉ើ ពឹត អន់នួរៗ”។ ");
INSERT INTO brb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","អ៊ែ បូវ មែ ម៉ើ រ៉ិ តគ់ ម៉ូង សើង អំប៊ឹ ម៉ើ ដក់ ហឹ ណគ ម៉ើ ដូវ លៀន មូយ រ៉ា មូយ ឌីណារី។ ");
INSERT INTO brb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","អ៊ែ តគ់ បូវ ម៉ើ រ៉ិ អន់នួរៗ ម៉ើ ប៊ឹះ ម៉ើ ឃឹត រៀន អាត មន់ដូវ លៀន អើន ជឺរ មែ អ៊ែ ហាក់ ម៉ើ ដូវ លៀន មូយ រ៉ា មូយ ឌីណារី ប៉ាគ់ ដើ មែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","តគ់ ម៉ើ ចក់ លៀន លែវ ឡើយ ម៉ើ មាំ ម៉ើ ម៉ាង ងួយ បងួយ ដើ កន់ដ្រាគ់ មឺរ ម៉ើ រៀន ");
INSERT INTO brb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“ដើ មែ ម៉ើ រ៉ិ អន់ទុន ម៉ើ ពពឹត វ៉ិះ មូយ ម៉ូង យ៉ះៗ អ៊ែ ណគ់ ដើ ញ៉ា ញ៉ើ ពពឹត ទុត សាវបះ ពឺង ដុ ហះហាយ ចាយ ម៉ាត់ ញឹះ តើម អំប៊ឹ ហអាំ លៀន ដើ ញ៉ា ប៉ាគ់ ដើ មែ ទឺ” ");
INSERT INTO brb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","យ៉ាគ់ កន់ដ្រាគ់ មឺរ ឡើ ត្រណើវ ហឹ បឹ មូយ រ៉ា ទឹង បូវ មែ រៀន “អើយ ម៉ន អតបូត អ៊ឺម ហៃ។ ហៃ កឡឹ ហផម គូលី អៃ មូយ តង៉ៃ មូយ ឌីណារី ហវ៉ៃ ណាគ់ ដាវ ហដុង? ");
INSERT INTO brb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ហន់ចក់ ហឹ អិះ ឡើយ លៀន អជែរ ហៃ ហន់ជឹ! អម៉ើត អាំ លៀន ដើ មែ ម៉ើ ពពឹត អន់ទុន ឈែវ ប៊ឹង ហៃ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","អន់នែ លៀន អៃ អំតប៉ាត់ តាម ឌី អកឡឹ។ ហចើះ ដើ មែ ហតៃ អប៊ិច ចនិះ ចាគ់ ឡះ?”» ");
INSERT INTO brb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «ប៉ាគ់ អ៊ែ ទឺ ឡើយ ណគ់ មែ ម៉ើ កិ ហឡាប ដាប ហឡង់ តគ់ ហន់ណូវ មន់ទិះ ក្រាគ់ អន់ណាវ អ៊ែ ណគ់ មែ ម៉ើ ទិះ ក្រាគ់ តគ់ ហន់ណូវ មន់កិ ហឡាប ដាប ហឡង់ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ទឹង គ្រែដៃ យែស៊ូ ឡើ ឌឹក ទឹង មួង យែរូសាឡឹម ឡើ ច្រា លុកស៊ិក ណគ លែក ជិត បារ រ៉ា ឡះ តើម ប៊ឹង បូវ។ ទឹង ម៉ើ ដក់ តៃ ទ្រូង ឡើ ហាយ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ណិះៗ នែ ង៉ាយ ង៉ើ ឌឹក ទឹង មួង យែរូសាឡឹម។ ទឹង អ៊ែ កួន បនឹះ លន់ត្រ មន់ឈូន ហឹ ទី មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម ហឹ មែ ណាយឃូ ពង់ហៀន ចឞាប់ មន់តាត់ស៊ិន ប៉្រៃ កជែត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ប៊្លី អ៊ែ មន់ដក់ ឈូន ណគ ហឹ ទី សុនសាត មែ គែង បក់ អាំ មន់ចអាវ ពសាល់ ពន់ឆាំ ណគ មន់បឹត ណគ ដើ ឆមឺ ប្រាត់ ដើម មន់ពឡាះ ប៉ាង កជែត ណគ ប៊ឹង ឡង អង់ឝ៉ាង ដិ ហាក់ តគ់ តង៉ៃ ទី ពែ លំញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ប៊ឹង អ៊ែ ទ្រី យ៉ាគ់ ស៊ែប៊ែឌែ ឡើ ដក់ ពន់ចើម តគ់ គ្រែដៃ យែស៊ូ ដើម កួន កឡ ណគ បារ រ៉ា អ៊ែ ឡើ កដាប ហំបះ ឡើ ងុញ ឡា អង់ង៉ាយ មូយ។ ");
INSERT INTO brb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","គ្រែដៃ យែស៊ូ ឡើ តង៉ា ណគ រៀន៖ «ហងុញ ឡា អង់ង៉ាយ?»។ ណគ ឡើ ត្រណើវ រៀន៖ «តគ់ ហំបើម សឋិច ពែក ប៉ាក់ អឡា ហង់អាំ អំប្រា កួន អៃ នែ អំប្រា លំដ្រូម ដៀក ហៃ មូយ រ៉ា តៃ ចម៉ា មូយ រ៉ា តៃ ចអៀវ»។ ");
INSERT INTO brb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ហឹ អំប្រា រៀន៖ «សប្រា ណោះ អ៊ឺម ណោះ អង់ង៉ាយ សប្រា ឡា។ ណាគ់ សប្រា បក់ ឞិ សប្រា លំញែត ប៊ែង ធុក ញ៉ាក អៃ អន់ត្រ ញែត អ៊ែ?»។ អំប្រា ត្រណើវ រៀន៖ «បក់»។ ");
INSERT INTO brb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ អំប្រា រៀន៖ «ត្រ ឡើយ សប្រា លំញែត ប៊ែង ណគ់ អៃ អន់ញែត ហាក់ ណគ់ កាន សប្រា លំដ្រូម តៃ ចម៉ា ដើម តៃ ចអៀវ អៃ អ៊ែ ដូវ អ៊ឺម អៃ អន់អាំ យ៉ាក់ គ្រែដៃ បើគ អៃ ឡើ រន់ឋាប់ ជុ ដ្រុនដ្រូម អ៊ែ ណគ់ ដើ មែ ណគ ឡើ រ៉ើះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ហំប៊្រុះ លុកស៊ិក ណគ ណាគ់ ជិត រ៉ា ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ មាំ ដើ អំប្រា អំម៉ោះ អោះ នែ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","គ្រែដៃ យែស៊ូ ឡើ កឡូវ លែក ដើ លុកស៊ិក មន់ដក់ ហឹ ណគ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «វែ វ៉ើ ណោះ ឡើយ ណគ់ មែ កឡា ពែក ប៉ាក់ ទឹង សុនសាត អង់គែងៗ ម៉ើ ឈិះ ឆាន់ ប៉ាសាសុន មែ កឡឹ អ៊ែ ណគ់ ដើ មែ ទិះ ក្រាគ់ ម៉ើ ប៊ិច អាតណាត ម៉ើ ពង់ខំ ប៉្រៃ បើម តាម ពន់ដ្រៃ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ញ៉ង វន់បើម អ៊ឺម ប៉ាគ់ អ៊ែ។ ហាក់ ប៉ាគ់ មែ ង៉ាយ ទឹង បូវ វែ លំងុញ បើម ទិះ ក្រាគ់ ណគ អ៊ែ លំត្រ បើម ឞយ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ដើម មែ ង៉ាយ ទឹង បូវ វែ លំងុញ បើម ណាយ ណគ អ៊ែ លំត្រ ក៝ត វែ។ ");
INSERT INTO brb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ប៉ាគ់ អ៊ែ ទឺ ឡើយ កួន បនឹះ ឡើ ទឺះ ទិ នែ ត្រ អ៊ឺម ឡើ ទឺះ បក់ មន់បើម ឞយ ណគ ឡើ ទឺះ បក់ លំបើម ឞយ មែ អន់ណាវ ដើម លំគែត ឡោះ បនឹះ ទុត អើន»។ ");
INSERT INTO brb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","តគ់ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ វីះ តើម ប៊ឹង មួង យែរីខូ មែ ប៉ាសាសុន ទុត អើន ម៉ើ ដក់ តូយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ទឹង អ៊ែ ប៊ិច កឡ សូត ម៉ាត់ បារ រ៉ា អំប្រា ដ្រូម ដៀក ទ្រូង។ ហំប៊្រុះ អំប្រា ដុង គ្រែដៃ យែស៊ូ ឡើ ដក់ តៃ អ៊ែ អ៊ែ អំប្រា កឡូវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ ហកន់ស៊ែយូ សឋិច ដាវីត អើយ ហំស្រុស្រៀត ញឺ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","អ៊ែ មែ ប៉ាសាសុន ម៉ើ គឹះ អំប្រា ម៉ើ ប៉្រៃ អំប្រា គូ ខៀង។ ហាក់ សរ៉ើម អំប្រា កឡូវ ចាំ ថាំង រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ ហកន់ស៊ែយូ សឋិច ដាវីត អើយ ហំស្រុស្រៀត ញឺ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","គ្រែដៃ យែស៊ូ ឡើ ជឹង ប្រយ ឡើ កឡូវ អំប្រា ដក់ ហឹ ណគ ឡើ តង៉ា អំប្រា រៀន៖ «អង់ង៉ាយ សប្រា ងុញ អំប៉ូរ សប្រា?»។ ");
INSERT INTO brb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","អំប្រា ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ ញ៉ើ ឡា ម៉ាត់ ញឺ លំត្រប៉ៃ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","គ្រែដៃ យែស៊ូ ឡើ ស្រុស្រៀត អំប្រា ទុត ខាក់ អ៊ែ ឡើ ពឹត ប៊ឹង ម៉ាត់ អំប្រា។ ហំប៊្រុះ ដើ អ៊ែ អំប្រា ត្រប៉ៃ ប្រយ អ៊ែ អំប្រា តូយ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ ដៀប ប៊ឹះ មួង យែរូសាឡឹម ឡើយ។ តគ់ ម៉ើ ប៊ឹះ ស៊្រុក ប៊ែតផាស៊ែ ប្លះ ក្រជែង សាង ចន់ឌូ តើម អូលីវ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ លុកស៊ិក ណគ បារ រ៉ា ដក់ អន់នួរ ");
INSERT INTO brb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ដើម ឡើ ហាយ រៀន៖ «មិញ សប្រា លំដក់ មឹត ស៊្រុក ហឹ ងឺរ តគ់។ ហំប៊្រុះ សប្រា លំប៊ឹះ ហឹ អ៊ែ សប្រា លំតៃ ម៉ើ ចង លៀ យូ ដើម កួន ណគ។ សប្រា លំឡិះ ជឹ តៀត លែក បារ ហឹ អៃ យ៉ឹ។ ");
INSERT INTO brb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ប៉ាគ់ ប៊ិច មែ ង៉ាយ មន់តង៉ា សប្រា អ៊ែ សប្រា លំហាយ រៀន “យ៉ាគ់ កន់ដ្រាគ់ ញឺ ឡើ តងកាន លៀ នែ”។ អ៊ែ មន់អាំ ដ្រិះៗ ដើ សប្រា លំជឹ តៀត»។ ");
INSERT INTO brb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","កាន នែ ឡើ កើត អាំ លំដាវ តាម ប៉ាគ់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ អន់នួរ ឡើយ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«មិញ វន់ហាយ ដើ មែ ប៉ាសាសុន មួង ស៊ីយ៉ូន រៀន “វន់ឝ្លាំង សឋិច វែ ឡើ ប៊ឹះ ឡើយ ហឹ វែ។ ឡើ ប៊ិច ចនិះ ស៊ិម បក់ ឡើ ឈិះ លៀ ឡើ ឈិះ ពឺង កណង កួន លៀ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","អំប្រា លុកស៊ិក អំប្រា វីះ ប្រយ អំប្រា បើម តាម ប៉ាគ់ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ ");
INSERT INTO brb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","អំប្រា ជឹ ទឹក លៀ ដើម កួន ណគ ហឹ គ្រែដៃ យែស៊ូ។ ម៉ើ សើវ ដើ អាវ ឌ្រឹម ពឺង កណង លៀ ដើម ពឺង កណង កួន លៀ ដិ គ្រែដៃ យែស៊ូ ឡើ ឌឹក ឈិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ប៊ឹង អ៊ែ មែ ប៉ាសាសុន ទុត អើន ម៉ើ សើវ ទ្រូង ដើ អាវ មែ កឡឹ មែ អន់នឺ អន់ណាវ ម៉ើ ច្រិះ កៀង ហឡា ឡង ម៉ើ សើវ ទ្រូង ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","មែ ប៉ាសាសុន ម៉ើ ដក់ អរែង តៃ ម៉ាង តៃ ងឺរ តៃ ម៉ាង តៃ ត្រិច គ្រែដៃ យែស៊ូ ម៉ើ ហូ រៀន៖ «ហូសាណា ឡា ព្រតឹះ ព្រនែ កួន ចូវ សឋិច ដាវីត! ឡា គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ បឹ ឡើ ប៊ឹះ ទឹង ម៉ាត់ គ្រែដៃ កន់ដ្រាគ់! ហូសាណា ឡា ព្រតឹះ ព្រនែ គ្រែដៃ ឡើ គូ ទឹង ហូង គ្រែ ឈ្រូង តៃ ឋាំ!»។ ");
INSERT INTO brb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","តគ់ គ្រែដៃ យែស៊ូ ឡើ មឹត ទឹង មួង យែរូសាឡឹម លែក ដើ មែ ទឹង មួង ភូះ ចំភូះ ឈឹង ហឈឹង ម៉ើ ម៉ាង រៀន៖ «មែ ង៉ាយ អិះ យ៉ាគ់ អន់នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ណគ់ មែ ប៉ាសាសុន ម៉ើ ដក់ អរែង ប៊ឹង ណគ ម៉ើ ហាយ រៀន៖ «យ៉ាគ់ អន់នែ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ណគ យែស៊ូ ឡើ ប៊ឹះ តើម ប៊ឹង ស៊្រុក ណាសារែត ស្រុក ឝ៉ាលីលែ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ មឹត ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ តវីះ លែក ដើ មែ ម៉ើ ហំពួត រួត ទឹង អ៊ែ ដើម ឡើ ឝឹ តាក់ តូក មែ ម៉ើ វ៉ាក់ លៀន ដើម កតាំង មែ ម៉ើ ហំពួត កំប៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ឡើ ម៉ាង ដើ មែ រៀន៖ «ទឹង ពឹម គ្រែដៃ គ្រែដៃ ឡើ ហាយ រៀន “រ៉ូង អៃ នែ ឡើ ត្រ រ៉ូង បនឹះ មន់ដក់ អ៊ឺរ ដាំង អៃ ហវ៉ៃ ណគ់ ដើ វែ អន់ណាវ រ៉ូង អៃ នែ វ៉ើ បើម កនូ មែ តទូង ចចក់”»។ ");
INSERT INTO brb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ប៊ិច បនឹះ សូត ដើម បនឹះ កន់ចក ម៉ើ ដក់ ដាំង គ្រែដៃ យែស៊ូ ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ ពនៀម ប្រយ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","តគ់ បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ តៃ កាន ឆង៉ាត់ គ្រែដៃ យែស៊ូ ឡើ បើម ដើម ម៉ើ ដុង មែ អង់គ្លែត ម៉ើ ហូ ម៉ាង ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ រៀន៖ «ហូសាណា ឡា ព្រតឹះ ព្រនែ កួន ចូវ សឋិច ដាវីត!» អ៊ែ ម៉ើ មាំ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ពយ៉ិ ហដុង អ៊ឺម ឡះ មែ អង់គ្លែត ម៉ើ ហូ អ៊ិន ប៉ាគ់ ង៉ាយ ហដុង ម៉ើ ម៉ាង?» ឡើ ត្រណើវ រៀន៖ «អដុង ឡើយ! ពយ៉ិ វ៉ើ អាន អ៊ឺម ឞិ ទឹង ពឹម គ្រែដៃ កាន សឋិច ដាវីត ឡើ ខៀន ជុ រៀន “គ្រែដៃ អើយ ហបើម អាំ ប្រម៉ាង ព្រតឹះ ព្រនែ លំញឺះ តើម ប៊ឹង បួរ មែ អង់គ្លែត ដើម មែ អង់អាង ណាគ់ ម៉ើ ពុ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តាក់ មែ ឡើ ញឺះ តើម ប៊ឹង មួង ឡើ ដក់ ហឹ ស៊្រុក ប៊ែថានី។ មាំង អ៊ែ ឡើ កី ហឹ អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","តើម ភុង មាំង គ្រែដៃ យែស៊ូ ឡើ ជឹ វឹញ ហឹ មួង យែរូសាឡឹម ទឹង ឡើ ដក់ ឡើ ដុង ពងួត។ ");
INSERT INTO brb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","អ៊ែ ឡើ តៃ ឡង កប៉ក់ មូយ តើម ដៀក ទ្រូង ឡើ ដក់ ឝ្លាំង ឡើ តៃ ញឹះ តៃ ឡើ ប៉្លៃ ឡើ ប៊ិច ឌិវ ហឡា។ អ៊ែ ឡើ ប្រាយ រៀន៖ «តើម ប៊ឹង នែ ឞិះ ហឹ ងឺរ តគ់ ញ៉ង ហពឺរ ប៉្លៃ យ៉ាវ!»។ ហំប៊្រុះ ដើ អ៊ែ ឡង កប៉ក់ ឡើ រ៉ូយ រ៉ាក គែត ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","មែ លុកស៊ិក ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ ញ៉ម ទុត ខាក់ ប្រយ អ៊ែ ម៉ើ ម៉ាង រៀន៖ «ប៉ិ ឡើ ត្រ តើម កប៉ក់ ឡើ គែត រ៉ូយ រ៉ាក ដ្រិះៗ ប៉ាគ់ នែ អិះ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ម៉ាង មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ វន់ចាប់ មឹង ញឹះ តៃ អ៊ឹនព្រឹះ តៃ ត្រ វ៉ិះ ឌិវ វន់បើម អាំ តើម កប៉ក់ លំរ៉ូយ រ៉ាក គែត ឞាល់ នែ អ៊ឺម ដឹប វន់ម៉ាង ដើ ចន់ឌូ នែ រៀន “មិញ ហំវីះ តើម ប៊ឹង នែ ហន់គ្លីះ ទិ ដាក សមុត ចុ!” អ៊ែ លំកើត ម៉ាត់ ម៉ាត តាម ប្រម៉ាង វែ។ ");
INSERT INTO brb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","កាន អង់ង៉ាយ កតាម វន់អ៊ឺរ ដាំង ឡា ទឹង គ្រែដៃ ចក់ ដើ វន់ចាប់ មឹង ណគ អ៊ែ លំអាំ ដើ វែ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ មឹត ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ទឹង ប៉ះ ឡើ ពង់ហៀន បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ដក់ តង៉ា ណគ ម៉ើ រៀន៖ «ហបើម កាន លែក នែ ហអ៊ីង ដើ អាតណាត មែ ង៉ាយ? មែ ង៉ាយ ម៉ើ អាំ អាតណាត នែ ដើ ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «អៃ អន់តង៉ា វែ មូយ ខ ប៉ាគ់ទឺ ប៉ាគ់ វែ វន់ហាយ ដើ អៃ អ៊ែ អៃ អង់ហាយ ប៉ាគ់ទឺ ដើ វែ អបើម កាន លែក នែ អអ៊ីង ដើ អាតណាត មែ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","អ៊ែ ឡើ តង៉ា ប្រយ៖ «មែ ង៉ាយ ម៉ើ អាំ អាតណាត ដើ យ៉ាគ់ យ៉ូហាន បើម ឞ៊ុន តម៉ូច ដាក? គ្រែដៃ លឺ បនឹះ?»។ អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ប៉ាគ់ ងន់ហាយ រៀន “គ្រែដៃ ឡើ អាំ” ឝ៉ាន់ លំម៉ាង ដើ ង៉ាយ រៀន “បាយ តៃ វ៉ើ ឌី ចាប់ ម៉ាង យ៉ាគ់ យ៉ូហាន ដឹះ?” ");
INSERT INTO brb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ប៉ាគ់ ងំត្រណើវ រៀន “បនឹះ ឡើ អាំ ដើ យ៉ាគ់ យ៉ូហាន” ង៉ើ ឌូង ដើ មែ ប៉ាសាសុន យ៉ាក់ លែក ដើ មែ ម៉ើ ជុ ណគ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ប៉ាគ់ ពអ៊ែ ម៉ើ ត្រណើវ រៀន៖ «ញ៉ើ ណោះ អ៊ឺម ញ៉ា»។ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប៉ាគ់ ពអ៊ិន ដើ អៃ អង់ហាយ អ៊ឺម ប៉ាគ់ទឺ ដើ វែ អបើម កាន លែក នែ អអ៊ីង ដើ អាតណាត មែ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«អ៊ែ ដើ វែ ប៉ាគ់ ង៉ាយ វន់ឃឹត ដើ កាន នែ? អំម៉ាង ព្រឌីវ ប៊ិច តង់កង់ មូយ រ៉ា ឡើ ប៊ិច កួន កឡ បារ អ៊ែ ឡើ ដក់ ហាយ ដើ កួន ឡង់ ណគ រៀន “អើយ កួន តង៉ៃ នែ ហន់រ៉ិ ពពឹត ហឹ មឺរ ឈឹង ជែម ង៉ាយ យ៉ឹ!”។ ");
INSERT INTO brb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","កួន ណគ ឡើ ត្រណើវ រៀន “ឌី អ៊ឺម អៃ បើគ”។ ហាក់ តគ់ ប៊្លី អ៊ែ ឡើ ពលិះ ចនិះ ឡើ រ៉ិ ប្រយ ហឹ មឺរ។ ");
INSERT INTO brb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","អ៊ែ បើគ ណគ ឡើ ដក់ ហាយ ប៉ាគ់ អន់ឌូ ទឺ ហឹ កួន អន់សូច កួន អន់សូច ណគ ឡើ ត្រណើវ រៀន “អើគ បើគ អន់រ៉ិ!” តគ់ ហន់ណូវ ឡើ រ៉ិ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «លែក ដើ អំប្រា កួន ណគ បឹ អង់ង៉ាយ ឡើ បើម តាម ប្រម៉ើត បើគ អំប្រា?»។ ម៉ើ ត្រណើវ ណគ រៀន៖ «បឹ ឡើ ឡង់»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន បូវ មែ កាគ់ លៀន ដើម មែ កទ្រី ឡាក់លែង មន់មឹត អន់នួរ វែ ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ");
INSERT INTO brb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","យ៉ាក់ យ៉ាគ់ យ៉ូហាន ឡើ ដក់ ពហាយ ឡើយ ដើ វែ កាន ញិវ កើត ឡើ ចាគ់ ទឹង ត្រ ណាគ់ តៃ វ៉ើ ចាប់ អ៊ឺម ម៉ាង ណគ។ ហាក់ ដើ បូវ មែ កាគ់ លៀន ដើម បូវ កទ្រី ឡាក់លែង ម៉ើ ចាប់ ម៉ាង ណគ អ៊ែ ណគ់ ដើ វែ អន់ណាវ សំយ៉ះ វ៉ើ តៃ កតាម កាន មែ ម៉ើ ចាប់ យ៉ាគ់ យ៉ូហាន ណាគ់ តៃ វ៉ើ ឌី ពលិះ ចនិះ ចាប់ ណគ ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«ឡា វន់ចង់ហៀង កាន ព្រឌីវ មូយ ឡឹះ អន់ណាវ។ ប៊ិច កន់ដ្រាគ់ មឺរ មូយ រ៉ា ឡើ ដាំ ឈឹង ជែម ទឹង មឺរ ណគ ឡើ បើម រំឞង ឈុំ មឺរ ដើម ឡើ ប៉ោះ តម៉ ដដារ បើម ឞន ឆាន់ៗ ចក់ ដាក ប៉្លៃ ឈឹង ជែម មូយ អំប៊ុ ដឹប ឡើ បើម ហំប៉ាង ឈ្រុង ឈ្រូង ចាំ មឺរ។ ប៊្លី អ៊ែ ឡើ អាំ ដើ មែ មន់រន់ឋាប់ ឝ្លាំង មឺរ ណគ ឡើ ប៉្រៃ មន់ប៉ាក ប្ល៉ៃ ដើ ណគ កឡឹ ត្រំ កម៉ ប៊្លី អ៊ែ ឡើ វីះ ហឹ ស្រុក ទុត ចង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","តគ់ ដៀប ឡើ ប៊ឹះ ញ៉ាម ប៉្លៃ ឈឹង ជែម ឡើ ឌុំ ឡើ ប៉្រៃ ឞយ ណគ មន់ដក់ ចក់ ប៉្លៃ ពណាក ណគ ហឹ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ។ ");
INSERT INTO brb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","តគ់ បូវ ឞយ ម៉ើ ប៊ឹះ ហឹ មែ ឡើយ អ៊ែ បូវ មែ រន់ឋាប់ ឝ្លាំង មឺរ ម៉ើ រ៉ាប់ ប្រយ មែ បឹ មូយ រ៉ា ម៉ើ បឹត ប៊ឹម បឹ មូយ រ៉ា ម៉ើ កជែត បឹ មូយ រ៉ា អន់ណាវ ម៉ើ ពៀវ កជែត ដើ តម៉។ ");
INSERT INTO brb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","អ៊ែ យ៉ាគ់ កន់ដ្រាគ់ មឺរ ឡើ ប៉្រៃ ឞយ ណគ គែង អ៊ែ អើន ជឺរ ឡៃ អន់នួរ ម៉ើ ដក់។ ហាក់ មែ រន់ឋាប់ ឝ្លាំង មឺរ ម៉ើ តំឞាប ឡឹះ ប៉ាគ់ ដើ មែ ម៉ើ ដក់ អន់នួរ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","តគ់ អន់ទុនៗ យ៉ាគ់ កន់ដ្រាគ់ មឺរ អ៊ែ ឡើ ប៉្រៃ កួន កឡ ណគ កឡឹ អន់ណាវ ដក់ ហឹ មែ ឡើ ឃឹត រៀន “អាត មន់អៀល បឹះ ឡើយ កួន អៃ នែ”។ ");
INSERT INTO brb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ហាក់ បូវ រន់ឋាប់ ឝ្លាំង មឺរ អ៊ែ ហំប៊្រុះ ម៉ើ តៃ កួន ណគ ឡើ ប៊ឹះ ម៉ើ ចជែ ត្រឌីវ មែ រៀន “ណគ នែ ឡើយ លំដូវ មឺរ នែ លំបើម មូន ខៃណូវ ញ៉ាគ់ ញំកជែត ណគ អ៊ែ មឺរ នែ លំត្រ មឺរ ង៉ាយ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","អ៊ែ ម៉ើ រ៉ាប់ អ៊ូះ កជែត តាក់ ណគ ហឹ ដៀក មឺរ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ប៉ាគ់ ពអ៊ែ តគ់ យ៉ាគ់ កន់ដ្រាគ់ មឺរ កឡឹ លំប៊ឹះ ប៉ាគ់ ង៉ាយ លំបើម ដើ មែ រន់ឋាប់ ឝ្លាំង មឺរ អ៊ែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ម៉ើ ត្រណើវ រៀន៖ «លំកជែត បូវ អរាំង មាំ អ៊ែ តូវ ហពែង ហយ៉ាម ប៊្លី អ៊ែ លំអាំ ដើ មែ គែង អន់ណាវ មន់រន់ឋាប់ ឝ្លាំង មឺរ ណគ ណគ់ មែ មន់ឌី អាំ ពណាក ណគ ត្រំ ញ៉ាម ប៉្លៃ ឌុំ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ ដើ មែ រៀន៖ «ពយ៉ិ វ៉ើ អាន អ៊ឺម ឡះ ប្រម៉ាង នែ ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “តម៉ ណគ់ មែ ម៉ើ បើម ហន់ណាម ម៉ើ ពៀវ តាក់ ឡើយ ឡើ វឹរ តម៉ ប៊ិច ខា ជឺរ អន់ណាវ។ កាន នែ គ្រែដៃ កន់ដ្រាគ់ ឡើ បើម ង៉ើ តៃ ដើម ង៉ើ ញ៉ម ទុត ខាក់ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ញ៉ន ពអ៊ែ ឡើយ អង់ហាយ ដើ វែ រៀន គ្រែដៃ លំតាក់ វែ លំពែក ប៉ាក់ យ៉ាវ លំពែក ប៉ាក់ សុនសាត គែង អន់ណាវ ណគ់ មន់បើម អង់កើត ពឺរ ប៉្លៃ ឡើ ត្រ តាម កាន គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","មែ ង៉ាយ មន់កទឹម បង់ ប៊ឹង តម៉ អន់នែ មែ អ៊ែ មន់ហិច អំប្រិច អ៊ែ ប៉ាគ់ តម៉ អន់នែ លំគ្លីះ តឹន ពឺង មែ ង៉ាយ មែ អ៊ែ តូវ មន់ហទឹក ប្រយ»។ ");
INSERT INTO brb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ផារីស៊ី ម៉ើ ដុង កាន ឡើ ម៉ាង ព្រឌីវ ប៉ាគ់ អ៊ែ អ៊ែ ម៉ើ ណោះ រៀន គ្រែដៃ យែស៊ូ ឡើ គឹះ មែ ដើ ម៉ាង ចនីរ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","អ៊ែ ម៉ើ ទែង រ៉ាប់ ណគ ពញ៉ង ណាគ់ ម៉ើ ឌូង ដើ មែ ប៉ាសាសុន យ៉ាក់ ម៉ើ ជុ ណគ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ឡឹះ ដើ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ផារីស៊ី ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ ព្រឌីវ ប៉ាគ់ នែ ប៊ិច សឋិច មូយ រ៉ា ឡើ ត្រៀម ច្រណង់ កួន កឡ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","តគ់ ប៊ឹះ ម៉ូង ចង់ ចា ឡើ ប៉្រៃ ឞយ ណគ មន់ដក់ ច្រា មែ តមួយ ណគ់ ណគ ឡើ ហាយ អន់នួរ ឡើយ មន់ដក់ ចង់ ចា ហឹ មែ ច្រណង់ ហាក់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ឌី ដក់ ចង់ ចា។ ");
INSERT INTO brb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","អ៊ែ ឡើ ប៉្រៃ ឞយ អង់គែង អន់ណាវ ដក់ ហាយ ដើ មែ តមួយ ណគ ឡើ ច្រា ពន់ឋើម អាំ មន់រៀន “អើយ បូវ ប៊ែង អៃ អត្រៀម ចណង់ ចណា ប្រយ៉ង់ លែវ ឡើយ អកោះ ឝ៉ូ សារ ដើម បណាន់ អៃ អបយ៉ា ណគ់ ទិះៗ បិញៗ អបើម កយ៉ិ លែវ ឡើយ វន់ដក់ ចង់ ចា ហំមិញ”។ ");
INSERT INTO brb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ហាក់ ណគ់ មែ សឋិច ឡើ ច្រា ពន់ឋើម អ៊ែ ញឹះ តៃ ម៉ើ វ៉ឹនវ៉ាយ អ៊ឺម មែ អន់នឺ ម៉ើ រ៉ិ ហឹ មឺរ មែ អន់នឺ ម៉ើ ដក់ ហំពួត រួត ");
INSERT INTO brb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ណគ់ មែ អន់នឺ អន់ណាវ ម៉ើ រ៉ាប់ តំឞាប ឞយ សឋិច ដើម ម៉ើ កជែត ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ហំប៊្រុះ យ៉ាគ់ សឋិច ឡើ ដុង ឡើ មាំ តូវ ចះ មុះ ម៉ាត់ ដើ មែ អ៊ែ ឡើ ប៉្រៃ បូវ តហាន ណគ ដក់ កជែត ណគ់ មែ ម៉ើ កជែត ឞយ ណគ ដឹប ឡើ ប៉្រៃ មន់ចុះ មួង មែ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ប៊្លី អ៊ែ ឡើ ហាយ ដើ បូវ ឞយ ណគ រៀន “អៃ អត្រៀម កាន ច្រណង់ ច្រណា នែ លែវ ឡើយ ហាក់ ណគ់ មែ អៃ អច្រា អន់នួរៗ អ៊ែ ឃឺ អ៊ឺម មន់មឹត ចង់ ចា ហឹ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ប៉ាគ់ ពអ៊ែ មិញ វន់ដក់ តៃ ទ្រូង លួង ចក់ ដើ វន់តៃ មែ ង៉ាយ តមឹង វន់ច្រា មន់ដក់ មឹត ចង់ ចា ហឹ ឞន ច្រណង់ នែ”។ ");
INSERT INTO brb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","បូវ ឞយ អ៊ែ ម៉ើ ដក់ ប្រយ តៃ ទ្រូង លួង ម៉ើ ច្រា លែក ដើ បនឹះ តាម ម៉ើ តៃ តៃ ម៉ាង មែ ចនិះ តៃ ចាគ់ ដើម មែ ចនិះ ចាគ់ លែក អិះ អ៊ែ បនឹះ តូវ ឡើ ប៊ិង ប្រយ ទឹង ឞន ច្រណង់»។ ");
INSERT INTO brb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«យ៉ាគ់ សឋិច ឡើ ដក់ តង៉ា ឡា មែ ម៉ើ ចង់ ចា ហឹ ឞន ច្រណង់ អ៊ែ ឡើ តៃ បនឹះ មូយ រ៉ា ឡើ ត្រទ្រូប ហហក តៃ ឃឺ ទឹង បូវ ច្រណង់។ ");
INSERT INTO brb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ឡើ តង៉ា កឡ ហង់អ៊ែ រៀន “អើយ ម៉ន ប៉ិ ឡើ ត្រ ហមឹត ទឹង នែ ហត្រទ្រូប ហហក តៃ ឃឺ ទឹង បូវ ច្រណង់ ប៉ាគ់ នែ ដឹះ?”។ បឹ ហង់អ៊ែ ឡើ គូ ខៀង ញឹះ តៃ ឡើ ណោះ ត្រណើវ។ ");
INSERT INTO brb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","អ៊ែ សឋិច ឡើ ហាយ ហឹ បូវ ឞយ ណគ រៀន “មិញ វន់រ៉ាប់ ចង ឈឹង ទី បឹ អន់នែ វន់ទូង ពញឺះ តាក់ ហឹ ដៀក ទឹង ហ្រង៉ូមៗ ហឹ ឞន បនឹះ ម៉ើ ញឺម ស៊្រែក កាប់ ក្រៀម ឝលៀម ពឹង!”»។ ");
INSERT INTO brb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ ដើ មែ រៀន៖ «គ្រែដៃ ឡើ កឡូវ បនឹះ ទុត អើន ហាក់ ឡើ រ៉ើះ ចក់ កើយៗ»។ ");
INSERT INTO brb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ប៊្លី អ៊ែ បូវ ផារីស៊ី ម៉ើ វីះ ដក់ ចជែ ព្រចួត ប្រម៉ាង ត្រឌីវ មែ ម៉ើ ដាំង រ៉ាប់ អ្រយូច គ្រែដៃ យែស៊ូ ប៊ឹង លំចជែ។ ");
INSERT INTO brb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","អ៊ែ ម៉ើ ប៉្រៃ លុកស៊ិក មែ កឡឹ ដើម បូវ ម៉ើ ចក់ តៃ សឋិច ហ៊ែរ៉ូត ម៉ើ ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ណាយឃូ ញ៉ា ញ៉ើ ណោះ ឡើយ ហៃ ហបនឹះ ចនិះ ចាគ់ ដាវ ដើម កាន ហៃ ហពង់ហៀន អាំ មន់បើម ត្រួយ ប្រម៉ើត គ្រែដៃ ឡើ ដាវ ម៉ាត់ ម៉ាត ញឹះ តៃ ហឌូង ដើ មែ ង៉ាយ អ៊ឺម សំយ៉ះ មែ ទិះ ក្រាគ់ លឺ មែ តៃ ម៉ាត ប៊ីត ណាគ់ តៃ ហច្រលែក អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ប៉ាគ់ ពអ៊ែ ហំហាយ ឡាំង ដើ ញ៉ា ប៉ាគ់ ង៉ាយ ដើ ហៃ ហឃឹត តាម ចឞាប់ សុនសាត ង៉ាយ ណាគ់ ដូវ ឡះ ងន់អាំ លៀន ដើ សឋិច ទិះ មួង រ៉ូម ឡើ កាគ់ ហឹ ង៉ាយ លឺ ដូវ អ៊ឺម?»។ ");
INSERT INTO brb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","គ្រែដៃ យែស៊ូ ឡើ ណោះ ខនឹត តៃ ចាគ់ មែ អ៊ែ ឡើ ត្រណើវ រៀន៖ «បូវ ចជែ ពឃឺ ពរ៉គ់ ឌិវ បួរ អើយ ពយ៉ិ ឡើ ត្រ វ៉ើ បឡង ឝ្លាំង អៃ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","មិញ វន់ពដៃ អៃ ឡាំង កាក់ វែ វ៉ើ ខើយ អាំ ដើ សឋិច មួង រ៉ូម ឡើ កាគ់»។ អ៊ែ ម៉ើ ចក់ អាំ ហឹ ណគ មូយ កាក់។ ");
INSERT INTO brb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ប៊ឹង កាក់ នែ ហ៊ូប មែ ង៉ាយ ម៉ាត់ មែ ង៉ាយ?»។ ");
INSERT INTO brb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ម៉ើ ត្រណើវ រៀន៖ «ហ៊ូប ដើម ម៉ាត់ យ៉ាគ់ សឋិច ទិះ មួង រ៉ូម»។ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប៉ាគ់ ពអ៊ែ ណគ់ អង់ង៉ាយ ឡើ ត្រ វន់អាំ ដើ សឋិច ទិះ មួង រ៉ូម វន់អាំ ដើ សឋិច កឡឹ អ៊ែ ណគ់ អង់ង៉ាយ ឡើ ត្រ ថួយ ដើ គ្រែដៃ វន់ថួយ អាំ ដើ គ្រែដៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ហំប៊្រុះ ម៉ើ ដុង ឡើ ត្រណើវ ប៉ាគ់ អ៊ែ តូវ ម៉ើ ញ៉ម ទុត ខាក់ ប្រយ អ៊ែ ម៉ើ វីះ តើម ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ទឹង តង៉ៃ អន់ទឺ ប៊ិច បូវ មែ សាឌូស៊ី ម៉ើ ដក់ តង៉ា ប៉ាគ់ទឺ គ្រែដៃ យែស៊ូ។ បូវ មែ សាឌូស៊ី នែ ម៉ើ ចាប់ អ៊ឺម បនឹះ គែត មន់ញិវ ឡឹះ។ អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«យ៉ាគ់ ណាយឃូ យ៉ាគ់ ម៉ូស៊ែ ឡើ ខៀន ជុ ទឹង ចឞាប់ រៀន “ប៉ាគ់ បឹ អង់ង៉ាយ ឡើ គែត តៃ ដាន់ ប៊ិច កួន អំម៉ឹះ អ៊ែ អោះ កឡ ណគ អន់ណាវ លំត្រ ហ្រដូវ ម៉ី ណគ បក់ លំពឝ៉ើត កួន ថរ ម៉ាត់ អ៊ូគ ណគ ”។ ");
INSERT INTO brb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ងំព្រឌីវ រៀន ទឹង ស៊្រុក ញ៉ា ប៊ិច អំម៉ោះ អោះ កឡ ប៉ឹះ រ៉ា។ អ៊ូគ ឡង់ មែ ឡើ ចក់ ទ្រី ប៊្លី អ៊ែ ឡើ គែត តៃ ដាន់ ប៊ិច កួន អំម៉ឹះ អ៊ែ អោះ ប៊ឹង ងឺរ ណគ ឡើ ហ្រដូវ ម៉ី ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ប៊្លី អ៊ែ ឡើ គែត តៃ ដាន់ ប៊ិច កួន ប៉ាគ់ទឺ។ អោះ ទី បារ ទី ពែ ឆា ដើ លែក មែ ប៉ឹះ រ៉ា ម៉ើ ចក់ ណាង អ៊ែ ម៉ើ គែត តៃ ដាន់ ប៊ិច កួន លែក ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","តគ់ ប៊្លី អ៊ែ ណាង អ៊ែ ឡើ គែត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ប៉ាគ់ ពអ៊ែ តគ់ បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ កទ្រី អ៊ែ លំត្រ ទ្រី មែ ង៉ាយ យ៉ាក់ លែក មែ ប៉ឹះ រ៉ា ម៉ាត់តូវ ក្ល ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «ខនឹត វែ ឡើ យូច ឡើយ ញ៉ន តៃ វ៉ើ ហឝ៉ាវ ពឹម គ្រែដៃ ដើម តៃ វ៉ើ ហឝ៉ាវ កាន ឆង៉ាត់ គ្រែដៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","យ៉ាក់ តគ់ បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ ប៊ិច យ៉ាវ មន់ចក់ ទ្រី ក្ល មន់បើម ប៉ាគ់ ឞាវ គ្រែដៃ ទឹង ហូង គ្រែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ណគ់ កាន បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ គ្រែដៃ ឡើ ហាយ ឡើយ ដើ វែ វ៉ើ អាន អ៊ឺម ឡះ? ឡើ រៀន ");
INSERT INTO brb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“អៃ នែ អគ្រែដៃ យ៉ាគ់ អាប្រាហាំ អ៊ីសាគ់ ដើម យ៉ាកុប”។ គ្រែដៃ ត្រ អ៊ឺម ឡើ គ្រែដៃ ដើ បនឹះ គែត ឡើ គ្រែដៃ ដើ បនឹះ ញិវ ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","តគ់ មែ ប៉ាសាសុន ម៉ើ ដុង កាន ណគ ឡើ ពង់ហៀន អ៊ែ តូវ ម៉ើ ញ៉ម ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ប៊ឹង បូវ ផារីស៊ី ម៉ើ ដុង រៀន គ្រែដៃ យែស៊ូ ឡើ បើម អាំ បូវ សាឌូស៊ី ញឹះ តៃ ម៉ើ ណោះ តើវ យ៉ាវ ម៉ើ ពទុំ ត្រឌីវ មែ អ៊ែ ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ទឹង បូវ មែ ប៊ិច មូយ រ៉ា ឡើ ណោះ ចឞាប់ ទុត ឈ្រុ ឡើ តង៉ា បឡង ឝ្លាំង គ្រែដៃ យែស៊ូ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«យ៉ាគ់ ណាយឃូ លែក ដើ ចឞាប់ គ្រែដៃ ចឞាប់ មូយ ង៉ាយ ឡើ ខា ជឺរ?»។ ");
INSERT INTO brb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ឡើ ត្រណើវ រៀន៖ «វន់ត្រ ម៉ើត ដើ គ្រែដៃ ឡើ កន់ដ្រាគ់ វែ អាំ លែក ដើ ក្លើម ក្លាក លែក ដើ ផវ យ៉ាង ដើម លែក ដើ ចនិះ។ ");
INSERT INTO brb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","អន់នែ ឡើយ ចឞាប់ ទី មូយ ឡើ ខា ជឺរ ចឞាប់ អង់គែងៗ។ ");
INSERT INTO brb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","អ៊ែ ណគ់ ចឞាប់ ទី បារ ឡើ ខា ឞាល់ ទឺ “វន់ត្រ ម៉ើត ដើ បូវ ប៊ែង ឞាល់ វ៉ើ ម៉ើត ដើ ចាក់ វែ កឡឹ ទឺ”។ ");
INSERT INTO brb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","បារ ចឞាប់ នែ ឡើយ ឡើ តើម លែក ដើ ចឞាប់ គ្រែដៃ ដឹប លែក ដើ ប្រម៉ាង បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ើ ខៀន ជុ ទឹង ពឹម»។ ");
INSERT INTO brb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ទឹង បូវ ផារីស៊ី ណាគ់ ម៉ើ គូ ពទុំ ប៊ឹង ណគ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«ប៉ាគ់ ង៉ាយ ដើ វែ វ៉ើ ឃឹត ដើ គ្រែដៃ គ្រិះ នែ ឡើ កួន ចូវ មែ ង៉ាយ?»។ មែ ម៉ើ ត្រណើវ រៀន៖ «កួន ចូវ យ៉ាគ់ សឋិច ដាវីត»។ ");
INSERT INTO brb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","គ្រែដៃ យែស៊ូ ឡើ តង៉ា ឡឹះ មែ រៀន៖ «ប៉ាគ់ គ្រែដៃ គ្រិះ ឡើ កួន ចូវ សឋិច ដាវីត ម៉ាត់ ម៉ាត ប៉ិ ឡើ ត្រ ផវ យ៉ាង គ្រែដៃ ឡើ បើម អាំ សឋិច ដាវីត ឡើ ជុ គ្រែដៃ គ្រិះ រៀន “កន់ដ្រាគ់ អៃ”? ឡើ រៀន ");
INSERT INTO brb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“គ្រែដៃ កន់ដ្រាគ់ ឡើ ហាយ ដើ កន់ដ្រាគ់ អៃ រៀន ហន់ឌឹក ដ្រូម តៃ ចម៉ា អៃ នែ ទឹង ហូច អំពញ៉ម ណគ់ មែ ម៉ើ ដ្រម៉ា ដើ ហៃ អំជុ ក្រូម ត្រប៉ាង ឈឹង ហៃ ”»។ ");
INSERT INTO brb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«ប៉ាគ់ សឋិច ដាវីត ឡើ ជុ គ្រែដៃ គ្រិះ រៀន “កន់ដ្រាគ់ ណគ” ប៉ិ លំប៉ិន គ្រែដៃ គ្រិះ នែ លំកួន ចូវ សឋិច ដាវីត ប៉ាគ់ អ៊ិន!» ");
INSERT INTO brb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ញឹះ តៃ ប៊ិច មូយ រ៉ា មន់ណោះ ត្រណើវ ណគ ហមយ៉ះ មូយ អំម៉ាង ណាគ់ តៃ ម៉ើ ណោះ។ តើម ប៊ឹង អ៊ែ ញឹះ តៃ ប៊ិច មែ ង៉ាយ យ៉ាវ មន់ហាន តង៉ា ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ ប៉ាសាសុន ដើម បូវ លុកស៊ិក ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី ម៉ើ កឡា ពង់ហៀន ចឞាប់ ថរ យ៉ាគ់ ម៉ូស៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ប៉ាគ់ ពអ៊ែ លែក ដើ កាន មែ ម៉ើ ពង់ហៀន វែ វន់ចង់ហៀង ដើម វន់បើម ត្រួយ ហឹ អិះ ឡើយ ម៉ាត់ ញ៉ង វន់ត្រួយ តាម មែ ម៉ើ បើម យ៉ាក់ មែ កឡឹ ម៉ើ បើម ត្រួយ អ៊ឺម តាម កាន ម៉ើ ពង់ហៀន។ ");
INSERT INTO brb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","មែ អ៊ែ ម៉ើ ពឝ៉ើត ចឞាប់ ទុត ញ៉ាក ម៉ើ ពធុក បនឹះ ណគ់ ដើ មែ កឡឹ ម៉ើ ឌី អ៊ឺម ប៉ូរ សំ ឌិត ត្រពួច ណាគ់ តៃ ម៉ើ ឌី ប៉ូរ ឡាំងៗ។ ");
INSERT INTO brb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","លែក ដើ កាន មែ ម៉ើ បើម ឝ៉ាន់ ដើ បនឹះ មន់តៃ ម៉ើ បើម កអ៊ែប ចាំ ទិះ ម៉ើ គឺន ទិ ត្រងឺវ ដឹប ម៉ើ ប៊ិច ក្រប៊ុយ អាវ ឝ៉ុះៗ ។ ");
INSERT INTO brb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ម៉ើ ម៉ើត ដ្រូម ប៊ឹង ដ្រុនដ្រូម យ៉ូក យ៉ាល់ ទឹង ឞន ញែត ចង់ ទិះៗ ដើម ម៉ើ ម៉ើត ដ្រូម ទឹង រ៉ូង ពស៊ុំ ហឹ ងឺរ បូវ។ ");
INSERT INTO brb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","បូវ មែ នែ ម៉ើ ម៉ើត អាំ បនឹះ ម៉ើ ហំបះ មែ ហឹ តឡាត ដើម ម៉ើ ជុ មែ រៀន “យ៉ាគ់ ណាយឃូ”។ ");
INSERT INTO brb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ញ៉ង វ៉ើ អាំ អ៊ឺម បូវ មន់ជុ វែ “យ៉ាគ់ ណាយឃូ” យ៉ាក់ វ៉ើ ប៊ិច ណាយឃូ វ៉ិះ ឌិវ មូយ អិះ ឡើយ អ៊ែ លែក ដើ វែ ម៉ាត់តូវ វ៉ើ អំម៉ោះ អោះ ត្រឌីវ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ញ៉ង វ៉ើ កឡូវ អ៊ឺម មែ ង៉ាយ ទិ ឡាង ប្រិះ នែ វន់ជុ “បើគ” យ៉ាក់ វ៉ើ ប៊ិច បើគ វ៉ិះ ឌិវ មូយ អិះ ឡើយ ណគ ឡើ គូ ទឹង ហូង គ្រែ ទិ។ ");
INSERT INTO brb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ញ៉ង វ៉ើ អាំ អ៊ឺម មែ មន់ជុ វែ រៀន “ណាយ ពង់ឝឹង” យ៉ាក់ វ៉ិះ ឌិវ គ្រែដៃ គ្រិះ ឡើយ ឡើ ណាយ ពង់ឝឹង វែ។ ");
INSERT INTO brb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ទឹង បូវ វែ ណគ់ បឹ អង់ង៉ាយ ឡើ បើម ទិះ ក្រាគ់ ណគ អ៊ែ ឡើយ ឡើ ត្រ បើម ឞយ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ណគ់ មែ ង៉ាយ ម៉ើ ពឌឹក ចាក់ មែ អ៊ែ គ្រែដៃ លំពន់ដាប អន់ណាវ។ អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ ពន់ដាប ចាក់ មែ អ៊ែ គ្រែដៃ លំពឌឹក អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ឌឹង ដ្រាគ់ ទ្រូង វ៉ើ អាំ អ៊ឺម បូវ មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់។ តៃ ត្រ វ៉ិះ ឌិវ វែ កឡឹ អ៊ឺម តៃ វ៉ើ ឌី មឹត ដើម តៃ វ៉ើ អាំ ណគ់ មែ ម៉ើ ងុញ មឹត ដិ»។ ");
INSERT INTO brb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ អ្យគ់ តបូត ចក់ ហន់ណាម រ៉ាះ អំបាះ មែ ម៉ិយូ កម៉ាយ ដើម វ៉ើ អ៊ឺរ ដាំង គ្រែដៃ ទុត ឌុញ ឃឺ អង់ឃឺ។ អ៊ែ វន់ត្រ ថូត ទុត កយឹក ជឺរ បនឹះ ហឹ គែង អន់ណាវ!»។ ");
INSERT INTO brb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ដក់ ក្លង ឡាត់ ប្រិះ ប៊្រី ដើម សមុត បក់ វ៉ើ ពន់ឆូម ពង់អ៊ុច បូវ មន់ដក់ តូយ ហ៊ីត ខើយ វែ ហមយ៉ះ ឌិវ មូយ រ៉ា លំមឹត តូយ វែ។ តគ់ ឡើ មឹត ឡើយ វ៉ើ បើម អាំ ណគ តៃ លំចាគ់ ជឺរ វែ បារ តង អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«បូវ សូត ម៉ាត់ វ៉ើ ច្រា បនឹះ តូយ វែ អើយ! វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ រៀន “មែ ង៉ាយ ម៉ើ តប៉ឹន ចាក់ ចក់ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ បើម កឡា តៃ ប្រម៉ាង តប៉ឹន ចាក់ អ៊ែ តៃ ឡើ ឆង៉ាត់ អ៊ឺម។ ហាក់ ប៉ាគ់ ម៉ើ តប៉ឹន ចាក់ ចក់ ឆៀង ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ លំបើម កឡា តៃ អ៊ែ ប្រម៉ាង តប៉ឹន ចាក់ មែ លំឆង៉ាត់ ម៉ាត់ ម៉ាត”»។ ");
INSERT INTO brb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","«បូវ សូត ម៉ាត់ អន់ឌ្រូយ អើយ! អង់ង៉ាយ ឡើ ឆង៉ាត់ ជឺរ ឆៀង លឺ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ បើម អាំ ឆៀង លំភែង យ៉ើម? ");
INSERT INTO brb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","វ៉ើ ម៉ាង ឡឹះ រៀន “មែ ង៉ាយ ម៉ើ តប៉ឹន ចាក់ ចក់ ហ៊ីប ថនួយ បើម កឡា តៃ ប្រម៉ាង តប៉ឹន ចាក់ អ៊ែ តៃ ឡើ ឆង៉ាត់ អ៊ឺម។ ហាក់ ប៉ាគ់ ម៉ើ តប៉ឹន ចាក់ ចក់ រ៉ាះ ម៉ប ដើ គ្រែដៃ បើម កឡា តៃ អ៊ែ ប្រម៉ាង តប៉ឹន ចាក់ មែ ឡើ ឆង៉ាត់ ម៉ាត់ ម៉ាត”។ ");
INSERT INTO brb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","បនឹះ សូត ម៉ាត់ អើយ! អង់ង៉ាយ ឡើ ឆង៉ាត់ ជឺរ អន់ណាំ ម៉ប លឺ ហ៊ីប ថនួយ ឡើ បើម អាំ អន់ណាំ ម៉ើ ម៉ប នែ ឡើ ភែង យ៉ើម? ");
INSERT INTO brb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ប៉ាគ់ ពអ៊ែ មែ ង៉ាយ ម៉ើ តប៉ឹន ចាក់ ចក់ ហ៊ីប ថនួយ បើម កឡា តៃ មែ អ៊ែ ម៉ើ ប៊ិច ហ៊ីប ថនួយ ដឹប លែក ដើ អន់ណាំ ពឺង អ៊ែ បើម កឡា តៃ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","មែ ង៉ាយ ម៉ើ តប៉ឹន ចាក់ ចក់ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ បើម កឡា តៃ មែ អ៊ែ ម៉ើ ប៊ិច រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ដឹប គ្រែដៃ ឡើ គូ ទឹង រ៉ូង អ៊ែ ឡើ កឡា តៃ មែ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ តប៉ឹន ចាក់ ចក់ ហូង គ្រែ បើម កឡា តៃ មែ អ៊ែ ម៉ើ ប៊ិច ទិង មៀង គ្រែដៃ ដឹប គ្រែដៃ ឡើ ដ្រូម ប៊ឹង ទិង មៀង ឡើ កឡា តៃ មែ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ម៉ប លហម កសុំ ក្រៀម កដៀម ប្លង់ កនុង ជិត វ៉ើ អាំ មូយ ដើ គ្រែដៃ ហាក់ វ៉ើ តាក់ កាន ឡើ ប៊ិច ខា ជឺរ ទឹង ចឞាប់ ប៉ាគ់ ឡើ កាន ចាគ់ ទឹង ត្រ កាន ស្រុស្រៀត បៀត ដើម កាន ទឹង ត្រ។ កាន លែក នែ ឡើយ វន់ត្រ បើម អ៊ែ ណគ់ កាន ម៉ប អាំ ដើ គ្រែដៃ ញ៉ង វ៉ើ វឺញ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","«បូវ សូត ម៉ាត់ វ៉ើ ច្រា បនឹះ តូយ វែ អើយ! វ៉ើ ប៉្លយ តាក់ ហំម៉ូច អិតអាត់ តើម ប៊ឹង ដាក ហាក់ សរ៉ើម វ៉ើ លឹន រោះ លែក អំប៉ម អន់ណាវ!»។ ");
INSERT INTO brb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ហដា ចក វ៉ិះ តៃ ដៀក ដើម តង់ឝ៉ាន វ៉ិះ តៃ កណង ហាក់ ទិ កនុង ឡើ ប៊ិង ដើ រ៉ាះ វ៉ើ តទូង ដើម ដើ កាន ពនឺង ពឋម។ ");
INSERT INTO brb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","បូវ ផារីស៊ី សូត ម៉ាត់ អើយ! មិញ វន់ហដា ចក ទិ កនុង អន់ដៃ អ៊ែ តៃ ដៀក លំចាគ់ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ បើម ប៉ាគ់ ក្រឌូប ឡូង កយ៉ក់ ម៉ើ ឡច ដើ កំឞូរ បក តៃ ពឺង ឡើ ចាគ់ ម៉ាត់ ម៉ាត ហាក់ ទិ កនុង ម៉ាត់តូវ កឌឺង កយ៉ក់ ដើម សុ ស៊្រឺយ តៃ ណោះ នែវ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ប៉ាគ់ទឺ ឡើយ ដើ វែ តៃ ពឺង វ៉ើ ពដៃ ដើ បូវ ប៉ាគ់ ចាគ់ ទឹង ត្រ ហាក់ ទិ កនុង ចនិះ វែ វ៉ើ ប៊ិង ដើ កាន ពឃឺ ដើម ដើ កាន អន់លឺន ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«អើយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ ផារីស៊ី វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វន់ត្រ ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ បើម ហន់ណាម ចាគ់ៗ ដើ លុង កយ៉ក់ បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម វ៉ើ ឆើម ទែម ពរ៉គ់ ពន់សំ ហន់ណាម លុង កយ៉ក់ បនឹះ ចាគ់ ទឹង ត្រ ");
INSERT INTO brb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ដើម វ៉ើ ម៉ាង រៀន “ប៉ាគ់ ងំដាន់ ប៉ាង ម៉ិ យ៉ាគ់ ង៉ាយ ពន់ឋើម ង៉ាយ ងន់ឈែវ អ៊ឺម ប៊ឹង មែ ម៉ើ កជែត ពលូះ ផាម មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ”។ ");
INSERT INTO brb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","វ៉ើ ម៉ាង ប៉ាគ់ អ៊ែ វែ កឡឹ វ៉ើ ហាយ ចាក់ រៀន វ៉ើ កួន ចូវ មែ ម៉ើ កជែត បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ប៉ាគ់ ពអ៊ែ មិញ វន់បើម បយ៉ឹះ កាន ម៉ិ យ៉ាគ់ វែ ម៉ើ បើម ពន់ឋើម! ");
INSERT INTO brb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","បូវ ប៊ិះ កួន ចូវ ប៊ិះ ប្រៃ អើយ! ញ៉ង វ៉ើ មឹង អ៊ឺម វន់ក្លើច តើម ប៊ឹង កាន ពថូត វន់គ្លីះ ទិ ហួម អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ញ៉ន ដើ អ៊ែ ឡើយ អ៊ែ អំប៉្រៃ បូវ កឡា ឈូន ប្រម៉ាង គ្រែដៃ បូវ ហ្រឡិច ហ្រឡាង ដើម បូវ កឡា ពង់ហៀន មន់ដក់ ហឹ វែ ហាក់ ណគ់ មែ អន់នឺ វន់កជែត មែ អន់នឺ វន់ពឡាះ ប៉ាង ប៊ឹង ឡង អង់ឝ៉ាង មែ អន់នឺ អន់ណាវ វន់បឹត ដើ ឆមឺ ប្រាត់ ទឹង រ៉ូង ពស៊ុំ វ៉ើ កឡឹ ដើម វន់ឆ្រួយ ដាំង តំឞាប មែ តើម ប៊ឹង មួង មូយ ដាំង មួង មូយ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ប៉ាគ់ ពអ៊ែ គ្រែដៃ លំតុ ហឹ វែ លែក ដើ ផាម បនឹះ ចាគ់ ទឹង ត្រ ណគ់ ម៉ិ យ៉ាគ់ វែ ម៉ើ កជែត ពលូះ ផាម ណាប់ តើម ប៊ឹង ផាម យ៉ាគ់ អ៊ែបិល ឡើ បនឹះ ចាគ់ ទឹង ត្រ ឆា ដើ ប៊ឹះ ផាម យ៉ាគ់ សាការ៉ៃ កួន យ៉ាគ់ បារ៉ាកៀ ណគ់ ម៉ិ យ៉ាគ់ វែ ម៉ើ កជែត ប្លះ ហ៊ីប បប៊ុះ ថួយ អរ៉ះ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ។ ");
INSERT INTO brb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន គ្រែដៃ លំពថូត តគ់ ប៉ាង វែ ញ៉ន ដើ កាន តៃ ចាគ់ វែ ដឹប ម៉ិ យ៉ាគ់ វែ វ៉ើ បើម»។ ");
INSERT INTO brb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«អើយ យែរូសាឡឹម យែរូសាឡឹម អើយ វែ វ៉ើ កជែត មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម វ៉ើ ពៀវ កជែត ដើ តម៉ ណគ់ មែ គ្រែដៃ ឡើ ប៉្រៃ ដក់ ហឹ វែ។ តៃ ណោះ ស៊ិ តង ឡើយ អងុញ តមួត យ៉ើក កួន ចូវ វែ ប៉ាគ់ អៀរ ឡើ ពុះលុំ កួន ណគ ដើ ហឡាប ហាក់ វ៉ើ ឌី អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","វន់ឝ្លាំង យ៉ឹ គ្រែដៃ លំតាក់ មួង វែ អ៊ែ លំហ្រង៉វ។ ");
INSERT INTO brb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","យ៉ាក់ អៃ អង់ហាយ ដើ វែ រៀន តើម ប៊ឹង នែ ឞិះ ហឹ ងឺរ តគ់ វន់តៃ យ៉ាវ អៃ ឆា ដើ ប៊ឹះ វន់ម៉ាង រៀន “ឡា គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ បឹ ឡើ ប៊ឹះ ទឹង ម៉ាត់ គ្រែដៃ កន់ដ្រាគ់!”»។ ");
INSERT INTO brb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ទឹង ប៉ះ ឡើ ដក់ បូវ លុកស៊ិក ម៉ើ ដក់ ចឹម ចើម តគ់ ណគ ម៉ើ ចង់អូត ពដៃ ណគ លំឝ្លាំង លែក ដើ ហន់ណាម ទឹង ឞន រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ មែ រៀន៖ «វន់ឝ្លាំង យ៉ឹ ហន់ណាម លែក នែ! ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ហន់ណាម លែក នែ លំប៊្លឺគ ដឡាយ លែក តាក់ លំប៊ិច យ៉ាវ តម៉ លំព្រឌឺន ពឺង តម៉ យ៉ាក់ មែ ដ្រម៉ា មន់ឝឹ លែក តាក់!»។ ");
INSERT INTO brb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ប៊្លី អ៊ែ តគ់ គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ទឹង ចន់ឌូ តើម អូលីវ អ៊ែ បូវ លុកស៊ិក ម៉ើ ដក់ ពន់ចើម តគ់ ណគ វ៉ិះ ឌិវ មែ ម៉ើ តង៉ា រៀន៖ «ឡា ហំហាយ ដើ ញ៉ា ដមិញ កាន ហង់អ៊ិន លំប៊ឹះ? ប៊ឹង ង៉ាយ ញំណោះ ហឝ៉ាវ រៀន ហៃ ដៀប ហំប៊ឹះ ឡើយ ដើម ដៀប លំឡូច ឡាង ប្រិះ ឡាង គ្រែ?»។ ");
INSERT INTO brb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «វែ វន់ត្រ លវាំង យ៉ឹ ញ៉ង វ៉ើ បូត អ៊ឺម ដើ មែ មន់ដាំង តបូត វែ! ");
INSERT INTO brb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","យ៉ាក់ លំប៊ិច បនឹះ ទុត អើន មន់ចើះ ចាក់ ម៉ាត់ អៃ មន់ហាយ រៀន “អៃ នែ ឡើយ អគ្រែដៃ គ្រិះ”។ មែ មន់តបូត បនឹះ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ប៊ឹង វន់ដុង ឡើ ប៊ិច កាន ប្រណើម ចើម តមឹង ចង៉ាយ តមឹង ញ៉ង វ៉ើ ឌូង អ៊ឺម ប្រយ យ៉ាក់ កាន ប្រណើម នែ តង លំប៊ិច ម៉ាត់ ម៉ាត ហាក់ ឡាង ប្រិះ ឡាង គ្រែ ប៊ឹះ អំម៉ឹះ លំឡូច។ ");
INSERT INTO brb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","លំប៊ិច សុនសាត មូយ មន់ប្រណើម ដើ សុនសាត មូយ ពធែត មូយ មន់ប្រណើម ដើ ពធែត មូយ។ ទុត អើន អំប៊ុ លំប៊ិច កាន អឹត ហរុ ដឹប ឆនិ អន់តុ  ដើម លំអង់ឝឹត ឡាង ប្រិះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","កាន លែក នែ ឡើ បើម ប៉ាគ់ ឆនិ មែ កទ្រី ឈិ អន់ឆិ អន់ចិះ អន់ចាំ»។ ");
INSERT INTO brb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«ទឹង អ៊ែ មន់រ៉ាប់ តៀត វែ ហឹ ទី មែ អាំ មន់តំឞាប ដើម មន់កជែត វែ។ បនឹះ លែក ដើ សុនសាត ញឹះ តៃ មន់រែម ឡាំងៗ ដើ វែ ញ៉ន ដើ វ៉ើ តូយ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ទឹង កាន អ៊ែ លំប៊ឹះ លំប៊ិច បនឹះ ទុត អើន មន់តាក់ កាន ចាប់ មឹង មន់ខ្រណិច ត្រឌីវ បូវ ដើម តៃ មន់ហំពែម ត្រឌីវ បូវ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","លំប៊ិច កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឆ្រឡិ ឆ្រលួគ ទុត អើន មន់តបូត បនឹះ អើនៗ អាំ មន់តាក់ កាន ចាប់ មឹង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","លំប៊ិច កាន តៃ ចាគ់ ចាំ ម៉ៃៗ អ៊ែ បនឹះ ទុត អើន មន់ប៊ិច យ៉ាវ កាន ហំពែម ត្រឌីវ បូវ។ ");
INSERT INTO brb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ហាក់ ណគ់ មែ ង៉ាយ មន់អុតថុន ឆា ដើ ឡូច មែ អ៊ែ គ្រែដៃ លំហវ៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","មន់ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ឡើ ពែក ប៉ាក់ បុ ឡាង ប្រិះ នែ អាំ បនឹះ ត្រំ សាត មន់ដុង អន់ដៃ។ អ៊ែ លំប៊ឹះ ឡាង ប្រិះ ឡាង គ្រែ លំឡូច»។ ");
INSERT INTO brb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«ប៊ឹង វន់តៃ រ៉ាះ តៃ ចាគ់ បើម ម៉ឹ ហំម៉ឹ លំឆុង ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ ត្រ ប៉ាគ់ យ៉ាគ់ ដានីយែល ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ អន់នួរ ឡើយ »។ (ឡា អាំ មែ កឡា អាន កាន នែ មន់ឃឹត អាំ ណោះ ហឡាក់ យ៉ឹ!) ");
INSERT INTO brb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","«ប៊ឹង អ៊ែ ណគ់ មែ ម៉ើ គូ ទឹង ស្រុក យូដា មន់ត្រ អ្រយ៉ាវ ព្រដិច ចាក់ ទឹង ចន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","អ៊ែ ណគ់ មែ ម៉ើ គូ ទឹង បូយ ហន់ណាម មន់ត្រ ទឺះ អ្រយ៉ាវ ប្រយ ញ៉ង ម៉ើ មឹត ចក់ យ៉ាវ រ៉ាះ អំបាះ ហឹ កនុង ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ណគ់ មែ ម៉ើ គូ ហឹ មឺរ មន់ត្រ រ៉ូះ ប្រយ ញ៉ង មន់ជឹ វឹញ ចក់ យ៉ាវ អាវ ឌ្រឹម ហឹ ស៊្រុក។ ");
INSERT INTO brb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ទឹង អ៊ែ ណគ់ មែ កទ្រី តមែវ តៃ ម៉ាង មែ កទ្រី តពុ កួន មន់ធុក ញ៉ាក ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","មិញ វន់អ៊ឺរ ដាំង ឡា ទឹង គ្រែដៃ អ៊ែ ញ៉ង វន់អ្រយ៉ាវ ព្រដិច ចាក់ ទឹង ញ៉ាម ឆឈុយ លឺ ទឹង តង៉ៃ ព្រឹង ");
INSERT INTO brb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","យ៉ាក់ ទឹង ប៉ាង អ៊ែ លំប៊ិច កាន ធុក ញ៉ាក ប៉ាប ពុន ទុត ខាក់ តើម ប៊ឹង គ្រែដៃ ឡើ ពឝ៉ើត ពដិះ គ្រែ ឆា ដើ ប៊ឹះ ត្រំ តង៉ៃ នែ សំយ៉ះ ឞិះ ហឹ ងឺរ តគ់ អន់ណាវ លំប៊ិច យ៉ាវ កាន ធុក ញ៉ាក ប៉ាក ម៉ង ញឹះ ឞាល់ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ប៉ាគ់ គ្រែដៃ តៃ លំពកើយ អន់នួរ តង៉ៃ ត្រ ធុក ញ៉ាក លែក អ៊ែ តៃ ប៊ិច បនឹះ អង់ង៉ាយ អ៊ឺម មន់ញិវ។ ហាក់ គ្រែដៃ ឡើ ពកើយ ឡើយ តង៉ៃ លែក អ៊ែ ញ៉ន ដើ បនឹះ ណគ់ ណគ ឡើ រ៉ើះ»។ ");
INSERT INTO brb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«ប៊ឹង អ៊ែ ប៉ាគ់ លំប៊ិច មែ មន់ហាយ ដើ វែ រៀន “គ្រែដៃ គ្រិះ ឡើ គូ ហឹ នែ” លឺ មន់រៀន “ឡើ គូ ហឹ តគ់” ញ៉ង វ៉ើ ចាប់ អ៊ឺម យ៉ឹ មែ។ ");
INSERT INTO brb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","យ៉ាក់ លំប៊ិច បនឹះ អន់នឺ មន់ចើះ ចាក់ រៀន ម៉ើ គ្រែដៃ គ្រិះ ដើម លំប៊ិច មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឆ្រឡិ ឆ្រលួគ មែ លែក អ៊ែ មន់ពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ ទុត ទិះ ដើម កាន បើម ញ៉ម ដិ អន់ដិ បក់ មន់តបូត បនឹះ ដឹប មែ ណគ់ គ្រែដៃ ឡើ រ៉ើះ ប៉ាគ់ ណាគ់ មន់ដូវ។ ");
INSERT INTO brb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","អៃ អហាយ កាន លែក នែ ដើ វែ អាំ វន់ណោះ អន់នួរ»។ ");
INSERT INTO brb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«ប៉ាគ់ មន់ហាយ ដើ វែ រៀន “គ្រែដៃ គ្រិះ ឡើ គូ ហឹ ត្រិញ ក្លៀវៗ” ញ៉ង វ៉ើ ដក់ ឝ្លាំង អ៊ឺម។ ប៉ាគ់ មន់រៀន “ឡើ គូ ហឹ កនុង ហន់ណាម” ញ៉ង វ៉ើ ចាប់ អ៊ឺម ប៉ាគ់ទឺ ម៉ាង មែ។ ");
INSERT INTO brb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","យ៉ាក់ តគ់ កួន បនឹះ លំប៊ឹះ លំបើម ប៉ាគ់ គ្រែ លលីប លំញឺះ ហ្រប៊្លីប តើម ប៊ឹង ម៉ាត់ តង៉ៃ ឌឹក ឞិះ ហឹ ម៉ាត់ តង៉ៃ លុច មន់តៃ លែក រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ចកាប់ ហឹ ង៉ាយ ជែម មិត ម៉ើ តមួត ហឹ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«តគ់ កាន ធុក ញ៉ាក នែ លំក្លើច ឡើយ ម៉ាត់ តង៉ៃ លំហ្រង៉ូម ប៊្រែ ណគ់ កើត លំឝ៉ាល យ៉ាវ អ៊ែ ពតួរ មន់គ្លីះ តើម ទិ គ្រែ ដើម គ្រែដៃ លំក្រស៊ូ អាំ លែក ទឹង ឡាង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ប៊ឹង អ៊ែ បនឹះ មន់តៃ កាន ហឝ៉ាវ ទឹង គ្រែ ពដៃ រៀន កួន បនឹះ លំប៊ឹះ។ លែក សុនសាត ទិ ឡាង ប្រិះ នែ មន់ញឺម ឝ្រង៉ឹត ស្រូក មន់តៃ កួន បនឹះ លំប៊ឹះ ពឺង យូក ដើ អាតណាត ឆង៉ាត់ អូងអាត យ៉ូកយ៉ាល់ តៃ ឋាំ ");
INSERT INTO brb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","លំលឺ ដដៀត តកួយ ទុត ថាំង អ៊ែ លំប៉្រៃ បូវ ឞាវ ណគ មន់ដក់ លែក ពួន ចំឞ៊ែង ឡាង ប្រិះ តើម ប៊ឹង ឈឹង គ្រែ តៃ នែ ប៊ឹះ ឈឹង គ្រែ តៃ តគ់ មន់តមួត បនឹះ ណគ់ គ្រែដៃ ឡើ រ៉ើះ»។ ");
INSERT INTO brb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«ហឹ វន់ឃឹត អាំ ខាក់ៗ កាន ព្រឌីវ ប៊ឹង តើម កប៉ក់ នែ ប៊ឹង វ៉ើ កគ់ តៃ ឝឹង ណគ ឡើ កយ៉ិ ហឡា ណគ ញឹះ លអៀវ អ៊ែ វ៉ើ ណោះ រៀន ដៀប លំប៊ឹះ ញ៉ាម ដុ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ប៉ាគ់ អ៊ែ ទឺ ឡើយ ប៊ឹង វន់តៃ កាន លែក អ៊ិន លំកើត អ៊ែ វន់ណោះ រៀន កួន បនឹះ ដៀប លំប៊ឹះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន កាន លែក អ៊ិន លំកើត ទឹង បនឹះ ប៉ាង អន់នែ តៃ ដាន់ មន់គែត អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ឡាង គ្រែ ដើម ឡាង ប្រិះ លំប៉ាត់ ពណាត់ លែក អ៊ែ ណគ់ ប្រម៉ាង អៃ លំណាគ់ អន់សច លំប៉ាត់ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«អ៊ែ ណគ់ តង៉ៃ លឺ ម៉ូង កាន អ៊ិន លំកើត តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ ណោះ សំយ៉ះ ឞាវ គ្រែដៃ ទឹង ហូង គ្រែ លឺ កួន កឡ គ្រែដៃ ណាគ់ តៃ ម៉ើ ណោះ ប៉ាគ់ទឺ វ៉ិះ ឌិវ គ្រែដៃ បើគ កឡឹ ឡើ ណោះ។ ");
INSERT INTO brb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","តគ់ កួន បនឹះ លំប៊ឹះ លំបើម ប៉ាគ់ ទឹង ប៉ាង យ៉ាគ់ ណូអ៊ែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","តៃ ដាន់ ដាក ឡើ លែប បនឹះ ចម៉ាវ វ៉ិះ ឌិវ ម៉ើ ឃឹត ញញែត ចចង់ ប្រយ៉ង់ ប្រយ៉ា ចក់ ទ្រី ក្ល ឆា ដើ ប៊ឹះ តង៉ៃ យ៉ាគ់ ណូអ៊ែ ឡើ មឹត ទឹង ឌូក ទិះ ");
INSERT INTO brb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ញឹះ តៃ ម៉ើ ណោះ ឡាំងៗ ឆា ដើ ប៊ឹះ ដាក លែប ឡើ ឞរ មែ គែត លែក តាក់។ ប៉ាគ់ អ៊ែ ទឺ ឡើយ តគ់ កួន បនឹះ លំប៊ឹះ ");
INSERT INTO brb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ទឹង អ៊ែ ប៉ាគ់ លំប៊ិច កឡ បារ រ៉ា អំប្រា គូ ទឹង មឺរ គ្រែដៃ លំចក់ មូយ រ៉ា លំជុ មូយ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ប៉ាគ់ លំប៊ិច កទ្រី បារ រ៉ា ទឹង អំប្រា លំតវ៉ិះ គ្រែដៃ លំចក់ មូយ រ៉ា លំជុ មូយ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ប៉ាគ់ ពអ៊ែ វន់ធៀវ យ៉ឹ យ៉ាក់ វ៉ើ ណោះ អ៊ឺម ណោះ តង៉ៃ ង៉ាយ កន់ដ្រាគ់ វែ លំប៊ឹះ។ ");
INSERT INTO brb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","វែ វ៉ើ ណោះ ឡើយ រៀន ប៉ាគ់ កន់ដ្រាគ់ ហន់ណាម លំណោះ ម៉ូង បឹ តទូង លំប៊ឹះ លំធៀវ ឡើយ លំអាំ អ៊ឺម លំមឹត ទឹង ហន់ណាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ប៉ាគ់ ពអ៊ែ វែ វន់ត្រ ត្រៀម ចាក់ ដៃ វែ យ៉ាក់ វ៉ើ ណោះ អ៊ឺម ណោះ ម៉ូង ង៉ាយ កួន បនឹះ លំប៊ឹះ ឡឹះ»។ ");
INSERT INTO brb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«ណគ់ ឞយ អង់ង៉ាយ ឡើ ទឹង ត្រ ដើម ឡើ ហ្រឡិច ហ្រឡាង ឞយ ហង់អ៊ែ ឡើយ កន់ដ្រាគ់ ណគ លំពឌឹក ពឺង ឞយ គែង អ៊ែ ទឹង កាន ព្រណាក ចណង់ ចណា ដើ មែ ត្រំ តង៉ៃ តាម ម៉ូង ចង់ ចា។ ");
INSERT INTO brb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","តគ់ យ៉ាគ់ កន់ដ្រាគ់ ឡើ ជឹ វឹញ លំតៃ ឞយ ណគ ណាគ់ ឡើ ពពឹត បបើម ត្រួយ តាម ពន់ដ្រៃ ណគ ឞយ ហង់អ៊ែ លំហ្រនុក ហ្រវ៉ាក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន យ៉ាគ់ កន់ដ្រាគ់ លំអាំ ប្រនិច ណគ លែក អិះ ដើ ឞយ ហង់អ៊ែ លំរន់ឋាប់ ឝ្លាំង។ ");
INSERT INTO brb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ហាក់ ប៉ាគ់ ឞយ ហង់អ៊ែ លំប៊ិច ចនិះ តៃ ចាគ់ លំឃឹត រៀន “កន់ដ្រាគ់ អៃ ឡើ ឌុញ ឞាល់ នែ” ");
INSERT INTO brb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","អ៊ែ ឡើ បឹត ឞយ គែង អ៊ែ ដើម ឡើ ញញែត ចចង់ អរែង ប៊ឹង មែ ម៉ើ ឍុ តវែ ");
INSERT INTO brb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","តគ់ កន់ដ្រាគ់ ណគ ឡើ ជឹ ឡើ ត្រ ទឹង តង៉ៃ ឞយ ណគ តៃ ឡើ ចាំ ញ៉ាម តៃ ឡើ ណោះ ម៉ូង កន់ដ្រាគ់ ណគ ឡើ ប៊ឹះ ");
INSERT INTO brb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","អ៊ែ កន់ដ្រាគ់ លំពថូត ណគ ទុត កយឹក ដើម លំជុ ណគ អរែង ប៊ឹង បូវ ម៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង ទឹង ឞន បនឹះ ម៉ើ ញឺម ស៊្រែក កាប់ ក្រៀម ឝលៀម ពឹង»។ ");
INSERT INTO brb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«ទឹង អ៊ែ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ លំព្រឌីវ ប៉ាគ់ នែ៖ ប៊ិច កទ្រី ប្រោះ ជិត រ៉ា ម៉ើ តៀត តកៀង ដក់ ឡាប់ ឡង បឹ ឡើ ច្រណង់។ ");
INSERT INTO brb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","មែ ជិត រ៉ា អ៊ែ សើង រ៉ា ម៉ើ ហ្រឡិច ហ្រឡាង ណគ់ មែ សើង រ៉ា អន់ណាវ ម៉ើ ប៊ិច អ៊ឺម ខនឹត។ ");
INSERT INTO brb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ណគ់ មែ កទ្រី តៃ ម៉ើ ប៊ិច ខនឹត អ៊ែ ម៉ើ តៀត តកៀង មែ ហាក់ ណាំម៉ាន់ ម៉ើ តៀត ផឿ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","អ៊ែ ណគ់ មែ កទ្រី ហ្រឡិច ហ្រឡាង អន់ណាវ ម៉ើ តៀត តកៀង ដឹប ម៉ើ តៀត ផឿ ណាំម៉ាន់ ទឹង កង់គែវ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ញ៉ន បឹ ឡើ ច្រណង់ អ៊ែ ឡើ ញ៉ាក ប៊ឹះ មែ កទ្រី លែក ជិត រ៉ា អ៊ែ ម៉ើ ញឺម ម៉ាត់ អ៊ែ ម៉ើ ហង់ង៉ាន់ តៀក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","តគ់ ទឹង មាំង ម៉ើ ដុង ម៉ើ កឡូវ រៀន “បឹ ឡើ ច្រណង់ ឡើ ប៊ឹះ ឡើយ មិញ វន់ដក់ ឡាប់ ឡង ណគ!” ");
INSERT INTO brb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","លែក ដើ មែ ម៉ើ រ៉ៃ ឌឹក ឝ្រៀះ ប្រាយ តកៀង មែ។ ");
INSERT INTO brb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","អ៊ែ មែ កទ្រី តៃ ប៊ិច ខនឹត ម៉ើ ឡា ណាំម៉ាន់ ហឹ មែ កទ្រី ហ្រឡិច ហ្រឡាង រៀន “ឡា វន់ប៉ាក ណាំម៉ាន់ ដើ ញ៉ា ដិ អុះ តកៀង ញ៉ា នែ លំប៉ាត់ ឡើយ សំអ៊ិន”។ ");
INSERT INTO brb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","មែ កទ្រី ហ្រឡិច ហ្រឡាង អ៊ែ ម៉ើ ត្រណើវ រៀន “ដូវ អ៊ឺម ញំអាំ ដើ វែ! ប៉ាគ់ ញំអាំ លំឆិ អ៊ឺម ដើ វែ ដើម ដើ ញ៉ា ដិ។ ណាគ់ ហយ វន់ដក់ រួត ហឹ មែ ម៉ើ ហំពួត កឋោះ!”»។ ");
INSERT INTO brb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«ហំប៊្រុះ មែ កទ្រី អ៊ែ ម៉ើ ដក់ ដាំង រួត ណាំម៉ាន់ តៃ នែ បឹ ឡើ ច្រណង់ ឡើ ប៊ឹះ ប្រយ អ៊ែ ណគ់ មែ ប្រោះ ម៉ើ ត្រៀម ចាក់ លែវ ឡើយ ម៉ើ មឹត ទឹង រ៉ូង ច្រណង់ អរែង ដើ ណគ ប៊្លី អ៊ែ ម៉ើ ពាំង កម៉ង។ ");
INSERT INTO brb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","តគ់ ប៊្លី អ៊ែ មែ កទ្រី តៃ ប៊ិច ខនឹត ម៉ើ ប៊ឹះ ប៉ាគ់ទឺ ម៉ើ កឡូវ រៀន “អើយ យ៉ាគ់ កន់ដ្រាគ់ យ៉ាគ់ កន់ដ្រាគ់ អើយ ហំប៉ើក កម៉ង ដើ ញ៉ា អុះ!” ");
INSERT INTO brb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ណគ ឡើ ត្រណើវ រៀន “អៃ អំហាយ ម៉ាត់ ម៉ាត ដើ វែ រៀន អហង់ឝ៉ាវ អ៊ឺម អៃ វែ អ៊ិន!”»។ ");
INSERT INTO brb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «ប៉ាគ់ ពអ៊ែ វន់ចាំ ធៀវ យ៉ឹ យ៉ាក់ តៃ វ៉ើ ណោះ អ៊ឺម រៀន កួន បនឹះ លំប៊ឹះ ណោះ តង៉ៃ ង៉ាយ ម៉ូង ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«កាន គ្រែដៃ ឡើ ពែក ប៉ាគ់ នែ ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ហឹ ស្រុក ចង៉ាយ។ អន់នួរ ឡើ វីះ ឡើ កឡូវ ឞយ មន់ដក់ ហឹ ណគ អ៊ែ ឡើ អាំ ប្រនិច ណគ ដើ មែ មន់រន់ឋាប់ ឝ្លាំង។ ");
INSERT INTO brb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ឡើ អាំ លៀន ដើ មែ តាម អ្រណោះ មែ កឡឹ ដើ បឹ មូយ រ៉ា ឡើ អាំ សើង តឡង់  ដើ បឹ លមូយ អន់ណាវ បារ តឡង់ ដើ បឹ លមូយ ឡឹះ អន់ណាវ មូយ តឡង់ ប៊្លី អ៊ែ ឡើ វីះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ឞយ ឡើ ចក់ លៀន សើង តឡង់ ឡើ ដក់ ដាំង ពស៊ឺក ប្រយ អ៊ែ ឡើ ដូវ សើង តឡង់ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ប៉ាគ់ទឺ ឡើយ បឹ ឡើ ចក់ លៀន បារ តឡង់ ឡើ ដក់ ដាំង ពស៊ឺក អ៊ែ ឡើ ដូវ បារ តឡង់ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","អ៊ែ ណគ់ ដើ បឹ ឡើ ចក់ មូយ តឡង់ នែ ឡើ ដក់ ចះ កប់ លៀន កន់ដ្រាគ់ ណគ ឡើ អាំ»។ ");
INSERT INTO brb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ទុត ឌុញ តើម ប៊ឹង អ៊ែ កន់ដ្រាគ់ មែ ឡើ ជឹ វឹញ អ៊ែ ឡើ ឡា ឝ្លាំង អំម៉ើន លៀន ណគ អរែង ដើ មែ ឞយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","បឹ ឡើ ចក់ លៀន សើង តឡង់ នែ ឡើ ដក់ ហឹ កន់ដ្រាគ់ ណគ ដើម ឡើ តៀត លៀន កំឡៃ សើង តឡង់ ឡើ ហាយ រៀន “យ៉ាគ់ កន់ដ្រាគ់ ហអាំ លៀន សើង តឡង់ ដើ អៃ ហន់ឝ្លាំង អដាំង ពស៊ឺក អដូវ សើង តឡង់ អន់ណាវ។ នែ លៀន ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","យ៉ាគ់ កន់ដ្រាគ់ ឡើ ម៉ាង ដើ ណគ រៀន “ចាគ់ ឡើយ! ហបើម ឞយ អៃ ហចនិះ ចាគ់ ដើម ហទឹង ត្រ ដិ ទុត កាន កិៗ ណាគ់ ហទឹង ត្រ។ ណិះៗ នែ អង់អាំ ដើ ហៃ ហំរន់ឋាប់ ឝ្លាំង ទឹង កាន ទិះៗ អន់ណាវ។ ហន់ដក់ រ៉គ់សំ ប៊ឹង អៃ នែ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","បឹ ឡើ ចក់ លៀន បារ តឡង់ ឡើ ប៊ឹះ ប៉ាគ់ទឺ អ៊ែ ឡើ ហាយ រៀន៖ “យ៉ាគ់ កន់ដ្រាគ់ ហអាំ លៀន បារ តឡង់ ដើ អៃ ហន់ឝ្លាំង អដាំង ពស៊ឺក អដូវ បារ តឡង់ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","យ៉ាគ់ កន់ដ្រាគ់ ឡើ ម៉ាង ហឹ ណគ ឡើ រៀន “ចាគ់ ឡើយ! ហបើម ឞយ អៃ ហចនិះ ចាគ់ ដើម ហទឹង ត្រ ដិ ទុត កាន កិៗ ណាគ់ ហទឹង ត្រ។ ណិះៗ នែ អង់អាំ ដើ ហៃ ហំរន់ឋាប់ ឝ្លាំង ទឹង កាន ទិះៗ អន់ណាវ។ ហន់ដក់ រ៉គ់សំ ប៊ឹង អៃ នែ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ប៊្លី អ៊ែ បឹ ឡើ ចក់ លៀន មូយ តឡង់ ឡើ ប៊ឹះ ប៉ាគ់ទឺ ឡើ ហាយ រៀន “យ៉ាគ់ កន់ដ្រាគ់ អណោះ ហបនឹះ ពង៉ាត់ ម៉ៃ ហ៊ែត។ ហម មឺរ ញឹះ តៃ ហចួយ ណាគ់ ហសួត ដើម ណា ញឹះ តៃ ហប្រាក់ ណាគ់ ហកៀវ ចក់ ចិះ។ ");
INSERT INTO brb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ញ៉ន ពអ៊ែ ឡើយ ណគ់ លៀន ហៃ ហអាំ ដើ អៃ អ៊ែ អកុប ទិ ប្រិះ យ៉ាក់ អឌូង ម៉ៃៗ។ ហឹ លៀន ហៃ នែ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","យ៉ាគ់ កន់ដ្រាគ់ ឡើ ត្រណើវ រៀន “ឞយ តៃ ចាគ់ កយ៉ូវ អើយ ហណោះ ឡើយ អៃ ហម មឺរ ញឹះ តៃ អចួយ ណាគ់ អសួត ដើម ណា ញឹះ តៃ អប្រាក់ ណាគ់ អកៀវ ចក់ ចិះ។ ");
INSERT INTO brb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ប៉ាគ់ ពអ៊ែ បាយ ហឌី អ៊ឺម ហង់អាំ លៀន អៃ ដើ មែ មន់តង់ ដឹះ អ៊ែ តគ់ អជឹ នែ អន់ដូវ លៀន តើម ដើម លៀន កំឡៃ។ ");
INSERT INTO brb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","មិញ វន់ចក់ លៀន តើម ប៊ឹង ណគ អ៊ែ វន់អាំ ដើ បឹ ឡើ ប៊ិច ជិត តឡង់ អ៊ែ អន់ណាវ ");
INSERT INTO brb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","យ៉ាក់ ត្រំ មែ ម៉ើ ប៊ិច ឡើយ អៃ អន់អាំ ពឺង អ៊ែ អន់ណាវ អ៊ែ មន់ប៊ិច ស៊ិវ សាគ់ ណាគ់ គ្លឺយ។ អ៊ែ ណគ់ ដើ មែ តៃ ម៉ើ ប៊ិច អៃ អន់ចក់ ពលែក ណគ់ អង់ង៉ាយៗ មែ ម៉ើ ប៊ិច។ ");
INSERT INTO brb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","អ៊ែ ណគ់ ដើ បឹ ឞយ តៃ ខា នែ វន់រ៉ាប់ ហពៀវ ហឹ ដៀក ទឹង ហ្រង៉ូមៗ ហឹ ឞន បនឹះ ម៉ើ ញឺម ស៊្រែក កាប់ ក្រៀម ឝលៀម ពឹង”»។ ");
INSERT INTO brb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«តគ់ កួន បនឹះ លំប៊ឹះ អរែង លែក ដើ ឞាវ គ្រែដៃ តូវ លំឝ៉ាល ធឺង លំដ្រូម ប៊ឹង ទិងមៀង ណគ ទុត អូងអាត យ៉ូក យ៉ាល់។ ");
INSERT INTO brb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","អ៊ែ បនឹះ ត្រំ សាត មន់តមួត ប៊ឹង ងឺរ ណគ ប៊ឹង អ៊ែ លំកះ មែ ដិ អន់ដិ លំបើម ប៉ាគ់ កឡា ពែក បណាន់ ឡើ កះ ចៀម តើម ប៊ឹង បប៊ែ ");
INSERT INTO brb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","លំជុ ចៀម តៃ ចម៉ា ណគ ណគ់ បប៊ែ តៃ ចអៀវ។ ");
INSERT INTO brb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ប៊ឹង អ៊ែ សឋិច លំហាយ ដើ មែ ម៉ើ គូ តៃ ចម៉ា ណគ រៀន “អ៊ែ ដើ វែ ណគ់ បើគ អៃ ឡើ អាំ កាន ចាគ់ អើយ វន់ចក់ មូន មាំង ឡើ ត្រ កាន ពែក ប៉ាក់ ណគ់ គ្រែដៃ បើគ ឡើ រន់ឋាប់ ជុ ដើ វែ ណាគ់ តើម ប៊ឹង កណើត ពដិះ គ្រែ ");
INSERT INTO brb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","យ៉ាក់ ទឹង អពងួត វ៉ើ អាំ ចណង់ ចណា ដើ អៃ ប៊ឹង អហរៀង ដាក វ៉ើ អាំ ដាក ញែត ដើ អៃ ប៊ឹង វ៉ើ តៃ អដក់ តមួយ ហឹ វែ ណាគ់ វ៉ើ ឡាប់ អាំ កនី កនូ ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ប៊ឹង តៃ អប៊ិច ប្រវ៉ើន ហណក វ៉ើ អាំ ប្រវ៉ើន ហណក ដើ អៃ ប៊ឹង អឈិ វ៉ើ ដក់ ឝ្លាំង អៃ ទឹង អគូ ឃុក ណាគ់ វ៉ើ ដក់ តង៉ា ឡា អៃ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ទឹង អ៊ែ ណគ់ មែ ម៉ើ ចាគ់ ទឹង ត្រ មន់ត្រណើវ ម៉ាង ណគ រៀន “យ៉ាគ់ កន់ដ្រាគ់ ដមិញ ហង់អ៊ិន ញ៉ើ តៃ ហពងួត អ៊ែ ញ៉ើ អាំ ចណង់ ចណា ដើ ហៃ លឺ ញ៉ើ តៃ ហើ ហរៀង ដាក អ៊ែ ញ៉ើ អាំ ដាក ដើ ហៃ? ");
INSERT INTO brb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ដមិញ ហង់អ៊ិន ញ៉ើ តៃ ហៃ ហដក់ តមួយ អ៊ែ ញ៉ើ ឡាប់ អាំ កនី កនូ លឺ ញ៉ើ តៃ ហប៊ិច អ៊ឺម ប្រវ៉ើន ហណក អ៊ែ ញ៉ើ អាំ ដើ ហៃ? ");
INSERT INTO brb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ដមិញ ដឹះ ញ៉ើ តៃ ហៃ ហឈិ លឺ ហគូ ឃុក អ៊ែ ញ៉ើ ដក់ ឝ្លាំង តង៉ា ឡា ហៃ”? ");
INSERT INTO brb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","សឋិច លំត្រណើវ ម៉ាង មែ រៀន “ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ត្រំ វ៉ើ បើម កាន លែក អ៊ែ ដើ មែ កិ ហឡាប ដាប ហឡង់ ទឹង អំម៉ោះ អោះ អៃ នែ ឞាល់ វ៉ើ បើម ដើ អៃ ឡើយ”»។ ");
INSERT INTO brb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«ប៊្លី អ៊ែ លំម៉ាង ដើ មែ ម៉ើ គូ តៃ ចអៀវ រៀន “ណគ់ វែ វ៉ើ ត្រ ពន់ដ្រាយ អើយ មិញ វន់វីះ តើម ប៊ឹង អៃ វន់ដក់ មឹត ហឹ អ៊ុញ ឡើ កាត ញឹះ តៃ ណោះ ប៉ាត់ អ៊ុញ គ្រែដៃ ឡើ រន់ឋាប់ ជុ ដើ អរ៉ាក់ សតាំង ដើម ឞយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","យ៉ាក់ ប៊ឹង អពងួត វ៉ើ អាំ អ៊ឺម ចណង់ ចណា ដើ អៃ ប៊ឹង អហរៀង ដាក វ៉ើ អាំ អ៊ឺម ដាក ញែត ដើ អៃ ");
INSERT INTO brb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ប៊ឹង អដក់ តមួយ ហឹ វែ វ៉ើ ឡាប់ អ៊ឺម អាំ កនី កនូ ដើ អៃ ប៊ឹង អប៊ិច អ៊ឺម ប្រវ៉ើន ហណក វ៉ើ អាំ អ៊ឺម ប្រវ៉ើន ហណក ដើ អៃ ប៊ឹង អឈិ ដើម អគូ ឃុក ញឹះ តៃ វ៉ើ ដក់ តង៉ា ឡា អៃ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","មែ អ៊ែ មន់ត្រណើវ ប៉ាគ់ទឺ ណគ រៀន “យ៉ាគ់ កន់ដ្រាគ់ ដមិញ ហង់អ៊ិន ញ៉ើ តៃ ហពងួត ញ៉ើ តៃ ហហរៀង ដាក ញ៉ើ តៃ ហដក់ តមួយ ញ៉ើ តៃ ហប៊ិច អ៊ឺម ប្រវ៉ើន ហណក ញ៉ើ តៃ ហឈិ លឺ ហគូ ឃុក អ៊ែ ញឹះ តៃ ញ៉ើ ហវីវ ឝ្លាំង ហឹ ហៃ?” ");
INSERT INTO brb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","អ៊ែ លំម៉ាង ដើ មែ រៀន “ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ត្រំ តៃ វ៉ើ បើម កាន លែក អ៊ែ ដើ បនឹះ កិ ហឡាប ដាប ហឡង់ ឞាល់ តៃ វ៉ើ បើម ដើ អៃ ទឺ”។ ");
INSERT INTO brb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","មែ អ៊ែ មន់ត្រ វីះ ដក់ ហឹ ឞន ធុក ញ៉ាក ប៉ាក ម៉ង ឡូច អន់សច អ៊ែ ណគ់ ដើ មែ ម៉ើ ចាគ់ ទឹង ត្រ មន់ដូវ ញិវ ឡូច អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","តគ់ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង កាន លែក នែ លែវ ឡើយ អ៊ែ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«វែ វ៉ើ ណោះ ឡើយ ណាគ់ បារ តង៉ៃ លំប៊ឹះ ឞ៊ុន ពជឺរ តង៉ៃ អ៊ែ ឡើយ មន់រ៉ាប់ កួន បនឹះ ដក់ ឈូន ហឹ ទី មែ ដ្រម៉ា អាំ មន់ពឡាះ ប៉ាង»។ ");
INSERT INTO brb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ប៊ឹង អ៊ែ បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ដក់ ពទុំ ទឹង ហន់ណាម យ៉ាគ់ កៃផាះ ឡើ ណាយ បប៊ុះ ថួយ។ ");
INSERT INTO brb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ម៉ើ ចជែ ដាំង ទ្រូង រ៉ាប់ គ្រែដៃ យែស៊ូ វៀកៗ បក់ មន់កជែត។ ");
INSERT INTO brb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ហាក់ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ញ៉ង ងន់រ៉ាប់ អ៊ឺម ទឹង ឞ៊ុន ពជឺរ នែ កឡាគ់ លំកើត កាន អ្រញ៉ុក អ្រញ៉ាក ទឹង មែ ប៉ាសាសុន»។ ");
INSERT INTO brb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","គ្រែដៃ យែស៊ូ ឡើ គូ ហឹ ស្រ៊ុក ប៊ែថានី ទឹង ហន់ណាម យ៉ាគ់ ស៊ីម៉ូន យ៉ាគ់ ស៊ីម៉ូន នែ ពន់ឋើម ឡើ ស៊ីតស៊ូត។ ");
INSERT INTO brb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","អ៊ែ ប៊ិច កទ្រី មូយ រ៉ា ឡើ ដក់ តគ់ គ្រែដៃ យែស៊ូ ដើម ឡើ ឝ៉ឹន កង់គែវ តម៉ ទុត ចាគ់។ ទឹង កង់គែវ អ៊ែ ឡើ ប៊ិច ណាំហម គ្លឹម ទុត ច្រណាប់។ ទឹង ប៉ះ គ្រែដៃ យែស៊ូ ឡើ ចង់ ចា អ៊ែ ណាង ឡើ ហ៊ែង ណាំហម ពឺង ទូះ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","បូវ លុកស៊ិក ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ មាំ ប្រយ អ៊ែ ម៉ើ ម៉ាង រៀន៖ «ពយ៉ិ ឡើ ត្រ ឡើ ហ៊ែង ពឃូច ដើ ណាំហម ប៉ាគ់ នែ! ");
INSERT INTO brb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ប៉ាគ់ ងំហំពួត ងំដូវ លៀន ទុត អើន ងន់អាំ ដើ មែ ម៉ូវ ម៉ក ពឡៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","គ្រែដៃ យែស៊ូ ឡើ ណោះ ចនិះ មែ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «ញ៉ង វ៉ើ ម៉ាង អ៊ឺម ដើ ណាង! ណគ ឡើ បើម កាន នែ ដើ អៃ ទុត ចាគ់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ណគ់ មែ ម៉ូវម៉ក ម៉ើ គូ ប៊ឹង វែ អន់សច អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អង់គូ យ៉ាវ ប៊ឹង វែ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ណាង ឡើ ហ៊ែង ពឡំ ណាំហម ទឹង ចាក់ អៃ ប៉ាគ់ នែ ឡើ រន់ឋាប់ អន់នួរ មន់ដក់ ជុ ហឹ ត្រម ច្រាង ជុ កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ត្រំ អំប៊ុ បុ ឡាង ប្រិះ នែ ប៊ឹង មន់ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ មន់ពហាយ ប៉ាគ់ទឺ កាន ណាង ឡើ បើម នែ អ៊ែ មន់ចនិះ ហឹ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ទឹង លុកស៊ិក ជិត បារ រ៉ា អ៊ែ ប៊ិច មូយ រ៉ា ម៉ាត់ ណគ យូដះ អ៊ីសការីយ៉ុត ឡើ ដក់ ហឹ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ");
INSERT INTO brb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ឡើ ចជែ ហឹ មែ រៀន៖ «ប៉ាគ់ អន់ម៉ប យ៉ាគ់ យែស៊ូ ហឹ ទី វែ អង់ង៉ាយ វន់អាំ ដើ អៃ?» បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ម៉ើ កាវ ប្រយ លៀន ពែ ជិត កាក់ ប៉្រាក់ ម៉ើ អាំ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","តើម ប៊ឹង អ៊ែ យូដះ ឡើ ចាំ លំវឺង បនឹះ បក់ លំដូវ ម៉ប គ្រែដៃ យែស៊ូ ហឹ ទី មែ។ ");
INSERT INTO brb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","តគ់ តង៉ៃ ទី មូយ ទឹង ឞ៊ុន ណុំពាំង តៃ ប៊ិច ប៊ូះ មែ លុកស៊ិក ម៉ើ ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ប៊ឹង ង៉ាយ ហប៉្រៃ ញន់ទែង កយ៉ិ កយី ដើ ហៃ ហំចង់ ចា ឞ៊ុន ពជឺរ?»។ ");
INSERT INTO brb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ រៀន៖ «មិញ វន់ដក់ ហឹ មួង តគ់ ហឹ ហន់ណាម បឹ ហង់អ៊ែ អ៊ែ វន់ហាយ ដើ ណគ រៀន “យ៉ាគ់ ណាយឃូ ប៉ាគ់ នែ ឡើ ហាយ ដើ ហៃ ‘តង៉ៃ គ្រែដៃ ឡើ ខណាត ជុ ដើ អៃ ដៀប ប៊ឹះ ឡើយ អៃ អំចង់ ចា អរែង ឞ៊ុន ពជឺរ ប៊ឹង មែ លុកស៊ិក អៃ ទឹង ហន់ណាម ហៃ’”»។ ");
INSERT INTO brb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","មែ លុកស៊ិក ម៉ើ ដក់ បើម តាម គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ អ៊ែ ម៉ើ ទែង កយ៉ិ កយី បើម ឞ៊ុន ពជឺរ។ ");
INSERT INTO brb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","តគ់ ឡើ អំប៊ឹ គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ប៊ឹង តូក អរែង ដើ លុកស៊ិក ណគ ជិត បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ទឹង ម៉ើ ចង់ ចា អ៊ែ ឡើ ហាយ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ទឹង បូវ វែ ប៊ិច មូយ រ៉ា លំម៉ប អៃ ហឹ ទី មែ មន់រ៉ាប់»។ ");
INSERT INTO brb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","អ៊ែ បូវ លុកស៊ិក ម៉ើ ដុង ស្រៀវ ប្រយ ម៉ើ តង៉ា ណគ មូយ រ៉ា មូយ តង រៀន៖ «អៃ ឡះ យ៉ាគ់ កន់ដ្រាគ់?»។ ");
INSERT INTO brb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ឡើ ត្រណើវ រៀន៖ «ណគ់ បឹ ឡើ ទុ ណុំពាំង ទឹង តង់ឝ៉ាន អរែង ប៊ឹង អៃ ណគ អ៊ែ ឡើយ លំម៉ប អៃ ហឹ ទី មែ។ ");
INSERT INTO brb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","កួន បនឹះ លំត្រ គែត ប៉ាគ់ ម៉ើ ខៀន ជុ កាន ណគ ទឹង ពឹម គ្រែដៃ ឡើយ។ ហាក់ បឹ កឡា ម៉ប កួន បនឹះ លំត្រ ធុក ញ៉ាក ទុត ខាក់។ ណគ់ បឹ ហង់អ៊ែ ណាគ់ ហយ តៃ លំកើត អ៊ែ លំចាគ់ ជឺរ!»។ ");
INSERT INTO brb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","យ៉ាគ់ យូដាះ ឡើ កឡា ម៉ប គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ ណាយឃូ អៃ ឡះ?» គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «ត្រ ឡើយ ហម៉ាង អ៊ិន!»។ ");
INSERT INTO brb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ទឹង ម៉ើ ចង់ ចា គ្រែដៃ យែស៊ូ ឡើ ចក់ ណុំពាំង ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ កដោះ ប៉ាក អាំ ដើ មែ លុកស៊ិក ណគ ឡើ ហាយ រៀន៖ «វន់ចា យ៉ឹ អន់នែ ឡើយ ចាក់ ដៃ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ប៊្លី អ៊ែ ឡើ ចក់ ចក តវែ ឈឹង ជែម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ឡើ អាំ ដើ មែ លុកស៊ិក ណគ ដើម ឡើ ហាយ ឡឹះ រៀន៖ «វន់ញែត ត្រំ វែ យ៉ឹ។ ");
INSERT INTO brb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","អន់នែ ឡើយ ផាម អៃ លំលូះ ដើ បនឹះ ទុត អើន បក់ គ្រែដៃ លំតាក់ ថូត ដើ មែ។ ផាម នែ ឡើ ពដៃ កាន ខណាត ខណាំ ប្លះ គ្រែដៃ ប្លះ វែ។ ");
INSERT INTO brb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","អៃ អន់ហាយ ដើ វែ តើម ប៊ឹង នែ អន់ញែត យ៉ាវ តវែ ឈឹង ជែម ញឹះ លំប៊ឹះ តង៉ៃ អំញែត ឡឹះ តវែ ឈឹង ជែម ហន់ដើម អរែង ដើ វែ ទឹង ឞន គ្រែដៃ បើគ អៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ប៊្លី ម៉ើ ច្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ មូយ យ៉ោះ អ៊ែ ម៉ើ ឌឹក ទឹង ចន់ឌូ តើម អូលីវ។ ");
INSERT INTO brb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «មាំង នែ លែក ដើ វែ វន់អ្រយ៉ាវ តាក់ អៃ ញ៉ន កាន លំកើត ដើ អៃ យ៉ាក់ ម៉ើ ខៀន ជុ រៀន “អៃ អំបឹត កជែត កឡា ពែក ចៀម អ៊ែ បូវ ចៀម មន់ផាគ់ ផាយ ”។ ");
INSERT INTO brb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ហាក់ តគ់ អន់ញិវ ឡឹះ អន់ណាវ អន់ដក់ ហឹ ស្រុក ឝ៉ាលីលែ អន់នួរ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «សំយ៉ះ មែ លែក រ៉ា មន់អ្រយ៉ាវ តាក់ ហៃ កតាម ញ៉ន កាន លំកើត ដើ ហៃ ដើ អៃ ណាគ់ តៃ អន់អ្រយ៉ាវ តាក់ ហៃ!»។ ");
INSERT INTO brb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ ហៃ មាំង នែ អន់នួរ អៀរ លំប្រូវ ហំប៉ាវ ពែ តង ហំរៀន ហហង់ឝ៉ាវ អ៊ឺម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «សំយ៉ះ អន់ត្រ គែត អរែង ប៊ឹង ហៃ កតាម ប៊ិច អ៊ឺម អំរៀន ញឹះ តៃ អំហង់ឝ៉ាវ ហៃ»។ លែក ដើ មែ លុកស៊ិក ម៉ើ ម៉ាង ប៉ាគ់ ដើ ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ប៊ឹះ តគ់ ឞន មូយ ម៉ើ ជុ ឝែតស៊ែម៉ានី។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «វន់ដ្រូម ប៊ឹង ណិះ អន់ដៃ វន់ចាំ អៃ អន់ដក់ អ៊ឺរ ដាំង គ្រែដៃ ហឹ តគ់»។ ");
INSERT INTO brb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","គ្រែដៃ យែស៊ូ ឡើ ច្រា យ៉ាគ់ ពែត្រុះ ដើម កួន យ៉ាគ់ ស៊ែប៊ែឌែ លែក បារ ម៉ើ ដក់ តូយ ណគ។ ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដុង ស្រៀវ អ្យិរៗ ដើម ឡើ ឝ្រង៉ឹត ទុត ខាក់ ");
INSERT INTO brb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ណគ ឡើ ហាយ ដើ មែ ពែ រ៉ា រៀន៖ «អៃ អ៊ិន តូវ ស្រៀវ អ្យិរៗ ឞាល់ អ៊ិន ស្រឹ អង់គែត ឡា វន់គូ ប៊ឹង ណិះ ឡើយ វន់ថៀវ អរែង ប៊ឹង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","គ្រែដៃ យែស៊ូ ឡើ ចវីះ ឞិត ឞ៊ែត អ៊ែ ឡើ ជឹះ ត្រកូវ ត្រងឺវ ទូត ប្រិះ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ឡា ឡូម រៀន៖ «ឡា គ្រែដៃ បើគ អើយ ប៉ាគ់ ហន់អាំ អឡា ហន់ញ៉ាក់ ប៊ែង ធុក ញ៉ាក នែ តើម ប៊ឹង អៃ ហាក់ ម៉ាត់ ញ៉ង ហំពន់ឋូយ តាម ប្រម៉ើត អៃ ហំបើម តាម ប្រម៉ើត ហៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","គ្រែដៃ យែស៊ូ ឡើ វឹញ ហឹ មែ ពែ រ៉ា ឡើ តៃ ម៉ើ ហង់ង៉ាន់ តៀក អ៊ែ ឡើ ម៉ាង ដើ យ៉ាគ់ ពែត្រុះ រៀន៖ «វន់ង៉ាះ ថៀវ វ៉ិះ ឌិវ មូយ ម៉ូង អរែង ដើ អៃ ដូវ អ៊ឺម ឡះ? ");
INSERT INTO brb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","មិញ វន់ង៉ាះ ថៀវ អ៊ឺរ ដាំង គ្រែដៃ ញ៉ង អាំ វន់ដូវ ដើ កាន ពលូង ចនិះ វែ ងុញ លហម បើម ត្រួយ ហាក់ ចាក់ ដៃ វែ ឡើ សូវ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","គ្រែដៃ យែស៊ូ ឡើ ចវីះ ឡឹះ តើម ប៊ឹង មែ ឡើ អ៊ឺរ ដាំង ឡា ទឹង បើគ ណគ រៀន៖ «ឡា គ្រែដៃ បើគ អើយ ប៉ាគ់ អៃ អន់ត្រ ញែត ប៊ែង ធុក ញ៉ាក នែ ប៉ាគ់ តៃ ប៊ិច ទ្រូង គែង ហំបើម ប៉ាគ់ ប្រម៉ើត ហៃ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","គ្រែដៃ យែស៊ូ ឡើ ជឹ វឹញ ឡឹះ ហឹ មែ ឡើ តៃ ម៉ើ ហង់ង៉ាន់ ដឌែ យ៉ាក់ ម៉ើ ញឺម ម៉ាត់ ម៉ៃ ហ៊ែត។ ");
INSERT INTO brb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ឡើ វីះ ឡឹះ តើម ប៊ឹង មែ ឡើ ដក់ អ៊ឺរ ដាំង គ្រែដៃ ញឹះ ពែ តង ដើ ណិះ ឡើយ ឡើ ឡា ឡូម ប៉ាគ់ អន់ឌូ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ប៊្លី អ៊ែ ឡើ ជឹ វឹញ ឡឹះ ហឹ មែ លុកស៊ិក ណគ ឡើ ម៉ាង ដើ មែ រៀន៖ «វែ នែ តាំង វ៉ើ ហង់ង៉ាន់ៗ ដមិញ វន់សាម? ណិះៗ ដៀប លំប៊ឹះ ម៉ូង មែ មន់ឈូន កួន បនឹះ ហឹ ទី មែ ប៊ិច ឞាប។ ");
INSERT INTO brb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","វន់ឌឹក ហំមិញ ញ៉ាគ់ ដក់ តគ់ វន់ឝ្លាំង បឹ ឡើ ឈូន ទ្រូង ដក់ រ៉ាប់ អៃ ប៉ះ ឡើ ដក់ ដៀប ប៊ឹះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","គ្រែដៃ យែស៊ូ ទឹង ប៉ះ ឡើ ចជែ យូដះ ឡើ លុកស៊ិក ទឹង បូវ មែ ជិត បារ រ៉ា ទឺ ឡើ ប៊ឹះ ប្រយ ដើម បនឹះ មូយ បូវ ទុត អើន ម៉ើ តូយ ណគ ម៉ើ ឝ៉ឹន តាវ ដើម ឡង ក្រដូង។ បូវ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ប៉្រៃ មែ ដក់ រ៉ាប់។ ");
INSERT INTO brb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","បឹ ឡើ តៀត មែ ដក់ រ៉ាប់ គ្រែដៃ យែស៊ូ ឡើ ថាន់ អន់នួរ មែ រៀន៖ «អំមុក បឹ អង់ង៉ាយ បឹ ហង់អ៊ែ ឡើយ វន់រ៉ាប់»។ ");
INSERT INTO brb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ហំប៊្រុះ ឡើ ប៊ឹះ តគ់ អ៊ែ ឡើ ដក់ ប្រយ ហឹ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ណាយឃូ ណាគ់ ហរ៉គ់សំ?» ប៊្លី អ៊ែ ឡើ មុក។ ");
INSERT INTO brb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ ណគ រៀន៖ «ប្រអៃ អើយ អង់ង៉ាយ ហងុញ បើម ហំបើម ដឹះ!»។ អ៊ែ ណគ់ មែ ម៉ើ តូយ ណគ ម៉ើ ដក់ រ៉ាប់ ប្រយ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ហំប៊្រុះ ដើ អ៊ែ ប៊ិច មូយ រ៉ា ទឹង បូវ គ្រែដៃ យែស៊ូ ឡើ ហួត តាវ ឡើ កោះ ឞយ យ៉ាគ់ ណាយ បប៊ុះ ថួយ តាត់ ត្រពិត មូយ ច្រះ។ ");
INSERT INTO brb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","គ្រែដៃ យែស៊ូ ឡើ គឹះ បឹ ហង់អ៊ែ រៀន៖ «មិញ ហន់ស៊ុរ តាវ ហៃ ទឹង ស្រូម ទឺ យ៉ាក់ ត្រំ មែ ង៉ាយ ម៉ើ បើម ដើ ប៉្លា តាវ មែ អ៊ែ មន់គែត ដើ ប៉្លា តាវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ហណោះ អ៊ឺម ឡះ ប៉ាគ់ អំកឡូវ អ៊ឺរ ឡា ទឹង បើគ អៃ លំប៉្រៃ ឞាវ ណគ ជឺរ ជិត បារ បូវ កង តហាន មន់ទឺះ ប៉ូរ អៃ ហរៀន តៃ ដូវ ឡះ? ");
INSERT INTO brb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ហាក់ ប៉ាគ់ អំបើម ពអ៊ែ លំដាវ យ៉ាវ ប៉ាគ់ មែ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ។ កាន នែ លំត្រ កើត ប៉ាគ់ ណិះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ បូវ ម៉ើ ដក់ រ៉ាប់ ណគ រៀន៖ «ពយ៉ិ វ៉ើ តៃ អខម៉ូយ ឡះ អ៊ែ វ៉ើ ឝ៉ឹន តាវ ឝ៉ឹន ឡង ក្រដូង ដក់ រ៉ាប់ អៃ ប៉ាគ់ នែ? ត្រំ តង៉ៃ អដ្រូម ពង់ហៀន ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អតៃ អ៊ឺម វន់រ៉ាប់ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","កាន លែក នែ ឡើ កើត អាំ លំដាវ ប៉ាគ់ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ើ ខៀន ជុ ឡើយ ទឹង ពឹម។ ហំប្រ៊ុះ ដើ អ៊ែ លែក ដើ មែ លុកស៊ិក ណគ ម៉ើ អ្រយ៉ាវ ព្រដិច ចាក់ តាក់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ណគ់ មែ ម៉ើ រ៉ាប់ គ្រែដៃ យែស៊ូ ម៉ើ តៀត ណគ ហឹ ហន់ណាម យ៉ាគ់ កៃផាះ ឡើ ណាយ បប៊ុះ ថួយ។ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ពស៊ុំ អរែង ហឹ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","យ៉ាគ់ ពែត្រុះ ឡើ ឆ្រួយ គ្រែដៃ យែស៊ូ ង៉ាយ ចង៉ាយ ឆា ដើ ប៊ឹះ ហន់ណាម ណាយ បប៊ុះ ថួយ អ៊ែ ឡើ មឹត ដ្រូម តគ់ បយឺង ប៊ឹង មែ កឡា ញ៉ាម រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ ងុញ តៃ កាន អ៊ែ លំកើត ប៉ាគ់ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ តង់កង់ ក្រាគ់ តាត់ កឍី សុនសាត យូដា លែក រ៉ា ម៉ើ ដាំង កឡា តៃ ណគ់ មន់សឡាគ់ ប៉ច ពយូច គ្រែដៃ យែស៊ូ បក់ មន់ប៊ិច ខ កជែត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ហមយ៉ះ បនឹះ ទុត អើន កតាម ម៉ើ ដក់ ប៉ច ពយូច ណគ ណាគ់ តៃ ម៉ើ តៃ ដឌែ ខ ញឹះ ឆិ មន់កជែត ណគ។ តគ់ ប៊្លី អ៊ែ ប៊ិច កឡ បារ រ៉ា អំប្រា ដក់ ហឹ មែ ");
INSERT INTO brb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","អំប្រា ម៉ាង រៀន៖ «បឹ អន់នែ ឡើ រៀន លំដូវ សោះ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ប៊្លី អ៊ែ លំបើម ឡឹះ លញ៉ាគ់ ពែ តង៉ៃ លំចឹះ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ប៊ឹង អ៊ែ ណាយ បប៊ុះ ថួយ ឡើ ឌឹក ឆុង ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ពយ៉ិ តៃ ហត្រណើវ ប្រម៉ាង អំប្រា ចឹន ហៃ អ៊ិន ប៉ាគ់ ង៉ាយ ហឃឹត?»។ ");
INSERT INTO brb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","គ្រែដៃ យែស៊ូ ឡើ គូ ខៀង។ យ៉ាគ់ ណាយ បប៊ុះ ថួយ ឡើ ម៉ាង អន់ណាវ រៀន៖ «មិញ ហន់តប៉ឹន ចាក់ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ញិវ អន់សច ហន់ហាយ ឡាំង ដើ ញ៉ា ហៃ ឡើយ ឡះ ហគ្រែដៃ គ្រិះ កួន កឡ គ្រែដៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ត្រ ឡើយ ហម៉ាង ប៉ាគ់ អ៊ិន។ ហាក់ អៃ អំហាយ ដើ វែ រៀន តើម ប៊ឹង នែ វន់តៃ កួន បនឹះ លំដ្រូម តៃ ចម៉ា គ្រៃដៃ ឡើ ប៊ិច អាតណាត ឆង៉ាត់ តៃ ឋាំ ដើម លំប៊ឹះ ពឺង យូក »។ ");
INSERT INTO brb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","យ៉ាគ់ ណាយ បប៊ុះ ថួយ ហំប៊្រុះ ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ សាក ប្រយ អាវ ឌ្រឹម ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «បឹ អន់នែ ឡើ ផម៉ាត គ្រែដៃ ឡើយ! សណូវ យ៉ាវ ងន់ដាំង កឡា តៃ គែង នែ។ វ៉ើ ដុង ឡើយ បឹ អន់នែ ឡើ ផម៉ាត គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ប៉ាគ់ ង៉ាយ ដើ វែ វន់ឃឹត បើម ដើ ណគ?»។ អ៊ែ ម៉ើ ត្រណើវ រៀន៖ «ណគ នែ ត្រ ថូត ឆិ កជែត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ប៊្លី អ៊ែ មែ អន់នឺ ម៉ើ កយ៉ុះ ក្រហាក មុះ ម៉ាត់ ណគ ដើម ម៉ើ ជិវ ណគ មែ អន់នឺ ម៉ើ តាះ ណគ ដើម ម៉ើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«គ្រែដៃ គ្រិះ អើយ ប៉ាគ់ ហកឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ម៉ាត ហំហាយ ឡាំង មែ ង៉ាយ ហណោះ ម៉ើ ជិវ ហៃ?» ");
INSERT INTO brb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","អ៊ែ ណគ់ ដើ ពែត្រុះ ឡើ ដ្រូម ចុ បយឺង។ ប៊ិច ឞយ កទ្រី មូយ រ៉ា ឡើ ដក់ ហឹ ណគ ឡើ ម៉ាង រៀន៖ «ហៃ នែ ហបូវ យែស៊ូ ស្រុក ឝ៉ាលីលែ ទឺ ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ហាក់ ណគ ឡើ ប៉ាវ ប៊ឹង ងឺរ មែ លែក រ៉ា រៀន៖ «អណោះ អ៊ឺម អៃ ណោះ កាន អង់ង៉ាយ ហម៉ាង អ៊ិន!» ");
INSERT INTO brb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ហឹ ឝឡោះ ដ្រក តគ់ អ៊ែ ប៊ិច ឞយ កទ្រី មូយ រ៉ា អន់ណាវ ឡើ តៃ ណគ អ៊ែ ឡើ ហាយ ដើ មែ ម៉ើ គូ ទឹង អ៊ែ រៀន៖ «បឹ អន់នែ បូវ យែស៊ូ ស៊្រុក ណាសារែត ទឺ ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","យ៉ាគ់ ពែត្រុះ ឡើ ប៉ាវ ឡឹះ ដឹប ឡើ តប៉ឹន ចាក់ រៀន៖ «អហង់ឝ៉ាវ អ៊ឺម អៃ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ឞិត ឞ៊ែត ប៊្លី អ៊ែ មែ ម៉ើ គូ ទឹង អ៊ែ ម៉ើ ដក់ ហឹ យ៉ាគ់ ពែត្រុះ ម៉ើ ម៉ាង ដើ ណគ រៀន៖ «ហៃ នែ ហបូវ យែស៊ូ ម៉ាត់ ម៉ាត ឡើយ យ៉ាក់ ញ៉ើ ដុង ប្រម៉ាង ហៃ អ៊ិន ប៉ាគ់ ប្រម៉ាង មែ ស្រុក ឝ៉ាលីលែ ទឺ!»។ ");
INSERT INTO brb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ យ៉វ តប៉ឹន ចាក់ រៀន៖ «ញឹះ តៃ អហង់ឝ៉ាវ អ៊ឺម អៃ បឹ ហង់អ៊ិន!»។ ឡូច ប្រម៉ាង ណគ អៀរ ឡើ ប្រូវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ចនិះ ភៀក ហឹ ប្រម៉ាង គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «អន់នួរ អៀរ លំប្រូវ ហៃ ហំប៉ាវ ពែ តង ហន់រៀន ហហង់ឝ៉ាវ អ៊ឺម អៃ »។ យ៉ាគ់ ពែត្រុះ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ចនិះ ស្រៀវ ភុច ឡើ ញឺម ទុត ខាក់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","តគ់ ងឹប ប្រណូវ លែក ដើ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ពស៊ុំ ព្រចួត ប្រម៉ាង កាន មន់កជែត គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","អ៊ែ ម៉ើ ចង ណគ ម៉ើ តៀត ហឹ យ៉ាគ់ ពីឡាត់ ឡើ កឡា ពែក ប៉ាក់ ស្រុក។ ");
INSERT INTO brb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ហំប្រ៊ុះ យ៉ាគ់ យូដះ ឡើ កឡា ម៉ប គ្រែដៃ យែស៊ូ ហឹ ទី មែ ឡើ តៃ ម៉ើ ពថូត កជែត គ្រែដៃ យែស៊ូ ពអ៊ែ អ៊ែ ឡើ ធឹច ចាក់ ឡើ ដក់ ឈូន លៀន ពែ ជិត កាក់ ប៉្រាក់ ហឹ បូវ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម ហឹ បូវ តង់កង់ ក្រាគ់ សុនសាត យូដា ទឺ ");
INSERT INTO brb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ឡើ ម៉ាង រៀន៖ «អៃ នែ អយូច ឡើយ យ៉ាក់ អឈូន បនឹះ តៃ ប៊ិច យូច អាំ ដើ មែ ម៉ើ កជែត»។ ម៉ើ ត្រណើវ រៀន៖ «កាន នែ ទូត អ៊ឺម ហឹ ញ៉ា លឿង ហៃ កឡឹ ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","អ៊ែ យូដះ ឡើ ប្រាក់ ប្រយ លៀន ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ប៊្លី អ៊ែ ឡើ វីះ ដក់ ចង ដង់ គែត ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ម៉ើ រ៉ើះ លៀន ម៉ើ ម៉ាង រៀន៖ «លៀន នែ តាម ចឞាប់ ដូវ អ៊ឺម ងំជុ អរែង ទឹង លៀន ឋង់វ៉ាយ ង៉ើ យួរ ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ យ៉ាក់ លៀន នែ ឡើ លៀន កជែត បនឹះ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ប៊្លី ម៉ើ ចជែ ព្រចួត ប្រម៉ាង លែវ ឡើយ ម៉ើ ចក់ លៀន នែ ដក់ រួត ពដិះ មឺរ បឹ កឡា សស៊ូក មម៉ាន បក់ មន់ចះ បូវ តើម ប៊ឹង ស្រុក គែង ណគ់ មន់គែត ទឹង មួង។ ");
INSERT INTO brb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ញ៉ន ពអ៊ែ ឡើយ អ៊ែ ម៉ើ ជុ មឺរ នែ “មឺរ ផាម” ប៊ឹះ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","កាន នែ ឡើ កើត អាំ លំដាវ តាម ប៉ាគ់ យ៉ាគ់ យែរែមៀ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ រៀន៖ «ម៉ើ ចក់ លៀន ពែ ជិត កាក់ ប៉្រាក់ ឡើ ត្រ លៀន មែ អ៊ីស្រាអ៊ែល ម៉ើ ចាប់ ច្រណាប់ ទូះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","លៀន អ៊ែ ម៉ើ រួត ប្រិះ មឺរ យ៉ាគ់ កឡា សស៊ូក មម៉ាន ប៉ាគ់ គ្រែដៃ កន់ដ្រាគ់ ឡើ ប៉្រៃ អៃ »។ ");
INSERT INTO brb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","អ៊ែ តៃ នែ ដើ គ្រែដៃ យែស៊ូ ឡើ ឆុង ប៊ឹង ងឺរ យ៉ាគ់ កឡា ពែក ប៉ាក់ ស្រុក យ៉ាគ់ កឡា ពែក ប៉ាក់ ស្រុក ឡើ តង៉ា ណគ រៀន៖ «ហៃ ឡើយ ឡះ ហសឋិច សុនសាត យូដា?» គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ត្រ ឡើយ ហម៉ាង អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ហាក់ ប៊ឹង មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ផង ណគ ញឹះ តៃ ឡើ ត្រណើវ។ ");
INSERT INTO brb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ហដុង អ៊ឺម ឡះ ម៉ើ ចឹន ហៃ ទុត អើន ខ ឞាល់ អ៊ិន?» ");
INSERT INTO brb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","គ្រែដៃ យែស៊ូ ញឹះ តៃ ឡើ ត្រណើវ ហម មូយ អំម៉ាង ណាគ់ តៃ ឡើ ត្រណើវ។ អ៊ែ យ៉ាគ់ កឡា ពែក ប៉ាក់ ស្រុក តូវ ឡើ បើម ទុត ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ត្រំ កម៉ ទឹង ឞ៊ុន ពជឺរ យ៉ាគ់ កឡា ពែក ប៉ាក់ ស្រុក ឡើ ខើយ តោះ ពញឺះ មែ ម៉ើ ថូត មូយ រ៉ា ណគ់ អង់ង៉ាយ មែ ប៉ាសាសុន ម៉ើ ឡា។ ");
INSERT INTO brb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ទឹង អ៊ែ ប៊ិច បឹ មូយ រ៉ា ឡើ គូ ឃុក ឡើ លឺ បើម តៃ ចាគ់ ម៉ាត់ ណគ យែសូ បារ៉ាបះ។ ");
INSERT INTO brb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","តគ់ មែ ប៉ាសាសុន ម៉ើ តមួត ឡើយ អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា មែ រៀន៖ «បឹ អង់ង៉ាយ វ៉ើ ម៉ើត អន់តោះ ដើ វែ យែស៊ូ បារ៉ាបះ លឺ យែស៊ូ ម៉ើ ជុ គ្រែដៃ គ្រិះ?»។ ");
INSERT INTO brb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","យ៉ាគ់ ពីឡាត់ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ យ៉ាក់ ឡើ ណោះ រៀន ម៉ើ តៀត ម៉ប គ្រែដៃ យែស៊ូ ហឹ ណគ ញ៉ន តៃ ម៉ើ យឺម។ ");
INSERT INTO brb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ទឹង យ៉ាគ់ ពីឡាត់ ឡើ ដ្រូម ប៊ឹង ឞន តាត់ស៊ិន អ៊ែ ទ្រី ណគ ឡើ ប្រ៉ៃ មែ ដក់ ហាយ ហឹ ណគ រៀន៖ «ញ៉ង ហពទិត អ៊ឺម ប៊ឹង កាន បឹ ឡើ ចាគ់ ទឹង ត្រ នែ។ យ៉ាក់ មាំង អ៊ិន ឞាល់ អ៊ែ អពកី កយ៉ាគ់ ញ៉ន ដើ កាន ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ពន់ឆូម ពង់អ៊ុច មែ ប៉ាសាសុន បក់ មន់ឡា ហឹ យ៉ាគ់ ពីឡាត់ លំតោះ ពញឺះ បារ៉ាបះ អ៊ែ ណគ់ ដើ គ្រែដៃ យែស៊ូ មន់ប៉្រៃ លំពថូត កជែត។ ");
INSERT INTO brb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","យ៉ាគ់ កឡា ពែក ប៉ាក់ ស្រុក ឡើ តង៉ា រៀន៖ «អំប្រា បារ រ៉ា នែ បឹ អង់ង៉ាយ វ៉ើ ម៉ើត អន់តោះ ដើ វែ?» ម៉ើ ត្រណើវ រៀន៖ «បារ៉ាបះ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា មែ រៀន៖ «ប៉ាគ់ ពអ៊ែ ប៉ាគ់ ង៉ាយ អំបើម ដើ យែស៊ូ ម៉ើ ជុ គ្រែដៃ គ្រិះ នែ?» មែ លែក រ៉ា ម៉ើ ត្រណើវ រៀន៖ «ហំពឡាះ ប៉ាង ណគ!» ");
INSERT INTO brb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា រៀន៖ «ប៉ិ វ៉ើ ម៉ាង ប៉ាគ់ អ៊ិន ឡើ បើម អន់យូច អង់ង៉ាយ ដឹះ?» សរ៉ើម ម៉ើ ឡា ចាំ ថាំង រៀន៖ «ហំពឡាះ ប៉ាង ណគ!» ");
INSERT INTO brb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ តៃ រៀន ផវ អ៊ឺម លំភែ ប៊ឹង មែ តគ់ ខាក់ៗ ហរ៉ើម ម៉ើ បើម សគ្រែក សក្រឹន ចាំ ថាំង អ៊ែ ឡើ ចក់ ដាក ឌូច ទី ស្រះ ចាក់ ប៊ឹង ងឺរ មែ ប៉ាសាសុន ដើម ឡើ ម៉ាង រៀន៖ «អៃ អឡាប់ អ៊ឺម កាន ពលូះ ផាម បឹ តៃ ឡើ ប៊ិច យូច នែ កាន នែ ឡើ គ្លីះ ហឹ វែ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","លែក ដើ ប៉ាសាសុន ម៉ើ ត្រណើវ រៀន៖ «ផាម បឹ អន់នែ លំគ្លីះ ហឹ ញ៉ា ដើម ហឹ កួន ចូវ ញ៉ា កតាម!»។ ");
INSERT INTO brb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ តោះ ពញឺះ បារ៉ាបះ ដើ មែ អ៊ែ ណគ់ ដើ គ្រែដៃ យែស៊ូ អន់ណាវ ឡើ ប៉្រៃ ម៉ើ បឹត ដើ ឆមឺ ប្រាត់ អន់ដៃ ប៊្លី អ៊ែ ឡើ ម៉ប ហឹ ទី មែ តហាន មន់ពឡាះ ប៉ាង ប៊ឹង ឡង អង់ឝ៉ាង។ ");
INSERT INTO brb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","បូវ តហាន យ៉ាគ់ ពីឡាត់ ឡើ កឡា ពែក ប៉ាក់ ស្រុក ម៉ើ តៀត គ្រែដៃ យែស៊ូ ហឹ បយឺង ហន់ណាម ណគ ម៉ើ កឡូវ លែក ដើ តហាន ទឹង អ៊ែ មន់ដក់ តមួត វ៉ាង ឈុំ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ម៉ើ តោះ អាវ ណគ ម៉ើ តវ៉ារ់ ដើ ហំបាន ប៊្លុង ចះ ង៉មៗ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ម៉ើ កង់ អង់កង់ ឆ្រឡា បើម កនឺន ពគឺន ទិ ទូះ ណគ ដើម ម៉ើ ពឝ៉ឹន តង ទ្រែង ប៊ឹង ទី ចម៉ា ណគ ប៊្លី អ៊ែ ម៉ើ ជឹះ ត្រកូវ កដាប ហំបះ ឞឞួះ យយ៉ាល់ ណគ ម៉ើ រៀន៖ «ញ៉ះ ខរ៉ុប យ៉ាគ់ សឋិច សុនសាត យូដា!» ");
INSERT INTO brb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ដឹប ម៉ើ កយ៉ុះ ក្រហាក ណគ ម៉ើ ចក់ តង ទ្រែង ប៊ឹង ទី ណគ ម៉ើ បឹត ទូះ ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ប៊្លី ម៉ើ ឞឞួះ យយ៉ាល់ ណគ លែវ ឡើយ ម៉ើ ញ៉ាក់ ហំបាន ប៊្លុង ប៊ឹង ចាក់ ណគ អ៊ែ ម៉ើ ពហក ដើ អាវ ឡើ កឡឹ អន់ណាវ ប៊្លី អ៊ែ ម៉ើ តៀត ពឡាះ ប៉ាង កជែត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ម៉ើ ញឺះ តើម ប៊ឹង មួង ម៉ើ ជូល បឹ មូយ រ៉ា ម៉ាត់ ណគ ស៊ីម៉ូន មួង គីរែន ម៉ើ ពង់ខំ ណគ កួយ ឡង អង់ឝ៉ាង គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","តគ់ ម៉ើ ប៊ឹះ ឞន មូយ ម៉ើ ជុ ឝ៉ុលឝ៉ូថា ប៊ិច នឿណៃ រៀន «ឞន ទូះ លៀង» ");
INSERT INTO brb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ម៉ើ អាំ តវែ ឈឹង ជែម ម៉ើ ចិះ ពណាត់ ដើ ណគ លំញែត វ៉ិះ ឡើ តមឹង ឡើ ឌី អ៊ឺម ញែត។ ");
INSERT INTO brb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","លែវ ម៉ើ ពឡាះ ប៉ាង គ្រែដៃ យែស៊ូ ក្លើច ឡើយ បូវ តហាន ម៉ើ ចក់ ប្រវ៉ើន ហណក ណគ ម៉ើ រ៉ាប់ សណូត ត្រឌីវ មែ ឡើ ត្រ ប៉ុះ បឹ អង់ង៉ាយ បឹ ហង់អ៊ែ ឡើ ដូវ ចក់ ។ ");
INSERT INTO brb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ប្ល៊ី អ៊ែ ម៉ើ ដ្រូម ញ៉ាម ណគ ប៊ឹង អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ម៉ើ ខៀន ប៊ឹង ផឡាគ់ ម៉ើ ពហាយ កាន ម៉ើ កជែត ណគ រៀន៖ «ណគ នែ យែស៊ូ ឡើ សឋិច សុនសាត យូដា» ម៉ើ ជុ ផឡាគ់ ពឺង ទូះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ប៊ឹង អ៊ែ ម៉ើ ពឡាះ ប៉ាង បនឹះ ខម៉ូយ បារ រ៉ា ដៀក គ្រែដៃ យែស៊ូ ប៊ឹង ឡង អង់ឝ៉ាង ដិៗ មូយ រ៉ា តៃ ចម៉ា មូយ រ៉ា តៃ ចអៀវ។ ");
INSERT INTO brb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","បនឹះ ម៉ើ ដក់ តៃ អ៊ែ ម៉ើ ឞឞួះ យយ៉ាល់ ណគ ដើម ម៉ើ ង៉ិច ឝលែប ម៉ាត់ ហឹ ណគ ");
INSERT INTO brb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ម៉ើ ម៉ាង រៀន៖ «អើយ ដូវ អន់ទិ! ហន់ឆិ ហរៀន ហំសោះ រំប៊្លឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ហរៀន ហំបើម ឡឹះ លញ៉ាគ់ ពែ តង៉ៃ លំចឹះ។ ប៉ាគ់ ហកួន កឡ គ្រែដៃ ហំតោះ ចាក់ ហៃ កឡឹ ឡាំង ហំទឺះ តើម ទិ ឡង អង់ឝ៉ាង អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","អ៊ែ ណគ់ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ពន់ឆាំ ឞឞួះ យយ៉ាល់ ណគ ប៉ាគ់ទឺ ម៉ើ ម៉ាង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ឡើ ហវ៉ាត់ មែ គែង ដូវ ឡើ ហវ៉ាត់ ចាក់ ណគ កឡឹ ដូវ អ៊ឺម! ប៉ាគ់ ឡើ សឋិច សុនសាត អ៊ីស្រាអ៊ែល ណិះៗ លំទឺះ ឡាំង តើម ទិ ឡង អង់ឝ៉ាង អ៊ែ ញំចាប់ មឹង ណគ! ");
INSERT INTO brb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“ណគ ឡើ មឹង អ៊ីង គ្រែដៃ ប៉ាគ់ គ្រែដៃ លំញឹម ក្លើម ដើ ណគ ណិះៗ លំតោះ ណគ!” យ៉ាក់ ណគ កឡឹ ឡើយ ឡើ រៀន “អៃ នែ អកួន កឡ គ្រែដៃ”»។ ");
INSERT INTO brb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","អ៊ែ ណគ់ អំប្រា ខម៉ូយ ម៉ើ ពឡាះ ប៉ាង ដៀក គ្រែដៃ យែស៊ូ អំប្រា ផម៉ាត ណគ ពអ៊ែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","តើម ប៊ឹង ឆុង ម៉ាត់ តង៉ៃ ឆា ដើ ប៊ឹះ ម៉ូង ពែ អំប៊ឹ លែក ដើ ប៊្រី ដាក មែ ឡើ កឡាំ ប៊្រែ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ទឹង ម៉ូង ពែ អំប៊ឹ អ្យាង គ្រែដៃ យែស៊ូ ឡើ ហរ៉ាវ ម៉ាង ថាំងៗ រៀន៖ «អ៊ែលី អ៊ែលី ឡាម៉ា សាបិចថានី?» ប៊ិច នឿណៃ រៀន «ឡា គ្រែដៃ អៃ គ្រែដៃ អៃ អើយ ពយ៉ិ ឡើ ត្រ ហតាក់ អៃ ប៉ាគ់ នែ?» ");
INSERT INTO brb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","មែ អន់នឺ ម៉ើ ឆុង ប៊ឹង អ៊ែ ម៉ើ ដុង ប្រម៉ាង ណគ អ៊ែ ម៉ើ រៀន៖ «អ៊ិន ឡើ កឡូវ យ៉ាគ់ អ៊ែលីយ៉ា!» ");
INSERT INTO brb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ហំប្រ៊ុះ ដើ អ៊ែ បឹ មូយ រ៉ា ទឹង បូវ មែ ឡើ ដក់ អ្រយ៉ាវ ចក់ ក្រដាគ់ ឡើ ចូប ទិ តវែ ឈឹង ជែម ឈូគ ឡើ ចង ប៊ឹង តង ត្រាង ឡើ តូល អាំ ដើ គ្រែដៃ យែស៊ូ លំឈ្រែប។ ");
INSERT INTO brb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","មែ គែង អ៊ែ ម៉ើ ម៉ាង រៀន៖ «ងំចាំ ឝ្លាំង អំប យ៉ាគ់ អ៊ែលីយ៉ា លំប៊ឹះ ហវ៉ាត់ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","គ្រែដៃ យែស៊ូ ឡើ ហរ៉ាវ ថាំងៗ ឡឹះ អន់ណាវ ប្ល៊ី អ៊ែ ឡើ តាត់ សើម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ហំប្រ៊ុះ ដើ អ៊ែ ហំបាន ទិះ ទុត កវឹវ ម៉ើ ពាំង អាត់ កនុង ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ ត្រសាក តង់បារ ប្រយ តើម ទិ ពឺង ប៊ឹះ ប្រិះ ណគ់ ប្រិះ ឡើ អង់ឝឹត តម៉ ដដារ ឡើ តពឺះ ប៉្លះ ");
INSERT INTO brb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ត្រម ច្រាង ចនុ កយ៉ក់ ម៉ើ តប៉ើក អ៊ែ ណគ់ មែ ម៉ើ ចាប់ មឹង គ្រែដៃ ម៉ើ គែត ឡើយ អ៊ែ ទុត អើន ម៉ើ ញិវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","តគ់ គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ លែក ដើ មែ ម៉ើ ញិវ ឡឹះ អ៊ែ ម៉ើ ញឺះ តើម ប៊ឹង ចនុ កយ៉ក់ ម៉ើ មឹត ទឹង មួង យែរូសាឡឹម ឡើ មួង ចាគ់ ភែង យ៉ើម ម៉ើ ពដៃ ចាក់ ដើ បនឹះ ទុត អើន ម៉ើ តៃ។ ");
INSERT INTO brb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","តគ់ ណាយ តហាន រ៉ូម ដើម បូវ តហាន ណគ ម៉ើ ញ៉ាម គ្រែដៃ យែស៊ូ ម៉ើ តៃ ប្រិះ ឡើ អង់ឝឹត ដើម ម៉ើ តៃ លែក ដើ កាន ឡើ កើត អ៊ែ ម៉ើ ឌូង ទុត ខាក់ ម៉ើ ម៉ាង រៀន៖ «បឹ អន់នែ ឡើ កួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត ឡើយ!» ");
INSERT INTO brb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ប៊ឹង អ៊ែ ប៊ិច មែ កទ្រី ទុត អើន ម៉ើ ឝ្លាំង តើម ប៊ឹង ចង៉ាយ ង៉ាយ មែ នែ ឡើយ ម៉ើ តូយ ឡាំលៀង គ្រែដៃ យែស៊ូ ណាគ់ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ទឹង បូវ មែ នែ ប៊ិច ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា ណាង ម៉ារី មែគ យ៉ាកុប អំប្រា យ៉ូស៊ែប ដើម ទ្រី យ៉ាគ់ ស៊ែប៊ែឌែ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","តគ់ ឡើ អំប៊ឹ បឹ ប៊ិច បាក់ មូយ រ៉ា ម៉ាត់ ណគ យ៉ូស៊ែប ស៊្រុក អារីម៉ាធែ ឡើ ប៊ឹះ តគ់ អ៊ែ ណគ នែ ឡើ លុកស៊ិក គ្រែដៃ យែស៊ូ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ឡើ ដក់ ឡា ចក់ កយ៉ក់ យែស៊ូ ហឹ យ៉ាគ់ ពីឡាត់។ អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ ប្រ៉ៃ មែ តហាន មន់អាំ កយ៉ក់ គ្រែដៃ យែស៊ូ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","យ៉ាគ់ យ៉ូស៊ែប ឡើ ចក់ កយ៉ក់ អ៊ែ ឡើ បវ ដើ ហំបាន បក ចាគ់ៗ ទុត ច្រណាប់។ ");
INSERT INTO brb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ប្ល៊ី អ៊ែ ឡើ ដក់ ជុ ហឹ ត្រម ច្រាង ចនុ កយ៉ក់ ណគ ឡើ បើម ហន់ដើម ច្រាង នែ ឡើ ប៉ោះ អន់នួរ ជុ ដើ ណគ កឡឹ។ ឡើ ព្រលូ តម៉ ទុត ទិះ ឡើ ក្លឹល ត្រម ច្រាង ប្ល៊ី អ៊ែ ឡើ ជឹ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា ដើម ណាង ម៉ារី លមូយ អំប្រា ដ្រូម ហ្រទឹង ដើ ត្រម ច្រាង អំប្រា តៃ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","តគ់ ប្រណូវ ឡើ ត្រ តង៉ៃ ព្រឹង បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ផារីស៊ី ម៉ើ តមួត ដក់ ចជែ ហឹ យ៉ាគ់ ពីឡាត់ ");
INSERT INTO brb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ម៉ើ ប៉ច រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ញ៉ើ ចនិះ ហឹ ប្រម៉ាង បឹ ពសូក វ៉ក អ៊ែ ទឹង ណាគ់ ឡើ ញិវ ឡើ រៀន “អង់គែត តគ់ តង៉ៃ ទី ពែ អន់ញិវ ឡឹះ”។ ");
INSERT INTO brb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ប៉ាគ់ ពអ៊ែ ហំប្រ៉ៃ មែ មន់ញ៉ាម អាំ ខាក់ៗ ប៊ឹង ត្រម ច្រាង អាំ ប៊ឹះ ពែ តង៉ៃ កឡាគ់ មែ លុកស៊ិក ណគ មន់ដក់ ចក់ ម៉ច ហន់ណូវ មន់ហាយ ដើ មែ ប៉ាសាសុន មន់រៀន លំញិវ ឡឹះ។ កាន ពសូក វ៉ក អន់នែ លំញ៉ាក ជឺរ កាន ពសូក វ៉ក អន់នួរៗ»។ ");
INSERT INTO brb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","យ៉ាគ់ ពីឡាត់ ឡើ ត្រណើវ រៀន៖ «វែ វ៉ើ ប៊ិច មែ ម៉ើ ញ៉ាម ហន់ឋុ ឡើយ ប៉ាគ់ ពអ៊ិន វន់ដក់ ញ៉ាម តាម អ្រណោះ វែ ឆិ!»។ ");
INSERT INTO brb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","អ៊ែ ម៉ើ វីះ ប្រយ ម៉ើ ឡារ ព្រទែប តម៉ ក្រឡឹល ដើម ម៉ើ ប៉្រៃ បូវ មន់ញ៉ាម ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","តង៉ៃ ម៉ើ ព្រឹង ក្លើច ឡើយ ឡើ ត្រ ទឹង តង៉ៃ អាទិត ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា ដើម ណាង ម៉ារី លមូយ តើម ភូង មាំង អំប្រា ដក់ ហឹ ត្រម ច្រាង ចនុ កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ទឹង អ៊ែ ឡាង ប្រិះ កអវ ឡើ អង់ឝឹត ហ្រលឹះ ទុត ថាំង ឞាវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ទឺះ តើម ទិ គ្រែ ឡើ ប៉ើក ព្រលូ កន់ស៊ីត តម៉ ក្រឡឹល ប្ល៊ី អ៊ែ ឡើ ដ្រូម ពឺង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ចាក់ ដៃ ណគ ឡើ ចាល់ ឞាល់ លលីប ប្រវ៉ើន ហណក ណគ ឡើ បក ឞាល់ ម៉ះ។ ");
INSERT INTO brb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","មែ តហាន ម៉ើ ញ៉ាម អ៊ែ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ អន់ឆាក់ យ៉ាង ញឹះ ម៉ើ គែត វិត។ ");
INSERT INTO brb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ឞាវ គ្រែដៃ ឡើ ហាយ ដើ អំប្រា កទ្រី អ៊ែ រៀន៖ «ញ៉ង សប្រា ឌូង អ៊ឺម! អៃ អណោះ ឡើយ សប្រា ដក់ ដាំង គ្រែដៃ យែស៊ូ ណគ់ មែ ម៉ើ ពឡាះ ប៉ាង កជែត។ ");
INSERT INTO brb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ប៊ិច យ៉ាវ ណគ ហឹ នែ ឡើ ញិវ ឡើយ ប៉ាគ់ ណគ ឡើ ហាយ ពន់ឋើម ឡើយ។ មិញ សប្រា លំដក់ ឝ្លាំង ឡាំង ហឹ ឞន ម៉ើ ពឝី ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","អ៊ែ សប្រា លំជឹ ប៉ច ដ្រិះៗ ដើ មែ លុកស៊ិក ណគ រៀន ណគ ឡើ ញិវ ឡឹះ ណិះៗ ឡើ ដក់ អន់នួរ វែ ហឹ ស្រុក ឝ៉ាលីលែ ហឹ អ៊ែ វន់តៃ ណគ។ អន់នែ អៃ អហាយ ដើ សប្រា»។ ");
INSERT INTO brb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","អំប្រា ជឹ ដ្រិះៗ ប្រយ តើម ប៊ឹង ត្រម ច្រាង ចនុ កយ៉ក់ ដឹប អំប្រា ឌូង ដើម អំប្រា ញឹម ក្លើម ទុត ខាក់ អំប្រា ជឹ អ្រយ៉ាវ ហាយ ប្រម៉ាង ឞាវ គ្រែ ដើ មែ លុកស៊ិក គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","គ្រែដៃ យែស៊ូ កអវ ឡើ ប៊ឹះ ប្រយ តគ់ អំប្រា ឡើ ម៉ាង រៀន៖ «ហឹ ង៉ាយ សប្រា ដក់ ណាង?» អំប្រា ដក់ អម ឈឹង ណគ ដើម អំប្រា កដាប ហំបះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ញ៉ង សប្រា ឌូង អ៊ឺម! សប្រា លំជឹ ហាយ ដើ មែ បូវ ប៊ែង អៃ មន់ដក់ ហឹ ស្រុក ឝ៉ាលីលែ តគ់ ហឹ អ៊ែ ប្រយ មន់តៃ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","អំប្រា កទ្រី នែ ណាគ់ ទឹង អំប្រា ដក់ តៃ នែ មែ តហាន ញ៉ាម ត្រម ច្រាង អន់នឺ រ៉ា ម៉ើ ជឹ មឹត ហឹ មួង ម៉ើ ប៉ច ដើ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ លែក ដើ កាន ឡើ កើត អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ពស៊ុំ ព្រចួត ប្រម៉ាង អ៊ែ ម៉ើ អាំ លៀន ទុត អើន តម៉គ់ មែ តហាន ");
INSERT INTO brb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ដើម ម៉ើ ថាន់ រៀន៖ «ប៉ាគ់ នែ វន់ម៉ាង “ទឹង មាំង ប៊ឹង ញ៉ើ ហង់ង៉ាន់ តៀក មែ លុកស៊ិក ណគ ម៉ើ ដក់ ចក់ ម៉ច កយ៉ក់”។ ");
INSERT INTO brb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ប៉ាគ់ កាន អន់នែ លំលឺ ប៊ឹះ កឡា ពែក ប៉ាក់ ស្រុក ណាគ់ ញ៉ា ញំចជែ ហឹ ណគ អ៊ែ ញ៉ង លំញ៉ាក ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","អ៊ែ បូវ មែ តហាន ម៉ើ ចក់ ប្រយ លៀន ដើម ម៉ើ បើម តាម ប៉ាគ់ មែ ម៉ើ ថាន់។ កាន ម៉ើ រៀន មែ លុកស៊ិក ម៉ើ ចក់ ម៉ច កយ៉ក់ ឡើ លឺ ប្រយ បុ សុនសាត យូដា ឆា ដើ ប៊ឹះ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","លុកស៊ិក គ្រែដៃ យែស៊ូ លែក ជិត មូយ រ៉ា ម៉ើ ដក់ ហឹ ស្រុក ឝ៉ាលីលែ ប៊ឹះ ចន់ឌូ ណគ់ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ ដក់។ ");
INSERT INTO brb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ហំប៊្រុះ ម៉ើ តៃ គ្រែដៃ យែស៊ូ ម៉ើ កដាប ហំបះ ប្រយ ណគ ហាក់ ប៊ិច មែ អន់នឺ ណាគ់ ម៉ើ វ៉ឹត រៀន ណោះ លំត្រ អ៊ឺម ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","គ្រែដៃ យែស៊ូ ឡើ ដក់ តគ់ មែ ឡើ ហាយ រៀន៖ «គ្រែដៃ ឡើ អាំ ដើ អៃ លែក ដើ អាតណាត ទឹង ឡាង គ្រែ ដើម ទិ ឡាង ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ប៉ាគ់ ពអ៊ែ វន់ដក់ ពហាយ ត្រំ សុនសាត អាំ មន់លុកស៊ិក អៃ អ៊ែ វន់បើម ឞ៊ុន តម៉ូច ដាក ដើ មែ កនុង ម៉ាត់ គ្រែដៃ បើគ កនុង ម៉ាត់ កួន កឡ ណគ ដើម ទឹង កនុង ម៉ាត់ ផវ យ៉ាង ចាគ់ លួង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ដើម វន់ពង់ហៀន មែ អាំ មន់បើម ត្រួយ លែក ដើ កាន អៃ អប៉្រៃ វែ។ អាំ វន់ណោះ រៀន អៃ អគូ ប៊ឹង វែ អន់សច ឋា ដើ ឡូច ឡាង ប្រិះ ឡាង គ្រែ»។");
INSERT INTO brb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","កាន ចាគ់ ពហាយ កាន គ្រែដៃ យែស៊ូ គ្រិះ ឡើ កួន កឡ គ្រែដៃ ឡើ ពន់តើម ប៉ាគ់ នែ៖ ");
INSERT INTO brb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ឡើ ត្រ ប៉ាគ់ យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡៃ មាំង ឡើ ខៀន ជុ ទឹង ពឹម រៀន៖ គ្រែដៃ ឡើ ហាយ រៀន៖ «អៃ អំប៉្រៃ បឹ មូយ រ៉ា លំដក់ ពហាយ ដើ បូវ អន់នួរ ហៃ ណគ លំព្រនៀម ពចាគ់ ទ្រូង អន់នួរ ដើ ហៃ ។ ");
INSERT INTO brb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ណគ អ៊ែ លំពហាយ ថាំងៗ ហឹ ត្រិញ ក្លៀវៗ រៀន៖ “មិញ វន់ចឝ៉ះ ពចាគ់ ទ្រូង ដើ គ្រែដៃ កន់ដ្រាគ់ វន់ពន់ទឹង ទ្រូង ដើ ណគ”»។ ");
INSERT INTO brb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ប្រម៉ាង នែ ឡើ ដាវ ម៉ាត់ ម៉ាត ឡើយ។ ប៊ិច កឡ មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ យ៉ូហាន ឡើ គូ ហឹ ត្រិញ ក្លៀវៗ ឡើ ពហាយ ដើ បនឹះ ចម៉ាវ អាំ មន់ពលិះ ចនិះ អ៊ែ គ្រែដៃ លំតាក់ ថូត ដើ មែ ដើម យ៉ូហាន ឡើ ប៉្រៃ អាំ មន់បើម ឞ៊ុន ម៉ូច ដាក ពដៃ រៀន ម៉ើ ពលិះ ចនិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","លែក ដើ មែ ទឹង ស្រុក យូដា ដើម តូច ដើ មែ ទឹង មួង យែរូសាឡឹម ម៉ើ ដក់ ហឹ យ៉ាគ់ យ៉ូហាន។ ម៉ើ ហំប្លប ចាក់ ម៉ើ ហាយ អ្រយូច មែ អ៊ែ យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក ដើ មែ ប៊ឹង ដណៃ យ៉ូរដាន់ អ៊ែ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","យ៉ាគ់ យ៉ូហាន ឡើ ហក អាវ ឝ៉ុះ ម៉ើ តាញ ដើ សក់ អូត ប៊ឹង តនួយ ណគ ឡើ តាន់ សអ៊ែវ ម៉ើ បើម ដើ ហំបក ពត្រូវ ដើម ឡើ ចា អរ៉ាច ដឹប ដាក ស៊ុត។ ");
INSERT INTO brb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","យ៉ាគ់ យ៉ូហាន ឡើ ពហាយ ដើ មែ ប៉ាសាសុន រៀន៖ «ប៊ិច មូយ រ៉ា ឡើ ខាក់ ជឺរ អៃ ណគ អ៊ិន លំប៊ឹះ អន់ទុន អៃ សំយ៉ះ អំបើម ក៝ត អំអង់គុះ ឡិះ ឆមឺ កើប ប៊ឹង ឈឹង ណគ ណាគ់ តៃ លំឃឺ។ ");
INSERT INTO brb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ដើ អៃ នែ អបើម ឞ៊ុន តម៉ូច វែ ដើ ដាក អ៊ែ ណគ់ ដើ ណគ អ៊ិន លំតម៉ូច វែ ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ទឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តើម ទិ ស៊្រុក ណាសារែត ស្រុក ឝ៉ាលីលែ ឡើ ដក់ ហឹ យ៉ាគ់ យ៉ូហាន។ អ៊ែ យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក ដើ ណគ ប៊ឹង ដណៃ យ៉ូរដាន់។ ");
INSERT INTO brb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ឌឹក តើម ចុ ដាក អ៊ែ ឡើ តៃ គ្រែ ឡើ ប៉ើក ផូង ដើម ឡើ តៃ ផវ យ៉ាង គ្រែដៃ ឡើ ទឺះ គូ ទិ ណគ ឡើ បើម ប៉ាគ់ កំប៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","អ៊ែ ម៉ើ ដុង ប្រយ ប្រម៉ាង តើម ទិ គ្រែ ឡើ រៀន៖ «ហៃ នែ ហកួន ប្រម៉ើត អៃ ហត្រ ទឹង ក្លើម អៃ ទុត ខាក់!»។ ");
INSERT INTO brb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ហំប៊្រុះ ដើ អ៊ែ ផវ យ៉ាង គ្រែដៃ ឡើ តៀត គ្រែដៃ យែស៊ូ ហឹ ត្រិញ ក្លៀវៗ។ ");
INSERT INTO brb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ឡើ គូ ហឹ ត្រិញ ក្លៀវៗ លញ៉ាគ់ ពួន ជិត តង៉ៃ អ៊ែ អរ៉ាក់ សតាំង ឡើ ពលូង ណគ។ ទឹង ត្រិញ គ្រែដៃ យែស៊ូ ឡើ គូ អ៊ែ ឡើ ប៊ិច ពត្រូវ ប៊្រី ដិ។ ទឹង អ៊ែ ប៊ិច ឞាវ គ្រែដៃ ម៉ើ បើម ឞយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ប៊្លី ម៉ើ រ៉ាប់ ចិះ ឃុក យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក គ្រែដៃ យែស៊ូ ឡើ ជឹ ហឹ ស្រុក ឝ៉ាលីលែ អ៊ែ ឡើ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ឡើ រៀន៖ «តង៉ៃ គ្រែដៃ ឡើ ខណាត ជុ ឡើ ប៊ឹះ ឡើយ ដើម កាន គ្រែដៃ លំពែក ប៉ាក់ លំប៊ឹះ ហឹត ឡើយ ប៉ាគ់ទឺ។ មិញ វន់ពលិះ ចនិះ ដឹប វន់ចាប់ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ!»។ ");
INSERT INTO brb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ទឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ បរ ពឹះ សមុត ឝ៉ាលីលែ ឡើ តៃ យ៉ាគ់ ស៊ីម៉ូន អំប្រា អោះ ណគ អន់ឌ្រែ ទឹង អំប្រា ឆុក យ៉ាក់ អំប្រា ខើយ ដាំង ចា ហំពួត ទ្រឺ។ ");
INSERT INTO brb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","គ្រែដៃ យែស៊ូ ឡើ ច្រា អំប្រា រៀន៖ «ដក់ សប្រា លំតូយ អៃ អំប៉្រៃ សប្រា សាត ដាំង បនឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","អ៊ែ អំប្រា តាក់ ប្រយ ឆណុក អំប្រា ប៊ឹង អិះ អំប្រា ដក់ តូយ គ្រែដៃ យែស៊ូ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ងឺរ ឞិត ឞ៊ែត ឡើ តៃ យ៉ាកុប អំប្រា អោះ ណគ យ៉ូហាន ទឹង អំប្រា រន់ឋាប់ ឈ្រុល អួន ទឹង ឌូក អំប្រា នែ កួន យ៉ាគ់ ស៊ែប៊ែឌែ។ ");
INSERT INTO brb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ តៃ អំប្រា ឡើ កឡូវ ប្រយ អំប្រា ដក់ តូយ ណគ អ៊ែ អំប្រា ដក់ តូយ ប្រយ។ អំប្រា តាក់ បើគ អំប្រា យ៉ាគ់ ស៊ែប៊ែឌែ ទឹង ឌូក អរែង ដើ មែ គូលី។ ");
INSERT INTO brb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ មឹត ទឹង មួង កាផារនុំ។ អ៊ែ តគ់ តង៉ៃ ព្រឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ មឹត ហឹ រ៉ូង ពស៊ុំ ដើម ឡើ ពង់ហៀន មែ ទឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ណគ់ មែ ម៉ើ ចង់ហៀង គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន តូវ ម៉ើ ញ៉ម យ៉ាក់ ប៊ឹង ឡើ ពង់ហៀន ឡើ ប៊ិច អាតណាត ត្រ អ៊ឺម ប៉ាគ់ ដើ មែ ណាយឃូ ពង់ហៀន ចឞាប់។ ");
INSERT INTO brb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ប៊ឹង អ៊ែ ទឹង រ៉ូង ពស៊ុំ ប៊ិច កឡ មូយ រ៉ា អរ៉ាក់ ឡើ មឹត ទឹង ណគ ឡើ ហរ៉ាវ ប៉ាគ់ ម៉ាង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«អើយ គ្រែដៃ យែស៊ូ ស្រ៊ុក ណាសារែត ហដក់ ដាំង ខ ប៉ាគ់ ង៉ាយ ហឹ ញ៉ា? ហដក់ ថំឡាយ ញ៉ា ឡះ? អៃ អណោះ ឡើយ ហៃ ហកឡា ចាគ់ លួង ហប៊ឹះ តើម ទិ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ក្រាគ់ ដើ អរ៉ាក់ អ៊ែ រៀន៖ «ខៀង ហង់គូ! ហំវីះ តើម ប៊ឹង បឹ អន់នែ!»។ ");
INSERT INTO brb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","អរ៉ាក់ ឡើ បើម ដើ បឹ ហង់អ៊ែ ឡើ បង់ កណាំង កាញ ប៊្លី អ៊ែ ឡើ វីះ ប៉ាគ់ ហរ៉ាវ ទុត ថាំង។ ");
INSERT INTO brb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","លែក ដើ មែ ហឡឹង ប្រយ ម៉ើ គូ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ពយ៉ិ អិះ ប្រម៉ាង ណគ នែ? ឡើ ពង់ហៀន កាន ហន់ដើម ឡើ ប៊ិច អាតណាត ឞាល់ នែ។ ឡើ ម៉ាង ដើ អរ៉ាក់ អរ៉ាក់ ណាគ់ ម៉ើ ចង់ហៀង ម៉ាង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","អ៊ែ ឡើ លឺ កន់ចុង ដុង កន់ឋារ់ ដ្រិះៗ ប្រយ កាន គ្រែដៃ យែស៊ូ បុ ស្រុក ឝ៉ាលីលែ។ ");
INSERT INTO brb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ប៊្លី គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ វីះ តើម ប៊ឹង រ៉ូង ពស៊ុំ ម៉ើ ដក់ មឹត ហឹ ហន់ណាម យ៉ាគ់ ស៊ីម៉ូន អំប្រា អន់ឌ្រែ ដើម យ៉ាកុប អំប្រា យ៉ូហាន អំប្រា តូយ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ទឹង អ៊ែ ហឝ៉ៃ ម៉ិ យ៉ាគ់ ស៊ីម៉ូន ឡើ ឝ្រុន ឡើ កី ប៊ឹង ឝ្រែ។ ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ ហឹ អ៊ែ ម៉ើ ហាយ ប្រយ ដើ ណគ ម៉ើ រៀន ឡើ ឈិ។ ");
INSERT INTO brb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ តគ់ ណគ ឡើ រ៉ាប់ ប៊ឹង ទី ពឌឹក ណគ ឝ្រុន ណគ ឡើ នៀម ប្រយ អ៊ែ ឡើ អាំ ចណង់ ចណា ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","តគ់ ឡើ អំប៊ឹ ម៉ាត់ តង៉ៃ ឡើ លុច ឡើយ អ៊ែ ម៉ើ ដក់ តៀត មែ ម៉ើ ឈិ ដើម បនឹះ អរ៉ាក់ មឹត លែក ដើ អិះ ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","តូច ដើ មែ ទឹង មួង ម៉ើ តមួត ពទុំ ប៊ឹង ឝឡោះ ហន់ណាម យ៉ាគ់ ស៊ីម៉ូន។ ");
INSERT INTO brb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","គ្រែដៃ យែស៊ូ ឡើ ពនៀម ឆនិ បនឹះ ទុត អើន ឆនិ មែ ដិ អន់ដិ ដើម ឡើ ពន់ឌ្រុះ អរ៉ាក់ ទឹង បនឹះ ទុត អើន ដិ។ ហាក់ គ្រែដៃ យែស៊ូ ឡើ អាំ អ៊ឺម អរ៉ាក់ ហង់អ៊ែ មន់ចជែ យ៉ាក់ ម៉ើ ហង់ឝ៉ាវ ឡើយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","តគ់ ងឹប ប្រណូវ ដៀប ប្រាង គ្រែដៃ យែស៊ូ ឡើ រ៉ៃ ឡើ វីះ ឡើ ដក់ ហឹ ឞន វៀកៗ អ៊ែ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ហឹ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","អ៊ែ ដើ យ៉ាគ់ ស៊ីម៉ូន ដើម មែ ម៉ើ គូ ប៊ឹង ណគ ម៉ើ ឆ្រួយ សាត គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","តគ់ ម៉ើ តៃ ណគ ឡើយ អ៊ែ ម៉ើ ហាយ ដើ ណគ រៀន៖ «លែក ដើ បូវ ម៉ើ សាត ដាំង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ហាក់ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «ញ៉ះ ញន់ដក់ ហឹ គែង ហឹ ស៊្រុក ចឹម ចើម ប្លះ នែ ដិ អន់ដិ បក់ អំពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ហឹ អ៊ែ ប៉ាគ់ទឺ ញ៉ន ដើ កាន នែ ឡើយ អ៊ែ អដក់ ហឹ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ត្រំ អំប៊ុ ទឹង ស្រុក ឝ៉ាលីលែ ឡើ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ហឹ រ៉ូង ពស៊ុំ មែ អ៊ែ ដើម ឡើ ពន់ឌ្រុះ អរ៉ាក់ អាំ វីះ តើម ប៊ឹង បនឹះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ទឹង អ៊ែ ប៊ិច បនឹះ ស៊ិត ស៊ូត មូយ រ៉ា ឡើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ឡើ ជឹះ ត្រកូវ ឡា ឡូម រៀន៖ «ឡា អុះ យ៉ាគ់ អ អើយ ប៉ាគ់ ហន់ឌី ហៃ ឡើយ ហន់ដូវ ពនៀម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","គ្រែដៃ យែស៊ូ ឡើ ស្រុស្រៀត ណគ ទុត ខាក់ អ៊ែ ឡើ ពឌឺះ ទី ជុ ពឺង ណគ ដើម ឡើ ម៉ាង រៀន៖ «ឌី ហឹ ហន់នៀម ហំមិញ!»។ ");
INSERT INTO brb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ហំប៊្រុះ ដើ អ៊ែ ស៊ិត ស៊ូត ណគ ឡើ នៀម ស្រើវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ បយឹ ណគ ដ្រិះៗ ដើម ឡើ ថាន់ ទុត ខាក់ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«ហន់កាំ យ៉ឹ ញ៉ង ហពប៉ច អង់ង៉ាយ អ៊ឺម ប្រយ ដើ បូវ! លំត្រ ហន់ដក់ ពដៃ ចាក់ ហៃ ហឹ កឡា បប៊ុះ ថួយ អ៊ែ ហំបើម ឞ៊ុន ពឆ្រះ ចាក់ ម៉ប អន់ណាំ ដើ គ្រែដៃ តាម ប៉ាគ់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ អាំ មែ លែក រ៉ា មន់ណោះ រៀន ចាក់ ហៃ ហនៀម ចាគ់ ម៉ាត់ ម៉ាត ឡើយ »។ ");
INSERT INTO brb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ត្រ យ៉ាវ ហំប៊្រុះ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ពហាយ ដើ បូវ ទុត អើន កាន អ៊ែ ត្រំ អំប៊ុ ត្រំ ឞន។ ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ គ្រែដៃ យែស៊ូ ឡើ ដូវ យ៉ាវ មឹត ទឹង មួង អាំ បនឹះ មន់ណោះ ឡើ គូ ប្លះ ឞន វៀកៗ គែង មួង ដើម ប៊ិច បនឹះ ទុត អើន តើម ប៊ឹង ទិ តើម ប៊ឹង ចុ ម៉ើ ដក់ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ប៊្លី អ៊ែ បារ ពែ តង៉ៃ គ្រែដៃ យែស៊ូ ឡើ ជឹ ហឹ មួង កាផារនុំ អន់ណាវ។ មែ ទឹង មួង ម៉ើ ដុង គ្រែដៃ យែស៊ូ ឡើ ជឹ គូ ហឹ ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","អ៊ែ បនឹះ ទុត អើន ម៉ើ ដក់ តមួត ឝុញ តឝុញ តូវ ឡើ កដៀត ទឹង ហន់ណាម ហង់អ៊ែ សំយ៉ះ ហឹ ឝឡោះ ណាគ់ តៃ ហូះ ប៉ាគ់ទឺ។ គ្រែដៃ យែស៊ូ ឡើ ពហាយ ប្រម៉ាង គ្រែដៃ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ហំប៊្រុះ ដើ អ៊ែ ប៊ិច បនឹះ អន់នឺ រ៉ា ម៉ើ ប៊ឹះ ម៉ើ តៀត បឹ ឡើ កុង ឈឹង ហឹ គ្រែដៃ យែស៊ូ។ ពួន រ៉ា ម៉ើ ទូង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ហាក់ ម៉ើ ដូវ អ៊ឺម មឹត តៀត ណគ ប៊ឹះ ហឹ គ្រែដៃ យែស៊ូ ញ៉ន បនឹះ ឡើ អើន ហ៊ែត។ អ៊ែ ម៉ើ ឌឹក ទឹង បូយ ហន់ណាម  ម៉ើ សោះ ប៉ើក តៃ បូយ ឡើ ត្រ ហ្រទឹង កនូ គ្រែដៃ យែស៊ូ។ អ៊ែ ម៉ើ យ៉ូង ពឌឺះ ព្រសច បឹ ឆនិ ប៊ឹង ប៊ែល ត្រនូង តៃ ឝឡោះ មែ ម៉ើ ប៉ើក។ ");
INSERT INTO brb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","គ្រែដៃ យែស៊ូ ឡើ តៃ មែ អ៊ែ ម៉ើ មឹង ណគ ឞាល់ អ៊ែ អ៊ែ ឡើ ហាយ ដើ បឹ ឈិ កុង ឈឹង អ៊ែ រៀន៖ «អតាក់ ឡើយ ឞាប ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ប៊ិច មែ ណាយឃូ ពង់ហៀន ចឞាប់ អន់នឺ រ៉ា ម៉ើ ដ្រូម ប៊ឹង អ៊ែ ម៉ើ ឃឹត អង់ឃឹត រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ពយ៉ិ ឡើ ត្រ បឹ អន់នែ ឡើ ម៉ាង ប៉ាគ់ នែ? ឡើ ផម៉ាត គ្រែដៃ! វ៉ិះ ឌិវ គ្រែដៃ មូយ អិះ ឡើយ ឡើ ដូវ តាក់ ឞាប បនឹះ»។ ");
INSERT INTO brb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","គ្រែដៃ យែស៊ូ ឡើ ណោះ ប្រយ ខនឹត មែ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ឃឹត ប៉ាគ់ នែ ឡើ ត្រ ឞិ? ");
INSERT INTO brb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ប៉ាគ់ អំបើម អន់នៀម បឹ កុង ឈឹង នែ អំប៉្រៃ ណគ លំឌឹក ចក់ ប៊ែល ត្រនូង ជឹ ហំមិញ អ៊ែ វន់ណោះ ហង់ឝ៉ាវ រៀន អៃ អប៊ិច អាតណាត តើម ទិ គ្រែដៃ ដើម អដូវ តាក់ ឞាប ដើ បនឹះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ហាក់ អៃ អងុញ អាំ វែ វន់ណោះ រៀន កួន បនឹះ ឡើ ប៊ិច អាតណាត តាក់ ឞាប ដើ បនឹះ ទិ ឡាង ប្រិះ នែ»។ អ៊ែ ឡើ ប៉្រៃ ហឹ បឹ កុង ឈឹង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«មិញ ហន់ឌឹក ឆុង ហន់ចក់ កយែង ម៉ើ ទូង ហៃ ហន់ជឹ ហឹ ហន់ណាម ហកឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","បឹ ឡើ កុង ឈឹង ឡើ ឌឹក ឆុង ប្រយ ឡើ ចក់ កយែង ណគ ឡើ វីះ ជឹ ប្លះ កឌី បនឹះ ម៉ៃៗ។ លែក ដើ បូវ ហឡឹង ប្រយ ម៉ើ គូ ដើម ម៉ើ ព្រតឹះ ព្រនែ គ្រែដៃ ម៉ើ ម៉ាង រៀន៖ «ង៉ាយ ង៉ើ ខើយ អ៊ឺម តៃ កាន ឆង៉ាត់ ឞាល់ នែ!»។ ");
INSERT INTO brb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","គ្រែដៃ យែស៊ូ ឡើ ដក់ ឡឹះ អន់ណាវ ហឹ ពឹះ សមុត ឝ៉ាលីលែ។ មែ ក្លាង ស៊្រុក ទុត អើន ម៉ើ ដក់ ហឹ ណគ អ៊ែ ឡើ ពង់ហៀន មែ។ ");
INSERT INTO brb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","តគ់ គ្រែដៃ យែស៊ូ ឡើ ដក់ ឡឹះ ហឹ ងឺរ ឞិត ឞ៊ែត អ៊ែ ឡើ តៃ យ៉ាគ់ លែវី កួន យ៉ាគ់ អាល់ផាយ ឡើ ដ្រូម ពឹត កាន ប៊ឹង ហន់ណាម កាគ់ លៀន។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ច្រា ណគ រៀន៖ «ដក់ ហន់តូយ អៃ វ៉ៃ»។ អ៊ែ ឡើ ឌឹក តូយ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ចង់ ចា ហឹ ហន់ណាម យ៉ាគ់ លែវី។ ប៊ិច បនឹះ កាគ់ លៀន ដើម បនឹះ តៃ ស៊ីត ប៊ីត ទុត អើន ម៉ើ ដក់ មឹត ចង់ ចា ដ្រូម អរែង ប៊ឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ។ យ៉ាក់ បូវ មែ នែ ទុត អើន ម៉ើ ដក់ តូយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ប៊ិច មែ ណាយឃូ ពង់ហៀន ចឞាប់ តើម ប៊ឹង បូវ ផារីស៊ី ម៉ើ តៃ គ្រែដៃ យែស៊ូ ឡើ ចង់ អរែង ទឹង បូវ មែ អ៊ែ អ៊ែ ម៉ើ ម៉ាង ដើ លុកស៊ិក ណគ រៀន៖ «ប៉ិ ឡើ ត្រ ឡើ ចង់ ចា អរែង ប៊ឹង មែ ម៉ើ កាគ់ លៀន ដើម ប៊ឹង បនឹះ ប៊ិច ឞាប ប៉ាគ់ នែ?» ");
INSERT INTO brb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","គ្រែដៃ យែស៊ូ ឡើ ដុង ម៉ើ ម៉ាង ប៉ាគ់ អ៊ែ អ៊ែ ឡើ ត្រណើវ រៀន៖ «បនឹះ តៃ ឈិ ម៉ើ តងកាន អ៊ឺម ពែត វ៉ិះ ឌិវ មែ ម៉ើ ឈិ ម៉ើ តងកាន ពែត។ ណគ់ ដើ អៃ នែ អដក់ ដាំង អ៊ឺម បនឹះ ចាគ់ ទឹង ត្រ អដក់ ដាំង បនឹះ ប៊ិច ឞាប ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","តង៉ៃ ហង់អ៊ិន បូវ លុកស៊ិក យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ដើម បូវ មែ ផារីស៊ី ម៉ើ អឹត ចង់ ចា ។ អ៊ែ ប៊ិច បូវ ម៉ើ ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «លុកស៊ិក យ៉ាគ់ យ៉ូហាន ដើម លុកស៊ិក មែ ផារីស៊ី ម៉ើ អឹត ចង់ ចា ប៉ិ ឡើ ត្រ ដើ លុកស៊ិក ហៃ ម៉ើ អឹត អ៊ឺម ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «តង៉ៃ ម៉ើ ច្រណង់ ទឹង បឹ កឡា ចក់ ទ្រី ឡើ ណាគ់ ប៊ឹង អ៊ែ លំឃឺ ឞិ មែ ម៉ើ ដក់ ផូវ មន់អឹត ចង់ ចា?។ ទឹង បឹ កឡា ចក់ ទ្រី ឡើ ណាគ់ ប៊ឹង មែ ដូវ អ៊ឺម មន់អឹត ចង់ ចា។ ");
INSERT INTO brb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ហាក់ ញឹះ តគ់ លំប៊ឹះ តង៉ៃ មន់រ៉ាប់ បឹ កឡា ចក់ ទ្រី តើម ប៊ឹង មែ តង៉ៃ ហង់អ៊ិន ឡើយ មន់អឹត ចង់ ចា»។ ");
INSERT INTO brb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ឡឹះ ដើ មែ រៀន៖ «តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ចក់ ក្រដាគ់ ហន់ដើម មន់ឈិង កដាគ់ ប៊ឹង អាវ ក្រាគ់។ ប៉ាគ់ មន់បើម ពអ៊ែ ក្រដាគ់ ហន់ដើម លំក្រស៊ឹន អ៊ែ លំបើម អាំ អាវ ក្រាគ់ លំត្រសាក ជឺរ ពន់ឋើម អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ដើម តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ជុ តវែ ឈឹង ជែម ហន់ដើម ទឹង ក្រឌុង ហំបក ក្រាគ់។ ប៉ាគ់ មន់បើម ប៉ាគ់ អ៊ែ តវែ ទឹង ក្រឌុង អ៊ែ លំចឋះ តវែ អ៊ែ លែក លំលូះ ដើម ក្រឌុង ហំបក នែ លំប៉ិន យ៉ាវ។ ឡើ ត្រ មន់ជុ តវែ ហន់ដើម ទឹង ក្រឌុង ហន់ដើម ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","តង៉ៃ ហង់អ៊ិន តង៉ៃ ព្រឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ ឡាត់ មឺរ បូវ លុកស៊ិក ណគ ម៉ើ ដក់ ប៉ាគ់ កាត់ ហ្រកង់ ចិះ។ ");
INSERT INTO brb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","អ៊ែ បូវ មែ ផារីស៊ី ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «នែ ហន់ឝ្លាំង ប៉ិ ឡើ ត្រ បូវ លុកស៊ិក ហៃ ម៉ើ កដិច ហ្រកង់ ចិះ ទឹង តង៉ៃ ព្រឹង ប៉ាគ់ នែ? ឡើ យូច ចឞាប់ ម៉ើ បើម ប៉ាគ់ អ៊ែ!»។ ");
INSERT INTO brb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «វ៉ើ អាន អ៊ឺម ឡះ ទឹង ពឹម គ្រែដៃ កាន សឋិច ដាវីត? ប៊ឹង ឡើ ពងួត ដើម មែ ម៉ើ គូ អរែង ប៊ឹង ណគ ប៉ាគ់ ង៉ាយ ឡើ បើម? ");
INSERT INTO brb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ទឹង ប៉ាង យ៉ាគ់ អាបៀថា ឡើ បើម ណាយ បប៊ុះ ថួយ សឋិច ដាវីត ឡើ មឹត ហឹ កទូប កនូ គ្រែដៃ ឡើ ចា ណុំពាំង ម៉ើ បាក ថួយ ដើ គ្រែដៃ ដើម ឡើ អាំ ដើ បូវ ម៉ើ គូ អរែង ប៊ឹង ណគ ដិ។ តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ វ៉ិះ ឌិវ កឡា បប៊ុះ ថួយ ម៉ើ ប៊ិច ស៊ិត ចា ណុំពាំង អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ ដើ មែ រៀន៖ «គ្រែដៃ ឡើ ពឝ៉ើត តង៉ៃ ព្រឹង អាំ ដើ បនឹះ គ្រែដៃ ឡើ ពឝ៉ើត អ៊ឺម បនឹះ ញឹះ តៃ មន់ដូវ បើម អង់ង៉ាយ ទឹង តង៉ៃ ព្រឹង តាម ខណើយ វែ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ញ៉ន ដើ អ៊ែ ឡើយ កួន បនឹះ ឡើ កន់ដ្រាគ់ ពឺង តង៉ៃ ព្រឹង ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","គ្រែដៃ យែស៊ូ ឡើ ដក់ មឹត ហឹ រ៉ូង ពស៊ុំ ឡឹះ អន់ណាវ។ ទឹង អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ កុង ទី មូយ ច្រះ ");
INSERT INTO brb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","មែ ទឹង អ៊ែ ម៉ើ អន់ឆយ ឝ្លាំង គ្រែដៃ យែស៊ូ អំប លំពនៀម បឹ ហង់អ៊ែ ទឹង តង៉ៃ ព្រឹង បក់ មន់ប៊ិច ខ រ៉ាប់ អ្រយូច ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ បឹ ញ៉ច កុង ទី អ៊ែ រៀន៖ «មិញ ហន់ឌឹក ឆុង ទឹង កឌី បូវ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ពយ៉ិ ទឹង តង៉ៃ ព្រឹង ចឞាប់ ឡើ អាំ ងំបើម អន់ចាគ់ លឺ តៃ ចាគ់ ងំហវ៉ាត់ ពញិវ បនឹះ លឺ ងំកជែត»។ ហាក់ លែក ដើ មែ ម៉ើ គូ ហ្រហ៊ឹប ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឝ្លាំង ហឹ មែ ឡើ មាំ ដើម ឡើ ដុង ស្រៀវ អ្រអវ ញ៉ន ម៉ើ ប៊ិច ចនិះ ឝ៉ិះ ង៉ឹល។ អ៊ែ ឡើ ម៉ាង ហឹ បឹ ញ៉ច កុង ទី អ៊ែ រៀន៖ «មិញ ហំពយ៉ោះ ទី ហៃ!»។ បឹ ហង់អ៊ែ ឡើ ពយ៉ោះ ប្រយ ទី ណគ ឡើ នៀម ប៉ាគ់ អំប៊ី រីវ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","មែ ផារីស៊ី ប៊្លី ម៉ើ ញឺះ តើម ប៊ឹង រ៉ូង ពស៊ុំ ដ្រិះៗ ប្រយ ម៉ើ ដក់ ចជែ មម៉ាង ប៊ឹង បូវ មែ ម៉ើ មឹត តៃ សឋិច ហ៊ែរ៉ូត បក់ មន់ដាំង ទ្រូង កជែត គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ប៊្លី គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ហឹ សមុត ឝ៉ាលីលែ អរែង ដើ លុកស៊ិក ណគ។ បនឹះ ទុត អើន ម៉ើ ប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ដើម តើម ប៊ឹង ស្រុក យូដា ម៉ើ ដក់ តូយ ណគ ");
INSERT INTO brb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ដើម មែ មួង យែរូសាឡឹម ស្រុក អ៊ែដុម ដឹប មែ ម៉ើ គូ ក្លង ដណៃ យ៉ូរដាន់ តៃ តគ់ ដើម ស្រ៊ុក មែ ដិ អន់ដិ ឈុំ មួង ទីរ៉ុះ ដឹប មួង ស៊ីដូន។ ទុត អើន ម៉ើ ដក់ ដាំង ណគ ប៊ឹង ម៉ើ ដុង លែក ដើ កាន ចាគ់ ណគ ឡើ បើម។ ");
INSERT INTO brb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ អាំ មន់ជុ ឌូក អន់នួរ មូយ ដើ ណគ កឡាគ់ លំកដៀត ដើ បនឹះ ទុត អើន ម៉ើ គូ ឈុំ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ញ៉ន ឡើ ពនៀម បនឹះ ទុត អើន អ៊ែ លែក ដើ មែ ម៉ើ ឈិ ម៉ើ ខំ ដក់ ចឹម ចើម បក់ មន់ដូវ ពឹត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","បនឹះ អរ៉ាក់ ឡើ មឹត ប៊ឹង ម៉ើ តៃ គ្រែដៃ យែស៊ូ អ៊ែ អរ៉ាក់ ឡើ បើម អាំ បនឹះ អ៊ែ ម៉ើ កដាប ហំបះ ប៊ឹង ឈឹង ណគ ដើម ម៉ើ ហរ៉ាវ ថាំងៗ រៀន៖ «ហៃ ឡើយ ហកួន កឡ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ហាក់ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ក្រាគ់ ដើ អរ៉ាក់ ញ៉ង អាំ មន់ពហាយ ណគ អ៊ែ ឡើ មែ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឌឹក ទឹង ចន់ឌូ ឡើ កឡូវ ណគ់ មែ ង៉ាយ ណគ ឡើ ម៉ើត អាំ មន់តូយ ណគ អ៊ែ ម៉ើ ដក់ ប្រយ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ឡើ រ៉ើះ ជិត បារ រ៉ា ឡើ ជុ មែ បូវ ពចាំ កាន។ ឡើ រ៉ើះ មែ អាំ មន់គូ អរែង ប៊ឹង ណគ មន់ដក់ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ដើ បូវ ");
INSERT INTO brb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ដើម ឡើ អាំ មន់ប៊ិច អាតណាត ពន់ឌ្រុះ អរ៉ាក់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ម៉ាត់ មែ ជិត បារ រ៉ា នែ ឡើ ប៊ិច ស៊ីម៉ូន គ្រែដៃ យែស៊ូ ឡើ ជុ ម៉ាត់ ណគ ពែត្រុះ ដិ ");
INSERT INTO brb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","យ៉ាកុប អំប្រា អោះ ណគ យ៉ូហាន អំប្រា នែ កួន យ៉ាគ់ ស៊ែប៊ែឌែ គ្រែដៃ យែស៊ូ ឡើ ជុ អំប្រា នែ “បូនអើឝែ” ប៊ិច នឿណៃ រៀន បនឹះ ឞាល់ គ្រែ ហដៀរ ");
INSERT INTO brb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","អន់ឌ្រែ ភីលីប បារថូឡូមែ ម៉ាថាយ ថូម៉ះ យ៉ាកុប កួន យ៉ាគ់ អាល់ផាយ ថាឌែ ស៊ីម៉ូន ឡើ បូវ មែ កានែន ");
INSERT INTO brb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ដើម យូដះ អ៊ីសការីយ៉ុត បឹ ឡើ ខិច គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ជឹ វឹញ ហឹ ហន់ណាម ទឺ ប៊ិច បនឹះ ទុត អើន ម៉ើ ដក់ តមួត ឡឹះ ហឹ ណគ ញ៉ន អ៊ែ ឡើយ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ តើប ចង់ ចា អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","មែ ទឹង ក្រាន ណគ ហំប៊្រុះ ម៉ើ ដុង កាន អ៊ែ ម៉ើ រៀន ណគ ឡើ វិត ឡើយ អ៊ែ ម៉ើ ចន់ដ្រា ដក់ ចក់ គ្រែដៃ យែស៊ូ ជឹ តៀត ហឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","បូវ មែ ពង់ហៀន ចឞាប់ ណគ់ ម៉ើ ប៊ឹះ តើម ទិ មួង យែរូសាឡឹម ម៉ើ ម៉ាង រៀន៖ «ណគ នែ ប៊ែលស៊ែប៊ូល ណាយ អរ៉ាក់ ឡើ គូ ទឹង ណគ អ៊ែ ឡើ ដូវ ពន់ឌ្រុះ អរ៉ាក់ ប៉ាគ់ នែ ញ៉ន ដើ អាតណាត ណាយ អរ៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","គ្រែដៃ យែស៊ូ ឡើ កឡូវ មែ មន់ដក់ ហឹ ណគ អ៊ែ ឡើ ម៉ាង ព្រឌីវ ដើ មែ រៀន៖ «អរ៉ាក់ សតាំង ណាគ់ លំប៉ិន ឞិ លំពន់ឌ្រុះ ចាក់ ឡើ កឡឹ? ");
INSERT INTO brb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ប៉ាគ់ ទឹង ពធែត មូយ មន់ប៊ិច កាន ព្រដិង ព្រដឹង ពធែត ហង់អ៊ែ លំណាគ់ យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ប៉ាគ់ទឺ ឡើយ ប៉ាគ់ ទឹង ក្រាន មូយ មន់ប៊ិច កាន ព្រដិង ព្រដឹង ក្រាន ហង់អ៊ែ លំណាគ់ យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ប៉ាគ់ សតាំង លំព្រឆាន់ ដើ ចាក់ កឡឹ លំប៊ិច កាន ប្រណើម ទឹង ឡើ កឡឹ អ៊ែ លំណាគ់ យ៉ាវ ប៉ាគ់ទឺ លំប៉ាត់ ពណាត់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដូវ មឹត ចក់ រ៉ាះ អំបាះ ទឹង ហន់ណាម បឹ ឡើ ប្រិញ ថាំង។ តៃ កា មន់ចង ណគ អន់ដៃ អ៊ែ មន់ដូវ ចក់ រ៉ាះ អំបាះ ណគ ។ ");
INSERT INTO brb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ដាវ ម៉ាត់ ម៉ាត អៃ អន់ហាយ ដើ វែ រៀន លែក ដើ ឞាប បនឹះ ម៉ើ បើម ដើម លែក ដើ កាន ផម៉ាត ផម៉ា គ្រែដៃ លំតាក់ ថូត លែក អិះ ដូវ។ ");
INSERT INTO brb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ហាក់ ណគ់ មែ ង៉ាយ មន់ផម៉ាត ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ លំតាក់ ថូត អ៊ឺម ដើ មែ មែ អ៊ែ មន់ត្រ ថូត ឡូច អន់សច ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ញ៉ន ម៉ើ រៀន អរ៉ាក់ ឡើ គូ ទឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ហំប៊្រុះ ដើ អ៊ែ មែគ គ្រែដៃ យែស៊ូ ដើម មែ អោះ កឡ ណគ ម៉ើ ប៊ឹះ តគ់ អ៊ែ ម៉ើ ឆុង ហឹ អរ៉ះ អ៊ែ ម៉ើ ប៉្រៃ ដក់ កឡូវ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ទឹង អ៊ែ ប៊ិច បនឹះ ទុត អើន ម៉ើ ដ្រូម ឈុំ ណគ ម៉ើ ហាយ រៀន៖ «យ៉ាគ់ ណាយឃូ តគ់ ហន់ឝ្លាំង មែគ ហៃ ដើម មែ អោះ ហៃ ម៉ើ ដក់ ដាំង ហៃ តគ់ អរ៉ះ ឡើយ ម៉ើ គូ!»។ ");
INSERT INTO brb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «មែ ង៉ាយ ដឹះ មែគ អៃ? មែ ង៉ាយ ដឹះ អំម៉ោះ អោះ អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","គ្រែដៃ យែស៊ូ ឡើ ឝ្លាំង ហឹ បនឹះ ម៉ើ ដ្រូម ឈុំ ណគ ប៊្លី អ៊ែ ឡើ ម៉ាង រៀន៖ «មែ នែ ឡើយ មែគ អៃ ដើម អំម៉ោះ អោះ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ណគ់ មែ ង៉ាយ ម៉ើ បើម ត្រួយ តាម ប្រម៉ើត គ្រែដៃ មែ អ៊ែ ឡើយ ឡើ ត្រ មែគ អៃ ដើម អំម៉ោះ អោះ អៃ តៃ ម៉ាង កទ្រី តៃ ម៉ាង កឡ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","គ្រែដៃ យែស៊ូ ឡើ ពន់តើម ពង់ហៀន មែ ប៉ាសាសុន ប៊ឹង ពឹះ សមុត មូយ តង ឡឹះ អន់ណាវ។ បនឹះ ទុត អើន ឆឹន ហន់ឆឹន វ៉ិន អវែន ម៉ើ ដក់ តមួត ហឹ ណគ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ទឺះ ដ្រូម ទិ ឌូក លមូយ ដៀក ពឹះ លែក ដើ បូវ ម៉ើ គូ ប៊ឹង ពឹះ សមុត។ ");
INSERT INTO brb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ឡើ ពង់ហៀន មែ កាន ទុត អើន ដើ ប្រម៉ាង ព្រឌីវ ទឹង ឡើ ពង់ហៀន ឡើ ម៉ាង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«វន់ចង់ហៀង យ៉ឹ ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ប្រាក់ អង់គុង។ ");
INSERT INTO brb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ទឹង ប៉ះ ឡើ ប្រាក់ អង់គុង ណគ់ អន់នឺ ឡើ គ្លីះ ត្រ ប៉ុះ ទ្រូង អ៊ែ ជែម ម៉ើ ដក់ ក្លក់ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","អង់គុង អន់នឺ អន់ណាវ ឡើ គ្លីះ ទិ តម៉ ដដារ តៃ ហន់ដាគ់ ប៊ិច ប្រិះ អ៊ែ ឡើ ក្លគ់ ដ្រិះៗ យ៉ាក់ ប្រិះ ឡើ ហឌឺង។ ");
INSERT INTO brb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","តគ់ ម៉ាត់ តង៉ៃ ឡើ ឌឹក ដុ អ៊ែ ឡើ រ៉ូយ រ៉ាក លែក តាក់ យ៉ាក់ រៀះ ណគ ឡើ តូត ឈ្រុ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","អង់គុង អន់នឺ អន់ណាវ ឡើ គ្លីះ ប្លះ ប្រិះ ឡើ ប៊ិច អង់គុង ឆ្រឡា។ ឆ្រឡា អ៊ែ ឡើ ឌឹក ហួន ពុះលុំ អ៊ែ ចិះ ឡើ កអង់ ឡើ ប៊ិច អ៊ឺម ពឺរ ប៉្លៃ។ ");
INSERT INTO brb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","អង់គុង អន់នឺ ឡើ គ្លីះ ទឹង ប្រិះ អ៊ីន អង់គុង អ៊ែ ឡើ ហួន ឌឹក តមែវ រ៉ក អ៊ែ ហ្រកង់ អន់នឺ ឡើ ប៉្លៃ ដូវ ពែ ជិត ហ្រកង់ អន់នឺ ឡឹះ អន់ណាវ ដូវ ត្រូវ ជិត ហ្រកង់ អន់នឺ ឡឹះ អន់ណាវ ដូវ មូយ ក្លាំ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង អៃ នែ មន់ចនិះ ឃឹត យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ គូ ដិៗ តើម ប៊ឹង មែ ប៉ាសាសុន ណគ់ មែ ម៉ើ គូ ឈុំ ណគ ដឹប មែ លុកស៊ិក ជិត បារ រ៉ា ម៉ើ តង៉ា ណគ រៀន៖ «ឡា ហំហាយ ពឡាក់ ដើ ញ៉ា កាន អង់ង៉ាយ ហម៉ាង ព្រឌីវ អន់ឌូ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ណគ ឡើ ត្រណើវ រៀន៖ «គ្រែដៃ ឡើ អាំ វែ វន់ណោះ កាន ណគ ឡើ ពែក ប៉ាក់ ណាគ់ ឡើ វៀក ដក។ ណគ់ ដើ មែ គែង ម៉ើ ដុង កាន លែក នែ វ៉ិះ ដើ ប្រម៉ាង ចនីរ ");
INSERT INTO brb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","អ៊ែ ហម ម៉ើ ឝ្លាំង ណាគ់ តៃ ម៉ើ តៃ ហម ម៉ើ ដុង ណាគ់ តៃ ម៉ើ ណោះ ហឡាក់ កឡាគ់ មន់ពលិះ ចនិះ អ៊ែ គ្រែដៃ លំតាក់ ថូត ដើ មែ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «ប៉ាគ់ តៃ វន់ណោះ ហឡាក់ អ៊ឺម កាន ម៉ាង ព្រឌីវ អន់នែ ពយ៉ិ អន់ណាវ វន់ណោះ ហឡាក់ លែក ដើ កាន ម៉ាង ព្រឌីវ អង់គែងៗ! ");
INSERT INTO brb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","បឹ កឡា ឡើ ប្រាក់ អង់គុង អ៊ែ ឡើ ប្រាក់ ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","បនឹះ អន់នឺ ម៉ើ បើម ប៉ាគ់ ទ្រូង អង់គុង ឡើ គ្លីះ ប៊ឹង ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ អរ៉ាក់ សតាំង ឡើ ដក់ សុក ប្រម៉ាង គ្រែដៃ ឡើ ប៊ិច ទឹង ចនិះ មែ ដ្រិះៗ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","បនឹះ អន់នឺ ម៉ើ បើម ប៉ាគ់ អង់គុង ឡើ គ្លីះ ទឹង តម៉ ដដារ ហំប៊្រុះ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ម៉ើ ឡាប់ ប្រយ ដើ ចនិះ ញឹម ក្លើម ក្លាក ");
INSERT INTO brb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ហាក់ ម៉ើ ចាប់ វ៉ិះ ឞិត ឞ៊ែត តគ់ ម៉ើ ប៊ិច កាន ធុក ញ៉ាក លឺ ប៊ិច បូវ ម៉ើ តំឞាប ញ៉ន ដើ ប្រម៉ាង គ្រែដៃ អ៊ែ ម៉ើ តាក់ ដ្រិះៗ ប្រយ កាន ចាប់ មឹង យ៉ាក់ រៀះ ឡើ តូត ឈ្រុ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","បនឹះ អន់នឺ ម៉ើ បើម ប៉ាគ់ អង់គុង ឡើ គ្លីះ ប៊ឹង ប្រិះ ឡើ ប៊ិច ឆ្រឡា មែ អ៊ែ ម៉ើ ដុង ប៉ាគ់ទឺ ប្រម៉ាង គ្រែដៃ ");
INSERT INTO brb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ហាក់ ម៉ើ វន់វ៉ាយ ដើ កាន ញិវ កើត ទិ ឡាង ប្រិះ ម៉ើ បូត ងុញ ប្រនិច ចាំ អើន ដើម ម៉ើ ងុញ កាន អង់គែងៗ ទុត អើន តូវ ឡើ ប៊ិង ទឹង ចនិះ មែ កាន លែក នែ ឡើ ពុះលុំ ប្រម៉ាង គ្រែដៃ អ៊ែ ឡើ កអង់ ឡើ ពឺរ ប៉្លៃ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","អ៊ែ ណគ់ មែ ម៉ើ បើម ប៉ាគ់ អង់គុង ឡើ គ្លីះ ទឹង ប្រិះ អ៊ីន មែ អ៊ែ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ដើម ម៉ើ ចាប់ ប្រយ ម៉ើ ពឝ៉ើត ពឺរ ប៉្លៃ មែ អន់នឺ ម៉ើ ពឝ៉ើត ពែ ជិត មែ អន់នឺ ម៉ើ ពឝ៉ើត ត្រូវ ជិត មែ អន់នឺ អន់ណាវ ម៉ើ ពឝ៉ើត មូយ ក្លាំ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ឡឹះ រៀន៖ «ប៊ិច អ៊ឺម មន់ដក់ ចក់ តកៀង មន់ទ្រូប គ្លឹប ដើ រែវ លឺ មន់ជុ តៃ ក្រូម ឝ្រែ។ ម៉ើ ដក់ ចក់ តកៀង ម៉ើ ជុ ទិ ឈ្រុង ឈ្រូង។ ");
INSERT INTO brb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","លែក ដើ កាន ឡើ វៀក ដក បក់ គ្រែដៃ លំពណោះ អ៊ែ លែក ដើ កាន ឡើ អំម៉គ់ បក់ ណគ លំពដៃ ដើ បនឹះ មន់តៃ ហឡាក់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង អៃ នែ មន់ចនិះ ឃឹត យ៉ឹ»!។ ");
INSERT INTO brb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ ដើ មែ រៀន៖ «វន់ឃឹត ហឹ ប្រម៉ាង ណគ់ វែ វ៉ើ ចង់ហៀង អាំ ខាក់ៗ។ គ្រែដៃ លំវ៉ាវ អាំ ដើ វែ តាម ប៉ាគ់ វែ វ៉ើ វ៉ាវ ទឺ ហ៊ែង ហម អ៊ែ ឡឹះ អន់ណាវ លំអាំ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","យ៉ាក់ ណគ់ មែ ង៉ាយ ម៉ើ ប៊ិច ឡើយ គ្រែដៃ លំអាំ ទឺម ឡឹះ អន់ណាវ អ៊ែ ណគ់ មែ ង៉ាយ តៃ ម៉ើ ប៊ិច គ្រែដៃ លំចក់ ពលែក ណគ់ អង់ង៉ាយៗ ម៉ើ ប៊ិច»។ ");
INSERT INTO brb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","គ្រែដៃ យែស៊ូ ឡើ ហាយ អន់ណាវ រៀន៖ «កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ប៉ាគ់ នែ ឡើ ព្រឌីវ៖ ប៊ិច បឹ មូយ រ៉ា ឡើ ប្រាក់ អង់គុង ទឹង មឺរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","បឹ ហង់អ៊ែ ឡើ ហង់ង៉ាន់ ត្រំ អំប៊ឹ ឡើ រ៉ៃ ត្រំ ងឹប ហមយ៉ះ ប៉ាគ់ អ៊ែ អង់គុង ណគ ណាគ់ ឡើ កនៀង ក្លគ់ សំយ៉ះ តៃ ឡើ ណោះ អ៊ឺម ណោះ អង់ង៉ាយ ឡើ បើម អង់ហួន អង់គុង ");
INSERT INTO brb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ប្រិះ កឡឹ ឡើ បើម អំប៉្លៃ អន់នួរៗ ឡើ កនៀង ប៊្លី អ៊ែ ឡើ តមែវ តគ់ អន់ទុន ឡើ ម៉ក់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","តគ់ ឡើ ឌុំ ឡើយ បឹ ហង់អ៊ែ ឡើ ចក់ កន់ឋៀវ ដ្រិះៗ ឡើ ដក់ កៀវ ប្រយ យ៉ាក់ ឡើ ប៊ឹះ ញ៉ាម កនៀវ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ ព្រឌីវ ប៊ឹង ង៉ាយ? ងន់ចក់ កាន ព្រឌីវ អង់ង៉ាយ អ៊ែ លំត្រ ប៊ឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់? ");
INSERT INTO brb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ បើម ប៉ាគ់ អង់គុង ក្លិត គ្លែត ជឺរ អង់គុង អង់គែងៗ លែក អិះ។ ប៊ឹង ម៉ើ ប្រាក់ ពឺង ប្រិះ អង់គុង អ៊ែ ហៀយៗ។ ");
INSERT INTO brb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","តគ់ ម៉ើ ប្រាក់ លែវ ឡើយ អង់គុង អ៊ែ ឡើ ហួន ឌឹក ទិះ ជឺរ ដណាំ អង់គែងៗ ដើម ឡើ ចន់ដះ ឝឹង ឝៀរ ណគ ដអ៊ី អ៊ែ ជែម ប៊្រែម ម៉ើ ដក់ ឆ្រុក បើម កសូម ប្រយ ប៊ឹង សុំនុំ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ប្រម៉ាង គ្រែដៃ ដើ ប៉ាសាសុន ម៉ាត់តូវ ដើ កាន ព្រឌីវ ប៉ាគ់ នែ ទុត អើន តាម ប៉ាគ់ មែ ម៉ើ បក់ ចង់ហៀង។ ");
INSERT INTO brb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ឡើ ពហាយ ដើ មែ ម៉ាត់តូវ ដើ កាន ព្រឌីវ អ៊ែ តគ់ ឌិវ មែ លុកស៊ិក ណគ កឡឹ ឡើ ហាយ ពឡាក់ ដើ មែ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","អំប៊ឹ តង៉ៃ អន់ទឺ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «ញ៉ះ ញន់ក្លង សមុត តៃ តគ់»។ ");
INSERT INTO brb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","អ៊ែ មែ លុកស៊ិក ម៉ើ វីះ តើម ប៊ឹង មែ ប៉ាសាសុន ម៉ើ ទឺះ ទិ ឌូក គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ពង់ហៀន ម៉ើ ពដក់ ប្រយ ឌូក ដើម ប៊ិច ឌូក អង់គែង ដិ ម៉ើ ដក់ អរែង ប៊ឹង មែ។ ");
INSERT INTO brb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ហំប៊្រុះ ដើ អ៊ែ ឡើ ប៊ិច កយឺវ ទិះ ឡើ ពឹក ទុត ថាំង ដាក ឡើ ផង មឹត ទឹង ឌូក ឞ៊ែត លំប៊ិង។ ");
INSERT INTO brb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ណគ់ ដើ គ្រែដៃ យែស៊ូ ឡើ ហង់ង៉ាន់ កើវ ដើ កណើវ ទូះ តៀក ឡើយ ទិ កន់សៃ ឌូក។ មែ លុកស៊ិក ម៉ើ ពរ៉ៃ ណគ រៀន៖ «អើយ ណាយឃូ ងន់គែត ឡើយ ង៉ាយ នែ! ហលវ៉ឹន អ៊ឺម ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","អ៊ែ ឡើ រ៉ៃ ឡើ ម៉ាង ក្រាគ់ ដើ កយឺវ ដើម ឡើ ប៉្រៃ ដាក សមុត រៀន៖ «ហំព្រឹង ហ្រហៀង ហំមិញ»។ ហំប៊្រុះ ដើ អ៊ែ កយឺវ ឡើ ប៉ាត់ ដាក ឡើ ព្រឹង អន់ជឺច ប្រយ ហ្រហៀង។ ");
INSERT INTO brb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ឌូង ញឹះ ឞាល់ នែ? វ៉ើ ចាប់ មឹង អំម៉ឹះ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","មែ លុកស៊ិក ណគ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «មែ ង៉ាយ ឋូវ យ៉ាគ់ អន់នែ ទុត កយឺវ ដើម ដាក សមុត ណាគ់ ម៉ើ ចាប់ ម៉ាង ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ប៊ឹះ ពឹះ សមុត តៃ តគ់ ឡើយ ហឹ ស្រុក មែ ឝែរ៉ាស៊ីន។ ");
INSERT INTO brb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ទឺះ តើម ប៊ឹង ឌូក ប៊ិច កឡ មូយ រ៉ា អរ៉ាក់ មឹត ទឹង ណគ ឡើ ញឺះ តើម ប៊ឹង ត្រម ច្រាង ចនុ កយ៉ក់ ឡើ ដក់ ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","កឡ នែ ឡើ គូ ហឹ ត្រម ច្រាង ចនុ កយ៉ក់ មែ ង៉ាយ យ៉ាវ មន់ដូវ រ៉ាប់ ចង ណគ សំយ៉ះ ម៉ើ ចង ណគ ដើ ស៊ីក ណាគ់ តៃ ដូវ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","យ៉ាក់ អើន តង ឡើយ ម៉ើ ខើយ រ៉ាប់ ចង ណគ ដើ ស៊ីក ដើម ដើ កណោះ ឡើ តរឹត ស៊ីក ណាគ់ តាត់ ដើម ឡើ បប៊ឹម បបឹត កណោះ ហិច អំប្រិច តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ប្រិញ ដូវ ពញ៉ម ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ឡើ គូ ទឹង ត្រម ច្រាង ចនុ កយ៉ក់ ដើម ទឹង ចន់ឌូ បរ អ៊ែ តាំង ឡើ ហរ៉ាវ តង៉ៃ ប៉ាគ់ មាំង ដើម ឡើ ចក់ តម៉ ឡើ អ៊ុរ ចាក់ ដៃ ឡើ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ហំប៊្រុះ ឡើ តៃ គ្រែដៃ យែស៊ូ តើម ប៊ឹង ចង៉ាយៗ ឡើ ដក់ យ៉ាវ កដាប ហំបះ ប្រយ តគ់ ងឺរ ណគ ");
INSERT INTO brb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","អ៊ែ ឡើ ហរ៉ាវ ម៉ាង ថាំងៗ រៀន៖ «ឡា យែស៊ូ ហកួន កឡ គ្រែដៃ ទិះ ឈ្រូង អើយ ហដក់ បើម ង៉ាយ ហឹ អៃ? អៃ អឡា ឡូម ហឹ ហៃ ប៊ឹង ងឺរ គ្រែដៃ ឡា យ៉ាគ់ ញ៉ង ហតំប៉ាប តំពុន អ៊ឺម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ឡើ ម៉ាង ប៉ាគ អ៊ែ ញ៉ន គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «មិញ អរ៉ាក់ ហំវីះ តើម ប៊ឹង បឹ អន់នែ!»។ ");
INSERT INTO brb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","គ្រែដៃ យែស៊ូ ឡើ តង៉ា រៀន៖ «អង់ង៉ាយ ម៉ាត់ ហៃ?» ឡើ ត្រណើវ រៀន៖ «ម៉ាត់ អៃ នែ កង តហាន យ៉ាក់ បូវ ញ៉ា ទុត អើន»។ ");
INSERT INTO brb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ឡើ ឡា ឡូម ដឌែ ហឹ គ្រែដៃ យែស៊ូ ញ៉ង អាំ លំតវីះ មែ តើម ប៊ឹង ស្រុក ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","បអើយ បរ អ៊ែ ឡើ ប៊ិច ជុរ មូយ បូវ ទុត អើន ម៉ើ ចជឹក ទឹង ចន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","អ៊ែ បូវ អរ៉ាក់ ម៉ើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា យ៉ាគ់ អើយ ហង់អាំ ញ៉ា ញំមឹត ហឹ ជុរ តគ់!»។ ");
INSERT INTO brb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","គ្រែដៃ យែស៊ូ ឡើ អាំ ប៉ាគ់ទឺ។ អ៊ែ បូវ អរ៉ាក់ ម៉ើ វីះ តើម ប៊ឹង បឹ ហង់អ៊ែ ម៉ើ មឹត ហឹ ជុរ បូវ ជុរ អ៊ែ បារ ហលិក អំប៉ម អ្យាង ម៉ើ អ្រយ៉ាវ តៃ ក្រជែង សាង ចន់ឌូ គ្លីះ ទិ ដាក សមុត ម៉ើ ឡូប គែត លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","បូវ មែ ម៉ើ ពែក ជុរ ម៉ើ ជឹ អ្រយ៉ាវ ពហាយ ដើ មែ ហឹ មួង ដើម ដើ មែ ម៉ើ គូ ហឹ មឺរ ញ៉ក បក តូង។ ប៊្លី អ៊ែ មែ ទឹង អ៊ែ ម៉ើ ដក់ ឝ្លាំង កាន ឡើ កើត អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","តគ់ ម៉ើ ប៊ឹះ ហឹ គ្រែដៃ យែស៊ូ ម៉ើ តៃ បឹ បូវ អរ៉ាក់ មឹត ពន់ឋើម អ៊ែ ឡើ ដ្រូម ដឹប ឡើ ណោះ ត្រទ្រូប ហហក ឡើយ ដើម ឡើ ណោះ ឌូរ ដះ ដិ អ៊ែ លែក ដើ មែ តូវ ម៉ើ អៀល ឌូង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ណគ់ មែ ម៉ើ តៃ កាន ឡើ កើត ដើ បឹ អរ៉ាក់ មឹត ពន់ឋើម ដើម កាន ឡើ កើត ដើ បូវ ជុរ ម៉ើ ពប៉ច ដើ បូវ។ ");
INSERT INTO brb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","អ៊ែ មែ ទឹង ស្រុក ហង់អ៊ែ ម៉ើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ អាំ លំវីះ តើម ប៊ឹង ប៊្រី ដាក មែ។ ");
INSERT INTO brb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ទឹង ប៉ះ គ្រែដៃ យែស៊ូ ឡើ ទឺះ ឈិះ ឌូក បឹ អរ៉ាក់ មឹត ពន់ឋើម អ៊ែ ឡើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ លំជឹ តូយ គូ អរែង ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","គ្រែដៃ យែស៊ូ ឡើ អាំ អ៊ឺម តូយ តគ់ ខាក់ៗ ឡើ ម៉ាង ដើ ណគ រៀន៖ «មិញ ហន់ជឹ ដាំង ហន់ណាម ក្រាន ដើម បូវ ប៊ែង ហៃ កឡឹ អន់ណាវ អ៊ែ ហំប៉ច ដើ មែ លែក ដើ កាន គ្រែដៃ កន់ដ្រាគ់ ឡើ បើម អន់នៀម ហៃ ដើម ឡើ ស្រុស្រៀត ហៃ ប៉ាគ់ ង៉ាយ ហតៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","បឹ ហង់អ៊ែ ឡើ ជឹ ពហាយ ដើ មែ ទឹង ស្រុក ឌែកាប៉ូល តូច ដើ កាន ង៉ាន គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម ណគ។ លែក ដើ មែ ម៉ើ ដុង តូវ ម៉ើ បើម ញ៉ម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឈិះ ឌូក ឡើ ជឹ ក្លង តៃ តគ់។ តគ់ ឡើ ប៊ឹះ ទឹង ណាគ់ ឡើ គូ ប៊ឹង ពឹះ សមុត បនឹះ ទុត អើន ម៉ើ ដក់ តមួត ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ទឹង អ៊ែ ប៊ិច កឡា ឝ្លាំង កាន យូច ត្រ ទឹង រ៉ូង ពស៊ុំ មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ យ៉ៃរ៉ុះ ឡើ ប៊ឹះ។ ហំប៊្រុះ ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ ដក់ កដាប ហំបះ ប្រយ ចុ ឈឹង ណគ ");
INSERT INTO brb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","អ៊ែ ឡើ ឡា ឡូម ទុត ខាក់ ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «កួន កទ្រី អៃ ឡើ ឈិ ម៉ៃ ដៀប លំតាត់ សើម ឡើយ។ ឡា យ៉ាគ់ អ អើយ ហន់ដក់ ជុ ទី ប៊ឹង ណគ អុះ អាំ លំនៀម អ៊ែ លំញិវ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","គ្រែដៃ យែស៊ូ ឡើ ជឹ តូយ យ៉ាគ់ យ៉ៃរ៉ុះ។ អ៊ែ បនឹះ ទុត អើន ម៉ើ ដក់ តូយ គ្រែដៃ យែស៊ូ តូវ ម៉ើ ព្រដៀត ឈុំ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ប៊ឹង អ៊ែ ប៊ិច កទ្រី មូយ រ៉ា ឡើ ពន់ឆិច ញឹះ ជិត បារ កម៉ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ឡើ ដក់ ដាំង ពែត ទុត អើន ឡើយ ហាក់ ប៊ឹង មែ ពែត ម៉ើ ពួ ណគ ហ៊ែង ម៉ើ បើម អន់ឈិ ចាំ ម៉ៃ ណាង ឡើ ជែរ មែ ឡើ កលីះ រ៉ាះ អំបាះ ញឹះ ឡើ លែក ហាក់ ឆនិ ណគ ណាគ់ តៃ ឡើ ហយ អង់ហយ អ៊ឺម សរ៉ើម ឡើ ឈិ ចាំ ម៉ៃៗ។ ");
INSERT INTO brb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ណាង ឡើ ដុង ម៉ើ ចជែ កាន គ្រែដៃ យែស៊ូ អ៊ែ ឡើ មឹត ប្រយ ប្លះ កឌី បូវ ឡើ ដក់ តៃ ត្រិច គ្រែដៃ យែស៊ូ ឡើ ពឹត ប៊ឹង អាវ ");
INSERT INTO brb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ញ៉ន ឡើ ឃឹត ទឹង ចនិះ រៀន៖ «ប៉ាគ់ អន់ដូវ ពឹត វ៉ិះ ឌិវ អាវ ណគ អន់នៀម ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ហំប៊្រុះ ដើ អ៊ែ កអវ ឡើ អាត់ ប្រយ ផាម ណគ អ៊ែ ឡើ ដុង ទឹង ចាក់ ណគ ឡើ នៀម តើម ប៊ឹង ឆនិ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ណោះ ប្រយ កាន ឆង៉ាត់ ឡើ ញឺះ តើម ប៊ឹង ណគ។ អ៊ែ ឡើ ហវីវ ឝ្លាំង ហឹ មែ ប៉ាសាសុន ឡើ តង៉ា រៀន៖ «មែ ង៉ាយ ហង់អ៊ិន ម៉ើ ពឹត អាវ អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","បូវ លុកស៊ិក ណគ ម៉ើ ត្រណើវ រៀន៖ «ណាយឃូ ហតៃ ឡើយ បនឹះ តូវ ម៉ើ ព្រដៀត ឈុំ ហៃ ឞាល់ នែ ពយ៉ិ ឡើ ត្រ ហតង៉ា រៀន “មែ ង៉ាយ ម៉ើ ពឹត អៃ?”»។ ");
INSERT INTO brb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឝ្លាំង ឈុំ អ៊ែ បក់ លំតៃ មែ ង៉ាយ ម៉ើ ពឹត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","កទ្រី អ៊ែ ឡើ ឌូង តូវ ឡើ សសឹរ ចាក់ យ៉ាក់ ឡើ ណោះ កាន ឡើ កើត ទឹង ចាក់ ណគ។ អ៊ែ ឡើ ដក់ កដាប ហំបះ ចុ ឈឹង គ្រែដៃ យែស៊ូ ឡើ ហាយ ក្រម៉ាត កាន លែក អ៊ែ ដើ ណគ ញឹះ តៃ ឡើ អំម៉គ់ កដក។ ");
INSERT INTO brb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណាង រៀន៖ «ណាង អើយ យ៉ាក់ ហមឹង អៃ អ៊ែ ហនៀម ហន់ជឹ ញឹម សាំង ក្លាំង រិញ ដើម ហន់នៀម តើម ប៊ឹង ឆនិ អន់តុ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","គ្រែដៃ យែស៊ូ ទឹង ណាគ់ ឡើ ចជែ ប៊ិច បនឹះ ម៉ើ ប៊ឹះ តើម ប៊ឹង ហន់ណាម យ៉ាគ់ យ៉ៃរ៉ុះ ឡើ កឡា ឝ្លាំង កាន យូច ត្រ ទឹង រ៉ូង ពស៊ុំ ម៉ើ ពហាយ រៀន៖ «កួន កទ្រី ហៃ ឡើ តាត់ សើម ឡើយ។ ញ៉ង ហច្រា ពខើក យ៉ាវ យ៉ាគ់ ណាយឃូ អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","គ្រែដៃ យែស៊ូ ឡើ ដុង ទូង ប្រម៉ាង មែ ម៉ើ ហាយ អ៊ែ អ៊ែ ឡើ ហាយ ដើ យ៉ាគ់ យ៉ៃរ៉ុះ រៀន៖ «ញ៉ង ហឌូង អ៊ឺម ឝ៉ាន់ ហំចាប់ មឹង អៃ ឆិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ឡើ អាំ អ៊ឺម មែ គែង មន់ដក់ ប៊ឹង ណគ ឡើ អាំ វ៉ិះ ឌិវ យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ាកុប ដើម យ៉ូហាន អោះ យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ហំប៊្រុះ ម៉ើ ប៊ឹះ ហន់ណាម យ៉ាគ់ យ៉ៃរ៉ុះ គ្រែដៃ យែស៊ូ ឡើ តៃ បនឹះ ចម៉ាវ ម៉ើ ញឺម ហរ៉ាវ កឡះ សគ្រែក សគ្រួះ។ ");
INSERT INTO brb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","គ្រែដៃ យែស៊ូ ឡើ មឹត ហឹ ហន់ណាម អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ញឺម ស៊្រែក សគ្រែក សគ្រួះ ប៉ាគ់ នែ? ណាង នែ ឡើ គែត អ៊ឺម វ៉ិះ ឡើ ហង់ង៉ាន់ តៀក »។ ");
INSERT INTO brb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ម៉ើ ចអាវ តវ៉ក តវ៉ិច ណគ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តវីះ លែក ដើ មែ ញឺះ ហឹ អរ៉ះ ប៊្លី អ៊ែ ឡើ ច្រា ឌិវ មែគ បើគ ណាង ដើម លុកស៊ិក ណគ ពែ រ៉ា មឹត ហឹ កណី ណាង។ ");
INSERT INTO brb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","គ្រែដៃ យែស៊ូ ឡើ រ៉ាប់ ណាង ប៊ឹង ទី ឡើ ម៉ាង រៀន៖ «តាលីថាគូម!» (ប៊ិច នឿណៃ រៀន “អើយ ណាង អប៉្រៃ ហៃ ហន់ឌឹក ឆុង ហំមិញ!”)។ ");
INSERT INTO brb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ណាំង ឡើ គែត អ៊ែ ឡើ ឌឹក ឆុង ដក់ ប្រយ ទឹង អ៊ែ អញុ ណគ ជិត បារ កម៉ ឡើយ។ ហំប៊្រុះ ដើ អ៊ែ លែក ដើ មែ ម៉ើ គូ ប៊ឹង អ៊ែ តូវ ម៉ើ បើម ញ៉ម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","គ្រែដៃ យែស៊ូ ឡើ កំប៊ែត ទុត ខាក់ អាំ អ៊ឺម មែ មន់ប៉ច កាន នែ ញ៉ង អាំ មែ ង៉ាយ មន់ណោះ។ ប៊្លី អ៊ែ ឡើ ប៉្រៃ មែ រៀន៖ «វន់អាំ ចណង់ ចណា ដើ ណាង នែ លំចង់ ចា»។ ");
INSERT INTO brb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ជឹ វឹញ ហឹ ស៊្រុក ណគ កឡឹ បូវ លុកស៊ិក ណគ ម៉ើ ជឹ តូយ ប៉ាគ់ទឺ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","តគ់ តង៉ៃ ព្រឹង គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន មែ ក្លាង ស៊្រុក ទឹង រ៉ូង ពស៊ុំ។ ប៊ិច បនឹះ ទុត អើន ណគ់ ម៉ើ ចង់ហៀង ណគ តូវ ម៉ើ បើម ញ៉ម អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «តើម ប៊ឹង ង៉ាយ ឋូវ ឡើ ហៀន កាន លែក នែ? ប៉ាគ់ ង៉ាយ ហ្រឡិច ហ្រឡាង ណគ់ ណគ ឡើ ដូវ អ៊ែ? តើម ប៊ឹង ង៉ាយ ឋូវ ឡើ ប៊ិច អាតណាត បើម កាន ឆង៉ាត់ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ពយ៉ិ បឹ អន់នែ ត្រ អ៊ឺម ឞិ ឡើ ខើយ បើម ហន់ណាម ដើ បូវ កួន ណាង ម៉ារី អ៊ូគ យ៉ាកុប យ៉ូស៊ែ យូដះ ដើម ស៊ីម៉ូន ហវ៉ៃ? អោះ កទ្រី ណគ ណាគ់ ម៉ើ គូ ទឹង ស៊្រុក ង៉ាយ នែ ទឺ!»។ អ៊ែ ឡើយ ម៉ើ ឌី អ៊ឺម ចាប់ ម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «មែ ហឹ គែង លែក រ៉ា ម៉ើ ខរ៉ុប បឹ កឡា ឈូន ប្រម៉ាង គ្រែដៃ វ៉ិះ ទឹង ស៊្រុក ប្រិះ ព្រឝ៉ើត យូ ដើម ទឹង ហន់ណាម ក្រាន ណគ កឡឹ ម៉ើ ឌី អ៊ឺម ខរ៉ុប ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ទឹង ស៊្រុក ឡើ កឡឹ ញ៉ន តៃ ម៉ើ ចាប់ ណគ អ៊ែ ឡើ ដូវ អ៊ឺម បើម កាន ឆង៉ាត់ វ៉ិះ ឌិវ ឡើ ជុ ទី ពនៀម មែ ម៉ើ ឈិ បារ ពែ រ៉ា អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","គ្រែដៃ យែស៊ូ ឡើ បើម ទុត ញ៉ន តៃ ម៉ើ ចាប់ មឹង ប៉ាគ់ នែ។ ប៊្លី អ៊ែ ឡើ ដក់ ស៊្រុក មូយ ដាំង ស៊្រុក មូយ ឈុំ អ៊ែ ដើម ឡើ ពង់ហៀន មែ។ ");
INSERT INTO brb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កឡូវ លុកស៊ិក ណគ លែក ជិត បារ រ៉ា មន់ដក់ តមួត តគ់ ណគ។ ប៊្លី អ៊ែ ឡើ ប៉្រៃ ដក់ បារ រ៉ាៗ ដើម ឡើ អាំ អាតណាត ពន់ឌ្រុះ អរ៉ាក់ ដិ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ឡើ ថាន់ មែ រៀន៖ «ប៊ឹង វន់ដក់ ញ៉ង វន់តៀត អង់ង៉ាយ អ៊ឺម យ៉ឹ សំយ៉ះ ចណង់ ចណា ក្រឌុង ប្រណាក់ លៀន ប្រាក់ ញ៉ង វន់ជុ ប៊ឹង ចាក់។ វន់តៀត វ៉ិះ ឌិវ តងអន់ណើង ");
INSERT INTO brb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","វន់ទ្រូប ឌិវ កើប ញ៉ង វន់ហក អ៊ឺម អាវ បារ ឡើប»។ ");
INSERT INTO brb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","អ៊ែ ឡើ ថាន់ ឡឹះ រៀន៖ «ប៉ាគ់ មែ ង៉ាយ មន់ច្រា វែ មឹត ទឹង ហន់ណាម មែ វន់គូ ប៊ឹង ហន់ណាម ហង់អិះ ឡើយ ឋា ដើ វន់វីះ តើម ប៊ឹង ស៊្រុក ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ប៉ាគ់ ស៊្រុក មែ ង៉ាយ តៃ មន់ឌី ឡាប់ ឡង ដើម តៃ មន់ឌី ចង់ហៀង វែ វន់វីះ តើម ប៊ឹង អ៊ែ វន់ក្រប៉ូះ ភុក ភុយ ប៊ឹង ឈឹង វែ បក់ មន់ណោះ គ្រែដៃ លំពថូត មែ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","អ៊ែ បូវ លុកស៊ិក ម៉ើ វីះ តើម ប៊ឹង អ៊ែ ម៉ើ ដក់ ពហាយ ដើ បនឹះ អាំ មន់ពលិះ ចនិះ។ ");
INSERT INTO brb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ដើម ម៉ើ ពន់ឌ្រុះ អរ៉ាក់ ទុត អើន តើម ប៊ឹង បនឹះ ដើម ម៉ើ ឡច ពុក អូលីវ ពឺង មែ ម៉ើ ឈិ ទុត អើន អ៊ែ ម៉ើ នៀម។ ");
INSERT INTO brb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","សឋិច ហ៊ែរ៉ូត ឡើ ដុង ម៉ើ ប៉ច កាន គ្រែដៃ យែស៊ូ យ៉ាក់ ម៉ាត់ ណគ ឡើ លឺសា។ មែ អន់នឺ ម៉ើ រៀន យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ញិវ ឡឹះ។ ញ៉ន ដើ អ៊ែ ឡើយ ឡើ ដូវ បើម កាន ឆង៉ាត់ ប៉ាគ់ នែ។ ");
INSERT INTO brb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ណគ់ មែ អន់នឺ ម៉ើ រៀន យ៉ាគ់ អ៊ែលីយ៉ា។ មែ អន់នឺ អន់ណាវ ម៉ើ រៀន ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ តើម ប៊ឹង បូវ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ទឹង ឡៃ មាំង។ ");
INSERT INTO brb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","តគ់ សឋិច ហ៊ែរ៉ូត ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ ម៉ាង រៀន៖ «បឹ ហង់អ៊ិន យ៉ាគ់ យ៉ូហាន ម៉ាត ឡើយ ណគ់ អៃ អប៉្រៃ ម៉ើ ឆាល់ ដង់។ តគ់ ណិះៗ ឡើ ញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","កាន នែ ប៉ាគ់ នែ ឡើ កើត។ សឋិច ហ៊ែរ៉ូត ឡើ សុក ណាង ហ៊ែរ៉ូដៀះ កម៉ាន់ ណគ ឡើ ត្រ ទ្រី អោះ ណគ យ៉ាគ់ ភីលីប។ អ៊ែ យ៉ាគ់ យ៉ូហាន ឡើ គឹះ ពន់ដូះ សឋិច រៀន៖ «ត្រ អ៊ឺម ហណោះ ហសុក ទ្រី អោះ ហៃ ប៉ាគ់ នែ»។ ញ៉ន ណាង ហ៊ែរ៉ូដៀះ អ៊ែ ឡើយ យ៉ាគ់ សឋិច ឡើ ប៉្រៃ មែ ម៉ើ ដក់ រ៉ាប់ ចង យ៉ាគ់ យ៉ូហាន ក្រាន់ ទឹង ឃុក។ ");
INSERT INTO brb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ណាង ហ៊ែរ៉ូដៀះ នែ ឡើ មាំ ទុត ខាក់ ដើ យ៉ាគ់ យ៉ូហាន អ៊ែ ឡើ ប្រអៀង កជែត ពញ៉ង ឡើ ដូវ អ៊ឺម ");
INSERT INTO brb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ញ៉ន សឋិច ឡើ អៀល បឹះ យ៉ាគ់ យ៉ូហាន ឡើ ណោះ រៀន ឡើ បនឹះ ទឹង ត្រ ដើម ឡើ ចាគ់ ស៊ីត អ៊ែ ឡើ លវាំង។ ប៊ឹង ឡើ ចង់ហៀង យ៉ាគ់ យ៉ូហាន ឡើ អ៊ឹង ស៊្រឺ ណោះ ប៉ាគ់ ង៉ាយ លំឃឹត ដើ ប្រម៉ាង ប្រណគ កនុង អ៊ែ ណាគ់ ឡើ ម៉ើត ចង់ហៀង ដឌែ ម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","តគ់ តង៉ៃ ឞ៊ុន កណើត សឋិច អ៊ែ ឡើ ទែង ញែត ទុត ទិះ ដើម ឡើ ច្រា មែ ទិះ ក្រាគ់ មែ ណាយ តហាន ថណាគ់ ទិះ ដើម មែ ប៊ិច បាក់ លឺ មុះ ម៉ាត់ ដិ ទឹង ស្រុក ឝ៉ាលីលែ ម៉ើ ដក់ មឹត ញែត ចង់ អរែង។ តង៉ៃ ហង់អ៊ែ ឡើ ត្រ ទ្រូង ណាង ហ៊ែរ៉ូដៀះ លំបើម ដើ យ៉ាគ់ យ៉ូហាន។ ");
INSERT INTO brb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ទឹង ណាគ់ ម៉ើ ញែត ចា កួន ប្រោះ ណាង ហ៊ែរ៉ូដៀះ ឡើ មឹត រាំ ឡើ ត្រ ទឹង ប្រម៉ើត សឋិច ដើម ឡើ ត្រ ប្រម៉ើត មែ តមួយ ដិ។ សឋិច ឡើ តង៉ា ណាង រៀន៖ «ហំងុញ អង់ង៉ាយ កតាម ហន់ឡា ហឹ អៃ អ៊ែ អង់អាំ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","យ៉ាគ់ សឋិច ឡើ ខណាត តប៉ឹន ចាក់ ដើ ណាង រៀន៖ «អង់ង៉ាយ កតាម ហន់ឡា ហឹ អៃ ណាគ់ អឡាប់ អង់អាំ សំយ៉ះ ហន់ឡា ប៊្រី ដាក អៃ តង់បារ ណាគ់ អង់អាំ ដើ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ណាង ឡើ ជឹ តង៉ា មែគ ណគ រៀន៖ «មែគ អន់ឡា អង់ង៉ាយ ហឹ យ៉ាគ់ សឋិច?»។ មែគ ណគ ឡើ ត្រណើវ រៀន៖ «ហន់ឡា ទូះ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក»។ ");
INSERT INTO brb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","អ៊ែ ណាង ឡើ ជឹ វឹញ ដ្រិះៗ ប្រយ ហឹ សឋិច ឡើ ឡា រៀន៖ «យ៉ាគ់ សឋិច អៃ អងុញ ហង់អាំ ទូះ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ហន់ជុ ប៊ឹង កថាត ណិះៗ ឡើយ ដើ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","សឋិច នែ ឡើ ដុង ស្រៀវ ប្រយ ហាក់ ឡើ ហាន យ៉ាវ លំពលិះ ប្រម៉ាង ណគ យ៉ាក់ ឡើ តប៉ឹន ចាក់ ឡើយ ដើម មែ តមួយ ម៉ើ ដុង លែក រ៉ា ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ដ្រិះ ប្រយ ឡើ ប៉្រៃ តហាន ណគ មូយ រ៉ា ដក់ ឆាល់ ដង់ ចក់ ជឹ តៀត ទូះ យ៉ាគ់ យ៉ូហាន។ ");
INSERT INTO brb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","បឹ ហង់អ៊ែ ឡើ ដក់ ប្រយ ប៊ឹះ ហឹ ឃុក អ៊ែ ឡើ ឆាល់ ប្រយ ដង់ យ៉ាគ់ យ៉ូហាន។ ទូះ ណគ ឡើ ជុ ទឹង កតូក ឡើ ដក់ អាំ ដើ ណាង អ៊ែ ណាង ឡើ ជឹ ឈូន ហឹ មែគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","តគ់ មែ លុកស៊ិក យ៉ាគ់ យ៉ូហាន ម៉ើ ដុង អ៊ែ ម៉ើ ដក់ ចក់ ចាក់ ណគ ជុ ហឹ ត្រម ច្រាង ចនុ កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","តគ់ មែ លុកស៊ិក លែក ជិត បារ រ៉ា ម៉ើ ជឹ វឹញ តមួត ហឹ គ្រែដៃ យែស៊ូ អ៊ែ ម៉ើ ពប៉ច ដើ ណគ លែក ដើ កាន មែ ម៉ើ បើម ដើម លែក ដើ កាន មែ ម៉ើ ពង់ហៀន។ ");
INSERT INTO brb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","បនឹះ ទុត អើន ម៉ើ ដក់ ដាំង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ មែ អន់នឺ ម៉ើ ដក់ មែ អន់នឺ ម៉ើ ជឹ។ អ៊ែ ម៉ើ តើប អ៊ឺម ចង់ ចា។ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ លុកស៊ិក ណគ រៀន៖ «ញ៉ះ ញន់វីះ អាំ ចង៉ាយៗ តើម ប៊ឹង បូវ ហឹ ឞន ក្លៀវៗ បក់ វន់ដូវ ព្រឹង ង៉ូក អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ទឺះ ឈិះ ឌូក ប្រយ ម៉ើ ដក់ ហឹ ឞន ក្លៀវៗ ចង៉ាយ តើម ប៊ឹង បូវ។ ");
INSERT INTO brb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ទឹង ប៉ះ ម៉ើ វីះ ប៊ិច បនឹះ ទុត អើន ម៉ើ តៃ មែ ដើម ម៉ើ ណោះ ដណក់ មែ អ៊ែ មែ ទុត អើន តើម ប៊ឹង មួង មុយ មូយ ម៉ើ ដក់ យ៉ាវ ចាំ អន់នួរ តមួត តគ់ ឞន។ ");
INSERT INTO brb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ទឺះ តើម ប៊ឹង ឌូក ឡើ តៃ បនឹះ ទុត អើន ទីប ហទីប អ៊ែ ឡើ ស្រុស្រៀត មែ យ៉ាក់ ម៉ើ បើម ប៉ាគ់ ចៀម តៃ ប៊ិច កន់ដ្រាគ់ ពែក។ អ៊ែ ឡើ ពង់ហៀន មែ កាន ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","តគ់ ដៀប ឡើ អំប៊ឹ ឡើយ មែ លុកស៊ិក ណគ ម៉ើ ដក់ ហាយ ដើ ណគ រៀន៖ «ឞន នែ ឡើ ក្លៀវៗ ដើម ម៉ាត់ តង៉ៃ ដៀប ឡើ លុច ឡើយ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ឡា ហំប៉្រៃ មែ មន់វីះ ដក់ ដាំង រួត ចណង់ ចណា តាម បក ដើម ស៊្រុក បរ នែ អាំ មន់ចង់ ចា»។ ");
INSERT INTO brb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «វែ កឡឹ វន់អាំ ចណង់ ចណា ដើ មែ!»។ មែ ម៉ើ ត្រណើវ រៀន៖ «ញន់ចក់ លៀន បារ ក្លាំ កាក់ កឋឹះ អ៊ែ ញន់ដក់ រួត ចណង់ ចណា ដើ មែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «វន់ដក់ ឝ្លាំង ឡាំង វ៉ើ ប៊ិច ណុំពាំង ស៊ិ អំប៉ម?»។ តគ់ ម៉ើ តៃ ឡើយ អ៊ែ ម៉ើ ជឹ ហាយ ដើ ណគ រៀន៖ «ញ៉ើ ប៊ិច ណុំពាំង សើង អំប៉ម ដើម ទ្រឺ ច្រាំ បារ អំប៉ម»។ ");
INSERT INTO brb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ បូវ លុកស៊ិក ណគ មន់ហាយ ដើ មែ ប៉ាសាសុន មន់ដ្រូម ពឺង បាត់ កយ៉ិៗ ប៉ិន បូវៗ។ ");
INSERT INTO brb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","អ៊ែ ម៉ើ ដ្រូម ប៉ិន បូវ បូវ អន់នឺ ត្រមូយ ក្លាំ រ៉ា បូវ អន់នឺ អន់ណាវ ពសើង ជិត រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ញ៉ាក់ ណុំពាំង សើង អំប៉ម ដើម ទ្រឺ បារ អំប៉ម ឡើ ង៉ើយ ទឹង គ្រែ ព្រតឹះ ព្រនែ គ្រែដៃ អ៊ែ ឡើ កដោះ ណុំពាំង អាំ ដើ បូវ លុកស៊ិក ណគ មន់ដក់ ប៉ាក ដើ ប៉ាសាសុន មន់ចា ដើម ឡើ កដោះ ទ្រឺ បារ អំប៉ម អាំ ដើ មែ លែក រ៉ា ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","លែក ដើ មែ ម៉ើ ចា ផិ ប៊ិង ត្រំ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ប៊្លី អ៊ែ បូវ មែ លុកស៊ិក ម៉ើ រ៉ើះ តមួត ណុំពាំង ដើម ទ្រឺ ណគ់ ឡើ ស៊ិវ ញឹះ ជិត បារ ហនូក ម៉ាត់តូវ ប៊ិងៗ។ ");
INSERT INTO brb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ទឹង បូវ មែ ម៉ើ ចា អ៊ែ ប៊ិច មែ កឡ សើង ហលិក រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កន់សឹត លុកស៊ិក ណគ ទឺះ ឈិះ ឌូក អន់នួរ មន់ក្លង តៃ តគ់ ហឹ ស៊្រុក ប៊ែតសៃដា។ ដើ ណគ កឡឹ លំប៉្រៃ មែ ប៉ាសាសុន មន់ជឹ វឹញ។ ");
INSERT INTO brb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ប៊្លី ឡើ ប៉្រៃ មែ ម៉ើ ជឹ ឡើយ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឌឹក ទឹង ចន់ឌូ បក់ លំអ៊ឺរ ដាំង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","តគ់ ឡើ ហ្រង៉ូម មាំង ឡើយ គ្រែដៃ យែស៊ូ ណាគ់ ឡើ គូ មូយ រ៉ា ណគ ទឹង អិះ ដឌែ អ៊ែ ដើ បូវ លុកស៊ិក ម៉ើ ក្លង ប៊ឹះ កឌី ដាក សមុត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","គ្រែដៃ យែស៊ូ ឡើ តៃ បូវ លុកស៊ិក ណគ ម៉ើ ខំ វ៉ះ ឌូក តូវ ម៉ើ សាវបះ ធុក ញ៉ាក យ៉ាក់ កយឺវ ឡើ ពឹក ចន់ដ្រាគ់ ងឺរ។ អ៊ែ តគ់ ដៀប ប្រាង ឡើ ដក់ ហឹ មែ ពឺង កណង ដាក សមុត ឡើ ងុញ លំជឺរ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","បូវ មែ លុកស៊ិក ហំប៊្រុះ ម៉ើ តៃ ណគ ឡើ ដក់ ពឺង កណង ដាក សមុត ម៉ើ វ៉ឹត រៀន កយ៉ក់ ឡើយ អន់តគ់ អ៊ែ ម៉ើ ហរ៉ាវ កឡះ ប្រយ ");
INSERT INTO brb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","យ៉ាក់ លែក ដើ មែ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ អន់ឆាក់ យ៉ាង ប៊ឹង ម៉ើ តៃ ណគ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដ្រិះៗ ដើ មែ រៀន៖ «វន់ពឝ៉ិះ ចនិះ វែ ញ៉ង វ៉ើ ឌូង អ៊ឺម អៃ កឡឹ ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ប៊្លី អ៊ែ ឡើ ឌឹក ឈិះ ឌូក ទឹង មែ អ៊ែ កយឺវ ឡើ ប៉ាត់ ហ្រហៀង។ មែ លុកស៊ិក ហឡឹង ប្រយ ម៉ើ គូ។ ");
INSERT INTO brb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ហមយ៉ះ ម៉ើ តៃ គ្រែដៃ យែស៊ូ ឡើ ពស៊ឺក ណុំពាំង ណាគ់ តៃ ម៉ើ ណោះ ហឝ៉ាវ ដឌែ កាន ណគ ឡើ បើម យ៉ាក់ ចនិះ មែ ណាគ់ តៃ ឡើ ណោះ ឃឹត។ ");
INSERT INTO brb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ក្លង ប៊ឹះ ពឹះ តគ់ ឞន ឝែនែសារែត ឡើយ អ៊ែ ម៉ើ ចត ឌូក ប៊ឹង អិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ហំប៊្រុះ ម៉ើ ញឺះ តើម ប៊ឹង ឌូក មែ ប៉ាសាសុន ម៉ើ ហង់ឝ៉ាវ ប្រយ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","អ៊ែ ម៉ើ ជឹ អ្រយ៉ាវ ពហាយ ត្រំ អំប៊ុ ត្រំ ឞន ឈុំ អ៊ែ។ អ៊ែ ម៉ើ ដក់ តៀត មែ ម៉ើ ឈិ ម៉ើ ទូង ដើ ប៊ែល។ ហឹ ង៉ាយ ម៉ើ ដុង ណគ ឡើ គូ ហឹ អិះ ឡើយ ម៉ើ ដក់ តៀត។ ");
INSERT INTO brb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ត្រំ ឞន គ្រែដៃ យែស៊ូ ឡើ ដក់ តាម មួង តមឹង តាម ស៊្រុក តមឹង តាម មឺរ ញ៉ក បក តូង តមឹង ម៉ើ តៀត មែ ម៉ើ ឈិ ជុ បរ បយឺង ដើម ម៉ើ ឡា ឡូម លំអាំ វ៉ិះ ឝ៉ាន់ មន់ពឹត ក្រប៊ុយ អាវ ណគ។ លែក ដើ មែ ម៉ើ ដូវ ពឹត ម៉ើ នៀម ត្រំ រ៉ា ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ទឹង អ៊ែ បូវ មែ ផារីស៊ី ដើម បូវ ណាយឃូ ពង់ហៀន ចឞាប់ អន់នឺ រ៉ា ណគ់ ម៉ើ ប៊ឹះ តើម ប៊ឹង មួង យែរូសាឡឹម ម៉ើ ដក់ តមួត ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ម៉ើ តៃ លុកស៊ិក គ្រែដៃ យែស៊ូ អន់នឺ រ៉ា ម៉ើ ចង់ ចា ដើ ទី ឡើ ទិត កាន តៃ ស៊ីត យ៉ាក់ តៃ ម៉ើ ដឌូច ។ ");
INSERT INTO brb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","លែក ដើ មែ សុនសាត យូដា ខាក់ៗ មែ ផារីស៊ី ម៉ើ ឌូច ទី អន់ដៃ តាម ខណើយ មែ អ៊ែ ម៉ើ ដូវ ចង់ ចា។ ម៉ើ បើម ត្រួយ តាម ហ៊ីត ខើយ ម៉ិ យ៉ាគ់ មែ ឡៃ មាំង។ ");
INSERT INTO brb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ប៊ឹង ម៉ើ ជឹ តើម ប៊ឹង តឡាត ម៉ើ ពឆ្រះ ចាក់ អន់ដៃ អ៊ែ ម៉ើ ចង់ ចា។ ហ៊ីត ខើយ មែ ទុត អើន អន់ណាវ ម៉ើ បើម ត្រួយ ប៉ាគ់ ឡើ ហដា ចក ហដា វ៉ាន់ ចនុ ដាក ហដា ង៉ិះ ហដា កតាំង។ ");
INSERT INTO brb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","អ៊ែ បូវ មែ ផារីស៊ី ដើម បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ ម៉ើ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ លុកស៊ិក ហៃ ម៉ើ បើម ត្រួយ អ៊ឺម ហ៊ីត ខើយ ម៉ិ យ៉ាគ់ ង៉ាយ ឡៃ មាំង ប៉ិ ឡើ ត្រ ម៉ើ ចង់ ចា ដើ ទី ឡើ ទិត កាន តៃ ស៊ីត ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «អើយ វែ វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង យ៉ាគ់ អ៊ែសាយ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ខៀន ជុ កាន វែ ទុត ត្រ ឡើយ។ ឡើ រៀន៖ “សាត មែ នែ ម៉ើ អៀល បឹះ អៃ វ៉ិះ ដើ បួរ ហាក់ ចនិះ មែ ម៉ើ ចង៉ាយ តើម ប៊ឹង អៃ។ ");
INSERT INTO brb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ម៉ើ អៀល បឹះ អៃ ញឹះ តៃ ប៊ិច ខា កាន ម៉ើ ពង់ហៀន នែ វ៉ិះ ពន់ដ្រៃ បនឹះ”។ ");
INSERT INTO brb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«វ៉ើ តាក់ ពន់ដ្រៃ គ្រែដៃ វែ វ៉ើ បើម តាម ខណើយ បនឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ ដើ មែ រៀន៖ «ទុត ចាគ់ ឡើយ វ៉ើ តាក់ ពន់ដ្រៃ គ្រែដៃ អ៊ែ វ៉ើ ដូវ ចក់ តាម ហ៊ីត ខើយ វែ កឡឹ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ដើ យ៉ាគ់ ម៉ូស៊ែ ឡើ ហាយ រៀន “វែ វន់ត្រ ខរ៉ុប មែគ បើគ ” ដើម ឡើ រៀន “មែ ង៉ាយ ម៉ើ ផម៉ាត ផម៉ា មែគ បើគ កឡឹ មែ អ៊ែ លន់ត្រ មន់កជែត ”។ ");
INSERT INTO brb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","អ៊ែ ណគ់ ដើ វែ អន់ណាវ វ៉ើ ម៉ាង រៀន “ប៉ាគ់ មែ ង៉ាយ ម៉ើ ម៉ាង ដើ មែគ បើគ រៀន ណគ់ អង់ង៉ាយ អៃ អដូវ អាំ ប៉ូរ មែគ បើគ អន់នែ ឡើ កួរបាន់ ឡើយ”។ (ប្រម៉ាង កួរបាន់ នែ ប៊ិច នឿណៃ រៀន អន់ណាំ ដើ គ្រែដៃ)។ ");
INSERT INTO brb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","អ៊ែ ញឹះ តៃ វ៉ើ អាំ យ៉ាវ ណគ លំប៉ូរ អង់ង៉ាយ មូយ ដើ មែគ បើគ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","«ប៉ាគ់ នែ ឡើយ ណគ់ ខណើយ វ៉ើ ពង់ហៀន តៗ អ៊ែ ឡើ បើម អាំ ប្រម៉ាង គ្រែដៃ ឡើ ខា យ៉ាវ។ ដើម វ៉ើ បើម កាន ទុត អើន អន់ណាវ ឡើ សន់ឋៀវ ប៉ាគ់ នែ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កឡូវ មែ ប៉ាសាសុន ម៉ើ ដក់ ឡឹះ ហឹ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «វែ លែក រ៉ា វន់ចង់ហៀង ម៉ាង អៃ ដើម វន់ឃឹត អាំ ណោះ ហឡាក់ៗ យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ប៊ិច អ៊ឺម ចណា អង់ង៉ាយ មូយ លំមឹត ទឹង បនឹះ លំបើម អាំ បនឹះ តៃ មន់ចាគ់ ស៊ីត តគ់ ខាក់ៗ ណគ់ អង់ង៉ាយ ឡើ ញឺះ តើម ប៊ឹង បនឹះ ហង់អ៊ែ ឡើយ ឡើ បើម អាំ បនឹះ តៃ ម៉ើ ចាគ់ ស៊ីត។ ");
INSERT INTO brb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ណគ់ មែ ម៉ើ ប៊ិច ត្រពិត មន់ឃឹត ហឹ ប្រម៉ាង នែ អាំ ខាក់ៗ យ៉ឹ !»។ ");
INSERT INTO brb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","តគ់ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង មែ ប៉ាសាសុន ឡើ មឹត ហឹ ហន់ណាម លមូយ បូវ លុកស៊ិក ម៉ើ តង៉ា ណគ កាន ឡើ ម៉ាង ព្រឌីវ អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «អ៊ែ ណគ់ ដើ វែ ណាគ់ តៃ វ៉ើ ណោះ ហឡាក់ ប៉ាគ់ ដើ មែ ទឺ ឞិ? វែ អាត វន់ណោះ ឡើយ រៀន ប៊ិច អ៊ឺម ចណា អង់ង៉ាយ មូយ លំមឹត ទឹង បនឹះ លំណោះ បើម អាំ បនឹះ តៃ មន់ចាគ់ ស៊ីត។ ");
INSERT INTO brb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","យ៉ាក់ ចណា ឡើ មឹត អ៊ឺម ទឹង ចនិះ បនឹះ ឡើ មឹត ទឹង ពឌិវ ប៊្លី អ៊ែ ឡើ ញឺះ តៃ អ៊ិច»។ ប៉ាគ់ នែ ឡើយ គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន លែក ដើ ចណា ឡើ ចាគ់ នៀម តូច អិះ។ ");
INSERT INTO brb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «ណគ់ អង់ង៉ាយ ឡើ ញឺះ តើម ប៊ឹង ចនិះ បនឹះ ណគ់ ហង់អ៊ែ ឡើយ ឡើ បើម អាំ បនឹះ តៃ មន់ចាគ់ ស៊ីត។ ");
INSERT INTO brb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","យ៉ាក់ កាន តៃ ចាគ់ លែក អ៊ែ ឡើ ញឺះ តើម ប៊ឹង ចនិះ បនឹះ ប៉ាគ់ ឡើ ខនឹត តៃ ចាគ់ ព្រអើក ហឡើ តទូង ចចក់ ក្រជែត ក្រណោះ ");
INSERT INTO brb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ឡើះ ច្រើន ងុញ ប្រនិច ពនឺង អរាំង មាំ តបូត មែ ម៉ាង ឆឡោះ ពឹត តោះ សោះ កដាង អំបូត ប៉ាគ់ ម៉ាត ចើះ តៃ យឺម ផម៉ាត ផម៉ា ចនិះ ឃូយ អុង ដើម ចឡឹង វិត។ ");
INSERT INTO brb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","កាន តៃ ចាគ់ លែក នែ ឡើយ ឡើ ញឺះ តើម ប៊ឹង ចនិះ បនឹះ ឡើ បើម អាំ មែ តៃ ម៉ើ ចាគ់ ស៊ីត»។ ");
INSERT INTO brb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ហឹ ឞន មូយ អន់ណាវ ចើម មួង ទីរ៉ុះ។ ឡើ មឹត ហឹ ហន់ណាម លមូយ ឡើ ងុញ អ៊ឺម មែ មន់ណោះ ណគ ឡើ គូ ទឹង អ៊ែ កនុង អ៊ែ ណាគ់ ម៉ើ ណោះ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ហំប៊្រុះ ដើ អ៊ែ ម៉ិ យូ មូយ រ៉ា ឡើ ប៊ិច កួន កទ្រី មូយ អរ៉ាក់ ឡើ មឹត ឡើ ដុង គ្រែដៃ យែស៊ូ ឡើ គូ ហឹ អ៊ែ អ៊ែ ឡើ ដក់ ជឹះ ត្រកូវ កដាប ហំបះ ប្រយ ប៊ឹង ងឺរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ម៉ិ យូ អ៊ែ ឡើ សុនសាត គែង ឡើ សាត ភែនីគី ស្រុក ស៊ីរី។ ឡើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ លំពន់ឌ្រុះ អរ៉ាក់ តើម ប៊ឹង កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ហឹ ម៉ិ យូ អ៊ែ រៀន៖ «ហន់អាំ កួន ចូវ មន់ចង់ ចា អាំ ផិ អន់ដៃ ឃឺ អ៊ឺម អន់ចក់ ចណង់ ចណា កួន ចូវ អំពៀវ អាំ ដើ ច មន់ចា ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","កទ្រី អ៊ែ ឡើ ត្រណើវ រៀន៖ «ដាវ ឡើយ យ៉ាគ់ កន់ដ្រាគ់! ហាក់ យ៉ះ ច ម៉ើ គូ តៃ ក្រូម តូគ ណាគ់ ម៉ើ កក្លៀប ចណា ណគ់ កួន ចូវ ម៉ើ បើម អន់រុះ»។ ");
INSERT INTO brb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «យ៉ាក់ ហម៉ាង ប៉ាគ់ អ៊ិន ហន់ជឹ ហំមិញ អរ៉ាក់ ឡើ វីះ ឡើយ តើម ប៊ឹង កួន ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ម៉ិ យូ អ៊ែ ឡើ ជឹ ប៊ឹះ តគ់ ហន់ណាម ឡើ តៃ កួន ណគ ឡើ កី ទិ ឝ្រែ អ៊ែ ឡើ ណោះ អរ៉ាក់ ឡើ វីះ ឡើយ តើម ប៊ឹង កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ជឹ វឹញ តើម ប៊ឹង ស្រុក ទីរ៉ុះ ឡើ ដក់ ឡាត់ ស្រុក ស៊ីដូន ដើម ស្រុក ឌែកាប៉ូល ឡើ ទឺះ ប៊ឹះ ទិ សមុត ឝ៉ាលីលែ។ ");
INSERT INTO brb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ទឹង អ៊ែ ម៉ើ ដក់ តៀត កឡ មូយ រ៉ា ហឹ គ្រែដៃ យែស៊ូ បឹ ហង់អ៊ិន ឡើ ទុង ដើម ឡើ ម៉ាង ឝ៉ិះ ម៉ើ ឡា ឡូម ហឹ ណគ លំជុ ទី ពឺង កឡ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","គ្រែដៃ យែស៊ូ ឡើ តៀត កឡ អ៊ែ ចវីះ តើម ប៊ឹង មែ ប៉ាសាសុន អ៊ែ ឡើ កឌែត ត្រពិត បឹ ហង់អ៊ែ ដើ ត្រពួច ប៊្លី អ៊ែ ឡើ កយ៉ុះ ប៊ឹង ត្រពួច ឡើ ពឹត ហពៀត កឡ អ៊ែ ");
INSERT INTO brb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ឡើ ង៉ើយ ឝ្លាំង ទឹង គ្រែ ដើម ឡើ សើម ទិះ អ៊ែ ឡើ ម៉ាង រៀន៖ «អ៊ែផាថា» (ប៊ិច នឿណៃ រៀន “ហំប្រឡុះ ផូង”)។ ");
INSERT INTO brb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ហំប៊្រុះ ដើ អ៊ែ ត្រពិត ណគ ឡើ ដុង ផូង ដើម ហពៀត ណគ ឡើ ដឹន អ្យយ ឡើ ចជែ ហឡាក់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","គ្រែដៃ យែស៊ូ ឡើ កំប៊ែត មន់ប៉ច ដើ បូវ មន់ណោះ។ ឡើ កំប៊ែត ឞាល់ ង៉ាយ ហ៊ែង ម៉ើ ពហាយ ចាំ ម៉ៃ ឞាល់ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","លែក ដើ ប៉ាសាសុន តូវ ម៉ើ ញ៉ម ទុត ខាក់ ដើម ម៉ើ ម៉ាង រៀន៖ «លែក ដើ កាន ណគ ឡើ បើម ម៉ាត់តូវ ឡើ ចាគ់ លែក អិះ សំយ៉ះ បនឹះ ទុង ចង់ហៀង ណាគ់ ដុង បនឹះ កំប្ល ចជែ ណាគ់ ដូវ»។ ");
INSERT INTO brb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ទឹង អ៊ែ ប៊ិច មែ ប៉ាសាសុន ទុត អើន ម៉ើ ដក់ តមួត ឡឹះ ហឹ គ្រែដៃ យែស៊ូ។ ពែ តង៉ៃ ប៊្លី អ៊ែ ញ៉ន តៃ ម៉ើ ប៊ិច ចណង់ ចណា អង់ង៉ាយ អ៊ឺម អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កឡូវ មែ លុកស៊ិក ណគ ឡើ ហាយ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«អស្រុស្រៀត មែ លែក នែ ឞាល់ អ៊ិន យ៉ាក់ ម៉ើ គូ ប៊ឹង អៃ ញឹះ ពែ តង៉ៃ ណិះ ឡើយ ដើម ម៉ើ ប៊ិច អ៊ឺម ចណង់ ចណា។ ");
INSERT INTO brb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ប៉ាគ់ អំប៉្រៃ មែ មន់ជឹ វឹញ ហឹ ហន់ណាម កអឹតៗ មន់សូវ អ៊ឺម មន់បង់ ប៉្រះ ឡើយ តៃ ទ្រូង យ៉ាក់ មែ អន់នឺ ម៉ើ ប៊ឹះ តើម ប៊ឹង ចង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","បូវ លុកស៊ិក ម៉ើ ត្រណើវ ណគ រៀន៖ «ប្លះ ក្លៀវៗ ឞាល់ នែ ហឹ ង៉ាយ ដឹះ ងន់ដូវ ដាំង ចណង់ ចណា ដើ មែ ឆិ មន់ផិ?»។ ");
INSERT INTO brb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ឡើ តង៉ា មែ រៀន៖ «វ៉ើ ប៊ិច ណុំពាំង ស៊ិ អំប៉ម?»។ ម៉ើ ត្រណើវ រៀន៖ «ប៉ឹះ អំប៉ម»។ ");
INSERT INTO brb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","អ៊ែ ឡើ ប៉្រៃ មែ ប៉ាសាសុន មន់ដ្រូម ប៊ឹង ប្រិះ ឡើ ចក់ ណុំពាំង លែក ប៉ឹះ អំប៉ម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ កដោះ អាំ ហឹ លុកស៊ិក ណគ មន់ប៉ាក ដើ មែ ប៉ាសាសុន មន់ចា អ៊ែ ម៉ើ ប៉ាក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ដើម ម៉ើ ប៊ិច ទ្រឺ គ្លែត អង់គ្លែត កិៗ កគ់ៗ ដិ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ ប៉្រៃ លុកស៊ិក ណគ មន់ប៉ាក ប៉ាគ់ទឺ ទ្រឺ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ម៉ើ ចា ផិ លែក រ៉ា ប៊្លី អ៊ែ មែ លុកស៊ិក ម៉ើ តមួត ចណា ណគ់ ឡើ ស៊ិវ ម៉ើ ដូវ ប៉ឹះ ហនូក ប៊ិង។ ");
INSERT INTO brb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ទឹង អ៊ែ ឡើ ប៊ិច បនឹះ ពួន ហលិក រ៉ា អ្យាង។ ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ ម៉ើ ជឹ។ ");
INSERT INTO brb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","លែវ អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ទឺះ ឈិះ ឌូក ដ្រិះៗ ប្រយ ដក់ ហឹ ឞន ដាល់ម៉ានូថា។ ");
INSERT INTO brb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ប៊្លី អ៊ែ បូវ មែ ផារីស៊ី ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ អ៊ែ ម៉ើ ចជែ ច្រម៉ាន ប៊ឹង ណគ ម៉ើ បឡង ឝ្លាំង ណគ ម៉ើ ឡា លំពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ តើម ទិ ហូង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ហាក់ គ្រែដៃ យែស៊ូ ឡើ សើម ទិះ អ៊ែ ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ បនឹះ ប៉ាង ណិះៗ ម៉ើ ងុញ តៃ កាន ហឝ៉ាវ ឆង៉ាត់ ប៉ាគ់ នែ? ដាវ ម៉ាត់ ម៉ាត អៃ អន់ហាយ ដើ វែ រៀន បនឹះ តណើរ អន់នែ ដូវ អ៊ឺម មន់តៃ កាន ហឝ៉ាវ ឆង៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង មែ ឡើ ទឺះ ឈិះ ឌូក ឡឹះ អន់ណាវ ឡើ ក្លង តៃ តគ់។ ");
INSERT INTO brb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","បូវ លុកស៊ិក ម៉ើ វឺញ តៀត ណុំពាំង ម៉ើ ប៊ិច វ៉ិះ ឌិវ មូយ អំប៉ម ទឹង ឌូក។ ");
INSERT INTO brb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","គ្រែដៃ យែស៊ូ ឡើ ថាន់ មែ លុកស៊ិក ណគ រៀន៖ «វន់លវាំង អាំ ខាក់ៗ យ៉ឹ ដើ ប៊ូះ មែ ផារីស៊ី ដើម ប៊ូះ សឋិច ហ៊ែរ៉ូត»។ ");
INSERT INTO brb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","បូវ មែ លុកស៊ិក ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «យ៉ាគ់ ណាយឃូ ឡើ ម៉ាង ប៉ាគ់ អ៊ិន ញ៉ន តៃ ង៉ើ ប៊ិច ណុំពាំង តៃ ណោះ!»។ ");
INSERT INTO brb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","គ្រែដៃ យែស៊ូ ឡើ ណោះ កាន មែ ម៉ើ ចជែ អ៊ែ ឡើ តង៉ា មែ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ចជែ កាន តៃ ប៊ិច ណុំពាំង ប៉ាគ នែ? វែ ណាគ់ វ៉ើ តៃ អ៊ឺម ដើម តៃ វ៉ើ ណោះ ហឡាក់ អំម៉ឹះ ឡះ? ដើម វ៉ើ ប៊ិច ចនិះ តៃ ណោះ ឃឹត ឡះ? ");
INSERT INTO brb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","វ៉ើ ប៊ិច ម៉ាត់ ណាគ់ តៃ វ៉ើ តៃ អ៊ឺម វ៉ើ ប៊ិច ត្រពិត ណាគ់ តៃ វ៉ើ ដុង អ៊ឺម!។ វ៉ើ កាំ អ៊ឺម ឡះ ");
INSERT INTO brb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ប៊ឹង អៃ អកដោះ ណុំពាំង សើង អំប៉ម ប៉ាក អាំ ដើ មែ សើង ហលិក រ៉ា ពយ៉ិ តគ់ វ៉ើ តមួត ណុំពាំង ឡើ ស៊ិវ ណាគ់ ស៊ិ ហនូក វ៉ើ តៃ ឡើ ប៊ិង?»។ ម៉ើ ត្រណើវ រៀន៖ «ណាគ់ ជិត បារ ហនូក »។ ");
INSERT INTO brb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","គ្រែដៃ យែស៊ូ ឡើ តង៉ា ឡឹះ មែ រៀន៖ «ប៊ឹង អៃ អកដោះ ណុំពាំង ប៉ឹះ អំប៉ម ប៉ាក អាំ ដើ បនឹះ ពួន ហលិក រ៉ា តគ់ វ៉ើ តមួត ណុំពាំង ឡើ ស៊ិវ ណាគ់ ស៊ិ ហនូក វ៉ើ តៃ ឡើ ប៊ិង?»។ ម៉ើ ត្រណើវ រៀន៖ «ណាគ់ ប៉ឹះ ហនូក»។ ");
INSERT INTO brb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «ពយ៉ិ ណាគ់ តៃ វ៉ើ ណោះ ហឡាក់ ដឌែ ដឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ វីះ ឡឹះ ប៊ឹះ ស៊្រុក ប៊ែតសៃដា។ តគ់ អ៊ែ ប៊ិច មែ ម៉ើ ទឹក តៀត កឡ សូត ម៉ាត់ មូយ រ៉ា អ៊ែ ម៉ើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ លំពឹត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","គ្រែដៃ យែស៊ូ ឡើ រ៉ាប់ ទី កឡ សូត ម៉ាត់ អ៊ែ ទឹក តៀត ហឹ ដៀក ស៊្រុក អ៊ែ ឡើ ប៉្រុះ ទឹង ម៉ាត់ កឡ អ៊ែ ដើម ឡើ ជុ ទី ពឺង ណគ ឡើ តង៉ា រៀន៖ «ហត្រប៉ៃ ឡើយ ឡះ អង់ង៉ាយ ហតៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","បឹ ហង់អ៊ែ ឡើ ប៉្លើក ម៉ាត់ ហ្រឡាំង ឝ្លាំង ឡើ ត្រណើវ រៀន៖ «អតៃ បនឹះ ដ្រងឹម ប៉ាគ់ តើម ឡង ហាក់ ម៉ើ ដក់»។ ");
INSERT INTO brb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","គ្រែដៃ យែស៊ូ ឡើ ពឹត ឡឹះ ម៉ាត់ បឹ ឡើ សូត បឹ ហង់អ៊ែ ឡើ ប៉្លើក ឡើ តៃ ផូង ប្រយ ទុត ហឡាក់ ម៉ាត់ ណគ ឡើ នៀម ប៉ាគ់ អំប៊ី រីវ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ ណគ ជឹ ហឹ ហន់ណាម ហំមិញ ដើម ឡើ ថាន់ ណគ រៀន៖ «ប៊ឹង ហន់ជឹ វឹញ ញ៉ង ហមឹត អ៊ឺម យ៉ឹ ទឹង ស៊្រុក អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ អំប៉ម ស៊្រុក មុយមូយ ចើម មួង ស៊ែសារែ ភីលីប ។ តៃ ទ្រូង ឡើ តង៉ា មែ លុកស៊ិក ណគ រៀន៖ «មែ ប៉ាសាសុន ម៉ើ រៀន អៃ នែ អមែ ង៉ាយ?»។ ");
INSERT INTO brb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ម៉ើ ត្រណើវ រៀន៖ «មែ អន់នឺ ម៉ើ រៀន ហៃ ហយ៉ាគ់ យ៉ូហាន តម៉ូច ដាក មែ អន់នឺ ម៉ើ រៀន យ៉ាគ់ អ៊ែលីយ៉ា  មែ អន់នឺ អន់ណាវ ម៉ើ រៀន ហកឡា ឈូន ប្រម៉ាង គ្រែដៃ តើម ប៉ាង ឡៃ មាំង»។ ");
INSERT INTO brb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ដើ វែ ដឹះ អង់ង៉ាយ វ៉ើ ជុ អៃ?»។ យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «ហៃ ហគ្រែដៃ គ្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","គ្រែដៃ យែស៊ូ ឡើ ថាន់ មែ លុកស៊ិក អាំ អ៊ឺម មន់ហាយ ដើ បូវ រៀន ណគ ឡើ មែ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពន់តើម ពង់ហៀន បូវ លុកស៊ិក ណគ រៀន៖ «កួន បនឹះ លំត្រ ធុក ញ៉ាក ចា ឈិ ដុ ទុត អើន។ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ណាយឃូ ពង់ហៀន ចឞាប់ មន់កាះ តាក់ ណគ ដើម មន់កជែត ដិ ណគ ហាក់ ពែ តង៉ៃ ប៊្លី អ៊ែ លំញិវ ឡឹះ អន់ណាវ »។ ");
INSERT INTO brb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ មែ ញឹះ តៃ ឡើ អំម៉គ់ កដក កាន នែ។ អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ច្រា គ្រែដៃ យែស៊ូ ចវីះ តើម ប៊ឹង បូវ លុកស៊ិក ឡើ គឹះ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឝ្លាំង ហឹ លុកស៊ិក ឡើ ម៉ាង ក្រាគ់ ដើ យ៉ាគ់ ពែត្រុះ រៀន៖ «ហម៉ាង ប៉ាគ់ អ៊ិន ប្រម៉ាង អរ៉ាក់ សតាំង អឌី អ៊ឺម ចង់ហៀង អតាក់ ប្រម៉ាង ហៃ យ៉ាក់ ខនឹត ហៃ ឡើ ត្រ អ៊ឺម ខនឹត គ្រែដៃ ឡើ ត្រ ខនឹត បនឹះ មិៗ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ប៊្លី អ៊ែ ឡើ កឡូវ មែ ប៉ាសាសុន ដើម លុកស៊ិក ណគ មន់ដក់ តមួត ហឹ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ មែ ង៉ាយ ម៉ើ ងុញ ដក់ តូយ អៃ តង មន់សឡាគ់ តាក់ ចាក់ មែ កឡឹ ញ៉ង មន់ឃឹត យ៉ាវ ទឹង ឝ្រងុញ មែ ដើម មន់កួយ ឡង អង់ឝ៉ាង មែ កឡឹ អ៊ែ មន់ដក់ តូយ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","យ៉ាក់ មែ ង៉ាយ ម៉ើ ខំ ដាំង កាន ញិវ កើត ទិ ឡាង ប្រិះ នែ មែ អ៊ែ មន់ត្រ គែត ប៉ាត់ ពណាត់ ឡើយ ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ឌី តាក់ កាន ញិវ មែ ញ៉ន ដើ អៃ ដើម ញ៉ន ដើ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ មែ អ៊ែ ឡើយ មន់ញិវ។ ");
INSERT INTO brb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ប៉ាគ់ មែ ង៉ាយ ម៉ើ បើម អន់ដូវ ចក់ លែក ដើ ឡាង ប្រិះ នែ ហាក់ តគ់ មន់គែត តៃ មន់ប៊ិច កាន ញិវ ឡូច អន់សច អង់ង៉ាយ លំខា ដើ មែ? ប៊ិច អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","យ៉ាក់ តៃ ប៊ិច ដើ ង៉ាយ អ៊ឺម បនឹះ មន់ដូវ វ៉ាក់ អ៊ែ មន់ដូវ ឆ្រញិវ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","បនឹះ តណើរ ណិះៗ ម៉ើ តាក់ គ្រែដៃ ដើម ម៉ើ ប៊ិច ឞាប។ ប៊ឹង ងឺរ បនឹះ តណើរ អន់នែ ប៉ាគ់ មែ ង៉ាយ ម៉ើ កម៉ាវ ញ៉ន ដើ អៃ ដើម ដើ ប្រម៉ាង អៃ តគ់ កួន បនឹះ លំប៊ឹះ ឡឹះ អរែង ដើ ឞាវ ចាគ់ លួង គ្រែដៃ លំឝ៉ាល ទ្រឺញ អូងអាត តៃ ឋាំ តើម ទិ បើគ ណគ ទឹង អ៊ែ កួន បនឹះ លំកម៉ាវ ប៉ាគ់ទឺ ដើ មែ ដើម លំរៀន ឡើ ហឝ៉ាវ អ៊ឺម មែ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន មែ អន់នឺ ណគ់ ម៉ើ គូ ប៊ឹង នែ មន់គែត អំម៉ឹះ ឋា ដើ មន់តៃ កាន ពែក ប៉ាក់ គ្រែដៃ លំប៊ឹះ ដើ អាតណាត ឆង៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","តើម ប៊ឹង អ៊ែ ត្រូវ តង៉ៃ គ្រែដៃ យែស៊ូ ឡើ ច្រា យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ាកុប ដើម យ៉ាគ់ យ៉ូហាន ឌឹក ទឹង ចន់ឌូ ទុត ឈ្រូង វ៉ិះ ឌិវ មែ។ ហំប៊្រុះ ម៉ើ ប៊ឹះ ទិ អ៊ែ ប៊ឹង ងឺរ មែ ម៉ើ តៃ ចាក់ ដៃ ណគ ឡើ ដិៗ អន់ណាវ ");
INSERT INTO brb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","អ៊ែ ណគ់ ដ្រុនឌ្រូប ហណក ណគ ឡើ វឹរ បក់ បក តូវ ឡើ ថាញ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ទិ ឡាង ប្រិះ នែ មន់ណោះ បើម បក់ បក ឞាល់ នែ។ ");
INSERT INTO brb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ប៊ឹង អ៊ែ បូវ មែ លុកស៊ិក កអវ ម៉ើ តៃ យ៉ាគ់ អ៊ែលីយ៉ា ដើម យ៉ាគ់ ម៉ូស៊ែ អំប្រា ចជែ ប៊ឹង គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ពហាយ ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ណាយឃូ ង៉ាយ ង៉ើ គូ ប៊ឹង នែ ចាគ់ ឡើយ។ ញ៉ះ ញំបើម កទូប ពែ មូយ ដើ ហៃ កឡឹ មូយ ដើ យ៉ាគ់ ម៉ូស៊ែ មូយ ឡឹះ អន់ណាវ ដើ យ៉ាគ់ អ៊ែលីយ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","យ៉ាគ់ ពែត្រុះ ឡើ ម៉ាង ប៉ាគ់ នែ ញ៉ន ឡើ ឃឹត អ៊ឺម ហឹ កាន ណគ ឡើ ចជែ ញ៉ន ម៉ើ ឌូង ទុត ខាក់ តូវ ម៉ើ កុង គឺ។ ");
INSERT INTO brb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","កអវ ឡើ ប៊ិច យូក ឡើ អន់លឹប មែ អ៊ែ ម៉ើ ដុង ប្រម៉ាង តើម ប៊ឹង យូក រៀន៖ «អន់នែ ឡើយ កួន កឡ ប្រម៉ើត អៃ វន់ចង់ហៀង យ៉ឹ ម៉ាង ណគ!»។ ");
INSERT INTO brb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ហំប៊្រុះ ដើ អ៊ែ មែ លុកស៊ិក ម៉ើ ហវីវ ឝ្លាំង ឈុំ មែ ម៉ើ តៃ យ៉ាវ អំប្រា ម៉ើ តៃ វ៉ិះ ឌិវ គ្រែដៃ យែស៊ូ ឡើ គូ ប៊ឹង មែ។ ");
INSERT INTO brb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ប៊ឹង មែ គ្រែដៃ យែស៊ូ ម៉ើ ទឺះ តើម ទិ ចន់ឌូ អ៊ែ ឡើ ថាន់ មែ ញ៉ង អាំ មន់ពប៉ច ដើ មែ ង៉ាយ អ៊ឺម កាន ម៉ើ តៃ អន់ឌូ អ៊ែ ឋា ដើ ប៊ឹះ កួន បនឹះ លំញិវ ឡឹះ តើម ប៊ឹង គែត។ ");
INSERT INTO brb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","លែក មែ ពែ រ៉ា ម៉ើ ចាប់ ម៉ាង ណគ ឡើ ថាន់ មែ អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «កាន ញិវ ឡឹះ តើម ប៊ឹង គែត អ៊ិន ឡើ ប៊ិច នឿណៃ ប៉ាគ់ ង៉ាយ ឋូវ?»។ ");
INSERT INTO brb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","អ៊ែ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ញ៉ន ង៉ាយ អ៊ែ ឡើ ត្រ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ រៀន យ៉ាគ់ អ៊ែលីយ៉ា ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ លំត្រ ប៊ឹះ អន់នួរ គ្រែដៃ គ្រិះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ឡើ ត្រណើវ ម៉ាង មែ រៀន៖ «ដាវ ឡើយ យ៉ាគ់ អ៊ែលីយ៉ា ឡើ ត្រ ប៊ឹះ អន់នួរ បក់ លំពចាគ់ លែក ដើ កាន អាំ ត្រៗ ប៉ាគ់ ពន់ឋើម ទឺ។ វែ វន់ត្រ ឃឹត ប៉ាគ់ទឺ កាន កួន បនឹះ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ ម៉ើ រៀន កួន បនឹះ លំត្រ ធុក ញ៉ាក ប៉ាក ម៉ង ទុត អើន ដើម មន់កាះ តាក់ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","អៃ អង់ហាយ ដើ វែ រៀន ណគ់ ដើ យ៉ាគ់ អ៊ែលីយ៉ា អ៊ែ ឡើ ប៊ឹះ ឡើយ ដើម ម៉ើ តំឞាប ណគ តាម ប្រម៉ើត មែ ត្រំ ហំឞ្លិច ឡើ ដាវ ប៉ាគ់ ម៉ើ ខៀន ជុ កាន ណគ ទឹង ពឹម ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ប៊ឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ លែក ពែ រ៉ា ម៉ើ ជឹ តមួត ទិ បូវ លុកស៊ិក តៃ ម៉ើ តូយ អ៊ឺម អ៊ែ ម៉ើ តៃ មែ ប៉ាសាសុន ទុត អើន ម៉ើ គូ ឈុំ មែ លុកស៊ិក ដើម មែ ណាយឃូ ពង់ហៀន ចឞាប់ ដិ ម៉ើ ចជែ ច្រម៉ាន ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ហំប៊្រុះ មែ ប៉ាសាសុន ម៉ើ តៃ គ្រែដៃ យែស៊ូ ព្រឺ ហឡឹង ប្រយ ម៉ើ គូ អ៊ែ ម៉ើ ដក់ យ៉ាវ តង៉ា ឡា ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «កាន អង់ង៉ាយ វ៉ើ ចជែ ច្រម៉ាន ដើ មែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ទឹង បូវ មែ ប៉ាសាសុន លែក អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ណាយឃូ អតៀត កួន កឡ អៃ ហឹ ហៃ យ៉ាក់ អរ៉ាក់ កំប្ល ឡើ មឹត ទឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ហឹ ង៉ាយ កតាម ប៊ឹង អរ៉ាក់ ឡើ មឹត មូយ តងៗ ឡើ តំបង់ ណគ កពូះ ដាក ហាយ កាប់ ក្រៀម ឝលៀម ពឹង ចាក់ ដៃ ណគ តូវ ឡើ កុង។ អអ៊ឺរ ឡើយ មែ លុកស៊ិក ហៃ ម៉ើ ពន់ឌ្រុះ អរ៉ាក់ តើម ប៊ឹង ណគ ណាគ់ តៃ ម៉ើ បើម អំវីះ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «អើយ បនឹះ តណើរ ណិះៗ ណគ់ តៃ វ៉ើ ឌី ចាប់ មឹង គ្រែដៃ! ណាគ់ ឌុញ ឞាល់ ង៉ាយ ដឹះ លំត្រ អង់គូ ប៊ឹង វែ? ណាគ់ ឌុញ ឞាល់ ង៉ាយ អន់ត្រ ប៉ឹន ក្លើម ដើ វែ? មិញ វន់តៀត អង់គ្លែត អ៊ែ ហឹ អៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","អ៊ែ ម៉ើ តៀត អង់គ្លែត ហឹ ណគ។ ហំប៊្រុះ អរ៉ាក់ ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ បើម អាំ អង់គ្លែត អ៊ែ ឡើ កកៃ យ៉ៃៗ អ៊ែ ឡើ បង់ ប្រយ តូវ ឡើ ព្រលូ ព្រឡាក់ កពូះ ដាក ហាយ បៀម។ ");
INSERT INTO brb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","គ្រែដៃ យែស៊ូ ឡើ តង៉ា បើគ ដូវ អង់គ្លែត អ៊ែ រៀន៖ «ឌុញ ឡើយ ឡះ ឡើ បើម ប៉ាគ់ នែ?»។ បើគ ណគ ឡើ ត្រណើវ រៀន៖ «តើម ណាគ់ ឡើ កិៗ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","អរ៉ាក់ អ៊ែ ឡើ តំបង់ ណគ ទឹង អ៊ុញ ដើម ទិ ដាក ឆិញៗ ឡើយ បក់ អាំ លំគែត។ ឡា ហន់ស្រុស្រៀត ញ៉ា ហំប៉ូរ ញ៉ា អុះ ប៉ាគ់ ណាគ់ ហន់ដូវ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «ពយ៉ិ ឡើ ត្រ ហរៀន “ប៉ាគ់ ហន់ដូវ” ប៉ាគ់ អ៊ិន? ចក់ ដើ មែ ង៉ាយ ម៉ើ ចាប់ មឹង គ្រែដៃ ឡើ បើម ដូវ លែក អិះ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ហំប៊្រុះ ដើ អ៊ែ បើគ អង់គ្លែត អ៊ែ ឡើ ម៉ាង ថាំងៗ រៀន៖ «អៃ អចាប់ មឹង ឡើយ! ឡា យ៉ាគ់ ហំប៉ូរ អៃ អាំ អន់ចាប់ មឹង ម៉ាត់ ម៉ាត អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","គ្រែដៃ យែស៊ូ ឡើ តៃ បនឹះ ទុត អើន ឆឹន ហន់ឆឹន ម៉ើ យ៉ាវ ដក់ តមួត ហឹ ណគ អ៊ែ ឡើ ម៉ាង ក្រាគ់ ដើ អរ៉ាក់ អ៊ែ រៀន៖ «អរ៉ាក់ កំប្ល ទុង អប៉្រៃ ហៃ ហំវីះ តើម ប៊ឹង អង់គ្លែត នែ ញ៉ង ហមឹត យ៉ាវ ឋាយ ទឹង ណគ!»។ ");
INSERT INTO brb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","អរ៉ាក់ អ៊ែ ឡើ ហរ៉ាវ កឡះ ទុត ថាំង ដើម ឡើ បើម អាំ អង់គ្លែត នែ កណាំង កាញ ហឞៀក ហឞូយ ទុត ខាក់ ប៊្លី អ៊ែ ឡើ វីះ។ ប៊ឹង អ៊ែ អង់គ្លែត អ៊ែ ឡើ ហង់ង៉ាន់ ឞាល់ ឡើ គែត អ៊ែ មែ ប៉ាសាសុន ទុត អើន ម៉ើ ហាយ រៀន ឡើ គែត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","អ៊ែ ដើ គ្រែដៃ យែស៊ូ ឡើ រ៉ាប់ ប៊ឹង ទី ឡើ ពឌឹក អង់គ្លែត អ៊ែ ឡើ ឌឹក ឆុង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","តគ់ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ មឹត ហឹ ហន់ណាម ម៉ើ ចង៉ាយ តើម ប៊ឹង បូវ ឡើយ អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ «ប៉ាគ់ ង៉ាយ អិះ ឡើ ត្រ ដើ ញ៉ា ញ៉ើ ដូវ អ៊ឺម ពន់ឌ្រុះ អរ៉ាក់ អន់នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «អរ៉ាក់ ប៉ាគ់ នែ តៃ កា មន់អ៊ឺរ ដាំង គ្រែដៃ  អ៊ែ មន់ដូវ ពន់ឌ្រុះ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ វីះ តើម ប៊ឹង អ៊ែ ម៉ើ ដក់ ឡាត់ ស្រុក ឝ៉ាលីលែ។ ឡើ អាំ អ៊ឺម បូវ មន់ណោះ ណគ ហឹ ង៉ាយ ឡើ គូ។ ");
INSERT INTO brb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","យ៉ាក់ ឡើ ពង់ហៀន លុកស៊ិក ណគ រៀន៖ «កួន បនឹះ លំត្រ មន់ឈូន ហឹ ទី មែ ដ្រម៉ា មែ មន់កជែត ណគ។ តគ់ តង៉ៃ ទី ពែ លំញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ហាក់ បូវ មែ លុកស៊ិក ម៉ើ ណោះ អ៊ឺម កាន ណគ ឡើ ម៉ាង អ៊ែ ដើម តៃ ម៉ើ ហាន តង៉ា ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ ប៊ឹះ មួង កាផារនុំ។ ប៊ឹង ម៉ើ គូ ទឹង ហន់ណាម ឡើ តង៉ា បូវ លុកស៊ិក ណគ រៀន៖ «កាន អង់ង៉ាយ វ៉ើ ចជែ តៃ ទ្រូង អន់ឌូ?»។ ");
INSERT INTO brb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","បូវ លុកស៊ិក ម៉ើ គូ ហ្រហៀង យ៉ាក់ តៃ ទ្រូង អន់ឌូ ម៉ើ ច្រម៉ាន ត្រឌីវ មែ រៀន៖ «មែ ង៉ាយ ឋូវ ឡើ ទិះ ក្រាគ់ ជឺរ ទឹង ង៉ាយ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ឡើ ប៉្រៃ លុកស៊ិក ណគ លែក ជិត បារ រ៉ា ដក់ តមួត ហឹ ណគ អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «មែ ង៉ាយ ម៉ើ ងុញ ទិះ ក្រាគ់ ជឺរ បូវ មែ អ៊ែ មន់ត្រ បើម កិ ក្រូម បូវ អន់ណាវ ដើម មន់បើម ឞយ លែក ដើ បូវ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ទឹក អង់គ្លែត មូយ រ៉ា ឡើ ពឆុង ប្លះ កឌី មែ លុកស៊ិក។ គ្រែដៃ យែស៊ូ ឡើ អម អង់គ្លែត អ៊ែ ប៊្លី អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«មែ ង៉ាយ ម៉ើ ឡាប់ អង់គ្លែត ឌិត នែ ញ៉ន ដើ ម៉ើ ម៉ើត អៃ មែ អ៊ែ ម៉ើ ឡាប់ អៃ ឡើយ មែ ង៉ាយ ម៉ើ ឡាប់ អៃ តៃ ត្រ ម៉ើ ឡាប់ វ៉ិះ ឌិវ អៃ អ៊ឺម ដើម ម៉ើ ឡាប់ កឡា ឡើ ប៉្រៃ អៃ អប៊ឹះ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","យ៉ាគ់ យ៉ូហាន ឡើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ណាយឃូ ញ៉ា ញ៉ើ តៃ បនឹះ មូយ រ៉ា ឡើ ពន់ឌ្រុះ អរ៉ាក់ ឡើ អ៊ីង ដើ អាតណាត ម៉ាត់ ហៃ។ អ៊ែ ញ៉ើ កំប៊ែត ណគ យ៉ាក់ ណគ ឡើ ដក់ តូយ អ៊ឺម ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ញ៉ង វ៉ើ កំប៊ែត អ៊ឺម ណគ យ៉ាក់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ បើម កាន ឆង៉ាត់ ដើ អាតណាត ម៉ាត់ អៃ ប៊្លី អ៊ែ មន់ម៉ាង កយ៉ាគ់ យូច ដើ អៃ ប៊ឹង បូវ ដ្រិះៗ ប្រយ ");
INSERT INTO brb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","យ៉ាក់ ណគ់ មែ ង៉ាយ តៃ ម៉ើ ព្រឆាន់ ដើ ង៉ាយ មែ អ៊ែ ម៉ើ បូវ ង៉ាយ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ណគ់ មែ ង៉ាយ ម៉ើ អាំ ដាក មូយ ចក ដើ វែ ញ៉ន ដើ វ៉ើ តូយ គ្រែដៃ គ្រិះ មែ អ៊ែ គ្រែដៃ លំអាំ តង់ហវ ម៉ាត់ ម៉ាត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«ប៉ាគ់ ប៊ិច មូយ រ៉ា លំច្រា ណគ់ មែ ម៉ើ ចាប់ មឹង អៃ ហមយ៉ះ ម៉ើ កិ ក្រូម បូវ កតាម មន់បើម កាន យូច ណគ អ៊ែ ណាគ់ អង់ហយ មន់ចក់ តម៉ កណិន ទុត ទិះ ចង ប៊ឹង ដង់ ណគ កលីះ ទិ ដាក សមុត អ៊ែ លន់ចាគ់ ជឺរ ហំប្លះ លំញិវ អង់ឝ៉ាន់ លំច្រា មែ មន់បើម កាន យូច។ ");
INSERT INTO brb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ប៉ាគ់ ទី ហៃ លំច្រា ហំបើម កាន យូច ហំឆាល់ តាក់ ណាគ់ ហយ ហំប៊ិច ទី ឌិវ មូយ ច្រះ ដើម ហំប៊ិច ឆ្រញិវ ឡូច អន់សច លន់ចាគ់ ជឺរ ហំប្លះ ហំប៊ិច ទី លែក បារ ច្រះ ដើម ហន់គ្លីះ ទិ ត្របាំង អ៊ុញ ញឹះ តៃ ណោះ ប៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ទិ ឞន អ៊ែ ឡើ ប៊ិច ស៊្រឺយ ម៉ើ ណោះ អក់ អន់សច អ៊ុញ តៃ ឡើ ណោះ ប៉ាត់ ។ ");
INSERT INTO brb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ប៉ាគ់ ឈឹង ហៃ លំតៀត ហៃ ហំបើម កាន យូច ហំឆាល់ តាក់ ណាគ់ ហយ ហំប៊ិច ឈឹង ឌិវ មូយ ច្រះ ដើម ហំប៊ិច ឆ្រញិវ ឡូច អន់សច លន់ចាគ់ ជឺរ ហំប្លះ ហំប៊ិច ឈឹង លែក បារ ដើម គ្រែដៃ លំពៀវ ហៃ ទិ ត្របាំង អ៊ុញ។ ");
INSERT INTO brb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ទិ ឞន អ៊ែ ឡើ ប៊ិច ស៊្រឺយ ម៉ើ ណោះ អក់ អន់សច អ៊ុញ តៃ ឡើ ណោះ ប៉ាត់ ។ ");
INSERT INTO brb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ប៉ាគ់ទឺ ឡើយ ប៉ាគ់ ម៉ាត់ ហៃ លំច្រា ហំបើម កាន យូច ហំឝ៉ិច តាក់ ប្រយ ណាគ់ ហយ ហំប៊ិច ម៉ាត់ ឌិវ មូយ ច្រះ ដើម ហំមឹត គូ ទឹង ឞន គ្រែដៃ ឡើ ពែក ប៉ាក់ លន់ចាគ់ ជឺរ ហំប្លះ ហំប៊ិច ម៉ាត់ លែក បារ ដើម គ្រែដៃ លំពៀវ ហៃ ទិ ត្របាំង អ៊ុញ ");
INSERT INTO brb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ទិ ឞន អ៊ែ ឡើ ប៊ិច ស៊្រឺយ ម៉ើ ណោះ អក់ អន់សច អ៊ុញ តៃ ឡើ ណោះ ប៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«យ៉ាក់ គ្រែដៃ ឡើ ពចាគ់ លែក ដើ បនឹះ ដើ អ៊ុញ ប៉ាគ់ បោះ ឡើ ពចាគ់ ថនួយ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","បោះ នែ ឡើ ប៊ិច ខា ទុត ខាក់ ហាក់ ប៉ាគ់ លំប៉ាត់ តារ់ ឡើយ ប៉ាគ់ ង៉ាយ អន់ណាវ វន់បើម អ៊ែ លំតារ់ ឡឹះ? ");
INSERT INTO brb_vpl VALUES ("MK9_51","071_9_51","MRK","9","51","51","ហឹ វន់ប៊ិច តារ់ ទឹង ចាក់ វែ កឡឹ អ៊ែ វន់ខា ត្រឌីវ វែ ដើម វន់គូ ឆនឹម ហន់ណាំង ត្រឌីវ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ប៊ឹះ ស្រុក យូដា ដើម ឡើ ក្លង ដណៃ យ៉ូរដាន់ ពឹះ តៃ តគ់។ មែ ប៉ាសាសុន ទុត អើន ម៉ើ ដក់ តមួត ឡឹះ អន់ណាវ ហឹ ណគ ប៊្លី អ៊ែ ឡើ ពង់ហៀន មែ តាម ប៉ាគ់ ខណើយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ដើម ប៊ិច បូវ មែ ផារីស៊ី ម៉ើ ដក់ ហឹ ណគ ម៉ើ ងុញ បឡង ឝ្លាំង ណគ។ អ៊ែ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ពយ៉ិ តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ មែ កឡ មន់តាក់ ទ្រី ណាគ់ ដូវ ឡះ លឺ ដូវ អ៊ឺម?»។ ");
INSERT INTO brb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ ង៉ាយ ដឹះ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ វែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ម៉ើ ត្រណើវ រៀន៖ «យ៉ាគ់ ម៉ូស៊ែ ឡើ អាំ មែ កឡ មន់តាក់ ទ្រី ថលែម មន់ខៀន សំឞ៊ុត តាក់ ទ្រី អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «យ៉ាគ់ ម៉ូស៊ែ ឡើ ខៀន ពន់ដ្រៃ នែ ដើ វែ ញ៉ន វ៉ើ ប៊ិច ចនិះ ឝ៉ិះ ង៉ឹល។ ");
INSERT INTO brb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ហាក់ អន់នួរៗ ពន់ឋើម ប៊ឹង គ្រែដៃ ឡើ ពឝ៉ើត ត្រំ ហំឞ្លិច លែក អិះ ឡើ ពឝ៉ើត ប៉ាគ់ទឺ បនឹះ ប៊ិច កឡ ប៊ិច កទ្រី ។ ");
INSERT INTO brb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ញ៉ន ដើ អ៊ែ ឡើយ អ៊ែ មែ កឡ មន់វីះ តើម ប៊ឹង ម៉ិ បើគ មន់ដក់ គូ អរែង ប៊ឹង ទ្រី មែ កឡឹ អន់ណាវ ");
INSERT INTO brb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","អ៊ែ អំប្រា ទ្រី ក្ល នែ លំវឹរ ចាក់ ដៃ ឌិវ មូយ។ ប៉ាគ់ ពអ៊ែ អំប្រា នែ ត្រ យ៉ាវ បារ រ៉ា ចាក់ វ៉ិះ ឌិវ មូយ អន់ណាវ ។ ");
INSERT INTO brb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ប៉ាគ់ ពអ៊ែ ណគ់ អង់ង៉ាយ គ្រែដៃ ឡើ ពង់ឝ៉ាប់ ឡើយ ញ៉ង អាំ យ៉ាវ បនឹះ មន់ពឝ៉្លះ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","តគ់ ម៉ើ មឹត ហឹ ហន់ណាម បូវ លុកស៊ិក ម៉ើ តង៉ា ឡឹះ គ្រែដៃ យែស៊ូ កាន អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «បឹ អង់ង៉ាយ ឡើ តាក់ ទ្រី ឡើ ចក់ ទ្រី ហន់ដើម បឹ ហង់អ៊ែ ឡើ ឡើះ ទ្រី ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","អ៊ែ ណគ់ កទ្រី អង់ង៉ាយ ឡើ តាក់ ក្ល ឡើ ចក់ ក្ល ហន់ដើម កទ្រី នែ ឡើ ឡើះ ក្ល ឡើយ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ប៊ិច បនឹះ ម៉ើ ដក់ តៀត មែ អង់គ្លែត ហឹ គ្រែដៃ យែស៊ូ អាំ លំជុ ទី ប៊ឹង មែ ហាក់ បូវ លុកស៊ិក ណគ ម៉ើ គឹះ មែ ម៉ើ តៀត មែ អង់គ្លែត។ ");
INSERT INTO brb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","តគ់ គ្រែដៃ យែស៊ូ ឡើ តៃ ប៉ាគ់ អ៊ែ ឡើ មាំ ទឹង ចនិះ ណគ ទុត ខាក់ អ៊ែ ឡើ ម៉ាង ដើ មែ លុកស៊ិក រៀន៖ «វន់អាំ មែ អង់គ្លែត មន់ដក់ ហឹ អៃ ញ៉ង វ៉ើ កំប៊ែត អ៊ឺម មែ យ៉ាក់ វ៉ិះ ឌិវ មែ ម៉ើ ប៊ិច ចនិះ ក្លើម ប៉ាគ់ មែ អង់គ្លែត ណិះ ឡើយ គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន មែ ង៉ាយ ម៉ើ ឡាប់ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ប៉ាគ់ ដើ មែ អង់គ្លែត នែ មែ អ៊ែ មន់ដូវ មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ប៉ាគ់ តៃ មន់ឡាប់ ដូវ អ៊ឺម មន់មឹត»។ ");
INSERT INTO brb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ អម មែ អង់គ្លែត ត្រំ មែ ដើម ឡើ ជុ ទី ប្រាយ អាំ កាន ចាគ់ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","គ្រែដៃ យែស៊ូ ហំប៊្រុះ ឡើ វីះ ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ យ៉ាវ ជឹះ ត្រកូវ កដាប ហំបះ ប៊ឹង ងឺរ ណគ ឡើ តង៉ា រៀន៖ «ឡា ណាយឃូ អើយ ហបនឹះ ក្លើម ចាគ់ ប៉ាគ់ ង៉ាយ អំបើម អ៊ែ អន់ដូវ ញិវ ឡូច អន់សច?»។ ");
INSERT INTO brb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ ហរៀន អៃ អបនឹះ ក្លើម ចាគ់ ប៉ាគ់ អ៊ិន? តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ប៊ិច ក្លើម ចាគ់ វ៉ិះ ឌិវ មូយ គ្រែដៃ អិះ ឡើយ ឡើ ប៊ិច ក្លើម ចាគ់។ ");
INSERT INTO brb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ហៃ ហណោះ ឡើយ ចឞាប់ គ្រែដៃ ឡើ ប៉្រៃ រៀន ញ៉ង កជែត បនឹះ ញ៉ង អ្រឡើះ ញ៉ង តទូង ចចក់ ញ៉ង ចឹន ឆ្រឡិ ឆ្រលួគ បូវ ញ៉ង ម៉ាង តបូត ដើ ងុញ រ៉ាះ មែ តង ខរ៉ុប មែគ បើគ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","បឹ ហង់អ៊ែ ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ ណាយឃូ អើយ អៃ អបើម ត្រួយ ពន់ដ្រៃ លែក នែ ណាគ់ តើម ប៊ឹង អច្រហើវ ឈ្រែង ឆ្រង ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","គ្រែដៃ យែស៊ូ ឡើ ឝ្លាំង ហឹ ណគ ដើម ឡើ ម៉ើត ដើ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «ណាគ់ មូយ ខ ហដូវ អំម៉ឹះ ហបើម ហន់ដក់ ហំពួត លែក ដើ អង់ង៉ាយៗ ណគ់ ហៃ ហប៊ិច ប៊្លី អ៊ែ ហំអាំ លៀន ដើ មែ ធុក ញ៉ាក។ អ៊ែ ហំប៊ិច ប្រនិច ទឹង ហូង គ្រែដៃ ទិ។ ហំបើម ប៉ាគ់ នែ ឡើយ អ៊ែ ហន់តូយ អៃ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ហំប៊្រុះ ឡើ ដុង គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ប៉ាគ់ អ៊ិន ឝ្រង៉ូវ ប្រយ ឡើ គូ អ៊ែ ឡើ ជឹ ស្រៀវ ឆ្រញ៉ាំ យ៉ាក់ ឡើ ប្រនិច ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឝ្លាំង ឈុំ ណគ ប៊្លី អ៊ែ ឡើ ម៉ាង ដើ មែ លុកស៊ិក ណគ រៀន៖ «ណគ់ បនឹះ ប៊ិច បាក់ ញ៉ាក ខាក់ៗ មន់មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","បូវ លុកស៊ិក តូវ ម៉ើ បើម ទុត ដើ ប្រម៉ាង ណគ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ ដើ មែ រៀន៖ «កួន ចូវ អើយ ញ៉ាក ខាក់ៗ មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់! ");
INSERT INTO brb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ណាគ់ ហយ រោះ លំមឹត ទឹង ត្រម កិះ ហំប្លះ បនឹះ ប៊ិច បាក់ លំមឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","បូវ លុកស៊ិក សរ៉ើម ម៉ើ បើម ទុត ហ៊ែង ចាំ ម៉ៃ អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «យ៉ាក់ ប៉ាគ់ អ៊ិន មែ ង៉ាយ ដឹះ មន់ដូវ កាន ហវ៉ាត់?»។ ");
INSERT INTO brb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","គ្រែដៃ យែស៊ូ ឡើ ឝ្លាំង ហឹ មែ លុកស៊ិក អ៊ែ ឡើ ម៉ាង រៀន៖ «កាន នែ ណោះ អ៊ឺម បនឹះ មន់បើម ហាក់ គ្រែដៃ ឡើ ដូវ បើម យ៉ាក់ ឡើ ណោះ បើម លែក អិះ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","យ៉ាគ់ ពែត្រុះ ឡើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «ហតៃ ឡើយ ដើ ញ៉ា នែ ញ៉ើ តាក់ កាន អង់ង៉ាយៗ លែក អិះ អ៊ែ ញ៉ើ ដក់ តូយ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន មែ ង៉ាយ ម៉ើ តាក់ ហន់ណាម ក្រាន អំម៉ោះ អោះ មែគ បើគ កួន ចូវ លឺ មឺរ ណា ញ៉ន ដើ ម៉ើ តូយ អៃ ដើម ញ៉ន ដើ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ");
INSERT INTO brb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","មែ អ៊ែ ទឹង ណាគ់ ម៉ើ ញិវ កនុង មូយ មន់ដូវ មូយ ក្លាំ អន់ណាវ ប៉ាគ់ ឡើ ហន់ណាម អំម៉ោះ អោះ មែគ បើគ កួន ចូវ ដើម មឺរ ណា ដឹប មន់ជូល កាន តំឞាប ដិ។ អ៊ែ ហឹ ងឺរ តគ់ មន់ដូវ ញិវ ឡូច អន់សច។ ");
INSERT INTO brb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","បនឹះ ទុត អើន ណគ់ ម៉ើ បើម ទិះ ក្រាគ់ តគ់ ហន់ណូវ តៃ មន់ម៉ាត ប៊ីត យ៉ាវ អ៊ែ បនឹះ ទុត អើន ណគ់ តៃ ម៉ើ ម៉ាត ប៊ីត តគ់ ហន់ណូវ មន់បើម ទិះ ក្រាគ់ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","គ្រែដៃ យែស៊ូ ដើម មែ ម៉ើ ដក់ តូយ ណគ ម៉ើ ឌឹក ទឹង មួង យែរូសាឡឹម។ គ្រែដៃ យែស៊ូ ឡើ ដក់ តៃ ងឺរ មែ។ មែ លុកស៊ិក ណគ នែ ម៉ើ ឃឹត កំប្រៃ ច្រៃ កនុង អ៊ែ ណគ់ មែ ម៉ើ ដក់ តូយ មែ ម៉ើ ឌូង ប៉ាគ់ទឺ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ចន់ដ្រា លុកស៊ិក ណគ លែក ជិត បារ រ៉ា ឡះ តើម ប៊ឹង បូវ ឡឹះ អណាវ អ៊ែ ឡើ ហាយ ដើ មែ កាន លំកើត ដើ ណគ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«វន់ចង់ហៀង យ៉ឹ ង៉ាយ ង៉ើ ឌឹក ទឹង មួង យែរូសាឡឹម ទឹង អ៊ែ កួន បនឹះ លំត្រ មន់ឈូន ហឹ ទី មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម ហឹ មែ ណាយឃូ ពង់ហៀន ចឞាប់ មន់តាត់ស៊ិន ប៉្រៃ កជែត ណគ ប៊្លី អ៊ែ មន់ដក់ ម៉ប ឈូន ណគ ហឹ ទី សុនសាត មែ គែង។ ");
INSERT INTO brb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","បូវ មែ អ៊ិន មន់ចអាវ ពសាល់ ពន់ឆាំ ណគ មន់កយ៉ុះ ក្រហាក ពឺង ណគ ដើម មន់បឹត ណគ ដើ ឆមឺ ប្រាត់ ប៊្លី អ៊ែ មន់កជែត។ លំគែត ពែ តង៉ៃ អ៊ែ លំញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ប៊្លី អ៊ែ យ៉ាគ់ យ៉ាកុប អំប្រា យ៉ាគ់ យ៉ូហាន កួន យ៉ាគ់ ស៊ែប៊ែឌែ អំប្រា ដក់ ពន់ចើម តគ់ គ្រែដៃ យែស៊ូ អ៊ែ អំប្រា ឡា រៀន៖ «យ៉ាគ់ ណាយឃូ ញ៉ើ ងុញ ហំបើម តាម អ្រឡា ញឺ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ម៉ាង អំប្រា រៀន៖ «អង់ង៉ាយ ដឹះ សប្រា ងុញ អៃ អំបើម ដើ សប្រា?»។ ");
INSERT INTO brb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","អំប្រា ត្រណើវ រៀន៖ «តគ់ ហន់ដ្រូម ប៊ឹង ទិងមៀង អនីង ទឹង ឞន យ៉ូក យ៉ាល់ ហៃ ហង់អាំ ញឺ ញន់ដ្រូម ប៊ឹង ដៀក ហៃ អុះ មូយ រ៉ា តៃ ចម៉ា មូយ រ៉ា តៃ ចអៀវ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «សប្រា ណោះ អ៊ឺម ណោះ អង់ង៉ាយ សប្រា ឡា។ ណាគ់ សប្រា បក់ ឞិ សប្រា លំញែត ប៊ែង ធុក ញ៉ាក ណគ់ អៃ អន់ត្រ ញែត? ណាគ់ សប្រា លំបក់ ឞិ សប្រា លំម៉ូច ទឹង កាន ធុក ញ៉ាក ណគ់ អៃ អំម៉ូច?»។ ");
INSERT INTO brb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","អំប្រា ត្រណើវ រៀន៖ «បក់»។ គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ រៀន៖ «ដាវ ឡើយ សប្រា លំញែត ប៊ែង ណគ់ អៃ អន់ញែត ដើម សប្រា លំម៉ូច ទឹង កាន ធុក ញ៉ាក ប៉ាគ់ ដើ អៃ ទឺ ");
INSERT INTO brb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ហាក់ ណគ់ កាន មែ មន់ដ្រូម តៃ ចម៉ា ដើម តៃ ចអៀវ អៃ អ៊ែ ត្រ អ៊ឺម អៃ អន់ដូវ អាំ យ៉ាក់ គ្រែដៃ ឡើ រន់ឋាប់ ជុ ដ្រុនដ្រូម អ៊ែ ណគ់ ដើ មែ ណគ ឡើ រ៉ើះ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ហំប៊្រុះ បូវ លុកស៊ិក ណគ ណាគ់ ជិត រ៉ា ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ មាំ ទុត ខាក់ ដើ យ៉ាគ់ យ៉ាកុប អំប្រា យ៉ាគ់ យ៉ូហាន។ ");
INSERT INTO brb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កឡូវ លែក ដើ បូវ លុកស៊ិក មន់ដក់ ហឹ ណគ ឡើ ម៉ាង រៀន៖ «វែ វ៉ើ ណោះ ឡើយ ទឹង សុនសាត អង់គែងៗ ណគ់ មែ កឡា ពែក ប៉ាក់ ម៉ើ ឈិះ ឆាន់ ប៉ាសាសុន កឡឹ ដើម មែ ទិះ ក្រាគ់ ម៉ើ ប៊ិច អាតណាត ពង់ខំ ប៉្រៃ បើម តាម ពន់ដ្រៃ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","អ៊ែ ណគ់ ដើ វែ អន់ណាវ ញ៉ង វន់បើម អ៊ឺម ប៉ាគ់ អ៊ែ។ ហាក់ ប៉ាគ់ មែ ង៉ាយ ទឹង បូវ វែ លំងុញ បើម ទិះ ក្រាគ់ ណគ អ៊ែ លំត្រ បើម ឞយ វែ។ ");
INSERT INTO brb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ដើម មែ ង៉ាយ ទឹង បូវ វែ លំងុញ បើម ណាយ ណគ អ៊ែ លំត្រ ក៝ត វែ លែក រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","យ៉ាក់ កួន បនឹះ ឡើ ទឺះ ទិ នែ ត្រ អ៊ឺម ឡើ ទឺះ បក់ មន់បើម ឞយ ណគ ឡើ ទឺះ បក់ លំបើម ឞយ មែ អន់ណាវ ដើម បក់ លំម៉ប ចាក់ ណគ អាំ លំឡោះ បនឹះ ទុត អើន»។ ");
INSERT INTO brb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ប៊ឹះ មួង យែរីខូ។ តគ់ ម៉ើ វីះ តើម ប៊ឹង មួង ហង់អ៊ែ ប៊ិច បនឹះ ទុត អើន ម៉ើ តូយ មែ ប៉ាគ់ទឺ។ តៃ ទ្រូង អ៊ែ ប៊ិច បឹ សូត ម៉ាត់ មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ បារទីមែ កួន យ៉ាគ់ ទីមែ ឡើ ដ្រូម ឡា លៀន ដៀក ទ្រូង។ ");
INSERT INTO brb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ហំប៊្រុះ ឡើ ដុង គ្រែដៃ យែស៊ូ ស៊្រុក ណាសារែត ឡើ ដក់ តៃ អ៊ែ ឡើ កឡូវ ថាំងៗ រៀន៖ «ឡា យ៉ាគ់ យែស៊ូ ហកន់ស៊ែ យូ សឋិច ដាវីត អើយ ហំស្រុស្រៀត អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","បនឹះ ទុត អើន ម៉ើ គឹះ ណគ ម៉ើ ប៉្រៃ លំគូ ខៀង។ ហាក់ សរ៉ើម ចាំ ថាំងៗ ឡើ កឡូវ រៀន៖ «ឡា យ៉ាគ់ ហកន់ស៊ែ យូ សឋិច ដាវីត អើយ ហំស្រុស្រៀត អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","គ្រែដៃ យែស៊ូ ឡើ ជឹង ប្រយ ឡើ ម៉ាង រៀន៖ «វន់កឡូវ ណគ ដក់ ហឹ អៃ នែ»។ អ៊ែ ម៉ើ កឡូវ បឹ ឡើ សូត ម៉ើ ម៉ាង ដើ ណគ រៀន៖ «ញ៉ង ហច្រៃ អ៊ឺម ហំឌឹក ឆុង ឡើ កឡូវ ហៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ហំប៊្រុះ ដើ អ៊ែ ឡើ តោះ តាក់ អាវ ទិះ ណគ ឡើ ឌឹក ឃុត ឡើ ដក់ ប្រយ ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","គ្រែដៃ យែស៊ូ ឡើ តង៉ា ណគ រៀន៖ «អង់ង៉ាយ ហងុញ អំប៉ូរ ហៃ?»។ បឹ សូត ម៉ាត់ ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ ណាយឃូ អឡា ម៉ាត់ អៃ លំត្រប៉ៃ ប៉ាគ់ ពន់ឋើម ទឺ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ហន់ជឹ ហំមិញ! យ៉ាក់ ហមឹង អៃ អ៊ែ ហនៀម»។ ហំប៊្រុះ ដើ អ៊ែ ម៉ាត់ ណគ ឡើ ត្រប៉ៃ អ៊ែ ឡើ តូយ ប្រយ គ្រែដៃ យែស៊ូ ទឹង ទ្រូង។ ");
INSERT INTO brb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ប៊ឹង គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ដៀប មន់ប៊ឹះ មួង យែរូសាឡឹម ចើម ស៊្រុក ប៊ែតផាស៊ែ ដើម ស៊្រុក ប៊ែថានី ប្លះ ក្រជែង សាង ចន់ឌូ តើម អូលីវ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ លុកស៊ិក ណគ បារ រ៉ា ដក់ អន់នួរ។ ");
INSERT INTO brb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ឡើ ថាន់ រៀន៖ «មិញ សប្រា លំដក់ ស៊្រុក ហឹ ងឺរ តគ់ ហំប៊្រុះ សប្រា លំមឹត ស៊្រុក សប្រា លំតៃ ម៉ើ ចង លៀ សារ អន់សារ មូយ ប៊ឹង អ៊ែ ញឹះ តៃ ប៊ិច មែ ង៉ាយ អំម៉ឹះ មន់ឈិះ។ អ៊ែ សប្រា លំឡិះ ជឹ ទឹក តៀត ហឹ អៃ។ ");
INSERT INTO brb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ប៉ាគ់ ប៊ិច មែ ង៉ាយ មន់តង៉ា រៀន “សប្រា ឡិះ បើម ង៉ាយ ដើ លៀ?” សប្រា លំត្រណើវ រៀន “យ៉ាគ់ កន់ដ្រាគ់ ឡើ តងកាន ប៊្លី អ៊ែ លំប៉្រៃ មែ មន់ជឹ ឈូន ដ្រិះៗ ហឹ នែ ទឺ”»។ ");
INSERT INTO brb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","អ៊ែ អំប្រា វីះ ប្រយ អំប្រា តៃ លៀ សារ អន់សារ ម៉ើ ចង ប៊ឹង ឝឡោះ ហន់ណាម ដៀក ទ្រូង អ៊ែ អំប្រា ឡិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ប៊ិច មែ អន់នឺ ម៉ើ គូ ប៊ឹង អ៊ែ ម៉ើ តង៉ា អំប្រា រៀន៖ «សប្រា បើម ង៉ាយ ប៉ាគ់ នែ? ពយ៉ិ ឡើ ត្រ សប្រា ឡិះ ដើ លៀ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","អ៊ែ អំប្រា ត្រណើវ តាម ប៉ាគ់ គ្រែដៃ យែស៊ូ ឡើ ថាន់ អ៊ែ ណាគ់ ម៉ើ អាំ ដើ អំប្រា ទឹក ជឹ តៀត។ ");
INSERT INTO brb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","អំប្រា ទឹក ជឹ តៀត អាំ ដើ គ្រែដៃ យែស៊ូ ដើម អំប្រា សើវ ដើ អាវ អំប្រា ពឺង កណង លៀ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឌឹក ឈិះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ប៊ិច បនឹះ ទុត អើន ម៉ើ សើវ ទ្រូង ដើ អាវ ម៉ើ កឡឹ មែ អន់នឺ អន់ណាវ ម៉ើ សើវ រ៉ាច កៀង ហឡា ឡង ណគ់ ម៉ើ ច្រិះ អន់ឌូ តើម ប៊ឹង មឺរ។ ");
INSERT INTO brb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","មែ ម៉ើ ដក់ អរែង ប៊ឹង គ្រែដៃ យែស៊ូ តៃ ម៉ាង តៃ ងឺរ តៃ ម៉ាង តៃ ត្រិច ម៉ើ ហូ រៀន៖ «ហូសាណា! ឡា គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ បឹ ឡើ ប៊ឹះ ទឹង ម៉ាត់ គ្រែដៃ កន់ដ្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ឡា គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ ណគ លំពែក ប៉ាក់ ប៉ាគ់ សឋិច ដាវីត ឡើ ពែក ប៉ាក់ ឡៃ មាំង ទឺ! ហូសាណា កាន ព្រតឹះ ព្រនែ លំលឺ អន់តើរ ទឹង ហូង ឈ្រូង តៃ ឋាំ!»។ ");
INSERT INTO brb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","គ្រែដៃ យែស៊ូ តគ់ ឡើ ប៊ឹះ មួង យែរូសាឡឹម ឡើ មឹត ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ទឹង អ៊ែ ឡើ ហន់នៀប ឝ្លាំង ត្រំ អង់ង៉ាយៗ។ ប៊្លី អ៊ែ ឡើ ដក់ គូ ហឹ ស៊្រុក ប៊ែថានី ដើម លុកស៊ិក ណគ លែក ជិត បារ រ៉ា យ៉ាក់ ដៀប ឡើ អំប៊ឹ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ងឹប ប្រណូវ ទឹង ប៉ះ ម៉ើ វីះ តើម ប៊ឹង ស៊្រុក ប៊ែថានី គ្រែដៃ យែស៊ូ ឡើ ពងួត។ ");
INSERT INTO brb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ឡើ តៃ ឡង កប៉ក់ មូយ តើម តើម ប៊ឹង ចង៉ាយៗ ហឡា ណគ តូវ ឡើ ខៀវ អ៊ែ ឡើ ដក់ ឝ្លាំង អំប លំប៉្លៃ។ ឡើ ប៊ឹះ តគ់ អ៊ែ ឡើ តៃ វ៉ិះ ឌិវ ហឡា មិៗ យ៉ាក់ ឡើ ប៊ឹះ អំម៉ឹះ ញ៉ាម ប៉្លៃ។ ");
INSERT INTO brb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","គ្រែដៃ យែស៊ូ ឡើ ប្រាយ តើម កប៉ក់ អ៊ែ រៀន៖ «តើម ប៊ឹង នែ ឞិះ ហឹ ងឺរ តគ់ ញ៉ង ហពឺរ ប៉្លៃ យ៉ាវ!»។ បូវ លុកស៊ិក ម៉ើ ដុង ប៉ាគ់ទឺ ប្រម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ប៊ឹះ ហឹ មួង យែរូសាឡឹម ម៉ើ មឹត ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តវីះ មែ ម៉ើ ហំពួត រួត ទឹង អ៊ែ។ ឡើ ឝឹ តាក់ តូក មែ ម៉ើ វ៉ាក់ លៀន ដើម កតាំង មែ ម៉ើ ហំពួត កំប៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ដើម ញឹះ តៃ ឡើ អាំ មែ ង៉ាយ មន់កួយ ទូង រ៉ាះ អំបាះ ក្លង ឡាត់ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន មែ រៀន៖ «ទឹង ពឹម គ្រែដៃ គ្រែដៃ ឡើ ហាយ រៀន រ៉ូង អៃ នែ ឡើ ត្រ រ៉ូង បនឹះ ត្រំ សាត មន់ដក់ អ៊ឺរ ដាំង អៃ ហវ៉ៃ ណគ់ ដើ វែ អន់ណាវ រ៉ូង អៃ នែ វ៉ើ បើម កនូ មែ តទូង ចចក់ អន់ណាវ »។ ");
INSERT INTO brb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ ដុង កាន ណគ ឡើ ម៉ាង។ អ៊ែ ម៉ើ ដាំង វិធី កជែត ណគ ញ៉ន ម៉ើ ឌូង ដើ ណគ យ៉ាក់ មែ ប៉ាសាសុន ម៉ើ គឺត ចង់ហៀង ទុត ខាក់ កាន ណគ ឡើ ពង់ហៀន។ ");
INSERT INTO brb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","តគ់ ឡើ អំប៊ឹ ឡើយ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ វីះ តើម ប៊ឹង មួង ហង់អ៊ែ ជឹ វឹញ កី ហឹ ស៊្រុក ប៊ែថានី។ ");
INSERT INTO brb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","តគ់ ងឹប ទឹង ម៉ើ ដក់ តៃ ទ្រូង អន់ទឺ អន់ណាវ បូវ លុកស៊ិក ម៉ើ តៃ តើម កប៉ក់ ឡើ រ៉ូយ រ៉ាក គែត តើម ទិ ដូច ប៊ឹះ រៀះ។ ");
INSERT INTO brb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","យ៉ាគ់ ពែត្រុះ ឡើ ចនិះ ហឹ គ្រែដៃ យែស៊ូ ឡើ ប្រាយ អ៊ែ ឡើ ហាយ រៀន៖ «យ៉ាគ់ ណាយឃូ តគ់ ហន់ឝ្លាំង! តើម កប៉ក់ ណគ់ ហៃ ហប្រាយ ដមាំង ណិះៗ ឡើ គែត តូវ ឡើ រ៉ូយ រ៉ាក ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ បូវ លុកស៊ិក រៀន៖ «វន់ចាប់ មឹង គ្រែដៃ យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ មែ ង៉ាយ លំប៉្រៃ ដើ ចន់ឌូ អន់នែ រៀន “ហំវីះ តើម ប៊ឹង ឞន អន់នែ ហន់គ្លីះ ទិ ដាក សមុត ចុ!” អ៊ែ ប៉ាគ់ លំចាប់ មឹង កាន ណគ ឡើ ឡា នែ លំកើត ញឹះ តៃ អ៊ឹនព្រឹះ អ៊ែ គ្រែដៃ លំបើម តាម ប្រម៉ាង ណគ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ញ៉ន ដើ អ៊ែ ឡើយ អៃ អហាយ ដើ វែ រៀន ប៊ឹង វ៉ើ អ៊ឺរ ដាំង ឡា អង់ង៉ាយ កតាម ទឹង គ្រែដៃ តង វន់មឹង រៀន មូយ វ៉ើ ដូវ ឡើយ អ៊ែ គ្រែដៃ លំអាំ ដើ វែ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","មូយ ឡឹះ អន់ណាវ ប៊ឹង វន់ឆុង អ៊ឺរ ដាំង គ្រែដៃ ប៉ាគ់ វន់មាំ ដើ មែ ង៉ាយ មូយ រ៉ា វន់តាក់ ថូត ដើ ណគ អ៊ែ គ្រែដៃ បើគ វែ ឡើ គូ ទឹង ហូង គ្រែ លំតាក់ ប៉ាគ់ទឺ អ្រយូច ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ហាក់ ប៉ាគ់ តៃ វន់តាក់ ថូត ដើ មែ គ្រែដៃ បើគ ឡើ គូ ទឹង ហូង គ្រែ លំតាក់ អ៊ឺម ប៉ាគ់ទឺ អ្រយូច ដើ វែ »។ ");
INSERT INTO brb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ប៊ឹះ ឡឹះ ហឹ មួង យែរូសាឡឹម។ ទឹង ប៉ះ គ្រែដៃ យែស៊ូ ឡើ អន់ឆូវ ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ បូវ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ដក់ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ម៉ើ តង៉ា ណគ រៀន៖ «ហបើម កាន លែក នែ ហអ៊ីង ដើ អាតណាត មែ ង៉ាយ? មែ ង៉ាយ ម៉ើ អាំ អាតណាត ដើ ហៃ ហដូវ បើម កាន លែក នែ?» ");
INSERT INTO brb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «អៃ អន់តង៉ា ប៉ាគ់ទឺ វែ មូយ ខ ប៉ាគ់ វន់ហាយ ដើ អៃ អ៊ែ អៃ អង់ហាយ ប៉ាគ់ទឺ ដើ វែ រៀន លែក ដើ កាន អៃ អបើម អ៊ែ អអ៊ីង ដើ អាតណាត មែ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ឡើ តង៉ា មែ រៀន៖ «មែ ង៉ាយ ឡើ អាំ អាតណាត ដើ យ៉ាគ់ យ៉ូហាន បើម ឞ៊ុន តម៉ូច ដាក? គ្រែដៃ លឺ បនឹះ? ហឹ វន់ត្រណើវ ឡាំង»។ ");
INSERT INTO brb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ប៉ាគ់ ងន់ហាយ រៀន គ្រែដៃ ឡើ អាំ ឝ៉ាន់ លំម៉ាង ដើ ង៉ាយ រៀន “បាយ តៃ វ៉ើ ឌី ចាប់ ប្រម៉ាង យ៉ាគ់ យ៉ូហាន ដឹះ?”»។ ");
INSERT INTO brb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ហាក់ ម៉ើ ហាន អ៊ឺម មន់ត្រណើវ រៀន បនឹះ ម៉ើ អាំ ម៉ើ ឌូង ដើ ប៉ាសាសុន យ៉ាក់ បនឹះ លែក រ៉ា ម៉ើ ជុ យ៉ាគ់ យ៉ូហាន អ៊ែ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ប៉ាគ់ ពអ៊ែ ម៉ើ ត្រណើវ រៀន៖ «ញ៉ើ ណោះ អ៊ឺម ញ៉ា!»។ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ប៉ាគ់ ពអ៊ិន ដើ អៃ អង់ហាយ អ៊ឺម ប៉ាគ់ទឺ ដើ វែ រៀន អបើម កាន លែក នែ អអ៊ីង ដើ អាតណាត មែ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ដើ មែ រៀន៖ «ប៊ិច កឡ មូយ រ៉ា ឡើ បើម មឺរ ដាំ ឈឹង ជែម។ ឡើ បើម រំឞង ឈុំ មឺរ អ៊ែ ឡើ ប៉ោះ តម៉ ដដារ បើម លុងៗ បនឹង ដាក ប៉្លៃ ឈឹង ជែម ដើម ឡើ បើម ហំប៉ាង ឈ្រុងឈ្រូង ចាំ មឺរ។ ប៊្លី អ៊ែ ឡើ អាំ ដើ មែ មន់រន់ឋាប់ ឝ្លាំង មឺរ ណគ ឡើ ប៉្រៃ មន់ប៉ាក ប៉្លៃ ដើ ណគ ត្រំ កម៉ ណគ កឡឹ ឡើ វីះ ហឹ ស្រុក ទុត ចង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","តគ់ ឡើ ប៊ឹះ ញ៉ាម ប៉្លៃ ឈឹង ជែម ឡើ ឌុំ កន់ដ្រាគ់ មឺរ អ៊ែ ឡើ ប៉្រៃ ឞយ ណគ មូយ រ៉ា ដក់ ចក់ ប៉្លៃ ពណាក ណគ ហឹ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ។ ");
INSERT INTO brb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ហាក់ ណគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ អ៊ែ ម៉ើ រ៉ាប់ បឹត ណគ អ៊ែ ម៉ើ បយឹ ជឹ វឹញ ទី មិៗ។ ");
INSERT INTO brb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","កន់ដ្រាគ់ មឺរ ឡើ ប៉្រៃ ឡឹះ ឞយ ណគ បឹ លមូយ អន់ណាវ លន់ដក់ ចក់ ហាក់ ណគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ អ៊ែ ម៉ើ បឹត ទូះ ឞយ ណគ ដើម ម៉ើ ព្រសាក ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","កន់ដ្រាគ់ មឺរ អ៊ែ ឡើ ប៉្រៃ ឞយ អង់គែង អន់ណាវ ដក់។ ណគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ ម៉ើ កជែត តាក់។ ប៊្លី អ៊ែ ឡើ ប៉្រៃ ឞយ ទុត អើន អន់ណាវ ម៉ើ ដក់ ឡឹះ មែ អន់នឺ ម៉ើ បឹត ប៊ឹម មែ អន់នឺ ឡើ ត្រ ម៉ើ កជែត។ ");
INSERT INTO brb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","តគ់ អន់ទុនៗ វ៉ិះ ណាគ់ មូយ លំដូវ ប៉្រៃ ដក់ ហឹ មឺរ អ៊ិន កួន កឡ ប្រម៉ើត ណគ កឡឹ។ អ៊ែ ឡើ ប៉្រៃ លំដក់ ឡើ ឃឹត រៀន “អាត មន់អៀល បឹះ ឡើយ កួន អៃ នែ”។ ");
INSERT INTO brb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ហាក់ ណគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ អ៊ែ ម៉ើ តៃ កួន កឡ ណគ ឡើ ប៊ឹះ អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន “ណគ នែ ឡើយ លំដូវ មឺរ នែ លំបើម មូន ខៃ ណូវ។ ញ៉ាគ់ ញំកជែត ណគ អ៊ែ មឺរ នែ លំត្រ មឺរ ង៉ាយ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","អ៊ែ ម៉ើ រ៉ាប់ កជែត កួន កន់ដ្រាគ់ មឺរ ប៊្លី អ៊ែ ម៉ើ យ៉ង់យ៉ូត ពៀវ តាក់ ហឹ ដៀក មឺរ»។ ");
INSERT INTO brb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «កន់ដ្រាគ់ មឺរ អ៊ែ ប៉ាគ់ ង៉ាយ អន់ណាវ លំបើម? ណគ លំដក់ កជែត ឡើយ មែ ប៊្លី អ៊ែ លំអាំ ដើ មែ គែង អន់ណាវ មន់រន់ឋាប់ ឝ្លាំង មឺរ។ ");
INSERT INTO brb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","វែ វ៉ើ អាន អ៊ឺម ឡះ ប្រម៉ាង នែ ទឹង ពឹម គ្រែដៃ ឡើ រៀន៖ “តម៉ ណគ់ មែ ម៉ើ បើម ហន់ណាម ម៉ើ ពៀវ តាក់ ឡើយ ឡើ វឹរ តម៉ ឡើ ប៊ិច ខា ណាគ់ ជឺរ អ៊ែ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","កាន នែ គ្រែដៃ កន់ដ្រាគ់ ឡើ បើម ង៉ើ តៃ ដើម ង៉ើ ញ៉ម ទុត ខាក់”»។ ");
INSERT INTO brb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","មែ ទិះ ក្រាគ់ សុនសាត យូដា ម៉ើ ណោះ រៀន គ្រែដៃ យែស៊ូ ឡើ គឹះ មែ ដើ ប្រម៉ាង ចនីរ អ៊ែ ម៉ើ ទែង រ៉ាប់ ណគ ពញ៉ង ណាគ់ ម៉ើ ឌូង ដើ មែ ប៉ាសាសុន អ៊ែ ម៉ើ វីះ តើម ប៊ឹង គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ប៊្លី អ៊ែ មែ ទិះ ក្រាគ់ សុនសាត យូដា ម៉ើ ប៉្រៃ បូវ មែ ផារីស៊ី ដើម បូវ មែ ម៉ើ ចក់ តៃ សឋិច ហ៊ែរ៉ូត អន់នឺ រ៉ា មន់ដក់ ហឹ គ្រែដៃ យែស៊ូ បក់ មន់ដូវ រ៉ាប់ អ្រយូច ណគ ប៊ឹង លំចជែ។ ");
INSERT INTO brb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","មែ ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ម៉ើ តង៉ា ណគ រៀន៖ «យ៉ាគ់ ណាយឃូ ញ៉ា ញ៉ើ ណោះ រៀន ហៃ ហបនឹះ ដាវ ឡាំង ញឹះ តៃ ហឌូង ដើ មែ ង៉ាយ អ៊ឺម សំយ៉ះ មែ ទិះ ក្រាគ់ លឺ មែ តៃ ម៉ាត ប៊ីត ណាគ់ តៃ ហច្រលែក អ៊ឺម កាន ហៃ ហពង់ហៀន អាំ មន់ដូវ បើម ត្រួយ ប្រម៉ើត គ្រែដៃ ឡើ ដាវ ម៉ាត់ ម៉ាត។ ហង់ហាយ ឡាំង ដើ ញ៉ា តាម ចឞាប់ សុនសាត ង៉ាយ ណាគ់ ដូវ ឡះ ងន់អាំ លៀន ដើ សឋិច ទិះ មួង រ៉ូម ឡើ កាគ់ ហឹ ង៉ាយ លឺ ដូវ អ៊ឺម? ពយ៉ិ ដើ ង៉ាយ នែ ណាគ់ ងន់អាំ លឺ អ៊ឺម?»។ ");
INSERT INTO brb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","គ្រែដៃ យែស៊ូ ឡើ ណោះ ម៉ើ ចជែ ពឃឺ ពរ៉គ់ ឌិវ បួរ អ៊ែ ឡើ ត្រណើវ រៀន៖ «ពយ៉ិ ឡើ ត្រ វ៉ើ បឡង ឝ្លាំង អៃ ប៉ាគ់ នែ? វន់ចក់ លៀន មែ រ៉ូម ដើ អៃ មូយ កាក់ អង់ឝ្លាំង ឡាំង»។ ");
INSERT INTO brb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","អ៊ែ ម៉ើ អាំ លៀន ដើ ណគ មូយ កាក់។ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ប៊ឹង កាក់ នែ ហ៊ូប មែ ង៉ាយ ម៉ាត់ មែ ង៉ាយ?»។ មែ ម៉ើ ត្រណើវ រៀន៖ «ហ៊ូប ដើម ម៉ាត់ សឋិច ទិះ មួង រ៉ូម»។ ");
INSERT INTO brb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ មែ រៀន៖ «ណគ់ អង់ង៉ាយ ឡើ ត្រ រ៉ាះ សឋិច ទិះ មួង រ៉ូម វន់អាំ ដើ សឋិច កឡឹ អ៊ែ ណគ់ អង់ង៉ាយ ឡើ ត្រ វន់ថួយ ដើ គ្រែដៃ វន់ថួយ អាំ ដើ ណគ កឡឹ»។ អ៊ែ ម៉ើ បើម ទុត ដើ ប្រម៉ាង ណគ ឡើ ត្រណើវ។ ");
INSERT INTO brb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","លែក ដើ មែ សាឌូស៊ី ម៉ើ ចាប់ រៀន បនឹះ គែត ប៊ិច យ៉ាវ មន់ញិវ ឡឹះ។ អ៊ែ ប៊ិច មែ សាឌូស៊ី អន់នឺ រ៉ា ម៉ើ ដក់ តង៉ា គ្រែដៃ យែស៊ូ ម៉ើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«យ៉ាគ់ ណាយឃូ! យ៉ាគ់ ម៉ូស៊ែ ឡើ ខៀន ជុ ចឞាប់ នែ ដើ ង៉ាយ រៀន “ប៉ាគ់ កឡ មូយ រ៉ា ឡើ ចក់ ទ្រី ប៊្លី អ៊ែ ឡើ គែត តាក់ ទ្រី ញឹះ តៃ ដាន់ ប៊ិច កួន អំម៉ឹះ អ៊ែ អោះ ណគ អន់ណាវ តង លំហ្រដូវ ម៉ី ណគ បក់ លំពឝ៉ើត កួន ថរ ម៉ាត់ អ៊ូគ ណគ”។ ");
INSERT INTO brb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ងំព្រឌីវ រៀន ប៊ិច អំម៉ោះ អោះ កឡ ប៉ឹះ រ៉ា។ អ៊ូគ ឡង់ មែ ឡើ ចក់ ទ្រី ប៊្លី អ៊ែ ឡើ គែត ញឹះ តៃ ដាន់ ប៊ិច កួន អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ប៊្លី អ៊ែ អោះ ប៊ឹង ងឺរ ណគ ឡើ ហ្រដូវ មី ណគ តៃ ដាន់ ប៊ិច កួន ឡើ គែត ប៉ាគ់ទឺ អោះ ទី បារ ប៉ាគ់ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ឆា ដើ លែក មែ ប៉ឹះ រ៉ា ម៉ើ គែត ញឹះ តៃ ប៊ិច កួន។ តគ់ ប៊្លី អ៊ែ កទ្រី នែ ឡើ គែត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ប៉ាគ់ ពអ៊ែ តគ់ បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ កទ្រី អ៊ែ លំត្រ ទ្រី មែ ង៉ាយ យ៉ាក់ លែក មែ ប៉ឹះ រ៉ា ម៉ាត់តូវ ក្ល ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «វែ វ៉ើ ឃឹត យូច ឡើយ យ៉ាក់ តៃ វ៉ើ ហឝ៉ាវ អ៊ឺម ពឹម គ្រែដៃ ដើម តៃ វ៉ើ ហង់ឝ៉ាវ កាន ឆង៉ាត់ គ្រែដៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","យ៉ាក់ តគ់ បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ ប៊ិច យ៉ាវ មន់ចក់ ទ្រី ក្ល មន់បើម ប៉ាគ់ ឞាវ គ្រែដៃ ទឹង ហូង គ្រែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","អ៊ែ ណគ់ កាន បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ ប៉ាគ់ ង៉ាយ វ៉ើ អាន អ៊ឺម ឡះ ទឹង ផាប់ យ៉ាគ់ ម៉ូស៊ែ ប៊ឹង យ៉ាគ់ ម៉ូស៊ែ ឡើ តៃ តើម ឆ្រឡា ឡើ កាត អ៊ុញ? ប៊ឹង អ៊ែ គ្រែដៃ ឡើ ហាយ ដើ ណគ រៀន “អៃ អគ្រែដៃ យ៉ាគ់ អាប្រាហាំ អ៊ីសាគ់ ដើម យ៉ាកុប”។ ");
INSERT INTO brb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","គ្រែដៃ នែ ត្រ អ៊ឺម ឡើ គ្រែដៃ ដើ បនឹះ គែត ឡើ គ្រែដៃ ដើ បនឹះ ញិវ ហវ៉ៃ។ វែ លែក រ៉ា វ៉ើ ឃឹត យូច ទុត ខាក់ ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ប៊ឹង អ៊ែ ប៊ិច បឹ ណាយឃូ ពង់ហៀន ចឞាប់ មូយ រ៉ា ឡើ ដុង ម៉ើ ចជែ ប៊ឹង គ្រែដៃ យែស៊ូ ដើម ឡើ ដុង គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ទុត ត្រ ម៉ាត់ ម៉ាត អ៊ែ ឡើ ដក់ ពន់ចើម តគ់ ណគ ឡើ តង៉ា រៀន៖ «លែក ដើ ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ មូយ ង៉ាយ ឡើ ខា ជឺរ?»។ ");
INSERT INTO brb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «នែ ឡើយ ចឞាប់ ឡើ ប៊ិច ខា ជឺរ “វែ អ៊ីស្រាអ៊ែល អើយ វន់ចង់ហៀង យ៉ឹ! ប៊ិច គ្រែដៃ វ៉ិះ ឌិវ មូយ ណគ អ៊ែ ឡើយ ឡើ កន់ដ្រាគ់ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","វែ វន់ត្រ ម៉ើត ដើ គ្រែដៃ ឡើ កន់ដ្រាគ់ វែ លែក ដើ ក្លើម ក្លាក លែក ដើ ផវ យ៉ាង លែក ដើ ចនិះ ដើម លែក ដើ ពន់ដ្រិញ ”។ អន់នែ ឡើយ ចឞាប់ ឡើ ប៊ិច ខា ជឺរ។ ");
INSERT INTO brb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","អ៊ែ ណគ់ ចឞាប់ ទី បារ អន់ណាវ “វន់ត្រ ម៉ើត ដើ បូវ ប៊ែង ឞាល់ វ៉ើ ម៉ើត ដើ ចាក់ វ៉ើ កឡឹ ទឺ ”។ តៃ ប៊ិច ចឞាប់ អង់ង៉ាយ យ៉ាវ លំខា ជឺរ លែក បារ ចឞាប់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ណាយឃូ ពង់ហៀន ចឞាប់ ឡើ ត្រណើវ រៀន៖ «ត្រ ឡើយ ណាយឃូ ហម៉ាង អ៊ិន ឡើ ដាវ ម៉ាត់ ម៉ាត ប៊ិច គ្រែដៃ វ៉ិះ ឌិវ មូយ អិះ ឡើយ ប៊ិច យ៉ាវ គ្រែដៃ គែង ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ដើម ងន់ត្រ ម៉ើត គ្រែដៃ លែក ដើ ក្លើម ក្លាក លែក ដើ អ្រណោះ លែក ដើ ពន់ដ្រិញ ដើម ងន់ត្រ ម៉ើត បូវ ប៊ែង ឞាល់ ង៉ើ ម៉ើត ចាក់ ង៉ាយ កឡឹ ទឺ។ អន់នែ ឡើយ ឡើ ចាគ់ ជឺរ លែក ដើ ពត្រូវ ង៉ើ ប៊ុះ ថួយ ម៉ប ហឹ គ្រែដៃ ដើម ថនួយ អង់គែងៗ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","គ្រែដៃ យែស៊ូ ឡើ ដុង ឡើ ត្រណើវ ដើ ហ្រឡិច ហ្រឡាង ប៉ាគ់ អ៊ែ អ៊ែ ឡើ ហាយ ដើ ណគ រៀន៖ «ដៀប ហអាំ គ្រែដៃ ឡើ ពែក ប៉ាក់ ហៃ ឡើយ»។ តើម ប៊ឹង អ៊ែ តៃ ប៊ិច មែ ង៉ាយ យ៉ាវ មន់ហាន តង៉ា ឡឹះ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","គ្រែដៃ យែស៊ូ ណាគ់ ទឹង ឡើ ពង់ហៀន មែ ប៉ាសាសុន ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ តង៉ា មែ រៀន៖ «ប៉ាគ់ ង៉ាយ ឡើ ត្រ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ រៀន គ្រែដៃ គ្រិះ ឡើ កួន ចូវ សឋិច ដាវីត? ");
INSERT INTO brb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","សឋិច ដាវីត កឡឹ ឡើ ម៉ាង តាម លញ៉ាគ់ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ រៀន៖ “គ្រែដៃ កន់ដ្រាគ់ ឡើ ហាយ ដើ កន់ដ្រាគ់ អៃ រៀន ហន់ឌឹក ដ្រូម តៃ ចម៉ា អៃ ទឹង ហូច អំពញ៉ម ណគ់ មែ ម៉ើ ដ្រម៉ា ដើ ហៃ អំជុ មែ ក្រូម ត្រប៉ាង ឈឹង ហៃ ”»។ ");
INSERT INTO brb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«ប៉ាគ់ សឋិច ដាវីត កឡឹ ឡើ ជុ គ្រែដៃ គ្រិះ រៀន “កន់ដ្រាគ់ ណគ” អ៊ែ ពយ៉ិ លំប៉ិន គ្រែដៃ គ្រិះ នែ លំកួន ចូវ សឋិច ដាវីត ប៉ាគ់ អ៊ិន?»។ មែ ប៉ាសាសុន ទុត អើន ម៉ើ ញឹម ក្លើម ម៉ើ ចង់ហៀង ប្រម៉ាង គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ប៊ឹង ឡើ ពង់ហៀន មែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «វន់លវាំង ម៉ាត់ ម៉ាត យ៉ឹ ដើ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ បូវ មែ អ៊ែ ម៉ើ ឍុ ហក អាវ ឌ្រឹម ចណុង ចណាគ់ ម៉ើ អន់ឆូវ ពយ៉ូក ចាក់ វឹញ ដក់ៗ ដើម ម៉ើ ម៉ើត បូវ ហឹ តឡាត មន់ហំបះ មែ ដិ ");
INSERT INTO brb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ដើម ម៉ើ ម៉ើត ដ្រូម ទឹង រ៉ូង ពស៊ុំ ហឹ ងឺរ បូវ អាំ លំឃឺ ដើម ម៉ើ ម៉ើត ដ្រូម ប៊ឹង ដ្រុនដ្រូម យ៉ូក យ៉ាល់ ទឹង ឞន ញែត ចង់ ទុត ទិះ។ ");
INSERT INTO brb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ម៉ើ អ្យគ់ តបូត ចក់ ហន់ណាម រ៉ាះ អំបាះ មែ ម៉ិយូ កម៉ាយ ដើម ម៉ើ អ៊ឺរ ដាំង គ្រែដៃ ទុត ឌុញ ឃឺ អង់ឃឺ។ បូវ មែ នែ មន់ត្រ ថូត ទុត កយឹក ជឺរ បនឹះ ហឹ គែង អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដ្រូម អាំ ងឺរ ហឹ ហ៊ីប ចនុ លៀន ម៉ប អាំ ដើ គ្រែដៃ ឡើ ឝ្លាំង មែ ប៉ាសាសុន ម៉ើ ដក់ កលីះ លៀន ទឹង ហ៊ីប អ៊ែ។ ឡើ តៃ ណគ់ មែ ម៉ើ ប្រនិច ទុត អើន ម៉ើ កលីះ លៀន អើន ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ទឹង អ៊ែ ប៊ិច កទ្រី កម៉ាយ មូយ រ៉ា ឡើ ធុក ញ៉ាក ទុត ខាក់ ឡើ ប៊ឹះ ឡើ កលីះ លៀន កិៗ វ៉ិះ ឌិវ បារ កាក់ ទឹង ហ៊ីប ហង់អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","គ្រែដៃ យែស៊ូ ឡើ កឡូវ មែ លុកស៊ិក ដក់ ហឹ ណគ អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន កទ្រី កម៉ាយ ធុក ញ៉ាក អន់នែ ឡើ កលីះ លៀន ទឹង ហ៊ីប អើន ជឺរ បូវ ");
INSERT INTO brb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","យ៉ាក់ មែ លែក នែ ម៉ើ កលីះ លៀន មែ ណគ់ ឡើ ស៊ិវ។ អ៊ែ ណគ់ ដើ កទ្រី កម៉ាយ អន់នែ អន់ណាវ សំយ៉ះ ឡើ ធុក ញ៉ាក ឞាល់ ង៉ាយ កតាម លែក ដើ ប្រនិច ឡើ ជុ រ៉ាក់ ចាក់ ណាគ់ ឡើ កលីះ ទឹង ហ៊ីប»។ ");
INSERT INTO brb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ប៊ិច លុកស៊ិក ណគ មូយ រ៉ា ឡើ ពដៃ រៀន៖ «យ៉ាគ់ ណាយឃូ តគ់ ហន់ឝ្លាំង តម៉ ចាគ់ ទុត ទិះ សណិច ឌិះ ត្រំ រ៉ូង ឡើ ចាគ់ ប៉ាគ់ទឺ!»។ ");
INSERT INTO brb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ម៉ាង លុកស៊ិក អ៊ែ រៀន៖ «ហន់ឝ្លាំង រ៉ូង ទិះ លែក នែ ហឹ តង៉ៃ អន់ទុន លំប៊្លឺគ ដឡាយ លែក តាក់ ប៊ិច យ៉ាវ តម៉ លំព្រឌឺន ពឺង តម៉ ឡឹះ អន់ណាវ យ៉ាក់ មែ ដ្រម៉ា មន់ឝឹ តាក់ លែក»។ ");
INSERT INTO brb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ប៊្លី អ៊ែ តគ់ គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ទឹង ចន់ឌូ តើម អូលីវ ហ្រទឹង ដើ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ាកុប យ៉ាគ់ យ៉ូហាន ដើម យ៉ាគ់ អន់ឌ្រែ ឌិវ មែ ម៉ើ គូ ចើម គ្រែដៃ យែស៊ូ អ៊ែ ម៉ើ តង៉ា ពឡាក់ ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ឡា ហំហាយ ដើ ញ៉ា កាន លែក នែ ដមិញ លំកើត? ប៊ឹង ង៉ាយ ដឹះ ញំណោះ ហង់ឝ៉ាវ កាន អ៊ិន ដៀប លំប៊ឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","គ្រែដៃ យែស៊ូ ឡើ ថាន់ មែ រៀន៖ «វន់លវាំង យ៉ឹ ញ៉ង វ៉ើ បូត អ៊ឺម ដើ មែ មន់ដាំង តបូត វែ។ ");
INSERT INTO brb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","យ៉ាក់ លំប៊ិច បនឹះ ទុត អើន មន់ចើះ ចាក់ ម៉ាត់ អៃ មន់ហាយ រៀន “អៃ នែ ឡើយ អគ្រែដៃ គ្រិះ!”។ អ៊ែ មន់តបូត បនឹះ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ប៊ឹង វន់ដុង ប៊ិច កាន ប្រណើម ចើម តមឹង ចង៉ាយ តមឹង ញ៉ង វ៉ើ ឌូង អ៊ឺម យ៉ាក់ កាន ប្រណើម អ៊ែ តង លំប៊ិច ម៉ាត់ ម៉ាត ហាក់ ដាន់ អំម៉ឹះ ឡាង ប្រិះ ឡាង គ្រែ លំឡូច។ ");
INSERT INTO brb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","សុនសាត មូយ មន់ប្រណើម ដើ សុនសាត មូយ ពធែត មូយ មន់ប្រណើម ដើ ពធែត មូយ អន់ណាវ។ ប្លះ ឞន ទុត អើន ឡាង ប្រិះ លំអង់ឝឹត ដើម លំប៊ិច កាន អឹត ហរុ ដិ។ កាន លែក នែ ឡើ បើម ប៉ាគ់ ឆនិ អន់ចិះ អន់ចាំ មែ កទ្រី ទឹង ម៉ើ ឈិ អន់ឆិ។ ");
INSERT INTO brb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ហាក់ ដើ វែ អន់ណាវ តង វន់លវាំង ចាក់ យ៉ឹ យ៉ាក់ មែ មន់រ៉ាប់ តៀត វែ ហឹ មែ ទិះ ក្រាគ់ តាត់ កឍី មន់បឹត វែ ទឹង រ៉ូង ពស៊ុំ ដើម មន់តៀត វែ ហឹ មែ ទិះ ក្រាគ់ ពែក ប៉ាក់ ដើម ហឹ មែ សឋិច អាំ មន់ពថូត វែ ញ៉ន ដើ វ៉ើ តូយ អៃ កាន នែ លំបើម អាំ វែ វន់ប៊ិច ទ្រូង ពហាយ កាន គ្រែដៃ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ លន់ត្រ មន់ពហាយ អាំ ដើ បនឹះ ត្រំ សាត មន់ដុង អន់ដៃ។ ");
INSERT INTO brb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ប៊ឹង មន់រ៉ាប់ ឈូន វែ ហឹ កឡា តាត់ កឍី ញ៉ង វ៉ើ ឌូង ច្រៃ អន់នួរ អ៊ឺម កាន វែ វន់ត្រណើវ អ៊ែ វន់ត្រណើវ តាម ប្រម៉ាង គ្រែដៃ លំអាំ ដើ វែ ប៊ឹង អ៊ែ យ៉ាក់ តៃ ត្រ វែ អ៊ឺម វន់ម៉ាង ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ លំម៉ាង តាម លញ៉ាគ់ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«ត អំម៉ោះ អោះ កឡឹ មន់តៀត ហឹ មែ មន់កជែត បើគ លំតៀត កួន កឡឹ ហឹ មែ មន់កជែត អ៊ែ ណគ់ កួន មន់ដ្រម៉ា ដើ មែគ បើគ កឡឹ ដើម មន់តៀត ហឹ មែ មន់កជែត ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","លែក ដើ បនឹះ ញឹះ តៃ មន់រែម ឡាំងៗ ដើ វែ ញ៉ន ដើ វ៉ើ តូយ អៃ។ ហាក់ ណគ់ មែ ង៉ាយ មន់បក់ អុតថុន ឆា ដើ ឡូច មែ អ៊ែ ឡើយ គ្រែដៃ លំហវ៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«តង៉ៃ ង៉ាយ វន់តៃ កាន តៃ ចាគ់ បើម ហំម៉ឹ លំឆុង ប៊ឹង ឞន តៃ លំឃឺ ឆុង (ឡា អាំ មែ ម៉ើ កឡា អាន កាន អន់នែ មន់ឃឹត អាំ ណោះ ហឡាក់ យ៉ឹ។) ប៊ឹង អ៊ែ ណគ់ មែ ម៉ើ គូ ទឹង ស្រុក យូដា មន់ត្រ អ្រយ៉ាវ ព្រដិច ចាក់ ទឹង ចន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","អ៊ែ ណគ់ មែ ម៉ើ គូ ទឹង បូយ ហន់ណាម មន់ទឺះ អ្រយ៉ាវ ញ៉ង ម៉ើ មឹត ចក់ យ៉ាវ រ៉ាះ អំបាះ ហឹ កនុង ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ណគ់ មែ ម៉ើ គូ ហឹ មឺរ មន់ត្រ វីះ ញ៉ង ម៉ើ ជឹ វឹញ ចក់ យ៉ាវ អាវ ឌ្រឹម មែ ហឹ ស៊្រុក។ ");
INSERT INTO brb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ទឹង អ៊ែ ណគ់ មែ កទ្រី តមែវ តៃ ម៉ាង មែ កទ្រី តពុ កួន មន់ធុក ញ៉ាក ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","មិញ វន់អ៊ឺរ ដាំង គ្រែដៃ ញ៉ង អាំ កាន នែ លំប៊ិច ទឹង ញ៉ាម ឆឈុយ។ ");
INSERT INTO brb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","យ៉ាក់ ទឹង អ៊ែ លំប៊ិច កាន ធុក ញ៉ាក ប៉ាប ពុន ទុត ខាក់ តើម ប៊ឹង គ្រែដៃ ឡើ ពឝ៉ើត ពដិះ គ្រែ ឆា ដើ ប៊ឹះ ត្រំ តង៉ៃ នែ សំយ៉ះ ហឹ ងឺរ តគ់ តៃ លំប៊ិច យ៉ាវ កាន ធុក ញ៉ាក ប៉ាក ម៉ង ញឹះ ឞាល់ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ប៉ាគ់ គ្រែដៃ កន់ដ្រាគ់ តៃ លំកើយ អន់នួរ តង៉ៃ លែក អ៊ែ តៃ ប៊ិច បនឹះ អង់ង៉ាយ អ៊ឺម មន់ញិវ ហាក់ គ្រែដៃ កន់ដ្រាគ់ ឡើ ពកើយ ឡើយ តង៉ៃ លែក អ៊ែ ញ៉ន ដើ បនឹះ ណគ់ ណគ ឡើ រ៉ើះ។ ");
INSERT INTO brb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ប៊ឹង អ៊ែ ប៉ាគ់ លំប៊ិច មែ មន់ហាយ ដើ វែ រៀន “គ្រែដៃ គ្រិះ ឡើ គូ ហឹ នែ លឺ ហឹ តគ់!” ញ៉ង វ៉ើ ចាប់ អ៊ឺម យ៉ឹ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","យ៉ាក់ លំប៊ិច បនឹះ អន់នឺ មន់ចើះ ចាក់ រៀន ម៉ើ គ្រែដៃ គ្រិះ ដើម លំប៊ិច មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឆ្រឡិ ឆ្រលួគ មែ លែក អ៊ែ មន់ពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ ដើម កាន បើម ញ៉ម ដិ អន់ដិ បក់ មន់តបូត បនឹះ ណគ់ គ្រែដៃ ឡើ រ៉ើះ ប៉ាគ់ ណាគ់ មន់ដូវ។ ");
INSERT INTO brb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ប៉ាគ់ ពអ៊ែ ហឹ វន់លវាំង យ៉ឹ យ៉ាក់ អៃ អហាយ អន់នួរ ឡើយ កាន លែក នែ ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«តគ់ កាន ធុក ញ៉ាក លែក នែ លំក្លើច ឡើយ ម៉ាត់ តង៉ៃ លំហ្រង៉ូម ប៊្រែ ណគ់ កើត លំឝ៉ាល យ៉ាវ ");
INSERT INTO brb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","អ៊ែ ពតួរ មន់គ្លីះ តើម ទិ គ្រែ ដើម គ្រែដៃ លំក្រស៊ូ អាំ លែក ទឹង ឡាង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ប៊ឹង អ៊ែ មន់តៃ កួន បនឹះ លប៊ឹះ ទឹង កឌី យូក ដឹប លំប៊ិច អាតណាត ឆង៉ាត់ ថាំង លំឝ៉ាល ទ្រឺញ។ ");
INSERT INTO brb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","លំប៉្រៃ បូវ ឞាវ ណគ មន់ដក់ លែក ពួន ចំឞ៊ែង ឡាង ប្រិះ បក់ មន់តមួត បូវ ណគ់ ណគ ឡើ រ៉ើះ តើម ប៊ឹង ម៉ាត់ តង៉ៃ ឌឹក ប៊ឹះ ម៉ាត់ តង៉ៃ លុច»។ ");
INSERT INTO brb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«ហឹ វន់ឃឹត អាំ ខាក់ កាន ព្រឌីវ ប៊ឹង តើម កប៉ក់ នែ ប៊ឹង វ៉ើ កគ់ តៃ ឝឹង ណគ ឡើ កយ៉ិ ហឡា ណគ ញឹះ ឡើ អៀវ អ៊ែ វ៉ើ ណោះ រៀន ដៀប លំប៊ឹះ ញ៉ាម ដុ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ពអ៊ែ ទឺ ឡើយ ប៊ឹង វន់តៃ កាន លែក អ៊ិន លំកើត អ៊ែ វន់ណោះ រៀន កួន បនឹះ ដៀប លំបឹះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន កាន លែក អ៊ែ លំកើត ទឹង បនឹះ ប៉ាង តណើរ អន់នែ តៃ ដាន់ មន់គែត លែក អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ឡាង ប្រិះ ឡាង គ្រែ លំឡាញ ប៉ាត់ ពណាត់ លែក អ៊ែ ណគ់ ប្រម៉ាង អៃ លំណាគ អន់សច លំប៉ាត់ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«អ៊ែ ណគ់ តង៉ៃ លឺ ម៉ូង កាន អ៊ិន លំកើត តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ ណោះ សំយ៉ះ ឞាវ គ្រែដៃ ទឹង ហូង គ្រែ លឺ កួន កឡ គ្រែដៃ ណាគ់ តៃ ម៉ើ ណោះ ប៉ាគ់ទឺ វ៉ិះ ឌិវ គ្រែដៃ បើគ កឡឹ ឡើ ណោះ។ ");
INSERT INTO brb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","វន់លវាំង ចាក់ ដើម វន់ថៀវ យ៉ឹ យ៉ាក់ វ៉ើ ណោះ អ៊ឺម កាន លែក នែ លំប៊ឹះ ណោះ តង៉ៃ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","តង៉ៃ លំប៊ឹះ អ៊ិន អំព្រឌីវ ប៊ឹង កឡ មូយ រ៉ា ឡើ វីះ ចង៉ាយ តើម ប៊ឹង ហន់ណាម ឡើ អាំ អាតណាត ដើ មែ ឞយ ណគ មន់ពឹត កាន ង៉ាន មែ កឡឹ ដឹប ឡើ ថាន់ បឹ កឡា ញ៉ាម ឝឡោះ ហន់ណាម លំថៀវ អាំ ទុត ខាក់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ប៉ាគ់ ពអ៊ែ វន់ថៀវ យ៉ឹ យ៉ាក់ វ៉ើ ណោះ អ៊ឺម ណោះ ម៉ូង ង៉ាយ កន់ដ្រាគ់ ហន់ណាម លំជឹ វឹញ ណោះ អំប៊ឹ ណោះ ទឹង មាំង ណោះ ទឹង ភុង មាំង ណោះ ដៀប ប្រាង ");
INSERT INTO brb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","កឡាគ់ លំជឹ ហ្រលឹម ពឹក ហន់ណូវ លំតៃ វែ ប៉ះ ទឹង វន់ហង់ង៉ាន់ តៀក។ ");
INSERT INTO brb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ណគ់ ប្រម៉ាង អៃ អហាយ ដើ វែ នែ អហាយ ដើ បនឹះ ត្រំ រ៉ា ប៉ាគ់ទឺ ហឹ វន់ថៀវ យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ណាគ់ បារ តង៉ៃ អ៊ែ លំប៊ឹះ ឞ៊ុន ពជឺរ ដើម ឞ៊ុន ណុំពាំង តៃ ប៊ិច ប៊ូះ។ បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ ចន់ដ្រា ដាំង ទ្រូង រ៉ាប់ ម៉ច គ្រែដៃ យែស៊ូ បក់ មន់កជែត។ ");
INSERT INTO brb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ញ៉ង ងន់រ៉ាប់ អ៊ឺម ទឹង ឞ៊ុន អន់នែ កឡាគ់ មែ ប៉ាសាសុន មន់បើម កាន ញុក ញ៉ាក»។ ");
INSERT INTO brb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ទឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ គូ ហឹ ស៊្រុក ប៊ែថានី ទឹង ហន់ណាម យ៉ាគ់ ស៊ីម៉ូន (យ៉ាគ់ ស៊ីម៉ូន នែ ពន់ឋើម ឡើ ស៊ិតស៊ូត)។ គ្រែដៃ យែស៊ូ ទឹង ប៉ះ ឡើ ដ្រូម ចង់ ប៊ិច កទ្រី មូយ រ៉ា ឡើ ដក់ ហឹ ណគ ឡើ តៀត កង់គែវ តម៉ ទុត ចាគ់។ ទឹង កង់គែវ អ៊ែ ឡើ ប៊ិច ណាំហម ណារដូ គែន គ្លឹម ទុត ច្រណាប់។ ឡើ កដោះ ដង់ កង់គែវ អ៊ែ ឡើ ហ៊ែង ណាំហម ពឺង ទូះ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ប៊ិច មែ អន់នឺ ម៉ើ គូ ទឹង អ៊ែ ម៉ើ មាំ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ពយ៉ិ ឡើ ត្រ ឡើ ហ៊ែង ថំឡាយ ដើ ណាំហម ប៉ាគ់ នែ! ");
INSERT INTO brb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ប៉ាគ់ ងន់ហំពួត ងន់ដូវ លៀន ទុត អើន ជឺរ ពែ ក្លាំ ឌីណារី ។ លៀន ហង់អ៊ែ ងន់អាំ ដើ មែ ម៉ូវម៉ក អន់ណាវ»។ លែក ដើ មែ ម៉ើ ម៉ាង ក្រាគ់ ពន់ដូះ ណគ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ហាក់ ដើ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «ញ៉ង វ៉ើ ម៉ាង អ៊ឺម ដើ ណគ ឝ៉ាន់ ឡើ ប៊ិច ចនិះ ស្រៀវ អ្រអវ ប៉ាគ់ នែ! ណគ ឡើ បើម កាន ចាគ់ ដើ អៃ ហវ៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ណគ់ មែ ម៉ូវម៉ក ម៉ើ គូ ប៊ឹង វែ អន់សច។ វែ វន់ដូវ បើម អន់ចាគ់ ដើ មែ តង៉ៃ ង៉ាយ តមឹង។ អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អង់គូ យ៉ាវ ប៊ឹង វែ អន់សច។ ");
INSERT INTO brb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ណាង ឡើ បើម ដើ អៃ តាម ប៉ាគ់ ណគ ឡើ ដូវ បើម។ ណាង ឡើ ពឡំ ណាំហម គ្លឹម នែ ឡើ រន់ឋាប់ ចាក់ អៃ អន់នួរ តៃ ដាន់ មន់ដក់ ជុ ហឹ ត្រម ច្រាង ចនុ កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ត្រំ អំប៊ុ បុ ឡាង ប្រិះ នែ ប៊ឹង មន់ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ប៊ឹង អ៊ែ មន់ពហាយ កាន ណាង ឡើ បើម នែ ប៉ាគ់ទឺ អ៊ែ មន់ចនិះ ហឹ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ប៊្លី អ៊ែ យូដះ អ៊ីសការីយ៉ុត ឡើ លុកស៊ិក មូយ រ៉ា ទឹង បូវ មែ ជិត បារ រ៉ា ឡើ ដក់ ចជែ ហឹ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ កាន លំប៉ូរ មែ រ៉ាប់ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","មែ អ៊ែ ហំប៊្រុះ ម៉ើ ដុង យូដះ ឡើ ហាយ ម៉ើ ញឹម ក្លើម ទុត ខាក់ ដើម ម៉ើ ឡាប់ មន់អាំ លៀន ដើ ណគ។ យូដះ ឡើ ចាំ ប៊ឹង លំវឺង បក់ លំដូវ ម៉ប គ្រែដៃ យែស៊ូ ហឹ ទី មែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","តគ់ តង៉ៃ ទី មូយ ទឹង ឞ៊ុន ណុំពាំង តៃ ប៊ិច ប៊ូះ ឡើ ត្រ តង៉ៃ ម៉ើ ខើយ កជែត ថួយ កួន ចៀម មន់ចា ប៊ឹង ឞ៊ុន ពជឺរ បូវ លុកស៊ិក ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ណាយឃូ ប៊ឹង ង៉ាយ ដឹះ ហប៉្រៃ ញ៉ា ញន់រន់ឋាប់ ឞន ដើ ហៃ ហន់ចង់ ចា បើម ឞ៊ុន ពជឺរ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","អ៊ែ ឡើ ប៉្រៃ លុកស៊ិក ណគ បារ រ៉ា ដក់ អន់នួរ ឡើ ថាន់ រៀន៖ «សប្រា លំដក់ ហឹ មួង អន់តគ់ ប៊ឹង សប្រា លំមឹត ឡើយ សប្រា លំតៃ កឡ មូយ រ៉ា លំដូល ដាក ទឹង វ៉ាន់ លំដក់ ហឹ សប្រា អ៊ែ សប្រា លំតូយ ណគ យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","លំមឹត ហឹ ហន់ណាម មែ ង៉ាយ សប្រា លំតង៉ា កន់ដ្រាគ់ ហន់ណាម អ៊ែ រៀន “ណាយឃូ ញឺ ឡើ តង៉ា ប៊ឹង វឺ អង់ង៉ាយ ហង់អាំ ដើ ណគ លន់ចង់ ចា ឞ៊ុន ពជឺរ អរែង ដើ លុកស៊ិក ណគ?”។ ");
INSERT INTO brb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","កន់ដ្រាគ់ ហន់ណាម លំពដៃ វឺ ទុត ឌឺះ ទឹង អន់ឡើ ពឺង ឡើ រន់ឋាប់ រន់ឋយ ស្រាប់ ឡើយ សប្រា លំបើម ចណង់ ចណា ដើ ង៉ាយ ទឹង អ៊ែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","អ៊ែ អំប្រា ដក់ ប្រយ ប៊ឹះ តគ់ មួង អំប្រា តៃ ប៉ាគ់ គ្រែដៃ យែស៊ូ ឡើ ហាយ ម៉ាត់ ម៉ាត អ៊ែ អំប្រា រន់ឋាប់ ចណង់ ចណា បើម ឞ៊ុន ពជឺរ។ ");
INSERT INTO brb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","តគ់ ឡើ អំប៊ឹ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ អ៊ែ អរែង ដើ លុកស៊ិក ណគ ជិត បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ទឹង ប៉ះ ណាគ់ ម៉ើ ចង់ អរែង ប៊ឹង តូក អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ទឹង បូវ វែ នែ ប៊ិច មូយ រ៉ា លំម៉ប អៃ ហឹ ទី មែ ណគ អ៊ិន ឡើ ចង់ ចា អរែង ប៉ាគ់ទឺ ប៊ឹង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","បូវ លុកស៊ិក ម៉ើ ដុង ស្រៀវ អ៊ែ ម៉ើ តង៉ា ណគ មូយ រ៉ា មូយ តង រៀន៖ «អៃ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «បឹ អន់នែ ឡើ ត្រ មូយ រ៉ា ទឹង បូវ វែ ជិត បារ រ៉ា ណិះ ឡើយ ណគ នែ ឡើ ទុ ណុំពាំង ទឹង តង់ឝ៉ាន អរែង ប៊ឹង អៃ។ ");
INSERT INTO brb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","កួន បនឹះ លំត្រ គែត ប៉ាគ់ ម៉ើ ខៀន ជុ កាន ណគ ទឹង ពឹម គ្រែដៃ ឡើយ។ ហាក់ បឹ ឡើ ម៉ប កួន បនឹះ ហឹ ទី មែ លំត្រ ធុក ញ៉ាក ទុត ខាក់។ ណគ់ បឹ ហង់អ៊ែ ណាគ់ ហយ តៃ លំកើត អ៊ែ លំចាគ់ ជឺរ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ទឹង ម៉ើ ចង់ គ្រែដៃ យែស៊ូ ឡើ ចក់ ណុំពាំង ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ កដោះ ប៉ាក ដើ មែ ដើម ឡើ ហាយ រៀន៖ «វន់ចា យ៉ឹ អន់នែ ឡើយ ចាក់ ដៃ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ប៊្លី អ៊ែ ឡើ ចក់ ចក តវែ ឈឹង ជែម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ លែវ អ៊ែ ឡើ អាំ ដើ លុកស៊ិក ណគ អ៊ែ ម៉ើ ញែត លែក មែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «អន់នែ ឡើយ ផាម អៃ លំលូះ ដើ បនឹះ ទុត អើន ផាម នែ ឡើ ពដៃ កាន ខណាត ខណាំ ប្លះ គ្រែដៃ ប្លះ វែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន អៃ អន់ញែត យ៉ាវ តវែ ឈឹង ជែម នែ ឆា ដើ ប៊ឹះ តង៉ៃ អៃ អន់ញែត ឡឹះ តវែ ឈឹង ជែម ទឹង ឞន គ្រែដៃ លំពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ប៊្លី ម៉ើ ច្រៀង ព្រតឹះ ព្រនែ គ្រែដៃ មូយ យ៉ោះ អ៊ែ ម៉ើ ឌឹក ទឹង ចន់ឌូ តើម អូលីវ។ ");
INSERT INTO brb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «វែ លែក រ៉ា វន់តាក់ អៃ យ៉ាក់ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ រៀន “អៃ អំបឹត កជែត កឡា ពែក ចៀម អ៊ែ បូវ ចៀម មន់ផាគ់ ផាយ ឡាយ ឡំ ”។ ");
INSERT INTO brb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ហាក់ តគ់ អន់ញិវ ឡឹះ អន់ណាវ អន់ដក់ ហឹ ស្រុក ឝ៉ាលីលែ អន់នួរ វែ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","យ៉ាគ់ ពែត្រុះ ឡើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «សំយ៉ះ មែ លែក រ៉ា មន់តាក់ ហៃ កតាម អៃ ណាគ់ តៃ អន់តាក់ អ៊ឺម ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ម៉ាង ណគ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ ហៃ រៀន មាំង នែ អន់នួរ អៀរ លំប្រូវ បារ តង ហំប៉ាវ ពែ តង ហន់រៀន ហហង់ឝ៉ាវ អ៊ឺម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ហាក់ យ៉ាគ់ ពែត្រុះ សរ៉ើម ចាំ ខាក់ ឡើ ច្រម៉ាន រៀន៖ «សំយ៉ះ អន់ត្រ គែត អរែង ប៊ឹង ហៃ កតាម ប៊ិច អ៊ឺម អំរៀន ញឹះ តៃ អំហង់ឝ៉ាវ ហៃ»។ លែក ដើ មែ លុកស៊ិក ម៉ើ ម៉ាង ប៉ាគ់ ដើ ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ ប៊ឹះ ឞន មូយ ឞន អ៊ែ ឝែតស៊ែម៉ានី។ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «វន់គូ ដ្រូម ប៊ឹង ណិះ អន់ដៃ ចាំ អៃ អន់ដក់ អ៊ឺរ ដាំង គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","អ៊ែ ឡើ ច្រា យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ាកុប ដើម យ៉ាគ់ យ៉ូហាន តូយ ណគ។ ហំប៊្រុះ ដអ៊ែ ឡើ ដុង ស្រៀវ អ្យិរៗ ដើម ឡើ ឝ្រង៉ឹត ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ឡើ ហាយ ដើ មែ ពែ រ៉ា រៀន៖ «អបើម ឝ្រង៉ឹត ទុត ខាក់ ស្រឹ អង់គែត ឡា វន់គូ ប៊ឹង ណិះ ឡើយ អន់ដៃ វន់ថៀវ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","គ្រែដៃ យែស៊ូ ឡើ ចវីះ ឞិត ឞ៊ែត ឡើ ជឹះ ត្រកូវ ប៊ឹង ប្រិះ ឡើ អ៊ឺរ ដាំង គ្រែដៃ អាំ កាន ធុក ញ៉ាក នែ លំចង៉ាយ តើម ប៊ឹង ណគ ប៉ាគ់ គ្រែដៃ ណាគ់ លំអាំ។ ");
INSERT INTO brb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ឡើ ម៉ាង រៀន៖ «អាបា ឡា គ្រែដៃ បើគ អើយ! ហៃ ហន់ដូវ បើម កាន លែក អិះ ឡា ហំហួត ប៊ែង ធុក ញ៉ាក នែ តើម ប៊ឹង អៃ ហាក់ ម៉ាត់ ញ៉ង ហំពន់ឋូយ អ៊ឺម តាម ប្រម៉ើត អៃ ហំបើម តាម ប្រម៉ើត ហៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","គ្រែដៃ យែស៊ូ ឡើ វឹញ ហឹ មែ ពែ រ៉ា ឡើ តៃ ម៉ើ ហង់ង៉ាន់ តៀក។ អ៊ែ ឡើ ម៉ាង ហឹ យ៉ាគ់ ពែត្រុះ រៀន៖ «អើយ ស៊ីម៉ូន ប៉ិ ហហង់ង៉ាន់ តៀក ឞាល់ នែ? ហន់ចាំ ថៀវ វ៉ិះ ឌិវ មូយ ម៉ូង ដូវ អ៊ឺម ឡះ? ");
INSERT INTO brb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","មិញ វន់ង៉ាះ ថៀវ អ៊ឺរ ដាំង គ្រែដៃ ញ៉ង អាំ វន់ដូវ ដើ កាន ពលូង ចនិះ វែ ឡើ ងុញ បើម ត្រួយ លហម ហាក់ ចាក់ ដៃ វែ ឡើ សូវ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ប៊្លី អ៊ែ ឡើ ចវីះ ឡឹះ តើម ប៊ឹង មែ អ៊ែ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ឡើ ម៉ាង ប៉ាគ់ អន់ឌូ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ឡើ វឹញ ឡឹះ ហឹ មែ ឡើ តៃ ណាគ់ ម៉ើ ហង់ង៉ាន់ តៀក ដឌែ យ៉ាក់ ម៉ើ ញឺម ម៉ាត់ ម៉ៃ ហ៊ែត អ៊ែ ម៉ើ ណោះ អ៊ឺម ត្រណើវ។ ");
INSERT INTO brb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","គ្រែដៃ យែស៊ូ ឡើ វឹញ ហឹ មែ តគ់ ពែ តង ដើ នែ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «វែ នែ តាំង វ៉ើ ហង់ង៉ាន់ ដមិញ វន់សាម? ឆិ ឡើយ ឞាល់ នែ! ណិះៗ នែ ឡើ ប៊ឹះ ម៉ូង មន់ឈូន កួន បនឹះ ហឹ ទី បនឹះ ប៊ិច ឞាប ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","វន់ឌឹក ហំមិញ ញ៉ាគ់ ដក់ តគ់ វន់ឝ្លាំង បឹ ឡើ ឈូន ទ្រូង ដក់ រ៉ាប់ អៃ ប៉ះ ឡើ ដក់ ដៀប ប៊ឹះ ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ទឹង គ្រែដៃ យែស៊ូ ណាគ់ ប៉ះ ឡើ ចជែ ហំប៊្រុះ ដើ អ៊ែ យូដះ ឡើ លុកស៊ិក មូយ រ៉ា ទឹង បូវ មែ ជិត បារ រ៉ា ទឺ ឡើ ប៊ឹះ ដើម ប៉ាសាសុន មូយ បូវ ទុត អើន ម៉ើ តូយ ណគ ម៉ើ ឝ៉ឹន តាវ ឝ៉ឹន ឡង ក្រដូង ដិ។ បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម មែ តង់កង់ ក្រាគ់ សុនសាត យូដា ម៉ើ ប៉្រៃ មែ ម៉ើ ដក់ រ៉ាប់។ ");
INSERT INTO brb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","បឹ ឡើ តៀត មែ ដក់ រ៉ាប់ គ្រែដៃ យែស៊ូ ឡើ ថាន់ អន់នួរ មែ រៀន៖ «អំមុក បឹ អង់ង៉ាយ ហង់អ៊ែ ឡើយ យែស៊ូ អ៊ែ វន់រ៉ាប់ ដើម វន់តៀត ណគ វន់រ៉ាប់ អាំ ខាក់ៗ យ៉ឹ បឹ ហង់អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ហំប៊្រុះ ឡើ ប៊ឹះ យូដះ ឡើ ដក់ ដ្រិះៗ ហឹ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «យ៉ាគ់ ណាយឃូ!» ប៊្លី អ៊ែ ឡើ មុក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","អ៊ែ ណគ់ មែ ម៉ើ តូយ ណគ ម៉ើ រ៉ាប់ ប្រយ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ទឹង បូវ ម៉ើ ឆុង ប៊ឹង អ៊ែ ប៊ិច បឹ មូយ រ៉ា ឡើ ហួត តាវ ឡើ កោះ ឞយ យ៉ាគ់ ណាយ បប៊ុះ ថួយ តាត់ ត្រពិត មូយ ច្រះ។ ");
INSERT INTO brb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «ពយ៉ិ វ៉ើ តៃ អខម៉ូយ ឞិ អ៊ែ វ៉ើ តៀត តាវ តៀត ឡង ក្រដូង ដក់ រ៉ាប់ អៃ ប៉ាគ់ នែ?។ ");
INSERT INTO brb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ត្រំ តង៉ៃ អគូ អរែង ប៊ឹង វែ ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ដើម អពង់ហៀន ដិ អតៃ អ៊ឺម វន់រ៉ាប់ អៃ។ ហាក់ កាន លែក នែ ឡើ កើត អាំ លំដាវ តាម ប៉ាគ់ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ប៊ឹង អ៊ែ មែ លុកស៊ិក ណគ ម៉ើ អ្រយ៉ាវ ព្រដិច ចាក់ ម៉ើ តាក់ ណគ លែក ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ប៊ិច ច្រហើវ មូយ រ៉ា ឡើ តូយ គ្រែដៃ យែស៊ូ ឡើ ហវ៉ារ់ ឌិវ ហំបាន ប៊្លុង ម៉ើ រ៉ាប់ ប៉ាគ់ទឺ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","អ៊ែ ឡើ តាក់ ប្រយ ហំបាន ប៊្លុង ណគ ឡើ អ្រយ៉ាវ ព្រដិច ចាក់ ហំប្រាតៗ។ ");
INSERT INTO brb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ម៉ើ តៀត គ្រែដៃ យែស៊ូ ហឹ ហន់ណាម ណាយ បប៊ុះ ថួយ។ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ បូវ តង់កង់ ក្រាគ់ សុនសាត យូដា ដើម មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ ដក់ ពទុំ ហឹ អ៊ែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","យ៉ាគ់ ពែត្រុះ ឡើ ឆ្រួយ គ្រែដៃ យែស៊ូ ឡើ ដក់ ង៉ាយ ចង៉ាយ ឆា ដើ ប៊ឹះ បយឺង ហន់ណាម ណាយ បប៊ុះ ថួយ អ៊ែ ឡើ មឹត ដ្រូម ហន់ឈុរ អ៊ុញ អរែង ប៊ឹង មែ ម៉ើ ញ៉ាម រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ទិះ ក្រាគ់ តាត់ កឍី សុនសាត យូដា លែក រ៉ា ម៉ើ ដាំង មែ កឡា តៃ មន់ប៉ច កាន គ្រែដៃ យែស៊ូ ឡើ បើម អន់យូច បក់ មន់ប៊ិច ខ កជែត ណគ ហាក់ ម៉ើ តៃ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ប៊ិច បនឹះ ទុត អើន ម៉ើ ចឹន ឆ្រឡិ គ្រែដៃ យែស៊ូ ហាក់ ណគ់ ប្រម៉ាង ម៉ើ ប៉ច អ៊ែ ឡើ ដិ អន់ដិ ប្លះ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ប៊ិច មែ អន់នឺ រ៉ា ម៉ើ ឌឹក ឆុង ចឹន គ្រែដៃ យែស៊ូ ឆ្រឡិ ឆ្រលួគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«ញ៉ា ញ៉ើ ដុង បឹ អន់នែ ឡើ ម៉ាង រៀន “អៃ អំសោះ រំប៊្លឹ តាក់ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ នែ ណគ់ បនឹះ ម៉ើ បើម អ៊ែ អំបើម ឡឹះ អន់ណាវ លញ៉ាគ់ ពែ តង៉ៃ លំចឹះ ណគ់ រ៉ូង អ៊ិន ត្រ អ៊ឺម បនឹះ មន់បើម”»។ ");
INSERT INTO brb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","សំយ៉ះ ម៉ើ ប៉ច ណគ ប៉ាគ់ អ៊ែ កតាម ប្រម៉ាង មែ អ៊ែ ណាគ់ ឡើ ដិ អន់ដិ ដឌែ ប្លះ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ប៊ឹង អ៊ែ យ៉ាគ់ ណាយ បប៊ុះ ថួយ ឡើ ឌឹក ឆុង ប្លះ កឌី មែ ទិះ ក្រាគ់ តាត់ កឍី ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «បាយ តៃ ហត្រណើវ? ប្រម៉ាង មែ ម៉ើ ចឹន ហៃ អ៊ិន ប៉ាគ់ ង៉ាយ ហឃឹត?» ");
INSERT INTO brb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","គ្រែដៃ យែស៊ូ ឡើ គូ ខៀង ញឹះ តៃ ឡើ ត្រណើវ។ ណាយ បប៊ុះ ថួយ ឡើ តង៉ា ឡឹះ ណគ រៀន៖ «ហង់ហាយ ឡាំង ដើ ញ៉ា ហៃ ឡើយ ឡះ ហគ្រែដៃ គ្រិះ កួន កឡ យ៉ាគ់ គ្រែដៃ ណគ់ ញ៉ា ញ៉ើ ព្រតឹះ ព្រនែ ណគ?» ");
INSERT INTO brb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «អៃ នែ ឡើយ។ អន់ទុន វន់តៃ កួន បនឹះ លំឌឹក ដ្រូម តៃ ចម៉ា គ្រែដៃ ឡើ ប៊ិច កាន ឆង៉ាត់ តៃ ឋាំ ដើម វន់តៃ លំប៊ឹះ អរែង ដើ យូក»។ ");
INSERT INTO brb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ណាយ បប៊ុះ ថួយ ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ សាក ប្រយ អាវ ទិះ ណគ អ៊ែ ឡើ ម៉ាង រៀន៖ «សណូវ យ៉ាវ ងន់ដាំង មែ កឡា តៃ ");
INSERT INTO brb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","វ៉ើ ដុង ឡើយ ណគ ឡើ ផម៉ាត គ្រែដៃ ពយ៉ិ អន់ណាវ ដើ វែ វន់ឃឹត?»។ អ៊ែ លែក ដើ មែ ម៉ើ ពថូត ណគ ឆា ដើ មន់កជែត។ ");
INSERT INTO brb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ប៊្លី អ៊ែ មែ អន់នឺ ម៉ើ កយ៉ុះ ក្រហាក ដើម ម៉ើ ចង វ៉ាត់ ម៉ាត់ ណគ ដើ ហំបាន ម៉ើ ជិវ អ៊ែ ម៉ើ ឋូវ ពសាល់ ណគ រៀន៖ «ហន់ហាយ ឡាំង មែ ង៉ាយ ម៉ើ ជិវ ហៃ!»។ ដើម មែ កឡា ញ៉ាម រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ម៉ើ តាះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ទឹង អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ដ្រូម ចុ បយឺង អ៊ែ កទ្រី មូយ រ៉ា ឡើ បើម ឞយ ណាយ បប៊ុះ ថួយ ឡើ ដក់ ហឹ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ណាង ឡើ តៃ យ៉ាគ់ ពែត្រុះ ទឹង ឡើ ហន់ឈុរ អ៊ុញ ឡើ ឝ្លាំង ពឡាក់ អ៊ែ ឡើ ម៉ាង រៀន៖ «ហៃ នែ ហបូវ យែស៊ូ ស៊្រុក ណាសារែត ទឺ ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ហាក់ យ៉ាគ់ ពែត្រុះ ឡើ ច្រម៉ាន រៀន៖ «អហង់ឝ៉ាវ អ៊ឺម អៃ ណគ ណោះ កាន អង់ង៉ាយ ហម៉ាង អ៊ិន»។ យ៉ាគ់ ពែត្រុះ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ដក់ ហឹ ឝឡោះ ដ្រក។ ហំប៊្រុះ ដើ អ៊ែ អៀរ ឡើ ប្រូវ ប្រយ ។ ");
INSERT INTO brb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","កទ្រី អ៊ែ ឡើ តៃ ឡឹះ យ៉ាគ់ ពែត្រុះ អ៊ែ ឡើ ហាយ ដើ មែ ម៉ើ គូ ទឹង អ៊ែ រៀន៖ «បឹ អន់នែ បូវ យែស៊ូ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","យ៉ាគ់ ពែត្រុះ ឡើ ច្រម៉ាន ឡឹះ អន់ណាវ។ ឞិត ឞ៊ែត ប៊្លី អ៊ែ ណគ់ មែ ម៉ើ គូ ទឹង អ៊ែ ម៉ើ ម៉ាង ដើ ណគ រៀន៖ «ហៃ នែ ហបូវ យែស៊ូ ម៉ាត់ ម៉ាត ឡើយ យ៉ាក់ ហប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","យ៉ាគ់ ពែត្រុះ ឡើ តប៉ឹន ចាក់ អ៊ែ ឡើ ម៉ាង រៀន៖ «ញឹះ តៃ អហឝ៉ាវ អ៊ឺម ណគ់ បឹ វែ វ៉ើ ម៉ាង អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ហំប៊្រុះ ដើ អ៊ែ អៀរ ឡើ ប្រូវ មូយ តង ឡឹះ។ អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ចនិះ ហឹ ប្រម៉ាង គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «អន់នួរ អៀរ លំប្រូវ បារ តង ហំប៉ាវ ពែ តង ហន់រៀន ហហង់ឝ៉ាវ អ៊ឺម អៃ»។ ហំប៊្រុះ ដើ អ៊ែ ឡើ ដុង ស្រៀវ ឡើ លូះ ដាក ម៉ាត់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","តគ់ ងឹប តើម ភុង មាំង បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ បូវ តង់កង់ ក្រាគ់ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ លែក ដើ មែ ទិះ ក្រាគ់ តាត់ កឍី ម៉ើ ពស៊ុំ ព្រចួត ប្រម៉ាង ត្រឌីវ មែ។ អ៊ែ ម៉ើ ចង គ្រែដៃ យែស៊ូ ម៉ើ តៀត ហឹ យ៉ាគ់ ពីឡាត់។ ");
INSERT INTO brb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ហៃ ឡើយ ឡះ ហសឋិច សុនសាត យូដា?» គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ត្រ ឡើយ ហម៉ាង អ៊ិន!» ");
INSERT INTO brb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ម៉ើ ផង ណគ ទុត អើន ខ។ ");
INSERT INTO brb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា ឡឹះ គ្រែដៃ យែស៊ូ រៀន៖ «ហដុង អ៊ឺម ឡះ ម៉ើ ផង ហៃ អើន ខ ឞាល់ អ៊ិន? ប៉ិ តៃ ហត្រណើវ ប៉ាគ់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ហាក់ គ្រែដៃ យែស៊ូ ញឹះ តៃ ឡើ ត្រណើវ យ៉ាវ អ៊ែ យ៉ាគ់ ពីឡាត់ តូវ ឡើ បើម ទុត ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ត្រំ កម៉ ប៊ឹង ម៉ើ បើម ឞ៊ុន ពជឺរ យ៉ាគ់ ពីឡាត់ ឡើ ខើយ តោះ ពញឺះ បនឹះ ថូត មូយ រ៉ា ណគ់ អង់ង៉ាយ មែ ប៉ាសាសុន ម៉ើ ឡា។ ");
INSERT INTO brb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ទឹង អ៊ែ ប៊ិច បនឹះ ម៉ើ គូ ឃុក មូយ បូវ ម៉ើ ថូត ញ៉ន ម៉ើ ចន់ដ្រា បូវ បើម កាន អ្រញ៉ុក អ្រញ៉ាក។ ទឹង បូវ មែ នែ ប៊ិច បឹ មូយ រ៉ា ម៉ាត់ ណគ បារ៉ាបះ ឡើ កជែត បនឹះ។ ");
INSERT INTO brb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","មែ ប៉ាសាសុន ម៉ើ ដក់ ហឹ យ៉ាគ់ ពីឡាត់ ម៉ើ ឡា លំតោះ ពរ៉ូះ បនឹះ ថូត មូយ រ៉ា តាម ប៉ាគ់ ណគ ឡើ ខើយ អាំ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា មែ រៀន៖ «វ៉ើ ម៉ើត អន់តោះ ពរ៉ូះ ដើ វែ សឋិច សុនសាត យូដា ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ណគ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ យ៉ាក់ ឡើ ណោះ រៀន បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ម៉ើ តៀត គ្រែដៃ យែស៊ូ ម៉ប ហឹ ណគ ញ៉ន តៃ ម៉ើ យឺម ដើ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ហាក់ បូវ មែ ទិ ក្រាគ់ បប៊ុះ ថួយ ម៉ើ ពន់ឆូម ពង់អ៊ុច មែ ប៉ាសាសុន ប៉្រៃ ឡា ហឹ យ៉ាគ់ ពីឡាត់ អាំ លំតោះ ពរ៉ូះ បារ៉ាបះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា ឡឹះ មែ ប៉ាសាសុន រៀន៖ «ប៉ាគ់ ពអ៊ែ វ៉ើ ម៉ើត អៃ អំបើម ប៉ាគ់ ង៉ាយ ដើ បឹ ណគ់ វែ វ៉ើ រៀន ឡើ សឋិច សុនសាត យូដា?»។ ");
INSERT INTO brb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ម៉ើ ហូ ឡា ថាំងៗ រៀន៖ «ហំពឡាះ ប៉ាង ណគ ប៊ឹង ឡង អង់ឝ៉ាង!»។ ");
INSERT INTO brb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា មែ រៀន៖ «ប៉ិ វ៉ើ ម៉ាង ប៉ាគ់ អ៊ិន? ឡើ បើម អន់យូច អង់ង៉ាយ ដឹះ?»។ សរ៉ើម ម៉ើ ឡា ថាំងៗ រៀន៖ «ហំពឡាះ ប៉ាង ណគ ប៊ឹង ឡង អង់ឝ៉ាង!»។ ");
INSERT INTO brb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","យ៉ាគ់ ពីឡាត់ ឡើ ម៉ើត អាំ មែ ប៉ាសាសុន មន់ញឹម ក្លើម អ៊ែ ឡើ ពញឺះ យ៉ាគ់ បារ៉ាបះ តើម ប៊ឹង ឃុក ដើ មែ ដើម ឡើ ឈូន គ្រែដៃ យែស៊ូ ហឹ ទី មែ តហាន អាំ មន់បឹត ណគ ដើ ឆមឺ ប្រាត់ អន់ដៃ លែវ អ៊ែ មន់ដក់ តៀត ពឡាះ ប៉ាង កជែត។ ");
INSERT INTO brb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","មែ តហាន ម៉ើ តៀត គ្រែដៃ យែស៊ូ ហឹ បយឺង ហន់ណាម យ៉ាគ់ កឡា ពែក ប៉ាក់ ស្រុក។ អ៊ែ ម៉ើ កឡូវ លែក ដើ បូវ តហាន ម៉ើ គូ ទឹង អ៊ែ ដក់ តមួត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ម៉ើ ពហក គ្រែដៃ យែស៊ូ ដើ អាវ ឌ្រឹម ចះ ង៉មៗ ដើម ម៉ើ កង់ អង់កង់ ឆ្រឡា បើម កនឺន ពគឺន ទិ ទូះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ប៊្លី អ៊ែ ម៉ើ ហំបះ ឞឞួះ យយ៉ាល់ ណគ ម៉ើ ម៉ាង រៀន៖ «ញ៉ះ ខរ៉ុប យ៉ាគ់ សឋិច សុនសាត យូដា!»។ ");
INSERT INTO brb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ម៉ើ បឹត ទូះ ណគ ដើ តង ត្រាង ម៉ើ កយ៉ុះ ក្រហាក ណគ ដើម ម៉ើ កដាប ហំបះ រួយ ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ប៊្លី ម៉ើ ឞឞួះ យយ៉ាល់ ណគ លែវ ឡើយ អ៊ែ ម៉ើ តោះ អាវ ឝ៉ុះ ចះ ង៉មៗ ម៉ើ ពហក ដើ អាវ ណគ កឡឹ អន់ណាវ ប៊្លី អ៊ែ ម៉ើ តៀត ដក់ ពឡាះ ប៉ាង កជែត ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ទឹង ម៉ើ ដក់ ប៊ិច កឡ មូយ រ៉ា ម៉ាត់ ណគ ស៊ីម៉ូន មួង គីរែន ឡើ ជឹ តើម ប៊ឹង មឺរ ឡើ ដក់ តៃ ទ្រូង អន់ទឺ អ៊ែ ម៉ើ ពង់ខំ ណគ កួយ ឡង អង់ឝ៉ាង គ្រែដៃ យែស៊ូ។ ណគ អ៊ែ បើគ អាលែសានដ្រុះ អំប្រា រូភូះ។ ");
INSERT INTO brb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","មែ តហាន ម៉ើ តៀត គ្រែដៃ យែស៊ូ ប៊ឹះ ឞន មូយ ម៉ើ ជុ “ឝ៉ូលឝ៉ូថា” ប៊ិច នឿណៃ រៀន “ចន់ឌូ លៀង ទូះ”។ ");
INSERT INTO brb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ម៉ើ ចក់ តវែ ប៉្លៃ ឈឹង ជែម ម៉ើ លុក ដើ ឆារ់ ឡង តៃ អាំ ដុង ឈិ ម៉ើ អាំ ដើ ណគ ញែត ហាក់ ឡើ ឌី អ៊ឺម ញែត។ ");
INSERT INTO brb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ប៊្លី អ៊ែ មែ តហាន ម៉ើ ពឡាះ ប៉ាង ណគ អ៊ែ ម៉ើ ចក់ ប្រវ៉ើន ហណក ណគ ម៉ើ រ៉ាប់ សណូត ត្រឌីវ មែ ឡើ ត្រ ប៉ុះ បឹ អង់ង៉ាយ បឹ ហង់អ៊ែ ឡើ ដូវ។ ");
INSERT INTO brb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ម៉ើ ពឡាះ ប៉ាង គ្រែដៃ យែស៊ូ ទឹង ម៉ូង ជែន ងឹប។ ");
INSERT INTO brb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ម៉ើ ខៀន ពហាយ កាន ម៉ើ កជែត ណគ ប៊ឹង ផឡាគ់ ម៉ើ ខៀន រៀន «បឹ នែ ឡើ សឋិច សុនសាត យូដា»។ ");
INSERT INTO brb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ដើម ម៉ើ ពឡាះ ប៉ាង បនឹះ ខម៉ូយ បារ រ៉ា ប៊ឹង ឡង អង់ឝ៉ាង ដិៗ ដៀក គ្រែដៃ យែស៊ូ មូយ រ៉ា តៃ ចម៉ា មូយ រ៉ា តៃ ចអៀវ។ ");
INSERT INTO brb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","លែក ដើ កាន នែ ឡើ ដាវ ប៉ាគ់ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ រៀន “ម៉ើ ជុ ណគ ប៉ាគ់ បនឹះ យូច ចឞាប់ ទឺ ”។ ");
INSERT INTO brb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","បនឹះ ម៉ើ ដក់ តៃ អ៊ែ ម៉ើ ឞឞួះ យយ៉ាល់ ណគ ដើម ម៉ើ ង៉ិច ឝលែប ម៉ាត់ ហឹ ណគ រៀន៖ «អើយ ហរៀន ហំសោះ រំប៊្លឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ហំបើម ឡឹះ លញ៉ាគ់ ពែ តង៉ៃ លំចឹះ ");
INSERT INTO brb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ហំតោះ ចាក់ ហៃ កឡឹ ឡាំង ហំទឺះ តើម ទិ ឡង អង់ឝ៉ាង អ៊ែ!»។ ");
INSERT INTO brb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","អ៊ែ ណគ់ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ ពន់ឆាំ ពន់ឆោះ ប៉ាគ់ទឺ ណគ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ឡើ ហវ៉ាត់ មែ គែង ដូវ ហាក់ ឡើ ហវ៉ាត់ ចាក់ ឡើ កឡឹ ដូវ អ៊ឺម!។ ");
INSERT INTO brb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","មិញ គ្រែដៃ គ្រិះ ហសឋិច អ៊ីស្រាអ៊ែល ណិះៗ នែ ហន់ទឺះ ឡាំង តើម ទិ ឡង អង់ឝ៉ាង បក់ ញំតៃ ដើម ញន់ចាប់ មឹង!»។ ណគ់ អំប្រា ម៉ើ ប៉ាង ដៀក គ្រែដៃ យែស៊ូ អំប្រា ពន់ឆាំ ពន់ឆោះ ប៉ាគ់ទឺ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ទឹង ឆុង តង៉ៃ លែក ដើ ប៊្រី ដាក មែ ឡើ កឡាំ ប៊្រែ ប្រយ ឆា ប៊ឹះ ម៉ូង ពែ អំប៊ឹ។ ");
INSERT INTO brb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ទឹង ម៉ូង ពែ អំប៊ឹ គ្រែដៃ យែស៊ូ ឡើ ហរ៉ាវ ម៉ាង ថាំងៗ រៀន៖ «អ៊ែឡយ អ៊ែឡយ ឡាម៉ា សាបិចថានី?» ប្រម៉ាង នែ ប៊ិច នឿណៃ រៀន៖ «ឡា គ្រែដៃ អៃ គ្រែដៃ អៃ អើយ ពយ៉ិ ឡើ ត្រ ហតាក់ អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ណគ់ មែ ម៉ើ ឆុង ទឹង អ៊ែ មែ អន់នឺ ម៉ើ ដុង ប្រម៉ាង ណគ អ៊ែ ម៉ើ ម៉ាង រៀន៖ «អ៊ិន ណាគ់ វ៉ើ ដុង ឡើ កឡូវ យ៉ាគ់ អ៊ែលីយ៉ា!»។ ");
INSERT INTO brb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","អ៊ែ បឹ មូយ រ៉ា ឡើ ដក់ អ្រយ៉ាវ ចក់ ក្រដាគ់ ឡើ ចូប ទិ តវែ ឈឹង ជែម ឈូគ ប៊្លី អ៊ែ ឡើ ចង ប៊ឹង តង ត្រាង ឡើ តូល អាំ ដើ គ្រែដៃ យែស៊ូ លំឈ្រែប ដើម ឡើ ម៉ាង រៀន៖ «ងំចាំ ឝ្លាំង អន់ដៃ អំប យ៉ាគ់ អ៊ែលីយ៉ា ណាគ់ លំប៊ឹះ ពឌឺះ ណគ តើម ទិ ឡង អង់ឝ៉ាង»។ ");
INSERT INTO brb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហរ៉ាវ រង់អូក ប៊្លី អ៊ែ ឡើ តាត់ សើម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ហំប៊្រុះ ដើ អ៊ែ ហំបាន ទិះ ទុត កវឹវ ម៉ើ អាត់ កនុង ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ ត្រសាក ប្រយ តង់បារ តើម ទិ ពឺង ប៊ឹះ ប្រិះ។ ");
INSERT INTO brb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ណាយ តហាន រ៉ូម ឡើ ឆុង ប៊ឹង ងឺរ គ្រែដៃ យែស៊ូ ឡើ តៃ ឡើ តាត់ សើម ប៉ាគ់ នែ អ៊ែ ឡើ ម៉ាង រៀន៖ «បឹ អន់នែ ឡើ កួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ទឹង អ៊ែ ប៊ិច ប៉ាគ់ទឺ មែ កទ្រី ម៉ើ ឝ្លាំង តើម ប៊ឹង ចង៉ាយ។ ទឹង បូវ មែ កទ្រី អ៊ែ ប៊ិច ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា ណាង ម៉ារី មែគ យ៉ាកុប អំប្រា យ៉ូស៊ែ (យ៉ាកុប នែ ឡើ ដនឹក ហន់ដើម) ដើម ប៊ិច ណាង សាឡូមែ ដិ។ ");
INSERT INTO brb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","បូវ មែ កទ្រី លែក ពែ រ៉ា នែ ម៉ើ តូយ ឡាំលៀង ណគ ណាគ់ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ឡើយ។ ប៊ិច មែ កទ្រី ហឹ គែង ទុត អើន អន់ណាវ ម៉ើ ឌឹក ទឹង មួង យែរូសាឡឹម អរែង ដើ ណគ ម៉ើ គូ ឝ្លាំង ប៊ឹង អិះ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ទឹង តង៉ៃ អ៊ែ ឡើ ត្រ តង៉ៃ មែ សុនសាត យូដា ម៉ើ រន់ឋាប់ បើម ឞ៊ុន ព្រឹង ឞ៊ុន ព្រឹង នែ អំប៊ឹ ហន់ណូវ ឡើយ មន់បើម។ ");
INSERT INTO brb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","យ៉ាគ់ យ៉ូស៊ែប ស៊្រុក អារីម៉ាធែ ឡើ តង់កង់ មែ ប៉ាសាសុន ម៉ើ អៀល បឹះ ទឹង បូវ មែ ទិះ ក្រាគ់ តាត់ កឍី សុនសាត យូដា ដើម ឡើ ចាំ ឝ្លាំង ប៉ាគ់ទឺ តង៉ៃ គ្រែដៃ លំពែក ប៉ាក់។ អ៊ែ តគ់ អំប៊ឹ ឡើ ហាន ដក់ ឡា ចក់ កយ៉ក់ គ្រែដៃ យែស៊ូ ហឹ យ៉ាគ់ ពីឡាត់។ ");
INSERT INTO brb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","យ៉ាគ់ ពីឡាត់ ឡើ ដុង គ្រែដៃ យែស៊ូ ឡើ គែត ឡើយ តូវ ឡើ បើម ញ៉ម ទុត ខាក់ អ៊ែ ឡើ កឡូវ ណាយ តហាន ឡើ តង៉ា ពឡាក់ រៀន៖ «គ្រែដៃ យែស៊ូ អ៊ិន ឡើ គែត ម៉ាត់ ម៉ាត ឡើយ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ប៊្លី ឡើ ដុង ណាយ តហាន ឡើ ហាយ លែវ ឡើយ អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ អាំ យ៉ាគ់ យ៉ូស៊ែប លំដក់ ចក់ កយ៉ក់ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","យ៉ាគ់ យ៉ូស៊ែប ឡើ រួត ហំបាន បក ទុត ច្រណាប់ ប៊្លី អ៊ែ ឡើ ប៊្រឺះ កយ៉ក់ គ្រែដៃ យែស៊ូ តើម ទិ ឡង អង់ឝ៉ាង ឡើ បវ ដើ ហំបាន ឡើ ដក់ ជុ ហឹ ត្រម ច្រាង ណគ់ មែ ម៉ើ ប៉ោះ ហន់ឋុ ឡើយ។ ប៊្លី អ៊ែ ឡើ ព្រលូ តម៉ ក្រឡឹល ពាំង ឝឡោះ ត្រម ច្រាង។ ");
INSERT INTO brb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា ដើម ណាង ម៉ារី មែគ យ៉ូស៊ែ អំប្រា តៃ ប៉ាគ់ទឺ ឞន ម៉ើ ជុ កយ៉ក់ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","តង៉ៃ ម៉ើ ព្រឹង ក្លើច ឡើយ ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា ណាង ម៉ារី មែគ យ៉ាកុប ដើម ណាង សាឡូមែ ម៉ើ រួត ខឿង គ្លឹម មន់ពឡំ កយ៉ក់ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","តគ់ តង៉ៃ អាទិត តើម ងឹប ឆិ ឌឹក ម៉ាត់ តង៉ៃ មែ កទ្រី លែក ពែ រ៉ា ម៉ើ ដក់ ហឹ ត្រម ច្រាង ចនុ កយ៉ក់ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «មែ ង៉ាយ ដឹះ មន់ប៉ូរ ង៉ាយ ព្រលូ កន់ស៊ីត តម៉ ម៉ើ ពាំង ឝឡោះ ត្រម ច្រាង?»។ ");
INSERT INTO brb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","អ៊ែ ម៉ើ បយ៉ើល ឝ្លាំង ម៉ើ តៃ តម៉ ម៉ើ ព្រលូ កន់ស៊ីត ហឹ ដៀក ឡើយ។ (តម៉ អ៊ែ តមិះ ណគ ទុត ទិះ)។ ");
INSERT INTO brb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ហំប៊្រុះ ម៉ើ មឹត ហឹ ត្រម ចនុ កយ៉ក់ ម៉ើ តៃ ច្រហើវ មូយ រ៉ា ឡើ ដ្រូម តៃ ចម៉ា ឡើ ហក អាវ ទិះ បក់ បក អ៊ែ ម៉ើ ឌូង តូវ ម៉ើ កុង គឺ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","បឹ ហង់អ៊ែ ឡើ ម៉ាង ហឹ មែ កទ្រី រៀន៖ «ញ៉ង វ៉ើ ឌូង អ៊ឺម! អណោះ ឡើយ វ៉ើ ដក់ ដាំង គ្រែដៃ យែស៊ូ ស៊្រុក ណាសារែត ណគ់ មែ ម៉ើ ពឡាះ ប៉ាង កជែត។ គ្រែដៃ ឡើ ពញិវ ឡើយ ប៊ិច យ៉ាវ ណគ ហឹ នែ វន់ឝ្លាំង ប៊ឹង នែ ឡើយ ម៉ើ ជុ ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","មិញ វន់ជឹ ហាយ ដើ យ៉ាគ់ ពែត្រុះ ដើម ដើ មែ លុកស៊ិក គែង អ៊ែ ដិ រៀន “គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ស្រុក ឝ៉ាលីលែ អន់នួរ វែ ឡើយ ហឹ អ៊ែ វន់តៃ ណគ ប៉ាគ់ ណគ ឡើ ហាយ ដើ វែ ពន់ឋើម ឡើយ”»។ ");
INSERT INTO brb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","មែ កទ្រី អ៊ែ ម៉ើ ញឺះ តើម ប៊ឹង ត្រម ច្រាង ចនុ កយ៉ក់ ម៉ើ ជឹ អ្រយ៉ាវ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ ដៃ ប្រយ។ ញឹះ តៃ ម៉ើ ហាយ ដើ មែ ង៉ាយ អ៊ឺម យ៉ាក់ ម៉ើ ឌូង ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ដៀប ប្រាង តង៉ៃ អាទិត គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ។ ឡើ ពដៃ ចាក់ អន់នួរ ដើ ណាង ម៉ារី ស៊្រុក ម៉ាដាឡា។ (ណាង ម៉ារី អន់នែ ឡើយ ពន់ឋើម គ្រែដៃ យែស៊ូ ឡើ ពន់ឌ្រុះ អរ៉ាក់ ប៉ឹះ រ៉ា ម៉ើ វីះ តើម ប៊ឹង ណគ។) ");
INSERT INTO brb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ណាង ម៉ារី ឡើ ដក់ ហាយ ដើ មែ ម៉ើ តូយ គ្រែដៃ យែស៊ូ អន់នួរ ឡើ គែត។ បូវ មែ នែ ណាគ់ ប៉ះ ម៉ើ ឝ្រង៉ឹត ស្រូក ដើម ម៉ើ ញឺម។ ");
INSERT INTO brb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","តគ់ ម៉ើ ដុង គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ ដើម ម៉ើ ដុង ណាង ម៉ារី ឡើ តៃ ណគ ណាគ់ តៃ ម៉ើ ចាប់ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពដៃ ចាក់ ណគ ប៉ាគ់ គែង អន់ណាវ ដើ លុកស៊ិក ណគ បារ រ៉ា ទឹង អំប្រា ដក់ តៃ ទ្រូង ញឺះ តើម ប៊ឹង មួង។ ");
INSERT INTO brb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","លុកស៊ិក បារ រ៉ា អ៊ែ អំប្រា ជឹ ហាយ ប៉ាគ់ទឺ ដើ មែ លុកស៊ិក គែង អ៊ែ ណាគ់ តៃ ម៉ើ ចាប់ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","តគ់ ប៊្លី អ៊ែ ទឹង ប៉ះ មែ លុកស៊ិក លែក ជិត មូយ រ៉ា ម៉ើ ចង់ ចា អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពដៃ ចាក់ ណគ ដើ មែ។ ឡើ ពន់ដូះ មែ ញ៉ន តៃ ម៉ើ ចាប់ ដើម ម៉ើ ប៊ិច ចនិះ ឝ៉ិះ យ៉ាក់ ម៉ើ ឌី អ៊ឺម ចាប់ ប្រម៉ាង ណគ់ មែ ម៉ើ តៃ ណគ ឡើ ញិវ ឡឹះ។ ");
INSERT INTO brb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «មិញ វន់ដក់ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ លែក ដើ បនឹះ ត្រំ អំប៊ុ ត្រំ ឞន ទិ ឡាង ប្រិះ នែ។ ");
INSERT INTO brb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","មែ ង៉ាយ មន់ចាប់ មឹង ដើម មន់បើម ឞ៊ុន ម៉ូច ដាក មែ អ៊ែ ឡើយ គ្រែដៃ លំហវ៉ាត់ អ៊ែ ណគ់ មែ តៃ ម៉ើ ឌី ចាប់ មឹង មែ អ៊ែ មន់ត្រ ថូត។ ");
INSERT INTO brb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","មែ មន់ចាប់ មឹង អៃ មន់ដូវ បើម កាន ហឝ៉ាវ ឆង៉ាត់ ប៉ាគ់ នែ៖ មន់ពន់ឌ្រុះ អរ៉ាក់ មន់អ៊ីង ដើ អាតណាត ម៉ាត់ អៃ ដើម មន់ចជែ ដើ ប្រម៉ាង ដិៗ តៃ ខើយ ម៉ាង។ ");
INSERT INTO brb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ប៉ាគ់ មន់រ៉ាប់ ប៊ិះ លឺ មន់ញែត ឆ្រាវ ប៊ូ កតាម ណាគ់ តៃ មន់ខគ់ណាំ អ៊ឺម។ មន់ជុ ទី ប៊ឹង មែ ម៉ើ ឈិ មែ ម៉ើ ឈិ អ៊ែ មន់នៀម ប្រយ»។ ");
INSERT INTO brb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","តគ់ គ្រែដៃ យែស៊ូ ឡើ កន់ដ្រាគ់ ឡើ ពហាយ ដើ មែ លុកស៊ិក លែវ ឡើយ គ្រែដៃ ឡើ ពឌឹក ណគ ទឹង ហូង គ្រែ ឡើ អាំ ដ្រូម តៃ ចម៉ា ណគ។ ");
INSERT INTO brb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","បូវ មែ លុកស៊ិក ម៉ើ ដក់ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ត្រំ អំប៊ុ ត្រំ ឞន។ គ្រែដៃ កន់ដ្រាគ់ ឡើ ប៉ូរ មែ ដើម ឡើ អាំ មែ មន់ដូវ បើម កាន ហង់ឝ៉ាវ ឆង៉ាត់ អាំ បនឹះ មន់ណោះ ប្រម៉ាង មែ ម៉ើ ហាយ នែ ឡើ ញឺះ តើម ប៊ឹង គ្រែដៃ កន់ដ្រាគ់ ម៉ាត់ ម៉ាត ។");
INSERT INTO brb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","ពយ៉ៃ ឈូន ដើ ហៃ យ៉ាគ់ ធែវភីល អើយ ហៃ ហណោះ ឡើយ រៀន ណគ់ បនឹះ ម៉ើ តៃ កាន គ្រែដៃ យែស៊ូ ឡើ ពឡូច ពន់ឋើម ទឹង ញ៉ា ញ៉ើ ដក់ តូយ ណគ បូវ មែ នែ ម៉ើ ពហាយ ដើ មែ ហឹ គែង អន់ណាវ មែ ហឹ គែង អ៊ែ ឡើយ ម៉ើ ដុង អ៊ែ ម៉ើ ខៀន ត្រួយ ជុ តមួត ត្រៗ តាម ពហាយ មែ អាំ ញ៉ើ ណោះ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ញ៉ន ដើ អ៊ែ ឡើយ អ៊ែ អៃ អខំ ផនិត កាន បាត់ លែក អ៊ែ តើម ប៊ឹង ឈឹង តើម អ៊ែ អឃឹត រៀន អាត លន់ចាគ់ ឡើយ អៃ អន់ខៀន ជុ តាម ក្រឡាក់ អំពយ៉ៃ ឈូន ដើ ហៃ យ៉ាគ់ ធែវភីល អើយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","អៃ អបើម ប៉ាគ់ នែ បក់ អាំ ហៃ ហន់ណោះ រៀន ណគ់ អង់ង៉ាយ ហៃ ហដុង តើម ប៊ឹង មែ ម៉ើ ពង់ហៀន ណគ់ ហង់អ៊ែ ឡើ ត្រ ម៉ាត់ ម៉ាត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ទឹង យ៉ាគ់ ហ៊ែរ៉ូត ឡើ បើម សឋិច ដើ មែ យូដា ពន់ឋើម ឡើ ប៊ិច មែ កឡា បប៊ុះ ថួយ មូយ រ៉ា ទឹង បូវ យ៉ាគ់ អប៊ីយ៉ា ម៉ាត់ ណគ យ៉ាគ់ សាការ៉ៃ ម៉ាត់ ទ្រី ណគ អ៊ែលីសាបិត អំប្រា នែ កួន ចូវ យ៉ាគ់ អើរ៉ុន ។ ");
INSERT INTO brb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","អំប្រា ទ្រី ក្ល នែ អំប្រា ចាគ់ ទឹង ត្រ ប៊ឹង ម៉ាត់ គ្រែដៃ អំប្រា បើម ត្រួយ តាម ពន់ដ្រៃ ចឞាប់ គ្រែដៃ កន់ដ្រាគ់ លែក អិះ ញឹះ តៃ យូច អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","អំប្រា នែ អំប្រា ប៊ិច អ៊ឺម កួន យ៉ាក់ ទ្រី ណគ អ៊ែលីសាបិត ឡើ កន់ដុង ដើម អំប្រា ក្រាគ់ៗ ម៉ៃ ឡើយ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ទឹង យ៉ាគ់ សាការ៉ៃ ឡើ ដក់ បើម កាន កឡា បប៊ុះ ថួយ យ៉ាក់ ឡើ ត្រ ប៉ុះ បូវ ណគ ឡើយ ម៉ើ ដក់ បើម កាន ហឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","អ៊ែ មែ ម៉ើ ព្រលូក តាម ខណើយ មែ កឡា បប៊ុះ ថួយ ឡើ ត្រ ប៉ុះ យ៉ាគ់ សាការ៉ៃ ឡើ មឹត ម៉ប ចុះ ខឿង គ្លឹម ហឹ កនុង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ កន់ដ្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ទឹង ឡើ ប៊ឹះ ម៉ូង ណគ ឡើ ចុះ ខឿង គ្លឹម ប៊ិច បនឹះ ទុត អើន ម៉ើ គូ ទឹង បយឺង ម៉ើ អ៊ឺរ ដាំង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ហំប៊្រុះ ដើ អ៊ែ យ៉ាគ់ សាការ៉ៃ ឡើ តៃ ប្រយ ឞាវ គ្រែដៃ កន់ដ្រាគ់ មូយ រ៉ា ឡើ ឆុង តៃ ចម៉ា ប៊ឹង ដៀក ហ៊ីប ម៉ើ ចុះ ខឿង គ្លឹម។ ");
INSERT INTO brb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ទឹង យ៉ាគ់ សាការ៉ៃ ឡើ តៃ ប៉ាគ់ អ៊ែ ឡើ ឌូង តូវ ឡើ សសឹរ ចាក់ ដៃ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","អ៊ែ ឞាវ គ្រែដៃ ឡើ ម៉ាង ដើ ណគ រៀន៖ «យ៉ាគ់ សាការ៉ៃ អើយ ញ៉ង ហឌូង អ៊ឺម គ្រែដៃ កន់ដ្រាគ់ ឡើ ផម តាម អ្រឡា ហៃ ឡើយ។ ទ្រី ហៃ អ៊ែ លំប៊ិច កួន កឡ មូយ ហន់ជុ ម៉ាត់ ណគ “យ៉ូហាន”។ ");
INSERT INTO brb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","កួន ហៃ ហង់អ៊ិន លំពញឹម ក្លើម ក្លាក ហៃ ដើម បនឹះ ទុត អើន មន់រ៉គ់សំ ឆំតក ប៉ាគ់ទឺ ដើ កួន ហៃ លន់កើត។ ");
INSERT INTO brb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","កួន គ្រែដៃ ឡើ អាំ ដើ ហៃ នែ លំបនឹះ ទិះ ក្រាគ់ លំត្រ ប៊ឹង ងឺរ គ្រែដៃ កន់ដ្រាគ់។ គ្រែដៃ តៃ លន់អាំ ញែត តវែ ដើម រ៉ាះ ប៊ូ អ៊ឺម លំប៊ិង ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ តើម ប៊ឹង ពឌិវ ម៉ិ។ ");
INSERT INTO brb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","កួន ហៃ អ៊ិន លន់ច្រា សុនសាត អ៊ីស្រាអ៊ែល ទុត អើន មន់ជឹ ដាំង គ្រែដៃ កន់ដ្រាគ់ មែ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","កួន ហៃ អ៊ិន លំប៊ឹះ អន់នួរ គ្រែដៃ ដើម លំប៊ិង ដើ ផវ យ៉ាង ឆង៉ាត់ ប៉ាគ់ យ៉ាគ់ អ៊ែលីយ៉ា ទឺ បក់ លំពន់ត្រ ចនិះ មែគ បើគ អាំ មន់ម៉ើត កួន មែ អន់ណាវ ដើម លំពលិះ ចនិះ បនឹះ ណគ់ តៃ ម៉ើ ចង់ហៀង ប្រម៉ាង គ្រែដៃ អាំ មន់ដក់ តាម ខនឹត ចាគ់ ទឹង ត្រ អន់ណាវ ដើម លន់ច្រា តវឹញ ចនិះ បនឹះ អាំ មន់ចង់ហៀង ប្រម៉ាង គ្រែដៃ កន់ដ្រាគ់»។ ");
INSERT INTO brb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","យ៉ាគ់ សាការ៉ៃ ឡើ តង៉ា ឞាវ គ្រែដៃ រៀន៖ «ពយ៉ិ អន់ណោះ រៀន ទ្រី អៃ លំប៊ិច កួន ម៉ាត់ ម៉ាត អៃ អក្រាគ់ៗ ឡើយ ណគ់ ទ្រី អៃ ឡើ ក្រាគ់ៗ ប៉ាគ់ទឺ ផវ យ៉ាវ លំប៊ិច កួន»។ ");
INSERT INTO brb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ឞាវ គ្រែដៃ ឡើ ត្រណើវ រៀន៖ «ម៉ាត់ អៃ ឝ៉ាប៊្រីយែល អៃ នែ ឡើយ អគូ ប៊ឹង ងឺរ គ្រែដៃ ឡើ ប៉្រៃ អទឺះ ពហាយ កាន ចាគ់ នែ ដើ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ហន់ឝ្លាំង យ៉ឹ ហន់កំប្ល យ៉ាក់ តៃ ហចាប់ ប្រម៉ាង អៃ អហាយ ដើ ហៃ ញឹះ កាន នែ លន់កើត ដាវ អ៊ែ ហន់ណោះ ចជែ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","បូវ មែ ម៉ើ អ៊ឺរ ដាំង គ្រែដៃ ម៉ើ គូ ចាំ យ៉ាគ់ សាការ៉ៃ ទុត ឌុញ ម៉ើ ឃឹត ប៉ិ ឋូវ ឡើ ឌុញ ឞាល់ នែ ដមិញ ឋូវ លំញឺះ តើម ប៊ឹង កនុង រ៉ូង។ ");
INSERT INTO brb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ហំប៊្រុះ ឡើ ញឺះ ហឹ បយឺង ឡើ ណោះ យ៉ាវ ឡើ ចជែ ដើ មែ អ៊ែ ម៉ើ ណោះ រៀន អាត ឡើ តៃ កាន ឆង៉ាត់ ប្រាវៗ ឡើយ ហឹ កនុង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ យ៉ាគ់ សាការ៉ៃ ឡើ ព្រឌីវ ដើ មែ ដើ ទី ណគ ណាគ់ ឡើ កំប្ល ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ប៊ឹង យ៉ាគ់ សាការ៉ៃ ឡើ បើម កាន ង៉ាន ទឹង រ៉ូង ទិះ គ្រែដៃ លែវ ឡើយ អ៊ែ ឡើ ជឹ ហឹ ហន់ណាម ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ែលីសាបិត ឡើ តមែវ ប្រយ ឡើ កដក ចាក់ ឡើ គូ ទឹង ហន់ណាម សើង ខៃ ញឹះ តៃ ឡើ វីះ ហឹ ង៉ាយ យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ឡើ ឃឹត រៀន៖ «ណិះៗ នែ គ្រែដៃ កន់ដ្រាគ់ ឡើ បើម អន់ចាគ់ ឡើយ ដើ អៃ ណគ ឡើ តប៉ាត់ កាន អៃ អកម៉ាវ ដើ បូវ ញ៉ន តៃ អប៊ិច កួន»។ ");
INSERT INTO brb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ទឹង អ៊ែលីសាបិត ឡើ តមែវ ហន់ដើម ត្រូវ ខៃ ឡើយ គ្រែដៃ ឡើ ប៉្រៃ ឞាវ ណគ ឝ៉ាប៊្រីយែល លំទឺះ ទិ ស្រ៊ុក ណាសារែត ស្រុក ឝ៉ាលីលែ។ ");
INSERT INTO brb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ឡើ ប៉្រៃ ដក់ ហឹ កទ្រី ប្រោះ ឈ្រែង ឆ្រង ស៊ីត ប៊ីត ឡើ ត្រ មែគ បើគ អំប្រា ម៉ើ អ្រឡា ឡើយ ប៊ឹង កឡ មូយ រ៉ា ម៉ាត់ ណគ យ៉ូស៊ែប ម៉ិ យ៉ាគ់ ណគ សឋិច ដាវីត ណគ់ កទ្រី ប្រោះ ឈ្រែង ឆ្រង ស៊ីត ប៊ីត នែ ម៉ាត់ ណគ ណាង ម៉ារី។ ");
INSERT INTO brb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","អ៊ែ ឞាវ គ្រែដៃ ឡើ ដក់ ហឹ ណាង ម៉ារី ឡើ តង៉ា ឡា រៀន៖ «ណាគ់ ហរ៉គ់សំ ឡះ ណាង ម៉ារី គ្រែដៃ កន់ដ្រាគ់ ឡើ អាំ កាន ចាគ់ ដើ ហៃ លន់គូ ប៊ឹង ហៃ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ហំប៊្រុះ ណាង ម៉ារី ឡើ ដុង ប្រម៉ាង ឞាវ គ្រែដៃ ហាយ ដើ ណគ ប៉ាគ់ អ៊ែ ហឡឹង ប្រយ ឡើ គូ (ប៉ិ ឋូវ ឡើ ម៉ាង ដើ អៃ ប៉ាគ់ អ៊ិន)។ ");
INSERT INTO brb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ឞាវ គ្រែដៃ ឡើ ហាយ ដើ ណគ រៀន៖ «ណាង ម៉ារី អើយ! ញ៉ង ហឌូង អ៊ឺម យ៉ាក់ គ្រែដៃ ឡើ អាំ កាន ចាគ់ ដើ ហៃ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","អ៊ែ ហន់តមែវ ហន់អន់ឆិ កួន កឡ មូយ ហន់ជុ ម៉ាត់ ណគ “យែស៊ូ”។ ");
INSERT INTO brb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","កួន ហៃ អ៊ិន លំបើម ទិះ ក្រាគ់ មែ មន់ជុ ណគ កួន កឡ គ្រែដៃ ទិះ ឈ្រូង គ្រែដៃ កន់ដ្រាគ់ លំពឌឹក ណគ បើម សឋិច ប៉ាគ់ ដើ យ៉ាគ់ ដាវីត ម៉ិ យ៉ាគ់ ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ណគ លំឌឹក បើម សឋិច ពឺង សុនសាត អ៊ីស្រាអ៊ែល ដឌែ ណគ លំពែក ប៉ាក់ រន់ឋាប់ ឝ្លាំង មែ ឡូច អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ណាង ម៉ារី ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ ង៉ាយ ដឹះ កាន អ៊ិន លន់កើត យ៉ាក់ អៃ ណាគ់ អប្រោះ ញឹះ តៃ អណោះ កី ដើ កឡ អំម៉ឹះ?» ");
INSERT INTO brb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ឞាវ គ្រែដៃ ឡើ ត្រណើវ រៀន៖ «ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ លំទឺះ គូ ទិ ហៃ អាតណាត គ្រែដៃ ទិះ ឈ្រូង លំឞាំង ដុប កុប លែប ហៃ។ កួន ហៃ ហង់អ៊ិន លំចាគ់ លួង មន់ជុ ណគ កួន កឡ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ឞាវ គ្រែដៃ ឡើ ហាយ អន់ណាវ ដើ ណាង ម៉ារី រៀន៖ «អើយ ម៉ារី! យ៉ាគ់ អ៊ែលីសាបិត អំម៉ោះ អោះ ហៃ ទុត ម៉ើ រៀន ឡើ កន់ដុង ឡើ ក្រាគ់ៗ ឞាល់ អ៊ែ ណាគ់ ឡើ តមែវ ញឹះ ត្រូវ ខៃ ណិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","អង់ង៉ាយៗ គ្រែដៃ ឡើ បើម ដូវ លែក អិះ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ណាង ម៉ារី ឡើ រៀន៖ «អៃ អបើម ឞយ គ្រែដៃ កន់ដ្រាគ់ អាំ លំដាវ ដើ អៃ ប៉ាគ់ ប្រម៉ាង ហៃ អ៊ិន ឆិ»។ ប៊្លី អ៊ែ ឞាវ គ្រែដៃ ឡើ វីះ តើម ប៊ឹង ណាង ម៉ារី ខៀង។ ");
INSERT INTO brb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ប៊្លី អ៊ែ ណាង ម៉ារី ឡើ រន់ឋាប់ ដ្រិះៗ ឡើ ដក់ ឆើ អំម៉ោះ អោះ ណគ យ៉ាគ់ អ៊ែលីសាបិត ហឹ ស្រ៊ុក លមូយ ស្រុក យូដា ឡើ ប៊ិច ចន់ឌូ អើនៗ។ ");
INSERT INTO brb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ហំប៊្រុះ ឡើ ប៊ឹះ ហឹ អ៊ែ ឡើ មឹត ទឹង ហន់ណាម យ៉ាគ់ សាការ៉ៃ អ៊ែ ឡើ តង៉ា ឡា យ៉ាគ់ អ៊ែលីសាបិត។ ");
INSERT INTO brb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ប៊ឹង ណាង ម៉ារី ឡើ តង៉ា ឡា ណគ យ៉ាគ់ អ៊ែលីសាបិត ឡើ ដុង អង់អាង ទឹង ពឌិវ ណគ ឡើ អំម៉ិះ ឆិញៗ អ៊ែ យ៉ាគ់ អ៊ែលីសាបិត ឡើ ប៊ិង ប្រយ ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ណគ ឡើ ម៉ាង ថាំងៗ រៀន៖ «គ្រែដៃ កន់ដ្រាគ់ ឡើ ប្រាយ កាន ចាគ់ ដើ ហៃ ញឹះ ជឺរ កទ្រី ហឹ គែង កង់ ដើម ដើ កួន ហៃ ទឹង ពឌិវ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","តៃ ឃឺ អ៊ឺម អៃ នែ ប៉ាគ់ នែ ញឹះ ឌិត មែគ គ្រែដៃ កន់ដ្រាគ់ ឡើ ដក់ កវាំង ហឹ អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ហំប៊្រុះ អដុង ប្រម៉ាង ហៃ ហតង៉ា ឡា អៃ អ៊ែ អដុង អង់អាង ទឹង ពឌិវ អៃ ឡើ អំម៉ិះ ឆិញៗ ប្រយ ញ៉ន ឡើ ញឹម ក្លើម» ");
INSERT INTO brb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","យ៉ាគ់ អ៊ែលីសាបិត ឡើ ហាយ អន់ណាវ រៀន៖ «ហៃ ហហ្រនុក ហ្រវ៉ាក ឡើយ ញ៉ន ហចាប់ ម៉ាង គ្រែដៃ កន់ដ្រាគ់ លំដាវ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ប៊្លី អ៊ែ ណាង ម៉ារី ឡើ ម៉ាង រៀន៖ «អៃ អព្រតឹះ ព្រនែ គ្រែដៃ កន់ដ្រាគ់ តូច ចនិះ រំឞ៊ិះ ");
INSERT INTO brb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","អញឹម ក្លើម ដើ គ្រែដៃ ឡើ ហវ៉ាត់ អៃ ");
INSERT INTO brb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ញ៉ន គ្រែដៃ ឡើ ឝ្លាំង ស្រុស្រៀត អៃ អបនឹះ តៃ អម៉ាត ប៊ីត អបើម ឞយ ណគ។ ប៊្លី អ៊ែ ហឹ ងឺរ តគ់ បនឹះ ត្រំ ប៉ាង មន់ជុ អៃ រៀន អបនឹះ ហ្រនុក ហ្រវ៉ាក ម៉ាត់ ម៉ាត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","យ៉ាក់ គ្រែដៃ ឡើ ឆង៉ាត់ ទុត ថាំង ឡើ បើម កាន ចាគ់ ដើ អៃ។ គ្រែដៃ ឡើ ចាគ់ លួង។ ");
INSERT INTO brb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","គ្រែដៃ ឡើ ស្រុស្រៀត បនឹះ ត្រំៗ ប៉ាង ណគ់ មែ ម៉ើ អៀល បឹះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","គ្រែដៃ ឡើ ពដៃ កាន ឆង៉ាត់ ឡើ តវីះ ពន់ឌ្រុះ ណគ់ មែ ម៉ើ ព្រដ ព្រឆាន់ ទឹង ចនិះ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ឡើ កលីះ មែ ទិះ ក្រាគ់ ម៉ើ ប៊ិច អាតណាត អ៊ែ ឡើ ពឌឹក ណគ់ បនឹះ តៃ ម៉ាត ប៊ីត អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ឡើ អាំ ផិ ប៊ិង ញឹម សាំង ណគ់ មែ ម៉ើ ពងួត ឝ៉្លក។ អ៊ែ ណគ់ ដើ មែ ម៉ើ ប៊ិច បាក់ ឡើ តវីះ មែ ម៉ើ ជឹ ទី មិៗ។ ");
INSERT INTO brb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ឡើ ប៉ូរ មែ ប៉ាសាសុន អ៊ីស្រាអ៊ែល ឞយ ណគ ឡើ ស្រុស្រៀត ញឹះ តៃ វឺញ ប៊ឹះ ខៃ ណូវ ");
INSERT INTO brb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","តាម ឡើ ខណាត ដើ ម៉ិ យ៉ាគ់ ង៉ាយ ពន់ឋើម ដើ យ៉ាគ់ អាប្រាហាំ ដើម កួន ចូវ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ណាង ម៉ារី ឡើ គូ ហឹ យ៉ាគ់ អ៊ែលីសាបិត ពែ ខៃ អ្យាង អ៊ែ ណគ ឡើ ជឹ វឹញ ហឹ ហន់ណាម ឡើ កឡឹ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ប៊្លី អ៊ែ យ៉ាគ់ អ៊ែលីសាបិត ឡើ ណុះ ខៃ អ៊ែ ឡើ អន់ឆិ កួន ណគ ឡើ កឡ។ ");
INSERT INTO brb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ឡើ លឺ ទឹង មែ ក្លាង ស៊្រុក ដើម អំម៉ោះ អោះ ណគ ម៉ើ ដុង «គ្រែដៃ កន់ដ្រាគ់ ឡើ ពដៃ កាន ស្រុស្រៀត ដើ ណគ»។ អ៊ែ ម៉ើ ដក់ ង៉ាះ រ៉គ់សំ ឆំតក ប្រយ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","តើម ប៊ឹង អ៊ែ ថាម តង៉ៃ មែ ក្លាង ស្រ៊ុក ម៉ើ ដក់ ផូវ ឞ៊ុន ចៀត ដម៉ូច ហំបក អង់អាង ហឹ ហន់ណាម មែគ បើគ ណគ អ៊ែ ម៉ើ ងុញ ជុ ម៉ាត់ ណគ សាការ៉ៃ ប៉ាគ់ ម៉ាត់ បើគ ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","អ៊ែ មែគ ណគ ឡើ ដ្រើះ ម៉ាង មែ រៀន៖ «អ៊ឺម! យ៉ូហាន លន់ត្រ ងន់ជុ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","បូវ មែ ម៉ើ ត្រណើវ រៀន៖ «ទឹង អំម៉ោះ អោះ ព្រឝ៉ើត យូ សប្រា ញឹះ តៃ ប៊ិច អំម៉ឹះ ម៉ាត់ ប៉ាគ់ អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","មែ ម៉ើ តង៉ា យ៉ាគ់ សាការ៉ៃ ម៉ើ ព្រឌីវ ដើ ទី៖ «អង់ង៉ាយ ដឹះ ហងុញ ជុ ម៉ាត់ កួន ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","យ៉ាគ់ សាការ៉ៃ ឡើ ឡា កន់តារ ខៀន ហឹ មែ អ៊ែ ឡើ ខៀន ប្រយ៖ «កួន អៃ នែ ម៉ាត់ ណគ យ៉ូហាន»។ មែ ទឹង អ៊ែ ហឡឹង ប្រយ ម៉ើ គូ។ ");
INSERT INTO brb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ហំប៊្រុះ ដើ អ៊ែ បួរ ដើម ហពៀត យ៉ាគ់ សាការ៉ៃ ឞ្រាង ប្រយ ឡើ ណោះ ម៉ាង ប៉ាគ់ រីវ មាំង ទឺ ឡើ ព្រតឹះ ព្រនែ ប្រយ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","មែ ក្លាង ស្រ៊ុក ម៉ើ ឌូង អៀល បឹះ លែក រ៉ា ម៉ើ ប៉ច អំប៉ច កាន ណគ់ អន់នែ បុ ស្រ៊ុក ទឹង ចន់ឌូ ស្រុក យូដា។ ");
INSERT INTO brb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","តូច ដើ មែ ម៉ើ ដុង កាន អន់នែ ម៉ើ ឃឹត អង់ឃឹត ជុ ទឹង ចនិះ រៀន៖ «ណោះ ប៉ាគ់ ង៉ាយ កួន ណគ់ អន់នែ អន់ទុន លំបើម យ៉ាក់ អាតណាត គ្រែដៃ កន់ដ្រាគ់ ឡើ គូ ប៊ឹង ណគ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ប៊្លី អ៊ែ យ៉ាគ់ សាការ៉ៃ បើគ អង់អាង នែ ឡើ ប៊ិង ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ឡើ ហាយ ប្រម៉ាង គ្រែដៃ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«ញ៉ះ ញំព្រតឹះ ព្រនែ គ្រែដៃ ឡើ កន់ដ្រាគ់ សុនសាត អ៊ីស្រាអ៊ែល ង៉ាយ យ៉ាក់ ណគ ឡើ ទឺះ ឡោះ ប៉ាសាសុន ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","គ្រែដៃ ឡើ អាំ កឡ មូយ រ៉ា ឡើ ប៊ិច អាតណាត ឆង៉ាត់ ឡើ ទឺះ ហវ៉ាត់ ង៉ាយ ណគ អ៊ែ ឡើយ ឡើ កន់ស៊ែ យូ សឋិច ដាវីត ដាវីត នែ ពន់ឋើម ឡើ បើម ឞយ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","លន់កើត ដាវ ប៉ាគ់ គ្រែដៃ ឡើ ខណាត តាម លញ៉ាគ់ កឡា ឈូន ប្រម៉ាង ណគ ណាគ់ ឡៃ មាំង ឡើយ។ មែ ម៉ើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ណគ លំហវ៉ាត់ ង៉ាយ តើម ប៊ឹង ទី ដ្រម៉ា អាំ ងន់ក្លើច តើម ប៊ឹង អាតណាត ណគ់ មែ តៃ ម៉ើ រែម ឡាំងៗ ដើ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ណគ ឡើ ពដៃ កាន ស្រុស្រៀត ដើ ម៉ិ យ៉ាគ់ ង៉ាយ ដើម ឡើ បើម ពឡូច អាំ លែវ កាន ចាគ់ ដាវ ណគ ឡើ ខណាត ខណាំ ប្លះ ណគ ប្លះ មែ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ឡើ ខណាត តប៉ឹន ចាក់ ឡើ កឡឹ ដើ យ៉ាគ់ អាប្រាហាំ ព្រឝ៉ើត យូ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ឡើ រៀន លំតោះ ង៉ាយ តើម ប៊ឹង ទី ដ្រម៉ា បក់ ង៉ាយ ងន់ណោះ អៀល បឹះ ណគ តៃ ប៊ិច ងន់ឌូង ដើ មែ យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ដើម អាំ ង៉ាយ ងន់គូ ចាគ់ ស៊ីត ទឹង ត្រ ប៊ឹង ម៉ាត់ គ្រែដៃ អន់សច ឆា ដើ គែត»។ ");
INSERT INTO brb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","យ៉ាគ់ សាការ៉ៃ ឡើ ហាយ ដើ កួន ណគ រៀន៖ «អ៊ែ ណគ់ ដើ ហៃ អន់ណាវ កួន អើយ ហំបើម កឡា ឈូន ប្រម៉ាង គ្រែដៃ ទិះ ឈ្រូង យ៉ាក់ ហៃ ហន់ដក់ ចឝ៉ះ ទ្រូង អន់នួរ ដើ គ្រែដៃ គ្រិះ ឡើ កន់ដ្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ហៃ ហំពហាយ អាំ ដើ មែ ប៉ាសាសុន គ្រែដៃ មន់ណោះ រៀន គ្រែដៃ លំហវ៉ាត់ មែ លំតាក់ ថូត មែ ");
INSERT INTO brb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ញ៉ន ឡើ ស្រុស្រៀត មែ លែក ចនិះ រំឞ៊ិះ។ ទឹង ឡើ ប៊ឹះ ទិ នែ ឡើ ព្រឌីវ ប៉ាគ់ ម៉ាត់ តង៉ៃ ចាំ ឌឹកៗ ឡើ ចាល់ ទិ ង៉ាយ ");
INSERT INTO brb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","បក់ លំពឝ៉ាល លែក ដើ បូវ ណគ់ មែ ម៉ើ គូ ទឹង ហ្រង៉ូម កន់ដ្រូម ឌូង កាន គែត ដឹប ណគ លំពដៃ ទ្រូង ដើ មែ មន់ដក់ ហឹ កាន ហ្រនុក ហ្រវ៉ាក»។ ");
INSERT INTO brb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","យ៉ូហាន នែ ឡើ ចាំ ទិះ អន់ឆើន អើន កម៉ តៃ ចាក់ ដៃ ដើម ចនិះ ដិ។ ណគ ឡើ គូ គូម ហឹ ត្រិញ ក្លៀវៗ ញឹះ ឆា លំប៊ឹះ តង៉ៃ គ្រែដៃ លំប៉្រៃ ណគ ដក់ ពង់ហៀន មែ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO brb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ទឹង ប៉ាង យ៉ាគ់ អូឝុះ ឡើ បើម សឋិច ទិះ មួង រ៉ូម ឡើ ប៉្រៃ អាំ ម៉ើ ខៀន ជុ តមួត ម៉ាត់ ប៉ាសាសុន លែក រ៉ា ទឹង ប៊្រី ដាក ណគ អ៊ែ លំណោះ អំម៉ើន មែ ឡើ ប៊ិច ស៊ិ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","សឋិច ឡើ ប៉្រៃ ម៉ើ ខៀន តមួត ម៉ាត់ ប៉ាសាសុន អន់នួរៗ អ៊ែ ទឹង យ៉ាគ់ គីរីញុះ ឡើ បើម ទិះ ក្រាគ់ ទឹង ស្រុក ស៊ីរី។ ");
INSERT INTO brb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","មែ បូវ លែក រ៉ា ម៉ើ ដក់ ខៀន ម៉ាត់ ហឹ ស៊្រុក ម៉ិ យ៉ាគ់ មែ កឡឹ ត្រំ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","អ៊ែ យ៉ូស៊ែប ដើ ណគ ឡើ ដក់ ប៉ាគ់ទឺ តើម ប៊ឹង ស៊្រុក ណាសារែត ស្រុក ឝ៉ាលីលែ ឡើ ឌឹក ទឹង ស៊្រុក ប៊ែថលែហិម ស្រុក យូដា ឡើ ស៊្រុក កណើត សឋិច ដាវីត យ៉ាក់ យ៉ាគ់ យ៉ូស៊ែប ម៉ិ យ៉ាគ់ ណគ សឋិច ដាវីត។ ");
INSERT INTO brb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ណគ ឡើ ដក់ ខៀន ម៉ាត់ អរែង ដើ ណាង ម៉ារី ទ្រី ណគ ហន់ដើម ឡើ អ្រឡាង ក្រាគ់  ឡើ តមែវ ញឹះ ចើយ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ទឹង អំប្រា គូ ហឹ អ៊ែ ណាង ម៉ារី ឡើ ណុះ ខៃ ប្រយ ");
INSERT INTO brb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ណគ ឡើ អន់ឆិ កួន ឡង់ កឡៗ ឡើ ចូម ដើ ហំបាន ឡើ ពឝ៉ី ទឹង ក្រឡោះ ចនៀម បណាន់ មែ យ៉ាក់ ហន់ណាម តមួយ មែ ឡើ កដៀត ឡើយ ញឹះ តៃ ប៊ិច ហូះ។ ");
INSERT INTO brb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ហឹ ត្រិញ ដៀក ស៊្រុក មែ ប៊ិច បូវ ម៉ើ បយ៉ា បប៊ែ ចៀម មាំងៗ ម៉ើ គូ ញ៉ាម បណាន់ មែ ហឹ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ហំប៊្រុះ ដើ អ៊ែ ម៉ើ តៃ ប្រយ ឞាវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ទឺះ ឆុង ដៀក មែ ទ្រឺញ ប្រយ ឡើ ឝ៉ាល បុ មែ បក់ យ៉ាវ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ អន់ឆាក់ យ៉ាង។ ");
INSERT INTO brb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ឞាវ គ្រែដៃ ឡើ ហាយ ដើ មែ រៀន៖ «ញ៉ង វ៉ើ ឌូង អ៊ឺម អៃ អទឺះ ហាយ កាន ចាគ់ ដើ វែ កាន ចាគ់ នែ លំបើម អាំ ដើ បនឹះ លែក រ៉ា មន់ញឹម ក្លើម ក្លាក តៃ ឋាំ ");
INSERT INTO brb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","យ៉ាក់ មាំង នែ ហឹ ស្រ៊ុក សឋិច ដាវីត ប៊ិច កឡា ហវ៉ាត់ វែ មូយ រ៉ា ឡើ កើត បឹ ហង់អ៊ិន ឡើយ ឡើ គ្រែដៃ គ្រិះ ឡើ កន់ដ្រាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","អ៊ែ វន់ណោះ ហឝ៉ាវ កាន ឡើ ដាវ វន់តៃ អង់អាង ម៉ើ ពសាប់ ដើ ហំបាន ពឝ៉ី ទឹង ក្រឡោះ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ហំប៊្រុះ ដើ អ៊ែ ឡើ ប៊ិច បូវ ឞាវ គ្រែដៃ ទុត អើន ញឹះ តូវ ឡើ ព្រដៀត ភូះ ចំភូះ យុង ហយុង ម៉ើ ទឺះ តើម ទិ ហូង គ្រែ ម៉ើ តមួត ព្រតឹះ ព្រនែ គ្រែដៃ អរែង ដើ ឞាវ អន់ឌូ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ញ៉ះ ញំព្រតឹះ ព្រនែ ពលឺ ពន់ដុង គ្រែដៃ ឡើ គូ ទឹង ហូង ឈ្រូង តៃ ឋាំ អ៊ែ ដើ បនឹះ ណគ់ គ្រែដៃ ឡើ ម៉ើត មន់គូ ឆនឹម ហន់ណាំង ទិ ឡាង ពដិះ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ក្លើច ត្រិច បូវ ឞាវ ម៉ើ ជឹ ទឹង ហូង គ្រែ ទឺ ឡើយ អ៊ែ បូវ មែ បយ៉ា ចៀម ម៉ើ ចន់ដ្រា ត្រឌីវ មែ រៀន៖ «ញ៉ះ ញន់ដក់ ហឹ ស្រ៊ុក ប៊ែថ្លែហិម អ៊ែ ងន់តៃ កាន ឞាវ គ្រែដៃ ឡើ ពហាយ ដើ ង៉ាយ អន់ឌូ អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","អ៊ែ ម៉ើ ដក់ សាត ប្រយ ដ្រិះៗ ហឹ អ៊ែ។ ប៊ឹះ តគ់ អ៊ែ ម៉ើ តៃ ប្រយ ណាង ម៉ារី ដើម យ៉ូស៊ែប អំប្រា ពឝ៉ី អង់អាង ទឹង ក្រឡោះ បណាន់។ ");
INSERT INTO brb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ប៊ឹង បូវ មែ បយ៉ា ចៀម ម៉ើ តៃ អង់អាង នែ អ៊ែ ម៉ើ ពប៉ច កាន អង់អាង ឡើ កើត ណគ់ ឞាវ គ្រែដៃ ឡើ ហាយ ដើ មែ អន់ឌូ ");
INSERT INTO brb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","អ៊ែ លែក ដើ បូវ ម៉ើ ចង់ហៀង មែ បយ៉ា ចៀម ម៉ើ ពប៉ច ហឡឹង ប្រយ ម៉ើ គូ។ ");
INSERT INTO brb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","អ៊ែ ដើ ណាង ម៉ារី ឡើ គឹន អង់គឹន ជុ ទឹង ចនិះ ដឌែ ដើ កាន ឡើ កើត អ៊ែ ");
INSERT INTO brb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ប៊្លី អ៊ែ បូវ មែ បយ៉ា ចៀម ម៉ើ ជឹ ហឹ ទឺ អន់ណាវ ដើម ម៉ើ ពលឺ ពន់ដុង ព្រតឹះ ព្រនែ គ្រែដៃ យ៉ាក់ លែក ដើ កាន ឞាវ គ្រែដៃ ឡើ ហាយ ដើ មែ ម៉ើ ដុង ដើម ម៉ើ តៃ ឡើ ដាវ ម៉ាត់ ម៉ាត ញឹះ តៃ យូច។ ");
INSERT INTO brb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ថាម តង៉ៃ តើម ប៊ឹង អ៊ែ ម៉ើ បើម ឞ៊ុន ចៀត ដម៉ូច ហំបក អ៊ែ អំប្រា ជុ ម៉ាត់ អង់អាង អ៊ែ “យែស៊ូ” ប៉ាគ់ ឞាវ គ្រែដៃ ឡើ ប៉្រៃ ជុ ណាគ់ តៃ ដាន់ មែគ ណគ ឡើ តមែវ អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ប៊្លី អ៊ែ ឡើ ប៊ឹះ តង៉ៃ ត្រ អំប្រា លំបើម ឞ៊ុន ពឆ្រះ ចាក់ យ៉ាគ់ យ៉ូស៊ែប អំប្រា ណាង ម៉ារី អំប្រា ដក់ ហឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ហឹ មួង យែរូសាឡឹម បើម ឞ៊ុន ពឆ្រះ ចាក់ ដៃ ចនិះ រំឞ៊ិះ អំប្រា តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ តើម ប៊ឹង ឡៃ មាំង ដើម អំប្រា លំម៉ប អង់អាង ដើ គ្រែដៃ កន់ដ្រាគ់ ដិ ");
INSERT INTO brb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ប៉ាគ់ ង៉ើ អាន ទឹង ពឹម ចឞាប់ គ្រែដៃ កន់ដ្រាគ់ រៀន៖ «លែក ដើ កួន កឡ ឡង់ៗ ត្រ ម៉ប អាំ ដើ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","អ៊ែ អំប្រា តៀត ជែម បើម ឞ៊ុន ពឆ្រះ ចាក់ ប៉ាគ់ ទឹង ពឹម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ខៀន ជុ រៀន៖ «ត្រ តៀត ថួយ ម៉ប ដើ គ្រែដៃ កន់ដ្រាគ់ គុរ មូយ ហំប៊្រុក លឺ ព្លឹក ច្រាយ អន់ច្រាយ មូយ ហំប៊្រុក»។ ");
INSERT INTO brb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ហឹ មួង យែរូសាឡឹម ឡើ ប៊ិច កឡ មូយ រ៉ា ម៉ាត់ ណគ ស៊ីមៀន ឡើ បនឹះ ចាគ់ ទឹង ត្រ ឡើ បើម ត្រួយ តាម ប្រម៉ាង គ្រែដៃ ឡើ គូ ចាំ តង៉ៃ គ្រែដៃ លំប៊ឹះ ពញឹម ក្លើម មែ ប៉ាសាសុន អ៊ីស្រាអ៊ែល ញ៉ង អាំ មន់ឝ្រង៉ឹត ស្រូក យ៉ាវ។ យ៉ាគ់ ស៊ីមៀន នែ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ឡើ គូ ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","អ៊ែ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ឡើ បើម អាំ យ៉ាគ់ ស៊ីមៀន ចនិះ ភៀក ឡើ ណោះ រៀន ណគ តៃ លន់គែត អ៊ឺម ឆា ដើ លំតៃ គ្រែដៃ គ្រិះ។ គ្រែដៃ កន់ដ្រាគ់ ឡើ ប៉្រៃ គ្រែដៃ គ្រិះ ទឺះ ហវ៉ាត់ ប៉ាសាសុន ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ផវ យ៉ាង គ្រែដៃ ឡើ ច្រា មឹត ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ទឹង យ៉ាគ់ យ៉ូស៊ែប អំប្រា ណាង ម៉ារី អំប្រា តៀត យែស៊ូ ហឹ អិះ ទឺ បក់ មន់ម៉ប អង់អាង ហឹ គ្រែដៃ កន់ដ្រាគ់ ត្រួយ តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ។ ");
INSERT INTO brb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","អ៊ែ យ៉ាគ់ ស៊ីមៀន ឡើ ចក់ អង់អាង ម៉ើ ពយ៉ ហឹ ណគ ប៊្លី អ៊ែ ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ឡា គ្រែដៃ កន់ដ្រាគ់ អើយ! អៃ នែ អឞយ ហៃ ឡើយ ណិះៗ ហៃ ហអាំ អៃ អន់តាក់ ឡាង ប្រិះ នែ តង៉ៃ ង៉ាយ កតាម អង់គែត ញឹម សាំង ឡើយ យ៉ាក់ ហៃ ហបើម ពលែវ ឡើយ តាម កាន ហខណាត ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","យ៉ាក់ អតៃ ដើ ម៉ាត់ ឡើយ ណគ់ កឡា ហវ៉ាត់ ញ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ណគ់ ហៃ ហអាំ កឡា ហវ៉ាត់ នែ ដើ បនឹះ លែក ដើ សុនសាត ទិ ឡាង ប្រិះ នែ ");
INSERT INTO brb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ណគ នែ ឡើយ ឡើ ពដៃ ពឝ៉ាល ចនិះ បនឹះ ដើ សុនសាត ហឹ គែង អាំ មន់ហង់ឝ៉ាវ ហៃ ដើម លំពលឺ ពន់ដុង ម៉ាត់ អ៊ីស្រាអ៊ែល ប៉ាសាសុន ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ហំប៊្រុះ យ៉ាគ់ ស៊ីមៀន ឡើ ម៉ាង កាន អង់អាង អ៊ែ មែគ បើគ អង់អាង នែ អំប្រា គូ ហឡឹង ប្រយ ដើ ប្រម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","យ៉ាគ់ ស៊ីមៀន ឡើ ប្រាយ កាន ចាគ់ ដើ អំប្រា ប៊្លី អ៊ែ ឡើ ហាយ ដើ ណាង ម៉ារី រៀន៖ «ណាង ម៉ារី អើយ! គ្រែដៃ ឡើ ប៉្រៃ កួន ហៃ ទឺះ ទិ នែ បក់ ប៉ាសាសុន អ៊ីស្រាអ៊ែល មែ អន់នឺ អើន រ៉ា មន់បង់ មែ អន់នឺ អើន រ៉ា អន់ណាវ មន់ឌឹក។ កួន នែ លំពដៃ អាំ បនឹះ មន់ហឝ៉ាវ កាន គ្រែដៃ លំហវ៉ាត់ មែ។ អ៊ែ បនឹះ ទុត អើន ម៉ើ ព្រឆាំង ដ្រើះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ លំពប៉្លើក ពដៃ ចនិះ វៀក ទឹង បនឹះ ទុត អើន។ អ៊ែ ណគ់ ដើ ហៃ អន់ណាវ ណាង ហន់តង៉ូក ឆ្រុក ឞាល់ ម៉ើ ស៊ូះ ហៃ ដើ តាវ ទឹង ក្លើម»។ ");
INSERT INTO brb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ហឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ប៊ិច កទ្រី មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ ហាណា បើគ ណគ យ៉ាគ់ ផានូអ៊ែល ឆ្រាំង យ៉ាគ់ អាស៊ែរ។ យ៉ាគ់ ហាណា នែ ឡើ កទ្រី ឈូន ប្រម៉ាង គ្រែដៃ។ ពន់ឋើម ឡើ គូ អរែង ប៊ឹង ក្ល ណគ ប៉ឹះ កម៉ ឡើយ ប៊្លី អ៊ែ ក្ល ណគ ឡើ គែត។ ");
INSERT INTO brb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ណគ ឡើ គូ កម៉ាយ ប៉ាគ់ អិះ ឡើយ ណិះៗ នែ ឡើ ក្រាគ់ៗ ម៉ៃ កំប្រាគ់ ណគ ថាម ជិត ពួន កម៉ ឡើយ។ ណគ ឡើ គូ ទឹង អិះ ឡើយ តៃ ឡើ អន់ឆូវ ដក់ ចង៉ាយ អ៊ឺម តើម ប៊ឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ អន់សច តង៉ៃ ដើម មាំង ណគ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ដឌែ ប៊ឹង អន់នឺ តូវ ឡើ អឹត ចង់ ចា ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ហំប៊្រុះ ដើ អ៊ែ យ៉ាគ់ ហាណា ឡើ ដក់ ប្រយ ហឹ យ៉ូស៊ែប អំប្រា ណាង ម៉ារី អ៊ែ ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ដើម ឡើ ហាយ កាន អង់អាង នែ ដើ មែ ម៉ើ ចាំ គ្រែដៃ លំប៊ឹះ ឡោះ មែ ទឹង មួង យែរូសាឡឹម ណគ ឡើ ប៉្រៃ មន់ណោះ រៀន អង់អាង នែ គ្រែដៃ កឡឹ ឡើ ប៉្រៃ ទឺះ។ ");
INSERT INTO brb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ប៊ឹង យ៉ូស៊ែប អំប្រា ម៉ារី អំប្រា បើម ឞ៊ុន ពឝ៉្លើច តាម ចឞាប់ គ្រែដៃ កន់ដ្រាគ់ ឡើយ អំប្រា ជឹ តៀត កួន អំប្រា ហឹ ស៊្រុក ណាសារែត ស្រុក ឝ៉ាលីលែ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","អង់គ្លែត ណគ់ អន់នែ ឡើ ចាំ ទិះ អន់ឆើន អើន កម៉ ឡើយ ឡើ ប៊ិច ពន់ដ្រិញ ពន់ដ្រួញ ចាំ ថាំង ដើម ខនឹត ណគ ចាំ អើន ប៉ាគ់ទឺ។ គ្រែដៃ ឡើ ម៉ើត ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ត្រំ កម៉ ប៊ឹង ប៊ឹះ ឞ៊ុន ពជឺរ មែគ បើគ យែស៊ូ នែ ម៉ើ កគ់ ឌឹក ទឹង មួង យែរូសាឡឹម។ ");
INSERT INTO brb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","តគ់ កួន អំប្រា អញុ ណគ ជិត បារ កម៉ ឡើយ អ៊ែ អំប្រា តៀត ណគ ឌឹក មឹត ឞ៊ុន តាម ខណើយ មែ រីវ មាំង។ ");
INSERT INTO brb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ម៉ើ បើម ឞ៊ុន លែវ ឡើយ មែគ បើគ ណគ អំប្រា ជឹ ហឹ ទឺ។ អ៊ែ ដើ កួន អំប្រា ណាគ់ ឡើ គូ ហឹ អិះ ឡើយ ហាក់ ដើ អំប្រា កឡឹ អំប្រា ណោះ អ៊ឺម ឡើ គូ ហឹ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","អំប្រា ឃឹត រៀន កួន អំប្រា អំប លំដក់ អរែង ដើ មែ បូវ។ អំប្រា ជឹ មូយ តង៉ៃ ឡើយ តគ់ ឡើ អំប៊ឹ ហន់ដើម អំប្រា សាត កួន អំប្រា ទឹង អំម៉ោះ អោះ បូវ ប៊ែង ឈែវ មែ ម៉ើ ដក់ អរែង។ ");
INSERT INTO brb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","អំប្រា សាត តៃ អំប្រា តៃ អ៊ឺម អ៊ែ អំប្រា ជឹ សាត ណគ ប៊ឹះ ហឹ មួង យែរូសាឡឹម អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","តើម ប៊ឹង អ៊ែ ញឹះ ពែ តង៉ៃ មែគ បើគ គ្រែដៃ យែស៊ូ អំប្រា តៃ កួន អំប្រា ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អំប្រា តៃ ណគ ទឹង ឡើ ដ្រូម អរែង ដើ មែ ណាយឃូ ម៉ើ ពង់ហៀន ឡើ ចង់ហៀង ដើម ឡើ ឍុ តង៉ា ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","លែក ដើ បូវ មែ ម៉ើ ចង់ហៀង ណគ ម៉ើ ឃឹត ព្រតឹះ រៀន៖ «ប៉ិ ដើ ណគ ឡើ ប៊ិច អ្រណោះ អ្រទីង ហ្រឡិច ហ្រឡាង ឞាល់ នែ ឡើ ណោះ ត្រណើវ ប្រម៉ាង ណាយឃូ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ទឹង អំប្រា តៃ កួន អំប្រា អំប្រា ញ៉ម ប្រយ អ៊ែ មែគ ណគ ឡើ ម៉ាង រៀន៖ «ប៉ិ កួន ហបើម ដើ ញឺ ប៉ាគ់ អ៊ែ ឞាល់ នែ ញឺ បើគ ហៃ ញ៉ើ តង៉ូក ឌូង ដើ ហៃ ទុត ខាក់ ញ៉ើ សាត ដាំង ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","អ៊ែ ណគ ឡើ ត្រណើវ រៀន៖ «មែគ សប្រា បើគ សប្រា សាត បើម ង៉ាយ ដឹះ ដើ អៃ? សប្រា ណោះ អ៊ឺម ឞិ អៃ អន់ត្រ គូ ហឹ រ៉ូង ទិះ គ្រែដៃ បើគ អៃ ហវ៉ៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ណគ់ ដើ មែគ បើគ ណគ នែ តៃ អំប្រា ណោះ អ៊ឺម កួន អំប្រា ណោះ ឡើ ម៉ាង ប៉ាគ់ ង៉ាយ ប៉ាគ់ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ប៊្លី អ៊ែ ឡើ ជឹ តូយ មែគ បើគ ណគ ហឹ ស្រ៊ុក ណាសារែត ទឺ។ អ៊ែ ឡើ ចង់ហៀង ត្រួយ តាម ប្រម៉ាង មែគ បើគ ណគ ដឌែ តូច ដើ កាន អ៊ែ មែគ ណគ ឡើ កាំ ជុ ទឹង ចនិះ។ ");
INSERT INTO brb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","គ្រែដៃ យែស៊ូ ចាក់ ណគ ចាំ ទិះ ចនិះ ណគ ចាំ អើន ឡើយ គ្រែដៃ ឡើ ម៉ើត ដើ ណគ បនឹះ ម៉ើ ម៉ើត ប៉ាគ់ទឺ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ជិត សើង កម៉ ឡើយ ទឹង យ៉ាគ់ ទីប៊ែរ ឡើ ឌឹក បើម សឋិច ទិះ ពែក ប៉ាក់ ប៊្រី ដាក រ៉ូម យ៉ាគ់ ពន់តៀះ ពីឡាត់ ឡើ កឡា ពែក ប៉ាក់ ស្រុក យូដា យ៉ាគ់ ហ៊ែរ៉ូត ឡើ ពែក ប៉ាក់ ស្រុក ឝ៉ាលីលែ យ៉ាគ់ ភីលីប អោះ ណគ ឡើ ពែក ប៉ាក់ ស្រុក អ៊ីទូរែ ដើម ស្រុក ត្រាខូនីត ដិ យ៉ាគ់ លីសានៀះ ឡើ ពែក ប៉ាក់ ស្រុក អាប៊ីលែន។ ");
INSERT INTO brb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","យ៉ាគ់ ហាណះ អំប្រា យ៉ាគ់ កៃផាះ អំប្រា បើម ណាយ បប៊ុះ ថួយ ដើ គ្រែដៃ។ ទឹង កម៉ អ៊ែ គ្រែដៃ កន់ដ្រាគ់ ឡើ ម៉ាង ដើ យ៉ូហាន កួន យ៉ាគ់ សាការ៉ៃ ទឹង ឡើ គូ ហឹ ត្រិញ ក្លៀវៗ។ ");
INSERT INTO brb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","អ៊ែ យ៉ាគ់ យ៉ូហាន ឡើ ដក់ ដឌែ ត្រំ អំប៊ុ ត្រំ ឞន បរ ដាក យ៉ូរដាន់ ណគ ឡើ ពហាយ ដើ បូវ អាំ មន់ពលិះ ចនិះ បក់ គ្រែដៃ លំតាក់ ថូត ដើ មែ ដើម ឡើ ប៉្រៃ អាំ មន់បើម ឞ៊ុន ម៉ូច ដាក លំពដៃ ម៉ើ ពលិះ ចនិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ណគ ឡើ ពហាយ ប៉ាគ់ អ៊ែ ឡើ ត្រ ប៉ាគ់ ខនៀន ទឹង ផាប់ យ៉ាគ់ អ៊ីសាយ រៀន៖ «លំប៊ិច បឹ កឡ មូយ រ៉ា លំពហាយ ថាំងៗ ហឹ ត្រិញ ក្លៀវៗ រៀន៖ “មិញ វន់ចឝ៉ះ ពចាគ់ ទ្រូង ដើ គ្រែដៃ កន់ដ្រាគ់ វន់ពន់ទឹង ទ្រូង ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ណគ់ លុៗ វន់ប៊ូន ពន់ឈែវ ប្លះ ចន់ឌូ ប្លះ សាង វន់ចះ ពទ្រឹប អន់ណាវ ណគ់ ទ្រូង តូងៗ វន់ពន់ទឹង ណគ់ ទ្រូង ហ្រលុ ហ្រលុន វន់ត្រាំង ព្រនៀម ប៉ាគ់ទឺ ");
INSERT INTO brb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","អ៊ែ លែក ដើ បនឹះ មន់តៃ គ្រែដៃ លំហវ៉ាត់ មែ ”»។ ");
INSERT INTO brb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","យ៉ាគ់ យ៉ូហាន ឡើ ពន់ដូះ បនឹះ ទុត អើន ម៉ើ ដក់ បើម ឞ៊ុន ម៉ូច ដាក ហឹ ណគ រៀន៖ «អើយ កួន ចូវ ប៊ិះ ប្រៃ! មែ ង៉ាយ ម៉ើ ហាយ ដើ វែ ណាគ់ វន់ដូវ ក្លើច តើម ប៊ឹង កាន មាំ គ្រែដៃ? ណាគ់ ឞិត ឞ៊ែត លំពដៃ ឡើយ កាន មាំ ណគ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","មិញ វន់បើម អន់ចាគ់ អ៊ែ លំត្រ ទឹង បនឹះ ពលិះ ចនិះ ក្លើម ម៉ាត់ ម៉ាត»។ ញ៉ង វ៉ើ អ៊ីង អ៊ឺម រៀន វ៉ើ កួន ចូវ យ៉ាគ់ អាប្រាហាំ អ៊ែ ណាគ់ វន់ក្លើច តើម ប៊ឹង កាន មាំ គ្រែដៃ។ អៃ អន់ហាយ ដើ វែ រៀន គ្រែដៃ លំចក់ លែក ដើ តម៉ នែ លំតវឹរ កួន ចូវ យ៉ាគ់ អាប្រាហាំ ដូវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","អៃ អន់ហាយ ដើ វែ ឡឹះ៖ «គ្រែដៃ ឡើ ព្រឌីវ ប៊ឹង បនឹះ ឡើ ជុ ជូង ចុ តើម ឡង ឡើយ ត្រំ តើម ណគ់ អង់ង៉ាយ ឡើ ប៉្លៃ តៃ ចាគ់ លំត្រ កូវ ហពៀវ តាក់ ហឹ អ៊ុញ»។ ");
INSERT INTO brb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","មែ ក្លាង ស្រ៊ុក ម៉ើ តង៉ា ណគ រៀន៖ «យ៉ាក់ ហម៉ាង ពអ៊ិន ប៉ាគ់ ង៉ាយ អន់ណាវ ដើ ញ៉ា ញំបើម អ៊ែ លំត្រ ទឹង ប្រម៉ើត គ្រែដៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","យ៉ាគ់ យ៉ូហាន ឡើ ត្រណើវ រៀន៖ «បឹ អង់ង៉ាយ ឡើ ប៊ិច អាវ បារ អ៊ែ លំអាំ ដើ ណគ់ តៃ ឡើ ប៊ិច អ៊ែ ណគ់ បឹ អង់ង៉ាយ ឡើ ប៊ិច ចណង់ ចណា លំអាំ ដើ បឹ ឡើ អឹត ងួត ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ប៊ឹង អ៊ែ បូវ មែ ក្រសៀក លៀន ដើ សឋិច ម៉ើ ដក់ បើម ឞ៊ុន ម៉ូច ដាក ប៉ាគ់ទឺ មែ ម៉ើ តង៉ា ណគ រៀន៖ «ណាយឃូ អើយ! ប៉ាគ់ ង៉ាយ ដឹះ ដើ ញ៉ា នែ ញំបើម?»។ ");
INSERT INTO brb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ណគ ឡើ ហាយ ដើ មែ រៀន៖ «ញ៉ង វ៉ើ ក្រសៀក លៀន ពន់ជឺរ អ៊ឺម ពន់ដ្រៃ សឋិច»។ ");
INSERT INTO brb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","មែ តហាន ម៉ើ ដក់ តង៉ា ប៉ាគ់ទឺ ណគ ម៉ើ រៀន៖ «ប៉ិ ណគ់ ដើ ញ៉ា នែ ដឹះ ប៉ាគ់ ង៉ាយ ញំបើម?»។ ណគ ឡើ ត្រណើវ មែ រៀន៖ «ញ៉ង វ៉ើ ចឹន ឆ្រឡិ ញ៉ង វ៉ើ ពញ៉ម អ៊ឺម បូវ បក់ មន់អាំ លៀន តង វន់ញឹម ក្លើម ឌិវ លៀន ខៃ វែ ឆិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","មែ ក្លាង ស្រ៊ុក ម៉ើ គូ ចាំ ឝ្លាំង ម៉ើ វ៉ឹត រៀន យ៉ាគ់ អន់នែ ឡើយ តៃ ណោះ ម៉ើ ជុ គ្រែដៃ គ្រិះ ! ");
INSERT INTO brb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","យ៉ាគ់ យ៉ូហាន ឡើ ហាយ ដើ មែ ត្រំ រ៉ា រៀន៖ «ដើ អៃ អបើម ឞ៊ុន តម៉ូច វែ ដើ ដាក ហាក់ ណាគ់ ប៊ិច បនឹះ មូយ រ៉ា អន់ណាវ ឡើ ខាក់ ជឺរ អៃ ណគ អ៊ិន ដៀប លំប៊ឹះ ឡើយ។ ណគ់ ដើ អៃ នែ សំយ៉ះ អន់តោះ កើប ប៊ឹង ឈឹង ណគ ណាគ់ តៃ លំឃឺ ណគ អ៊ិន លំតម៉ូច វែ លែក រ៉ា ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ដើម ដើ អ៊ុញ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ណគ អ៊ិន លំបើម ប៉ាគ់ បនឹះ ឡើ ឝ៉ឹន ចង់ឝួរ ដក់ កសារ ប៉ូះ បយឺង បឹត ចិះ ឡើ កឌែ អូម ចិះ ចក់ ឌិវ ចាក់ៗ ឡើ ជុ ទឹង នុក អ៊ែ ណគ់ ញ៉ាបៗ ឡើ តមួត ចុះ តាក់ ទិ អ៊ុញ ឡើ កាត ញឹះ តៃ ប៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","យ៉ាគ់ យ៉ូហាន ឡើ ពហាយ កាន ចាគ់ ដើម ឡើ ព្រតូវ គឹះ ទុត អើន អន់ណាវ មែ ក្លាង ស្រ៊ុក។ ");
INSERT INTO brb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","យ៉ាគ់ យ៉ូហាន ឡើ គឹះ ពន់ដូះ សឋិច ហ៊ែរ៉ូត ញ៉ន ឡើ សុក ណាង ហ៊ែរ៉ូដៀះ  កម៉ាន់ ណគ កឡឹ ដើម ឡើ គឹះ សឋិច ហ៊ែរ៉ូត ឡើ បើម អង់យូច តៃ ណោះ ឞាល់ ង៉ាយ ឡើយ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","អ៊ែ សឋិច ហ៊ែរ៉ូត ឡើ បើម អន់យូច ចាំ អើន ឡឹះ អន់ណាវ ឡើ ប៉្រៃ ម៉ើ រ៉ាប់ យ៉ាគ់ យ៉ូហាន ក្រាន់ ទឹង ឃុក យ៉ាក់ ឡើ មាំ កំប្រឹន ដើ យ៉ាគ់ យ៉ូហាន ឡើ គឹះ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ប៊ឹង យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន ម៉ូច ដាក ដើ មែ ក្លាង ស្រ៊ុក អើន រ៉ា ឡើយ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ យ៉ាគ់ យ៉ូហាន ប៉ាគ់ទឺ ឡើ ប៉្រៃ យ៉ាគ់ យ៉ូហាន លំតម៉ូច ដាក ដើ ណគ។ ទឹង ឡើ អ៊ឺរ ដាំង គ្រែដៃ បើគ ណគ គ្រែ ឡើ ប៉ើក ប្រយ ផូង ");
INSERT INTO brb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","អ៊ែ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ឡើ ទឺះ ប្រយ ទិ គ្រែដៃ យែស៊ូ ឡើ បើម ប៉ាគ់ កំប៊ូ ឡើ ជ្រឹប ប៊ឹង ណគ។ ម៉ើ ដុង ប្រម៉ាង តើម ទិ គ្រែ រៀន៖ «ហៃ នែ កួន ប្រម៉ើត អៃ ឡើយ ហត្រ ទឹង ក្លើម អៃ ទុត ខាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ បើម កាន ឆង៉ាត់ ដើម ឡើ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ដើ មែ ក្លាង ស្រ៊ុក អន់នួរៗ ទឹង អ៊ែ កំប្រាគ់ ណគ លន់ឃឺ ពែ ជិត កម៉ ឡើយ។ គ្រែដៃ យែស៊ូ នែ ម៉ើ វ៉ឹត រៀន បើគ ណគ យ៉ាគ់ យ៉ូស៊ែប យ៉ាគ់ យ៉ូស៊ែប បើគ ណគ យ៉ាគ់ ហ៊ែលី ");
INSERT INTO brb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","យ៉ាគ់ ហ៊ែលី បើគ ណគ យ៉ាគ់ ម៉ាត់ថាត់ យ៉ាគ់ ម៉ាត់ថាត់ បើគ ណគ យ៉ាគ់ លែវី យ៉ាគ់ លែវី បើគ ណគ យ៉ាគ់ ម៉ាល់គី យ៉ាគ់ ម៉ាល់គី បើគ ណគ យ៉ាគ់ យ៉ាណាយ យ៉ាគ់ យ៉ាណាយ បើគ ណគ យ៉ាគ់ យ៉ូស៊ែប ");
INSERT INTO brb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","យ៉ាគ់ យ៉ូស៊ែប បើគ ណគ យ៉ាគ់ ម៉ាតាធៀះ យ៉ាគ់ ម៉ាតាធៀះ បើគ ណគ យ៉ាគ់ អាម៉ុះ យ៉ាគ់ អាម៉ុះ បើគ ណគ យ៉ាគ់ ណាហ៊ុំ យ៉ាគ់ ណាហ៊ុំ បើគ ណគ យ៉ាគ់ ហិះសលី យ៉ាគ់ ហិះសលី បើគ ណគ យ៉ាគ់ ណាឝ៉ាយ ");
INSERT INTO brb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","យ៉ាគ់ ណាឝ៉ាយ បើគ ណគ យ៉ាគ់ ម៉ាអាត យ៉ាគ់ ម៉ាអាត បើគ ណគ យ៉ាគ់ ម៉ាតាធៀះ យ៉ាគ់ ម៉ាតាធៀះ បើគ ណគ យ៉ាគ់ ស៊ីមី យ៉ាគ់ ស៊ីមី បើគ ណគ យ៉ាគ់ យ៉ូសិះ យ៉ាគ់ យ៉ូសិះ បើគ ណគ យ៉ាគ់ យ៉ូដា ");
INSERT INTO brb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","យ៉ាគ់ យ៉ូដា បើគ ណគ យ៉ាគ់ យ៉ូហាណាន់ យ៉ាគ់ យ៉ូហាណាន់ បើគ ណគ យ៉ាគ់ រែសា យ៉ាគ់ រែសា បើគ ណគ យ៉ាគ់ សូរ៉ូបាប៊ែល យ៉ាគ់ សូរ៉ូបាប៊ែល បើគ ណគ យ៉ាគ់ សាល់ធៀល យ៉ាគ់ សាល់ធៀល បើគ ណគ យ៉ាគ់ នែរី ");
INSERT INTO brb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","យ៉ាគ់ នែរី បើគ ណគ យ៉ាគ់ ម៉ិលគី យ៉ាគ់ ម៉ិលគី បើគ ណគ យ៉ាគ់ អាត់ឌី យ៉ាគ់ អាត់ឌី បើគ ណគ យ៉ាគ់ កូសាម យ៉ាគ់ កូសាម បើគ ណគ យ៉ាគ់ អ៊ែលម៉ាដាម យ៉ាគ់ អ៊ែលម៉ាដាម បើគ ណគ យ៉ាគ់ អ៊ែរ ");
INSERT INTO brb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","យ៉ាគ់ អ៊ែរ បើគ ណគ យ៉ាគ់ យែសួ យ៉ាគ់ យែសួ បើគ ណគ យ៉ាគ់ អ៊ែលៀស៊ែរ យ៉ាគ់ អ៊ែលៀស៊ែរ បើគ ណគ យ៉ាគ់ យ៉ូរីម យ៉ាគ់ យ៉ូរីម បើគ ណគ យ៉ាគ់ ម៉ាត់ថាត់ យ៉ាគ់ ម៉ាត់ថាត់ បើគ ណគ យ៉ាគ់ លែវី ");
INSERT INTO brb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","យ៉ាគ់ លែវី បើគ ណគ យ៉ាគ់ ស៊ីមៀន យ៉ាគ់ ស៊ីមៀន បើគ ណគ យ៉ាគ់ យូដា យ៉ាគ់ យូដា បើគ ណគ យ៉ាគ់ យ៉ូស៊ែប យ៉ាគ់ យ៉ូស៊ែប បើគ ណគ យ៉ាគ់ យ៉ូណាម យ៉ាគ់ យ៉ូណាម បើគ ណគ យ៉ាគ់ អ៊ែលៀគីម ");
INSERT INTO brb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","យ៉ាគ់ អ៊ែលៀគីម បើគ ណគ យ៉ាគ់ មែលៀះ យ៉ាគ់ មែលៀះ បើគ ណគ យ៉ាគ់ ម៉ៃណាន់ យ៉ាគ់ ម៉ៃណាន់ បើគ ណគ យ៉ាគ់ ម៉ាតាថា យ៉ាគ់ ម៉ាតាថា បើគ ណគ យ៉ាគ់ ណាថាន់ យ៉ាគ់ ណាថាន់ បើគ ណគ សឋិច ដាវីត ");
INSERT INTO brb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","សឋិច ដាវីត បើគ ណគ យ៉ាគ់ អ៊ីសាយ យ៉ាគ់ អ៊ីសាយ បើគ ណគ យ៉ាគ់ អូប៊ែត យ៉ាគ់ អូប៊ែត បើគ ណគ យ៉ាគ់ បូអូះ យ៉ាគ់ បូអូះ បើគ ណគ យ៉ាគ់ សាល់ម៉ូន យ៉ាគ់ សាល់ម៉ូន បើគ ណគ យ៉ាគ់ ណាសូន ");
INSERT INTO brb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","យ៉ាគ់ ណាសូន បើគ ណគ យ៉ាគ់ អាមីណាដាប់ យ៉ាគ់ អាមីណាដាប់ បើគ ណគ យ៉ាគ់ អារ៉ាម យ៉ាគ់ អារ៉ាម បើគ ណគ យ៉ាគ់ អ្រនី យ៉ាគ់ អ្រនី បើគ ណគ យ៉ាគ់ ហ៊ែតស្រុន យ៉ាគ់ ហ៊ែតស្រុន បើគ ណគ យ៉ាគ់ ពែរែះ យ៉ាគ់ ពែរែះ បើគ ណគ យ៉ាគ់ យូដា ");
INSERT INTO brb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","យ៉ាគ់ យូដា បើគ ណគ យ៉ាគ់ យ៉ាកុប យ៉ាគ់ យ៉ាកុប បើគ ណគ យ៉ាគ់ អ៊ីសាគ់ យ៉ាគ់ អ៊ីសាគ់ បើគ ណគ យ៉ាគ់ អាប្រាហាំ យ៉ាគ់ អាប្រាហាំ បើគ ណគ យ៉ាគ់ ទែរ៉ះ យ៉ាគ់ ទែរ៉ះ បើគ ណគ យ៉ាគ់ ណាខូរ ");
INSERT INTO brb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","យ៉ាគ់ ណាខូរ បើគ ណគ យ៉ាគ់ ស៊ែរូក យ៉ាគ់ ស៊ែរូក បើគ ណគ យ៉ាគ់ រែហ៊ូ យ៉ាគ់ រែហ៊ូ បើគ ណគ យ៉ាគ់ ផាលែក យ៉ាគ់ ផាលែក បើគ ណគ យ៉ាគ់ ហ៊ែប៊ែរ យ៉ាគ់ ហ៊ែប៊ែរ បើគ ណគ យ៉ាគ់ ស៊ែឡា ");
INSERT INTO brb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","យ៉ាគ់ ស៊ែឡា បើគ ណគ យ៉ាគ់ កៃណាន យ៉ាគ់ កៃណាន បើគ ណគ យ៉ាគ់ អារប៉ាក់សាត យ៉ាគ់ អារប៉ាក់សាត បើគ ណគ យ៉ាគ់ សិម យ៉ាគ់ សិម បើគ ណគ យ៉ាគ់ ណូអ៊ែ យ៉ាគ់ ណូអ៊ែ បើគ ណគ យ៉ាគ់ ឡាមែក ");
INSERT INTO brb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","យ៉ាគ់ ឡាមែក បើគ ណគ យ៉ាគ់ ម៉ាត់ធូសាឡា យ៉ាគ់ ម៉ាត់ធូសាឡា បើគ ណគ យ៉ាគ់ ហ៊ែណុក យ៉ាគ់ ហ៊ែណុក បើគ ណគ យ៉ាគ់ យ៉ារែត យ៉ាគ់ យ៉ារែត បើគ ណគ យ៉ាគ់ ម៉ាលែលៀល យ៉ាគ់ ម៉ាលែលៀល បើគ ណគ យ៉ាគ់ កៃណាន ");
INSERT INTO brb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","យ៉ាគ់ កៃណាន បើគ ណគ យ៉ាគ់ អ៊ែណុះ យ៉ាគ់ អ៊ែណុះ បើគ ណគ យ៉ាគ់ ស៊ែត យ៉ាគ់ ស៊ែត បើគ ណគ យ៉ាគ់ អាដាំ យ៉ាគ់ អាដាំ កួន យ៉ាគ់ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ទឹង ឡើ ជឹ តើម ប៊ឹង ដាក យ៉ូរដាន់ យែស៊ូ ឡើ ប៊ិង ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ផវ យ៉ាង គ្រែដៃ ឡើ តៀត ណគ ហឹ ត្រិញ ក្លៀវៗ។ ");
INSERT INTO brb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ប៊ឹះ តគ់ អ៊ែ អរ៉ាក់ សតាំង ឡើ ពលូង គ្រែដៃ យែស៊ូ ពួន ជិត តង៉ៃ។ ទឹង លញ៉ាគ់ អ៊ែ គ្រែដៃ យែស៊ូ តៃ ឡើ ចង់ ចា អង់ង៉ាយ អ៊ឺម។ ញឹះ ក្លើច ពួន ជិត តង៉ៃ អ៊ែ ឡើ ដុង ពងួត។ ");
INSERT INTO brb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","អរ៉ាក់ សតាំង ឡើ ពលូង គ្រែដៃ យែស៊ូ រៀន៖ «ប៉ាគ់ ហកួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត មិញ ហំប៉្រៃ តម៉ នែ លំវឹរ ណុំពាំង ឡាំង»។ ");
INSERT INTO brb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “បនឹះ ម៉ើ ញិវ តៃ ត្រ វ៉ិះ ដើ ចណង់ ចណា អ៊ឺម ”»។ ");
INSERT INTO brb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","អរ៉ាក់ សតាំង ឡើ ឌឹក តៀត គ្រែដៃ យែស៊ូ ទឹង ឈ្រុង ឈ្រូង អ៊ែ ឡើ ចង់អូត ពដៃ លែក ដើ ប៊្រី ដាក ទឹង ឡាង ប្រិះ នែ អាំ គ្រែដៃ យែស៊ូ តៃ វ៉ិះ មូយ ហ្រវឹច។ ");
INSERT INTO brb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","អរ៉ាក់ សតាំង ឡើ ហាយ ដើ ណគ រៀន៖ «អៃ អំម៉ប លែក ដើ ប៊្រី ដាក ដើម ប្រនិច ទុត អូងអាត ទឹង ឡាង ប្រិះ នែ អង់អាំ ដើ ហៃ ហំពែក ប៉ាក់ យ៉ាក់ ប្រនិច លែក ចុ រ៉ាះ អៃ អន់អាំ ដើ មែ ង៉ាយ កតាម តាម ឌី អៃ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ប៉ាគ់ ហន់កដាប ហំបះ អៃ រ៉ាះ អំបាះ នែ អំម៉ប ដើ ហៃ អាំ លែក ហៃ ឡើយ ហំពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “ញ៉ា បនឹះ ញន់ត្រ កដាប ហំបះ គ្រែដៃ កន់ដ្រាគ់ ឡើ គ្រែដៃ ញ៉ា ញន់ត្រ ខរ៉ុប ចាប់ វ៉ិះ ឌិវ ណគ អិះ ឡើយ ”»។ ");
INSERT INTO brb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ប៊្លី អ៊ែ អរ៉ាក់ សតាំង ឡើ តៀត គ្រែដៃ យែស៊ូ ហឹ មួង យែរូសាឡឹម អ៊ែ ឡើ ជុ ណគ ទិ បូយ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ សតាំង ឡើ ម៉ាង ពលូង ឡឹះ រៀន៖ «ប៉ាគ់ ហកួន កឡ គ្រែដៃ ម៉ាត់ ម៉ាត ហំជ្រុះ ឡាំង តើម ប៊ឹង បូយ រ៉ូង នែ ទិ ប្រិះ ចុ ");
INSERT INTO brb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","យ៉ាក់ ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “គ្រែដៃ លំប៉្រៃ ឞាវ ណគ មន់លវាំង ឝ្លាំង ហៃ។ ");
INSERT INTO brb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","អ៊ែ បូវ ឞាវ គ្រែដៃ មន់ដើរ ហៃ ដើ ទី ញ៉ង អាំ ឈឹង ហៃ លំត្រ ប៉ុះ តម៉ ”»។ ");
INSERT INTO brb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ រៀន “ញ៉ា បនឹះ ញ៉ង ញំបឡង ឝ្លាំង អ៊ឺម គ្រែដៃ កន់ដ្រាគ់ ឡើ គ្រែដៃ ញ៉ា។ ”»។ ");
INSERT INTO brb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","អរ៉ាក់ សតាំង ឡើ ពលូង គ្រែដៃ យែស៊ូ ញឹះ ត្រំ ហំឞ្លិច លែវ ឡើយ អ៊ែ ឡើ វីះ តើម ប៊ឹង ណគ ឆា ដើ លំប៊ឹះ តង៉ៃ ង៉ាយ ផ លំដូវ ពលូង អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","គ្រែដៃ យែស៊ូ ឡើ ជឹ វឹញ ហឹ ស្រុក ឝ៉ាលីលែ ទឺ ឡើ ប៊ិច អាតណាត តើម ប៊ឹង ផវ យ៉ាង គ្រែដៃ អ៊ែ ម៉ាត់ ណគ ឡើ លឺ អន់តើរ ត្រំ ស៊្រុក ឈុំ អិះ។ ");
INSERT INTO brb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","អ៊ែ ឡើ ពង់ហៀន មែ ហឹ រ៉ូង ពស៊ុំ មែ យូដា មែ លែក រ៉ា ម៉ើ ព្រតឹះ ព្រនែ ប្រយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","គ្រែដៃ យែស៊ូ ឡើ ជឹ វឹញ ហឹ ស្រ៊ុក ណាសារែត ឡើ ត្រ ស៊្រុក កនូ ណគ ទឹង ណាគ់ ឡើ អង់គ្លែត ពន់ឋើម។ ទឹង ណាគ់ ឡើ គូ ហឹ អ៊ែ ឡើ ដក់ ហឹ រ៉ូង ពស៊ុំ តគ់ តង៉ៃ ម៉ើ ព្រឹង ពពឹត តាម ខណើយ ណគ អ៊ែ ឡើ ឌឹក ឆុង តគ់ ងឺរ មែ បក់ លំអាន ពឹម គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","អ៊ែ ម៉ើ ញ៉ាក់ ផាប់ យ៉ាគ់ អ៊ីសាយ ណគ់ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ើ អាំ ដើ ណគ អាន អ៊ែ ឡើ ប៉ើក សាត ឡើ តៃ ត្រ ប៉ុះ ប្រម៉ាង គ្រែដៃ យ៉ាគ់ អ៊ីសាយ ឡើ ខៀន ជុ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ផវ យ៉ាង គ្រែដៃ កន់ដ្រាគ់ ឡើ គូ ប៊ឹង អៃ។ គ្រែដៃ ឡើ ហ៊ែង ពុក រ៉ើះ អៃ ឡើ ប៉្រៃ អៃ អដក់ ពហាយ កាន ចាគ់ ដើ មែ ធុក ញ៉ាក។ ណគ ឡើ ប៉្រៃ អៃ អដក់ ពហាយ ពន់ដុង ដើ មែ ម៉ើ រ៉ាប់ បើម ក៝ត រៀន មន់ក្លើច តើម ប៊ឹង ទី ដ្រម៉ា ដើម អន់ហាយ ដើ មែ ម៉ើ សូត ឡក់ រៀន មន់ត្រប៉ៃ អន់ណាវ។ ណគ ឡើ ប៉្រៃ អៃ អន់តោះ ពឝ៉្លើច ណគ់ មែ ម៉ើ ត្រ បូវ ឈិះ ឆាន់។ ");
INSERT INTO brb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ដើម អំពហាយ ពន់ដុង ណគ់ កម៉ គ្រែដៃ កន់ដ្រាគ់ លំពដៃ កាន ស្រុស្រៀត ដើ ប៉ាសាសុន ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ប៊្លី គ្រែដៃ យែស៊ូ ឡើ អាន លែវ ឡើយ អ៊ែ ឡើ កឌឹប ផាប់ យ៉ាគ់ អ៊ីសាយ ឡើ ឈូន ហឹ កឡា រន់ឋាប់ រ៉ូង ពស៊ុំ លែវ អ៊ែ ឡើ ជឹ ដ្រូម ចុ ទឺ អន់ណាវ។ អ៊ែ បូវ ត្រំ រ៉ា ម៉ើ ឝ្លាំង ពហឹង ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប្រម៉ាង គ្រែដៃ ណគ់ វ៉ើ ចង់ហៀង អៃ អអាន អន់ឌូ អ៊ែ ឡើ កើត ក្លើច ឡើយ តង៉ៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","បូវ មែ លែក រ៉ា ម៉ើ ព្រតឹះ ណគ ម៉ើ ឃឹត រៀន៖ «តូវ ញ៉ើ បើម ញ៉ម ញ៉ា ឡើ ម៉ាង ត្រ ញឹម ឞាល់ អ៊ិន»។ ហាក់ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «កួន យ៉ាគ់ យ៉ូស៊ែប ហវ៉ៃ អន់នែ? ប៉ិ ឡើ ណោះ ម៉ាង ឞាល់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «អាត វ៉ើ ងុញ ព្រតូវ អៃ ប៉ាគ់ ប្រម៉ាង មែ ឡៃ ម៉ើ រៀន “ណាយឃូ ពែត អើយ! ហំពួ ចាក់ ហកឡឹ អន់ដៃ អាំ នៀម”។ វែ វ៉ើ ឃឹត ប៉ាគ់ នែ ញ៉ន វ៉ើ ដុង អៃ អបើម កាន ឆង៉ាត់ ហឹ មួង កាផារនុំ អ៊ែ ណិះៗ វ៉ើ ងុញ វន់តៃ អៃ អំបើម កាន ឆង៉ាត់ ប៊ឹង ស្រ៊ុក អៃ កឡឹ ប៉ាគ់ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ណគ ឡើ ម៉ាង ឡឹះ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អម៉ាង ដើ វែ លែក រ៉ា រៀន ប៉ាគ់ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ដក់ ហឹ ស្រ៊ុក មែ គែង ម៉ើ ចាប់ ប្រយ ប្រម៉ាង ណគ ប៉ាគ់ ឡើ ជឹ ហឹ ស្រ៊ុក ណគ កឡឹ ម៉ើ ចង់ហៀង អ៊ឺម ប្រម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ដាវ ម៉ាត់ ម៉ាត អម៉ាង ដើ វែ រៀន ទឹង ប៉ាង យ៉ាគ់ អ៊ែលីយ៉ា តៃ ឡើ ប៊ិច អំមឺ ញឹះ ពែ កម៉ តង់បារ អ៊ែ ម៉ើ អឹត ហរុ ទុត ខាក់ លែក ដើ ប៊្រី ដាក អ៊ីស្រាអ៊ែល។ អ៊ែ ទឹង ពធែត អ៊ីស្រាអ៊ែល នែ អាត លំប៊ិច ម៉ិ យូ កម៉ាយ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ហាក់ គ្រែដៃ តៃ ឡើ ប៉្រៃ អ៊ឺម យ៉ាគ់ អ៊ែលីយ៉ា លំប៉ូរ ម៉ិ យូ កម៉ាយ ហឹ ប៊្រី ដាក អ៊ីស្រាអ៊ែល សំ យ៉ះ មូយ រ៉ា ណាគ់ តៃ ឡើ អាំ អ៊ឺម ឡើ ប៉្រៃ លំដក់ ប៉ូរ កទ្រី កម៉ាយ មូយ រ៉ា ហឹ ស្រ៊ុក សារ៉ិបតា ចើម មួង ស៊ីដូន អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","អ៊ែ ទឹង ប៉ាង យ៉ាគ់ អ៊ែលីស៊ែ ណគ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ប៊ិច បនឹះ ស៊ិត ស៊ូត ទុត អើន ហឹ ប៊្រី ដាក អ៊ីស្រាអ៊ែល តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់នៀម ហម មូយ រ៉ា ណាគ់ តៃ ប៊ិច អ៊ឺម វ៉ិះ ឌិវ យ៉ាគ់ ណៃម៉ាន់ សុនសាត ស៊ីរី ណាគ់ ឡើ នៀម»។ ");
INSERT INTO brb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","មែ ម៉ើ គូ ទឹង រ៉ូង ពស៊ុំ ហំប៊្រុះ ម៉ើ ដុង ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ម៉ើ មាំ ដើ ណគ តូវ ចះ មុះ ម៉ាត់ លែក ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ញ៉ន ម៉ើ បើម ស្រ៊ុក ទិ ក្រជែង សាង អ៊ែ ម៉ើ ពញឺះ ដក់ ប៉ាគ់ បៀត ណគ តើម ប៊ឹង ស៊្រុក ហឹ ច្រាំងៗ ម៉ើ ឃឹត មន់ឝឹ កលីះ ណគ ទិ ច្រាំងៗ។ ");
INSERT INTO brb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ហាក់ ណគ ឡើ ញឺះ អន់ដៀត អន់លៀត ប្លះ មែ ប្រយ ខៀង។ ");
INSERT INTO brb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","គ្រែដៃ យែស៊ូ ឡើ ទឺះ ទិ មួង កាផារនុំ ស្រុក ឝ៉ាលីលែ ហឹ អ៊ែ ឡើ ពង់ហៀន មែ ក្លាង ស្រ៊ុក ទឹង តង៉ៃ ម៉ើ ព្រឹង ពពឹត។ ");
INSERT INTO brb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","មែ បូវ ម៉ើ ញ៉ម ខាក់ៗ ញ៉ន ប្រម៉ាង ណគ ឡើ ពង់ហៀន ឡើ ប៊ិច អាតណាត ឆង៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ទឹង រ៉ូង ពស៊ុំ ឡើ ប៊ិច កឡ មូយ រ៉ា អរ៉ាក់ ឡើ មឹត គូ ទឹង ណគ ឡើ ហរ៉ាវ ប៉ាគ់ កឡូវ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«អើយ គ្រែដៃ យែស៊ូ ស្រ៊ុក ណាសារែត ហដក់ ដាំង ខ ពយ៉ិ ហឹ ញ៉ា នែ? ហងុញ ថំឡាយ ញ៉ា ឡះ? អៃ អហឝ៉ាវ ឡើយ ហៃ ហកឡា ចាគ់ លួង តើម ទិ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ក្រាគ់ ដើ អរ៉ាក់ រៀន៖ «ព្រឹង! ខៀង ហង់គូ ហំវីះ តើម ប៊ឹង បឹ អន់នែ»។ អ៊ែ អរ៉ាក់ ឡើ តំបង់ តាក់ បឹ ហង់អ៊ែ ទឹង កឌីៗ បូវ ឡើ វីះ ខៀង អ៊ែ បឹ អន់នែ ឡើ នៀម ញឹះ តៃ ឡើ ឈិ ចាក់ ដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","មែ បូវ ម៉ើ ឌូង ហឡឹង ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ពយ៉ិ ប្រម៉ាង ប្រដង់ ណគ ឡើ ឆង៉ាត់ ឞាល់ នែ។ តគ់ វន់ឝ្លាំង ណគ ឡើ ប៊ិច អាតណាត ឆង៉ាត់ ឡើ ប៉្រៃ អរ៉ាក់ វីះ អ៊ែ អរ៉ាក់ ឡើ វីះ ម៉ាត់ ម៉ាត ដើ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ប៊្លី អ៊ែ កាន គ្រែដៃ យែស៊ូ ឡើ លឺ ហន់ឈី ប្រយ ត្រំ ស្រ៊ុក ឈុំ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","គ្រែដៃ យែស៊ូ ឡើ ញឺះ តើម ប៊ឹង រ៉ូង ពស៊ុំ ឡើ មឹត គូ ហឹ ហន់ណាម យ៉ាគ់ ស៊ីម៉ូន តគ់ អ៊ែ ហឝ៉ៃ ម៉ិ យ៉ាគ់ ស៊ីម៉ូន ឡើ ឝ្រុន ម៉ៃៗ អ៊ែ ម៉ើ ឡា ហឹ ណគ លំប៉ូរ អាំ លំនៀម។ ");
INSERT INTO brb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","គ្រែដៃ យែស៊ូ ឡើ កឈុះ ឝ្លាំង ទិ ណគ ឡើ ម៉ាង ក្រាគ់ ដើ ឆនិ ឝ្រុន អ៊ែ ឆនិ ឝ្រុន ឡើ បាត់ ប្រយ។ អ៊ែ ហឝ៉ៃ ម៉ិ យ៉ាគ់ ស៊ីម៉ូន ឡើ ឌឹក អាំ ចណង់ ចណា ប្រយ ដើ មែ តមួយ។ ");
INSERT INTO brb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","តគ់ ម៉ាត់ តង៉ៃ លុច មែ ស្រ៊ុក លែក រ៉ា ម៉ើ តៀត អំម៉ោះ អោះ ណគ់ ម៉ើ ប៊ិច ឆនិ ដិ អន់ដិ ហឹ គ្រែដៃ យែស៊ូ អ៊ែ ណគ ឡើ ជុ ទី ពឺង មែ មូយ រ៉ា មូយ តង អ៊ែ ម៉ើ នៀម ប្រយ លែក មែ។ ");
INSERT INTO brb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ប៊ិច បូវ អរ៉ាក់ ម៉ើ ញឺះ តើម ប៊ឹង បនឹះ អើនៗ ម៉ើ ហរ៉ាវ ពន់ដុង រៀន៖ «ហៃ ឡើយ ម៉ាត ហកួន កឡ គ្រែដៃ»។ ហាក់ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ក្រាគ់ ឡើ តព្រឹង មែ ខៀង ប្រយ ម៉ើ ព្រឹង។ យ៉ាក់ មែ អរ៉ាក់ ម៉ើ ហឝ៉ាវ ណគ ឡើ គ្រែដៃ គ្រិះ។ ");
INSERT INTO brb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ស៊ី ប្រាង ងឹប គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ឞន វៀកៗ អ៊ែ មែ ក្លាង ស្រ៊ុក ម៉ើ ចន់ដ្រា ត្រឌីវ បូវ ដក់ សាត ណគ។ តគ់ ម៉ើ តៃ ណគ ឡើយ ម៉ើ កំប៊ែត តៃ អាំ លំវីះ តាក់ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ហាក់ គ្រែដៃ យែស៊ូ ឡើ តើវ មែ រៀន៖ «គ្រែដៃ ឡើ ប៉្រៃ អៃ តង អំពហាយ កាន ចាគ់ ណគ ហឹ មួង អង់គែងៗ ប៉ាគ់ទឺ រៀន គ្រែដៃ ឡើ បើម សឋិច ឡើ ពែក ប៉ាក់ បនឹះ យ៉ាក់ អទឺះ ទិ នែ អពហាយ កាន ចាគ់ អន់នែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហាយ ពហាយ ដឌែ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ បុ រ៉ូង ពស៊ុំ ដិ អន់ដិ ទឹង ប៊្រី ដាក មែ យូដា។ ");
INSERT INTO brb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ ឆុង ពង់ហៀន ដៀក ពឹះ សមុត ឝែនែសារែត មែ ក្លាង ស្រ៊ុក ទុត អើន តូវ ម៉ាត់ ម៉ើ អន់ដៀត ឈុំ ណគ ម៉ើ ដក់ ចង់ហៀង ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","អ៊ែ ឡើ តៃ ឌូក មែ ម៉ើ ដាំង ទ្រឺ បារ អ្រឝួង ប្រយ ម៉ើ ចត ប៊ឹង ពឹះ ហាក់ ណគ់ មែ ម៉ើ អ៊ូះ អួន ម៉ើ ទឺះ តើម ប៊ឹង ឌូក ម៉ើ ដក់ ឆះ អួន លែក មែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ទឺះ ឈិះ ទិ ឌូក លមូយ ឡើ ត្រ ប៉ុះ ឌូក យ៉ាគ់ ស៊ីម៉ូន ឡើ ប៉្រៃ ស៊ីម៉ូន វ៉ះ អាំ ចង៉ាយ ឞិត ឞ៊ែត តើម ប៊ឹង ពឹះ។ អ៊ែ ឡើ ដ្រូម ទឹង ឌូក ឡើ ពង់ហៀន មែ ក្លាង ស្រ៊ុក ម៉ើ គូ ហឹ ពឹះ។ ");
INSERT INTO brb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ឡើ ពង់ហៀន លែវ ឡើយ អ៊ែ ឡើ ប៉្រៃ យ៉ាគ់ ស៊ីម៉ូន រៀន៖ «មិញ ហន់វ៉ះ ពដក់ ឌូក ហឹ ឈ្រុៗ ប៊ឹះ តគ់ អ៊ែ វន់កលីះ អួន វែ អ៊ែ វន់ដូវ ទ្រឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","យ៉ាគ់ ស៊ីម៉ូន ឡើ ត្រណើវ រៀន៖ «ណាយឃូ អើយ មាំង អ៊ិន ញ៉ា ញ៉ើ ខំ អ៊ូះ អួន ញឹះ ប្រាង គ្រែ ឞាល់ អ៊ិន ណាគ់ តៃ ញ៉ើ ដូវ អ៊ឺម ទ្រឺ ពញ៉ង ណាគ់ ហប៉្រៃ ញ៉ា ញន់កលីះ ឡឹះ អន់ណាវ ប៉ាគ់ ពអ៊ែ ញន់ត្រួយ ពន់ដ្រៃ ហៃ ឆិ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ហំប៊្រុះ ម៉ើ កលីះ អួន ទិ ដាក អ៊ែ ម៉ើ ដូវ ប្រយ ទ្រឺ ទុត អើន ញឹះ ស្រឹ លំត្រសាក អួន។ ");
INSERT INTO brb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","អ៊ែ ឡើ កវឺច កឡូវ បូវ មែ ឌូក លមូយ អន់ណាវ ឡើ ប៉្រៃ មន់ដក់ ប៉ូរ មែ។ បូវ មែ អ៊ែ ម៉ើ វ៉ះ ប៊ឹះ តគ់ អ៊ែ ម៉ើ ប៉ូរ រ៉ើះ ទ្រឺ ប៊ិង លែក បារ ឌូក ញឹះ ស្រឹ លំឡង់ ឌូក មែ។ ");
INSERT INTO brb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","យ៉ាគ់ ស៊ីម៉ូន ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ បើម កាន ឆង៉ាត់ ប៉ាគ់ អ៊ែ អ៊ែ ឡើ កដាប ហំបះ ប្រយ ប៊ឹង ឈឹង ណគ ឡើ ម៉ាង រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ! អឡា ហំវីះ តើម ប៊ឹង អៃ តៃ ឃឺ អ៊ឺម ហៃ ហន់គូ អរែង ប៊ឹង អៃ អបនឹះ ប៊ិច ឞាប»។ ");
INSERT INTO brb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","យ៉ាគ់ ស៊ីម៉ូន ឡើ ម៉ាង ប៉ាគ់ អ៊ែ យ៉ាក់ ណគ ដើម លែក ដើ មែ ម៉ើ គូ អរែង ប៊ឹង ណគ ម៉ើ ឌូង ម៉ើ ញ៉ម ទុត ខាក់ ម៉ើ តៃ ម៉ើ ដូវ ទ្រឺ អើន ឞាល់ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","យ៉ាគ់ យ៉ាកុប អំប្រា យ៉ាគ់ យ៉ូហាន កួន យ៉ាគ់ ស៊ែប៊ែឌែ អំប្រា ដាំង ទ្រឺ អរែង ដើ យ៉ាគ់ ស៊ីម៉ូន អំប្រា ញ៉ម ប៉ាគ់ទឺ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ យ៉ាគ់ ស៊ីម៉ូន រៀន៖ «ញ៉ង ហឌូង អ៊ឺម ហៃ នែ ហខើយ ដាំង ទ្រឺ ឡើយ តើម ប៊ឹង នែ ហឹ ងឺរ តគ់ ហៃ ហន់សាត ដាំង បនឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ហំប៊្រុះ ដើ អ៊ែ ម៉ើ អ៊ូះ ឌូក ជុ តគ់ ពឹះ អ៊ែ ម៉ើ តាក់ ប្រយ កាន ដាំង ទ្រឺ មែ ម៉ើ ដក់ តូយ គ្រែដៃ យែស៊ូ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ទឹង គ្រែដៃ យែស៊ូ ឡើ គូ ហឹ មួង លមូយ ប៊ិច កឡ មូយ រ៉ា ឡើ កើត ស៊ិត ស៊ូត បុ ចាក់ ហំប៊្រុះ ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ ដក់ កដាប ហំបះ ត្រងឺវ ទូត ពដិះ ឡើ ឡា ហឹ ណគ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ! ប៉ាគ់ ហន់ឌី ឡា ហំពនៀម អៃ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ជុ ទី ពឺង ណគ ដើម ឡើ ម៉ាង រៀន៖ «ឌី ហន់នៀម ហំមិញ»។ ហំប៊្រុះ ដើ អ៊ែ ឡើ នៀម ប្រយ ស៊ិតស៊ូត ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","គ្រែដៃ យែស៊ូ ឡើ ថាន់ ណគ រៀន៖ «ញ៉ង ហពប៉ច អន់ដិះ យ៉ឹ ដើ បូវ! វ៉ិះ ហន់ដក់ ពដៃ ចាក់ ហៃ ដើ កឡា បប៊ុះ ថួយ ដើ គ្រែដៃ អន់ដៃ អាំ លំហន់នៀប ឝ្លាំង ហៃ ហនៀម ឡើយ ដើម ហំបើម ឞ៊ុន ពឆ្រះ ចាក់ ម៉ប អន់ណាំ ដើ គ្រែដៃ ដិ ប៉ាគ់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ ឡៃ មាំង។ ហៃ ហំបើម ប៉ាគ់ នែ អាំ មែ លែក រ៉ា មន់ណោះ ហឡាក់ រៀន ហៃ ហនៀម ចាគ់ ម៉ាត់ ម៉ាត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ហាក់ ម៉ើ ដុង ឡើ លឺ អន់តើរ ម៉ាត់ គ្រែដៃ យែស៊ូ សរ៉ើម ចាំ អើនៗ អ៊ែ ឡើ ប៊ិច បនឹះ ទុត អើន ម៉ើ ដក់ តមួត ចង់ហៀង ណគ ដើម មែ ម៉ើ ឈិ ម៉ើ ឡា ហឹ ណគ លំបើម អន់នៀម មែ ដិ ");
INSERT INTO brb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","អ៊ែ ដើ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ វៀកៗ ឡើ អ៊ឺរ ដាំង គ្រែដៃ តាម ខណើយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","តង៉ៃ ហង់អ៊ិន ទឹង គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន ឡើ ប៊ិច បូវ មែ ផារីស៊ី ដើម បូវ មែ ពង់ហៀន ចឞាប់ ម៉ើ ដក់ ដ្រូម ចង់ហៀង ប៉ាគ់ទឺ ណគ់ បូវ មែ លែក អ៊ែ ម៉ើ ប៊ឹះ តើម ប៊ឹង ស្រ៊ុក ដិ អន់ដិ ស្រុក ឝ៉ាលីលែ ស្រុក យូដា ដើម តើម ប៊ឹង មួង យែរូសាឡឹម ដិ។ គ្រែដៃ យែស៊ូ ឡើ ប៊ិច អាតណាត ឆង៉ាត់ តើម ប៊ឹង គ្រែដៃ កន់ដ្រាគ់ បក់ លំបើម អន់នៀម ណគ់ មែ ម៉ើ ឈិ។ ");
INSERT INTO brb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ហំប៊្រុះ ដអ៊ែ ប៊ិច បូវ ម៉ើ ទូង បនឹះ កុង ឈឹង មូយ រ៉ា ម៉ើ ខំ តមឹត អន់ដៀត អន់លៀត ដក់ ជុ ណគ ហឹ ងឺរ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","យ៉ាក់ ឡើ ប៊ិច បនឹះ ទុត អើន តឝុញ ទឹង ហន់ណាម តៃ ម៉ើ ដូវ ប្រយ មន់តមឹត បឹ ឡើ កុង ឈឹង ហឹ គ្រែដៃ យែស៊ូ។ អ៊ែ ម៉ើ ទូង ណគ ពឌឹក ពឺង បូយ ហន់ណាម ម៉ើ សោះ តៃ បូយ អ៊ែ ម៉ើ ពឌឺះ ណគ ដើ ឝ្រែ ហ្រជិវ ខយៗ អាំ លំត្រ ទឹង កឌីៗ បូវ ឡើ ត្រ ប៉ុះ ងឺរ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","តគ់ គ្រែដៃ យែស៊ូ ឡើ តៃ មែ ម៉ើ មឹង ណគ ឞាល់ នែ ឡើយ អ៊ែ ឡើ ហាយ ដើ បឹ ឡើ កុង ឈឹង អ៊ែ រៀន៖ «អោះ អើយ ដូវ ឡើយ អតាក់ ឞាប ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ណគ់ ដើ មែ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម បូវ មែ ផារីស៊ី ម៉ើ គឹន អង់គឹន រៀន៖ «បនឹះ ង៉ាយ បឹ អន់នែ អិះ ហំប៊ិ ឡើ ហាន ផម៉ាត គ្រែដៃ ឞាល់ អ៊ិន? ប៊ិច ឌិវ គ្រែដៃ មូយ រ៉ា ឡើយ ឡើ ដូវ តាក់ ថូត ដើ បនឹះ អាំ មន់ក្លើច តើម ប៊ឹង ឞាប»។ ");
INSERT INTO brb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ហាក់ ដើ គ្រែដៃ យែស៊ូ ឡើ ណោះ ខនឹត មែ អ៊ែ ឡើ ម៉ាង រៀន៖ «ពយ៉ិ ឡើ ត្រ វ៉ើ ឃឹត ប៉ាគ់ នែ ត្រ ឞិ។ ");
INSERT INTO brb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","អង់ហាយ ដើ វែ រៀន ប៉ាគ់ អំបើម អន់នៀម បឹ កុង ទី ឈឹង នែ អំប៉្រៃ ណគ លំឌឹក អន់ឆូវ អ៊ែ វន់ណោះ ហង់ឝ៉ាវ រៀន អៃ អប៊ិច អាតណាត តើម ទិ គ្រែដៃ អដូវ តាក់ ឞាប ដើ បនឹះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","អៃ អំពដៃ អាំ វែ វន់ណោះ រៀន កួន បនឹះ ណគ់ អន់នែ ឡើ ប៊ិច អាតណាត តាក់ ឞាប ដើ បនឹះ ទិ ឡាង ប្រិះ នែ ដូវ»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហវីវ ហឹ បឹ ឡើ កុង ឈឹង អ៊ែ ឡើ រៀន៖ «មិញ ហន់ឌឹក ឆុង ហន់ចក់ កយែង ហៃ ហន់ជឹ កួយ ហឹ ហន់ណាម ហំមិញ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ហំប៊្រុះ ដើ អ៊ែ ឡើ កន់ត្រូង ឌឹក ឆុង ប្រយ ប៊ឹង ងឺរ មែ ឡើ ញ៉ាក់ កយែង ណគ ឡើ ជឹ តៀត ដក់ ប៉ាគ់ ព្រតឹះ ព្រនែ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","តូច ដើ បូវ មែ ម៉ើ គូ ទឹង អ៊ែ ម៉ើ ឌូង តូវ ម៉ើ កុង គឺ ប្រយ យ៉ាក់ ម៉ើ តៃ អាតណាត ឆង៉ាត់ ឞាល់ នែ អ៊ែ ម៉ើ ព្រតឹះ ដើម ម៉ើ អៀល ឌូង ដើ គ្រែដៃ ម៉ើ ចជែ រៀន៖ «យ៉ើ តង៉ៃ នែ ឌិះ ង៉ើ តៃ កាន ឆង៉ាត់ ដិៗ ឞាល់ នែ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","គ្រែដៃ យែស៊ូ ប៊្លី ឡើ បើម អន់នៀម បឹ ឡើ កន់ចក អ៊ែ ឡើ វីះ ឡើ តៃ យ៉ាគ់ លែវី ទឹង ឡើ ដ្រូម ពឹត កាន ប៊ឹង ហន់ណាម កាគ់ លៀន។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ច្រា ណគ រៀន៖ «ដក់ ហន់តូយ អៃ វ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","អ៊ែ យ៉ាគ់ លែវី ឡើ តាក់ ប្រយ កាន ង៉ាន ណគ ឡើ តូយ គ្រែដៃ យែស៊ូ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ប៊្លី អ៊ែ យ៉ាគ់ លែវី ឡើ រ៉ាត ចង់ បយ៉ង់ បយ៉ា ប្រយ គ្រែដៃ យែស៊ូ ហឹ ហន់ណាម ណគ ដើម បូវ មែ កាគ់ លៀន ទុត អើន ដឹប មែ ហឹ គែង ដិ ម៉ើ ចង់ ចា អរែង ប៊ឹង មែ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","បូវ មែ ផារីស៊ី ដើម ណាយឃូ ពង់ហៀន ចឞាប់ ទឹង មែ ផារីស៊ី ទឺ ម៉ើ អង់អះ ឡះ បាក អ៊ែ ម៉ើ ដក់ ម៉ាង ដើ លុកស៊ិក ណគ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ឌី ញែត ចង់ អរែង ប៊ឹង មែ ម៉ើ កាគ់ លៀន ដើម បូវ បនឹះ ប៊ិច ឞាប ដិ?» ");
INSERT INTO brb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ដើ មែ រៀន៖ «បនឹះ តៃ ឈិ ម៉ើ តងកាន អ៊ឺម ពែត វ៉ិះ ឌិវ មែ ម៉ើ ឈិ ម៉ើ តងកាន ពែត។ ");
INSERT INTO brb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ណគ់ ដើ អៃ នែ អៃ អដក់ ដាំង អ៊ឺម បនឹះ ចាគ់ ទឹង ត្រ អដក់ ដាំង បនឹះ ប៊ិច ឞាប ហវ៉ៃ អាំ មន់ពលិះ ចនិះ មែ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","អ៊ែ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «លុកស៊ិក យ៉ាគ់ យ៉ូហាន ដើម លុកស៊ិក មែ ផារីស៊ី ម៉ើ អ៊ឺរ ដាំង គ្រែដៃ ដើម ម៉ើ អឹត ចង់ ចា ឆិញៗ ប៉ិ ឡើ ត្រ ដើ លុកស៊ិក ហៃ ម៉ើ ញញែត ចចង់ ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «តង៉ៃ ម៉ើ ច្រណង់ ទឹង បឹ កឡា ចក់ ទ្រី ឡើ ណាគ់ ប៊ឹង អ៊ែ លំឃឺ ឞិ មែ ម៉ើ ដក់ ផូវ មន់អឹត ចណង់ ចណា? ");
INSERT INTO brb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ហាក់ តគ់ លំប៊ឹះ តង៉ៃ មន់រ៉ាប់ បឹ កឡា ចក់ ទ្រី អ៊ែ លំត្រ បូវ ប៊ែង ណគ មន់ឝ្រង៉ឹត អឹត ចង់ ចា»។ ");
INSERT INTO brb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ឡឹះ រៀន៖ «តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់សាក អាវ ហន់ដើម មន់ឈិង កដាគ់ ប៊ឹង អាវ ក្រាគ់ មន់បើម ប៉ាគ់ នែ ណគ់ អាវ ហន់ដើម លំប៉ិន យ៉ាវ ដើម តៃ ឡើ តក ប្រយ ណគ់ អាវ ក្រាគ់ ប៊ឹង ក្រដាគ់ ហន់ដើម។ ");
INSERT INTO brb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","មូយ ឡឹះ អន់ណាវ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ជុ តវែ ឈឹង ជែម ហន់ដើម ទឹង ក្រឌុង ហំបក ក្រាគ់  ប៉ាគ់ ពអ៊ែ ក្រឌុង ក្រាគ់ លន់ចឋះ លំប៉ិន យ៉ាវ អ៊ែ តវែ លំលូះ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ឡើ ត្រ មន់ជុ តវែ ឈឹង ជែម ហន់ដើម ទឹង ក្រឌុង អ្រឡូត ហន់ដើម ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","មែ ង៉ាយ ម៉ើ ញែត តវែ ឈឹង ជែម ក្រាគ់ មន់ឌី យ៉ាវ មន់ញែត តវែ ឈឹង ជែម ហន់ដើម យ៉ាក់ ម៉ើ រៀន តវែ ឈឹង ជែម ក្រាគ់ ឡើ ញឹម ជឺរ តវែ ឈឹង ជែម ហន់ដើម»។ ");
INSERT INTO brb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ទឹង តង៉ៃ ម៉ើ ព្រឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ ឡាត់ មឺរ អ៊ែ មែ លុកស៊ិក ណគ ម៉ើ ដក់ អរែង ម៉ើ កាត់ ហ្រកង់ ចិះ ម៉ើ កប៉ ដក់ ប៉ាគ់ ចា។ ");
INSERT INTO brb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","បូវ មែ ផារីស៊ី អន់នឺ រ៉ា ម៉ើ ម៉ាង ដើ មែ រៀន៖ «ប៉ិ ត្រ វ៉ើ កាត់ ចិះ ប៉ាគ់ នែ? ឡើ យូច ចឞាប់ វ៉ើ ណោះ ង៉ើ ពពឹត ទឹង តង៉ៃ ព្រឹង»។ ");
INSERT INTO brb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «វ៉ើ អាន អ៊ឺម ឡះ ទឹង ពឹម គ្រែដៃ កាន សឋិច ដាវីត ដើម បូវ ណគ ប៉ាគ់ ង៉ាយ ម៉ើ បើម ប៊ឹង ម៉ើ ពងួត? ");
INSERT INTO brb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","សឋិច ដាវីត នែ ឡើ មឹត ហឹ កទូប កនូ គ្រែដៃ ឡើ ចក់ ចា ណំពាំង មែ ម៉ើ បាក ថួយ ដើ គ្រែដៃ ដើម ឡើ អាំ ដើ បូវ ណគ ម៉ើ ចា ដិ។ ប៉ាគ់ តាម ចឞាប់ ម៉ូស៊ែ វ៉ិះ ឌិវ មែ កឡា បប៊ុះ ថួយ ដើ គ្រែដៃ ម៉ើ ដូវ ចា»។ ");
INSERT INTO brb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ រៀន៖ «កួន បនឹះ ហវ៉ៃ ឡើ កន់ដ្រាគ់ ពឺង តង៉ៃ ព្រឹង»។ ");
INSERT INTO brb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","តង៉ៃ ម៉ើ ព្រឹង ឡឹះ អន់ណាវ គ្រែដៃ យែស៊ូ ឡើ មឹត ទឹង រ៉ូង ពស៊ុំ មែ សុនសាត យូដា អ៊ែ ឡើ ពង់ហៀន មែ។ ទឹង អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ កុង ទី តៃ ចម៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","បូវ មែ ពង់ហៀន ចឞាប់ ដើម បូវ មែ ផារីស៊ី ម៉ើ អន់ឆយ ឝ្លាំង គ្រែដៃ យែស៊ូ អំប មន់តៃ ណគ លំពនៀម ទី បឹ ហង់អ៊ែ ទឹង តង៉ៃ ព្រឹង បក់ មន់ដាំង ខ រ៉ាប់ អ្រយូច ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ហាក់ ដើ គ្រែដៃ យែស៊ូ ឡើ ណោះ ខនឹត មែ អ៊ែ ឡើ ម៉ាង ដើ បឹ កុង ទី រៀន៖ «មិញ ហន់ឌឹក ឆុង ទឹង កឌី បូវ នែ»។ បឹ ហង់អ៊ែ ឡើ ឌឹក ឆុង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «ណិះៗ អន់តង៉ា វែ តាម ចឞាប់ ទឹង តង៉ៃ ង៉ើ ព្រឹង តង ងំបើម អន់ចាគ់ លឺ ងំបើម តៃ ចាគ់? ងំហវ៉ាត់ ពញិវ លឺ ងំកជែត មែ បូវ?»។ ");
INSERT INTO brb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឝ្លាំង ហឹ បនឹះ ម៉ើ គូ ឈុំ ណគ អ៊ែ ឡើ ប៉្រៃ បឹ កុង ទី រៀន៖ «ហំពយ៉ោះ ទី ហៃ»។ អ៊ែ ឡើ ពយ៉ោះ ប្រយ ឡើ នៀម ប៉ាគ់ អំប៊ី រីវ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","មែ ម៉ើ ឌឹក ក្លើម បើម មាំ ប៊្រីវ តំប៊្រីវ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ប៉ាគ់ ង៉ាយ ងំបើម ដើ បឹ អន់នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ទឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឌឹក អ៊ឺរ ដាំង គ្រែដៃ ទឹង ចន់ឌូ។ ឡើ អ៊ឺរ ដាំង មូយ មាំង ញឹះ ប្រាង។ ");
INSERT INTO brb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ស៊ី ប្រាង ងឹប ឡើ កឡូវ លុកស៊ិក ឌឹក ពទុំ ទឹង ណគ ទឹង បូវ មែ អ៊ែ ឡើ រ៉ើះ ជិត បារ រ៉ា ឡើ ជុ មែ នែ “បូវ ពចាំ កាន ណគ”។ ");
INSERT INTO brb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ទឹង អ៊ែ ឡើ ប៊ិច ស៊ីម៉ូន គ្រែដៃ យែស៊ូ ឡើ ជុ ពលិះ ម៉ាត់ ណគ ពែត្រុះ អន់ណាវ ដើម អន់ឌ្រែ អោះ ណគ តើម ប៊ឹង អ៊ែ ឡើ ប៊ិច មែ យ៉ាកុប យ៉ូហាន ភីលីប បារថូឡូមែ ");
INSERT INTO brb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ម៉ាថាយ ថូម៉ះ យ៉ាកុប ឡើ ត្រ កួន យ៉ាគ់ អាល់ផាយ ស៊ីម៉ូន មែ ម៉ើ ជុ ណគ បឹ ស៊ីឡូត ");
INSERT INTO brb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","យូដះ កួន យ៉ាគ់ យ៉ាកុប ដើម យូដះ អ៊ីសការីយ៉ុត បឹ ឡើ ខិច គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","គ្រែដៃ យែស៊ូ ឡើ ទឺះ តើម ទិ ចន់ឌូ អរែង ដើ លុកស៊ិក ណគ អ៊ែ ឡើ ឆុង ចុ ទ្រឹបៗ។ ទិ អ៊ែ ប៊ិច លុកស៊ិក ដើម មែ ក្លាង ស្រ៊ុក ទុត អើន ម៉ើ ប៊ឹះ តើម ប៊ឹង ពដិះ មែ យូដា មួង យែរូសាឡឹម ហន់ដឹប មែ ម៉ើ ប៊ឹះ តើម ប៊ឹង មួង បរ ពឹះ សមុត មួង ទីរ៉ុះ ដើម មួង ស៊ីដូន ម៉ើ ដក់ ចាំ អន់នួរ ណគ ឝុញ តឝុញ។ ");
INSERT INTO brb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","មែ ម៉ើ ដក់ ចង់ហៀង ណគ ពង់ហៀន ដើម ម៉ើ ឡា ហឹ ណគ លំពនៀម ឆនិ មែ ណគ់ មែ អរ៉ាក់ ឡើ មឹត ម៉ើ នៀម ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","មែ ក្លាង ស្រ៊ុក ទុត អើន តូវ ម៉ើ អន់ដៀត ម៉ើ ងុញ ដក់ ពឹត គ្រែដៃ យែស៊ូ យ៉ាក់ ឆង៉ាត់ ឡើ ញឺះ តើម ប៊ឹង ណគ អ៊ែ ម៉ើ នៀម ត្រំ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","គ្រែដៃ ឡើ ហវីវ ឝ្លាំង ហឹ មែ លុកស៊ិក អ៊ែ ឡើ ម៉ាង រៀន៖ «អើយ ណគ់ វែ វ៉ើ ធុក ញ៉ាក ណិះៗ នែ វន់ហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ គ្រែដៃ លំពែក ប៉ាក់ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ណគ់ វែ វ៉ើ អឹត ងួត ណិះៗ នែ វន់ហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ វន់ផិ ប៊ិង។ ណគ់ វែ វ៉ើ ញឺម ឝ្រង៉ឹត ស្រូក ណិះៗ នែ វន់ហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ វន់រ៉គ់សំ ប្រលែក ចអាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ទឹង បនឹះ តៃ មន់រែម ដើ វែ មន់ដ្រើះ តាក់ វែ ទឹង មន់ម៉ាង លលៀវ តតៀវ ព្រសាក យ៉វ វែ ដើម មន់ពន់ឆាំ ម៉ាត់ វែ ដិ ញ៉ន ដើ កួន បនឹះ អ៊ែ វន់ហ្រនុក ហ្រវ៉ាក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ប៊ឹង មន់បើម តៃ ចាគ់ ដើ វែ ប៉ាគ់ នែ ហរ៉ើម វន់រ៉គ់សំ ឆំតក តូវ វន់ច្រោះ អន់ច្រើន ប៊ឹង អ៊ែ យ៉ឹ យ៉ាក់ វន់ដូវ តង់ហវ ទិះ ទឹង ហូង គ្រែដៃ។ យ៉ាក់ ម៉ិ យ៉ាគ់ មែ ឡៃ មាំង ម៉ើ បើម តៃ ចាគ់ ប៉ាគ់ នែ ទឺ ដើ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","អើយ ណគ់ ដើ វែ វ៉ើ ប៊ិច ណិះៗ នែ វន់ធុក ញ៉ាក អន់ណាវ យ៉ាក់ វែ លែក រ៉ា វ៉ើ ញឹម ក្លើម ក្លាក រ៉គ់ សំ ឡូច ឌិវ ណិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","អើយ ណគ់ វែ វ៉ើ ផិ ប៊ិង ណិះៗ នែ វន់ធុក ញ៉ាក អឹត ងួត អន់ណាវ។ អើយ ណគ់ វែ វ៉ើ ចអាវ រ៉គ់ សំ ណិះៗ នែ វន់ធុក ញ៉ាក វន់ញឺម ក្រវ៉ើយ ក្រើយ អន់ដូង អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ប៉ាគ់ បនឹះ លែក រ៉ា ម៉ើ ព្រតឹះ ព្រនែ វែ ណិះៗ នែ វន់ធុក ញ៉ាក អន់ណាវ ឡើយ ញ៉ន ម៉ិ យ៉ាគ់ មែ ឡៃ ពន់ឋើម ម៉ើ ព្រតឹះ ព្រនែ ប៉ាគ់ទឺ មែ ម៉ើ ឈូន ប្រម៉ាង គ្រែដៃ ឆ្រឡិ ឆ្រលូគ។ ");
INSERT INTO brb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«វន់ចង់ហៀង ម៉ាង អៃ ទឹង ណាគ់ វ៉ើ ស្រូម ប៊ឹង នែ វន់ម៉ើត ដើ ដ្រម៉ា វែ យ៉ឹ វន់បើម អន់ចាគ់ ណគ់ ដើ មែ ម៉ើ កាញ វែ ");
INSERT INTO brb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","វន់ប្រាយ កាន ចាគ់ ណគ់ ដើ មែ ម៉ើ យ៉វ វែ វន់អ៊ឺរ ដាំង គ្រែដៃ អាំ លំប៉ូរ ណគ់ មែ ម៉ើ ចំអ៊ីល ហន់តាគ់ ឆឡាគ់ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ប៉ាគ់ មែ ង៉ាយ មន់តាះ ហៃ តៃ ចអៀវ ហន់អាំ មន់តាះ តៃ ចម៉ា អន់ណាវ។ ប៉ាគ់ មែ ង៉ាយ មន់សុក អាវ ហៃ ហន់អាំ មន់ចក់ ដើម អាវ កនុង ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ប៉ាគ់ មែ ង៉ាយ មន់ឡា រ៉ាះ ហៃ ហង់អាំ ដើ មែ អ៊ែ ប៉ាគ់ មែ ង៉ាយ ម៉ើ ដ្រូក រ៉ាះ ហៃ ញ៉ង ហន់សួរ យ៉ាវ ហឹ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","វន់ម៉ើត បូវ មន់បើម អន់ចាគ់ ដើ វែ ប៉ាគ់ ង៉ាយ ប៉ាគ់ អ៊ែ ឡើយ វន់បើម ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ប៉ាគ់ វន់ម៉ើត ឌិវ បនឹះ ម៉ើ ម៉ើត ដើ វែ ប៉ិ លំប៊ិច ខា មន់ព្រតឹះ វែ ទុត មែ ម៉ើ ប៊ិច ឞាប ម៉ើ បើម ប៉ាគ់ អ៊ែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ប៉ាគ់ វន់បើម អន់ចាគ់ ឌិវ ដើ បនឹះ ម៉ើ បើម អន់ចាគ់ ដើ វែ ប៉ិ លំប៊ិច ខា មន់ព្រតឹះ វែ ទុត មែ ម៉ើ ប៊ិច ឞាប ម៉ើ បើម ប៉ាគ់ អ៊ែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ប៉ាគ់ វែ វន់អាំ មែ មន់តង់ ណាគ់ វន់មឹង មែ មន់ធែន ប៉ិ លំប៊ិច ខា មន់ព្រតឹះ វែ ទុត បនឹះ ម៉ើ ប៊ិច ឞាប ណាគ់ ម៉ើ អាំ ប៉ាគ់ទឺ ដើ ប្រមែ ម៉ើ តង់ យ៉ាក់ ណាគ់ មន់ធែន អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","អ៊ែ ដើ វែ តង វន់ម៉ើត ដើ ដ្រម៉ា វែ វន់បើម អន់ចាគ់ ដើ មែ វន់អាំ ដើ មែ មន់តតង់ ដដាំង ហឹ វែ ញ៉ង វ៉ើ ឃឹត យ៉ាវ មន់ធែន ហឹ វែ អ៊ែ គ្រែដៃ លំអាំ តង់ហវ ទិះ ដើ វែ អ៊ែ វន់ត្រ កួន គ្រែដៃ ឡើ ទិះ ឈ្រូង យ៉ាក់ គ្រែដៃ ឡើ បើម អន់ចាគ់ ដើ បនឹះ ណគ់ តៃ ម៉ើ ណោះ ព្រតឹះ ណគ ដើម ដើ បនឹះ តៃ ចាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","វន់ត្រ ស្រុស្រៀត មែ ប៉ាគ់ គ្រែដៃ បើគ វែ ឡើ ស្រុស្រៀត ដើ បនឹះ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«វែ ញ៉ង វ៉ើ ពន់ដូះ អ៊ឺម កាន មែ បូវ អ៊ែ មែ មន់ពន់ដូះ អ៊ឺម ប៉ាគ់ទឺ កាន វែ។ ញ៉ង វន់ពថូត អ៊ឺម មែ អ៊ែ មែ មន់ពថូត អ៊ឺម ប៉ាគ់ទឺ វែ។ តង វន់តាក់ តណាក់ អ្រយូច មែ អ៊ែ មែ មន់តាក់ តណាក់ អ្រយូច វែ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","វែ តង វន់អាំ ដើ មែ អ៊ែ គ្រែដៃ លំអាំ ដើ វែ ប៉ាគ់ទឺ លំវ៉ាវ ហ៊ែង អាំ ប៊ិងៗ លំពឺត កន់ស៊ី លីលូ តូវ ស៊ិវ សាគ់ ណាគ់ គ្លឺយ ទឹង រែវ វែ យ៉ាក់ ឞាល់ ង៉ាយ វែ វ៉ើ វ៉ាវ ដើ មែ អ៊ែ គ្រែដៃ លំវ៉ាវ ដើ វែ ឞាល់ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ រៀន៖ «បនឹះ សូត អំប្រា ត្រនឹក ត្រឌីវ សូត ណាគ់ ដូវ លឺ អ៊ឺម? ប៉ាគ់ ពអ៊ែ អាត អំប្រា លន់គ្លីះ ឡើយ ទិ លុងៗ។ ");
INSERT INTO brb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","តៃ ប៊ិច អ៊ឺម លុកស៊ិក មន់ប៊ិច ថណាគ់ ជឺរ ណាយឃូ មែ ហាក់ លែក ដើ លុកស៊ិក ណគ់ ម៉ើ ដូវ ហៀន លែក អ្រណោះ អ្រទីង តើម ប៊ឹង ណាយឃូ អ៊ែ មន់ណោះ ឞាល់ ណាយឃូ មែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ប៉ាគ់ ង៉ាយ ឡើ ត្រ ហតៃ កយ៉ាគ់ ទឹង ម៉ាត់ អំម៉ោះ អោះ ហៃ ហាក់ ហតៃ អ៊ឺម ប៉្រាង ប៊ឹង ម៉ាត់ៗ ហៃ កឡឹ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ដើ ហៃ ដឹះ ប៉្រាង ប៊ឹង ម៉ាត់ៗ ហៃ ហឝ្លាំង ណាគ់ តៃ ហតៃ អ៊ឺម ប៉ិ ណាគ់ ហហាន ហាយ ដើ អំម៉ោះ អោះ ហៃ រៀន “អៃ ឡាំង អោះ អង់កវ៉ាយ កយ៉ាគ់ ម៉ាត់ ហៃ”។ ហបនឹះ ហពឃឺ វ៉ិះ ឌិវ តៃ ពឺង អើយ! ហន់ញ៉ាក់ ប៉្រាង តើម ប៊ឹង ម៉ាត់ ហកឡឹ អន់ដៃ អ៊ែ ហន់ត្រប៉ៃ ហឡាក់ ហន់ដូវ កវ៉ាយ កយ៉ាគ់ ម៉ាត់ តើម ប៊ឹង អំម៉ោះ អោះ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«តៃ ប៊ិច អ៊ឺម តើម ឡង ចាគ់ លំប៉្លៃ តៃ ចាគ់ ណគ់ តើម ឡង តៃ ចាគ់ លំប៉្លៃ ចាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","យ៉ាក់ ង៉ើ ហឝ៉ាវ តើម ឡង មូយៗ ញ៉ន តើម ប៊ឹង ប៉្លៃ។ យ៉ាក់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ប៉ិះ ប៉្លៃ លវ៉ា តើម ប៊ឹង ឆមឺ លែន លឺ ប៉្លៃ ឈឹង ជែម តើម ប៊ឹង តើម រន់ដា។ ");
INSERT INTO brb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","បនឹះ ចាគ់ ឡើ ពដៃ កាន ចាគ់ យ៉ាក់ ចនិះ ណគ ឡើ ចាគ់ បនឹះ តៃ ចាគ់ ឡើ ពដៃ កាន តៃ ចាគ់ យ៉ាក់ ចនិះ ណគ តៃ ឡើ ចាគ់ ប៉ាគ់ទឺ។ បនឹះ ម៉ើ ចជែ ឞ្លៀៗ តាម ឡើ ញឺះ តើម ប៊ឹង ចនិះ មែ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ប៉ាគ់ ង៉ាយ ឡើ ត្រ វ៉ើ ជុ អៃ “យ៉ាគ់ កន់ដ្រាគ់ អើយ យ៉ាគ់ កន់ដ្រាគ់ អើយ” មិៗ ហាក់ តៃ វ៉ើ ឌី អ៊ឺម បើម ត្រួយ ប្រម៉ាង អៃ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","លែក បូវ ម៉ើ ដក់ ចង់ហៀង ប្រម៉ាង អៃ អ៊ែ ម៉ើ បើម ត្រួយ តាម ប្រម៉ាង អៃ អហាយ បូវ មែ អ៊ែ អំព្រឌីវ ប៉ាគ់ ង៉ាយ វ៉ើ ណោះ? ");
INSERT INTO brb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","អំព្រឌីវ ប៉ាគ់ បនឹះ មូយ រ៉ា ឡើ បើម ហន់ណាម ឡើ ចះ ពដិះ ឈ្រុៗ ប៊ឹះ ដដារ ឡើ តាំ ឆ្រាំង ទិ តម៉ តគ់ ឡើ ប៊ឹះ ដាក ដណៃ ឡើ លែប សំយ៉ះ ដាក ឡើ ឆួរ តាវ ឞាល់ ង៉ាយ កតាម ណាគ់ តៃ ឡើ ប៊្លឺគ អ៊ឺម យ៉ាក់ កន់ដ្រាគ់ ណគ ឡើ បើម ឝ៉្រឹត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ណគ់ មែ ម៉ើ ដុង ប្រម៉ាង អៃ ឡើយ ណាគ់ តៃ ម៉ើ ឌី បើម ត្រួយ អ៊ឺម អំព្រឌីវ ប៉ាគ់ បនឹះ មូយ រ៉ា ឡើ បើម ហន់ណាម ឡើ ពដ្រូម ឆ្រាំង ប៊ឹង ប្រិះ មិៗ ឡើ ចះ អ៊ឺម ឈ្រុៗ តគ់ ឡើ ប៊ឹះ ដាក ដណៃ លែប ឆួរ ឡើ តាវ ហន់ណាម អ៊ែ ឡើ តលឹ ត្រសោះ លែក តាក់ ញឹះ តៃ ណាគ់»។ ");
INSERT INTO brb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ប៊្លី គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន មែ ក្លាង ស្រ៊ុក លែវ ឡើយ អ៊ែ ឡើ ដក់ ហឹ មួង កាផារនុំ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ទឹង មួង អ៊ែ ឡើ ប៊ិច ឞយ ប្រម៉ើត យ៉ាគ់ ណាយ តហាន រ៉ូម មូយ រ៉ា ឡើ ឈិ ទុត ម៉ៃ ស្រឹ លន់គែត។ ");
INSERT INTO brb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ទឹង ឡើ ដុង ម៉ើ ចជែ កាន គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ ប្រយ មែ ទិះ ក្រាគ់ អន់នឺ រ៉ា ទឹង សុនសាត យូដា មន់ដក់ ច្រា ឡា គ្រែដៃ យែស៊ូ លំដក់ ពនៀម ឞយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ម៉ើ ដក់ ប៊ឹះ តគ់ អ៊ែ ម៉ើ ឡា ឡូម គ្រែដៃ យែស៊ូ រៀន៖ «ណាយ តហាន អ៊ិន ឡើ បនឹះ ចាគ់ ហណោះ ឡា ដើវ អុះ ឃឺ ហន់ស្រុស្រៀត ណគ ");
INSERT INTO brb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","យ៉ាក់ ណគ ឡើ ម៉ើត ដើ សុនសាត ង៉ាយ ដើម ឡើ អាំ លៀន ដើ ញ៉ា ញ៉ើ បើម រ៉ូង ពស៊ុំ ដិ ពន់ឋើម»។ ");
INSERT INTO brb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ជឹ តូយ ប្រយ មែ។ ម៉ើ ជឹ ដៀប ប៊ឹះ ហន់ណាម ឡើយ អ៊ែ យ៉ាគ់ ណាយ តហាន រ៉ូមាំង ឡើ ប៉្រៃ បូវ ប៊ែង ណគ ដក់ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ! ណាយ តហាន ឡើ ប៉្រៃ ញ៉ា ដក់ ហាយ ដើ ហៃ រៀន “ញ៉ង ហដក់ តំប៉ាប ចាក់ អ៊ឺម ឃឺ អ៊ឺម ញឹះ ឌិត ហៃ ហំមឹត ហន់ណាម ណគ ”។ ");
INSERT INTO brb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ប៉ាគ់ អ៊ែ ឡើយ ណគ កឡឹ ឡើ ឃឹត រៀន តៃ លន់ឃឺ អ៊ឺម លំដក់ ហឹ ហៃ។ វ៉ិះ ហំម៉ាង មូយ អំម៉ាង ប៊ឹង ណិះ ឡើយ អ៊ែ ឆនិ ឞយ ណគ លំនៀម។ ");
INSERT INTO brb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","យ៉ាក់ ណគ នែ ឡើ គូ ក្រូម អាតណាត ណាយ ប៉ាគ់ទឺ ដើម ឡើ ប៊ិច កួន តហាន អើន ម៉ើ គូ កន់ដ្រូម ណគ អន់ណាវ។ ប៉ាគ់ ឡើ ប៉្រៃ បឹ អន់នែ “ដក់” ឡើ ដក់ ប្រយ ប៉ាគ់ ឡើ ប៉្រៃ បឹ អន់នែ “ជឹ” ឡើ ជឹ ប្រយ។ ប៉ាគ់ ឡើ ប៉្រៃ ក៝ត ណគ បើម កាន អង់ង៉ាយ ឡើ បើម ប្រយ (ណគ ឡើ ណោះ ឡើយ ហៃ ហប៊ិច អាតណាត ប៉ាគ់ ហំប៉្រៃ ឞយ ណគ លំនៀម លំនៀម ឡើយ)»។ ");
INSERT INTO brb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","គ្រែដៃ យែស៊ូ ឡើ ដុង បូវ ប៊ែង យ៉ាគ់ ណាយ តហាន ម៉ើ ម៉ាង ប៉ាគ់ អ៊ែ អ៊ែ ឡើ ញ៉ម ខាក់ៗ ប្រយ ដើ ណាយ តហាន។ ឡើ ហវីវ ពហាយ ដើ មែ ក្លាង ស្រ៊ុក ម៉ើ តូយ ណគ ឡើ ព្រតឹះ ព្រនែ ណាយ តហាន រៀន៖ «អៃ អង់ហាយ ដើ វែ លែក រ៉ា រៀន ទុត ទឹង ពធែត អ៊ីស្រាអ៊ែល អៃ ណាគ់ តៃ អតៃ អ៊ឺម បនឹះ ម៉ើ មឹង អៃ ឞាល់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","តគ់ បូវ ប៊ែង ណាយ តហាន ម៉ើ ជឹ ហឹ ហន់ណាម ម៉ើ តៃ បឹ ឡើ ឈិ ឡើ នៀម ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ប៊្លី អ៊ែ អន់ណាវ គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ ស៊្រុក លមូយ ម៉ើ ជុ ស្រ៊ុក ណាអ៊ីន។ មែ លុកស៊ិក ដើម មែ ក្លាង ស្រ៊ុក ទុត អើន ម៉ើ ដក់ តូយ ណគ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ទឹង គ្រែដៃ យែស៊ូ ដៀប លំប៊ឹះ ឝឡោះ ដ្រក ស្រ៊ុក ឡើ តៃ ប្រយ មែ ម៉ើ ទូង កយ៉ក់ មន់ដក់ ចះ បនឹះ ទឹង ស្រ៊ុក ទុត អើន ម៉ើ តូយ មែ ដក់ ចះ កយ៉ក់។ បនឹះ ឡើ គែត អ៊ែ កួន កឡ ម៉ិ យូ កម៉ាយ ឡើ ប៊ិច កួន វ៉ិះ ឌិវ មូយ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ តៃ ម៉ិ យូ កម៉ាយ ឡើ ស្រុស្រៀត ណគ ទុត ខាក់ អ៊ែ ឡើ ហាយ ដើ ណគ រៀន៖ «ញ៉ង ហញឺម យ៉ាវ កួន ហៃ!»។ ");
INSERT INTO brb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ប៊ឹះ តគ់ មែ ឡើ ជុ ទី ពឺង ឝ្រែ ត្រនូង កយ៉ក់ ណគ់ មែ ម៉ើ ទូង កយ៉ក់ ម៉ើ ជឹង ប្រយ។ ឡើ ម៉ាង ដើ បឹ ឡើ គែត រៀន៖ «អើយ ម៉ន ហន់ឌឹក ហំមិញ!»។ ");
INSERT INTO brb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ហំប៊្រុះ ដើ អ៊ែ បឹ ឡើ គែត ឡើ ឌឹក ដ្រូម ចជែ មម៉ាង ប្រយ។ ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឈូន បឹ កឡ អ៊ែ ហឹ មែគ ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","លែក ដើ បូវ ម៉ើ ឌូង ទុត ខាក់ ដើម ម៉ើ ព្រតឹះ ព្រនែ គ្រែដៃ ម៉ើ រៀន៖ «ប៊ិច មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ មូយ រ៉ា ឡើ ទិះ ឡើ ប៊ឹះ ហឹ ង៉ាយ នែ គ្រែដៃ ឡើ ទឺះ ប៉ូរ ប៉ាសាសុន ណគ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ម៉ើ ចជែ កាន ឆង៉ាត់ គ្រែដៃ យែស៊ូ ឡើ បើម អ៊ែ ម៉ើ ដុង ប៊ិង ស្រុក មែ យូដា ដើម បុ ស្រ៊ុក មែ បរ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","បូវ លុកស៊ិក ម៉ើ ដក់ ពហាយ ដើ ណាយឃូ មែ ម៉ាត់ ណគ យ៉ាគ់ យ៉ូហាន លែក ដើ កាន ង៉ាន គ្រែដៃ យែស៊ូ ឡើ បើម។ អ៊ែ ឡើ កឡូវ ប្រយ លុកស៊ិក ណគ បារ រ៉ា ឡើ ប៉្រៃ មន់ដក់ ហឹ ណគ យ៉ាក់ ណគ កឡឹ ឡើ គូ ហឹ ឃុក។ ");
INSERT INTO brb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","អ៊ែ ឡើ ប៉្រៃ អំប្រា ដក់ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ហៃ នែ ឡើយ ឡះ ហគ្រែដៃ គ្រិះ លំត្រ ប៊ឹះ ទិ នែ ណគ់ ញ៉ា ញ៉ើ ចាំ លឺ ណាគ់ ញន់ចាំ ឝ្លាំង បឹ មូយ រ៉ា អន់ណាវ?»។ ");
INSERT INTO brb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","អំប្រា ដក់ ប៊ឹះ តគ់ អ៊ែ អំប្រា តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ យ៉ូហាន ឡើ តម៉ូច ដាក ឡើ ប៉្រៃ ញឺ ញ៉ើ ដក់ តង៉ា ហៃ “ហៃ ឡើយ ឡះ ហគ្រែដៃ គ្រិះ ឡើ ត្រ ហប៊ឹះ ទិ នែ ណគ់ ញ៉ា ញ៉ើ ចាំ លឺ ញន់ចាំ ឝ្លាំង បឹ មូយ រ៉ា អន់ណាវ?”»។ ");
INSERT INTO brb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ប៊ឹង អ៊ែ គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម បនឹះ ទុត អើន ឆនិ ដិ អន់ដិ ណគ់ មែ អរ៉ាក់ មឹត ម៉ើ នៀម មែ ម៉ើ សូត ម៉ាត់ ម៉ើ ត្រប៉ៃ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ អំប្រា រៀន៖ «សប្រា លន់ជឹ ហាយ ដើ យ៉ាគ់ យ៉ូហាន ណគ់ កាន អង់ង៉ាយ សប្រា តៃ ដើម សប្រា ដុង ប៉ាគ់ បនឹះ សូត ណាគ់ ម៉ើ ត្រប៉ៃ បនឹះ កន់ចក ម៉ើ ដក់ ដូវ បនឹះ ស៊ិត ស៊ូត ណាគ់ ម៉ើ នៀម បនឹះ ទុង ចង់ហៀង ណាគ់ ដុង បនឹះ គែត ណាគ់ ញិវ ឡឹះ អ៊ែ ណគ់ មែ ម៉ើ ធុក ញ៉ាក ម៉ើ ដុង កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ");
INSERT INTO brb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","មែ ង៉ាយ តៃ ម៉ើ តាក់ កាន ចាប់ មឹង អៃ មែ អ៊ែ ឡើយ មន់ហ្រនុក ហ្រវ៉ាក»។ ");
INSERT INTO brb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ទឹង អំប្រា ជឹ ហឹ យ៉ាគ់ យ៉ូហាន ក្លើច ឡើយ តៃ នែ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ ប៉ាសាសុន កាន យ៉ាគ់ យ៉ូហាន ឡើ រៀន៖ «ទឹង ខៃ ឡៃ អន់នួរ វ៉ើ ដក់ ឝ្លាំង អង់ង៉ាយ ហឹ ត្រិញ ក្លៀវៗ? វ៉ើ ដក់ ឝ្លាំង តើម ត្រាង កយឺវ ឡើ ពឹក ឡះ? ");
INSERT INTO brb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","វែ វ៉ើ ដក់ ឝ្លាំង អង់ង៉ាយ ហឹ អ៊ែ? វ៉ើ ដក់ ឝ្លាំង បឹ ឡើ ត្រទ្រូប ហហក កដាង ស៊ុត អាវ ស៊ុត ឡះ? ណគ់ មែ ម៉ើ ទ្រូប ហក កដាង ស៊ុត អាវ ស៊ុត ម៉ើ ប៊ិច បាក់ ម៉ើ ចង់ ញឹម ចា ញឹម ញឹះ ឞាល់ ចូវ សវិត  មែ អ៊ែ ម៉ើ គូ ហឹ ហន់ណាម សឋិច ហវ៉ៃ! ");
INSERT INTO brb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","វ៉ើ ដក់ ឝ្លាំង អង់ង៉ាយ ដឹះ ហឹ អ៊ែ? វ៉ើ ដក់ ឝ្លាំង កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡះ? ត្រ ឡើយ! អៃ អង់ហាយ ដើ វែ រៀន យ៉ាគ់ ហង់អ៊ែ ឡើ ខាក់ ជឺរ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","យ៉ាក់ កាន យ៉ាគ់ យ៉ូហាន នែ ឡើយ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ រៀន “អៃ អប៉្រៃ ណគ លំដក់ ពហាយ ដើ បូវ អន់នួរ ហៃ ហំប៊ឹះ ណគ លំព្រនៀម ពចាគ់ ទ្រូង អន់នួរ ដើ ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","អៃ អង់ហាយ ដើ វែ រៀន យ៉ាគ់ យ៉ូហាន ឡើ ខាក់ ជឺរ លែក ដើ បនឹះ ម៉ើ កើត ទិ ឡាង ប្រិះ នែ ហាក់ ណគ់ មែ ម៉ើ កិ ជឺរ ទឹង បូវ គ្រែដៃ កន់ដ្រាគ់ ឡើ ពែក ប៉ាក់ ណគ់ មែ អ៊ែ ម៉ើ ខាក់ ជឺរ យ៉ូហាន អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«លែក ដើ មែ ក្លាង ស្រ៊ុក ដើម មែ កាគ់ លៀន ម៉ើ ដូវ ចង់ហៀង យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក អ៊ែ ម៉ើ បើម ឞ៊ុន ម៉ូច ដាក ប៊ឹង ណគ បក់ បនឹះ មន់ណោះ ហឝ៉ាវ គ្រែដៃ ឡើ ចាគ់ ទឹង ត្រ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ណគ់ ដើ មែ ផារីស៊ី ដើម បូវ មែ ពង់ហៀន ចឞាប់ ម៉ើ ដ្រើះ តាក់ លែក ដើ កាន គ្រែដៃ ឡើ ទែង ដើ មែ មន់បើម យ៉ាក់ តៃ ម៉ើ ឌី មឹត ឞ៊ុន ម៉ូច ដាក ប៊ឹង យ៉ាគ់ យ៉ូហាន»។ ");
INSERT INTO brb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ អន់ណាវ រៀន៖ «ប៊ឹង ង៉ាយ អំព្រឌីវ បនឹះ ប៉ាង អន់នែ? ណគ់ មែ នែ អំព្រឌីវ ប៊ឹង បនឹះ ប៉ាគ់ ង៉ាយ វ៉ាះ លំត្រ? ");
INSERT INTO brb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","អំព្រឌីវ ប៊ឹង មែ អង់គ្លែត ម៉ើ ដ្រូម កំប្រក់ ទឹង បយឺង ម៉ើ ច្រម៉ាន ត្រឌីវ មែ សគ្រែក រៀន “ញ៉ើ ឝ៉ោះ ឝ៉ង ជីង ណាគ់ តៃ វ៉ើ រាំ ញ៉ើ ញឺម បយ៉ុះ បយ៉ាល់ ណាគ់ តៃ វ៉ើ ឌី លូះ ដាក ម៉ាត់”។ ");
INSERT INTO brb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ប៉ាគ់ អ៊ែ ទឺ ឡើយ ដើ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ប៊ឹះ ទិ នែ ឡើ អឹត ចង់ ចា ដើម តវែ តៃ ឡើ ញែត អ៊ែ វ៉ើ រៀន “អរ៉ាក់ ឡើ មឹត ទឹង ណគ”។ ");
INSERT INTO brb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","អ៊ែ ណគ់ កួន បនឹះ អន់ណាវ ឡើ ប៊ឹះ ទិ នែ ណគ ឡើ ញញែត ចចង់ ប៉ាគ់ ពអ៊ែ វែ ណាគ់ តៃ វ៉ើ ឡាប់ ឡង ណគ វ៉ើ រៀន “នែ វន់ឝ្លាំង បឹ អន់នែ ឡើ ក្រហូ សូប ដើម ឡើ ពន់តក ប៊ឹង មែ កាគ់ លៀន ដឹប ប៊ឹង មែ បនឹះ ប៊ិច ឞាប ដិ”។ ");
INSERT INTO brb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ហាក់ លែក ដើ មែ ម៉ើ បើម ត្រួយ ហ្រឡិច គ្រែដៃ ម៉ើ ពដៃ រៀន ហ្រឡិច គ្រែដៃ ឡើ ដាវ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ប៊ិច មែ ផារីស៊ី មូយ រ៉ា ឡើ ច្រា គ្រែដៃ យែស៊ូ ដក់ ចង់ ចា ហឹ ហន់ណាម ណគ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ មឹត ដ្រូម ចង់ ម៉ាត អរែង ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ទឹង មួង អ៊ែ ប៊ិច កទ្រី មូយ រ៉ា តៃ ឡើ ស៊ីត ឡើ ប៊ិច ឞាប ឡើ ដុង គ្រែដៃ យែស៊ូ ឡើ ដក់ ចង់ ហឹ ហន់ណាម បឹ ផារីស៊ី អ៊ែ ឡើ ដក់ យ៉ាវ ឡើ តៀត ណាំហម មូយ កង់គែវ ");
INSERT INTO brb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ឡើ ឆុង តៃ កណង គ្រែដៃ យែស៊ូ ដៀក ឈឹង ណគ អ៊ែ ឡើ ដ្រូម ញឺម តូវ ឡើ លូះ ដាក ម៉ាត់ ញឹះ ឡើ ត្រដាក ឈឹង គ្រែដៃ យែស៊ូ ប៊្លី អ៊ែ ឡើ ឈូត ឈឹង ដើ សក់ ឡើ មុក ដិ ឡើ ឈូត ដិ ឈឹង គ្រែដៃ យែស៊ូ ប៊្លី អ៊ែ ឡើ ហ៊ែង ណាំហម គ្លឹម ដិ ពឺង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","កន់ដ្រាគ់ ហន់ណាម ឡើ តៃ ប៉ាគ់ អ៊ែ ឡើ ឃឹត អង់ឃឹត រៀន៖ «ប៉ាគ់ បឹ អន់នែ លន់កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ម៉ាត អាត លំណោះ ហឝ៉ាវ ឡើយ កទ្រី ណគ់ ឡើ ពឹត ណគ នែ ណោះ ឡើ កទ្រី ប៉ាគ់ ង៉ាយ យ៉ាក់ ឡើ កទ្រី ប៊ិច ឞាប»។ ");
INSERT INTO brb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ ណគ រៀន៖ «អើយ ស៊ីម៉ូន អៃ អំប៉ចៗ កាន ព្រឌីវ មូយ ដើ ហៃ»។ ស៊ីម៉ូន ឡើ តើវ រៀន៖ «ហន់ហាយ ដឹះ យ៉ាគ់ ណាយឃូ!»។ ");
INSERT INTO brb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","គ្រែដៃ យែស៊ូ ឡើ រៀន៖ «ប៊ិច បនឹះ បារ រ៉ា អំប្រា តង់ លៀន ហឹ បឹ ឡើ លមូយ បឹ មូយ រ៉ា ឡើ តង់ សើង ក្លាំ កាក់ បឹ លមូយ អន់ណាវ សើង ជិត កាក់ ។ ");
INSERT INTO brb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","យ៉ាក់ តៃ អំប្រា ប៊ិច លៀន ធែន អ៊ឺម បឹ កឡា ម៉ើ តង់ ណគ ឡើ តាក់ មិៗ ដើ អំប្រា។ ប៉ាគ់ ពអ៊ែ អំប្រា បារ រ៉ា នែ បឹ អង់ង៉ាយ ឡើ ម៉ើត ជឺរ ដើ យ៉ាគ់ កឡា ប៊ិច លៀន?»។ ");
INSERT INTO brb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ស៊ីម៉ូន ឡើ ត្រណើវ រៀន៖ «តាម អៃ អឃឹត ណគ់ បឹ ឡើ តង់ អើន អ៊ែ ឡើ ម៉ើត ជឺរ»។ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ហត្រណើវ អ៊ិន ត្រ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហវីវ ហឹ កទ្រី ហង់អ៊ែ ឡើ ម៉ាង ហឹ ស៊ីម៉ូន រៀន៖ «ណាគ់ ហតៃ ឡះ កទ្រី អន់នែ? ហំប៊្រុះ អមឹត ទឹង ហន់ណាម ហៃ អន់ឌូ ណាគ់ តៃ ហអាំ អ៊ឺម ដាក ដើ អៃ អន់ឆះ ឈឹង ណគ់ ដើ កទ្រី នែ អន់ណាវ ឡើ ញឺម ពលូះ ដាក ម៉ាត់ ប៊ឹង ឈឹង អៃ ដើម ឡើ ឈូត ឈឹង អៃ ដើ សក់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ហៃ ញឹះ តៃ ហមុក អ៊ឺម អៃ  អ៊ែ ណគ់ ដើ កទ្រី នែ ឡើ មុក ឌែៗ ឈឹង អៃ ញឹះ តៃ ឡើ ព្រឹង តើម អៃ អប៊ឹះ អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ហៃ ប៊ិច អឹ ញឹះ ហន់ឡច ទូះ អៃ ដើ ពុក ណគ់ ដើ កទ្រី អន់នែ ម៉ាត់តូវ ដើ ណាំហម គ្លឹម ឡើ ហ៊ែង ប៊ឹង ឈឹង អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ញ៉ន ប៉ាគ់ អ៊ែ ឡើយ អហាយ ដើ ហៃ រៀន ណាង កទ្រី អន់នែ ឡើ ម៉ើត ដើ អៃ ម៉ៃៗ យ៉ាក់ គ្រែដៃ ឡើ តាក់ ឞាប ដើ ណគ ទុត អើន ឡើយ ណគ់ មែ ង៉ាយ គ្រែដៃ ឡើ តាក់ ឞាប កិៗ ណគ អ៊ែ លំម៉ើត ដើ គ្រែដៃ កិៗ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ កទ្រី នែ រៀន៖ «អៃ អតាក់ ឡើយ ឞាប ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ណគ់ មែ ម៉ើ ចង់ ចា អរែង ប៊ឹង ណគ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ឡើ បនឹះ ប៉ាគ់ ង៉ាយ ឋូវ បឹ អន់នែ អ៊ែ ឡើ ហាន ម៉ាង រៀន ឡើ តាក់ ឞាប បូវ ដូវ អ៊ែ ម៉ើ ក្លើច ប៉ាគ់ អ៊ិន?»។ ");
INSERT INTO brb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ កទ្រី ហង់អ៊ែ រៀន៖ «យ៉ាក់ ហមឹង គ្រែដៃ ឡើយ អ៊ែ ឡើ ហវ៉ាត់ ហៃ។ ហន់ជឹ ញឹម សាំង ហំមិញ យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ មួង ហង់អ៊ែ ក្លង មួង ហង់អ៊ែ ដក់ ស្រ៊ុក ហង់អ៊ែ ក្លង ស្រ៊ុក ហង់អ៊ែ ឡឹះ ទុត អើន ដើម ឡើ ពហាយ ពន់ដុង មែ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ លំបើម សឋិច ពែក ប៉ាក់។ លុកស៊ិក ណគ ជិត បារ រ៉ា ម៉ើ តូយ ណគ ");
INSERT INTO brb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ដើម ឡើ ប៊ិច មែ កទ្រី អន់នឺ រ៉ា ម៉ើ ដក់ តូយ គ្រែដៃ យែស៊ូ ប៉ាគ់ទឺ។ មែ កទ្រី នែ គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម ឆនិ មែ ដើម ណគ់ មែ អរ៉ាក់ ឡើ មឹត។ ឡើ ប៊ិច ណាង ម៉ារី ស្រ៊ុក ម៉ាដាឡា អរ៉ាក់ ប៉ឹះ ម៉ើ ញឺះ តើម ប៊ឹង ណគ ");
INSERT INTO brb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ប៊ិច ណាង យ៉ូហាណា ក្ល ណគ យ៉ាគ់ ឃូសា ណគ នែ ឡើយ ឡើ រន់ឋាប់ ឝ្លាំង កាន សឋិច ហ៊ែរ៉ូត ប៊ិច ណាង ស៊ូសាណា ដឹប ប៊ិច មែ កទ្រី ទុត អើន អន់ណាវ។ មែ នែ ឡើយ ម៉ើ ប៉ូរ អាំ ចណង់ ចណា រ៉ាះ អំបាះ ដើ មែ គ្រែដៃ យែស៊ូ តាម ប្រនិច មែ។ ");
INSERT INTO brb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ឡើ ប៊ិច មែ ក្លាង ស្រ៊ុក ទុត អើន ឆន់ ហន់ឆឹន វ៉ិន អវែន ម៉ើ ប៊ឹះ តើម ប៊ឹង ស៊្រុក ដិ អន់ដិ ម៉ើ ដក់ តមួត ហឹ គ្រែដៃ យែស៊ូ អ៊ែ ឡើ ហាយ ព្រឌីវ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«ប៊ិច កឡ មូយ រ៉ា ឡើ ដក់ ប្រាក់ អង់គុង ហឹ ណា ណគ។ ទឹង ប៉ះ ឡើ ប្រាក់ អ៊ែ អង់គុង អន់នឺ ឡើ គ្លីះ ត្រ ប៉ុះ ទ្រូង អ៊ែ ឡើ ប៊ិច បនឹះ ម៉ើ ដក់ ឆាន់ ដើម ជែម ម៉ើ ទឺះ ក្លក់ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","អង់គុង អន់នឺ ឡើ គ្លីះ ទិ តម៉ ដដារ់ តៃ ហន់ដាគ់ ប៊ិច ប្រះ ឡើ ហួន ឞិត ឞ៊ែត ប៊្លី អ៊ែ ឡើ រ៉ូយ គែត យ៉ាក់ តៃ ឡើ ប៊ិច ដាក អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","អង់គុង អន់នឺ ឡើ គ្លីះ ប្លះ តើម ឆ្រឡា ឡើ ហួន ឞិត ឞ៊ែត ឡើ ហឝុះ ដើ ឆ្រឡា អ៊ែ ចិះ ឡើ កអង់ គែត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ឡើ ប៊ិច អង់គុង អន់នឺ ឡឹះ អន់ណាវ ឡើ គ្លីះ ទឹង ពដិះ អ៊ីន ឡើ ហួន ចាគ់ៗ ប៉្លៃ ឡើ ស៊ឺក កនុង មូយ តើម ឡើ ប៊ិច មូយ ក្លាំ អង់គុង»។ ឡើ ប៉ច អំប៉ច លែវ ឡើយ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ថាំងៗ រៀន៖ «ណគ់ មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង អៃ នែ វន់ឃឹត យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","លុកស៊ិក គ្រែដៃ យែស៊ូ ម៉ើ តង៉ា ណគ រៀន៖ «ហព្រឌីវ អន់នែ ប៉ាគ់ ង៉ាយ ហងុញ ម៉ាង?»។ ");
INSERT INTO brb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «គ្រែដៃ ឡើ អាំ បូវ វែ លុកស៊ិក វន់ណោះ កាន ឡើ វៀក ដក តើម ប៊ឹង ឡើ បើម សឋិច ឡើ ពែក ប៉ាក់ ប៉ាសាសុន ណគ។ អ៊ែ ដើ មែ ហឹ គែង អន់ណាវ អៃ អហាយ ដើ មែ វ៉ិះ ឌិវ អព្រឌីវ អ៊ែ សំ មែ ម៉ើ ឝ្លាំង ណាគ់ តៃ មន់តៃ អ៊ឺម សំ ម៉ើ ដុង ណាគ់ តៃ មន់ណោះ អ៊ឺម ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«កាន អព្រឌីវ អ៊ែ ប៉ាគ់ នែ អម៉ាង អង់គុង នែ ឡើ ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","បនឹះ អន់នឺៗ ម៉ើ បើម ប៉ាគ់ អង់គុង ឡើ គ្លីះ តៃ ទ្រូង មែ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ឡើយ អ៊ែ ណគ់ អរ៉ាក់ សតាំង នែ ឡើ សុក ប្រម៉ាង គ្រែដៃ តើម ប៊ឹង ចនិះ មែ ញ៉ង អាំ មន់ចាប់ គ្រែដៃ ឝ៉ាន់ លំហវ៉ាត់ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","បនឹះ អន់នឺ រ៉ា អន់ណាវ ម៉ើ បើម ប៉ាគ់ អង់គុង ឡើ គ្លីះ ទឹង តម៉ ដដារ់ ហំប៊្រុះ ម៉ើ ដុង ប្រម៉ាង គ្រែដៃ ម៉ើ ញឹម ក្លើម ក្លាក ម៉ើ ចាប់ ប្រយ ហាក់ មែ ម៉ើ ចាប់ ឞិត ឞ៊ែត យ៉ាក់ ប្រម៉ាង គ្រែដៃ ឡើ បើម ប៉ាគ់ រៀះ ដណាំ ឡើ តូត តៃ ឈ្រុ អ៊ឺម ទឹង ចនិះ មែ។ តង៉ៃ ង៉ាយ ឡើ ប៊ិច កាន ពលូង មែ អ៊ែ ម៉ើ តាក់ មឹង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ណគ់ អង់គុង ឡើ គ្លីះ ប្លះ តើម ឆ្រឡា ឡើ បើម ប៉ាគ់ មែ ម៉ើ ចង់ហៀង ប្រម៉ាង គ្រែដៃ ហាក់ ឌិវ ម៉ើ វន់វ៉ាយ ដើ កាន ញិវ កើត ម៉ើ ដាំង ប្រនិច ម៉ើ អ៊ឺក ដើ កាន រ៉គ់ សំ។ កាន លែក អ៊ែ ឡើយ ឡើ បើម ប៉ាគ់ តើម ឆ្រឡា ឡើ បើម ហឝុះ មែ អ៊ែ ពឺរ ប៉្លៃ មែ ឡើ បាត់ ពណាត់ តៃ ឡើ ឌុំ អ៊ឺម ");
INSERT INTO brb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","អ៊ែ ណគ់ អង់គុង ឡើ គ្លីះ ប្លះ ពដិះ អ៊ីន ឡើ បើម ប៉ាគ់ បនឹះ ចាគ់ ទឹង ត្រ ម៉ើ ចង់ហៀង ប្រម៉ាង គ្រែដៃ ម៉ើ ចាប់ ប្រម៉ាង គ្រែដៃ ដើម ម៉ើ បើម ត្រួយ អ៊ែ មែ ម៉ើ បើម អង់កើត ពឺរ ប៉្លៃ ញ៉ន ម៉ើ បក់ អុតថុន»។ ");
INSERT INTO brb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","គ្រែដៃ យែស៊ូ ឡើ ព្រឌីវ ឡឹះ រៀន៖ «តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ចុះ តកៀង មន់ទ្រូប គ្លឹប ដើ វ៉ាន់ លឺ មន់ដក់ ជុ តៃ ក្រូម ឝ្រែ។ ម៉ើ ចក់ តកៀង ម៉ើ ជុ ឈ្រុង ឈ្រូង អ៊ែ លំឝ៉ាល ដើ មែ មន់មឹត ហឹ ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ហឹ ខៃ ណូវ បនឹះ មន់តៃ កាន កដក ណិះៗ នែ អ៊ែ ណគ់ ឡើ វៀក ដក មន់ណោះ ហឡាក់ៗ។ ");
INSERT INTO brb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","វែ វន់ចង់ហៀង ជុ ហឡាក់ៗ យ៉ឹ ប្រម៉ាង គ្រែដៃ! ណគ់ មែ ង៉ាយ ម៉ើ ប៊ិច ឡើយ គ្រែដៃ លំអាំ ឡឹះ អន់ណាវ ហាក់ ណគ់ មែ តៃ ម៉ើ ប៊ិច គ្រែដៃ លន់ចក់ ពលែក»។ ");
INSERT INTO brb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","មែគ ដើម មែ អោះ កឡ គ្រែដៃ យែស៊ូ មែ ម៉ើ ដក់ ដាំង ណគ ហាក់ ប៊ឹះ អ៊ឺម ម៉ើ ដក់ ហឹ ណគ ញ៉ន ឡើ ប៊ិច បនឹះ ឝិត អង់ឝិត ឈុំ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ប៊ិច មែ ម៉ើ ហាយ ដើ ណគ រៀន៖ «មែគ ដើម អំម៉ោះ អោះ ហៃ ម៉ើ ដក់ ដាំង ហៃ ម៉ើ ចាំ ហៃ តគ់ បយឺង ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","គ្រែដៃ យែស៊ូ ឡើ តើវ មែ រៀន៖ «ណគ់ មែ ម៉ើ ចង់ហៀង ប្រម៉ាង គ្រែដៃ ដើម ម៉ើ បើម ត្រួយ មែ អ៊ែ ឡើយ ឡើ ត្រ មែគ អៃ អំម៉ោះ អោះ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ ទឺះ ឈិះ ឌូក អរែង ដើ លុកស៊ិក ណគ អ៊ែ ឡើ ចន់ដ្រា មែ រៀន៖ «ញ៉ះ អើយ ញន់ក្លង សមុត តៃ តគ់!»។ អ៊ែ ម៉ើ ទឺះ ឈិះ ប្រយ ឌូក។ ");
INSERT INTO brb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ប៊ឹង ម៉ើ ក្លង គ្រែដៃ យែស៊ូ ឡើ ហង់ង៉ាន់ ប្រយ។ ទឹង ឡើ ហង់ង៉ាន់ កយឺវ ទិះ ឡើ ប៊ឹះ ប្រយ ភឹបៗ ឡើ ពឹក ដាក ដាក ឡើ អន់ជឺច មឹត ទឹង ឌូក លែក ដើ មែ ស្រឹ មន់ឡូប ម៉ើ គូ ទឹង កាន ខគ់ណាំ។ ");
INSERT INTO brb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","មែ លុកស៊ិក ម៉ើ ដក់ ពរ៉ៃ គ្រែដៃ យែស៊ូ ម៉ើ រៀន៖ «យ៉ាគ់ ណាយឃូ! យ៉ាគ់ ណាយឃូ! ងន់គែត ឡើយ ង៉ាយ នែ»។ គ្រែដៃ យែស៊ូ ឡើ រ៉ៃ ប្រយ ឡើ ឌឹក ម៉ាង ក្រាគ់ ដើ កយឺវ ដើម ដាក ឡើ អន់ជឺច។ អ៊ែ កយឺវ ដើម ដាក អន់ជឺច ឡើ ប៉ាត់ ហ្រហៀង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ លុកស៊ិក រៀន៖ «ហំប៊ិ វ៉ើ រៀន វ៉ើ មឹង អៃ ដឹះ?»។ បូវ មែ លុកស៊ិក ម៉ើ ឌូង ដើម ម៉ើ ញ៉ម ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «មែ ង៉ាយ ឋូវ យ៉ាគ់ អន់នែ អ៊ែ ឡើ ដូវ តប៉ាត់ កយឺវ ដើម ដាក ម៉ើ ចាប់ ណគ ហ្រហៀង ឞាល់ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","គ្រែដៃ យែស៊ូ ដើម មែ លុកស៊ិក ណគ ម៉ើ ក្លង ប៊ឹះ ប៊្រី ដាក ឝែរ៉ាស៊ិន ឡើ ហ្រទឹង ស្រុក ឝ៉ាលីលែ ");
INSERT INTO brb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ប៊ឹង គ្រែដៃ ឡើ ឌឹក ទឹង ពឹះ អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ ខើយ គូ ហឹ មួង មែ អ៊ែ ឡើ ដក់ ដាំង ណគ។ បនឹះ នែ អរ៉ាក់ ឡើ មឹត ទឹង ណគ ឡើ គូ ហំប្រាត តៃ ឡើ ណោះ ទ្រូប ខូ អាវ ឌុញ ឡើយ តៃ ឡើ គូ យ៉ាវ ទឹង ហន់ណាម ឡើ គូ ហឹ ត្រម ចនុ កយ៉ក់ ");
INSERT INTO brb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ហំប៊្រុះ ឡើ តៃ គ្រែដៃ យែស៊ូ អ៊ែ ឡើ ហរ៉ាវ កដាប ប្រយ ប៊ឹង ឈឹង ណគ ឡើ ម៉ាង ថាំងៗ រៀន៖ «ឡា យែស៊ូ ហៃ ហកួន កឡ គ្រែដៃ ឡើ ទិះ ឈ្រូង អើយ ហដាំង ខ ង៉ាយ ហឹ អៃ? ឡា អុះ ញ៉ង ហតំប៉ាប តំពុន អ៊ឺម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","អរ៉ាក់ ឡើ ឡា ឡូម ប៉ាគ់ អ៊ែ ញ៉ន គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ វីះ តើម ប៊ឹង បឹ ហង់អ៊ែ។ យ៉ាក់ អរ៉ាក់ ឡើ ខើយ បើម ពន់ចះ ពន់ចាល ណគ អើន តង ឡើយ សំ ម៉ើ ញ៉ាម ចង ឈឹង ទី ណគ ដើម ម៉ើ តាំ ស៊ីក តាំ កណោះ ជុ មូយ អំប៊ុ ហាក់ ឡើ តរឹត កណោះ ណាគ់ តាត់ អ៊ែ អរ៉ាក់ ឡើ តៀត ណគ ហឹ ត្រិញ ក្លៀវៗ។ ");
INSERT INTO brb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","គ្រែដៃ យែស៊ូ ឡើ តង៉ា ណគ រៀន៖ «អង់ង៉ាយ ម៉ាត់ ហៃ?»។ ណគ ឡើ ត្រណើវ រៀន៖ «ម៉ាត់ អៃ នែ កង តហាន»។ ឡើ ត្រណើវ ប៉ាគ់ អ៊ែ យ៉ាក់ អរ៉ាក់ ម៉ើ មឹត ទឹង ណគ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","លែក ដើ អរ៉ាក់ ទឹង ចាក់ ណគ ម៉ើ ឡា ឡូម ដឌែ ហឹ គ្រែដៃ យែស៊ូ តៃ អាំ លន់កលីះ មែ ទិ ឃុក កន់ដ្រាន់ អរ៉ាក់ ឈ្រុ តៃ ឋាំ ។ ");
INSERT INTO brb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ប្លះ អ៊ែ ឡើ ប៊ិច ជុរ មូយ បូវ ទុត អើន ម៉ើ ចជឹក បរ ក្រជែង សាង ចន់ឌូ។ អ៊ែ បូវ អរ៉ាក់ ម៉ើ ឡា ឡូម ហឹ គ្រែដៃ យែស៊ូ មន់មឹត គូ ទឹង ជុរ អន់ណាវ គ្រែដៃ យែស៊ូ ឡើ អាំ ប៉ាគ់ទឺ មែ មន់មឹត ទឹង ជុរ។ ");
INSERT INTO brb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","បូវ អរ៉ាក់ ម៉ើ ញឺះ តើម ប៊ឹង បឹ ហង់អ៊ែ ម៉ើ មឹត ហឹ ជុរ បូវ ជុរ អ៊ែ ម៉ើ វីះ អ្រយ៉ាវ តៃ ក្រជែង សាង ចន់ឌូ ម៉ើ គ្លីះ ទិ ដាក សមុត អ៊ែ ម៉ើ ឡូប គែត លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","បូវ មែ ម៉ើ ពែក ជុរ ហំប៊្រុះ ម៉ើ តៃ កាន ឡើ កើត ប៉ាគ់ អ៊ែ ម៉ើ ជឹ អ្រយ៉ាវ ពហាយ ដើ មែ ទឹង មួង ដើម ដើ មែ ម៉ើ គូ ហឹ មឺរ ញ៉ក បក តូង។ ");
INSERT INTO brb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","អ៊ែ មែ លែក រ៉ា ម៉ើ ចន់ដ្រា ដក់ ឝ្លាំង កាន ឡើ កើត អ៊ែ។ ប៊ឹះ តគ់ គ្រែដៃ យែស៊ូ ម៉ើ តៃ បឹ ណគ់ អរ៉ាក់ ឡើ មឹត ឡើ ដ្រូម ដៀក ឈឹង គ្រែដៃ យែស៊ូ ឡើ ណោះ ឍិង ឋាំង ឡើ ទ្រូប ហក ខូ អាវ ប៉ាគ់ អំប៊ី រីវ ទឺ។ អ៊ែ ម៉ើ ឌូង ដើ គ្រែដៃ យែស៊ូ ឡើ ណោះ បើម កាន ឆង៉ាត់ ឞាល់ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ណគ់ មែ ម៉ើ តៃ កាន ឡើ កើត អន់ឌូ អ៊ែ ម៉ើ ពប៉ច ដើ បូវ ណគ់ កាន គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម បឹ អរ៉ាក់ ឡើ មឹត ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","មែ ក្លាង ស្រ៊ុក ម៉ើ គូ ទឹង ប៊្រី ដាក ឝែរឝែសា ម៉ើ ឡា ប៉្រៃ គ្រែដៃ យែស៊ូ លំវីះ តើម ប៊ឹង ប៊្រី ដាក មែ យ៉ាក់ ម៉ើ ឌូង ទុត ខាក់ ដើ ណគ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ទឺះ ឈិះ ឌូក ឡើ ជឹ វឹញ ហឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","កឡ ណគ់ គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម នែ ឡើ ឡា ជឹ តូយ ណគ ហាក់ គ្រែដៃ យែស៊ូ ឡើ អាំ អ៊ឺម ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«ហន់ជឹ ដាំង ហន់ណាម ក្រាន ហៃ កឡឹ ហំមិញ អ៊ែ ហំប៉ច ដើ មែ ត្រំ កាន ណគ់ គ្រែដៃ ឡើ បើម អន់នៀម ហៃ»។ អ៊ែ បឹ ហង់អ៊ែ ឡើ ជឹ ប៉ច អំប៉ច លែក ដើ មែ ទឹង មួង នែ អាំ មែ មន់ណោះ តូច ដើ កាន គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ក្លង ជឹ វឹញ ឡើយ បូវ មែ ក្លាង ស្រ៊ុក ទុត អើន ម៉ើ ដក់ យ៉ាវ ណគ យ៉ាក់ ម៉ើ គូ ចាំ ណគ លំប៊ឹះ។ ");
INSERT INTO brb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ទឹង អ៊ែ ឡើ ប៊ិច កឡ មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ យ៉ៃរ៉ូះ ឡើ កឡា ឝ្លាំង កាន យូច ត្រ រ៉ូង ពស៊ុំ ឡើ ដក់ កដាប ហំបះ ចុ ឈឹង គ្រែដៃ យែស៊ូ ឡើ ឡា ឡូម ចន់ដ្រា គ្រែដៃ យែស៊ូ ដក់ ហឹ ហន់ណាម ណគ ");
INSERT INTO brb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","យ៉ាក់ ណគ ឡើ ប៊ិច កួន កទ្រី វ៉ិះ ឌិវ មូយ រ៉ា អិះ ឡើយ អញុ ណគ ជិត បារ កម៉ អ្យាង ឡើ ឈិ ម៉ៃ ដៀប លន់គែត ឡើយ។ អ៊ែ តៃ ទ្រូង មែ ក្លាង ស្រ៊ុក ម៉ើ ដក់ អន់ដៀត អន់លៀត ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ទឹង អ៊ែ ឡើ ប៊ិច កទ្រី មូយ រ៉ា ឡើ ពន់ឆិច ញឹះ ជិត បារ កម៉ ឡើយ (ឡើ តប៉ាត់ រ៉ាះ អំបាះ ណគ អាំ ដើ មែ ពែត លែក តាក់ ឡើយ ) ណាគ់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ណោះ បើម អន់នៀម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","កទ្រី អន់នែ ឡើ ដក់ តៃ ត្រិច គ្រែដៃ យែស៊ អ៊ែ ឡើ ពឹត ក្រប៊ុយ អាវ ណគ ហំប៊្រុះ ដើ អ៊ែ កអវ ដើ ឡើ អាត់ ប្រយ ផាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «មែ ង៉ាយ ហង់អ៊ិន ម៉ើ ពឹត អៃ?»។ មែ ត្រំ រ៉ា ម៉ើ ប៉ាវ រៀន៖ «ញ៉ើ ពឹត អ៊ឺម ញ៉ា អាវ ហៃ»។ អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ហាយ រៀន៖ «យ៉ាគ់ ណាយឃូ! ប៉ិ ហម៉ាង ប៉ាគ់ អ៊ិន? បនឹះ ទុត អើន ឞាល់ នែ ម៉ើ ដក់ អន់ដៀត អន់លៀត ណាគ់ មែ ង៉ាយ តៃ មន់បើម អន់ទូត ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ហាក់ គ្រែដៃ យែស៊ូ ឡើ តើវ រៀន៖ «ប៊ិច មូយ រ៉ា ឡើ ពឹត អៃ យ៉ាក់ អដុង ឆង៉ាត់ ឡើ ញឺះ តើម ប៊ឹង អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","កទ្រី នែ ឡើ ណោះ រៀន ផ អ៊ឺម លំអំម៉គ់ លំជែប តៃ មន់ណោះ ណគ អ៊ែ សាន់ ឡើ ដក់ ហឹ គ្រែដៃ យែស៊ូ តូវ ឡើ សសឹរ ចាក់ ឡើ កដាប ហំបះ ពហាយ ក្រម៉ាត ដើ ណគ ទឹង បូវ លែក អ៊ែ ញ៉ន ឡើ ពឹត អាវ ណគ ឡើយ អ៊ែ ឡើ នៀម។ ");
INSERT INTO brb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ កទ្រី ហង់អ៊ែ រៀន៖ «ណាង អើយ! ញ៉ន ហមឹង អៃ អ៊ែ ហនៀម ប៉ាគ់ នែ ហន់ជឹ ហំមិញ ញឹម សាំង យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ទឹង គ្រែដៃ យែស៊ូ ណាគ់ ឡើ ចជែ អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ ប៊ឹះ តើម ប៊ឹង ហន់ណាម យ៉ាគ់ យ៉ៃរ៉ូះ ឡើ ពហាយ ដើ ណគ រៀន៖ «អើយ យ៉ាគ់ យ៉ៃរ៉ូះ កួន ហៃ ហឹ តគ់ ឡើ តាត់ សើម ឡើយ ហណោះ សណូវ ហន់ច្រា យ៉ាវ ណាយឃូ ឝ៉ាន់ លំដក់ តំប៉ាប ឈឹង»។ ");
INSERT INTO brb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","គ្រែដៃ យែស៊ូ ឡើ ដុង ម៉ច ប្រម៉ាង អំប្រា អ៊ែ ឡើ ហាយ ដើ យ៉ាគ់ យ៉ៃរ៉ូះ រៀន៖ «ញ៉ង ហឌូង អ៊ឺម! ថលែម ហំមឹង អៃ កួន ហៃ លំនៀម ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ទឹង គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តគ់ ហន់ណាម យ៉ាគ់ យ៉ៃរ៉ូះ ឡើយ ឡើ អាំ អ៊ឺម មែ បូវ មឹត តូយ ណគ ឡើ អាំ មឹត ឌិវ ពែត្រុះ យ៉ូហាន យ៉ាកុប ដើម មែគ បើគ កយ៉ក់ កឡឹ ឌិវ អិះ ឡើយ ម៉ើ ដូវ មឹត។ ");
INSERT INTO brb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","លែក ដើ មែ ម៉ើ ដក់ ផូវ ម៉ើ ញឺម ហរ៉ាវ កឡះ ម៉ើ អង់ងឹះ ណគ ហាក់ ដើ គ្រែដៃ យែស៊ូ ឡើ រៀន៖ «ញ៉ង វ៉ើ ញឺម យ៉ាវ ឡើ គែត អ៊ឺម វ៉ិះ ឡើ ហង់ង៉ាន់ តៀក ហវ៉ៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","មែ ម៉ើ ចអាវ ពន់ឆាំ តវ៉ក គ្រែដៃ យែស៊ូ យ៉ាក់ ម៉ើ តៃ កួន ណគ នែ ឡើ គែត ម៉ាត់ ម៉ាត ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ រ៉ាប់ ទី ណាង ឡើ គែត អ៊ែ ឡើ កឡូវ ថាំងៗ រៀន៖ «អើយ ណាង! ហន់ឌឹក ហំមិញ»។ ");
INSERT INTO brb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ហំប៊្រុះ ដើ អ៊ែ ផវ យ៉ាង ណគ ឡើ ជឹ វឹញ ហឹ ទឺ អ៊ែ ឡើ រ៉ៃ ឌឹក ឃុត ប្រយ។ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ ម៉ើ អាំ ចណង់ ចណា ដើ ណាង លន់ចង់ ចា។ ");
INSERT INTO brb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","មែគ បើគ ណគ អំប្រា ញ៉ម ទុត ខាក់ ប្រយ ហាក់ ដើ គ្រែដៃ យែស៊ូ ឡើ ថាន់ អំប្រា តៃ អាំ ពប៉ច កាន លែក នែ ដើ មែ ហឹ គែង អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","គ្រែដៃ យែស៊ូ ឡើ កឡូវ លុកស៊ិក ណគ តូច ជិត បារ រ៉ា ដក់ ពស្រូម ប៊ឹង ណគ អ៊ែ ឡើ អាំ ដើ មែ កាន ឆង៉ាត់ ដើម អាតណាត ពន់ឌ្រុះ អរ៉ាក់ លែក អិះ ដើម អាតណាត បើម អន់នៀម មែ ម៉ើ ឈិ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","អ៊ែ ណគ ឡើ ប៉្រៃ ម៉ើ ដក់ ពហាយ ដើ បូវ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដើម មន់បើម អន់នៀម មែ ម៉ើ ឈិ។ ");
INSERT INTO brb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ មែ លុកស៊ិក រៀន៖ «ប៊ឹង វែ វន់ដក់ ពហាយ ដើ បូវ ញ៉ង វន់តៀត អង់ង៉ាយៗ អ៊ឺម សំ តង អន់ណើង កតាម ក្រឌុង ប្រណាក់ កតាម ចណា ចណាត់ កតាម លៀន កាក់ កតាម ហម អាវ ពលិះ ពឡាក់ កតាម ណាគ់ តៃ វន់តៀត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ប៉ាគ់ វន់មឹត ហឹ ហន់ណាម មែ ង៉ាយ វន់គូ ទឹង ហន់ណាម មែ អ៊ែ ឡើយ ឋា ដើ វន់វីះ តើម ប៊ឹង ស្រ៊ុក មែ។ ");
INSERT INTO brb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ប៉ាគ់ ស្រ៊ុក មែ ង៉ាយ តៃ មន់ឡាប់ ឡង វែ អ៊ែ វន់វីះ តើម ប៊ឹង ស៊្រុក មែ ដើម វន់ក្រប៉ូះ ភុក ភុយ តើម ប៊ឹង ឈឹង វែ ដិ បក់ មន់ណោះ គ្រែដៃ លំពថូត មែ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","មែ លុកស៊ិក ម៉ើ ដក់ ពហាយ ប្រយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ អំប៉ម ស្រ៊ុក ប្រិះ បូវ ហន់ដឹប ម៉ើ បើម អន់នៀម មែ ម៉ើ ឈិ ត្រំ អំប៊ុ។ ");
INSERT INTO brb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","យ៉ាគ់ សឋិច ហ៊ែរ៉ូត ឡើ ពែក ប៉ាក់ ស្រុក ឝ៉ាលីលែ ឡើ ដុង កាន គ្រែដៃ យែស៊ូ ឡើ បើម អ៊ែ ឡើ ឃឹត ស្រៀវ អ្រអវ តៃ ណោះ ប៉ាគ់ ង៉ាយ យ៉ាក់ ឡើ ដុង បនឹះ អន់នឺ រ៉ា ម៉ើ រៀន “យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ញិវ ឡឹះ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","មែ អន់នឺ រ៉ា ម៉ើ រៀន “យ៉ាគ់ អ៊ែលីយ៉ា ឡើ ពដៃ ចាក់ ដើ បូវ ឡឹះ អន់ណាវ”។ មែ អន់នឺ រ៉ា អន់ណាវ ម៉ើ រៀន “ប៊ិច កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡៃ មាំង ឡើ ញិវ ឡឹះ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","យ៉ាគ់ ហ៊ែរ៉ូត ឡើ រៀន៖ «អប៉្រៃ ឡើយ មែ ម៉ើ ឆាល់ ដង់ យ៉ូហាន អ៊ិន។ បឹ អង់ង៉ាយ អន់ណាវ ណគ អ៊ិន អ៊ែ ឡើ ណោះ បើម កាន ឆង៉ាត់ ឞាល់ អ៊ិន?»។ អ៊ែ សឋិច ហ៊ែរ៉ូត ឡើ ងុញ តៃ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ប៊ឹង លុកស៊ិក គ្រែដៃ យែស៊ូ ម៉ើ ជឹ វឹញ ហឹ ណគ ម៉ើ ពហាយ លែក ដើ កាន មែ ម៉ើ បើម។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ចន់ដ្រា មែ ដក់ ហឹ ឞន ក្លៀវៗ តើម ប៊ឹង បូវ ដៀប ស្រ៊ុក ប៊ែតសៃដា។ ");
INSERT INTO brb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","តគ់ មែ ក្លាង ស្រ៊ុក ម៉ើ ណោះ ណគ ឡើ គូ ហឹ អ៊ែ ម៉ើ ដក់ សាត ឆ្រួយ ណគ។ គ្រែដៃ យែស៊ូ ឡើ ឡាប់ មែ អ៊ែ ឡើ ពង់ហៀន កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដើ មែ មន់ចង់ហៀង ដឹប ឡើ បើម អន់នៀម មែ ម៉ើ ឈិ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ដៀប លំអំប៊ឹ ឡើយ លុកស៊ិក គ្រែដៃ យែស៊ូ លែក ជិត បារ រ៉ា ម៉ើ ដក់ ពហាយ ដើ ណគ រៀន៖ «អើយ ណាយឃូ! ហំប៉្រៃ មែ ក្លាង ស្រ៊ុក កឡឹ អើយ មន់ដក់ ដាំង ចណង់ ចណា ដើម កណី កនូ បរ ស្រ៊ុក មឺរ ចើមៗ ប្លះ នែ ហឹ នែ ញឹះ ឞ៊្លិង ឞ្លៀង ញ៉ើ តៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ហាក់ គ្រែដៃ យែស៊ូ ឡើ តើវ រៀន៖ «វែ កឡឹ វន់អាំ ចណង់ ចណា ដើ មែ ដិ យ៉ឹ»។ មែ លុកស៊ិក ម៉ើ តើវ ណគ រៀន៖ «ញ៉ា ញ៉ើ ប៊ិច វ៉ិះ ឌិវ ហន់តារ សើង ហន់ឋរ ទ្រឺ ច្រាំ បារ សួយ ប៉ិ លំឆិ មន់ចង់ តៃ កា ញន់ដក់ រួត ឡឹះ អន់ណាវ ដើ មែ លែក រ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ម៉ើ ម៉ាង ប៉ាគ់ នែ យ៉ាក់ ទឹង អ៊ែ ឡើ ប៊ិច បនឹះ សើង ហលិក រ៉ា អ្យាង ម៉ើ កាវ ឌិវ មែ កឡៗ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ មែ លុកស៊ិក ណគ រៀន៖ «វន់ប៉្រៃ មែ មន់ដ្រូម ប៉ិន អំប៊ុៗ កនុង មូយ អំប៊ុ សើង ជិត រ៉ា អ្យាង»។ ");
INSERT INTO brb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","បូវ មែ លុកស៊ិក ម៉ើ បើម តាម ពន់ដ្រៃ ណាយឃូ មែ អ៊ែ មែ លែក រ៉ា ម៉ើ ដ្រូម ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","គ្រែដៃ យែស៊ូ ឡើ ឝ៉ឹន ហន់តារ សើង ហន់ឋរ ដើម ទ្រឺ បារ សួយ នែ ប៊្លី អ៊ែ ឡើ ង៉ើយ ព្រតឹះ គ្រែដៃ កន់ដ្រាគ់ លែវ អ៊ែ ឡើ កដោះ អាំ ដើ លុកស៊ិក ណគ មន់ប៉ាក ដើ មែ ក្លាង ស្រ៊ុក មន់ចា។ ");
INSERT INTO brb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","មែ ក្លាង ស្រ៊ុក ទឹង អ៊ែ ម៉ើ ចា ផិ ប៊ិង ត្រំ រ៉ា។ ម៉ើ ចង់ ចា លែវ ឡើយ អ៊ែ មែ លុកស៊ិក ម៉ើ រ៉ើះ តមួត ចណង់ ចណា ណគ់ ឡើ ស៊ិវ ម៉ើ ដូវ ជិត បារ ហនូក។ ");
INSERT INTO brb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ ដក់ អ៊ឺរ ដាំង គ្រែដៃ បើគ ណគ ហឹ វៀកៗ តើម ប៊ឹង បូវ វ៉ិះ ឌិវ មែ លុកស៊ិក ម៉ើ គូ ប៊ឹង ណគ។ អ៊ែ ឡើ តង៉ា លុកស៊ិក ណគ រៀន៖ «អៃ នែ អង់ង៉ាយ មែ ក្លាង ស្រ៊ុក ម៉ើ ជុ?»។ ");
INSERT INTO brb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","មែ ម៉ើ ត្រណើវ រៀន៖ «មែ អន់នឺ ម៉ើ ជុ ហៃ រៀន ហើ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក មែ អន់នឺ ម៉ើ ជុ ហៃ រៀន យ៉ាគ់ អ៊ែលីយ៉ា អ៊ែ មែ អន់នឺ អន់ណាវ ម៉ើ ជុ ហៃ រៀន ហើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ តើម ប៉ាង ឡៃ មាំង ឡើ ញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «អូ ដើ វែ ដឹះ អង់ង៉ាយ វ៉ើ ជុ អៃ នែ?»។ យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «ហៃ ហគ្រែដៃ គ្រិះ ណគ់ គ្រែដៃ ឡើ ប៉្រៃ ទឺះ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ថាន់ មែ ញ៉ង អាំ មន់ពហាយ ដើ មែ ង៉ាយ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ មែ អន់ណាវ រៀន៖ «កួន បនឹះ លំត្រ ធុក ញ៉ាក ចា ឈិ ដុ តៃ ឋាំ។ មែ ទិះ ក្រាគ់ សុនសាត យូដា បូវ ណាយ កឡា បប៊ុះ ថួយ ដើម បូវ ពង់ហៀន ចឞាប់ មន់តាក់ តណាក់ ណគ ដើម មន់កជែត ណគ ដិ។ ហាក់ តគ់ តង៉ៃ ទី ពែ ណគ លំញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ បូវ លែក រ៉ា អន់ណាវ រៀន៖ «ប៉ាគ់ មែ ង៉ាយ ម៉ើ ងុញ ដក់ តូយ អៃ តង មន់សឡាគ់ តាក់ ចាក់ មែ កឡឹ ញ៉ង មន់ឃឹត យ៉ាវ ទឹង ឝ្រងុញ មែ មន់កួយ ឡង អង់ឝ៉ាង មែ កឡឹ ត្រំ តង៉ៃៗ  អ៊ែ មន់ដូវ ដក់ តូយ អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","យ៉ាក់ ប៉ាគ់ បនឹះ ង៉ាយ ម៉ើ ខំ ដាំង កាន ញិវ ទិ ឡាង ពដិះ នែ មែ អ៊ែ មន់ត្រ គែត ប៉ាត់ ពណាត់ ឡើយ ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ឌី តាក់ កាន ញិវ មែ ញ៉ន ដើ អៃ មែ អ៊ែ មន់ញិវ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ប៉ាគ់ បនឹះ មូយ រ៉ា លំបើម អន់ដូវ ចក់ លែក ដើ ឡាង ប្រិះ នែ លំបើម មូន ដើ ណគ កឡឹ ប៉ាគ់ លន់គែត អង់ង៉ាយ លំប៊ិច ខា ដើ ណគ? ");
INSERT INTO brb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ប៉ាគ់ មែ ង៉ាយ ម៉ើ កម៉ាវ ដើ អៃ ដើម ប្រម៉ាង អៃ ប៉ាគ់ ពអ៊ែ កួន បនឹះ លន់កម៉ាវ ប៉ាគ់ទឺ ឡើយ ដើ មែ តគ់ លំប៊ឹះ ខៃ ណូវ លំលឺ សាអា កដាគ់ លំឝ៉ាល ទ្រឺញ អូងអាត តៃ ឋាំ តើម ប៊ឹង ណគ កឡឹ តើម ប៊ឹង បើគ ណគ ដើម ឞាវ គ្រែដៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន មែ អន់នឺ រ៉ា ម៉ើ គូ ប៊ឹង នែ មន់គែត អំម៉ឹះ ឋា ដើ មន់តៃ គ្រែដៃ កន់ដ្រាគ់ លំប៊ឹះ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","តើម ប៊ឹង ឡើ ពង់ហៀន មែ អ៊ែ ថាម តង៉ៃ អ្យាង គ្រែដៃ យែស៊ូ ឡើ ចន់ដ្រា ពែត្រុះ យ៉ូហាន ដើម យ៉ាកុប ឌឹក ទឹង ចន់ឌូ បក់ លន់កឡូវ អ៊ឺរ ដាំង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ទឹង ណគ ឡើ កឡូវ អ៊ឺរ ដាំង គ្រែដៃ មុះ ម៉ាត់ ណគ ឡើ វឹរ តូវ ឡើ ចាល់ អ៊ែ ដ្រន់ឌ្រូប ហណក ណគ តូវ ឡើ បក ធឺង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","អ៊ែ កអវ ប៊ិច កឡ បារ រ៉ា យ៉ាគ់ ម៉ូស៊ែ អំប្រា យ៉ាគ់ អ៊ែលីយ៉ា អំប្រា ចជែ មម៉ាង ប្រយ ប៊ឹង គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","អំប្រា ប៊ឹះ តគ់ ណគ អំប្រា ឝ៉ាល ញឹះ ឡើ ចាល់ អំប្រា ចជែ ប៊ឹង ណគ កាន ណគ លំពឡូច តគ់ លន់គែត ទឹង មួង យែរូសាឡឹម។ ");
INSERT INTO brb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","អ៊ែ ដើ ពែត្រុះ ដើម បូវ ណគ ម៉ើ ហង់ង៉ាន់ តៀក។ តគ់ ម៉ើ រ៉ៃ ម៉ើ តៃ គ្រែដៃ យែស៊ូ ឡើ ចាល់ ទ្រឹញ ទ្រឺញ ដើម ម៉ើ តៃ បនឹះ បារ រ៉ា អំប្រា ឆុង ដៀក ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","យ៉ាគ់ ម៉ូស៊ែ អំប្រា យ៉ាគ់ អ៊ែលីយ៉ា ទឹង ប៉ះ អំប្រា ជឹ ឡើយ យ៉ាគ់ ពែត្រុះ ឡើ ពហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «ណាយឃូ! ង៉ាយ ងំគូ ប៊ឹង នែ ចាគ់ ឡើយ។ ញ៉ា ញំបើម កទូប ពែ មូយ ដើ ហៃ កឡឹ មូយ ដើ យ៉ាគ់ ម៉ូស៊ែ មូយ ឡឹះ អន់ណាវ ដើ យ៉ាគ់ អ៊ែលីយ៉ា»។ យ៉ាគ់ ពែត្រុះ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ញ៉ន ឡើ ម៉ាង អន់នួរ ត្រពិត តៃ ឡើ ឃឹត តៃ ឡើ ណោះ ចាក់ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ណាគ់ ទឹង ឡើ ម៉ាង តៃ ដាន់ ឡូច យូក ឡើ អន់លឹប ប្រយ លែក ដើ មែ លឹម បលឹម អ៊ែ មែ លុកស៊ិក ម៉ើ ឌូង តៃ ឋាំ តគ់ ម៉ើ មឹត ទឹង កនុង យូក។ ");
INSERT INTO brb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","អ៊ែ ម៉ើ ដុង ប្រយ ប្រម៉ាង តើម ប៊ឹង យូក រៀន៖ «ណគ នែ ឡើយ កួន កឡ អៃ អរ៉ើះ វែ វន់ចង់ហៀង យ៉ឹ ម៉ាង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ឡូច ប្រម៉ាង ហង់អ៊ែ ម៉ើ តៃ វ៉ិះ ឌិវ គ្រែដៃ យែស៊ូ អន់ណាវ ឡើ គូ ប៊ឹង មែ។ ទឹង អ៊ែ បូវ មែ លុកស៊ិក ម៉ើ អំម៉គ់ ញឹះ តៃ ម៉ើ ពប៉ច ដើ បូវ ណគ់ កាន មែ ម៉ើ តៃ អន់ឌូ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","តគ់ ប្រណូវ គ្រែដៃ យែស៊ូ ហន់ដឹប មែ លុកស៊ិក ណគ ពែ រ៉ា ប៊ឹង ម៉ើ ទឺះ តើម ទិ ចន់ឌូ ឡើយ អ៊ែ មែ ក្លាង ស្រ៊ុក ទុត អើន ម៉ើ ដក់ យ៉ាវ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ទឹង មែ នែ ប៊ិច តង់កង់ មូយ រ៉ា ឡើ កឡូវ ឡា ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា អុះ យ៉ាគ់ ណាយឃូ អើយ! ហន់ស្រុស្រៀត កួន អៃ ដិ អុះ យ៉ាក់ កួន អៃ នែ វ៉ិះ មូយ រ៉ា ណិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ប៉ាគ់ ញឹះ អរ៉ាក់ ឡើ មឹត គូ ប៊ឹង ណគ មូយ តងៗ តូវ ឡើ ហរ៉ាវ កឡះ សសួល សសាក់ កពូះ ដាក ហាយ ឆ្រាយ ដាក ម៉ាត់។ អរ៉ាក់ នែ តូវ ឡើ កញាំ តំឞាប ទុត ខាក់ អន់ដៃ អ៊ែ ឡើ ញឺះ។ ");
INSERT INTO brb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","អឡា ឡូម ឡើយ ហឹ មែ លុកស៊ិក ហៃ ម៉ើ ពន់ឌ្រុះ ណាគ់ តៃ ម៉ើ បើម អំវីះ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «អើយ បនឹះ តណើរ ណិះៗ វ៉ើ ឌី អ៊ឺម ចាប់ មឹង គ្រែដៃ វ៉ិះ វ៉ើ អរ៉ឹក អរ៉ើវ ណាគ់ ឌុញ ឞាល់ ង៉ាយ អន់ណាវ អំបក់ ប៉ឹន ក្លើម គូ ប៊ឹង វែ?»។ អ៊ែ ឡើ ម៉ាង ដើ កឡា ប៊ិច កួន រៀន៖ «ហន់តៀត កួន ហៃ ហឹ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ទឹង កួន ណគ ឡើ ដក់ ដៀប ប៊ឹះ ហឹ គ្រែដៃ យែស៊ូ ឡើយ អ៊ែ អរ៉ាក់ ឡើ តំបង់ អន់ណាវ ណគ ញឹះ ឡើ កណាំង កាញ ហឞៀក ហឞូយ។ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ក្រាគ់ ពន់ឌ្រុះ អរ៉ាក់ អ៊ែ ឡើ បើម អន់នៀម ប្រយ អង់គ្លែត នែ។ ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឈូន អង់គ្លែត នែ ហឹ បើគ ណគ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","បនឹះ តូច បូវ តូវ ម៉ើ បើម ទុត ប្រយ ដើ ឆង៉ាត់ គ្រែដៃ ឞាល់ នែ។ ប៊ឹង បនឹះ លែក បូវ ម៉ើ ញ៉ម ដើ គ្រែដៃ ឡើ បើម កាន ឆង៉ាត់ ឞាល់ នែ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ លុកស៊ិក ណគ កឡឹ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«ហឹ វន់ចង់ហៀង ហឡាក់ៗ យ៉ឹ ប្រម៉ាង អៃ អពហាយ ដើ វែ អាំ វន់កាំ ជុ ទឹង ចនិះ វែ រៀន កួន បនឹះ នែ បូវ មន់ដក់ ឈូន ម៉ប ណគ ហឹ ទី មែ ដ្រម៉ា»។ ");
INSERT INTO brb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","បូវ មែ លុកស៊ិក ម៉ើ ណោះ អ៊ឺម តៃ ណោះ ប៉ាគ់ ង៉ាយ ឡើ ម៉ាង យ៉ាក់ កាន នែ ឡើ វៀក ញ៉ង អាំ មន់ណោះ អ៊ែ ដើ បូវ មែ លុកស៊ិក ម៉ើ ឌូង ប៉ាគ់ទឺ មន់តង៉ា ពឡាក់ ប្រម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","តង៉ៃ ហង់អ៊ិន បូវ មែ លុកស៊ិក ម៉ើ ចជែ ច្រម៉ាន ត្រឌីវ មែ រៀន៖ «មែ ង៉ាយ ឋូវ ឡើ ទិះ ជឺរ ទឹង បូវ ង៉ាយ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","គ្រែដៃ យែស៊ូ ឡើ ណោះ ចនិះ មែ អ៊ែ ឡើ តៀត អង់គ្លែត មូយ រ៉ា ពឆុង ប៊ឹង ដៀក ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ប៊្លី អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «មែ ង៉ាយ ម៉ើ ឡាប់ អង់គ្លែត អន់នែ ញ៉ន ដើ ម៉ើ ម៉ើត អៃ ណគ់ មែ អ៊ែ ម៉ើ ឡាប់ អៃ ឡើយ អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ ឡាប់ អៃ មែ អ៊ែ នែ ម៉ើ ឡាប់ កឡា ឡើ ប៉្រៃ អប៊ឹះ ទិ នែ ប៉ាគ់ទឺ។ យ៉ាក់ ណគ់ មែ ង៉ាយ ឡើ កិ ក្រូម បូវ វែ លែក រ៉ា ណគ អ៊ែ ឡើយ ឡើ ទិះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","យ៉ាគ់ យ៉ូហាន ឡើ ហាយ រៀន៖ «យ៉ាគ់ ណាយឃូ ញ៉ើ តៃ បនឹះ មូយ រ៉ា ឡើ ពន់ឌ្រុះ អរ៉ាក់ ឡើ អ៊ីង ដើ អាតណាត ម៉ាត់ ហៃ អ៊ែ ញ៉ើ កំប៊ែត ណគ ឡើ ពន់ឌ្រុះ យ៉ាក់ ណគ តៃ ឡើ ដក់ តូយ ហៃ ប៉ាគ់ ដើ ញ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ញ៉ង វ៉ើ កំប៊ែត អ៊ឺម ណគ យ៉ាក់ ណគ់ មែ ង៉ាយ តៃ ម៉ើ ព្រសាំង ដើ វែ មែ អ៊ែ បូវ វែ លែក រ៉ា ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ដៀប លំប៊ឹះ តង៉ៃ គ្រែដៃ យែស៊ូ លំត្រ ឌឹក ទឹង ហូង គ្រែ ឡើ កន់ចុង លំដក់ ហឹ មួង យែរូសាឡឹម។ ");
INSERT INTO brb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","អ៊ែ ឡើ ប៉្រៃ មែ អន់នឺ រ៉ា ដក់ អន់នួរ បក់ មន់រន់ឋាប់ កនូ ដើ ណគ អ៊ែ ម៉ើ ដក់ ប៊ឹះ ហឹ ស្រ៊ុក លមូយ ទឹង ស្រុក សាម៉ារី។ ");
INSERT INTO brb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ហាក់ មែ ទឹង ស្រ៊ុក អ៊ែ តៃ ម៉ើ ឡាប់ អ៊ឺម គ្រែដៃ យែស៊ូ យ៉ាក់ ណគ ឡើ កន់ចុង ដក់ ហឹ មួង យែរូសាឡឹម ។ ");
INSERT INTO brb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","លុកស៊ិក ណគ យ៉ាកុប អំប្រា យ៉ូហាន ទឹង អំប្រា ដុង ប៉ាគ់ អ៊ែ អ៊ែ អំប្រា តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ ណាគ់ ដូវ ឡះ ញឺ ញន់កឡូវ អ៊ុញ តើម ទិ គ្រែ លំបលុ ស្រ៊ុក មែ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ឝ្លាំង ហឹ អំប្រា ឡើ គឹះ អំប្រា (រៀន៖ «សប្រា ណោះ អ៊ឺម ឡះ ផវ យ៉ាង អង់ង៉ាយ សប្រា ណោះ ឡើ គូ ទឹង សប្រា។ ");
INSERT INTO brb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","យ៉ាក់ កួន បនឹះ ឡើ ទឺះ ទិ នែ តៃ ត្រ ឡើ ទឺះ កជែត តប៉ាត់ បនឹះ អ៊ឺម ឡើ ទឺះ ហវ៉ាត់ មែ ហវ៉ៃ»)។ ប៊្លី អ៊ែ ម៉ើ វីះ ហឹ ស្រ៊ុក លមូយ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","មែ គ្រែដៃ យែស៊ូ ទឹង ប៉ះ ម៉ើ ដក់ ប៊ិច កឡ មូយ រ៉ា ឡើ ហាយ ហឹ យែស៊ូ រៀន៖ «យ៉ាគ់ អើយ! អៃ អន់ដក់ តូយ ហៃ សំ ហៃ ហន់ដក់ ហឹ ង៉ាយ តមឹង ណាគ់ អន់តូយ ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «កស៊ិរ ម៉ើ ប៊ិច ត្រម ជែម ប៊្រែម ម៉ើ ប៊ិច កសូម អ៊ែ ណគ់ ដើ កួន បនឹះ តៃ ឡើ ប៊ិច អ៊ឺម ឞន កណី កនូ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ណគ ឡើ ម៉ាង ហឹ បនឹះ មូយ រ៉ា អន់ណាវ រៀន៖ «ដក់! ហន់ដក់ តូយ អៃ យ៉ឹ!»។ ហាក់ ណគ ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ! អឡា ហឹ ហៃ អន់ជឹ ចាំ បើគ អៃ លំគែត អន់ចះ កុប ណគ អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","គ្រែដៃ យែស៊ូ ឡើ តើវ រៀន៖ «តាក់ ដើ មែ ឈែវ ម៉ើ គែត មន់ចះ កុប ត្រឌីវ មែ ហឹ អិះ ឡើយ អ៊ែ ណគ់ ដើ ហៃ អន់ណាវ ហន់ដក់ ពហាយ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ហំមិញ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ប៊ិច បនឹះ មូយ រ៉ា អន់ណាវ ឡើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ! អៃ អន់តូយ ហៃ ប៉ាគ់ទឺ ហាក់ អឡា ហឹ ហៃ អន់ជឹ ពហាយ ដើ មែ ក្រាន អៃ អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ណគ់ បនឹះ ឡើ ឝ៉ឹន ហ្រម៉វ ឆមូ ឡើ ហវីវ ឝ្លាំង ហឹ ត្រិច ណគ អ៊ែ តៃ ឡើ ប៊ិច ឌូរ អ៊ឺម ទឹង គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ រ៉ើះ ឡឹះ លុកស៊ិក ប៉ឹះ ជិត បារ រ៉ា អន់ណាវ តើម ប៊ឹង ជិត បារ អ៊ែ ឡើ ប៉្រៃ មែ បារ រ៉ាៗ ដក់ តាម ស្រ៊ុក តាម ស្រុក អន់នួរ ណគ តាម ណគ ឡើ កន់ចុង ដក់។ ");
INSERT INTO brb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","គ្រែដៃ យែស៊ូ ឡើ ហាយ ព្រឌីវ ដើ មែ រៀន៖ «ចិះ ឡើ ឌុំ ទុត ឌឺះ ឡើយ ហាក់ មែ ម៉ើ កៀវ កើយៗ។ ប៉ាគ់ ពអ៊ែ វន់ឡា ហឹ កន់ដ្រាគ់ ណា លំដាំង ពអើន មែ គូលី មន់ដក់ កៀវ ចិះ។ ");
INSERT INTO brb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ហឹ វន់ដក់ យ៉ឹ! អៃ អប៉្រៃ វែ វន់ដក់ ហឹ អ៊ែ វន់បើម ប៉ាគ់ កួន ចៀម ម៉ើ មឹត ទឹង កឌី បូវ ច ប៊្រី។ ");
INSERT INTO brb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ញ៉ង វន់តៀត កសូប លៀន ក្រឌុង ប្រណាក់ លឺ កើប ពលិះ ពឡាក់ ដើម ញ៉ង វន់តង៉ា ឡា មែ តៃ ទ្រូង ដិ!»។ ");
INSERT INTO brb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«ប៊ឹង វន់មឹត ទឹង ហន់ណាម មែ ង៉ាយ កតាម អន់នួរៗ វន់ប្រាយ រៀន “ឡា គ្រែដៃ លំអាំ វន់គូ ឆនឹម ហន់ណាំង ទឹង ហន់ណាម ក្រាន វែ នែ”។ ");
INSERT INTO brb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ប៉ាគ់ ទឹង កនុង ហន់ណាម អ៊ែ មន់ឡាប់ វែ ដើម មន់ម៉ើត ដើ កាន ឆនឹម ហន់ណាំង អ៊ែ មែ មន់ដូវ កាន ឆនឹម ហន់ណាំង ម៉ាត់ ម៉ាត ប៉ាគ់ ប្រម៉ាង វែ។ ប៉ាគ់ តៃ ប៊ិច មែ ង៉ាយ មន់ម៉ើត កាន ឆនឹម ហន់ណាំង កាន អ៊ែ លំវឹញ ហឹ វែ កឡឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ប៉ាគ់ វន់មឹត ទឹង ហន់ណាម មែ ង៉ាយ វន់គូ ប៊ឹង អិះ ឡើយ វន់ចង់ ចា អង់ង៉ាយៗ ណគ់ មែ មន់អាំ ដើ វែ យ៉ាក់ ណគ់ មែ ម៉ើ បើម កាន តង មន់ដូវ លៀន ចនែរ។ ញ៉ង វន់វីះ អ៊ឺម តើម ប៊ឹង ហន់ណាម មូយ ដក់ គូ ហឹ ហន់ណាម លមូយ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","វន់ដក់ ហឹ ស្រ៊ុក មែ ង៉ាយ តមឹង ប៉ាគ់ មន់ឡាប់ វែ មន់អាំ ចណង់ ចណា វន់ចង់ ចា តាម មែ ម៉ើ អាំ ហឹ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","វន់បើម អន់នៀម មែ ម៉ើ ឈិ ដើម វន់ហាយ ដើ មែ រៀន “គ្រែដៃ ដៀប លំប៊ឹះ ពែក ប៉ាក់ វែ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","វន់ដក់ ហឹ ស្រ៊ុក មែ ង៉ាយ កតាម ប៉ាគ់ តៃ មន់ច្រា ឡា វែ វន់ដក់ ហាយ ពហាយ ដើ មែ បរ ទ្រូង អ៊ែ អន់ណាវ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“អើយ វែ នែ វន់ឝ្លាំង យ៉ឹ! ទុត ភុក ភុយ ឡើ ការ ប៊ឹង ឈឹង ញឺ ណាគ់ ញ៉ើ ក្រប៉ូះ វ៉ិះ ញន់ហាយ ឌិវ មូយ ដើ វែ អាំ វន់ណោះ គ្រែដៃ ដៀប លំប៊ឹះ ពែក ប៉ាក់ វែ ឡើយ!”។ ");
INSERT INTO brb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","អៃ អំពហាយ ដើ វែ រៀន តគ់ តង៉ៃ គ្រែដៃ លំតាត់ ស៊ិន ខៃ ណូវ បនឹះ ទឹង ស្រ៊ុក មែ នែ គ្រែដៃ លំពថូត កយឹក ជឺរ មួង សូដំ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«អើយ ស្រ៊ុក ខូរ៉ាស៊ីន វន់ធុក ញ៉ាក់ ឡើយ! អើយ ស៊្រុក ប៊ែតសៃដា វន់ធុក ញ៉ាក់ ប៉ាគ់ទឺ ឡើយ! ប៉ាគ់ មែ ទឹង មួង ទីរ៉ុះ ដើម មួង ស៊ីដូន មន់តៃ កាន ឆង៉ាត់ ប៉ាគ់ ដើ វែ នែ មន់ពលិះ ចនិះ មន់ត្រទ្រូប ហហក ពស្រុ ចាក់ មន់ដ្រូម ប៊ឹង ទុះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ប៉ាគ់ អ៊ែ ឡើយ ហឹ តង៉ៃ គ្រែដៃ លំតាត់ស៊ិន ដើ ស៊្រុក វែ នែ លំពថូត កយឹក ជឺរ មួង ទីរ៉ុះ ដឹប មួង ស៊ីដូន អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","អ៊ែ ដើ វែ មួង កាផារនុំ អើយ ញ៉ង វ៉ើ មឹង អ៊ឺម វន់ដូវ ឌឹក ទឹង ហូង គ្រែ ហរ៉ើម វន់គ្លីះ ទិ ឞន បនឹះ គែត»។ ");
INSERT INTO brb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ឡឹះ ដើ មែ លុកស៊ិក រៀន៖ «ណគ់ មែ ង៉ាយ ម៉ើ ចាប់ ប្រម៉ាង វែ មែ អ៊ែ ឞាល់ ម៉ើ ចាប់ ប្រម៉ាង អៃ ទឺ អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ កាះ តាក់ វែ ឞាល់ ម៉ើ កាះ តាក់ អៃ ទឺ ឡើយ អ៊ែ មែ ង៉ាយ ម៉ើ កាះ តាក់ អៃ ឞាល់ ម៉ើ កាះ តាក់ កឡា ឡើ ប៉្រៃ អៃ អប៊ឹះ ទិ នែ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","មែ លុកស៊ិក ប៉ឹះ ជិត បារ រ៉ា ម៉ើ ជឹ ញឹម ក្លើម ក្លាក តើម ប៊ឹង ម៉ើ ពហាយ កាន គ្រែដៃ ឡើយ។ អ៊ែ ម៉ើ ប៉ច ដើ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ! បក់ យ៉ាវ ហណោះ ញ៉ន ដើ អាតណាត ម៉ាត់ ហៃ អ៊ែ អរ៉ាក់ ណាគ់ ម៉ើ ជុះ ញ៉ម ដើ ញ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","គ្រែដៃ យែស៊ូ ឡើ តើវ មែ រៀន៖ «អៃ អតៃ អរ៉ាក់ សតាំង ឡើ គ្លីះ តើម ទិ គ្រែ ឡើ បើម ប៉ាគ់ លលីប។ ");
INSERT INTO brb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","អៃ អអាំ អាតណាត ដើ វែ បក់ វន់ដូវ ឆាន់ ប៊ិះ ឆាន់ កដាម អរិង ដើម លែក ដើ អាតណាត ពឺង អរ៉ាក់ សតាំង ប៉ាគ់ ពអ៊ែ តៃ ប៊ិច អង់ង៉ាយ យ៉ាវ មន់ដូវ បើម ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ញ៉ង វ៉ើ ញឹម ក្លើម អ៊ឺម ដើ អរ៉ាក់ ឡើ ជុះ ញ៉ម ដើ វែ វន់ញឹម ក្លើម ដើ គ្រែដៃ ឡើ ខៀន ជុ ម៉ាត់ វែ ទឹង ហូង គ្រែ ទិ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ទឹង អ៊ែ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ឡើ បើម អាំ គ្រែដៃ យែស៊ូ ញឹម ក្លើម រ៉គ់សំ ឆំតក ទុត ខាក់។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ឡា គ្រែដៃ បើគ អើយ! ហៃ ហកន់ដ្រាគ់ ទឹង ហូង គ្រែ ហន់ដឹប ទិ ឡាង ប្រិះ អៃ អព្រតឹះ ព្រនែ ហៃ យ៉ាក់ ហៃ ហពដៃ កាន លែក នែ ឌិវ ដើ បនឹះ តៃ ណោះ ឌូរ វ៉ារ អាំ មន់ណោះ ហាក់ ហៃ ហអំម៉គ់ ដើ មែ ហ្រឡិច ហ្រឡាង ដើម ដើ បនឹះ អ្រណោះ អ្រទីង។ ដាវ ឡើយ គ្រែដៃ បើគ អើយ! យ៉ាក់ ប្រម៉ើត ហៃ ប៉ាគ់ អ៊ែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ លុកស៊ិក ណគ រៀន៖ «គ្រែដៃ បើគ អៃ ឡើ ម៉ប អង់ង៉ាយៗ ដើ អៃ លែក អិះ។ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ហឝ៉ាវ កួន កឡ គ្រែដៃ វ៉ិះ ឌិវ គ្រែដៃ បើគ កឡឹ ឡើ ហឝ៉ាវ ដើម តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ហឝ៉ាវ គ្រែដៃ បើគ វ៉ិះ ឌិវ កួន កឡ ណគ កឡឹ ឡើ ហឝ៉ាវ ដើម ណគ់ មែ ង៉ាយ កួន កឡ គ្រែដៃ លំម៉ើត ពដៃ មែ អ៊ែ មន់ហឝ៉ាវ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","លែវ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហវីវ ហឹ លុកស៊ិក ណគ ឡើ ច្រា ចវីះ តើម ប៊ឹង មែ ឞិត ឞ៊ែត អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «បូវ វែ លែក នែ វ៉ើ ហ្រនុក ហ្រវ៉ាក ឡើយ យ៉ាក់ វ៉ើ តៃ លែក ឡើយ កាន អន់នែ! ");
INSERT INTO brb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","អៃ អង់ហាយ ពឡាក់ ដើ វែ រៀន មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម មែ សឋិច ទឹង ឡៃ មាំង ទុត អើន ម៉ើ ងុញ មន់តៃ កាន ឆង៉ាត់ ប៉ាគ់ ដើ វែ ពញ៉ង ម៉ើ តៃ អ៊ឺម មែ ម៉ើ ងុញ ប៉ាគ់ទឺ មន់ដុង ប៉ាគ់ ដើ វែ ពញ៉ង តៃ ម៉ើ ដុង អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ប៊្លី អ៊ែ ឡើ ប៊ិច ណាយឃូ ពង់ហៀន ចឞាប់ មូយ រ៉ា ឡើ ឌឹក ឆុង តង៉ា បឡង ឝ្លាំង គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ណាយឃូ អើយ! ដើ អៃ ប៉ាគ់ ង៉ាយ អំបើម អ៊ែ អន់ដូវ ញិវ ឡូច អន់សច?»។ ");
INSERT INTO brb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","គ្រែដៃ យែស៊ូ ឡើ តើវ ណគ រៀន៖ «ប៉ាគ់ ង៉ាយ ហតៃ ម៉ើ ខៀន ជុ ទឹង ពឹម ចឞាប់ គ្រែដៃ? ទឹង ហអាន ប៉ាគ់ ង៉ាយ ហដុង ដឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ណគ ឡើ ហាយ រៀន៖ «យ៉ាគ់ ម៉ូស៊ែ ឡើ ខៀន ជុ រៀន ង៉ាយ នែ ងន់ត្រ ម៉ើត ដើ គ្រែដៃ កន់ដ្រាគ់ ឡើ គ្រែដៃ ង៉ាយ ង៉ើ មឹង លែក ដើ ក្លើម ក្លាក លែក ដើ ផវ យ៉ាង លែក ដើ ពន់ដ្រិញ លែក ដើ ចនិះ ដើម ងំម៉ើត ដើ បូវ ប៊ែង ឞាល់ ង៉ើ ម៉ើត ដើ ចាក់ ង៉ាយ កឡឹ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «ត្រ ឡើយ ហម៉ាង ប៉ាគ់ ពអ៊ិន ប៉ាគ់ អ៊ែ ឡើយ ហំបើម អ៊ែ ហន់ញិវ ឡូច អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ហាក់ ដើ ណាយឃូ ពង់ហៀន ចឞាប់ ឡើ ម៉ើត ពដៃ កាន ណគ ឡើ តង៉ា អន់ឌូ អ៊ែ ឡើ ប៊ិច ខា ឡើ ត្រ ម៉ាត់ ម៉ាត អ៊ែ ឡើ រៀន៖ «មែ ង៉ាយ ដឹះ បូវ ប៊ែង អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ព្រឌីវ រៀន៖ «ប៊ិច កឡ មូយ រ៉ា ឡើ ញឺះ តើម ប៊ឹង មួង យែរូសាឡឹម ឡើ ទឺះ ទិ មួង យែរីខូ។ ណគ ឡើ ត្រ ខគ់ណាំ ដើ បូវ ចូ ម៉ើ ចក់ រ៉ាះ អំបាះ ខូ អាវ ណគ លែក ដើម ម៉ើ បឹត ណគ តូវ ឡើ មឹត ចាក់ ដៃ ស្រឹ លន់គែត ប៊្លី អ៊ែ ណគ់ មែ ម៉ើ បឹត ណគ ម៉ើ វីះ ហ្រហៀង ម៉ើ តាក់ ណគ ប៊ឹង អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","អ៊ែ ប៊ិច កឡា បប៊ុះ ថួយ មូយ រ៉ា ឡើ ដក់ តៃ ទ្រូង អន់ទឺ។ ប៊ឹង ឡើ តៃ បឹ កឡ ឡើ ប៊ឺក ឡើ វៀរ ក្លើច តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","អ៊ែ ប៊ិច បូវ លែវី មូយ រ៉ា ឡើ ប៊ឹះ តគ់ អ៊ែ។ ហំប៊្រុះ ឡើ តៃ បឹ ឡើ ប៊ឺក ឡើ វៀរ ក្លើច តាក់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ហាក់ ប៊ិច សុនសាត សាម៉ារី មូយ រ៉ា ឡើ ដក់ តៃ ទ្រូង ប៉ុះ ទឺ ឡើ តៃ ប្រយ បឹ ឡើ ប៊ឺក តូវ ឡើ បើម ស្រុស្រៀត ណគ ");
INSERT INTO brb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ឡើ ដក់ ប៊ឹះ តគ់ បឹ ឡើ ប៊ឺក ឡើ ចក់ ពុក អំប្រា តវែ ឡើ ហន់តួច ប៊ឹង បនឺក អ៊ែ ឡើ ចូម ប៊្លី អ៊ែ ឡើ ហយៀក ពឈិះ ទិ សិះ លៀ ណគ ឡើ តៀត ហឹ ហន់ណាម ចនែរ បក់ លំរន់ឋាប់ ឝ្លាំង ប្រណគ។ ");
INSERT INTO brb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ប៉ាគ់ ប្រណូវ ឡើ ចក់ លៀន បារ កាក់ ឡើ អាំ ហឹ កន់ដ្រាគ់ ហន់ណាម ឡើ ហាយ ដើ ណគ រៀន “ឡា ហន់ឝ្លាំង ណគ ដិ អុះ ប៉ាគ់ លំជឺរ លៀន អន់នែ ហំពួ ណគ ប៊ឹង អន់ជឹ វឹញ អ៊ែ អន់ធែន លៀន ហៃ”»។ ");
INSERT INTO brb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","គ្រែដៃ យែស៊ូ ឡើ តង៉ា ណាយឃូ ពង់ហៀន ចឞាប់ រៀន៖ «ប៉ាគ់ ង៉ាយ ហដុង លែក ដើ មែ ពែ រ៉ា នែ ណគ់ បឹ អង់ង៉ាយ ឡើ ត្រ អំម៉ោះ អោះ បឹ ឡើ ប៊ឺក ដើ ចូ?»។ ");
INSERT INTO brb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ណាយឃូ ឡើ ពង់ហៀន ចឞាប់ ឡើ ត្រណើវ រៀន៖ «ណគ់ បនឹះ ឡើ ណោះ ស្រុស្រៀត ប្រណគ»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «ហន់ជឹ បើម ត្រួយ ប៉ាគ់ ដើ ណគ ទឺ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ដើម លុកស៊ិក ណគ ម៉ើ ដក់ ដឌែ អ៊ែ ម៉ើ មឹត ហឹ ស្រ៊ុក លមូយ។ ប៊ិច កទ្រី មូយ រ៉ា ម៉ាត់ ណគ ម៉ាថា ឡើ ចន់ដ្រា មែ គ្រែដៃ យែស៊ូ មឹត ទឹង ហន់ណាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ណាង ម៉ាថា ឡើ ប៊ិច អោះ កទ្រី មូយ រ៉ា ម៉ាត់ ណគ ម៉ារី ឡើ ដ្រូម ចុ ឈឹង គ្រែដៃ យែស៊ូ ដើម ឡើ ចង់ហៀង ម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","អ៊ែ ដើ ណាង ម៉ាថា ឡើ វន់វ៉ាយ ពពឹត បបើម ចណង់ ចណា ដើ មែ តមួយ។ អ៊ែ ឡើ ដក់ ហាយ ដើ គ្រែដៃ យែស៊ូ លំប៉្រៃ ណាង ម៉ារី ដក់ ប៉ូរ ណគ ឡើ ម៉ាង រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ហន់ឃឹត អ៊ឺម ឡះ ដើ អៃ អោះ អៃ នែ ឡើ មឹង ដើ អៃ មូយ រ៉ា អបើម ចណង់ ចណា ដើ វែ? ហំប៉្រៃ ណគ លំដក់ ប៉ូរ អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ហាក់ គ្រែដៃ យែស៊ូ ឡើ តើវ រៀន៖ «ម៉ាថា អើយ ម៉ាថា! ប៉ិ ឡើ ត្រ ហវន់វ៉ាយ ដើ កាន អើន ឞាល់ នែ! ");
INSERT INTO brb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","វ៉ិះ ឌិវ មូយ ឡើ ប៊ិច ខា អ៊ែ ដើ ណាង ម៉ារី អោះ ហៃ ឡើ រ៉ើះ កាន ចាគ់ៗ អន់នែ ឡើយ។ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ដូវ ចក់ តើម ប៊ឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ហឹ ឞន លមូយ។ ឡើ អ៊ឺរ ដាំង លែវ ឡើយ អ៊ែ ប៊ិច លុកស៊ិក មូយ រ៉ា ឡើ ដក់ ឡា ហឹ ណគ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ! ញ៉ើ ឡា ហឹ ហៃ ហំពង់ហៀន ញ៉ា អាំ ញន់ណោះ អ៊ឺរ ដាំង គ្រែដៃ ប៉ាគ់ ដើ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ពង់ហៀន លុកស៊ិក ណគ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប៊ឹង វែ វន់អ៊ឺរ ដាំង គ្រែដៃ ប៉ាគ់ នែ វន់ម៉ាង៖ “ឡា គ្រែដៃ បើគ អើយ! ញ៉ើ ឡា អាំ បនឹះ លែក រ៉ា ទិ ឡាង ប្រិះ នែ មន់អៀល បឹះ ម៉ាត់ ហៃ ញ៉ើ ឡា ហំបើម សឋិច ហំពែក ប៉ាក់ ញ៉ា លែក រ៉ា ទិ ឡាង ប្រិះ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ឡា ហង់អាំ ចណង់ ចណា ណគ់ ញ៉ា ញ៉ើ តងកាន ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ឡា គ្រែដៃ បើគ អើយ! ហន់តាក់ ឞាប ដើ ញ៉ា ប៉ាគ់ ញ៉ា ញ៉ើ តាក់ ដើ មែ ម៉ើ បើម អន់យូច ដើ ញ៉ា ទឺ ឡើយ។ ឡា ញ៉ង ហអាំ អ៊ឺម ញ៉ា ញំគ្លីះ ទឹង កាន ពលូង”»។ ");
INSERT INTO brb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ ដើ មែ រៀន៖ «ទឹង បូវ វែ ប៉ាគ់ បឹ មូយ រ៉ា ឡើ ប៊ិច ប្រម៉ើត មូយ អ៊ែ តគ់ ទឹង មាំង វន់ដក់ ឡា ហឹ ណគ រៀន៖ “ឡា ប៉ អើយ អដក់ តង់ ណំពាំង ហឹ ហៃ ពែ អំប៉ម អន់ដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","យ៉ាក់ កឡើ អៃ ឡើ ដក់ ឆើ អៃ ហន់ដើម ឡើ ប៊ឹះ តៃ អប៊ិច អង់ង៉ាយ អ៊ឺម អំបយ៉ង់ បយ៉ា ណគ”។ ");
INSERT INTO brb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","អ៊ែ បឹ ទឹង ហន់ណាម ឡើ ត្រណើវ រៀន៖ “ញ៉ង ហពខើក អ៊ឺម អៃ យ៉ាក់ កម៉ង អៃ អក្លៀង ឡើយ កួន ចូវ អៃ ម៉ើ ហង់ង៉ាន់ លែក ឡើយ ដូវ អ៊ឺម អៃ អន់ឌឹក ចក់ ណំពាំង ដើ ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","អៃ អង់ហាយ ដើ វែ រៀន កន់ដ្រាគ់ ហន់ណាម អ៊ែ អាត លំឌឹក អាំ ម៉ាត់ ម៉ាត ណំពាំង ដើម អង់ង៉ាយៗ ណគ់ ប្រម៉ើត ណគ ឡើ តងកាន។ ណគ លំឌឹក ចក់ អ៊ែ តៃ ត្រ ញ៉ន ដើ ឡើ ម៉ើត ប្រណគ អ៊ឺម ញ៉ន ដើ ប្រណគ ឡើ ពខើក ណគ ញឹះ តៃ ព្រឹង»។ ");
INSERT INTO brb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«អ៊ែ ណគ់ ដើ អៃ អន់ណាវ អង់ហាយ ដើ វែ រៀន វន់ឡា ហឹ គ្រែដៃ អ៊ែ គ្រែដៃ លំអាំ ដើ វែ វន់ដាំង អ៊ែ វន់តៃ វន់ឝឝ៉ោះ កម៉ង អ៊ែ គ្រែដៃ លំប៉ើក ឡើយ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","យ៉ាក់ ណគ់ មែ ង៉ាយ ម៉ើ ឡា មែ អ៊ែ មន់ដូវ មែ ង៉ាយ ម៉ើ ដាំង មែ អ៊ែ មន់តៃ ដើម គ្រែដៃ លំប៉ើក កម៉ង ណគ់ ដើ មែ ម៉ើ ឝឝ៉ោះ។ ");
INSERT INTO brb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ទឹង វែ លែក រ៉ា ប៉ាគ់ កួន លំឡា ទ្រឺ ប៊ិច អ៊ឺម ញឹះ បើគ ណគ លំអាំ កយែប ដើ ណគ លន់ចា។ ");
INSERT INTO brb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","អ៊ែ ប៉ាគ់ កួន លំឡា កលែ អៀរ ប៊ិច អ៊ឺម ញឹះ បើគ ណគ លំអាំ កដាម អរិង ដើ កួន លន់ចា។ ");
INSERT INTO brb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ទុត វែ វ៉ើ បនឹះ តៃ ចាគ់ កតាម ណាគ់ វ៉ើ ណោះ អាំ រ៉ាះ ចាគ់ៗ ដើ កួន វែ ហ៊ែង ហាយ ដើ គ្រែដៃ បើគ ឡើ គូ ទឹង ហូង គ្រែ ទិ ហម អ៊ែ លំអាំ ផវ យ៉ាង ចាគ់ លួង ណគ ណគ់ ដើ មែ ង៉ាយ ម៉ើ ឡា ទឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ ពន់ឌ្រុះ អរ៉ាក់ ឡើ បើម កំប្ល បនឹះ មូយ រ៉ា។ តគ់ អរ៉ាក់ ឡើ វីះ តើម ប៊ឹង បឹ កំប្ល ក្លើច ឡើយ អ៊ែ ឡើ ណោះ ម៉ាង ប្រយ មែ ក្លាង ស្រ៊ុក ម៉ើ គូ ទឹង អ៊ែ តូវ ម៉ើ ញ៉ម ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ហាក់ ប៊ិច មែ អន់នឺ រ៉ា ម៉ើ ម៉ាង រៀន៖ «ណគ នែ ឡើ ដូវ ពន់ឌ្រុះ អរ៉ាក់ ប៉ាគ់ នែ ញ៉ន ដើ ប៊ែលស៊ែប៊ូល ណាយ អរ៉ាក់ ឡើ អាំ អាតណាត ដើ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ប៊ិច មែ អន់នឺ អន់ណាវ ម៉ើ ងុញ បឡង ឝ្លាំង គ្រែដៃ យែស៊ូ អ៊ែ ម៉ើ ប៉្រៃ ណគ លំពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ តើម ទិ ហូង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ហាក់ គ្រែដៃ យែស៊ូ ឡើ ណោះ ខនឹត មែ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «ពធែត មែ ង៉ាយ កតាម ប៉ាគ់ទឺ ឡើយ ប៉ាគ់ ប៉ាសាសុន ម៉ើ ព្រឆាន់ ត្រឌីវ បូវ ពធែត ហង់អ៊ែ លំប៉ាត់ ពណាត់ លែក អ៊ែ លែក ដើ ហន់ណាម ក្រាន ណគ់ មែ ម៉ើ ព្រសិញ ត្រឌីវ មែ លំប៉ាត់ ពណាត់ លែក ប៉ាគ់ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ណគ់ ប៉ាគ់ ខនឹត វែ អន់ឌូ អ៊ែ ប៉ាគ់ វ៉ើ រៀន អៃ អពន់ឌ្រុះ អរ៉ាក់ ញ៉ន ដើ អាតណាត ប៊ែលស៊ែប៊ូល អ៊ែ ឡើ បើម ប៉ាគ់ អរ៉ាក់ ម៉ើ ព្រឆាន់ ត្រឌីវ បូវ មែ កឡឹ ឡើយ ប៉ាគ់ ពអ៊ែ អរ៉ាក់ សតាំង លំប៊ិច យ៉ាវ អាតណាត ពឺង អរ៉ាក់ យ៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ប៉ាគ់ អៃ អពន់ឌ្រុះ អរ៉ាក់ ដើ អាតណាត ប៊ែលស៊ែប៊ូល ម៉ាត់ ម៉ាត ប៉ាគ់ ពអ៊ែ លុកស៊ិក វែ ដើ អាតណាត មែ ង៉ាយ អន់ណាវ ម៉ើ អ៊ីង ម៉ើ ពន់ឌ្រុះ អរ៉ាក? ប៉ាគ់ ពអ៊ែ លុកស៊ិក វែ មន់ពដៃ រៀន ខនឹត វែ យូច ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ហាក់ ប៉ាគ់ អៃ អពន់ឌ្រុះ អរ៉ាក់ អមឹង ដើ អាតណាត ឆង៉ាត់ គ្រែដៃ ប៉ាគ់ ពអ៊ែ នែ គ្រែដៃ ឡើ ប៊ឹះ ពែក ប៉ាក់ វែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«អរ៉ាក់ សតាំង ឡើ បើម ប៉ាគ់ បនឹះ ប្រិញ មូយ រ៉ា ឡើ ប៊ិច ហក តាវ ឡើ ញ៉ាម ហន់ណាម ណគ កឡឹ ប៉ាគ់ អ៊ែ រ៉ាះ អំបាះ ទឹង ហន់ណាម ណគ ណាគ់ លំណាគ់ ដឌែ។ ");
INSERT INTO brb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ហាក់ ប៉ាគ់ ប៊ិច បនឹះ មូយ រ៉ា ឡើ ប្រិញ ថាំង ជឺរ ណគ លំប៊ឹះ បើម ដើ ណគ អន់ណាវ លន់ចក់ តាវ ហក ប្រណគ ណគ់ ប្រណគ ឡើ មឹង អ៊ែ ដើម លន់ចក់ ដ្រូក សាក រ៉ាះ អំបាះ ដិ។ ប៊្លី អ៊ែ លំព្រណាក ដើ បូវ ប៊ែង។ ");
INSERT INTO brb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","មែ ង៉ាយ ម៉ើ គូ អ៊ឺម តៃ អៃ មែ អ៊ែ ម៉ើ ព្រឆាន់ ដើ អៃ ឡើយ មែ ង៉ាយ តៃ ម៉ើ ឌី តមួត បនឹះ មន់តូយ អៃ មែ អ៊ែ ម៉ើ បើម អាំ បនឹះ មន់ប៉្រាះ ព្រាំង ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ រៀន៖ «ប៊ឹង អរ៉ាក់ ឡើ ញឺះ តើម ប៊ឹង បនឹះ មូយ រ៉ា ណគ់ ឡើ ខើយ គូ ឡើ បើម ប៉ាគ់ ហន់ណាម ណគ កឡឹ ប៊្លី អ៊ែ ឡើ ដក់ ដាំង កនូ ហឹ គែង អន់ណាវ ឡើ ក្លង ឡាត់ ត្រិញ ក្លៀវៗ។ ហឹ អ៊ែ ឡើ ដាំង កនូ ប៊ិច អ៊ឺម អ៊ែ ឡើ ម៉ាង រៀន “អន់ជឹ វឹញ អន់ណាវ អៃ អ៊ិន ហឹ ហន់ណាម អវីះ អន់ឌូ អៀះ!”។ ");
INSERT INTO brb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ហំប៊្រុះ ឡើ ប៊ឹះ តគ់ ហន់ណាម អ៊ែ ឡើ តៃ ម៉ើ ពប៉ូះ សសា រន់ឋាប់ ពរ៉គ់ ពសំ ");
INSERT INTO brb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","អ៊ែ ឡើ ដក់ ច្រា អរ៉ាក់ ប៉ឹះ រ៉ា អន់ណាវ ម៉ាត់តូវ អរាំងៗ ជឺរ ណគ ម៉ើ ជឹ មឹត គូ ហឹ បនឹះ អន់ទឺ ឡឹះ បើម អាំ បនឹះ អ៊ែ លំធុក ញ៉ាក ជឺរ ពន់ឋើម អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","គ្រែដៃ យែស៊ូ ទឹង ណាគ់ ប៉ះ ឡើ ពហាយ ប៊ិច កទ្រី មូយ រ៉ា ទឹង បូវ មែ ក្លាង ស្រ៊ុក ឡើ ម៉ាង ថាំងៗ ហឹ ណគ រៀន៖ «ណគ់ កទ្រី ឡើ កឡា ពឝ៉ើត ដើម ឡើ តពុ ហៃ ណគ អ៊ែ ឡើ ហ្រនុក ហ្រវ៉ាក ម៉ាត់ ម៉ាត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ត្រ ឡើយ! ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ចង់ហៀង ប្រម៉ាង គ្រែដៃ ដើម ម៉ើ បើម ត្រួយ ប្រយ មែ អ៊ែ ឡើយ មន់ហ្រនុក ហ្រវ៉ាក ជឺរ ណគ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ទឹង អ៊ែ ប៊ិច មែ ក្លាង ស្រ៊ុក ម៉ើ តមួត ចាំ អើន ប៊ឹង គ្រែដៃ យែស៊ូ។ អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «បនឹះ ប៉ាង ណិះៗ ញឹះ តៃ ម៉ើ ចាគ់ ឡាំងៗ ម៉ើ ងុញ តៃ កាន ហឝ៉ាវ ឆង៉ាត់ ហាក់ គ្រែដៃ លំពដៃ អ៊ឺម កាន ឆង៉ាត់ គែង តើម ប៊ឹង កាន ហឝ៉ាវ ឆង៉ាត់ ឡើ បើម ប៊ឹង យ៉ាគ់ យ៉ូណះ។ ");
INSERT INTO brb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ប៉ាគ់ ង៉ាយ មែ ហឹ មួង នីនីវែ ម៉ើ តៃ កាន ហឝ៉ាវ ឆង៉ាត់ ដើ យ៉ាគ់ យ៉ូណះ កួន បនឹះ អន់នែ ប៉ាគ់ អ៊ែ ទឺ ឡើយ លំពដៃ កាន ហឝ៉ាវ ឆង៉ាត់ ដើ បនឹះ តណើរ ណិះៗ។ ");
INSERT INTO brb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ទឹង ប៉ាង ឡៃ មាំង ប៊ិច សឋិច កទ្រី មូយ រ៉ា ឡើ ពែក ប៉ាក់ ប៊្រី ដាក ស៊ែបា ណាង ហង់អ៊ិន ឡើ ដក់ ចង់ហៀង ប្រម៉ាង ហ្រឡិច ហ្រឡាង សឋិច សាឡូម៉ូន តើម ប៊ឹង ចង៉ាយៗ។ ណិះៗ នែ ទឹង ប៉ាង អន់នែ ឡើ ប៊ិច បនឹះ មូយ រ៉ា ឡើ ទិះ ជឺរ សឋិច សាឡូម៉ូន អន់ណាវ ហាក់ ដើ បនឹះ តណើរ ណិះៗ ម៉ើ ឌី អ៊ឺម ចង់ហៀង ប្រម៉ាង ណគ។ ប៉ាគ់ ពអ៊ែ ឡើយ តគ់ គ្រែដៃ លំតាត់ ស៊ិន ដើ បនឹះ ខៃ ណូវ អ៊ែ ដើ សឋិច កទ្រី ហង់អ៊ិន លំឌឹក ឆុង អរែង ប៉ាគ់ទឺ ដើ បនឹះ តណើរ ណិះៗ ហន់ដឹប លំពថូត មែ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ហឹ តង៉ៃ គ្រែដៃ លំតាត់ ស៊ិន ដើ បនឹះ ទិ ឡាង ពដិះ នែ បូវ មែ ទឹង មួង នីនីវែ មន់ឌឹក ឆុង អរែង ដើ បនឹះ តណើរ ណិះៗ អ៊ែ មន់ពថូត មែ យ៉ាក់ ទឹង ប៉ាង ពន់ឋើម មែ មួង នីនីវែ ម៉ើ ពលិះ ចនិះ តគ់ ម៉ើ ដុង ប្រម៉ាង យ៉ាគ់ យ៉ូណះ ឡើ ពហាយ។ អ៊ែ ទឹង ង៉ាយ នែ ប៊ិច មូយ រ៉ា ឡើ ទិះ ជឺរ យ៉ូណះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ចុះ តកៀង មន់ជុ កដក លឺ មន់ទ្រូប ដើ វ៉ាន់។ ប៉ាគ់ ញឹះ ម៉ើ ចុះ ឡើយ តកៀង ម៉ើ ជុ ទិ ឈ្រុ ឈ្រូង អ៊ែ លំឝ៉ាល ដើ មែ មន់មឹត ហឹ ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ម៉ាត់ វែ ឡើ បើម ប៉ាគ់ តកៀង ទឹង ចាក់ ដៃ ប៉ាគ់ ម៉ាត់ វែ ឡើ ចាគ់ នៀម អ៊ែ ចាក់ វែ ឡើ ឝ៉ាល ប៉ាគ់ទឺ ហាក់ ប៉ាគ់ ម៉ាត់ វែ តៃ ឡើ ចាគ់ នៀម អ៊ែ ចាក់ ដៃ វែ លំហ្រង៉ូម ប៊្រែ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ប៉ាគ់ ពអ៊ែ វែ វន់លវាំង យ៉ឹ ញ៉ង អាំ កាន ឝ៉ាល ទឹង ចាក់ វែ លំហ្រង៉ូម អន់ណាវ ");
INSERT INTO brb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ប៉ាគ់ ចាក់ ដៃ វែ ឡើ ឝ៉ាល ញឹះ តៃ ប៊ិច ហ្រង៉ូម ប្លះ ង៉ាយ អ៊ែ លែក ដើ ចាក់ ដៃ វែ លំឝ៉ាល ធឺង ឡើ បើម ប៉ាគ់ តកៀង ឡើ ឝ៉ាល ដើ វែ ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","តគ់ គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ មែ លែវ ឡើយ ប៊ិច កឡ មូយ រ៉ា ទឹង បូវ មែ ផារីស៊ី ឡើ ចន់ដ្រា គ្រែដៃ យែស៊ូ ដក់ ចង់ ចា ហឹ ហន់ណាម ណគ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ដក់ ចង់ ប្រយ ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","បឹ ផារីស៊ី ឡើ ឃឹត អង់ឃឹត ទឹង ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ ចង់ តៃ ឡើ ដឌូច ទី ។ ");
INSERT INTO brb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ ណគ រៀន៖ «បូវ វែ ផារីស៊ី អើយ! វែ វ៉ើ ហដា ចក វ៉ិះ តៃ ដៀក ដើម តង់ឝ៉ាន វ៉ិះ តៃ កណង ហឹ កនុង ចនិះ វែ ឡើ ប៊ិង វ៉ិះ ឌិវ កាន ពនឺង ពឋម ដើម ខនឹត តៃ ចាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","អើយ បនឹះ តៃ ណោះ ឌូរ វ៉ារ! គ្រែដៃ ឡើ ពឝ៉ើត វ៉ិះ ឌិវ តៃ ពឺង ឞិ? ណគ់ ទិ កនុង ឡើ ពឝ៉ើត ប៉ាគ់ទឺ ហវ៉ៃ! ");
INSERT INTO brb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ហឹ វន់ចក់ អង់ង៉ាយ ណគ់ វ៉ើ ប៊ិច វន់អាំ ដើ មែ ធុក ញ៉ាក អ៊ែ វន់ចាគ់ ស៊ីត ម៉ាត់ ម៉ាត តៃ កនុង ដើម តៃ ពឺង ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«បូវ វែ ផារីស៊ី អើយ វែ វន់ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ម៉ប កសុំ ក្រៀម កដៀម ប្លង់ ដើម បិច វឺៗ វ៉ះៗ ត្រំ ហំឞ្លិច កនុង ជិត វ៉ើ អាំ មូយ ដើ គ្រែដៃ ហាក់ វ៉ើ វឺញ បើម កាន ចាគ់ ទឹង ត្រ ដើ បនឹះ ដើម តៃ វ៉ើ ម៉ើត ដើ គ្រែដៃ ដិ។ ហឹ វន់បើម កាន ចាគ់ ទឹង ត្រ ដើ បនឹះ ដើម វន់ម៉ើត ដើ គ្រែដៃ ដិ។ អ៊ែ ណគ់ ដើ កាន ម៉ប អាំ ដើ គ្រែដៃ ញ៉ង វ៉ើ វឺញ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","បូវ វែ ផារីស៊ី អើយ វែ វន់ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ឌី ដ្រូម ពយ៉ូក ចាក់ ទឹង រ៉ូង ពស៊ុំ ប៊ឹង ដ្រុនដ្រូម មែ ទិះ ក្រាគ់ ដើម វ៉ើ ម៉ើត មន់ហំបះ វែ ប្លះ តឡាត ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","វែ វន់ធុក ញ៉ាក ឡើយ យ៉ាក់ វែ នែ វ៉ើ បើម ប៉ាគ់ លុង កយ៉ក់ ម៉ើ ជុ អ៊ឺម ឡង ង៉ូ អ៊ែ ម៉ើ ឆាន់ៗ ប៉ាគ់ ម៉ើត យ៉ាក់ ម៉ើ ណោះ អ៊ឺម លុង កយ៉ក់»។ ");
INSERT INTO brb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","អ៊ែ ប៊ិច កឡា ពង់ហៀន ចឞាប់ មូយ រ៉ា ឡើ ម៉ាង ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ណាយឃូ ហៃ ហម៉ាង ប៉ាគ់ អ៊ិន ឡើ បើម ប៉ាគ់ ហផម៉ាត ផម៉ា ញ៉ា ដិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ណគ រៀន៖ «បូវ វែ វ៉ើ ពង់ហៀន ចឞាប់ អើយ វន់ធុក ញ៉ាក ប៉ាគ់ទឺ ឡើយ យ៉ាក់ វែ កឡឹ វ៉ើ ពឝ៉ើត ចឞាប់ ពធុក បនឹះ មិៗ អ៊ែ ដើ វែ កឡឹ វ៉ើ ឌី អ៊ឺម ប៉ូរ មែ ហម ឌិត ត្រពួច ណាគ់ តៃ វ៉ើ ឌី ប៉ូរ ឡាំងៗ។ ");
INSERT INTO brb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","វែ វន់ធុក ញ៉ាក ឡើយ យ៉ាក់ ម៉ិ យ៉ាគ់ វែ ម៉ើ កជែត មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ណគ់ ដើ វែ ណិះៗ នែ វ៉ើ កឡា បើម ហន់ណាម ចាគ់ៗ ដើ លុង កយ៉ក់ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","វែ វ៉ើ បើម ប៉ាគ់ នែ ឡើ បើម ប៉ាគ់ វ៉ើ ពដៃ រៀន វែ កឡឹ វ៉ើ ឈែវ អរែង ប៊ឹង ម៉ិ យ៉ាគ់ វែ ម៉ើ កជែត មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡៃ មាំង ញឹះ តៃ យូច ប្លះ វែ ណគ់ ដើ មែ ម៉ើ កឡា កជែត អ៊ែ ណគ់ ដើ វែ អន់ណាវ វ៉ើ កឡា បើម ហន់ណាម ចាគ់ៗ ពឺង លុង កយ៉ក់ ណគ់ ម៉ិ យ៉ាគ់ វែ ម៉ើ កជែត។ ");
INSERT INTO brb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ប៉ាគ់ អ៊ែ ឡើយ គ្រែដៃ ឡើ ហ្រឡិច ហ្រឡាង ត្រំ ហំឞ្លិច ឡើ ម៉ាង រៀន “អៃ អំប៉្រៃ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម បូវ ពចាំ កាន ដើ ណគ ទុត អើន ម៉ើ ដក់ ដាំង ម៉ិ យ៉ាគ់ វែ ហាក់ ម៉ើ កជែត អន់នឺ ម៉ើ តំឞាប អន់នឺ”។ ");
INSERT INTO brb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ប៉ាគ់ ពអ៊ែ តគ់ ប៉ាង វែ ណិះៗ នែ គ្រែដៃ លំតុ ហឹ វែ លែក ដើ ផាម កឡា ឈូន ប្រម៉ាង គ្រែដៃ ណគ់ មែ ម៉ិ យ៉ាគ់ វែ ម៉ើ កជែត ណាប់ តើម ប៊ឹង កណើត ពដិះ គ្រែ ពន់ឋើម ");
INSERT INTO brb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ណាប់ តើម ប៊ឹង ផាម យ៉ាគ់ អ៊ែបិល ឆា ដើ ប៊ឹះ ផាម យ៉ាគ់ សាការ៉ៃ ណគ់ មែ ម៉ើ កជែត ពន់ឋើម ហឹ បយឺង ប្លះ កឌីៗ ហ៊ីប បប៊ុះ ថួយ ដើម រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ លែក រ៉ា រៀន បនឹះ ទឹង ហ្រណើង ណគ់ អន់នែ មន់ត្រ ថូត ពតាង ញ៉ន លែក ដើ កាន ក្រជែត ម៉ិ យ៉ាក់ វែ អន់នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","បូវ វែ វ៉ើ ពង់ហៀន ចឞាប់ អើយ វន់ធុក ញ៉ាក ឡើយ យ៉ាក់ វ៉ើ ពាំង កម៉ង ចិះ កជែ ដើ បនឹះ ម៉ើ ងុញ ណោះ កាន គ្រែដៃ អ៊ែ ដើ វែ អន់ណាវ វ៉ើ មឹត អ៊ឺម ដើម វ៉ើ កន់ឌឹង ដ្រាគ់ ដើ មែ ម៉ើ ងុញ មឹត»។ ");
INSERT INTO brb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","តគ់ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង ហន់ណាម អ៊ែ បូវ មែ ពង់ហៀន ចឞាប់ ដើម បូវ មែ ផារីស៊ី ញឹះ តៃ ម៉ើ ដារ់ ទុត ខាក់ ប្រយ ដើ គ្រែដៃ យែស៊ូ ដើម ម៉ើ តង៉ា ណគ ញឹះ ឆឆិក លឡិក ណគ់ កាន អង់គែងៗ ទុត អើន ");
INSERT INTO brb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ម៉ើ ទែង ពខ បក់ ណគ លំម៉ាង យូច។ ");
INSERT INTO brb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ទឹង អ៊ែ ប៊ិច មែ ក្លាង ស្រ៊ុក ប៉ិន មឺន រ៉ា ម៉ើ តមួត តូវ ម៉ើ អន់ដៀត ញឹះ ម៉ើ ឆ្រណាន់ ឈឹង ត្រឌីវ មែ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ អន់នួរ ដើ លុកស៊ិក ណគ រៀន៖ «ប៊ូះ មែ ផារីស៊ី ញ៉ង វ៉ើ រួយ អឹ យ៉ឹ  បូវ មែ អ៊ែ ម៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង ញ៉ង វ៉ើ បើម អ៊ឺម ប៉ាគ់ ដើ មែ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","គ្រែដៃ លំពហាយ ពដៃ លែក ដើ កាន បនឹះ ម៉ើ កដក ដើម លំពហាយ ពណោះ លែក ដើ កាន បនឹះ ម៉ើ អំម៉គ់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ប៉ាគ់ ពអ៊ែ កាន អង់ង៉ាយៗ ណគ់ វែ វ៉ើ ចជែ ទឹង ហ្រង៉ូមៗ តគ់ លំត្រប៉ៃ លំលឺ ដើ បនឹះ អ៊ែ ណគ់ កាន អង់ង៉ាយ វែ វ៉ើ ព្រជែះ ប៊ឹង ត្រពិត ទឹង កនុង ហន់ណាម មែ មន់កឡះ ហូ ដើ បូវ តើម ទិ បូយ ហន់ណាម អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«អើយ ណគ់ បូវ អៃ អពន់តក អើយ អំពហាយ ដើ វែ រៀន ញ៉ង វ៉ើ ឌូង អ៊ឺម ណគ់ មែ ម៉ើ ណោះ កជែត វ៉ិះ ឌិវ ចាក់ ដៃ វែ ប៊្លី អ៊ែ តៃ មន់ដូវ បើម ប៉ាគ់ ង៉ាយ យ៉ាវ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","អៃ អំពហាយ ដើ វែ អាំ វន់ណោះ អន់ណាវ រៀន ដើ មែ ង៉ាយ វន់ត្រ ឌូង ដើ គ្រែដៃ វន់ត្រ ឌូង យ៉ាក់ ដើ ណគ ប៊្លី ឡើ ពតាត់ សើម វែ ឡើយ ឡើ ប៊ិច អាតណាត ពៀវ វែ ទិ ត្របាំង អ៊ុញ ឡឹះ អន់ណាវ។ ដាវ ឡើយ វ៉ិះ ឌិវ ដើ គ្រែដៃ មូយ រ៉ា នែ ឡើយ វែ លែក រ៉ា វន់ត្រ ឌូង! ");
INSERT INTO brb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","វ៉ើ ណោះ ប៉ាគ់ទឺ រៀន ម៉ើ ខើយ ហំពួត ជែម ប្រាល សើង អំប៉ម ច្រណាប់ បារ កាក់  សំ តៃ ឡើ ច្រណាប់ កតាម ជែម មូយ អំប៉ម គ្រែដៃ ណាគ់ តៃ ឡើ វឺញ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","អ៊ែ ដើ វែ ញ៉ង វ៉ើ ឌូង អ៊ឺម យ៉ាក់ វ៉ើ ច្រណាប់ ជឺរ ជែម ប្រាល ប៉ិន បូវ សំយ៉ះ សក់ ទឹង ទូះ វែ គ្រែដៃ ឡើ កាវ ណាគ់ លែក»។ ");
INSERT INTO brb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«អៃ អង់ហាយ ដើ វែ រៀន មែ ង៉ាយ ម៉ើ ហាន ហាយ ចាក់ ប៊ឹង ងឺរ បូវ ម៉ើ ឡាប់ ចាប់ អៃ កួន បនឹះ លំឡាប់ ឡង ហឝ៉ាវ មែ អ៊ែ ប៊ឹង ងឺរ ឞាវ គ្រែដៃ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ កាះ តាក់ អៃ ប៊ឹង ងឺរ បូវ មែ អ៊ែ អៃ អង់កាះ តាក់ ប៉ាគ់ទឺ មែ ប៊ឹង ងឺរ ឞាវ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","មែ ង៉ាយ ម៉ើ ម៉ាង តៃ ញឹម ដើ កួន បនឹះ មែ អ៊ែ គ្រែដៃ លំតាក់ អ្រយូច មែ ដូវ ហាក់ ប៉ាគ់ មែ ង៉ាយ ម៉ើ ផម៉ាត ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ មែ អ៊ែ គ្រែដៃ តៃ លំតាក់ អ៊ឺម អ្រយូច មែ។ ");
INSERT INTO brb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ប៊ឹង បនឹះ មន់រ៉ាប់ វែ តៀត តាត់ ស៊ិន វែ ហឹ រ៉ូង ពស៊ុំ លឺ ហឹ ងឺរ មែ ទិះ ក្រាគ់ ដើម មែ ម៉ើ ប៊ិច អាតណាត ញ៉ង វ៉ើ តង៉ូក អន់នួរ អ៊ឺម ដើ កាន ត្រណើវ លឺ វន់ម៉ាង ប៉ាគ់ ង៉ាយ ដើ មែ ទឹង មន់ពន់ដូះ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","យ៉ាក់ ប៊ឹង វែ វន់ត្រណើវ អ៊ែ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ លំពហាយ ដើ វែ ណគ់ កាន អង់ង៉ាយ វែ វន់ត្រ ម៉ាង»។ ");
INSERT INTO brb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ទឹង មែ ក្លាង ស៊្រុក ប៊ិច កឡ មូយ រ៉ា ឡើ ប៉្រៃ គ្រែដៃ យែស៊ូ ពហាយ ហឹ អ៊ូគ ណគ រៀន៖ «អើយ យ៉ាគ់ ណាយឃូ ឡា អុះ! ហំពហាយ ដើ អ៊ូគ អៃ លំព្រណាក មូន មាំង ដើ អៃ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","គ្រែដៃ យែស៊ូ ឡើ តើវ បឹ ហង់អ៊ែ រៀន៖ «មែ ង៉ាយ ហដុង ម៉ើ ប៉្រៃ អៃ អំបើម តង់កង់ យ៉ាគ់វឺ ព្រណាក មូន មាំង ដើ សប្រា?»។ ");
INSERT INTO brb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ មែ លែក រ៉ា រៀន៖ «វន់លវាំង យ៉ឹ ញ៉ង វ៉ើ ងុញ ប្រនិច ពឋម ដឌែ យ៉ាក់ បនឹះ ម៉ើ ញិវ តៃ ត្រ ដើ រ៉ាះ ស៊ិវ សាគ់ ណាគ់ គ្លឺយ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","គ្រែដៃ យែស៊ូ ឡើ ព្រឌីវ ដើ មែ រៀន៖ «ប៊ិច កឡ មូយ រ៉ា ឡើ ប៊ិច បាក់ តៃ ឋាំ ឡើ ដូវ ឡាប់ ផុន តើម ប៊ឹង មឺរ ណគ ទុត អើន ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ណគ ឡើ ឃឹត អង់ឃឹត រៀន “ប៉ាគ់ ង៉ាយ ឋូវ អំបើម ប៊ឹង ង៉ាយ អន់ណាវ អន់ជុ ចិះ ភែ អៃ នែ យ៉ាក់ តូវ ឡើ ស៊ិវ សាគ់ ណាគ់ គ្លឺយ ឞាល់ នែ?”។ ");
INSERT INTO brb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ប៊្លី អ៊ែ ណគ ឡើ ឃឹត ឡឹះ រៀន “អូ ប៉ាគ់ នែ អន់ណាវ អំបើម អន់សោះ តាក់ នុក ក្រាគ់ អៃ អន់នែ អ៊ែ អំបើម ហន់ដើម អាំ ទិះ ជឺរ នែ អន់ណាវ អំបើម ចឹះ ឡើយ អ៊ែ អំអន់ឈូន ជុ តមួត ចិះ អៃ ដើម រ៉ាះ អំបាះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ប៊្លី អ៊ែ អំម៉ាង ដើ ចាក់ អៃ កឡឹ រៀន ឞាល់ នែ អុះ អប៊ិច ចិះ ភែ រ៉ាះ អំបាះ ទុត អើន ឞាល់ នែ អតមួត ជុ ហឹ ងឺរ ឌុញ កម៉ ឡើយ អន់យួរ អង់គូ មិៗ អន់ដៃ អៃ អ៊ិន វ៉ិះ ឌិវ អង់ឃឹត ញញែត ចចង់ រ៉គ់ សំ ឆំតក ហំមិញ អៃ អ៊ិន អៀះ”។ ");
INSERT INTO brb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ហាក់ គ្រែដៃ ឡើ ម៉ាង ហឹ បឹ ហង់អ៊ែ រៀន “បនឹះ តៃ ណោះ ឌូរ វ៉ារ អើយ មាំង នែ អៃ អន់ហវ៉ើច ឡើយ ផវ យ៉ាង ហៃ ប៉ាគ់ ពអ៊ែ រ៉ាះ អំបាះ ហៃ ហរន់ឋាប់ ជុ រ៉ាក់ ដើ ចាក់ ហៃ អ៊ែ ណោះ លំត្រ រ៉ាះ មែ ង៉ាយ អន់ណាវ?”»។ ");
INSERT INTO brb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","គ្រែដៃ យែស៊ូ ឡើ ហាយ អន់ណាវ រៀន៖ «មែ ង៉ាយ ម៉ើ ជុ តមួត រ៉ាះ អំបាះ ឡើ ឃឹត ឌិវ ដើ ចាក់ កឡឹ ឡើ ប៊ិច អ៊ឺម ខា ទឹង គ្រែដៃ ណគ អ៊ែ ឡើ បើម ប៉ាគ់ កឡា ប៊ិច បាក់ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «ប៉ាគ់ ពអ៊ែ ឡើយ ញ៉ង វ៉ើ វន់វ៉ាយ អឹ ដើ ចណង់ ចណា ចៀម ចាក់ កឡឹ លឺ ដើ ប្រវ៉ើន ហណក កដាប់ ចាក់ កឡឹ ");
INSERT INTO brb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","យ៉ាក់ ឆ្រញិវ ឡើ ប៊ិច ខា ជឺរ ចណង់ ចណា អ៊ែ ណគ់ ចាក់ ដៃ ឡើ ប៊ិច ខា ជឺរ ប្រវ៉ើន ហណក អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","វន់ឃឹត ឡាំង ប៊ឹង កអាក ញឹះ តៃ ម៉ើ ឆមូ ចួយ ញឹះ តៃ ម៉ើ សួត រ៉ិះ ញឹះ តៃ ម៉ើ ប៊ិច រ៉ម តៃ ម៉ើ ប៊ិច នុក ហាក់ គ្រែដៃ ណាគ់ ឡើ ចៀម មែ។ អ៊ែ ណគ់ ដើ វែ វ៉ើ ប៊ិច ខា ជឺរ បូវ ជែម ទុត ខាក់ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ទឹង បូវ វែ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម ម៉ើ ណោះ ពឝ៉ុះ អញុ កឡឹ ញ៉ន ដើ វន់វ៉ាយ សំ ឞិត ឞ៊ែត ណាគ់ តៃ ម៉ើ ដូវ។ ");
INSERT INTO brb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ប៉ាគ់ ពអ៊ែ ទុត កាន កិៗ ឌិត អ៊ែ វ៉ើ បើម ណាគ់ តៃ វ៉ើ ណោះ សាំ ប៉ាគ់ ង៉ាយ ឡើ ត្រ ណាគ់ វ៉ើ វន់វ៉ាយ ដើ កាន គែង អន់ណាវ? ");
INSERT INTO brb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ហឹ វន់ឃឹត ឡាំង ប៊ឹង ពឺរ ឡើ ហួន ប៉ាគ់ ង៉ាយ វ៉ើ តៃ ញឹះ តៃ ឡើ ប៉ាប ពពឹត បបើម តតាញ ពប៉ោះ។ អៃ អំហាយ ដើ វែ រៀន ទុត សឋិច សាឡូម៉ូន ឡើ ប៊ិច បាក់ អូងអាត តៃ ឋាំ ប្រវ៉ើន ហណក ណគ ទុត ចាគ់ ឞាល់ អ៊ែ ណាគ់ តៃ ឈែវ លំចាគ់ ឞាល់ ពឺរ។ ");
INSERT INTO brb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","សំ ពឺរ ហឹ ត្រិញ ឡើ ហួន វ៉ិះ មូយ តង៉ៃ ភុង ប្រាង ប្រណូវ ម៉ើ ប៊ុះ តាក់ ទិ អ៊ុញ គ្រែដៃ ណាគ់ ឡើ ប៉្រៃ ឡាក ចាគ់ៗ។ ឡា បនឹះ ណគ់ វែ វ៉ើ ចាប់ មឹង កិៗ អើយ គ្រែដៃ លំអាំ ប្រវ៉ើន ហណក ដើ វែ ណាគ់ ហម ពឺរ អ៊ែ អន់ណាវ វ៉ើ ណោះ។ ");
INSERT INTO brb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ប៉ាគ់ ពអ៊ែ វែ លែក រ៉ា ញ៉ង វ៉ើ វន់វ៉ាយ អ៊ឺម ញ៉ង វ៉ើ ឃឹត អ៊ឺម ដើ ចណង់ ចណា ");
INSERT INTO brb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","យ៉ាក់ សុនសាត អង់គែងៗ ទិ ឡាង ប្រិះ នែ ម៉ើ ខំ ដាំង រ៉ាះ លែក អ៊ែ ឡើយ។ អ៊ែ ណគ់ ដើ វែ អន់ណាវ គ្រែដៃ បើគ វែ ឡើ ណោះ ឡើយ ណគ់ វែ វ៉ើ តងកាន តូច អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","វន់ខំ បើម ត្រួយ តាម ឝ្រងុញ គ្រែដៃ ណគ់ ឡើ ពែក ប៉ាក់ វែ អ៊ែ លំអាំ រ៉ាះ លែក នែ ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«បូវ កើយៗ អៃ អើយ ញ៉ង វ៉ើ ឌូង អ៊ឺម យ៉ាក់ គ្រែដៃ បើគ វែ ឡើ ម៉ើត រន់ឋាប់ ឝ្លាំង វែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ហឹ វន់ហំពួត រ៉ាះ អំបាះ វែ វន់ចក់ លៀន អ៊ែ វន់អាំ ដើ មែ ធុក ញ៉ាក។ ប៊្លី អ៊ែ វន់តមួត ប្រនិច តៃ ឡើ ណោះ ប៊ុក តៃ ឡើ ណោះ ប៉ាត់ វន់ជុ ប្រនិច ដើ វែ កឡឹ ទឹង ហូង គ្រែដៃ ទិ ទឹង អ៊ែ ឡើ ប៊ិច អ៊ឺម បនឹះ តទូង លឺ កន់តៀរ លំមូរ។ ");
INSERT INTO brb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","យ៉ាក់ ប្រនិច វែ ហឹ ង៉ាយ ចនិះ វែ ឡើ ហឹ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«វន់ត្រៀម ចាក់ ដៃ វែ ដើម វន់ចុះ តកៀង វែ អាំ លំឝ៉ាល មាំងៗ ឋា ដើ ប្រាង ");
INSERT INTO brb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","វែ វន់បើម ប៉ាគ់ មែ ម៉ើ បើម ឞយ ម៉ើ ចាំ កន់ដ្រាគ់ មែ លន់ជឹ តើម ប៊ឹង ញែត ច្រណង់។ ហំប៊្រុះ លំប៊ឹះ លំឝឝ៉ោះ កម៉ង ឞយ ណគ អ៊ែ មន់ដក់ ប៉ើក ដ្រិះៗ ប្រយ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","តគ់ កន់ដ្រាគ់ មែ ឡើ ជឹ ឡើ តៃ មែ ង៉ាយ ណាគ់ ម៉ើ ចាំ ណគ មែ អ៊ែ មន់ហ្រនុក ហ្រវ៉ាក ឡើយ។ ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន ណគ លំពលិះ ខូ អាវ លំប៉្រៃ ឞយ ណគ អ៊ែ មន់ដ្រូម ប៊ឹង តូគ អ៊ែ ណគ កឡឹ លំបើម ឞយ តូវ លំឈូន ចណង់ ចណា ដើ មែ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ប៉ាគ់ កន់ដ្រាគ់ មែ លន់ជឹ ទឹង មាំង លឺ ដៀប ប្រាង ឡើ តៃ មែ ឞយ ណគ ណាគ់ ម៉ើ ចាំ ណគ ដឌែ មែ អ៊ែ មន់ហ្រនុក ហ្រវ៉ាក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","វែ វ៉ើ ណោះ ឡើយ ប៉ាគ់ កន់ដ្រាគ់ ហន់ណាម ឡើ ណោះ ម៉ូង បូវ មែ តទូង មន់ប៊ឹះ អ៊ែ លំអាំ អ៊ឺម មែ មន់មឹត ទឹង ហន់ណាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","អ៊ែ ណគ់ ដើ វែ អន់ណាវ វន់ត្រៀម ចាក់ ដៃ វែ យ៉ាក់ វ៉ើ ណោះ អ៊ឺម ណោះ ម៉ូង ង៉ាយ កួន បនឹះ លំប៊ឹះ ឡឹះ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ពែត្រុះ ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «អើយ យ៉ាគ់ កន់ដ្រាគ់ ពយ៉ិ ហពហាយ កាន ព្រឌីវ នែ វ៉ិះ ហព្រតូវ ឌិវ ញ៉ា ណិះ ឡើយ ឡះ លឺ ហព្រតូវ លែក ដើ បនឹះ ទឹង នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «អម៉ាង ដើ មែ ម៉ើ បើម ប៉ាគ់ ឞយ ឡើ ចាគ់ ឡើ ទឹង ត្រ ដើម ឡើ ហ្រឡិច ហ្រឡាង យ៉ាគ់ កន់ដ្រាគ់ អ៊ែ លំពឌឹក ណគ លំបើម ក្រាគ់ លំឝ្លាំង កាន យូច ត្រ ដើ ប្រមែ អន់ណាវ ដើម លំព្រណាក ចណង់ ចណា ដើ ប្រមែ ត្រំ តង៉ៃ តាម ម៉ូង ចង់ ចា។ (ប៊្លី អ៊ែ យ៉ាគ់ កន់ដ្រាគ់ ឡើ វីះ ឌុញ កម៉ ឡ ខៃ។) ");
INSERT INTO brb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ប៊ឹង យ៉ាគ់ កន់ដ្រាគ់ ឡើ ជឹ ហឹ ហន់ណាម ឡើ តៃ ឞយ ណគ ណាគ់ ឡើ ពពឹត បបើម ត្រួយ តាម ពន់ដ្រៃ ណគ ឞយ ហង់អ៊ែ លំហ្រនុក ហ្រវ៉ាក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន យ៉ាគ់ កន់ដ្រាគ់ លន់អាំ ប្រនិច ប្រណាក់ លែក អិះ ដើ ឞយ ហង់អ៊ែ លំពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ហាក់ ប៉ាគ់ ឞយ អ៊ែ លន់ឃឹត រៀន “កន់ដ្រាគ់ អៃ ឡើ ជឹ ឌុញ ឞាល់ នែ” អ៊ែ ឡើ បឹត ឞយ ណគ ដើម កទ្រី ដើម កឡ ដើម ឡើ ញញែត ចចង់ តូវ ឡើ ប៊ូ បង់។ ");
INSERT INTO brb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","តគ់ កន់ដ្រាគ់ ណគ ឡើ ជឹ វឹញ ហឹ ហន់ណាម ឡើ ត្រ ទឹង តង៉ៃ ឞយ ណគ តៃ ឡើ ញ៉ាម ចាំ ទឹង ម៉ូង ឞយ តៃ ឡើ ណោះ អ៊ែ កន់ដ្រាគ់ ណគ លំពថូត ណគ ទុត កយឹក ដើម លំជុ ណគ អរែង ដើ មែ តៃ ម៉ើ ចាប់ មឹង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ឞយ អង់ង៉ាយ ឡើ ណោះ ឡើយ ឝ្រងុញ កន់ដ្រាគ់ ណគ ហាក់ ណគ តៃ ឡើ ត្រៀម អ៊ឺម ចាក់ ណគ ដើម តៃ ឡើ បើម ត្រួយ ចនិះ កន់ដ្រាគ់ ណគ ឞយ អ៊ែ លំត្រ ឞ ប្រណឹត ទុត កយឹក។ ");
INSERT INTO brb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ហាក់ ណគ់ ឞយ អង់ង៉ាយ តៃ ឡើ ណោះ ឝ្រងុញ កន់ដ្រាគ់ ណគ កឡឹ ដើម ឡើ បើម អន់យូច លំត្រ មន់បឹត អ៊ែ មន់បឹត ណគ កិៗ។ ហាក់ ណគ់ ដើ មែ ង៉ាយ គ្រែដៃ ឡើ អាំ អើន លំសួរ ហឹ មែ អ៊ែ អើន ប៉ាគ់ទឺ។ អ៊ែ ណគ់ ដើ មែ ង៉ាយ មន់អាំ កាន ង៉ាន អើន លំសួរ តើម ប៊ឹង មែ ហ៊ែង អើន ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«អៃ អទឺះ ទិ នែ អំកលីះ អ៊ុញ ទិ ពដិះ នែ ហ៊ូយ ប៉ាគ់ លំឝ៉ូច ឡើយ តូវ អន់ញឹម ក្លើម ប្រយ អៃ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","អៃ អន់ត្រ ម៉ូច ទឹង កាន ធុក ញ៉ាក ប៉ាក ម៉ង តៃ ឋាំ អ៊ែ អៃ អគ្លីះ ក្លើម ស្រៀវ ស្រាក់ ឆា ដើ កាន នែ លន់ក្លើច ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ញ៉ង វ៉ើ ឃឹត អ៊ឺម រៀន អៃ អទឺះ ទិ នែ អាំ បនឹះ ទិ ឡាង ពដិះ នែ មន់គូ ឆនឹម ហន់ណាំង ញ៉ន ដើ អៃ នែ ឡើយ បនឹះ មន់ត្រ ត្រក្លះ ត្រក្លាយ។ ");
INSERT INTO brb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","តើម ប៊ឹង នែ ហឹ ងឺរ ប៉ាគ់ មូយ ក្រាន លំប៊ិច បនឹះ សើង រ៉ា មែ ពែ រ៉ា តៃ មន់ត្រណក ដើ អំប្រា បារ រ៉ា អំប្រា បារ រ៉ា តៃ អំប្រា ត្រណក ដើ មែ ពែ រ៉ា អ៊ែ មន់ត្រក្លះ ត្រក្លាយ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","អ៊ែ បើគ តៃ លំត្រណក ដើ កួន កឡ កួន កឡ តៃ លំត្រណក ដើ បើគ អ៊ែ ដើ មែគ តៃ លំត្រណក ដើ កួន កទ្រី កួន កទ្រី តៃ លំត្រណក ដើ មែគ ហឝ៉ៃ ម៉ិ តៃ លំត្រណក ដើ កម៉ាន់ កម៉ាន់ តៃ លំត្រណក ដើ ហឝ៉ៃ ម៉ិ ប៉ាគ់ទឺ អ៊ែ មន់ត្រក្លះ ត្រក្លាយ ឡើយ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","អ៊ែ ណគ ឡើ ម៉ាង ឡឹះ ដើ មែ ក្លាង ស៊្រុក រៀន៖ «ទឹង វែ វ៉ើ តៃ យូក ឡើ តមួត តៃ ម៉ាត់ តង៉ៃ លុច អ៊ែ វ៉ើ ណោះ ប្រយ រៀន ដៀប លំអំមឺ ឡើយ ប៊្លី អ៊ែ ឡើ អំមឺ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","អ៊ែ ទឹង កយឺវ ឡើ ពឹក ព្រឌឹង ម៉ាត់ តង៉ៃ តៃ ចម៉ា វ៉ើ រៀន លំដុ ទុត ថាំង ឡើយ អ៊ែ ឡើ ដុ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","អើយ ណគ់ វែ វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង វ៉ើ ណោះ ហឝ៉ាវ អំមឺ ដុ តាម វ៉ើ តៃ ទិ ប្រិះ ទឹង គ្រែ ប៉ិ ឡើ ត្រ តៃ វ៉ើ ណោះ ហឝ៉ាវ កាន ឡើ កើត ណិះៗ នែ ដឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«ប៉ិ តៃ វ៉ើ ណោះ ឃឹត វែ កឡឹ កាន ចាគ់ វន់ត្រ បើម? ");
INSERT INTO brb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ទឹង ម៉ើ ងុញ តិច ហៃ ម៉ើ ច្រា ហៃ ដក់ ហឹ មែ តង់កង់ តាត់ កឍី លុង ណាគ់ ទឹង សប្រា លំដក់ តៃ ទ្រូង ហន់ខំ ហ្រឡះ ហំប៉ះ ត្រឌីវ សប្រា កឡឹ អន់ដៃ ប៉ាគ់ តៃ ហំបើម ប៉ាគ់ នែ ណគ លំឈូន ហៃ ហឹ បឹ តាត់ កឍី បឹ តាត់ កឍី លំឈូន ហៃ ហឹ បឹ ពលិះ បឹ ពលិះ លំជុ ហៃ ទឹង ឃុក។ ");
INSERT INTO brb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","អៃ អង់ហាយ ដើ ហៃ រៀន ញឹះ លំណុះ លៀន ហន់សៀ ដើ មែ អ៊ែ ហន់ដូវ ញឺះ តើម ប៊ឹង ឃុក»។ ");
INSERT INTO brb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ទឹង អ៊ែ ប៊ិច បនឹះ ម៉ើ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ ពីឡាត់ ឡើ ប៉្រៃ តហាន ណគ ម៉ើ កជែត មែ ឝ៉ាលីលែ អន់នឺ រ៉ា ទឹង ម៉ើ កជែត បណាន់ ម៉ប អាំ ដើ គ្រែដៃ អ៊ែ ផាម បនឹះ ឡើ លុក ឡំ ដើ ផាម បណាន់»។ ");
INSERT INTO brb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","អ៊ែ ឡើ ត្រណើវ ម៉ាង មែ រៀន៖ «ប៉ិ វ៉ើ ឃឹត រៀន មែ ឝ៉ាលីលែ ម៉ើ គែត អ៊ែ ម៉ើ ប៊ិច ឞាប អើន ជឺរ មែ ឝ៉ាលីលែ ហឹ គែង អន់ណាវ ឡះ ញ៉ន ម៉ើ គែត ប្រៀង ធុក ញ៉ាក ប៉ាគ់ អ៊ិន? ");
INSERT INTO brb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ឡើ ត្រ អ៊ឺម អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ វែ តៃ វន់ពលិះ ចនិះ វន់គែត ប្រៀង ប៉ាគ់ មែ ទឺ ឡើយ ");
INSERT INTO brb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","អ៊ែ ទឹង ចន់ដ្រាង ស៊ីឡូម ម៉ើ បើម ដើ តម៉ ឡើ បង់ តឹន មែ ជិត ថាម រ៉ា ប៉ិ វ៉ើ ឃឹត ណគ់ ដើ មែ ម៉ើ គែត ប្រៀង អ៊ែ ម៉ើ ឞាប អើន ជឺរ មែ ហឹ គែង ទឹង មួង យែរូសាឡឹម ឡះ? ");
INSERT INTO brb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","អ៊ឺម អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ វែ តៃ វន់ពលិះ ចនិះ វន់គែត ប្រៀង ធុក ញ៉ាក់ ប៉ាគ់ ដើ មែ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ រៀន៖ «ប៊ិច បនឹះ មូយ រ៉ា ឡើ ដាំ តើម លវ៉ា ទឹង មឺរ ណគ អ៊ែ ឡើ ដក់ ឝ្លាំង អំប លំប៊ិច ប៉្លៃ។ ឡើ ប៊ឹះ តគ់ អ៊ែ អំបុះ តៃ ឡើ ប៉្លៃ ស្រើវ។ ");
INSERT INTO brb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","អ៊ែ ឡើ ហាយ ដើ បឹ ឡើ រន់ឋាប់ ឝ្លាំង មឺរ ណគ រៀន “ពែ កម៉ ឡើយ អដក់ ឝ្លាំង អងុញ អំប៉ិះ ប៉្លៃ លវ៉ា ហឹ តើម នែ ណាគ់ តៃ ឡើ ប៉្លៃ។ យ៉ាក់ ប៉ាគ់ អ៊ែ ហង់កូវ តាក់ យ៉ឹ ឝ៉ាន់ ឡើ កួច ពដិះ មិៗ”។ ");
INSERT INTO brb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","អ៊ែ បឹ អន់នែ ឡើ ត្រណើវ រៀន “ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ! ហន់ជុ ណាគ់ មូយ កម៉ អន់ដៃ ចាំ អៃ អន់ឈ្រឺក ពដិះ ឈុំ តើម អ៊ែ អន់ជុ អ៊ិច បណាន់ ");
INSERT INTO brb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","អំប កម៉ អន់ទុន ណាគ់ លំប៉្លៃ ប៉ាគ់ តៃ លំប៉្លៃ ដឌែ អ៊ែ ហំប៉្រៃ អង់កូវ តាក់ ឆិ”»។ ");
INSERT INTO brb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន មែ ទឹង រ៉ូង ពស៊ុំ លមូយ ឡើ ត្រ ទឹង តង៉ៃ ម៉ើ ព្រឹង។ ");
INSERT INTO brb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ទឹង អ៊ែ ឡើ ប៊ិច កទ្រី មូយ រ៉ា ឡើ ឈិ អរ៉ាក់ ឡើ មឹត ជិត ថាម កម៉ ឡើយ ឡើ បើម អាំ ណគ ឈិ ត្រូន កណង ឡើ ឆុង ទឹងៗ តៃ ដូវ យ៉ាវ។ ");
INSERT INTO brb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ តៃ កទ្រី ឡើ ត្រូន កណង អ៊ែ ឡើ កឡូវ ប៉្រៃ ដក់ ហឹ ណគ ឡើ ម៉ាង រៀន៖ «អើយ ណាង ហន់នៀម ឡើយ តើម ប៊ឹង ឆនិ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ឡើ ជុ ទី ពឺង កទ្រី ហង់អ៊ែ អ៊ែ កណង ណគ ឡើ ទឹង ប្រយ ដើម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","អ៊ែ ដើ កឡា ពែក ប៉ាក់ រ៉ូង ពស៊ុំ អន់ណាវ ឡើ មាំ ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ បើម អន់នៀម បនឹះ មូយ រ៉ា ទឹង តង៉ៃ ម៉ើ ត្រ ព្រឹង អ៊ែ ឡើ ម៉ាង ដើ មែ ម៉ើ មឹត ពស៊ុំ រៀន៖ «ចឞាប់ ឡើ អាំ ង៉ាយ ង៉ើ បើម កាន វ៉ិះ ឌិវ ត្រូវ តង៉ៃ អិះ ឡើយ អ៊ែ វន់ដក់ ហឹ ណគ លំពនៀម វែ ទឹង ត្រូវ តង៉ៃ អ៊ែ ឡើយ ញ៉ង វ៉ើ ដក់ អ៊ឺម ទឹង តង៉ៃ ង៉ើ ព្រឹង!»។ ");
INSERT INTO brb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ ម៉ាង ណាយ រ៉ូង ពស៊ុំ រៀន៖ «អើយ បនឹះ វ៉ើ ពឃឺ វ៉ិះ ឌិវ តៃ ពឺង អើយ! ទឹង តង៉ៃ ង៉ើ ព្រឹង វែ ត្រំ រ៉ា អាត វន់ឡិះ ពរ៉ូះ ឝ៉ូ ដើម លៀ វែ តើម ប៊ឹង ខក វន់ទឹក តៀត ពញែត ដាក ប៉ាគ់ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","អ៊ែ កទ្រី អន់នែ អន់ណាវ ឡើ ត្រ កួន ចូវ យ៉ាគ់ អាប្រាហាំ ណគ់ អរ៉ាក់ សតាំង ឡើ ចង ណគ ជិត ថាម កម៉ ឡើយ ត្រ អ៊ឺម ឡះ អន់ឡិះ ពឝ៉្លើច ណគ តើម ប៊ឹង ទី អរ៉ាក់ ទឹង តង៉ៃ ង៉ើ ព្រឹង នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ប៊្លី ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ឡើយ លែក ដើ មែ ណគ់ ម៉ើ ព្រឆាន់ ដើ ណគ ម៉ើ កម៉ាវ យួរ អ៊ែ ដើ មែ ក្លាង ស៊្រុក លែក រ៉ា ម៉ើ រ៉គ់សំ ញឹម ក្លើម ក្លាក ដើ ម៉ើ តៃ កាន ឆង៉ាត់ គ្រែដៃ យែស៊ូ ឡើ បើម។ ");
INSERT INTO brb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប៉ាគ់ ង៉ាយ គ្រែដៃ ឡើ ពែក ប៉ាក់ មែ ប៉ាសាសុន ណគ? ប៊ឹង ង៉ាយ អំព្រឌីវ? ");
INSERT INTO brb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","អំព្រឌីវ ឡើ បើម ប៉ាគ់ អង់គុង ក្លិត អង់គ្លែត ណគ់ បឹ មូយ រ៉ា ឡើ ដក់ ដាំ ហឹ មឺរ ណគ។ អង់គុង អ៊ែ ឡើ ហួន ឡើ វឹរ តើម ឡង មូយ អ៊ែ ជែម ម៉ើ ដក់ បើម កសូម ប៊ឹង ឝឹង ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ រៀន៖ «កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ប៊ឹង ង៉ាយ អំព្រឌីវ? ");
INSERT INTO brb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","អំព្រឌីវ ប៉ាគ់ ប៊ូះ ណគ់ កទ្រី ឡើ ចក់ លុក ទឹង ភែ ប៊ិះ មូយ រែវ ហម ឡើ បើម ណំពាំង អ៊ែ ភែ ប៊ិះ ឡើ ឌឹក សូល លែក អិះ »។ ");
INSERT INTO brb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","គ្រែដៃ យែស៊ូ ឡើ ដក់ ឡឹះ ហឹ មួង យែរូសាឡឹម ក្លង មួង ហង់អ៊ែ ដក់ មួង ហង់អ៊ែ ក្លង ស៊្រុក ហង់អ៊ែ ដក់ ស៊្រុក ហង់អ៊ែ ដើម ឡើ ពង់ហៀន មែ ក្លាង ស៊្រុក ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ប៊ិច បនឹះ មូយ រ៉ា ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ! គ្រែដៃ លំហវ៉ាត់ បនឹះ កើយៗ ឡះ?»។ ណគ ឡើ ត្រណើវ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«វន់ខំ មឹត ឝឡោះ កដៀត យ៉ឹ អៃ អហាយ ដើ វែ ប៉ាគ់ នែ រៀន យ៉ាក់ ឡើ ប៊ិច បនឹះ ទុត អើន មន់ខំ មឹត ណាគ់ តៃ មន់ដូវ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ទឹង តង៉ៃ កន់ដ្រាគ់ ហន់ណាម លំឌឹក ពាំង កម៉ង លែវ ឡើយ អ៊ែ វែ ណាគ់ វន់ឆុង ហឹ អរ៉ះ ដើម វន់ឝឝ៉ោះ កម៉ង វន់ឡា ឡូម ហឹ កន់ដ្រាគ់ ហន់ណាម រៀន៖ “អើយ កន់ដ្រាគ់ ឡា ហំប៉ើក កម៉ង ដើ ញ៉ា អុះ”។ អ៊ែ កន់ដ្រាគ់ ហន់ណាម លំតើវ វែ រៀន “អ៊ឺម! អហឝ៉ាវ អ៊ឺម អៃ វែ អ៊ិន ណោះ តើម ប៊ឹង ង៉ាយ វ៉ើ ប៊ឹះ!”។ ");
INSERT INTO brb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","អ៊ែ វន់ត្រណើវ ណគ រៀន “ញ៉ា ញ៉ើ ខើយ ចង់ ចា អរែង ប៊ឹង ហៃ ហៃ ហខើយ ពង់ហៀន ញ៉ា ហឹ បយឺង ទឹង ស្រ៊ុក ប្រិះ ញ៉ា”។ ");
INSERT INTO brb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","អ៊ែ លំតើវ វែ រៀន៖ “អ៊ឺម អហឝ៉ាវ អ៊ឺម វែ ណោះ តើម ប៊ឹង ង៉ាយ វ៉ើ ប៊ឹះ។ អូ ណគ់ វែ វ៉ើ បើម តៃ ទឹង ត្រ ណិះៗ វន់វីះ តើម ប៊ឹង អៃ!”»។ ");
INSERT INTO brb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«ប៊ឹង អ៊ែ វន់តៃ យ៉ាគ់ អាប្រាហាំ យ៉ាគ់ អ៊ីសាគ់ យ៉ាគ់ យ៉ាកុប ដើម លែក ដើ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ មន់គូ គូម ហឹ ឞន គ្រែដៃ លំពែក ប៉ាក់។ ហាក់ គ្រែដៃ លំតវីះ តាក់ វែ ហឹ ដៀក អ៊ែ វន់ណោះ វ៉ិះ ឌិវ ញឺម តូវ វន់កាប់ ក្រៀម ឝលៀម ពឹង។ ");
INSERT INTO brb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ទឹង ឞន គ្រែដៃ លំពែក ប៉ាក់ លំប៊ិច បនឹះ លែក ដើ សុនសាត ត្រំ អំប៊ុ មន់ដក់ តមួត ចង់ ចា អរែង។ ");
INSERT INTO brb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ទឹង អ៊ែ ណគ់ មែ តៃ ម៉ើ ម៉ាត ប៊ីត តគ់ ហន់ណូវ មន់បើម ទិះ ក្រាគ់ ណគ់ មែ ម៉ើ ទិះ ក្រាគ់ តគ់ ហន់ណូវ តៃ មន់ម៉ាត ប៊ីត អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","អ៊ែ ប៊ិច មែ ផារីស៊ី អន់នឺ រ៉ា ម៉ើ ដក់ ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «ហំវីះ តើម ប៊ឹង នែ យ៉ាក់ សឋិច ហ៊ែរ៉ូត ឡើ ងុញ កជែត ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","អ៊ែ ណគ ឡើ ត្រណើវ រៀន៖ «វន់ដក់ ហាយ ហឹ បឹ ឡើ ណោះ តបូត ប៉ាគ់ ច ប៊្រី ទឺ “ហន់ឝ្លាំង តង៉ៃ នែ ដើម ប្រណូវ អំពន់ឌ្រុះ អរ៉ាក់ ដើម អំបើម អន់នៀម មែ ម៉ើ ឈិ។ តគ់ តង៉ៃ ទី ពែ លំឡូច ឡើយ កាន ង៉ាន អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ហាក់ តង៉ៃ នែ ប្រណូវ ដើម ហំប្រា អៃ នែ អន់ត្រ ដក់ ប៊ឹះ មួង យែរូសាឡឹម យ៉ាក់ ឃឺ អ៊ឺម កឡា ឈូន ប្រម៉ាង គ្រែដៃ លន់គែត ហឹ ដៀក មួង យែរូសាឡឹម”»។ ");
INSERT INTO brb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«អើយ យែរូសាឡឹម យែរូសាឡឹម អើយ វែ វ៉ើ កជែត កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម វ៉ើ ពៀវ កជែត ដើ តម៉ ណគ់ មែ គ្រែដៃ ឡើ ប៉្រៃ ដក់ ហឹ វែ តៃ ណោះ ស៊ិ តង ឡើយ អងុញ តមួត យ៉ើក កួន ចូវ វែ ប៉ាគ់ អៀរ ឡើ ពុះលុំ កួន ណគ ដើ ហឡាប ហាក់ វ៉ើ ឌី អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","វន់ឝ្លាំង យ៉ឹ គ្រែដៃ លំតាក់ មួង វែ អ៊ែ លំហ្រង៉វ។ អៃ អង់ហាយ ដើ វែ រៀន វន់តៃ យ៉ាវ អៃ ឆា ដើ ប៊ឹះ វន់ម៉ាង រៀន “ឡា គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ បឹ ឡើ ប៊ឹះ ទឹង ម៉ាត់ គ្រែដៃ កន់ដ្រាគ់”»។ ");
INSERT INTO brb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","តង៉ៃ ហង់អ៊ិន តង៉ៃ ម៉ើ ព្រឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ ចង់ ចា ហឹ ហន់ណាម បឹ មូយ រ៉ា ឡើ ទិះ ក្រាគ់ ទឹង បូវ មែ ផារីស៊ី។ ណគ់ មែ ម៉ើ ចង់ ចា អរែង ប៊ឹង ណគ អ៊ែ ម៉ើ អន់ឆយ ឝ្លាំង ហឹ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡើ ឈិ ផុក ឡើ ដ្រូម ប៊ឹង ងឺរ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","គ្រែដៃ យែស៊ូ ឡើ តង៉ា បូវ ម៉ើ ពង់ហៀន ចឞាប់ ដើម បូវ មែ ផារីស៊ី រៀន៖ «ពយ៉ិ វ៉ើ ឃឹត ណាគ់ ឡើ ត្រ ឡះ ងំពនៀម បនឹះ ឈិ ទឹង តង៉ៃ ង៉ើ ព្រឹង?»។ ");
INSERT INTO brb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","លែក ដើ មែ ម៉ើ គូ ហ្រហៀង ម៉ើ តើវ អ៊ឺម ម៉ាង ណគ។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ រ៉ាប់ ពឹត ពនៀម ប្រយ បឹ ឡើ ឈិ ប៊្លី អ៊ែ ឡើ ប៉្រៃ ណគ ជឹ។ ");
INSERT INTO brb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","អ៊ែ ឡើ ម៉ាង រៀន៖ «ទឹង បូវ វែ ប៉ាគ់ បឹ អង់ង៉ាយ ឡើ ប៊ិច កួន លឺ ឝ៉ូ លន់គ្លីះ ទិ រន់ឋូវ សំ លំត្រ តង៉ៃ ង៉ើ ព្រឹង កតាម អាត ណគ លំពឌឹក ដ្រិះៗ ប៉ាគ់ទឺ ឡើយ កឋោះ?»។ ");
INSERT INTO brb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","មែ ម៉ើ ណោះ អ៊ឺម ម៉ើ ត្រណើវ កាន ណគ ឡើ តង៉ា អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","គ្រែដៃ យែស៊ូ ឡើ តៃ មែ តមួយ ម៉ើ ងុញ ដក់ ដ្រូម ប៊ឹង ដ្រុនដ្រូម មែ ទិះ ក្រាគ់ អ៊ែ ឡើ ម៉ាង ព្រឌីវ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ប៉ាគ់ ប៊ិច មែ ម៉ើ ចន់ដ្រា ហៃ ដក់ ញែត ចង់ ហឹ ហន់ណាម មែ ម៉ើ ច្រណង់ ញ៉ង ហដ្រូម អ៊ឺម ប៊ឹង ដ្រុនដ្រូម ណគ់ ម៉ើ ជុ ដើ មែ ទិះ ក្រាគ់ អំប មន់ច្រា មែ ទិះ ក្រាគ់ ជឺរ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","អ៊ែ កឡា ប្រយ៉ង់ លំដក់ ពហាយ ដើ ហៃ រៀន “ហន់ឌឹក យ៉ឹ ហង់អាំ ដ្រុនដ្រូម ហៃ ដើ យ៉ាគ់ ទិះ ក្រាគ់ អន់នែ”។ ប៊ឹង អ៊ែ ហៃ អាត ហន់កម៉ាវ យួរ ឡើយ ហន់ជឹ ដ្រូម ហឹ កនូ តៃ ខា ឃុន ជឺរ បូវ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ប៉ាគ់ ប៊ិច មែ មន់ចន់ដ្រា ហៃ ដក់ មឹត ចង់ ប៊ឹង មែ ហន់ដក់ ដ្រូម ហឹ ត្រិច ត្រួច មែ អន់ដៃ ញឹះ លំប៊ឹះ កឡា ហន់ណាម កឡឹ លំហាយ ដើ ហៃ រៀន “អើយ កឡើ ហន់ឌឹក ដ្រូម ទិ ងឺរ នែ អន់ណាវ”។ ប៊ឹង អ៊ែ ហៃ ហំប៊ិច មុះ ម៉ាត់ ប៊ឹង ងឺរ មែ តមួយ ម៉ើ ដ្រូម អរែង ប៊ឹង តូគ។ ");
INSERT INTO brb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","យ៉ាក់ ណគ់ មែ ង៉ាយ ម៉ើ ពឌឹក ចាក់ មែ អ៊ែ គ្រែដៃ លំពន់ដាប អន់ណាវ។ អ៊ែ ណគ់ មែ ង៉ាយ ម៉ើ ពន់ដាប ចាក់ មែ អ៊ែ គ្រែដៃ លំពឌឹក អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ បឹ កឡា ឡើ ចន់ដ្រា ចង់ ចា អ៊ែ រៀន៖ «ប៉ាគ់ ប៊ឹង ហំប៊ិច កាន ញែត ចង់ ឆុង តង៉ៃ ឆិ អំប៊ឹ ឆិ ញ៉ង ហន់ចន់ដ្រា អ៊ឺម បូវ ប៊ែង ប្រម៉ើត អន់ញ៉ុ អំម៉ោះ អោះ មីក ប៉ លឺ មែ ព្រដៀង ហន់ណាម ណគ់ មែ ម៉ើ ប៊ិច បាក់ ប៉ាគ់ ពអ៊ែ មន់ច្រា តូវ ឡើយ ហៃ។ ");
INSERT INTO brb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ហាក់ ប៉ាគ់ ប៊ឹង ហៃ ហំប៊ិច កាន ញែត ចង់ ណាគ់ ហយ ហន់ច្រា មែ ធុក ញ៉ាក កន់ចក អវែះ ញ៉ច ឈឹង ទី សូត ឡក់ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ប៉ាគ់ ហំបើម ប៉ាគ់ អ៊ិន អ៊ែ ហៃ ហន់ហ្រនុក ហ្រវ៉ាក ឡើយ។ យ៉ាក់ មែ លែក អ៊ែ តៃ មន់ដូវ អ៊ឺម មន់តូវ ហៃ វ៉ិះ ឌិវ គ្រែដៃ ឡើយ លំតូវ ដើ ហៃ តគ់ បនឹះ ចាគ់ ទឹង ត្រ មន់ញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ប៊្លី ឡើ ដុង ប្រម៉ាង គ្រែដៃ យែស៊ូ លែក អ៊ែ ឡើយ អ៊ែ កឡ មូយ រ៉ា ឡើ ដ្រូម អរែង ប៊ឹង តូគ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ហឹ ឞន គ្រែដៃ លំពែក ប៉ាក់ ណគ់ មែ ង៉ាយ ម៉ើ មឹត ចង់ ចា អរែង ប៊ឹង ណគ មែ អ៊ែ មន់ហ្រនុក ហ្រវ៉ាក ឡើយ!»។ ");
INSERT INTO brb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ប៊ិច តង់កង់ មូយ រ៉ា ឡើ ទែង ជុបលៀង ចង់ ចា ញែត ចនូ គូ ពន់ដ្រូយ អរែង ទុត អើន ដើម ឡើ ចន់ដ្រា បូវ ប៊ែង ទុត អើន ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","តគ់ ប៊ឹះ ម៉ូង ចង់ ចា ឡើ ប៉្រៃ ឞយ ណគ ដក់ ចន់ដ្រា មែ តមួយ រៀន “ចណង់ ចណា ម៉ើ បើម ដើ វែ លែវ ឡើយ មិញ វន់ដក់ ចង់ ហឹ តគ់”។ ");
INSERT INTO brb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ណគ់ មែ តមួយ លែក ដើ អ៊ែ ម៉ើ ប៉្លិច ចាក់ ត អន់ត លែក ដើ មែ។ បឹ អន់នួរៗ ឡើ ត្រណើវ រៀន “អតើប អ៊ឺម អៃ អ៊ិន អរួត ប្រិះ ហន់ដើម ឡើ ត្រ អន់ដក់ ឝ្លាំង ណិះៗ ឡើយ អឡា ឡាប់ ញ៉ម ហឹ កន់ដ្រាគ់ ហៃ តាក់ ដើ វែ ហឹ អិះ ឡើយ វន់ញែត ចង់”។ ");
INSERT INTO brb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","បឹ មូយ រ៉ា ឡើ ប៉្លិច ចាក់ ណគ រៀន “អតើប អ៊ឺម អៃ អ៊ិន ហន់ដើម អរួត ឝ៉ូ សើង ហំប៊្រុក អងុញ ដក់ ឝ្លាំង អឡា ឡាប់ ញ៉ម ហឹ កន់ដ្រាគ់ ហៃ តាក់ ដើ វែ វន់ញែត ចង់ ហឹ អិះ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","បឹ មូយ រ៉ា ឡឹះ អន់ណាវ ឡើ តើវ រៀន “ដូវ អ៊ឺម អៃ អ៊ិន អន់ដក់ ញែត ចង់ ហឹ វែ យ៉ាក់ អច្រណង់ ហន់ដើមៗ”។ ");
INSERT INTO brb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ឞយ ឡើ ជឹ ហាយ ហឹ កន់ដ្រាគ់ ណគ ប៉ាគ់ ប្រម៉ាង មែ ម៉ើ ប៉្លិច ចាក់ ទឺ។ អ៊ែ កន់ដ្រាគ់ ហន់ណាម ឡើ មាំ ប្រយ ដើ មែ ម៉ើ ប៉្លិច ចាក់ ឡើ ប៉្រៃ ឡឹះ ឞយ ណគ រៀន “ប៉ាគ់ ពអ៊ែ ដ្រិះ ហន់ដក់ ច្រា មែ បរ ទ្រូង ទិះ ទ្រូង កិ ទឹង មួង នែ ដើម ហន់ច្រា បូវ មែ ធុក ញ៉ាក ដឹប មែ ម៉ើ កន់ចក អវែះ ញ៉ច ឈឹង ទី សូត ឡក់ ដិ”។ ");
INSERT INTO brb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","តគ់ ប៊្លី អ៊ែ ឞយ ណគ ឡើ ជឹ ហាយ ហឹ កន់ដ្រាគ់ ណគ ឡឹះ រៀន “យ៉ាគ់ កន់ដ្រាគ់ អៃ អបើម ត្រួយ តាម ហៃ ហប៉្រៃ ឡើយ ហាក់ ឞន ដ្រូម ណាគ់ ឡើ ស៊ិវ ដឌែ”។ ");
INSERT INTO brb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","កន់ដ្រាគ់ ហន់ណាម ឡើ ប៉្រៃ ឡឹះ ឞយ ណគ អន់ណាវ រៀន “មិញ ហន់ដក់ បរ ស្រ៊ុក ណក ណើ បរ រំឞង ដ្រក ហន់ច្រា ពង់ខំ មែ ម៉ើ គូ ប៊ឹង អ៊ែ មន់ដក់ មឹត ហឹ ហន់ណាម អៃ នែ អាំ ប៊ិងៗ”។ ");
INSERT INTO brb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","អៃ អង់ហាយ ដើ វែ រៀន “ទឹង បូវ មែ ណគ់ អៃ អច្រា ឡៃ អន់នួរ អ៊ែ មែ លែក អ៊ែ អង់អាំ យ៉ាវ មន់ដក់ ញែត ចង់ ហឹ អៃ ហម មន់តមឹង មូយ អំម៉ាង ណាគ់ តៃ អង់អាំ ប៉ាគ់ទឺ”»។ ");
INSERT INTO brb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","មែ ក្លាង ស៊្រុក ទុត អើន ម៉ើ ដក់ តូយ គ្រែដៃ យែស៊ូ អ៊ែ ឡើ ហវីវ ឝ្លាំង ហឹ មែ ឡើ ម៉ាង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ប៉ាគ់ មែ ង៉ាយ ម៉ើ ងុញ ដក់ តូយ អៃ ហាក់ ប៉ាគ់ តៃ មន់ម៉ើត អៃ ជឺរ មែគ បើគ កួន ទ្រី អំម៉ោះ អោះ ដើម កាន ញិវ កើត ចាក់ ម៉ើ កឡឹ មែ អ៊ែ ដូវ អ៊ឺម មន់បើម លុកស៊ិក អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","មែ ង៉ាយ តៃ ម៉ើ កួយ ឡង អង់ឝ៉ាង មែ កឡឹ ដើម តៃ ម៉ើ ដក់ តូយ អៃ មែ អ៊ែ ដូវ អ៊ឺម ប៉ាគ់ទឺ មន់បើម លុកស៊ិក អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ទឹង បូវ វែ លែក រ៉ា នែ ប៉ាគ់ បឹ អង់ង៉ាយ ឡើ ងុញ បើម ហន់ណាម កន់តារ ទិះ លន់ត្រ ឃឹត ឝ្លាំង ច្រណាប់ ឞាល់ ង៉ាយ អន់ដៃ បក់ លន់ណោះ រៀន ឡើ ប៊ិច លៀន ឞាល់ ង៉ាយ លំឆិ អ៊ែ លំបើម អន់ចឹះ ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","កឡាគ់ ហន់ណូវ លំប៊្រឹក ឌិវ ឆ្រាំង មិៗ លំបើម អន់ចឹះ អ៊ឺម លែក ដើ បូវ ម៉ើ តៃ ប៉ាគ់ អ៊ែ មន់ចអាវ ពន់ឆាំ។ ");
INSERT INTO brb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","មន់រៀន “វន់ឝ្លាំង បឹ អន់នែ ឡើ បើម ហន់ណាម តៃ ឡើ ដូវ បើម អន់ចឹះ អ៊ឺម!”»។ ");
INSERT INTO brb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«អំព្រឌីវ មូយ អន់ណាវ ប៉ាគ់ សឋិច មូយ រ៉ា ឡើ ដក់ ប្រណើម ប៊ឹង សឋិច លមូយ អន់ណាវ អាត ណគ លន់គូ ឃឹត អន់ដៃ រៀន “អៃ អប៊ិច តហាន ឌិវ មូយ មឺន រ៉ា ណាគ់ អំប៊ែ ឋូវ អំប្រណើម ប៊ឹង សឋិច ឡើ ប៊ិច តហាន បារ មឺន រ៉ា?”។ ");
INSERT INTO brb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ប៉ាគ់ ឡើ ឃឹត រៀន លំប្រណើម តៃ ផវ ប៊ែ អ៊ឺម អ៊ែ លំប៉្រៃ មែ មន់ដក់ ចជែ អូរ ញ៉ូម ហឹ សឋិច អ៊ែ ទឹង ណាគ់ ឡើ គូ ចង៉ាយៗ នែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","«ប៉ាគ់ទឺ ឡើយ ដើ វែ លែក រ៉ា មែ ង៉ាយ តៃ ម៉ើ សឡាគ់ តាក់ រ៉ាះ អំបាះ អង់ង៉ាយៗ ណគ់ ម៉ើ ប៊ិច មែ អ៊ែ ដូវ អ៊ឺម មន់បើម លុកស៊ិក អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«បោះ ឡើ ប៊ិច ខា ខាក់ៗ ហាក់ ប៉ាគ់ លំប៉ាត់ តារ់ ឡើយ ប៉ាគ់ ង៉ាយ អន់ណាវ ងំបើម អ៊ែ លំតារ់ ឡឹះ? ");
INSERT INTO brb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","បោះ អ៊ែ តៃ លំប៊ិច ខា យ៉ាវ សំ ងំលុក ដើ ពដិះ លឺ ដើ អ៊ិច បណាន់ ណាគ់ តៃ លំប៉ិន យ៉ាវ ប៉ាគ់ទឺ ឡើយ វ៉ិះ ឌិវ ងំហវ៉ាក់ តាក់ ឡើយ។ អើយ ណគ់ មែ ង៉ាយ ម៉ើ ដុង ប្រម៉ាង អៃ នែ វន់ឃឹត យ៉ឹ!»។ ");
INSERT INTO brb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ប៊ិច មែ ម៉ើ កាគ់ លៀន ដើម បនឹះ ប៊ិច ឞាប ម៉ើ ដក់ ហឹ គ្រែដៃ យែស៊ូ ម៉ើ ចង់ហៀង ប្រម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","បូវ មែ ផារីស៊ី ដើម បូវ មែ ពង់ហៀន ចឞាប់ ម៉ើ ម៉ាង ចំ រៀន៖ «វន់ឝ្លាំង បឹ អន់នែ ឡើ ឌី គូ អរែង ប៊ឹង បនឹះ ឞាប ដើម ឡើ ចង់ ចា អរែង ប៊ឹង មែ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ទឹង បូវ វែ នែ ប៉ាគ់ មូយ រ៉ា ឡើ ប៊ិច ចៀម មូយ ក្លាំ អំប៉ម អ៊ែ ចៀម ណគ ឡើ ប៉ាត់ មូយ អំប៉ម ណគ់ ចៀម ជែន ជិត ជែន អំប៉ម នែ អាត ណគ លំជុ តាក់ ទឹង ត្រិញ អិះ ឡើយ អ៊ែ លំដក់ សាត ចៀម ណគ់ ឡើ ប៉ាត់ អ៊ែ ឆា ដើ តៃ។ ");
INSERT INTO brb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","តគ់ ឡើ តៃ ឡើយ ចៀម ណគ ឡើ ញឹម ក្លើម ទុត ខាក់ អ៊ែ ឡើ ជឹ តៀត ចំបាក់ ប៊ឹង ដង់។ ");
INSERT INTO brb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ឡើ ជឹ ប៊ឹះ តគ់ ហន់ណាម ឡើ កឡូវ មែ បូវ ប៊ែង ណគ ដើម មែ ព្រដៀង ហន់ណាម រៀន “អើយ បូវ ប៊ែង វន់ដក់ ផូវ ញឹម ក្លើម អរែង ដើ អៃ នែ យ៉ាក់ ចៀម អៃ ណគ់ ឡើ ប៉ាត់ ណិះៗ អសាត តៃ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ អ៊ែ ទឺ ឡើយ គ្រែដៃ ដើម មែ ម៉ើ គូ ទឹង ហូង គ្រែ មន់ញឹម ក្លើម ប៉ាគ់ ប៊ិច បនឹះ ឞាប មូយ រ៉ា លំពលិះ ចនិះ មន់ញឹម ក្លើម ជឺរ បនឹះ ជែន ជិត ជែន រ៉ា ណគ់ ម៉ើ ចាគ់ ទឹង ត្រ ឡើយ តៃ ម៉ើ តងកាន ពលិះ ចនិះ យ៉ាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«មូយ ឡឹះ អន់ណាវ អំព្រឌីវ រៀន ប៊ិច កទ្រី មូយ រ៉ា ឡើ ប៊ិច លៀន ជិត កាក់ ប៉ាគ់ ឡើ ប៉ាត់ មូយ កាក់  អាត ណគ លន់ចក់ តកៀង លំពយ៉ូង ប៉ូះ សាត បុ មុំៗ ញ៉កៗ ឆា ដើ តៃ។ ");
INSERT INTO brb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ហំប៊្រុះ ឡើ តៃ ឡើ កឡូវ ប្រយ បូវ ប៊ែង ណគ ដើម មែ ព្រដៀង ហន់ណាម រៀន “អើយ បូវ ប៊ែង វន់ដក់ ផូវ ញឹម ក្លើម ក្លាក អរែង ដើ អៃ យ៉ាក់ កាក់ អៃ ណគ់ ឡើ ប៉ាត់ ណិះៗ នែ អសាត តៃ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","អៃ អង់ហាយ ដើ វែ រៀន ប៉ាគ់ អ៊ែ ទឺ ឡើយ គ្រែដៃ ដើម ឞាវ ណគ ឞាវ គ្រែដៃ ម៉ើ ញឹម ក្លើម ទុត ខាក់ ប៉ាគ់ ប៊ិច បនឹះ ឞាប មូយ រ៉ា ឡើ ពលិះ ចនិះ»។ ");
INSERT INTO brb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «តង់កង់ ហង់អ៊ិន ឡើ ប៊ិច កួន កឡ បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","កួន អន់សូច ឡើ ម៉ាង ហឹ បើគ ណគ រៀន “អើយ បើគ អឡា ហង់អាំ មូន ពណាក អៃ ណិះៗ ឡើយ”។ អ៊ែ បើគ ណគ ឡើ ព្រណាក ប្រយ មូន ណគ ដើ អំប្រា កួន ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","បារ ពែ តង៉ៃ ប៊្លី អ៊ែ តគ់ កួន អន់សូច ណគ ឡើ ហំពួត មូន មាំង ចក់ លៀន លែវ ឡើយ អ៊ែ ឡើ វីះ ហឹ ស្រុក ចង៉ាយ ប៉ាត់ តាក់។ ហឹ អ៊ែ ឡើ តប៉ាត់ អន់ឈឺះ លៀន មូន មាំង បើគ ណគ តៃ ប៊ិច ខា លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","លៀន ណគ ឡើ តប៉ាត់ តូច ឡើយ អ៊ែ ឡើ ប៊ិច កាន អឹត ហរុ លែក ដើ ស្រុក អ៊ែ ឡើ ពងួត អឹត ធុក ញ៉ាក ប៉ាក ម៉ង តៃ ឋាំ។ ");
INSERT INTO brb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","អ៊ែ ឡើ ដក់ ដាំង គូលី ហឹ បឹ លមូយ ទឹង ស្រុក មែ អ៊ិន។ បឹ ហង់អ៊ែ ឡើ ប៉្រៃ ណគ ដក់ ចៀម ជុរ ហឹ មឺរ។ ");
INSERT INTO brb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ឡើ ពងួត ទុត ខាក់ ញឹះ ឡើ ងុញ ចង់ អគ ជុរ ហាក់ ណាគ់ តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់អាំ ចណង់ ចណា ដើ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«តគ់ អ៊ែ ឡើ ចនិះ ភៀក ប្រយ ឡើ រៀន “ប៉ាគ់ នែ ម៉ាត អៃ នែ លែក មែ គូលី បើគ អៃ ហឹ តគ់ ម៉ើ ចង់ ចា ផិ ប៊ិង ស៊ិវ សាគ់ ណាគ់ គ្លឺយ ណគ់ ដើ អៃ ហឹ នែ អពងួត ស្រឹ អន់តាត់ ក្លាក ឞាល់ អ៊ិន។ ");
INSERT INTO brb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","អាះ ហយ អន់ជឹ ដាំង បើគ អៃ កឋឹះ អន់ជឹ ឡា ហឹ បើគ អៃ អន់រៀន ឡា បើគ អើយ អៃ អបើម យូច ម៉ាត ឡើយ ទឹង គ្រែដៃ ឡើ គូ ទឹង ហូង គ្រែ ដើម ដើ ហៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ឡា បើគ អើយ ឃឺ យ៉ាវ ហន់ជុ កួន ដើ អៃ ហន់ជុ មែ គូលី ឆិ អន់ណាវ បើគ”។ ");
INSERT INTO brb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","លែវ ឡើ ឃឹត ពអ៊ិន ឡើយ អ៊ែ ឡើ ជឹ ដាំង ប្រយ បើគ ណគ»។ «ហំប៊្រុះ បើគ ណគ ឡើ តៃ កួន អន់សូច ណគ តើម ប៊ឹង ចង៉ាយៗ ឡើ ស្រុស្រៀត តៃ ឋាំ អ៊ែ ឡើ ដក់ យ៉ាវ អម មុក មុញ កួន ណគ ដ្រិះៗ។ ");
INSERT INTO brb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","កួន អន់សូច ឡើ ហាយ ហឹ បើគ ណគ រៀន “ឡា បើគ អើយ អៃ អយូច ម៉ាត់ ម៉ាត ឡើយ ទឹង គ្រែដៃ ឡើ គូ ទឹង ហូង គ្រែ ដើម ដើ ហៃ ដិ។ តៃ លន់ឃឺ យ៉ាវ ហន់ជុ អៃ នែ កួន ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ហាក់ បើគ ណគ ឡើ ប៉្រៃ ឞយ ណគ រៀន “ដ្រិះ វន់ដក់ ចក់ ខូ អាវ ច្រណាប់ៗ ពទ្រូប ពហក កួន អៃ ដើម វន់ពទ្រូប ហន់ណក ប៊ឹង ទី ណគ ចក់ កើប អាំ ដើ ណគ លំទ្រូប។ ");
INSERT INTO brb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","មិញ វន់ចក់ កួន ឝ៉ូ ង៉ាយ ង៉ើ បយ៉ា ណគ់ ទិះៗ បិញៗ វន់កោះ អ៊ែ ងន់ចា ដើ កួន អៃ អាំ ងន់រ៉គ់សំ ឆំតក។ ");
INSERT INTO brb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","យ៉ាក់ កួន អៃ នែ ឡើ បើម ប៉ាគ់ ឡើ គែត តគ់ ណិះៗ ឡើ ញិវ ឡឹះ អន់ណាវ ពន់ឋើម ឡើ ហវ៉ារ់ ប៉ាត់ តគ់ ណិះៗ អតៃ ឡើ ជឹ ឡើយ។ អ៊ែ ម៉ើ ញែត ចង់ រ៉គ់ សំ ឆំតក ប្រយ”»។ ");
INSERT INTO brb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«ទឹង អ៊ែ កួន ឡង់ ណគ ណាគ់ ឡើ គូ ហឹ មឺរ តគ់ ឡើ ជឹ ហឹ ហន់ណាម ដៀប លំប៊ឹះ ឡើយ អ៊ែ ឡើ ដុង ភូះ ចំភូះ ម៉ើ ប៉្រិញ ថាះ ឝ៉ោះ ឝ៉ង រាំ ជ្រែង លែង ហវ៉ិច។ ");
INSERT INTO brb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","អ៊ែ ឡើ កឡូវ ឞយ មូយ រ៉ា ឡើ តង៉ា “អង់ង៉ាយ វ៉ើ បើម ហង់អ៊ិន ឞាល់ អ៊ិន អិះ”។ ");
INSERT INTO brb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ឞយ ឡើ ត្រណើវ រៀន “អោះ ហៃ ឡើ ជឹ ឡើយ បើគ ហៃ ឡើ ប៉្រៃ ញ៉ា កោះ កួន ឝ៉ូ ណគ់ ទិះៗ បិញៗ ញ៉ើ ចា ដើ ណគ យ៉ាក់ ឡើ ជឹ ចាគ់ៗ នៀមៗ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","បឹ ឡើ ឡង់ ឡើ មាំ ទុត ខាក់ ញឹះ តៃ ឡើ ឌី អ៊ឺម លំមឹត ទឹង ហន់ណាម អ៊ែ បើគ អំប្រា ឡើ ញឺះ អូរ កួន ឡង់ ណគ ច្រា មឹត ហឹ ហន់ណាម។ ");
INSERT INTO brb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","កួន ឡង់ នែ ឡើ ត្រណើវ បើគ ណគ រៀន “អៃ អគូ ពពឹត បបើម កយឹក ប៊ឹង ហៃ ឌុញ កម៉ ឞាល់ នែ ឡើយ ញឹះ តៃ អតើង ម៉ាង ហៃ បើគ អើយ ហម យ៉ះ កួន បប៊ែ មូយ អំប៉ម ណាគ់ តៃ ហអាំ ដើ អៃ អំចា ពរ៉គ់ ពន់សំ ប៊ឹង បូវ ប៊ែង អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","អ៊ែ តគ់ កួន ហៃ ឡើ ប៊ឹះ ហកោះ កួន ឝ៉ូ ទិះៗ បិញៗ ហចា ដើ ណគ។ ហង់ឝ្លាំង មូន មាំង ហៃ ណគ ឡើ ពលុប លែក តាក់ ញ៉ន ដើ កទ្រី”។ ");
INSERT INTO brb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","បើគ ណគ ឡើ តើវ ម៉ាង កួន ឡង់ ណគ រៀន “ឡា កួន អើយ ដើ ហៃ ហគូ ប៊ឹង អៃ អន់សច ឡើយ អង់ង៉ាយៗ អៃ អប៊ិច ឞាល់ ប្រនិច ហៃ ទឺ ឡើយ កួន។ ");
INSERT INTO brb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","អ៊ែ តគ់ ណិះៗ នែ ង៉ាយ ងន់ត្រ រ៉គ់សំ លែក ង៉ាយ ឡើយ កួន យ៉ាក់ អោះ ហៃ ពន់ឋើម ឡើ បើម ប៉ាគ់ ឡើ គែត ឡើយ ហាក់ តគ់ ណិះៗ ឡើ បើម ប៉ាគ់ ឡើ ញិវ ឡឹះ អន់ណាវ។ ណគ ឡើ ហវ៉ារ់ ប៉ាត់ តគ់ ណិះៗ ង៉ើ តៃ ឡឹះ អន់ណាវ”»។ ");
INSERT INTO brb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ លុកស៊ិក ណគ ឡឹះ រៀន៖ «ប៊ិច បនឹះ មូយ រ៉ា ឡើ ប៊ិច បាក់ ឡើ អាំ កាន ង៉ាន ដើ ឞយ ណគ ឡើ ប៉្រៃ លំរន់ឋាប់ ឝ្លាំង រ៉ាះ អំបាះ ណគ។ អ៊ែ ប៊ិច មែ ម៉ើ ដក់ ប៉ច ដើ កន់ដ្រាគ់ ណគ ម៉ើ រៀន “ឞយ ហៃ ឡើ តប៉ាត់ រ៉ាះ អំបាះ ហៃ ហណោះ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","យ៉ាគ់ ឡើ ប្រនិច ឡើ កឡូវ ប្រយ ឞយ ណគ ឡើ តង៉ា រៀន “ប៉ាគ់ ង៉ាយ ហបើម កាន ហៃ ណគ់ អដុង មែ ម៉ើ ហាយ? មិញ ហន់ខៀន ឡាំង ប៉ាគ់ ង៉ាយ ហបើម ដើ ប្រនិច អៃ យ៉ាក់ ដូវ យ៉ាវ ហំពឹត កាន ឡឹះ ដើ អៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ឞយ អ៊ែ ឡើ ឃឹត ទឹង ត្រពិត រៀន “កន់ដ្រាគ់ អៃ ឡើ អាំ យ៉ាវ អន់ឝ្លាំង រ៉ាះ អំបាះ ណគ ហឹ ង៉ាយ អន់ណាវ ឋូវ អន់ដាំង កាន ង៉ាន បើម? យ៉ាក់ អន់ចះ ពដិះ តៃ អំបក់ អ៊ឺម យ៉ាក់ អន់ដក់ ឡា លៀន កាក់ ហឹ បូវ អកម៉ាវ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","អូ ណោះ ឡើយ ប៉ាគ់ នែ អំបើម បក់ មែ ស៊្រុក មន់ចន់ដ្រា អៃ គូ ហឹ មែ តគ់ អន់ញឺះ តើម ប៊ឹង កាន ង៉ាន ណគ់ អន់នែ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","អ៊ែ ណគ ឡើ កឡូវ ណគ់ មែ ម៉ើ តង់ កន់ដ្រាគ់ ណគ មូយ រ៉ា មូយ តងៗ ត្រំ មែ ឡើ តង៉ា បឹ ឡើ ប៊ឹះ អន់នួរៗ រៀន “ហតង់ កន់ដ្រាគ់ អៃ ឡើ ណាគ់ ឞាល់ ង៉ាយ?”។ ");
INSERT INTO brb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","បឹ ឡើ តង់ ឡើ ត្រណើវ រៀន “ពុក មូយ ក្លាំ កធុង”។ បឹ ឡើ កឡា កខៀន ឡើ ហាយ រៀន “ហន់ចក់ ខនៀន ហៃ ហតង់ មែ ហន់ខៀន ពលិះ ដ្រិះៗ ហន់ជុ សើង ជិត កធុង អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ប៊្លី អ៊ែ ឡើ តង៉ា បឹ មូយ រ៉ា អន់ណាវ “ដើ ហៃ ដឹះ ឞាល់ ង៉ាយ ហតង់ កន់ដ្រាគ់ អៃ?”។ ឡើ ត្រណើវ រៀន “ចិះ មូយ ក្លាំ រែវ”។ បឹ កឡា កខៀន ឡើ ហាយ រៀន “ហន់ចក់ ខនៀន ហៃ អ៊ែ ហន់ខៀន ថាម ជិត រែវ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","កន់ដ្រាគ់ ណគ ឡើ ព្រតឹះ ឞយ តៃ ឡើ ទឹង ត្រ នែ យ៉ាក់ ឡើ ប៊ិច ហ្រឡិច ហ្រឡាង»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ឡឹះ រៀន៖ «បនឹះ តៃ ម៉ើ ដក់ តូយ គ្រែដៃ ម៉ើ ប៊ិច ហ្រឡិច ហ្រឡាង ដាំង ចា ជឺរ ណគ់ មែ ម៉ើ ដក់ តូយ គ្រែដៃ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«អៃ អង់ហាយ ដើ វែ រៀន វន់ចក់ ប្រនិច ណគ់ វ៉ើ ដូវ ទិ ឡាង ប្រិះ នែ វន់ព្រណាក អាំ ដើ មែ អ៊ែ វន់ប៊ិច បូវ ប៊ែង ចាំ អើន។ តគ់ តង៉ៃ ប្រនិច វែ លំប៉ាត់ ពណាត់ លែក តាក់ អ៊ែ ណាគ់ វន់ប៊ិច បូវ មន់ឡាប់ វែ ទឹង ហូង គ្រែ វន់គូ អរែង ប៊ឹង មែ ទឹង អ៊ែ ឡូច អន់សច។ ");
INSERT INTO brb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","មែ ង៉ាយ ម៉ើ ទឹង ត្រ ដើ កាន កិៗ មែ អ៊ែ ម៉ើ ទឹង ត្រ ដើ កាន ទិះៗ ប៉ាគ់ទឺ។ មែ ង៉ាយ តៃ ម៉ើ ទឹង ត្រ ដើ កាន កិៗ ណគ់ មែ អ៊ែ ដើ កាន ទិះៗ តៃ ម៉ើ ទឹង ត្រ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ប៉ាគ់ វែ តៃ វន់ទឹង ត្រ វន់យួរ ប្រនិច ទិ ឡាង ប្រិះ នែ ប៉ាគ់ ពអ៊ែ ប៉ាគ់ ង៉ាយ គ្រែដៃ លំហអ៊ឹន លំអាំ ប្រនិច ឡើ ប៊ិច ខា ម៉ាត់ ម៉ាត ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ប៉ាគ់ វែ តៃ វន់ទឹង ត្រ ដើ ប្រនិច បូវ ប៊ែង អ៊ែ គ្រែដៃ លំអាំ អ៊ឺម ដើ វែ រ៉ាះ អំបាះ ឡើ ប៊ិច ខា ម៉ាត់ ម៉ាត ណគ់ ឡើ ជុ ដើ វែ ទឹង ហូង គ្រែ ទិ។ ");
INSERT INTO brb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម លំបើម ឞយ មូយ រ៉ា ណគ បារ កន់ដ្រាគ់ យ៉ាក់ តគ់ ហន់ណូវ លំម៉ើត ឌិវ មូយ រ៉ា ណគ់ លមូយ លំរែម អ៊ឺម លំអៀល បឹះ ដើ បឹ មូយ រ៉ា ណគ់ បឹ មូយ រ៉ា លំឝ្លីង ឝ្លាំង រាំង តាក់។ វែ លែក រ៉ា ដូវ អ៊ឺម វន់អៀល បឹះ គ្រែដៃ ដិ វន់ងុញ រ៉ាះ អំបាះ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","មែ ផារីស៊ី ម៉ើ ដុង ប៉ាគ់ អ៊ែ ម៉ើ ឞឞើះ លឡើះ គ្រែដៃ យែស៊ូ យ៉ាក់ ម៉ើ ងុញ លៀន ម៉ៃ ហ៊ែត។ ");
INSERT INTO brb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «វែ វ៉ើ ពឃឺ ពរ៉គ់ ឌិវ តៃ ពឺង ដើ បូវ មន់តៃ អ៊ែ បក់ មន់រៀន វែ វ៉ើ បនឹះ ចាគ់ ទឹង ត្រ ហាក់ គ្រែដៃ ឡើ ណោះ ចនិះ ក្លើម វែ។ ណគ់ អង់ង៉ាយៗ បនឹះ ម៉ើ តៃ រៀន ឡើ ប៊ិច ខា ដើ គ្រែដៃ ឡើ ហំម៉ឹ តៃ ឋាំ។ ");
INSERT INTO brb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ពឹម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ដើម ពឹម មែ ម៉ើ ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ព្រតូវ បនឹះ តើម ប៊ឹង ពន់ឋើម ឆា ដើ យ៉ាគ់ យ៉ូហាន តម៉ូច ដាក ឡើ ប៊ឹះ។ ហាក់ តើម ប៊ឹង អ៊ែ អៃ អពហាយ កាន ចាគ់ យ៉ាគ់ គ្រែដៃ ឡើ ពែក ប៉ាក់ អ៊ែ បនឹះ ត្រំ រ៉ា ម៉ើ ខំ មឹត ហឹ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ហម ឡាង ពដិះ គ្រែ លំប៉ាត់ ពណាត់ ហាក់ ប្រម៉ាង ទឹង ពឹម គ្រែដៃ លំណាគ់ ដឌែ យ៉ះ កន់ដ្រៀះ កិៗ មូយ អំប៉ម ទឹង សំឞ៊ុត ណាគ់ តៃ លំប៉ាត់ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«បឹ អង់ង៉ាយ ឡើ តាក់ ទ្រី ឡើ ចក់ ទ្រី ហន់ដើម កឡ អ៊ែ ឡើ ឡើះ ទ្រី ឡើយ។ អ៊ែ ណគ់ កឡ ឡើ ចក់ កទ្រី ក្ល ណគ ឡើ តាក់ គ្រែដៃ ឡើ រៀន កឡ អ៊ែ ឡើ បើម យូច ចឞាប់ ទ្រី ក្ល ប៉ាគ់ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«ប៊ិច កឡ មូយ រ៉ា ឡើ ប្រនិច ប្រវ៉ើន ហណក ណគ ចាគ់ៗ ម៉ាត់តូវ ច្រណាប់ៗ។ ឡើ គូ ហ្រនុក ហ្រវ៉ាក ប៊ិច កយ៉ិ ចង់ ចណង់ ចា ញឹមៗ ស៊ិវ សាគ់ ណាគ់ គ្លឺយ ត្រំ តង៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ប៊ិច កឡ មូយ រ៉ា អន់ណាវ ឡើ ធុក ញ៉ាក ម៉ាត់ ណគ ឡាសា ឡើ ជឺគ ប៊ិង ចាក់ មែ ទឹង ស្រ៊ុក ម៉ើ ដក់ ជុ ពឝ៉ី ណគ តគ់ ឝឡោះ រំឞង ហន់ណាម បឹ ឡើ ប៊ិច បាក់។ ");
INSERT INTO brb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ឡាសា ឡើ ងុញ ចង់ ចា កយ៉ិ អគ ឡើ រុះ តើម ប៊ឹង តូគ បឹ ឡើ ប៊ិច បាក់ ដើម ច ម៉ើ ដក់ ឆាវ ជឺគ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","តង៉ៃ ហង់អ៊ិន បឹ ឡើ ធុក ញ៉ាក ឡើ គែត អ៊ែ បូវ ឞាវ គ្រែដៃ ម៉ើ ចក់ ពឌឹក តៀត ណគ គូ អរែង ទឹង យ៉ាគ់ អាប្រាហាំ តគ់ ប៊្លី អ៊ែ បឹ ឡើ ប៊ិច បាក់ ឡើ គែត ប៉ាគ់ទឺ អ៊ែ មែ ទឹង ស្រ៊ុក ម៉ើ ដក់ ចះ កុប ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","«ហឹ ឞន មួង កយ៉ក់ បឹ ឡើ ប៊ិច បាក់ នែ ឡើ ធុក ញ៉ាក តៃ ឋាំ អ៊ែ ឡើ ង៉ើយ ឝ្លាំង ទឹង ពឺង ឡើ តៃ យ៉ាគ់ អាប្រាហាំ តើម ប៊ឹង ចង៉ាយៗ ដើម ឡាសា ឡើ គូ ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ណគ ឡើ កឡូវ យ៉ាគ់ អាប្រាហាំ រៀន “ឡា យ៉ាគ់ អ អើយ ហន់ស្រុស្រៀត អៃ ដិ អុះ ហំប៉្រៃ ឡាសា លន់ចូប ត្រពួច ទី ណគ ទិ ដាក លែង កិៗ លំដក់ ហន់តួច ទឹង ហពៀត អៃ អ៊ែ លំឝ្លីម យ៉ាក់ អគូ ទិ កនុង អ៊ុញ នែ អធុក ញ៉ាក ឞាល់ អ៊ិន”។ ");
INSERT INTO brb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","យ៉ាគ់ អាប្រាហាំ ឡើ តើវ ណគ រៀន “ចូវ អើយ ហន់ចនិះ ទឹង ណាគ់ ហញិវ ពន់ឋើម ហៃ ហហ្រនុក ហ្រវ៉ាក តាក កើត អ៊ែ ដើ ឡាសា អន់ណាវ ឡើ ធុក ញ៉ាក ប៉ាក ម៉ង អ៊ែ ណិះៗ នែ ឡើ រ៉គ់សំ ឆំតក អន់ណាវ ណគ់ ដើ ហៃ ហន់ធុក ញ៉ាក ហឹ អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","មូយ អន់ណាវ ឡើ ប៊ិច ហ៊ុង ហាំង ឈ្រុ ឡើ កះ ប្លះ ង៉ាយ សំ យ៉ះ មែ ង៉ាយ មន់ងុញ ក្លង តើម ប៊ឹង ញ៉ា ហឹ វែ ណាគ់ តៃ ម៉ើ ដូវ អ៊ឺម លឺ ម៉ើ ងុញ ក្លង តើម ប៊ឹង វែ ហឹ ញ៉ា ណាគ់ តៃ ម៉ើ ដូវ ក្លង អ៊ឺម ប៉ាគ់ទឺ”»។ ");
INSERT INTO brb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«បឹ ឡើ ប៊ិច បាក់ ឡើ ឡា ឡូម ឡឹះ រៀន “ឡា យ៉ាគ់ អ អើយ ប៉ាគ់ ពអ៊ែ ហំប៉្រៃ ឡាសា លន់ជឹ ហឹ ហន់ណាម បើគ អៃ អន់ដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","យ៉ាក់ អប៊ិច អំម៉ោះ អោះ ម៉ាត់តូវ កឡៗ សើង រ៉ា ហំប៉្រៃ ឡាសា លំដក់ ហាយ ដើ មែ អាំ មន់ណោះ លវាំង ចាក់ អ៊ែ ញ៉ង មន់ដក់ ហឹ ឞន ធុក ញ៉ាក ប៉ាគ់ ដើ អៃ នែ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន “អំម៉ោះ អោះ ហៃ ចូវ អើយ ម៉ើ ប៊ិច ពឹម យ៉ាគ់ ម៉ូស៊ែ ដើម ពឹម មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ តាក់ ដើ មែ មន់ចង់ហៀង ប្រម៉ាង មែ ម៉ើ ព្រតូវ ហឹ អិះ ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","បឹ ឡើ ប៊ិច បាក់ ឡើ ត្រណើវ យ៉ាគ់ អាប្រាហាំ រៀន “អ៊ឺម យ៉ាគ់ អ អើយ! ម៉ើ ចង់ហៀង អ៊ឺម តៃ កា ប៊ិច មែ មន់ជឹ ពហាយ តើម ប៊ឹង បូវ ង៉ាយ ង៉ើ គែត នែ ឡើយ អ៊ែ មន់ឌី ពលិះ ចនិះ”។ ");
INSERT INTO brb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ហាក់ យ៉ាគ់ អាប្រាហាំ ឡើ ត្រណើវ រៀន “ប៉ាគ់ តៃ មន់ឌី ចង់ហៀង ប្រម៉ាង យ៉ាគ់ ម៉ូស៊ែ ដើម មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ហម យ៉ះ បនឹះ លំញិវ តើម ប៊ឹង គែត លន់ជឹ ពហាយ ដើ មែ ណាគ់ តៃ មន់ឌី ចាប់ ប៉ាគ់ទឺ ឡើយ”»។ ");
INSERT INTO brb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","គ្រែដៃ យែស៊ូ ឡើ ហាយ ហឹ បូវ លុកស៊ិក ណគ រៀន៖ «ប៊ិច កាន អើន ឡើ បើម អាំ បនឹះ គ្លីះ ទឹង ឞាប។ ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ចន់ដ្រា បូវ បើម ឞាប មែ អ៊ែ ឡើយ មន់ធុក ញ៉ាក ម៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ណគ់ បនឹះ អ៊ែ ប៉ាគ់ ប្រមែ មន់ចក់ តវ៉ាវ ក្រលីត ចង ប៊ឹង ដង់ ណគ ប៊្លី អ៊ែ មន់ផាត់ កលីះ ណគ ទិ ដាក សមុត អ៊ែ លន់ចាគ់ ជឺរ ហំប្លះ លំញិវ អង់ឝ៉ាន់ លន់ចន់ដ្រា មែ លុកស៊ិក អៃ តៃ ដាន់ ម៉ើ ឝ៉្រឹត អំម៉ឹះ មន់គ្លីះ ទឹង ឞាប ប៉ាគ់ ដើ ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","យ៉ាក់ ប៉ាគ់ អ៊ិន វន់លវាំង យ៉ឹ ចាក់ វែ កឡឹ។ ប៉ាគ់ អំម៉ោះ អោះ ហៃ លំបើម អន់យូច ហន់គឹះ ព្រតូវ ណគ ដិ ប៉ាគ់ ណគ លំពលិះ ចនិះ ក្លើម ហន់តាក់ តណាក់ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ប៉ាគ់ ណគ លំបើម អង់យូច ហឹ ហៃ មូយ តង៉ៃ ប៉ឹះ តង ប៉ាគ់ ណាគ់ លន់ជឹ ដាំង ឡឹះ ហៃ ប៉ឹះ តង ប៉ាគ់ទឺ ឡើ រៀន “អធឹច តៃ ការ អបើម យូច ដើ ហៃ អុះ” អ៊ែ ហន់តាក់ តណាក់ ដើ ណគ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","បូវ លុកស៊ិក ម៉ើ ឡា ហឹ គ្រែដៃ យែស៊ូ ឡើ កន់ដ្រាគ់ ម៉ើ រៀន៖ «ឡា ហំប្រាយ ញ៉ា ញំមឹង ហៃ អាំ ឝ៉្រឹត ហម នែ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ប៉ាគ់ វ៉ើ មឹង អៃ កិៗ ឌិត អង់គុង ក្លិត គ្លែត វន់ប៉្រៃ តើម ឡង ទិះ នែ រៀន “ហឹ ហន់ទុច ឡាំង រៀះ ហៃ ហន់ទឺះ ហួន ទិ សមុត ចុ”។ មូយ លន់ចង់ហៀង ម៉ាត់ ម៉ាត ឡើយ ម៉ាង វែ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«ទឹង កនុង បូវ វែ ប៉ាគ់ មូយ រ៉ា លំប៊ិច ក៝ត ថៃ ណា លឺ ពែក បណាន់ ក៝ត អ៊ែ តគ់ ឡើ ជឹ ហឹ ហន់ណាម តៃ ប៊ិច អ៊ឺម ញឹះ កន់ដ្រាគ់ ណគ លន់ច្រា រៀន “នែ ហន់ដ្រូម ចង់ ចា អន់ដៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ហរ៉ើម លំប៉្រៃ ក៝ត ណគ រៀន “ហំបើម ចណង់ ចណា ដើ អៃ ប៊្លី អ៊ែ ហំបើម ចាក់ ចាគ់ៗ ហន់វ៉ក់ ចណង់ ចណា ដើ អៃ អន់ចង់ អន់ដៃ។ អៃ អន់ចង់ លែវ ឡើយ ប៊្លី អ៊ែ ហៃ អន់ណាវ ហន់ចង់”។ ");
INSERT INTO brb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ប៊ិច អ៊ឺម កន់ដ្រាគ់ អ៊ែ លំព្រតឹះ ក៝ត សំ លន់ចាប់ លហម លែក ដើ ពន់ដ្រៃ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ណគ់ ដើ វែ អន់ណាវ ប៉ាគ់ទឺ អិះ ឡើយ ប៉ាគ់ វ៉ើ បើម កាន គ្រែដៃ ណគ ឡើ ប៉្រៃ វែ ក្លើច ឡើយ អ៊ែ វន់រៀន “ឡើ ឃឺ អ៊ឺម ហំព្រតឹះ ញ៉ា នែ យ៉ាក់ ឌិវ ង៉ាយ ហប៉្រៃ ញ៉ើ ពឹត ហវ៉ៃ អ៊ែ ញ៉ើ ពឹត”»។ ");
INSERT INTO brb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ទឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ ហឹ មួង យែរូសាឡឹម ឡើ ដក់ ប្លះ ប្រឡា ស្រុក សាម៉ារី ប្លះ ស្រុក ឝ៉ាលីលែ។ ");
INSERT INTO brb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","តគ់ ឡើ មឹត ទឹង ស្រ៊ុក លមូយ ប៊ិច បនឹះ ស៊ិត ស៊ូត ជិត រ៉ា ម៉ើ ដក់ ដាំង ណគ។ ម៉ើ ឆុង តើម ប៊ឹង ចង៉ាយៗ ");
INSERT INTO brb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ម៉ើ កឡូវ រៀន៖ «អើយ ណាយឃូ យែស៊ូ អើយ ហន់ស្រុស្រៀត បៀត ញ៉ា ដិ អុះ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","គ្រែដៃ យែស៊ូ ឡើ ឝ្លាំង ហឹ មែ អ៊ែ ឡើ រៀន៖ «មិញ វន់ដក់ ពដៃ ចាក់ វែ ហឹ មែ កឡា បប៊ុះ ថួយ តគ់ »។ ទឹង ម៉ើ ដក់ ហឹ អ៊ែ ម៉ើ នៀម ប្រយ តូច ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","តគ់ បឹ មូយ រ៉ា ឡើ តៃ ចាក់ ណគ ឡើ នៀម ស្រើវ ឡើ ជឹ វឹញ ហឹ ទឺ ដើម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ថាំងៗ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ឡើ កដាប ហំបះ ប៊ឹង ឈឹង គ្រែដៃ យែស៊ូ ត្រងឺវ ទូត ប្រិះ ឡើ ព្រតឹះ ព្រនែ យែស៊ូ យ៉ាក់ ឡើ បើម អន់នៀម ណគ។ បឹ ហង់អ៊ែ ឡើ សុនសាត សាម៉ារី។ ");
INSERT INTO brb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «ពយ៉ិ បនឹះ លែក ជិត រ៉ា តៃ ម៉ើ នៀម អ៊ឺម ឡះ? ហឹ ង៉ាយ ដឹះ អន់ណាវ មែ ជែន រ៉ា អ៊ែ ម៉ើ គូ? ");
INSERT INTO brb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ពយ៉ិ អន់នែ ដឹះ ឌិវ សុនសាត មែ គែង មូយ រ៉ា ឡើ ជឹ វឹញ ព្រតឹះ ព្រនែ គ្រែដៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ហឹ ណគ រៀន៖ «ហន់ឌឹក ហំមិញ ឆិ ឡើយ អ៊ែ ហន់ជឹ។ យ៉ាក់ ហមឹង អៃ អ៊ែ ហនៀម»។ ");
INSERT INTO brb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","បូវ មែ ផារីស៊ី ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «តង៉ៃ ង៉ាយ គ្រែដៃ លំប៊ឹះ ពែក ប៉ាក់?»។ ណគ ឡើ តើវ មែ រៀន៖ «ទឹង គ្រែដៃ លំប៊ឹះ ពែក ប៉ាក បនឹះ មន់តៃ អ៊ឺម ដើ ម៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ដូវ អ៊ឺម មន់ម៉ាង រៀន “គ្រែដៃ ឡើ ពែក ប៉ាក់ ហឹ តគ់ លឺ ហឹ នែ”។ វន់ចង់ហៀង អាំ ហឡាក់ៗ ឋាយ គ្រែដៃ ឡើ ពែក ប៉ាក់ ឡើ គូ អរែង ប៊ឹង វែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ប៊្លី អ៊ែ ឡើ ហាយ ហឹ លុកស៊ិក ណគ រៀន៖ «តគ់ ខៃ ណូវ ទុត ម៉ៃ វន់ក្រើយ វន់ងុញ តៃ តង៉ៃ កួន បនឹះ លំប៊ឹះ ហាក់ វន់តៃ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ប៊ឹង អ៊ែ លំប៊ិច បនឹះ មន់ហាយ ដើ វែ រៀន “គ្រែដៃ គ្រិះ ឡើ គូ ហឹ តគ់ លឺ ហឹ នែ” ញ៉ង វន់ដក់ យ៉ាវ ឝ្លាំង ឆ្រឡិ អ៊ឺម តូយ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","តគ់ តង៉ៃ កួន បនឹះ លំប៊ឹះ ឡឹះ បនឹះ លែក រ៉ា មន់តៃ ឡើយ ណគ យ៉ាក់ លំបើម ប៉ាគ់ គ្រែ លលីប ហ្រប្ល៊ីប ឡាត់ ឈឹង គ្រែ ឈឹង គ្រឹម។ ");
INSERT INTO brb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ហាក់ កួន បនឹះ អ៊ិន លំត្រ ធុក ញ៉ាក ប៉ាក ម៉ង ទុត ខាក់ អន់ដៃ ដើម បនឹះ តណើរ ណិះៗ មន់តាក់ តណាក់ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«តគ់ ប៉ាង កួន បនឹះ លំប៊ឹះ លំបើម ប៉ាគ់ ទឹង ប៉ាង យ៉ាគ់ ណូអ៊ែ ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ទឹង ប៉ាង អ៊ែ បនឹះ វ៉ិះ ឌិវ ម៉ើ ឃឹត ញញែត ចចង់ ប្រយ៉ង់ ប្រយ៉ា ចក់ ទ្រី ក្ល ឆា ដើ ប៊ឹះ តង៉ៃ យ៉ាគ់ ណូអ៊ែ ឡើ មឹត ទឹង ឌូក ទិះ អ៊ែ ដាក ឡើ លែប ក្រលឺង បនឹះ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","តគ់ ប៉ាង កួន បនឹះ លំប៊ឹះ ឡឹះ លំបើម ប៉ាគ់ ទឹង ប៉ាង យ៉ាគ់ ឡុត ទឺ ទឹង អ៊ែ បនឹះ ម៉ើ ញញែត ចចង់ ហំពួត រួត បើម មឺរ បើម ណា ដើម ម៉ើ បើម ហន់ណាម ក្រាន ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","តគ់ តង៉ៃ យ៉ាគ់ ឡុត ឡើ វីះ តើម ប៊ឹង មួង សូដំ ប៊ិច ពឡា អ៊ុញ ដើម ក្រលៀត អ៊ុញ ឡើ គ្លីះ តើម ទិ គ្រែ ឡើ បើម ប៉ាគ់ អំមឺ ឡើ បលុ បនឹះ ទិ មួង សូដំ លែក តាក់។ ");
INSERT INTO brb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ហឹ តង៉ៃ កួន បនឹះ លន់ជឹ វឹញ ពដៃ ចាក់ លន់កើត ប៉ាគ់ អ៊ែ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«ទឹង តង៉ៃ អ៊ែ ណគ់ មែ ម៉ើ គូ ពឺង បូយ ហន់ណាម ដើម ប៊ិច រ៉ាះ អំបាះ ទឹង កនុង ហន់ណាម សណូវ មន់មឹត ចក់ អ៊ឺម រ៉ាះ មែ មន់ត្រ អ្រយ៉ាវ ប៉ាត់ តាក់។ អ៊ែ ណគ់ មែ ម៉ើ គូ ហឹ មឺរ សណូវ អ៊ឺម មន់ជឹ វឹញ ចក់ រ៉ាះ មែ ហឹ ស៊្រុក មន់ត្រ អ្រយ៉ាវ ប៉ាត់ តាក់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","វែ វន់ចនិះ ហឹ ទ្រី យ៉ាគ់ ឡុត ពន់ឋើម ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ណគ់ មែ ម៉ើ ខំ ដាំង កាន ញិវ ទិ ឡាង ពដិះ នែ មែ អ៊ែ មន់ត្រ គែត ប៉ាត់ ឡើយ ហាក់ ណគ់ មែ ង៉ាយ ម៉ើ ឌី តាក់ កាន ញិវ មែ មែ អ៊ែ មន់ញិវ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","អៃ អង់ហាយ ដើ វែ រៀន មាំង អ៊ែ លំប៊ិច បនឹះ បារ រ៉ា អំប្រា កី អរែង មូយ ឝ្រែ គ្រែដៃ លំចក់ មូយ រ៉ា លំជុ មូយ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","លំប៊ិច កទ្រី បារ រ៉ា អំប្រា តវ៉ិះ អរែង គ្រែដៃ លំចក់ មូយ រ៉ា លំជុ មូយ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(លំប៊ិច កឡ បារ រ៉ា អំប្រា គូ ហឹ មឺរ គ្រែដៃ លំចក់ មូយ រ៉ា លំជុ មូយ រ៉ា»។) ");
INSERT INTO brb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","បូវ លុកស៊ិក ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ អើយ ហឹ ង៉ាយ ដឹះ កាន លែក នែ លន់កើត?»។ គ្រែដៃ យែស៊ូ ឡើ តើវ រៀន៖ «ពត្រូវ ម៉ើ គែត ហឹ ង៉ាយ ជែម មិត ម៉ើ តមួត ហឹ អិះ ទឺ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ពហាយ កាន ព្រឌីវ ព្រតូវ លុកស៊ិក ណគ តង មន់អ៊ឺរ ដាំង គ្រែដៃ អន់សច ញ៉ង មន់ប៊ិច ចនិះ អល អ៊ឺម ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«ទឹង មួង មូយ ប៊ិច កឡា តាត់ កឍី មូយ រ៉ា ឡើ បនឹះ តៃ អៀល បឹះ គ្រែដៃ ដើម ញឹះ តៃ ឡើ ឌូង ដើ មែ ង៉ាយ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","អ៊ែ ប៊ិច ម៉ិ យូ កម៉ាយ មូយ រ៉ា ទឹង កនុង មួង ហង់អ៊ែ ទឺ ឡើ ដក់ ឡា ឡូម ដឌែ ហឹ កឡា តាត់ កឍី រៀន “ឡា យ៉ាគ់ អ អើយ ហន់តាត់ កឍី អាំ ត្រៗ ដើ អៃ អុះ យ៉ាក់ ម៉ើ បើម អង់យូច ម៉ាត់ ម៉ាត ដើ អៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ហាក់ កឡា តាត់ កឍី ឡើ ឌី អ៊ឺម លំពឹត កាន ដើ ណគ ដ្រិះៗ ឡើ ពញ៉ាក ដើ ប្រណគ ទុត ឌុញ។ ប៊្លី អ៊ែ ឡើ ឃឹត អង់ឃឹត រៀន “សំយ៉ះ អៃ តៃ អអៀល បឹះ គ្រែដៃ តៃ អឌូង ដើ មែ ង៉ាយ កតាម ");
INSERT INTO brb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","តង អន់តាត់ កឍី អាំ ត្រៗ ដើ ម៉ិ យូ កម៉ាយ អន់នែ ប៉ាគ់ អៃ តៃ អន់តាត់ កឍី ដើ ណគ អាត លំដក់ ពខើក ដឌែ ឡើយ ហឹ អៃ ឝ៉ាន់ អន់សាម អន់ចង់ហៀង ម៉ាង ណគ អន់ទឺៗ”»។ ");
INSERT INTO brb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ អន់ណាវ រៀន៖ «វន់ឃឹត ឡាំង ណគ់ ប្រម៉ាង កឡា តាត់ កឍី តៃ ឡើ ទឹង ត្រ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","អ៊ែ ដើ គ្រែដៃ អន់ណាវ សរ៉ើម លំដាំង កាន ត្រ លន់អាំ ដើ បនឹះ ណគ ឡើ រ៉ើះ ណគ់ មែ ម៉ើ អ៊ឺរ ដាំង ណគ ម៉ាត់ ម៉ើ កឡះ ហូ តង៉ៃ ដើម មាំង គ្រែដៃ លំពឌុញ អ៊ឺម ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","អៃ អង់ហាយ ដើ វែ រៀន គ្រែដៃ លំដាំង កាន ត្រ ដើ មែ ដ្រិះៗ ហឹតៗ។ ហាក់ តគ់ កួន បនឹះ លំប៊ឹះ ទិ នែ ឡឹះ ណាគ់ លំតៃ ឋូវ បនឹះ មន់ចាប់ មឹង ណគ ទឹង ឡាង ប្រិះ នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ មូយ ឡឹះ អន់ណាវ ដើ មែ អន់នឺ រ៉ា ណគ់ ម៉ើ ឃឹត រៀន មែ កឡឹ ម៉ើ ចាគ់ ទឹង ត្រ កនុង អ៊ែ ម៉ើ ឝ្លីង ឝ្លាំង រាំង តាក់ ហឹ បូវ។ ");
INSERT INTO brb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ប៊ិច កឡ បារ រ៉ា អំប្រា ឌឹក អ៊ឺរ ដាំង គ្រែដៃ ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ បឹ ផារីស៊ី មូយ រ៉ា ដើម បឹ កាគ់ លៀន មូយ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","បឹ ផារីស៊ី ឡើ ឆុង មូយ រ៉ា ណគ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ឡើ ម៉ាង រៀន “ឡា គ្រែដៃ អើយ អព្រតឹះ ព្រនែ ហៃ ត្រ អ៊ឺម អៃ នែ ប៉ាគ់ បូវ មែ គែង បូវ មែ អ៊ែ ម៉ើ បនឹះ តទូង បនឹះ តបូត ម៉ើ បនឹះ ឡើះ ច្រើន។ អៃ នែ តៃ ត្រ ប៉ាគ់ បឹ ឡើ កាគ់ លៀន អ៊ែ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","អៃ អអឹត ចណង់ ចណា កនុង មូយ អាទិត បារ តង ដើម ណគ់ អង់ង៉ាយៗ អៃ អដូវ ដាំង កនុង ជិត អម៉ប ដើ ហៃ មូយ”។ ");
INSERT INTO brb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ណគ់ ដើ បឹ ឡើ កាគ់ លៀន អន់ណាវ ឡើ ឆុង ចង៉ាយៗ ដើម តៃ ឡើ ហាន ង៉ើយ ឝ្លាំង អ៊ឺម ទឹង គ្រែ ឡើ ទឹម គ្រឹក ឡើ ធឹច ចាក់ ណគ ឡើ បើម អន់យូច ឡើ អ៊ឺរ ដាំង ហឹ គ្រែដៃ រៀន “ឡា គ្រែដៃ កន់ដ្រាគ់ អើយ អឡា ហន់ស្រុស្រៀត អៃ អុះ អបនឹះ ប៊ិច ឞាប”។ ");
INSERT INTO brb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","អៃ អង់ហាយ ដើ វែ រៀន តគ់ អំប្រា ជឹ ហឹ ហន់ណាម ណគ់ បឹ ឡើ កាគ់ លៀន អ៊ែ គ្រែដៃ ឡើ ជុ ណគ បនឹះ ចាគ់ ទឹង ត្រ អ៊ែ ណគ់ ដើ បឹ ផារីស៊ី អន់ណាវ គ្រែដៃ ឡើ ជុ ណគ បនឹះ តៃ ចាគ់ ទឹង ត្រ អ៊ឺម។ មែ ង៉ាយ ម៉ើ ពឌឹក ចាក់ មែ អ៊ែ គ្រែដៃ ឡើ ពន់ដាប មែ ង៉ាយ ម៉ើ ពន់ដាប ចាក់ មែ អ៊ែ គ្រែដៃ ឡើ ពឌឹក អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ប៊ិច មែ ម៉ើ ដក់ តៀត អង់គ្លែត ហឹ គ្រែដៃ យែស៊ូ ម៉ើ ឡា ណគ លំជុ ទី ប៊ឹង មែ បក់ លំប្រាយ ហ្រនុក ដើ មែ។ ម៉ើ តៃ ប៉ាគ់ អ៊ែ មែ លុកស៊ិក ម៉ើ គឹះ ប្រយ មែ កឡា តៀត អង់គ្លែត អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ហាក់ គ្រែដៃ យែស៊ូ សរ៉ើម ឡើ ប៉្រៃ មែ អង់គ្លែត មន់ដក់ ហឹ ណគ ឡើ ម៉ាង ដើ មែ លុកស៊ិក អ៊ែ រៀន៖ «វន់អាំ មែ មន់ដក់ ហឹ អៃ ប៉ាគ់ អិះ ឡើយ ញ៉ង វ៉ើ កំប៊ែត អ៊ឺម មែ យ៉ាក់ វ៉ិះ ឌិវ មែ ម៉ើ ប៊ិច ចនិះ ក្លើម ប៉ាគ់ មែ អង់គ្លែត ណិះ ឡើយ គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន មែ ង៉ាយ តៃ ឡើ អាំ គ្រែដៃ លំពែក ប៉ាក់ ណគ ប៉ាគ់ ដើ មែ អង់គ្លែត នែ ទឺ ណគ អ៊ែ ដូវ អ៊ឺម លំមឹត ទឹង ឞន គ្រែដៃ លំពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ប៊ិច បនឹះ ទិះ ក្រាគ់ មូយ រ៉ា ឡើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ណាយឃូ ហបនឹះ ចាគ់ អើយ ប៉ាគ់ ង៉ាយ ដើ អៃ នែ អំបើម អ៊ែ អន់ដូវ ញិវ ឡូច អន់សច?»។ ");
INSERT INTO brb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ប៉ិ ត្រ ហរៀន អៃ អបនឹះ ចាគ់ ប៉ាគ់ អ៊ិន? តៃ ប៊ិច មែ ង៉ាយ អ៊ឺម មន់ចាគ់ គែង គ្រែដៃ មូយ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ហៃ ហណោះ ឡើយ ចឞាប់ គ្រែដៃ ឡើ ម៉ាង រៀន ញ៉ង ឡើះ ច្រើន ញ៉ង កជែត បនឹះ ញ៉ង តទូង ចចក់ ញ៉ង ចឹន ឆ្រឡិ បូវ តង វន់ខរ៉ុប មែគ បើគ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","យ៉ាគ់ ហង់អ៊ែ ឡើ ត្រណើវ រៀន៖ «អៃ អបើម ត្រួយ ពន់ដ្រៃ លែក អ៊ែ ណាគ់ តើម ប៊ឹង អអង់គ្លែត ពន់ឋើម ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ទឹង គ្រែដៃ យែស៊ូ ឡើ ដុង ប៉ាគ់ អ៊ែ ឡើ ហាយ ដើ យ៉ាគ់ ហង់អ៊ែ រៀន៖ «ណាគ់ មូយ អន់ណាវ តៃ ហបើម អំម៉ឹះ តង ហន់ចក់ រ៉ាះ អំបាះ ហៃ ណគ់ ហប៊ិច ហន់ដក់ ហំពួត អ៊ែ ហំព្រណាក លៀន ដើ មែ ធុក ញ៉ាក។ ប៉ាគ់ ហំបើម ប៉ាគ់ អ៊ិន អ៊ែ ហំប៊ិច ប្រនិច ប្រណាក់ ទឹង ហូង គ្រែដៃ ទិ។ ប៊្លី អ៊ែ ហន់ដក់ តូយ អៃ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ទឹង ឡើ ដុង គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ឡើ គូ ស្រៀវ ឝ្រង៉ូវ ប្រយ យ៉ាក់ ឡើ ប៊ិច បាក់ តៃ ឋាំ។ ");
INSERT INTO brb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","គ្រែដៃ យែស៊ូ ឡើ តៃ ណគ ឡើ គូ ស្រៀវ ឝ្រង៉ូវ ប៉ាគ់ អ៊ែ ឡើ ម៉ាង រៀន៖ «ណគ់ បនឹះ ប៊ិច បាក់ ញ៉ាក ខាក់ៗ មន់មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ណាគ់ ហយ រោះ លំមឹត ទឹង ត្រម កិះ ហំប្លះ បនឹះ ប៊ិច បាក់ មន់មឹត ទឹង កាន គ្រែដៃ ឡើ ពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","មែ ម៉ើ ដុង ណគ ឡើ ហាយ ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ «យ៉ាក់ ប៉ាគ់ អ៊ិន មែ ង៉ាយ ដឹះ មន់ដូវ កាន ហវ៉ាត់?»។ ");
INSERT INTO brb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ណគ់ អង់ង៉ាយ បនឹះ តៃ ម៉ើ ណោះ បើម គ្រែដៃ ឡើ ណោះ បើម លែក អិះ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ពែត្រុះ ឡើ ត្រណើវ ណគ រៀន៖ «ហៃ ហតៃ ឡើយ ដើ ញ៉ា ណគ់ អង់ង៉ាយៗ ញ៉ា ញ៉ើ ប៊ិច ញ៉ើ តាក់ លែក អ៊ែ ញ៉ើ តូយ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ លុកស៊ិក ណគ រៀន៖ «ណគ់ ខាក់ៗ អៃ អង់ហាយ ដើ វែ រៀន មែ ង៉ាយ ម៉ើ សឡាគ់ តាក់ ហន់ណាម ក្រាន កួន ទ្រី មែគ បើគ អំម៉ោះ អោះ អូយ ញ៉ន ដើ ម៉ើ ឌី គ្រែដៃ លំពែក ប៉ាក់ មែ ");
INSERT INTO brb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","មែ អ៊ែ សរ៉ើម មន់ដូវ ស៊ឺក ពឺង អ៊ែ អន់ណាវ ណិះៗ នែ ដើម មន់ញិវ ឡូច អន់សច ហឹ ងឺរ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","គ្រែដៃ យែស៊ូ ឡើ ចន់ដ្រា លុកស៊ិក ណគ លែក ជិត បារ រ៉ា ឡះ តើម ប៊ឹង បូវ ដក់ ហឹ ណគ អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «វែ វ៉ើ ណោះ ឡើយ ង៉ាយ នែ ង៉ើ ឌឹក ទឹង មួង យែរូសាឡឹម។ តគ់ ងំប៊ឹះ ទឹង អ៊ែ លែក ដើ កាន កួន បនឹះ ណគ់ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ើ ខៀន ជុ ពន់ឋើម លំប៊ិច ទឹង មួង អ៊ែ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","មែ ក្លាង ស៊្រុក មន់រ៉ាប់ ឈូន ណគ ហឹ សុនសាត គែង អ៊ែ មន់ចអាវ ពាសាល់ ពន់ឆាំ មន់តំឞាប ណគ ដើម មន់កយ៉ុះ ក្រហាក ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ប៊្លី អ៊ែ មន់បឹត ណគ ដើ ឆមឺ ប្រាត់ ដើម មន់កជែត តាក់ ណគ។ តគ់ តង៉ៃ ទី ពែ លំញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ហាក់ លែក ដើ បូវ មែ លុកស៊ិក ម៉ើ ណោះ អ៊ឺម កាន គ្រែដៃ យែស៊ូ ឡើ ម៉ាង អ៊ែ តៃ ណោះ ប៉ាគ់ ង៉ាយ ឡើ ម៉ាង យ៉ាក់ កាន អ៊ែ ណាគ់ ឡើ វៀក ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ទឹង គ្រែដៃ យែស៊ូ ដៀប លំប៊ឹះ មួង យែរីខូ ប៊ិច កឡ សូត ម៉ាត់ មូយ រ៉ា ឡើ ដ្រូម ឡា លៀន ដៀក ទ្រូង។ ");
INSERT INTO brb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ទឹង ឡើ ដុង មែ ក្លាង ស៊្រុក ម៉ើ ដក់ តៃ ទ្រូង ទុត អើន អ៊ែ ឡើ តង៉ា រៀន៖ «អង់ង៉ាយ ហង់អ៊ិន អិះ វ៉ើ តៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","មែ ម៉ើ ហាយ ដើ ណគ រៀន៖ «យ៉ាគ់ យែស៊ូ ស៊្រុក ណាសារែត ឡើ ដក់ ហឹ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","អ៊ែ បឹ ឡើ សូត ម៉ាត់ ឡើ កឡូវ រៀន៖ «អើយ យ៉ាគ់ យែស៊ូ ហៃ ហកន់ស៊ែ យូ សឋិច ដាវីត ហន់ស្រុស្រៀត អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","អ៊ែ ណគ់ មែ ម៉ើ ដក់ អន់នួរ ម៉ើ គឹះ ណគ៖ «ហំព្រឹង វ៉ៃ!»។ ហាក់ ណគ សរ៉ើម ឡើ កឡូវ ចាំ ថាំង រៀន៖ «ឡា យ៉ាគ់ ហកន់ស៊ែ យូ សឋិច ដាវីត ហន់ស្រុស្រៀត អៃ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","គ្រែដៃ យែស៊ូ ឡើ ជឹង ប្រយ ឡើ ប៉្រៃ ម៉ើ តៀត បឹ ឡើ សូត ម៉ាត់ ហឹ ណគ ម៉ើ តៀត ប៊ឹះ តគ់ ណគ អ៊ែ ឡើ តង៉ា បឹ ឡើ សូត ម៉ាត់ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«អង់ង៉ាយ ហប៉្រៃ អំប៉ូរ ហៃ?»។ ឡើ ត្រណើវ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ អៃ អឡា ហឹ ហៃ ម៉ាត អៃ លំត្រប៉ៃ ប៉ាគ់ ពន់ឋើម ទឺ អុះ!»។ ");
INSERT INTO brb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ហឹ ហន់ត្រប៉ៃ ហំមិញ ហន់នៀម ឡើយ យ៉ាក់ ហមឹង អៃ ប៉ាគ់ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ហំប៊្រុះ ដើ អ៊ែ ម៉ាត់ ណគ ឡើ ត្រប៉ៃ ប្រយ អ៊ែ ឡើ ដក់ តូយ គ្រែដៃ យែស៊ូ ដើម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ដិ។ លែក ដើ បនឹះ ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ ព្រតឹះ ព្រនែ ប៉ាគ់ទឺ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","អ៊ែ ទឹង គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ ហឹ មួង យែរីខូ ");
INSERT INTO brb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ប៊ិច កឡ មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ សាឃែ ឡើ ប៊ិច បាក់ តៃ ឋាំ ឡើ បើម ណាយ ទឹង បូវ មែ កាគ់ លៀន។ ");
INSERT INTO brb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ឡើ ងុញ តៃ គ្រែដៃ យែស៊ូ ណោះ ប៉ាគ់ ង៉ាយ ចាក់ ណគ ហាក់ ឡើ ដូវ អ៊ឺម តៃ យ៉ាក់ ឡើ ប៊ិច បនឹះ ទុត អើន ប៊ឹង អ៊ែ ដើម យ៉ាគ់ សាឃែ នែ ចាក់ ណគ ឡើ ឡិៗ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","អ៊ែ ឡើ ដក់ អ្រយ៉ាវ អន់នួរ ឡើ ហាវ ទិ ត្រប៊ឺ ឡង ឡើ ចាំ ឝ្លាំង គ្រែដៃ យែស៊ូ យ៉ាក់ គ្រែដៃ យែស៊ូ លំដក់ ប៉ុះ អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តគ់ អ៊ែ ឡើ ង៉ើយ ឝ្លាំង ទឹង ត្រប៊ឺ ឡង អ៊ែ ឡើ ម៉ាង រៀន៖ «អើយ យ៉ាគ់ សាឃែ ហន់ទឺះ ដ្រិះ ទិ នែ! យ៉ាក់ តង៉ៃ នែ អៃ អន់ត្រ គូ ទឹង ហន់ណាម ហៃ អន់ដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","អ៊ែ យ៉ាគ់ សាឃែ ឡើ ទឺះ ដ្រិះៗ តើម ទិ ឡង ឡើ ញឹម ក្លើម ក្លាក ឡើ ច្រា ឡា ប្រយ គ្រែដៃ យែស៊ូ មឹត ទឹង ហន់ណាម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ប៊ឹង បនឹះ លែក រ៉ា ម៉ើ តៃ ប៉ាគ់ អ៊ែ ម៉ើ ចជែ ព្រសក់ ព្រសិវ ត្រឌីវ មែ រៀន៖ «តគ់ វន់ឝ្លាំង យ៉ាគ់ អន់តគ់ ឡើ មឹត គូ ហឹ ហន់ណាម បនឹះ ប៊ិច ឞាប»។ ");
INSERT INTO brb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","យ៉ាគ់ សាឃែ ឡើ ឌឹក ឆុង ហាយ ដើ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា យ៉ាគ់ កន់ដ្រាគ់ អើយ អៃ អំព្រណាក រ៉ាះ អំបាះ អៃ តង់បារ អង់អាំ ដើ មែ ធុក ញ៉ាក អ៊ែ ណាគ់ អៃ អន់កាគ់ លៀន មែ ពជឺរ ពន់ឋើម កនុង មូយ អន់សៀ ពួន អន់ណាវ ដើ មែ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «តង៉ៃ នែ គ្រែដៃ ឡើ ហវ៉ាត់ ហន់ណាម ក្រាន ហៃ ឡើយ យ៉ាក់ ហៃ ហមឹង គ្រែដៃ ប៉ាគ់ យ៉ាគ់ អាប្រាហាំ ម៉ិ យ៉ាគ់ ង៉ាយ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","យ៉ាក់ កួន បនឹះ ឡើ ទឺះ ដាំង ហវ៉ាត់ បនឹះ ម៉ើ ហវ៉ារ់ ប៉ាត់»។ ");
INSERT INTO brb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","តគ់ គ្រែដៃ យែស៊ូ ដៀប លំប៊ឹះ មួង យែរូសាឡឹម ឡើយ អ៊ែ ឡើ ម៉ាង ព្រឌីវ ណាគ់ មូយ អន់ណាវ ដើ មែ ម៉ើ ចង់ហៀង ណគ យ៉ាក់ មែ លែក រ៉ា ម៉ើ វ៉ឹត រៀន គ្រែដៃ លំប៊ឹះ ពែក ប៉ាក់ ហឹត ឡើយ ទិ នែ ។ ");
INSERT INTO brb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប៊ិច កួន មែ អាត់ញ៉ា មូយ រ៉ា ឡើ ទែង ដក់ ហឹ មួង ចង៉ាយៗ បក់ មន់ពឌឹក ណគ បើម សឋិច ពឺង ប៊្រី ដាក ណគ កឡឹ។ តគ់ លំបើម សឋិច ឡើយ អ៊ែ លន់ជឹ ហឹ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","អន់នួរ ឡើ វីះ ឡើ កឡូវ ឞយ ណគ ជិត រ៉ា ឡើ ប៉្រៃ មន់ដក់ ហឹ ណគ ឡើ អាំ លៀន ត្រំ មែ មូយ រ៉ា មូយ កាក់ ឆៀង ដើម ឡើ ថាន់ មែ រៀន “វន់ចក់ ដាំង ពស៊ឺក កាក់ នែ ឆា ដើ ប៊ឹះ អៃ អន់ជឹ ហឹ វែ ទឺ”។ ");
INSERT INTO brb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","មែ ក្លាង ស៊្រុក ណគ កឡឹ ម៉ើ ព្រឆាន់ ដើ ណគ អ៊ែ ម៉ើ ប៉្រៃ មែ អន់នឺ រ៉ា ឆ្រួយ ពហាយ តៃ ត្រិច ណគ រៀន “ញ៉ា ញ៉ើ អាំ អ៊ឺម ណគ លំបើម សឋិច ដើ ញ៉ា”»។ ");
INSERT INTO brb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«តគ់ ឡើ បើម សឋិច ឡើយ អ៊ែ ឡើ ជឹ វឹញ ហឹ ទឺ។ ឞយ ណគ់ ឡើ អាំ លៀន កាក់ ឆៀង ពន់ឋើម ឡើ ប៉្រៃ មន់ដក់ ហឹ ណគ បក់ លំណោះ កនុង មូយ រ៉ា ម៉ើ ដូវ ពស៊ឺក ឞាល់ ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ឞយ ទី មូយ ឡើ ប៊ឹះ តគ់ ណគ ឡើ ហាយ រៀន “យ៉ាគ់ កន់ដ្រាគ់ អើយ កាក់ ណគ់ ហៃ ហអាំ ដើ អៃ អពស៊ឺក អដូវ ជិត កាក់ ឆៀង អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","យ៉ាគ់ សឋិច ឡើ ព្រតឹះ ណគ រៀន “ចាគ់ ឡើយ ហបើម ប៉ាគ់ នែ ហឞយ កនូយ ម៉ាត់ ម៉ាត ឡើយ ហៃ នែ! យ៉ះ កាន កិៗ ណាគ់ ហទឹង ត្រ ប៉ាគ់ទឺ ណិះៗ នែ អៃ អង់អាំ មួង ជិត អំប៊ុ ដើ ហៃ ហំពែក ប៉ាក់ យ៉ឹ”។ ");
INSERT INTO brb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ឞយ ទី បារ ឡើ ប៊ឹះ តគ់ អ៊ែ ឡើ ហាយ រៀន “យ៉ាគ់ កន់ដ្រាគ់ អើយ ណគ់ កាក់ ហៃ ហអាំ អពស៊ឺក អ៊ែ អដូវ សើង កាក់ ឆៀង អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","យ៉ាគ់ សឋិច ឡើ ពហាយ ដើ ណគ រៀន “ហៃ ហំពែក ប៉ាក់ មួង សើង អំប៊ុ អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","តគ់ បឹ លមូយ អន់ណាវ ឡើ ប៊ឹះ ឡើ ហាយ រៀន “នែ យ៉ាគ់ កន់ដ្រាគ់ កាក់ ឆៀង ហៃ! អចូម ជុ ពឝ្លៀក ទឹង ហំបាន ដើ ហៃ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","អឌូង ដើ ហៃ ញ៉ន ហបនឹះ ពង៉ាត់ អង់ង៉ាយៗ ហៃ តៃ ហជុ ណាគ់ ហចក់ តមួត ដឹប ហកៀវ ចក់ ចិះ ហឹ ណា ញឹះ ហៃ តៃ ហពពឹត”។ ");
INSERT INTO brb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","យ៉ាគ់ សឋិច ឡើ ម៉ាង ដើ ឞយ ហង់អ៊ែ រៀន “អើយ ឞយ តៃ ចាគ់! អៃ អំពថូត ហៃ ប៉ាគ់ ប្រម៉ាង ហៃ ហង់អ៊ិន ទឺ ឡើយ។ ហៃ ហណោះ ឡើយ អៃ អបនឹះ ពង៉ាត់ អង់ង៉ាយៗ តៃ អជុ ណាគ់ អចក់ តមួត ដឹប អកៀវ ចក់ ចិះ ហឹ ណា ណគ់ អៃ តៃ អពពឹត។ ");
INSERT INTO brb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ប៉ាគ់ ពអ៊ែ ប៉ិ តៃ ហឌី អាំ កាក់ អៃ ដើ មែ មន់តង់ អ៊ែ អន់ចក់ កាក់ អំប៊ី ដឹប កាក់ ពស៊ឺក ដិ តគ់ អជឹ?” ");
INSERT INTO brb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ប៊្លី អ៊ែ យ៉ាគ់ សឋិច ឡើ ប៉្រៃ មែ ម៉ើ គូ ចើម ណគ រៀន “វន់ចក់ កាក់ តើម ប៊ឹង ណគ វន់អាំ ដើ បឹ ឡើ ប៊ិច ជិត កាក់ ឆៀង អន់ណាវ”។ ");
INSERT INTO brb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","មែ ទឹង អ៊ែ ម៉ើ ពហាយ ដើ សឋិច រៀន “យ៉ាគ់ កន់ដ្រាគ់ អើយ បឹ ហង់អ៊ែ ឡើ ប៊ិច ជិត កាក់ ឡើយ!”។ ");
INSERT INTO brb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","យ៉ាគ់ សឋិច ឡើ ត្រណើវ មែ រៀន “អៃ អង់ហាយ ដើ វែ រៀន ណគ់ ត្រំ មែ ម៉ើ ប៊ិច ឡើយ បនឹះ មន់អាំ ទឺម អន់ណាវ ដើ មែ ហាក់ ណគ់ មែ ម៉ើ ប៊ិច កិៗ បនឹះ មន់សួរ ពលែក តើម ប៊ឹង មែ ញឹះ តៃ អាំ ណាគ់។ ");
INSERT INTO brb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","អ៊ែ ណគ់ ដើ បូវ ដ្រម៉ា អៃ ណគ់ តៃ ម៉ើ ម៉ើត អៃ អបើម សឋិច ដើ មែ មិញ វន់រ៉ាប់ តៀត មែ ហឹ នែ វន់កោះ កជែត តាក់ មែ ប៊ឹង ងឺរ អៃ ណិះ ឡើយ”»។ ");
INSERT INTO brb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","តគ់ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ពអ៊ិន លែវ ឡើយ អ៊ែ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ឌឹក ទឹង មួង យែរូសាឡឹម អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ណគ ឡើ ប៊ឹះ ដៀប ស៊្រុក ប៊ែតផាស៊ែ ដើម ស៊្រុក ប៊ែថានី ប្លះ ក្រជែង សាង ចន់ឌូ តើម អូលីវ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ លុកស៊ិក ណគ បារ រ៉ា ដក់ អន់នួរ។ ");
INSERT INTO brb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ដើម ឡើ ហាយ រៀន៖ «មិញ សប្រា លំដក់ ហឹ ស្រ៊ុក មែ ហឹ ងឺរ តគ់ ហំប៊្រុះ សប្រា លំប៊ឹះ តគ់ អ៊ែ អ៊ែ សប្រា លំតៃ កួន សិះ លៀ មូយ ម៉ើ ចង តគ់ អ៊ែ ញឹះ តៃ ប៊ិច មែ ង៉ាយ អំម៉ឹះ មន់ឈិះ អ៊ែ សប្រា លំឡិះ ជឹ ទឹក ហឹ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ប៉ាគ់ ប៊ិច មែ ង៉ាយ មន់តង៉ា សប្រា រៀន “ប៉ិ ត្រ សប្រា ឡិះ ណគ?”។ អ៊ែ សប្រា លំត្រណើវ រៀន “យ៉ាគ់ កន់ដ្រាគ់ ឡើ តងកាន ណគ”»។ ");
INSERT INTO brb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","អំប្រា ដក់ ប្រយ ប៊ឹះ តគ់ អ៊ែ អំប្រា តៃ ប៉ាគ់ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ អំប្រា ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ទឹង អំប្រា ឡិះ កួន សិះ លៀ មែ កន់ដ្រាគ់ សិះ លៀ ម៉ើ តង៉ា រៀន៖ «ប៉ិ ឡើ ត្រ សប្រា ឡិះ លៀ អៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","អំប្រា ត្រណើវ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់ ឡើ តងកាន ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ប៊្លី អ៊ែ អំប្រា ជឹ ទឹក កួន លៀ អាំ ដើ គ្រែដៃ យែស៊ូ ដើម អំប្រា សើវ ដើ អាវ ទិះ អំប្រា ពឺង កណង លៀ អ៊ែ អំប្រា ពឈិះ ប្រយ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ទឹង គ្រែដៃ យែស៊ូ ឡើ ឈិះ តៃ ទ្រូង បនឹះ តូវ ម៉ើ សើវ ទ្រូង ណគ ដើ អាវ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ហំប៊្រុះ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តគ់ ទ្រូង តនឺះ តើម ទិ ចន់ឌូ តើម អូលីវ លុកស៊ិក ណគ ទុត អើន ម៉ើ ញឹម ក្លើម ក្លាក ម៉ើ ព្រតឹះ ព្រនែ គ្រែដៃ ថាំងៗ ញ៉ន ដើ ម៉ើ តៃ គ្រែដៃ យែស៊ូ ឡើ បើម កាន ឆង៉ាត់ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","មែ ម៉ើ រៀន៖ «ឡា គ្រែដៃ លំប្រាយ កាន ចាគ់ ដើ បឹ ឡើ ប៊ឹះ ទឹង ម៉ាត់ គ្រែដៃ កន់ដ្រាគ់ ញឹម សាំង ក្លាំង រ៉ិញ ទឹង ហូង គ្រែ ដើម កាន ព្រតឹះ ព្រនែ ឡើ លឺ អន់តើរ ទឹង ហូង ឈ្រូង តៃ ឋាំ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","មែ ផារីស៊ី អន់នឺ រ៉ា ណគ់ ម៉ើ គូ ទឹង បនឹះ អើនៗ ម៉ើ ប៉្រៃ គ្រែដៃ យែស៊ូ រៀន៖ «អើយ ណាយឃូ ហង់គឹះ លុកស៊ិក ហៃ ហំប៉្រៃ មន់គូ ហ្រហៀង!»។ ");
INSERT INTO brb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «អៃ អន់ហាយ ដើ វែ រៀន ប៉ាគ់ បូវ មែ នែ មន់គូ ហ្រហៀង ណាគ់ តម៉ អន់ណាវ មន់ហរ៉ាវ កឡះ ព្រតឹះ ព្រនែ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ ដក់ ដៀប ប៊ឹះ មួង យែរូសាឡឹម ហំប៊្រុះ ឡើ តៃ មួង អ៊ែ ឡើ ញឺម អមួញ ប្រយ បនឹះ ទឹង អ៊ែ ដើម ឡើ ម៉ាង រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«វែ មួង យែរូសាឡឹម អើយ! ឞាល់ អ៊ិន អុះ អមួញ វែ តង៉ៃ នែ ញឹះ តៃ វ៉ើ ណោះ ហឝ៉ាវ កាន ឆនឹម ហន់ណាំង គ្រែដៃ ឡើ ម៉ើត ឈូន ដើ វែ ញ៉ន កាន នែ ឡើ វៀក វ៉ើ ឝ្លាំង លហម ណាគ់ តៃ វ៉ើ តៃ។ ");
INSERT INTO brb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","យ៉ាក់ ហឹ ងឺរ បូវ ដ្រម៉ា វែ មន់បើម ដ្រក វ៉ាង ឈុំ វែ អ៊ែ មន់ត្រវ៉ាង ឌ្រឺប វែ។ ");
INSERT INTO brb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","អ៊ែ មន់មឹត កជែត កោះ វែ តូវ មន់ឝ៉្លារ ឆាន់ ឞ្លិរ មួង វែ។ សំ យ៉ះ តម៉ ព្រឌឺន ណាគ់ តៃ លំប៊ិច យ៉ាវ ឞ្លៀវ លែក តាក់ យ៉ាក់ តៃ វ៉ើ ឌី ហឝ៉ាវ អ៊ឺម គ្រែដៃ ទឹង ឡើ ទឺះ ហវ៉ាត់ វែ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ ហឹ មួង យែរូសាឡឹម ឡើ មឹត ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ តវីះ មែ ហំពួត រួត។ ");
INSERT INTO brb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ឡើ ម៉ាង ដើ មែ រៀន៖ «ទឹង ពឹម គ្រែដៃ គ្រែដៃ ឡើ ហាយ រៀន “កនូ អៃ នែ ឡើ ត្រ រ៉ូង បនឹះ មន់ដក់ អ៊ឺរ ដាំង អៃ ហវ៉ៃ ណគ់ ដើ វែ រ៉ូង អៃ នែ វ៉ើ បើម កនូ មែ តទូង ចចក់ អន់ណាវ។”»។ ");
INSERT INTO brb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន មែ ទឹង រ៉ូង ទិះ កដាប ហំបះ ត្រំ តង៉ៃ។ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ មែ ពង់ហៀន ចឞាប់ ដើម មែ ទិះ ក្រាគ់ សុនសាត យូដា ម៉ើ តមួត ចជែ ត្រឌីវ មែ រៀន៖ «ប៉ាគ់ ង៉ាយ ងំបើម អ៊ែ ងន់ដូវ កជែត គ្រែដៃ យែស៊ូ»។ ");
INSERT INTO brb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ហាក់ ណោះ ប៉ាគ់ ង៉ាយ អ៊ែ មន់ដូវ ក្រតៀង កជែត ណគ យ៉ាក់ លែក ដើ មែ ក្លាង ស៊្រុក ម៉ើ គឺត ចង់ហៀង ប្រម៉ាង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","តង៉ៃ ហង់អ៊ិន គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន មែ ទឹង បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ដើម ឡើ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ ដើ មែ ក្លាង ស៊្រុក ទឹង អ៊ែ ឡើ ប៊ិច បូវ ទិះ ក្រាគ់ បប៊ុះ ថួយ បូវ ពង់ហៀន ចឞាប់ ដើម មែ ទិះ ក្រាគ់ សុនសាត យូដា ម៉ើ មឹត ហឹ ណគ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ម៉ើ តង៉ា ណគ រៀន៖ «ហង់ហាយ ឡាំង ដើ ញ៉ា ហអ៊ីង ដើ អាតណាត មែ ង៉ាយ ហបើម កាន លែក នែ អ៊ែ ហដូវ មែ ង៉ាយ ម៉ើ អាំ អាតណាត ដើ ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «អៃ អន់តង៉ា ប៉ាគ់ទឺ វែ វន់ហាយ ឡាំង ដើ អៃ ");
INSERT INTO brb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","មែ ង៉ាយ ម៉ើ អាំ អាតណាត ដើ យ៉ាគ់ យ៉ូហាន បើម ឞ៊ុន តម៉ូច ដាក? គ្រែដៃ លឺ បនឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ប៉ាគ់ ងន់ហាយ រៀន គ្រែដៃ ឝ៉ាន់ លំម៉ាង ដើ ង៉ាយ រៀន “ប៉ិ តៃ វ៉ើ ឌី ចាប់ ប្រម៉ាង យ៉ាគ់ យ៉ូហាន ដឹះ?”។ ");
INSERT INTO brb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ប៉ាគ់ ងំត្រណើវ រៀន “បនឹះ ឡើ អាំ ដើ ណគ” ឝ៉ាន់ មែ ប៉ាសាសុន លែក រ៉ា មន់ពៀវ កជែត ង៉ាយ ដើ តម៉ យ៉ាក់ ម៉ើ ណោះ ហឡាក់ រៀន ណគ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ម៉ាត»។ ");
INSERT INTO brb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ប៉ាគ់ ពអ៊ែ ម៉ើ ត្រណើវ រៀន៖ «ញ៉ើ ណោះ អ៊ឺម ញ៉ា ណោះ មែ ង៉ាយ ម៉ើ អាំ អាតណាត ដើ យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក»។ ");
INSERT INTO brb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «ប៉ាគ់ ពអ៊ិន ដើ អៃ អង់ហាយ អ៊ឺម ប៉ាគ់ទឺ ដើ វែ រៀន អបើម កាន លែក នែ អអ៊ីង ដើ អាតណាត មែ ង៉ាយ»។ ");
INSERT INTO brb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ព្រឌីវ ដើ មែ ក្លាង ស៊្រុក រៀន៖ «ប៊ិច បនឹះ មូយ រ៉ា ឡើ ដាំ ឈឹង ជែម ទឹង មឺរ ឡើ អាំ ដើ មែ មន់រន់ឋាប់ ឝ្លាំង មឺរ ណគ ឡើ ប៉្រៃ មន់ប៉ាក ប៉្លៃ ដើ ណគ ត្រំ កម៉ ប៊្លី អ៊ែ ណគ កឡឹ ឡើ វីះ ហឹ ស្រុក ចង៉ាយ ទុត ឌុញ។ ");
INSERT INTO brb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","តគ់ ប៊ឹះ ញ៉ាម ប៉្លៃ ឈឹង ជែម ឡើ ឌុំ ឡើយ ឡើ ប៉្រៃ ឞយ ណគ មូយ រ៉ា ដក់ ចក់ ប៉្លៃ ពណាក ណគ ហឹ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ ហាក់ ឡើ ប៊ឹះ តគ់ អ៊ែ ម៉ើ បឹត បយឹ ណគ ជឹ ទី មិៗ។ ");
INSERT INTO brb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","យ៉ាគ់ កន់ដ្រាគ់ មឺរ ឡើ ប៉្រៃ ឞយ មូយ រ៉ា អន់ណាវ លំដក់ ហាក់ ណគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ ម៉ើ បឹត ព្រសាក យ៉វ ឡឹះ អន់ណាវ ឞយ ហង់អ៊ែ ម៉ើ ប៉្រៃ ឡើ ជឹ វឹញ ទី មិៗ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ឡើ ប៉្រៃ ឞយ លមូយ ឡឹះ អន់ណាវ ប៊ឹះ តគ់ អ៊ែ ម៉ើ បឹត ណគ តូវ ឡើ មឹត ចាក់ ដៃ ប៊្លី អ៊ែ ម៉ើ ឝ្រយ៉ិង យ៉ង់ ហពៀវ តាក់ ណគ ហឹ ដៀក មឺរ»។ ");
INSERT INTO brb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«យ៉ាគ់ កន់ដ្រាគ់ មឺរ ឡើ ឃឹត រៀន “ប៉ាគ់ ង៉ាយ ឋូវ អំបើម អំប៉្រៃ កួន កឡ ប្រម៉ើត អន់ញ៉ុ អៃ លំដក់ ហឹ មែ អាត មន់ចាប់ អៀល បឹះ ប្រម៉ាង ណគ”។ ");
INSERT INTO brb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","តគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ ម៉ើ តៃ កួន កឡ យ៉ាគ់ កន់ដ្រាគ់ មឺរ ឡើ ប៊ឹះ តគ់ មែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន “បឹ អន់នែ ឡើយ លំដូវ មឺរ នែ លំបើម មូន ខៃ ណូវ ញ៉ះ ញន់កជែត ណគ អ៊ែ មឺរ នែ លំត្រ មឺរ ង៉ាយ”។ ");
INSERT INTO brb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","អ៊ែ ម៉ើ រ៉ាប់ កួន កឡ កន់ដ្រាគ់ មឺរ ម៉ើ អ៊ូះ កជែត តាក់ ហឹ ដៀក មឺរ។ ប៉ាគ់ ពអ៊ែ កន់ដ្រាគ់ មឺរ ប៉ាគ់ ង៉ាយ អន់ណាវ លំបើម ដើ មែ? ");
INSERT INTO brb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ណគ លំដក់ កជែត ឡើយ ណគ់ មែ ម៉ើ រន់ឋាប់ ឝ្លាំង មឺរ ណគ ប៊្លី អ៊ែ លំអាំ មឺរ អ៊ែ ហឹ មែ គែង អន់ណាវ មន់រន់ឋាប់ ឝ្លាំង»។ ម៉ើ ដុង ណគ ឡើ ព្រឌីវ ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ ម៉ើ រៀន៖ «ឡា អុះ កាន អ៊ិន អាំ អ៊ឺម លំប៊ិច ប៉ាគ់ អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","គ្រែដៃ យែស៊ូ ឡើ ឝ្លាំង ហឹ មែ ឡើ ម៉ាង រៀន៖ «វន់ឃឹត យ៉ឹ ប៉ិ វ៉ើ អាន ទឹង ពឹម គ្រែដៃ “តម៉ ណគ់ មែ ម៉ើ បើម ហន់ណាម ម៉ើ ពៀវ តាក់ ឡើយ ឡើ វឹរ តម៉ ឡើ ប៊ិច ខា ណាគ់ ជឺរ អ៊ែ អន់ណាវ ”។ ");
INSERT INTO brb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","មែ ង៉ាយ មន់កទឹម បង់ ប៊ឹង តម៉ អន់នែ មែ អ៊ែ មន់ហិច អំប្រិច អ៊ែ ប៉ាគ់ តម៉ អន់នែ លំគ្លីះ តឹន ពឺង មែ ង៉ាយ មែ អ៊ែ តូវ មន់ហទឹក ប្រយ»។ ");
INSERT INTO brb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ទឹង អ៊ែ បូវ មែ ពង់ហៀន ចឞាប់ ដើម មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ម៉ើ អៀត មៀង ងុញ រ៉ាប់ គ្រែដៃ យែស៊ូ ប៊ឹង អិះ ឡើយ យ៉ាក់ ម៉ើ ណោះ ណគ ឡើ ចនីរ គឹះ មែ ពញ៉ង ណាគ់ ម៉ើ ឌូង ដើ មែ ក្លាង ស៊្រុក។ ");
INSERT INTO brb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ម៉ើ អន់ឆយ ឝ្លាំង ចង់ហៀង ប្រម៉ាង គ្រែដៃ យែស៊ូ ដើម ម៉ើ ប៉្រៃ បនឹះ ដក់ ស៊ឺប ប្រម៉ាង ណគ អំប លំម៉ាង យូច។ បូវ មែ កឡា ស៊ឺប ម៉ើ ពឝ្លា វ៉ិះ ឌិវ តៃ ពឺង ដើ ណគ បក់ មន់ដូវ រ៉ាប់ ប្រម៉ាង ណគ កឡាគ់ លំចជែ យូច អ៊ែ មន់តៀត ណគ ហឹ យ៉ាគ់ ពីឡាត់ ណគ់ ឡើ ពែក ប៉ាក់ ស្រុក ដើម ឡើ ប៊ិច អាតណាត ពថូត ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","បូវ មែ នែ ម៉ើ តង៉ា ណគ រៀន៖ «អើយ ណាយឃូ ញ៉ា ញ៉ើ ណោះ ឡើយ រៀន លែក ដើ ប្រម៉ាង ណគ់ ហៃ ហពង់ហៀន ដើម ហព្រតូវ ឡើ ត្រ លែក អិះ។ កាន ហៃ ហពង់ហៀន ឡើ ដាវ ម៉ាត់ ម៉ាត តាម ប្រម៉ើត គ្រែដៃ ញឹះ តៃ ហច្រលែក បនឹះ។ ");
INSERT INTO brb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ហន់ហាយ ឡាំង ដើ ញ៉ា តាម ចឞាប់ សុនសាត ង៉ាយ ណាគ់ ដូវ ឡះ ងន់អាំ លៀន ដើ សឋិច រ៉ូមាំង ឡើ កាគ់ លឺ ដូវ អ៊ឺម?»។ ");
INSERT INTO brb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","គ្រែដៃ យែស៊ូ ឡើ ហឝ៉ាវ មែ ម៉ើ ចជែ តបូត ណគ អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«មិញ វន់ពដៃ ឡាំង កាក់ មែ រ៉ូមាំង មូយ ដើ អៃ ទឹង កាក់ នែ ឡើ ប៊ិច ហ៊ូប មែ ង៉ាយ? ម៉ាត់ មែ ង៉ាយ?»។ មែ ម៉ើ ត្រណើវ រៀន៖ «ហ៊ូប ដើម ម៉ាត់ អ៊ែ យ៉ាគ់ សឋិច ទិះ មែ រ៉ូមាំង»។ ");
INSERT INTO brb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «ប៉ាគ់ ពអ៊ែ ណគ់ អង់ង៉ាយ ឡើ ត្រ រ៉ាះ សឋិច ទិះ រ៉ូមាំង វន់ឈូន ដើ សឋិច ទិះ កឡឹ ណគ់ អង់ង៉ាយ ឡើ ត្រ ថួយ ដើ គ្រែដៃ វន់ឈូន ដើ គ្រែដៃ កឡឹ ប៉ាគ់ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","បូវ មែ នែ ម៉ើ ដូវ អ៊ឺម ដាំង ខ ដើ គ្រែដៃ យែស៊ូ ប៊ឹង ងឺរ មែ ក្លាង ស្រ៊ុក ញ៉ន ម៉ើ ដុង អ៊ឺម ប្រម៉ាង គ្រែដៃ លំយូច។ លែក ដើ មែ ម៉ើ ញ៉ម ទុត ខាក់ ប្រយ ដើ ណគ ឡើ ត្រណើវ អ៊ែ ម៉ើ គូ ហ្រហៀង។ ");
INSERT INTO brb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ប៊ិច បូវ មែ សាឌូស៊ី អន់នឺ រ៉ា ម៉ើ ដក់ តង៉ា ប៉ាគ់ទឺ គ្រែដៃ យែស៊ូ។ បូវ មែ សាឌូស៊ី ម៉ើ ច្រម៉ាន រៀន បនឹះ គែត ប៊ិច យ៉ាវ មន់ញិវ ឡឹះ អន់ណាវ។ អ៊ែ ម៉ើ តង៉ា បឡង ឝ្លាំង ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«អើយ ណាយឃូ យ៉ាគ់ ម៉ូស៊ែ ទឹង ឡៃ មាំង ឡើ ខៀន ចឞាប់ ជុ ដើ ង៉ាយ ឡើ រៀន “ប៉ាគ់ បឹ អង់ង៉ាយ ឡើ គែត តៃ ដាន់ ប៊ិច កួន អំម៉ឹះ ប៊្លី អ៊ែ អោះ ណគ តង លំហ្រដូវ ម៉ី ណគ បក់ លំពឝ៉ើត កួន ថរ ម៉ាត់ អ៊ូគ ណគ”។ ");
INSERT INTO brb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ងំព្រឌីវ រៀន ប៊ិច អំម៉ោះ អោះ ម៉ាត់ កឡៗ ប៉ឹះ រ៉ា អ៊ូគ ឡង់ មែ ឡើ ចក់ ទ្រី អន់នួរ ប៊្លី អ៊ែ ឡើ គែត ញឹះ តៃ ដាន់ ឡើ ប៊ិច កួន អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","អោះ ប៊ឹង ងឺរ ណគ ឡើ ចក់ ហ្រដូវ ម៉ី ណគ តៃ ដាន់ ប៊ិច កួន ឡើ គែត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","អោះ ទី បារ ឡើ ហ្រដូវ ឡឹះ ម៉ី ណគ ឡើ គែត ប៉ាគ់ទឺ។ ប៊្លី អ៊ែ អោះ អូយ ណគ ម៉ើ ហ្រដូវ ម៉ី មែ តៃ ដាន់ ប៊ិច កួន ម៉ើ គែត តៃ ដាន់ ប៊ិច កួន ម៉ើ គែត ឆា ដើ លែក មែ ប៉ឹះ រ៉ា ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","តគ់ ប៊្លី អ៊ែ កទ្រី នែ ឡើ គែត ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","តគ់ តង៉ៃ បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ ប៉ាគ់ ពអ៊ែ កទ្រី អ៊ែ លំត្រ ទ្រី មែ ង៉ាយ យ៉ាក់ លែក មែ ប៉ឹះ រ៉ា ម៉ាត់តូវ ក្ល ណគ?»។ ");
INSERT INTO brb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «បនឹះ ទិ ឡាង ប្រិះ នែ ម៉ើ ចក់ ទ្រី ចក់ ក្ល ប៉ាគ់ អិះ ឡើយ ");
INSERT INTO brb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ហាក់ ហឹ ប៉ាង ខៃ ណូវ បនឹះ ណគ់ គ្រែដៃ ឡើ តៃ ឆិ ឃឺ អ៊ែ លំពញិវ ឡឹះ អន់ណាវ ប៊ិច យ៉ាវ មន់ចក់ ទ្រី ក្ល។ ");
INSERT INTO brb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","បូវ មែ អ៊ែ ដូវ យ៉ាវ មន់គែត ឡឹះ យ៉ាក់ មន់បើម ប៉ាគ់ ឞាវ គ្រែដៃ មែ មន់កួន គ្រែដៃ ឡើយ យ៉ាក់ ម៉ើ ញិវ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","យ៉ាគ់ ម៉ូស៊ែ ឡើ ហាយ ទុត ហឡាក់ រៀន បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ យ៉ាក់ ទឹង ឡើ តៃ តើម ឆ្រឡា ឡើ កាត អ៊ុញ អ៊ែ ឡើ ជុ គ្រែដៃ កន់ដ្រាគ់ រៀន គ្រែដៃ យ៉ាគ់ អាប្រាហាំ គ្រែដៃ យ៉ាគ់ អ៊ីសាគ់ ដើម គ្រែដៃ យ៉ាគ់ យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","គ្រែដៃ តៃ ត្រ ឡើ គ្រែដៃ ដើ បនឹះ គែត អ៊ឺម គ្រែដៃ ឡើ គ្រែដៃ ដើ បនឹះ ញិវ សំយ៉ះ ចាក់ ដៃ មែ ម៉ើ គែត ឌុញ កម៉ ឡើយ កតាម ដើ គ្រែដៃ ឡើ តៃ ណាគ់ ម៉ើ ញិវ លែក រ៉ា ដឌែ»។ ");
INSERT INTO brb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ណាយឃូ ម៉ើ ពង់ហៀន ចឞាប់ អន់នឺ រ៉ា ម៉ើ រៀន៖ «ណាយឃូ ហៃ ហហាយ ពអ៊ិន ចាគ់ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","តគ់ ប៊្លី អ៊ែ មែ លែក រ៉ា តៃ ម៉ើ ហាន យ៉ាវ តង៉ា គ្រែដៃ យែស៊ូ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ប៉ិ ឡើ ត្រ មែ បូវ ម៉ើ រៀន គ្រែដៃ គ្រិះ ឡើ កួន ចូវ សឋិច ដាវីត ពអ៊ិន ដឹះ? ");
INSERT INTO brb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","យ៉ាក់ ទឹង កនុង ផាប់ ព្រតឹះ ព្រនែ យ៉ាគ់ សឋិច ដាវីត ឡើ ខៀន ជុ កាន គ្រែដៃ គ្រិះ ឡើ រៀន “គ្រែដៃ កន់ដ្រាគ់ ឡើ ពហាយ ដើ កន់ដ្រាគ់ អៃ ឡើ រៀន ហន់ឌឹក ដ្រូម តៃ ចម៉ា អៃ នែ ");
INSERT INTO brb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ទឹង ហូច អៃ អំពញ៉ម ដ្រម៉ា ហៃ អំជុ បើម ឝណើវ ឈឹង ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ប៉ាគ់ យ៉ាគ់ សឋិច ដាវីត ឡើ ជុ គ្រែដៃ គ្រិះ អ៊ែ រៀន កន់ដ្រាគ់ ណគ ប៉ិ លំប៉ិន គ្រែដៃ គ្រិះ នែ លំកួន ចូវ សឋិច ដាវីត ប៉ាគ់ អ៊ិន?»។ ");
INSERT INTO brb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ទឹង មែ ក្លាង ស្រ៊ុក លែក រ៉ា ម៉ើ ចង់ហៀង ណគ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ថាន់ បូវ លុកស៊ិក ណគ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«វែ វន់ត្រ លវាំង ម៉ាត់ ម៉ាត យ៉ឹ ដើ បូវ ណាយឃូ ពង់ហៀន ចឞាប់ បូវ មែ អ៊ែ ម៉ើ ឍុ ហក អាវ ឌ្រឹម ចណុង ចណាគ់ ម៉ើ អន់ឆូវ វឹញ ដក់ៗ ម៉ើត ពយ៉ូក ចាក់ មែ កឡឹ ម៉ើត បូវ មន់ហំបះ មែ ហឹ តឡាត ម៉ើ ដ្រូម ពឃឺ ប៊ឹង ងឺរ បូវ ទឹង រ៉ូង ពស៊ុំ ដើម ម៉ើ ម៉ើត ដ្រុនដ្រូម យ៉ូក យ៉ាល់ ប៊ឹង ឞន ញែត ចង់ ទុត ទិះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","បូវ មែ អ៊ែ ម៉ើ អ្យគ់ តបូត បក់ មន់ដូវ ចក់ ហន់ណាម រ៉ាះ អំបាះ មែ ម៉ិយូ កម៉ាយ ដើម ម៉ើ អ៊ឺរ ដាំង គ្រែដៃ ទុត ឌុញ ឃឺ អង់ឃឺ។ បូវ មែ នែ មន់ត្រ ថូត ទុត កយឹក ជឺរ បនឹះ ហឹ គែង អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ បយ៉ើល ឝ្លាំង ឡើ តៃ មែ ម៉ើ ប៊ិច បាក់ ជុ លៀន ម៉ប ដើ គ្រែដៃ ទឹង ហ៊ីប។ ");
INSERT INTO brb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","គ្រែដៃ យែស៊ូ ឡើ តៃ កទ្រី កម៉ាយ ធុក ញ៉ាក មូយ រ៉ា ឡើ ដក់ ជុ លៀន ប៉ាគ់ទឺ ទឹង ហ៊ីប នែ បារ កាក់ ។ ");
INSERT INTO brb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន កទ្រី កម៉ាយ ធុក ញ៉ាក ណគ់ អន់នែ ឡើ ម៉ប លៀន អើន ជឺរ បូវ។ ");
INSERT INTO brb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","យ៉ាក់ ដើ មែ បូវ ម៉ើ ជុ លៀន ហន់និវ ហន់ណាគ់ ទឹង ហ៊ីប ម៉ើ ម៉ប ដើ គ្រែដៃ ហាក់ ដើ កទ្រី កម៉ាយ អន់នែ អន់ណាវ ហម ឡើ ធុក ញ៉ាក ឞាល់ ង៉ាយ កតាម ណាគ់ ឡើ ជុ ពលែក លៀន ណគ់ ឡើ ជុ រ៉ាក់ ដើ ចាក់ ណគ កឡឹ ឡើ ម៉ប ដើ គ្រែដៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","បូវ អន់នឺ រ៉ា ម៉ើ ព្រតឹះ រ៉ូង កដាប ហំបះ គ្រែដៃ ណគ់ មែ ឡៃ ម៉ើ បើម ដើ តម៉ ទុត ចាគ់ ដើម ម៉ើ បាក រ៉ាះ ណគ់ មែ ម៉ើ ម៉ប ដើ គ្រែដៃ ឡើយ។ អ៊ែ គ្រែដៃ ឡើ ហាយ ដើ មែ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«ហឹ ងឺរ អន់ទុន អង់ង៉ាយៗ ណគ់ វែ វ៉ើ តៃ ណិះៗ នែ លំដឡាយ ហិច អំប្រិច លែក តាក់ ប៊ិច យ៉ាវ តម៉ លំព្រឌឺន ត្រឌីវ តម៉ អន់ណាវ មែ ដ្រម៉ា មន់ឝឹ លែក»។ ");
INSERT INTO brb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","មែ ម៉ើ តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ណាយឃូ អើយ! កាន អ៊ិន ដមិញ ដឹះ លន់កើត? ប៊ឹង ង៉ាយ ដឹះ ញន់ណោះ ហឝ៉ាវ កាន អ៊ិន ដៀប លំប៊ឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «វន់លវាំង យ៉ឹ ញ៉ង វ៉ើ បូត អ៊ឺម ដើ មែ មន់តបូត វែ ប៊ិច បនឹះ ទុត អើន មន់ចើះ ចាក់ ម៉ាត់ អៃ រៀន “អៃ នែ ឡើយ អគ្រែដៃ គ្រិះ” លឺ មន់រៀន “តង៉ៃ គ្រែដៃ ឡើ ខណាត ឡើ ប៊ឹះ ឡើយ”។ ញ៉ង វ៉ើ ចាប់ ហំឞយ អ៊ឺម ប្រយ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ប៊ឹង វន់ដុង ឡើ ប៊ិច កាន ប្រណើម លឺ ប៊ិច កាន អ្រញ៉ុក អ្រញ៉ាក ញ៉ង វ៉ើ ឌូង អ៊ឺម យ៉ាក់ កាន អន់នែ តង លន់កើត អន់នួរ ឡើយ ហាក់ ដាន់ អំម៉ឹះ លំឡូច ឡាង ប្រិះ នែ ដ្រិះៗ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","គ្រែដៃ យែស៊ូ ឡើ ហាយ ឡឹះ អន់ណាវ រៀន៖ «សុនសាត មូយ មន់ប្រណើម ដើ សុនសាត មូយ អន់ណាវ ពធែត មូយ មន់ប្រណើម ដើ ពធែត មូយ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","អើន អំប៊ុ អើន ឞន លំប៊ិច អង់ឝឹត ពដិះ ទុត ខាក់ លំប៊ិច កាន អឹត ហរុ ដើម លំប៊ិច ឆនិ អន់តុ ម៉ើ កាត់ តៗ ប៉ាគ់ទឺ ដឹប ទឹង ឡាង គ្រែ លំប៊ិច កាន ហ្រលឹម ពឹក តូវ មន់សសឹរ ចាក់ អន់ឆាក់ យ៉ាង កុងគឺ ក្រលឺ ក្រឡា ដើម លំប៊ិច កាន ពន់ជែម ឆង៉ាត់ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«អន់នួរ កាន លែក អ៊ែ លន់កើត មែ មន់រ៉ាប់ តំឞាប វែ អន់ដៃ ដើម មន់តៀត តាត់ ស៊ិន វែ ហឹ រ៉ូង ពស៊ុំ អ៊ែ មន់ជុ វែ ទឹង ឃុក ដើម មន់ឈូន វែ ហឹ សឋិច ហឹ មែ ទិះ ក្រាគ់ អាំ មន់ពថូត វែ ញ៉ន ដើ វ៉ើ តូយ អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ហាក់ កាន នែ លំបើម អាំ វែ វន់ប៊ិច ទ្រូង ពហាយ កាន គ្រែដៃ ដើ បូវ។ ");
INSERT INTO brb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ប៉ាគ់ ពអ៊ែ ញ៉ង វ៉ើ ឌូង ច្រៃ អ៊ឺម ញ៉ង វ៉ើ ឃឹត អន់នួរ អ៊ឺម ណគ់ កាន វែ វន់ត្រណើវ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","យ៉ាក់ អៃ អំប៉ូរ វែ អាំ វន់ណោះ ម៉ាង តាម ហ្រឡិច អៃ អ៊ែ ដ្រម៉ា វែ ណគ់ មន់ដាំង ខ ហឹ វែ តៃ មន់ណោះ ច្រម៉ាន ប៊ឹង វែ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ហម យ៉ះ មែគ បើគ អំម៉ោះ អោះ ព្រឝ៉ើត យូ បូវ ប៊ែង វែ ណាគ់ មន់ផង ប៉ាគ់ទឺ វែ ហឹ មែ ទិះ ក្រាគ់ មន់ប៉្រៃ មែ មន់កជែត វែ អន់នឺ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ទឹង អ៊ែ លែក ដើ បនឹះ តៃ មន់រែម ឡាំងៗ ដើ វែ ញ៉ន ដើ វ៉ើ តូយ អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ហម យ៉ះ សក់ វែ ទឹង ទូះ មូយ ឡង ណាគ់ តៃ លំប៉ាត់ អ៊ឺម ប៉ាគ់ទឺ ។ ");
INSERT INTO brb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","អ៊ែ ដើ វែ ប៉ាគ់ វន់បក់ អុតថុន ណាគ់ វន់ដូវ ញិវ អន់សច»។ ");
INSERT INTO brb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«តង៉ៃ ង៉ាយ វែ វន់តៃ កង តហាន មន់វ៉ាង មួង យែរូសាឡឹម នែ អ៊ែ វន់ណោះ រៀន មួង នែ ដៀប លំដឡាយ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","តគ់ តង៉ៃ អ៊ែ មែ ទឹង ស្រុក យូដា តង មន់អ្រយ៉ាវ ទឹង ចន់ឌូ អ៊ែ ណគ់ មែ ទឹង មួង យែរូសាឡឹម តង មន់រ៉ូះ តើម ប៊ឹង មួង ណគ់ អន់នែ អ៊ែ ណគ់ ដើ មែ ម៉ើ គូ ហឹ មឺរ សារ់ ញ៉ង មន់ជឹ យ៉ាវ ហឹ មួង។ ");
INSERT INTO brb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","យ៉ាក់ តង៉ៃ អ៊ែ លំត្រ គ្រែដៃ លំពថូត ប៉ាសាសុន ណគ លន់កើត តាម មែ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ទឹង អ៊ែ ណគ់ មែ កទ្រី តមែវ តៃ ម៉ាង មែ កទ្រី តពុ កួន មន់ធុក ញ៉ាក ទុត ខាក់ យ៉ាក់ លំប៊ិច កាន ធុក ញ៉ាក ប៉ាក ម៉ង តៃ ឋាំ ទឹង ស្រុក ញ៉ន គ្រែដៃ ឡើ ពដៃ កាន មាំ ណគ ដើ មួង អន់នែ លំពថូត មែ។ ");
INSERT INTO brb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","មែ អើន រ៉ា មន់ត្រ គែត ដើ ប៉្លា តាវ ណគ់ មែ អន់នឺ បូវ ដ្រម៉ា មន់រ៉ាប់ ជឹ តៀត បើម ក៝ត អាំ មន់គូ គូម ចន់ឌ្រូះ ចន់ដ្រុប ហឹ ពធែត មែ អង់គែង អង់កង់ សុនសាត មែ គែង មន់ឈិះ ឆាន់ មួង យែរូសាឡឹម ឆា ដើ ប៊ឹះ តង៉ៃ គ្រែដៃ លំអាំ យ៉ាវ ដើ មែ មន់គូ ពែក ប៉ាក់ មួង អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«ទឹង អ៊ែ លំប៊ិច កាន ចង់ហ លំពន់ជែម ទឹង ម៉ាត់ តង៉ៃ ទឹង កើត ដើម ទឹង ពតួរ ទុត អើន។ អ៊ែ ទិ ឡាង ប្រិះ នែ លែក ដើ សុនសាត មន់ឌូង តៃ មន់ណោះ បើម ប៉ាគ់ ង៉ាយ យ៉ាវ ទឹង មន់ដុង សមុត លំស៊ឹរ អន់ជឺច ថាំងៗ។ ");
INSERT INTO brb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","បនឹះ ចម៉ាវ មន់ឌូង តូវ សសឹរ ចាក់ អន់ឆាក់ យ៉ាង កុង គឺ ក្រលឺ ក្រឡា ប៊ឹង ម៉ើ ឃឹត កាន លន់កើត ទិ ឡាង ពដិះ នែ យ៉ាក់ គ្រែដៃ លន់ក្រស៊ូ អាំ លែក ទឹង ឡាង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ទឹង អ៊ែ មន់តៃ កួន បនឹះ លំប៊ឹះ ទឹង កឌី យូក ដើម លំប៊ិច អាតណាត ឆង៉ាត់ អូងអាត យ៉ូកយ៉ាល់ តៃ ឋាំ។ ");
INSERT INTO brb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","តង៉ៃ ង៉ាយ កាន លែក អ៊ែ លំពន់តើម កើត វែ វន់ឌឹក ឆុង ង៉ើយ ឝ្លាំង ទឹង គ្រែ យ៉ាក់ គ្រែដៃ ដៀប លំប៊ឹះ តោះ វែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ព្រឌីវ រៀន៖ «មិញ វន់ឝ្លាំង តើម លវ៉ា ដើម លែក ដើ តើម ឡង ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ប៉ាគ់ វន់តៃ ហឡា ណគ លន់កយ៉ិ ឡើយ អ៊ែ វន់ណោះ រៀន ដៀប លំប៊ឹះ ញ៉ាម ដុ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ប៉ាគ់ អ៊ែ ទឺ ឡើយ តង៉ៃ ង៉ាយ វន់តៃ កាន លែក អ៊ែ លន់កើត អ៊ែ វន់ណោះ ប៉ាគ់ទឺ រៀន គ្រែដៃ ដៀប លំប៊ឹះ ពែក ប៉ាក់ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ វែ រៀន កាន លែក អ៊ែ លំកើត ទឹង បនឹះ ប៉ាង តណើរ អន់នែ ឡើយ តៃ ដាន់ មន់គែត លែក អំម៉ឹះ។ ");
INSERT INTO brb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ឡាង គ្រែ ដើម ឡាង ប្រិះ លំឡាញ ប៉ាត់ ពណាត់ លែក អ៊ែ ណគ់ ប្រម៉ាង អៃ លំដាវ អន់សច លំប៉ាត់ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«វន់ត្រ លវាំង យ៉ឹ! ញ៉ង វន់អ៊ឺក អ៊ឺម ដើ កាន រ៉គ់សំ ប៊ូ ញែត ចង់ វន់វ៉ាយ ដើ កាន ញិវ កើត កឡាគ់ កួន បនឹះ លំប៊ឹះ ឡឹះ ទឹង តង៉ៃ តៃ វន់ចាំ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","យ៉ាក់ តង៉ៃ ហង់អ៊ិន លំប៊ឹះ ឡើ បើម ប៉ាគ់ ខាយ លន់គ្លឹប បនឹះ លែក រ៉ា ម៉ើ គូ ទិ ឡាង ប្រិះ នែ។ ");
INSERT INTO brb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ប៉ាគ់ ពអ៊ែ វន់ចាំ ញ៉ាម ដឌែ យ៉ឹ ដើម វន់អ៊ឺរ ដាំង គ្រែដៃ អ៊ែ វន់ដូវ ក្លើច តើម ប៊ឹង កាន លែក នែ ដើម វន់ដូវ ឆុង ប៊ឹង ងឺរ កួន បនឹះ»។ ");
INSERT INTO brb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ត្រំ តង៉ៃ គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន ព្រតូវ ច្រូវ មែ ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ តគ់ មាំងៗ ឡើ ឌឹក គូ ទឹង ចន់ឌូ តើម អូលីវ។ ");
INSERT INTO brb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","តើម ភុង មាំង មែ ក្លាង ស៊្រុក លែក រ៉ា ម៉ើ ដក់ ចង់ហៀង គ្រែដៃ យែស៊ូ ឡើ ពង់ហៀន ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","តង៉ៃ មែ សុនសាត យូដា មន់បើម ឞ៊ុន ណំពាំង តៃ ប៊ិច ប៊ូះ ដៀប លំប៊ឹះ ឡើយ ឞ៊ុន អ៊ែ ម៉ើ ជុ រៀន ឞ៊ុន ពជឺរ។ ");
INSERT INTO brb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដឹប បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ ដាំង ទ្រូង កជែត ម៉ច គ្រែដៃ យែស៊ូ យ៉ាក់ ម៉ើ ឌូង ដើ មែ ក្លាង ស្រ៊ុក មន់បើម អ្រញ៉ុក អ្រញ៉ាក ប៉ាគ់ មន់ណោះ។ ");
INSERT INTO brb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","អរ៉ាក់ សតាំង ឡើ មឹត ទឹង ចនិះ យូដះ ណគ់ ម៉ើ ជុ អ៊ីសការីយ៉ុត ឡើ លុកស៊ិក ប៉ាគ់ទឺ ទឹង បូវ មែ ជិត បារ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ប៊្លី អ៊ែ យូដះ ឡើ ដក់ ហឹ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ណាយ កឡា ញ៉ាម រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ឡើ ចជែ អរែង ប៊ឹង មែ ដើម ឡើ តង៉ា មែ រៀន៖ «ប៉ាគ់ ង៉ាយ អំបើម អ៊ែ អន់ដូវ ម៉ប គ្រែដៃ យែស៊ូ ហឹ ទី វែ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","អ៊ែ ម៉ើ ញឹម ក្លើម ក្លាក ប្រយ ដើម ម៉ើ ផម អាំ លៀន ដើ យូដះ ");
INSERT INTO brb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","យូដះ ឡើ ឌី ប៉ាគ់ទឺ ម៉ប គ្រែដៃ យែស៊ូ ហឹ ទី មែ អ៊ែ ឡើ ចាំ ប៊ឹង លំវឺង បក់ លំដូវ ម៉ប គ្រែដៃ យែស៊ូ ហឹ ទី មែ ប្លះ មែ ក្លាង ស៊្រុក តៃ ប៊ិច។ ");
INSERT INTO brb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","តគ់ ឡើ ប៊ឹះ តង៉ៃ ម៉ើ បើម ឞ៊ុន ណំពាំង តៃ ប៊ិច ប៊ូះ ទឹង តង៉ៃ ឡើ ត្រ ម៉ើ កជែត ថួយ កួន ចៀម បើម ឞ៊ុន ពជឺរ ");
INSERT INTO brb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","គ្រែដៃ យែស៊ូ ឡើ ប៉្រៃ ពែត្រុះ អំប្រា យ៉ូហាន ដក់ អន់នួរ មែ ឡើ ហាយ រៀន៖ «មិញ សប្រា លំដក់ រន់ឋាប់ ចណង់ ចណា ឞ៊ុន ពជឺរ ដើ ង៉ាយ!»។ ");
INSERT INTO brb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","អ៊ែ អំប្រា តង៉ា គ្រែដៃ យែស៊ូ រៀន៖ «ណាយឃូ! ហឹ ង៉ាយ ដឹះ ហប៉្រៃ ញឺ ញន់ដក់ រន់ឋាប់ ចណង់ ចណា អ៊ិន?»។ ");
INSERT INTO brb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ អំប្រា រៀន៖ «ហំប៊្រុះ សប្រា លំប៊ឹះ ហឹ មួង តគ់ អ៊ែ សប្រា លំតៃ កឡ មូយ រ៉ា លំដូល ដាក ទឹង វ៉ាន់ អ៊ែ សប្រា លំតូយ ណគ ណគ លំមឹត ហឹ ហន់ណាម ង៉ាយ សប្រា លំមឹត ហឹ អ៊ែ ទឺ ");
INSERT INTO brb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","អ៊ែ សប្រា លំហាយ ដើ កន់ដ្រាគ់ ហន់ណាម រៀន “ណាយឃូ ញឺ ឡើ ប៉្រៃ ញឺ ដក់ តង៉ា ហៃ ប៊ឹង សួម អង់ង៉ាយ ហង់អាំ ដើ ណគ លន់ចង់ ចា ឞ៊ុន ពជឺរ អរែង ដើ លុកស៊ិក ណគ?”។ ");
INSERT INTO brb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","អ៊ែ កន់ដ្រាគ់ ហន់ណាម លំពដៃ អន់ឡើ ពឺង ទុត ទិះ ដើ សប្រា ណគ់ ឡើ រន់ឋាប់ លែវ ឡើយ អ៊ែ សប្រា លំបើម ចណង់ ចណា ឞ៊ុន ពជឺរ ប៊ឹង អ៊ែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","អ៊ែ អំប្រា ដក់ ប៊ឹះ តគ់ អ៊ែ អំប្រា តៃ ប៉ាគ់ គ្រែដៃ យែស៊ូ ឡើ ហាយ ម៉ាត់ ម៉ាត អ៊ែ អំប្រា រន់ឋាប់ រន់ឋយ ប្រយ ចណង់ ចណា បក់ មន់បើម ឞ៊ុន ពជឺរ។ ");
INSERT INTO brb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","តគ់ ប៊ឹះ ម៉ូង ម៉ើ មឹត ឞ៊ុន ឡើយ គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ចង់ ចា ប៊ឹង បូវ ពចាំ កាន ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ណគ ឡើ ម៉ាង រៀន៖ «ទឹង ហូច អន់ធុក ញ៉ាក អងុញ ទុត ខាក់ អន់មឹត ចា ឞ៊ុន ពជឺរ អរែង ប៊ឹង វែ។ ");
INSERT INTO brb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","អៃ អង់ហាយ ដើ វែ រៀន អៃ តៃ អន់ចា យ៉ាវ ឞ៊ុន ពជឺរ នែ ឆា ដើ ប៊ឹះ ឞ៊ុន អន់នែ លន់ក្លើច ឡើយ ទឹង ណាគ់ គ្រែដៃ លំពែក ប៉ាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","គ្រែដៃ យែស៊ូ ឡើ ចក់ ចក ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ ហាយ ដើ មែ រៀន៖ «ណិ វន់ចក់ ញែត ត្រំៗ វែ យ៉ឹ! ");
INSERT INTO brb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","អៃ អង់ហាយ ដើ វែ រៀន តើម ប៊ឹង នែ ហឹ ងឺរ តគ់ អៃ អន់ញែត យ៉ាវ តវែ ឈឹង ជែម ឆា ដើ គ្រែដៃ លំប៊ឹះ ពែក ប៉ាក់ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ចក់ ណុំពាំង ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ អ៊ែ ឡើ កដោះ ប៉ាក ដើ មែ ដើម ឡើ ហាយ រៀន៖ «អន់នែ ឡើយ ចាក់ ដៃ អៃ អំម៉ប ឡោះ ហវ៉ាត់ វែ។ ប៉ាគ់ នែ ឡើយ វន់បើម ដឌែ ហឹ ងឺរ តគ់ បក់ វន់ចនិះ ហឹ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ម៉ើ ចង់ ចា លែវ ឡើយ អ៊ែ ឡើ ចក់ តវែ ឈឹង ជែម ឡើ បើម ប៉ាគ់ អន់ឌូ ទឺ ឡើ ម៉ាង រៀន៖ «ចក តវែ ឈឹង ជែម នែ ឡើយ ផាម អៃ លំលូះ ដើ វែ ឡើ ពដៃ ហឡាក់ កាន ខណាត ខណាំ ហន់ដើម ប្លះ គ្រែដៃ ប្លះ វែ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«វែ វន់ត្រ ណោះ យ៉ឹ ណគ់ បឹ ឡើ ខិច អៃ ឡើ ដ្រូម ប៊ឹង តូគ អរែង ប៊ឹង អៃ នែ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","កួន បនឹះ លំត្រ គែត តាម គ្រែដៃ ឡើ ទែង ជុ អន់នួរ ឡើយ ហាក់ ណគ់ បឹ ឡើ ខិច កួន បនឹះ អ៊ែ លំធុក ញ៉ាក ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ទឹង អ៊ែ មែ លុកស៊ិក ម៉ើ តង៉ា ត្រឌីវ មែ រៀន៖ «បឹ អង់ង៉ាយ ឋូវ លំបើម ញឹះ ឞាល់ អ៊ិន?»។ ");
INSERT INTO brb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","មែ លុកស៊ិក ម៉ើ ច្រម៉ាន ត្រឌីវ មែ ម៉ើ ម៉ើត ណោះ រៀន៖ «មែ ង៉ាយ ឡើ ទិះ ជឺរ ដើ ង៉ាយ?»។ ");
INSERT INTO brb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","គ្រែដៃ យែស៊ូ ឡើ ពហាយ ដើ មែ ឡើ រៀន៖ «ត្រំ សឋិច មែ សុនសាត គែង ទិ ឡាង ប្រិះ នែ ម៉ើ ឈិះ ឆាន់ ប៉ាសាសុន ដើម បូវ មែ ម៉ើ ឝ៉ឹន អាតណាត ម៉ើ រៀន ចាក់ មែ កឡឹ ចាគ់ ឡើយ ញ៉ន ដើ ម៉ើ ប៉ូរ បូវ។ ");
INSERT INTO brb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ណគ់ ដើ វែ អន់ណាវ ញ៉ង វ៉ើ បើម អ៊ឺម ប៉ាគ់ ដើ មែ។ ណគ់ មែ ង៉ាយ ម៉ើ ទិះ ជឺរ មន់ត្រ បើម កិ អន់ណាវ ណគ់ មែ ង៉ាយ ម៉ើ ពឝឹង បូវ មែ អ៊ែ មន់ត្រ បើម ឞយ បូវ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","អង់ង៉ាយ ឡើ ទិះ ប្លះ អំប្រា? ណគ់ ឡើ ដ្រូម ប៊ឹង តូគ លឺ ណគ់ ឡើ វវ៉ក់ ចណង់ ចណា? តាម ង៉ើ ខើយ តៃ ណគ់ ឡើ ដ្រូម ប៊ឹង តូគ ឡើ ទិះ ជឺរ។ ហាក់ ណគ់ ដើ អៃ នែ អគូ ប៊ឹង វែ អបើម ឞយ វែ តវឹញ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«ប៊ឹង អៃ អធុក ញ៉ាក វែ ណាគ់ វ៉ើ បក់ អត់ថុន ប៊ឹង អៃ ដឌែ វ៉ើ តាក់ អ៊ឺម អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ប៉ាគ់ អ៊ែ ឡើយ ប៉ាគ់ គ្រែដៃ បើគ ឡើ ម៉ប កាន ពែក ប៉ាក់ ដើ អៃ អ៊ែ អៃ អង់អាំ ដើ វែ វន់ពែក ប៉ាក់ ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","តគ់ អំពែក ប៉ាក់ វែ វន់ដូវ ចង់ ចា អរែង ប៊ឹង តូគ អៃ ដើម វន់ដ្រូម ទិ ទិងមៀង បក់ វន់តាត់ កឍី ដើ មែ អ៊ីស្រាអ៊ែល លែក ជិត បារ ឆ្រាំង»។ ");
INSERT INTO brb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហាយ រៀន៖ «ស៊ីម៉ូន! ស៊ីម៉ូន អើយ! អរ៉ាក់ សតាំង ឡើ ឡា ពលូង បឡង វែ ឡើ បើម ប៉ាគ់ មែ ម៉ើ អូម ភែ ម៉ើ ហន់ដិច តាក់ ទូះៗ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ហាក់ អៃ ណាគ់ អអ៊ឺរ ដាំង គ្រែដៃ ដើ ហៃ តៃ អាំ អ៊ឺម ហៃ ហន់តាក់ មឹង អៃ។ តគ់ ហំពលិះ ចនិះ អន់ណាវ តង ហំពឝ៉្រឹត អំម៉ោះ អោះ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","យ៉ាគ់ ពែត្រុះ ឡើ តើវ គ្រែដៃ យែស៊ូ រៀន៖ «អ៊ឺម យ៉ាគ់ កន់ដ្រាគ់! អៃ អឃឹត លែវ ឡើយ អង់គូ ឃុក អរែង ដើ ហៃ អឌី ប៉ាគ់ទឺ អង់គែត អរែង ដើ ហៃ អឌី ប៉ាគ់ទឺ ណាគ់ អន់តូយ ដឌែ ហៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ ណគ រៀន៖ «ពែត្រុះ អើយ! អៃ អន់ហាយ ដើ ហៃ រៀន មាំង នែ ហៃ ហំប៉ាវ ញឹះ ពែ តង រៀន ហហឝ៉ាវ អ៊ឺម អៃ ប៊្លី អ៊ែ អៀរ លំប្រូវ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តង៉ា លុកស៊ិក ណគ រៀន៖ «ទឹង អៃ អប្រ៉ៃ វែ ដក់ ពហាយ កាន ចាគ់ តើម ប៊ឹង គ្រែដៃ អអាំ អ៊ឺម វែ វ៉ើ តៀត កសូប លៀន ក្រឌុង ប្រណាក់ ដើម កើប ប៉ិ វ៉ើ តៃ ណាគ់ ឆិ?»។ មែ ម៉ើ ត្រណើវ រៀន៖ «អ៊ឺគ ឆិ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","គ្រែដៃ ឡើ ហាយ ដើ មែ ឡឹះ អន់ណាវ រៀន៖ «ណិះៗ នែ មែ ង៉ាយ ម៉ើ ប៊ិច កសូប លៀន តង មន់តៀត ប៊ឹង ចាក់ មែ ង៉ាយ ម៉ើ ប៊ិច ក្រឌុង ប្រណាក់ តង មន់តៀត ប៉ាគ់ទឺ។ បឹ អង់ង៉ាយ តៃ ឡើ ប៊ិច តាវ លំត្រ ហំពួត អាវ ទិះ ណគ អ៊ែ លន់រួត តាវ។ ");
INSERT INTO brb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","អៃ អង់ហាយ ដើ វែ រៀន ទឹង ពឹម គ្រែដៃ ម៉ើ ខៀន ជុ កាន អៃ រៀន “ម៉ើ ជុ ណគ ប៉ាគ់ បនឹះ យូច ទឺ ”។ កាន នែ តង លន់កើត ម៉ាត់ ម៉ាត ដើ អៃ ប៉ាគ់ មែ ម៉ើ ខៀន ទឹង ពឹម ពន់ឋើម ទឺ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","បូវ លុកស៊ិក ម៉ើ ត្រណើវ រៀន៖ «នែ យ៉ាគ់ កន់ដ្រាគ់! ញ៉ើ ប៊ិច ឡើយ តាវ បារ»។ គ្រែដៃ យែស៊ូ ឡើ តើវ ម៉ាង មែ រៀន៖ «ឆិ ឡើយ ប៉ាគ់ អ៊ែ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","គ្រែដៃ យែស៊ូ ឡើ ញឺះ តើម ប៊ឹង ហន់ណាម ឡើ ដក់ ហឹ ចន់ឌូ តើម អូលីវ តាម ខណើយ ណគ បូវ លុកស៊ិក ម៉ើ ដក់ តូយ ប៉ាគ់ទឺ ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ហំប៊្រុះ ម៉ើ ប៊ឹះ តគ់ អ៊ែ ឡើ ម៉ាង រៀន៖ «មិញ វន់អ៊ឺរ ដាំង គ្រែដៃ អ៊ែ ញ៉ង វន់ដូវ ដើ កាន ពលូង»។ ");
INSERT INTO brb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ វីះ តើម ប៊ឹង លុកស៊ិក ណគ ចង៉ាយ ឆិ តូវ ហពៀវ ដើ តម៉ អ៊ែ ឡើ ជឹះ ត្រកូវ ប៊ឹង ប្រិះ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ឡើ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«ឡា អុះ គ្រែដៃ បើគ អើយ! ប៉ាគ់ ហន់ឌី ហន់ញ៉ាក់ តាក់ ចក ធុក ញ៉ាក នែ តើម ប៊ឹង អៃ។ ហាក់ ម៉ាត់ ញ៉ង ហំពន់ឋូយ អ៊ឺម តាម ប្រម៉ើត អៃ ហំបើម ប៉ាគ់ ប្រម៉ើត ហៃ កឡឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","លែវ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ឡើយ កអវ ឡើ តៃ ឞាវ គ្រែដៃ តើម ទិ គ្រែ ឡើ ប៊ឹះ ចុ ណគ បក់ លំប៉ូរ អាំ លំប៊ិច ពន់ដ្រិញ ពន់ដ្រួញ។ ");
INSERT INTO brb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","គ្រែដៃ យែស៊ូ ឡើ ឝ្រង៉ឹត ស្រូក ទុត ខាក់ អ៊ែ ឡើ ខំ អ៊ឺរ ដាំង គ្រែដៃ ចាំ ថាំងៗ ប្រយ តូវ ឡើ ជុះ ផូរ អ៊្យ្រឹះៗ ឞាល់ ផាម ឡើ ស្រួច ទិ ប្រិះ ។ ");
INSERT INTO brb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","លែវ ឡើ អ៊ឺរ ដាំង គ្រែដៃ ឡើយ ឡើ ឌឹក ឆុង អ៊ែ ឡើ ជឹ ហឹ លុកស៊ិក ណគ ទឺ អន់ណាវ ឡើ តៃ ម៉ើ ហង់ង៉ាន់ តៀក ញ៉ន ដើ ម៉ើ ឝ្រង៉ឹត ស្រូក។ ");
INSERT INTO brb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ឡើ ម៉ាង ដើ មែ រៀន៖ «ពយ៉ិ ឡើ ត្រ វ៉ើ ហង់ង៉ាន់ តៀក ឞាល់ នែ? មិញ វន់ឌឹក អ៊ឺរ ដាំង គ្រែដៃ អ៊ែ ញ៉ង វន់ដូវ ដើ កាន ពលូង»។ ");
INSERT INTO brb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ទឹង គ្រែដៃ យែស៊ូ ណាគ់ ឡើ ចជែ ហំប៊្រុះ ដអ៊ែ ឡើ ប៊ិច ប្រយ បនឹះ ទុត អើន ម៉ើ ប៊ឹះ យ៉ាគ់ យូដះ អ៊ីសការីយ៉ុត លុកស៊ិក ណគ មូយ រ៉ា ទឹង បូវ មែ ជិត បារ រ៉ា ឡើ តៀត ទ្រូង ដើ មែ។ ណគ ឡើ ដក់ ពន់ចើម ឡើ មុក ប្រយ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ ណគ រៀន៖ «យូដះ អើយ! អណោះ ឡើយ ហមុក ខិច អៃ អកួន បនឹះ បក់ មន់រ៉ាប់ អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","បូវ មែ ម៉ើ គូ ប៊ឹង គ្រែដៃ យែស៊ូ ម៉ើ តៃ កាន នែ ឡើ ប៊ឹះ ហឹត ម៉ាត់ ម៉ាត អ៊ែ ម៉ើ តង៉ា ណគ រៀន៖ «យ៉ាគ់ កន់ដ្រាគ់! ណាគ់ ញន់ហួត ឡះ តាវ កោះ មែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ហំប៊្រុះ ដើ អ៊ែ កអវ លុកស៊ិក មូយ រ៉ា ឡើ ហួត តាវ កោះ ប្រយ ឞយ យ៉ាគ់ ណាយ បប៊ុះ ថួយ តាត់ ត្រពិត តៃ ចម៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង រៀន៖ «ហំព្រឹង ហំមិញ ញ៉ង ហបើម យ៉ាវ!»។ ប៊្លី អ៊ែ ឡើ ដក់ ពឹត ត្រពិត បឹ ឡើ ប៊ឺក ឡើ ពនៀម ពទិត ប៉ាគ់ អំប៊ី រីវ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ណាយ កឡា ញ៉ាម រ៉ូង ទិះ កដាប ហំបះ ដើម មែ ទិះ ក្រាគ់ សុនសាត យូដា ម៉ើ ដក់ រ៉ាប់ ណគ រៀន៖ «ពយ៉ិ ឡើ ត្រ ញឹះ លែក ដើ វែ វ៉ើ តៀត តាវ តៀត ឡង ក្រដូង ឞាល់ នែ វ៉ើ តៃ អៃ នែ អខម៉ូយ ឡះ អ៊ែ ឡើ ត្រ វ៉ើ ដក់ រ៉ាប់ អៃ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","អៃ អគូ ទឹង រ៉ូង ទិះ កដាប ហំបះ អរែង ដើ វែ ត្រំ តង៉ៃ ឡើយ អតៃ អ៊ឺម វន់រ៉ាប់ អៃ។ ទឹង ម៉ូង នែ ឡើយ គ្រែដៃ ឡើ អាំ វែ វ៉ើ បើម តាម ប្រម៉ើត វែ ទឹង ម៉ូង នែ ឡើយ គ្រែដៃ ឡើ អាំ អរ៉ាក់ សតាំង ណគ់ ឡើ សឋិច ដើ កាន ហ្រង៉ូម លំបើម កាន តៃ ចាគ់ ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","អ៊ែ ម៉ើ រ៉ាប់ គ្រែដៃ យែស៊ូ ម៉ើ តៀត ណគ ហឹ ហន់ណាម ណាយ បប៊ុះ ថួយ។ យ៉ាគ់ ពែត្រុះ ឡើ ឆ្រួយ តៃ ត្រិច គ្រែដៃ យែស៊ូ ប្លះ អំប្រា ចង៉ាយៗ។ ");
INSERT INTO brb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","អ៊ែ ម៉ើ ព្រឹះ អ៊ុញ ទឹង កឌី បយឺង បូវ ទុត អើន ម៉ើ តមួត ហន់ឈុរ អ៊ុញ អ៊ែ ដើ យ៉ាគ់ ពែត្រុះ ឡើ ហន់ឈុរ ប៊ឹង មែ ទឺ ");
INSERT INTO brb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ប៊ឹង អ៊ែ ឡើ ប៊ិច ឞយ កទ្រី មូយ រ៉ា ឡើ តៃ យ៉ាគ់ ពែត្រុះ ឡើ ដ្រូម តគ់ ចឹម ចើម អ៊ុញ អ៊ែ ឡើ ត្រប៉ៃ ហឹ ណគ អ៊ែ ឡើ ឝ្លាំង ពឡាក់ ឡើ រៀន៖ «បូវ យែស៊ូ ទឺ ហវ៉ៃ បឹ អន់នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ហាក់ យ៉ាគ់ ពែត្រុះ ឡើ ច្រម៉ាន រៀន៖ «អ៊ែ ណាង អើយ! អៃ នែ អហង់ឝ៉ាវ អ៊ឺម ណគ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ឞិត ឞ៊ែត ប៊្លី អ៊ែ ប៊ិច កឡ មូយ រ៉ា ឡឹះ ឡើ តៃ ណគ ឡើ រៀន៖ «ហបូវ ណគ ឡើយ ហៃ នែ»។ យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «អ៊ឺម ត្រ អ៊ឺម ប!»។ ");
INSERT INTO brb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ប៊្លី អ៊ែ មូយ ម៉ូង អ្យាង ប៊ិច បឹ មូយ រ៉ា ឡឹះ អន់ណាវ ឡើ ហាយ រៀន៖ «បូវ យែស៊ូ ម៉ាត់ ម៉ាត ឡើយ បឹ អន់នែ យ៉ាក់ អំប្រា យែស៊ូ អំប្រា ប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ »។ ");
INSERT INTO brb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ រៀន៖ «យ៉ាគ់ អើយ អណោះ អ៊ឺម អៃ ហម៉ាង ប៉ាគ់ អ៊ិន!»។ ទឹង ណាគ់ ប៉ះ ឡើ ម៉ាង អ៊ែ អៀរ ឡើ ប្រូវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","អ៊ែ គ្រែដៃ យែស៊ូ ឡើ កន់ដ្រាគ់ ឡើ ហវីវ ឝ្លាំង ហឹ យ៉ាគ់ ពែត្រុះ យ៉ាគ់ ពែត្រុះ ឡើ ចនិះ ភៀក ហឹ គ្រែដៃ យែស៊ូ ឡើ ថាន់ ណគ អន់ឌូ រៀន៖ «មាំង នែ អន់នួរ អៀរ លំប្រូវ ហៃ ហំប៉ាវ ពែ តង ហន់រៀន តៃ ហហឝ៉ាវ អ៊ឺម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","យ៉ាគ់ ពែត្រុះ ឡើ វីះ តើម ប៊ឹង អ៊ែ ឡើ ចនិះ ភុច ស្រៀវ អ៊ែ ឡើ ញឺម ទុត ខាក់ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","បូវ មែ ម៉ើ ញ៉ាម គ្រែដៃ យែស៊ូ ម៉ើ ចអាវ ពន់ឆាំ ដើម ម៉ើ បឹត ណគ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ម៉ើ វ៉ាត់ ម៉ាត់ ណគ ដើ ហំបាន អ៊ែ ម៉ើ ឋូវ ណគ រៀន៖ «ប៉ាគ់ ហកឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ាត់ ម៉ាត ហង់ហាយ ឡាំង មែ ង៉ាយ ម៉ើ បឹត ហៃ?»។ ");
INSERT INTO brb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ដើម ម៉ើ យ៉វ ក្លះ ផម៉ាត ផម៉ា ណគ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","តគ់ ងឹប បូវ តង់កង់ ក្រាគ់ សុនសាត យូដា មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ ណាយឃូ ពង់ហៀន ចឞាប់ ម៉ើ ពស្រូម ត្រឌីវ មែ អ៊ែ ម៉ើ ប៉្រៃ មែ ម៉ើ ញ៉ាម មន់តៀត គ្រែដៃ យែស៊ូ ហឹ ងឺរ មែ អាំ មន់តាត់ កឍី លុង យ៉ាក់ មែ ឡើយ ម៉ើ ទិះ ក្រាគ់ តាត់ កឍី លុង ។ ");
INSERT INTO brb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","តគ់ អ៊ែ ម៉ើ តង៉ា ប្រយ ណគ រៀន៖ «ហង់ហាយ ឡាំង ដើ ញ៉ា ហៃ ឡើយ ឡះ ហគ្រែដៃ គ្រិះ?»។ គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ មែ រៀន៖ «សំយ៉ះ អៃ អង់ហាយ ដើ វែ ណាគ់ តៃ វន់ចាប់ ប៉ាគ់ទឺ ឡើយ អៃ ");
INSERT INTO brb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ប៉ាគ់ អន់តង៉ា វែ ណាគ់ តៃ វន់ឌី ត្រណើវ ប៉ាគ់ទឺ ឡើយ ដើ អៃ។ ");
INSERT INTO brb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ហាក់ តើម ប៊ឹង នែ ហឹ ងឺរ តគ់ កួន បនឹះ លំឌឹក ដ្រូម តៃ ចម៉ា គ្រែដៃ ឡើ ប៊ិច កាន ឆង៉ាត់ តៃ ឋាំ»។ ");
INSERT INTO brb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ប៊ឹង អ៊ែ ម៉ើ តង៉ា ណគ ប្រុកៗ ប្រយ រៀន៖ «អូ ហៃ ឡើយ ឡះ ហកួន កឡ គ្រែដៃ?»។ ណគ ឡើ ត្រណើវ មែ រៀន៖ «ត្រ ឡើយ វ៉ើ ម៉ាង ប៉ាគ់ អ៊ិន!»។ ");
INSERT INTO brb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","មែ ម៉ើ រៀន៖ «សណូវ យ៉ាវ ងន់តង៉ា ឡឹះ មែ កឡា ដុង យ៉ាក់ តូច ដើ ង៉ាយ ឡើយ ង៉ើ ដុង ប្រម៉ាង ណគ កឡឹ!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ប៊្លី អ៊ែ តូច ដើ មែ ម៉ើ ពស៊ុំ ម៉ើ ឌឹក ឆុង ម៉ើ តៀត គ្រែដៃ យែស៊ូ ហឹ យ៉ាគ់ ពីឡាត់ ណគ់ ឡើ ពែក ប៉ាក់ ស្រុក យូដា។ ");
INSERT INTO brb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","តគ់ អ៊ែ ម៉ើ ផង ណគ រៀន៖ «ញ៉ើ តៃ បឹ អន់នែ ឡើ ចាវ មែ ក្លាង ស៊្រុក ដើម ឡើ កំប៊ែត ញ៉ា កាគ់ លៀន ដើ សឋិច ទិះ រ៉ូមាំង ដើម ឡើ រៀន ចាក់ ណគ ឡើ គ្រែដៃ គ្រិះ ឡើ សឋិច»។ ");
INSERT INTO brb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","យ៉ាគ់ ពីឡាត់ ឡើ តង៉ា ណគ រៀន៖ «ហៃ ឡើយ ឡះ ហសឋិច សុនសាត យូដា?» គ្រែដៃ យែស៊ូ ឡើ ត្រណើវ រៀន៖ «ត្រ ឡើយ ហម៉ាង អ៊ិន»។ ");
INSERT INTO brb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","យ៉ាគ់ ពីឡាត់ ឡើ ម៉ាង ហឹ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម ហឹ មែ ក្លាង ស៊្រុក រៀន៖ «តាម អតៃ បឹ អន់នែ ប៊ិច អ៊ឺម ញឹះ ឆិ លំថូត!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ហរ៉ើម ម៉ើ ផង ពឝ៉្លាប់ ដឌែ ណគ រៀន៖ «បឹ អន់នែ ឡើ ពង់ហៀន ចាវ មែ ក្លាង ស៊្រុក ណាប់ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ឋា ដើ ប៊ិង ស្រុក យូដា»។ ");
INSERT INTO brb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","យ៉ាគ់ ពីឡាត់ ឡើ ដុង ប៉ាគ់ អ៊ិន អ៊ែ ឡើ តង៉ា រៀន៖ «មែ ស្រុក ឝ៉ាលីលែ ឡះ បឹ អន់នែ?»។ ");
INSERT INTO brb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ហំប៊្រុះ យ៉ាគ់ ពីឡាត់ ឡើ ដុង រៀន គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ (យ៉ាក់ សឋិច ហ៊ែរ៉ូត ឡើ ពែក ប៉ាក់ ស្រុក ហង់អ៊ែ) អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ ប៉្រៃ តហាន ណគ ដក់ ឈូន គ្រែដៃ យែស៊ូ ហឹ សឋិច ហ៊ែរ៉ូត លំតាត់ ស៊ិន យ៉ាក់ ណគ ឡើ ដក់ កវាំង ហឹ មួង យែរូសាឡឹម ទឺ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ហំប៊្រុះ យ៉ាគ់ ហ៊ែរ៉ូត ឡើ តៃ គ្រែដៃ យែស៊ូ ឡើ ញឹម ក្លើម ខាក់ៗ យ៉ាក់ ឡើ ងុញ តៃ គ្រែដៃ យែស៊ូ ឌុញ ឡើយ វ៉ិះ ឌិវ ឡើ ដុង មែ ក្លាង ស៊្រុក ម៉ើ ប៉ច កាន គ្រែដៃ យែស៊ូ នែ ឡើយ ដើ ណគ អ៊ែ ឡើ មឹង លំតៃ គ្រែដៃ យែស៊ូ លំបើម កាន ឆង៉ាត់ អង់ង៉ាយ មូយ។ ");
INSERT INTO brb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","សឋិច ហ៊ែរ៉ូត ឡើ តង៉ា កាន ទុត អើន ហាក់ គ្រែដៃ យែស៊ូ ញឹះ តៃ ឡើ តើវ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","បូវ មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ណាយឃូ ពង់ហៀន ចឞាប់ ណាគ់ ស្រូមៗ ម៉ើ ឆុង ប៊ឹង អិះ ឡើយ ម៉ើ ផង គ្រែដៃ យែស៊ូ តតាល់ វវ៉ាល់ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","សឋិច ហ៊ែរ៉ូត ដើម បូវ តហាន ណគ ម៉ើ ពន់ឆាំ ពន់ឆោះ ប៊ែត ឆាន់ គ្រែដៃ យែស៊ូ ម៉ើ ចក់ អាវ ឌ្រឹម ទុត ចាគ់ ម៉ើ ពហក ណគ ប៊្លី អ៊ែ សឋិច ហ៊ែរ៉ូត ឡើ ប៉្រៃ តហាន ណគ ដក់ ឈូន ណគ ហឹ យ៉ាគ់ ពីឡាត់ ទឺ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ទឹង ពន់ឋើម សឋិច ហ៊ែរ៉ូត អំប្រា យ៉ាគ់ ពីឡាត់ តៃ អំប្រា ត្រណក អ៊ឺម។ តើម ប៊ឹង តង៉ៃ អ៊ែ អំប្រា ហំពែម អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","យ៉ាគ់ ពីឡាត់ ឡើ កឡូវ បូវ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម បូវ មែ ទិះ ក្រាគ់ សុនសាត យូដា ដើម មែ ក្លាង ស៊្រុក អាំ មន់ពស៊ុំ តមួត ប៊ឹង ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ឡើ ហាយ ដើ មែ រៀន៖ «វែ វ៉ើ ឈូន បនឹះ នែ ហឹ អៃ អន់តាត់ ស៊ិន វ៉ើ ផង រៀន ណគ ឡើ ចន់ដ្រា មែ ក្លាង ស៊្រុក បើម កាន អ្រញ៉ុក អ្រញ៉ាក។ អតង៉ា ឡើយ ណគ ប៊ឹង ងឺរ វែ អតៃ អ៊ឺម លំយូច ញឹះ ឆិ លំថូត ប៉ាគ់ វែ វ៉ើ ផង អន់ឌូ។ ");
INSERT INTO brb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ទុត សឋិច ហ៊ែរ៉ូត ឡើយ ណាគ់ តៃ ឡើ តៃ ប៉ាគ់ទឺ លំយូច ឆិ ងំពថូត ញ៉ន ប៉ាគ់ នែ ឡើយ អ៊ែ ឡើ ឈូន តវឹញ ហឹ នែ អន់ណាវ។ វែ វ៉ើ តៃ ហឡាក់ ឡើយ បឹ អន់នែ ឡើ បើម អន់យូច អ៊ឺម ញឹះ ឆិ ងំកជែត ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","យ៉ាក់ ប៉ាគ់ អ៊ិន វ៉ិះ អំប៉្រៃ មន់បឹត មិៗ ណគ លែវ អ៊ែ អំពរ៉ូះ»។ ");
INSERT INTO brb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ត្រំ កម៉ ប៊ឹង ឞ៊ុន ពជឺរ យ៉ាគ់ ពីឡាត់ តង លំពញឺះ បនឹះ ថូត មូយ រ៉ា ដើ មែ យូដា ។ ");
INSERT INTO brb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","លែក ដើ មែ ហរ៉ើម ម៉ើ កឡូវ ណគ រៀន៖ «ហន់កជែត តាក់ បឹ អន់នែ ហំពរ៉ូះ បារ៉ាបះ ដើ ញ៉ា អន់ណាវ!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","បារ៉ាបះ នែ ម៉ើ រ៉ាប់ ចិះ ឃុក ពន់ឋើម ញ៉ន ឡើ ពឝ៉ើត កាន អ្រញ៉ុក អ្រញ៉ាក ដើ បូវ ទឹង មួង ដើម ឡើ កជែត បនឹះ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","យ៉ាក់ យ៉ាគ់ ពីឡាត់ ឡើ ងុញ ឡិះ ពរ៉ូះ គ្រែដៃ យែស៊ូ អ៊ែ ឡើ ហាយ ដើ មែ មូយ តង ឡឹះ រៀន គ្រែដៃ យែស៊ូ ឡើ បើម អន់យូច អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ហាក់ ហរ៉ើម ម៉ើ កឡូវ ឡា ថាំងៗ ដឌែ រៀន៖ «ហំពឡាះ ប៉ាង ណគ អ៊ែ ប៊ឹង ឡង អង់ឝ៉ាង! ហំពឡាះ ប៉ាង ណគ អ៊ែ ប៊ឹង ឡង អង់ឝ៉ាង!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","យ៉ាគ់ ពីឡាត់ ឡើ ហាយ ដើ មែ តគ់ ទី ពែ ឡឹះ អន់ណាវ រៀន៖ «ឡើ បើម អន់យូច អង់ង៉ាយ ដឹះ? អតៃ អ៊ឺម លំយូច ញឹះ ឆិ ងំកជែត ណគ។ ឝ៉ាន់ អំប៉្រៃ មែ តហាន អៃ មន់បឹត ណគ ប៊្លី អ៊ែ អំពរ៉ូះ»។ ");
INSERT INTO brb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ហរ៉ើម ម៉ើ កឡូវ ឡា ចាំ ថាំងៗ ដឌែ៖ «ហំពឡាះ ប៉ាង ណគ ប៊ឹង ឡង អង់ឝ៉ាង!»។ ឆា ដើ ឡើ ពន់ឋូយ ប៉ាគ់ ប្រម៉ាង មែ ");
INSERT INTO brb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","អ៊ែ យ៉ាគ់ ពីឡាត់ ឡើ ផម ប៉ាគ់ អ្រឡា មែ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ឆា ឡើ ពញឺះ យ៉ាគ់ បារ៉ាបះ តើម ប៊ឹង ឃុក តាម អ្រឡា មែ។ យ៉ាគ់ បារ៉ាបះ ឡើ ពឝ៉ើត កាន អ្រញ៉ុក អ្រញ៉ាក ដើម ឡើ កជែត បនឹះ ពន់ឋើម។ អ៊ែ ណគ់ ដើ គ្រែដៃ យែស៊ូ នែ អន់ណាវ យ៉ាគ់ ពីឡាត់ ឡើ ឈូន ហឹ ទី មែ អាំ មន់បើម តាម ប្រម៉ើត មែ កឡឹ។ ");
INSERT INTO brb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ទឹង មែ តហាន ម៉ើ តៀត គ្រែដៃ យែស៊ូ តៃ ទ្រូង ម៉ើ ជូល បឹ មូយ រ៉ា ម៉ាត់ ណគ ស៊ីម៉ូន មួង គីរែន ឡើ ជឹ តើម ប៊ឹង មឺរ អ៊ែ ម៉ើ រ៉ាប់ ពកួយ ណគ ដើ ឡង អង់ឝ៉ាង គ្រែដៃ យែស៊ូ ម៉ើ ប៉្រៃ អាំ លំដក់ តៃ ត្រិច ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","មែ ក្លាង ស៊្រុក ទុត អើន ម៉ើ ដក់ តៃ ត្រិច គ្រែដៃ យែស៊ូ ដឹប ប៊ិច មែ កទ្រី តូវ ម៉ើ ញឺម តង៉ូក ឆ្រុក ដើ គ្រែដៃ យែស៊ូ ម៉ាត់ ម៉ើ ទឹម ក្លើម គ្រឹក។ ");
INSERT INTO brb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","គ្រែដៃ យែស៊ូ ឡើ ហវីវ ហឹ មែ កទ្រី ឡើ ម៉ាង រៀន៖ «វែ កទ្រី មួង យែរូសាឡឹម អើយ! ញ៉ង វ៉ើ ញឺម អ៊ឺម អៃ តង វន់ញឺម អំមួញ ចាក់ វែ កឡឹ ដើម កួន ចូវ វែ ហំមិញ។ ");
INSERT INTO brb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","យ៉ាក់ ហឹ តង៉ៃ អន់ទុន បនឹះ មន់ម៉ាង រៀន “មែ កទ្រី កន់ដុង មែ កទ្រី តៃ ប៊ិច កួន ដើម កទ្រី តៃ តពុ កួន កទ្រី អ៊ែ មន់ហ្រនុក ហ្រវ៉ាក ឡើយ”។ ");
INSERT INTO brb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ទឹង អ៊ែ បនឹះ មន់កឡូវ ហង់អើយ ចន់ឌូ រៀន “ឡា ចន់ឌូ ទិះ អើយ វន់ហ្រលឹះ តឹន ញ៉ា នែ! ឡា ចន់ឌូ កិ វន់កុប កឌឹប ចាក់ ញ៉ា ដិ អុះ!”។ ");
INSERT INTO brb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","យ៉ាក់ ទុត ឡង ញិវៗ ណាគ់ ឞាល់ នែ ម៉ើ តំឞាប ហ៊ែង ឡង គែត ណាគ់ ហម នែ កឋឹះ »។ ");
INSERT INTO brb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ម៉ើ តៀត បនឹះ ថូត បារ រ៉ា ឡឹះ អន់ណាវ ម៉ើ ដក់ កជែត អរែង ប៊ឹង គ្រែដៃ យែស៊ូ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ហំប៊្រុះ ម៉ើ ប៊ឹះ ទិ ចន់ឌូ ម៉ើ ជុ រៀន “ចន់ឌូ លៀង ទូះ” ប៊ឹង អ៊ែ ឡើយ ម៉ើ ពឡាះ ប៉ាង គ្រែដៃ យែស៊ូ ប៊ឹង ឡង អង់ឝ៉ាង ដើម ម៉ើ ប៉ាង កជែត បនឹះ ថូត បារ រ៉ា ប៉ាគ់ទឺ តៃ ដៀក ណគ មូយ រ៉ា តៃ ចម៉ា គ្រែដៃ យែស៊ូ មូយ រ៉ា អន់ណាវ តៃ ចអៀវ។ ");
INSERT INTO brb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","គ្រែដៃ យែស៊ូ ឡើ កឡូវ អ៊ឺរ រៀន៖ «ឡា គ្រែដៃ បើគ អើយ! ហន់តាក់ ឞាប ដើ មែ នែ យ៉ាក់ មែ កឡឹ តៃ ម៉ើ ណោះ អ៊ឺម ណោះ ម៉ើ បើម អង់ង៉ាយ»។ ប៊្លី អ៊ែ មែ តហាន ម៉ើ ចក់ ប្រវ៉ើន ហណក គ្រែដៃ យែស៊ូ ប៊ឹង ម៉ើ ព្រណាក ម៉ើ ព្រលូក ត្រឌីវ មែ  បឹ អង់ង៉ាយ ឡើ ត្រ បឹ ហង់អ៊ែ ឡើ ដូវ។ ");
INSERT INTO brb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","មែ ក្លាង ស៊្រុក ម៉ើ ឆុង ឝ្លាំង ណគ។ មែ ទិះ ក្រាគ់ ម៉ើ ពន់ឆាំ លលៀវ តតៀវ ណគ រៀន៖ «ណគ នែ ឡើយ ហវ៉ៃ ឡើ ហវ៉ាត់ បូវ ប៉ាគ់ ណគ ឡើ គ្រែដៃ គ្រិះ ម៉ាត់ ម៉ាត តើម ទិ គ្រែដៃ ណគ់ គ្រែដៃ កន់ដ្រាគ់ ឡើ រ៉ើះ ប៉្រៃ ទឺះ ទិ នែ អ៊ែ លំតោះ ចាក់ ណគ កឡឹ ឡាំង ប៉ាគ់ លំដូវ!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","បូវ មែ តហាន ម៉ើ ពន់ឆាំ លលៀវ តតៀវ ប៉ាគ់ទឺ គ្រែដៃ យែស៊ូ ម៉ើ ចក់ តវែ ឈូគ ម៉ើ ពន់តូល ពយ៉ អាំ ដើ ណគ លំឈ្រែប ");
INSERT INTO brb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ដើម ម៉ើ ម៉ាង រៀន៖ «ប៉ាគ់ ហសឋិច សុនសាត យូដា ម៉ាត់ ម៉ាត ហន់តោះ ឡាំង ចាក់ ហកឡឹ!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ពឺង ទូះ ណគ ម៉ើ ខៀន ជុ រៀន៖ «ណគ នែ ឡើយ សឋិច សុនសាត យូដា»។ ");
INSERT INTO brb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","បនឹះ ថូត មូយ រ៉ា ម៉ើ ប៉ាង ប៊ឹង ឡង អង់ឝ៉ាង ទឺ ឡើ ផម៉ាត គ្រែដៃ យែស៊ូ រៀន៖ «ប៉ាគ់ ហគ្រែដៃ គ្រិះ ម៉ាត់ ម៉ាត ហន់តោះ ឡាំង ចាក់ ហកឡឹ ប៊្លី អ៊ែ ហន់តោះ ញឺ ដិ!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ហាក់ បនឹះ ថូត លមូយ ឡើ គឹះ ប្រណគ រៀន៖ «ហម៉ាង ប៉ាគ់ អ៊ិន ហឌូង អ៊ឺម ឡះ ដើ គ្រែដៃ? ហណោះ អ៊ឺម ឡះ ចាក់ ហៃ ម៉ើ ពថូត ប៉ាគ់ ដើ ណគ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ដើ បា នែ ឃឺ ឡើយ ម៉ើ ពថូត ឆា ដើ គែត យ៉ាក់ បបើម អន់យូច ម៉ាត់ ម៉ាត។ ណគ់ ដើ ណគ នែ ញឹះ តៃ ឡើ បើម អង់យូច អង់ង៉ាយ អ៊ឺម»។ ");
INSERT INTO brb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","តគ់ ប៊្លី អ៊ែ ឡើ ឡា ហឹ គ្រែដៃ យែស៊ូ រៀន៖ «ឡា គ្រែដៃ យែស៊ូ អើយ! ប៊ឹង ហន់ឌឹក បើម សឋិច ពែក ប៉ាក់ ញ៉ង ហវឺញ អ៊ឺម អៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","គ្រែដៃ យែស៊ូ ឡើ តើវ ណគ រៀន៖ «ដាវ ម៉ាត់ ម៉ាត អៃ អង់ហាយ ដើ ហៃ រៀន តង៉ៃ នែ ហៃ ហង់គូ អរែង ប៊ឹង អៃ ទឹង មួង ដុំ ហ្រនុក ទិ»។ ");
INSERT INTO brb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","តើម ប៊ឹង ឆុង ម៉ាត់ តង៉ៃ ឡើ កឡាំ ប៊្រែ ប្រយ លែក ដើ ប៊្រី ដាក មែ ឋា ដើ ប៊ឹះ ម៉ូង ពែ អំប៊ឹ ");
INSERT INTO brb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ម៉ាត់ តង៉ៃ ឡើ ប៉ាត់ ឝ៉ាល ដើម ហំបាន ទិះ ទុត កវឹវ ម៉ើ ពាំង ឝឡោះ ហឹ កនុង ទឹង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ឡើ ត្រសាក តង់បារ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","គ្រែដៃ យែស៊ូ ឡើ កឡូវ ហង់អើយ ថាំងៗ រៀន៖ «ឡា គ្រែដៃ បើគ អើយ! អម៉ប ផវ យ៉ាង អៃ ទឹង ត្រប៉ាង ទី ហៃ កឡឹ ឡើយ»។ ប៊្លី ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ឡើយ ឡើ តាត់ សើម ប្រយ ។ ");
INSERT INTO brb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","តគ់ ណាយ តហាន រ៉ូមាំង ឡើ តៃ កាន ឡើ កើត នែ ឡើ ព្រតឹះ ព្រនែ ប្រយ គ្រែដៃ ឡើ ហាយ រៀន៖ «បឹ អន់នែ ឡើ បនឹះ ចាគ់ ទឹង ត្រ ម៉ាត់ ម៉ាត!»។ ");
INSERT INTO brb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","អ៊ែ ដើ មែ ក្លាង ស៊្រុក ទុត អើន ម៉ើ តមួត ម៉ើ ឝ្លាំង ម៉ើ ប៉ាង មែ នែ ហំប៊្រុះ ម៉ើ តៃ កាន លែក អ៊ែ ឡើ កើត តគ់ ម៉ើ ជឹ វឹញ ម៉ើ តង៉ូក ឆ្រុក តូវ ម៉ើ ទឹម ក្លើម គ្រឹក ។ ");
INSERT INTO brb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","អ៊ែ ណគ់ ដើ បូវ ម៉ើ ទែប រែប ប៊ឹង គ្រែដៃ យែស៊ូ ដឹប មែ កទ្រី ម៉ើ តូយ ណគ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ម៉ើ ឆុង ឝ្លាំង បយ៉ើល កាន នែ តើម ប៊ឹង ចង៉ាយៗ។ ");
INSERT INTO brb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ប៊ិច បនឹះ ទឹង បូវ មែ ទិះ ក្រាគ់ តាត់ កឍី លុង មូយ រ៉ា ម៉ាត់ ណគ យ៉ាគ់ យ៉ូស៊ែប។ បឹ អន់នែ ស៊្រុក ណគ អារីម៉ាធែ ស្រុក យូដា។ ណគ ឡើ បនឹះ ចាគ់ ទឹង ត្រ ឡើ ចាំ ឝ្លាំង តង៉ៃ គ្រែដៃ លំពែក ប៉ាក់។ ");
INSERT INTO brb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ទឹង មែ ទិះ ក្រាគ់ ម៉ើ ទែង កជែត គ្រែដៃ យែស៊ូ ឡើ ឈែវ អ៊ឺម ប៊ឹង មែ ដើម តៃ ឡើ ផម អ៊ឺម ដើ កាន តៃ ចាគ់ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","យ៉ូស៊ែប ឡើ ដក់ ឡា ហឹ យ៉ាគ់ ពីឡាត់ លន់ចក់ កយ៉ក់ គ្រែដៃ យែស៊ូ។ ");
INSERT INTO brb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ឡើ ពឌឺះ កយ៉ក់ គ្រែដៃ យែស៊ូ តើម ទិ ឡង តង់កាគ់ លែវ ឡើយ អ៊ែ ឡើ បវ ដើ ហំបាន ចាគ់ៗ ឡើ ដក់ ជុ ហឹ ត្រម ច្រាង ត្រម ម៉ើ ជុ កយ៉ក់ នែ ញឹះ តៃ ប៊ិច ម៉ើ ជុ កយ៉ក់ អំម៉ឹះ ទឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ទឹង អ៊ែ ឡើ ត្រ តង៉ៃ មែ សុនសាត យូដា ម៉ើ រន់ឋាប់ បើម ឞ៊ុន ព្រឹង ដើម ដៀប លំប៊ឹះ ម៉ូង មន់បើម ឞ៊ុន ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","បូវ មែ កទ្រី ណគ់ ម៉ើ ដក់ តូយ គ្រែដៃ យែស៊ូ តើម ប៊ឹង ស្រុក ឝ៉ាលីលែ ម៉ើ ដក់ ឆ្រួយ ឝ្លាំង យ៉ាគ់ យ៉ូស៊ែប អ៊ែ ម៉ើ តៃ ត្រម ច្រាង ឡើ ជុ កយ៉ក់ យែស៊ូ ដើម ម៉ើ តៃ ហឡាក់ៗ ប៉ាគ់ ង៉ាយ ឡើ ពឝ៉ី កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ប៊្លី អ៊ែ មែ កទ្រី ម៉ើ ជឹ វឹញ រន់ឋាប់ រ៉ាះ គ្លឹម ដើម ណាំហម។ ប៊ឹង តង៉ៃ ត្រ ព្រឹង ម៉ើ ព្រឹង ប៉ាគ់ទឺ តាម ចឞាប់ យ៉ាគ់ ម៉ូស៊ែ ឡើ ប៉្រៃ។ ");
INSERT INTO brb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","តគ់ តង៉ៃ អាទិត តើម ភុង មាំង ត្រះ ឞ៊្រីៗ មែ កទ្រី ម៉ើ ចន់ដ្រា ដក់ ឆឈូន ដើ កយ៉ក់ ម៉ើ តៀត ខឿង គ្លឹម ណគ់ មែ ម៉ើ រន់ឋាប់ ជុ អន់នួរ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ហំប៊្រុះ ម៉ើ ប៊ឹះ តគ់ អ៊ែ ម៉ើ តៃ តម៉ ក្រឡឹល ម៉ើ ព្រលូ កន់ស៊ីត ហឹ ដៀក ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","អ៊ែ ម៉ើ មឹត ហឹ ត្រម ម៉ើ តៃ យ៉ាវ កយ៉ក់ គ្រែដៃ យែស៊ូ ឡើ កន់ដ្រាគ់ ឡើ ប៉ាត់ ខៀង ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ប៊ឹង មែ កទ្រី ម៉ើ ញ៉ម ដើ កាន នែ ហំប៊្រុះ ដើ អ៊ែ ម៉ើ តៃ ប្រយ កឡ បារ រ៉ា ប្រវ៉ើន ហណក អំប្រា តូវ ឡើ ចាល់ ធឺង ប្រយ អំប្រា ឆុង ដៀក មែ។ ");
INSERT INTO brb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","មែ កទ្រី ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ ម៉ើ កឈុះ ទិ ពដិះ កឡ បារ រ៉ា អ៊ែ អំប្រា ហាយ ដើ មែ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ដក់ ឝ្លាំង បនឹះ ឡើ ញិវ ហឹ ឞន ចនុ កយ៉ក់ ប៉ាគ់ នែ? ");
INSERT INTO brb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ឡើ គូ យ៉ាវ ប៊ឹង នែ ឡើ ញិវ ឡឹះ ឡើយ។ វន់ចនិះ យ៉ឹ ហឹ ប្រម៉ាង ណគ ឡើ ហាយ ដើ វែ ទឹង ណាគ់ ឡើ គូ ហឹ ស្រុក ឝ៉ាលីលែ រៀន ");
INSERT INTO brb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“កួន បនឹះ ឡើ ត្រ មន់រ៉ាប់ ម៉ប ហឹ ទី បនឹះ ឞាប មន់ពឡាះ ប៉ាង កជែត ណគ ប៊ឹង ឡង អង់ឝ៉ាង តគ់ តង៉ៃ ទី ពែ អ៊ែ លំញិវ ឡឹះ អន់ណាវ”»។ ");
INSERT INTO brb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","អ៊ែ មែ កទ្រី ម៉ើ ចនិះ ភៀក ហឹ ប្រម៉ាង ណគ ពន់ឋើម។ ");
INSERT INTO brb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","អ៊ែ ម៉ើ ជឹ វឹញ ប្រយ តើម ប៊ឹង ត្រម ច្រាង ម៉ើ ហាយ លែក ដើ កាន ម៉ើ តៃ អន់ឌូ ដើ មែ លុកស៊ិក ជិត មូយ រ៉ា ដើម ដើ មែ ម៉ើ គូ អរែង ប៊ឹង មែ ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","មែ កទ្រី ណគ់ ម៉ើ ប៉ច កាន អ៊ែ ដើ មែ ពចាំ កាន ដើ គ្រែដៃ យែស៊ូ ឡើ ប៊ិច ណាង ម៉ារី ស្រ៊ុក ម៉ាដាឡា ណាង យ៉ូហាណា ណាង ម៉ារី មែគ យ៉ាកុប ដើម មែ កទ្រី អន់នឺ អន់ណាវ ណគ់ ម៉ើ ដក់ អរែង ប៊ឹង មែ។ ");
INSERT INTO brb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ហាក់ មែ កឡា ពហាយ ម៉ើ ចាប់ អឹ ប្រម៉ាង មែ កទ្រី ម៉ើ រៀន មែ កទ្រី ម៉ើ ម៉ាង ឆ្រឡិ ឆ្រលួគ។ ");
INSERT INTO brb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","អ៊ែ ដើ យ៉ាគ់ ពែត្រុះ ឡើ ឌឹក ត្រយ៉ាវ ឆ្រលៀង ឝ្លាំង ហឹ ត្រម ច្រាង ឡើ តៃ វ៉ិះ ឌិវ ហំបាន ប្រណវ កយ៉ក់ ឡើ ជឹ វឹញ ហឹ ទឺ ឡើ ញ៉ម ទុត ខាក់ ប្រយ ដើ កាន គ្រែដៃ យែស៊ូ ឡើ ប៉ាត់។ ");
INSERT INTO brb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ទឹង តង៉ៃ ហង់អ៊ែ ទឺ លុកស៊ិក បារ រ៉ា អំប្រា ដក់ ហឹ ស្រ៊ុក អ៊ែម៉ូះ ចង៉ាយ តើម ប៊ឹង មួង យែរូសាឡឹម ជិត មូយ កឡូម៉ិត។ ");
INSERT INTO brb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","អំប្រា ចជែ លែក ដើ កាន ម៉ើ ដុង ដើម ម៉ើ តៃ។ ");
INSERT INTO brb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ទឹង អំប្រា ចជែ មម៉ាង ត្រឌីវ អំប្រា គ្រែដៃ យែស៊ូ ឡើ ប៊ឹះ ប្រយ តគ់ អំប្រា ឡើ ដក់ អរែង ប៊ឹង អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","អំប្រា តៃ គ្រែដៃ យែស៊ូ ឡើ ដក់ អរែង ប៊ឹង អំប្រា ហាក់ អំប្រា ហឝ៉ាវ អ៊ឺម ណគ។ ");
INSERT INTO brb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","គ្រែដៃ យែស៊ូ ឡើ តង៉ា អំប្រា រៀន៖ «សប្រា ដក់ ប៉ាគ់ ចជែ កាន ង៉ាយ អិះ?»។ អំប្រា ជឹង ឆ្រួយ ប្រយ អំប្រា គូ។ ");
INSERT INTO brb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","បឹ មូយ រ៉ា ម៉ាត់ ណគ គ្លែវប៉ះ ឡើ ត្រណើវ រៀន៖ «លែក ដើ បនឹះ ម៉ើ គូ ទឹង មួង យែរូសាឡឹម ម៉ើ ដុង ឡើយ កាន ឡើ កើត ឡៃ អន់នួរ ប៉ិ វ៉ិះ ឌិវ ហៃ តៃ ហដុង អំម៉ឹះ?»។ ");
INSERT INTO brb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","គ្រែដៃ យែស៊ូ ឡើ តង៉ា អំប្រា រៀន៖ «កាន អង់ង៉ាយ ដឹះ?»។ អំប្រា ត្រណើវ រៀន៖ «កាន យ៉ាគ់ យែស៊ូ ស្រ៊ុក ណាសារែត។ ណគ ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ។ គ្រែដៃ ដើម មែ ក្លាង ស៊្រុក ម៉ើ តៃ លែក ដើ កាន ណគ ឡើ បើម ដើម លែក ដើ ប្រម៉ាង ណគ ឡើ ពហាយ អ៊ែ ម៉ើ រៀន កាន នែ ឡើ ឆង៉ាត់ ទុត ខាក់។ ");
INSERT INTO brb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","មែ ទិះ ក្រាគ់ បប៊ុះ ថួយ ដើម មែ ទិះ ក្រាគ់ សុនសាត ង៉ាយ ម៉ើ ឈូន ណគ ដើ កឡា ឡើ ពែក ប៉ាក់ ស្រុក ង៉ាយ ម៉ើ ប៉្រៃ អាំ លំពថូត កជែត ពឡាះ ប៉ាង ណគ ប៊ឹង ឡង អង់ឝ៉ាង។ ");
INSERT INTO brb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ញ៉ា ញ៉ើ មឹង រៀន យ៉ាគ់ អន់នែ ឡើយ លំឡោះ សុនសាត អ៊ីស្រាអ៊ែល។ មូយ ឡឹះ អន់ណាវ កាន លែក អ៊ែ ឡើ ក្លើច ពែ តង៉ៃ ណិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ដើម ប៊ិច មែ កទ្រី អន់នឺ រ៉ា ទឹង បូវ ញ៉ា ម៉ើ បើម អាំ ញ៉ា ញ៉ើ ញ៉ម ទុត ត្រពិត ម៉ើ ដក់ ហឹ ត្រម ច្រាង កយ៉ក់ តើម ភុង មាំង។ ");
INSERT INTO brb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ហាក់ ម៉ើ តៃ អ៊ឺម កយ៉ក់ អ៊ែ ម៉ើ ជឹ វឹញ ហាយ ដើ ញ៉ា រៀន ម៉ើ តៃ ឞាវ គ្រែដៃ បារ រ៉ា អំប្រា ហាយ ដើ មែ រៀន គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","បូវ ញ៉ា អន់នឺ រ៉ា ម៉ើ ដក់ ឝ្លាំង ប៉ាគ់ទឺ ហឹ ត្រម ច្រាង អ៊ែ ម៉ើ តៃ ប៉ាគ់ ប្រម៉ាង មែ កទ្រី ម៉ាត់ ម៉ាត ហាក់ ម៉ើ តៃ អ៊ឺម គ្រែដៃ យែស៊ូ»។ ");
INSERT INTO brb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ អំប្រា រៀន៖ «អូ បនឹះ តៃ ណោះ ឌូរ វ៉ារ តៃ ណោះ វ៉ាត វ៉ុង អើយ! វ៉ើ ពញ៉ាក ចាប់ លែក ដើ ប្រម៉ាង មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ើ ពហាយ ពន់ឋើម ");
INSERT INTO brb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","គ្រែដៃ គ្រិះ ឡើ ត្រ ធុក ញ៉ាក ចា ឈិ ឞាល់ អិះ ឡើយ អន់ដៃ ទឹង ហូច លំឌឹក ទឹង ហូង គ្រែ ទុត យ៉ូកយ៉ាល់»។ ");
INSERT INTO brb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ប៊្លី អ៊ែ ណគ ឡើ ពហាយ ពឡាក់ ដើ អំប្រា លែក ដើ កាន អង់ង៉ាយៗ ម៉ើ ម៉ាង ហឹ គ្រែដៃ យែស៊ូ ណគ់ ម៉ើ ខៀន ជុ ទឹង ពឹម គ្រែដៃ តើម ប៊ឹង ពឹម យ៉ាគ់ ម៉ូស៊ែ ឆា លែក ដើ ពឹម កឡា ឈូន ប្រម៉ាង គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","តគ់ ដៀប មន់ប៊ឹះ ស្រ៊ុក ណគ់ អំប្រា លុកស៊ិក អំប្រា ងុញ គូ អ៊ែ ដើ គ្រែដៃ យែស៊ូ ឡើ បើម ប៉ាគ់ ឡើ ងុញ ជឺរ។ ");
INSERT INTO brb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","អ៊ែ អំប្រា រ៉ុង គ្រែដៃ យែស៊ូ រៀន៖ «ហន់គូ ប៊ឹង ញឺ អន់ដៃ យ៉ាក់ ឡើ អំប៊ឹ ម៉ាត់ តង៉ៃ ដៀប ឡើ លុច ឡើយ»។ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ មឹត គូ ម៉ាត ប៊ឹង អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ ដ្រូម ចង់ អរែង ប៊ឹង អំប្រា អ៊ែ ឡើ ចក់ ណំពាំង ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ប៊្លី អ៊ែ ឡើ កដោះ អាំ ដើ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ហំប៊្រុះ ដើ អ៊ែ ម៉ាត់ អំប្រា ណោះ ហឝ៉ាវ ប្រយ ណគ អ៊ែ ដើ ណគ កអវ ឡើ ប៉ាត់ ប្រយ ខៀង។ ");
INSERT INTO brb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","អ៊ែ អំប្រា ចជែ ត្រឌីវ អំប្រា រៀន៖ «ប៉ាគ់ អ៊ែ ហន់ឆា បញឹម ក្លើម រ៉ើម ពណាត់ ឞាល់ អ៊ែ ទឹង ឡើ ព្រតូវ បា តៃ ទ្រូង ដើម ឡើ ពដៃ ពហាយ ប្រម៉ាង ទឹង ពឹម គ្រែដៃ ដើ បា អាំ បណោះ ហឡាក់»។ ");
INSERT INTO brb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ហំប៊្រុះ ដើ អ៊ែ អំប្រា ឌឹក ជឹ សប៊្រីវ ប្រយ ហឹ មួង យែរូសាឡឹម ទឺ អ៊ែ អំប្រា តៃ មែ កឡា ពហាយ លែក ជិត មូយ រ៉ា ដើម បូវ ប៊ែង ម៉ើ គូ ណាគ់ ស្រូមៗ ប៊ឹង អ៊ែ។ ");
INSERT INTO brb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ម៉ើ ហាយ ដើ អំប្រា រៀន៖ «គ្រែដៃ កន់ដ្រាគ់ ឡើ ញិវ ឡឹះ ម៉ាត់ ម៉ាត ឡើយ ញឹះ ឡើ ពដៃ ចាក់ ដើ យ៉ាគ់ ស៊ីម៉ូន ឡើ តៃ»។ ");
INSERT INTO brb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","អ៊ែ ដើ អំប្រា អំប្រា ពហាយ ប៉ាគ់ទឺ ណគ់ កាន អំប្រា តៃ ដើម អំប្រា ដុង ទឹង អំប្រា ដក់ តៃ ទ្រូង អន់ឌូ ដើម កាន អំប្រា ណោះ ហឝ៉ាវ គ្រែដៃ យែស៊ូ ប៊ឹង ឡើ កដោះ ណំពាំង ដិ។ ");
INSERT INTO brb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ទឹង ប៉ះ អំប្រា ពប៉ច កាន អំប្រា ហំប៊្រុះ ដើ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ឆុង ប្រយ ទឹង កឌីៗ មែ អ៊ែ ឡើ ម៉ាង ដើ មែ រៀន៖ «វែ លែក រ៉ា វន់គូ ឆនឹម ហន់ណាំង ឡើយ យ៉ឹ»។ ");
INSERT INTO brb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ហំប៊្រុះ ម៉ើ តៃ ណគ ម៉ើ ឌូង តូវ ម៉ើ សសឹរ ចាក់ អន់ឆាក់ យ៉ាង ប្រយ យ៉ាក់ ម៉ើ ឃឹត រៀន អំប កយ៉ក់។ ");
INSERT INTO brb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ដើ មែ រៀន៖ «ប៉ិ ឡើ ត្រ វ៉ើ ឌូង ប៉ាគ់ នែ? វ៉ើ ចាប់ អ៊ឺម ឡះ អៃ អញិវ ឡឹះ អន់ណាវ? ");
INSERT INTO brb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ហឹ វន់ឝ្លាំង ឡាំង ទី ឈឹង អៃ អ៊ែ វន់ណោះ ហឡាក់ អៃ កឡឹ! វន់ដក់ ពឹត ឡាំង ចាក់ អៃ មែ កយ៉ក់ ម៉ើ ប៊ិច អ៊ឺម ច្រឡាត ម៉ាត លឺ កឌឺង ប៉ាគ់ ដើ អៃ នែ»។ ");
INSERT INTO brb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ប៊្លី ឡើ ម៉ាង ប៉ាគ់ អ៊ែ ឡើយ ឡើ ពដៃ ប្រយ ឈឹង ទី ណគ អាំ មន់តៃ។ ");
INSERT INTO brb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","មែ លុកស៊ិក ម៉ើ ញឹម ក្លើម ដិ ដើម ម៉ើ ញ៉ម ដិ ហាក់ ម៉ើ ចាប់ អ៊ឺម ប្រម៉ាង ណគ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ តង៉ា មែ រៀន៖ «ហឹ នែ ណាគ់ វ៉ើ ប៊ិច ចណង់ ចណា?»។ ");
INSERT INTO brb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","អ៊ែ ម៉ើ ចក់ ទ្រឺ អណាំង មូយ អន់ណូវ ម៉ើ អាំ ដើ គ្រែដៃ យែស៊ូ ");
INSERT INTO brb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","អ៊ែ ឡើ ចក់ ចា ប៊ឹង ងឺរ មែ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ហឹ មែ រៀន៖ «ទឹង អៃ ណាគ់ អគូ អរែង ប៊ឹង វែ ពន់ឋើម អហាយ ដើ វែ រៀន លែក ដើ ប្រម៉ាង ម៉ើ ពហាយ កាន អៃ ទឹង ពឹម យ៉ាគ់ ម៉ូស៊ែ ទឹង ពឹម មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ដើម ទឹង ពឹម ព្រតឹះ ព្រនែ គ្រែដៃ តង លំដាវ ម៉ាត់ ម៉ាត ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","អ៊ែ គ្រែដៃ ឡើ ប៉ច ពឡាក់ អាំ មែ មន់ណោះ ហឝ៉ាវ ខនៀន ទឹង ពឹម គ្រែដៃ ");
INSERT INTO brb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","គ្រែដៃ យែស៊ូ ឡើ ហាយ ដើ មែ រៀន៖ «កនុង ពឹម ម៉ើ ខៀន ជុ រៀន គ្រែដៃ គ្រិះ លំត្រ ធុក ញ៉ាក ចា ឈិ ដុ តៃ ឋាំ អ៊ែ លន់គែត។ តគ់ តង៉ៃ ទី ពែ លំញិវ ឡឹះ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","វន់ពហាយ កនុង អាតណាត ម៉ាត់ អៃ ដើ បនឹះ រៀន មន់ត្រ ពលិះ ចនិះ អាំ គ្រែដៃ លំតាក់ ឞាប មែ វន់ពហាយ កាន នែ តើម ប៊ឹង មួង យែរូសាឡឹម នែ ប្រយ ឋា ដើ ត្រំ សុនសាត។ ");
INSERT INTO brb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","វែ លែក រ៉ា ឡើយ វ៉ើ កឡា តៃ កាន នែ ហឡាក់ៗ អ៊ែ វន់ដក់ ពហាយ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","វន់ឝ្លាំង យ៉ឹ អៃ អន់អាំ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ លន់គូ ប៊ឹង វែ ត្រំ រ៉ា តាម ប្រម៉ាង គ្រែដៃ បើគ អៃ ឡើ ខណាត ដើ វែ។ វែ តង វន់គូ ទឹង មួង យែរូសាឡឹម ណិះ ឡើយ អន់ដៃ ឋា ដើ ប៊ឹះ គ្រែដៃ លំអាំ កាន ឆង៉ាត់ ដើ វែ»។ ");
INSERT INTO brb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ប៊្លី អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ចន់ដ្រា បូវ លុកស៊ិក ណគ ញឺះ តើម ប៊ឹង មួង ដក់ ចើម ស្រ៊ុក ប៊ែថានី។ ម៉ើ ប៊ឹះ តគ់ អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ប៊្រឹក ទី ឡើ ប្រាយ កាន ចាគ់ អាំ ដើ មែ។ ");
INSERT INTO brb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ទឹង ប៉ះ ឡើ ប្រាយ កាន ចាគ់ ដើ មែ ឡើ វីះ តើម ប៊ឹង មែ គ្រែដៃ បើគ ឡើ ប៊្រឹក ប្រយ ណគ ទឹង ហូង គ្រែ។ ");
INSERT INTO brb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ប៊្លី អ៊ែ មែ លុកស៊ិក ម៉ើ កដាប ហំបះ គ្រែដៃ យែស៊ូ ម៉ើ ជឹ វឹញ ហឹ មួង យែរូសាឡឹម ទឺ តូវ ម៉ើ ញឹម ក្លើម ក្លាក រ៉គ់សំ ឆំតក តៃ ឋាំ ត្រំ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ម៉ើ ដក់ ព្រតឹះ ព្រនែ គ្រែដៃ ហឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ត្រំ តង៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","យ៉ាគ់ ធែវភីល អើយ អម៉ើត ហាយ ដើ ហៃ រៀន ទឹង កនុង ផាប់ ទី មូយ អៃ អខៀន លែក ដើ កាន គ្រែដៃ យែស៊ូ ឡើ បើម ដើម លែក ដើ ប្រម៉ាង ឡើ ពង់ហៀន តើម ប៊ឹង ឡើ ពន់តើម បើម កាន គ្រែដៃ ");
INSERT INTO brb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ឆា ដើ ប៊ឹះ គ្រែដៃ ឡើ ប៊្រឹក ណគ ទឹង ហូង គ្រែ។ អន់នួរ ឡើ ឌឹក ឡើ ថាន់ ថយ តាម លញ៉ាគ់ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ដើ មែ ពចាំ កាន ដើ ណគ ណគ់ ឡើ រ៉ើះ។ ");
INSERT INTO brb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ប៊្លី ឡើ ធុក ញ៉ាក ឆា ដើ គែត លែវ ឡើយ គ្រែដៃ យែស៊ូ ឡើ ពដៃ ចាក់ ណគ អើន តង ដើ មែ កឡា ពហាយ អាំ ម៉ើ តៃ ហឡាក់ រៀន គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ ម៉ាត់ ម៉ាត។ ណគ ឡើ ពដៃ ចាក់ ដើ មែ លែក ពួន ជិត តង៉ៃ ដើម ឡើ ហាយ ដើ មែ កាន គ្រែដៃ ឡើ ពែក ប៉ាក់ ដិ។ ");
INSERT INTO brb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ទឹង ប៉ះ ឡើ ចង់ អរែង ប៊ឹង មែ កឡា ពហាយ ឡើ កំប៊ែត មែ រៀន៖ «ញ៉ង វ៉ើ វីះ អ៊ឺម តើម ប៊ឹង មួង យែរូសាឡឹម វន់ចាំ ឆា ដើ ប៊ឹះ បើគ អៃ លំអាំ ផវ យ៉ាង ចាគ់ លួង ណគ ដើ វែ តាម ឡើ ខណាត ប៉ាគ់ អៃ អហាយ ដើ វែ អន់នួរ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","យ៉ាគ់ យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក ដើ មែ ក្លាង ស៊្រុក ហាក់ ដើ វែ ណាគ់ ឞិត ឞ៊ែត គ្រែដៃ លំតម៉ូច វែ ដើ ផវ យ៉ាង ចាគ់ លួង ណគ ឡើយ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ទឹង អ៊ែ មែ ពចាំ កាន ដើ គ្រែដៃ យែស៊ូ ម៉ើ ដក់ តមួត ប៊ឹង ណគ ម៉ើ តង៉ា ណគ រៀន៖ «អើយ គ្រែដៃ កន់ដ្រាគ់! ហៃ ហន់ឌឹក បើម សឋិច ដើ ង៉ាយ អ៊ីស្រាអ៊ែល អាំ ងន់ពែក ប៉ាក់ ប៊្រី ដាក ង៉ាយ កឡឹ ឡឹះ អន់ណាវ ទឹង ប្លះ ណិះ ឡើយ ឡះ?»។ ");
INSERT INTO brb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ណគ ឡើ ត្រណើវ ម៉ាង មែ រៀន៖ «សណូវ អ៊ឺម វន់ណោះ ណគ់ តង៉ៃ ខៃ គ្រែដៃ បើគ ឡើ ទែង ជុ តាម អាតណាត ណគ កឡឹ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ហាក់ ដើ វែ ទឹង ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ លំទឺះ គូ ទិ វែ វន់ដូវ កាន ឆង៉ាត់។ អ៊ែ ឡើយ វន់ដូវ បើម កឡា ប៉ច កាន វ៉ើ តៃ ដើម វ៉ើ ដុង តើម ប៊ឹង អៃ តើម ប៊ឹង មួង យែរូសាឡឹម បុ ស្រុក យូដា ស្រុក សាម៉ារី ឋា ដើ ប៊ឹះ ព្រទុត ឡាង ប្រិះ»។ ");
INSERT INTO brb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ប៊ឹង គ្រែដៃ យែស៊ូ ឡើ ម៉ាង ប៉ាគ់ អ៊ែ លែវ ឡើយ បូវ កឡា ពហាយ ទឹង ម៉ើ ឝ្លាំង ណគ អ៊ែ គ្រែដៃ បើគ ឡើ ប៊្រឹក ណគ ទឹង ហូង គ្រែ ដើម ឡើ ប៊ិច យូក ឡើ ពាំង ណគ ប៉ាត់ តាក់ ប្រយ ម៉ើ តៃ យ៉ាវ ណគ។ ");
INSERT INTO brb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ទឹង ប៉ះ ម៉ើ ង៉ើយ ឝ្លាំង ណគ ឡើ ឌឹក ទឹង គ្រែ ហំប៊្រុះ ដើ អ៊ែ ប៊ិច កឡ បារ រ៉ា អំប្រា ត្រទ្រូប ហហក បក់ បក ឆុង ដៀក មែ ");
INSERT INTO brb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","អំប្រា រៀន៖ «បូវ ស្រុក ឝ៉ាលីលែ អើយ! វ៉ើ ឆុង ង៉ើយ ឝ្លាំង បើម ង៉ាយ ទឹង គ្រែ ប៉ាគ់ នែ? យែស៊ូ អ៊ែ គ្រែដៃ បើគ ឡើ ប៊្រឹក ណគ តើម ប៊ឹង វែ ឡើ ជឹ តៀត ទឹង ហូង គ្រែ ឡើយ។ តគ់ តង៉ៃ លន់ជឹ វឹញ ប៉ាគ់ វែ វ៉ើ តៃ ណគ ឡើ ឌឹក ប៉ាគ់ អ៊ែ ទឺ ឡើយ លំទឺះ ទិ នែ»។ ");
INSERT INTO brb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","លែវ អ៊ែ ម៉ើ ជឹ វឹញ តើម ប៊ឹង ចន់ឌូ តើម អូលីវ ហឹ មួង យែរូសាឡឹម អន់ណាវ ចង៉ាយ ទ្រូង ដក់ មូយ កឡូ ម៉ិត អ្យាង។ ");
INSERT INTO brb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ហំប៊្រុះ ម៉ើ ប៊ឹះ តគ់ ហន់ណាម ម៉ើ ឌឹក ទឹង អន់ឡើ ពឺង ណគ់ កនូ ម៉ើ ខើយ គូ។ លែក ដើ មែ អ៊ែ ប៊ិច យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ូហាន យ៉ាគ់ យ៉ាកុប យ៉ាគ់ អន់ឌ្រែ យ៉ាគ់ ភីលីប យ៉ាគ់ ថូម៉ះ យ៉ាគ់ បារថូឡូមែ យ៉ាគ់ ម៉ាថាយ យ៉ាគ់ យ៉ាកុប កួន យ៉ាគ់ អាល់ផាយ យ៉ាគ់ ស៊ីម៉ូន ម៉ើ ជុ រៀន “បូវ ស៊ីឡូត” ដើម យ៉ាគ់ យូដះ កួន យ៉ាគ់ យ៉ាកុប។ ");
INSERT INTO brb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","បូវ មែ លែក រ៉ា ម៉ើ តមួត ចនិះ ក្លើម ឌិវ មូយ កនូយ អ៊ឺរ ដាំង គ្រែដៃ។ ឡើ ប៊ិច កទ្រី អន់នឺៗ ម៉ើ មឹត អរែង ប៉ាគ់ទឺ ដើម ឡើ ប៊ិច ណាង ម៉ារី មែគ គ្រែដៃ យែស៊ូ ដើម អោះ កឡ គ្រែដៃ យែស៊ូ កឡឹ ដិ។ ");
INSERT INTO brb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","តង៉ៃ មូយ ប៊ិច មែ ម៉ើ ចាប់ គ្រែដៃ យែស៊ូ មូយ ក្លាំ បារ ជិត រ៉ា អ្យាង ម៉ើ តមួត ពស៊ុំ អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ឌឹក ឆុង ទឹង កឌី មែ ឡើ ហាយ រៀន៖ ");
INSERT INTO brb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«មិះ ដាគ់ យ៉ាគ់ ប៉ អើយ! ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ឡើ ពហាយ តើម ឡៃ មាំង ឡើយ តាម លញ៉ាគ់ សឋិច ដាវីត កាន យ៉ាគ់ យូដះ ឡើ តៀត មែ ទិះ ក្រាគ់ ដក់ រ៉ាប់ គ្រែដៃ យែស៊ូ។ កាន នែ ឡើ ត្រ កើត ដាវ ប៉ាគ់ ប្រម៉ាង ទឹង ពឹម គ្រែដៃ ម៉ាត់ ម៉ាត។ ");
INSERT INTO brb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","សំយ៉ះ យូដះ នែ ឡើ បូវ ង៉ាយ កតាម ពន់ឋើម ឡើ បើម កាន អរែង ប៊ឹង ង៉ាយ ប៉ាគ់ទឺ ");
INSERT INTO brb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ណគ ឡើ ដូវ លៀន តើម ប៊ឹង កាន កលីះ ម៉ប គ្រែដៃ យែស៊ូ លៀន អ៊ែ ឡើ ដក់ រួត ប្រិះ មឺរ មូយ អំប៊ុ ប៊្លី អ៊ែ ឡើ បង់ ក្រស៊ឹបៗ ឆឡិច ក្លាក ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","មែ បូវ ទឹង មួង យែរូសាឡឹម ម៉ើ ដុង កាន នែ ត្រំៗ រ៉ា អ៊ែ ឡើ ត្រ ម៉ើ ជុ មឺរ អន់នែ តាម ប្រម៉ាង មែ កឡឹ រៀន “ហាកិលដាម៉ា” ង៉ើ ជុ ប្រម៉ាង ង៉ាយ រៀន “មឺរ ផាម”»។ ");
INSERT INTO brb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«ប៉ាគ់ អ៊ែ ឡើយ អ៊ែ សឋិច ដាវីត ឡើ ខៀន ជុ កាន យូដះ អ៊ែ ទឹង ពឹម ព្រតឹះ ព្រនែ គ្រែដៃ រៀន៖ “ណគ់ កនូ ណគ លំត្រ ហ្រហៀង ហ្រហាប់ តៃ អាំ មែ ង៉ាយ មន់គូ ប៊ឹង អ៊ែ យ៉ាវ” មូយ អន់ណាវ “លំត្រ មែ គែង អន់ណាវ មន់ថរ កាន ង៉ាន ណគ”»។ ");
INSERT INTO brb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«ញ៉ន នែ ឡើយ ញ៉ះ ញន់រ៉ើះ បឹ មូយ រ៉ា អន់ណាវ ទឹង បូវ ង៉ាយ ង៉ើ តូយ អន់សច គ្រែដៃ យែស៊ូ ឡើ កន់ដ្រាគ់ ទឹង ណាគ់ ឡើ គូ ប៊ឹង ង៉ាយ ");
INSERT INTO brb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","តើម ប៊ឹង យ៉ូហាន ឡើ បើម ឞ៊ុន តម៉ូច ដាក ដើ គ្រែដៃ យែស៊ូ ឋា ដើ ប៊ឹះ តគ់ គ្រែដៃ បើគ ឡើ ប៊្រឹក ណគ តើម ប៊ឹង ង៉ាយ។ តង ប៊ិច មូយ រ៉ា មន់ពតាង យ៉ាគ់ យូដះ លំដក់ អរែង ប៊ឹង ង៉ាយ ប៉ច ដើ បូវ រៀន ង៉ើ តៃ គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ អន់ណាវ»។ ");
INSERT INTO brb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","អ៊ែ ម៉ើ រ៉ើះ បនឹះ បារ រ៉ា បឹ មូយ រ៉ា ម៉ាត់ ណគ យ៉ូស៊ែប មូយ ឡឹះ អន់ណាវ ម៉ាត់ ណគ ម៉ាថៀះ។ យ៉ាគ់ យ៉ូស៊ែប នែ ម៉ើ ជុ ម៉ាត់ ណគ ពែ អន់នឺ ម៉ើ ជុ ណគ បារសាបះ មែ អន់នឺ ម៉ើ ជុ ណគ យូសទុះ។ ");
INSERT INTO brb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ប៊្លី អ៊ែ ម៉ើ អ៊ឺរ ដាំង គ្រែដៃ រៀន៖ «ឡា គ្រែដៃ កន់ដ្រាគ់ អើយ ហៃ ហកឡា ហង់ឝ៉ាវ ចនិះ ខនឹត បនឹះ លែក រ៉ា ឡា អុះ ហំពដៃ អាំ ដើ ញ៉ា ញន់ណោះ ដិ រៀន ទឹង អំប្រា បារ រ៉ា នែ ណគ់ អង់ង៉ាយ ហម៉ើត រ៉ើះ ");
INSERT INTO brb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","បក់ លំបើម កឡា ពចាំ កាន ថរ យូដះ យ៉ាក់ យូដះ នែ ឡើ តាក់ ឡើយ កាន ង៉ាន នែ ឡើ ដក់ ហឹ កនូ ឡើ ត្រ គូ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ម៉ើ ព្រលូក  ឡើ ត្រ ប៉ុះ យ៉ាគ់ ម៉ាថៀះ អ៊ែ ម៉ើ តមឹត ប្រយ ណគ ទឹង បូវ ពចាំ កាន ជិត មូយ រ៉ា អ៊ែ អន់ណាវ។ ");
INSERT INTO brb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ប៊ឹង ឞ៊ុន “ឞ៊ុន តង៉ៃ សើង ជិត ” បូវ មែ ចាប់ គ្រែដៃ យែស៊ូ ម៉ើ ពទុំ តមួត មូយ អំប៊ុ។ ");
INSERT INTO brb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ហំប៊្រុះ ដើ អ៊ែ ម៉ើ ដុង ឡើ ស៊ឹរ តើម ទិ គ្រែ អ៊ិង ហអ៊ីង ឡើ លឺ ប៉ាគ់ កយឺវ ទុត ថាំង ប៊ិង កនុង ហន់ណាម មែ ម៉ើ គូ។ ");
INSERT INTO brb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","បូវ មែ ទឹង ហន់ណាម ម៉ើ តៃ ប៉ាគ់ ពឡា អ៊ុញ ឡើ អ្រឡះ ឡើ គូ ប៊ឹង ទូះ មែ ត្រំ រ៉ា។ ");
INSERT INTO brb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","អ៊ែ មែ លែក រ៉ា ម៉ើ ប៊ិង ដើ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ  អ៊ែ ម៉ើ ចជែ ប្រម៉ាង ចង់ហ ដិ អន់ដិ ប្រយ ប្លះ មែ តាម ផវ យ៉ាង គ្រែដៃ ឡើ អាំ។ ");
INSERT INTO brb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ទឹង មួង យែរូសាឡឹម អ៊ែ ប៊ិច សុនសាត យូដា ណគ់ មែ ម៉ើ ខើយ បើម ត្រួយ តាម ប្រម៉ាង គ្រែដៃ ម៉ើ ប៊ឹះ តើម ប៊ឹង ស្រុក អង់គែងៗ ទឹង ឡាង ប្រិះ នែ ម៉ើ ដក់ មឹត ឞ៊ុន ទឹង មួង ប៉ាគ់ទឺ។ ");
INSERT INTO brb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ទឹង ម៉ើ ដុង ស៊ឹរ ប៉ាគ់ អ៊ែ មែ ក្លាង ស៊្រុក ទុត អើន ម៉ើ ដក់ យ៉ាវ ឝ្លាំង មែ ត្រំ រ៉ា ម៉ើ ដុង បូវ ចាប់ គ្រែដៃ យែស៊ូ ម៉ើ ចជែ ប្រម៉ាង មែ គែង ដិ អន់ដិ ប្លះ មែ ម៉ើ ចជែ ដើ ប្រម៉ាង មែ តមួយ តើម ប៊ឹង គែង អ៊ែ ម៉ើ ឝ្លាំង ហ្រហឹ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","បូវ មែ តមួយ តូវ ម៉ើ បើម ទុត អ៊ែ ម៉ើ ចជែ ត្រឌីវ មែ រៀន៖ «ណគ់ លែក ដើ មែ ម៉ើ ចជែ នែ ម៉ាត់តូវ បូវ ស្រុក ឝ៉ាលីលែ ហវ៉ៃ។ ");
INSERT INTO brb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ប៉ិ ឡើ ត្រ លែក ដើ ង៉ាយ ង៉ើ ដុង មែ ម៉ើ ណោះ ចជែ ប្រម៉ាង ញ៉ា ញឹះ ត្រំ រ៉ា ប៉ាគ់ អ៊ិន អិះ? ");
INSERT INTO brb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","លែក ដើ ញ៉ា ញ៉ើ ប៊ឹះ តើម ប៊ឹង ស្រុក គែង ប៉ាគ់ ឡើ ស្រុក ប៉ារថុះ ស្រុក មែឌី ស្រុក អ៊ែឡាំ ដើម ស្រុក មែសូប៉ូតាមី ស្រុក យូដា ស្រុក កាប៉ាដូកៀ ស្រុក ប៉ុនតុះ ស្រុក អាស៊ី ");
INSERT INTO brb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ស្រុក ព្រីគី ស្រុក ប៉ាមភីលី ស្រុក អ៊ែស៊ីប ស្រុក លីប៊ី ណគ់ ឡើ បរ ដៀក ស្រុក គីរែន ដើម បូវ មែ ម៉ើ ដក់ កវាំង តើម ប៊ឹង ស្រុក រ៉ូម ");
INSERT INTO brb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ទឹង បូវ មែ នែ ប៊ិច សុនសាត យូដា ដើម មែ ម៉ើ មឹត ហ៊ីត ខើយ យូដា ដិ ដើម មែ ម៉ើ ប៊ឹះ តើម ប៊ឹង ចូន គ្រែត ដើម សុនសាត អារ៉ាប់ ញ៉ា ញ៉ើ ដុង ម៉ើ ប៉ច កាន ឆង៉ាត់ គ្រែដៃ ដើ ប្រម៉ាង ញ៉ា កឡឹ!»។ ");
INSERT INTO brb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","បូវ មែ នែ តូវ ម៉ើ ទុត ទ្រូង តៃ ណោះ ឃឹត ប៉ាគ់ ង៉ាយ យ៉ាវ អ៊ែ ម៉ើ តង៉ា ត្រឌីវ មែ រៀន៖ «កាន ឡើ កើត នែ ណោះ ប៉ាគ់ ង៉ាយ?»។ ");
INSERT INTO brb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ហាក់ ប៊ិច អន់នឺ រ៉ា ម៉ើ ពន់ឆាំ រៀន៖ «បូវ មែ នែ បូវ ប៊ូ តវែ អង់ង៉ាម ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ឌឹក ឆុង អរែង ដើ មែ កឡា ពចាំ កាន ជិត មូយ រ៉ា ឡើ ពប៉ច ប្រយ ដើ មែ ទឹង មួង ថាំងៗ រៀន៖ «មិះ ដាគ់ យ៉ាគ់ ប៉ សុនសាត យូដា ដើម វែ លែក រ៉ា ណគ់ វែ វ៉ើ គូ ទឹង មួង យែរូសាឡឹម អើយ! វន់ចង់ហៀង ប្រម៉ាង អៃ អាំ ហឡាក់ៗ អ៊ែ វន់ណោះ កាន ឡើ កើត នែ។ ");
INSERT INTO brb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","បូវ ញ៉ា នែ តៃ ត្រ ញ៉ើ ប៊ូ ញែត ប៉ាគ់ ប្រម៉ាង វែ វ៉ើ វ៉ឹត អ៊ឺម! ប៉ិ ញន់ណោះ ញែត ហន់ដើម ម៉ូង ជែន ងឹប ប៉ាគ់ នែ! ");
INSERT INTO brb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","កាន ណគ់ អន់នែ ឡើ ដាវ តាម ប្រម៉ាង យ៉ាគ់ យ៉ូអ៊ែល ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ឡើ ហាយ ជុ អន់នួរ ឡើយ ");
INSERT INTO brb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«“គ្រែដៃ ឡើ ហាយ រៀន ហឹ ព្រឡូច អន់ទុន អៃ អង់ហ៊ែង ផវ យ៉ាង អៃ លន់គូ ទឹង បនឹះ លែក រ៉ា។ អ៊ែ កួន កទ្រី កួន កឡ វែ មន់ឈូន ប្រម៉ាង គ្រែដៃ បូវ មែ ច្រហើវ ប្រោះ មន់តៃ ប្រាវៗ កាន អំពដៃ ដើ មែ អ៊ែ ណគ់ បូវ តង់កង់ យូ វែ មន់តៃ ហរ៉គ់ ប៉ាគ់ ពកី។ ");
INSERT INTO brb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ទឹង អ៊ែ អៃ អង់ហ៊ែង ផវ យ៉ាង អៃ លន់គូ ទឹង ឞយ អៃ កទ្រី ឆិ កឡ ឆិ អ៊ែ មន់ឈូន ប្រម៉ាង អៃ។ ");
INSERT INTO brb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","អៃ អំពដៃ កាន ឆង៉ាត់ ទិះ ទឹង គ្រែ ដើម កាន ពន់ជែម ទិ ឡាង ប្រិះ លំប៊ិច ផាម អ៊ុញ ដឹប អន់ញូយ ញឹះ ឡើ ងៀវ។ ");
INSERT INTO brb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","អន់នួរ តង៉ៃ គ្រែដៃ កន់ដ្រាគ់ លំប៊ឹះ តាត់ ស៊ិន អ៊ែ ម៉ាត់ តង៉ៃ លន់កឡាំ ប៊្រែ ប្រយ ណគ់ កើត លន់ចះ ប៉ាគ់ ផាម អន់ណាវ តង៉ៃ ហង់អ៊ិន តូវ លំធឺង ថាង អ៊្យ្រែង អយែង បុ មួង។ ");
INSERT INTO brb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","អន់នួរ លំប៊ឹះ តង៉ៃ អ៊ែ មែ ង៉ាយ មន់កឡូវ អ៊ឺរ ដាំង ម៉ាត់ គ្រែដៃ កន់ដ្រាគ់ មែ អ៊ែ មន់ដូវ កាន ហវ៉ាត់ ឡើយ!”»។ ");
INSERT INTO brb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«មិះ ដាគ់ យ៉ាគ់ ប៉ សុនសាត អ៊ីស្រាអ៊ែល អើយ វន់ចង់ហៀង ប្រម៉ាង អៃ នែ យ៉ឹ! វែ វ៉ើ ណោះ ប៉ាគ់ទឺ ឡើយ ទឹង គ្រែដៃ យែស៊ូ ស៊្រុក ណាសារែត ណាគ់ ឡើ គូ ប៊ឹង វែ គ្រែដៃ ឡើ ពដៃ ហឡាក់ ឡើយ ណគ កឡឹ ឡើ ប៉្រៃ យែស៊ូ ទឺះ ទិ វែ ដើម ឡើ អាំ អាតណាត ដើ ណគ អ៊ែ ឡើ ដូវ បើម កាន ឆង៉ាត់ ដើម កាន ហង់ឝ៉ាវ។ ញ៉ន នែ ឡើយ អ៊ែ វ៉ើ ណោះ រៀន ណគ ឡើ ប៊ឹះ តើម ទិ គ្រែដៃ។ ");
INSERT INTO brb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","យ៉ាគ់ យែស៊ូ នែ វែ វ៉ើ ឈូន ហឹ ទី បនឹះ តៃ ម៉ើ បើម ត្រួយ ប្រម៉ាង គ្រែដៃ អ៊ឺម បក់ ម៉ើ ប៉ាង កជែត ណគ ប៊ឹង ឡង អង់ឝ៉ាង តាម គ្រែដៃ ឡើ ទែង ជុ អន់នួរ ដើម ឡើ ណោះ តើម ពន់ឋើម ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ហាក់ យ៉ាគ់ គ្រែដៃ ឡើ ពញិវ ណគ តើម ប៊ឹង គែត គ្រែដៃ ឡើ ឡិះ ណគ តើម ប៊ឹង កាន ធុក ញ៉ាក ប៉ាប ពុន យ៉ាក់ កាន គែត ឡើ ដូវ អ៊ឺម ជុ ណគ។ ");
INSERT INTO brb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ទឹង ឡៃ មាំង សឋិច ដាវីត ឡើ ពប៉ច កាន គ្រែដៃ យែស៊ូ រៀន “អៃ អតៃ គ្រែដៃ កន់ដ្រាគ់ ប៊ឹង ងឺរ អៃ អន់សច យ៉ាក់ ណគ ឡើ គូ តៃ ទី ចម៉ា អៃ អ៊ែ ញឹះ តៃ អឌូង ដើ ង៉ាយ អ៊ឺម។ ");
INSERT INTO brb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","កាន នែ ឡើយ ឡើ បើម អាំ អញឹម ក្លើម ក្លាក តៃ ឋាំ ដើម អព្រតឹះ ព្រនែ រ៉គ់សំ ឆំតក ដើម អមឹង រង់ហៀវ ចាក់ ដៃ អៃ អំញិវ ឡឹះ។ ");
INSERT INTO brb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","គ្រែដៃ ហៃ តៃ ហន់តាក់ តណាក់ អ៊ឺម ផវ យ៉ាង អៃ ហឹ មួង កយ៉ក់ ហៃ តៃ ហំពន់ឋូយ អ៊ឺម ឞយ ចាគ់ លួង ហៃ លំសុ ប៊្លុច។ ");
INSERT INTO brb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","គ្រែដៃ ហពដៃ ដើ អៃ អន់ហឝ៉ាវ ទ្រូង ញិវ ឡូច អន់សច គ្រែដៃ ហៃ ហង់អាំ ដើ អៃ អន់ញឹម ក្លើម ក្លាក តៃ ឋាំ យ៉ាក់ ហគូ អរែង ប៊ឹង អៃ”»។ ");
INSERT INTO brb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«មិះ ដាគ់ យ៉ាគ់ ប៉ អើយ! អៃ អប៉ច ដាវ ហឡាក់ៗ ដើ វែ សឋិច ដាវីត ឡើ ម៉ិ យ៉ាគ់ ង៉ាយ ឡៃ មាំង ឡើ គែត ក្លើច ឡើយ អ៊ែ ម៉ើ កុប ណគ។ ណគ់ លុង កយ៉ក់ ណគ ឡើ ណាគ់ ប៊ឹង ង៉ាយ ឋា ដើ ប៊ឹះ ត្រំ តង៉ៃ នែ។ ");
INSERT INTO brb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","យ៉ាក់ សឋិច ដាវីត ឡើ កឡា ឈូន ប្រម៉ាង គ្រែដៃ មូយ រ៉ា អ៊ែ ណគ ឡើ ណោះ រៀន គ្រែដៃ ឡើ ខណាត តប៉ឹន ចាក់ ដើ ណគ លំអាំ កួន ចូវ ណគ មូយ រ៉ា លំឌឹក បើម សឋិច ត ណគ។ ");
INSERT INTO brb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","សឋិច ដាវីត ឡើ ណោះ អន់នួរ ឡើយ អ៊ែ ឡើ ហាយ រៀន គ្រែដៃ គ្រិះ លំញិវ ឡឹះ អន់ណាវ គ្រែដៃ តៃ លំតាក់ អ៊ឺម ណគ ហឹ មួង កយ៉ក់ ដើម តៃ លំអាំ ចាក់ ដៃ ណគ លំសុ ប៊្លុច ដិ។ ");
INSERT INTO brb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","យែស៊ូ នែ ឡើយ គ្រែដៃ ឡើ ពញិវ ណគ ញ៉ា ញ៉ើ កឡា តៃ កាន នែ ហឡាក់ៗ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","គ្រែដៃ បើគ ឡើ ប៊្រឹក យែស៊ូ ឌឹក គូ តៃ ចម៉ា ណគ អាំ លំពែក ប៉ាក់ អរែង ដើ ណគ អ៊ែ ឡើ អាំ ផវ យ៉ាង ចាគ់ លួង គ្រែដៃ ដើ ណគ តាម ប៉ាគ់ ណគ ឡើ ខណាត អ៊ែ គ្រែដៃ យែស៊ូ ឡើ ហ៊ែង ផវ យ៉ាង គ្រែដៃ លន់គូ ទឹង ញ៉ា ប៉ាគ់ វែ វ៉ើ តៃ ដើម វ៉ើ ដុង អិះ ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","សឋិច ដាវីត តៃ ឡើ ឌឹក អ៊ឺម ទឹង ហូង គ្រែ ហាក់ ណគ ឡើ ពហាយ រៀន “គ្រែដៃ កន់ដ្រាគ់ ឡើ ហាយ ដើ កន់ដ្រាគ់ អៃ រៀន ហន់ដ្រូម តៃ ចម៉ា អៃ នែ ");
INSERT INTO brb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ទឹង ហូច អៃ អំពញ៉ម ដ្រម៉ា ហៃ អំជុ បើម ឝណើវ ឈឹង ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ប៉ាគ់ ពអ៊ែ បូវ វែ អ៊ីស្រាអ៊ែល វន់ត្រ ណោះ ហឡាក់ រៀន យែស៊ូ នែ ណគ់ វែ វ៉ើ ពឡាះ ប៉ាង កជែត ប៊ឹង ឡង អង់ឝ៉ាង គ្រែដៃ ឡើ ពឌឹក ណគ បើម កន់ដ្រាគ់ ដើម ឡើ ពឌឹក បើម គ្រែដៃ គ្រិះ ដិ»។ ");
INSERT INTO brb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ហំប៊្រុះ មែ ក្លាង ស្រ៊ុក ម៉ើ ដុង យ៉ាគ់ ពែត្រុះ ឡើ ប៉ច ប៉ាគ់ អ៊ែ ស្រៀវ អ្រអវ ប្រយ ម៉ើ ដុង អ៊ែ ម៉ើ តង៉ា យ៉ាគ់ ពែត្រុះ ដើម មែ កឡា ពចាំ កាន ដិ អន់ដិ រៀន៖ «មិះ ដាគ់ យ៉ាគ់ ប៉ អើយ! ប៉ាគ់ ង៉ាយ វ៉ើ ប៉្រៃ ញំបើម អ៊ែ គ្រែដៃ លំតាក់ ថូត ដើ ញ៉ា?»។ ");
INSERT INTO brb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","យ៉ាគ់ ពែត្រុះ ឡើ ត្រណើវ មែ រៀន៖ «មិះ ដាគ់ យ៉ាគ់ ប៉ អើយ តង វន់ពលិះ ចនិះ ដក់ ដាំង គ្រែដៃ អន់ណាវ មូយ រ៉ាៗ តង វន់បើម ឞ៊ុន ម៉ូច ដាក កនុង ម៉ាត់ គ្រែដៃ យែស៊ូ គ្រិះ បក់ គ្រែដៃ លំតាក់ ថូត ដើ វែ អ៊ែ គ្រែដៃ លំអាំ ផវ យ៉ាង ចាគ់ លួង ណគ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","យ៉ាក់ គ្រែដៃ ឡើ ខណាត ប៉ាគ់ នែ ឡើយ ដើ វែ ដើ កួន ចូវ វែ ដើម ដើ បនឹះ លែក រ៉ា ម៉ើ គូ ហឹ ចង៉ាយៗ ប៉ាគ់ទឺ តាម អំម៉ើន គ្រែដៃ កន់ដ្រាគ់ ង៉ាយ លំរ៉ើះ»។ ");
INSERT INTO brb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","យ៉ាគ់ ពែត្រុះ នែ ឡើ ព្រតូវ ច្រូវ ពឡាក់ មែ ដើ ប្រម៉ាង ទុត អើន ដើម ឡើ ហាយ រៀន៖ «ឡា មិះ ដាគ់ យ៉ាគ់ ប៉ អើយ! វន់ឡា គ្រែដៃ លំហវ៉ាត់ វែ ដើម វន់វីះ តើម ប៊ឹង បនឹះ តណើរ អន់នែ ម៉ើ បើម កាន តៃ ចាគ់»។ ");
INSERT INTO brb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ណគ់ មែ ម៉ើ ចាប់ ប្រម៉ាង យ៉ាគ់ ពែត្រុះ ម៉ើ បើម ឞ៊ុន ម៉ូច ដាក ប្រយ។ ទឹង តង៉ៃ អ៊ែ ឡើ ប៊ិច បនឹះ ពែ ហលិក រ៉ា អ្យាង ហន់ដើម ម៉ើ ចាប់ គ្រែដៃ យែស៊ូ ម៉ើ មឹត អរែង ទឹង បូវ មែ។ ");
INSERT INTO brb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","បូវ មែ នែ ម៉ើ កនូយ ចង់ហៀង មែ កឡា ពចាំ កាន ម៉ើ ពង់ហៀន ម៉ើ គូ អរែង បើម ប៉ាគ់ អំម៉ោះ អោះ ម៉ើ បើម ឞ៊ុន កដោះ ណំពាំង ដើម ម៉ើ កនូយ អ៊ឺរ ដាំង គ្រែដៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","លែក ដើ មែ ម៉ើ គូ ហឹ មួង យែរូសាឡឹម ម៉ើ ឌូង អៀល បឹះ គ្រែដៃ ញ៉ន ដើ ម៉ើ តៃ បូវ កឡា ពចាំ កាន ម៉ើ បើម កាន ហឝ៉ាវ ដើម កាន ឆង៉ាត់ ទុត អើន។ ");
INSERT INTO brb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ណគ់ បូវ មែ ម៉ើ ចាប់ មឹង គ្រែដៃ យែស៊ូ ម៉ើ គូ អរែង ម៉ើ ប៊ិច ចនិះ ឌិវ មូយ ដើម រ៉ាះ អំបាះ មែ កឡឹ ណាគ់ ម៉ើ ជុ តមួត ត្រឌីវ មែ។ ");
INSERT INTO brb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ម៉ើ ហំពួត រ៉ាះ អំបាះ មែ កឡឹ លៀន ដណូវ មែ កឡឹ ម៉ើ ព្រណាក ត្រឌីវ មែ តាម មែ ម៉ើ តងកាន។ ");
INSERT INTO brb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ត្រំ តង៉ៃៗ ម៉ើ ដក់ តមួត ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ ដើម ម៉ើ ចង់ ចា អរែង បើម ឞ៊ុន កដោះ ណំពាំង តាម ហន់ណាម មែ កឡឹ ម៉ើ ចង់ ចា រ៉គ់សំ ឆំតក ម៉ើ ប៊ិច ចនិះ ប្រម៉ើត ឝម៉ៃ ត្រំ រ៉ា ");
INSERT INTO brb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ដើម ម៉ើ ព្រតឹះ ព្រនែ គ្រែដៃ ដិ។ អ៊ែ លែក ដើ មែ ក្លាង ស្រ៊ុក ម៉ើ ម៉ើត មែ។ គ្រែដៃ កន់ដ្រាគ់ ឡើ ទឺម ឡឹះ បនឹះ ណគ់ ឡើ ហវ៉ាត់ តមឹត អរែង ទឹង មែ ត្រំ តង៉ៃៗ។ ");
INSERT INTO brb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","តង៉ៃ មូយ យ៉ាគ់ ពែត្រុះ អំប្រា យ៉ាគ់ យ៉ូហាន អំប្រា ឌឹក ទឹង រ៉ូង ទិះ កដាប ហំបះ អំប្រា ដក់ អ៊ឺរ ដាំង គ្រែដៃ ទឹង ម៉ូង ពែ អំប៊ឹ។ ");
INSERT INTO brb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ត្រំ តង៉ៃ ប៊ិច បនឹះ ម៉ើ ទូង បឹ ញ៉ច ឈឹង ទី តើម ប៊ឹង ឡើ កើត ម៉ើ ដក់ ជុ តគ់ កម៉ង បយឺង រ៉ូង ទិះ កដាប ហំបះ ម៉ើ ជុ រៀន “កម៉ង ចណុង ចណាគ់” បក់ លំដូវ ឡា លៀន ហឹ មែ ម៉ើ មឹត ញឺះ ហឹ បយឺង។ ");
INSERT INTO brb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ហំប៊្រុះ ឡើ តៃ យ៉ាគ់ ពែត្រុះ អំប្រា យ៉ាគ់ យ៉ូហាន ទឹង អំប្រា មឹត ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ ឡើ ឡា ប្រយ លៀន ហឹ អំប្រា។ ");
INSERT INTO brb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","យ៉ាគ់ ពែត្រុះ អំប្រា យ៉ាគ់ យ៉ូហាន អំប្រា ឝ្លាំង ហឹ ណគ អ៊ែ ពែត្រុះ ឡើ រៀន៖ «ហង់ង៉ើយ ឝ្លាំង ទឹង ញឺ នែ!»។ ");
INSERT INTO brb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ណគ ឡើ ង៉ើយ ឝ្លាំង ទឹង អំប្រា ឡើ មឹង រៀន អំប្រា លំអាំ អង់ង៉ាយៗ ដើ ណគ។ ");
INSERT INTO brb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ហាក់ យ៉ាគ់ ពែត្រុះ ឡើ ហាយ ហឹ ណគ រៀន៖ «អៃ នែ អប៊ិច អ៊ឺម ឆៀង កាក់ ប៉្រាក់ ចៀម ហាក់ ណគ់ អង់ង៉ាយៗ អៃ អប៊ិច ហង់អិះ ឡើយ អង់អាំ ដើ ហៃ ប៉ាគ់ ពអ៊ែ ញ៉ន ដើ អាតណាត ឆង៉ាត់ ម៉ាត់ គ្រែដៃ យែស៊ូ គ្រិះ ឡើ ស្រ៊ុក ណាសារែត ហន់ឌឹក ឆុង ហន់ដក់ ហំមិញ!»។ ");
INSERT INTO brb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ប៊្លី អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ រ៉ាប់ ទី ចម៉ា ណគ ឡើ ពឌឹក ប្រណគ។ ហំប៊្រុះ ដើ អ៊ែ ត្រប៉ាង ដើម ក្រឡាវ ឈឹង ឡើ ឝ៉ិះ ទឹង នៀម ប្រយ ");
INSERT INTO brb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ប៊្លី អ៊ែ ឡើ ឌឹក ឃុត ឡើ អនឆូវ វឹញ ដក់ៗ ប្រយ ឡើ មឹត ហឹ បយឺង រ៉ូង ទិះ កដាប ហំបះ អរែង ដើ អំប្រា។ ឡើ ដក់ ប៉ាគ់ ច្រោះ អន់ច្រើន ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ដិ។ ");
INSERT INTO brb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","លែក ដើ បូវ ម៉ើ គូ ហឹ បយឺង ម៉ើ តៃ ណគ ឡើ ដក់ ដើម ឡើ ព្រតឹះ ព្រនែ គ្រែដៃ ដិ ");
INSERT INTO brb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","មែ ម៉ើ ហង់ឝ៉ាវ ណគ ណគ ឡើយ ឡើ ខើយ ដ្រូម ឡា លៀន ប៊ឹង កម៉ង “ចណុង ចណាគ់” ហឹ រ៉ូង ទិះ កដាប ហំបះ គ្រែដៃ អ៊ែ ម៉ើ ញ៉ម ហឡឹង ប្រយ យ៉ាក់ ម៉ើ តៃ ណគ ឡើ នៀម។ ");
INSERT INTO brb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ទឹង បឹ ហង់អ៊ែ ណាគ់ ឡើ គូ ដ្រិត អន់ឌ្រែត ប៊ឹង យ៉ាគ់ ពែត្រុះ យ៉ាគ់ យ៉ូហាន អ៊ែ មែ បូវ ម៉ើ ដក់ យ៉ាវ ប្រយ មែ ហឹ រ៉ូង ឆ្រាំង ត្រិះ ទ្រែ សឋិច សាឡូម៉ូន ដើម ម៉ើ គូ ហឡឹង ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","តគ់ យ៉ាគ់ ពែត្រុះ ឡើ តៃ ប៉ាគ់ អ៊ែ ឡើ រៀន៖ «មិះ ដាគ់ យ៉ាគ់ ប៉ អ៊ីស្រាអ៊ែល អើយ! ប៉ិ ឡើ ត្រ វ៉ើ ញ៉ម ដើ កាន នែ វ៉ើ ឝ្លាំង ហឹ ញឺ ហ្រហឹ ប៉ាគ់ នែ? វ៉ើ ឃឹត រៀន ឆង៉ាត់ ញឺ ឡះ ញ៉ើ បើម អន់នៀម បឹ អន់នែ អ៊ែ ឡើ ដូវ ដក់ លឺ ញ៉ន ដើ ញ៉ើ ខំ បើម ត្រួយ ប្រម៉ាង គ្រែដៃ អ៊ែ ឡើ នៀម? ");
INSERT INTO brb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ត្រ អ៊ឺម តើម ប៊ឹង ញឺ! គ្រែដៃ ឡើ កន់ដ្រាគ់ យ៉ាគ់ អាប្រាហាំ យ៉ាគ់ អ៊ីសាគ់ ដើម យ៉ាគ់ យ៉ាកុប ឡើ ត្រ គ្រែដៃ ម៉ិ យ៉ាគ់ ង៉ាយ គ្រែដៃ អ៊ិន ឡើយ ឡើ ពដៃ អាតណាត ឆង៉ាត់ គ្រែដៃ យែស៊ូ ឞយ ណគ។ ណគ់ ដើ វែ អន់ណាវ វ៉ើ រ៉ាប់ ឈូន ណគ ហឹ យ៉ាគ់ ពីឡាត់ អាំ លំប៉្រៃ តហាន ណគ មន់កជែត ដើម វ៉ើ កាះ តាក់ ណគ ប៊ឹង ងឺរ យ៉ាគ់ ពីឡាត់ ទឹង ឡើ ងុញ តោះ ពរ៉ូះ។ ");
INSERT INTO brb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","វែ វ៉ើ កាះ តាក់ ណគ ឡើ គ្រែដៃ ចាគ់ លួង ដើម ឡើ ទឹង ត្រ អ៊ែ វ៉ើ ឡា ហឹ យ៉ាគ់ ពីឡាត់ លំពរ៉ូះ បឹ ឡើ កជែត បនឹះ អាំ ដើ វែ។ ");
INSERT INTO brb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","វែ វ៉ើ កជែត ណគ់ កឡា ឡើ តណើម ឆ្រញិវ ហាក់ គ្រែដៃ ឡើ ពញិវ ឡឹះ អន់ណាវ ណគ តើម ប៊ឹង គែត ញឺ ឡើយ ញ៉ើ កឡា តៃ ហឡាក់ កាន នែ។ ");
INSERT INTO brb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ញ៉ន ញ៉ា ញ៉ើ មឹង គ្រែដៃ យែស៊ូ ប៉ាគ់ ពអ៊ែ អាតណាត ឆង៉ាត់ ម៉ាត់ គ្រែដៃ យែស៊ូ នែ ឡើយ ឡើ អាំ ពន់ដ្រិញ ដើ បឹ ឡើ ញ៉ច ឈឹង ទី នែ ណគ់ វែ វ៉ើ ហឝ៉ាវ ដើម វ៉ើ តៃ ណិះៗ នែ។ ញ៉ន ដើ ញ៉ើ មឹង គ្រែដៃ យែស៊ូ អ៊ែ ឡើ នៀម ឝរ៉ ប្រយ ប៉ាគ់ វែ លែក រ៉ា វ៉ើ តៃ នែ ឡើយ»។ ");
INSERT INTO brb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«មិះ ដាគ់ យ៉ាគ់ ប៉ អើយ! អៃ អណោះ ឡើយ រៀន វែ ដើម មែ ទិះ ក្រាគ់ វែ ម៉ើ កជែត គ្រែដៃ យែស៊ូ យ៉ាក់ តៃ វ៉ើ ណោះ ចាក់ វែ កឡឹ ណោះ វ៉ើ បើម ង៉ាយ។ ");
INSERT INTO brb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ហាក់ ដើ គ្រែដៃ ឡើ បើម អាំ ប៊ិច កាន ណគ់ អន់នែ អាំ ឡើ ដាវ ប៉ាគ់ ប្រម៉ាង គ្រែដៃ ឡើ ហាយ ដើ ង៉ាយ តាម កឡា ឈូន ប្រម៉ាង ណគ ពន់ឋើម ឡើ រៀន គ្រែដៃ គ្រិះ លំត្រ ធុក ញ៉ាក ប៉ាប ពុន ឋា ដើ គែត។ ");
INSERT INTO brb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ប៉ាគ់ ពអ៊ែ វែ វន់ត្រ ពលិះ ចនិះ ជឹ ដាំង គ្រែដៃ ឡឹះ អន់ណាវ បក់ លំជុ យ៉ាវ ឞាប វែ។ ");
INSERT INTO brb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","អ៊ែ គ្រែដៃ កន់ដ្រាគ់ លន់គូ ប៊ឹង វែ លំពញឹម ក្លើម ក្លាក ដើម លំប៉្រៃ គ្រែដៃ គ្រិះ ណគ់ ណគ ឡើ រ៉ើះ អន់នួរ ឡើយ លំទឺះ អន់ណាវ ទិ វែ។ ");
INSERT INTO brb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ណិះៗ នែ គ្រែដៃ យែស៊ូ តង លន់គូ ទឹង ហូង គ្រែ អន់ដៃ ឆា ដើ ប៊ឹះ គ្រែដៃ លំពចាគ់ ហឹ ទឺ អន់ណាវ អង់ង៉ាយៗ ណគ ឡើ ពឝ៉ើត ពន់ឋើម ប៉ាគ់ ឡើ ពហាយ ជុ ប៊ឹង មែ កឡា ឈូន ប្រម៉ាង ណគ ឡៃ មាំង ឡើយ។ ");
INSERT INTO brb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","យ៉ាគ់ ម៉ូស៊ែ ឡើ ហាយ រៀន “គ្រែដៃ ឡើ កន់ដ្រាគ់ វែ លំប៉្រៃ កឡ មូយ រ៉ា លំបើម កឡា ឈូន ប្រម៉ាង ណគ ដើ វែ ប៉ាគ់ ដើ អៃ ទឺ លំរ៉ើះ ណគ តើម ប៊ឹង អំម៉ោះ អោះ វែ តង វន់ចង់ហៀង លែក ដើ ប្រម៉ាង ណគ លំពង់ហៀន ព្រតូវ វែ។ ");
INSERT INTO brb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ណគ់ មែ ង៉ាយ តៃ ម៉ើ ឌី ចង់ហៀង កឡា ឈូន ប្រម៉ាង គ្រែដៃ នែ បូវ មែ អ៊ែ លំត្រ ប៉ាត់ ពណាត់ តើម ប៊ឹង សុនសាត អ៊ីស្រាអ៊ែល”»។ ");
INSERT INTO brb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«លែក ដើ មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ តើម ប៊ឹង យ៉ាគ់ សាមូអ៊ែល ឆា ដើ ប៊ឹះ មែ អន់ទុន ម៉ាត់តូវ ម៉ើ ពហាយ អន់នួរ ឡើយ កាន ឡើ កើត ទឹង ប៉ាង អន់នែ។ ");
INSERT INTO brb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","លែក ដើ កាន មែ កឡា ឈូន ប្រម៉ាង គ្រែដៃ ម៉ើ ខណាត ឡើ ត្រ ហឹ វែ ទឺ ឡើយ។ អ៊ែ ណគ់ ដើ កាន ខណាត ខណាំ ប្លះ គ្រែដៃ ប្លះ ម៉ិ យ៉ាគ់ វែ ណាគ់ ឡើ ត្រ ទឹង វែ ទឺ នែ ឡើយ ប៉ាគ់ ណគ ឡើ ហាយ ដើ យ៉ាគ់ អាប្រាហាំ ពន់ឋើម រៀន “លែក ដើ ក្រាន ឆ្រាំង ទិ ឡាង ប្រិះ នែ មន់ហ្រនុក តាម ប៉ាគ់ ព្រយ៉យ ហៃ”។ ");
INSERT INTO brb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ទឹង គ្រែដៃ ឡើ ប៉្រៃ ឞយ ណគ គ្រែដៃ យែស៊ូ ឡើ ទឺះ ទិ ឡាង ប្រិះ នែ ឡើ ទឺះ ដាំង វែ សុនសាត អ៊ីស្រាអ៊ែល អន់នួរ អន់ដៃ អាំ វែ វន់ហ្រនុក ហ្រវ៉ាក ញ៉ន ដើ គ្រែដៃ លំប៉ូរ អាំ វែ វន់ដូវ ព្រឹង បើម កាន តៃ ចាគ់ វែ ត្រំ រ៉ា»។ ");
INSERT INTO brb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ទឹង យ៉ាគ់ ពែត្រុះ អំប្រា យ៉ាគ់ យ៉ូហាន ប៉ះ អំប្រា ហាយ ហឹ មែ ក្លាង ស៊្រុក ហំប៊្រុះ ដើ អ៊ែ មែ កឡា បប៊ុះ ថួយ យ៉ាគ់ ណាយ កឡា ញ៉ាម រ៉ូង ទិះ កដាប ហំបះ ដើម បូវ មែ សាឌូស៊ី ម៉ើ ប៊ឹះ ប្រយ។ ");
INSERT INTO brb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","លែក ដើ មែ ម៉ើ មាំ ទុត ខាក់ ដើ អំប្រា ពង់ហៀន កាន គ្រែដៃ យែស៊ូ ដើ មែ ប៉ាសាសុន យ៉ាក់ អំប្រា ហាយ រៀន បនឹះ គែត មន់ញិវ ឡឹះ អន់ណាវ ប៉ាគ់ គ្រែដៃ យែស៊ូ ឡើ ញិវ ឡឹះ ទឺ។ ");
INSERT INTO brb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","អ៊ែ ម៉ើ រ៉ាប់ ប្រយ អំប្រា នែ ម៉ើ ដក់ ជុ ហឹ ឃុក ម៉ើ ក្រាន់ ឋា ដើ ប៊ឹះ ប្រណូវ យ៉ាក់ ទឹង ម៉ើ រ៉ាប់ អ៊ែ ឡើ អំប៊ឹ ឡើយ ");
INSERT INTO brb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ហាក់ ទឹង បូវ មែ ម៉ើ ចង់ហៀង ប្រម៉ាង អំប្រា នែ ប៊ិច បូវ មែ ម៉ើ ចាប់ ទុត អើន មែ លែក ដើ អ៊ែ តៃ ម៉ាង មែ ម៉ើ ចាប់ អំប៊ី តៃ ម៉ាង មែ ម៉ើ ចាប់ ហន់ដើម ញឹះ ដូវ សើង ហលិក រ៉ា អ្យាង ម៉ើ កាវ ឌិវ កឡៗ។ ");
INSERT INTO brb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","តគ់ ងឹប ប្រណូវ យ៉ាគ់ ណាយ បប៊ុះ ថួយ ឡើ កឡូវ មែ ទិះ ក្រាគ់ សុនសាត យូដា មែ ណាយឃូ ពង់ហៀន ចឞាប់ ដើម មែ តង់កង់ ម៉ើ ពទុំ ទឹង មួង យែរូសាឡឹម។ ");
INSERT INTO brb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ទឹង អ៊ែ ឡើ ប៊ិច យ៉ាគ់ ហាណះ ឡើ ណាយ បប៊ុះ ថួយ យ៉ាគ់ កៃផាះ យ៉ាគ់ យ៉ូហាន យ៉ាគ់ អាលែសានដ្រុះ ដើម មែ កឡ អន់នឺ ដិ តើម ប៊ឹង ក្រាន យ៉ាគ់ ណាយ កឡា បប៊ុះ ថួយ។ ");
INSERT INTO brb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ម៉ើ ប៉្រៃ បូវ មែ ម៉ើ ញ៉ាម ដក់ ចក់ យ៉ាគ់ ពែត្រុះ អំប្រា យ៉ាគ់ យ៉ូហាន តៀត ជុ ប្លះ កឌី មែ ម៉ើ ពស៊ុំ។ ប៊្លី អ៊ែ ម៉ើ តង៉ា អំប្រា រៀន៖ «សប្រា បើម កាន អន់នែ សប្រា មឹង ដើ អាតណាត មែ ង៉ាយ? ដើ ម៉ាត់ មែ ង៉ាយ?»។ ");
INSERT INTO brb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ទឹង អ៊ែ យ៉ាគ់ ពែត្រុះ ឡើ ប៊ិង ដើ ផវ