﻿USE sofia;
DROP TABLE IF EXISTS sofia.bqp_vpl;
CREATE TABLE bqp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bqp_vpl WRITE;
INSERT INTO bqp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Zaa káaku Luda musu kũ zĩtɛoo kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Gu da pãmɛ à kɛkɛnaro, gusira mɛ́ à da ísirala, akũ Luda Nini tɛn yàa kɛ í pìla. ");
INSERT INTO bqp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Akũ Luda pì: Gupura kũ! Akũ gupura kũ̀. ");
INSERT INTO bqp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","À è gupura pìi kɛ̀ mana, akũ à gupura kɛ̃̀kↄ̃a kũ gusirao. ");
INSERT INTO bqp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","À tↄ́ kpà gupuranɛ fãnantɛ̃, gusira sↄ̃ gwãani. Gu sì gu dↄ̀, a gↄrↄ káakun gwe. ");
INSERT INTO bqp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Akũ Luda pì: Sarapura gↄ̃ kú ínↄ dagura de à í pìnↄ kɛ̃kↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Akũ à sarapura kɛ̀ lɛ, à í kũ à kú sarapura gbáru kɛ̃̀kↄ̃a kũ í kũ à kú a musuo. ");
INSERT INTO bqp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Akũ à tↄ́ kpà sarapura pìinɛ ludambɛ. Gu sì gu dↄ̀, a gↄrↄ pladen gwe. ");
INSERT INTO bqp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Akũ Luda pì: Í kũ à kú zĩtɛ kakara gu dokↄ̃nↄ, gukori bo. Akũ à kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","À tↄ́ kpà gukori pìinɛ zĩtɛ, akũ a tↄ́ kpà í kũ à kàkaranɛ ísira. Akũ à è à kɛ̀ mana. ");
INSERT INTO bqp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Akũ Luda pì: Lánↄ bↄtɛ zĩtɛ kũ sɛ̃̀ wɛ́denↄ kũ lí nɛ́denↄ, baadi kũ a burio. Akũ à kɛ̀ lɛ, ");
INSERT INTO bqp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","lánↄ bↄ̀tɛ zĩtɛ kũ sɛ̃̀ wɛ́denↄ kũ lí nɛ́denↄ, baadi kũ a burio. Akũ Luda è à kɛ̀ mana. ");
INSERT INTO bqp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Gu sì gu dↄ̀, a gↄrↄ aakↄ̃den gwe. ");
INSERT INTO bqp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Akũ Luda pì: Pↄ́ gupurakũrinↄ gↄ̃ kú musu ògↄ̃ fãnantɛ̃ kɛ̃kↄ̃a kũ gwãanio, ògↄ̃ wɛ̃̀ sèedanↄ kũ gↄrↄnↄ kũ wɛ̃̀nↄ mↄńnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ògↄ̃ kú pↄ́ gupurakũrinↄ ũ musu de ògↄ̃ andunia pura kũ. Akũ à kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","À pↄ́ gupurakũri zↄ̃kↄ̃nↄ kɛ̀ mɛ̀n pla, a kũ à gbãna dìgↄ̃ kí ble fãnantɛ̃, a kũ à busɛ dìgↄ̃ kí ble gwãani. À susunɛnↄ kɛ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","À ń pɛ́pɛ musu de ògↄ̃ andunia pura kũ ");
INSERT INTO bqp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ògↄ̃ kí ble fãnantɛ̃ kũ gwãanio, ògↄ̃ gupura kɛ̃kↄ̃a kũ gusirao. Akũ à è à kɛ̀ mana. ");
INSERT INTO bqp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Gu sì gu dↄ̀, a gↄrↄ siikↄ̃den gwe. ");
INSERT INTO bqp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Akũ Luda pì: Pↄ wɛ̃̀ndidenↄ í pa yɛ́rɛrɛ, bãnↄ dagula musu ògↄ̃ vura sarapuran. ");
INSERT INTO bqp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Akũ à pↄ́ wɛ̃̀ndide kũ òdi í panↄ kɛ̀ kũ kpↄ̀ gbɛ̃̀ntɛ̃nↄ pínki, baadi kũ a burio. À bãnↄ kɛ̀ pínki dↄ, baadi kũ a burio. Akũ à è à kɛ̀ mana. ");
INSERT INTO bqp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","À arubarikaa dàńgu à pì, ògↄ̃ nɛ́ i ògↄ̃ kɛ dasi, kpↄ̀nↄ ísira pa, bãnↄ kɛ dasi zĩtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Gu sì gu dↄ̀, a gↄrↄ sↄↄroden gwe. ");
INSERT INTO bqp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Akũ Luda pì: Pↄ́ wɛ̃̀ndidenↄ bↄtɛ zĩtɛ, bɛ pↄ́kãdenↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ kũ nↄ̀bↄsɛ̃ntɛnↄ, baadi kũ a burio. Akũ à kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Luda nↄ̀bↄsɛ̃ntɛnↄ kɛ̀ baadi kũ a burio. À bɛ pↄ́kãdenↄ kɛ̀ baadi kũ a burio. À pↄ́ kũ òdi táa o kũ kùaonↄ kɛ̀ baadi kũ a burio. Akũ à è à kɛ̀ mana. ");
INSERT INTO bqp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Akũ Luda pì: Ò bisãsiri kɛ ó taka ũ, ògↄ̃ de lán ó bà, ògↄ̃ kí ble kpↄ̀nↄa kũ bãnↄ kũ bɛ pↄ́kãdenↄ kũ nↄ̀bↄsɛ̃ntɛnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Akũ Luda bisãsiri kɛ̀ a zĩda taka ũ. A zĩda takan à ń kɛ́ a ũ. À ń kɛ́ gↄ̃gbɛ̃ kũ nↄgbɛ̃o. ");
INSERT INTO bqp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","À arubarikaa dàńgu à pìńnɛ: Àgↄ̃ nɛ́ i àgↄ̃ kɛ dasi àgↄ̃ andunia pa àgↄ̃ gbãna blea. Àgↄ̃ kí ble kpↄ̀nↄa kũ bãnↄ kũ pↄ́ wɛ̃̀ndide kũ òdi táa o zĩtɛnↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Akũ Luda pì: Pↄ́ wɛ́de kũ ò kú zĩtɛnↄn ma kpàáwa á pↄ́ble ũ pínki kũ lí nɛ́denↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma sɛ̃̀nↄ kũ lánↄ kpà pↄ́ wɛ̃̀ndidenↄa pínki ń pↄ́ble ũ, nↄ̀bↄnↄ kũ bãnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ pínki. Akũ à kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Luda pↄ́ kũ à kɛ̀nↄ è pínki, à kɛ̀ mana swáswa. Gu sì gu dↄ̀, a gↄrↄ suddoden gwe. ");
INSERT INTO bqp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Lɛn Luda musu kũ zĩtɛo kɛ̀ lɛ kũ a pↄ́nↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ari a gↄrↄ supplade zĩ gↄ̃ ká, à zĩ kũ àtɛn kɛ pìi làka. A gↄrↄ supplade pì zĩ à kámma bò kũ zĩ kũ a kɛ̀nↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Akũ à arubarikaa dà gↄrↄ supplade pìn à dìtɛ a pↄ́ ũ, kũ gↄrↄ bire à kámma bò kũ zĩ kũ a kɛ̀nↄ pínki yãi. ");
INSERT INTO bqp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Musu kũ zĩtɛo naana yãn dí. Gↄrↄ kũ Dikiri Luda zĩtɛ kũ musuoo kɛ̀, ");
INSERT INTO bqp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","pↄ́wɛ ke dí butɛ zĩtɛ kↄ̀ro, bee sɛ̃̀ɛ, zaakũ Dikiri Luda dí tó legũ màro, akũsↄ̃ gbɛ̃ke kun à bura zĩ kɛro. ");
INSERT INTO bqp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Suka mɛ́ àdi kpá andunia gũn, akũ àdi mↄtↄ pisi zĩtɛa pínki. ");
INSERT INTO bqp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Dikiri Luda gↄ̃gbɛ̃ í kàsa kũ bùsutitio, akũ à ĩa wɛ̃̀ndide vù a yĩn, akũ gↄ̃gbɛ̃ pìi gↄ̃̀ gbɛ̃ bɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Dikiri Luda swadakoo kɛ̀kɛ ifãboki kpa gu kũ òdi pi Ɛdɛni, akũ à gↄ̃gbɛ̃ kũ à kɛ̀ɛ pìi dà gwe. ");
INSERT INTO bqp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dikiri Luda tò lí buri sĩnda pínki bùtɛ zĩtɛ. Lí pìnↄ kɛ̀ mana, akũsↄ̃ ń nɛ́ blena nna. Lí wɛ̃̀ndide kú dàkoo pìi dagura. Lí kũ àdi dↄ̃na mana kũ a vãnio ińnɛ kú gwe dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Swa kú Ɛdɛni àdigↄ̃ mↄtↄ pisi dàkoo pìia. Bona gwe à ↄnɛ kɛ̀ siikↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","A káaku tↄ́n Pisↄ̃, àkũ mɛ́ à lika Avila bùsuui pínki. Wura kú bùsuu pìi gũn, ");
INSERT INTO bqp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","wuraa pì mana. Gbɛ̀ bɛ̀ɛrɛdenↄn kú gwe dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Swa pì ↄnɛ plade tↄ́n Giↄ̃, à lika Kusu bùsuui pínki. ");
INSERT INTO bqp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","A ↄnɛ aakↄ̃de tↄ́n Tigiri, a dↄ̀rↄↄ tà Asiria bùsu ifãboki kpa. Swa pì ↄnɛ siikↄ̃de tↄ́n Yuflati. ");
INSERT INTO bqp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Dikiri Luda gↄ̃gbɛ̃ pìi dìtɛ Ɛdɛni dàkoo pìi gũn de àgↄ̃ a zĩ kɛ àgↄ̃ gwa. ");
INSERT INTO bqp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Akũ à yã dìtɛnɛ à pì: Ĩni fↄ̃ ǹ dàkoo pì lí nɛ́nↄ ble pínki, ");
INSERT INTO bqp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ama ǹsun lí kũ àdi dↄ̃na mana kũ a vãnio ińnɛ nɛ́ blero. Tó n blè, ĩni gamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dikiri Luda pì: Gↄ̃gbɛ̃ kunna ado manaro. Mani kpanyĩri kɛnɛ a gbɛ̃ndo ũ. ");
INSERT INTO bqp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Akũ Dikiri Luda bùsuu sɛ̀ à nↄ̀bↄnↄ kɛ̀o pínki kũ bãnↄ pínki, akũ à sù kũńwo gↄ̃gbɛ̃ pì kĩnaa de à e deran ani tↄ́ kpáńnɛ nà. Tↄ́ kũ gↄ̃gbɛ̃ pìi kpà pↄ́ wɛ̃̀ndide pìnↄnɛ pínki gↄ̃̀ ń tↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Gↄ̃gbɛ̃ pì tↄ́ kpà bɛ pↄ́kãdenↄnɛ pínki kũ bãnↄ kũ nↄ̀bↄsɛ̃ntɛnↄ pínki, ama adi kpanyĩri e ń tɛ́ a gbɛ̃ndo ũro. ");
INSERT INTO bqp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Akũ Dikiri Luda i zↄ̃kↄ̃ↄ dà gↄ̃gbɛ̃ pìla. Kũ àtɛn i o, akũ à a gbã̀ntɛrɛwa mɛ̀n do bò, akũ à a mɛ̀baasi tàta a gbɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Akũ à gↄ̃gbɛ̃ gbã̀ntɛrɛwa kũ à bòo pìi lìtɛ nↄgbɛ̃ ũ, akũ à gɛ̀ɛ kãao a kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Akũ gↄ̃gbɛ̃ pìi pì: Adikĩna wá bò ma wá gũmmɛ, a mɛ̀ sↄ̃ à bò ma mɛ̀ɛ gũmmɛ. Oni a sísi nↄgbɛ̃, kũ Luda a bò gↄ̃gbɛ̃ gũn yãi. ");
INSERT INTO bqp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","A yã mɛ́ à tò gↄ̃gbɛ̃ dì bo a de kũ a dao bɛa, àdi nakↄ̃a kũ a nanↄo ò gↄ̃ mɛ̀ do ũ. ");
INSERT INTO bqp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Gↄ̃gbɛ̃ kũ a nanↄo kú pótompo ń pla ń pínki, wé'i sↄ̃ àdi ń kũro. ");
INSERT INTO bqp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mlɛ̃̀ mɛ́ à manafiki vĩ de pↄ́ kũ Dikiri Luda kɛ̀nↄla pínki, akũ à nↄgbɛ̃ là à pì: Luda pì àsun dàkoo pì lí ke nɛ́ blenloo? ");
INSERT INTO bqp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Akũ nↄgbɛ̃ wè mlɛ̃̀ɛ pìia à pì: Óni fↄ̃ ò dàkoo pì línɛ ble, ");
INSERT INTO bqp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ama lí kũ à kú dàkoo pìi guragura, Luda pì òsun a nɛ́ blero òsun ↄ naa sero, de òsun garo yãi. ");
INSERT INTO bqp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Akũ mlɛ̃̀ɛ pìnɛ: Áni garo fá! ");
INSERT INTO bqp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Zaakũ Luda dↄ̃ tó a blè, á wɛ́ ni kɛ̃ áni gↄ̃ lán a bà, ánigↄ̃ a mana dↄ̃ kũ a vãnio. ");
INSERT INTO bqp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kũ nↄgbɛ̃ è lí pì nɛ́ mana, akũsↄ̃ a blena nigↄ̃ nna ani tó gbɛ̃ wɛ́ kɛ̃, akũ à a nɛ́ kɛ̃̀ à blè. À kpà a zãa dↄ, akũ à blè se. ");
INSERT INTO bqp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ń pla ń pínki ń wɛ́ kɛ̃̀, akũ ò dↄ̃̀ sà kũ ò kun pótompo. Akũ ò gboroda lá nàbi ò yĩ̀ḿma. ");
INSERT INTO bqp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kũ gↄ̃gbɛ̃ kũ a nanↄo Dikiri Luda kĩni mà àtɛn kure dàkoo pìi gũn ↄkↄsi, akũ ò ùtɛnɛ dàkoo pì lán. ");
INSERT INTO bqp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Akũ Dikiri Luda lɛ́ zù gↄ̃gbɛ̃i à pì: Ń kú mámɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","À wèa à pì: Kũ ma n kĩni mà, akũ vĩna ma kũ kũ má kun pótompo yãi, akũ ma utɛ. ");
INSERT INTO bqp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Akũ Dikiri Luda a là à pì: Dí mɛ́ à ònnɛ ń kun pótompoo? Lí kũ ma ginnɛ ǹ a nɛ́ ble, n blèn yá? ");
INSERT INTO bqp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","À wèa à pì: Nↄgbɛ̃ kũ n kpàma àgↄ̃ kú kũmao mɛ́ à lí pì nɛ́ kpàma ma blè. ");
INSERT INTO bqp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Akũ Dikiri Luda nↄgbɛ̃ là à pì: Bↄ́yãi n kɛ̀ lɛɛ? À wèa à pì: Mlɛ̃̀ mɛ́ à ma kɛkɛ, akũ ma blè. ");
INSERT INTO bqp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Akũ Dikiri Luda pì mlɛ̃̀ɛnɛ: Kũ n kɛ̀ lɛ, ĩnigↄ̃ láaribona pↄ́ ũ de bɛ pↄ́kãdenↄ kũ nↄ̀bↄsɛ̃ntɛnↄla pínki, ĩnigↄ̃ táa o n kùua, bùsutitin ĩnigↄ̃ ble ari n wɛ̃̀ndi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mani ibɛrɛ da mↄkↄ̃n kũ nↄgbɛ̃o dagura, n buri kũ a burio dagura. A buri ni n mì wí, ĩni a gbátoki kĩnna. ");
INSERT INTO bqp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Akũ à pì nↄgbɛ̃nɛ: Mani n nↄ̀sinaa wari karannɛ, ĩnigↄ̃ nɛ́ i kũ wãwão. N zã ni nigↄ̃ kúmmamɛ, anigↄ̃ kí ble n musu. ");
INSERT INTO bqp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Akũ à pì gↄ̃gbɛ̃nɛ: Lákũ n n nanↄ yã mà nà, lí kũ ma ginnɛ ǹ a nɛ́ ble n blè, ma láari bò zĩtɛa n yãi, ↄsi kũ ↄsioon ĩnigↄ̃ pↄ́ble en ari n wɛ̃̀ndi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ani lɛ̀nↄ kũ lá ũkãdenↄ butɛnnɛ, gbasa ǹ burapↄnↄ ble. ");
INSERT INTO bqp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ísimmawaranaa gũnn ĩni pↄ́ble en ari ǹ ɛra ǹ gɛ̃o bùsun, zaakũ gwen ma n bon. Bùsutitimɛ n ũ, ĩni ɛra ǹ gↄ̃ bùsutiti pìi ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu tↄ́ kpà a nanↄnɛ Awau, zaakũ gbɛ̃ pínki daimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dikiri Luda bára uta kɛ̀ Adamunɛ kũ a nanↄo, akũ à dàńnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Akũ à pì: Bisãsiri a mana kũ a vãnio dↄ̃̀ sà, à gↄ̃̀ lán ó bà. Óni gínɛ à lí wɛ̃̀ndide nɛ́ kɛ̃ à ble de àsungↄ̃ kun gↄrↄ sĩnda pínkiro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Akũ Dikiri Luda pɛ̀a à a bò Ɛdɛni dàkoo pìi gũn. Akũ Adamu gɛ̀ɛ à zĩtɛ kũ Luda a bòn zĩ kɛ. ");
INSERT INTO bqp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kũ Dikiri Luda pɛ̀a, akũ à kɛrubunↄ kàtɛ Ɛdɛni dàko ifãboki kpa, de ògↄ̃ lí wɛ̃̀ndide zɛ́ dãkpã kũ fɛ̃nɛda kũ àtɛn tɛ́ kɛ àtɛn litɛlitɛo. ");
INSERT INTO bqp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu a nanↄ Awau dↄ̃̀ nↄgbɛ̃ ũ, akũ à nↄ̀ↄ sì à Kainu ì. Akũ à pì: Ma gↄ̃gbɛ̃ ì kũ Dikiri gbãnao. ");
INSERT INTO bqp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Akũ à a dakũna Habila ì dↄ. Habila kɛ̀ sãdãri ũ, Kainu sↄ̃ à kɛ̀ búbari ũ. ");
INSERT INTO bqp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Zĩkea Kainu sù kũ a burapↄnↄo gba ũ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habila sↄ̃ à sù kũ a sãnɛ káaku mɛ̀kpanaao. Habila yã kà Dikirigu, akũ à a gba sì. ");
INSERT INTO bqp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kainu sↄ̃ a yã dí kɛ Dikirinɛro, akũ adi a gba síro. Akũ Kainu pↄ fɛ̃̀ manamana a ãnn sìsi. ");
INSERT INTO bqp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Akũ Dikiri pì Kainunɛ: Bↄ́yãi n pↄ fɛ̃̀ɛ? À kɛ̀ dera n ãnn yàkaa? ");
INSERT INTO bqp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tó n yã mana kɛ̀, mani n síroo? Tó ńdi yã mana kɛ sↄ̃ro, durunna natɛnnɛ n kpɛ́lɛlɛa. N ni tɛni a dɛ, séde ǹ zĩ̀ blea. ");
INSERT INTO bqp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Akũ Kainu pì a dakũna Habilanɛ: Ò gɛ́ sɛ̃̀n. Kũ ò kà gwe, akũ à fùtɛ a dakũnai à a dɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Dikiri Kainu là à pì: Mán n dakũna Habila kunn? À wèa à pì: Má dↄ̃ro. Ma dakũna dãkpãriin ma ũ yá? ");
INSERT INTO bqp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Akũ Dikiri pì: Bↄ́n n kɛ̀ɛ? N dakũna aru tɛn lɛ́ zumai zaa zĩtɛ gũn mà zɛ kãao. ");
INSERT INTO bqp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tera sà ĩnigↄ̃ láari pↄ́ ũmɛ, ĩnigↄ̃ zã̀ kũ zĩtɛ kũ à n dakũna aru mì n ↄĩo. ");
INSERT INTO bqp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tó n bú bà, zĩtɛ ni kararo. Ĩnigↄ̃ sↄ̃sↄ̃ gu kũ guo ǹgↄ̃ likara andunia gũn. ");
INSERT INTO bqp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Akũ Kainu pì Dikirinɛ: Wari bire gbãna demala, mani fↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ntɛn pɛ́ma zĩtɛ la gbãramɛ sà. Mani kɛ̃kↄ̃a kũnwo sà. Manigↄ̃ sↄ̃sↄ̃ gu kũ guo màgↄ̃ likara andunia gũn, gbɛ̃ kũ à kpàkũn kũmao ni ma dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Akũ Dikiri pìnɛ: Lɛnlo! Tó gbɛ̃ n dɛ, oni mↄra káa gɛ̃̀n supplamɛ. Akũ Dikiri wãnzãn ke kɛ̃̀ Kainua, de gbɛ̃ kũ à kpàkũn kãao sún a dɛro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Akũ Kainu dà zɛ́n à kɛ̃̀ Dikiria. À gɛ̀ɛ à vùtɛ Nↄdu bùsun Ɛdɛni ifãboki kpa. ");
INSERT INTO bqp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kainu wùtɛ kũ a nanↄo, akũ à nↄ̀ↄ sì à Ɛnↄku ì. A gbɛra Kainu wɛ̃tɛ kàtɛ, akũ à a nɛ́ pì tↄ́ kpà wɛ̃tɛ pìinɛ. ");
INSERT INTO bqp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ɛnↄku Irada ì, Irada Mɛuyaɛli ì, Mɛuyaɛli Mɛtusaɛli ì, Mɛtusaɛli Lamɛki ì. ");
INSERT INTO bqp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamɛki nↄ sɛ̀ mɛ̀n pla, a do tↄ́n Ada, a do Zila. ");
INSERT INTO bqp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Yabala ì. Àkũmɛ pↄ́dãri kũ òdigↄ̃ kú bizakuta gũnnↄ dizi káaku ũ. ");
INSERT INTO bqp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A dakũna tↄ́n Yubala. Àkũmɛ mↄrↄlɛrinↄ kũ úrapɛrinↄ dizi káaku ũ. ");
INSERT INTO bqp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila sↄ̃, akũ mɛ́ à Tubala Kainu ì. Siaamɛ a ũ. Àdi pↄ pínki pi kũ mↄ̀sio kũ mↄ̀gotɛ̃o. A dãre tↄ́n Naama. ");
INSERT INTO bqp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Akũ Lamɛki pì a nↄnↄnɛ: Ada kũ Zilao, à ma yã ma, ma nↄnↄ, à sã kpá ma yãi. Gbɛ̃ke ma kĩnna, akũ ma a dɛ̀, kɛfɛnna pì ma lɛmɛ, akũ ma a wɛ̃̀ndii bò. ");
INSERT INTO bqp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tó oni Kainu fĩna bonɛ gɛ̃̀n suppla, makũ Lamɛki ma pↄ́ sↄ̃, gɛ̃̀n baaakↄ̃ akuri awɛɛsupplamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu wùtɛ kũ a nanↄo dↄ, akũ à nɛ́gↄ̃gbɛ̃ ì. À tↄ́ kpànɛ Sɛti à pì, Luda a gba nɛ́ pãnde Habila kũ Kainu a dɛ̀ gɛ̃nɛ ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sɛti sↄ̃ à nɛ́gↄ̃gbɛ̃ ì, akũ à tↄ́ kpànɛ Ɛnↄsu. Zaa zĩ birean ò nà Dikiri sísinaaa. ");
INSERT INTO bqp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamu burinↄ yãn dí. Gↄrↄ kũ Luda bisãsirinↄ kɛ̀, à ń kɛ́ lán a bàmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","À ń kɛ́ gↄ̃gbɛ̃ kũ nↄgbɛ̃o, akũ à arubarikaa dàńnɛ. À tↄ́ kpàńnɛ bisãsiri. ");
INSERT INTO bqp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu wɛ̃̀ basuddo akuride gũn à nɛ́ ì a taka ũ à bòkↄ̃a kãao, akũ à tↄ́ kpànɛ Sɛti. ");
INSERT INTO bqp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛti inaa gbɛra à kɛ̀ wɛ̃̀ wàa siikↄ̃ à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basuddo akuri, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛti wɛ̃̀ basↄↄro awɛɛsↄↄrode gũn à Ɛnↄsu ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","A gbɛra à kɛ̀ wɛ̃̀ wàa siikↄ̃ awɛɛsuppla à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basↄↄro akuri awɛɛpla, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ɛnↄsu wɛ̃̀ basiikↄ̃ akuride gũn à Kenana ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","A gbɛra à kɛ̀ wɛ̃̀ wàa siikↄ̃ kũ gɛ̃roo à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basↄↄro awɛɛsↄↄro, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenana wɛ̃̀ baaakↄ̃ akuride gũn à Malalɛli ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","A gbɛra à kɛ̀ wɛ̃̀ wàa siikↄ̃ kpɛ́ bupla à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basↄↄro akuri, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malalɛli wɛ̃̀ baaakↄ̃ awɛɛsↄↄrode gũn à Yarɛdi ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","A gbɛra à kɛ̀ wɛ̃̀ wàa siikↄ̃ kũ mɛ̀n baraakuri à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basↄↄro sↄↄrosari, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarɛdi wɛ̃̀ basↄraakↄ̃ awɛɛplade gũn à Ɛnↄku ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","A gbɛra à kɛ̀ wɛ̃̀ wàa siikↄ̃ à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basↄraakↄ̃ awɛɛpla, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ɛnↄku wɛ̃̀ baaakↄ̃ awɛɛsↄↄrode gũn à Mɛtusela ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","A gbɛra à táa ò kũ Ludao ari wɛ̃̀ wàa do kpɛ́ basↄↄro à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","À kà wɛ̃̀ wàa do kpɛ́ basↄraakↄ̃ awɛɛsↄↄro. ");
INSERT INTO bqp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","À táa ò kũ Ludao, akũ ò kùrai, kũ Luda a sɛ̀ à bò kãao andunia gũn yãi. ");
INSERT INTO bqp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mɛtusela wɛ̃̀ bakɛ̃ndo awɛɛsupplade gũn à Lamɛki ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","A gbɛra à kɛ̀ wɛ̃̀ wàa aakↄ̃ kpɛ́ bakɛ̃ndo awɛɛpla à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kũ à kà wɛ̃̀ wàa siikↄ̃ kpɛ́ basↄraakↄ̃ akuri donsari, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamɛki kɛ̀ wɛ̃̀ bakɛ̃ndo awɛɛpla, akũ à nɛ́gↄ̃gbɛ̃ ì. ");
INSERT INTO bqp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","À tↄ́ kpànɛ Nuhu à pì: Gbɛ̃ bire mɛ́ ani ó laakari kpátɛwɛrɛ zĩ gbãna kũ ótɛn kɛ yãi. Odì zĩ gbãna pì kɛ Dikiri láaribona zĩtɛa yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhu inaa gbɛra Lamɛki kɛ̀ wɛ̃̀ wàa aakↄ̃ sↄↄrosari à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kũ à kà wɛ̃̀ wàa aakↄ̃ kpɛ́ basↄraakↄ̃ akuri awɛɛsuppla, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kũ Nuhu kà wɛ̃̀ wàa pla kpɛ́ basↄↄro, à Sɛmu kũ Hamuo kũ Yafɛtio ì. ");
INSERT INTO bqp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kũ bisãsirinↄ nà kɛna nà òtɛn dagula òtɛn nɛ́nↄgbɛ̃nↄ i, ");
INSERT INTO bqp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","akũ Luda nɛ́nↄ è bisãsiri nɛ́nↄgbɛ̃ pìnↄ mana, akũ òtɛni ń sɛ́ ń pↄyeinaaa. ");
INSERT INTO bqp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Akũ Dikiri pì: Ma Nini nigↄ̃ kú bisãsirinↄ gũn gↄrↄ sĩnda pínkiro, zaakũ mɛ̀barademɛ. Ń gↄrↄnↄ nigↄ̃ wɛ̃̀ basuddomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Gbɛ̃ gbã̀nanↄn kú andunia gũn gↄrↄ birea kũ gↄrↄ bire gbɛrao dↄ, gↄrↄ kũ Luda nɛ́ pìnↄ bisãsiri nɛ́nↄgbɛ̃nↄ dↄ̃̀ nↄgbɛ̃nↄ ũ ò nɛ́nↄ ì kũńwo. Ń nɛ́ pìnↄmɛ gↄ̃sa gbãna kũ ń tↄ́ bò zaa káakunↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Dikiri è kũ bisãsirinↄ yã vãni kɛna dasi andunia gũn. Gↄrↄ sĩnda pínki yã bɛ̃̀nɛ laasunn òdigↄ̃ lɛ́ ado, ");
INSERT INTO bqp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","akũ a pↄ yàka bisãsiri kũ à kɛ̀ zĩtɛ yã musu. À laasun pãnde lɛ̀, ");
INSERT INTO bqp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","akũ à pì: Mani bisãsiri kũ ma kɛ̀ zĩtɛ wara, bisãsirinↄ kũ nↄ̀bↄnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ kũ bãnↄo, zaakũ ma pↄ yàka ń kɛna yã musu. ");
INSERT INTO bqp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ama Nuhu Dikiri pↄnna lè. ");
INSERT INTO bqp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuhu burinↄ yãn dí. Nuhu bi gbɛ̃ manamɛ. Kũ à kun, a mɛ̀n do mɛ́ à taari vĩro à táa ò kũ Ludao. ");
INSERT INTO bqp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu nɛ́gↄ̃gbɛ̃nↄ ì gbɛ̃nↄn aakↄ̃, Sɛmu kũ Hamuo kũ Yafɛtio. ");
INSERT INTO bqp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Luda è andunia gbɛ̃nↄ yàka ń pínki, taarikɛna andunia pà. ");
INSERT INTO bqp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kũ Luda andunia gwà, à è à yàka, zaakũ gbɛ̃ sĩnda pínki zã̀ zɛ́a. ");
INSERT INTO bqp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Akũ Luda pì Nuhunɛ: Mani gbɛ̃ sĩnda pínki kakatɛ, kũ ń yãin taarikɛna dà anduniala. Mani ń kakatɛ lɛɛlɛ kũ anduniaomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ǹ gó'itɛ kɛkɛ kũ lí lɛ̀kɛtɛɛo ǹ kpɛ́nɛnↄ kɛ a gũn ǹ ↄ̀da maa a gũn kũ a kpɛo. ");
INSERT INTO bqp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ĩni gó pì kɛ lán dí bà. A gbã̀na gã̀sãkuru wàa do kpɛ́ basↄↄro, a yàasa gã̀sãkuru bupla akuri, a lei sↄ̃ gã̀sãkuru baraakuri. ");
INSERT INTO bqp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ǹ gó pìi musu pápa, gbasa ǹ guforo tó a dagura gwe gã̀sãkuru do zaa a musu kpa. Ǹ gbà da gó pì kpado ǹ gó pì kɛ didikↄ̃ana lɛu aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Makũ sↄ̃ mani tó í da anduniala, de mà pↄ́ wɛ̃̀ndide kũ òdi wesa bonↄ kakatɛ ń pínki. Pↄ́ kũ ò kú andunia gũnnↄ ni gaga pínki. ");
INSERT INTO bqp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ama ma bàka nigↄ̃ kú kũnwo. Ĩni gɛ̃ gó pìi gũn kũ n nɛ́gↄ̃gbɛ̃nↄ kũ n nanↄo kũ n nɛ́nↄ nↄnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ĩni pↄ́ wɛ̃̀ndide pínki sɛ́ ǹ gɛ̃ kũńwo mɛ̀n plapla de onigↄ̃ kun kũ wɛ̃̀ndiio. ");
INSERT INTO bqp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bã burinↄ kũ nↄ̀bↄ burinↄ kũ pↄ́ kũ òdi táa o kũ kùao burinↄ pínki oni su n kĩnaa mɛ̀n plapla de ògↄ̃ kun. ");
INSERT INTO bqp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ǹ pↄ́ble kũ òdi ble sĩnda pínki sɛ́tɛ ǹ kakara á zàna ũ, ákↄ̃nↄ kũ pↄ́ pìnↄ. ");
INSERT INTO bqp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Akũ Nuhu kɛ̀ lɛ à yã kũ Luda ònɛɛ kɛ̀ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Akũ Dikiri pì Nuhunɛ: Ǹ gɛ̃ gó gũn kũ n bedenↄ, zaakũ mↄkↄ̃mmɛ ma n e yãnnade ũ gbãragbɛ̃nↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ǹ nↄ̀bↄ kũ à de sa'opↄ ũnↄ sɛ́ ǹ gɛ̃ kũńwo da kũ a sàao mɛ̀n supplapla, ǹ nↄ̀bↄ kũ òdi sa ooronↄ sɛ́ mɛ̀n plapla da kũ a sàao. ");
INSERT INTO bqp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ǹ bãnↄ sɛ́ ǹ gɛ̃ kũńwo dↄ da kũ a sàao mɛ̀n supplapla de ń burinↄ gↄ̃ kú andunia gu sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Zaakũ gↄrↄ suppla gbɛra mani tó legũ ma zĩtɛ ari gↄrↄ bupla fãnantɛ̃ kũ gwãanio, de mà pↄ́ wɛ̃̀ndide kũ ma kɛ̀nↄ wara zĩtɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu yã kũ Dikiri ònɛɛ kɛ̀ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Gↄrↄ kũ í dà anduniala, Nuhu kun wɛ̃̀ wàa aakↄ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","À gɛ̃̀ gó'itɛ gũn kũ a nɛ́nↄ kũ a nanↄo kũ a nɛ́nↄ nↄnↄo de ò bo í pì yãn. ");
INSERT INTO bqp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Akũ nↄ̀bↄ kũ ò de sa'opↄ ũnↄ kũ nↄ̀bↄ kũ òdi sa ooronↄ kũ bãnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ ");
INSERT INTO bqp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sù Nuhu kĩnaa gó gũn mɛ̀n plapla da kũ a sàao lákũ Luda ònɛɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Gↄrↄ suppla gbɛra í da pìi dà anduniala. ");
INSERT INTO bqp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu wɛ̃̀ wàa aakↄ̃de gũn a mↄ plade gↄrↄ gɛ̃ro awɛɛplade zĩ, akũ í kũ à kú zĩtɛ gbárunↄ pũ̀tã pínki, akũ ludambɛ guforonↄ fↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Legũ mà ari gↄrↄ bupla fãnantɛ̃ kũ gwãanio. ");
INSERT INTO bqp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Gↄrↄ birea Nuhu gɛ̃̀ gó gũn kũ a nɛ́nↄ Sɛmu kũ Hamuo kũ Yafɛtio kũ api nanↄo kũ a nɛ́nↄ nↄnↄ gbɛ̃nↄn aakↄ̃, ");
INSERT INTO bqp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","kũ nↄ̀bↄsɛ̃ntɛnↄ pínki ń buria kũ bɛ pↄ́kãdenↄ pínki ń buria kũ pↄ́ kũ òdi táa o kũ kùaonↄ pínki ń buria kũ pↄ́ vurananↄ pínki ń buria, bãnↄ kũ pↄ́ dɛ̀mbɛrɛdenↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pↄ́ kũ òdi wesa bonↄ sù Nuhu kĩnaa gó gũn buri kũ burio mɛ̀n plapla. ");
INSERT INTO bqp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Pↄ wɛ̃̀ndidenↄ buri pínki gɛ̃̀ da kũ a sàao lákũ Luda dìtɛnɛ nà. Akũ Dikiri gbà tàtańlɛ. ");
INSERT INTO bqp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Legũ mà ari gↄrↄ bupla. Kũ í tɛn kara, akũ à gó pìi sɛ̀ zĩtɛla. ");
INSERT INTO bqp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Í fùtɛ à kàra manamana à dà zĩtɛla, akũ gó pì fù íla. ");
INSERT INTO bqp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Í kàra à dà zĩtɛla lái, à dà kpi lei kũ ò kú andunia gũnnↄla míↄmiↄ. ");
INSERT INTO bqp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Í fùtɛ à dà kpi pìnↄla ari gã̀sãkuru gɛ̃ro. ");
INSERT INTO bqp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Pↄ́ wɛ̃̀ndide kũ òdi táa o zĩtɛnↄ gàga pínki, bãnↄ kũ bɛ pↄ́kãdenↄ kũ nↄ̀bↄsɛ̃ntɛnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ kũ bisãsirinↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Pↄ́ kũ òdi wesa bo kũ ò kú sĩ̀sĩanↄ gàga pínki. ");
INSERT INTO bqp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Luda pↄ́ wɛ̃̀ndide kũ ò kú sĩ̀sĩanↄ kàkatɛ pínki. À bisãsirinↄ kũ nↄ̀bↄnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ kũ bãnↄ kàkatɛ andunia gũn. Nuhu mɛ́ à bò ado kũ pↄ́ kũ ò kú kãao gó gũnnↄ. ");
INSERT INTO bqp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Akũ í gↄ̃̀ da anduniala ari gↄrↄ basuppla akuri. ");
INSERT INTO bqp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nuhu kũ nↄ̀bↄsɛ̃ntɛnↄ kũ bɛ pↄ́kãde kũ ò kú kãao gó gũnnↄ pínki yã dↄ̀ Ludan. Kũ à ĩa gbàrɛ zĩtɛa, akũ í nà babanaaa. ");
INSERT INTO bqp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Í kũ ò kú zĩtɛ gbárunↄ kũ ludambɛ guforonↄ tàta, akũ legũ kɛ̃̀. ");
INSERT INTO bqp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Í pì tɛn baba busɛbusɛ àtɛn lago ari gↄrↄ basuppla akuri. ");
INSERT INTO bqp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","A mↄ supplade gↄrↄ gɛ̃ro awɛɛplade zĩ gó pìi dì kpi kũ òdi pi Ararataa. ");
INSERT INTO bqp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Í pì tɛn lago ari mↄ kuride gũn. Mↄ kuride pì gↄrↄ káaku zĩ kpinↄ mìsↄ̃ntɛnↄ bòbo. ");
INSERT INTO bqp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Gↄrↄ bupla gbɛra Nuhu gó wondo kũ à bòn yã wɛ̃̀, ");
INSERT INTO bqp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","akũ à kãakãanna gbàrɛ. Àtɛn vura àtɛn gɛ́ àtɛn su ari í bàba zĩtɛa. ");
INSERT INTO bqp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","À potɛ̃nɛ gbàrɛ dↄ de à le à dↄ̃ tó í làgo zĩtɛa. ");
INSERT INTO bqp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kũ potɛ̃nɛ dí diki lero, akũ a ɛ̀ra à sù Nuhu kĩnaa gó gũn, zaakũ í da anduniala pínkimɛ. Nuhu ↄ bò à a kũ̀ à gɛ̃̀o gó gũn. ");
INSERT INTO bqp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","À kámma bò ari gↄrↄ suppla, akũ à ɛ̀ra à potɛ̃nɛ gbàrɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Potɛ̃nɛ pìi ɛ̀ra à sù à kĩnaa ↄkↄsi à kù lá kɛ̃̀ à kpá a lɛ́i. Akũ Nuhu dↄ̃ kũ í làgo zĩtɛa. ");
INSERT INTO bqp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","À kámma bò gↄrↄ suppla dↄ, akũ à ɛ̀ra à potɛ̃nɛ pìi gbàrɛ, adi ɛra à sù a kĩnaa doro. ");
INSERT INTO bqp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu wɛ̃̀ wàa aakↄ̃ awɛɛdode gũn a mↄ káaku gↄrↄ káaku zĩ, í bàba zĩtɛa, akũ à gó pìi musu gò. Kũ à gu gwà, à è í làka zĩtɛa. ");
INSERT INTO bqp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A mↄ plade gↄrↄ baraasↄↄro awɛɛplade zĩ í bàba zĩtɛa. ");
INSERT INTO bqp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Akũ Luda yã ò Nuhunɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ǹ bo gó gũn kũ n nanↄo kũ n nɛ́gↄ̃gbɛ̃nↄ kũ ń nↄnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ǹ pↄ́ wɛ̃̀ndide kũ ò kú kũnwonↄ bↄtɛ pínki, bãnↄ kũ nↄ̀bↄnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ pínki, de ò fãkↄ̃a zĩtɛ ògↄ̃ nɛ́ i ògↄ̃ kara andunia gũn. ");
INSERT INTO bqp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Akũ Nuhu bò kũ a nɛ́nↄ kũ a nanↄo kũ a nɛ́ pìnↄ nↄnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nↄ̀bↄnↄ pínki kũ pↄ́ kũ òdi táa o kũ kùaonↄ pínki kũ bãnↄ pínki kũ pↄ́ kũ òdi táa o zĩtɛnↄ pínki bↄ̀tɛ gó gũn buri kũ burio. ");
INSERT INTO bqp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Akũ Nuhu Dikiri gbagbaki bò. À nↄ̀bↄ kũ bã kũ òdi sa oonↄ kũ̀, akũ à sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ òa. ");
INSERT INTO bqp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kũ Dikiri a gbĩ mà, à kɛ̀nɛ nna, akũ à laasun lɛ̀ à pì: Mani ɛra mà láari bo zĩtɛa bisãsiri yãi doro, zaakũ bisãsiri laasun dìgↄ̃ vãni zaa a kɛfɛnnakɛgↄrↄamɛ. Mani ɛra mà pↄ́ wɛ̃̀ndidenↄ kakatɛ lákũ ma kɛ̀ nà doro. ");
INSERT INTO bqp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ari andunia gɛ́ àgↄ̃ kunwo pↄ́tↄ̃na kũ pↄ́kɛkɛnaao, ĩa kũ guwãnao, bunsirɛ kũ sakareo, fãnantɛ̃ kũ gwãanio, ń ke ni lákaro. ");
INSERT INTO bqp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Akũ Luda arubarikaa dà Nuhugu kũ a nɛ́nↄ à pìńnɛ: Àgↄ̃ nɛ́ i àgↄ̃ kara à andunia pa. ");
INSERT INTO bqp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nↄ̀bↄnↄ kũ bãnↄ kũ pↄ́ kũ òdi táa o kũ kùaonↄ kũ kpↄ̀nↄ nigↄ̃ á vĩna vĩ pínki. Ma ń náárɛ á ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Pↄ́ kũ òdi táa onↄ pínki nigↄ̃ de á pↄ́ble ũ. Ma ń kpááwa pínki lákũ ma pↄ́ble kũ òdi butɛ zĩtɛanↄ kpàáwa nà yã. ");
INSERT INTO bqp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ama àsun nↄ̀bↄ kũ odi a kùtu kpáro sóro, zaakũ a arumɛ a wɛ̃̀ndi ũ. ");
INSERT INTO bqp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mani á aru kũ à de á wɛ̃̀ndi ũ fĩna boárɛ. Tó nↄ̀bↄ gbɛ̃ dɛ̀ ke tó gbɛ̃ a gbɛ̃dake dɛ̀, mani a aru fĩna bonɛ. Mani fĩna bo gbɛ̃ kũ à a gbɛ̃dake dɛ̀ɛa. ");
INSERT INTO bqp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tó gbɛ̃ a gbɛ̃dake dɛ̀, oni a dɛ, zaakũ ma bisãsiri kɛ̀ ma taka ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Àgↄ̃ nɛ́ i àgↄ̃ kara, à da anduniala àgↄ̃ kɛ dasi. ");
INSERT INTO bqp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Luda pì Nuhunɛ kũ a nɛ́nↄ dↄ: ");
INSERT INTO bqp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ma bàka nigↄ̃ kú kãáo kũ á burinↄ ");
INSERT INTO bqp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kũ pↄ́ wɛ̃̀ndide kũ ò kú kãáo kũ ò bò gó gũnnↄ pínki, bãnↄ kũ bɛ pↄ́kãdenↄ kũ nↄ̀bↄsɛ̃ntɛnↄ kũ pↄ́ kũ ò kú zĩtɛanↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ma bàka nigↄ̃ kú kãáo. Mani í da anduniala mà pↄ́ wɛ̃̀ndidenↄ kakatɛ pínki doro. Í ni da anduniala à a kakatɛ doro. ");
INSERT INTO bqp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Akũ Luda ɛ̀ra à pì: Ma bàka nigↄ̃ kú kãáo kũ pↄ́ wɛ̃̀ndide kũ ò kú kãáonↄ ari gↄrↄ sĩnda pínkimɛ. A sèedaan dí. ");
INSERT INTO bqp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mani ludambɛfɛ̃nɛda bo legũa ma bàka kunna kũ anduniao sèeda ũ. ");
INSERT INTO bqp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tó ma tò legũ sìsi ludambɛfɛ̃nɛda bòa, ");
INSERT INTO bqp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","lákũ ma bàka kú kãáo nà kũ pↄ́ wɛ̃̀ndide buri sĩnda pínkio, a yã ni dↄmagu. Mani tó í da anduniala à pↄ́ wɛ̃̀ndide kakatɛ pínki doro. ");
INSERT INTO bqp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tó ma ludambɛfɛ̃nɛda è legũa, ma bàka kunna kũ pↄ́ wɛ̃̀ndide buri sĩnda pínkio ari gↄrↄ sĩnda pínki yã ni dↄmagu. ");
INSERT INTO bqp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Akũ Luda pì Nuhunɛ: Ma bàka kunna kũ pↄ́ wɛ̃̀ndide kũ ò kú andunia gũnnↄ pínki sèedaan gwe. ");
INSERT INTO bqp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhu nɛ́ kũ ò bↄ̀tɛ gó gũnnↄ tↄ́n dí: Sɛmu, Hamu, Yafɛti. Hamumɛ Kanaa de ũ. ");
INSERT INTO bqp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuhu nɛ́nↄn gwe gbɛ̃nↄn aakↄ̃. Ń burinↄ mɛ́ ò dàgula andunia gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu bi búbariimɛ, akũ à geepi líkpɛ bà. ");
INSERT INTO bqp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kũ à sèwɛ̃ mì à kã̀, akũ a wutɛna pótompo a kpɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kũ Kanaa de Hamu a de pótompo è, à bò à gɛ̀ɛ à ò Sɛmunɛ kũ Yafɛtio. ");
INSERT INTO bqp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Akũ Sɛmu kũ Yafɛtio uta zↄ̃kↄ̃ↄ sɛ̀ ò dì ń gã̀aa ń pla ò táa ò kũ kpɛo. Ń arɛ dↄna gu pãndea de òsun ń de pótompo ero yãi, ò gɛ̀ɛ ò kù ń de pótompola. ");
INSERT INTO bqp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kũ wɛ̃ wère Nuhua à vù, à mà lákũ a nɛ́ kpɛde kɛ̀arɛ nà, ");
INSERT INTO bqp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","akũ à pì: Kanaa nigↄ̃ láari pↄ́ ũmɛ, àkũ mɛ́ anigↄ̃ a gbɛ̃nↄ zↄ̀ kpɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Akũ à pì: Arubarikademɛ Dikiri, Sɛmu Luda ũ, Kanaa nigↄ̃ de Sɛmu zↄ̀ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Luda karana kɛ Yafɛtinɛ, a burinↄ ń baka le Sɛmu burinↄ arubarikaa gũn, Kanaa nigↄ̃ de Yafɛti zↄ̀ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Í dana anduniala gbɛra Nuhu kɛ̀ wɛ̃̀ wàa do kpɛ́ basuppla akuri. ");
INSERT INTO bqp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","À kɛ̀ wɛ̃̀ wàa siikↄ̃ kpɛ́ basuppla akuri, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuhu nɛ́gↄ̃gbɛ̃nↄ Sɛmu kũ Hamuo kũ Yafɛtio kũ ń nɛ́gↄ̃gbɛ̃ kũ ò ì í dana anduniala gbɛranↄ yãn dí. ");
INSERT INTO bqp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafɛti nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Goma, Magↄgu, Midiã, Girisi, Tubala, Mɛsɛki kũ Tirasao. ");
INSERT INTO bqp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goma nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Asakɛnaza, Rifa, Tↄgama. ");
INSERT INTO bqp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Girisi nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Ɛlisa, Tasisi, Sipiru, Rodanimu. ");
INSERT INTO bqp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Buri pìnↄ mɛ́ ò dàgula ísira gɛrɛɛi, ò kↄ̃ kpàatɛtɛ bùsu kũ bùsuuo buri kũ burio danɛdanɛ, baadi kũ a buriyão. ");
INSERT INTO bqp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamu nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Etiopia, Misila, Libia kũ Kanaao. ");
INSERT INTO bqp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Etiopia nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Sɛba, Avila, Sabata, Raama kũ Sabatɛkao. Raama nɛ́gↄ̃gbɛ̃nↄmɛ Seba kũ Dedão ũ. ");
INSERT INTO bqp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nimlↄdu bi Etiopia burimɛ dↄ. Àkũmɛ andunia gbãnazↄ̃kↄ̃de tↄ́de káaku ũ. ");
INSERT INTO bqp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Tofe sàamɛ Dikiri kĩnaa. A yã mɛ́ à tò òdi pi: Lákũ Nimlↄdu de tofe sà ũ Dikiri kĩnaa nà. ");
INSERT INTO bqp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Babilↄnia bùsu kũ à kí blèa káaku wɛ́ranↄmɛ Babɛli kũ Ɛrɛkio kũ Akadao kũ Kalanɛo ũ. ");
INSERT INTO bqp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Bona gwe à gɛ̀ɛ Asiria bùsun, akũ à Ninɛva kàtɛ kũ Reobo'irio kũ Kalao ");
INSERT INTO bqp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kũ Rɛsɛ̃ kũ à kú Ninɛva dagura kũ Kalao. Ninɛvamɛ wɛ́ra zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misila burinↄn dí: Ludunↄ, Anamunↄ, Lɛabanↄ, Nafatunↄ, ");
INSERT INTO bqp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarusinↄ, Kasalunↄ kũ Kɛrɛti kũ Filisitininↄ bò ń gũnnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaa daudu Sidↄ̃ burinↄn dí: Itinↄ, ");
INSERT INTO bqp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusinↄ, Amↄrinↄ, Gigasinↄ, ");
INSERT INTO bqp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ivinↄ, Akinↄ, Sininↄ, ");
INSERT INTO bqp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avadanↄ, Zɛmarinↄ kũ Amatanↄo. Kanaa pìnↄ dàgula kpɛkpɛ. ");
INSERT INTO bqp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ń bùsu lɛ́zɛkin dí. Bona zaa Sidↄ̃ gɛna Gera kũ à kú Gaza sarɛ ari Sↄdↄmu kũ Gↄmↄrao kũ Adamao kũ Zeboimu kũ à kú Lasa sarɛo. ");
INSERT INTO bqp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hamu nɛ́gↄ̃gbɛ̃nↄn gwe buri kũ burio bùsu kũ bùsuuo danɛdanɛ, baadi kũ a buriyão. ");
INSERT INTO bqp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafɛti dakũna Sɛmu buri kɛ̀ dↄ. Àkũmɛ Eberunↄ dizi káaku ũ. ");
INSERT INTO bqp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛmu nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Elamu, Asiria, Apasada, Ludu kũ Aramuo. ");
INSERT INTO bqp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Uzu, Hulu, Geta kũ Mɛsɛkio. ");
INSERT INTO bqp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apasada mɛ́ à Sela ì, akũ Sela Eberu ì. ");
INSERT INTO bqp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberu nɛ́gↄ̃gbɛ̃nↄ ì gbɛ̃nↄn pla. A do tↄ́n Pɛlɛgi, zaakũ a gↄrↄn ò kɛ̃̀kↄ̃a andunia gũn. A dakũna tↄ́n Yↄkↄtã. ");
INSERT INTO bqp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yↄkↄtã nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Alamↄdada, Sɛlɛfi, Azamavɛ, Yera, ");
INSERT INTO bqp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoramu, Uzala, Dikala, ");
INSERT INTO bqp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimaɛli, Seba, ");
INSERT INTO bqp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi, Avila kũ Yobabuo. Yↄkↄtã nɛ́gↄ̃gbɛ̃nↄn gwe pínki. ");
INSERT INTO bqp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bona Mɛsa gɛna Sefa kũ kpi kũ ò kú ifãboki kpanↄ, àkũmɛ ń bùsu ũ. ");
INSERT INTO bqp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sɛmu nɛ́gↄ̃gbɛ̃nↄn gwe pínki buri kũ burio bùsu kũ bùsuuo danɛdanɛ, baadi kũ a buriyão. ");
INSERT INTO bqp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nuhu nɛ́gↄ̃gbɛ̃nↄ burinↄn gwe danɛdanɛ bùsu kũ bùsuuo. Ń kĩnaan andunia buri sĩnda pínki bòn ò dàgula í dana anduniala gbɛra. ");
INSERT INTO bqp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Andunia gũn yã pínki buri mɛ̀n domɛ, yã dokↄ̃nↄn òdi o. ");
INSERT INTO bqp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lákũ gbɛ̃nↄ tɛn sↄ̃sↄ̃ ifãboki kpa nà, kũ ò kà Babilↄnia bùsu gusaran, akũ ò vùtɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ò pìkↄ̃nɛ: Ò gɛ́ ò kúnku bo ò kpáta manamana. Kúnkumɛ ń gbɛ̀ ũ, ↄ̀daamɛ ń simiti ũ. ");
INSERT INTO bqp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Akũ ò pì: Ò wɛ́ra kátɛ ò kpɛ́didikↄ̃ana bo a mìsↄ̃ntɛ zↄ̃ ludambɛa. Ò ó zĩda tↄ́ bo de òsungↄ̃ fãkↄ̃ana dodo andunia gũnlo yãi. ");
INSERT INTO bqp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Akũ Dikiri kìpa à wɛ́ra pìi gwà kũ kpɛ́ lei kũ bisãsirinↄ bòoo. ");
INSERT INTO bqp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Akũ à pì: Ń pínki ń buri dokↄ̃nↄmɛ, yã dokↄ̃nↄn òdi o, akũ yã kũ òtɛn boon dí yá? Yã kũ ò a laasun lɛ̀ tera sà oni kɛmɛ, pↄ́ke ni kpáńnɛ a kɛnaa gũn doro. ");
INSERT INTO bqp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ò kipa ò gɛ́ gwe ò ń yã yãkatɛńnɛ de òsun kↄ̃ yã ma doro. ");
INSERT INTO bqp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Akũ Dikiri ń fãkↄ̃a gwe dodo andunia gũn pínki, akũ ò ń wɛ́ra katɛnaa tò. ");
INSERT INTO bqp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","A yã mɛ́ à tò, ò tↄ́ kpà wɛ̃tɛ pìinɛ Babɛli, zaakũ gwen Dikiri tò andunia buri sĩnda pínki yã bòn. Zaa gwen à ń fãkↄ̃a andunia gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛmu burinↄ yãn dí. Sɛmu wɛ̃̀ basↄↄrode gũn à Apasada ì ídana anduniala gbɛra wɛ̃̀ pla. ");
INSERT INTO bqp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A gbɛra à kɛ̀ wɛ̃̀ wàa pla kpɛ́ basↄↄro à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apasada wɛ̃̀ baraakuri awɛɛsↄↄrode gũn à Sela ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A gbɛra à kɛ̀ wɛ̃̀ wàa pla kũ aakↄ̃o à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela wɛ̃̀ baraakuride gũn à Eberu ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A gbɛra à kɛ̀ wɛ̃̀ wàa pla kũ aakↄ̃o à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberu wɛ̃̀ baraakuri awɛɛsiikↄ̃de gũn à Pɛlɛgi ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A gbɛra à kɛ̀ wɛ̃̀ wàa pla kũ baraakurio à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pɛlɛgi wɛ̃̀ baraakuride gũn à Rɛu ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A gbɛra à kɛ̀ wɛ̃̀ wàa do awɛɛkɛ̃ndo à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rɛu wɛ̃̀ baraakuri awɛɛplade gũn à Serugu ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A gbɛra à kɛ̀ wɛ̃̀ wàa do awɛɛsuppla à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugu wɛ̃̀ baraakuride gũn à Nao ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A gbɛra à kɛ̀ wɛ̃̀ wàa do à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nao wɛ̃̀ baraakuri donsaride gũn à Tera ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A gbɛra à kɛ̀ wɛ̃̀ basuddo donsari à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera kɛ̀ wɛ̃̀ baaakↄ̃ akuri, akũ à Abramu kũ Nao kũ Aranao ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera burinↄ yãn dí. Tera Abramu kũ Nao kũ Aranao ì, akũ Arana Lutu ì. ");
INSERT INTO bqp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Arana gà a de Tera wára zaa Urumɛ Kaladia bùsun, gu kũ ò a ìn. ");
INSERT INTO bqp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu kũ Nao nↄ sɛ̀. Abramu nanↄ tↄ́n Sarai, Nao nanↄ sↄ̃ tↄ́n Milika, Arana nɛ́. Arana pì mɛ́ à Isika ì dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai sↄ̃ paramɛ, adi nɛ́ iro. ");
INSERT INTO bqp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Akũ Tera a nɛ́ Abramu kũ a daikore Lutuo kũ Abramu nanↄ Saraio sɛ̀ bona Uru, Kaladia bùsun, òtɛn gɛ́ Kanaanↄ bùsun. Kũ ò kà Arana, ò vùtɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera wɛ̃̀ wàa do awɛɛsↄↄrode gũnn à gà zaa Arana. ");
INSERT INTO bqp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Dikiri pì Abramunɛ: Ǹ bo n bùsun n danɛnↄ tɛ́ n de bɛa, ǹ tá bùsu kũ mani mↄnnɛn. ");
INSERT INTO bqp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mani tó n buri kɛ dasi, mani arubarika dangu mà n tↄ́ bo, n kĩnaan onigↄ̃ arubarika len. ");
INSERT INTO bqp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mani arubarika da gbɛ̃ kũ oni sa mana onnɛnↄn, mani gbɛ̃ kũ oni sa vãni onnɛnↄ ká. Andunia buri sĩnda pínki ni arubarika le n gãi. ");
INSERT INTO bqp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Akũ Abramu dà zɛ́n lákũ Dikiri ònɛ nà. Lutu gɛ̀ɛ kãao. A wɛ̃̀ baaakↄ̃ akuri awɛɛsↄↄrode gũn à bò Arana ");
INSERT INTO bqp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","kũ a nanↄ Saraio kũ a vĩ̀ni nɛ́ Lutuo kũ ń aruzɛkɛ kũ ò vĩnↄ kũ gbɛ̃ kũ ò sɛ̀ gwenↄ. Lɛn ò bò Arana lɛ ò dà Kanaa zɛ́n. Kũ ò kà gwe, ");
INSERT INTO bqp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","akũ ò gɛ̃̀tɛ bùsuu pìn ari ò kà Mↄre gbiri lí kĩnaa Sɛkɛmu. Kanaanↄn kú bùsuu pìn gↄrↄ birea. ");
INSERT INTO bqp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Akũ Dikiri bò à sù Abramua à pì: Mani bùsu dí kpá n burinↄamɛ. Akũ à Dikiri gbagbaki bò gwe. ");
INSERT INTO bqp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kũ à fùtɛ gwe, à mìi pɛ̀ kpi kũ ò kú Bɛtɛli ifãboki kpanↄa, akũ à bùraa kàtɛ gwe, Bɛtɛli kú ifãlɛtɛ kpa, Ai kú ifãboki kpa. À Dikiri gbagbaki bò gwe dↄ, akũ à a sìsi. ");
INSERT INTO bqp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Akũ à dà zɛ́n dↄ à mìi pɛ̀ Nɛgɛvia. ");
INSERT INTO bqp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kũ nàa kà bùsuu pìn, akũ Abramu gɛ̀ɛ gↄrↄ pla kɛ Misila, zaakũ nàa pìi gɛ̃̀ ↄla. ");
INSERT INTO bqp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kũ à kà kãni kũ Misilao, à pì a nanↄnɛ: Má dↄ̃ nↄ manamɛ n ũ. ");
INSERT INTO bqp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tó Misilanↄ n e, oni pi ma nanↄmɛ n ũ, oni ma dɛ oni n tó. ");
INSERT INTO bqp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ǹ pińnɛ ma dãremɛ n ũ de ò ma sí ↄplapla n yãi. Lákũ ĩni ma mì sí nàn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kũ ò kà Misila, Misilanↄ è nↄgbɛ̃ pì mana gɛ̃̀. ");
INSERT INTO bqp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kũ Misilanↄ kína Firi'auna ìbanↄ a è, ò a mana gↄ̃̀gↄ̃nɛ, akũ ò a sɛ̀ ò gɛ̃̀ kãao Firi'aunanɛ a bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Akũ à Abramu gwà manamana a yãi, à sãnↄ kpàa kũ zùnↄ kũ zaakinↄ kũ gↄ̃gbɛ̃ zĩkɛrinↄ kũ nↄgbɛ̃ zĩkɛrinↄ kũ lakuminↄo. ");
INSERT INTO bqp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Akũ Dikiri gyã pãsĩnↄ kà Firi'aunagu kũ a bedenↄ Abramu nanↄ pì yãi. ");
INSERT INTO bqp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Akũ Firi'auna Abramu sìsi à pìnɛ: Bↄ́ yã n kɛ̀mɛnɛ gwee? Bↄ́ yã mɛ́ à tò ńdi omɛnɛ kũ n nanↄnloo? ");
INSERT INTO bqp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","À kɛ̀ dera n pì n dãremɛ, akũ ma a sɛ̀ nↄ ũu? N nↄn di! Ǹ n pↄ́ sɛ́ ǹ táo. ");
INSERT INTO bqp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Firi'auna yã ò a gbɛ̃nↄnɛ Abramu yã musu, akũ ò gɛ̀ɛ ò zɛ̀nɛ kũ a nanↄo kũ a aruzɛkɛnↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Akũ Abramu bò Misila à sù Nɛgɛvi kũ a nanↄo kũ a aruzɛkɛnↄ pínki kũ Lutuo. ");
INSERT INTO bqp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu bi aruzɛkɛdemɛ, à pↄ́kãdenↄ vĩ dasi kũ andurufuuo kũ wuraao. ");
INSERT INTO bqp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Bona Nɛgɛvi à sↄ̃̀sↄ̃ gu kũ guo ari à gɛ̀ɛ à kào Bɛtɛli, gu kũ à bùraa kàtɛn káaku Bɛtɛli dagura kũ Aio, ");
INSERT INTO bqp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","gu kũ à sa'oki bòn yã. Akũ à Dikiri sìsi gwe. ");
INSERT INTO bqp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lutu dìgↄ̃ tɛ́ kũ Abramuo lɛɛlɛ. À sãnↄ kũ zùnↄ kũ bizakutanↄ vĩ se. ");
INSERT INTO bqp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ń pↄ́kãdenↄn dasi, gu pìi sɛ̃̀ dí mↄ́ḿma ń pínkiro. A yã mɛ́ à tò oni fↄ̃ ògↄ̃ kú gu dokↄ̃nↄ lɛɛlɛ doro. ");
INSERT INTO bqp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Akũ lɛ́kpakↄ̃a gɛ̃̀ Abramu pↄ́dãrinↄ kũ Lutu pↄ́dãrinↄ dagura. Zĩ kũ̀a sↄ̃ Kanaanↄ kũ Pɛrizinↄn kú bùsuu pìn. ");
INSERT INTO bqp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Akũ Abramu pì Lutunɛ: À mana lɛ́kpakↄ̃a gↄ̃ kú ó daguraro, ke ma pↄ́dãrinↄ kũ n pↄ́dãrinↄ dagura, zaakũ danɛnↄn ó ũ. ");
INSERT INTO bqp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ǹ bùsu gwa da n arɛ pínki. Ò kɛ̃kↄ̃a. Tó n gɛ ↄzɛi, mani gɛ́ ↄplai. Tó n gɛ ↄplaimɛ sↄ̃, mani gɛ́ ↄzɛi. ");
INSERT INTO bqp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kũ Lutu gu gwà, à è Yoda guvutɛ pínki mↄtↄ vĩ manamana. Ari Dikiri gↄ̃ gɛ́ Sↄdↄmu kũ Gↄmↄrao kakatɛ, guvutɛ pì de lán Dikiri swadakoo bà, lán Misila bùsuu bà, ari à gɛ̀ɛ pɛ́ Zoaa. ");
INSERT INTO bqp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Akũ Lutu Yoda guvutɛ sɛ̀ pínki. Ò kɛ̃̀kↄ̃a, akũ Lutu dà zɛ́n à tà ifãboki kpa. ");
INSERT INTO bqp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu gↄ̃̀ Kanaanↄ bùsun, Lutu sↄ̃ à kú Yoda guvutɛ wɛ̃tɛnↄ dagura. À bùraa kàtɛ Sↄdↄmu sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sↄdↄmudenↄ sↄ̃ ò vãni, durunnakɛri sànↄmɛ ń ũ Dikiri kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lutu tanaa gbɛra Dikiri pì Abramunɛ: Gu kũ ń zɛ́n ǹ wɛ́ sɛ́ ǹ gugbãnduru kũ gɛ̀nↄmidↄkio kũ ifãbokio kũ ifãlɛtɛo gwa. ");
INSERT INTO bqp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Zĩtɛ kũ n è pínki, ma kpàmma, anigↄ̃ de mↄkↄ̃n kũ n burinↄ pↄ́ ũ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mani tó n burinↄ kɛ dasi lán bùsu'atɛ̃ bà. Tó gbɛ̃ke ni fↄ̃ à bùsu'atɛ̃ naro, de ani fↄ̃ à n burinↄ naro. ");
INSERT INTO bqp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ǹ futɛ ǹ gɛ̃ bùsuu pìn ǹ a gbã̀na kũ a yàasaao gwa, zaakũ ma kpàmmamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abramu fùtɛ à gɛ̀ɛ à vùtɛ Mamare gbiri lí kũ ò kú Ɛblↄnunↄ sarɛ, akũ à Dikiri gbagbaki bò gwe. ");
INSERT INTO bqp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Zĩkea Babilↄnia bùsu kína Amarafɛli kũ Ɛlasa bùsu kína Ariↄkio kũ Elamu bùsu kína Kɛdↄlaomɛɛo kũ Goimu bùsu kína Tidalao ");
INSERT INTO bqp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","tɛn zĩ̀ ká kũ Sↄdↄmu kína Bɛrao kũ Gↄmↄra kína Bisao kũ Adama kína Sinabuo kũ Zeboimu kína Sɛmɛbao kũ Bɛla kũ òdi pi tera Zoa kínao. ");
INSERT INTO bqp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kína gbɛ̃nↄn sↄↄro pìnↄ kↄ̃ kàkara ń pínki Sidimu guvutɛn. Àkũmɛ Sɛ̀bɛ Wiside ũ tera. ");
INSERT INTO bqp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wɛ̃̀ kuri awɛɛpla dagura òdigↄ̃ táfe bo Kɛdↄlaomanɛ. A wɛ̃̀ kuri awɛɛ'aakↄ̃de gũnn ò gì bonɛi. ");
INSERT INTO bqp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A wɛ̃̀ gɛ̃ro donsaride gũnn Kɛdↄlaoma kũ kína kũ ò kú kãaonↄ sù ò zĩ̀i blè Rɛfaimunↄa zaa Asɛtɛro Kanaimu, ò zĩ̀i blè Zuzinↄa zaa Hamu, ò zĩ̀i blè Ɛminↄa zaa Save Kiriataimu, ");
INSERT INTO bqp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ò zĩ̀i blè Orinↄa ń kpi kũ òdi pi Seia ari à gɛ̀ɛ pɛ́ Ɛli Parana gbárannaa. ");
INSERT INTO bqp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Akũ ò ɛ̀ra ò sù Ɛmisipa. Àkũ òdi pi tera Kadɛsi. Ò zĩ̀i blè Amalɛki bùsuua pínki kũ Amↄri buri kũ ò kú Azazↄ̃ Tamanↄa dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Akũ Sↄdↄmu kína kũ Gↄmↄra kínao kũ Adama kínao kũ Zeboimu kínao kũ Bɛla kũ òdi pi tera Zoa kínao fùtɛ ò gɛ̀ɛ ò zĩ̀ ká kũńwo Sidimu guvutɛn. ");
INSERT INTO bqp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Òtɛn zĩ̀ ká kũ Elamu bùsu kínao kũ Goimu bùsu kínao kũ Babilↄnia bùsu kínao kũ Ɛlasa bùsu kínao. Kína gbɛ̃nↄn siikↄ̃ pìnↄ tɛn zĩ̀ ká kũ kína gbɛ̃nↄn sↄↄronↄ. ");
INSERT INTO bqp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidimu guvutɛ ↄ̀da wɛ̀ɛ vĩ dasi. Kũ Sↄdↄmu kína kũ Gↄmↄra kínao tɛn bàa lɛ́, akũ ò sì a gũn, akũ ń gbɛ̃ kparanↄ bàa lɛ̀ ò gɛ̀ɛ gusĩsĩden. ");
INSERT INTO bqp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Zĩ̀blerinↄ Sↄdↄmu kũ Gↄmↄrao aruzɛkɛnↄ kũ ń pↄ́blenↄ sɛ̀tɛ pínki ò tào. ");
INSERT INTO bqp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Gↄrↄ kũ̀a Abramu vĩ̀ni nɛ́ Lutu kú Sↄdↄmu, akũ ò a kũ̀ ò tà kãao kũ a aruzɛkɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Akũ gbɛ̃ kũ à bò ń ↄĩ gɛ̀ɛ à ò Eberu buri Abramunɛ zaa Mamare gbiri línↄ sarɛ. Mamare kũ a dakũnanↄ Ɛsɛkↄlu kũ Anɛo bi Amↄri burinↄmɛ, ò de kↄ̃ gbɛ̃ ũ kũ Abramuo. ");
INSERT INTO bqp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kũ Abramu mà ò a danɛ kũ̀ ò tà kãao, akũ à a bɛ zĩ̀karinↄ sɛ̀tɛ gbɛ̃nↄn wàa do kpɛ́ basuddo plansari à pɛ̀tɛ kína pìnↄi, akũ à ń lé Dã. ");
INSERT INTO bqp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Akũ à a gbɛ̃nↄ kpàatɛtɛ, akũ ò sìńgu gwãani. Ò zĩ̀i blèḿma ò pɛ̀ḿma ari Oba, Damasuku gugbãnduru kpa. ");
INSERT INTO bqp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","À ɛ̀ra à sù kũ aruzɛkɛ pìnↄ pínki kũ a vĩ̀ni nɛ́ Lutuo kũ a aruzɛkɛnↄ. À sù kũ nↄgbɛ̃nↄo kũ gbɛ̃ pãndenↄ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kũ Abramu zĩ̀i blè Kɛdↄlaomaa kũ kína kũ ò kú kãaonↄ àtɛn su, akũ Sↄdↄmu kína bò à dàalɛ Save Guvutɛ kũ òdi pi tera Kína Guvutɛn. ");
INSERT INTO bqp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Akũ Salɛmu kína Mɛlɛkizɛdɛki sù kũ burodiio kũ sèwɛ̃o. Àpi bi Luda Musude gbàgbariimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Akũ à sa mana ò Abramunɛ à pì: Luda Musude musu kũ zĩtɛo Kɛ̀ri arubarika da Abramun. ");
INSERT INTO bqp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Arubarikaden Luda Musude kũ à n ibɛrɛnↄ nànnɛ n ↄĩ ũ. Akũ Abramu aruzɛkɛ kũ àtɛn sunↄ pínki kuride kpàa. ");
INSERT INTO bqp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sↄdↄmu kína pì Abramunɛ: Ǹ ma gbɛ̃nↄ kpáma ǹgↄ̃ aruzɛkɛ kũna n pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Akũ Abramu pìnɛ: Ma sì kũ Dikiri Luda Musude musu kũ zĩtɛo Kɛ̀riio, ");
INSERT INTO bqp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mani n pↄ́ke sɛ́ro, bee kyateyĩba, de ǹsun pi n ma kɛ aruzɛkɛde ũro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mani pↄ́ke sɛ́ro, sé pↄ́ble kũ ma gbɛ̃nↄ blèe baasiro. Ama Anɛ kũ Ɛsɛkↄluo kũ Mamare kũ ò gɛ̀ɛ kũmaonↄ, ǹ tó ò ń baka sɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Abire gbɛra Dikiri yã ò Abramunɛ wɛ́gupu'enaa gũn à pì: Abramu! Ǹsun vĩna kɛro. Makũmɛ n sɛ̃gbako ũ, n láada nigↄ̃ zↄ̃kↄ̃ manamana. ");
INSERT INTO bqp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Akũ Abramu pì: Dikiri Luda, bↄ́n ĩni ma gbaa? Má nɛ́ vĩro. Damasuku gbɛ̃ Ɛliɛza mɛ́ anigↄ̃ de ma bɛ túbibleri ũ. ");
INSERT INTO bqp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kũ ńdi ma gba nɛ́ro, ma bɛ zĩkɛri pì mɛ́ anigↄ̃ de ma túbibleri ũ. ");
INSERT INTO bqp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Akũ Dikiri pìnɛ: Àpi mɛ́ anigↄ̃ de n túbibleri ũro. Nɛ́ kũ ani bo n wóplɛn mɛ́ anigↄ̃ de n túbibleri ũ. ");
INSERT INTO bqp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Akũ à bò kãao bàai à pì: Ǹ musu gwa ǹ susunɛnↄ naro, tó ĩni fↄ̃. Lɛmɛ n burinↄ nigↄ̃ de lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","À Dikiri náani kɛ̀, akũ Dikiri tò yã bò kãao nna a náani kũ à kɛ̀ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","À pìnɛ dↄ: Dikirimɛ ma ũ, makũ mɛ́ ma n bo Uru, Kaladia bùsun, de mà bùsu díkĩna kpámma yãi. ");
INSERT INTO bqp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Akũ Abramu pì: Dikiri Luda, deran manigↄ̃ dↄ̃ kũ anigↄ̃ de ma pↄ́ ũu? ");
INSERT INTO bqp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","À wèa à pì: Ǹ zùnunu wɛ̃̀ aakↄ̃ sɛ́ kũ blè wɛ̃̀ aakↄ̃o kũ sãkaro wɛ̃̀ aakↄ̃o kũ potɛ̃nɛtɛ̃nnao kũ lukulukuuo. ");
INSERT INTO bqp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Akũ à pↄ́ pìnↄ sɛ̀ à sùo pínki à pàrapara à gògokↄ̃a, akũ à kàtɛ à ń arɛ dↄ̀dↄkↄ̃a, ama adi bãnↄ parapararo. ");
INSERT INTO bqp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kũ yumburukunↄ sù ò dìdi nↄ̀bↄↄ pìnↄa, akũ Abramu pɛ̀ḿma. ");
INSERT INTO bqp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kũ ifãntɛ̃ tɛn gɛ̃ kpɛ́n, i zↄ̃kↄ̃ Abramu kũ̀, akũ gusira zↄ̃kↄ̃ vĩnade dàala. ");
INSERT INTO bqp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Akũ Dikiri pìnɛ: Ǹgↄ̃ dↄ̃ kũ n burinↄ nigↄ̃ nibↄ ble bùsu kũ à de ń pↄ́ ũro gũn, onigↄ̃ zↄ̀ ble gwe, onigↄ̃ wɛ́ tãḿma ari wɛ̃̀ wàa pla. ");
INSERT INTO bqp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ama mani wari dↄ buri kũ òtɛn zↄ̀ bleńnɛa, n burinↄ ni bↄtɛ kũ aruzɛkɛ zↄ̃kↄ̃ↄo. ");
INSERT INTO bqp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mↄkↄ̃n sↄ̃, ĩnigↄ̃ aafiamɛ ari ǹ gɛ́ zĩ kũo, gbasa ǹ ká n dizinↄla oni n vĩ. ");
INSERT INTO bqp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","N nasionↄ mɛ́ oni ɛra ò su la, zaakũ Amↄrinↄ durunna dí papa kↄ̀ro. ");
INSERT INTO bqp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kũ ifãntɛ̃ gɛ̃̀ kpɛ́n, gu sì, akũ Abramu è kĩni kũ àtɛn túsukpɛ bo kũ sɛ̃̀tɛo tɛn gɛ̃ nↄ̀bↄ kũ à pàrapara pìnↄ dagura. ");
INSERT INTO bqp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Zĩ birea Dikiri pì a bàka nigↄ̃ kú kũ Abramuo à pì: Mani bùsu díkĩna kpá n burinↄa zaa Misila bùsu lɛ́zɛki swai ari swada kũ òdi pi Yuflati, ");
INSERT INTO bqp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","bùsu kũ Keninↄn kun kũ Kenizinↄ kũ Kadamↄnunↄ ");
INSERT INTO bqp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kũ Itinↄ kũ Pɛrizinↄ kũ Rɛfaimunↄ ");
INSERT INTO bqp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","kũ Amↄrinↄ kũ Kanaanↄ kũ Gigasinↄ kũ Yebusinↄo. ");
INSERT INTO bqp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abramu nanↄ Sarai dí nɛ́ iro. À nↄgbɛ̃ zĩkɛri vĩ Misila gbɛ̃ ũ kũ òdi pinɛ Hazara. ");
INSERT INTO bqp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Akũ Sarai pì Abramunɛ: Lákũ Dikiri ma kɛ para ũ nà, ǹ wútɛ kũ ma zĩkɛriio. Ma sì kũ mani nɛ́nↄ le a gãi. Akũ Abramu Sarai yã mà. ");
INSERT INTO bqp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abramu wɛ̃̀ kuri kɛna Kanaanↄ bùsun gbɛran Sarai a zĩkɛri Hazara kpàa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramu wùtɛ kãao, akũ à nↄ̀ↄ sì. Kũ à è á nↄ̀sinaa, à dↄkɛ̀ kũ a dikiriio. ");
INSERT INTO bqp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Akũ Sarai pì Abramunɛ: Taari kũ ò kɛ̀mɛnɛ gↄ̃̀ n yã ũmɛ. Ma a zĩkɛrii kpàmma. Kũ à è á nↄ̀sina, akũ àdigↄ̃ dↄkɛ kũmao. Mↄkↄ̃n kũ makũo, Dikiri mɛ́ ani yã gↄ̃gↄ̃wɛrɛ. ");
INSERT INTO bqp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Akũ Abramu wèa à pì: N zĩkɛri kun n pↄ́ ũmɛ. Ǹ kɛnɛ lákũ ń yei nà. Kũ Sarai wari dↄ̀a, akũ à bàa lɛ̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Dikiri Malaika a è ísɛ̃bokia gbárannan, ísɛ̃boki pì kú Suru zɛ́ sarɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Akũ à a là à pì: Sarai zĩkɛri Hazara, n bo mámɛɛ? Ntɛn gɛ́ mámɛɛ? Akũ à wèa à pì: Matɛn bàa lɛ́ ma dikiri Sarainɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Akũ Dikiri Malaikaa pìnɛ: Ǹ ɛra ǹ tá n dikirii pì kĩnaa ǹgↄ̃ mì natɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mani n buri kara ògↄ̃ dasi, oni fↄ̃ ò ń lɛ́ dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ń nↄ̀sina, ĩni nɛ́ i gↄ̃gbɛ̃ ũ, ĩni tↄ́ kpánɛ Sumaila, zaakũ Dikiri n yã mà n wɛ́tãmma gũn. ");
INSERT INTO bqp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Anigↄ̃ de lán zaakisɛ̃ntɛ bà, ani ibɛrɛ sɛ́ kũ gbɛ̃ sĩnda pínkio, gbɛ̃ sĩnda pínki ni ibɛrɛ sɛ́ kãao se. Anigↄ̃ kú kↄ̃ yãn kũ a gbɛ̃nↄro. ");
INSERT INTO bqp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Akũ Hazara pì: Ma wɛ́ sì Luda kũ àdi ma elɛ. Akũ à tↄ́ kpà Dikiri kũ à yã ònɛɛnɛ Ludakũadima'e. ");
INSERT INTO bqp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","A yã mɛ́ à tò ò tↄ́ kpà lↄ̀gↄↄ pìinɛ Ludabɛ̃nɛkũadima'e lↄ̀gↄↄ. À kú Kadɛsi kũ Bɛrɛdio daguramɛ. ");
INSERT INTO bqp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hazara nɛ́gↄ̃gbɛ̃ ì kũ Abramuo, akũ Abramu tↄ́ kpànɛ Sumaila. ");
INSERT INTO bqp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Gↄrↄ kũ Hazara Sumaila ì, Abramu wɛ̃̀ basiikↄ̃ awɛɛsuddomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kũ Abramu kà wɛ̃̀ basↄↄro donsari, Dikiri bò à sùa à pì: Luda Gbãnasĩndapinkiden ma ũ. Ǹ táa o kũmao ǹgↄ̃ kun taari sari. ");
INSERT INTO bqp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma bàka kunna kũnwo nigↄ̃ gɛ́, mani n buri karannɛ manamana. ");
INSERT INTO bqp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramu wùtɛ a gbɛrɛa Luda arɛ, akũ Luda pìnɛ: ");
INSERT INTO bqp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Lákũ ma bàka kú kũnwo nà, ĩni gↄ̃ buri dasinↄ dizi ũ. ");
INSERT INTO bqp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Onigↄ̃ pinnɛ Abramu doro, sé Ibrahĩ, zaakũ mani n kɛ buri dasinↄ dizi ũ. ");
INSERT INTO bqp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mani tó n buri kɛ dasi, burinↄ kũ kínanↄ ni bo n kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ma bàka nigↄ̃ kú kũnwo kũ n burinↄ ari gↄrↄ sĩnda pínki. Manigↄ̃ de n Luda ũ kũ n burinↄ n gbɛra. ");
INSERT INTO bqp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mani Kanaanↄ bùsu kũ ń kú a gũn nibↄ ũ kpámma pínki kũ n burinↄ n gbɛra, de ògↄ̃ vĩ gↄrↄ sĩnda pínki, manigↄ̃ de ń Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Luda ɛ̀ra à pì Ibrahĩnɛ: Mↄkↄ̃n kũ n burinↄ, àgↄ̃ ma bàka kunna kãáo yã kũna ari á buria. ");
INSERT INTO bqp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ma bàka kuna kãáo yã kũ ánigↄ̃ kũnan dí, mↄkↄ̃n kũ n burinↄ. Séde á gↄ̃gbɛ̃ sĩnda pínki tↄ̃̀ zↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","À tↄ̃̀ zↄ̃ ma bàka kunna kãáo sèeda ũ. ");
INSERT INTO bqp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Séde n buri nɛ́gↄ̃gbɛ̃nↄ tↄ̃̀ zↄ̃ ń gↄrↄ sↄraakↄ̃de zĩ ari ń buria, nɛ́ kũ ò ń í n bɛanↄ kũ zĩkɛri kũ ò ń lú buri pãndenↄanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ò a ì n bɛan yá kesↄ̃ ò a lù zĩkɛri ũn yá, sé à tↄ̃̀ zↄ̃. Abire nigↄ̃ de ma bàka kunna kãáo gↄrↄ sĩnda pínki sèeda ũ á mɛ̀ɛa. ");
INSERT INTO bqp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Oni gyↄfↄrↄde bo a gbɛ̃nↄ tɛ́, zaakũ gbɛ̃ kũ adi tↄ̃̀ zↄ̃ro yã kũ ma dìtɛárɛ kũnaro. ");
INSERT INTO bqp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Akũ Luda ɛ̀ra à pì Ibrahĩnɛ: Ǹsun pi n nanↄnɛ Sarai doro, ǹgↄ̃ pinɛ Sara sà. ");
INSERT INTO bqp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mani arubarika dan mà tó à nɛ́ i gↄ̃gbɛ̃ ũ, ani gↄ̃ burinↄ dai ũ, bùsu kínanↄ ni bo a kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Akũ Ibrahĩ wùtɛ a nɛ̀sɛlɛ kutɛna Luda arɛ à yáa dↄ̀ à pì a nɛ̀sɛɛ gũn: Gbɛ̃ kũ à kà wɛ̃̀ basↄↄro ni nɛ́ i yá? Lákũ Sara kà wɛ̃̀ basiikↄ̃ akuri nà, ani nɛ́ i yá? ");
INSERT INTO bqp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Akũ à ɛ̀ra à pì Ludanɛ: Ǹ sùru kɛ ǹ Sumaila gwa. ");
INSERT INTO bqp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Luda pì: Yãpura n nanↄ Sara ni nɛ́ i gↄ̃gbɛ̃ ũ, ĩni tↄ́ kpánɛ Isaaku. Ma bàka nigↄ̃ kú kãao kũ a burinↄ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Sumaila yã musu, ma n yã mà. Mani arubarika dan, ani nɛ́ i à kara manamana. Ani nɛ́gↄ̃gbɛ̃nↄ i gbɛ̃nↄn kuri awɛɛpla, oni gↄ̃ kínanↄ ũ, a buri ni kɛ dasi. ");
INSERT INTO bqp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bee kũ abireo ma bàka kunna kũnwo ni gↄ̃ Isaakuamɛ. Ziki mandara'i Sara ni a i. ");
INSERT INTO bqp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kũ Luda yã ò Ibrahĩnɛ à làka, akũ à a tò à tà musu. ");
INSERT INTO bqp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Akũ Ibrahĩ a nɛ́ Sumaila sɛ̀ kũ a bɛ gↄ̃gbɛ̃ kũ ò ń í a bɛanↄ kũ zĩkɛri kũ ò ń lúnↄ ń pínki, akũ à tↄ̃̀ↄ zↄ̃̀ńnɛ gↄrↄ birea gↄ̃̀nↄ lákũ Luda ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahĩ kà wɛ̃̀ basↄↄro donsari, gbasa à tↄ̃̀ↄ zↄ̃̀, ");
INSERT INTO bqp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","a nɛ́ Sumaila sↄ̃ wɛ̃̀ kuri awɛɛ'aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Gↄrↄ dokↄ̃nↄ pì zĩ Ibrahĩ tↄ̃̀ↄ zↄ̃̀ kũ a nɛ́ Sumailao ");
INSERT INTO bqp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kũ a bɛ gↄ̃gbɛ̃ kũ ò ń í a bɛanↄ kũ zĩkɛri kũ ò ń lú buri pãndeanↄ ń pínki. Ò tↄ̃̀ↄ zↄ̃̀ gↄrↄ dokↄ̃nↄ zĩmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Dikiri bò à sù Ibrahĩa Mamare gbiri línↄ sarɛ. Ibrahĩ vutɛna a bizakuta kpɛ́lɛlɛa fãnantɛ̃. ");
INSERT INTO bqp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kũ à wɛ́ sɛ̀ musu, à gbɛ̃nↄn aakↄ̃ è zɛna. Kũ à ń é lɛ, akũ à fùtɛ kpɛ́lɛlɛa kũ bàao à gɛ̀ɛ à dàńlɛ à wùtɛ a nɛ̀sɛlɛ kutɛna ");
INSERT INTO bqp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","à pì: Dikiri, tó ma n pↄnna lè, ǹsun gɛ̃ makũ n zↄ̀blerilaro. ");
INSERT INTO bqp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mani suárɛ kũ ío à gbá pípi à kámma bo lí gbáru la. ");
INSERT INTO bqp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Lákũ a bↄtɛ ma bɛ kpa nà, mani suárɛ kũ pↄ́bleo fíti de à gbãna le gbasa à da zɛ́n. Akũ ò pì: Tↄ̀, ǹ kɛ lákũ n ò nà. ");
INSERT INTO bqp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Akũ à gɛ̀ɛ Sara kĩnaa kutan à pì: Ǹ flawa dã zaka lɛ́ aakↄ̃ ǹ burodi kɛ likalika. ");
INSERT INTO bqp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Akũ à bàa lɛ̀ à gɛ̃̀ a zùnↄ tɛ́ à zùnɛ bↄ̀rↄ mana kũ̀ à kpà a zĩkɛriia, akũ zĩkɛrii pìi gɛ̀ɛ à kɛ̀kɛ likalika. ");
INSERT INTO bqp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Akũ Ibrahĩ vĩfãani kũ vĩ'ipuo kũ zù kũ ò kɛ̀kɛɛ pìioo sɛ̀ à gɛ̀ɛ à dìtɛńnɛ. Gↄrↄ kũ òtɛn pↄ́ ble, api zɛ ń sarɛ lí gbáru gwe. ");
INSERT INTO bqp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Akũ ò a là ò pì: N nanↄ Sara kú mámɛɛ? À pì: À kú kutan gwe. ");
INSERT INTO bqp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Akũ Dikiri pì: Mani ɛra mà su n kĩnaa ziki mandara'i, n nanↄ Sara ni nɛ́ i gↄ̃gbɛ̃ ũ. Sara kú a kpɛ kuta kpɛ́lɛlɛa àtɛn ma. ");
INSERT INTO bqp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibrahĩ kũ Sarao zĩ kũ̀, Sara dì nↄgbɛ̃nↄ pↄ́ kɛ doro. Akũ Sara yáa dↄ̀ à pì a swɛ̃̀ɛ gũn: ");
INSERT INTO bqp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ma zĩ kũ̀, akũ ma dikiri zĩ kũ̀ dↄ. Mani pↄnna yã pì dↄ̃ dↄ yá? ");
INSERT INTO bqp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Akũ Dikiri Ibrahĩ là à pì: À kɛ̀ dera Sara yáa dↄ̀ↄ? À pì akũ kũ a zĩ kũ̀ áni fↄ̃ à nɛ́ i dↄ yá? ");
INSERT INTO bqp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yãke dìgↄ̃ zĩ'ũmɛnɛro. Ziki mandara'i tó a gↄrↄ kà, mani su n kĩnaa, gbasa Sara nɛ́ i gↄ̃gbɛ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Akũ Sara ledi kpà à pì ádi yáa dↄro, zaakũ vĩna a kũ̀. Akũ Dikiri pì: É'e! N yáa dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kũ gbɛ̃ pìnↄ fùtɛ, Ibrahĩ gɛ̀ɛ à zɛńnɛ, akũ ò Sↄdↄmu kpa gwà. ");
INSERT INTO bqp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Akũ Dikiri pì: Mani yã kũ má ye mà kɛ utɛ Ibrahĩnɛro. ");
INSERT INTO bqp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","A burinↄ nigↄ̃ zↄ̃kↄ̃ onigↄ̃ gbãna vĩ. Andunia buri sĩnda pínki ni arubarika le a gãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Zaakũ ma a sɛ̀, de à o a nɛ́nↄnɛ kũ a burinↄ a gbɛra ògↄ̃ ma yã kũna ò yã mana zɛ́de kɛ, de mà yã kũ ma a lɛ́ sɛ̀nɛ kɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Akũ Dikiri ɛ̀ra à pì: Yã kũ òtɛn o Sↄdↄmu kũ Gↄmↄrao musu dasi, ń durunna gɛ̃̀ ↄla. ");
INSERT INTO bqp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mani gɛ́ gwe sà mà gwa, tó yã kũ òtɛn kɛ vãni lákũ ma mà nà. Tó ò de lɛ sↄ̃ro, mani dↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kũ ń gbɛ̃nↄn pla pìnↄ dà zɛ́n òtɛn gɛ́ Sↄdↄmu, akũ Dikiri gↄ̃̀ kũ Ibrahĩo gwe. ");
INSERT INTO bqp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Akũ Ibrahĩ nài à pì: Ĩni gbɛ̃ mananↄ wara lɛɛlɛ kũ gbɛ̃ vãninↄn yá? ");
INSERT INTO bqp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tó gbɛ̃ mananↄn kú wɛ̃tɛ pìi gũn ò kà gbɛ̃nↄn bupla akuri, ĩni ń waran yá? Ĩni sùru kɛ kũ wɛ̃tɛ pìio gbɛ̃ mana gbɛ̃nↄn bupla akurii pìnↄ yãiroo? ");
INSERT INTO bqp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ǹ sùru kɛ! Ǹsun kɛ lɛro. Ǹsun gbɛ̃ mananↄ dɛdɛ lɛɛlɛ kũ gbɛ̃ vãninↄro, zaakũ ò dokↄ̃nↄro. Ǹ sùru kɛ! Ǹsun kɛ lɛro. Mↄkↄ̃n kũ ń de andunia pínki yãkpatɛkɛri ũ, ĩni yã kɛ a zɛ́aroo? ");
INSERT INTO bqp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Akũ Dikiri pì: Tó ma gbɛ̃ mananↄ è Sↄdↄmu gbɛ̃nↄn bupla akuri, mani sùru kɛ kũ wɛ̃tɛ pìio ń yãi. ");
INSERT INTO bqp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Akũ Ibrahĩ ɛ̀ra à pì dↄ: Makũ kũ má de bùsutiti kũ túbuo ũ, ǹ gaafara kɛmɛnɛ mà yã onnɛ, Dikiri. ");
INSERT INTO bqp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tó gbɛ̃nↄn sↄↄro kĩ̀a gbɛ̃nↄn bupla akurii pìi gũn, gbɛ̃nↄn sↄↄro pìnↄ yãi ĩni wɛ̃tɛ pì kakatɛ yá? Akũ Dikiri pì: Tó ma gbɛ̃ mananↄ è gbɛ̃nↄn bupla awɛɛsↄↄro, mani wɛ̃tɛ pì kakatɛro. ");
INSERT INTO bqp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Akũ Ibrahĩ kpɛ́ àtɛn yã onɛ à pì: Tó gbɛ̃ mananↄ kà bupla sↄ̃ bi? Akũ Dikiri pì: Mani yãke kɛro gbɛ̃nↄn bupla pìnↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Akũ à pì: Dikiri, n yã nna! Ǹsun pↄ fɛ̃ro, má ye mà yã o dↄ. Tó gbɛ̃ mananↄ kà baraakuri sↄ̃ bi? À wèa à pì: Tó ma gbɛ̃ mananↄ è ò kà gbɛ̃nↄn baraakuri, mani yãke kɛro. ");
INSERT INTO bqp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Akũ à pì: Ǹ gaafara kɛmɛnɛ dↄ Dikiri, mà yã onnɛ. Tó gbɛ̃ mananↄ kà gbɛ̃nↄn baro sↄ̃ bi? À wèa à pì: Mani wɛ̃tɛ pì kakatɛro gbɛ̃nↄn baro pìnↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Akũ à pì: Dikiri, ǹsun pↄ fɛ̃ro, yã díkĩna baasi mani yã o doro. Tó gbɛ̃ mananↄ kà gbɛ̃nↄn kuri sↄ̃ bi? À wèa à pì: Mani wɛ̃tɛ pì kakatɛro gbɛ̃nↄn kurii pìnↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kũ Dikiri yã ò Ibrahĩnɛ à làka, à gɛ̃̀ zɛ́la, akũ Ibrahĩ ɛ̀ra à tà bɛ. ");
INSERT INTO bqp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kũ malaika gbɛ̃nↄn pla pìnↄ kà Sↄdↄmu ↄkↄsi, Lutu vutɛna Sↄdↄmu bĩni kpɛ́lɛlɛa. Kũ à ń é, à fùtɛ à gɛ̀ɛ à dàńlɛ à kùtɛńnɛ à wùtɛ a nɛ̀sɛlɛ kutɛna ");
INSERT INTO bqp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","à pì: Ma dikirinↄ, á yã nna! À mↄ́ à gɛ́ kipa makũ á zↄ̀bleri bɛa. À zú o à i la, zia kↄnkↄ káakukaaku á da zɛ́n. Ò pì: Oi, óni i gãnulɛamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lutu nàkaraḿma manamana, akũ ò gɛ̃̀ a kpɛ́n. À ń yàrii kɛ̀ manamana à masaa kɛ̀ńnɛ, akũ ò sò. ");
INSERT INTO bqp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ari ògↄ̃ gɛ́ wútɛ, Sↄdↄmudenↄ lìka Lutu kpɛ́i. Wɛ̃tɛ pì gↄ̃gbɛ̃nↄ kàkara gwe mámmam, kɛfɛnnanↄ kũ gbɛ̃ zↄ̃kↄ̃nↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ò lɛ́ zù Lutui ò pì: Gↄ̃gbɛ̃ kũ ò kìpa n bɛa ↄkↄsialanↄn kú máa? Ǹ bↄtɛ kũńwowɛrɛ, ò pãpã kɛ kũńwo. ");
INSERT INTO bqp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu bò à zɛ̀ kpɛ́lɛlɛa ń kĩnaa, à gbàa tàta kũ kpɛo ");
INSERT INTO bqp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","à pì: Á'a ma gbɛ̃nↄ, àsun yã bɛ̃̀nɛ kɛro. ");
INSERT INTO bqp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Má nɛ́nↄgbɛ̃nↄ vĩ gbɛ̃nↄn pla kũ ò gↄ̃gbɛ̃ dↄ̃ro, mani ń bↄtɛárɛ. Lákũ á yei nà à kɛ kũńwo, ama àsun yãke kɛ gↄ̃gbɛ̃ díkĩnanↄnɛro, zaakũ ò kìpa ma bɛamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ò pìnɛ: Ǹ gowɛrɛ gwe! Akũ ò pì dↄ: Gbɛ̃ dí bi gbɛ̃ zĩ̀tↄↄmɛ, akũ à ye à kɛ ó yãkpatɛkɛri ũ. Óni yã vãni kɛnnɛ de ń pↄ́la. Akũ ò kùsia kũ gbãnao, òtɛn su kpɛ́ gbàa gboro. ");
INSERT INTO bqp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Akũ gbɛ̃nↄn pla pìnↄ ↄ bò ò Lutu kũ̀ ò gɛ̃̀ kãao kpɛ́n, akũ ò zɛ́ tàta. ");
INSERT INTO bqp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ò tò vĩ̀na gbɛ̃ kũ ò kú kpɛ arɛnↄ kũ̀ ń pínki nɛ́ fíti gbɛ̃ zↄ̃kↄ̃, akũ òtɛn kpɛ́ gbà wɛtɛ ari ò kpàsa. ");
INSERT INTO bqp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Gbɛ̃nↄn pla pìnↄ pì Lutunɛ: Dí ń vĩ la dↄↄ? Nɛ́gↄ̃gbɛ̃nↄ, nɛ́nↄgbɛ̃nↄ, n nɛ́ anzurenↄ kũ gbɛ̃ kũ ò de n gbɛ̃ ũnↄ wɛ̃tɛ gũn ń pínki. Ǹ bↄtɛ kũńwo, ");
INSERT INTO bqp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","zaakũ o su ò gu dí kakatɛmɛ. Yã vãni kũ òtɛn o wɛ̃tɛpidenↄ musu gɛ̃̀ Dikiri sãn, akũ à ó zĩ ò wɛ̃tɛ pì kakatɛ. ");
INSERT INTO bqp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lutu bò à gɛ̀ɛ à ò a nɛ́nↄ anzurenↄnɛ à pì: À futɛ ò bↄtɛ, zaakũ Dikiri ni wɛ̃tɛ dí pì kakatɛ teramɛ. Akũ òtɛn da àtɛn fàai bomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kũ gu dↄ̀ malaikaa pìnↄ nàkara Lutua ò pì: Ǹ futɛ ǹ n nanↄ kũ n nɛ́nↄgbɛ̃ gbɛ̃nↄn pla dínↄ sɛ́tɛ ǹ bↄtɛ kũńwo la, de ǹsun ga wɛ̃tɛ pì kakatɛnaa gũnlo yãi. ");
INSERT INTO bqp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kũ Lutu tɛn sika kɛ, Dikiri a wɛ̃nda bò, akũ gbɛ̃nↄn pla pìnↄ a kũ̀ a ↄa kũ a nanↄo kũ a nɛ́nↄgbɛ̃ gbɛ̃nↄn planↄ, ò bↄ̀tɛ kũńwo wɛ̃tɛ kpɛ. ");
INSERT INTO bqp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kũ ò bↄ̀tɛ kũńwo lɛ, akũ malaikaa pìnↄ do pì Lutunɛ: Ǹ bàa lɛ́ ǹ n zĩda mì sí. Ǹsun kpɛ gwaro. Ǹsun zɛ guvutɛ pìi gũnlo. Ǹ bàa lɛ́ ǹ mì pɛ́ kpinↄa de ǹsun garo yãi. ");
INSERT INTO bqp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Akũ à pìńnɛ: Oi ma dikiri! N yã nna! ");
INSERT INTO bqp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Makũ n zↄ̀bleri ma n pↄnna lè, n gbɛ̃kɛ kɛ̀mɛnɛ manamana n ma mìi sì. Ama mani fↄ̃ mà bàa lɛ́ mà kpi pìnↄ kĩnaa lero. Ari màgↄ̃ gɛ́ ká gwe, kakatɛnaa pì ni ma le mà ga. ");
INSERT INTO bqp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ǹ lakutu ke gwa zã̀ dire. Lákũ à kãni nà, mani fↄ̃ mà bàa lɛ́ mà gɛ́ gwe. Lakutu fítimɛ sↄ̃. Ǹ tó mà bàa sí mà tá gwe, manigↄ̃ aafia. Asa à fítiroo? ");
INSERT INTO bqp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Akũ à pìnɛ: Ma n gba zɛ́, mani lakutu kũ ntɛn o pì kakatɛro. ");
INSERT INTO bqp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ǹ bàa lɛ́ ǹ tá gwe likalika, zaakũ mani yãke kɛ gĩaro ari ǹ gɛ́ káo gwe. A yã mɛ́ à tò, ò tↄ́ kpà lakutu pìinɛ Zoa. ");
INSERT INTO bqp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kũ Lutu Zoa lè, ifãntɛ̃ tɛn bo, ");
INSERT INTO bqp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","akũ Dikiri tò tɛ́ kũ ifãntɛ̃gbↄ̃ↄo bò musu à kà Sↄdↄmu kũ Gↄmↄraola. ");
INSERT INTO bqp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","À wɛ̃tɛ pìnↄ kàkatɛ kũ gbɛ̃nↄ kũ guvutɛ pìio kũ línↄ kũ sɛ̃̀nↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kũ Lutu nanↄ a kpɛ gwà, akũ à lì à gↄ̃̀ zɛna wisi gbɛ̀ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kũ gu dↄ̀, Ibrahĩ fùtɛ kↄnkↄkↄnkↄ, à gɛ̀ɛ gu kũ à kun yã kũ Dikirioo pìn. ");
INSERT INTO bqp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kũ à Sↄdↄmu kũ Gↄmↄrao kpa gwà kũ guvutɛ pìio pínki, à è túsukpɛ tɛn futɛ zĩtɛ lán tãmatɛ túsukpɛ bà. ");
INSERT INTO bqp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lɛmɛ kũ Luda guvutɛ kũ Lutu kunwa wɛ̃tɛnↄ kàkatɛ lɛ, Ibrahĩ yã dↄ̀n, akũ à Lutu bò wɛ̃tɛ kũ à kàkatɛ pìnↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kũ Lutu bò Zoa, à gɛ̀ɛ à vùtɛ kpinↄ tɛ́ kũ a nɛ́nↄgbɛ̃ gbɛ̃nↄn planↄ, kũ à kunna Zoa vĩna vĩ yãi. Akũ à gↄ̃̀ kú gbɛ̀wɛɛn kũ a nɛ́nↄgbɛ̃ pìnↄ. ");
INSERT INTO bqp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Akũ Yↄ̃ↄ pì Bãnanɛ: Ó de zĩ kũ̀, akũ gↄ̃gbɛ̃ ke kú bùsun à wútɛ kũoo lákũ òdi kɛ nàro. ");
INSERT INTO bqp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ǹ mↄ́ ò sèwɛ̃ kákanɛ ó wútɛ kãao, de ògↄ̃ ó buri le a gãi. ");
INSERT INTO bqp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Gwãani birea ò wɛ̃ kàkanɛ, akũ Yↄ̃ↄ gɛ̀ɛ à wùtɛ kãao. Lutu dí dↄ̃ gↄrↄ kũ à wùtɛ kãao ke gↄrↄ kũ à fùtɛro. ");
INSERT INTO bqp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kũ gu dↄ̀ Yↄ̃ↄ pì Bãnanɛ: Ma wutɛ kũ ma deo gĩa. Ò wɛ̃ kákanɛ ↄkↄsiala dↄ, ĩni gɛ́ ǹ wútɛ kãao, de ògↄ̃ ó buri le a gãi. ");
INSERT INTO bqp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Gwãani birea dↄ ò wɛ̃ kàkanɛ, akũ Bãna gɛ̀ɛ à wùtɛ kãao. Lutu dí dↄ̃ gↄrↄ kũ à wùtɛ kãao ke gↄrↄ kũ à fùtɛro. ");
INSERT INTO bqp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lɛmɛ Lutu nɛ́nↄgbɛ̃ gbɛ̃nↄn pla pìnↄ kɛ̀ lɛ ò nↄ̀ↄ sì kãao. ");
INSERT INTO bqp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yↄ̃ↄ nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à tↄ́ kpànɛ Mↄabu. Àkũmɛ Mↄabu buri kũ ò kun ari gbãranↄ dizi káaku ũ. ");
INSERT INTO bqp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Bãna nɛ́ ì gↄ̃gbɛ̃ ũ se, akũ à tↄ́ kpànɛ Aminɛ. Àkũmɛ Amↄni buri kũ ò kun ari gbãranↄ dizi káaku ũ. ");
INSERT INTO bqp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Akũ Ibrahĩ fùtɛ gwe à gɛ̀ɛ Nɛgɛvi bùsun Kadɛsi kũ Suruo dagura. Kũ à gɛ̀ɛ à vùtɛ Gera, ");
INSERT INTO bqp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","à pì a nanↄ Sara bi a dãremɛ, akũ Gera kína Abimɛlɛki gbɛ̃ zĩ̀ à a sɛ̀ à sù kãao. ");
INSERT INTO bqp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Akũ Luda bò à sù Abimɛlɛkia nana gũn gwãani à pìnɛ: Ĩni ga nↄ kũ n sɛ̀ɛ pì yãi, zaakũ nↄzãremɛ. ");
INSERT INTO bqp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","À sù à lè Abimɛlɛki dí wútɛ kãao kↄ̀ro, akũ à pì: Dikiri, ĩni buri kũ odi yãke kɛronↄ dɛdɛn yá? ");
INSERT INTO bqp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Àkũ mɛ́ à pìmɛnɛ a dãrenloo? Nↄgbɛ̃ pì sↄ̃ à pì a dãgↄ̃mɛ. Ma yã kɛ̀ a zɛ́amɛ, má taari vĩro. ");
INSERT INTO bqp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Akũ Luda pìnɛ nana pìi gũn: Ee, má dↄ̃ kũ n yã kɛ̀ a zɛ́amɛ. A yã mɛ́ à tò, ma kpannɛ ǹ durunna kɛmɛnɛ, mádi we n ↄ nà nↄgbɛ̃ pìiaro. ");
INSERT INTO bqp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tera sà, à gↄ̃gbɛ̃ pì nↄ kpáa, zaakũ annabiimɛ. Ani adua kɛnnɛ de ǹ gↄ̃ aafia. Tó ńdi a nↄ pì kpáa sↄ̃ro, ǹgↄ̃ dↄ̃ kũ n gamɛ, mↄkↄ̃n kũ n gbɛ̃nↄ á pínki. ");
INSERT INTO bqp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Akũ Abimɛlɛki fùtɛ kↄnkↄkↄnkↄ, à a gbɛ̃nↄ sìsi à yã pì bàbańnɛ ń pínki, akũ vĩna ń kũ manamana. ");
INSERT INTO bqp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Akũ Abimɛlɛki Ibrahĩ sìsi à pìnɛ: Bↄ́yãi n kɛ̀wɛrɛ lɛɛ? Bↄ́ taarin ma kɛ̀nnɛ gbasa n tò ma gↄ̃ durunnade ũ kũ ma bùsuuo? N yã kũ à de ò kɛro kɛ̀mɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Bↄ́ laasun n lɛ̀ gbasa n yã pìi kɛ̀ɛ? ");
INSERT INTO bqp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahĩ wèa à pì: Matɛn da yã gbɛ̃ke Luda vĩna vĩ bùsu díkĩna gũnlo, oni ma dɛ ma nanↄ yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Abire gbɛra nↄgbɛ̃ pì bi ma dãremɛ yãpura. Ó de dokↄ̃nↄmɛ, baadi kũ a dao, akũ à gↄ̃̀ ma nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kũ Luda ma bo ma de bɛa yã, matɛn likara, akũ ma pì ma nↄ pìinɛ gu kũ óni gɛ́n pínki, à gbɛ̃kɛ kɛmɛnɛ àgↄ̃ pi a dãgↄ̃n ma ũ. ");
INSERT INTO bqp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Akũ Abimɛlɛki sù kũ sãnↄ kũ zùnↄ kũ gↄ̃gbɛ̃ zĩkɛrinↄ kũ nↄgbɛ̃ zĩkɛrinↄ à kpà Ibrahĩa, akũ à a nanↄ ɛ̀ranɛ. ");
INSERT INTO bqp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Akũ Abimɛlɛki pì: Ma bùsun dí, ǹ vutɛ gu kũ ń yein. ");
INSERT INTO bqp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Akũ à pì Saranɛ: Ma andurufu ↄgↄ wàa sↄↄro kpà n dãgↄ̃a kútɛkɛbↄ ũ, de gbɛ̃ kũ ò kú kũnwonↄ dↄ̃ ń pínki kũ ńdi taari kɛro. ");
INSERT INTO bqp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Akũ Ibrahĩ wɛ́ kɛ̀ Ludaa, akũ Luda Abimɛlɛki gbà aafia kũ a nanↄo kũ a nↄ yìgisaridenↄ, de ò nɛ́ i, ");
INSERT INTO bqp_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","zaakũ Dikiri tò Abimɛlɛki bɛ nↄgbɛ̃nↄ para kũ̀ yã Ibrahĩ nanↄ yã musu. ");
INSERT INTO bqp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Dikiri arubarikaa dà Saragu lákũ à ò nà, à kɛ̀nɛ lákũ à lɛ́ sɛ̀nɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Akũ à nↄ̀ↄ sì à nɛ́ ì kũ Ibrahĩo gↄ̃gbɛ̃ ũ a zĩkũnaa gũn gↄrↄ kũ Luda dìtɛnɛɛa. ");
INSERT INTO bqp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahĩ tↄ́ kpà nɛ́ pìinɛ Isaaku. ");
INSERT INTO bqp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","À tↄ̃̀ↄ zↄ̃̀nɛ a gↄrↄ sↄraakↄ̃de zĩ lákũ Luda dìtɛnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","À kà wɛ̃̀ basↄↄro a nɛ́ pì igↄrↄa. ");
INSERT INTO bqp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Akũ Sara pì: Luda yáadↄyã kɛ̀mɛnɛ, gbɛ̃ kũ à mà pínki ni yáa dↄ kũmao. ");
INSERT INTO bqp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","À pì dↄ: Oni we ò pi Ibrahĩnɛ yã mani gↄ̃ nɛ́rande ũ yá? Akũ ma nɛ́gↄ̃gbɛ̃ ì kãao a zĩkũnaa gũn. ");
INSERT INTO bqp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kũ nɛ́ pì zↄ̃kↄ̃ kũ̀ à kɛ̃̀ yↄ̃a, akũ Ibrahĩ a kɛ̃na yↄ̃a pↄnna kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara è nɛ́ kũ Misila nↄgbɛ̃ Hazara ì kũ Ibrahĩo dìgↄ̃ Isaaku yáa dↄmɛ, ");
INSERT INTO bqp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","akũ à pì Ibrahĩnɛ: Ǹ pɛ́ zↄ̀ↄ pìia kũ a nɛ́o, zaakũ zↄ̀ nɛ́ pì ni túbi ble kũ ma nɛ́ Isaakuoro. ");
INSERT INTO bqp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yã pìi Ibrahĩ pↄ yàka manamana, zaakũ a nɛ́mɛ, ");
INSERT INTO bqp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","akũ Luda pìnɛ: Ǹsun tó n pↄ yaka n nɛ́ kũ n zↄ̀nↄgbɛ̃ pìio yã musuro. Yã kũ Sara tɛn onnɛ pínki ǹ ma, zaakũ Isaaku burinↄn onigↄ̃ pińnɛ n burinↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mani tó zↄ̀ nɛ́ pìi buri kɛ se, zaakũ n nɛ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Akũ Ibrahĩ fùtɛ kↄnkↄkↄnkↄ, à pↄ́ble sɛ̀ kũ í tùruuo à kpà Hazaraa. À dìnɛ, akũ à a nɛ́ kpàa dↄ. À a gbàrɛ, akũ à gɛ̀ɛ àtɛn likara zↄ̃ Bɛsɛba gbárannan. ");
INSERT INTO bqp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kũ í làkaḿma, à kɛfɛnna pìi tò lí gbáru, ");
INSERT INTO bqp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","akũ à gɛ̀ɛ à vùtɛ arɛ kàzulɛtɛki zã̀ lɛ́n, zaakũ à pì á ye à a nɛ́ gana ero. Kũ à gɛ̀ɛ à vùtɛ zã̀ lɛ, akũ à nà ↄ́ↄdↄnaaa. ");
INSERT INTO bqp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Luda kɛfɛnna pì ↄ́ↄ dↄ mà, akũ Luda Malaika lɛ́ zù Hazarai zaa musu à pì: Bↄ́ mɛ́ à n lee Hazara? Ǹsun vĩna kɛro, zaakũ Luda nɛ́ pì ↄ́ↄ dↄ mà gu kũ à kunwa. ");
INSERT INTO bqp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ǹ futɛ ǹ n nɛ́ pì sɛ́ ǹ a kũ a ↄa, zaakũ mani tó à gↄ̃ buri zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Luda nↄgbɛ̃ pì wɛ́ kɛ̃̀nɛ, akũ à lↄ̀gↄↄ è. À gɛ̀ɛ à í tↄ̀ a tùru pa, akũ à sù à kpà a nɛ́ pìia à mì. ");
INSERT INTO bqp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Luda kú kũ nɛ́ pìio ari à zↄ̃kↄ̃ kũ̀. Àdigↄ̃ kú gbárannan, akũ à gↄ̃̀ tofekari ũ. ");
INSERT INTO bqp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Gↄrↄ kũ à kú Parani gbáranna pìi gũnn a da Misila bùsu nↄ sɛ̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Gↄrↄ birea Abimɛlɛki kũ a zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Fikↄluo gɛ̀ɛ Ibrahĩ kĩnaa ò pìnɛ: Luda kú kũnwo yã kũ ntɛn kɛ gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ǹ la damɛnɛ la gↄ̃̀nↄ ǹ sì kũ Ludao kũ ĩni bo ma kpɛro ke ma nɛ́nↄ ke ma burinↄ. Lákũ ma gbɛ̃kɛ kɛ̀nnɛ nà, ǹ kɛmɛnɛ lɛ kũ bùsu kũ ń kú a gũn gbɛ̃ zĩ̀tↄ ũo. ");
INSERT INTO bqp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Akũ Ibrahĩ pìnɛ: Ma la dànnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Akũ Ibrahĩ lↄ̀gↄ kũ Abimɛlɛki gbɛ̃nↄ sìa yã sɛ̀tɛ à ònɛ. ");
INSERT INTO bqp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimɛlɛki pì: Má gbɛ̃ kũ ò yã bire kɛ̀nↄ dↄ̃ro, ńdi omɛnɛ yãro, gbãran ma mà. ");
INSERT INTO bqp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Akũ Ibrahĩ sãnↄ kũ zùnↄ kũ̀ à kpà Abimɛlɛkia, akũ ò lɛ́dokↄ̃nↄ kɛ̀ kũ kↄ̃o. ");
INSERT INTO bqp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Akũ Ibrahĩ sãnunu mɛ̀n supplanↄ bò à kàtɛ ńdona. ");
INSERT INTO bqp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimɛlɛki a là à pì: Sã mɛ̀n suppla kũ n ń kátɛ ńdona pìnↄ yã de deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Akũ à wèa à pì: Ǹ sã mɛ̀n suppla pìnↄ sí sèeda ũ kũ makũ mɛ́ ma lↄ̀gↄↄ pìi yↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","A yã mɛ́ à tò ò tↄ́ kpà gu pìinɛ Bɛsɛba, zaakũ gwen ò la dànkↄ̃nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Lɛn ò lɛ́dokↄ̃nↄ kɛ̀ Bɛsɛba lɛ, akũ Abimɛlɛki kũ a zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Fikↄluo ɛ̀ra ò tà Filisitini bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahĩ sãma lí tↄ̃̀ Bɛsɛba, akũ à Dikiri Luda Gↄrↄsĩndapinkide sìsi gwe. ");
INSERT INTO bqp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Akũ à gↄrↄ pla kɛ̀ Filisitini bùsuu pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Abire gbɛra Luda Ibrahĩ yↄ̃̀ à gwà à pìnɛ: Ibrahĩ! Akũ à wèa à pì: Makũ di! ");
INSERT INTO bqp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Akũ Luda pìnɛ: Ǹ n nɛ́ mɛ̀n do kũ ń yei Isaaku sɛ́ ǹ gɛ́o Mↄria bùsun, ǹ sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ o kãao kpi kũ mani onnɛa. ");
INSERT INTO bqp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kũ à fùtɛ kↄnkↄkↄnkↄ, à gàarii yĩ̀ a zaakinɛ, akũ à a zĩkɛrinↄ sɛ̀ gbɛ̃nↄn pla kũ a nɛ́ Isaaku pìio. À sa'oyakaa pàra, akũ à dà zɛ́n, àtɛn gɛ́ gu kũ Luda ònɛn. ");
INSERT INTO bqp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","A gↄrↄ aakↄ̃de zĩ kũ à wɛ́ sɛ̀, à gu pìi è zãa. ");
INSERT INTO bqp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Akũ à pì a zĩkɛri pìnↄnɛ: À gↄ̃ kũ zaakio la. Makũ kũ kɛfɛnna dio óni gɛ́ arɛ ò donyĩ kɛ Ludanɛ, óni ɛra ò su ò á le la. ");
INSERT INTO bqp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahĩ sa'oyakaa sɛ̀ à dì a nɛ́ pìinɛ, akũ à tɛ́ kũna kũ fɛ̃nɛo, òtɛn gɛ́ lɛɛlɛ. ");
INSERT INTO bqp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Akũ Isaaku yã ò a denɛ à pì: Baa! À wèa à pì: Bↄ́mɛ nɛ́? Akũ à pìnɛ: Ó tɛ́ kũna kũ yàkaao, sãnɛ bↄ̀rↄ kũ óni ká tɛ́n à tɛ́ kũ kú mámɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Akũ Ibrahĩ pì: Ma nɛ́, Luda mɛ́ ani sa'osã kpá. Akũ ò tɛ́kↄ̃i òtɛn gɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kũ ò kà gu kũ Luda ònɛn, à sa'oki bò gwe à yàkaa kpàkpaala, akũ à a nɛ́ pìi yĩ̀ à dì yàkaa pìia sa'oki musu. ");
INSERT INTO bqp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kũ à fɛ̃nɛ sɛ̀ à ↄ bò de à a nɛ́ pìi kùtu kpá, ");
INSERT INTO bqp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","akũ Dikiri Malaika lɛ́ zùi zaa musu à pì: Ibrahĩ! Ibrahĩ! À wèa à pì: Makũ di! ");
INSERT INTO bqp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Akũ à pì: Ǹsun ↄ na nɛ́ pìiaro ǹsun yãke kɛnɛro. Má dↄ̃ sà kũ ń ma vĩna vĩ, ńdi gímɛnɛ kũ n nɛ́ mɛ̀n dooro. ");
INSERT INTO bqp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahĩ wɛ́ sɛ̀, akũ à sãkaroo è líwaka kà a bɛ̃nɛi. Akũ à gɛ̀ɛ à a kũ̀ à sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ òo a nɛ́ gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Akũ à tↄ́ kpà gu pìinɛ Dikirinikpa, akũ òdigↄ̃ o ari kũ a gbãrao òdi pi: Dikiri ni kpá a kpi musu. ");
INSERT INTO bqp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Dikiri Malaikaa ɛ̀ra à lɛ́ zù Ibrahĩi zaa musu dↄ ");
INSERT INTO bqp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","à pì: Makũ Dikiri ma la dà kũ ma kunnaao ma pì, lákũ n yã pìi kɛ̀ nà, ńdi gí kũ n nɛ́ mɛ̀n dooro, ");
INSERT INTO bqp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mani arubarika dangu mà n buri karannɛ lán susunɛnↄ bà, onigↄ̃ dasi lán ísiralɛ bùsu'atɛ̃ bà. N burinↄ nigↄ̃ gbãna vĩ n ibɛrɛnↄa. ");
INSERT INTO bqp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mani arubarika da andunia buri sĩnda pínkigu n buri gãi, kũ n ma yã mà yãi. ");
INSERT INTO bqp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kũ Ibrahĩ ɛ̀ra à sù a zĩkɛrinↄ kĩnaa, ò fùtɛ ò tà Bɛsɛba, akũ à gↄrↄ pla kɛ̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Abire gbɛra ò ò Ibrahĩnɛ ò pì: N vĩ̀ni Nao nanↄ Milika nɛ́gↄ̃gbɛ̃nↄ ì. ");
INSERT INTO bqp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A daudu tↄ́n Uzu. A dakũnanↄ tↄ́n dí: Buzu, Aramu de Kɛmuɛli, ");
INSERT INTO bqp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kɛsɛdi, Azo, Pilidasa, Yidilafa kũ Bɛtuɛlio. ");
INSERT INTO bqp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bɛtuɛli pì mɛ́ à Rɛbɛka ì. Nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn sↄraakↄ̃ kũ Milika ì kũ Ibrahĩ vĩ̀ni Naon gwe. ");
INSERT INTO bqp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","A nↄ danyĩ Ruma nɛ́nↄ tↄ́n dí: Teba, Gaamu, Tasa kũ Maakao. ");
INSERT INTO bqp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara kɛ̀ wɛ̃̀ basuddo awɛɛsuppla, ");
INSERT INTO bqp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","gbasa à gà zaa Kiriataba kũ òdi pi tera Ɛblↄnu, Kanaanↄ bùsun. Akũ Ibrahĩ a wɛ̃nda kɛ̀ à ↄ́ↄ dↄ̀ a gana yã musu. ");
INSERT INTO bqp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kũ à gò a nanↄ gɛ̀ kĩnaa, à gɛ̀ɛ à pì Iti burinↄnɛ: ");
INSERT INTO bqp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Nibↄ kũ gbɛ̃ zĩ̀tↄↄon ma ũ á tɛ́. À zĩtɛ yíama ma gɛ̀vĩki ũ mà gɛ̀ vĩn. ");
INSERT INTO bqp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Akũ Iti burinↄ pìnɛ: ");
INSERT INTO bqp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Mare, ǹ ó yã ma. Luda gbɛ̃ arubarikademɛ n ũ ó tɛ́. Ǹ n gɛ̀ vĩ gbɛ̀wɛɛ kũ à kɛ̀nnɛ mana gũn. Ó gbɛ̃ke ni n tɛ̃ gbɛ̀wɛɛ kũ ĩni n gɛ̀ vĩ a gũnlo. ");
INSERT INTO bqp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Akũ Ibrahĩ fùtɛ à kùtɛ bùsupidenↄnɛ ");
INSERT INTO bqp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","à pìńnɛ: À ma yã ma, tó a we mà a gɛ̀ vĩ la. À wɛ́ kɛmɛnɛ Zoa nɛ́ Ɛflↄnua ");
INSERT INTO bqp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","à Makpɛla gbɛ̀wɛɛ kũ à kú a bú lɛ́i yíama a ↄgↄa, ani gↄ̃ ma gɛ̀vĩki ũ á bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ɛflↄnu vutɛna ń tɛ́ a wɛ̃tɛ bĩnilɛa gwe, akũ à ò Ibrahĩnɛ Itinↄ wára ń pínki à pì: ");
INSERT INTO bqp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Oi mare, ǹ ma yã ma. Ma n gba bura pì kũ gbɛ̀wɛɛ kũ à kú gweo. Ma n gba ma gbɛ̃nↄ wára. Ma n gbamɛ, de ǹ n gɛ̀ vĩn. ");
INSERT INTO bqp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrahĩ kùtɛ bùsupidenↄnɛ, ");
INSERT INTO bqp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","akũ à pì Ɛflↄnunɛ ń pínki wára: Ǹ sã kpá ǹ ma yã ma. Mani bura pì fĩna bonnɛ. Ǹ ma ↄgↄ sí, mani ma gɛ̀ vĩn. ");
INSERT INTO bqp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Akũ Ɛflↄnu pìnɛ: ");
INSERT INTO bqp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mare, ǹ ma yã ma. Zĩtɛ kũ a ↄgↄ kà andurufu wàa plamɛ, bↄ́n abire ũ ó daguraa? Ǹ n gɛ̀ vĩn. ");
INSERT INTO bqp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahĩ a yã mà, akũ à andurufu kũ à òo yↄ̃̀nɛ gbɛ̃nↄ wára lagatarinↄ zakaaa. ");
INSERT INTO bqp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Lɛmɛ Ɛflↄnu bú kũ à kú Makpɛla, Mamare sarɛ, gↄ̃̀ Ibrahĩ pↄ́ ũ lɛ kũ gbɛ̀wɛɛ kũ à kú gweo kũ lí kũ ò kú gwenↄ zaa bú pì lɛ́i pínki. ");
INSERT INTO bqp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","À gↄ̃̀ Ibrahĩ pↄ́ ũ Iti kũ ò sù wɛ̃tɛ bĩnilɛanↄ pínki wára. ");
INSERT INTO bqp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Abire gbɛra Ibrahĩ a nanↄ vĩ̀ Makpɛla bura gbɛ̀wɛɛ pìi gũn Mamare kũ òdi pi tera Ɛblↄnu sarɛ, Kanaanↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Lɛn bú kũ gbɛ̀wɛɛ kũ à de Itinↄ pↄ́ ũ yãoo gↄ̃̀ Ibrahĩnɛ gɛ̀vĩki ũ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahĩ zĩ kũ̀ a gↄrↄnↄ kà zã̀, akũ Dikiri arubarikaa dàagu yã sĩnda pínki gũn. ");
INSERT INTO bqp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Akũ à ò a zĩkɛrinↄ gbɛ̃ zↄ̃kↄ̃ kũ à de a pↄ́ sĩnda pínki yãgↄ̃gↄ̃ri ũnɛ à pì: Ǹ ↄ sↄtↄ ma gbáda gbáru, ");
INSERT INTO bqp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","mani tó ǹ la da kũ Dikiri, musu kũ zĩtɛo Luda tↄ́o kũ ĩni Kanaa kũ má kú ń tɛ́nↄ nↄ sɛ́ ma nɛ́nɛro. ");
INSERT INTO bqp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ǹ gɛ́ ma bɛ bùsun ma danɛnↄ gũn, ǹ nↄ sɛ́ ma nɛ́nɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Akũ a zĩkɛrii pì a là à pì: Tó nↄgbɛ̃ pì dí we à tɛ̀mai à sù kũmao bùsu díkĩnan sↄ̃ro bi? Mani gɛ́ kũ n nɛ́o bùsu kũ n bonn yá? ");
INSERT INTO bqp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahĩ pìnɛ: Ǹ laakari kɛ! Ǹsun gɛ́ kũ ma nɛ́o gwero. ");
INSERT INTO bqp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Dikiri Luda Musude ma bo ma de bɛa ma danɛnↄ bùsun, akũ à yã òmɛnɛ à la dà à pì, áni bùsu díkĩna kpá ma burinↄamɛ. Àkũ mɛ́ ani a Malaika zĩ à donnɛ arɛ. Gwen ĩni nↄ sɛ́n ma nɛ́nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tó nↄgbɛ̃ pì dí we à tɛ̀nyĩro, n bo ladana kũ n la dàmɛnɛ dí gũn. Ǹsun gɛ́ gwe kũ ma nɛ́oro fá! ");
INSERT INTO bqp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Akũ a zĩkɛrii pì a ↄ sↄ̀tↄ a dikiri gbáda gbáru, à la dànɛ yã pìi musu. ");
INSERT INTO bqp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Zĩkɛrii pì a dikiri lakuminↄ sɛ̀ mɛ̀n kuri kũ a dikiri aruzɛkɛ buri pínkio, akũ à fùtɛ à gɛ̀ɛ Nao bɛ wɛ̃tɛn zaa Siria Mɛsↄpↄtamia bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kũ à kà gwe, à tò lakuminↄ kámma bò lↄ̀gↄↄ sarɛ wɛ̃tɛ kpɛ. Kũ ↄkↄsi kɛ̀, gↄrↄ kũ nↄgbɛ̃nↄ dì bↄtɛ í tↄ́, ");
INSERT INTO bqp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","akũ à adua kɛ̀ à pì: Dikiri, ma dikiri Ibrahĩ Luda, ǹ gbɛ̃kɛ kɛ ma dikiriinɛ ǹ tó ma tá kɛ nna ↄkↄsiala. ");
INSERT INTO bqp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ǹ gwa, má zɛna lↄ̀gↄↄ sarɛ. Tó wɛ̃tɛ nↄkparenↄ bↄ̀tɛ í tↄ́, ");
INSERT INTO bqp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","nↄkpare kũ ma ònɛ à a lo kipa à í tↄ́mɛnɛ mà mi, tó à pìmɛnɛ mà mi, akũ à kpà ma lakuminↄa dↄ, de mani dↄ̃ kũ n gbɛ̃kɛ kɛ̀ ma dikiriinɛ, nↄgbɛ̃ kũ n dìtɛ n zↄ̀bleri Isaaku pↄ́ ũn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Adi yã pì o à làkaro, akũ Bɛtuɛli nɛ́ Rɛbɛka bò kũ loo dina a gã̀n. Bɛtuɛli bi Ibrahĩ vĩ̀ni Nao nɛ́ kũ à ì kũ a nanↄ Milikaomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nɛ́ pì mana akũsↄ̃ à bũnumɛ, gↄ̃gbɛ̃ ke dí wutɛ kãao zikiro. À sù lↄ̀gↄ kĩnaa, à í tↄ̀ à a lo pà, akũ à ɛ̀ra àtɛn tá. ");
INSERT INTO bqp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Akũ zĩkɛrii pìi bàa lɛ̀ à gɛ̀ɛ à zɛ́ zↄ̃̀nɛ à pì: Ǹ ma gba í mà mi, bee fíti. ");
INSERT INTO bqp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nↄgbɛ̃ pìi pì: Ǹ mi Baa! Akũ à a lo kìpa gↄ̃̀nↄ, à í kpàa à mì. ");
INSERT INTO bqp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kũ à í kpàa à mì à làka, à pì: Mani tↄ́ n lakuminↄnɛ dↄ, ò mi ari ò kã. ");
INSERT INTO bqp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Akũ à a lo í kà pↄ́nↄ ímibↄn gↄ̃̀nↄ, à ɛ̀ra à bàa lɛ̀ à gɛ̀ɛ à í tↄ́ lↄ̀gↄn, akũ à í tↄ̀ lakuminↄnɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Gↄ̃gbɛ̃ pì zɛna àtɛni a gwa tíii, de à le à dↄ̃ tó Dikiri ni tó a tá kɛ nna, ke ani kɛ nnaro. ");
INSERT INTO bqp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kũ lakuminↄ í mì ò làka, akũ gↄ̃gbɛ̃ pì wura tãnka mana dà nↄ pìinɛ a yĩa, à wura zã dànɛ mɛ̀n pla. Tãnka pìi tìkisii kà giramu sↄↄro, zã pìnↄ sↄ̃ giramu basↄsↄↄro. ");
INSERT INTO bqp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Akũ à a là à pì: Ǹ omɛnɛ, dí nɛ́mɛ n ũu? Óni iki e n de bɛa yá? ");
INSERT INTO bqp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Akũ à wèa à pì: Bɛtuɛli nɛ́n ma ũ, Milika kũ Nao daikore. ");
INSERT INTO bqp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sɛ̃̀ kũ tàragaao din ó bɛa, akũ iki kun dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Akũ gↄ̃gbɛ̃ pìi kùtɛ à donyĩ kɛ̀ Dikirinɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Dikiri ma dikiri Ibrahĩ Luda arubarika vĩ kũ adi gí gbɛ̃kɛ kũ náanio yã kɛnɛro yãi. Makũ sↄ̃, Dikiri dòmɛnɛ arɛ ma dikiri danɛnↄ bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Akũ nↄkpare pìi bàa lɛ̀ à gɛ̀ɛ à yã pì gbã̀ a ↄndenↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rɛbɛka pì dãgↄ̃ vĩ kũ òdi pinɛ Labã. À bò wɛ̃tɛ kpɛ kũ bàao à gɛ̀ɛ à gↄ̃gbɛ̃ pìi lè lↄ̀gↄ lɛ́a, ");
INSERT INTO bqp_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","zaakũ à è a dãre tãnka kũ zão dana, akũ à yã kũ gↄ̃gbɛ̃ pìi ònɛɛ mà. Kũ à gɛ̀ɛ à a lè kũ lakuminↄ lↄ̀gↄ lɛ́a, ");
INSERT INTO bqp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","à pì: Ǹ mↄ́ mↄkↄ̃n kũ Dikiri arubarikaa dàngu! À kɛ̀ dera ń zɛna wɛ̃tɛ kpɛɛ? Ma kpɛ́ kɛ̀kɛnnɛ kũ lakuminↄ bàdↄkio. ");
INSERT INTO bqp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Gↄ̃gbɛ̃ pìi gɛ̃̀ ↄnn, akũ Labã lakuminↄ aso pòro à sɛ̃̀la kori kũ tàragaao kpàḿma à í kpà gↄ̃gbɛ̃ pìia à a gbá pípio kũ a gbɛ̃nↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ò pↄ́ble dìtɛnɛ, akũ à pì: Mani pↄ́ ble gĩaro ari mà yã kũ ma suo o. Akũ Labã pì: Ǹ o. ");
INSERT INTO bqp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Akũ à pì: Ibrahĩ zĩkɛriimɛ ma ũ. ");
INSERT INTO bqp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Dikiri arubarikaa dà ma dikiriinɛ manamana, akũ à gↄ̃̀ aruzɛkɛde ũ. À a gbà sãnↄ kũ zùnↄ kũ andurufuuo kũ wuraao kũ gↄ̃gbɛ̃ zĩkɛrinↄ kũ nↄgbɛ̃ zĩkɛrinↄ kũ lakuminↄ kũ zaakinↄ. ");
INSERT INTO bqp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ma dikirii pì nanↄ Sara nɛ́ ì gↄ̃gbɛ̃ ũ a zĩkũnaa gũn, akũ ma dikiri pↄ́ kũ à vĩ kpà nɛ́ pìia pínki. ");
INSERT INTO bqp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ma dikirii tò ma la dà, zaakũ à pì màsun Kanaa kũ à kú ń tɛ́nↄ nↄ sɛ́ a nɛ́nɛro. ");
INSERT INTO bqp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","À pì mà gɛ́ a de bɛa a buri gũn mà nↄ sɛ́ a nɛ́nɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Akũ ma a dikirii là ma pì, tó nↄgbɛ̃ pì dí we à tɛ́mai sↄ̃ro bi? ");
INSERT INTO bqp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","À wèma à pì, Dikiri kũ a táa ò kãao mɛ́ ani a Malaika zĩ à gɛ́ zɛmɛnɛ, de ma tá kɛ nna, mani nↄ sɛ́ a nɛ́nɛ a de bɛ danɛnↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","À pì tó ma gɛ a buri kĩnaa, tó odi wero, mani bo ladana kũ ma la dàarɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kũ ma ka lↄ̀gↄ kĩnaa gbãra ma pì: Dikiri, ma dikiri Ibrahĩ Luda, tó n we, ǹ tó ma tá kɛ nna. ");
INSERT INTO bqp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Má kú lↄ̀gↄ lɛ́a. Nↄkpare kũ à sù í tↄ́, akũ ma pìnɛ à ma gba í fíti mà mi, ");
INSERT INTO bqp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","tó à pì mà mi, akũ à tↄ̀ ma lakuminↄnɛ dↄ, mani dↄ̃ kũ nↄkpare kũ n dìtɛ à kɛ ma dikiri nɛ́ pↄ́ ũn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ari màgↄ̃ yã pì o ma nɛ̀sɛɛ gũn mà láka, akũ Rɛbɛka bò kũ loo dina a gã̀n à sù lↄ̀gↄ lɛ́a à í tↄ̀. Akũ ma pìnɛ à ma gba í mà mi. ");
INSERT INTO bqp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","À a lo kìpa gↄ̃̀nↄ, à pì mà mi áni kpá ma lakuminↄa dↄ. Kũ ma mì, akũ à kpà ma lakuminↄa. ");
INSERT INTO bqp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Akũ ma a la, dí nɛ́n a ũu? À pì Bɛtuɛli nɛ́n a ũ, Milika kũ Nao daikore. Akũ ma tãnka dànɛ a yĩa, ma zã dànɛ a ↄnↄa. ");
INSERT INTO bqp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Akũ ma kutɛ ma donyĩ kɛ̀ Dikiri ma dikiri Ibrahĩ Ludanɛ ma sáabu kpàa, zaakũ à dòmɛnɛ arɛ zɛ́ súsu gũn, de mà a dikiri vĩ̀ni daikore sɛ́ a nɛ́nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tera sà tó áni we à gbɛ̃kɛ kũ náanio yã kɛ ma dikiriinɛ, à omɛnɛ. Tó ádi we sↄ̃ro, à omɛnɛ, mani gɛ́ gu pãndea. ");
INSERT INTO bqp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labã kũ Bɛtuɛlio wèa ò pì: Yã pìi bò Dikiri kĩnaamɛ, ó yãke ona vĩro, a mana ke a vãni. ");
INSERT INTO bqp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rɛbɛkan dí, ǹ a sɛ́ ǹ tá kãao, à gↄ̃ n dikiri nɛ́ nanↄ ũ lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kũ Ibrahĩ zĩkɛrii pì ń yã mà, à wùtɛ zĩtɛ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Akũ à nↄmanablebↄ kũ ò kɛ̀ kũ andurufuuo kũ wuraao kũ pↄ́kasanↄ bↄ̀tɛ à kpà Rɛbɛkaa. À a vĩ̀ni kũ a daoo gbà pↄ́ ↄgↄdenↄ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Akũ àpii kũ gbɛ̃ kũ ò kú kãaonↄ pↄ́ blè ò í mì, akũ ò ì gwe. Kũ ò fùtɛ kↄnkↄ à pì: À ma gbarɛ mà tá ma dikiri kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nↄ vĩ̀ni kũ a dao pì: Ǹ tó nɛ́ pì gↄ̃ kũoo bee gↄrↄ kuri, á gbasa à tá. ");
INSERT INTO bqp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Akũ gↄ̃gbɛ̃ pìi pìńnɛ: Lákũ Dikiri ma tá kɛ̀ nna nà lán dí bà, àsun ma dãdã doro. À ma gbarɛ mà tá ma dikiri kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Akũ ò pì: Ò nɛ́ pì sísi ò a la. ");
INSERT INTO bqp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Akũ ò Rɛbɛka sìsi ò a là ò pì: Ĩni tá kũ gbɛ̃ pìio yá? Akũ Rɛbɛka pì: Mani tá kãao. ");
INSERT INTO bqp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Akũ ò Rɛbɛka gbàrɛ kũ a gwàri kũ à a gwà zaa a fítinna zĩo, òtɛn tá kũ Ibrahĩ zĩkɛriio kũ a gbɛ̃nↄ. ");
INSERT INTO bqp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ò sa mana ò Rɛbɛkanɛ ò pì: Nɛ́, Luda tó ǹ gↄ̃ gbɛ̃ dasinↄ dai ũ, n burinↄ gↄ̃ gbãna vĩ ń zãngurinↄa. ");
INSERT INTO bqp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Akũ Rɛbɛka fùtɛ kũ a nↄgbɛ̃ zĩkɛrinↄ, ò dì lakuminↄ kpɛ ò tɛ́ gↄ̃gbɛ̃ pìii, akũ à tà kũńwo. ");
INSERT INTO bqp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","A sù à lè Isaaku sù kũ lↄ̀gↄ kũ òdi pi Ludabɛ̃nɛkũadima'eo à vùtɛ Nɛgɛvi bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","À bò à gɛ̀ɛ à laasun lɛ́ sɛ̃̀n ↄkↄsi, akũ kũ à wɛ́ sɛ̀, à è lakuminↄ tɛn su. ");
INSERT INTO bqp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rɛbɛka wɛ́ sɛ̀ à Isaaku è se, akũ à kìpa a lakumi kpɛ likalika ");
INSERT INTO bqp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","à zĩkɛrii pìi là à pì: Dín gↄ̃gbɛ̃ kũ àtɛn kure sɛ̃̀n àtɛn su daolɛ zã̀ dire ũu? Akũ zĩkɛrii pìi wèa à pì: Ma dikiriimɛ. Akũ Rɛbɛka a pↄ́dangãnn sɛ̀ à kù a ãnnwa. ");
INSERT INTO bqp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kũ ò kà Isaaku kĩnaa, zĩkɛrii pì yã kũ à kɛ̀ɛ bàbanɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaaku gɛ̃̀ kũ Rɛbɛkao a da Sara bizakutan, akũ à a sɛ̀ à gↄ̃̀ a nↄ ũ. À ye nↄ pìii, akũ a laakari kpatɛna a da ga gbɛra. ");
INSERT INTO bqp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahĩ nↄ pãnde sɛ̀ dↄ a tↄ́n Kɛtura. ");
INSERT INTO bqp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nɛ́ kũ à ì kãaonↄ tↄ́n dí: Zimlã, Yↄkↄsã, Mɛdã, Midiã, Isibaki, Sua. ");
INSERT INTO bqp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yↄkↄsã mɛ́ à Seba kũ Dedão ì. Dedã burinↄn Asirianↄ kũ Lɛtusinↄ kũ Lɛuminↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiã nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Efa, Ɛfa, Anↄku, Abida, Ɛlɛda. Ń pínki Kɛtura burinↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahĩ a aruzɛkɛ kpà Isaakua pínki, ");
INSERT INTO bqp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","akũ à gba dà a nↄ yìgisaride nɛ́nↄnɛ à ń gbárɛ ifãboki kpa de à kpɛ́ à ga, de òsungↄ̃ kú kũ Isaakuoro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahĩ kɛ̀ wɛ̃̀ bakɛ̃ndo sↄↄro sari, ");
INSERT INTO bqp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","akũ à gà. À zĩ kũ̀ yúkuyuku, gbasa à kà a gbɛ̃nↄla gyãwãn. ");
INSERT INTO bqp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A nɛ́nↄ Isaaku kũ Sumailao a vĩ̀ Makpɛla gbɛ̀wɛɛ gũn, Mamare ifãboki kpa, bura kũ à de Iti buri Zoa nɛ́ Ɛflↄnu pↄ́ ũ yã ");
INSERT INTO bqp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","kũ Ibrahĩ pìi lù Itinↄa. Gwen ò a vĩ̀n kũ a nanↄ Sarao. ");
INSERT INTO bqp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibrahĩ ganaa gbɛra Luda arubarikaa dà a nɛ́ Isaakun. À vutɛna Ludabɛ̃nɛkũadima'e lↄ̀gↄↄ sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ibrahĩ nɛ́ Sumaila burinↄ yãn dí. Sara zĩkɛri Hazara, Misila nↄgbɛ̃ mɛ́ à nɛ́ pìi ì kãao. ");
INSERT INTO bqp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Sumaila nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí lákũ ò ń í nà. A daudu tↄ́n Nɛbayo. A dakũnanↄ tↄ́n dí: Keda, Adabɛli, Mibisamu, ");
INSERT INTO bqp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO bqp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adada, Tema, Yetu, Nafisi kũ Kedemao. ");
INSERT INTO bqp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sumaila nɛ́gↄ̃gbɛ̃nↄ tↄ́n gwe. Ń baadi a tↄ́ kpà a lakutu ke a bùraanɛ. Mↄ́kↄ̃nↄmɛ a buri kuri awɛɛplanↄ kínanↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumaila kɛ̀ wɛ̃̀ basuddo akuri awɛɛsuppla, akũ à gà à kà a gbɛ̃nↄla gyãwãn. ");
INSERT INTO bqp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","A burinↄ vùtɛ zaa Avila ari à gɛ̀ɛ pɛ́ Surua, Misila ifãboki kpa gɛna Asiria bùsu kpa. Òdi kↄ̃ tɛ́ kpákpa kũ Ibrahĩ buri kparanↄro. ");
INSERT INTO bqp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ibrahĩ nɛ́ Isaaku burinↄ yãn dí. Ibrahĩ Isaaku ì. ");
INSERT INTO bqp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kũ Isaaku kà wɛ̃̀ bupla, akũ à Labã dãre Rɛbɛka sɛ̀. Àkũmɛ Siria bùsu gbɛ̃ Bɛtuɛli kũ à bò Mɛsↄpↄtamia bùsun nɛ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaaku wɛ́ kɛ̀ Dikiria a nanↄnɛ, zaakũ paramɛ, akũ Dikiri a adua sì, a nanↄ pìi nↄ̀ↄ sì. ");
INSERT INTO bqp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Sìkanↄ tɛn ↄsi ká a gbɛrɛn, akũ à pì: Bↄ́ yã mɛ́ à tò yã bire taka ma lee? Akũ à gɛ̀ɛ à Dikiri là. ");
INSERT INTO bqp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Dikiri pìnɛ: Buri mɛ̀n pla kú n nɛ́'isↄn, gbɛ̃nↄn pla kũ ò kú n gbɛrɛn pìnↄ ni kɛ̃kↄ̃a. Buri mɛ̀n do gbãna nigↄ̃ de a dola, a kũ à bò káaku nigↄ̃ nɛ́ ũ gbɛ̃ kpɛdenɛ. ");
INSERT INTO bqp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kũ a nɛ́'igↄrↄ kà, akũ à sìkanↄ ì gↄ̃gbɛ̃nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kũ gbɛ̃ káaku tɛn bo, à bò tɛ̃ɛ zónzon. À mɛ̀kã vĩ lán uta kãde bà, akũ ò tↄ́ kpànɛ Isau. ");
INSERT INTO bqp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Abire gbɛra kũ nɛ́ plade tɛn bo, à dↄ̀ Isau gbátokia, akũ ò tↄ́ kpànɛ Yakubu. Isaaku wɛ̃̀ baaakↄ̃de gũnn à nɛ́ pìnↄ ì. ");
INSERT INTO bqp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nɛ́ pìnↄ zↄ̃kↄ̃ kũ̀. Isau kɛ̀ tofekari gbãna kũ àdi kɛ̃ sɛ̃̀ntɛaro ũ. Yakubu sↄ̃ bɛgwariimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaku ye Isaui kũ à nↄ̀bↄ lɛ́'i vĩ yãi. Rɛbɛka sↄ̃ à ye Yakubui. ");
INSERT INTO bqp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Zĩkea Yakubu tɛn dòo kuku, akũ Isau sù kũ sɛ̃̀ntɛo nà tɛni a dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Akũ à pì Yakubunɛ: N yã nna! Ǹ tó mà dò tɛ̃ra bire ble, zaakũ nà tɛni ma dɛmɛ. A yã mɛ́ à tò, ò tↄ́ kpà Isaunɛ Ɛdↄmu. ");
INSERT INTO bqp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakubu pì: Ǹ n daudukɛzɛ kpáma gĩa. ");
INSERT INTO bqp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Akũ Isau pì: Má kú ga lɛ́i, bↄ́n ma daudukɛzɛ ni kɛmɛnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Akũ Yakubu pìnɛ: Ǹ la damɛnɛ gĩa. Akũ à la dànɛ à a daudukɛzɛ kpàa. ");
INSERT INTO bqp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Akũ Yakubu burodii kpàa kũ bládoo pìio. À blè à í mì, akũ à fùtɛ à bò. Lɛmɛ Isau kɛ̀ lɛ, à a daudukɛzɛ dìtɛ pã. ");
INSERT INTO bqp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nàa kà bùsuu pìn a káakupↄ kũ à kà Ibrahĩ gↄrↄa baasi, akũ Isaaku fùtɛ à gɛ̀ɛ Filisitininↄ kína Abimɛlɛki kĩnaa Gera. ");
INSERT INTO bqp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Akũ Dikiri bò à sùa à pì: Ǹsun tá Misilaro, ǹ vutɛ gu kũ mani onnɛn. ");
INSERT INTO bqp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ǹgↄ̃ kú bùsu díkĩnan gĩa, manigↄ̃ kú kũnwo mà arubarika dannɛ. Mani bùsu díkĩna kpámma pínki kũ n burinↄ, mani lɛ́ kũ ma kɛ̀ n denɛ kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mani n buri kara lán susunɛnↄ bà, mani bùsu díkĩna kpáḿma pínki. Buri kũ à kú zĩtɛnↄ ni arubarika le n buri gãi ń pínki ");
INSERT INTO bqp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kũ Ibrahĩ ma yã mà yãi. À ma ↄdↄki gwà, akũ à yã kũ ma dìtɛnↄ kũna kũ ma yãdannɛnanↄ kũ ma dokayãnↄ. ");
INSERT INTO bqp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Akũ Isaaku gↄ̃̀ Gera. ");
INSERT INTO bqp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kũ wɛ̃tɛpidenↄ tɛni a la a nanↄ yã musu, à pì a dãremɛ. Àtɛn vĩna kɛ, zaakũ àtɛn da tó à pì a nanↄmɛ, oni a dɛ nↄ pì yãi, zaakũ nↄ pì bi nↄ manamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kũ a gↄrↄ pla kɛ̀ gwe, Filisitininↄ kí Abimɛlɛki wɛ́ kpàtɛ wondoo gũn, akũ à è Isaaku tɛn bã̀ndara gá kũ a nanↄo. ");
INSERT INTO bqp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Akũ à Isaaku sìsi à pì: Ase n nanↄmɛɛ! À kɛ̀ dera n pì n dãremɛɛ? À wèa à pì: Matɛn da oni ma dɛ a yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimɛlɛki pì: Bↄ́ yã n kɛ̀wɛrɛ lɛɛ? Fíti mɛ́ à gↄ̃̀ kũ ó gbɛ̃ke ni wútɛ kũ n nↄ pìio, de ǹ ó da taarin. ");
INSERT INTO bqp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Akũ Abimɛlɛki gbɛ̃nↄ sã gbɛ̃̀ńnɛ pínki à pì: Gbɛ̃ kũ à ↄ nà gↄ̃gbɛ̃ pìia kũ a nanↄo, oni a dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaaku pↄ́ tↄ̃̀ bùsuu pìn, akũ à pↄ́ lè wɛ̃̀ birea lɛu basↄↄro, kũ Dikiri arubarikaa dàn yãi. ");
INSERT INTO bqp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","À kàra, a aruzɛkɛ tɛn kara ari à kɛ̀ aruzɛkɛde zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","À sãnↄ kũ zùnↄ vĩ dasi kũ zĩkɛrinↄ, akũ Filisitininↄ zã̀n. ");
INSERT INTO bqp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Akũ ò lↄ̀gↄ kũ a de Ibrahĩ gbɛ̃nↄ yↄ̃̀ a gↄrↄanↄ tàta kũ bùsuuo pínki. ");
INSERT INTO bqp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Akũ Abimɛlɛki pì Isaakunɛ: Ǹ futɛ ó kĩnaa, zaakũ ń gbãna deóla manamana. ");
INSERT INTO bqp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Akũ Isaaku bò gwe à bùraa kàtɛ Gera guvutɛn, akũ à gↄrↄ pla kɛ̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Lↄ̀gↄ kũ ò yↄ̃̀ a de Ibrahĩ gↄrↄa akũ Filisitininↄ tàta a de ga gbɛranↄn à ɛ̀ra à bↄ̀bↄ à tↄ́ dokↄ̃nↄ kũ a de kpàńnɛ yãnↄ kpàńnɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaaku zĩkɛrinↄ lↄ̀gↄ pãnde yↄ̃̀ guvutɛ pìn, akũ ò bò í manaa. ");
INSERT INTO bqp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Akũ Gera pↄ́dãrinↄ fìti kɛ̀ kũ Isaaku pↄ́dãrinↄ ò pì: Ó ímɛ. Akũ à tↄ́ kpà lↄ̀gↄↄ pìinɛ Fìtii, kũ ò fìti kɛ̀ kãao yãi. ");
INSERT INTO bqp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ò lↄ̀gↄ pãnde yↄ̃̀, akũ ò fìti kɛ̀ lↄ̀gↄↄ pì yã musu dↄ, akũ à tↄ́ kpànɛ Íbɛtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","À bò gwe, akũ à lↄ̀gↄ pãnde yↄ̃̀ dↄ, odi fìti kɛ a yã musu doro. Akũ à tↄ́ kpànɛ Mɛ̀poroki, zaakũ à pì: Dikiri tò o mɛ̀ɛ pòro, óni dagula sà. ");
INSERT INTO bqp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Abire gbɛra à gɛ̀ɛ Bɛsɛba. ");
INSERT INTO bqp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Dikiri bò à sùa gwãani birea à pì: Makũmɛ n de Ibrahĩ Luda ũ, ǹsun vĩna kɛro zaakũ má kú kũnwo. Mani arubarika dangu mà n buri kara ma zↄ̀bleri Ibrahĩ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Gwen à sa'oki bòn à Dikiri sìsi. Akũ à bùraa kàtɛ gwe à gbɛ̃nↄ tɛn lↄ̀gↄ yↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Akũ Abimɛlɛki bò Gera à sù Isaaku kĩnaa kũ a kpàasi Auzao kũ a zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Fikↄluo. ");
INSERT INTO bqp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaku ń lá à pì: Kũ a zãmagu a pɛma á bɛa, à kɛ̀ dera a su ma kĩnaa? ");
INSERT INTO bqp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ò wèa ò pì: O è Dikiri kú kũnwo, akũ o pì à mana ò lɛ́dokↄ̃nↄ kɛ ò la dakↄ̃nɛ a yã musu ");
INSERT INTO bqp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kũ ĩni yã vãni ke kɛwɛrɛro, zaakũ ódi wɛ́ tãmmaro. Yã manan o kɛ̀nnɛ o n gbarɛ aafia, akũ Dikiri arubarikaa dàngu. ");
INSERT INTO bqp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Akũ Isaaku ń yàrii kɛ̀, ò pↄ́ blè ò í mì. ");
INSERT INTO bqp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kũ ò fùtɛ kↄnkↄ, ò la dàkↄ̃nɛ, akũ Isaaku zɛ̀ńnɛ, ò bò a kĩnaa aafia. ");
INSERT INTO bqp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Zĩ birea Isaaku gbɛ̃nↄ sù ò lↄ̀gↄ kũ ò yↄ̃̀ yã ònɛ ò pì: O í è. ");
INSERT INTO bqp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Akũ à tↄ́ kpànɛ Sɛba. A yã mɛ́ à tò òdi wɛ̃tɛ pì sísi Bɛsɛba ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kũ Isau kà wɛ̃̀ bupla, à Iti nↄ sɛ̀ mɛ̀n pla, Beri nɛ́ Yudi kũ Ɛlↄni nɛ́ Basɛmao. ");
INSERT INTO bqp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaaku kũ Rɛbɛkao nɛ̀sɛɛ dìgↄ̃ yakana ń yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaaku zĩ kũ̀ a wɛ́ gbãna doro, àtɛn gu e manaro. Akũ à a dauduu sìsi à pì: Nɛ́! Akũ à wèa à pì: Makũ dí. ");
INSERT INTO bqp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaku pì: Ma zĩ kũ̀ má a gagↄrↄ dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ǹ n sá sɛ́ kũ n gbàtaao ǹ gɛ́ ǹ nↄ̀bↄsɛ̃ntɛ wɛtɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ǹ ma pↄyeina dòo kuku ǹ mↄ́omɛnɛ mà ble, mani sa'olɛ kɛnnɛ de mà kpɛ́ mà ga. ");
INSERT INTO bqp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rɛbɛka yã kũ Isaaku ò Isaunɛ pìi mà. Kũ Isau fùtɛ à gɛ̀ɛ tofe ká, ");
INSERT INTO bqp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","akũ à gɛ̀ɛ à ò Yakubunɛ à pì: Ma mà n de yã ò n vĩ̀ninɛ à pì ");
INSERT INTO bqp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","à gɛ́ à nↄ̀bↄ dɛarɛ à a pↄyeina dòo kukuoarɛ à ble, áni sa'olɛ kɛnɛ kũ Dikiri tↄ́o de á kpɛ́ à ga. ");
INSERT INTO bqp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Akũ Rɛbɛka ɛ̀ra à pìnɛ: Ǹ ma yã ma ǹ yã kũ ma dànnɛ kɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ǹ gɛ́ blè kpàsaa gũn ǹ blènɛ mana kũ mɛ̀n pla ǹ suo. Mani n de pↄyeina dòo kukunɛ, ");
INSERT INTO bqp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ń gɛ́onɛ à ble, ani sa'olɛ kɛnnɛ de à kpɛ́ à ga. ");
INSERT INTO bqp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Akũ Yakubu pì a danɛ: Ma vĩ̀ni mɛ̀kã vĩ, akũ ma mɛ̀ pↄ́rↄpↄrↄ. ");
INSERT INTO bqp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tó ma de ↄ kɛ̀ma, tó à ma dↄ̃, ani pi matɛni a kɛ pãpãmɛ, ani lɛ́ kɛmɛnɛ sa'olɛ gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Akũ a da pìnɛ: Luda tó lɛ́kɛnnɛnaa pì gↄ̃mɛnɛ. Ǹ ma yã ma dé! Ǹ gɛ́ ǹ dɛ ǹ suomɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Akũ Yakubu gɛ̀ɛ à blèe pìnↄ dɛ̀ à sùo a danɛ, akũ à a de pↄyeina dòo kùkunɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Akũ à a daudu pↄ́kasa mana kũ à kú a kpɛ́ gũnnↄ sɛ̀ à dà a nɛ́ sabidenɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","À blènɛ bára pìnↄ fĩ̀fĩ a ↄnↄa kũ a waka pↄ́rↄpↄrↄo. ");
INSERT INTO bqp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Akũ à dò kũ burodi kũ à kɛ̀ɛoo kpàa. ");
INSERT INTO bqp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakubu gɛ̀ɛ a de kĩnaa à pì: Baa! Akũ a de pì: Makũ di! Ma nɛ́ kpatemɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakubu wèa à pì: Makũmɛ Isau n dauduu. Lákũ n òmɛnɛ nà, ma kɛ̀ lɛ. Ǹ futɛ ǹ vutɛ ǹ ma ↄ'i ble de ǹ sa'olɛ kɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Akũ Isaaku pì a nɛ́nɛ: O'o! N lè kↄ̀ yá? À wèa à pì: Dikiri n Luda mɛ́ à ma tá kɛ̀ nna. ");
INSERT INTO bqp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Akũ Isaaku pìnɛ: Ǹ namai mà ↄ kɛmma de mà dↄ̃ tó ma nɛ́ Isaumɛ yãpura. ");
INSERT INTO bqp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakubu nà a dei, akũ à ↄ kɛ̀a à pì: Kòto díkĩna bi Yakubu kòtoomɛ, ↄ díkĩna sↄ̃ Isau ↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Akũ adi a dↄ̃ro, kũ a ↄnↄ kã vĩ lán Isau pↄ́ bà yãi. À ye à sa'olɛ kɛnɛ, ");
INSERT INTO bqp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","akũ à a la gĩa: Ma nɛ́ Isaumɛ n ũ yãpura yá? À wèa à pì: Makũmɛ! ");
INSERT INTO bqp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Akũ à pì: Ǹ pↄ́ kpáma mà n ↄ'i ble, mani sa'olɛ kɛnnɛ. Kũ à dìtɛnɛ, akũ à blè. À sùnɛ kũ wɛ̃o, à mì dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Akũ a de pìi pìnɛ: Ǹ namai ǹ lɛ́ pɛ́ma. ");
INSERT INTO bqp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Akũ à nài à lɛ́ pɛ̀a. Kũ Isaaku a pↄ́kasanↄ gbĩ mà, akũ à sa'olɛ kɛ̀nɛ à pì: Ma nɛ́ gbĩ de lán bura kũ Dikiri arubarikaa dàn bà. ");
INSERT INTO bqp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Luda n gba mↄtↄ bona musu, à n gba zĩtɛ mana. Pↄ́blewɛ kũ sèwɛ̃o nigↄ̃ dinyĩ. ");
INSERT INTO bqp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Gbɛ̃nↄ ni zↄ̀ blennɛ, burinↄ ni kútɛ n arɛ, ĩnigↄ̃ de n gbɛ̃nↄ dikiri ũ, n da nɛ́nↄ ni kútɛnnɛ. Luda ni lɛ́ kɛ gbɛ̃ kũ ò lɛ́ kɛ̀nnɛnↄnɛ, ani arubarika da gbɛ̃ kũ ò sa mana ònnɛnↄgu. ");
INSERT INTO bqp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kũ Isaaku sa'olɛ kɛ̀ Yakubunɛ à làka, akũ Yakubu gò a kĩnaa. Kũ a vĩ̀ni sù kũ tofekao gↄ̃̀nↄ, ");
INSERT INTO bqp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","akũ à pↄ́ble kɛ̀ a denɛ dↄ à gɛ̀ɛonɛ, akũ à pìnɛ: Baa! Ǹ futɛ ǹ ma ↄ'i ble ǹ sa'olɛ kɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Akũ a de a la à pì: Mↄkↄ̃mmɛ dí ũu? À wèa à pì: Makũmɛ n daudu Isau. ");
INSERT INTO bqp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yã pì Isaaku swɛ̃̀ɛ zↄ̃̀ àtɛn lukaluka à pì: Dí mɛ́ à nↄ̀bↄↄ dɛ̀ à sùomɛnɛ yã ari ǹgↄ̃ gɛ́ su ma sòo? Ma sa'olɛ kɛ̀nɛ kↄ̀, àkũ mɛ́ ani arubarika le. ");
INSERT INTO bqp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kũ Isau a de yã pìi mà, à pũ̀tã à ↄ́ gbãna dↄ̀ à kɛ̀ wɛ̃nda, akũ à pì: Baa! Ǹ sa'olɛ kɛmɛnɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Akũ à pì: N dakũna sù kũ ↄ̃ndↄ̃o à n sa'olɛ sì kↄ̀. ");
INSERT INTO bqp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Akũ Isau pì: A tↄ́n Yakuburoo? À ma kɛkɛ à kɛ̀ gɛ̃̀n plan gwe sà. À ma daudukɛzɛ sìma yã, akũ à ma sa'olɛ sìma tera dↄ. Mani sa'olɛ e doro yá? ");
INSERT INTO bqp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaku wèa à pì: Ma a dìtɛ n dikiri ũ, ma a danɛnↄ kɛ̀ a zĩkɛrinↄ ũ ń pínki, ma pↄ́blewɛ kũ sèwɛ̃o kpàa. Bↄ́n mani le mà kɛnnɛ dↄↄ? ");
INSERT INTO bqp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isau pì a denɛ: Baa, sa'olɛ biren ń vĩ ado yá? Ǹ sa'olɛ pãnde kɛmɛnɛ dↄ Baa. Akũ Isau wiki gbãna lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Akũ a de wèa à pì: Zĩtɛ kũ ĩnigↄ̃ kun nigↄ̃ manaro, mↄtↄ ni bonnɛ zaa musuro. ");
INSERT INTO bqp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ĩnigↄ̃ fɛ̃nɛda kũna, ĩni zↄ̀ ble n dakũnanɛ. Lɛmɛ dↄ n laakari ni gↄ̃ kpatɛnaro, ĩni a gbãngo gonla. ");
INSERT INTO bqp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isau ibɛrɛɛ sɛ̀ kũ Yakubuo sa'olɛ kũ a de kɛ̀nɛ yãi, akũ à pì a nɛ̀sɛɛ gũn: Ma de ga zã̀ro, gbasa mani ma dakũna dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ò yã kũ Isau ò kↄrↄmↄtↄↄ kɛ̀ Rɛbɛkanɛ, akũ à Yakubu sìsi à pì: Isau ye à fĩna bomma à n dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ǹ ma yã ma sà. Ǹ futɛ ǹ bàa lɛ́ ǹ gɛ́ ma dãgↄ̃ Labã bɛa zaa Arana ");
INSERT INTO bqp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ǹgↄ̃ kú kãao gwe gĩa ari n vĩ̀ni pì pↄfɛ̃ kpátɛ. ");
INSERT INTO bqp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tó a nɛ̀sɛɛ kpàtɛ, tó yã kũ n kɛ̀nɛɛ sã̀agu, mani gbɛ̃ zĩ ò n gbɛsɛ. Má ye mà kura á gbɛ̃nↄn planↄi pínki gↄrↄ doro. ");
INSERT INTO bqp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Akũ Rɛbɛka pì Isaakunɛ: Iti nↄgbɛ̃nↄ ni bòmagu. Tó Yakubu Iti nↄ sɛ̀ bùsu díkĩnan lán Isau nↄgbɛ̃ birenↄ bà, ma kunna nigↄ̃ nnamɛnɛ doro. ");
INSERT INTO bqp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Akũ Isaaku Yakubu sìsi à sa'olɛ kɛ̀nɛ à yã dànɛ à pì: Ǹsun nↄ sɛ́ Kanaa nↄgbɛ̃nↄ tɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ǹ futɛ ǹ gɛ́ Mɛsↄpↄtamia bùsun n da de Bɛtuɛli bɛa, ǹ nↄ sɛ́ gwe n disɛ̃ Labã nɛ́nↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Luda Gbãnasĩndapinkide arubarika dangu à tó ǹ nɛ́ i manamana, ògↄ̃ kara de ǹ gↄ̃ burinↄ dizi ũ. ");
INSERT INTO bqp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Luda arubarika kũ à dà Ibrahĩn dangu kũ n burinↄ, de bùsu kũ ntɛn nibↄ blen gↄ̃nnɛ, bùsu kũ à kpà Ibrahĩaa. ");
INSERT INTO bqp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Akũ Isaaku Yakubu gbàrɛ à gɛ́ Labã kĩnaa Mɛsↄpↄtamia bùsun. Labã bi Siria bùsu gbɛ̃ Bɛtuɛli nɛ́mɛ, Yakubu kũ Isauo disɛ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isau mà Isaaku sa'olɛ kɛ̀ Yakubunɛ à a gbàrɛ Mɛsↄpↄtamia de à nↄ sɛ́ gwe. Kũ à sa'olɛ pìi kɛ̀nɛ, à pì àsun nↄ sɛ́ Kanaa nↄgbɛ̃nↄ tɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","À tàasii kà kũ Yakubu a de kũ a dao yã mà à dà Mɛsↄpↄtamia zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Akũ à dↄ̃̀ sà kũ a de pↄ nna kũ Kanaanↄ bùsu nↄgbɛ̃nↄro. ");
INSERT INTO bqp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Akũ à gɛ̀ɛ Ibrahĩ nɛ́ Sumaila kĩnaa à a nɛ́ Maala sɛ̀ à nà a nↄ káakunↄa. Maala bi Nɛbayo dãremɛ. ");
INSERT INTO bqp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakubu bò Bɛsɛba à dà Arana zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kũ à kà gukea, à ye à i gwe kũ ifãntɛ̃ gɛ̃̀ kpɛ́n yãi. Akũ à gbɛ̀ɛ sɛ̀ gu pìn a mìdibↄ ũ à wùtɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Akũ à nana ò à gára è pɛtɛna zĩtɛ ari à gɛ̀ɛ à zↄ̃̀ ludambɛa, Luda malaikanↄ tɛn didia òtɛn kipa. ");
INSERT INTO bqp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","À Dikiri è zɛnaala à pì: Makũmɛ Dikiri n dizi Ibrahĩ kũ n de Isaakuoo Luda ũ. Mani bùsu kũ ń wútɛa díkĩna kpámma, mↄkↄ̃n kũ n burinↄ. ");
INSERT INTO bqp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","N burinↄ nigↄ̃ dasi lán bùsutiti bà, oni dagula ifãboki kpa kũ ifãlɛtɛo kũ gugbãnduru kũ gɛ̀nↄmidↄkio. Andunia buri sĩnda pínki ni arubarika le mↄkↄ̃n kũ n burio gãi. ");
INSERT INTO bqp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Manigↄ̃ kú kũnwo, manigↄ̃ n dãkpã gu kũ ntɛn gɛ́n pínki, mani ɛra mà su kũnwo bùsu díkĩnan, zaakũ mani n tónlo mani yã kũ ma ònnɛ kɛ. ");
INSERT INTO bqp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kũ Yakubu vù kũ io à pì: Dikiri kú gu dí, akũ mádi dↄ̃ro! ");
INSERT INTO bqp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Vĩna a kũ̀ à pì: Gu dí ma kã fùtɛ. Luda bɛmɛ, ludambɛ zɛ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakubu fùtɛ kↄnkↄ à gbɛ̀ kũ à kɛ̀ mìdibↄ ũ pìi sɛ̀ à pɛ̀tɛ dↄngupↄ ũ, akũ à nísi kùa. ");
INSERT INTO bqp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Akũ à tↄ́ kpà gu pìinɛ Bɛtɛli, ama wɛ̃tɛ kũ ò kàtɛ gwe tↄ́ káakun Luzu. ");
INSERT INTO bqp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakubu lɛ́ kɛ̀ Dikiria à pì: Tó ń kú kũmao, tó ĩni ma dãkpã ma wɛ̃tɛ díkĩna gɛnaa gũn, tó ĩni ma gba pↄ́ble kũ pↄ́kasanↄ ");
INSERT INTO bqp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ari ma gɛ ma su ma de bɛa aafia, ĩnigↄ̃ de ma Luda ũ, ");
INSERT INTO bqp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","gbɛ̀ kũ ma pɛ̀tɛ dↄngupↄ ũ pì ni gↄ̃ n gbagbaki ũ, pↄ́ kũ n ma gba pínki mani a kuride kpámma. ");
INSERT INTO bqp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakubu ɛ̀ra à dà zɛ́n à gɛ̀ɛ ifãbokikpadenↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kũ à kà gwe, à lↄ̀gↄↄ è sɛ̃̀n sã kpàsa lɛu aakↄ̃ katɛna a sarɛ, zaakũ lↄ̀gↄↄ pì ín òdi kpáḿma. Gbɛ̀ zↄ̃kↄ̃ ta lↄ̀gↄↄ pìlɛ. ");
INSERT INTO bqp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tó kpàsaa pìnↄ kàkara gwe pínki, akũ òdi gbɛ̀ɛ pì go lↄ̀gↄↄ pì lɛ́a, ò í kpáḿma, akũ òdi ɛra ò gbɛ̀ɛ pì tarɛ a gbɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Akũ Yakubu sãdãrinↄ là à pì: Gbɛ̃nↄ, a bo mámɛɛ? Ò wèa ò pì: O bo Aranamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Akũ à ń lá à pì: Á Nao daikore Labã dↄ̃ yá? Ò wèa ò pì: Ó a dↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Akũ à ń lá à pì: À aafia yá? Ò pì: À aafia. Ǹ a nɛ́ Rahila gwa, àtɛn su kũ sãnↄ zã̀ dire. ");
INSERT INTO bqp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Akũ Yakubu pì: Ifãntɛ̃ kpɛ́ gbãna, sãnↄ tágↄrↄ dí ká kↄ̀ro. À í kpáḿma à gɛ́ ń dã. ");
INSERT INTO bqp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Akũ ò pì: Óni fↄ̃ro. Tó adi kɛ sã kpàsanↄ kàkara pínki baasiro, òdi gbɛ̀ go lↄ̀gↄↄ pì lɛ́a ò í kpáḿmaro. ");
INSERT INTO bqp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kũ àtɛn yã ońnɛ lɛ, Rahila sù kũ a de sãnↄ, zaakũ sãdãriimɛ a ũ. ");
INSERT INTO bqp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kũ Yakubu a disɛ̃ Labã nɛ́nↄgbɛ̃ Rahila è kũ a de sãnↄ, à nà lↄ̀gↄↄi à gbɛ̀ɛ gò lↄ̀gↄↄ pì lɛ́a, akũ à í kpà a disɛ̃ sãnↄa. ");
INSERT INTO bqp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Akũ à lɛ́ pɛ̀ Rahilaa à pↄnna ↄ́ↄ dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Akũ à ònɛ kũ a de danɛ Rɛbɛka nɛ́n a ũ. Akũ Rahila bàa lɛ̀ à gɛ̀ɛ à ò a denɛ. ");
INSERT INTO bqp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kũ Labã a dãre nɛ́ Yakubu baaruu mà, à bàa lɛ̀ à gɛ̀ɛ daalɛ. Kũ à kà, akũ à kùsia à lɛ́ pɛ̀a à tà kãao a bɛa. Akũ Yakubu yã kũ ò kɛ̀nↄ ònɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Akũ Labã pìnɛ: Ma arumɛ n ũ yãpura. Yakubu kɛ̀ Labã bɛa mↄ do, ");
INSERT INTO bqp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","akũ Labã pìnɛ: Kũ ń de ma danɛ ũ yãin ĩni zĩ kɛmɛnɛ pã yá? Dera mani fĩna bonnɛ nà ǹ omɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labã sↄ̃ à nɛ́nↄgbɛ̃nↄ vĩ gbɛ̃nↄn pla. Yↄ̃ↄ tↄ́n Lea, Bãna sↄ̃ Rahila. ");
INSERT INTO bqp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea wɛ́ busana, Rahila sↄ̃ nↄkpare manamɛ, akũ a kakana mana. ");
INSERT INTO bqp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakubu ye Rahilai, akũ à pì Labãnɛ: Mani zĩ kɛnnɛ wɛ̃̀ suppla n nɛ́ bãnade Rahila yãi. ");
INSERT INTO bqp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labã pì: À sã̀na mà a kpámma de mà a kpá gbɛ̃ pãndeala. Ǹgↄ̃ kú ma bɛa la. ");
INSERT INTO bqp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Akũ Yakubu zĩ kɛ̀nɛ wɛ̃̀ suppla Rahila yãi, ase à kɛ̀nɛ lán gↄrↄ pla bàmɛ kũ à yei yãi. ");
INSERT INTO bqp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Akũ à pì Labãnɛ: Kũ ma zĩgↄrↄ pàpa, ǹ ma nↄ kpáma mà sɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Akũ Labã gwedenↄ kàkara ń pínki à nↄsɛpↄble kɛ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kũ ↄkↄsi kɛ̀, akũ à a nɛ́ Lea sɛ̀ à kpàa, akũ Yakubu wùtɛ kãao. ");
INSERT INTO bqp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labã a nↄgbɛ̃ zĩkɛri Zilipa kpà Leanɛ zĩkɛri ũ. ");
INSERT INTO bqp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kũ gu dↄ̀ Yakubu è Leamɛ, akũ à pì Labãnɛ: Bↄ́yãi n kɛ̀mɛnɛ lɛɛ? Rahila yãin ma zĩ kɛ̀nnɛroo? Bↄ́ mɛ́ à tò n ma kɛkɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labã pì: Ó kĩnaa òdi Bãna kpá gↄ̃a Yↄ̃ↄ ãro. ");
INSERT INTO bqp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ǹ azuma do kɛ kũ gbɛ̃ dio gĩa, mani a gbɛ̃ndo kpámma zĩ kũ ĩni ɛra ǹ kɛmɛnɛ wɛ̃̀ suppla pãnde pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakubu wè à azuma do pìi kɛ̀ kũ Leao, akũ Labã a nɛ́ Rahila kpàa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labã a nↄgbɛ̃ zĩkɛri Bila kpà Rahilaa zĩkɛri ũ. ");
INSERT INTO bqp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakubu wùtɛ kũ Rahilao sↄ̃, akũ à yei de Leala. Akũ à ɛ̀ra à zĩ kɛ̀ Labãnɛ ari wɛ̃̀ suppla dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Dikiri è Yakubu ye Leairo, akũ à a kɛ̀ nɛ́rande ũ, Rahila sↄ̃ paramɛ. ");
INSERT INTO bqp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nↄ̀ↄ sì à nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à tↄ́ kpànɛ Rubɛni, zaakũ à pì: Dikiri ma warikɛnaa gwà. Ma zã nigↄ̃ yemai sà. ");
INSERT INTO bqp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kũ à nↄ̀ↄ sì dↄ, à nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à pì: Dikiri mà ma zã yemairo, akũ à ɛ̀ra à nɛ́ díkĩna kpàma dↄ. Akũ à tↄ́ kpànɛ Simɛↄ. ");
INSERT INTO bqp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kũ à ɛ̀ra à nↄ̀ↄ sì dↄ, à nɛ́ ì gↄ̃gbɛ̃ ũ à pì: Adikĩna sà ma zã ni ma ditɛki ero, zaakũ ma nɛ́gↄ̃gbɛ̃ ì kãao mɛ̀n aakↄ̃. Akũ à tↄ́ kpànɛ Levi. ");
INSERT INTO bqp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","À ɛ̀ra à nↄ̀ↄ sì dↄ à nɛ́ ì gↄ̃gbɛ̃ ũ à pì: Adikĩna sà ma Dikiri sáabu kpà, akũ à tↄ́ kpànɛ Yuda. Akũ a nɛ́'i zɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kũ Rahila è átɛn nɛ́ i kũ Yakubuoro, à gↄ̃ba kpà kũ a vĩ̀nio. Akũ à pì Yakubunɛ: Ǹ nↄ̀ dↄmagu. Tó mádi e sↄ̃ro, mani gamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakubu pↄ fɛ̃̀i à pì: Makũmɛ Luda ũ kũ à n tɛ̃ nɛ́ yá? ");
INSERT INTO bqp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Akũ Rahila pì: Ma zĩkɛri Bilan dí. Ǹ gɛ́ i kãao à nɛ́nↄ imɛnɛ, mani buri le se a gãi. ");
INSERT INTO bqp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Akũ à a zĩkɛri Bila kpàa nↄ ũ. Yakubu wùtɛ kãao, ");
INSERT INTO bqp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","akũ à nↄ̀ↄ sì à nɛ́ ì gↄ̃gbɛ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Akũ Rahila pì: Luda tò yã bò kũmao nna à ma yã mà à ma gba nɛ́gↄ̃gbɛ̃. Akũ à tↄ́ kpànɛ Dã. ");
INSERT INTO bqp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahila zĩkɛrii pìi ɛ̀ra à nↄ̀ↄ sì à nɛ́ ì gↄ̃gbɛ̃ ũ dↄ, ");
INSERT INTO bqp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","akũ Rahila pì: Ma ↄsi zↄ̃kↄ̃ↄ kà kũ ma vĩ̀nio ma ↄsi nɛ̀. Akũ à tↄ́ kpànɛ Nafatali. ");
INSERT INTO bqp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kũ Lea è a nɛ́'i zɛ̀, akũ à a zĩkɛri Zilipa kpà Yakubua nↄ ũ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Akũ Lea zĩkɛrii pì nɛ́ ì gↄ̃gbɛ̃ ũ kũ Yakubuo. ");
INSERT INTO bqp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Akũ Lea pì: Mìnnamɛ. Akũ à tↄ́ kpànɛ Gada. ");
INSERT INTO bqp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Akũ Lea zĩkɛrii pì nɛ́ ì gↄ̃gbɛ̃ ũ dↄ kũ Yakubuo. ");
INSERT INTO bqp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Akũ Lea pì: Ma pↄ kɛ̀ nna, zaakũ nↄgbɛ̃nↄ ni pi pↄnnaden ma ũ. Akũ à tↄ́ kpànɛ Asa. ");
INSERT INTO bqp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Rubɛni bò ésekɛ̃gↄrↄa à yenyĩ ɛzɛ è sɛ̃̀n, akũ à bòbo à sùo a da Leanɛ. Akũ Rahila pìnɛ: Ǹ n nɛ́ yenyĩ ɛzɛ pì dãmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea pìnɛ: Kũ n ma gↄ̃ sìma, abire dí mↄ́mmaro, akũ ń ye ǹ ma nɛ́ yenyĩ ɛzɛ sí dↄ yá? Rahila pì: Tó n kpàma, mↄkↄ̃mmɛ ĩni i kãao gbãra. ");
INSERT INTO bqp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kũ Yakubu tɛn su kũ burao ↄkↄsi, Lea bò à gɛ̀ɛ à dàalɛ à pì: Makũmɛ mani wutɛ kũnwo gbãra, zaakũ ma n sãkã ma nɛ́ yenyĩ ɛzɛ yãimɛ. Akũ à ì kãao gwãani birea. ");
INSERT INTO bqp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Luda Lea wɛ́kɛ sì, akũ à nↄ̀ↄ sì à Sãani ì kũ Yakubuo. ");
INSERT INTO bqp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Akũ Lea pì: Luda láada kpàma, kũ ma a zĩkɛrii kpà ma zãa yãi. Akũ à tↄ́ kpànɛ Isaka. ");
INSERT INTO bqp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea ɛ̀ra à nↄ̀ↄ sì dↄ à Tori ì, ");
INSERT INTO bqp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","akũ à pì: Luda gba mana dàmɛnɛ. Adikĩna sà ma zã ni ma kpe ta, zaakũ ma nɛ́gↄ̃gbɛ̃nↄ ì kãao mɛ̀n suddo. Akũ à tↄ́ kpànɛ Zɛbuluni. ");
INSERT INTO bqp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kũ à kɛ̀ saa à nɛ́nↄgbɛ̃ ì, akũ à tↄ́ kpànɛ Dina. ");
INSERT INTO bqp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Akũ Rahila yã dↄ̀ Ludan à a wɛ́kɛ sì, akũ à kɛ̀ nɛ́rande ũ. ");
INSERT INTO bqp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","À nↄ̀ↄ sì à nɛ́gↄ̃gbɛ̃ ì, akũ à pì: Luda wé'i bòmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Akũ à tↄ́ kpànɛ Yusufu à pì: Dikiri ɛra à nɛ́gↄ̃gbɛ̃ pãnde karamɛnɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kũ Rahila Yusufu ì, Yakubu pì Labãnɛ: Ǹ ma gbarɛ mà tá ma bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ma zĩ kɛ̀nnɛ ma nↄnↄ kũ ma nɛ́nↄ yãi. Ǹ ń kpáma mà tá, zaakũ ń dↄ̃ lákũ ma zĩ kɛ̀nnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Akũ Labã pìnɛ: Tó ma n pↄnna lè, ǹ gↄ̃ kũmao la. Ma màsoo kɛ̀ ma è Dikiri arubarikaa kɛ̀magu n yãi. ");
INSERT INTO bqp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ǹ n làada omɛnɛ, mani kpámma. ");
INSERT INTO bqp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakubu pìnɛ: Ń dↄ̃ lákũ ma zĩ kɛ̀nnɛ nà. Ń dↄ̃ lákũ n pↄ́kãdenↄ kɛ̀ ma ↄĩ nà, ");
INSERT INTO bqp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","zaakũ a fíti kũ ń vĩ zaade mádi suro kàra manamana. Dikiri arubarikaa dàngu gu kũ ma gɛn n bɛa pínki. Bↄrɛn mani ma zĩda bɛ zĩ kɛ sↄ̃ↄ? ");
INSERT INTO bqp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labã à là à pì: Bↄ́n mani fĩna boonnɛɛ? Yakubu wèa à pì: Ǹsun pↄ́ke kpámaro, ama ǹ yã dí kɛmɛnɛ, manigↄ̃ n pↄ́nↄ dãnnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ǹ tó mà gɛ̃ n pↄ́nↄ tɛ́ gbãra mà sã bakibakinↄ kũ a totontotonnↄ plɛplɛ ma làada ũ kũ sãnɛ bↄ̀rↄ siranↄ kũ blè bakibakinↄ kũ a totontotonnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tó n ma làadaa gwà gɛna gↄrↄ arɛ, ĩni dↄ̃ tó má yãpura vĩ. Blè kũ à kun bakibakiro akũ à totontotonlo, ke sãnɛ bↄ̀rↄ kũ à siraro, ɛ̃hɛ̃ ma kpãni òmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labã pì: Tↄ̀! Àgↄ̃ de lákũ n ò nà. ");
INSERT INTO bqp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Zĩ kũ̀a Labã a blèkofĩni bakibakinↄ sɛ̀ kũ a wãnzãndenↄ kũ blèda totontotonnↄ kũ a bakibakinↄ, pↄ́ kũ ò pura vĩnↄ pínki kũ sãnɛ bↄ̀rↄ siranↄ pínki, à ń ná a nɛ́gↄ̃gbɛ̃nↄnɛ ń ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Akũ à zàaa bò ń dagura kũ Yakubuo lán gↄrↄ aakↄ̃ tá bà, akũ Yakubu tɛn Labã pↄ kparanↄ dã. ");
INSERT INTO bqp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakubu lí buri aakↄ̃ gã̀ búsunↄ zↄ̃̀zↄ̃ à ń wãnzãn kpàkpa à ń wãnzãn kɛ̀ púu. ");
INSERT INTO bqp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Akũ à lí kũ à ń wãnzãn kɛ̀aa pìnↄ pɛ̀tɛpɛtɛ pↄ́nↄ gó ímibↄnↄ gũn, pↄ́ kũ òtɛn su í minↄ wɛ́n, zaakũ gwen òdi kpákpa on. ");
INSERT INTO bqp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tó ò kpákpa ò lí pìnↄ sarɛ, akũ òdigↄ̃ nɛ́ wãnzãndenↄ i kũ a totontotonnↄ kũ a bakibakinↄo. ");
INSERT INTO bqp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakubu dì pↄ́nɛ pìnↄ plɛplɛ adona àdi a wãnzãndenↄ kũ a siranↄ ká Labã pↄ́nↄ gũn. Lɛmɛ à a zĩda kpàsaa bò lɛ, adi ká Labã pↄ́nↄ gũnlo. ");
INSERT INTO bqp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tó pↄ́buri mananↄ fùtɛ kũ kpákpa'onaao, Yakubu dì lí pìnↄ pɛ́tɛpɛtɛ pↄ́nↄ arɛ gó ímibↄↄ pìnↄ gũn, de ò kpákpa o ń sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tó pↄ ginanↄmɛ sↄ̃, àdi lí pɛ́tɛpɛtɛńnɛro. Lɛn pↄ ginanↄ gↄ̃̀ Labã pↄ́ ũ lɛ, akũ pↄ́buri mananↄ gↄ̃̀ Yakubu pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Akũ Yakubu aruzɛkɛ dìgↄ̃ kara manamana, a pↄ́nↄ dasi kũ̀ kũ nↄgbɛ̃ zĩkɛrinↄ kũ gↄ̃gbɛ̃ zĩkɛrinↄ kũ lakuminↄ kũ zaakinↄo. ");
INSERT INTO bqp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakubu yã kũ Labã nɛ́nↄ tɛn o mà kũ ò pì: Yakubu ó de pↄ́nↄ sìa pínki. Ó de aruzɛkɛ gũnn à karanaa lèn. ");
INSERT INTO bqp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakubu dↄ̃̀ Labã wɛ́a, kũ a yã kú a nɛ̀sɛn lán yã bà doro. ");
INSERT INTO bqp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Akũ Dikiri pìnɛ: Ǹ ɛra ǹ tá n dizi bùsun n danɛnↄ bɛa, manigↄ̃ kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Akũ Yakubu Rahila kũ Leaoo sìsi ò mↄ́ a pↄ́nↄ kĩnaa sɛ̃̀n. ");
INSERT INTO bqp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","À pìńnɛ: Ma dↄ̃̀ á de wɛ́a kũ ma yã kú a nɛ̀sɛn lán yã bà doro. Bee kũ abireo ma de Luda kú kũmao. ");
INSERT INTO bqp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Á dↄ̃ á zĩdanɛ kũ ma zĩ kɛ̀ á denɛ ma gbãna lɛ́mmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Á de ↄ̃ndↄ̃ kɛ̀mɛnɛ, à ma làadaa lìtɛ gɛ̃̀n kuri, akũ Luda dí tó à yãke kɛ̀mɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tó à pì sã bakibakinↄmɛ ma baka ũ, sãnↄ dìgↄ̃ nɛ́ bakibakinↄ i. Tó à pì a wãnzãndenↄmɛ ma baka ũ, sãnↄ dìgↄ̃ nɛ́ wãnzãndenↄ i. ");
INSERT INTO bqp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Luda á de sãnↄ sìa à kpàma. ");
INSERT INTO bqp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Gↄrↄ kũ blènↄ tɛn kpákpa o, ma nana ò, akũ nana gũn ma è blèkofĩni kũ òtɛn kpákpa onↄ bi blè wãnzãndenↄmɛ kũ a bakibakinↄ kũ a totontotonnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Akũ Luda Malaikaa pìmɛnɛ nana pìi gũn: Yakubu! Akũ ma wea ma pì: Makũ di! ");
INSERT INTO bqp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","À pì: Ǹ wɛ́ sɛ́ ǹ gwa. Blèkofĩni kũ òtɛn kpákpa onↄ pínki blè wãnzãndenↄmɛ kũ a bakibakinↄ kũ a totontotonnↄo, zaakũ ma yã kũ Labã kɛ̀nnɛ è pínki. ");
INSERT INTO bqp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Makũmɛ Luda kũ à bò à sùnyĩ Bɛtɛli ũ, gu kũ n gbɛ̀ɛ pɛ̀tɛn n nísi kùa n lɛ́ kɛ̀ma. Tera sà ǹ futɛ ǹ bo bùsu dín ǹ tá n bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Akũ Rahila kũ Leaoo pìnɛ: Ó túbi vĩ ó de bɛa dↄ yá? ");
INSERT INTO bqp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Adi ó ditɛ gbɛ̃ zĩ̀tↄnↄ ũnloo? A ó yíamma, akũ à a ↄgↄ blè pínki. ");
INSERT INTO bqp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Aruzɛkɛ kũ Luda sì ó dea gↄ̃̀ ó pↄ́ ũ pínkimɛ kũ ó nɛ́nↄ. Ǹ yã kũ Luda ònnɛ kɛ pínki sà. ");
INSERT INTO bqp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Akũ Yakubu fùtɛ à a nɛ́nↄ kũ a nↄnↄ dì lakuminↄ kpɛ. ");
INSERT INTO bqp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","À a pↄ́kãdenↄ kũ aruzɛkɛ kũ à lè Mɛsↄpↄtamianↄ sɛ̀tɛ pínki, akũ à dà zɛ́n àtɛn tá a de kĩnaa Kanaanↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kũ Labã gɛ̀ɛ a sãnↄ kã zↄ̃zↄ̃, akũ Rahila a tãnanↄ sɛ̀ kpãni a kpɛ. ");
INSERT INTO bqp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakubu sↄ̃ à ↄ̃ndↄ̃ kɛ̀ Siria buri Labãnɛ adi lɛ́ zaaro. ");
INSERT INTO bqp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","À fùtɛ à bàa lɛ̀ kũ a pↄ́nↄ pínki à bikũ̀ Yuflatia, akũ à mìi pɛ̀ Giliada gusĩsĩdea. ");
INSERT INTO bqp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A gↄrↄ aakↄ̃de zĩ ò pì Labãnɛ Yakubu bàa lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","À a gbɛ̃nↄ kàkara, akũ à pɛ̀tɛi. À táa ò gↄrↄ suppla, akũ à a lè Giliada gusĩsĩden. ");
INSERT INTO bqp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Akũ Luda bò à sùa gwãani nana gũn à pìnɛ: Ǹ laakari kɛ yã kũ ĩni o Yakubunɛi a mana ke a vãni. ");
INSERT INTO bqp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labã Yakubu bùra lè katɛna Giliada gusĩsĩden, akũ à bùra kàtɛ gwe kũ a gbɛ̃nↄo se. ");
INSERT INTO bqp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Akũ Labã gɛ̀ɛ à pì Yakubunɛ: Bↄ́yãi n ↄ̃ndↄ̃ kɛ̀mɛnɛ n ma nɛ́nↄ sɛ̀tɛ n ta kũńwo lán zĩ̀zↄnↄ bàa? ");
INSERT INTO bqp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Bↄ́yãi n ↄ̃ndↄ̃ kɛ̀mɛnɛ n woto kpãni ńdi lɛ́ zamaro, de ma gɛ zɛnnɛ kũ pↄnnakɛnaao kũ lɛ̀sinaao kũ gã̀gãao kũ mↄrↄↄo. ");
INSERT INTO bqp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ńdi tó ma lɛ́ zà ma nɛ́nↄ kũ ma daikorenↄaro. N yↄ̃nkↄyã kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ma gbãna kà mà yã vãni kɛárɛ, akũ n de Luda yã òmɛnɛ gwãani à pì mà laakari kɛ yã kũ mani onnɛi a mana ke a vãni. ");
INSERT INTO bqp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ntɛn tá sà, kũ ntɛni n de bɛ bɛgɛ kɛ yãi. À kɛ̀ dera n ma tãnanↄ sɛ̀ kpãnii? ");
INSERT INTO bqp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakubu wèa à pì: Ma vĩna kɛ̀, matɛn da ĩni n nɛ́nↄ símamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Gbɛ̃ kũ n n tãnanↄ lè a kĩnaa, ò a dɛ. Ǹ ma pↄ́nↄ gwagwa ó gbɛ̃nↄ wára. Tó n n pↄ́ lè, ǹ sɛ́. Yakubu sↄ̃, à dↄ̃ kũ Rahila Labã pↄ́ sɛ̀ kpãniro. ");
INSERT INTO bqp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labã gɛ̃̀ Yakubu bizakutan à gɛ̃̀ Lea kutan à gɛ̃̀ nↄgbɛ̃ zĩkɛri mɛ̀n pla pìnↄ kutan, adi pↄ́ke lero. Kũ à bò Lea kutan, à gɛ̃̀ Rahila kutan. ");
INSERT INTO bqp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahila tãna pìnↄ sɛ̀ à ùtɛ lakumi gàarii gũmmɛ, akũ à vùtɛa. Labã a kuta gũn gwàgwa pínki, adi pↄ́ke lero. ");
INSERT INTO bqp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahila pì a denɛ: Baa, ǹsun pↄ fɛ̃mairo, zaakũ mádi le mà futɛro kũ má ↄ kũna yãi. Lɛmɛ Labã a tãnanↄ wɛ̀tɛ lɛ adi lero. ");
INSERT INTO bqp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Akũ Yakubu pↄ pà à lɛ́fↄtↄ kà Labãi à pì: Bↄ́ dàan ma kɛ̀ɛ? Bↄ́ durunnan ma kɛ̀ akũ n pɛtɛmai wãnawãna lán dí bàa? ");
INSERT INTO bqp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kũ n ma pↄ́nↄ gwàgwa pínki, n n bɛ pↄ́nↄ lè gwe yá? Ǹ boo gupuraa ma gbɛ̃nↄ kũ n gbɛ̃nↄ wára, ò yã nna kpá gbɛ̃ kũ a yã nnaa. ");
INSERT INTO bqp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ma kɛ n bɛ wɛ̃̀ baro. N sãnↄ kũ n blènↄ dí nↄ̀ bↄtɛro, mádi n sã ke sóro. ");
INSERT INTO bqp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mádi sunnɛ kũ pↄ́ kũ nↄ̀bↄ pãsĩnↄ kũ̀ keoro, madì a fĩna bonnɛ ma zĩdamɛ. Ndì pↄ́ kũ ò a kpãni ò gwãani ke fãnantɛ̃ fĩna lama. ");
INSERT INTO bqp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ifãntɛ̃ dì ma lɛ fãnantɛ̃, ĩa dì ma dɛ gwãani, madì itɛ̃ kɛ. ");
INSERT INTO bqp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Lɛn ma kɛ n bɛa lɛ ari wɛ̃̀ baro. Wɛ̃̀ gɛ̃ro donsari ma zĩ kɛ̀nnɛ n nɛ́nↄgbɛ̃ gbɛ̃nↄn planↄ yãi. Ma wɛ̃̀ suddo kɛ̀ n kpàsa yã musu. N ma làadaa lìtɛ gɛ̃̀n kuri. ");
INSERT INTO bqp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tó adi kɛ ma dizi Ibrahĩ Luda kũ ma de Isaaku a vĩna vĩ zɛ̀ kũmao baasiro, de n ma gbarɛ ↄkori. Luda zĩ kũ ma kɛ̀ kũ warioo è, akũ à kpã̀kɛ̃nyĩ gĩa gwãani. ");
INSERT INTO bqp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Akũ Labã wè Yakubua: Nↄgbɛ̃ díkĩnanↄ bi ma nɛ́nↄmɛ. Nɛ́ díkĩnanↄ sↄ̃ ma daikorenↄmɛ. Pↄ́kãde díkĩnanↄ sↄ̃ ma pↄ́kãdenↄmɛ. Pↄ́ kũ n è la pínki ma pↄ́mɛ. Bↄ́n mani kɛ ma nɛ́nↄgbɛ̃nↄ kũ nɛ́ kũ ò ìnↄnɛ gbãraa? ");
INSERT INTO bqp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ǹ tó ò lɛ́dokↄ̃nↄ kɛ àgↄ̃ de sèeda ũ ó dagura. ");
INSERT INTO bqp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Akũ Yakubu gbɛ̀ɛ sɛ̀ à pɛ̀tɛ yã pì dↄngupↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","À pì a gbɛ̃nↄnɛ ò gbɛ̀nↄ sɛ́tɛ, akũ ò sɛ̀tɛ ò dìdikↄ̃a, akũ ò pↄ́ blè a sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Akũ Labã tↄ́ kpà gbɛ̀didikↄ̃anaa pìinɛ Yega Saduta. Yakubu tↄ́ kpànɛ Galɛdi. ");
INSERT INTO bqp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labã pì: Gbɛ̀didikↄ̃ana díkĩnamɛ sèeda ũ ó dagura gbãra. Abire yãi ò tↄ́ kpànɛ Galɛdi. ");
INSERT INTO bqp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Òdi pi dↄ Mizipa, zaakũ Labã pì: Dikiri ó dãkpã ó kɛ̃kↄ̃anaa gbɛra de òsun zãkↄ̃nlo yãi. ");
INSERT INTO bqp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tó n wari dↄ̀ ma nɛ́nↄgbɛ̃nↄa ke tó n nↄ pãndenↄ sɛ̀ dↄ, bee tó ó kú kↄ̃ kĩnaaro, ǹgↄ̃ dↄ̃ sãnsãn kũ Ludan ó yã pìi sèedade ũ. ");
INSERT INTO bqp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Akũ Labã pìnɛ dↄ: Ǹ gbɛ̀didikↄ̃ana díkĩna gwa kũ gbɛ̀ kũ ma pɛ̀tɛ ó dagurao. ");
INSERT INTO bqp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Anigↄ̃ de sèeda ũ kũ mani vĩala mà su mà a vãni kɛnnɛro, mↄkↄ̃n sↄ̃ ĩni vĩala ǹ su ǹ a vãni kɛmɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibrahĩ kũ Naoo kũ ń deo Ludamɛ ó yãkpatɛkɛri ũ. Akũ Yakubu la dà kũ Luda kũ a de Isaaku a vĩna vĩ tↄ́o. ");
INSERT INTO bqp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","À sa ò gusĩsĩden gwe, akũ à a gbɛ̃nↄ sìsi ò pↄ́ ble. Kũ ò pↄ́ blè, akũ ò ì gwe. ");
INSERT INTO bqp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Labã fùtɛ kↄnkↄkↄnkↄ, à lɛ́ zà a daikorenↄa kũ a nɛ́nↄ à sa mana òńnɛ, akũ à ɛ̀ra à tà a bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakubu dà zɛ́n, akũ Luda malaikanↄ dàalɛ. ");
INSERT INTO bqp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kũ à ń é, à pì: Luda bùraan dí. Akũ à tↄ́ kpà gu pìinɛ Manaimu. ");
INSERT INTO bqp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","À zĩ̀rinↄ zĩ̀ a arɛ a vĩ̀ni Isaua Sei bùsu kũ ò pi dↄ Ɛdↄmu bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","À pì a zĩ̀rinↄnɛ: À gɛ́ à o ma dikiri Isaunɛ a zↄ̀bleri Yakubu gↄrↄ pla kɛ̀ Labã bɛa àtɛn su sà. ");
INSERT INTO bqp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","À onɛ má zùnↄ vĩ kũ zaakinↄ kũ sãnↄ kũ blènↄ kũ gↄ̃gbɛ̃ zĩkɛrinↄ kũ nↄgbɛ̃ zĩkɛrinↄo. Makũ mɛ́ ma á zĩ à onɛ de ma a pↄnna le. ");
INSERT INTO bqp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kũ zĩ̀rinↄ ɛ̀ra ò sù Yakubu kĩnaa, ò pì: O gɛ n vĩ̀ni kĩnaa, àtɛn su à danlɛ kũ gbɛ̃nↄn wàa planↄ. ");
INSERT INTO bqp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vĩna Yakubu kũ̀ àtɛn bídi kɛ manamana, akũ à gbɛ̃ kũ ò kú kãaonↄ kpàatɛ lɛu pla kũ sãnↄ kũ blènↄ kũ zùnↄ kũ lakuminↄo à pì: ");
INSERT INTO bqp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tó Isau sù à sì a lɛu doa, a lɛu do kũ à gↄ̃̀ ni bo. ");
INSERT INTO bqp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Akũ à adua kɛ̀ à pì: Dikiri, ma dizi Ibrahĩ kũ ma de Isaakuoo Luda, n òmɛnɛ mà su ma bùsun ma danɛnↄ kĩnaa, ĩni arubarika damagu. ");
INSERT INTO bqp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","N gbɛ̃kɛ kũ náani yãoo kɛ̀mɛnɛ manamana, ma bɛ̀ɛrɛ dí káro. Gↄrↄ kũ ma bikũ Yodaa, gò mɛ́ à na ma ↄĩ ado. Tera sà ma su kũ aruzɛkɛ lɛu pla díkĩnanↄ. ");
INSERT INTO bqp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ma wɛ́ kɛ̀mma ǹ ma sí ma vĩ̀nia, zaakũ matɛn vĩna kɛnɛ kũ ani sí ó tɛ́ à nↄgbɛ̃nↄ kũ nɛ́nↄ dɛdɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mↄkↄ̃n sↄ̃, n pì ĩni arubarika damagu ĩni ma buri kara lán ísiralɛ bùsu'atɛ̃ bà oni fↄ̃ ń naroro ń dasi yãi. ");
INSERT INTO bqp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Gwen Yakubu ìn. Pↄ́ kũ à plɛ̀plɛ à a vĩ̀ni gbanↄn dí: ");
INSERT INTO bqp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Blèda mɛ̀n wàa do, a kofĩni mɛ̀n baro, sãda mɛ̀n wàa do, a karo mɛ̀n baro, ");
INSERT INTO bqp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","lakumida mɛ̀n baraakuri kũ ń nɛ́ bↄ̀rↄnↄ, zùda mɛ̀n bupla, a sà mɛ̀n kuri, zaakida mɛ̀n baro, a sà mɛ̀n kuri. ");
INSERT INTO bqp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","À ń ná a zĩkɛrinↄnɛ ń ↄĩ buri kũ burio, akũ à pìńnɛ: Àgↄ̃ tɛ́ ma arɛ à kpango da á dagura gã̀ kũ gã̀ao. ");
INSERT INTO bqp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","À pì gbɛ̃ káakunɛ: Tó ma vĩ̀ni dànlɛ à n la à pì: Dímɛ n dikiri ũu? Ntɛn gɛ́ mámɛɛ? Dí mɛ́ à pↄ́ kũ ntɛn dã dínↄ vĩi? ");
INSERT INTO bqp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ǹ onɛ a zↄ̀bleri Yakubu pↄ́mɛ, pↄ́ kũ à a dikirii gbà à kpã̀zãnɛnↄn gwe, àpii tɛn su kpɛ. ");
INSERT INTO bqp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","A yã dokↄ̃nↄ pìi ò gbɛ̃ pladenɛ kũ gbɛ̃ aakↄ̃deo kũ pↄ́dãrinↄ ń pínki à pì: Tó a da Isaulɛ, à onɛ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","À onɛ a zↄ̀bleri Yakubu tɛn su kpɛ. Zaakũ à laasun lɛ̀ à pì: Mani a laakari kpátɛ kũ pↄ́ kũ ma kpà arɛ dínↄ, óni wɛ́ sikↄ̃lɛ. Ani gí gbãnakɛ kpámai sà yá? ");
INSERT INTO bqp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gba pìnↄ dònɛ arɛ, akũ à gↄ̃̀ bùran gwãani kũ̀a à ì gwe. ");
INSERT INTO bqp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","À fùtɛ gwãani à a nↄ mɛ̀n planↄ sɛ̀tɛ kũ a nↄgbɛ̃ zĩkɛri mɛ̀n planↄ kũ a nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn kuri awɛɛdonↄ, akũ à bikũ̀ kũńwo Yaboku bikũkia. ");
INSERT INTO bqp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kũ à bikũ̀ kũńwo, akũ à pↄ́ kũ à vĩnↄ sɛ̀tɛ à bikũ̀o pínki. ");
INSERT INTO bqp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakubu gↄ̃̀ ado, akũ gↄ̃gbɛ̃ ke sù àtɛn ↄsi ká kãao ari gu kà dↄna. ");
INSERT INTO bqp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kũ gↄ̃gbɛ̃ pìi è áni fↄ̃ à a nɛ́ro, à a lɛ̀ a gisipɛkɛrɛkia, akũ a gisi bòkũn ↄsikanaa pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Gↄ̃gbɛ̃ pìi pì: Ǹ ma gbarɛ, zaakũ gu tɛn dↄ. Akũ Yakubu pìnɛ: Tó adi kɛ ǹ arubarika damagu baasiro, mani n gbarɛro. ");
INSERT INTO bqp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Gↄ̃gbɛ̃ pì a là à pì: N tↄ́n deraa? À wèa à pì: Ma tↄ́n Yakubu. ");
INSERT INTO bqp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Akũ à pì: Oni pinnɛ Yakubu doro, séde Isaraila, zaakũ n ↄsi kà kũ Ludao kũ bisãsirinↄ, akũ n ↄsi nɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakubu pìnɛ: Ǹ n tↄ́ omɛnɛ se. A wèa à pì: Bↄ́yãi ntɛni ma tↄ́ gbɛkaa? Akũ à arubarikaa dàn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakubu tↄ́ kpà gu pìinɛ Pɛniɛli, zaakũ à pì: O wɛ́ sìkↄ̃lɛ kũ Ludao, akũ mádi garo. ");
INSERT INTO bqp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","À bò Pɛniɛli ifãntɛ̃bona àtɛn tↄ̃ↄtɛ a gisi wãwã yãi. ");
INSERT INTO bqp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","A yã mɛ́ à tò ari gbãra Isarailanↄ dì nↄ̀bↄ tugisi sóro, kũ Luda Yakubu lɛ̀ a tugisia yãi. ");
INSERT INTO bqp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kũ Yakubu wɛ́ sɛ̀, à è Isau tɛn su kũ gbɛ̃nↄn wàa planↄ. À a nɛ́nↄ kpàatɛtɛ Leanɛ kũ Rahilao kũ nↄgbɛ̃ zĩkɛri mɛ̀n planↄ. ");
INSERT INTO bqp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Akũ à nↄgbɛ̃ zĩkɛrii pìnↄ gbàrɛ ò do arɛ kũ ń nɛ́nↄ. Abire gbɛra Lea kũ a nɛ́nↄ, akũ Rahila kũ Yusufuo tɛ́ ń kpɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","À dòńnɛ arɛ à kùtɛ zĩtɛ gɛ̃̀n suppla ari à gɛ̀ɛ à kào a vĩ̀ni pì kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Akũ Isau bàa lɛ̀ à sù à dàalɛ à mlɛ̃̀a à ↄ dà a gã̀n à lɛ́ pɛ̀a, akũ ò ↄ́ↄ dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Isau wɛ́ sɛ̀ à nↄgbɛ̃nↄ è kũ nɛ́nↄ, akũ à pì: Dínↄ mɛ́ ò kú kũnwo laa? Yakubu wèa à pì: Nɛ́ kũ Luda ma gbanↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Akũ nↄgbɛ̃ zĩkɛrii pìnↄ nàńyĩ kũ ń nɛ́nↄ ò kùtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Akũ Lea kũ a nɛ́nↄ nàńyĩ dↄ ò kùtɛ. Abire gbɛra Yusufu kũ Rahilao nàńyĩ ò kùtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isau pì: Pↄ́ kũ ma dańlɛ dínↄ de deramɛɛ? Yakubu wèa à pì: De mà n pↄnna le yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Isau pì: Ma gbɛ̃, ma pↄ́nↄ mↄ̀ma, ǹgↄ̃ n pↄ́nↄ kũna. ");
INSERT INTO bqp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Akũ Yakubu pì: Oi! N yã nna! Tó ma n pↄnna lè, ǹ ma gba sí, zaakũ ó wɛ́sikↄ̃lɛnaa kɛ̀mɛnɛ lán wɛ́sikↄ̃lɛna kũ Ludaoo bàmɛ, akũ n gbãnakɛ kpàmai. ");
INSERT INTO bqp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ǹ gba kũ ma suonnɛ sí, zaakũ Luda arubarikaa dàmagu, pↄ́ke dí kĩamaro. Lɛmɛ à nàkaraa lɛ, akũ à sì. ");
INSERT INTO bqp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Akũ Isau pì: Ò da zɛ́n ò tá. Mani gɛ́ kũnwo. ");
INSERT INTO bqp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Akũ à wèa à pì: Ma dikiri, ń dↄ̃ kũ nɛ́nↄn gbãna vĩro, akũ má sã kũ zùnɛ bↄ̀rↄnↄ vĩ. Tó o tá gbãna ò gↄrↄ do, pↄ́kãdenↄ ni gaga pínkimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ǹ domɛnɛ arɛ ma dikiri, makũ n zↄ̀bleri manigↄ̃ tɛ́ pↄ́nↄ kpɛ kũ nɛ́nↄ busɛbusɛ ari mà su mà n le Sei. ");
INSERT INTO bqp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Isau pì: Mani ma gbɛ̃kenↄ tó kũnwo. Yakubu pì: À kɛ̀ dera ĩni kɛ lɛ dↄↄ? Ǹ tó mà n pↄnna le dikiri. ");
INSERT INTO bqp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Zĩ kũ̀an Isau dà Sei zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Akũ Yakubu gɛ̀ɛ Suko. À bɛ bò gwe, akũ à lá kutanↄ dↄ̀ pↄ́nↄnɛ. A yã mɛ́ à tò, ò tↄ́ kpà gu pìinɛ Suko. ");
INSERT INTO bqp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kũ Yakubu sù kũ Mɛsↄpↄtamiao, à kà wɛ̃tɛ kũ òdi pinɛ Sɛkɛmu, Kanaanↄ bùsun aafia, akũ à bùraa kàtɛ wɛ̃tɛ pìi sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","À a bùrakũki lù Sɛkɛmu de Amↄ nɛ́nↄa andurufu basↄↄro. ");
INSERT INTO bqp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Gwen à sa'oki bòn, à tↄ́ kpànɛ Luda Isarailanↄ Luda. ");
INSERT INTO bqp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lea nɛ́nↄgbɛ̃ Dina kũ à ì kũ Yakubuo bò à wɛ́ kpátɛ bùsuu pì nↄgbɛ̃nↄi. ");
INSERT INTO bqp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kũ bùsuu pì kína Amↄ nɛ́ Sɛkɛmu, Ivi buri a è, à a sɛ̀ kũ gbãnao, akũ à wùtɛ kãao. ");
INSERT INTO bqp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","A pↄ dↄ nↄkpare pìia à yei, akũ à yã nnanna ònɛ. ");
INSERT INTO bqp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Akũ Sɛkɛmu pì a denɛ: Ǹ nɛ́nↄkpare bire wɛtɛmɛnɛ mà sɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kũ Yakubu mà ò a nɛ́nↄgbɛ̃ kpe bò, a nɛ́nↄn kú sɛ̃̀n kũ a pↄ́kãdenↄ, akũ à yĩ̀tɛ ari ò sù. ");
INSERT INTO bqp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Akũ Sɛkɛmu de Amↄ gɛ̀ɛ à Yakubu le à yã pì onɛ. ");
INSERT INTO bqp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kũ Yakubu nɛ́nↄ bò sɛ̃̀n ò sù, akũ ò yã pìi mà gↄ̃̀nↄ. Ń nɛ̀sɛɛ yàka ò pↄ fɛ̃̀ manamana, kũ Sɛkɛmu wé'iyã kɛ̀ Isarailanↄnɛ yãi, à wùtɛ kũ Yakubu nɛ́nↄgbɛ̃o à yã kũ à de ò kɛro kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Akũ Amↄ pìńnɛ: Ma nɛ́ Sɛkɛmu pↄ dↄ á nɛ́nↄgbɛ̃a. Á yã nna. À a kpáa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ò lɛ́dokↄ̃nↄ kɛ ògↄ̃ ó nɛ́nↄgbɛ̃nↄ kpãzãkↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Àgↄ̃ kú kũoo, ó bùsu kun á pↄ́ ũmɛ. À vutɛn àgↄ̃ laga tán àgↄ̃ zĩtɛ vĩ. ");
INSERT INTO bqp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Akũ Sɛkɛmu ò Dina de kũ a dãgↄ̃nↄnɛ à pì: À tó mà á pↄnna le. Pↄ́ kũ a pi mà kpááwa mani kpá. ");
INSERT INTO bqp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","À anzureblebↄ lɛ́ damɛnɛ zↄ̃kↄ̃ kũ gbanↄ dasidasi. Pↄ́ kũ a ò mani kpá. À nɛ́nↄkpare pì kpáma nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Akũ Yakubu nɛ́nↄ wè Sɛkɛmu kũ a de Amↄooa kũ manafikio kũ Sɛkɛmu ń dãre kpe bò yãi. ");
INSERT INTO bqp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ò pìńnɛ: Óni fↄ̃ ò abire kɛro, óni fↄ̃ ò ó dãre kpá gyↄfↄrↄdearo, zaakũ wé'iyãmɛ ó kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Óni we á yãiro, séto à gↄ̃ lán ó bà á gↄ̃gbɛ̃nↄ tↄ̃̀ zↄ̃ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tó a tↄ̃̀ↄ zↄ̃̀, óni ó nɛ́nↄ kpãzãáwa óni á nɛ́nↄ sɛ́ nↄ ũ. Ónigↄ̃ kú kãáo, óni gↄ̃ buri dokↄ̃nↄnↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ama tó ádi we ó yãiro, tó ádi tↄ̃̀ zↄ̃ro, óni ó dãre sɛ́ ò tá kãaomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yã pìi kɛ̀ Amↄ kũ a nɛ́ Sɛkɛmuoonɛ nna. ");
INSERT INTO bqp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kɛfɛnna pì yã pìi gↄ̃̀gↄ̃ likalika, kũ Yakubu nɛ́nↄgbɛ̃ yã kànɛ yãi. À bɛ̀ɛrɛ vĩ deńla a de bedenↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amↄ kũ a nɛ́ Sɛkɛmuo gɛ̀ɛ ń wɛ̃tɛ bĩnilɛa, akũ ò yã ò kũ wɛ̃tɛdenↄ ò pì: ");
INSERT INTO bqp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Gbɛ̃ pìnↄ yãke vĩ kũooro. Ò tó ògↄ̃ kú ó bùsun ògↄ̃ laga tá, zaakũ bùsuu pìi yàasa ani mↄ́wá. Óni ń nɛ́nↄgbɛ̃nↄ sɛ́ óni ó nɛ́nↄ kpáḿma. ");
INSERT INTO bqp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Gbɛ̃ pìnↄ sↄ̃, oni we ògↄ̃ kú kũoo de ò gↄ̃ buri dokↄ̃nↄ ũro, séto adi kɛ ó gↄ̃gbɛ̃ sĩnda pínki tↄ̃̀ↄ zↄ̃̀ lán ń bà baasiro. ");
INSERT INTO bqp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ń pↄ́kãdenↄ kũ ń aruzɛkɛnↄ kũ ń zùnↄ pínki ni gↄ̃ ó pↄ́ ũroo? Ò weńnɛ de ògↄ̃ kú kũoo. ");
INSERT INTO bqp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wɛ̃tɛpidenↄ Amↄ kũ a nɛ́ Sɛkɛmuo yã mà, akũ ń gↄ̃gbɛ̃nↄ tↄ̃̀ↄ zↄ̃̀ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A gↄrↄ aakↄ̃de zĩ, kũ ò kú kũ wãwão ò kú kũ yãke laasunnworo, Yakubu nɛ́ gbɛ̃nↄn planↄ Simɛↄ kũ Levio, Dina vĩ̀ninↄ, ń baadi a fɛ̃nɛda sɛ̀ ò sì wɛ̃tɛn ò gↄ̃gbɛ̃nↄ dɛ̀dɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ò Amↄ kũ a nɛ́ Sɛkɛmuoo dɛ̀dɛ, akũ ò Dina sɛ̀ ò bòo Sɛkɛmu kpɛ́n ò tà kãao. ");
INSERT INTO bqp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wɛ̃tɛdenↄ dɛdɛnaa gbɛra Yakubu nɛ́nↄ sù ò wɛ̃tɛ pↄ́nↄ nàkↄ̃a kũ ò wé'i dà ń dãrea yãi. ");
INSERT INTO bqp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ò ń sãnↄ kũ ń blènↄ sɛ̀tɛ kũ ń zùnↄ kũ ń zaakinↄ, pↄ́ kũ ò kú wɛ̃tɛ gũnnↄ kũ pↄ́ kũ ò kú ń buranↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ò ń aruzɛkɛnↄ sɛ̀tɛ pínki kũ ń nɛ́nↄ kũ ń nↄgbɛ̃nↄ kũ pↄ́ kũ ò kú ń bɛanↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Akũ Yakubu pì Simɛↄnɛ kũ Levio: A sumɛnɛ kũ yã vãnio. Kanaanↄ kũ Pɛrizinↄ kũ bùsu díkĩna buri pãndenↄ nigↄ̃ ye ma kãiro. Lákũ ó dasiro nà, tó ò lìkawái, tó ò sìógu, oni ma dɛ kũ ma burinↄo pínki. ");
INSERT INTO bqp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Akũ ò wèa ò pì: Kũ à ó dãre dìtɛ karua ũ, abire manan gwe yá? ");
INSERT INTO bqp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Luda pì Yakubunɛ: Ǹ futɛ ǹ tá Bɛtɛli ǹ vutɛ gwe. Ǹ ma gbagbaki bo gwe, zaakũ ma bo ma summa gwe gↄrↄ kũ ntɛn bàa lɛ́ n vĩ̀ninɛ. ");
INSERT INTO bqp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Akũ Yakubu pì a ↄndenↄnɛ kũ gbɛ̃ kũ ò kú kãaonↄ ń pínki: À buri zĩ̀tↄnↄ tãna kũ á vĩnↄ kↄ́tɛ à zú o à á pↄ́kasanↄ lilin kɛ. ");
INSERT INTO bqp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Óni futɛ ò tá Bɛtɛli. Mani Luda gbagbaki bo gwe, zaakũ à kpàmai ma warikɛgↄrↄ zĩ, àdigↄ̃ kú kũmao gu kũ ma gɛn pínki. ");
INSERT INTO bqp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Akũ ò buri zĩ̀tↄnↄ tãna kũ ò vĩnↄ kpàa kũ pↄ́sã kũ ò dananↄ, akũ à pↄ́ pìnↄ vĩ̀ gbiri lí gbáru Sɛkɛmu sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kũ Yakubu kũ a nɛ́nↄ dà zɛ́n, Luda tò vĩna wɛ̃tɛ kũ ò kú ń sarɛnↄ denↄ kũ̀ manamana, akũ ń gbɛ̃ke dí pɛ́tɛńyĩro. ");
INSERT INTO bqp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Akũ Yakubu kũ gbɛ̃ kũ ò kú kãaonↄ ń pínki kà Luzu kũ òdi pi tera Bɛtɛli, Kanaanↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","À sa'oki bò gwe, akũ à tↄ́ kpà gu pìinɛ Bɛtɛli Luda, zaakũ gwen Luda bò à sùan gↄrↄ kũ àtɛn bàa sí a vĩ̀ninɛ. ");
INSERT INTO bqp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora kũ à de Rɛbɛka gwàri ũ yã gà gwe, akũ ò a vĩ̀ gbiri lí gbáru Bɛtɛli sarɛ. Akũ ò tↄ́ kpà lí pìinɛ Ɔ́ↄdↄlii. ");
INSERT INTO bqp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Luda bò à sù Yakubua dↄ a suna kũ Mɛsↄpↄtamiao gbɛra, à arubarikaa dàagu ");
INSERT INTO bqp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","à pì: N tↄ́n Yakubu, ama oni pinnɛ Yakubu doro, sé Isaraila. Lɛmɛ à tↄ́ kpànɛ Isaraila lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Luda pìnɛ dↄ: Luda Gbãnasĩndapinkidemɛ ma ũ. Àgↄ̃ nɛ́ i àgↄ̃ kara. Buri ni bo n kĩnaa kũ buri dasinↄ dↄ, n buri kenↄ nigↄ̃ de kínanↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mani bùsu kũ ma kpà Ibrahĩ kũ Isaakuooa kpámma kũ n burinↄ n ga gbɛra. ");
INSERT INTO bqp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Akũ Luda fùtɛ à bò gu kũ à yã ò kãaon. ");
INSERT INTO bqp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakubu gbɛ̀ɛ pɛ̀tɛ gu kũ Luda yã ònɛn dↄngupↄ ũ. À í tↄ̀a à nísi kùa. ");
INSERT INTO bqp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Akũ Yakubu tↄ́ kpà gu kũ Luda yã ònɛn pìinɛ Bɛtɛli. ");
INSERT INTO bqp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Akũ ò fùtɛ Bɛtɛli ò dà zɛ́n. Kũ ò kà kãni kũ Ɛflatao, Rahila nɛ́'igↄrↄ kà, akũ nɛ́'i kɛ̀a zĩ'ũ. ");
INSERT INTO bqp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nɛ́'iwãwã a kũ̀ gbãna, akũ nↄgbɛ̃ nɛ́sɛtɛrii pìnɛ: Ǹsun vĩna kɛro, n nɛ́gↄ̃gbɛ̃ ì dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rahila gbãna vĩ doro àtɛn ga, akũ à tↄ́ kpà a nɛ́ pìinɛ Bɛnↄni, akũ a de tↄ́ kpànɛ Biliaminu. ");
INSERT INTO bqp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kũ Rahila gà, ò a vĩ̀ Ɛflata kũ òdi pi tera Bɛtilihamu zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakubu gbɛ̀ dↄngupↄ pɛ̀tɛ a miraa. Rahila mira gbɛ̀ɛ pì kú gwe ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isaraila ɛ̀ra à dà zɛ́n, akũ à bùraa kàtɛ Migidalɛda arɛ kpa. ");
INSERT INTO bqp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Gↄrↄ kũ à kú bùsuu pìn Rubɛni gɛ̀ɛ à wùtɛ kũ Bilao, Yakubu nↄ yìgisaride, akũ Yakubu yã pìi mà. Yakubu nɛ́gↄ̃gbɛ̃nↄ ì mɛ̀n kuri awɛɛpla. ");
INSERT INTO bqp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea nɛ́gↄ̃gbɛ̃nↄn dí: Yakubu daudu Rubɛni, Simɛↄ, Levi, Yuda, Isaka kũ Zɛbulunio. ");
INSERT INTO bqp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahila nɛ́nↄn Yusufu kũ Biliaminuo ũ. ");
INSERT INTO bqp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahila zĩkɛri Bila nɛ́nↄn Dã kũ Nafatalio ũ. ");
INSERT INTO bqp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea zĩkɛri Zilipa nɛ́nↄn Gada kũ Asao ũ. Nɛ́gↄ̃gbɛ̃ kũ ò ń í kũ Yakubuo Mɛsↄpↄtamianↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Akũ Yakubu kà a de Isaaku kĩnaa Mamare. À kú Kiriataba kũ òdi pi tera Ɛblↄnu sarɛ, gu kũ Ibrahĩ kũ Isaakuo vùtɛn. ");
INSERT INTO bqp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaaku kà wɛ̃̀ bakɛ̃ndo ");
INSERT INTO bqp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","à zĩ kũ̀ yúkuyuku, akũ à gà à kàkara kũ a gbɛ̃nↄo, akũ a nɛ́nↄ Isau kũ Yakubuo a vĩ̀. ");
INSERT INTO bqp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Isau kũ òdi pinɛ dↄ Ɛdↄmu burinↄ yãn dí. ");
INSERT INTO bqp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isau Kanaa nↄgbɛ̃nↄ sɛ̀, Iti buri Ɛlↄni nɛ́ Ada kũ Ivi buri Ana nɛ́ Ɔↄlibama, Zibɛↄ̃ daikoreo. ");
INSERT INTO bqp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","À Sumaila nɛ́ Basɛma, Nɛbayo dãre sɛ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Ɛlifaza ì kãao, akũ Basɛma Ruɛli ì. ");
INSERT INTO bqp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ɔↄlibama Yeusu kũ Yalamuo kũ Koraoo ì. Isau nɛ́gↄ̃gbɛ̃ kũ ò ń í Kanaanↄ bùsunnↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isau a nↄnↄ sɛ̀tɛ kũ a nɛ́gↄ̃gbɛ̃nↄ kũ a nɛ́nↄgbɛ̃nↄ kũ a bedenↄ ń pínki kũ a pↄ́kãdenↄ kũ a aruzɛkɛ kũ à lè Kanaanↄ bùsunnↄ pínki, akũ à gɛ̀ɛ Sei bùsun, à zã̀ kũ a dakũna Yakubuo, ");
INSERT INTO bqp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","zaakũ ń aruzɛkɛ zↄ̃kↄ̃ mɛ́ à tò oni fↄ̃ ògↄ̃ kú kũ kↄ̃oro. Bùsu kũ ò kun dí mↄ́ḿmaro kũ ń pↄ́nↄn dasi yãi. ");
INSERT INTO bqp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Isau vùtɛ Sei gusĩsĩden kũ òdi pi tera Ɛdↄmu. ");
INSERT INTO bqp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isau kũ à de Ɛdↄmunↄ dizi káaku ũ burinↄn dí. ");
INSERT INTO bqp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isau nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Ada nɛ́ Ɛlifaza kũ Basɛma nɛ́ Ruɛlio. ");
INSERT INTO bqp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ɛlifaza nɛ́gↄ̃gbɛ̃nↄn Temana, Omaa, Zefo, Gatamu kũ Kenazio ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ɛlifaza nↄ yìgisaridemɛ Timina ũ. Àkũ mɛ́ à Amalɛki ì kãao. Isau nↄ Ada daikorenↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ruɛli nɛ́gↄ̃gbɛ̃nↄn dí: Naata, Zɛra, Sama kũ Mizao. Isau nↄ Basɛma daikorenↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isau nↄ Ɔↄlibama nɛ́gↄ̃gbɛ̃nↄn dí: Yeusu, Yalamu kũ Korao. ");
INSERT INTO bqp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isau buri kínanↄn dí. Isau daudu Ɛlifaza buri kínanↄn Temana, Omaa, Zefo, Kenazi, ");
INSERT INTO bqp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu kũ Amalɛkio ũ. Ɛlifaza buri kínanↄ, Ada daikorenↄn gwe. Ò kú Ɛdↄmu bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isau nɛ́ Ruɛli buri kínanↄn dí: Naata, Zɛra, Sama kũ Mizao. Ruɛli buri kínanↄ, Basɛma daikorenↄn gwe. Ò kú Ɛdↄmu bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isau nↄ Ɔↄlibama buri kínanↄn dí: Yeusu, Yalamu kũ Korao. Ana nɛ́ Ɔↄlibama daikorenↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Isau kũ òdi pinɛ dↄ Ɛdↄmu nɛ́gↄ̃gbɛ̃nↄn gwe, a buri kínanↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sei, Ori buri kũ à kú Ɛdↄmu bùsun zaa káaku nɛ́gↄ̃gbɛ̃nↄn dí: Lotana, Sobala, Zibɛↄ̃, Ana, ");
INSERT INTO bqp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disↄ̃, Ɛza kũ Disão. ");
INSERT INTO bqp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotana nɛ́gↄ̃gbɛ̃nↄn dí: Ori kũ Omamuo. Lotana dãren Timina ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobala nɛ́gↄ̃gbɛ̃nↄn dí: Alavã, Manaa, Ebala, Sefo kũ Onamuo. ");
INSERT INTO bqp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibɛↄ̃ nɛ́gↄ̃gbɛ̃nↄn dí: Aya kũ Anao. Ana pì mɛ́ à bò ísɛ̃boki wãnaa zaa gbárannan gↄrↄ kũ àtɛni a de zaakinↄ dã. ");
INSERT INTO bqp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana nɛ́gↄ̃gbɛ̃n Disↄ̃ ũ, a nɛ́nↄgbɛ̃ sↄ̃ Ɔↄlibama. ");
INSERT INTO bqp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disↄ̃ nɛ́gↄ̃gbɛ̃nↄn dí: Ɛmɛdã, Ɛsɛbã, Itirana kũ Keranao. ");
INSERT INTO bqp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ɛza nɛ́gↄ̃gbɛ̃nↄn dí: Bilana, Zavã kũ Akanao. ");
INSERT INTO bqp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disã nɛ́gↄ̃gbɛ̃nↄn dí: Uzu kũ Aranao. ");
INSERT INTO bqp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ori buri kínanↄn dí: Lotana, Sobala, Zibɛↄ̃, Ana, ");
INSERT INTO bqp_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disↄ̃, Ɛza kũ Disão. Ori buri kínanↄ kũ ń buri kũ ò kú Sei bùsunnↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kína kũ ò kí blè Ɛdↄmu bùsun Isarailanↄ kínanↄ ãnↄn dí. ");
INSERT INTO bqp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bɛↄ nɛ́ Bɛla, Dinaba gbɛ̃ mɛ́ à kí blè Ɛdↄmu káaku. ");
INSERT INTO bqp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kũ à gà, akũ Zɛra nɛ́ Yobabu, Bↄzↄra gbɛ̃ kí blè a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kũ à gà, akũ Temana bùsu gbɛ̃ Usamu kí blè a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kũ à gà, akũ Bedada nɛ́ Adada, Avi gbɛ̃ kí blè a gɛ̃nɛ ũ. Àkũ mɛ́ à zĩ̀i blè Midiãnↄa Mↄabunↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kũ à gà, akũ Masareka gbɛ̃ Samala kí blè a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kũ à gà, akũ Reobo kũ à kú Yuflati sarɛ gbɛ̃ Saulu kí blè a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kũ à gà, akũ Akabo nɛ́ Baali Ana kí blè a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kũ à gà, akũ Pau gbɛ̃ Adada kí blè a gɛ̃nɛ ũ. A nↄ tↄ́n Mɛtabɛli, Matarɛdi nɛ́mɛ, Mɛzaba daikoremɛ. ");
INSERT INTO bqp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Isau buri kínanↄ tↄ́n dí kũ ń bùsunↄ: Timina, Alava, Yɛtɛ, ");
INSERT INTO bqp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ɔↄlibama, Ela, Pinↄ, ");
INSERT INTO bqp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temana, Mibiza, ");
INSERT INTO bqp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiɛli kũ Iramuo. Ɛdↄmu kínanↄ tↄ́n gwe wɛ̃tɛ kũ wɛ̃tɛo bùsu kũ ò vùtɛn. Isau kũ à de Ɛdↄmunↄ dizi ũ burinↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakubu kú Kanaanↄ bùsun gu kũ a de vùtɛn. ");
INSERT INTO bqp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakubu burinↄ yãn dí. Yusufu bi kɛfɛnnamɛ. A wɛ̃̀ gɛ̃ro awɛɛplade gũn kũ àtɛn sãnↄ dã kũ a vĩ̀ninↄ, a de nↄnↄ Bila kũ Zilipao nɛ́nↄ, akũ à dà vãni kũ ò kɛ̀ɛ kↄrↄmↄtↄↄ kɛ̀ a denɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isaraila ye Yusufui de a nɛ́ kparanↄla kũ à a ì a zĩkũnaa gũn yãi, akũ à utagyabaa zↄ̃̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kũ a vĩ̀ninↄ è ń de ye Yusufui deńla, akũ ò zã̀agu òdi we ò yã nna o kãaoro. ");
INSERT INTO bqp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu nana ò, akũ à bàba a vĩ̀ninↄnɛ, akũ ò ɛ̀ra ò zã̀agu de zĩ pↄ́la. ");
INSERT INTO bqp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","À pìńnɛ: À nana kũ ma ò ma. ");
INSERT INTO bqp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ma è ótɛn ése yĩyĩ bura, akũ ma ése baka fùtɛ à zɛ̀. Á pↄ́nↄ lìkai, akũ ò nàtɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Akũ a vĩ̀ninↄ pìnɛ: Ĩni kí blewán yá? Ĩni gbãna ble wán yá? Akũ ò ɛ̀ra ò zã̀agu de yã pↄ́la nana kũ à òo pì yãi. ");
INSERT INTO bqp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusufu ɛ̀ra à nana ò dↄ, akũ à bàba a vĩ̀ninↄnɛ à pì: Ma ɛra ma nana ò dↄ. Ma è ifãntɛ̃ kũ mↄvuraao kũ susunɛ mɛ̀n kuri awɛɛdonↄ tɛn natɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","À nana pìi bàba a denɛ dↄ, akũ a de pàtaa à pì: Nana kpate takan n ò lɛɛ? Makũ kũ n dao kũ n vĩ̀ninↄ, óni su ò kútɛ n arɛn yá? ");
INSERT INTO bqp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A vĩ̀ninↄ nɛ̀sɛgↄ̃baa sɛ̀ kãao. A de sↄ̃ à nana pì yã kũna a nɛ̀sɛɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","A vĩ̀ninↄ gɛ̀ɛ ń de sãnↄ dã Sɛkɛmu. ");
INSERT INTO bqp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Akũ Isaraila pì Yusufunɛ: N vĩ̀ninↄ tɛn sã dã Sɛkɛmu. Mani n zĩ ń kĩnaa. À wèa à pì: Ma laka. ");
INSERT INTO bqp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Akũ à pìnɛ: Ǹ gɛ́ ǹ n vĩ̀ninↄ gwa kũ sãnↄ, tó ò aafia. Ǹ ɛra ǹ sumɛnɛ kũ ń baaruuo. Akũ à a gbàrɛ, à bò Ɛblↄnu guvutɛn à gɛ̀ɛ Sɛkɛmu. ");
INSERT INTO bqp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Àtɛn likara sɛ̃̀n, akũ gↄ̃gbɛ̃ ke dàalɛ à a là: Bↄ́n ntɛn wɛtɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","À wèa à pì: Matɛni ma vĩ̀ninↄ wɛtɛmɛ. Tó ń ń sãdãki dↄ̃, ǹ omɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Gↄ̃gbɛ̃ pìi pì: Kũ ò bò gu dín, ma mà ò pì òtɛn gɛ́ Dotãmɛ. Akũ Yusufu pɛ̀tɛńyĩ à ń lé Dotã. ");
INSERT INTO bqp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kũ ò a è zã̀ dire, ari àgↄ̃ gɛ́ ká ń kĩnaa, ò lɛ́ kpàkũsũi ò pì ò a dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ò pìkↄ̃nɛ: À gwa, nana'ori tɛn su zã̀ dire. ");
INSERT INTO bqp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","À tó ò a dɛ ò a zu lↄ̀gↄ dínↄ doke gũn. Óni pi nↄ̀bↄ pãsĩ mɛ́ à a dɛ̀ à sò. Ɛ̃hɛ̃ óni e lákũ a nananↄ ni mì dɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kũ Rubɛni yã pìi mà, à ye à a mì sí, akũ à pì: Òsun a dɛro, ");
INSERT INTO bqp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","àsun aru boaro. À a zu lↄ̀gↄ díkĩnan gbárannan la. Àsun a dɛro. Rubɛni òńnɛ lɛ, kũ à ye à a mì sí à a kpá a dea yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kũ Yusufu kà a vĩ̀ninↄ kĩnaa, ò a uta bò, a utagyaba mana pìi. ");
INSERT INTO bqp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Akũ ò a sɛ̀ ò a zù lↄ̀gↄↄ pìn. Lↄ̀gↄↄ pì da korimɛ à í vĩro. ");
INSERT INTO bqp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Akũ ò vùtɛ òtɛn pↄ́ ble. Kũ ò wɛ́ sɛ̀, ò Sumaila buri lagatarinↄ è, ò bò Giliada bùsun òtɛn gɛ́ Misila. Ń lakuminↄn do pↄ́nↄ kũ lí'ↄ ɛzɛo kũ lí'ↄ gbĩ nnao sɛna. ");
INSERT INTO bqp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Akũ Yuda pì a gbɛ̃nↄnɛ: Tó o ó dakũna dɛ̀, akũ o a gɛ̀ɛ ùtɛ, bↄ́ àreen óni lee? ");
INSERT INTO bqp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","À tó ò a yía Sumaila buri pìnↄa. Òsun a dɛro, ó dakũnanloo? Ó aru dokↄ̃nↄmɛ. Akũ a gbɛ̃nↄ a yã mà. ");
INSERT INTO bqp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kũ Midiã lagatari pìnↄ tɛn su gɛ̃ zɛ́la, akũ ò Yusufu gà ò bò lↄ̀gↄn, ò a yìa Sumaila buri pìnↄa andurufu baro, akũ ò tà kãao Misila. ");
INSERT INTO bqp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kũ Rubɛni sù lↄ̀gↄↄ pì kĩnaa, adi Yusufu e gwe doro, akũ à a pↄ́kasanↄ gà à kɛ̃̀kɛ̃, ");
INSERT INTO bqp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","akũ à gɛ̀ɛ a dakũnanↄ kĩnaa à pì: Nɛ́ pì kú gwe doro. Mani gɛ́ má kũ abireoo? ");
INSERT INTO bqp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ò blèkofĩnii kũ̀ ò dɛ̀, akũ ò Yusufu uta pìi sɛ̀ ò màtɛ a aru gũn. ");
INSERT INTO bqp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Akũ ò a utagyabaa pìi sɛ̀ ò gɛ̀ɛo ń denɛ ò pì: Pↄ́ kũ o èn dí. N nɛ́ utan yá, ke a pↄ́nlo? ");
INSERT INTO bqp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","À dↄ̃̀, akũ à pì: Ma nɛ́ utamɛ, nↄ̀bↄ pãsĩ mɛ́ à a sò. Waiyoo, ò ma nɛ́ Yusufu kɛ̀ yákiyakimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Akũ à a uta zↄ̃kↄ̃ↄ gà à kɛ̃̀ à pↄ́kasa sɛ̀ à dà, akũ à a nɛ́ pì wɛ̃nda kɛ̀ gìkɛna. ");
INSERT INTO bqp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A nɛ́gↄ̃gbɛ̃nↄ kũ a nɛ́nↄgbɛ̃nↄ sù a laakari kpátɛnɛ ń pínki, ama à gì a laakari kpátɛi à pì: Manigↄ̃ ma nɛ́ pìi gɛ̀ ↄ́ↄ dↄmɛ ari mà gɛ́ táo a kĩnaa gyãwãn. Akũ àtɛn wɛ̃nda ↄ́ↄ dↄ a nɛ́ pì yã musu. ");
INSERT INTO bqp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midiã pìnↄ sↄ̃ ò Yusufu yìa Pↄtifaa Misila. Firi'auna ìba kemɛ, àkũmɛ a dogarinↄ gbɛ̃ zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Zĩ kũ̀a Yuda bò a gbɛ̃nↄ kĩnaa à gɛ̀ɛ à vùtɛ Adulamu gbɛ̃ kũ òdi pinɛ Ira bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Gwen à dàkarɛ kũ Kanaanↄ bùsu gbɛ̃ kũ òdi pinɛ Sua nɛ́nↄgbɛ̃o, akũ à a sɛ̀ nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","À nↄ̀ↄ sì à nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à tↄ́ kpànɛ Ɛɛ. ");
INSERT INTO bqp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","À ɛ̀ra à nↄ̀ↄ sì dↄ à nɛ́gↄ̃gbɛ̃ ì, akũ à tↄ́ kpànɛ Ona. ");
INSERT INTO bqp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","À ɛ̀ra à nɛ́gↄ̃gbɛ̃ ì dↄ, akũ à tↄ́ kpànɛ Sela. Gↄrↄ kũ à nɛ́ pìi ì, à kú Kezibimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Akũ Yuda nↄgbɛ̃ kũ òdi pinɛ Tama sɛ̀ a daudu Ɛɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ɛɛ kɛ̀ Dikirinɛ vãni, akũ à a dɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Akũ Yuda pì Onanɛ: Ǹ n vĩ̀ni gyaanↄ sɛ́ ǹ buri kɛ n vĩ̀ninɛ, lákũ òdi kɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kũ Ona dↄ̃ kũ nɛ́ kũ áni i kũ a vĩ̀ni gyaanↄo nigↄ̃ de a buri ũro, tó à wùtɛ kãao akũ à ye à a zĩda e, àdi a gↄ̃gbɛ̃ pↄ́ kↄ́tɛmɛ, de àsun buri kɛ a vĩ̀ninɛro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yã kũ àtɛn kɛ pìi kɛ̀ Dikirinɛ vãni, akũ à a dɛ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Akũ Yuda pì a nɛ́ gyaanↄ Tamanɛ: Ǹ gɛ́ ǹgↄ̃ gyaanↄ ble n de bɛa ari ma nɛ́ Sela zↄ̃kↄ̃ kũ. Zaakũ àtɛn da Sela ni ga lán a vĩ̀ninↄ bàmɛ. Akũ Tama gɛ̀ɛ à vùtɛ a de bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kũ a gↄrↄ gìi kɛ̀, akũ Yuda nanↄ gà. Kũ a nɛ̀sɛɛ kpàtɛ, à dà zɛ́n àtɛn gɛ́ a sãkãkɛ̃rɛrinↄ kĩnaa Timina kũ a gbɛ̃nna Irao. ");
INSERT INTO bqp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Akũ ò a baaruu kpà Tamanɛ ò pì: N zã de tɛn gɛ́ Timina a sãnↄ kã kɛ̃rɛ. ");
INSERT INTO bqp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Akũ à a gyaanↄblepↄnↄ bò a pↄ́dangãnn sɛ̀ à kù a ãnnwa, akũ à gɛ̀ɛ à vùtɛ Enaimu bĩnilɛa Timina zɛ́n. Zaakũ à è Sela zↄ̃kↄ̃ kũ̀, odi a kpáa nↄ ũro. ");
INSERT INTO bqp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kũ Yuda a è, akũ à a dìtɛ karua ũ kũ à pↄ́ kù a ãnnwa yãi. ");
INSERT INTO bqp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Akũ à nài zɛ́ sarɛ à pì: Ǹ tó mà wútɛ kũnwo. Adi a dↄ̃ a nɛ́ gyaanↄ ũro. Akũ nↄgbɛ̃ pìi pì: Tó n wútɛ kũmao, bↄ́n ĩni kpámaa? ");
INSERT INTO bqp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","À wèa à pì: Mani ma kpàsa blènɛ mɛ̀n do kpãzãnnɛ. Akũ à pì: Ǹ tↄrↄma ditɛmɛnɛ ari ǹgↄ̃ gɛ́ kpãzã. ");
INSERT INTO bqp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Akũ à a là à pì: Bↄ́ tↄrↄman mani ditɛnnɛɛ? A pì: Ǹ n sèedakɛbↄ kũ a bàao kũ gò kũ ń kũnaao kpáma. Akũ à kpàa à wùtɛ kãao à nↄ̀ↄ dↄ̀agu. ");
INSERT INTO bqp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Akũ nↄgbɛ̃ pìi fùtɛ à tà bɛ à a pↄ́dangãnn bò à a gyaanↄblepↄnↄ sɛ̀ à dà. ");
INSERT INTO bqp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda a gbɛ̃nna Adulamu gbɛ̃ zĩ̀ kũ blènɛo à tↄrↄma boo nↄgbɛ̃ pìia. Kũ à kà, adi a lero. ");
INSERT INTO bqp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Akũ à gwedenↄ làla à pì: Karua kũ à kú Enaimu zɛ́ sarɛ la yã kú máa? Ò wèa ò pì: Karua ke kú laro fá! ");
INSERT INTO bqp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Akũ à ɛ̀ra à tà à pì Yudanɛ: Mádi a ero. Gwedenↄ pì o karua ke dↄ̃ gwe yã sero. ");
INSERT INTO bqp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Akũ Yuda pì: Àgↄ̃ pↄ́ pìnↄ kũna. Óni tó gbɛ̃nↄ ó yáa dↄro. Ma n zĩ kũ blèe pìio, ńdi a lero. ");
INSERT INTO bqp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mↄ aakↄ̃ gbɛra ò sù ò ò Yudanɛ ò pì: N nɛ́ nanↄ Tama karua kà, akũ à nↄ̀ↄ sì a pãpãkɛnaa pìi gũn. Yuda pì: À bo kãao ò tɛ́ sↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kũ òtɛn bo kãao bàai, à lɛ́gbãzã kɛ̀ a zã denɛ à pì: Gbɛ̃ kũ à pↄ́ díkĩnanↄ vĩ mɛ́ à nↄ̀ↄ dↄ̀magu. Ǹ sèedakɛbↄ kũ a bàao kũ gò díkĩnao gwa, tó ń a de dↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda pↄ́ pìnↄ dↄ̃̀, akũ à pì: Nↄgbɛ̃ pì yã nna demala, zaakũ mádi a kpá ma nɛ́ Selaaro. Yuda dí wútɛ kãao doro. ");
INSERT INTO bqp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kũ à kà nɛ́'ina, à sù à lè sìkanↄ mɛ́ ò kú a gbɛrɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Gↄrↄ kũ àtɛn nɛ́ i, ń gbɛ̃ do ↄ bò, akũ nↄgbɛ̃ nɛ́sɛtɛri wↄ̃nↄ tɛ̃ra dↄ̀a à pì: Nɛ́ díkĩna mɛ́ à bò káaku. ");
INSERT INTO bqp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kũ nɛ́ pì a ↄ sùkpa, akũ nɛ́ plade bò, akũ nↄgbɛ̃ pìi pì: N bo bùimɛ fá! Akũ ò tↄ́ kpànɛ Pɛrɛzi. ");
INSERT INTO bqp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Abire gbɛra kũ a gbɛ̃ndo kũ ò wↄ̃nↄ tɛ̃ra dↄ̀ a ↄaa bò, akũ ò tↄ́ kpànɛ Zɛra. ");
INSERT INTO bqp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kũ Sumaila burinↄ kà kũ Yusufuo Misila, akũ Misila gbɛ̃ Pↄtifa a lùḿma. Firi'auna ìba kemɛ, àkũmɛ a dogarinↄ gbɛ̃ zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Dikiri kú kũ Yusufuo, akũ à sa'a kũ̀. À kú a dikiri Misila gbɛ̃ pì bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kũ a dikiri pìi è Dikiri kú kãao àdigↄ̃ a dakarɛ kũ sa'ao yã kũ àtɛn kɛnↄ gũn pínki, ");
INSERT INTO bqp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","akũ Yusufu a pↄnna lè. Pↄtifa a dìtɛ a azia ũ à pↄ́ kũ à vĩnↄ nànɛ a ↄĩ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Zaa gↄrↄ kũ à a dìtɛ a azia ũ, Dikiri arubarikaa dà a bɛn Yusufu yãi. Dikiri arubarikaa dà pↄ́ kũ à de a pↄ́ ũnↄgu pínki, bɛ pↄ́nↄ kũ burapↄnↄn yá. ");
INSERT INTO bqp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Akũ Pↄtifa a pↄ́ sĩnda pínki nà Yusufunɛ a ↄĩ. A bàka kú yãkeoro, tó adi kɛ pↄ́ble baasiro. Yusufu sↄ̃ bi gↄ̃ kɛfɛnnamɛ, akũ a zɛna mana. ");
INSERT INTO bqp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Zĩkea Yusufu ni gɛ̃̀ a dikiri nanↄgu, akũ à pìnɛ: Ǹ wútɛ kũmao. ");
INSERT INTO bqp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Akũ à gì à pì: Ǹ gwa, ma dikiri bàka kú yãkeo ↄn dí gũn doro, à pↄ́ kũ à vĩnↄ nàmɛnɛ ma ↄĩ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A gbãna demala ↄn dí gũnlo, adi gímɛnɛ kũ pↄ́keoro, sé mↄkↄ̃n, kũ ń de a nↄ ũ yãi. Mani fↄ̃ mà yã vãni bire taka kɛ mà durunna kɛ Ludanɛro. ");
INSERT INTO bqp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bee kũ nↄgbɛ̃ pìi dìgↄ̃ onɛ baabↄrɛ, adi we à wùtɛ kãaoro, à ye àgↄ̃ kú kãao sero. ");
INSERT INTO bqp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Zĩkea kũ Yusufu gɛ̃̀ kpɛ́n a zĩ kɛ, à sù à lè ↄn zĩkɛri ke kú kpɛ́ gũnlo. ");
INSERT INTO bqp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Akũ nↄgbɛ̃ pì a kũ̀ a utaa à pì: Ǹ wútɛ kũmao. Akũ Yusufu a uta tònɛ gwe à bàa lɛ̀ à bò bàai. ");
INSERT INTO bqp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kũ nↄgbɛ̃ pìi è à a uta tòarɛ à bàa lɛ̀ à bò bàai, ");
INSERT INTO bqp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","akũ à ↄn zĩkɛrinↄ sìsi à pìńnɛ: À gwa, ò sùwɛrɛ kũ Eberuo, akũ àtɛn dↄkɛ kũoo. À gɛ̃̀mai à wútɛ kũmao, akũ ma wiki lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kũ à mà ma wiki dↄ̀awa, akũ à a uta tò katɛna ma sarɛ à bàa lɛ̀ à bò bàai. ");
INSERT INTO bqp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Akũ nↄgbɛ̃ pìi uta pìi kàtɛ a sarɛ ari Yusufu dikirii sù, ");
INSERT INTO bqp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","akũ à pìnɛ: Eberu zↄ̀ kũ n su kãaowɛrɛ dↄkɛ̀ kũmao à gɛ̃̀mai. ");
INSERT INTO bqp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kũ ma wiki dↄ̀a, akũ à a uta tò katɛna ma sarɛ à bàa lɛ̀ à bò bàai. ");
INSERT INTO bqp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kũ nↄgbɛ̃ pì yã pìi ò a zãnɛ à pì, lákũ n zↄ̀ↄ kɛ̀mɛnɛ nàn gwe, akũ Yusufu dikiri pↄfɛ̃̀ manamana. ");
INSERT INTO bqp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Akũ à pì ò Yusufu kũ ò a da kpɛ́siran, gu kũ gbɛ̃ kũ kína bàa dↄ̀ḿmanↄ kátɛn, akũ à gↄrↄ pla kɛ̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Bee kũ abireo Dikiri kú kãao à gbɛ̃kɛ kɛ̀nɛ à tò a yã kà purusunanↄ dãkpãrigu. ");
INSERT INTO bqp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Akũ dãkpãrii pì purusunanↄ nà Yusufunɛ a ↄĩ ń pínki, òdi yãke kɛ a sariro. ");
INSERT INTO bqp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Purusunanↄ dãkpãrii pìi bàka dìgↄ̃ kú Yusufu yãoro, kũ Dikiri kú kãao yãi, akũ àdigↄ̃ a dakarɛ kũ sa'ao yã kũ àtɛn kɛ gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Abire gbɛra Misila kína Firi'auna wɛ̃kpaatɛri kũ a burodikɛriio taari kɛ̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","A pↄ fɛ̃̀ a ìba gbɛ̃nↄn pla pìnↄi, a wɛ̃kpaatɛriki kũ a burodikɛrikio. ");
INSERT INTO bqp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Akũ à ń ká kpɛ́siran a dogarinↄ gbɛ̃ zↄ̃kↄ̃ bɛa, kpɛ́ kũ ò Yusufu dàn. ");
INSERT INTO bqp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Dogarinↄ gbɛ̃ zↄ̃kↄ̃ pì Yusufu dìtɛ àgↄ̃ ń gwa, akũ ò gↄrↄ pla kɛ̀ kpɛ́ pìn gwe. ");
INSERT INTO bqp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gwãani dokↄ̃nↄa Misila kína wɛ̃kpaatɛri kũ burodikɛrii pìio nana ò ń gbɛ̃nↄn pla ń pínki, baadi kũ a pↄ́o kũ a bↄkↄtɛnaao. ");
INSERT INTO bqp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kũ Yusufu sù ń gwa kↄnkↄ, à è ń ãnn sìsi. ");
INSERT INTO bqp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Akũ à ń lá à pì: Bↄ́ yã mɛ́ à tò á ãn sisina gbãraa? ");
INSERT INTO bqp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ò wèa ò pì: Nanan o ò, gbɛ̃ke kú la kũ à a àlesi owɛrɛro. Akũ à pìńnɛ: Luda mɛ́ à nana àlesi bↄkↄtɛna vĩroo? À á nana pìnↄ omɛnɛ mà ma. ");
INSERT INTO bqp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Akũ wɛ̃kpaatɛriki a pↄ́ ònɛ à pì: Ma nana gũn ma geepi lí è ma sarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Geepi lí pì ↄnɛ aakↄ̃mɛ. À lá bò à vú kɛ̀ à nɛ́ ì à mà. ");
INSERT INTO bqp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Má Firi'auna toko kũna, akũ ma geepi nɛ́ pìnↄ sɛ̀ ma fɛ̃̀ a toko pìi gũn ma kpàa. ");
INSERT INTO bqp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu pìnɛ: Nana pìi bↄkↄtɛnan dí. Lí'ↄnɛ aakↄ̃ pìnↄ bi gↄrↄ aakↄ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Gↄrↄ aakↄ̃ gbɛra Firi'auna ni n mì sí. Ani ɛra à n da n zĩ gũn, ĩni ɛra ǹgↄ̃ wɛ̃ bonɛ lákũ ndìgↄ̃ kɛ nà yã. ");
INSERT INTO bqp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tó yã bò kũnwo nna, ǹ tó ma yã gↄ̃ dↄngu. Ǹ gbɛ̃kɛ kɛmɛnɛ ǹ ma yã o Firi'aunanɛ de à ma bo kpɛ́sira dí gũn. ");
INSERT INTO bqp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Zaakũ ò ma kũ kpãni zaa Eberu bùsun, akũ bee Misila la mádi yãke kɛ à kà ò ma da wɛ̀ɛ dí gũnlo. ");
INSERT INTO bqp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kũ burodikɛriki è Yusufu nana pìi àlesi'onaa bò kũ wɛ̃kpaatɛriio nna, akũ à pìnɛ: Ma nana gũn sↄ̃ ma è má burodi sɛna tãnko aakↄ̃ dikↄ̃ana. ");
INSERT INTO bqp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tãnko kũ à kú musu, burodi buri dasi kũ ma kɛ̀ Firi'aunanɛ ká a gũn, akũ bãnↄ tɛn ble ma musu. ");
INSERT INTO bqp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu pìnɛ: A bↄkↄtɛnan dí. Tãnko aakↄ̃ pìnↄ gↄrↄ aakↄ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Gↄrↄ aakↄ̃ gbɛra Firi'auna ni n mì zↄ̃ à n loko lía, bãnↄ ni n ble. ");
INSERT INTO bqp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A gↄrↄ aakↄ̃de sↄ̃ Firi'auna igↄrↄ là kↄ̃kↄ̃mɛ, akũ à pↄ́ble kɛ̀ a ìbanↄnɛ. À wɛ̃kpaatɛriki kũ burodikɛrikio bↄ̀tɛ kpɛ́n a ìbanↄ wára. ");
INSERT INTO bqp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Akũ à ɛ̀ra à wɛ̃kpaatɛriki dà a zĩn à ɛra àgↄ̃ í boarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Akũ à burodikɛriki lòko lía lákũ Yusufu ń nananↄ bↄkↄtɛnaa òńnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yusufu yã dí dↄ wɛ̃kpaatɛrikin doro, a yã sã̀agu. ");
INSERT INTO bqp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Wɛ̃̀ pla papanaa gbɛra Firi'auna nana ò, à è á zɛna Nili lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","À è zùda mana mɛ̀kpananↄ bↄ̀tɛ swa pìi wɛ̀ɛn mɛ̀n suppla òtɛn sɛ̃̀ ble tàfee gũn. ");
INSERT INTO bqp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Akũ à zùda fɛ̃fɛ̃na wↄkↄwↄkↄnↄ è mɛ̀n suppla dↄ. Ò bò swawɛɛn ò tɛ̀ a káakupↄnↄ kpɛ ò zɛ̀ ń sarɛ swa lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Akũ zù fɛ̃fɛ̃na wↄkↄwↄkↄ pìnↄ zù mana mɛ̀kpana pìnↄ mↄ̀mↄ, akũ Firi'auna vù. ");
INSERT INTO bqp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","À ɛ̀ra à i ò, akũ à nana ò dↄ. À è ése sáko mana wɛ́de pìa ése lí dokↄ̃nↄa sáko suppla. ");
INSERT INTO bqp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Akũ à ése sáko wɛ́ kↄgↄkↄgↄ kũ legũ'i kĩ̀aḿmanↄ è, à pìa ń gbɛra dↄ sáko suppla. ");
INSERT INTO bqp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Akũ ése sáko wɛ́ kↄgↄkↄgↄ pìnↄ ése sáko mana wɛ́de pìnↄ mↄ̀mↄ. Kũ Firi'auna vù, à è nanan a ò. ");
INSERT INTO bqp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kũ gu dↄ̀, à kú bídi gũn, akũ à Misila màsokɛrinↄ kũ wɛ́zɛ̃rinↄ sìsi ń pínki. À a nananↄ bàbańnɛ, ama ń gbɛ̃ke dí fↄ̃ à a bↄkↄtɛnaa ònɛro. ");
INSERT INTO bqp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Akũ wɛ̃kpaatɛriki fùtɛ à yã ò Firi'aunanɛ à pì: Taari kũ ma kɛ̀ yã dↄ̀magu gbãra. ");
INSERT INTO bqp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kí, n pↄ fɛ̃̀ n zↄ̀blerinↄi yã, akũ n ma da kpɛ́siran n dogarinↄ gbɛ̃ zↄ̃kↄ̃ bɛa lɛɛlɛ kũ burodikɛrikio. ");
INSERT INTO bqp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Gwãani dokↄ̃nↄa o nana ò, ó baadi kũ a pↄ́o kũ a àlesiio. ");
INSERT INTO bqp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Eberu kɛfɛnna ke kú kũoo gwe, n dogarinↄ gbɛ̃ zↄ̃kↄ̃ↄ zↄ̀ↄmɛ. Kũ o ó nananↄ bàbanɛ, akũ à ó baadi pↄ́ bↄkↄtɛnaa ònɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yã pìnↄ kɛ̀ lákũ à òwɛrɛ nà. N ɛra n ma da ma zĩn, akũ n burodikɛriki pìi lòko lía. ");
INSERT INTO bqp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Akũ Firi'auna gbɛ̃ zĩ̀ ò Yusufu sísi, akũ ò gɛ̀ɛ ò a bò wɛ̀ɛn likalika. À mìi bò à a pↄ́kasanↄ lìtɛ, akũ à gɛ̀ɛ Firi'auna kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Akũ Firi'auna pìnɛ: Ma nana ò, gbɛ̃ke dí fↄ̃ à a bↄkↄtɛnaa òmɛnɛro. Ma mà ò pì, tó ò ònnɛ, ndì fↄ̃ ǹ a àlesi ońnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu pìnɛ: Adi kɛ makũmɛro, Luda mɛ́ ani a àlesi onnɛ, kí. ");
INSERT INTO bqp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Akũ Firi'auna pìnɛ: Ma nana gũn ma è má zɛna Nili lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ma è zùda mana mɛ̀kpana mɛ̀n supplanↄ bↄ̀tɛ swawɛɛn òtɛn sɛ̃̀ ble tàfee gũn. ");
INSERT INTO bqp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Akũ ma zùda pãndenↄ è dↄ mɛ̀n suppla ò fɛ̃fɛ̃na wↄkↄwↄkↄ, mádi zù fɛ̃fɛ̃na bire takanↄ e Misila la zikiro. ");
INSERT INTO bqp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Akũ zùda fɛ̃fɛ̃na wↄkↄwↄkↄ pìnↄ zù mɛ̀kpana káakupↄ mɛ̀n suppla pìnↄ mↄ̀mↄ. ");
INSERT INTO bqp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bee kũ ò ń mↄ́mↄ, ò gↄ̃̀ fɛ̃fɛ̃na lán yã bàmɛ, gbɛ̃ke ni dↄ̃ kũ ò ń mↄ́mↄ sero. Akũ ma vu. ");
INSERT INTO bqp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nana gũn dↄ ma è, ése sáko mana wɛ́de pìa ése lí dokↄ̃nↄa sáko suppla. ");
INSERT INTO bqp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Akũ ma è ése sáko térere wɛ́ kↄgↄkↄgↄ kũ legũ'i kĩ̀aḿmanↄ pìa ń gbɛra dↄ sáko suppla. ");
INSERT INTO bqp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Akũ ése sáko wɛ́ kↄgↄkↄgↄ pìnↄ ése sáko wɛ́de pìnↄ mↄ̀mↄ. Kũ ma ò màsokɛrinↄnɛ, ń gbɛ̃ke dí fↄ̃ à a bↄkↄtɛnaa òmɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Akũ Yusufu pìnɛ: Kí, nana kũ n òo pìnↄ àlesi dokↄ̃nↄmɛ. Luda yã kũ à ye à kɛ mↄ̀nnɛmɛ, kí. ");
INSERT INTO bqp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Zù mana mɛ̀n suppla pìnↄ bi wɛ̃̀ supplamɛ. Ése sáko wɛ́de sáko suppla pìnↄ sↄ̃ wɛ̃̀ supplamɛ. Nana pìnↄ àlesi dokↄ̃nↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Zù fɛ̃fɛ̃na wↄkↄwↄkↄ mɛ̀n suppla kũ ò bↄ̀tɛ ò tɛ̀ a káakupↄnↄ kpɛ pìnↄ bi wɛ̃̀ supplamɛ. Lɛmɛ ése sáko wɛ́ kↄgↄkↄgↄ kũ legũ'i kĩ̀aḿma sáko suppla pìnↄ de lɛ dↄ. Abirekũnↄmɛ wɛ̃̀ suppla kũ nà ni ká ũ. ");
INSERT INTO bqp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Lákũ ma ònnɛ nà tera, kí, ma pì Luda tɛn yã kũ à ye à kɛ mↄnnɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pↄ́blewɛ nigↄ̃ di Misila gu sĩnda pínkia manamana ari wɛ̃̀ suppla. ");
INSERT INTO bqp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Abire gbɛra nà ni gɛ̃ ari wɛ̃̀ suppla, kãna gbãna pì yã ni sã Misilanↄgu. Nàa pì ni bùsuu pì dɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Nà kũ ani su pì nigↄ̃ pãsĩ manamana, kãna gbãna pì yã ni dↄ gbɛ̃kegu doro. ");
INSERT INTO bqp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kí, kũ gɛ̃̀n plamɛ n nana pìi ò, kũ Luda mɛ́ à dìtɛ yãimɛ. Ani kɛ teramɛ, à sika vĩro. ");
INSERT INTO bqp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tera sà kí, ǹ wɛ́zɛ̃ri ↄ̃ndↄ̃de wɛtɛ ǹ ditɛ àgↄ̃ de gbãnade ũ Misila. ");
INSERT INTO bqp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kí, ǹ gbɛ̃nↄ ditɛ gbɛ̃ zↄ̃kↄ̃nↄ ũ Misila ògↄ̃ pↄ́blewɛ sↄↄrode kakara wɛ̃̀ suppla kũ pↄ́blewɛ nigↄ̃ din pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Oni pↄ́ble kakara wɛ̃̀ mana kũ àtɛn sunↄ gũn ò pↄ́blewɛ ká dↄ̃̀nↄ gũn wɛ̃tɛ kũ wɛ̃tɛo kũ n tↄ́o, onigↄ̃ dãkpã. ");
INSERT INTO bqp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tó nà kũ ani kɛ wɛ̃̀ suppla pìi kà Misila, pↄ́ble pì nigↄ̃ de zã̀na ũ de nàa pì sún Misilanↄ dɛdɛro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yã pìi kà Firi'aunagu kũ a ìbanↄ ń pínki, ");
INSERT INTO bqp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","akũ à pìńnɛ: Gbɛ̃ dí Luda Nini vĩ. Óni gbɛ̃ke e lán a bà dↄ yá? ");
INSERT INTO bqp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Akũ à pì Yusufunɛ: Lákũ Luda tò ń yã birenↄ dↄ̃ pínki nà, wɛ́zɛ̃ri ↄ̃ndↄ̃de ke kun lán n bàro. ");
INSERT INTO bqp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Mↄkↄ̃n mɛ́ ĩnigↄ̃ de ma ↄn gbɛ̃ zↄ̃kↄ̃ ũ, ma gbɛ̃nↄ nigↄ̃ mì natɛnnɛ ń pínki. Kpata mɛ́ ani tó màgↄ̃ denla ado. ");
INSERT INTO bqp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Akũ à ɛ̀ra à pìnɛ: Ĩnigↄ̃ gbãna vĩ Misila bùsu gu sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Akũ à tãnka sèedakɛbↄↄ bò a ↄnɛa à dà Yusufunɛ a ↄnɛa, à taasaa uta dànɛ à wura gɛ̀rɛɛ dànɛ a wakaaa. ");
INSERT INTO bqp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","À a sↄ̃go plade kpàa táa'obↄ ũ, akũ gbɛ̃ kũ ò donɛ arɛnↄ dìgↄ̃ pata: À kútɛ! À kútɛ! Lɛmɛ Firi'auna tò Yusufu gbãna vĩ Misila bùsun lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","À pìnɛ dↄ: Makũ Firi'auna, gbɛ̃ke ni fↄ̃ à yãke kɛ Misila la n lɛ́ sariro. ");
INSERT INTO bqp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","À tↄ́ kpànɛ Zafɛna Panɛa, akũ à Ɛliↄpↄli wɛ̃tɛ sa'ori Potifɛra nɛ́nↄgbɛ̃ Asɛna kpàa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Gↄrↄ kũ Yusufu zĩ lè Misila kína Firi'auna bɛa, a wɛ̃̀ baraakurimɛ. Akũ à bò Firi'auna kĩnaa à gɛ̀ɛ à kurè Misila gu sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kãna gbãna kun ari wɛ̃̀ suppla, pↄ́blewɛ din manamana. ");
INSERT INTO bqp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Akũ Yusufu pↄ́blewɛ kũ à di Misila wɛ̃̀ suppla pìnↄ kàkara wɛ̃tɛ kũ wɛ̃tɛo zã̀na ũ, wɛ̃tɛ sĩnda pínki kũ a bura kũ ò likainↄ pↄ́o. ");
INSERT INTO bqp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","A pↄ́blewɛ kàkara zↄ̃kↄ̃zↄ̃kↄ̃ lán ísiralɛ bùsu'atɛ̃ bà, akũ ò zɛ̀ a zaka lɛ́ yↄ̃naaa, kũ oni fↄ̃ ò a lɛ́ dↄ̃ro yãi. ");
INSERT INTO bqp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ari nà gↄ̃ gɛ́ ká Yusufu nanↄ Asɛna, Potifɛra nɛ́, nɛ́gↄ̃gbɛ̃nↄ ì mɛ̀n pla. ");
INSERT INTO bqp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu tↄ́ kpà a dauduunɛ Manase à pì: Luda tò ma de bedenↄ kũ wari kũ ma kɛ̀ɛo yã sã̀magu pínki. ");
INSERT INTO bqp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Akũ à tↄ́ kpà a pladenɛ Ɛflaimu à pì: Luda tò ma gↄ̃ nɛ́de ũ bùsu kũ ò wɛ́ tã̀man. ");
INSERT INTO bqp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kũ kãna gbãna kũ à kú Misila wɛ̃̀ suppla pìi làka, ");
INSERT INTO bqp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","akũ wɛ̃̀ suppla kũ nà ni ká dàtɛ lákũ Yusufu ò nà. Nàa kà bùsu kũ bùsuuo pínki, ama pↄ́blewɛ di Misila gu sĩnda pínkiamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kũ nàa gɛ̃̀ Misilanↄgu pínki, ò wiki lɛ̀ Firi'aunanɛ à pↄ́ble kpáḿma. Akũ à pìńnɛ ń pínki: À gɛ́ Yusufu kĩnaa à kɛ lákũ ani oárɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nàa dà bùsuu pìla pínki, akũ Yusufu dↄ̃̀nↄ wɛ̃̀wɛ̃ à pↄ́blewɛ yìa Misilanↄa, kũ nàa pì gbãna kũ̀ ń bùsun yãi. ");
INSERT INTO bqp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Akũ gbɛ̃nↄ bò andunia gu pínkia ò sù Misila pↄ́blewɛ lú Yusufua, zaakũ nà gbãna kũ̀ andunia gũn pínkimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kũ Yakubu mà pↄ́blewɛ kú Misila, à pì a nɛ́nↄnɛ: Ánigↄ̃ kátɛ la pã yá? ");
INSERT INTO bqp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ma mà pↄ́blewɛ kú Misila. À gɛ́ lúwɛrɛ gwe, de òsun garo, ògↄ̃ kun aafia yãi. ");
INSERT INTO bqp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Akũ Yusufu vĩ̀ni gbɛ̃nↄn kurinↄ gɛ̀ɛ Misila pↄ́blewɛ lú. ");
INSERT INTO bqp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakubu dí Yusufu dakũna Biliaminu zĩ kũńworo, zaakũ à pì: Òdigↄ̃ dↄ̃ro tó yã vãni ni a le. ");
INSERT INTO bqp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Akũ Isaraila nɛ́ pìnↄ gɛ̀ɛ pↄ́blewɛ lú kũ gbɛ̃ pãndenↄ, zaakũ nàa pìi kà Kanaanↄ bùsun dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusufu mɛ́ à bùsuu pì gbɛ̃ zↄ̃kↄ̃ ũ. Àkũ mɛ́ àdi pↄ́blewɛ yía gbɛ̃ sĩnda pínkia. Akũ a vĩ̀ninↄ sù ò kùtɛnɛ ò ń arɛ pɛ̀tɛ zĩtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kũ à a vĩ̀ninↄ è, à ń dↄ̃, akũ à a zĩda kɛ̀ńnɛ nibↄ ũ. Akũ à yã òńnɛ pãsĩpãsĩ à ń lá à pì: A bo máa? Ò wèa ò pì: O bo Kanaanↄ bùsun o su pↄ́blewɛ lúmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu a vĩ̀ninↄ dↄ̃̀, ama odi a dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nana kũ à ò yã ń yã musu dↄ̀agu, akũ à pìńnɛ: Gu'asirigwarinↄn á ũ, a su ó bùsu kĩaki gwamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ò wèa ò pì: Oi dikiri! N zↄ̀blerinↄn ó ũ, o su pↄ́blewɛ lúmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Dedokↄ̃nↄdenↄmɛ ó ũ ó pínki. Náanidenↄmɛ ó ũ. Ókↄ̃nↄ n zↄ̀blerinↄ, gu'asirigwarinↄmɛ ó ũro. ");
INSERT INTO bqp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Akũ à pìńnɛ: Ɛ́kɛmɛ! A su ó bùsu asiri dↄ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ò pì: Ókↄ̃nↄ n zↄ̀blerinↄ, dedokↄ̃nↄdenↄmɛ ó ũ, ó gbɛ̃nↄn kuri awɛɛplamɛ. Kanaanↄ bùsu gbɛ̃nↄmɛ ó ũ. Ó dakũna gↄ̃̀ bɛ kũ ó deo, ó gbɛ̃ do kunlo. ");
INSERT INTO bqp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Akũ Yusufu pìńnɛ: Lákũ ma òárɛ nà, gu'asirigwarinↄmɛ á ũ. ");
INSERT INTO bqp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Yã kũ ani tó mà á yãpura dↄ̃n dí. Kũ Firi'auna kunnaao áni bↄtɛ laro, séto á dakũna pìi sù la baasiro. ");
INSERT INTO bqp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","À á gbɛ̃ do zĩ à á dakũna sɛ́, á gbɛ̃ kparanↄ ni gↄ̃ kpɛ́siran la, mani dↄ̃ tó á yã yãpuramɛ. Tó lɛnlo, kũ Firi'auna kunnaao gu'asirigwarinↄn á ũ. ");
INSERT INTO bqp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Akũ à ń ká kpɛ́n ari gↄrↄ aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A gↄrↄ aakↄ̃de zĩ à pìńnɛ: Má Luda vĩna vĩ. À yã kũ mani oárɛ kɛ áni bo aafia. ");
INSERT INTO bqp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tó náanidenↄmɛ á ũ, à á gbɛ̃ do tó da kpɛ́n la, á gbɛ̃ kparanↄ ni tá kũ pↄ́blewɛo á bede nàdɛrinↄnɛ, ");
INSERT INTO bqp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","áni ɛra à sumɛnɛ kũ á dakũna pìio, mani dↄ̃ kũ á yã yãpuramɛ, oni á dɛdɛ doro. Akũ ò wèi lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ò pìkↄ̃nɛ: Yãpuramɛ taaridenↄn ó ũ yã kũ o kɛ̀ ó dakũnanɛ yã yãi. O è gↄrↄ kũ àtɛn kútɛ kɛwɛrɛ, à kɛ̀ wɛ̃nda, akũ ódi a yã maro. Abire yãin yã dí ó lé. ");
INSERT INTO bqp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Akũ Rubɛni pìńnɛ: Kũ ma òárɛ àsun yãke kɛ nɛ́ pìinɛro, ádi ma yã maro. A aru fĩnan Luda tɛn bowá dí. ");
INSERT INTO bqp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ò dↄ̃ Yusufu tɛn maro, zaakũ kũ àtɛn yã ońnɛ, òtɛn litɛńnɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Akũ à gò ń kĩnaa à gɛ̀ɛ à ↄ́ↄ dↄ̀. Kũ à sù, à yã òńnɛ, akũ à Simɛↄ bò ń gũn à a yĩ̀ ń wára. ");
INSERT INTO bqp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu pì ò pↄ́blewɛ káńnɛ ń asasanↄ pa ò ń baadi ↄgↄ danɛ a pↄ́n ò zɛ́ kusuna kɛńnɛ. Kũ ò kɛ̀ńnɛ lɛ, ");
INSERT INTO bqp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ò ń pↄ́blewɛnↄ dì ń zaakinↄnɛ, akũ ò dà zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kũ ò kà gu kũ òtɛn in, kũ ń gbɛ̃ do a asasa pòro de à pↄ́ kpá a zaakia, akũ à a ↄgↄ è a asasa lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Akũ à pì a gbɛ̃nↄnɛ: À ma asasa gũn gwa, ò ma ↄgↄ sùkpamɛnɛ! Akũ swɛ̃̀ɛ kɛ̃̀ńgu, ò pìkↄ̃nɛ kũ lukanaao: Bↄ́ yãn Luda kɛ̀wɛrɛ lɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kũ ò kà ń de Yakubu kĩnaa Kanaanↄ bùsun, ò yã kũ à ń lé bàbanɛ pínki ò pì: ");
INSERT INTO bqp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bùsu gbɛ̃ zↄ̃kↄ̃ↄ pì yã òwɛrɛ pãsĩpãsĩ, a ó dítɛ gu'asirigwarinↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","O pìnɛ náanidenↄmɛ ó ũ, gu'asirigwarinↄmɛ ó ũro. ");
INSERT INTO bqp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Dedokↄ̃nↄdenↄmɛ ó ũ, ó gbɛ̃nↄn kuri awɛɛplamɛ, ó gbɛ̃ do kunlo, ó dakũna gↄ̃̀ Kanaanↄ bùsun kũ ó deo. ");
INSERT INTO bqp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Akũ bùsu gbɛ̃ zↄ̃kↄ̃ↄ pìi pìwɛrɛ yã kũ ani tó á ó dↄ̃ náanidenↄ ũn dí. À pì ò ó gbɛ̃ do tó kãao, ò pↄ́blewɛ sɛ́ ò táo ó bede nàdɛrinↄnɛ, ");
INSERT INTO bqp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ò ɛra ò suárɛ kũ ó dakũnao, áni dↄ̃ sà kũ gu'asirigwarinↄmɛ ó ũro, náanidenↄmɛ ó ũ, áni ó gbɛ̃ndo kpáwá, óni laga tá bùsuu pìn. ");
INSERT INTO bqp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kũ òtɛn pↄ́blewɛ bↄtɛ ń asasanↄ gũn, ń baadi a ↄgↄsↄ̃nↄnↄ è a pↄ́ gũn. Kũ ò ń ↄgↄnↄ è lɛ, vĩna ń kũ ń pínki kũ ń deo. ");
INSERT INTO bqp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Akũ ń de pìńnɛ: Á ye mà gↄ̃ nɛ́ sarin yá? Yusufu kunlo, Simɛↄ kunlo, akũ á ye à Biliaminu síma dↄ yá? Yã sĩnda pínki tɛn bomɛnɛ vãnimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Akũ Rubɛni pì a denɛ: Tó mádi su kãaonnɛro, ǹ ma nɛ́gↄ̃gbɛ̃ planↄ dɛdɛ. Ǹ a kpáma, mani su kãaonnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Akũ Yakubu pì: Ma nɛ́ ni gɛ́ kãáoro, zaakũ a vĩ̀ni dadokↄ̃nↄde gà, àkũ à gↄ̃̀ ado. Ma zĩ kũ̀. Tó yãke a lè tá kũ átɛn o gũn, ani tó mà tá miran kũ pↄsiraomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nà pãsĩ kũ̀ Kanaanↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kũ ò pↄ́blewɛ kũ ò bòo Misila blè ò làka, ń de pìńnɛ: À ɛra à gɛ́ pↄ́blewɛ lú fíti dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Akũ Yuda pìnɛ: Gↄ̃gbɛ̃ pìi òwɛrɛ sãnsãmmɛ à pì, tó ó dakũna kú kũooro, óni wɛ́ sikↄ̃lɛro. ");
INSERT INTO bqp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tó ĩni we ó dakũna gɛ́ kũoo, óni gɛ́ ò pↄ́blewɛ lúnnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tó ńdi we sↄ̃ro, óni gɛ́ro, zaakũ gbɛ̃ pìi òwɛrɛ, tó ó dakũna kú kũooro, óni wɛ́ sikↄ̃lɛro. ");
INSERT INTO bqp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Akũ Isaraila pì: Bↄ́ yã mɛ́ à tò a wari dↄ̀ma, kũ a ò gbɛ̃ pìinɛ á dakũna vĩi? ");
INSERT INTO bqp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ò wèa ò pì: Àkũ mɛ́ à yã gbɛ̀kawá kũ ó bedenↄ yão à pì: Á de kun ari tera yá? Á dakũna vĩ yá? Yã birenↄ musun o wea. Ó dↄ̃ yã ani pi ò su kũ ó dakũnaon yá? ");
INSERT INTO bqp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Akũ Yuda pì a denɛ: Ǹ tó nɛ́ pì gɛ́ kũmao. Óni futɛ ò gɛ́ gↄ̃̀nↄmɛ, de ókↄ̃nↄ kũ mↄkↄ̃nwo kũ ó nɛ́nↄ òsun gagaro yãi, ónigↄ̃ kun aafia. ");
INSERT INTO bqp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","À gↄ̃̀ ma yã ũmɛ. Ma a zĩda wɛ̃̀ndii dìtɛ a pↄ́ gɛ̃nɛ ũ. Tó mádi su kãaonnɛ aafiaro, ma gↄ̃ n taaride ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tó ódi sika kɛ yãro, de o gɛ kũ gɛ̃̀n pladeo o su. ");
INSERT INTO bqp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Akũ ń de pìńnɛ: Tó lɛmɛ, à yã díkĩna kɛ. À ó bùsu pↄ́ mananↄ sɛ́tɛ à ká á asasanↄ gũn à gɛ́ à gↄ̃gbɛ̃ pì gba. À lí'ↄ ɛzɛ sɛ́ fíti kũ zↄ́'io fíti kũ do pↄ́nↄ kũ lí'ↄ gbĩ nnannao kũ gↄ̀rↄↄo kũ sĩo. ");
INSERT INTO bqp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","À gɛ́ kũ ↄgↄo lɛu pla à ↄgↄ kũ ò dàárɛ á asasanↄ gũn ɛrańnɛ. Ke ò sã̀tɛn yá, á dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","À á dakũna sɛ́ à ɛra à gɛ́ gↄ̃gbɛ̃ pì kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Luda Gbãnasĩndapinkide tó gbɛ̃ pì á wɛ̃nda gwa à á gbɛ̃ndo kũ Biliaminuo gbarɛ ò su kãáo. Makũ sↄ̃, tó Luda ma nɛ́nↄ sìmamɛ, à sìman gwe. ");
INSERT INTO bqp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ò pↄ́ kũ oni gɛ́ ò a gba pìnↄ sɛ̀tɛ kũ ↄgↄo lɛu pla kũ Biliaminuo ò fùtɛ ò gɛ̀ɛ Misila, akũ ò gɛ̀ɛ Yusufu kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kũ Yusufu Biliaminu è ń tɛ́, à pì a bɛgwariinɛ: Ǹ gɛ́ kũ gbɛ̃ birenↄ ma bɛa. Ǹ nↄ̀bↄ dɛ ǹ kɛkɛ, zaakũ gbɛ̃ pìnↄ ni pↄ́ ble kũmao fãnantɛ̃aramɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Bɛgwarii pì yã kũ Yusufu dànɛɛ kɛ̀ à gɛ̀ɛ kũńwo a bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kũ òtɛn gɛ́ kũńwo Yusufu bɛa lɛ, vĩna ń kũ ò pì: Ɔgↄ kũ ò dà ó asasanↄ gũn yã mɛ́ à tò òtɛn su kũoo la. Ò ye ò lɛ́tɛwá ò gbãna mↄwɛrɛ ò ó kũkũ zↄ̀nↄ ũ ò ó zaakinↄ sɛ́tɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kũ ò kà Yusufu bɛ kpɛ́lɛlɛa, ò nà a bɛgwarii pìii ò pì: ");
INSERT INTO bqp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Mare, n yã nna! O su ò pↄ́blewɛ lú la yã káaku. ");
INSERT INTO bqp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kũ o ka gu kũ óni in, o ó asasanↄ pòro, akũ ó baadi a ↄgↄ lè a asasa lɛ́n papana. Akũ o su kũ ↄgↄ pìio ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","O su kũ ↄgↄ pãndeo de ò pↄ́ble pãnde lúo. Ó dↄ̃ gbɛ̃ kũ à ↄgↄ pìi dà ó asasanↄ gũnlo. ");
INSERT INTO bqp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bɛgwarii pìi pì: Àsun damu kɛro, àsun vĩna kɛro. Á Luda, á de Luda mɛ́ à ↄgↄ pìi dàárɛ á asasanↄ gũn. Á ↄgↄ ma ki lè. Akũ à Simɛↄ bòńnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Bɛgwarii pìi gɛ̃̀ kũńwo Yusufu ↄnn, à í kpàḿma ò zú oo, akũ à sɛ̃̀ɛ kpà ń zaakinↄa. ");
INSERT INTO bqp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Akũ ò pↄ́ kũ oni Yusufu gba pì yã kɛ̀kɛ ari àgↄ̃ gɛ́ su fãnantɛ̃, zaakũ ò mà oni pↄ́ ble a bɛamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kũ Yusufu sù bɛ, ò a gbà pↄ́ kũ ò sùoo pìnↄ ò wùtɛ zĩtɛ a arɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","À ń aafiaa gbɛ̀ka, akũ à pì: Á de zĩkũna kũ a a yã òo pì gbãna yá? À kú kũ wɛ̃̀ndiio yá? ");
INSERT INTO bqp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ò wèa ò pì: Ó de n zↄ̀bleri gbãna à kun ari tera. Akũ ò kùtɛnɛ ò arɛ pɛ̀tɛ zĩtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu wɛ́ sɛ̀ à a dakũna dadokↄ̃nↄde Biliaminu gwà à pì: Á dakũna kũ a a yã òmɛnɛ pìin dí yá? Akũ à pì Biliaminunɛ: Luda arubarika dangu. ");
INSERT INTO bqp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kũ à a dakũna gwà, a pↄ kɛ̀ nna zↄ̃kↄ̃ à ye à ↄ́ↄ dↄ, akũ à gɛ̃̀ kpɛ́nɛn likalika à ↄ́ↄ dↄ̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kũ à ãnn pìpi, akũ à bò à a zĩda kũ̀ à pì ò su kũ pↄ́bleo. ");
INSERT INTO bqp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ò pↄ́ble dìtɛnɛ ado, ń pↄ́ sↄ̃ adona, Misila kũ ò kú kãaonↄ pↄ́ adona dↄ, zaakũ Misilanↄ dì pↄ́ ble kũ Eberunↄro òdi kakara kũńworo. ");
INSERT INTO bqp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ò ń vútɛvutɛ a arɛ ń sárakɛa, zaa dauduua ari ń gbɛ̃ kpɛdea, akũ ò lɛ́ àtɛ ò kↄ̃ gwàgwa. ");
INSERT INTO bqp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Akũ ò pↄ́ble kũ à kú Yusufu arɛ kpàatɛtɛńnɛ. Biliaminu pↄ́ zↄ̃kↄ̃ de gbɛ̃ kparanↄ pↄ́la lɛu sↄↄro. Akũ ò pↄ́ blè ò í mì kũ Yusufuo ari ò kã̀. ");
INSERT INTO bqp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu pì a bɛgwariinɛ: Ǹ pↄ́blewɛ káka gbɛ̃ pìnↄnɛ ń asasanↄ pa lákũ oni fↄ̃ ò sɛ́ nà. Ǹ baadi ↄgↄ danɛ a asasa lɛ́n ");
INSERT INTO bqp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ǹ ma andurufu toko sɛ́ ǹ da ń dakũna asasan kũ a pↄ́blewɛ ↄgↄo. Akũ à kɛ̀ lákũ Yusufu ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kũ gu dↄ̀ gↄ̃̀nↄ, ò ń gbárɛ kũ ń zaakinↄ. ");
INSERT INTO bqp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ari ògↄ̃ gɛ́ ká zã̀, akũ Yusufu pì a bɛgwariinɛ: Ǹ futɛ ǹ pɛ́tɛńyĩ. Tó n ń lé, ǹ ń la ǹ pi bↄ́ yã mɛ́ à tò ò fĩnaa bòmɛnɛ kũ a vãnio a mana gɛ̃nɛ ũu? ");
INSERT INTO bqp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bↄ́ yã mɛ́ à tò ò ma toko kũ madì í mio mà màso kɛoo sɛ̀ kpãnii? Ǹ ońnɛ kũ ò yã vãni kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kũ à ń lé, à yã pìi òńnɛ, ");
INSERT INTO bqp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","akũ ò wèa ò pì: Mare, à kɛ̀ dera n ò lɛɛ? Kúku! Ókↄ̃nↄ n zↄ̀blerinↄ, odì yã bire taka kɛro. ");
INSERT INTO bqp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ɔgↄ kũ o lè yã ó asasanↄ lɛ́ gũn, ódi ɛra o suonnɛ bona zaa Kanaaroo? Óni fↄ̃ ò andurufu ke wura sɛ́ kpãni n dikiri bɛa yá? ");
INSERT INTO bqp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mare, ó gbɛ̃ kũ n lè a kĩnaa, ade gà, ó pínki óni gↄ̃ n zↄ̀nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","À pì: Tↄ̀, à kɛ lákũ a ò nà. Gbɛ̃ kũ ò lè a kĩnaa ni gↄ̃ ma zↄ̀ ũmɛ, á gbɛ̃ kparanↄ ni gↄ̃ taari sari. ");
INSERT INTO bqp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Akũ ń baadi a asasa kìpa à pòro gↄ̃̀nↄ. ");
INSERT INTO bqp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Akũ bɛgwarii pì ń asasanↄ gwàgwa. À nà ń vĩ̀ni pↄ́a ari à gɛ̀ɛ à kào ń dakũna pↄ́a, akũ à toko pìi lè Biliaminu pↄ́ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ò ń utanↄ gà ò kɛ̃̀kɛ̃, akũ ń baadi a aso yĩ̀ a zaakinɛ ò ɛ̀ra ò gɛ̃̀ wɛ̃tɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kũ Yuda kũ a gbɛ̃nↄ kà Yusufu bɛa, ò a lè gwe, akũ ò kùtɛ a arɛ zĩtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","À pìńnɛ: Bↄ́yãin a kɛ̀ lɛɛ? Á dↄ̃ kũ ma taka dì màso kɛroo? ");
INSERT INTO bqp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda wèa à pì: Dikiri, óni pinnɛ deramɛɛ? À yãke ona vĩro. Óni kɛ dera ò ó zĩda bo yãnn? Luda mɛ́ à bò ó taaria. Dikiri, o gↄ̃ n zↄ̀nↄ ũ dí, ókↄ̃nↄ kũ gbɛ̃ kũ ò toko pìi lè a kĩnaao. ");
INSERT INTO bqp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Akũ Yusufu pì: Kai! Mani fↄ̃ mà abire kɛro. Gbɛ̃ kũ ò toko pìi lèa mɛ́ ani gↄ̃ ma zↄ̀ ũ, á gbɛ̃ kparanↄ áni ɛra à tá á de kĩnaa aafia. ");
INSERT INTO bqp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Akũ Yuda nài à pì: N yã nna dikiri! Ǹ tó makũ n zↄ̀bleri mà yã onnɛ. Ǹsun pↄ fɛ̃mairo dikiri, zaakũ ń sára kũ Firi'aunaomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Dikiri, n ó lá yã tó ó de vĩ ke dakũna. ");
INSERT INTO bqp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Akũ o pì ó de zĩ kũ̀, akũsↄ̃ ó dakũna kun dↄ, ó de a ì a zĩkũnaa gũmmɛ. Nɛ́ pìi vĩ̀ni dadokↄ̃nↄde gà, àkũ mɛ́ à gↄ̃̀ ado, akũ ó de pì yei manamana. ");
INSERT INTO bqp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","N ò ókↄ̃nↄ n zↄ̀blerinↄnɛ ò a sɛ́ ò su kãaonnɛ de ǹ wɛ́ sialɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Dikiri, o pìnnɛ nɛ́ pì ni fↄ̃ à a de tóro. Tó à a tò, de pì ni gamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Akũ n pìwɛrɛ, tó ódi su kũ ó dakũna pìioro, óni wɛ́ sikↄ̃lɛro. ");
INSERT INTO bqp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kũ o ta ó de kĩnaa, o n yã ònɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Akũ ó de pìi pì ò ɛra ò gɛ́ pↄ́blewɛ lú fíti dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","O pì, tó adi kɛ ó dakũna kú kũoo baasiro, óni fↄ̃ ò gɛ́ro, zaakũ tó à kú kũooro, óni wɛ́ sikↄ̃lɛro. ");
INSERT INTO bqp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Akũ ó de pìwɛrɛ, ó dↄ̃ kũ a nanↄ nɛ́ ì mɛ̀n pla. ");
INSERT INTO bqp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kũ a do bò a bɛa, adi a e doro ari gbãra. À pì nↄ̀bↄ pãsĩ mɛ́ à a sò. ");
INSERT INTO bqp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","À pì tó o nɛ́ bire sìawa, akũ yã vãni a lè, lákũ a zĩ kũ̀ nà, óni tó à tá miran kũ pↄsiraomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Tera sà, tó ma ta ma de kĩnaa, akũ a nɛ́ pì kú kũooro, ani gamɛ, zaakũ a pↄ kúamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Tó ó de dí nɛ́ pì e ó tɛ́ro, ani tá miran a zĩkũnaa gũn kũ pↄsiraomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ma a zĩda kpà ma dea nɛ́ pìi gɛ̃nɛ ũmɛ, ma pì tó mádi sunɛ kãaoro, mani gↄ̃ a taaride ũ ari ma wɛ̃̀ndi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Dikiri, n yã nna! Ǹ tó mà gↄ̃ n zↄ̀ ũ nɛ́ pìi gɛ̃nɛ ũ de à tá kũ a vĩ̀ninↄ. ");
INSERT INTO bqp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tó adi kɛ kũ nɛ́ pìioro, mani fↄ̃ mà tá ma de kĩnaaro. Ǹsun tó mà yã vãni kũ ani ma de le ero. ");
INSERT INTO bqp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusufu dí fↄ̃ à a zĩda kũ̀ a ìba kũ ò kú gwenↄ arɛ doro, akũ à pũ̀tã à pì: Ákↄ̃nↄ kũ á kú lanↄ, à bↄtɛ á pínki! Kũ gbɛ̃ke kú gwe doro, akũ à a zĩda bàba a vĩ̀ninↄnɛ sà. ");
INSERT INTO bqp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Àtɛn ↄ́ↄ dↄ gbãnagbãna ari Misilanↄ mà, akũ Firi'auna bedenↄ a baaruu mà. ");
INSERT INTO bqp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Akũ à pì a gbɛ̃ pìnↄnɛ: Yusufumɛ ma ũ. Ma de kun ari tera yá? Akũ swɛ̃̀ɛ kɛ̃̀ńgu, odi fↄ̃ ò wèaro. ");
INSERT INTO bqp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Akũ Yusufu pìńnɛ: À namai. Kũ ò nài, akũ à pì: Makũmɛ á dakũna Yusufu kũ a yìa ò sù kãao Misila la ũ. ");
INSERT INTO bqp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tera sà àsun tó á nɛ̀sɛɛ yakaro. Àsun pↄ fɛ̃ ma yiana yã musuro, zaakũ gbɛ̃nↄ surabana yãin Luda ma zĩ á arɛ la. ");
INSERT INTO bqp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nà kana bùsun la wɛ̃̀ pladen dí. Oni bú baro oni pↄ́ kɛ̃ro ari wɛ̃̀ sↄↄro. ");
INSERT INTO bqp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Luda tò ma doárɛ arɛ de ó buri bo aafia andunia gũn, mà á sura ba manamana. ");
INSERT INTO bqp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Adi kɛ ákↄ̃nↄ mɛ́ a ma zĩ laro, Ludamɛ. À ma ditɛ Firi'auna lɛ́dammari ũ, a bɛgwari ũ, Misila gu sĩnda pínki gbɛ̃ zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","À kɛ likalika à gɛ́ ó de kĩnaa à onɛ a nɛ́ Yusufu pì Luda a ditɛ Misila bùsu gbãnade ũ. À su ma kĩnaa la gↄ̃̀nↄ. ");
INSERT INTO bqp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Àgↄ̃ kú kũmao kãni à vutɛ Gosɛ̃ bùsun kũ a nɛ́nↄ kũ a daikorenↄ kũ a sãnↄ kũ a blènↄ kũ a zùnↄ kũ pↄ́ kũ à vĩnↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mani a gwa la, zaakũ nà nigↄ̃ kun ari wɛ̃̀ sↄↄro dↄmɛ. Tó lɛnlo, àkũ kũ a bedenↄ kũ pↄ́ kũ à vĩnↄ ni kakatɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ákↄ̃nↄ kũ Biliaminuo, a è kũ wɛ́o kũ makũ Yusufu makũ mɛ́ matɛn yã oárɛ. ");
INSERT INTO bqp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","À bɛ̀ɛrɛ kũ má vĩ Misila la yã o ma denɛ kũ pↄ́ kũ a èo pínki. À gɛ́ à su kãao la likalika. ");
INSERT INTO bqp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","À vĩ̀ à lòko a dakũna Biliaminu wakaaa à ↄ́ↄ dↄ̀, akũ Biliaminu mlɛ̃̀a à ↄ́ↄ dↄ̀ se. ");
INSERT INTO bqp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Akũ à lɛ́ pɛ̀pɛ a vĩ̀ninↄa ń pínki kũ ↄ́ↄdↄo. Abire gbɛra a vĩ̀ninↄ yã ò kãao. ");
INSERT INTO bqp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kũ Yusufu vĩ̀ninↄ suna baaruu kà Firi'auna bɛa, à kɛ̀nɛ nna kũ a ìbanↄ. ");
INSERT INTO bqp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Akũ à pì Yusufunɛ: Ǹ o n vĩ̀ninↄnɛ ò ń aso yĩ ń zaakinↄnɛ ò futɛ ò gɛ́ Kanaa, ");
INSERT INTO bqp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ò ń de sɛ́ kũ n bedenↄ ò su kũńwo ma kĩnaa la. Mani Misila bùsu gu mana kpáḿma ògↄ̃ nna ma. ");
INSERT INTO bqp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ǹ ońnɛ dↄ ò Misila zùgonↄ sɛ́ ń nɛ́ fítinↄ kũ ń nↄgbɛ̃nↄ yãi, ò ń de sɛ́ ò su kãao. ");
INSERT INTO bqp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Òsun laasun lɛ́ pↄ́ kũ oni tó gwenↄaro, zaakũ Misila gu mana ni gↄ̃ ń pↄ́ ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Akũ Isaraila nɛ́ pìnↄ kɛ̀ lɛ. Yusufu zùgonↄ kpàḿma lákũ Firi'auna ò nà. À zɛ́ zànaa kɛ̀ńnɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","À ń gbá uta zↄ̃kↄ̃nↄ ń pínki, akũ à Biliaminu gbà andurufu ↄgↄ mɛ̀n wàa do kpɛ́ basↄↄro kũ uta zↄ̃kↄ̃nↄ mɛ̀n sↄↄro. ");
INSERT INTO bqp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","À Misila pↄ́ mananↄ kpã̀zã a denɛ zaaki aso kuri kũ pↄ́blewɛo kũ pↄ́bleo zaaki aso kuri a de zɛ́ zàna ũ. ");
INSERT INTO bqp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kũ à ń gbárɛ à pì: Àsun fìti kɛ zɛ́nlo! Akũ ò tà. ");
INSERT INTO bqp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ò bò Misila, akũ ò kà Kanaanↄ bùsun ń de Yakubu kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ò pìnɛ: Yusufu kú wɛ̃̀ndiio ari tera, àkũmɛ Misila bùsu gbɛ̃ zↄ̃kↄ̃ ũ. Akũ Yakubu kɛ̀ sã̀ii, adi síro. ");
INSERT INTO bqp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Akũ ò yã kũ Yusufu òńnɛ ònɛ pínki. Kũ Isaraila zùgo kũ Yusufu gbàrɛ à a sɛ́nↄ è, akũ a laasun kɛ̀ do sà, ");
INSERT INTO bqp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","akũ à pì: Adikĩna mↄ̀! Ma nɛ́ Yusufu kú kũ wɛ̃̀ndiio ari tera. Mani gɛ́ mà wɛ́ sialɛ de má kpɛ́ mà ga. ");
INSERT INTO bqp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isaraila dà zɛ́n kũ pↄ́ kũ a vĩnↄ pínki. Kũ à kà Bɛsɛba, à sa ò a de Isaaku Ludaa. ");
INSERT INTO bqp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Akũ Luda bò à sùa wɛ́gupu'enaa gũn gwãani à pì: Yakubu! Yakubu! À wèa à pì: Makũ di! ");
INSERT INTO bqp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Akũ à pì: Makũmɛ Luda ũ n de Luda. Ǹsun Misila gɛna damu kɛro, zaakũ gwen mani n buri karan manamana. ");
INSERT INTO bqp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mani gɛ́ kũnwo Misila mà ɛra mà su kũ n burinↄ. Yusufu gbádan ĩni gan. ");
INSERT INTO bqp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Akũ Yakubu fùtɛ Bɛsɛba. A nɛ́nↄ a dà zùgo kũ Firi'auna gbàrɛ ò a sɛ́onↄ gũn kũ ń nɛ́nↄ kũ ń nanↄnↄo. ");
INSERT INTO bqp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ò ń pↄ́kãdenↄ kũ aruzɛkɛ kũ ò lè Kanaanↄ bùsunnↄ sɛ̀tɛ ò tào Misila. ");
INSERT INTO bqp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakubu tà gwe kũ a nɛ́gↄ̃gbɛ̃nↄ kũ a nɛ́nↄgbɛ̃nↄ kũ a daikorenↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isaraila kũ ò tà Misilanↄ tↄ́nↄn dí, Yakubu kũ a burinↄ: Yakubu daudu Rubɛni. ");
INSERT INTO bqp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubɛni nɛ́gↄ̃gbɛ̃nↄ Anↄku, Palu, Ɛzɛrↄnu kũ Kaamio. ");
INSERT INTO bqp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simɛↄ nɛ́gↄ̃gbɛ̃nↄ Yemuɛli, Yami, Oada, Yakĩ, Zoa kũ Sauluo kũ à a ì kũ Kanaa nↄgbɛ̃o. ");
INSERT INTO bqp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi nɛ́gↄ̃gbɛ̃nↄ Gɛsↄmu, Koa kũ Mɛrario. ");
INSERT INTO bqp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda nɛ́gↄ̃gbɛ̃nↄ Ɛɛ, Ona, Sela, Pɛrɛzi kũ Zɛrao, ama Ɛɛ kũ Onao gà Kanaamɛ. Pɛrɛzi nɛ́gↄ̃gbɛ̃nↄ Ɛzɛrↄnu kũ Amuluo. ");
INSERT INTO bqp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka nɛ́gↄ̃gbɛ̃nↄ Tola, Pua, Yasubu kũ Simirↄnuo. ");
INSERT INTO bqp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zɛbuluni nɛ́gↄ̃gbɛ̃nↄ Sɛrɛdi, Ɛlↄni kũ Yalɛlio. ");
INSERT INTO bqp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nɛ́gↄ̃gbɛ̃ kũ Lea ń í kũ Yakubuo Mɛsↄpↄtamianↄn gwe. Àkũ mɛ́ à a nɛ́nↄgbɛ̃ Dina ì dↄ. Ń buri pìnↄ ń pínki gbɛ̃nↄn baraakuri awɛɛ'aakↄ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gada nɛ́gↄ̃gbɛ̃nↄ Zɛfↄ̃, Agi, Suni, Ɛzɛbↄ̃, Eri, Arodi kũ Arɛlio. ");
INSERT INTO bqp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asa nɛ́gↄ̃gbɛ̃nↄ Imina, Isiva, Isivi, Bɛria kũ ń dãre Sɛrao. Bɛria nɛ́gↄ̃gbɛ̃nↄ Eberu kũ Malakiɛlio. ");
INSERT INTO bqp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Labã mɛ́ à Zilipa kpà Leaa. Buri kũ Zilipa kɛ̀ kũ Yakubuon gwe. Ò gbɛ̃nↄn gɛ̃ro awɛɛdomɛ. ");
INSERT INTO bqp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakubu nanↄ Rahila nɛ́gↄ̃gbɛ̃nↄ Yusufu kũ Biliaminuo. ");
INSERT INTO bqp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufu Manase kũ Ɛflaimuo ì Misila kũ a nanↄ Asɛna, Ɛliↄpↄli sa'ori Potifɛra nɛ́o. ");
INSERT INTO bqp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Biliaminu nɛ́gↄ̃gbɛ̃nↄ Bɛla, Bɛkɛ, Asabɛli, Gera, Naama, Ɛhi, Rosu, Mupimu, Upimu kũ Adao. ");
INSERT INTO bqp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Buri kũ Rahila kɛ̀ kũ Yakubuonↄn gwe. Ò gbɛ̃nↄn gɛ̃ro donsarimɛ. ");
INSERT INTO bqp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dã nɛ́gↄ̃gbɛ̃ Usimu. ");
INSERT INTO bqp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafatali nɛ́gↄ̃gbɛ̃nↄ Yaziɛli, Guni, Yɛzɛ kũ Silɛmuo. ");
INSERT INTO bqp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Labã mɛ́ à Bila kpà Rahilaa. Buri kũ Bila kɛ̀ kũ Yakubuonↄn gwe. Ò gbɛ̃nↄn supplamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakubu buri kũ ò tà kũńwo Misilanↄn gwe. Ò gbɛ̃nↄn baaakↄ̃ awɛɛsuddomɛ a nɛ́ nↄnↄ baasi. ");
INSERT INTO bqp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kũ Yusufu nɛ́ ì Misila gbɛ̃nↄn pla, akũ Yakubu buri kũ ò tà gwenↄ kɛ̀ gbɛ̃nↄn baaakↄ̃ akuri. ");
INSERT INTO bqp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakubu Yuda zĩ̀ à donɛ arɛ Yusufu kĩnaa de à Gosɛ̃ bùsu zɛ́ mↄnɛ. Kũ ò kà gwe, ");
INSERT INTO bqp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","akũ Yusufu gɛ̃̀ a sↄ̃gon à gɛ̀ɛ da a delɛ gwe. Kũ à a lè, à mlɛ̃̀a à ↄ́ↄ dↄ̀ à gìi kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Akũ Isaraila pì Yusufunɛ: Lákũ ma wɛ́ sìnlɛ nà ma è ń kú wɛ̃̀ndiio, ga ni fↄ̃ à ma sɛ́ sà. ");
INSERT INTO bqp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu pì a vĩ̀ninↄnɛ kũ a de bedenↄ: Mani gɛ́ mà o Firi'aunanɛ ma vĩ̀ninↄ kũ ma de bede kũ ò kú Kanaanↄ bùsunnↄ sù ma kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mani onɛ kũ sãdãrinↄmɛ á ũ, á pↄ́kãdenↄ vĩ, akũ a su kũ á sãnↄ kũ á blènↄ kũ á zùnↄ kũ pↄ́ kũ á vĩnↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tó Firi'auna á sísi, akũ à á lá bↄ́ zĩn adì kɛ, ");
INSERT INTO bqp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","à onɛ à pi á pↄ́kãdedenↄ ũ zaa á kɛfɛnnakɛgↄrↄa ari kũ a gbãrao lán á dizinↄ bà. Tó a ònɛ lɛ, áni le à vutɛ Gosɛ̃ bùsun, zaakũ Misilanↄ dì kakara kũ sãdãrinↄro. ");
INSERT INTO bqp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu gɛ̀ɛ à yã ò Firi'aunanɛ à pì: Ma vĩ̀ninↄ bò Kanaanↄ bùsun kũ ń sãnↄ kũ ń blènↄ kũ ń zùnↄ kũ pↄ́ kũ ò vĩnↄ pínki, ò sù Gosɛ̃ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Akũ à a vĩ̀ninↄ sɛ̀ gbɛ̃nↄn sↄↄro à ń mↄ́ Firi'aunanɛ. ");
INSERT INTO bqp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firi'auna ń lá à pì: Bↄ́ zĩn adì kɛɛ? Ò wèa ò pì: Ókↄ̃nↄ n zↄ̀blerinↄ, sãdãrinↄn ó ũ lán ó dizinↄ bà. ");
INSERT INTO bqp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Akũ ò pìnɛ: O su vutɛ bùsun la gↄrↄ plamɛ, zaakũ nà kú Kanaanↄ bùsun manamana, sɛ̃̀ kun kũ ó sãnↄ blero. Ókↄ̃nↄ n zↄ̀blerinↄ, ǹ ó gba zɛ́ ò vutɛ Gosɛ̃ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Akũ Firi'auna pì Yusufunɛ: Lákũ n de kũ n vĩ̀ninↄ sù n kĩnaa nà, ");
INSERT INTO bqp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ǹ ń kátɛ Misila gu manan. Ò vutɛ Gosɛ̃ bùsun. Tó laakaridenↄn kú ń tɛ́, ǹ ma pↄ́nↄ nańnɛ ń ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Akũ Yusufu a de Yakubu sɛ̀ à gɛ̀ɛ à mↄ̀ Firi'aunanɛ. Akũ Yakubu sa mana ònɛ. ");
INSERT INTO bqp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firi'auna a là à pì: N ka wɛ̃̀n gbaa? ");
INSERT INTO bqp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","À wèa à pì: Ma kunna andunia gũn wɛ̃̀ basuddo akuriden dí. Ma wɛ̃̀ dí ká ma dizinↄ pↄ́ ũro, akũ à yã'ũmmana vĩ. ");
INSERT INTO bqp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","À sa mana ò Firi'aunanɛ dↄ, akũ à bò a kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu a de kũ a vĩ̀ninↄ kàtɛ Misila bùsu gu manan à ń gbá bùsu kũ Ramɛsɛ de a wɛ́ra ũ lákũ Firi'auna ò nà. ");
INSERT INTO bqp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu pↄ́blewɛ kpà a dea kũ a vĩ̀ninↄ kũ a de bedenↄ ń pínki ↄn kũ ↄnnwo ń dasi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nàa kɛ̀ gbãna, pↄ́blewɛ kú gukearo. Misilanↄ kũ Kanaanↄ gbãna làka. ");
INSERT INTO bqp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Òtɛn pↄ́blewɛ lú, akũ Yusufu ↄgↄ kũ à kú Misila kũ Kanaao sì pínki à tào Firi'auna bɛa. ");
INSERT INTO bqp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kũ Misilanↄ kũ Kanaanↄ ↄgↄ làka, Misilanↄ sù Yusufu kĩnaa ń pínki ò pì: Ɔgↄ kun doro. Ǹ ó gba pↄ́blewɛ. Ǹsun tó ò ga n wáraro. ");
INSERT INTO bqp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu pì: Lákũ ↄgↄ kunlo nà, à su kũ á pↄ́kãdenↄ, mani pↄ́blewɛ kpááwa a musu. ");
INSERT INTO bqp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Akũ ò sù Yusufunɛ kũ pↄ́kãdenↄ, akũ à pↄ́blewɛ kpàḿma sↄ̃nↄ kũ sãnↄ kũ blènↄ kũ zùnↄ kũ zaakinↄ musu. Wɛ̃̀ birea à pↄ́blewɛ kpàḿma ń pↄ́kãdenↄ musumɛ. ");
INSERT INTO bqp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kũ wɛ̃̀ bire gɛ̃̀tɛ, akũ ò sù a kĩnaa a wɛ̃̀ làa ò pìnɛ: Dikiri, óni fↄ̃ ò yãke utɛnnɛro. Ɔgↄ làka, akũ ó pↄ́kãdenↄ gↄ̃̀ n pↄ́ ũ. Pↄ́ke dí gↄ̃ ò kpámmaro, ókↄ̃nↄ kũ ó buranↄ baasiro. ");
INSERT INTO bqp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ǹsun tó ò ga n wára kũ ó buranↄro. Ǹ ó lú kũ ó buranↄ ǹ fĩna bo kũ pↄ́blewɛo ò gↄ̃ Firi'auna zↄ̀nↄ ũ, ókↄ̃nↄ kũ ó buranↄ. Ǹ ó gba pↄ́blewɛ de òsun garo ògↄ̃ kun, akũsↄ̃ de ó buranↄ sún gↄ̃ tàraga ũro. ");
INSERT INTO bqp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Akũ Yusufu Misila buranↄ lù Firi'aunanɛ pínki, zaakũ Misilanↄ baadi a bura yìa, kũ nà ń kũ gbãna yãi, akũ bùsuu gↄ̃̀ Firi'auna pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusufu Misilanↄ sì zↄ̀nↄ ũ ń pínki zaa ń bùsu lɛ́n la gɛna a lɛ́ dire. ");
INSERT INTO bqp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ama adi sa'orinↄ buranↄ lúro, zaakũ Firi'auna dìtɛ àgↄ̃ pↄ́blewɛ kpáḿma gↄrↄ sĩnda pínki. Lákũ ò kú kũ pↄ́blewɛ kũ Firi'auna dì kpáḿmao nà, odi ń buranↄ yíaro. ");
INSERT INTO bqp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Akũ Yusufu pì gbɛ̃nↄnɛ: Ma á lú kũ á buranↄ sà, a gↄ̃ Firi'auna pↄ́ ũ. Pↄ́blewɛn dí. À gɛ́ à tↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pↄ́kɛ̃gↄrↄ àgↄ̃ a lɛu sↄↄrode kpá Firi'aunaa, a kpara ni gↄ̃árɛ pↄ́wɛ ũ kũ pↄ́bleo. Àgↄ̃ abire ble kũ á nɛ́nↄ kũ á bedenↄ á pínki. ");
INSERT INTO bqp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Akũ ò pì: N ó sura bà. Ǹ tó ò n pↄnna le dikiri, ò gↄ̃ Firi'auna zↄ̀nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Akũ Yusufu yã dìtɛ Misila à pì, burapↄ lɛu sↄↄrode nigↄ̃ de Firi'auna pↄ́ ũ. Yã pì kun ari kũ a gbãrao. Sa'orinↄ bùsu mɛ́ adi gↄ̃ Firi'auna pↄ́ ũro ado. ");
INSERT INTO bqp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isarailanↄn kú Gosɛ̃ bùsun zaa Misila. Ò ń zĩda zĩtɛ vĩ gwe, akũ ò nɛ́ ì ò kàra manamana. ");
INSERT INTO bqp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakubu kɛ̀ wɛ̃̀ gɛ̃ro awɛɛpla Misila, a wɛ̃̀ pínkipinki basuppla awɛɛsupplamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kũ à kà gana, à a nɛ́ Yusufu sìsi, akũ à pìnɛ: N yã nna! Tó ma n pↄnna lè, ǹ n ↄ da ma gbáda gbáru ǹ gbɛ̃kɛ kũ náanio yã kɛmɛnɛ. Ǹsun ǹ ma vĩ Misilaro. ");
INSERT INTO bqp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tó ma ka ma dizinↄla, ǹ ma sɛ́ ǹ bo kũmao Misila la ǹ ma vĩ ma dizi pìnↄ miran. Akũ Yusufu pìnɛ: Mani yã kũ n ò kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Akũ Yakubu pì: Ǹ la damɛnɛ. Kũ à la dànɛ, akũ Yakubu gbãna lè a gòoa à donyĩ kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Gↄrↄ pla gbɛra ò ò Yusufunɛ a de tɛn gyã kɛ, akũ à a nɛ́ gbɛ̃nↄn planↄ Manase kũ Ɛflaimuo sɛ̀tɛ à gɛ̀ɛ kũńwo. ");
INSERT INTO bqp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kũ ò ò Yakubunɛ a nɛ́ Yusufu sù a gwa, à kokari kɛ̀ à fùtɛ à vùtɛ a gádo musu. ");
INSERT INTO bqp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","À pì Yusufunɛ: Luda Gbãnasĩndapinkide bò à sùma zaa Luzu, Kanaanↄ bùsun, à arubarikaa dàmagu ");
INSERT INTO bqp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","à pìmɛnɛ áni tó mà nɛ́ i manamana, áni ma kara mà gↄ̃ burinↄ dizi ũ áni bùsuu pì kpá ma burinↄa ma gbɛra ń pↄ́ ũ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tera sà nɛ́ gbɛ̃nↄn pla kũ n ń í Misila ari màgↄ̃ su n kĩnaanↄ ma pↄ́nↄmɛ. Ɛflaimu kũ Manaseo gↄ̃̀ ma nɛ́nↄ ũ lákũ Rubɛni kũ Simɛↄo de nà. ");
INSERT INTO bqp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nɛ́ kũ ĩni ń i ń gbɛranↄ mɛ́ onigↄ̃ de n pↄ́ ũ, oni ń túbi ble ń vĩ̀ninↄ kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Zaakũ kũ matɛn su kũ Mɛsↄpↄtamiao, n da Rahila gà zɛ́n Ɛflata kũ òdi pi tera Bɛtilihamu lɛ́i zaa Kanaanↄ bùsun, akũ ma a vĩ̀ zɛ́n gwe. ");
INSERT INTO bqp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Akũ Isaraila Yusufu nɛ́nↄ gwà à pì: Dínↄn gwee? ");
INSERT INTO bqp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","À pì a denɛ: Nɛ́ kũ Luda ma gba lanↄn gwe. Akũ Isaraila pì: Ǹ mↄ́ kũńwo ma kĩnaa mà sa'olɛ kɛńnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Zĩkũna Isaraila wɛ́ bùsa àtɛn gu e manaro, akũ Yusufu nài kũ nɛ́ pìnↄ. Isaraila lɛ́ pɛ̀pɛḿma à ń kpá a kùla, ");
INSERT INTO bqp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","akũ à pì Yusufunɛ: Mádi da yã mà wɛ́ sinlɛ doro, akũ Luda tò ma n e kũ n nɛ́nↄ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu ń gó a de gbála, akũ à kùtɛnɛ à a arɛ pɛ̀tɛ. ");
INSERT INTO bqp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Akũ Yusufu a nɛ́nↄ kũ̀ ń pla ń pínki. À Ɛflaimu kũ̀ kũ ↄplao Yakubu ↄzɛ kpa, akũ à Manase kũ̀ ↄzɛ kpa Yakubu ↄpla kpa, akũ à nài kũ nɛ́ pìnↄ. ");
INSERT INTO bqp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Akũ Yakubu a ↄ pã̀kↄ̃la à a ↄpla nà Ɛflaimu kũ à de dakũna ũ mìia, à a ↄzɛ nà Manase kũ à de daudu ũ mìia. ");
INSERT INTO bqp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Akũ à sa'olɛ kɛ̀ Yusufunɛ à pì: Luda kũ ma dizinↄ Ibrahĩ kũ Isaakuo táa ò kãao, Luda kũ à dòmɛnɛ arɛ ma kunnaa gũn ari kũ a gbãrao, ");
INSERT INTO bqp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","a Malaika kũ à ma bo a vãnin pínki à arubarika da nɛ́ díkĩnanↄgu, à tó ògↄ̃ ń sísi ma tↄ́a, kũ ma dizinↄ Ibrahĩ kũ Isaakuo tↄ́o, à tó ògↄ̃ kↄ̃ manamana andunia gũn. ");
INSERT INTO bqp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kũ Yusufu è a de a ↄpla nà Ɛflaimu mìia, adi kɛnɛ nnaro. À a de ↄ kũ̀ de à go Ɛflaimu mìia à na Manase pↄ́a ");
INSERT INTO bqp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","à pì: Lɛnlo Baa, gbɛ̃ díkĩna mɛ́ à daudu ũ. Ǹ n ↄpla na a mìia. ");
INSERT INTO bqp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Akũ a de gì à pì: Má dↄ̃ ma nɛ́, má dↄ̃. Àpi sↄ̃ ani gↄ̃ buri ũ, anigↄ̃ zↄ̃kↄ̃, ama a dakũna zↄ̃kↄ̃ nigↄ̃ deala, a buri nigↄ̃ dasi. ");
INSERT INTO bqp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Zĩ kũ̀a à sa'olɛ kɛ̀ńnɛ à pì: Isarailanↄ ni sa mana okↄ̃nɛ kũ á tↄ́o oni pi Luda tó ǹ gↄ̃ lán Ɛflaimu kũ Manaseoo bà. Lɛmɛ à Ɛflaimu dò Manasenɛ arɛ lɛ. ");
INSERT INTO bqp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Akũ Isaraila pì Yusufunɛ: Ma ka gana, ama Luda nigↄ̃ kú kãáo, ani ɛra à tá kãáo á dizinↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sɛkɛmu bùsu mana kũ ma sì Amↄrinↄa kũ ma fɛ̃nɛdao kũ ma sáo, ma n gba, mↄkↄ̃n kũ ń de n vĩ̀ninↄla. ");
INSERT INTO bqp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakubu a nɛ́nↄ sìsi, akũ à pì: À kↄ̃ kakara mà yã kũ ani á le ziakpɛzĩ oárɛ. ");
INSERT INTO bqp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","À kↄ̃ kakara ma nɛ́nↄ à sã kpá, à á de Isaraila yã ma. ");
INSERT INTO bqp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubɛni ma daudu ma gbãna, ma kana gↄ̃ lɛ́i nɛ́ káaku, n bɛ̀ɛrɛ deńla kũ n gbãnao. ");
INSERT INTO bqp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ń pãsĩ lán ísↄ̃ bà, ama ĩnigↄ̃ deńlaro, zaakũ n didi n de gádoa, n wutɛ kũ ma nↄnↄ dokeo. ");
INSERT INTO bqp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simɛↄ kũ Levio mɛ́ ò kↄ̃ gbɛ̃nↄ ũ, ò pãsĩ kũ fɛ̃nɛdao. ");
INSERT INTO bqp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ma lɛ́ kú ń kakaranaa gũnlo, ma baka kú ń yãgↄ̃gↄ̃naa gũnlo, zaakũ ò gbɛ̃nↄ dɛ̀dɛ pↄfɛ̃ gũn, ò zù gbátĩnↄ zↄ̃̀zↄ̃ lákũ ò yei nà. ");
INSERT INTO bqp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Luda láari boḿma ń pↄfɛ̃ zↄ̃kↄ̃ yãi, à lɛ́ kɛńnɛ ń pãsĩkɛ yãi. Mani ń kɛ̃kↄ̃a Yakubu burinↄ tɛ́, mani ń burinↄ fãkↄ̃a Isarailanↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, n gbɛ̃nↄ ni n tↄ́ kpá. Ĩni n ibɛrɛnↄ kũ ń wakaaa, n de nɛ́nↄ ni kútɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda de lán músu bà, ma nɛ́ pìi dì su kũ tofekao àdi gátɛ àdi wútɛ a tòn. Dí mɛ́ ani fↄ̃ à a futɛɛ? ");
INSERT INTO bqp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kpata ni go Yudalaro, a burinↄ mɛ́ onigↄ̃ gò kũna ari Silo gɛ́ su, buri sĩnda pínki ni mì natɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ani a zaaki dↄ geepi lía, ani a zaakinɛ yĩ geepi lí manaa. Sèwɛ̃ nigↄ̃ dimɛ ani a pↄ́kasanↄ pípio, ani a uta pípi kũ geepi'io. ");
INSERT INTO bqp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Sèwɛ̃ ni a wɛ́ tɛ̃ra kũ, vĩ ni a saka pura kũ. ");
INSERT INTO bqp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zɛbuluni nigↄ̃ kú ísira sarɛ, a bùsu nigↄ̃ de gó'itɛnↄ bàdↄki ũ. A bùsu lɛ́ ni zɛ Sidↄ̃. ");
INSERT INTO bqp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka de lán zaaki gbãna kũ à wutɛna aso mɛ̀n pla dagura bà. ");
INSERT INTO bqp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tó a burinↄ è ń kámmaboki mana, akũsↄ̃ ń bùsu pì vutɛna nna, oni natɛ asosɛnaanɛ ò zↄ̀zĩ kɛ. ");
INSERT INTO bqp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dã ni a gbɛ̃nↄ bo yãn Isaraila burinↄ doke ũ. ");
INSERT INTO bqp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dã nigↄ̃ de lán mlɛ̃̀ kũ à kú zɛ́ sarɛ bà, lán pitiko kũ à kú zɛ́wɛwɛ gũn bà. Àdi sↄ̃ lɛ́ a gbáa, de gbɛ̃ kũ à di a musu lɛ́tɛ a kpɛdangara. ");
INSERT INTO bqp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Dikiri, madì wɛ́ dↄ n surabanaai. ");
INSERT INTO bqp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada sↄ̃, zĩ̀karinↄ ni sińgu, ama oni lɛ́tɛ ń kpɛdenↄa. ");
INSERT INTO bqp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asa pↄ́blewɛ nigↄ̃ nísi vĩ, pↄ́ble kũ a blena nna kínanↄnɛɛn ani kpá. ");
INSERT INTO bqp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatali de lán gbɛ̃tɛ̃ lí kũ àdi gã̀ mananↄ bo bà. ");
INSERT INTO bqp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu de lán lí nɛ́'iri kũ à kú ísɛ̃boki sarɛ bà, a gã̀nↄ dì poro à da gbĩ̀la. ");
INSERT INTO bqp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kàzurinↄ ni ibɛrɛ sɛ́o, ò pɛ́a kũ kàao. ");
INSERT INTO bqp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Anigↄ̃ a sá kũna yĩgãnaa sari Yakubu Luda gbãnade gãi, a ↄ gbãna nigↄ̃ wãna Isarailanↄ Gbɛ̀si kũ àdi donɛ arɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","N de Luda pì ni kpányĩ, Gbãnasĩndapinkide pì ni arubarika dangu kũ legũ'i kũ àdi bo musuo, kũ arubarika kũ à katɛna zĩtɛ gbáruo, de n nↄnↄ kũ n pↄ́nↄ gↄ̃ de nɛ́randenↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sa'olɛ kũ n de kɛ̀nnɛ de ma dizinↄ pↄ́la, à zↄ̃kↄ̃ de kpi zĩnↄla. Luda tó arubarika dínↄ gↄ̃ Yusufu mìia, gbɛ̃ kũ ò dìtɛ adona a gbɛ̃nↄ tɛ́ musu. ");
INSERT INTO bqp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Biliaminu de lán lɛwanna pãsĩ bà, àdi lɛ́tɛ gbɛ̃nↄa kↄnkↄ, àdi ń pↄ́nↄ kpàatɛ ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isaraila buri mɛ̀n kuri awɛɛplanↄn gwe ń pínki. Sa'olɛ kũ ń de kɛ̀ńnɛn gwe baadi kũ a pↄ́o. ");
INSERT INTO bqp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Akũ à pìńnɛ: Tó ma andunia tò, à ma vĩ ma dizinↄ gbɛ̀wɛɛ kũ à kú Iti buri Ɛflↄnu bura gũn. ");
INSERT INTO bqp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Gbɛ̀wɛɛ pì kú Makpɛlamɛ, Mamare ifãboki kpa Kanaanↄ bùsun, bura kũ Ibrahĩ lù Iti buri Ɛflↄnua gɛ̀vĩki ũ. ");
INSERT INTO bqp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Gwen ò Ibrahĩ kũ a nanↄ Sarao vĩ̀n. Gwen ò Isaaku kũ a nanↄ Rɛbɛkao vĩ̀n. Gwen ma Lea vĩ̀n. ");
INSERT INTO bqp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ò bura pì kũ a gbɛ̀wɛɛɛoo lù Itinↄamɛ. ");
INSERT INTO bqp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kũ Yakubu lɛ́ dìtɛ a nɛ́nↄnɛ à làka, à ɛ̀ra à wùtɛ, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu kùsi a dea à ↄ́ↄ dↄ̀ a musu à lɛ́ pɛ̀pɛa. ");
INSERT INTO bqp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Akũ à ò a zĩkɛri ɛzɛdenↄnɛ ò ɛzɛ kũ àdi tó gɛ̀ vãro máma a de gɛ̀ɛa. Akũ ò màma Isaraila gɛ̀ɛa ");
INSERT INTO bqp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ari gↄrↄ bupla de àsun yagi kɛro yãi, zaakũ lɛn Misilanↄ dì kɛ lɛ, akũ ò a gɛ̀ ↄ́ↄ dↄ̀ gↄrↄ baaakↄ̃ akuri. ");
INSERT INTO bqp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kũ ò a gɛ̀ ↄ́ↄ dↄ̀ ò làka, Yusufu pì Firi'auna ↄndenↄnɛ: Á yã nna! Tó ma á pↄnna lè, à omɛnɛ Firi'aunanɛ à pi: ");
INSERT INTO bqp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Kũ ma de tɛn ga, à tò ma la dànɛ à pì mà a vĩ mira kũ à kɛ̀kɛ a zĩda pↄ́ ũ Kanaanↄ bùsun. Ǹ ma gba zɛ́ mà gɛ́ mà a de vĩ sà, mani ɛra mà su. ");
INSERT INTO bqp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Akũ Firi'auna pìnɛ: Ǹ gɛ́ ǹ n de vĩ, zaakũ à tò n la dàarɛ. ");
INSERT INTO bqp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kũ Yusufu tɛn gɛ́ a de vĩ, Firi'auna ìbanↄ kũ a bɛ gbɛ̃ zↄ̃kↄ̃nↄ kũ Misila bùsu gbãnadenↄ gɛ̀ɛ kãao ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusufu bedenↄ kũ a vĩ̀ninↄ kũ a de bedenↄ gɛ̀ɛ kãao ń pínki dↄ. Ń nɛ́ fítinↄ kũ ń sãnↄ kũ ń blènↄ kũ ń zùnↄ mɛ́ ò gↄ̃̀ Gosɛ̃ bùsun ńtɛ̃nɛ. ");
INSERT INTO bqp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sↄ̃gonↄ kũ sↄ̃denↄ gɛ̀ɛ kãao dↄ. Gbɛ̃ kũ ò gɛ̀ɛ zɛnɛɛ pìnↄn dasi manamana. ");
INSERT INTO bqp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kũ ò kà Atada pↄ́wɛgbɛ̃kia Yoda bara, gwen ò wiki gbãna lɛ̀n ari, ò gɛ̀ ↄ́ↄ dↄ̀ manamana, akũ Yusufu a de wɛ̃nda kɛ̀ ari gↄrↄ suppla. ");
INSERT INTO bqp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kũ Kanaanↄ bùsudenↄ è lákũ òtɛn gɛ̀ kɛ nà Atada pↄ́wɛgbɛ̃kia, akũ ò pì: Misilanↄ gɛ̀kɛna zↄ̃kↄ̃n dí. Abire yãi ò tↄ́ kpà Yoda bara gu pìinɛ Abɛli Misila. ");
INSERT INTO bqp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Lɛn Yakubu nɛ́nↄ kɛ̀ lɛ lákũ à òńnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ò a gɛ̀ɛ sɛ̀ ò gɛ̀ɛo Kanaanↄ bùsun, akũ ò a vĩ̀ Makpɛla bura gbɛ̀wɛɛ kũ Ibrahĩ lù Iti buri Ɛflↄnua mira ũ gũn Mamare ifãboki kpa. ");
INSERT INTO bqp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kũ Yusufu a de vĩ̀ à làka, à ɛ̀ra à tà Misila kũ a vĩ̀ninↄ kũ gbɛ̃ kũ ò gɛ̀ɛ zɛnɛ a de gɛ̀ vĩnↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kũ Yusufu vĩ̀ninↄ è ń de gà, akũ ò pì: Tó Yusufu ibɛrɛɛ sɛ̀ kũoo, akũ à ye à a vãni kũ o kɛ̀nɛ pínki fĩna bowɛrɛ sↄ̃ bi? ");
INSERT INTO bqp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Akũ ò lɛ́gbãzã kɛ̀nɛ ò pì: De n de kpɛ́ à ga à pì ");
INSERT INTO bqp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ò onnɛ ǹ ó taari kũ ó durunnao kɛ̃wá, zaakũ a vãnin o kɛ̀nnɛ. N yã nna! Ǹ ó taarinↄ kɛ̃wá. N de Luda zↄ̀blerinↄmɛ ó ũ. Kũ ò yã pìi ò Yusufunɛ, akũ à ↄ́ↄ dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Akũ a vĩ̀ninↄ sù a kĩnaa ò kùtɛ a arɛ ò pì: N zↄ̀nↄmɛ ó ũ. ");
INSERT INTO bqp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Akũ Yusufu pìńnɛ: Àsun vĩna kɛro. Ludamɛ ma ũ yá? ");
INSERT INTO bqp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Á ye à a vãni kɛmɛnɛ yã, akũ Luda lìtɛ a mana ũ, de à le à gbɛ̃nↄ sura ba dasi lán àtɛn kɛ nà tera. ");
INSERT INTO bqp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Àsun vĩna kɛro. Mani á gwa kũ á nɛ́nↄ. Akũ à náani kpàḿma à ń laakarii kpàtɛ. ");
INSERT INTO bqp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu kú Misila kũ a de bedenↄ ari à kà wɛ̃̀ basↄↄro akuri. ");
INSERT INTO bqp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","À wɛ́ sì Ɛflaimu sãkpɛnↄlɛ, akũ à wɛ́ sì Manase nɛ́ Maki nɛ́nↄlɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Akũ Yusufu pì a gbɛ̃nↄnɛ: Ma ka gana. Luda mɛ́ ani su kpáái à bo kãáo bùsu dín à gɛ́ kãáo bùsu kũ à a lɛ́ sɛ̀ Ibrahĩnɛ kũ Isaakuo kũ Yakubuoo gũn. ");
INSERT INTO bqp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Akũ Yusufu tò Isarailanↄ la dàarɛ à pì: Gↄrↄ kũ Luda ni su kpáái, à ma wánↄ sɛ́tɛ à boo gu dín. ");
INSERT INTO bqp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusufu wɛ̃̀ basↄↄro akuriden à gà. Akũ ò ɛzɛ kũ àdi tó gɛ̀ vãro màma a gɛ̀ɛa ò dà àkpatii gũn Misila. ");
INSERT INTO bqp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Isaraila nɛ́ kũ ò tà Misila kũ ń de Yakubuo, baadi kũ a bɛ gbɛ̃nↄ tↄ́n dí: ");
INSERT INTO bqp_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubɛni, Simɛↄ, Levi, Yuda, ");
INSERT INTO bqp_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Zɛbuluni, Biliaminu, ");
INSERT INTO bqp_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dã, Nafatali, Gada kũ Asao. ");
INSERT INTO bqp_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakubu buri pìnↄ ń pínki gbɛ̃nↄn baaakↄ̃ akurimɛ. Yusufu sↄ̃ a gĩnakɛ à kú Misila kↄ̀. ");
INSERT INTO bqp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Akũ Yusufu gà kũ a vĩ̀ninↄ kũ gbɛ̃ kũ ò kun a gↄrↄanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isarailanↄ nɛ́ ì ò kɛ̀ dasi ò kàra ò dasi kũ̀ manamana, ò dà bùsuu pìla pínki. ");
INSERT INTO bqp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kína dufu kũ à Yusufu dↄ̃ro kpata blè Misila, ");
INSERT INTO bqp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","akũ à pì a gbɛ̃nↄnɛ: À Isarailanↄ gwa, ò dasi kũ̀ ò dàóla. ");
INSERT INTO bqp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ò gɛ́ ò ↄ̃ndↄ̃ kɛńnɛ de òsun kararo yãi. Tó zĩ̀i fùtɛ, ò na ó ibɛrɛnↄa ò zĩ̀ ká kũoo ò bↄtɛ ó bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Akũ ò gbɛ̃nↄ dìtɛńnɛ ń dikirinↄ ũ ò wɛ́ tãḿma kũ zĩ gbãna kɛnaao. Lɛmɛ ò Pitomu kũ Ramɛsɛo kàtɛ Firi'aunanɛ a pↄ́blekatɛkianↄ ũ lɛ. ");
INSERT INTO bqp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ama lán òtɛn wari dↄḿma nà, lɛmɛ òdigↄ̃ kara lɛ òtɛn dagula, akũ swɛ̃̀ɛ kɛ̃̀ Misilanↄgu ń yã musu. ");
INSERT INTO bqp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Akũ ò ń dá zↄ̀zĩ pãsĩn ");
INSERT INTO bqp_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ò ń pↄ yàka ò ɛ̃ zĩ gbãna dàńnɛ kũ kúnkubonaao kũ bura zĩ sĩnda pínkio. Ò zĩ pìnↄ dàńnɛ pínki pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Akũ Misilanↄ kína Eberu nɛ́sɛtɛrinↄ sìsi, a do tↄ́n Sifira, a do Pua. ");
INSERT INTO bqp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","À pìńnɛ: Tó áni nɛ́ i Eberu nↄgbɛ̃nↄnɛ tera sa, tó gↄ̃gbɛ̃mɛ, à a dɛ. Tó nↄgbɛ̃mɛ sↄ̃, à a tó. ");
INSERT INTO bqp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nↄgbɛ̃ pìnↄn Luda vĩna vĩ, odi yã kũ à òńnɛ kɛro, òtɛn nɛ́gↄ̃gbɛ̃nↄ tó. ");
INSERT INTO bqp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Akũ kína pì ń sísi à ń lá à pì: À kɛ̀ dera a kɛ̀ lɛ a nɛ́gↄ̃gbɛ̃nↄ tòo? ");
INSERT INTO bqp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ò wèa ò pì: Eberu nↄgbɛ̃nↄ de lán Misila nↄgbɛ̃nↄ bàro, ò wãna òdi nɛ́ i ari ògↄ̃ ká. ");
INSERT INTO bqp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Lɛmɛ Isarailanↄ tɛn kara lɛ òtɛn dasi kũ. Akũ Luda yã mana kɛ̀ nɛ́sɛtɛrii pìnↄnɛ ");
INSERT INTO bqp_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","à ń gbá nɛ́nↄ, kũ ò a vĩna vĩ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Akũ Firi'auna yã dìtɛ a gbɛ̃nↄnɛ ń pínki à pì: À Eberu nɛ́gↄ̃gbɛ̃ kũ ò ń ínↄ ká Nili ín ń pínki, ama à nɛ́nↄgbɛ̃nↄ tó. ");
INSERT INTO bqp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Levi buri gↄ̃gbɛ̃ Levi buri nↄgbɛ̃ sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nↄ pìi nↄ̀ↄ sì à nɛ́ ì gↄ̃gbɛ̃ ũ. Kũ à è nɛ́ pì mana, akũ à a ùtɛ mↄ aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kũ adi fↄ̃ à a ùtɛ doro, à kepu tãnko sɛ̀ à ↄ̀daa lɛ̀a de í sún gɛ̃ a gũnlo yãi. Akũ à nɛ́ pìi dàn à gɛ̀ɛ à dìtɛ Nili í lɛ́a kanda gũn. ");
INSERT INTO bqp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nɛ́ pì dãre zɛ zã̀ dire, àtɛn gwa yã kũ ani a le. ");
INSERT INTO bqp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Akũ Firi'auna nɛ́nↄgbɛ̃ gɛ̀ɛ zú o swai, a gbɛ̃nↄ tɛn kure swa pì lɛ́a. À tãnko è ditɛna kandan, akũ à a zↄ̀nↄkpare zĩ̀ à gɛ̀ɛ à a sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kũ à wɛ̃̀, à è nɛ́ mɛ́ à dan, àtɛn ↄ́ↄ dↄ. À kɛ̀nɛ wɛ̃nda à pì: Eberu nɛ́gↄ̃gbɛ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Akũ nɛ́ pì dãre sù à pì Firi'auna nɛ́ pìinɛ: Ń ye mà gɛ́ mà Eberu nↄgbɛ̃ sísinnɛ àgↄ̃ yↄ̃ kpánnɛ nɛ́ pìian yá? ");
INSERT INTO bqp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","À wèa à pì: Ǹ gɛ́! Akũ nɛ́nↄgbɛ̃ pìi gɛ̀ɛ à nɛ́ pì da sìsi. ");
INSERT INTO bqp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Firi'auna nɛ́nↄgbɛ̃ pìi pìnɛ: Ǹ nɛ́ pì sɛ́ ǹ tá kãao ǹgↄ̃ a gwamɛnɛ, manigↄ̃ fĩna bonnɛ. Akũ à nɛ́ pìi sɛ̀ à tà kãao, àtɛni a gwa. ");
INSERT INTO bqp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kũ nɛ́ pì zↄ̃kↄ̃ kũ̀, à a sɛ̀ à gɛ̀ɛ kãao Firi'auna nɛ́nↄgbɛ̃ pìinɛ, akũ à a sì a nɛ́ ũ. À tↄ́ kpànɛ Musa, zaakũ à pì, a a bò í gũmmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Zĩkea kũ Musa zↄ̃kↄ̃ kũ̀, à gɛ̀ɛ a buri Eberunↄ gwa, akũ à zĩ gbãna kũ òtɛn kɛ è. À è Misila gbɛ̃ tɛni a buri dake gbɛ̃. ");
INSERT INTO bqp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kũ à gu gwàgwa, adi gbɛ̃ke ero, akũ à Misila gbɛ̃ pìi dɛ̀ à a ùtɛ bùsu'atɛ̃n. ");
INSERT INTO bqp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kũ gu dↄ̀, à bò à Eberunↄ è gbɛ̃nↄn pla, òtɛn fìti kɛ. Akũ à gbɛ̃ kũ a yã nnaro là à pì: Bↄ́yãi ntɛni n gbɛ̃ndo gbɛ̃ɛ? ");
INSERT INTO bqp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","À wèa à pì: Dí mɛ́ à n ditɛ kína yãgↄ̃gↄ̃ri ũwɛrɛɛ? Ń ye ǹ ma dɛ lákũ n Misila gbɛ̃ dɛ̀ nàn yá? Akũ vĩna Musa kũ̀ à pì: Ò yã kũ ma kɛ̀ɛ dↄ̃̀ fá! ");
INSERT INTO bqp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kũ Firi'auna yã pìi mà, àtɛn wɛtɛ à Musa dɛ, akũ à bàa lɛ̀nɛ à tà Midiã bùsun, akũ à vùtɛ lↄ̀gↄↄ sarɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midiã sa'ori kun à nɛ́nↄgbɛ̃nↄ vĩ gbɛ̃nↄn suppla, akũ ò sù ò í tↄ̀ ò kà pↄ́kãdenↄ gó ímikin ń de pↄ́kãdenↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kũ sãdãri kenↄ sù òtɛn pɛ́ḿma, akũ Musa fùtɛ à yã sì kũńwo, akũ à í kpàńnɛ ń pↄ́kãdenↄa. ");
INSERT INTO bqp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kũ ò tà ń de Ruɛli kĩnaa, à ń lá à pì: À kɛ̀ dera a su káaku lɛ gbãraa? ");
INSERT INTO bqp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ò wèa ò pì: Misila gↄ̃gbɛ̃ ke mɛ́ à ó sí sãdãrinↄa. Àkũ mɛ́ se à í tↄ̀ à kpàwɛrɛ ó pↄ́kãdenↄa. ");
INSERT INTO bqp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Akũ à ń lá à pì: Ade pì kú máa? Bↄ́ yã mɛ́ à tò a gↄ̃gbɛ̃ pìi tò gwee? À a sísi à su à pↄ́ ble kũoo. ");
INSERT INTO bqp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa sù, akũ à wè à vùtɛ kũ gↄ̃gbɛ̃ pìio, akũ gↄ̃gbɛ̃ pì a nɛ́nↄgbɛ̃ Zipora kpàa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Akũ Zipora nɛ́ ì gↄ̃gbɛ̃ ũ, akũ Musa tↄ́ kpànɛ Gɛsↄmu, à pì: Buri zĩ̀tↄↄn ma ũ gbɛ̃ pãndenↄ bùsun la. ");
INSERT INTO bqp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kũ à gìi kɛ̀, akũ Misilanↄ kína gà. Isarailanↄ tɛni nda zↄ̀zĩ kũ òtɛn kɛ yãi, òtɛn wiki lɛ́, akũ ń wiki pìi kà Luda kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","À ń ndanaa mà, a bàka kũ à kú kũ Ibrahĩo kũ Isaakuo kũ Yakubuo dí sãaguro. ");
INSERT INTO bqp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Luda Isarailanↄ gwà, akũ ò kɛ̀nɛ wɛ̃nda. ");
INSERT INTO bqp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa tɛni a anzure Midiã bùsu sa'ori pↄ́kãdenↄ dã à vĩ̀ gbárannala ari à kà kpi kũ òdi pi Orɛbu kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Akũ Dikiri Malaikaa bò à sùa tɛ́vuraa gũn tariankpãn. Musa tariankpã pìi gwà à è tɛ́ kúa, ama àtɛn tɛ́ kũro. ");
INSERT INTO bqp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Akũ à pì: Mani gɛ́ mà daboyã pì gwa de mà dↄ̃ pↄ́ kũ à tò tariankpã pì tɛn tɛ́ kũro. ");
INSERT INTO bqp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kũ Dikiri è à sù gwa, akũ à lɛ́ zùi zaa tariankpã pìi gũn à pì: Musa! Musa! Akũ à wèa à pì: Makũ di! ");
INSERT INTO bqp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Luda pìnɛ: Ǹsun nairo. Ǹ n kyate bobo, zaakũ gu kũ ń zɛn kun adonamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Akũ à pì: Makũmɛ n dizinↄ Ibrahĩ kũ Isaakuo kũ Yakubuo Luda ũ. Akũ Musa pↄ́ kù a wɛ́a, kũ à wɛ́ kɛna pla kũ Ludao vĩna vĩ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Akũ Dikiri pì: Ma yã'ũmmana kũ ma gbɛ̃nↄ tɛn kɛ Misila è, ma wiki kũ ń wɛ́tãmmarinↄ tò òtɛn lɛ́ mà. Má ń wãwãkɛnaa dↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ma kipa mà ń sí Misilanↄa mà ń bↄtɛ bùsuu pìn mà gɛ́ kũńwo bùsu mana yàasan, gu kũ vĩ kũ zↄ́'io din, bùsu kũ Kanaanↄn kun kũ Itinↄ kũ Amↄrinↄ kũ Pɛrizinↄ kũ Ivinↄ kũ Yebusinↄo. ");
INSERT INTO bqp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isarailanↄ wikilɛna kà ma kĩnaa tera sà, ma wari kũ Misilanↄ tɛn dↄḿma è. ");
INSERT INTO bqp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ǹ gɛ́ tera sà, ma n zĩ Firi'aunaamɛ de ǹ ma gbɛ̃ Isarailanↄ bↄtɛ Misila. ");
INSERT INTO bqp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Akũ Musa pì Ludanɛ: Dín ma ũ kũ mani gɛ́ Firi'auna kĩnaa mà Isarailanↄ bↄtɛ Misilai? ");
INSERT INTO bqp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Luda pìnɛ: Manigↄ̃ kú kũnwo. Zĩna kũ ma n zĩ sèedaan dí. Tó n ń bↄ́tɛ Misila, áni donyĩ kɛmɛnɛ kpi dí pↄtɛa. ");
INSERT INTO bqp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Akũ Musa pì Ludanɛ: Tó ma gɛ ma ò Isarailanↄnɛ ma pì, ń dizinↄ Luda mɛ́ à ma zĩḿma, tó ò ma la n tↄ́i sↄ̃ bi? Mani pińnɛ deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Luda wèa à pì: Makũmɛ gbɛ̃ kũ má de a ũ ũ. Ǹ ońnɛ makũ mɛ́ ma n zĩḿma. ");
INSERT INTO bqp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Luda pìnɛ dↄ: Ǹ o Isarailanↄnɛ makũ Dikiri ń dizinↄ Ibrahĩ kũ Isaakuo kũ Yakubuo Luda mɛ́ à n zĩḿma. Ma tↄ́n gwe gↄrↄ sĩnda pínki. Àgↄ̃ ma sísi lɛ ari á buria. ");
INSERT INTO bqp_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ǹ gɛ́ ǹ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kakara ǹ ońnɛ makũ Dikiri ń dizinↄ Ibrahĩ kũ Isaakuo kũ Yakubuo Luda mɛ́ à bò à sùmma. Ǹ ońnɛ matɛni ń e ma yã kũ òtɛn kɛńnɛ Misila è. ");
INSERT INTO bqp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mani ń bↄtɛ Misila gu kũ òtɛn wɛ́ tãḿma pìn, mani gɛ́ kũńwo bùsu kũ Kanaanↄn kun kũ Itinↄ kũ Amↄrinↄ kũ Pɛrizinↄ kũ Ivinↄ kũ Yebusinↄo, gu kũ vĩ kũ zↄ́'io din. ");
INSERT INTO bqp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Oni n yã ma. Mↄkↄ̃n kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ à gɛ́ à Misila kína le à onɛ makũ Dikiri Eberunↄ Luda ma bo ma suáwa, ma pì à á gba zɛ́ à gɛ́ gↄrↄ aakↄ̃ kɛ gbárannan de à sa o makũ Dikiri á Ludaa. ");
INSERT INTO bqp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Má dↄ̃ kũ Misila kína ni we à gɛ́ro, tó adi kɛ ma a dà tilasiro. ");
INSERT INTO bqp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mani ↄ tↄ̃ Misilanↄa, mani daboyãnↄ kɛ mà wɛ́ tãoḿma, gbasa à á gbarɛ. ");
INSERT INTO bqp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mani tó Misilanↄ á wɛ́ gwa, de tó átɛn tá, áni tá ↄkoriro. ");
INSERT INTO bqp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Á nↄgbɛ̃ sĩnda pínki andurufu ke wura nↄmanablebↄnↄ kũ pↄ́kasanↄ gbɛka a Misila nↄgbɛ̃ dakea kũ ń nↄgbɛ̃ kũ ò kú a bɛanↄ, à da á nɛ́gↄ̃gbɛ̃nↄnɛ kũ á nɛ́nↄgbɛ̃nↄ. Lɛn áni Misilanↄ pↄ́nↄ síḿma lɛ manamana. ");
INSERT INTO bqp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa wèa à pì: Tó odi ma náani kɛro, akũ odi ma yã maro, tó ò pì mↄkↄ̃n mɛ́ n bo n sumaro sↄ̃ bi? ");
INSERT INTO bqp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Akũ Dikiri a là à pì: Bↄ́n ń kũna gwee? À wèa à pì: Gòomɛ. ");
INSERT INTO bqp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Dikiri pìnɛ: Ǹ gòo pì pãtɛ zĩtɛ. Kũ à pã̀tɛ, akũ à lì mlɛ̃̀ ũ, akũ Musa a zĩda gà gwe. ");
INSERT INTO bqp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Dikiri pìnɛ: Ǹ ↄ bo ǹ a kũ a vlãa. Kũ à kũ̀, akũ à ɛ̀ra à lì gò ũ a ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Dikiri pìnɛ: Lɛn ĩni kɛ lɛ, de ò sí kũ makũ Dikiri ń dizinↄ Ibrahĩ kũ Isaakuo kũ Yakubuo Luda mɛ́ à bò à sùmma. ");
INSERT INTO bqp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Dikiri ɛ̀ra à pìnɛ dↄ: Ǹ n ↄ sↄtↄ n utan. Akũ à sↄ̀tↄn. Kũ à bò, à è a ↄ lì kusu ũ, à kɛ̀ púu lán buu bà. ");
INSERT INTO bqp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Dikiri pìnɛ: Ǹ ɛra ǹ n ↄ sↄtↄ n utan. À ɛ̀ra à sↄ̀tↄn. Kũ à bò, à è à kɛ̀ a gbɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Dikiri pìnɛ: Tó odi n náani kɛ ò sèeda káaku sìro, ò kpɛkpɛ pↄ́ sí. ");
INSERT INTO bqp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tó odi sèeda pla pìnↄ sí ò n yã mà sↄ̃ro, ǹ Nili í tↄ́ ǹ kↄ́tɛ zĩtɛ, ani li aru ũ. ");
INSERT INTO bqp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Akũ Musa pìnɛ: N yã nna Dikiri! Zaa zĩ yã'onaa araga kũmaoro. Bee zaa gↄrↄ kũ n yã òmɛnɛ, ma lɛ́ tìkisimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Akũ Dikiri pìnɛ: Dí mɛ́ à lɛ́ dↄ̀ bisãsirinɛɛ? Dí mɛ́ àdi a nɛ́nɛ natɛ ke àdi a sãto kũu? Dí mɛ́ àdi tó à gu e ke àdi a vĩ̀na kũu? Makũ Dikiri, makũroo? ");
INSERT INTO bqp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ǹ gɛ́! Mani kpányĩ kũ yã'onaao, mani yã kũ ĩni o dannɛ. ");
INSERT INTO bqp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Akũ à pì: N yã nna Dikiri! N yã nna! Ǹ gbɛ̃ pãnde zĩ. ");
INSERT INTO bqp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Akũ Dikiri pↄ fɛ̃̀ kũ Musao à pì: N vĩ̀ni Haruna Levi buri kunloo? Má dↄ̃ kũ yã'ona zĩ'ũ kãaoro. Àtɛn su danlɛ. Tó á wɛ́ kɛ̀ pla, a pↄ ni kɛ nna. ");
INSERT INTO bqp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ǹ yã o kãao ǹ yã kũ ani o danɛ. Makũ, manigↄ̃ kpái kũ yã'onaao, manigↄ̃ yã kũ áni kɛ daárɛ. ");
INSERT INTO bqp_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ani yã o gbɛ̃nↄnɛ n gɛ̃nɛ ũ, anigↄ̃ de n lɛ́gbɛkpari ũ, ĩnigↄ̃ denɛ lán Luda bà. ");
INSERT INTO bqp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ǹ gò dí sɛ́ ǹgↄ̃ kũna ǹ sèedanↄ kɛo. ");
INSERT INTO bqp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa tà a anzure Yɛtoro kĩnaa à pìnɛ: Ǹ ma gba zɛ́ mà tá ma gbɛ̃nↄ kĩnaa Misila, mà e tó ò kpɛ́ kú kũ wɛ̃̀ndiio ari tera. Yɛtoro pìnɛ: Ǹ kipa aafia. ");
INSERT INTO bqp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","À sù à lè Dikiri ò Musanɛ Midiã bùsun à pì: Ǹ futɛ ǹ tá Misila, zaakũ gbɛ̃ kũ òtɛni n wɛtɛ ò n dɛ yãnↄ gàga ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Akũ Musa a nanↄ sɛ̀ kũ a nɛ́gↄ̃gbɛ̃nↄ à ń dí zaakia, à ɛ̀ra àtɛn tá Misila à Luda gòo pì kũna. ");
INSERT INTO bqp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Akũ Dikiri pìnɛ: Tó n ka Misila, ǹ daboyã kũ ma a gbãna kpàmmanↄ kɛ Firi'auna arɛ pínki. Ama mani a kùgbãna kũ, ani gí gbɛ̃nↄ gbarɛi. ");
INSERT INTO bqp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ǹ onɛ makũ Dikiri ma pì, Isaraila burimɛ ma daudu ũ, ");
INSERT INTO bqp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","akũ ma pìnɛ à ma daudu gbarɛ à gɛ́ donyĩ kɛmɛnɛ. Lákũ à gì a gbarɛi nà, mani a daudu dɛ sà. ");
INSERT INTO bqp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Zɛ́ gũn Musa tɛn i gukea, akũ Dikiri a lè gwe à ye à a dɛ. ");
INSERT INTO bqp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Akũ Zipora gbɛ̀ fɛ̃nɛ sɛ̀ à a nɛ́ tↄ̃̀ↄ zↄ̃̀o à a gyↄfↄrↄ nà Musa gbáa à pì: Yãpuramɛ, ń demɛnɛ gↄ̃ arude ũ. ");
INSERT INTO bqp_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tↄ̃̀zↄ̃na bire yãin à pìnɛ gↄ̃ arude. Akũ Dikiri Musa tò. ");
INSERT INTO bqp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Dikiri pì Harunanɛ: Ǹ gɛ́ da Musalɛ gbárannan. Akũ à gɛ̀ɛ à a lè Luda kpi kĩnaa, à lɛ́ pɛ̀a. ");
INSERT INTO bqp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa yã kũ Dikiri a zĩ à o bàba Harunanɛ kũ sèeda kũ à pìnɛ à kɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Akũ Musa kũ Harunao tà Misila ò Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kàkara. ");
INSERT INTO bqp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haruna yã kũ Dikiri ò Musanɛ bàbańnɛ ń pínki, akũ Musa daboyã pìnↄ kɛ̀ Isarailanↄ wára. ");
INSERT INTO bqp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ò yã pìi sì. Kũ ò mà Dikiri mɛ́ à sù ń gwa à ń yã'ũmmanaa è, akũ ò kùtɛ ò donyĩ kɛ̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Abire gbɛra Musa kũ Harunao gɛ̀ɛ ò Firi'auna lè ò pìnɛ: Yã kũ Dikiri Isarailanↄ Luda òon dí. À pì ǹ a gbɛ̃nↄ gbarɛ ò gɛ́ dikpɛ kɛarɛ gbárannan. ");
INSERT INTO bqp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firi'auna wèḿma à pì: Dímɛ Dikiri ũ kũ mà a yã ma mà Isarailanↄ gbarɛɛ? Má Dikiri dↄ̃ro. Mani Isarailanↄ gbarɛro. ");
INSERT INTO bqp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Akũ ò pìnɛ: Eberunↄ Luda bò à sùwá. Ǹ ó gba zɛ́ ò gɛ́ ò gↄrↄ aakↄ̃ kɛ gbárannan ò sa o Dikiri ó Luda pìia, de àsun gyã káwáiro kesↄ̃ zĩ̀i. ");
INSERT INTO bqp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Akũ Misila kína pìi pì Musanɛ kũ Harunao: À kɛ̀ dera a tò gbɛ̃nↄ laakari tɛn go ń zĩaa? À ɛra á zĩa. ");
INSERT INTO bqp_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Akũ à ɛ̀ra à pì: Kũ gbɛ̃nↄ dasi kũ̀ sà, akũ á ye ò kámma bo kũ ń zĩo yá? ");
INSERT INTO bqp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Zĩ birea Firi'auna yã dìtɛ Isaraila wɛ́tãmmarinↄnɛ kũ ń don'arɛdenↄ à pì: ");
INSERT INTO bqp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Àsun sɛ̃̀buru kpáḿma ò kúnku kɛo lákũ adì kɛ nà yã doro. Ò gɛ́ ò ń pↄ́ kɛ̃ ń zĩda. ");
INSERT INTO bqp_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ama ò kúnku kɛ lákũ òdi kɛ nà yã lɛ́n. Àsun lagońnɛro, zaakũ ma'ãdenↄmɛ. A yã mɛ́ à tò ń wiki dìgↄ̃ dↄ, òtɛn pi ò ye ò gɛ́ sa o ń Ludaamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","À zĩ karańnɛ de òsun ĩampaki le ò laakari kpá ɛ́kɛyãnↄa doro. ");
INSERT INTO bqp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Akũ ń wɛ́tãmmarii pìnↄ kũ ń don'arɛdenↄ sù ò pìńnɛ: Firi'auna pì òsun sɛ̃̀buru kpááwa doro. ");
INSERT INTO bqp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","À gɛ́ à wɛtɛ á zĩda gu kũ áni len. Bee kũ abireo óni zĩ lagoárɛro, bee fíti. ");
INSERT INTO bqp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Akũ ò fã̀kↄ̃a ò gɛ̀ɛ Misila gu sĩnda pínki sɛ̃̀ kɛ̃ sɛ̃̀buru ũ. ");
INSERT INTO bqp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ń wɛ́tãmmarii pìnↄ dìgↄ̃ nakaraḿma lákũ gu dìgↄ̃ dↄ nà, de ò ń zĩ láka lákũ òdi láka nà gↄrↄ kũ òdi sɛ̃̀buru kpáḿma. ");
INSERT INTO bqp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ò gbɛ̃naa kɛ̀ Isaraila don'arɛde kũ ń wɛ́tãmmarinↄ dìtɛnↄnɛ ò pìńnɛ: À kɛ̀ dera ádi kúnku kɛ gbãra ke gĩa à kà lákũ ò a lɛ́ dìtɛárɛ nà yãroo? ");
INSERT INTO bqp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Akũ Isaraila don'arɛdenↄ gɛ̀ɛ ò wiki lɛ̀ Firi'aunaa ò pì: À kɛ̀ dera ntɛn kɛ ókↄ̃nↄ n zↄ̀blerinↄnɛ lɛɛ? ");
INSERT INTO bqp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Òtɛni sɛ̃̀buru kpáwá doro, akũ òtɛn pi ò kúnku kɛ. Òtɛni ó gbɛ̃, ama n gbɛ̃nↄ mɛ́ ò taari vĩ. ");
INSERT INTO bqp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Akũ à pì: Ma'ãdenↄn á ũ. Lɛn á de lɛ! A yã mɛ́ à tò adìgↄ̃ pi áni gɛ́ sa o Dikiria. ");
INSERT INTO bqp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","À gɛ́ zĩ kɛ. Oni sɛ̃̀buru kpááwa doro, bee kũ abireo áni kúnku kɛ lákũ ò dàárɛ nà lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kũ ò ò Isaraila don'arɛdenↄnɛ òsun gↄrↄ do kúnkubona lagoro, ò dↄ̃̀ kũ ò yã è sà. ");
INSERT INTO bqp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kũ ò bò Firi'auna kĩnaa, ò dàkarɛ kũ Musao kũ Harunao, òtɛni ń dã, ");
INSERT INTO bqp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","akũ ò pìńnɛ: Dikiri á yã gwa à yãkpatɛ kɛ kãáo, zaakũ a tò Firi'auna kũ a gbɛ̃nↄn ye ó kãiro. A ó dɛna zɛ́ kpàḿman gwe. ");
INSERT INTO bqp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Akũ Musa ɛ̀ra à gɛ̀ɛ à pì Dikirinɛ: Dikiri, bↄ́yãi n wari dↄ̀ gbɛ̃ pìnↄaa? Abire yãin n ma zĩ yá? ");
INSERT INTO bqp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Zaa gↄrↄ kũ ma gɛ ma yã ò Firi'aunanɛ kũ n tↄ́o, akũ àtɛn wari dↄ n gbɛ̃nↄa, akũ ńdi ń bo sↄ̃ro bi! ");
INSERT INTO bqp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Akũ Dikiri pìnɛ: Ĩni yã kũ mani kɛ Firi'aunanɛ e tera. Ani ń gbarɛ ma gbãna zↄ̃kↄ̃ yãi. Ani pɛ́ḿma a bùsun ma gbãna zↄ̃kↄ̃ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Akũ Luda ɛ̀ra à yã ò Musanɛ à pì: Makũmɛ Dikiri ũ, ");
INSERT INTO bqp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ma bo ma su Ibrahĩ kũ Isaakuo kũ Yakubuooa Luda Gbãnasĩndapinkide ũ, ama odi ma dↄ̃ ma tↄ́ Dikiriaro. ");
INSERT INTO bqp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ma bàka kú kũńwo, ma pì mani Kanaanↄ bùsu kũ ò kú a gũn buri zĩ̀tↄ ũ kpáḿma. ");
INSERT INTO bqp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ma Isarailanↄ ndanaa mà ń zↄ̀blena Misilanↄnɛ yãi, akũ ma bàka kũ à kú kũńwoo pì yã dí sãmaguro. ");
INSERT INTO bqp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","A yã mɛ́ à tò ǹ o Isarailanↄnɛ makũmɛ Dikiri ũ. Mani á bo zĩ gbãna kũ Misilanↄ dàárɛ gũn, mani á bo zↄ̀blen. Mani yãkpatɛ kɛ kũńwo mani a bo kũ ma gã̀sã gbãnao. ");
INSERT INTO bqp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mani á sɛ́ ma gbɛ̃nↄ ũ màgↄ̃ de á Luda ũ, ánigↄ̃ dↄ̃ kũ makũmɛ Dikiri á Luda kũ à á bó Misila zĩ gbãna gũn ũ. ");
INSERT INTO bqp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mani gɛ́ kãáo bùsu kũ ma a la dà Ibrahĩnɛ kũ Isaakuo kũ Yakubuo gũn. Mani á gba àgↄ̃ vĩ. Makũmɛ Dikiri ũ. ");
INSERT INTO bqp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa yã pìi ò Isarailanↄnɛ, ama odi a yã maro kũ zↄ̀zĩ pãsĩ ń mɛ̀ɛ yↄ̀ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Akũ Dikiri ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ǹ gɛ́ ǹ o Misilanↄ kína Firi'aunanɛ à Isarailanↄ gbarɛ ò bↄtɛ a bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Akũ Musa wè Dikiria à pì: Lákũ Isarailanↄ dì ma yã maro nà, makũ kũ ma lɛ́ tìkisi, deran Firi'auna ni ma yã ma sↄ̃ↄ? ");
INSERT INTO bqp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Dikiri yã ò Musanɛ kũ Harunao Isarailanↄ yã musu kũ Misila kínao, à òńnɛ ò bↄtɛ kũ Isarailanↄ Misila. ");
INSERT INTO bqp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ń buri ↄmbede káakunↄ tↄ́n dí. Isaraila daudu Rubɛni nɛ́gↄ̃gbɛ̃nↄn dí: Anↄku, Palu, Ɛzɛrↄnu, Kaami. Rubɛni burinↄn gwe danɛdanɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simɛↄ nɛ́gↄ̃gbɛ̃nↄn dí: Yemuɛli, Yami, Oada, Yakĩ, Zoa kũ Kanaa nↄgbɛ̃ nɛ́ Soluo. Simɛↄ burinↄn gwe danɛdanɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí ń burinↄa: Gɛsↄmu, Koa, Mɛrari. Levi kɛ̀ wɛ̃̀ basuddo akuri awɛɛsupplamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gɛsↄmu nɛ́gↄ̃gbɛ̃nↄn dí ń burinↄa danɛdanɛ: Libini kũ Simɛio. ");
INSERT INTO bqp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koa nɛ́gↄ̃gbɛ̃nↄ tↄ́n dí: Amlamu, Iza, Ɛblↄnu, Uziɛli. Koa kɛ̀ wɛ̃̀ basuddo akuri awɛɛ'aakↄ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mɛrari nɛ́gↄ̃gbɛ̃nↄn Mali kũ Musio ũ. Levi burinↄn gwe danɛdanɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amlamu a dasɛ̃ Yↄkɛbɛdi sɛ̀ nↄ ũ, akũ à Haruna kũ Musao ì kãao. Amlamu kɛ̀ wɛ̃̀ basuddo akuri awɛɛsupplamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Iza nɛ́gↄ̃gbɛ̃nↄn Kora kũ Nɛfɛgio kũ Zikirio ũ. ");
INSERT INTO bqp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziɛli nɛ́gↄ̃gbɛ̃nↄn Misaili kũ Ɛlɛzafão kũ Sitirio ũ. ");
INSERT INTO bqp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna Aminadabu nɛ́ Ɛlisɛba, Nasↄ̃ dãre sɛ̀ nↄ ũ, akũ à Nadabu kũ Abiuo kũ Ɛlɛazao kũ Itamao ì kãao. ");
INSERT INTO bqp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora nɛ́gↄ̃gbɛ̃nↄn Asi kũ Ɛlɛkanao kũ Abiasafao ũ. Kora burinↄn gwe danɛdanɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Haruna nɛ́ Ɛlɛaza Putiɛli nɛ́nↄgbɛ̃nↄ doke sɛ̀ nↄ ũ, akũ à Finɛasi ì kãao. Levi buri ↄmbede káakunↄn gwe danɛdanɛ. ");
INSERT INTO bqp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Haruna kũ Musa kũ Dikiri òńnɛ ò Isarailanↄ bↄtɛ Misila gã̀ kũ gã̀aon gwe. ");
INSERT INTO bqp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Mↄ́kↄ̃nↄ mɛ́ ò yã ò Misilanↄ kína Firi'aunanɛ de ò Isarailanↄ bↄtɛ Misila. ");
INSERT INTO bqp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kũ Dikiri yã ò Musanɛ Misila, ");
INSERT INTO bqp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","à pì akãamɛ Dikiri ũ, yã kũ átɛn onɛn à o Firi'aunanɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Akũ Musa pìnɛ a lɛ́ tìkisi, deran Firi'auna ni a yã maa? ");
INSERT INTO bqp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Akũ Dikirii pì Musanɛ: Ǹ gwa! Ma n kɛ lán ma bà Firi'aunanɛ, akũsↄ̃ n vĩ̀ni Haruna de n lɛ́gbɛkpari ũ. ");
INSERT INTO bqp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ǹ yã kũ ma ònnɛ pínki o n vĩ̀ni Harunanɛ, ani o Firi'aunanɛ à Isarailanↄ gbarɛ ò bↄtɛ a bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Bee kũ abireo mani a kù kɛ gbãna. Mani sèedanↄ kũ daboyãnↄ kɛ Misila dasi, ");
INSERT INTO bqp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ama Firi'auna ni á yã maro. Mani ↄ tↄ̃ Misilaa mà yãkpatɛ kɛ kũńwo pãsĩpãsĩ, mani bo kũ ma zĩ̀kari Isarailanↄ gã̀ kũ gã̀ao. ");
INSERT INTO bqp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Tó ma bo kũ ma gbãnao Misilaa, mani Isarailanↄ bↄtɛn, Misilanↄ ni dↄ̃ sà kũ makũmɛ Dikiri ũ. ");
INSERT INTO bqp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Akũ Musa kũ Harunao kɛ̀ lákũ Dikiri òńnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Gↄrↄ kũ ò yã ò Firi'aunanɛ, Musa kun wɛ̃̀ basiikↄ̃, Haruna sↄ̃ wɛ̃̀ basiikↄ̃ awɛɛ'aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Akũ Dikiri pì Musanɛ kũ Harunao: ");
INSERT INTO bqp_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Tó Firi'auna daboyã gbɛ̀kamma, ǹ o Harunanɛ à a gò sɛ́ à pãtɛ a arɛ, ani li mlɛ̃̀ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kũ Musa kũ Harunao gɛ̀ɛ Firi'auna kĩnaa, ò kɛ̀ lákũ Dikiri òńnɛ nà. Haruna a gòo sɛ̀ à pã̀tɛ Firi'auna kũ a ìbanↄ arɛ, akũ à lì mlɛ̃̀ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Akũ Firi'auna Misila wɛ́zɛ̃rinↄ kũ ɛzɛdenↄ sìsi, akũ ò daboyã dokↄ̃nↄ pìnↄ kɛ̀ se ń ɛzɛdekɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kũ ń baadi a gòo pã̀tɛ, akũ ń gòo pìnↄ lì mlɛ̃̀nↄ ũ, akũ Haruna gò ń pↄ́nↄ mↄ̀mↄ. ");
INSERT INTO bqp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Firi'auna sã gbãnamɛ, adi ń yã maro lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Dikiri pì Musanɛ: Firi'auna kù gbãna à gì gbɛ̃nↄ gbarɛi. ");
INSERT INTO bqp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ǹ gɛ́ ǹ a le zia kↄnkↄ gↄrↄ kũ àtɛn gɛ́ swai. Ǹgↄ̃ a dã Nili sarɛ gwe. Ǹgↄ̃ n gò kũ à lì mlɛ̃̀ ũ pì kũna. ");
INSERT INTO bqp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ǹ pinɛ makũ Dikiri Eberunↄ Luda ma n zĩa, n ònɛ à ma gbɛ̃nↄ gbarɛ ò gɛ́ donyĩ kɛmɛnɛ gbárannan, ama ari tera à gìmai. ");
INSERT INTO bqp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Makũ Dikiri ma pì, yã kũ ani tó àgↄ̃ dↄ̃ kũ makũmɛ Dikiri ũn dí. Tó n Nili í lɛ̀ kũ gò kũ ń kũnaao, ani li aru ũ. ");
INSERT INTO bqp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kpↄ̀ kũ ò kú í pìi gũnnↄ ni gaga, Nili í ni gbĩ sↄ̃, Misilanↄ ni fu í pì minaa. ");
INSERT INTO bqp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Akũ Dikiri ɛ̀ra à pì Musanɛ: Ǹ o Harunanɛ à a gò sɛ́ à dↄ Misila ínↄ la, ń swanↄ kũ ń swa'ↄnɛnↄ kũ ń ísɛ̃bokinↄ kũ ń íkakinↄ pínki ni gↄ̃ aru ũ. Aru nigↄ̃ dagula Misila, bee kũ kpɛ̃nɛnↄ kũ orozã gũnnↄ. ");
INSERT INTO bqp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Akũ Musa kũ Harunao kɛ̀ lákũ Dikiri òńnɛ nà. Haruna a gòo pìi sɛ̀, à Nili í lɛ̀o Firi'auna kũ a ìbanↄ wára, akũ í pìi gↄ̃̀ aru ũ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kpↄ̀ kũ ò kú a gũnnↄ gàga, akũ Nili í pì gbĩ sↄ̃̀, Misilanↄ fùa ò mi. Aru dàgula Misila. ");
INSERT INTO bqp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Misila ɛzɛdenↄ kɛ̀ lɛ se ń ɛzɛdekɛ gũn, akũ Firi'auna kùgbãna kũ̀, adi ń yã maro lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firi'auna ɛ̀ra à tà a bɛa, adi yã pì da sero. ");
INSERT INTO bqp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misilanↄ bia yↄ̃̀yↄ̃ Nili bara de ò í mi, zaakũ odi fↄ̃ ò swada'i mìro. ");
INSERT INTO bqp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","À kun lɛ ari gↄrↄ supplamɛ Dikiri Nili lɛnaa gbɛra. ");
INSERT INTO bqp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Akũ Dikiri pì Musanɛ: Ǹ gɛ́ ǹ o Firi'aunanɛ, makũ Dikiri ma pì à ma gbɛ̃nↄ gbarɛ ò gɛ́ donyĩ kɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tó à gì ń gbarɛi sↄ̃, mani tó blↄ̀nↄ da a bùsu gu sĩnda pínki la. ");
INSERT INTO bqp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Blↄ̀nↄ ni Nili pa ari ò bikũ bara, ò gɛ̃ a ↄnn ari a kpɛ́n, ò didi a gádoa. Ò gɛ̃ a ìbanↄ ↄnnↄ gũn kũ a gbɛ̃nↄ ↄnnↄ. Ò ká a kĩninↄ kũ a gónↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Blↄ̀nↄ ni didia kũ a gbɛ̃nↄ kũ a ìbanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Dikiri ɛ̀ra à pì Musanɛ: Ǹ o Harunanɛ à a gò sɛ́ à dↄ swanↄla kũ swa'ↄnɛnↄ kũ ísɛ̃bokinↄ, blↄ̀nↄ ni da Misila bùsula. ");
INSERT INTO bqp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kũ Haruna a gòo dↄ̀ Misila ínↄla, akũ blↄ̀nↄ bↄ̀tɛ ò dà bùsuu pìla. ");
INSERT INTO bqp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Akũ ɛzɛde pìnↄ kɛ̀ lɛ se ń ɛzɛdekɛ gũn, ò tò blↄ̀nↄ dà Misilala. ");
INSERT INTO bqp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Akũ Firi'auna Musa kũ Harunao sìsi à pì: À kútɛ kɛ Dikirinɛ à blↄ̀nↄ kɛ̃ma kũ ma gbɛ̃nↄ, mani á gbɛ̃nↄ gbarɛ ò gɛ́ sa oa. ");
INSERT INTO bqp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Akũ Musa pì Firi'aunanɛ: Ǹ gↄrↄ ditɛmɛnɛ mà kútɛ kɛnnɛ Dikirinɛ kũ n ìbanↄ kũ n gbɛ̃nↄ, de à blↄ̀nↄ kɛ̃mma kũ n ↄnnↄ ògↄ̃ kú swai ado. ");
INSERT INTO bqp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firi'auna pì: Zia. Akũ Musa pì: Ani kɛ lákũ n ò nà, de ǹgↄ̃ dↄ̃ kũ gbɛ̃ke de lán Dikiri ó Luda bàro. ");
INSERT INTO bqp_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Blↄ̀nↄ ni kɛ̃mma kũ n ↄnnↄ kũ n ìbanↄ kũ n gbɛ̃nↄ ògↄ̃ kú swai ado. ");
INSERT INTO bqp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kũ Musa kũ Harunao bò Firi'auna kĩnaa, Musa wɛ́ kɛ̀ Dikiria blↄ̀ kũ ò dà Firi'aunalanↄ yã musu. ");
INSERT INTO bqp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Dikiri Musa wɛ́kɛ sì, akũ blↄ̀nↄ gàga kpɛ́nↄ gũn kũ ↄnnↄ kũ buranↄ. ");
INSERT INTO bqp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ò ń kákara, akũ bùsu gbĩ sↄ̃̀ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kũ Firi'auna è à kɛ̀ sã̀na, a sã kpɛ́ gbãna, akũ à gì Musa kũ Harunao yã mai lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Dikiri pì Musanɛ: Ǹ o Harunanɛ à a gò sɛ́ à zĩtɛ lɛ́o, bùsutiti ni li sàa ũ Misila gu sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Akũ ò kɛ̀ lɛ. Haruna a gòo sɛ̀ à zĩtɛ lɛ̀o, akũ bùsutiti lì sàanↄ ũ, ò dà bisãsirinↄla kũ nↄ̀bↄnↄ. Misila bùsutiti lì sàanↄ ũ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ɛzɛdenↄ yↄ̃̀ ò gwà se ń ɛzɛdekɛ gũn, akũ ò fùa. Sàanↄ dà bisãsirinↄla kũ nↄ̀bↄnↄ. ");
INSERT INTO bqp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Akũ ɛzɛdenↄ pì Firi'aunanɛ: Luda ↄgbɛɛmɛ. Ama Firi'auna sã kpɛ́ gbãna, à gì ń yã mai lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Dikiri pì Musanɛ: Ǹ futɛ kↄnkↄkↄnkↄ ǹ gɛ́ ǹ Firi'auna le gↄrↄ kũ àtɛn gɛ́ swai, ǹ onɛ makũ Dikiri ma ò, à ma gbɛ̃nↄ gbarɛ ò gɛ́ donyĩ kɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tó à gì ń gbarɛi, mani ífĩninↄ daala kũ a ìbanↄ kũ a gbɛ̃nↄ kũ a kpɛ́nↄ. Misila kpɛ́nↄ ni pa kũ ífĩninↄ, bee zĩtɛ oni daala. ");
INSERT INTO bqp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Gↄrↄ birea mani Gosɛ̃ bùsu gu kũ ma gbɛ̃nↄn kun bo ado. Gwen ífĩninↄ ni dan gularo, de àgↄ̃ dↄ̃ kũ makũmɛ Dikiri ũ a bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mani ma gbɛ̃nↄ dↄ̃kↄ̃nɛ kũ a gbɛ̃nↄ. Zian sèedaa pì ni kɛ. ");
INSERT INTO bqp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Akũ Dikiri kɛ̀ lɛ. Ífĩninↄ kà Firi'auna ↄnn kũ a ìbanↄ ↄnnↄo. Misila yàka pínki ífĩninↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Akũ Firi'auna Musa kũ Harunao sìsi à pì: À gɛ́ sa o á Ludaa bùsun la. ");
INSERT INTO bqp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Akũ Musa pìnɛ: Ani sí kɛ ò kɛ lɛro, zaakũ pↄ́ kũ óni sa o Dikiri ó Ludaa pì de Misilanↄnɛ tɛ̃̀ ũmɛ. Tó o sa ò kũ pↄ́ kũ à deńnɛ tɛ̃̀ ũo ń wára, oni ó pápa kũ gbɛ̀ɛo ò ó dɛdɛroo? ");
INSERT INTO bqp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Óni táa o gbárannan gↄrↄ aakↄ̃mɛ, gbasa ò sa o Dikiri ó Ludaa lákũ à òwɛrɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Akũ Firi'auna pì: Mani á gbarɛ à gɛ́ sa o Dikiri a Ludaa gbárannan, ama àsun gɛ́ zã̀ro. À kútɛ kɛnɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa pìnɛ: Tó ma ta, mani kútɛ kɛnɛ, ani ífĩninↄ kɛ̃mma zia kũ n ìbanↄ kũ n gbɛ̃nↄ. Ama ǹsun manafiki kɛ doro. Ǹ tó gbɛ̃nↄ gɛ́ sa o Dikiria. ");
INSERT INTO bqp_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kũ Musa bò Firi'auna kĩnaa, a kútɛ kɛ̀nɛ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Dikiri a wɛ́kɛ sì, akũ ífĩninↄ kɛ̃̀ Firi'aunaa kũ a ìbanↄ kũ a gbɛ̃nↄ. Adi gↄ̃ gukearo, bee mɛ̀n do. ");
INSERT INTO bqp_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ama Firi'auna sã kpɛ́ gbãna ari tera, à gì ń gbarɛi. ");
INSERT INTO bqp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Dikiri pì Musanɛ: Ǹ gɛ́ ǹ Firi'auna le ǹ onɛ Dikiri Eberunↄ Luda pì, à ma gbɛ̃nↄ gbarɛ ò gɛ́ donyĩ kɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tó à gì ń gbarɛi, tó à kpɛ́ ń kũna ari tera, ");
INSERT INTO bqp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mani ↄ tↄ̃ a pↄ́kãdenↄa a buran. Mani gagagyã pãsĩ ká a sↄ̃nↄn kũ a zaakinↄ kũ a lakuminↄ kũ a zùnↄ kũ a sãnↄ kũ a blènↄ. ");
INSERT INTO bqp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mani Isaraila pↄ́kãdenↄ dↄ̃kↄ̃nɛ kũ Misilanↄ pↄ́nↄo. Isarailanↄ pↄ́kãdenↄ ke ni garo. ");
INSERT INTO bqp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Makũ Dikiri ma a gↄrↄ dìtɛ. Zian mani abire kɛ bùsun la. ");
INSERT INTO bqp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kũ gu dↄ̀, akũ Dikiri kɛ̀ lɛ. Misilanↄ pↄ́kãdenↄ gàga pínki, ama Isarailanↄ pↄ́kãdenↄ ke dí garo. ");
INSERT INTO bqp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firi'auna yã kũ à kɛ̀ pìi gbɛ̀ka, à mà Isarailanↄ pↄ́kãdenↄ ke dí garo, ama a sã kpɛ́ gbãna, à gì gbɛ̃ pìnↄ gbarɛi. ");
INSERT INTO bqp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Dikiri pì Musanɛ kũ Harunao: À tãmakpɛ túbu dã okũ dodo, Musa fã Firi'auna arɛ. ");
INSERT INTO bqp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ani da Misila bùsula pínki lán lukutɛ̃ bà, ani kɛ bisãsirinↄnɛ kũ nↄ̀bↄnↄ bↄ̀bũnu ũ gu sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Akũ ò tãmakpɛ túbu sɛ̀tɛ ò gɛ̀ɛo Firi'auna kĩnaa. Kũ Musa túbu pìi fã̀ musu, akũ à kɛ̀ bisãsirinↄnɛ kũ nↄ̀bↄnↄ bↄ̀bũnu ũ. ");
INSERT INTO bqp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ɛzɛdenↄ dí fↄ̃ ò gɛ̀ɛ Musa kĩnaaro bↄ̀bũnu pìnↄ yãi, zaakũ à dàńla kũ Misilanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Akũ Dikiri Firi'auna kùu kɛ̀ gbãna, lákũ à ò Musanɛ nà, akũ à gì ń yã mai. ");
INSERT INTO bqp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Dikiri pì Musanɛ: Ǹ futɛ kↄnkↄkↄnkↄ ǹ gɛ́ ǹ Firi'auna le, ǹ onɛ makũ Dikiri Eberunↄ Luda ma pì, à ma gbɛ̃nↄ gbarɛ ò gɛ́ donyĩ kɛmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tera sà mani yã pãsĩ pínki daala kũ a ìbanↄ kũ a gbɛ̃nↄ, de àgↄ̃ dↄ̃ kũ andunia gũn pínki gbɛ̃ke de lán ma bàro. ");
INSERT INTO bqp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Zaakũ tó ma ↄ tↄ̃̀ḿma ma gagagyã kàńgu yã, de àkũ kũ a gbɛ̃nↄ làka andunia gũn. ");
INSERT INTO bqp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ma a kà kpatan de mà a gbãna mↄnɛ, ò ma tↄ́ kpá andunia gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Lákũ àtɛni a zĩda bi, à gì ma gbɛ̃nↄ gbarɛi ari tera, ");
INSERT INTO bqp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","zia mandara'i mani tó legũgbɛ pãsĩ ma manamana, legũgbɛ kũ a taka buri dí ma Misila zikiro zaa lákũ ò a kàtɛ nà ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ǹ onɛ à gbɛ̃nↄ zĩ ò a pↄ́kãdenↄ kũ pↄ́ kũ à vĩ buranↄ sɛ́tɛ ò káka kpɛ́n pínki. Bisãsirinↄ kũ pↄ́ kũ ò kú bàainↄ, tó òdi gɛ̃ kũńwo kpɛ́nlo, legũgbɛ ni maḿma oni gagamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Firi'auna ìba kenↄ vĩna kɛ̀ Dikiri yãnɛ, ò ń zĩkɛrinↄ kũ ń pↄ́kãdenↄ kàka kpɛ́n. ");
INSERT INTO bqp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ama gbɛ̃ kũ odi Dikiri yã daronↄ ń zĩkɛrinↄ kũ ń pↄ́kãdenↄ tò bàai. ");
INSERT INTO bqp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Akũ Dikiri pì Musanɛ: Ǹ ↄ sɛ́ musu, legũgbɛ ni ma bisãsirinↄ kũ pↄ́kãdenↄ kũ burapↄnↄa Misila bùsu gu sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Kũ Musa a gòo dↄ̀ musu, Dikiri tò legũ tɛn pũtã, àtɛn ma kũ gbɛ̀ɛo, àtɛn pí, akũ sura tɛn kipa zĩtɛ. Dikiri legũgbɛ kà Misilanↄgu. ");
INSERT INTO bqp_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Legũgbɛ tɛn ma, legũ tɛn pí. Legũgbɛ pì pãsĩ. Zaa lákũ Misila bùsu kun nà, legũ dí taka buri dí ma zikiro. ");
INSERT INTO bqp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Legũgbɛɛ pì pↄ́ kũ ò kú bàai Misila bùsu gũnnↄ ásaru kɛ̀ pínki, bisãsirinↄ kũ pↄ́kãdenↄ kũ burapↄnↄ pínki. À sɛ̃̀ntɛ línↄ ɛ̀'ɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosɛ̃ bùsu gu kũ Isarailanↄn kunn legũgbɛɛ pì dí kánlo ado. ");
INSERT INTO bqp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firi'auna Musa kũ Harunao sìsi à pìńnɛ: Tera sà ma durunna kɛ̀. Dikiri yã mɛ́ à nna, makũ kũ ma gbɛ̃nↄ taaridenↄn ó ũ. ");
INSERT INTO bqp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","À kútɛ kɛnɛ. Legũpũtãna kũ legũgbɛ díkĩnao mↄ̀ lɛ. Mani á gbarɛ sa, mani gíárɛ doro. ");
INSERT INTO bqp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa pìnɛ: Tó ma bo wɛ̃tɛ kpɛ, mani ma ↄnↄ sɛ́ lei gɛna Dikiri kĩnaa, legũpũtãna ni zɛ, legũgbɛ ni láka, de ǹgↄ̃ dↄ̃ kũ zĩtɛ bi Dikiri pↄ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ama má dↄ̃ kũ mↄkↄ̃n kũ n ìbanↄ, átɛn vĩna kɛ Dikiri Ludanɛro ari tera. ");
INSERT INTO bqp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Nagã kũ gbadoo yàka, zaakũ nagã gĩnakɛ à pìa, gbado mure bò. ");
INSERT INTO bqp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ése kũ werao dí yakaro, kũ òdi ma kpɛkpɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa bò Firi'auna kĩnaa à gɛ̀ɛ wɛ̃tɛ kpɛ, à a ↄnↄ sɛ̀ lei gɛna Dikiri kĩnaa, akũ legũpũtãna kũ legũgbɛɛo zɛ̀, legũ dí ma doro. ");
INSERT INTO bqp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kũ Firi'auna è legũ kũ legũgbɛɛo kũ legũpũtãnaao zɛ̀, akũ à kpɛ́ àtɛn durunna kɛ, a sã kpɛ́ gbãna, àkũ kũ a ìbanↄ. ");
INSERT INTO bqp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","A kù kpɛ́ gbãna à gì Isarailanↄ gbarɛi, lákũ Luda dà Musanɛ à ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Dikiri pì Musanɛ: Ǹ gɛ́ Firi'auna kĩnaa, zaakũ ma a kù kɛ gbãna kũ a ìbanↄ, de mà a daboyã dínↄ kɛ ń tɛ́, ");
INSERT INTO bqp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","de ǹ le ǹ o n nɛ́nↄnɛ kũ n daikorenↄ lákũ ma wɛ́ tã̀ Misilanↄa nà kũ daboyã kũ ma kɛ̀ ń tɛ́nↄ, àgↄ̃ dↄ̃ kũ makũmɛ Dikiri ũ. ");
INSERT INTO bqp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Akũ Musa kũ Harunao gɛ̀ɛ ò pì Firi'aunanɛ: Dikiri Eberunↄ Luda pì, ĩnigↄ̃ kun mìnatɛnaarɛ sari ari bↄrɛmɛɛ? Ǹ a gbɛ̃nↄ gbarɛ ò gɛ́ donyĩ kɛarɛ. ");
INSERT INTO bqp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tó n gi ń gbarɛi, zia ani kwanↄ ká n bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ò da zĩtɛla, oni gu ero. Ò lɛ́tɛ pↄ́ kũ ò gↄ̃̀nnɛ legũgbɛɛ gbɛranↄa kũ línↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ò pa n kpɛ́nↄ gũn kũ n ìbanↄ pↄ́nↄ kũ Misilanↄ pↄ́nↄ pínki. N denↄ kũ n dizinↄ dí a taka e zikiro, zaa gↄrↄ kũ ò vùtɛ bùsu dín ari kũ a gbãrao. Akũ Musa ɛ̀ra à bò Firi'auna kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Firi'auna ìbanↄ pìnɛ: Gbɛ̃ pìnↄ nigↄ̃ kisira dawá lɛ ari bↄrɛɛ? Ǹ gbɛ̃ pìnↄ gbarɛ ò gɛ́ donyĩ kɛ Dikiri ń Ludanɛ. Ń dↄ̃ kũ Misila kàkatɛroo? ");
INSERT INTO bqp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Akũ ò ɛ̀ra ò sù kũ Musao kũ Harunao Firi'auna kĩnaa, à pìńnɛ: À gɛ́ donyĩ kɛ Dikiri á Ludanɛ. Á dínↄ mɛ́ oni gɛ́ɛ? ");
INSERT INTO bqp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa wèa à pì: Nɛ́ fíti gbɛ̃ zↄ̃kↄ̃. Óni gɛ́ ó pínkimɛ kũ ó nɛ́gↄ̃gbɛ̃nↄ kũ ó nɛ́nↄgbɛ̃nↄ kũ ó sãnↄ kũ ó blènↄ kũ ó zùnↄ, zaakũ Dikiri dikpɛn ótɛn gɛ́ kɛ. ");
INSERT INTO bqp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Akũ à pìńnɛ: Tó ma á gbárɛ kũ á nↄgbɛ̃nↄ kũ á nɛ́nↄ á pínki, ásarumɛ, Dikiri á bo! À laakari kɛ! Átɛn wɛtɛ à fɛ̃ kũmaomɛ. ");
INSERT INTO bqp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Oi! Á gↄ̃gbɛ̃nↄ mɛ́ oni gɛ́ donyĩ kɛ Dikirinɛ, zaakũ lɛn a gbɛ̀ka lɛ. Akũ ò pɛ̀ḿma Firi'auna arɛ. ");
INSERT INTO bqp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Dikiri pì Musanɛ: Ǹ n ↄ dↄ Misila bùsula, kwanↄ ni ká ò sɛ̃̀ kũ lá kũ ò bùtɛ legũgbɛɛ gbɛranↄ ble pínki. ");
INSERT INTO bqp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kũ Musa a gòo dↄ̀ Misilala, Dikiri bò kũ ĩao ifãboki kpa, àtɛn pá bùsuu pìia fãnantɛ̃ kũ gwãanio zɛnaa sari. Kũ gu dↄ̀, ifãboki ĩa pìi sù kũ kwanↄ. ");
INSERT INTO bqp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Akũ kwa pìnↄ sù ò dà Misila bùsula pínki. Ń dasi de a yã pↄ́nↄla, a taka ni kɛ ziki doro. ");
INSERT INTO bqp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ò dà zĩtɛla gu sĩnda pínki, akũ zĩtɛ sira kũ̀. Ò sɛ̃̀ kũ lánↄ kũ línɛ kũ ò bò legũgbɛɛ gbɛranↄ blè pínki. Sɛ̃̀ɛ kũ láo kú Misila bùsun doro. ");
INSERT INTO bqp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Gwe gↄ̃̀nↄ Firi'auna Musa kũ Harunao sìsi à pì: Ma durunna kɛ̀ Dikiri á Ludanɛ kũ ákↄ̃nↄ. ");
INSERT INTO bqp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","À sùru gɛ̃̀n do dí kɛmɛnɛ kũ ma durunnao, à kútɛ kɛmɛnɛ Dikiri á Ludanɛ à gaga dí kɛ̃ma. ");
INSERT INTO bqp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kũ à bò Firi'auna kĩnaa, à kútɛ kɛ̀ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Akũ Dikiri bò kũ ĩa gbãnao ifãlɛtɛ kpa, à sù à kwanↄ sɛ̀tɛ à kà Isira Tɛ̃ran. Bee kwa mɛ̀n do dí gↄ̃ Misila doro. ");
INSERT INTO bqp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ama Dikiri Firi'auna kùu kɛ̀ gbãna, akũ à gì Isarailanↄ gbarɛi. ");
INSERT INTO bqp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Dikiri pì Musanɛ: Ǹ ↄ sɛ́ musu, gusira kũ oni fↄ̃ ò ↄ kɛa ni da Misilala. ");
INSERT INTO bqp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kũ Musa a ↄ dↄ̀ musu, akũ gusira níkiniki dà Misila gu sĩnda pínkia ari gↄrↄ aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Òdi kↄ̃ ero, gbɛ̃ke dí bo a gbɛ̀nlo ari gↄrↄ aakↄ̃ pìia. Ama gupura kú gu kũ Isarailanↄn kun pínki. ");
INSERT INTO bqp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Akũ Firi'auna Musa sìsi à pì: À gɛ́ donyĩ kɛ Dikirinɛ kũ á nↄgbɛ̃nↄ kũ á nɛ́nↄ á pínki, ama à á sãnↄ kũ á blènↄ kũ á zùnↄ tó. ");
INSERT INTO bqp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa pì: Ǹ tó ògↄ̃ ó sa'opↄnↄ kũ sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũnↄ kũna, de ò le ò Dikiri ó Luda gbagbao. ");
INSERT INTO bqp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Séto ò gɛ́ kũ ó pↄ́kãdenↄ, bee mɛ̀n do ni gↄ̃ro, zaakũ ń tɛ́n óni sa'opↄnↄ bon ò Dikiri ó Luda gbagbao. De ò kpɛ́ ò ká gwe, ó dↄ̃ pↄ́ kũ óni sɛ́, ò sa ooa gĩaro. ");
INSERT INTO bqp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Dikiri Firi'auna kùgbãna kũ̀, akũ adi we à ń gbarɛro. ");
INSERT INTO bqp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firi'auna pì Musanɛ: Ǹ gomɛnɛ gwe! Ǹsun tó ó wɛ́ kɛ pla doro. Zĩ kũ ó wɛ́ kɛ̀ pla, n gamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Akũ Musa pì: Lákũ n ò nà, óni kↄ̃ e doro. ");
INSERT INTO bqp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","À sù à lè Dikiri gĩnakɛ à pì Musanɛ: Mani wari dↄ Firi'aunaa kũ Misila bùsuuo gɛ̃̀n do dↄ, ani gbasa à á gbarɛ. Tó àtɛni á gbarɛ, ani pɛ́áwamɛ! ");
INSERT INTO bqp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ǹ o gbɛ̃nↄnɛ ń baadi gↄ̃gbɛ̃ kũ nↄgbɛ̃o andurufu pↄ́nↄ kũ wura pↄ́nↄ gbɛka á Misila gbɛ̃dakea. ");
INSERT INTO bqp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mani tó Isarailanↄ kɛ kũ Misilanↄo nna. Musa sↄ̃, àdigↄ̃ bɛ̀ɛrɛ vĩ Misila gũn Firi'auna ìbanↄnɛ kũ a gbɛ̃nↄ. ");
INSERT INTO bqp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Akũ Musa pì Firi'aunanɛ: Dikiri pì, gwãani lizãndo áni vĩ Misila bùsula, ");
INSERT INTO bqp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Misila daudunↄ ni gaga ń pínki sɛna zaa Firi'auna kũ à vutɛna kpataa nɛ́a ari à gɛ̀ɛ pɛ́ nↄgbɛ̃ zĩkɛri kũ òdi wísi lↄ́nↄ nɛ́a kũ pↄ́kãde nɛ́ sà káakunↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Oni wɛ̃nda ↄ́ gbãna dↄ Misila gu sĩnda pínkia, a taka dí kɛ yãro, ani kɛ ziki doro. ");
INSERT INTO bqp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ama Isarailanↄ tɛ́ bee gbɛ̃ ni won kɛ bisãsiri ke pↄ́kãdearo, de ǹgↄ̃ dↄ̃ kũ Dikiri Misilanↄ dↄ̃kↄ̃nɛ kũ Isarailanↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","N ìba dínↄ ni su ma kĩnaa ń pínki ò kútɛmɛnɛ, ò pi mà gɛ́ kũ ma gbɛ̃nↄo ń pínki. Abire gbɛra sà mani gɛ́. Akũ Musa bò Firi'auna kĩnaa kũ pↄfɛ̃ zↄ̃kↄ̃ↄo. ");
INSERT INTO bqp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Dikiri pì Musanɛ yã: Firi'auna ni n yã maro, de ma daboyãkɛnanↄ kɛ dasi Misila. ");
INSERT INTO bqp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa kũ Harunao daboyã pìnↄ kɛ̀ Firi'auna arɛ pínki, akũ Dikiri a kùgbãna kũ̀. À gì Isarailanↄ gbarɛi ò bo a bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Dikiri yã ò Musanɛ kũ Harunao Misila à pì: ");
INSERT INTO bqp_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Mↄ díkĩna nigↄ̃ deárɛ mↄ káaku ũ wɛ̃̀ kũ wɛ̃̀ɛo. ");
INSERT INTO bqp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","À o Isarailanↄnɛ ń pínki, mↄ díkĩna gↄrↄ kuride zĩ ò sã bobo mɛ̀n dodo ↄn kũ ↄnnwo pínki. ");
INSERT INTO bqp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tó ↄn gbɛ̃nↄ dasi dí ká ò sã mɛ̀n do só sↄ̃ro, ò kpàatɛ kũ ↄn kũ ò kú kↄ̃ sarɛo a gbɛ̃nↄ lɛ́n, de a kpara sún gↄ̃ro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","À sãkaro ke blèkofĩni fíti kũ à mamberu vĩro bo. ");
INSERT INTO bqp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Isarailanↄ pínki, baadi a pↄ́ gwa ari mↄ díkĩna gↄrↄ gɛ̃ro donsaride zĩ. Ɔkↄsin oni dɛ, ");
INSERT INTO bqp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","oni a aru má kpɛ́ kũ oni a nↄ̀bↄ són kpɛ́lɛlɛ gbĩ̀nↄa, ↄplai kũ ↄzɛo kũ musuo. ");
INSERT INTO bqp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Gwãani dokↄ̃nↄ pìia oni nↄ̀bↄↄ pì kpá tɛ́a, oni só kũ burodi futɛnasario kũ lá kyã̀kyãao. ");
INSERT INTO bqp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Àsun só búsu ke fùfukɛnaro. À kpá tɛ́a kũ a mìio kũ a gbánↄ kũ a pↄ́gũnnↄ. ");
INSERT INTO bqp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Àsun tó gu dↄ a kparaaro. Tó a kpara gↄ̃̀, à a kpáta à tɛ́ kũ. ");
INSERT INTO bqp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tó átɛn só, à asa dↄáwa à kyate kpá, á gò gↄ̃ nana á ↄĩ. À só likalika, zaakũ Dikiri Vĩnla sa'opↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Gwãani pìia mani vĩ Misilala mà daudunↄ dɛdɛ bùsuu pì gu pínkia kũ pↄ́kãde nɛ́ sà káakunↄ ń pínki, mani wé'i da Misila tãnanↄa. Makũmɛ Dikiri ũ. ");
INSERT INTO bqp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Aru pì nigↄ̃ de sèeda ũ kpɛ́ kũ á kú a gũnnↄwa. Tó matɛn ↄ tↄ̃ Misilanↄa, tó ma aru pìi è, mani gɛ̃ála, gaga pì ni á lero. ");
INSERT INTO bqp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","À gↄrↄ pì ditɛ ma dikpɛ gↄrↄ ũ dↄngu yãi, àgↄ̃ dikpɛ pì kɛ kɛ̀otokↄ̃nɛ ũ ari á buria. ");
INSERT INTO bqp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Gↄrↄ suppla gũn à burodi futɛnasari só. A gↄrↄ káaku zĩ à lùbɛnɛ kũ à kú á kpɛ́ gũnnↄ kↄ́tɛ, zaakũ gbɛ̃ kũ à pↄ́futɛnaa sò gↄrↄ suppla pìi gũn, oni a bo Isarailanↄ tɛ́ ò a dɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A gↄrↄ káaku zĩ kũ a gↄrↄ suppladeo à kↄ̃ kakara à donyĩ kɛmɛnɛ. Àsun zĩ ke kɛ gↄrↄ kũ̀nↄaro, sé pↄ́blekɛna gbɛ̃ sĩnda pínkinɛ baasiro, a lɛ́n gwe. ");
INSERT INTO bqp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","À Burodi Futɛnasari dikpɛ kɛ, zaakũ zĩ birean ma á bↄ́tɛ Misila lán zĩ̀karinↄ bà. Á burinↄ gↄ̃ dikpɛ pì kɛ kɛ̀otokↄ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mↄ káaku gↄrↄ gɛ̃ro donsaride zĩ ↄkↄsi, àgↄ̃ burodi futɛnasari só ari a gↄrↄ baro awɛɛdode zĩ ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Gↄrↄ suppla gũn lùbɛnɛ sún gↄ̃ kú á bɛaro, zaakũ gbɛ̃ kũ à pↄ́futɛnaa sò, gbɛ̃ zĩ̀tↄↄn yòo, beden yòo, oni a bo Isarailanↄ tɛ́ ò a dɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Àsun pↄ́futɛna só gↄrↄ pìiaro. Gu kũ á kun pínki, àgↄ̃ burodi futɛnasari só. ");
INSERT INTO bqp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa Isaraila gbɛ̃ zↄ̃kↄ̃nↄ sìsi ń pínki à pìńnɛ: À gɛ́ à á ↄn sã kũ à dɛ Vĩnla dikpɛkɛpↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","À sɛ̃̀sↄ̃vlã sɛ́ à zↄ̃ aru kũ à kú ta gũnwa à máma á kpɛ́lɛlɛ gbĩ̀nↄa, ↄplai kũ ↄzɛo kũ a musuo. Á gbɛ̃ke sún bo bàairo ari gu dↄ. ");
INSERT INTO bqp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tó Dikiri tɛn pã bùsula àtɛn Misilanↄ dɛdɛ, tó à aru è kpɛ́lɛlɛ gbĩ̀nↄa, ani gɛ̃alamɛ. Ani tó gbɛ̃dɛdɛri gɛ̃ái à á dɛdɛro. ");
INSERT INTO bqp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ákↄ̃nↄ kũ á burinↄ àgↄ̃ yã pì kũna kɛ̀otokↄ̃nɛ ũ ari á buria. ");
INSERT INTO bqp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tó a gɛ̃ bùsu kũ Dikiri ni á gban lákũ à a lɛ́ sɛ̀árɛ nà, àgↄ̃ donyĩyã pì kũna. ");
INSERT INTO bqp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tó á nɛ́nↄ donyĩyã pìi mìi gbɛ̀kaáwa, ");
INSERT INTO bqp_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","à ońnɛ kũ Vĩnla sa kũ òdi o Dikiriaamɛ, zaakũ kũ à Misilanↄ dɛ̀dɛ, à gɛ̃̀ ó Isarailanↄ kpɛ́la, adi ó dɛdɛro. Akũ gbɛ̃nↄ kùtɛ ò donyĩ kɛ̀ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kũ ò tà, ò kɛ̀ lákũ Dikiri ò Musa kũ Harunaoonɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gwãani lizãndo Dikiri Misila daudunↄ dɛ̀dɛ ń pínki, sɛna zaa Firi'auna kũ à vutɛna kpataa nɛ́a ari à gɛ̀ɛ pɛ́ purusunanↄ nɛ́nↄa kũ pↄ́kãde nɛ́ sà káakunↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Firi'auna fùtɛ gwãani kũ a ìbanↄ kũ Misilanↄ ń pínki, akũ wɛ̃nda ↄ́ dà Misilala, zaakũ ↄn ke kun gɛ̀ɛ sariro. ");
INSERT INTO bqp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Gwãanin Firi'auna Musa kũ Harunao sìsi à pìńnɛ: À futɛ kũ Isarailanↄ à bↄtɛ ma gbɛ̃nↄ tɛ́. À gɛ́ donyĩ kɛ Dikirinɛ lákũ a ò nà. ");
INSERT INTO bqp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","À á blènↄ kũ á sãnↄ kũ á zùnↄ sɛ́tɛ lákũ a ò nà. À gɛ́ à sa mana omɛnɛ se. ");
INSERT INTO bqp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misilanↄ nàkara gbɛ̃ pìnↄa ò bↄtɛńnɛ ń bùsun likalika, zaakũ ò pì: Óni gaga ó pínkimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Isarailanↄ ń flawadɛnanↄ kà tanↄ gũn lùbɛnɛɛ sari, ò ń utanↄ fĩ̀fĩa ò dàda ń gã̀n. ");
INSERT INTO bqp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ò kɛ̀ lákũ Musa òńnɛ nà, ò andurufu pↄ́nↄ kũ wura pↄ́nↄ kũ pↄ́kasanↄ gbɛ̀ka Misilanↄa. ");
INSERT INTO bqp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dikiri tò Misilanↄ ń wɛ́ gwà, akũ ò kpàḿma. Lɛmɛ ò Misilanↄ pↄ́nↄ sìḿma lɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isarailanↄ dà zɛ́n gɛ̀sɛ, ò bↄ̀tɛ kũ Ramɛsɛo ò tà Suko. Gↄ̃gbɛ̃nↄ gbɛ̃nↄn dúbu wàa aakↄ̃mɛ, nɛ́nↄ kũ nↄgbɛ̃nↄ baasi. ");
INSERT INTO bqp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Buri zĩ̀tↄnↄ tà kũńwo dasi dↄ. Blènↄ kũ sãnↄ kũ zùnↄn dasi manamana. ");
INSERT INTO bqp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ò burodi futɛnasari kɛ̀ kũ flawadɛna kũ ò bòo Misilao. Ò kɛ̀ lùbɛnɛɛ sari, zaakũ ò pɛ̀ḿma Misila kãntomɛ. Odi le ò pↄ́ble kɛ̀ ò sɛ̀ zãna ũro. ");
INSERT INTO bqp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isarailanↄ kunna Misila kɛ̀ wɛ̃̀ wàa pla kũ baraakurio. ");
INSERT INTO bqp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Wɛ̃̀ wàa pla kũ baraakurio pì papanaa gbɛra, dikpɛ pì zĩn Dikiri zĩ̀karii pìnↄ bↄ̀tɛ Misila ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Gwãani pì kun Dikiri pↄ́ ũmɛ. Isarailanↄ nigↄ̃ ibɛ̃nɛ kɛa ari ń buria, zaakũ gwãani pìin Dikiri Isarailanↄ bona Misila ibɛ̃nɛ kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Dikiri pì Musanɛ kũ Harunao: Vĩnla yã kũ ma dìtɛn dí. Buri zĩ̀tↄ ke sún a nↄ̀bↄ sóro, ");
INSERT INTO bqp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ama zↄ̀ kũ a lù, tó a tↄ̃̀ zↄ̃na, ani só. ");
INSERT INTO bqp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nibↄ ke gbasekɛri sún sóro. ");
INSERT INTO bqp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","À só kpɛ́n, àsun bo kũ a nↄ̀bↄↄ pìio bàairo. Àsun sã pì wá ke ɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isarailanↄ pínki gↄ̃ dikpɛ pì kɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tó gbɛ̃ zĩ̀tↄ kú á tɛ́, tó à ye à Vĩnla dikpɛ kɛ Dikirinɛ, à a bɛ gↄ̃gbɛ̃nↄ tↄ̃̀ zↄ̃ ń pínki à gↄ̃ bede ũ gbasa à kɛ. Gyↄfↄrↄde sún sóro. ");
INSERT INTO bqp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Bede kũ gbɛ̃ zĩ̀tↄ kũ à kú kãáo, doka dokↄ̃nↄ pìimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Akũ Isarailanↄ kɛ̀ lákũ Dikiri ò Musanɛ nà kũ Harunao ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Zĩ birean Dikiri Isarailanↄ bↄ̀tɛ Misila gã̀ kũ gã̀ao. ");
INSERT INTO bqp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Dikiri yã ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Àgↄ̃ Isaraila daudunↄ kũ pↄ́kãde nɛ́ sà káakunↄ kpáma, zaakũ ma pↄ́nↄmɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa pì Isarailanↄnɛ: Á bona Misila zↄ̀blen gↄrↄ díkĩna yã gↄ̃ dↄágu, zaakũ Dikiri mɛ́ à á bↄ́tɛ Misila kũ a ↄ gbãnao. Àsun pↄ́futɛna só gↄrↄ pìiaro. ");
INSERT INTO bqp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Átɛn bↄtɛ Misila gbãramɛ mↄ káaku kũ òdi pi Abibu gũn. ");
INSERT INTO bqp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Dikiri lɛ́ sɛ̀ á dizinↄnɛ à pì áni bùsu kũ à vĩ kũ zↄ́'io din, kũ Kanaanↄ kũ Itinↄ kũ Amↄrinↄ kũ Ivinↄ kũ Yebusinↄn kun kpááwa. Tó à tò a ka, à dikpɛ pì kɛ mↄ dín. ");
INSERT INTO bqp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Àgↄ̃ burodi futɛnasari só ari gↄrↄ suppla. A gↄrↄ supplade pì zĩ nigↄ̃ deárɛ Dikiri dikpɛ gↄrↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Àgↄ̃ burodi futɛnasari só ari gↄrↄ suppla pì papa. Pↄ́futɛna ke lùbɛnɛ ke súngↄ̃ kú ↄn ke gũn á bùsunlo. ");
INSERT INTO bqp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Zĩ pìia àgↄ̃ o á nɛ́gↄ̃gbɛ̃nↄnɛ átɛn kɛ lɛ yã kũ Dikiri kɛ̀árɛ kũ à á bↄ́tɛ Misila yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Dikpɛ pì nigↄ̃ deárɛ sèeda ũ lán pↄ́ dana ↄaa bà, ke lán dↄngu pↄ́ yĩna mì'arɛaa bà, de Dikiri doka gↄ̃ kú á lɛ́n, zaakũ àkũ mɛ́ à á bↄ́tɛ Misila kũ a ↄ gbãnao. ");
INSERT INTO bqp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Àgↄ̃ dokayã pì kɛ a gↄrↄa wɛ̃̀ kũ wɛ̃̀ɛo. ");
INSERT INTO bqp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Tó Dikiri tò a ka Kanaanↄ bùsun, akũ à kpàáwa lákũ à a lɛ́ sɛ̀árɛ nà kũ á dizinↄ, ");
INSERT INTO bqp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","àgↄ̃ á daudunↄ kpáa ń pínki. Á pↄ́kãde nɛ́ sà káakunↄ dìgↄ̃ de a pↄ́ ũ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Àgↄ̃ á zaaki nɛ́ sà káaku tↄrↄma bo kũ sãnɛo. Tó ádi boro, à a waka fĩ. Àgↄ̃ á daudunↄ tↄrↄma bo ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tó á nɛ́gↄ̃gbɛ̃nↄ á lá a mìii zia ò pì, bↄ́ yãn gwee, à pińnɛ Dikiri á bↄ́tɛ zↄ̀blen Misila yã kũ a ↄ gbãnao yãimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kũ Firi'auna kùgbãna kɛ̀ à gì ó gbarɛi, akũ Dikiri Misila daudunↄ dɛ̀dɛ ń pínki kũ pↄ́kãde nɛ́ sà káakunↄ ń pínki. A yã mɛ́ à tò odì sa oa kũ pↄ́kãde nɛ́ sà káakunↄ pínki, odì ó daudunↄ tↄrↄma bo. ");
INSERT INTO bqp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Adikĩna nigↄ̃ de sèeda ũ lán pↄ́ dana ó ↄaa bà ke pↄ́ yĩna ó mì'arɛaa bà, zaakũ Dikiri mɛ́ à ó bↄ́tɛ Misila kũ a ↄ gbãnao. ");
INSERT INTO bqp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kũ Firi'auna Isarailanↄ gbàrɛ, Luda dí bo kũńwo Filisitini bùsu zɛ́ kparo, bee kũ a kãnikɛo, zaakũ à pì: Tó ò fùtɛńyĩ kũ zĩ̀io, oni ǹ nɛ̀sɛ litɛ ò ɛra Misila. ");
INSERT INTO bqp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Luda pã̀ zɛ́ pìinɛ, akũ à gbáranna zɛ́ sɛ̀ kũńwo Isira Tɛ̃ra kpa. Isarailanↄ bↄ̀tɛ Misila ò ń zĩ̀kabↄnↄ kũna. ");
INSERT INTO bqp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa Yusufu wánↄ sɛ̀ àtɛn táo, zaakũ Yusufu tò Isarailanↄ lɛ́ sɛ̀arɛ yã à pì, tó Luda sù ń bo, oni a wánↄ sɛ́tɛ ò boo gwe. ");
INSERT INTO bqp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kũ ò bò Suko, ò gɛ̀ɛ ò bùraa kàtɛ gbáranna lɛ́a zaa Etamu. ");
INSERT INTO bqp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Dikiri dìgↄ̃ dońnɛ arɛ tɛ́luku gũn fãnantɛ̃ de àgↄ̃ zɛ́ mↄńnɛ. Gwãani sↄ̃ àdigↄ̃ dońnɛ arɛ tɛ́nɛnɛ gũn, de àgↄ̃ gu puńnɛ ògↄ̃ táa o fãnantɛ̃ kũ gwãanio. ");
INSERT INTO bqp_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tɛ́luku pìi dì go ń arɛ fãnantɛ̃ro, tɛ́nɛnɛ pìi dì go ń arɛ gwãaniro. ");
INSERT INTO bqp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Dikiri pì Musanɛ: ");
INSERT INTO bqp_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Ǹ o Isarailanↄnɛ ò litɛ ò gɛ́ bùra kátɛ Pi'airo sarɛ Migidolu kũ ísirao dagura, arɛdↄkↄ̃ana kũ Baali Zɛfↄ̃o. À bùra kátɛ ísira sarɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firi'auna nigↄ̃ da a sãtɛ, gbáranna á kũkũmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mani a kùgbãna kũ, ani pɛ́tɛái, mani tↄ́ bo Firi'auna kũ a zĩ̀karinↄ yã sabai, Misilanↄ nigↄ̃ dↄ̃ kũ makũmɛ Dikiri ũ. Akũ Isarailanↄ kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kũ ò ò Misilanↄ kína Firi'aunanɛ gbɛ̃ pìnↄ bàa lɛ̀, akũ àpii kũ a ìbanↄ nɛ̀sɛ lìtɛ Isarailanↄ yã musu ò pì: Bↄ́n o kɛ̀, akũ o tò ò bò zↄ̀blenawɛrɛnn? ");
INSERT INTO bqp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Akũ Firi'auna gó dↄ̀ a sↄ̃nɛ à a zĩ̀karinↄ kàkara. ");
INSERT INTO bqp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","À sↄ̃go mananↄ sɛ̀ mɛ̀n wàa aakↄ̃ kũ Misila sↄ̃gonↄ pínki kũ zĩ̀kari gbɛ̃ zↄ̃kↄ̃nↄo ká ń gũn. ");
INSERT INTO bqp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Dikiri Misilanↄ kína Firi'auna kùgbãna kũ̀, akũ à pɛ̀tɛ Isaraila kũ òtɛn bↄtɛ kũ swɛ̃̀gbãnaonↄi. ");
INSERT INTO bqp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Akũ Misilanↄ pɛ̀tɛńyĩ kũ Firi'auna sↄ̃nↄ kũ a sↄ̃gonↄ kũ a sↄ̃denↄ kũ a zĩ̀karinↄ ń pínki, akũ òtɛn su ń le ń bùran ísira sarɛ kãni kũ Pi'airoo arɛdↄkↄ̃ana kũ Baali Zɛfↄ̃o. ");
INSERT INTO bqp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kũ Firi'auna kà kãni, Isarailanↄ wɛ́ sɛ̀, akũ ò Misilanↄ è tɛ́ ń kpɛ. Vĩna ń kũ manamana, akũ ò wiki lɛ̀ Dikiria. ");
INSERT INTO bqp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ò pì Musanɛ: Miranↄn kú Misilanloo? Bↄ́ yã mɛ́ à tò n su kũoo gbárannan la ò gagaa? À kɛ̀ dera n bo kũoo Misilai? ");
INSERT INTO bqp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Asa o ònnɛ Misila ò pì ǹ ó tó tɛɛnɛ ò zↄ̀ ble Misilanↄnɛ! Zↄ̀blennɛna manawɛrɛ de gagana gbáranna dínla. ");
INSERT INTO bqp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa pìńnɛ: Àsun tó vĩna á kũro. À zɛ tɛɛnɛ áni e lákũ Dikiri ni á sura ba nà gbãra, zaakũ Misila kũ átɛni ń e gbãra dínↄ, áni ń e ziki doro. ");
INSERT INTO bqp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Dikiri mɛ́ ani zĩ̀ káárɛ. Àgↄ̃ yĩtɛna kítikiti dé! ");
INSERT INTO bqp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Dikiri Musa là à pì: Bↄ́ wikin ntɛn lɛ́maa? Ǹ o gbɛ̃nↄnɛ ò futɛ ò bo kũ táo. ");
INSERT INTO bqp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ǹ n gò dↄ ísirala à zↄ̃kↄ̃rɛ, de Isarailanↄ le ò gɛ̃tɛ a dagura gukoria. ");
INSERT INTO bqp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Makũ, mani Misilanↄ kùgbãna kũ, oni gɛ̃n ń gbɛra, mani tↄ́ bo Firi'auna kũ a zĩ̀karinↄ kũ a sↄ̃gonↄ kũ a sↄ̃denↄ yã sabai. ");
INSERT INTO bqp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tó ma tↄ́ bò Firi'auna kũ a sↄ̃gonↄ kũ a sↄ̃denↄ yã sabai, Misilanↄ nigↄ̃ dↄ̃ sà kũ makũmɛ Dikiri ũ. ");
INSERT INTO bqp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Luda Malaika kũ à do Isarailanↄnɛ arɛ ɛ̀ra à gɛ̀ɛ ń kpɛ kpa, akũ tɛ́luku kũ à kú ń arɛ ɛ̀ra à gɛ̀ɛ ń kpɛ dↄ ");
INSERT INTO bqp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","mↄ́kↄ̃nↄ kũ Misilanↄ dagura. Tɛ́luku pì gu pù Isarailanↄnɛ à gusira kpà Misilanↄnɛ, akũ ń gbɛ̃ke dí le à nà a dakei gwãani kũ̀aro. ");
INSERT INTO bqp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kũ Musa a ↄ dↄ̀ ísirala, akũ Dikiri bò kũ ĩa gbãnao ifãboki kpa. À kàka ari gu gɛ̀ɛ a dↄ̀o à ísira lɛ̀ à kpàatɛkↄ̃rɛ, akũ gukori bò. Kũ í zↄ̃̀kↄ̃rɛ, ");
INSERT INTO bqp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","akũ Isarailanↄ táa ò gukoria ò bikũ̀. Í bĩni bò ń ↄplai kũ ↄzɛo. ");
INSERT INTO bqp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Akũ Misilanↄ pɛ̀tɛńyĩ. Firi'auna sↄ̃nↄ kũ a sↄ̃gonↄ kũ a sↄ̃denↄ pínki tɛ́ ń kpɛ ísira gũn. ");
INSERT INTO bqp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Gudↄnaao Dikiri Misila zĩ̀karinↄ gwà zaa tɛ́nɛnɛ gũn, akũ à tò ò lìkara. ");
INSERT INTO bqp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","À tò ń sↄ̃gonↄ vlɛ̃̀, à tò ń táa'onaa kɛ̀ zĩ'ũ, akũ ò pì: Ò bàa lɛ́ Isarailanↄnɛ, zaakũ Dikiri tɛn zĩ̀ káńnɛ kũoomɛ. ");
INSERT INTO bqp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Dikiri pì Musanɛ: Ǹ n ↄ dↄ ísirala, í ni da Misilanↄla kũ ń sↄ̃gonↄ kũ ń sↄ̃denↄ. ");
INSERT INTO bqp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Akũ Musa a ↄ dↄ̀ ísirala, akũ í tɛn su a gbɛ̀n gudↄnaao. Lákũ í tɛn su nà, akũ Misilanↄ bàa sì ò ye ò bↄtɛ. Gwen Dikiri tò ísira dàńlan. ");
INSERT INTO bqp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Í sù a dà sↄ̃gonↄla kũ sↄ̃denↄ kũ Firi'auna zĩ̀kari kũ ò gɛ̃̀ ísira gũn Isarailanↄ gbɛranↄ ń pínki. Ń gbɛ̃ke dí boro, bee mɛ̀n do. ");
INSERT INTO bqp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isarailanↄ sↄ̃ ò táa ò í dagura gu koriamɛ. Í bĩni bò ń ↄplai kũ ↄzɛo. ");
INSERT INTO bqp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Zĩ birean Dikiri Isarailanↄ sì Misilanↄa, akũ Isarailanↄ Misila pìnↄ gɛ̀nↄ è ísira bara. ");
INSERT INTO bqp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kũ Isarailanↄ Dikiri gbãna zↄ̃kↄ̃ kũ à mↄ̀ Misilanↄnɛɛ è, ò vĩna kɛ̀nɛ, akũ ò a náani kɛ̀ kũ a zↄ̀bleri Musao. ");
INSERT INTO bqp_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Akũ Musa kũ Isarailanↄ ń pínki lɛ̀ dí sì Dikirinɛ ò pì: Mani lɛ̀ sí Dikirinɛ, zaakũ a tↄ́ bona, à sↄ̃denↄ kũ ń sↄ̃nↄ kà ísiran. ");
INSERT INTO bqp_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Dikiri mɛ́ à ma gbãna ũ, mani a táaki lɛ́, àkũ mɛ́ à ma sura bà. Àkũmɛ ma Luda ũ, mani a tↄ́ kpá. Àkũmɛ ma de Luda ũ, mani a tↄ́ sɛ́ lei. ");
INSERT INTO bqp_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Dikiri bi zĩ̀kariimɛ, a tↄ́n Dikiri. ");
INSERT INTO bqp_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","À Firi'auna sↄ̃gonↄ kũ a zĩ̀karinↄ kà ísiran, à zĩ̀kari gbɛ̃ zↄ̃kↄ̃nↄ vlɛ̃̀ Isira Tɛ̃ran. ");
INSERT INTO bqp_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Í lòkotoo pìi dàńla, ò kpàtɛ zĩtɛ lán gbɛ̀ɛ bà. ");
INSERT INTO bqp_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Dikiri, n ↄplan gbãna kun kũ zↄ̃kↄ̃kɛo, Dikiri, n n ibɛrɛnↄ kàkatɛ kũ n ↄplao. ");
INSERT INTO bqp_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","N n zãngurinↄ nɛ̀ n gakuri zↄ̃kↄ̃ↄ gũn, n pↄ fɛ̃̀ n ń nátɛ lán sɛ̃̀ɛ bà. ");
INSERT INTO bqp_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","N pↄ́ bò n yĩn, akũ í zↄ̃̀kↄ̃rɛ, à gↄ̃̀ zɛna lán bĩni bà, ísira ì ari a guragura. ");
INSERT INTO bqp_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ó ibɛrɛ pìnↄ pì, oni pɛ́tɛwái ò ó lemɛ, oni ó pↄ́nↄ sɛ́tɛ lákũ ò yei nà, oni ń fɛ̃nɛdanↄ bo ò ó dɛdɛo. ");
INSERT INTO bqp_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","N n lɛ́'ĩa vù, akũ ísira dàńla, ò kpàtɛ lán darumaa bà í zↄ̃kↄ̃ↄ pìn. ");
INSERT INTO bqp_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Dikiri, tãnanↄ tɛ́ a kpate mɛ́ à de lán n bàa? Dín oni lɛkↄ̃a kũnwoo? Yãbonsarɛkɛri, n zↄ̃kↄ̃kɛ adona, n gakuri naasi vĩ. ");
INSERT INTO bqp_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","N n ↄpla pòro, akũ zĩtɛ ń mↄ́mↄ. ");
INSERT INTO bqp_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ókↄ̃nↄ kũ n ó bó zↄ̀blennↄ ĩni dowɛrɛ arɛ n gbɛ̃kɛ gũn, ĩni gɛ́ kũoo n bùsun kũ n gbãnao. ");
INSERT INTO bqp_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Tó burinↄ mà, oni lukaluka, í wãna ni ká Filisitini bùsudenↄ pↄa. ");
INSERT INTO bqp_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ɛdↄmunↄ kínanↄ ni vĩna kɛ, swɛ̃̀ ni kɛ̃ Mↄabu don'arɛdenↄn, Kanaanↄ bùsudenↄ mɛ̀ ni yↄ́ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Vĩna zↄ̃kↄ̃ ni ń kũ, swɛ̃̀ ni kɛ̃ńgu, oni gↄ̃ kítikiti lán gbɛ̀ɛ bà n gbãna zↄ̃kↄ̃ yãi Dikiri, ari ókↄ̃nↄ kũ n ó sɛ́ n pↄ́ ũnↄ ni gɛ̃tɛ. ");
INSERT INTO bqp_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dikiri, ĩni gɛ́ kũoo kpi kũ n sɛ̀ n pↄ́ ũ kĩnaa, ĩni ó zĩni pɛ́tɛ gu kũ n dìtɛ n vutɛki ũn, n kúki kũ n kɛ̀kɛ n zĩdanɛɛ pìi. ");
INSERT INTO bqp_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Dikiri nigↄ̃ kí ble gↄrↄ sĩnda pínkimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kũ Firi'auna sↄ̃nↄ kũ a sↄ̃gonↄ kũ a sↄ̃denↄ gɛ̃̀ ísira gũn, akũ Dikiri sù kũ ío à dàńla, ama Isarailanↄ táa ò gukoria ísira pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Akũ annabi Miriamu, Haruna dãre, a sɛ̃̀gɛ̃ɛ sɛ̀, akũ nↄgbɛ̃nↄ bò ò tɛ́i ń pínki, òtɛn sɛ̃̀gɛ̃ pá òtɛn ũ wã. ");
INSERT INTO bqp_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu lɛ̀ɛ sìńnɛ à pì: À lɛ̀ sí Dikirinɛ, zaakũ a tↄ́ bona, à sↄ̃denↄ kũ ń sↄ̃nↄ kà ísiran. ");
INSERT INTO bqp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musa dà zɛ́n kũ Isarailanↄ, ò kɛ̃̀kↄ̃a kũ Isira Tɛ̃rao ò gɛ̃̀ Suru gbárannan. Ò táa ò gↄrↄ aakↄ̃ gbáranna pìn odi í ero. ");
INSERT INTO bqp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kũ ò kà gu kũ òdi pi Mara, odi fↄ̃ ò a í mìro kũ à kɛ̀ kyã̀kyã yãi. A yã mɛ́ à tò ò tↄ́ kpà gu pìinɛ Mara. ");
INSERT INTO bqp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Akũ gbɛ̃nↄ zuka kà Musai ò pì: Bↄ́n óni mii? ");
INSERT INTO bqp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa wiki lɛ̀ Dikiria, akũ Dikiri lí mↄ̀nɛ. Kũ Musa lí pìi zù ín, akũ í pìi kɛ̀ nna. Gwen Dikiri yã dìtɛńnɛ kũ dokao à ń yↄ̃ à ń gwá ");
INSERT INTO bqp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","à pì: Tó a laakarii dↄ̀ makũ Dikiri á Luda yãa átɛn yã kũ má yei kɛ, tó a yã kũ ma dìtɛnↄ mà, akũ á ma dokanↄ kũna pínki, mani gyã kũ ma kà Misilanↄn ke kááguro, zaakũ makũmɛ Dikiri kũ àdi á gba aafia ũ. ");
INSERT INTO bqp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Abire gbɛra ò kà Ɛlimu, gu kũ ísɛ̃boki mɛ̀n kuri awɛɛplanↄn kun kũ domina lí mɛ̀n baaakↄ̃ akurinↄo. Akũ ò bùraa kàtɛ í pìi sarɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isarailanↄ fùtɛ Ɛlimu ń pínki, akũ ò kà Sini gbáranna kũ à kú Ɛlimu kũ Sinaio dagura ń bona Misila mↄ plade gũn gↄrↄ gɛ̃rode zĩ. ");
INSERT INTO bqp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Akũ ò zuka kà Musai kũ Harunao gbárannan gwe ń pínki ");
INSERT INTO bqp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ò pìńnɛ: Bↄ́ yã mɛ́ à tò Dikiri dí ó dɛdɛ Misilaroo? Gwe odì vutɛ ò pↄ́ ble kũ nↄ̀bↄↄo ari ò kã, akũ a su kũoo gbárannan kũ à ó dɛdɛ kũ nàao. ");
INSERT INTO bqp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Dikiri pì Musanɛ: Bona musu mani pↄ́ble fãárɛ. Gbɛ̃nↄ ni bↄtɛ ò gↄrↄ do pↄ́ sɛ́tɛ lákũ gu dìgↄ̃ dↄ nà ń blena lɛ́n, de mà ń yↄ̃ mà gwa tó ò ma doka kũna. ");
INSERT INTO bqp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Gↄrↄ suddode zĩ gↄrↄ pla pↄ́n oni sɛ́tɛ ò a pↄ́ble kɛ. ");
INSERT INTO bqp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Akũ Musa kũ Harunao pìńnɛ ń pínki: Ɔkↄsiala áni dↄ̃ kũ Dikiri mɛ́ à á bↄ́tɛ Misila, ");
INSERT INTO bqp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","zia kↄnkↄ áni Dikiri gakuri e. À zuka kũ a kàai mà. Bↄ́n ó ũ kũ áni gbasa a zuka kàwáii? ");
INSERT INTO bqp_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa ɛ̀ra à pì: Dikiri ni á gba nↄ̀bↄↄ à só ↄkↄsiala, zia kↄnkↄ ani pↄ́ble kpááwa á blena lɛ́n, kũ à zuka kũ á kàai mà yãi. Pↄ́ken ó ũro. Adi kɛ ókↄ̃nↄ a zuka kàwáiro, Dikirimɛ. ");
INSERT INTO bqp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Akũ Musa pì Harunanɛ: Ǹ o Isarailanↄnɛ ń pínki ò na Dikirii, zaakũ à ń zukakanaa mà. ");
INSERT INTO bqp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kũ Haruna tɛn yã ońnɛ, ò arɛ dↄ̀ gbáranna kpa, akũ ò è Dikiri gakuri bò à sùḿma tɛ́luku gũn. ");
INSERT INTO bqp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Akũ Dikiri yã ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ma Isarailanↄ zukakanaa mà. Ǹ ońnɛ ↄkↄsiala oni nↄ̀bↄ só, zia kↄnkↄ oni pↄ́ ble ò kã, oni dↄ̃ kũ makũmɛ Dikiri ń Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ɔkↄsi kpɛkpɛrɛwinↄ sù ò dà ń bùrala. Kũ gu dↄ̀ plí kpà à lìkańyĩ. ");
INSERT INTO bqp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kũ plí kɛ̃̀, akũ pↄ́ gↄ̃̀ katɛna zĩtɛ púu ketekete lán pↄ́ koto bà. ");
INSERT INTO bqp_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kũ Isarailanↄ è, ò pìkↄ̃nɛ: Bↄ́n díi? Zaakũ odi dↄ̃ pↄ́ kũ à de a ũro. Musa pìńnɛ: Pↄ́ kũ Dikiri kpàáwa à blen gwe. ");
INSERT INTO bqp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yã kũ Dikiri dìtɛárɛn dí: Á baadi sɛ́tɛ a blena lɛ́n. À sɛ́tɛ á baadi zaka lɛ́ dodo á ↄndenↄ dasi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isarailanↄ kɛ̀ lɛ. Ò sɛ̀tɛ, gbɛ̃kenↄ pↄ́ zↄ̃kↄ̃, gbɛ̃kenↄ pↄ́ fíti. ");
INSERT INTO bqp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kũ ò zakaa dàn, gbɛ̃ kũ à sɛ̀tɛ zↄ̃kↄ̃ pↄ́ dí dialaro, gbɛ̃ kũ à sɛ̀tɛ fíti pↄ́ dí kĩaaro. ");
INSERT INTO bqp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa pìńnɛ: Gbɛ̃ke sún a kpara tó ari gudↄoro. ");
INSERT INTO bqp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Gbɛ̃kenↄ dí Musa yã maro, ò a kpara tò ari gu dↄ̀, akũ à kↄ̀kↄↄ kà à vã̀, akũ Musa pↄ fɛ̃̀ gbɛ̃ pìnↄi. ");
INSERT INTO bqp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lákũ gu dìgↄ̃ dↄ nà baadi dì sɛ́tɛ a blena lɛ́n. Tó ifãntɛ̃ gbã̀, pↄ́ kũ à gↄ̃̀ zĩtɛ dì yↄ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Gↄrↄ suddode zĩ ò pↄ́ble sɛ̀tɛ lɛu pla, baadi zaka lɛ́ plapla. Akũ ń gbɛ̃ zↄ̃kↄ̃nↄ gɛ̀ɛ ò ò Musanɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","À pìńnɛ: Lɛn Dikiri dìtɛ lɛ. Zia bi kámmabogↄrↄ zĩmɛ, Dikiri gↄrↄmɛ. À pↄ́ kũ á ye à kpá tɛ́a kpá tɛ́a. À pↄ́ kũ á ye à disa disa, à a kpara kũ à gↄ̃̀ ditɛ ari gu dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ò dìtɛ ari gu dↄ̀ lákũ Musa ò nà. Adikũ dí vãro adi kↄ̀kↄ káro. ");
INSERT INTO bqp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Akũ Musa pìńnɛ: À ble gbãra, zaakũ kámmabogↄrↄ zĩmɛ, áni e gukea gbãraro. ");
INSERT INTO bqp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Àgↄ̃ sɛ́tɛ ari gↄrↄ suddo. A gↄrↄ supplade bi kámmabogↄrↄ zĩmɛ, anigↄ̃ kun zĩ kũ̀aro. ");
INSERT INTO bqp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Gↄrↄ supplade zĩ gbɛ̃kenↄ bò ò gɛ̀ɛ sɛ́tɛ, akũ odi lero. ");
INSERT INTO bqp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Akũ Dikiri pì Musanɛ: Ánigↄ̃ kú kũ doka kũ ma dìtɛnↄ manaa sario ari bↄrɛmɛɛ? ");
INSERT INTO bqp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Àgↄ̃ dↄ̃ kũ makũ Dikiri ma kámmabogↄrↄ dìtɛárɛ. A yã mɛ́ à tò gↄrↄ suddode zĩ madì gↄrↄ pla pↄ́ble kpááwa. Baadi gↄ̃ kú a gbɛ̀n, gbɛ̃ke sún bo gu kũ à kun gↄrↄ supplade pì zĩro. ");
INSERT INTO bqp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Akũ ò kámma bò gↄrↄ supplade zĩ. ");
INSERT INTO bqp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isarailanↄ tↄ́ kpà pↄ́ble pìinɛ mana. À de lán pↄ́wɛ pura keteketenↄ bàmɛ. A í nna lán kàra zↄ́de bà. ");
INSERT INTO bqp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa pì: Yã kũ Dikiri dìtɛn dí: Ò mana zaka lɛ́ do ditɛ ó burinↄnɛ, de ò pↄ́ble kũ à kpàwá o blè gbárannan ó bona Misila gbɛra e se. ");
INSERT INTO bqp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Akũ Musa pì Harunanɛ: Ǹ lo sɛ́ ǹ mana zaka lɛ́ do kán ǹ ditɛ Dikiri arɛ, de àgↄ̃ ditɛna ó burinↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Akũ Haruna dìtɛ gbɛ̀ anlonↄ sarɛ de àgↄ̃ ditɛna lákũ Dikiri ò Musanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isarailanↄ mana blè wɛ̃̀ bupla ari ò gɛ̀ɛ ò kào bùsu kũ gbɛ̃nↄn kún. Ò mana pìi blè ari ò gɛ̀ɛ ò kào Kanaanↄ bùsu lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Zaka lɛ́ do bi lita plamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isarailanↄ fùtɛ Sini gbárannan ń pínki, òtɛn bùra kátɛkatɛ lákũ Dikiri òńnɛ nà, akũ ò gɛ̀ɛ ò bùraa kàtɛ Rɛfidimu. Odi í le ò mì gwero, ");
INSERT INTO bqp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","akũ ò zuka kà Musai ò pì: Ǹ ó gba í ò mi. À pìńnɛ: Bↄ́yãi átɛn lɛ́kpakↄ̃ana kɛ kũmaoo? A kɛ̀ dera átɛn Dikiri lɛ́ à gwaa? ");
INSERT INTO bqp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kũ ími tɛni ń dɛ, akũ ò zuka kà Musai ò pì: Bↄ́yãi n bo kũoo Misilai? Ń ye ími ó dɛ kũ ó nɛ́nↄ kũ ó pↄ́kãdenↄon yá? ");
INSERT INTO bqp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Akũ Musa wiki lɛ̀ Dikiria à pì: Deran mani kɛ kũ gbɛ̃ pìnↄ nàa? À gↄ̃̀ fíti kũ oni ma pápa kũ gbɛ̀ɛo ò ma dɛ. ");
INSERT INTO bqp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Dikiri pìnɛ: Ǹ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ sɛ́tɛ à do gbɛ̃ pìnↄnɛ arɛ. Ǹ n gò kũ n Nili lɛ̀o sɛ́ dↄ. ");
INSERT INTO bqp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mani zɛ n arɛ Orɛbu gbɛ̀si sarɛ gwe. Ǹ gbɛ̀si pì lɛ́, í ni bo de ò mi. Akũ Musa kɛ̀ lɛ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ wára. ");
INSERT INTO bqp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Akũ ò tↄ́ kpà gu pìinɛ Masa, zaakũ gwen ò Dikiri lɛ̀n ò gwà ò pì: Dikiri kú kũoomɛ gwe yá? Ò tↄ́ kpànɛ Mɛriba dↄ, kũ Isarailanↄ zuka kà gwe yãi. ");
INSERT INTO bqp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalɛkinↄ sù zĩ̀ ká kũ Isarailanↄ Rɛfidimu. ");
INSERT INTO bqp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Akũ Musa pì Yↄsuanɛ: Ǹ gbɛ̃nↄ sɛ́ ó tɛ́ à gɛ́ zĩ̀ ká kũ Amalɛkinↄ. Zia manigↄ̃ zɛna sĩ̀sĩ dí mìsↄ̃ntɛa kũ Luda gòoo kũna. ");
INSERT INTO bqp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yↄsua kɛ̀ lákũ Musa ònɛ nà, à gɛ̀ɛ zĩ̀ ká kũ Amalɛkinↄ. Akũ Musa kũ Harunao kũ Uruo dìdi sĩ̀sĩi pìi mìsↄ̃ntɛa. ");
INSERT INTO bqp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tó Musa a ↄnↄ sɛ̀, Isarailanↄ dìgↄ̃ zĩ̀ ble Amalɛkinↄamɛ, ama tó à a ↄnↄ dìtɛ sↄ̃, Amalɛkinↄ dìgↄ̃ zĩ̀ ble Isarailanↄa. ");
INSERT INTO bqp_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kũ Musa ↄnↄ wã̀, ò gbɛ̀ɛ sɛ̀ ò dìtɛ a gbáru à vùtɛa, akũ Haruna kũ Uruo a ↄnↄ kũkũna, gbɛ̃ do ↄplai, gbɛ̃ do ↄzɛi, akũ a ↄnↄ gↄ̃̀ zɛna ari ifãntɛ̃ gɛ̀ɛ à gɛ̃̀o kpɛ́n. ");
INSERT INTO bqp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Akũ Yↄsua zĩ̀i blè Amalɛkinↄa à ń dɛdɛ kũ fɛ̃nɛdao. ");
INSERT INTO bqp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Dikiri pì Musanɛ: Ǹ adikĩna kɛ̃ takada gũn de àgↄ̃ de dↄngu pↄ́ ũ ǹ o Yↄsuanɛ, zaakũ mani Amalɛkinↄ buri bo andunia gũn ń pínki. ");
INSERT INTO bqp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa gbagbaki bò, akũ à tↄ́ kpànɛ Dikirimɛ ma tuta ũ ");
INSERT INTO bqp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","à pì: Ma ↄ sɛ̀ Dikiri kpata kpa. Dikiri nigↄ̃ zĩ̀ ká kũ Amalɛkinↄ gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Musa anzure Yɛtoro, Midiã sa'ori, yã kũ Luda kɛ̀ Musanɛ kũ a gbɛ̃ Isarailanↄ mà, lákũ Dikiri ń bↄ́tɛ Misila nà. ");
INSERT INTO bqp_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","À sù à lè Musa gĩnakɛ à a nanↄ Zipora zĩ̀ bɛ ");
INSERT INTO bqp_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","kũ a nɛ́gↄ̃gbɛ̃ mɛ̀n planↄ. A do tↄ́n Gɛsↄmu, zaakũ Musa pì gbɛ̃ zĩ̀tↄn a ũ dakenↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","A do tↄ́n Ɛliɛza, zaakũ Musa pì a de Luda a faaba kɛ̀ à a bo Firi'auna fɛ̃nɛda lɛ́i. ");
INSERT INTO bqp_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Akũ Yɛtoro fùtɛ àtɛn su Musa kĩnaa kũ a nɛ́nↄ kũ a nanↄo gu kũ à bùraa kàtɛn Luda kpi sarɛ gbárannan. ");
INSERT INTO bqp_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","À lɛ́gbãzã kɛ̀ Musanɛ à pì: Matɛn su n kĩnaa kũ n nanↄo kũ n nɛ́ mɛ̀n planↄo. ");
INSERT INTO bqp_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa bò à gɛ̀ɛ à dà a anzurelɛ à kùtɛ à lɛ́ pɛ̀a. Ò kↄ̃ aafiaa gbɛ̀ka, akũ ò gɛ̃̀ kpɛ́n. ");
INSERT INTO bqp_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa yã kũ Dikiri kɛ̀ Firi'aunanɛ kũ Misilanↄ Isarailanↄ yãi bàbanɛ pínki kũ wari kũ à ń lé zɛ́ gũnnↄ pínki kũ lákũ Dikiri ń bó nào. ");
INSERT INTO bqp_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yɛtoro pↄ kɛ̀ nna yã mana kũ Dikiri kɛ̀ Isarailanↄnɛɛa pínki kũ lákũ à ń bó Misilanↄ ↄĩ nào. ");
INSERT INTO bqp_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Akũ à pì: Ò Dikiri sáabu kpá lákũ à á bó Firi'auna kũ Misilanↄ ↄĩ nà. ");
INSERT INTO bqp_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Má dↄ̃̀ sà kũ Dikiri zↄ̃kↄ̃ de tãnanↄla ń pínki. Kũ Misilanↄ ĩa dã̀áwa, à yã mↄ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Akũ Yɛtoro sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ ò Ludaa kũ sa'opↄ pãndenↄ dↄ. Akũ Haruna kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ ń pínki ò sù ò pↄ́ blè kãao Luda arɛ. ");
INSERT INTO bqp_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kũ gu dↄ̀ Musa vùtɛ àtɛn yã gↄ̃gↄ̃ńnɛ, ò katɛnai zaa kↄnkↄ ari ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kũ Musa anzure yã kũ àtɛn kɛńnɛ è pínki, akũ à a là à pì: Bↄ́n ntɛn kɛ kũ gbɛ̃ dínↄ lɛɛ? Bↄ́yãi ntɛn yãkpatɛ kɛńnɛ ndo, gbɛ̃ sĩnda pínki katɛnanyĩ zaa kↄnkↄ ari ↄkↄsii? ");
INSERT INTO bqp_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa wèa à pì: Gbɛ̃nↄ dì su ma kĩnaa ò Luda pↄyenyĩna yã mamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tó ò yãkete vĩ, òdi su ma kĩnaa mà yã pì gↄ̃gↄ̃ńnɛ mà Luda doka kũ à dìtɛnↄ ońnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musa anzure pìnɛ: Yã kũ ntɛn kɛ manaro. ");
INSERT INTO bqp_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ĩni kpasa, gbɛ̃ kũ ò kú kũnwonↄ ni kpasa dↄ, zaakũ zĩ pì denla, ĩni fↄ̃ ǹ kɛ ndoro. ");
INSERT INTO bqp_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ǹ ma yã ma sà, mani lɛ́ damma, Luda nigↄ̃ kú kũnwo. Ĩnigↄ̃ deńnɛ yãgↄ̃gↄ̃ri ũ, ĩnigↄ̃ gɛ́ kũ ń yãnↄ Luda kĩnaa, ");
INSERT INTO bqp_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ĩnigↄ̃ doka kũ Luda dìtɛnↄ dańnɛ, ĩnigↄ̃ zɛ́ kũ à de ò sɛ́ mↄńnɛ kũ yã kũ oni kɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ǹ gbɛ̃ laakaride náanide kũ ò Luda vĩna vĩ akũ òdi gusarɛgba síronↄ sɛ́ ń tɛ́, ǹ ń ditɛ gbɛ̃nↄn wàa sↄsↄↄronↄ don'arɛdenↄ ũ kũ gbɛ̃nↄn basↄsↄↄroo kũ gbɛ̃nↄn bupla akurio kũ gbɛ̃nↄn kurikurio, ");
INSERT INTO bqp_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","de ògↄ̃ yã gↄ̃gↄ̃ gbɛ̃ pìnↄnɛ gↄrↄ sĩnda pínki. Oni su n kĩnaa kũ yã zĩ'ũnↄ pínki, ama oni yã fítinnanↄ gↄ̃gↄ̃ ń zĩda. Abire mɛ́ ani n aso lagonnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Tó Dikiri wènnɛ, tó n kɛ̀ lɛ, ĩni fuaro, gbɛ̃ pìnↄ ni tá bɛ kũ laakariio kpatɛna. ");
INSERT INTO bqp_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa a anzure yã mà à kɛ̀ lákũ à òarɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","À gbɛ̃ laakaridenↄ sɛ̀ Isaraila burinↄ tɛ́ pínki à ń dítɛ gbɛ̃nↄn wàa sↄsↄↄronↄ don'arɛdenↄ ũ kũ gbɛ̃nↄn basↄsↄↄroo kũ gbɛ̃nↄn bupla akurio kũ gbɛ̃nↄn kurikurio. ");
INSERT INTO bqp_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Akũ òdigↄ̃ yã gↄ̃gↄ̃ńnɛ gↄrↄ sĩnda pínki. Yã zĩ'ũn òdi suo Musa kĩnaa, akũ òdi yã fítinnanↄ gↄ̃gↄ̃ ń zĩda. ");
INSERT INTO bqp_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Musa gɛ̀ɛ à zɛ̀ a anzureenɛ, akũ à tà a bùsun. ");
INSERT INTO bqp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isarailanↄ bona Misila mↄ aakↄ̃de gũn ");
INSERT INTO bqp_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ò fùtɛ Rɛfidimu. Kũ ò kà Sinai gbárannan, akũ ò bùraa kàtɛ gwe Sinai kpi sarɛ. ");
INSERT INTO bqp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa dìdi à gɛ̀ɛ Luda kĩnaa kpi pìi musu, akũ Dikiri lɛ́ zùi à pì: Ǹ yã dí o Yakubu buri Isarailanↄnɛ: ");
INSERT INTO bqp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","A è lákũ ma kɛ̀ Misilanↄnɛ nà, lákũ ma á sɛ́ ma su kãáo ma kĩnaa, lákũ vãu dì a nɛ́ sɛ́ a dɛ̀mbɛrɛɛa nà. ");
INSERT INTO bqp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tó a ma yã mà á ma bàka kunna kãáo yã kũna tera sà, anigↄ̃ de ma gbɛ̃ yenyĩdenↄ ũ buri sĩnda pínki tɛ́. Bee kũ andunia de ma pↄ́ ũ pínki, ");
INSERT INTO bqp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ánigↄ̃ demɛnɛ kínanↄ kũ sa'orinↄ ũ, ma gbɛ̃ kũ ò kú adonanↄ ũ. Yã kũ ĩni o Isarailanↄnɛɛn gwe. ");
INSERT INTO bqp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa kìpa à gbɛ̃ zↄ̃kↄ̃nↄ sìsi, akũ à yã kũ Dikiri ònɛɛ bàbańnɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Gbɛ̃nↄ wèa ń pínki ò pì: Yã kũ Dikiri òwɛrɛ pínki óni kɛ. Akũ Musa gɛ̀ɛ à yã kũ ò òo bàba Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Dikiri pìnɛ: Mani su n kĩnaa túsukpɛ gègetee gũn, de gↄrↄ kũ matɛn yã onnɛ, oni ma onigↄ̃ n náani vĩ gↄrↄ sĩnda pínki. Akũ Musa yã kũ gbɛ̃nↄ òo bàba Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Akũ Dikiri pìnɛ: Ǹ gɛ́ ń kĩnaa ǹ ońnɛ ò gbã̀ bo ń zĩdanɛ gbãra kũ ziao, ò ń pↄ́kasanↄ pípi. ");
INSERT INTO bqp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ògↄ̃ kú soru gũn ziando, zaakũ a gↄrↄ aakↄ̃de zĩn mani kipa mà zɛ Sinai kpi musu gbɛ̃ sĩnda pínki wára. ");
INSERT INTO bqp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ǹ zĩtɛ lɛ́ sèeda dańnɛ kpi pìi pↄ̀rↄ lɛ́a ari à lìkai pínki. Ǹ ońnɛ ò laakari kɛ. Òsun didi kpi pìiaro. Ń gbɛ̃ke sún ↄ kɛa sero. Gbɛ̃ kũ à ↄ kɛ̀a, ò ade dɛ. ");
INSERT INTO bqp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Òsun ↄ kɛ adearo. Ò a pápa kũ gbɛ̀ɛo ke ò a pápa kũ kàao ò dɛ. Pↄ́kãden yá, bisãsirin yá, à gàmɛ. Tó ò mà ò kuru pɛ̀ ò a yĩsãm pà, ò na kpi pìii. ");
INSERT INTO bqp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa kìpa kpi pìia à sù à gbɛ̃nↄ lè à òńnɛ ò gbã̀ bo ń zĩdanɛ ò ń pↄ́kasanↄ pípi. ");
INSERT INTO bqp_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","À ɛ̀ra à pìńnɛ: Àgↄ̃ kú soru gũn gↄrↄ aakↄ̃de zĩ yãi. Àsun wútɛ kũ nↄgbɛ̃oro. ");
INSERT INTO bqp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kũ gu dↄ̀ a gↄrↄ aakↄ̃de pìia, akũ legũ tɛn pũtã àtɛn pí, akũ legũ sìsi kpi musu. Kũ ò kuru yĩsãmpanaa mà, akũ vĩna gbɛ̃ kũ ò kú bùrannↄ kũ̀ ń pínki òtɛn lukaluka. ");
INSERT INTO bqp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa bò kũńwo bùran à gɛ̀ɛ kũńwo Luda kĩnaa, akũ ò zɛ̀ zĩtɛ kpi pìi sarɛ. ");
INSERT INTO bqp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Túsukpɛ dà Sinai kpila kũ Dikiri kìpaa kũ tɛ́o yãi. Túsukpɛ pìi fùtɛ lán tãma túsukpɛ bà, akũ kpi pì tɛn yĩgãyĩgã manamana. ");
INSERT INTO bqp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kuru yĩsãmpana tɛn kara. Kũ Musa yã ò, akũ Luda wèa legũpũtãnaa gũn. ");
INSERT INTO bqp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Dikiri kìpa à zɛ̀ Sinai kpi mìsↄ̃ntɛa à Musa sìsi, akũ à dìdi à gɛ̀ɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Dikiri pìnɛ: Ǹ kipa ǹ kpãkɛ̃ gbɛ̃nↄi, òsun vĩ gulɛzɛkila ò su ò ma gwaro, de ń paridenↄ sún gagaro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Bee sa'ori kũ òdi namainↄ, ò gbã̀ bo ń zĩdanɛ de màsun fɛ̃ńyĩro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa pì Dikirinɛ: Oni didiro, zaakũ n kpãkɛ̃wái n pì ò zĩtɛ lɛ́ sèeda da kpi pìi pↄ̀rↄ lɛ́a à gↄ̃ n pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Akũ Dikiri pìnɛ: Ǹ kipa ǹ Haruna sɛ́ ǹ su kãao, ama sa'orinↄ kũ gbɛ̃ kparanↄ sún vĩ bara ò su ma kĩnaaro de màsun fɛ̃ńyĩro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Akũ Musa kìpa gbɛ̃ pìnↄ kĩnaa à yã pìi òńnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Luda yã díkĩna ò pínki à pì: ");
INSERT INTO bqp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Makũmɛ Dikiri á Luda ũ. Ma á bↄ́tɛ zↄ̀blen Misila. ");
INSERT INTO bqp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Àsungↄ̃ dikiri ke vĩ ma gbɛraro. ");
INSERT INTO bqp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","5","Àsun pↄ́ke taka kɛ à kútɛ à donyĩ kɛnɛro, pↄ́ kũ à kú musu ke zĩtɛ ke í gũnn yá, zaakũ makũ Dikiri á Luda, nɛ̀sɛgↄ̃bademɛ ma ũ. Madì gbɛ̃ kũ à yemaironↄ yã vãni wí ń burinↄ musu ari à gɛ́ pɛ́ ń sãkpɛnↄa kũ ń nasionↄ. ");
INSERT INTO bqp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Gbɛ̃ kũ ò yemai ò ma dokayãnↄ kũnanↄ sↄ̃, madìgↄ̃ gbɛ̃kɛ vĩ kũńwomɛ ari ń buria. ");
INSERT INTO bqp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Àsun makũ Dikiri á Luda tↄ́ sí pãpãro, zaakũ gbɛ̃ kũ à ma tↄ́ sì pãpã mani tó à bo pãro. ");
INSERT INTO bqp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Àgↄ̃ dↄn kámmabogↄrↄ bi ma pↄ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Àgↄ̃ á bura zĩ kũ á zĩ sĩnda pínkio kɛ gↄrↄ suddo, ");
INSERT INTO bqp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","a supplade gↄ̃ deárɛ kámmabogↄrↄ ũ, zaakũ makũ Dikiri á Luda ma pↄ́mɛ. Àsun zĩ ke kɛ gↄrↄ pì zĩro, ákↄ̃nↄ ke á nɛ́gↄ̃gbɛ̃ ke á nɛ́nↄgbɛ̃ ke á zĩkɛri gↄ̃gbɛ̃ ke nↄgbɛ̃ ke á pↄ́kãde ke nibↄ kũ à kú á bɛa. ");
INSERT INTO bqp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Zaakũ gↄrↄ suddon ma musu kũ zĩtɛo kɛ̀ kũ ísirao kũ pↄ́ kũ ò kú ń gũnnↄ pínki, akũ ma kámma bò a gↄrↄ supplade zĩ. A yã mɛ́ à tò ma arubarikaa dà kámmabogↄrↄ pìn ma dìtɛ ma pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Àgↄ̃ á de kũ á dao bɛ̀ɛrɛ dↄ̃, de à gì kɛ bùsu kũ makũ Dikiri á Luda matɛn kpááwan. ");
INSERT INTO bqp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Àsun gbɛ̃ dɛro. ");
INSERT INTO bqp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Àsun zina kɛro. ");
INSERT INTO bqp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Àsun kpãni oro. ");
INSERT INTO bqp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Àsun yã dí á gbɛ̃dakearo. ");
INSERT INTO bqp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Àsun á gbɛ̃dake ↄn ni dɛro. Àsun a nↄ ni dɛro ke a zĩkɛri gↄ̃gbɛ̃ ke nↄgbɛ̃ ke a zù ke a zaaki ke pↄ́ kũ à vĩnↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Gbɛ̃ sĩnda pínki legũpũtãnaa mà kũ kuru yĩsãmpanaao, ò legũpinaa è kũ túsukpɛo dↄ kpi musu, akũ vĩna ń kũ òtɛn lukaluka ò zɛ zã̀ dire. ");
INSERT INTO bqp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ò pì Musanɛ: Ǹ yã owɛrɛ n zĩda, óni ma. Ǹsun tó Luda yã owɛrɛro, de òsun gagaro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa pìńnɛ: Àsun tó vĩna á kũro, zaakũ kũ à á yↄ̃ à gwa yãin à sù, de àgↄ̃ a vĩna vĩ akũsↄ̃ àsun durunna kɛro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ò zɛ zã̀ dire, akũ Musa nà túsukpɛ gègetee pìii, gu kũ Luda kun pìn. ");
INSERT INTO bqp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Akũ Dikiri pì Musanɛ: Ǹ yã dí o Isarailanↄnɛ: A mà kũ á zĩdao lákũ ma yã òárɛ zaa musu nà. ");
INSERT INTO bqp_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Àsun tãna ke kɛ à namaro. Àsun andurufu ke wura pi tãnanↄ ũro. ");
INSERT INTO bqp_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","À ma gbagbaki bo kũ ɛ̃o à sa oa kũ sãnↄ kũ zùnↄ, sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ kũ kɛnnakũkↄ̃o sa'opↄo. Gu kũ ma dìtɛárɛ àgↄ̃ ma sísin, mani su á kĩnaa mà arubarika daágu. ");
INSERT INTO bqp_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tó átɛni ma gbagbaki pì bo kũ gbɛ̀ɛo, àsun bo kũ gbɛ̀ anaaoro, zaakũ tó a gã pɛ̀tɛa, a tò à gbã̀a lɛ̀n gwe. ");
INSERT INTO bqp_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Àsun ma gbagbaki bo à a didiki kɛro, de á pótompokɛ sún bo gbagbaki pìiaro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Àsun òpi baaru kpáro. Àsun zɛ kũ gbɛ̃ vãnio ɛ́kɛ sèedade ũro. ");
INSERT INTO bqp_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Àsun tɛ́ parii yãvãnikɛnaa gũnlo. Àsun zɛ kũ pario yãkpatɛ gũn à bo yãzɛde kpɛro. ");
INSERT INTO bqp_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tó takaside yã nnaro, àsun zɛ kãaoro. ");
INSERT INTO bqp_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Tó n ibɛrɛɛ zù ke a zaaki sã̀tɛ akũsↄ̃ n kpakũ kãao, ǹ a kũ ǹ gɛ́onɛ bɛ. ");
INSERT INTO bqp_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tó n n zãnguri zaaki è àtɛn fu asoa, ǹ kpái, ǹsun a tónlo. ");
INSERT INTO bqp_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Tó takaside yã nna, àsun bo a kpɛro. ");
INSERT INTO bqp_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","À kɛ zã̀ kũ manafikio. Àsun taarisaride ke gbɛ̃ mana dɛro, zaakũ mani tó taaride bo pãro. ");
INSERT INTO bqp_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Àsun gusarɛgba síro, zaakũ gusarɛgba dì tó wɛ́denↄ vĩna kũmɛ, akũsↄ̃ àdi gbɛ̃ mananↄ yã litɛ kpɛdangara. ");
INSERT INTO bqp_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Àsun bòasu wɛ́ tãro. Á bòasukɛ dↄ̃, zaakũ bòasunↄn á ũ yã Misila. ");
INSERT INTO bqp_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Àgↄ̃ pↄ́ tↄ̃ á buranↄa à kɛkɛ ari wɛ̃̀ suddo, ");
INSERT INTO bqp_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","a wɛ̃̀ suppladen à tó zĩtɛ kámma bo à ĩam pá, de á takasidenↄ le ò a zã̀ kũ à bùtɛ gwenↄ kↄ̃nↄ wɛ, nↄ̀bↄsɛ̃ntɛnↄ le ò a kpara só. À kɛ lɛ dↄ kũ á geepi búo kũ á kùkpɛo. ");
INSERT INTO bqp_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Àgↄ̃ zĩ kɛ ari gↄrↄ suddo, a suppladen àgↄ̃ kámma bo, de á zùnↄ kũ á zaakinↄ le ò kámma bo, akũsↄ̃ á zↄ̀nↄ kũ bòasunↄ ni le ò ĩam pá. ");
INSERT INTO bqp_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Àgↄ̃ yã kũ ma òárɛnↄ kũna pínki. Àsun tãnanↄ tↄ́ síro. Òsun ń tↄ́ ma á lɛ́n sero. ");
INSERT INTO bqp_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Wɛ̃̀ kũ wɛ̃̀ɛo àgↄ̃ su dikpɛ kɛmɛnɛ gɛ̃̀n aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Àgↄ̃ Burodi Futɛnasari dikpɛ kɛ lákũ ma dìtɛárɛ nà, àgↄ̃ burodi futɛnasari só ari gↄrↄ suppla mↄ kũ òdi pi Abibu gũn a gↄrↄa, zaakũ mↄ pìi gũnn a bↄtɛn Misila. Gbɛ̃ke sún su ma kĩnaa ↄkoriro. ");
INSERT INTO bqp_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Àgↄ̃ Pↄ́kɛ̃na dikpɛ kɛ gↄrↄ kũ a na pↄ́kɛ̃naaa, à á burapↄ káakunↄ kpáma. Àgↄ̃ Pↄ́dufublena dikpɛ kɛ wɛ̃̀ lakanaaa, gↄrↄ kũ a á burapↄnↄ kàkara pínki. ");
INSERT INTO bqp_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Wɛ̃̀ kũ wɛ̃̀ɛo gɛ̃̀n aakↄ̃ á gↄ̃gbɛ̃ sĩnda pínki su kↄ̃kakarana kɛ makũ Dikiri á Luda arɛ. ");
INSERT INTO bqp_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Àsun pↄ́futɛna kpáma lɛɛlɛ kũ sa'opↄ aruoro. Àsun dikpɛ sa'opↄ nísi ditɛ gu dↄaro. ");
INSERT INTO bqp_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Àgↄ̃ gɛ́ ma Dikiri á Luda ↄnn kũ á burapↄ káakunↄo. Àsun blènɛ nↄ̀bↄ kuku kũ a da yↄ̃'ioro. ");
INSERT INTO bqp_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mani malaika gbarɛ à doárɛ arɛ à á dãkpã zɛ́n à ká kãáo gu kũ ma kɛ̀kɛn. ");
INSERT INTO bqp_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","À laakari dↄ a yãa à a yã ma. Àsun bo a kpɛro, zaakũ ani sùru kɛ kãáo á taari yã musuro kũ ma tↄ́ kúa yãi. ");
INSERT INTO bqp_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tó a a yã mà akũsↄ̃ a yã kũ ma òárɛ kɛ̀ pínki, manigↄ̃ de á ibɛrɛnↄ ibɛrɛ ũmɛ, á wɛtɛrinↄ wɛtɛri ũ. ");
INSERT INTO bqp_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ma malaika pì ni doárɛ arɛ à gɛ́ zɛárɛ bùsu kũ Amↄrinↄn kun kũ Itinↄ kũ Pɛrizinↄ kũ Kanaanↄ kũ Ivinↄ kũ Yebusinↄo, mani ń kakatɛ. ");
INSERT INTO bqp_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Àsun kútɛ ń tãnanↄnɛ à dońyĩro, àsun ń kɛna kɛro. À ń gboro à ń gbɛ̀nↄ wíwi. ");
INSERT INTO bqp_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","À dↄ Dikiri á Ludai, ani arubarika daárɛ á pↄ́blen kũ á pↄ́minaao, ani gyãnↄ kɛ̃áwa. ");
INSERT INTO bqp_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nↄgbɛ̃nↄ ni nↄ̀ bↄtɛ á bùsunlo akũsↄ̃ para nigↄ̃ kunlo. Mani á wɛ̃̀ndi bà dↄárɛ kũ mↄ̀kakↄ̃anaao. ");
INSERT INTO bqp_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mani vĩna dada gbɛ̃ kũ ò kú á arɛnↄi, mani tó bídi gɛ̃ buri kũ a ka ń kĩnaanↄgu, mani tó á ibɛrɛnↄ kpɛ liárɛ. ");
INSERT INTO bqp_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mani zúmantɛ̃nↄ gbarɛ á arɛ ò ká Ivinↄgu kũ Kanaanↄ kũ Itinↄ ò pɛ́ḿmaárɛ. ");
INSERT INTO bqp_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Adi kɛ mani pɛ́ḿmaárɛ wɛ̃̀ do gũn gↄ̃̀nↄnlo, de bùsuu pì sún gↄ̃ lákpɛ ũ nↄ̀bↄsɛ̃ntɛnↄ daálaro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Manigↄ̃ pɛ́ḿmaárɛ busɛbusɛmɛ ari à kɛ dasi à ká à bùsu sí. ");
INSERT INTO bqp_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mani á bùsu lɛ́ daárɛ zaa Isira Tɛ̃ra lɛ́a ari Filisitininↄ Isira lɛ́a, zaa gbáranna lɛ́n ari Yuflati lɛ́a. Mani bùsupidenↄ naárɛ á ↄĩ à pɛ́ḿma. ");
INSERT INTO bqp_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Á bàka súngↄ̃ kú ń yãn ke ń tãnanↄ yãnlo. ");
INSERT INTO bqp_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Àsun tó ògↄ̃ kú á bùsunlo, de òsun tó à durunna kɛmɛnɛro, zaakũ tó a ń tãnanↄ gbàgba, a tankutɛ kpàkpa á zĩdanɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Dikiri pì Musanɛ: Mↄkↄ̃n kũ Harunao kũ Nadabuo kũ Abiuo kũ Isaraila gbɛ̃ zↄ̃kↄ̃ gbɛ̃nↄn baaakↄ̃ akurinↄ, à didi kpia à mↄ́ ma kĩnaa, à donyĩ kɛmɛnɛ zaa zã̀. ");
INSERT INTO bqp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mↄkↄ̃mmɛ ĩni namai ndo, gbɛ̃ kparanↄ sún su kãniro akũsↄ̃ pari sún didi kũńwo kpi díkĩna musuro. ");
INSERT INTO bqp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa gɛ̀ɛ à yã kũ Dikiri òo gbã̀ńnɛ pínki kũ dokayãnↄ pínki. Ò wè lɛɛlɛ ń pínki ò pì: Yã kũ Dikiri ò pínki óni kɛ. ");
INSERT INTO bqp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Akũ Musa yã kũ Dikiri òo pìnↄ kɛ̃̀ takada gũn pínki. À fùtɛ kↄnkↄkↄnkↄ à gbagbaki bò kpigɛrɛɛi, akũ à gbɛ̀ɛ pɛ̀tɛpɛtɛ mɛ̀n kuri awɛɛpla Isaraila buri mɛ̀n kuri awɛɛplanↄ pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","À Isaraila kɛfɛnnanↄ zĩ̀ kũ zùsanɛnↄ, akũ ò sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ òo Dikiria kũ sáabukpana sa'opↄnↄ. ");
INSERT INTO bqp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Akũ Musa zùu pìnↄ aru sì à kpàatɛ lɛu pla. À a lɛu do dìtɛ kũ tao à a lɛu do àtɛ̃ gbagbakia. ");
INSERT INTO bqp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Akũ à Dikiri bàka kunna kũńwo takada sɛ̀ à a kyó kɛ̀ńnɛ. Akũ ò pì: Yã kũ Dikiri ò pínki óni kɛ óni mì natɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Akũ à aru pìi sɛ̀ à fã̀ḿma à pì: Dikiri bàka kunna kãáo arun gwe lákũ a mà nà pínki. ");
INSERT INTO bqp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa kũ Harunao kũ Nadabuo kũ Abiuo kũ Isaraila gbɛ̃ zↄ̃kↄ̃ gbɛ̃nↄn baaakↄ̃ akurinↄ dìdi kpia. ");
INSERT INTO bqp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ò Isarailanↄ Luda è. Safia gbɛ̀ gusara katɛna a gbá gɛ̃i, a í de búgu swáswa lán ludambɛ búgu bà. ");
INSERT INTO bqp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Luda dí yãke kɛ Isaraila gbãnade pìnↄnɛro. Ò wɛ́ sìalɛ, akũ ò pↄ́ blè ò í mì. ");
INSERT INTO bqp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Dikiri pì Musanɛ: Ǹ didi kpia ǹ mↄ́ ma kĩnaa ǹgↄ̃ kú gwe. Mani gbɛ̀ anlo kũ ma a dokayãnↄ kɛ̃̀anↄ kpámma, de ǹ le ǹ dańnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Akũ à fùtɛ kũ a kpàasi Yↄsuao, òtɛn gɛ́ didi Luda kpia. ");
INSERT INTO bqp_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Akũ Musa pì gbɛ̃ zↄ̃kↄ̃nↄnɛ: Àgↄ̃ ó dã la, óni ɛra ò su á kĩnaa. Haruna kũ Uruo nigↄ̃ kú kãáo. Tó gbɛ̃ke yãke vĩ, à gɛ́o ń kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Akũ Musa dìdi kpi pìia. Túsukpɛ dà a mìsↄ̃ntɛla, ");
INSERT INTO bqp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","akũ Dikiri gakuri kìpa Sinai kpi pìia. Túsukpɛ pì daala lɛ ari gↄrↄ suddo, a gↄrↄ suppladen Dikiri lɛ́ zù Musai zaa túsukpɛ pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Isarailanↄ Dikiri gakuri è lán tɛ́ kũ àdi ń ble bà kpi pìi mìsↄ̃ntɛa. ");
INSERT INTO bqp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Akũ Musa gɛ̃̀ tɛ́luku pìi gũn à ɛ̀ra à dìdi kpi pìia. À kú gwe ari gↄrↄ bupla fãnantɛ̃ kũ gwãanio. ");
INSERT INTO bqp_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Dikiri yã ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ǹ ma! Ma Uri nɛ́ Bezalɛli, Uru daikore, Yuda buri sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ma tò ma Nini kúa, akũ à ↄ̃ndↄ̃ kũ gonio kũ dↄ̃naao lè ↄzĩ pínki gũn. ");
INSERT INTO bqp_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","À zãble pↄ́nↄa dↄ̃ kũ wuraao kũ andurufuuo kũ mↄ̀gotɛ̃o. ");
INSERT INTO bqp_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","À gbɛ̀ bɛ̀ɛrɛde ana dↄ̃ kũ a dana pↄ́ gũnwo kũ lí'anaao kũ ↄzĩ sĩnda pínkio. ");
INSERT INTO bqp_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Abire gbɛra ma Aisamaki nɛ́ Ɔↄliabu, Dã buri dìtɛ a kpanyĩri ũ. Ma ↄzĩkɛrinↄ gbà ↄ̃ndↄ̃ ń pínki, de ò le ò pↄ́ kũ ma dìtɛnnɛnↄ kɛ pínki: ");
INSERT INTO bqp_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Dakarɛki kuta kũ doka àkpatiio kũ a nɛ́kparɛo kũ kpɛ́ pì pↄ́ ketenↄ pínki, ");
INSERT INTO bqp_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","teburu kũ a pↄ́ ketenↄ, wura atɛ̃nɛ fitiladibↄ kũ a pↄ́ ketenↄ pínki, turaretitikpataki, ");
INSERT INTO bqp_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ oki kũ a pↄ́ ketenↄ pínki, dàga kũ a dibↄↄo, ");
INSERT INTO bqp_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pↄ́kasa kũ ò tã̀nↄ, sa'ori Haruna pↄ́kasa kũ ani naomainↄ kũ a nɛ́nↄ sa'opↄkasanↄ pínki, ");
INSERT INTO bqp_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","pↄ́ sakɛnísi kũ bizakuta turaretiti gbĩ nnannao. Ò pↄ́ pìnↄ kɛ lákũ ma dìtɛnnɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Dikiri yã ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Ǹ o Isarailanↄnɛ ò kámmabogↄrↄ kũ ma dìtɛ yã da, zaakũ à de sèeda ũ makũ kũ ákↄ̃nↄ dagura ari á buria, de à le à dↄ̃ makũ Dikiri ma á sɛ́ ma gbɛ̃nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Àgↄ̃ kámmabogↄrↄ pì yã da, zaakũ gↄrↄ pì kúárɛ adonamɛ. Gbɛ̃ kũ à gↄrↄ pìi tɛ̃̀ɛ kɛ̀, ade gàmɛ. Gbɛ̃ kũ à zĩ kɛ̀ gↄrↄ pìia, ò ade bo a gbɛ̃nↄ tɛ́ ò a dɛ. ");
INSERT INTO bqp_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Àgↄ̃ zĩ kɛ gↄrↄ suddo, a gↄrↄ suppladen áni kámma bo, zaakũ makũ Dikiri ma pↄ́mɛ. Gbɛ̃ kũ à zĩ kɛ̀ kámmabogↄrↄaa gàmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isarailanↄ gↄ̃ kámmabogↄrↄ pì yã kũna ò ditɛ gↄrↄ zↄ̃kↄ̃ ũ ari ń buria ma bàka kunna kũńwo yã ũ. ");
INSERT INTO bqp_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Anigↄ̃ de sèeda ũ makũ kũ Isarailanↄ dagura gↄrↄ sĩnda pínki, zaakũ makũ Dikiri ma musu kũ anduniao kɛ̀ gↄrↄ suddomɛ, akũ ma làka ma kámma bò a gↄrↄ supplade zĩ. ");
INSERT INTO bqp_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kũ Dikiri yã ò Musanɛ Sinai kpi musu à làka, akũ à dokayã kɛ̃̀ gbɛ̀ anlonↄa mɛ̀n pla kũ a zĩda ↄnɛo à kpàa. ");
INSERT INTO bqp_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kũ gbɛ̃nↄ è Musa dí kipa kpia likalikaro, ò kàkara Harunai ò pìnɛ: Ǹ futɛ ǹ tãna kenↄ kɛwɛrɛ ò dowɛrɛ arɛ, zaakũ Musa kũ à ó bↄ́tɛ Misila pìi, ó dↄ̃ yã kũ à a lèro. ");
INSERT INTO bqp_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Akũ Haruna pìńnɛ: À á nↄgbɛ̃nↄ wura pↄ́sãnↄ bↄtɛ kũ á nɛ́gↄ̃gbɛ̃nↄ pↄ́nↄ kũ á nɛ́nↄgbɛ̃nↄ pↄ́nↄ à suomɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Akũ ń pínki a wura pↄ́sãnↄ bòbo ò kpà Harunaa. ");
INSERT INTO bqp_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","À sì à kàsa lán zùsanɛ bà, akũ à lↄ̀lↄ. Akũ ò pì: Isarailanↄ, á tãnan di! Àkũ mɛ́ à á bↄ́tɛ Misila. ");
INSERT INTO bqp_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kũ Haruna è lɛ, à sa'oki bò zùu pì arɛ, akũ à kpàkpaa kɛ̀ à pì: Dikiri dikpɛ kun zia. ");
INSERT INTO bqp_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kũ gu dↄ̀, gbɛ̃nↄ fùtɛ ò sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ òa kũ kɛnnakũkↄ̃o sa'opↄo. Gbɛ̃nↄ vùtɛ òtɛn pↄ́ ble òtɛn í mi, akũ ò fùtɛ òtɛn pãpã kɛ. ");
INSERT INTO bqp_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Akũ Dikiri pì Musanɛ: Ǹ kipa ǹ gɛ́! N gbɛ̃ kũ n bo kũńwo Misilanↄ yàka. ");
INSERT INTO bqp_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ò kɛ̃̀ zɛ́ kũ ma mↄ̀ńnɛa likalika, ò wuraa kàsa tãna ũ lán zùsanɛ bà, ò kùtɛnɛ ò sa òa ò pì, Isarailanↄ tãna kũ à ń bↄ́tɛ Misilan gwe. ");
INSERT INTO bqp_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Akũ Dikiri ɛ̀ra à pì Musanɛ: Ma è gbɛ̃ pìnↄ sã gbãnamɛ. ");
INSERT INTO bqp_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ǹ gomala de mà a pↄfɛ̃ kipaḿma mà ń kakatɛ, ama mani n burinↄ kɛ dasi. ");
INSERT INTO bqp_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Akũ Musa kútɛ kɛ̀ Dikiri a Ludanɛ à pì: Dikiri, bↄ́yãin ntɛn pↄfɛ̃ kipa n gbɛ̃nↄa kũ n ń bↄ́tɛ Misila kũ n gbãna purao kũ n gã̀sã gbãnaoo? ");
INSERT INTO bqp_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Misilanↄ ni pi ń kakatɛna yãin n ń bↄ́tɛ, de ǹ le ǹ ń dɛdɛ kpinↄ musu ǹ ń láka andunia gũn. Ǹ n pↄfɛ̃ kpátɛ ǹ yã kũ ń ye ǹ kipa n gbɛ̃nↄaa pì bo n nɛ̀sɛn. ");
INSERT INTO bqp_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ǹ dↄ n zↄ̀blerinↄ Ibrahĩ kũ Isaakuo kũ Isarailao yãn, zaakũ n la dàńnɛ kũ n zĩdao n pì, ĩni ń buri kara lán susunɛnↄ bà, ĩni bùsu kũ n a yã òńnɛ kpá ń burinↄa ògↄ̃ vĩ gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Akũ Dikiri yã kũ à pì áni kipa a gbɛ̃nↄaa pìi bò a nɛ̀sɛn. ");
INSERT INTO bqp_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa ɛ̀ra à kìpa kpia, à doka gbɛ̀ anlo mɛ̀n pla pìnↄ kũna a ↄĩ. Yã kɛ̃na gbɛ̀ɛ pìnↄa kpa plapla pínki. ");
INSERT INTO bqp_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Luda mɛ́ à gbɛ̀ anlo pìnↄ à, àkũ mɛ́ à yã kɛ̃̀ḿma. ");
INSERT INTO bqp_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yↄsua gbɛ̃nↄ wiki mà, akũ à pì Musanɛ: Ǹ zĩ̀ wiki ma dↄ bùran. ");
INSERT INTO bqp_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa pì: Kùwiki mɛ́ à dↄ gwero, wɛ̃nda ↄ́ↄ dↄn gwe sↄ̃ro, gbɛ̃nↄ lɛ̀sinaan matɛn ma. ");
INSERT INTO bqp_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kũ à kà kãni kũ bùraao, à è òtɛn ũ wã zùsa pì arɛ, akũ à pↄ fɛ̃̀. À gbɛ̀ anlo kũ à kũnaa pìnↄ pã̀tɛ kpigɛrɛɛi gwe, ò wìwi. ");
INSERT INTO bqp_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Akũ à zùsa kũ ò pìi pìi sɛ̀ à dà tɛ́n. À a títi bò, akũ à kà ín à kpà Isarailanↄa, ò mì. ");
INSERT INTO bqp_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Akũ Musa Haruna là à pì: Bↄ́n gbɛ̃ pìnↄ kɛ̀nnɛ, gbasa n tò ò durunna zↄ̃kↄ̃ dí taka kɛ̀ɛ? ");
INSERT INTO bqp_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Akũ à wèa à pì: Ǹsun pↄ fɛ̃ro, mare. Ń gbɛ̃ pìnↄ dↄ̃, kũ ò vãni. ");
INSERT INTO bqp_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mↄ́kↄ̃nↄ mɛ́ ò pìmɛnɛ mà tãna ke kɛ à dońnɛ arɛ. Ò pì Musa kũ à á bↄ́tɛ Misila pìi, ò dↄ̃ yã kũ à a lèro. ");
INSERT INTO bqp_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Akũ ma pìńnɛ gbɛ̃ kũ ò wura vĩnↄ bↄtɛ ò suo. Kũ ò sùo, akũ ma kà tɛ́n, akũ à bò zùsanɛ́ bↄ̀rↄↄ pì ũ. ");
INSERT INTO bqp_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa è Haruna tò gbɛ̃nↄ tɛni ń pↄyeina kɛ, akũ ò gↄ̃̀ lalandi pↄ́ ũ ń ibɛrɛnↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Akũ à zɛ̀ bùra zɛ́lɛa à pì: Gbɛ̃ kũ ò kú Dikiri kpanↄ su ma kuru. Akũ Levi burinↄ kàkara a kuru. ");
INSERT INTO bqp_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","À pìńnɛ: Dikiri Isarailanↄ Luda pì, á baadi a fɛ̃nɛda loko à dodo bùraai zɛ́lɛ kũ zɛ́lɛo, á baadi a gbɛ̃nↄ kũ a gbɛ̃nnanↄ kũ a gbɛ̃dakenↄ dɛdɛ. ");
INSERT INTO bqp_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levi burinↄ kɛ̀ lákũ Musa dàńnɛ nà. Gbɛ̃ kũ ò ń dɛdɛ zĩ pìianↄ kà gbɛ̃nↄn dúbu aakↄ̃ taka bà. ");
INSERT INTO bqp_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Akũ Musa pì Levi buri pìnↄnɛ: Lákũ a bo á nɛ́nↄ kũ á gbɛ̃nↄ kpɛ nà, a á zĩda kpà Dikiria gbãra, Dikiri arubarikaa dàágu gbãran gwe. ");
INSERT INTO bqp_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kũ gu dↄ̀ Musa pì Isarailanↄnɛ: A durunna zↄ̃kↄ̃ↄ kɛ̀, bee kũ abireo mani ɛra mà didi kpia mà gɛ́ Dikiri kĩnaa dↄ, òdigↄ̃ dↄ̃ro ke mani le mà kútɛ kɛnɛárɛ á durunna yã musu. ");
INSERT INTO bqp_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Akũ à ɛ̀ra à gɛ̀ɛ Dikiri kĩnaa à pì: N yã nna! Gbɛ̃ pìnↄ durunna zↄ̃kↄ̃ↄ kɛ̀, ò tãna ke kɛ̀ ń zĩdanɛ kũ wuraao. ");
INSERT INTO bqp_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ǹ sùru kɛ! Ǹ ń durunna kɛ̃ḿma. Tó lɛnlo, ǹ ma tↄ́ warawara takada kũ n kɛ̃̀ɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Dikiri pìnɛ: Gbɛ̃ kũ à durunna kɛ̀mɛnɛ tↄ́n mani warawara ma takada gũn. ");
INSERT INTO bqp_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ǹ gɛ́ kũ gbɛ̃nↄ gu kũ ma ònnɛn sà. Ma Malaika ni donnɛ arɛ. Bee kũ abireo tó ma wɛ́tãmmana gↄrↄ kà, mani wɛ́ tãḿma ń durunna yãi. ");
INSERT INTO bqp_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Akũ Dikiri gagagyã kà gbɛ̃nↄgu zùsanɛ kũ ò tò Haruna pìi pì yãi. ");
INSERT INTO bqp_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Dikiri pì Musanɛ: Ǹ futɛ ǹ go la, mↄkↄ̃n kũ gbɛ̃ kũ n bo kũńwo Misilanↄ, ǹ gɛ́ kũńwo bùsu kũ ma la dà Ibrahĩnɛ kũ Isaakuo kũ Yakubuo ma pì mani kpá ń burinↄan. ");
INSERT INTO bqp_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mani malaika gbarɛ à doárɛ arɛ mani pɛ́árɛ Kanaanↄa kũ Amↄrinↄ kũ Itinↄ kũ Pɛrizinↄ kũ Ivinↄ kũ Yebusinↄo. ");
INSERT INTO bqp_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","À gɛ́ bùsu kũ vĩ kũ zↄ́'io din pìi gũn. Ama mani gɛ́ kãáoro, de màsun á kakatɛ zɛ́nlo yãi, zaakũ sãgbãnadenↄn á ũ. ");
INSERT INTO bqp_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kũ gbɛ̃nↄ yã pãsĩ pìi mà, ò ↄ́ↄ dↄ̀, akũ gbɛ̃ke dí a zãblebↄnↄ da doro. ");
INSERT INTO bqp_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Zaakũ Dikiri gĩnakɛ à yã ò Musanɛ à o Isarailanↄnɛ à pi: Sãgbãnadenↄmɛ ń ũ, bee tó ma táa ò kũńwo gɛ̀sɛ do, mani ń kakatɛ. Ń baadi ń zãblebↄnↄ bobo, manigↄ̃ dↄ̃ deran mani kɛ kũńwo nà. ");
INSERT INTO bqp_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Akũ Isarailanↄ ń zãblebↄnↄ bòbo, odi da doro zaa Orɛbu kpi kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa dì bizakuta sɛ́ à gɛ́ dↄ bùra kpɛ boruna kũ bùraa pìio fíti. À tↄ́ kpà kuta pìinɛ dakarɛki kuta. Gbɛ̃ kũ à ye Dikiri yãi ade dì bo à gɛ́ dakarɛki kuta pì kĩnaa bùra kpɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Tó Musa bò àtɛn gɛ́ kpɛ́ pì kĩnaa, baadi dì bo à zɛ a kpɛ́lɛlɛa àgↄ̃ a gwa ari à gɛ́ à gɛ̃n. ");
INSERT INTO bqp_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tó Musa gɛ̃̀ kpɛ́ pìn, tɛ́luku dì kipa àgↄ̃ dↄ kpɛ́lɛlɛa, akũ Dikiri dì yã o kãao. ");
INSERT INTO bqp_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tó gbɛ̃nↄ è tɛ́luku pì dↄ kpɛ́lɛlɛ pìia, baadi dì donyĩ kɛ a kpɛ́lɛlɛa. ");
INSERT INTO bqp_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Dikiri dì yã o kũ Musao tɛ̃tɛ̃ntɛ̃, lákũ gbɛ̃ dì yã o kũ a gbɛ̃nnao nà. Musa dì ɛra à su bùran, ama Nuni nɛ́ Yↄsua a kpàasi dì bo kpɛ́ pìi gũnlo. ");
INSERT INTO bqp_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa pì Dikirinɛ: N pìmɛnɛ mà gɛ́ kũ gbɛ̃ pìnↄ, ama ńdi gbɛ̃ kũ ntɛn damɛnɛ omɛnɛro. N pìmɛnɛ yã ń ma dↄ̃ n gbɛ̃nna ũ akũsↄ̃ ma n pↄnna lè. ");
INSERT INTO bqp_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Zaakũ ma n pↄnna lè, ǹ tó mà n laasunnↄ dↄ̃ sà, de mà le màgↄ̃ n dↄ̃ màgↄ̃ nna kũnwo yãpura. Ǹgↄ̃ dↄ̃ kũ buri díkĩna bi n gbɛ̃nↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Akũ Dikiri wèa à pì: Ma wɛ́ nigↄ̃ tɛ́ái mà á gba kámmabonaa. ");
INSERT INTO bqp_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa pì: Tó ńdi wɛ́ tɛ́wáiro, ǹsun ó futɛ laro. ");
INSERT INTO bqp_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tó ńdi gɛ́ kũooro, deran oni le ò dↄ̃ kũ makũ kũ n gbɛ̃ pìnↄ ó nna kũnwoo? Oni ó dↄ̃kↄ̃nɛ kũ buri pãndenↄ andunia gũn deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Dikiri pìnɛ: Yã kũ n gbɛ̀kama pì mani kɛ, zaakũ n ma pↄnna lè, má n dↄ̃ ma gbɛ̃nna ũ. ");
INSERT INTO bqp_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa pì: Ǹ n gakuri mↄmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Akũ Dikiri wèa à pì: Mani tó ma manakɛ pínki gɛ̃ n arɛ, mani ma tↄ́ Dikiri sísi n arɛ, zaakũ gbɛ̃ kũ má ye mà sùru kɛ kãaon mani kɛ kãao, akũsↄ̃ gbɛ̃ kũ má ye mà wɛ̃nda dↄ̃nɛn mani dↄ̃nɛ. ");
INSERT INTO bqp_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Akũ à pì: Ĩni fↄ̃ ǹ ma ãn gwaro, zaakũ bisãsiri ni fↄ̃ à wɛ́ simalɛ àgↄ̃ kunlo. ");
INSERT INTO bqp_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Dikiri pì: Ǹ gu gwa da ma sarɛ la. Ǹ zɛ gbɛ̀ɛ musu gwe. ");
INSERT INTO bqp_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tó ma gakuri pì tɛn gɛ̃, mani n sↄtↄ gbɛ̀sↄkↄn mà a ↄ kúnla ari mà gɛ̃tɛ. ");
INSERT INTO bqp_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Tó ma a ↄ gònla, ĩni ma kpɛ kpa e sà, ama oni fↄ̃ ò ma ãn ero. ");
INSERT INTO bqp_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Dikiri pì Musanɛ: Ǹ gbɛ̀ anlo kɛ mɛ̀n pla lán a káakunↄ bà, mani yã kũ ò kú a káakupↄ kũ n wìnↄa kɛ̃ḿma. ");
INSERT INTO bqp_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ǹgↄ̃ kú soru gũn kↄnkↄ. Ǹ didi Sinai kpia ǹ zɛ ma arɛ a mìsↄ̃ntɛa. ");
INSERT INTO bqp_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Gbɛ̃ke sún su kũnworo. Òsun gbɛ̃ke e gukea kpi pìia sero. Bee sã ke zù sún su pↄ́ ble a gɛ̃iro. ");
INSERT INTO bqp_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa gbɛ̀ anlo à mɛ̀n pla lán a káakunↄ bà. À fùtɛ kↄnkↄ káakukaaku, akũ à dìdi Sinai kpia à gbɛ̀ anlo mɛ̀n pla pìnↄ kũna a ↄĩ lákũ Dikiri ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Dikiri kìpa túsukpɛ gũn à zɛ̀ a sarɛ, akũ à a zĩda tↄ́ sìsi. ");
INSERT INTO bqp_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kũ Dikiri tɛn gɛ̃ a arɛ, à a tↄ́ sìsi à pì: Dikiri, Dikiri Luda wɛ̃ndadↄ̃nnɛri sùruden ma ũ. Ma pↄ dì fɛ̃ likaro, má gbɛ̃kɛ kũ náanio vĩ zↄ̃kↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Madìgↄ̃ gbɛ̃kɛ vĩ kũ gbɛ̃nↄ ari ń buri lɛ́mmɛ, mani ń yã vãninↄ kɛ̃ḿma kũ ń taarinↄ kũ ń durunnanↄo. Ama madì tó taaride bo pãro. Madì denↄ yã vãni wí ń nɛ́nↄ musu kũ ń daikorenↄ kũ ń sãkpɛnↄ kũ ń nasionↄo. ");
INSERT INTO bqp_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa wùtɛ a nɛ̀sɛlɛ kutɛna à donyĩ kɛ̀nɛ gↄ̃̀nↄ ");
INSERT INTO bqp_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","à pì: Dikiri, zaakũ ma n pↄnna lè, ǹ gɛ́ kũoo. Bee kũ gbɛ̃ pìnↄ sã gbãna, ǹ sùru kɛ kũoo ó yã vãninↄ kũ ó durunnanↄ musu ǹ ó sɛ́ n pↄ́nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Dikiri pì: Ma bàka nigↄ̃ kú kãáomɛ. Mani yãbonsarɛ kɛ á pínki wára, kũ gbɛ̃ke dí a taka kɛ buri ke gũn andunian zikiro. Buri kũ ò likaáinↄ ni ma yãkɛna e, zaakũ mani yã naaside kɛ kãáo. ");
INSERT INTO bqp_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Àgↄ̃ yã kũ ma òárɛ gbãra kũna, mani pɛ́árɛ Amↄrinↄa kũ Kanaanↄ kũ Itinↄ kũ Pɛrizinↄ kũ Ivinↄ kũ Yebusinↄo. ");
INSERT INTO bqp_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","À laakari kɛ! Àsun lɛ́dokↄ̃nↄ kɛ kũ bùsu kũ átɛn gɛ́ gɛ̃n denↄoro, de àsun tankutɛ kpákpa á zĩdanɛro yãi. ");
INSERT INTO bqp_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","À ń sa'okinↄ gboro à ń tãna gbɛ̀nↄ wíwi à Asɛra línↄ zↄ̃zↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Àsun kútɛ tãnanɛro, zaakũ makũ Dikiri ma tↄ́n Gↄ̃ba, madì gↄ̃ba kpá. ");
INSERT INTO bqp_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","À laakari kɛ! Àsun lɛ́dokↄ̃nↄ kɛ kũ bùsupidenↄoro, zaakũ tó òtɛn pãpã kɛ ń tãnanↄ yã musu, òtɛn sa oḿma, oni á sísi à ń sa'ona nↄ̀bↄ só kũńwomɛ. ");
INSERT INTO bqp_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Àsun nↄ sɛ́ á nɛ́nↄnɛ ń tɛ́ro, zaakũ tó ń nɛ́nↄgbɛ̃nↄ tɛn pãpã kɛ ń tãnanↄ yã musu, oni tó á nɛ́nↄ pãpã kɛ kũńwo se. ");
INSERT INTO bqp_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Àsun mↄ̀ pi tãna ũro. ");
INSERT INTO bqp_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Àgↄ̃ Burodi Futɛnasari dikpɛ kɛ. Àgↄ̃ burodi futɛnasari só gↄrↄ suppla mↄ kũ òdi pi Abibu gũn lákũ ma dìtɛárɛ nà, zaakũ mↄ pìi gũn a bↄtɛ Misila. ");
INSERT INTO bqp_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Á daudunↄ bi ma pↄ́nↄmɛ ń pínki kũ á pↄ́kãde nɛ́ sà káakunↄ ń pínki, zù ke pↄ́ ketenↄ. ");
INSERT INTO bqp_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Àgↄ̃ zaaki nɛ́ sà káaku bo kũ são. Tó ádi boro, à a waka fĩ à dɛ. Àgↄ̃ á daudunↄ bo. Gbɛ̃ke sún su ma kĩnaa ↄkoriro. ");
INSERT INTO bqp_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Àgↄ̃ zĩ kɛ gↄrↄ suddo à kámma bo a gↄrↄ supplade zĩ, bee búwigↄrↄ ke pↄ́kɛ̃gↄrↄn yá. ");
INSERT INTO bqp_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Àgↄ̃ Pↄ́kɛ̃na dikpɛ kɛ gↄrↄ kũ a na burapↄ káaku kɛkɛnaaa. Àgↄ̃ Pↄ́dufublena dikpɛ kɛ wɛ̃̀ lakanaaa. ");
INSERT INTO bqp_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Wɛ̃̀ kũ wɛ̃̀ɛo gↄ̃gbɛ̃ sĩnda pínki gↄ̃ su makũ Dikiri Isarailanↄ Luda arɛ gɛ̃̀n aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mani pɛ́árɛ burinↄa mani á bùsu lɛ́ karaárɛ. Gbɛ̃ke ni á bùsu ni dɛ gↄrↄ kũ átɛn su makũ Dikiri á Luda arɛ wɛ̃̀ kũ wɛ̃̀ɛo gɛ̃̀n aakↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Àsun pↄ́futɛna kpáma lɛɛlɛ kũ sa'opↄ aruoro. Àsun Vĩnla sa'ona nↄ̀bↄ ditɛ gu dↄ̀aro. ");
INSERT INTO bqp_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Àgↄ̃ gɛ́ makũ Dikiri á Luda ↄnn kũ á burapↄ káakunↄ. Àsun blènɛ nↄ̀bↄ kuku kũ a da yↄ̃'ioro. ");
INSERT INTO bqp_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Akũ Dikiri pì Musanɛ: Ǹ yã pìnↄ kɛ̃ takadan, zaakũ ma bàka kunna kũnwo kũ Isarailanↄ yãnↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa kú kũ Dikirio gwe ari gↄrↄ bupla fãnantɛ̃ kũ gwãanio pↄ́blenaa sari pↄ́minaa sari. Akũ Dikiri a bàka kunna kũńwo yã mɛ̀n kurinↄ kɛ̃̀ gbɛ̀ anlo pìnↄa. ");
INSERT INTO bqp_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kũ Musa kìpa Sinai kpia, à gbɛ̀ anlo mɛ̀n pla kũ doka kɛ̃aa pìnↄ kũna a ↄĩ. À dↄ̃ kũ a ãn tɛn tɛ́ kɛ ń yã'ona kũ Dikirio yãiro. ");
INSERT INTO bqp_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kũ Haruna kũ Isarailanↄ a è ń pínki, a ãn tɛn tɛ́ kɛ, vĩna ń kũ ò nai. ");
INSERT INTO bqp_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Akũ Musa ń sísi. Haruna kũ gbɛ̃ zↄ̃kↄ̃nↄ ɛ̀ra ò sù a kĩnaa, akũ à yã ò kũńwo. ");
INSERT INTO bqp_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Abire gbɛra Isarailanↄ nài ń pínki, akũ à yã kũ Dikiri dìtɛarɛ Sinai kpi musu òńnɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kũ à yã òńnɛ à làka, à fáta kù a ãnnwa. ");
INSERT INTO bqp_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tó à gɛ̃̀ à yã o kũ Dikirio, àdi fáta go ari à ɛra à bo. Tó à bò, àdi yã kũ Dikiri dìtɛarɛ o Isarailanↄnɛ, ");
INSERT INTO bqp_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","akũ òdi e a ãn tɛn tɛ́ kɛ. Musa dì ɛra à fáta kú a ãnnwa ari à ɛra à gɛ̃ à yã o kũ Dikirio. ");
INSERT INTO bqp_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Dikiri pì Musanɛ: ");
INSERT INTO bqp_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Ǹ kuta dↄ kũ à de dakarɛki kuta ũ mↄ káakun gↄrↄ káaku zĩ ");
INSERT INTO bqp_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ǹ àkpati kũ doka gbɛ̀ anlonↄn kú a gũn ditɛn ǹ lábure kpái. ");
INSERT INTO bqp_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ǹ gɛ̃ kũ teburuo ǹ a tanↄ kátɛa zɛ́azɛa. Ǹ gɛ̃ kũ fitiladibↄↄo ǹ a fitilanↄ kɛkɛ. ");
INSERT INTO bqp_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ǹ wura turaretitikpataki ditɛ doka àkpati arɛ ǹ kuta kpɛ́lɛlɛ lábure kpá ǹ tataalɛ. ");
INSERT INTO bqp_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ǹ sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ oki ditɛ dakarɛki kuta kpɛ́lɛlɛa, ");
INSERT INTO bqp_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ǹ dàga ditɛ dakarɛki kuta dagura kũ sa'okio ǹ í kán. ");
INSERT INTO bqp_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ǹ kara kpá ǹ likai, ǹ lábure kpá karaa pì lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ǹ pↄ́ sakɛnísi sɛ́ ǹ kú kpɛ́ pìia kũ pↄ́ kũ ò kú a gũnnↄ pínki ǹ ditɛ ma pↄ́ ũ kũ a zĩkɛbↄnↄ, oni gↄ̃ ma pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ǹ nísi pì kú sa'oki pìia kũ a zĩkɛbↄnↄ pínki. Ǹ sa'oki pì ditɛ ma pↄ́ ũ, anigↄ̃ de ma pↄ́ ũ deńla. ");
INSERT INTO bqp_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ǹ nísi pì kú dàga pìia kũ a dibↄↄo, oni gↄ̃ ma pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ǹ su kũ Harunao kũ a nɛ́nↄ dakarɛki kuta kpɛ́lɛlɛa ǹ ń zú o gwe. ");
INSERT INTO bqp_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ǹ sa'ori pↄ́kasanↄ da Harunanɛ, ǹ nísi kúa ǹ a ditɛ ma pↄ́ ũ, ani gↄ̃ ma gbàgbari ũ. ");
INSERT INTO bqp_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ǹ su kũ a nɛ́nↄ dↄ ǹ utagyabanↄ dadańnɛ, ");
INSERT INTO bqp_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ǹ nísi kúkuḿma lákũ n kù ń dea nà, oni ma gbagba. Nísikummanaa pì mɛ́ ani tó ògↄ̃ de ma gbàgbarinↄ ũ ari ń buria. ");
INSERT INTO bqp_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa kɛ̀ lákũ Dikiri ònɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ń bona Misila wɛ̃̀ plade mↄ káaku gↄrↄ káakua ò kuta pìi dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kũ Musa tɛn kuta pì dↄ, à a zɛbↄnↄ pɛ̀tɛpɛtɛ gĩa, akũ à a lípɛtɛnↄ pɛ̀pɛn à a líkpakpanↄ kpàkpan, akũ à lípɛtɛnↄ pɛ̀tɛpɛtɛ. ");
INSERT INTO bqp_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","À biza kùa, akũ à bára kùtɛa lákũ Dikiri ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","À sèeda gbɛ̀ anlonↄ sɛ̀ à kà àkpatii pìi gũn, à àkpatii pì sɛ́linↄ dà a zãnↄ gũn, akũ à a nɛ́ kùtɛa. ");
INSERT INTO bqp_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","À gɛ̃̀o kpɛ́n, akũ à lábure kpà sèeda àkpatii pìii lákũ Dikiri ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","À teburuu dìtɛ dakarɛki kutan lábure pì kpɛ́lɛlɛ kpa gugbãnduru kpa. ");
INSERT INTO bqp_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","À burodii kàtɛa Dikirinɛ zɛ́azɛa lákũ à ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","À fitiladibↄↄ dìtɛ dakarɛki kutan arɛdↄkↄ̃ana teburuua gɛ̀nↄmidↄki kpa, ");
INSERT INTO bqp_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","à fitilanↄ nàna Dikiri arɛ lákũ à ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Akũ à wura turaretitikpataki pìi dìtɛ dakarɛki kutan lábure sarɛ, ");
INSERT INTO bqp_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","akũ à turaretiti gbĩ nnanna kpàtaa lákũ Dikiri ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Akũ à lábure kpà kuta pì lɛ́a. ");
INSERT INTO bqp_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","À sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ oki dìtɛ dakarɛki kuta kpɛ́lɛlɛa, akũ à sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ òa kũ flawaao lákũ Dikiri ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","À dàgaa pìi dìtɛ dakarɛki kuta dagura kũ sa'okio, akũ à í kàn. ");
INSERT INTO bqp_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Gwen Musa kũ Harunao kũ a nɛ́gↄ̃gbɛ̃nↄ dì ń ↄnↄ kũ ń gbánↄ pípin. ");
INSERT INTO bqp_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tó òtɛn gɛ̃ dakarɛki kutan, ke tó òtɛn na sa'okii, òdi ń ↄnↄ kũ ń gbánↄ pípin lákũ Dikiri ò Musanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Akũ à karaa kpà à lìka kuta pìii kũ sa'okio, akũ à lábure kpà karaa pì lɛ́a. Lɛn Musa zĩ pìi kɛ̀ à làka lɛ. ");
INSERT INTO bqp_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Akũ tɛ́luku pìi dà dakarɛki kuta pìla, Dikiri gakuri kuta pìi pà. ");
INSERT INTO bqp_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa dí fↄ̃ à gɛ̃̀ dakarɛki kuta pìi gũnlo, kũ tɛ́luku dàala akũsↄ̃ kũ Dikiri gakuri kuta pìi pà yãi. ");
INSERT INTO bqp_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Isarailanↄ táa'onaa gũn, tó tɛ́luku pìi gò kuta pìia, akũ òdi futɛ kũ táo. ");
INSERT INTO bqp_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tó tɛ́luku pì dí goaro, òdi futɛ kũ táoro, sé zĩ kũ à gòa. ");
INSERT INTO bqp_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Fãnantɛ̃ Dikiri tɛ́luku dì da kuta pìla, gwãani sↄ̃ tɛ́ dìgↄ̃ kú tɛ́luku pìi gũn. Lɛn Isarailanↄ dì e lɛ ń pínki ń táa'onaa gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yinni Gusunɔ u Mɔwisi sokɑ sɑɑ win kuu bekurugii tèn mi bɑ rɑ nùn sɑ̃n di. ");
INSERT INTO bqp_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","U nùn sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ben goo ù n kĩ u nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ, u koo kpĩ u kɛtɛ go, ǹ kun mɛ yɑ̃ɑru. ");
INSERT INTO bqp_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ǹ n yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirɑ yɛ̃ro u mɔ̀ kɑ kɛtɛ, kɛtɛ ye, yɑ ko n sɑ̃ɑwɑ kɛtɛ kinɛru te tɑ ǹ ɑlebu gɑɑ mɔ. U koo yɑ̃ku te kowɑ nɛn sɑ̃ɑ yerun kɔnnɔwɔ, kpɑ u kɑ nɛ, Yinni Gusunɔn durom wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","U koo win nɔmɑ sɔndiwɑ kɛtɛ yen wiru wɔllɔ ye nɛ Gusunɔ nɑ wurɑ yu kɑ win durum wukiri. ");
INSERT INTO bqp_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","U koo kɛtɛ ye gowɑ nɛ, Yinni Gusunɔn wuswɑɑɔ nɛn kuu ten kɔnnɔwɔ. Aronin bibu be bɑ sɑ̃ɑ yɑ̃ku kowobu, beyɑ bɑ koo yen yɛm suɑ kpɑ bu mu yɛ̃kɑ bu kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Yen biru bɑ koo sɑbe te kokuwɑ kpɑ bu ten yɑɑ bɔtiri. ");
INSERT INTO bqp_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Yɑ̃ku kowo berɑ bɑ koo yɑ̃ku dɑ̃ɑ yi yi kpɑ bu dɔ̃ɔ doke. ");
INSERT INTO bqp_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Dɔ̃ɔ wi sɔɔrɑ bɑ koo ye kpuro doke kɑ yen wiru kɑ yen gum. ");
INSERT INTO bqp_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Bɑ koo yen bɔsɔ yɑ̃nu kɑ yen wɔbunu kpuro teɑwɑ kpɑ yɑ̃ku kowobu bu ye kpuro dɔ̃ɔ doke. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu nìn nuburɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Goo ù n mɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru mɔ̀ kɑ yɑ̃ɑru, ǹ kun mɛ kɑ boo, yɑ̃ɑ kinɛrɑ u koo go, ǹ kun mɛ boo kinɛru te tɑ ǹ ɑlebu gɑɑ mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","U koo tu sɑkɑwɑ yɑ̃ku yerun sɔ̃ɔ yɛ̃sɑn nɔm geu giɑ Yinni Gusunɔn wuswɑɑɔ kpɑ yɑ̃ku kowobu bu ten yɛm suɑ bu yɛ̃kɑ yɛ̃kɑ bu kɑ yɑ̃ku yerun nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","U koo yɑɑ ye bɔtiriwɑ kpɑ u kpɛ̃ɛ yɑ̃ku dɔ̃ɔ sɔɔ kɑ yen wiru kɑ yen gum sɑnnu. ");
INSERT INTO bqp_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","U koo yen bɔsɔ yɑ̃nu kɑ yen wɔbunu suɑ u teɑwɑ, kpɑ yɑ̃ku kowo u ye kpuro suɑ u dɔ̃ɔ doke, yu dɔ̃ɔ mwɑɑrɑ mɑm mɑm. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru tèn nuburɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Goo ù n yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru mɔ̀ kɑ gunɔsu, kpɑrukonɑ u koo kɑ tu ko, ǹ kun mɛ totobɛrɛnu. ");
INSERT INTO bqp_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Yɑ̃ku kowo u koo kɑ gunɔ ge nɑ yɑ̃ku yerɔ. Kpɑ u gen wiru burɑ kpɑ u gen yɛm yɛ̃kɑ yɛ̃kɑ yɑ̃ku yee ten yɛ̃sɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","U koo gen sɑnsu wukiriwɑ kpɑ u gen yɔ̃ɔru wĩɑ u kɔ̃ yɑ̃ku yerun sɔ̃ɔ yɑri yeru giɑ mì bɑ rɑ torom wisi. ");
INSERT INTO bqp_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kpɑ u gu bɛrɑ bɛsi yiru u kun sɔsiɑnɛ. Yen biruwɑ u koo gu dɔ̃ɔ kpɛ̃ɛ, kpɑ gu dɔ̃ɔ mwɑɑrɑ. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru tèn nuburu tɑ koo nɛ Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Goo ù n kĩ u Yinni Gusunɔ yɑ̃kuru kuɑ kɑ win dĩɑ binnu, somɑ u koo suɑ, u mu burinɑ kɑ gum kɑ sere turɑre ye bɑ rɑ dɔ̃ɔ doke yɑ̃ku yerɔ. ");
INSERT INTO bqp_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","U koo kɑ ye dɑwɑ Aronin bibun mi be bɑ sɑ̃ɑ yɑ̃ku kowobu. Ben turowɑ u koo som mɛn nɔm wɔɔ teeru sɔkɑ u doke yɑ̃ku yerun wɔllɔ kɑ turɑre ye kpuro kpɑ u dɔ̃ɔ doke. Yerɑ yɑ koo de Gusunɔ u n yɛ̃ro yɑɑye. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru tèn nuburɑ koo Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Som mɛ mu tie mu ko n sɑ̃ɑwɑ Aroni kɑ win bibugim. Mu kuɑwɑ mi dĩɑ dɛɛrɑnu, domi bɑ kɑ nu Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","À n Yinni Gusunɔ yɑ̃kuru kuɑmmɛ kɑ kirɑ ni bɑ wɔ̃ɔwɑ, kɑɑ nu kowɑ kɑ som mɛ bɑ gum yɛ̃kɑ ǹ kun mɛ mɛ bɑ kɑ gum burinɑ bɑ ǹ seeyɑtiɑ doke. ");
INSERT INTO bqp_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Bɑ̀ n koo yɑ̃ku te kon nɑ kɑ kirɑ ni bɑ sɔnwɑ, bɑ koo nu kowɑ kɑ som buu te bɑ burinɑ kɑ gum, seeyɑtiɑ sɑri. ");
INSERT INTO bqp_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Yen biru bɑ koo nu muririwɑ kpɑ bu gum yɛ̃kɑ nin wɔllɔ. Yɑ ko n sɑ̃ɑwɑ yɑ̃kuru. ");
INSERT INTO bqp_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Bɑ̀ n koo yɑ̃ku te kon nɑ, kɑ kirɑ te bɑ koo wɔ̃, bɑ koo tu kowɑ kɑ som buuru te bɑ burinɑ kɑ gum. ");
INSERT INTO bqp_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bɑ koo kɑ yɑ̃ku kirɑ te dɑwɑ Yinni Gusunɔn sɑ̃ɑ yerɔ. Kpɑ u tu yɑ̃ku kowo wɛ̃ u kɑ tu dɑ yɑ̃ku yerɔ. ");
INSERT INTO bqp_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","U koo ten gɑru murɑ te tɑ koo de Yinni Gusunɔ u n yɛ̃ro yɑɑye kpɑ u tu dɔ̃ɔ doke yɑ̃ku yee ten mi, kpɑ tu dɔ̃ɔ mwɑɑrɑ. Tɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru tèn nuburɑ koo Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kirɑ ni nu tie, Aroni kɑ win bibɑ bɑ ni mɔ. Nu kuɑwɑ mi dĩɑ dɛɛrɑnu domi bɑ kɑ nu Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Kirɑ ni bɑ koo kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko kpuro, bu ku rɑɑ nu seeyɑtiɑ doke, bu ku rɑɑ mɑɑ nu tim doke. ");
INSERT INTO bqp_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kɑɑ kpĩ ɑ kɑ wunɛn dĩɑ gbiikinu Yinni Gusunɔ nɑɑwɑ. Adɑmɑ ɑ ǹ kɑ nu yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu mɔ̀ yɑ̃ku yerɔ. ");
INSERT INTO bqp_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Dĩɑ ni ɑ kɑ yɑ̃kuru mɔ̀ kpuro, kɑɑ nu bɔru dokewɑ. A ku duɑri ɑ kun tu doke. Domi bɔru tɑ sɑ̃ɑwɑ wunɛ kɑ Gusunɔn ɑrukɑwɑnin yĩreru. Yen sɔ̃nɑ bɑ ko n dɑ tu doke yɑ̃kuru bɑɑtere sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ì n kĩ i kɑ bɛɛn gberun dĩɑ gbiikinu nɑ Yinni Gusunɔn mi, i ko i nu sɔmɛwɑ kpɑ i nu nɑm i sere kɑ nɑ. ");
INSERT INTO bqp_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kpɑ i kɑ nu gum burinɑ, i turɑre sɔndi nin wɔllɔ. Yɑ ko n sɑ̃ɑwɑ yɑ̃kuru. ");
INSERT INTO bqp_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Yɑ̃ku kowowɑ u koo som mɛ mu sɑ̃ɑ Gusunɔgim dɔ̃ɔ doke kɑ sere mɑɑ turɑre ye. Yerɑ yɑ koo de Gusunɔ u n yɛ̃ro yɑɑye. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru Yinni Gusunɔn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀ Yinni Gusunɔn mi kɑ kɛtɛ kinɛru, ǹ kun mɛ kɑ kɛtɛ niɑ, yen ye u wɑ kpurowɑ u koo kɑ nɑ, yɑ kun gesi ɑlebu mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","U koo win nɔmu sɔndiwɑ kɛtɛ yen wiru wɔllɔ kpɑ u ye sɑkɑ kuu ten kɔnnɔwɔ mi bɑ rɑ Yinni Gusunɔ sɑ̃. Kpɑ yɑ̃ku kowo Aronin bibu bu yen yɛm yɛ̃kɑ bu kɑ sɑ̃ɑ yerun nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Wee ye bɑ koo Yinni Gusunɔ dɔ̃ɔ dokeɑ, yerɑ gum mɛ mu bɔsɔ yɑ̃nu tɛ̃ke, ");
INSERT INTO bqp_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kɑ gɑbu swii yiru kɑ yin gum mɛ mu yi tɛ̃ke yɛ̃si yɛ̃sikɑɔ, kɑ yen buro ge gɑ yen woru wukiri. Bɑ koo gu wĩɑwɑ kɑ gɑbu swii sɑnnu. ");
INSERT INTO bqp_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Yɑ̃ku kowobɑ bɑ koo ye kpuro dɔ̃ɔ doke yu dɔ̃ɔ mwɑɑrɑ kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru sɑnnu. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku tèn nuburɑ koo Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀ kɑ yɑ̃ɑru, yɑ̃ɑ te u wɑ kpurowɑ u koo kɑ nɑ, bɑɑ ǹ n nirun nɑ, tɑ kun gesi ɑlebu mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ǹ n yɑ̃ɑ kpɛndun nɑ, u koo kɑ tu dɑwɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Kpɑ u win nɔmɑ sɔndi ten wiru wɔllɔ u sere tu sɑkɑ Yinni Gusunɔn kurun kɔnnɔwɔ. Sɑɑ yerɑ yɑ̃ku kowobu bɑ koo ten yɛm suɑ bu yɛ̃kɑ bu kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Wee ye bɑ koo Yinni Gusunɔ dɔ̃ɔ dokeɑ, yerɑ ten gum, kɑ ten siru kpuro te bɑ koo burɑ sɑɑ ten gɑbu wɑ̃ɑn di, kɑ gum mɛ mu bɔsɔnu wukiri, ");
INSERT INTO bqp_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kɑ ten gɑbu swii, kɑ ten gum mɛ mu wɑ̃ɑ yɛ̃sɑɔ kɑ ten buro ge gɑ woru wukiri, ge bɑ koo wĩɑ kɑ gɑbu swii sɑnnu. ");
INSERT INTO bqp_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Yɑ̃ku kowo u koo ye kpuro dɔ̃ɔ dokewɑ yɑ̃ku yerɔ, kpɑ yɑ n sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru Yinni Gusunɔn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Goo ù n mɑɑ kɑ boo yɑ̃kuru mɔ̀, u koo kɑ gu dɑwɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","U koo win nɔmɑ sɔndiwɑ boo gen wiru wɔllɔ kuu ten kɔnnɔwɔ, kpɑ u sere gu sɑkɑ. Kpɑ yɑ̃ku kowobu bu gen yɛm suɑ bu yɛ̃kɑ yɑ̃ku yerun nɔɔ bɔkɑɔ bu kɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Wee ye bɑ koo Yinni Gusunɔ dɔ̃ɔ dokeɑ, yerɑ gum mɛ mu gen bɔsɔ yɑ̃nu tɛ̃ke, ");
INSERT INTO bqp_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kɑ gɑbu swii yiru kɑ gum mɛ mu yi tɛ̃ke kɑ gen buro ge gɑ woru wukiri, ge bɑ koo wĩɑ kɑ gɑbu swii sɑnnu. ");
INSERT INTO bqp_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Yɑ̃ku kowowɑ u koo ye kpuro dɔ̃ɔ doke mu dɔ̃ɔ mwɑɑrɑ. Kpɑ yɑ n sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru tèn nuburɑ koo Yinni Gusunɔ dore. Yen gum kpuro mu ko n sɑ̃ɑwɑ Yinni Gusunɔgim. ");
INSERT INTO bqp_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Yen sɔ̃nɑ bɑɑ ǹ n sɑɑ yeren nɑ, mi i wɑ̃ɑ kpuro, i woodɑ yeni mɛm nɔɔwɔ sere kɑ bɑɑdommɑɔ, yerɑ i ku yɑɑ gum di, i ku mɑɑ yen yɛm di. ");
INSERT INTO bqp_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ɑ Isirelibɑ woodɑ yenibɑ sɔ̃ɔwɔ ɑ nɛɛ, goo ù n Yinni Gusunɔn woodɑ gɑɑ torɑ u kun yɛ̃, wee ye u koo ko. ");
INSERT INTO bqp_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ǹ n yɑ̃ku kowon nɑ u torɑ, mɑ win torɑ te, tɑ Isirelibɑ kpuro torɑsiɑ, u koo kɑ kɛtɛ kinɛ kpɛmbu nɑwɑ ge gɑ ǹ ɑlebu gɑɑ mɔ, u go u kɑ win torɑ ten suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U koo kɑ kɛtɛ ye dɑwɑ Yinni Gusunɔn kurun kɔnnɔwɔ, kpɑ u win nɔmɑ sɔndi yen wiru wɔllɔ u sere ye sɑkɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Yen biru kpɑ u yen yɛm suɑ u kɑ dɑ kuu ten sɔɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","U koo kɑ mu win niki biɑ dɛkɑwɑ, kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru kuu ten beku kɑre ten berɑ giɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Yen biru u koo yɛm mɛ yɛ̃kɑ kpɑkoro tèn mi bɑ rɑ turɑre dɔ̃ɔ doken kɑ̃ɑnɔ te tɑ wɑ̃ɑ kuu ten sɔɔwɔ, kpɑ u mɛn sukum wisi yɑ̃ku yerun temɔ te tɑ wɑ̃ɑ kuu ten kɔnnɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","U koo yɑɑ yen gum kpuro wunɑ mɛ mu wɑ̃ɑ bɔsɔ yɑ̃nu sɔɔ, ");
INSERT INTO bqp_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kɑ yen gɑbu swii, kɑ gum mɛ mu gɑbu swii yi wukiri yɛ̃si yɛ̃sikɑɔ, kɑ buro ge gɑ woru wukiri, ge bɑ koo wĩɑ kɑ gɑbu swii sɑnnu. ");
INSERT INTO bqp_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ye bɑ rɑ wĩɛ bɑ̀ n siɑrɑbun yɑ̃kuru mɔ̀ gesi, yerɑ bɑ koo mɑɑ wĩɑ yeni sɔɔ. Yen biru yɑ̃ku kowo tɔnwerowɑ u koo ye dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","U koo ye yɑ tie kpuro gurɑwɑ u kɑ dɑ sɑnsɑnin biruɔ mi bɑ gɔsɑ bɑ n dɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun torom kube. Miyɑ u koo yen gɔnɑ kɑ yɑɑ ye yɑ tie kpuro dɔ̃ɔ doke torom mɛn wɔllɔ, kɑ yen wiru kɑ yen wɔbunu kɑ yen bɔsɔ yɑ̃nu. ");
INSERT INTO bqp_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Isirelibɑ kpuro bɑ̀ n Gusunɔn woodɑ gɑɑ sɑrɑ bɑ ǹ kɑ bɑɑru, bɑ torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Adɑmɑ bɑ̀ n tubɑ mɑ bɑ torɑwɑ mi, bɑ koo nɑɑ kinɛ kpɛmbu gowɑ bu kɑ ben torɑ ten suuru kɑnɑ. Bɑ koo kɑ nɑɑ kinɛ te dɑwɑ Yinni Gusunɔn kurun kɔnnɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Kpɑ Isirelibɑn wirugibu bu ben nɔmɑ sɔndi nɑɑ yen wiru wɔllɔ kpɑ ben turo u ye sɑkɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Yɑ̃ku kowo tɔnwerowɑ u koo yen yɛm fiiko suɑ u kɑ dɑ kuu ten mi. ");
INSERT INTO bqp_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Sɑɑ ye sɔɔrɑ u koo yɛm mɛ dɛkɑ kɑ win niki biɑ kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru kuu ten beku kɑre ten deedeeru. ");
INSERT INTO bqp_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Yen biru, kpɑ u mɑɑ kpɑkoro tèn mi u rɑ turɑre dɔ̃ɔ doken kɑ̃ɑnu yɛm yɛ̃kɑ. Yɛm mɛ mu tie, kpɑ u mu wisi yɑ̃ku yerun temɔ te tɑ wɑ̃ɑ kuu ten kɔnnɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Yen biru u koo yɑɑ yen gum kpuro suɑ u dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Nge mɛ u rɑɑ kuɑ win tiin torɑrun sɔ̃, nge mɛyɑ u koo ko Isirelibɑ kpuron torɑ ten sɔ̃ kpɑ Gusunɔ u sere bu suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Yen biru kpɑ u kɑ yɑɑ ye yɑ tie dɑ sɑnsɑnin biruɔ kpɑ bu ye doke dɔ̃ɔ sɔɔ nge mɛ bɑ rɑɑ kuɑ wi, yɑ̃ku kowon torɑrun sɔ̃. Yɑ̃ku te, tɑ sɑ̃ɑwɑ Isirelibɑ kpuro bu kɑ ben torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Isirelibɑn wirugii goo ù n Gusunɔn woodɑ gɑɑ sɑrɑ u ǹ kɑ bɑɑru, u torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Adɑmɑ ù n tubɑ mɑ u torɑ, boo kinɛrɑ u koo go te tɑ ǹ ɑlebu gɑɑ mɔ u kɑ yɑ̃kuru ko. Kpɑ Gusunɔ u nùn win torɑ te suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ù n kɑ boo ge nɑ, u koo win nɔmɑ sɔndiwɑ boo gen wɔllɔ kpɑ u gu sɑkɑ mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruginun yɑɑ sɑke. Yɑ̃ku te, tɑ sɑ̃ɑwɑ torɑrun suurugiru. ");
INSERT INTO bqp_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Yɑ̃ku kowo wi, u koo kɑ win niki biɑ yɛm mɛ dɛkɑwɑ kpɑ u mu yɛ̃kɑ yɑ̃ku yerun kɑ̃ɑnu sɔɔ. Yɛm mɛ mu tie, kpɑ u mu wisi yɑ̃ku yee ten temɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","U koo yɑɑ yen gum kpuro suɑwɑ u dɔ̃ɔ doke nge mɛ bɑ rɑ siɑrɑbun yɑ̃kuru ko. Nge mɛyɑ yɑ̃ku kowo tɔnwero wi, u koo ko u kɑ wirugii win torɑrun suuru kɑnɑ. Sɑɑ ye sɔɔ, Gusunɔ u koo nùn tu suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Tɔn diro goo ù n Gusunɔn woodɑ gɑɑ sɑrɑ u ǹ kɑ bɑɑru, u torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Adɑmɑ ù n tubɑ mɑ u torɑwɑ, boo niu ge gɑ ǹ ɑlebu gɑɑ mɔwɑ u koo kɑ yɑ̃kuru ko Gusunɔ u kɑ nùn win torɑru suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","U koo win nɔmɑ sɔndiwɑ boo gen wiru wɔllɔ kpɑ u gu sɑkɑ mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun yɑɑ sɑke. ");
INSERT INTO bqp_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Yen biru, yɑ̃ku kowo u koo nɑ u yɛm mɛ dɛkɑ kɑ win niki biɑ, kpɑ u mu yɛ̃kɑ yɑ̃ku yerun kɑ̃ɑnɔ, kpɑ u yɛm mɛ mu tie wisi yɑ̃ku yee ten temɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Yen biru, bɑ koo yɑɑ yen gum kpuro wĩɑwɑ nge mɛ bɑ rɑ siɑrɑbun yɑ̃kurugim wĩɛ. Kpɑ yɑ̃ku kowo u mu dɔ̃ɔ mɛni, kpɑ mɛn nuburu tu Yinni Gusunɔ dore. Nge mɛyɑ yɑ̃ku kowo wi, u koo kɑ toro wi suuru kɑnɑ. Sɑɑ ye sɔɔ, Gusunɔ u koo nùn suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Toro wi, ù n mɑɑ kĩn nɑ, u kɑ yɑ̃ɑ kpɛndu yɑ̃kuru ko, yɑ̃ɑ nirɑ u koo kɑ nɑ u go, te tɑ ǹ ɑlebu mɔ, u kɑ win torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ù n kĩ u tu go, u koo win nɔmɑ sɔndiwɑ ten wiru wɔllɔ kpɑ u tu sɑkɑ mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun yɑɑ go. ");
INSERT INTO bqp_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Yen biru yɑ̃ku kowo u koo yɛm mɛ dɛkɑ kɑ win niki biɑ u mu yɛ̃kɑ yɑ̃ku yerun kɑ̃ɑnɔ. Yɛm mɛ mu tie kpɑ u mu wisi sɑ̃ɑ yee ten temɔ. ");
INSERT INTO bqp_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Yen biru u koo yen gum wĩɑwɑ nge mɛ bɑ rɑ siɑrɑbun yɑ̃kurugim wĩɛ. Yɑ̃ku kowowɑ u koo mɛ kpuro dɔ̃ɔ doke kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru sɑnnu. Nge mɛyɑ yɑ̃ku kowo wi, u koo ko u kɑ toro wi suuru kɑnɑ. Sɑɑ ye sɔɔrɑ Yinni Gusunɔ u koo nùn win torɑ te suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Su tɛ̃ nɛɛ, goo u bɔ̃ruɑ mɑ u koo seedɑ di gɑ̃ɑ ni u wɑn sɔ̃, ɑdɑmɑ u ǹ geruɑ ye u wɑ, ǹ kun mɛ ye u yɛ̃. Sɑɑ ye sɔɔ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Su tɛ̃ kpɑm nɛɛ, goo u gɑ̃ɑnu bɑbɑ ye yɑ disi mɔ u kun kɑ bɑɑru, ɑɑ, yɑɑ sɑbe te bɑ ku rɑ din gorɑ? Ǹ kun mɛ gbeeku yɑɑ ye bɑ ku rɑ din gorɑ? Ǹ kun mɛ yɑɑ ye yɑ rɑ kɑbirin gorɑ? Sɑɑ ye sɔɔ, yɛ̃ro u disi duurɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Su mɑɑ tɛ̃ nɛɛ, goo ù n win winsim bɑbɑ wi u disi gɛɛ mɔ yi yi koo nùn tiɑ, n deemɑ u ǹ yɛ̃, mɑ u rɑ ye tubɑ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Torɑru gɑru wee mɑɑ. Su tɛ̃ nɛɛ, goo u bɔ̃ruɑ u win winsim kɔ̃sɑ kuɑ ǹ kun mɛ u nùn geɑ kuɑ, u ǹ bwisikɑ, ù n deemɑ gɑri yi, gɑri giriyɑ u geruɑ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Goo ù n torɑ nin gɑru kuɑ, u koo yen tuubɑ kowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Adɑmɑ u sere torɑ ten suuru wɑ, u koo yɑ̃ɑ niru ǹ kun mɛ boo niu gowɑ u kɑ Yinni Gusunɔ yɑ̃kuru kuɑ. Yen biru yɑ̃ku kowo u koo nùn suuru kɑnɑbun wororu koosi, kpɑ u sere win torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Goo ù kun kpɛ̃ u yɑ̃ɑ niru ǹ kun mɛ boo niu wɑ u kɑ torɑrun yɑ̃kuru ko, u koo kpĩ u kpɑrukonu yiru ǹ kun mɛ totobɛrɛnu yiru kɑsu. Gunɔ gen teuwɑ bɑ koo kɑ torɑrun yɑ̃kuru ko. Kpɑ bu mɑɑ kɑ teu geni yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Bɑ koo ginɑ yɑ̃ku kowo wi gunɔ ge wɛ̃wɑ ge bɑ kɑ torɑrun suuru kɑnɑbu nɑ mi, kpɑ u gen wĩiru buɑ u kun sɔsie. ");
INSERT INTO bqp_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kpɑ u gen yɛm dɛkɑ u yɛ̃ke yɑ̃ku yerun nɔɔ bɔkɑɔ, mɛ mu tie kpɑ u wisi ten temɔ. Yɑ ko n sɑ̃ɑwɑ torɑrun yɑ̃kuru. ");
INSERT INTO bqp_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Yen biru yɑ̃ku kowo u koo gunɔ yiruse suɑ nge mɛ woodɑ yɑ geruɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru gɑru ko. Kpɑ u nùn suuru kɑnɑbun wororu koosi. Nge mɛyɑ Gusunɔ u koo kɑ yɛ̃ro suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Goo ù kun kpɛ̃ u kpɑrukonu yiru ye wɑ, ǹ kun mɛ totobɛrɛnu yiru ye, u kɑ som buuru kilo nnɛ nɑ u kɑ yɑ̃kuru ko kpɑ u kɑ win torɑrun suuru wɑ. Adɑmɑ u ku mu gum doke, u ku mɑɑ mu turɑre doke, domi u kɑ mu nɑwɑ u kɑ win torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","U koo kɑ som mɛ dɑwɑ yɑ̃ku kowon mi kpɑ yɑ̃ku kowo wi, u mɛn nɔm kure teeru sɔkɑ u dɔ̃ɔ doke mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. Som nɔm kure tee te, tɑ koo de Yinni Gusunɔ u n yɛ̃ro yɑɑye. Yɑ̃ku terɑ tɑ koo de u win torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Sɑɑ ye sɔɔ, yɑ̃ku kowo wi, u koo wi u torɑ suuru kɑnɑbun wororu koosi. Kpɑ Gusunɔ u nùn win torɑrun suuru kuɑ. Kpɑ yɑ̃ku kowo u mɛ mu tie suɑ win tiin sɔ̃, nge gberun dĩɑnun yɑ̃kunu. ");
INSERT INTO bqp_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","goo ù n gɑ̃ɑnu nɛni ni n weenɛ u Yinni Gusunɔn wɛ̃, mɑ u ǹ yɛ̃ mɑ Yinni Gusunɔginɑ, wee ye u koo ko win torɑ ten sɔ̃. Kɑɑ nùn yɑ̃ɑ kinɛru te tɑ ǹ ɑlebu gɑɑ mɔn geeru burɑwɑ te u koo kɑsu u kɑ nɑ u kɑ torɑrun sɔmbun yɑ̃kuru ko. Kɑɑ ten gee te burɑwɑ kɑ sii geesun gobi yi bɑ rɑ di Yinni Gusunɔn kuu bekurugirɔ. ");
INSERT INTO bqp_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kpɑ u kɑ gɑ̃ɑ ni u nɛni mi nɑ. Yen biruwɑ u koo mɑɑ kɑ nin bɔnu nɔɔbusen tiɑ nɑ. Yɑ̃ku kowowɑ u koo ye wɛ̃. Yɑ̃ku kowo wiyɑ u koo nùn torɑrun yɑ̃kuru kuɑ, kpɑ u sere suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Goo ù n Yinni Gusunɔn woodɑ gɑɑ sɑrɑ, bɑɑ u kun yɛ̃, u torɑwɑ mi. Yen torɑrɑ ko n nùn wɑ̃ɑsiwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yen sɔ̃, u koo kɑ yɑ̃ɑ kinɛru te tɑ ǹ ɑlebu gɑɑ mɔ dɑwɑ yɑ̃ku kowon mi, win torɑ ten sɔ̃ nge mɛ n weenɛ u kɔsiɑ. Kpɑ yɑ̃ku kowo u nùn suuru kɑnɑbun wororu koosi. Sɑɑ ye sɔɔrɑ Gusunɔ u koo nùn suuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Yɑ ko n sɑ̃ɑwɑ torɑrun sɔmbun yɑ̃kuru. Domi yɛ̃ro u Yinni Gusunɔ torɑriwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","goo ù n win winsim weesu kuɑ gɑ̃ɑ ni u nùn berusie sɔɔ, ǹ kun mɛ u bɔkurɑ, ǹ kun mɛ u gbɛnɑ, ǹ kun mɛ u kɑwɑ, ");
INSERT INTO bqp_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ǹ kun mɛ u gɑ̃ɑnu dɔbɑ mɑ u siki, ǹ kun mɛ u bɔ̃ri weesugii kuɑ, ");
INSERT INTO bqp_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","tɔnu win bweseru u Yinni Gusunɔ torɑriwɑ mi. U koo gɑ̃ɑ ni u gbɛnɑ mi wesiɑ, ǹ kun mɛ ni u kɑwɑ mi, ǹ kun mɛ ye bɑ nùn berusiɑ mi, ǹ kun mɛ ye u dɔbɑ mɑ u siki, ");
INSERT INTO bqp_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ǹ kun mɛ yèn bɔ̃ri u kuɑ mi. Adɑmɑ n ǹ mɔ ye tɔnɑ u koo wesiɑ. U koo mɑɑ yen bɔnu nɔɔbusen tiɑ kɔsiɑwɑ dɔmɑ te u koo win torɑrun sɔmbun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","U koo kɑ yɑ̃ɑ kinɛru dɑwɑ yɑ̃ku kowon mi, te tɑ gɑ̃ɑ nin gobin sɑkɑ turɑ bu kɑ ye Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Yinni Gusunɔn wuswɑɑɔrɑ yɑ̃ku kowo u koo nùn suuru kɑnɑbun wororu koosi. Yen biru Gusunɔ u koo yɛ̃ro suuru kuɑ, bɑɑ ǹ n mɛren nɑ win torɑrɑ nɛ. ");
INSERT INTO bqp_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","ɑ Aroni kɑ win bibu woodɑ yeni wɛ̃ɛyɔ ɑ nɛɛ, wee ye yɑ sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun woodɑ. Ten yɑ̃ku yɑɑ yɑ ko n wɑ̃ɑwɑ dɔ̃ɔ sɔɔ wɔ̃ku giriru, kpɑ bu ku de dɔ̃ɔ wi, u gbi sere yɑm mu kɑ sɑ̃rɑ. ");
INSERT INTO bqp_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Yen biru yɑ̃ku kowo u koo win tɑko sebewɑ kɑ win sokoto kpiriru kpɑ u yɑ̃ku dɔ̃ɔ mwɑɑrɑrugii ten torom gurɑ u yi yɑ̃ku yee ten bɔkuɔ. ");
INSERT INTO bqp_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Yen biruwɑ u koo win yɑ̃ɑ ni potɑ kpɑ u kpɑɑnu doke u sere torom mɛ suɑ u kɑ yɑri sɑnsɑnin di. Kpɑ u kɑ mu dɑ yɑm mi bɑ gɔsɑ mɛn sɔ̃ u yi mi. ");
INSERT INTO bqp_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Dɔ̃ɔ wi u mwɑɑrɑmɔ yɑ̃ku yee ten mi, bɑ ǹ koo de u gbi pɑi! Bururu bɑɑtere yɑ̃ku kowo u ko n dɑ tu dɑ̃ɑ dokewɑ. Yen wɔllɔwɑ u koo yɑ̃ku yɑɑ sɔndi kɑ sere siɑrɑbun yɑ̃ku gum. ");
INSERT INTO bqp_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Dɔ̃ɔ u ko n wɑ̃ɑwɑ yɑ̃ku yee te sɔɔ sere kɑ bɑɑdommɑɔ, bɑ ǹ koo de u gbi. ");
INSERT INTO bqp_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Yɑ̃ku te bɑ rɑ ko kɑ gberun dĩɑnun woodɑ wee. Aronin bibɑ bɑ ko n dɑ kɑ tu de yɑ̃ku yerɔ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Kpɑ ben wi u yɑ̃kuru mɔ̀ dɔmɑ te, u som nɔm kure teeru sɔkɑ mɛ bɑ kɑ yɑ̃kuru nɑ mɛ bɑ gum wisi, kɑ turɑre kpuro, kpɑ bu ye kpuro mɛnnɑ bu dɔ̃ɔ doke kpɑ ten nuburu tu Gusunɔ dore kpɑ u n yɛ̃ro yɑɑye. ");
INSERT INTO bqp_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","10","Som mɛ mu tiɑrɑ Aroni kɑ win bibɑ bɑ koo mɛ di. Yerɑ yɑ ko n sɑ̃ɑ begiɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru sɔɔ. Adɑmɑ bɑ koo mu diwɑ Yinni Gusunɔn kuu bekurugirun yɑɑrɑɔ. Bɑ ǹ mɛ pɛ̃ɛ seeyɑtiɑ dokemɔ. Yɑ sɑ̃ɑwɑ nɛnɛm nge yɑ̃ku te bɑ kuɑ bu kɑ torɑrun suuru wɑn dĩɑnu, ǹ kun mɛ te bɑ rɑ kɑ torɑru sɔmɛn dĩɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Aronin bii tɔn durɔ bɑɑwurewɑ u koo dĩɑ ni di. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ win bibun bweseru sɔɔ sere kɑ bɑɑdommɑɔ. Tɔn tuko wi u koo nu bɑbɑ kpuro u koo gbiwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, yɑ̃ku te Aroni kɑ win bibu bɑ koo Yinni Gusunɔ kuɑ wee. ");
INSERT INTO bqp_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Bɑ̀ n Aroni kɑ win bibu tusiɑ mɑ bɑ kuɑ nɛn yɑ̃ku kowobu, sɑɑ dɔmɑ ten diyɑ bɑ ko n dɑ som kilo itɑ kɑ yɑ̃kuru ko tɔ̃ɔ bɑɑtere, tiɑ kɑ bɔnu bururu, yokɑ mɑɑ tiɑ kɑ bɔnu. ");
INSERT INTO bqp_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Bɑ koo som mɛ mɔmwɑ buturu buturu, kpɑ bu mɛ sɔmɛ siru sɔɔ kɑ gum, kpɑ mɛn nuburu tu nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Yɑ̃ku kowo wi bɑ gum tɑ̃re bɑ gɔsɑ Aronin bibu sɔɔ u kɑ nùn kɔsire ko, win tii u koo tu kowɑ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ nɛ, Yinni Gusunɔn sɔ̃. Bɑ koo som mɛ dɔ̃ɔ dokewɑ kpuro. ");
INSERT INTO bqp_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Yɑ̃ku te yɑ̃ku kowon tii u kuɑ, bɑ koo de tu dɔ̃ɔ mwɑɑrɑwɑ mɑm mɑm, bɑ ǹ koo tu di. ");
INSERT INTO bqp_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, yɑ̃ku te bɑ koo ko bu kɑ suuru kɑnɑn woodɑ wee. Yɑm mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun yɑ̃ku yɑɑ sɑke, miyɑ bɑ koo yɑ̃ku tenin yɑɑ sɑkɑ. Yɑ ko n sɑ̃ɑwɑ gɑ̃ɑ dɛɛrɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yɑ̃ku kowo wi u koo yɑ̃ku te ko wiyɑ u koo ye di. U koo ye diwɑ yɑm dɛɛrɑmɔ, kuu ten yɑɑrɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Tɔn tuko wi u koo yɑ̃ku yɑɑ ye bɑbɑ kpuro u koo gbiwɑ. Yɑ̃ku yɑɑ yen yɛm mù n wisi win yɑberɔ u koo tu teɑwɑ yɑm dɛɛrɑm mi. ");
INSERT INTO bqp_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bɑ̀ n tu sɑwɑ wekeru sɔɔ te bɑ kuɑ kɑ sɔndu, bɑ koo weke te kɔrɑwɑ. Ǹ n mɑɑ weke te bɑ kuɑ kɑ sii gɑndun nɑ, bɑ koo tu teɑwɑ sɑ̃ɑ sɑ̃ɑ kɑ nim. ");
INSERT INTO bqp_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Yɑ̃ku kowo tɔn durɔ bɑɑwurewɑ u koo kpĩ u tu di domi tɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Adɑmɑ bɑ ǹ koo torɑrun yɑ̃ku yɑɑ tem tèn yɛm bɑ kɑ duɑ sɑ̃ɑ yerɔ. Bɑ koo ye dɔ̃ɔ dokewɑ yu dɔ̃ɔ mwɑɑrɑ mɑm mɑm. ");
INSERT INTO bqp_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, yɑ̃ku te bɑ rɑ ko bu kɑ torɑru sɔmɛn woodɑ wee. Yɑ̃ku te, tɑ ko n sɑ̃ɑwɑ yɑ̃ku dɛɛrɑru. ");
INSERT INTO bqp_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun yɑɑ sɑke, miyɑ bɑ koo mɑɑ ten yɑɑ sɑkɑ, kpɑ bu yɑɑ yen yɛm yɛ̃kɑ yɑ̃ku yerun nɔɔ bɔkɑɔ bu kɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Yɑɑn mi bɑ koo kɑ Yinni Gusunɔ yɑ̃kuru kuɑ wee, yerɑ yen gum kpuro, kɑ yen siru kɑ bɔsɔ yɑ̃nun gum, ");
INSERT INTO bqp_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kɑ yen gɑbu swii yiru, kɑ gum mɛ mu yi tɛ̃ke yɛ̃si yɛ̃sikɑ, kɑ yen buro ge gɑ woru wukiri. ");
INSERT INTO bqp_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Yɑ̃ku kowo u koo ye kpuro dɔ̃ɔ dokewɑ yɑ̃ku yerɔ Yinni Gusunɔn sɔ̃. Yɑ̃ku te, tɑ sɑ̃ɑwɑ te tɑ koo torɑru sɔmɛ. ");
INSERT INTO bqp_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Yɑ̃ku kowo tɔn durɔ bɑɑwurewɑ u koo tu di. Bɑ koo tu diwɑ yɑm dɛɛrɑmɔ domi tɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Yen woodɑ ye, yɑ sɑ̃ɑwɑ tiɑ kɑ torɑrun yɑ̃kurugiɑ. Yɑ̃ku kowo wi u yɑ̃ku te kuɑ, wiyɑ u yen yɑɑ mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Goo ù n yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ, yɑ̃ku kowo wi u nùn tu kuɑ wiyɑ u ten gɔnɑ mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Yɑ̃ku te bɑ kuɑ kɑ gberun dĩɑnu bɑ wɔ̃ɔwɑwɑ? Aɑwo, bɑ sɔnwɑwɑ? Yɑ̃ku kowo wi u tu kuɑ wiyɑ u tu mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Adɑmɑ ni bɑ kɑ gum burinɑ kɑ ni bɑ ǹ yeesie, bɑ koo nu Aronin bibu bɔnu kuɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Siɑrɑbun yɑ̃kurun woodɑ wee. ");
INSERT INTO bqp_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀, u koo kirɑ bwesenu itɑ kowɑ. U koo gbiikinu ko kɑ gum nu kun seeyɑtiɑ mɔ, kpɑ u yirusenun som gum yɛ̃kɑ nu kun seeyɑtiɑ mɔ, kpɑ u itɑsenun som burinɑ kɑ gum u sɔmɛ. ");
INSERT INTO bqp_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kirɑ nin biru, u koo pɛ̃ɛ ye bɑ seeyɑtiɑ doke sosi mi, kɑ sere win siɑrɑbun yɑ̃kunun yɑɑ. ");
INSERT INTO bqp_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Bɑ koo yɑ̃ku dĩɑ nin bɑɑniren sukum suɑwɑ wɔllɔ bu Yinni Gusunɔ sɔ̃ɔsi. Yerɑ yɑ ko n sɑ̃ɑ wi u yɛm yɛ̃kɑginu. ");
INSERT INTO bqp_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Dɔmɑ te bɑ siɑrɑ bin yɑ̃kuru kuɑ, yen dɔmɑ terɑ bɑ koo ten yɑɑ di, bɑ ǹ koo de ten yɑɑ yu yɑm sɑ̃rɑ. ");
INSERT INTO bqp_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Adɑmɑ goo ù n yɑ̃kuru kuɑ u kɑ win nɔɔ mwɛɛru yibiɑ ǹ kun mɛ win tii ù n gɔ̃ru doke u kɑ nɛ, Yinni Gusunɔ kɛ̃ru wɛ̃, u koo kpĩ u ten yɑɑn sukum di yen tɔ̃ɔ te, kpɑ u sukum yi sere sisiru. ");
INSERT INTO bqp_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Adɑmɑ yɑ̀ n mɑɑ wure yɑ tiɑrɑ sɔ̃ɔ itɑseru bɑ koo ye dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Goo ù n siɑrɑbun yɑ̃ku yɑɑ ye yɑ tiɑrɑ sere sɔ̃ɔ itɑ temɑ, Gusunɔ kun mɑɑ yɛ̃ron yɑ̃ku te mwɑɑmɔ. U win yɑ̃kuru gɑrisiwɑ mi kɑm domi yɑɑ ye, yɑ disi duurɑ. Wì u mɑɑ ye temɑ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Mɛyɑ bɑ̀ n mɑɑ kɑ yɑ̃ku yɑɑ gɑ̃ɑnu bɑbɑ ni nu disi mɔ, bɑ koo ye dɔ̃ɔ mɛniwɑ, bɑ ǹ ye dimɔ. Wi u kun disi mɔ, wiyɑ koo yɑ̃ku yɑɑ tem, ");
INSERT INTO bqp_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ɑdɑmɑ goo ù n wɑ̃ɑ disi gɛɛ sɔɔ u kɑ siɑrɑbun yɑ̃kuru dimɔ te bɑ Yinni Gusunɔ kuɑ, bɑ koo yɛ̃ro girɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Goo ù n mɑɑ tɔnu bɑbɑ wi u disi mɔ, ǹ kun mɛ yɑɑ gɑɑ ye yɑ sɑ̃ɑ seseru, ǹ kun mɛ gɑ̃ɑnu gɑnu ni nu disi mɔ, mɑ u kɑ siɑrɑbun yɑ̃kuru di te bɑ Yinni Gusunɔ kuɑ bɑ koo yɛ̃ro girɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bu ku yɑɑ gɑɑn gum di nge yɑ̃ɑru ǹ kun mɛ kɛtɛ, ǹ kun mɛ boo. Bu ku yen gɑɑn gum di. ");
INSERT INTO bqp_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Sɑbe te gbeeku yɑɑ yɑ go, ǹ kun mɛ te tɑ gu, i ko i kpĩ i kɑ ten gum gɑ̃ɑnu ko. Adɑmɑ i ǹ mu dimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Goo ù n yɑ̃kurun yɑɑn gum di mɛ bɑ kɑ Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ, bɑ koo yɛ̃ro girɑwɑ wigibun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","I ku gunɔ gɑgun yɛm di ǹ kun mɛ yɑɑ gɑɑ, bɑɑ mi i dɑ kpuro. ");
INSERT INTO bqp_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Wi u mu di, bɑ koo yɛ̃ro girɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ɑ Isirelibɑ woodɑ yeni wɛ̃ɛyɔ ɑ nɛɛ, goo ù n nɛ Yinni Gusunɔ siɑrɑbun yɑ̃kuru kuɑmmɛ, u koo wunɑwɑ ye yɑ sɑ̃ɑ nɛgiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Win tiiwɑ u koo kɑ nɛ, Yinni Gusunɔ yen gum kɑ yen guro guroru nɑɑwɑ u kpɑrɑ nɛn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Yɑ̃ku kowowɑ u koo yen gum mɛ dɔ̃ɔ doke yɑ̃ku yerɔ. Adɑmɑ yɑɑ guro guro te, tɑ ko n sɑ̃ɑwɑ Aroni kɑ win bibugiru. ");
INSERT INTO bqp_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Yɑ̃ku yɑɑ yen nɔmu nɔm geuguu gɑ ko n mɑɑ sɑ̃ɑwɑ Aroni kɑ win bibuguu. ");
INSERT INTO bqp_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Yɑɑ nɔmu ge, gɑ ko n sɑ̃ɑwɑ Aronin biiguu wi u yɛm yɛ̃kɑ mɑ u yɑɑ gum mɛ doke yɑ̃ku yerɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Yɑɑ nɔmu ge, ge bɑ mɑn sɔ̃ɔsi, kɑ yen guro guro te bɑ kpɑrɑ nɛn wuswɑɑɔ sɑnɑm mɛ bɑ siɑrɑbun yɑ̃kuru mɔ̀ mi, yerɑ yɑ ko n dɑ n sɑ̃ɑ Aroni kɑ win bibugiɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu sɔɔ, yeniwɑ yɑ ko n sɑ̃ɑ Aroni kɑ win bibugiɑ dɔmɑ tèn di bɑ koo bu gum tɑ̃re bu kɑ ko yɑ̃ku kowobu. ");
INSERT INTO bqp_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Woodɑ yerɑ Yinni Gusunɔ u Isirelibɑ wɛ̃ɛmɔ bu kɑ Aroni kɑ win bibu yɑɑ ye wɛ̃ sɑɑ dɔmɑ tèn di bɑ bu gum tɑ̃re bu kɑ ko yɑ̃ku kowobu. Bɑ ko n dɑ bu ye kuewɑ sere kɑ ben bibun bweserɔ. ");
INSERT INTO bqp_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Nge mɛyɑ bɑ ko n dɑ ko bɑ̀ n yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru mɔ̀, ǹ kun mɛ bɑ̀ n yɑ̃kuru mɔ̀ kɑ gberun dĩɑnu, ǹ kun mɛ bɑ̀ n torɑrun yɑ̃kuru mɔ̀, ǹ kun mɛ bɑ̀ n yɑ̃kuru mɔ̀ te bɑ rɑ kɑ torɑru sɔmɛ, ǹ kun mɛ te bɑ rɑ ko bu kɑ tɔnu gum tɑ̃re u sere sɔmburu tore, ǹ kun mɛ bɑ̀ n siɑrɑbun yɑ̃kuru mɔ̀. ");
INSERT INTO bqp_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yinni Gusunɔwɑ u Mɔwisi woodɑ yeni wɛ̃ gbɑburɔ, Sinɑin guurɔ, tɔ̃ɔ te u bu woodɑ wɛ̃ bu kɑ nùn yɑ̃kunu kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","ɑ Aroni kɑ win bibu sokuo Yinni Gusunɔn kurun kɔnnɔwɔ. Kpɑ ɑ de bu kɑ ben yɑ̃ku yɑ̃nu nɑ kɑ gum mɛ bɑ rɑ gɑ̃ɑnu tɑ̃re bu kɑ nu gɔsi Yinni Gusunɔn sɔ̃ kɑ nɑɑ kinɛ te bɑ koo kɑ torɑrun yɑ̃kuru ko kɑ yɑ̃ɑ kinɛnu yiru kɑ bire te tɑ pɛ̃ɛ mɔ ye bɑ ǹ seeyɑtiɑ doke. A mɑɑ Isirelibɑ kpuro mɛnnɔ mi. ");
INSERT INTO bqp_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mɑ Mɔwisi u Yinni Gusunɔn gɑri yi wurɑ u Isirelibɑ kpuro mɛnnɑ sɑ̃ɑ yee ten kɔnnɔ mi. ");
INSERT INTO bqp_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mɑ u bu sɔ̃ɔwɑ u nɛɛ, wee ye Yinni Gusunɔ u geruɑ su ko. ");
INSERT INTO bqp_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mɑ u derɑ Aroni kɑ win bibu bɑ nɑ u bu woburɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Mɑ u Aroni win tɑko sebusiɑ kɑ sɛ̃kɑtiɑ ye, kɑ yɑbe boogugii te, kɑ yɑbe tɑrɑkpe ge, ge u gbinisi yɑbe boogugii te sɔɔ kɑ gen sɛ̃kɑtiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Mɑ u bɔɔ bɑrɑ ye sɔndi win tororu wɔllɔ. Mɑ u urimu kɑ tumimu doke bɔɔ bɑrɑ yen sɔɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Mɑ u dɑwɑni ye bɔkuɑ win wirɔ. Mɑ u wurɑn bɑtɑni ye mɑni nge mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mɔwisi u gum mɛ suɑ u sɑ̃ɑ yee te yɛ̃kɑ kɑ ten dendi yɑ̃nu kpuro, mɑ tɑ kuɑ nɛnɛm Yinni Gusunɔn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Mɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru yɑ̃ku yerun wɔllɔ, kɑ ten dendi yɑ̃nɔ kɑ boo sii gɑnduguu ge, kɑ gen yɔ̃rɑtiiyɔ, ye kpuro yɑ n kɑ sɑ̃ɑ Gusunɔn kuu bekurugirugiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Mɑ u Aroni gum mɛ tɑ̃re wirɔ u kɑ nùn wunɑ nɛnɛm u ko yɑ̃ku kowo. ");
INSERT INTO bqp_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Yen biru Mɔwisi u mɑɑ Aronin bibu sokɑ u bu tɑkobɑ dokeɑ kɑ sɛ̃kɑtii kɑ furɔsu nge mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mɔwisi u mɑɑ kɑ nɑɑ kinɛru nɑ te bɑ koo kɑ torɑrun yɑ̃kuru ko. Mɑ Aroni kɑ win bibu bɑ ben nɔmɑ sɔndi nɑɑ kinɛ ten wiru wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mɑ Mɔwisi u ye sɑkɑ u yen yɛm dɛkɑ kɑ win niki biɑ u tɛɛni yɑ̃ku yerun kɑ̃ɑnu wɔllɔ kɑ sere mɑɑ ten nɔɔ bɔkɑɔ u kɑ sikerenɑ. Nge mɛyɑ u kɑ kuu te dɛɛrɑsiɑ. Mɑ u mɑɑ yɛm yɛ̃kɑ kuu ten temɔ. Nge mɛyɑ u kɑ kuu te kuɑ nɛnɛm tèn mi bɑ ko n dɑ torɑnun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mɑ u yen gum mɛ suɑ mɛ mu bɔsɔ yɑ̃nu tɛ̃ke kɑ yen buro ge gɑ woru wukiri kɑ yen gɑbu swii yiru ye, kɑ yin gum sɑnnu. Ye kpurowɑ u dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Adɑmɑ u nɑɑ kinɛ ten tii kɑ ten bisu kɑ ten gɔnɑ yɑrɑwɑ tɔɔwɔ u dɔ̃ɔ doke nge mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","U mɑɑ kɑ yɑ̃ɑ kinɛru nɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun sɔ̃. Mɑ Aroni kɑ win bibu bɑ ben nɔmɑ sɔndi yɑ̃ɑ ten wiru wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mɑ Mɔwisi u tu sɑkɑ u ten yɛm yɛ̃kɑ u kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Mɑ u yɑ̃ɑ ten yɑɑ bɔɔrɑ, yen biru u ten wiru dɔ̃ɔ doke kɑ ten gum kɑ yɑɑ ye u mururɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Mɑ u ten nuki kɑ ten kɔ̃ri teɑ kɑ nim. Mɑ u yɑ̃ɑ kinɛ ten yɑɑ doke dɔ̃ɔ sɔɔ yɑ̃ku yeru wɔllɔ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ nge mɛ Yinni Gusunɔ u geruɑ. Mɑ yɑ̃ku ten nuburɑ Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Yen biru u mɑɑ kɑ yɑ̃ɑ kinɛru yiruse nɑ te bɑ koo kɑ Aroni kɑ win bibu tusiɑ mɑ bɑ sɑ̃ɑ yɑ̃ku kowobu. Aroni kɑ win bibu bɑ ben nɔmɑ sɔndi yɑ̃ɑ ten wiru wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mɑ Mɔwisi u tu sɑkɑ, u ten yɛm suɑ u tɛɛni Aronin soo nɔm geuguuɔ kɑ nɔm geun niki bii bɑkɑɔ kɑ mɑɑ win nɔɔ nɔm geuguun niki bii bɑkɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mɑ u mɑɑ Aronin bibu sokɑ u bu yɑɑ yɛm mɛ tɛɛni ben soo nɔm geugisɔ, kɑ mɑɑ nɔm geun niki bii bɑkɑnɔ kɑ ben nɑɑ nɔm geugisun niki bii bɑkɑnɔ. Mɑ u yɛm mɛ mu tie yɛ̃kɑ yɑ̃ku yee ten nɔɔ bɔkɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Mɑ u yen gum suɑ kɑ yen siru kɑ yen nukin gum kɑ yen buro kɑ yen gɑbu swii kɑ sere yen nɔm geu. ");
INSERT INTO bqp_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Mɑ u pɛ̃ɛ suɑ bireru sɔɔ ye bɑ ǹ seeyɑtiɑ doke kɑ kirɑ te bɑ kuɑ kɑ gum kɑ sere mɑɑ kirɑ sɔndɑnu. Mɑ u ye kpuro sɔndi yɑɑ gum mɛn wɔllɔ kɑ yɑ̃ɑ nɔmu gen wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Yen biru u ye Aroni kɑ win bibu wɛ̃. Mɑ u nɛɛ, bu ye Yinni Gusunɔ wɛ̃ɛyɔ. Kpɑ bu ye sɔ̃ɔsi beri berikɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Yen biru u ye kpuro mwɑ ben nɔmɑn di u dɔ̃ɔ mɛni yɑ̃ku dɔ̃ɔ mwɑɑrɑrugii ten wɔllɔ. Mɑ yen nuburɑ Yinni Gusunɔ dore. Nge mɛyɑ bɑ kɑ Aroni kɑ win bibu wunɑ nɛnɛm. ");
INSERT INTO bqp_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mɑ Mɔwisi u yɑ̃ɑ ten guro guroru suɑ u tu sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. Mɑ tɑ kuɑ Mɔwisigiru nge mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mɔwisi u gum mɛ suɑ kɑ yɛm fiiko mɛ mu wɑ̃ɑ yɑ̃ku yeru wɔllɔ, mɑ u mu Aroni yɛ̃kɑ kɑ win sɑ̃ɑ yɑ̃nɔ kɑ sere mɑɑ win bibun wɔllɔ kɑ ben sɑ̃ɑ yɑ̃nu sɔɔ. Nge mɛyɑ u kɑ ye kpuro dɛɛrɑsiɑ u yi nɛnɛm. ");
INSERT INTO bqp_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mɑ Mɔwisi u Aroni kɑ win bibu sɔ̃ɔwɑ u nɛɛ, i yɑ̃ku yɑɑ ye sɑɑwo Yinni Gusunɔn wuswɑɑɔ. Miyɑ i ko i ye di kɑ pɛ̃ɛ ye yɑ wɑ̃ɑ bire te sɔɔ. Bɛɛyɑ i ko ye di nge mɛ Yinni Gusunɔ u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Yɑɑ kɑ pɛ̃ɛ ye yɑ tiɑrɑ, i ko ye kpuro dokewɑ dɔ̃ɔ sɔɔ yu dɔ̃ɔ mwɑɑrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","I ko i n wɑ̃ɑwɑ kuu ten kɔnnɔ mi sere sɔ̃ɔ nɔɔbɑ yiru. I ǹ yɑriɔ min di. Domi sɔ̃ɔ nɔɔbɑ yiruwɑ i ko i ko bɑ n bɛɛ tusiɑmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Yinni Gusunɔwɑ u yenin woodɑ wɛ̃ i n dɑ ko nge mɛ i wɑ sɑ kuɑ gisɔ i kɑ bɛɛn torɑnun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ǹ n mɛn nɑ, i ko i sinɑwɑ kuu ten kɔnnɔ mi sere sɔ̃ɔ nɔɔbɑ yiru, wɔ̃kuru kɑ sɔ̃ɔ sɔɔ. Kpɑ i win woodɑbɑ mɛm nɔɔwɑ i ku rɑ kɑ gbin sɔ̃. Woodɑ be Yinni Gusunɔ u mɑn wɛ̃ berɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Mɑ Aroni kɑ win bibu kpuro bɑ kuɑ ye Yinni Gusunɔ u bu yiire sɑɑ Mɔwisin min di. ");
INSERT INTO bqp_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sɔ̃ɔ nɔɔbɑ itɑse, Mɔwisi u Aroni kɑ win bibu sokɑ kɑ sere Isirelibɑn guro gurobu. ");
INSERT INTO bqp_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","U Aroni sɔ̃ɔwɑ u nɛɛ, ɑ nɑɑ kinɛ kpɛndu suo ɑ kɑ yɑ̃kuru ko wunɛn torɑrun sɔ̃, kpɑ ɑ yɑ̃ɑ kinɛru kɑsu ɑ kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. A ǹ kɑɑ de yen gɑɑ yɑ n ɑlebu mɔ. Kpɑ ɑ kɑ ye kpuro Yinni Gusunɔ yɑ̃kuru kuɑ sɑ̃ɑ yerɔ. ");
INSERT INTO bqp_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Yen biru kɑɑ Isirelibɑ sɔ̃ ɑ nɛɛ, bu boo kinɛru suo ben torɑrun yɑ̃kurun sɔ̃ kɑ nɑɑ buu kɑ yɑ̃ɑru ye kpuro yɑ n wɔ̃ɔ tiɑ tiɑ mɔ, kpɑ yɑ kun ɑlebu gɑɑ mɔ. Bɑ koo kɑ ye yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Kpɑ ɑ mɑɑ kɑ nɑɑ kinɛru kɑ yɑ̃ɑ kinɛru nɑ bu kɑ siɑrɑbun yɑ̃kuru ko Yinni Gusunɔn mi, kɑ som mɛ bɑ burɑ kɑ gum. Domi Yinni Gusunɔ u koo bɛɛ kure mi gisɔ. ");
INSERT INTO bqp_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Bɑ kɑ ye kpuro nɑ kuu ten mi ye Mɔwisi u bikiɑ. Mɑ be kpuro bɑ nɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mɔwisi u nɛɛ, i koowo ye Yinni Gusunɔ u geruɑ. Kpɑ u de win yiiko yu bɛɛ kure. ");
INSERT INTO bqp_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mɔwisi u Aroni sɔ̃ɔwɑ u nɛɛ, ɑ susimɑ yɑ̃ku yeru mini, kpɑ ɑ wunɛn tiin torɑrun yɑ̃kuru ko kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru. Yen biru kpɑ ɑ mɑɑ wunɛn tɔmbu Isirelibɑn torɑnun yɑ̃kuru ko nge mɛ Yinni Gusunɔ u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Mɑ Aroni u susi yɑ̃ku yee ten bɔkuɔ. Mɑ u nɑɑ kinɛ kpɛm te go win torɑrun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Mɑ win bibɑ nùn yen yɛm wɛ̃. Mɑ u mu dɛkɑ kɑ niki biɑ u tɛɛni sɑ̃ɑ yerun kɑ̃ɑnu sɔɔ, mɑ u mɛ mu tie wisi yɑ̃ku yee ten temɔ. ");
INSERT INTO bqp_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Yen biru u yɑɑ yen gum suɑ u dɔ̃ɔ doke kɑ yen gɑbu swii yiru kɑ yen buro ge gɑ woru wukiri nge mɛ Yinni Gusunɔ u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Adɑmɑ yen yɑɑ kɑ yen gɔnɑ, tɔɔwɔwɑ u dɑ u ye dɔ̃ɔ doke. ");
INSERT INTO bqp_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Yen biru Aroni u yɑ̃ɑ te sɑkɑ bu kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. Mɑ win bibɑ ten yɛm suɑ bɑ nùn wɛ̃. Mɑ u mu yɛ̃kɑ u kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yen biru bɑ yɑ̃ɑ ten yɑɑ bɔɔrɑ bɑ Aroni wɛ̃ kɑ ten wiru. Mɑ u ye kpuro dɔ̃ɔ doke. ");
INSERT INTO bqp_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","U ten nuki teɑ kɑ ten kɔ̃ri u sɔndi yɑ̃ku dɔ̃ɔ mwɑɑrɑrugii ten wɔllɔ u dɔ̃ɔ doke. ");
INSERT INTO bqp_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Yen biru u Isirelibɑn yɑ̃kunu kuɑ. U boo ge sɑkɑ ge bɑ koo kɑ yɑ̃kuru ko tɔmbun torɑnun sɔ̃ mɑ u kuɑ nge mɛ u rɑɑ yɑ̃ku gbiikii te kuɑ kɑ nɑɑ kinɛ kpɛmbu ge. ");
INSERT INTO bqp_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Yen biru u yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ nge mɛ woodɑ yɑ geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Mɑ u gberun dĩɑnu suɑ u kɑ yɑ̃kuru kuɑ. U som nɔm kureru suɑ u dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ bururu bɑɑteren yɑ̃ku dɔ̃ɔ mwɑɑrɑrugii te bɑɑsi. ");
INSERT INTO bqp_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","U kɛtɛ ye kɑ yɑ̃ɑ kinɛ te sɑkɑ bɑ kɑ siɑrɑbun yɑ̃kuru kuɑ Isirelibɑn sɔ̃. Mɑ win bibu bɑ nùn yen yɛm wɛ̃ u kɑ mu yɛ̃kɑ yɑ̃ku yerun nɔɔ bɔkɑɔ u kɑ sikerenɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mɑ bɑ mɑɑ nùn kɛtɛ yen gum wɛ̃ kɑ yɑ̃ɑ ten siru kɑ mɑɑ ten gum mɛ mu ten bɔsɔ yɑ̃nu tɛ̃ke kɑ sere mɑɑ ten gɑbu swii kɑ mɑɑ ten buro ge gɑ woru wukiri. ");
INSERT INTO bqp_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Mɑ u yɑɑ yen gum sɔndi yen guro gurorun wɔllɔ. Yen biru u gum mɛ dɔ̃ɔ doke yɑ̃ku yeru wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mɑ Aroni u yɑɑ yen guro guro ni suɑ kɑ yen nɔm geu ge, u sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ nge mɛ Mɔwisi u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sɑnɑm mɛ Aroni u torɑnun yɑ̃kunu kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu kɑ siɑrɑbun yɑ̃kunu kuɑ u kpɑ, yerɑ u nɔmɑ suɑ wɔllɔ u Isirelibɑ domɑru kuɑ. Yen biru u sɑrɑ yɑ̃ku yerun di. ");
INSERT INTO bqp_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mɔwisi kɑ Aroni bɑ duɑ kuu ten mi. Ye bɑ yɑrɑ, mɑ bɑ tɔmbu domɑru kuɑ. Sɑɑ yerɑ Yinni Gusunɔ u bu win yiikon girimɑ sɔ̃ɔsi. ");
INSERT INTO bqp_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mɑ dɔ̃ɔ yɑri yɑrɑ win wuswɑɑn di yi dɑ yi yɑ̃ku dɔ̃ɔ mwɑɑrɑrugii te mwɑ kɑ yɑ̃ku ni nu tien yɑɑ gum mɛ. Mɑ Isirelibɑ kpuro bɑ ye wɑ. Mɑ bɑ nuku dobun kuuki wɔri bɑ yiirɑ sere temɔ. ");
INSERT INTO bqp_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aronin bibu Nɑdɑbu kɑ Abihu ben bɑɑwure u win dɔ̃ɔ gurɑtiɑ suɑ bɑ dɔ̃ɔ gure, mɑ bɑ turɑre doke mi. Yen biru bɑ kɑ Yinni Gusunɔ dɑɑwɑ kuu bekurugirɔ. Nge mɛyɑ bɑ kɑ dɔ̃ɔ tuko dɑ kuu ten mi. N deemɑ Yinni Gusunɔ u bu ye yinɑri. ");
INSERT INTO bqp_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Yerɑ u derɑ dɔ̃ɔ u yɑrɑ u bu di mɑ bɑ gu mi. ");
INSERT INTO bqp_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mɑ Mɔwisi u Aroni sɔ̃ɔwɑ u nɛɛ, Yinni Gusunɔ u ǹ dɑɑ bɛɛ sɔ̃ɔwɑ u nɛɛ, u kĩwɑ be bɑ nùn susimɔ bu win dɛɛrɑru nɑsiɑ, kpɑ bu nùn bɛɛrɛ wɛ̃ tɔmbu kpuron wuswɑɑɔ? Mɑ Aroni u win nɔɔ mɑri. ");
INSERT INTO bqp_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mɑ Mɔwisi u Misɑɛli kɑ Elisɑfɑni Usiɛlin bibu sokɑ. Usiɛli wi, u sɑ̃ɑwɑ Aronin tundon wɔnɔn bii. Mɔwisi u bu sɔ̃ɔwɑ u nɛɛ, i nɑ i bɛɛn wɔnɔbun gonu suɑ kuu ten min di i kɑ nu dɑ sɑnsɑnin biruɔ. ");
INSERT INTO bqp_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Mɑ bɑ nɑ bɑ goo ni suɑ kɑ nin tɑkobɑ sɑnnu bɑ kɑ dɑ sɑnsɑnin biruɔ nge mɛ Mɔwisi u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mɑ Mɔwisi u Aroni kɑ win bibu yiru be bɑ tie Eleɑsɑɑ kɑ Itɑmɑɑ sɔ̃ɔwɑ u nɛɛ, i ku bɛɛn winu deri diinu, i ku mɑɑ bɛɛn yɑ̃nu gɛ̃ɛku nuku sɑnkirɑnun sɔ̃ kpɑ Gusunɔ u ku rɑɑ bɛɛ go kpɑ u kɑ Isirelibɑ mɔru ko. Adɑmɑ i de bɛɛn mɛro bisibu Isirelibɑ bu swĩ be dɔ̃ɔ u din sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Bɛɛn tii i ku doonɑ kuu ten kɔnnɔn di kpɑ i ku rɑ kɑ gbin sɔ̃. Domi gum mɛ bɑ bɛɛ tɑ̃re mi, mu bɛɛ kuɑwɑ mi Yinni Gusunɔn yɑ̃ku kowobu. Mɑ Aroni kɑ win bii be, bɑ kuɑ ye Mɔwisi u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yinni Gusunɔ u Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","11","ɑ ǹ kɑɑ tɑm bɔɔbɔm gɑm nɔ wunɛ kɑ wunɛn bibu ì n dɔɔ nɛn kuu bekurugirɔ, kpɑ i ku rɑ kɑ gbin sɔ̃. Kpɑ i kɑ kpĩ i wunɑnɑ ye yɑ sɑ̃ɑ sɑ̃ɑrugiɑ kɑ ye yɑ ǹ sɑ̃ɑ sɑ̃ɑrugiɑ. Mɛyɑ i ko i mɑɑ kpĩ i wunɑnɑ ye yɑ dɛɛre kɑ ye yɑ ǹ dɛɛre. Mɛyɑ i ko i mɑɑ kpĩ i Isirelibɑ Gusunɔn woodɑbɑ kpuro sɔ̃ɔsi ye u Mɔwisi wɛ̃. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɛɛn bibun bweserɔ. ");
INSERT INTO bqp_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mɔwisi u Aroni kɑ win bibu yiru be bɑ nùn tie, Eleɑsɑɑ kɑ Itɑmɑɑ sɔ̃ɔwɑ u nɛɛ, i som mɛ suo mɛ bɑ kɑ yɑ̃kunu kuɑ mu tiɑrɑ. Kpɑ i kɑ mu pɛ̃ɛ ko ye i kun seeyɑtiɑ doke. Kpɑ i ye di yɑ̃ku yerun bɔkuɔ. Domi nu kuɑwɑ mi dĩɑ dɛɛrɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","I ko ye diwɑ yɑm dɛɛrɑm sɔɔ. Yerɑ yɑ ko n sɑ̃ɑ wunɛ kɑ wunɛn bibugiɑ nge mɛ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mɛyɑ wunɛ kɑ wunɛn bii tɔn durɔbu kɑ tɔn kurɔbu i ko i yɑɑ nɔmu ge bɑ kpɑrɑ mi di kɑ guro guro te bɑ sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. Yerɑ yɑ ko n sɑ̃ɑ wunɛ kɑ wunɛn bibugiɑ Isirelibɑ bɑ̀ n siɑrɑbun yɑ̃kuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Isirelibɑ bɑ ko n dɑ kɑ yen nɔmu ge kɑ guro guro te nɛwɑ kɑ sere mɑɑ yɑɑ gum mɛ bɑ rɑ dɔ̃ɔ doke yɑ̃ku yerun wɔllu mi. Bɑ̀ n ye kpuro sɔ̃ɔsi beri berikɑ bɑ kpɑ, yɑ koo kowɑ wunɛ kɑ wunɛn bibugiɑ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ nge mɛ Yinni Gusunɔ u geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Yerɑ Mɔwisi u torɑrun yɑ̃ku boo ge bikiɑ. Adɑmɑ u deemɑ bɑ gu dɔ̃ɔ mɛni. Yerɑ u kɑ Aronin bibu yiru Eleɑsɑɑ kɑ Itɑmɑɑ mɔru bɑrɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","mbɑn sɔ̃nɑ i ǹ boo gen yɑɑ temɛ Yinni Gusunɔn kuru mini. Domi gɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu. Yinni Gusunɔ u bɛɛ gu wɛ̃wɑ i kɑ Isirelibɑ kpuron torɑnun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Adɑmɑ i ǹ kɑ gen yɛm duumɛ Yinni Gusunɔn kuu ten sɔɔwɔ. N deemɑ i ko i rɑɑ gen yɑɑ temwɑ kuu ten mi nge mɛ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aroni u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ yɛ̃ ye n mɑn deemɑ sɑnɑm mɛ Isirelibɑ bɑ Yinni Gusunɔ yɑ̃kuru kuɑ ben torɑnun sɔ̃ kɑ mɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru. Yen dɔmɑ te, nɑ̀ n torɑrun suurun yɑ̃ku ten yɑɑ di, yɑ koo Gusunɔ dore? Aɑwo! Yɑ ǹ Gusunɔ doremɔ. ");
INSERT INTO bqp_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mɑ Aronin wisi bi, bu Mɔwisi dore. ");
INSERT INTO bqp_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","bu Isirelibɑ sɔ̃ɔwɔ bu nɛɛ, yɛɛ yi bɑ koo kpĩ bu di wee. ");
INSERT INTO bqp_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Bɑ koo kpĩ bu yɑɑ di ye yɑ nɑɑ kɑburosu mɔ mɑ yɑ rɑ tukɑ ko. ");
INSERT INTO bqp_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Adɑmɑ bɑ ǹ yɛɛ dimɔ yi yi rɑ tukɑ ko tɔnɑ mɑ yi ǹ nɑɑ kɑburosu mɔ. Nge mɛyɑ bɑ ǹ yooyoo temmɔ yèn sɔ̃ gɑ ǹ nɑɑ kɑburosu mɔ bɑɑ mɛ gɑ rɑ tukɑ ko. Bɑ koo gu gɑrisiwɑ yɑɑ disigiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Bɑ ǹ koo yɑɑ ye bɑ mɔ̀ dɑmɑɑ tem bɑɑ mɛ yɑ rɑ tukɑ ko yèn sɔ̃ yɑ ǹ nɑɑ kɑburosu mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Mɛyɑ bɑ ǹ koo mɑɑ wukun yɑɑ tem domi gɑ ǹ nɑɑ kɑburosu mɔ bɑɑ mɛ gɑ rɑ tukɑ ko. Bɑ koo gu gɑrisiwɑ yɑɑ disigiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Mɛyɑ bɑ ǹ koo mɑɑ kurusɔ di. Gɑ nɑɑ kɑburosu mɔ ɑdɑmɑ gɑ ku rɑ tukɑ ko. Bɑ koo gu gɑrisiwɑ yɑɑ disigiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Bu ku yɛɛ yi di, bu ku mɑɑ yin gonu bɑbɑ. Bɑ koo yi gɑrisiwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Yɛɛ yi yi mɑɑ wɑ̃ɑ dɑɑnɔ kɑ nim wɔ̃kuɔ, yi yi wɑ̃ɑ nim sɔɔ gesi kpuro yi bɑ koo di wee. Yiyɑ yi yi kɛ̃ɛritii mɔ kɑ kokosu sɑnnu. ");
INSERT INTO bqp_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Adɑmɑ yi yi kun kɛ̃ɛritii mɔ kɑ kokosu sɑnnu, bɑ koo yi gɑrisiwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Bɑ ǹ koo yi di. Mɛyɑ bu ku mɑɑ yin gonu bɑbɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yɛɛ yi yi gesi wɑ̃ɑ nim wɔ̃ku sɔɔ, kɑ dɑɑnɔ, mɑ yi ǹ kɛ̃ɛritii kɑ koko si mɔ, bɑ koo yi gɑrisiwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Gunɔsu sɔɔ, si bɑ koo gɑrisi disigisu wee, siyɑ gunɔ bɑkeru kɑ sere mɑɑ si su rɑ swɛ̃ɛ di kɑ si su rɑ yɑɑ di ");
INSERT INTO bqp_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kɑ yɑberekunu kɑ sere si su kɑ nu weenɛ ");
INSERT INTO bqp_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kɑ gbɑnɑmgbɑɑnu kɑ mɑɑ si su kɑ nu weenɛ ");
INSERT INTO bqp_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","kɑ tɑɑtɑɑnu kɑ booro kɑ sere si su kɑ su weenɛ kɑ kɑsɑ kɑ si su kɑ ye weenɛ, ");
INSERT INTO bqp_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","kɑ booro bweseru gɑru kɑ nim kpɑkpɑyɛ, kɑ booro dɑ̃ɑ kɔ̃ɔru ");
INSERT INTO bqp_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","kɑ gunɔ gbɑmgbɑyɑku kɑ gunɔ si su rɑ swɛ̃ɛ din bweseru ");
INSERT INTO bqp_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","kɑ swɑ̃ɑ wĩɑku kɑ si su kɑ ye weenɛ kɑ kɔ̃ɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","I ku mɑɑ kɔkɔmii ni nu kɑsɑ kɑ nɑɑsu mɔ di. ");
INSERT INTO bqp_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Adɑmɑ ni sɔɔ, i ko i kpĩ i di ni nu rɑ yɔ̃ɔku tem sɔɔ ");
INSERT INTO bqp_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","nge tweɑ kɑ gbɔɔ kɑ ni nu kɑ ye weenɛ. ");
INSERT INTO bqp_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Adɑmɑ ni nu tie nu kɑsɑ kɑ nɑɑsu mɔ mi, i ku nu di. ");
INSERT INTO bqp_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Yɛɛ gɛɛ wɑ̃ɑ yìn goru tɔnu ù n bɑbɑ u koo ko disigii. U ko n disi mɔwɑ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Wi u yin goru sɔɔwɑ, u koo win yɑ̃nu teɑwɑ. Kpɑ u n wɑ̃ɑ disi sɔɔ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","28","Yɛɛ yi i ko i gɑrisi disigii yi wee. Yiyɑ yi yi ǹ nɑɑ kɑburosu mɔ kɑ yi yi ku rɑ tukɑ ko kɑ sere yi yi nɑɑsu nnɛ mɔ yi sĩimɔ kɑ nɑɑ sɛ̃nu. Wi u yin gɑɑ bɑbɑ u disi duurɑwɑ mi sere kɑ tɔ̃ɔ ten yokɑɔ. Wi u mɑɑ yin goru sɔɔwɑ u koo win yɑ̃nu teɑwɑ kpɑ u n disi mɔ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Yɛɛ yi yi kɑbirimɔ sɔɔ wee yi i ko i gɑrisi disigii. Yiyɑ gunɔ yɑntɑru kɑ gunɔ kiikiiru kɑ dɛbɑ kɑ ye yɑ kɑ ye weenɛ kpuro ");
INSERT INTO bqp_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","kɑ duurubɛɛku kɑ sureru kɑ korombɔɔru kɑ sokoro kɑ sunɔ nɑki. ");
INSERT INTO bqp_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Yi kpurowɑ i ko i gɑrisi disigii yɛɛ yi yi kɑbirimɔ sɔɔ. Wi u yin gɑɑn goru bɑbɑ u ko n disi mɔwɑ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Yin gɑɑn goru tɑ̀ n wɔri dendi yɑ̃nu sɔɔ ni bɑ kuɑ kɑ dɑ̃ɑ ǹ kun mɛ kɑ bekuru ǹ kun mɛ kɑ gɔnɑ ǹ kun mɛ kɑ sɑɑki, dendi yɑ̃ɑ ni, nu disi duurɑwɑ mi. Bɑ koo nu dokewɑ nim sɔɔ sere kɑ tɔ̃ɔ ten yokɑɔ. Yen biru nu sere dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Yen gɑɑ yɑ̀ n wekeru gɑru wɔri te bɑ kuɑ kɑ sɔndu, ye yɑ wɑ̃ɑ mi sɔɔ kpuro yɑ disi duurɑwɑ mi. Bɑ koo weke te kɔrɑwɑ. Bɑ̀ n nim doke weke te sɔɔ, mɑ nim mɛ, mu tɑ̃rɑ dĩɑnu sɔɔ ǹ kun mɛ nɔrurɑ gɑɑ sɔɔ, bɑ koo ye kpuro gɑrisiwɑ disi. ");
INSERT INTO bqp_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Bɑ̀ n nim doke weke te sɔɔ, mɑ nim mɛ, mu dɑ̃ɑre dĩɑnu sɔɔ ǹ kun mɛ nɔrurɑ gɑɑ sɔɔ, bɑ koo ye kpuro gɑrisiwɑ disi bɑɑ ǹ n weke tere sɔɔn nɑ yɑ wɑ̃ɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Mi yɑɑ yen goru tɑ wɔri kpuro gesi, doo koo yerɔ ǹ kun mɛ pɛ̃ɛ wɔ̃ɔ yerɔ, bɑ koo ye kpuro kɔsukuwɑ. Domi ye kpuro yɑ disi duurɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Yɑɑ goo te, tɑ̀ n wɔri dɔkɔ sɔɔ ǹ kun mɛ dɑɑrɔ, i ǹ ko i nim mɛ gɑrisi disi. Adɑmɑ wi u tu bɑbɑ u disi duurɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Tɑ̀ n wɔri dĩɑ bwese te bɑ koo duure sɔɔ, dĩɑ bwese te, tɑ ǹ disi duure. ");
INSERT INTO bqp_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Adɑmɑ bɑ̀ n dɑɑ dĩɑ bwese te wɑsɑn nɑ bu kɑ di, tɑ disi duurɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Yɑɑ ye bɑ rɑ di yɑ̀ n kɑ tii gu, wi u yen goru bɑbɑ, yɛ̃ro u disi duurɑwɑ mi sere n kɑ ko tɔ̃ɔ ten yokɑ. ");
INSERT INTO bqp_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Wi u yen yɑɑ temɑ ǹ kun mɛ u yen goru sɔɔwɑ, u koo win yɑ̃nu teɑwɑ kpɑ u n disi mɔ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","I ku yɛɛ yi yi kɑbirimɔn yɑɑ tem ");
INSERT INTO bqp_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","kɑ yi yi rɑ kɑ nukuru sĩ kɑ yi yi kɑbirimɔ kɑ nɑɑsu nnɛ ǹ kun mɛ yi yi nɑɑ dɑbinu mɔ. I ko ye kpuro deriwɑ mɑm mɑm. ");
INSERT INTO bqp_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","I ku de yɛɛ yin bweseru yi bɛɛ ko disigibu. ");
INSERT INTO bqp_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Domi nɛ Gusunɔ nɑ sɑ̃ɑwɑ bɛɛn Yinni. I ko i tii dɛɛrɑsiɑ kpɑ i n dɛɛre. Domi nɑ sɑ̃ɑwɑ Dɛɛro. Yen sɔ̃nɑ i ǹ ko i tii disi doke kɑ yɛɛ yi yi kɑbirimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nɛnɑ nɑ bɛɛ yɑrɑmɑ Egibitin di nɑ n kɑ sɑ̃ɑ bɛɛn Yinni. Yen sɔ̃, i de i n dɛɛre. Domi nɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Woodɑ yeni kpurowɑ nɑ yi yɛɛ kpuron sɔ̃ kɑ gunɔsu kɑ yɛɛ yi yi wɑ̃ɑ nimɔ kɑ sere yi yi kɑbirimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Yerɑ yɑ koo de i n dɑ yɑɑ wunɑnɛ ye bɑ koo kɑ yɑ̃kuru ko kɑ ye bɑ ǹ kɑ yɑ̃kuru mɔ̀. Mɛyɑ mɑɑ yɑ koo bɛɛ sɔ̃ɔsi yɑɑ ye i ko i di kɑ ye i ǹ dimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yinni Gusunɔ u Mɔwisi woodɑ wɛ̃ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, tɔn kurɔ ù n gurɑ suɑ mɑ u bii tɔn durɔ mɑrɑ, u ko n disi mɔwɑ sɔ̃ɔ nɔɔbɑ yiru nge sɑnɑm mɛ u yɑsɑ mɔ̀. ");
INSERT INTO bqp_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sɔ̃ɔ nɔɔbɑ itɑse, kpɑ bu win bii wi bɑngo kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Adɑmɑ kurɔ wi, u ko n wɑ̃ɑwɑ disi sɔɔ sɔ̃ɔ tɛnɑ kɑ itɑ kpɑm u sere dɛɛrɑ yɛm mɛ u yɑrin sɔ̃ mɑrubun sɑɑ. U ku rɑɑ sɑ̃ɑ yɑ̃nu gɑnu bɑbɑ, u ku rɑɑ mɑɑ dɑ Gusunɔn kuu bekurugirɔ sere tɔ̃ɔ te, tu kɑ turi. ");
INSERT INTO bqp_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ǹ n mɑɑ tɔn kurɔn nɑ u mɑrɑ, u ko n wɑ̃ɑwɑ disi sɔɔ ɑlusumɑ yiru. Yɑ ko n sɑ̃ɑwɑ nge sɑnɑm mɛ u yɑsɑ mɔ̀. Yen biru u koo kowɑ sɔ̃ɔ wɑtɑ kɑ nɔɔbɑ tiɑ u sere dɛɛrɑ win yɛm mɛ mu yɑrin sɔ̃ mɑrubun sɑɑ. ");
INSERT INTO bqp_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Tɔn kurɔ wi u mɑrɑ, win dɛɛrɑsiɑbun sɑɑ yɑ̀ n turɑ, u koo kɑ yɑ̃ɑru wɔ̃ɔ tiɑgiru nɑwɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. Kpɑ u totobɛrɛru ǹ kun mɛ kpɑruko suɑ u kɑ win torɑrun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Yɑ̃ku kowowɑ u koo kɑ ye yɑ̃kuru ko. Kpɑ u nùn win torɑrun suuru kɑnɑ. Sɑɑ ye sɔɔrɑ u koo dɛɛrɑ win yɛm mɛ mu yɑrin sɔ̃. Woodɑ yeniwɑ nɛ, Yinni Gusunɔ nɑ wɛ̃ɛmɔ tɔn kurɔ wi u bii mɑrɑn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ù kun yɑ̃ɑru wɑ, u koo totobɛrɛnu yiru ǹ kun mɛ kpɑrukonu yiru kɑsu. Nin teuwɑ u koo kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko kpɑ u mɑɑ kɑ teu geni torɑrun yɑ̃kuru ko. Yɑ̃ku kowowɑ u koo nùn yɑ̃ku te kuɑ. Sɑɑ ye sɔɔrɑ u koo dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","goo ù n mɔsiru mɔ wɑsi sɔɔ, ǹ kun mɛ debu, ǹ kun mɛ bɑu kpiku ge gɑ kɑ bɑrɑ disigiru weenɛ, bɑ koo kɑ yɛ̃ro dɑwɑ yɑ̃ku kowo Aronin mi ǹ kun mɛ win bibun turon mi. ");
INSERT INTO bqp_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Yɑ̃ku kowo wiyɑ u koo bɑrɑ te mɛɛri. Ù n deemɑ bɑu ge, gɑ sɑn kpikisu mɔ, mɑ gɑ wɔru mɔ, sɑɑ ye sɔɔrɑ u koo gere mɑ yɛ̃ro u bɑrɑ disigiru bɑrɔ. ");
INSERT INTO bqp_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ù n mɑɑ bɑu kpiku gɑgu mɔ mɑ gɑ ǹ wɔru mɔ, mɑ gen sɑnsu kun buriri, yɑ̃ku kowo u koo kɑ yɛ̃ro dɑwɑ diru gɑru sɔɔ u kɛnusi sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sɔ̃ɔ nɔɔbɑ yiruse, yɑ̃ku kowo ù n wɑ bɑu ge, gɑ ǹ yɑbi, u koo mɑɑ nùn kɛnusiwɑ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sɔ̃ɔ nɔɔbɑ yiruse te, yɑ̃ku kowo u koo mɑɑ nùn yɑrɑwɑ u mɛɛri. Ù n deemɑ gɑ ǹ yɑbi bɑɑmɑ, u koo yɛ̃ro sɔ̃wɑ mɑ u dɛɛre, yɑ sɑ̃ɑwɑ debu, kpɑ u win yɑ̃nu teɑ u dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Amɛn biru, debu ye, yɑ̀ n yɑbi gɔnɑ ye sɔɔ, yɛ̃ro u koo mɑɑ wurɑwɑ yɑ̃ku kowo u nùn mɛɛri. ");
INSERT INTO bqp_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Yɑ̃ku kowo wi, ù n nùn mɛɛrɑ mɑ u deemɑ yɑ yɑbi win gɔnɑ sɔɔ, u koo yɛ̃ro sɔ̃wɑ mɑ u ǹ dɛɛre, u bɑrɑ disigiru mɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Goo ù n bɑrɑ disigiru bɑrɔ, bɑ koo kɑ nùn dɑwɑ yɑ̃ku kowon mi. ");
INSERT INTO bqp_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Yɑ̃ku kowo wiyɑ u koo nùn mɛɛri. Ù n bɑu kpiku wɑ mi, mɑ bɑu gen sɑnsu buriri, mɑ gɔnɑ ye, yɑ boo kuɑ, ");
INSERT INTO bqp_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","yɑ sɑ̃ɑwɑ bɑrɑ disigii te tɑ torumɔ yɛ̃ron gɔnɑ sɔɔ. Yɑ̃ku kowo u koo yɛ̃ro gɑrisiwɑ disigii. U ǹ mɑɑ nùn kɛnusimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Adɑmɑ yɑ̃ku kowo ù n mɔsi mɔsiminu wɑ nu yɑbi yɛ̃ron gɔnɑ kpuro sɔɔ, sɑɑ win wirun di sere kɑ nɑɑsɔ, ");
INSERT INTO bqp_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","u koo yɛ̃ro gɑrisiwɑ u dɛɛre, domi win wɑsi kpuro yi bururɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Adɑmɑ dɔmɑ te bɑ boo swɑ̃ɔ wɑ win wɑsi sɔɔ, bɑ koo nùn gɑrisiwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Yɑ̃ku kowon tiiwɑ u koo nùn mɛɛri. Ù n deemɑ boo swɑ̃ɔ u wɑ̃ɑ mi, u koo nùn gɑrisiwɑ disigii, domi yɑ sɑ̃ɑwɑ bɑrɑ disigiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Adɑmɑ win wɑsi yi, yì n kɔsɑ, mɑ yi bururɑ kpuro, u koo mɑɑ dɑwɑ u yɑ̃ku kowo wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Yen biru, yɑ̃ku kowo u koo ye mɛɛriwɑ. Ù n wɑ yɑ bururɑ, sɑɑ ye sɔɔ, u koo yɛ̃ro gɑrisiwɑ u dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Goo ù n win bwisi kpɑkɑ sɔɔ ");
INSERT INTO bqp_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mɔsiru gɑru wɑ, mɑ u deemɑ tɑ buriri, ǹ kun mɛ tɑ sɔ̃ri, yɛ̃ro u koo dɑwɑ u tii sɔ̃ɔsi yɑ̃ku kowon mi. ");
INSERT INTO bqp_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Yɑ̃ku kowo wi, u koo nùn mɛɛriwɑ. Ù n deemɑ mɔsi te, tɑ wɔru mɔ, mɑ win wɑsin sɑnsu su bururɑ, sɑɑ ye sɔɔrɑ yɑ̃ku kowo u koo nùn gɑrisi disigii. Bɑrɑ disigirɑ tɑ yɑrimɔ sɑɑ bwisi kpɑkɑ yen min di. ");
INSERT INTO bqp_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Adɑmɑ yɑ̃ku kowo ù n wɑ mɑ sɑn kpikisu sɑri mɔsi ten wɔllɔ, yen biru mɔsi te, tɑ ǹ wɔru mɔ, mɑ tɑ buriri fiiko, u koo durɔ wi kɛnusiwɑ dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mɔsi te, tɑ̀ n gɔnɑ yɑbi, yɑ̃ku kowo u koo nùn gɑrisiwɑ disigii domi bɑrɑ disigirɑ tɑ nùn deemɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Adɑmɑ mɔsi te, tɑ kun yɑbi, tɑ sɑ̃ɑwɑ bwisi kpɑkɑ. Sɑɑ ye sɔɔ, yɑ̃ku kowo u koo gere mɑ yɛ̃ro kun disi mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Goo ù n dɔ̃ɔ mwɑɑrɑ mɑ yen boo kpɑkɑ sɔɔ bɑu kpiku gɑ yɑrɑ, ǹ kun mɛ bɑu sɔ̃ɔ, yɑ̃ku kowo u koo yɛ̃ro mɛɛriwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Gen sɑnsu sù n kuɑ kpikisu mɑ wɔru gɑ sɔ̃ɔsire gɔnɑ ye sɔɔ, sɑɑ ye sɔɔ bɑrɑ disigirɑ tɑ sɔ̃ɔsirɑ mi. Yɑ̃ku kowo u koo nùn gɑrisiwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Adɑmɑ yɑ̃ku kowo ù n wɑ mɑ sɑn kpikisu sɑri bɑu ge sɔɔ, gɑ ǹ mɑɑ wɔru mɔ, mɑ gɑ buriri fiiko, u koo yɛ̃ro kɛnusiwɑ dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo nùn mɛɛri. Ù n wɑ bɑu ge, gɑ yɑbi win gɔnɑ sɔɔ, u koo nùn gɑrisiwɑ disigii. Tɑ sɑ̃ɑwɑ bɑrɑ disigiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Adɑmɑ bɑu ge, gɑ kun yɑbi, mɑ gɑ bururɑ fem fem, dɔ̃ɔ mwɑɑrɑ kpɑkɑ yerɑ. Sɑɑ ye sɔɔ, yɑ̃ku kowo u koo nùn gɑrisiwɑ u dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Tɔn durɔ ǹ kun mɛ tɔn kurɔ ù n bɑu gɑgu mɔ win wirɔ, ǹ kun mɛ win tonkurorɔ, ");
INSERT INTO bqp_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","yɑ̃ku kowo u koo gu mɛɛriwɑ. Gɑ̀ n wɔru mɔ mɑ gen sɑnsu su ǹ sinum mɔ, mɑ su swɛ̃rɑmɑ nge dɔm buuru, yɑ̃ku kowo u koo yɛ̃ro gɑrisiwɑ disigii. Yɑ sɑ̃ɑwɑ wii kpɑkɑ ye yɑ wɑ̃ɑ wirɔ, ǹ kun mɛ tonkurorɔ. ");
INSERT INTO bqp_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Yɑ̃ku kowo wi, ù n wɑ yɑ wɔru mɔ, mɑ sɑn wɔ̃kusu sɑri, u koo yɛ̃ro kɛnusiwɑ dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo mɑɑ yɛ̃ro mɛɛriwɑ. Ù n deemɑ wii kpɑkɑ ye, yɑ ǹ yɑbi mɑ yɑ sɑnsu mɔ si su kɑ dɔm buuru weenɛ, mɑ su ǹ wɔru mɔ, ");
INSERT INTO bqp_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","yɛ̃ro u koo win sɑnsu kɔniwɑ. Adɑmɑ u ǹ kpɑkɑ ye kɔnimɔ. Yen biruwɑ yɑ̃ku kowo u koo mɑɑ nùn kɛnusi dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo ye mɛɛriwɑ. Wii kpɑkɑ ye, yɑ̀ kun yɑbi, mɑ yɑ ǹ tĩre yɑ gɔnɑ kere, yɑ̃ku kowo u koo nùn gɑrisiwɑ u dɛɛre. U koo win yɑ̃nu teɑ. Sɑɑ ye sɔɔ, u dɛɛrɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Adɑmɑ wii kpɑkɑ ye, yɑ̀ n dɑ̃kuru yɑbi, yɑ̃ku kowo u koo mɑɑ nùn mɛɛriwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Ù n wɑ yɑ yɑbi gɔnɑ ye sɔɔ, yɑ̃ku kowo u ǹ mɑɑ kɑsumɔ yɛ̃ro ù n sɑn dɔm buuru mɔ. U koo nùn gɑrisiwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Wii kpɑkɑ ye, yɑ̀ kun yɑbi, mɑ yen sɑnsu tĩrɑ, yɛ̃ro u bɛkurɑwɑ mi. U ǹ mɑɑ disi mɔ. Yɑ̃ku kowowɑ u koo gere mɑ u dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Tɔn durɔ goo ǹ kun mɛ tɔn kurɔ goo ù n win gɔnɑ sɔɔ bɑu kpikisu wɑ, ");
INSERT INTO bqp_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","yɑ̃ku kowowɑ u koo nùn mɛɛri. Ù n bɑusu gɑsu wɑ si su ǹ buriri sɑ̃ɑ sɑ̃ɑ, bɑu si, su ǹ sɛ̃. U koo yɛ̃ro gɑrisiwɑ u dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Goo ù kun seri mɔ wirɔ, wii kpɑrɑrugiiwɑ bɑ koo yɛ̃ro gɑrisi. U dɛɛrewɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ǹ n wuswɑɑ giɑn nɑ u ǹ seri mɔ, yɛ̃ro u sɑ̃ɑwɑ wii kpɑrɑrugii. Kɑ mɛ, yɛ̃ro u dɛɛrewɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Adɑmɑ wii kpɑrɑ te sɔɔ, bɑu gɑgu gɑ̀ n sɔ̃ɔsirɑ gɑ sɔ̃ri, bɑrɑ disigirɑ tɑ torumɔ mi. ");
INSERT INTO bqp_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Yɑ̃ku kowowɑ u koo gu mɛɛri. Ù n deemɑ wii kpɑrɑ te, tɑ bɑu kpikisu mɔ su kɑ bɑrɑ disigiru weenɛ, wi u su mɔ mi, u bɑrɑ disigiru bɑrɔwɑ mi. U ǹ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Yɑ̃ku kowo u koo nùn gɑrisiwɑ disigii win wii bɑu gen sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wi u bɑrɑ disigiru mɔ kpuro, u koo yɑ̃nu dokewɑ ni nu gɛ̃ɛre, u ku furɔ doke, kpɑ u win wuswɑɑ wukiri kpɑ u n nɔɔgiru sue u n mɔ̀, disigii, disigii. ");
INSERT INTO bqp_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","U ko n sɑ̃ɑwɑ disigii sere win bɑrɑ disigii te, tu kɑ kpe. Yen sɔ̃nɑ u ko n wɑ̃ɑ yeru mɔ bee tiɑ u n kɑ tɔmbu dɛsire. ");
INSERT INTO bqp_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","49","Bɑ̀ n disi gɔmi gɛɛ wɑ yi sɔ̃ri ǹ kun mɛ yi sɑ̃ɑ nge wuru biresu yɑ̃nu gɑnu sɔɔ, ni bɑ kuɑ kɑ yɑ̃ɑ sɑnsu ǹ kun mɛ kĩɑ si bɑ kuɑ kɑ wɛ̃ɛ dɑmgii ǹ kun mɛ yɑɑ gɔnɑ, bɑu ge, yɑ̃ku kowo u koo gu mɛɛriwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Yɑ̃ku kowo wi, ù n yɑ̃ɑ ni mɛɛrɑ u koo nu yiwɑ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Yen sɔ̃ɔ nɔɔbɑ yiruse te, u koo wure u mɑɑ yɑ̃ɑ ni mɛɛriwɑ. Ù n deemɑ disi gɔmi yi, yi yɑbi bɑɑmɑ, mɑ bɑ ǹ kpɛ̃ bu yi wĩɑ, sɑɑ ye sɔɔ, u koo nu gɑrisiwɑ yɑ̃ɑ disiginu. ");
INSERT INTO bqp_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Sɑɑ ye sɔɔrɑ yɑ̃ku kowo u koo yɑ̃ɑ ni dɔ̃ɔ mɛni. Bɑɑ bɑ̀ n nu kuɑ kɑ wɛ̃su ǹ kun mɛ kɑ wɛ̃ɛ dɑmgii ǹ kun mɛ kɑ yɑ̃ɑ sɑnsun wɛ̃ɛ ǹ kun mɛ kɑ mɑm gɔnɑ, kɑ mɛ, bɑ koo ye kpuro dɔ̃ɔ mɛniwɑ. Domi bɑ ǹ kpɛ̃ bu disi gɔmi yi wĩɑ. Dɔ̃ɔwɑ u koo ye go. ");
INSERT INTO bqp_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Adɑmɑ yɑ̃ku kowo ù n wɑ gɔmi yi, yi ǹ yɑbi yɑ̃ɑ ni sɔɔ, ");
INSERT INTO bqp_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","u koo de bu nu teɑwɑ kpɑ bu mɑɑ nu diru kɛnusi sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo wure u mɑɑ nu mɛɛriwɑ. Ù n deemɑ disi gɔmi yi ǹ kɔsɑ, yi ǹ mɑɑ yɑbi, bɑ koo yɑ̃ɑ ni gɑrisiwɑ disiginu kpɑ bu nu dɔ̃ɔ doke. Domi disi gɔmi yi, yi nu di biruɔ ǹ kun mɛ wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Adɑmɑ yɑ̃ku kowo ù n deemɑ disi gɔmi yi, yi bururɑ, u koo ye wɔkɑwɑ yɑ̃ɑ nin min di. ");
INSERT INTO bqp_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Yen biru yì n mɑɑ wurɑmɑ yɑ̃ɑ ni sɔɔ, yi ko n sɑ̃ɑwɑ disi gɔmi. Bɑ koo yɑ̃ɑ ni dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Bɑ̀ n yɑ̃nu gɑnu teɑ ni nu disi gɔmi kpiɑ, mɑ disi gɔmi yi, yi wĩɑrɑ, bɑ koo wure bu mɑɑ nu teɑwɑ bu sere nu gɑrisi nu dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Yeniwɑ yɑ sɑ̃ɑ disi gɔmin woodɑ yi yi rɑ kpi yɑ̃nu sɔɔ ye bɑ kuɑ kɑ wɛ̃su ǹ kun mɛ kɑ wɛ̃ɛ dɑmgii ǹ kun mɛ kɑ gɔnɑ. Woodɑ yerɑ yɑ koo sɔ̃ɔsi yɑ̃ɑ ni nu dɛɛre kɑ ni nu kun dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","wee nge mɛ bɑ koo kɑ tɔnu dɛɛrɑsiɑ wi u rɑɑ bɑrɑ disigiru mɔ. Bɑ koo kɑ nùn dɑwɑ yɑ̃ku kowon mi, ");
INSERT INTO bqp_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kpɑ yɑ̃ku kowo u kɑ nùn yɑri sɑnsɑnin di u nùn mɛɛri. Ù n deemɑ u bɛkurɑ, ");
INSERT INTO bqp_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","yɑ̃ku kowo u koo nùn sɔ̃wɑ ye bɑ koo kɑ nùn dɛɛrɑsiɑ. U koo gunɔminu yiru suɑ ni bɑ rɑ kɑ yɑ̃kuru ko kɑ sere dɑ̃ɑ ye bɑ mɔ̀ sɛduru kɑ wɛ̃ɛ wunɔmgii kɑ dɑ̃ɑ kiku gɑgun kɑ̃ɑsɑ ge bɑ mɔ̀ isɔpu. ");
INSERT INTO bqp_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Yɑ̃ku kowo u koo de bu gunɔ gen teu sɑkɑwɑ wekeru sɔɔ te bɑ kuɑ kɑ sɔndu te tɑ nim gem mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Yen biru u koo gunɔ ge gɑ wɑsi mi, kɑ sɛdurun dɑ̃ɑ ye, kɑ wɛ̃ɛ wunɔmgii yi, kɑ isɔpun kɑ̃ɑsɑ ye dokewɑ yɛm mɛ sɔɔ, mɛ bɑ wisi nim sɔɔ mi. ");
INSERT INTO bqp_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","U koo ye yɛ̃kɑwɑ nɔn nɔɔbɑ yiru wi bɑ koo dɛɛrɑsiɑn wɔllɔ. Yen biru u koo nùn gɑrisiwɑ u dɛɛre kpɑ u gunɔ ge yɔ̃su gu doonɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Wi u koo tii dɛɛrɑsiɑ, u koo win yɑ̃nu teɑwɑ kpɑ u win sɑnsu kɔni, kpɑ u wobure nim sɔɔ. Sɑɑ ye sɔɔrɑ bɑ koo nùn gɑrisi u dɛɛre. Yen biru, u koo kpĩ u wurɑmɑ sɑnsɑniɔ. Adɑmɑ u koo kowɑ sɔ̃ɔ nɔɔbɑ yiru tɔɔwɔ u kun due win kuu bekurugirɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo win sɑnsu kɔniwɑ kɑ win seri kɑ win toburu kɑ win nɔni burosu. Ye yɑ sɑ̃ɑ sɑnsu kpuro gesi, u koo kɔniwɑ. U koo mɑɑ win yɑ̃nu teɑwɑ kpɑ u wobure u dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sɔ̃ɔ nɔɔbɑ itɑse, u koo yɑ̃ɑnu yiru suɑ ni nu ǹ ɑlebu mɔ kɑ yɑ̃ɑ nii teeru wɔ̃ɔ tiɑgiru kɑ som kilo nɔɔbɑ nnɛ mɛ bɑ burinɑ kɑ gum kɑ sere mɑɑ gum litirin bɔnu. ");
INSERT INTO bqp_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Yɑ̃ku kowo wi u koo tɔnu wi dɛɛrɑsiɑ u koo nùn tusiɑ Yinni Gusunɔn wuswɑɑɔ kuu ten kɔnnɔwɔ kɑ mɑɑ win yɑ̃ku dĩɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Yɑ̃ku kowo u koo yɑ̃ɑ nin teeru suɑwɑ kpɑ u kɑ tu yɑ̃kuru ko te bɑ rɑ kɑ torɑru sɔmɛ kɑ sere gum litirin bɔnu ye, kpɑ u ye kpuro sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kpɑ u tu sɑkɑ yɑm dɛɛrɑm mi, mi bɑ rɑ torɑrun yɑ̃kuru kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun yɑɑ sɑke. Domi torɑrun yɑ̃ku yɑɑ kɑ ye bɑ rɑ kɑ torɑnu sɔmɛgiɑ yɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu ni nu koo ko yɑ̃ku kowoginu. ");
INSERT INTO bqp_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Yɑ̃ku kowo u koo torɑrun yɑ̃ku yɑɑ yen yɛm suɑ u tɛɛni wi u dɛɛrɑsiɑmɔn soo nɔm geuguuɔ kɑ win nɔm geun niki biɑ bɑkɑɔ kɑ sere win nɔɔ nɔm geuguun niki biɑ bɑkɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Yɑ̃ku kowo u koo mɑɑ gum litirin bɔnu ye wisiwɑ win nɔm dwɑrun nɔm wɔɔrɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kpɑ u kɑ win nɔm geun niki biɑ gum mɛ dɛkɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Yen biru, kpɑ u gum mɛ mu tie tɛɛni wi u dɛɛrɑsiɑmɔn soo nɔm geuguuɔ kɑ mɑɑ win nɔm geun niki biɑ bɑkɑɔ kɑ win nɔɔ nɔm geuguun niki biɑ bɑkɑɔ. U koo mu tɛɛniwɑ mi u rɑɑ yɛm mɛ doke. ");
INSERT INTO bqp_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kpɑ u mɑɑ mɛ mu tie win nɔmɑ sɔɔ doke yɛ̃ron wiru wɔllɔ kpɑ u nùn dɛɛrɑsiɑbun wororu koosi Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kpɑ u nùn torɑrun yɑ̃kuru kuɑ. Nge mɛyɑ u koo kɑ nùn dɛɛrɑsiɑ. Yen biruwɑ u koo yɑ̃ku dɔ̃ɔ mwɑɑrɑrugirun yɑɑ go. ");
INSERT INTO bqp_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kpɑ u ye dɔ̃ɔ doke yɑ̃ku yerɔ kɑ kɛ̃nu. Nge mɛyɑ u koo kɑ yɛ̃ro torɑrun yɑ̃kuru kuɑ kpɑ u dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Wi u bɑrɑ disigiru mɔ mɑ u ǹ dɑm mɔ u kɑ yɑ̃ku yɑɑ sɑberu wɑ, yɑ̃ɑ teerɑ u koo kɑsu u kɑ yɑ̃kuru ko te tɑ sɑ̃ɑ torɑrun sɔmbugiru. Yɑ̃ku kowo u koo kɑ tu suuru kɑnɑbun wororu ko Yinni Gusunɔn wuswɑɑɔ. Yen biru durɔ wi, u koo som kilo itɑ wɛ̃ mɛ bɑ burɑ kɑ gum kɑ sere mɑɑ gum litirin bɔnu. ");
INSERT INTO bqp_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","U koo mɑɑ kɑ kpɑrukonu yiru nɑ ǹ kun mɛ totobɛrɛnu yiru nge mɛ win wɑɑrɑ nɛ. Bɑ koo gen teu go win torɑrun suurun sɔ̃. Kpɑ bu mɑɑ kɑ teu ge gɑ tie yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Win dɛɛrɑsiɑbun sɔ̃ɔ itɑserɑ u koo kɑ ye kpuro yɑ̃ku kowo nɑɑwɑ sɑ̃ɑ yerun kɔnnɔwɔ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Yɑ̃ku kowo wi, u koo yɑ̃ɑ te mwɑ kɑ gum litirin bɔnu ye, kpɑ u ye kpuro sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Yen biru u koo yɑ̃ɑ te sɑkɑ kpɑ u ten yɛm suɑ u tɛɛni wi u rɑɑ bɑrɑ disigiru mɔn soo nɔm geuguuɔ kɑ win nɔm geun niki biɑ bɑkɑɔ kɑ sere mɑɑ win nɔɔ nɔm geuguun niki biɑ bɑkɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Yen biru yɑ̃ku kowo wi, u koo gum mɛ wie win nɔm dwɑrun nɔm wɔɔrɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Kpɑ u kɑ win nɔm geun niki biɑ gum mɛ dɛkɑ u yɛ̃kɑ nɔn nɔɔbɑ yiru Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","U koo mɑɑ gum mɛ tɛɛni wi u rɑɑ bɑrɑ disigiru mɔn soo nɔm geuguuɔ kɑ nɔm geun niki biɑ bɑkɑɔ kɑ sere win nɔɔ nɔm geuguun niki biɑ bɑkɑɔ. U koo mu dokewɑ mi u rɑɑ gesi yɛm tɛɛni. ");
INSERT INTO bqp_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Yen biru gum mɛ mu tie win nɔmɑɔ, u koo mu wisiwɑ wi u rɑɑ bɑrɑ disigiru mɔn wirɔ u sere nùn dɛɛrɑsiɑbun wororu kuɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Yen biru, u koo gunɔ gen teu go, gèn bweseru u wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Bɑ koo kɑ gen teu torɑrun suurun yɑ̃kuru ko. Teu mɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kɑ som mɛ, kɑ gum mɛ. Kpɑ yɑ̃ku kowo wi, u wi u rɑɑ bɑrɑ disigiru mɔ dɛɛrɑsiɑbun wororu kuɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Woodɑ yeniwɑ wi u bɑrɑ disigiru mɔ mɑ u ǹ dɑm mɔ u koo swĩi u kɑ dɛɛrɑsiɑbun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","sɑnɑm mɛ i ko i du Kɑnɑnin temɔ mɛ kon bɛɛ wɛ̃, nɑ̀ n derɑ disi gɔmi yi kpiɑ diru gɑru sɔɔ tè sɔɔ i wɑ̃ɑ, ");
INSERT INTO bqp_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","wi u dii te mɔ, u koo dɑwɑ u yɑ̃ku kowo sɔ̃ u nɛɛ, wee u gɑ̃ɑnu wɑɑmɔ win dirɔ nge disi gɔmi. ");
INSERT INTO bqp_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Yɑ̃ku kowo wi, u sere du u kɑ dii te mɛɛri, u koo dewɑ bu ten yɑ̃nu kpuro yɑrɑ kpɑ yɑ̃ɑ nin tii nu ku rɑɑ disi duurɑ. Yen biru u koo du kpɑ u disi gɔmi yi mɛɛri. ");
INSERT INTO bqp_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ù n deemɑ gɔmi yi sɑ̃ɑ nge wuru bekusu, ǹ kun mɛ yi sɔ̃ri, kpɑ yi n sɑ̃ɑ nge wɔru gɑnɑ ye sɔɔ, ");
INSERT INTO bqp_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","u koo yɑriwɑ kpɑ u dii te kɛnɛ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sɔ̃ɔ nɔɔbɑ yiruse, yɑ̃ku kowo u koo wurɑ diru mi. Ù n deemɑ disi gɔmi yi yɑbi dii ten gɑni sɔɔ, ");
INSERT INTO bqp_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","u koo de bu dii ten kpenu wɔɔriwɑ nìn mi disi gɔmi yi, yi kpiɑ bu kɑ nu yɑri wuun di bu kɔ̃ mi n kun dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","U koo dewɑ bu dii ten sɔɔwɔ kpuro kɛrɑ kpɑ bu yɑnim mɛ bɑ kɛrɑ mi yɑri wuun biruɔ mi n kun dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Yen biru kpɑ bu kpee kpɑɑnu kɔsire ko. Kpɑ bu wure bu dii te tɑ̃wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Amɛn biru, disi gɔmi yi, yì n mɑɑ wurɑmɑ dii te sɔɔ, ");
INSERT INTO bqp_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","yɑ̃ku kowo u koo mɑɑ sewɑ u dɑ u tu mɛɛri. Ù n deemɑ disi gɔmi yi, yi mɑɑ kpiɑ dii ten gɑni sɔɔ, sɑɑ ye sɔɔ, n ǹ mɑɑ koorɔ bu yi wĩɑ min di. Dii te, tɑ disi duurɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Bɑ koo tu surɑwɑ kpɑ bu ten kpenu kɑ dɑ̃ɑ kɑ tem gurɑ bu kɑ dɑ wuun biruɔ mi n kun dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Wi u duɑ diru mi sɑnɑm mɛ bɑ tu kɛnusi, u disi duurɑwɑ mi sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Wi u kpunɑ mi, ǹ kun mɛ u gɑ̃ɑnu di mi, u koo win yɑ̃nu teɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Sɑnɑm mɛ bɑ dii te sɔnwɑ bɑ kpɑ, yɑ̃ku kowo ù n wurɑ u kɑ tu mɛɛri, mɑ u deemɑ disi gɔmi yi sɑri, u koo dii te gɑrisiwɑ tɑ dɛɛre. Domi disi gɔmi yi, yi doonɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Bu kɑ dii ten dɛɛrɑsiɑbun woronu ko, bɑ koo gunɔsu yiru kɑsuwɑ kɑ dɑ̃ɑ ye bɑ mɔ̀ sɛduru kɑ kiku ge bɑ mɔ̀ isɔpu kɑ wɛ̃ɛ wunɔmgii. ");
INSERT INTO bqp_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","U koo gunɔ gen teu sɑkɑwɑ wekeru sɔɔ te bɑ kuɑ kɑ sɔndu tɑ nim gem mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Yen biru, u koo ge gɑ wɑsi suɑ kɑ sɛduru ye, kɑ isɔpu ye, kɑ wɛ̃ɛ wunɔmgii yi, kpɑ u ye kpuro doke gunɔ ge bɑ sɑkɑn yɛm mɛ sɔɔ, mɛ bɑ wisi nim sɔɔ mi, kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru dii te sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","U koo kɑ gunɔ gen yɛm mɛ bɑ wisi nim sɔɔ mi, disi wɔkɑ kɑ gunɔ ge gɑ wɑsi kɑ sɛduru ye, kɑ isɔpu kɑ wɛ̃ɛ wunɔmgii yi. ");
INSERT INTO bqp_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kpɑ u gunɔ ge gɑ wɑsi yɔ̃su gu doonɑ yɑkɑsɔ. Sɑɑ ye sɔɔrɑ u koo dii te dɛɛrɑsiɑbun wororu koosi kpɑ tu dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Woodɑ yenibɑrɑ bɑ ko n dɑ swĩi bɑrɑ disigiru kɑ wii kpɑkin sɔ̃ ");
INSERT INTO bqp_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","kɑ mɔsiru kɑ debu kɑ disi gɔmi yi yi rɑ kpi yɑ̃nu sɔɔ kɑ diɑ sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Woodɑ yerɑ yɑ koo sɔ̃ɔsi gɑ̃ɑ ni nu dɛɛre kɑ ni nu kun dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","i Isirelibɑ sɔ̃ɔwɔ i nɛɛ, ben goo ù n kentu kpikɑ mɔ, u kuɑwɑ mi disigii. ");
INSERT INTO bqp_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Yɑ rɑ wĩ? Yɑ ku rɑ wĩ? Kɑ mɛ, u kuɑwɑ mi disigii. ");
INSERT INTO bqp_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kpin yee tè sɔɔ u kpunɑ kpuro, tɑ disi duurɑwɑ mi, kɑ sere mɑɑ gɑ̃ɑ ni u sinɑri kpuro. ");
INSERT INTO bqp_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Wi u mɑɑ kpin yee te bɑbɑ kpuro u koo win yɑ̃nu teɑwɑ kpɑ u wobure kɑ nim. Adɑmɑ kɑ mɛ, yɛ̃ro u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Wi u mɑɑ sinɑ mi bɑrɔ wi, u sinɑ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure kɑ nim. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wi u bɑrɔ wi bɑbɑ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure kɑ nim. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Bɑrɔ wi, ù n goo yɑ̃ɑtɑm sie, yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Gɑ̃ɑ ni bɑrɔ wi, u sɔni kpuro, nu kuɑwɑ mi disiginu. ");
INSERT INTO bqp_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Gɑ̃ɑ ni u sɑkusi kpuro, wi u nu bɑbɑ yɛ̃ro u kuɑwɑ mi disigii sere kɑ yokɑɔ. Wi u mɑɑ nu sɔɔwɑ yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Wi u derɑ bɑrɔ wi, u nùn bɑbɑ, mɑ u ǹ niɛ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, yɛ̃ro u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Bɑrɔ wi, ù n dendi yɑ̃nu bɑbɑ ni bɑ kuɑ kɑ sɔndu bɑ koo nu kɔsukuwɑ. Nù n mɑɑ sɑ̃ɑn nɑ ni bɑ kuɑ kɑ dɑ̃ɑ, bɑ koo nu teɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Sɑnɑm mɛ kentu ye, yɑ wĩibu yɔ̃rɑ, u koo kowɑ sɔ̃ɔ nɔɔbɑ yiru u sere dɛɛrɑ. U koo win yɑ̃nu teɑ kpɑ u wobure kɑ nim. Sɑɑ ye sɔɔ, u dɛɛrɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sɔ̃ɔ nɔɔbɑ itɑse u koo kpɑrukonu yiru ǹ kun mɛ totobɛrɛnu yiru suɑ u kɑ dɑ Gusunɔn kurun kɔnnɔwɔ kpɑ u nu yɑ̃ku kowo wɛ̃. ");
INSERT INTO bqp_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Yɑ̃ku kowo u koo nin teu gowɑ torɑrun sɔ̃. Kpɑ u kɑ teu geni yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko kpɑ u nùn dɛɛrɑsiɑbun wororu koosi Yinni Gusunɔn wuswɑɑɔ kpɑ u dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Goon sen nim mù n yɑri, u koo woburewɑ. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Mù n yɑ̃nu gɑnu tɑ̃re, ǹ kun mɛ gɔnɑ ye bɑ rɑ wukiri, bɑ koo ye teɑwɑ kɑ nim. Adɑmɑ kɑ mɛ, yɑ ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kurɔ kɑ durɔ bɑ̀ n mɛnnɑ, be kpuro bɑ koo woburewɑ kɑ nim. Adɑmɑ kɑ mɛ, bɑ koo bu gɑrisiwɑ disigibu sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Tɔn kurɔ ù n yɑsɑ mɔ̀, bɑ koo nùn gɑrisiwɑ disigii sɔ̃ɔ nɔɔbɑ yiru. Wi u nùn bɑbɑ kpuro u kuɑwɑ mi disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kpin yee tè sɔɔ u kpunɑ kpuro, tɑ kuɑwɑ mi disigiru. Ye u mɑɑ sinɑri kpuro yɑ kuɑwɑ mi disigiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Wi u mɑɑ kurɔ win kpin yeru bɑbɑ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Goo ù n bɑbɑ ye kurɔ wi, u sinɑri, yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Gɑ̃ɑ ni nu wɑ̃ɑ win kpin yee ten wɔllɔ ǹ kun mɛ ye u sinɑrin wɔllɔ, wi u yen gɑɑ bɑbɑ, u kuɑwɑ mi disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Tɔn durɔ goo ù n kɑ nùn mɛnnɑ, mɑ win yɛm mu nùn tɑ̃re, durɔ wi, u kuɑwɑ mi disigii sere sɔ̃ɔ nɔɔbɑ yiru. Kpin yee tè sɔɔ u gesi kpunɑ tɑ mɑɑ disi duurɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Tɔn kurɔ wi u yɛm wĩimɔ, win yɑsɑn sɑɑ bɑɑsi, ǹ kun mɛ, mu wĩimɔ mu win yɑsɑn sɑɑ kerɑ, bɑ koo nùn gɑrisiwɑ disigii yɛm wĩi bin sɑɑ kpuro sɔɔ nge win yɑsɑn sɑɑ. ");
INSERT INTO bqp_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kpin yee tè sɔɔ u kpunɑ kpuro kɑ ye u sinɑri kpuro, yɑ kuɑwɑ mi disigiɑ nge sɑnɑm mɛ u win yɑsɑ mɔ̀. ");
INSERT INTO bqp_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Wi u kpin yee te bɑbɑ, ǹ kun mɛ sin yee te, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u kuɑwɑ mi disigii sere kɑ yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Sɑnɑm mɛ yɛm mɛ, mu yɔ̃rɑ u koo kowɑ sɔ̃ɔ nɔɔbɑ yiru bu sere nùn gɑrisi wi u dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Yen sɔ̃ɔ nɔɔbɑ itɑse sɔɔrɑ u koo kpɑrukonu yiru ǹ kun mɛ totobɛrɛnu yiru kɑsu kpɑ u kɑ yɑ̃ku kowo dɑɑwɑ Gusunɔn kuu ten kɔnnɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kpɑ yɑ̃ku kowo u nin teu suɑ u kɑ torɑrun suurun yɑ̃kuru ko kpɑ u mɑɑ teu geni suɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. Yen biruwɑ u koo kurɔ wi dɛɛrɑsiɑbun wororu koosi Yinni Gusunɔn wuswɑɑɔ kpɑ u dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Yinni Gusunɔ u kpɑm Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, i Isirelibɑ sɔ̃ɔwɔ i nɛɛ, bu de bu kɑ nɛn kuu te tɑ wɑ̃ɑ ben suunu sɔɔ tondɑ sɑnɑm mɛ bɑ disi mɔ kpɑ bu ku rɑɑ gbi. ");
INSERT INTO bqp_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Woodɑ yeni yɑ wɑ̃ɑwɑ kentugibun sɔ̃ kɑ wìn sen nim mu yɑri ");
INSERT INTO bqp_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kɑ tɔn kurɔ wi u yɑsɑ mɔ̀ kɑ tɔn durɔ wi u yɛm wĩimɔ win tɔn durɔrun di kɑ tɔn kurɔ wi yɛm wĩimɔ win tɔn kurɔrun di kɑ mɑɑ tɔn durɔ wi u kɑ tɔn kurɔ disigii kpunɑ. ");
INSERT INTO bqp_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aronin bii be bɑ gu Yinni Gusunɔn kurɔ yèn sɔ̃ bɑ kɑ turɑre tukɑ dɑ mi, ben gɔɔn biruwɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ɑ wunɛn mɔɔ Aroni sɔ̃ɔwɔ ɑ nɛɛ, u kun dɑ du kiri kiri kuu ten dii te tɑ dɛɛre gem gem sɔɔ mi woodɑn kpɑkororɑ wɑ̃ɑ kɑ ten wukiritiɑ kpɑ u ku rɑɑ gbin sɔ̃. Domi kpɑkoro ten wukiritiɑn wɔllɔwɑ kon tii sɔ̃ɔsi guru wii wuroru sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Dɔmɑ te u duɔ mi, u koo kɛtɛ kinɛ kpɛndu kɑsuwɑ u kɑ win torɑrun yɑ̃kuru ko. Kpɑ u mɑɑ yɑ̃ɑ kinɛru kɑsu u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Yen biru u koo win tɑko doke kpɑ u sokoto kpiribu doke kɑ sɛ̃kɑtiɑ. Ye kpuro yɑ ko n sɑ̃ɑwɑ ye bɑ kuɑ kɑ wɛ̃ɛ dɑmgii kpɑ u dɑwɑni bɔke. U koo woburewɑ u sere yɑ̃ɑ ni kpuro doke. ");
INSERT INTO bqp_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isirelibɑ bɑ koo mɑɑ boo kinɛnu yiru wɛ̃ u kɑ ben torɑnun yɑ̃kunu ko kpɑ bu nùn yɑ̃ɑ kinɛru wɛ̃ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ù n koo yɑ̃kuru tore, u koo ginɑ win tii kɑ win yɛnugibun torɑnun yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ te. ");
INSERT INTO bqp_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Yen biru kpɑ u boo kinɛnu yiru ye suɑ u kɑ dɑ Yinni Gusunɔn wuswɑɑɔ kuu ten kɔnnɔwɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Kpɑ u nu tubu tubu koosi u kɑ wɑ ge gɑ sɑ̃ɑ Yinni Gusunɔguu kɑ ge bɑ koo yɔ̃su gbɑburɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Boo ge gɑ sɑ̃ɑ Yinni Gusunɔguu, gerɑ u koo kɑ torɑrun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ge bɑ koo mɑɑ yɔ̃su gbɑburɔ, gerɑ bɑ koo kɑ torɑrun suurun wororu ko. Wɑsirɑ bɑ koo kɑ gu nɑ Yinni Gusunɔn wuswɑɑɔ bu sere gu yɔ̃su gu doonɑ gbɑburɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aroni u koo ginɑ gbiwɑ u win tiin kɛtɛ kinɛ te go win torɑnun sɔ̃ kɑ sere mɑɑ win yɛnugibuginun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Kpɑ u dɔ̃ɔ gɛ̃ɛ gurɑ sɑɑ yɑ̃ku yerun di yi bɑ yibie dɔ̃ɔ gurɑtii sɔɔ kpɑ u turɑre buuru sɔkɑ nɔm kurenu yiru kpɑ u kɑ ye kpuro du dii te tɑ dɛɛre gem gem sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","U koo turɑre ye doke dɔ̃ɔ gɛ̃ɛ yi sɔɔ Yinni Gusunɔn wuswɑɑɔ kpɑ yen wiisu su woodɑn kpɑkoro ten wukiritiɑ wukiri kpɑ u ku rɑɑ kɑ gbin sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Yen biru kpɑ u kɛtɛ yen yɛm suɑ u dɛkɑ kɑ win niki biɑ kpɑ u mu yɛ̃kɑ kpɑkoro ten wukiritiɑ sɔɔ sɔ̃ɔ yɑri yeru giɑ. Kpɑ u mɑɑ ko mɛ kpɑkoro ten wuswɑɑɔ nɔn nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Yen biruwɑ u koo mɑɑ boo ge gɑ sɑ̃ɑ Yinni Gusunɔguu mi go Isirelibɑ kpuron torɑnun sɔ̃ kpɑ u gen yɛm suɑ u kɑ dɑ dii te tɑ dɛɛre gem gem sɔɔ kpɑ u mu yɛ̃kɑ woodɑn kpɑkoro ten wukiritiɑ wɔllɔ kɑ mɑɑ ten wuswɑɑɔ nge mɛ u kuɑ kɑ kɛtɛ yen yɛm. ");
INSERT INTO bqp_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kpɑ u dii te tɑ dɛɛre gem gem dɛɛrɑsiɑbun wororu koosi u kɑ ten disi wɔkɑ yi tɑ duurɑ Isirelibɑn torɑnu kɑ ben mɛm nɔɔbu sɑrirun sɔ̃. Nge mɛyɑ u koo ko u kɑ dii dɛɛrɑ ten disi wɔkɑ, domi tɑ wɑ̃ɑ disigibun suunu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Goo kun ko n wɑ̃ɑ dii ten sɔɔwɔ sɑnɑm mɛ Aroni u koo du mi, u kɑ torɑnun yɑ̃kuru ko sere u dɑ u kɑ yɑrimɑ. U koo win tii kɑ win yɛnugibun torɑnun yɑ̃kuru ko. Yen biru kpɑ u mɑɑ Isirelibɑ kpurogiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ù n yɑriɔ, u koo dɑwɑ yɑ̃ku yerɔ kpɑ u tu dɛɛrɑsiɑbun wororu koosi. Yen biru kpɑ u kɛtɛ ye, kɑ boo gen yɛm suɑ u tɛɛni yɑ̃ku yerun kɑ̃ɑnu nnɛ yen bɑɑyere sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","U koo yɛm mɛ dɛkɑwɑ kɑ win niki biɑ u yɛ̃kɑ nɔn nɔɔbɑ yiru yɑ̃ku yee ten wɔllɔ. Nge mɛyɑ u koo kɑ tu dɛɛrɑsiɑ Isirelibɑn torɑnun di kpɑ u tu yi nɛnɛm Yinni Gusunɔn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Sɑnɑm mɛ u dii te tɑ dɛɛre gem gem dɛɛrɑsiɑ u kpɑ, kɑ dii dɛɛrɑ te, kɑ yɑ̃ku yeru, u koo de bu kɑ boo ge gɑ wɑsi mi nɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aroni u koo win nɔmɑ kpuro sɔndiwɑ boo gen wiru wɔllɔ kpɑ u Isirelibɑn torɑnu kpuro tuubɑ ko kɑ mɛm nɔɔbu sɑri te bɑ kuɑ kpuro. Kpɑ u boo ge torɑ ni kpuro sɔbi kpɑ u de goo u gu girɑ u kɑ dɑ gbɑburɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nge mɛyɑ boo ge, gɑ koo kɑ Isirelibɑ kpuron torɑnu sɔbe gu kɑ doonɑ gbɑburɔ mi goo kun wɑ̃ɑ. ");
INSERT INTO bqp_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Yen biru u koo wurɑ kuu ten mi, kpɑ u win sɑ̃ɑ yɑ̃ɑ ni u doke potiri u nu yi mi. ");
INSERT INTO bqp_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kpɑ u wobure yɑm dɛɛrɑmɔ kpɑ u win tiin yɑ̃nu doke. Yen biru kpɑ u yɑri u nɑ u yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko win tiin sɔ̃ kɑ sere mɑɑ Isirelibɑn sɔ̃. Yen biru kpɑ u torɑrun yɑ̃kuru ko win tiin sɔ̃ kɑ sere Isirelibɑn sɔ̃. Kpɑ u suuru kɑnɑbun woronu ko win tii kɑ Isirelibɑn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Yen biru kpɑ u yɑɑ yen gum dɔ̃ɔ doke yɑ̃ku yerɔ ye bɑ kɑ torɑrun yɑ̃kuru kuɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Wi u boo ge girɑ u kɑ dɑ gbɑburɔ u koo win yɑ̃nu teɑwɑ kpɑ u wobure u sere du sɑnsɑniɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kɛtɛ ye, kɑ boo gen yɛm mɛ bɑ kɑ dɑ dii te tɑ dɛɛre gem gem sɔɔ torɑnun sɔ̃, bɑ koo yen yɑɑ kɑ yen gɔni kɑ yen bisu yɑrɑwɑ ben sɑnsɑnin di bu dɔ̃ɔ doke. ");
INSERT INTO bqp_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Wi u ye kpuro dɔ̃ɔ mɛni u koo win yɑ̃nu teɑwɑ kpɑ u wobure u sere wurɑmɑ sɑnsɑniɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkuruse, i nɔɔ bɔkuo kpɑ i bɛɛn sɔmɑ deri sere kɑ sɔbɔ be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Domi tɔ̃ɔ te sɔɔrɑ bɑ koo bɛɛ torɑrun yɑ̃kuru kuɑ bu kɑ bɛɛ dɛɛrɑsiɑ. Nge mɛyɑ i ko i kɑ dɛɛrɑ bɛɛn durum kpuron di Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Tɔ̃ɔ te, tɑ koo kowɑ tɔ̃ɔ wɛ̃rɑrugiru kpɑ i n dɑ nɔɔ bɔke. Kpɑ yɑ n sɑ̃ɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Amɛn biru yɑ̃ku kowo wi bɑ gum tɑ̃re bɑ gɔsɑ u kɑ ko yɑ̃ku kowo tɔnwero win bɑɑbɑn kɔsire, wiyɑ u koo sɑ̃ɑ yɑ̃ɑ ni doke ni bɑ kuɑ kɑ wɛ̃ɛ dɑmgii. ");
INSERT INTO bqp_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Wiyɑ u ko n dɑ yɑ̃kuru ko u kɑ dii te tɑ dɛɛre gem gem dɛɛrɑsiɑ kɑ sere dii dɛɛrɑ te, kɑ yɑ̃ku yee te, kɑ yɑ̃ku kowobu kɑ sere mɑɑ Isirelibɑ kpuro. ");
INSERT INTO bqp_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. Wɔ̃ɔ tiɑ sɔɔ, bɑ ko n dɑ yɑ̃kuru kowɑ Isirelibɑ kpuron torɑnun sɔ̃ nɔn teeru. Mɑ Aroni u kuɑ kpuro ye Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ɑ Aroni kɑ win bibu kɑ sere Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, woodɑ wee ye nɛ, Yinni Gusunɔ nɑ wɛ̃ɛmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isirelibɑ sɔɔ goo ù n kĩ u sɑberu gɑru sɑkɑ sɑnsɑniɔ ǹ kun mɛ mi u wɑ̃ɑ kpuro, u koo ginɑ kɑ tu nɑwɑ nɛn kuu bekurugirun kɔnnɔwɔ u kɑ tu yɑ̃kuru ko nɛ, Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Yɛ̃ro u kun kue mɛ, bɑ koo nùn sɑbe ten yɛm bikiɑwɑ domi u yɛm yɑriwɑ mi. Sɑɑ ye sɔɔ, bɑ koo yɛ̃ro yɑrɑwɑ Isirelibɑn suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Woodɑ yeni yɑ koo dewɑ Isirelibɑ bu kɑ ben yɑɑ sɑbenu nɑ yɑ̃ku kowon mi nɛn kuu ten kɔnnɔwɔ bu go nɛ, Yinni Gusunɔn wuswɑɑɔ. Kpɑ bu ku rɑɑ tu go mi bɑ turɑ. Kpɑ tɑ n sɑ̃ɑ siɑrɑbun yɑ̃kuru. ");
INSERT INTO bqp_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Yɑ̃ku kowowɑ u koo ten yɛm mɛ yɛ̃kɑ yɑ̃ku yerɔ kuu ten kɔnnɔwɔ. Kpɑ u ten gum dɔ̃ɔ doke mɛ̀n nuburu tɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Nge mɛyɑ Isirelibɑ bɑ ǹ mɑɑ kɑ bũnu yɑ̃kuru kuɑmmɛ nìn bwɑ̃ɑrokunu nu kɑ bonu weenɛ. Yeni yɑ ko n wɑ̃ɑwɑ ben tiin sɔ̃ kɑ ben bibun bibun sɔ̃ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ǹ n mɛn nɑ, Isireli goo, ǹ kun mɛ sɔɔ goo wi u wɑ̃ɑ ben suunu sɔɔ, ù n yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru mɔ̀, ǹ kun mɛ yɑ̃kunu gɑnu, ");
INSERT INTO bqp_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mɑ u ǹ kɑ nu nɛ nɛ, Yinni Gusunɔn kurun kɔnnɔwɔ u kɑ nin yɑɑ go, bɑ koo yɛ̃ro yɑrɑwɑ ben suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Wee woodɑ ye nɛ, Yinni Gusunɔ nɑ mɑɑ wɛ̃ɛmɔ. Isireli goo, ǹ kun mɛ sɔɔ goo wi u wɑ̃ɑ ben suunu sɔɔ ù n yɛm di, bɑɑ ǹ n mɛren nɑ mu sɑ̃ɑ, nɛ, Yinni Gusunɔwɑ kon yɛ̃ro wɔrimɑ n nùn yɑrɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Domi yɛm sɔɔrɑ hunde koni kpuron wɑ̃ɑrɑ wɑ̃ɑ. Nɑ derɑ i yɛm dendimɔ yɑ̃ku yerɔ i kɑ bɛɛn torɑnun suuru wɑ. Yɛm mɛyɑ mu rɑ de tɔnu u win torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Yen sɔ̃nɑ nɑ nɛɛ, Isirelibɑn goo ǹ kun mɛ sɔɔ goo bɛɛn suunu sɔɔ u ǹ yɛm dimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Bɛɛ Isirelibɑn goo ǹ kun mɛ sɔɔ goo wi u wɑ̃ɑ bɛɛn suunu sɔɔ, ù n yɑɑ gɑɑ mwɑ tɑɑsoru sɔɔ ǹ kun mɛ gunɔ gɑgu ge bɑ rɑ di, u koo yɑɑ ye, ǹ kun mɛ gunɔ gen yɛm yɑriwɑ kpɑ u mu yɑnim wukiri. ");
INSERT INTO bqp_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Domi hunde koni ye yɑ wɑsi kpuro, yen wɑ̃ɑrɑ wɑ̃ɑwɑ yen yɛm sɔɔ. Yen sɔ̃nɑ nɑ nɛɛ, i ku hunde koni gɑɑn yɛm di. Domi yɛm sɔɔrɑ wɑ̃ɑrɑ wɑ̃ɑ. Wi u mɑɑ yinɑ u mu di, bɑ koo yɛ̃ro wunɑwɑ wigibun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Bɛɛ Isirelibɑn goo, ǹ kun mɛ sɔɔ goo wi u wɑ̃ɑ bɛɛn suunu sɔɔ, ù n yɑɑ goru di ǹ kun mɛ yɑɑ ye gbeeku yɑɑ yɑ go, yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disigii sere kɑ tɔ̃ɔ ten yokɑɔ u sere dɛɛrɑ. ");
INSERT INTO bqp_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ù kun win yɑ̃ɑ ni teye, mɑ u ǹ woburɑ, u koo win torɑrun ɑre mwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, nɛnɑ nɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","I ku rɑ ko ye bɑ rɑ ko Egibitiɔ mi i rɑɑ sinɑ. I ku mɑɑ ko ye Kɑnɑnibɑ mɔ̀ mi nɑ kɑ bɛɛ dɔɔ. I ku ben komɑnu swĩi. ");
INSERT INTO bqp_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Adɑmɑ i nɛn woodɑbɑ kɑ nɛn yiirebu mɛm nɔɔwɔ kpɑ i ye swĩi. Domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ǹ n mɛn nɑ, i nɛn gere kɑ nɛn woodɑbɑ mɛm nɔɔwɔ. Wi u ye mɛm nɔɔwɑ u ko n wɑ̃ɑwɑ yen sɔ̃. Nɛ Yinni Gusunɔwɑ nɑ yeni gerumɔ. ");
INSERT INTO bqp_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nɛnɑ nɑ woodɑ yenibɑ wɛ̃ɛmɔ. Nɑ nɛɛ, bɛɛn goo u ku rɑɑ kɑ win dusi tɔn kurɔ kɔ̃ɔ mɛnnɑ. ");
INSERT INTO bqp_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","I ku bɛɛn tundo sekuru doke i kɑ bɛɛn mɛro kɔ̃ɔ mɛnnɑ. Domi u sɑ̃ɑwɑ bɛɛn mɛro. ");
INSERT INTO bqp_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","I ku kɑ bɛɛn mɛron nisi goo kɔ̃ɔ mɛnnɑ, domi ì n kuɑ mɛ, i bɛɛn tundo sekuru dokewɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","I ku kɑ bɛɛn sesu tundo turosi ǹ kun mɛ mɛro turosi kɔ̃ɔ mɛnnɑ bɑɑ bɑ̀ kun bɛɛ seeye yɛnu teu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","I ku kɑ bɛɛn nikurɔbu kɔ̃ɔ mɛnnɑ bɑɑ ù n sɑ̃ɑn nɑ tɔn durɔn bii, ǹ kun mɛ tɔn kurɔn bii. Domi wi u kuɑ mɛ, u tii sekuru dokewɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","I ku kɑ bɛɛn tundon kurɔ goon bii kɔ̃ɔ mɛnnɑ domi u sɑ̃ɑwɑ bɛɛn sesu. ");
INSERT INTO bqp_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","I ku kɑ bɛɛn tiɔ kɔ̃ɔ mɛnnɑ, domi u sɑ̃ɑwɑ bɛɛn tundon dusi. ");
INSERT INTO bqp_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","I ku mɑɑ kɑ bɛɛn mɛron wɔnɔ ǹ kun mɛ win mɔɔ kɔ̃ɔ mɛnnɑ. Domi u sɑ̃ɑwɑ bɛɛn mɛron dusi. ");
INSERT INTO bqp_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","I ku mɑɑ bɛɛn tundon wɔnɔ ǹ kun mɛ win mɔɔ sekuru doke i kɑ win kurɔ kɔ̃ɔ mɛnnɑ. Domi kurɔ wi, u sɑ̃ɑwɑ nge bɛɛn tiin mɛro. ");
INSERT INTO bqp_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","I ku kɑ bɛɛn bigii kurɔ kɔ̃ɔ mɛnnɑ, domi u sɑ̃ɑwɑ bɛɛn biin kurɔ. ");
INSERT INTO bqp_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","I ku kɑ bɛɛn wɔnɔ ǹ kun mɛ bɛɛn mɔɔn kurɔ kɔ̃ɔ mɛnnɑ. Ì n kuɑ mɛ, i nùn sekuru dokewɑ. ");
INSERT INTO bqp_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","I ku kɑ tɔn kurɔ kɔ̃ɔ mɛnnɑ kpɑ i mɑɑ kɑ win bii kɔ̃ɔ mɛnnɑ, ǹ kun mɛ win nikurɔbu, domi bɑ sɑ̃ɑwɑ mi dusinu. Ì n kuɑ mɛ, yɑ sɑ̃ɑwɑ mi torɑ bɑkɑru. ");
INSERT INTO bqp_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","I ku bɛɛn kurɔn wɔnɔ ǹ kun mɛ win mɔɔ suɑ kurɔ sɑnɑm mɛ kurɔ win tii u wɑ̃ɑ wɑ̃ɑru sɔɔ. Domi yɑ koo nisinu mɑ. ");
INSERT INTO bqp_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","I ku kɑ tɔn kurɔ mɛnnɑ sɑnɑm mɛ u yɑsɑ mɔ̀, domi u sɑ̃ɑwɑ disigii. ");
INSERT INTO bqp_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","I ku kɑ bɛɛn winsim kurɔ kɔ̃ɔ mɛnnɑ. Ì n kuɑ mɛ, i tii disi koosiwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","I ku kɑ bɛɛn bii yɑ̃kuru ko bũu wi bɑ mɔ̀ Mɔlɔkun mi. Domi ì n kuɑ mɛ, nɛ, Yinni Gusunɔn yĩsirɑ i sɑnkɑ mi. I n yɛ̃ mɑ nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","I ku kɑ bɛɛn tɔn durɔsi kɔ̃ɔ mɛnnɑ nge mɛ i rɑ kɑ tɔn kurɔ ko. Domi yɑ sɑ̃ɑwɑ seku bɑkɑru. ");
INSERT INTO bqp_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","I ku kɑ yɑɑ sɑberu kɔ̃ɔ mɛnnɑ nge tɔn kurɔ. Domi ì n kuɑ mɛ, i tii disi dokewɑ. Nge mɛyɑ mɑɑ tɔn kurɔ goo u ku rɑɑ de yɑɑ sɑberu tu kɑ nùn mɛnnɑ. Yɑ sɑ̃ɑwɑ seku bɑkɑru. ");
INSERT INTO bqp_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","I ku de komɑ ninin bweseru nu bɛɛ ko disigibu. Domi niyɑ bwese tuku nini nu rɑ ko ni kon girɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Bɑ tem mɛn tii disi doke, mɑ nɑ mu sɛɛyɑsiɑ mɑ mu mɛn tɔmbu yɑrinɑsiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Bɛɛ Isirelibɑ kɑ bɛɛ sɔbu bɛɛ be i wɑ̃ɑ Isirelibɑ sɔɔ, i nɛn gere kɑ nɛn woodɑ ye mɛm nɔɔwɔ. Kpɑ i bwese nin komɑ sekurugii ni deri. ");
INSERT INTO bqp_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Be bɑ rɑɑ sinɑ tem mɛ sɔɔ i sere nɑ, bɑ komɑ ni kuɑ mɑ tem mɛ, mu disi duurɑ. ");
INSERT INTO bqp_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ǹ n mɛn nɑ, bɛɛn tii i ku mu disi doke kpɑ mu ku rɑɑ mɑɑ bɛɛ yɑrinɑsiɑ nge yellugibu. ");
INSERT INTO bqp_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Domi be bɑ komɑ nin gɑru sɑɑrɑ Isirelibɑ kpuro sɔɔ, bɑ koo bu wunɑwɑ ben tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nɛnɑ Gusunɔ bɛɛn Yinni. I de i nɛn gere kɑ nɛn woodɑ ye mɛm nɔɔwɑ mɑm mɑm. Kpɑ i ku bwese tuku nin komɑnu swĩi ni bɑ rɑ ko i sere tunumɑ mini. Kpɑ i ku rɑ tii disi doke. ");
INSERT INTO bqp_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ɑ Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, i de i n dɛɛre, domi nɛ Gusunɔ bɛɛn Yinni nɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Yen sɔ̃, bɛɛn bɑɑwure u win tundo kɑ win mɛro bɛɛrɛ wɛ̃ɛyɔ kpɑ u n dɑ wɛ̃re tɔ̃ɔ wɛ̃rɑrugiru sɔɔ. Nɛnɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","I ku tii bũnu wɛ̃, i ku rɑ mɑɑ bwɑ̃ɑroku gɑgu seku. ");
INSERT INTO bqp_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ì n nɛ, Yinni Gusunɔ siɑrɑbun yɑ̃kuru kuɑmmɛ, i tu koowo nge mɛ tɑ koo kɑ mɑn wɛ̃re. ");
INSERT INTO bqp_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","I ko ten yɑɑ diwɑ dɔmɑ te i kɑ ye yɑ̃kuru kuɑ ǹ kun mɛ sisiru. Adɑmɑ ye yɑ tiɑrɑ sɔ̃ɔ itɑse, i ko ye dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ì n ye di sɔ̃ɔ itɑse, nɑ ǹ yɑ̃ku te mwɑɑmɔ. Domi yɑɑ ye, yɑ disi duurɑwɑ mi. ");
INSERT INTO bqp_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Wi u ye di u koo win torɑrun ɑre wɑ, domi u ǹ ye gɑrisi nɛgiɑ. Bɑ koo yɛ̃ro wunɑwɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ì n bɛɛn dĩɑnu gɛ̃ɛmɔ, i ku gɛ̃ ye yɑ wɑ̃ɑ gbee goorɔ. I ku mɑɑ bɛɛn gberun dĩɑnu kunɔnu ko. ");
INSERT INTO bqp_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mɛyɑ i ku mɑɑ resɛm gberu sɔɔ resɛm kunɔnu ko kɑ mɑɑ resɛm ye yɑ wɔrumɑ. I ko ye deriwɑ sɑ̃ɑrobu kɑ sɔbun sɔ̃. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","I ku gbɛni, i ku mɑɑ bɛɛn winsim weesu kuɑ ǹ kun mɛ i nùn nɔni wɔ̃ke. ");
INSERT INTO bqp_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","I ku bɔ̃ri weesugii ko kɑ nɛn yĩsiru. Domi ì n kuɑ mɛ, i nɛn yĩsiru sɑnkɑwɑ. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","I ku bɛɛn winsim dɑm dɔre. I ku mɑɑ nùn gɑ̃ɑnu mwɑɑri kɑ dɑm. I ku bɛɛn sɔm kowon kɔsiɑru nɛnɛ sere yɑm mu kɑ sɑ̃rɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","I ku soso wɔmɛ. I ku mɑɑ gɑ̃ɑnu yi wɔ̃kon wuswɑɑɔ ni nu koo nùn surɑ. I de bɛɛn dɑɑ yu sɔ̃ɔsi mɑ i mɑn nɑsie nɛ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","I ku murɑfitiru ko siribu sɔɔ. I ku goon bwɛ̃ɛbwɛ̃ɛru ǹ kun mɛ win dɑm mɛɛri i kɑ nùn siri. Adɑmɑ i ko i bu siriwɑ nge mɛ bɑɑwuren gem mu nɛ. ");
INSERT INTO bqp_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","I ku gɑri weesugii kpɑrɑ bɛɛn tɔnusin sɔ̃. I ku mɑɑ nùn gɑri mɑni yi yi koo nùn go. ");
INSERT INTO bqp_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","I ku bɛɛn winsim tusi gɔ̃ruɔ. Adɑmɑ i nùn gerusio kpɑ i ku rɑ tii durum sɔbi win sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","I ku bɛɛn winsim mɔru kɔsie. I ku mɑɑ kɑ goo mɔru nɛnɛ. I bɛɛn tɔnusi kĩɔ nge bɛɛn tii. Nɛ Yinni Gusunɔwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","I de i nɛn woodɑ yenibɑ mɛm nɔɔwɑ. I ku de yɛɛ bwese bwesekɑ yu yɔɔnɑ. I ku dĩɑ bwesenu yiru duure gbee teeru sɔɔ. I ku yɑ̃nu doke ni bɑ kuɑ kɑ wɛ̃ɛ bwesenu yiru. ");
INSERT INTO bqp_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Goo ù n kɑ yoo tɔn kurɔ kɔ̃ɔ mɛnnɑ wi bɑ durɔ kɑ̃, ɑdɑmɑ bɑ ǹ ginɑ nùn yɑkie win yorun di, yɛ̃ro u koo yen gobi kɔsiɑwɑ, ɑdɑmɑ bɑ ǹ bu goomɔ. Domi kurɔ wi, u ginɑ sɑ̃ɑ yoo. ");
INSERT INTO bqp_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Durɔ win torɑrun sɔ̃, u koo kɑ yɑ̃ɑ kinɛru nɑ Yinni Gusunɔn wuswɑɑɔ win kurun kɔnnɔwɔ u kɑ torɑrun sɔmbun yɑ̃kuru ko. ");
INSERT INTO bqp_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kpɑ yɑ̃ku kowo u nùn torɑrun suurun wororu koosi nɛ Yinni Gusunɔn wuswɑɑɔ. Sɑɑ ye sɔɔrɑ u koo win torɑrun suuru wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Sɑnɑm mɛ i duɑ Kɑnɑnin temɔ i kpɑ, mɑ i dɑ̃ɑ bwese bwesekɑ duurɑ, i ko yen mɑrum gɑrisiwɑ disigim, wɔ̃ɔ itɑ. I ǹ mu dimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Wɔ̃ɔ nnɛsen mɑrum mɛ yɑ koo mɑ, mu ko n sɑ̃ɑwɑ nɛ Yinni Gusunɔgim, i kɑ mɑn siɑrɑ tɔ̃ɔ bɑkɑrun sɑɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Sɑɑ wɔ̃ɔ nɔɔbusen diyɑ bɛɛn tii i ko i n dɑ dɑ̃ɑ mɑrum mɛ sɔri i di. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","I ku gɑ̃ɑnu gɑnu di kɑ yɛm. I ku wɛɛ ǹ kun mɛ guru wiru mɛɛri i kɑ bikiɑru ko. ");
INSERT INTO bqp_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","I ku bɛɛn wirun goo gookɑn seri kɔni bwɛɛrɛkɛ. I ku mɑɑ bɛɛn toburun beri berikɑ kɔni. ");
INSERT INTO bqp_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","I ku bɛɛn wɑsi muriri goon gɔɔn sɔ̃. I ku mɑɑ bɛɛn wɑsi yore. Nɛ, Yinni Gusunɔwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","I ku bɛɛn bii wɔndiɑbɑ sekuru doke i bu kurɔ tɑnɑru kpɛ̃ɛ sɑ̃ɑru gɑrun sɔ̃, kpɑ sɑkɑrɑru kɑ sekuru sɑriru tu ku rɑɑ yibu tem mɛ sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","I n dɑ tɔ̃ɔ wɛ̃rɑrugiru yɑɑye kpɑ i nɛn kuu bekurugiru bɛɛrɛ wɛ̃. Nɛ, Yinni Gusunɔwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","I ku dɑ be bɑ rɑ gɔribu sokun mi ǹ kun mɛ sɔrobun mi kpɑ i ku rɑ kɑ tii disi doke. Domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","I wi u seri kpiki mɔ kpuro kpunɔ kpɑ i durɔ tɔkɔ bɛɛrɛ wɛ̃. I mɑɑ nɛ, Yinni Gusunɔ nɑsio. Domi nɛnɑ nɑ sɑ̃ɑ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Sɔɔ goo ù n wɑ̃ɑ bɛɛn tem sɔɔ, i ku nùn dɑm dɔre. ");
INSERT INTO bqp_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","I ko i nùn kuɑwɑ nge kpɑɑ yɛ̃ro, kpɑ i nùn kĩɑ nge bɛɛn tii. Domi bɛɛn tii i rɑɑ sɔru di Egibitiɔ. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","I ku murɑfitiru ko siribu sɔɔ, kɑ gɑ̃ɑ yĩirubu sɔɔ, kɑ kilobɑ sɔɔ kɑ sɑkɑkunu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","I de bɛɛn kilobɑ kɑ bɛɛn sɑkɑkunu ye kpuro yɑ n sɑ̃ɑ dee dee. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye geruɑ, nɛ wi nɑ bɛɛ yɑrɑ Egibitin di. ");
INSERT INTO bqp_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","I nɛn woodɑbɑ kpuro mɛm nɔɔwɔ kpɑ i ye swĩi. Nɛ, Yinni Gusunɔwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ben goo ǹ kun mɛ sɔɔ wi u wɑ̃ɑ be sɔɔ ù n win bii suɑ u kɑ bũu wi bɑ mɔ̀ Mɔlɔku yɑ̃kuru kuɑ, bɑ koo nùn kɑsukuwɑ bu go. ");
INSERT INTO bqp_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nɛ, Yinni Gusunɔwɑ kon nùn wɔri kpɑ n nùn wunɑ nɛn tɔmbun suunu sɔɔn di yèn sɔ̃ u kɑ win bii Mɔlɔku yɑ̃kuru kuɑ mɑ u nɛn kuru disi doke u nɛn yĩsi dɛɛrɑru sɑnkɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Isirelibɑ bɑ̀ n yinɑ bu durɔ win bweseru go, mɑ bɑ nùn mɛɛrɑ u dɑɑ yen bweseru mɔ̀, ");
INSERT INTO bqp_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nɛn tiiwɑ kon nùn wɔri wi kɑ win yɛnugibu kpuro kpɑ n nùn yɑrɑ win tɔmbun suunu sɔɔn di kɑ sere be bɑ mɑɑ Mɔlɔku ye sɑ̃ɑmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Goo ù n bikiɑru dɑ gɔri sokobun mi ǹ kun mɛ sɔrobun mi, kon nùn wɔriwɑ kpɑ n nùn wunɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","I de i n dɛɛre, domi nɛn tii nɑ dɛɛre. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Nɛnɑ Yinni Gusunɔ wi u bɛɛ gɔsɑ i n kɑ dɛɛre. I ko i nɛn woodɑbɑ mɛm nɔɔwɑwɑ kpɑ i sĩ ye sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Goo ù n win tundo ǹ kun mɛ win mɛro bɔ̃rusi, bɑ koo yɛ̃ro gowɑ kpɑ win yɛm mu wɔri win tii sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Goo ù n kɑ goon kurɔ kpunɑ, bɑ koo kurɔ wi kɑ durɔ wi gowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Goo ù n kɑ win tundon kurɔ kpunɑ, u win tundo sekuru dokewɑ. Bɑ koo yɛ̃ro gowɑ kɑ kurɔ wi sɑnnu kpɑ ben yɛm mu wɔri ben tii sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Goo ù n kɑ win biin kurɔ kpunɑ, bɑ koo yɛ̃ro gowɑ kɑ kurɔ wi sɑnnu. Domi seku bɑkɑrɑ bɑ kuɑ mi. Ben yɛm mu koo wɔriwɑ ben tii sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Tɔn durɔ ù n kɑ win tɔn durɔsi kpunɑ nge mɛ bɑ rɑ kɑ tɔn kurɔ mɛnnɛ, bɑ koo be yiru ye kpuro gowɑ. Domi gɑ̃ɑ kɔ̃sunɑ bɑ kuɑ mi. Ben yɛm mu koo wɔriwɑ ben tii sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Goo ù n bii kɑ mɛro suɑ kurɔ, torɑ bɑkɑrɑ mi. Bɑ koo be kpuro dɔ̃ɔ mɛniwɑ. Kpɑ yen bweseru yɑ kun wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Goo ù n mɑɑ kɑ yɑɑ sɑberu mɛnnɑ nge mɛ bɑ rɑ kɑ tɔn kurɔ mɛnnɛ, bɑ koo yɛ̃ro gowɑ kɑ yɑɑ sɑbe ten tii. ");
INSERT INTO bqp_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Tɔn kurɔ ù n mɑɑ kɑ yɑɑ sɑberu mɛnnɑ nge mɛ bɑ rɑ kɑ tɔn durɔ mɛnnɛ, bɑ koo nùn gowɑ kɑ yɑɑ sɑbe ten tii. Kpɑ ben yɛm mu wɔri ben tii sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Goo ù n win sesu tundo turosi ǹ kun mɛ mɛro turosi suɑ kurɔ u kɑ kpunɑ, bɑ tii sekuru dokewɑ mi. Bɑ koo bu wunɑwɑ ben tɔmbun suunu sɔɔn di. Durɔ wi, u koo win torɑrun ɑre sɔbewɑ. Domi u kɑ win sesu kpunɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Goo ù n kɑ tɔn kurɔ mɛnnɑ wi u yɑsɑ mɔ̀, mɑ yen yɛm mɛ mu yɑrɑ u mu wɑ, bɑ koo be yiru ye yɑrɑwɑ Isirelibɑn suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","I ku kɑ bɛɛn mɛron wɔnɔ ǹ kun mɛ win mɔɔ ǹ kun mɛ bɛɛn tiɔ kɔ̃ɔ mɛnnɑ. Domi i sɑ̃ɑwɑ dusinu. Wi u kuɑ mɛ, u koo yen ɑre wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Goo ù n kɑ win tundon wɔnɔ ǹ kun mɛ tundon mɔɔn kurɔ kpunɑ, u bu sekuru dokewɑ. Kurɔ wi, kɑ durɔ wi, bɑ koo ben torɑnun ɑre wɑ. Bɑ ǹ bii mɑrumɔ sere bu kɑ gbi. ");
INSERT INTO bqp_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Goo ù n win wɔnɔ ǹ kun mɛ win mɔɔn kurɔ suɑ, u torɑwɑ mi. U win wɔnɔ ǹ kun mɛ win mɔɔ wi sekuru dokewɑ mi. Kurɔ wi, kɑ durɔ wi, bɑ ǹ bibu mɑrumɔ. ");
INSERT INTO bqp_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","I de i nɛn woodɑbɑ kɑ nɛn yiirebu mɛm nɔɔwɑ kpɑ i kɑ ye sɔmburu ko, kpɑ tem mi nɑ kɑ bɛɛ dɔɔ mu ku rɑɑ bɛɛ yɑrinɑsiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","I ku bwese nin komɑnu swĩi ni nɑ kon bɛɛ girɑ. Domi komɑ niyɑ bɑ kuɑ nɑ kɑ bu yinɑ. ");
INSERT INTO bqp_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Nɑ bɛɛ sɔ̃ɔwɑ nɑ nɛɛ, bɛɛyɑ i ko i n ben tem mɛ mɔ. Nɛnɑ kon bɛɛ mu wɛ̃. Tem mɛ, mu tim kɑ bom yibɑ. Nɛnɑ Gusunɔ bɛɛn Yinni nɛ wi nɑ bɛɛ wunɑ sɑɑ bwese ni nu tien di. ");
INSERT INTO bqp_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Yen sɔ̃nɑ i ko i wunɑnɑ yɑɑ ye i ko i di kɑ ye i kun dimɔ kɑ sere mɑɑ gunɔ si i ko i di kɑ si i ǹ dimɔ kpɑ i ku rɑ bɛɛn tɔmbu disi doke yɛɛ yi, kɑ gunɔ sin sɔ̃ ye nɑ gesi nɛɛ, i ku di mi. ");
INSERT INTO bqp_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I de i n dɛɛre i n wɑ̃ɑ nɛn sɔ̃, domi nɑ dɛɛre. Nɛ, Yinni Gusunɔwɑ nɑ bɛɛ wunɑ nɛnɛm bwese ni nu tien suunu sɔɔn di i n kɑ sɑ̃ɑ nɛgibu. ");
INSERT INTO bqp_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Goo ù n wɑ̃ɑ bɛɛn suunu sɔɔ, tɔn kurɔ ǹ kun mɛ tɔn durɔ mɑ u rɑ gɔribu soku ǹ kun mɛ u rɑ sɔroru ko, bɑ koo yɛ̃ro kpenu kɑsukuwɑ kpɑ win yɛm mu wɔri win tii sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, yɑ̃ku kowo u ku rɑɑ tii disi doke u wigii goon goru bɑbɑ ");
INSERT INTO bqp_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","mɑ n kun mɔ win mɛro kɑ win tundon goru kɑ win tiin biigiru kɑ win wɔnɔ kɑ win mɔɔgiru ");
INSERT INTO bqp_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kɑ sere win sesu wi u kun durɔ yɛ̃giru wi bɑ ǹ ginɑ sue. ");
INSERT INTO bqp_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Isirelibɑn suunu sɔɔ, yɑ̃ku kowo wi, u sɑ̃ɑwɑ ben guro guro. Yen sɔ̃, u ǹ koo tii disi doke kɑ ben goon goru. ");
INSERT INTO bqp_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Goo ù n gu, yɑ̃ku kowobu bu ku rɑɑ ben wii suunun seri kɔni, bu ku rɑɑ mɑɑ ben toburun beri berikɑ kɔni. ");
INSERT INTO bqp_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Mɛyɑ bu ku rɑɑ mɑɑ tii muriri wɑsi sɔɔ. Bɑ ko n wɑ̃ɑwɑ nɛ Gusunɔ ben Yinnin sɔ̃. Bɑ ǹ nɛn yĩsiru sɑnkumɔ. Domi beyɑ bɑ ko n dɑ mɑn yɑ̃kunu kue ni nu sɑ̃ɑ nɛn dĩɑnu. Yen sɔ̃, bɑ ko n dɛɛrewɑ. ");
INSERT INTO bqp_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Bɑ ǹ koo kurɔ tɑnɔ ǹ kun mɛ wi bɑ gɑbɑ bɑ kɑ kpunɑ suɑ kurɔ. Bɑ ǹ mɑɑ kurɔ wi u win durɔ yinɑ suɑmɔ. Domi bɑ ko n dɛɛrewɑ bɑ n wɑ̃ɑ nɛ, Yinni Gusunɔn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Isireli bɑɑwurewɑ u koo yɑ̃ku kowo gɑrisi tɔn dɛɛro. Domi wiyɑ u rɑ kɑ bɛɛn yɑ̃kunu nɛ, nɛ, Yinni Gusunɔn mi. Yen sɔ̃, bɑ ko n dɛɛrewɑ, domi nɛ, Yinni Gusunɔ nɑ dɛɛre. Nɛnɑ nɑ bɛɛ gɔsɑ i n kɑ mɑɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Yɑ̃ku kowo goon bii wɔndiɑ ù n tii sekuru dokemɔ u kurɔ tɑnɑru dimɔ, win tundowɑ u sekuru dokemɔ. Bɑ koo bii wɔndiɑ wi dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Yɑ̃ku kowo wi bɑ gum tɑ̃re wirɔ u kuɑ yɑ̃ku kowo tɔnwero, mɑ bɑ nùn sɑ̃ɑ yɑ̃nu dokeɑ, u ku mɑɑ win seri sɑnku goon gɔɔn sɔ̃. Mɛyɑ u ku mɑɑ win yɑ̃nu gɛ̃ɛku. ");
INSERT INTO bqp_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","U ku rɑɑ goru gɑru susi u tii disi doke, bɑɑ ǹ n win tundo ǹ kun mɛ win mɛron gorun nɑ. ");
INSERT INTO bqp_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","U ǹ mɑɑ yɑriɔ nɛn kurun di goon gorun sɔ̃, u ku kɑ kuu te disi doken sɔ̃. Domi bɑ nùn gum tɑ̃re u n kɑ sɑ̃ɑ nɛnɛm. Nɛ, Yinni Gusunɔwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Wɔndiɑ wi u kun durɔ yɛ̃wɑ yɑ̃ku kowo tɔnwero u koo suɑ kurɔ. ");
INSERT INTO bqp_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","U ǹ koo gɔmini goo suɑ kurɔ ǹ kun mɛ kurɔ wi bɑ yinɑ ǹ kun mɛ kurɔ wi bɑ gɑbɑ bɑ kɑ kpunɑ ǹ kun mɛ kurɔ tɑnɔ. Adɑmɑ wɔndiɑ wi u kun durɔ yɛ̃wɑ u koo suɑ win dusibu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Kpɑ u ku rɑɑ bwese tukuru doke win bweseru sɔɔ. Nɛ Yinni Gusunɔwɑ nɑ nùn gɔsɑ u n kɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, bɑɑ kɑ win bibun bweserɔ goo ù n ɑlebu gɑɑ mɔ win wɑsi sɔɔ, yɛ̃ro kun kpɛ̃ u dɑ nɛn kuu te sɔɔ u nɛ, Yinni Gusunɔ dĩɑnu gɑnu yɑ̃kuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Alebugii goo kun kpɛ̃ u nɛn sɔmbu te ko, ɑɑ wɔ̃kowɑ? Aɑ kɔ̃ri bɑrɔwɑ? Ǹ kun mɛ yɛ̃ron wuswɑɑ yɑ kɔsikirewɑ? ");
INSERT INTO bqp_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Ǹ kun mɛ yɛ̃ron nɑɑsu ǹ kun mɛ win gɑ̃serɑ bɔɔrewɑ? ");
INSERT INTO bqp_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Ǹ kun mɛ yɛ̃ro u kundu kpiɑwɑ? Ǹ kun mɛ u sɑ̃ɑwɑ tɔn kɔmiɑkubu? Ǹ kun mɛ yɛ̃ron nɔni kpiɑwɑ? Ǹ kun mɛ yɛ̃ro tɑɑtɑɑru ǹ kun mɛ debu mɔwɑ? Ǹ kun mɛ win tĩɑ bii kɔsikirɑ? ");
INSERT INTO bqp_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Wi u ɑlebu gɑɑ mɔ wɑsi sɔɔ gesi Aronin bweseru sɔɔ, u ǹ kpɛ̃ u nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ. U ǹ mɑɑ kpɛ̃ u kɑ dĩɑnu gɑnu nɑ u kɑ yɑ̃kuru ko nɛn kuu te sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Adɑmɑ u koo kpĩ u nɛ, Yinni Gusunɔn dĩɑ dɛɛrɑnu di. ");
INSERT INTO bqp_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Win ɑlebun sɔ̃nɑ u ǹ kpɛ̃ u susi yɑ̃ku yerɔ kɑ kuu ten beku kɑre ten mi. Kpɑ u ku rɑɑ nɛn kuu te disi doke. Nɛ, Yinni Gusunɔwɑ nɑ rɑ yɑ̃ku kowobu gɔsi bɑ n kɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mɑ Mɔwisi u Aroni kɑ win bibu kɑ Isirelibɑ kpuro gɑri yi sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, bɑ n tii sɛ dĩɑ ni Isirelibɑ bɑ kɑ mɑn nɑɑwɑmmɛ sɔɔ, kpɑ bu ku rɑɑ nɛn yĩsi dɛɛrɑ te sɑnku. Nɛnɑ nɑ sɑ̃ɑ Yinni Gusunɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ben bweseru sɔɔ, goo ù n nu susi, mɑ u disi gɛɛ mɔ, bɑ koo yɛ̃ro yɑrɑwɑ nɛn sɔmburun di. ");
INSERT INTO bqp_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Aronin bweseru sɔɔ, goo ù n bɑrɑ disigiru mɔ, ǹ kun mɛ ù n kentu kpikɑ mɔ, u ǹ yɑ̃ku dĩɑ ni dimɔ sere ù n dɛɛrɑ, ");
INSERT INTO bqp_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kɑ sere wi u goru bɑbɑ ǹ kun mɛ wìn sen nim mu wĩɑ ǹ kun mɛ wi u yɑɑ gɑɑ bɑbɑ ye yɑ disi mɔ ǹ kun mɛ wi u goo bɑbɑ wi u disi mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Wi u yen gɑɑ bɑbɑ gesi, u disi duurɑwɑ mi sere kɑ yokɑɔ. U ǹ kpɛ̃ u yɑ̃ku dĩɑ ni di mɑ n kun mɔ u woburɑ mɑm mɑm. ");
INSERT INTO bqp_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ù n woburɑ, yokɑn di u dɛɛrɑ, u koo kpĩ u nɛn dĩɑ ni di. Domi niyɑ nu sɑ̃ɑ win dĩɑnu. ");
INSERT INTO bqp_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mɛyɑ yɑ̃ku kowo goo kun yɑɑ goru temmɔ ǹ kun mɛ yɑɑ ye gbeeku yɑɑ gɑɑ yɑ go u ku rɑɑ kɑ tii disi doken sɔ̃. Nɛ, Yinni Gusunɔwɑ nɑ yeni geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Bɑ koo nɛn woodɑbɑ mɛm nɔɔwɑwɑ domi bɑ̀ n nɛn dĩɑnu disi doke, bɑ koo ben torɑrun ɑre sɔbe kpɑ bu gbi. Nɛ, Yinni Gusunɔwɑ nɑ bu gɔsɑ bɑ n kɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Tɔn diro kun yɑ̃ku dĩɑ ni dimɔ bɑɑ yɑ̃ku kowon sɔm kowo ǹ kun mɛ win sɔɔ. Yɛ̃ro kun yɑ̃ku dĩɑ ni dimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Adɑmɑ yoo wi yɑ̃ku kowo u dwɑ kɑ wi bɑ mɑrɑ win yɛnuɔ, bɑ koo kpĩ bu dĩɑ ni di. ");
INSERT INTO bqp_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Yɑ̃ku kowon bii tɔn kurɔ ù n tɔn diro suɑ durɔ, ù ku rɑɑ yɑ̃ku dĩɑ ni di. ");
INSERT INTO bqp_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Adɑmɑ bii wi, ù n sɑ̃ɑ gɔmini ǹ kun mɛ win durɔ u nùn yinɑ, mɑ u ǹ kɑ durɔ wi mɑrɑ, mɑ u gɔsirɑ win tundon yɛnuɔ u sɔ̃ nge sɑnɑm mɛ u ǹ durɔ sue, u koo kpĩ u dĩɑ ni di. Mɑ n kun mɛ, tɔn diro u ku dĩɑ ni di. ");
INSERT INTO bqp_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Tɔn tuko goo ù n nu di u ǹ kɑ bɑɑru, u koo nin kɔsire yɑ̃ku kowo wɛ̃wɑ. Yen biru kpɑ u nùn nin bɔnu nɔɔbun tiɑ sosiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Yɑ̃ku kowobu bu ku rɑɑ dĩɑ ni disi doke nì Isirelibɑ bɑ kɑ yɑ̃kuru kuɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Bɑ̀ n nu di sɑnɑm mɛ n ǹ weenɛ bu nu di, bɑ Isirelibɑ torɑnu sɔbimɔwɑ. Nɛnɑ Yinni Gusunɔ, nɛ wi nɑ rɑ yɑ̃kunu dɛɛrɑsie. ");
INSERT INTO bqp_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ɑ Aroni kɑ win bibu kɑ Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, goo be sɔɔ ǹ kun mɛ sɔɔ goo wi u wɑ̃ɑ ben suunu sɔɔ, ù n kĩ u yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko kɑ kĩru, ǹ kun mɛ u kɑ nɔɔ mwɛɛru gɑru yibiɑ, ");
INSERT INTO bqp_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","nɛ, Yinni Gusunɔ n sere tu mwɑ, yɑɑ sɑbe dɔɔ ge gɑ ǹ ɑlebu mɔ gerɑ u koo kɑ nɑ, nɑɑ, ǹ kun mɛ yɑ̃ɑru, ǹ kun mɛ boo, yɑ n gesi sɑ̃ɑ dwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","U ǹ koo kɑ yɑɑ sɑberu nɑ te tɑ ɑlebu gɑɑ mɔ. Domi ù n kɑ tu yɑ̃kuru kuɑ, nɑ ǹ mwɑɑmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀ kɑ kĩru ǹ kun mɛ u kɑ nɔɔ mwɛɛru gɑru yibiɑ, u koo tu kowɑ kɑ sɑbe te tɑ ǹ ɑlebu gɑɑ mɔ n sere win yɑ̃ku te mwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ǹ n mɛn nɑ, bu ku kɑ sɑbe wɔ̃ko nɑ, ǹ kun mɛ te tɑ kɔ̃ri bɔɔre, ǹ kun mɛ te bɑ so bɑ kɔsiki, ǹ kun mɛ te tɑ boo boosu ǹ kun mɛ tɑɑtɑɑru mɔ gɔnɑɔ. Bu ku kɑ yen gɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Bɑ koo kpĩ bu kɑ yɑɑ sɑbe tèn wɑsin bee tiɑ kpɑ̃ɑru bo kɛ̃run yɑ̃kuru ko. Adɑmɑ bu ku kɑ tu nɔɔ mwɛɛrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Bu ku rɑɑ kɑ yɑɑ sɑbe tèn tĩɑrɑ kɔrɑ ǹ kun mɛ bɑ wĩɑ nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ. Bu ku mɑɑ yen bweseru yɑɑ sɑberu gɑru kuɑ bɑ̀ n duɑ ben temɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Bu ku kɑ nɛ, Yinni Gusunɔ sɑbe ten bweseru yɑ̃kuru kuɑ te bɑ wɑ sɔbun mi. Domi sɑbe tèn wɑsi bɑ mɛɛrɑ kuɑ, tɑ sɑ̃ɑwɑ nge sɑbe te tɑ ɑlebu mɔ. Nɛ, Yinni Gusunɔ, nɑ ǹ yɑ̃ku ten bweseru mwɑɑmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","bɑ̀ n kɛtɛ buu mɑrɑ ǹ kun mɛ yɑ̃ɑru ǹ kun mɛ boo, gɑ koo kowɑ sɔ̃ɔ nɔɔbɑ yiru kɑ gen mɛro. Adɑmɑ sɑɑ sɔ̃ɔ nɔɔbɑ itɑsen di, bɑ koo kpĩ bu kɑ gu yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru ko. ");
INSERT INTO bqp_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bu ku rɑɑ yɑɑ sɑberu gɑru go kɑ ten buu sɔ̃ɔ teeru. ");
INSERT INTO bqp_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Bɑ̀ n nɛ, Yinni Gusunɔ siɑrɑbun yɑ̃kuru kuɑmmɛ, bu tu koowo nge mɛ kon kɑ tu mwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Yen dɔmɑ terɑ bɑ koo ten yɑɑ di. Bɑ ǹ yen gɑɑ tiɑmɔ sere sisiru. ");
INSERT INTO bqp_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Bɑ koo nɛn woodɑ ye mɛm nɔɔwɑwɑ kpɑ bu ye swĩi. ");
INSERT INTO bqp_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Bu ku rɑɑ nɛn yĩsiru sɑnku kpɑ bu wɑ bu mɑn bɛɛrɛ wɛ̃ ben suunu sɔɔ. Nɛnɑ nɑ Yinni Gusunɔ wi u bɛɛ gɔsɑ i n kɑ dɛɛre. ");
INSERT INTO bqp_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nɛnɑ nɑ bɛɛ yɑrɑ sɑɑ Egibitin di nɑ n kɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","2","Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, tɔ̃ɔ bɑkɑ nì sɔɔ i ko i n dɑ mɛnnɛ i mɑn sɑ̃, ni wee. ");
INSERT INTO bqp_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Alusumɑ tiɑ sɔɔ, sɔ̃ɔ nɔɔbɑ tiɑ i ko i n dɑ sɔmburu ko, sɔ̃ɔ nɔɔbɑ yiruse, i ko i wɛ̃rɑ kpɑ i mɛnnɑ i kɑ mɑn sɑ̃. Yen tɔ̃ɔ te, i ku rɑ sɔmburu gɑru ko. I ko i tu diwɑ nɛn sɔ̃ bɑɑ mi i wɑ̃ɑ kpuro gesi. ");
INSERT INTO bqp_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Tɔ̃ɔ bɑkɑ ni nu mɑɑ tie, nì sɔɔ i ko i mɛnnɑ i kɑ mɑn sɑ̃, nin tɔ̃nu wee. ");
INSERT INTO bqp_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Yinni Gusunɔ u nɛɛ, wɔ̃ɔn suru gbiikoon sɔ̃ɔ wɔkurɑ nnɛsen yokɑn di, i Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru dio nɛ, Yinni Gusunɔn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Yen sɔ̃ɔ wɔkurɑ nɔɔbuse sɔɔrɑ i ko i pɛ̃ɛ ye bɑ kun seeyɑtiɑ doken tɔ̃ɔ bɑkɑru tore. I ko i kowɑ sɔ̃ɔ nɔɔbɑ yiru i n pɛ̃ɛ dimɔ ye bɑ kun seeyɑtiɑ doke. ");
INSERT INTO bqp_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Alusumɑ yen tɔ̃ɔ gbiikiru sɔɔrɑ i ko i mɛnnɑ i mɑn sɑ̃. Yen tɔ̃ɔ te, i ku rɑ sɔmburu gɑru ko. ");
INSERT INTO bqp_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Alusumɑ yen tɔ̃ɔ bɑɑtere i ko i n dɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuewɑ. Sɔ̃ɔ nɔɔbɑ yiruse, i ko i kpɑm mɛnnɑ i mɑn sɑ̃. Yen tɔ̃ɔ te, i ku sɔmburu gɑru ko. ");
INSERT INTO bqp_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Yinni Gusunɔ u mɑɑ Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, ì n duɑ tem mɛ kon bɛɛ wɛ̃ sɔɔ, mɑ i dĩɑnu gɑ̃, i ko i kɑ dĩɑ gbiikii ni i gɑ̃ mi yɑ̃ku kowo dɑɑwɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kpɑ yɑ̃ku kowon tii u mɑn nu tusiɑ tɔ̃ɔ wɛ̃rɑrugirun sisiru kpɑ n wɑ n kɑ bɛɛ nɔnu geu mɛɛri. ");
INSERT INTO bqp_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Yen tɔ̃ɔ te, i ko i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ kɑ yɑ̃ɑru wɔ̃ɔ tiɑgiru te tɑ ǹ ɑlebu gɑɑ mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","I ko i mɑɑ som kilo nɔɔbɑ tiɑ mɛ i kɑ gum burinɑ sɔndi kpɑ ye kpuron nuburu tu nɛ, Yinni Gusunɔ dore. Yen biru kpɑ i tɑm litiri tiɑ kɑ bɔnu tɑ̃re som mɛn wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","I ǹ ko i dĩɑ gbiikii nin pɛ̃ɛ di ǹ kun mɛ nin bimɑ ye bɑ sɔnwɑ ǹ kun mɛ ye bɑ kɔsukɑ sere dɔmɑ te i kɑ nɛ, Yinni Gusunɔgiɑ nɑ. I ko woodɑ yeni mɛm nɔɔwɑwɑ mi i wɑ̃ɑ kpuro sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Yinni Gusunɔ u mɑɑ Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, i ko i mɑɑ ɑlusumɑ gɑriwɑ nɔɔbɑ yiru sɑɑ tɔ̃ɔ wɛ̃rɑrugirun sisirun di dɔmɑ tèn di i kɑ bɛɛn dĩɑ gbiikii ni, nɛ, Yinni Gusunɔ nɑɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","I ko i gɑriwɑ sɔ̃ɔ weerɑɑkuru sere n kɑ ko tɔ̃ɔ wɛ̃rɑrugiru nɔɔbɑ yirusen sisiru. Kpɑ i mɑɑ nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","I ko i kɑ pɛ̃ɛ yiru nɑ sɑɑ bɛɛn yɛnun di yèn bɑɑyere bɑ kuɑ kɑ som kilo itɑ kɑ pɛ̃ɛ seeyɑtiɑ. Bɛɛn gberun dĩɑ gbiikii niyɑ i ko i kɑ yen som mɛ ko, kpɑ yɑ̃ku kowo u ye sɔ̃ɔsi beri berikɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Yen biru, i ko i nɛ, Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuɑ kɑ yɑ̃ɑnu nɔɔbɑ yiru ni nu wɔ̃ɔ tiɑ tiɑ mɔ kpɑ nu kun ɑlebu gɑɑ mɔ kɑ mɑɑ kɛtɛ kinɛ kpɛm teeru kɑ yɑ̃ɑ kinɛnu yiru kɑ sere tɑm. Kpɑ ye kpuron nuburu tu nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bqp_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","I ko i mɑɑ boo go bɛɛn torɑnun yɑ̃kurun sɔ̃ kɑ mɑɑ yɑ̃ɑnu yiru ni nu wɔ̃ɔ tiɑ tiɑ mɔ siɑrɑbun yɑ̃kurun sɔ̃ ");
INSERT INTO bqp_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","kɑ pɛ̃ɛ ye sɑnnu. Yɑ̃ku kowo u koo kɑ ye kpuro Yinni Gusunɔ dɑɑwɑwɑ u nu tusiɑrun wororu koosi. Kpɑ ye kpuro yɑ n sɑ̃ɑ nɛ, Yinni Gusunɔgiɑ. Ye kpuron biru, yɑɑ ye kpuro yɑ koo kowɑ yɑ̃ku kowogiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Yen tɔ̃ɔ te, i ko mɛnnɑwɑ bɛɛ kpuro i mɑn sɑ̃. I ǹ mɑɑ sɔmburu mɔ̀ dɔmɑ te. Mi i wɑ̃ɑ kpuro, i ko i woodɑ yeni mɛm nɔɔwɑwɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ì n bɛɛn gberun dĩɑnu gɛ̃ɛmɔ, i ku ni nu wɑ̃ɑ bɛɛn gbee goorɔ gɛ̃. Yen biru i ku mɑɑ nu kunɔnu ko. I ko i nu sɑ̃ɑrobu kɑ sɔbu deriɑwɑ. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, wɔ̃ɔn suru nɔɔbɑ yirusen tɔ̃ɔ gbiikiru sɔɔ, i ko i wɛ̃rɑwɑ kpɑ i kɔbi so Gusunɔ u kɑ bɛɛ yɑɑyɑ. Tɔ̃ɔ te, i ko i mɛnnɑwɑ kpɑ i mɑn sɑ̃. ");
INSERT INTO bqp_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","I ku rɑ sɔmburu gɑru ko. Kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","wɔ̃ɔn suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurusewɑ i ko i yɑ̃kuru ko bɛɛn torɑnun suurun sɔ̃. I ko i mɛnnɑwɑ kpɑ i nɔɔ bɔke kpɑ i mɑn sɑ̃. Kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu kuɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","I ku rɑ sɔmburu gɑru ko tɔ̃ɔ te sɔɔ. Domi tɔ̃ɔ te sɔɔrɑ bɑ koo bɛɛ torɑnun suuru kobun woronu koosi Gusunɔ bɛɛn Yinnin wuswɑɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Wi u kun nɔɔ bɔkue yen tɔ̃ɔ te, bɑ koo nùn wunɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bqp_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Wi u mɑɑ sɔmburu kuɑ tɔ̃ɔ te sɔɔ, kon de bu yɛ̃ro gowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","I ku rɑ sɔmburu gɑru ko tɔ̃ɔ te. Yɑ ko n sɑ̃ɑwɑ woodɑ kɑ bɑɑdommɑɔ kɑ bɛɛn bibun bweserɔ. Mi i wɑ̃ɑ kpuro, i ko ye mɛm nɔɔwɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Yɑ ko n sɑ̃ɑwɑ nge tɔ̃ɔ wɛ̃rɑrugiru kpɑ i nɔɔ bɔke. I ko i wɛ̃rɑwɑ sɑɑ surun sɔ̃ɔ nɔɔbɑ nnɛn yokɑn di sere kɑ yen sisirun yokɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, sɑɑ wɔ̃ɔn suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurɑ nɔɔbun di, i ko i Kunun tɔ̃ɔ bɑkɑru diwɑ sɔ̃ɔ nɔɔbɑ yiru i kɑ nɛ, Yinni Gusunɔ sɑ̃. ");
INSERT INTO bqp_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Yen tɔ̃ɔ gbiikiru, i ko i mɛnnɑ i mɑn sɑ̃. I ku rɑ sɔmburu gɑru ko tɔ̃ɔ te. ");
INSERT INTO bqp_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Tɔ̃ɔ bɑɑtere i ko i n dɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru kuewɑ sere n kɑ ko sɔ̃ɔ nɔɔbɑ yiru ye. Yen sɔ̃ɔ nɔɔbɑ itɑse, i ko i kpɑm mɛnnɑwɑ i mɑn sɑ̃ kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu kuɑ. Tɔ̃ɔ te, i ku rɑ sɔmburu gɑru ko. Tɑ sɑ̃ɑwɑ gɑ̃ɑ girinu. ");
INSERT INTO bqp_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Yenibɑ kpuro yɑ sɑ̃ɑwɑ tɔ̃ɔ bɑkɑ ni i ko i di nɛ Yinni Gusunɔn sɔ̃. Kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruginu kuɑ kɑ bɛɛn gberun dĩɑnu kɑ siɑrɑbun yɑ̃kunu kɑ tɑm. Yɑ̃kuru bɑɑtere kɑ ten tɔ̃ru. ");
INSERT INTO bqp_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Mɛyɑ i ku mɑɑ tɔ̃ɔ wɛ̃rɑrugiru duɑri kɑ yɑ̃ku ni i rɑ mɑn kue kɑ sere mɑɑ kɛ̃ɛ ni i rɑ kɑ nɛ kɑ mɑɑ nɔɔ mwɛɛrun yɑ̃kuru. ");
INSERT INTO bqp_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurɑ nɔɔbuse sɔɔ, ì n bɛɛn gberun dĩɑnu gɑ̃, i ko i tɔ̃ɔ bɑkɑru diwɑ sɔ̃ɔ nɔɔbɑ yiru i kɑ mɑn bɛɛrɛ wɛ̃. Yen tɔ̃ɔ gbiikiru kɑ yen tɔ̃ru nɔɔbɑ itɑse, i ko i wɛ̃rɑwɑ i ku sɔmburu gɑru ko. ");
INSERT INTO bqp_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Yen tɔ̃ɔ gbiikii te, i ko i dɑ̃ɑ mɑrum burɑm suɑ kɑ kpɑkpɑ wurusu kɑ dɑ̃ɑ wuru bɑkɑsu si su rɑ n wɑ̃ɑ dɑɑrɔ kpɑ i n nuku dobu mɔ̀ nɛn wuswɑɑɔ sɔ̃ɔ nɔɔbɑ yiru ye. ");
INSERT INTO bqp_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Wɔ̃ɔ bɑɑgere i ko i n dɑ tɔ̃ɔ bɑkɑ te diwɑ i kɑ mɑn bɛɛrɛ wɛ̃ suru nɔɔbɑ yiruse ye sɔɔ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Bɛɛ Isirelibɑ kpurowɑ i ko i n wɑ̃ɑ kunu sɔɔ sere sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bqp_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Kpɑ bɛɛn bibun bweseru tu kɑ giɑ mɑ nɑ ben sikɑdobɑ sinɑsiɑ kunu sɔɔ sɑnɑm mɛ nɑ bu yɑrɑmɑ Egibitin di. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nge mɛyɑ Mɔwisi u Isirelibɑ tɔ̃ɔ bɑkɑ ni sɔ̃ɔwɑ ni bɑ ko n dɑ di bu kɑ Yinni Gusunɔ bɛɛrɛ wɛ̃. ");
INSERT INTO bqp_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bu nùn olifin gum kɑsuo mɛ mu geɑ bo kpɑ fitilɑnu nu n kɑ sɔ̃re yokɑ bɑɑyere. ");
INSERT INTO bqp_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aroni u koo kɑ gum mɛ dɑwɑ nɛ, Yinni Gusunɔn kuu bekurugii ten mi, beku kɑre ten wuswɑɑɔ te tɑ woodɑn kpɑkoro te gɑnuɑ. Kpɑ u de fitilɑ ni, nu n sɔ̃re yokɑn di sere yɑm mu kɑ sɑ̃rɑ. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ ben bibun bweserɔ. ");
INSERT INTO bqp_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aroni u koo fitilɑ ni sɔndiwɑ dɑbu wurɑguun wɔllɔ kpɑ nu n sɔ̃re wɔ̃kuru bɑɑtere sere yɑm mu kɑ sɑ̃rɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ pɛ̃ɛ wɔkurɑ yiru wɔ̃ɔwɔ yen bɑɑyere yɑ n sɑ̃ɑ kilo nɔɔbɑ tiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kɑɑ ye yorewɑ nɛn wuswɑɑɔ tɑbulu wurɑgiɑ yen wɔllɔ sĩɑ yiru, yen bɑɑyere sɔɔ pɛ̃ɛ nɔɔbɑ tiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Sĩɑ bɑɑyeren wɔllɔ kɑɑ turɑre geɑ sɔndi kpɑ bu ye dɔ̃ɔ mɛni nɛn sɔ̃ pɛ̃ɛ yen ɑyerɔ kpɑ n bɛɛ yɑɑyɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Tɔ̃ɔ wɛ̃rɑrugiru bɑɑtere, bɑ ko n dɑ mɑn pɛ̃ɛ yen bweseru yiiyewɑ kpɑ yɑ n yii mi bɑɑdommɑ. Yɑ ko n sɑ̃ɑwɑ woodɑ bɛɛn bibun bweseru sɔɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Pɛ̃ɛ ye bɑ kɔsire kuɑ mi, yɑ ko n sɑ̃ɑwɑ Aroni kɑ win bibugiɑ. Bɑ koo ye diwɑ yɑm dɛɛrɑmɔ. Pɛ̃ɛ ye, yɑ sɑ̃ɑwɑ nɛnɛm domi nɛnɑ bɑ ye wɛ̃ sɑnɑm mɛ bɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑrugiru mɔ̀. Aronin bweserɑ tɑ ko n dɑ ye di sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Sɔ̃ɔ teeru Isirelibɑn goo kɑ Egibitigii goon bii wì u kɑ Isireli tɔn kurɔ mɑrɑ bɑ sɑnnɑ. Kurɔ Isireli win yĩsirɑ Selomiti, Debirin bii, Dɑnun bweseru sɔɔ. Selomitin bii wi, u Gusunɔn yĩsiru gɑri kɑm gerusimɔ u bɔ̃rusimɔ. Yerɑ yɑnde bɑ kɑ nùn dɑ Mɔwisin mi. ");
INSERT INTO bqp_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mɑ bɑ nùn yii bɑ kɑ mɑrɑ bu wɑ ye Yinni Gusunɔ u koo gere. ");
INSERT INTO bqp_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","i kɑ durɔ wi yɑrio sɑnsɑnin di. Be bɑ mɑɑ nuɑ u nɛ Yinni Gusunɔ gɑri kɑm gerusi mi, kpɑ bu ben nɔmɑ sɔndi win wirɔ bu kɑ seedɑ di kpɑ Isirelibɑ kpuro bu nùn kpenu kɑsuku bu go. ");
INSERT INTO bqp_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Yen biru woodɑ yeniwɑ kɑɑ Isirelibɑ wɛ̃ ɑ nɛɛ, wi u nɛ, Yinni Gusunɔ gɑri kɑm gerusi, yɛ̃ro u koo yen ɑre wɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Wi u gesi nɛ, Yinni Gusunɔ gɑri kɑm gerusi, bɑ koo yɛ̃ro gowɑ. Isirelibɑ kpurowɑ bɑ koo nùn kpenu kɑsuku bu go. Bɑɑ ù n sɑ̃ɑn nɑ sɔɔ, bɑ koo nùn gowɑ yèn sɔ̃ u nɛ, Yinni Gusunɔ gɑri kɑm gerusi. ");
INSERT INTO bqp_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Goo ù n win winsim go, bɑ koo mɑɑ yɛ̃ro gowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Goo ù n win winsim yɑɑ sɑberu go, u koo ten kɔsire wɛ̃wɑ wɑsiru. Hundewɑ yɑ hunden kɔsire. ");
INSERT INTO bqp_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Goo ù n mɑɑ win winsim mɛɛrɑ kuɑ, mɛɛrɑ yen bweserɑ bɑ koo yɛ̃ro ko. ");
INSERT INTO bqp_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Wi u goo buɑ, bɑ koo mɑɑ yɛ̃ro buɑwɑ. Wi u goon nɔni wĩɑ, bɑ koo mɑɑ yɛ̃ron nɔni wĩɑwɑ. Wi u goon dondu buɑ, bɑ koo mɑɑ yɛ̃rogiru buɑwɑ. Kɔ̃sɑ ye tɔnu u win tɔnusi kuɑ kpuro, yerɑ bɑ koo mɑɑ nùn kɔsie. ");
INSERT INTO bqp_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Wi u yɑɑ sɑberu go, u koo ten kɔsire wɛ̃wɑ. Wi u mɑɑ tɔnu go, bɑ koo mɑɑ yɛ̃ro gowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Woodɑ tiɑ yerɑ bɑ koo kɑ bɛɛ kɑ bɛɛn sɔbu siri. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mɑ Mɔwisi u Isirelibɑ kpuro ye sɔ̃ɔwɑ. Mɑ bɑ durɔ wi u Yinni Gusunɔ gɑri kɑm gerusi mi yɑrɑ sɑnsɑnin di bɑ nùn kpenu kɑsukɑ bɑ go. Nge mɛyɑ bɑ kɑ kuɑ ye Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","2","Yinni Gusunɔ u kɑ Mɔwisi gɑri kuɑ guu te bɑ mɔ̀ Sinɑin wɔllɔ u nɛɛ, bɛɛ Isirelibɑ ì n duɑ tem mɛ sɔɔ, mɛ kon bɛɛ wɛ̃ mi, i ko i dewɑ bɛɛn gbeɑn tem mu wɛ̃rɑ nɛn sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Wɔ̃ɔ nɔɔbɑ tiɑ sɔɔrɑ i ko i bɛɛn gbeɑ duure kpɑ i bɛɛn resɛm gbɑɑnu sɔmɛ i nin dɑ̃nu kɔni. Kpɑ i yen mɑrum sɔri. ");
INSERT INTO bqp_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Adɑmɑ wɔ̃ɔ nɔɔbɑ yiruse, yɑ ko n sɑ̃ɑwɑ wɔ̃ɔ wɛ̃rɑruguu Yinni Gusunɔn sɔ̃. Bɛɛn gbenu nu koo wɛ̃rɑwɑ mɑm mɑm. I ku rɑ nu dĩɑnu duure, i ǹ ko i mɑɑ bɛɛn resɛm kɔni. ");
INSERT INTO bqp_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Bɑɑ dĩɑ ni nu wɔrumɑ sɑnɑm mɛ i gɛ̃ɛmɔ mɑ nu kpiɑ kɑ tii, i ǹ nu gɛ̃ɛmɔ. I ǹ mɑɑ resɛm sɔrimɔ ye yɑ kɑ tii mɑrɑ. Domi bɛɛn gbeɑ yɑ koo wɛ̃rɑwɑ mɑm mɑm wɔ̃ɔ ge sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Adɑmɑ wɔ̃ɔ wɛ̃rɑruguu ge sɔɔ, ye yɑ kpiɑ kɑ tii, yerɑ i ko i di bɛɛ kɑ bɛɛn sɔm kowobu kɑ bɛɛn yobu kɑ sere mɑɑ sɔɔ be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ ");
INSERT INTO bqp_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","kɑ bɛɛn yɑɑ sɑbenu kɑ gbeeku yɛɛ. Ye tem mɛ, mu koo kpi yerɑ i ko i di. ");
INSERT INTO bqp_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","I ko i wɔ̃ɔ nɔɔbɑ yirun subɑ nɔɔbɑ yiru deriwɑ yu doonɑ. Ye kpuro yɑ sɑ̃ɑwɑ mi, wɔ̃ɔ weerɑɑkuru tiɑ sɑri. ");
INSERT INTO bqp_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Yen wɔ̃ɔ dɑ̃ɑkun suru nɔɔbɑ yirusen sɔ̃ɔ wɔkuru, tɔ̃ɔ te bɑ torɑrun yɑ̃kuru kuɑ mi, i ko i kɔbi wurɑwɑ kɑ kuuki tem mɛ kpuro sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Wɔ̃ɔ weerɑɑkurusen wɔ̃ɔ ge, gɑ ko n sɑ̃ɑwɑ nɛnɛm nɛ, Yinni Gusunɔn sɔ̃. Kpɑ i kpɑrɑ mɑ bɑɑwure u tii mɔ. Wɔ̃ɔ ge sɔɔ, bɑ koo gbee te goo u rɑɑ dɔrɑ ǹ kun mɛ te bɑ nùn mwɑɑri wesiɑwɑ tu ko wigiru. Wi u rɑɑ mɑɑ yoru dimɔ, u koo yɑkiɑrɑ u wurɑ win yɛnuɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Nge mɛyɑ i ko n dɑ wɔ̃ɔ weerɑɑkuru bɑɑteren yɑkiɑbun tɔ̃ɔ bɑkɑru di. I ko i wɛ̃rɑwɑ wɔ̃ɔ ge sɔɔ. I ǹ dĩɑnu gɑnu duurumɔ. I ǹ mɑɑ dĩɑnu gɑnu gɛ̃ɛmɔ ni nu kɑ tii kpiɑ. Mɛyɑ i ǹ mɑɑ resɛm sɔrimɔ ye yɑ mɑrɑ resɛm gbɑɑrɔ te bɑ ǹ sɔnwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Domi nuku dobun wɔ̃ɔwɑ ge i ko i wunɑ nɛnɛm nɛ Yinni Gusunɔn sɔ̃. Adɑmɑ bɛɛn gbeɑn dĩɑnɑ i ko i di. ");
INSERT INTO bqp_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Wɔ̃ɔ ge sɔɔ, bɑɑwure u koo win tem mwɑwɑ mɛ bɑ rɑɑ nùn mwɑɑri. ");
INSERT INTO bqp_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ì n tem dɔrɑmɔ, ǹ kun mɛ ì n dwemɔ, bɛɛn goo u ku rɑɑ win winsim nɔni wɔ̃ke. ");
INSERT INTO bqp_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Wi u kĩ u win gberu dɔrɑ, u koo ginɑ lɑsɑbu kowɑ u wɑ mɛ̀n nɔɔ tɑ koo dĩɑnu mɑ sere wɔ̃ɔ weerɑɑku te, tu kɑ yibu tè sɔɔ bɑ rɑ yɑkiɑbun tɔ̃ɔ bɑkɑru ko tè sɔɔ yɛ̃ro u koo tu wesiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nge mɛ wɔ̃su su dɑbiru nɛ, nge mɛyɑ gbee ten gobi yi ko n kpɑ̃ɑru nɛ. Wɔ̃sun sukum mɛ mu tie mù kun dɑbi sere wɔ̃ɔ weerɑɑku te, tu kɑ yibu, ten gobi yi ǹ ko yi n kpɑ̃. Domi ye bɑ koo gɛ̃ gbee te sɔɔ, yerɑ u dɔrɑmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Bɛɛn goo u ku rɑɑ win winsim nɔni wɔ̃ke. I ko i mɑn nɑsiɑwɑ domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","I nɛn woodɑbɑ mɛm nɔɔwɔ kpɑ i sĩ ye sɔɔ. Sɑɑ ye sɔɔrɑ i ko i sinɑ tem mɛ sɔɔ kɑ bɔri yɛndu. ");
INSERT INTO bqp_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tem mɛ, mu koo dĩɑnu ko ni nu koo bɛɛ turi kpɑ i n kɑ wɑ̃ɑ bɔri yɛndu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Sɔrɔkudo i ko i tii bikiɑ i nɛɛ, mbɑ i ko i di wɔ̃ɔ nɔɔbɑ yiruse te. Domi i ǹ wɔ̃ɔ ge sɔɔ dĩɑnu duurumɔ, i ǹ mɑɑ gɛ̃ɛmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Kon bɛɛ domɑru kuɑ wɔ̃ɔ nɔɔbɑ tiɑse kpɑ bɛɛn gbeɑ yu wɔ̃ɔ itɑn dĩɑnu mɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Wɔ̃ɔ nɔɔbɑ itɑse sɔɔ, i ko i dĩɑnu duure kpɑ bɛɛn dĩɑ gurunu nu n tie sere i kɑ wɔ̃ɔ nɔɔbɑ nnɛsen dĩɑnu gɛ̃. ");
INSERT INTO bqp_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Goo kun tɔnu tem dɔremɔ kpɑ yɛ̃ro u n mu mɔ sere kɑ bɑɑdommɑɔ, domi nɛ, Yinni Gusunɔwɑ nɑ tem mɔ, i mɑɑ wɑ̃ɑwɑ nɛn mi nge sɔbu. ");
INSERT INTO bqp_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Yen sɔ̃nɑ mi i sinɑ kpuro, i ko i tem yɑkiɑbun woodɑ ye mɛm nɔɔwɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Bɛɛ sɔɔ, goo ù n kuɑ sɑ̃ɑro, mɑ u win tem sukum dɔrɑ, win dusi goo ù n gobi mɔ, u koo kpĩ u mu yɑkiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Yɛ̃ro ù kun mɑɑ dusi goo mɔ wi u koo mu yɑkiɑ, win tii u koo kookɑri kowɑ u kɑ mu yɑkiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","U koo wɔ̃su gɑriwɑ si su tie wɔ̃ɔ weerɑɑku te, tu kɑ sere yibu kpɑ u si kpuron gobi kɔsiɑ kpɑ tem mɛ, mu ko wigim. ");
INSERT INTO bqp_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ù kun gobi wɑ u kɑ mu yɑkiɑ, u koo mu wi u tem mɛ dwɑ deriɑ sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi. Yen biru u koo kpĩ u wurɑ tem mɛ sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Yinni Gusunɔ u nɛɛ, goo ù n win diru dɔrɑ te tɑ wɑ̃ɑ wuu gbɑ̃rɑruguu sɔɔ, wɔ̃ɔ tiɑ u mɔ u kɑ tu yɑkiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Yɛ̃ro ù n kpɑnɑ u dii te yɑkiɑ wɔ̃ɔ tiɑ yen bɑɑ sɔɔ, tɑ koo kowɑ wi u tu dwɑgiru sere kɑ bɑɑdommɑɔ. U ǹ mɑɑ tu wesiɑmɔ bɑɑ yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Adɑmɑ dii te tɑ wɑ̃ɑ wuu ge gɑ ǹ gbɑ̃rɑru mɔ sɔɔ, bɑ koo tu yɑkiɑwɑ nge mɛ bɑ rɑ tem yɑkie. Bɑɑ ǹ n mɛren nɑ, wi u rɑɑ dii te mɔ, bɑ koo nùn tu wesiɑwɑ yɑkiɑbun tɔ̃ɔ bɑkɑru sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Adɑmɑ Lefibɑn wusu kɑ ben diɑ, bɑ ko n dɑ kpĩ bu ye yɑkie sɑɑ kpuro. ");
INSERT INTO bqp_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Wi u Lefibɑn goon diru dwɑ, yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ, u koo yɑriwɑ dii ten min di kɑ wuu gen min di. Lefibɑn diɑ yɑ sɑ̃ɑwɑ ben tiiginu Isirelibɑginun suunu sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Gbee ni nu mɑɑ kɑ ben wusu sikerenɛ, ben goo kun kpɛ̃ u nu dɔrɑ. Domi berɑ bɑ nu mɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Yinni Gusunɔ u nɛɛ, wunɛn Isirelisi ù n sɑ̃ɑru duurɑ, mɑ u ǹ kpɛ̃ u tii nɔɔri, ɑ de ɑ nùn somi u kɑ win wɑ̃ɑru di. Nge mɛyɑ kɑɑ mɑɑ sɔɔ kuɑ kpɑ u wɑ u sinɑ tem mɛ sɔɔ wunɛn bɔkuɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","À n nùn gɑ̃ɑnu bɔkurɑ, ɑ ku nùn ɑre kɑsusi. A de ɑ nɛ Gusunɔ wunɛn Yinni nɑsiɑ, kpɑ wunɛn winsim u wɑ u n wɑ̃ɑ wunɛn bɔkuɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","À n nùn gobi bɔkurɑ ǹ kun mɛ dĩɑnu, ɑ ku nim doke. ");
INSERT INTO bqp_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye geruɑ. Nɛnɑ nɑ bɛɛ yɑrɑ sɑɑ Egibitin di n kɑ bɛɛ Kɑnɑnin tem wɛ̃ kpɑ nɑ n sɑ̃ɑ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Yinni Gusunɔ u mɑɑ nɛɛ, wunɛn Isirelisi ù n sɑ̃ɑru duurɑ mɑ u nun tii dɔre, ɑ ku nùn yoo sɔmɑ koosiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","U ko n sɑ̃ɑwɑ wunɛn sɔm kowo, u n wɑ̃ɑ wunɛn yɛnuɔ sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ nɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Yɑkiɑbun tɔ̃ɔ bɑkɑ te, tɑ̀ n tunumɑ, kɑɑ nùn yɑkiɑwɑ wi kɑ win bibu kpɑ u wurɑ u win yɛnugibu deemɑ, u win sikɑdobɑn gbeɑ tubi di. ");
INSERT INTO bqp_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Domi bɑ sɑ̃ɑwɑ nɛn yobu be nɑ yɑrɑmɑ Egibitin di. Bɑ ǹ koo bu dɔrɑ nge mɛ bɑ rɑ yobu dɔre. ");
INSERT INTO bqp_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","A ku nùn dɑm dɔre. A sɔ̃ɔsio mɑ ɑ nɛ Gusunɔ wunɛn Yinni nɑsie. ");
INSERT INTO bqp_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","À n yobu kĩ, bwese tuku ni nu kɑ nun sikerenɛwɑ kɑɑ yoru mwɛɛri bɑ n sɑ̃ɑ wunɛgibu. ");
INSERT INTO bqp_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kɑɑ kpĩ ɑ sɔbun bibu dwe be bɑ wɑ̃ɑ wunɛn yɛnuɔ kɑ sere be bɑ mɑrɑ bɛɛn tem sɔɔ. À n bu dwɑ, bɑ ko n sɑ̃ɑwɑ wunɛgibu. ");
INSERT INTO bqp_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wunɛn bibun bweseru tɑ koo kpĩ tu bu tubi di sere kɑ bɑɑdommɑɔ. Adɑmɑ goo u ku rɑɑ win Isirelisi dɑm dɔre. ");
INSERT INTO bqp_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Sɔɔ goo ù n wɑ̃ɑ wunɛn yɛnuɔ, mɑ u kuɑ gobigii, mɑ Isireli goo u sɑ̃ɑru duurɑ, mɑ u tii sɔɔ wi dɔre, ǹ kun mɛ sɔɔ win dusi goo, ");
INSERT INTO bqp_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Isireli wi, u koo kpĩ u tii yɑkiɑ ǹ kun mɛ win dusi goo u nùn yɑkiɑ ");
INSERT INTO bqp_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ǹ kun mɛ win bɑɑn mɔɔ ǹ kun mɛ win bɑɑn wɔnɔ ǹ kun mɛ ben bii goo ǹ kun mɛ win dusi goo gesi. Wi u mɑɑ tii dɔrɑ mi, ù n dɑm wɑ u kɑ tii yɑkiɑ, u koo kpĩ u tii yɑkiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Bɑ koo wɔ̃sun geeru gɑriwɑ wi kɑ wi u nùn dwɑ sɑɑ mìn di u tii dɔrɑ sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi. Win yɑkiɑbun gobin geeru tɑ ko n sɑ̃ɑwɑ nge gobi yi bɑ koo sɔm kowo kɔsiɑ wɔ̃ɔ si sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Wɔ̃su sù n mɑɑ tie su kpɑ̃ yɑkiɑbun tɔ̃ɔ bɑkɑru tu sere turi, u koo win yɑkiɑbun gobi kɔsiɑwɑ nge mɛ wɔ̃ɔ sin geerɑ nɛ. ");
INSERT INTO bqp_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Wɔ̃su sù kun mɑɑ dɑbi sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi, u koo win yɑkiɑbun gobi kɔsiɑwɑ nge mɛ wɔ̃ɔ sin geerɑ nɛ. ");
INSERT INTO bqp_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ù n wɑ̃ɑ win yinnin mi, yinni wi, u koo nùn kowɑ nge mɛ bɑ rɑ sɔm kowo kue. U ǹ koo nùn dɑm dɔre. ");
INSERT INTO bqp_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ù kun kpĩɑ u tii yɑkie kɑ swɑɑ yen gɑɑ, u koo yɑkiɑrɑ wi kɑ win bibu yɑkiɑbun tɔ̃ɔ bɑkɑru sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isirelibɑ bɑ sɑ̃ɑwɑ nɛ, Yinni Gusunɔn yobu be nɑ yɑrɑ Egibitin di. Nɛ Gusunɔ nɑ sɑ̃ɑwɑ ben Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Nɑ nɛɛ, i ku bwɑ̃ɑroku gɑgu sɑ̃. I ku rɑ mɑɑ gɑ̃ɑnu gɑnun weenɑsinu ko. I ku mɑɑ kperu gɑru girɑ te bɑ gɑ̃ɑnu gɑnun weenɑsinu koosi kpɑ i yiirɑ i sɑ̃. Domi nɛnɑ nɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","I tɔ̃ɔ wɛ̃rɑrugiru yɑɑyo kpɑ i nɛn kuu bekurugiru bɛɛrɛ wɛ̃. Nɛ, Yinni Gusunɔwɑ nɑ ye geruɑ. ");
INSERT INTO bqp_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ì n nɛn woodɑbɑ mɛm nɔɔwɑ mɑ i ye swĩi, ");
INSERT INTO bqp_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","kon de gurɑ yu nɛ yen sɑɑ sɔɔ kpɑ tem mu dĩɑnu wɛ̃ kpɑ dɑ̃nu nu binu mɑ. ");
INSERT INTO bqp_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","I ko n dĩɑnu gɛ̃ɛmɔwɑ sere bɛɛn resɛm yu kɑ sɔribu turi. Kpɑ resɛm ye, yɑ n mɑɑ wɑ̃ɑ duurubun sɑɑ. I ko i di i debu kpɑ i n wɑ̃ɑ kɑ bɔri yɛndu bɛɛn tem sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Kon de ɑlɑfiɑ yɑ n wɑ̃ɑ tem mɛ sɔɔ. Goo kun bɛɛ bɑɑsimɔ ì n dò. Kon de yɛɛ gɔbi yi doonɑ. Mɛyɑ tɑbu kun mɑɑ duɔ tem mɛ sɔɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","I ko i bɛɛn yibɛrɛbɑ nɑɑ girɑwɑ kpɑ i bu tɑkobi sɔkiri i kɑmiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Bɛɛn nɔɔbu bɑ koo kpĩ bu tɔmbu wunɔbu (100) nɑɑ swĩi bu go. Kpɑ bɛɛn wunɔbu bu tɔmbu nɔrɔbun subɑ wɔkuru (10.000) nɑɑ swĩi bu go kɑ tɑkobi. ");
INSERT INTO bqp_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Kon kɑ bɛɛ nɔnu geu mɛɛri kpɑ n de i mɑrurɑ i kɔwɑrɑ kpɑ n de nɛn ɑrukɑwɑni yɑ n wɑ̃ɑ sere kɑ bɛɛn bibun bibɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I ko i bɛɛn dĩɑ gurunu di sere nu tiɑrɑ kpɑ i kpɑɑnu kɔsire ko bɛɛn birɑnɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Kon de bu nɛn wɑ̃ɑ yeru girɑ bɛɛn suunu sɔɔ. Nɑ ǹ mɑɑ bɛɛ biru kisimɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nɑ kon sĩimɔwɑ bɛɛn suunu sɔɔ kpɑ nɑ n sɑ̃ɑ bɛɛn Yinni kpɑ i n mɑɑ sɑ̃ɑ nɛn tɔmbu. ");
INSERT INTO bqp_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nɛnɑ Gusunɔ bɛɛn Yinni, nɛ wi nɑ bɛɛ yɑrɑ sɑɑ yorun di Egibitiɔ. Nɛnɑ nɑ Egibitigibun dɑm dɔrebu kpeerɑsiɑ. Tɛ̃ i ko i kpĩ i sĩ n kun kɑ sekuru. ");
INSERT INTO bqp_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Yinni Gusunɔ u nɛɛ, ì kun nɛn woodɑbɑ mɛm nɔɔwɛ, mɑ i ǹ sĩimɔ ye sɔɔ, ");
INSERT INTO bqp_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","mɑ i nɛn ɑrukɑwɑni yinɑ, i nɛn woodɑbɑ biru kisi, i ǹ kɑ bu sɔmburu kue, ");
INSERT INTO bqp_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","wee ye kon bɛɛ kuɑ. Kon bɛɛ bɛrum tiɑ kpɑ n de wɑsi sun bɑkɑru tu bɛɛ wɔri i woorɑ sere bɛɛn nɔni yi tondɑ kpɑ i n wɑhɑlɑ mɔ̀. Kɑm sɔɔrɑ i ko i bɛɛn dĩɑnu duure. Domi bɛɛn yibɛrɛbɑrɑ bɑ koo nu di. ");
INSERT INTO bqp_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kon bɛɛ biru kisi kpɑ bɛɛn yibɛrɛbɑ bu bɛɛ kɑmiɑ. Kpɑ be bɑ bɛɛ tusɑ bu bɛɛ dɑm dɔre. I ko i duki yɑkikirɑwɑ bɑɑ bɑ̀ kun bɛɛ nɑɑ gire. ");
INSERT INTO bqp_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Yenibɑ kpuron biru, ì kun mɑn mɛm nɔɔwɛ, kon bɛɛ sɛɛyɑsiɑ too too bɛɛn torɑrun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kon bɛɛn dɑm buɑ mɛ̀n sɔ̃ i tii sue. Kon de wɔllu tu bɔbiɑ nge sisu kpɑ gurɑ yu ku nɛ. Kpɑ tem mu bɔbiɑ nge sii gɑndu. ");
INSERT INTO bqp_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","I ko i bɛɛn dɑm dɔrɑwɑ kɑm sɔɔ. Domi tem mu ǹ dĩɑnu mɔ̀. Mɛyɑ dɑ̃nu nu ǹ mɑɑ mɑrumɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ì n mɑn seesimɔ, kon bɛɛ sɛɛyɑsiɑ too too bɛɛn torɑnun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Kon bɛɛ gbeeku yɛɛ suremɑ yi bɛɛn bibu go sere kɑ bɛɛn yɑɑ sɑbenɔ kpɑ i kun mɑɑ dɑbi kpɑ bɛɛn swɛɛ yi gbi. ");
INSERT INTO bqp_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Sɛɛyɑsiɑ bini bù kun mɑɑ dere i gɔ̃ru gɔsie, mɑ i mɑn seesimɔ, ");
INSERT INTO bqp_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nɛn tii kon bɛɛ seesi kpɑ n mɑɑ bɛɛ sɛɛyɑsiɑ too too n kere yellu bɛɛn torɑnun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kon de tɑbu bu bɛɛ wɔri yèn sɔ̃ i nɛn ɑrukɑwɑni kusiɑ. Ì n mɛnnɑ i kukuɑ bɛɛn wusɔ, kon de bɑrɑru tu bɛɛ wɔri kpɑ yibɛrɛbɑ bu bɛɛ nɔmɑ turi. ");
INSERT INTO bqp_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kon de gɔ̃ɔru tu nɑ. Sɑɑ ye sɔɔ, tɔn kurɔbu wɔkuru bɑ koo pɛ̃ɛ wɔ̃wɑ doo teu sɔɔ kpɑ bu kɑ bɛɛ nɑɑwɑ ye yɑ ǹ bɛɛ debumɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Yenibɑn biru ì kun mɑn mɛm nɔɔwɛ, mɑ i mɑn seesimɔ, ");
INSERT INTO bqp_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nɛn tii kon bɛɛ seesi kɑ mɔru kpɑ n bɛɛ sɛɛyɑsiɑ nɔn nɔɔbɑ yiru n kere yellu bɛɛn torɑnun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","I ko i gɔ̃ɔru wɑ sere i bɛɛn bibu tem. ");
INSERT INTO bqp_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Kon bɛɛ tusi sere n bɛɛ gunguu nìn mi i rɑ yɑ̃kuru ko kɔsuku kɑ bwɑ̃ɑrokunu ni i rɑ kɑ sɔ̃ɔ sɑ̃. Kon bɛɛn gonu sɔndi bwɑ̃ɑroku nin kɛ̃kin wɔllɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kon bɛɛn wusu gɔsiɑ bɑnsu kpɑ n bɛɛn sɑ̃ɑ yenu kɔsuku. Nɑ ǹ mɑɑ bɛɛn yɑ̃kunu mwɑɑmɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Kon bɛɛn tem kɑm koosiɑ. Bɛɛn yibɛrɛ be, bɑ koo nɑ bu sinɑ mi, kpɑ biti yu bu mwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Kon de bu bɛɛ tɑbu wɔri kpɑ i yɑrinɑ i dɑ tem tukumɔ. Kpɑ bɛɛn wusu su ko bɑnsu. ");
INSERT INTO bqp_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Sɑɑ yè sɔɔ i ko i n wɑ̃ɑ tem tukum mi, bɛɛn tem mɛ, mu koo wɛ̃rɑ, wɛ̃rɑ bi i ǹ dɑɑ mu wɛ̃ɛre. ");
INSERT INTO bqp_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Be bɑ koo tiɑrɑ bɑ n wɑ̃ɑ yibɛrɛbɑn temɔ, kon de bu nuki sɑnkirɑ. Bɑɑ wuru kokosun dɑmu, gɑ koo de bu dukɑ yɑkurɑwɑ. Bɑ koo yɑkurɑwɑ nge be bɑ yibɛrɛbɑ wɑ bɑ tɑbu yɑ̃nu nɛni bɑ kɑ bu nɑɑ gire. Bɑ koo wɔrukuwɑ bɑɑ goo ù kun bu nɑɑ swĩi. ");
INSERT INTO bqp_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Bɑ koo wɔrikinɑwɑ nge be bɑ goonɑmɔ tɑbu sɔɔ kɑ tɑkobi. Bɑ ǹ kpɛ̃ bu yɔ̃rɑ bu ben yibɛrɛbɑ mɑ. ");
INSERT INTO bqp_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Bɑ koo gbiwɑ bwese tukunun suunu sɔɔ. Kpɑ yibɛrɛbɑ bu bu kɑm koosiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Be bɑ koo tiɑrɑ yibɛrɛbɑn tem mi, bɑ koo woorɑwɑ kɑ nuku sɑnkirɑnu ben torɑnun sɔ̃ kɑ ben bɑɑbɑbɑginun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Isireli be bɑ tiɑrɑ, bɑ koo ben torɑnu tuubɑ ko kɑ ben bɑɑbɑbɑginu ni bɑ kuɑ nɛ, Yinni Gusunɔn wuswɑɑɔ kɑ sere seesi bi bɑ mɑn seesi. ");
INSERT INTO bqp_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Bɑ koo giɑ mɑ nɛnɑ nɑ bu seesi mɑ nɑ kɑ bu dɑ tem tukumɔ ben yibɛrɛbɑn mi. Sɑɑ ye sɔɔrɑ bɑ koo tii kɑwɑ ben nɑɑnɛ sɑrirun sɔ̃ kpɑ bu giɑ mɑ nɛnɑ nɑ bu sɛɛyɑsiɑmɔ ben torɑnun sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Sɑɑ ye sɔɔ, kon nɛn ɑrukɑwɑnibɑ yɑɑyɑ ye nɑ bɔkuɑ kɑ ben bɑɑbɑbɑ. Berɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu. Kon mɑɑ nɛn nɔɔ mwɛɛru yɑɑyɑ te nɑ kuɑ ben tem sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ben biru, tem mɛ, mu koo wɛ̃rɑ. Sɑɑ ye sɔɔrɑ bɑ koo sɛɛyɑsiɑbu wɑ yèn sɔ̃ bɑ nɛn woodɑbɑ deri. ");
INSERT INTO bqp_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Adɑmɑ bɑɑ bɑ̀ n wɑ̃ɑ tem tukumɔ ben yibɛrɛbɑn mi, nɑ ǹ bu derimɔ mɑm mɑm. Nɑ ǹ bu biru kisimɔ, nɑ ǹ mɑɑ bu kpeerɑsiɑmɔ. Nɑ ǹ nɛn ɑrukɑwɑni ye kusiɑmɔ. Domi nɑ sɑ̃ɑwɑ Gusunɔ ben Yinni. ");
INSERT INTO bqp_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ben ɑrufɑɑnin sɔ̃ kon ɑrukɑwɑni ye yɑɑyɑ ye nɑ kɑ ben bɑɑbɑbɑ bɔkuɑ mi, ye yɑ derɑ nɑ bu yɑrɑ Egibitin di bwesenu kpuron nɔni biru, mɑ nɑ kuɑ ben Yinni. Nɛnɑ Yinni Gusunɔ. ");
INSERT INTO bqp_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Woodɑ kɑ sɔ̃ɔsi niniwɑ Yinni Gusunɔ u Mɔwisi wɛ̃ Sinɑin guurɔ u kɑ Isirelibɑ sɔ̃. ");
INSERT INTO bqp_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bqp_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ɑ Isirelibɑ woodɑ yeni sɔ̃ɔwɔ ɑ nɛɛ, goo ù n nɔɔ mwɛɛru kuɑ u nɛɛ, u koo nɛ, Yinni Gusunɔ tɔnu kɛ̃, u koo kpĩ u gobi kɔsiɑ tɔnu win ɑyerɔ nge mɛni u kɑ win nɔɔ mwɛɛru yibiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Sɑɑ tɔn durɔ wi u wɔ̃ɔ yɛndu mɔn di n kɑ dɑ wɔ̃ɔ wɑtɑgii, sii geesun gobi weerɑɑkurɑ u koo kɔsiɑ nge mɛ bɑ rɑ sɑ̃ɑ yerun gobi kɔsi. ");
INSERT INTO bqp_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ǹ n tɔn kurɔn nɑ, sii geesun gobi tɛnɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Tɔn durɔ wi u mɔ wɔ̃ɔ nɔɔbu n kɑ dɑ wɔ̃ɔ yɛndugii, sii geesun gobi yɛndɑ u koo kɔsiɑ. Ǹ n mɑɑ tɔn kurɔn nɑ, sii geesun gobi wɔkuru. ");
INSERT INTO bqp_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Sɑɑ tɔn durɔ suru tiɑgii sere n kɑ dɑ wɔ̃ɔ nɔɔbugii, sii geesun gobi nɔɔbuwɑ u koo kɔsiɑ. Ǹ n mɑɑ tɔn kurɔn nɑ, sii geesun gobi itɑwɑ u koo kɔsiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Goo ù n mɑɑ wɔ̃ɔ wɑtɑ mɔ ǹ kun mɛ ù n kere mɛ, sii geesun gobi wɔkurɑ nɔɔbuwɑ u koo kɔsiɑ. Ǹ n mɑɑ tɔn kurɔn nɑ, sii geesun gobi wɔkurɑ u koo kɔsiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Goo ù n sɑ̃ɑ sɑ̃ɑro too, mɑ u ǹ kpɛ̃ u kɔsiɑ mɛ bɑ geruɑ, bɑ koo kɑ yɛ̃ro dɑwɑ yɑ̃ku kowon mi, kpɑ yɑ̃ku kowo wi, u nùn sɔ̃ mɛ̀n nɔɔ u koo kɔsiɑ nge mɛ win wɑɑrɑ nɛ. ");
INSERT INTO bqp_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Goo ù n nɛ, Yinni Gusunɔ nɔɔ mwɛɛru kuɑ mɑ u koo mɑn yɑɑ sɑberu kɛ̃ te bɑ rɑ kɑ yɑ̃kuru ko, yɑɑ sɑbe te, tɑ ko n sɑ̃ɑwɑ nɛgiru. ");
INSERT INTO bqp_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Bɑ ǹ kɑ tu gɑru kɔsinɑmɔ te tɑ kun wɑ̃. Bɑɑ tɑ̀ kun mɑɑ wɑ̃, bɑ ǹ kɑ tu gɑru kɔsinɑmɔ te tɑ wɑ̃. Kɑ mɛ, bɑ̀ n mɑɑ kɑ tu kɔsinɑ, ni yiru kpuro nu ko n sɑ̃ɑwɑ nɛginu. ");
INSERT INTO bqp_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Goo ù n kɑ yɑɑ sɑberu nɑ te bɑ ku rɑ kɑ yɑ̃kuru ko, bɑ koo kɑ tu dɑwɑ yɑ̃ku kowon mi. ");
INSERT INTO bqp_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Kpɑ yɑ̃ku kowo u tu mɛɛri u ten geeru burɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Wi u kɑ yɑɑ sɑbe te nɑ, mɑ u kĩ u tu yɑkiɑ, gee te yɑ̃ku kowo u nùn bure, terɑ u koo kɔsiɑ. Kpɑ u mɑɑ gee ten bɔnu nɔɔbun tiɑ sosi. ");
INSERT INTO bqp_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Goo ù n win diru Yinni Gusunɔ kɑ̃, yɑ̃ku kowowɑ u koo dɑ u tu mɛɛri kpɑ u ten geerun sɑkɑ gere. Gee te u geruɑ mi, terɑ bɑ koo kɑ sɔmburu ko. ");
INSERT INTO bqp_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Adɑmɑ ù n kĩ u win dii te yɑkiɑ, u koo ginɑ gee te yɑ̃ku kowo u burɑ mi kɔsiɑwɑ kpɑ u ten wɔllɔ bɔnu nɔɔbusen tiɑ sosi dii te, tu sere mɑɑ ko wigiru. ");
INSERT INTO bqp_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Goo ù n mɑɑ win gberu Yinni Gusunɔ wɛ̃, bɑ koo ten geeru burɑwɑ. Dĩɑ ni bɑ koo duuren kpɑ̃ɑrɑ bɑ koo mɛɛri. Nge tɛ̃ bɑ̀ n dĩɑ ni bɑ mɔ̀ ɔɔsu duurɑ, mɑ nu kilo goobɑ wunɔbu (300) kuɑ, sii geesun gobi weerɑɑkurɑ bɑ koo kɔsiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ǹ n sɑ̃ɑn nɑ yɑkiɑbun tɔ̃ɔ bɑkɑrun diyɑ u gbee te wɛ̃, ten gobi kpurowɑ u koo kɔsiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ù n gbee te Yinni Gusunɔ wɛ̃ yɑkiɑbun tɔ̃ɔ bɑkɑrun biru, yɑ̃ku kowo u koo ten gobi kɑwɑwɑ. U koo wɔ̃ɔ si su tie sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turin gobi kɔsiɑwɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Yɛ̃ro ù n kĩ u win gbee te yɑkiɑ, u koo kɔsiɑwɑ ye bɑ burɑ mi, kpɑ u yen bɔnu nɔɔbun tiɑ sosi gbee te, tu sere mɑɑ ko wigiru. ");
INSERT INTO bqp_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ù kun tu yɑkie, mɑ bɑ tu goo dɔre, u ǹ mɑɑ kpɛ̃ u tu yɑkiɑ win tii. ");
INSERT INTO bqp_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ, tɑ koo kowɑ Yinni Gusunɔgiru. Yɑ̃ku kowobɑ bɑ ko n tu mɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Goo ù n Yinni Gusunɔ gberu wɛ̃ te u dwɑ, n ǹ mɔ te u tubi di, ");
INSERT INTO bqp_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","yɑ̃ku kowowɑ u koo tu mɛɛri kpɑ u ten geeru burɑ. U koo wɔ̃su gɑriwɑ si su tie yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi. Wɔ̃ɔ si kpuron gobiyɑ u koo gere kpɑ gobi yi, yi ko Yinni Gusunɔgii. ");
INSERT INTO bqp_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Adɑmɑ yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ, gbee te, tɑ ko n sɑ̃ɑwɑ wi u rɑɑ nùn tu dɔregiru. ");
INSERT INTO bqp_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bɑ koo gɑ̃ɑnu kpuron geeru burɑwɑ nge mɛ bɑ rɑ sɑ̃ɑ yerun gobi kɔsi. N deemɑ gobi yin tiɑn bunum mu rɑ n sɑ̃ɑwɑ gɑrɑmu wɔkuru. ");
INSERT INTO bqp_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Goo u ku rɑɑ win yɑɑ sɑberun buu gbiikuu Yinni Gusunɔ kɛ̃. Domi gɑ sɑ̃ɑwɑ Yinni Gusunɔguu kɔ yèn sɔ̃ gɑ sɑ̃ɑ buu gbiikuu. Bɑɑ ǹ n yɑ̃ɑrun nɑ ǹ kun mɛ kɛtɛ, gɑ sɑ̃ɑwɑ Yinni Gusunɔguu. ");
INSERT INTO bqp_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Gɑ̀ n mɑɑ sɑ̃ɑn nɑ sɑbe te bɑ ku rɑ kɑ yɑ̃kuru kon buu gbiikuu, wi u kɑ tu nɑ u koo kpĩ u tu yɑkiɑ ù n gee te yɑ̃ku kowo u nùn bure kɔsiɑ kpɑ u mɑɑ ten bɔnu nɔɔbun tiɑ sosi. Ù n kpɑnɑ u tu yɑkiɑ, yɑ̃ku kowo u koo kpĩ u tu goo dɔre nge mɛ u ten geeru bure. ");
INSERT INTO bqp_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Gɑ̃ɑ ni bɑ Yinni Gusunɔ kɑ̃ sere kɑ bɑɑdommɑɔ, ɑɑ tɔnuwɑ? Ǹ kun mɛ yɑɑ sɑberɑ? Ǹ kun mɛ gbee te u tubi diwɑ? Gɑ̃ɑ ni bɑ gɔsɑ bɑ yi Yinni Gusunɔn sɔ̃ gesi, n ǹ mɑɑ koorɔ u nu yɑkiɑ ǹ kun mɛ u nu dɔrɑ. Nu ko n sɑ̃ɑwɑ Yinni Gusunɔginu sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bqp_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Bɑɑ ǹ n tɔnun nɑ n ǹ koorɔ u nùn yɑkiɑ. Bɑ koo yɛ̃ro gowɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","I ko i n dɑ Yinni Gusunɔ bɛɛn gberun dĩɑnun subɑ wɔkuru sɔɔ tiɑ yiiyewɑ sere kɑ dɑ̃ɑ mɑrumɔ. ");
INSERT INTO bqp_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Goo ù n kĩ u ye yɑkiɑ, u koo yen gee te kɔsiɑwɑ kpɑ u mɑɑ yen bɔnu nɔɔbun tiɑ sosi. ");
INSERT INTO bqp_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mɛyɑ mɑɑ yɑɑ sɑbenu sɔɔ. Yɑ̃ɑrɑ? Kɛtɛwɑ? Boowɑ? Sɑbe ni bɑ kpɑre gesi, wɔkuru bɑɑteren wɔllɔ Yinni Gusunɔ u teeru mɔ. ");
INSERT INTO bqp_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Wi u sɑbe ni mɔ, u ǹ koo gɔsi te tɑ wɑ̃ ǹ kun mɛ te tɑ kun wɑ̃. U ǹ mɑɑ kɑ tu gɑru kɔsinɑmɔ. Bɑɑ ù n kɑ tu gɑru kɔsinɑ, ni yiru kpuro nu ko n sɑ̃ɑwɑ Yinni Gusunɔginu. N ǹ koorɔ bu nu yɑkiɑ. ");
INSERT INTO bqp_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Woodɑ yenibɑrɑ Yinni Gusunɔ u Mɔwisi wɛ̃ Isirelibɑn sɔ̃ Sinɑin guurɔ. ");
INSERT INTO bqp_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Dikiri yã ò Musanɛ Sinai gbárannan Isarailanↄ bona Misila wɛ̃̀ plade mↄ káaku gũn à pì: ");
INSERT INTO bqp_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Isarailanↄ gↄ̃ Vĩnla dikpɛ kɛ a gↄrↄa. ");
INSERT INTO bqp_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","À dikpɛ pì kɛ mↄ díkĩna gↄrↄ gɛ̃ro donsariden ↄkↄsi. À kɛ lákũ ma dàárɛ nà pínki kũ a dokayã kũ ma dàárɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Musa ò Isarailanↄnɛ ò Vĩnla dikpɛ kɛ, ");
INSERT INTO bqp_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","akũ ò dikpɛ pìi kɛ̀ Sinai gbárannan mↄ káaku gↄrↄ gɛ̃ro donsariden ↄkↄsi. Ò kɛ̀ lákũ Dikiri ò Musanɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Gbɛ̃kenↄ kú gwe ò gbãsĩ vĩ kũ ò ↄ nà gɛ̀ɛa yãi, akũ odi le ò Vĩnla dikpɛ kɛ̀ zĩ birearo. Akũ ò gɛ̀ɛ ò Musa kũ Harunao lè zĩ birea gↄ̃̀nↄ ");
INSERT INTO bqp_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ò pì Musanɛ: Gɛ̀ yã musu o gbã̀a lɛ̀. Bↄ́yãi ò gìwɛrɛ ò su kũ gbanↄ Dikirinɛ kũ ó gbɛ̃nↄo a gↄrↄaa? ");
INSERT INTO bqp_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa wèḿma à pì: À zɛ ari mà ma lákũ Dikiri ni o á yã musu nà. ");
INSERT INTO bqp_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Akũ Dikiri pì Musanɛ: ");
INSERT INTO bqp_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Ǹ o Isarailanↄnɛ, tó ń gbɛ̃kenↄ ke ń burinↄ kpɛ́ gbãsĩ vĩ gɛ̀ yã musu, ke ò gɛ̀ɛ wɛ̃tɛ zã̀zã ken, oni fↄ̃ ò Vĩnla dikpɛ kɛmɛnɛ kpɛkpɛ. ");
INSERT INTO bqp_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Mↄ plade gↄrↄ gɛ̃ro donsaride ↄkↄsin oni dikpɛ pì kɛ. Oni sã nↄ̀bↄ só kũ burodi futɛnasario kũ lá kyã̀kyãao. ");
INSERT INTO bqp_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Òsun a ke tó gu dↄ̀aro akũsↄ̃ òsun sã pì wá ke ɛ́ro. Oni Vĩnla dikpɛ pì kɛ lákũ ma dìtɛárɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Gbɛ̃ kũ adi gbã̀ lɛ́ro akũsↄ̃ adi gɛ́ wɛ̃tɛ kearo, tó à gì Vĩnla dikpɛ pì kɛi, ò ade bo a gbɛ̃nↄ tɛ́, zaakũ adi sumɛnɛ kũ gbao a gↄrↄaro. A taari ni wí a musu. ");
INSERT INTO bqp_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Bòasu kũ à kú á tɛ́ akũsↄ̃ à ye à Vĩnla dikpɛ kɛmɛnɛ, séde à kɛ lákũ ma a doka dìtɛárɛ nà. Bòasu kũ bedeo ń pínki yã dokↄ̃nↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Zĩ kũ ò bizakuta kũ̀ dↄ̀, tɛ́luku pìi dà sèeda kuta pìla. Naana zaa ↄkↄsi ari gu gɛ̀ɛ à dↄ̀o tɛ́luku pì kú kuta pìi musu lán tɛ́ bà. ");
INSERT INTO bqp_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Lɛn àdigↄ̃ kun lɛ gↄrↄ sĩnda pínki, àdigↄ̃ kú kuta pìla fãnantɛ̃, gwãani sↄ̃ lán tɛ́ bà. ");
INSERT INTO bqp_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tó à gò kuta pìia, akũ Isarailanↄ dì futɛ kũ táo. Gu kũ tɛ́luku pìi zɛ̀n, gwen òdi bùra kátɛn. ");
INSERT INTO bqp_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Tó Dikiri mↄ̀ńnɛ lɛ, òdi bùra futɛ. Tó à mↄ̀ńnɛ dↄ, òdi ɛra ò bùra kátɛ. Tó tɛ́luku pì da kuta pìla sↄ̃, ń bùraa dìgↄ̃ katɛnamɛ. ");
INSERT INTO bqp_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tó tɛ́luku pì tɛn gↄrↄ pla kɛ kuta pìla, òdigↄ̃ Dikiri yã ma, òdi bùra futɛro. ");
INSERT INTO bqp_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Zĩkenↄa tɛ́luku pìi dì gↄrↄ pla kɛ kutalaro. Tó Dikiri mↄ̀ńnɛ, òdi bùra kátɛ, tó Dikiri ɛ̀ra à mↄ̀ńnɛ dↄ, akũ òdi bùra futɛ. ");
INSERT INTO bqp_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Zĩkenↄa sↄ̃ tɛ́luku pìi dì zɛ gu dokↄ̃nↄ fíti zaa ↄkↄsi ari kↄnkↄ. Tó à gòa kↄnkↄ, akũ òdi bùra futɛ. Fãnantɛ̃ ke gwãanin yá, tó tɛ́luku pìi gòa, òdi bùra futɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tó tɛ́luku pìi gↄ̃̀ zɛna kuta pìla gↄrↄ do ke mↄ do ke wɛ̃̀ don yá, òdigↄ̃ katɛna bùran, òdi futɛro. Tó à gòa, akũ òdi bùra futɛ. ");
INSERT INTO bqp_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Òdi bùra kátɛ ke ò bùra futɛ Dikiri lɛ́ sariro. Òdigↄ̃ Dikiri yã ma lákũ à dà Musanɛ à òńnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Dikiri yã ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Ǹ kãkãki pi mɛ̀n pla kũ andurufu kũ ò gbɛ̃̀gbɛ̃ manamanao gbɛ̃nↄ kakarabↄ ũ de ò bùra futɛ. ");
INSERT INTO bqp_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Tó ò kãkãki pìnↄ pɛ̀, gbɛ̃nↄ ni su ò kakaranyĩ ń pínki dakarɛki kpɛ́lɛlɛa. ");
INSERT INTO bqp_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Tó kãkãki mɛ̀n don ò pɛ̀, Isaraila buri don'arɛde kũ ò de kína ũnↄ mɛ́ oni su ò kakaranyĩ. ");
INSERT INTO bqp_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Tó ò kãkãki pìnↄ pɛ̀ kũ yĩsãmpanaao, gbɛ̃ kũ ń bùra kú ifãboki kpanↄ mɛ́ oni bùra futɛ káaku. ");
INSERT INTO bqp_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Tó ò a gɛ̃̀n plade pɛ̀ kũ yĩsãmpanaao, gbɛ̃ kũ ń bùra kú gɛ̀nↄmidↄki kpanↄ mɛ́ oni bùra futɛ. Kãkãkipɛna kũ yĩsãmpanaao pìimɛ gbɛ̃nↄ dana zɛ́n sèeda ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Tó ò ye ò gbɛ̃nↄ kakara, ògↄ̃ pɛ́ yĩsãmpanaa sari. ");
INSERT INTO bqp_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Haruna nɛ́ sa'orinↄ mɛ́ oni kãkãki pìnↄ pɛ́. Anigↄ̃ deárɛ doka ũ gↄrↄ sĩnda pínki, ákↄ̃nↄ kũ á burinↄ. ");
INSERT INTO bqp_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Gↄrↄ kũ a ka á bùsun, tó átɛn gɛ́ zĩ̀ ká kũ á ibɛrɛ kũ oni sù ò futɛ kãáonↄ, àgↄ̃ kãkãki pìnↄ pɛ́ kũ yĩsãmpanaao, de á yã le à dↄ makũ Dikiri á Ludagu, mani á bo á ibɛrɛɛ pìnↄ ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Gↄrↄ kũ átɛn pↄnna kɛ sↄ̃, dikpɛn yá, mↄ dufu gↄrↄ káaku zĩn yá, àgↄ̃ kãkãki pìnↄ pɛ́ á sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũnↄa kũ á sáabukpana sa'opↄnↄ, á yã ni dↄmagu. Makũmɛ Dikiri á Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Wɛ̃̀ plade mↄ plade gↄrↄ barode zĩ, tɛ́luku gò sèeda kutala, ");
INSERT INTO bqp_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","akũ Isarailanↄ bùraa fùtɛ Sinai gbárannan, òtɛn bùra sↄ̃sↄ̃ ari tɛ́luku gɛ̀ɛ à zɛ̀ Parani gbárannan. ");
INSERT INTO bqp_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ń bùra futɛna káakun gwe. Ò kɛ̀ lákũ Dikiri dà Musanɛ à òńnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuda zĩ̀karinↄ mɛ́ ò bùraa fùtɛ gã̀ kũ gã̀ao káaku kũ ń tutaao. Aminadabu nɛ́ Nasↄ̃mɛ ń don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Zua nɛ́ Nɛtanɛlimɛ Isaka zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eloni nɛ́ Ɛliabumɛ Zɛbuluni zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Gɛsↄmu burinↄ kũ Mɛrari burinↄ kuta pìi gbòro, akũ ò sɛ̀ ò dào zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Akũ Rubɛni zĩ̀karinↄ bùraa fùtɛ gã̀ kũ gã̀ao kũ ń tutaao. Sedeu nɛ́ Ɛlizumɛ ń don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Zurisadai nɛ́ Selumiɛlimɛ Simɛↄ zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Dɛwɛli nɛ́ Ɛliasafamɛ Gada zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Akũ Koa burinↄ Luda pↄ́nↄ sɛ̀ ò dào zɛ́n. Ò kuta pìi dↄ̀ ari ògↄ̃ ká. ");
INSERT INTO bqp_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Akũ Ɛflaimu zĩ̀karinↄ bùraa fùtɛ gã̀ kũ gã̀ao kũ ń tutaao. Amiudu nɛ́ Ɛlisamamɛ ń don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pedazu nɛ́ Gamaliɛlimɛ Manase zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gideoni nɛ́ Abidãmɛ Biliaminu zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Akũ Dã zĩ̀karinↄ bùraa fùtɛ gã̀ kũ gã̀ao kũ ń tutaao. Mↄ́kↄ̃nↄ mɛ́ òdigↄ̃ tɛ́ kpɛkpɛ. Amisadai nɛ́ Ayɛzamɛ ń don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ɔkↄrana nɛ́ Pagiɛlimɛ Asa zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enana nɛ́ Airamɛ Nafatali zĩ̀karinↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Lákũ Isarailanↄ dì bùra futɛfutɛ ògↄ̃ tɛ́tɛkↄ̃i nàn gwe gã̀ kũ gã̀ao. ");
INSERT INTO bqp_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Obabumɛ Musa anzure Ruɛli nɛ́ ũ, Midiã burimɛ. Musa pìnɛ: Ótɛn da zɛ́n ò gɛ́ bùsu kũ Dikiri pì áni ó gban. Ǹ mↄ́ ǹ gɛ́ kũoo, óni yã mana kɛnnɛ, zaakũ Dikiri nnamana gwe lɛ́ sɛ̀wɛrɛ. ");
INSERT INTO bqp_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Akũ à pìnɛ: Mani gɛ́ro, mani ɛra ma bùsun ma bedenↄ kĩnaamɛ. ");
INSERT INTO bqp_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa pì: N yã nna. Ǹsun ó tónlo, zaakũ ń bùrakatɛki mana dↄ̃ akũsↄ̃ mↄkↄ̃n mɛ́ ĩni kɛ ó wɛ́de ũ. ");
INSERT INTO bqp_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Tó n gɛ kũoo, óni yã mana kũ Dikiri ni kɛwɛrɛ kɛnnɛ se. ");
INSERT INTO bqp_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Isarailanↄ bùraa fùtɛ Dikiri kpi sarɛ ò táa ò gↄrↄ aakↄ̃. Ò dò arɛ kũ Dikiri bàka kunna kũńwo àkpatiio de à bùrakũki mↄńnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Tó ò fùtɛ ò dà zɛ́n, Dikiri tɛ́luku pìi dìgↄ̃ kúńla fãnantɛ̃. ");
INSERT INTO bqp_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tó ò dà zɛ́n kũ àkpatiio, Musa dì pi: Ǹ futɛ Dikiri, de n ibɛrɛnↄ fãkↄ̃a, n zãngurinↄ bàa lɛ́nnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Tó ò dìtɛ, Musa dì pi: Dikiri, ǹ ɛra ǹ su Isaraila dúbu ũgbangbanↄa. ");
INSERT INTO bqp_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Isarailanↄ zuka kà Dikirii ń warikɛna yãi. Kũ Dikiri mà, à pↄ fɛ̃̀, akũ a tɛ́ fùtɛ ń tɛ́, ń bùra kpado tɛ́ kũ̀. ");
INSERT INTO bqp_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Akũ gbɛ̃nↄ wiki lɛ̀ Musaa. Kũ à wɛ́ kɛ̀ Dikiria, akũ tɛ́ pìi zɛ̀. ");
INSERT INTO bqp_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Akũ ò tↄ́ kpà gu pìinɛ Tabera, kũ Dikiri tɛ́ fùtɛ ń tɛ́ gwe yãi. ");
INSERT INTO bqp_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Buri pãndenↄn kú Isarailanↄ tɛ́, òtɛn pↄ́ble pãnde ni dɛ, akũ Isarailanↄn tɛn ↄ́ↄ dↄ se ò pì: Mán óni nↄ̀bↄ len ò sóo? ");
INSERT INTO bqp_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ótɛn kpↄ̀ kũ o sò Misila ó pↄyeinaaa bɛgɛ kɛ kũ plɛ̃̀nↄ kũ gbɛzɛnↄ kũ ɛfↄnↄ kũ arubasanↄ kũ arubasa gizonↄo. ");
INSERT INTO bqp_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Tera sà ó lɛ́ gà, zaakũ odì pↄ́ke lero, séde mana dí baasiro. ");
INSERT INTO bqp_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manaa pì wɛ́ kete, à de lán lí'ↄ bàmɛ. ");
INSERT INTO bqp_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Isarailanↄ dì sɛ́tɛ ò lↄ́ gbɛ̀n ke òdi zↄ̃ gón. Òdi disa ò kàra kɛo. A nna lán kàra asãnaa bà. ");
INSERT INTO bqp_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Tó plí kpà bùran gwãani, akũ manaa pìi dì kↄ́tɛ se. ");
INSERT INTO bqp_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa mà òtɛn ↄ́ↄ dↄ ↄnlɛ kũ ↄnlɛo. Dikiri pↄ fɛ̃̀ manamana, akũ à kɛ̀ Musanɛ ĩni ");
INSERT INTO bqp_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","à pìnɛ: Bↄ́yãin ntɛn wɛ́ tãmaii? Ma yã kpate mɛ́ à kɛ̀nnɛ vãni, akũ n gbɛ̃ pìnↄ gwana aso dìmɛnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Makũ mɛ́ ma gbɛ̃ pìnↄ nↄ̀ↄ sì yá? Makũ mɛ́ ma ń í yá? Bↄ́yãi n pìmɛnɛ mà ń kú kpɛ lán nɛ́rande bà mà gɛ́ kũńwo bùsu kũ n la dà ń dizinↄnɛnn? ");
INSERT INTO bqp_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Mákpan mani nↄ̀bↄ len mà kpá gbɛ̃ pìnↄa ń pínkii? Zaakũ òtɛn ↄ́ↄ dↄmɛnɛ òtɛn pi mà ń gba nↄ̀bↄↄ ò só. ");
INSERT INTO bqp_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mani fↄ̃ mà gbɛ̃ pìnↄ aso sɛ́ ń pínki madoro, zaakũ ń aso demala. ");
INSERT INTO bqp_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tó lɛn ĩni kɛmɛnɛ lɛ, ǹ tó ma n pↄnna le ǹ ma dɛ gↄ̃̀nↄ. Ǹsun tó mà wari pì kɛ doro. ");
INSERT INTO bqp_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Akũ Dikiri pìnɛ: Ǹ Isaraila gbɛ̃ zↄ̃kↄ̃ kũ ń ń dↄ̃ don'arɛde ũnↄ kakara gbɛ̃nↄn baaakↄ̃ akuri ǹ su kũńwo dakarɛki kuta kia ògↄ̃ kú kũnwo gwe. ");
INSERT INTO bqp_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mani kipa mà yã onnɛ gwe mà a Nini kũ à kúmma kpado go mà dińnɛ, oni gbɛ̃nↄ gwana aso sɛ́ kũnwo de ǹsungↄ̃ ń sɛna ndo doro yãi. ");
INSERT INTO bqp_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ǹ o gbɛ̃nↄnɛ ò gbã̀ bo ń zĩdanɛ zia yãi, oni nↄ̀bↄ le ò só. Zaakũ ò ↄ́ↄ dↄ̀mɛnɛ ò pì, mán óni nↄ̀bↄ len la ò sóo? Ò pì ò sã̀na Misila. Abire yãin mani ń gba nↄ̀bↄ ò só. ");
INSERT INTO bqp_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Oni só adi kɛ gↄrↄ donlo, gↄrↄ planlo, gↄrↄ sↄↄronlo, gↄrↄ kurinlo, gↄrↄ baronlo. ");
INSERT INTO bqp_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Oni só mↄ do gbãngbãn ari à bo ń yĩn a ni bo ń pↄn. Zaakũ makũ Dikiri má kú ń tɛ́, akũ ò pã kpàmai. Ò zuka dↄ̀ma ò pì, bↄ́yãi ò bò Misilai? ");
INSERT INTO bqp_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Akũ Musa pì: Gↄ̃gbɛ̃nↄn kú kũmao tá gũn gbɛ̃nↄn dúbu wàa aakↄ̃, akũ n pì ĩni nↄ̀bↄ kpáḿma ò só ari mↄ do gbãngbãn yá? ");
INSERT INTO bqp_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bee tó ò sãnↄ kũ zùnↄ dɛ̀dɛ dasidasi, ani mↄ́ḿma yá? Tó ò ísira kpↄ̀nↄ sɛ̀tɛ pínki, ani mↄ́ḿma yá? ");
INSERT INTO bqp_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Dikiri wèa à pì: Ma gbãna ni kánloo? Ĩni e tera, tó yã kũ ma ònnɛ ni kɛ ke ani kɛro. ");
INSERT INTO bqp_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa bò à Dikiri yã pìnↄ òńnɛ. À Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kàkara gbɛ̃nↄn baaakↄ̃ akuri à ń zɛ́ ò lìka kuta pìii. ");
INSERT INTO bqp_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Akũ Dikiri kìpa tɛ́luku gũn à yã ò kãao. À a Nini kũ à kúa kpado gò à dì gbɛ̃ zↄ̃kↄ̃ gbɛ̃nↄn baaakↄ̃ akurii pìnↄnɛ. Kũ à a Nini pìi dìńnɛ lɛ, ò annabikɛyã ò, abire gbɛra odi ɛra ò kɛ̀ doro. ");
INSERT INTO bqp_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Gbɛ̃ kũ Musa ń sɛ́ gbɛ̃nↄn planↄ gↄ̃̀ bùran, gbɛ̃ do tↄ́n Ɛlɛdada, gbɛ̃ do sↄ̃ Mɛdada. Odi gɛ́ kuta kĩnaaro, ama Nini pìi sùḿma se, akũ ò annabikɛyã ò bùran. ");
INSERT INTO bqp_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Kɛfɛnna ke bàa lɛ̀ à gɛ̀ɛ à pì Musanɛ: Ɛlɛdada kũ Mɛdadao tɛn annabikɛyã o bùran. ");
INSERT INTO bqp_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nuni nɛ́ Yↄsuamɛ Musa kpàasi ũ zaa a kɛfɛnnakɛgↄrↄa, akũ à pì: Baa Musa, ǹ gíńnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Akũ Musa pìnɛ: Ntɛn nɛ̀sɛgↄ̃ba kɛ kũńwo ma yã musun yá? Tó Dikiri a Nini dì a gbɛ̃nↄnɛ ò gↄ̃̀ annabinↄ ũ ń pínki, à manaroo? ");
INSERT INTO bqp_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Akũ Musa ɛ̀ra bùran kũ Isarailanↄ gbɛ̃ zↄ̃kↄ̃ↄ pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Dikiri tò ĩa bò ísira kpa à sù kũ kpɛkpɛrɛwinↄ, ò dà bùrala. Ò lìka bùraai gu sĩnda pínki à kà tágↄrↄ do ũ, akũsↄ̃ ń vurana lei kà gã̀sãkuru pla. ");
INSERT INTO bqp_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Fãnantɛ̃ birea kũ gwãanio kũ a gu làa dↄnaao ò fùtɛ ò gɛ̀ɛ ò kpɛkpɛrɛwinↄ kũ̀kũ. Gbɛ̃ kũ adi kũkũ dasiro kũ̀kũ bùruma baro. Akũ ò fã̀tɛ à kori kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kũ ò a nↄ̀bↄↄ dà ń lɛ́n gↄ̃̀nↄ, odi le ò só dasiro, akũ Dikiri pↄ fɛ̃̀ńyĩ à gagagyã kàńgu. ");
INSERT INTO bqp_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Akũ ò tↄ́ kpà gu pìinɛ Lɛ́'idenↄ Mira, zaakũ gwen ò gbɛ̃ kũ nↄ̀bↄ lɛ́'i ń kũnↄ vĩ̀n. ");
INSERT INTO bqp_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Akũ Isarailanↄ fùtɛ gwe ò gɛ̀ɛ Azero ò gↄrↄ pla kɛ̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu kũ Harunao Musa taari è Etiopia nↄ kũ à sɛ̀ yã musu, zaakũ à Etiopia nↄ sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ò pì: Musa adon Dikiri dìtɛ à yã ò a gãi yá? Adi o ó gãi seroo? Dikiri yã pìi mà. ");
INSERT INTO bqp_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa bi gbɛ̃ busɛɛmɛ, a sára kú andunia gũnlo. ");
INSERT INTO bqp_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gwe gↄ̃̀nↄ Dikiri pì Musa kũ Harunao kũ Miriamuoonɛ: À bↄtɛ à gɛ́ dakarɛki kuta kia á gbɛ̃nↄn aakↄ̃. Akũ ò gɛ̀ɛ ń gbɛ̃nↄn aakↄ̃ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Dikiri kìpa tɛ́luku gũn à zɛ̀ kuta pì kpɛ́lɛlɛa. À Haruna kũ Miriamuo sìsi, akũ ò nài ń pla ń pínki. ");
INSERT INTO bqp_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","À pìńnɛ: À ma yã ma. Tó ma annabi ke kú á tɛ́, madì bo mà sua wɛ́gupu gũn madì yã onɛ nana gũmmɛ. ");
INSERT INTO bqp_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ama à de lɛ kũ ma zↄ̀bleri Musaoro. Zĩkɛri náanidemɛ ma ↄn gbɛ̃nↄ tɛ́ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Odì yã bo kↄ̃ lɛ́n. Madì yã onɛ mà a ke utɛnɛro. Àdi wɛ́ si ma takalɛ. À kɛ̀ dera ádi ma zↄ̀bleri Musa taari'ena vĩna kɛroo? ");
INSERT INTO bqp_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Akũ Dikiri pↄ fɛ̃̀ńyĩ à a tá o. ");
INSERT INTO bqp_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kũ tɛ́luku pìi gò kuta pìla, kusu dà Miriamula gↄ̃̀nↄ, à pura kũ̀ lán buu bà. Kũ Haruna lìtɛ à a gwà, à è kusu dàala, ");
INSERT INTO bqp_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","akũ à pì Musanɛ: N yã nna Baa! Ǹsun tó ò yↄ̃nkↄyã taarikɛnaa gbɛ̀ lero. ");
INSERT INTO bqp_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ǹsun tó àgↄ̃ de lán nɛ́ kũ ò ì gɛ̀ ũ a mɛ̀ kpado yàkanaa bàro. ");
INSERT INTO bqp_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa ↄ́ↄ dↄ̀ Dikirinɛ à pì: Luda, n yã nna! Ǹ a werekↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Akũ Dikiri pìnɛ: Tó a de mɛ́ à lɛ́'i fã̀ a ãnnwa, ani kɛnɛ wé'iyã ũ ari gↄrↄ supplaroo? Ò bo kãao bùra kpɛ gↄrↄ suppla gĩa, gbasa ò a sí. ");
INSERT INTO bqp_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriamu kú bùra kpɛ ari gↄrↄ suppla. Isarailanↄ dí da zɛ́nlo sé kũ ò ɛ̀ra ò a sì. ");
INSERT INTO bqp_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Abire gbɛra ò fùtɛ Azero ò gɛ̀ɛ ò bùraa kàtɛ Parani gbárannan. ");
INSERT INTO bqp_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Dikiri pì Musanɛ: ");
INSERT INTO bqp_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Ǹ gbɛ̃nↄ zĩ ò gɛ́ Kanaanↄ bùsu kũ matɛn kpá Isarailanↄa yakɛ. Ǹ ń dizinↄ buri gbɛ̃ kũ ò de don'arɛde ũnↄ sɛ́ mɛ̀n dodo ǹ ń zĩ. ");
INSERT INTO bqp_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Akũ à ń gbárɛ lɛ bona Parani gbárannan lákũ Dikiri ò nà. Gbɛ̃ pìnↄ bi Isaraila don'arɛdenↄmɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ń tↄ́nↄn dí: Rubɛni burinↄ gũn Zaku nɛ́ Samua, ");
INSERT INTO bqp_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simɛↄ burinↄ gũn Ori nɛ́ Safata, ");
INSERT INTO bqp_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yuda burinↄ gũn Yefunɛ nɛ́ Kalɛbu, ");
INSERT INTO bqp_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isaka burinↄ gũn Yusufu nɛ́ Igali, ");
INSERT INTO bqp_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ɛflaimu burinↄ gũn Nuni nɛ́ Osea, ");
INSERT INTO bqp_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Biliaminu burinↄ gũn Rafu nɛ́ Paliti, ");
INSERT INTO bqp_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zɛbuluni burinↄ gũn Sodi nɛ́ Gadiɛli, ");
INSERT INTO bqp_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yusufu nɛ́ Manase burinↄ gũn Susi nɛ́ Gadi, ");
INSERT INTO bqp_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dã burinↄ gũn Gɛmali nɛ́ Amiɛli, ");
INSERT INTO bqp_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asa burinↄ gũn Mukaila nɛ́ Setu, ");
INSERT INTO bqp_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nafatali burinↄ gũn Vofosi nɛ́ Nabi, ");
INSERT INTO bqp_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gada burinↄ gũn Maki nɛ́ Guɛli. ");
INSERT INTO bqp_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Gbɛ̃ kũ Musa ń zĩ bùsu yakɛnↄn gwe. Musa tↄ́ kpà Nuni nɛ́ Oseanɛ Yↄsua. ");
INSERT INTO bqp_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kũ Musa tɛni ń zĩ Kanaanↄ bùsu yakɛ, à pìńnɛ: À bↄtɛ kũ Nɛgɛvi gbárannao à dí bùsu gusĩsĩdea. ");
INSERT INTO bqp_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","À gwa lákũ bùsuu pì de nà, tó a gbɛ̃nↄn gbãna kesↄ̃ ò busɛ, tó ò dasi kesↄ̃ ò dasiro, ");
INSERT INTO bqp_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","tó ń bùsu mana kesↄ̃ à vãni, tó ń wɛ̃tɛnↄn bĩni vĩ kesↄ̃ à vĩro, ");
INSERT INTO bqp_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","tó a zĩtɛ gbãna kesↄ̃ à bùsa, tó à línↄ vĩ kesↄ̃ à vĩro. À kokari kɛ à bùsuu pì línɛnↄ sɛ́tɛ à suo. Zaakũ geepi nɛ́ káakunↄ mana gↄrↄn dí. ");
INSERT INTO bqp_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Akũ ò gɛ̀ɛ ò bùsuu pìi yakɛ̀ zaa Zini gbárannan ari Reobo, Lebo Amata kpa. ");
INSERT INTO bqp_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Kũ ò bↄ̀tɛ kũ Nɛgɛvi gbárannao, ò kà Ɛblↄnu, gu kũ Anaki burinↄ Aima kũ Sesaio kũ Talamaio kún. Ɛblↄnu katɛna Zoã kũ à kú Misila ã wɛ̃̀ supplamɛ. ");
INSERT INTO bqp_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kũ ò kà Ɛsɛkↄlu guvutɛn, ò geepi línɛyↄ̃ do zↄ̃̀ gwe ò lòko lía, akũ gbɛ̃nↄn planↄn sɛna. Ò bísi kũ kakapuraoo sɛ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ò tↄ́ kpà gu pìinɛ Ɛsɛkↄlu guvutɛ, geepi línɛyↄ̃ kũ Isarailanↄ zↄ̃̀ gwe yãi. ");
INSERT INTO bqp_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kũ ò bùsuu pìi yakɛ̀ gↄrↄ bupla, akũ ò ɛ̀ra ò sù. ");
INSERT INTO bqp_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Kũ ò sù Kadɛsi, Parani gbárannan, ò gɛ̀ɛ Musa kũ Harunao kũ Isarailanↄ kĩnaa pínki. Ò sù kũ baaruuo Isarailanↄnɛ ń pínki, akũ ò bùsuu pì línɛnↄ mↄ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ò yã pìi gbã̀ Musanɛ ò pì: O gɛ bùsu kũ n ó zĩn. Vĩ kũ zↄ́'io di gwe. A línɛnↄn dí. ");
INSERT INTO bqp_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ama bùsupidenↄ gbãna. Ń wɛ̃tɛnↄn bĩni vĩ akũsↄ̃ ń wɛ̃tɛ pìnↄn zↄ̃kↄ̃ manamana. O Anaki burinↄ è gwe se. ");
INSERT INTO bqp_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛkinↄn kú Nɛgɛvi gbárannan. Itinↄ kũ Yebusinↄ kũ Amↄrinↄn kú bùsu gusĩsĩden, akũsↄ̃ Kanaanↄn kú ísira sarɛ kũ Yoda sarɛo. ");
INSERT INTO bqp_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalɛbu gbɛ̃nↄ lɛ́ yĩ̀tɛ Musa arɛ, akũ à pì: Ò gɛ́ ò bùsu pì sí, zaakũ óni fↄ̃ ò zĩ̀ bleḿma. ");
INSERT INTO bqp_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Akũ gbɛ̃ kũ ò gɛ̀ɛ kãaonↄ pì: Óni fↄ̃ ò lɛ́tɛ gbɛ̃ pìnↄaro, zaakũ ń gbãna deóla. ");
INSERT INTO bqp_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Akũ ò bùsu kũ ò yakɛ̀ɛ pì gya bò Isarailanↄnɛ ò pì: Bùsu kũ o yakɛ̀ɛ pì bi bùsu kũ àdi a gbɛ̃nↄ mↄ́mↄmɛ. Gbɛ̃ kũ o ń é gwenↄ ń pínki bi gbɛ̃ gbã̀nanↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","O gbɛ̃ gbã̀nagbãnanↄ è gwe Anaki burinↄ ũ. O ó zĩda è lán babanɛnↄ bà, lɛn ó de lɛ ń wɛ́n se. ");
INSERT INTO bqp_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Isarailanↄ tɛn wiki gbãna lɛ́ ń pínki, òtɛn ↄ́ↄ dↄ gwãani pìa. ");
INSERT INTO bqp_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ò zuka dↄ̀ Musaa kũ Harunao ń pínki ò pìńnɛ: Tó o gaga Misila kesↄ̃ gbárannan la, de à kɛ̀ mana. ");
INSERT INTO bqp_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bↄ́yãin Dikiri tɛn tá kũoo bùsuu pìnn? Oni ó dɛdɛ kũ fɛ̃nɛdaomɛ, oni ó nↄgbɛ̃nↄ kũ ó nɛ́nↄ kũkũ. Ó ɛrana Misila sã̀naroo? ");
INSERT INTO bqp_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Akũ ò pìkↄ̃nɛ: Ò don'arɛde bo ò ɛra ò tá Misila. ");
INSERT INTO bqp_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa kũ Harunao wùtɛ ń nɛ̀sɛlɛ kutɛna pari arɛ. ");
INSERT INTO bqp_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Akũ bùsuyakɛrinↄ gbɛ̃nↄn pla Nuni nɛ́ Yↄsua kũ Yefunɛ nɛ́ Kalɛbuo ń utanↄ gàga ò kɛ̃̀kɛ̃ ");
INSERT INTO bqp_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ò pì gbɛ̃nↄnɛ: Bùsu kũ o bↄtɛn o yakɛ̀ɛ pì mana manamana. ");
INSERT INTO bqp_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Tó ó yã kà Dikirigu, ani gɛ́ kũoo bùsuu pìn, bùsu kũ vĩ kũ zↄ́'io din pìia, à ó gba. ");
INSERT INTO bqp_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Àsun bo Dikiri kpɛro. Àsun vĩna kɛ bùsupidenↄnɛro, zaakũ ó pↄ́blenↄmɛ, ò utɛki vĩ doro. Dikiri kú kũoo, àsun vĩna kɛro. ");
INSERT INTO bqp_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Gbɛ̃ sĩnda pínki tɛni pi ò ń pápa kũ gbɛ̀ɛo, akũ Dikiri gakuri bò à sù Isarailanↄa dakarɛki kuta kia. ");
INSERT INTO bqp_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Dikiri pì Musanɛ: Gbɛ̃ pìnↄ nigↄ̃ ma gya bo gↄrↄ sĩnda pínkin yá? Bee kũ daboyã dasi kũ ma kɛ̀ ń tɛ́nↄ, onigↄ̃ gí ma náani kɛi gↄrↄ sĩnda pínkin yá? ");
INSERT INTO bqp_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mani gagagyã káńyĩ mà ń kakatɛ, mani n burinↄ kɛ dasi, ń gbãna nigↄ̃ de gbɛ̃ pìnↄla. ");
INSERT INTO bqp_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Akũ Musa pì Dikirinɛ: Mↄkↄ̃n mɛ́ n gbɛ̃ pìnↄ bↄ̀tɛ Misila kũ n gbãnao. Tó Misilanↄ mà, ");
INSERT INTO bqp_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","oni gí o bùsu dí denↄnɛiro. Zaakũ ò dↄ̃ kũ ń kú kũoo, ndì bo ǹ suwá tɛ̃tɛ̃ntɛ̃. Ò dↄ̃ kũ n tɛ́luku dìgↄ̃ kú ó musu, ndì dowɛrɛ arɛ a gũn fãnantɛ̃, gwãani sↄ̃ tɛ́ gũn. ");
INSERT INTO bqp_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Tó n gbɛ̃ pìnↄ dɛ̀ kãnto gↄ̃̀nↄ, buri kũ ò yã pìi mànↄ ni pi: ");
INSERT INTO bqp_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Dikiri fùa à gɛ́ kũ gbɛ̃ pìnↄ bùsu kũ à la dàńnɛn, abire yãin à ń dɛdɛ gbárannan. ");
INSERT INTO bqp_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Dikiri, ǹ n gbãna zↄ̃kↄ̃ mↄńnɛ sà, lákũ n ò nà n pì ");
INSERT INTO bqp_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ndì pↄ fɛ̃ likalikaro, ń gbɛ̃kɛ vĩ zↄ̃kↄ̃, ndì gbɛ̃nↄ yã vãninↄ kũ ń taarinↄ kɛ̃ḿma, ama ndì tó taaride bò pãro. Ndì denↄ yã vãninↄ wí ń burinↄ musu ari à gɛ́ à pɛ́ ń sãkpɛnↄa kũ ń nasionↄ. ");
INSERT INTO bqp_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Lákũ n sùruu kɛ̀ kũ gbɛ̃ pìnↄo nà zaa Misila ari ò gɛ̀ɛ ò kào la, ǹ ń durunna kɛ̃ḿma n gbɛ̃kɛ zↄ̃kↄ̃ↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Akũ Dikiri pì: Lákũ n wɛ́ kɛ̀ma nà, mani sùru kɛ kũńwo. ");
INSERT INTO bqp_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ama lákũ madìgↄ̃ kun nà akũsↄ̃ ma gakuri dà anduniala pínki, ");
INSERT INTO bqp_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","gbɛ̃ kũ ò ma gakuri è kũ daboyã kũ ma kɛ̀ Misila kũ gbáranna gũnwo kũ ò ma lɛ ò ma gwa gɛ̃̀n kuri ò gì ma yã mainↄ, ");
INSERT INTO bqp_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ń gbɛ̃ke ni wɛ́ sí bùsu kũ ma la dà ń dizinↄnɛɛ pìlɛro. Gbɛ̃ kũ ò ma gya bònↄ ke ni wɛ́ sialɛro. ");
INSERT INTO bqp_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Lákũ ma zↄ̀bleri Kalɛbu nɛ̀sɛɛ bò ado nà, à tɛ́mai kũ nɛ̀sɛ doo, mani tó à gɛ̃ bùsu kũ à gɛ̀ɛn pìi gũn, a burinↄ ni le túbi ũ. ");
INSERT INTO bqp_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Zaakũ Amalɛkinↄ kũ Kanaanↄn kú guvutɛn gwe, à ɛra à da gbáranna zɛ́n zia Isira Tɛ̃ra kpa. ");
INSERT INTO bqp_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Dikiri pì Musanɛ kũ Harunao: ");
INSERT INTO bqp_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Gbɛ̃ vãni dínↄ ni zuka kámai gↄrↄ sĩnda pínkin yá? Ma zuka kũ òtɛn kámai mà. ");
INSERT INTO bqp_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ǹ pińnɛ makũ Dikiri ma pì má kun. Lákũ ò wɛ́ kɛ̀ma nà, lɛn mani kɛńnɛ lɛ. ");
INSERT INTO bqp_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ń gɛ̀nↄ ni gↄ̃ kátɛ gbárannan la, ń gbɛ̃ kũ ò kà wɛ̃̀ baro ke à dealanↄ pínki. Ń gbɛ̃ kũ ò ń náro akũsↄ̃ ò zuka kàmainↄ ");
INSERT INTO bqp_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ni gɛ̃ bùsu kũ ma a la dàńnɛnlo, séde Yefunɛ nɛ́ Kalɛbu kũ Nuni nɛ́ Yↄsuao baasiro. ");
INSERT INTO bqp_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ń nɛ́ kũ ò pì oni ń kũkũnↄn mani gɛ̃ kũńwo, de ò bùsu kũ ń denↄ gìi pì nna ma. ");
INSERT INTO bqp_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mↄ́kↄ̃nↄ sↄ̃, ń gɛ̀nↄ ni gↄ̃ katɛna gbárannan lamɛ. ");
INSERT INTO bqp_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ń nɛ́nↄ ni pↄ́nↄ dãdã gbárannan la ari wɛ̃̀ bupla, ò ń denↄ náani sari gbɛ̀ le. Ń denↄ gɛ̀nↄ ni gↄ̃ gbárannan la ń pínki. ");
INSERT INTO bqp_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Lákũ ò bùsuu pìi yakɛ̀ gↄrↄ bupla nà, lɛn onigↄ̃ ń yã vãni gbɛ̀ le lɛ ari wɛ̃̀ bupla, wɛ̃̀ dodo gↄrↄ dodo, onigↄ̃ dↄ̃ lán ibɛrɛsɛna kũmao de nà. ");
INSERT INTO bqp_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Makũ Dikiri makũ mɛ́ ma yã pìi ò, lɛmɛ sↄ̃ mani kɛ gbɛ̃ vãni kũ ò kàkaramai pìnↄnɛ lɛ. Oni gaga gbárannan la ń pínki. ");
INSERT INTO bqp_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Gbɛ̃ kũ Musa ń zĩ ò bùsuu yakɛ̀ kũ ò sù ò bùsuu pì gya bò ò tò ò zuka dↄ̀anↄ, ");
INSERT INTO bqp_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Dikiri gagagyã kà gbɛ̃ pìnↄgu, akũ ò gàga. ");
INSERT INTO bqp_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Gbɛ̃ kũ ò gɛ̀ɛ ò bùsuu yakɛ̀ɛ pìnↄ tɛ́, Nuni nɛ́ Yↄsua kũ Yefunɛ nɛ́ Kalɛbuo mɛ́ ò gↄ̃̀ kũ wɛ̃̀ndiio. ");
INSERT INTO bqp_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa yã pìnↄ gbã̀ Isarailanↄnɛ pínki, akũ ò ↄ́ↄ dↄ̀ manamana. ");
INSERT INTO bqp_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ò fùtɛ kↄnkↄ káakukaaku, ò mìi pɛ̀ kpinↄa ò pì: À gwa, ótɛn gɛ́ gu kũ Dikiri òn. O ó durunna dↄ̃̀ sà. ");
INSERT INTO bqp_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa pì: Bↄ́yãi átɛn pã Dikiri yãnɛɛ? Abire ni sí kɛro. ");
INSERT INTO bqp_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Àsun gɛ́ro, zaakũ Dikiri kú kãáoro. Á ibɛrɛnↄ ni á ble kũ zĩ̀io. ");
INSERT INTO bqp_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalɛkinↄ kũ Kanaanↄn kú á arɛ gwe. Oni á dɛdɛ kũ fɛ̃nɛdao. Dikiri nigↄ̃ kú kãáoro, kũ a gi tɛ́ii yãi. ");
INSERT INTO bqp_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Akũ ò sãgbãna kɛ̀ ò mìi pɛ̀ kpinↄa, bee kũ Dikiri bàka kunna kũńwo àkpatii gↄ̃̀ bùran kũ Musao. ");
INSERT INTO bqp_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Akũ Amalɛkinↄ kũ Kanaa kũ ò kú gusĩsĩde pìnnↄ lɛ̀tɛḿma ò ń blé kũ zĩ̀io ò pɛ̀ḿma ari Ɔↄma. ");
INSERT INTO bqp_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Isarailanↄ kà Zini gbárannan ń pínki mↄ káaku gũn, akũ ò vùtɛ Kadɛsi. Gwen Miriamu gàn, ò a vĩ̀. ");
INSERT INTO bqp_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Í kun ò miro, akũ ò kàkara Musa kũ Harunaoi. ");
INSERT INTO bqp_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ò zuka kà Musai ò pì: Tó o gaga yã kũ gbɛ̃ kũ ò gàga Dikiri arɛnↄ, de abire sã̀na. ");
INSERT INTO bqp_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Bↄ́yãi a su kũoo gbáranna díkĩnan de ò gaga la kũ ó pↄ́kãdenↄoo? ");
INSERT INTO bqp_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Bↄ́yãi a bↄtɛ kũoo Misila a su kũoo gu vãni díkĩna gũnn? Pↄ́blewɛ ke kaka lí ke geepi nɛ́ ke bísi kú laro, akũsↄ̃ í kú la ò miro. ");
INSERT INTO bqp_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa kũ Harunao gò paria ò gɛ̀ɛ dakarɛki kpɛ́lɛlɛa ò wùtɛ ń nɛ̀sɛlɛ kutɛna, akũ Dikiri gakuri bò à sùḿma. ");
INSERT INTO bqp_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Dikiri yã ò Musanɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Ǹ gò sɛ́, mↄkↄ̃n kũ n vĩ̀ni Harunao à gbɛ̃ pìnↄ kakara à yã o gbɛ̀si direnɛ ń wára, í ni bon. Lɛn ĩni í bońnɛ gbɛ̀ pìn ò mi lɛ kũ ń pↄ́kãdenↄ. ");
INSERT INTO bqp_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa gòo sɛ̀ Dikiri arɛ lákũ à ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa kũ Harunao ń kákara gbɛ̀si pì arɛ, akũ à pìńnɛ: À ma á sãgbãnadenↄ! Á ye ò í boárɛ gbɛ̀ dínn yá? ");
INSERT INTO bqp_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Akũ Musa ↄ sɛ̀ musu à gbɛ̀ɛ pìi lɛ̀ kũ a gòoo gɛ̃̀n pla. Í bò manamana, akũ ò mì kũ ń pↄ́kãdenↄ. ");
INSERT INTO bqp_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Akũ Dikiri pì Musanɛ kũ Harunao: Zaakũ ádi ma náani kɛ a ma tↄ́ bò Isarailanↄnɛro, áni gɛ̃ kũńwo bùsu kũ matɛn kpáḿmanlo. ");
INSERT INTO bqp_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Mɛriba ísɛ̃bokin gwe, gu kũ Isarailanↄ zuka kàn Dikirii, akũ à a ludakɛnaa mↄ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa gbɛ̃nↄ zĩ̀ ò bò Kadɛsi ò gɛ̀ɛ Ɛdↄmunↄ kína kĩnaa ò pì: Ókↄ̃nↄ n danɛ Isarailanↄ pì, ń wari kũ à ó lénↄ dↄ̃ pínki. ");
INSERT INTO bqp_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ó dizinↄ gɛ̀ɛ Misila, akũ o gìi kɛ̀ gwe. Misilanↄ wari dↄ̀wá kũ ó dizinↄ. ");
INSERT INTO bqp_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","O wiki lɛ̀ Dikiria, akũ à yã sì kũoo. À a Malaikaa zĩ̀ à bò kũoo Misila. Tera sà ó kú Kadɛsi, n bùsu lɛ́zɛkin. ");
INSERT INTO bqp_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ǹ ó gba zɛ́ ò gɛ̃tɛ n bùsuua. Óni gɛ̃tɛ buranↄ ke geepi búnↄaro, óni á lↄ̀gↄ'i miro. Ónigↄ̃ tɛ́ kína zɛ́da gũmmɛ. Óni litɛ ↄplai ke ↄzɛiro ari ò gɛ́ gɛ̃tɛo n bùsula. ");
INSERT INTO bqp_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Akũ Ɛdↄmunↄ pìńnɛ: Áni le à gɛ̃tɛ ó bùsuuaro. Tó a gi, óni bo ò daálɛ kũ fɛ̃nɛdao. ");
INSERT INTO bqp_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isarailanↄ pìńnɛ: Óni gɛ̃tɛ zɛ́daamɛ. Tó ókↄ̃nↄ ke ó pↄ́kãdenↄ á í mì, óni a fĩna bo. Gɛ̃tɛnaan ótɛn wɛtɛ ado. ");
INSERT INTO bqp_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ɛdↄmunↄ pì: Áni le à gɛ̃tɛro. Akũ ń zĩ̀karinↄ bↄ̀tɛ dasidasi ò sù dańlɛ kũ gbãnao. ");
INSERT INTO bqp_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Zaakũ Ɛdↄmunↄ gì Isarailanↄnɛ ò gɛ̃tɛ ń bùsuua, akũ Isarailanↄ pã̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isarailanↄ bò Kadɛsi ń pínki ò kà Oru kpia ");
INSERT INTO bqp_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ɛdↄmu bùsu lɛ́zɛkin. Gwen Dikiri yã òn Musanɛ kũ Harunao à pì: ");
INSERT INTO bqp_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Haruna ni ká a dizinↄla tera, ani gɛ̃ bùsu kũ matɛn Isarailanↄ gba gũnlo, kũ á gbɛ̃nↄn pla a gi ma yã ma zaa Mɛriba yãi. ");
INSERT INTO bqp_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ǹ Haruna kũ a nɛ́ Ɛlɛazao sɛ́ ǹ didi kũńwo Oru kpia ");
INSERT INTO bqp_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ǹ Haruna pↄ́kasanↄ bↄtɛa ǹ da a nɛ́ Ɛlɛazanɛ gwe. Gwen Haruna ni gan à ká a dizinↄla. ");
INSERT INTO bqp_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa kɛ̀ lákũ Dikiri ònɛ nà. À dìdi Oru kpia gbɛ̃ sĩnda pínki wára ");
INSERT INTO bqp_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","à Haruna pↄ́kasanↄ bↄ̀tɛa à dà a nɛ́ Ɛlɛazanɛ, akũ Haruna gà kpi pìi musu gwe. Kũ Musa kũ Ɛlɛazao kìpa kpi pìia ");
INSERT INTO bqp_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","akũsↄ̃ Isarailanↄ mà kũ Haruna gà, akũ ò a gɛ̀ wɛ̃nda kɛ̀ gↄrↄ baraakuri. ");
INSERT INTO bqp_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Aradi kũ à kú Nɛgɛvi bùsun kína bi Kanaa gbɛ̃mɛ. Kũ à mà Isarailanↄn tɛ́ Atarimu zɛ́n òtɛn su, akũ à bò à dàńlɛ kũ zĩ̀io à ń gbɛ̃kenↄ kũ̀kũ. ");
INSERT INTO bqp_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Akũ Isarailanↄ lɛ́ sɛ̀ Dikirinɛ ò pì: Tó n gbɛ̃ pìnↄ nàwɛrɛ ó ↄĩ, óni ń wɛ̃tɛnↄ kakatɛ mámmam. ");
INSERT INTO bqp_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Dikiri Isarailanↄ yã mà, akũ à Kanaa pìnↄ kpàḿma. Ò ń kákatɛ kũ ń wɛ̃tɛnↄ pínki, akũ ò tↄ́ kpà gu pìinɛ Ɔↄma. ");
INSERT INTO bqp_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Kũ ò fùtɛ Oru kpi pì kĩnaa, ò Isira Tɛ̃ra zɛ́ sɛ̀ de ò pã Ɛdↄmunↄ bùsuunɛ. Akũ ò fù mɛnaa zɛ́n ");
INSERT INTO bqp_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ò Luda kũ Musao taari è ò pì: Bↄ́yãi a ó bↄ́tɛ Misila de ò gaga gbárannann? Pↄ́ble kunlo, í kunlo, o zã pↄ́ble gina dín. ");
INSERT INTO bqp_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Akũ Dikiri mlɛ̃̀ pãsĩnↄ zĩ̀ḿma ò ń lɛlɛ, akũ ò gàga dasidasi. ");
INSERT INTO bqp_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Gbɛ̃nↄ sù Musa kĩnaa ò pì: O durunna kɛ̀, zaakũ o Dikiri kũ mↄkↄ̃nwoo taari è. Ǹ kútɛ kɛnɛwɛrɛ de à ó kɛ̃kↄ̃a kũ mlɛ̃̀ dínↄ. Akũ à kútɛ kɛ̀nɛńnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Dikiri pìnɛ: Ǹ mlɛ̃̀ pi ǹ loko lía ǹ pɛ́tɛ. Tó mlɛ̃̀ gbɛ̃ lɛ̀, tó à wɛ́ sɛ̀ à a gwà, ani aafia le. ");
INSERT INTO bqp_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Akũ à mↄ̀gotɛ̃ pì mlɛ̃̀ ũ à lòko lía à pɛ̀tɛ. Tó mlɛ̃̀ gbɛ̃ lɛ̀ akũsↄ̃ à wɛ́ sɛ̀ à mↄ̀gotɛ̃ mlɛ̃̀ɛ pìi gwà, àdi aafia le. ");
INSERT INTO bqp_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isarailanↄ dà zɛ́n, akũ ò bùraa kàtɛ Obo. ");
INSERT INTO bqp_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Bona Obo ò gɛ̀ɛ ò bùraa kàtɛ Iyɛ'abarimu gbárannan Mↄabunↄ bùsu ifãboki kpa. ");
INSERT INTO bqp_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Bona gwe ò gɛ̀ɛ ò bùraa kàtɛ Zeredi guvutɛn. ");
INSERT INTO bqp_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Bona gwe ò bùraa kàtɛ Anↄ bara dire, gbáranna kũ à kú Amↄrinↄ bùsu lɛ́zɛkin. Anↄ pìmɛ Mↄabunↄ kũ Amↄrinↄ bùsunↄ lɛ́zɛki ũ. ");
INSERT INTO bqp_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Abire yãin ò pì Dikiri zĩ̀katakada gũn: Waɛbu kũ à kú Sufa bùsun kũ Anↄ swa'ↄnɛnↄ ");
INSERT INTO bqp_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kũ ń guvutɛ kũ ò tà ari Aranↄo Mↄabunↄ bùsu lɛ́zɛkin. ");
INSERT INTO bqp_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Bona gwe dↄ ò gɛ̀ɛ Lↄ̀gↄ, gu kũ Dikiri pìn Musanɛ: Ǹ gbɛ̃nↄ kakara mà í kpáḿma. ");
INSERT INTO bqp_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Gwen Isarailanↄ lɛ̀ díkĩna sìn: Í bo lↄ̀gↄn, gbasa ò lɛ̀ sínɛ, ");
INSERT INTO bqp_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","lↄ̀gↄ kũ ó don'arɛdenↄ yↄ̃̀ kũ línↄ, lↄ̀gↄ kũ kínɛnↄ pà kũ ń gònↄ. Bona gbárannan ò gɛ̀ɛ Matana. ");
INSERT INTO bqp_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Matana gbɛra Naliɛli, Naliɛli gbɛra Bamↄ. ");
INSERT INTO bqp_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamↄ gbɛra guvutɛ kũ à kú Mↄabunↄ bùsun, gu kũ Pisiga mìsↄ̃ntɛ arɛ dↄ gbárannaa. ");
INSERT INTO bqp_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isarailanↄ gbɛ̃nↄ zĩ̀ Amↄrinↄ kína Siↄ̃a ò pì: ");
INSERT INTO bqp_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Ǹ ó gba zɛ́ ò gɛ̃tɛ n bùsuua. Óni pã buranↄ ke geepi líkpɛlaro, óni á lↄ̀gↄ'i miro. Ónigↄ̃ tɛ́ kína zɛ́da gũmmɛ ari ò gɛ́ gɛ̃tɛo n bùsula. ");
INSERT INTO bqp_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Siↄ̃ dí ń gba zɛ́ ò gɛ̃tɛ a bùsuuaro. À a zĩ̀karinↄ kàkara ń pínki, ò bↄ̀tɛ òtɛn gɛ́ńyĩ gbárannan. Kũ ò kà Yaza, ò zĩ̀i kà kũ Isarailanↄ, ");
INSERT INTO bqp_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","akũ Isarailanↄ ń dɛdɛ kũ fɛ̃nɛdao ò ń bùsuu sìḿma zaa Anↄ ari Yabokui Amↄninↄ bùsun, zaakũ Amↄninↄ bùsu lɛ́zɛki pì pãsĩ, àdi sí gɛ̃nlo. ");
INSERT INTO bqp_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isarailanↄ Amↄri wɛ̃tɛnↄ sì pínki kũ Ɛsɛbↄ̃o kũ a lakutunↄ pínki, akũ ò vùtɛn. ");
INSERT INTO bqp_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ɛsɛbↄ̃mɛ Amↄrinↄ kína Siↄ̃ wɛ́ra ũ. Siↄ̃ zĩ̀i kà yã kũ Mↄabunↄ kína káakuo, akũ à a bùsuu sìa ari Anↄ swai. ");
INSERT INTO bqp_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Abire yãin kɛrɛnↄ dì pi: À mↄ́ Ɛsɛbↄ̃, ò Siↄ̃ wɛ́ra pì kɛkɛ ò kátɛ! ");
INSERT INTO bqp_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Tɛ́ bò Ɛsɛbↄ̃ yã, zĩ̀karinↄ bò Siↄ̃ wɛ̃tɛ pìi gũn, ò Mↄabunↄ bùsu wɛ́ra Ara kàkatɛ Anↄ mìi sĩ̀sĩ gbɛ̃ pìnↄ. ");
INSERT INTO bqp_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Waiyoo Mↄabunↄ! Kɛmↄsi gbàgbarinↄ, a kakatɛmɛ! Kɛmↄsi tò á gↄ̃gbɛ̃nↄ fã̀kↄ̃a, à á nↄgbɛ̃nↄ kpà Amↄrinↄ kína Siↄ̃a zĩ̀zↄnↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Akũ o ń fú, o ń dɛdɛ zaa Ɛsɛbↄ̃ ari Dibↄ̃. O ń kákatɛ ari Nↄfa kũ Mɛdɛbao. ");
INSERT INTO bqp_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Lɛn Isarailanↄ vùtɛ Amↄrinↄ bùsun lɛ. ");
INSERT INTO bqp_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa gbɛ̃nↄ zĩ̀ Yaza asiri gwa, akũ Isarailanↄ gwe sì kũ a lakutunↄ pínki, ò pɛ̀ Amↄri kũ ò kú gwenↄa. ");
INSERT INTO bqp_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Akũ Isarailanↄ lìtɛ ò Basã zɛ́ sɛ̀. Akũ Basã kína Ogu gɛ̀ɛńyĩ kũ a zĩ̀karinↄ ń pínki ò zĩ̀i kà kũńwo Ɛdɛrɛi. ");
INSERT INTO bqp_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Dikiri pì Musanɛ: Ǹsun vĩna kɛnɛro, zaakũ ma a nànnɛ n ↄĩ kũ a gbɛ̃nↄ kũ a bùsuuo pínki. Ǹ kɛnɛ lákũ n kɛ̀ Amↄrinↄ kína Siↄ̃ kũ à kí blè Ɛsɛbↄ̃nɛ nà. ");
INSERT INTO bqp_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Akũ ò Ogu dɛ̀ kũ a nɛ́nↄ kũ a zĩ̀karinↄ ń pínki, bee gbɛ̃ mɛ̀n do dí boro, akũ ò a bùsuu pìi sì. ");
INSERT INTO bqp_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isarailanↄ dà zɛ́n, akũ ò bùraa kàtɛ Mↄabunↄ bùsu sɛ̃̀n Yoda bara dire kũ à arɛ dↄ Yɛrikoa. ");
INSERT INTO bqp_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Zipo nɛ́ Balaki Mↄabunↄ kína è lákũ Isarailanↄ kɛ̀ Amↄrinↄnɛ nà, ");
INSERT INTO bqp_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","akũ swɛ̃̀ɛ kɛ̃̀ Mↄabunↄgu, vĩna ń kũ Isarailanↄ dasikɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Akũ Mↄabunↄ pì Midiã gbɛ̃ zↄ̃kↄ̃nↄnɛ: Pari díkĩna ni pↄ́ kũ à likawáinↄ ble pínki lán zùu dì sɛ̃̀ só nà. ");
INSERT INTO bqp_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Akũ Balaki gbɛ̃nↄ zĩ̀ Bɛↄ nɛ́ Balamua ari Peto, Yuflati sarɛ a bɛ bùsun. À pìńnɛ ò a sísi à su, ò pinɛ: Gbɛ̃ kenↄ bò Misila ò dàgula ò kátɛ ma sarɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","N yã nna! Ǹ mↄ́ ǹ lɛ́ kɛńnɛmɛnɛ, zaakũ ń gbãna demala. Òdigↄ̃ dↄ̃ro ke mani le mà zĩ̀ bleḿma mà pɛ́ḿma bùsu dín gwɛɛ. Má dↄ̃ kũ gbɛ̃ kũ n sa mana ònɛ nigↄ̃ de arubarikade ũmɛ. Gbɛ̃ kũ n sa vãni ònɛ sↄ̃, anigↄ̃ de láaribona pↄ́ ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mↄabu kũ Midiã gbɛ̃ zↄ̃kↄ̃nↄ dà zɛ́n, ò màsokɛna gba kũ oni da Balamunɛ kũna. Kũ ò kà a kĩnaa, ò yã kũ Balaki ń zĩoo ònɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","À pìńnɛ: À i la, mani yã kũ Dikiri ni omɛnɛ oárɛ. Akũ Mↄabu kínanɛ pìnↄ ì Balamu bɛa. ");
INSERT INTO bqp_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Akũ Luda bò à sù Balamua à a là à pì: Dínↄn gbɛ̃ kũ ò kú kũnwo díkĩnanↄ ũu? ");
INSERT INTO bqp_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","À wèa à pì: Zipo nɛ́ Balaki, Mↄabunↄ kína mɛ́ à ń zĩma. Ò pì ");
INSERT INTO bqp_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","gbɛ̃ kenↄ bò Misila ò dàgula. Akũ à pì mà su mà lɛ́ kɛńnɛarɛ de à le à zĩ̀ bleḿma à pɛ́ḿma. ");
INSERT INTO bqp_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Akũ Luda pìnɛ: Ǹsun tɛ́ńyĩro. Ǹsun sa vãni ońnɛro, zaakũ ma arubarikaa dàńgu kↄ̀. ");
INSERT INTO bqp_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kũ Balamu fùtɛ kↄnkↄ, à pì Balaki kínanɛnↄnɛ: À tá á bùsun, zaakũ Dikiri gì mà tɛ́ái. ");
INSERT INTO bqp_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Akũ Mↄabu kínanɛ pìnↄ fùtɛ ò tà Balaki kĩnaa ò pì: Balamu gì su kũooi. ");
INSERT INTO bqp_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki ɛ̀ra à kínanɛ pãndenↄ zĩ̀ dↄ, ń dasi kũ ń gakurio de gbɛ̃ káakunↄ pↄ́la. ");
INSERT INTO bqp_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Kũ ò kà Balamu kĩnaa, ò pì: Zipo nɛ́ Balaki pì ǹsun tó pↄ́ke kpánnɛ kũ suna a kĩnaaoro, ");
INSERT INTO bqp_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","zaakũ áni gba kɛnnɛ manamana. Pↄ́ kũ n òarɛ pínki, áni kɛ. N yã nna! Ǹ mↄ́ ǹ lɛ̀ kɛarɛ gbɛ̃ pìnↄa. ");
INSERT INTO bqp_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Akũ Balamu pì Balaki zĩ̀rii pìnↄnɛ: Bee tó Balaki andurufu kũ wura kũ à kú a bɛaoo kpàma pínki, mani fↄ̃ mà bo Dikiri ma Luda yã kpɛro, bee fíti. ");
INSERT INTO bqp_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","À i la gwãaniala lákũ gbɛ̃ káakunↄ kɛ̀ nà ari mà ma dↄ yã kũ Dikiri ni karamɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Luda bò à sùa gwãani à pìnɛ: Zaakũ gbɛ̃ díkĩnanↄ sù n sísi, ǹ futɛ ǹ gɛ́ kũńwo, ama yã kũ mani on ǹ kɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balamu fùtɛ kↄnkↄ à gàarii yĩ̀ a zaakinɛ, akũ à gɛ̀ɛ kũ Mↄabu kínanɛ pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Luda pↄ fɛ̃̀ kũ à gɛ̀ɛ yãi, akũ Dikiri Malaikaa gɛ̀ɛ à zɛ̀ à zɛ́ zↄ̃̀nɛ. Balamu di a zaaki kpɛ, a zĩkɛri gbɛ̃nↄn planↄn tɛ́ kãao. ");
INSERT INTO bqp_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kũ zaaki pìi è Dikiri Malaika zɛna zɛ́ gũn à fɛ̃nɛda wòto à kũna, akũ à lìtɛ sɛ̃̀n. Balamu a lɛ̀, akũ à ɛ̀ra à dà zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Dikiri Malaikaa gɛ̀ɛ à zɛ̀ zɛ́ tererennan geepi líkpɛ kũ gbɛ̀ karaa likainↄ dagura. ");
INSERT INTO bqp_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kũ zaaki pì Dikiri Malaikaa è, à nà gbĩ̀ia à Balamu gbá lↄ̀a. Akũ Balamu ɛ̀ra à a lɛ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Dikiri Malaikaa ɛ̀ra à gɛ̀ɛ arɛ dↄ à zɛ̀ gu kpakoto kũ à litɛki vĩron. ");
INSERT INTO bqp_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kũ zaaki pì Dikiri Malaikaa pìi è, à kùtɛ kũ Balamuo. Akũ Balamu pↄ fɛ̃̀ à a lɛ̀ kũ gòoo. ");
INSERT INTO bqp_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Akũ Dikiri zaaki pìi gbà lɛ́ à yã ò Balamunɛ à pì: Bↄ́n ma kɛ̀nnɛ n ma lɛ ari gɛ̃̀n aakↄ̃ↄ? ");
INSERT INTO bqp_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balamu wèa à pì: Kũ n yↄ̃nkↄyã kɛ̀mɛnɛ yãimɛ. Tó má fɛ̃nɛ kũna, de ma n dɛ gↄ̃̀nↄ. ");
INSERT INTO bqp_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Akũ zaaki pìi pìnɛ: N zaaki kũ ndìgↄ̃ dia gↄrↄ sĩnda pínkia ari suna gbãramɛ ma ũroo? Ma kɛ̀nnɛ lɛ yã yá? À pì: Oi. ");
INSERT INTO bqp_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Akũ Dikiri Balamu wɛ́ kɛ̃̀nɛ, à a Malaikaa è zɛna zɛ́n à fɛ̃nɛda wòto à kũna. Akũ à kùtɛ à mìi pɛ̀tɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Dikiri Malaika a là à pì: Bↄ́yãin n n zaaki lɛ̀ ari gɛ̃̀n aakↄ̃ↄ? Ma su zɛ́ zↄ̃nnɛmɛ, zaakũ n wãmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kũ zaaki pì ma e, akũ à lìtɛmɛnɛ ari gɛ̃̀n aakↄ̃. Tó adi litɛmɛnɛ yãro, de ma n dɛ ma a tò. ");
INSERT INTO bqp_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balamu pì Dikiri Malaikaa pìinɛ: Ma durunna kɛ̀, zaakũ má dↄ̃ kũ n zɛ́ zↄ̃̀mɛnɛro. Zaakũ ma gɛnaa kɛ̀nnɛ ĩni, mani ɛra mà tá. ");
INSERT INTO bqp_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Akũ Dikiri Malaikaa pì Balamunɛ: Ǹ gɛ́ kũ gbɛ̃ pìnↄ, yã kũ mani dannɛn ǹ o. Akũ Balamu gɛ̀ɛ kũ Balaki kínanɛ pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kũ Balaki mà Balamu tɛn su, akũ à gɛ̀ɛ à dàalɛ wɛ̃tɛ kũ à kú Anↄ bara, Mↄabunↄ bùsu lɛ́zɛkin. ");
INSERT INTO bqp_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Akũ à pì Balamunɛ: Kũ ma gbɛ̃nↄ zĩ̀ ò n sísi yã, à kɛ̀ dera ńdi suroo? Mani fↄ̃ mà gba kɛnnɛnloo? ");
INSERT INTO bqp_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balamu wèa à pì: Ma su sà, ama má yã sĩnda pínki ona zɛ́ vĩro. Yã kũ Luda ni damɛnɛn mani o. ");
INSERT INTO bqp_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Akũ Balaki gɛ̀ɛ kũ Balamuo Kiria'uzo. ");
INSERT INTO bqp_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","À sa ò kũ zùnↄ kũ sãnↄ à a nↄ̀bↄↄ kpà Balamua kũ kínanɛ kũ ò kú kãao lɛɛlɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kũ gu dↄ̀, à Balamu sɛ̀ à gɛ̀ɛ kãao Bamↄbaali. Gwen Balamu Isarailanↄ bùra kpado èn. ");
INSERT INTO bqp_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balamu pì Balakinɛ: Ǹ gbagbaki bomɛnɛ la mɛ̀n suppla, ǹ sumɛnɛ kũ zùsanↄ mɛ̀n suppla kũ sãkaronↄ mɛ̀n suppla. ");
INSERT INTO bqp_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki kɛ̀ lákũ Balamu ònɛ nà, akũ ò sa ò kũ zùsaao kũ sãkarooo gbagbaki pìnↄa pínki. ");
INSERT INTO bqp_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Akũ Balamu pìnɛ: Ǹ zɛ n sa'opↄi. Mani gɛ́ mà gwa tó Dikiri ni su yã omɛnɛ, mani yã kũ ani omɛnɛ onnɛ. Akũ à gɛ̀ɛ à zɛ̀ gulei gbáagbaaa. ");
INSERT INTO bqp_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Luda sù à a lè, akũ Balamu pìnɛ: Ma gbagbaki bò mɛ̀n suppla, akũ ma sa òḿma pínki kũ zùsaao kũ sãkarooo. ");
INSERT INTO bqp_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Dikiri yã dànɛ a lɛ́n, akũ à pì: Ǹ ɛra ǹ gɛ́ ǹ Balaki le ǹ onɛ lákũ ma dànnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Akũ à ɛ̀ra à gɛ̀ɛ à a lè zɛna a sa'opↄi kũ Mↄabu kínanɛnↄ ń pínki, ");
INSERT INTO bqp_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","akũ à yã kũ à èe ò à pì: Mↄabunↄ kína Balaki ma sisi Siria bùsun, akũ ma bo ifãboki kpa kpinↄ kĩnaa ma su. À pì mà boarɛ Isarailanↄ kpɛ, mà su mà sa vãni oarɛ Yakubu buri pìnↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mani kɛ dera mà gbɛ̃ kũ Luda dí ń káronↄ káa? Mani kɛ dera mà bo gbɛ̃ kũ Dikiri dí bo ń kpɛronↄ kpɛɛ? ");
INSERT INTO bqp_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Zaa kpi mìsↄ̃ntɛa matɛni ń e, zaa gu lei musu matɛn wɛ́ sińlɛ. Gbɛ̃ pìnↄn kú ńdona, ò ń zĩda dìtɛ ńdona kũ buri pãndenↄ. ");
INSERT INTO bqp_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yakubu burinↄn dasi lán bùsu'atɛ̃ bà, oni fↄ̃ ò Isarailanↄ naro ò ń lɛ́ dↄ̃ro. Luda tó ma ga gↄ̃ de lán a gbɛ̃nↄ pↄ́ bà, ma lakana gↄ̃ de lán ń pↄ́ bà. ");
INSERT INTO bqp_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Akũ Balaki pìnɛ: N kɛ̀mɛnɛ deran gwee? Ma su kũnwo de ǹ ma ibɛrɛnↄ kámɛnɛ, akũ sa manan n òńnɛ yá? ");
INSERT INTO bqp_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","À wèa à pì: Yã kũ Dikiri dàmɛnɛ ma lɛ́nn mani oroo? ");
INSERT INTO bqp_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki pìnɛ: Ǹ mↄ́ ò gɛ́ gu pãndea, gu kũ ĩni ń en. Ǹ ń kámɛnɛ gwe, zaakũ ń kpadomɛ ĩni e, ĩni ń e ń pínkiro. ");
INSERT INTO bqp_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Akũ à gɛ̀ɛ kãao gudãkpãrinↄ buran Pisiga kpi mìsↄ̃ntɛa. À gbagbaki bò gwe mɛ̀n suppla, akũ à sa òḿma pínki kũ zùsaao kũ sãkarooo. ");
INSERT INTO bqp_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Akũ Balamu pìnɛ: Ǹ zɛ n sa'opↄi la, mani gɛ́ mà a le gwe. ");
INSERT INTO bqp_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Akũ Dikiri sù à yã dànɛ a lɛ́n, akũ à pìnɛ: Ǹ ɛra ǹ gɛ́ ǹ Balaki le ǹ onɛ lákũ ma dànnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Akũ à ɛ̀ra à gɛ̀ɛ à a lè zɛna a sa'opↄi kũ Mↄabu kínanɛnↄo. Balaki a là à pì: Dikiri pì deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Akũ à yã kũ à èe ò à pì: Zipo nɛ́ Balaki, ǹ sã kpá ǹ ma yã ma! ");
INSERT INTO bqp_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Luda bi bisãsirinlo kũ à gbasa à ɛ́kɛ to, àdi nɛ̀sɛ litɛ lán bisãsiri bàro. Ani gí yã kũ à ò kɛi yá? Ani gí lɛ́ kũ à gbɛ̃̀ńnɛ papai yá? ");
INSERT INTO bqp_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","À pìmɛnɛ mà sa mana ońnɛmɛ. À arubarikaa dàńgu, mani fↄ̃ mà gíro. ");
INSERT INTO bqp_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Mádi yã vãni ke e Yakubu burinↄaro, mádi yã'ũmmana ke e Isarailanↄaro. Dikiri ń Luda kú kũńwo, òdi a kíkɛ tↄ́ sɛ́ lei ń tɛ́. ");
INSERT INTO bqp_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Luda ń bↄ́tɛ Misila, ò gbãna vĩ lán zùsɛ̃ntɛ bà. ");
INSERT INTO bqp_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Oni fↄ̃ ò pↄ́ da Yakubu burinↄaro, oni fↄ̃ ò àlesi bɛ̃̀nɛ kpá Isarailanↄnɛro. Zaa gbãra onigↄ̃ o ń yã musu, yã kũ Luda kɛ̀n gwe. ");
INSERT INTO bqp_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Buri pìi dì futɛ lán músuda bà, àdi a zĩda bi lán músusaa bà. Àdi wútɛro ari à gɛ́ pↄ́ kũ à só, ari à gɛ́ pↄ́ kũ à dɛ̀nↄ aru mi. ");
INSERT INTO bqp_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki pìnɛ: Ǹsun ń káro. Ǹsun sa mana ońnɛ sero. ");
INSERT INTO bqp_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balamu pìnɛ: Mádi onnɛ kũ yã kũ Dikiri dàmɛnɛn mani oroo? ");
INSERT INTO bqp_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki pì Balamunɛ: Ǹ mↄ́ sà, mani gɛ́ kũnwo gu pãnden. Òdigↄ̃ dↄ̃ro tó ani kɛ Ludanɛ ǹ gbɛ̃ pìnↄ kámɛnɛ gwe sà. ");
INSERT INTO bqp_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Akũ Balaki gɛ̀ɛ kãao Peo kpi musu kũ à arɛ dↄ gbárannaa. ");
INSERT INTO bqp_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balamu pìnɛ: Ǹ gbagbaki bomɛnɛ la mɛ̀n suppla, ǹ mↄmɛnɛ kũ zùsanↄ mɛ̀n suppla kũ sãkaronↄ mɛ̀n suppla. ");
INSERT INTO bqp_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki kɛ̀ lákũ à ònɛ nà à sa òḿma kũ zùsaa pìnↄ kũ sãkaroo pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kũ Balamu è sa mana ona Isarailanↄnɛ kà Dikirigu, adi gɛ́ màso kɛ lán yã bà doro, akũ à arɛ dↄ̀ gbárannaa. ");
INSERT INTO bqp_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kũ à wɛ́ zù, akũ à Isarailanↄ è katɛna ń buria. Luda Nini kìpaa, ");
INSERT INTO bqp_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","akũ à yã kũ à èe ò à pì: Bɛↄ nɛ́ Balamu yãn dí, makũ kũ ma wɛ́ kɛ̃na yãn dí. ");
INSERT INTO bqp_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Makũ kũ madì Luda yã ma yãn dí. Ma Gbãnasĩndapinkide wɛ́gupu è, ma wutɛ nɛ̀sɛlɛ kutɛna, ma wɛ́ wɛ̃na. ");
INSERT INTO bqp_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yakubu burinↄ bùrakatɛna mana fá! Isaraila bizakutanↄn mana! ");
INSERT INTO bqp_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ò katɛna lán guvutɛ dàkonↄ bà, lán swa dↄ̀rↄ kara búnↄ bà. Ò de lán zà lí kũ Dikiri bànↄ bà, lán sida lí kũ ò kú í sarɛnↄ bà. ");
INSERT INTO bqp_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Í ni ń orozãnↄ pa yɛ́rɛrɛ, ń pↄ́tↄ̃nanↄ ni í le manamana. Ń kína gbãna nigↄ̃ de Agaga pↄ́la, ń kpata ni tↄ́ bo. ");
INSERT INTO bqp_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Luda ń bↄ́tɛ Misila, ò gbãna vĩ lán zùsɛ̃ntɛ bà. Òdi zĩ̀ ble buri kũ ò ibɛrɛɛ kpà kũńwonↄa, òdi ń wánↄ wíwi òdi ń pápa kũ kàao. ");
INSERT INTO bqp_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Òdi sↄ̃pɛtɛ ò wútɛ lán músuu bà, dí mɛ́ ani fↄ̃ à ń futɛɛ? Luda arubarika da gbɛ̃ kũ oni sa mana ońnɛnↄgu, à gbɛ̃ kũ oni sa vãni ońnɛnↄ ká. ");
INSERT INTO bqp_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki pↄ fɛ̃̀ Balamui à ↄnɛ dↄ̀a à pì: Ma ibɛrɛnↄ kana yãin ma n sisi, akũ n sa mana òńnɛ gɛ̃̀n aakↄ̃ yá? ");
INSERT INTO bqp_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ǹ tá n bɛa gↄ̃̀nↄ. Ma pì mani gba kɛnnɛmɛ yã, akũsↄ̃ Dikiri gìnnɛ ǹ láada le. ");
INSERT INTO bqp_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balamu pìnɛ: Mádi o gbɛ̃ kũ n ń zĩmanↄnɛroo! ");
INSERT INTO bqp_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ma pì bee tó n ma gba n bɛ kũ à pana kũ andurufuuo kũ wuraao, mani bo Dikiri yã kpɛ mà yã kɛ kũ ma zĩda pↄyeinaaoro, a mana ke a vãni. Yã kũ Dikiri pì mà on mani o. ");
INSERT INTO bqp_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Matɛn tá ma gbɛ̃nↄ kĩnaa sà. Ǹ mↄ́ mà onnɛ lákũ gbɛ̃ pìnↄ ni kɛ n gbɛ̃nↄnɛ nà zia. ");
INSERT INTO bqp_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Akũ Balamu yã kũ à èe ò à pì: Bɛↄ nɛ́ Balamu yãn dí, makũ kũ ma wɛ́ kɛ̃na yãn dí. ");
INSERT INTO bqp_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Makũ kũ madì Luda yã ma yãn dí. Má Luda Musude nɛ̀sɛgũnyã dↄ̃. Ma Gbãnasĩndapinkide wɛ́gupu è, ma wutɛ nɛ̀sɛlɛ kutɛna, ma wɛ́ wɛ̃na. ");
INSERT INTO bqp_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Matɛn Isarailanↄ e, adi kɛ teranlo, matɛni ń gwa, a gↄrↄ dí ká gĩaro. Susunɛ ni bo Yakubu burinↄ tɛ́, kpatableri ni bo Isarailanↄ tɛ́, ani Mↄabunↄ mì wíwi, ani zukakari pìnↄ mìtoko fↄ̃fↄ̃. ");
INSERT INTO bqp_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ɛdↄmu bùsu ni gↄ̃ a pↄ́ ũ, a ibɛrɛ Sei bùsu ni gↄ̃ a pↄ́ ũ, Isarailanↄ gbãna nigↄ̃ karamɛ. ");
INSERT INTO bqp_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yakubu buri ke ni kí bleḿma, ani gbɛ̃ kpara kũ ò gↄ̃̀nↄ kakatɛ. ");
INSERT INTO bqp_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balamu Amalɛki burinↄ è, akũ à yã kũ à èe ò à pì: Amalɛki burinↄ bi burinↄ mìdemɛ, ama oni kakatɛ zã. ");
INSERT INTO bqp_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kũ Balamu Keninↄ è, akũ à yã kũ à èe ò à pì: Á kúki gbãna gíngin, á sà kú gbɛ̀ musu. ");
INSERT INTO bqp_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Bee kũ abireo oni á kakatɛmɛ, Asirianↄ ni á kũkũ zĩ̀zↄnↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balamu yã kũ à èe ò dↄ à pì: O'o, tó Luda kɛ̀ lɛ, dí mɛ́ ani boo? ");
INSERT INTO bqp_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Gó'itɛnↄ ni bo Sipiru bùsun, oni zĩ̀ ble Asirianↄ kũ Eberunↄa, ama mↄ́kↄ̃nↄ ni kakatɛmɛ se. ");
INSERT INTO bqp_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balamu fùtɛ à tà a bɛa, akũ Balaki dà zɛ́n se. ");
INSERT INTO bqp_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Tó arubarika kũ láari yã kũ ma dìtɛárɛ dínↄ á lé pínki, àgↄ̃ dↄn buri kũ Dikiri á Luda ni pɛ́áwa à á fãkↄ̃a ń tɛ́nↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","Tó ákↄ̃nↄ kũ á nɛ́nↄ ɛ̀ra ò arɛ dↄ̀ Dikiri á Ludaa, tó a a yã kũ matɛn ditɛárɛ gbãra mà pínki kũ nɛ̀sɛ doo kũ pↄyeinaao, ");
INSERT INTO bqp_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","Dikiri á Luda ni á wɛ̃nda gwa, ani ɛra à á kakara zaa buri kũ à á fãkↄ̃a ń tɛ́nↄ gũn à su kãáo á gwena zĩn. ");
INSERT INTO bqp_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Bee tó à pɛ̀áwa à á fãkↄ̃a bùsu kũ ò kú ari andunia lɛ́anↄ gũn, ani á burinↄ kakara gwe à su kũńwo. ");
INSERT INTO bqp_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Ani ɛra kũńwo bùsu kũ à de ń dizinↄ pↄ́ ũ gũn. Tó ò bùsuu pìi kũ̀, ani arubarikaa dańgu, ani tó ò dasi kũ de ń dizinↄla. ");
INSERT INTO bqp_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Dikiri á Luda ni á swɛ̃̀ pípiárɛ kũ á burinↄ, á nini nigↄ̃ yei kũ nɛ̀sɛ doo de àgↄ̃ kú kũ wɛ̃̀ndiio. ");
INSERT INTO bqp_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Dikiri á Luda ni láari dínↄ bo á ibɛrɛ kũ ò zã̀águ òtɛn wɛ́ tãáwanↄa, ");
INSERT INTO bqp_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","áni ɛra à Dikiri yã ma àgↄ̃ zĩ kɛ kũ a yãditɛna kũ matɛn oárɛ gbãranↄo. ");
INSERT INTO bqp_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Dikiri á Luda ni arubarika daágu kũ á zĩ sĩnda pínkio, ani tó á nɛ́nↄ kↄ̃ kũ á pↄ́kãdenↄ kũ á burapↄnↄ. A pↄ ni ɛra à kɛáwa nna, ani yã mana kɛárɛ lákũ a pↄ kɛ̀ nna á dizinↄa nà. ");
INSERT INTO bqp_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Tó a Dikiri á Luda yã mà a a ↄdↄki gwà akũsↄ̃ á a yãditɛna kũ ò kú doka takada díkĩna gũnnↄ kũna, tó a arɛ dↄ̀ Dikiri á Ludaa kũ nɛ̀sɛ doo kũ pↄyeinaao, ani abirenↄ kɛárɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","Yã kũ matɛn ditɛárɛ gbãra pì zĩ'ũ de á gbãna lɛ́laro. À zã̀ kãáoro. ");
INSERT INTO bqp_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","À kú ludambɛro, gbasa à pi, dí mɛ́ ani gɛ́ ludambɛ à kipao de à ma à zĩ kɛa. ");
INSERT INTO bqp_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","À kú ísira bara direro, gbasa à pi, dí mɛ́ ani bikũ ísira bara à suo de à ma àgↄ̃ kũna. ");
INSERT INTO bqp_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Yã pì kú kãáo kãnikãni, à kú á lɛ́n kũ á nɛ̀sɛɛo de à le à zĩ kɛa. ");
INSERT INTO bqp_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","À ma! Matɛn wɛ̃̀ndi kũ yã manao ditɛ á arɛ gbãra kũ gao kũ yã vãnio. ");
INSERT INTO bqp_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Matɛn ditɛárɛ gbãra, àgↄ̃ ye Dikiri á Ludai àgↄ̃ tɛ́ a gɛ̀sɛgbɛɛi, à a ↄdↄki gwa àgↄ̃ a yãditɛnanↄ kũ a dokayãnↄ kũna, de àgↄ̃ kun à kɛ̀ dasi, Dikiri á Luda ni arubarika daágu bùsu kũ átɛn gɛ́ sí gũn. ");
INSERT INTO bqp_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Ama tó a kpɛ lìnɛ akũsↄ̃ ádi a yã maro, tó a kɛ̃a akũsↄ̃ a tãnanↄ gbàgba a donyĩ kɛ̀ńnɛ, ");
INSERT INTO bqp_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","matɛn oárɛ gbãra, a kakatɛn gwe! Áni gì kɛ bùsu kũ átɛn bikũ Yodaa átɛn gɛ́ sí gũnlo. ");
INSERT INTO bqp_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Ludambɛ kũ zĩtɛomɛ ma sèedadenↄ ũ gbãra á yã musu. Ma wɛ̃̀ndi kũ gao dìtɛ á arɛ, arubarika yãnↄ kũ láaribona yãnↄ. À wɛ̃̀ndi sɛ́ de ákↄ̃nↄ kũ á nɛ́nↄ le àgↄ̃ kun. ");
INSERT INTO bqp_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Àgↄ̃ ye Dikiri á Ludai àgↄ̃ a yã ma à naa, zaakũ àkũmɛ á wɛ̃̀ndi ũ. Ani tó à gì kɛ bùsu kũ à la dà á dizi Ibrahĩ kũ Isaakuo kũ Yakubuonↄnɛ, à pì áni kpáḿma gũn. ");
INSERT INTO bqp_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Kũ Musa yã dínↄ ò Isarailanↄnɛ à làka, ");
INSERT INTO bqp_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","à pì: Tera dí bà ma ka wɛ̃̀ basuddo, mani fↄ̃ mà doárɛ arɛ doro. Dikiri pìmɛnɛ mani bikũ Yodaaro. ");
INSERT INTO bqp_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Dikiri á Luda mɛ́ ani doárɛ arɛ à bikũ. Ani buri kũ ò kú gwenↄ kakatɛárɛ de à ń bùsu sí. Yↄsua mɛ́ anigↄ̃ doárɛ arɛ sà lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Dikiri ni kɛ buri pìnↄnɛ lákũ à kɛ̀ Amↄrinↄ kínanↄnɛ nà Siↄ̃ kũ Oguo kũ ń bùsuuo kũ à ń kákatɛ. ");
INSERT INTO bqp_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Dikiri ni ń naárɛ á ↄĩ áni kɛńnɛ lákũ ma dìtɛárɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","À á laakari kpátɛ àgↄ̃ wↄ́rↄgↄ vĩ! Àsun tó vĩna á kũro, àsun tó swɛ̃̀ kɛ̃águ ń yãiro, zaakũ Dikiri á Luda mɛ́ àtɛn gɛ́ kãáo. Ani á tónlo ani pã kpááiro. ");
INSERT INTO bqp_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Akũ Musa Yↄsua sìsi Isarailanↄ wára ń pínki à pìnɛ: Ǹ zɛ gbãna ǹgↄ̃ wↄ́rↄgↄ vĩ, zaakũ mↄkↄ̃n mɛ́ ĩni gɛ́ kũ gbɛ̃ dínↄ bùsu kũ Dikiri la dà ń dizi káakunↄnɛ à pì áni kpáḿma gũn. Mↄkↄ̃n mɛ́ ĩni bùsuu pìi kpaatɛtɛńnɛ. ");
INSERT INTO bqp_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Dikiri mɛ́ ani donnɛ arɛ. Àkũ mɛ́ anigↄ̃ kú kũnwo, ani n tónlo ani pã kpányĩ zikiro. Ǹsun tó vĩna n kũro ǹsun bídi kɛro. ");
INSERT INTO bqp_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Musa doka pìi kɛ̃̀ takada gũn à kpà sa'ori Levi buri kũ òdigↄ̃ Dikiri bàka kunna kũńwo àkpati sɛnanↄa kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Musa yã dìtɛńnɛ à pì: Wɛ̃̀ supplapla gbɛra, wɛ̃̀ kũ òdi fĩnadenↄ kɛ̃ Kutadↄna dikpɛgↄrↄa, ");
INSERT INTO bqp_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","tó Isarailanↄ sù ò ń zĩda mↄ̀ Dikiri ń Ludanɛ ń pínki gu kũ ani sɛ́ gũn, àgↄ̃ doka takada díkĩna kyó kɛńnɛ ò ma. ");
INSERT INTO bqp_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Àgↄ̃ ń kakara, gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ kũ nɛ́ fítinↄ kũ bòasu kũ ò kú á wɛ̃tɛnnↄ, de ò ma ò dada, ò le ògↄ̃ Dikiri á Luda vĩna vĩ, ògↄ̃ dokayã pìnↄ kũna pínki ògↄ̃ zĩ kɛa. ");
INSERT INTO bqp_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Ń nɛ́ kũ ò yã pì dↄ̃ronↄ ni ma, onigↄ̃ vĩnakɛna Dikiri á Ludanɛ dada gↄrↄ kũ á kú bùsu kũ átɛn bikũ Yodaa à gɛ́ sí pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Dikiri pì Musanɛ: N gagↄrↄ kà kĩni. Ǹ Yↄsua sísi à gɛ́ zɛ dakarɛkia, mani zĩ nanɛ a ↄĩ. Akũ Musa kũ Yↄsuao gɛ̀ɛ ò zɛ̀ dakarɛkia. ");
INSERT INTO bqp_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Dikiri bò à sùḿma gwe tɛ́luku kũ à zɛna kuta pì kpɛ́lɛlɛaa gũn. ");
INSERT INTO bqp_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Akũ Dikiri pì Musanɛ: Tó n ka n dizinↄla, gbɛ̃ pìnↄ ni futɛ ò pãpã kɛ ò do bùsu kũ òtɛn gɛ̃n tãnanↄi. Oni pã kpámai ò ma bàka kunna kũńwo yã gboro. ");
INSERT INTO bqp_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Zĩ pìia mani pↄ fɛ̃ńyĩ mà pã kpáńyĩ, mani kpɛ lińnɛ ò ń kakatɛ. Kisianↄ ni wí ń musu dasi ò wari kɛ. Zĩ pìia oni pi: Kisira pìnↄ wì ó musu kũ ó Luda kú kũooro yãinloo? ");
INSERT INTO bqp_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Zĩ pìian mani kpɛ lińnɛ yã vãni kũ ò kɛ̀ yãi, ò arɛ dↄ̀ tãnanↄa. ");
INSERT INTO bqp_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Ǹ lɛ̀ díkĩna kɛ̃ takadan sà ǹ dada Isarailanↄnɛ ò sí, de àgↄ̃ demɛnɛ ń bona ma kpɛ sèeda ũ. ");
INSERT INTO bqp_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Tó ma gɛ kũńwo bùsu kũ ma la dà ń dizi káakunↄnɛ gũn, bùsu kũ vĩ kũ zↄ́'io din pìi, tó ò kã̀ ò mɛ̀ɛ kpà, oni arɛ dↄ tãnanↄamɛ ò ń gbagba. Oni pã kpámai ò ma bàka kunna kũńwo yã gboro. ");
INSERT INTO bqp_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Tó kisira pìnↄ ń lé dasi òtɛn wari kɛ, lɛ̀ɛ pì mɛ́ ani ń yã vãni káńnɛ ń ↄĩ, zaakũ a yã ni sã ń burinↄguro. Má yã kũ à kú ń nɛ̀sɛn gbãra dↄ̃ ari màgↄ̃ gɛ́ kũńwo bùsu kũ ma la dàńnɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Musa lɛ̀ɛ pìi kɛ̃̀ takadan zĩ pìia, akũ à dà Isarailanↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Dikiri yã dìtɛ Nuni nɛ́ Yↄsuanɛ à pì: Ǹ laakari kpátɛ ǹgↄ̃ wↄ́rↄgↄ vĩ! Mↄkↄ̃n mɛ́ ĩni gɛ́ kũ Isarailanↄ bùsu kũ ma la dàńnɛ gũn, akũsↄ̃ makũ manigↄ̃ kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Kũ Musa dokayã pìnↄ kɛ̃̀ takadan à làka pínki, ");
INSERT INTO bqp_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","à yã dìtɛ Levi buri kũ òdigↄ̃ Dikiri bàka kunna kũńwo àkpati sɛnanↄnɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","À doka takada díkĩna sí à ditɛ Dikiri á Luda bàka kunna kãáo àkpatii sarɛ, àgↄ̃ kú gwe á bona Dikiri kpɛ sèeda ũ. ");
INSERT INTO bqp_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Zaakũ má á sãgbãna dↄ̃, lákũ adì gí yãi nà. Zaa gↄrↄ kũ má kú kãáo adìgↄ̃ bo Dikiri yã kpɛmɛ ari kũ a terao. Oni ma ga gbɛra pↄ́ o dↄ yá? ");
INSERT INTO bqp_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","À á buri gbɛ̃ zↄ̃kↄ̃nↄ kũ á don'arɛdenↄ kakaramɛnɛ, de mà yã dínↄ dańnɛ ń sãn, ludambɛ kũ zĩtɛo nigↄ̃ de ma sèedadenↄ ũ á yã musu. ");
INSERT INTO bqp_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Zaakũ má dↄ̃ kũ áni á zĩda yaka ma ga gbɛra, áni kɛ̃ zɛ́ kũ ma mↄ̀árɛa. Abire gbɛra kisira ni á le, zaakũ áni yã kũ à vãni Dikirinɛ kɛ, ani pↄ fɛ̃ái tãna kũ a kɛ̀nↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Akũ Musa lɛ̀ɛ pì yã dà Isaraila kũ ò kakarananↄnɛ ń sãn mámmam. ");
INSERT INTO bqp_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Musa bò Mↄabunↄ bùsu sɛ̃̀ntɛ à dìdi Nɛbo kpia ari Pisiga kpi mìsↄ̃ntɛ kũ à arɛ dↄ Yɛrikoa, akũ Dikiri bùsuu pìi mↄ̀nɛ pínki zaa Giliada bùsun ari Daninↄ bùsun ");
INSERT INTO bqp_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","kũ Nafatalinↄ bùsuuo pínki kũ Ɛflaimunↄ bùsuuo kũ Manasenↄ bùsuuo kũ Yudanↄ bùsuuo pínki ari ísira kũ à kú ifãlɛtɛ kpa ");
INSERT INTO bqp_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","kũ Nɛgɛvio kũ Yɛriko wɛ̃tɛ dominalide guvutɛo ari Zoa. ");
INSERT INTO bqp_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Akũ Dikiri pìnɛ: Bùsu kũ ma la dà Ibrahĩnɛ kũ Isaakuo kũ Yakubuo ma pì mani kpá ń burinↄaa pìin gwe. Ma tò n wɛ́ sìalɛ, ama ĩni bikũ Yodaa ǹ gɛ̃nlo. ");
INSERT INTO bqp_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Akũ Dikiri zↄ̀bleri Musa gà Mↄabunↄ bùsun gwe lákũ Dikiri ò nà. ");
INSERT INTO bqp_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Akũ Dikiri a vĩ̀ guvutɛn gwe Bɛtɛpeo kpa. Gbɛ̃ke a mira ki dↄ̃ro ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Musa gà a wɛ̃̀ basuddode gũmmɛ. A wɛ́ nna akũsↄ̃ a gbãna dí lagoro. ");
INSERT INTO bqp_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Isarailanↄ a gɛ̀ɛ kɛ̀ gↄrↄ baraakuri Mↄabunↄ bùsu sɛ̃̀ntɛ, akũ a gɛ̀kɛna kũ ↄ́ↄdↄo làka. ");
INSERT INTO bqp_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Ɔ̃ndↄ̃ pàpa Nuni nɛ́ Yↄsuaa kũ Musa ↄ nàa yãi. Isarailanↄ a yã mà, ò kɛ̀ lákũ Dikiri dà Musanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Annabi ke dí bo Isarailanↄ gũn lán Musa bà doro. Àdi yã o kũ Dikirio tɛ̃tɛ̃ntɛ̃ ");
INSERT INTO bqp_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","akũsↄ̃ à sèedanↄ kũ daboyã kũ Dikiri à zĩ̀onↄ kɛ̀ Misila, Firi'auna kũ a ìbanↄ kũ a gbɛ̃nↄ arɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Gbɛ̃ke dí yã naasi zↄ̃kↄ̃ kɛ kũ iko gbãnao lán Musa bà Isarailanↄ wɛ́ sìalɛ doro. ");
INSERT INTO bqp_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Dikiri zↄ̀bleri Musa ga gbɛra Dikiri yã ò Musa kpàasi Yↄsua, Nuni nɛ́nɛ à pì: ");
INSERT INTO bqp_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Ma zↄ̀bleri Musa gà. Ǹ futɛ ǹ bikũ Yodaa la sà, mↄkↄ̃n kũ Isarailanↄ ń pínki, à gɛ̃ bùsu kũ ma kpàáwan. ");
INSERT INTO bqp_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Gu kũ á gbá pɛ̀tɛn pínki, ma kpàáwa lákũ ma ò Musanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Sɛna zaa gbárannan ari gɛna Lɛbana bùsun, sɛna zaa swa zↄ̃kↄ̃ kũ òdi pi Yuflati ari gɛna ísira kũ à kú ifãlɛtɛ kpa, Itinↄ bùsuu pì ni gↄ̃ á búsu ũ pínki. ");
INSERT INTO bqp_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ari ǹ gɛ́ gao gbɛ̃ke ni le à n gã̀ fĩro. Lákũ má kú kũ Musao nà, lɛn manigↄ̃ kú kũnwo lɛ. Mani n tónlo, mani pã kpányĩ zikiro. ");
INSERT INTO bqp_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Ǹ zɛ gbãna ǹgↄ̃ wↄ́rↄgↄ vĩ, zaakũ mↄkↄ̃n mɛ́ ĩni bùsu kũ ma a la dà á dizi káakunↄnɛ ma pì mani kpáḿma sí ǹ kpá gbɛ̃ dínↄa. ");
INSERT INTO bqp_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ǹ zɛ gbãna ǹgↄ̃ wↄ́rↄgↄ vĩ dé! Ǹ laakari dↄ doka kũ ma zↄ̀bleri Musa dànnɛa ǹgↄ̃ kũna pínki. Ǹsun kɛ̃a ǹ na ↄplai ke ↄzɛiro, n tá ni kɛ nna. ");
INSERT INTO bqp_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Ǹ tó Musa doka takada pì yã gↄ̃ da n lɛ́n, ǹgↄ̃ laasun lɛ́a fãnantɛ̃ kũ gwãanio. Ǹ laakari dↄ yã kũ à kú a gũnnↄa pínki ǹ zĩ kɛa, n tá nigↄ̃ nna n yã ni bo mana. ");
INSERT INTO bqp_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Makũ mɛ́ ma yã dìtɛnnɛroo? Ǹ zɛ gbãna ǹgↄ̃ wↄ́rↄgↄ vĩ. Ǹsun tó vĩna n kũro, ǹsun bídi kɛro, zaakũ makũ Dikiri n Luda, manigↄ̃ kú kũnwo gu kũ ntɛn gɛ́n pínki. ");
INSERT INTO bqp_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Akũ Yↄsua pì Isaraila don'arɛdenↄnɛ: ");
INSERT INTO bqp_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","À gɛ̃tɛ bùran à o gbɛ̃nↄnɛ ò zàna soru kɛ, zaakũ gↄrↄ aakↄ̃ gbɛra oni bikũ Yodaa la, oni gɛ́ bùsu kũ Dikiri ń Luda kpàḿma ògↄ̃ vĩ sí. ");
INSERT INTO bqp_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Yↄsua pì Rubɛninↄnɛ kũ Gadanↄ kũ Manasenↄ kpadoo: ");
INSERT INTO bqp_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","À dↄ yã kũ Dikiri zↄ̀bleri Musa dìtɛárɛ dín, à pì Dikiri á Luda ni tó à kámmaboki le à bùsu díkĩna kpàáwa. ");
INSERT INTO bqp_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Abire yãi á nↄgbɛ̃nↄ kũ á nɛ́ fítinↄ kũ á pↄ́kãdenↄ gↄ̃ bùsu kũ Musa kpàáwan Yoda bara la, á zĩ̀karinↄ do ń gbɛ̃nↄnɛ arɛ ò bikũ ń pínki, ògↄ̃ ń gↄ̃kɛbↄnↄ kũna ò kpáńyĩ ");
INSERT INTO bqp_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ari Dikiri gↄ̃ tó á gbɛ̃nↄ kámmaboki le lákũ à kɛ̀árɛ nà, mↄ́kↄ̃nↄ sↄ̃ onigↄ̃ bùsu kũ Dikiri á Luda tɛn kpáḿma vĩ. Abire gbɛra áni su bùsu kũ à gↄ̃̀ á pↄ́ ũ díkĩna gũn, áni vutɛ bùsu kũ Dikiri zↄ̀bleri Musa kpàáwa Yoda bara la ifãboki kpa pìn. ");
INSERT INTO bqp_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Akũ ò wèa ò pì: Yã kũ n dìtɛwɛrɛ pínki óni kɛ. Gu kũ n ó zĩn pínki óni gɛ́. ");
INSERT INTO bqp_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Lákũ o zĩ kɛ̀ Musa yã nà pínki, lɛn óni zĩ kɛ n yãa lɛ se. Dikiri n Luda gↄ̃ kú kũnwo, lákũ à kú kũ Musao nà. ");
INSERT INTO bqp_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Gbɛ̃ kũ à bò n yã kpɛ à gì yã kũ n dìtɛnɛ kɛi, ade gàmɛ. Ǹ zɛ gbãna ǹgↄ̃ wↄ́rↄgↄ vĩ dé! ");
INSERT INTO bqp_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Zaa Sitimu Nuni nɛ́ Yↄsua gu'asirigwarinↄ zĩ̀ gbɛ̃nↄn pla asiri gũn à pì: À gɛ́ à wɛ́ kpátɛ bùsuu pìii, atɛ̃nsa Yɛriko. Akũ ò gɛ̀ɛ gwe, ò gɛ̀ɛ ò kìpa karua kũ òdi pinɛ Rahabu bɛn. ");
INSERT INTO bqp_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Akũ ò pì Yɛriko kínanɛ: Isaraila kenↄ gɛ̃̀ la ↄkↄsiala de ò ó bùsu asiri gwa. ");
INSERT INTO bqp_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Akũ kína pì gbɛ̃nↄ zĩ̀ Rahabua ò pì: Ǹ bo kũ gↄ̃gbɛ̃ kũ ò sù n kĩnaanↄ, zaakũ ó bùsu pínki asiri gwana yãin ò sù. ");
INSERT INTO bqp_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Àkũ sↄ̃ nↄgbɛ̃ pì gĩnakɛ à gbɛ̃nↄn pla pìnↄ ùtɛ kↄ̀, akũ à pì: Gbɛ̃ pìnↄ sù ma kĩnaa la yãpuramɛ. Má dↄ̃ gu kũ ò bònlo. ");
INSERT INTO bqp_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Kũ gu sì bĩnizɛtatagↄrↄa, ò bↄ̀tɛ. Má dↄ̃ tó gu kũ ò tànlo. À ń gbɛsɛ likalika, áni ń le. ");
INSERT INTO bqp_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Àkũ sↄ̃ à gĩnakɛ à ń sɛ́ à gɛ̀ɛ kũńwo kpɛ́ musu à ń útɛ bàwisi lí kũ à katɛna gwen kↄ̀. ");
INSERT INTO bqp_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Zĩ̀rinↄ pɛ̀tɛńyĩ zɛ́n ari Yoda bikũkia, akũ ò bĩnizɛ tàta ń kpɛ gↄ̃̀nↄ. ");
INSERT INTO bqp_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Ari gu'asirigwarii pìnↄ gↄ̃ wútɛ, Rahabu dìdi ń kĩnaa kpɛ́ musu ");
INSERT INTO bqp_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","à pìńnɛ: Má dↄ̃ kũ Dikiri bùsu díkĩna kpàáwa. Á vĩna ó kũ, akũ bùsu dí denↄ kã gà ń pínki á yãi. ");
INSERT INTO bqp_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","O mà lákũ Dikiri Isira Tɛ̃ra zↄ̃̀kↄ̃rɛárɛ nà gↄrↄ kũ a bↄtɛ Misila kũ yã kũ a kɛ̀ Siↄ̃ kũ Oguonɛ, a Amↄrinↄ kína gbɛ̃nↄn pla pìnↄ kɛ̀ dúgudugu Yoda bara dire. ");
INSERT INTO bqp_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Kũ o mà, swɛ̃̀ɛ kɛ̃̀ógu, ó nini kòko á yãi, zaakũ Dikiri á Ludamɛ musu kũ zĩtɛo Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Zaakũ ma gbɛ̃kɛ kɛ̀árɛ, ákↄ̃nↄ sↄ̃ à la damɛnɛ sà kũ Dikiri tↄ́o kũ áni gbɛ̃kɛ kɛ ma de bedenↄnɛ. À sèeda kɛmɛnɛ de màgↄ̃ dↄ̃ sãnsãn ");
INSERT INTO bqp_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","kũ áni ma de kũ ma dao kũ ma vĩ̀ninↄ kũ ma dakũnanↄ kũ ó gbɛ̃nↄ mì sí ń pínki à ó bo ga lɛ́i. ");
INSERT INTO bqp_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Akũ gↄ̃gbɛ̃ pìnↄ wèa ò pì: Mↄkↄ̃mmɛ ó wɛ̃̀ndi ũ, ókↄ̃nↄmɛ n wɛ̃̀ndi ũ se. Tó ńdi ó yã o gbɛ̃ke màro, tó Dikiri bùsu díkĩna kpàwá, óni gbɛ̃kɛ kɛnnɛ yãpura. ");
INSERT INTO bqp_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Akũ à ń bↄ́tɛ wondoo gũn à ń kípa bĩni kpɛ kũ bàao, zaakũ a bɛ kũ à kun kú wɛ̃tɛ bĩni musumɛ. ");
INSERT INTO bqp_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","À pìńnɛ: À mì pɛ́ kpinↄa de á gbɛ̀sɛrinↄ sún dakarɛ kãáoro yãi. Àgↄ̃ utɛna gwe gↄrↄ aakↄ̃ ari á gbɛ̀sɛrinↄ su, gbasa à da zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","Akũ gↄ̃gbɛ̃ pìnↄ pìnɛ: Tó o ɛra o gɛ̃ á bùsun, ǹ wↄ̃nↄ tɛ̃ra díkĩna dↄ wondo kũ ntɛni ó bↄtɛn dia, ǹ n de kũ n dao kũ n vĩ̀ninↄ kũ n dakũnanↄ kũ n de bedenↄ kakaranyĩ ń pínki n kpɛ́ díkĩnan. Tó ńdi kɛ lɛro, ó bàka nigↄ̃ kú ladana kũ n tò o la dànnɛn doro. ");
INSERT INTO bqp_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Tó ń gbɛ̃ke bò n kpɛ́n à gɛ̀ɛ gãnulɛa, à a zĩda dɛ̀n gwe, ó yãn doro. Tó ń gbɛ̃ke kú kũnwo kpɛ́n, akũ ò a dɛ̀, ókↄ̃nↄn a gana yã ni wí ó musu. ");
INSERT INTO bqp_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Tó n ó kↄrↄmↄtↄↄ kɛ̀ gbɛ̃nↄnɛ sↄ̃, ó bàka nigↄ̃ kú ladana kũ n tò o la dànnɛ pìn doro. ");
INSERT INTO bqp_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Akũ Rahabu pì: Àgↄ̃ de lákũ a ò nà. Akũ à ń gbárɛ ò tà. Akũ à wↄ̃nↄ tɛ̃ra pìi dↄ̀ a wondooa. ");
INSERT INTO bqp_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Kũ ò kìpa bĩnia lɛ, ò mìi pɛ̀ kpinↄa, akũ ò ì gwe gↄrↄ aakↄ̃ ari ń gbɛ̀sɛrinↄ gɛ̀ɛ sùo. Ń gbɛ̀sɛrii pìnↄ ń wɛ́tɛ zɛ́ sarɛ pínki odi ń lero. ");
INSERT INTO bqp_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Akũ gbɛ̃nↄn pla pìnↄ dà zɛ́n ò kìpa kpi pìnↄa ò bikũ̀ swaa. Kũ ò kà Nuni nɛ́ Yↄsua kĩnaa, ò yã kũ à ń lé gbã̀nɛ pínki ");
INSERT INTO bqp_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ò pì: Dikiri bùsuu pìi nàwɛrɛ ó ↄĩ pínki. Bùsupidenↄ kã gà ń pínki ó yãi. ");
INSERT INTO bqp_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Yↄsua fùtɛ kↄnkↄkↄnkↄ kũ Isarailanↄ ń pínki. Bona Sitimu ò gɛ̀ɛ Yodai, akũ ò bùraa kàtɛ gwe ari ògↄ̃ gɛ́ bikũ. ");
INSERT INTO bqp_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Gↄrↄ aakↄ̃ gbɛra Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kurèkure bùraai ");
INSERT INTO bqp_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ò yã dìtɛ gbɛ̃nↄnɛ ò pì: Tó a è Levi buri sa'orinↄ Dikiri á Luda bàka kunna kũoo àkpati sɛna, à da zɛ́n àgↄ̃ tɛ́ ń kpɛ, ");
INSERT INTO bqp_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","de à le à dↄ̃ zɛ́ kũ áni sɛ́, zaakũ ádi zɛ́ pì sɛ́ zikiro. Àgↄ̃ tɛ́ zã̀zã lán kiloo do taka bà yↄↄ! Àsun na àkpatii pìiiro. ");
INSERT INTO bqp_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Akũ Yↄsua pì gbɛ̃nↄnɛ: À gbã̀ bo á zĩdanɛ, zaakũ Dikiri ni yãbonsarɛ kɛ á tɛ́ zia. ");
INSERT INTO bqp_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Akũ à ɛ̀ra à pì sa'orinↄnɛ: À Dikiri bàka kunna kũoo àkpati sɛ́ à do gbɛ̃nↄnɛ arɛ à bikũo. Akũ ò àkpatii pìi sɛ̀ ò dòo gbɛ̃nↄnɛ arɛ. ");
INSERT INTO bqp_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Dikiri pì Yↄsuanɛ: Mani na n sɛna leia Isarailanↄnɛ gbãra, onigↄ̃ dↄ̃ kũ má kú kũnwo lákũ má kú kũ Musao nà. ");
INSERT INTO bqp_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ǹ o sa'ori kũ ò ma bàka kunna kãáo àkpati sɛnanↄnɛ, tó ò kà Yodai, ò gɛ̃ ò zɛ a ín. ");
INSERT INTO bqp_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Akũ Yↄsua pì Isarailanↄnɛ: À mↄ́ la à Dikiri á Luda yã ma. ");
INSERT INTO bqp_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Akũ à ɛ̀ra à pì: Lɛn ánigↄ̃ dↄ̃ kũ Luda Wɛ̃̀ndide kú kãáo lɛ, akũsↄ̃ ani pɛ́árɛ Kanaanↄa kũ Itinↄ kũ Ivinↄ kũ Pɛrizinↄ kũ Gigasinↄ kũ Amↄrinↄ kũ Yebusinↄo. ");
INSERT INTO bqp_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","À gwa! Andunia sĩnda pínki Dikiri bàka kunna kũoo àkpati ni doárɛ arɛ ari Yoda ín. ");
INSERT INTO bqp_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","À gbɛ̃nↄn kuri awɛɛplanↄ sɛ́ á tɛ́, buri kũ burio gbɛ̃ mɛ̀n dodo. ");
INSERT INTO bqp_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Tó sa'ori kũ ò andunia sĩnda pínki Dikiri àkpati sɛnanↄ gbá pɛ̀tɛ Yoda ín, í pì ni zↄ̃kↄ̃rɛ, í kũ àtɛn bo swa musu ni kɛ bĩni ũ à gↄ̃ zɛna a gbɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Kũ gbɛ̃nↄ bùra fùtɛ ò dà zɛ́n, òtɛn gɛ́ bikũ Yodaa, sa'ori kũ ò Dikiri bàka kunna kũńwo àkpati sɛnanↄ tɛ́ ń arɛ lɛ. ");
INSERT INTO bqp_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Burapↄnↄ kɛkɛgↄrↄ sĩnda pínki swa pìi dì pa ari à dà sĩ̀sĩla, ama gↄrↄ kũ àkpatisɛrii pìnↄ kà swa pìii, kũ ò gbá pɛ̀tɛ ín, ");
INSERT INTO bqp_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","akũ í kũ àtɛn bo swa pìi musu zↄ̃̀kↄ̃rɛ à bĩni kɛ̀ à gↄ̃̀ zɛna a gbɛ̀n zaa zã̀zã wɛ̃tɛ kũ òdi pi Adamu sarɛ Zarɛtã bùsun. Í kũ àtɛn ta sɛ̀bɛ wisiden zↄ̃̀kↄ̃rɛ míↄmiↄ, akũ gbɛ̃nↄ bikũ̀ arɛdↄkↄ̃ana kũ Yɛrikoo. ");
INSERT INTO bqp_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Sa'ori kũ ò Dikiri bàka kunna kũńwo àkpati sɛnanↄ gↄ̃̀ zɛna Yoda wɛ̀ɛn zĩtɛ koria gíngin, akũ Isaraila buri sĩnda pínki tɛ́ gukori pìn ari ò gɛ̀ɛ ò bikũ̀ ń pínki ò làka. ");
INSERT INTO bqp_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Kũ Isaraila buri sĩnda pínki bikũ̀ Yodaa ò làka, akũ Dikiri pì Yↄsuanɛ: ");
INSERT INTO bqp_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","Á buri mɛ̀n kuri awɛɛplanↄ tɛ́ à gbɛ̃nↄ sɛ́n dodo ");
INSERT INTO bqp_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ǹ ońnɛ ò gbɛ̀ sɛ́tɛ swawɛɛn mɛ̀n kuri awɛɛpla gu kũ sa'orinↄn zɛn súsu, ò bikũo ò kátɛ gu kũ áni in gwãaniala. ");
INSERT INTO bqp_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Akũ Yↄsua gbɛ̃nↄn kuri awɛɛplanↄ dìtɛ Isaraila burinↄ tɛ́ dodo, akũ à ń sísi ");
INSERT INTO bqp_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","à pìńnɛ: À gɛ́ Yoda wɛ̀ɛn Dikiri á Luda àkpati arɛ, á baadi gbɛ̀ sɛ́ à di a gã̀n á Isaraila burinↄ dasi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Gbɛ̀ dínↄ ni gↄ̃árɛ sèeda ũ. Tó á nɛ́nↄ á lá zia, bↄ́n gbɛ̀ dínↄ deárɛ a ũu, ");
INSERT INTO bqp_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","à pińnɛ, kũ ò ye ò bikũ kũ Dikiri bàka kunna kũoo àkpatiio, akũ a í zↄ̃̀kↄ̃rɛ, akũ gbɛ̀ɛ pìnↄ gↄ̃̀ Isarailanↄnɛ a dↄngu pↄ́ ũ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Lɛn Isarailanↄ kɛ̀ lɛ lákũ Yↄsua òńnɛ nà. Ò gbɛ̀ɛ sɛ̀tɛ Yoda wɛ̀ɛn mɛ̀n kuri awɛɛpla Isaraila burinↄ dasi lɛ́n lákũ Dikiri ò Yↄsuanɛ nà. Ò bikũ̀o ò kàtɛ gu kũ ò ìn. ");
INSERT INTO bqp_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Gbɛ̀ mɛ̀n kuri awɛɛpla kũ ò sɛ̀tɛ swawɛɛn sa'ori kũ ò àkpati sɛnaa pìnↄ zɛkian Yↄsua dìdikↄ̃a, ò kú gwe ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Sa'ori kũ ò àkpatii pì sɛnanↄ gↄ̃̀ zɛna swawɛɛn ari yã kũ Dikiri dìtɛ Yↄsuanɛ à ò gbɛ̃nↄnɛɛ gɛ̀ɛ à làkao pínki lákũ Musa dìtɛnɛ nà. Gbɛ̃nↄ kɛ̀ likalika ò bikũ̀. ");
INSERT INTO bqp_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Kũ ò bikũ̀ ń pínki ò làka, gbasa sa'orinↄ bikũ̀ kũ Dikiri àkpatiio gbɛ̃nↄ wára. ");
INSERT INTO bqp_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Rubɛni buri gↄ̃gbɛ̃nↄ kũ Gada buri gↄ̃gbɛ̃nↄ kũ Manasenↄ kpado gↄ̃gbɛ̃nↄ mɛ́ ò dò Isaraila buri kparanↄnɛ arɛ ò bikũ̀ lákũ Musa òńnɛ yã nà. Ò ń zĩ̀kabↄnↄ kũna. ");
INSERT INTO bqp_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Ń zĩ̀karinↄ kà gbɛ̃nↄn dúbu bupla taka. Ò bikũ̀ Dikiri arɛ ò gɛ̀ɛ Yɛriko gbárannan kũ zĩ̀ soruo. ");
INSERT INTO bqp_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Zĩ birean Dikiri Yↄsua sɛ̀ lei Isarailanↄnɛ ń pínki, akũ ò a yã mà ari à gɛ̀ɛ à gào lákũ ò Musa yã mà nà. ");
INSERT INTO bqp_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Akũ Dikiri pì Yↄsuanɛ: ");
INSERT INTO bqp_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Ǹ o sa'ori kũ ò doka àkpati sɛnanↄnɛ ò bo swawɛɛn. ");
INSERT INTO bqp_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Akũ Yↄsua òńnɛ ò bo swawɛɛn, ");
INSERT INTO bqp_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","akũ ò bòn. Kũ ò gbá pɛ̀tɛ sĩ̀sĩia, akũ swa'i ɛ̀ra à sù a gbɛ̀n gↄ̃̀nↄ. À pà à dàgula ari à dà sĩ̀sĩla lán káakupↄ bà. ");
INSERT INTO bqp_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Mↄ káaku gↄrↄ kuride zĩn Isarailanↄ bò Yoda swawɛɛn ò gɛ̀ɛ ò bùraa kàtɛ Giligala, Yɛriko ifãboki kpa. ");
INSERT INTO bqp_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Yↄsua gbɛ̀ mɛ̀n kuri awɛɛpla kũ ò sɛ̀tɛ Yoda wɛ̀ɛn pìnↄ dìdikↄ̃a Giligala gwe. ");
INSERT INTO bqp_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","À pì gbɛ̃nↄnɛ: Tó á nɛ́nↄ sù ò ń denↄ là zia ò pì, gbɛ̀ dínↄ yáasi de deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","À pińnɛ, á bikũna Yodaa gukoria sèedaamɛ, ");
INSERT INTO bqp_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","zaakũ Dikiri á Luda a í bàbaárɛ á zɛ́n, akũ a bikũ̀ lákũ a bikũ̀ Isira Tɛ̃ra kũ à a í bàbaárɛa nà. ");
INSERT INTO bqp_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Dikiri kɛ̀ lɛ, de andunia buri sĩnda pínki gↄ̃ dↄ̃ kũ à gbãna vĩ, ákↄ̃nↄ sↄ̃ àgↄ̃ Dikiri á Luda vĩna vĩ gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Kũ Amↄrinↄ kína kũ ò kú Yoda ifãlɛtɛ kpanↄ kũ Kanaanↄ kína kũ ò kú ísira sarɛnↄ mà lákũ Dikiri Yoda í zↄ̃̀kↄ̃rɛ Isarailanↄnɛ ò bikũ̀ nà, akũ swɛ̃̀ɛ kɛ̃̀ńgu ń kã gà ń pínki Isarailanↄ yãi. ");
INSERT INTO bqp_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Gↄrↄ birea Dikiri pì Yↄsuanɛ: Ǹ gbɛ̀ fɛ̃nɛnↄ kɛ ǹ ɛra ǹ tↄ̃̀ zↄ̃ Isarailanↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Akũ Yↄsua pì ò gbɛ̀ fɛ̃nɛnↄ kɛ, akũ ò tↄ̃̀ↄ zↄ̃̀o Isarailanↄnɛ gu kũ òdi pi tera gyↄfↄrↄ Sĩ̀sĩi. ");
INSERT INTO bqp_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Yã kũ à tò à tↄ̃̀ↄ zↄ̃̀ńnɛn dí. Isarailanↄ bↄtɛna Misila gbɛra, ń tá gũn, gↄ̃ gbãna kũ ò tↄ̃̀ↄ zↄ̃̀nↄ gàga gbárannan ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Gbɛ̃ kũ ò bↄ̀tɛ Misilanↄ tↄ̃̀zↄ̃na ń pínki. Gbɛ̃ kũ ò ń í gbárannan zɛ́ gũn bona Misila gbɛranↄ, mↄ́kↄ̃nↄ mɛ́ òdi tↄ̃̀ zↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Isarailanↄ tɛ́ gbárannan wɛ̃̀ bupla ari gbɛ̃ kũ ò de gↄ̃ gbãnanↄ ũ gↄrↄ kũ ò bↄ̀tɛ Misilanↄ gɛ̀ɛ ò gàgao ń pínki, zaakũ odi Dikiri yã maro. Dikiri pìńnɛ oni wɛ́ si bùsu kũ a a lɛ́ sɛ̀ ń dizinↄnɛ à pì áni kpáḿmalɛro, bùsu kũ vĩ kũ zↄ́'io din pìi. ");
INSERT INTO bqp_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ń nɛ́ kũ Dikiri tò ò fùtɛ ń gbɛranↄn Yↄsua tↄ̃̀ↄ zↄ̃̀ńnɛ, zaakũ gyↄfↄrↄdenↄmɛ, odi tↄ̃̀ zↄ̃ńnɛ zɛ́nlo. ");
INSERT INTO bqp_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Kũ Isarailanↄ tↄ̃̀ↄ zↄ̃̀ ń pínki ò làka, ò gↄ̃̀ gu kũ ò bùraa kàtɛn gwe ari ń bↄ̀ↄ gɛ̀ɛ à làkao. ");
INSERT INTO bqp_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Akũ Dikiri pì Yↄsuanɛ: Ma wé'i kũ Misilanↄ dàáwa bòare gbãran gwe. Akũ ò tↄ́ kpà gu pìinɛ Giligala ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Isarailanↄ bùra katɛna Giligala akũ ò Vĩnla dikpɛ kɛ̀ Yɛriko gbárannan gwe mↄ pì gↄrↄ gɛ̃ro donsaride zĩ ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Kũ ò dikpɛ pìi kɛ̀ gu dↄ̀ ò bùsuu pì burapↄnↄ blè, burodi futɛnasari kũ pↄ́blewɛ kpatanaao. ");
INSERT INTO bqp_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ń bùsuu pì burapↄnↄ blenaa gbɛra, kũ gu dↄ̀, manakↄtɛnaa zɛ̀, adi kↄ́tɛńnɛ doro, akũ ò Kanaanↄ bùsu pↄ́ blè wɛ̃̀ birea sà. ");
INSERT INTO bqp_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Kũ Yↄsua kà kãni kũ Yɛrikoo, à wɛ́ sɛ̀ à gu gwà, akũ à gↄ̃gbɛ̃ ke è zɛna a arɛ kũ fɛ̃nɛdao na a ↄ̃i. Akũ Yↄsua nài à a là à pì: Ń kú ó kpɛn yá, ke ó ibɛrɛnↄ kpɛ? ");
INSERT INTO bqp_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","À wèa à pì: Lɛnlo. Dikiri zĩ̀karinↄ don'arɛden ma ũ, ma kanan dí. Akũ Yↄsua kùtɛnɛ à mìi pɛ̀tɛ, akũ à a là à pì: Yã kpaten ma Dikiri ni o makũ a zↄ̀bleriinɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Dikiri zĩ̀karinↄ don'arɛde pìi wèa à pì: Ǹ n kyate bobo, zaakũ gu kũ ń zɛ́n kú adona. Akũ Yↄsua kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ò Yɛriko bĩnizɛ gbànↄ tàta gíngin Isarailanↄ yãi. Gbɛ̃ke dí boro, gbɛ̃ke dí gɛ̃ro. ");
INSERT INTO bqp_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Akũ Dikiri pì Yↄsuanɛ: Ǹ gwa, ma Yɛriko nànnɛ n ↄĩ kũ a kínao kũ a zĩ̀karinↄo. ");
INSERT INTO bqp_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Mↄkↄ̃n kũ n zĩ̀karinↄ à gɛ́ à lika wɛ̃tɛ pìii gɛ̃̀n do á pínki à su. Àgↄ̃ likai gɛ̃̀n dodo lɛ ari gↄrↄ suddo. ");
INSERT INTO bqp_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Sa'ori gbɛ̃nↄn supplanↄ do àkpatiinɛ arɛ ògↄ̃ kuru kũna. A gↄrↄ supplade zĩ à lika wɛ̃tɛ pìii gɛ̃̀n suppla gↄrↄ kũ sa'orii pìnↄ tɛni ń kuru pɛ́. ");
INSERT INTO bqp_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Tó ò kuru pɛ̀ òtɛni a yĩsãm pá, akũ a a ũ mà, gbɛ̃ sĩnda pínki wiki lɛ́ gbãnagbãna, wɛ̃tɛ bĩni ni sikũn, á baadi ni sin. ");
INSERT INTO bqp_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Akũ Nuni nɛ́ Yↄsua sa'orinↄ sìsi à pìńnɛ: À Dikiri bàka kunna kũoo àkpati sɛ́, a gbɛ̃nↄn supplanↄ ni donɛ arɛ, á baadi nigↄ̃ kuru kũna. ");
INSERT INTO bqp_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Akũ à pì gbɛ̃nↄnɛ: À futɛ à gɛ́ à lika wɛ̃tɛi gɛ̃̀n do. Zĩ̀karinↄ mɛ́ ò do Dikiri àkpatiinɛ arɛ. ");
INSERT INTO bqp_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Kũ Yↄsua yã ò gbɛ̃nↄnɛ, akũ sa'ori gbɛ̃nↄn suppla kũ ò kuru kũnaa pìnↄ fùtɛ ò dò Dikiri bàka kunna kũńwo àkpatiinɛ arɛ, òtɛni ń kuru pɛ́. ");
INSERT INTO bqp_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Zĩ̀karinↄ tɛ́ sa'orii pìnↄ arɛ, pari tɛ́ àkpati kpɛ, akũsↄ̃ kurunↄ ũ dↄ. ");
INSERT INTO bqp_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","À sù à lè Yↄsua ò gbɛ̃nↄnɛ à pì: Àsun wiki lɛ́ro. Àsun tó ò á kĩni maro. Àsun tó yãke bo á lɛ́nlo ari gↄrↄ kũ mani oárɛ à wiki lɛ́, gbasa à lɛ́. ");
INSERT INTO bqp_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Ò gɛ̀ɛ ò lìka wɛ̃tɛ pìii kũ àkpatiio gɛ̃̀n do lɛ, akũ ò ɛ̀ra ò tà ń bùran ò ì gwe. ");
INSERT INTO bqp_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Yↄsua fùtɛ kↄnkↄkↄnkↄ, akũ sa'orinↄ Dikiri àkpatii sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Sa'ori gbɛ̃nↄn suppla kũ ò kuru kũnaa pìnↄ dò Dikiri àkpatiinɛ arɛ, òtɛn pɛ́. Zĩ̀karinↄ dòńnɛ arɛ, pari tɛ́ àkpatii pì kpɛ, akũsↄ̃ kurunↄ ũ dↄ. ");
INSERT INTO bqp_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ò lìka wɛ̃tɛ pìii gɛ̃̀n do a gↄrↄ plade zĩ, akũ ò ɛ̀ra ò tà ń bùran. Ò kɛ̀ lɛ ari gↄrↄ suddo. ");
INSERT INTO bqp_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","A gↄrↄ supplade zĩ ò fùtɛ kↄnkↄ gudↄnaao, akũ ò ɛ̀ra ò gɛ̀ɛ ò lìka wɛ̃tɛ pìii lákũ òdi kɛ nà. Ama zĩ birea ò lìkai gɛ̃̀n supplamɛ. ");
INSERT INTO bqp_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","A gɛ̃̀n supplade pìia gↄrↄ kũ sa'orinↄ tɛn gɛ́ ń kuru yĩsãm pá, akũ Yↄsua pì gbɛ̃nↄnɛ: À wiki lɛ́, zaakũ Dikiri wɛ̃tɛ pìi kpàáwamɛ. ");
INSERT INTO bqp_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Dikiri wɛ̃tɛ pì kũ pↄ́ kũ ò kunnↄ dìtɛ a pↄ́ ũmɛ. Ò ń kakatɛ ń pínki. Karua Rahabu kũ gbɛ̃ kũ ò kú kãao a bɛanↄ mɛ́ oni bo ńtɛ̃nɛ, zaakũ àkũ mɛ́ à gu'asirigwari kũ ò ń zĩnↄ ùtɛ. ");
INSERT INTO bqp_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","À laakari kɛ! Àsun pↄ́ kũ Dikiri dìtɛ a pↄ́ ũ ke sɛ́ro, de àsun kakatɛro yãi. Tó a sɛ̀, áni yã gátɛ á bùraanɛ à gↄ̃ kakatɛna pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Andurufu kũ wuraao kũ mↄ̀gotɛ̃ pↄ́nↄ kũ mↄ̀si pↄ́nↄ pínki bi Dikiri pↄ́mɛ. Séde ò ká Dikiri aruzɛkɛ utɛkin. ");
INSERT INTO bqp_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Kũ ò kuru pɛ̀, akũsↄ̃ Isarailanↄ wiki lɛ̀ gbãnagbãna lɛ, wɛ̃tɛ bĩninↄ sìkũn. Akũ ń baadi sìn súsu, akũ ò wɛ̃tɛ pìi sì. ");
INSERT INTO bqp_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Ò pↄ́ kũ ò kunnↄ dìtɛ Dikiri pↄ́ ũ, akũ ò gbɛ̃nↄ kàkatɛ ń pínki kũ fɛ̃nɛdao, gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ, nɛ́ fítinↄ gbɛ̃ zↄ̃kↄ̃nↄ kũ zùnↄ kũ sãnↄ kũ zaakinↄo. ");
INSERT INTO bqp_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Yↄsua pì gbɛ̃nↄn pla kũ ò gɛ̀ɛ ò bùsuu pìi asiri gwànↄnɛ: À gɛ̃ karuaa pì kpɛ́n à bo kãao kũ a gbɛ̃nↄ, lákũ a a la dànɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Akũ kɛfɛnna pìnↄ gɛ̀ɛ ò bò kũ Rahabuo kũ a deo kũ a dao kũ a vĩ̀ninↄ kũ a dakũnanↄ kũ a gbɛ̃nↄ ń pínki. Ò sù kãao kũ a danɛnↄ ń pínki, akũ ò ń kátɛ Isarailanↄ bùraa sarɛ. ");
INSERT INTO bqp_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Akũ ò tɛ́ sↄ̃̀ wɛ̃tɛ pìia kũ pↄ́ kũ ò kunnↄ pínki, tó adi kɛ andurufu kũ wuraao kũ mↄ̀gotɛ̃ pↄ́nↄ kũ mↄ̀si pↄ́ kũ ò sɛ̀tɛ ò kàtɛ Dikiri bizakuta aruzɛkɛ utɛkin baasiro. ");
INSERT INTO bqp_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Yↄsua tò karua Rahabu bò aafia kũ a de bedenↄ kũ a gbɛ̃nↄ ń pínki, kũ à gu'asirigwari kũ Yↄsua ń zĩ Yɛriko asiri gwanↄ ùtɛ yãi, akũ ò gↄ̃̀ Isarailanↄ tɛ́ ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Gↄrↄ birea Yↄsua lɛ́ kɛ̀ à pì: Dikiri láari bo gbɛ̃ kũ ani futɛ à Yɛriko wɛ̃tɛ dí kɛkɛ à kátɛa. Tó à a bĩni ɛ̃ pɛ̀tɛ, a daudu ni ga. Tó à a gbànↄ pɛ̀tɛ sↄ̃, a nɛ́ kpɛde ni ga. ");
INSERT INTO bqp_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Dikiri kú kũ Yↄsuao, akũ a tↄ́ dà bùsuu pìla pínki. ");
INSERT INTO bqp_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Isarailanↄ tɛ̃̀ pↄ́ kɛ̀. Kaami nɛ́ Akã, Zimiri daikore, Zɛra sãkpɛ, Yuda buri mɛ́ à tɛ̃̀ pↄ́ kenↄ sɛ̀, akũ Dikiri pↄ fɛ̃̀ Isarailanↄi. ");
INSERT INTO bqp_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Yↄsua gbɛ̃nↄ zĩ̀ à pì, ò bo Yɛriko ò gɛ́ Ai kũ à kú Bɛtavɛ̃ sarɛ Bɛtɛli ifãboki kpa de ò bùsuu pì asiri gwa. Akũ ò gɛ̀ɛ ò Ai asiri gwà. ");
INSERT INTO bqp_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Kũ ò sù Yↄsua kĩnaa, ò pìnɛ: Aidenↄn dasiro, adi ká ò gɛ́ gwe ó pínkiro. Tó gbɛ̃nↄn wàa kuri ke gɛ̃ro gɛ̀ɛ, oni wɛ̃tɛ pì sí. Ǹsun wari dↄ gbɛ̃nↄa ń pínkiro. ");
INSERT INTO bqp_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Kũ gbɛ̃nↄn wàa gɛ̃ronↄ gɛ̀ɛ gwe, akũ Aidenↄ ń fú ");
INSERT INTO bqp_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ò pɛ̀ḿma bona zaa ń wɛ̃tɛ bĩnilɛa ari gbɛ̀wikia, ò ń dɛdɛ sĩ̀sĩgɛrɛɛi gbɛ̃nↄn baraakuri awɛɛsuddo. Akũ swɛ̃̀ɛ kɛ̃̀ Isarailanↄgu ń nini kòko. ");
INSERT INTO bqp_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Yↄsua a uta gà à kɛ̃̀ à wùtɛ a nɛ̀sɛlɛ kutɛna Dikiri àkpati arɛ ari ↄkↄsi. Àpi kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ bùsuu kùku ń mìia. ");
INSERT INTO bqp_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Akũ Yↄsua pì: É'e! Dikiri Luda! À kɛ̀ dera n ó bikũ Yodaa n ó ná Amↄrinↄnɛ ń ↄĩ ò ó kakatɛɛ? Tó ó vutɛna Yoda bara dire yã dé! ");
INSERT INTO bqp_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","N yã nna Dikiri! Zaakũ Isarailanↄ bòru kpɛ ń ibɛrɛnↄnɛ, mani pi dera sàa? ");
INSERT INTO bqp_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Kanaanↄ kũ bùsu dí denↄ ni yã pì ma ń pínki, ò likawái ò ó kakatɛ andunian. N tↄ́ zↄ̃kↄ̃kɛ sↄ̃ bi? Ĩni kɛo deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Akũ Dikiri pì Yↄsuanɛ: Ǹ futɛ ǹ zɛ! À kɛ̀ dera n wutɛ n nɛ̀sɛlɛ kutɛnaa? ");
INSERT INTO bqp_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Isarailanↄ durunna kɛ̀, ò ma bàka kunna kũńwo yã gbòro. Ò tɛ̃̀ pↄ́ kenↄ sɛ̀, ò kpãni ò, ò manafiki kɛ̀, ò pↄ́ pìi dà ń pↄ́nↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Abire yãi odi fↄ̃ ò ń ibɛrɛnↄ gã̀ fĩ̀ro. Ò bòru kpɛńnɛ, kũ ò gↄ̃̀ kakatɛna pↄ́ ũ yãi. Manigↄ̃ kú kãáo doro, séto a tɛ̃̀ pↄ́ kũ à kú á tɛ́nↄ kàkatɛ. ");
INSERT INTO bqp_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Ǹ futɛ ǹ gɛ́ gbã̀ bo n gbɛ̃nↄnɛ. Ǹ pińnɛ ò gbã̀ bo ń zĩdanɛ ari gu gↄ̃ dↄ, zaakũ makũ Dikiri Isarailanↄ Luda ma pì, tɛ̃̀ pↄ́ kú á tɛ́mɛ. Áni fↄ̃ à zɛ á ibɛrɛnↄ arɛro séto à pↄ́ pì bò á tɛ́. ");
INSERT INTO bqp_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Tó gu dↄ̀, à namai buri kũ burio. Buri kũ ma sɛ̀ ni namai danɛdanɛ, danɛ kũ ma sɛ̀nↄ ni namai ↄn kũ ↄnnwo, ↄn kũ ma sɛ̀ sↄ̃, a gↄ̃gbɛ̃nↄ ni namai dodo. ");
INSERT INTO bqp_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Gbɛ̃ kũ ò sù ò tɛ̃̀ pↄ́ pìi lèa, oni ade kpata kũ pↄ́ kũ à vĩnↄ pínki, zaakũ à ma bàka kunna kãáo yã gbòro, à wé'i dà Isarailanↄa. ");
INSERT INTO bqp_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Yↄsua fùtɛ kↄnkↄ káakukaaku, à tò Isarailanↄ nà Dikirii buri kũ burio, akũ gbɛ̀ Yuda buri sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Akũ à tò Yudanↄ nài danɛdanɛ, akũ gbɛ̀ Zɛra danɛnↄ sɛ̀. À tò Zɛra danɛnↄ nài ↄn kũ ↄnnwo, akũ gbɛ̀ Zimiri ↄnn sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Akũ à tò a ↄn gↄ̃gbɛ̃nↄ nài dodo, akũ gbɛ̀ Kaami nɛ́ Akã, Zimiri daikore, Zɛra sãkpɛ, Yuda buri sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Akũ Yↄsua pì Akãnɛ: Nɛ́, ǹ yãpura o ǹ bɛ̀ɛrɛ lí Dikiri Isarailanↄ Ludanɛ. Ǹ yã kũ n kɛ̀ omɛnɛ. Ǹsun a ke utɛmɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Akũ à wèa à pì: Yãpuramɛ, ma durunna kɛ̀ Dikiri Isarailanↄ Ludanɛ. Yã kũ ma kɛ̀n dí. ");
INSERT INTO bqp_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ma Babilↄnia arukĩmba mana è ń pↄ́nↄ tɛ́ kũ andurufuuo kiloo pla kũ wura kiloo kusuo, akũ ma a ni dɛ̀ ma sɛ̀. À utɛna wɛ̀ɛn ma kpɛ́n, andurufu kú zĩtɛ. ");
INSERT INTO bqp_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Akũ Yↄsua gbɛ̃nↄ zĩ̀ gwe. Ò kɛ̀ likalika ò gɛ̀ɛ ò gɛ̃̀ a kpɛ́n, akũ ò è utɛna gwe, andurufu kú zĩtɛ. ");
INSERT INTO bqp_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Akũ ò sɛ̀tɛ ò sùo Yↄsuanɛ kũ Isarailanↄ ń pínki, ò kàtɛ Dikiri arɛ. ");
INSERT INTO bqp_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Akũ Yↄsua kũ Isarailanↄ Zera sãkpɛ Akã sɛ̀ kũ andurufuuo kũ arukĩmbaao kũ wuraa pìio kũ a nɛ́gↄ̃gbɛ̃nↄ kũ a nɛ́nↄgbɛ̃nↄ kũ a zùnↄ kũ a zaakinↄ kũ a sãnↄ kũ a bizakutao kũ a pↄ́nↄ pínki, ò gɛ̀ɛ kũńwo Ako guvutɛn. ");
INSERT INTO bqp_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Akũ Yↄsua pì: N yã gàtɛwɛrɛ fá! Dikiri ni yã mↄnnɛ gbãra sↄ̃. Akũ Isarailanↄ a pàpa kũ gbɛ̀ɛo ń pínki, ò a dɛ̀ kũ a gbɛ̃nↄ ń pínki, akũ ò ń kpáta. ");
INSERT INTO bqp_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Ò gbɛ̀ kàkara a musu, gbɛ̀didikↄ̃ana zↄ̃kↄ̃ↄ pì kú gwe ari kũ a gbãrao. Akũ Dikiri pↄfɛ̃ kpàtɛ. Abire yãin òdi pi gu pìinɛ Akoo guvutɛ. ");
INSERT INTO bqp_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Dikiri pì Yↄsuanɛ: Ǹsun tó vĩna n kũro, ǹsun bídi kɛro. Ǹ zĩ̀karinↄ sɛ́tɛ ǹ gɛ́ kũńwo ń pínki à lɛ́tɛ Aia, zaakũ ma Ai kína nànnɛ n ↄĩ kũ a gbɛ̃nↄ kũ a wɛ̃tɛo kũ a bùsuuo. ");
INSERT INTO bqp_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Ǹ kɛ Ainɛ kũ a kínao lákũ n kɛ̀ Yɛrikonɛ nà kũ a kínao. Áni fↄ̃ à ń pↄ́nↄ kũ ń pↄ́kãdenↄ sɛ́tɛ á pↄ́ ũ sà. Ǹ natɛńnɛ ń wɛ̃tɛ kpɛ. ");
INSERT INTO bqp_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Akũ Yↄsua kũ a zĩ̀karinↄ gɛ̀ɛ ò lɛ́tɛ Aia ń pínki. À gↄ̃sa gbãnanↄ sɛ̀ gbɛ̃nↄn dúbu baraakuri, akũ à ń gbárɛ gwãani ");
INSERT INTO bqp_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","à pìńnɛ: À sã kpá! À natɛńnɛ ń wɛ̃tɛ kpɛ. Àsun kɛ zã̀ kũ wɛ̃tɛ pìioro. Àgↄ̃ kú soru gũn á pínki. ");
INSERT INTO bqp_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Makũ kũ gbɛ̃ kũ ò kú kũmaonↄ óni na wɛ̃tɛ pìii. Tó ò bò daólɛ, ónigↄ̃ bàa lɛ́ńnɛ lán káaku bà. ");
INSERT INTO bqp_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Oni pɛ́wá ari oni kɛ̃ ń wɛ̃tɛa zã̀, zaakũ onigↄ̃ da ótɛn bàa lɛ́ńnɛ lán káaku bàmɛ. Tó ótɛn bàa lɛ́ńnɛ lɛ, ");
INSERT INTO bqp_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","à futɛ á utɛkia à wɛ̃tɛ pì sí. Dikiri á Luda nàárɛ á ↄĩmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Tó a wɛ̃tɛ pìi sì, à tɛ́ sↄ̃a lákũ Dikiri ò nà. À laakari kɛ, à kɛ lákũ ma dìtɛárɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Akũ Yↄsua ń gbárɛ, ò gɛ̀ɛ gu kũ oni le ò ń zãmba kɛn. Ò nàtɛ Bɛtɛli kũ Aio dagura Ai ifãlɛtɛ kpa. Gwãani birea Yↄsua ì bùran gwe kũ a gbɛ̃nↄo. ");
INSERT INTO bqp_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","À fùtɛ kↄnkↄkↄnkↄ à gbɛ̃nↄ kàkara, akũ àpii kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ dòńnɛ arɛ ari ò gɛ̀ɛ ò kào Ai. ");
INSERT INTO bqp_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Zĩ̀kari kũ ò kú kãaonↄ nà wɛ̃tɛ pìii ń pínki. Kũ ò kào kãni, ò bùraa kàtɛ a arɛ gugbãnduru kpa. Guvutɛ kú ń dagura kũ Aio. ");
INSERT INTO bqp_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Yↄsua gbɛ̃nↄ sɛ̀ dúbu sↄↄro. À gĩnakɛ à ń útɛ Bɛtɛli kũ Aio dagura kↄ̀ Ai ifãlɛtɛ kpa. ");
INSERT INTO bqp_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Isarailanↄ bùraa kàtɛ wɛ̃tɛ gugbãnduru kpa, akũsↄ̃ gbɛ̃ kũ ò natɛna pìnↄn kú wɛ̃tɛ ifãlɛtɛ kpa. Gwãani birea Yↄsua ì guvutɛmmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Kũ Ai kína Isarailanↄ è lɛ, àkũ kũ a wɛ̃tɛdenↄ fùtɛ ò kɛ̀ likalika ò gɛ̀ɛńyĩ kũ zĩ̀io gu kũ à arɛ dↄ̀ Araba gbárannaa. À dↄ̃ kũ gbɛ̃nↄ natɛna a wɛ̃tɛ kpɛro. ");
INSERT INTO bqp_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Yↄsua kũ Isarailanↄ tɛn kɛ lákũ Aidenↄ tɛni ń fu bà, òtɛn bàa lɛ́ńnɛ ò mìi pɛ̀ gbárannaa. ");
INSERT INTO bqp_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Aidenↄ kↄ̃ sìsi ń pínki ò bↄtɛ ò pɛ́ Yↄsuanↄa, akũ ò pɛ̀ḿma ari ò gɛ̀ɛ ò kɛ̃̀ ń wɛ̃tɛa zã̀zã. ");
INSERT INTO bqp_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Gↄ̃gbɛ̃ ke dí gↄ̃ wɛ̃tɛ gũnlo, ò bↄ̀tɛ ò pɛ̀ Isarailanↄa ń pínki, akũ ò ń wɛ̃tɛ bĩnilɛ tò wɛ̃na, òtɛn pɛ́ Isarailanↄa. ");
INSERT INTO bqp_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Dikiri pì Yↄsuanɛ: Ǹ sári kũ ń kũna dↄ Aia, zaakũ ma nànnɛ n ↄĩmɛ. Akũ Yↄsua a sári pìi dↄ̀ Aia. ");
INSERT INTO bqp_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Kũ à ↄ pòro lɛ, akũ gbɛ̃ kũ ò natɛnanↄ fùtɛ ò sì wɛ̃tɛn gↄ̃̀nↄ ò sì, akũ ò kɛ̀ likalika ò tɛ́ sↄ̃̀a. ");
INSERT INTO bqp_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Kũ Aidenↄ lìtɛ ò ń kpɛ gwà, akũ ò è túsukpɛ fùtɛ à dà ń wɛ̃tɛla, akũ odi gɛ́ki le doro, zaakũ Isaraila kũ ò bàa lɛ̀ ò mìi pɛ̀ gbárannaanↄ lìtɛ ò arɛ dↄ̀ ń pɛmmarii pìnↄa. ");
INSERT INTO bqp_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Kũ Yↄsua kũ Isarailanↄ è ń gbɛ̃ kũ ò natɛnanↄ wɛ̃tɛ sì akũsↄ̃ ò è túsukpɛ fùtɛ à dà wɛ̃tɛla, akũ ò ɛ̀ra ò lɛ̀tɛ Aide pìnↄa. ");
INSERT INTO bqp_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Isaraila kparanↄ bↄ̀tɛ wɛ̃tɛ pìn ò gɛ̀ɛ Aidenↄi kũ zĩ̀io, akũ ò lìkańyĩ. Ò lɛ̀tɛḿma, akũ ń gbɛ̃ke dí le à bòro, ń gbɛ̃ke dí le à bàa lɛ̀ro. ");
INSERT INTO bqp_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Ama ò Ai kína kũ̀ bɛ̃nɛ ò gɛ̀ɛ kãao Yↄsuanɛ. ");
INSERT INTO bqp_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Isarailanↄ Aidenↄ dɛ̀dɛ míↄmiↄ bura kũ sɛ̃̀ntɛo gu kũ ò ń lén. Kũ ò Aidenↄ dɛ̀dɛ kũ fɛ̃nɛdao lɛ, akũ ò ɛ̀ra ò gɛ̃̀ wɛ̃tɛ pìn, ò gbɛ̃ kũ ò gↄ̃̀ gwenↄ dɛ̀dɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Gbɛ̃ kũ ò gàga zĩ pìianↄ gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ ń pínki gbɛ̃nↄn dúbu kuri awɛɛplamɛ. Aidenↄ lɛ́n gwe. ");
INSERT INTO bqp_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Yↄsua ↄ kũ à sári kũnaoo pìi kpɛ́ dↄna ari ò gɛ̀ɛ ò Aidenↄ dúgu zↄ̃o. ");
INSERT INTO bqp_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Isarailanↄ wɛ̃tɛ pì pↄ́kãdenↄ kũ a pↄ́nↄ nàkↄ̃a ò tào lákũ Dikiri ò Yↄsuanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Lɛn Yↄsua tɛ́ sↄ̃̀ Aia lɛ, à tò à gↄ̃̀ bɛzĩ ũ, akũ à gↄ̃̀ dana kori ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Akũ à Ai kína lòko lía ari ↄkↄsi. Kũ ifãntɛ̃ tɛn gɛ̃ kpɛ́n, à pì ò a gɛ̀ kipa lía ò zu wɛ̃tɛ bĩnilɛa gwe. Akũ ò gbɛ̀ɛ kàkaraa dasidasi, gbɛ̀didikↄ̃anaa pì kú gwe ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Yↄsua Dikiri Isarailanↄ Luda gbagbaki bò Ebala kpi musu ");
INSERT INTO bqp_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","lákũ Dikiri zↄ̀bleri Musa dìtɛ Isarailanↄnɛ nà. À bò lákũ Musa kɛ̃̀ a doka takada gũn nà, à pì ò bo kũ gbɛ̀ kũ odi gã pɛ́tɛa ò àronↄ. Akũ ò sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ ò Dikiria gwe kũ sáabukpana sa'opↄnↄ. ");
INSERT INTO bqp_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Akũ Yↄsua dokayã kũ Musa kɛ̃̀ɛ pìi kɛ̃̀ gbɛ̀ɛ pìnↄa gwe Isarailanↄ wára. ");
INSERT INTO bqp_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Isaraila sĩnda pínki, bedenↄ kũ bòasunↄ kũ ń gbɛ̃ zↄ̃kↄ̃nↄ kũ ń don'arɛdenↄ kũ ń yãkpatɛkɛrinↄn zɛna àkpatii sarɛ ↄplai kũ ↄzɛo. Ń arɛ dↄna Levi buri sa'ori kũ òdigↄ̃ Dikiri bàka kunna kũńwo àkpati sɛnanↄa. Gbɛ̃ kpadonↄ arɛ dↄna Gɛrizimu kpia, gbɛ̃ kpadonↄ sↄ̃ Ebala kpia, lákũ Dikiri zↄ̀bleri Musa gĩnakɛ à dìtɛ nà ò sa mana o Isarailanↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Abire gbɛra Yↄsua dokayã pìnↄ kyó kɛ̀ńnɛ pínki, arubarika kũ Dikiri dì dańgunↄ kũ láari kũ àdi boḿmanↄo lákũ à kú Musa doka takada gũn nà. ");
INSERT INTO bqp_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Yã kũ Musa dìtɛnↄ tɛ́ pínki, a ke dí gↄ̃ kũ Yↄsua gì a kyó kɛi parinɛro. Bee nↄgbɛ̃nↄ kũ nɛ́ fítinↄ kũ bòasu kũ ò kú ń tɛ́nↄn kú gwe ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Buri kũ ò kú Yoda ifãlɛtɛ kpanↄ, sĩ̀sĩdenↄ kũ gusaradenↄ kũ ísiralɛdenↄ ari à gɛ̀ɛ pɛ́ Lɛbana bùsuua, Itinↄ kũ Amↄrinↄ kũ Kanaanↄ kũ Pɛrizinↄ kũ Ivinↄ kũ Yebusinↄo, kũ ń kínanↄ Ai yã pìi baaruu mà, ");
INSERT INTO bqp_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","akũ ò kↄ̃ kàkara ń pínki de ò gɛ́ ò zĩ̀ ká kũ Yↄsuao kũ a gbɛ̃ Isarailanↄ. ");
INSERT INTO bqp_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Kũ Gibiↄ̃denↄ yã kũ Yↄsua kɛ̀ Yɛrikonɛ kũ Aio baaruu mà, ");
INSERT INTO bqp_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","ò ↄ̃ndↄ̃ kpàtɛńyĩ. Ò kusuna kàka asasa zĩkũnanↄ gũn ò dìdi zaakinↄnɛ kũ sèwɛ̃ tùru zĩ parana nabinabinanↄo. ");
INSERT INTO bqp_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Ò kyate nambata nanananↄ kpákpana, ò uta kasanↄ dadana. Ń burodi kusuna korikũna akũsↄ̃ à pukpana. ");
INSERT INTO bqp_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Ò fùtɛ ò gɛ̀ɛ ò Yↄsua lè kũ a gbɛ̃nↄ Giligala bùran, akũ ò pìńnɛ: Bùsu kũ o bon zã̀. Ó ye à lɛ́dokↄ̃nↄ kɛ kũoo. ");
INSERT INTO bqp_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Akũ Isarailanↄ pì Ivi pìnↄnɛ: Tó á bɛ kú la kãnimɛ, óni lɛ́dokↄ̃nↄ kɛ kãáoro yoo! ");
INSERT INTO bqp_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Akũ ò pì Yↄsuanɛ: N zↄ̀blerinↄn ó ũ. Akũ Yↄsua ń lá à pì: Dínↄmɛ á ũu? A bo mámɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Ò wèa ò pì: Ókↄ̃nↄ n zↄ̀blerinↄ, o bo bùsu zã̀zãmmɛ Dikiri n Luda tↄ́ kũ à dàgula yãi. O a baaruu mà kũ yã kũ à kɛ̀ Misilanↄ pínki ");
INSERT INTO bqp_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","kũ yã kũ à kɛ̀ Amↄrinↄ kína gbɛ̃nↄn pla kũ ò kú Yoda bara direnↄnɛ, Ɛsɛbↄ̃ kína Siↄ̃ kũ Basã kína Ogu kũ à kú Asataroo. ");
INSERT INTO bqp_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Ó gbɛ̃ zↄ̃kↄ̃nↄ kũ ó bùsudenↄ pì ò kusuna sɛ́ ò su ò á le, ò piárɛ á zↄ̀blerinↄmɛ ó ũ. Abire yãi à lɛ́dokↄ̃nↄ kɛ kũoo. ");
INSERT INTO bqp_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Ó kusunan dí. O boo bɛ burodi wãna ũmɛ gↄrↄ kũ o da zɛ́n ótɛn su á kĩnaa. À gwa deran à kori kũ̀ nà à pùu kpà. ");
INSERT INTO bqp_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ó wɛ̃ tùrunↄn dí. O wɛ̃ kàn tùru dufu ũmɛ. À gwa deran ò pàrapara nà. À ó utanↄ kũ ó kyatenↄ gwa. Ò yàkayaka tá gbã̀na kũ o ò yãi. ");
INSERT INTO bqp_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Akũ Isarailanↄ ń kusuna blè kũńwo Dikiri lɛ́ sari. ");
INSERT INTO bqp_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Yↄsua lɛ́dokↄ̃nↄ kɛ̀ kũńwo à pì áni ń dɛdɛro, akũ Isaraila don'arɛdenↄ la dà a yã musu. ");
INSERT INTO bqp_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Ń lɛ́dokↄ̃nↄkɛna kũńwoo gbɛra a gↄrↄ aakↄ̃de zĩ, akũ ò mà kũ ń bɛ zã̀ kũńworo, ò kú kↄ̃ sarɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Akũ Isarailanↄ dà zɛ́n, a gↄrↄ aakↄ̃de zĩ ò kà ń wɛ̃tɛnↄ kĩnaa, Gibiↄ̃ kũ Kɛfirao kũ Beroo kũ Kiriayarimuo. ");
INSERT INTO bqp_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Odi lɛ́tɛḿmaro, zaakũ ń don'arɛdenↄ la dàńnɛ kũ Dikiri ń Luda tↄ́omɛ. Gbɛ̃ sĩnda pínki tɛn yãkete ká ń don'arɛdenↄi, ");
INSERT INTO bqp_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","akũ don'arɛde pìnↄ pìńnɛ: Ókↄ̃nↄ mɛ́ o la dàńnɛ kũ Dikiri ó Luda tↄ́o. Adi kũ ò ↄ naḿma doro. ");
INSERT INTO bqp_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Yã kũ óni kɛńnɛn dí. Óni ń tó gwe ladana kũ o kɛ̀ńnɛ yãi, de Dikiri sún pↄ fɛ̃ kũooro. ");
INSERT INTO bqp_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Akũ ò ɛ̀ra ò pì: Ò ń tó, onigↄ̃ de ó yàkawɛrinↄ ũ kũ ó ítↄtↄrinↄ. Akũ Isarailanↄ zɛ̀ kũ ń don'arɛdenↄ yã pìio. ");
INSERT INTO bqp_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Akũ Yↄsua Gibiↄ̃denↄ sìsi à pìńnɛ: Bↄ́yãi a ɛ́kɛ tòwɛrɛ lɛɛ? Ase ó katɛna kↄ̃ gbálamɛ, akũ a pì á kúki zã̀ kũoo yá? ");
INSERT INTO bqp_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Ma Luda láari bòáwa sà. Ánigↄ̃ de a kpɛ́ yàkawɛrinↄ ũ kũ a ítↄtↄrinↄo gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Akũ ò pìnɛ: Ò pì ókↄ̃nↄ n zↄ̀blerinↄnɛ súsu lákũ Dikiri n Luda ò a zↄ̀bleri Musanɛ nà. À pì áni bùsu pì kpááwa pínki à gbɛ̃ kũ ò kunnↄ kakatɛárɛ ń pínki. Abire yãi vĩna ó kũ manamana ó wɛ̃̀ndi yã musu, akũ o yã pìi kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Ó kú n ↄĩmɛ sà. Yã kũ à kɛ̀nnɛ mana akũsↄ̃ à zɛ́ vĩn kɛwɛrɛ. ");
INSERT INTO bqp_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Lɛn Yↄsua kɛ̀ lɛ à ń bó Isarailanↄ ↄĩ, odi ń dɛdɛro. ");
INSERT INTO bqp_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Zĩ birean à ń dítɛ Isarailanↄ yàkawɛrinↄ kũ ń ítↄtↄrinↄ ũ, òdigↄ̃ yàka wɛ òdigↄ̃ í tↄ́tↄ Dikiri gbagbakinɛ gu kũ Dikiri ni ditɛn. Akũ ò kun lɛ ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Yurusalɛmu kína Adonizɛdɛki mà kũ Yↄsua Ai sì à kɛ̀nɛ dúgudugu, à kɛ̀ Ainɛ kũ a kínao lákũ à kɛ̀ Yɛriko kũ a kínaoonɛ nà. À mà dↄ kũ Gibiↄ̃denↄ kↄ̃ yã mà kũ Isarailanↄ akũsↄ̃ ò kú kↄ̃ sarɛ. ");
INSERT INTO bqp_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Akũ vĩna Yurusalɛmudenↄ kũ̀ manamana, zaakũ Gibiↄ̃ bi wɛ́ramɛ lákũ kína wɛ̃tɛ ke bà. A zↄ̃kↄ̃ de Aila akũsↄ̃ a gↄ̃gbɛ̃nↄ bi zĩ̀kari gbãnanↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Akũ Yurusalɛmu kína Adonizɛdɛki lɛ́gbãzã kɛ̀ Ɛblↄnu kína Oamunɛ kũ Yamu kína Piramuo kũ Lakisi kína Yafiao kũ Ɛgɛlↄni kína Dɛbio à pì: ");
INSERT INTO bqp_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","À mↄ́ à kpámai ò gɛ́ lɛ́tɛ Gibiↄ̃denↄa, zaakũ ò kↄ̃ yã mà kũ Yↄsuao kũ Isarailanↄ. ");
INSERT INTO bqp_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Akũ Amↄrinↄ kína gbɛ̃nↄn sↄↄro pìnↄ, Yurusalɛmu kína kũ Ɛblↄnu kínao kũ Yamu kínao kũ Lakisi kínao kũ Ɛgɛlↄni kínao kũ ń zĩ̀karinↄ kↄ̃ kàkara. Ò gɛ̀ɛ ò bùraa kàtɛ Gibiↄ̃ sarɛ, akũ ò gɛ̀ɛńyĩ kũ zĩ̀io. ");
INSERT INTO bqp_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Akũ Gibiↄ̃denↄ gbɛ̃nↄ zĩ̀ Yↄsuaa Giligala bùran ò pì: Ǹsun pã kpá ókↄ̃nↄ n zↄ̀blerinↄiro. Ǹ kɛ likalika ǹ mↄ́ ǹ ó sura ba. Ǹ mↄ́ ǹ kpáwái, zaakũ Amↄrinↄ kína kũ ò kú gusĩsĩdennↄ kↄ̃ kàkarawái ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Akũ Yↄsua kũ a gↄ̃sa gbãnanↄ kũ a zĩ̀karinↄ bↄ̀tɛ Giligala, òtɛn su ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Akũ Dikiri pì Yↄsuanɛ: Ǹsun vĩna kɛńnɛro. Ma ń nánnɛ n ↄĩ, ń gbɛ̃ke ni fↄ̃ à n gã̀ fĩro. ");
INSERT INTO bqp_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Bona Giligala Yↄsua táa ò gwãani ari gu gɛ̀ɛ à dↄ̀o à sùḿma kãnto zɛnaa sari. ");
INSERT INTO bqp_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Akũ Dikiri tò ò kɛ̀ gìri ò lɛ̀kↄ̃a Isarailanↄ arɛ, akũ Isarailanↄ lɛ̀tɛḿma ò ń dɛdɛ manamana Gibiↄ̃ gwe, akũ ò pɛ̀ḿma Bɛtoroni zɛ́n dↄ. Ò ń dɛdɛ ari à gɛ̀ɛ pɛ́ Azeka kũ Makɛdaooa. ");
INSERT INTO bqp_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Kũ òtɛn bàa lɛ́ Isarailanↄnɛ zɛ́ kũ à bò Bɛtoroni kũ à gɛ̀ɛ Azeka gũn, Dikiri legũgbɛ gbɛ̃̀ntɛ̃ɛ sìńgu. Gbɛ̃ kũ legũgbɛɛ pì ń dɛdɛnↄn dasi de gbɛ̃ kũ Isarailanↄ ń dɛdɛ kũ fɛ̃nɛdaonↄla. ");
INSERT INTO bqp_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Gↄrↄ kũ Dikiri Amↄri pìnↄ nà Isarailanↄnɛ ń ↄĩ, akũ Yↄsua yã ò kũ Dikirio Isarailanↄ wára à pì: Ǹ tó ifãntɛ̃ zɛ a gbɛ̀n Gibiↄ̃la! Ǹ tó mↄ zɛ tɛɛnɛ Ayalↄni guvutɛla! ");
INSERT INTO bqp_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Akũ ifãntɛ̃ zɛ̀ a gbɛ̀n lɛ, akũ mↄ zɛ̀ dↄ ari Isarailanↄ gɛ̀ɛ ò fĩnaa bò ń ibɛrɛnↄa. Yã pì kú Yasa takadan. Ifãntɛ̃ gↄ̃̀ zɛna mìdangura, adi go a gbɛ̀nlo ari gↄrↄ do gbãngbãn. ");
INSERT INTO bqp_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Odi gↄrↄ dí taka e zikiro, akũsↄ̃ odi e a gbɛraro. Dikiri bisãsiri yã mà, zaakũ àtɛn zĩ̀ ká Isarailanↄnɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Akũ Yↄsua tà Giligala bùran kũ a gbɛ̃nↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Kũ kína gbɛ̃nↄn sↄↄro pìnↄ bàa lɛ̀, ò gɛ̀ɛ ò ùtɛ gbɛ̀wɛɛn zaa Makɛda, ");
INSERT INTO bqp_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","akũ ò pì Yↄsuanɛ: Ò bò kína gbɛ̃nↄn sↄↄro kũ̀nↄa gbɛ̀wɛɛn zaa Makɛda. ");
INSERT INTO bqp_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Akũ Yↄsua pì: À gbɛ̀ gbɛ̃̀ntɛ̃nↄ yĩpa à ta gbɛ̀wɛɛɛ pìlɛ, à gbɛ̃nↄ ditɛ gwe ògↄ̃ dãkpã. ");
INSERT INTO bqp_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Àsun zɛro. À pɛ́tɛ á ibɛrɛnↄi à lɛ́tɛḿma kpɛ kpa. Àsun tó ò ń wɛ̃tɛnↄ lero, zaakũ Dikiri á Luda ń náárɛ á ↄĩmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Yↄsua kũ a gbɛ̃nↄ ń dɛdɛ ari ò ye ò láka, ń gbɛ̃ kũ ò bònↄ kà ń wɛ̃tɛ bĩnidenↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Akũ Isarailanↄ sù Yↄsuaa bùran Makɛda aafia ń pínki. Gbɛ̃ke dí fↄ̃ à yãke ò Isarailanↄ yã musu doro. ");
INSERT INTO bqp_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Akũ Yↄsua pì: À gbɛ̀ go gbɛ̀wɛɛ pìia à bↄtɛmɛnɛ kũ kína gbɛ̃nↄn sↄↄro pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Akũ ò kɛ̀ lɛ, ò bↄ̀tɛnɛ kũ kína gbɛ̃nↄn sↄↄro pìnↄ, Yurusalɛmu kína kũ Ɛblↄnu kínao kũ Yamu kínao kũ Lakisi kínao kũ Ɛgɛlↄni kínao. ");
INSERT INTO bqp_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Kũ ò ń bↄ́tɛ lɛ, akũ à Isaraila zĩ̀karinↄ sìsi ń pínki à pì ń don'arɛde kũ ò gɛ̀ɛ kãaonↄnɛ: À na kãni à gbá zɛzɛ kína díkĩnanↄ wakaaa. Akũ ò sù ò gbá zɛ̀zɛ ń wakaaa. ");
INSERT INTO bqp_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Yↄsua pìńnɛ: Àsun tó vĩna á kũro, àsun bídi kɛro. À zɛ gbãna àgↄ̃ wↄ́rↄgↄ vĩ, zaakũ lɛn Dikiri ni kɛ lɛ kũ á ibɛrɛ kũ áni zĩ̀ ká kũńwonↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Abire gbɛra Yↄsua ń dɛdɛ à ń lóko lía, baadi kũ a lío, akũ ò gↄ̃̀ lokolokona gwe ari ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Kũ ifãntɛ̃ tɛn gɛ̃ kpɛ́n, à pì ò ń gɛ̀nↄ kipa lí pìnↄa ò ń zu gbɛ̀wɛɛ kũ ò ùtɛn pìn. Akũ ò kɛ̀ lɛ, ò gbɛ̀ gbɛ̃̀ntɛ̃nↄ tàta wɛ̀ɛɛ pìlɛ, à kú gwe ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Zĩ birean Yↄsua Makɛda sì. À a kína kũ a gbɛ̃nↄ dɛ̀dɛ ń pínki kũ fɛ̃nɛdao à ń kákatɛ. Bee gbɛ̃ mɛ̀n do dí boro. Akũ à kɛ̀ Makɛda kínanɛ lákũ à kɛ̀ Yɛriko kínanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Yↄsua kũ Isarailanↄ bↄ̀tɛ Makɛda ń pínki, akũ ò gɛ̀ɛ Libina ò lɛ̀tɛa. ");
INSERT INTO bqp_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Dikiri wɛ̃tɛ pì kũ a kínaoo nàńnɛ ń ↄĩ, akũ ò ń dɛdɛ kũ fɛ̃nɛdao ń pínki, ń gbɛ̃ke dí boro. Akũ ò kɛ̀ a kínanɛ lákũ ò kɛ̀ Yɛriko kínanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Akũ Yↄsua kũ a gbɛ̃nↄ bↄ̀tɛ Libina ò gɛ̀ɛ Lakisi. Ò lìkai ò lɛ̀tɛa. ");
INSERT INTO bqp_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Dikiri Lakisi nàńnɛ ń ↄĩ, a gↄrↄ plade zĩ ò sì. Ò gbɛ̃ kũ ò kunnↄ dɛ̀dɛ kũ fɛ̃nɛdao ń pínki lákũ ò kɛ̀ Libinanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Kũ Gɛza kína Oramu sù à kpá Lakisidenↄi, akũ Yↄsua zĩ̀i blèa kũ a zĩ̀karinↄ, ń gbɛ̃ke dí boro. ");
INSERT INTO bqp_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Ò bò Lakisi, akũ ò gɛ̀ɛ ò lìka Ɛgɛlↄnii ò lɛ̀tɛa. ");
INSERT INTO bqp_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Ò wɛ̃tɛ pìi sì zĩ birea gↄ̃̀nↄ, akũ ò gbɛ̃ kũ ò kunnↄ dɛ̀dɛ kũ fɛ̃nɛdao ò ń kákatɛ lákũ ò kɛ̀ Lakisinɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Kũ ò bↄ̀tɛ Ɛgɛlↄni, akũ ò gɛ̀ɛ Ɛblↄnu ò lɛ̀tɛa. ");
INSERT INTO bqp_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Ò wɛ̃tɛ pìi sì ò a gbɛ̃nↄ kũ a kínao dɛ̀dɛ kũ fɛ̃nɛdao kũ a lakutudenↄo. Ò gbɛ̃ kũ ò kunnↄ kàkatɛ, ń gbɛ̃ke dí boro, lákũ ò kɛ̀ Ɛgɛlↄninɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Akũ ò gɛ̀ɛ Dɛbi ò lɛ̀tɛa. ");
INSERT INTO bqp_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Ò wɛ̃tɛ pìi sì kũ a kínao kũ a lakutunↄ pínki. Akũ ò ń dɛdɛ kũ fɛ̃nɛdao ò gbɛ̃ kũ ò kunnↄ kàkatɛ lákũ ò kɛ̀ Ɛblↄnunɛ nà, ń gbɛ̃ke dí boro. Ò kɛ̀ Dɛbinɛ kũ a kínao lákũ ò kɛ̀ Libinanɛ kũ a kínao nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Yↄsua bùsupidenↄ kũ a kínanↄ dɛ̀dɛ ń pínki, gusĩsĩdenↄ kũ Nɛgɛvidenↄ kũ gusaradenↄ kũ sĩ̀sĩgɛrɛdenↄ ń pínki. Adi gbɛ̃ke tó bɛ̃nɛro, à gbɛ̃ kũ ò kú gwenↄ kàkatɛ lákũ Dikiri Isarailanↄ Luda ònɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","À ń dɛdɛ sɛna zaa Kadɛsi Banɛa ari à gɛ̀ɛ pɛ́ Gazaa, zaa Gosɛ̃ bùsun pínki ari à gɛ̀ɛ pɛ́ Gibiↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Yↄsua zĩ̀i blè kína pìnↄa kũ ń bùsunↄ gɛ̃̀n do gↄ̃̀nↄ, kũ Dikiri Isarailanↄ Luda tɛn zĩ̀ káńnɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Akũ à ɛ̀ra kũ a gbɛ̃nↄ bùran zaa Giligala. ");
INSERT INTO bqp_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Kũ Azo kína Yabĩ a baaruu mà, à gbɛ̃nↄ zĩ̀ Madↄ̃ kína Yobabua kũ Simirↄnu kínao kũ Akasafa kínao ");
INSERT INTO bqp_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","kũ kína kũ ò kú gugbãnduru kpanↄ ń pínki, kína kũ ò kú gukpidenↄ kũ sɛ̃̀ntɛpↄrↄtu kũ à kú Galili gɛ̀nↄmidↄki kpao kũ gusarao kũ Dↄru gusĩsĩde kũ à kú ifãlɛtɛ kpao. ");
INSERT INTO bqp_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Akũ à ɛ̀ra à gbɛ̃nↄ zĩ̀ dↄ Kanaa kũ ò kú ifãboki kpanↄa kũ ifãlɛtɛ kpanↄ ń pínki, Amↄrinↄ kũ Itinↄ kũ Pɛrizinↄ kũ Yebusi kũ ò kú gukpidennↄ kũ Ivi kũ ò kú Mizipa bùsun Ɛmↄ gbɛ̀ sarɛnↄo. ");
INSERT INTO bqp_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Ò bↄ̀tɛ kũ ń zĩ̀karinↄ ń pínki dasidasi lán ísiralɛ bùsu'atɛ̃ bà. Ń sↄ̃nↄ kũ ń sↄ̃gonↄn dasi. ");
INSERT INTO bqp_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Akũ kína pìnↄ kↄ̃ kàkara ò sù ò bùraa kàtɛ lɛɛlɛ Mɛromu ínↄ sarɛ, de ò zĩ̀ ká kũ Isarailanↄ. ");
INSERT INTO bqp_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Akũ Dikiri pì Yↄsuanɛ: Ǹsun vĩna kɛńnɛro. Zia mandara'i mani ń na Isarailanↄnɛ ń ↄĩ ò ń dɛdɛ. Ǹ ń sↄ̃nↄ gbátĩnↄ zↄ̃zↄ̃ ǹ ń sↄ̃gonↄ kpata. ");
INSERT INTO bqp_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Akũ Yↄsua kũ a zĩ̀karinↄ gɛ̀ɛńyĩ kũ zĩ̀io kãnto ń pínki ò dàńla Mɛromu ínↄ sarɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Dikiri ń náńnɛ ń ↄĩ, akũ ò ń dɛdɛ ò pɛ̀ ń gbɛ̃kenↄa ari Sidↄ̃ wɛ́ran kũ Misirefomaimuo kũ Mizipa guvutɛ kũ à kú ifãboki kpao. Ò ń dɛdɛ, ń gbɛ̃ke dí boro. ");
INSERT INTO bqp_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Yↄsua kɛ̀ńnɛ lákũ Dikiri ònɛ nà, à ń sↄ̃nↄ gbátĩnↄ zↄ̃̀zↄ̃ à ń sↄ̃gonↄ kpàta. ");
INSERT INTO bqp_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Zĩ pìia Yↄsua lìtɛ à gɛ̀ɛ à Azo sì, akũ à a kína dɛ̀ kũ fɛ̃nɛdao. Azo pìmɛ kína pìnↄ wɛ̃tɛ mìde ũ gↄrↄ birea. ");
INSERT INTO bqp_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Isarailanↄ gbɛ̃ kũ ò kunnↄ dɛ̀dɛ kũ fɛ̃nɛdao ò ń kákatɛ, ń gbɛ̃ke dí gↄ̃ro, akũ ò tɛ́ sↄ̃̀a. ");
INSERT INTO bqp_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Yↄsua wɛ̃tɛ pìnↄ sì pínki kũ ń kínanↄ, à ń dɛdɛ kũ fɛ̃nɛdao à ń kákatɛ lákũ Dikiri zↄ̀bleri Musa ò nà. ");
INSERT INTO bqp_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Ama Isarailanↄ dí tɛ́ sↄ̃ wɛ̃tɛ kũ ò ɛ̀ra ò kàtɛ ń bɛzĩ gbɛ̀nnↄaro, séde Azo kũ Yↄsua tɛ́ sↄ̃̀aa pìi baasiro. ");
INSERT INTO bqp_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Isarailanↄ wɛ̃tɛ pìnↄ pↄ́nↄ nàkↄ̃a ń pↄ́ ũ kũ ń pↄ́kãdenↄ ò tào. Ò ń gbɛ̃nↄ dɛ̀dɛ kũ fɛ̃nɛdao ń pínki ari ò ń kákatɛ, odi gbɛ̃ke tó bɛ̃nɛro. ");
INSERT INTO bqp_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Yã kũ Dikiri ò a zↄ̀bleri Musanɛ, Musa yã pìi ò Yↄsuanɛ, akũ Yↄsua kɛ̀ lɛ pínki, adi yã kũ Dikiri ò Musanɛ ke tó kpɛro. ");
INSERT INTO bqp_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Lɛn Yↄsua bùsuu pìi sì lɛ pínki, a gukpide kũ Nɛgɛvio pínki kũ Gosɛ̃ bùsuuo pínki kũ gusarao kũ sɛ̃̀ntɛpↄrↄtuo pínki. À Isaraila gukpide kũ gusaraoo sì ");
INSERT INTO bqp_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","sɛna zaa Alaki gbɛ̀ kũ à kú Sei bùsun ari à gɛ̀ɛ pɛ́ Baali Gada kũ à kú Lɛbana bùsu guvutɛn Ɛmↄ gbɛ̀ɛ sarɛ. À ń kínanↄ kũ̀kũ ń pínki à ń dɛdɛ. ");
INSERT INTO bqp_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","À zĩ̀kanaa gìi kɛ̀ kũ kína pìnↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Ivi kũ ò kú Gibiↄ̃nↄ baasiro wɛ̃tɛ ke dí kↄ̃ yã mà kũ Isarailanↄro, ò ń blé kũ zĩ̀io pínki. ");
INSERT INTO bqp_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Dikiri mɛ́ à tò ń sã gbã̀gbã, akũ ò zĩ̀i kà kũ Isarailanↄ, de Isarailanↄ le ò ń kakatɛ ń wɛ̃ndagwanaa sari, à láka kũńwo mámmam lákũ à ò Musanɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Gↄrↄ pìian Yↄsua gɛ̀ɛ à Anakinↄ dɛ̀dɛ gukpiden kũ Ɛblↄnuo kũ Dɛbio kũ Anabuo. À ń kákatɛ à ń wɛ̃tɛnↄ kɛ̀ dúgudugu Yuda gukpiden kũ Isaraila gukpideo pínki. ");
INSERT INTO bqp_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Anaki buri ke dí gↄ̃ Isarailanↄ bùsun doro, séde Gaza kũ Gatao kũ Asadↄdio. ");
INSERT INTO bqp_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Yↄsua bùsuu pìi sì pínki lákũ Dikiri ò Musanɛ nà, akũ à kpà Isarailanↄa à kpàatɛtɛńnɛ danɛdanɛ túbi ũ. Akũ bùsuu pìi gↄ̃̀ katɛna aafia zĩ̀i sari. ");
INSERT INTO bqp_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","À gↄrↄ pla kɛ̀ kũ Dikiri tò Isarailanↄ kámma bò ń ibɛrɛ kũ ò lìkańyĩnↄ yã musu, akũsↄ̃ Yↄsua zĩ kũ̀ yúkuyuku. ");
INSERT INTO bqp_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Akũ à Isarailanↄ sìsi, ń gbɛ̃ zↄ̃kↄ̃nↄ kũ ń mìdenↄ kũ ń yãkpatɛkɛrinↄ kũ ń don'arɛdenↄ ń pínki, à pìńnɛ: Ma zĩ kũ̀ yúkuyuku. ");
INSERT INTO bqp_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Á wɛ́ è yã kũ Dikiri á Luda kɛ̀ buri dínↄnɛ á yãi. Dikiri á Luda mɛ́ à zĩ̀i kàárɛ. ");
INSERT INTO bqp_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Ma buri kũ ò gↄ̃̀ Yoda dagura kũ ifãlɛtɛ kpa ísira zↄ̃kↄ̃ↄonↄ bùsuu kpàatɛ á burinↄnɛ túbi ũ kũ buri kũ ma ń kákatɛnↄ pↄ́o. ");
INSERT INTO bqp_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Dikiri á Luda ni ń yĩpaárɛ ani pɛ́ḿmaárɛ, áni ń bùsunↄ síḿma de àgↄ̃ vĩ lákũ à a lɛ́ sɛ̀árɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","À zɛ gbãna manamana. À laakari kɛ àgↄ̃ zĩ kɛ yã kũ à kú Musa doka takada gũnwa. Àsun pãnɛ ↄplai ke ↄzɛiro. ");
INSERT INTO bqp_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Á bàka súngↄ̃ kú kũ buri kũ ò gↄ̃̀ á tɛ́ pìnↄoro, àsun ń tãnanↄ tↄ́ sísiro, àsun la da kũńworo. Àsun donyĩ à kútɛńnɛro. ");
INSERT INTO bqp_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Àgↄ̃ na Dikiri á Ludai ado lákũ átɛn kɛ nà ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Dikiri buri zↄ̃kↄ̃ gbãnadenↄ yĩ̀paárɛ, gbɛ̃ke dí fↄ̃ à á gã̀ fĩ̀ro ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Á gbɛ̃ mɛ̀n do dì gbɛ̃nↄn wàa sↄↄronↄ fu, kũ Dikiri á Luda tɛn zĩ̀ káárɛ lákũ à a lɛ́ sɛ̀árɛ nà yãi. ");
INSERT INTO bqp_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","À laakari kɛ manamana àgↄ̃ ye Dikiri á Ludai. ");
INSERT INTO bqp_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Tó a kpɛ lìnɛ, akũ a na buri kũ ò gↄ̃̀ á tɛ́ pìnↄa, tó a ń nↄgbɛ̃nↄ sɛ̀ akũsↄ̃ a kakara kũńwo, ");
INSERT INTO bqp_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","àgↄ̃ dↄ̃ sãnsãn kũ Dikiri á Luda ni pɛ́árɛ buri pìnↄa doro. Oni gↄ̃árɛ tankutɛ ke mↄ̀ ũ ke flã̀nↄ ũ á kpɛdagura kesↄ̃ kↄ̀kↄnↄ ũ á wɛ́n ari a gɛ lákao bùsu mana kũ Dikiri á Luda kpàáwa dí gũn. ");
INSERT INTO bqp_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","À gwa! Ma ka gɛna gbɛ̃ sĩnda pínki gɛ́kia tera sà. Á dↄ̃ á nɛ̀sɛn kũ á laasunnwo pínki kũ sa mana kũ Dikiri á Luda òárɛnↄ gũn, bee mɛ̀n do dí kɛ pãro. À pàpa pínki, ń ke dí lɛ́tɛ pãro. ");
INSERT INTO bqp_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","16","Lákũ sa mana kũ Dikiri á Luda òárɛ pàpa a musu nà pínki, tó a Dikiri á Luda bàka kunna kãáo yã kũ à dìtɛárɛ gbòro, a gɛ a do tãnanↄi a kutɛńnɛ, Dikiri ni tó sa vãni kũ à òo pìnↄ pínki á le ari à gɛ́ à á kakatɛo bùsu mana kũ à kpàáwa dín. Dikiri ni pↄfɛ̃ kipaáwa, áni láka gↄ̃̀nↄ bùsu mana kũ à kpàáwa dí pìn. ");
INSERT INTO bqp_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Yↄsua Isaraila burinↄ kàkara Sɛkɛmu. À Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kũ ń mìdenↄ kũ ń yãkpatɛkɛrinↄ kũ ń don'arɛdenↄ sìsi, akũ ò sù ò zɛ̀ Luda arɛ. ");
INSERT INTO bqp_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Akũ Yↄsua pìńnɛ: Yã kũ Dikiri Isarailanↄ Luda òon dí: Á dizinↄ kú Yuflati bara dire yã, ò dò tãnanↄi. Ibrahĩ kũ Naonↄ de Tera kú ń tɛ́. ");
INSERT INTO bqp_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Akũ ma á dizi káaku Ibrahĩ sɛ̀ zaa Yuflati bara dire, ma gɛ̃tɛ kãao Kanaanↄ bùsun pínki, akũ ma tò a buri kↄ̃̀. Ma a gbà Isaaku, ");
INSERT INTO bqp_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","akũ ma Isaaku gbà Yakubu kũ Isauo. Ma Isau gbà Sei gusĩsĩde. Yakubu kũ a nɛ́nↄ sↄ̃ ò tà Misila. ");
INSERT INTO bqp_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Ma Musa kũ Harunaoo zĩ̀, akũ ma wɛ́ tã̀ Misilanↄa kũ yã kũ ma kɛ̀ ń tɛ́nↄ, akũ ma á bↄ́tɛn. ");
INSERT INTO bqp_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Kũ ma á dizinↄ bↄ̀tɛ Misila, kũ a ka ísirai, akũ Misilanↄ pɛ̀tɛái kũ sↄ̃gonↄ kũ sↄ̃denↄ ari Isira Tɛ̃rai. ");
INSERT INTO bqp_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Kũ a ↄ́ↄ dↄ̀mɛnɛ, akũ ma gusira dà á dagura kũ Misila pìnↄ, akũ ma tò ísira dàńla míↄmiↄ. Á wɛ́ yã kũ ma kɛ̀ Misilanↄnɛ è. Abire gbɛra a gↄrↄ pla kɛ̀ gbárannan. ");
INSERT INTO bqp_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Ma su kãáo Amↄri kũ ò kú Yoda ifãboki kpanↄ bùsun. Kũ ò fùtɛái kũ zĩ̀io, akũ ma ń náárɛ á ↄĩ. Ma ń kákatɛ, akũ ń bùsuu gↄ̃̀ á pↄ́ ũ. ");
INSERT INTO bqp_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Kũ Zipo nɛ́ Balaki, Mↄabunↄ kína fùtɛái kũ zĩ̀io, à Bɛↄ nɛ́ Balamu sìsi à láari boáwa. ");
INSERT INTO bqp_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Akũ ma gi Balamu yã mai ma tò à sa mana òárɛ, ma á bó Balaki ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Abire gbɛra a bikũ Yodaa a ka Yɛriko. Akũ Yɛrikodenↄ zĩ̀i kà kãáo. Amↄrinↄ kũ Pɛrizinↄ kũ Kanaanↄ kũ Itinↄ kũ Gigasinↄ kũ Ivinↄ kũ Yebusinↄ zĩ̀i kà kãáo dↄ, akũ ma ń náárɛ á ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Ma zúmantɛ̃nↄ gbàrɛ á arɛ, ò pɛ̀árɛ Amↄrinↄ kína gbɛ̃nↄn planↄa. Adi kɛ á fɛ̃nɛda ke á kà mɛ́ à pɛ̀ḿmaro. ");
INSERT INTO bqp_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Ma zĩtɛ kũ ákↄ̃nↄ mɛ́ a a zĩ kɛ̀ro kpàáwa kũ wɛ̃tɛ kũ ákↄ̃nↄ mɛ́ a kàtɛronↄ, akũ á kú wɛ̃tɛ pìnↄ gũn. Átɛn geepi lí kũ kù lí kũ ákↄ̃nↄ mɛ́ a bàronↄ bɛ ble. ");
INSERT INTO bqp_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Akũ Yↄsua pì: Àgↄ̃ Dikiri vĩna vĩ àgↄ̃ doi yãpura kũ nɛ̀sɛɛo mɛ̀n do. À tãna kũ á dizinↄ dòńyĩ Yuflati bara dire kũ Misilaonↄ bo á tɛ́ à do Dikirii. ");
INSERT INTO bqp_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Tó zↄ̀blena Dikirinɛ dí kɛárɛro, à zɛ kũ tãna kũ á ye à doiio gbãra, tãna kũ á dizinↄ dòńyĩ Yuflati bara direnↄn, Amↄri kũ á kú ń bùsunnↄ pↄ́n yá. Makũ kũ ma bedenↄ sↄ̃, Dikirin ónigↄ̃ doi. ");
INSERT INTO bqp_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Akũ gbɛ̃nↄ wèa ò pì: Gyam! Óni fↄ̃ ò pã kpá Dikirii ò do tãnanↄiro. ");
INSERT INTO bqp_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Dikiri ó Luda mɛ́ à ó bó zↄ̀blen Misila bùsun kũ ó denↄo. Àkũ mɛ́ à daboyã zↄ̃kↄ̃ↄ pìnↄ kɛ̀ ó wára, à ó dãkpã ó táa'onaa gũn pínki à ó bó buri kũ ó gɛ̃tɛ ń gũnnↄ ↄĩ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Dikiri mɛ́ à pɛ̀wɛrɛ Amↄrinↄa kũ buri kũ ò kú bùsu díkĩnannↄo. Abire yãi ónigↄ̃ do Dikirii se, zaakũ àkũmɛ ó Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Akũ Yↄsua pì gbɛ̃nↄnɛ: Áni fↄ̃ à do Dikiriiro. Zaakũ à kú adona, Luda nɛ̀sɛgↄ̃bademɛ. Ani á taarinↄ kũ á durunnanↄ kɛ̃áwaro. ");
INSERT INTO bqp_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Bee kũ à yã mana kɛ̀árɛ yã, tó a pã kpài a do buri zĩ̀tↄnↄ tãnanↄi, ani ɛra à kisira zĩáwa à á kakatɛ. ");
INSERT INTO bqp_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Akũ gbɛ̃nↄ pì Yↄsuanɛ: Lɛnlo! Dikirin ónigↄ̃ doi. ");
INSERT INTO bqp_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Akũ Yↄsua pìńnɛ: Ákↄ̃nↄmɛ á zĩda sèedadenↄ ũ, kũ a zɛo àgↄ̃ do Dikirii. Akũ ò pì: Ee! A sèedadenↄmɛ ó ũ. ");
INSERT INTO bqp_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Akũ Yↄsua pì: Tó lɛmɛ, à buri zĩ̀tↄnↄ tãna kũ ò kú kãáonↄ bo á tɛ́ à á swɛ̃̀ kpá Dikiri Isarailanↄ Ludaa. ");
INSERT INTO bqp_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Akũ gbɛ̃nↄ pìnɛ: Dikiri ó Ludan ónigↄ̃ doi ògↄ̃ a yã ma. ");
INSERT INTO bqp_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Zĩ birean Yↄsua ɛ̀ra à Dikiri bàka kunna kũńwo yã kɛ̀kɛ gbɛ̃nↄnɛ. Zaa Sɛkɛmu gwe à dokayãnↄ kũ yãditɛnanↄ zɛ́ kpàtɛńnɛ, ");
INSERT INTO bqp_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","akũ à yã pìnↄ kɛ̃̀ Luda doka takadan. Akũ à gbɛ̀ gbɛ̃̀ntɛ̃ɛ sɛ̀ à pɛ̀tɛ gbiri lí gbáru Dikiri gbagbakia gwe. ");
INSERT INTO bqp_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Akũ à pì gbɛ̃nↄnɛ: À gwa! Gbɛ̀ díkĩna mɛ́ anigↄ̃ dewɛrɛ sèedade ũ. Gbɛ̀ɛ pì yã kũ Dikiri òwɛrɛ mà pínki. Anigↄ̃ deárɛ sèedade ũ de àsun manafiki kɛ á Ludanɛro. ");
INSERT INTO bqp_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Yↄsua gbɛ̃nↄ gbàrɛ, akũ baadi tà a bùsu kũ ò kpàa túbi ũ gũn. ");
INSERT INTO bqp_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Yã birenↄ gbɛra Dikiri zↄ̀bleri Yↄsua, Nuni nɛ́ gà. À kɛ̀ wɛ̃̀ basↄↄro akuri. ");
INSERT INTO bqp_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ò a vĩ̀ gu kũ à de a túbi ũ gũn Timina Sɛra, Ɛflaimunↄ gukpiden Gaasi kpi gugbãnduru kpa. ");
INSERT INTO bqp_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Isarailanↄ zↄ̀ↄ blè Dikirinɛ Yↄsua gↄrↄa pínki kũ gbɛ̃ zↄ̃kↄ̃ kũ ò kun a gbɛranↄ gↄrↄaao dↄ. Gbɛ̃ zↄ̃kↄ̃ↄ pìnↄ wɛ́ sì yã kũ Dikiri kɛ̀ Isarailanↄnɛlɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Yusufu wánↄ kũ Isarailanↄ bòo Misila sↄ̃, ò vĩ̀ Sɛkɛmu zĩtɛ gũn, kũ Yakubu lù Sɛkɛmu de Amↄ nɛ́nↄa andurufu mɛ̀n basↄↄro. Zĩtɛ pì kú Yusufunↄ túbi gũmmɛ. ");
INSERT INTO bqp_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Kũ Haruna nɛ́ Ɛlɛaza gà, akũ ò a vĩ̀ zaa Gibɛa, wɛ̃tɛ kũ ò kpà a nɛ́ Finɛasia túbi ũ Ɛflaimunↄ gukpiden. ");
INSERT INTO bqp_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Yↄsua ga gbɛra Isarailanↄ Dikiri gbɛ̀ka ò pì: Dínↄ mɛ́ oni gɛ́ zĩ̀ káwɛrɛ kũ Kanaanↄ káakuu? ");
INSERT INTO bqp_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Akũ Dikiri pì: Yudanↄ mɛ́ oni gɛ́. À ma! Ma bùsuu pìi nàńnɛ ń ↄĩmɛ. ");
INSERT INTO bqp_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Akũ Yudanↄ pì ń danɛ Simɛↄnↄnɛ: À mↄ́ à gɛ́ zɛwɛrɛ gu kũ Luda kpàwá túbi ũ gũn, ò zĩ̀ ká kũ Kanaanↄ gbasa ò gɛ́ zɛárɛ gu kũ à kpàáwan. Akũ Simɛↄnↄ gɛ̀ɛ kũńwo. ");
INSERT INTO bqp_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Kũ Yudanↄ gɛ̀ɛ lɛ, Dikiri Kanaanↄ kũ Pɛrizinↄ nàńnɛ ń ↄĩ, akũ ò ń dɛdɛ zaa Bɛzɛki dúbu kuri. ");
INSERT INTO bqp_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","Gwen ò Adonibɛzɛki lèn ò zĩ̀i kà kãao, akũ ò Kanaanↄ kũ Pɛrizi pìnↄ dɛ̀dɛ. ");
INSERT INTO bqp_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","Kũ kína pì tɛn bàa lɛ́, akũ ò pɛ̀a. Ò a kũ̀, akũ ò a ↄnɛmidanↄ kũ a gbánɛmidanↄ zↄ̃̀zↄ̃. ");
INSERT INTO bqp_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Akũ Adonibɛzɛki pì: Ma kína gbɛ̃nↄn baaakↄ̃ akurinↄ ↄnɛmidanↄ kũ ń gbánɛmidanↄ zↄ̃̀zↄ̃, akũ ò pↄ́ble kũ à lɛ̀tɛ ma teburu gɛ̃i kↄ̃nↄ wɛ̀. Lákũ ma kɛ̀ gbɛ̃ pìnↄnɛ nà, a fĩnan Luda bòmɛnɛ. Akũ ò gɛ̀ɛ kãao Yurusalɛmu, gwen à gàn. ");
INSERT INTO bqp_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Kũ Yudanↄ lɛ̀tɛ Yurusalɛmua, ò sì, akũ ò a gbɛ̃nↄ dɛ̀dɛ kũ fɛ̃nɛdao ò tɛ́ sↄ̃̀a. ");
INSERT INTO bqp_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Abire gbɛra Yudanↄ gɛ̀ɛ ò zĩ̀ ká kũ Kanaa kũ ò kú gusĩsĩdennↄ kũ Nɛgɛvio kũ gusarao. ");
INSERT INTO bqp_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Ò gɛ̀ɛ ò lɛ̀tɛ Kanaa kũ ò kú Ɛblↄnunↄa. Ɛblↄnu tↄ́n Kiriataba yã. Gwen ò zĩ̀i blèn Sesai kũ Aimao kũ Talamaiooa. ");
INSERT INTO bqp_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Bona gwe ò gɛ̀ɛ lɛ́tɛ Dɛbidenↄa. Dɛbi tↄ́n Kiriasɛfa yã. ");
INSERT INTO bqp_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Akũ Kalɛbu pì: Gbɛ̃ kũ à lɛ̀tɛ Kiriasɛfa pìia à sìn, mani ma nɛ́nↄgbɛ̃ Akasa kpáa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Kalɛbu dakũna Kenazi nɛ́ Ɔtↄniɛli mɛ́ à sì, akũ Kalɛbu a nɛ́nↄgbɛ̃ pìi kpàa. ");
INSERT INTO bqp_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Kũ à a sɛ̀, akũ à nàkaraa à gɛ́ zĩtɛ wɛ́ kɛ a dea. Kũ nↄgbɛ̃ pìi kìpa a zaakia, akũ Kalɛbu a là à pì: Bↄ́n ń yeii? ");
INSERT INTO bqp_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Akũ à wèa à pì: Ǹ gbɛ̃kɛ kɛmɛnɛ. Zaakũ gu kũ n ma gba kú Nɛgɛvi gbárannan, ǹ ma gba a ísɛ̃bokide dↄ. Akũ Kalɛbu a gbà gu kũ a ísɛ̃boki kú sĩ̀sĩi musu kũ gu kũ a ísɛ̃boki kú guvutɛ gũnwo. ");
INSERT INTO bqp_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Musa anzure buri kũ òdi pi Keninↄ bò wɛ̃tɛ dominaliden kũ Yudanↄ, ò gɛ̀ɛ ò vùtɛ kũńwo ń bùsun Aradi sarɛ Nɛgɛvi gbárannan. ");
INSERT INTO bqp_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Akũ Yudanↄ kũ ń danɛ Simɛↄnↄ gɛ̀ɛ ò lɛ̀tɛ Kanaa kũ ò kú Zɛfanↄa. Ò wɛ̃tɛ pìi kàkatɛ mámmam, akũ ò tↄ́ kpànɛ Ɔↄma. ");
INSERT INTO bqp_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Yudanↄ Gaza kũ Asakɛlↄnio kũ Ɛkɛrↄnuo kũ ń gunↄ sì. ");
INSERT INTO bqp_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Dikiri kú kũńwo, akũ ò ń gukpide sì, ama odi fↄ̃ ò pɛ̀ gusaradenↄaro, kũ gbɛ̃ pìnↄn sↄ̃go mↄ̀pↄnↄ vĩ yãi. ");
INSERT INTO bqp_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Ò Ɛblↄnu kpà Kalɛbua lákũ Musa a lɛ́ sɛ̀ nà, akũ à pɛ̀ Anaki buri gbɛ̃nↄn aakↄ̃nↄa gwe. ");
INSERT INTO bqp_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Biliaminunↄ sↄ̃ odi pɛ́ Yebusi kũ ò kú Yurusalɛmunↄaro, akũ Yebusinↄn kú kũńwo Yurusalɛmu ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Yusufunↄ sↄ̃ ò lɛ̀tɛ Bɛtɛlia akũsↄ̃ Dikiri kú kũńwo. ");
INSERT INTO bqp_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Bɛtɛli tↄ́n Luzu yã. Kũ ò gbɛ̃nↄ zĩ̀ Bɛtɛli asiri gwa, ");
INSERT INTO bqp_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","gu'asirigwarii pìnↄ gↄ̃gbɛ̃ ke è àtɛn bo wɛ̃tɛ pìn, akũ ò pìnɛ: Ǹ owɛrɛ deran óni kɛ nà ò gɛ̃ wɛ̃tɛ gũn óni gbɛ̃kɛ kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Kũ à zɛ́ mↄ̀ńnɛ, akũ ò wɛ̃tɛpidenↄ dɛ̀dɛ kũ fɛ̃nɛdao, akũ ò gↄ̃gbɛ̃ pìi tò kũ a danɛnↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Gↄ̃gbɛ̃ pìi gɛ̀ɛ Iti bùsun à wɛ̃tɛ kàtɛ gwe, akũ à tↄ́ kpànɛ Luzu. Tↄ́ bire mɛ́ à gↄ̃̀nɛ ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Manasenↄ dí pɛ́ Kanaa kũ ò kú Bɛtɛsã kũ Tanakio kũ Dↄruo kũ Ibleamuo kũ Mɛgidoo kũ ń lakutunↄaro, zaakũ ò gì ò kpɛ́ vutɛ bùsuu pìmmɛ. ");
INSERT INTO bqp_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Kũ Isarailanↄ gbãna lè, akũ ò Kanaanↄ dà zↄ̀zĩn, odi pɛ́ḿma ń pínkiro. ");
INSERT INTO bqp_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Lɛmɛ se Ɛflaimunↄ dí pɛ́ Kanaa kũ ò kú Gɛzanↄaro, akũ ò kú gwe lɛɛlɛ. ");
INSERT INTO bqp_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Lɛmɛ dↄ Zɛbuluninↄ dí pɛ́ Kanaa kũ ò kú Kitironu kũ Naloluonↄaro, akũ ò ń dá zↄ̀zĩn. ");
INSERT INTO bqp_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Lɛmɛ dↄ Asanↄ dí pɛ́ gbɛ̃ kũ ò kú Ako kũ Sidↄ̃o kũ Alabuo kũ Akazibuo kũ Ɛlɛbao kũ Afɛkio kũ Reobuooaro, ");
INSERT INTO bqp_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","akũ ò vùtɛ lɛɛlɛ kũ Kanaanↄ bùsude pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Lɛmɛ dↄ Nafatalinↄ dí pɛ́ Bɛsɛmɛsidenↄ kũ Bɛtanadenↄaro, akũ ò vùtɛ lɛɛlɛ kũ Kanaanↄ bùsude pìnↄ ò ń dá zↄ̀zĩn. ");
INSERT INTO bqp_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Amↄrinↄ Dãnↄ yĩ̀pa ò ń kpá gukpiden, odi weńnɛ ò su vutɛ gusaranlo. ");
INSERT INTO bqp_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Amↄri pìnↄ gì ò kpɛ́ vutɛ Ɛrɛsi kpia kũ Ayalↄnio kũ Salabimuo. Kũ Yusufunↄ gbãna kàra, akũ ò ń dá zↄ̀zĩn. ");
INSERT INTO bqp_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Amↄrinↄ bùsu lɛ́zɛki nàa zaa Fí Gbɛ̀kpakotozɛn ari à gɛ̀ɛ pɛ́ Selaa ari à gɛ̀ɛo arɛ kpa. ");
INSERT INTO bqp_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Dikiri Malaikaa bò Giligala à gɛ̀ɛ Bokimu à pì: Ma á bↄ́tɛ Misila, ma gɛ̃ kãáo bùsu kũ ma la dà á dizinↄnɛ dí gũn. Ma pì mani ma bàka kunna kãáo yã gboro zikiro. ");
INSERT INTO bqp_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Ma òárɛ á yã sún kakara kũ bùsu dí denↄoro. Ma òárɛ à ń sa'okinↄ gboro, akũ ádi ma yã maro. À kɛ̀ dera a kɛ̀ lɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Tↄ̀! Matɛn oárɛ, mani pɛ́ḿmaárɛ doro. Onigↄ̃ deárɛ lɛ̀ ũ á gbã̀ntɛrɛɛa akũsↄ̃ ń tãnanↄ nigↄ̃ deárɛ tankutɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Kũ Dikiri Malaika yã pìi ò Isarailanↄnɛ, ò ↄ́ↄ dↄ̀ gbãnagbãna. ");
INSERT INTO bqp_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Akũ ò tↄ́ kpà gu pìinɛ Bokimu, akũ ò sa ò Dikiria gwe. ");
INSERT INTO bqp_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Yↄsua gbɛ̃nↄ gbarɛna gbɛra baadi gɛ̀ɛ à gu kũ ò kpàa túbi ũ kũ̀. ");
INSERT INTO bqp_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Ò dò Dikirii Yↄsua gↄrↄa pínki kũ gbɛ̃ zↄ̃kↄ̃ kũ ò kun a gbɛranↄ gↄrↄo dↄ. Gbɛ̃ zↄ̃kↄ̃ↄ pìnↄ wɛ́ sì yã zↄ̃kↄ̃ kũ Dikiri kɛ̀ Isarailanↄnɛlɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Kũ Dikiri zↄ̀bleri Nuni nɛ́ Yↄsua kɛ̀ wɛ̃̀ basↄↄro akuri, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Ò a vĩ̀ gu kũ à de a túbi ũ gũn zaa Timina Ɛrɛsi, Ɛflaimunↄ gukpiden, Gaasi kpi gugbãnduru kpa. ");
INSERT INTO bqp_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Kũ Yↄsua gↄrↄ gbɛ̃nↄ gàga ń pínki, nɛ́ kũ ò fùtɛ ń gbɛranↄ Dikiri dↄ̃ro, akũsↄ̃ ò yã kũ à kɛ̀ ń dizinↄnɛ dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Akũ ò yã kũ à vãni Dikirinɛɛ kɛ̀ ò dò tãnanↄi. ");
INSERT INTO bqp_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Ò pã kpà Dikiri ń dizinↄ Luda kũ à ń bↄ́tɛ Misilai, ò tɛ̀ buri kũ ò likańyĩnↄ tãnanↄi ò donyĩ kɛ̀ńnɛ, akũ ò Dikiri pↄ fɛ̃̀. ");
INSERT INTO bqp_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Ò pã kpài ò dò Baalii kũ Asatorɛo. ");
INSERT INTO bqp_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Akũ Dikiri pↄ fɛ̃̀ńyĩ à ń ná ń wɛ́tãmmarinↄnɛ ń ↄĩ ò ń wára. À ń kpá ń ibɛrɛ kũ ò likańyĩnↄa, akũ odi fↄ̃ ò gì kũ ń zĩdao ń ibɛrɛɛ pìnↄ ↄĩro. ");
INSERT INTO bqp_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Gↄrↄ kũ ò gɛ̀ɛ zĩ̀ ká pínki, Dikiri dì bo ń kpɛ de yã sún bo kũńwo nnaro yãi, lákũ à dàńnɛ ń sãn nà, akũ ò gↄ̃̀ wɛ́tãmma zↄ̃kↄ̃ↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Akũ Dikiri yãgↄ̃gↄ̃rinↄ bòbo ń tɛ́ de ò ń sí ń wɛ́tãmmarinↄa. ");
INSERT INTO bqp_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Ama òdi ń yãgↄ̃gↄ̃rii pìnↄ yã maro, ò pãpã kɛ̀ ò donyĩ kɛ̀ tãnanↄnɛ. Ò kɛ̃̀ zɛ́ kũ ń dizinↄ sɛ̀ɛa likalika, òdigↄ̃ yã kũ Dikiri dìtɛńnɛnↄ kũna lán ń dizi pìnↄ bàro. ");
INSERT INTO bqp_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Tó Dikiri yãgↄ̃gↄ̃rii bò ń tɛ́, àdigↄ̃ kú kũ yãgↄ̃gↄ̃rii pìio, akũ àdigↄ̃ ń sí ń ibɛrɛnↄ ↄĩ ari yãgↄ̃gↄ̃rii pìi wɛ̃̀ndi lɛ́n, zaakũ tó ò ǹ dà gbɛ̃ kũ òtɛn ↄ tↄ̃ḿma òtɛn wari dↄḿmanↄ yãi, Dikiri dì ń wɛ̃nda gwamɛ. ");
INSERT INTO bqp_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Tó yãgↄ̃gↄ̃rii gà sↄ̃, òdi ɛra ò yaka de ń denↄla. Òdi do tãnanↄi, òdi ń gbagba, òdi donyĩ kɛńnɛ. Òdi ń yãvãnikɛnaa pìnↄ kũ ń sãgbãnao tóro. ");
INSERT INTO bqp_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Akũ Dikiri pↄ fɛ̃̀ńyĩ à pì: Zaakũ buri dí ma bàka kunna kũ ń dizinↄ yã gbòro odi ma yã maro, ");
INSERT INTO bqp_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","mani pɛ́ńnɛ buri kũ Yↄsua gà à ń tó ń bùsunnↄ kea doro. ");
INSERT INTO bqp_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Mani ń suu kɛ Isarailanↄa de mà ń yↄ̃ mà gwa, tó oni ma zɛ́ sɛ́ ògↄ̃ ma yã kũna lákũ ń dizinↄ kũ̀ nà, ke tó oni kɛ lɛro. ");
INSERT INTO bqp_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Abire yãin Dikiri buri pìnↄ tò gwe. Adi ń na Yↄsuanɛ a ↄĩ à pɛ̀ḿma gↄ̃̀nↄro. ");
INSERT INTO bqp_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Dikiri buri pìnↄ tò gwe de à Isaraila kũ odi Kanaanↄ bùsu zĩ̀ ká ń wáraronↄ yↄ̃ à gwao ");
INSERT INTO bqp_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","de dↄ à zĩ̀kana dada gbɛ̃ kũ ò zĩ̀kana dↄ̃ yãro pìnↄnɛ. Buri pìnↄn dí: ");
INSERT INTO bqp_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Filisitini kína gbɛ̃nↄn sↄↄronↄ kũ Kanaanↄ pínki kũ Sidↄ̃denↄ kũ Ivi kũ ò kú Lɛbana gukpidennↄ zaa Baali Ɛmↄ kpia ari à gɛ̀ɛ pɛ́ Lebo Amata. ");
INSERT INTO bqp_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","À ń tó de à Isarailanↄ yↄ̃ à gwao, tó onigↄ̃ yã kũ à dìtɛ ń dizinↄnɛ Musa gãinↄ kũna. ");
INSERT INTO bqp_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Abire yãin Isarailanↄ vùtɛ Kanaanↄ tɛ́ kũ Itinↄ kũ Amↄrinↄ kũ Pɛrizinↄ kũ Ivinↄ kũ Yebusinↄo. ");
INSERT INTO bqp_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Ò ń nɛ́nↄgbɛ̃nↄ sɛ̀ nↄ ũ akũsↄ̃ ò ń nɛ́nↄgbɛ̃nↄ kpã̀zã buri pìnↄ nɛ́gↄ̃gbɛ̃nↄa, akũ ò dò ń tãnanↄi. ");
INSERT INTO bqp_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Isarailanↄ yã kũ Dikiri yeiro kɛ̀. Dikiri ń Luda yã sã̀ńgu, akũ ò dò Baalii kũ Asatorɛo. ");
INSERT INTO bqp_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Akũ Dikiri pↄ fɛ̃̀ńyĩ à ń yía Mɛsↄpↄtamia bùsu kína Kusãrisataimua, akũ ò zↄ̀ↄ blènɛ ari wɛ̃̀ sↄraakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Kũ ò ↄ́ↄ dↄ̀ Dikirinɛ, akũ à surabarii bòńnɛ, àkũmɛ Kalɛbu dakũna Kenazi nɛ́ Ɔtↄniɛli ũ. Àkũ mɛ́ à ń bó. ");
INSERT INTO bqp_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Dikiri Nini sùa, akũ à yã gↄ̃̀gↄ̃ Isarailanↄnɛ à dòńnɛ arɛ zĩ̀i gũn. Dikiri Mɛsↄpↄtamia bùsu kína Kusãrisataimu nànɛ a ↄĩ, akũ à gbãna mↄ̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Akũ ń bùsuu gↄ̃̀ katɛna aafia wɛ̃̀ bupla ari Kenazi nɛ́ Ɔtↄniɛli gɛ̀ɛ à gào. ");
INSERT INTO bqp_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Isarailanↄ ɛ̀ra ò yã kũ Dikiri yeiro kɛ̀ dↄ, akũ Dikiri tò Mↄabu kína Ɛgɛlↄni gbãna mↄ̀ńnɛ yã vãni kũ ò kɛ̀ɛ pì yãi. ");
INSERT INTO bqp_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Ɛgɛlↄni Amↄninↄ kũ Amalɛkinↄ nàawa, akũ ò sù ò lɛ̀tɛ Isarailanↄa ò wɛ̃tɛ dominalide sì. ");
INSERT INTO bqp_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Isarailanↄ zↄ̀ↄ blè Mↄabu kína Ɛgɛlↄninɛ ari wɛ̃̀ baro plansari. ");
INSERT INTO bqp_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Akũ ò ↄ́ↄ dↄ̀ Dikirinɛ, akũ à surabarii bòńnɛ, àkũmɛ Gera nɛ́ Ɛudu, Biliaminu buri ũ. Ɔzɛdemɛ. Isarailanↄ a zĩ̀ táfe bo Mↄabu kína Ɛgɛlↄninɛ. ");
INSERT INTO bqp_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Ɛudu fɛ̃nɛ lɛ́kpaplade pì a gbã̀na kà gã̀sãkuru do. À nà a gbáda ↄplaa a uta zĩtɛ, ");
INSERT INTO bqp_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","akũ à gɛ̀ɛ à táfe bò Ɛgɛlↄninɛ. Ɛgɛlↄni sↄ̃ bi gbɛ̃ mɛ̀demɛ manamana. ");
INSERT INTO bqp_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Kũ Ɛudu kũ gbɛ̃ kũ ò táfe sɛ̀ ò gɛ̀ɛonↄ táfe bònɛ ò làka, akũ Ɛudu a gbɛ̃ pìnↄ gbàrɛ zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Akũ à ɛ̀ra tãna kũ à kú Giligala sarɛ à sù kína pì kĩnaa dↄ à pì: Má asiriyã vĩ mà onnɛ. Akũ kína pìi pì: À tó mà yã ma, akũ a ìba kũ ò kú kãaonↄ bↄ̀tɛ. ");
INSERT INTO bqp_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Ɛgɛlↄni vutɛna ado kpɛ́ musu ĩampakia, akũ Ɛudu nài à pì: Má yã kũ à bò Luda kĩnaa vĩ mà onnɛ. Kũ kína pìi fùtɛ a gbàaa, ");
INSERT INTO bqp_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","akũ Ɛudu a fɛ̃nɛ gà à wòto a ↄpla gbádaa kũ ↄzɛo, akũ à a zↄ̃̀o a gbɛrɛa. ");
INSERT INTO bqp_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","Akũ fɛ̃nɛ pìi gɛ̃̀ a gbɛrɛn kũ a páo pínki ari à bò a kpɛ. Ɛudu dí fɛ̃nɛ pì wotoro ari a gbɛrɛ nísi dàala. ");
INSERT INTO bqp_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Ɛudu bò kpɛ́lɛlɛa à kpɛ́ ĩampaki pì zɛ́ tàta à mↄ̀da kã̀. ");
INSERT INTO bqp_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","A bona gbɛra Ɛgɛlↄni zĩ̀rinↄ sù ò è ĩampaki pì zɛ́ tatana ò kã̀, akũ ò pì: Ke àtɛn bĩnikpɛ kɛ kpɛ́ ĩampakian yá? ");
INSERT INTO bqp_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Òtɛni a dã ari ò bídi kɛ̀. Kũ ò è adi zɛ́ wɛ̃ńnɛro, akũ ò mↄ̀nɛ sɛ̀ ò wɛ̃̀ ò gɛ̃̀ ò ń dikiri è wutɛna zĩtɛ gɛ̀ ũ. ");
INSERT INTO bqp_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Gↄrↄ kũ òtɛn kína dã lɛ, Ɛudu bàa lɛ̀ à dò tãna pìnↄi à tà Seira. ");
INSERT INTO bqp_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Kũ à kà gwe, à tò ò kuru pɛ̀ Ɛflaimu gukpiden, akũ Isarailanↄ kìpa kãao kpinↄa, Ɛudu dòńnɛ arɛ. ");
INSERT INTO bqp_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","À pìńnɛ: À tɛ́mai, zaakũ Dikiri á ibɛrɛ Mↄabunↄ nàárɛ á ↄĩ. Ò tɛ̀i, akũ ò Yoda bikũki kũ àdi gɛ́ Mↄabunↄ bùsun sì, odi we gbɛ̃ke bikũ doro. ");
INSERT INTO bqp_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Zĩ birea ò Mↄabu gↄ̃ gbãnanↄ dɛ̀dɛ dúbu kuri taka bà, ń gbɛ̃ke dí boro. ");
INSERT INTO bqp_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Zĩ kũ̀a Isarailanↄ gbãna mↄ̀ Mↄabunↄnɛ, akũ ń bùsuu gↄ̃̀ katɛna aafia ari wɛ̃̀ basiikↄ̃. ");
INSERT INTO bqp_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Ɛudu gbɛra Anata nɛ́ Samaga Filisitininↄ dɛ̀dɛ gbɛ̃nↄn wàa aakↄ̃ kũ zùdãgooo. À Isarailanↄ sura bà se. ");
INSERT INTO bqp_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Kũ Ɛudu gà, Isarailanↄ ɛ̀ra ò yã kũ Dikiri yeiro kɛ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Akũ Dikiri ń yía Kanaa kína Yabĩ kũ à vutɛna Azoa. A zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ tↄ́n Sisera. A bɛn Arose Goyimu. ");
INSERT INTO bqp_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","À sↄ̃go mↄ̀pↄnↄ vĩ mɛ̀n wàa siikↄ̃ kũ basↄↄroo. À gbãna mↄ̀ Isarailanↄnɛ pãsĩpãsĩ ari wɛ̃̀ baro, akũ Isarailanↄ ↄ́ↄ dↄ̀ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Gↄrↄ birea nↄgbɛ̃ annabi kũ òdi pinɛ Debora, Lapido nanↄ de Isarailanↄ yãgↄ̃gↄ̃ri ũ. ");
INSERT INTO bqp_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Àdi yã gↄ̃gↄ̃ńnɛ a domina lí gbáru Rama kũ Bɛtɛlio dagura Ɛflaimunↄ gukpiden. Isarailanↄ dìgↄ̃ gɛ́ a kĩnaa gwe. ");
INSERT INTO bqp_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Akũ à Abinↄamu nɛ́ Baraki kũ à kú Kɛdɛsi, Nafatalinↄ bùsun sìsi à pìnɛ: Dikiri Isarailanↄ Luda pì ǹ futɛ ǹ gɛ́ Nafatalinↄ kũ Zɛbuluninↄ sɛ́ gbɛ̃nↄn dúbu kuri ǹ gɛ́ kũńwo Tabo kpia. ");
INSERT INTO bqp_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Dikiri ni Yabĩ zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Sisera gátɛ à su kãao Kisↄ̃ swai kũ a sↄ̃gonↄ kũ a zĩ̀karinↄ dasidasi, gwen ani a nannɛ n ↄĩn. ");
INSERT INTO bqp_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Akũ Baraki pìnɛ: Tó ĩni gɛ́ kũmao dé, mani gɛ́. Tó ĩni gɛ́ kũmao sↄ̃ro, mani gɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Akũ Debora pì: Mani gɛ́ kũnwo, ama kũ n ò lɛ, adi kɛ n tↄ́ mɛ́ ani boro. Nↄgbɛ̃n Dikiri ni Sisera nanɛ a ↄĩ sà. Akũ Debora fùtɛ à gɛ̀ɛ kãao Kɛdɛsi. ");
INSERT INTO bqp_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Akũ Baraki Zɛbuluninↄ kũ Nafatalinↄ kàkara Kɛdɛsi, akũ à dà zɛ́n gɛ̀sɛ kũ gbɛ̃nↄn dúbu kurii pìnↄ. Debora kú ń tɛ́. ");
INSERT INTO bqp_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Keni buri Eberu bò Keninↄ bùsun yã, à sù à bùraa kàtɛ gbiri lí kũ à kú Zananimu gbáru Kɛdɛsi sarɛ. Keninↄ bi Musa anzure Obabu burinↄ domɛ. ");
INSERT INTO bqp_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Ò pì Siseranɛ Abinↄamu nɛ́ Baraki gɛ̀ɛ Tabo kpia, ");
INSERT INTO bqp_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","akũ à a sↄ̃go mↄ̀pↄnↄ kàkara mɛ̀n wàa siikↄ̃ kũ basↄↄroo kũ zĩ̀kari kũ ò kú kãaonↄ. Bona zaa Arose Goyimu, ò gɛ̀ɛ Kisↄ̃ swai. ");
INSERT INTO bqp_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Akũ Debora pì Barakinɛ: Ǹ gɛ́, zaakũ gbãran Dikiri ni Sisera nannɛ n ↄĩ. À de Dikiri dònnɛ arɛ kↄ̀ fá. Akũ Baraki kìpa Tabo kpia kũ zĩ̀kari gbɛ̃nↄn dúbu kurii pìnↄ. ");
INSERT INTO bqp_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Dikiri tò Sisera kũ a sↄ̃gonↄ kũ a zĩ̀karinↄ fã̀kↄ̃a Baraki fɛ̃nɛdanɛ, akũ Sisera bò a sↄ̃gon à bàa lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Baraki pɛ̀tɛ Sisera zĩ̀karinↄ kũ ń sↄ̃gonↄi ari Arose Goyimu. Gwen à ń dɛdɛn kũ fɛ̃nɛdao ń pínki, bee gbɛ̃ mɛ̀n do adi gↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Akũ Sisera bàa lɛ̀ gɛ̀sɛ à gɛ̀ɛ Keni buri Eberu nanↄ Yaɛli kuta kĩnaa, zaakũ Azo kína Yabĩ kũ Eberu bedenↄ kↄ̃ yã mà yã. ");
INSERT INTO bqp_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Yaɛli bò à dàalɛ à pì: Ǹ mↄ́ ǹ gɛ̃ kpɛ́n, Baa. Ǹ gɛ̃! Ǹsun tó vĩna n kũro. Kũ à gɛ̃̀, akũ nↄgbɛ̃ pìi bↄrↄgↄ dàala, ");
INSERT INTO bqp_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","akũ Sisera pìnɛ: Ími tɛni ma dɛ. Ǹ ma gba í mà mi. Akũ à vĩ tùruu sɛ̀ à dã̀nɛ à mì, akũ à ɛ̀ra à bↄrↄgↄ dàala. ");
INSERT INTO bqp_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Sisera pìnɛ: Ǹ zɛ kpɛ́lɛlɛa. Tó gbɛ̃ke sù à n la à pi, gbɛ̃ke kú la yá, ǹ pinɛ, oi. ");
INSERT INTO bqp_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Kpasa'i a sɛ̀, a gbãna làka, akũ Eberu nanↄ Yaɛli kuta káro sɛ̀ kũ éreo à nào Siserai tɛɛnɛ, akũ à káro pìi pɛ̀ a mì'arɛ kpadoa à pà ari à gɛ̃̀ à gɛ̀ɛ à zĩtɛ kũ̀, akũ à gà. ");
INSERT INTO bqp_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Baraki sↄ̃ àtɛn pɛ́tɛ Siserai, akũ Yaɛli bò à gɛ̀ɛ à dàalɛ à pì: Ǹ mↄ́ mà gbɛ̃ kũ ntɛni wɛtɛ mↄnnɛ. Kũ à gɛ̃̀ kpɛ́n, akũ à Sisera è wutɛna, à gà kũ károo pɛna a mì'arɛ kpadoa. ");
INSERT INTO bqp_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Zĩ birea Luda Kanaa kína Yabĩ bùsa Isarailanↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Akũ Isarailanↄ pãsĩkɛ tɛn kara ari ò gɛ̀ɛ ò Kanaa kína Yabĩ dɛ̀o. Akũ ń bùsuu gↄ̃̀ a laakariia ari wɛ̃̀ bupla. ");
INSERT INTO bqp_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Isarailanↄ ɛ̀ra ò yã kũ Dikiri yeiro kɛ̀ dↄ, akũ Dikiri ń ná Midiãnↄnɛ ń ↄĩ ari wɛ̃̀ suppla. ");
INSERT INTO bqp_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Kũ Midiãnↄ tɛn ↄ tↄ̃ḿma, akũ Isarailanↄ utɛkinↄ kɛ̀kɛ gukpidenↄn kũ gbɛ̀wɛɛnↄ kũ sɛ̃̀ntɛpↄrↄtuo. ");
INSERT INTO bqp_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Tó ò pↄ́ tↄ̃̀, Midiãnↄ kũ Amalɛkinↄ kũ ifãboki kpa buri pãndenↄ dì su ò lɛ́tɛḿmamɛ. ");
INSERT INTO bqp_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Òdi su ò bùra kátɛ ń bùsun, akũ òdi ń burapↄnↄ yakańnɛ ari à gɛ́ pɛ́o Gazaa. Òdi pↄ́ke tó Isarailanↄnɛro ke sã ke zù ke zaaki. ");
INSERT INTO bqp_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Òdi su kũ ń pↄ́kãdenↄ kũ ń bizakutanↄ dasidasi lán sutɛ̃nↄ bà. Gbɛ̃ke dìgↄ̃ mↄ́kↄ̃nↄ kũ ń lakuminↄ lɛ́ dↄ̃ro. Òdi su ò bùsuu yakamɛ. ");
INSERT INTO bqp_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Midiãnↄ Isarailanↄ dà takasi gũn, akũ ò wiki lɛ̀ Dikiria. ");
INSERT INTO bqp_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Kũ ò wiki lɛ̀ Dikiria Midiãnↄ yã musu lɛ, ");
INSERT INTO bqp_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","akũ Dikiri annabii bòńnɛ à pì: Makũ Dikiri Isarailanↄ Luda ma pì ma á bó zↄ̀blen ma á bↄ́tɛ Misila. ");
INSERT INTO bqp_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Ma á bó Misilanↄ ↄĩ kũ gbɛ̃ kũ ò ↄ tↄ̃̀áwanↄ ń pínki ma pɛ́ḿmaárɛ, akũ ma ń bùsuu kpàáwa. ");
INSERT INTO bqp_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Kũ ma pìárɛ makũmɛ Dikiri á Luda ũ, àsun Amↄri kũ á kú ń bùsunnↄ tãnanↄ gbagbaro, akũ a gi ma yã mai. ");
INSERT INTO bqp_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Dikiri Malaikaa sù à vùtɛ gbiri lí gbáru zaa Ɔfla, Abiɛza buri Yoasi bɛ wɛ̃tɛ. A nɛ́ Gidiↄn tɛn pↄ́wɛ gbɛ̃ geepi'ifɛ̃ki wɛ̀ɛn de Midiãnↄ sún a ero yãi. ");
INSERT INTO bqp_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Kũ Dikiri Malaikaa bò à sùa, à pìnɛ: Gↄ̃ gbãna, Dikiri kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Akũ Gidiↄn pìnɛ: Baa, tó Dikiri kú kũoo, bↄ́yãi yã dínↄ ó lé pínkii? Daboyã kũ ó denↄ a yã bàbawɛrɛnↄn kú mámɛɛ? Ò pì Dikiri ó bↄ́tɛ Misila, ama tera à pã kpàwái, akũ à ó ná Midiãnↄnɛ ń ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Akũ Dikiri arɛ dↄ̀a à pì: Ǹ gɛ́ kũ gbãna kũ ń vĩo ǹ Isarailanↄ bo Midiãnↄ ↄĩ. À de makũ mɛ́ ma n zĩ fá. ");
INSERT INTO bqp_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Akũ Gidiↄn a là à pì: Baa, mani fↄ̃ mà Isarailanↄ bo deramɛɛ? Ma ↄn mɛ́ à kĩana Manasenↄ tɛ́ akũsↄ̃ makũmɛ fíti deńla ma de bedenↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Dikiri wèa à pì: Manigↄ̃ kú kũnwo, ĩni Midiãnↄ nɛ lán gbɛ̃ mɛ̀n do bà. ");
INSERT INTO bqp_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Akũ Gidiↄn pìnɛ: Tó ma n pↄnna lè, ǹ sèeda mↄmɛnɛ de màgↄ̃ dↄ̃ kũ mↄkↄ̃n mɛ́ ntɛn yã o kũmao. ");
INSERT INTO bqp_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Ǹsun go laro ari mà su. Mani sunnɛ kũ gbao mà ditɛnnɛ. Akũ à wèa à pì: Manigↄ̃ kú la ari ǹ su. ");
INSERT INTO bqp_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Gidiↄn gɛ̀ɛ à blènɛ dɛ̀ à kɛ̀kɛ, à burodi futɛnasari kɛ̀ kũ wísiti kiloo kuriio. À nↄ̀bↄↄ kà tãnkon à dòo kà dò'oron à sùo gbiri lí pì gbáru gwe, akũ à dìtɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Luda Malaikaa pìnɛ: Ǹ nↄ̀bↄ kũ burodiio sɛ́ ǹ kátɛ gbɛ̀ díkĩnaa ǹ dò kúa. Akũ à kɛ̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Akũ Dikiri Malaikaa gò kũ à kũnaa zↄ̃̀ nↄ̀bↄ kũ burodii pìioa, akũ tɛ́ bò gbɛ̀ɛ pìi gũn à kũ̀ nↄ̀bↄ kũ burodii pìiooa, akũ Dikiri Malaikaa pì dibi lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Kũ Gidiↄn dↄ̃̀ Dikiri Malaikaamɛ, à pì: É'e! Dikiri Luda, ase n Zĩ̀rin ma wɛ́ sìalɛ tɛ̃tɛ̃ntɛ̃ yá? ");
INSERT INTO bqp_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Akũ Dikiri pìnɛ: Ǹgↄ̃ kú aafia! Ǹsun tó vĩna n kũro. Ĩni garo. ");
INSERT INTO bqp_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Gidiↄn Dikiri gbagbaki bò gwe, akũ à tↄ́ kpà gu pìinɛ Dikiri Aafiade. À kú Ɔfla Abiɛza gwe ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Zĩ birea gwãani Dikiri pìnɛ: Ǹ n de zùsa kũ à kà wɛ̃̀ suppla kũ ǹ Baali gbagbaki kũ n de vĩ gboro ǹ Asɛra lí kũ à zɛ a sarɛ zↄ̃ ǹ nɛ. ");
INSERT INTO bqp_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Ǹ makũ Dikiri n Luda gbagbaki bo a zɛ́a sĩ̀sĩ díkĩna musu. Ǹ Asɛra lí kũ n zↄ̃̀ sɛ́tɛ yàka ũ ǹ sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ oma kũ zùu pìio. ");
INSERT INTO bqp_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Akũ Gidiↄn a zĩkɛrinↄ sɛ̀ gbɛ̃nↄn kuri à kɛ̀ lákũ Dikiri ònɛ nà. Kũ àtɛn vĩna kɛ a de bedenↄnɛ kũ wɛ̃tɛdenↄ yãi, adi we à kɛ̀ fãnantɛ̃ro, sé gwãani. ");
INSERT INTO bqp_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Kũ wɛ̃tɛdenↄ fùtɛ kↄnkↄ, ò è ò Baali gbagbaki gbòro ò Asɛra lí kũ à zɛ a sarɛ zↄ̃̀ ò nɛ̀ ò sa ò kũ zùuo sa'oki dufu kũ ò bòoa. ");
INSERT INTO bqp_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Akũ ò kↄ̃ làla: Dí mɛ́ à kɛ̀ lɛɛ? Kũ ò dòńyĩ ò gbɛ̀kagbɛka, akũ ò mà ò pì: Yoasi nɛ́ Gidiↄn mɛ́ à kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Akũ wɛ̃tɛdenↄ gɛ̀ɛ ò pì Yoasinɛ: Ǹ bo kũ n nɛ́o ò a dɛ, zaakũ à Baali gbagbaki gbòro akũsↄ̃ à Asɛra lí kũ à zɛ a sarɛ zↄ̃̀ à nɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Akũ Yoasi pì gbɛ̃ kũ ò likaainↄnɛ: Ákↄ̃nↄ mɛ́ áni yã sí Baalinɛ yá? Ákↄ̃nↄ mɛ́ áni a bo yá? Oni gbɛ̃ kũ à yã sìnɛ dɛ ari gu gↄ̃ gɛ́ dↄ. Tó tãnan a ũ, à gí kũ a zĩdao a gbagbaki kũ ò gbòro yãi. ");
INSERT INTO bqp_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Zĩ birean ò tↄ́ kpà Gidiↄnnɛ Yerubaali ò pì: Ò à tó kũ Baalio, zaakũ a gbagbakin à gbòro. ");
INSERT INTO bqp_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Midiãnↄ kũ Amalɛkinↄ kũ ifãboki kpa gbɛ̃ pãndenↄ kↄ̃ kàkara ń pínki ò bikũ̀ Yodaa, akũ ò bùraa kàtɛ Yɛzɛrili guvutɛn. ");
INSERT INTO bqp_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Dikiri Nini gɛ̃̀ Gidiↄn gũn, akũ à Abiɛzanↄ sìsi kũ kuruo de ò su ò tɛ́ai. ");
INSERT INTO bqp_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","À gbɛ̃nↄ zĩ̀ Manasenↄ bùsu gu sĩnda pínkia ò ń sísi se ò su ò tɛ́ai. Akũ à gbɛ̃nↄ zĩ̀ Asanↄ bùsun kũ Zɛbuluninↄ bùsuuo kũ Nafatalinↄ bùsuuo. Akũ ò sù ò kàkara kũńwo. ");
INSERT INTO bqp_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Gidiↄn pì Ludanɛ: Tó ĩni Isarailanↄ bo ma gãi lákũ n a lɛ́ sɛ̀mɛnɛ nà, ");
INSERT INTO bqp_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","ǹ gwa, matɛn sãkã kátɛ pↄ́wɛgbɛ̃kia. Tó plí kpà sãkã pìia ado akũsↄ̃ zĩtɛ gↄ̃̀ kori, mani dↄ̃ sà kũ ĩni Isarailanↄ bo ma gãi lákũ n ò nà. ");
INSERT INTO bqp_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Akũ à kɛ̀ lɛ. Kũ gu dↄ̀, akũ à fùtɛ kↄnkↄkↄnkↄ à sãkã pìi fɛ̃̀, a í ta pà. ");
INSERT INTO bqp_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Akũ Gidiↄn pì Ludanɛ: Ǹsun pↄ fɛ̃ kũmaoro. Má ye mà yã gbɛkamma gɛ̃̀n do dↄ. Ǹ tó mà gwa sãkãa gɛ̃̀n do dↄ. Adikĩna sà, ǹ tó plí kpá zĩtɛa ado, sãkã gↄ̃ kori. ");
INSERT INTO bqp_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Gwãani birea Luda kɛ̀ lɛ. Plí kpà zĩtɛa gu sĩnda pínkia, sãkã mɛ́ à gↄ̃̀ kori ado. ");
INSERT INTO bqp_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Gidiↄn kũ gbɛ̃ kũ ò kú kãaonↄ fùtɛ kↄnkↄ káakukaaku ò gɛ̀ɛ ò bùraa kàtɛ Arodi ísɛ̃bokia. Midiãnↄ bùra kú guvutɛn gugbãnduru kpa Mↄre sĩ̀sĩgɛrɛɛi. ");
INSERT INTO bqp_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Akũ Dikiri pì Gidiↄnnɛ: Gbɛ̃ kũ ò kú kũnwonↄ kɛ̀ dasi, mani Midiãnↄ nańnɛ ń ↄĩro. Tó ma ń náńnɛ ń ↄĩ, oni ĩa dã ò pi ń zĩda gbãna mɛ́ à ń bó. ");
INSERT INTO bqp_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Ǹ kpàkpa kɛ gĩa ǹ pińnɛ, gbɛ̃ kũ swɛ̃̀ɛ kɛ̃̀agu àtɛn lukaluka, ade ɛra. Akũ gbɛ̃nↄn dúbu baro awɛɛpla ɛ̀ra, gbɛ̃nↄn dúbu kuri mɛ́ ò gↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Akũ Dikiri pì Gidiↄnnɛ: Ò kpɛ́ dasi ari tera. Ǹ gɛ́ kũńwo í kĩnaa, mani ń plɛplɛnnɛ gwe. Gbɛ̃ kũ ma ònnɛ oni gɛ́ kũnwonↄ mɛ́ oni gɛ́, gbɛ̃ kũ ma ònnɛ oni gɛ́ kũnworonↄ sↄ̃ mɛ́ oni gↄ̃. ");
INSERT INTO bqp_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Kũ à gɛ̀ɛ kũńwo í kĩnaa, Dikiri pìnɛ: Ǹ gbɛ̃ kũ n è ò lɛ́ pɛ̀tɛ ía lán gbɛ̃ bànↄ sɛ́ kpado kũ gbɛ̃ kũ ò kùtɛ ń kosoa ò í dã̀ kũ ↄo òtɛn minↄ. ");
INSERT INTO bqp_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Gbɛ̃ kũ ò lɛ́ pɛ̀tɛ íanↄ gbɛ̃nↄn wàa do kpɛ́ basↄↄromɛ. Gbɛ̃ kparanↄ sↄ̃ ò kùtɛ ń kosoa ò í mì. ");
INSERT INTO bqp_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Akũ Dikiri pì Gidiↄnnɛ: Mani Midiãnↄ naárɛ á ↄĩ kũ gbɛ̃nↄn wàa do kpɛ́ basↄↄro kũ ò lɛ́ pɛ̀tɛ íanↄo sà mà á bo. Ǹ gbɛ̃ kparanↄ gbarɛ, ń baadi tá a bɛa. ");
INSERT INTO bqp_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Akũ Gidiↄn gbɛ̃nↄn wàa do kpɛ́ basↄↄro pìnↄ sɛ̀, ò gbɛ̃ kũ òtɛn tá bɛnↄ zànanↄ kũ ń kurunↄ sìḿma, akũ à ń gbárɛ. Gidiↄn kú sĩ̀sĩi musu, Midiãnↄ bùra kú guvutɛn a gɛ̃i. ");
INSERT INTO bqp_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Gwãani birea Dikiri yã ònɛ à pì: Ǹ futɛ ǹ gɛ́ńyĩ ń bùran, zaakũ ma ń nánnɛ n ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Tó vĩna tɛni n kũ ǹ gɛ́ńyĩmɛ, ǹ kipa ǹ gɛ́ lɛɛlɛ kũ n zĩkɛri Purao ");
INSERT INTO bqp_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ǹ sã kpá yã kũ òtɛn oi. Yã pì ni n gba swɛ̃̀ de ǹ gɛ́ńyĩ ń bùran. Akũ à kìpa kũ a zĩkɛri Purao ò nà ń bùra lɛ́i. ");
INSERT INTO bqp_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Midiãnↄ kũ Amalɛkinↄ kũ ifãboki kpa gbɛ̃ pãndenↄn katɛna guvutɛn ń pínki, ò kpá lán sutɛ̃nↄ bà. Odi fↄ̃ ò ń lakuminↄ nàroro, ò dasi lán ísiralɛ bùsu'atɛ̃ bà. ");
INSERT INTO bqp_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Kũ Gidiↄn kà gwe, à gbɛ̃ke lè, àtɛni a nana baba a gbɛ̃ndonɛ à pì: Ǹ nana kũ ma ò ma. Ma è burodi bundurunna tɛn gbigiri kɛ, akũ à lɛ̀tɛ ó bùran à sì bizakutaa, akũ kuta pìi lɛ̀tɛ kpɛdangara à gↄ̃̀ katɛna. ");
INSERT INTO bqp_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Akũ a gbɛ̃ndo pìi pìnɛ: Yoasi nɛ́ Gidiↄn, Isaraila buri fɛ̃nɛdan n è gwe, adi kɛ pↄ́ pãndenlo. Luda Midiãnↄ kũ ó bùraao nànɛ a ↄĩ pínki. ");
INSERT INTO bqp_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Kũ Gidiↄn nana pì yã mà kũ a bↄkↄtɛnaao, à donyĩ kɛ̀ Dikirinɛ. Akũ à ɛ̀ra Isarailanↄ bùran à pì: À futɛ! Dikiri Midiãnↄ nàwɛrɛ ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","À gbɛ̃nↄn wàa do kũ basↄↄroo pìnↄ kpàatɛ gã̀ aakↄ̃, akũ à kuru kũ lo korio kpà ń baadia. Akũ ò sɛ̃̀tɛ sↄ̀tↄsↄtↄ lo pìnↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","À pìńnɛ: Matɛn gɛ́ ari ń bùra lɛ́a. Àgↄ̃ ma gwa. Lákũ a è ma kɛ̀ nà, à kɛ lɛ se. ");
INSERT INTO bqp_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","À lika ń bùraai pínki. Tó makũ kũ gbɛ̃ kũ ò kú kũmaonↄ ó kuru pɛ̀, à á pↄ́ pɛ́ se à wiki lɛ́ à pi: Dikiri pↄ́mɛ kũ Gidiↄnwo. ");
INSERT INTO bqp_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Gidiↄn kũ gbɛ̃nↄn basↄↄro kũ ò kú kãaonↄ kà bùra lɛ́a lizãndo gudãkpãrinↄ kↄ̃ lilinkɛnaa gbɛra gↄ̃̀nↄ. Akũ ò ń kuru pɛ̀ ń pínki, ò lo kũ ò kũnanↄ wìwi. ");
INSERT INTO bqp_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Akũ gã̀ aakↄ̃ pìnↄ baadi a kuru pɛ̀ ò ń lonↄ wìwi. Ò sɛ̃̀tɛnↄ kũna ↄzɛn, ò kuru kũ òtɛn pɛ́nↄ kũna ↄplan. Akũ ò wiki lɛ̀ ò pì: Dikiri kũ Gidiↄnwo fɛ̃nɛdamɛ. ");
INSERT INTO bqp_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Baadi zɛ a gbɛ̀n likana bùraai, akũ bùradenↄ fùtɛ ò lɛ̀kↄ̃a kũ wikio ò bàa lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Kũ ò kuru mɛ̀n wàa do kũ basↄↄronↄ pɛ̀ lɛ, Dikiri tò bùraa pì denↄ kↄ̃ dɛ̀dɛ kↄ̃ tɛ̃nɛ kũ fɛ̃nɛdao. Zĩ̀karii pìnↄ bàa lɛ̀ ò tà Bɛtɛsita kũ Zererao ari Abɛli Mɛↄla lɛ́a Taba kpa. ");
INSERT INTO bqp_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Ò Nafatalinↄ kũ Asanↄ sìsi kũ Manasenↄ ń pínki, akũ ò pɛ̀tɛ Midiãnↄi. ");
INSERT INTO bqp_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Akũ Gidiↄn gbɛ̃nↄ zĩ̀ ò gɛ̀ɛ Ɛflaimunↄ gukpiden pínki, ò pìńnɛ: À kipa à gɛ́ Midiãnↄi. À zɛ́ zↄ̃ńnɛ Yoda bikũkinↄa ari Bɛtɛbara. Akũ ò Ɛflaimunↄ sìsi ń pínki ò gɛ̀ɛ ò zɛ́ zↄ̃̀ńnɛ Yoda bikũkinↄa ari Bɛtɛbara. ");
INSERT INTO bqp_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Akũ Ɛflaimunↄ Midiã kínanↄ kũ̀ gbɛ̃nↄn pla, Orɛbu kũ Zebuo. Ò Orɛbu dɛ̀ gbɛ̀ɛ sarɛ, kũ òdi pi tera Orɛbu gbɛ̀ɛ. Ò Zebu dɛ̀ dↄ, gu pìn òdi pi tera Zebu geepi'ifɛ̃ki. Akũ ò ɛ̀ra ò pɛ̀ Midiãnↄa. Akũ ò kína pìnↄ mìi zↄ̃̀zↄ̃ ò gɛ̀ɛo Gidiↄnnɛ Yoda bara dire. ");
INSERT INTO bqp_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Ɛflaimunↄ Gidiↄn là ò pì: Bↄ́ yã mɛ́ à tò n kɛ̀wɛrɛ lɛɛ? Kũ ntɛn gɛ́ zĩ̀ ká kũ Midiãnↄ, akũ ńdi ó sísiroo? Akũ ò yãkete kài lɛ manamana, ");
INSERT INTO bqp_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","akũ à pìńnɛ: Bↄ́n ma kɛ̀ kũ à kà á pↄ́ ũu? Ákↄ̃nↄ Ɛflaimunↄ geepi kↄ̃nↄwɛna mana de ókↄ̃nↄ Abiɛzanↄ geepikɛkɛnala. ");
INSERT INTO bqp_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Luda Midiã kínanↄ Orɛbu kũ Zebuoo nàárɛ á ↄĩ. Bↄ́n ma fↄ̃ ma kɛ̀ kũ à kà á pↄ́ ũu? Kũ à òńnɛ lɛ, gbasa ń pↄfɛ̃ kpàtɛ sà. ");
INSERT INTO bqp_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Gidiↄn kũ a gbɛ̃ gbɛ̃nↄn wàa do kũ basↄↄronↄ kpɛ́ òtɛn pɛ́tɛ Midiãnↄi, bee kũ ń gbãna bùsa. Kũ ò kà Yodai, akũ ò bikũ̀. ");
INSERT INTO bqp_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Akũ à pì Sukodenↄnɛ: À ma gbɛ̃nↄ gba pↄ́ble. Ń gbãna bùsa akũsↄ̃ má kpɛ́ matɛn pɛ́tɛ Midiã kínanↄ Zɛba kũ Zalamunaoi. ");
INSERT INTO bqp_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Akũ Suko gbɛ̃ zↄ̃kↄ̃nↄ pì: Zɛba kũ Zalamunao gɛ̃̀ n ↄĩ kↄ̀n yá? Bↄ́n tò óni n zĩ̀karinↄ gba pↄ́blee? ");
INSERT INTO bqp_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Gidiↄn wèḿma à pì: Zaakũ a ò lɛ, tó Dikiri Zɛba kũ Zalamunao nàmɛnɛ ma ↄĩ, mani á kɛ yákiyaki kũ gbáranna lɛ̀ɛo. ");
INSERT INTO bqp_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Zaa gwe à gɛ̀ɛ Pɛniɛli, akũ à wɛ́ kɛ̀ḿma lɛ dↄ. Pɛniɛlidenↄ wèa lákũ Sukodenↄ wèa nà dↄ, ");
INSERT INTO bqp_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","akũ à pìńnɛ se: Tó ma gɛ ma su aafia, mani gudãkpãki lei díkĩna gboro. ");
INSERT INTO bqp_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Zɛba kũ Zalamunao kú Kako kũ ń zĩ̀karinↄ gbɛ̃nↄn dúbu gɛ̃ro. Ifãboki kpa zĩ̀kari kũ ò gↄ̃̀nↄn gwe. Ń fɛ̃nɛdadenↄ gàga gbɛ̃nↄn dúbu basuddo. ");
INSERT INTO bqp_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Gidiↄn lagatarinↄ zɛ́ sɛ̀ Nↄba kũ Yↄgbɛao ifãboki kpa, akũ à sì zĩ̀karii pìnↄ tɛ́ gↄrↄ kũ ò sã̀ ń zĩda yãn. ");
INSERT INTO bqp_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Midiã kína pìnↄ Zɛba kũ Zalamunao bàa lɛ̀, akũ à pɛ̀tɛńyĩ à ń kũkũ, akũ à tò ń zĩ̀karinↄ lɛ̀kↄ̃a ń pínki. ");
INSERT INTO bqp_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Kũ Yoasi nɛ́ Gidiↄn bò zĩ̀lan àtɛn su, à bↄ̀tɛ Ɛrɛsi Gbɛ̀kpakotozɛn, ");
INSERT INTO bqp_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","akũ à Suko kɛfɛnna ke kũ̀ à a làla yãi, akũ kɛfɛnna pì Suko gbɛ̃ zↄ̃kↄ̃nↄ tↄ́ kɛ̃̀nɛ takadan gbɛ̃nↄn baaakↄ̃ akuri awɛɛsuppla. ");
INSERT INTO bqp_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Akũ Gidiↄn gɛ̀ɛ à Sukodenↄ lè à pì: Zɛba kũ Zalamunaon dí. A ma lalandii kɛ̀ yã a pì, Zɛba kũ Zalamunao dí gɛ̃ ma ↄĩ kↄ̀ro. Áni fↄ̃ à ma gbɛ̃ kũ ń gbãna bùsanↄ gba pↄ́blero. ");
INSERT INTO bqp_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Akũ à wɛ̃tɛ pì gbɛ̃ zↄ̃kↄ̃ↄ pìnↄ kũ̀kũ à ń kɛ́ yákiyaki kũ gbáranna lɛ̀ɛo, ò dↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Akũ à gɛ̀ɛ à Pɛniɛli gudãkpãki lei gbòro à wɛ̃tɛ gↄ̃gbɛ̃nↄ dɛ̀dɛ. ");
INSERT INTO bqp_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Akũ à Zɛba kũ Zalamunao là à pì: Gbɛ̃ kũ a ń dɛdɛ Tabonↄn de deramɛɛ? Ò wèa ò pì: Ò de lán n bàmɛ, ń bona de lán kínanɛnↄ bà. ");
INSERT INTO bqp_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Akũ Gidiↄn pìńnɛ: Ma vĩ̀ni dadokↄ̃nↄdenↄn gwe. Tó a ń tó yã, kũ Dikirio mani á dɛdɛro. ");
INSERT INTO bqp_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Akũ à pì a daudu Yɛtanɛ: Ǹ futɛ ǹ ń dɛdɛ. Nɛ́ pì dí a fɛ̃nɛda wotoro, vĩna a kũ̀, zaakũ nɛ́ fítinnamɛ. ");
INSERT INTO bqp_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Akũ Zɛba kũ Zalamunao pì: Ǹ futɛ ǹ ó dɛdɛ n zĩda. Baadi kũ a gbãnaomɛ. Akũ Gidiↄn fùtɛ à ń dɛdɛ à mↄ̀zã kũ ò dada ń lakuminↄ wakaanↄ bↄ̀tɛ. ");
INSERT INTO bqp_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Isarailanↄ pì Gidiↄnnɛ: Ǹ gↄ̃ ó mìde ũ kũ n burinↄ. Zaakũ mↄkↄ̃n mɛ́ n ó bó Midiãnↄ ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Akũ Gidiↄn pìńnɛ: Mani gↄ̃ á mìde ũro, bee ma nɛ́. Dikirimɛ á kína ũ. ");
INSERT INTO bqp_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Akũ à ɛ̀ra à pìńnɛ: Matɛn wɛ́ kɛáwa: Á baadi pↄ́sã kũ à sìḿma kpáma mɛ̀n dodo. Midiãnↄ dìgↄ̃ wura pↄ́sã dana, zaakũ Sumaila burinↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Ò pìnɛ: Óni kpámma kũ nɛ̀sɛɛo do. Ò biza kpàtɛ, akũ baadi pↄ́sã kũ à sìḿmanↄ dàn mɛ̀n dodo. ");
INSERT INTO bqp_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Wura pↄ́sã kũ à gbɛ̀kaḿma pìnↄ tìkisii kà kiloo baro, mↄ̀zãnↄ kũ pↄ́sãnↄ kũ arukĩmba tɛ̃ra kũ Midiã kínanↄ dananↄ kũ mↄ̀zã kũ ò dada ń lakuminↄ wakaaanↄ baasi. ");
INSERT INTO bqp_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Akũ à pì màsokɛbↄ ũ à pɛ̀tɛ a bɛ wɛ̃tɛn zaa Ɔfla. Akũ Isarailanↄ pãpã kɛ̀ ò dòi ń pínki, akũ à gↄ̃̀ tankutɛ ũ Gidiↄnnɛ kũ a bedenↄo. ");
INSERT INTO bqp_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Lɛn Isarailanↄ Midiãnↄ gbãna bùsa lɛ. Midiãnↄ dí le ò mìi bò doro. Akũ Isarailanↄ bùsu gↄ̃̀ katɛna aafia Gidiↄn gↄrↄ ari wɛ̃̀ bupla. ");
INSERT INTO bqp_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Yoasi nɛ́ Gidiↄn gɛ̀ɛ à vùtɛ a bɛa. ");
INSERT INTO bqp_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","A nɛ́gↄ̃gbɛ̃ kũ à ń ínↄ gbɛ̃nↄn baaakↄ̃ akurimɛ, zaakũ a nↄnↄn dasi. ");
INSERT INTO bqp_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","À nↄpose vĩ dↄ zaa Sɛkɛmu kũ à nɛ́gↄ̃gbɛ̃ ì kãao, akũ ò tↄ́ kpànɛ Abimɛlɛki. ");
INSERT INTO bqp_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Yoasi nɛ́ Gidiↄn gà a wɛ̃̀managↄrↄa, akũ ò a mira kpàkũsũ kũ a de pↄ́o zaa Ɔfla Abiɛza. ");
INSERT INTO bqp_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Kũ Gidiↄn gà gↄ̃̀nↄ, akũ Isarailanↄ ɛ̀ra ò pãpã kɛ̀ ò dò Baalii. Akũ ò tãna kũ òdi pi Baalibakakukũoo pɛ̀tɛ ń dikiri ũ, ");
INSERT INTO bqp_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","akũ Dikiri ń Luda kũ à ń bó ń ibɛrɛ kũ ò likańyĩ kpa sĩnda pínkianↄ ↄĩ yã sã̀ńgu. ");
INSERT INTO bqp_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Odi gbɛ̃kɛ kɛ Gidiↄn kũ òdi pinɛ dↄ Yerubaali bedenↄnɛ yã mana kũ à kɛ̀ńnɛ pínki musuro. ");
INSERT INTO bqp_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Isarailanↄ ɛ̀ra ò yã kũ Dikiri yeiro kɛ̀ dↄ, akũ Dikiri ń ná Filisitininↄnɛ ń ↄĩ ari wɛ̃̀ bupla. ");
INSERT INTO bqp_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Gↄ̃gbɛ̃ ke kú Zↄra, Dã burimɛ, a tↄ́n Manↄa. A nanↄ bi paramɛ, adi nɛ́ iro. ");
INSERT INTO bqp_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Dikiri Malaikaa bò à sù nↄgbɛ̃ pìia à pì: Ǹ ma! Paramɛ n ũ, ńdi nɛ́ iro, ama ĩni nↄ̀ sí ǹ nɛ́ i gↄ̃gbɛ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ǹ laakari kɛ! Ǹsun wɛ̃ ke í gbãna ke miro. Ǹsun tɛ̃̀ ke blero. ");
INSERT INTO bqp_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Ĩni nↄ̀ sí ǹ nɛ́ i gↄ̃gbɛ̃ ũ. Gɛ̃ sún na nɛ́ pìi mìiaro, zaakũ anigↄ̃ de Luda pↄ́ ũmɛ zaa a igↄrↄ. Àkũ mɛ́ ani na Isarailanↄ bonaaa Filisitininↄ ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Akũ nↄgbɛ̃ pìi gɛ̀ɛ à ò a zãnɛ à pì: Luda gbɛ̃ke sù ma kĩnaa. Tó n a è, à de lán Luda Malaikaa bà à naasi vĩ manamana. Mádi a la tó mámɛ à bònlo, akũsↄ̃ adi a tↄ́ omɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","À pìmɛnɛ mani nↄ̀ sí mà nɛ́ i gↄ̃gbɛ̃ ũ. À pìmɛnɛ màsun wɛ̃ ke í gbãna ke miro, akũ dↄ màsun tɛ̃̀ ke blero, zaakũ nɛ́ pì nigↄ̃ de Luda pↄ́ ũmɛ zaa a ina gↄrↄ ari a wɛ̃̀ndi lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Akũ Manↄa wɛ́ kɛ̀ Dikiria à pì: N yã nna Dikiri! Ǹ tó gbɛ̃ kũ n zĩ̀ ɛra à su dↄ à yã kũ óni kɛ kũ nɛ́ pìio a inaa gbɛra dawɛrɛ. ");
INSERT INTO bqp_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Luda Manↄa yã mà, akũ Luda Malaikaa pìi ɛ̀ra à sù nↄgbɛ̃ pìia gↄrↄ kũ à kú bura. A zã Manↄa kú kãao gwero, ");
INSERT INTO bqp_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","akũ à kɛ̀ likalika à bàa lɛ̀ à gɛ̀ɛ à ònɛ à pì: Gↄ̃gbɛ̃ kũ à bò à sùma zĩ kũ̀a kũ̀ dí dↄee! ");
INSERT INTO bqp_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Manↄa fùtɛ à tɛ̀ a nanↄi. Kũ à kà gↄ̃gbɛ̃ pì kĩnaa, à a là à pì: Mↄkↄ̃n mɛ́ n yã ò kũ ma nanↄo yá? À wèa à pì: Makũmɛ! ");
INSERT INTO bqp_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Akũ Manↄa a là à pì: Tó n yã pìi pàpa, nɛ́ pì nigↄ̃ de deramɛɛ? Bↄ́ zĩn anigↄ̃ kɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Dikiri Malaikaa wèa à pì: N nanↄ gↄ̃ yã kũ ma ònɛ kũna pínki. ");
INSERT INTO bqp_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Àsun geepi lí pↄ́ke blero. Àsun wɛ̃ ke í gbãna ke miro. Àsun tɛ̃̀ ke blero. Àgↄ̃ yã kũ ma dìtɛnɛ kũna pínki. ");
INSERT INTO bqp_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Akũ Manↄa pìnɛ: N yã nna, ǹ zɛ gĩa ari ò blènɛ bↄ̀rↄ kɛkɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Dikiri Malaikaa wèa à pì: Bee tó ma gↄ̃ la, mani n pↄ́ke blero. Tó n sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ soru kɛ̀, ǹ o Dikiria. Manↄa dí dↄ̃ kũ Dikiri Malaikaamɛro, ");
INSERT INTO bqp_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","akũ à a là à pì: N tↄ́n deramɛɛ? Tó yã kũ n òo pìi kɛ̀, óni sáabu kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Dikiri Malaikaa wèa à pì: Bↄ́yãin ntɛni ma tↄ́ gbɛkaa? Tↄ́ bonsarɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Akũ Manↄa blènɛ bↄ̀rↄↄ kũ̀ à flawaa sɛ̀ à Dikiri gbàgbao gbɛ̀ ke musu. Kũ Manↄa kũ a nanↄo tɛn gwa, akũ Dikiri yãbonsarɛ kɛ̀ ");
INSERT INTO bqp_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","à tò tɛ́ bò sa'oki pìn à fùtɛ musu, akũ Dikiri Malaikaa fùtɛ tɛ́vuraa pìi gũn à tà musu. Kũ Manↄa kũ a nanↄo è lɛ, akũ ò wùtɛ nɛ̀sɛlɛ kutɛna. ");
INSERT INTO bqp_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Dikiri Malaika dí ɛra à sù Manↄa kũ a nanↄooa doro, akũ Manↄa dↄ̃̀ sà kũ Dikiri Malaikaamɛ. ");
INSERT INTO bqp_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Manↄa pì a nanↄnɛ: O gan yee! Zaakũ o Luda è kũ wɛ́o. ");
INSERT INTO bqp_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Akũ a nanↄ pìnɛ: Tó Dikiri ye à ó dɛmɛ, de adi sa kũ o òa kũ flawaao síro, de adi yã dínↄ owɛrɛro, akũsↄ̃ adi yã pì mↄwɛrɛro. ");
INSERT INTO bqp_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Nↄgbɛ̃ pì nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à tↄ́ kpànɛ Samusi. Nɛ́ pì zↄ̃kↄ̃ kũ̀, akũsↄ̃ Dikiri arubarikaa dànɛ. ");
INSERT INTO bqp_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Dikiri Nini nà zĩkɛnaaa a gũn gↄrↄ kũ à kú Dãnↄ buran, Zↄra dagura kũ Ɛsɛtaoluo. ");
INSERT INTO bqp_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Samusi gɛ̀ɛ Timina, akũ à Filisitini nɛ́nↄkpare ke è gwe. ");
INSERT INTO bqp_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Kũ à sù, akũ à pì a de kũ a daonɛ: Ma Filisitini nɛ́nↄkpare ke è zaa Timina. À gɛ́ à a wɛtɛmɛnɛ mà sɛ́ nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Akũ a de kũ a dao pìnɛ: Nↄ kú n danɛnↄ ke n burinↄ tɛ́nloo? Akũ ĩni gɛ́ ǹ nↄ sɛ́ Filisitini gyↄfↄrↄdenↄ tɛ́ yá? Akũ Samusi pì a denɛ: Ǹ gɛ́ ǹ a wɛtɛmɛnɛ dé, zaakũ nↄkpare pìn má yei. ");
INSERT INTO bqp_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","A de kũ a dao dí dↄ̃ kũ yã pìi bò Dikiri kĩnaanlo, zaakũ Dikiri tɛn zɛ́ wɛtɛ à yã mↄ Filisitininↄnɛmɛ. Gↄrↄ birea Filisitininↄ mɛ́ òtɛn kí ble Isarailanↄa. ");
INSERT INTO bqp_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Akũ Samusi tɛn gɛ́ Timina kũ a deo kũ a dao. Kũ ò kà Timina geepi bura, músunɛ bↄ̀rↄↄ bò Samusii àtɛn pũtã. ");
INSERT INTO bqp_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Dikiri Nini sùa, akũ à músuu pìi kũ̀ à kɛ̃̀kↄ̃rɛ lákũ blènɛ bↄ̀rↄↄn à kɛ̃̀kↄ̃rɛ bà. À pↄ́ke kũna a ↄĩ sↄ̃ro. Adi yã kũ à kɛ̀ɛ pì o a de ke a danɛro. ");
INSERT INTO bqp_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Akũ à gɛ̀ɛ à yã ò kũ nↄkpare pìio, nↄkpare pì sↄ̃ à kɛ̀nɛ mana. ");
INSERT INTO bqp_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Kũ à gↄrↄ pla kɛ̀, à fùtɛ àtɛn gɛ́ nↄ pì sɛ́, akũ à lìtɛ à gɛ̀ɛ músu gɛ̀ɛ pì gwa. Akũ à è zↄ́nↄ sàa dↄ̀ a gɛ̀ɛa ari ò í kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Akũ à ↄ dàn à a sàa gà à wòto àtɛn ble, akũ àtɛn táo. Kũ à kà a de kũ a dao kĩnaa, à lìńnɛ ò blè, ama adi ońnɛ kũ a bò músu gɛ̀ɛ gũmmɛro. ");
INSERT INTO bqp_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","A de gɛ̀ɛ nↄkpare pì kĩnaa, akũ Samusi pↄnna pↄ́ble kɛ̀ńnɛ lákũ nↄsɛrii dì kɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Kũ à sù, ò kɛfɛnnanↄ sìsi gbɛ̃nↄn baraakuri ògↄ̃ kú kãao. ");
INSERT INTO bqp_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Akũ Samusi pìńnɛ: Má gara kutu ke vĩ mà daárɛ. Ari pↄ́blena gↄrↄ suppla dí gɛ́ papao, tó a fↄ̃ à gara pìi bòmɛnɛ, mani biza kpááwa pi baraakuri kũ utao waka baraakuri. ");
INSERT INTO bqp_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Tó ádi fↄ̃ à bòmɛnɛ sↄ̃ro, ákↄ̃nↄ mɛ́ áni biza pi baraakuri kũ uta waka baraakuriio kpáma. Akũ ò pìnɛ: Ǹ ǹ gara pì dawɛrɛ ò ma. ");
INSERT INTO bqp_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","À pìńnɛ: Pↄ́ble bò pↄ́sorii gũn, pↄ́ nna bò pↄ́ gbãna gũn. Akũ odi fↄ̃ ò gara pìi bòro ari gↄrↄ aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","A gↄrↄ siikↄ̃dea ò pì Samusi nanↄnɛ: Ǹ ↄ̃ndↄ̃ kɛ n zãnɛ à gara pì bowɛrɛ. Tó lɛnlo, óni n kpata kũ n de bedenↄo. Ase a ó sísi de à ó pↄ́nↄ síwámɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Akũ Samusi nanↄ tɛn ↄ́ↄ dↄnɛ à pì: N zãmagu! Ń yemairo! N gara ke dà ma gbɛ̃nↄnɛ, akũsↄ̃ ńdi a bona omɛnɛro. Akũ à pìnɛ: Mádi o ma de ke ma danɛro. Bↄ́ mɛ́ à tò mani onnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Àtɛn ↄ́ↄ dↄnɛ ari gↄrↄ suppla pìi gɛ̀ɛ à pàpao. A gↄrↄ supplade pìn akũ Samusi gara pìi bònɛ kũ à nàkaraa yãi, akũ a nↄ pìi gɛ̀ɛ à ò a gbɛ̃nↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","A gↄrↄ suppladea ari ifãntɛ̃ gↄ̃ gɛ́ gɛ̃ kpɛ́n wɛ̃tɛ pìi kɛfɛnnanↄ pìnɛ: Bↄ́ nna mɛ́ à de zↄ́laa? Bↄ́ gbãna mɛ́ à de músulaa? Akũ Samusi pìńnɛ: Tó adi kɛ a bú wì kũ ma zùnunuoro, de ádi fↄ̃ a ma gara pì bòro. ");
INSERT INTO bqp_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Dikiri Nini sùa, akũ à gɛ̀ɛ Asakɛlↄni à gↄ̃gbɛ̃nↄ dɛ̀dɛ gbɛ̃nↄn baraakuri à ń pↄ́kasanↄ bòboḿma, akũ à gɛ̀ɛ à kpà gbɛ̃ kũ ò a gara pì bònɛnↄa. Akũ à pↄ fɛ̃̀ à tà a de bɛa. ");
INSERT INTO bqp_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Akũ ò Samusi nↄ pìi kũ̀ ò kpà a gbɛ̃nna kũ à zɛ̀ a sarɛa nↄ pì sɛ́gↄrↄa. ");
INSERT INTO bqp_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Kũ à kɛ̀ gↄrↄ pla, burapↄnↄ kɛkɛgↄrↄ kà, akũ Samusi blènɛ bↄ̀rↄↄ kũ̀ à gɛ̀ɛ a nↄ pì gwao. À pì: Má ye mà gɛ̃ ma nanↄi kpɛ́n. Akũ a nↄ pì de dí a gba zɛ́ro ");
INSERT INTO bqp_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","à pì: Matɛn da n yeimɛro, akũ ma a kpà n gbɛ̃nnaa. A dakũna mana deala. Ǹ a sɛ́ a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Samusi pìńnɛ: Tó ma yã vãni kɛ̀ á Filisitininↄnɛ sà, manigↄ̃ taari vĩ doro. ");
INSERT INTO bqp_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Samusi gɛ̀ɛ à gbɛ̃gbonnↄ kũ̀kũ wàa do kũ basↄↄroo, akũ à sɛ̃̀ɛ yĩ̀yĩ térereterere. À gbɛ̃gbon pìnↄ vlã yĩ̀yĩkↄ̃a plapla, akũ à sɛ̃̀ɛ pìi yĩ̀yĩ ń vlã pìnↄa. ");
INSERT INTO bqp_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","À tɛ́ nà sɛ̃̀ɛ pìnↄa, akũ à gbɛ̃gbon pìnↄ gbàrɛ Filisitininↄ bura. Ń pↄ́wɛnↄ tɛ́ kũ̀ pínki kũ ń pↄ́wɛ gbànↄ kũ ń geepi búnↄ kũ ń kùkpɛnↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Akũ Filisitininↄ pì: Dí mɛ́ à yã dí taka kɛ̀wɛrɛɛ? Akũ ò pì: Samusimɛ, Timina gbɛ̃ anzuree. A anzuree pì a nↄ sìamɛ, akũ à kpà a gbɛ̃nnaa. Akũ Filisitininↄ gɛ̀ɛ ò tɛ́ sↄ̃̀ nↄ pìia kũ a deo. ");
INSERT INTO bqp_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Samusi pìńnɛ: Zaakũ a kɛ̀ lɛ, mani kámma boro ari ma gɛ fĩna booáwa. ");
INSERT INTO bqp_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","À sì ń tɛ́ à ń kɛ́ dúgudugu, ń dɛdɛnaa pì gɛ̃̀ onala, akũ à gɛ̀ɛ à vùtɛ Etamu gbɛ̀wɛɛn. ");
INSERT INTO bqp_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Filisitininↄ gɛ̀ɛ ò bùraa kàtɛ Yudanↄ bùsun, ò dàgula ari Gɛrɛwa sarɛ. ");
INSERT INTO bqp_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Akũ Yudanↄ ń lá ò pì: Bↄ́yãi a suwái kũ zĩ̀ioo? Akũ ò pì: O su ò Samusi kũmɛ, de ò kɛnɛ lákũ à kɛ̀wɛrɛ nà. ");
INSERT INTO bqp_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Akũ Yudanↄ gbɛ̃nↄn dúbu aakↄ̃nↄ gɛ̀ɛ Etamu gbɛ̀wɛɛ kĩnaa ò pì Samusinɛ: Ń dↄ̃ kũ Filisitininↄ mɛ́ òtɛn kí blewároo? Bↄ́ yãn n kɛ̀wɛrɛ gwee? À wèḿma à pì: Pↄ́ kũ ò kɛ̀mɛnɛn ma kɛ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Akũ ò pì: O su ò n yĩ ò n kpáḿma. Akũ Samusi pì: À la damɛnɛ kũ áni ma dɛ á zĩdaro. ");
INSERT INTO bqp_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Akũ ò pìnɛ: Oi! Óni n dɛro. Óni n yĩ kũ bàaomɛ ò n nańnɛ ń ↄĩ. Akũ ò a yĩ̀ kũ bà dufuo mɛ̀n pla ò bò kãao gbɛ̀wɛɛɛ pìi gũn. ");
INSERT INTO bqp_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Kũ ò kà kãao Gɛrɛwa, akũ Filisitininↄ sù ò daalɛ, òtɛn wiki lɛ́a. Dikiri Nini sù Samusia, akũ bà kũ ò a yĩ̀o a ↄnↄa mùna kũ̀, akũ bàa pìnↄ zↄ̃̀zↄ̃kↄ̃rɛ a ↄa. ");
INSERT INTO bqp_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","À zaaki gɛ̀ dufu gɛrɛwa è, akũ à nàtɛ à sɛ̀ à gbɛ̃nↄn wàa sↄↄronↄ dɛ̀dɛo. ");
INSERT INTO bqp_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Samusi pì: Zaaki gɛrɛwan ma gbɛ̃nↄn wàa sↄↄronↄ dɛ̀dɛo, zaaki gɛrɛwan ma ń tↄ̃tↄ̃kↄ̃ao. ");
INSERT INTO bqp_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Kũ à yã pìi ò à làka, akũ à gɛrɛwa pìi zùkũna. Akũ ò tↄ́ kpà gu pìinɛ Gɛrɛwa Sĩ̀sĩi. ");
INSERT INTO bqp_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Ími a kũ̀ gbãna, akũ à ↄ́ↄ dↄ̀ Dikirinɛ à pì: N tò makũ n zↄ̀bleri ma zĩ̀i blè manamana, akũ ń ye mà ga kũ ímio mà lɛ́tɛ Filisitini gyↄfↄrↄdenↄ ↄĩ yá? ");
INSERT INTO bqp_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Luda Gɛrɛwa guwɛɛ lòkotoo pàra, akũ í bòn. Samusi mì, akũ a wɛ̃̀ndii sù à gbãna lè. Abire yãin òdi gu pì sísi Ɛnakore. À kú Gɛrɛwa ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Samusi yã gↄ̃̀gↄ̃ Isarailanↄnɛ ari wɛ̃̀ baro Filisitininↄ kíblemmanagↄrↄ. ");
INSERT INTO bqp_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Samusi gɛ̀ɛ Gaza à karua ke è gwe, akũ à gɛ̃̀ à wutɛ kãao. ");
INSERT INTO bqp_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Ò pì Gazadenↄnɛ: Samusi kú la. Akũ ò lìka zↄ̃̀ gu pìii, òtɛni a dã wɛ̃tɛ gɛ̃kia gwãani. Ò yĩ̀tɛ gwãani pìia ò pì: Tó gu dↄ̀, óni a dɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Samusi wùtɛ gwe ari lizãndo, akũ à fùtɛ à gɛ̀ɛ à wɛ̃tɛ gɛ̃ki gbàa kũ̀ kũ a lípɛtɛna mɛ̀n planↄ à gà à wò kũ a gbãngao lɛɛlɛ. À dà a gã̀n à gɛ̀ɛ à zùkũna sĩ̀sĩ kũ à arɛ dↄ Ɛblↄnua musu. ");
INSERT INTO bqp_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Abire gbɛra Samusi yè nↄgbɛ̃ kei zaa Sↄrɛki guvutɛn, a tↄ́n Dɛlila. ");
INSERT INTO bqp_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Akũ Filisitini kínanↄ gɛ̀ɛ ò nↄgbɛ̃ pìi lè ò pìnɛ: Ǹ ↄ̃ndↄ̃ kpátɛi de ǹ le ǹ a gbãna zↄ̃kↄ̃ↄ pìi asiri dↄ̃ kũ lákũ óni kɛ nà ò gbãna mↄnɛo. Tó o a yĩ̀ bàao o a gbãna bùsa, ó baadi ni n gba andurufu ↄgↄ mɛ̀n wàa sↄↄro kũ basↄↄroo. ");
INSERT INTO bqp_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Akũ Dɛlila pì Samusinɛ: Ǹ ń gbãna zↄ̃kↄ̃ↄ asiri omɛnɛ kũ deran oni kɛ nà ò n yĩ kũ bàao ò n gbãna busao. ");
INSERT INTO bqp_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","À wèa à pì: Tó ò ma yĩ kũ kyã yĩda mɛ̀n supplao, abire mɛ́ ani ma busa màgↄ̃ de lán baadi bà. ");
INSERT INTO bqp_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Filisitini kínanↄ sù Dɛlilanɛ kũ kyã yĩda kũ adi kori kɛroo mɛ̀n suppla, akũ à a yĩ̀o. ");
INSERT INTO bqp_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","A kũ̀rinↄn utɛna kpɛ́nɛn, akũ Dɛlila pì Samusinɛ: Samusi! Filisitininↄn zɛ la díee! Akũ à kyã pìnↄ kɛ̃̀kɛ̃ lán bà mùkumukuu bà, odi a gbãna asiri dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Akũ Dɛlila pìnɛ: Ntɛni ma lalandi kɛ, ntɛn ɛ́kɛ tomɛnɛmɛ. Ǹ omɛnɛ sà lákũ oni n yĩ nà. ");
INSERT INTO bqp_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Akũ à pìnɛ: Tó ò ma yĩ kũ bà gbìgiri dufu kũ odi zĩ kɛo kↄ̀ro, ani ma busa màgↄ̃ de lán baadi bà. ");
INSERT INTO bqp_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Akũ Dɛlila bàa pìi sɛ̀ à a yĩ̀o. A kũ̀rinↄn utɛna kpɛ́nɛn, akũ à pì: Samusi! Filisitininↄn zɛ la díee! Akũ Samusi bà kũ à dↄ a ↄaa pìi kɛ̃̀kɛ̃ lán buu bàa bà. ");
INSERT INTO bqp_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Dɛlila pìnɛ: Ntɛni ma lalandi kɛ ari tera. Ntɛn ɛ́kɛ tomɛnɛ. Ǹ omɛnɛ sà lákũ oni n yĩ nà? Akũ à pìnɛ: Tó n ma mìkã gbã̀na mɛ̀n supplanↄ kũ̀ n dà àsan n tã̀ lán gòdoo bà, tó n káro pɛ̀a, mani busa màgↄ̃ de lán baadi bà. Dɛlila tò i a sɛ̀, akũ à a mìkã gbã̀na mɛ̀n suppla pìnↄ kũ̀ à tã̀ lán gòdoo bà ");
INSERT INTO bqp_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","à káro pɛ̀a. Akũ à pì: Samusi! Filisitininↄn zɛ la díee! Akũ à vù à àsaa pìi gà à wò kũ a mìkão. ");
INSERT INTO bqp_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Dɛlila ɛ̀ra à pìnɛ dↄ: Ndìgↄ̃ pi ń yemai, akũsↄ̃ ndì ma náani kɛroo? N ma lalandii kɛ̀ à kà gɛ̃̀n aakↄ̃. Ńdi n gbãna zↄ̃kↄ̃ↄ asiri omɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Lɛn àdigↄ̃ nakaraa lɛ kũ yã pìi takao lakanaa sari. Àtɛni a zĩda yↄ́yↄnɛ ari à gɛ̀ɛ à fù mɛnaa à ye à ga. ");
INSERT INTO bqp_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Akũ à yã kũ à kú a swɛ̃̀n ònɛ pínki sà à pì: Gɛ̃ dí na ma mìia zikiro, zaakũ ò ma kɛ Luda pↄ́ ũmɛ. Tó ò ma mìi bò, ma gbãna ni bo ma gũn, mani busa màgↄ̃ de lán baadi bà. ");
INSERT INTO bqp_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Kũ Dɛlila è à yã kũ à kú a swɛ̃̀n òarɛ pínki, akũ à lɛ́gbãzã kɛ̀ Filisitini kínanↄnɛ à pì: À ɛra à su gɛ̃̀n do dↄ, zaakũ à a sĩnda pínki òmɛnɛ sà. Akũ ò ɛ̀ra ò sù a kĩnaa, ò andurufuu pì kũna. ");
INSERT INTO bqp_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Dɛlila tò i Samusi sɛ̀ a gbála, akũ à gↄ̃gbɛ̃ ke sìsi. À a mìkã gbã̀na mɛ̀n suppla pìnↄ bò, akũ à nà busanaaa a gbãna pìi bò. ");
INSERT INTO bqp_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Dɛlila pì: Samusi! Filisitininↄn zɛ la díee! Akũ à vù àtɛn da áni kɛ lán yã bà à a zĩda bomɛ. À dↄ̃ kũ Dikiri a tonlo. ");
INSERT INTO bqp_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Akũ Filisitininↄ a kũ̀, ò a wɛ́nↄ bòbo, akũ ò gɛ̀ɛ kãao Gaza. Ò mↄ̀gotɛ̃ kpàtii kpànɛ, akũ ò a dà àtɛn wísi lↄ́ kpɛ́siran. ");
INSERT INTO bqp_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","A mìkã pìi ɛ̀ra à nà kunaa dↄ a bonaa gbɛra. ");
INSERT INTO bqp_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Filisitini kínanↄ kↄ̃ kàkara de ò ń tãna Dagↄni gbagba, akũ òtɛn pↄnna kɛ ò pì: Ó tãna ó ibɛrɛ Samusi nàwɛrɛ ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Kũ Filisitininↄ a è, ò ń tãna sáabu kpà ò pì: Ó ibɛrɛ ó bùsuu dɛ̀, à ó gbɛ̃nↄ dɛ̀dɛ dúgudugu, akũ ó tãna a nàwɛrɛ ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Lákũ ń pↄ kɛ̀ nna nà, ò pì: À Samusi sísi à fàai pↄ́ kɛwɛrɛ. Akũ ò a bò kpɛ́siran à yáadↄyã kɛ̀ńnɛ. Kũ ò a zɛ̀ kpɛ́ gbɛ̀gbanↄ dagura, ");
INSERT INTO bqp_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","à pì kɛfɛnna kũ à a ↄ kũnaanɛ: Ǹ gɛ́ kũmao gbɛ̀gba kũ ò kpɛ́ kũnanↄ sarɛ de mà ↄ nanaa mà gbãna lea. ");
INSERT INTO bqp_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Tãnakpɛ pìi pà, gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄn kú gwe kũ Filisitini kínanↄ ń pínki. Gbɛ̃ kũ ò kú kpɛ́ pìi musu kà gbɛ̃nↄn wàa gɛ̃ro, kũ ò sù Samusi fàai gwa. ");
INSERT INTO bqp_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Samusi wɛ́ kɛ̀ Dikiria à pì: Dikiri Luda, ǹ tó ma yã dↄngu. Luda, ǹ ma gba gbãna gɛ̃̀n do dↄ de mà fĩna boo Filisitininↄa ma wɛ́ mɛ̀n pla yã musu. ");
INSERT INTO bqp_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","À ↄ nàna gbɛ̀gba mɛ̀n pla kũ ò kpɛ́ pì kũna guraguranↄa, a ↄpla kú a doa a ↄzɛ kú a doa dↄ. ");
INSERT INTO bqp_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","À pì: Ǹ tó mà ga kũ Filisitininↄo! À kutuu kɛ̀, akũ à ↄ yĩ̀paa kũ gbãnao, akũ kpɛ́ pìi gbòro à sì Filisitini kínanↄa kũ gbɛ̃ kũ ò kú a gũnnↄ ń pínki. Gbɛ̃ kũ Samusi ń dɛdɛ a gagↄrↄanↄn dasi de gbɛ̃ kũ à ń dɛdɛ gↄrↄ kũ à kú kũ wɛ̃̀ndiiola. ");
INSERT INTO bqp_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","A dakũnanↄ kũ a de bedenↄ sù ń pínki ò a gɛ̀ɛ sɛ̀ ò tào, akũ ò a mira kpàkũsũ kũ a de Manↄa pↄ́o, Zↄra kũ Ɛsɛtaoluo dagura. À yã gↄ̃̀gↄ̃ Isarailanↄnɛ ari wɛ̃̀ baro. ");
INSERT INTO bqp_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Gↄrↄ kũ yãgↄ̃gↄ̃rinↄ tɛn kí ble Isarailanↄ bùsun, nàa gɛ̃̀, akũ gↄ̃gbɛ̃ ke bò Bɛtilihamu, Yudanↄ bùsun, à gɛ̀ɛ à gↄrↄ pla kɛ̀ Mↄabunↄ bùsun kũ a nanↄo kũ a nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn planↄ. ");
INSERT INTO bqp_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Gↄ̃gbɛ̃ pì tↄ́n Ɛlimɛlɛki. A nanↄ tↄ́n Naomi. A nɛ́nↄ tↄ́n Malonu kũ Kiliↄ̃o. Ɛflata bùsu gbɛ̃nↄmɛ. Ò gɛ̀ɛ Mↄabunↄ bùsun, akũ ò kú gwe. ");
INSERT INTO bqp_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Gwen Naomi zã Ɛlimɛlɛki gàn, akũ à gↄ̃̀ gwe kũ a nɛ́ gbɛ̃nↄn pla pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ò Mↄabu nↄgbɛ̃nↄ sɛ̀ nↄnↄ ũ, a do tↄ́n Opa, a do sↄ̃ Rutu. Ò kú gwe lán wɛ̃̀ kuri taka bà, a gbɛran ");
INSERT INTO bqp_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malonu kũ Kiliↄ̃o gà ń pla ń pínki, akũ Naomi gↄ̃̀ gↄ̃ sari nɛ́nↄ sari. ");
INSERT INTO bqp_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Kũ à kú Mↄabunↄ bùsun gwe, à mà kũ Dikiri a gbɛ̃nↄ wɛ̃nda gwà à ń gbá pↄ́ble, akũ à soru kɛ̀ à ta kũ a nɛ́ nanↄ pìnↄo. ");
INSERT INTO bqp_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Akũ à fùtɛ gu kũ à kunwa à dà zɛ́n kũ a nɛ́ nanↄ pìnↄo, òtɛn tá Yudanↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Akũ à pì a nɛ́ nanↄ pìnↄnɛ: À ɛra à tá á danↄ kĩnaa. Dikiri gbɛ̃kɛ kɛárɛ lákũ a kɛ̀ á gↄ̃ kũ ò gànↄnɛ nà kũ makũo. ");
INSERT INTO bqp_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Dikiri tó á baadi ɛra à zã kɛ à vutɛki le. Kũ à lɛ́ zàḿma, akũ ò ↄ́ↄ dↄ̀ manamana. ");
INSERT INTO bqp_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ò pìnɛ: Óni gɛ́ kũnwo n gbɛ̃nↄ kĩnaamɛ. ");
INSERT INTO bqp_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Akũ à pì a nɛ́ gyaanↄ pìnↄnɛ: À ɛra! Bↄ́yãi áni gɛ́ kũmaoo? Mani ɛra mà nɛ́gↄ̃gbɛ̃nↄ i de à le à zã kɛḿma dↄn yá? ");
INSERT INTO bqp_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","À ɛra à tá! Ma zĩ kũ̀, mani le mà zã kɛ doro. Bee tó ma pì mani wɛ́ dↄ zãkɛnaai, akũ ma lè ↄkↄsiala ma nɛ́gↄ̃gbɛ̃nↄ ì kãao, ");
INSERT INTO bqp_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","áni fↄ̃ à ń dã ari ò kɛ zↄ̃kↄ̃ yá? Áni fↄ̃ àgↄ̃ kun pose ń yãi yá? Oi, ma nɛ́nↄ! Dikiri kpɛ lìmɛnɛmɛ. Yã kũ à á lé pì dí kɛmɛnɛ nnaro fá! ");
INSERT INTO bqp_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ò ɛ̀ra ò nà ↄ́ↄ dↄa, akũ Opa lɛ́ zà a zã daa, ama Rutu gì à nàa. ");
INSERT INTO bqp_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Akũ Naomi pìnɛ: Ǹ gwa, n gbɛ̃ndo tɛn tá a gbɛ̃nↄ kũ a tãnanↄi. Ǹ ɛra ǹ tá kãao. ");
INSERT INTO bqp_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Akũ Rutu pìnɛ: Ǹsun nakarama mà n tó mà táro. Gu kũ n gɛ̀sɛɛ pɛ̀tɛn, ónigↄ̃ lɛɛlɛmɛ. Gu kũ n kipan, gwen mani kipan. N gbɛ̃nↄ ni gↄ̃ ma gbɛ̃nↄ ũ, n Luda ni gↄ̃ ma Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Gu kũ n gan, gwen mani gan ò ma vĩ gwe. Ga baasiro pↄ́ke ni ó kɛ̃kↄ̃aro. Tó ma kɛ̃mma, Dikiri yã kɛmɛnɛ pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kũ Naomi è à zɛ̀o kũ à tá kãáomɛ, adi yãke onɛ doro. ");
INSERT INTO bqp_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Akũ ń pla ń pínki ò gɛ̀ɛ arɛ ari ò kà Bɛtilihamu. Kũ ò kà gwe, wɛ̃tɛ wã̀ ń yã musu. Gbɛ̃nↄ pì: Naomin gwe sↄ̃ yá? ");
INSERT INTO bqp_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Akũ à pìńnɛ: Àsungↄ̃ ma sísi Naomi doro, séde Mara, zaakũ Gbãnasĩndapinkide pↄsirayã kɛ̀mɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ma gɛ wɛ̃tɛa kũ pↄ́nↄ, akũ Dikiri sù kũmao ↄkori. Bↄ́ yã mɛ́ à tò áni ma sísi Naomii? Dikiri bò ma kpɛmɛ, Gbãnasĩndapinkide pì yã'ũmmanaa kpàmai. ");
INSERT INTO bqp_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Lákũ Naomi sù kũ Mↄabunↄ bùsuuo nàn gwe kũ a nɛ́ nanↄ Rutu, Mↄabu burio. Ò kà Bɛtilihamu gↄrↄ kũ ò nà nagãkɛ̃naaamɛ. ");
INSERT INTO bqp_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi zã Ɛlimɛlɛki bɛ gↄ̃gbɛ̃ ke kun, gbɛ̃ zↄ̃kↄ̃ aruzɛkɛdemɛ, a tↄ́n Bↄaza. ");
INSERT INTO bqp_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Mↄabu nↄgbɛ̃ Rutu pì Naominɛ: Ǹ tó mà gɛ́ bura nagã kↄ̃nↄ wɛ màgↄ̃ tɛ́ gbɛ̃ kũ à ma wɛ̃nda gwà kpɛ. Akũ à pì a nɛ́ gyaanↄ pìinɛ: Ǹ gɛ́! ");
INSERT INTO bqp_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Akũ à fùtɛ à gɛ̀ɛ nagã kↄ̃nↄ wɛ bura, àdigↄ̃ tɛ́ pↄ́kɛ̃rinↄ kpɛ. Akũsↄ̃ bura kũ à gɛ̀ɛn pì bi Ɛlimɛlɛki danɛ Bↄaza buramɛ. ");
INSERT INTO bqp_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Akũ Bↄaza bò Bɛtilihamu. Kũ à kà gwe, à fↄ kpà pↄ́kɛ̃rinↄa à pì: Dikiri gↄ̃ kú kãáo! Akũ ò pìnɛ: Dikiri arubarika dangu! ");
INSERT INTO bqp_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bↄaza pì a zĩkɛri kũ à de a pↄ́kɛ̃rinↄ gwàri ũnɛ: Dí mɛ́ à nↄkpare direkũ vĩi? ");
INSERT INTO bqp_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Akũ à wèa à pì: Nↄkpare pì bi Mↄabu nↄgbɛ̃ kũ Naomi bò kãao Mↄabunↄ bùsun à sù kãaomɛ. ");
INSERT INTO bqp_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","À pì mà tó à nagã kↄ̃nↄ wɛ pↄ́kɛ̃rinↄ kpɛ, akũ àtɛn zĩ kɛ zaa kↄnkↄ. Teran à sù kámma bo fíti kuta gũn. ");
INSERT INTO bqp_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Akũ Bↄaza gɛ̀ɛ à pì Rutunɛ: Ǹ ma yã ma. Ǹsun gɛ́ nagã kↄ̃nↄ wɛ bura pãnden doro. Ǹsun gɛ̃tɛwálaro. Ǹ gↄ̃ la kũ ma nↄgbɛ̃ zĩkɛrinↄo. ");
INSERT INTO bqp_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ǹ wɛ́ dↄ zĩ kũ òtɛn kɛa ǹgↄ̃ tɛ́ ń kpɛ. Ma ò ma kɛfɛnnanↄnɛ ò su wari dↄmmaro. Tó ími tɛni n dɛ, ǹ gɛ́ ǹ í kũ ò kà orozãnↄn mi. ");
INSERT INTO bqp_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","À kùtɛnɛ à mìi nàtɛ à pì: À kɛ̀ dera makũ kũ buri pãnde nↄgbɛ̃n ma ũ, n laakarii dↄ̀ma, akũ n yã mana kɛ̀mɛnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Akũ Bↄaza wèa à pì: Ò yã kũ n kɛ̀ n zã danɛ n zã ga gbɛra òmɛnɛ pínki, lákũ n n de kũ n dao tò nà kũ n bùsuuo, akũ n su n vutɛ gbɛ̃ kũ ń ń dↄ̃ yãronↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Dikiri fĩna bonnɛ yã kũ n kɛ̀ɛ musu. Lákũ n su n sↄtↄ Dikiri Isarailanↄ Luda oruu gũn nà, à a fĩna bonnɛ manamana. ");
INSERT INTO bqp_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutu pì: Baa, n yã mana kɛ̀mɛnɛ fá! N ma laakarii kpàtɛmɛnɛ, n yã nna ò makũ n zĩkɛriinɛ, bee kũ n zĩkɛrinↄ doken ma ũro. ");
INSERT INTO bqp_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Pↄ́blegↄrↄ Bↄaza pìnɛ: Ǹ mↄ́ ǹ pↄ́ ble la ǹgↄ̃ burodi zↄ̃ dòoa. Akũ à vùtɛ pↄ́kɛ̃rinↄ sarɛ. Bↄaza pↄ́blewɛ kpatanaa kpàa, akũ à pↄ́ blè à kã̀ ari a kpara gↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Kũ à fùtɛ àtɛn gɛ́ pↄ́ kↄ̃nↄ wɛ, akũ Bↄaza ò kɛfɛnnanↄnɛ à pì: Bee tó àtɛn pↄ́ kↄ̃nↄ wɛ nagã kũ à katɛna tɛ́, àsun wé'i daaro. ");
INSERT INTO bqp_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","À a sà kenↄ bobonɛ nagã gũn à tó à a kↄ̃nↄ wɛ. Àsun pataaro. ");
INSERT INTO bqp_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Akũ à pↄ́ kↄ̃nↄ wɛ̀ ari ↄkↄsi. Kũ à zↄ̃̀ à a wɛ́ bò, à kà toko lɛ́ do taka bà. ");
INSERT INTO bqp_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kũ à sɛ̀ à tào bɛ, akũ à pↄ́ kũ à a kↄ̃nↄ wɛ̀ pìi mↄ̀ a zã danɛ. À pↄ́ble kpara kũ à gↄ̃̀ pìi kpàa dↄ. ");
INSERT INTO bqp_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Akũ a zã da a là à pì: Mákpan n pↄ́ kↄ̃nↄ wɛ̀n gbãraa? N zĩ kɛ̀ máa? Luda arubarika da gbɛ̃ kũ à laakarii dↄ̀mman. Akũ à gbɛ̃ kũ à zĩ kɛ̀ a bura yã ònɛ à pì: Gbɛ̃ kũ ma zĩ kɛ̀ a bura gbãra tↄ́n Bↄaza. ");
INSERT INTO bqp_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Akũ Naomi pì: Ma Dikiri sáabu kɛ̀! À kpɛ́ àtɛn gbɛ̃kɛ kɛ ókↄ̃nↄ kũ ó bɛ̃nɛnↄnɛ kũ ó gbɛ̃ kũ ò gànↄ. Akũ à ɛ̀ra à pì: Gbɛ̃ pì bi ó danɛ kãni buri mɛ̀n domɛ. ");
INSERT INTO bqp_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Akũ Mↄabu nↄgbɛ̃ Rutu pì: À pìmɛnɛ mà na a zĩkɛrinↄa ari ò gɛ́ pↄ́ kɛ̃ ò lákao. ");
INSERT INTO bqp_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Akũ Naomi pì a nɛ́ gyaanↄ pìinɛ: À mana ǹ gɛ́ kũ a nↄgbɛ̃ zĩkɛrinↄ de òsun wari dↄmma bura pãnde gũnlo yãi. ");
INSERT INTO bqp_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Akũ à nà Bↄaza nↄgbɛ̃ zĩkɛrinↄa. Àdigↄ̃ pↄ́ kↄ̃nↄ wɛ ń kpɛ ari ò gɛ̀ɛ ò nagã kũ gbadoo kɛ̃̀ ò làka. À kú a zã da bɛamɛ. ");
INSERT INTO bqp_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Naomi pì a nɛ́ gyaanↄ pìinɛ: À mana mà bɛ wɛtɛnnɛ, gu kũ ĩni le ǹgↄ̃ kunwa aafia. ");
INSERT INTO bqp_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Bↄaza kũ ń kú kũ a zĩkɛrinↄ bi ó danɛnloo? Àkũ mɛ́ àtɛn pↄ́wɛ gbɛ̃ ↄkↄsiala. ");
INSERT INTO bqp_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ǹ zú o ǹ nísi dↄkↄ. Ǹ n aso mana da ǹ gɛ́ pↄ́wɛgbɛ̃kia. Ǹsun tó à dↄ̃ ń kú gwero ari à pↄ́ blè à í mì à làkao. ");
INSERT INTO bqp_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Tó à wùtɛ, ǹ gu kũ à wùtɛn gwa, ǹ gɛ́ ǹ a biza lɛ́ sɛ́ ǹ wútɛ a gbá sarɛ. Ani yã kũ ĩni kɛ onnɛ. ");
INSERT INTO bqp_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Akũ à pìnɛ: Yã kũ n ò pínki, mani kɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Akũ à gɛ̀ɛ pↄ́wɛgbɛ̃kia à yã kũ a zã da ònɛɛ pìi kɛ̀ pínki. ");
INSERT INTO bqp_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bↄaza pↄ́ blè à í mì, a pↄ kɛ̀ nna. À gɛ̀ɛ à wùtɛ pↄ́wɛ tuku sarɛ dire kpa, akũ Rutu lↄↄtɛ̀i tɛɛnɛ, à biza gò a gbáa à wùtɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Lizãndo kũ Bↄaza kɛ̀ gìri, à vù kũ io à lìtɛ, akũ à lè nↄgbɛ̃ mɛ́ à wutɛna a gbá sarɛ. ");
INSERT INTO bqp_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Kũ à pì, dímɛɛ, akũ Rutu wèa à pì: N zĩkɛri Rutumɛ. Ǹ n biza lɛ́ kúmala, zaakũ ma danɛ kãni kũ ani ma bomɛ n ũ. ");
INSERT INTO bqp_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","À pìnɛ: Dikiri arubarika dangu! Gbɛ̃kɛ kũ n kɛ̀ kpɛkpɛ díkĩna de a káakupↄla. Ńdi gɛ́ kɛfɛnna wɛtɛro, takaside kesↄ̃ aruzɛkɛde. ");
INSERT INTO bqp_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ǹsun tó vĩna n kũro. Pↄ́ kũ n wɛ́ kɛ̀ pínki, mani kɛnnɛ, zaakũ wɛ̃tɛdenↄn dↄ̃ kũ nↄ manamɛ n ũ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Yãpuramɛ! N danɛn ma ũ, ama danɛ kãni pãnde kun à kãni demala. ");
INSERT INTO bqp_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ǹ i la gwãaniala, zia kↄnkↄ tó à ye à n bomɛ, à mana, à n bo. Ama tó adi wero, ma sì kũ Dikirio mani n bo. Ǹ i la ari gu dↄ. ");
INSERT INTO bqp_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","À wutɛna a gbá sarɛ gwe ari gudↄo, akũ à fùtɛ ari gu gↄ̃ gɛ́ kɛ̃, zaakũ Bↄaza pìnɛ àsun tó gbɛ̃ke dↄ̃ kũ à sù pↄ́wɛgbɛ̃kiaro. ");
INSERT INTO bqp_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","À pìnɛ dↄ: Ǹ n pↄ́dangãa poro ǹgↄ̃ kũna. Kũ à kũna, akũ Bↄaza nagã kànɛ zaka lɛ́ suddo à dìnɛ, akũ à tào bɛ. ");
INSERT INTO bqp_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Kũ à kà bɛ, à zã da a là à pì: Yã kɛ̀ deraa? Akũ à yã kũ gↄ̃gbɛ̃ pìi kɛ̀nɛɛ ònɛ pínki, ");
INSERT INTO bqp_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","à pì: À ma gba nagã zaka lɛ́ suddo díkĩnamɛ. À pì à mana mà tá ma zã da kia ↄkoriro. ");
INSERT INTO bqp_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Akũ Naomi pì: Ǹ vutɛ tɛɛnɛ ari ǹ yã pì lakana dↄ̃, zaakũ gↄ̃gbɛ̃ pì ni kámma bo gbãra yã pì lakanaa sariro. ");
INSERT INTO bqp_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bↄaza gɛ̀ɛ à vùtɛ wɛ̃tɛ bĩnilɛa, akũ à è danɛ kãni bòri kũ à a yã òo pì tɛn su. Akũ à pì: Ma gbɛ̃, ǹ mↄ́ ǹ vutɛ. ");
INSERT INTO bqp_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Akũ à wɛ̃tɛ gbɛ̃ zↄ̃kↄ̃nↄ sìsi gbɛ̃nↄn kuri à pì ò vutɛ. ");
INSERT INTO bqp_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Akũ à pì danɛ kãni kũ ani a sura ba pìinɛ: Naomi kũ à sù kũ Mↄabunↄ bùsuuo tɛni ó vĩ̀ni Ɛlimɛlɛki bura kpado yía. ");
INSERT INTO bqp_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Akũ ma è à mana mà a yã onnɛ, de ǹ lú ó gbɛ̃ zↄ̃kↄ̃ kũ ò vutɛna lanↄ wára. Tó ń ye ǹ lúmɛ, ǹ lú. Tó ń ye ǹ lú sↄ̃ro, ǹ omɛnɛ mà ma, zaakũ mↄkↄ̃n mɛ́ ń a luna zɛ́ vĩ. Tó n bakanlo, séde makũ mà lú. Akũ gↄ̃gbɛ̃ pìi pì: Mani lú. ");
INSERT INTO bqp_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Akũ Bↄaza pì: Tó n bura pìi lù Naomi kũ Mↄabu nↄgbɛ̃ Rutuoa, ĩni gbɛ̃ kũ à gà gyaanↄ le dↄ, de a tↄ́ le à gↄ̃ a túbia. ");
INSERT INTO bqp_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Akũ danɛ kãni bòrii pìi pì: Tó lɛn à de lɛ, mani lúro, de màsun ma zĩda túbi yakaro yãi. Ǹ n pↄ́ lú, zaakũ mani fↄ̃ mà lúro. ");
INSERT INTO bqp_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Isarailanↄ bùsun yã tó gbɛ̃ tɛn bura lú ke tó àtɛni a lilin kɛ, tó àtɛn yã mì láka, àdi a kyate gbá do bo à kpá gbɛ̃amɛ yã pì lakana sèeda ũ Isarailanↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kũ danɛ kãni bòrii pìi pì Bↄazanɛ à lú, akũ à a kyate bò à kpà Bↄazaa. ");
INSERT INTO bqp_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Akũ Bↄaza pì gbɛ̃ zↄ̃kↄ̃ↄ pìnↄnɛ kũ gbɛ̃ kparanↄ ń pínki: Ákↄ̃nↄmɛ sèedadenↄ ũ gbãra, kũ ma Ɛlimɛlɛki kũ Malonuo kũ Kiliↄ̃o pↄ́nↄ lù Naomia pínki. ");
INSERT INTO bqp_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Akũ ma Malonu gyaanↄ Rutu, Mↄabu nↄgbɛ̃ lè nↄ ũ dↄ, de gbɛ̃ kũ à gàa pì tↄ́ le àgↄ̃ kú a túbia, de a tↄ́ sún ga a gbɛ̃nↄ tɛ́ ke a wɛ̃tɛ díkĩna gũnlo. Ákↄ̃nↄmɛ yã pìi sèedadenↄ ũ gbãra. ");
INSERT INTO bqp_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Akũ gbɛ̃ zↄ̃kↄ̃ↄ pìnↄ kũ gbɛ̃ kũ ò kú gãnu gũnnↄ pì ń pínki: Ókↄ̃nↄmɛ sèedadenↄ ũ. Dikiri tó nↄgbɛ̃ kũ àtɛn gɛ̃ n ↄnn pì gↄ̃ lán Rahila kũ Leao bà, kũ ò Isarailanↄ buri kɛ̀. Ani tó ǹ gbãna kũ Ɛflata bùsun ǹ tↄ́ bo Bɛtilihamu. ");
INSERT INTO bqp_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Dikiri tó buri kũ ani kpámma kũ nↄgbɛ̃ pìionↄ gↄ̃ lán Pɛrɛzi kũ Tama ì Yudanɛɛ burinↄ bà. ");
INSERT INTO bqp_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Akũ Bↄaza Rutu sɛ̀ nↄ ũ. À wùtɛ kãao, akũ Dikiri tò à nↄ̀ↄ sì, akũ à nɛ́ ì gↄ̃gbɛ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Akũ nↄgbɛ̃nↄ pì Naominɛ: O Dikiri sáabu kɛ̀, adi n tó buri sari gbãraro. Luda tó nɛ́ pì tↄ́ bo Isarailanↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ani n laakari kpátɛnnɛ, ani n gwa n zĩkũnaa gũn, zaakũ n nɛ́ gyaanↄ kũ à yenyĩ mɛ́ à a ìnnɛ, akũsↄ̃ à manannɛ de nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn supplanↄla. ");
INSERT INTO bqp_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Akũ Naomi nɛ́ pìi sɛ̀ à kpà a kùla à gↄ̃̀ a gwàri ũ. ");
INSERT INTO bqp_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Akũ nↄgbɛ̃ kũ ò kú gwenↄ pì: Ò nɛ́gↄ̃gbɛ̃ ì Naominɛ. Akũ ò tↄ́ kpànɛ Ɔbɛdi. Àkũmɛ Yɛsɛ de, Dauda dizi ũ. ");
INSERT INTO bqp_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Pɛrɛzi burinↄ tↄ́n dí: Pɛrɛzi mɛ́ à Ɛzɛrↄnu ì, ");
INSERT INTO bqp_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ɛzɛrↄnu Ramu ì, Ramu Aminadabu ì, ");
INSERT INTO bqp_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabu Nasↄ̃ ì, Nasↄ̃ Salamↄ ì, ");
INSERT INTO bqp_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salamↄ Bↄaza ì, Bↄaza Ɔbɛdi ì, ");
INSERT INTO bqp_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Ɔbɛdi Yɛsɛ ì, akũ Yɛsɛ Dauda ì. ");
INSERT INTO bqp_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Gↄ̃gbɛ̃ ke kú Rama, Ɛflaimu bùsu gusĩsĩden. Zufu burimɛ, a tↄ́n Ɛlɛkana, Yeroamu nɛ́mɛ. Ɛflaimu buri kũ òdi pi Zufu pì mɛ́ à Tohu ì, akũ Tohu Ɛliu ì, akũ Ɛliu Yeroamu pìi ì. ");
INSERT INTO bqp_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Ɛlɛkana nↄnↄ vĩ mɛ̀n pla, a káaku tↄ́n Ana, a plade tↄ́n Penina. Penina mɛ́ à nɛ́nↄ vĩ, Ana sↄ̃ à nɛ́ vĩro. ");
INSERT INTO bqp_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Wɛ̃̀ kũ wɛ̃̀ɛo gↄ̃gbɛ̃ pìi dì bo a wɛ̃tɛ gũn à gɛ́ donyĩ kɛ Dikiri Zĩ̀karidenɛ zaa Silo à sa oa. Ɛli nɛ́gↄ̃gbɛ̃ mɛ̀n planↄ Ɔfini kũ Finɛasio kú gwe Dikiri gbàgbarinↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Gↄrↄ kũ Ɛlɛkana sa ò, àdi a nↄ̀bↄ kpá a nanↄ Peninaa kũ a nɛ́gↄ̃gbɛ̃nↄ kũ a nɛ́nↄgbɛ̃nↄ ń pínki, ");
INSERT INTO bqp_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","akũ àdi a lɛu pla kpá Anaa kũ à yei yãi, bee kũ Dikiri à kɛ̀ para ũ. ");
INSERT INTO bqp_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","A gↄ̃ba pì sↄ̃, àdigↄ̃ a fobo a parakɛna yãi, de à a nɛ̀sɛ futɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Lɛn àdigↄ̃ kɛnɛ lɛ wɛ̃̀ kũ wɛ̃̀ɛo. Tó Ana gɛ̀ɛ Dikiri kpɛ́ gũn, a gↄ̃ba pìi dì a fobo, akũ àdi ↄ́ↄ dↄ ari à fua à pↄ́ ble. ");
INSERT INTO bqp_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Akũ a zã dì a lá: Ana, bↄ́ mɛ́ à n le, ntɛn ↄ́ↄ dↄ, ńdi pↄ́ bleroo? À kɛ̀ dera n nɛ̀sɛɛ yàkaa? Má dennɛ nɛ́gↄ̃gbɛ̃ mɛ̀n kurilaroo? ");
INSERT INTO bqp_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Zĩkea kũ ò kú Silo, ò pↄ́ blè ò làka, sa'ori Ɛli vutɛna gbàaa Dikiri kpɛ́ kpɛ́lɛlɛa, akũ Ana fùtɛ ");
INSERT INTO bqp_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","kũ nɛ̀sɛyakana zↄ̃kↄ̃ↄo, à wɛ́ kɛ̀ Dikiria kũ ↄ́ↄdↄo manamana. ");
INSERT INTO bqp_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Akũ à lɛ́ kɛ̀ Dikiria à pì: Dikiri Zĩ̀karide, ǹ tó makũ n zↄ̀bleri yã dↄngu! Ǹ ma wɛ̃nda gwa! Tó ma yã dí sãnguro, akũsↄ̃ n ma gba nɛ́gↄ̃gbɛ̃, mani a kpámma n pↄ́ ũ ari a wɛ̃̀ndi lɛ́n, gɛ̃ ni na a mìia zikiro. ");
INSERT INTO bqp_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Kũ a wɛ́kɛna Dikiriaa pì tɛn lákaro, akũ Ɛli tɛni a lɛ́ gwa tíii. ");
INSERT INTO bqp_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Ana tɛn adua pì kɛ a swɛ̃̀ɛ gũn, a lɛ́ mɛ́ àtɛn kɛ zúkizuki, adi yã o à bò a lɛ́n gbɛ̃ke màro. Ɛli tɛn da wɛ̃ tɛni a dɛmɛ, ");
INSERT INTO bqp_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","akũ à pìnɛ: Wɛ̃ nigↄ̃ n dɛ ari bↄrɛmɛɛ? Ǹ mì kɛ̃ wɛ̃a. ");
INSERT INTO bqp_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Akũ Ana wèa à pì: Adi kɛ lɛnlo Baa! Nↄgbɛ̃ pↄsiraden ma ũ, mádi wɛ̃ ke í gbãna ke miro. Matɛni ma yã'ũmmananↄ o Dikirinɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ǹsun makũ n zↄ̀bleri ditɛ nↄgbɛ̃ pã ũro. Ma nɛ̀sɛ yakana kũ ma kunna bídi gũnwo mɛ́ à tò matɛn wɛ́ kɛ la ari tera. ");
INSERT INTO bqp_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Akũ Ɛli pìnɛ: Ǹ tá aafia. Isarailanↄ Luda n gba pↄ́ kũ n wɛ́ kɛ̀aa. ");
INSERT INTO bqp_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Akũ Ana pì: Ǹ tó makũ n zↄ̀bleri yã kángu. Akũ à tà à pↄ́ blè a ãnn wère. ");
INSERT INTO bqp_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Kũ gu dↄ̀, ò fùtɛ kↄnkↄkↄnkↄ ò gɛ̀ɛ ò donyĩ kɛ̀ Dikirinɛ. Akũ ò ɛ̀ra ò tà ń wɛ̃tɛa Rama. Kũ Ɛlɛkana wùtɛ kũ a nanↄ Anao, a yã dↄ̀ Dikirigu. ");
INSERT INTO bqp_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Gↄrↄ birean à nↄ̀ↄ sì à nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à tↄ́ kpànɛ Samuɛli, zaakũ à pì: Ma a wɛ́ kɛ̀ Dikiriamɛ. ");
INSERT INTO bqp_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Akũ Ɛlɛkana fùtɛ kũ a bedenↄ ń pínki, ò ɛ̀ra ò gɛ̀ɛ sa kũ òdi o wɛ̃̀ kũ wɛ̃̀ɛo o Dikiria, ò lɛ́ kũ ò gbɛ̃̀nɛ fĩna bo. ");
INSERT INTO bqp_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Ama Ana dí gɛ́ro. À pì a zãnɛ: Tó nɛ́ pìi kɛ̃̀, akũ mani gɛ́ a mↄ Dikirinɛ, anigↄ̃ kú gwe gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Akũ a zã pìnɛ: Lákũ à kɛ̀nnɛ mana nà ǹ kɛ. Ǹ mɛna ari à kɛ̃. Dikiri tó yã pì kɛ. Akũ nↄgbɛ̃ pì a nɛ́ gwà ari à gɛ̀ɛ à kɛ̃̀o. ");
INSERT INTO bqp_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Kũ à kɛ̃̀, akũ à a sɛ̀ à gɛ̀ɛ kãao Dikiri kpɛ́n Silo kũ zùsa wɛ̃̀ aakↄ̃o kũ wísitio konko do kũ sèwɛ̃o tùru do. Nɛ́ pìi kɛ̀ kɛfɛnna ũ. ");
INSERT INTO bqp_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Kũ ò zùsaa pìi kùtu kpà, akũ ò gɛ̀ɛ kũ nɛ́ pìio Ɛli kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Akũ Ana pìnɛ: Baa, ǹ gaafara kɛmɛnɛ! Kũ n kunnaao makũmɛ nↄgbɛ̃ kũ à zɛ la matɛn wɛ́ kɛ Dikiria n wára ũ. ");
INSERT INTO bqp_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Nɛ́ díkĩnan ma wɛ́ kɛ̀ Dikiria, akũ à ma gba pↄ́ kũ ma gbɛ̀kaaa pìi. ");
INSERT INTO bqp_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Abire yãin ma su a kpá Dikiria, de àgↄ̃ kun a pↄ́ ũ ari a wɛ̃̀ndi lɛ́n. Akũ ò donyĩ kɛ̀ Dikirinɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Akũ Ana aduaa kɛ̀ à pì: Ma nɛ̀sɛ tɛn yáa dↄ Dikiria, ma mì dana ía Dikiri yãi. Matɛn woo kɛ ma ibɛrɛnↄa, ma pↄ kɛ̀ nna, kũ à ma sura bà. ");
INSERT INTO bqp_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Gbɛ̃ke kú adona lán Dikiri bàro, gbɛ̃ke kun lán a bàro, gbɛ̀si ke kun lán ó Luda bàro. ");
INSERT INTO bqp_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Àsun yã bↄtɛ kũ yↄ̃nkↄoro, àsun tó zĩda bina yã bo á lɛ́nlo, zaakũ Dikiri Ludamɛ yãdↄ̃ri ũ, àkũ mɛ́ àdi ó yãkɛnanↄ yↄ̃ à gwa. ");
INSERT INTO bqp_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Gↄ̃sa gbãnanↄ sá ɛ̀'ɛ, ama gbɛ̃ funanↄ gbãna asa dↄ̀ ń pi. ");
INSERT INTO bqp_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Gbɛ̃ kãna tɛn a zĩda aya kɛ pↄ́ble yãi, ama nà tɛn gbɛ̃ kũ àtɛni a dɛ yã dɛ doro. Para nɛ́ ì mɛ̀n suppla, ama nɛ́dasi'irii gↄ̃̀ wɛ̃nda. ");
INSERT INTO bqp_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Dikiri mɛ́ àdi tó gbɛ̃ ga, akũsↄ̃ àdi tó gbɛ̃ gↄ̃ kun. Àkũ mɛ́ àdi tó gbɛ̃ gɛ̃ bùsuu gũn, akũsↄ̃ àdi gɛ̀ vu. ");
INSERT INTO bqp_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Dikiri mɛ́ àdi su kũ takasio kũ kunna nnao, àdi ↄ tↄ̃ gbɛ̃kenↄa, àdi gbɛ̃kenↄ sɛ́ lei. ");
INSERT INTO bqp_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Àdi wɛ̃ndadenↄ bo bùsutitin, àdi takasidenↄ bo tuburan. Àdi ń vutɛ gu dokↄ̃nↄ kũ kínɛnↄ, àdi tó ò kpata ble kũ gakurio. Zaakũ zĩtɛ pɛ́tɛkinↄ bi Dikiri pↄ́mɛ, akũ à andunia kàtɛa. ");
INSERT INTO bqp_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Àdi a gbɛ̃nↄ gbápɛtɛki dãkpãńnɛ, àdi yãvãnikɛrinↄ dúgu zↄ̃ gusiran. Gbɛ̃ke ni fↄ̃ à ↄsi nɛ kũ a zĩda gbãnaoro. ");
INSERT INTO bqp_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Dikiri ni a ibɛrɛnↄ ú lↄ́, ani pata a ibɛrɛnↄa zaa musu, ani yãkpatɛ kɛ kũńwo ari andunia lɛ́zɛkia. Ani kína kũ à kàa gba gbãna, ani gbɛ̃ kũ à sɛ̀ɛ pìi mì da ía. ");
INSERT INTO bqp_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Akũ Ɛlɛkana tà a bɛ wɛ̃tɛa Rama, akũ nɛ́gↄ̃gbɛ̃ pìi gↄ̃̀, àtɛn zĩ kɛ Dikirinɛ kũ sa'ori Ɛlio. ");
INSERT INTO bqp_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Ɛli nɛ́gↄ̃gbɛ̃nↄ bi nɛ́ pãsĩnↄmɛ, òdi Dikiri daro. ");
INSERT INTO bqp_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Yã kũ sa'orii pìnↄ dì kɛńnɛn dí. Tó gbɛ̃ sa ò, gↄrↄ kũ àtɛn nↄ̀bↄↄ pì fùfu kɛ, sa'ori ìba ke dì su kũ saka gã̀nɛ aakↄ̃deo kũna. ");
INSERT INTO bqp_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Akũ àdi sí ta gũn ke oro ke mↄ̀'oro, akũ sa'ori dì pↄ́ kũ saka pìi bòo sɛ́ a pↄ́ ũ pínki. Lɛn òdi kɛ Isaraila kũ ò sù Silonↄnɛ lɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Bee ari ògↄ̃ gɛ́ nↄ̀bↄ kpá tɛ́a a nísi láka, sa'ori ìba ke dì su à pi gbɛ̃ kũ à sa òo pìinɛ: Ǹ nↄ̀bↄ kpá sa'oria à kpá tɛ́a, zaakũ ani we à nↄ̀bↄ fùfukɛna símmaro, sé a búsu. ");
INSERT INTO bqp_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Tó gbɛ̃ pìi pìnɛ áni nↄ̀bↄ kpá tɛ́a gĩa a nísi láka, gbasa pↄ́ kũ à yei à sɛ́ sà, akũ ìbaa pìi dì pi: Oi! Ǹ kpáma gↄ̃̀nↄ! Tó n gi, mani bo kũ gbãnao. ");
INSERT INTO bqp_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Kɛfɛnna pìnↄ durunna zↄ̃kↄ̃ Dikirinɛ manamana, zaakũ òtɛni a sa'onↄbↄ gya bomɛ. ");
INSERT INTO bqp_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Nɛ́gↄ̃gbɛ̃ Samuɛli sↄ̃ àdigↄ̃ zĩ kɛ Dikirinɛ kũ uta lokommao dana. ");
INSERT INTO bqp_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","A da dì uta gyaba fítinna zↄ̃nɛ. Tó àtɛn su sa o kũ a zão wɛ̃̀ kũ wɛ̃̀ɛo, akũ àdi suonɛ. ");
INSERT INTO bqp_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Ɛli dì sa mana o Ɛlɛkananɛ kũ a nↄ pìio à pi: Dikiri n gba nɛ́ dↄ kũ n nↄ pìio, nɛ́ kũ à a wɛ́ kɛ̀ akũ à kpà Dikiriaa pìi gɛ̃nɛ ũ. Akũ òdi tá ń bɛa. ");
INSERT INTO bqp_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Akũ Dikiri arubarikaa dà Ananɛ, à ɛ̀ra à nɛ́ ì mɛ̀n sↄↄro, gↄ̃gbɛ̃ aakↄ̃, nↄgbɛ̃ pla. Nɛ́gↄ̃gbɛ̃ Samuɛli sↄ̃ àtɛn zↄ̃kↄ̃ kũ Dikiri ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Ɛli zĩ kũ̀ yúkuyuku, à yã kũ a nɛ́nↄ tɛn kɛ Isarailanↄnɛ mà pínki kũ lákũ òdi wútɛ kũ nↄgbɛ̃ kũ òdigↄ̃ zĩ kɛ dakarɛki kuta kpɛ́lɛlɛanↄo nà. ");
INSERT INTO bqp_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Akũ à ń lá à pì: Bↄ́ mɛ́ à tò átɛn yã kɛ lɛɛ? Ma mà gbɛ̃ sĩnda pínki tɛni á yãvãnikɛna o. ");
INSERT INTO bqp_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Àsun kɛ lɛro ma nɛ́nↄ! Baaru kũ ma mà kũ àtɛn dagula Dikiri gbɛ̃nↄ tɛ́ pì manaro. ");
INSERT INTO bqp_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Tó gbɛ̃ durunna kɛ̀ a gbɛ̃dakenɛ, Luda ni a yã gↄ̃gↄ̃, ama tó gbɛ̃ durunna kɛ̀ Dikirinɛ, dí mɛ́ ani kútɛ kɛnɛɛ? Akũ ò gì ń de yã mai, zaakũ Dikiri zɛ̀ kũ ń dɛdɛna yãomɛ. ");
INSERT INTO bqp_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Nɛ́gↄ̃gbɛ̃ Samuɛli sↄ̃, àtɛn zↄ̃kↄ̃ kũ àtɛn kara. Àdigↄ̃ nna kũ Dikirio kũ gbɛ̃ sĩnda pínkio. ");
INSERT INTO bqp_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Akũ Luda gbɛ̃ke sù à pì Ɛlinɛ: Dikiri pì, gↄrↄ kũ n dizi Haruna bedenↄ tɛn zↄ̀ ble Firi'aunanɛ zaa Misila, a bo a suḿma tɛ̃tɛ̃ntɛ̃, ");
INSERT INTO bqp_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Isaraila burinↄ tɛ́ pínki n dizi Harunan a sɛ̀ a gbàgbari ũ. Akũ à a gbagba, à turaretiti kàarɛ tɛ́n kũ sa'o'utao dana. Dikiri pì, a sa'opↄ kũ Isarailanↄ dì kpáta kpà a burinↄa pínki. ");
INSERT INTO bqp_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Dikiri pì, bↄ́ mɛ́ à tò adì a sa'ona nↄ̀bↄ zↄ̃ kũ gbáo kũ gba kũ a dìtɛ ò suoarɛ a kpɛ́ gũnwoo? À pì, bↄ́yãi ndì n nɛ́nↄ ditɛ deala, akũ átɛn mɛ̀ kpá kũ a gbɛ̃ Isarailanↄ sa'ona nↄ̀bↄ manaoo? ");
INSERT INTO bqp_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Abire yãi Dikiri Isarailanↄ Luda pì, a dìtɛ yã n burinↄ kũ n dizi burinↄ mɛ́ ògↄ̃ a gbagba ari gↄrↄ sĩnda pínki, ama tera adì we abirekũi doro. À pì, gbɛ̃ kũ à a kpe tàn áni bɛ̀ɛrɛ línɛ, gbɛ̃ kũ à a gya bò áni kɛ pↄ́ ũro. ");
INSERT INTO bqp_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Ǹ ma! À pì, gↄrↄke ni su, áni n bɛ gbãna símma kũ n de bɛ pↄ́o. Mare zĩ ke nigↄ̃ kú n ↄnn doro. ");
INSERT INTO bqp_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Ĩni wari e a bɛa. Bee tó a arubarikaa pìsi Isarailanↄa ń pínki, mare zĩ ke nigↄ̃ kú n ↄnnlo ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","N ↄndenↄ ni gaga zɛ́gbãn ń pínki. N gbɛ̃ kũ adi a bo a gbagbazĩ gũnlo ni tó n wɛ́ bobo kũ ↄ́ↄdↄo, n pↄ ni sira kũ. ");
INSERT INTO bqp_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","N nɛ́ gbɛ̃nↄn pla Ɔfini kũ Finɛasio ni gaga gↄrↄ dokↄ̃nↄ zĩ ń pínki. Abirekũ nigↄ̃ dennɛ sèeda ũ kũ yã kũ a ò ni kɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Dikiri pì, áni gbɛ̃ sɛ́ sa'ori náanide ũ, ani a pↄyenyĩna kɛ lákũ á yei nà. Áni a burinↄ gba gbãna gíngin, anigↄ̃ zĩ kɛ kína kũ áni kánɛ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","N buri kũ ò gↄ̃̀nↄ ni su ò kútɛ kɛnɛ ↄgↄ ke burodi yãi ò pi: Ǹ sa'ori zĩ ke dawɛrɛ ò kɛ, de ò pↄ́ fítinna le ògↄ̃ ble. ");
INSERT INTO bqp_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Nɛ́gↄ̃gbɛ̃ Samuɛli tɛn zĩ kɛ Dikirinɛ Ɛli ↄĩ. Gↄrↄ birea Dikiri yã dì su gbɛ̃a likalikaro, akũ wɛ́gupu'ena kun dasiro. ");
INSERT INTO bqp_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Zĩkea Ɛli wutɛna a wútɛkia. A wɛ́ bùsa, àtɛn gu e manamana doro. ");
INSERT INTO bqp_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samuɛli wutɛna Dikiri kpɛ́n, gu kũ Luda àkpati kunwa. Luda fitila dí ga kↄ̀ro. ");
INSERT INTO bqp_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Akũ Dikiri lɛ́ zù Samuɛlii. À wèa à pì: Makũ dí! ");
INSERT INTO bqp_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Akũ à bàa lɛ̀ à gɛ̀ɛ Ɛli kĩnaa à pì: N lɛ́ zùmain yá? Ma su. Akũ à pìnɛ: Mádi lɛ́ zunyĩro. Ǹ gɛ́ wútɛ. Akũ à ɛ̀ra à gɛ̀ɛ à wùtɛ. ");
INSERT INTO bqp_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Dikiri ɛ̀ra à lɛ́ zùi dↄ, akũ à ɛ̀ra à gɛ̀ɛ Ɛli kĩnaa à pì: N lɛ́ zùmain yá? Ma su. Akũ à pì: Ma nɛ́, mádi lɛ́ zunyĩro. Ǹ gɛ́ wútɛ. ");
INSERT INTO bqp_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuɛli sↄ̃ à Dikiri dↄ̃ gĩaro, Dikiri yã dí sua yã kↄ̀ro. ");
INSERT INTO bqp_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Dikiri ɛ̀ra à lɛ́ zùi a gɛ̃̀n aakↄ̃de, akũ à fùtɛ à gɛ̀ɛ Ɛli kĩnaa dↄ à pì: N lɛ́ zùmain yá? Ma su. Akũ Ɛli dↄ̃̀ sà kũ Dikiri mɛ́ àtɛn lɛ́ zu kɛfɛnna pìii. ");
INSERT INTO bqp_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Akũ à pìnɛ: Ǹ gɛ́ wútɛ. Tó à lɛ́ zùnyĩ sà, ǹ pi: Ǹ yã o Dikiri, n zↄ̀bleri sã dↄ. Akũ Samuɛli gɛ̀ɛ à wùtɛ a wútɛkia. ");
INSERT INTO bqp_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Dikiri sù à zɛ̀ gwe, à lɛ́ zùi lákũ à kɛ̀ yã nà à pì: Samuɛli! Samuɛli! Akũ Samuɛli pì: Ǹ yã o Dikiri, makũ n zↄ̀bleri ma sã dↄ. ");
INSERT INTO bqp_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Akũ Dikiri pìnɛ: Ǹ ma! Mani yã kɛ Isarailanↄ tɛ́, gbɛ̃ kũ à a baaruu mà ni kɛkɛ à sã wɛ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Gↄrↄ birea mani àlesi kũ ma dↄ̀ Ɛli bedenↄa kɛ pínki zaa a naanaa ari a mìdɛnaaa. ");
INSERT INTO bqp_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Ma pìnɛ mani tó yã gↄ̃ wí a bedenↄ musu ari gↄrↄ sĩnda pínki yã vãni kũ à a yã dↄ̃ yãi. A nɛ́nↄ ń zĩda kpe bò, akũ adi gíńnɛro. ");
INSERT INTO bqp_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Abire yãi ma la dà Ɛli bedenↄ yã musu ma pì: Sa'ona ke gbadana ni Ɛli bedenↄ taari kɛ̃ḿma zikiro. ");
INSERT INTO bqp_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuɛli wùtɛ ari gu dↄ̀, akũ à Dikiri kpɛ́ gbànↄ wɛ̃̀wɛ̃. À wɛ́gupu kũ à è ona Ɛlinɛ vĩna vĩ. ");
INSERT INTO bqp_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Akũ Ɛli a sìsi à pì: Samuɛli ma nɛ́! À wèa à pì: Makũ dí! ");
INSERT INTO bqp_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Akũ à a là à pì: À pìnnɛ deraa? Ǹsun yã pì utɛmɛnɛro. Tó n yã kũ à ònnɛ ke ùtɛmɛnɛ, Luda yã kɛnnɛ pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Akũ Samuɛli yã pìi bàbanɛ pínki, adi a ke utɛnɛro. Akũ Ɛli pì: Dikirimɛ a ũ. Lákũ à kɛ̀nɛ mana nà à kɛ. ");
INSERT INTO bqp_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuɛli tɛn zↄ̃kↄ̃ kũ, akũsↄ̃ Dikiri kú kãao. Adi tó yã kũ à òo lɛ̀tɛ pãro. ");
INSERT INTO bqp_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Akũ Isaraila kũ ò kú zaa Dã ari Bɛsɛbanↄ dↄ̃̀ ń pínki sà kũ Samuɛli bi Dikiri annabiimɛ yãpura. ");
INSERT INTO bqp_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Dikiri dìgↄ̃ bo àgↄ̃ su Samuɛlia Silo, gu kũ à a zĩda mↄ̀nɛn káaku. Àdi yã onɛ, akũ Isarailanↄ tɛni a yã ma ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Isarailanↄ bↄ̀tɛ ò gɛ̀ɛ Filisitininↄa kũ zĩ̀io. Ò bùraa kàtɛ Ɛbɛnɛza, Filisitininↄ sↄ̃, Afɛki. ");
INSERT INTO bqp_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Filisitininↄ zĩ̀'ↄ pòro ò gɛ̀ɛo Isarailanↄa. Kũ zĩ̀ gbãna kũ̀, akũ Filisitininↄ Isarailanↄ blè ò ń dɛdɛ zĩ̀lan gwe lán gbɛ̃nↄn wàa baro taka bà. ");
INSERT INTO bqp_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Kũ Isarailanↄ sù ń bùran, ń gbɛ̃ zↄ̃kↄ̃nↄ pì: Bↄ́yãi Dikiri tò Filisitininↄ ó blé kũ zĩ̀io gbãraa? Ò gɛ́ ò Dikiri bàka kunna kũoo àkpati sɛ́ Silo ò suo àgↄ̃ kú kũoo, de àgↄ̃ ó bo ó ibɛrɛnↄ ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Akũ ò gbɛ̃nↄ zĩ̀ Silo ò gɛ̀ɛ ò Dikiri bàka kunna kũńwo àkpatii sɛ̀ ò sùo. Àkũmɛ Dikiri Zĩ̀karide kíblegba ũ kɛrubunↄ dagura. Ɛli nɛ́ gbɛ̃nↄn planↄ Ɔfini kũ Finɛasio kú kũ àkpatii pìio gwe. ");
INSERT INTO bqp_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Kũ ò kao Isarailanↄ bùran, ò fùtɛ kũ pↄnna wikio ń pínki ari zĩtɛ yĩ̀gã. ");
INSERT INTO bqp_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Kũ Filisitininↄ wiki pìi mà, ò pì: Bↄ́ wiki gbãna mɛ́ à dↄ Eberunↄ bùran lɛɛ? Kũ ò dↄ̃̀ Dikiri àkpati mɛ́ à kìpa ń bùran, ");
INSERT INTO bqp_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","vĩna ń kũ ò pì: Tãna ke kìpa ń bùrammɛ. Yã gì kũoo sà! Yã dí taka dí kɛ zikiro. ");
INSERT INTO bqp_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Yã gì kũoo! Dí mɛ́ ani ó bo tãna gbãnade pìnↄ ↄĩi? Tãna pìnↄ mɛ́ ò yã gàtɛ Misilanↄnɛ gbárannan. ");
INSERT INTO bqp_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Ókↄ̃nↄ Filisitininↄ ò swɛ̃̀ ditɛ ò gↄ̃gbɛ̃kɛ kɛ. Tó ódi kɛ lɛro, óni zↄ̀ ble Eberunↄnɛ lákũ òtɛn blewɛrɛ nà. Ò gↄ̃gbɛ̃kɛ kɛ ò zĩ̀ ká kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Akũ Filisitininↄ fùtɛ Isarailanↄa kũ zĩ̀io ò ń fu, akũ ń baadi bàa lɛ̀ ò tà bɛ, zaakũ ń dɛdɛnaa kɛ̀ dasi. Filisitininↄ ń gbɛ̃ kũ ò tɛ́ gɛ̀sɛnↄ dɛ̀dɛ gbɛ̃nↄn dúbu baraakuri. ");
INSERT INTO bqp_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Ò Luda àkpatii sì, akũ ò Ɛli nɛ́ gbɛ̃nↄn planↄ Ɔfini kũ Finɛasioo dɛ̀dɛ. ");
INSERT INTO bqp_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Biliaminu buri gbɛ̃ke bò zĩ̀lan à bàa lɛ̀ à gɛ̀ɛ Silo zĩ pìia. À a pↄ́kasanↄ gà à kɛ̃̀kɛ̃ à bùsuu kù a mìia. ");
INSERT INTO bqp_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Kũ à kà, à Ɛli lè vutɛna gbàaa zɛ́ sarɛ, àtɛn gu dãkpã, zaakũ a laakari kpatɛnaro Luda àkpati yãi. Kũ gbɛ̃ pìi gɛ̃̀ wɛ̃tɛn, à baaruu kpà wɛ̃tɛdenↄnɛ, akũ òtɛn ↄ́ↄ dↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Kũ Ɛli wiki pìi mà à pì: Zuka dí bò máa? Akũ gbɛ̃ pìi kɛ̀ likalika à gɛ́ onɛ. ");
INSERT INTO bqp_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Ɛli zĩ kũ̀ à kà wɛ̃̀ basↄↄro plansari, a wɛ́ gↄ̃̀ dãadãa, adi gu e doro. ");
INSERT INTO bqp_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Akũ gbɛ̃ pìi pìnɛ: Teran ma bo zĩ̀lan, ma bo zaa gwe kũ bàao gbãramɛ. Akũ Ɛli a là à pì: Bↄ́ mɛ́ à kɛ̀ gwee, ma gbɛ̃? ");
INSERT INTO bqp_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Baarukparii pìi wèa à pì: Isarailanↄ bàa lɛ̀ Filisitininↄnɛ, akũ Filisitininↄ ń dɛdɛ dasidasi. N nɛ́ gbɛ̃nↄn planↄ Ɔfini kũ Finɛasio gà dↄ. Ò Luda àkpatii sìḿma dↄ. ");
INSERT INTO bqp_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Kũ à Luda àkpati yã ò, Ɛli bò a gbàaa à lɛ̀tɛ kpɛdangara wɛ̃tɛ bĩnilɛ sarɛ, akũ a wakaa ɛ̀ à gà, zaakũ à zĩ kũ̀, akũsↄ̃ gbɛ̃ kãnamɛ. À dò Isarailanↄnɛ arɛ ari wɛ̃̀ bupla. ");
INSERT INTO bqp_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Ɛli nɛ́ Finɛasi nanↄ nↄ̀sina, à kà nɛ́'ina. Kũ à Luda àkpati sina baaruu mà kũ a zã de ganaao kũ a zã ganaao, akũ à kùtɛ à nɛ́ ì, zaakũ nↄ̀wãwã fùtɛa. ");
INSERT INTO bqp_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Kũ àtɛn gbãsĩ lɛ́, gbɛ̃ kũ ò a kũkũnanↄ pìnɛ: Ǹsun tó vĩna n kũro, zaakũ n nɛ́ ì gↄ̃gbɛ̃ ũ. Ama adi weḿmaro, adi ń yã daro. ");
INSERT INTO bqp_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Akũ à tↄ́ kpà nɛ́ pìinɛ Ikabodu à pì: Isarailanↄ gakuri kↄ̀ↄ ɛ̀. Zaakũ ò Luda àkpatii sìḿma, akũsↄ̃ a zã de kũ a zão gàga dↄ. ");
INSERT INTO bqp_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","À pì: Isarailanↄ gakuri kↄ̀ↄ ɛ̀, zaakũ ò Luda àkpatii sìḿma. ");
INSERT INTO bqp_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Kũ Filisitininↄ Luda àkpatii sì, ò bòo Ɛbɛnɛza ò tào Asadↄdi. ");
INSERT INTO bqp_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Akũ ò gɛ̃̀o ń tãna Dagↄ̃ kpɛ́n ò dìtɛ a sarɛ. ");
INSERT INTO bqp_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Kũ gu dↄ̀, Asadↄdidenↄ fùtɛ kↄnkↄkↄnkↄ, akũ ò è Dagↄ̃ lɛ̀tɛ zĩtɛ a gbɛrɛa Dikiri àkpati arɛ. Akũ ò Dagↄ̃ sɛ̀ ò vùtɛ a gbɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Kũ gu dↄ̀ dↄ, ò fùtɛ kↄnkↄkↄnkↄ, akũ ò è Dagↄ̃ lɛ̀tɛ zĩtɛ a gbɛrɛa dↄ Dikiri àkpati arɛ. A mì kũ a ↄnↄ wòwokↄ̃a katɛna kpɛ́lɛlɛ gbĩ̀ia. A gbãn mɛ́ à gↄ̃̀ ditɛna ado. ");
INSERT INTO bqp_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Abire yãi Dagↄ̃ gbàgbarinↄ kũ gbɛ̃ kũ òtɛn gɛ̃ a kpɛ́n Asadↄdinↄ dì gɛ̀sɛ pɛ́tɛ a kpɛ́ kpɛ́lɛlɛ gbĩ̀iaro ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Dikiri ↄ tↄ̃̀ Asadↄdidenↄa à ń ásaru kɛ̀ à gbɛ̀nna kàńgu, Asadↄdi kũ a lakutunↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Kũ Asadↄdidenↄ è lɛ, ò pì: Isarailanↄ tãna àkpati ni le àgↄ̃ kú kũoo la doro, zaakũ àtɛn ↄ tↄ̃wá kũ ó tãna Dagↄ̃o pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Akũ ò gbɛ̃nↄ zĩ̀ ò ń kínanↄ kàkara ń pínki, akũ ò ń lá ò pì: Deran óni kɛ nà kũ Isarailanↄ tãna àkpatiioo? Akũ ò pì: Ò gɛ́o Gata. Akũ ò gɛ̀ɛo. ");
INSERT INTO bqp_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Kũ ò kào gwe, Dikiri ↄ tↄ̃̀ wɛ̃tɛ gwe denↄa dↄ, akũ wɛ̃tɛ pìi wã̀. Dikiri gagagyã kàńgu, gbɛ̀nna dàńla ń pínki nɛ́ fíti gbɛ̃ zↄ̃kↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Akũ ò gɛ̀ɛ kũ Luda àkpatii pìio Ɛkɛrↄnu. Kũ òtɛn gɛ̃o, wɛ̃tɛpidenↄ wiki lɛ̀ ò pì: Ò gɛ̃̀wái kũ Isarailanↄ tãna àkpatiio, de ò ó dɛdɛ ó buriamɛ. ");
INSERT INTO bqp_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Akũ ò gbɛ̃nↄ zĩ̀ ò ń kínanↄ kàkara ń pínki ò pìńnɛ: À Isarailanↄ tãna àkpati sɛ́ à táo a gbɛ̀n, de àsun ó dɛdɛ ó buriaro. Zaakũ gaga tò wɛ̃tɛ pìi wã̀, Luda ↄ tↄ̃̀ḿma gwe manamana. ");
INSERT INTO bqp_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Gbɛ̀nna kà gbɛ̃ kũ odi garonↄgu, akũ wɛ̃tɛpidenↄ wiki kà ludambɛ. ");
INSERT INTO bqp_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Dikiri àkpati kú Filisitininↄ bùsun ari mↄ suppla, ");
INSERT INTO bqp_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","akũ ò sa'orinↄ kũ màsokɛrinↄ kàkara ò ń lá ò pì: Deran óni kɛ nà kũ Dikiri àkpatiioo? À owɛrɛ lákũ óni kɛ nà ò táo a gbɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Akũ ò wèḿma ò pì: Tó átɛn tá kũ Isarailanↄ tãna àkpatiio, àsun táo koriro. À a gba pↄ́ á taari yãi, áni aafia le, áni yã kũ à tò adi ↄ goáwaro dↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Akũ ò ń lá ò pì: Bↄ́n óni a gba ò táo ó taari yãii? Ò wèḿma ò pì: À wura pi lán gbɛ̀nna bà mɛ̀n sↄↄro kũ ɛ̃nɛnↄ dↄ mɛ̀n sↄↄro á kínanↄ dasi lɛ́n, zaakũ gyã dokↄ̃nↄ pì á lé kũ á kínanↄ á pínki. ");
INSERT INTO bqp_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","À á gbɛ̀nnanↄ taka pi kũ ɛ̃nɛ kũ òtɛni ó bùsu yaka takanↄ, à Isarailanↄ tãna kpe tao. Ke ani ↄ gowá kũ ó tãnanↄ kũ ó bùsuuo gwɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Bↄ́yãi á ye à sãgbãna kɛ lákũ Misilanↄ kũ Firi'aunao kɛ̀ nàa? Kũ à ń wɛ́ tã̀ ari ò Isarailanↄ gbàrɛ ò tà, a yã dí dↄáguroo? ");
INSERT INTO bqp_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Tera sà à gɛ́ à zùgo dufu kɛ, à su kũ zù nɛ́rande mɛ̀n pla kũ òdi gbãngo dańnɛ yãronↄ. À gó pì dↄḿma, à ń nɛ́ kũ ò tɛ́ńyĩnↄ kɛ̃ḿma à tá kũńwo ń karaa gũn. ");
INSERT INTO bqp_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","À Dikiri àkpati sɛ́ à da gó pìi gũn, à wura pↄ́ kũ átɛn kpãzã á taari yãinↄ ká batan à ditɛ àkpatii pìi sarɛ, à zùnↄ ká zɛ́n ò gɛ́o ");
INSERT INTO bqp_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","àgↄ̃ gwa. Tó àkpatii pì a bùsu zɛ́ sɛ̀ àtɛn gɛ́ Bɛsɛmɛsi kpa, àkũ mɛ́ à kisira zↄ̃kↄ̃ↄ pìi zĩ̀wá. Tó adi sɛ́tɛ gwe sↄ̃ro, ónigↄ̃ dↄ̃ kũ àkũ mɛ́ à ↄ tↄ̃̀wáro, yã mɛ́ à sù lɛ. ");
INSERT INTO bqp_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Akũ ò kɛ̀ lɛ, ò gó dↄ̀ zù nɛ́rande mɛ̀n planↄa ò ń nɛ́nↄ kà kara gũn, ");
INSERT INTO bqp_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","akũ ò Dikiri àkpatii dà gó pìi gũn kũ bata kũ wura ɛ̃nɛnↄ kũ gbɛ̀nna takanↄn kú a gũnwo. ");
INSERT INTO bqp_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Akũ zùu pìnↄ zɛ́ sɛ̀ súsu ò arɛ dↄ Bɛsɛmɛsi zɛ́a, òtɛn gɛ́ òtɛn ↄ́ↄ dↄ, odi litɛ ↄplai ke ↄzɛiro. Filisitini kínanↄ tɛ́ ń kpɛ ari Bɛsɛmɛsi bùsu lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Bɛsɛmɛsidenↄ tɛn pↄ́wɛ kɛkɛ guvutɛn. Kũ ò wɛ́ sɛ̀ musu, ò àkpatii pìi è, akũ ń pↄ kɛ̀ nna kũ a enaao. ");
INSERT INTO bqp_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Kũ gó pìi kà Bɛsɛmɛsi gbɛ̃ Yↄsua búgbɛɛa, akũ à zɛ̀ gbɛ̀ gbɛ̃̀ntɛ̃ɛ sarɛ gwe. Akũ Levinↄ Dikiri àkpatii pìi bò kũ bata kũ wura pↄ́nↄn kú a gũnwo, ò kàtɛ gbɛ̀ gbɛ̃̀ntɛ̃ɛ pìia. Akũ Bɛsɛmɛsidenↄ gó pì lí zↄ̃̀zↄ̃kↄ̃rɛ yàka ũ, ò sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ ò Dikiria kũ zùu pìnↄ. Zĩ pìia ò sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũnↄ ò Dikiria kũ sa'opↄ pãndenↄ. ");
INSERT INTO bqp_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Filisitini kína gbɛ̃nↄn sↄↄronↄ yã pìi è, akũ ò ɛ̀ra ò tà Ɛkɛrↄnu zĩ pìia. ");
INSERT INTO bqp_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Wura gbɛ̀nna kũ Filisitininↄ kpã̀zã Dikirinɛ ń taari yãinↄn dí: Asadↄdi pↄ́ do, Gaza pↄ́ do, Asakɛlↄni pↄ́ do, Gata pↄ́ do, Ɛkɛrↄnu pↄ́ do. ");
INSERT INTO bqp_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Wura ɛ̃nɛnↄ kun dↄ Filisitini wɛ́ra pìnↄ dasi lɛ́n, ń kína gbɛ̃nↄn sↄↄronↄ pↄ́ ũ. Ń wɛ́ra bĩnide pìnↄ baadi kũ a lakutunↄ. Gbɛ̀ gbɛ̃̀ntɛ̃ kũ ò Dikiri àkpatii dìtɛa Bɛsɛmɛsi gbɛ̃ Yↄsua búgbɛɛaa pìimɛ sèeda ũ ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Akũ Dikiri Bɛsɛmɛside kenↄ dɛ̀dɛ, kũ ò a àkpatii gũn gwà yãi. À ń dɛdɛ gbɛ̃nↄn baaakↄ̃ akurimɛ, akũ ò wɛ̃nda ↄ́ↄ dↄ̀, kũ Dikiri kakatɛ zↄ̃kↄ̃ↄ kpàńyĩ yãi. ");
INSERT INTO bqp_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Akũ Bɛsɛmɛsidenↄ pì: Dí mɛ́ ani fↄ̃ à zɛ Dikiri Luda kũ à kú adona pì arɛɛ? Óni àkpatii pì kpãzã dínↄ kĩnaa sàa? ");
INSERT INTO bqp_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Akũ ò gbɛ̃nↄ zĩ̀ Kiriayarimudenↄa ò pì: Filisitininↄ sù kũ Dikiri àkpatiio. À mↄ́ à sɛ́ à táo á kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Akũ Kiriayarimudenↄ sù ò Dikiri àkpatii pìi sɛ̀ ò tào Abinadabu bɛa sĩ̀sĩi musu. Akũ ò a nɛ́ Ɛlɛaza dìtɛ a dãkpãri ũ. ");
INSERT INTO bqp_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Àkpatii pì kú Kiriayarimu à gìi kɛ̀, à kɛ̀ gwe wɛ̃̀ baro. Isarailanↄ tɛn wiki lɛ́ Dikiria ń pínki, òtɛni a ki wɛtɛ. ");
INSERT INTO bqp_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Akũ Samuɛli pì Isarailanↄnɛ ń pínki: Tó a arɛ dↄ̀ Dikiria kũ nɛ̀sɛ mɛ̀n doo, à buri zĩ̀tↄnↄ tãnanↄ kũ Asatorɛnↄ bↄtɛ á tɛ́, à á zĩda kpá Dikiria àgↄ̃ doi ado, ani á bo Filisitininↄ ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Akũ Isarailanↄ Baalinↄ kũ Asatorɛnↄ bↄ̀tɛ ń tɛ́, òtɛn do Dikirii ado. ");
INSERT INTO bqp_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Akũ Samuɛli pì: Ákↄ̃nↄ Isarailanↄ à kↄ̃ kakara Mizipa á pínki, mani kútɛ kɛárɛ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Kũ ò kↄ̃ kàkara gwe, akũ ò í tↄ̀ ò kↄ̀tɛ Dikiri arɛ. Zĩ birea ò lɛ́ yĩ̀ ò pì: O durunna kɛ̀ Dikirinɛ. Akũ Samuɛli yã gↄ̃̀gↄ̃ Isarailanↄnɛ Mizipa gwe. ");
INSERT INTO bqp_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Kũ Filisitininↄ mà Isarailanↄ kↄ̃ kàkara Mizipa, akũ ń kínanↄ gɛ̀ɛ lɛ́tɛḿma. Kũ Isarailanↄ mà, vĩna ń kũ, ");
INSERT INTO bqp_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","akũ ò ò Samuɛlinɛ: Ǹsungↄ̃ yĩtɛnaro! Ǹ wiki lɛ́ Dikiri ó Ludaa de à ó sí Filisitininↄa. ");
INSERT INTO bqp_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Akũ Samuɛli sãnɛ yↄ̃miri sɛ̀ à sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ ò Dikiria, akũ à wiki lɛ̀a Isarailanↄnɛ. Akũ Dikiri sì kãao. ");
INSERT INTO bqp_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Kũ Samuɛli tɛn sa pì o, Filisitininↄ tɛn su Isarailanↄa kũ zĩ̀io. Zĩ birea Dikiri tò legũ gbãna pàta Filisitininↄa. Swɛ̃̀ɛ kɛ̃̀ńgu ò lɛ̀kↄ̃a, akũ Isarailanↄ ń ásaru kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Kũ Isarailanↄ bↄ̀tɛ Mizipa ò pɛ̀ Filisitininↄa, ò ń dɛdɛ ò ń kpá ari Bɛtɛka. ");
INSERT INTO bqp_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Akũ Samuɛli gbɛ̀ɛ pɛ̀tɛ Mizipa kũ Sɛnio dagura à tↄ́ kpànɛ Ɛbɛnɛza, zaakũ à pì: Dikiri mɛ́ à kpàwái ari o ka la. ");
INSERT INTO bqp_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Lɛn ò Filisitininↄ fù lɛ, akũ odi fↄ̃ ò ɛ̀ra ò sùḿma kũ zĩ̀io ń bùsun doro. Dikiri ↄ tↄ̃̀ Filisitininↄa ari Samuɛli kunna gↄrↄ zakan. ");
INSERT INTO bqp_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Wɛ̃tɛ kũ Filisitininↄ sì Isarailanↄa yãnↄ ɛ̀ra à gↄ̃̀ ń pↄ́ ũ zaa Ɛkɛrↄnu ari à gɛ̀ɛ pɛ́ Gataa. Isarailanↄ wɛ̃tɛ pìnↄ kũ ń bùsunↄ sì Filisitininↄa pínki. Isarailanↄ kũ Amↄrinↄ sↄ̃ ò kú kũ kↄ̃o yãkete sari. ");
INSERT INTO bqp_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuɛli bi Isarailanↄ don'arɛdemɛ ari a kunna gↄrↄ zakan. ");
INSERT INTO bqp_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Wɛ̃̀ kũ wɛ̃̀ɛo àdigↄ̃ gɛ́ Bɛtɛli kũ Giligalao kũ Mizipao, àdi yã gↄ̃gↄ̃ Isarailanↄnɛ wɛ̃tɛ pìnↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Akũ àdi ɛra à tá Rama, zaakũ a bɛn gwe. Àdi yã gↄ̃gↄ̃ Isarailanↄnɛ gwe dↄ. Gwen à Dikiri gbagbaki bòn. ");
INSERT INTO bqp_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Kũ Samuɛli zĩ kũ̀, à a nɛ́nↄ dìtɛ Isarailanↄnɛ don'arɛdenↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","A daudu tↄ́n Yoɛli, a plade Abia. Mↄ́kↄ̃nↄ mɛ́ òdi yã gↄ̃gↄ̃ńnɛ Bɛsɛba. ");
INSERT INTO bqp_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Ama a nɛ́ pìnↄ dí tɛ́ a ágbairo. Ɔgↄyã ń swɛ̃̀ɛ blè, òdi gusarɛgba sí, òdi yã gↄ̃gↄ̃ a zɛ́aro. ");
INSERT INTO bqp_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Akũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kↄ̃ kàkara, ò gɛ̀ɛ ò Samuɛli lè Rama ");
INSERT INTO bqp_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","ò pì: Ǹ gwa, n zĩ kũ̀, akũ n nɛ́nↄn tɛ́ n ágbairo. Ǹ kína ditɛwɛrɛ sà de àgↄ̃ de ó don'arɛde ũ, lán buri sĩnda pínki a pↄ́ vĩ nà. ");
INSERT INTO bqp_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Kũ ò pì à kína káńnɛ àgↄ̃ de ń don'arɛde ũ, yã pì dí kɛ Samuɛlinɛ nnaro, akũ à wɛ́ kɛ̀ Dikiria. ");
INSERT INTO bqp_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Akũ Dikiri pì Samuɛlinɛ: Ǹ gbɛ̃ pìnↄ yã ma, zaakũ mↄkↄ̃mmɛ ò gìnyĩro. Makũmɛ ò gìmai de màsun kí bleḿmaro yãi. ");
INSERT INTO bqp_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Lákũ òtɛn kɛ nà zaa gↄrↄ kũ ma ń bↄtɛ Misila ari gbãra, ò pã kpàmai ò dò tãnanↄi, lɛn òtɛn kɛnnɛ lɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ǹ ń yã ma sà, ǹ lɛ́ daḿma ǹ tó ògↄ̃ dↄ̃ lákũ gbɛ̃ kũ ani kí bleḿma yãnↄ nigↄ̃ de nà. ");
INSERT INTO bqp_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Akũ Samuɛli Dikiri yã pìi bàba gbɛ̃ kũ òtɛn kína gbɛkaanↄnɛ pínki ");
INSERT INTO bqp_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","à pì: Lákũ gbɛ̃ kũ ani kí bleáwa yãnↄ nigↄ̃ de nàn dí. Ani á nɛ́gↄ̃gbɛ̃nↄ sí à ń ditɛ a sↄ̃godenↄ kũ a sↄ̃denↄ ũmɛ. Onigↄ̃ táa o a sↄ̃go arɛ kũ bàao. ");
INSERT INTO bqp_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Ani ń ditɛ gbɛ̃nↄn wàa sↄsↄↄro ke gbɛ̃nↄn bupla akurikurinↄ gbɛ̃ zↄ̃kↄ̃nↄ ũ. Onigↄ̃ a bú wínɛ, onigↄ̃ a pↄ́nↄ kɛkɛnɛ, onigↄ̃ a zĩ̀kabↄnↄ pinɛ kũ a sↄ̃go pↄ́nↄ. ");
INSERT INTO bqp_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Ani á nɛ́nↄgbɛ̃nↄ sí à ń ditɛ nísigbĩnnakɛrinↄ kũ pↄ́blekɛrinↄ kũ burodikɛrinↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Ani á buranↄ kũ á geepi búnↄ kũ á kùkpɛ mananↄ síáwa à kpá a ìbanↄa. ");
INSERT INTO bqp_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Ani á pↄ́wɛnↄ kũ á geepi nɛ́nↄ lɛu kuride síáwa à kpá a bɛgwarinↄ kũ a ìbanↄa. ");
INSERT INTO bqp_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Ani á zↄ̀gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ sí kũ á zù mananↄ kũ á zaakinↄ àgↄ̃ a zĩda zĩ kɛo. ");
INSERT INTO bqp_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Ani á pↄ́kãdenↄ lɛu kuride síáwa, ákↄ̃nↄ áni gↄ̃ a zↄ̀nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Gↄrↄ birea sà áni wiki lɛ́ Dikiria gbɛ̃ kũ a sɛ̀ á kína ũ pì yãi, ama ani weáwa gↄrↄ birea doro. ");
INSERT INTO bqp_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Akũ ò gì Samuɛli yã mai ò pì: Oi! Ó ye ògↄ̃ kína vĩmɛ, ");
INSERT INTO bqp_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","ónigↄ̃ de lán buri kparanↄ bà se. Ó kína mɛ́ anigↄ̃ yã gↄ̃gↄ̃wɛrɛ, anigↄ̃ dowɛrɛ arɛ zĩ̀i gũn. ");
INSERT INTO bqp_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Kũ Samuɛli ń yã mà pínki, à gɛ̀ɛ à dà Dikirinɛ a sãn. ");
INSERT INTO bqp_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Akũ Dikiri pìnɛ: Ǹ ń yã ma, ǹ kína káńnɛ. Akũ Samuɛli pì Isaraila pìnↄnɛ: Á baadi tá a wɛ̃tɛa. ");
INSERT INTO bqp_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Biliaminu buri ke kun, a tↄ́n Kisi. Aruzɛkɛdemɛ. Biliaminu buri mɛ́ à Afia ì, Afia Bekora ì, Bekora Zero ì, Zero Abiɛli ì, akũ Abiɛli Kisi pìi ì. ");
INSERT INTO bqp_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","À nɛ́gↄ̃gbɛ̃ vĩ, a tↄ́n Solu. Kɛfɛnna manamɛ. A mana sára kú Isarailanↄ tɛ́ro, ń gbɛ̃ke gbã̀na dí vĩ a gã̀nlaro. ");
INSERT INTO bqp_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Kũ Kisi pì zaakinↄ sã̀tɛ, akũ à pì a nɛ́ pìinɛ: Ǹ futɛ ǹ zĩkɛrinↄ doke sɛ́ à gɛ́ zaaki pìnↄ wɛtɛ. ");
INSERT INTO bqp_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Akũ ò Ɛflaimu bùsu gusĩsĩde pàra kũ Salisa bùsuuo, odi ń lero. Akũ ò Salimu bùsuu pàra, ama ò kú gwero. Akũ ò Biliaminu bùsuu pàra, odi zaaki pìnↄ lero. ");
INSERT INTO bqp_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Kũ ò kà Zufu bùsun, Solu pì zĩkɛri kũ ò lɛɛlɛ pìinɛ: Ǹ mↄ́ ò ɛra. Tó ódi táro, ma mare ni damu kɛ ó yã musu, ani zaakinↄ yã da doro. ");
INSERT INTO bqp_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Akũ à wèa: Ǹ ma! Luda gbɛ̃ke kú wɛ̃tɛ dí gũn. À bɛ̀ɛrɛ vĩ, yã kũ à pì ani kɛ, àdi kɛmɛ. Ò gɛ́ gwe. Ke ani zɛ́ kũ óni sɛ́ ò ó zaaki pìnↄ leo owɛrɛ gwɛɛ. ");
INSERT INTO bqp_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Akũ Solu wèa à pì: Tó ótɛn gɛ́, bↄ́n óni gɛ́onɛɛ? Pↄ́ble ke dí gↄ̃ ó bↄ̀kↄn doro. Ó pↄ́ke vĩ ò Luda gbɛ̃ pì gbaro. Ke bↄ́n ó vĩi? ");
INSERT INTO bqp_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Akũ zĩkɛrii pìi ɛ̀ra à pì Solunɛ: Ǹ gwa! Má ↄgↄ vĩ fítinle la. Mani a gba, ani ó da zɛ́ kũ à de ò sɛ́a. ");
INSERT INTO bqp_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","Isarailanↄ bùsun yã, tó gbɛ̃ tɛn gɛ́ yã gbɛka Ludaa àdi pi: Ǹ mↄ́ ò gɛ́ wɛ́gupu'eri kĩnaa. Zaakũ gbɛ̃ kũ òdi pi gbãra annabi ũ gbãra, àkũmɛ òdi sísi yã wɛ́gupu'eri ũ. ");
INSERT INTO bqp_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Akũ Solu pì a zĩkɛriinɛ: N yã mana ò. Ò gɛ́. Akũ òtɛn gɛ́ wɛ̃tɛ kũ Luda gbɛ̃ pì kunwa. ");
INSERT INTO bqp_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Kũ òtɛn wɛ̃tɛ pìi sĩ̀sĩ kũ, ò dàkarɛ kũ nↄkparenↄ, òtɛn gɛ́ í tↄ́. Akũ ò ń lá ò pì: Wɛ́gupu'eri kú bɛ yá? ");
INSERT INTO bqp_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Ò wèḿma ò pì: Ee, à kú arɛ gwe. À kɛ likalika. Gbãran à sù, zaakũ ò ye ò sa o gbagbakiamɛ. ");
INSERT INTO bqp_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Tó a gɛ̃ wɛ̃tɛn, áni a e ari àgↄ̃ gɛ́ pↄ́ ble gbagbaki pìia. Zaakũ oni pↄ́ ble gĩaro ari à su, àkũ mɛ́ ani arubarika da sa'opↄblen gĩa, gbasa gbɛ̃ kũ ò ń sísinↄ pↄ́ ble. Àgↄ̃ wãna, zaakũ a lenagↄrↄn dí. ");
INSERT INTO bqp_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Kũ ò gɛ̃̀ wɛ̃tɛ pìi gũn, akũ ò dàkarɛ kũ Samuɛlio gↄ̃̀nↄ, à bò àtɛn gɛ́ gbagbaki pìia. ");
INSERT INTO bqp_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Ari Solu gↄ̃ gɛ́ su, Dikiri gĩnakɛ à yã dí dà Samuɛlinɛ a sãn à pì: ");
INSERT INTO bqp_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","Zia mandara'i mani Biliaminu bùsu gbɛ̃ zĩmma. Ǹ nísi kúa ǹ a ditɛ ma gbɛ̃ Isarailanↄ don'arɛde ũ. Ani ma gbɛ̃ pìnↄ bo Filisitininↄ ↄĩ. Ma a gbɛ̃ pìnↄ wiki mà, akũ ma ń wɛ̃nda gwà. ");
INSERT INTO bqp_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Kũ Samuɛli Solu è, Dikiri pìnɛ: Gbɛ̃ kũ ma a yã ònnɛ pìin gwe. Àkũ mɛ́ ani kí ble ma gbɛ̃nↄa. ");
INSERT INTO bqp_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Akũ Solu nà Samuɛlii wɛ̃tɛ bĩnilɛa à a là à pì: Wɛ́gupu'eri bɛ kú mámɛɛ? Ǹ mↄmɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Akũ Samuɛli wèa à pì: Makũmɛ ade pì ũ. Ǹ domɛnɛ arɛ ò gɛ́ gbagbakia, ĩni pↄ́ ble kũmao gbãra. Zia kↄnkↄ mani n nɛ̀sɛgũnyã onnɛ pínki, gbasa mà n gbarɛ. ");
INSERT INTO bqp_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Ǹsun n zaaki kũ ò sã̀tɛ zaa gↄrↄ aakↄ̃ damu kɛro, zaakũ ò ń lé. Dín Isarailanↄn yei ń pínkii, tó adi kɛ mↄkↄ̃n kũ n de bedenↄ baasiro? ");
INSERT INTO bqp_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Akũ Solu pì: Biliaminu burin ma ũroo? Ma buri mɛ́ à fíti de Isaraila burinↄla ń pínki, akũ ma danɛnↄ mɛ́ ò kĩ̀ańyĩ Biliaminu burinↄ tɛ́. Bↄ́yãi ntɛn yã dí taka omɛnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Akũ Samuɛli Solu kũ a zĩkɛriioo sɛ̀ à gɛ̃̀ kũńwo pↄ́blekpɛn, à vutɛki mana kpàḿma gbɛ̃ kũ ò ń sísinↄ tɛ́. Gbɛ̃ pìnↄ kà gbɛ̃nↄn baraakuri taka bà. ");
INSERT INTO bqp_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Akũ Samuɛli pì pↄ́blekɛriinɛ: Ǹ nↄ̀bↄ kũ ma kpàmma ma pì ǹ a ditɛki kɛ pì sɛ́ ǹ mↄ́o. ");
INSERT INTO bqp_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Akũ pↄ́blekɛrii pìi sù kũ nↄ̀bↄ gbá pìio à dìtɛ Solu arɛ. Akũ Samuɛli pì: Pↄ́ kũ ò dìtɛnnɛn dí. Ǹ só, zaakũ ò dìtɛnnɛ ari mandara'i kũ gbɛ̃ kũ ma ń sísinↄ. Akũ Solu pↄ́ blè kũ Samuɛlio zĩ birea. ");
INSERT INTO bqp_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Kũ ò kìpa gbagbaki pìia, ò gɛ̃̀ wɛ̃tɛ gũn, akũ Samuɛli gɛ̀ɛ à yã ò kũ Soluo a kpɛ́ musu. ");
INSERT INTO bqp_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Akũ ò ì gwe. Kũ gu ye à dↄ, akũ Samuɛli lɛ́ zù Solui kpɛ́ musu gwe à pì: Ǹ futɛ, mà gɛ́ zɛnnɛ. Kũ Solu fùtɛ, àkũ kũ Samuɛlio ò bò bàai ń pla. ");
INSERT INTO bqp_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Kũ ò kà wɛ̃tɛ kpɛ, akũ Samuɛli pì Solunɛ: Ǹ o n zĩkɛriinɛ àgↄ̃ gɛ́, mↄkↄ̃n ǹ zɛ gĩa de mà yã kũ Dikiri ò onnɛ. ");
INSERT INTO bqp_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Akũ Samuɛli nísi tùruu sɛ̀ à nísi kù Solunɛ a mìia, akũ à lɛ́ pɛ̀a à pì: Dikiri mɛ́ à n ditɛ don'arɛde ũ a gbɛ̃ Isarailanↄnɛ. Ĩni kí ble Dikiri gbɛ̃nↄa ǹ ń bo ń ibɛrɛ kũ ò likańyĩnↄ ↄĩ. Sèeda kũ ani tó ǹ dↄ̃ kũ Dikiri mɛ́ à n ditɛ a gbɛ̃nↄ don'arɛde ũn dí. ");
INSERT INTO bqp_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Tó o kɛ̃kↄ̃a la tera, ĩni da gbɛ̃nↄn planↄlɛ Zɛlɛza, Rahila mira sarɛ, Biliaminu bùsu lɛ́i. Oni pinnɛ: Ò zaaki kũ n gɛ wɛtɛnↄ lè. Ń yã n de kũna gbãna doro, n yãn àtɛni a damu kɛi sà, àtɛn pi deran áni kɛ a nɛ́ yã musu nàa? ");
INSERT INTO bqp_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Bona gwe, tó n tɛ arɛ, tó n ka gbiri lí kũ̀ kĩnaa zaa Tabo, gbɛ̃nↄn aakↄ̃ ni danlɛ gwe dↄ, òtɛn gɛ́ Luda gbagba zaa Bɛtɛli. Ń gbɛ̃ do blènɛnↄ kũna mɛ̀n aakↄ̃, ń gbɛ̃ do burodi kũna mɛ̀n aakↄ̃, akũ ń gbɛ̃ do sèwɛ̃ kũna tùru do. ");
INSERT INTO bqp_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Oni n aafia gbɛka, oni burodi mɛ̀n pla kpámma, ń sí. ");
INSERT INTO bqp_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Abire gbɛra tó n ka Luda sĩ̀sĩ kũ à kú Gibɛa, gu kũ Filisitininↄ gudãkpãki kún, tó n ka kãni kũ wɛ̃tɛ pìio, ĩni dakarɛ kũ annabinↄ ò tɛ́tɛkↄ̃i, òtɛn kipa gbagbakia. Òtɛn dońnɛ arɛ kũ mↄrↄnↄ kũ gã̀gãnↄ kũ gidigbonↄ kũ kutɛnↄ, òtɛn annabikɛyã o. ");
INSERT INTO bqp_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Dikiri Nini ni summa, ĩni annabikɛyã o kũńwo, ĩni li gbɛ̃ dufu ũ. ");
INSERT INTO bqp_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Tó sèeda birenↄ kɛ̀ lɛ, ǹ yã kũ n a kɛna zɛ́ è kɛ, zaakũ Luda kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Ǹ domɛnɛ arɛ gɛna Giligala, mani n le gwe, mani sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ o kũ kɛnnakũkↄ̃o sa'opↄo. Ǹ ma dã gwe ari gↄrↄ suppla, mani su mà n le gwe, mani yã kũ ĩni kɛ onnɛ. ");
INSERT INTO bqp_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Kũ Solu kpɛ lì Samuɛlinɛ, àtɛn tá, Luda a nɛ̀sɛɛ lìtɛnɛ, akũ sèedaa pìnↄ kɛ̀ zĩ birea pínki. ");
INSERT INTO bqp_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Kũ ò kà Gibɛa, annabinↄ dàalɛ ò tɛ́tɛkↄ̃i, akũ Luda Nini sùa, àtɛn annabikɛyã o kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Kũ gbɛ̃ kũ ò a dↄ̃nↄ a è, àtɛn annabikɛyã o kũ annabinↄ, ò kↄ̃ là ò pì: Bↄ́ mɛ́ à Kisi nɛ́ lèe? Solu kú annabinↄ tɛ́ see? ");
INSERT INTO bqp_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Akũ Gibɛa gbɛ̃ke yã wèḿma à pì: Gbɛ̃ kparanↄ denↄmɛ dínↄ ũ sↄ̃ↄ? Akũ à gↄ̃̀ baaru pↄ́ ũ òdi pi: Solu kú annabinↄ tɛ́ see? ");
INSERT INTO bqp_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Kũ Solu annabikɛyã ò à làka, akũ à gɛ̀ɛ gbagbaki pìia. ");
INSERT INTO bqp_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Kũ Solu tà bɛ kũ a zĩkɛriio, a disɛ̃ ń lá à pì: A gɛ mámɛɛ? Solu wèa à pì: O gɛ zaakinↄ wɛtɛmɛ. Kũ ódi ń ero, akũ o gɛ Samuɛli kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Akũ Solu disɛ̃ pìnɛ: Yã kũ Samuɛli òárɛ babamɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Akũ Solu pì: À pìwɛrɛ ò zaaki pìnↄ lè. Ama adi kpata yã kũ Samuɛli òarɛ babanɛro. ");
INSERT INTO bqp_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Akũ Samuɛli Isarailanↄ kàkara Dikiri arɛ Mizipa. ");
INSERT INTO bqp_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","À pìńnɛ: Dikiri á Luda pì, a á bↄ́tɛ Misila, a á sí Misilanↄ kũ buri kũ ò ↄ tↄ̃̀áwanↄ ↄĩ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Luda á bↄ́ á yã'ũmmananↄ kũ á warikɛnanↄ gũn pínki, akũ a gii gbãra, a pìnɛ à kína káárɛ. Tↄ̀, à mↄ́ à zɛ Dikiri arɛ sà buri kũ burio, ↄn kũ ↄnnwo. ");
INSERT INTO bqp_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Kũ Samuɛli sù kũ Isaraila burinↄ ń pínki, akũ gbɛ̀ Biliaminu burinↄ sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Akũ à sù kũ Biliaminu burinↄ ↄn kũ ↄnnwo. Akũ Matari ↄnnn ò zɛ̀o. Ɔnde pìnↄ tɛ́ Kisi nɛ́ Solu mɛ́ à blè. Kũ ò a wɛ̀tɛ, òdi a lero. ");
INSERT INTO bqp_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Akũ ò ɛ̀ra ò Dikiri là dↄ ò pì: Gↄ̃gbɛ̃ pìi sù la kↄ̀ yá? Akũ Dikiri pì: À utɛna asonↄ dagura. ");
INSERT INTO bqp_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Akũ ò bàa lɛ̀ ò gɛ̀ɛ ò a bò ò sù kãao ń tɛ́. Kũ à zɛ̀ ń tɛ́, ń pínki ń gbã̀na zɛ̀ a gã̀ lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Akũ Samuɛli pìńnɛ ń pínki: A gbɛ̃ kũ Dikiri sɛ̀ɛ è yá? Gbɛ̃ke kun lán a bà á tɛ́ro. Akũ gbɛ̃ sĩnda pínki wiki lɛ̀ ò pì: Luda ó kína dↄ̃ kũ aafiaao! ");
INSERT INTO bqp_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Akũ Samuɛli kíblena zɛ́ bↄ̀kↄtɛńnɛ, akũ à kɛ̃̀ takadan à dìtɛ Dikiri kpɛ́n. Akũ à ń gbárɛ, baadi tà a bɛa. ");
INSERT INTO bqp_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Solu sↄ̃ à tà a bɛa Gibɛa. Gↄ̃ wↄ́rↄgↄde kũ Luda zĩ kɛ̀ ń swɛ̃̀ɛ gũnnↄ tɛ̀i. ");
INSERT INTO bqp_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Akũ gbɛ̃ pã kenↄ pì: Gbɛ̃ bire mɛ́ ani ó sura ba yá? Akũ ò a gya bò, odi sunɛ kũ pↄ́keoro, ama Solu a yĩtɛna o. ");
INSERT INTO bqp_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Amↄni buri Naasa sù kũ a zĩ̀karinↄ, ò bùraa kàtɛ Yabɛsi Giliada sarɛ, akũ Yabɛsidenↄ pì Naasanɛ: Ǹ lɛ́dokↄ̃nↄ kɛ kũoo, óni mì natɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Akũ Naasa pìńnɛ: Tó ma á baadi ↄpla wɛ́ bↄ̀bↄ, akũ wé'i Isarailanↄ kũ̀ ń pínki, gbasa mà lɛ́dokↄ̃nↄ kɛ kãáo. ");
INSERT INTO bqp_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Akũ Yabɛsi gbɛ̃ zↄ̃kↄ̃nↄ pìnɛ: Ǹ ó gba gↄrↄ suppla de ò gbɛ̃nↄ zĩ Isarailanↄ bùsuu gũn pínki. Tó gbɛ̃ke kun à ó sura baro, óni ó zĩda kpámma. ");
INSERT INTO bqp_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Kũ zĩ̀rii pìnↄ kà Solu bɛa Gibɛa, ò yã pìi òńnɛ, akũ ò wɛ̃nda ↄ́ↄ dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Gↄrↄ birea Solu tɛn su kũ burao, à tɛ́ a zùnↄi, akũ à pì: Bↄ́ yã mɛ́ à sù, akũ òtɛn ↄ́ↄ dↄↄ? Akũ ò Yabɛside pìnↄ yã bàbanɛ. ");
INSERT INTO bqp_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Kũ Solu yã pìi mà, Luda Nini sùa, akũ a pↄ fɛ̃̀ manamana. ");
INSERT INTO bqp_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","À zùu sɛ̀ mɛ̀n pla à dɛ̀ à zↄ̃̀zↄ̃kↄ̃rɛ, akũ à gbɛ̃nↄ zĩ̀o Isarailanↄ bùsuu gũn pínki ò pì: Lɛn oni kɛ gbɛ̃ kũ adi tɛ́ Solui kũ Samuɛlioro zùnↄnɛ lɛ. Akũ vĩna ń kũ Dikiri yã musu, ò bò ò tɛ̀ńyĩ lɛɛlɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Solu ń náro zaa Bɛzɛki. Isarailanↄ kà gbɛ̃nↄn dúbu wàa do kpɛ́ basↄↄro. Yudanↄn kú ń tɛ́ gbɛ̃nↄn dúbu baraakuri. ");
INSERT INTO bqp_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Akũ ò pì zĩ̀ri kũ ò sùu pìnↄnɛ: À gɛ́ à o á gbɛ̃nↄnɛ, zia ari ifãntɛ̃ gↄ̃ gɛ́ gbã, óni ń sura ba. Kũ zĩ̀rinↄ tà, ò yã pì baaruu kpà Yabɛsidenↄnɛ, akũ ń pↄ kɛ̀ nna. ");
INSERT INTO bqp_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Ò pì Amↄninↄnɛ: Óni ó zĩda kpááwa zia, áni á pↄyeina kɛwá. ");
INSERT INTO bqp_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Solu a gbɛ̃nↄ kpàatɛ gã̀ aakↄ̃. Gudↄon ò sì Amↄninↄgu ń bùran ò ń dɛdɛ ari ifãntɛ̃ gɛ̀ɛ à gbã̀o. Akũ gbɛ̃ kũ ò gↄ̃̀nↄ fã̀kↄ̃a dodo. ");
INSERT INTO bqp_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Akũ ò pì Samuɛlinɛ: Dínↄ mɛ́ ò pì Solu ni kí blewároo? À bↄtɛ kũńwo ò ń dɛdɛ. ");
INSERT INTO bqp_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Akũ Solu pì: Oni gbɛ̃ke dɛ gbãraro, zaakũ Dikiri Isarailanↄ sura bà gbãramɛ. ");
INSERT INTO bqp_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Akũ Samuɛli pì parinɛ: À mↄ́ ò gɛ́ Giligala ò ɛra ò Solu ká kpatan gwe dↄ. ");
INSERT INTO bqp_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Akũ ò gɛ̀ɛ Giligala ń pínki, ò ɛ̀ra ò Solu kà kpatan Dikiri arɛ gwe dↄ, ò kɛnnakũkↄ̃o sa ò Dikiria, akũ Solu kũ Isarailanↄ pↄnna kɛ̀ gwe ń pínki manamana. ");
INSERT INTO bqp_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Samuɛli pì Isarailanↄnɛ ń pínki: Ma yã kũ a òmɛnɛ mà pínki, ma kína kàárɛ kpatan. ");
INSERT INTO bqp_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Àkũ mɛ́ ani doárɛ arɛ sà. Makũ sↄ̃ ma zĩ kũ̀, ma mìkã pura kũ̀ akũ ma nɛ́nↄn kú kãáo. Ma doárɛ arɛ zaa ma kɛfɛnnakɛgↄrↄa ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Makũn dí! À kɛ ma sèedadenↄ ũ Dikiri kũ kína kũ à kào arɛ. Ma zù ke zaaki sì á gbɛ̃kea yá? Ma á gbɛ̃ke blè yá? Ma wɛ́ tã̀ á gbɛ̃kea yá? Gusarɛgba ma wɛ́ blè ari ma bo á gbɛ̃ke kpɛ yá? Tó ma kɛ̀ lɛ, mani a fĩna bonɛ. ");
INSERT INTO bqp_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Akũ ò wèa ò pì: Ńdi ó blero, ńdi wɛ́ tãwáro, ńdi pↄ́ke sí ó gbɛ̃kearo. ");
INSERT INTO bqp_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Samuɛli pìńnɛ dↄ: Dikiri kũ kína kũ à kàaoomɛ á sèedadenↄ ũ gbãra, kũ ádi taari emaro. Ò pì: Dikiri mɛ́ à ó sèedade ũ. ");
INSERT INTO bqp_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Akũ Samuɛli pìńnɛ: Dikiri mɛ́ à Musa kũ Harunaoo dìtɛ, akũ ò bò kũ á dizinↄ Misila. ");
INSERT INTO bqp_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","À zɛ kyáu Dikiri arɛ, mani yã mana kũ à kɛ̀árɛ kũ á dizinↄ babaárɛ. ");
INSERT INTO bqp_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Yakubunↄ gɛna Misila gbɛra á dizinↄ wiki lɛ̀ Dikiria, akũ à Musa kũ Harunaoo dìtɛ, ò ń bↄ́tɛ Misila, akũ ò ń kátɛ bùsu dín. ");
INSERT INTO bqp_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Kũ Dikiri ń Luda yã sã̀ńgu yãi, akũ à ń kpá Azo zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Siseraa kũ Filisitininↄ kũ Mↄabunↄ kínao, òtɛn zĩ̀ ká kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Akũ ò wiki lɛ̀ Dikiria ò pì: O durunna kɛ̀ o pã kpànyĩ o dò Baalinↄi kũ Asatorɛnↄ. Ǹ ó bo ó ibɛrɛnↄ ↄĩ sà, ónigↄ̃ donyĩ. ");
INSERT INTO bqp_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Akũ Dikiri Gidiↄn dìtɛ kũ Barakio kũ Yɛfɛtao kũ Samusio ò á bó á ibɛrɛ pìnↄ ↄĩ gu sĩnda pínkia, akũ a gↄ̃ katɛna aafia. ");
INSERT INTO bqp_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Kũ a è Amↄni kína Naasa tɛn su lɛ́tɛáwa, bee kũ Dikiri á Ludamɛ á kína ũ, a pìmɛnɛ: Oi! Kínan á yei! ");
INSERT INTO bqp_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Tera sà kína kũ a gbɛ̀ka a sɛ̀n dí, àkũmɛ Dikiri dìtɛárɛ. ");
INSERT INTO bqp_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Tó á Dikiri vĩna vĩ akũ átɛn doi, tó átɛni a yã ma akũ ádi bo a yã kpɛro, tó ákↄ̃nↄ kũ gbɛ̃ kũ àtɛn kí bleáwao tɛ́ Dikiri á Ludai, ánigↄ̃ aafia. ");
INSERT INTO bqp_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Tó ádi Dikiri yã ma sↄ̃ro, akũ a bo a yã kpɛ, ani ↄ tↄ̃áwa lákũ à kɛ̀ á dizinↄnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","À zɛ à yã zↄ̃kↄ̃ kũ Dikiri ni kɛárɛ e. ");
INSERT INTO bqp_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ésekɛ̃gↄrↄn ó kun loo? Mani Dikiri sísi, ani tó legũ pata à ma, ánigↄ̃ dↄ̃ kũ á kína gbɛkanaa kɛ̀ Dikirinɛ ĩni manamana. ");
INSERT INTO bqp_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Akũ Samuɛli Dikiri sìsi, akũ Dikiri tò legũ pàta à mà zĩ birea. Akũ gbɛ̃ sĩnda pínki vĩna kɛ̀ Dikirinɛ kũ Samuɛlio manamana. ");
INSERT INTO bqp_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Akũ ò pìnɛ: Ǹ wɛ́ kɛwɛrɛ Dikiri n Ludaa de ókↄ̃nↄ n zↄ̀blerinↄ sún gagaro. O yã vãni kàra ó durunnanↄla, kũ o kína gbɛ̀ka. ");
INSERT INTO bqp_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Samuɛli pìńnɛ: Àsun tó vĩna á kũro. A yã vãni pìi kɛ̀ pínki, ama àsun kɛ̃ Dikiriaro. Àgↄ̃ doi kũ nɛ̀sɛ mɛ̀n doo. ");
INSERT INTO bqp_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Àsun kɛ̃a à tɛ́ pↄ́ ginanↄiro. Ò àre vĩro, oni fↄ̃ ò gbɛ̃ boro, zaakũ pↄ́ pãnↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Dikiri ni a gbɛ̃nↄ zukũnaro a tↄ́ zↄ̃kↄ̃ yãi, zaakũ à kàagu à á kɛ́ a gbɛ̃nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Makũ sↄ̃, Dikiri sún tó mà durunna kɛarɛ mà aduakɛnaárɛ tóro. Mani zɛ́ mana kũ à de à sɛ́ mↄárɛ. ");
INSERT INTO bqp_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","À vĩna kɛ Dikirinɛ, àgↄ̃ doi kũ náanio kũ nɛ̀sɛ mɛ̀n doo. À laasun lɛ́ yã zↄ̃kↄ̃ kũ à kɛ̀árɛnↄa. ");
INSERT INTO bqp_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Tó a gi a tɛ yã vãnii, ákↄ̃nↄ kũ á kínao, oni á kakatɛ á pínki. ");
INSERT INTO bqp_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Kũ Solu kí blè Isarailanↄa wɛ̃̀ pla, ");
INSERT INTO bqp_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","à ń zĩ̀karinↄ sɛ̀ gbɛ̃nↄn wàa gɛ̃ro. Gbɛ̃nↄn wàa kuri kú kãao Mikimasa kũ Bɛtɛli gusĩsĩdeo. Gbɛ̃nↄn wàa sↄↄro kú kũ a nɛ́ Yonatão Gibɛa, Biliaminu bùsun. Akũ à gbɛ̃ kparanↄ gbàrɛ, baadi tà a bɛa. ");
INSERT INTO bqp_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Yonatã lɛ̀tɛ Filisitini gudãkpãki kũ à kú Gɛbaa, akũ Filisitininↄ a baaruu mà. Akũ Solu zĩ̀ kuru pɛ̀ Isarailanↄ bùsu gu sĩnda pínkia à pì Eberunↄ ma! ");
INSERT INTO bqp_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Akũ Isarailanↄ mà ń pínki ò pì, Solu lɛ̀tɛ Filisitini gudãkpãkia, akũ Filisitininↄ zã Isarailanↄ gbĩn. Akũ ò Isarailanↄ sìsi, ò sù ò nà Solua Giligala. ");
INSERT INTO bqp_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Akũ Filisitininↄ kↄ̃ kàkara ò zĩ̀ ká kũ Isarailanↄ. Ń sↄ̃gonↄ kà dúbu baraakuri, ń sↄ̃godenↄ kà dúbu suddo, akũ ń gɛ̀sɛdenↄn dasi lán ísiralɛ bùsu'atɛ̃ bà. Akũ ò fùtɛ ò gɛ̀ɛ ò bùraa kàtɛ Mikimasa, Bɛtavɛ̃ ifãboki kpa. ");
INSERT INTO bqp_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Kũ Isarailanↄ è ò kú wari gũn òtɛn nakara kũńwo, akũ ò ùtɛ gbɛ̀wɛɛnↄ gũn kũ dàkonↄ kũ gbɛ̀ sↄ̀kↄnↄ kũ tↄ̃̀nↄwɛɛnↄ kũ lↄ̀gↄnↄo. ");
INSERT INTO bqp_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Ń gbɛ̃kenↄ gu lɛ̀ ò bikũ̀ Yodaa ari Gada bùsun kũ Giliada bùsuuo. Solu kpɛ́ kú Giligala, vĩna tɛn gbɛ̃ kũ ò kú kãaonↄ kũ manamana. ");
INSERT INTO bqp_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","À Samuɛli dã̀ gↄrↄ suppla lákũ à dìtɛarɛ nà. Kũ adi suro, akũ a gbɛ̃nↄ tɛn fãkↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Akũ Solu pì: À mↄ́mɛnɛ kũ sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũo kũ sáabukpa sa'opↄnↄ. Akũ à sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ pìi ò. ");
INSERT INTO bqp_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Kũ à làka, Samuɛli tɛn ká, akũ Solu pìi gɛ̀ɛ à dàalɛ à gbãnakɛ kpài. ");
INSERT INTO bqp_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Akũ Samuɛli pìnɛ: Bↄ́ yãn n kɛ̀ gwee? Solu wèa à pì: Kũ ma è ma gbɛ̃nↄ tɛn fãkↄ̃a, akũsↄ̃ ńdi su gↄrↄ kũ n dìtɛaro yãimɛ. Filisitininↄ tɛn kↄ̃ kakara Mikimasa, ");
INSERT INTO bqp_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","akũ ma pì, òsun lɛ́tɛma Giligala la ari mà Dikiri gbɛka. Akũ ma sa pìi ò tilasi. ");
INSERT INTO bqp_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Akũ Samuɛli pìnɛ: N fayasariyã kɛ̀! Ń yã kũ Dikiri n Luda dìtɛnnɛ kũnaro. Tó ń kũna yãmɛ, de Dikiri ni tó n burinↄ gↄ̃ kpata ble Isarailanↄa gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Tera sà ĩni gì kɛ kpataa gũnlo. Lákũ ń yã kũ Dikiri dìtɛnnɛ kũnaro nà, à gĩnakɛ à gbɛ̃ kũ a pↄ kɛ̀arɛ wɛ̀tɛ, à a dìtɛ a gbɛ̃nↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Akũ Samuɛli fùtɛ Giligala à gɛ̀ɛ Gibɛa, Biliaminu bùsun. Akũ Solu a zĩ̀kari kũ ò kú kãaonↄ nàro, ò kà gbɛ̃nↄn wàa aakↄ̃ taka bà. ");
INSERT INTO bqp_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Solu kũ a nɛ́ Yonatão kũ a zĩ̀kari kũ ò kú kũńwonↄn kú Gibɛa, Filisitininↄ sↄ̃ ò bùraa kàtɛ Mikimasa. ");
INSERT INTO bqp_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Zĩ̀kari gã̀ aakↄ̃nↄ bↄ̀tɛ Filisitininↄ bùran ò gɛ̀ɛ lɛ́tɛ Isarailanↄa. Gã̀ do gɛ̀ɛ Ɔfla kpa Suala bùsun, ");
INSERT INTO bqp_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","gã̀ do gɛ̀ɛ Bɛtoroni kpa, akũ a aakↄ̃de gɛ̀ɛ Isarailanↄ bùsu lɛ́n, sĩ̀sĩ kũ à arɛdↄna maninↄ guvutɛa kũ gbárannao. ");
INSERT INTO bqp_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Sia kú Isarailanↄ bùsunlo, zaakũ Filisitininↄ pì, Eberunↄ sún fɛ̃nɛda ke sári piro. ");
INSERT INTO bqp_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Filisitininↄ kĩnaan Isarailanↄ dì gɛ́ swakurenↄ kũ zùswanↄ kũ kpásanↄ kũ kòmanↄ lɛ́ kɛkɛn pínki. ");
INSERT INTO bqp_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Swakure kũ zùswa lɛ́kɛkɛnaa kà andurufu plapla, sakanↄ kũ kpásanↄ sↄ̃ andurufu dodo. ");
INSERT INTO bqp_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","A yã mɛ́ à tò zĩ̀i pìi kágↄrↄ Solu kũ Yonatão zĩ̀karinↄ fɛ̃nɛda ke sári kũnaro, sé Solu kũ Yonatão baasiro. ");
INSERT INTO bqp_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Filisitini gudãkpãrinↄ gɛ̀ɛ Mikimasa gbɛ̀sↄkↄn. ");
INSERT INTO bqp_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Zĩkea Solu nɛ́ Yonatã pì kɛfɛnna kũ à a zĩ̀kapↄnↄ kũnaanɛ: Ǹ mↄ́ ò gɛ́ Filisitini gudãki kpa zã̀ dire. Adi o a denɛ sↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Solu kú bísi lí gbáru Migirↄnu, Gibɛa sarɛ kũ zĩ̀karinↄ gbɛ̃nↄn wàa aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Sa'ori Ahia kú ń tɛ́, à a uta lokomma dana. Ikabodu vĩ̀ni Aitubu nɛ́mɛ. Aitubu pì bi Finɛasi nɛ́mɛ, Ɛli kũ à de Luda gbàgbari ũ Silo daikoremɛ. Ń gbɛ̃ke dↄ̃ Yonatã gɛ̀ɛ gukearo. ");
INSERT INTO bqp_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Gbɛ̀sↄkↄ kũ Yonatã ye à gɛ̃n à Filisitini gudãkpãrinↄ le, gbɛ̀ sↄ̃ntɛnↄ pɛtɛpɛtɛnan ↄplai kũ ↄzɛo. A do tↄ́n Bozezi, a do sↄ̃ Sɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","A do kú gugbãndurun Mikimasa kpa, a do sↄ̃ gɛ̀nↄmidↄki Gɛba kpa. ");
INSERT INTO bqp_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Akũ Yonatã pì kɛfɛnna pìinɛ: Ǹ mↄ́ ò gɛ́ gyↄfↄrↄde gudãkpãrii pìnↄ kĩnaa. Ke Dikiri ni kpáwái gwɛɛ? Zaakũ yãke ni fↄ̃ à kpá Dikirinɛ à tó ò gí zĩ̀ bleiro, bee tó ó dasi kesↄ̃ ó dasiro. ");
INSERT INTO bqp_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Akũ a zĩ̀kapↄnↄsɛri pìi pìnɛ: Lákũ à n pↄ gbà nà pínki dé, ǹ kɛ. Lákũ n sɛ̀ nà, má kú kũnwo kũ nɛ̀sɛ mɛ̀n doomɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Akũ Yonatã pì: Tↄ̀, ò gɛ́ńyĩ ò ó zĩda mↄ́ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Tó ò pìwɛrɛ ò zɛ ò ń dãmɛ, óni zɛ ó gbɛ̀n, óni gɛ́ńyĩ doro. ");
INSERT INTO bqp_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Tó ò pì ò sumɛ sↄ̃, óni gɛ́ńyĩ, zaakũ abirekũ mɛ́ anigↄ̃ de sèeda ũ kũ Dikiri ń náwɛrɛ ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Akũ ò ń zĩda mↄ̀ Filisitini gudãkpãrii pìnↄnɛ. Akũ Filisitini pìnↄ pì: À gwa! Eberunↄ tɛn bo wɛ̀ɛ kũ ò ùtɛnnↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Akũ gudãkpãrii pìnↄ lɛ́ zù Yonatãi kũ a zĩ̀kapↄnↄsɛriio ò pì: À mↄ́ ò yãke oárɛ la. Akũ Yonatã pì a zĩ̀kapↄnↄsɛriinɛ: Ǹgↄ̃ tɛ́ ma kpɛ, zaakũ Dikiri ń ná Isarailanↄnɛ ń ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Akũ Yonatã tɛn lↄↄtɛ kutɛna, akũ a zĩ̀kapↄnↄsɛri tɛ́ a kpɛ. Kũ Yonatã ń nɛ́, akũ a zĩ̀kapↄnↄsɛrii pì ń dɛdɛ a kpɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Lɛtɛmmana káaku pìi gũn Yonatã kũ a zĩ̀kapↄnↄsɛriio ń dɛdɛ gbɛ̃nↄn baro taka bà. Gu pì yàasaa kà bú dↄ̀rↄ basↄↄro taka bà. ");
INSERT INTO bqp_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Akũ swɛ̃̀ɛ kɛ̃̀ Filisitininↄgu ń bùran kũ zĩ̀lao pínki. Vĩna ń zĩ̀karinↄ kũ̀, gudãkpãrinↄ kũ gbɛ̃ kũ òdi gɛ́ lɛ́tɛ Isarailanↄanↄ ń pínki. Akũ zĩtɛ yĩ̀gãyĩgã. Luda mɛ́ à tò swɛ̃̀ɛ kɛ̃̀ńgu lɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Kũ Solu gudãkpãri kũ ò kú kãao Gibɛanↄ è Filisitini zĩ̀karinↄ bàa lɛ̀ òtɛn fãkↄ̃a gu sĩnda pínkia, ");
INSERT INTO bqp_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","akũ Solu pì gbɛ̃ kũ ò kú kãaonↄnɛ: À wɛ́ pá ó gbɛ̃nↄi à gwa, óni dↄ̃ gbɛ̃ kũ ò bò ó tɛ́. Kũ ò gwà, ò è Yonatã kũ a zĩ̀kapↄnↄsɛriio mɛ́ ò kú ń tɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Akũ Solu pì Ahianɛ: Ǹ mↄ́ kũ n sa'o'utao ò Dikiri gbɛka. Zaakũ zĩ birea à uta lokomma pì dana Isarailanↄ tɛ́ gwe. ");
INSERT INTO bqp_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Gↄrↄ kũ Solu tɛn yã o sa'orii pìinɛ, zuka kũ à dↄ Filisitininↄ bùran kɛ̀kɛ àtɛn kara, akũ Solu pìnɛ à tó gwe. ");
INSERT INTO bqp_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Solu a zĩ̀karinↄ kàkara ń pínki, ò gɛ̃̀ zĩ̀n, akũ ò è swɛ̃̀ɛ kɛ̃̀ Filisitininↄgu manamana, òtɛn fɛ̃nɛ kákↄ̃nɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Eberu kũ ò vùtɛ Filisitininↄ tɛ́ yã ò sù kũńwo ń bùraa gũnnↄ ɛ̀ra ò nà ń gbɛ̃ kũ ò kú kũ Soluo kũ Yonatãooa. ");
INSERT INTO bqp_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Kũ Isaraila kũ ò utɛna Ɛflaimu bùsu gusĩsĩden gwenↄ mà Filisitininↄ tɛn bàa lɛ́, ò nà ń gbɛ̃nↄa dↄ ò pɛ̀tɛńyĩ zĩ̀i gũn. ");
INSERT INTO bqp_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Lɛn Dikiri Isarailanↄ bò lɛ zĩ birea, akũ ò zĩ̀i blè ari Bɛtavɛ̃. ");
INSERT INTO bqp_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Isarailanↄ wari kɛ̀ zĩ birea, zaakũ Solu yã sɛ̀ kũ Luda tↄ́o a zĩ̀karinↄnɛ à pì: Ari ↄkↄsi gɛ́ kɛo, gbɛ̃ kũ à pↄ́ blè ari màgↄ̃ gɛ́ fĩna bo ma ibɛrɛnↄa, ade gↄ̃̀ láaripↄ ũmɛ. Akũ ń gbɛ̃ke dí pↄ́ blero. ");
INSERT INTO bqp_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Zĩ̀karinↄ sì lákpɛn ń pínki, akũ ò zↄ́'i è di gu pìn. ");
INSERT INTO bqp_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Kũ ò sì lákpɛn lɛ, ò è zↄ́'i tɛn bàa lɛ́, ama ń gbɛ̃ke dí ↄ zↄ̃a à dà a lɛ́nlo, kũ òtɛn vĩna kɛ ladana kũ Solu dà yãi. ");
INSERT INTO bqp_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Yonatã sↄ̃, adi yã kũ a de dìtɛ a zĩ̀karinↄnɛ maro, akũ à a gò kũ à kũnaa zↄ̃̀ zↄ́saa pìia. À ↄ nàa à dà a lɛ́n, akũ a wɛ́ kɛ̃̀. ");
INSERT INTO bqp_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Akũ zĩ̀kari ke pìnɛ: N de yã sɛ̀ a zĩ̀karinↄnɛ kũ Luda tↄ́o à pì, gbɛ̃ kũ à pↄ́ blè gbãra, ade gↄ̃̀ láaripↄ ũmɛ. Abire yãin ń gbɛ̃ sĩnda pínki gbãna làka. ");
INSERT INTO bqp_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Akũ Yonatã pì: Ma de tɛn wari dↄḿmamɛ. Ǹ gwa lákũ ma wɛ́ kɛ̃̀ nà, kũ ma zↄ́ pìi mↄ̀sↄ fíti yãi. ");
INSERT INTO bqp_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Tó gbɛ̃nↄ pↄ́ kũ ò sì ń ibɛrɛnↄaa blè gbãra yã dé, de ò Filisitininↄ dɛ̀dɛ de abirela. ");
INSERT INTO bqp_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Zĩ birean Isarailanↄ Filisitininↄ dɛ̀dɛ sɛna zaa Mikimasa ari Ayalↄni. Ò kpàsa búgubugu, ");
INSERT INTO bqp_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","akũ ò sì ń pↄ́kãdenↄ tɛ́, ò sãnↄ kũ zùnↄ kũ zùnɛnↄ kũ̀kũ ò dɛ̀dɛ gwe gↄ̃̀nↄ, òtɛn só kũ a aruo. ");
INSERT INTO bqp_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Akũ ò a baaruu kpà Solunɛ ò pì: Ǹ gwa! Òtɛn durunna kɛ Dikirinɛ, òtɛn nↄ̀bↄ só kũ a aruo. Akũ Solu pì: A bo Dikiri yã kpɛ. À gbɛ̀ gbɛ̃̀ntɛ̃ gbigiri kɛ à suo ma arɛ la likalika. ");
INSERT INTO bqp_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Akũ à pì: À fãkↄ̃a ń tɛ́, à pińnɛ ń baadi mↄ́ ma kĩnaa kũ a zùuo ke a sã, ò a kùtu kpá la ò só. Àsun durunna kɛ Dikirinɛ à nↄ̀bↄ só kũ a aruoro. Akũ baadi sù kũ a zùuo gwãani birea, à a kùtu kpàkpa gwe. ");
INSERT INTO bqp_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Solu Dikiri gbagbaki bò gwe. Sa'oki kũ à bò káakun gwe. ");
INSERT INTO bqp_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Akũ Solu pì: Ò pɛ́tɛ Filisitininↄi gwãaniala ògↄ̃ ń dɛdɛ ari gu gɛ́ dↄ. Òsun ń gbɛ̃ke tóro. Akũ ò pìnɛ: Ǹ kɛ lákũ à kɛ̀nnɛ mana nà. Akũ sa'orii pì: À tó ò gbɛka Ludaa la gĩa. ");
INSERT INTO bqp_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Akũ Solu gbɛ̀ka Ludaa: Ò pɛ́tɛ Filisitininↄi, ĩni ń nawɛrɛ ó ↄĩ yá? Akũ adi wea zĩ birearo. ");
INSERT INTO bqp_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Akũ Solu pì: Ákↄ̃nↄ zĩ̀kari gbɛ̃ zↄ̃kↄ̃nↄ á pínki, à namai la, de ò le ò dↄ̃ durunna kũ ò kɛ̀ gbãra. ");
INSERT INTO bqp_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Kũ Dikiri Isarailanↄ Surabari tↄ́o, bee tó ma nɛ́ Yonatã mɛ́ à durunna kɛ̀, séde à ga. Akũ gbɛ̃ke dí lɛ́ síro. ");
INSERT INTO bqp_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Akũ à pìńnɛ: À zɛ kpado gwe, makũ kũ ma nɛ́o ónigↄ̃ kú kpado la. Akũ ò pìnɛ: Ǹ kɛ lákũ à kɛ̀nnɛ mana nà. ");
INSERT INTO bqp_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Solu pì Dikiri Isarailanↄ Ludanɛ: Ǹ tó ò yãpura dↄ̃. Akũ yã Yonatã kũ Soluoo blè, akũ baadi mìi bò bàn. ");
INSERT INTO bqp_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Solu pì: À gbɛ̀ la makũ kũ ma nɛ́o musu. Kũ yã Yonatã blè, ");
INSERT INTO bqp_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","akũ Solu pìnɛ: Ǹ yã kũ n kɛ̀ omɛnɛ. Akũ Yonatã pìnɛ: Ma gò lɛ́ sↄ̃ntɛn ma zↄ̃̀ zↄ́a, fíti ma mↄ̀sↄ. Makũn dí! Mà ga. ");
INSERT INTO bqp_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Akũ Solu pì: Yonatã, tó ńdi garo, Luda yã kɛmɛnɛ pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Akũ ò pì Solunɛ: Yonatã ga yá! Àkũ kũ à tò o zĩ̀i blè yá? Oi! Kũ Ludao ódi we kũ bee a mìkã mɛ̀n do à lɛ́tɛ zĩtɛro, zaakũ Luda kpányĩn à yã pìi kɛ̀o gbãra. Lɛn ò Yonatã mìi sì lɛ, adi garo. ");
INSERT INTO bqp_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Akũ Solu kámma bò kũ pɛtɛna Filisitininↄiio, akũ Filisitininↄ tà ń bùsun. ");
INSERT INTO bqp_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Kũ Solu vùtɛ Isarailanↄ kpatan à làka, à zĩ̀i kà kũ a ibɛrɛnↄ gu sĩnda pínkia: Mↄabunↄ kũ Amↄninↄ kũ Ɛdↄmunↄ kũ Zoba kínanↄ kũ Filisitininↄo. Kpa kũ à lìtɛn pínki, àdi zĩ̀ bleḿmamɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","A wↄ́rↄgↄkɛ tↄ́ bò à zĩ̀i blè Amalɛkinↄa, à Isarailanↄ sì ń wɛ́tãmmarinↄa. ");
INSERT INTO bqp_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Yonatã kũ Isibosɛo kũ Malakisuaoomɛ Solu nɛ́gↄ̃gbɛ̃nↄ ũ. À nɛ́nↄgbɛ̃nↄ vĩ gbɛ̃nↄn pla. A káaku tↄ́n Mɛraba, a plade Mikala. ");
INSERT INTO bqp_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","A nanↄ tↄ́n Ainↄama, Aimaza nɛ́mɛ. A zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ tↄ́n Abana. Solu pì dakũnamɛ, a disɛ̃ Nɛrɛ nɛ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Solu de Kisi kũ Abana de Nɛrɛoomɛ Abiɛli nɛ́nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Solu gↄrↄ àdigↄ̃ pãsĩ kũ Filisitininↄo gↄrↄ sĩnda pínki. Tó Solu gↄ̃sa gbãna ke wↄ́rↄgↄde è, àdi a sí à na a zĩ̀karinↄa. ");
INSERT INTO bqp_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Samuɛli pì Solunɛ: Makũmɛ Dikiri ma zĩ, akũ ma nísi kùmma n kana kín a gbɛ̃ Isarailanↄa sèeda ũ. Tↄ̀! Ǹ sã kpá Dikiri yãi sà. ");
INSERT INTO bqp_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Dikiri Zĩ̀karide pì, áni fĩna bo Amalɛkinↄnɛ yã kũ ò kɛ̀ Isarailanↄnɛ, kũ ò zɛ́ zↄ̃̀ńnɛ ń bↄtɛna Misila gbɛra yãi. ");
INSERT INTO bqp_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Ǹ gɛ́ ǹ lɛ́tɛḿma sà, ǹ ń kakatɛ ń pínki. Ǹsun ń gbɛ̃ke tóro. Ǹ ń dɛdɛ ń pínki, gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ kũ nɛ́nↄ kũ nɛ́kpãntɛ̃nↄ kũ zùnↄ kũ sãnↄ kũ lakuminↄ kũ zaakinↄo. ");
INSERT INTO bqp_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Akũ Solu a gbɛ̃nↄ sìsi à ń kakara Telaimu. A zĩ̀kari gɛ̀sɛdenↄ gbɛ̃nↄn dúbu wàa domɛ. Yudanↄ kun dↄ gbɛ̃nↄn dúbu kuri. ");
INSERT INTO bqp_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Akũ Solu gɛ̀ɛ Amalɛkinↄ wɛ̃tɛn, àtɛni ń kpákpa swawɛɛn. ");
INSERT INTO bqp_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Solu lɛ́gbãzã kɛ̀ Keninↄnɛ à pìńnɛ: À bↄtɛ Amalɛkinↄ tɛ́ de màsun á dɛdɛ kũńworo yãi, zaakũ ákↄ̃nↄ mɛ́ a yã mana kɛ̀ Isarailanↄnɛ ń bↄtɛna Misila gbɛra. Kũ Keninↄ bↄ̀tɛ Amalɛkinↄ tɛ́, ");
INSERT INTO bqp_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","akũ Solu gɛ̀ɛ à lɛ̀tɛ Amalɛki pìnↄa sɛna zaa Avila ari à gɛ̀ɛ pɛ́ Suru kũ à kú Misila ifãboki kpaa. ");
INSERT INTO bqp_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","À Amalɛki kína Agaga kũ̀ bɛ̃nɛ, akũ à a gbɛ̃nↄ dɛ̀dɛ kũ fɛ̃nɛdao ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Solu kũ a zĩ̀karinↄ dí Agaga dɛro, akũsↄ̃ ò sã mananↄ sɛ̀tɛ kũ zùnↄ kũ zùnɛ mɛ̀kpananↄ kũ sãnɛ bↄ̀rↄnↄ kũ pↄ́ mananↄ pínki, odi we ò ń dɛdɛro. Pↄ́ ginanↄ kũ pↄ́ yãyãnanↄn ò dɛ̀dɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Akũ Dikiri yã sù Samuɛlia à pì: ");
INSERT INTO bqp_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Ma Solu kana kpatan tò ma pↄ yàka, zaakũ à kpɛ lìmɛnɛ. Lákũ ma dànɛ nà, àdi kɛ lɛro. Yã pì Samuɛli bídi kɛ̀, akũ à wiki lɛ̀ Dikiria ari gu gɛ̀ɛ à dↄ̀o. ");
INSERT INTO bqp_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Kũ Samuɛli fùtɛ kↄnkↄkↄnkↄ, à gɛ̀ɛ da Solulɛ, akũ ò pìnɛ: Solu gɛ̀ɛ Kamɛli. À sèedaa pɛ̀tɛ gwe a zĩda yãdↄngu yãi, akũ à ɛ̀ra à gɛ̀ɛ Giligala. ");
INSERT INTO bqp_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Kũ Samuɛli Solu lè, akũ Solu pìnɛ: Dikiri arubarika dangu! Ma kɛ̀ lákũ Dikiri òmɛnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Akũ Samuɛli a là à pì: Sã wiki kũ ma sã tɛn ma deramɛɛ? Zù ↄ́ↄ dↄ kũ matɛn ma bò mámɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Akũ Solu wèa à pì: Amalɛkinↄ pↄ́nↄmɛ, zaakũ ò ń sãnↄ kũ ń zù mananↄ sɛ̀tɛ ò sùo ò sa oo Dikiri n Ludaamɛ. O ń kparanↄ dɛ̀dɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Akũ Samuɛli pìnɛ: Ǹ yĩtɛ lɛ, mani yã kũ Dikiri òmɛnɛ gwãaniala onnɛ. Akũ Solu pì: Ǹ o. ");
INSERT INTO bqp_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Akũ Samuɛli pì: Kũ n n zĩda fíti bò yã, ńdi gↄ̃ Isaraila burinↄ don'arɛde ũroo? Dikiri n ka Isarailanↄ kína ũ, ");
INSERT INTO bqp_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","akũ à n zĩ ǹ a bↄkↄtɛ kɛarɛ kũ à pì: Ǹ gɛ́ ǹ Amalɛkinↄ dɛdɛ, zaakũ durunnakɛrinↄmɛ. Ǹ gɛ́ ǹ zĩ̀ ká kũńwo ari ǹ ń kakatɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","À kɛ̀ dera n gi Dikiri yã mai, n lɛtɛ ń pↄ́nↄa, n yã kũ Dikiri yeiro kɛ̀ɛ? ");
INSERT INTO bqp_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Akũ Solu pìnɛ: Ma Dikiri yã mà, ma bↄkↄtɛ kũ à ma zĩ mà kɛ kɛ̀. Ma Amalɛkinↄ dɛ̀dɛ ń pínki, akũ ma su kũ ń kína Agagao. ");
INSERT INTO bqp_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Akũ zĩ̀karinↄ sã mananↄ kũ zù mananↄoo bò pↄ́ kũ ò sɛ̀tɛ pìnↄ tɛ́, de ò sa oo Dikiri n Ludaa Giligala la. ");
INSERT INTO bqp_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Akũ Samuɛli pì: Dikiri yã kũna mananɛ de sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũla. Mìnatɛnanɛ de sa'onala. A yãmana de sa'ona kũ sãkaro mɛ̀kpanaaola. ");
INSERT INTO bqp_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Gina a yã mai durunna lɛɛlɛ kũ màsokɛnaaomɛ. Dↄkɛna kãao vãni lɛɛlɛ kũ tãnagbagbanaaomɛ. Lákũ n gi Dikiri yã mai nà, àpii gì n kínakɛi se. ");
INSERT INTO bqp_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Akũ Solu pìnɛ: Ma durunna kɛ̀. Ma pã Dikiri yã kũ n òmɛnɛnɛ, zaakũ ma vĩna kɛ̀ gbɛ̃nↄnɛ, akũ ma ń yã mà. ");
INSERT INTO bqp_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Ǹ sùru kɛ kũmao kũ ma durunna pìio sà. Ǹ ɛra ǹ gɛ́ kũmao de mà le mà donyĩ kɛ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Akũ Samuɛli pìnɛ: Mani gɛ́ kũnworo. N gi Dikiri yãi, akũ à gìnnɛ ǹgↄ̃ de Isarailanↄ kína ũ. ");
INSERT INTO bqp_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Kũ Samuɛli kpɛ lì, àtɛn ta, akũ Solu a kũ̀ a uta lɛ́a, à kɛ̃̀ a ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Akũ Samuɛli pìnɛ: Dikiri n bo Isarailanↄ kpatan gbãra, akũ à n gbɛ̃dake kũ à mana denla kàn. ");
INSERT INTO bqp_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Isarailanↄ Luda Gakuride dì ɛ́kɛ toro, àdi a laasun litɛro, zaakũ bisãsirinlo, gbasa à a laasun litɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Akũ Solu pìnɛ: Ma durunna kɛ̀. Bee kũ abireo n yã nna, ǹ ma kpe ta Isaraila gbɛ̃ zↄ̃kↄ̃nↄ kũ gbɛ̃ sĩnda pínkio arɛ. Ǹ gɛ́ zɛmɛnɛ de mà le mà donyĩ kɛ Dikiri n Ludanɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Akũ Samuɛli ɛ̀ra à gɛ̀ɛ à zɛ̀nɛ, akũ Solu donyĩ kɛ̀ Dikirinɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Akũ Samuɛli pì: À mↄ́ kũ Amalɛki kína Agagao. Kũ kína pì tɛn su, àtɛn kpákpa kũ yãke kunlo, zaakũ àtɛn da a bo ga lɛ́imɛ. ");
INSERT INTO bqp_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Akũ Samuɛli pì: Lákũ n fɛ̃nɛda tò nↄgbɛ̃ dasinↄ kùra ń nɛ́i nà, lɛn n da ni kura a nɛ́i lɛ se. Akũ à Agaga zↄ̃̀zↄ̃kↄ̃rɛ Dikiri arɛ Giligala gwe. ");
INSERT INTO bqp_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Akũ à tà Rama. Solu sↄ̃ à tà a bɛa Gibɛa. ");
INSERT INTO bqp_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Bee kũ Solu kɛ̀ Samuɛlinɛ wɛ̃nda, Samuɛli dí gɛ́ a gwa doro ari à gɛ̀ɛ gao, zaakũ Dikiri pↄ yàka kũ à Solu kà Isarailanↄ kína ũ yãi. ");
INSERT INTO bqp_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Dikiri pì Samuɛlinɛ: Ĩnigↄ̃ ↄ́ↄ dↄ Solu yã musu ari bↄrɛmɛɛ? Ma ginɛ à kí ble Isarailanↄa. Ǹ nísi ká bɛ̃nɛn à pa ǹ da zɛ́n. Ma n zĩ Bɛtilihamu gbɛ̃ Yɛsɛ kĩnaa, zaakũ a nɛ́nↄ doken ma sɛ̀ à gↄ̃ kína ũ. ");
INSERT INTO bqp_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Akũ Samuɛli pì: Deran mani kɛ mà gɛ́ gwee? Tó Solu mà, ani ma dɛ. Akũ Dikiri pìnɛ: Ǹ zùnunu sɛ́ ǹ gɛ́o ǹ pi n su ma gbagbamɛ. ");
INSERT INTO bqp_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Ǹ Yɛsɛ sísi sa pì onaa gũn, mani yã kũ ĩni kɛ onnɛ, ĩni nísi kúmɛnɛ gbɛ̃ kũ mani mↄnnɛ mìia. ");
INSERT INTO bqp_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samuɛli yã kũ Dikiri òarɛ kɛ̀. Kũ àtɛn ká Bɛtilihamu, lakutu pì gbɛ̃ zↄ̃kↄ̃nↄ gɛ̀ɛ ò dàalɛ. Vĩna ń kũ, akũ ò a là ò pì: Aafiaamɛ n su la yá? ");
INSERT INTO bqp_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","À pì: Aafiaamɛ. Ma su Dikiri gbagbamɛ. À gbã̀ bo á zĩdanɛ à gɛ́ kũmao sa o. Akũ à gbã̀ bò Yɛsɛnɛ kũ a nɛ́gↄ̃gbɛ̃nↄ à ń sísi sa'onaaa. ");
INSERT INTO bqp_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Kũ ò kà, Samuɛli Ɛliabu è, akũ à laasun lɛ̀ à pì: Gbɛ̃ kũ Dikiri sɛ̀ mɛ́ à zɛna a arɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Akũ Dikiri pìnɛ: Ǹsun a zɛna ke a gbã̀nakɛ gwaro, ma giimɛ. Madì gbɛ̃ gwa lákũ bisãsiri dì gwa nàro. Bisãsiri dì gbɛ̃ gwa a mɛ̀ɛamɛ, makũ sↄ̃, swɛ̃̀ɛn madì gwa. ");
INSERT INTO bqp_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Akũ Yɛsɛ Abinadabu sìsi, à sù Samuɛli arɛ, akũ à pì: Dikiri dí gbɛ̃ díkĩna sɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Akũ Yɛsɛ Sama sìsi, à sù Samuɛli arɛ dↄ, akũ à pì: Dikiri dí gbɛ̃ díkĩna sɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Akũ Yɛsɛ a nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn supplanↄ sìsi, ò sù Samuɛli arɛ, akũ à pì: Dikiri dí ń gbɛ̃ke sɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Akũ à Yɛsɛ là à pì: N kɛfɛnnanↄ lɛ́n dí ń pínki yá? À wèa à pì: Ń gbɛ̃ kpɛde mɛ́ à kú laro, àtɛn sã dãmɛ. Akũ Samuɛli pìnɛ: Ǹ gbɛ̃ zĩ ò a sísi. Óni pↄ́ke kɛro séto à sù. ");
INSERT INTO bqp_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Akũ à gbɛ̃ zĩ̀a, à sù. Nɛ́ pì bi gbɛ̃ tɛ̃ramɛ, a pɛtɛna mana akũsↄ̃ a ãn kɛ̃kↄ̃ana. Akũ Dikiri pì: Ǹ futɛ ǹ nísi kú a mìia, zaakũ àpiin gwe. ");
INSERT INTO bqp_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Akũ Samuɛli bɛ̃nɛ pìi sɛ̀ à nísi kù a mìia a vĩ̀ninↄ wára. Zaa zĩ birean Dikiri Nini sù Daudaa. Abire gbɛra Samuɛli ɛ̀ra à tà Rama. ");
INSERT INTO bqp_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Dikiri Nini gò Solua, akũ Dikiri tò tãna pãsĩ sùa. ");
INSERT INTO bqp_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","A ìbanↄ pìnɛ: Luda tò tãna pãsĩ tɛn wɛ́ tãmma. ");
INSERT INTO bqp_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Kína, ǹ tó ókↄ̃nↄ n ìbanↄ ò gbɛ̃ kũ à mↄrↄlɛna dↄ̃ wɛtɛ. Tó Luda tò tãna pãsĩ pìi sùmma, anigↄ̃ mↄrↄ lɛ́nnɛ, ń le ǹ kɛ sã̀na. ");
INSERT INTO bqp_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Akũ à pì a ìbanↄnɛ. À gbɛ̃ kũ à mↄrↄlɛna dↄ̃ manamana wɛtɛ à su kãaomɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Akũ a ìbanↄ doke pìnɛ: Ma Bɛtilihamu gbɛ̃ Yɛsɛ nɛ́ ke è, à mↄrↄlɛna dↄ̃. Zĩ̀kari wↄ́rↄgↄdemɛ, akũsↄ̃ à yã'ona dↄ̃. Gↄ̃ manamɛ, akũsↄ̃ Dikiri kú kãao. ");
INSERT INTO bqp_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Akũ Solu gbɛ̃nↄ zĩ̀ Yɛsɛa, ò gɛ̀ɛ ò pìnɛ: Solu pì ǹ n nɛ́ Dauda kũ àdi sãnↄ dã gbarɛarɛ. ");
INSERT INTO bqp_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Akũ Yɛsɛ burodii dì zaakinɛ kũ sèwɛ̃o tùru do kũ blèkofĩninɛ bↄ̀rↄↄo, à a nɛ́ Dauda gbàrɛo Solua. ");
INSERT INTO bqp_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Kũ à kà Solu kĩnaa, à gↄ̃̀ a zĩkɛri ũ. Solu yei manamana, akũ à a dìtɛ a zĩ̀kapↄnↄsɛrinↄ doke ũ. ");
INSERT INTO bqp_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Akũ Solu gbɛ̃ zĩ̀ Yɛsɛa à pì: Ǹ tó Dauda gↄ̃ ma zĩkɛri ũ, zaakũ a yã dì kɛmɛnɛ nna. ");
INSERT INTO bqp_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Tó Luda tò tãna pìi sù Solua, akũ Dauda dì a mↄrↄ sɛ́ àgↄ̃ lɛ́nɛ. Tó tãna pìi gòa, akũ àdi kɛ sã̀na, à su a laakariia. ");
INSERT INTO bqp_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Filisitininↄ ń zĩ̀karinↄ kàkara, òtɛn zĩ̀ soru kɛ Soko, Yudanↄ bùsun, akũ ò bùraa kàtɛ Ɛfɛsi Damimu, Soko kũ Azekao dagura. ");
INSERT INTO bqp_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Solu kũ Isarailanↄ sↄ̃ ò kↄ̃ kàkara ò bùraa kàtɛ Ela gusaran, òtɛn soru kɛ ò gɛ́ Filisitininↄi kũ zĩ̀io. ");
INSERT INTO bqp_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Filisitininↄn kú sĩ̀sĩia dire kpa, Isarailanↄn kú sĩ̀sĩia la, guvutɛ kú ń dagura. ");
INSERT INTO bqp_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Akũ Gata gↄ̃sa gbãna kũ òdi pinɛ Gↄlaya bò Filisitininↄ bùran. A gbã̀na kà gã̀sãkuru suddo. ");
INSERT INTO bqp_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","À mↄ̀gotɛ̃ fùra kuna, à mↄ̀gotɛ̃ uta kũ à de lán kpↄ̀tɛkɛɛ bà dana kũ a tìkisii kà kiloo baaakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","À mↄ̀gotɛ̃ sòkoto yĩna dↄ, akũsↄ̃ à mↄ̀gotɛ̃ sári lɛ̀kɛtɛ lokona a kpɛ kpa. ");
INSERT INTO bqp_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","À sári sↄ̃ntɛ kũna, a pá de lán bizatãri gòdo lí bà. A wɛ́ tìkisii kà kiloo suppla. A sɛ̃gbakosɛri tɛ́ a arɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Gↄlaya zɛ̀ à lɛ́ zù Isaraila zĩ̀karinↄi à pì: Bↄ́ yã mɛ́ à tò a bↄtɛ kũ zĩ̀ioo? Á dↄ̃ kũ Filisitinimɛ ma ũroo? Ákↄ̃nↄ sↄ̃, Solu zↄ̀nↄn á ũ. À gbɛ̃ke bo á tɛ́ à kipa à su ma kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Tó ani fↄ̃ à zĩ̀ ká kũmao à ma dɛ, ma gbɛ̃nↄ ni gↄ̃ á zↄ̀nↄ ũ. Tó makũ mɛ́ ma a dɛ̀ sↄ̃, áni gↄ̃ ó zↄ̀nↄ ũ, ánigↄ̃ zↄ̀ blewɛrɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Akũ Filisitini pìi ɛ̀ra à pì: Matɛn kùsɛɛ biri Isaraila zĩ̀karinↄa gbãra. À gbɛ̃ wɛtɛmɛnɛ de ò zĩ̀ ká kũ kↄ̃o. ");
INSERT INTO bqp_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Kũ Solu kũ Isarailanↄ a yã pìi mà ń pínki, ò bídi kɛ̀, swɛ̃̀ɛ kɛ̃̀ńgu. ");
INSERT INTO bqp_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Dauda bi Ɛflata gbɛ̃ Yɛsɛ nɛ́mɛ. Yɛsɛ bi Bɛtilihamu kũ à kú Yudanↄ bùsun gbɛ̃mɛ. À nɛ́gↄ̃gbɛ̃nↄ ì gbɛ̃nↄn sↄraakↄ̃. Solu gↄrↄa à zↄ̃kↄ̃ kũ̀ à zĩ kũ̀ manamana. ");
INSERT INTO bqp_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","A nɛ́ gbãna gbɛ̃nↄn aakↄ̃nↄn kú zĩ̀lan kũ Soluo. A daudu tↄ́n Ɛliabu, a plade tↄ́n Abinadabu, a aakↄ̃de tↄ́n Sama. ");
INSERT INTO bqp_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Daudamɛ Yɛsɛ nɛ́ kpɛde ũ. A vĩ̀ni pìnↄ tɛ́ Solui, ");
INSERT INTO bqp_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","ama Dauda dì gɛ́ Solu kĩnaa à ɛra à su Bɛtilihamu a de sãnↄ dã. ");
INSERT INTO bqp_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Filisitini pìi dì bo à a zĩda mↄńnɛ kↄnkↄ kũ ↄkↄsio ari gↄrↄ bupla. ");
INSERT INTO bqp_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Zĩkea Yɛsɛ pì a nɛ́ Daudanɛ: Ǹ ése kpatana kpɛ̃nɛ do dí kũ burodi mɛ̀n kuri dínↄ sɛ́ ǹ gɛ́o n vĩ̀ninↄnɛ likalika ń bùran. ");
INSERT INTO bqp_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Ǹ gàsi mɛ̀n kuri dínↄ sɛ́ ǹ kpá ń gã̀ gbɛ̃ zↄ̃kↄ̃ↄa. Ǹ gɛ́ ǹ ń gwa, tó ò aafia, ǹ su kũ sèedaao kũ ò kun aafia. ");
INSERT INTO bqp_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Ò kú kũ Soluo kũ Isarailanↄ pínki Ela guvutɛn, òtɛn zĩ̀ ká kũ Filisitininↄ. ");
INSERT INTO bqp_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Dauda fùtɛ kↄnkↄkↄnkↄ, à a sãnↄ tò kũ sãdãri pãndeo. À a aso sɛ̀, akũ à dà zɛ́n lákũ Yɛsɛ òarɛ nà. Kũ à kà zĩ̀karinↄ bùran, à sù à lè òtɛn gɛ́ zĩ̀lan, òtɛn wiki gbãna lɛ́. ");
INSERT INTO bqp_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Isarailanↄ kũ Filisitininↄ tɛn soru kɛ ò arɛ dↄkↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Akũ Dauda a aso nà pↄ́dãkpãriinɛ a ↄĩ, akũ à bàa lɛ̀ à gɛ̀ɛ zĩ̀lan. À a vĩ̀ninↄ lè gwe, akũ à fↄ kpàḿma. ");
INSERT INTO bqp_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Kũ àtɛn yã o kũńwo, Filisitininↄ gↄ̃sa gbãna Gↄlaya, Gata gbɛ̃ bò Filisitini zĩ̀karinↄ tɛ́, à ɛ̀ra à fùtɛ kũ a yã pìio. Dauda yã pìi mà. ");
INSERT INTO bqp_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Kũ Isarailanↄ a è, swɛ̃̀ɛ kɛ̃̀ńgu, ò lɛ̀kↄ̃a ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Òtɛn okↄ̃nɛ òtɛn pi: Ádi gↄ̃gbɛ̃ pì e à bòroo? Tó à bò, àdi kùsɛɛ biriwámɛ. Gbɛ̃ kũ à a dɛ̀, kína ni ade gba aruzɛkɛ zↄ̃kↄ̃, ani a gba a nɛ́nↄgbɛ̃ dↄ nↄ ũ, akũsↄ̃ a bedenↄ ni bɛ'ↄgↄ kpá doro. ");
INSERT INTO bqp_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Akũ Dauda gbɛ̃ kũ ò zɛna a sarɛnↄ là à pì: Bↄ́n oni kɛ gbɛ̃ kũ à Filisitini pìi dɛ̀ à Isarailanↄ bò wé'i gũnnɛɛ? Dín Filisitini gyↄfↄrↄde pì ũ, gbasa àtɛn kùsɛɛ biribiri Luda Wɛ̃̀ndide zĩ̀karinↄaa? ");
INSERT INTO bqp_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Akũ ò pìnɛ lákũ gbɛ̃nↄ tɛn o nà: Lɛn oni kɛ gbɛ̃ kũ à a dɛ̀nɛ lɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Kũ a vĩ̀ni zↄ̃kↄ̃de Ɛliabu mà Dauda tɛn yã o kũ gbɛ̃nↄ, a pↄ fɛ̃̀i à pì: À kɛ̀ dera n su laa? Dín n sã fíti nↄ tònɛ gbárannan? Má n karambaani kũ n nɛ̀sɛ vãnio dↄ̃. N su zĩ̀ gwamɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Dauda pì: Bↄ́n ma kɛ̀ɛ? Bee yã mani oroo? ");
INSERT INTO bqp_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Akũ à kpɛ dↄ̀nɛ, à gɛ̀ɛ à yã dokↄ̃nↄ pìi là gbɛ̃ pãndea. Lákũ gbɛ̃ káaku ònɛ nà, lɛn ò ònɛ lɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ò yã kũ Dauda ò pìi gbã̀ Solunɛ, akũ à a sìsi. ");
INSERT INTO bqp_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Kũ Dauda sù, à pì Solunɛ: Gbɛ̃ke sún tó swɛ̃̀ kɛ̃agu Filisitini pì yã musuro. Makũ n zↄ̀blerii, mani gɛ́ zĩ̀ ká kãao. ");
INSERT INTO bqp_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Akũ Solu pìnɛ: Ĩni fↄ̃ ǹ gɛ́ zĩ̀ ká kũ Filisitini pìioro. Nɛ́ fítimɛ n ũ. Gↄ̃gbɛ̃ pì sↄ̃ bi zĩ̀kariimɛ zaa a kɛfɛnnakɛgↄrↄa. ");
INSERT INTO bqp_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Akũ Dauda pìnɛ: Makũ n zↄ̀blerii, makũ mɛ́ madìgↄ̃ ma de sãnↄ dã. Tó músu ke mani sù à sã kũ̀ kpàsan, ");
INSERT INTO bqp_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","madì a gbɛsɛ mà a gbɛ̃ mà sã pì bo a lɛ́i. Tó à ɛ̀ra kũmao, akũ madì a kũ a lɛ́kãsãa mà gbɛ̃ mà dɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Makũ n zↄ̀blerii, ma músuu dɛ̀, ma mani dɛ̀. Filisitini gyↄfↄrↄde pì ni gↄ̃ lán pↄ́ pìnↄ bà, zaakũ àtɛn kùsɛɛ biribiri Luda Wɛ̃̀ndide zĩ̀karinↄamɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Dauda ɛ̀ra à pì: Lákũ Dikiri ma bo músu kũ manio lɛ́i nà, lɛn ani ma bo Filisitini pì ↄĩ lɛ. Akũ Solu pìnɛ: Ǹ gɛ́! Dikiri gↄ̃ kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Solu a zĩ̀ka'uta dànɛ à a mↄ̀gotɛ̃ fùraa kùnɛ, akũ à a mↄ̀ uta dànɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Dauda Solu fɛ̃nɛda lòko zĩ̀ka'uta pìia. Kũ à nà táa, akũ à fùa, zaakũ adi dↄ́nɛ kɛoro. Akũ à pì Solunɛ: Mani fↄ̃ mà gɛ́ kũ pↄ́ pìnↄro, zaakũ mádi dↄ́nɛ kɛoro. Akũ à pↄ́ pìnↄ bↄ̀tɛ pínki à kàtɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","À a gòo sɛ̀, akũ à gɛ̀ɛ à gbɛ̀ pↄ́rↄpↄrↄ sɛ̀tɛ swawɛɛn mɛ̀n sↄↄro à kà a sãdãbↄkↄn. Akũ àtɛn na Filisitini pìii, à a gbɛ̀mba kũna. ");
INSERT INTO bqp_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Akũ Filisitini pì tɛn na Daudai, a sɛ̃gbakosɛri tɛn táa o a arɛ. ");
INSERT INTO bqp_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Kũ à Dauda gwà, à è nɛ́ fíti tɛ̃ra manamɛ, akũ à dↄkɛ̀ kãao ");
INSERT INTO bqp_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","à pìnɛ: Gbɛ̃dan ma ũ, akũ n gbasa ntɛn sumai kũ gòoo yá? Akũ à a kà kũ a tãna tↄ́o. ");
INSERT INTO bqp_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Akũ à ɛ̀ra à pì: Ǹ namai ǹ gwa, bãnↄ ni n ble, nↄ̀bↄ pãsĩnↄ ni n só. ");
INSERT INTO bqp_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Dauda pìnɛ: Fɛ̃nɛda kũ sári lɛ̀kɛtɛɛo kũ sári sↄ̃ntɛon ntɛn suomai. Makũ sↄ̃, Dikiri Zĩ̀karide Isarailanↄ Luda kũ n kùsɛɛ bìribiria tↄ́n matɛn suomma. ");
INSERT INTO bqp_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Dikiri ni n namɛnɛ ma ↄĩ gbãra. Mani n dɛ mà n mì zↄ̃, mani Filisitini zĩ̀karinↄ gɛ̀nↄ kpá bãnↄa kũ nↄ̀bↄ pãsĩnↄo gbãra ò só, andunia ni dↄ̃ kũ Luda kú kũ Isarailanↄ. ");
INSERT INTO bqp_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Gbɛ̃ kũ ò kakarana lanↄ ni dↄ̃ kũ Dikiri dì zĩ̀ ble kũ fɛ̃nɛdao ke kũ sárioro. Dikiri mɛ́ a zĩ̀ gbãna vĩ, ani á nawɛrɛ ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Gↄrↄ kũ Filisitini pì tɛn na Daudai àtɛn su, akũ Dauda bàa lɛ̀ àtɛn su gu kũ oni zĩ̀ kán. ");
INSERT INTO bqp_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Akũ à ↄ dà a bↄ̀kↄn à gbɛ̀ɛ bò à dà a gbɛ̀mban. Kũ à Filisitini pìi gbã̀o, akũ à a pà a arɛa. Gbɛ̀ɛ pìi vlɛ̃̀ a arɛ pìi gũn, akũ à lɛ̀tɛ a gbɛrɛa. ");
INSERT INTO bqp_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Gbɛ̀mbaan Dauda zĩ̀i blèo Filisitini pìia. À a pào à nɛ̀, bee fɛ̃nɛda à kũnaro. ");
INSERT INTO bqp_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Akũ à bàa lɛ̀ à gɛ̀ɛ à zɛ̀ala, à a fɛ̃nɛda wòto a kpɛ́n à a dɛ̀ à a mìi zↄ̃̀o. Kũ Filisitininↄ è ń gↄ̃sa gbãna pìi gà, akũ ò lɛ̀kↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Akũ Isarailanↄ kũ Yudanↄ pɛ̀tɛńyĩ kũ wikio, ò pɛ̀ḿma ari Gata bĩnilɛa kũ Ɛkɛrↄnu bĩnilɛo. Gbɛ̃ kũ ò ń dɛdɛnↄ gɛ̀nↄ gↄ̃̀ katɛna sɛna zaa Saraimu zɛ́n ari Gata kũ Ɛkɛrↄnuo. ");
INSERT INTO bqp_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Kũ ò sù kũ pɛna Filisitininↄaao, akũ ò ń bùra pↄ́nↄ nàkↄ̃a ò tào. ");
INSERT INTO bqp_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Dauda Filisitini pìi mìi sɛ̀ à gɛ̀ɛo Yurusalɛmu, à a gↄ̃kɛbↄnↄ kàtɛ a kpɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Gↄrↄ kũ Dauda tɛn na Filisitini pìii, Solu tɛni a gwa, akũ à a zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Abana là à pì: Dí nɛ́mɛ nɛ́gↄ̃gbɛ̃ pì ũu? À wèa à pì: Kína, kũ n kunnaao, má dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Akũ kína pì: Ǹ gbɛka ǹ ma dí nɛ́n kɛfɛnna pì ũ. ");
INSERT INTO bqp_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Kũ Dauda sù kũ Filisitini pì dɛnaao, Abana a sɛ̀ à gɛ̀ɛo Solu kĩnaa, à Filisitini pìi mì kũna. ");
INSERT INTO bqp_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Akũ Solu a là à pì: Kɛfɛnna, dí nɛ́mɛ n ũu? À wèa à pì: N zↄ̀bleri Yɛsɛ, Bɛtilihamu gbɛ̃ nɛ́mɛ ma ũ. ");
INSERT INTO bqp_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Kũ Dauda yã ò kũ Soluo à làka, akũ Yonatã gbɛ̃nna kpà kãao à yei lán a zĩda wɛ̃̀ndii bà. ");
INSERT INTO bqp_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Zaa zĩ birean Solu a dìtɛ a bɛa, adi we à tá a de bɛa doro. ");
INSERT INTO bqp_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Yonatã yã yĩ̀ kãao kũ à yei lán a zĩda wɛ̃̀ndii bà yãi. ");
INSERT INTO bqp_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Akũ à a arukĩmba kũ à dana bò à a gbà kũ a zĩ̀ka'utao kũ a fɛ̃nɛdao kũ a sáo kũ a asaao. ");
INSERT INTO bqp_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Gu kũ Solu Dauda gbàrɛn zĩ̀ ká pínki, àdi sa'a kɛmɛ, akũ à a dìtɛ zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ ũ. A yã dì kɛ gbɛ̃ sĩnda pínkinɛ nnamɛ kũ Solu ìbanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Kũ zĩ̀karinↄ tɛn su Dauda Filisitini pì dɛnaa gbɛra, nↄgbɛ̃nↄ bò Isaraila wɛ̃tɛnↄ gũn pínki, ò gɛ̀ɛ da ń kína Solulɛ, òtɛn lɛ̀ sí òtɛn ũ wã, òtɛn gã̀gã lɛ́ òtɛn pↄnna kɛ òtɛn sɛ̀kɛrɛ pá. ");
INSERT INTO bqp_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Òtɛn lɛ̀ sí òtɛn dↄkↄ̃nɛ, òtɛn ũ wã òtɛn pi: Solu gbɛ̃nↄ dɛ̀dɛ wàa sↄsↄↄro, Dauda sↄ̃ dúbu lɛu ũgbangba. ");
INSERT INTO bqp_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Yã pìi kɛ̀ Solunɛ ĩni manamana, akũ a pↄ fɛ̃̀ à pì: Ò dúbu lɛu ũgbangba kpà Daudaa, makũ sↄ̃ wàa sↄsↄↄro. Kpata mɛ́ à gↄ̃̀ à sí sà. ");
INSERT INTO bqp_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Zaa zĩ birean à nɛ̀sɛgↄ̃baa kpà kãao. ");
INSERT INTO bqp_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Kũ gu dↄ̀, akũ Luda tò Solu tãna pãsĩ pìi dìa, àtɛn yã ya a kpɛ́n, akũ Dauda a mↄrↄↄ sɛ̀, àtɛn lɛ́ lákũ àdi lɛ́ nà. Solu a sári kũna, ");
INSERT INTO bqp_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","akũ à a gbã̀o, àtɛn da áni Dauda páo de à nakↄ̃a kũ gbĩ̀io. Akũ Dauda a zĩda gbã̀tɛnɛ gɛ̃̀n pla. ");
INSERT INTO bqp_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Solu tɛn vĩna kɛ Daudanɛ kũ Dikiri kú kãao akũsↄ̃ à pã kpàai yãi. ");
INSERT INTO bqp_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Akũ à pɛ̀ Daudaa a kia, à a dìtɛ zĩ̀kari gbɛ̃nↄn wàa sↄↄronↄ gbɛ̃ zↄ̃kↄ̃ ũ. Àkũ mɛ́ àdigↄ̃ tɛ́ńnɛ arɛ zĩ̀lan. ");
INSERT INTO bqp_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Gu kũ à gɛ̀ɛn pínki àdi sa'a kɛmɛ, kũ Dikiri kú kãao yãi. ");
INSERT INTO bqp_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Kũ Solu è àdigↄ̃ sa'a le, akũ à vĩna kɛ̀nɛ de yãla. ");
INSERT INTO bqp_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Isarailanↄ kũ Yudanↄ sↄ̃ ò ye Daudai ń pínki, kũ àdigↄ̃ tɛ́ńnɛ arɛ zĩ̀lan yãi. ");
INSERT INTO bqp_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Akũ Solu pìnɛ: Mani ma nɛ́nↄgbɛ̃ káaku Mɛraba kpámma nↄ ũ. Ǹ wↄ́rↄgↄ kɛ ǹ Dikiri zĩ̀ kámɛnɛ. Zaakũ Solu laasun lɛ̀ à pì: Mani ↄ kɛaro, Filisitininↄ mɛ́ oni a dɛ. ");
INSERT INTO bqp_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Akũ Dauda pìnɛ: Dín ma ũu? Dín ma bedenↄ kũ ma de burinↄ ũ kũ mani gbasa mà gↄ̃ n anzure ũu? ");
INSERT INTO bqp_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Kũ Mɛraba kà ò a kpá Daudaa, akũ Solu a kpà Mɛↄla gbɛ̃ Adariɛlia. ");
INSERT INTO bqp_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Solu nɛ́nↄgbɛ̃ Mikala ye Daudai. Kũ ò yã pìi ò Solunɛ, à kɛ̀nɛ nna ");
INSERT INTO bqp_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","à pì: Mani a kpáamɛ, ani gↄ̃nɛ tankutɛ ũ, Filisitininↄ ni a dɛ. Akũ à pì Daudanɛ: Ĩni ma nɛ́ pãnde e ǹ sɛ́ sà. ");
INSERT INTO bqp_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Akũ à pì a ìbanↄnɛ: À yã o Daudanɛ asiri gũn, à onɛ a yã kàmagu akũsↄ̃ ma ìbanↄn yei ń pínki. À ma nɛ́nↄgbɛ̃ sɛ́. ");
INSERT INTO bqp_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","A ìbanↄ yã pìi dà Daudanɛ a sãn, akũ à pìńnɛ: Gↄ̃na kína nɛ́ zã ũ bi yã aragan yá? Takasidemɛ ma ũ, dí mɛ́ à ma dↄ̃ↄ? ");
INSERT INTO bqp_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Kũ Solu ìbanↄ sù, ò Dauda yã pìi bàbanɛ. ");
INSERT INTO bqp_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Akũ Solu pì: À onɛ má ye anzure pↄ́keiro, séto à fĩna bomɛnɛ ma ibɛrɛ Filisitininↄa, à sumɛnɛ kũ ń gyↄfↄrↄnↄ mɛ̀n basↄↄro. Àtɛn da Filisitininↄ ni a dɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Kũ ìbaa pìnↄ yã pìi bàba Daudanɛ, gↄ̃na kína nɛ́ zã ũ kɛ̀nɛ nna sà. Ari nↄ pì sɛ́gↄrↄ gↄ̃ gɛ́ ká, ");
INSERT INTO bqp_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","Dauda kũ a zĩ̀karinↄ fùtɛ ò gɛ̀ɛ ò Filisitininↄ dɛ̀dɛ gbɛ̃nↄn wàa do, akũ à sù kũ ń gyↄfↄrↄnↄ à kpà kínaa pínki, de à le à gↄ̃ a nɛ́ zã ũ yãi. Akũ Solu a nɛ́ Mikala kpàa nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Kũ Solu è lɛ, à dↄ̃̀ kũ Dikiri kú kũ Daudao akũsↄ̃ a nɛ́ Mikala yei, ");
INSERT INTO bqp_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","akũ a vĩnakɛnanɛɛ kàra, à gↄ̃̀ a ibɛrɛ ũ ari à gɛ̀ɛ gào. ");
INSERT INTO bqp_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Gↄrↄ kũ Filisitini kínanↄ tɛn bↄtɛ ò gɛ́ zĩ̀ ká, Dauda dì sa'a le de Solu ìba kparanↄla, akũ à tↄ́ bò manamana. ");
INSERT INTO bqp_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Solu ò a nɛ́ Yonatãnɛ kũ a ìbanↄ ń pínki ò Dauda dɛ. Ama Yonatã yei manamana, ");
INSERT INTO bqp_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","akũ à a gbà laakarii à pì: Ma de tɛn wɛtɛ à n dɛ. Ǹgↄ̃ n zĩda kũna dↄ̃ zia kↄnkↄ. Ǹ utɛki wɛ́tɛ ǹgↄ̃ kun. ");
INSERT INTO bqp_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Mani bo wɛ̃tɛ kpɛ kũ ma deo, óni zɛ gu kũ n utɛn. Mani n yã onɛ. Lákũ à òmɛnɛ nà, mani onnɛ. ");
INSERT INTO bqp_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Akũ Yonatã gɛ̀ɛ à Dauda mana bò a denɛ à pì: Baa, ǹsun yã vãni kɛ n zↄ̀bleri Daudanɛro, zaakũ adi vãni ke kɛnnɛro. A yãkɛnanↄ àre vĩnnɛ manamana. ");
INSERT INTO bqp_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Kũ à Filisitini pìi dɛ̀, à gì a wɛ̃̀ndiiimɛ, akũ Dikiri tò o zĩ̀ zↄ̃kↄ̃ↄ blè ó pínki. N è, akũ n pↄ kɛ̀ nna. Bↄ́ yã mɛ́ à tò ń ye ǹ yã vãni kɛ taarisaride pìinɛ ǹ a dɛ pãa? ");
INSERT INTO bqp_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Solu a yã mà, akũ à yã sɛ̀ à pì: Kũ Dikirio oni a dɛro. ");
INSERT INTO bqp_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","A gbɛra Yonatã Dauda sìsi, à yã pìi bàbanɛ pínki, akũ à gɛ̀ɛ kũ Daudao Solu kĩnaa, akũ àtɛn zĩ kɛnɛ lán a zĩ bà. ");
INSERT INTO bqp_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Zĩ̀i ɛ̀ra à fùtɛ, akũ Dauda gɛ̀ɛ zĩ̀ ká kũ Filisitininↄ. À sìńgu à zĩ̀i blèḿma búgubugu, akũ ò bàa lɛ̀nɛ. ");
INSERT INTO bqp_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Dikiri tò Solu tãna pãsĩ pìi ɛ̀ra à dìa gↄrↄ kũ à vutɛna a kpɛ́n. À a sári kũna, akũ Dauda tɛni a mↄrↄ lɛ́nɛ. ");
INSERT INTO bqp_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Solu wɛ̀tɛ à Dauda páo de à a nakↄ̃a kũ gbĩ̀io. Kũ à gbã̀tɛnɛ, akũ sári pìi gɛ̀ɛ à gbĩ̀i pà. Gwãani birean Dauda bàa lɛ̀ à tà. ");
INSERT INTO bqp_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Akũ Solu gbɛ̃nↄ zĩ̀ Dauda bɛa, de ò a dãdã ò a dɛ kↄnkↄ, akũ a nanↄ Mikala a gbà laakarii à pì: Tó ńdi bàa sí gwãanialaro, oni n dɛ zia. ");
INSERT INTO bqp_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Akũ Dauda bò wondoo gũn, Mikala a gbàrɛ kũ bàao zĩtɛ, akũ à bàa lɛ̀ à gɛ̃̀ zɛ́la. ");
INSERT INTO bqp_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Akũ Mikala tãna sɛ̀ à wùtɛ gádoa, à blè bára sɛ̀ à kù tãna pìi mìla, akũ à biza kùala. ");
INSERT INTO bqp_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Kũ Solu gbɛ̃nↄ zĩ̀ ò Dauda kũ, Mikala pì à gbãnaro. ");
INSERT INTO bqp_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Akũ Solu ɛ̀ra à gbɛ̃nↄ zĩ̀ Dauda gwa à pìńnɛ: À a sɛ́ kũ a gádoo lɛɛlɛ, à su kãaomɛnɛ de mà a dɛ. ");
INSERT INTO bqp_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Kũ ò gɛ̃̀ kpɛ́n, tãna pìin ò è gádoa, blè bára kú a mìla. ");
INSERT INTO bqp_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Akũ Solu Mikala là à pì: Bↄ́yãi n bo ma kpɛ n ma ibɛrɛ gbàrɛ à pìtima lɛɛ? Mikala wèa à pì: À pìmɛnɛ mà tó à gɛ̃ zɛ́la. Tó ma gi, áni ma dɛ. ");
INSERT INTO bqp_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Kũ Dauda bàa lɛ̀ à gɛ̃̀ zɛ́la, à gɛ̀ɛ Samuɛli gwa zaa Rama. À yã kũ Solu kɛ̀arɛ bàbanɛ pínki, akũ ò gɛ̀ɛ ò vùtɛ Nayo lɛɛlɛ. ");
INSERT INTO bqp_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Kũ ò ò Solunɛ Dauda kú Nayo zaa Rama, ");
INSERT INTO bqp_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","akũ Solu gbɛ̃nↄ zĩ̀ ò a kũ. Kũ ò kà gwe, ò lè annabi gã̀ tɛn dɛdɛ, Samuɛli kú ń tɛ́ ń don'arɛde ũ. Akũ Luda Nini sù zĩ̀rii pìnↄa, òtɛn dɛdɛ se. ");
INSERT INTO bqp_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Kũ ò ò Solunɛ, akũ à gbɛ̃ pãndenↄ zĩ̀, akũ ò dɛ̀dɛ lɛ se. Solu ɛ̀ra à gbɛ̃nↄ zĩ̀ a gɛ̃̀n aakↄ̃de, akũ ò dɛ̀dɛ lɛ se dↄ. ");
INSERT INTO bqp_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Akũ Solu pìi fùtɛ àtɛn gɛ́ Rama a zĩda sà. Kũ à kà lↄ̀gↄ zↄ̃kↄ̃ kũ à kú Sɛku sarɛ, à gbɛ̃nↄ là à pì: Samuɛli kũ Daudao kú mámɛɛ? Akũ ò pìnɛ: Ò kú Nayo zaa Rama. ");
INSERT INTO bqp_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Kũ àtɛn gɛ́ gwe, akũ Luda Nini sù bee àpiia se, àtɛn gɛ́ àtɛn dɛdɛ, ari à gɛ̀ɛ à kao Nayo zaa Rama. ");
INSERT INTO bqp_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","À a pↄ́kasanↄ pìtiawa, à dɛ̀dɛ Samuɛli wára. Zĩ birea fãnantɛ̃ kũ gwãanio pínki àdigↄ̃ wutɛna punsimɛ. À yã mɛ́ à tò òdi pi: Solu kú annabinↄ tɛ́ dↄ see? ");
INSERT INTO bqp_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Dauda bò Nayo zaa Rama, à bàa lɛ̀ à gɛ̀ɛ à Yonatã lè, akũ à a là à pì: Bↄ́n ma kɛ̀ɛ? Dà kpaten ma kɛ̀ɛ? Yã vãni kpaten ma kɛ̀ n denɛ kũ àtɛn wɛtɛ à ma dɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","À wèa à pì: Gyam! Ĩni garo. Ǹ gwa, ma de dìgↄ̃ yãke kɛ à gí damɛnɛ ma sãnyĩro, yã zↄ̃kↄ̃ ke a fítinnan yá. Ma de nigↄ̃ yã dí taka kɛ à gí omɛnɛi yá? Lɛnlo! ");
INSERT INTO bqp_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Akũ Dauda pì dↄ: N de dↄ̃ sãnsãn kũ ma n pↄnna è. Abire yãin adi tó n yã pìi màro, de n pↄ sún yakaro yãi. Kũ Dikiri kunnaao kũ n kunnaao má kú ga lɛ́imɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Akũ Yonatã pìnɛ: Pↄ́ kũ n yei pínki mani kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Akũ Dauda pìnɛ: Ǹ gwa, mↄ dufu dikpɛmɛ zia. À kũ̀ mà vutɛ mà pↄ́ ble kũ kínaomɛ. Ǹ tó mà gɛ́ mà utɛ sɛ̃̀ntɛ ari ziando ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Tó n de ma gbɛka, ǹ pinɛ ma zɛ́ gbɛ̀kamma mà gɛ́ ma bɛ wɛ̃tɛa Bɛtilihamu likalika, kũ ma bedenↄ pínki tɛn sa kũ òdi o wɛ̃̀ kũ wɛ̃̀ɛo o gwe yãi. ");
INSERT INTO bqp_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Tó à pì à mana, manigↄ̃ aafia, ama tó a pↄ fɛ̃̀ manamana, ǹgↄ̃ dↄ̃ kũ yã vãnin à zɛ̀o à kɛmɛnɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Ǹ gbɛ̃kɛ kɛ makũ n zↄ̀bleriinɛ, zaakũ n yã yĩ̀ kũmao kũ Dikiri dↄ̃naaomɛ. Tó má taari vĩ, ǹ ma dɛ n zĩda. Ǹsun ma kpá n dearo. ");
INSERT INTO bqp_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Akũ Yonatã pì: Gyam! Tó má dↄ̃ kũ ma de zɛ̀o à vãni kɛnnɛ, de mani onnɛroo? ");
INSERT INTO bqp_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Akũ Dauda a là à pì: Tó n de sù à yã pãsĩ ònnɛ, dí mɛ́ ani omɛnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Akũ Yonatã pìnɛ: Ǹ mↄ́ ò gɛ́ sɛ̃̀ntɛ. Akũ ò bↄ̀tɛ ò gɛ̀ɛ sɛ̃̀ntɛ ń pla. ");
INSERT INTO bqp_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Akũ Yonatã pì: Ma sì kũ Dikiri Isarailanↄ Ludao, ari ziando mandara'i mani ma de yↄ̃ mà gwa. Tó n yã kɛ̀nɛ, mani lɛ́gbãzã kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Tó ma de ye à vãni kɛnnɛmɛ sↄ̃, akũ mádi lɛ́gbãzã kɛnnɛ ma n gbarɛ n ta aafiaro, Dikiri yã kɛmɛnɛ pãsĩpãsĩ. Dikiri gↄ̃ kú kũnwo lákũ à kú kũ ma deo yã nà. ");
INSERT INTO bqp_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Lákũ má kú kũ wɛ̃̀ndiio nà ǹ gbɛ̃kɛ kɛmɛnɛ lákũ Dikiri dì kɛńnɛ nà, kũ òsun ma dɛro yãi. ");
INSERT INTO bqp_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","N gbɛ̃kɛ sún laka kũ ma bedenↄ zikiro, bee tó Dikiri tò n ibɛrɛnↄ làka andunia gũn. ");
INSERT INTO bqp_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Lɛn Yonatã yã yĩ̀ kũ Daudao lɛ, akũ à pì: Dikiri fĩna bonnɛ n ibɛrɛnↄa. ");
INSERT INTO bqp_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Akũ Yonatã tò Dauda ɛ̀ra a la dàarɛ dↄ a yeina yãi, zaakũ à yei lán a zĩda wɛ̃̀ndii bàmɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Akũ Yonatã pìnɛ: Mↄ dufu dikpɛ kun zia. Tó odi gbɛ̃ke e n vutɛkinlo, oni n gbɛkamɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Ziando ǹ gɛ́ ǹ utɛ gu kũ n utɛn yã pì naana gↄrↄ, ĩnigↄ̃ kú gbɛ̀ kũ à de zĩtɛ lɛ́ sèeda ũ sarɛ gwe. ");
INSERT INTO bqp_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Mani kà zu gbɛ̀ɛ pìi sarɛ wɛ́n aakↄ̃ lándↄ̃ matɛn pↄ́ gbã bà, ");
INSERT INTO bqp_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","mani nɛ́gↄ̃gbɛ̃ ke zĩ à gɛ́ kàa pìnↄ wɛtɛ. Tó ma pìnɛ, kànↄn kú a kpɛ, à sɛ́tɛ à mↄ́o, ǹ mↄ́, ma sì kũ Dikirio ĩnigↄ̃ aafiamɛ, kari yã kunlo. ");
INSERT INTO bqp_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Tó ma pìnɛ kànↄn kú a arɛ sↄ̃, ǹ gɛ́, zaakũ Dikiri mɛ́ à n gbarɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Yã kũ o yĩ̀ kũ kↄ̃o sↄ̃, Dikiri mɛ́ anigↄ̃ de yã pìi sèedade ũ gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Akũ Dauda gɛ̀ɛ à ùtɛ sɛ̃̀n. Kũ mↄ dufu bò, kína vùtɛ de à pↄ́ ble. ");
INSERT INTO bqp_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","À vùtɛ a vutɛkia gbĩ̀i sarɛ. Yonatã vùtɛ a arɛ, Abana kú a sarɛ. Dauda vutɛki sↄ̃, gbɛ̃ke kú gwero. ");
INSERT INTO bqp_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Solu dí yãke o zĩ birearo, zaakũ àtɛn da yãke mɛ́ à a lè, gbãsĩ nàamɛ, abirekũ mɛ́ à gìnɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Kũ gu dↄ̀ mↄ gↄrↄ plade zĩ, Dauda vutɛki da korimɛ, akũ Solu a nɛ́ là à pì: Bↄ́yãi Yɛsɛ nɛ́ dí su pↄ́ ble gĩa kũ gbãraoroo? ");
INSERT INTO bqp_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Akũ à pìnɛ: À zɛ́ gbɛ̀kama à pì áni gɛ́ Bɛtilihamu. ");
INSERT INTO bqp_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","À pì mà tó à gɛ́, zaakũ a bedenↄ tɛn sa o wɛ̃tɛ pìi gũmmɛ, akũ a vĩ̀ni pìarɛ à mↄ́. À pì tó à kɛ̀mɛnɛ, mà a gbarɛ à gɛ́ a vĩ̀ninↄ gwa. À yã mɛ́ à tò adi su pↄ́ ble kũnworo. ");
INSERT INTO bqp_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Akũ Solu pↄ fɛ̃̀ Yonatãi à pì: Nɛ́ fayasari sãgbãnade! Má dↄ̃ kũ n zɛ kũ Yɛsɛ nɛ́omɛ. N wé'i dà n zĩdaa kũ n dao. ");
INSERT INTO bqp_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Tó Yɛsɛ nɛ́ pì gↄ̃ kú kũ wɛ̃̀ndiio, ĩni le ǹ kpata blero. Ǹ gbɛ̃nↄ zĩ ò a kũ ò su kãaomɛnɛ tera. À gàn gwe. ");
INSERT INTO bqp_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Akũ Yonatã a là à pì: Bↄ́ yã mɛ́ à tò ani gaa? Bↄ́n à kɛ̀ɛ? ");
INSERT INTO bqp_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Akũ Solu Yonatã gbã̀ kũ sário de à le à a dɛ, akũ Yonatã dↄ̃̀ sà kũ a de zɛ̀ kũ Dauda dɛnaaomɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Yonatã fùtɛ à gò pↄ́blea kũ pↄfɛ̃o, adi pↄ́ ble mↄ gↄrↄ plade pì zĩro, zaakũ a nɛ̀sɛɛ yàka Dauda yã musu, kũ a de a dìtɛ gbɛ̃ futa ũ yãi. ");
INSERT INTO bqp_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Kũ gu dↄ̀, Yonatã bò à gɛ̀ɛ Dauda le gu pìn. Nɛ́gↄ̃gbɛ̃ ke tɛ́i. ");
INSERT INTO bqp_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Akũ à pì nɛ́ pìinɛ. Ǹ bàa lɛ́ ǹ gɛ́ zã̀ dire. Tó ma kà zù, ǹ wɛtɛ. Kũ nɛ́ pìi bàa lɛ̀ àtɛn gɛ́, akũ Yonatã kàa zù a mìla. ");
INSERT INTO bqp_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Kũ nɛ́ pìi kà gu kũ Yonatã kàa pɛ̀tɛn, akũ à lɛ́ zù nɛ́ pìii à pì: Kàa pìnↄn kú n arɛ dire. ");
INSERT INTO bqp_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Akũ Yonatã ɛ̀ra à lɛ́ zùi dↄ à pì: Ǹ gɛ́ likalika, ǹsun zɛro. Akũ nɛ́ pìi kàa pìnↄ sɛ̀tɛ à sùo a dikiriinɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Nɛ́ pì dí yã pì dↄ̃ro, sé Yonatã kũ Daudao. ");
INSERT INTO bqp_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Akũ Yonatã a gↄ̃kɛbↄnↄ kpà nɛ́ pìia à pì: Ǹ sí ǹ táo bɛ. ");
INSERT INTO bqp_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Kũ nɛ́ pìi tà, Dauda fùtɛ gbɛ̀ kpɛ à sù à kùtɛ Yonatãnɛ gɛ̃̀n aakↄ̃ à wùtɛ a gbɛrɛa. Akũ ò lɛ́ pɛ̀kↄ̃a ò ↄ́ↄ dↄ̀ ń pla ń pínki, Dauda pↄ́ mɛ́ à kɛ̀ zↄ̃kↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Akũ Yonatã pìnɛ: Ǹ tá aafia, zaakũ o yã sɛ̀ kũ Dikiri tↄ́o o pì, Dikirimɛ ó sèedade ũ ma burinↄ kũ n burinↄ dagura ari gↄrↄ sĩnda pínki. Dauda bò gwe, akũ Yonatã ɛ̀ra à tà bɛ. ");
INSERT INTO bqp_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Kũ Dauda tɛn gɛ́ sa'oriki Aimɛlɛki kĩnaa Nↄbu, Aimɛlɛki pìi bò à gɛ̀ɛ à daalɛ. Vĩna a kũ̀, akũ à a là à pì: Bↄ́ mɛ́ à tò ntɛn kure ndo, gbɛ̃ke kú kũnworoo? ");
INSERT INTO bqp_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Dauda wèa à pì: Kína mɛ́ à zĩ dàmɛnɛ, à pì màsun tó gbɛ̃ke yã kũ a dìtɛmɛnɛ à ma zĩ mà kɛ dↄ̃ro. Akũ o gu dàkↄ̃nɛ kũ ma ìbanↄ ò domɛnɛ arɛ. ");
INSERT INTO bqp_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Pↄ́ble kpaten ń vĩ la teraa? Ǹ ma gba burodi mɛ̀n sↄↄro kesↄ̃ pↄ́ kũ ń vĩ pínki. ");
INSERT INTO bqp_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Akũ sa'oriki pìi pì: Burodi pã kunlo, séde pↄ́ kũ ò kàtɛ Ludanɛ baasiro. Tó n gbɛ̃nↄ dí kakara kũ nↄgbɛ̃oro, mani kpámma. ");
INSERT INTO bqp_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Akũ Dauda pìnɛ: À de lɛ kↄ̀, ó ó zĩda kũna nↄgbɛ̃nↄ yã musu, lákũ odì kɛ nà gbasa ò da zĩ̀kazɛn. Ma gbɛ̃nↄ mɛ̀nↄn gbãsĩro. Bee gↄrↄ kũ ótɛn pↄyeina táa o, òdigↄ̃ gbãsĩro, atɛ̃nsa tá kũ ótɛn o gbãra. ");
INSERT INTO bqp_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Akũ sa'oriki pìi Luda burodii sɛ̀ à kpàa, zaakũ burodi ke kú gwero, sé pↄ́ kũ ò kàtɛ Ludanɛ. Òdi burodii pì sɛ́ Dikiri arɛmɛ, akũ òdi a lilin kɛ kũ burodi dufuo. ");
INSERT INTO bqp_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Solu ìbanↄ doke kú gwe gↄrↄ pìia, a tↄ́n Doɛgi. Ɛdↄmu burimɛ, àkũ mɛ́ à Solu sãdãrikina ũ. ");
INSERT INTO bqp_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Akũ Dauda Aimɛlɛki là à pì: Ń sári ke fɛ̃nɛda vĩ la yá? Mádi le ma a fɛ̃nɛda ke gↄ̃kɛbↄ ke sɛ̀ro, zaakũ kína zĩ pìi dàmɛnɛ likalikamɛ. ");
INSERT INTO bqp_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Sa'oriki pìi wèa à pì: Filisitini kũ n dɛ̀ Ela guvutɛn Gↄlaya fɛ̃nɛda kú la. À kú uta lokomma kpɛ, biza fĩfĩa. Tó ń yei, ǹ sɛ́, zaakũ a pãnde kú la doro, séde abirekũ. Akũ Dauda pì: Ǹ kpáma, a sára kunlo. ");
INSERT INTO bqp_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Dauda bàa lɛ̀ Solunɛ zĩ birea, à tà Gata kína Akisi kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Akũ Akisi ìbanↄ pìnɛ: Isarailanↄ bùsu kína Daudan díroo? Àkũmɛ òdi ũ wã ò lɛ̀ sí a yã musuroo? Òdi pi: Solu gbɛ̃nↄ dɛ̀dɛ wàa sↄsↄↄro, Dauda sↄ̃ dúbu lɛu ũgbangba. ");
INSERT INTO bqp_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Yã pì Dauda kũ̀ gbãna, àtɛn vĩna kɛ Akisinɛ manamana. ");
INSERT INTO bqp_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Akũ à a zĩda lìtɛ, àtɛn ĩadeyãnↄ kɛkɛ ń wára. À ↄgbɛ gàtɛgatɛ bĩni zɛ́ gbànↄa, à tò lɛ́'i dà a lɛ́kãsãa. ");
INSERT INTO bqp_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Akũ Akisi pì a ìbanↄnɛ: À gwa! Gbɛ̃ pì bi ĩademɛ. Bↄ́yãin a a sɛ̀ a su kãao ma kĩnaaa? ");
INSERT INTO bqp_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Ĩadenↄ kĩ̀amamɛɛ, akũ a gbɛ̃ pìi sɛ̀ a su kãao ma kĩnaa de a ĩadeyãnↄ kɛkɛmɛnɛ yá? Ani le à gɛ̃ ma ↄnnlo. ");
INSERT INTO bqp_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Dauda bò gwe à bàa lɛ̀, à gɛ̀ɛ à gɛ̃̀ Adulamu gbɛ̀wɛɛn. Kũ a vĩ̀ninↄ kũ a de bedenↄ a baaruu mà, ò gɛ̀ɛ ò a lè gwe. ");
INSERT INTO bqp_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Yã'ũmmadenↄ kũ fĩnadenↄ kũ gbɛ̃ kũ yã dì kɛńnɛronↄ kàkarai ń pínki, akũ à gↄ̃̀ ń gbɛ̃ zↄ̃kↄ̃ ũ. Ò kà gbɛ̃nↄn wàa pla taka bà. ");
INSERT INTO bqp_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Bona zaa gwe Dauda gɛ̀ɛ Mizipa, Mↄabunↄ bùsun, à pì Mↄabu kínanɛ: Ǹ ma de kũ ma dao gba zɛ́ ògↄ̃ kú kũnwo ari mà dↄ̃ lákũ Luda ni kɛmɛnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Akũ à ń tó kũ Mↄabu kínao gwe. Ò kú kãao gↄrↄ kũ Dauda kú sɛ̃̀ntɛpↄrↄtu. ");
INSERT INTO bqp_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Abire gbɛra annabi Gada sù à yã ò Daudanɛ à pì: Ǹsungↄ̃ kú sɛ̃̀ntɛpↄrↄtu doro. Ǹ ɛra ǹ tá Yudanↄ bùsun. Akũ à fùtɛ à gɛ̀ɛ Ɛrɛti líkpɛn. ");
INSERT INTO bqp_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Zĩkea Solu vutɛna sãma lí gbáru Gibɛa sĩ̀sĩia. À a sári kũna, a ìbanↄ lìkai ń pínki. Akũ à mà ò Dauda kũ gbɛ̃ kũ ò kú kãaonↄ kúki dↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Akũ à pì a ìbaa pìnↄnɛ: Ákↄ̃nↄ Biliaminu burinↄ, à ma yã ma á pínki. Yɛsɛ nɛ́ ni buranↄ kũ geepi búnↄ kpááwa yá? Ani á ditɛ zĩ̀kari gbɛ̃nↄn wàa sↄsↄↄro ke gbɛ̃nↄn basↄsↄↄronↄ gbɛ̃ zↄ̃kↄ̃nↄ ũ yá? ");
INSERT INTO bqp_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Á pínki a lɛ́ kpàkũsũmaimɛ. Kũ ma nɛ́ yã yĩ̀ kũ Yɛsɛ nɛ́o, á gbɛ̃ke dí omɛnɛro. Á gbɛ̃ke dí ma wɛ̃nda gwaro. Ádi damɛnɛ ma sãn kũ ma nɛ́ ma ìbaa pìi nɛ̀sɛɛ fùtɛ àgↄ̃ ma wɛtɛ à ma dɛ, lákũ àtɛn kɛ nà teraro. ");
INSERT INTO bqp_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Ɛdↄmu buri Doɛgi kú kũ Solu ìbanↄ gwe, akũ à pì: Ma Yɛsɛ nɛ́ è, à sù Aitubu nɛ́ Aimɛlɛki kĩnaa Nↄbu. ");
INSERT INTO bqp_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","À yã gbɛ̀kanɛ Dikiria, akũ à zànaa kpàa kũ Filisitini buri Gↄlaya fɛ̃nɛdao. ");
INSERT INTO bqp_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Akũ kína gbɛ̃nↄ zĩ̀ ò sa'oriki Aimɛlɛki sísi kũ a de bede kũ ò de sa'orinↄ ũ Nↄbunↄ ń pínki. Akũ ò sù kína kĩnaa ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Akũ Solu pìnɛ: Ǹ sã kpá ǹ ma, Aitubu nɛ́. À wèa à pì: Ma sã wɛ̃̀, Baa. ");
INSERT INTO bqp_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Akũ Solu a là à pì: Bↄ́yãin mↄkↄ̃n kũ Yɛsɛ nɛ́o a lɛ́ kpàkũsũmaii? Bↄ́yãin n pↄ́ble kpàa kũ fɛ̃nɛdaoo? N yã gbɛ̀kanɛ Ludaa, de à futɛmai àgↄ̃ ma wɛtɛ à ma dɛ, lákũ àtɛn kɛ nà tera. ");
INSERT INTO bqp_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Aimɛlɛki wèa à pì: N ìbanↄ tɛ́ pínki, dí mɛ́ à náani vĩ à kà Dauda ũu? N nɛ́ zãmɛ, n zĩda dogarinↄ kínamɛ. À tↄ́ bò n bɛa. ");
INSERT INTO bqp_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Mádi gbɛkanɛ Ludaa yãroo? Kai! Baa, ǹsun yã dí makũ n zↄ̀bleriiaro ke ma de bedenↄ, zaakũ má yãke dↄ̃ yã pìi musuro, bee fíti. ");
INSERT INTO bqp_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Akũ kína pìnɛ: Ĩni gamɛ, mↄkↄ̃n kũ n de bedenↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Akũ à ò dogari kũ ò kú gwenↄnɛ à pì: À futɛ à Dikiri gbàgbarinↄ dɛdɛ, zaakũ ń ↄ kú Dauda yãmmɛ. Ò a bàasina yã dↄ̃, akũ odi omɛnɛro. Ama a ìbaa pìnↄ dí we ò ↄ sɛ̀ ò Dikiri gbàgbarii pìnↄ dɛ̀dɛro. ");
INSERT INTO bqp_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Akũ kína pì Doɛginɛ: Ǹ futɛ ǹ sa'ori pìnↄ dɛdɛ. Akũ à fùtɛ à ń dɛdɛ gↄ̃̀nↄ. À sa'o'utadarii pìnↄ dɛ̀dɛ gbɛ̃nↄn basiikↄ̃ awɛɛsↄↄro. ");
INSERT INTO bqp_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Akũ Solu ɛ̀ra à sa'orii pìnↄ wɛ̃tɛ Nↄbudenↄ dɛ̀dɛ dↄ, gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ kũ nɛ́ gbãnanↄ kũ nɛ́kpãntɛ̃nↄ kũ zùnↄ kũ zaakinↄ kũ sãnↄ. Ò ń dɛdɛ kũ fɛ̃nɛdao ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Akũ Aimɛlɛki nɛ́ ke pìtiḿma, a tↄ́n Abiata. À bàa lɛ̀ à gɛ̀ɛ à nà Daudai. ");
INSERT INTO bqp_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","À pì Daudanɛ, Solu Dikiri gbàgbarinↄ dɛ̀dɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Akũ Dauda pìnɛ: Kũ ma Ɛdↄmu buri Doɛgi è gwe zĩ birea, má dↄ̃ sãnsãn kũ ani o Solunɛ. Ma yãin ò n de bedenↄ dɛ̀dɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Ǹgↄ̃ kú kũmao. Ǹsun tó vĩna n kũro. Gbɛ̃ kũ àtɛni n wɛtɛ à n dɛ tɛni ma wɛtɛ à ma dɛ se. Yãke ni n le ma ↄĩro. ");
INSERT INTO bqp_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Ò ò Daudanɛ ò pì: Ǹ gwa, Filisitininↄ tɛn zĩ̀ ká kũ Kɛiladenↄ, òtɛni ń pↄ́wɛnↄ nakↄ̃a. ");
INSERT INTO bqp_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Akũ Dauda gbɛ̀ka Dikiria à pì: Mà gɛ́ mà lɛ́tɛ Filisitini pìnↄan yá? Akũ Dikiri pìnɛ: Ǹ gɛ́ ǹ lɛ́tɛḿma ǹ Kɛiladenↄ sura ba. ");
INSERT INTO bqp_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Akũ Dauda gbɛ̃nↄ pìnɛ: Lákũ vĩna tɛni ó kũ Yudanↄ bùsun la nà, óni fↄ̃ ò gɛ́ ò zĩ̀ ká kũ Filisitininↄ Kɛila yá? ");
INSERT INTO bqp_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Dauda ɛ̀ra à gbɛ̀ka Dikiria dↄ, akũ Dikiri pìnɛ: Ǹ futɛ ǹ gɛ́ Kɛila, zaakũ mani Filisitininↄ nannɛ n ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Akũ Dauda gɛ̀ɛ Kɛila kũ a gbɛ̃nↄ, à zĩ̀i kà kũ Filisitininↄ, akũ à ń pↄ́kãdenↄ sìḿma. À Filisitininↄ dɛ̀dɛ dasidasi, akũ à Kɛiladenↄ sura bà. ");
INSERT INTO bqp_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Kũ Aimɛlɛki nɛ́ Abiata bàa lɛ̀ àtɛn gɛ́ Dauda kĩnaa yã, à a sa'o'uta kũna, akũ à gɛ̀ɛo Kɛila. ");
INSERT INTO bqp_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Kũ Solu mà Dauda gɛ̀ɛ Kɛila, à pì: Luda gìimɛ, akũ à a nàmɛnɛ ma ↄĩ, zaakũ à a zĩda tàta wɛ̃tɛ bĩnide gũmmɛ. ");
INSERT INTO bqp_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Solu a zĩ̀karinↄ kàkara ń pínki, de ò gɛ́ Dauda kagura kɛ kũ a gbɛ̃nↄ zaa Kɛila. ");
INSERT INTO bqp_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Kũ Dauda mà Solu tɛni a vãni kpákũsũ kãao, akũ à pì sa'ori Abiatanɛ à mↄ́ kũ sa'o'utao. ");
INSERT INTO bqp_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Akũ Dauda pì: Dikiri Isarailanↄ Luda, makũ n zↄ̀bleri ma mà Solu tɛn zɛ́ wɛ́tɛ à su Kɛila à wɛ̃tɛ díkĩna kakatɛ ma yãi. ");
INSERT INTO bqp_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Kɛiladenↄ ni ma kpáan yá? Solu ni su la lákũ ma mà nàn yá? Dikiri Isarailanↄ Luda, ǹ o makũ n zↄ̀bleriinɛ. Akũ Dikiri pìnɛ: Ani su. ");
INSERT INTO bqp_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Akũ Dauda a là dↄ: Kɛiladenↄ ni ma kpáa kũ ma gbɛ̃nↄn yá? Akũ Dikiri pì: Oni á kpáamɛ. ");
INSERT INTO bqp_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Akũ Dauda kũ a gbɛ̃nↄ fùtɛ, ò kà gbɛ̃nↄn wàa aakↄ̃ taka bà. Kũ ò bò Kɛila, akũ òtɛn gɛ́ gu kũ guo. Kũ Solu mà Dauda bò Kɛila, adi gɛ́ gwe doro. ");
INSERT INTO bqp_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Dauda kú zɛki gbãnan gbárannan Zifi bùsu sĩ̀sĩden. Lákũ gu dìgↄ̃ dↄ nà Solu dìgↄ̃ a wɛtɛ à dɛ, ama Luda dí Dauda nanɛ a ↄĩro. ");
INSERT INTO bqp_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Gↄrↄ kũ Dauda kú Zifi bùsu líkpɛn, à mà Solu kũ a gbɛ̃nↄ tɛn su a dɛ. ");
INSERT INTO bqp_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Akũ Solu nɛ́ Yonatã fùtɛ à gɛ̀ɛ à Dauda lè zaa líkpɛ pìn, à a gbà swɛ̃̀ɛ kũ Luda tↄ́o. ");
INSERT INTO bqp_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","À pìnɛ: Ǹsun tó vĩna n kũro, zaakũ ma de ni le à ↄ nammaro. Mↄkↄ̃n mɛ́ ĩni kí ble Isarailanↄa, makũ sↄ̃ manigↄ̃ de n plade ũ. Ma de pì abirekũ dↄ̃ se. ");
INSERT INTO bqp_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Akũ ò yã yĩ̀ kũ kↄ̃o ń pla Dikiri arɛ. Dauda gↄ̃̀ líkpɛn gwe, akũ Yonatã tà bɛ. ");
INSERT INTO bqp_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Abire gbɛra Zifidenↄ gɛ̀ɛ ò Solu lè Gibɛa ò pì: Dauda utɛna ó bùsun sɛ̃̀ntɛpↄrↄtu. À kú líkpɛn Akila sĩ̀sĩgɛrɛɛi Yɛsimↄ gɛ̀nↄmidↄki kpa. ");
INSERT INTO bqp_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Kína, gↄrↄ kũ ń yei pínki, ǹ su gwe, óni a kpámma. ");
INSERT INTO bqp_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Akũ Solu pì: Dikiri arubarika daágu kũ a ma wɛ̃nda gwà yãi. ");
INSERT INTO bqp_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","À tá à ɛra à soru kɛ. À gu kũ àdi gɛ́n gbɛkagbɛka kũ gbɛ̃ kũ ò a ènↄ, zaakũ ma mà ò pì, a ↄ̃ndↄ̃ bi ↄ̃ndↄ̃nlo. ");
INSERT INTO bqp_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","À gbɛkagbɛka de à le à a utɛkinↄ dↄ̃ pínki, à ɛra à su à ma le, de mà a yã ma sãnsãn, mani gɛ́ kãáo. Tó à kú á bùsun gwemɛ, mani pɛ́tɛi Yuda burinↄ tɛ́ pínki. ");
INSERT INTO bqp_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Akũ ò dà zɛ́n, ò dò Solunɛ arɛ gɛna Zifi. Dauda kũ a gbɛ̃nↄ sↄ̃ ò kú Maↄni gbárannan sɛ̃̀ntɛ Yɛsimↄ gɛ̀nↄmidↄki kpa. ");
INSERT INTO bqp_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Kũ Solu kũ a gbɛ̃nↄ tɛn su pɛ́tɛi, à a baaruu mà, akũ à kìpa kpi pìia à gɛ̀ɛ à kú Maↄni gbárannan. Kũ Solu mà, akũ à pɛ̀tɛi Maↄni gbárannan gwe. ");
INSERT INTO bqp_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Solunↄ tɛn táa o kpi kpɛ dire kpa, Daudanↄ tɛn táa o a kpɛ la kpa, òtɛn wã òtɛn bàa lɛ́ Solunɛ. Gↄrↄ kũ Solu kũ a gbɛ̃nↄ tɛn lika Daudanↄi ò ń kũ, ");
INSERT INTO bqp_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","akũ gbɛ̃ke sù à baaruu kpà Solunɛ à pì: Ǹ kɛ likalika, Filisitininↄ sù ò lɛ̀tɛ ó bùsuua. ");
INSERT INTO bqp_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Akũ Solu pɛtɛna Daudaii tò, à gɛ̀ɛ Filisitininↄ le. Abire yãi òdi gu pì sísi Kↄ̃kpaatɛkpi. ");
INSERT INTO bqp_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Abire gbɛra Dauda bò gwe à gɛ̀ɛ à vùtɛ sɛ̃̀ntɛpↄrↄtu, gu kũ òdi pi Ɛngɛdi. ");
INSERT INTO bqp_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Kũ Solu sù kũ pɛtɛna Filisitininↄiio, ò pìnɛ Dauda kú Ɛngɛdi gbárannan. ");
INSERT INTO bqp_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Akũ à Isaraila zĩ̀karinↄ sɛ̀tɛ gbɛ̃nↄn wàa gɛ̃ro à dà kũńwo zɛ́n, de ò Daudanↄ wɛtɛ gu kũ òdi pi Zↄ̃nↄ Gbɛ̀ɛa. ");
INSERT INTO bqp_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Kũ à kà sãnↄ kara kũ à kú zɛ́ sarɛ kĩnaa, à gbɛ̀wɛɛɛ è gwe, akũ à gɛ̃̀n à bĩnisarɛ kɛ. Dauda kũ a gbɛ̃nↄ sↄ̃, ò kú gbɛ̀wɛɛɛ pìn zaa a lɛ́zɛkia. ");
INSERT INTO bqp_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Akũ Dauda gbɛ̃nↄ pìnɛ: Ǹ gwa, a gↄrↄn gbãra kũ Dikiri pì áni n ibɛrɛ nannɛ n ↄĩ ǹ yã kɛnɛ lán ń yei nà. Akũ Dauda fùtɛ tɛɛnɛ, à Solu arukĩmba lɛ́ zↄ̃̀ a sarɛ. ");
INSERT INTO bqp_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","A gbɛra Dauda laasun tɛn wari dↄa Solu uta lɛ́ kũ à zↄ̃̀ↄ pì yãi, ");
INSERT INTO bqp_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","à pì a gbɛ̃nↄnɛ: Kai! Dikiri sún tó mà yã dí taka kɛ ma dikiri kũ à a kàanɛro. Mani ↄ kɛaro, zaakũ Dikiri mɛ́ à a kà kín. ");
INSERT INTO bqp_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Dauda kpãkɛ̃ a gbɛ̃nↄi kũ yã pìio, adi tó ò Solu dɛ̀ro. Kũ Solu bò gbɛ̀wɛɛn, àtɛn gɛ̃ zɛ́la, ");
INSERT INTO bqp_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","akũ Dauda bò gbɛ̀wɛɛɛ pìn, à lɛ́ zùi à pì: Ma dikiri kína! Kũ Solu lìtɛ à a kpɛ gwà, akũ Dauda kùtɛ à wùtɛ a gbɛrɛa. ");
INSERT INTO bqp_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Akũ à pì Solunɛ: Tó ò pì ma yã vãni kpàkpa n musu, bↄ́ yã mɛ́ à tò ndì síi? ");
INSERT INTO bqp_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ǹ gwa! N wɛ́ è gbãra lákũ Dikiri n namɛnɛ ma ↄĩ nà gbɛ̀wɛɛn. Ò pìmɛnɛ mà n dɛ, akũ ma n wɛ̃nda gwà, ma pì mani ↄ kɛ ma dikiriaro, zaakũ Dikiri mɛ́ à a kà kín. ");
INSERT INTO bqp_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Ǹ gwa dí Baa! Ǹ gwa, má n uta lɛ́ kũna dí! Ma n uta lɛ́ zↄ̃̀, ama mádi n dɛro. N dↄ̃̀ sà kũ má n kũna kũ nɛ̀sɛ vãnioro. Mádi taari kɛnnɛro, akũ ntɛni ma wɛtɛ ǹ ma dɛ. ");
INSERT INTO bqp_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Dikiri yã gↄ̃gↄ̃wɛrɛ à fĩna bommamɛnɛ, ama makũ mani ↄ nammaro. ");
INSERT INTO bqp_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Lákũ ò yáasi zù zaa zĩ nà ò pì, yã vãni dì bo yãvãnikɛrinↄ kĩnaamɛ, mani ↄ nammaro. ");
INSERT INTO bqp_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Mↄkↄ̃n Isarailanↄ kína, dí yãin n boo? Dín ntɛn pɛ́tɛii? Gbɛ̃da gɛ̀ɛn yá? Ke kↄ̀kↄ fítinna? ");
INSERT INTO bqp_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Dikiri ma yã gwa à yã gↄ̃gↄ̃wɛrɛ. À yã nna kpáma à zɛ kũmao à ma bo n ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Kũ Dauda yã dí ò Solunɛ à làka, Solu pì: Ma nɛ́ Dauda, n kòtoon gwe yá? Akũ Solu pũ̀tã kũ wikio ");
INSERT INTO bqp_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","à pì Daudanɛ: N yã nna demala, zaakũ yã vãnin ma kɛ̀nnɛ, akũ n fĩna bòmɛnɛ kũ a manao. ");
INSERT INTO bqp_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","N yã mana kũ n kɛ̀mɛnɛ ò tera. Kũ Dikiri ma nannɛ n ↄĩ, ńdi ma dɛro. ");
INSERT INTO bqp_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Tó gbɛ̃ bò a ibɛrɛɛa, àdi tó à tá aafia yá? Dikiri yã mana kũ n kɛ̀mɛnɛ gbãra fĩna bonnɛ. ");
INSERT INTO bqp_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Má dↄ̃ sà kũ ĩni gↄ̃ kína ũ, ĩnigↄ̃ kí ble Isarailanↄa. ");
INSERT INTO bqp_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Ǹ símɛnɛ kũ Dikiri tↄ́o, kũ ĩni ma buri kakatɛro, ĩni ma tↄ́ dɛ ma de bedenↄ tɛ́ro. ");
INSERT INTO bqp_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Akũ Dauda la dà Solunɛ. Kũ Solu tà bɛ, akũ Dauda kũ a gbɛ̃nↄ ɛ̀ra ò tà sɛ̃̀ntɛpↄrↄtu. ");
INSERT INTO bqp_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Samuɛli gà, akũ Isarailanↄ kàkara ń pínki, òtɛn ↄ́ↄ dↄ a ganaa musu, akũ ò a vĩ̀ a bɛa zaa Rama. Abire gbɛra Dauda gɛ̀ɛ Parani sɛ̃̀ntɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","Maↄni gbɛ̃ke kun, à bↄkↄtɛ vĩ Kamɛli gwe. Aruzɛkɛde zↄ̃kↄ̃ↄmɛ, à sãnↄ vĩ wàa gɛ̃ro kũ blènↄ wàa sↄↄro. Akũ à sù Kamɛli de à a sãnↄ kã zↄ̃zↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","A tↄ́n Nabala, a nanↄ tↄ́n Abigaili. Nↄgbɛ̃ pìi laakari vĩ akũsↄ̃ a kakana mana, ama a gↄ̃ pì gbɛ̃ke wé'i vĩro, a yãkɛnanↄn dↄ̀rↄ vĩro. Kalɛbu burimɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Gↄrↄ kũ Dauda kú sɛ̃̀ntɛ, à mà Nabala sù a sãnↄ kã zↄ̃zↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Akũ à a ìbanↄ zĩ̀ gbɛ̃nↄn kuri, à pìńnɛ: À futɛ à gɛ́ Nabala kĩnaa zaa Kamɛli, à fↄ kpáamɛnɛ ");
INSERT INTO bqp_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","à onɛ à pi: Luda n dↄ̃ kũ aafiaao kũ n ↄnnwo kũ n gbɛ̃nↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Ma mà n su kũ sãkãkɛ̃rɛrinↄ. Kũ n sãdãrinↄn kú kũoo, odi wari daḿmaro, ń kunna Kamɛli gũn, pↄ́ke dí kĩaḿmaro. ");
INSERT INTO bqp_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Ǹ n zĩkɛrii pìnↄ la, oni onnɛ. Ǹ tó ma ìbanↄ n pↄnna e, zaakũ dikpɛ zĩmɛ. N zↄ̀blerii pìnↄ kũ makũ n nɛ́o ǹ ó gba pↄ́ kũ n è. ");
INSERT INTO bqp_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Kũ Dauda ìbaa pìnↄ kà, ò yã pìi bàba Nabalanɛ kũ Dauda tↄ́o, akũ ò zɛ̀i. ");
INSERT INTO bqp_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Akũ Nabala pìńnɛ: Dín Dauda ũu? Dín Yɛsɛ nɛ́ pì ũu? Zↄ̀ kũ ò kɛ̃̀ n dikirinↄa gbãranↄn dasi. ");
INSERT INTO bqp_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Á ye mà a burodi kũ ma ío kũ nↄ̀bↄ kũ ma dɛ̀ ma sãkãkɛ̃rɛrinↄnɛo sɛ́tɛ mà kpá gbɛ̃ kũ má ń boki dↄ̃ronↄan yá? ");
INSERT INTO bqp_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Akũ Dauda gbɛ̃nↄ ɛ̀ra ò dà zɛ́n ò tà. Kũ ò kà, ò yã pìnↄ gbã̀nɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Akũ Dauda pì a gbɛ̃ pìnↄnɛ: Á baadi a fɛ̃nɛda loko. Akũ ń baadi a fɛ̃nɛda lòko kũ Daudao se. Gbɛ̃ kũ ò gɛ̀ɛ kũ Daudaonↄ kà wàa pla taka, akũ gbɛ̃nↄn wàa do gↄ̃̀ kũ asonↄ. ");
INSERT INTO bqp_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","À sù à lè zĩkɛrii pìnↄ doke gɛ̀ɛ à ò Nabala nanↄ Abigailinɛ à pì: Dauda gbɛ̃nↄ zĩ̀ ò bò sɛ̃̀ntɛ, ò sù ò fↄ kpà ó dikiria, akũ à pàtaḿma. ");
INSERT INTO bqp_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Gbɛ̃ pìnↄ sↄ̃ ò yã mana kɛ̀wɛrɛ manamana, odi wari dawáro. Ó kunna kũńwo sɛ̃̀ntɛ, pↄ́ke dì sãtɛwáro. ");
INSERT INTO bqp_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Gↄrↄ kũ ótɛn sã dã ń sarɛ fãnantɛ̃ kũ gwãanio pínki, òdigↄ̃ likawái lán bĩni bà. ");
INSERT INTO bqp_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Ǹ laasun lɛ́ yã kũ ĩni kɛa, zaakũ ò zɛ̀o ò yã vãni kɛ ó dikiriinɛ kũ a ↄndenↄ ń pínki. Àpi manaro, àdi gbɛ̃ lɛ́damma maro. ");
INSERT INTO bqp_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Akũ Abigaili burodii kàkara likalika mɛ̀n wàa do kũ sèwɛ̃o tùru pla kũ sã kũ ò kɛ̀kɛnↄ mɛ̀n sↄↄro kũ pↄ́blewɛ kpatanaao kpɛ̃nɛ sↄↄro kũ geepi kàranↄ mɛ̀n basↄↄro kũ kaka nɛ́ kori kàranↄ mɛ̀n wàa do, ò yĩ̀ zaakinↄnɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Akũ à pì a zĩkɛrinↄnɛ: Àgↄ̃ do arɛ, manigↄ̃ tɛ́ á kpɛ. Adi yãke o a zã Nabalanɛro. ");
INSERT INTO bqp_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Akũ à di a zaakia, àtɛn kipa sĩ̀sĩia. Kũ à bò sĩ̀sĩ kpɛ, ò dàkarɛ kũ Daudao, àtɛn kipa sĩ̀sĩia se kũ a gbɛ̃nↄ, òtɛn su. ");
INSERT INTO bqp_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Dauda tɛn o a gbɛ̃nↄnɛ: Ma gbɛ̃ pì pↄ́nↄ dã̀kpãnɛ sɛ̃̀ntɛ pãmɛ. Ódi a pↄ́ke sɛ́ro, akũ à yã mana kũ ma kɛ̀nɛ fĩna bòmɛnɛ kũ a vãnio. ");
INSERT INTO bqp_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Tó ma a gↄ̃gbɛ̃ ke tò bɛ̃nɛ ari gu gↄ̃ gɛ́ dↄ, Luda yã kɛmɛnɛ pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Kũ Abigaili a è, akũ à kìpa a zaakia likalika, à kùtɛ Daudanɛ à arɛ pɛ̀tɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Akũ à kùtɛ a gbá sarɛ à pì: Baa, taari pìi gↄ̃̀ ma mɛ̀n do musu. Ǹ makũ n zↄ̀bleri gba zɛ́ mà yã onnɛ. Ǹ sã dↄ makũ n zↄ̀bleri yãi. ");
INSERT INTO bqp_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Baa, Nabala manaro. Ǹsun a yã daro. À de lán a tↄ́ bàmɛ. A tↄ́n Yↄ̃nkↄ, akũsↄ̃ yↄ̃nkↄyãn àdigↄ̃ kɛ. Makũ n zↄ̀bleri sↄ̃, mádi gbɛ̃ kũ n ń zĩnↄ ero. ");
INSERT INTO bqp_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Baa, lákũ Dikiri kun akũsↄ̃ ń kun nà, Dikiri gìnnɛ ǹ gbɛ̃ dɛ ǹ mↄra káḿma n zĩda. Dikiri tó n ibɛrɛnↄ kũ gbɛ̃ kũ òtɛni n kpákpa kũ a vãnionↄ gↄ̃ lán Nabala bà. ");
INSERT INTO bqp_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Tera sà Baa, ǹ gba kũ makũ n zↄ̀bleri ma suonnɛ dí sí ǹ kpá n ìbanↄa. ");
INSERT INTO bqp_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Ǹ sùru kɛ kũ makũ n zↄ̀bleriio kũ ma taario dↄ. Dikiri ni tó n burinↄ gↄ̃ kí ble gↄrↄ sĩnda pínki, zaakũ ndì zĩ̀ ká Dikirinɛmɛ, oni a vãni ke emma zikiro. ");
INSERT INTO bqp_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Bee tó gbɛ̃ke fùtɛ àtɛn pɛ́tɛnyĩ à n dɛ, Dikiri n Luda ni n wɛ̃̀ndiba dↄ kũ mↄ̀kakↄ̃anaamɛ, ani n ibɛrɛnↄ wɛ̃̀ndi da gbɛ̀mban à zu. ");
INSERT INTO bqp_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Baa, tó Dikiri yã mana kɛ̀nnɛ lákũ à lɛ́ sɛ̀nnɛ nà pínki, tó à n ditɛ Isarailanↄ gbɛ̃ zↄ̃kↄ̃ ũ, ");
INSERT INTO bqp_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","n laasun sún wari dↄmma à n da yãn gbɛ̃dɛna pã ke fĩnabona n zĩdanɛ yã musuro. Baa, tó Dikiri yã mana kɛ̀nnɛ, ǹ tó makũ n zↄ̀bleri ma yã gↄ̃ dↄngu. ");
INSERT INTO bqp_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Akũ Dauda pì Abigailinɛ: Ò Dikiri Isarailanↄ Luda sáabu kpá, zaakũ à n zĩ ǹ damalɛ gbãra. ");
INSERT INTO bqp_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Ma n sáabu kpà se kũ lɛ́damma kũ n ma gbao, zaakũ mↄkↄ̃mmɛ n kpamɛnɛ gbãra, akũ mádi gbɛ̃ dɛ ma mↄra káḿma ma zĩdanɛro. ");
INSERT INTO bqp_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Tó abirekũnlo, kũ Dikiri Isarailanↄ Luda kũ à gìmɛnɛ mà yã vãni kɛnnɛo, tó ńdi wã n su n damalɛ yãro, de gu ni dↄ Nabala nɛ́gↄ̃gbɛ̃ kearo. ");
INSERT INTO bqp_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Akũ Dauda pↄ́ kũ Abigaili sùoarɛ sì à pì: Ǹ ká bɛ aafia. Ma n yã mà, ma yodaado kɛ̀nnɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Kũ Abigaili kà Nabala kĩnaa, à è àtɛn pↄ́ ble lán kína bà. A pↄ kɛ̀ nna, à wɛ̃ gbɛ̃̀ à kã̀. Akũ a nanↄ pì dí lɛ́ bo à yãke ònɛ, bee fítiro, ari gu gɛ̀ɛ à dↄ̀o. ");
INSERT INTO bqp_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Kũ gu dↄ̀, wɛ̃ wère Nabalaa, akũ a nanↄ yã kũ à kɛ̀ɛ pìi ònɛ. Akũ swɛ̃̀ɛ kɛ̃̀agu, à gↄ̃̀ lán gbɛ̀ɛ bà. ");
INSERT INTO bqp_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Kũ à kɛ̀ lán gↄrↄ kuri taka bà, akũ Dikiri gòo tↄ̃̀a, à gà. ");
INSERT INTO bqp_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Kũ Dauda Nabala gana baaruu mà, à pì: Ò Dikiri kũ à zɛ̀ kũmao sáabu kpá, à wé'i kũ Nabala dàma bòmɛnɛ. À gìmɛnɛ mà yã vãni kɛ, akũ à tò Nabala vãnikɛnaa wì a zĩda musu. Abire gbɛra Dauda gbɛ̃nↄ zĩ̀ Abigailia ò onɛ á ye à a sɛ́ nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Kũ Dauda ìbaa pìnↄ kà Abigaili kĩnaa Kamɛli, ò pìnɛ: Dauda mɛ́ à ó zĩmma, à ye à n sɛ́ nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Akũ à fùtɛ à kùtɛ à a mìi pɛ̀tɛ à pì: A zↄ̀bleriin ma ũ, ma soru kɛ̀ mà a dikiri ìbanↄ gbá pípińnɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Akũ à fùtɛ à dì zaakia gↄ̃̀nↄ. A nↄgbɛ̃ zĩkɛrinↄ gɛ̀ɛ kãao gbɛ̃nↄn sↄↄro. Ò dà zɛ́n kũ Dauda zĩ̀rinↄ, akũ à gↄ̃̀ a nↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Dauda Yɛzɛrili gbɛ̃ Ainↄama kũna nↄ ũ dↄ. Ń pla ń pínki a nↄnↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Solu a nɛ́ Mikala kũ à de Dauda nↄ ũ yã kpà Laisi nɛ́ Palatiɛli, Galimu gbɛ̃a. ");
INSERT INTO bqp_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Zifidenↄ gɛ̀ɛ ò Solu lè Gibɛa ò pìnɛ: Dauda utɛna Akila sĩ̀sĩgɛrɛɛi kũ arɛdↄna Yɛsimↄa. ");
INSERT INTO bqp_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Akũ Solu gɛ̀ɛ Zifi sɛ̃̀ntɛ kũ Isaraila zĩ̀karinↄ gbɛ̃nↄn wàa gɛ̃ro, òtɛn Dauda wɛtɛ ò a dɛ sɛ̃̀ɛ pìn. ");
INSERT INTO bqp_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Solu bùraa kàtɛ zɛ́ sarɛ Akila sĩ̀sĩgɛrɛ kũ à arɛdↄna Yɛsimↄa, akũ Dauda kú sɛ̃̀n. Kũ à mà Solu tɛn pɛ́tɛai, ");
INSERT INTO bqp_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","akũ à gu'asirigwarinↄ zĩ̀, akũ à dↄ̃̀ sà kũ Solu kà. ");
INSERT INTO bqp_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Akũ Dauda fùtɛ à gɛ̀ɛ gu kũ Solu bùraa kàtɛn. À Solu kũ a zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Nɛrɛ nɛ́ Abanao wutɛki è. Solu wutɛna bùraan, a gbɛ̃nↄ kàtɛ ò likai. ");
INSERT INTO bqp_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Akũ Dauda Iti buri Aimɛlɛki kũ Zeruya nɛ́ Abisaio là à pì: Dí mɛ́ ani gɛ́ kũmao bùraa pìn Solu kĩnaa? Akũ Abisai pìnɛ: Makũ mɛ́ mani gɛ́ kũnwo. ");
INSERT INTO bqp_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Kũ Dauda kũ Abisaio lↄↄtɛ̀ gbɛ̃ pìnↄi gwãani, akũ ò Solu è wutɛna, àtɛn i o bùran, a sári pɛtɛna a mìii. Abana kũ a gbɛ̃nↄn wutɛna ò likai ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Akũ Abisai pì Daudanɛ: Luda n ibɛrɛ nànnɛ n ↄĩ gbãra. Ǹ tó mà a zↄ̃ kũ sário mà a nakↄ̃a kũ zĩtɛo. Mani a zↄ̃ gɛ̃̀n domɛ, adi kɛ gɛ̃̀n planlo. ");
INSERT INTO bqp_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Akũ Dauda pìnɛ: Ǹsun a dɛro. Dí mɛ́ ani fↄ̃ à ↄ na kína kũ Dikiri kàa à bo pãa? ");
INSERT INTO bqp_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Akũ Dauda ɛ̀ra à pì: Dikiri kun! Dikiri mɛ́ ani gò tↄ̃a à ga, tó a gↄrↄ pàpa kesↄ̃ à gà zĩ̀lan. ");
INSERT INTO bqp_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Kai! Dikiri sún tó mà ↄ na kína kũ à kàaro. Ò gɛ́ ò sári kũ à kú a mìii sɛ́ kũ a í loo ò táo. ");
INSERT INTO bqp_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Dauda sári kũ í lo kũ à kú Solu mìiioo sɛ̀, akũ ò tào. Ń gbɛ̃ke dí ń ero, ò ń yã dↄ̃ro, òtɛn i o ń pínki. Ń gbɛ̃ke dí vuro, zaakũ Dikiri mɛ́ à tò i zↄ̃kↄ̃ↄ dàńla. ");
INSERT INTO bqp_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Kũ Dauda bikũ̀ guvutɛ bara dire kpa, akũ à zɛ̀ sĩ̀sĩi musu zã̀zã, gu yàasa dana ń dagura. ");
INSERT INTO bqp_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Akũ à lɛ́ zù Abanai kũ a gbɛ̃nↄ à pì: Abana yooo! Ń yĩtɛnan yá? Abana wèa à pì: Dí mɛ́ àtɛn lɛ́ zu kínaii? ");
INSERT INTO bqp_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Dauda pìnɛ: Gↄ̃sa gbãnamɛ n ũroo? Gbɛ̃ke kà lán n bà Isarailanↄ bùsunn yá? Gbɛ̃ke sù n dikiri kína dɛ. Bↄ́ yã mɛ́ à tò ńdi a dãkpãroo? ");
INSERT INTO bqp_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Ńdi yã kɛ a zɛ́aro. Ma sì kũ Dikirio a ka ganamɛ, zaakũ ádi á dikiri kína kũ Dikiri kà dãkpãro. Ǹ gwa! Kína sári kũ a í lo kũ à kú a mìiio kú mámɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Solu Dauda kòtoo dↄ̃̀, akũ à pì: Dauda ma nɛ́, n kòtoon gwe yá? À wèa à pì: Ma dikiri kína, ma kòtoomɛ. ");
INSERT INTO bqp_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Dauda ɛ̀ra à pì: Bↄ́ yã mɛ́ à tò ma dikiri tɛn pɛ́tɛ makũ a zↄ̀bleriiii? Bↄ́n ma kɛ̀ɛ? Bↄ́ taarin ma kɛ̀ɛ? ");
INSERT INTO bqp_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Ma dikiri kína, ǹ sã kpá makũ n zↄ̀bleri yãi sà. Tó Dikiri mɛ́ à n suu kɛ̀ma, à ma sa'ona gbĩ ma. Tó bisãsirinↄmɛ sↄ̃, Dikiri láari kɛḿma, zaakũ ò pɛ̀ma ò ma bo Dikiri gbɛ̃nↄ tɛ́, ò pì mà gɛ́ do tãnanↄimɛ. ");
INSERT INTO bqp_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Ǹsun tó ò ma dɛ zã̀ kũ Dikirioro. Isarailanↄ kína bò, àtɛn kↄ̀kↄ fítinna wɛtɛ à dɛ, lákũ òdigↄ̃ pɛ́ dↄ̃a sĩ̀sĩnↄ musu nà. ");
INSERT INTO bqp_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Akũ Solu pì: Ma durunna kɛ̀. Ma nɛ́ Dauda, ǹ ɛra ǹ su. Mani wari dↄmma doro, zaakũ n ma wɛ̃̀ndii bɛ̀ɛrɛ dↄ̃ gbãra. Yãpuramɛ, ma yↄ̃nkↄyã kɛ̀, ma zã yãa manamana. ");
INSERT INTO bqp_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Akũ Dauda pìnɛ: N sárin dí. Ǹ tó n ìbanↄ doke bikũ à mↄ́ à sí. ");
INSERT INTO bqp_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Dikiri dì fĩna bo baadinɛ a manakɛna kũ a náanio musu. Dikiri n namɛnɛ ma ↄĩ gbãra, ama mádi we mà ↄ nàmmaro kũ Dikiri mɛ́ à n ka kín yãi. ");
INSERT INTO bqp_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Lákũ ma n wɛ̃̀ndii bɛ̀ɛrɛɛ dↄ̃̀ gbãra nà, Dikiri ma wɛ̃̀ndii bɛ̀ɛrɛ dↄ̃ lɛ, à ma sí yã vãni sĩnda pínkia. ");
INSERT INTO bqp_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Akũ Solu pìnɛ: Luda arubarika dangu ma nɛ́ Dauda. Ĩni yã zↄ̃kↄ̃ kɛ, n mì nigↄ̃ dana íla. Kũ Dauda tà, akũ Solu tà bɛ. ");
INSERT INTO bqp_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Dauda laasun lɛ̀ à pì: Solu ni ma dɛ zĩkea. Tó mádi bàa lɛ́ ma ta Filisitininↄ bùsunlo, ani bo kũmao nnaro. Tó ma bàa lɛ̀, Solu ni ma wɛtɛna tó, mani bo a ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Akũ Dauda fùtɛ à gɛ̀ɛ Gata kína Akisi, Maↄku nɛ́ kĩnaa. Gbɛ̃nↄn wàa aakↄ̃nↄ gɛ̀ɛ kãao. ");
INSERT INTO bqp_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","Akũ Dauda kũ a gbɛ̃nↄ vùtɛ Gata kũ Akisio, baadi kũ a bedenↄ. Dauda kú gwe kũ a nↄnↄ gbɛ̃nↄn pla, Yɛzɛrili gbɛ̃ Ainↄama kũ Kamɛli gbɛ̃ Abigaili kũ à de Nabala nↄ ũ yão. ");
INSERT INTO bqp_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Kũ ò ò Solunɛ Dauda bàa lɛ̀ à tà Gata, adi pɛ́tɛi doro. ");
INSERT INTO bqp_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Dauda pì Akisinɛ: Tó ma n pↄnna è, ǹ ma gba zɛ́ mà vutɛ gukea n lakutunↄ doke gũn. Makũ n zↄ̀bleri má ye màgↄ̃ kú kũnwo n wɛ́ranlo. ");
INSERT INTO bqp_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Zĩ birean Akisi Zikilaga kpàa, akũ à gↄ̃̀ Yudanↄ kínanↄ pↄ́ ũ ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Dauda kunna Filisitininↄ bùsun kà wɛ̃̀ do kũ mↄ siikↄ̃o. ");
INSERT INTO bqp_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Akũ Dauda kũ a gbɛ̃nↄ gɛ̀ɛ ò lɛ̀tɛ Gesurunↄa kũ Gizinↄ kũ Amalɛkinↄ. Gbɛ̃ pìnↄn kú bùsuu pìn zaa zĩmɛ bona zaa Suru ari à gɛ̀ɛ pɛ́ Misilaa. ");
INSERT INTO bqp_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Tó Dauda zĩ̀i blè bùsuu pì lakutunↄa, àdi gↄ̃gbɛ̃ ke nↄgbɛ̃ ke tó bɛ̃nɛro, sãnↄ kũ zùnↄ kũ zaakinↄ kũ lakuminↄ kũ pↄ́kasanↄ àdi nakↄ̃a. Tó à tà, àdi gɛ́ Akisi kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Tó Akisi a là gu kũ à lɛ̀tɛn gbɛ̃nↄa gbãra, Dauda dì pinɛ a gɛ Nɛgɛvi bùsun, Yudanↄ ke Yeramɛɛli burinↄ ke Keninↄ kĩnaamɛ. ");
INSERT INTO bqp_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Dauda dì gↄ̃gbɛ̃ ke nↄgbɛ̃ ke tó bɛ̃nɛ ò su kãao Gataro, zaakũ àtɛn pi: Gbɛ̃ke ni ó kↄrↄmↄtↄↄ kɛ à pi dera ma kɛ̀ nàn dí. Lɛn àdigↄ̃ kɛ lɛ gↄrↄ kũ à kú Filisitininↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Akisi Dauda náani kɛ̀ à pì a zĩdanɛ: Isarailanↄn ye a kãiro. Anigↄ̃ de ma zↄ̀bleri ũmɛ gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Gↄrↄ birenↄa Filisitininↄ ń zĩ̀karinↄ kàkara, ò ye ò gɛ́ ò zĩ̀ ká kũ Isarailanↄ. Akũ Akisi pì Daudanɛ: Asa ń dↄ̃ kũ mↄkↄ̃n kũ n gbɛ̃nↄ áni gɛ́ kũmao zĩ̀ ká kó? ");
INSERT INTO bqp_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Akũ Dauda pìnɛ: Tↄ̀, ĩni e sà lákũ makũ n zↄ̀bleri mani kɛ nà. Akũ Akisi pìnɛ: Tó lɛmɛ, mani n kɛ ma dãkpãri ũ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","À sù à lè Samuɛli gà, Isarailanↄ kàkara ń pínki, ò ↄ́ↄ dↄ̀ a ga yã musu, akũ ò a vĩ̀ a bɛ wɛ̃tɛn Rama. Solu pɛ̀ wedekũnnadenↄa kũ gɛ̀sisirinↄ Isarailanↄ bùsun. ");
INSERT INTO bqp_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Kũ Filisitininↄ kↄ̃ kàkara, ò sù ò bùraa kàtɛ Sunɛmu. Akũ Solu Isarailanↄ kàkara ń pínki, ò bùraa kàtɛ Giliboa. ");
INSERT INTO bqp_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Kũ Solu Filisitini zĩ̀karinↄ è, vĩna a kũ̀, swɛ̃̀ɛ kɛ̃̀agu manamana. ");
INSERT INTO bqp_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","À gbɛ̀ka Dikiria, akũ Dikiri dí wea nana gũn ke kũ Urimuo ke annabinↄ gãiro. ");
INSERT INTO bqp_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Akũ Solu pì a ìbanↄnɛ: À nↄgbɛ̃ wedekũnnade gɛ̀sisiri ke wɛtɛmɛnɛ, de mà gɛ́ mà yã gbɛkaa. Akũ ò pìnɛ: Nↄgbɛ̃ wedekũnnade gɛ̀sisiri ke kú Ɛndↄ. ");
INSERT INTO bqp_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Akũ Solu a zĩda lìtɛ à pↄ́kasa pãndenↄ dà, akũ à gɛ̀ɛ à nↄgbɛ̃ pìi lè gwãani, a gbɛ̃nↄn planↄ tɛ̀i. À pìnɛ: Ǹ tó n tãna su ǹ gɛ̀ kũ mani a tↄ́ onnɛ sísimɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Akũ nↄgbɛ̃ pìi pìnɛ: Ń dↄ̃ sãnsãn yã kũ Solu kɛ̀. À a bùsu zɛ́ zↄ̃̀ wedekũnnadenↄnɛ kũ gɛ̀sisirinↄo. Bↄ́ yã mɛ́ à tò ntɛn tankutɛ kpákpamɛnɛ de ò ma dɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Akũ Solu la dànɛ kũ Dikirio à pì: Ma sì kũ Dikirio oni wari dↄmma yã dí musuro. ");
INSERT INTO bqp_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Akũ nↄgbɛ̃ pìi pì: Gɛ̀ kpaten mà sísinnɛɛ? À pì: Samuɛli gɛ̀ɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Kũ nↄgbɛ̃ pì Samuɛli è, à wiki pũ̀tã à pì Solunɛ: Mↄkↄ̃mmɛ Solu ũu? Bↄ́yãin n ↄ̃ndↄ̃ kɛ̀mɛnɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Akũ kína pìnɛ: Ǹsun tó vĩna n kũro. Bↄ́n n èe? À pìnɛ: Gyãwãnden ma è, àtɛn bo zĩtɛn. ");
INSERT INTO bqp_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Solu a là à pì: À kɛ̀ deramɛɛ? À pìnɛ: Mare zĩ ke mɛ́ àtɛn su, à arukĩmba dana. Akũ Solu dↄ̃̀ kũ Samuɛlimɛ, akũ à kùtɛ à wùtɛ a gbɛrɛa. ");
INSERT INTO bqp_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Akũ Samuɛli a là à pì: Bↄ́yãin n wari dↄ̀ma, kũ n ma sisii? À wèa à pì: Ma warikɛna zↄ̃kↄ̃ↄ èmɛ. Filisitininↄ mɛ́ ò sù zĩ̀ ká kũmao, akũ Luda kpɛ lìmɛnɛ. Àdi wema annabi gãi ke nana gũn doro. Abire yãin ma n sisi. Ǹ omɛnɛ lákũ mani kɛ nà. ");
INSERT INTO bqp_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuɛli pìnɛ: Dikiri kpɛ lìnnɛ à gↄ̃̀ n ibɛrɛ ũ, akũ n su ntɛn yã gbɛkama sↄ̃ bi? ");
INSERT INTO bqp_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Dikiri kɛ̀nnɛ lákũ à dàmɛnɛ ma ònnɛ nà. À n bo kpatan à n gbɛ̃dake Dauda kàn. ");
INSERT INTO bqp_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Dikiri abirekũ kɛ̀nnɛ gbãra, kũ ńdi a yã maro yãimɛ. Ńdi pↄfɛ̃ pãsĩ kipanɛ Amalɛkinↄaro. ");
INSERT INTO bqp_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Dikiri ni Isarailanↄ kũ mↄkↄ̃nwo kpá Filisitininↄamɛ. Mↄkↄ̃n kũ n nɛ́gↄ̃gbɛ̃nↄ nigↄ̃ kú kũmao la zia. Dikiri ni Isaraila zĩ̀karinↄ kpá Filisitininↄa. ");
INSERT INTO bqp_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Samuɛli yã pìi tò vĩna Solu kũ̀ manamana, akũ à lɛ̀tɛ a gbɛrɛa sↄ̀rↄrↄ gↄ̃̀nↄ. A gbãna làka, zaakũ adi pↄ́ke ble gↄrↄ birea ke gwãani kũ̀aro. ");
INSERT INTO bqp_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Kũ nↄgbɛ̃ pìi sù Solu kĩnaa, à è swɛ̃̀ɛ kɛ̃̀agu manamana, akũ à pìnɛ: Makũ n zↄ̀bleri ma n yã mà, ma a zĩda kari kɛ̀, ma yã kũ n òmɛnɛ kɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Ǹ n zↄ̀bleri yã ma sà. Ǹ tó mà pↄ́ble ditɛnnɛ ǹ ble, de ǹ gbãna kũ ǹ da zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Akũ Solu gì à pì: Mani pↄ́ blero. Kũ a ìbanↄ nàkaraa lɛɛlɛ kũ nↄgbɛ̃ pìio, akũ à ń yã mà. Akũ à fùtɛ zĩtɛ à vùtɛ gádoa. ");
INSERT INTO bqp_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Nↄgbɛ̃ pìi zù bↄ̀rↄ mɛ̀kpana vĩ bàdↄna a bɛa. À gɛ̀ɛ à dɛ̀ gↄ̃̀nↄ, akũ à flawa sɛ̀ à dɛ̀, à burodi futɛnasari kɛ̀o. ");
INSERT INTO bqp_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","À dìtɛ Solunɛ kũ a ìbanↄ. Ò blè, akũ ò fùtɛ ò tà gwãani birea gↄ̃̀nↄ. ");
INSERT INTO bqp_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Filisitininↄ ń zĩ̀karinↄ kàkara Afɛki, akũsↄ̃ Isarailanↄ bùra kú Yɛzɛrili ísɛ̃bokia. ");
INSERT INTO bqp_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Filisitini kínanↄ tɛn gɛ̃tɛ kũ ń zĩ̀kari gã̀nↄ, ń kenↄ gbɛ̃nↄn basↄsↄↄro, ń gã̀ kenↄ wàa sↄsↄↄro. Dauda kũ a gbɛ̃nↄ tɛ́ ń kpɛ kũ Akisio. ");
INSERT INTO bqp_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Akũ Filisitini kína pìnↄ Akisi là ò pì: Eberu dínↄ sↄ̃ bi? À wèḿma à pì: Daudan dí. Isarailanↄ kína Solu ìba kemɛ yã. À gↄrↄ pla kɛ̀ kũmao. À kú kũmao de wɛ̃̀ dola. Naana zaa gↄrↄ kũ à sù ma kĩnaa ari gbãra, mádi yãke earo. ");
INSERT INTO bqp_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Akũ kína pìnↄ pↄ fɛ̃̀ kãao ò pì: Ǹ gↄ̃gbɛ̃ pì gbarɛ à tá gu kũ n kpàawan. Ani le à gɛ́ kũoo zĩ̀lanlo, de àsun bo ó kpɛ gwero yãi. Deran ani le à kɛ nna kũ a dikiriio nà, tó adi kɛ à tà kũ ó gbɛ̃kenↄ mìio baasiroo? ");
INSERT INTO bqp_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Dauda kũ ò lɛ̀ɛ sì ò ũ wã̀ a yã musun gweroo? Kũ ò pì: Solu gbɛ̃nↄ dɛ̀dɛ wàa sↄsↄↄro, Dauda sↄ̃ mɛ̀n dúbu lɛu ũgbangba. ");
INSERT INTO bqp_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Akũ Akisi Dauda sìsi à pìnɛ: Ma sì kũ Dikirio n kɛmɛnɛ gbɛ̃ mana ũmɛ, n gɛna kũmao zĩ̀lan kɛ̀mɛnɛ nna, zaakũ naana zaa gↄrↄ kũ n su ma kĩnaa ari gbãra, mádi yãke emmaro. Ama ń yã dí kɛ ó kínanↄnɛro. ");
INSERT INTO bqp_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Ǹ ɛra ǹ tá kũ aafiaao de ǹsun yãke kɛ à kɛńnɛ ĩniro. ");
INSERT INTO bqp_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Akũ Dauda Akisi là à pì: Bↄ́n ma kɛ̀ɛ? Naana zaa gↄrↄ kũ ma su n kĩnaa ari gbãra, bↄ́n n èmaa? Bↄ́yãin mani gí gɛ́ mà zĩ̀ ká kũ ma dikiri kína ibɛrɛnↄoroo? ");
INSERT INTO bqp_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Akũ Akisi pìnɛ: Má dↄ̃ kũ ń manamɛnɛ lán Luda malaika bà, ama ó kínanↄ pì ǹsun gɛ́ kũoo zĩ̀lanlo. ");
INSERT INTO bqp_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Tó gu dↄ̀, ǹ futɛ kↄnkↄkↄnkↄ kũ n dikiri Solu zↄ̀bleri kũ ò sù kũnwonↄ, à tá. ");
INSERT INTO bqp_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Akũ Dauda fùtɛ kↄnkↄkↄnkↄ kũ a gbɛ̃nↄ, òtɛn tá Filisitininↄ bùsun. Filisitininↄ sↄ̃ ò gɛ̀ɛ Yɛzɛrili. ");
INSERT INTO bqp_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Dauda kũ a gbɛ̃nↄ kà Zikilaga a gↄrↄ aakↄ̃de zĩ. À sù à lè Amalɛkinↄ sù ò lɛ̀tɛ Nɛgɛvi bùsuua kũ Zikilagao ń kpɛ. Ò lɛ̀tɛ Zikilagaa ò tɛ́ sↄ̃̀a. ");
INSERT INTO bqp_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","Ò nↄgbɛ̃ kũ ò kú gwenↄ kũ̀kũ, nɛ́nↄgbɛ̃nↄ kũ nↄgbɛ̃ zↄ̃kↄ̃nↄ ń pínki. Odi ń gbɛ̃ke dɛro, ò ń sɛ́tɛ ò tà kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Kũ Dauda kũ a gbɛ̃nↄ kà ń bɛ wɛ̃tɛn, ò è ò tɛ́ sↄ̃̀a ò ń nↄgbɛ̃nↄ kũ ń nɛ́gↄ̃gbɛ̃nↄ kũ ń nɛ́nↄgbɛ̃nↄ kũ̀kũ ò tà kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Akũ Dauda kũ gbɛ̃ kũ ò kú kãaonↄ wiki lɛ̀ ò ↄ́ↄ dↄ̀ ari ń gbãna làka, ari odi fↄ̃ ò ↄ́ↄ dↄ̀ doro. ");
INSERT INTO bqp_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Ò Dauda nↄnↄ kũ̀kũ ò tà kũńwo ń pla Ainↄama kũ Abigailio. ");
INSERT INTO bqp_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Dauda wɛ́tãmma è manamana, zaakũ òtɛn pi ò a pápa kũ gbɛ̀ɛo ò dɛ. Ń gbɛ̃ sĩnda pínki nɛ̀sɛɛ yàka ń nɛ́gↄ̃gbɛ̃nↄ kũ ń nɛ́nↄgbɛ̃nↄ yã musu. Ama Dauda gbãna è Dikiri a Ludaa, ");
INSERT INTO bqp_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","akũ à pì sa'ori Abiatanɛ: Ǹ mↄ́ kũ n uta lokommao. Kũ à gɛ̀ɛonɛ, ");
INSERT INTO bqp_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","akũ Dauda yã gbɛ̀kao Dikiria, à a là à pì: Mà pɛ́tɛ gbãnamↄnnɛrii pìnↄi mani ń le yá? À pìnɛ: Ǹ pɛ́tɛńyĩ, ĩni ń le ǹ n gbɛ̃nↄ mì sí. ");
INSERT INTO bqp_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Akũ Dauda dà zɛ́n kũ gbɛ̃nↄn wàa aakↄ̃nↄ. Kũ ò kà Beso swai, gbɛ̃kenↄ gↄ̃̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Gbɛ̃nↄn wàa donↄ gbãna làka, odi fↄ̃ ò bikũ̀ swa pìiaro, akũ Dauda bikũ̀, à tɛ́ ń gbɛ̀ɛi kũ gbɛ̃nↄn wàa planↄ. ");
INSERT INTO bqp_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Ò Misila gbɛ̃ke è sɛ̃̀ntɛ, akũ ò gɛ̀ɛ kãao Dauda kĩnaa. Ò pↄ́ble kpàa à blè, ò í kpàa à mì. ");
INSERT INTO bqp_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","Akũ ò kaka nɛ́ kori kpàa kũ geepi kàraao mɛ̀n pla à sò. Akũ a mɛ̀ɛ sù, zaakũ à kɛ̀ fãnantɛ̃ aakↄ̃ gwãani aakↄ̃ pↄ́blesari ímisari. ");
INSERT INTO bqp_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Akũ Dauda a là à pì: Dí gbɛ̃mɛ n ũu? N bo mámɛɛ? Akũ Misila gbɛ̃ pìi pì: Amalɛki zↄ̀ↄn ma ũ. A gↄrↄ aakↄ̃den dí, ma dikiri pã kpàmai kũ matɛn gyã kɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","O lɛtɛ Nɛgɛvi bùsuuamɛ, gu kũ Kɛrɛtinↄn kun kũ Yudanↄ kũ Kalɛbu burinↄ, akũ ò tɛ́ sↄ̃̀ Zikilagaa. ");
INSERT INTO bqp_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Akũ Dauda a là à pì: Ĩni fↄ̃ ǹ gɛ́ kũmao gbɛ̃ pìnↄ kĩnaa yá? À wèa à pì: Tó n sìmɛnɛ kũ Ludao kũ ĩni ma dɛro, tó ĩni ma kpá ma dikiriiaro, mani gɛ́ kũnwo ń kĩnaa. ");
INSERT INTO bqp_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Akũ à gɛ̀ɛ kãao. Kũ ò kà, ò ń lé, ò fãkↄ̃ana gu sĩnda pínkia, òtɛn pↄ́ ble òtɛn í mi, òtɛn pↄnna kɛ pↄ́ zↄ̃kↄ̃ kũ ò sɛ̀tɛ Filisitini bùsunnↄ kũ Yudanↄ bùsuuo yãi. ");
INSERT INTO bqp_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Akũ Dauda sì ń tɛ́ à ń dɛdɛ naana zaa ↄkↄsi ari gu gɛ̀ɛ à dↄ̀o ↄkↄsi. Ń gbɛ̃ke dí boki lero, séde kɛfɛnna gbɛ̃nↄn wàa pla kũ ò dì lakumia ò bàa lɛ̀nↄ baasiro. ");
INSERT INTO bqp_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Dauda gbɛ̃ kũ Amalɛkinↄ ń kũkũnↄ mìi sì ń pínki kũ a nↄnↄ ń pla. ");
INSERT INTO bqp_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Ń gbɛ̃ke dí sãsãro, nɛ́ fíti gbɛ̃ zↄ̃kↄ̃, nɛ́gↄ̃gbɛ̃nↄ kũ nɛ́nↄgbɛ̃nↄ ń pínki. Bee pↄ́ kũ ò sɛ̀tɛnↄ, Dauda ɛ̀ra à pↄ́ pìnↄ sì pínki. ");
INSERT INTO bqp_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","À sãnↄ kũ zùnↄ nàkↄ̃a, akũ a gbɛ̃nↄ pↄ́kãde pìnↄ kpán'arɛ kɛ̀ ò pì: Dauda pↄ́nↄn dí. ");
INSERT INTO bqp_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Akũ Dauda kà gbɛ̃nↄn wàa do kũ ń gbãna làka odi fↄ̃ ò gɛ̀ɛ kãaoro ò gↄ̃̀ Beso swainↄ kĩnaa. Ò bↄ̀tɛ ò dàalɛ kũ gbɛ̃ kũ ò kú kãaonↄ. Kũ Dauda nàńyĩ, à fↄ kpàḿma, ");
INSERT INTO bqp_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","akũ gbɛ̃ pãsĩ gaavude kũ ò tɛ́ Daudainↄ pì: Lákũ odi gɛ́ kũooro nà, óni pↄ́ kũ o sìnↄ ke kpáḿmaro, tó adi kɛ ń baadi nanↄ kũ a nɛ́nↄ baasiro. Ò ń sɛ́ ò tá kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Akũ Dauda pì: Oi! Ma gbɛ̃nↄ, àsun kɛ lɛ kũ pↄ́ kũ Dikiri kpàwánↄro, zaakũ à ó dãkpã à gbãnamↄnnɛri kũ ò lɛ̀tɛwánↄ nàwɛrɛ ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Gbɛ̃ke ni yã kũ a ò díkĩna síro fá. Gbɛ̃ kũ ò gↄ̃̀ òtɛn pↄ́nↄ dãkpãnↄ baka nigↄ̃ dokↄ̃nↄ kũ gbɛ̃ kũ ò gɛ̀ɛ zĩ̀lannↄmɛ. Óni kpaatɛtɛkↄ̃nɛ lɛɛlɛlɛɛlɛ. ");
INSERT INTO bqp_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Kũ Dauda yã pìi dìtɛ, akũ à gↄ̃̀ doka ũ Isarailanↄnɛ zaa zĩ birea ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Kũ Dauda kà Zikilaga, à pↄ́ kũ à sì kenↄ kpã̀zã Yudanↄ bùsu gbɛ̃ zↄ̃kↄ̃ kũ ò de a gbɛ̃nna ũnↄnɛ à pì: Gba kũ a è pↄ́ kũ o sì Dikiri ibɛrɛnↄaa gũnnↄn gwe. ");
INSERT INTO bqp_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","À kpã̀zãńnɛ Bɛtɛli kũ Ramↄ Nɛgɛvio kũ Yatio ");
INSERT INTO bqp_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","kũ Aroao kũ Sifimↄo kũ Ɛsɛtɛmↄao ");
INSERT INTO bqp_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","kũ Rakalao kũ Yeramɛɛli buri wɛ̃tɛnↄ kũ Keni wɛ̃tɛnↄ ");
INSERT INTO bqp_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","kũ Ɔↄmao kũ Borasão kũ Atakao ");
INSERT INTO bqp_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","kũ Ɛblↄnuo kũ gu kũ Dauda kurèn kũ a gbɛ̃nↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Filisitininↄ zĩ̀i kà kũ Isarailanↄ, akũ Isarailanↄ bàa lɛ̀ńnɛ ari ń daside gàga Giliboa sĩ̀sĩgɛrɛɛi. ");
INSERT INTO bqp_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Filisitininↄ pɛ̀tɛ Solu kũ a nɛ́gↄ̃gbɛ̃nↄi, akũ ò a nɛ́ pìnↄ Yonatã kũ Abinadabuo kũ Malakisuaoo dɛ̀dɛ. ");
INSERT INTO bqp_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Zĩ̀ kũ òtɛn ká Solu sarɛ pãsĩ kũ̀, akũ kàzurinↄ a pà, à kĩ̀nna manamana. ");
INSERT INTO bqp_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Akũ à pì a zĩ̀kapↄnↄsɛriinɛ: Ǹ n fɛ̃nɛda woto ǹ ma zↄ̃ ǹ ma dɛo. Tó lɛnlo, gyↄfↄrↄde dínↄ ni ma zↄ̃ ò fàai bo kũmao. Akũ vĩna a zĩ̀kapↄnↄsɛrii kũ̀, adi weiro, akũ Solu a fɛ̃nɛda sɛ̀, à a zĩda ò'oala. ");
INSERT INTO bqp_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Kũ a zĩ̀kapↄnↄsɛrii è à gà, akũ à a zĩda ò'o a fɛ̃nɛdaa se à gà. ");
INSERT INTO bqp_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Lɛn Solu kũ a nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn aakↄ̃ kũ a zĩ̀kapↄnↄsɛriio kũ a gbɛ̃nↄ gàga lɛɛlɛ lɛ zĩ dokↄ̃nↄ pìa ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Kũ Isaraila kũ ò kú guvutɛn gwenↄ kũ ń gbɛ̃ kũ ò kú Yoda bara direnↄ è ń zĩ̀karinↄ bàa lɛ̀, akũsↄ̃ Solu kũ a nɛ́nↄ gàga, ò bàa lɛ̀ ò ń wɛ̃tɛnↄ tò gwe, akũ Filisitininↄ sù ò vùtɛn. ");
INSERT INTO bqp_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Kũ gu dↄ̀, akũ Filisitininↄ sù òtɛn pↄ́nↄ bↄtɛ gbɛ̃ kũ ò gàganↄa, akũ ò Solu kũ a nɛ́ mɛ̀n aakↄ̃ pìnↄ gɛ̀nↄ è katɛna Giliboa sĩ̀sĩgɛrɛɛi. ");
INSERT INTO bqp_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Akũ ò Solu mìi zↄ̃̀ ò a gↄ̃kɛbↄnↄ bↄ̀tɛa, akũ ò gbɛ̃nↄ zĩ̀ ò a baaruu kpàkpa Filisitininↄ bùsu gu sĩnda pínkia kũ ń tãnakpɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Ò a gↄ̃kɛbↄnↄ kàtɛ tãna kũ òdi pi Asatorɛ kpɛ́n, akũ ò a gɛ̀ɛ lòko Bɛtɛsã bĩnia. ");
INSERT INTO bqp_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Kũ Yabɛsi Giliadadenↄ yã kũ Filisitininↄ kɛ̀ Solunɛ pìi mà, ");
INSERT INTO bqp_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","akũ ń gↄ̃sa gbãnanↄ fùtɛ ń pínki ò tá gwãani ò zĩ birea, ò Solu kũ a nɛ́nↄ gɛ̀nↄ kìpa Bɛtɛsã bĩnia, akũ ò tào Yabɛsi ò tɛ́ sↄ̃̀ḿma gwe. ");
INSERT INTO bqp_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Ò ń wánↄ sɛ̀tɛ ò vĩ̀ sãma lí gbáru Yabɛsi gwe, akũ ò lɛ́ yĩ̀ gↄrↄ suppla. ");
INSERT INTO bqp_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Solu gana gbɛra Dauda sù kũ zĩ̀blena Amalɛkinↄaao, akũ à gↄ̃̀ Zikilaga gↄrↄ pla. ");
INSERT INTO bqp_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","A gↄrↄ aakↄ̃de zĩ gↄ̃gbɛ̃ ke bò Solu bùran à sù. A pↄ́kasanↄ kɛ̃kɛ̃na, bùsu ká a mìn. Kũ à kà Dauda kĩnaa, à kùtɛnɛ à wùtɛ a gbɛrɛa. ");
INSERT INTO bqp_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Dauda a là à pì: N bo máa? À wèa à pì: Ma bo Isarailanↄ bùrammɛ. ");
INSERT INTO bqp_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Akũ Dauda a là dↄ: À kɛ̀ dera gwee? Ǹ omɛnɛ. Akũ à wèa à pì: Isarailanↄ bò zĩ̀lan ò bàa lɛ̀. Ń daside lɛ̀tɛ ò gàga. Solu kũ a nɛ́ Yonatão gà dↄ. ");
INSERT INTO bqp_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Akũ Dauda kɛfɛnna kũ àtɛn baaruu pì kpáarɛ là à pì: N kɛ deran ń dↄ̃ kũ Solu kũ a nɛ́ Yonatão gàa? ");
INSERT INTO bqp_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","À wèa à pì: À sù à lè má kú Giliboa kpi gɛrɛɛi gwemɛ, akũ ma Solu è, àtɛn gbãna e a sária. Sↄ̃godenↄ kũ sↄ̃denↄ tɛn ká kãao kĩni. ");
INSERT INTO bqp_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Kũ à lìtɛ ma kpa, à ma e, akũ à ma sisi. Ma pì: Makũ dí! ");
INSERT INTO bqp_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Akũ à ma la, makũmɛ dí ũu? Akũ ma wea ma pì Amalɛki burin ma ũ. ");
INSERT INTO bqp_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Akũ à pìmɛnɛ mà naai mà a dɛ, zaakũ á kú ga lɛ́imɛ, bee kũ a wɛ́ kpɛ́ kɛ̃na fíti. ");
INSERT INTO bqp_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Akũ ma nai ma a dɛ̀, zaakũ má dↄ̃ ani fↄ̃ à ble a lɛtɛnaa gbɛra doro. Akũ ma a kífura kũ à kunaa sɛ̀ kũ zã kũ à danaao, akũ ma suonnɛ la ma dikiri. ");
INSERT INTO bqp_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Akũ Dauda a pↄ́kasanↄ gà à kɛ̃̀, akũ gbɛ̃ kũ ò kú kãaonↄ ń pↄ́nↄ kɛ̃̀kɛ̃ se. ");
INSERT INTO bqp_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Ò Solu kũ a nɛ́ Yonatão gana ↄ́ↄ dↄ̀ kũ Dikiri gbɛ̃ Isarailanↄ, zaakũ zĩ̀ ń blé. Wɛ́'i bòḿma, akũ ò lɛ́ yĩ̀ ari ↄkↄsi. ");
INSERT INTO bqp_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Dauda kɛfɛnna kũ à baaruu pìi kpàarɛ là à pì: N bɛ kú máa? Akũ à pìnɛ: Bòasu nɛ́n ma ũ, Amalɛki buri. ");
INSERT INTO bqp_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Akũ Dauda a là à pì: À kɛ̀ dera kína kũ Dikiri kà dɛna vĩna dí n kũroo? ");
INSERT INTO bqp_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","Akũ Dauda a kɛfɛnna ke sìsi à pì: Ǹ a lɛ́ ǹ dɛ se. Akũ à a lɛ̀ à dɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","Zaakũ Dauda gĩnakɛ à pìnɛ: N n zĩda dɛ̀mɛ. N zĩda lɛ́ mɛ́ à n da yãn, n pì n kína kũ Dikiri kàa dɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Dauda wɛ̃nda lɛ̀ díkĩna sì Solu kũ a nɛ́ Yonatão ga yã musu. ");
INSERT INTO bqp_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","À pì ò lɛ̀ɛ pìi dada Yudanↄnɛ. À kú Yasa takadan. ");
INSERT INTO bqp_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","Isarailanↄ gakuridenↄ gàga sĩ̀sĩgɛrɛɛi, gↄ̃sa gbãnanↄ i òmɛ fá! ");
INSERT INTO bqp_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Àsun a baaru kpá Gata zɛ́danlo, de Filisitini nↄgbɛ̃nↄ sún a pↄnna kɛro yãi. Àsun a kpàkpa kɛ Asakɛlↄniro, de gyↄfↄrↄde nɛ́nↄgbɛ̃nↄ sún ayuwii kɛro. ");
INSERT INTO bqp_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Plí sún kpá Giliboa gbɛ̀ɛa doro, legũ sún ma bura kũ ò kú gwenↄn doro, gwen ò ↄ sↄ̃̀ gↄ̃sa gbãnanↄ sɛ̃gbakonↄi, nísi dↄkↄna Solu sɛ̃gbakoa lɛ́ zɛ̀! ");
INSERT INTO bqp_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Kũ òtɛn gↄ̃sa gbãna aru fã gua, òtɛni ń gbɛrɛ para, kàzuri pãsĩ Yonatã dì kpɛ gwaro, fɛ̃nɛdade pãsĩ Solu dì su koriro. ");
INSERT INTO bqp_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Solu kũ Yonatão, gbɛ̃ mana yenyĩdenↄmɛ! Odi kɛ̃kↄ̃a wɛ̃̀ndi ke ganaa gũnlo. Ń wãna de vãunↄla, ń gbãna de músunↄla. ");
INSERT INTO bqp_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Isaraila nↄgbɛ̃nↄ, à wɛ́'i bo Solu ga yã musu. À biza tɛ̃ra yĩ̀árɛ kũ nↄmanablebↄnↄ, à á pↄ́kasanↄ kɛ̀kɛárɛ kũ zãblebↄ kũ ò pì kũ wuraaonↄ. ");
INSERT INTO bqp_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Gↄ̃sa gbãnanↄ i ò zĩ̀lan fá! Yonatã wutɛna gɛ̀ ũ sĩ̀sĩgɛrɛɛi. ");
INSERT INTO bqp_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Ma gbɛ̃ Yonatã, ma gↄ̃ warikɛnaa gũn n yãi, ń manamɛnɛ swáswa. Yenyĩ kũ ń vĩ kũmao sára vĩro, à de nↄ yenyĩla. ");
INSERT INTO bqp_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Gↄ̃sa gbãnanↄ i ò fá! Ń zĩ̀kabↄnↄ kàkatɛ. ");
INSERT INTO bqp_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Abire gbɛra Dauda Dikiri gbɛ̀ka à pì: Mà gɛ́ Yuda wɛ̃tɛ ke gũn yá? Dikiri pìnɛ à gɛ́, akũ Dauda ɛ̀ra à a là à pì: Mákpan mà gɛ́nn? Dikiri wèa à pì: Ɛblↄnu kpa. ");
INSERT INTO bqp_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Akũ Dauda gɛ̀ɛ gwe kũ a nↄ mɛ̀n planↄ, Yɛzɛrili gbɛ̃ Ainↄama kũ Nabala gyaanↄ Abigaili, Kaamɛli gbɛ̃o. ");
INSERT INTO bqp_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Dauda gɛ̀ɛ kũ gbɛ̃ kũ ò kú kãaonↄ dↄ, baadi kũ a bedenↄ, akũ ò vùtɛ Ɛblↄnu kũ a lakutunↄo. ");
INSERT INTO bqp_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Akũ Yudanↄ gbɛ̃ zↄ̃kↄ̃nↄ sù ò nísi kù Dauda mìia gwe, ò a kà Yudanↄ kína ũ. Kũ Dauda mà Yabɛsi Giliadadenↄ mɛ́ ò Solu vĩ̀, ");
INSERT INTO bqp_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","à gbɛ̃nↄ zĩ̀ḿma, ò gɛ̀ɛ ò òńnɛ: Dauda pì, Dikiri arubarika daágu, kũ a gbɛ̃kɛ kɛ̀ Solu á dikiriinɛ a a vĩ̀. ");
INSERT INTO bqp_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Dikiri gbɛ̃kɛ yã kũ náani yão kɛárɛ. Makũ sↄ̃ mani yã mana kɛárɛ kũ a yã pìi kɛ̀ yãi. ");
INSERT INTO bqp_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Tera sà àgↄ̃ gbãna à kù gbãna kɛ. Á dikiri Solu gà, akũ Yudanↄ ma ka ń kína ũ. ");
INSERT INTO bqp_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","À sù à lè Nɛrɛ nɛ́ Abana, Solu zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ↄ gĩnakɛ à gɛ̀ɛ se kũ Solu nɛ́ Isibosɛo Manaimu. ");
INSERT INTO bqp_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Akũ à a kà kína ũ Giliada bùsun kũ Asa burinↄ bùsuuo kũ Yɛzɛrilio kũ Ɛflaimu burinↄ bùsuuo kũ Biliaminu burinↄ bùsuuo kũ Isarailanↄ bùsu kparanↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Solu nɛ́ Isibosɛ wɛ̃̀ buplade gũnn à gↄ̃̀ Isarailanↄ kína ũ. À kí blè wɛ̃̀ pla. Yudanↄ sↄ̃, Daudan ò zɛ̀o. ");
INSERT INTO bqp_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","Dauda kí blè Yudanↄa zaa Ɛblↄnu ari wɛ̃̀ suppla kũ mↄ suddoo. ");
INSERT INTO bqp_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","Nɛrɛ nɛ́ Abana kũ Solu nɛ́ Isibosɛ zĩ̀karinↄ bò Manaimu ò gɛ̀ɛ Gibiↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","Zeruya nɛ́ Yoabu kũ Dauda zĩ̀karinↄ fùtɛ ò gɛ̀ɛ dańlɛ Gibiↄ̃ íkaki sarɛ. Ń gã̀ do kú í bara la, ń gã̀ do kú í bara dire. ");
INSERT INTO bqp_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","Akũ Abana pì Yoabunɛ: Ǹ tó kɛfɛnna kenↄ futɛkↄ̃i ò gwa. Akũ Yoabu pì: Ò gɛ́. ");
INSERT INTO bqp_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Akũ Biliaminu zĩ̀karinↄ fùtɛ gbɛ̃nↄn kuri awɛɛpla Isibosɛ pↄ́ ũ, akũ Dauda zĩ̀karinↄ fùtɛ gbɛ̃nↄn kuri awɛɛpla se. ");
INSERT INTO bqp_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","Baadi ↄ kà a ↄsikari dake kↄ̀kↄtↄↄi, akũ ò kↄ̃ zↄ̃̀zↄ̃ kↄ̃ gbã̀ntɛrɛɛa kũ fɛ̃nɛo ò lɛ̀tɛ lɛɛlɛ. Akũ ò tↄ́ kpà Gibiↄ̃ gu pìinɛ Fɛ̃nɛlɛnnabura. ");
INSERT INTO bqp_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Zĩ̀ kũ ò kà zĩ birea pãsĩ manamana, akũ Dauda zĩ̀karinↄ zĩ̀i blè Abana kũ Isarailanↄa. ");
INSERT INTO bqp_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","Zeruya nɛ́gↄ̃gbɛ̃ gbɛ̃nↄn aakↄ̃nↄn kú gwe, Yoabu kũ Abisaio kũ Asahɛlio. Asahɛli sↄ̃ a bà nna lán zↄ̃ bà. ");
INSERT INTO bqp_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","Akũ à pɛ̀tɛ Abanai, adi litɛ ↄplai ke ↄzɛiro. ");
INSERT INTO bqp_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","Kũ Abana a kpɛ gwà à a è, akũ à pì: Asahɛli, mↄkↄ̃mmɛ gwe yá? À wèa à pì: Makũmɛ. ");
INSERT INTO bqp_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","Akũ Abana pìnɛ: Ǹ litɛ n ↄplai ke n ↄzɛi, ǹ kɛfɛnnanↄ doke kũ ǹ a pↄ́nↄ sía. Ama Asahɛli dí zɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","Abana ɛ̀ra à pìnɛ dↄ: Ǹsun namairo. Ń ye mà n dɛn yá? Tó ma n dɛ, mani we ó wɛ́ kɛ siikↄ̃ kũ n vĩ̀ni Yoabuo dↄ yá? ");
INSERT INTO bqp_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Ama Asahɛli gì, adi zɛnɛro, akũ Abana a zↄ̃̀ a gbɛrɛa kũ a sári páo ari à bò a kpɛ kpa. Gwen à lɛ̀tɛn à gà gↄ̃̀nↄ. Kũ gbɛ̃ sĩnda pínki kà gu kũ à lɛ̀tɛ à gà pìn, ò zɛ̀ òtɛn gwa. ");
INSERT INTO bqp_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Akũ Yoabu kũ Abisaio pɛ̀ Abanaa ari ifãntɛ̃ gɛ̀ɛ à gɛ̃̀ kpɛ́n. Ò kà Ama sĩ̀sĩ kũ à kú Gia ifãboki kpa Gibiↄ̃ gbáranna zɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Biliaminu burinↄ kàkara Abanai gã̀ do, akũ ò gɛ̀ɛ òtɛn gí kũ ń zĩdao sĩ̀sĩi musu. ");
INSERT INTO bqp_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","Akũ Abana lɛ́ zù Yoabui à pì: Óni zɛ kↄ̃dɛdɛnaanɛroo? Ń dↄ̃ kũ yã pì ni mì dɛ kũ pↄsiraoroo? Ĩni o n gbɛ̃nↄnɛ ò zɛwɛrɛ ò ɛra ò tároo? ");
INSERT INTO bqp_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","Akũ Yoabu wèa à pì: Luda kun! Tó ńdi lɛ́ sí yãro, ma gbɛ̃nↄ ni zɛárɛro ari gu gɛ́ dↄo. ");
INSERT INTO bqp_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Kũ Yoabu kuru pɛ̀, akũ a gbɛ̃nↄ kámma bò, odi gɛ́ Isarailanↄa kũ zĩ̀io doro. ");
INSERT INTO bqp_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Gwãani birea Abana kũ a gbɛ̃nↄ táa ò sɛ̃̀n ò bikũ̀ Yodaa, akũ ò tɛ́ swadↄrↄↄi ari ò gɛ̀ɛ ò kà Manaimu. ");
INSERT INTO bqp_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Kũ Yoabu sù kũ pɛna Abanaaao, akũ à a zĩ̀karinↄ kàkara ń pínki. Dauda gbɛ̃nↄ tɛ́ gbɛ̃nↄn baro donsari mɛ́ ò kunlo, Asahɛli baasi. ");
INSERT INTO bqp_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","Ò Biliaminu kũ ò kú kũ Abanaonↄ dɛ̀dɛ gbɛ̃nↄn wàa do kũ basↄraakↄ̃o. ");
INSERT INTO bqp_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","Ò Asahɛli gɛ̀ɛ sɛ̀ ò vĩ̀ a de miran Bɛtilihamu. Akũ Yoabu kũ a gbɛ̃nↄ táa ò gwãani ò kà Ɛblↄnu gudↄnaao. ");
INSERT INTO bqp_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Zĩ̀ kũ Solu bedenↄ kà kũ Dauda bedenↄ gìi kɛ̀. Dauda gbãna tɛn kara, Solu bedenↄ sↄ̃, ń gbãna tɛn lago. ");
INSERT INTO bqp_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","Nɛ́gↄ̃gbɛ̃ kũ Dauda ì Ɛblↄnunↄ tↄ́n dí. A káaku tↄ́n Aminↄ. A da tↄ́n Ainↄama, Yɛzɛrili gbɛ̃mɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","A plade tↄ́n Kiliabu. A da tↄ́n Abigaili, Nabala gyaanↄ Kaamɛli gbɛ̃mɛ. A aakↄ̃de tↄ́n Abusalomu. A da tↄ́n Maaka, Gesuru kína Talamai nɛ́mɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","A siikↄ̃de tↄ́n Adonia. A da tↄ́n Agi. A sↄↄrode tↄ́n Sefatia. A da tↄ́n Abitali. ");
INSERT INTO bqp_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","A suddode tↄ́n Itiriamu. A da tↄ́n Egela. Dauda nↄnↄ nɛ́ pìnↄ ì Ɛblↄnumɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","Gↄrↄ kũ Solu bedenↄ tɛn zĩ̀ ká kũ Dauda bedenↄ, Abana tɛn gbãna kũ Solu bedenↄ gũn. ");
INSERT INTO bqp_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","Solu nↄ yìgisaride vĩ yã, a tↄ́n Rizipa, Aya nɛ́mɛ. Isibosɛ pì Abananɛ: À kɛ̀ dera n wutɛ kũ ma de nↄoo? ");
INSERT INTO bqp_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","Abana pↄ fɛ̃̀ manamana Isibosɛ yã pì yãi à pì: Gbɛ̃dan ma ũ Yudanↄ kpa yá? Matɛn gbɛ̃kɛ kɛ n de Solu bedenↄnɛ kũ a dakũnanↄ kũ a gbɛ̃nnanↄ ari kũ a gbãrao. Mádi n na Daudanɛ a ↄĩro, akũ ntɛni ma taari e nↄgbɛ̃ pì yã musu sàa? ");
INSERT INTO bqp_vpl VALUES ("S23_9","011_3_9","2SA","3","9","9","Tó mádi lɛ́ kũ Dikiri sɛ̀ Daudanɛ kɛnɛro, Luda yã kɛmɛnɛ pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("S23_10","011_3_10","2SA","3","10","10","Mani kpata sí Solu bedenↄa mà tó Dauda gↄ̃ Isarailanↄ kũ Yudanↄ kína ũ sɛna zaa Dani ari à gɛ́ pɛ́o Bɛsɛbaa. ");
INSERT INTO bqp_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","Isibosɛ dí we à wè Abanaa doro, kũ àtɛn vĩna kɛnɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","Abana gbɛ̃nↄ zĩ̀ Daudaa kũ a tↄ́o à pìnɛ: Dí mɛ́ à bùsu vĩi? Ò lɛ́dokↄ̃nↄ kɛ, mani kpányĩ de Isarailanↄ bàka le àgↄ̃ kú kũnwo ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","Akũ Dauda pì: À mana, mani lɛ́dokↄ̃nↄ kɛ kũnwo, ama yã mɛ̀n don matɛn gbɛkamma. Tó ntɛn su ma gwa, tó ńdi sumɛnɛ kũ Solu nɛ́nↄgbɛ̃ Mikalaoro, ǹsun tó ó wɛ́ sikↄ̃lɛro. ");
INSERT INTO bqp_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","Dauda lɛ́gbãzã kɛ̀ Solu nɛ́ Isibosɛnɛ à pì: Ǹ ma nanↄ Mikala sukpamɛnɛ. Ma anzure blè kũ Filisitininↄ gyↄfↄrↄo mɛ̀n basↄↄro. ");
INSERT INTO bqp_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","Akũ Isibosɛ gbɛ̃nↄ zĩ̀, ò nↄgbɛ̃ pìi sì a zã Palatiɛli, Laisi nɛ́a. ");
INSERT INTO bqp_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","Akũ a zã pì tɛn gɛ́ kãao à tɛ́i ari Bahurimu, àtɛn ↄ́ↄ dↄ. Akũ Abana ònɛ à ɛra à tá, akũ à ɛ̀ra. ");
INSERT INTO bqp_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","Abana yã ò kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ à pì: Zaa zĩ átɛn wɛtɛ Dauda gↄ̃ de á kína ũ. ");
INSERT INTO bqp_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","À a ká sà, zaakũ Dikiri lɛ́ sɛ̀nɛ à pì, áni a gbɛ̃ Isarailanↄ bo Filisitininↄ kũ ń ibɛrɛnↄ ↄĩ ń pínki a zↄ̀bleri Dauda pìi gãimɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","Abana yã pìi dà Biliaminu burinↄnɛ ń sãn dↄ. Akũ à gɛ̀ɛ Ɛblↄnu, de à yã kũ à kɛ̀ Biliaminu burinↄnɛ kũ Isarailanↄoo pì o Daudanɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","Kũ à kà Dauda kĩnaa zaa Ɛblↄnu kũ gbɛ̃nↄn baro kũ ò kú kãaonↄ, akũ Dauda pↄnna pↄ́ble kɛ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","Akũ Abana pì Daudanɛ: Ma dikiri kína, ǹ tó mà futɛ mà gɛ́ mà Isarailanↄ kakarannɛ ń pínki, de ò lɛ́dokↄ̃nↄ kɛ kũnwo, ĩnigↄ̃ de bùsu kũ n pↄ yei pínki kína ũ. Akũ Dauda Abana gbàrɛ, à tá aafia. ");
INSERT INTO bqp_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","Zĩ birea Yoabu kũ Dauda gbɛ̃nↄ sù kũ lɛ́tɛmmanaao. Ò pↄ́nↄ sì gbɛ̃nↄa manamana ò sùo. Abana kú kũ Daudao gwe doro, zaakũ à a gbàrɛ, à tá aafia. ");
INSERT INTO bqp_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","Kũ Yoabu kũ zĩ̀kari kũ ò kú kãaonↄ kà, ò ònɛ Nɛrɛ nɛ́ Abana sù kína gwa, akũ à a gbàrɛ à tá aafia. ");
INSERT INTO bqp_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","Akũ Yoabu gɛ̀ɛ à kína lè à pì: Bↄ́ yãn n kɛ̀ gwee? Kũ Abana sù n kĩnaa, bↄ́yãi n tò à tàa? ");
INSERT INTO bqp_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","Ń Nɛrɛ nɛ́ Abana dↄ̃roo? À sù ↄ̃ndↄ̃ kɛnnɛ, de à le àgↄ̃ n gɛ́gↄrↄ kũ n sugↄrↄo dↄ̃ kũ n yãkɛnanↄ pínki. ");
INSERT INTO bqp_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","Kũ Yoabu bò Dauda kĩnaa, akũ à gbɛ̃nↄ zĩ̀, ò pɛ̀tɛ Abanai. Ò a lè Sira lↄ̀gↄ kĩnaa, akũ òtɛn su kãao, ama Dauda a yã dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","Kũ ò kà kũ Abanao Ɛblↄnu wɛ̃tɛ bĩnilɛa, akũ Yoabu a sìsi lándↄ̃ à ye à asiriyã onɛ bà, akũ à a zↄ̃̀ a gbɛrɛa à a dɛ̀. A dakũna Asahɛli dɛna fĩnaan à bòa gwe. ");
INSERT INTO bqp_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","Abire gbɛra kũ Dauda mà, à pì: Makũ kũ ma kíkɛo, manigↄ̃ taari vĩ Dikirinɛ Nɛrɛ nɛ́ Abana dɛna yã musuro. ");
INSERT INTO bqp_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","Yã pì ni wí Yoabu musumɛ kũ a de bedenↄ ń pínki. Yoabu bedenↄ nigↄ̃ kun kɛntude ke kusu ke ɛrɛ ke gbɛ̃ kũ zĩ̀ a blè ke nàdɛrii sariro. ");
INSERT INTO bqp_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","Yoabu kũ Abisaio Abana dɛ̀, kũ àkũ mɛ́ à ń dakũna Asahɛli dɛ̀ zĩ̀lan zaa Gibiↄ̃ yãi. ");
INSERT INTO bqp_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","Akũ Dauda pì Yoabunɛ kũ gbɛ̃ kũ ò kú kãaonↄ ń pínki: À á pↄ́kasanↄ gága à kɛ̃kɛ̃, à uta kasanↄ daála, àgↄ̃ tɛ́ arɛ kũ Abana gɛ̀ɛo kũ ↄ́ↄdↄo. Kína Dauda sↄ̃ à tɛ́ ń kpɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","Akũ ò a vĩ̀ Ɛblↄnu gwe. Kína wɛ̃nda ↄ́ↄ dↄ̀ gbãnagbãna Abana miraa, akũ gbɛ̃ sĩnda pínki ↄ́ↄ dↄ̀ se. ");
INSERT INTO bqp_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","Akũ kína wɛ̃ndalɛ díkĩna sì Abana yã musu à pì: Abana gana lán mìsaride bà manan gwe yá? ");
INSERT INTO bqp_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","Òdi n gã̀ yĩnnɛ n kpɛ kparo, òdi mↄ̀kakↄ̃ana kánnɛro, n ga lán gbɛ̃ kũ à gɛ̃̀ yãvãnikɛrinↄ ↄĩ bà. Akũ gbɛ̃ sĩnda pínki ɛ̀ra ò ↄ́ↄ dↄ̀ dↄ. ");
INSERT INTO bqp_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","Gbɛ̃ sĩnda pínki sù ò ò Daudanɛ à pↄ́ ble ari gu gↄ̃ gɛ́ si, ama à la dà à pì: Tó ma burodi ke pↄ́ble ke dà ma lɛ́n ifãntɛ̃ gɛ̃na kpɛ́n sari, Luda yã kɛmɛnɛ pãsĩpãsĩ. ");
INSERT INTO bqp_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","Gbɛ̃ sĩnda pínki wɛ́ tɛ̀ yã pìii, akũ à kɛ̀ńnɛ mana. Yã kũ kína tɛn kɛ pínki dì kɛ gbɛ̃nↄnɛ manamɛ. ");
INSERT INTO bqp_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","Zĩ birea Dauda gbɛ̃nↄ kũ Isarailanↄ pínki dↄ̃̀ sà kũ kína lɛ́ kú Nɛrɛ nɛ́ Abana dɛna yãnlo. ");
INSERT INTO bqp_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","Akũ à pì a gbɛ̃ pìnↄnɛ: Á dↄ̃ kũ Isaraila don'arɛde zↄ̃kↄ̃ↄ gà gbãraroo? ");
INSERT INTO bqp_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","Makũ sↄ̃, bee kũ Luda ma ka kína ũ, ma busa gbãra. Zeruya nɛ́ pìnↄ yãkɛna pãsĩ de ma pↄ́la. Dikiri mɛ́ ani fĩna bo vãnikɛriinɛ a vãni lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","Kũ Solu nɛ́ Isibosɛ mà Abana gà Ɛblↄnu, a kã gà, akũ Isarailanↄ gↄ̃̀ bídi gũn ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","Solu nɛ́ pìi zĩ̀kari gbɛ̃ zↄ̃kↄ̃nↄ vĩ gbɛ̃nↄn pla, a do tↄ́n Baana, a do sↄ̃ Rekabu. Bero gbɛ̃ Rimↄ, Biliaminu buri nɛ́nↄmɛ. Ò Bero dìtɛ Biliaminu bùsu pↄ́ ũ yãmɛ, ");
INSERT INTO bqp_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","zaakũ Berodenↄ bàa lɛ̀ ò tà Gitaimu ò kú gwe ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","Solu nɛ́ Yonatã sↄ̃ à nɛ́ vĩ ɛrɛ ũ. Gↄrↄ kũ nɛ́ pìi kà wɛ̃̀ sↄↄro, akũ Solu kũ Yonatão gana Yɛzɛrili baaruu sù. Kũ a gwàri a sɛ̀ àtɛn bàa lɛ́ kãao, a wãnaa gũnn nɛ́ pìi pìtia à lɛ̀tɛ. Abire mɛ́ à tò à ɛrɛ kũ̀. A tↄ́n Mɛfibosɛ. ");
INSERT INTO bqp_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","Bero gbɛ̃ Rimↄ nɛ́ pìnↄ Rekabu kũ Baanao fùtɛ, ifãntɛ̃ gbãnai ò kà Isibosɛ bɛa, gↄrↄ kũ àtɛn i fãnantɛ̃ o. ");
INSERT INTO bqp_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","Akũ Rekabu kũ a dakũna Baanao gɛ̃̀ kpɛ́n ò kɛ̀ lándↄ̃ òtɛn gɛ́ pↄ́blewɛ dã bà. ");
INSERT INTO bqp_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","Kũ ò gɛ̃̀ kpɛ́n, Isibosɛ wutɛna a gádoa, akũ ò gɛ̃̀i kpɛ́nɛ gũn ò a zↄ̃̀ ò dɛ̀. Akũ ò a mìi zↄ̃̀ ò sɛ̀ ò tào. Ò pɛ̀tɛ Yoda sɛ̃̀n, akũ ò táa ò ari gu gɛ̀ɛ à dↄ̀o. ");
INSERT INTO bqp_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","Ò sù Dauda kĩnaa Ɛblↄnu kũ Isibosɛ mìio ò pìnɛ: Ǹ gwa, n ibɛrɛ Solu kũ à wɛ̀tɛ à n dɛ nɛ́ Isibosɛ mìin dí. Ó dikiri kína, Dikiri fĩnaa bònnɛ Solu kũ a burinↄa gbãra. ");
INSERT INTO bqp_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","Dauda wèḿma à pì: Dikiri kun! À ma bo ma warikɛnaa gũn pínki. ");
INSERT INTO bqp_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","Kũ gbɛ̃ke sù ma kĩnaa Zikilaga yã à pì Solu gà, àtɛn da baaru nnan átɛn kpá, akũ ma a kũ̀ ma dɛ̀. A baaru àreen gwe. ");
INSERT INTO bqp_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","Dí deńla lákũ ákↄ̃nↄ gbɛ̃ vãninↄ a taarisaride dɛ̀ a gádoa a kpɛ́n nà. Mani a dɛna fĩna boáwa mà á wɛ̃̀ndi bo se. ");
INSERT INTO bqp_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","Akũ Dauda yã ò a gbɛ̃nↄnɛ, akũ ò ń dɛdɛ. Ò ń ↄla kũ ń gbálanↄ zↄ̃̀zↄ̃, akũ ò ń gɛ̀nↄ lòko Ɛblↄnu ítↄki sarɛ. Akũ ò Isibosɛ mìi sɛ̀ ò vĩ̀ Abana miran zaa Ɛblↄnu. ");
INSERT INTO bqp_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Isarailanↄ sù ń buria ń pínki Dauda kĩnaa zaa Ɛblↄnu ò pì: Ó aru dokↄ̃nↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Zaa zĩ gↄrↄ kũ Solu de ó kína ũ, mↄkↄ̃mmɛ ndì dowɛrɛ arɛ zĩ̀lan, gɛna kũ sunaao. Akũ Dikiri pìnnɛ, mↄkↄ̃mmɛ ĩnigↄ̃ de a gbɛ̃ Isarailanↄ don'arɛde ũ, ń kína ũ. ");
INSERT INTO bqp_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ sù kína Dauda kĩnaa zaa Ɛblↄnu ń pínki, gwen à lɛ́dokↄ̃nↄ kɛ̀n kũńwo Dikiri arɛ, akũ ò nísi kù a mìia ò a kà Isarailanↄ kpatan. ");
INSERT INTO bqp_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Dauda wɛ̃̀ baraakuri vĩ gↄrↄ kũ à nà kíblenaaa, à vùtɛ kín wɛ̃̀ bupla. ");
INSERT INTO bqp_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","À de Yudanↄ kína ũ zaa Ɛblↄnu wɛ̃̀ suppla kũ mↄ suddoo, akũ à de Yudanↄ kũ Isarailanↄ pínki kína ũ zaa Yurusalɛmu wɛ̃̀ baraakuri awɛɛ'aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Kína kũ a gbɛ̃nↄ gɛ̀ɛ Yurusalɛmu de à zĩ̀ ká kũ Yebusi kũ ò kú gwenↄ. Akũ ò ò Daudanɛ: Ĩni gɛ̃ laro, bee vĩ̀nanↄ kũ ɛrɛnↄ oni pɛ́mma. Òtɛn da Dauda ni le à gɛ̃ gwero. ");
INSERT INTO bqp_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Bee kũ abireo Dauda wɛ̃tɛ bĩnide kũ òdi pi dↄ Zaiↄ̃ pìi sì, akũ à gↄ̃̀ a wɛ́ra ũ. ");
INSERT INTO bqp_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Zĩ birea Dauda pì: Tó gbɛ̃ ye à Yebusinↄ dɛdɛ, séde à gɛ̃ ízɛ kũ ò yↄ̃̀ gbɛ̀n gũn, ani ɛrɛnↄ kũ vĩ̀naa pìnↄ le. Dauda ibɛrɛnↄmɛ. Abire yãi òdi pi, vĩ̀nanↄ kũ ɛrɛnↄ oni gɛ̃ kínabɛaro. ");
INSERT INTO bqp_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Akũ Dauda bɛ kũ̀ wɛ̃tɛ bĩnide pìi gũn, à a zĩda tↄ́ kpànɛ, Dauda Wɛ̃tɛ. À kpɛ́nↄ bòbo à lìkai ari gu kũ ò wɛ̀ɛɛ tàtan, òdi pi Milo. ");
INSERT INTO bqp_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Dauda gbãna tɛn kara, zaakũ Dikiri Luda Zĩ̀karide kú kãao. ");
INSERT INTO bqp_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Taya kína Hiramu gbɛ̃nↄ zĩ̀ Daudaa kũ sida línↄ kũ lí'arinↄ kũ gbɛ̀'arinↄ, akũ ò bɛ bònɛ. ");
INSERT INTO bqp_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Akũ Dauda dↄ̃̀ sà kũ Dikiri a ka Isarailanↄ kína ũmɛ, akũsↄ̃ à a kpataa kàraárɛ kũ Isarailanↄn de Dikiri gbɛ̃nↄ ũ yãi. ");
INSERT INTO bqp_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Dauda bona Ɛblↄnu gbɛra à ɛ̀ra à nↄ pãndenↄ sɛ̀ à kàra Yurusalɛmu dↄ kũ nↄ yìgisaridenↄ, akũ à nɛ́gↄ̃gbɛ̃nↄ kũ nɛ́nↄgbɛ̃nↄ ì kũńwo. ");
INSERT INTO bqp_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Nɛ́gↄ̃gbɛ̃ kũ à ń í Yurusalɛmu pìnↄ tↄ́n dí: Samua, Sobabu, Natã, Sulemanu, ");
INSERT INTO bqp_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","Iba, Ɛlisua, Nɛfɛgi, Yafia, ");
INSERT INTO bqp_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","Ɛlisama, Ɛliada kũ Ɛlifɛlɛtio. ");
INSERT INTO bqp_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Kũ Filisitininↄ mà ò Dauda kà Isarailanↄ kína ũ, akũ ò gɛ̀ɛ òtɛni a wɛtɛ ò a dɛ ń pínki. Kũ à ń baaruu mà, akũ à gɛ̀ɛ sɛ̃̀ntɛpↄrↄtu. ");
INSERT INTO bqp_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Filisitininↄ zĩ̀'ↄ pòro Rɛfaimu guvutɛn, ");
INSERT INTO bqp_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","akũ Dauda gbɛ̀ka Dikiria à pì: Mà gɛ́ mà lɛ́tɛ Filisitininↄa, ĩni ń namɛnɛ ma ↄĩ yá? Akũ Dikiri wèa à pì: Ǹ gɛ́, mani ń nannɛ n ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Akũ Dauda gɛ̀ɛ Baali Pɛrazimu, à zĩ̀i blèḿma gwe. Akũ à pì: Dikiri dòmɛnɛ arɛ, à bò à sù ma ibɛrɛnↄa bùi lákũ í dì gu fↄ̃ nà. Akũ à tↄ́ kpà gu pìinɛ Baali Pɛrazimu. ");
INSERT INTO bqp_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Filisitininↄ ń tãnanↄ tò gwe, akũ Dauda kũ a gbɛ̃nↄ sɛ̀tɛ ò tào. ");
INSERT INTO bqp_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Filisitininↄ ɛ̀ra ò sù dↄ, ò zĩ̀'ↄ pòro Rɛfaimu guvutɛn. ");
INSERT INTO bqp_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Akũ Dauda ɛ̀ra à gbɛ̀ka Dikiria dↄ. Akũ Dikiri wèa à pì: Ǹsun gɛ́ńyĩ súsuro. Ǹ likańyĩ kpɛ kpa ǹ lɛ́tɛḿma kpɛ̃̀ líkpɛ sarɛ. ");
INSERT INTO bqp_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Tó a gɛ̀sɛ kĩni mà lí pìnↄ musu, à kɛ likalika, zaakũ makũmɛ ma bo ma doárɛ arɛ gwe, de mà zĩ̀ bleárɛ Filisitini zĩ̀karinↄa yãi. ");
INSERT INTO bqp_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Dauda kɛ̀ lákũ Dikiri ònɛ nà, akũ à zĩ̀i blè Filisitininↄa sɛna zaa Gibiↄ̃ ari à gɛ̀ɛ pɛ́ Gɛzaa. ");
INSERT INTO bqp_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Dauda ɛ̀ra à Isaraila kũ à ń sɛ́tɛnↄ kàkara gbɛ̃nↄn dúbu baraakuri. ");
INSERT INTO bqp_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Akũ à fùtɛ à dà kũńwo zɛ́n, ò gɛ̀ɛ Baala kũ à kú Yudanↄ bùsun, de ò Luda àkpati sɛ́ ò suo. Dikiri Zĩ̀karide dìgↄ̃ vutɛna kín àkpatii pì malaika dɛ̀mbɛrɛdenↄ dagura, abire yãin òdi pi a tↄ́ kúa. ");
INSERT INTO bqp_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Ò àkpatii pìi dà zùgo dufu gũn Abinadabu bɛ sĩ̀sĩi musu, akũ ò dào zɛ́n. Abinadabu nɛ́nↄ Uza kũ Ahioo mɛ́ òtɛn do zùgo pìii, ");
INSERT INTO bqp_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","Luda àkpati kún. Ahio mɛ́ à tɛ́ arɛ, ");
INSERT INTO bqp_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","akũ Dauda kũ Isarailanↄ tɛn ũ wã ń pínki Dikiri arɛ ń gbãna zaka lɛ́n kũ lɛ̀sinaao. Òtɛn mↄrↄ lɛ́ kũ gidigboo kũ sɛ̃gɛ̃sɛ̃gɛ̃o kũ fakao kũ sɛ̃̀gɛ̃ɛo. ");
INSERT INTO bqp_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Kũ ò kà Nakↄ̃ ésegbɛ̃kia, zùnↄ gɛ̃̀ɛ sì, akũ Uza ↄ bò à nà Luda àkpatiia. ");
INSERT INTO bqp_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Akũ Dikiri pↄ fɛ̃̀i, à a lɛ̀ a dɛ̀ àkpatii sarɛ gwe dà kũ à kɛ̀ yãi. ");
INSERT INTO bqp_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Dauda nɛ̀sɛɛ yàka, kũ Dikiri pↄ fɛ̃̀ Uzai yãi, akũ òdi gu pì sísi Pↄfɛ̃'uzai ari kũ a gbãrao. ");
INSERT INTO bqp_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Zĩ birea vĩna Dauda kũ̀ Dikiri yã musu à pì: Deran mani kɛ nà mà Dikiri àkpati sɛ́ mà táoo? ");
INSERT INTO bqp_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Akũ adi we à táo a wɛ̃tɛ gũn doro, à lìtɛ à tào Gata gbɛ̃ Ɔbɛdi Ɛdↄmu bɛa. ");
INSERT INTO bqp_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Dikiri àkpati kú a bɛa ari mↄ aakↄ̃, akũ Dikiri arubarikaa dàn kũ a bedenↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Ò pì kína Daudanɛ: Dikiri arubarikaa dà Ɔbɛdi Ɛdↄmu bedenↄgu kũ pↄ́ kũ à vĩnↄ pínki a àkpati yãi. Akũ Dauda gɛ̀ɛ gwe, à Luda àkpatii sɛ̀ àtɛn suo a wɛ̃tɛ gũn kũ pↄnnao. ");
INSERT INTO bqp_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Kũ gbɛ̃ kũ ò Dikiri àkpati sɛnanↄ gbá sɛ̀ gɛ̃̀n suddo, akũ Dauda sa ò kũ zùsaao kũ zùnɛ bↄ̀rↄ mɛ̀kpanaao. ");
INSERT INTO bqp_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Dauda sa'o'uta dana, àtɛn ũ wã Dikiri arɛ a gbãna zaka lɛ́n. ");
INSERT INTO bqp_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Àpii kũ Isarailanↄ pínki òtɛn su kũ Dikiri àkpatiio, òtɛn pↄnna wiki lɛ́ òtɛn kuru pɛ́. ");
INSERT INTO bqp_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Kũ Dikiri àkpati tɛn gɛ̃ Dauda wɛ̃tɛ gũn, akũ Solu nɛ́ Mikala tɛn zĩtɛ gwa wondoo gũn. Kũ à è kína Dauda tɛn vĩvĩ àtɛn ũ wã Dikiri arɛ, à a gya bò a swɛ̃̀ɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Kũ ò sù kũ Dikiri àkpatiio, ò dìtɛ a gbɛ̀n bizakuta kũ Dauda dↄ̀nɛɛ gũn. Akũ à sa'opↄ kũ òdi ká tɛ́n à tɛ́ kũ ò Dikiri arɛ kũ kɛnnakũkↄ̃o sa'opↄo. ");
INSERT INTO bqp_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Kũ à sa ò à làka, à sa mana ò gbɛ̃nↄnɛ kũ Dikiri Zĩ̀karide tↄ́o. ");
INSERT INTO bqp_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Akũ à burodii kpàatɛtɛ Isaraila kũ ò kakarana gwenↄnɛ kↄ̃̀nↄ dodo gↄ̃gbɛ̃nↄ kũ nↄgbɛ̃nↄ ń pínki kũ domina kàraao mɛ̀n dodo kũ geepi kàraao mɛ̀n dodo. ");
INSERT INTO bqp_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Kũ Dauda tɛn su bɛ de à sa mana o a bedenↄnɛ, akũ Solu nɛ́ Mikala bò à gɛ̀ɛ à dàalɛ à pì: Mↄkↄ̃n Isarailanↄ kína, gbɛ̃ bɛ̀ɛrɛde yãn n kɛ̀ gwe gbãra yá? N n zĩda mɛ̀ɛ mↄ̀ n ìba nↄgbɛ̃ zĩkɛrinↄnɛ, lán wé'isaride dì a zĩda mɛ̀ɛ mↄńnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Akũ Dauda pì Mikalanɛ: Dikirin ma ũ wã̀nɛ. Dikiri mɛ́ à ma sɛ n de kũ a bedenↄ gɛ̃nɛ ũ, à ma kɛ a gbɛ̃ Isarailanↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Mani futa kũ de abirela, mani ma zĩda kĩa n enaa gũn, ama nↄgbɛ̃ zĩkɛri kũ ń tɛ́ḿma pìnↄ mɛ́ oni ma bɛ̀ɛrɛ dↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Akũ Solu nɛ́ Mikala dí nɛ́ iro ari à gɛ̀ɛ à gào. ");
INSERT INTO bqp_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Kũ kína vùtɛ a bɛa, Dikiri a bò ibɛrɛ kũ ò likainↄ ↄĩ à a gbà ĩampaki, ");
INSERT INTO bqp_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","akũ kína pì annabi Natãnɛ: É'e! Kpɛ́ kũ ò dↄ̀ kũ sida líon manigↄ̃ vutɛn, Luda àkpati gↄ̃ ditɛna bizakutan yá? ");
INSERT INTO bqp_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Natã wèa à pì: Lákũ à kɛ̀nnɛ nà ǹ kɛ, zaakũ Dikiri kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Gwãani birea Dikiri yã sù Natãa à pì: ");
INSERT INTO bqp_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","Ǹ gɛ́ ǹ o ma zↄ̀bleri Daudanɛ kũ ma pì, àkũ mɛ́ ani kpɛ́ kũ manigↄ̃ kun bomɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Zaa gↄrↄ kũ ma Isarailanↄ bↄ̀tɛ Misila ari gbãra mádi bɛ kũro. Madìgↄ̃ sↄ̃sↄ̃sↄ̃sↄ̃mɛ, bizakutamɛ ma kúki ũ. ");
INSERT INTO bqp_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Gu kũ ma sↄ̃sↄ̃n kũ ma gbɛ̃ Isarailanↄ ń pínki madì don'arɛdenↄ ditɛ ò dońnɛ arɛ, ama mádi o ń gbɛ̃kenɛ, bↄ́yãi adi kpɛ́ bomɛnɛ kũ sida líoro. ");
INSERT INTO bqp_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Ǹ gɛ́ ǹ o ma zↄ̀bleri Daudanɛ, ma Dikiri Zĩ̀karide ma pì, ma a sɛ̀ sãdãkia de àgↄ̃ de ma gbɛ̃ Isarailanↄ don'arɛde ũ. ");
INSERT INTO bqp_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Má kú kãao gu kũ à gɛ̀ɛn pínki, akũ ma a ibɛrɛnↄ dɛ̀dɛnɛ. Mani a tↄ́ bo manamana sà, anigↄ̃ kú andunia tↄ́denↄ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Mani bùsu kpá ma gbɛ̃ Isarailanↄa, mani ń kátɛn, oni vutɛn ń pↄ́ ũ. Ń laakari ni futɛ doro. Gbɛ̃ vãninↄ ni le ò wɛ́ tãḿma lákũ ò wɛ́ tã̀ḿma káaku ");
INSERT INTO bqp_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","gↄrↄ kũ ma don'arɛdenↄ dìtɛńnɛ nà doro. Mani a bo a ibɛrɛ pìnↄ ↄĩ ń pínki. Makũ Dikiri matɛn onɛ, makũ mɛ́ mani bɛ kɛnɛ a burinↄ gbãnaleki ũ. ");
INSERT INTO bqp_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Tó a gↄrↄ pàpa à gà, mani a buri kũ à bò a mɛ̀ɛn ke sɛ́ lei, mani a ká kpatan. ");
INSERT INTO bqp_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Àpi mɛ́ ani kpɛ́ bo kũ ma tↄ́ nigↄ̃ kúa, mani a kpatablena gbá pɛ́tɛ, anigↄ̃ kí ble ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Manigↄ̃ denɛ De ũ, anigↄ̃ de ma nɛ́ ũ. Tó à taari kɛ̀, mani wɛ́ tãa kũ gòoomɛ, lákũ bisãsiri dì gbɛ̃ gbɛ̃ nà. ");
INSERT INTO bqp_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Ama ma gbɛ̃kɛ ni kɛ̃kↄ̃a kãao lákũ ma kɛ̃̀kↄ̃a kũ Solu kũ ma a bò Dauda arɛ nàro. ");
INSERT INTO bqp_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","A burinↄ nigↄ̃ kpata ble gↄrↄ sĩnda pínki. A kpata pì nigↄ̃ lakana vĩro. ");
INSERT INTO bqp_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Akũ Natã yã pìi gbã̀ Daudanɛ lákũ Dikiri òarɛ nà pínki. ");
INSERT INTO bqp_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Akũ kína Dauda gɛ̃̀ à vùtɛ Dikiri arɛ à pì: Dikiri Luda, bↄ́n ma ũu? Dínↄn ma bedenↄ ũ kũ n ma ka gwena dí takaaa? ");
INSERT INTO bqp_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Dikiri Luda, abirekũ bi yã fítimɛ n kĩnaa, akũ n makũ n zↄ̀bleri buri kũ onigↄ̃ kú zianↄ yã ò dↄ yá? Lɛn ndì kɛńnɛ lɛ yá, Dikiri Luda? ");
INSERT INTO bqp_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Dikiri Luda, mani pinnɛ deramɛ dↄↄ? Makũ n zↄ̀bleri ń ma dↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","N yã zↄ̃kↄ̃ↄ pìi kɛ̀ lákũ n pↄ yei nà yã kũ n ò yãi, akũ n tò makũ n zↄ̀bleri ma dↄ̃̀. ");
INSERT INTO bqp_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","Dikiri Luda, ń zↄ̃kↄ̃ fá! Oni gbɛ̃ke lɛkↄ̃a kũnworo. N baasiro dikiri ke kunlo, lákũ o mà kũ ó são nà. ");
INSERT INTO bqp_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Dín oni lɛkↄ̃a kũ n gbɛ̃ Isarailanↄↄ? Andunia burinↄ tɛ́ buri mɛ̀n do pìin n bo n gɛ n bò, de ògↄ̃ de n gbɛ̃nↄ ũ. N n zĩda tↄ́ bò, n yã zↄ̃kↄ̃ bonsarɛnↄ kɛ̀ n gbɛ̃ pìnↄnɛ, n pɛ buri kenↄa kũ ń tãnanↄ n gbɛ̃ kũ n ń bó Misilanↄ arɛ. ");
INSERT INTO bqp_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","N Isarailanↄ dìtɛ ògↄ̃ de n gbɛ̃nↄ ũ ari gↄrↄ sĩnda pínki. Dikiri, n gↄ̃ ń Luda ũ. ");
INSERT INTO bqp_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","Dikiri Luda, lɛ́ kũ n sɛ̀ makũ n zↄ̀bleriinɛ kũ ma burinↄ yã musu, ǹgↄ̃ zĩ kɛa gↄrↄ sĩnda pínki. Ǹ kɛ lákũ n ò nà ");
INSERT INTO bqp_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","de ǹ tↄ́ bo manamana ari gↄrↄ sĩnda pínki. Gbɛ̃nↄ ni pi Dikiri Zĩ̀karidemɛ Isarailanↄ Luda ũ. Makũ n zↄ̀bleri Dauda, ĩni ma burinↄ zĩni pɛ́tɛ, ");
INSERT INTO bqp_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","zaakũ Dikiri Zĩ̀karide Isarailanↄ Luda, n òmɛnɛ n pì, ĩni ma bɛ kɛmɛnɛ ma burinↄ gbãnaleki ũ. Abire yãi makũ n zↄ̀bleri ma kùgbãna kɛ̀ ma wɛ́kɛ díkĩna kɛ̀mma. ");
INSERT INTO bqp_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","Dikiri Luda, mↄkↄ̃mmɛ Luda ũ, n yã náani vĩ, akũ n yã mana dínↄ lɛ́ sɛ̀ makũ n zↄ̀bleriinɛ. ");
INSERT INTO bqp_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Ǹ arubarika da makũ n zↄ̀bleri burinↄgu sà, n wɛ́ nigↄ̃ tɛ́ńyĩ gↄrↄ sĩnda pínki. Dikiri Luda, n yã ò n arubarikaa dà makũ n zↄ̀bleri burinↄgu, onigↄ̃ arubarika vĩ ari gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Abire gbɛra Dauda zĩ̀i blè Filisitininↄa à ń búsa à ń wɛ́ra Gata sìḿma. ");
INSERT INTO bqp_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","À zĩ̀i blè Mↄabunↄa, akũ à tò ò wùtɛ kↄ̃ sarɛ zĩtɛ. À bàa yↄ̃̀ḿma. Tó à bà pla daguraa dɛ̀dɛ, àdi bà do dagura tó bɛ̃nɛ. Akũ Mↄabunↄ gↄ̃̀ Dauda zↄ̀blerinↄ ũ, akũ òdigↄ̃ táfe bonɛ. ");
INSERT INTO bqp_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Dauda zĩ̀i blè Reobo nɛ́ Adadɛza, Zoba kínaa, gↄrↄ kũ kína pìi ɛ̀ra àtɛn gɛ́ ↄ tↄ̃ Yuflati swasarɛdenↄa. ");
INSERT INTO bqp_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","Akũ à a sↄ̃gonↄ kũ̀kũ mɛ̀n wàa sↄↄro kũ sↄ̃godenↄ gbɛ̃nↄn dúbu suppla kũ gbɛ̃ kũ ò tɛ́ gɛ̀sɛnↄ gbɛ̃nↄn dúbu baro. Akũ à ń sↄ̃nↄ gbátĩnↄ zↄ̃̀zↄ̃ pínki, mɛ̀n basↄↄro mɛ́ ò bò. ");
INSERT INTO bqp_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Siria kũ ò kú Damasukunↄ sù Adadɛza leo, akũ Dauda ń gbɛ̃nↄ dɛ̀dɛ dúbu baro awɛɛpla. ");
INSERT INTO bqp_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","À gudãkpãrinↄ dìtɛditɛ Siria bùsun, akũ ò gↄ̃̀ a zↄ̀blerinↄ ũ, òdigↄ̃ táfe bonɛ. Dikiri tò Dauda zĩ̀i blè gu kũ à gɛ̀ɛn pínki. ");
INSERT INTO bqp_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","Dauda Adadɛza ìbanↄ wura sɛ̃gbakonↄ sɛ̀tɛ à tào Yurusalɛmu. ");
INSERT INTO bqp_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","À mↄ̀gotɛ̃ sɛ̀tɛ dasidasi Adadɛza wɛ̃tɛ kũ òdi pi Teba kũ Berotaioo gũn. ");
INSERT INTO bqp_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","Kũ Amata kína Tohu mà Dauda zĩ̀i blè Adadɛza zĩ̀karinↄa ń pínki, ");
INSERT INTO bqp_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","akũ à a nɛ́ Adoramu zĩ̀ fↄ kpáa. À a sáabu kpà zĩ̀ kũ à blè Adadɛzaa yãi, zaakũ Tohu zĩ̀i kà kãao yã. Adoramu sù kũ wura pↄ́nↄ kũ andurufu pↄ́nↄ kũ mↄ̀gotɛ̃ pↄ́nↄ, ");
INSERT INTO bqp_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","akũ kína Dauda kàtɛ Dikiri pↄ́ ũ lákũ à kɛ̀ kũ buri kũ à gbãna blèḿmanↄ andurufu pↄ́nↄ kũ wura pↄ́nↄ nà pínki, ");
INSERT INTO bqp_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","Ɛdↄmunↄ kũ Mↄabunↄ kũ Amↄninↄ kũ Filisitininↄ kũ Amalɛkinↄ. Lɛn à kɛ̀ lɛ kũ pↄ́ kũ à sì Zoba kína Adadɛza, Reobo nɛ́aao. ");
INSERT INTO bqp_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Lɛn Dauda tↄ́ bò lɛ. Kũ à zĩ̀i blè Sirianↄa à sù, à Ɛdↄmunↄ dɛ̀dɛ Guvutɛ Wisiden gbɛ̃nↄn dúbu baro plansari. ");
INSERT INTO bqp_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Akũ à gudãkpãrinↄ dìtɛditɛ Ɛdↄmu bùsun dↄ, akũ Ɛdↄmu pìnↄ gↄ̃̀ a zↄ̀blerinↄ ũ. Gu kũ Dauda gɛ̀ɛn pínki Dikiri dì tó à zĩ̀ blemɛ. ");
INSERT INTO bqp_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Daudamɛ Isaraila buri sĩnda pínki kína ũ, à yã mana kɛ̀ a gbɛ̃nↄnɛ a zɛ́a. ");
INSERT INTO bqp_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Zeruya nɛ́ Yoabumɛ zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ ũ. Ailudi nɛ́ Yosafatamɛ baarukpari ũ. ");
INSERT INTO bqp_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Aitubu nɛ́ Zadↄki kũ Abiata nɛ́ Aimɛlɛkioomɛ sa'orikinↄ ũ. Serayamɛ takadakɛ̃ri ũ. ");
INSERT INTO bqp_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Yoyada nɛ́ Bɛnayamɛ dogarinↄ gbɛ̃ zↄ̃kↄ̃ ũ. Dauda zĩda nɛ́gↄ̃gbɛ̃nↄmɛ a kpàasinↄ ũ. ");
INSERT INTO bqp_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Dauda gbɛ̃nↄ là: Solu buri ke dí gↄ̃roo? Má ye mà gbɛ̃kɛ kɛnɛ Yonatã yãi. ");
INSERT INTO bqp_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Solu bɛ zĩkɛri ke kun, a tↄ́n Ziba, akũ ò a sìsi kína Daudanɛ. À a là à pì: Mↄkↄ̃mmɛ Ziba ũ yá? À wèa à pì: Ee, n zↄ̀bleriin ma ũ. ");
INSERT INTO bqp_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Akũ kína pì a là à pì: Solu buri ke kun ari tera yá? Má ye mà gbɛ̃kɛ kũ Luda vĩ kɛnɛmɛ. Akũ Ziba wèa à pì: Yonatã nɛ́ ke kun ari tera. Ɛrɛɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Akũ kína a là à pì: À kú mámɛɛ? Ziba wèa à pì: À kú Amiɛli nɛ́ Maki bɛa zaa Lodɛba. ");
INSERT INTO bqp_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Kína Dauda gbɛ̃nↄ zĩ̀, akũ ò sù kãao. ");
INSERT INTO bqp_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Kũ Yonatã nɛ́ Mɛfibosɛ, Solu daikore kà Dauda kĩnaa, à kùtɛnɛ à wùtɛ zĩtɛ. Akũ Dauda pì: Mɛfibosɛ! À wèa à pì: N zↄ̀bleriimɛ ma ũ. ");
INSERT INTO bqp_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Akũ Dauda pìnɛ: Ǹsun tó vĩna n kũro, zaakũ mani gbɛ̃kɛ kɛnnɛ n de Yonatã yãi. Mani n dizi Solu buranↄ sukpannɛ pínki, ĩnigↄ̃ su pↄ́ ble kũmao gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Mɛfibosɛ kùtɛnɛ à pì: Bↄ́n makũ n zↄ̀bleri ũ kũ ĩni ma wɛ̃nda gwaa? Má de lán gbɛ̃nda gɛ̀ɛ bàroo? ");
INSERT INTO bqp_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Akũ kína Dauda Solu zĩkɛri Ziba sìsi à pìnɛ: Pↄ́ kũ à de Solu pↄ́ ũ kũ a bedenↄ pↄ́o pínki, ma kpà n dikiri daikorea. ");
INSERT INTO bqp_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Mↄkↄ̃n kũ n nɛ́nↄ kũ n zĩkɛrinↄ, àgↄ̃ a zĩtɛ zĩ kɛnɛ, à a pↄ́nↄ kɛkɛ, de à le àgↄ̃ zàna vĩ. N dikiri daikore Mɛfibosɛ nigↄ̃ pↄ́ ble kũmao gↄrↄ sĩnda pínki. Ziba sↄ̃ à nɛ́gↄ̃gbɛ̃nↄ vĩ gbɛ̃nↄn gɛ̃ro kũ zĩkɛrinↄ gbɛ̃nↄn baro. ");
INSERT INTO bqp_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Akũ Ziba pì kínanɛ: Yã kũ ma dikiri kína ò makũ a zↄ̀bleriinɛ, mani kɛ pínkimɛ. Akũ Mɛfibosɛ dìgↄ̃ pↄ́ ble kũ kínao, à gↄ̃̀ lán kína nɛ́nↄ doke bà. ");
INSERT INTO bqp_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mɛfibosɛ nɛ́gↄ̃gbɛ̃ vĩ, a tↄ́n Mika, akũsↄ̃ Ziba bedenↄ gↄ̃̀ Mɛfibosɛ zĩkɛrinↄ ũ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","À kú Yurusalɛmu, zaakũ àdigↄ̃ pↄ́ ble kũ kínao gↄrↄ sĩnda pínkimɛ. Àkũsↄ̃ ɛrɛɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","Abire gbɛra Amↄni kína gà, akũ a nɛ́ Anuni vùtɛ a gɛ̃nɛ ũ. ");
INSERT INTO bqp_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","Dauda pì: Mani gbɛ̃kɛ kɛ Naasa nɛ́ Anuninɛ lákũ a de gbɛ̃kɛ kɛ̀mɛnɛ yã nà. Akũ Dauda a ìba kenↄ zĩ̀a, de ò gɛ́ Amↄninↄ bùsun ò a laakari kpátɛnɛ a de gana yã musu. Kũ Dauda ìbaa pìnↄ kà gwe, ");
INSERT INTO bqp_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","Amↄni kínɛnↄ pì ń dikiri Anuninɛ: Ntɛn da Dauda gbɛ̃nↄ zĩ̀mma n de gɛ̀ kpetana yãi de à n laakari kpátɛnnɛn yá? À ń zĩ de ò su ó wɛ̃tɛ asiri gwamɛ, de ò ɛra ò su ò wɛ̃tɛ ble kũ zĩ̀io. ");
INSERT INTO bqp_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","Akũ Anuni Dauda ìbaa pìnↄ kũ̀kũ à ń lɛ́kãsã kpadonↄ bò, à ń pↄ́kasanↄ zↄ̃̀zↄ̃ ń pↄ̀rↄnↄ dagura, akũ à ń gbárɛ. ");
INSERT INTO bqp_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","Kũ ò ò Daudanɛ, akũ à gbɛ̃nↄ zĩ̀ ò gɛ́ dańlɛ, zaakũ wé'i ń kũ manamana. Ò pìńnɛ: Kína pì, à vutɛ Yɛriko ari á lɛ́kãsã kã kú gbasa à su. ");
INSERT INTO bqp_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","Kũ Amↄninↄ è Dauda ye ń kãi doro, akũ ò fĩna bò gbɛ̃nↄnɛ de ò zĩ̀ káńnɛ: Siria kũ ò kú Bɛtɛreobu kũ Zobao kũ ò tɛ́ gɛ̀sɛnↄ gbɛ̃nↄn dúbu baro kũ kína Maaka zĩ̀karinↄ gbɛ̃nↄn wàa sↄↄro kũ Tobudenↄ gbɛ̃nↄn dúbu kuri awɛɛpla. ");
INSERT INTO bqp_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","Kũ Dauda a baaruu mà, akũ à Yoabu gbàrɛḿma kũ zĩ̀karinↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","Amↄninↄ bò ò zĩ̀'ↄ pòro ń wɛ̃tɛ bĩnilɛa, akũ Zoba kũ Bɛtɛreobuo Sirianↄ kũ Tobudenↄ kũ Maaka gbɛ̃nↄn kú sɛ̃̀n ńtɛ̃nɛ. ");
INSERT INTO bqp_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","Kũ Yoabu è ò zĩ̀'ↄ pòro a arɛ kũ a kpɛo, akũ à Isaraila zĩ̀kari mananↄ sɛ̀ à ń kpaatɛtɛ ò gɛ́ lɛ́tɛ Sirianↄa. ");
INSERT INTO bqp_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","Akũ à zĩ̀kari kparanↄ nà a dakũna Abisainɛ a ↄĩ, akũ à ń gbárɛ ò gɛ́ lɛ́tɛ Amↄninↄa. ");
INSERT INTO bqp_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","À pì: Tó Sirianↄ gbãna tɛni ma fu, ǹ mↄ́ ǹ ↄ dama. Tó Amↄninↄ gbãna tɛni n fumɛ sↄ̃, mani su mà ↄ damma. ");
INSERT INTO bqp_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","Ǹgↄ̃ gbãna, ò gↄ̃gbɛ̃kɛ kɛ ó gbɛ̃nↄ kũ ó Dikiri wɛ̃tɛnↄ yã musu. Dikiri ni yã kũ à kɛ̀arɛ mana kɛ. ");
INSERT INTO bqp_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","Akũ Yoabu kũ zĩ̀kari kũ ò kú kãaonↄ gɛ̀ɛ Sirianↄa kũ zĩ̀io, akũ Siria pìnↄ bàa lɛ̀ńnɛ. ");
INSERT INTO bqp_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","Kũ Amↄninↄ è Sirianↄ bàa lɛ̀, akũ ò bàa lɛ̀ Abisainɛ se ò sì wɛ̃tɛ gũn, akũ Yoabu ń tó gwe à tà Yurusalɛmu. ");
INSERT INTO bqp_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","Kũ Sirianↄ è Isarailanↄ zĩ̀i blèḿma, akũ ò ɛ̀ra ò kↄ̃ kàkara. ");
INSERT INTO bqp_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","Akũ Adadɛza gbɛ̃nↄ zĩ̀, ò sù kũ Siria kũ ò kú Yuflati bara direnↄ, akũ ò gɛ̀ɛ Elamu. Sobakimɛ Adadɛza zĩ̀karii pìnↄ gbɛ̃ zↄ̃kↄ̃ ũ. ");
INSERT INTO bqp_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","Kũ Dauda a baaruu mà, akũ à Isarailanↄ kàkara ń pínki, à bikũ̀ kũńwo Yodaa à gɛ̀ɛ Elamu. Akũ Sirianↄ zĩ̀'ↄ pòroi, akũ ò sì kↄ̃ tɛ́. ");
INSERT INTO bqp_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","Kũ òtɛn bàa lɛ́ Isarailanↄnɛ, akũ Dauda ń dɛdɛ sↄ̃godenↄ gbɛ̃nↄn wàa aakↄ̃ kpɛ́ basↄↄro kũ gbɛ̃ kũ ò tɛ́ gɛ̀sɛnↄ gbɛ̃nↄn dúbu bupla. Gwen ò ń zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ Sobaki dɛ̀n. ");
INSERT INTO bqp_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","Kũ kína kũ ò de Adadɛza zↄ̀blerinↄ ũ è Isarailanↄ zĩ̀i blèḿma lɛ, akũ ò lɛ́dokↄ̃nↄ kɛ̀ kũ Isarailanↄ ò gↄ̃̀ ń zↄ̀blerinↄ ũ. Vĩna Sirianↄ kũ̀, odi gɛ́ ò ↄ da Amↄninↄa doro. ");
INSERT INTO bqp_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Kũ í bò wɛ̀ɛn, gↄrↄ kũ kínanↄ dì gɛ́ zĩ̀ ká, akũ Dauda Yoabu zĩ̀ kũ a ìbanↄ kũ Isarailanↄ ń pínki. Ò Amↄninↄ ásaru kɛ̀, akũ ò lìka Rabai. Dauda sↄ̃ à kú Yurusalɛmu. ");
INSERT INTO bqp_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Kũ ↄkↄsi kɛ̀, akũ Dauda fùtɛ a gádoa, àtɛn lika a kpɛ́ musu. Zaa kpɛ́ musu gwe akũ à nↄgbɛ̃ ke è, àtɛn zú o. Nↄgbɛ̃ pì bi nↄ manamɛ manamana, ");
INSERT INTO bqp_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","akũ à gbɛ̃ zĩ̀ ò nↄgbɛ̃ pì yã gbɛka. Akũ ò pìnɛ: Ɛliamu nɛ́ Basɛban gwe, Iti buri Uria nanↄmɛ. ");
INSERT INTO bqp_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Akũ Dauda gbɛ̃nↄ zĩ̀ ò a sísi. Kũ à sù, akũ Dauda wùtɛ kãao, akũ nↄgbɛ̃ pìi tà bɛ. Àkũ sↄ̃, a okũna gbã̀a bò dufumɛ. ");
INSERT INTO bqp_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Kũ à nↄ̀ↄ sì, akũ à lɛ́gbãzã kɛ̀ Daudanɛ à pì a nↄ̀ↄ sì. ");
INSERT INTO bqp_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Akũ Dauda gbɛ̃ zĩ̀ Yoabua à pì: Ǹ Iti buri Uria gbarɛmɛnɛ. Akũ Yoabu a gbàrɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Kũ Uria pìi sù, akũ Dauda Yoabu aafia gbɛ̀ka kũ zĩ̀karinↄ kũ zĩ̀ kũ òtɛn káo. ");
INSERT INTO bqp_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Akũ Dauda pìnɛ: Ǹ tá bɛ ǹ zú o. Kũ Uria bò kínabɛa, akũ kína gbɛ̃ zĩ̀a kũ pↄ́bleo. ");
INSERT INTO bqp_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Ama Uria dí tá a bɛaro, kínabɛ gãnu gũnn à ìn kũ kínabɛ zĩkɛrinↄ. ");
INSERT INTO bqp_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Kũ ò ò Daudanɛ ò pì, Uria dí tá a bɛaro, akũ à Uria là à pì: À de n bo tái n sumɛ gwɛɛ? À kɛ̀ dera ńdi tá bɛroo? ");
INSERT INTO bqp_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uria wèa à pì: Àkpati kũ Isarailanↄ kũ Yudanↄn kú bizakutanↄ gũn. Ma dikiri Yoabu kũ a gbɛ̃nↄn kú zĩ̀lan. Mani fↄ̃ mà tá bɛ mà pↄ́ ble mà í mi, mà wútɛ kũ ma nanↄoro. Kũ n kunnaao mani yã pìi taka kɛro. ");
INSERT INTO bqp_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Akũ Dauda pìnɛ: Ǹ gↄ̃ la gbãra dↄ, zian mani n gbarɛ. Akũ Uria gↄ̃̀ Yurusalɛmu zĩ birea kũ a gu làa dↄnaao dↄ. ");
INSERT INTO bqp_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Dauda a sìsi à pↄ́ blè à í mì kãao, akũ Dauda í kàkanɛ. Ama kũ à bò ↄkↄsi, à gɛ̀ɛ à ì kũ a dikiri kína zĩkɛrinↄomɛ, adi tá a bɛaro. ");
INSERT INTO bqp_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Kũ gu dↄ̀ Dauda takada kɛ̃̀ Yoabunɛ, akũ à Uria gbàrɛo. ");
INSERT INTO bqp_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Takada pìi gũn à pì: À Uria dońnɛ arɛ gu kũ zĩ̀ pãsĩn, à bo a kpɛ de ò le ò a dɛ. ");
INSERT INTO bqp_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Gↄrↄ kũ Yoabu tɛn lika wɛ̃tɛ pìii, akũ à Uria dà gu kũ à dↄ̃ gↄ̃sa gbãnanↄn kún. ");
INSERT INTO bqp_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Kũ wɛ̃tɛdenↄ bↄ̀tɛ òtɛn zĩ̀ ká kũ Yoabuo, ò Dauda zĩ̀kari kenↄ dɛ̀dɛ. Iti buri Uria kú ń tɛ́. ");
INSERT INTO bqp_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Akũ Yoabu gbɛ̃ zĩ̀ Daudaa de à zĩ̀ yã gbãnɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","À pì zĩ̀rii pìinɛ: Tó n zĩ̀ yã gbã̀ kínanɛ pínki n laka, ");
INSERT INTO bqp_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","tó a nɛ̀sɛɛ fùtɛ à n la à pì: Bↄ́ mɛ́ à tò a na wɛ̃tɛi kãnikãni kũ zĩ̀ioo? Á dↄ̃ kũ bĩnimusudenↄ dì kà gbarɛńyĩ zĩtɛroo? ");
INSERT INTO bqp_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Dí mɛ́ à Gidiↄn nɛ́ Abimɛlɛki dɛ̀ɛ? Nↄgbɛ̃ mɛ́ à ↄ sↄ̃̀ wísilↄgbɛɛi zaa bĩni musu, akũ à a dɛ̀ Tebeziroo? À kɛ̀ dera a na bĩnii kãnikãni lɛɛ? Tó à ònnɛ lɛ, ǹ onɛ a zↄ̀bleri Uria, Iti buri gà dↄ. ");
INSERT INTO bqp_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Akũ zĩ̀rii pìi dà zɛ́n. Kũ à kà Dauda kĩnaa, à yã kũ Yoabu dàarɛ ònɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","À pì: Gbɛ̃nↄ bↄ̀tɛ wɛ̃tɛ gũn òtɛn gbãna mↄwɛrɛ bĩni kpɛmɛ, akũ o pɛḿma ari ń wɛ̃tɛ bĩnilɛa. ");
INSERT INTO bqp_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Ń kàzurinↄn kú zaa bĩni musu, akũ ò kà fã̀ n gbɛ̃nↄ tɛ́ zĩtɛ ò n gbɛ̃kenↄ dɛ̀dɛ. N zↄ̀bleri Uria, Iti buri gà dↄ. ");
INSERT INTO bqp_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Akũ Dauda ò zĩ̀rii pìinɛ: Ǹ o Yoabunɛ àsun tó yã pì kɛnɛ ĩniro. Òdigↄ̃ dↄ̃ gbɛ̃ kũ zĩ̀ ni ń blero. À zĩ̀ ká kũ wɛ̃tɛpidenↄ kũ gbãnao à wɛ̃tɛ pì kakatɛ. Ǹ a gba swɛ̃̀ lɛ. ");
INSERT INTO bqp_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Kũ Uria nanↄ mà a zã gà, à ↄ́ↄ dↄ̀. ");
INSERT INTO bqp_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Kũ ò gɛ̀ɛ kɛ̀ ò làka, Dauda gbɛ̃nↄ zĩ̀ ò sù kãao a bɛa, akũ à gↄ̃̀ a nↄ ũ. À nɛ́ ì kãao gↄ̃gbɛ̃ ũ, akũ yã kũ Dauda kɛ̀ɛ pìi kɛ̀ Dikirinɛ ĩni. ");
INSERT INTO bqp_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Dikiri Natã zĩ̀ Daudaa. Kũ à kà, à pìnɛ: Gↄ̃gbɛ̃ gbɛ̃nↄn pla kenↄ mɛ́ ò kú wɛ̃tɛ ke gũn, gbɛ̃ do bi aruzɛkɛdemɛ, gbɛ̃ do sↄ̃ takasidemɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Aruzɛkɛde pì sãnↄ kũ zùnↄ vĩ dasidasi, ");
INSERT INTO bqp_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","takaside pì sↄ̃ à pↄ́ke vĩro, sã núnu fítinna mɛ̀n doken à lù. Akũ à dàto ari à zↄ̃kↄ̃ kũ̀ a bɛa kũ a nɛ́nↄ. Òdigↄ̃ pↄ́ dokↄ̃nↄ ble òdigↄ̃ í mi ta dokↄ̃nↄn, àdi wùtɛ a pↄtɛ, akũ àtɛni a gwa lán a zĩda nɛ́nↄkpare bà. ");
INSERT INTO bqp_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Kũ nibↄↄ kìpa aruzɛkɛde pìia, akũ adi we à sã ke zùu kũ̀ a kpàsaa gũn à nibↄↄ pìi yàri kɛoro. Takaside sã núnu fítinna pìin à sìa à a nibↄↄ pìi yàrii kɛ̀o. ");
INSERT INTO bqp_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Akũ Dauda pↄ fɛ̃̀ aruzɛkɛde pì yã musu manamana, à pì Natãnɛ: Dikiri kun! À kũ̀ ò gbɛ̃ kũ à yã pìi kɛ̀ dɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Lákũ à kɛ̀ lɛ nà, adi a wɛ̃nda gwaro, ani sã pì fĩna bo lɛu siikↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Akũ Natã pì Daudanɛ: Mↄkↄ̃mmɛ ade pì ũ. Dikiri Isarailanↄ Luda mɛ́ à yã dí ò à pì: Ma n ka Isarailanↄ kína ũ, ma n bo Solu ↄĩ, ");
INSERT INTO bqp_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","akũ ma n dikirii pì bɛ kpàmma, ma a nↄnↄ nànnɛ n ↄĩ. Ma Isarailanↄ kũ Yudanↄ kpàmma n gbɛ̃nↄ ũ. Tó adinↄ kɛ̀mma fíti yã, de mà a pãndenↄ karannɛ dↄ. ");
INSERT INTO bqp_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Bↄ́yãi n ma yã gya bòo? N yã kũ má yeiro kɛ̀, n Iti buri Uria dɛ̀ kũ fɛ̃nɛdao, n a nↄ sìa n sɛ̀. N tò Amↄninↄ a dɛ̀ zĩ̀i gũn. ");
INSERT INTO bqp_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Zaa gbãra yã pãsĩ ni kɛ̃ n bɛa ziki doro, zaakũ n ma gya bò, n Iti buri Uria nↄ sìa n sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Akũ Dikiri ɛ̀ra à yã dí ò dↄ à pì: Ǹ ma! Mani tó n zĩda bedenↄ sunyĩ kɛnnɛ. Mani n nↄnↄ símma mà ń kpá n gbɛ̃dake kea n wára, ani wútɛ kũńwo gupuraa. ");
INSERT INTO bqp_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","N yã pìi kɛ̀ asiri gũmmɛ. Makũ sↄ̃ mani yã pì kɛnnɛ gupuraa Isarailanↄ wára ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Akũ Dauda pì Natãnɛ: Ma durunna kɛ̀ Dikirinɛ. Akũ Natã pìnɛ: Dikiri n durunna kɛ̃̀mma, ĩni garo. ");
INSERT INTO bqp_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Ama lákũ n dↄkɛ kũ Dikirio manamana nà yã pì kɛnaa musu, nɛ́gↄ̃gbɛ̃ kũ nↄgbɛ̃ pìi ì kũnwo ni gamɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Kũ Natã tà bɛ, akũ Dikiri tò nɛ́ kũ Uria nanↄ ì kũ Daudao pì gyã kũ̀. ");
INSERT INTO bqp_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Akũ Dauda tɛn Luda wɛ́ kɛ nɛ́ pì yã musu kũ lɛ́yĩnaao, gwãani àdigↄ̃ wútɛ zĩtɛmɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","A bɛ gbɛ̃ zↄ̃kↄ̃nↄ dìgↄ̃ zɛala de ò a futɛ zĩtɛ, ama àdi wero, àdi pↄ́ ble kũńworo. ");
INSERT INTO bqp_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","A gↄrↄ supplade zĩn nɛ́ pìi gà. Vĩna Dauda ìbanↄ kũ̀, odi fↄ̃ ò ònɛ kũ nɛ́ pìi gàro. Ò pì: Gↄrↄ kũ nɛ́ pì kun, o yã ònɛ, adi ó yã maro. Deran óni onɛ nà sà kũ nɛ́ pìi gàa? Ani yã vãni kɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Dauda è a ìbanↄ tɛn yã kpãni okↄ̃nɛ, akũ à dↄ̃̀ kũ nɛ́ pìi gàmɛ. À ń lá à pì: Nɛ́ pìi gàn yá? Akũ ò wèa ò pì: Ee! À gàmɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Dauda fùtɛ zĩtɛ à zú ò, à nísi dↄ̀kↄ à a pↄ́kasanↄ lìtɛ, akũ à gɛ̀ɛ à kùtɛ Dikirinɛ a kpɛ́n. Kũ à ɛ̀ra à tà bɛ, à pↄ́ble gbɛ̀ka, akũ ò kpàa à blè. ");
INSERT INTO bqp_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","A ìbanↄ a là ò pì: À kɛ̀ dera ntɛn yã kɛ lɛɛ? Gↄrↄ kũ nɛ́ pì kun, n lɛ́ yĩ̀ n ↄ́ↄ dↄ̀. Kũ à gà sà, n futɛ n pↄ́ blè. ");
INSERT INTO bqp_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","À wèḿma à pì: Gↄrↄ kũ nɛ́ pì kun, ma lɛ́ yĩ̀ ma ↄ́ↄ dↄ̀, zaakũ ma pì, ke Dikiri ni ma wɛ̃nda gwa à tó nɛ́ pì gↄ̃ kun gwɛɛ, dí mɛ́ à dↄ̃ↄ? ");
INSERT INTO bqp_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Lán à gà nà sà, bↄ́yãin manigↄ̃ lɛ́yĩna dↄↄ? Mani fↄ̃ mà a vun yá? Mani gɛ́ a kĩnaa, ama ani ɛra à su ma kĩnaaro. ");
INSERT INTO bqp_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Dauda a nanↄ Basɛba laakarii kpàtɛnɛ, akũ à gɛ̀ɛ à wùtɛ kãao. À nɛ́ ì gↄ̃gbɛ̃ ũ, akũ à tↄ́ kpànɛ Sulemanu. Dikiri yei, ");
INSERT INTO bqp_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","akũ à annabi Natã zĩ̀a à tↄ́ kpà nɛ́ pìinɛ Yɛdidaya Dikiri yenyĩ pì yãi. ");
INSERT INTO bqp_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","Ari tera Yoabu kpɛ́ àtɛn zĩ̀ ká kũ Amↄninↄ zaa Raba, akũ à kínabɛ sì. ");
INSERT INTO bqp_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","Akũ à gbɛ̃nↄ zĩ̀ Daudaa à pì: Ma zĩ̀i kà kũ Rabadenↄ, akũ ma ń ítↄki sì. ");
INSERT INTO bqp_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","Ǹ zĩ̀kari kparanↄ kakara sà, ǹ mↄ́ ǹ lika wɛ̃tɛ pìii ǹ sí. Tó lɛnlo, mani sí, oni ma tↄ́ kpánɛ. ");
INSERT INTO bqp_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","Akũ Dauda zĩ̀karinↄ kàkara ń pínki, à gɛ̀ɛ à lɛ̀tɛ Rabaa à sì. ");
INSERT INTO bqp_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","Ò ń kína wura fùraa gò a mìia ò kù Daudanɛ. A tìkisi kà kiloo baraakuri, akũsↄ̃ gbɛ̀ bɛ̀ɛrɛde kúa. À wɛ̃tɛ pì pↄ́nↄ nàkↄ̃a manamana, ");
INSERT INTO bqp_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","akũ à gbɛ̃ kũ ò kú gwenↄ kũ̀kũ à bↄ̀tɛ kũńwo, à ń dá sàkasaka zĩn kũ diga zĩo kũ kpása zĩo, akũsↄ̃ à tò ò kúnku bò. Lɛn à kɛ̀ Amↄni wɛ̃tɛnↄnɛ lɛ pínki, akũ à ɛ̀ra à tà Yurusalɛmu kũ a zĩ̀karinↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","Abire gbɛra Dauda nɛ́ Abusalomu dãre mana vĩ, a tↄ́n Tama, akũ Dauda nɛ́ Aminↄ yei. ");
INSERT INTO bqp_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","Yã pì tɛn wari dↄ Aminↄ pìia ari à kà gyãkɛna a dãre Tama pì yãi, zaakũ à gↄ̃gbɛ̃ dↄ̃ro, ani fↄ̃ à yãke kɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","Aminↄ gbɛ̃nna ke vĩ, a tↄ́n Yonadabu, Dauda vĩ̀ni Simɛa nɛ́mɛ. Yonadabu ↄ̃ndↄ̃ gbãna, ");
INSERT INTO bqp_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","akũ à Aminↄ là à pì: À kɛ̀ dera n kínɛ'ina n mɛ̀ɛ dìgↄ̃ yↄna lákũ gu dìgↄ̃ dↄ nà lɛɛ? Ĩni omɛnɛroo? Akũ Aminↄ wèa à pì: Má ye ma dakũna Abusalomu dãre Tamaimɛ. ");
INSERT INTO bqp_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","Akũ Yonadabu pìnɛ: Ǹ gɛ́ ǹ wútɛ n gádoa lákũ gyãren n ũ bà. Tó n de sù n gwa, ǹ onɛ ń ye n dãre Tama su à pↄ́ble kpámma. À su à kɛkɛ n wára de ǹgↄ̃ e, gbasa à nannɛ n ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","Akũ Aminↄ wùtɛ lán gyãre bà. Kũ kína sù a gwa, akũ à pìnɛ: Ǹ tó ma dãre Tama su à kàra kɛmɛnɛ ma wára, à namɛnɛ ma ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","Akũ Dauda gbɛ̃ zĩ̀ Tamaa a bɛa à pì: Ǹ gɛ́ n vĩ̀ni Aminↄ kpɛ́n ǹ pↄ́ble kɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","Kũ Tama gɛ̃̀ a kpɛ́n, à a lè wutɛna, akũ à wísiti yà à kàraa kàsao a wára. ");
INSERT INTO bqp_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","Akũ à ta sɛ̀ à kàraa pìi kànnɛ. Aminↄ gì sói à pì: Ǹ pɛ́ gbɛ̃nↄa ò bↄtɛ ń pínki. Kũ gbɛ̃ kũ ò kú kãaonↄ bↄ̀tɛ ń pínki, ");
INSERT INTO bqp_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","akũ à pì Tamanɛ: Ǹ su kũ pↄ́ble pìio kpɛ́nɛ gũn la ǹ namɛnɛ ma ↄ̃i. Akũ Tama kàra kũ à kɛ̀ɛ sɛ̀ à gɛ̃̀o a vĩ̀ni Aminↄ pì kĩnaa kpɛ́nɛ gũn. ");
INSERT INTO bqp_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","Kũ à nài, àtɛn su kpáa à só, akũ à a dãre pìi kũ̀ à pì: Ǹ tó mà wútɛ kũnwo. ");
INSERT INTO bqp_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","Akũ à pì a vĩ̀ni pìinɛ: Oi! Ǹsun gbãna mↄmɛnɛro. Zaakũ ó Isarailanↄ odì yã dí taka kɛro. Ǹsun yã dↄ̀rↄsari bire taka kɛmɛnɛro. ");
INSERT INTO bqp_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","Makũ, mán mani gɛ̃n kũ wé'iyã dioo? Mↄkↄ̃n sↄ̃, Isarailanↄ ni n ditɛ gbɛ̃ pã ũ. Ǹ sùru kɛ! Ǹ a yã o kínanɛ, ani gí ma kpámmairo. ");
INSERT INTO bqp_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","Adi we à a yã màro. À gbãna mↄ̀nɛ, akũ à kùsia à wùtɛ kãao. ");
INSERT INTO bqp_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","Akũ Aminↄ zã̀agu pãsĩpãsĩ. Zãngu kũ à sɛ̀ kũ Tama pìio de yenyĩ kũ à vĩ kãao yãla. Akũ à pìnɛ: Ǹ futɛ ǹ bo. ");
INSERT INTO bqp_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","Akũ nↄgbɛ̃ pìi pì a vĩ̀ni pìinɛ: Oi! N pɛnama taari zↄ̃kↄ̃ de pↄ́ kũ n kɛ̀mɛnɛla. Kũ abireo adi we à a yã màro. ");
INSERT INTO bqp_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","Akũ Aminↄ a zĩkɛri kɛfɛnna sìsi à pì: Ǹ pɛ́ nↄgbɛ̃ díkĩnaa à bomɛnɛ ma kpɛ́n, ǹ gbà ta ǹ a mↄ̀nɛ dan. ");
INSERT INTO bqp_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","Akũ a zĩkɛrii pì a sɛ̀ à bò kãao bàai, à gbàa tà à a mↄ̀nɛ dàn. Nↄgbɛ̃ pìi uta gbã̀na dana, zaakũ uta bire takan kína nɛ́nↄkpare lésinↄ dìgↄ̃ dana. ");
INSERT INTO bqp_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","Akũ Tama túbu gbɛ̃̀ a mìia, à a uta gbã̀na kũ à danaa pìi gà à kɛ̃̀ à ↄ dì a musu, àtɛn ↄ́ↄ dↄ àtɛn tá. ");
INSERT INTO bqp_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","A dãgↄ̃ dadokↄ̃nↄde Abusalomu pìnɛ: N dãgↄ̃ Aminↄ wùtɛ kũnwon yá? Ǹsun o gbɛ̃ke maro, zaakũ n dãgↄ̃mɛ. Ǹsungↄ̃ yã pì kũna n swɛ̃̀ɛ gũnlo. Akũ Tama vùtɛ a dãgↄ̃ Abusalomu bɛa kũ pↄyakao. ");
INSERT INTO bqp_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","Kũ kína Dauda yã pìi mà, a pↄ fɛ̃̀ manamana. ");
INSERT INTO bqp_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","Abusalomu dí yãke o Aminↄnɛro, yã vãni ke a mana. A zã̀agu, kũ à kùsi a dãre Tamaa yãi. ");
INSERT INTO bqp_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","Wɛ̃̀ pla gbɛra Abusalomu kú Baali Azo, Ɛflaimu bùsu lɛ́n kũ a sãkãkɛ̃rɛrinↄ, akũ à kína nɛ́nↄ sìsi pↄnna pↄ́blea ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","Akũ à gɛ̀ɛ à kína lè à pì: Kína, òtɛni makũ n zↄ̀bleri sãnↄ kã zↄ̃zↄ̃. Mↄkↄ̃n kũ n ìbanↄ áni gɛ́ kũmaoroo? ");
INSERT INTO bqp_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","Akũ kína wè a nɛ́ pìia à pì: Oi! Óni fↄ̃ ò gɛ́ ó pínkiro. Óni kɛnnɛ aso ũ. À nàkara kãao, ama adi gɛ́ro, akũ à sa mana ònɛ. ");
INSERT INTO bqp_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","Akũ Abusalomu pì: Tó ĩni gɛ́ro, ǹ tó ma vĩ̀ni Aminↄ gɛ́ kũoo. Kína a là à pì: Bↄ́yãi ń ye à gɛ́ kũnwoo? ");
INSERT INTO bqp_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","Abusalomu nàkara kãao, akũ kína tò Aminↄ gɛ̀ɛ kãao kũ a nɛ́ kparanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","Abusalomu yã dìtɛ a gbɛ̃nↄnɛ à pì: À sã kpá! Tó í Aminↄ kũ̀, tó ma òárɛ à a zↄ̃, à a dɛ. Àsun tó vĩna á kũro. Makũ mɛ́ ma á dán! À zɛ gbãna à gↄ̃gbɛ̃kɛ kɛ. ");
INSERT INTO bqp_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","Abusalomu gbɛ̃nↄ kɛ̀ lákũ à òńnɛ nà ò a dɛ̀, akũ kína nɛ́ kparanↄ fùtɛ ò dì ń baragbãsↄ̃nↄ kpɛ ò bàa lɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","Gↄrↄ kũ ò kú zɛ́n, Dauda a baaruu mà ò pì: Abusalomu kína nɛ́nↄ dɛ̀dɛ ń pínki, ń gbɛ̃ke dí gↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","Dauda fùtɛ à a pↄ́kasanↄ gà à kɛ̃̀, akũ à wùtɛ zĩtɛ. A ìbanↄ zɛi kũ ń pↄ́kasanↄ kɛ̃kɛ̃na. ");
INSERT INTO bqp_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","Akũ Dauda vĩ̀ni Simɛa nɛ́ Yonadabu pì: Baa, ǹsungↄ̃ da ò n nɛ́ kɛfɛnnanↄ dɛ̀dɛ ń pínkiro, Aminↄ mɛ́ à gà ado. Ò yã pìi dↄ̃̀ Abusalomu wɛ́a zaa gↄrↄ kũ Aminↄ kùsi a dãre Tamaamɛ. ");
INSERT INTO bqp_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","Ma dikiri kína, ǹsungↄ̃ yã pì kũna n nɛ̀sɛɛ gũnlo. N nɛ́gↄ̃gbɛ̃nↄ dí gaga ń pínkiro, séde Aminↄ ado. ");
INSERT INTO bqp_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","Abusalomu sↄ̃ à bàa lɛ̀. Kũ kɛfɛnna gudãkpãri wɛ́ zù, à è ò tɛ́ Oronaimu zɛ́n sĩ̀sĩgɛrɛɛi dasidasi. À gɛ̀ɛ à pì kínanɛ: Ma gbɛ̃nↄ è tɛ́ sĩ̀sĩgɛrɛɛi Oronaimu kpa. ");
INSERT INTO bqp_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","Akũ Yonadabu pì kínanɛ: N è yá? N nɛ́nↄ mɛ́ òtɛn su gwe lákũ ma ònnɛ nà. ");
INSERT INTO bqp_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","Kũ à yã pìi ò à làka, akũ kína nɛ́ pìnↄ kà gↄ̃̀nↄ, òtɛn wɛ̃nda ↄ́ↄ dↄ. Kína kũ a ìbanↄ ↄ́ↄ dↄ̀ ń pínki manamana dↄ. ");
INSERT INTO bqp_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","Abusalomu bàa lɛ̀ à tà Amiudu nɛ́ Talamai, Gesuru kína kĩnaa. Kína Dauda sↄ̃ àdigↄ̃ a nɛ́ gana ↄ́ↄ dↄ gↄrↄ sĩnda pínki. ");
INSERT INTO bqp_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","Kũ Abusalomu bàa lɛ̀ à tà Gesuru, à kú gwe ari wɛ̃̀ aakↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","Kũ kína Dauda nɛ̀sɛɛ kpàtɛ Aminↄ gana yã musu, akũ àtɛn Abusalomu bɛgɛ kɛ sà. ");
INSERT INTO bqp_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Zeruya nɛ́ Yoabu dↄ̃ kũ kína pↄ kpɛ́ kú Abusalomua, ");
INSERT INTO bqp_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","akũ à gbɛ̃nↄ zĩ̀ Tɛkoa, ò nↄgbɛ̃ ↄ̃ndↄ̃de ke sɛ̀ ò sù kãao. Akũ à pìnɛ: Ǹ kɛ lándↄ̃ ntɛn wɛ̃nda kɛ bà. Ǹ gyaanↄ pↄ́kasanↄ da. Ǹsun nísi dↄkↄro. Ǹ kɛ lákũ nↄgbɛ̃ kũ a gbɛ̃ gà àtɛni a ↄ́ↄ dↄ à gìi kɛ̀ bà. ");
INSERT INTO bqp_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","Ǹ gɛ́ kína kĩnaa lɛ, ǹ yã díkĩna onɛ. Akũ Yoabu yã kàka nↄgbɛ̃ pìinɛ. ");
INSERT INTO bqp_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","Kũ Tɛkoa nↄgbɛ̃ pìi gɛ̀ɛ à kína lè, à kùtɛnɛ kũ à mìio zĩtɛ à pì: Kína, ǹ ma mì sí! ");
INSERT INTO bqp_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","Akũ kína pì a là à pì: Bↄ́n ń yeii? À wèa à pì: Gyaanↄn ma ũ, ma zã gà. ");
INSERT INTO bqp_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","Makũ n zↄ̀bleri, má nɛ́gↄ̃gbɛ̃nↄ vĩ gbɛ̃nↄn pla. Kũ òtɛn fìti kɛ ń kↄ̃ tɛ̃nɛ bura, gbɛ̃ke kun à ń kpaatɛro. Akũ gbɛ̃ do a gbɛ̃ do lɛ̀ à dɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","Akũ ma bedenↄ fùtɛ ń pínki, ò pì makũ n zↄ̀bleriinɛ mà a nɛ́ kũ à a gbɛ̃ndo dɛ̀ɛ pì kpáḿma ò dɛ, kũ à a gbɛ̃ndo dɛ̀ yãi. Ò ye ò yàka mì'oro tɛ́de kũ à gↄ̃̀mɛnɛ túbibleri ũ pì tɛ́ dɛmɛ, de ma zã súngↄ̃ tↄ́ ke buri vĩ andunia gũn doro yãi. ");
INSERT INTO bqp_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","Akũ kína pì nↄgbɛ̃ pìinɛ: Ǹ tá bɛ, mani yã gwa n yã pìi musu. ");
INSERT INTO bqp_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","Akũ Tɛkoa nↄgbɛ̃ pìi pì: Ma dikiri kína, taari pì wí ma musu kũ ma de bedenↄ, mↄkↄ̃n ǹgↄ̃ kun taari sari kũ n kíkɛo. ");
INSERT INTO bqp_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","Akũ kína pì: Tó gbɛ̃ke lɛ́ pà yã pìia, ǹ mↄ́ kãao ma kĩnaa la, ani le à wari dↄmma doro. ");
INSERT INTO bqp_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","Akũ nↄgbɛ̃ pìi pì: Kína, ǹ sì kũ Dikiri n Ludao, de mↄrakari sún ma nɛ́ mɛ̀n do kũ à gↄ̃̀ lakiti kɛro yãi. Akũ kína pìi pì: Kũ Dikirio n nɛ́ pìi mìkã ke ni lɛ́tɛ zĩtɛro. ");
INSERT INTO bqp_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","Akũ nↄgbɛ̃ pìi pì: Ma dikiri kína, makũ n zↄ̀bleri ǹ ma gba zɛ́ mà ɛra mà yã onnɛ. À wèa à pì: Ǹ o! ");
INSERT INTO bqp_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","Akũ à pìnɛ: Bↄ́yãi n yã dí taka kpàkũsũ kũ Luda gbɛ̃nↄↄ? Yã kũ n òmɛnɛ mɛ́ à n da yãn, zaakũ ńdi gbɛ̃ kũ n pɛaa gbɛsɛ n su kãaoro. ");
INSERT INTO bqp_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","Ó pínki óni ga, ónigↄ̃ de lán í kũ à kↄ̀tɛ zĩtɛ gbɛ̃ke dí le à sɛ̀tɛ doro bà. Luda dì gbɛ̃ kũ ò pɛ̀aa wɛ̃̀ndi boro, àdi zɛ́ wɛtɛ ade ɛra à suawamɛ. ");
INSERT INTO bqp_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","Ma su yã pì o ma dikiri kínanɛmɛ, zaakũ gbɛ̃nↄ tò vĩna ma kũ. Akũ makũ n zↄ̀bleri ma pì mani yã pì onnɛ. Òdigↄ̃ dↄ̃ro ke ĩni ma wɛ́kɛna sí ");
INSERT INTO bqp_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","ǹ ma bo gbɛ̃ kũ à ye à makũ kũ ma nɛ́o zĩtɛ kũ Luda tòwɛrɛ sí ó ↄĩ. ");
INSERT INTO bqp_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","Ma dikiri kína, makũ n zↄ̀bleri ma pì n yã ni tó ma laakari kpátɛ, zaakũ ń de lán Luda malaikaa bàmɛ, ndì sã kpá yã mana kũ a vãniooi pínki. Dikiri n Luda gↄ̃ kú kũnwo. ");
INSERT INTO bqp_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","Akũ kína pìnɛ: Ǹsun gí yã kũ matɛni n la onaairo. Akũ nↄgbɛ̃ pìi pì: Ǹ o ma dikiri kína! ");
INSERT INTO bqp_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","Akũ kína a là à pì: Yoabu lɛ́ kú yã pìi gũn yá? Nↄgbɛ̃ pìi wèa à pì: Ma dikiri kína, kũ n kunnaao yã kũ n òo pì gɛna arɛ kũ kpɛo vĩro. Ee, n zↄ̀bleri Yoabu mɛ́ à yã pìi kàkamɛnɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","N zↄ̀bleri Yoabu kɛ̀ lɛ, de à le à yã kũ à lokona tera díkũ kɛkɛ yãimɛ. Ma dikiri, ń ↄ̃ndↄ̃ lán Luda malaikaa bàmɛ, ń yã kũ à kɛ̀ andunia gũn dↄ̃ pínki. ");
INSERT INTO bqp_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Akũ kína gɛ̀ɛ à ò Yoabunɛ: Tↄ̀, mani yã pì kɛ sà. Ǹ gɛ́ ǹ kɛfɛnna Abusalomu gbɛsɛ ǹ su kãao. ");
INSERT INTO bqp_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Akũ Yoabu kùtɛ kínanɛ kũ à mìio, à a sáabu kpà à pì: Ma dikiri kína, makũ n zↄ̀bleri, ma dↄ̃̀ gbãra sà kũ ma yã kàngu, zaakũ n ma yã mà. ");
INSERT INTO bqp_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Akũ Yoabu fùtɛ à gɛ̀ɛ à Abusalomu gbɛ̀sɛ zaa Gesuru à sù kãao Yurusalɛmu. ");
INSERT INTO bqp_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Akũ kína pì: Ǹ onɛ à gɛ́ vutɛ a zĩda bɛa, ó wɛ́ ni kɛ siikↄ̃ro. Akũ Abusalomu gɛ̀ɛ à vùtɛ a bɛa, odi wɛ́ sikↄ̃lɛ kũ kínaoro. ");
INSERT INTO bqp_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Gↄ̃ mana ke kú Isarailanↄ tɛ́ lán Abusalomu bàro. Òdigↄ̃ a manakɛ yã o manamana. Sɛna zaa a gɛ̀sɛɛa ari à gɛ̀ɛ pɛ́ a mìdangura mamberu ke kúaro. ");
INSERT INTO bqp_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Àdigↄ̃ a mì bo wɛ̃̀ kũ wɛ̃̀ɛomɛ. Àdi kɛa tìkisi. Tó à bò, àdi yↄ̃ kilooa, a tìkisii dìgↄ̃ de kiloo plala. ");
INSERT INTO bqp_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","À nɛ́gↄ̃gbɛ̃nↄ ì gbɛ̃nↄn aakↄ̃ kũ nɛ́nↄgbɛ̃o mɛ̀n do. Nɛ́nↄgbɛ̃ pì tↄ́n Tama. Nↄ manamɛ. ");
INSERT INTO bqp_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Abusalomu kú Yurusalɛmu ari wɛ̃̀ pla wɛ́sina kínalɛ sari. ");
INSERT INTO bqp_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Akũ à Yoabu sìsi à gɛ́arɛ kína kĩnaa, ama Yoabu dí we à sù a kĩnaaro. Akũ à ɛ̀ra à a sìsi dↄ, adi we à sùro. ");
INSERT INTO bqp_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Akũ à pì a zĩkɛrinↄnɛ: À Yoabu bura kũ à kú ma pↄ́ sarɛ gwa, a nagã mà. À gɛ́ à tɛ́ sↄ̃a. Akũ Abusalomu zĩkɛrinↄ gɛ̀ɛ ò tɛ́ sↄ̃̀ Yoabu bura pìia. ");
INSERT INTO bqp_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Akũ Yoabu fùtɛ à gɛ̀ɛ Abusalomu bɛa, à a là à pì: Bↄ́yãi n zĩkɛrinↄ tɛ́ sↄ̃̀ ma buraaa? ");
INSERT INTO bqp_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Akũ Abusalomu wèa à pì: Ǹ gwa, ma gbɛ̃ zĩ̀mma ma pì ǹ mↄ́ mà n zĩ kínaa, de ǹ a la bↄ́ mɛ́ à tò à ma gbɛsɛ zaa Gesuru à sù kũmaoo? Ma kunna gwe sã̀namɛnɛ de gu díla! Má ye mà kↄ̃ e kũ kínao tera. Tó má taari ke vĩ, à ma dɛ. ");
INSERT INTO bqp_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Akũ Yoabu gɛ̀ɛ à yã pìi ò kínanɛ. Akũ kína Abusalomu sìsi. Kũ à sù, à kùtɛnɛ kũ a mìio zĩtɛ. Akũ kína lɛ́ pɛ̀a. ");
INSERT INTO bqp_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Abire gbɛra Abusalomu sↄ̃go lè a zĩdanɛ kũ sↄ̃nↄ kũ gↄ̃gbɛ̃nↄ gbɛ̃nↄn bupla akuri kũ onigↄ̃ bàa lɛ́ a arɛnↄ. ");
INSERT INTO bqp_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Àdi futɛ kↄnkↄkↄnkↄ àgↄ̃ zɛna bĩnilɛ sarɛ. Tó gbɛ̃ yã vĩ kũ a gbɛ̃dakeo àtɛn gɛ́o kína kĩnaa à kɛkɛnɛ, Abusalomu dì ade sísi à pinɛ: Wɛ̃tɛ kpaten n bonn? Tó à wèa à pì: Makũ n zↄ̀bleri ma bo Isaraila buri dí gũmmɛ, ");
INSERT INTO bqp_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","akũ Abusalomu dì pinɛ: N yã nnamɛ, à zɛ́ vĩ, ama kína gbɛ̃ke kun à sã kpá n yãiro. ");
INSERT INTO bqp_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Abusalomu dì ɛra à pi: Tó ò ma kɛ yãkpatɛkɛri ũ ó bùsun, gbɛ̃ kũ à yã vĩ ke gbɛ̃ kũ àtɛn gbɛ̃ gbɛka yãkpatɛkɛkia ń pínki anigↄ̃ su ma kĩnaa, manigↄ̃ a yã kɛkɛnɛ a zɛ́a. ");
INSERT INTO bqp_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Tó gbɛ̃ sù à kùtɛ a arɛ, àdi ↄ bo à ade kũ à lɛ́ pɛ́a. ");
INSERT INTO bqp_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Lɛn àdigↄ̃ kɛ lɛ Isaraila kũ òtɛn su yãkpatɛ kɛ kína kĩnaanↄnɛ ń pínki, akũ ń swɛ̃̀ɛ tà a kpa. ");
INSERT INTO bqp_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Wɛ̃̀ siikↄ̃ gbɛra à pì kínanɛ: Ǹ ma gba zɛ́ mà gɛ́ la kũ ma dà Dikirinɛ sa o zaa Ɛblↄnu. ");
INSERT INTO bqp_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Makũ n zↄ̀bleri ma lɛ́ pìi gbɛ̃̀nɛ gↄrↄ kũ má kú Gesuru, Siria bùsun ma pì: Tó Dikiri tò ma su Yurusalɛmu, mani sa oa Ɛblↄnumɛ. ");
INSERT INTO bqp_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Kína pìnɛ: Ǹ gɛ́ ǹ su aafia! Akũ à fùtɛ à gɛ̀ɛ Ɛblↄnu. ");
INSERT INTO bqp_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","À gbɛ̃nↄ zĩ̀ Isaraila burinↄ kĩnaa pínki à pì: Tó a kuru'ũ mà dↄ, à pi Abusalomu mɛ́ à kí blè Ɛblↄnu. ");
INSERT INTO bqp_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","Gↄrↄ kũ àtɛn futɛ Yurusalɛmu à gbɛ̃nↄ sìsi gbɛ̃nↄn wàa do ò gɛ́ kãáo, akũ ò gɛ̀ɛ kũ nɛ̀sɛ mɛ̀n doo, ò yã pìi asiri dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Gↄrↄ kũ àtɛn sa o, à Gilo gbɛ̃ Aitofɛli, Dauda lɛ́dammarii sìsi zaa a bɛ wɛ̃tɛn, akũ lɛ́kpakũsũna Daudai tɛn kara. Gbɛ̃ kũ ò kú kũ Abusalomuonↄ dasi tɛn kara. ");
INSERT INTO bqp_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Baarukparii sù à pì Daudanɛ: Isarailanↄ swɛ̃̀ɛ tà Abusalomua. ");
INSERT INTO bqp_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Akũ Dauda pì a ìba kũ ò kú kãao Yurusalɛmunↄnɛ: À futɛ ò bàa lɛ́. Tó ódi kɛ lɛro, óni le ò bo Abusalomu ↄĩro. Ò kɛ likalika. Tó ódi kɛ likalikaro, ani ó le la, ani ó ásaru kɛ, ani wɛ̃tɛdenↄ dɛdɛ kũ fɛ̃nɛdao. ");
INSERT INTO bqp_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Kína ìbanↄ pìnɛ: Ó dikiri kína, yã kũ n zɛo pínki, ókↄ̃nↄ n zↄ̀blerinↄ o lakamɛ. ");
INSERT INTO bqp_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Akũ kína dà zɛ́n. A bedenↄ bò ò tɛ̀i ń pínki, ama à a nↄ yìgisaride mɛ̀n kurinↄ tò gwe ògↄ̃ bɛ gwa. ");
INSERT INTO bqp_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Kína dà zɛ́n lɛ kũ a gbɛ̃nↄ. Kũ ò kà wɛ̃tɛ kpɛ, à lìtɛ à zɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Akũ a ìbanↄ pínki kũ a dogarinↄ kũ Gatadenↄ gbɛ̃nↄn wàa aakↄ̃ kũ ò tɛ́i zaa Gatanↄ gɛ̃̀tɛ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Akũ kína pì Gata gbɛ̃ Itainɛ: Bↄ́yãi ntɛn gɛ́ kũoomɛɛ? Ǹ ɛra ǹ tá ǹgↄ̃ kú kũ kína dufuo, zaakũ gbɛ̃ zĩ̀tↄↄmɛ n ũ, n bo n bùsummɛ. ");
INSERT INTO bqp_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","N suna dí gↄrↄ pla kɛro, akũ ń ye ǹgↄ̃ likara zↄ̃ kũoo yá? Má dↄ̃ gu kũ matɛn gɛ́nlo. Ǹ n gbɛ̃nↄ kakara ǹ tá kũńwo. Dikiri gbɛ̃kɛ kũ náani yão kɛnnɛ. ");
INSERT INTO bqp_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Akũ Itai wèa à pì: Ma dikiri kína, kũ Dikiri kunnaao kũ n kunnaao, gu kũ ń kun pínki, makũ n zↄ̀bleri manigↄ̃ kú gwemɛ, mani ga yá kesↄ̃ manigↄ̃ kun yá. ");
INSERT INTO bqp_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Akũ Dauda pìnɛ: Ǹ domɛnɛ arɛ ò gɛ́! Akũ Gata gbɛ̃ Itai ɛ̀ra à dà zɛ́n kũ a gbɛ̃nↄ kũ a danɛ kũ ò kú kãaonↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Kũ òtɛn gɛ̃ zɛ́la ń pínki, akũ bùsudenↄ wiki lɛ̀. Kũ kína bikũ̀ Kidironua, akũ ń pínki ò gbáranna zɛ́ sɛ̀. ");
INSERT INTO bqp_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Zadↄki kú gwe dↄ kũ Levinↄ ń pínki. Ò Luda bàka kunna kũńwo àkpati sɛna. Ò àkpatii pìi dìtɛ Abiata sarɛ ari gbɛ̃nↄ bↄ̀tɛ wɛ̃tɛn ò làka ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Akũ kína pì Zadↄkinɛ: Ǹ Luda àkpati sɛ́ ǹ gɛ̃o wɛ̃tɛ gũn. Tó ma Dikiri pↄnna lè, ani tó mà su mà wɛ́ sialɛ kũ a kúkio. ");
INSERT INTO bqp_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Tó à pì ma yã dí káaguro sↄ̃, ma laka. À kɛmɛnɛ lákũ à kɛ̀arɛ mana nà. ");
INSERT INTO bqp_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Akũ kína ɛ̀ra à pì sa'ori Zadↄkinɛ: Wɛ́gupu'eriimɛ n ũroo? Ǹ ɛra ǹ tá wɛ̃tɛ gũn aafia kũ n nɛ́ Aimazao kũ Abiata nɛ́ Yonatão. À tá kũ á nɛ́ gbɛ̃nↄn pla pìnↄ. ");
INSERT INTO bqp_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Manigↄ̃ zɛna swabikũkia sɛ̃̀ntɛ ari mà baaru maáwa. ");
INSERT INTO bqp_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Akũ Zadↄki kũ Abiatao Luda àkpatii sɛ̀ ò tào Yurusalɛmu, akũ ò gↄ̃̀ gwe. ");
INSERT INTO bqp_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Dauda tɛn Kùkpɛ sĩ̀sĩ kũ àtɛn ↄ́ↄ dↄ. À pↄ́ kù a mìia, à kyate kpanaro. Gbɛ̃ kũ ò kú kãaonↄ pↄ́ kù ń mìia ń pínki, òtɛn ↄ́ↄ dↄdↄ òtɛn gɛ́o. ");
INSERT INTO bqp_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Kũ ò pì Daudanɛ Aitofɛli kú gbɛ̃ kũ ò zɛ̀ kũ Abusalomuonↄ tɛ́, akũ Dauda adua kɛ̀ à pì: Dikiri, ǹ tó a lɛ́damma gↄ̃ de yã fayasaride ũ. ");
INSERT INTO bqp_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Kũ Dauda kà sĩ̀sĩ mìsↄ̃ntɛa, gu kũ donyĩkɛki kún, Aki gbɛ̃ Usai sù à dàalɛ, a uta kɛ̃na akũsↄ̃ bùsu kú a mìia. ");
INSERT INTO bqp_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Dauda pìnɛ: Tó n gɛ kũmao, ĩnigↄ̃ demɛnɛ aso ũmɛ. ");
INSERT INTO bqp_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Tó n ɛra n ta wɛ̃tɛn, akũ n ò Abusalomunɛ a zↄ̀bleriimɛ n ũ sↄ̃, ĩni Aitofɛli lɛ́damma gboromɛnɛmɛ. Ǹ pinɛ a de zↄ̀bleriimɛ n ũ yã, ama tera n gↄ̃ a zↄ̀bleri ũmɛ sà. ");
INSERT INTO bqp_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Sa'orinↄ Zadↄki kũ Abiatao gↄ̃ kú kũnwo gwe. Ǹ yã kũ n mà kínabɛa babańnɛ pínki. ");
INSERT INTO bqp_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Ń nɛ́ gbɛ̃nↄn planↄn kú kũnwo gwe, Zadↄki nɛ́ Aimaza kũ Abiata nɛ́ Yonatão. Tó n yãke mà, ǹ nɛ́ pìnↄ zĩ ò su ò omɛnɛ. ");
INSERT INTO bqp_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Akũ Dauda gbɛ̃nna Usai pìi tà, à kà Yurusalɛmu gↄrↄ kũ Abusalomu tɛn gɛ̃. ");
INSERT INTO bqp_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Kũ Dauda vĩ̀ sĩ̀sĩ mìdangurala fíti, à è Mɛfibosɛ bɛgwari Ziba gàarii yĩ̀ zaakinↄnɛ mɛ̀n pla, àtɛn su daalɛ. Ò burodi sɛna mɛ̀n wàa do kũ geepi kàraao mɛ̀n basↄↄro kũ kaka nɛ́ kàraao mɛ̀n basↄↄro kũ sèwɛ̃o tùru do. ");
INSERT INTO bqp_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Akũ Dauda Ziba là à pì: Bↄ́ mɛ́ à tò n su kũ abireoo? Ziba wèa à pì: Kína, zaakinↄ bi n bedenↄ pↄ́mɛ ò dia. Burodi kũ kàranↄ bi n gbɛ̃nↄ pↄ́blemɛ. Wɛ̃ sↄ̃, gbɛ̃ kũ ò kpàsa gbáranna gũnnↄ pↄ́minaamɛ. ");
INSERT INTO bqp_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Kína a là à pì: N dikiri kũ à kɛ̀ sari daikore kú mámɛ? Ziba wèa à pì: À gↄ̃̀ Yurusalɛmu, zaakũ àtɛn da Isarailanↄ a ká a dizi kpatan gbãramɛ. ");
INSERT INTO bqp_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Akũ kína pìnɛ: Pↄ́ kũ Mɛfibosɛ vĩ pínki gↄ̃̀ n pↄ́ ũ. Akũ Ziba pì: Má kútɛ dí! Ma dikiri kína, ǹ tó màgↄ̃ n pↄnna le lɛ. ");
INSERT INTO bqp_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Kũ kína Dauda nà Bahurimui, à è gↄ̃gbɛ̃ ke bò. A tↄ́n Simɛi, Gera nɛ́mɛ. Àkũmɛ buri dokↄ̃nↄ kũ Solu bedenↄ. À bò wɛ̃tɛ gũn, àtɛn Dauda ká. ");
INSERT INTO bqp_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","Àtɛn gbɛ̀ zuzu kína Daudai kũ a gbɛ̃nↄ, bee kũ a zĩ̀karinↄ kũ a dogarinↄn kú a ↄplai kũ a ↄzɛio ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Àtɛni a sↄ̃sↄ̃ àtɛn pi: Ǹ gɛ́! Ǹ gɛ́! Gbɛ̃dɛri! Pↄ́ pã! ");
INSERT INTO bqp_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Dikiri fĩna bònnɛ Solu kũ n kí blè a gɛ̃nɛ ũ bedenↄ dɛdɛna yã yãi. Dikiri n bo kpatan à n nɛ́ Abusalomu kàn. Ásaru kɛ̀mma sà, zaakũ gbɛ̃dɛriimɛ n ũ. ");
INSERT INTO bqp_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Akũ Zeruya nɛ́ Abisai pì kínanɛ: Ma dikiri kína, à mana gbɛ̃da gɛ̀ dí gↄ̃ n sↄ̃sↄ̃ro. Ǹ tó mà gɛ́ mà a mì zↄ̃. ");
INSERT INTO bqp_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Akũ kína pì: Zeruya nɛ́nↄ, bↄ́ mɛ́ à ó kakaraa? Tó Dikiri mɛ́ à ònɛ à ma sↄ̃sↄ̃, akũ àtɛni ma sↄ̃sↄ̃, dí mɛ́ ani fↄ̃ à a la à pi, bↄ́yãi àtɛn kɛ lɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Akũ Dauda ò Abisainɛ kũ a ìbanↄ ń pínki à pì: À gwa, ma zĩda nɛ́'ina mɛ́ àtɛn wɛtɛ à ma dɛ. Oni Biliaminu buri díkĩna pↄ́ o dↄ yá? À a tó gwe. Tó Dikiri mɛ́ à pìnɛ à ma sↄ̃sↄ̃, à manamɛ. ");
INSERT INTO bqp_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Òdigↄ̃ dↄ̃ro ke Dikiri ni ma wari dↄ̃ à fĩna bomɛnɛ kũ yã manao sↄ̃sↄ̃ kũ òtɛn kɛmɛnɛ gbãra yãi. ");
INSERT INTO bqp_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Kũ Dauda tɛ́ zɛ́n kũ a gbɛ̃nↄ, Simɛi tɛ́ sĩ̀sĩ pãnde kpadoi, àtɛni a sↄ̃sↄ̃ àtɛni gbɛ̀ zuzui àtɛn bùsu fã. ");
INSERT INTO bqp_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Kũ kína kũ a gbɛ̃ kũ ò kú kãaonↄ kà swai, ò kpàsa, akũ ò kámma bò gwe. ");
INSERT INTO bqp_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Abusalomu kà Yurusalɛmu kũ Isarailanↄ ń pínki. Aitofɛli kú kãao. ");
INSERT INTO bqp_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Akũ Dauda gbɛ̃nna Usai, Aki gbɛ̃ gɛ̀ɛ à Abusalomu lè à pìnɛ: Luda n dↄ̃ kũ aafiaao Zaaki! Luda n dↄ̃ kũ aafiaao Zaaki! ");
INSERT INTO bqp_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Abusalomu a là à pì: Gbɛ̃kɛ kũ ń vĩ kũ n gbɛ̃nnaon gwe yá? Bↄ́yãi ńdi gɛ́ kũ n gbɛ̃nnaoroo? ");
INSERT INTO bqp_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Usai wèa à pì: Lɛnlo! Gbɛ̃ kũ Dikiri kũ gbɛ̃ díkĩnanↄ sɛ̀ pↄ́n ma ũ. Ma zɛ kũ kína kũ Isarailanↄ kàa pìio. ");
INSERT INTO bqp_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Abire gbɛra dↄ, dí mɛ́ à mana mà zↄ̀ blenɛ, n baasii? Lákũ ma zↄ̀ↄ blè n denɛ nà, lɛn mà blennɛ lɛ. ");
INSERT INTO bqp_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Abusalomu pì Aitofɛlinɛ: À lɛ́ dawá. Bↄ́n óni kɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Akũ Aitofɛli wèa à pì: Ǹ gɛ́ ǹ wútɛ kũ n de nↄ yìgisaride kũ à ń tó la òtɛn bɛ gwanↄo, de Isarailanↄ le ò dↄ̃ ń pínki kũ n tò n de ye n kãiro, gbɛ̃ kũ ò kú kũnwonↄ gbãna ni kara. ");
INSERT INTO bqp_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Akũ ò bizakuta dↄ̀ Abusalomunɛ kpɛ́ musu, akũ à gɛ̀ɛ à wùtɛ kũ a de nↄ pìnↄ gwe Isarailanↄ pínki wára. ");
INSERT INTO bqp_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Gↄrↄ birenↄa lɛ́ kũ Aitofɛli dì daḿma de lán gbɛ̃ kũ à yã gbɛ̀ka Ludaa yã bàmɛ. Lɛn Aitofɛli lɛ́damma de lɛ Daudanɛ kũ Abusalomuo ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Aitofɛli pì Abusalomunɛ: Tó makũmɛ, mani zĩ̀karinↄ sɛ́ gbɛ̃nↄn dúbu kuri awɛɛpla mà pɛ́tɛ Daudai kũńwo gwãaniala. ");
INSERT INTO bqp_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Mani lɛ́tɛa gↄrↄ kũ à kpàsa a ↄ bùsa, mani a fu. A gbɛ̃nↄ ni bàa lɛ́ ń pínki, mani a dɛ ado, ");
INSERT INTO bqp_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","mani sunnɛ kũ gbɛ̃ pìnↄ ń pínki. Gbɛ̃ kũ ntɛn wɛtɛ ǹ dɛ ganan gbɛ̃ pìnↄ suna ũ ń pínki. Tó à gà, gbɛ̃ kparanↄ ni gↄ̃ aafia ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Yã pìi kɛ̀ Abusalomunɛ nna kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Akũ Abusalomu pì: Ò Aki gbɛ̃ Usai sísi dↄ ò ma lákũ ani o nà se. ");
INSERT INTO bqp_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Kũ Usai kà, Abusalomu pìnɛ: Lákũ Aitofɛli ò nàn dí. Ò kɛ lákũ à ò nàn yá? Ke òsun kɛ lɛro. N è deramɛɛ? ");
INSERT INTO bqp_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Usai wèa à pì: Lɛ́ kũ Aitofɛli dàáwa gbãra manaro. ");
INSERT INTO bqp_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Ń n de dↄ̃ kũ a gbɛ̃nↄ. Zĩ̀kari mananↄmɛ ń ũ, ò pãsĩ lán músu nɛ́rande kũ ò a nɛ́nↄ sìaa bàmɛ. N de bi zĩ̀kariimɛ, ani we à i gu dokↄ̃nↄ kũ a gbɛ̃nↄoro. ");
INSERT INTO bqp_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Gu kũ à kun tera, anigↄ̃ utɛna gbɛ̀wɛɛɛ gũn ke gukea. Tó à sù à lɛ̀tɛ ó gbɛ̃nↄa káaku sↄ̃, gbɛ̃ kũ à a baaruu mà ni pi, ò zĩ̀i blè Abusalomu zĩ̀karinↄamɛ. ");
INSERT INTO bqp_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Bee gↄ̃sa gbãna kũ à wↄ́rↄgↄ vĩ lán músuu bànↄ swɛ̃̀ ni kɛ̃ńgumɛ, zaakũ Isarailanↄ dↄ̃ ń pínki kũ n de bi zĩ̀kari manamɛ, akũsↄ̃ gↄ̃sa gbãnanↄn kú kãao. ");
INSERT INTO bqp_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Abire yãi lɛ́damma yã kũ má vĩn dí. Ǹ Isarailanↄ kakaranyĩ ń pínki zaa Dani ari gɛna Bɛsɛba, ògↄ̃ dasi lán ísiralɛ bùsu'atɛ̃ bà, ǹ dońnɛ arɛ zĩ̀lan. ");
INSERT INTO bqp_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Óni a le gu kũ à kun pínki, óni lɛ́tɛa lán plí dì kↄ́tɛ zĩtɛa nà. Àpi kũ gbɛ̃ kũ ò kú kãaonↄ ń pínki, ń gbɛ̃ke ni boro. ");
INSERT INTO bqp_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Tó à sù à gɛ̃̀ wɛ̃tɛ ke gũmmɛ sↄ̃, Isaraila gbɛ̃ sĩnda pínki ni bà sɛ́ à gɛ́o gwe, oni wɛ̃tɛ pì kátɛbↄnↄ gátɛ ò táo guvutɛn. Bee a gbɛ̀ kaso ke, oni e gwe doro. ");
INSERT INTO bqp_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Akũ Abusalomu kũ Isarailanↄ pì ń pínki: Usai lɛ́damma mana de Aitofɛli pↄ́la. Dikiri mɛ́ à zɛ̀o à Aitofɛli lɛ́damma mana pìi gboro, de à le à Abusalomu ásaru kɛ yãi. ");
INSERT INTO bqp_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Akũ Usai ò sa'ori Zadↄkinɛ kũ sa'ori Abiatao à pì: Aitofɛli lɛ́ dà Abusalomua kũ Isaraila gbɛ̃ zↄ̃kↄ̃nↄ à pì à kɛ lán dí bà, akũ ma lɛ́ dàḿma ma pì ò kɛ lán dí bà. ");
INSERT INTO bqp_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","À gbɛ̃nↄ zĩ likalika ò gɛ́ ò o Daudanɛ àsun i swabikũkiaro, à bikũ likalika, de òsun àpii kũ gbɛ̃ kũ ò kú kãaonↄ dúgu zↄ̃ro yãi. ");
INSERT INTO bqp_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Yonatã kũ Aimazao kú Ɛnlogɛli, zaakũ oni fↄ̃ ò bo gupuraa Yurusalɛmuro. Akũ nↄkpare zĩkɛri ke gɛ̀ɛ à òńnɛ ò gɛ́ baaruu pìi kpá kína Daudanɛ. ");
INSERT INTO bqp_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Akũsↄ̃ kɛfɛnna ke ń é, akũ à gɛ̀ɛ à ò Abusalomunɛ. Gbɛ̃nↄn pla pìnↄ dà zɛ́n gↄ̃̀nↄ, ò gɛ̀ɛ gbɛ̃ke bɛa Bahurimu. Lↄ̀gↄ kú ↄnn gwe, akũ ò gɛ̃̀n. ");
INSERT INTO bqp_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Akũ bede pì nanↄ lↄ̀gↄↄ pì nɛ́ kpàalɛ à pↄ́blewɛ fã̀tɛa, gbɛ̃ke a yã dↄ̃ro. ");
INSERT INTO bqp_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Kũ Abusalomu gbɛ̃nↄ sù nↄgbɛ̃ pì bɛa ò pì: Aimaza kũ Yonatão kú mámɛɛ? À wèḿma à pì: Ò bikũ̀ swa'ↄnɛa. Ò ń wɛ́tɛ, odi ń ero, akũ ò ɛ̀ra ò tà Yurusalɛmu. ");
INSERT INTO bqp_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Kũ ò tà, akũ gbɛ̃nↄn pla pìnↄ bↄ̀tɛ lↄ̀gↄↄ pìi gũn, ò gɛ̀ɛ ò pì kína Daudanɛ: Ǹ bikũ swaa likalika, zaakũ Aitofɛli n kpakpa kũ yã vãniomɛ. ");
INSERT INTO bqp_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Dauda dà zɛ́n kũ gbɛ̃ kũ ò kú kãaonↄ ń pínki, ò bikũ̀ Yodaa. Kũ gu dↄ̀, ń gbɛ̃ke dí gↄ̃ro, ò bikũ̀ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Kũ Aitofɛli è òdi zĩ kɛ a lɛ́damma yãaro, à fùtɛ à gàarii yĩ̀ a zaakinɛ à tà a bɛ wɛ̃tɛn. À a bɛ pↄ́nↄ nàkↄ̃a, akũ à a zĩda lòko à gà, akũ ò a vĩ̀ a de mirawɛɛn. ");
INSERT INTO bqp_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Dauda gɛ̀ɛ Manaimu, akũ Abusalomu bikũ̀ Yodaa kũ Isarailanↄ ń pínki. ");
INSERT INTO bqp_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Abusalomu Amasa dìtɛ zĩ̀karinↄ gbɛ̃ zↄ̃kↄ̃ ũ Yoabu gɛ̃nɛ ũ. Amasa bi Sumaila buri Yɛta nɛ́mɛ. A dan Naasa nɛ́ Abigaili ũ, Yoabu da Zeruya dakũnamɛ. ");
INSERT INTO bqp_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Isarailanↄ kũ Abusalomuo bùraa kɛ̀ Giliada bùsun. ");
INSERT INTO bqp_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","Kũ Dauda kà Manaimu, Naas