﻿USE sofia;
DROP TABLE IF EXISTS sofia.bqj_vpl;
CREATE TABLE bqj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bqj_vpl WRITE;
INSERT INTO bqj_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ni fíĉilum fafu, Aláemit nátut fatiya ni ettam. ");
INSERT INTO bqj_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ettam yay eᵽa erakel eomene, ban néni n’emoĉ. Ni baj mal mammeŋe múggub yo múharo. Biinum Aláemit m’bíni fatiya mal mamu m’bíbefene. ");
INSERT INTO bqj_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ñer Aláemit naah : « Gajaŋa gubaj ! » N’gubaj may ti maagen. ");
INSERT INTO bqj_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Najuh búoh gajaŋa gagu kakan waf waaro. Náfaculor gajaŋa ni emoĉ, ");
INSERT INTO bqj_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","aban navoh gajaŋa gagu etufunaha ; emoĉ yay, yo navoh yo efuga. Ni baj tiname, ni baj bujom : funah fítiar ufu. ");
INSERT INTO bqj_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Aláemit nabbañ aah : « Elínga ebaj yajae me éfaculor mal mamu maa n’ettam ni maa fatiya. » ");
INSERT INTO bqj_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Min átut élinga yauyu yagabor me mal mamu maa n’ettam ni maa fatiya ; nebaj ti nalob me. ");
INSERT INTO bqj_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Elínga yauyu, navoh yo émit. Ni baj tiname, ni baj bujom : funah fúuten ufu. ");
INSERT INTO bqj_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Aláemit nabbañ aah : « Mbi mal mamu maamme n’ettam muomunor tiñ tanur, min mahae múᵽurul. » Ni kan ti nalob me. ");
INSERT INTO bqj_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mahae maumu, navoh mo mof ; to mal mamu muomunor me, navoh to fal. Ban najuh búoh kakan waf waaro. ");
INSERT INTO bqj_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mbiban natajen aah : « Mbi ettam yay eil esel yánoyan yajae me esen eugit, mb’eil may bununuh bánoban bajae me ebuh subugum sabaje bakol bi éni eugit. » Ni baj may ti maagen, ");
INSERT INTO bqj_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","min ettam yay eil esel, mununuhen ni ununuh, gánogan n’gubaj eugit go. Ban najuh búoh kakan waf waaro. ");
INSERT INTO bqj_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ni baj tiname, ni baj bujom : funah fúfaten ufu. ");
INSERT INTO bqj_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Aláemit nabbañ aah : « Ujaŋa ubaj n’émit bi egabor etufunaha ni efuga ; ujaŋa wauwu wo ujae me egiten nay ugan waw ujae me ekan, ni gunah gagu ni símit sasu. ");
INSERT INTO bqj_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Dó n’émit, mb’újaŋenul mof mamu. » Ni baj may ti maagen. ");
INSERT INTO bqj_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ñer Aláemit nátut ujaŋa úuba wájaloe : gagu gafaŋ me gájalo, go bi ejaŋen etufunaha ; gafaŋ me gatiti, go bi ejaŋen efuga ; nátut may suut sasu. ");
INSERT INTO bqj_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nabaŋ so ᵽe fatiya bi efijigen ettam yay, ");
INSERT INTO bqj_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","min siĉil etufunaha ni efuga, ban ni sigabor gajaŋa ni emoĉ. Aláemit najuh búoh kakan waf waaro. ");
INSERT INTO bqj_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ni baj tiname, ni baj bujom : funah fubarigen ufu. ");
INSERT INTO bqj_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Aláemit nabbañ aah : « Mbi mal mamu mugoror mala gammeŋ gagu gaa waf waw ᵽe wajae ró me eroŋ, mbi ᵽoᵽ upu waw núh’úit fatiya uhat ettam yay. » ");
INSERT INTO bqj_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Min átut súnuhureŋ sasu saa mal sámah sasu ni wáfowaf waĉine ni mal, ban n’ubugor dó ; nátut ᵽoᵽ upu waw wáile me fatiya. Wánowan ni wo, nátut wo ni ganogor wo gúbuli. Aban najuh búoh kakan waf waaro. ");
INSERT INTO bqj_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Násonien so ᵽe naah so : « Mbi jubugor iki jimmeŋen fal fafu ! Upu waw, buru mbi jubugor iki jimmeŋen ettam yay ! » ");
INSERT INTO bqj_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ni baj tiname, ni baj bujom : funah futogen ufu. ");
INSERT INTO bqj_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Aláemit nabbañ aah : « Mbi ettam yay ebaj súnuhureŋ, sánosan ni ganogor so : sihaj, súnuhureŋ saa baha, bi ni sáfulore me n’ettam ró. » Ni baj may ti maagen, ");
INSERT INTO bqj_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","min átut sihaj, súnuhureŋ saa baha, bi ni sáfulore me n’ettam ró, sánosan ni ganogor so. Aban najuh búoh kakan waf waaro. ");
INSERT INTO bqj_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Aláemit natajen aah : « Utúlal an anogorolal, mb’anogorolal ti maagen. Mbi waf waw ᵽe úni n’guñen gola : suol sasu saamme ni mal, upu waw waa fatiya, súnuhureŋ sasu sal ettam bi ni sáfulore me ró. » ");
INSERT INTO bqj_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ñer Aláemit nátut arafuhow anogorol, ban nanogorol maagen mamu. Nátulil ánaine ni anaare. ");
INSERT INTO bqj_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Násonienil naagil : « Mbi jubugor iki jimmeŋen ettam yay, ban n’juogen yo ! Suol sasu saamme ni mal, upu waw waa fatiya, súnuhureŋ sasu sal ettam, mbi so ᵽe síni n’guñenul. » ");
INSERT INTO bqj_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Natajen aagil : « N’ettam yay ᵽe nisenulsen esel ni eugit yo, nisenul ᵽoᵽ ununuh waw ni subugum wo, mbi síni fitiñul. ");
INSERT INTO bqj_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mo may, nisen me súnuhureŋ sasu, upu waw, wánowan wáfulore me n’ettam ban n’uif, mafos mánoman maiyulo n’ettam. » Ni kan mo ti maagen. ");
INSERT INTO bqj_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ñer Aláemit naluj waf waw ᵽe wo nátut me, najuh búoh úariari nár. Ni baj tiname, ni baj bujom : funah fakan me futoh ni fanur ufu. ");
INSERT INTO bqj_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mamu Aláemit naban étut fatiya ni ettam ni waf waw waam dó me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Funah fafu fakan me futoh ni gúuba, o babaner étut yay ; min áelo burok funah faufu. ");
INSERT INTO bqj_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Yo eĉil me nakan fo funah faaro, ban ni fíni fola, mata fiĉila náelo me étut yay. ");
INSERT INTO bqj_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mamu Aláemit átut me fatiya ni ettam. No Aláemit Atúla akan me ettam ni fatiya, ");
INSERT INTO bqj_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hani jununuh janur jilelen ni mof, esel yánoyan yo m’bailerut ; mata Aláemit Atúla o m’bakanerut émit nelubul ni mof mamu, ban ᵽoᵽ arafuhow m’babajerut bi eañ ettam yay. ");
INSERT INTO bqj_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Bare ni baj mal nihi múbulul n’ettam yay min míjeben yo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ñer Aláemit Atúla naŋar gábupa nateᵽ arafuhow, aban náfuᵽ ni súñunduol érus yaa buroŋ, min arafuhow ahu akan an arondoŋ. ");
INSERT INTO bqj_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Aláemit Atúla nailen fíreŋ fal ununuh baubu Eden, galam bo tinah talu túᵽureul me, min abaŋ ró an ahu o nátut me. ");
INSERT INTO bqj_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Naban naroh ró ganunuh gánogan gáarie, ban bubugum go m’búsum. N’etut fíreŋ fafu, naroh ró bununuh baa buroŋ, naroh ró ᵽoᵽ bice bal effas maaro ni maarat. ");
INSERT INTO bqj_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ni baj fal fáᵽullo ró Eden nihi fíjeben fíreŋ fafu ; ni fúgat iki fúlandor babu siral sibbagir : ");
INSERT INTO bqj_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Eral étiar gajow yo Piĉon, ban nebosor mof mamu ᵽe maa Havila, bo baj me éurus ");
INSERT INTO bqj_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","yaa maagen ; baj bo may ununuh wo físim wo fitiŋoe, ni ᵽoᵽ sival sáarie faŋ so nihi guŋar me n’gujjonen úibor waw. ");
INSERT INTO bqj_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Eral éuten gajow yo Gihon, ban nebosor mof mamu ᵽe maa Kuĉ. ");
INSERT INTO bqj_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Efáten gajow yo Tigir, uyu bo tinah talu túᵽureul me aw baamer ni mof mamu maa Aĉur. Ebarigen yay yo eemme Afúrat. ");
INSERT INTO bqj_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ñer Aláemit Atúla naŋar an ahu abaŋ ni fíreŋ fafu fal Eden bi ecokor fo naluj fo nímoro. ");
INSERT INTO bqj_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Naban naagol : « Bubugum ununuh waw ᵽe waamme ni fíreŋ faufe, nújue utiñ bo ; ");
INSERT INTO bqj_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bare nífireni etiñ bununuh babu basene me effas maaro ni maarat. Mata ínje ilob yo, funah fo nujae bo me etiñ, ᵽan uoᵽoro eĉet ti maagen. » ");
INSERT INTO bqj_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Aláemit Atúla naah : « Jáhorut min ánaine anamo nevonol ; ᵽan ikanol arambena ajae me éjahor ni o. » ");
INSERT INTO bqj_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nemme Aláemit Atúla o baŋarer mof min ateᵽ súnuhureŋ sasu ni upu waw, náŋarul so ᵽe bújoŋor an ahu min mb’ajuh bu najae so me evoh. Ñer so ᵽe ᵽan sibaj yánoyan gajow yo, go an ahu ajae yo me ekan. ");
INSERT INTO bqj_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Min an ahu akan súnuhureŋ sasu, sihaj sasu ni upu waw ᵽe ujow. Bare ajugut ni so yájahor me bi erambenol. ");
INSERT INTO bqj_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ñer Aláemit Atúla náyuol gámori gámah, min áᵽuren evul ece yaa gacaĉol, aban nabbañen to ti tínien me. ");
INSERT INTO bqj_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Naŋar evul yauyu nateᵽ anaare, aban naŋallol bi ni áine ahu. ");
INSERT INTO bqj_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ñer áine ahu naah fatiya : « Maer an ume ti ínje ! Enilol ni yúmbam éᵽullo, físimol ni fúmbam fúᵽullo. Ᵽan guvogol anaare mata n’enil ánaine náᵽullo. » ");
INSERT INTO bqj_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yo eĉil me ánaine ᵽan áᵽur ahat ᵽayol ni jaol min ak’aĉin búli bugo n’aarol, min ñer bugo gúuba gúbbañul gúni enil yanur. ");
INSERT INTO bqj_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ban áine ahu bugo n’aarol sinil sirakel guomene, bare kanutil bo ñusu. ");
INSERT INTO bqj_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Jiffase ni súnuhureŋ sasu so Atúla átut me, enuhunjaŋ efaŋ ró ᵽe mutuho. Funah fice néjoul ek’etoh to aare ahu neogol : « Maagen, Aláemit naagulseh jambi jitiñ hani bununuh banur ni waamme dáre ni fíreŋ fe ? » ");
INSERT INTO bqj_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Naah yo : « A-a, alobut me, naagóli jújue jitiñ wo, ");
INSERT INTO bqj_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bare baamme n’etut fíreŋ fafu, naagóli : “Jambi jitiñ bo, hani egor bo jatiito, mata jitiñ bo me, ᵽan jiĉet.” » ");
INSERT INTO bqj_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Enuhunjaŋ yay neogol : « Múk ! Let maagen, mati jiĉet. ");
INSERT INTO bqj_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Aláemit faŋaol naffas yo : Funah fo jijae bo me etiñ, gúĉilul ᵽan gúpegulo min jíni ti o, mata ᵽan júju jiffas maaro ni maarat. » ");
INSERT INTO bqj_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ñer aare ahu naluj bubugum bununuh babu, najuh búoh búariari, ᵽan búsum fitiñ, ban bújue bisen gaffas. Najow ak’atujul dó ni bubugum babu ece atiñ, naŋar may ak’asen áinol atiñ. ");
INSERT INTO bqj_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ñer to baenah gúĉilil n’gúpegulo n’gujuh búoh gusimout. Min guŋar utoj bununuh bice gajow bo bífig, guleĉ úhoi guhogo. ");
INSERT INTO bqj_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mb’uĉiga tiname, bunaa báruser, n’guun Aláemit Atúla najatore me ni fíreŋ fafu. N’gutey gukoᵽ n’ununuh waw. ");
INSERT INTO bqj_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Aláemit Atúla navoh áinema naagol : « Aw umelo ? » ");
INSERT INTO bqj_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Naagol : « Niuwun gaeli ni fíreŋ fafu, ñer níholi nitey ik’ikoᵽ mala min ikan me eᵽatalah. » ");
INSERT INTO bqj_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Naagol : « Ay agiteni búoh eᵽatalah nukane ? Nutitiñ ᵽiaŋ bununuh babu bo nífireni me ? » ");
INSERT INTO bqj_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Naagol : « Dáru aare ahu o nusenom me, o abajulo bo asenom, nitiñ. » ");
INSERT INTO bqj_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Aláemit Atúla naah aare ahu : « Wa uĉile nukan me ? » Naagol : « Dáru enuhunjaŋ yay ekelo ebutom min itiñ. » ");
INSERT INTO bqj_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ñer Aláemit Atúla naah enuhunjaŋ yay : « Nemme mamu nukane, ni sihaj sasu ni súnuhureŋ sasu ᵽe aw nevoni mb’itab me ! Ᵽan núh’úfulor ni fari, ban aw m’buroŋi, ᵽan núh’úmer gaᵽor gunah émit ᵽe ! ");
INSERT INTO bqj_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ñer maer, maa nijoge bi n’aw ni aare ahu : Ᵽan ikanul n’jilator, ban ubugorul ᵽoᵽ ᵽan ikan wo nulator. Gabulaken aare ahu ᵽan gumapul fuhoi, aw ᵽan urum gola ni futoñ. » ");
INSERT INTO bqj_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mbiban, naah aare ahu : « Ᵽan ikan gafareti gútañi, min nuh’ubuh guñoli ni buyoh. Ᵽan nuh’umaŋ bilihor n’áini, bare aĉila ᵽan áni afani. » ");
INSERT INTO bqj_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Naban nábaho mbal áinema naagol : « Nemme firim aari núttune min utiñ bununuh babu bo nífireni me : Aw mb’uĉil me min itab ettam yay. Ᵽan urok yo táñi gunah émit ᵽe min mb’úju ubaj ró fitiñi. ");
INSERT INTO bqj_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","N’ettam yay yíya, mafos mánoman maa sijeŋ ᵽan miil dó, ᵽan nuh’utiñ waileul me n’ulah waw. ");
INSERT INTO bqj_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","N’ejeni ᵽan útiñum bi funah fal eĉeli no mb’ubbañ me mbal ettam dó núᵽullo me. Maagen aw mof nom, ban ᵽan ubbañ úbaho mof. » ");
INSERT INTO bqj_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mbiban, áinema Adam nakan aarol gajow gagu gaa Eva (dóemme \"aroŋ me\"), mata aĉila ajae me éni jaw bugan bugagu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ñer Aláemit Atúla naŋar ubaŋ waa súnuhureŋ min acokor wañ asim Adam ni aarol. ");
INSERT INTO bqj_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Naban naah : « Nemme maer arafuhow nánini ti ace ni wolal, min affas me wáari me ni waarat me, jambi atiñ me maer bununuh babu baa buroŋ ; mata ihalol me natiñ bo, ᵽan aroŋ bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ñer Aláemit Atúla náᵽunnil ni fíreŋ fafu fal Eden gujow guke burok ettam yay dó naŋar me nateᵽil. ");
INSERT INTO bqj_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","No nahamil me aban, naŋar báuwener émit guce bugo guvoge me ĉerubeŋ, abaŋ m’butum gánonum fíreŋ fafu. N’guogen ufoje wajege sambun nihi gúvit wo bi emin bulago babu bajow me bi ni bununuh babu baa buroŋ. ");
INSERT INTO bqj_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam narobo bugo n’aarol Eva. Eva naŋar far, nak’apegor nabaj júᵽur naah : « Ni garamben Atúla niballo júᵽur. » Min akan jo gajow gagu gaa Kaeŋ (dóemme \"ébajul\"). ");
INSERT INTO bqj_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nabbañ ateb ak’aalen náŋarul Kaeŋ jitiay navoh jo Abbel. No uñiaw gújalo me, Abbel nakan akoña ubbarum, atiol Kaeŋ o náni aaña. ");
INSERT INTO bqj_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Min gunah gagu gúgale me, nuĉiga funah fice, Kaeŋ nátebul mitiñ maa burokol bi éji Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abbel may o náŋarul gabugor gátiar gafat me gal ubbarumol ákail áji Atúla. Ban Atúla nayab Abbel n’gásumay n’gájiol ró ");
INSERT INTO bqj_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","min til ahabo gaa Kaeŋ. Ñer Kaeŋ fiiñol ni fitiñ náñigen. ");
INSERT INTO bqj_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Atúla naagol : « Wa uĉile fiiñi ni fitiñ ? Uñígen min ni bu ? ");
INSERT INTO bqj_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Biinumi bútuen me, ᵽan úju úallo bújonih ; bare búhoji me, gatil gagu ugu to n’guholei ti énuhureŋ yafiye m’butum gánonumi nénii n’enah. Gumaŋe bi ejogi, bare aw núarie uhek go. » ");
INSERT INTO bqj_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ᵽúrto, Kaeŋ naah atiol Abbel : « Ujaa ujatora mbal ulah waw ! » No guĉih bo me, náñag álloŋ Abbel min amugol. ");
INSERT INTO bqj_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","No nabbanno me, Atúla narorenol : « Atii Abbel umelo ? » Naagol : « Ijugutol. Injé ᵽiaŋ eemme apoyaol ? » ");
INSERT INTO bqj_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Atúla naagol : « Wa nukan me ? Físim atii fo núyu me n’ettam ufu fákoŋeul me bi n’ínje, fuoge bulugen ! ");
INSERT INTO bqj_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nujuge, gatab ugu ni aw, min mb’uhat ettam yay yámer me físim atii o numuh me. ");
INSERT INTO bqj_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Maer uañ me ettam yay, mat’ebbañ eseni wo nuh’ubajen dó me. Ᵽan nuh’uyanor bo me, ban mat’ubaj to nujae éjoj. » ");
INSERT INTO bqj_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaeŋ naagol : « Gúteh gauge gúliiomlii mámah, mat’íju iteb go. ");
INSERT INTO bqj_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Jama aw umu n’ehamom n’ettam yay yáari me. Ᵽan ñer ik’imeoi ráli. Mbi nih’iyanor bo me m’bájojut, an ajugom babu, namuh ! » ");
INSERT INTO bqj_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Atúla naagol : « Hani ! An amugi me, bulugeni ᵽan bubaj ñono futoh ni ñúuba. » Min akan fúffasum ni o, mbi an aemor n’aĉila jamb’amugol. ");
INSERT INTO bqj_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ᵽúrto, Kaeŋ najow ráli n’Atúla ak’aĉin ni mof mamu maa Nod (dóemme \"gayanor\") galam bo tinah túᵽureul me aw baamer Eden. ");
INSERT INTO bqj_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaeŋ nak’abaj anaare, n’gurobo. Aarol naŋar far ak’apegor áᵽur navogol Henok. Kaeŋ naŋar gajow áᵽurol akan ésuh yay yo naamme n’eju. ");
INSERT INTO bqj_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok nabuh Irad ; Irad nabuh Mehuyael aamme ᵽay Metuĉael abuh me Lameh. ");
INSERT INTO bqj_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameh waare gúuba nayabe : átiar gajaol Ada, áuten gajaol Sila. ");
INSERT INTO bqj_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nabuh Yabal ; aĉila aamme ᵽay afan ala ukoñaaw ᵽe bugo nihi guĉin me ni gúggut. ");
INSERT INTO bqj_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Atiol gajaol Yubal ; aĉila o aamme ᵽay afan ala utega sisimbiŋ sasu ni uoga sutongole sasu. ");
INSERT INTO bqj_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila abel Ada nabaj may añil navogol Tubal-Kain ; aĉila o aamme ᵽay afan ala uaᵽaaw ᵽe, bugo nihi guaᵽ me mañ mújugah ni muñuget. Alínol gajaol Naama. ");
INSERT INTO bqj_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Mb’uĉiga funah fice, Lameh naah waarol : « Ada ni Sila, aᵽi juuttenom ! Buru waarom, mbi jikan to uinumul ni wo nijaeul me elob : Nimuge ánaine o bábukenerom, nitege áᵽur ik’imuh o bakanerom gúbit. ");
INSERT INTO bqj_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Guoseh an amuh me Kaeŋ, ᵽan gulugenol ñono futoh ni ñúuba. Bare ínje neege, an agor me ínje Lameh, ᵽan ilugen ni o ñono úvi gúfaji ni gaat ni ñúuba (77). » ");
INSERT INTO bqj_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ᵽúrto, Adam nabbañ asen Eva far ak’apegor júᵽur. Eva naah : « Aláemit nájiom ace añil butum Abbel o Kaeŋ amuh me. » Yo eĉil me nakanol gajow gagu gaa Set (dóemme \"éji\"). ");
INSERT INTO bqj_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set nak’abuh áᵽur nakanol gajow gagu gaa Henoĉ. No, bugan bugagu guju me elaw Aláemit ni gajaol gal Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dáure gabugor Adam : Aláemit no nátut me an, nakanol anogorol ; ");
INSERT INTO bqj_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ban nátulil gúni ánaine ni anaare. Funah fafu fo nátulil me, násonienil, aban nakanil gajow gagu gaa arafuhow. ");
INSERT INTO bqj_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","No Adam abaj me símit ekeme ni ávi ni guñen (130), nabuh áᵽur anogorol maagen mamu, navogol Set. ");
INSERT INTO bqj_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni sífaji (800) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni ávi ni guñen (930). ");
INSERT INTO bqj_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set nak’abuh áᵽur o babajer símit ekeme ni futoh (105), navogol Henoĉ. ");
INSERT INTO bqj_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni sífaji ni futoh ni súuba (807) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni guñen ni súuba (912). ");
INSERT INTO bqj_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Henoĉ may no nabaj me símit úvi gubbagir ni guñen (90), nabuh áᵽur gajaol Kenan. ");
INSERT INTO bqj_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni sífaji ni gaat (815) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni futoh (905). ");
INSERT INTO bqj_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan aĉila no nabaj me símit úvi gúfaji ni guñen (70), nabuh áᵽur navogol Mahalalel. ");
INSERT INTO bqj_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni sífaji ni úvi gúuba (840) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni guñen (910). ");
INSERT INTO bqj_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel nak’abuh áᵽur o babajer símit úvi gúfaji ni futoh (65), navogol Yered. ");
INSERT INTO bqj_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni sífaji ni ávi ni guñen (830) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sífaji ni úvi gubbagir ni gaat (895). ");
INSERT INTO bqj_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yered no nabaj me símit ekeme ni úvi gúfaji ni súuba (162), nabuh áᵽur navogol Henok. ");
INSERT INTO bqj_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni sífaji (800) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni úvi gúfaji ni súuba (962). ");
INSERT INTO bqj_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok no nabaj me símit úvi gúfaji ni futoh (65), nabuh áᵽur navogol Matuĉelah. ");
INSERT INTO bqj_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Naroŋ to atajen símit sikeme sífaji (300) n’elagen Aláemit, nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","No nabaj me ñer símit sikeme sífaji ni úvi gúfaji ni futoh (365), ");
INSERT INTO bqj_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","an abbañut ajugol n’ettam, Aláemit bájaenumerol mbaa fatiya ; mata buroŋol n’Aláemit nabaŋ bo. ");
INSERT INTO bqj_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matuĉelah nak’abuh áᵽur o babajer símit ekeme ni úvi gubbagir ni futoh ni súuba (187), navogol Lameh. ");
INSERT INTO bqj_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni súuba ni úvi gubbagir ni súuba (782) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni úvi gúfaji ni futoh ni sibbagir (969). ");
INSERT INTO bqj_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameh no nabaj me símit ekeme ni úvi gubbagir ni súuba (182), nabuh áᵽur ");
INSERT INTO bqj_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","naah : « Nemme Atúla natatab ettam yay min burokolal bútañi, añil ahume o ajae me éelenolal ni buyogolal. » Yo eĉil me nakanol gajow gagu gaa Nóe (dóemme \"éelen\"). ");
INSERT INTO bqj_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh ni úvi gubbagir ni gaat (595) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni súuba ni úvi gúfaji ni gaat ni súuba (777). ");
INSERT INTO bqj_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nóe no nabaj me símit sikeme futoh (500), nabuh úᵽur gúfaji, ahu gajaol Sem, ahu Ham, ahu Yafet. ");
INSERT INTO bqj_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Min bugan bugagu gúmmeŋeul me n’ettam, mo may gubuge me sújur gáarie faŋ. ");
INSERT INTO bqj_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","No úᵽur Aláemit gujuh me jáari sújur sausu, nihi gúkail guliᵽ guce ni bugo guyab. ");
INSERT INTO bqj_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ñer Atúla naah : « Biinumom baa buroŋ bábaerit bo nisen me arafuhow, mati búju bíni ni o bi nánonan, mata aĉila enil nam. Maer buroŋol ᵽan bítij símit ekeme ni ávi (120). » ");
INSERT INTO bqj_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","No bajene n’ettam bugan búgamah ban ni gubbah ; bugo guomme gabugor úᵽur Aláemit go gubuh me no gukelo me guyab sújur sasu bugal ettam. Uñiaw ubugi bugo guomme buganolal búgamah bugaa no, bugo ujail ujamo me. ");
INSERT INTO bqj_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Atúla najuh búoh bugan bugagu gufaŋefaŋ n’gúlaᵽute : Funah fo tihane, uinumil nuteb bi ekan maarat barebare. ");
INSERT INTO bqj_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ni táñiol iki ajoh émiremma min akan me arafuhow ");
INSERT INTO bqj_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","naah : « Ᵽan inemen ni mof bugan bugagu bi ni súnuhureŋ sasu ró, sáfulore me ni may upu waw. Ti maagen, nijojoh émiremma min ítulum me waf wauwu ᵽe waife me. » ");
INSERT INTO bqj_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bare Nóe buroŋol búsusum Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Buroŋ Nóe maa bujow ma : Bukakan buroŋ banabe ban ni bukur bújoŋor bugan bugagu, mata nalagelagen Aláemit, ban ᵽoᵽ nah’akan wásum me Aláemit. ");
INSERT INTO bqj_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nabaj úᵽur gúfaji, gaamme Sem, Ham ni Yafet. ");
INSERT INTO bqj_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Bare ni bajuger Aláemit, bugan bugagu ᵽe gaamme n’ettam gujonut, iki báloj bimmeŋ ni mof. ");
INSERT INTO bqj_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Najuh maagen mamu búoh mof mamu ᵽe muhajekajen ; mata bugan bugagu maarat bare guom n’ekan. ");
INSERT INTO bqj_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ñer Aláemit naah Nóe : « Báloj bugan bugagu bikelo bimmeŋen ettam yay kab. Bo biĉil me min ijoh bi eban ésuh yay ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mb’uŋar ubabar waake min ucokor busana báamah. Mb’ugabor ñáraru bo gutoŋ gammemmeŋ. Mb’uban nulogos bo elahatiroŋ ñáraru bo bi ni tíyaŋ bo ró. ");
INSERT INTO bqj_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Gahuli gagu mb’ulih simetar ekeme ni úvi gúuba ni guñen (150), bauŋ babu simetar ávi ni futoh (25), gabbah gagu simetar gaat (15). ");
INSERT INTO bqj_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mb’urembenor sitah sífaji, uban nukan bo firihinjaŋ fahalore eᵽa yaᵽiloe butum gañen ni guteᵽ gagu. Ganegen bo mbi gúni n’etut gacaĉ bo gace. ");
INSERT INTO bqj_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Uban me, ínje ᵽan íannul mal mammeŋe iki muguben ettam yay múharo, min mumuh wáfowaf waife me. Waf waw ᵽe waamme n’ettam ᵽan uĉet. ");
INSERT INTO bqj_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bare aw, ᵽan ijogor babuge n’aw ; ᵽan mb’unogen ni busana babu, aw, aari, guñoli ni waaril. ");
INSERT INTO bqj_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mb’uŋar ni súnuhureŋ sasu ᵽe, sánosan ni ganogor so, yáine ni yaare úrur dó min súju suroŋ ti buru. ");
INSERT INTO bqj_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Imaŋut buroŋ binemo ni mof. Yo eĉil me, mb’uŋar súuba-súuba n’upu waw, ni súnuhureŋ sasu sájalo me, bi ni sáfulore me n’ettam ró. ");
INSERT INTO bqj_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mb’uŋar may mitiñay mánoman ulalen me bi fitiñul, buru ni súnuhureŋ sasu ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nóe nakan wo Aláemit alobol me, ahalut bo hani waf wanur. ");
INSERT INTO bqj_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ᵽúrto, Atúla naah Nóe : « Uŋar bugani n’junogen ni busana babu. Mata nijuge búoh n’ésuh yay ᵽe aw bare unab ró. ");
INSERT INTO bqj_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ni súnuhureŋ sasu sáari me bi bísimen, ni ganogor gánogan mb’uŋar súuba-súuba, yáine ni yaare, bi ñono futoh ni ñúuba. Ni sáariut me, mb’uŋar tánotan yáine ni yaare bare. ");
INSERT INTO bqj_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ni upu waw may, mb’uŋar tánotan úuba, gáine ni gaare, bi ñono futoh ni ñúuba. Mamu mbi ganogor gánogan gúju gubbañ guroŋ ni mof. ");
INSERT INTO bqj_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tale gunah futoh ni gúuba, ᵽan ikan émit yay nelub gunah úvi gúuba tujon ni tihalen, m’báelout. Min inemen ni mof mamu waf waw ᵽe waife me wo nikan me. » ");
INSERT INTO bqj_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nóe nakan wo Atúla alobol me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","No Aláemit áyuulo me mal mamu báyuer babu bájalo me ni mof, Nóe o babajer símit sikeme futoh ni yanur (600). ");
INSERT INTO bqj_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ñer Nóe nanogen ni busana babu, aĉila, aarol, guñolol ni waaril, bi eᵽah. ");
INSERT INTO bqj_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ti Aláemit alob yo me, súnuhureŋ sasu sáari me ni sáariut me bi bísimen, upu waw bi ni sáfulore me ró, ni síkail sunogen ni busana babu súuba-súuba, yáine ni yaare, sutoh ró Nóe. ");
INSERT INTO bqj_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","No nuĉiga me funah fafu fakan me futoh ni gúuba, mal mamu mámah mamu ni miĉigul. ");
INSERT INTO bqj_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Gannay gaugu no Nóe abaj me símit sikeme futoh ni yanur (600), funah fafu fakan me gaat ni gúuba ni fieñ fafu fúuten, funah fiĉila súbula sasu ᵽe saa fal fámah sútojuloulo me n’efanjen mal ró, sílinga émit ni sífasoul, ");
INSERT INTO bqj_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","min émit yay eilo eban mal babaner gunah úvi gúuba, tujon ni tihalen. ");
INSERT INTO bqj_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Funah faufu Nóe o banoner ni busana babu, aĉila, aarol, guñolol Sem, Ham ni Yafet ni waaril, ");
INSERT INTO bqj_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ni may súnuhureŋ sasu ᵽe, sánosan ni ganogor so, sihaj sasu bi ni sáfulore me ró, upu waw ni wáfowaf wabaje ubes. ");
INSERT INTO bqj_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","So ᵽe saife me, sánosan ni síkail súuba-súuba, sutoh ró Nóe. ");
INSERT INTO bqj_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ni sunogen dó, ganogor gánogan yáine ni yaare, ti Aláemit alobol yo me. Mbiban, Atúla nábahen ganegen gagu apeh. ");
INSERT INTO bqj_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Min ñer émit yay eilo elubul gunah úvi gúuba. Mal mamu ni mimmeŋ iki busana babu bitebor buhat ettam yay. ");
INSERT INTO bqj_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mo muomme iki busana babu bíren. ");
INSERT INTO bqj_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ni muroŋ bae n’ejiŋ yay iki muguben gurijaŋ gagu ᵽe gal ettam. ");
INSERT INTO bqj_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ni muroŋ dó n’ejiŋ yay iki múgat go butum simetar futoh ni súuba. ");
INSERT INTO bqj_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Min ñer waf waw waife me ᵽe waamme n’ettam uĉet : újogum n’upu waw, sihaj sasu, súnuhureŋ sasu, wánowan wáfulore me n’ettam bi ni bugan bugagu ró, ");
INSERT INTO bqj_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","wáfowaf waife me ban nuĉin n’ettam, nulojo uk’uĉet. ");
INSERT INTO bqj_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mamu Atúla anemen me waf waw ᵽe waamme n’ettam, iki ŋaño to Nóe ni buganol ni waf waw ᵽe waam dó me ni busana babu. ");
INSERT INTO bqj_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Gunah ekeme ni úvi gúuba ni guñen (150), mal mamu ni muroŋ n’eguben ettam yay múharo. ");
INSERT INTO bqj_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Bare Aláemit naroŋ ᵽoᵽ n’gaᵽinor mala Nóe, súnuhureŋ sasu ni sihaj sasu saamme ni busana babu. Min ainnul érus bi ékasul mal mamu. ");
INSERT INTO bqj_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Súbula sasu saa fal fámah bi ni sílinga émit ró ni sutojo, émit yay may nehat galub. ");
INSERT INTO bqj_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","No baj me gunah ekeme ni úvi gúuba ni guñen (150), mal mamu ni múkasulo jatito-jatito ");
INSERT INTO bqj_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","uk’uĉiga funah fafu fakan me gaat ni gúuba faa fieñ fafu fakan me futoh ni gúuba, busana babu m’butaj fatiya firijaŋ fafu fo guvoge me Ararat. ");
INSERT INTO bqj_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mal mamu ni muroŋ n’ékasulo bi funah fítiar faa fieñ fafu fakan me guñen, no gurijaŋ gagu gutiulo me. ");
INSERT INTO bqj_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nóe natajen airigen gunah úvi gúuba balama ápegul elajen yay yo nakan me ni busana babu, ");
INSERT INTO bqj_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","aban nahalen gaganar gúit nihi gujow n’gúbbañul iki mal mamu muñah. ");
INSERT INTO bqj_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nahalen may gálab bi ejuh ter mal mamu muhae. ");
INSERT INTO bqj_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bare gálab gagu gujugut tiñ tahae to gújue gulo, min ñer gúbbañul bi ni busana babu, mata mal mamu murondoŋ. Nóe naalen gañenol min ájogul go árur dó ni busana babu. ");
INSERT INTO bqj_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nabbañ airigen gunah futoh ni gúuba bala abbañ ahalen go n’gúit. ");
INSERT INTO bqj_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","No gubbañulo me gállim, n’gútebul ni gáñin go gatoj gajeb gaa bice bununuh gajow bo buoliv. Ñer Nóe naffas búoh mal mamu múkasuloe faŋ n’ettam yay. ");
INSERT INTO bqj_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Natajen airigen guce gunah futoh ni gúuba, nabbañ ahalen go, n’gúit n’gufa bo. ");
INSERT INTO bqj_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Funah fítiar faa fieñ fítiar fal émit evugul, gannay gaugu no Nóe abaj me símit sikeme futoh ni yanur ni émit yanur (601), mal mamu mo bajuer ehay. Ñer Nóe náᵽuren firihinjaŋ busana babu. Naluj tíyaŋ najuh búoh ettam yay ehahay. ");
INSERT INTO bqj_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mb’uĉiga ni fieñ fúuten fo babajer gunah ávi ni futoh ni gúuba, ettam yay yo bahaer was, ");
INSERT INTO bqj_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Aláemit naah Nóe : ");
INSERT INTO bqj_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","« Uᵽúrul ni busana babu, aw, aari, guñoli ni waaril ! ");
INSERT INTO bqj_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Uᵽúnnul may súnuhureŋ sasu ᵽe, upu waw, sihaj sasu, bi ni sáfulore me n’ettam ró, min mbi sitey siban babu ᵽe, ni sibbañ subugor simmeŋen mof mamu. » ");
INSERT INTO bqj_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ñer Nóe náᵽurul ni aarol, guñolol ni waaril ró. ");
INSERT INTO bqj_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Súnuhureŋ sasu may ni súᵽurul ᵽe, sánosan ni ganogor so, bi ni sáfulore me n’ettam yay ni upu waw ró. ");
INSERT INTO bqj_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Mbiban, Nóe nateᵽ físimenum bi n’Atúla, naŋar tánotan ni súnuhureŋ sasu sáari me sice bi may n’upu waw wáari me ró bi bísimen Atúla : namuh so, aban naremben so to min asaen so iki sirem. ");
INSERT INTO bqj_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Atúla no naun me gatiŋ gagu gásum me gaa bísimen babu, ni súmol. Naah m’biinumol : « Maer mat’ibbañ itab ettam yay mala búkanum arafuhow. Maagen, újogum ni fiñileol, biinumol maarat bare nihi biᵽinor ekan. Ban mat’ibbañ inemen wáfowaf waife me n’ettam, ti nikanen mo me. ");
INSERT INTO bqj_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nánonan no mof mamu muroŋe n’ebaj, buroh ni eᵽit, ñutot ni ésuᵽa, fujam ni fiye, etufunaha ni efuga ᵽan síni to bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ᵽúrto, Aláemit násonien Nóe ni úᵽurol naagil : « Mbi jubugor iki jimmeŋen mof mamu. ");
INSERT INTO bqj_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Maer súnuhureŋ sasu ᵽe, upu waw, sáfulore me n’ettam, bi ni suol sasu ró, ni guñenul nihat so. Ᵽan súhollul nár. ");
INSERT INTO bqj_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Waf waw ᵽe waroŋ me, ban nugoror, nisenulwosen, ti nisenul me may waf waw ᵽe waileul me n’ettam ; dó ᵽe bi fitiñul. ");
INSERT INTO bqj_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bare jambi jitiñ ellu ni físim yo ró, mata físim fo fiĉil me buroŋ. ");
INSERT INTO bqj_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mala éyu físimul, ᵽan iroren fo nánonan no fúuyoe ; énuhureŋ emuh me an, ᵽan iroren yo. An ᵽoᵽ amuh me apalol, ᵽan irorenol yo. ");
INSERT INTO bqj_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","An áyu me físim apalol, ace ᵽan áyu fola, mata Aláemit ni ganogorol nátulum me arafuhow. ");
INSERT INTO bqj_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Neegul mbi jubugor min jifaŋ jammeŋ. Mbi gabugorul guvisor ni mof mamu ᵽe iki gummeŋen mo. » ");
INSERT INTO bqj_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Aláemit natajen aagil : ");
INSERT INTO bqj_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","« Injé, babugeom ᵽan ijogor bo ni buru ni gabugorul. ");
INSERT INTO bqj_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Babuge baubu ᵽan bíni to may bi ni upu waw, sihaj sasu ni súnuhureŋ sasu, waf waw ᵽe waife me waamen dó me ni busana babu, ni wawu ᵽe wajae me ebugi ni mof. ");
INSERT INTO bqj_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Babuge baubu bo buomme ube : mati bañ mús baj báyuer mal ti babu banemenen me ettam yay. » ");
INSERT INTO bqj_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Natajen aagil : « Ᵽan ikan fúffasum faa babuge babu baamme n’etut ínje ni buru ni wáfowaf waamme ni buroŋ, bi egiten búoh ᵽan bíni to bi nánonan. Fúffasum fafu ufe : ");
INSERT INTO bqj_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Gaiba-émit ᵽan ibaŋ fatiya, mbi gúni fúffasum faa babuge babu baamme n’etut ínje ni ettam yay. ");
INSERT INTO bqj_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","No nijae me éᵽunnul úpar úni fatiya ettam yay min gaiba-émit gaugu gúᵽurul dó ni wo, ");
INSERT INTO bqj_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","no ᵽan iᵽinor me mala babugeom bo nijogor me ni buru ni waf waw ᵽe waamme ni buroŋ. Emít yay mat’ebbañ elub mal máamah iki minemen buroŋ babu ᵽe baa n’ettam ti no. ");
INSERT INTO bqj_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","No gaiba-émit gaugu gujae me éᵽurul n’úpar waw min ijuh go, ᵽan iosen babuge babu bo nikan me n’etut ínje ni wánowan waife me ni mof bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nabbañ aah Nóe : « Neegi me : Gaiba-émit gaugu go guomme fúffasum babuge babu baliŋ me bo nijogor me ni wánowan waamme m’buroŋ ni mof. » ");
INSERT INTO bqj_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Guñol Nóe gáᵽullo me ni busana babu, bugo guomme Sem, Ham ni Yafet. Ban Ham o abuh me Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Uñiaw ubuge gaamme gúfaji bugaa Nóe, bugo guomme sipay gufan bugaa bugan bugagu ᵽe gaĉin me ni mof. ");
INSERT INTO bqj_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nóe o aamme átiar eañ úbiñu. ");
INSERT INTO bqj_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Funah fice, narem bíñu yay ák’áhali. Ñer náᵽuren wañol ᵽe min afilo ni fúgulol enil erakel. ");
INSERT INTO bqj_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham aamme ᵽay Kanaan, nanogen dó natogol me enil erakel. Náᵽurul bi tíyaŋ ak’agiten yo gutiol. ");
INSERT INTO bqj_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","No nalobil yo me, Sem bugo ni Yafet n’guŋar gábil guremben n’ubandil min gunogen dó baa gúsolasola bi eke efut ᵽail. N’guluj ráli gayoŋil jambi gujuh ᵽail min akan me enil erakel. ");
INSERT INTO bqj_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","No fúhali Nóe fusar me, naun wo áᵽurol apuma akanol me. ");
INSERT INTO bqj_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ñer naah : « Ban itab Kanaan ! Mb’áni amigel ahu afaŋ me gatiti emigel gutiol ᵽe ! » ");
INSERT INTO bqj_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nabbañ aah : « Gasal ugu n’Atúla aamme Aláemit ala Sem ! Mbi Kanaan akan amigel Sem ! ");
INSERT INTO bqj_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mb’Aláemit asen Yafet mof mauŋe, ban mb’áuro ni gúggut Sem. Mbi Kanaan akan amigel may ala Yafet ! » ");
INSERT INTO bqj_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ᵽúrto báyuer mal mamu bájalo me, Nóe nabbañ aroŋ to símit sikeme sífaji ni úvi gúuba ni guñen (350). ");
INSERT INTO bqj_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Yaĉil me nak’aĉet o babajer símit sikeme futoh ni sibbagir ni úvi gúuba ni guñen (950). ");
INSERT INTO bqj_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","No báyuer mal mamu bámah babu búgat me, úᵽur Nóe gaamme Sem, Ham ni Yafet, n’gubuh úᵽur. Gabugoril uge : ");
INSERT INTO bqj_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Uᵽúr Yafet bugo guomme Gomer, Magog, Madai, Yavan, Tubal, Meĉeh ni Tiras. ");
INSERT INTO bqj_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer nabuh Aĉikenas, Rifat ni Togaruma ; ");
INSERT INTO bqj_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan o abuh me Eliĉa, Tarisis, ni may bugaa Kit ni bugaa Rodan. ");
INSERT INTO bqj_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Gabugor Yavan go guvisor me iki guĉin galam fal fámah ; n’gúfaculor fiil-fiil ésuh fo, mof fo ni gúlobum yo gúbuli. ");
INSERT INTO bqj_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Uᵽúr Ham bugo guomme Kuĉ, Misiraim, Put ni Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuĉ nabuh Seba, Havila, Sabuta, Raguma ni Sabuteka ; Raguma úᵽurol bugo guomme Ĉeba ni Dedan. ");
INSERT INTO bqj_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuĉ nabuh may ace áᵽur gajaol Nimurod. Nimurod ahumu o aamme atiga ámah átiar ni mof. ");
INSERT INTO bqj_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Náni ᵽoᵽ asaa ámah bújoŋor Atúla. Yo eĉil me bi jama nihi guoh : « Hari nakakan asaa ámah bújoŋor Atúla ti Nimurod. » ");
INSERT INTO bqj_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Súsuh sítinar saa ni fívietol so suomme Babel, Erek, Akad ni Kalune, so ᵽe ni mof mamu maa Ĉinear. ");
INSERT INTO bqj_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Náᵽur bo atos bi ni mof mice gajow mo Aĉur. Bo naju me súsuh sasu saa Niniv, Rehobot, Kelah, ");
INSERT INTO bqj_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ni Resen, yaamme n’etut Niniv ni ésuh yay yámah yay yaa Kelah. ");
INSERT INTO bqj_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misiraim o aamme ᵽay afan ala bugaa Lud, Anam, Lehab, Nafutuh, ");
INSERT INTO bqj_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Paturos, Kasuluh ni Kafutor ; bugaa Kasuluh bugo guomme sipay gufan bugaa Ᵽilisit. ");
INSERT INTO bqj_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan nabuh Sidoŋ, aamme afamma, ni Hit ; ");
INSERT INTO bqj_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan o aamme may ᵽay afan bugaa Yébus, Amor, Girigaĉ, ");
INSERT INTO bqj_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiw, Aruk, Sin, ");
INSERT INTO bqj_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aruwad, Semar ni Hamat. Bugaa Kanaan gabugoril n’gummeŋ guban babu ᵽe, ");
INSERT INTO bqj_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ettamil neuŋ újogum Sidoŋ bi Gasa mbaa Gerar ; yo ejow me bi Sodom, Gomora, Aduma, Seboim bi bo Leĉa. ");
INSERT INTO bqj_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dáuru ᵽe gabugor Ham gúfaculor me fiil-fiil ésuh fo, mof fo ni gúlobum yo gúbuli. ");
INSERT INTO bqj_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, ati Yafet, nabuh may úᵽur. Ban Sem o aamme ᵽay afan ala Eber ni gabulakenol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Uᵽúrol bugo guomme Elam, Aĉur, Arupahad, Lud ni Aram. ");
INSERT INTO bqj_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram úᵽurol bugo guomme Us, Hul, Geter ni Maĉ. ");
INSERT INTO bqj_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arupahad o abuh me Ĉela abuh me Eber. ");
INSERT INTO bqj_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ahumu nabaj úᵽur gúuba : átiar gajaol Peleg (dóemme \"éfaculor\"), mata no naamme m’buroŋ, gaĉin me n’ettam yay gúfaculorfaculor. Atiol gajaol Yokutan, ");
INSERT INTO bqj_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","o abuh me Alumodad, Ĉelef, Hasarumavet, Yerah, ");
INSERT INTO bqj_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikila, ");
INSERT INTO bqj_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Ĉeba, ");
INSERT INTO bqj_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila ni Yobab. Dáuru ᵽe gabugor Yokutan. ");
INSERT INTO bqj_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bugo guĉin me n’etut Meĉa ni mof mamu maa gurijaŋ gagu gaa Sefar, galam bo tinah túᵽureul me. ");
INSERT INTO bqj_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dáuru ñer gabugor Sem. Bugo may n’gúfaculor fiil-fiil ésuh fo, mof fo ni gúlobum yo gúbuli. ");
INSERT INTO bqj_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Gaᵽin gabugor úᵽur Nóe, ésuh-ésuh bi ni fiil-fiil, tale guree. Guil gaugu, ni go bugan bugagu ᵽe gaĉin me ni mof gúᵽullo me, no báyuer mal mamu bámah babu búgat me. ");
INSERT INTO bqj_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","No bítinar, bugan bugagu ᵽe bugaa mof gúlobum ganur gubaje, bavogeril waf banur. ");
INSERT INTO bqj_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Funah fice, n’gúᵽurul bo tinah tiiyeul me. N’ejail n’gujuh eᵽarandaŋ baubu ni mof mamu maa Ĉinear n’guĉin dó. ");
INSERT INTO bqj_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","N’guoh : « Ujaal uk’uteᵽal síbirih, ubanal nusoal so. » N’gucokor síbirih so mbi síni me gubokenil, guban n’guŋar elahatiroŋ bi eholenor so. ");
INSERT INTO bqj_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","N’guoh : « Ujaal uk’uilenal ésuh, nuteᵽal may etah ebbah ék’égorul émit. Mamu ujaolal ᵽan uuno, ban mat’uvisoral ni mof. » N’guilo gúni n’gateᵽ. ");
INSERT INTO bqj_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ñer Atúla náaloul ákail bujuh ésuh yay ni etah yauyu so bugan bugagu guomme n’eteᵽ. ");
INSERT INTO bqj_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Aban naah : « Iní mamu gújaeul ekan bi nánonan, bugo ubugi gaamme bugan buganur, ban baloberil banur, wáfowaf mat’úju umindenil ni wo gumaŋ me ekan. ");
INSERT INTO bqj_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hani ! Fújuut fubaj ! Ualoal úk’úguñoral gúlobumil jambi gubbañ guunor ! » ");
INSERT INTO bqj_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Min ñer Atúla avisil ni mof mamu ᵽe, min gateᵽil gútij to. ");
INSERT INTO bqj_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Yo eĉil me n’gukan ésuh yauyu gajow gagu gaa Babel (dóemme \"éguñor\"), mata to Atúla águñor me gúlobum bugan bugagu bugaa mof mamu ᵽe, ban to navisil me guban babu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dáure gabugor Sem : Ᵽúrto símit súuba búsol báyuer mal mamu bámah babu, Sem nabuh Arupahad o babajer símit ekeme (100). ");
INSERT INTO bqj_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ᵽúrto, nabbañ aroŋ to símit sikeme futoh (500) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","No Arupahad abaj me símit ávi ni gaat (35), nabuh áᵽur navogol Ĉela. ");
INSERT INTO bqj_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ᵽúrto, nabbañ aroŋ to símit sikeme sibbagir ni símit sífaji (403) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","No Ĉela abaj me símit ávi ni guñen (30), nabuh áᵽur navogol Eber. ");
INSERT INTO bqj_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ᵽúrto, nabbañ aroŋ to símit sikeme sibbagir ni símit sífaji (403) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","No Eber abaj me símit ávi ni guñen ni sibbagir (34), nabuh áᵽur navogol Peleg. ");
INSERT INTO bqj_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ᵽúrto, nabbañ aroŋ to símit sikeme sibbagir ni ávi ni guñen (430) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","No Peleg abaj me símit ávi ni guñen (30), nabuh áᵽur navogol Réu. ");
INSERT INTO bqj_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ᵽúrto, nabbañ aroŋ to símit sikeme súuba ni símit futoh ni sibbagir (209) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","No Réu abaj me símit ávi ni guñen ni súuba (32), nabuh áᵽur navogol Sérug. ");
INSERT INTO bqj_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ᵽúrto, nabbañ aroŋ to símit sikeme súuba ni símit futoh ni súuba (207) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","No Sérug abaj me símit ávi ni guñen (30), nabuh áᵽur navogol Nahor. ");
INSERT INTO bqj_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ᵽúrto, nabbañ aroŋ to símit sikeme súuba (200) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","No Nahor abaj me símit ávi ni futoh ni sibbagir (29), nabuh áᵽur navogol Tera. ");
INSERT INTO bqj_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ᵽúrto, nabbañ aroŋ to símit ekeme ni gaat ni sibbagir (119) nabuh úᵽur ni sújur guce. ");
INSERT INTO bqj_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera no nabaj me símit úvi gúfaji ni guñen (70), nabuh úᵽur gúfaji gaamme Aburam, Nahor ni Haran. ");
INSERT INTO bqj_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dáure gabugor Tera : Uᵽúrol bugo guomme Aburam, Nahor ni Haran. Haran nabuh áᵽur gajaol Lot ; ");
INSERT INTO bqj_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","naĉet baubu Ur ni mof mamu maa Ĉalide, bo nabugi me ; no naĉet me, ᵽayol Tera to ni buroŋ. ");
INSERT INTO bqj_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aburam ni atiol Nahor n’guyab waare ; ala Aburam gajaol Sarai, ala Nahor o gajaol Milika, aamme bájur Haran ; Haran o abuh me may Yiska. ");
INSERT INTO bqj_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Bare Sarai affasut fufane, mata emotombo nakane. ");
INSERT INTO bqj_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Funah fice, Tera naŋar áᵽurol Aburam bugo n’aarol Sarai, naŋaror may gabulakenol Lot, áᵽur Haran. Min gúᵽur Ur ni mof mamu maa Ĉalide gujow guriŋen mbaa ni mof mamu maa Kanaan. No guĉih me n’ésuh yay yo guvoge me Haran, n’gunamo to. ");
INSERT INTO bqj_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera nak’aĉet to Haran o babajer símit sikeme súuba ni símit futoh (205). ");
INSERT INTO bqj_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Atúla nalob ni Aburam naagol : « Uᵽúr dáre ni mof mamu maamme míya, uhat fiili ni yaŋ ᵽai, min uilo ujow bi ni mof mice mo nijai me egiten. ");
INSERT INTO bqj_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ᵽan ikan min gabugori gúni ésuh yámah, ᵽan ísonieni, ban ᵽoᵽ nikan gajai guuno. Ᵽan mb’úni an ala gásonien bi ni bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Gajae me élikeni, ᵽan ísonienil. Bare gajae me eĉotiheni, ᵽan itabil. Míya, mb’ísonienum me guil gagu ᵽe gal ettam yay. » ");
INSERT INTO bqj_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ñer Aburam náᵽur ajow ti Atúla alobol yo me ; Lot nalagenol. No gúᵽure me ésugol Haran, Aburam o babajer símit úvi gúfaji ni gaat (75). ");
INSERT INTO bqj_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","N’ejaol nájaenum aarol Sarai ni áᵽur atiol aamme Lot. N’gújaenum fubajil ᵽe ni ᵽoᵽ umigel waw bugo gunom bo me Haran. Min gukay mbaa mof mamu maa Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","No guĉih me Kanaan, Aburam nasat mof mamu bi ni bununuh babu báñai me baa More, babu Siĉem. No, bugaa Kanaan bugo baroŋer dó n’eĉin. ");
INSERT INTO bqj_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Atúla náᵽurul Aburam naagol : « Dáure mof mamu mo nijae me esen guñoli ni gabulakenil. » Ñer Aburam naŋar sival nateᵽ to físimenum bi n’Atúla mala min áᵽullol to me. ");
INSERT INTO bqj_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Nafa bi ni mof mice maa gurijaŋ, galam Betel mbaa bo tinah talu tiiyeul me. Min ailen fúgulol fal ubaŋ n’etut Betel yaamme bo tinah tiiyeul me, ni Ai yaamme bo tinah tiave me. To may nateᵽ to físimenum fice bi n’Atúla min alaw to ni gajow Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mo may natos jatito-jatito ak’aĉih ni eᵽarandaŋ ece yo guvoge me Negev. ");
INSERT INTO bqj_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Gannay gace, bieb m’búloul dó n’ésuh yay. Maagen bieb baubu m’bújalo iki Aburam atennor ajow mbaa mof mice mo guvoge me Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","No gulof bo me, Aburam navoh aarol : « Sarai ! » Naagol : « Eé ? » Naagol : « Uuttenom. Niffase búoh aw anaare áarie faŋ. ");
INSERT INTO bqj_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Bugal Esíp no gujae me ejugi, ᵽan guoh : “Dáru aarol.” Ban ᵽan gumugom min guhali to. ");
INSERT INTO bqj_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mb’uboket uogil aw álinom ! Mamu ᵽan gujogom jon, ban aw ᵽan uĉil min iᵽagen súñunduom. » Naagol yoo. ");
INSERT INTO bqj_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","No guĉih bo me Esíp, maagen bugaa bo n’gujuh búoh aarol náariari nár ");
INSERT INTO bqj_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","iki ufan búgamah bugaa gávi gagu gulob ávi ahu mola n’gusalenol nímoro. O ñer naboñ guŋallol bi ni gávi gagu. ");
INSERT INTO bqj_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai aĉil me min ávi ahu aalen Aburam wári. Nasenol ubbarum, sijamen, síbe, musum máine ni maare ni suñokombo ; nasenol may uroka wáine ni waare. ");
INSERT INTO bqj_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bare Atúla nakan min mataño mámah múavul n’ávi ahu ni fiilol, dó ᵽe mala Sarai, aar Aburam o naŋar me. ");
INSERT INTO bqj_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Aví ahu návogul Aburam naagol : « Dáru bakaner bu ? Wa uĉil me uogutom dáru aari ");
INSERT INTO bqj_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","min ubutom nuogom dáru álini ? Min ínje iŋarol áni aarom ? Nibane n’aari. Uŋarol n’júᵽur tale ! » ");
INSERT INTO bqj_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ñer naboñ urokaol gúᵽurenil n’Esíp, aĉila n’aarol ni wafol ᵽe wo nabaj me. ");
INSERT INTO bqj_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aburam no náᵽullo me Esíp, nabbañ mbal eᵽarandaŋ yay yaa Negev, o ni aarol ni wafol ᵽe. Lot may nalagenol. ");
INSERT INTO bqj_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aburam nasanumet faŋ, nabaje sukore sámah, síralam ni ᵽoᵽ éurus yaguguy. ");
INSERT INTO bqj_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nah’ajow jatito-jatito Negev bi Betel. Námusene arobo tiñ tautu n’etut Betel ni Ai, ");
INSERT INTO bqj_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ban nailenen to físimenum. To Aburam alaw me Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot alageneol me, nabaje ᵽoᵽ ubbarum, sijamen ni síbe. Nabaje may gúgulol gal ubaŋ. ");
INSERT INTO bqj_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ban mof mamu miᵽilout mata mbi gúju gufenen dó sukoreil ᵽe. Min simmeŋ me nár, sújuut surobo tiñ tanur. ");
INSERT INTO bqj_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ban ᵽoᵽ bajene bugaa Kanaan ni bugaa Ᵽeris gaĉin dó. Funah fice, ukoña Aburam ni bugaa Lot n’gúrig. ");
INSERT INTO bqj_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ñer Aburam návogul Lot naagol : « Jamb’úriga ! Ukoñai ni búgumbam jambi gúrig may ! Let wola fiilola fanur ? ");
INSERT INTO bqj_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mof mamu umu mo nuluje me, gayoŋi. Ufáculora ! Ujow me mbaa gañen gárib, ínje ᵽan ijow mbaa gamay. Ujow me mbaa gamay, ínje mbaa gárib. » ");
INSERT INTO bqj_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ñer Lot náarul buulol najuh eᵽarandaŋ yay yo fal fafu fo guvoge me Suruden fusat me, ni fíjeben yo nímoro. Ban éguguf bi bo ésuh yay yaa Soar. Níme ti fíreŋ fafu fal Atúla, ti ᵽoᵽ Esíp yo fal fafu faa Nil nihi fíjeben me. No, Atúla m’bafumerut súsuh sasu saa Sodom ni Gomora saam dó me. ");
INSERT INTO bqj_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ñer Lot naĉob bi ni o eᵽarandaŋ yauyu ᵽe, aban najow abbañen mbaa bo tinah talu tiiyeul me. Mamu Lot ni Aburam gúfaculor me. ");
INSERT INTO bqj_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aburam aĉila narobo to Kanaan. Lot o nak’aĉin lof súsuh sasu saamme galam Suruden. Nailen gúgulol iki gúffus ésuh yay yaa Sodom. ");
INSERT INTO bqj_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Bare bugaa Sodom buroŋil buarat ; nihi guhajen n’Atúla, gutiletil ni o hóji faŋ. ");
INSERT INTO bqj_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","No Lot ávuh me akay, Atúla naah Aburam : « Uluj joon mbaa gayoŋi, mbaa búsoli, nuluj ᵽoᵽ mbaa gañeni gárib ni gamai : ");
INSERT INTO bqj_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ᵽan iseni bi nánonan ettam yauyu ᵽe yo nuluje me, aw, guñoli ni gabulakeni. ");
INSERT INTO bqj_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Gabugori ᵽan ikanil gummeŋ ti fuus. Nemme fuus an ájuut aᵽin fo, mati an may ájuil eᵽin. ");
INSERT INTO bqj_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Uilo nujow mof mamu min ujuh mo, mata aw nijae mo me esen. » ");
INSERT INTO bqj_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ñer Aburam natosen gúgulol ak’aĉin lof ununuh waw wáñai me waa Mámure galam Heboron. Nailen to físimenum bi n’Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Ni gunah gaugu, úvi guce n’gúni ni fitih. Bugo guomme Amurafel ala Ĉinear, Ariok ala Elasar, Kedor-Laomer ala Elam ni Tidal ala Goim. N’gutegor n’gutigen bugagu úvi gaamme Bera ala Sodom, Biriĉa ala Gomora, Ĉineab ala Aduma, Ĉemeber ala Seboim, ni ávi ahu ala Bela, yo guvoge me may Soar. ");
INSERT INTO bqj_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bugo futoh bugo gunonulo me, n’guemor ni eᵽarandaŋ yay yaa Sidim (to Fal Fasisesiset fuomme jama). ");
INSERT INTO bqj_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Mata ni fimigilet fal ávi ahu Kedor-Laomer guomene símit guñen ni súuba, bare ᵽúrto émit yanur n’guñiñet. ");
INSERT INTO bqj_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mb’uĉiga toon yo, Kedor-Laomer ni bugagu úvi gabbañ me búsolol n’guiyul n’gutigen ulatoril. N’guhek bugaa Refa galam Aĉetarot-Karunaim, bugaa Sus galam Ham, ni bugaa Em galam Ĉave-Kiriataim. ");
INSERT INTO bqj_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","N’guhek may bugaa Hor dó n’ésugil ni gurijaŋ gagu gaa Seir, n’guhattoril iki guĉih El-Paran, lof gafit gámah. ");
INSERT INTO bqj_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Mbiban n’gúbbañul mbal En-Miĉepat yo guvoge me may Kadeĉ, iki gufum ᵽe mof bugal Amalek, ban ni guhek bugal Amor gaĉin me Hasason-Tamar. ");
INSERT INTO bqj_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ñer úviaw bugaa Sodom, Gomora, Aduma, Seboim ni Bela yaamme Soar, n’gúᵽunnul ekosombilil gualen ni eᵽarandaŋ yay yaa Sidim, ");
INSERT INTO bqj_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","bi etigen to ávi ahu Kedor-Laomer ala Elam, ni may Tidal ala Goim, Amurafel ala Ĉinear ni Ariok ala Elasar : dóemme ñer úvi gono gubbagir n’gutigen gono futoh. ");
INSERT INTO bqj_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ban eᵽarandaŋ yay yaa Sidim, babaj ró usun wammeŋe wo guoh ró bi eŋar eukut wo yafige ban neñuget tem. No úviaw bugaa Sodom ni Gomora guomme n’etey, n’gulo ró. Bugagu gaᵽah me n’gutey bi ni gurijaŋ gagu. ");
INSERT INTO bqj_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Gahekil me, n’guram fubaj fafu ᵽe faamme Sodom ni Gomora, bi n’újej waw ró, min gukay. ");
INSERT INTO bqj_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot ásabul Aburam, nemme dó Sodom naĉine, n’gujogol may gújaenum ni fubajol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ace áine aᵽagulo bo nákail agiten yo Aburam aamme an ala Híbori ; nájoul ak’atogol to naĉin me galam ununuh waw wáñai me waa Mámure. Mámure ni gutiol gaamme Eĉekol bugo ni Aner, bugaa Amor gom, ban bugo néfajiil gubbabbañ búsol Aburam. ");
INSERT INTO bqj_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","No naun me búoh áᵽur atiol gujogoljoh áni amigel, Aburam naomen utigaaw gabugi to me ni fiilol gono sikeme sífaji ni gaat ni bugan gúfaji (318), aban nahattor ulatorol bi n’ésuh yay yo guvoge me Dan. ");
INSERT INTO bqj_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","No naĉih me, nagabor buganol mítiman-mítiman min anonil ni fuh. Nahek úviaw min ahattoril bi Hoba, babu galam Damas. ");
INSERT INTO bqj_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nábbañenul wafil ᵽe, náᵽagenul may áᵽur atiol Lot ni fubajol, ni ᵽoᵽ waareaw ni bugagu umigel. ");
INSERT INTO bqj_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","No Aburam aham me Kedor-Laomer ni ulagorol aban, náolul. Ñer ávi ahu ala Sodom náᵽurul iki guemor ni fíĉiĉilen fahahay faa Ĉave, fo guvoge me fíĉiĉilen Aví. ");
INSERT INTO bqj_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ni baj ᵽoᵽ ace ávi, gajaol Melikisedek, o ávi ala Salem, ban náni ásimena Aláemit-Fatiya. N’ejaol náŋarul unaĉ ni bíñu bi esen Aburam. ");
INSERT INTO bqj_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Násonienol min aagol : « Aláemit-Fatiya átut me émit ni ettam, mb’ásonieni ! ");
INSERT INTO bqj_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Usalal Aláemit-Fatiya aseni me sembe min uham ulatorai ! » Ñer Aburam náᵽuren fugab fanur ni gono guñen ni wo naramulo me ni fitih fafu asenol. ");
INSERT INTO bqj_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mbiban ávi ahu ala Sodom naagol : « Ubbañenom umigel waw min ubaŋ bi n’aw fubaj fafu fo nuŋallo me ! » ");
INSERT INTO bqj_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Bare Aburam naagol : « Iteb gañenom mbal Atúla, Aláemit-Fatiya átut me émit ni ettam, ");
INSERT INTO bqj_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","min ibbat : Ijéerit eŋar wáfowaf ni fubaji, hani jilaor jafulut me. Mamu mat’úju uoh : “Injé nitajentajen fubaj Aburam.” ");
INSERT INTO bqj_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","A-a, mat’ibaŋ wáfowaf bi n’ínje. Uᵽúren me wo buganom gutiñ me, ni may butum ulagorom gaamme Aner, Eĉekol bugo ni Mámure, babu ᵽe mat’iŋar. Ban bugo gúarie guŋar butumil. » ");
INSERT INTO bqj_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","No ᵽúrto me, Atúla náᵽurul Aburam min alobol firim faufe naagol : « Aburam, jamb’úholi ! Injé iomme ebangal yay yíya. Ᵽan iseni bacam bámah. » ");
INSERT INTO bqj_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Naagol : « Aláemit Atúla, ecamom bi wa ? Injé ume abajut maa añil ; Elieser ala Damas, o mb’aŋar me fubajom ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Natajen aagol : « Nemme usenutom gabugor, maer arokaom abugi me tale ni yaŋom, aĉila ñer niĉobe bi gafumom » ");
INSERT INTO bqj_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Atúla naagol : « Hani ! Let aĉila ajae me efumi, bare áᵽur o aw faŋai ujae me ebuh. » ");
INSERT INTO bqj_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Naban nakanol áᵽur tíyaŋ naagol : « Uháken émit yay nuᵽin suut sasu eno nújue. » Nabbañ aagol : « Gabugori mo may gujae me emmeŋ. » ");
INSERT INTO bqj_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Min Atúla alobol me, Aburam nabaj gafium. Ni gafiumol, Atúla najogol an aĉole. ");
INSERT INTO bqj_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Naagol : « Injé iomme Atúla áᵽunnuli me baubu Ur ni mof mamu maa Ĉalide, bi eseni mof maume dó nuom ma maer min mbi míni míya. » ");
INSERT INTO bqj_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aburam naagol : « Aláemit Atúla, bu níjue iffas búoh mof maume ᵽan míni múmbam ? » ");
INSERT INTO bqj_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Naagol : « Uŋallom buyan ni fubaah ni gabbarum gáine, yánoyan nebaj símit sífaji, ni ᵽoᵽ júrun ni etalab. » ");
INSERT INTO bqj_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aburam naliᵽ so ᵽe, aban najas sihaj sasu min abaŋ ujas waw úᵽimbor úuba-úuba. Bare upu waw, ajasut wo. ");
INSERT INTO bqj_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ñer súgutum sasu nihi síavul bi etiñ wo, bare Aburam naham so. ");
INSERT INTO bqj_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","No tinah talu tujon me, Aburam umoyol núlii gámori. Efuga yay nemoĉ, gáholi gámah n’gunogenol. ");
INSERT INTO bqj_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ñer Atúla naagol : « Neegi maa : Gabulakeni ᵽan guĉin ni mof malet molil. Ᵽan gukan umigel, ban ᵽan gúlamenil símit sikeme sibbagir (400). ");
INSERT INTO bqj_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bare ᵽúrto, ᵽan iteh úlamenail gúteh go nuffase, iki guhalil n’gukay ni fubaj fammeŋe ró. ");
INSERT INTO bqj_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bare aw ᵽan fúfanumi fúari uk’uĉet min gufogi n’gásumay. ");
INSERT INTO bqj_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ñer no gabulakeni gujae me eĉih ni jabbah jabarigen, no gujae me éolul bi Kanaan. Mata ᵽan bugal Amor gukanerut maarat iki miᵽilo min ihamil n’ésuh yauye. » ");
INSERT INTO bqj_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","No fíbiñu fafu fualo me, efuga yay nérim, to baenah sambun ni súᵽurul to ni fakor so ró, sígat ñaw n’etut ujas waw. ");
INSERT INTO bqj_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Funah faufu, fiĉila Atúla aĉob me bi ejogor babuge baliŋe ni Aburam. Naagol : « Mof maume, ᵽan isen mo guñoli ni gabulakenil, újogum ni fal fafu fal Esíp bi ni fafu fo guvoge me Afúrat. ");
INSERT INTO bqj_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Gaĉin dó me, bugo guomme bugaa Ken, bugaa Kenis, bugaa Kadimon, ");
INSERT INTO bqj_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","bugaa Hit, bugaa Ᵽeris, bugaa Refa, ");
INSERT INTO bqj_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","bugaa Amor, bugaa Kanaan, bugaa Girigaĉ ni bugaa Yébus. » ");
INSERT INTO bqj_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, aamme aar Aburam, asenutol añil. Bare amigelol Hagar ala Esíp umu to. ");
INSERT INTO bqj_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai naah Aburam : « Nujuge búoh Atúla náfiromfir jamb’ibaj añil. Neege uŋar amigelom min jifilo, tima ñace nabajom áᵽur. » Naagol yoo. ");
INSERT INTO bqj_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","No, Aburam o babajer dó Kanaan símit guñen. Ñer aarol Sarai nasenol amigelol Hagar ayab. ");
INSERT INTO bqj_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","N’gufilo, ban Hagar nateb. No najuh me búoh alet rakelol, nah’aluj afanol bukoñoñ. ");
INSERT INTO bqj_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ñer Sarai naah Aburam : « Hagar najeleomjel. Aw úarie ufoh elob yauye yal amigelom. Maagen ínje iŋarol iseni, bare aĉila no najuh me búoh nateteb, naĉotihenom. Mb’Atúla ataliŋola ! » ");
INSERT INTO bqj_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aburam naagol : « Leti dáru amigeli ? Wásumi me, nukanol ! » Ñer Sarai nafaŋ nálatiene abelol, bireg natey. ");
INSERT INTO bqj_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","No naĉih me n’ébula ece yaam m’bulago babu baa Ĉur, dó ni gafit gagu gámah gagu, nanamo náni n’gáelo. Ñer Atúla naŋar enil yal amalaka min áᵽullol to ");
INSERT INTO bqj_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","naagol : « Aw, Hagar, amigel Sarai, bay núᵽullo ? Bay nujae ? » Naagol : « Afanom Sarai nitee maa. » ");
INSERT INTO bqj_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Naagol : « Ubbañ bi n’afani, maer mb’úttun firimol. » ");
INSERT INTO bqj_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Natajen aagol : « Ᵽan iseni gabugor gámah iki an mát’áju go eᵽin. » ");
INSERT INTO bqj_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nabbañ aagol : « Aw umu m’bíteb, ban ᵽan ubaj añil ánaine. Ᵽan mb’uvogol Isimael (dóemme \"Atúla naune\") mata Atúla naune ukoŋi. ");
INSERT INTO bqj_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Añoli ᵽan áni ti asum yaheheh. Ᵽan ataj n’ésuh yay ᵽe, ban ésuh yay ᵽe ᵽan gutaj ni o. Ᵽan aĉin nevonol áhatulo gutiol ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ᵽúrto, Hagar naagoro : « Alobe me n’ínje, ban nalujom, o niluje maa ᵽiaŋ ? » Min avoh Atúla alobe me ni o \"Aláemit ajugeom me\". ");
INSERT INTO bqj_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yo eĉil me min guvoh maer éhaᵽa yauyu Lahai-Roi (dóemme \"Eháᵽa yay yal aroŋ me, ban najugom\"). Eháᵽa yauyu n’etut Kadeĉ ni Bered yom. ");
INSERT INTO bqj_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","No funagol fiĉih me, Hagar nabaj añil ánaine. Aburam nakanol gajow gagu gaa Isimael. ");
INSERT INTO bqj_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Emít yauyu, Aburam abaj me símit úvi gubbagir ni futoh ni yanur (86). ");
INSERT INTO bqj_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","No Aburam abaj me símit úvi gubbagir ni gaat ni sibbagir (99), Atúla nabbañ áᵽullol min aagol : « Injé iomme Aláemit-Sembe. Ᵽan mb’uroŋ ni gapoy gúmbam, ban nuaken nuh’ukan waf wanabe. ");
INSERT INTO bqj_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ᵽan ikan babuge baliŋe n’etulola, ban ᵽan iseni gabugor gámah. » ");
INSERT INTO bqj_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ñer Aburam náñuᵽ ak’aya fíringol n’ettam. Aláemit naroŋ bae n’elob ni o, naagol : ");
INSERT INTO bqj_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","« Babuge babu bolola, maa nijae bo ekan : Ᵽan úni ᵽay afan ala súsuh sammemmeŋ. ");
INSERT INTO bqj_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mati gubbañ guvogi Aburam, bare maer gajai ᵽan gúni Aburaham (dóemme \"ᵽaay súsuh sammemmeŋ\"), mata ᵽan ikani núni ᵽay afan ala súsuh sammemmeŋ. ");
INSERT INTO bqj_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ᵽan iseni gabugor gájaloe iki guᵽilo súsuh sammemmeŋ, ban úvi ᵽan gúᵽurul dó may ni go. ");
INSERT INTO bqj_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ᵽan ikan babuge baliŋe n’aw ni gabugori ni gabulakenil, jabbah bi ni jabbah, ban ᵽan bíni to bi nánonan. Mamu, ᵽan íni Aláemit úiya ni ᵽoᵽ ala ánoan ajae me éᵽurul ni gátuh gúiya. ");
INSERT INTO bqj_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kanaan nuĉine maer, ban mof maumu milet míya. Bare ᵽan iseni mo, aw ni guñoli ni gabulakenil. Min mbi míni molil bi nánonan, ti may ínje mb’íni me Aláemit olil. » ");
INSERT INTO bqj_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Aláemit natajen aah Aburaham : « Aw, gabugori ni gabulakenil, jabbah bi ni jabbah, ᵽan jíkanum babuge babu búmbam ni buru. ");
INSERT INTO bqj_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dáre mukanay mamu mo nimaŋ me jikan, aw ni gabugori ni gabulakenil ᵽe : Mbi áᵽur ánoan ni buru anogen búhut. ");
INSERT INTO bqj_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Dóemme fúffasum fafu faa babugeolal. ");
INSERT INTO bqj_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Jabbah bi ni jabbah, añil ánaine abaj me gunah futoh ni gúfaji, ᵽan anogen búhut. Ᵽan mb’ukan mo may umigel waw gabugi me ni yaŋi, ni ᵽoᵽ bugagu galet me ni fiili, bugo nunomulo me ni guñen sijaora. ");
INSERT INTO bqj_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mamu umigeli ᵽe ᵽan gunogen búhut, gabugi me ni yaŋi ti bugo nunomulo me. Bakiĉer babugeolal ᵽan bíni ró ni sinilul, mamu babuge babu ᵽan bunamo ni ánoan ni buru bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Anáine ánoan amaŋut me enogen búhut, ᵽan jíhatulol n’ésugol, mata ákanumut babuge babu búmbam ni buru. » ");
INSERT INTO bqj_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ᵽúrto, Aláemit naah Aburaham : « Neege maa : Aari, jamb’ubbañ uvogol Sarai (dóemme \"aseh ahu úmbam\"). Maer gajaol ᵽan gúni Saara (dóemme \"aseh\"). ");
INSERT INTO bqj_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ᵽan ísonienol min ikan nubaj áᵽur ni o. Maagen, ᵽan ísonienol mb’áni jaw afan ala súsuh sammemmeŋ, ban gabugorol ᵽan baj ró úvi bugaa súsuh. » ");
INSERT INTO bqj_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ñer Aburaham nabbañ áñuᵽ ak’aya fíringol n’ettam, náni n’eber, ban naagoro : « Injé abaj me símit ekeme, bu níjue ibuh añil ? Saara may abaj me símit úvi gubbagir ni guñen, nájue ᵽiaŋ aŋar far ? » ");
INSERT INTO bqj_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Naah Aláemit : « Samen ubaŋ Isimael ni gapoy gúiya, dáuru ᵽiloom. » ");
INSERT INTO bqj_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Naagol : « Mati fubaj ! Aari Saara, o ajai me esen añil. Ᵽan mb’uvogol Isak. Ᵽan ikan babuge baliŋe ni o ni gabugorol, ban ᵽan bíni to bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mala Isimael, niune wo nuroren me. Ᵽan ísonienol min mb’abaj gátuh gahulo. Ᵽan akan ᵽay bífesum baa bugan guñen ni gúuba, ᵽan akan ᵽoᵽ ᵽay afan ala ésuh yámah. ");
INSERT INTO bqj_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bare babugeom, bo, ni Isak ᵽan ikan bo, aamme áᵽur ahu o Saara ajai me esen toon tinah ti taute. » ");
INSERT INTO bqj_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","No Aláemit alob me n’Aburaham aban, nahalol to nakay. ");
INSERT INTO bqj_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ñer Aburaham naŋar áᵽurol Isimael ni may umigelol ᵽe, gabugi ró me ni yaŋol bi ni bugo nanomulo me ; dóemme ñer wáineaw ᵽe gaam dó me yaŋol. Balama tujon funah faufu, nakanil n’gunogen búhut, ti Aláemit alobol yo me. ");
INSERT INTO bqj_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Fo gunogen me, Aburaham o babajer símit úvi gubbagir ni gaat ni sibbagir (99), Isimael o símit guñen ni sífaji (13). ");
INSERT INTO bqj_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Mamu Aburaham, áᵽurol Isimael ni wáineaw ᵽe bugaa yaŋol gunogen me búhut funah fanur, gabugi ró me bi ni ganomuli me babu ni sijaora. ");
INSERT INTO bqj_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ᵽúrto, Atúla náᵽurul Aburaham galam ununuh waw wáñai me waa Mámure. Tufunah cay, o barover n’gánonum fúggut fafu fola, ");
INSERT INTO bqj_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","nake éarul buulol najuh wáine gono gúfaji guilo gulofol. To baenah naiyul to nanamo me atey iki guemor. Nasafil n’éñuᵽ ró bi n’ettam ");
INSERT INTO bqj_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","min aah anur ni bugo : « Súmenom nár uilen súndoom min icokori. ");
INSERT INTO bqj_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ᵽan isenul mal min juᵽos guolul, iban nikanul n’jíelo fattam bununuh baubua. ");
INSERT INTO bqj_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ᵽan isenul jitiñ, min jibaj sembe bi etos jitajen. Mamu mati jígat tale bamotoŋ. » N’guogol : « Yoo, ukan wo nulob me ! » ");
INSERT INTO bqj_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ñer Aburaham nanogen ni fúggut fafu ni majase, atoh ró Saara naagol : « Ukan cab nukib ucoᵽ úfaji n’eᵽori yafaŋ me jáari min ukanil unaĉ ! » ");
INSERT INTO bqj_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mbiban, natey mbal ekoreol naĉob ró furafen falie bib asen arokaol acokor ni majase. ");
INSERT INTO bqj_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","No ellu yay eñulo me, Aburaham nátebul yo aalenil, nabaŋil to ᵽoᵽ efene ni míi maalut, min gutiñ. No guomme ni fitiñ, nailo to fattam bununuh babu alofil. ");
INSERT INTO bqj_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ejaora yay n’gurorenol : « Aari Saara umelo ? » Naagil : « Umu ró ni fúggut fafu. » ");
INSERT INTO bqj_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ace ni bugo naagol : « Toon tinah ti taute ᵽan íbbañul, ban ᵽan itoh aari o babajer áᵽur. » Kan Saara umu n’gánonum fúggut fafu naiye búsol Aburaham, min áni n’eutten. ");
INSERT INTO bqj_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nemme Aburaham bugo ni Saara gúfanumfanum, ban Saara maer nahahat ejuh fieñ, ");
INSERT INTO bqj_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","naber ñáraru aah : « Awa til ! Injé áfanum maa, áinom may mo, biinumom ᵽan bubbañ ᵽiaŋ biteb mbaa gafilo ? » ");
INSERT INTO bqj_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ñer Atúla naah Aburaham : « Wa uĉile Saara naber ? Wa uĉile naᵽinor búoh o náfanumfanum mámah bi ebaj uñil ? ");
INSERT INTO bqj_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Baje ᵽiaŋ uce wo Atúla ájuut ? Neegiseh, toon tinah ti taute, no nijae me ébbañul yaŋi, Saara ᵽan abaj áᵽur. » ");
INSERT INTO bqj_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saara nemme naune, náholi naagol : « A-a, iberut ! » Atúla naagol : « Eé, nubeber ti maagen. » ");
INSERT INTO bqj_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","No ejaora yay guilo me bi ekay mbaa Sodom, Aburaham nátinenil bi ni jirijaŋ jice to gúju me guŋanden ésuh yay yaa Sodom. ");
INSERT INTO bqj_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Atúla naah : « Mat’íju ikoen Aburaham wo nijae me ekan. ");
INSERT INTO bqj_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Mata ᵽan áni ᵽay afan ala ésuh yámah, ban nebaj sembe. Ni gajaol ᵽan ísonien súsuh sasu ᵽe saa mof mamu. ");
INSERT INTO bqj_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","O niĉobe bi egiten guñolol ni gabulakenil bu gujae me eroŋ gúboñ gagu gúmbam, min gukan wanab me ban nuĉol. Mamu, firim fafu fo nilobol me, ᵽan ikan fo. » ");
INSERT INTO bqj_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Naah Aburaham : « Nuffase bugaa Sodom ni Gomora, niune walobei me uya ni bugo, wáhoji me nár, batileril bújalojalo iki gát. ");
INSERT INTO bqj_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Bare min iune maa molil, mo gukane ᵽiaŋ ? Ᵽan ialo bi bo ik’ijuh táh ter maagen. Iní let mo, ᵽan iffas may. » ");
INSERT INTO bqj_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ñer gúuba n’ejaora yay n’gujow guriŋen mbaa Sodom ; min Aburaham aŋaño to bújoŋor Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aburaham nátosul alofol min aagol : « Ti maagen, ᵽan umuh anab mimanur ni anabut me ? ");
INSERT INTO bqj_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Júe baj dó Sodom bugan úvi gúuba ni guñen ganabe. Ñer mat’uboket ésuh yauyu bi eᵽagen bugo gaĉin dó me ? Maagen joon ᵽan unemenil ? ");
INSERT INTO bqj_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","A-a, újuut ukan waf ti wauwu ! Aín ! Umuh an anabe mimanur ni an anabut ! Ujoh an anabe ti an anabut ! Aw, ataliŋa ahu ala mof mamu ᵽe, újuut mat’uĉol, dáru júut baj ! » ");
INSERT INTO bqj_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Atúla naagol : « Yoo, itoh ró me bugan gono úvi gúuba ni guñen ganabe, ᵽan iboket ésuh yay molil. » ");
INSERT INTO bqj_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aburaham nabbañ alob naagol : « Uboketom, ínje aᵽilout me wáfowaf, gakañen gaugu go nibaj me min ilob n’aw. ");
INSERT INTO bqj_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ñace júe mati gutoh bugan úvi gúuba ni guñen ; júe ŋañoil bugan gono futoh. Ᵽan ñer ufum ésuh yauyu mata bugan bugaubugu gaamme futoh ? » Naagol : « Yoo, itoh ró me bugan úvi gúuba ni futoh ganabe, mat’ifum yo. » ");
INSERT INTO bqj_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aburaham natajen aagol : « Gújue guᵽilo bugan úvi gúuba. » Naagol : « Mati baemul ifum yo molil gaamme úvi gúuba. » ");
INSERT INTO bqj_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Naagol : « Jambi fiiñi fitiñ ínje amigeli balober itajen. Júe may kan bugan ávi ni guñen ganabe bare guom dó. » Naagol : « Itogil dó me gono ávi ni guñen ganabe, mat’inemen yo. » ");
INSERT INTO bqj_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aburaham natajen aagol : « Uboketom min ikañen me ibbañ íni n’eroreni. Ter may butum bugan ávi guom dó ganabe ? » Naagol : « Bugan ávi ganabe gúni ró me, mat’ifum ésuh yay. » ");
INSERT INTO bqj_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Aburaham nabbañ aagol : « Jambi fiiñi fitiñ ínje amigeli. Ban iroreni eroren ésola. Iní me bugan gono guñen ganabe guom dó barebare ? » Naagol : « Yoo, mat’ifum ésuh yay mala bugan bugaubugu ganab me gaamme guñen. » ");
INSERT INTO bqj_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Atúla no naban me etallor gurim gagu ni Aburaham, nakay. Min Aburaham áolul bi to naĉin me. ");
INSERT INTO bqj_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Emalaka gúuba bugagu n’guĉih Sodom tinah n’eseor. Lot anamoen me n’gánonum ésuh yay, no najugil me, najow iki guemor. Náñuᵽ ak’aya fíringol n’ettam bújoŋoril ");
INSERT INTO bqj_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","naagil : « Juboket jújoul jialen súndoom, min isenul mal n’juᵽos guolul, n’júmori to bi gajem ni bujom, jiban n’jujow bulagoul. » N’guogol : « A-a, ᵽan júmori tíyaŋ n’eŋam yay. » ");
INSERT INTO bqj_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bare Lot narondopenil nár iki gújoul gunogen dó ni yaŋol. Naalenil wári, nakanil unaĉ gutiñ. ");
INSERT INTO bqj_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bugo m’banonerut, wáineaw bugaa Sodom, bajut anafan, bajut áᵽur, n’gújoul ᵽe iki gúgot yaŋ yay gúharo. ");
INSERT INTO bqj_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","N’guvoh Lot n’guogol : « Wáineaw ganonulo me yaŋi n’efuga yauye, ubugelo ? Uᵽúnnuloliil min jifilenil ! » ");
INSERT INTO bqj_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ñer Lot náᵽurul ailo n’gábbiruol nabbañen ganegenol apeh. ");
INSERT INTO bqj_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Naagil : « Gutiom, nilaul jambi jikan ejaoraom maarat maumu. ");
INSERT INTO bqj_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nibaje sújur gúuba gaffasut wáine. Isenul bugo, min jikanil wásumul me. Bare wáineaw ubuge, jambi jikanil wánowan ! Injé íurenil, ban níarie ipoil. » ");
INSERT INTO bqj_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","N’guogol : « Ufaren m’baaba ! » N’guogor : « Ujugom sum áine ahumu ! Aĉila aamme ajaora, ᵽan agitenolal bu nujaale buroŋ. » N’guogol : « Unah ! Ᵽan jikani wafaŋe núhojie wo jimaŋen me ekanil ! » N’gufatikenor Lot ni sembe, n’gúgat bi efaken ganegen gagu gural dó. ");
INSERT INTO bqj_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bare emalakaay n’gúᵽurul gujoh Lot ni guñen gúñagul gúrur dó min gupeh. ");
INSERT INTO bqj_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","N’gúpimen wáineaw ᵽe gaamme tíyaŋ, bajut anafan, bajut añil, jambi gúju gujuh ganegen gagu. ");
INSERT INTO bqj_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ñer emalakaay n’guoh Lot : « Nubaje babe bugan bugaa fiili ? Ter guoli, úᵽur, sújur, an ace ala fiili ? Mb’úᵽunnil gúrali n’ésuh yauye ! ");
INSERT INTO bqj_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Efum yo jíjaeul bo. Mata Atúla naune maarat mamu mo gulobe me guya ni bugal ésuh yauye. Yo eĉil me naboñulóli bi efum yo. » ");
INSERT INTO bqj_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ñer Lot najow ak’atoh gaᵽañ me sújurol naagil : « Júᵽur dáre cab ! Mata Atúla ᵽan afum ésuh ye. » Bare bugo n’guoh ter súbunen naam ni so. ");
INSERT INTO bqj_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","M’bujom mej, emalakaay n’gusommen Lot mala min ailo ajow cab. N’guogol : « Uilo nuŋar aari ni sújuri gúuba gaamme tale, min jujow ! Jikanut mo me, ᵽan jiĉet mimanur ni bugal ésuh yauye. Maagen, ᵽan jitegil mala búlaᵽutil. » ");
INSERT INTO bqj_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot alet n’esommen, ñer emalakaay n’gujogil n’guñen, aĉila, aarol ni sújurol gúuba, mata Atúla eᵽagenil namaŋe. Min gújaenumil iki gúᵽur ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","No guĉih me babu, ace ni emalakaay naah Lot : « Utey bi eᵽagen súñundui ! Jamb’ujegor búsoli, jambi ᵽoᵽ uilen tánotan n’eᵽarandaŋ yauye ! Utey mbaa gurijaŋ gagu jamb’uĉet ! » ");
INSERT INTO bqj_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot naagol : « Hoj ! Uboketom, mat’íju etey yauyu. ");
INSERT INTO bqj_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Maagen nukanomkan maaro. Nugitenom gábbolii min uᵽagenom me súñunduom. Bare íjuut itey ik’iĉih baubu ni gurijaŋ gagu. Bala iĉih bo, eĉet yay ᵽan etobenulom min emugom. ");
INSERT INTO bqj_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Leti nujuge júsuh jaujua ? Jo níjue itey bi bo, mata jíraliut, ban jititititi. Uboketom nik’imeo bo ! Mamu ᵽan iroŋ. » ");
INSERT INTO bqj_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Amalaka ahu naagol : « Yoo, ᵽan ibbañ íttun gúcini. Júsuh jauju, ilet jo n’efum. ");
INSERT INTO bqj_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Utey cab uk’ukoᵽ ró, mata íjuut ikan wáfowaf aw m’baĉigerut. » Yo eĉil me min guvoh jama júsuh jauju Soar (dóemme \"titititi\"). ");
INSERT INTO bqj_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot nak’aĉih bo tinah n’éᵽurul. ");
INSERT INTO bqj_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ñer Atúla nábenul fínir ni gávuh gásusuᵽ ban ni guᵽut táñi, ni súsuh sasu saa Sodom ni Gomora. ");
INSERT INTO bqj_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Min anoñen súsuh sausu, bugala so ᵽe, bi n’eᵽarandaŋ yay ᵽe ni wailo ró me. ");
INSERT INTO bqj_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ban aar Lot nak’ejegor búsolol, enilol nébaho misis wak kaŋ ti gajil. ");
INSERT INTO bqj_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Tihalen fo ni bujom mej, Aburaham náᵽurul ajow bi ni jirijaŋ jaju to nailoen me bújoŋor Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Náarul buulol naluj abbañen mbaa Sodom ni Gomora bi n’eᵽarandaŋ yay ᵽe. Naŋanden bo fakor fatiya ti faa sambun sámah. ");
INSERT INTO bqj_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Aláemit no naamme n’efum súsuh sausu, naosen galoloboril bugo n’Aburaham ; no naamme may n’ejow bi ehajen to Lot aĉinen me, náᵽunnulol bi eᵽagenol ni gabao gagu. ");
INSERT INTO bqj_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nemme Lot náholiholi biĉin Soar, náᵽur dó ajow ak’aĉin ni gurijaŋ gagu, aĉila ni sújurol. Niki guĉin ni gaun gace gaam dó ni gurijaŋ gagu. ");
INSERT INTO bqj_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Funah fice, bájurol afamma naah apuma : « Ᵽayola náfanume, ban ni mof maume bo nuomal ma, bajut ró wáine gajaola búyab, ti ᵽi to me n’ekani. ");
INSERT INTO bqj_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ujaa usena ᵽayola arem ák’áhali, min mb’újua ufiya ni o, mo ᵽan abaj gátuh ni wola. » Naagol yoo. ");
INSERT INTO bqj_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Elíma yauyu, n’guremen ᵽail ák’áhali. Mbiban afamma nákail afilo ni o, o m’baffasut nay bájurol akelo afilo búsolol, nay nailoe. ");
INSERT INTO bqj_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tihalen fo, afamma naah apuma : « Kanoe. Efuga yay yágat me, jifilofilo ínje ni ᵽayola. Ubbaña usenaol arem efuga yauye, min aw may ujow uk’ufilo ni o. Ni wola jaamme gúuba ᵽan ñer abaj gátuh. » ");
INSERT INTO bqj_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mb’uĉiga gállim, n’gubbañ guremenol ák’áhali, min apuma may ajow iki gufilo. Lot abbañut áju affas nay bájurol akelo afilo búsolol, nay nailoe. ");
INSERT INTO bqj_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ñer sújur Lot gaamme gúuba n’guŋar gar gaa ᵽail. ");
INSERT INTO bqj_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Afamma no funagol fiĉih me, nabaj júᵽur, navoh jo Moab ; o aamme ᵽay afan ala bugaa mof mamu mo guvoge me may Moab bi jama. ");
INSERT INTO bqj_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Apuma no napegor me, nabaj may júᵽur, navoh jo Ben-Ami ; o aamme ᵽay afan ala bugaa mof mamu mo guvoge me Amon bi jama. ");
INSERT INTO bqj_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ᵽúrto, Aburaham náᵽur to naamme ajow bi n’eᵽarandaŋ yay yaa Negev. Nak’arobo to n’etut Kadeĉ ni Ĉur gueñ guman, balama atos ak’aĉin Gerar. ");
INSERT INTO bqj_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nah’aah bugan bugagu Saara álinol. Yo eĉil me, Abimelek aamme ávi ahu ala Gerar, no naun yo me, naboñ gujogol o. ");
INSERT INTO bqj_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bare n’efuga yay, Aláemit náᵽullol ni síyeut naagol : « Ᵽan uĉet mala aare ahumu o nujogulo me, mata náyaboyabo. » ");
INSERT INTO bqj_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nemme Abimelek agorerutol, naah Aláemit : « Aláemilom, maagen ᵽan umugóli ᵽiaŋ, ínje ni bugal ésugom, ban jiffasut to wáfowaf ? ");
INSERT INTO bqj_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Leti Aburaham naagom dáru álinol, ban aarol may naage maagen mo ? Ni biinum bakukur níkanum mo, ban ikanut waf wahojo. » ");
INSERT INTO bqj_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ni síyeut sausu, Aláemit naagol : « Niffase bae biinumi bukukur. Ban ínje ífireni egor aare ahumu jamb’util n’ínje. ");
INSERT INTO bqj_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Maer ubbañenol usen áinol. Ahumu aboñer nam, ban ᵽan alaw bi eᵽageni. Waf wanur núarie uffas : Ubbañenutol me, aw ni fiili ᵽe ᵽan jiĉet ti maagen. » ");
INSERT INTO bqj_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ñer Abimelek náiyali m’bujom aomen úvulaol min agitenil firim faufu. N’gúholi nár. ");
INSERT INTO bqj_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Naban návogul Aburaham naagol : « Bakaner bu nukanóli me ? Wa nikani mb’uĉilenóli ínje ni jáviom mbi jitilen gatil gáamah ? Wo nukanom me, an nd’akan wo apalol ! » ");
INSERT INTO bqj_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Natajen aagol : « Biinum bu nubaj me iki ukan mo ? » ");
INSERT INTO bqj_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Aburaham naagol : « Neegene, nemme bugan bugagu bugaa babe gúkanumut Aláemit, ᵽan gumugom mala aarom. ");
INSERT INTO bqj_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ban bakoŋom, wóli bálinay jom, mata ᵽayóli anur, bare jugumut jaay. Yo eĉil me niyabol. ");
INSERT INTO bqj_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","No Aláemit áᵽunneulom me ni yaŋ ᵽayom, neeh Saara : “Mb’uboket, tánotan to nujaae me eĉih, nuogil wola bálinay.” » ");
INSERT INTO bqj_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ñer Abimelek no nabbañeneol me aarol, nájogul ubbarum, sijamen, síbe, ni may umigel wáine ni waare asenol. ");
INSERT INTO bqj_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Naagol : « Ettamom uye yo nuluje me. Tásumi me, nuk’uĉin ! » ");
INSERT INTO bqj_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Naban naah Saara : « Nujuge, ban isen álini sifaraku sono éuli. So mbi súᵽuren me ñusui bújoŋor bugani. Dó jae me egiten búoh aw uffasut to wáfowaf n’elob yauyu. » ");
INSERT INTO bqj_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ñer Aburaham nalaw Aláemit min átojul Abimelek, aarol ni urokaol waarema ᵽe gaam dó me yaŋol, mata Atúla natojeniltoj no Abimelek ajoh me Saara aar Aburaham. Min ñer gúju gubbañ gubaj uñil. ");
INSERT INTO bqj_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ᵽúrto, Atúla nakan Saara firim fafu faa gásumay gagu fo nalobol me fíllim, ");
INSERT INTO bqj_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","min Saara aŋar far ak’apegor may tinah talu to Aláemit alobol me, ban Aburaham o báfanumer faŋ. ");
INSERT INTO bqj_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aᵽúr ahu o Saara asenol me, navogol Isak. ");
INSERT INTO bqj_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nanogenol búhut o babajer gunah futoh ni gúfaji ti Aláemit agitenol me. ");
INSERT INTO bqj_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Gannay gaugu, Aburaham o babajer símit ekeme (100). ");
INSERT INTO bqj_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ñer Saara naah : « Aláemit nakanom eber yal ésumay ! Anóan ajae me eun gabugi gauge gal Isak, ᵽan aber mimanur n’ínje. » ");
INSERT INTO bqj_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Natajen aah : « Ay ájuene aah Aburaham : “Funah fice aari Saara ᵽan arafen añil” ? Maagen mamu, ínje ume asenol maa áᵽur ni fúfanumol. » ");
INSERT INTO bqj_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","No Isak ájalo me, Saara náᵽurenol garaf ; funah faufu, ᵽayol Aburaham nakan gaggan gámah. ");
INSERT INTO bqj_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ban Hagar áᵽullo me Esíp, nasene Aburaham añil ánaine, gajaol Isimael. Funah fice, Saara naŋandenol áni n’efiŋen jitiol Isak. ");
INSERT INTO bqj_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Naah Aburaham : « Uham amigel ahumu bugo n’añolol gujow ! Jambi áñum ake búgabor fubaj ᵽayol n’añol amigel ahumu ! » ");
INSERT INTO bqj_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Aburaham no naun me firim faufu, ni táñiol, mata mánoman níe, Isimael añolol om may. ");
INSERT INTO bqj_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bare Aláemit naagol : « Jambi táñii mala añoli ni mala amigeli ! Wánowan wo Saara aroreni me, nukan wo. Mata Isak aĉila ajae me eseni gátuh gagu go nilobi me mala go. ");
INSERT INTO bqj_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mala áᵽur amigeli, aamme ᵽoᵽ añoli, ᵽan isenol may gátuh guᵽilo bi eilen ésuh. » ");
INSERT INTO bqj_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tihalen fo m’bujom mej, Aburaham nailo ñer ák’áŋarul unaĉ, nakan mal ni baet baa gabaŋ, naban naŋar asen Hagar. Náŋarul Isimael asenol ni gañen min gukay. Min gujow gualo bo n’gafit gámah gaa Beer-Ĉeba, nih’iki gulilimbor bo. ");
INSERT INTO bqj_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","No malil mubao me, Hagar naŋar añil ahu ak’abaŋ fattam jununuh, ");
INSERT INTO bqj_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","aban náhatulo ak’anamo baaba, mata n’gaᵽinorol : amaŋut ajuh añolol min ajae me eĉet. To nanamo me, náni n’ukoŋ. ");
INSERT INTO bqj_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Aláemit naun ukoŋ waw wal Isimael. Dó n’émit, amalaka ahu návogul jaol naagol : « Wa ubaji ? Jamb’úholi ! Mata añoli to narobo me, Aláemit naune ukoŋol. ");
INSERT INTO bqj_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Uilo nujoh añoli ni gañen min uaken ! Mat’aĉet, ban ᵽan isenol gátuh gahulo. » ");
INSERT INTO bqj_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ñer Aláemit nakan Hagar najegor, min ajuh éhaᵽa. Najow ák’áij ammeŋen baelol baa gabaŋ gagu, min asen áᵽurol arem. ");
INSERT INTO bqj_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Aláemit napoy añil ahu. No nake me ájalo, naĉin bo n’gafit gagu, ban nakan ayaa fuŋajen ámah. ");
INSERT INTO bqj_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nak’aĉin n’gafit gagu gaa Paran. Min jaol aŋesol anaare ala Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Gannay gaugu, Abimelek nájoul ákail bujuh Aburaham ; nájaorul ni Pikol aamme afan ekosombilol. No guĉih me, Abimelek naah Aburaham : « Maagen Aláemit umu búsoli ni wánowan wo nukan me. ");
INSERT INTO bqj_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Maer mb’ubbat ni gajow gal Aláemit : Mat’úmus ubutom, ínje ni guñolom ni gabulakenom. Niᵽie n’ekani maaro, ñer aw may mb’ukan maaro bi n’ínje ni may mof mamu bo nuĉin ma. » ");
INSERT INTO bqj_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ñer Aburaham naagol : « Yoo, ᵽan ibbat fo. » ");
INSERT INTO bqj_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Bare Aburaham namundum aĉaf Abimelek mala éhaᵽaol ece yo uroka aĉila Abimelek gurame. ");
INSERT INTO bqj_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","O naagol : « Iffasut ay arok me dáuru. Bi jama ímusut iun elob yauyu, ban aw ᵽoᵽ ulobutom yo. » ");
INSERT INTO bqj_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ñer Aburaham nájogul ubbarum, sijamen ni síbe asen Abimelek, min mbi gujogor babuge. ");
INSERT INTO bqj_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ban Aburaham náᵽuren dó gubaah gal ubbarum gono futoh ni gúuba ahoh me. ");
INSERT INTO bqj_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Min Abimelek aagol : « Gubaah gaugu gaamme futoh ni gúuba, bi ekan bu ? » ");
INSERT INTO bqj_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Naagol : « Ᵽan iseni go n’gañenom bi egiteni búoh ínje ioge éhaᵽa yay. » ");
INSERT INTO bqj_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Yo eĉil me min guvoh tiñ tautu Beer-Ĉeba (dóemme \"éhaᵽa yay yaa gabbat\"), mata tautu bugo gúuba gubbat me. ");
INSERT INTO bqj_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ñer n’gujogor babuge babu to Beer-Ĉeba. Mbiban, Abimelek bugo ni Pikol n’guot mbaa mofol maamme maa Ᵽilisit. ");
INSERT INTO bqj_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","To Beer-Ĉeba, Aburaham naroh to bununuh bámah, aban nalaw to Atúla aroŋ me bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ni búuyol naĉin bo símit ni mof maumu maa Ᵽilisit. ");
INSERT INTO bqj_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","No ᵽúrto me, Aláemit namaŋ álingen gáinen Aburaham. Navogol : « Aburaham ! » Naagol : « Eé, ínje ume. » ");
INSERT INTO bqj_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Naagol : « Uŋar áᵽuri Isak, aamme érimbanii o numaŋ me mámah, min uilo ujow bi ni mof mamu maa Moria. Uĉih bo me, núsimenomol, ban nusaenomol ak’arem ni firijaŋ fafu fo nijai me egiten. » ");
INSERT INTO bqj_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tihalen fo m’bujom mej, Aburaham nailo ajis uyaj bi bísimen babu, aban naremben n’asumol fúrovum bi ejow yay. Naŋar urokaol gono gúuba ni áᵽurol Isak. Min gujow mbaa bo Aláemit agitenol me. ");
INSERT INTO bqj_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Funah fúfaten n’ejail, naŋanden bin babu bo gujae me. ");
INSERT INTO bqj_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Naah urokaol : « Buru jinamo tale n’asum yay ró. Injé n’áᵽurom ᵽan jujow bi baaba bi eke esal Aláemit. Mbi jiban, n’jíbbañul jutogul tale. » ");
INSERT INTO bqj_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ñer naŋar uyaj waw waa bísimen babu asen áᵽurol ateb ; aĉila naogen gumej gagu ni jiiba jaju, min gujaor. ");
INSERT INTO bqj_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","N’gujow maa, Isak naagol : « Ammay. » Naagol : « Añúm, ínje umu n’eutteni. » Isak naagol : « Uyaj ni gumej nuogenae, ñer fubaah fafu faa bísimen babu, ufela ? » ");
INSERT INTO bqj_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Naagol : « Añúm, Aláemit ajae egitenola bu najae me ekan min ubaja fubaah. » N’gujaor gutajen ");
INSERT INTO bqj_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","iki guĉih to Aláemit agitenol me. Min Aburaham ateᵽ to físimenum naremben uyaj waw fatiya. Naban nahoh Isak aremben fatiya uyaj waw. ");
INSERT INTO bqj_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","No nateb me jiiba jaju bi eramul áᵽurol, ");
INSERT INTO bqj_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","amalaka ahu ala Atúla navogulol fatiya bi ñúuba : « Aburaham ! Aburaham ! » Naagol : « Eé, ínje ume. » ");
INSERT INTO bqj_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Naagol : « Jamb’ugor áᵽur ahu, jamb’ukanol maarat mánoman ! Maer niffase búoh núkanumkanum Aláemit, mata ulalut esenol áᵽuri o nuffas me búoh érimbani om. » ");
INSERT INTO bqj_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ñer Aburaham nake ejegor najuh gabbarum gáine gugol n’usin go n’jununuh jice. Najow ák’ágolul go áŋarul ákail ásimen aban nasaen go iki gurem butum áᵽurol. ");
INSERT INTO bqj_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Min avoh tiñ tautu \"Atúla ᵽan ailo molola\". Yo eĉil me n’guoh to bi jama : « To ni firijaŋ faufu fola, Atúla ᵽan ailo mololal. » ");
INSERT INTO bqj_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Dó fatiya, amalaka Atúla návogul Aburaham áuten ");
INSERT INTO bqj_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","naagol : « Uutten wo Atúla aam n’elob : Nemme nukane dáure, min ulalut me esenom áᵽuri anur ahu, ti maagen ínje iomme Atúla ban ibbat ínje faŋaom : ");
INSERT INTO bqj_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ᵽan ísonieni faŋ mbi gabugori gummeŋ ti suut sasu, ti ᵽoᵽ fuus faa galam fal. Ᵽan mbi guhek ulatoril min guyab súsugil. ");
INSERT INTO bqj_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Molil nijae me ésonien súsuh sasu ᵽe saa mof mamu, mata aw nubabaj gákanumom. » ");
INSERT INTO bqj_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Aburaham nábbañul atoh bo urokaol, min gúolorul mbaa Beer-Ĉeba to naĉin me. ");
INSERT INTO bqj_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","No ᵽúrto me, n’guhoŋen guoh Aburaham : « Milika aamme aar atii Nahor, nabajolbaj may úᵽur : ");
INSERT INTO bqj_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","afamma gajaol Us, araf me asen Bús, mbiban Kemuel (abuh me Aram), ");
INSERT INTO bqj_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","atuten me Kesed, Haso, Ᵽilidaĉ, Yidilaf ni Betuel. » ");
INSERT INTO bqj_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ñer úᵽur bugaubugu gaamme futoh ni gúfaji, bugo Milika asen ma Nahor, aamme ati Aburaham. Apumail Betuel nabuh Rebeka. ");
INSERT INTO bqj_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Réuma, aar Nahor áuten o naᵽañut me, nabajol may uñil gubbagir gaamme Teba, Gaham, Tahaĉ ni Maaka. ");
INSERT INTO bqj_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara no nabaj me símit ekeme ni ávi ni futoh ni súuba (127), ");
INSERT INTO bqj_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","naĉet baubu Kiriat-Aruba baamme Heboron, ni mof mamu maa Kanaan. Ñer Aburaham nahul aarol n’ukoŋol ró. ");
INSERT INTO bqj_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Naban nahat to efuluŋ Saara, min ajow ak’alob bugaa Hit ");
INSERT INTO bqj_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","naagil : « Nemme ínje ajaora nem ni mof maumu maamme molul, nilaul junomenom ma fuyah. Min mb’íju ifoh ró aarom. » ");
INSERT INTO bqj_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","N’guogol : ");
INSERT INTO bqj_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","« Uuttenóli ᵽaa ! Aláemit akani min úni an ámah n’ésuh ye. Uĉob fufoh fafu fafaŋ me jáari ni guyagóli ᵽe, ban ánoan ni wóli mát’áfiri efoh aari ni fuyagol. » ");
INSERT INTO bqj_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ñer Aburaham nailo, mbiban náñuᵽ bi to n’ettam bújoŋoril ");
INSERT INTO bqj_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","naagil : « Iní maagen jimamaŋ ifoh aarom n’ésuh ye, n’jujow iki julobom Eforon áᵽur Soar. ");
INSERT INTO bqj_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Juogol ínje neege anomenom gaun gagu gaa Makupela, gaamme ni firijaŋ fafu bo galagol gútij me. Juogomol anomenom go ti gúari me gunomeni min mbi gúni gúmbam. » ");
INSERT INTO bqj_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kan Eforon ala Hit umu to n’etut bugal ésugol naroboe. Nábal Aburaham fatiya min mbi ésuh yay ᵽe gaam to me n’gánonum ésugol gúju guunol. Naagol : ");
INSERT INTO bqj_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","« Jamb’uyoh bo ! Mat’inomeni go, bare ᵽan íjii go. Níjii go ti maagen bújoŋor bugal ésugom ᵽe gaam ma tale. Min mb’úju ufoh ró aari. » ");
INSERT INTO bqj_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ñer Aburaham nabbañ áñuᵽ bújoŋoril. ");
INSERT INTO bqj_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Naban naah Eforon fatiya : « Uuttenom ᵽaa may ! Injé bi enom go. Ᵽan umaŋ bacam babu, mamu níju ifoh ró aarom. » ");
INSERT INTO bqj_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Naagol : ");
INSERT INTO bqj_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","« Jamb’uyoh bo ! Neege, waamme n’etulola ureut ni galah gaa sifaraku sikeme sibbagir. Ñer mb’ufoh ró aari. » ");
INSERT INTO bqj_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","No Aburaham autten me Eforon aban, namaŋ firimol. Min asenol bacam babu bújoŋor ésuh yay ᵽe ; maagen mamu, naŋar sifaraku so guᵽi me ni gucam ni so, aᵽin butum sono sikeme sibbagir so naunen me, asenol. ");
INSERT INTO bqj_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Mamu Aburaham abbanno me aĉil galah Eforon gaa bo Makupela, baubu Mámure, ni gaun gagu gaam dó me, bi n’ununuh waw ró. Ban bugaa Hit ᵽe gaam to me ni gánonum ésuh yay gumate ni funomen fafu. ");
INSERT INTO bqj_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","No bao me, Aburaham náŋarul efuluŋ aarol Saara ak’afoh ró n’gaun gagu gaa Makupela, galam Mámure baubu Heboron ni mof mamu maa Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Maer bugaa Hit guffase búoh galah gaugu dó fuyah fafu fuomme gúᵽure n’guñenil gúni ni gal Aburaham. Ñer nájue maer afoh ró buganol gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Maagen Aburaham náfanume faŋ, ban Atúla násonienolsonien ni wánowan. ");
INSERT INTO bqj_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Funah fice, Aburaham návogul afan urokaol aogen me fubajol ᵽe naagol : « Ugor fatamom ");
INSERT INTO bqj_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","min ubbat ni gajow Atúla aĉil me fatiya ni ettam uoh : Mat’uliᵽ bi n’Isak anaare ni sújur sasu saa babe Kanaan bo niĉin me. ");
INSERT INTO bqj_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bare ᵽan mb’ujow bi ni mofom dó ni fiilom uk’uliᵽulol dó anaare. » ");
INSERT INTO bqj_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Aroka ahu naagol : « Iní me ñer aare ahumu amaŋut alagenulom bi babe, níjaenum ᵽiaŋ áᵽuri bi ni mof mamu bo núᵽullo me ? » ");
INSERT INTO bqj_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Naagol : « A-a, jamb’újaenum bo áᵽurom ! ");
INSERT INTO bqj_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Uffas búoh Atúla aamme ala fatiya, akanom me níhalul fiilom ni mofom, aban nabbat aagom mof me ᵽan asen yo gabugorom, aĉila ᵽan áboñul amalakaol ayabi gayoŋ. Min mb’úju úŋesul anaare bi n’áᵽurom. ");
INSERT INTO bqj_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Iní me aare ahu amaŋut alagenuli, gabbati ñer gúᵽure. Bare mánoman níe, jamb’újaenum bo áᵽurom ! » ");
INSERT INTO bqj_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ñer aroka ahu nagor fattam afanol Aburaham min abbat ti nalobol yo me. ");
INSERT INTO bqj_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Naban naŋar wafaŋ me jáari ni fubaj afanol ájuᵽ ni suñokombo sono guñen sal afanol, min akay mbal ésuh yay yaa Nahor, baubu ni mof mamu mo guvoge me Aram Naharaim. ");
INSERT INTO bqj_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","No naĉih me n’éhaᵽa yay yalof me ésuh yay, bunaa báruser. Ban tinah tautu, waareaw nihi gúkail to me gáij. Nakan to suñokombo sasu min siya gújul. ");
INSERT INTO bqj_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Náni n’galaw aah : « Aw Atúla aamme Aláemit ala afanom Aburaham, ínje umu n’elai : Ukan min iemor jama ni o niŋese me ! Mamu mb’ugiten afanom Aburaham gábbolii. ");
INSERT INTO bqj_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Injé ume ninave lof éhaᵽa yay to sújur ésuh yay gújaeul me gáij. ");
INSERT INTO bqj_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ᵽan iroren ace ni bugo áñien jifinol min irem ; aagom me : “Urem, ban ᵽan isen ᵽoᵽ suñokomboi sirem”, ᵽan ñer iffas búoh aĉila nuĉobe bi n’Isak aamme amigeli. Mamu ᵽan ijuh me búoh nugitene afanom gábbolii. » ");
INSERT INTO bqj_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","O m’babanerut elob, ni baj bájur bice átebul jifin ni gabandol aĉigul. Gajaol Rebeka, bájur Betuel aamme añol Milika bugo ni Nahor, ati Aburaham. ");
INSERT INTO bqj_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ban bájur om áarie nár ; ámusut affas ánaine. Naalo bi n’éhaᵽa yay ák’ámmeŋenul jifinol min ábahoul. ");
INSERT INTO bqj_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Aroka Aburaham natey iki guemor, min aagol : « Uboket újiom jal n’jifini irem. » ");
INSERT INTO bqj_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Naagol : « Yoo, uyab urem ! » Nafaen áanul jifinol átuh ni guñenol bi esenol arem. ");
INSERT INTO bqj_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","No naban me, naagol : « Ᵽan íij may bi ni suñokomboi iki supoñ. » ");
INSERT INTO bqj_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Náulen to baenah jifinol ni gáremum sihaj sasu, aban nabbañ aalo ák’áijul mice mal. Mamu iki suñokombo sasu ᵽe supoñ. ");
INSERT INTO bqj_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Aroka ahu nah’alujol mamu m’balobut wáfowaf naagoro : « Atúla ᵽiaŋ nakakan bulagoom bútuen. » ");
INSERT INTO bqj_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","No suñokombo sasu sirem me siban, áine ahu nasenol eloŋuloŋ yal éurus yal eŋoben ni súñundu, ni ᵽoᵽ gúliñah gúuba gal éurus gáliie. ");
INSERT INTO bqj_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Aban naagol : « Uboket ugitenom ay abugi. Ulobom may ter yaŋ ᵽai baje tiñ to jújue júmori ínje ni buganom ? » ");
INSERT INTO bqj_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Naagol : « Injé Betuel abugom, o Milika abaj me ni Nahor. » ");
INSERT INTO bqj_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Natajen aagol : « Yaŋóli baje tiñ to jújue júmori, baje ᵽoᵽ mafos ni éful yammeŋe. » ");
INSERT INTO bqj_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ñer áine ahu náñuᵽ bi esal Atúla ");
INSERT INTO bqj_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","naagol : « Gasal gúni ni aw, Atúla, aamme Aláemit ala afanom Aburaham, aw agitenol me nánonan gábbolii ni músumi. Núĉibbenulom ĉol bi to ni fiil afanom. » ");
INSERT INTO bqj_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","To baenah, Rebeka natey bi ni jaol ak’agitenol wabaj me. ");
INSERT INTO bqj_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ban nabaje álinay gajaol Laban. Laban najuge eloŋuloŋ yay ni súñunduol ni gúliñah gagu gaamme ni guñenol. Nemme naune ᵽoᵽ bagitener álinol Rebeka, min áine ahu alob me ni o, ñer nailo atey atoh bo aroka Aburaham galam éhaᵽa yay, o ni suñokombool. ");
INSERT INTO bqj_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Naagol : « Aw o Atúla ásonien me, újoul bi yaŋóli ! Jamb’unamo mamu tíyaŋ ! Nicokore yaŋ yay bi ealenul, buru ni suñokomboul. » ");
INSERT INTO bqj_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ñer n’gujaor bi yaŋ Laban. Min urokaol gujal bíteb suñokombo sasu, guban n’gusen so mafos ni éful sitiñ. N’gúŋarul ᵽoᵽ mal min mbi áine ahu ni gátinenol me guᵽos guolil. ");
INSERT INTO bqj_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","No gugabulo me bi fitiñ, aroka Aburaham naagil : « Mat’itiñ ínje m’baloberutul waŋallom me bi tale. » Laban naagol : « Ñer ulob ! » ");
INSERT INTO bqj_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Naagil : « Injé aroka ala Aburaham om. ");
INSERT INTO bqj_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ban Atúla násoniesonien afanom faŋ nakanol an ámah, nasenol fubaj fámah faa ubbarum, sijamen ni síbe, suñokombo ni musum, síralam, éurus, uroka wáine ni waare. ");
INSERT INTO bqj_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saara, aamme aar afanom, nasenolsen áᵽur ni fúfanumol. N’áᵽur ahumu nahale fubajol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bare afanom nakanomkan min ibbat ieh : mat’iŋes bi n’áᵽurol anaare ni sújur sasu bugaa bo Kanaan bo naĉin me ; ");
INSERT INTO bqj_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mbi tin íjoul bi babe ésugol min iŋesol anaare to ni fiilol. ");
INSERT INTO bqj_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Neegol : “Aare ahumu alat me elagenom ?” ");
INSERT INTO bqj_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Naagom : “Atúla o nih’iᵽi me nikan gúboñol, ᵽan aboñuli amalakaol ayabi gayoŋ min akan bulagoi m’bútuen, mb’uliᵽ anaare ala fiilom bi n’áᵽurom.” ");
INSERT INTO bqj_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Naagom may : “Nánonan nuĉih bo, hani gulale eseni bájur bi n’áᵽurom, gabbat gagu gúᵽure.” ");
INSERT INTO bqj_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Jama no niĉilo me n’éhaᵽa yay, nilalaw Atúla ieh : “Aláemit aamme ala afanom Aburaham, uboket ukan bulagoom m’bútuen.” ");
INSERT INTO bqj_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Injé ume n’galam éhaᵽa yay ninave. Bájur ajae me éjoul bi gáij, niegol : “Uboket újiom jal ni jifini irem”, ");
INSERT INTO bqj_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","min aagom : “Uyab urem, ban ᵽoᵽ ᵽan iremen suñokomboi”, bájur baubu mb’áni me o nuĉob me bi éni aar áᵽur afanom. ");
INSERT INTO bqj_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Balama iban galaw gaugu n’éĉigirom, nijuh Rebeka átebul jifinol ni gabandol naalo ake gáij. Neegol : “Uboket újiom irem !” ");
INSERT INTO bqj_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Nafaen áñien jifinol min aagom : “Urem, ban suñokomboi ᵽoᵽ ᵽan iremen so.” ");
INSERT INTO bqj_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mbiban nirorenol : “Ay abugi ?” Naagom : “Betuel abugom, aamme añol Nahor ni Milika.” No ñer niŋar me eloŋuloŋ yay iŋobenol n’éñundu, ni gúliñah gagu n’guñenol. ");
INSERT INTO bqj_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ᵽúrto niya gújul bújoŋor Atúla min isal aĉila aamme Aláemit ala afanom Aburaham, min áĉibbenulom me ĉol bi tale yaŋul. Mamu níjue ícin bi n’áᵽurol gañen bájurul aamme gabulaken atiol. ");
INSERT INTO bqj_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nirorenul ñer, íni me ᵽan jibaj gailo gaa yaŋ gaaro bi ni afanom, n’julobom ; let mo, n’julobom ᵽoᵽ min itos itajen. » ");
INSERT INTO bqj_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","No nalob me aban, Laban ni Betuel n’guogol : « Maagen, dáru bakaner Atúla. Mati júju julob to wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka umu ailo me. Ujáenumol ñer uk’usen áᵽur afani ayab, ti Atúla alob yo me. » ");
INSERT INTO bqj_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Aroka Aburaham no naun me gurim gaugu, naya gújulol min áñuᵽ bi n’ettam nasal Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Naban náᵽunnul bíibor baa síralam ni bal éurus ni ᵽoᵽ wañ waaro asen Rebeka. Náᵽuren ᵽoᵽ uce ti wo áji jaol ni álinol. ");
INSERT INTO bqj_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","No naban me, aĉila ni gátinenol me n’gunamo n’gutiñ ni gurem. Mbi guban niki gufilo. Tihalen fo m’bujom no guilo me, aroka Aburaham naagil : « Ñer maer jihalóli min jibbañ bi n’afanom ! » ");
INSERT INTO bqj_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Jaol n’álinol n’guogol : « Ᵽan uhalóli tale Rebeka utajen butum gunah guñen, ᵽúrto n’jujow. » ");
INSERT INTO bqj_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Naagil : « A-a, nemme Aláemit nakakan bulagoom bútuen, juboket jambi jujogom jitajen, jihalom min ibbañ maer bi n’afanom ! » ");
INSERT INTO bqj_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","N’guogol : « Ñer uvogulaol min uunal fola ! » ");
INSERT INTO bqj_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebeka no naĉilo me, jaol n’álinol n’gurorenol : « Numaŋe ejow búsol áine ahume ? » Naagil ey. ");
INSERT INTO bqj_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","N’guhalol min ajaor ni aroka Aburaham ni buganol. Naŋar may áelol me. ");
INSERT INTO bqj_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Balama gujow, bugaa yaŋol n’gúsonienol guoh : « Aw aamme álinoli, mbi gabugori gummeŋ iki guᵽilo súuli ! Mbi ᵽoᵽ guram súsuh ulatoril ᵽe ! » ");
INSERT INTO bqj_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","No guban me, Rebeka ni urokaol waarema n’gújuᵽo ni suñokombo sasu min gukay manur n’aroka Aburaham. Mamu naliᵽulo me Rebeka bi n’Isak. ");
INSERT INTO bqj_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Toker Isak o baĉiner galam éhaᵽa yay yo guvoge me Lahai-Roi, ák’átosul bi Negev, bo nailen me gúgulol. ");
INSERT INTO bqj_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Fice funah tiname, o báᵽurerul áni n’gajator, naŋanden suñokombo so n’éjoul. ");
INSERT INTO bqj_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka may nake ejegor naŋanden Isak, nafaen áavul n’eñokombool ");
INSERT INTO bqj_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","naah aroka Aburaham : « Dáudua ay áine om me ájaeul me ban uemoral ? » Naagol : « Dáru afanom. » Ñer Rebeka naŋar ésorol afut buulol. ");
INSERT INTO bqj_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","No guemor me, aroka ahu nagiten Isak bu bulagool bujow me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ñer Isak nájaenum Rebeka bi ni fúggut fafu faamen me faa jaol Saara. N’gúyabo, ban namaŋol mámah. Mamu may, Isak áti me mufuol mal eĉet jaol. ");
INSERT INTO bqj_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aburaham nabbañ ayab ace aare gajaol Kétura. ");
INSERT INTO bqj_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nabugol úᵽur gaamme Simiran, Yokuĉan, Medan, Majan, Yiĉebak ni Ĉua. ");
INSERT INTO bqj_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokuĉan nabuh Ĉeba ni Dedan ; Dedan aamme ᵽay afan ala bugaa Aĉur, Létuĉ ni Léum. ");
INSERT INTO bqj_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Majan úᵽurol guomme Efa, Efer, Henok, Abida ni Elida. Dáuru ᵽe gabugor Kétura. ");
INSERT INTO bqj_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aburaham nahat áᵽurol Isak fubajol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Náᵽuren wafol uce asen úᵽurol bugaa Kétura ni Hagar. Bare balama aĉet, náᵽurenil gujow gúrali áᵽurol Isak, mbaa bo tinah talu túᵽureul me. ");
INSERT INTO bqj_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Fúfanum Aburaham fúariari ban ni fiᵽio. No naĉet me, o babajer símit ekeme ni úvi gúfaji ni gaat (175). Min ñer aalo atoh bo sipayol n’ufuga. ");
INSERT INTO bqj_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ñer úᵽurol Isak ni Isimael n’gújaenum efuluŋol iki gufoh Makupela baubu Mámure, ni gaun gagu gaamme ni galah gagu gal Eforon áᵽur Soar ala Hit ; ");
INSERT INTO bqj_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","galah gaugu go Aburaham anom me ni bugaa Hit, dó gufogol me galam aarol Saara. ");
INSERT INTO bqj_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","No Aburaham aĉet me ᵽúrto, Aláemit násonien áᵽurol Isak atajen. O baĉiner lof éhaᵽa yay yo guvoge me Lahai-Roi. ");
INSERT INTO bqj_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Gáu Isimael maa gujae, áᵽur Aburaham o nabaj me ni Hagar ala Esíp aamme amigel Saara : ");
INSERT INTO bqj_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Uᵽúr Isimael ubuge, ti gúulo me : Nebayot aamme afammaol, mbiban Kedar, Adibeel, Mibusam, ");
INSERT INTO bqj_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Miĉema, Duma, Masa, ");
INSERT INTO bqj_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yétur, Nafiĉ, ni Kedema. ");
INSERT INTO bqj_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dáuru úᵽur Isimael gaamme guñen ni gúuba ; bugo ᵽe bífesum bom, ánoan ni bugo afan ala fiil nam, ban nasen ésugol ni furobool gajaol. ");
INSERT INTO bqj_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimael no naĉet me, o babajer símit ekeme ni ávi ni gaat ni súuba (137). Min aalo atoh bo sipayol n’ufuga. ");
INSERT INTO bqj_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Buganol guke me guĉin ni mof mamu malof me Esíp, újogum Havila bi Ĉur, galam mof mamu maa Aĉur. Gaunorutil ni gutiil go guĉil me éhatulor yauyu. ");
INSERT INTO bqj_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Gáu Isak, áᵽur Aburaham, maa gujae : Isak, Aburaham abugol. ");
INSERT INTO bqj_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","No nabaj me símit úvi gúuba, nayab Rebeka aamme bájur Betuel, náni ᵽoᵽ álin Laban. Bugo éubail Padan-Aram gúᵽullo. ");
INSERT INTO bqj_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Bare Rebeka ájuut affas fufane. Ñer Isak nah’alaw Atúla tima nasen aarol gásumay. Atúla náttunol min akanol ateb. ");
INSERT INTO bqj_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ni bíteb baubu, náni n’enah múuba, ban múuba maumu nihi mutaj ró ni farol. Rebeka najahali naah : « Wa uom n’ebajom ? » Mufaŋ najow ake eŋes gasab n’Atúla. ");
INSERT INTO bqj_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Atúla naagol : « Uú gúuba guom n’aw, súsuh súuba ᵽan súᵽurul ni bugo sañumut ejamor : ece ᵽan efaŋ epayo sembe, apuma ᵽan ábahen afamma amigel. » ");
INSERT INTO bqj_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","No funagol fiĉih me, nabaj may múuba. ");
INSERT INTO bqj_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Amundum me ajuh tíyaŋ, ni kan añil ájuge, ban nafalet ti énuhureŋ. N’gukanol gajow gagu gaa Esau (dóemme \"nafalefalet\"). ");
INSERT INTO bqj_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Mbiban, atiol nájoul gañenol go baroŋer n’ejoh futoñ afamma. N’guvogol Sakob (dóemme \"najogol ni futoñ\"). No Esau ni Sakob gubugi me, Isak o babajer símit úvi gúfaji (60). ");
INSERT INTO bqj_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","No uñiaw gújalo me, Esau nakan asaa ámah, ban namaŋ baha. Sakob o nakan an abebene, nd’ake ban. ");
INSERT INTO bqj_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ᵽail, Esau nafaŋe namaŋe mata ellu baha naruhene ; jail tin o biinumol ni Sakob nabaŋ bo. ");
INSERT INTO bqj_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Funah fice, Esau nábbañul ni jasaw mayoge. Natoh atiol Sakob o básiler búholoŋ baa gusah. ");
INSERT INTO bqj_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Naagol : « Ujíom básileri bájuh me itiñ, bieb bumugom ! Básiler baubu bájuh me, bo nimaŋe. » (Yo eĉil me ni’gusalol Edom, dóemme \"ájuh me\".) ");
INSERT INTO bqj_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Sakob naagol : « Umundum ᵽan unomenom fufanei pe ! » ");
INSERT INTO bqj_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Naagol : « Ᵽan iĉet m’bieb. Fufaneom wa fúju to ekan ? » ");
INSERT INTO bqj_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Naagol : « Ñer ubbat ! » Min abbat gaa búoh nanomene Sakob fufaneol. ");
INSERT INTO bqj_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ñer Sakob nasenol unaĉ ni básiler gusah gagu atiñ ak’apoñ, aban narem nakay. Mamu Esau aĉotihen mee fufaneol. ");
INSERT INTO bqj_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ᵽúrto, bieb bice m’búloul n’ésuh yay, búbuli ni babu babajen me Aburaham o m’buroŋol. Ñer Isak nailo bi ejow mbaa Gerar atoh bo Abimelek, aamme ávi bugaa Ᵽilisit. ");
INSERT INTO bqj_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kan Atúla naᵽiᵽi naagol : « Jamb’úffus Esíp, bare mb’unamo n’ésuh yay yo nijai me egiten. ");
INSERT INTO bqj_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mb’unamo ró. Injé umu búsoli, ban ᵽan ísonieni, mata aw ni gabugori nijae me esen mof maumu. Firim fafu fo jihalor me ínje ni ᵽai Aburaham, ᵽan ífaro ni fo bi n’aw ni gabugori. ");
INSERT INTO bqj_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Guñoli ni gabulakenil ᵽan ikanil gummeŋ ti suut sasu ; ᵽan isenil ettam yauyu ᵽe guogen. Ni gabugori mb’ísonienum me súsuh sasu ᵽe saa mof, ");
INSERT INTO bqj_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","mata Aburaham buroŋol n’ínje nabaŋ bo, nauttenomwutten, nákanum firimom, ban nakan gúboñom. » ");
INSERT INTO bqj_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yo eĉil me Isak nak’arobo Gerar. ");
INSERT INTO bqj_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nemme Rebeka anaare om áarie mámah, Isak náholi jambi gumugol mola. Yo eĉil me, nánonan no bugal ésuh yay gurorenol mala aare ahumu, naagil dáru álinol om. ");
INSERT INTO bqj_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak nanamo ró ᵽio. Funah fice, ávi ahu Abimelek nake eŋalo n’elajenol naŋanden Isak áni n’emamaen Rebeka. ");
INSERT INTO bqj_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Navogulol naagol : « Aw hum dáuru aari om ! Ban aw nuogóli dáru álini. Wa uĉile ? » Naagol : « Níholiholi jambi an amugom mola. » ");
INSERT INTO bqj_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Naagol : « Bakaner bu nukanóli me báni me ? Jatito ace ni wóli ᵽan afilenen aari min mb’uĉilóli n’jitil ni aw ! » ");
INSERT INTO bqj_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Aban nasen gúboñ gauge n’ésuh yay ᵽe naagil : « An agor me áine ahume ter aarol, ᵽan amugi ! » ");
INSERT INTO bqj_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Emít yauyu, Isak naañ ulah n’ésuh yay. Min Atúla ásonienol me, naᵽit iki ᵽilo butum ñono ekeme wo naroh me. ");
INSERT INTO bqj_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ban fubajol ni fufaŋ ni fújaloe ");
INSERT INTO bqj_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","iki abaj sukore sámah saa ubbarum, sijamen ni síbe, ni ᵽoᵽ uroka gammeŋe. Yo eĉil me bugaa Ᵽilisit n’gúsilaet mola, ");
INSERT INTO bqj_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","iki gutik síhaᵽa sasu ᵽe so uroka ᵽayol guoh me o m’buroŋol. ");
INSERT INTO bqj_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek no najuh me fubaj Isak, naagol : « Uᵽúr n’ésugoli, mata nubbanno ufaŋóli ekan an ámah ! » ");
INSERT INTO bqj_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ñer Isak nailo ajow ak’ailen gúgulol galam fíĉiĉilen fafu fahay me faa Gerar. ");
INSERT INTO bqj_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aban natikul síhaᵽa sasu saa ᵽayol so bugaa Ᵽilisit gutiken me, aban nabbañen to ujow so waᵽi me. ");
INSERT INTO bqj_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Funah fice, uroka Isak n’guoh éhaᵽa evugul iki ébul. ");
INSERT INTO bqj_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ñer ukoñaaw bugaa Gerar n’guiyul gúrigen bugala Isak n’guogil : « Mal maume, wóli jiĉil mo ! » Isak navoh éhaᵽa yauyu Esek (dóemme \"gárig\"), mata ukoñaaw érigenol gumaŋene. ");
INSERT INTO bqj_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","N’gubbañ guoh ece éhaᵽa ; yo may nebbañ eilenul gárig. Yauye navoh yo Sitina (dóemme \"síñagor\"). ");
INSERT INTO bqj_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Natos ak’aoh éfaten ; yo ebajut gárig. Yo eĉil me navoh yo Rehobot (dóemme \"mauŋe mo an aĉilut\"). Naah : « Maer Atúla nasenolal ni mof maume mauŋe májue eŋalolal fubaj. » ");
INSERT INTO bqj_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ᵽúrto, Isak najow mbaa Beer-Ĉeba. ");
INSERT INTO bqj_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mb’uĉiga ni fuh, Atúla náᵽullol naagol : « Injé iomme Aláemit o ᵽai Aburaham áinen me ni o. Jamb’úholi, mata ínje umu búsoli. Ᵽan ísonieni min mb’ubaj gabugor, dó ᵽe mala Aburaham aamme amigelom. » ");
INSERT INTO bqj_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ñer Isak nateᵽ to físimenum min alaw to ni gajow Atúla. Nailen to ᵽoᵽ gúgulol, ban urokaol n’guoh to may éhaᵽa. ");
INSERT INTO bqj_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Funah fice, Abimelek náᵽurul Gerar ákail bujuh Isak. Nájoul n’ataraol Ahusat ni afan utigaol aamme Pikol. ");
INSERT INTO bqj_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak naagil : « Wa uĉile n’jikelom bujuh ? Leti buru jihamulom n’ésugul mata jujogutom jon ? » ");
INSERT INTO bqj_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","N’guogol : « Wóli jujuge ŋanno ca búoh Aláemit umu búsolul. Yo eĉil me n’jiᵽinor juoh : Jújoul min gásumay gúni n’etulolal, ban gásumay gaugu, mbi gabbat guliŋen go : ");
INSERT INTO bqj_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Mb’ubbat uoh mat’úmus ukanóli maarat, ti may wóli faŋaóli júmusut me jílatieni. Maaro barebare jikani iki jihali nukay n’gásumay. Maagen, aw an o Atúla ásoniene. » ");
INSERT INTO bqj_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ñer Isak násilil gutiñ n’gurem nímoro. Mbiban nasenil n’gúmori. ");
INSERT INTO bqj_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tihalen fo m’bujom mej n’guilo, ánoan ni bugo nabbat. Mbiban Isak nasafil min guhalor n’gásumay. ");
INSERT INTO bqj_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ban funah faufu fanur fafu, uroka Isak n’gújoul iki guogol : « Eháᵽa yay yo juoh me, ébule ! » ");
INSERT INTO bqj_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ñer Isak navoh yo Ĉiba (dóemme \"gabbat\"). Yo eĉil me bi jama ésuh yauyu n’guvoh yo Beer-Ĉeba (dóemme \"éhaᵽa yaa gabbat\"). ");
INSERT INTO bqj_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau no nabaj me símit úvi gúuba, nayab waare gúuba bugala Hit. Atíar gajaol Yehudit, bájur Beeri ; áuten gajaol Basamat, bájur Elon. ");
INSERT INTO bqj_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Waareaw ubugi n’guyogen Isak bugo ni Rebeka faŋ. ");
INSERT INTO bqj_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak maer náfanume nár, ban bujugol m’búkasulo ák’ápim. Funah fice, navoh añolol afamma : « Esau ! » Naagol : « Eé, ínje ume n’eutteni. » ");
INSERT INTO bqj_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Naagol : « Nujuge hum búoh ínje nífanume. Iffasut funagom fal eĉet. ");
INSERT INTO bqj_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nimaŋe uŋar fuŋajeni ni simelei min ujow bi ni baha numugulom bo énuhureŋ. ");
INSERT INTO bqj_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mb’uban núsilom yo básiler babu bo niruhen me itiñ min ísonieni bala iĉet. » ");
INSERT INTO bqj_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ñer Esau nailo ajow. Kan Rebeka umu n’eutten wo gulobe me. ");
INSERT INTO bqj_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Nafaen avoh Sakob naagol : « Niune ᵽai aah Esau ");
INSERT INTO bqj_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ak’amugulol énuhureŋ ni baha ákail ásilol atiñ ; mb’aban násonienol bala aĉet. ");
INSERT INTO bqj_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Aᵽ’uutten, ban nukan ti nijae me elobi : ");
INSERT INTO bqj_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ᵽan ujow bi n’ekore yay nujogulom dó míjehel múuba malie, min ísil ᵽai básiler babu bo nafaŋ me namaŋe. ");
INSERT INTO bqj_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mbiban nuteb bo uk’usenol atiñ min ásonieni bala aĉet. » ");
INSERT INTO bqj_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Sakob naagol : « Nuffase Esau nafalefalet, ban ínje ifaletut. ");
INSERT INTO bqj_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Iní ter ᵽayom namamaenorom, ᵽan affas búoh dáru let Esau, ban ᵽan ajoh búoh ínje ebutol nimaŋe, min til ñer atabom. » ");
INSERT INTO bqj_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Naagol : « Jamb’úholi, úttun firimom. Ujow uk’ujogulom míjehel mamu. Atabi me, gatab gagu ᵽan gulo n’ínje. » ");
INSERT INTO bqj_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ñer Sakob najow ak’aŋallol míjehel mamu. Min Rebeka ñer ásil básiler babu bo áinol aruhen me. ");
INSERT INTO bqj_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Naban naŋar wañ áᵽurol afamma Esau wafaŋ me jáari wo natoh ró me ni yaŋ yay, akan áᵽurol apuma Sakob. ");
INSERT INTO bqj_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Naŋar may ubaŋ míjehel mamu afut guñenol ni ehondorol, bafaletut me. ");
INSERT INTO bqj_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Aban nasen Sakob básiler babu ni unaĉ waw ájaenum bi esen ᵽayol. ");
INSERT INTO bqj_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Sakob najow ak’atogol to, navogol : « Ammay ! » Naagol : « Añúm, ínje ume n’eutteni ; bare áᵽurom ay uomme alobe maa n’ínje ? » ");
INSERT INTO bqj_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Naagol : « Injé om Esau, añoli afamma. Nikane wo nulobom me. Uilo ñer unamo min utiñ ellu yay yo nurorenom me, mb’uban nusenom gásonien gagu gúiya. » ");
INSERT INTO bqj_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak najahali naagol : « Bu nukane min úbajul énuhureŋ yay jas me ? » Naagol : « Atúla aamme Aláemit o núinen me ni o, o asenom yo. » ");
INSERT INTO bqj_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Naagol : « Añúm, útosul ulofom min imamaenori, mamu níju iffas ter maagen joon aw áᵽurom Esau om. » ");
INSERT INTO bqj_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Min Sakob atos atogol to. Isak namamaenorol naah : « Firim fafu, fo faa Sakob fom, bare guñen gagu, go maagen gal Esau. » ");
INSERT INTO bqj_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nemme guñen Sakob gufalefalet may ti gal atiol Esau, ᵽail ájuut átallool. Bare bala ásonienol ti maagen, ");
INSERT INTO bqj_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nabbañ arorenol : « Ti maagen, aw Esau uomme ? » Naagol : « Injé faŋaom. » ");
INSERT INTO bqj_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Naagol : « Ñer ugabom básileri itiñ, min mb’íju ísonieni. » Nagabol atiñ, nasenol may bíñu arem. ");
INSERT INTO bqj_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mbiban Isak naagol : « Yoo, áñum, ulofulom min úlloŋora. » ");
INSERT INTO bqj_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","No Sakob akan mo me, ᵽayol naun gatiŋ wañ waw wo nakano me. Ñer nasenol gásonien gauge naagol : « Maagen gatiŋ gauge gal áñum gom, ganogor me ti gaa galah go Atúla ásoniene. ");
INSERT INTO bqj_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mb’Aláemit aseni gamon gáaveul me fatiya, mb’aseni ᵽoᵽ fubaj fal ettam, ti bahager ni bíñu yammeŋe. ");
INSERT INTO bqj_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mbi súsuh sammeŋe suutten n’aw, mbi bugan gammeŋe guya gújulil bújoŋori. Ᵽan uyab gayoŋ gutii ᵽe, iki guya gújulil bíᵽimbori. An atabi me, mbi gatab gagu gúbbañul bi ni o, bare an ásonieni me, mbi ᵽoᵽ ayab gásonien ti go. » ");
INSERT INTO bqj_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mamu Isak ásonien me añolol Sakob. Sakob o n’eju ehalor ni ᵽayol, Esau nábbañul n’jasaol. ");
INSERT INTO bqj_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","O may násil básiler babu bo ᵽayol aruhen me ateb akaol esen naagol : « Apa, uilo min utiñ ellu yay yo niŋalli me n’jasaw jaju. Mb’uban núsonienom ti nulobom me. » ");
INSERT INTO bqj_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Naagol : « Aw uomme ay ? » Naagol : « Injé, áᵽuri afamma Esau. » ");
INSERT INTO bqj_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak no naffas me búoh dáru Esau om, náñag natelen nímoro naagol : « Min til ay akaene jasaw iki aŋallom ellu yatemoritemor itiñ aw m’baĉigerulat ? O til nísonien me, ban gásonien gaugu ᵽan gúni ni o bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau no naun me firim faufu, nalo me tes naya gáᵽib aah ᵽayol : « Injé may, úsonienom ! » ");
INSERT INTO bqj_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Naagol : « Atii abutom min aram gásonien gagu gáarien me gúni gúiya. » ");
INSERT INTO bqj_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Naagol : « Maagen, gajow gagu gaa Sakob, ni mo gukanol go : abuta bugan ! Nabutom bi ñúuba, min aram fufaneom ni may gásonien gagu go niñumen me eyab ni aw. » Nabbañ aagol : « Ŋañouti gásonien gace bi n’ínje ? » ");
INSERT INTO bqj_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Naagol : « Nikanolkan mb’áni gayoŋi bándor, ban nikanol ᵽoᵽ mbi buru gutiol ᵽe jíni umigelol. Nísonienol mb’abaj bahager ni bíñu yammeŋe. Añúm, wa níjue ᵽiaŋ ibbañ ikan bi n’aw ? » ");
INSERT INTO bqj_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Naagol : « Min ñer gásonien gaugu ganur pat nubaje ? Ammay, uboket usenom may gásonien gace ! » Min áarul akoŋ. ");
INSERT INTO bqj_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ñer ᵽayol naagol : « Ᵽan uĉin úhatulo ettam yay yáari me ! Ᵽan úhatulo bo gamon gagu gúloeul me ! ");
INSERT INTO bqj_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","N’gafojei mb’útiñum me, ban ᵽan ukan amigel atii. Bare búuy babu bíya, ésuh bi n’ésuh, mbi biĉili me min uᵽah ni fimigeleti. » ");
INSERT INTO bqj_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau nabaŋ Sakob ni fiiñ mala gásonien gagu gaa ᵽayol go naramol me. Naah m’biinumol : « Ᵽayóli aĉet me funah, ᵽan imugol. » ");
INSERT INTO bqj_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka no naffas me biᵽinorum Esau, návogul Sakob naagol : « Ukánum, atii Esau naᵽinore jamugi bi elugen wo nukanol me. ");
INSERT INTO bqj_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Añúm, uuttenom, nuffase buma : uilo ujow bi n’álinom Laban baubu Haran. ");
INSERT INTO bqj_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mb’urobo bo nunah bi no fiiñ atii fujae me eyom. ");
INSERT INTO bqj_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mb’unamo bo bi no najae me éjumor wo nukanol me, níboñul an ákail aŋali. Mata imaŋut íburul buru éubaul funah fanur. » ");
INSERT INTO bqj_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Naban naah áinol Isak : « To niemme, buroŋ baube nipoñbopoñ mata gúsabulom, waar Esau bugaa Hit, guyogenomyogen nár. Iní me may Sakob ban abbañ áyabul bo anaare, ñer níni to m’buroŋ bi wa ? » ");
INSERT INTO bqj_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ñer Isak návogul Sakob min abbañ asenol gace gásonien. Naagol : « Jamb’uyab anaare ala babe Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Uilo ujow bi Padan-Aram, ni yaŋ aolom Betuel abuh me jai. Bo mb’úyabul ace ni sújur Laban aamme álin jai. ");
INSERT INTO bqj_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mo Aláemit-Sembe mb’ásonieni, min ubaj gabugor gámah, min mb’ukan ᵽay afan ala súsuh sammeŋe. ");
INSERT INTO bqj_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Aláemit mb’ásonieni ti násonien me Aburaham, aw ni gabugori ᵽe, min mb’úju uogen mof mamu to nuĉin me maer ti ajaora, mo Aláemit asen me ᵽai afan Aburaham. » ");
INSERT INTO bqj_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Mamu Isak akan me Sakob min akay mbaa Padan-Aram bi ni yaŋ Laban, áᵽur Betuel. Laban aamme álin Rebeka, jaw Sakob ni Esau. ");
INSERT INTO bqj_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau naun gaa búoh ᵽayol násoniensonien Sakob min aboñol mbaa Padan-Aram, bi eke éŋesul anaare ni yaŋ Laban. Ban no násonieneol me, náfirenolfiren eyab anaare dó Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ban Sakob náttutun firim ᵽayol ni jaol min akay mbaa bo. ");
INSERT INTO bqj_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ñer Esau nátallo búoh ᵽayol amaŋut sújur Kanaan, ");
INSERT INTO bqj_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","min aah ban ak’aliᵽul ace aare atajen. Ñer nak’ajuh Isimael aamme may añol Aburaham, min ayab bájurol Mahalat aamme álin Nebayot. ");
INSERT INTO bqj_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ñer Sakob náᵽur Beer-Ĉeba áni n’ejow mbaa Haran. ");
INSERT INTO bqj_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","No tinah tujon me, nailen bi eŋes to najae me gámori. To nafilo me, naŋar eval náhago. ");
INSERT INTO bqj_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Náyeut ; ni síyeutol najuh biñehet biilo n’ettam bi fatiya émit, ban ni baj emalaka ni’gujiŋ n’gúavul. ");
INSERT INTO bqj_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Atúla dó fatiya biñehet babu náagul Sakob : « Injé iomme Atúla, Aláemit ala ᵽai afan Aburaham ni ᵽai Isak. Ᵽan isenul mof mamu to nufilo me, aw ni gabugori. ");
INSERT INTO bqj_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ᵽan gummeŋ ti eus ; biĉin babu bolul ᵽan bujow bubbañen bo tinah tiiyeul me bi bo tuloe me, ni may bubbañ bújogul n’gañen gárib bi ni gamay. Ni gajow gagu gúiya ni gaa gabugori, mb’isen me guil gagu ᵽe gal ettam yay gásumay. ");
INSERT INTO bqj_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Injé umu búsoli. Ᵽan ipoi tánotan to nujae, bi funah fafu fo nijae me ebbañenuli bi n’ésuh ye. Mat’ímus ijundeni. Ban wo nilobi me ᵽee, ᵽan ikan wo. » ");
INSERT INTO bqj_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","No Sakob álio me, naah : « Maagen, Atúla umu tale, ban ínje iffasenut yo. » ");
INSERT INTO bqj_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Náholi naah : « Tiñ taute tíliilii ! Maagen, biĉin Aláemit bom, ni ᵽoᵽ gánonum émit. » ");
INSERT INTO bqj_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mb’uĉiga ni bujom, náiyali aŋar eval yay yo náhagoen me ni yo ailen bújonih bi ekan fúosenum. Naŋar édunen áĉir fo. ");
INSERT INTO bqj_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Naban navoh tiñ tautu Betel (dóemme \"yaŋ Aláemit\"). No, nihi guvogen to Lús. ");
INSERT INTO bqj_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ᵽúrto, Sakob nabbat bi n’Aláemit naagol : « Iní me aw Atúla umu búsolom, ban nupoyom ni bújaorom, nusenom ᵽoᵽ itiñ nisimo, ");
INSERT INTO bqj_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ík’íbbañul n’gásumay bi ni fiilom, no ᵽan ijogi me guñen gúuba bándor. ");
INSERT INTO bqj_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Eval yauye yo niilen ma ban níĉir yo, mb’éni yaŋi. Ban ni wo nujae me esenom ᵽe, ᵽan íᵽuren dó gakib ganur ni wono guñen iseni. » ");
INSERT INTO bqj_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ᵽúrto, Sakob nailo ajow mbaa bo tinah túᵽureul me. ");
INSERT INTO bqj_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Najow ajow ajow, funah fice naŋanden éhaᵽa n’eᵽarandaŋ yay to sukore sífaji saa ubbarum ni sijamen suom n’gáelo, mata to siᵽie nihi sirem. Ban ni baj fuval fámah fuguben éhaᵽa yauyu. ");
INSERT INTO bqj_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nánonan no sukore sasu suomunorulo iki sírir, n’gúbaken fuval fafu min guremen so ; mbiban n’gubbañen fo. ");
INSERT INTO bqj_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Sakob nasaf ukoñaaw naagil : « Gutiom, bay júᵽullo ? » N’guogol : « Haran júᵽullo. » ");
INSERT INTO bqj_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Naagil : « Jiffase ᵽiaŋ Laban añol Nahor ? » N’guogol : « Ey, jiffasol. » ");
INSERT INTO bqj_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Naagil : « Bu nakane ? » N’guogol : « Umu to gásumay. Fubambaŋ, bájurol Raĉel umua ájaeul me n’ekoreol. » ");
INSERT INTO bqj_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Sakob natajen aagil : « Bare tinah tiŋaŋut bi eomen sukore sasu. Jiremen so jiban, n’jibbañen so sike gafen. » ");
INSERT INTO bqj_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","N’guogol : « Jújuut jifaen jikan mo. Ᵽan jumundum juomen so ᵽe, balama jíbaken fuval fafu min jiremen so. » ");
INSERT INTO bqj_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","O m’babanerut elob ni bugo, Raĉel, aamme may akoña, naĉigul n’ekore ᵽayol ; ");
INSERT INTO bqj_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ban ᵽay Raĉel ni jaw Sakob, bálinay bom. No Sakob ajugol me aĉigul n’ekore Laban, nátosul bi to n’éhaᵽa yay min ábaken fuval fafu bi eremen ubbarumol. ");
INSERT INTO bqj_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Mbiban nálloŋ Raĉel nakaw ");
INSERT INTO bqj_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","naagol : « Injé an ᵽai om ; Rebeka abugom. » Ñer Raĉel nafaen atey ak’agiten yo ᵽayol. ");
INSERT INTO bqj_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","No Laban aun me búoh añol álinol najoulo, náteil iki guemor, nálloŋol, namamaenorol, aban nájaenumol bi ni yaŋol. No guĉih me, Sakob nagitenol waĉilol me éjoul. ");
INSERT INTO bqj_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ñer Laban naagol : « Maagen aw wola ni fiil fanur núᵽullae, fásimola fanur. » Min Sakob anamo to fieñ iki fubao lis. ");
INSERT INTO bqj_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Funah fice, Laban návogul Sakob naagol : « Maagen, aw anom. Bare yo mat’eĉil nuh’urokom bamotoŋ. Wa numaŋe mb’icami ? » ");
INSERT INTO bqj_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Kan Laban nabaje sújur gúuba ; afamma gajaol Lea, apuma Raĉel. ");
INSERT INTO bqj_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea gúĉilol guŋannout, bare Raĉel náari ajugo, nabaj gailo. ");
INSERT INTO bqj_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Sakob biinumol m’bíni ni Raĉel ; yo eĉil me, nábahul Laban aah : « Bájuri Raĉel nimaŋe ; ᵽan iroki mola símit futoh ni súuba. » ");
INSERT INTO bqj_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Naagol : « Yoo, unamo nurok. Esenol aw efaŋe gásumom esenol ace ábulo. » ");
INSERT INTO bqj_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ñer Sakob nanamo to narokol símit futoh ni súuba mala Raĉel. Nemme namaŋolmaŋ nár, símit sausu ni sijas ni o ti nihi síni me gunah guman. ");
INSERT INTO bqj_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","No sibao me, naah Laban : « Yoo, símilom sírire. Maer usenom aarom min jiĉin. » ");
INSERT INTO bqj_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ñer Laban návogul bugal ésuh yay ᵽe min akan gaggan gámah gaa búyaboil. ");
INSERT INTO bqj_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mb’uĉiga gállim, naŋar tin bájurol afamma Lea ak’asen Sakob, min gúmori. ");
INSERT INTO bqj_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban naŋar Siliᵽa aamme ace n’urokaol waarema ábahen asen Lea min nah’arokol. ");
INSERT INTO bqj_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tihalen fo m’bujom, Sakob najuh búoh kan bugo ni Lea gúmoe. Ni táñiol naah Laban : « Bu nukanom me ? Leti mala Raĉel nírokumi ? Wa uĉile ñer nubutom ? » ");
INSERT INTO bqj_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Naagol : « Wóli ésugoli ndi jikan me, ndi jumundum jisen apuma búyabo bala afamma. ");
INSERT INTO bqj_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Uban fíiyai faa búyaboul buru ni Lea. Ᵽúrto, niseni ᵽoᵽ Raĉel, íni me ᵽan utajen urokom símit sice futoh ni súuba. » ");
INSERT INTO bqj_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Sakob nahabo min afaben fíiyay fafu ni Lea. Mbiban, Laban nasenol ñer Raĉel ayab. ");
INSERT INTO bqj_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","30","Min Sakob aĉin ni o, ban namaŋol iki faŋ Lea. Ñer nabbañ anamo to burok Laban símit futoh ni súuba. Laban nabbañ ábahen arokaol ahu Biliha asen Raĉel min nah’arokol. ");
INSERT INTO bqj_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Atúla no najuh me búoh Lea Sakob aruhenutol, nasenol gabugor, min tin akan Raĉel áni emotombo. ");
INSERT INTO bqj_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea naŋar far ak’apegor júᵽur. Naah : « Atúla najuge matañoom. Níinene maer áinom ᵽan amaŋom. » Nakanol gajow gagu gaa Ruben (dóemme \"Juluj, dáre júᵽur\"). ");
INSERT INTO bqj_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nabbañ ateb ak’aalen, náŋarul jice júᵽur. Naah : « Atúla naffase búoh ínje áinom amaŋutom. Yo eĉil me, natajen asenom júᵽur je. » Nakanol gajow gagu gaa Simioŋ (dóemme \"auttena\"). ");
INSERT INTO bqj_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Náfaten ateb ak’aalen, nabbañ abaj júᵽur. Naah : « Aínom maer ᵽan aholom, mata nisenol úᵽur gúfaji. » Yo eĉil me nakanol gajow gagu gaa Lévi (dóemme \"ᵽan aholom\"). ");
INSERT INTO bqj_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nateb abarigen ak’aalen, nabaj mul júᵽur. Naah : « Ᵽan iteben Atúla. » Min akanol gajow gagu gaa Yuda (dóemme \"eteben\"). Ᵽúrto, nailo ᵽio m’babbañut abuh añil. ");
INSERT INTO bqj_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raĉel no najuh me búoh ájuut asen Sakob añil, násilaet abbañen mbal atiol. Naah Sakob : « Ukanom min ibaj añil ! Let mo, ᵽan iĉet. » ");
INSERT INTO bqj_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Sakob fiiñol ni fitiñ ak’aagol : « Injé iomme ᵽiaŋ Aláemit áfiri me gabugor ? » ");
INSERT INTO bqj_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Naagol : « Nemme mamu, ban iseni arokaom Biliha uyab mb’abajom uñil ! N’aĉila, ínje mb’íbajum me may añil. » ");
INSERT INTO bqj_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ñer nasenol o ayab min gufilo. ");
INSERT INTO bqj_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ban Biliha nateb ak’aalen, náŋarul Sakob júᵽur. ");
INSERT INTO bqj_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Min Raĉel aah : « Aláemit nataliŋomtaliŋ, naun gaĉagorom, min asenom may añil. » Nakanol gajow gagu gaa Dan (dóemme \"bataliŋ\"). ");
INSERT INTO bqj_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha nabbañ aŋar far, nak’apegor náŋarul Sakob jice júᵽur. ");
INSERT INTO bqj_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raĉel naah : « Nitaje n’atiom mámah, ban nihekol. » Nakanol gajow gagu gaa Nafutali (dóemme \"bútaj\"). ");
INSERT INTO bqj_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea no najuh me búoh alet n’ebbañ abaj añil, naŋar arokaol Siliᵽa asen may Sakob ayab. ");
INSERT INTO bqj_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","No Siliᵽa asen me Sakob júᵽur, ");
INSERT INTO bqj_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea naah : « Fubaŋom. » Nakan jo gajow gagu gaa Gad (dóemme \"fubaŋom\"). ");
INSERT INTO bqj_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Siliᵽa natajen asen Sakob áᵽur áuten. ");
INSERT INTO bqj_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea nabbañ aah : « Gásumay gámah ugu n’ínje, ban waareaw ᵽe gújue guoh maer níeloe. » Min akanol gajow gagu gaa Aser (dóemme \"ésumay\"). ");
INSERT INTO bqj_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Funah fice, Ruben nake n’ulah waw bugan n’eᵽit ble yay. Náŋarul bo mitiñ mice munogor gujahata ákail asen jaol Lea. Ñer abelol Raĉel naagol : « Uboket újiom ni mitiñ maumu ! » ");
INSERT INTO bqj_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Naagol : « Ᵽilouti min uramom me ánaine, numaŋe mul ubbañ uŋar mitiñ áᵽurom ! » Raĉel nábahulol aagol : « Iní me nusenom mo, ᵽan ihat Sakob min ámori n’aw efuga yauye ! » Naagol yoo. ");
INSERT INTO bqj_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Gállim Sakob o m’búolul n’ulah, Lea natey iki guemor naagol : « Jama n’ínje nuĉiggo, mata funah faufe nicamfocam abelom, min isenol me mitiñ añolom. » Ñer Sakob nák’ámori ni o efuga yauyu. ");
INSERT INTO bqj_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ban Aláemit náttun galaw Lea min akanol ateb ak’aalen nasen Sakob júᵽur jutogen. ");
INSERT INTO bqj_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Naah : « Aláemit nasenom bacamom, mala min isen me áinom arokaom ayab. » Nakanol gajow gagu gaa Isahar (dóemme \"bacam\"). ");
INSERT INTO bqj_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nabbañ ateb ak’aalen náŋarul áinol júᵽur júsola. ");
INSERT INTO bqj_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Naah : « Aláemit nájiomji gáji gaaro. Ñañe áinom ᵽan amalenom, mata nisenol úᵽur gono futoh ni anur. » Nakanol gajow gagu gaa Sabuloŋ (dóemme \"emalen\"). ");
INSERT INTO bqj_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ᵽúrto, nabaj bájur nakanol gajow gagu gaa Dina. ");
INSERT INTO bqj_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","No ᵽúrto me, Aláemit nabil áttun galaw Raĉel min átojulol. ");
INSERT INTO bqj_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Naŋar far ak’apegor nabaj júᵽur. Naah : « Aláemit náᵽurenom ñusuom. » ");
INSERT INTO bqj_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nakanol gajow gagu gaa Susef (dóemme \"mb’abbañ asen\") naah : « Mbi Atúla aboket asenom ace añil ! » ");
INSERT INTO bqj_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","No Susef abugi me aban, Sakob naah Laban : « Uhalom nike búot mbal ésugom. ");
INSERT INTO bqj_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mb’uhalom niŋar waarom ni guñolom, bugo niroki me molil, min jujow. Nujuge hum bu nirok me bi n’aw. » ");
INSERT INTO bqj_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Naagol : « Nilai unamo tale utajen. Mata sínatiom sigitenomgiten búoh Atúla míya násonienumom. ");
INSERT INTO bqj_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Yo eĉil me, ulobom wa numaŋe icami aw batajener urokom. » ");
INSERT INTO bqj_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Naagol : « Aw nujuge bu niroki me iki ekorei efaŋ n’éjaloe. ");
INSERT INTO bqj_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Balama iĉigul, minde matiito nubajene, maer ekelo ekan ekore yámah. Wáfowaf wo nigore úiya, Atúla naremben to gañenol bi n’aw. Nay ᵽiaŋ ínje ijae me burok bi ni fuhoom ? » ");
INSERT INTO bqj_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Naagol : « Wa numaŋe icami ? » Naagol : « Ulet n’ecamom wáfowaf. Iní me numaŋe ukan wo nijae me eroreni, ᵽan ibbañ inamo min ikoñ sukorei ti no. ");
INSERT INTO bqj_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jama ᵽan iluj joon sihaj sasu so ᵽe. Ᵽan íᵽuren jala so sihaj sasu siaĉah sasu ni sabaj me úpar ; ᵽan íᵽunnor ᵽoᵽ ubbarum waw uus waw. Dó mb’éni me bacamom. ");
INSERT INTO bqj_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nánonan no numaŋe effas ter ínje an ala maagen, núkail uluj bacamom. Ejamen yánoyan yo nujae me etoh n’ekoreom, yaaĉahout ban nebajut gápar, ter gabbarum gánogan galet guus, nuffas búoh ínje íkuet so. » ");
INSERT INTO bqj_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Naagol : « Yoo, nimaŋe firimi. » ");
INSERT INTO bqj_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Funah faufu fanur fafu, Laban náni n’éᵽurenor gújehelol guaĉah gagu ni gabaj me úpar, sijamenol siaĉah sasu ni sabaj me úpar, ni ᵽoᵽ ubbarumol uus waw, min asen so úᵽurol gukoñ. ");
INSERT INTO bqj_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Naban nájaenumil gúrali Sakob, butum ejow gunah gúfaji ; min Sakob anamo to nakoñ saŋaño to me. ");
INSERT INTO bqj_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ñer Sakob naᵽikul muan ununuh uce amilij, aban nave mo iki mátuene mamu múᵽurul. ");
INSERT INTO bqj_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Naŋar mipil mamu mo nábilen me ahalen n’úremum waw, mata sihaj sasu nihi sivagevagen jijiŋ so bákaerul marem. ");
INSERT INTO bqj_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ñer síni me n’jijiŋ jaju, nihi suluj dó mipil mamu mábileni me. Yo eĉil me subugor me, ᵽan sibaj miñil mánie walalal, mamu muaĉaho, mice mitegor úpar. ");
INSERT INTO bqj_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Náfaculor ubbarum waw jala wo, aban nakan wo min uluj uus waw ni wáni me walalal waa Laban. Mamu naŋar me miñil mamu min aju ekoreol ébuli ni yaa Laban. ");
INSERT INTO bqj_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","42","Nánonan no najuge sihaj ságurete so n’jijiŋ, mat’akan dó mipil mamu n’úremum waw ; mb’éni me sasu sali me, nakan mo ró. Yo eĉil me Laban nayab miñil mamu máguret me, aĉila Sakob o naŋar mabaj me sembe. ");
INSERT INTO bqj_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mamu Sakob akan me asanum ala sihaj, nabaj may suñokombo ni musum, ni ᵽoᵽ umigel wáine ni waare. ");
INSERT INTO bqj_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ᵽúrto, Sakob naun gaa búoh guñol Laban guoge aĉila arame fubaj ᵽail, fo fiĉilol me nabaj. ");
INSERT INTO bqj_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Najuh ᵽoᵽ búoh Laban abbañut ajogol ti no. ");
INSERT INTO bqj_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ñer Atúla naah Sakob : « Ubbañ mbal ésuh sipai gufan utoh bo fiili. Injé ᵽan ijow búsoli. » ");
INSERT INTO bqj_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ñer Sakob naboñ gúvogul waarol Lea ni Raĉel bi bo n’ulah waw bo naamme n’gakoñ. ");
INSERT INTO bqj_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Naagil : « Nijuge búoh maer ᵽayul abbañut asenom jíĉil ti no. Bare Aláemit o ᵽayom áinen me ni o, o nailoilo múmbam. ");
INSERT INTO bqj_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Jiffase búoh sembeom ᵽe ni burok ᵽayul nialen so. ");
INSERT INTO bqj_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Bare tin aĉila nabutom min ágotor bacamom ñammeŋe. Ni fubaŋ, Aláemit ahalutol min akanom maarat. ");
INSERT INTO bqj_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","No ᵽayul aagom me mbi sihaj sasu siaĉah sasu síni bacamom, saarema sifamma ᵽe nihi subuh miñil muaĉah ; mb’ábahen aah sáni me walalal mbi síni bacamom, so may nihi subuh miñil mánie walalal. ");
INSERT INTO bqj_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mamu Aláemit ayabulo me jatito-jatito ekore ᵽayul ábahen asenom. ");
INSERT INTO bqj_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","No sihaj sasu nihi sijingor me, níyeute nijuh maa : sáinema sajinge me saarema, baje sánie walalal, siaĉah ni sategore úpar. ");
INSERT INTO bqj_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ni síyeut sausu, amalaka Aláemit navogom : “Sakob !” Neegol : “Eé, ínje ume n’eutteni.” ");
INSERT INTO bqj_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Naagom : “Uluj ! Nujuge búoh sáine sasu sáni me walalal, siaĉah sasu ni sategor me úpar, so bare suom ni jijiŋ ? Dáuru ᵽe mata nijuge wo Laban akani me.” ");
INSERT INTO bqj_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nabbañ aagom : “Injé iomme Aláemit anur ahu áᵽulli me baubu Betel. Bo nuilen me eval yay, núĉir yo, ban nubbat bi n’ínje. Maer uilo ujow ubbañ mbal ésuh yay bo fiili fuomme !” » ");
INSERT INTO bqj_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raĉel ni Lea n’guoh Sakob : « Jibajut gafum gánogan ni fubaj ᵽayóli. ");
INSERT INTO bqj_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Najogólijoh ti ejaora mata nanomenóli, aban natiñ bacam babu baamen me bóloli. ");
INSERT INTO bqj_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Wánowan wo Aláemit alobi me, nukan wo, mata fubaj fafu fo náᵽunnulo me ni guñen ᵽayóli, fololal fom ni guñololal. » ");
INSERT INTO bqj_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ñer Sakob naomen wañol bi ekay. Nájuᵽ waarol ni guñolol ni suñokombo, ");
INSERT INTO bqj_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","naŋar may sukoreol ni wafol ᵽe wo nabaj bo me Padan-Aram, bi éjaenum mbaa yaŋ ᵽayol Isak baubu Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","No guomme n’ekay, Laban o bakaer écih bufal ubbarumol. Ñer bájurol Raĉel nabbuy ák’ákutul fípiraol. ");
INSERT INTO bqj_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Kan Sakob ebut Laban nan ni yo, min atey me akay m’balobutol. ");
INSERT INTO bqj_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Naŋar fubajol ᵽe fo nabaj bo me min ailo atey ák’ápino fal fafu fo guvoge me Afúrat, min ariŋen mbaa gurijaŋ gagu gaa Galaad. ");
INSERT INTO bqj_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","No Sakob atey me baj gunah gúfaji, ace nak’atoh Laban bo naamme naagol : « Sakob natetey akay ! » ");
INSERT INTO bqj_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Min Laban ábbañul ákail aŋar ni fiilol bugan guce, min gulagenol. N’guteynenol gunah futoh ni gúuba iki gutobenol baubu ni gurijaŋ gagu gaa Galaad. ");
INSERT INTO bqj_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bare n’efugaol ésola bala atobenol, Aláemit náᵽullol ni síyeut naagol : « Mb’úkanum wo nujae me elob Sakob ! » ");
INSERT INTO bqj_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","No natobenol me, najuh búoh Sakob naileyilen gúgulol to ni gurijaŋ gagu gaa Galaad ; o ni buganol n’guilen may golil gúratul. ");
INSERT INTO bqj_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Mbiban najow ak’atogol to naagol : « Aw bu nukanom me ? Nubutom nújaenumul sújurom ti umigel ? ");
INSERT INTO bqj_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Wa uĉile joon nubutom min ubbuil úteil úkail aw m’balobutom ? Ulobenom me, ᵽan jítineneni n’ésumay, n’éfoñ, ni sibeleŋ ni suhontin dó. ");
INSERT INTO bqj_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Uhalutom hani nílloŋ sújurom ni gabulakenom élloŋ ésola. Nukakan me ti an aᵽinorérit. ");
INSERT INTO bqj_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Níjuene ikanul maarat ; bare n’efuga yay yágat me, Aláemit, o ᵽai áinen me ni o, naĉafomĉaf naagom : “Wo nuᵽinor me bi ekanol, mb’úkanum !” ");
INSERT INTO bqj_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Maagen esommen búot mbaa yaŋ ᵽai yo eĉili me núteil, bare wa uĉile ñer núkutul fípiraom ? » ");
INSERT INTO bqj_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Sakob naagol : « Gáholi jamb’uram sújuri, go guĉil me. ");
INSERT INTO bqj_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bare utoh me fípirai ni ace ni wóli, an ahumu ᵽan aĉet. Fáĉil buganola ᵽan uŋes ni gúguloli ᵽe ; ujuh ró me waf úiya, nuŋar. » Kan Sakob affasut búoh Raĉel nákutulokuet fípira ᵽayol. ");
INSERT INTO bqj_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ñer Laban nailo aŋes ni gúggut gagu. Nanogen ni faa Sakob, ajugut. Naban nanogen ni gal urokaol Biliha ni Siliᵽa, ajugut. Náᵽurul anogen ni faa Lea, abbañut ajuh. Dó náᵽullo me anogen ni faa Raĉel. ");
INSERT INTO bqj_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ban Raĉel aŋallo me fípira fafu, o m’baŋarer fo akoen ñáraru fúnavum eñokombool, min anamo ni fo. Laban náhundulor wañ Raĉel iki heh, ajugut. ");
INSERT INTO bqj_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","No, Raĉel aagol me : « Ammay, uboketom min iilout me no nunonulo me dáre, mata iolut ró. » Laban nabbañ aŋes iki mufaŋ, ajugut. ");
INSERT INTO bqj_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Sakob fiiñol ni fitiñ, nalobol dó me naagol : « Maarat bu nikani me ? Gatil bu nitil me ni aw gare me iki uroŋ n’ehattorom bahattorer baubu ? ");
INSERT INTO bqj_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Núhundulore wañóli ᵽe. Iní me nujuge uce watiito úiya ni gúguloli, nugiten wo bújoŋor gutiola ᵽe garobo maa, min mbi gúju gutaliŋola. ");
INSERT INTO bqj_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Símit ávi ínje umu n’guñeni, ban jibbarum ter jijamen jíya júmusut jilas. Imúsut ᵽoᵽ itiñ jibbarum jal ekorei, ");
INSERT INTO bqj_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ban ᵽoᵽ ímusut íŋarul búŋañen ehaj yíya yo súnuhureŋ baha sujoge ; íni me fubabaj, ínje faŋaom nih’icam yo. Nánonan no ehaji ékuti ter tufunah ter gállim, nuh’uogomseh ilugeni yo. ");
INSERT INTO bqj_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Bare bae ninamo to m’bámoit, ñutot nihi ñumuh gállim, ésuᵽa nemuh tufunah. ");
INSERT INTO bqj_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nirove yaŋi símit ávi : símit guñen ni sibbagir niroki mala sújuri, símit futoh ni yanur mala sukorei, mbiban tin núgotor bacamom ñammeŋe. ");
INSERT INTO bqj_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Bare Aláemit o ᵽayom afan Aburaham áinen me ni o, o náh’áhollen me ᵽayom Isak, o ájumorutom. Lelen me aĉila, ᵽan úruhenom ík’íolul guñen gurakel. Fubambaŋ, Aláemit naĉafi ni síyeuti, mata najujuh sílamom ni buyogom bájalo me no niomen me m’buroki. » ");
INSERT INTO bqj_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban naagol : « Me, waareaw ubuge guñolom, guñolil guñolom, sukorei súmbam, ban dáuru ᵽe dó nujuh me, ínje iĉil me. Baje maer ᵽiaŋ uce wo níjue ikan bi ni sújurom ni guñolil ? ");
INSERT INTO bqj_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yo eĉil me neege unava nuloba min ujamora. Mb’uilena to fúosenum bi gajem. » ");
INSERT INTO bqj_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ñer Sakob naŋar eval ailen, ");
INSERT INTO bqj_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","min aah bugaa fiilol gumukul may sival sice. N’gukan mo min guilen fúpuh fámah. N’gubaŋ to bugo ᵽe n’gutiñ. ");
INSERT INTO bqj_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban navoh to Yegar Sahaduta ni golil, Sakob o navoh to ni golil Galed. (Ujow waw úuba waw dóemme \"fúpuh faa gajamor\".) ");
INSERT INTO bqj_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Min Laban aagol : « Jama fúpuh faufe mbi fíni me fúffasum fafu fagiten me gaunorola. » Yo eĉil me gajow gagu gaa Galed. ");
INSERT INTO bqj_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Bugagu n’guvoh tiñ tautu Misipa (dóemme \"tapoei me\"), mala min Laban atajen me aah : « Mb’Atúla apoyola wola báraliorer. ");
INSERT INTO bqj_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Iní me ᵽan úlatien sújurom aw bayaber waare guce, mb’uosen búoh let an aam n’etulola, bare Aláemit faŋaol. » ");
INSERT INTO bqj_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Nabbañ aah Sakob : « Nujuge fúpuh faufu faamme n’etulola, nujuge may eval yauyu yailo me. ");
INSERT INTO bqj_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Siĉila so sijae me egitenola búoh firim nuhalorae : Injé umu n’ebbat bújoŋor fúpuh faufe, mat’ímus ígat fo ibbañen mbaa galambi bi ekani maarat. Aw ᵽoᵽ mat’úmus úgalul fo úbbañenul mbaa gúmbam bi ekanom maarat. ");
INSERT INTO bqj_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aláemit Aburaham ni ala Nahor, mbi gúni utaliŋaola. » Ñer Sakob nabbat ni gajow Atúla, o náh’áhollen me ᵽayol Isak. ");
INSERT INTO bqj_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Aban násimen ehaj to ni firijaŋ fafu, min ávogul buganol gúkail gutiñ. Mbiban, n’gúmori to. ");
INSERT INTO bqj_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Tihalen fo, Laban nailo m’bujom mej, ak’atoh bo sújurol ni guñolil, nálloŋil, aban násonienil min aot. ");
INSERT INTO bqj_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ᵽúrto, Sakob nafa bulagool. N’ejaol ni baj emalaka Aláemit gújoul bi eemor ni o. ");
INSERT INTO bqj_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","No najugil me, naah : « Dáuru funamo Aláemit. » Min avoh tiñ tautu Mahanaim (dóemme \"gunamo gúuba\"). ");
INSERT INTO bqj_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Sakob naboñ uloba uhoŋen guyabol gayoŋ mbal atiol Esau baubu Seir ni mof mamu mal Edom, ");
INSERT INTO bqj_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","naagil : « Mbi juoh Esau, ínje Sakob aamme amigelol, neege : “Nende Laban niomene bi maer. ");
INSERT INTO bqj_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nibaje síbe, musum, ubbarum, sijamen, umigel wáine ni waare. Niboñulo maa gahoŋen gauge gulobi min mb’ualenom n’gásumay.” » ");
INSERT INTO bqj_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","No uloba gahoŋen gagu gubbañulo me gutoh to Sakob, n’guogol : « Jujojow me ti maagen iki jutoh bo atii Esau. Kan til may aĉila umu n’éjoul mbal aw ni bugan gono sikeme sibbagir (400). » ");
INSERT INTO bqj_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ñer gáholi gámah n’gunogenol. Naluj to náfaculor buganol akan guyoŋ gúuba. Naŋar may sihajol ᵽe bi ni suñokombool ró agabor sukore súuba, ");
INSERT INTO bqj_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","mata n’gaᵽinorol : mb’éni me Esau ban atigen fítiman fanur, fafu ni fuᵽah. ");
INSERT INTO bqj_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Naban náni n’galaw Aláemit naah : « Aw Atúla, Aláemit ala ᵽayom afan Aburaham ni ᵽayom Isak, aw uogom me mb’ibbañ bi ni mofom itoh bo fiilom, min ukanom maaro : ");
INSERT INTO bqj_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nititie nár bi eyab gábbolii ni gamaŋi so nubaŋ me n’ínje aamme amigeli. No níᵽur me yaŋom bi épino fal fafu faa Suruden, fijigumom bare niogenene, ban maer ínje ume ni guyoŋom gúuba. ");
INSERT INTO bqj_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Uboket mb’uᵽagenom ínje baemorer ni atiom Esau, mata níholiholi jamb’ákail amugóli ínje ni waarom ni guñolom ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Aw uogom me ᵽan ukanom maaro, ban nusenom gabugor gummeŋ ti fuus fo an ájuut me eᵽin. » ");
INSERT INTO bqj_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","No nalaw me aban, narobo to bi gámori efuga yauyu. Mb’uĉiga ni bujom, náᵽuren sihajol sice bi éji atiol Esau : ");
INSERT INTO bqj_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","sijamen saare sikeme súuba, gújehel gono ávi, ubbarum waare sikeme súuba, wáine ávi, ");
INSERT INTO bqj_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","suñokombo saare sono ávi ni guñen saam n’erafen muñol so, síbe saare úvi gúuba ni gújin guñen, musum maare mono ávi ni máine guñen. ");
INSERT INTO bqj_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Náfaculor so mukore-mukore ; jukore jánojan náᵽuren jo jala jo asen ace n’urokaol aogen. Aban naagil : « Jiyab gayoŋ, ban ni jihalor siᵽa. » ");
INSERT INTO bqj_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Natajen aah amundum me ayab gayoŋ : « No nujae me eemor n’atiom Esau min aroreni ay aamme afani, bay nujae, ni ᵽoᵽ ay aĉile jukore jauju jo núĉibbene me, ");
INSERT INTO bqj_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","mb’uogol : “Dáru ᵽe amigeli Sakob aĉil me, ban naage jukore jauju bi eseni ; o faŋaol umu n’éjoul búsololi.” » ");
INSERT INTO bqj_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nalob mo may bugagu ᵽe garukeneul me mamu mukore. ");
INSERT INTO bqj_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Natajen aagil : « Jambi jújumor me eegol : “Amigeli Sakob faŋaol umu bo n’éjoul búsololi.” » Mata n’gaᵽinorol : áji me Esau mukore maumu, fiiñol ᵽan fualo ; min mb’ajoŋorol, ñace nayabol n’gásumay. ");
INSERT INTO bqj_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ñer mukore mamu ni muyabol gayoŋ, min aĉila abbañ amor to efuga yauyu. ");
INSERT INTO bqj_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","N’efuga yauyu, Sakob ámoit. Nailo aŋar waarol gaamme gúuba ni urokail Biliha ni Siliᵽa, ni guñolol gaamme guñen ni anur ni wafol ᵽe, ápinen gatuh gagu go guvoge me Yabbok. ");
INSERT INTO bqj_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Min Sakob anamo bo nevonol. Ni baj ace atogol bo min gúkuj iki tinah túᵽurul. ");
INSERT INTO bqj_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Aíne ahu no najuh me búoh alet n’ehek Sakob, nategol ni gátagit aijen. ");
INSERT INTO bqj_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Aban naagol : « Uhalom nijow, tinah túᵽullo ! » Sakob naagol : « Mat’ihali ró me nujow aw m’básonienutom. » ");
INSERT INTO bqj_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Naagol : « Aw hereŋ gajai bu ? » Naagol : « Gajaom Sakob. » ");
INSERT INTO bqj_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Aíne ahu naagol : « Maer mati gubbañ guvogi Sakob, ᵽan guvogi Israel. Mata nutaje ni bugan bugagu, nutaj ᵽoᵽ ni Aláemit, ban nuhekil ᵽe. » (\"Israel\" dóemme \"ataj me n’Aláemit\".) ");
INSERT INTO bqj_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Sakob naagol : « Aw may, uboket ugitenom gajai. » Naagol : « Wa uĉile numaŋ uffas gajaom ? » Min ásonienol to. ");
INSERT INTO bqj_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ñer Sakob naah : « Nijuge táh buul Aláemit, ban ínje ume aam to maa m’buroŋ. » Yo eĉil me navoh to Penuel (dóemme \"buul Aláemit\"). ");
INSERT INTO bqj_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","No tinah túᵽullo me, Sakob nápino gatuh gagu gaa Penuel, n’ejih ró mata gátagilol gaij me. ");
INSERT INTO bqj_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Yo eĉil me bi jama bugaa Israel ndi gutiñ gaĉil gagu gajoh me éhoulorum yaa gátagit, mata ni gaĉil gaugu Sakob ábukeni me. ");
INSERT INTO bqj_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ᵽúrto, Sakob najuh atiol Esau o n’éjoul ni buganol gaamme sikeme sibbagir (400). Naŋar guñolol agabor Lea, Raĉel ni urokail gaamme Biliha ni Siliᵽa, ánoan guñolol. ");
INSERT INTO bqj_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Mb’aban naŋar Biliha ni Siliᵽa ni guñolil guyab gayoŋ ; Lea ni guñolol n’gurukenil, min Raĉel ni añolol Susef gúni gúsola. ");
INSERT INTO bqj_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mbiban, aĉila faŋaol nákail ayab gayoŋ. Min ásilen bi n’ettam ñono futoh ni ñúuba bi etoh bo atiol. ");
INSERT INTO bqj_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bare til no Esau ajugol me, nahat náteil iki guemor. Nálloŋol min gukaw bugo éubail. ");
INSERT INTO bqj_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mbiban, Esau najuh waareaw ni uñiaw naagol : « Dáuru bugay guomme búsoli ? » Naagol : « Dáru guñolom bugo Aláemit asenom me. » ");
INSERT INTO bqj_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ñer urokaaw n’gúloful ni guñolil ró iki may gúsilen to. ");
INSERT INTO bqj_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ᵽúrto, Lea ni guñolol n’gúkail gukan mo may. Min Raĉel bugo ni Susef gúni gúsola. ");
INSERT INTO bqj_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau naagol : « Sukore sasu sammeŋ me so niemorulo me ni so baubu, bi wa me ᵽe ? » Naagol : « So ᵽe bi éjii, min mb’ujogom wári. » ");
INSERT INTO bqj_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Naagol : « Atiom, fubajom fiᵽiloom. Ubaŋ wafi bi n’aw ! » ");
INSERT INTO bqj_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Sakob naagol : « Jamb’ukanom me ! Iní me uroŋutom n’ejoh ni fiiñ, uŋar wo níjiei me. Ejugomi énini ti ejuh buul Aláemit, mala min uyabom me wári. ");
INSERT INTO bqj_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Yo eĉil me neege uyab wo niboñuli me, mata Aláemit nakakan bulagoom bútuen min ibaj waf waw ᵽe wo nimaŋ me. » Min ahehoreol me, Esau ñer nahabo nayab. ");
INSERT INTO bqj_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ᵽúrto, naah Sakob : « Maer ñer uiyal nujaal ! Ᵽan ítineni. » ");
INSERT INTO bqj_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sakob naagol : « Atiom, nuffase hum búoh añil let an abaje sembe. Ban ᵽoᵽ ubbarum waw ni síbe sasu saamme n’garafen, sibaje gákanum gámah. Hani funah fanur barebare sijae ejow yal evagen, ᵽan siĉet ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yo eĉil me nimaŋe uyabom gayoŋ. Min ínje irukenul sukoreom ni guñolom min jújoul jatito-jatito, iki jutoli bo Seir. » ");
INSERT INTO bqj_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Naagol : « Ñer ᵽan ihali to guce ni buganom bugo jijaorulo me, min mbi gútinenuli. » Naagol : « Jamb’uyoh bo ! Samen gajamor gúni n’etulola, ᵽiloe. » ");
INSERT INTO bqj_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ñer Esau nabbañ dó ake búot mbaa Seir. ");
INSERT INTO bqj_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sakob aĉila najow bi Sukot, bo nateᵽ me yaŋ bi ni o, nailen to ᵽoᵽ uteb mb’úni uner bi ni sukoreol. Yo eĉil me n’gusen tiñ tautu gajow gagu gaa Sukot (dóemme \"uteb\"). ");
INSERT INTO bqj_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ᵽúrto, najow ak’aĉih apuñol n’ésuh yay yaa Siĉem ni mof mamu maa Kanaan. To ñer bújaorol, bainnulol me baubu Padan-Aram, bítij me. Min ailen to gúgulol lof ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nanom mof maumu to naamme n’guñen guñol Hamor, aju me Siĉem, butum ukib wono ekeme waa síralam. ");
INSERT INTO bqj_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nailen to may físimenum navoh fo El Elohe Israel (dóemme \"Aláemit aamme ala Israel\"). ");
INSERT INTO bqj_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Funah fice, bájur Sakob Dina, o nabaj me ni Lea, najow ake galoden sújur guce bugaa Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ban Hamor, aĉil me mof mamu maa Hiw, nabaje añil ace, gajaol Siĉem. No Siĉem ajuh me bájur babu, najogol min afilenol. ");
INSERT INTO bqj_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Bare no ᵽúrto me, biinumol ᵽe m’búbaho bi ni Dina ak’amaŋol búyab, aban nalih ebutorol. ");
INSERT INTO bqj_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Mbiban naah ᵽayol Hamor : « Ujow uk’urorenom gañen bájur baubu. » ");
INSERT INTO bqj_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sakob naun búoh Siĉem nakakan bájurol gajel. Bare nemme úᵽurol bároŋerul n’gakoñ, naᵽanor yo iki guĉigul. ");
INSERT INTO bqj_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Min aamme n’enagil, ᵽay Siĉem Hamor nájoul ak’atogulol bi eroren gañen Dina. ");
INSERT INTO bqj_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Guñol Sakob no gubbanno me ni gakoñ gagu min guun elob yay, ni táñiil ; guiñil n’gutiñ nár, mata wo Siĉem akan me, úñaiñai ni bugo táli. ");
INSERT INTO bqj_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Bare Hamor naĉagor ni bugo naagil : « Nilaul jisen áᵽurom bájurul ayab, mata biinumol ᵽe ni o nabaŋ bo. ");
INSERT INTO bqj_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Min úruroral, wóli jiyab ni buru, buru n’jiyab ni wóli ! ");
INSERT INTO bqj_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ᵽan uĉinoral, ésuh yauye ᵽan éni yolul. Ᵽan jinamo ró n’jújulla ti jimaŋ me, ban ᵽoᵽ ᵽan júju junom ró ettam. » ");
INSERT INTO bqj_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mbiban, Siĉem faŋaol nailo nalob ni ᵽay Dina ni gúlinol naagil : « Juboket jambi jífiromol. Wánowan wo jijae me erorenom mola, ᵽan isenul wo. ");
INSERT INTO bqj_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Hani jibelom búᵽañ bújalo bu, ᵽan isenul bo, samen jiban n’jisenom álinul iyab. » ");
INSERT INTO bqj_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Nemme Siĉem nakakan álinil gajel, guñol Sakob n’gúbalil ni mutuho ró ");
INSERT INTO bqj_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","n’guogil : « Wóli mati júju jisen álinoli búyabo an anonut búhut ; dáuru kakan gákerulo ni wóli. ");
INSERT INTO bqj_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Waf wanur pat újue ukan n’jiseniol : buru bamaŋer jíni ti wóli, min ánaine ánoan ni buru anogen búhut. ");
INSERT INTO bqj_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","No ᵽan újual me úruroral, buru jiyab ni wóli, wóli may n’jiyab ni buru. Mo ᵽan jíkail jiĉin ni buru, min ukanal bugan buganur. ");
INSERT INTO bqj_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Iní me ᵽan jilat enogen búhut babu, wóli ᵽan jiŋar álinoli min júᵽur babe. » ");
INSERT INTO bqj_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Gurim gauge n’gúsum Hamor bugo ni áᵽurol Siĉem. ");
INSERT INTO bqj_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ñer Siĉem nafaen ajow ake eilo ma firim faufu, mata namamaŋ bájur babu nár, ban nabaj fusumo ni fiilol. ");
INSERT INTO bqj_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ñer Hamor ni Siĉem n’gujow bi n’gánonum ésuh yay to bugan bugagu nihi guomunor me, min gugitenil firim fafu. N’guogil : ");
INSERT INTO bqj_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","« Bugan bugaubugi leti bugan gakelolal etigen. Mb’uhalail n’guĉin dáre n’gújulla. Leti jujuge búoh ésugolal euwuŋ eᵽilo bi ealenil, ban ᵽan úyavoral. ");
INSERT INTO bqj_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bala gújoul gúkail uĉinal tiñ tanur min ukanal bugan buganur, waf wanur pat gurorene : Anáine ánoan ni wolal mb’anogen búhut ti bugo. ");
INSERT INTO bqj_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Jujugut búoh ukanal me ti gulob me, min gújoul iki guĉin ni wolal, sihajil ᵽe ni fubajil ᵽan sujow sujow ni síni sololal ? » ");
INSERT INTO bqj_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","No nalob me aban, gaam to me ni fuomunor fafu n’gumaŋ firim fafu, min wáineaw ᵽe bugal ésuh yay gunogen búhut. ");
INSERT INTO bqj_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Funah fúfaten, wáineaw bugo baroŋer ni ñatiñil, Simioŋ ni Lévi, gaamme may gúlin Dina, n’guŋar ufojeil min gunogen n’ésuh yay yabajut me maer upoya, min gumuh wáineaw ᵽe bugala yo, ");
INSERT INTO bqj_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","bi ni Hamor ni áᵽurol Siĉem dó. N’gúᵽunnul álinil Dina ni yaŋ Siĉem gújaenum. ");
INSERT INTO bqj_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mbiban, guñol Sakob bugagu n’gúkail guteb fubaj gaĉet me ᵽe, n’guteb ᵽe waamme n’ésuh yay, dó ᵽe bi elugen gajel gagu go gukan me álinil. ");
INSERT INTO bqj_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","N’gujoh ᵽoᵽ ubbarumil, sijamenil, síbeil, musumil, n’guteb wánowan waam dó me n’ésuh yay ni may waamme n’ulah waw. ");
INSERT INTO bqj_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","N’gújaenumor waareaw bugal ésuh yay ni guñolil ró, n’guteb waf waw ᵽe waamme ni saŋ sasu. ");
INSERT INTO bqj_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","No bao me, Sakob návogul Simioŋ bugo ni Lévi naagil : « Buru jikelo jikanom gaᵽinor gámah ! Bakanerul ᵽan biĉil bugaa Kanaan ni Ᵽeris min gulalom. Jujuge búoh ummeŋutal. Guke me gugum firim fanur min gunonulom, ᵽan gubanolal ᵽe, ínje ni buru gabugorom. » ");
INSERT INTO bqj_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","N’guogol : « Mati júju jihat áine ahumu akan me álinoli ti ejobu, min aroŋ. » ");
INSERT INTO bqj_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Funah fice, Aláemit naah Sakob : « Uilo ujow uk’uĉin Betel. Mb’uilenom bo físimenum, mata baubu níᵽulli me no nuomme n’etey úhatulo atii Esau. » ");
INSERT INTO bqj_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ñer Sakob naomen fiilol ni buganol ᵽe naagil : « Júᵽuren sínati sasu ᵽe saamme ni saŋul jibelen. Juuwo jukur n’jikano wañ wakure. ");
INSERT INTO bqj_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mbi jiban, n’juomen wañul min ujaal mbaa Betel uk’uĉinal bo. Ᵽan iilen bo físimenum bi esal Aláemit, mata náttunomtun no niomen me ni sílam, ban tánotan to nijae, umu búsolom. » ");
INSERT INTO bqj_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ñer n’gúᵽuren sínatiil ni suloŋuloŋil ᵽe gusen Sakob afogen fattam bununuh babu bámah babu baam to galam Siĉem. ");
INSERT INTO bqj_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","No Sakobi gúvuh me gukay, Aláemit nakan súsuh sasu ságolil me gáholi gámah jambi sikañen síkail etigen. ");
INSERT INTO bqj_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ñer Sakob ni buganol niki guĉih Lús, yaamme maer Betel, ni mof mamu maa Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nateᵽ bo físimenum min avoh fo El Betel (dóemme \"Aláemit ala Betel\"), mata Aláemit bo náᵽullol me no naamme n’etey atiol Esau. ");
INSERT INTO bqj_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ban Debora aamme aare ahu o nah’acokor me Rebeka, nak’aĉet. Min gufogol bo Betel fattam bununuh bámah ; no ñer gukan bo me gajow gagu gaa Alon Bakut (dóemme \"bununuh babu bal ukoŋ\"). ");
INSERT INTO bqj_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Mamu Sakob abbanno me Padan-Aram, min Aláemit áᵽullol násonienol ");
INSERT INTO bqj_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","naagol : « Maagen gajai Sakob, bare maer mati gubbañ guvogi Sakob, ᵽan guvogi Israel. » Ñer Aláemit nakanol gajow gaugu. ");
INSERT INTO bqj_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nabbañ aagol : « Injé iomme Aláemit-Sembe. Ᵽan ubaj gátuh gahulo, min ukan ᵽay afan ala súsuh sammemmeŋ, ban ni gabugori ᵽan baj ró úvi. ");
INSERT INTO bqj_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mof mamu mo nieh me mb’isen Aburaham ni Isak, ᵽan míni may míya. Ban no nujae me egub buuli, ᵽan míni maa guñoli ni gabulakenil. » ");
INSERT INTO bqj_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Aláemit no nalob me Sakob aban, nabbañ mbaa fatiya. ");
INSERT INTO bqj_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Min Sakob ailen to eval náĉir yo, aban náyu to bíñu, ");
INSERT INTO bqj_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","mb’aban nakan to gajow gagu gaa Betel. ");
INSERT INTO bqj_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","No gát to me, Sakob ni fiilol n’gúᵽur Betel guriŋen mbal Efarata, Raĉel o ni far dó. Funagol niki fiĉih bu m’baĉigerut Efarata. N’enogen yay nabaj buyoh bámah. ");
INSERT INTO bqj_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Afan bárinay babu no najugol me min ataje me, naagol : « Jamb’úholi, ᵽan utajen ubaj júᵽur. » ");
INSERT INTO bqj_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Bare Raĉel naffas búoh mat’aroŋ. No naamme n’ejow bi eĉet, navoh júᵽur jaju Ben-Oni (dóemme \"júᵽur jaa buyogom\"). Bare Sakob nakan jo gajow gagu gaa Baisomen (dóemme \"júᵽur jaa gañenom gárib\"). ");
INSERT INTO bqj_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raĉel nak’aĉet min gufogol n’galam bulago babu bal ejow mbal Efarata, yo guvoge me may Betuleem. ");
INSERT INTO bqj_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Mbiban Sakob nailen eval to ni fuyagol bi ekan fúffasum ; eval yauyu yo eom to bi jama. ");
INSERT INTO bqj_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Sakob nabbañ ajow ak’ailen fúgulol o bágaler Migidal-Eder. ");
INSERT INTO bqj_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","No guom bo me, funah fice Ruben nafilen Biliha aamme abel jaol. Ᵽayol no naffas yo me, ni táñiol. Uᵽúr Sakob guomme ñer guñen ni gúuba : ");
INSERT INTO bqj_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea nasenol Ruben aamme afamma, Simioŋ, Lévi, Yuda, Isahar ni Sabuloŋ. ");
INSERT INTO bqj_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raĉel aĉila nabugol Susef ni Baisomen. ");
INSERT INTO bqj_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Biliha aamme aroka Raĉel, o nasenol Dan ni Nafutali. ");
INSERT INTO bqj_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Siliᵽa aamme aroka Lea, o nabugol Gad ni Aser. Dáuru guñol Sakob bugo nabugulo me Padan-Aram. ");
INSERT INTO bqj_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Sakob nak’aĉigul to ᵽayol Isak aamme, baubu Mámure galam Kiriat-Aruba, yo guvoge me jama Heboron. Ban Aburaham ni Isak bugo baĉiner bo ᵽio bo. ");
INSERT INTO bqj_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak fufaneol ni fiᵽio ak’abaj símit ekeme ni úvi gubbagir (180), bala akay atoh bo sipayol n’ufuga. Ñer guñolol Esau bugo ni Sakob n’gufogol. ");
INSERT INTO bqj_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dáure fiil Esau o guvoge me may Edom : ");
INSERT INTO bqj_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nayab waare bugaa Kanaan : Ada, bájur Elon ala Hit ; Oholibama, bájur Ana o Sibeon ala Hiw abuh me ; ");
INSERT INTO bqj_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","nabbañ ayab Basamat álin Nebayot, bugo Isimael abuh me. ");
INSERT INTO bqj_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nabuh Elifas, Basamat o nabuh Réuel. ");
INSERT INTO bqj_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nabajol Yéuĉ, Yalam ni Kora. Dáuru guñol Esau bugo nabuh me Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau nájaenum waarol, guñolol, sihajol ni wo nabaj ró me ᵽe Kanaan, min atos ajow árali atiol Sakob, mbaa mof mice. ");
INSERT INTO bqj_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nemme bugo éubail gubabaj mámah, gújuut guĉin gulofor, mata mof mamu dó guomme mújuut mutogil bi gakoñ dó sukoreil. ");
INSERT INTO bqj_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yo eĉil me Esau, o guvoge me may Edom, nak’aĉin ni gurijaŋ gagu gaa Seir. ");
INSERT INTO bqj_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dáure gabugor Esau aamme ᵽay afan bugaa Edom, gaĉin me ni gurijaŋ gagu gaa Seir : ");
INSERT INTO bqj_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Guñol Esau wáinema ubuge : Elifas o aarol Ada abuh me, ni Réuel o aarol Basamat abuh me. ");
INSERT INTO bqj_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Uᵽúr Elifas bugo guomme Teman, Omar, Sefo, Gatam ni Kenas. ");
INSERT INTO bqj_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas nabaj anaare áuten o naᵽañut me, gajaol Timina, abugol me ace áᵽur gajaol Amalek. Dáuru gabulaken Esau bugo n’aarol Ada. ");
INSERT INTO bqj_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Uᵽúr Réuel bugo guomme Nahat, Sera, Ĉama ni Misa. Dáuru gabulaken Esau bugo n’aarol Basamat. ");
INSERT INTO bqj_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibama, bájur Ana o Sibeon ala Hiw abuh me, nabuh Esau úᵽur gúfaji gaamme Yéuĉ, Yalam ni Kora. ");
INSERT INTO bqj_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dáure gabulaken Esau gakan me ufan bugaa súsuh : Teman, Omar, Sefo, Kenas, ");
INSERT INTO bqj_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ni Amalek ; bugo ᵽe Elifas, áᵽur Esau afamma, abugil n’aarol Ada. N’guĉin Edom. ");
INSERT INTO bqj_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ufan waw bugaa súsuh bugo Réuel abuh me, guomme Nahat, Sera, Ĉama ni Misa. Bugo may, Edom guĉine, ban bugo gabulaken Basamat ni Esau gom. ");
INSERT INTO bqj_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Guñol Esau bugo Oholibama añol Ana asenol me, gaamme Yéuĉ, Yalam ni Kora, bugo éfajiil n’gukan may ufan súsuh. ");
INSERT INTO bqj_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dáuru ñer ufan waw bugaa súsuh Edom gáᵽullo me ni fiil Esau. ");
INSERT INTO bqj_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Gamundum me guĉin ni mof mamu mal Edom, bugo guomme gabugor Seir áᵽullo me Hor. Uᵽúr Seir bugo guomme Lotan, Ĉobal, Sibeon, Ana, Diĉon, Eser ni Diĉan ; bugo ᵽe ufan súsuh bugom. ");
INSERT INTO bqj_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Uᵽúr Lotan bugo guomme Hori ni Hemam ; álin Lotan gajaol Timina. ");
INSERT INTO bqj_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ĉobal úᵽurol bugo guomme Alivan, Manahat, Ebal, Ĉefo ni Onam. ");
INSERT INTO bqj_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon úᵽurol bugo guomme Aya ni Ana. Ban Ana o aamme átiar ejuh ébula ni gafit gagu gámah gagu, o n’gakoñ musum ᵽayol Sibeon. ");
INSERT INTO bqj_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana nabaje áᵽur gajaol Diĉon ni bájur gajaol Oholibama. ");
INSERT INTO bqj_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Diĉon úᵽurol bugo guomme Hemudan, Eĉeban, Yitiran ni Keran. ");
INSERT INTO bqj_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser úᵽurol n’guno Bilehan, Savan ni Akan. ");
INSERT INTO bqj_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Diĉan úᵽurol bugo guomme Us ni Aran. ");
INSERT INTO bqj_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Dáuru ñer gakan me ufan bugaa súsuh ni mof mamu maa Seir : Lotan, Ĉobal, Sibeon, Ana, Diĉon, Eser ni Diĉan. ");
INSERT INTO bqj_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ni mof mamu maa Edom, bajene úvi bala Israel gubaj bugolil. ");
INSERT INTO bqj_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Atíar ahu gajaol Bela, añol Beor, ala ésuh yay yaa Dinaba. ");
INSERT INTO bqj_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","No naĉet me, n’gúvien Yobab añol Sera ala ésuh yay yaa Bosra. ");
INSERT INTO bqj_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","No may aĉila aĉet me, n’gúvien Huĉam ala mof mamu maa Teman. ");
INSERT INTO bqj_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","No naĉet me, Hadad añol Bedad, ala ésuh yay yaa Avit, naŋar efenjeŋ yay. Natigen bugaa Majan ni mof mamu maa Moab aham. ");
INSERT INTO bqj_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","No Hadad aĉet me, n’gúvien Samula ala ésuh yay yaa Masreka. ");
INSERT INTO bqj_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","No naĉet me, n’gúvien Ĉaul ala Rehobot yaamme galam fal. ");
INSERT INTO bqj_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","No naĉet me, n’gúvien Baal-Hanan añol Akubor. ");
INSERT INTO bqj_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Mbi no naĉet me, n’gúvien Hadar ala ésuh yay yaa Pau. Aarol gajaol Mehetabel, bájur Matared, gabulaken Mey-Sahab. ");
INSERT INTO bqj_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dáure ufan bugaa súsuh ni mof mamu maa Edom ni guilil dó gúᵽullo me : Timina, Aliva, Yetet, ");
INSERT INTO bqj_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO bqj_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibisar, ");
INSERT INTO bqj_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidiel, Iram. Anóan ni bugo naogenwogen mof. Dáuru ñer ufan mof mamu maa Edom mo Esau ailen me. ");
INSERT INTO bqj_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Sakob nanamo ni mof mamu maa Kanaan, bo ᵽayol akelo me aĉin. ");
INSERT INTO bqj_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Maa jow maa ni gabugorol : Susef abaj me símit gaat ni súuba, nah’aramben gutiol bugagu min gukoñ ubbarum waw ni sijamen sasu ; gutiol gaamme bugaa Biliha ni Siliᵽa, gaamme ᵽoᵽ waar ᵽayol. Susef nánonan nagiten ᵽayol maarat mamu mo gulobe me guya ni gutiol. ");
INSERT INTO bqj_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Sakob namaŋ Susef iki faŋ guñolol bugagu, mata ni fúfanumol nabugol ; nafiol gájuo gumecor gúari. ");
INSERT INTO bqj_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Gutiol no gujuh me búoh ᵽail aĉila nafaŋe namaŋe, n’gújohatiol iki mati ni’gulob ni o súm. ");
INSERT INTO bqj_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Funah fice Susef náyeut ; no nagiteneil so me, n’gufaŋ n’gulalol. ");
INSERT INTO bqj_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Mata naagil : « Juutten min ilobul síyeutom. ");
INSERT INTO bqj_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nogonogor ti nuh’ukaal me ehoh guĉah n’ulah waw. Néni to éni, fuĉagom ni fiilo to firih bújonih, min golul ᵽe gújoul iki gúgot fo n’gúsilen. » ");
INSERT INTO bqj_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ñer gutiol n’guogol : « Aw ᵽiaŋ numamaŋ ejogoro búoh aw ávioli bi eogenóli ? » Min alobeil so me, mo may gufaŋe me n’gulalol. ");
INSERT INTO bqj_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Susef nabbañ áyeut natajen agitenil naagil : « Nibbañe íyeut. Nijuge tinah, fieñ ni suut sono guñen ni yanur sísilen bíᵽimborom. » ");
INSERT INTO bqj_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","No nagiten so me ᵽayol, nanurol naagol : « Síyeut sausu, síyeut bu som ? Yaamme búoh ínje ni jai ni gutii ᵽan jísilen bi n’ettam bíᵽimbori ? » ");
INSERT INTO bqj_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ñer gutiol n’gúsilaet mola. Bare ᵽail nabaŋ gurim gaugu m’biinumol. ");
INSERT INTO bqj_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Funah fice, guti Susef n’gujow bi Siĉem guke bo gakoñ ubbarum waw ni sijamen sasu saa ᵽail. ");
INSERT INTO bqj_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Mb’uĉiga funah fice, ᵽayol naagol : « Gutii ubugu baubu, galam Siĉem gunave n’guno gakoñ ekore yay. Ujow ᵽaa uk’ujugulil. » Naagol : « Apa, nimaŋe. » ");
INSERT INTO bqj_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Sakob nabbañ aagol : « Ujow min uffas ter ubugu bo apuñil, ter ᵽoᵽ ekore yay apuñ yo. Mb’uban, núbbañul uk’ulobom. » Ñer náᵽur to Heboron to guomme, akay bo ᵽayol aboñol me. No nalof me Siĉem, náni n’eŋes ekore yay, ");
INSERT INTO bqj_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","naemor n’ace áine. Aíne ahu narorenol : « Wa non n’eŋes ? » ");
INSERT INTO bqj_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Naagol : « Gutiom niŋese. Ugitenom bay gom, bugo ni ekoreil. » ");
INSERT INTO bqj_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Naagol : « Gúᵽure tale. Niunil guunen ejow mbaa Dotan. » Ñer Susef nalagen uhagil ak’ajugil bo Dotan. ");
INSERT INTO bqj_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kan gutiol guŋandenol o n’elofil. Bala aĉih to, bugo bajoger guban bu gujae me ekan n’gumugol. ");
INSERT INTO bqj_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","N’gubunor guoh : « Ayéuta ahu umua. ");
INSERT INTO bqj_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ujaal umugalol. Umugalol ubenal n’éhaᵽa. Mb’ubanal, nuogal énuhureŋ baha ejogol. Min mb’ujugal ter síyeutol ᵽan sikano ! » ");
INSERT INTO bqj_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben naun min gulobe me jamugol, namaŋ bi eᵽagenol. Naagil : « Jamb’umugalol ! » ");
INSERT INTO bqj_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Natajen aagil : « Jamb’úyual físimol ! Ubenalol maroŋe n’éhaᵽa, bare jamb’uᵽikaol buroŋ ! » Dó ᵽe bi eᵽagenol n’guñenil abbañen bi ni ᵽayol. ");
INSERT INTO bqj_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","No Susef aĉih to me ni gutiol, n’gujogol n’guram gájuool gamecor me. ");
INSERT INTO bqj_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Mbi guban, n’gubenol n’éhaᵽa. Ban éhaᵽa yay ehahay. ");
INSERT INTO bqj_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Púrto, n’gunamo bi fitiñ. N’guŋanden fítiman faa bugan bugal Isimael, gáᵽullo Galaad. Suñokomboil ni sítebul waf wammeŋe : físim fatiŋoe fal ununuh, mitiñ maaro ni míĉir, bi eke funomen wo ni mof mice, gajow mo Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda naah gutiol : « Fubaj fay nujaale ebaj wolal bamuger atiolal, mb’ubanal nukoenal eĉelol ? ");
INSERT INTO bqj_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Faŋe jáari unomenaol bugal Isimael. Bare súñunduol uhalaol so. Dáru atiolal om, físimolal fanur. » Gutiol n’gumaŋ firimol. ");
INSERT INTO bqj_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ñer unomena guce bugal Isimael n’gúni to n’égat. Guti Susef n’gúᵽunnulol n’éhaᵽa yay min gunomenil o sifaraku ávi ; ubuge n’gújaenumol mbal Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ban Ruben no nabbanno me bi to n’éhaᵽa yay (nemme amatut funomen fafu), atogut ró Susef. Ñer ni mujogol ak’aĉaĉ wañol, ");
INSERT INTO bqj_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","nabbañ ak’atoh bo gutiol naagil : « Susef álero. Injé maer bu nijae me ekan ? » ");
INSERT INTO bqj_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ñer gutiol n’gumuh fíjehel n’guŋar físim fo gúluten gájuo Susef. ");
INSERT INTO bqj_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Guban n’guboñ go bi ni ᵽail ni gahoŋen gauge ró : « Gañ gauge jiraŋene. Ulíngen go min ujuh ter gal áᵽuri. » ");
INSERT INTO bqj_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Sakob naffas go náᵽib aah : « Dáru gájuo añolom ! Enúhureŋ baha ejogol ! Susef naĉele ! » ");
INSERT INTO bqj_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ñer ni mujogol bireg naĉaĉ wañol, aban nakano uce waa gúnigo min akoŋol gunah gammemmeŋ. ");
INSERT INTO bqj_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Guñolol ᵽe n’gúkail bi esaforol, bare nalat. Naagil : « Ñuhul ñe ᵽan ñurobo n’ínje bi no nijae me ealo itoh bo áñum ni ufuga. » Naroŋ bae n’ukoŋ waw. ");
INSERT INTO bqj_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ban bugaa Majan no guĉih me Esíp, n’gubbañ gunomen bo Susef ace áine gajaol Potifar. Aíne ahumu ávula ávi nam, ban náni afan upoyaol. ");
INSERT INTO bqj_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Gannay gaugu, Yuda nahat bo gutiol min áuy mbal ésuh ece yo guvoge me Adulam. Narobo bo ni abugeol ace, gajaol Hira. ");
INSERT INTO bqj_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Najuh bo bájur ace áine gajaol Ĉua, ala Kanaan. Nayabol n’gurobo. ");
INSERT INTO bqj_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nateb ak’aalen nabaj júᵽur. Yuda nakan jo gajow gagu gaa Er. ");
INSERT INTO bqj_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nabbañ ateb nabaj júᵽur jice navoh jo Onan. ");
INSERT INTO bqj_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ᵽúrto, nabaj júᵽur jífaten navoh jo Ĉela. No nabugei me, Yuda o baamer Kesib. ");
INSERT INTO bqj_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","No áᵽurol afamma aamme Er, aak me, ᵽayol naliᵽol anaare gajaol Tamar. ");
INSERT INTO bqj_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bare buroŋ Er búsumut Atúla, mo kane nakanol naĉet. ");
INSERT INTO bqj_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ñer Yuda naah Onan : « Núarie usen atii aĉet me uñil, ñer uk’utunol. » ");
INSERT INTO bqj_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Bare Onan naffase búoh añil ahumu guñumutol ejoh ti ola ; yo eĉil me, guke me búnogen, nain nahat eugilol elo n’ettam, mamu jamb’asen atiol añil. ");
INSERT INTO bqj_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Bakaner baubu búsumut Atúla, min akanol may naĉet. ");
INSERT INTO bqj_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ñer Yuda naah ásabulol Tamar : « Aw nemme ubajut ánaine, ubbañ mbaa ᵽai min uirigen Ĉela nákanul anafan. » Mata n’gaᵽinorol náholiholi jambi Ĉela aĉet ti gutiol. Ñer Tamar nabbañ bi yaŋ ᵽayol. ");
INSERT INTO bqj_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ᵽúrto ᵽio bo, bájur Ĉua aamme aar Yuda naĉet. No ñuhul ñañu ñígat me, Yuda naŋar abugeol Hira ala Adulam, min gujaor mbaa Timina bi eke bujuh úciga bufal ubbarumol. ");
INSERT INTO bqj_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ni baj an aah Tamar : « Ᵽay áini umu n’eke écih bufal ubbarumol baubu Timina. » ");
INSERT INTO bqj_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ñer Tamar náᵽuren wañol waa ñuhul akano uce, aban nafut buulol jambi an affasol. Nak’arobo ni fukaen fafu faa Timina galam bújalingenor babu bal Enaim. Najuh maagen búoh Ĉela maer naake, ban Yuda asenutol o. ");
INSERT INTO bqj_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda no najugol me, najogol ejanjaŋ-bulago, min afut me buulol ; ");
INSERT INTO bqj_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","affasut búoh dáru ásabulol. Ñer nak’atogol bo n’galam bulago babu min aagol : « Ujaa ufiya ! » Naagol : « Wa ᵽan usenom ? » ");
INSERT INTO bqj_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda naagol : « Ᵽan iboñuli jíjehel jal ekoreom. » Naagol : « Yoo, bare umundum ᵽan uhalom tale waf uce. » ");
INSERT INTO bqj_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Naagol : « Wa numaŋe ? » Naagol : « Usenom eĉelai yáamumma, ganew yo ni ᵽoᵽ fijigumi. » Yuda nasenol so ᵽe min guke gufilo, ban naŋar far. ");
INSERT INTO bqj_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ñer Tamar nabbañ bi yaŋol nafululo, aban nabbañ asimo wañol waa gúnigo. ");
INSERT INTO bqj_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda naboñ abugeol Hira ala Adulam min ájaenum jíjehel jaju ti gulob me ; tima mb’áju áyabul wafol wo nahatulo me. Bare abugeol no naĉih bo me, abbañut ajuh aare ahu. ");
INSERT INTO bqj_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Naroren bugal Enaim : « Ejanjaŋ-bulago yay yaamen me tautu n’galam bulago babu, uyela ? » N’guogol : « Músut baj taute ejanjaŋ-bulago. » ");
INSERT INTO bqj_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nábbañul ak’atoh Yuda naagol : « Aare ahumu ijugutol. Hani gaĉin bo me, guogom tiñ tautu músut baj to ejanjaŋ-bulago. » ");
INSERT INTO bqj_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ñer Yuda naagol : « Wañ waw ñer abaŋ wo. Jamb’uoᵽoroa ñusu. Niboñene jíjehelom, ban aw ubbañut ujuh aare ahumu. » ");
INSERT INTO bqj_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","No gueñ gúfaji gúgat me, n’gúkail guoh Yuda : « Asábuli Tamar etey ñawuy náᵽure ak’aŋar far. » Yuda naah : « Jujogol jisaen maroŋe ! » ");
INSERT INTO bqj_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","No gúᵽunneulol me tíyaŋ, naboñ guoh Yuda : « Aíne ahu aĉil me wañ wauwe, o afatenom. Mb’uluj tima nuffas ay aĉile eĉela ye, jinew je ni fíjigum fe. » ");
INSERT INTO bqj_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda no najuh wo me, naffas wo naah : « Aare ahume nabaje maagen n’ínje, mata niarene isenol áᵽurom Ĉela ayab. » Nabbañulol áni n’gañenol, ban abbañut afilo ni o. ");
INSERT INTO bqj_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","No funagol fiĉih me, n’gujuh búoh múuba najae ebaj. ");
INSERT INTO bqj_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","N’epegor yay, ace ni bugo náᵽunnul jiñenol. Afan bárinay babu najoh jo aban nahoh jo bíbil bújugah naah : « Ume aamme átiar. » ");
INSERT INTO bqj_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bare jiñil jaju n’júrur jiñen jo min jiti jo jumundum jo júᵽurul. Afan bárinay babu naah : « Bu núᵽullo me fús ! » Ñer Yuda nakanol gajow gagu gaa Ᵽeres (dóemme \"éfusel\"). ");
INSERT INTO bqj_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mbiban, jipajo n’júᵽurul, jo gañen jo guhogi me bíbil babu bájuh me. Yuda navoh jo Sera. ");
INSERT INTO bqj_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kan bugal Isimael gájaenum me Susef bi ni mof mamu mal Esíp, gunomenolnomen ace áine gajaol Potifar, ala bo Esíp. O ávula ávi nam, ban náni afan upoyaol. ");
INSERT INTO bqj_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Atúla umu búsol Susef, ban wáfowaf nakane, ni wári. Potifar naŋarol aĉin ni yaŋol. ");
INSERT INTO bqj_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Najuh búoh Atúla umu búsol Susef nakanol ápiraet ni wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ñer Potifar násum ni o, ban naŋarol nah’arokol. Namaŋol nár iki asenol yaŋol ni fubajol ᵽe aogenol. ");
INSERT INTO bqj_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ni mútut mamu no nakan mo me, Atúla násonienol min wafol ᵽe úari, dó ᵽe mala Susef. Gásonien gagu gal Atúla n’gúni ni wafol ᵽe, újogum ni yaŋol bi n’ulagol ró. ");
INSERT INTO bqj_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nahat fubajol ᵽe n’guñen Susef. Uᵽúren me fitiñol, abbañut agor waf uce. Ban Susef ánaine áarie, aban nailo liŋ. ");
INSERT INTO bqj_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","N’gúni ró gúni, aar Potifar nátalloulol ak’aagol : « Ujóul ufiya ! » ");
INSERT INTO bqj_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Susef nalat naagol : « Let nujuge búoh ni mútut no neemme tale, afanom abbañut akan búlar bánoban dáre ni yaŋol. Nahale n’gañenom wafol ᵽe wo nabaj me. ");
INSERT INTO bqj_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Abbañut abaj dáre sembe iki sifaŋ súmbam, áfirenutom wáfowaf, let me egor aw aamme aarol. Ñer níjue ᵽiaŋ ikan waf wáhojie ti wauwu min itil n’Aláemit ? » ");
INSERT INTO bqj_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gunah émit ᵽe náh’ákail arondopenol mala gafilo, bare nalat euttenol, hani elofol. ");
INSERT INTO bqj_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Funah fice, Susef nanogen ni yaŋ yay bi ekan burokol, toker urokaaw m’baleto. ");
INSERT INTO bqj_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ñer aare ahu najoh gájuool min aagol : « Ujaa ufiya ! » Bare Susef nahat gájuool ni gañenol min áteil áᵽur tíyaŋ. ");
INSERT INTO bqj_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Aare ahu no najuh me búoh Susef nahamenolhamen gájuool min atey áᵽur, ");
INSERT INTO bqj_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","návogul urokaaw naagil : « Juluj ᵽaa, áinom naŋallo an ala Híbori min ajelolal. Najoulo ak’atogom dó bi gafilo n’ínje, bare niya gáᵽib gámah. ");
INSERT INTO bqj_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ñer no naunom me íᵽib nivoh nímoro, natey cab áᵽur ni yaŋ yay, ban nahato gájuool n’galambom. » ");
INSERT INTO bqj_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ᵽúrto, aare ahu naogen gájuo gagu bi no áinol abbanno me. ");
INSERT INTO bqj_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nabbañ alobol firim fafu fanur fafu naagol : « Amigel ahu úiya ala Híbori o nuŋalóli me, nakelo atogom bi gafilo n’ínje. ");
INSERT INTO bqj_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","19","No níᵽib me nivoh nímoro, nabelen to gájuool galambom min atey áᵽur. Amigel ahu úiya mamu nakan me n’ínje. » No ala yaŋol aun me bagitener aarol, fiiñol ni fitiñ nár. ");
INSERT INTO bqj_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Naboñ gujoh Susef iki gubaŋol ni fipeh umigel ávi ahu. Hani no Susef aamme ni fipeh, ");
INSERT INTO bqj_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Atúla umu búsolol. Nagitenol músumol ak’akan min gaunor gubaj n’etulil o ni afan fipeh fafu. ");
INSERT INTO bqj_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Afan ahu ñer nakanol áni ni fuhow gupalol ᵽe bugo gupeh ró me. Bajut waf ukani ró o m’báĉibbenut wo. ");
INSERT INTO bqj_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Afan ahu abbañut agor wo nahat me n’gañen Susef, mata Atúla aamme ni o násoniesonien búlarol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Ᵽio bo, funah fice, bugagu úvula gúuba bugal ávi Esíp n’gutil ni o. Ace ni bugo o aĉil me miremay mamu mola, ahuo o aamme afan usoa unaĉol. Aví ahu fiiñol ni fitiñil ");
INSERT INTO bqj_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ak’ajogil abaŋ ni fipeh fafu fal afan upoyaol, dó may Susef apegi me. ");
INSERT INTO bqj_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Afan upoya ahu nábahenil ahat ni gañen Susef min acokoril. N’gunamo ró gunah guman. ");
INSERT INTO bqj_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Efuga ece, bugo éubail n’gúyeut síyeut sábuliore. ");
INSERT INTO bqj_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","No Susef akelil me bujuh ni bujom, natogil min guñahore, ");
INSERT INTO bqj_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","naagil : « Buru jama junogorom bugan gasarut. Wa ubajul ? » ");
INSERT INTO bqj_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","N’guogol : « Jíyeuyeut éubaoli, ban an ájuut agitenóli wa sulobe. » Naagil : « Aláemit nevonol nájue áᵽajulul so. Jigitenom so ᵽaa ! » ");
INSERT INTO bqj_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ñer aĉil me miremay ávi nagiten aah : « Injé ni síyeutom nijuge bíbiñu biilo bújoŋorom, ");
INSERT INTO bqj_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","m’bubaj uan wono úfaji. Ban ni bijef to baenah, iki buya min bubuh gújeŋ iki gújuh. ");
INSERT INTO bqj_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nítuh n’gañenom éremuma ávi ahu, niŋar subugum sasu iñafen dó n’éremuma yay. Mbiban nisenol yo arem. » ");
INSERT INTO bqj_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Susef naagol : « Síyeuti maa sulobe : Uan waw úfaji wo uomme gunah gúfaji. ");
INSERT INTO bqj_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ban tale gunah gúfaji, ávi ahu ᵽan atebeni fatiya, ak’abbañeni buroki ; ᵽan nuh’uñurenol éremumaol ti no. ");
INSERT INTO bqj_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ñer uboket jamb’újumorom aw babbañer unamo jon. Mb’ulob múmbam ávi ahu, tima níᵽur ni fipeh fe. ");
INSERT INTO bqj_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ti maagen, babu guramulom n’ésuh yay yal Ehíbori yay, ban babe ímusut ikan maarat maĉil me n’gupegom dáre. » ");
INSERT INTO bqj_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ñer afan usoaaw najuh búoh bagitener babu búariari. Naah Susef : « Injé may níyeute, niteb ni fuhoom utegel úfaji wájutenore wal unaĉ wásume. ");
INSERT INTO bqj_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ni gaa fatiya, ganaĉ gánogan go asoa nah’akan bi fitiñ ávi ahu, ugu ró. Ban mupu mamu nihi múkail mitiñ dó. » ");
INSERT INTO bqj_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Susef naagol : « Síyeuti maa sulobe : Utegel waw úfaji wo uomme gunah gúfaji. ");
INSERT INTO bqj_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ban tale gunah gúfaji, ávi ahu ᵽan atebeni fatiya, bare bi eĉagi úrien ni bununuh, min mupu mamu múkail mitiñ efuluŋi. » ");
INSERT INTO bqj_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mb’uĉiga funah fúfaten, ávi ahu náni n’ekan úvulaol gaggan funagol fo nabugi me. Ñer naboñ gúhanul afan miremayol ni ala usoaol unaĉ bújoŋor ésuh yay ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Aĉil me miremay mamu, ávi nabbañenol burokol min abbañ nah’añurenol éremuma yay. ");
INSERT INTO bqj_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bare ahu, naboñ min guĉagol árien, ti Susef alob yo me. ");
INSERT INTO bqj_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Toker afan miremayol o bájumorer Susef faĉaw. ");
INSERT INTO bqj_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","No símit súuba sígat me, ávi ahu ala Esíp náyeut ; ni síyeutol náni n’galam fal fafu fo guoge me Nil. ");
INSERT INTO bqj_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Najuh síbe sono futoh ni súuba sáarie ban ni sili bib súᵽurul dó ni fal fafu ni síni to n’gafen. ");
INSERT INTO bqj_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mbiban, sice futoh ni súuba ni súᵽurul dó may, súhoji taw ban ni sigan. Ni sújoul sutoh to sáari me n’galam fal fafu. ");
INSERT INTO bqj_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ñer síbe sasu sagan me ban ni súhoji ni síhab sasu sáari me. No, ávi ahu naᵽagor álio. ");
INSERT INTO bqj_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nabbañ ámori natajen áyeut. Najuh gukoñ futoh ni gúuba, fuhoŋol go fanur, gúari ban ni guli. ");
INSERT INTO bqj_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mbiban, guce futoh ni gúuba n’guil gulof gáari me. Gaugu, érus yay yásuᵽ me nellaben go min guhay. ");
INSERT INTO bqj_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ñer gahay me n’gúmer gagu gáari me. Aví ahu nabbañ álio nátallo búoh síyeut som. ");
INSERT INTO bqj_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mb’uĉiga ni bujom, nágogor ák’ávogul úutaaw ni ufan waw bugal Esíp ᵽe. Nagitenil síyeutol, bare an ájuut áᵽajulol so. ");
INSERT INTO bqj_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ñer afan miremay ávi ahu naagol : « Yoo, áviom, jama niosene gatilom ");
INSERT INTO bqj_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","gaĉil me nupególi ni fipeh afan upoyai no fiiñi fitiñóli me, ínje ni asoa unaĉ waw. ");
INSERT INTO bqj_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Eúbaoli n’efuga yanur n’jíyeut síyeut sábuliore. ");
INSERT INTO bqj_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ban ni baj dó ni fipeh fafu ace áᵽur amigel ala mof Híbori, aamen n’gañen afan upoyaaw. O áᵽajuloli ánoan síyeutol, ");
INSERT INTO bqj_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ban wo nalobóli me, wo may ubaj me : ínje nubbañenom ni burokom, bare apalom nuĉagol. » ");
INSERT INTO bqj_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ñer ávi Esíp naboñ gúŋarul Susef. N’gúᵽunnulol ni majase ni fipeh fafu, n’gúcigol guban n’gusimol wañ uvugul. Mbiban nájoul bújoŋor ávi ahu. ");
INSERT INTO bqj_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Aví ahu naagol : « Níyeute, ban an ájuut áᵽajulom so. Bare guogom aw nújue úᵽajul síyeut sánosan so gulobi. » ");
INSERT INTO bqj_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Susef naagol : « Let ínje, bare Aláemit nájue áᵽajuli so iki súmi. » ");
INSERT INTO bqj_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Naagol : « Síyeutom use. Galam fal niomene. ");
INSERT INTO bqj_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nijuh síbe futoh ni súuba síari ban ni sili bib súᵽurul dó ni fal fafu, min síni n’gafen. ");
INSERT INTO bqj_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mbiban, sice mul futoh ni súuba ni súᵽurul. Súhoji taw, sigan nár ban ni súguret. Imúsut ijuh Esíp ᵽe síbe súhoji ti sausu. ");
INSERT INTO bqj_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ñer síbe sausu ni síhab sítiar sasu sali me. ");
INSERT INTO bqj_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bare hani min símer so me, ni suroŋ bae n’egan ti siᵽi me. Ñer no niᵽagor me ílio. ");
INSERT INTO bqj_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ᵽúrto, nibbañ íyeut. Nijuge gukoñ futoh ni gúuba gúari ban ni guli bib gaile ni fuhoŋol fanur. ");
INSERT INTO bqj_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mbiban, ni baj guce gono futoh ni gúuba, guhay ban ni guak kaŋ, go érus yay elabene, guil galam gútinar gagu. ");
INSERT INTO bqj_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ñer gahay me n’gúmer gagu gáari me. Síyeut se, nigiten so úutaaw búgumbam, bare gújuut gúᵽajulom so. » ");
INSERT INTO bqj_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Susef naagol : « Avíom, síyeuti súuba sasu tiñ tanur súuñene. Aláemit umu n’egiteni wo najae me ekan. ");
INSERT INTO bqj_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Síbe sasu sáari me saamme futoh ni súuba, ti may gukoñ gagu gáari me gaamme futoh ni gúuba, dáru dóemme símit futoh ni súuba ; dó ᵽe síyeut sanur. ");
INSERT INTO bqj_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sasu síbe sagan me ban ni súhoji, ti may gukoñ gagu gahay me mbiban érus yay nellaben go, dáru dóemme sice símit futoh ni súuba, sausu saa bieb. ");
INSERT INTO bqj_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ti nilobi me, Aláemit nagiteni wo najae me ekan. ");
INSERT INTO bqj_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Símit sasu futoh ni súuba sájaeul me ᵽan síni símit sal eᵽit yaaro faŋ ni mof mamu ᵽe mal Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mbiban, sipaso sono may futoh ni súuba ᵽan síni saa bieb, ban mat’ubbañal uosenal fubaj fafu faa sítinara sasu. Bieb baubu ᵽan bunoñen ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Fubaj fafu fo ésuh yay ebajen me, mati waf ubbañ uŋaño ni fo, iki gújumor fo. Maagen mamu, bieb baubu ᵽan bújalo faŋ. ");
INSERT INTO bqj_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ujuh me min úyeut ñono ñáuba waf waw wanur waw, dóemme Aláemit mo najoge, ban mati ᵽio min baj. ");
INSERT INTO bqj_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nítalleni, ávi, mb’uŋes ñer an ajenguloe, min mof mamu mal Esíp ᵽe uhat mo n’guñen gola. ");
INSERT INTO bqj_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mb’uŋes may uyaba-búalen gajae me éᵽuren gakib ganur ni wono futoh gubet n’újej. Mbi gukan mo ni símit sasu futoh ni súuba so nujaale me ebaj eᵽit yaaro. ");
INSERT INTO bqj_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Mbi guomen mitiñ mamu ᵽe mo gujae me eᵽit ni símit sausu sítiar sájaeul me. Esúh-ésuh ᵽan gubet ró bíjej baa ble, dó ᵽe ni gajow gúiya, bi elalen mitiñay. ");
INSERT INTO bqj_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mamu bugal Esíp ᵽan gubaj wo gujae me fitiñ no símit sasu saa bieb sijae me eĉigul, jambi bieb babu binemen ésuh yay. » ");
INSERT INTO bqj_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","No Susef agiten me aban, firimol ni fúsum ávi ahu ni úvulaol. ");
INSERT INTO bqj_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Aví ahu naagil : « Maagen, biinum Aláemit ubu ni áine ahume. Ᵽan újual ubajal ᵽiaŋ ace ti o ? » ");
INSERT INTO bqj_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Naban naah Susef : « Nemme Aláemit aĉile nubaj gaffas gaugu gare me, bajut ace ajenguloe ban najah ti aw. ");
INSERT INTO bqj_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ñer aw ujae me eyab fuhow ésuh yay. Bugo ᵽe ᵽan gúttun firimi. Maageyma nureare, let me búoh ínje ávi nem. » ");
INSERT INTO bqj_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Natajen aagol : « Niseni maer sembe n’ésugom ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ñer ávi náoĉ ni gañenol eĉelaol yaa jávi aoᵽ ni fisih Susef. Naban nasenol wañ ujaha asimo, nakanol may banuh bal éurus n’ehondor. ");
INSERT INTO bqj_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mbiban, najingenol n’esaretol éuten yo ateynenol me aĉil me, min bugan bugagu nihi gúᵽib guoh : « Jutos min ágat ! » Mamu ávi ahu ala Esíp ateben me Susef, aban nakanol áni ni fuhow ésuh yay ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Aví nabbañ aagol : « Mánoman nínie ávi Esíp ᵽe, bare maer mati an agoror aw m’bamaŋut. » ");
INSERT INTO bqj_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Mbiban, nasenol gajow golil gaa Safunat-Ᵽaneah. Nasenol may anaare gajaol Asanat, ᵽayol Potifera, afan bacin ala On. Min Susef ñer aŋar fuhow ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Gannay gaugu, o babajer símit ávi ni guñen. Ñer nahato ávi ahu min ake bújaor dó n’ésuh yay ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ban ni símit sausu saa fubaj saamme futoh ni súuba, eᵽit yay néari nár. ");
INSERT INTO bqj_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ñer Susef náᵽuren ni mitiñay mamu fugab fice alalen. Esúh-ésuh, naŋar abet n’újej waw wo guᵽile me n’ulah waw wágolil me. ");
INSERT INTO bqj_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Naban nalalen ble yammemmeŋ ti fuus, mufaŋ nahat elih yay. ");
INSERT INTO bqj_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bala bieb babu búloul, aarol aamme Asanat nabugol úᵽur gúuba. ");
INSERT INTO bqj_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Afamma Susef navogol Manase (yoemme \"ekan an nájumor\"), aban naah : « Aláemit nakanomkan níjimor buyogom ᵽe ni may búhanorom ni fiilom. » ");
INSERT INTO bqj_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Apuma o navogol Efuraim (yoemme \"nabaje gátuh gámah\"), aban naah : « Aláemit nasenomsen uñil n’ésuh yay dó niyogen me nár. » ");
INSERT INTO bqj_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Símit sasu futoh ni súuba saa fubaj ni sígat, ");
INSERT INTO bqj_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","min saa bieb siĉigul, ti Susef alob yo me. Maagen, bieb babu m’búloul ni súsuh sasu ᵽe, úᵽuren me Esíp galalen me mitiñay. ");
INSERT INTO bqj_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","No bieb babu bunonulo me bugal Esíp, n’gúkail gúcin n’ávi ahu. Ñer naagil : « Jujow bi ni Susef min jikan wo najae me elobul. » ");
INSERT INTO bqj_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Maer bieb babu ubu tánotan Esíp. Ñer Susef n’ésuh-ésuh nápegul újej waw min anomenil ble yay, mata bieb babu bufafaŋ éloul. ");
INSERT INTO bqj_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Hani bugaa sasu súsuh n’gúteil bi funom ble n’aĉila ; maagen bieb babu ubu ni mof mamu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Babu Kanaan bo naamme, Sakob naun gaa búoh Esíp babaj bo ble. Naah guñolol : « Buru bu jinamo mee m’balet n’ekan wáfowaf ? ");
INSERT INTO bqj_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Niune búoh baubu Esíp ble uyu bo. Jiilo ᵽaa jujow bi bo iki júnomul, tima nuroŋal jamb’uĉelal. » ");
INSERT INTO bqj_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ñer guti Susef gono guñen n’guilo gujow mbal Esíp bi eke fúnomul ble yay. ");
INSERT INTO bqj_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bare Baisomen, aamme ati Susef apuma ni jail, Sakob náfirenol elagenil. Mata n’gaᵽinorol, jambi biᵽila bubajol m’bulago. ");
INSERT INTO bqj_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ñer úᵽur Sakob n’guĉih Esíp mimanur ni guce gajae ᵽoᵽ funom bo ble, mata ni mof mamu ᵽe maa Kanaan bieb babu ubu ró. ");
INSERT INTO bqj_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nemme Susef ni fuhow Esíp nam, o aĉile funomen fafu faa ble yay bugan bugagu ᵽe. Gutiol no guĉih bo me, n’gúñuᵽ bíᵽimborol bi to n’ettam. ");
INSERT INTO bqj_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","O no najugil me, nafaen affasil, bare nakan nan affatil min ain najogil ti ejaora. Narorenil táñi : « Bay júᵽullo ? » N’guogol : « Kanaan júᵽullo. Mitiñay jikelo babe funom. » ");
INSERT INTO bqj_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ñer Susef naffas búoh dáru gutiol, bare bugo gútalloutol. ");
INSERT INTO bqj_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ban naosen síyeutol so náyeut me ak’aya ni bugo, naagil : « Buru úreka ! Jujoulojow bi effas tay ésuh yauye élikut me. » ");
INSERT INTO bqj_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","N’guogol : « A-a, wóli umigeli, funom mitiñay bare fuŋalóli babe. ");
INSERT INTO bqj_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ban wóli ᵽe batiay, ᵽayóli anur. Wóli bugan bugaa maagen, jilet úreka. » ");
INSERT INTO bqj_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Naagil : « Jibibij ! Buru ékail gárebah bi effas tay ésugoli élikut me. » ");
INSERT INTO bqj_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","N’guogol : « A-a, wóli umigeli. Guñen ni gúuba jom ni ᵽayóli, an ala Kanaan. Atióli apuma bo jihatulol ni ᵽayóli, ban ace ni wóli nallilim. » ");
INSERT INTO bqj_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Naagil : « Yo niᵽi me nilobul, buru úreka jom. ");
INSERT INTO bqj_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ᵽan ujugal ter maagen julobe. Injé ibbatul fo ni gajow ávioli : Mati júᵽur n’ésuh yauye atiul apuma m’baĉilat. ");
INSERT INTO bqj_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Juboñ ace ni buru ak’aŋallol ; bugagu ᵽan ipegil. Mo ᵽan ijuh ter julolob maagen. Iní me jibibij, neegulseh : ti may nibbatul fo me ni gajow ávioli, buru ᵽoᵽ ᵽan jíni úreka. » ");
INSERT INTO bqj_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ñer nabaŋil ni fipeh iki gubaj ró gunah gúfaji. ");
INSERT INTO bqj_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Fúfaten fafu náᵽunnulil naagil : « Iní me ter jimaŋe juroŋ, ᵽan jikan ti nijae me elobul, mata ínje níkanume Aláemit. ");
INSERT INTO bqj_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Iní me buru bugan bugaa maagen, ace ni buru aŋaño ni fipeh fafu, min bugagu gújaenum mitiñay mbaa saŋul dó bieb babu buloulo me. ");
INSERT INTO bqj_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mbiban, ᵽan jiŋallom atiul apuma min ijuh búoh maagen julobe ; mamu mati jiĉet. » Gutiol n’gumaŋ firimol. ");
INSERT INTO bqj_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","N’gúᵽur jolil n’guogoro : « Wuj ! Gúteh gauge gololal mata wo nukanal me atiolal Susef. Nujugale min afotenor me nah’aagolal uboketal sinilolal surumol, bare tuᵽ nulalal éttunol. Biᵽilaolal to bujoumulo mee. » ");
INSERT INTO bqj_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben naagil : « Let niᵽiene neegul jambi jikan añil ahumu maarat ? Bare júttunutom. Maer wolal ubugu m’bacam físimol fo núyual me. » ");
INSERT INTO bqj_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nemme babaj an n’etulil náh’áᵽajulil gúlobum Esíp, guti Susef n’gujoh búoh wo gulobe me, aunut wo, kan aĉila naune ŋanno ca. ");
INSERT INTO bqj_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Min áhatulo ni bugo náni n’ukoŋ. Naban nábbañul naagil ban ajoh Simioŋ, naban naboñ guhogol bújoŋoril n’gújaenumol iki gupeh. ");
INSERT INTO bqj_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Mbiban naah urokaol : « Jikan ble yammemmeŋ ni uet ubuge. Mbi jiban, n’jibbañen ánoan síralamol ni baelol. Jisenil may wo gujae me fitiñ m’bulago. » N’gukan ti nalobil me. ");
INSERT INTO bqj_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ñer gutiol n’gújuᵽ ni musumil uelil waa ble min gukay. ");
INSERT INTO bqj_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mb’uĉiga gállim no guilen me, ace ni bugo nápegul baelol bi esen asumol mafos etiñ. Natoh síralamol sibaŋi ró m’butum baet babu. ");
INSERT INTO bqj_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Naah gutiol : « Gubbañenom síralamom, usu ró ni baelom. » Sinilil ni siteh n’gúholi nímoro. Anóan naah apalol : « Aláemit bu nakaneolal me ? » ");
INSERT INTO bqj_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","No gubbanno me bi ni ᵽail Sakob babu Kanaan, n’gugitenol wabaj me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","N’guogol : « Aíne ahu aamme ni fuhow Esíp nalobólilob táñi ak’ajogóli úreka. ");
INSERT INTO bqj_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Bare juogolseh wóli jilet úreka bare bugan bugaa maagen. ");
INSERT INTO bqj_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wóli juomme guñen ni gúuba ni ᵽayóli, bare ace ni gutióli nallilim, ban apuma ahu bo jihatulol ni ᵽayóli. ");
INSERT INTO bqj_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Aíne ahu naagóli ban affas ter wóli bugan bugaa maagen jom : naagóli ace ni wóli aŋaño bo, min wóli jíjaenumul ble yay bi ni saŋóli dó bieb babu buomme, ");
INSERT INTO bqj_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","mbiban n’jíjaenum atióli apuma bi bo. Mamu mb’affas me búoh wóli jilet úreka, bare bugan bugaa maagen. No ñer ᵽan abbañenulóli me Simioŋ, ban ᵽan ahalóli n’jujow ti súmoli me n’ésuh yay. » ");
INSERT INTO bqj_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ñer n’gúulen uelil, ban ánoan natoh ni bola jice jatiito dó gukan me síralamol. No gujuh so me, gáholi n’gunonil bugo ᵽe bi ni ᵽail ró. ");
INSERT INTO bqj_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Naagil : « Buru eramom uñil : Susef alet, Simioŋ alet, Baisomen mul ban jiŋaromol. Bíteb baube ᵽe bikelo bulo n’ínje. » ");
INSERT INTO bqj_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ñer Ruben naagol : « Iní me ter ibbañulati Baisomen, mb’umuh guñolom gaamme gúuba. Uhalol n’gañenom n’jujow, ban ᵽan ibbañuliol. » ");
INSERT INTO bqj_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Naagol : « A-a, Baisomen alet n’ejow ni buru. Atiol Susef naĉele, o bare níhagume ni jail. Injé maer nífanume, ban waf ubajol me babu m’bulago, gaᵽinor ᵽan gumugom mala bakanerul. » ");
INSERT INTO bqj_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Bieb babu buroŋ dó n’eĉimen ésuh yay yaa Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Bugaa yaŋ Sakob bugo batiñer ble yay yo guŋallo me Esíp. Ñer Sakob naah guñolol : « Jibbañ bi Esíp iki júnomul mitiñay mice ! » ");
INSERT INTO bqj_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda naagol : « Aíne ahu aamme ni fuhow Esíp naĉafóli ŋanno ca búoh mat’ayabóli atióli m’bajaorut ni wóli. ");
INSERT INTO bqj_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Umaŋ me, nuhat Baisomen najaor ni wóli. No ñer ᵽan jiki junomuli mitiñay mamu. ");
INSERT INTO bqj_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Bare ulat me, mati jujow. Maagen, áine ahu naagóliseh mat’ayabóli atióli m’balet. » ");
INSERT INTO bqj_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ñer Sakob, o guvoge me may Israel, naagil : « Wa uĉile n’juogol buru jibaje atiay ace ? Dáuru jikanutom jon. » ");
INSERT INTO bqj_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","N’guogol : « Waf wammeŋe narorenóli, újogum ni sinilóli bi ni yaŋóli. Naagóli : “Ᵽayul naroŋe ni buroŋ ? Jibaje atiay ace ?” Suroren sausu jíbalol mee, jiffasenut búoh ᵽan aagóli iki jiŋallol. » ");
INSERT INTO bqj_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda nabbañ atajen aagol : « Apa, nilai uhat Baisomen n’gañenom min jujow, tima wóli, guñolóli ni aw ᵽoᵽ nuroŋal jamb’uĉelal. ");
INSERT INTO bqj_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Maer ínje iĉilol. Ibbañenulatol me, nurorenom. Aotulat me bi n’aw, gatil gauge ᵽan gúni n’ínje iki buroŋom bubao. ");
INSERT INTO bqj_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Lelen me gaᵽio gagu go jiᵽio me tale, wóli bajaener ñono ñáuba bi Esíp n’jíbbañul. » ");
INSERT INTO bqj_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Sakob naagil : « Elob ece eleto ñer. Ñer maa jijae bi ekan : Jiŋar wañul n’jiŋar ᵽoᵽ waf bi éji áine ahumu ala Esíp, waf waw wáari me ᵽe waa dáre mofolal, ti físim ununuh fatiŋo me, míĉir, múhum, ni gurumen. ");
INSERT INTO bqj_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Jiŋar may síralam sice súbuli ni so jutoh me n’uelul, mata mbi júju jibbañen sítiar sasu ; ter gulillim n’gukan so ró. ");
INSERT INTO bqj_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ñer jiŋar atiul min jujow iki jujuh áine ahu. ");
INSERT INTO bqj_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Emít-Sembe emmeŋen éĉigirol gaboket min ajugul enilol n’erum, min áhanul Simioŋ bugo ni Baisomen gúolul manur ni buru. Injé ñer to nem ma, íni me ban íbbur gúñum ᵽe, níbburil. » ");
INSERT INTO bqj_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ñer batiay babu n’guomen wo gujae me éjaenum bi gáji, ni ᵽoᵽ gugab gagu gúuba gaa síralam sasu. Mbiban n’guŋar Baisomen min gubbañ mbal Esíp iki gutoh bo Susef. ");
INSERT INTO bqj_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","No Susef ajuh me búoh Baisomen umu ni bugo, naah afan urokaol : « Ujáenum ubuge bi yaŋom, ban numuh ehaj nucokor yo, mata jama ᵽan gutiñ gataw manur n’ínje. » ");
INSERT INTO bqj_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ñer áine ahu nájaenumil bi ni yaŋ yay, aban nakan ᵽe ti Susef alobol me. ");
INSERT INTO bqj_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","No guomme n’ejow yay mbaa yaŋ Susef, n’gúholi n’guoh : « Dáru síralam sasu so gubbañen me n’uelolal n’ejaolal étiar, so siĉil maa. Ᵽan gúloŋolal n’guram musumolal, mbiban n’gukanolal únial umigelil. » ");
INSERT INTO bqj_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","No gulof me gánonum yaŋ yay, n’guoh afan urokaaw : ");
INSERT INTO bqj_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","« Aíne ahu, uboketóli. Júmusene jíkail babe funom mitiñay. ");
INSERT INTO bqj_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ni búot babu, no jiilen me bi gámori, n’jípegul uelóli, ánoan ni wóli najuh síralamol ni butum baelol, ban níni may wo jicam me mitiñóli. Ñer so jibbañenulo maa jama. ");
INSERT INTO bqj_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ban jiŋalloŋar sice bi ebbañ junom mitiñay. Jiffasut ay abbañen so n’uelóli. » ");
INSERT INTO bqj_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Naagil : « Jibeben, jambi júholi. Aláemilul aamme anur ni ala ᵽayul, o auñ so ró n’uelul. Solul so niyabsoyab. » No nalob me aban, nahanulil Simioŋ. ");
INSERT INTO bqj_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nakanil ᵽe n’gunogen ni yaŋ Susef. Nasenil mal n’guᵽos guolil, naŋalil ᵽoᵽ mafos bi ni musumil. ");
INSERT INTO bqj_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","No guomme n’eirigen Susef min aĉigul tinah baraber, n’gúni n’ecokor wo guŋallo me bi éjiol, mata gugitenilgiten búoh to gujae fitiñ n’aĉila. ");
INSERT INTO bqj_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","No naĉilo me, n’guñurenol waf waw wo guŋallol me. Ban n’gúñuᵽ bi n’ettam bújoŋorol. ");
INSERT INTO bqj_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Narorenil bu gukane, aban naagil : « Ñer ᵽayul o julobom me mola, bu nakane ? Naroŋe ni buroŋ ? » ");
INSERT INTO bqj_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","N’guogol : « Ey, ᵽayóli, aamme may amigeli, umu bo apuñol. » N’gubbañ gúñuᵽ bi n’ettam. ");
INSERT INTO bqj_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ñer Susef najuh atiol Baisomen, o gugum me jaay. Naagil : « Umu ñer aamme atiul apuma o julobom me mola ? » Nábaho mbal aĉila naagol : « Añolom, mb’Aláemit ásonieni ! » ");
INSERT INTO bqj_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ni mujogol iki ájuut atajen alob. Gúĉilol n’gummeŋ mufu, náᵽur cab ajow mbaa futongol min akoŋ ró. ");
INSERT INTO bqj_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Aban naᵽos buulol min ábbañul. Najogoro min aah urokaol : « Jigabil sinaŋ sasu ! » ");
INSERT INTO bqj_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","N’gugab Susef butumol nevonol, ni gutiol bugo may nevonil. Bugal Esíp bugo guvogulo me, n’gugabil may jolil nevonil ; mata bugo mukanail mífirenilfiren fitiñ tiñ tanur ni bugan bugaa Híbori. ");
INSERT INTO bqj_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Guti Susef n’gunamo gúᵽimborol. N’gubaŋil ni fufaneil, jógum n’afamma bi n’apuma. N’gujahali nár iki ánoan naluj apalol. ");
INSERT INTO bqj_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Susef naboñ min gusenil básiler babu ᵽe baamme gayoŋol. Wo gugab me Baisomen ufaŋe ñono futoh waa gutiol. N’gurem mimanur ni Susef iki guᵽilo, ban ni súmil nár. ");
INSERT INTO bqj_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ᵽio maa, Susef naah afan urokaol : « Mb’ummeŋenom uet ubugu mitiñay, ánoan min áju me ateb. Nubbañenil ᵽoᵽ síralamil ánoan ni baelol. ");
INSERT INTO bqj_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nuŋar may éremumaom yaaᵽi me ni síralam úrur ni baet apuma ahu. » Nakan ti Susef alobol me. ");
INSERT INTO bqj_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tihalen fo, no tinah titebulo me, n’guhalil n’guŋar musumil min gukay. ");
INSERT INTO bqj_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","6","No gujow me ᵽiout, Susef naah afan urokaol ateynenil. Nagitenol ᵽoᵽ wo najae me elobil. No afan urokaaw atobenil me, nalobil ti Susef ahoŋenol me naagil : « Wa uĉile n’jitit maarat ni maaro ? Bu kane n’júkutul éremuma afanom dó nah’arem me, ban ni yo nah’affas wajae me ebaj gajem ? Jikanut jon, hani jatito. » ");
INSERT INTO bqj_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","N’guogol : « Aíne ahu, bu nújue ulobóli elob ti yauyu ? Mati jikañen jikan waf ti wauwu ! ");
INSERT INTO bqj_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Let wóli jibbañenulo mee síralam sasu so jutoh me n’uelóli, ñer bu jújue jíkail júkuet síralam ter éurus ni yaŋ afani ? ");
INSERT INTO bqj_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Utoh me éremuma yay ni wañ ace ni wóli, an ahumu mbi gumugol, ban wóli ᵽan jíni umigeli. » ");
INSERT INTO bqj_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Naagil : « Yoo, ukanal mo. Ñer ni baet an dó nujaale yo me ejuh, o mb’áni me amigelom ; bugagu nihalenil. » ");
INSERT INTO bqj_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ñer ánoan ni bugo naalenul baelol ni majase ápegul. ");
INSERT INTO bqj_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mbiban, afan urokaaw náni n’élingen uet waw ᵽe, újogum ni bal afamma ák’ábanum ni bal apuma aamme Baisomen, dó natoh me éremuma yay. ");
INSERT INTO bqj_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ñer ni mujogil iki guĉaĉ wañil, mbi guban n’gújuᵽ uelil ni musumil min gubbañ gunogen dó n’ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","No Yuda bugo ni gutiol guĉih me ni yaŋ Susef, o baroŋer dó. N’gúñuᵽ bi n’ettam bújoŋorol. ");
INSERT INTO bqj_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Susef naagil : « Bakaner bu jikan mee ? Jiffasut búoh ínje an o biinumol bújaloe ? » ");
INSERT INTO bqj_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda naagol : « Afan ésuh yay, bu jújue jigiten iki jibaj bakoŋ ? Aláemit áᵽunnoli asen ésuh. Maer ᵽan jíni umigeli, manur n’atióli o éremuma yay eemen me ni baelol. » ");
INSERT INTO bqj_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Naagil : « Hani ! Mat’ikan mo hóji mee ! Ala baet babu dó éremuma yay etogi me, o bare ajae éni amigelom. Buru jike búot bi yaŋ ᵽayul ni gásumay ! » ");
INSERT INTO bqj_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ñer Yuda nátosul alof Susef naagol : « Afan ésuh yay, maagen numamaŋ ere n’ávi ahu. Yo eĉil me nilai jambi fiiñi fitiñom. Uboket újiom min ilobi firim fe. ");
INSERT INTO bqj_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Funah fítinar nurorenóli ter ᵽayóli naroŋe ni buroŋ, ter jibaje atiay ace. ");
INSERT INTO bqj_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","N’juogi ᵽayóli umu bo náfanume ni atióli apuma o nabaj me ni fúfanumol, ban namaŋol mámah, mata o bare naŋañene ni aarol o nafaŋ me namaŋe ; ahuol nalelet. ");
INSERT INTO bqj_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Aw uogóli me mbi jiŋaliol min mb’ujugol táh. ");
INSERT INTO bqj_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ñer wóli n’juogi añil ahumu ájuut áhatulo ᵽayol ; let mo, ᵽayol ᵽan aĉet. ");
INSERT INTO bqj_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Bare nuogóli íni me jijoulat ni o ró, mat’uyabóli. ");
INSERT INTO bqj_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yo eĉil me, no jibbañ me bi ni ᵽayóli aamme amigeli, n’jigitenol gurim gagu gúiya. ");
INSERT INTO bqj_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","No mitiñóli mubao me, ᵽayóli naagóli jibbañ iki júnomul mitiñay. ");
INSERT INTO bqj_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","N’jíbahulol búoh jújuut jujow apuma m’balet ; ájoul me, ᵽan jijaor, mb’ajoulat n’jurobo, mata jiffase búoh aamme ni fuhow ésuh yay mat’ayabóli. ");
INSERT INTO bqj_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ᵽayóli naagóli : “Jiffase búoh aarom Raĉel uñil gúuba bare nasenom. ");
INSERT INTO bqj_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ban ahu nallilim, niᵽinore búoh énuhureŋ baha ejogol. To niemme, bi jama ibbañut iyaol jíĉil. ");
INSERT INTO bqj_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","N’jimaŋ jiŋarom ahume, ban ínje nífanume. Iní mataño mubajol m’bulago, ᵽan iĉet n’gaᵽinor mala bakanerul.” » ");
INSERT INTO bqj_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Yuda nabbañ aagol : « Nujuge búoh maer mat’íju iot bi ni ᵽayom añil ahu m’balet. Ᵽayóli biinumol n’añil ahumu nabaŋ bo, ");
INSERT INTO bqj_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ban ajugutol me ábbañul, ᵽan aĉet. Ᵽan jumugol ni gaᵽinor mata jiŋallatol. ");
INSERT INTO bqj_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ban ínje eege ᵽayóli ahalol n’guñenom. Neegolseh ᵽan ibbañulol ik’isenol ; let mo, gatil ge ᵽan gunamo n’ínje iki buroŋom bubao. ");
INSERT INTO bqj_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ñer nilai gaboket, uhalom tale min ikan amigeli butum añil ahume, min aĉila aot manur ni gutiol. ");
INSERT INTO bqj_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Bu ᵽan íju ibbañ bi ni ᵽayom añil ahume m’balet ? Mat’íju inamo me min iluj ᵽayom ni buyoh baubu bo nikanol mee. » ");
INSERT INTO bqj_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Bújoŋor urokaol, Susef abbañut áju ekoᵽen waamme m’biinumol. Yo eĉil me naah urokaaw : « Buru ᵽe, júᵽur dáre ! » No guŋaño ró me o ni gutiol bare, nagitenil o aamme ay. ");
INSERT INTO bqj_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Bare nakoŋ nímoro iki bugaa tíyaŋ guun. Elob yay neuno bi n’ávi ahu. ");
INSERT INTO bqj_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ñer Susef naah gutiol : « Injé om Susef. Juoge ᵽayom umu to ni buroŋ ? » Bare gutiol n’guŋaben gah iki gújuut gúbalol. ");
INSERT INTO bqj_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Naagil : « Jútosul bi tale n’ínje ! » N’gutos iki gutogol to. Nabbañ aagil : « Neegul ínje om Susef, atiul, o junomen me min gújaenumom mbal Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Jambi júrut, jambi ᵽoᵽ jiñahor min junomenom me n’ésuh yauye. Dáuru ᵽe Aláemit aboñulom mee íkiil ilef babe bi eᵽagen súñunduul. » ");
INSERT INTO bqj_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nabbañ aagil : « Babe Esíp, símit súuba use bugan ubugu ni bieb. Ban tale símit futoh sájaeul me, an mat’aañ, an mat’aᵽit. ");
INSERT INTO bqj_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yo eĉil me, Aláemit naboñulom iyabulul gayoŋ bi n’ésuh yauye. Mata eᵽagenul namaŋe min ᵽoᵽ jibaj gátuh gámah n’ésuh yauye. Maagen, gaᵽagen gauge let gaᵽagen gapuñ. ");
INSERT INTO bqj_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Neegulseh let buru juboñulom babe, bare Aláemit ájaenumulom. Aĉila akanom me min íni afan mof mamu afaŋ me nabaje gailo n’ávi ahu. Injé iĉil me eogen gávi gagu. ");
INSERT INTO bqj_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Maer ñer jitey cab iki jigiten ᵽayom gurim gauge ; jiĉih n’juogol Susef naage : Aláemit nasenolsen bíteb bal eogen fuhow Esíp ᵽe. Ñer mb’ájoul cab ak’atogol babe. ");
INSERT INTO bqj_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Namaŋe mb’ákail aĉin alofol ni mof mamu maa Goĉen, aĉila ni guñolol ni gabulakenol ni sihajol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ᵽan isenol wo najae me fitiñ, aĉila ni bugaa yaŋol ni sihajol ᵽe, jambi gucaret ; mata bieb babu ᵽan buroŋ n’ésuh yay símit futoh. » ");
INSERT INTO bqj_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nabbañ aagil : « Jujuge hum búoh buru ni atiom apuma Baisomen, maagen ínje Susef ilobe maa ni buru. ");
INSERT INTO bqj_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Jujow iki jigiten ᵽayom gailo gagu go nibaj me babe, ni wo jujuh me ᵽe. Mbiban n’jiŋalomol cab ! » ");
INSERT INTO bqj_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","No naban me, nálloŋ atiol Baisomen, ban bugo éubail n’gúlloŋor n’ukoŋ ró. ");
INSERT INTO bqj_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nálloŋ may gutiol bugagu ᵽe n’ukoŋol ró. Mbiban, gutiol n’gunamo n’gúni n’elob ni o. ");
INSERT INTO bqj_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ejóul yay yaa guti Susef neuno bi ró ni gávi gagu. Aví ahu ni úvulaol ni súmil nár. ");
INSERT INTO bqj_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Aví naah Susef : « Mb’uoh gutii gújuᵽ wañil ni musumil min gujow mbal ésuh yay yaa Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mbi gujow iki gúŋarul ᵽayul ni buganul gaŋaño bo me. Ᵽan ibaŋil ni mof mamu mafaŋ me gáari babe Esíp, ban ᵽan nihi gutiñ mitiñ mamu mafaŋ me músum n’ésuh yauye. ");
INSERT INTO bqj_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Mb’uogil may mbi guŋar tale sisaret bi éjuᵽul waaril, guñolil ni ᵽayul. ");
INSERT INTO bqj_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Jambi gujoh émiremma fubajil fo guhatulo bo me, mata ᵽan gubaj waf waw wafaŋ me gáari babe Esíp. » ");
INSERT INTO bqj_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Guñol Sakob n’gukan ti gulobil me. Susef nasenil sisaret sasu ti ávi ahu alobol yo me. Nasenil ᵽoᵽ wo gujae me fitiñ m’bulago. ");
INSERT INTO bqj_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Naban nasen ánoan ni bugo bisimo buvugul, bare Baisomen nasenol wono futoh, nabbañ atajenol sifaraku butum sikeme sífaji (300). ");
INSERT INTO bqj_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Naboñ bi esen ᵽayol musum mono guñen matebe waf waw wafaŋ me gáari Esíp ᵽe, ni ᵽoᵽ musum maare mono guñen matebe ble, unaĉ ni mice mitiñ, dáru ᵽe bi fitiñ ᵽayol m’bulago. ");
INSERT INTO bqj_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","No guomme n’ekay, Susef naagil : « Jambi jírig m’bulago ! » ");
INSERT INTO bqj_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ñer n’gúᵽur Esíp bi Kanaan iki gutoh bo ᵽail Sakob. ");
INSERT INTO bqj_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","No guĉih bo me, n’guogol : « Susef naroŋe m’buroŋ ! Ban aĉila aogene fuhow Esíp ᵽe ! » Bare Sakob nanamo to ájebi mata áinenutil. ");
INSERT INTO bqj_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","N’gunamo n’gugitenol ᵽe wo Susef alobil me. No Sakob ajuh me sisaret sasu so n’éjoul so Susef aboñulo me bi éjaenumol, no sarol me nailo ");
INSERT INTO bqj_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","naah : « Dáuru totoh bi éinen ! Añolom Susef naroŋe m’buroŋ, ᵽan ijow ik’ijugulol bala iĉet ! » ");
INSERT INTO bqj_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ñer Sakob nailo naŋar wafol ᵽe wo nabaj me min ajow mbal Esíp. No naĉih me Beer-Ĉeba, nailen to min ásimen Aláemit, aamme Aláemit olala ᵽayol Isak. ");
INSERT INTO bqj_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","N’efuga yay, Aláemit nálobul ni o o n’gámori. Navogol bi ñúuba : « Sakob ! Sakob ! » Naagol : « Injé ume. » ");
INSERT INTO bqj_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Naagol : « Injé iomme Aláemit, Aláemit ahu o ᵽai áinen me ni o. Neege jamb’úholi me ejow bi Esíp, mata baubu Esíp ᵽan ikan gabugori n’gubaj gátuh gahulo, iki guᵽilo ésuh. ");
INSERT INTO bqj_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Injé umu n’elageni mbal Esíp, ban ᵽan ikani may núbbañul. No nujae me eĉet, ᵽan Susef akani númoen. » ");
INSERT INTO bqj_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Mbiban, Sakob náᵽur Beer-Ĉeba, min guñolol gújuᵽol, aĉila ni waaril ni guñolil, ni sisaret sasu so ávi ahu aboñ me bi éjaenumil mbal Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","N’gújaenum ᵽoᵽ sihajil ni fubajil ᵽe faa Kanaan. Mamu Sakob ni gabugorol gúuy me bi Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nájaenum bo buganol ᵽe : guñolol ni gabulakenol, wáinema ni waarema. ");
INSERT INTO bqj_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dáure ujow bugal Israel gakelo me guĉin Esíp, dóemme Sakob ni guñolol ni gabulakenol. Guñolol bugo guomme ubuge : Ruben, Simioŋ, Lévi, Yuda, Isahar, Sabuloŋ, Gad, Aser, Baisomen, Dan ni Nafutali. Guñolol bugo Lea abuh me, ubuge : Ruben, Simioŋ, Lévi, Yuda, Isahar ni Sabuloŋ. Afamma Sakob gajaol Ruben, ");
INSERT INTO bqj_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","guñolol bugo guomme Hanok, Ᵽalu, Hesoron ni Karumi. ");
INSERT INTO bqj_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Aúten gajaol Simioŋ, guñolol bugo guomme Yemuel, Yamin, Ohad, Yakin, Sohar ni Ĉaul. Ĉaul o jaol áᵽullo me Kanaan. ");
INSERT INTO bqj_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Afáten gajaol Lévi, guñolol bugo guomme Geriĉoŋ, Kehat ni Merari. ");
INSERT INTO bqj_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Abarigen gajaol Yuda, guñolol bugo guomme Er, Onan, Ĉela, Ᵽeres ni Sera. Bare Er ni Onan Kanaan guĉetulo. Ᵽeres aĉila nabaj uñil gúuba, gaamme Hesoron ni Hamul. ");
INSERT INTO bqj_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Atogen gajaol Isahar, guñolol bugo guomme Tola, Puva, Yaĉub ni Ĉimoron. ");
INSERT INTO bqj_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Akan me futoh ni anur, gajaol Sabuloŋ, guñolol bugo guomme Sered, Elon ni Yahalel. ");
INSERT INTO bqj_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dáru ᵽe guñol Lea, gabugi me n’ésuh yay yo guvoge me Padan-Aram. Nabaj ᵽoᵽ bájur gajaol Dina. Uᵽin me guñolol ni gabugoril, ᵽan gúni ávi ni guñen ni gúfaji (33). ");
INSERT INTO bqj_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Guñolol bugo Siliᵽa abuh me, bugo guomme Gad ni Aser. Afamma gajaol Gad, guñolol bugo guomme Sifion, Hagi, Ĉuni, Esobon, Eri, Arodi ni Areli. ");
INSERT INTO bqj_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aúten gajaol Aser, guñolol bugo guomme Yimina, Yiĉiva, Yiĉivi, Beria ni álinil Sera. Beria aĉila nabaj uñil gúuba, gaamme Heber ni Malikiel. ");
INSERT INTO bqj_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dáru ᵽe guñol Sakob ni Siliᵽa ni gabulakenil, guomme gaat ni an anur (16). Siliᵽa o Laban aŋalo me asen bájurol Lea min akan amigelol. ");
INSERT INTO bqj_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Guñol Sakob bugo Raĉel abuh me, ubuge : Susef ni Baisomen. ");
INSERT INTO bqj_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Afamma ahu Susef nabuh bo Esíp uñil gúuba ni aarol Asanat o Potifera abuh me, ban náni afan bacin bal On. Guñolol bugo guomme Manase ni Efuraim. ");
INSERT INTO bqj_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Aúten ahu Baisomen, o nabaj uñil gono guñen, gaamme Bela, Beker, Aĉebel, Gera, Naaman, Ehi, Roĉ, Mupim, Hupim ni Ared. ");
INSERT INTO bqj_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dáru ᵽe guñol Sakob ni Raĉel ni gabulakenil, guomme guñen ni gubbagir. ");
INSERT INTO bqj_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Guñol Sakob bugo Biliha abuh me, bugo guomme Dan ni Nafutali. Afamma ahu Dan nabaj añil anur, gajaol Huĉim. ");
INSERT INTO bqj_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Aúten ahu Nafutali, guñolol bugo guomme Yahasiel, Guni, Yeser ni Ĉilem. ");
INSERT INTO bqj_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dáru ᵽe guñol Sakob ni Biliha ni gabulakenil, gaamme futoh ni gúuba. Biliha o Laban aŋallo me asen bájurol Raĉel min akan amigelol. ");
INSERT INTO bqj_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ñer gabugor Sakob gáᵽullo me bi Esíp, bugo guomme úvi gúfaji ni futoh ni an anur (66), waaril m’baᵽinuti. ");
INSERT INTO bqj_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Utajen me Susef ni guñolol gabugi me Esíp, gabugor Sakob ᵽe gajoulo me iki guĉin Esíp, n’gúni úvi gúfaji ni guñen (70). ");
INSERT INTO bqj_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","No gunogen me Esíp, Sakob naboñ Yuda amundum ágat bi ni Susef min mb’agitenol mof mamu maa Goĉen, bo gujae me eĉin. No Sakob ni buganol guĉih me Goĉen, ");
INSERT INTO bqj_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Susef naŋar esaretol najow iki guemor bo. No najuh me ᵽayol, náñag álloŋol n’ehondor min akoŋ ᵽio. ");
INSERT INTO bqj_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ñer Sakob naagol : « Aw umu m’buroŋ ! Maer níjue iĉet, mata nijugi táh ! » ");
INSERT INTO bqj_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Susef nábaho mbaa gutiol ni buganil naagil : « Ᵽan ijow ik’igiten ávi ahu iegol ᵽayom ni buganol gaamen me Kanaan guĉilo gutogom babe. ");
INSERT INTO bqj_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Niban nífaro iegol buru ukoña jom, mata dó duomme burokul. Jujoulojow n’ubbarumul, sijamenul, síbeil ni fubajul ró ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Eno ávi ahu navogulul bi erorenul waamme burokul, ");
INSERT INTO bqj_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ᵽan jíbalol juogol buru burokul baᵽi to me ni sipayul gufan, bo buomme gakoñ. Min mbi júju jiĉin ni mof mamu maa Goĉen, mata bugal Esíp ndi gumaŋ eĉindor n’ukoña. » ");
INSERT INTO bqj_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ñer Susef najow ak’agiten ávi ahu naagol : « Ᵽayom ni gutiom gáuilo me Kanaan mbaa babe n’ubbarumil, sijamenil, síbeil ni fubajil ró ᵽe, guĉilo. To guomme ubugi ni mof maa Goĉen. » ");
INSERT INTO bqj_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Mbiban, Susef naŋar gutiol gono futoh ak’agiten ávi ahu. ");
INSERT INTO bqj_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","O narorenil : « Wa uomme burokul ? » N’guogol : « Avíoli, wóli ukoña ubbarum ni sijamen, ti sipayóli gufan guᵽi me n’ekan mo. ");
INSERT INTO bqj_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ban baubu Kanaan, bieb babu bújalojalo mámah iki sihajóli sibajut wo sijae me efen. Yo eĉil me n’jíkail jiĉin babe. Uboket uhalóli min jiĉin ni mof mamu maa Goĉen. » ");
INSERT INTO bqj_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ñer ávi ahu naah Susef : « Ᵽai ni gutii gukelo gutogi babe. ");
INSERT INTO bqj_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mof mamu múmbam ᵽe ni guñeni nihat mo. Ubaŋil n’ésuh yay yafaŋ me jáari. Uhalil niki guĉin bo Goĉen ti gulob me. Iní ter baje guce ni bugo gájurore, nusenil sukoreom guogenom. » ");
INSERT INTO bqj_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Mbiban, Susef náŋarul ᵽayol Sakob ak’agiten ávi ahu. Sakob nasafol násonienol nímoro. ");
INSERT INTO bqj_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Aví ahu narorenol : « Símit butumbu nubaje ? » ");
INSERT INTO bqj_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Naagol : « Baje símit ekeme ni ávi ni guñen (130) ínje umu ni búuy ésuh bi n’ésuh ti ajaora, ban nijuh ró sílam. Símit sausu sititititi, ban buroŋom buhuliut ti baa sipayom gufan gaamme may úuya ti ínje. » ");
INSERT INTO bqj_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nabbañ ásonien ávi ahu min áᵽurul akay. ");
INSERT INTO bqj_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ñer Susef nabaŋ ᵽayol ni gutiol ni mof mamu mafaŋ me Esíp ᵽe jáari, galam ésuh yay yo guvoge me Ramises, ti ávi ahu alob yo me. Dó nasenil me ánoan ettamol. ");
INSERT INTO bqj_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nasenil may fitiñil, ᵽayol ni gutiol ni guñolil, ánoan min yaŋol ere me. ");
INSERT INTO bqj_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bieb babu bújalojalo mámah, hani waf waa fitiñ ubajut tánotan. Dó Esíp ni Kanaan, bugan bugagu sinilil sitetey mata bieb baubu. ");
INSERT INTO bqj_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","N’gúkail ᵽe bi ni Susef funom ble. Ñer naomen síralam sasu ᵽe saa bugal Esíp ni Kanaan, ak’abaŋ ni gávi gagu. ");
INSERT INTO bqj_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","No síralamil sike me sibao, bugal Esíp n’gújoul iki guoh Susef : « Usenóli jitiñ. Wóli ᵽiaŋ ᵽan jiĉet ni bieb bújoŋori mala gabajutóli síralam ? » ");
INSERT INTO bqj_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Naagil : « Nemme síralamul sibaobao, jiŋallom ñer sihajul min itilul so ni mitiñay. » ");
INSERT INTO bqj_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Min gúŋarul sukoreil iki gusenol, siᵽiliŋ-bufal, ubbarum, sijamen, síbe ni musum, min asenil wo gujae me fitiñ. Gannay gaugu, n’gutit sihajil ᵽe min gúju gutiñ. ");
INSERT INTO bqj_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","No nuĉiga me yay émit, n’gúbbañul iki guogol : « Mati jukoeni maagenóli : síralamoli sibae, sihajóli usu n’guñeni. Maer sinilóli bare jiŋañene, so ni ettamóli. ");
INSERT INTO bqj_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ᵽan ᵽiaŋ ulujóli me min jiĉet ni bieb, min ettamóli ejun ? Uŋaróli n’ettamóli ró min jikan umigel ávi ahu, min usenóli jitiñ. Usenóli eugit, mamu mati jiĉet, ᵽan juroŋ, ban ettamóli mat’enay bo. » ");
INSERT INTO bqj_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ñer Susef nanom ettam Esíp ᵽe bi n’ávi ahu. Nemme bieb babu bújalojalo mámah, ánoan nanomenol ettamol. Mamu ettam yay ᵽe yal Esíp ejoulo me iki enamo n’guñen ávi ahu. ");
INSERT INTO bqj_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mamu Susef naŋar ésuh yay ᵽe akan umigel, újogum ni fíĉilum Esíp bi to étij me. ");
INSERT INTO bqj_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Bare anomut ettam uvasenaaw, mata bugo ávi ahu nah’asenilsen waf bi fitiñil ; yo eĉil me gunomenut ettamil. ");
INSERT INTO bqj_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Mbiban, Susef naah bugal Esíp : « Nemme maer ninomulnom bi n’ávi ahu n’ettamul ró, ᵽan isenul eugit min jiañ ettam yay. ");
INSERT INTO bqj_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mbi gúvagen guĉigul, ᵽan júᵽuren gakib ganur ni wono futoh jisen ávi ahu, min wawu ubbagir úni wolul. Ᵽan jiŋar dó eugit, n’jiŋar dó ᵽoᵽ bi fitiñul, buru ni guñolul ni bugaa saŋul ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","N’guogol : « Nuᵽagenóli buroŋ. Jilai mb’ukanóli maaro bi nánonan. Maagen, wóli umigel bugal ávi ahu. » ");
INSERT INTO bqj_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Susef mamu naju me Esíp mukanay mamu maam to me bi funah faa jama, maamme mbi ánoan asen ávi ahu gakib ganur ni wono futoh, ulah uvasenaaw m’bálero. ");
INSERT INTO bqj_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ñer bugal Israel niki guĉin dó Esíp ni mof mamu maa Goĉen, niki gubaj ró ettam, ban ni gubugor dó meŋ. ");
INSERT INTO bqj_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sakob naĉin dó símit gaat ni súuba, mo kan me nabaj símit ekeme ni úvi gúuba ni futoh ni súuba (147) bala aĉet. ");
INSERT INTO bqj_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","No naamme n’ejow bi eĉet, navoh añolol Susef naagol : « Iní me numaŋommaŋ ti maagen, ugitenom gamaŋi ni gábbolii min jamb’ufogom babe Esíp ínje baĉeler. Ugor fatamom min ubbat bi egiten maagen nujojoh liŋ. ");
INSERT INTO bqj_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Funah fo nijae me ealo itoh bo sipayom n’ufuga, mb’újaenum efuluŋom éᵽur Esíp. Mb’ufoh yo to sipayom gufan gufogi me. » Naagol : « Ᵽan ikan wo nulobom me. » ");
INSERT INTO bqj_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Naagol : « Ubbat firimi ! » Min Susef abbat fo. Ñer Sakob násilen to ni galam fuhow buraol. ");
INSERT INTO bqj_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ᵽúrto, n’guboñ guoh Susef ᵽayol násomusomut. Ñer naŋar úᵽurol gúuba, Manase bugo ni Efuraim, min akay bujugol. ");
INSERT INTO bqj_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Israel (dóemme gajow Sakob go Aláemit akanol me) no guogol me áᵽurol umu n’éjoul bi bujugol, naakulenor min ailo anamo ni buraol. ");
INSERT INTO bqj_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","No Susef aĉilo me, naagol : « Aláemit-Sembe náᵽullomᵽur baubu Lús ni mof mamu maa Kanaan. Násonienom, ");
INSERT INTO bqj_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","aban naagom : “Ᵽan iseni gabugor gámah, min mb’úni ᵽay afan ala guil gajae ebugor iki gummeŋen súsuh. Gabulaken guñoli, ᵽan isenil mof maume maa Kanaan, min guogen mo bi nánonan.” » ");
INSERT INTO bqj_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nabbañ aagol : « Guñoli gúuba Efuraim ni Manase bugo nubaj me babe Esíp bala itoguli bo, ᵽan ijogil ti búgumbam. Ñer ᵽan gúni búgumbam ti Ruben ni Simioŋ. ");
INSERT INTO bqj_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bare guñoli bugo nujae me ebaj búsolil, bugo gujae me éni búguiya ; ᵽan guyab bijisil ni mof gutiil gufan. ");
INSERT INTO bqj_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","No níoleul me baubu Padan-Aram, bala iĉigul Efarata ni mof mamu maa Kanaan, jai Raĉel naĉelom ni guñen wóli n’éjoul. Nifogulol bo galam bulago babu bal Efarata, yaamme Betuleem. Mola ᵽan ijoh me guñoli ubugu ti búgumbam. » ");
INSERT INTO bqj_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Nemme Sakob náfanumfanum nár, bujugol butogut. No najuh me guñol Susef, narorenol aah : « Uñiaw bugomme ? » Naagol : « Ey, dáru guñolom bugo Aláemit asenom me babe Esíp. » Sakob naagol : « Uŋalomil min ísonienil. » Ñer Susef nálofenul guñolol bi to naamme. Min Sakob álloŋil nacolil n’urab. ");
INSERT INTO bqj_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Naban naah Susef : « Iínenenut ᵽan ibbañ ijuh buuli, katin Aláemit naroŋe bi esenom guñoli ijuh. » ");
INSERT INTO bqj_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ñer Susef náannul guñolol n’guboŋ ᵽayol min aĉila áñuᵽ bi to n’ettam. ");
INSERT INTO bqj_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Mbiban Susef najoh guñolol ni guñen, Efuraim n’gañen gárib, Manase n’gañen gamay. Mo kan me, Efuraim nabbañ n’gañen Sakob gamay, min Manase áni n’gáribol. Min ñer alofenil o. ");
INSERT INTO bqj_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bare Sakob nalajor guñenol min gáribol gurembor ni fuhow Efuraim aamme apuma, gamayol n’gúni ni fuhow Manase til aamme afamma. ");
INSERT INTO bqj_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nasen Susef gásumay naagol : « Aláemit apoy me ᵽayom afan Aburaham ni ᵽayom Isak ni buroŋil, mb’asen guñoli gásumay ! Aláemit apoy me ínje ni mútut ni buroŋom, mb’asenil gásumay ! ");
INSERT INTO bqj_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Amalaka ahu áᵽunnom me ni maarat mánoman, mb’asenil gásumay ! Mbi Efuraim ni Manase gukan jambi ifuluŋo, ti may sipayom Aburaham ni Isak ! Mbi gubaj gátuh gahulo ! » ");
INSERT INTO bqj_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Susef no najuh me búoh ᵽayol gañenol gárib naŋare aremben ni fuhow Efuraim aamme til apuma, súmutol iki amaŋ éᵽuren go bi eremben ni fuhow Manase, ");
INSERT INTO bqj_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","min aagol : « Apa, nulillim ! Manase aamme afamma, ni fuhow aĉila nuote uremben gañeni gárib. » ");
INSERT INTO bqj_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bare ᵽayol nalat naagol : « Añúm, niffase bae. Gabugor Manase ᵽan gújalo may iki guᵽilo ésuh. Bare gal atiol apuma ᵽan gufaŋ go iki guilen súsuh sammemmeŋ. » ");
INSERT INTO bqj_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Funah faufu, Israel násonien guñol Susef naagil : « Ni ujow waw wolul bugal Israel gujae me maer ésonien bugan min guoh : “Mb’Aláemit akani maaro ti nakan me Efuraim bugo ni Manase !” » Mamu nakan me Efuraim ayab gayoŋ Manase. ");
INSERT INTO bqj_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mbiban naah Susef : « Eĉet niñum, bare Aláemit ᵽan ajow búsolul min abbañulul bi n’ésuh sipayul gufan. ");
INSERT INTO bqj_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ᵽan iseni bo bijis bufaŋ baa gutii, baamme ésuh yay yaa Siĉem. Yo niyab me ni guñen bugal Amor, bugo niham me ni gafojeom ni fuŋajenom. » ");
INSERT INTO bqj_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Mbiban, Sakob, o guvoge me may Israel, návogul guñolol naagil : « Júomunorul min ilobul wajaeul me ebaj. ");
INSERT INTO bqj_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Buru gabugor Sakob, jújoul juuttenom ! Injé ᵽayul Israel eegeul me júttunom ! ");
INSERT INTO bqj_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Aw Ruben, aw uomme añolom afamma, físimom fítiar no niroŋ me ni sembeom. Gailoi ni sembei sifafaŋ saa gutii. ");
INSERT INTO bqj_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Aw núnini ti mal maa fíĉiĉilen matee ni sembe. Bare mat’ubbañ úni átiar, mata núkerulomkerul no nufilen me abel jai ni buraom. ");
INSERT INTO bqj_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simioŋ ni Lévi, buru batiay jom, ban n’jijamor bi ekan gáaĉ. ");
INSERT INTO bqj_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Biinumom bulout ni maarat mamu mo jiᵽinore me ekan, imaŋut íni ró m’bíemorul bamoĉ me. Mata ni bitiña-fiiñul n’jumuh bugan, n’jiteŋ síbe mala min súmul. ");
INSERT INTO bqj_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bitiña-fiiñul bájalo me m’búhoji nímoro, bo biĉil me Aláemit ᵽan atabul min gabugorul guvisor tánotan n’ésuh yay yal Israel ; ᵽan avis go gúni n’ulam waw ᵽe. ");
INSERT INTO bqj_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, aw gutii ᵽan nihi gusali iki guyai gújul. Ᵽan uhek ulatorai. ");
INSERT INTO bqj_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Añúm Yuda, aw núnini ti éŋaŋ yaake yáhabulo ellu ni jasaw yo, mbiban n’éolul bi n’gasun yo. Ti éŋaŋ neh’eĉoŋ me, ñace nefilo, ay akañene ailen yo ? ");
INSERT INTO bqj_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Fálandiŋ ávi ᵽan funamo ni fiil fafu fíya bi nánonan, faet ávi ᵽan furobo ni guñen gabugori. Ᵽan fíni to n’guñenil bi no aĉil fo me faŋ ajae me éuul ; aĉila umu súsuh sasu sijae me ékanum. ");
INSERT INTO bqj_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ettamol ᵽan eĉej ek’ebaj bíñu yammeŋe iki nah’ahoh asumol ni bíbiñu babu bafaŋ me jáari, iki nah’abol dó bisimool, nah’afolen dó ᵽoᵽ gájuool. ");
INSERT INTO bqj_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Gúĉilol ᵽan gújuh káw ti gal an areme bíñu nár ; gúŋiŋol n’gútuen par ti gal an areme míi mammeŋe. ");
INSERT INTO bqj_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabuloŋ, aw ᵽan uĉin n’galam fal, bo baje gásih to sisahar sasu nihi siya. Ban mofi ᵽan mujow iki múffus ni mof mamu maa Sidoŋ. ");
INSERT INTO bqj_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isahar, aw núnini ti asum yailoe liŋ, yaam n’gáelo n’etut busoen yo ; ");
INSERT INTO bqj_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ejuge búoh tiñ talu to eemme n’gáelo tíariari, ban ésuh yay kakan ésuh yajaha. Ᵽan eya gújul min guremben yo bíteb báliilii ; mat’elat burok bátañie. ");
INSERT INTO bqj_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, aw ᵽan nuh’utaliŋ ésugi. ");
INSERT INTO bqj_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Bare ᵽan úni ti enuhunjaŋ yafiye m’bulago, bi erum eᵽiliŋ-bufal ni gaat min ala yo áloul avelovelo. ");
INSERT INTO bqj_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Atúla, aw bare ninage min uᵽagenom ! ");
INSERT INTO bqj_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, no ukana-galego gujae me éjoul bi etigeni, ᵽan uilo liŋ min uhamil. ");
INSERT INTO bqj_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, mitiñ mammeŋe ᵽan múᵽurul ni mofi. Ettami ᵽan esen mitiñay bi ni mal ávi ró. ");
INSERT INTO bqj_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafutali, aw núnini ti etahala yalet ni fipeh yabaje miñil máarie ti yo. ");
INSERT INTO bqj_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Susef, aw núnini ti gátuh gaĉeje gaiye gulof ébula. Ulan go ᵽan ujiŋ guteᵽ gagu úᵽur babu. ");
INSERT INTO bqj_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ulatorai n’gugeĉi ni guyai simele n’gutigeni nímoro. ");
INSERT INTO bqj_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bare nútuh fuŋajeni liŋ, ban gañeni n’guroŋ to ni míseli go, mata Aláemit nasenisen sembe. Ti nah’apoy me ínje Sakob, ᵽan apoi may ; o aamme akoña ahu, o nah’apoy me Israel. ");
INSERT INTO bqj_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Aw Susef, ni gajow gal Aláemit ala ᵽai aamme arambenai, Aláemit-Sembe aseni me gásumay, mb’uyab maaro máaveul me fatiya ti mal maa émit, nuyab ᵽoᵽ maaro máᵽureul me n’ettam ti mal ébula. Ᵽan ubaj gátuh gahulo, ban ᵽan ukan an ala gafal ! ");
INSERT INTO bqj_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Gásumay gagu go ínje ᵽai ilai me gújalojalo iki gufaŋ gaa gurijaŋ gagu. Mb’Aláemit áannul go bi ni aw, Susef, o naĉob me ni gutii ! ");
INSERT INTO bqj_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Baisomen, aw núnini ti ejoba-baha yo neh’efaĉul me. M’bujom ᵽan eke jasaw néhab bo wo ejoh me ᵽe, tiname néŋarul wo ebaj me ek’egabor. » ");
INSERT INTO bqj_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ubuge ᵽe gavogi maa, bugo guilen me guil gagu gaamme guñen ni gúuba gal Israel. Dáru ñer gurim gagu go ᵽail alobil me no násonieneil me, ánoan firimol fúbuli. ");
INSERT INTO bqj_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Mbiban Sakob naagil : « Funah eĉelom, mbi jufogom ni fuyah sipayom gufan, ni gaun gagu gaamme ni firijaŋ fafu faamme n’galah gagu gal Eforon áᵽullo me Hit. ");
INSERT INTO bqj_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ti jiᵽi me n’jiffas yo, ugu baubu Kanaan, gulof Mámure, n’ésuh yay yaa Makupela. Aburaham aamme ᵽay ᵽayul afan anome galah gaugu ni guñen Eforon ala Hit, min ábahen go akan fuyagol. ");
INSERT INTO bqj_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Dó gufogol me, bugo ni aarol Saara, ni may ᵽayul afan Isak bugo ni aarol Rebeka. Dó may nifoh me jaul Lea. ");
INSERT INTO bqj_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ni bugaa Hit gunome galah gaugu ni gaun gagu gaam dó me. » ");
INSERT INTO bqj_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","No Sakob alob me n’guñolol aban, nabbañ afilo ban naalo. Min akay atoh bo sipayol gufan n’ufuga. ");
INSERT INTO bqj_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Susef no naffas me búoh ᵽayol naĉeĉet, naiyul álloŋol ni mufuol ró. ");
INSERT INTO bqj_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Navoh úsotenaaw bugola naagil gucokor efuluŋ ᵽayol bi gafoh gagu. N’gukan mo. ");
INSERT INTO bqj_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ban ni bakaneril ᵽan gunamo gunah úvi gúuba ecokor efuluŋ yay. Bugal Esíp, bugo n’gúnigool molil gunah úvi gúfaji ni guñen. ");
INSERT INTO bqj_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","No gúnigo gagu gubao me, Susef naboñ bugaa ró gávi gagu naagil : « Juboket julobom ávi ahu firim faufe : ");
INSERT INTO bqj_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Ᵽayom balama aĉet, nalobom ibbat mb’íjaenum efuluŋol ik’ifoh baubu Kanaan ni fuyah fafu fo naogoro bo me. Injé umu n’elai mb’uhalóli n’jujow iki jufogulol bo min jíbbañul.” » ");
INSERT INTO bqj_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Aví ahu nábbañul gahoŋen gagu aagol : « Yoo, újaenum efuluŋ ᵽai uk’ufoh bo ti nubbatol yo me ! » ");
INSERT INTO bqj_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ñer Susef najow bi eke efoh ᵽayol. Najaor ni úvula ávi ahu, ufan gávi gagu ni ᵽoᵽ bugagu ufan gaam dó me Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Bugaa yaŋol ni gutiol ni bugaa fiilol ᵽe n’gútinenol, iki ŋaño ró Goĉen uñiaw bare ni sukore sasu. ");
INSERT INTO bqj_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ni baj ᵽoᵽ utiga garembore siᵽiliŋ-bufal, bugagu sisaret, gútinenil. N’gukan fítiman fámah. ");
INSERT INTO bqj_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","No gusat me fal fafu fo guvoge me Suruden, n’gurobo n’eŋam yay yo guvoge me Atad, min guhulol bo ñuhul ñámah. Susef nakoŋ bo ᵽayol gunah futoh ni gúuba go gunamo bo me. ");
INSERT INTO bqj_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Bugaa Kanaan gaĉin bo me, no gujugil me, n’guoh : « Maagen, ñuhul ñe ñujoge Esíp nár. » Yo eĉil me n’gukan tiñ tautu gajow gagu gaa Abbel Misiraim (dóemme \"ñuhul ñal Esíp\"). ");
INSERT INTO bqj_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Mbi guban, guñol Sakob n’gukan ti ᵽail alobil me, ");
INSERT INTO bqj_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","n’gújaenum efuluŋol bi Kanaan iki gunemen baubu Makupela galam Mámure, ni gaun gagu gaamme ni galah gagu go Aburaham anom me ni Eforon ala Hit bi ekan to fuyagol. ");
INSERT INTO bqj_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","No gufogulol me guban, Susef ni gutiol ni gátinenil me n’gúbbañul bugo ᵽe bi Esíp. ");
INSERT INTO bqj_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ᵽúrto, guti Susef n’guogoro : « Susef ᵽiaŋ mat’ajogolal maer ti ulatorol, min abbañenolal maarat mamu ᵽe mo nukanaol me, nemme ᵽayolal naĉele. » ");
INSERT INTO bqj_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ñer n’guboñ guoh Susef : « Nuffase ᵽai bala aĉet, naagóli ");
INSERT INTO bqj_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","mbi juogi mb’uboketóli wóli gutii maarat mamu ᵽe mo jikani me. Yoo, wóli bi eroreni mb’uboketóli ñer ni gatil gaugu. Wóli bugo aw uffas me búoh n’Aláemit anur jíinene ni ᵽai. » Susef no naun me gahoŋen gaugu, nanamo ukoŋ. ");
INSERT INTO bqj_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","No gutiol faŋail gujoulo me iki gutogol, n’gulo to n’guolol n’guogol : « Wóli umigeli ! » ");
INSERT INTO bqj_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bare Susef naagil : « Jambi júholi ! Injé ilet Aláemit bi etegul ! ");
INSERT INTO bqj_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Jimaŋenmaŋ ekanom maarat, bare Aláemit nábahen mo akan maaro. Min aᵽagen bugan gammemmeŋ, ti jujuh yo me jama. ");
INSERT INTO bqj_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Jambi jitelenor ! Ᵽan ijegorul buru ni guñolul. » Min alobil me gurim gaugu gásum mee, uinumil n’ufilo. ");
INSERT INTO bqj_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ñer Susef ni gabugor ᵽayol n’guĉin bo Esíp. Nanamo to ak’abaj símit ekeme ni guñen (110) min aĉet. ");
INSERT INTO bqj_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ban namat gabugi guñol guñol áᵽurol Efuraim. Namate ᵽoᵽ gabugi gaa Makir, añol áᵽurol Manase, iki o Susef nah’aleb guñolol. ");
INSERT INTO bqj_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Funah fice, Susef naah buganol : « Ᵽan igub buulom. Bare ínje ilobul yo, Aláemit ᵽan ailo búsolul. Ᵽan áᵽurenul ni mof maume abbañen bi Kanaan, mof mamu mo nalob me mala mo sipayul gufan Aburaham, Isak ni Sakob ᵽio bo. » ");
INSERT INTO bqj_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nabbañ aagil : « Jibbat búoh, no Aláemit ajae me éᵽurenul babe, ᵽan jíjaenum efuluŋom iki jufoh bo. » Min gubbat fo. ");
INSERT INTO bqj_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Susef naĉet o babajer símit ekeme ni guñen (110). Ñer n’gucokor efuluŋ yay n’gulogos yo míĉir, mamu mbi eᵽio jambi egal. Guban n’gukan yo ni bucaĉ bateᵽiteᵽ ni sival gufoh bo Esíp.");
INSERT INTO bqj_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Elob yauye no ebaj me, ésuh yay yal Israel yo m’babajerut ávi. Gannay gaugu, bieb báloerul dó n’ésuh yauyu. Ñer ace áine, gajaol Elimelek, áᵽullo Betuleem ni mof mamu maa Yuda, náᵽur n’ésugol bugo n’aarol ni úᵽurol gúuba. Min gujow bi ni mof mice mo guoge me Moab. Aarol gajaol Noemi, úᵽurol ahu gajaol Malon, ahu Kilion. Bugo ni fiil fal Efarata gúᵽullo. Ñer n’gujow iki guĉin dó Moab. ");
INSERT INTO bqj_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ᵽúrto, áin Noemi, Elimelek, naĉet min aarol áni to ni guñolol. ");
INSERT INTO bqj_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ᵽio, úᵽurol n’guyab sújur bugaa ró Moab : ahu gajaol Rut, ahu Orupa. N’guĉin dó butum símit guñen. ");
INSERT INTO bqj_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mbiban, Malon ni atiol n’guĉet may bugo éubail, Noemi nanamo to nevonol m’babajut añil m’babajut ánaine. ");
INSERT INTO bqj_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Funah fice, dó ni mof mamu maa Moab, firim fuvugul ni futolol, faamme : Atúla nakanno gásumay bugal ésugol min abbanno me asenil eᵽit yaaro. Noemi nagoror bi éᵽurul Moab, o ni gúsabulol. ");
INSERT INTO bqj_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","N’gúᵽurul bi ebbañ mbaa mof mamu maa Yuda. ");
INSERT INTO bqj_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","No gúᵽullo me bi ekay, naah gúsabulol : « Jibbañ bi ni saŋul. Jikanomkan maaro ni ᵽoᵽ guñolom gaĉet me. Ti buru jikanóli me, Aláemit mbi may akanul mo. ");
INSERT INTO bqj_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Mb’asenul ánoan ni buru ánaine min jibaj gásumay ni saŋ wáinul. » Naban nállloŋil. Usábulol n’gukoŋ gúihilor ");
INSERT INTO bqj_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","n’guogol : « Jimaŋut, wóli bi elageni mbal ésugi. » ");
INSERT INTO bqj_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naagil : « Usábulom, jibbañ mbaa saŋ ubugaul. Wa uĉile n’jimaŋ jilagenom ? Jíinene búoh níjue ebaj maer uñil iki guᵽilo eyabul ? Jiffase maer íjuut. ");
INSERT INTO bqj_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Neegul jibbañ mbaa saŋul. Injé nífanume nár bi ebbañ íyabo. Hani níyaboene jama min ibaj uñil, ");
INSERT INTO bqj_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ᵽan júju jinagil ᵽiaŋ iki gújalo min guyabul ? Ᵽan jilat búyabo mala enah yay ? A-a, sújurom. Buroŋom bufaŋe gátañi bolul, mata Aláemit najogomjoh búlat. » ");
INSERT INTO bqj_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ñer gúsabulol n’gufaŋ n’gukoŋe. Orupa nabbañ álloŋol bala akay. Bare Rut najoh búoh ban anamo n’asomol. ");
INSERT INTO bqj_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Noemi naagol : « Ujuh abeli umu n’ebbañ mbal ésugol atoh bo sínatiol. Ukan ti aĉila, uot mbaa súndoi ! » ");
INSERT INTO bqj_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Bare Rut naagol : « Jamb’urondopenom min ihali nibbañ bi súndoom. Bánoban bo nujae, wola. Tánotan to nuĉin me, wola. Bugani buganom, ban Aláemili Aláemilom. ");
INSERT INTO bqj_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","To nujae me eĉet, wola, to may mbi gufogom me. Iní inamout n’aw iki eĉet éfaculorola, mbi Aláemit ategom. » ");
INSERT INTO bqj_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Noemi no najuh me Rut aban dáh bi elagenol, ñer nahabo. ");
INSERT INTO bqj_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Min gujow éubail bi Betuleem. No guĉih bo me, bugal ésuh yay ᵽe no gujugil me, n’gujahali. Waareaw n’guoh : « Dáru Noemi oomme ? » ");
INSERT INTO bqj_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naagil : « Jambi jibbañ juvogom Noemi, gajow gaa gásumay. Maer juvogom Mara, gajow gaa matalo. Mata Aláemit-Sembe nakakan buroŋom bútali. ");
INSERT INTO bqj_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","No níᵽur me tale, biinumom mafiloe, yaŋom gárira yo. Jama Atúla nabbañulom guñen gurakel. Atúla návuomvu búsol, Emít-Sembe ekanutom maaro. Yo eĉil me, jambi jibbañ juvogom Noemi ! » ");
INSERT INTO bqj_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Mamu Noemi abbañulo me, bugo ni ásabulol Rut ala Moab. N’guĉigul Betuleem bugan n’eju ealo eᵽit mitiñil mo guoge me oris. ");
INSERT INTO bqj_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ban áinen Noemi nabaje atiay, gajaol Boas. Ni kan an ala fusumo, ban ni kan asanum. ");
INSERT INTO bqj_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Funah fice, Rut naah asomol : « Nimaŋene ejow búsol ace ike gandakor baubu n’ulah waw. Ter nífokorul bo gukoñ gal oris. » Naagol : « Yoo, aw ujow ! » ");
INSERT INTO bqj_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Min ñer akay nah’aki andakor bo guᵽit me. Kan galah gagu dó naalo me, Boas aĉil go, aamme ati Elimelek. ");
INSERT INTO bqj_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ᵽio maa, Boas náᵽurul Betuleem bi to n’galagol. Nasaf urokaol naagil : « Emít epoyul ! » N’guogol : « Aw may mo. » ");
INSERT INTO bqj_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Naroren afan urokaol naagol : « Bájur baubu, bay náᵽullo ? » ");
INSERT INTO bqj_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Naagol : « Baubu Moab ; Noemi aŋallol bo no náoleul me. ");
INSERT INTO bqj_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nácinomcin ter nájue amuruh waᵽage me ni urokaaw. No naĉilo me ni bujom bi maer, maageima áelout. » ");
INSERT INTO bqj_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ñer Boas naah Rut : « Bájurom, uuttenom. Jamb’ubbañ ualo n’galah gace uke ró gandakor. Unamo tale ni jurok n’ularaom waarema. ");
INSERT INTO bqj_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ujuh bo wáineaw guᵽile me, nulagen waareaw gaamme n’efor. Niĉaĉaf urokaom jambi guyogeni. Marem mujogi me, uk’urem n’uinum waw wo urokaom gúij me. » ");
INSERT INTO bqj_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ñer Rut náñuᵽ iki aya gújulol bújoŋor Boas naagol : « Bu kane nujoh ínje re me, ínje aamme ajaora ? » ");
INSERT INTO bqj_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas naagol : « Niune faŋfaŋ wo nukan me asomi kábiriŋ no áini alet me. Nuhatulo bo ubugai ni ésugi, núkail uĉin n’etut bugan bugo nuffasenut no. ");
INSERT INTO bqj_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Atúla acami mala dáuru ᵽe dó nukan me. Nukelo ulo ni guñen Atúla Israel. Mb’acami mámah ! » ");
INSERT INTO bqj_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut naagol : « Núsume n’ínje nár. Gurimi gutajenom sembe. Ban ínje iŋaŋut ere n’ace ni urokai. » ");
INSERT INTO bqj_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","No guomme ni fitiñ, Boas naah Rut : « Ujóul utiñ ni wóli. Uŋar fiᵽirih faa ganaĉ núrur fo ni basolen babu nutiñ. » Narobo alof uᵽilaaw. Ñer Boas nañurenulol gukoñ gasoisow. Natiñ go ak’apoñ aŋañen. ");
INSERT INTO bqj_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Mb’aban, nailo abbañ ak’emuruh gukoñ. Boas naah urokaol : « Jihalol namuruh gukoñ gagu hani bi n’etut guĉah gagu. Jambi julobol wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Jiin n’júᵽuren n’uñen waw guce gukoñ mb’áju amuruh go. Dáuru ᵽe, jambi julobol wáfowaf. » ");
INSERT INTO bqj_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ñer Rut namuruh gukoñ gagu bi tiname, aban nahah go ᵽe nammeŋen jubbote. ");
INSERT INTO bqj_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Nateb jo naot. Mb’aĉih, nagiten Noemi wo nabajulo me. Náᵽuren may búŋañenol baa gataw gagu asenol. ");
INSERT INTO bqj_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Noemi narorenol : « Tu numukulo me jama gukoñ gaugu ? Ni gay galah nurokulo me ? Aláemit apoy an ahu ásum maa n’aw. » Rut nagitenol bo narokulo me, aban naagol : « Aíne ahumu gajaol Boas. » ");
INSERT INTO bqj_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Noemi naagol : « Nijuge búoh Atúla naroŋe n’egitenola gábboliol. Nah’akakan maaro ni wolal jaroŋ me bi ni gaĉet me ró. Mb’apoy áine ahumu. » Nabbañ aagol : « Boas yaŋolal, bugo guĉil me gafum áini. » ");
INSERT INTO bqj_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut nábbañul aagol : « Boas naagom may irobo n’urokaol n’jiᵽit iki eᵽit yay ebao. » ");
INSERT INTO bqj_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Noemi naagol : « Wárie, bájurom. Ñer unamo n’urokaol, mata ujow me bi ni galah gace, gújue gúlatieni bo. » ");
INSERT INTO bqj_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ñer Rut nah’ake emuruh gukoñ oris yay, ni may gaa mitiñ mice mo guoge me ble, ni manur uroka Boas, iki eᵽit ebao. Ban naroŋ n’eĉin n’asomol. ");
INSERT INTO bqj_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Funah fice, Noemi naah Rut : « Bájurom, ᵽan igiteni bu nujae me ekan núelo, ban nubaj gásumay. ");
INSERT INTO bqj_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Leti nuffase Boas ahumu, ahali me nurok manur n’ularaol, an ala yaŋolal. Ban jama gállim ᵽan ákail ehah oris yay to nah’ahah me. ");
INSERT INTO bqj_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Uk’uuwo ukur, nulosor utiŋo, uban nusimo wañi wafaŋ me jáari, min ujow bi to ni fúhagumol. Nuhot bi no najae me eban fitiñ. ");
INSERT INTO bqj_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Uluj to najae me gafilo. Uban nujow bi to, nufulul guolol nufilo to. Ᵽúrto, aĉila faŋaol ᵽan agiteni bu nujae me ekan. » ");
INSERT INTO bqj_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut naagol : « Yoo, wo nulobom me ᵽe, ᵽan ikan wo. » ");
INSERT INTO bqj_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ñer najow bi to ni fúhagum fafu nakan ti asomol alobol me. ");
INSERT INTO bqj_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas no natiñ me aban, ni súmol, nak’afilo búsol fúpuh bahager babu. Ñer Rut nabbuyul ak’afulul guolol nafilo to. ");
INSERT INTO bqj_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","No nuĉiga me n’etut fuh, Boas nálio áñañag. Nábaho najuh to n’guolol anaare min afiloe. ");
INSERT INTO bqj_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Naah : « Ay uomme ? » Naagol : « Injé amigeli Rut. Ufulom n’gáñin gábili min upoyom, mata aw uĉile gafum áinom. » ");
INSERT INTO bqj_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas naagol : « Atúla ásonieni. Ejouli bi n’ínje egitengiten gákanum gagu go nubaj me ni asomi ni fiilol. Mata uŋesut gamaŋ úᵽur waw, gabaj me bi ni gabajut me. Yo eĉil me gailoi gaa maer gufafaŋ gaa no. ");
INSERT INTO bqj_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Bájurom, maer jamb’ubbañ úholi. Wánowan wo numaŋ me, ᵽan ikani wo. Esúh yay ᵽe guffase búoh aw an ala maagen. ");
INSERT INTO bqj_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Yoo, bakoŋi, gafumom gom, ᵽan iilo míya. Bare nibaje atiay ace o nuffase búoh nafaŋe ínje elof. ");
INSERT INTO bqj_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ᵽan unamo tale efuga yauye. Gajem ni bujom, ᵽan ujugal ter ᵽan amaŋ ailo míya. Amaŋ me, ᵽan akan. Mb’amaŋut, ínje ilobi fo bíᵽimbor Atúla, ᵽan ikani wo níari me ikan. Umóri uwaen bi gajem m’bujom. » ");
INSERT INTO bqj_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ñer Rut námori to n’guot Boas bi ni bujom. Náiyali tinahurab, mata Boas amaŋut an affas búoh aare ahu to naamene. ");
INSERT INTO bqj_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Naagol : « Uyelen gábili gaa fatiya, ban nútuh go liŋ ! » Rut nayelen go min Boas alih ucoᵽ wono futoh ni ganur wal oris áulen dó. Aban nabbañ mbal ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut may naot mbal asomol. No naĉih me, asomol naagol : « Bulagoi búᵽure ? » Ñer nagitenol ᵽe wo Boas akanol me ");
INSERT INTO bqj_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","náfaro aagol : « Nájiom ucoᵽ wono futoh ni ganur wal oris, naagom jamb’íbbañul dó me bi tale n’aw guñen gurakel. » ");
INSERT INTO bqj_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Noemi naagol : « Aw unamo tale nunah min ujuh bu jae me ebao. Niffase áine ahumu añumut éelo maa firim faufu fo m’baŋanout jama. » ");
INSERT INTO bqj_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ñer Boas najow bi n’gánonum ésuh yay to nihi guomunor me, min arobo to. Ᵽiout áine ahu o nalob me Rut mola, náni n’égat. Boas navogol naagol : « Atiom, újoul uloba. » Ñer áine ahu nákail anamo. ");
INSERT INTO bqj_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boas návogul ufan gono guñen bugal ésuh yay niki gunamo. ");
INSERT INTO bqj_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Naah afuma ahu afaŋol me galof : « Nuffase Noemi nabbanno Moab bo naamen me. Naage ᵽan anomen galah gagu gal atiola Elimelek. ");
INSERT INTO bqj_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Yo eĉil me nivoguli manur n’ufan wauwe bi eroreni ter numaŋe unom galah gagu. Mb’eno umaŋut, nugitenom min iffas. Mata aw uomme átinar añum me emundum unom go ; újuut me, ínje aamme áuten, niŋar go. » Naagol : « Yoo, ᵽan inom go. » ");
INSERT INTO bqj_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Naagol : « Unom go me n’guñen Noemi, ᵽan may uyab Rut aamen me aar añol Elimelek, min galah gagu mbi gunamo ni gajow gaa fiilol. » ");
INSERT INTO bqj_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Naagol : « Iní me mamu, mat’íju. Mata ikan mo me, fubajom ᵽan fúkasulo. Kan aw uk’unom, ínje mat’íju. » ");
INSERT INTO bqj_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","No, baubu Israel, bugan gúuba gujamor me bi bitilor ter búallor, ace ni bugo ᵽan áᵽuren gadalaol asen apalol bi egiten búoh bugo gujamore. ");
INSERT INTO bqj_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ñer afuma ahu naah Boas : « Ñer uk’unom go ! » Min áᵽuren gadalaol asen Boas. ");
INSERT INTO bqj_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ñer Boas naah ufan waw ni bugan bugagu gaam to me : « Jama buru jimat me búoh ebaj yay yal Elimelek ni guñolol Kilion ni Malon, yaamme ni guñen Noemi, maer ínje iĉil yo. ");
INSERT INTO bqj_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ban ᵽoᵽ ᵽan itun Rut ala Moab aamen me aar Malon ; mamu, fubaj fafu ᵽan funamo ni fiil fafu fal umu alet me. Ban ᵽan abaj uñil jambi gajow Malon gunemo n’ésuh yay ; uñiaw ubugu ᵽan gúju guilo mala fiilolal gajem. Yoo, jama buru jimat me firim fafu. » ");
INSERT INTO bqj_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ñer ufan waw ni bugan bugagu gaam to me n’guogol : « Maagen, wóli jimat me. Atúla asen gapos aare ahumu ajae me enogen ni yaŋi. Emít esenol gabugor gámah ti gaa waar Sakob Raĉel ni Lea, gaamme sijaw gufan bugal Israel. Emít eseni fubaj ni fiil fafu fal Efarata, ban gajai n’guuno Betuleem ᵽe. ");
INSERT INTO bqj_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Emít éjii gátuh ni aare ahumu, ban yaŋi mb’éni ti yaa Ᵽeres, añol Yuda bugo ni Tamar. » ");
INSERT INTO bqj_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ñer Boas nayab Rut min áni aarol, n’gunamo. Atúla násonienol min ateb ak’aalen, nabaj añil ánaine. ");
INSERT INTO bqj_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Waareaw n’guoh ñer Noemi : « Usalal Atúla mata jama naseni an ajae me ecokori. Ban gabulakeni ugu, gajaol ᵽan guuno mámah Israel. ");
INSERT INTO bqj_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ᵽan akani újumor buyoh babu bo nuomen me ni bo, ban ni fúfanumi ᵽan acokori. Ebaj ásabul ti Rut, abugol me ban namaŋi nár, eĉila efaŋe aw babajener úᵽur futoh ni gúuba. » ");
INSERT INTO bqj_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ñer Noemi nateb añil ahu aleb, aban naŋarol ak’aagen. ");
INSERT INTO bqj_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Uĉindorol waarema n’gujogol nan Noemi abugol, n’gukanol gajow gagu gaa Obed. Obed aamme ᵽay Yese, abuh me David. ");
INSERT INTO bqj_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Dáre ñer ujow waw waa sipay David gufan, újogum ni Ᵽeres : Ᵽeres abuh me Hesoron, ");
INSERT INTO bqj_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesoron nabuh Ram aamme ᵽay Aminadab. ");
INSERT INTO bqj_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab nabuh Naĉon aamme ᵽay Salman. ");
INSERT INTO bqj_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salman o abuh me Boas, ᵽay Obed. ");
INSERT INTO bqj_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed nabuh Yese aamme ᵽay David.");
INSERT INTO bqj_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Baje ace áine, gajaol Sonas, ᵽayol gajaol Amitay. Ni baj funah fice, Atúla navogol naagol : ");
INSERT INTO bqj_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","« Uilo ujow bi n’ésuh yay yámah yay yo guoge me Niniv, min uĉafil uogil búlaᵽut babu bo guomme ni bo, nipoñbopoñ. » ");
INSERT INTO bqj_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ñer Sonas nailo ajow, bare bi etey mbal ésuh ece, gajow yo Tarisis, bi éhatulo n’Atúla. No naĉih me n’gásih gagu gaa Jafa, natoh to baraca baam n’ejow ni fal fámah mbaa Tarisis. Nacam ejaol min ájuᵽo mimanur ni bugan bugagu gajae me Tarisis, dó ᵽe bi etey Atúla. ");
INSERT INTO bqj_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","No gutey me guĉih babu, Atúla nayalil fúrus fáamah, fal fafu ni fiteh iki fumaŋ efum baraca babu. ");
INSERT INTO bqj_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ujaoraol n’gúholi, ánoan náᵽib nalaw nímoro álaemilol. N’guteb wañil ᵽe gubelen ni fal, mata mbi baraca babu bufaŋ m’bivilie. Sonas kan aĉila umu ró ni gatal bo, min ámoe ahay was. ");
INSERT INTO bqj_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ñer afan baraca babu najow atogol to naagol : « Buenne ? Aw gámori ? Uilo ulaw álaemili ! Ter ᵽan arumolal enil jamb’uĉelal. » ");
INSERT INTO bqj_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Bugaa baraca babu n’gúᵽur jolil n’guoh : « Uñagoral usos min ujugal ay ni wolal aŋallo me biᵽila baube. » No guñagor wo me, ni lo ni Sonas. ");
INSERT INTO bqj_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ñer n’gubbañ iki guogol : « Biᵽila baube, aw ukanóli bo. Ugitenóli wa nuom dáre nekan. Bay núᵽullo ? Aw an bu ? » ");
INSERT INTO bqj_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Nábahulil : « Injé an ala Híbori, ban ni Atúla níinene aamme fatiya, Aláemit átut me fal ni ettam. » ");
INSERT INTO bqj_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Naban nagitenil waĉil me naam n’etey ráli Aláemit, n’gúholi nár. N’guogol : « Nujuge bakaneri ! » ");
INSERT INTO bqj_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","N’gutajen guogol : « Ñer bu jijae ekani tima fal fafu ni fulluhor ? » Mata gulongos gagu ugu n’efaŋ n’gutege. ");
INSERT INTO bqj_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Naagil : « Jujogom jibelen dó, mo fal fafu ᵽan fibeben. Maagen niffase búoh ínje iĉile min fúrus faufe fubaj. » ");
INSERT INTO bqj_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","N’gumundum ᵽan gulih even bi n’galam, bare gújuut mata fal fafu fufafaŋ ni fitege. ");
INSERT INTO bqj_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ñer n’gulaw Atúla n’guogol : « Jamb’umugóli mata ahume ! Jamb’ujogóli may bugan gamuge an añumenut eĉet ! Ban aw Atúla, nukakan wo numaŋ me. » ");
INSERT INTO bqj_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","No guban me, n’gujoh Sonas gural dó. Ñer fal fafu ni fúbbañul fíjebi. ");
INSERT INTO bqj_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ni ᵽúrto, n’gúkanum Atúla nár iki gukanol bísimen min gubbat gáinenil ni o. ");
INSERT INTO bqj_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ñer Atúla náboñul eol yámah ékail émer Sonas. Nanamo ró ni far yo sutufunaha sífaji ni sufuga sífaji. ");
INSERT INTO bqj_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Ni far eol yay nalaw Atúla aamme Aláemilol ");
INSERT INTO bqj_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","naagol : « Bíyih bámah nibaje, níbaho nivoh aw Aláemit, núttunom. To ni butum eĉet yay níᵽib min urambenom, nuun firimom. ");
INSERT INTO bqj_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ni másiko fal fafu nubelenom, ban mal mamu múgolom múharo. Gatey mal mamu n’guĉimenom, gulongos gagu n’gúggubom gúharo. ");
INSERT INTO bqj_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Injé nieh : “Nutosenom dáli ni aw. Nimaŋene ibbañ ijuh yaŋi yanab me.” ");
INSERT INTO bqj_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Muu mamu mímmeŋul iki mireom n’ehondor. Injé umu n’étimo, mafos mamu ni mugolenom ni fuhow. ");
INSERT INTO bqj_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nialoene bi to n’ettam gurijaŋ gagu. Nijaene mbaa buroŋ babu baa gaĉet me, ettam yay ᵽan eᵽamunorenom bi nánonan. Bare aw Aláemit aamme Atúla, núᵽunnulom maroŋe ni gasun gaugu, ");
INSERT INTO bqj_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","mata nikaene eĉet. Bare niosen míya min ilai ; galaom n’gujow iki gutogi bo ni yaŋi yanab me. ");
INSERT INTO bqj_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Gabaj me gáinen bamotoŋ n’uce úbuli n’aw, mati gúmus gubaj gásumay. ");
INSERT INTO bqj_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ban ínje ᵽan ísimeni nisali nímoro. Ᵽan ikan wo nibbat me ni aw Atúla, aw aamme aᵽagena ahu. » ");
INSERT INTO bqj_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Ñer Aláemit naah eol yay : « Uk’úmasul Sonas ni mahae ! » Nemasulol to baenah. ");
INSERT INTO bqj_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ñer Atúla nabbañ aah Sonas : ");
INSERT INTO bqj_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","« Uilo, ujow bi Niniv, ésuh yay yámah yay, uk’ugitenil bo wo nilobi me. » ");
INSERT INTO bqj_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Ñer Sonas nailo ajow, bare ñañe bi Niniv, ti Atúla alobol yo me. Ban Niniv ésuh yom yájaloe nár ; ᵽan ukan gunah gúfaji bala ujow yo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","No Sonas anogen me n’ésuh yay, najow ró funah fanur iki fubao bala áelo. Naagil : « Juutten min ilobul. Tale gunah úvi gúuba, Niniv mati ebbañ éni ésuh ! » ");
INSERT INTO bqj_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ñer bugaa Niniv n’gúinen n’Aláemit. N’guoh baor n’gukano wañ waa ñuhul bugo ᵽe, gabaj me bi ni gabajut me, bi egiten gaa búoh guteteh mahat. ");
INSERT INTO bqj_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Kan elob yay eunoe bi n’ávi ahu. Nailo n’efenjeŋol náᵽuren gájuool gal ávi min ñer asimo may ti buganol, aban nanamo ni bukugay. ");
INSERT INTO bqj_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Aví ahu ni úvulaol n’gusen gúboñ gauge : « Jigiten gurim gauge n’ésuh yay ᵽe : Fírenifiren marem ni fitiñ bugan bugagu ni súnuhureŋ sasu ; jambi ébe, gabbarum, ejamen sifen. ");
INSERT INTO bqj_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Min ánoan akano wañ waa ñuhul, bugan bi ni súnuhureŋ dó. Ᵽan ánoan alaw ni sembeol ᵽe Aláemit. Anóan ahat bakanerol baarat me, ahat búlaᵽut bánoban bo nah’akanen me. ");
INSERT INTO bqj_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ay affase ? Ter Aláemit ᵽan abbañ abaj gaᵽinor gace, min aalen fiiñol bújoŋorolal jamb’uĉelal. » ");
INSERT INTO bqj_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Aláemit no najuh me búoh ubugu n’ehat bakaneril baarat me, nábahen gaᵽinorol. Nahat, buyoh babu bo naᵽinoren me ekanil, abbañut akan bo. ");
INSERT INTO bqj_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Sonas súmutol hani, min Aláemit aboket me bugaa Niniv, ban fiiñol ni fitiñ Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Nalaol aagol : « Atúla, no niomen me n’ésugom, niᵽiene niffas búoh ᵽan uboketil. Mo kane nisommen nitey mbaa Tarisis. Niᵽie niffas búoh aw gamaŋi gújalojalo, nújuju ñarum enil, nújuju ebeben waf, nummemmeŋ gábboli, ban nuhat sílam sasu so numaŋenil me ekan. ");
INSERT INTO bqj_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Maer ñer, Atúla, uŋarom min íelo. Ey, eĉet efaŋom buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ñer Atúla naagol : « Núinene ni maageni fiiñi fitiñ me ? » ");
INSERT INTO bqj_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Sonas ñer nágat ak’arobo ga galam gaa Niniv bo tinah túᵽureul me. Nacokor bo gateb min áuro, tima mb’ajuh wajae me ebaj n’ésuh yay yaa Niniv. ");
INSERT INTO bqj_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ñer Aláemit Atúla nakan jununuh jiilo bi éurenol, ni may bi ealen fiiñol. Sonas ni súmol nár mata jo. ");
INSERT INTO bqj_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Tihalen fo, bala tinah túᵽurul, Aláemit náboñul eo ek’eya jununuh jaju min jihay. ");
INSERT INTO bqj_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Mbi no tinah titebulo me, ni baj érus yásuᵽe yo Aláemit ainnulo bo tinah túᵽureul me, ban bunaa babu m’búsuᵽ nár ni fuhow Sonas ak’amaŋ érit. Ñer naᵽinor eĉet bare, naah : « Eĉet éhoyumom buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Aláemit narorenol : « Aw núinene ni maageni fiiñi fitiñ me mata jununuh jauju ? » Nábahulol : « Ey, ni maagenom fiiñom fitiñe, iki imaŋ eĉet. » ");
INSERT INTO bqj_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Atúla nabbañ aagol : « Aw enili erundum jununuh jauju, ban aw ukanut jo burok bánoban. Let aw ukan jo n’jiilo. N’efuga yanur jibbage, n’efuga yanur may jihae. ");
INSERT INTO bqj_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Uluj Niniv : Gaam dó me gufaŋe súuli ekeme ni ávi, gaffasut me maaro ni maarat. Baj ró may súnuhureŋ sammeŋe. Ñer aw nuoge ésuh yauyu yájalo me yaamme Niniv, ínje iarenat irum yo enil ? A-a, íjuut ikan mo ! »");
INSERT INTO bqj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ujow waw waa sipay Yésu Kirista gufan uwe : Gabulaken gom gaa David aamme gabulaken gal Aburaham. ");
INSERT INTO bqj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburaham abuge Isak ; Isak nabuh Sakob ; Sakob nabuh Yuda ni gutiol ; ");
INSERT INTO bqj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda nabuh Ᵽeres ni Sera ; jail gajaol Tamar. Ᵽeres nabuh Hesoron, Hesoron abuh Aram ; ");
INSERT INTO bqj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram nabuh Aminadab, Aminadab aĉila abuge Naaĉon, Naaĉon abuh Salimon. ");
INSERT INTO bqj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimon ayab me Rahab nabuh Boas ; Boas ayab me Rut nabuh Obed. ");
INSERT INTO bqj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obed o nabuh Yese, Yese abuh David. Aví ahu David ayab me aar Uri nabuh Salomoŋ ; ");
INSERT INTO bqj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoŋ nabuh Roboam, Roboam abuh Abia ; Abia aĉila o abuge Asa. ");
INSERT INTO bqj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nabuh Yosafat abuh me Yoram ᵽay Osias. ");
INSERT INTO bqj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osias nabuh Yotam, Yotam nabuh Ahas abuh me Esekias. ");
INSERT INTO bqj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekias nabuh Manase, Manase nabuh Amon abuh me Yosias ; ");
INSERT INTO bqj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosias nabuh Yekonia ni gutiol, unnay waw no gujoh me Esúif yay ni sembe gújaenum búuy mbaa Babilon. ");
INSERT INTO bqj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Búsol búuy babu baa Babilon, Yekonia nabuh Ĉelasiel ; Ĉelasiel o nabuh Sorobabel ");
INSERT INTO bqj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","abuh me Abiud. Abiud abuge Eliakim, Eliakim abuh Asor. ");
INSERT INTO bqj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor nabuh Sadok ; Sadok o nabuh Ahim abuh me Elíud. ");
INSERT INTO bqj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elíud nabuh Eleasar, Eleasar nabuh Matan abuh me Sakob. ");
INSERT INTO bqj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sakob o abuge Susef áin Mari abuh me Yésu o guvoge me Kirista. ");
INSERT INTO bqj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kan ñer baje ᵽe jabbah jono guñen ni jibbagir (14) kábiriŋ Aburaham bi ni David, jabbah mul jono guñen ni jibbagir kábiriŋ David bi ni búuy babu mbaa Babilon, ni jabbah jice jono guñen ni jibbagir kábiriŋ búuy babu mbaa Babilon bi ni Kirista. ");
INSERT INTO bqj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gabugi gagu gaa Yésu Kirista maa gujoumulo : Babaj ace áine gajaol Susef aᵽañe bájur bice gajaol Mari ajae me éni jaw Yésu. Balama guĉin tiñ tanur, Mari ahumu naŋar far ni búkanum baa Biinum Banabe. ");
INSERT INTO bqj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","No najugol me mee, áinol Susef aamme ánaine aĉole ban amaŋut áᵽunnol n’ésuh, najoh bi ehalor ni o an m’baffasut wabaj me n’etulil. ");
INSERT INTO bqj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","O ni gaᵽinor gaugu, ni baj amalaka Aláemit áᵽullol ni súmori naagol : « Susef, añol David, jamb’úholi eŋar aari Mari, mata far fafu fo naam mee ni fo búkanum bom baa Biinum Banabe. ");
INSERT INTO bqj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ᵽan abuh áᵽur, ban ᵽan ukanol gajow gagu gaa Yésu, mata aĉila ajae me eᵽagen ésugol ni utilil. » ");
INSERT INTO bqj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Urú ᵽe kanokano min mbi wo Aláemit alob me ni butum aboñer ahu Esai ukano, no naah me : ");
INSERT INTO bqj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","« Bájur babu affasut me ánaine ᵽan aŋar far ; ᵽan abuh áᵽur ban ᵽan gukanol gajow gagu gal Emanuel. » (Dóemme \"Aláemit umu ni wolal\".) ");
INSERT INTO bqj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","No Susef álio me, nakan wo amalaka ahu ala Aláemit alobol me ni súmori sasu, min ñer ayab aarol abaŋ ni yaŋol. ");
INSERT INTO bqj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bare akait ni o iki aarol apegor áᵽur ; Susef nakanol gajow gagu gaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yésu nabugi Betuleem ni mof maa Yúde, gannay gagu no ávi ahu Herod aamen me ni fuhow mo. Ni baj bugan búgamah gabaje gaffas ni suut sasu gáᵽullo ráli bo tinah talu tiiyeul me guĉigul dó Yérusalem ");
INSERT INTO bqj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ban n’guroren guoh : « Umelo, ávi ahu ala Esúif yay aju me ebugi ? Wóli jujugulo eut yay yola kábiriŋ baubu bo tinah talu tiiyeul me ; aĉila jikelo maa emigelet. » ");
INSERT INTO bqj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","No ávi ahu Herod aun me firim faufu, náguo mala gajahali manur ni bugaa Yérusalem ᵽooil. ");
INSERT INTO bqj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ñer naomen ufan uteŋenaaw ᵽooil ni úᵽajula gúboñ Aláemit bugagu bugal Esúif yay min arorenil tay Kirista ahu aat me abugi. ");
INSERT INTO bqj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","N’guogol : « Ᵽan abugi Betuleem ni mof maa Yúde, mata aboñer ahu nalobe mola aah : ");
INSERT INTO bqj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Aw Betuleem, ésuh yaa Yúde, let aw uomme ásola ni súsuh sasu sáamumma saa Yúde : uffas búoh an ámah ᵽan áᵽurul n’aw ajae me ekoñ ésugom yaamme Israel.” » ");
INSERT INTO bqj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ñer Herod naboñ ni fubbuy guvogulol bugan bugaubugi bugo gaffasil gújalo mee min gugitenol joon tinah tay eut yay eraŋulil mee. ");
INSERT INTO bqj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mbiban, naboñil mbaa Betuleem naagil : « Jujow, jiĉih me n’juroren joon mala añil ahumu ; ban no jijae me ejugol, jikanulom min iffas, min mbi ínje may íjoul íkiil imigeletol. » ");
INSERT INTO bqj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","No guutten me ávi ahu guban, n’gukay. Bugo n’ejow yay, eut yay yo gujugulo me baubu bo tinah talu tiiyeul me neyabil gayoŋ ; no eĉih me tiñ talu to añil ahu aamme, neilen to fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","No gujuh me eut yay eilen, ésumay yámah nenonil. ");
INSERT INTO bqj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ñer n’gunogen ni yaŋ yay, ban n’gujuh añil ahu bugo ni jaol Mari ; n’guya gújul, ban n’gúñuᵽ n’gúni n’emigeletol. Mbiban, n’gúpegul dó gubaŋe me gubajil gáamumma min gúᵽuren dó éurus, batiŋoa ni míĉir gújiol. ");
INSERT INTO bqj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ᵽúrto, nemme Aláemit nátalleniltallen ni súmori gaa búoh jambi gubbañ me bi nende Herod, ñer n’guŋar bulago bice min guot mbal ésugil. ");
INSERT INTO bqj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","No gukay me, amalaka ala Aláemit náᵽurul Susef ni súmori naagol : « Uilo, uŋar añil ahu ni jaol nutey bi Esíp ; urobo ró bi no nijae me eogi úbbañul, mata Herod ᵽan aŋes añil ahu bi jamugol. » ");
INSERT INTO bqj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ñer Susef nailo n’etut fuh naŋar añil ahu ni jaol, ban najow ak’akoᵽ baubu Esíp. ");
INSERT INTO bqj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nanamo bo iki Herod aĉet ; mamu, min mbi wo Aláemit alob me ni butum aboñer ahu ukano, no naah me : « Nivoge áñum min iogol áᵽurul Esíp. » ");
INSERT INTO bqj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","No Herod ajuh me búoh bugan bugagu gabaj me gaffas ni suut sasu gubutolbut, fiiñol ni fitiñ faŋ ; naboñ gumuh úᵽur waw ᵽe gabaj me símit súuba ualen mbal ettam gaamme Betuleem ni sasu súsuh saa mofol. Símit sausu so nabet mee sijaojaor ni bagitener babu bo bugan bugagu bugaa gaffas gagu gulobol me. ");
INSERT INTO bqj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ñer wo aboñer ahu Séremi alob me n’ukano, no naah me : ");
INSERT INTO bqj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","« Firim fúᵽullo baubu Rama, ukoŋ ni gaĉagor gámah : Raĉel akoŋe mee eĉet yay yaa guñolol ; amaŋut an asaforol. » ");
INSERT INTO bqj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","No Herod aĉet me, amalaka ala Aláemit náᵽurul Susef ni súmori bo Esíp ");
INSERT INTO bqj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","naagol : « Uilo, uŋar añil ahu ni jaol min ubbañ bi ni mof mamu maa Israel ! Bugan bugagu gamaŋen me emugol guĉele. » ");
INSERT INTO bqj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ñer Susef nailo, naŋar añil ahu ni jaol min aot bi ni mof mamu maa Israel. ");
INSERT INTO bqj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bare no naun me búoh añol Herod o guvoge me Arukelaus aŋare efenjeŋ ᵽayol yaa jávi mof mamu maa Yúde, náholi ebbañ bo. Ñer Aláemit nátallenol ni súmori min añago bi ni mof mamu maa Gálile. ");
INSERT INTO bqj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Najow ak’aĉin n’ésuh ece gajow yo Nasaret ; mamu, min mbi wo uboñer waw gulob me guya ni Yésu ukano no guoh me : « Ᵽan guvogol an ala Nasaret. » ");
INSERT INTO bqj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ni tinah tautu Saaŋ Batis áᵽullo me, nah’avare ni gafit gagu gámah gagu gaa mof mamu mo guvoge me Yúde. ");
INSERT INTO bqj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nah’aah : « Jihat bakanerul baarat mee, mata Jávi jaju jaa fatiya julofulo. » ");
INSERT INTO bqj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Saaŋ o aamme an ahu o aboñer ahu Esai alob me mola no naah me : « Firim fúᵽureul baubu n’eᵽarandaŋ yay nihi fuoh fatiya : “Jiteŋen fukaen bi ni Ataw ! Jiyaol ulago waĉole !” » ");
INSERT INTO bqj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bisimo Saaŋ ni bufal eñokombo bucokori, ban nah’ahogo ni fuhoŋolol gasinja gaa gabaŋ. Ujamen-émit ni múhum maa baha nah’atiñen. ");
INSERT INTO bqj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bugaa Yérusalem, bugaa ñer Yúde ᵽe ni bugan bugagu ᵽe bugaa galam fal fafu fo guvoge me Suruden nihi gujow gutogol bo, ");
INSERT INTO bqj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ban n’gugiten utilil bújoŋor ésuh yay ᵽe, min ñer Saaŋ ábatiseil ni fal faufu faa Suruden. ");
INSERT INTO bqj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","No Saaŋ ajuh me búoh Eᵽárisie ni Esáduke gammeŋe gújaeuljow bi eyab gábatise ni o, naagil : « Buru gabugor súᵽudum ge ! Juoseh mamu jijae eᵽah bataliŋ Aláemit bájaeul me. Ay alobul mee ? ");
INSERT INTO bqj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mbi nihi jikan maaro bi egiten búoh ᵽan jíbahen bakanerul ! ");
INSERT INTO bqj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jambi jinamo to nánonan eoh : “Nemme wóli gabulaken Aburaham jom, ᵽan jiᵽah.” Injé ilobul yo : leti jujuge sival sause ? Yoo, Aláemit áju me ábahen so síni gabugor gal Aburaham. ");
INSERT INTO bqj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Fínir fafu ufu to n’fubaŋi bi efar ununuh waw ; bununuh bánoban babugut mitiñ maaro ᵽan biᵽiki bibeni ni sambun. ");
INSERT INTO bqj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Injé ni mal níbatiseeul mala ehat bakanerul baarat me. Bare an ahu ajae me éjoul búsolom nafaŋom sembe fúf, iᵽilout bi éᵽunnol sidalaol. Aĉila ᵽan ábatiseul me ni Biinum Banabe ni sambun. ");
INSERT INTO bqj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ᵽan aogen ni gañenol gárigol gal eey bi éfaculor emano yay ni emey yay. Emano yay, ᵽan abet yo ni bíjej, bare emey yay, yo ᵽan akan yo fuñulen fañumut efogo. » ");
INSERT INTO bqj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Funah fice, Yésu náᵽurul Gálile ak’atoh bo Saaŋ galam fal fafu faa Suruden bi eyab gábatise. ");
INSERT INTO bqj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bare Saaŋ aruhenut ban naagol : « Injé isoholae min aw úbatiseom ; aw til nújoul mbal ínje ! » ");
INSERT INTO bqj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yésu naagol : « Maer umaŋ uhabo min kano ; mamu nuotae ukana min mbi wo Aláemit amaŋ me ukano. » Ñer Saaŋ namaŋ. ");
INSERT INTO bqj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","O n’eban eyab gábatise, Yésu náᵽurul ni mal mamu. To baenah, émit yay népegulo, ban najuh Biinum Aláemit búavul ti gálab birembor ni o. ");
INSERT INTO bqj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ni baj firim fúᵽurul n’émit fuoh : « Ume Añolom o nifaŋ me níbbolie ; ésumayom ᵽe ni o yom. » ");
INSERT INTO bqj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ᵽúrto, Biinum Banabe m’bújaenum Yésu bi ni gafit gagu gámah gagu min mbi Seytane álingen gáinen gagu gola. ");
INSERT INTO bqj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Naor bo sutufunaha úvi gúuba ni sufuga so ró, ᵽúrto bieb m’bujogol nár. ");
INSERT INTO bqj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ñer álingena ahu Seytane nalofulol naagol : « Iní me maagen aw uomme Añol Aláemit, uoh sival sausu síbaho unaĉ. » ");
INSERT INTO bqj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yésu naagol : « Bahiĉer babu buoge : “Arafuhow let mitiñay bare mujae eĉilol naroŋ, bare ᵽoᵽ firim fánofan fáᵽullo ni butum Aláemit.” » ");
INSERT INTO bqj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ᵽúrto, Seytane nájaenumol bi Yérusalem, ésuh yay yanab me, aĉih najingenol bi ró fatiya gávi-Aláemit gagu ak’ailen ni fibil go fice, ");
INSERT INTO bqj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","aban naagol : « Iní me maagen aw Añol Aláemit nom, úñag uk’uya n’ettam ; leti Bahiĉer babu buoge : “Atúla ᵽan aboñ emalakaol míya” ? Buoge ᵽoᵽ : “Ᵽan guyeni jambi guoli guteh n’eval.” » ");
INSERT INTO bqj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yésu naagol : « Bahiĉer babu buoge ᵽoᵽ : “Jamb’urif Aláemit aamme Atúlai !” » ");
INSERT INTO bqj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seytane nabbañ ájaenum Yésu bi ró fatiya firijaŋ fice fabbage faŋ. Nakanol naluj ñanur súsuh sasu ᵽe saa mof ni jáari so ró, ");
INSERT INTO bqj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","aban naagol : « Nujuge súsuh sausu ? Ᵽan iseni dáuru ᵽee, íni me nuyae gújul bújoŋorom min umigeletom. » ");
INSERT INTO bqj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bare Yésu naagol : « Seytane, úᵽur tale ! Bahiĉer babu buoge : “Ᵽan uya gújul bújoŋor Aláemit aamme Atúlai, ban numigelet aĉila nevonol pat.” » ");
INSERT INTO bqj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ñer Seytane nakay ahalol to, ban emalaka n’gúloful Yésu bi esenol wo nasohola me. ");
INSERT INTO bqj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","No Yésu aun me búoh Saaŋ gúruroldur ni fipeh, nailo ajow mbaa mof mamu maa Gálile. ");
INSERT INTO bqj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Náᵽur Nasaret ajow ak’anamo n’ésuh yay yo guvoge me Kaᵽerinaum, yaamme galam fal fafu fáᵽurut me faa Gálile, ni mof mamu maa Sabuloŋ ni Nafutali. ");
INSERT INTO bqj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dó ᵽe min mbi gurim gagu go aboñer ahu Esai alob me gukano gaah me : ");
INSERT INTO bqj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","« Mof maa Sabuloŋ ni mof maa Nafutali, maamme galam fal fámah, ñagagu fal fafu faa Suruden, Gálile yay dó galet me Esúif guĉin me ! ");
INSERT INTO bqj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Esúh yay gaamme n’emoĉ gujuge gajaŋa gámah : bugan bugagu gaĉin me n’éuruŋa yay yal eĉet, gajaŋa guiyulil. » ");
INSERT INTO bqj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ᵽúrto, Yésu nailo gavare nah’aah : « Jíbahen bakanerul, mata Jávi jaju jaa fatiya julofulolof. » ");
INSERT INTO bqj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bo ni galam fal fafu fáᵽurut me faa Gálile, Yésu najuh batiay búuba gaam umbala : Simoŋ o guvoge me may Ᵽier ni atiol Andere. Batiay baubu m’bíni n’ebet fumbal dó ni fal fafu. ");
INSERT INTO bqj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Naagil : « Jújoul jilagenom, ban ᵽan ikanul jíni umbala bugan. » ");
INSERT INTO bqj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","To baenah, n’guhato simbalil min gulagenol. ");
INSERT INTO bqj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","No Yésu abbañ me atos ráli maa, nabbañ ajuh batiay bice búuba : Saak ni atiol Saaŋ, guñol Sebede, bugo bájuᵽoer ni busana ni ᵽail ró, min gúni n’eheten simbalil. ");
INSERT INTO bqj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yésu navogulil ; ban to baenah n’gúᵽurul ni busana babu gúharo ᵽail min gulagenol. ");
INSERT INTO bqj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ñer Yésu najow mof mamu maa Gálile ᵽoomo, nah’aligen bugan bugagu ni saŋ sasu saa galaw sal Esúif yay, navareil Firim fafu Fásum me faa Jávi jaju, ban ᵽoᵽ nah’asen ésuh yay gahoy gaa gásomut gánogan ni buhaj bánoban. ");
INSERT INTO bqj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gáilandiŋol n’guuno guban babu ᵽe dó ni mof mamu maa Siri. N’guŋallol bugan bugagu ᵽe bugo úsomut wánowan uyogen me ni bugaa ñatiñ ñánoñan : guŋallol bugo siseytane sunogen me, galoe me gaay ni ubofoaaw, ban Yésu nasenil gahoy bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gútiman gámah n’gulagenol ; nihi gúᵽurul ni mof mamu maa Gálile ni maa Dekapolis, n’ésuh yay yaa Yérusalem ni wawu ulam ᵽe waa mof mamu maa Yúde, bi ni maa ñagagu fal fafu faa Suruden. ");
INSERT INTO bqj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","No Yésu ajuh me fítiman fafu, najiŋ n’erijaŋ ak’arobo ró. Ulagorol may n’gujiŋ gutogol to naamme. ");
INSERT INTO bqj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ñer nanamo gavareil naagil : ");
INSERT INTO bqj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","« Gásumay gúni ni bugan bugagu gaalenoro me bújoŋor Aláemit : Jávi Aláemit jolil jom ! ");
INSERT INTO bqj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Gásumay gúni ni bugagu gaamme n’ukoŋ : Aláemit ᵽan asaforil ! ");
INSERT INTO bqj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Gásumay gúni ni bugagu gabubi me : gafumil go guomme mof mamu ! ");
INSERT INTO bqj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Gásumay gúni ni bugagu gabaŋ me gaᵽinoril ᵽe ni filiᵽ eroŋ buroŋ baĉole bújoŋor Aláemit : waf waw wo guliᵽe me ᵽan gubaj wo ! ");
INSERT INTO bqj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Gásumay gúni ni bugagu gáju me ñarum enil : Aláemit ᵽan arumil enil ! ");
INSERT INTO bqj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Gásumay gúni ni bugagu bugo uinumil ukur me : ᵽan gujuh Aláemit ! ");
INSERT INTO bqj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Gásumay gúni ni bugagu garoke me bi mala gajamor : Aláemit ᵽan ajogil ti guñolol ! ");
INSERT INTO bqj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Gásumay gúni ni bugagu bugo gúlatiene me mata maaro gukane : Jávi jaju jaa fatiya jolil jom ! ");
INSERT INTO bqj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Gásumay gúni ni buru bugan bugagu bajelerul, bálatienerul ter balober maarat mánoman guya ni buru múmbam. ");
INSERT INTO bqj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Júsumaet, jísangor mata bacam bámah ubu bo m’bunageul fatiya n’émit. Juosen búoh mamu may gúlatien mee uboñer waw bugal Aláemit bugaa no. ");
INSERT INTO bqj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Buru juomme misis mamu maa mof mamu. Bare íni me misis múbbure gafira gagu gala mo, wa ᵽan uŋar min úbbañenul mo go ? Mubbañut maer munafa wáfowaf ; ebelen tíyaŋ bare, nihi bugan bugagu guhah mo bo. ");
INSERT INTO bqj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Buru juomme gajaŋa gagu gaa mof mamu. Esúh yateᵽi fatiya firijaŋ éjuut ekoᵽeni. ");
INSERT INTO bqj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","An mat’usaen may ejaŋa uban nuŋar yo ubaŋ ñáraru elaᵽ ; bare til níh’íni nuremben yo n’ebamba yay, to éju me efijigen bugan bugagu ᵽe gaamme ni yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mbi gajaŋaul gujaŋ mamu bújoŋor bugan bugagu min mbi gujuh bakanerul báari mee, ban n’gusal Ᵽayul aamme fatiya mala bo. ");
INSERT INTO bqj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jambi jiᵽinor gaa búoh nijoulojow bi enemen gúboñ gagu gaa Móis, ter bi enemen Bahiĉer babu bal uboñer waw. Ijoulat bi enemen so, bare til bi ériren so. ");
INSERT INTO bqj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Maagen, ínje ilobul yo : émit ni ettam ᵽio min ᵽioe ᵽan sinemo, bare mele firim fafu fafaŋ me gatiti faa gúboñ gagu mati finemo. Hani may jimer ehiĉ go jice mati jinemo, ban dáuru bi no waf waw ᵽe ujae me ekano. ");
INSERT INTO bqj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","An ajae me ñer elat ékanum gúboñ gagu ᵽe, hani gafaŋ me n’gutitie, ban naligen bugan bugagu ekan mo may, an ahumu ᵽan áni an ahu afaŋ me gatiti ni Jávi jaju jaa fatiya ; bare an ajae me eroŋ ti gúboñ gagu gulob me aban naligen bugan bugagu ekan mo may, aĉila ᵽan áni an ámah ni Jávi jaju jaa fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Maagen, ínje ilobul yo : íni me juroŋut faŋ gaĉol úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay, mati júju junogen ni Jávi jaju jaa fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Juune wo gulob me sipayolal gufan búoh : “Jambi an amuh apalol ; an amuh me an, ᵽan ataliŋi.” ");
INSERT INTO bqj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bare ínje niegul : Anóan o fiiñol fitiñe apalol, ᵽan ataliŋi. An ajae me eoh apalol : “Gasoŋ ge,” an ahumu naaro ataliŋi bújoŋor fujoj ufan waw fámah fafu. An ajae me eoh apalol : “Aw ulet waf,” an ahumu naaro abeni ni sambun sábaerit. ");
INSERT INTO bqj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Iní me ñer nuŋare waf bi eke éji Aláemit ni gáviol, uĉih ró nuosen gaa búoh atii baje wo najogi ni fiiñ, ");
INSERT INTO bqj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","uhat to wo nuŋallo me bújoŋor tiñ talu to gújie me, min ᵽan umundum ujow úk’újamorul ni an ahumu, mbiban núkail ñer usen Aláemit gájii. ");
INSERT INTO bqj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Iní me jibajore ni an, usommen n’jiki juunor balama elobul éffus ni bataliŋ, gáholi jambi aŋari asen ataliŋa, min ataliŋa ahumu ábaheni asen akula-bugan ahu árur ni fipeh. ");
INSERT INTO bqj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Maagen, ínje ilobi yo : mat’úᵽurul dó ni fipeh fafu aw m’babanut ecam ganei bi n’efaraku ésola. ");
INSERT INTO bqj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Juune búoh Bahiĉer babu buoge : “Jamb’ufilen anaare o jíyavut.” ");
INSERT INTO bqj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bare ínje niegul : ánoan ajae me eluj anaare alet ola gúĉil gaa gamaŋ, natile aban ni biinumol gatil gaa gafilen aare ahumu. ");
INSERT INTO bqj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Iní me jíĉili jírib ban jiĉili min util, úloĉ jo ban nural jo jíralii. Hóimi úbbur jimer enili janur so n’eŋari múmei urali ni sambun sábaerit. ");
INSERT INTO bqj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iní me gañeni gárib ban guĉili min util, uᵽirih go ban nural go gúralii. Hóimi úbbur gálan enili ganur so n’eŋari múmei ubeni ni sambun sábaerit. ");
INSERT INTO bqj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bahiĉer babu buoge may : “An amaŋ me eham aarol, amundum ahiĉ gahait gal evis búyabo asenol.” ");
INSERT INTO bqj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bare ínje niegul : Anóan ajae me eham aarol, íni me let mala bujobuet náhamumol, nápegulolpegul ganegen gal etil gatil gaa búyabo ; ban ánaine ace ajae me eyabol, o ᵽoᵽ ᵽan atil gatil gaa búyabo. ");
INSERT INTO bqj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Juune ᵽoᵽ wo Bahiĉer babu bulob me sipayolal gufan buoh : “Jambi an áᵽuren gabbat gagu gola, bare akan wo nabbat me bújoŋor Aláemit.” ");
INSERT INTO bqj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bare ínje niegul : Jambi júmus jibbat ! Jambi jibbat ni gajow gal émit yay, mata dó efenjeŋ Aláemit yom yaa Jávi. ");
INSERT INTO bqj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jambi jibbat ni gajow gal ettam yay, mata yo eomme fírembenum fafu faa guolol. Jambi jibbat ni gajow gagu gaa Yérusalem, mata dáru ésuh yay yal Aláemit aamme ávi ahu ámah ahu. ");
INSERT INTO bqj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jambi an ni buru abbat gabbat gace, hani aya n’enilol, mata ájuut akan gal ganur ni fuhool n’gufinet ter n’guñuget. ");
INSERT INTO bqj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iní me bi eoh ey, juoh ey, íni bi eoh a-a, juoh a-a ; jitajen to me gabbat, ni Seytane gúᵽullo. ");
INSERT INTO bqj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Juune búoh Bahiĉer babu buoge : “Ufumom jíĉil, nifumi jíĉil ; ufalom fíŋiŋ, nifali fíŋiŋ.” ");
INSERT INTO bqj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bare ínje niegul : Jambi an akani maarat nulugen. An ategi me ni garab gárib, usenol may gamay gagu. ");
INSERT INTO bqj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iní me an namaŋe ájaenumi m’bataliŋ bi eŋar gájuoi, uhalol ᵽoᵽ min aŋar gaᵽalitoŋi. ");
INSERT INTO bqj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iní me an nakoñi min uteb bítebol n’jijaor simetar éuli, uteb bo n’jijaor faŋ to, hani bi simetar súuli súuba. ");
INSERT INTO bqj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","An ácini me waf, usenol ; ban an amaŋ me emag waf n’aw, jamb’úvuol búsol. ");
INSERT INTO bqj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Juune búoh Bahiĉer babu buoge : “Umaŋ apali, ban nulat alatori.” ");
INSERT INTO bqj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bare ínje niegul : Júbboli ulatorul, ban jilaw bi ni gálatieneul me. ");
INSERT INTO bqj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mamu ᵽan jigiten me búoh buru uñil jom bugaa Ᵽayul aamme fatiya. Aĉila o nah’akan me bunaaol m’búyaul ni bugan bugagu ᵽe, gálaj me ni gásum me, o nah’akan me ᵽoᵽ émit yay nelubul mala bugan bugagu gaĉol me ni ᵽoᵽ bugagu gaĉolut me. ");
INSERT INTO bqj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Maagen mamu, íni me ban jimaŋ gamaŋul me tíj to, bacam bay ᵽan jiyab to ? Let may uyaba-búalen bugagu mo nihi gukan ? ");
INSERT INTO bqj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ban íni me ban nihi jisaf gutiul bareil, wa ñer jikane walet útut ? Gáinenut me n’Aláemit let mo may nihi gukan ? ");
INSERT INTO bqj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jíni ñer bugan gaĉole maagen mamu ti Ᵽayul aamme fatiya aĉol me ! ");
INSERT INTO bqj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jíkanum jambi jikan bújoŋor bugan bugagu wo jikane me bi n’Aláemit, min mbi gujugul ; let mo, mati jiyab bacam n’aĉila Ᵽayul aamme fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yo eĉil me, no núᵽunne úji galeh me, jamb’uteh ébisa min uamben yo. Dáru bugan bugagu gatennoro me nihi gukan mee ni saŋ sasu saa galaw ni ulago waw, min mbi bugan bugagu gusalil. Maagen, ínje ilobul yo : bugan bugaubugi guyabe bacamil guban. ");
INSERT INTO bqj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bare aw til, úni me n’gáji galeh me, jambi gañeni gamay guffas wo gáribi guom n’ekan. ");
INSERT INTO bqj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mamu, gájii ᵽan gukani ni fubbuen dó ; ban Ᵽai Aláemit, ajuge me waf waw wakanei me ni fubbuen dó, ᵽan abbañeni wo. ");
INSERT INTO bqj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jíni me ni galaw, jambi jíni ti bugan bugagu gatennoro me : bugo gúni me n’galaw, nihi gulikeliken eilo gayoŋ ni saŋ sasu saa galaw ni ᵽoᵽ n’újalingenor ulago waw, min mbi bugan bugagu gujugil. Maagen, ínje ilobul yo : bugan bugaubugi guyabe bacamil guban. ");
INSERT INTO bqj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bare aw til, úni me n’galaw, nunogen ni futongi, nupeh ganegeni, uban nulaw dó Ᵽai Aláemit aam to me ni makoᵽei ; aĉila ajuge me waf waw wakanei me ni makoᵽe, ᵽan abbañeni wo. ");
INSERT INTO bqj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jíni me n’galaw, jambi julob meŋ gurim gabajut nafa, ti bugagu gaffasut me mala Aláemit : bugo nihi guᵽinoᵽinor búoh gulob me meŋ, Aláemit nayab galaw gagu golil. ");
INSERT INTO bqj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jambi jíni ti bugo ! Ᵽayul naᵽie naffas wo jusohola me balama buru jícinol wo. ");
INSERT INTO bqj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Maa jíari me jilaw : « Ᵽayóli aamme fatiya, Gajai gumaleni, ");
INSERT INTO bqj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jávi jaju jíya jújoul ! Mbi wo numaŋ me ubaj n’ettam ti fatiya ! ");
INSERT INTO bqj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Usenóli jama mitiñ mamu maa funah faufe. ");
INSERT INTO bqj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Uboketóli utilóli ti may wóli jubokete me gatile me ni wóli, ");
INSERT INTO bqj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ban jamb’uhalóli n’julo ni gabut, bare uᵽagenóli ni maarat mánoman ; mata aw uĉile Jávi, sembe ni gasal bi nánonan. Amen ! » ");
INSERT INTO bqj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Iní me jubokete gupalul utilil, Ᵽayul aamme fatiya ᵽan may aboketul wolul. ");
INSERT INTO bqj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bare íni me juboketutil wo, Ᵽayul may mat’aboketul wolul. ");
INSERT INTO bqj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jíni me ni baor, jambi juñol uulul ti bugagu gatennoro me gukane me : bugo ᵽan gujoh uulil guñol bi egiten bugan bugagu búoh bugo baor guom ni bo. Maagen, ínje ilobul yo : bugan bugaubugi guyabe bacamil guban. ");
INSERT INTO bqj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bare aw til, úni me m’baor, uᵽos buuli ban nucokor fuhoi wári ti nuᵽi me nuh’ukan. ");
INSERT INTO bqj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mamu bugan bugagu mati gútallo búoh baor nuom ni bo, bare Ᵽai Aláemit aam to me n’aw, o, ᵽan átallo yo ; ban aĉila ajuge me waf waw wakanei me ni makoᵽe, ᵽan abbañeni wo. ");
INSERT INTO bqj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jambi jiŋes eomen gubaj bi ni buru babe ni mof, bo balol ni bisem nihi sihajen go me, bo ᵽoᵽ úku waw nihi gúñag me silajen bi gákuet. ");
INSERT INTO bqj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bare til, juomen gubaj fatiya n’émit, dó balol ter bisem ndi sihajen go me, dó úku waw ndi gúju me gunogen bi gákuet. ");
INSERT INTO bqj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jiffas búoh : to fubajul fuomme, uinumul ᵽoᵽ uwu to. ");
INSERT INTO bqj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Gúĉil go guomme ejaŋa yay yal enil. Iní me ugu apuñ go, enili ᵽooyo ᵽan éni ni maŋannoe ; ");
INSERT INTO bqj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","bare gúĉili gulet me apuñ go, enili ᵽooyo ᵽan éni n’emoĉ. Iní me ñer nuᵽinore búoh ni gajaŋa nom ban gajaŋa gaugu n’gúni emoĉ, mo emoĉ yauyu ejae éjalo ! ");
INSERT INTO bqj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","An ájuut áni aroka ala ufan gúuba ni manur ; mata ᵽan alat anur min amaŋ ahu, ᵽan ákanum anur min aĉotihen ahuo. Jújuut jimigelet mimanur Aláemit ni Síralam. ");
INSERT INTO bqj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yo eĉil me niegul : jambi jiĉagor mala wo jusohola me bi buroŋul, waamme fitiñul ni maremul. Jambi jiĉagor ᵽoᵽ mala sinilul, yaamme maa bisimoul. Buroŋ bufaŋut ᵽiaŋ mitiñay ? Enil efaŋut bisimo ? ");
INSERT INTO bqj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Juluj upu waw : nd’uroh, nd’uᵽit, nd’uomen waf ubaŋ ni újej, bare til Ᵽayul aamme fatiya nákumenewokumen. Jifaŋut wo ᵽiaŋ ebaj nafa bújoŋorol ? ");
INSERT INTO bqj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ay ni buru gaĉagorol gújue gutajen gaᵽio buroŋol hani jatiito ? ");
INSERT INTO bqj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wa uĉile may n’jiĉagor mala bisimo ? Juluj mafos mamu maa siŋam sasu bu nihi muya me ! Ndi mirien, ndi mieĉ bisimo, ");
INSERT INTO bqj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","bare ínje ilobul yo : Hani ávi ahu Salomoŋ faŋaol, mánoman fubajol fújaloe, ámusut abaj bisimo búari iki bire ni bayaer baa gace ni mafos maumu ! ");
INSERT INTO bqj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iní me Aláemit násangene wári re mamu mafos mamu maa siŋam sasu maroŋ me jama, ban gajem ᵽan mibeni ni sambun, bu ñer mat’afaŋ me nasime wári buru, bugan ge bugo gáinenil gutogut mee ? ");
INSERT INTO bqj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kan jambi ñer jiĉagor juoh : “Wa ᵽan utiñal ? Wa ᵽan uremal ? Wa ᵽan usimoal ?” ");
INSERT INTO bqj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dáru gabajut me gáinen n’Aláemit nihi guliᵽ mee waf wauwu m’báelout. Ᵽayul aamme fatiya naffase búoh buru jusoholawosohola ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jumundum jiŋes Jávi Aláemit ban ni juroŋ ti namaŋ me, mamu ᵽan atañul wajae bo me eŋaño. ");
INSERT INTO bqj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kan ñer jambi jiĉagor mala gajem, mata gajem yo faŋayo ᵽan eĉagororo. Funah fánofan ni sílam fo. ");
INSERT INTO bqj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jambi jujogoro utaliŋa bugan, mamu may Aláemit mat’ataliŋul. ");
INSERT INTO bqj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Min jijae me etaliŋ bugan bugagu, mo may najaeul me etaliŋ ; galigum gagu go jijae me eŋar n’jiligil, go may ᵽan aligumul me ni go. ");
INSERT INTO bqj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wa uĉile núni n’eluj jikaw jaju jalo me n’jíĉil atii, ban aw fusos ni fíni n’jíya ? ");
INSERT INTO bqj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bu nújue uoh atii : “Unah níᵽunni jikaw jaju jaamme n’jíĉili !” Aw m’bátallout fusos fafu faamme n’jíya ? ");
INSERT INTO bqj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Aᵽula-elob e, umundum ᵽan úᵽuren fusos fafu faamme n’jíĉili, mamu ᵽan ujuh ŋanno bi éᵽuren jikaw jaju jaamme n’jíĉil atii. ");
INSERT INTO bqj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jambi jisen bugan bugagu gáni me ti sujoba waf wanabe jambi gúbbañul gukanul maarat ; jambi jiŋar banugul jisen bugan bugagu gáni me ti suhumba jambi guhah bo. ");
INSERT INTO bqj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jícin Aláemit, ban ᵽan asenul. Jiŋes, ban ᵽan jujuh. Jiteh ganegen gagu, ban Aláemit ᵽan ápegulul. ");
INSERT INTO bqj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maagen, ánoan ácin me, ᵽan ayab ; ánoan aŋes me, ᵽan ajuh ; ánoan ateh me ganegen, Aláemit ᵽan ápegulol. ");
INSERT INTO bqj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ay ni buru ajae esen añolol eval o bácinerol mitiñ ? ");
INSERT INTO bqj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ter eno juol nácinol, ᵽan ᵽiaŋ asenol enuhunjaŋ ? ");
INSERT INTO bqj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eno ñer buru jaarat me jújue esen guñolul waf waaro, bu ñer Ᵽayul aamme fatiya mat’afaŋ me nasene waf waaro bugan bugagu galaeol wo me ? ");
INSERT INTO bqj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Waf waw ᵽe wo jimaŋ me bugan bugagu gukan bi ni buru, buru ᵽoᵽ jikan wo may bi ni bugo ; dóemme wo gúboñ gagu gaa Móis ni uboñer waw gulob me. ");
INSERT INTO bqj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Junogen ni gánonum gagu gagog me ! Gánonum gagu ni bulago babu sauŋ me so nihi síjaenum mbal eĉet, ban bugan gammeŋe ni so gújoume. ");
INSERT INTO bqj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bare gánonum gagu go nihi gújaenum me mbaa buroŋ guuŋut, bulago babu ᵽoᵽ bo nihi bújaenum me mbaa buroŋ bimimis ; gajuh bo me ban ni gujow ró gummeŋut. ");
INSERT INTO bqj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jíkanum uboñer waw galet me bugaa maagen ! Ᵽan gújoul mbaa buru gububi ti ubbarum, bare ñáraruil sujoba-baha sujoga gom. ");
INSERT INTO bqj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bakaneril ᵽan biĉilul me min jiffasil. Gueĉ gújue ᵽiaŋ gutulli ni bindikit, ter gumangu n’gutulli ni bukoho ? ");
INSERT INTO bqj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bununuh bánoban baaro nihi bububuh mitiñ maaro, bare baarat me, bo, mitiñ maarat nihi bubuh. ");
INSERT INTO bqj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bununuh baaro bújuut bubuh mitiñ maarat, ti may bununuh baarat bújuut me bubuh mitiñ maaro. ");
INSERT INTO bqj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bununuh bánoban babugut mitiñ maaro ᵽan biᵽiki bibeni ni sambun. ");
INSERT INTO bqj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kan ñer ni bakaneril jijae me effas uboñer waw. ");
INSERT INTO bqj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Let bugan bugagu ᵽe gavogeom me “Ataw, Ataw” gujae enogen ni Jávi jaju jal Aláemit, bare ubugi bareil gakane me wo Ᵽayom aamme fatiya amaŋ me. ");
INSERT INTO bqj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Funah fafu faa bataliŋ babu, gammeŋe ᵽan guogom : “Ataw, Ataw, let ni gajai wóli jivaree ? Let ni gajai wóli jihame siseytane sasu ? Let ᵽoᵽ ni gajai wóli jikane waf wajureruti wammeŋe ?” ");
INSERT INTO bqj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ñer ᵽan iogil : “Injé ímusut iffasul. Júᵽur tale jíraliom, buru jákanumut me Aláemit !” ");
INSERT INTO bqj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Mamu ñer ánoan auttene gurim gauge go nilob maa ban nakan wo gulob me, an ahumu ᵽan áni ti an atuhoe ateᵽe yaŋol tiñ taake kaŋ. ");
INSERT INTO bqj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Emít nelub mal mámah mitey murandañor, fúrus fámah ni fiteh ni yaŋ yay, bare mánoman elout mata gúĉit yo gubaŋibaŋ tiñ taake kaŋ. ");
INSERT INTO bqj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bare ánoan auttene gurimom mb’aban akanut ti nilob me, ᵽan áni ti an águnoe ateᵽe yaŋol ni eus. ");
INSERT INTO bqj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Emít nelub mal mámah mitey murandañor, fúrus fámah ni fiteh ni yaŋ yay, ñer nelo efumo ᵽooyo. » ");
INSERT INTO bqj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","No Yésu alob me gurim gaugu aban, fítiman fafu ni fujahali faŋ baligener baubu bola, ");
INSERT INTO bqj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mata naligeneligen ti an ayabe sembe, búli ni wo úᵽajula gúboñ Aláemit bugagu bugolil nihi guligen me. ");
INSERT INTO bqj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","No Yésu aavulo me n’erijaŋ yay, fítiman fámah ni fulagenol. ");
INSERT INTO bqj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ni baj ánaine o háhae ejoge ájoul aĉigul náñuᵽ to bújoŋorol naagol : « Ataw, umaŋ me, nújue ukanom nihoy ijañ ti no ! » ");
INSERT INTO bqj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ñer Yésu naalen gañenol agorol ban naagol : « Yoo nimaŋe. Uhoy ujañ ! » To baenah háhae yay néᵽur n’áine ahu min ahoy. ");
INSERT INTO bqj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mbiban Yésu naagol : « Uutten jon : jamb’ulob yo me ánoan, bare ujow iki ateŋena ajugi, ban mb’ukan bíteŋen babu bo gúboñ gagu gaa Móis gulob me, min ugiten ésuh yay búoh nuhohoy. » ");
INSERT INTO bqj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","No Yésu áfaro me bulagool ák’áni n’enogen Kaᵽerinaum, ni baj afan ekosombil ace ala Rom ájoul ak’atogol nalaol n’efotenor dó ");
INSERT INTO bqj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aah : « Ataw, amigelom umu súndo nafiye, guot gulet ban umu ni sílam faŋ. » ");
INSERT INTO bqj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yésu naagol : « Ᵽan ijow bi bo ik’isenol gahoy. » ");
INSERT INTO bqj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Afan ekosombil yay naagol : « Ataw, iᵽilout min mb’unogen ni yaŋom. Bare ulob firim fanur pat, ban amigelom ᵽan ahoy. ");
INSERT INTO bqj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nuffase, ínje faŋaom nibaje ufanom bugo níh’íttun, ti ᵽoᵽ ekosombil yay gaamme ni gañenom gúttuneom me. Ioh me an ni bugo : “Ujow !” Najow ; ioh me ᵽoᵽ ahu : “Ujóul !” Nájoul ; ioh me arokaom : “Ukan waf uman !” Nakan wo. » ");
INSERT INTO bqj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","No Yésu aunol me alob gurim gaugu, ni súmol nár. Naah bugan bugagu galageneol me : « Maagen, ínje ilobul yo : ni bugal Israel ᵽooil ímusut ijuh ró an o gáinenol gújaloe ti gal áine ahume. ");
INSERT INTO bqj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Injé ilobul yo : bugan gammeŋe ᵽan gúᵽurul n’ulam waw ᵽe waa mof íkiil gutiñor tiñ tanur ni Aburaham, Isak ni Sakob dó ni Jávi jaju jaa fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bare guñol Jávi jaju gañumen me enogen dó ᵽan gubeni tíyaŋ n’emoĉ yay, bo baj me ukoŋ ni ejoh émiremma. » ");
INSERT INTO bqj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mbiban, Yésu naah afan ekosombil yay : « Ujow, mbi wo nulaw me ukano mala gáineni. » Ban may ni tinah tautu tanur tatu, amigel ahu nahoy. ");
INSERT INTO bqj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ᵽúrto, Yésu najow bi yaŋ Ᵽier. No naĉih ró me, natoh aol Ᵽier aarema bújusa bibelol. ");
INSERT INTO bqj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yésu nagorol ni gañen, ban to baenah bújusa babu ni búᵽur ni o, min ñer aare ahu anamo ecokorol. ");
INSERT INTO bqj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mb’uĉiga gállim, n’gúŋarul Yésu bugan gammeŋe bugo siseytane sunone. Naŋar butumol naham siseytane sasu, ban nasen gahoy úsotaaw ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mamu, firim fafu fo aboñer ahu Esai aᵽi me nalob ni fukano faah me : « Naŋare buhajolal, ban natebe úsomulolal akundo. » ");
INSERT INTO bqj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","No Yésu ajuh me fítiman fafu fágoleol me fúharo, naah ulagorol : « Utíᵽal fal fafu uloal ñagagu. » ");
INSERT INTO bqj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bugo n’ejow mbaa busana babu, ni baj áᵽajula gúboñ Aláemit ace alofulol naagol : « Aligenaom, tánotan to nujae ᵽan ilageni bi to. » ");
INSERT INTO bqj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yésu naagol : « Usikin waw ubaje usun wo, upu waw ᵽoᵽ ubaje ulef wo, bare Añol Arafuhow aĉila abajut tiñ taa gáelo. » ");
INSERT INTO bqj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mbiban, ace ni galagenol me naah Yésu : « Ataw, uboket újiom min imundum ijow ik’ifoh ᵽayom, mbiban níjoul ilageni. » ");
INSERT INTO bqj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bare Yésu naagol : « Ujóul ulagenom min uhat gaĉet me n’gufoh buganil gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ᵽúrto, Yésu nák’ájuᵽo ni busana babu, ulagorol n’gulagenol. ");
INSERT INTO bqj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","No gukay me ᵽiout, fúrus fámah ni fiiyulil ; fal fafu ni fiteh iki gulongos gagu gumaŋ emmeŋen busana babu. Bare Yésu, o, náni n’gámori. ");
INSERT INTO bqj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ulagoraaw n’gulofulol ban n’gúliol n’éᵽib ró guoh : « Ataw, ukan min uᵽagal ! Wolal ubugi n’gabao ! » ");
INSERT INTO bqj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naagil : « Mo gáinenul gutitie ! Wa uĉile n’júholi re me ? » Ñer nailo nannur fúrus fafu ni fal fafu, ban to baenah ni síjebi yem. ");
INSERT INTO bqj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gajahali gámah n’gunogenil, bireg nihi gurorenoro guoh : « An bu om umu, iki fúrus fafu ni fal fafu síkanumol ? » ");
INSERT INTO bqj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","No Yésu aya me ñagagu fal fafu, ni mof mamu mo guvoge me Gadara, najuh wáine gúuba bugo siseytane sunone gúteil mbal aĉila. Ni guyah guĉine, ban gúlaᵽulaᵽut bireg an abbañut akañen ajow n’ulam wauwu. ");
INSERT INTO bqj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wáineaw ubuge n’gunamo éᵽib fatiya n’guoh Yésu : « Añol Aláemit, wa numaŋe ni wóli ? Nujoulojow ᵽiaŋ bi ekelóli élamen tinah talu m’baĉigerut ? » ");
INSERT INTO bqj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ban bajene n’ulam wauwu ekore yámah yaa suhumba saam bo n’gafen. ");
INSERT INTO bqj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñer siseytane sasu ni sufotenor suoh Yésu : « Iní me ban uhamóli, nuboket uhalóli n’jiki junogen ekore suhumba sausua. » ");
INSERT INTO bqj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naah so : « Yoo, jujow ! » To baenah, siseytane sasu ni súᵽur sujow iki sunogen suhumba sasu. Ñer ekore yay ᵽe néᵽaᵽoul dó fitey fatiya mavaŋoe mamu eriŋoul bi ni fal fafu iki enemo ró ni mal mamu ᵽooyo. ");
INSERT INTO bqj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ñer bugan bugagu gakoñe me suhumba sasu n’gutey gukay bi n’ésuh yay iki gugiten bo elob yay ᵽe yabaj me bi ni wabaj me bugo siseytane sasu sunogenen me ró. ");
INSERT INTO bqj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ñer bugal ésuh yay ᵽe n’gúᵽurul íkiil guemor ni Yésu ; no gujugol me, n’gulaol aboket áᵽur ahat mofil. ");
INSERT INTO bqj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ñer Yésu nájuᵽo ni busana, aban nápino fal fafu fáᵽurut me faa Gálile ajow bi n’ésugol. ");
INSERT INTO bqj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","No naĉih me, ni baj bugan gútebul an abofoe afiloe ni gapeh. No Yésu ajuh me gáinenil, naah abofoa ahu : « Añúm, uaken, utili uboketiboket ! » ");
INSERT INTO bqj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ñer úᵽajula gúboñ Aláemit guce gaamen to no guun me gurim gaugu, n’guogoro : « Aíne ahumu gújel Aláemit naam ni go. » ");
INSERT INTO bqj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yésu affas me gaᵽinoril naagil : « Wa uĉile n’jibaj uᵽinor wauwu waarat mee ? ");
INSERT INTO bqj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Julobom ᵽaa, eoh abofoa ahu “Utili uboketiboket” Ter eogol “Uilo ujow,” wa ufaŋe ésum elob ? ");
INSERT INTO bqj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ban waf wanur nimaŋe jiffas : Añol Arafuhow nayayab babe ni mof sembe n’Aláemit sal eboket util bugan bugagu. » Náfaro aah abofoa ahu : « Uilo nuŋar gapegi min uot bi yaŋi. » ");
INSERT INTO bqj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ñer abofoa ahu nailo, aban naot. ");
INSERT INTO bqj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","No fítiman fafu fujuh me waf wauwu, gáholi n’gunonil ban n’gunamo esalen Aláemit asen mee bugan bugagu sembe sausu. ");
INSERT INTO bqj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yésu náᵽur to ajow, ban o n’égat najuh ace áine gajaol Mácie arobo to nah’ayab me búalen. Naagol : « Ulagenom. » Ñer Mácie naiyul alagenol. ");
INSERT INTO bqj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ᵽúrto, Yésu náni ni fitiñ n’ende Mácie ; uyaba-búalen gammeŋe ni bugan guce bugo ujail uhajene n’gújoul iki gurobo to manur ni o ni ulagorol. ");
INSERT INTO bqj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","No Eᵽárisie yay gujuh me dáuru, n’guoh ulagorol : « Wa uĉile afanul natiñor n’uyaba-búalen bugagu ni bugagu utila ? » ");
INSERT INTO bqj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yésu naunil, ban naagil : « Let bugan bugagu gaamme apuñil guŋese ásotena, bare til úsotaaw. ");
INSERT INTO bqj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jujow iki jiŋes min jiffas wo gurim gauge gulobe go Aláemit alob maa aah : “Jibaj ñarum enil, dáuru nimaŋe, let úsimen waa sihaj.” Ijoulat bi evoh bugan bugagu gaĉol me, bare til utilaaw. » ");
INSERT INTO bqj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ᵽúrto, ulagora Saaŋ Batis guce n’gújoul íkiil gutoh Yésu n’guogol : « Wóli ni Eᵽárisie yay juorewor. Wa uĉile ñer ulagorai bugo mati guor ? » ");
INSERT INTO bqj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yésu naagil : « Jíinene ᵽiaŋ búoh, funah faa búyabo, ubuge ayaba ahu gújue gúgogor aĉila baamer to ni bugo ? Hani, júut ní me ! Bare funah fice ᵽan fiĉigul no gujae me eram ayaba ahu n’guñenil ; no ñer ᵽan guor me. ");
INSERT INTO bqj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","An nd’aŋar gaĉaĉ gavugul gal épis ateh gaᵽoroh ni bisimo bufan ; akan mo me, gaĉaĉ gagu gavugul gagu ᵽan gunoĉul gafan gagu min til ñer élu yay efaŋ gauŋ. ");
INSERT INTO bqj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","An nd’aoren ᵽoᵽ bunuh bijeb ni siĉan sifan aban natoj so ; akan mo me, bunuh babu ᵽan bufaĉ so min ñer bivisor, ban siĉan sasu ni súbburi. Bare til níh’íni mee nuoren bunuh babu bijeb babu ni siĉan sasu suvugul sasu, mamu, so ᵽooso mati súbburi. » ");
INSERT INTO bqj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yésu m’babanerut elobil gurim gaugu, ni baj afan Esúif ace aĉigul ; náñuᵽ bújoŋor Yésu naagol : « Afanom, bájurom maer naĉele mee ᵽiout. Bare újoul urembenol gañeni, ban ᵽan abbañ aroŋ. » ");
INSERT INTO bqj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ñer Yésu nailo, aban o ni ulagorol n’gulagen áine ahu. ");
INSERT INTO bqj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Bajene may ace aare ásomute gásomut gal ébbur físim kábiriŋ símit guñen ni súuba. Nah’aah m’biinumol : « Ijúen me igor bare bisimool, ᵽan ihoy. » Ñer nabbuyul búsol Yésu aĉigul nagor gáñin bisimool. ");
INSERT INTO bqj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yésu najegor, ban no najugol me, naagol : « Bájurom, jamb’úholi ! Gáineni guĉili nuhoy. » Ban aare ahu nahoy to baenah. ");
INSERT INTO bqj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","No Yésu aĉih me yaŋ afan Esúif yay, ban najuh uoga sutongole bugagu ni fítiman fafu faliliore mee n’efam ró, naagil : ");
INSERT INTO bqj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","« Júᵽur dáre ! Bájur babu aĉelut, námorimori bare. » N’gunamo éfohulol. ");
INSERT INTO bqj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","No guham me bugan bugagu gúᵽuren tíyaŋ guban, Yésu nanogen ni futoŋ fafu, aĉih najoh bájur babu ni gañen, ban m’biilo. ");
INSERT INTO bqj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ñer elob yay neuno eban babu ᵽe ni mof maumu ᵽoomo. ");
INSERT INTO bqj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","No Yésu aamme n’ekay, ni baj úpima gúuba gulagenol n’eoh nímoro fatiya : « Añol David, enili erumóli ! » ");
INSERT INTO bqj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","No naĉih me ni yaŋ yay dó naalen me, úpimaaw n’gulofol. Narorenil aah : « Jíinene búoh nibaje sembe sausu sal ekan wo jilaeom me ? » N’guogol : « Ey, Ataw, wóli jíinene. » ");
INSERT INTO bqj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ñer nagor gúĉilil aban naagil : « Mbi wo jimaŋ me ukano mala gáinenul. » ");
INSERT INTO bqj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","To baenah, gúĉilil n’guhoy ban ni gujuh. Ñer Yésu naĉafil naagil : « Jambi an affas yo me ! » ");
INSERT INTO bqj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bare bugo n’eju éᵽur, n’gufaen guamben ni mofil ᵽoomo wo Yésu akan me. ");
INSERT INTO bqj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No wáineaw gápimen me gukay me ᵽiout, bugal ésuh yay n’gúŋarul Yésu ace áine akane émumune mata eseytane eom ni o. ");
INSERT INTO bqj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yésu naham eseytane yay, ban to baenah áine ahu nanamo elob. Ñer fítiman fafu ni fujahali bireg nihi fíᵽib fatiya fuoh : « An ámusut ajuh waf ti wauwe dáre Israel ! » ");
INSERT INTO bqj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bare Eᵽárisie yay bugo nihi guoh : « Ujuh me náju aham siseytane sasu, mata firimil fanur o ni afan so. » ");
INSERT INTO bqj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yésu nailo ajow súsuh sasu ᵽooso, bi ni saa m’baha ró, nah’aligen bugan bugagu ni saŋ sasu saa galaw, navare Firim fafu Fásum me faa Jávi Aláemit, ban ᵽoᵽ nah’asen gahoy úsotaaw ni gahaj me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","No najuh me gútiman gagu gajoulo me mbal aĉila, enilol nerumil, mata najuge búoh guyoyoh iki gúdeum, ban gujundenijunden may ti ubbarum wabajut akoña. ");
INSERT INTO bqj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ñer naah ulagorol : « Eᵽit yay yo jijae me éjalojalo, bare uᵽilaaw gummeŋut. ");
INSERT INTO bqj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jícin ñer aĉil me eᵽit yay min áboñul uᵽila gatoge bi eᵽilol. » ");
INSERT INTO bqj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ᵽúrto, Yésu navoh ulagorol gaamme guñen ni gúuba, aban nasenil sembe sasu sal eham siseytane sasu ni esen gahoy gaa gásomut gánogan ni gaa buhaj bánoban. ");
INSERT INTO bqj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bugo guomme ubuge : Simoŋ o guvoge me may Ᵽier ni atiol Andere ; Saak ni atiol Saaŋ, guñol Sebede ; ");
INSERT INTO bqj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fílip ni Barutelemi ; Toma ni ayaba-búalen ahu Mácie ; Saak, añol Alife, ni Tade ; ");
INSERT INTO bqj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ atigena ahu ni Yudas Isikariot ajae me ennomen Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yésu naboñ uᵽotoraaw ubuge gaamme guñen ni gúuba naagil : « Jambi jujow me mbaa galet me Esúif, ban jambi junogen me ni súsuh sasu saa bugaa Samari ; ");
INSERT INTO bqj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","bare til jujow mbaa bugal Israel, gáni mee ti ubbarum wallilim. ");
INSERT INTO bqj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Buru n’ejow yay, mbi jivare juoh : “Jávi jaju jaa fatiya julofulo.” ");
INSERT INTO bqj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jisen gahoy úsotaaw, jiilen bugagu gaĉet me, jisen gajañ bugo háhae ejoh me, jiham siseytane sasu. Nemme jiyayab m’bacamut wáfowaf, jisen may m’barorenut bacam bánoban. ");
INSERT INTO bqj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jíni me n’ejow, jambi jiŋar síralam sánosan. ");
INSERT INTO bqj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jambi jíjaenum may ter baet, ter bisimo búutten, ter sidala sice ; jambi jíjaenum may egol. Aroka ánoan naote ayab fitiñol. ");
INSERT INTO bqj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","No jijae me eĉih ni ésuh yaa baha ter ni ésuh élulumay, jiliᵽ an ájue aalenul min jurobo súndool bi no jijae me éᵽur to jikay. ");
INSERT INTO bqj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","No juom n’enogen ni yaŋ, jumundum juoh gaĉin dó me : “Gásumay gúni ni buru !” ");
INSERT INTO bqj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Eno me bugaa yaŋ yay gualenul, mbi gásumay gagu golul gúni ni bugo ; mb’íni me gualenutul, gásumay gagu golul gúbbañul bi ni buru. ");
INSERT INTO bqj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No gulale eannul n’gulat eutten gurimul, júᵽur tiñ tautu n’eᵽaᵽ gulaul. ");
INSERT INTO bqj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Maagen, ínje ilobul yo : Funah fafu fo Aláemit ajae me etaliŋ bugan bugagu, bataliŋerol bugaa súsuh sasu saa Sodom ni Gomora ᵽan buhoy baa bugal ésuh yay eĉila. » ");
INSERT INTO bqj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","« Ban ilobul waf wanur : ínje umu n’eboñul ti ubbarum n’etut sujoba-baha. Mbi jijengulo ti sunuhunjaŋ, ban n’jububi ti úlab. ");
INSERT INTO bqj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jambi jifium bugan bugagu, mata bugo gujaul me ebet ni bataliŋ, ban ᵽan gutegul gusoh gal ubaŋ ni saŋ sasu saa galaw. ");
INSERT INTO bqj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gajaom ᵽan guĉil min gújaenumul bújoŋor ufan súsuh ni úviaw, dó ᵽe min mbi bugo ni ᵽoᵽ bugaa súsuh sasu ᵽe guun bagitenerul. ");
INSERT INTO bqj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","No gujae me éjaenumul bújoŋor ufan waw, jambi sinilul siteh mala bu jijae me ébal ter wo juñum me elob ; tinah talu tiĉila ᵽan jiyab me wo juot me julob. ");
INSERT INTO bqj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","No ñer let buru faŋaul jijae elob, bare Biinum babu baa Ᵽayul bo ᵽan bulob n’utumul. ");
INSERT INTO bqj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ni tinah tautu, an ᵽan abet atiol n’eĉet, ᵽaaya ᵽan abet añolol n’eĉet, uñil ᵽan guiyul bi n’ubugail min gukanil n’guĉet. ");
INSERT INTO bqj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gajaom ᵽan guĉil min bugan bugagu ᵽe gulalul ; bare an ajae me emuten iki bao, Aláemit ᵽan aᵽagenol. ");
INSERT INTO bqj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gúlatienul me n’ésuh, jitey bi n’ece. Maagen, ínje ilobul yo : ᵽan jujow súsuh sasu ᵽe sal Israel bi no Añol Arafuhow ajae me ébbañul. ");
INSERT INTO bqj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Bajut aligena afaŋe afanol aligeneol me ; bajut ᵽoᵽ aroka afaŋe afanol. ");
INSERT INTO bqj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yoemme ᵽiaŋ, aligena ahu ábbañul aongor ere ni afanol, ni may aroka ahu ábbañul aongor ere ni afanol. Eno guvoge afan fiil fafu Belisebul (yoemme afan siseytane sasu), bu ñer mati gujel may bugaa fiilol ? » ");
INSERT INTO bqj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","« Yo eĉil me niegul jambi júholi bugan bugaubugu. Bajut uce wakoᵽeni wañumuti éᵽuren ni maŋannoe, ter uce waffasuti wañumuti effas. ");
INSERT INTO bqj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wo nilobul me n’emoĉ, julob wo ni maŋannoe ca ; wo nibunul me, jigiten wo ésuh yay fatiya ni fuhay. ");
INSERT INTO bqj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jambi júholi bugagu ganemene me enil ban gújuut enemen yaalor, bare til júholi Aláemit, áju me anemen ni manur enil ni yaalor ni sambun sasu safogoérit me. ");
INSERT INTO bqj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Leti mutaja múuba éralam yanur munome ? Bare bajut janur ni mo jo mbi jiĉet Ᵽayul m’bamaŋut. ");
INSERT INTO bqj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hani wal waw waa guhoul naffase butumbu uree. ");
INSERT INTO bqj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yo niegeul jambi júholi : hani fuyoŋ faa bataja, jifaŋfofaŋ ! ");
INSERT INTO bqj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","An ailo me ni fuhay min aah bújoŋor bugan bugagu : “Yésu aĉilom,” ínje may ᵽan ilob mola bújoŋor Ᵽayom aamme fatiya ioh : “An ahumu ínje iĉilol.” ");
INSERT INTO bqj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bare ánoan ajae me elalom bújoŋor bugan bugagu, ínje may ᵽan ilalol bújoŋor Ᵽayom aamme fatiya. » ");
INSERT INTO bqj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","« Jambi jiᵽinor gaa búoh nijoulojow bi éŋarul gásumay ni mof ; ijoulat bi éŋarul gásumay, bare til gafoje. ");
INSERT INTO bqj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nijoulojow bi éŋarul búfaculor tutor áᵽur ni ᵽayol, bájur ni jaol, ásabul ni asomol. ");
INSERT INTO bqj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Maagen búlator ᵽan bubaj tutor an ni bugaa súndool. ");
INSERT INTO bqj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","An amaŋ me ᵽayol ter jaol iki faŋ ínje, an ahumu aᵽilout éni úmbam ; an ᵽoᵽ amaŋ me áᵽurol ter bájurol iki faŋ ínje, an ahumu aᵽilout éni úmbam. ");
INSERT INTO bqj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","An atebut me ekurua yay yaa sílamol min alagenom, an ahumu aᵽilout éni úmbam. ");
INSERT INTO bqj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","An ajoh me buroŋol guñen gúuba ᵽan ábbur bo, ban an ábbur me buroŋol múmbam, ᵽan abaj buroŋ babu bábaerit me. » ");
INSERT INTO bqj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","« An aalenul me, ínje naalene, ban an aalenom me, an ahu aboñulom me naalene. ");
INSERT INTO bqj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","An aalen me aboñer Aláemit mala min aamme aboñer, ᵽan ayab bacam babu bo nihi gusen me aboñer ; ban an aalen me an aĉole mala maĉoleol, an ahumu ᵽan ayab bacam babu bo nihi gusen me an aĉole. ");
INSERT INTO bqj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Maagen, ínje ilobul yo : an ajae me esen hani gago ganur gaa mal májebijebi anur ni bugagu gatiti me ni ulagorom mata búoh alagorom nam, an ahumu mát’ábbur bacamol. » ");
INSERT INTO bqj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","No Yésu aban me egiten ulagorol gaamme guñen ni gúuba gurim gaugu, náᵽur to naamen me min ajow ake eligen bugan bugagu Firim fafu Fásum me, nah’avare fo ni súsuh sasu solil. ");
INSERT INTO bqj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ni tinah tautu, Saaŋ Batis o baamer ni fipeh ; no naun me wo Kirista akane me, náboñul ulagorol guce ");
INSERT INTO bqj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","íkiil guroren Yésu guogol : « Aw uomme an ahu aot me ájoul, ter juote jiirigen ace ábulo ? » ");
INSERT INTO bqj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yésu naagil : « Jibbañ iki jigiten Saaŋ wo juune me ni wo jujuge me : ");
INSERT INTO bqj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","gápim me gubbañe gujuh, gahaj me gujae ĉol, bugaa háhae yay guyabe gahoy, gatopo me gútopuloe, gaĉet me guiloe gubbañ guroŋ, gásugateno me guyabe Firim fafu Fásum me fal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Gásumay gúni ni an ahu o bakanerom biĉilut me min ahabo gáinen gagu gola n’ínje ! » ");
INSERT INTO bqj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","No ulagora Saaŋ Batis gukay me, Yésu nanamo egiten fítiman fafu maa Saaŋ ahumu aah : « Wa jikaene faluj baubu n’eᵽarandaŋ yay ? Fisisit ᵽiaŋ fo érus yay élisene ? ");
INSERT INTO bqj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wa ñer jikaen bo faluj ? Anáine ᵽiaŋ asimoe wañ ujaha ? Bare hum gasimoe me wañ ujaha ni saŋ úviaw gom ! ");
INSERT INTO bqj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ñer joon wa jikaen bo bujuh ? Aboñer ᵽiaŋ ? Ey, aĉila, ban ínje ilobul yo, fafaŋ sah aboñer. ");
INSERT INTO bqj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","O aamme an ahu o Bahiĉer Aláemit bulob me mola buoh : “Ᵽan iboñ ájaenumaom gahoŋen ayabi gayoŋ min mb’ateŋen bulago babu bi n’aw.” » ");
INSERT INTO bqj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yésu natajen aagil : « Maagen, ínje ilobul yo : ni bugan bugagu ᵽe gabugi me babe ni mof, Saaŋ Batis afaŋil me ᵽe. Bare afaŋ me gatiti ni Jávi jaju jaa fatiya, o nafaŋe Saaŋ fúf. ");
INSERT INTO bqj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kábiriŋ gannay gagu go Saaŋ áᵽullo me bi funah faa jama, Jávi jaju jaa fatiya uju n’ejow gayoŋ ni bútaj ró, ban bugan bugaa sembe n’gúni jo n’eram. ");
INSERT INTO bqj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sílebur sasu sal uboñer waw ni ᵽoᵽ gúboñ gagu gaa Móis, so ᵽe sulolob mala Jávi jauju iki ĉih ni Saaŋ ; ");
INSERT INTO bqj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ban eno jimaŋe jíinen yo joon : Saaŋ Batis o aamme Elí ahu o gulobe mee mala ébbañul yay yola. ");
INSERT INTO bqj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","An abaj me gunnu gal eun, aun ! ");
INSERT INTO bqj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ni wa ᵽan ᵽiaŋ iligor me bugan bugagu bugaa jabbah je ? Gúnini ti uñil garove to ésuh yay ni’guomunor me, guban n’guoh gupalil : ");
INSERT INTO bqj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Uŋeh juogul mee, jimaŋut eboh ; mbi júfoñul ufuluŋ, n’jilat ukoŋ.” ");
INSERT INTO bqj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maagen, Saaŋ Batis najoulo, nd’atiñ mitiñolal, nd’arem ᵽoᵽ eremolal, ban bugan bugagu n’guoh : “Eseytane enogenol.” ");
INSERT INTO bqj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Añol Arafuhow najoulo, nah’atiñ narem, ban bugan bugagu n’guoh : “Jujugom sum áine ahumu : gaᵽinorol ᵽe fitiñ ni marem barebare, ni ᵽoᵽ ejaor n’utilaaw ni uyaba-búalen bugagu !” Bare Malillo mamu mal Aláemit migitenigiten ĉol ni waf waw wo bugan bugagu gabaj mo me gukane me. » ");
INSERT INTO bqj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ñer Yésu narobo ennur súsuh sasu dó nafaŋ me nakane waf wajureruti, mata bugala ró guhalut bakaneril baarat mee. ");
INSERT INTO bqj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nah’aah so : « Mataño míni ni buru, bugaa Korasin ! Mataño míni ni buru, bugaa Betusaida ! Waf waw waunderuti mee wo Aláemit akan me ni buru, ínien Tir ni Sidoŋ nakanen wo, bugala súsuh sausu bugo basimoener wañ waa gúnigo, n’gulosor bukugay bi egiten búoh gúbahembahen bakaneril. ");
INSERT INTO bqj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yo eĉil me, ínje ilobul yo : funah fafu faa bataliŋ babu fiĉigul me, bataliŋul ᵽan bufaŋ m’bútañie baa Tir ni Sidoŋ. ");
INSERT INTO bqj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Min buru may, bugaa Kaᵽerinaum, jíinene ᵽiaŋ búoh Aláemit ᵽan atebenul bi fatiya ? Múk ! Ᵽan jialeni bi ró n’ettam n’ufuga ! Eno waf waw waunderuti mee wakani me n’ésugul ukaneni Sodom, ésuh yauyu ᵽan eroŋen to bi jama. ");
INSERT INTO bqj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yo eĉil me niegul : funah fafu faa bataliŋ babu fiĉih me, bataliŋul ᵽan bufaŋ m’bútañie baa Sodom. » ");
INSERT INTO bqj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ni tinah tautu, Yésu nalob aah : « Nisali, Aláemit Ᵽayom, aw aĉil me émit ni ettam, mala min ukoᵽen me waf wauwu bugan bugagu gabaj me gaffas ni bugagu galillo me, mbiban nugiten wo bugagu gáni me ti uñil. ");
INSERT INTO bqj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Maagen, Ᵽayom, nisali mata súmisum min ní mee. ");
INSERT INTO bqj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Waf waw ᵽe Ᵽayom nahatwohat ni guñenom. Bajut an affase ínje Añil ahu íni let Ᵽaaya, ban may bajut an affase Ᵽaaya íni let ínje Añil ahu ni bugo nimaŋ me egitenol. » ");
INSERT INTO bqj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","« Jújoul bi n’ínje buru ᵽe jayoh me n’eteb bíteb báliie, ban ᵽan isenul gáelo. ");
INSERT INTO bqj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nibubibubi ban itebenorout ; yo eĉil me jiŋarom íni áĉibbenaul, ban n’jiyab baligenerom. Mamu ᵽan jibaj gáelo, uinumul ᵽan ufilo. ");
INSERT INTO bqj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maagen mamu báĉibbenerom bútañiut, ban bíteb babu bo nijae me esenul jiteb bivilivili. » ");
INSERT INTO bqj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ni gunah gaugu, Yésu náni n’esat ulah waw funah faa fíiyay. Nemme ulagorol bieb bujogil, n’gunamo etuj gukoñ gagu guheŋ. ");
INSERT INTO bqj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ni baj Eᵽárisie guce gujugil n’guoh Yésu : « Aᵽaa uluj ! Ulagorai ubugi n’ekan waf wo gúfirene ekan funah faa fíiyay. » ");
INSERT INTO bqj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bare Yésu naagil : « Buru ᵽiaŋ jijangaut wo David akan me funah fice no bieb bujogil me, o ni galageneol me ? ");
INSERT INTO bqj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Leti nanogenogen ni Fúggut Aláemit, aban náŋarul dó unaĉ waw wájii ró me Aláemit gutiñ, aĉila ni galageneol me ? Ban guotenut gutiñ wo, bare til uteŋenaaw bareil bugo gújue gutiñ wo ! ");
INSERT INTO bqj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jijangaut mul wo gúboñ gagu gaa Móis gulob me mala uteŋenaaw gaĉiggo me dó ni gávi-Aláemit hani funah faa fíiyay ? Ekan yauyu eĉilil min gúkanumut fíiyay fafu, bare eĉilutil min gutil. ");
INSERT INTO bqj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ban ínje ilobul yo : baje tale waf wafaŋe nubaje hámma gávi-Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Leti Bahiĉer babu buoge : “Nimaŋe ñarum enil, bare let úsimen waw waa sihaj” ? Jujogen me wo gurim gaugu gulobe, mati jitegen sulob bugan gakanut waf. ");
INSERT INTO bqj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maagen, Añol Arafuhow o aamme afan ahu ala fíiyay fafu fololal. » ");
INSERT INTO bqj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yésu náᵽur to akay ban najow ak’anogen ni yaŋil yaa galaw. ");
INSERT INTO bqj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ni baj ró ánaine ace ahaje ni gañenol. Nemme Eᵽárisie yay gumamaŋ ebaj waf wo mbi gújogumol me ni wo, n’gurorenol guoh : « Gúboñolal gújiji ᵽiaŋ an min asen gahoy funah faa fíiyay ? » ");
INSERT INTO bqj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yésu naagil : « Eno ace ni buru nabaje gabbarum ganur pat ban ni gulo n’éhaᵽa funah faa fíiyay, mati ᵽiaŋ ajow iki áᵽunnul go n’éhaᵽa yay ? ");
INSERT INTO bqj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ban an, leti nafaŋe gabbarum nár ? Kan hum sesen búoh an nájue akan maaro funah faa fíiyay. » ");
INSERT INTO bqj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mbiban Yésu nábaho mbal áine ahu naagol : « Uraw ᵽaa gañeni. » Aíne ahu naraw go, ban gañen gagu n’gúbbañul guhoy ti gagu. ");
INSERT INTO bqj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ñer Eᵽárisie yay n’gukay ban n’gujoj bi effas bu gujae ekan min gunemen Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nemme Yésu naffase gaᵽinor Eᵽárisie yay, náᵽur tiñ tautu ajow akay. N’ejaol, bugan gammeŋe n’gulagenol. Nasen gahoy úsotaaw ᵽe, ");
INSERT INTO bqj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","bare nannuril liŋ naagil jambi an áᵽunnol me n’ésuh. ");
INSERT INTO bqj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nakan mo mee min mbi gurim gagu go Aláemit alob me ni butum aboñer ahu Esai gukano gaah me : ");
INSERT INTO bqj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","« Arokaom o niĉob me ume ; aĉila aamme o níbboli me nár, ni o nibaje ésumayom ᵽooyo. Ᵽan ibaŋ Biinumom ni o, min mb’avare maĉole mamu ni sasu súsuh ᵽe saa mof. ");
INSERT INTO bqj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mat’abaj síñagor ni an ban mát’áᵽib fatiya, mati an aun firimol ni gukaen gagu. ");
INSERT INTO bqj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mat’afaben fisisit fatuje fuban, ban mat’afoh ejaŋa yo gajaŋa yo gufokotoe. Ᵽan akan mamu bi no najae me ekan maĉole mamu ni mihek maarat mamu. ");
INSERT INTO bqj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ban bugaa súsuh sasu ᵽe saa mof ᵽan gubaŋ gafiumil ni o. » ");
INSERT INTO bqj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ᵽúrto, n’gúŋarul Yésu ace áine o eseytane enone ák’ápim ban nakan émumune. Yésu nasenol gahoy iki nah’alob ban najuh. ");
INSERT INTO bqj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ñer gaam to me ᵽe n’gummeŋ gajahali iki ni’guoh : « Dáuru leti añol David ? » ");
INSERT INTO bqj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bare Eᵽárisie yay no guun yo me, n’guoh : « Ujuh me áine ahumu náju aham siseytane sasu, mata búoh Belisebul, aamme afan so, o aseneol sembe sausu. » ");
INSERT INTO bqj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nemme Yésu naffase gaᵽinoril, naagil : « Bugan gagume jávi gutigenoro me, jávi jauju ᵽan jinemo. Bajut ésuh ter yaŋ yo uĉinda ró guom n’etigenor yájue eroŋ. ");
INSERT INTO bqj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eno Seytane nah’ahakam Seytane, o hum atigenoroe faŋaol ; bu ñer jáviol jújue juroŋ ? ");
INSERT INTO bqj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Buru jujoge búoh Belisebul aseneom sembe sasu so niŋare me niham siseytane sasu. Ñer gupalul ni sembe sal ay guhame so me ? Yo eĉil me bakaner gupalul ᵽan bigitenul me búoh jibibij. ");
INSERT INTO bqj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bare nemme Biinum Aláemit biĉilom min nih’iham siseytane sasu, dó giten me búoh Jávi Aláemit jiĉiloĉih tale ni buru. ");
INSERT INTO bqj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","An ájuut anogen ni yaŋ yal an abaje sembe ák’ákuet ró fubajol o m’bamundumut ajogol ahoh ; aban me, no ñer ᵽan áju me ákuet waamme ni yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","An abbañut me búsolom, o alatorom nam ; an ᵽoᵽ aanenutom me niomen ekore yay, dóemme evis yo namaŋe. ");
INSERT INTO bqj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yo eĉil me niegul : gatil gánogan ter gajel gánogan gal arafuhow, hani guyae n’Aláemit, gújue guboketi ; bare gajel gayae ni Biinum Banabe, go, mati guboketi. ");
INSERT INTO bqj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","An alob me firim faarat aya n’Añol Arafuhow, Aláemit nájue aboketol fo ; bare an alob me firim faarat aya ni Biinum Banabe, Aláemit mat’aboketol hani ni buroŋ baa jama, hani ᵽoᵽ ni buroŋ bájaeul. » ");
INSERT INTO bqj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","« Bununuh búari me, mitiñ bo may ᵽan múari ; bare bununuh buarat me, mitiñ bo may mati múari. Maagen mamu, bununuh bánoban ni mitiñ bo buffasei. ");
INSERT INTO bqj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gabugor súᵽudum ge ! Bu jújue julob waf waaro buru baamer bugan gaarat ? Maagen mamu, ánoan wammeŋen me biinumol butumol ní’búᵽuren bulob. ");
INSERT INTO bqj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","An aaro náh’áᵽureᵽuren máarie mamu mal ebaj yay yaamme ni o agiten ésuh yay ; bare aarat me, máhojie mamu mal ebaj yay yaamme ni o, mo náh’áᵽuren agiten ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Injé ilobul yo : funah fafu faa bataliŋ babu, bugan bugagu ᵽan gubaj bi egiten mala firim fánofan faarat fo gulobe. ");
INSERT INTO bqj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maagen mamu, Aláemit ni gurim gagu gúiya ᵽan ataliŋi me bataliŋ bal eseni bakoŋ ter bal etegi. » ");
INSERT INTO bqj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ñer úᵽajula gúboñ Aláemit ni Eᵽárisie guman n’guoh Yésu : « Afan ahu, jimaŋe ukanóli n’jujuh bigitenum bo an ájuut akan. » ");
INSERT INTO bqj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yésu naagil : « Bugan bugagu bugaa jama gaarat mee ban gúkanumut Aláemit, bugo guŋese me ejuh bigitenum bo an ájuut akan. Bare Aláemit mat’abbañ akanil n’gujuh bigitenum bice íni let babu babaj me aboñer ahu Sonas. ");
INSERT INTO bqj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ti Sonas arobo me ni far eol yay yámah yay sutufunaha sífaji ni sufuga sífaji, mo may Añol Arafuhow ᵽan arobo me ñáraru ettam yay sutufunaha sífaji ni sufuga so ró. ");
INSERT INTO bqj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Funah fafu faa bataliŋ babu, gailo gagu go bugaa Niniv gubajen me no, ᵽan may gugiten bugan bugagu bugaa jama búoh gubajut bakoŋ, mata bugo no guutten me baĉafer Sonas guban, gúbahembahen bakaneril ; ban ute to nuomal maa, baje an afaŋe Sonas. ");
INSERT INTO bqj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Funah faufu fanur fafu faa bataliŋ babu, aseh ahu ala mof mamu maa Saba ni gailool ᵽan may aceŋ bugan bugagu bugaa jama, mata aĉila náᵽulloᵽur ráli ákail autten gurim gagu gatajene me gaffas gal ávi ahu Salomoŋ ; ban ute to nuomal maa, baje an afaŋe Salomoŋ. » ");
INSERT INTO bqj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","« Eseytane éᵽur me ni an o neh’ebet, ᵽan neh’eyanor bo me bin babu bahay me, ᵽan neh’eŋes tiñ taa gáelo, ban mat’ebaj. ");
INSERT INTO bqj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ñer ᵽan eoh : “Ban ibbañ bi ni yaŋom dó níᵽullo me.” No eĉih ró me, nejuh búoh yaŋ yay eᵽa erakel, evuivu ban étugituh jon. ");
INSERT INTO bqj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ᵽan ñer ejow ék’éŋesul sice siseytane sono futoh ni súuba safaŋ yo búlaᵽut, min sújoul so ᵽe íkiil siĉin dó. Ᵽúrto, sílam an ahumu ᵽan sifaŋ saa no. Mo may jae mee éni bi ni bugan bugagu bugaa jama gaarat mee. » ");
INSERT INTO bqj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yésu o n’eroŋ n’elob ni fítiman fafu, jaol ni gutiol n’guĉigul. N’guilo tíyaŋ min gúni n’eliᵽ bi elob ni o. ");
INSERT INTO bqj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ace ni gaam dó me naah Yésu : « Uutten, jai ni gutii ubugi tíyaŋ, ban gumaŋe elob n’aw. » ");
INSERT INTO bqj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yésu naagol : « Ay aamme jaom ? Bugay guomme gutiom ? » ");
INSERT INTO bqj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mbiban nañuren ulagorol aban naah : « Bugaubuge guomme jaom ni gutiom. ");
INSERT INTO bqj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maagen mamu, ánoan akane wo Ᵽayom aamme fatiya amaŋ me, an ahumu o aamme atiom, álinom, jaom. » ");
INSERT INTO bqj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Funah faufu, Yésu náᵽurul dó ni yaŋ yay ak’arobo galam fal fafu fáᵽurut me. ");
INSERT INTO bqj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Fítiman fámah ni fúkail fuomunor to naamme ; ni fújalo bireg nájuᵽo ni busana bice ak’anamo ró. Fítiman fafu ni fíni bo ni mahae ni fiiye. ");
INSERT INTO bqj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ñer naŋar búnogor min avareil waf wammeŋe nah’aagil : « Baje abela-euh ace áᵽullo bi eke ebet euh. ");
INSERT INTO bqj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","O n’ebet euh yay, eceyo nelo n’galam bulago ; upu waw n’úkail utiñ yo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yayuyo nelo tiñ taake tabaje sival to eus emmeŋut ; nefaen eil mata guar yo gújuut gunogen síki. ");
INSERT INTO bqj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bare no tinah talu tirabulo me, nepab ehay mala min guar yo gújuut me gunogen síki. ");
INSERT INTO bqj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Epayo nelo tiñ taa sijeŋ ; sijeŋ sasu ni síbbagul iki súnumen yo. ");
INSERT INTO bqj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eceyo nelo ni mof maaro : nebuh mitiñ, gahager ganur n’gubuh wono ávi ni guñen, gace wono úvi gúfaji, gagu wono ekeme. ");
INSERT INTO bqj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","An abaj me gunnu gal eun, aun ! » ");
INSERT INTO bqj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ñer ulagora Yésu n’gulofol ban n’guogol : « Wa uĉile nuŋar únogor nulob ni bugo ? » ");
INSERT INTO bqj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naagil : « Buru Aláemit nájiulji min júju jujoh firim fafu faa Jáviol fásiki me, bare bugo ájiutil yo. ");
INSERT INTO bqj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","An abaj me, ᵽan afaŋ nayabe ák’áni ni fusanumet ; bare an abajut me, ᵽan guramol ᵽe bi ni jo náhagum me ró. ");
INSERT INTO bqj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yo eĉil me nih’iŋar únogor min ilob ni bugo, mata gulujeluj gujugérit, guuttenewutten guunérit ban ᵽoᵽ gujogérit. ");
INSERT INTO bqj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ban firim faufe fal aboñer ahu Esai ufu n’ekano ni bugo faah me : “Ᵽan juun bare mati jujoh, ᵽan juluj bare mati jujuh. ");
INSERT INTO bqj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ey, bugan bugaubugu gubbannobañ gúni bugan gaake uinum, gutotoj gunnuil, gúmipemipen gúĉilil, min gúfiren gúĉilil ejuh, gunnuil eun, uinumil ejoh. Mamu ñer gúfirenoroe ébbañul bi n’ínje min isenil gahoy.” ");
INSERT INTO bqj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bare buru til jibaje gásumay : gúĉilul gujuge, ban gunnuul n’guun ! ");
INSERT INTO bqj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Maagen, ínje ilobul yo : uboñer gammeŋe ni ᵽoᵽ bugagu gaĉol me bújoŋor Aláemit gumaŋene gujuh wo buru jujuge me, bare gutogut gujuh wo, gumaŋene guun wo buru juune me, bare gutogut guun wo. » ");
INSERT INTO bqj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","« Buru ñer juutten wo búnogor babu bal abela euh yay bulob me. ");
INSERT INTO bqj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bulago babu dó ece n’eugit yay elo me, dóemme bugan bugagu gautten me firim fafu faa Jávi Aláemit, mbiban gujogut fo : An ahu Aarat me ᵽan ájoul ban ᵽan áᵽuren firim faufu n’uinum bugan bugaubugu. ");
INSERT INTO bqj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ettam yay yaak me dóemme bugagu gaun fo me, ban n’gufaen guyab fo to baenah n’ésumay ró, ");
INSERT INTO bqj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","bare fiilut guar ni bugo ; bugo bugan bugom gañumut eᵽio : No sílam sasu ni gálatien gagu sijae me eĉigul mala firim faufu, n’gufaen gubelen gáinenil. ");
INSERT INTO bqj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tiñ talu taa sijeŋ sasu, dóemme bugagu gaun me firim fafu, mbiban gaᵽinor gagu gaa buroŋ babu baa jama ni ᵽoᵽ eliᵽ fubaj yay yabute me ni síkail súnumen fo min fújuut fubugor ni bugo. ");
INSERT INTO bqj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mof mamu máari me, dóemme bugan bugagu gaun me firim fafu ban n’gujoh fo. Bugan bugaubugi ᵽan gúŋarul ni buroŋil waf waaro wammeŋe ti emano : gahager ganur n’gubuh wono ávi ni guñen, gagu wono úvi gúfaji, gace wono ekeme. » ");
INSERT INTO bqj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mbiban Yésu natajen alobil búnogor bice naagil : « Jávi jaju jaa fatiya jínini ti an abele eugit yaaro ni galagol. ");
INSERT INTO bqj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Efuga ece, ésuh yay ᵽe n’gámori, alator áine ahumu nájoul íkiil aroh esisit águñor n’emano yauyu aban najow akay. ");
INSERT INTO bqj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","No emano yay eogol me, esisit yay néᵽurul may. ");
INSERT INTO bqj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ñer urokaaw bugal ala yaŋ yay n’gúkail guogol : “Afanóli, leti eugit yaaro nubele ni galagi ? Bu jáorum me ñer ni baj dó esisit ?” ");
INSERT INTO bqj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Naagil : “Dáuru alatorom ace akan mee burok baubu.” N’guogol : “Numaŋe iki jiñah yo jibelen ?” ");
INSERT INTO bqj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naagil : “A-a, jambi jike yo eñah n’júloĉor manur eugen yay. ");
INSERT INTO bqj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jihat so min sibbagor iki eᵽit yay eĉigul. No ᵽan ioh me uᵽilaaw : Jumundum jiñah esisit yay juhoh gúpuh bi esaen ; emano yay, yo, jibet yo ni bíjejom.” » ");
INSERT INTO bqj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yésu nabbañ alobil búnogor bice mul naagil : « Jávi jaju jaa fatiya jínini ti jukol fuyaba jo an aŋare aroh ni galagol. ");
INSERT INTO bqj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jo jifaŋe gatiti mukol mamu ᵽe ; bare jiilul me, ᵽan jifaŋ gájalo mununuh mamu ᵽe maam dó me ni gafat gagu, ban ᵽan jíni bununuh bújalo iki upu waw úkail ulef ró n’uan bo. » ");
INSERT INTO bqj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Natajen mul alobil búnogor be : « Jávi jaju jaa fatiya jínini ti lévir yo anaare atiĉe águñor ni ukib úfaji wal eᵽor ek’eilo ᵽooyo. » ");
INSERT INTO bqj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ñer Yésu naŋar únogor wauwu ᵽe min alob ni fítiman fafu ; nd’alob ni bugo o m’baŋarut únogor, ");
INSERT INTO bqj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","dó ᵽe min mbi wo Aláemit alob me ni butum aboñer ahu ukano, no naah me : « Ᵽan íŋabul butumom nilob n’únogor, ᵽan igiten waf waw wakoᵽeni me kábiriŋ m’buju babu. » ");
INSERT INTO bqj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","No Yésu aban me, nahato fítiman fafu min abbañ anogen ni yaŋ yay dó naamen me. Ulagorol n’gulofol n’guogol : « Uᵽájuloli búnogor babu bal esisit yay yaa galah gagu. » ");
INSERT INTO bqj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Naagil : « Yoo. An ahu abele me eugit yay yáari me, o aamme Añol Arafuhow ; ");
INSERT INTO bqj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","galah gagu dóemme mof mamu, eugit yay yáari me dóemme guñol Jávi jaju ; esisit yay dóemme guñol An ahu Aarat me. ");
INSERT INTO bqj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Alator ahu aroh me esisit yay, o aamme Seytane ; eᵽit yay dóemme gabao mof ; uᵽilaaw bugo guomme emalakaay. ");
INSERT INTO bqj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ban ti gujae me éᵽuren esisit yay gural ni sambun, mo may ᵽan ní mee no gabao mof gujae me eĉigul : ");
INSERT INTO bqj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Añol Arafuhow ᵽan áboñul emalakaol íkiil gúᵽuren ni Jáviol bugan bugagu gaĉile me gupalil n’gutil, ni ukana-maarat bugagu. ");
INSERT INTO bqj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mbiban ᵽan gubenil ni sambun, dó ᵽan níme ukoŋ ni ejoh émiremma. ");
INSERT INTO bqj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","No ñer, bugagu gaĉol me ᵽan nihi guij ti tinah dó ni Jávi jaju jaa Ᵽail. An abaj me gunnu gal eun, aun ! » ");
INSERT INTO bqj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","« Jávi jaju jaa fatiya jínini ᵽoᵽ ti fubaj fakoᵽeni ni galah fo an araŋene. No naraŋen fo me, natosen fo akoen dó tice ; násumaet nár ak’annomen wafol ᵽe min annom galah gaugu. ");
INSERT INTO bqj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jávi jaju jaa fatiya maa jínie may : baje annomena ace aam n’eŋes enuh ejaha. ");
INSERT INTO bqj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","No najuh me ece yo funnom yo fújaloe mata ebabaj hámma, najow ak’annomen wafol ᵽe min annom yo. » ");
INSERT INTO bqj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","« Jávi jaju jaa fatiya, maa mul jínie : baje fumbal fabeli ni fal fámah, ban ni fujoh eol yánoyan. ");
INSERT INTO bqj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No fimmeŋ me, umbalaaw n’gúñagul fo gural ni búluŋ min gurobo éᵽuren suol sasu. N’gufor sáari me gukan n’utegel, min gubelen saarat me. ");
INSERT INTO bqj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mamu may ᵽan ní mee ni gabao gagu gaa mof : emalakaay ᵽan guke gúfaculor ukana-maarat bugagu ni bugagu gaĉol me, ");
INSERT INTO bqj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mbiban n’guteb ukana-maarat bugagu gubelen ni sambun sajege : dó ᵽan baj me ukoŋ ni ejoh émiremma. » ");
INSERT INTO bqj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mbiban naagil : « Jujoge joon dáuru ᵽe ? » N’guogol ey. ");
INSERT INTO bqj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ñer naagil : « Aᵽájula gúboñ Aláemit ánoan abbanno áni alagor ala Jávi jaju jaa fatiya nánini ti afan yaŋ áᵽurene me ni ebajol waf uvugul ni ᵽoᵽ waf ufan. » ");
INSERT INTO bqj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","No Yésu alob me únogor wauwu aban, náᵽur to akay. ");
INSERT INTO bqj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Najow bi ni mof mamu dó nabugi me, aban nanamo eligen bugan bugagu ni yaŋ yay yaa galaw yolil dó Nasaret. Maagen mamu, naligenil bireg n’gujahali n’guoh : « Bay naŋallo malillo maumu ? Bu nájue nah’akan waf waunderuti ti wauwu ? ");
INSERT INTO bqj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Leti dáuru añol acokora gurihinjaŋ ahu ? Leti jaol aamme Mari ? Gutiol leti bugo guomme Saak, Susef, Simoŋ ni Síd ? ");
INSERT INTO bqj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gúlinol leti bugo guom maa tale ᵽe ni wolal ? » ");
INSERT INTO bqj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dáuru ñer n’diĉilil n’gulat éinen ni o. Ñer Yésu naagil : « Aboñer nah’aruheniruhen tíñotiñ iki fádo fiilol ni ésugol dó nabugi me. » ");
INSERT INTO bqj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ñer Yésu akanut ró waf waunderuti wammeŋe mala gáinenut gagu golil. ");
INSERT INTO bqj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gannay gaugu, Herod, aamen me ávi Gálile, naun gulob mala Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naah urokaol : « Dáuru Saaŋ Batis aiyulo me ni gaĉet me ! Yo eĉil me nabaj sembe sausu sal ekan waf wajureruti. » ");
INSERT INTO bqj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Maagen mamu, Herod naboñenboñ gujoh Saaŋ Batis min guhogol ñisel ban n’guŋarol gúrur ni fipeh. Dáuru ᵽe mala Herodias aar atiol Fílip o nábahen me akan aarol, ");
INSERT INTO bqj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ban no Herod akane mo me, Saaŋ naagolseh : « Senuti min uram Herodias ! » ");
INSERT INTO bqj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod namaŋene ekan min Saaŋ Batis aĉet, bare náholi Esúif yay mata bugo ᵽe gujojoh Saaŋ Batis ti aboñer. ");
INSERT INTO bqj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mb’uĉiga funah fafu fo Herod aamme n’ekan gaggan gagu gaa gabugiol, bájur Herodias naboh bújoŋor sijaora Herod. Naboh aboh iki súm Herod ");
INSERT INTO bqj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","bireg Herod nabbat esenol wáfowaf wo najaol me écin. ");
INSERT INTO bqj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ni batuñener baa jaol, bájur babu naah ávi ahu Herod : « Uŋallom maer yauye fuhow Saaŋ Batis ni biril. » ");
INSERT INTO bqj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ñer ávi ahu ni mujogol faŋ, bare nemme nabbabat aban bújoŋor sijaoraol, namaŋ guŋallol fo, ");
INSERT INTO bqj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ban naboñ iki guᵽikul fuhow Saaŋ Batis dó ni fipeh fafu. ");
INSERT INTO bqj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","N’gúŋarul fuhow fafu ni biril íkiil gusen bájur babu ; biĉila may m’búbahen fo bisen jaw bo. ");
INSERT INTO bqj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ñer ulagora Saaŋ Batis n’gúkail guŋar efuluŋ yay iki gufoh. Mbiban n’gujow iki gugiten Yésu wabaj me. ");
INSERT INTO bqj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","No Yésu aun me wabaj me Saaŋ Batis, naŋar busana min añago mbaa tiñ talikoe ; bare fítiman fafu ni fuun yo, min bugan bugagu gúᵽurul ni súsuh sasu gulagenol ni guot. ");
INSERT INTO bqj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","No naavulo me ni busana babu, najuh fítiman fámah. Enilol nerumil min asen gahoy úsotaaw ᵽe gaamen to me. ");
INSERT INTO bqj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","No tinah tujon me, ulagorol n’gulofol n’guogol : « Tiñ taute tilikoe, ban tinah tígale ; ubbañen bugan bugaubugi gujow ni súsuh sasu, tima n’gunnom bo waf gutiñ. » ");
INSERT INTO bqj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yésu naagil : « Rorenut min guke bice : buru faŋaul jisenil gutiñ ! » ");
INSERT INTO bqj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","N’guogol : « Unaĉ futoh ni muol múuba bare jibaje. » ");
INSERT INTO bqj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naagil : « Jiŋallom so bi tale. » ");
INSERT INTO bqj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nakan fítiman fafu ni funamo n’efos yay, aban naŋar unaĉ waw waamme futoh ni muol mamu maamme múuba, náarul gúĉilol fatiya min asalen Aláemit. Mbiban namusul unaĉ waw asen ulagorol gugabor fítiman fafu. ");
INSERT INTO bqj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bugo ᵽe n’gutiñ iki gupoñ kab guŋañen. Mbiban, ulagoraaw n’guteb utegel guñen n’úuba ummeŋ kab baᵽirih babu baŋaño me. ");
INSERT INTO bqj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bugan bugagu gatiñ me maageima bugan gono súuli futoh (5 000), waareaw ni uñiaw m’baᵽinuti. ");
INSERT INTO bqj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","No bao me, Yésu nafaen aah ulagorol gújuᵽo ni busana babu min guyabol gayoŋ mbaa ñagagu, min mb’aĉila faŋaol abbañen fítiman fafu. ");
INSERT INTO bqj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","No nabbañenil me aban, najiŋ n’erijaŋ yay áhatulo ake galaw ; náni ró iki tinah tujon. ");
INSERT INTO bqj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ni tinah tautu, busana babu bo baamer n’etut fal fafu, ban gulongos gagu n’guyogen bo faŋ mata gallaj érus yay guomen ni go. ");
INSERT INTO bqj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tinahurab, Yésu najow n’guot ni fal fafu mbaa bugo. ");
INSERT INTO bqj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","No ulagorol gujugol me nájaeul mee ni fal fafu, n’gúholi n’guoh : « Dáuru ayaul ! » Ñer n’guilo guya úᵽib. ");
INSERT INTO bqj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bare Yésu naramor aagil : « Jifilen uinumul, ínje om ! Jambi júholi ! » ");
INSERT INTO bqj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ᵽier naagol : « Ataw, íni me aw om, uogom íjoul ni mal mamu mbal aw. » ");
INSERT INTO bqj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Naagol : « Ujóul ! » Ñer Ᵽier náavul ni busana babu ajow ni mal mamu mbaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bare no najuh me búoh érus yay ebabaj sembe, gáholi n’gunonol, ban namaŋ bi étimo ; ñer náᵽib aah : « Ataw, uᵽagenom ! » ");
INSERT INTO bqj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","To baenah, Yésu naalen gañenol ajogulol, aban naagol : « Mo gáineni gutitie ! Wa uĉile nusasabor ? » ");
INSERT INTO bqj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ñer n’gújuᵽo ni busana babu bugo éubail, ban érus yay neilen. ");
INSERT INTO bqj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ñer gaamen dó me ᵽe n’guya gújul bújoŋor Yésu n’guoh : « Maagen aw uomme Añol Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","No gútiᵽ me fal fafu guban, n’guya n’ésuh yay yo guvoge me Genesaret. ");
INSERT INTO bqj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bugaa bo n’gútallo Yésu min gufaen guboñ bugan ni súsuh sasu ᵽe salof yo me bi egitenil búoh Ataw umu dáre ; ñer bugan bugagu n’guŋallol úsotaaw ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","N’gulaol aboket ahalil n’gugor hani gáñin bisimool bare. Maagen gagor go me ᵽe n’guhoy gujañ. ");
INSERT INTO bqj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ni gunah gaugu, ni baj Eᵽárisie ni úᵽajula gúboñ Aláemit guce gúᵽurul Yérusalem gúkail gutoh Yésu n’guogol : ");
INSERT INTO bqj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","« Wa uĉile ulagorai gúkanumerit mukanay mamu mo sipayolal gufan guhalolal me ? Uluj ᵽaa, ndi guᵽos guñenil balama gutiñ ti mukanayolal mulob yo me. » ");
INSERT INTO bqj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Naagil : « Buru may wa uĉile jíkanumerit gúboñ Aláemit min til jilagen mukanay mamu molul ? ");
INSERT INTO bqj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aláemit aagut hee : “Ukánum ᵽai ni jai” ? Naage mul : “An ajel me ᵽayol ter jaol, an ahumu naate amugi.” ");
INSERT INTO bqj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Bare hum buru juoge bugan bugagu gusoholaut ékanum ᵽail ter jail íni me guŋare wo guñumen me erambenil ni wo gúji me Aláemit ní bíteŋenol. Mamu ñer, jibelene firim Aláemit min til jilagen mukanay mamu molul. ");
INSERT INTO bqj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bugan ge gálodit maagen ! Aboñer ahu Esai nabaje bakoŋ ni buru no naah me : ");
INSERT INTO bqj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Bugan bugaubugi ni gurim bare gusaleom, bare uinumil úraliomrali faŋ ! ");
INSERT INTO bqj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bíteŋen babu bo gukaneom me burakel bom, mata wo guligene me bugan bugagu, mukanay mom mal arafuhow bare !” » ");
INSERT INTO bqj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ᵽúrto, Yésu nabbañ alob ni fítiman fafu naagil : « Juuttenom joon min mbi júju jujoh wo nijae me elobul. ");
INSERT INTO bqj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Let wanone me ni butum arafuhow nuh’ukanol nasigo. Bare til wáᵽullo me ni butum an, wo nuh’ukanol nasigo. » ");
INSERT INTO bqj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ñer ulagorol n’gulofol ban n’guogol : « Nuffase búoh Eᵽárisie yay guiñil gutitiñ mala firim faufu fo nulob mee ? » ");
INSERT INTO bqj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naagil : « Bununuh bánoban bo Ᵽayom aamme fatiya arogut, ᵽan bubbuĉi. ");
INSERT INTO bqj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jihalil bo ! Dáuru úpima gaam n’éĉibben gupalil úpima. Ban ápima áĉibben me apalol ápima, bugo éubail ᵽan gulo ni gasun. » ");
INSERT INTO bqj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ñer Ᵽier naagol : « Aᵽaa úᵽajuloli gurim gagu go nulob mee mala gasigo gagu ! » ");
INSERT INTO bqj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yésu naagil : « Kan buru may jujogut gurim gaugu ? ");
INSERT INTO bqj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jiffasut búoh wanone me ᵽe ni butum bal an ujaejow bi ni farol, ban ᵽúrto n’úᵽur n’enilol o bakaer m’bise ? ");
INSERT INTO bqj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bare wáᵽureul me ni butumol, wo, ni biinumol úᵽummulo, ban wo nuh’uĉilol nasigo bújoŋor Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mata ni biinum an uᵽinor waw waarat me núh’úᵽurul : waa jamuh an, gafilen anaare alet úiya, bujobuet, gákuet, eteh bugan sulob, gúmeñ bugan. ");
INSERT INTO bqj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Waf wauwu nuh’uĉil me an nasigo. Bare fitiñ m’baᵽosut guñen, yo nd’eĉil an nasigo. » ");
INSERT INTO bqj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mbiban Yésu náᵽur to ajow bi ni mof mamu dó súsuh sasu saa Tir ni Sidoŋ suomme. ");
INSERT INTO bqj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ni baj anaare ace ala Kanaan aĉin dó. Aare ahumu nájoul bi to ni Yésu n’éᵽib nímoro aah : « Ataw, añol David, uboket enili erumom ! Bájurom eseytane eyogenol faŋ, náguoguo nár ! » ");
INSERT INTO bqj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bare Yésu ábalutol hani firim fanur. Ñer ulagorol n’gulofol n’guogol : « Ukanol najow ! Nafambeolalfam. » ");
INSERT INTO bqj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yésu naagil : « Niboñuliboñ mala bugan bugagu bugal Israel bare, gáni mee ti ubbarum wallilim. » ");
INSERT INTO bqj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bare aare ahu nákail aya gújul bújoŋorol naagol : « Ataw, urambenom ! » ");
INSERT INTO bqj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yésu naagol : « Warat eŋar mitiñay uñiaw usen sujoba. » ");
INSERT INTO bqj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aare ahu naagol : « Ataw, maagen nulobe, bare bae sujoba sasu nihi sititiñ baᵽoy babu báloeul me ni biril bugala so. » ");
INSERT INTO bqj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ñer Yésu naagol : « Alínom, mo gáineni gújaloe ! Wo numaŋ me ukano. » Ban bájurol nahoy ni tinah tiĉila. ");
INSERT INTO bqj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yésu náᵽur to ajow bi galam fal fafu fáᵽurut me faa Gálile. No naĉih bo me, najiŋ n’erijaŋ aban narobo ró. ");
INSERT INTO bqj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ñer bugan gammeŋe n’gújoul iki gutogol bo. N’ejoulil, n’gúŋarul uhaja, úpima, ubofoa, súmumune, ni úsota guce gammeŋe. N’gubaŋil to n’guolol ban nasenil gahoy. ");
INSERT INTO bqj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bugan bugagu n’gujahali náar no gujuh me súmumune sasu sulob, uhajaaw guhoy, ubofoaaw guilo n’gujow, úpimaaw gujuh ; ñer bugo ᵽe n’gurobo esalen Aláemit ahu ala Israel. ");
INSERT INTO bqj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ᵽúrto, Yésu návogul ulagorol aban naagil : « Enilom erume bugan bugaubugi mata baje ñer gunah gúfaji bugo tale n’ínje, ban gubajut wáfowaf bi fitiñ. Imaŋut ibbañenil guot gar gurakel, jambi guyogo babu m’bulago. » ");
INSERT INTO bqj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ulagoraaw n’guogol : « Bay nújuale ubajal ni tiñ taute taliko maa waf waa fitiñ watoge bi esen bugan bugaubugi gammeŋ mee gutiñ iki gupoñ ? » ");
INSERT INTO bqj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yésu naagil : « Unaĉ butumbu jibaje ? » N’guogol : « Wono futoh n’úuba, ni ᵽoᵽ muol matiito muman. » ");
INSERT INTO bqj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ñer Yésu nakan bugan bugagu n’gurobo to n’ettam, ");
INSERT INTO bqj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","aban naŋar unaĉ waw waamme futoh n’úuba ni muol mamu, mbiban nasal Aláemit, aban namusul so asen ulagorol gugabor bugan bugagu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bugo ᵽe n’gutiñ iki gupoñ. Ulagoraaw n’guomen miᵽirih mamu maŋaño me iki gummeŋen utegel wono futoh n’úuba guteb gújaenum. ");
INSERT INTO bqj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bugan bugagu gatiñ me guomme súuli sibbagir (4 000), waareaw ni uñiaw m’baᵽinuti. ");
INSERT INTO bqj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mbiban, Yésu nabbañenil guot, aban nájuᵽo ni busana min akay mbaa mof mamu mo guvoge me Magadan. ");
INSERT INTO bqj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ᵽúrto, Eᵽárisie yay ni Esáduke yay n’gulof Yésu bi ebelol gabbut n’gurorenol bigitenum bo an ájuut akan, bajae egiten búoh aĉila n’émit náᵽullo. ");
INSERT INTO bqj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bare Yésu naagil : « Emít yay éjugen me tiname, n’juoh : “Gajem funah faaro.” ");
INSERT INTO bqj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mb’uĉiga m’bujom mej, éhuten me n’juoh : “Jama émit yay ᵽan elub.” Jújue effas ganogor gánogan gal émit gajugei me min til jújuut effas ugitenum waw wo Aláemit aamme n’ekan. ");
INSERT INTO bqj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Buru bugan bugagu bugaa jama jiarat, jíkanumut Aláemit mbiban jiŋese ejuh bigitenum bo an ájuut akan. Bare Aláemit mat’abbañ akanul n’jujuh bigitenum bice íni let babu babaj me Sonas. » No nalob me aban, nahalil to min akay. ");
INSERT INTO bqj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ñer Yésu ni ulagorol n’gújuᵽo ni busana gútiᵽ gulo gag’galam gaa fal fafu. N’ejail, ulagorol n’gújumor éjaenum mitiñay. ");
INSERT INTO bqj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yésu naagil : « Júludo ! Jíkanum lévir yay yal Eᵽárisie yay ni Esáduke yay ! » ");
INSERT INTO bqj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ñer ulagoraaw n’guᵽinor guoh : « Nalob mee mala min uŋallatal me unaĉ. » ");
INSERT INTO bqj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yésu naffas gaᵽinoril ban naagil : « Wa uĉile n’jibaj gaᵽinor mala gabajutul unaĉ ? Mo gáinenul gutitie ! ");
INSERT INTO bqj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bi maer jujogerut ? Juosenut unaĉ waw waamme futoh wagabori me bugan súuli futoh (5 000), ni utegel wono bu jimmeŋene ni búŋañen babu bala wo ? ");
INSERT INTO bqj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Juosenut ᵽoᵽ unaĉ waw waamme futoh n’úuba wagabori me bugan súuli sibbagir (4 000), ni utegel wono bu jimmeŋene ni búŋañen babu bala wo ? ");
INSERT INTO bqj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Min iogul mee jíkanum lévir yay yal Eᵽárisie yay ni Esáduke yay, bu jújuut jujoh gaa búoh let mala unaĉ nilobeul ? » ");
INSERT INTO bqj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ñer ulagoraaw n’gujoh búoh aagutil gulat lévir yay yacokore me unaĉ, bare til gúludo baligener babu bal Eᵽárisie yay ni Esáduke yay. ");
INSERT INTO bqj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yésu najow bi ni mof mamu maa Sesare yaa Fílip. No naĉih bo me, naah ulagorol : « Bugan bugagu guoge ay aamme Añol Arafuhow ? » ");
INSERT INTO bqj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","N’guogol : « Guce guoge aw Saaŋ Batis ; bugagu n’guoh aw Elí ; bugaguil n’guoh aw Séremi ter ace ni uboñer waw bugaa no. » ");
INSERT INTO bqj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naagil : « Ñer buru juoge ínje iomme ay ? » ");
INSERT INTO bqj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoŋ Ᵽier naagol : « Aw uomme Kirista ahu, Añol Aláemit aroŋ me. » ");
INSERT INTO bqj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ñer Yésu naagol : « Simoŋ añol Saaŋ, nubaje gásumay ! Uffas búoh let arafuhow agiteni maagen maumu, bare Ᵽayom aamme fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yaĉil me nivogi Ᵽier (dóemme \"fuval\"), ban ni fuval faufu nijae me eteᵽ Janguom. Hani eĉet yay faŋayo mat’éju yo eᵽiken bulago. ");
INSERT INTO bqj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ᵽan iseni síffaŋum Jávi jaju jaa fatiya : wo nujae me ehoh n’ettam, uhogihoh uban fatiya ; wo nujae me ejal n’ettam, ujalijal uban fatiya. » ");
INSERT INTO bqj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mbiban naĉaf ulagorol naagil jambi gugiten me an búoh aĉila aamme Kirista ahu. ");
INSERT INTO bqj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kábiriŋ funah faufu Yésu ávasul me agiten ulagorol búoh naate ajow bi Yérusalem, naate álam mámah ni búkanum ufan ésuh yay, ufan uteŋenaaw ni ᵽoᵽ úᵽajula gúboñ Aláemit bugagu, naate amugi, bare funah fúfatten ᵽan ailo ni gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ñer Ᵽier navogol guilo jolil, aban nailo avaborol naagol : « Ataw, Aláemit apoyi ! Waf wauwu mat’úmus ubaji ! » ");
INSERT INTO bqj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bare Yésu nábaho bi ni Ᵽier naagol : « Uᵽúr tale úraliom, Seytane ! Aw fújoten nom ni bulagoom. Baᵽinoreri bujaorut ni bal Aláemit, bare bal arafuhow bom. » ");
INSERT INTO bqj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mbiban Yésu naah ulagorol : « An amaŋ me alagenom, jambi abbañ aᵽinor mala fuhool : ateb ekuruaolm min alagenom. ");
INSERT INTO bqj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maagen, an amaŋ me eᵽagen buroŋol ᵽan ábbur bo ; bare an ábbur me buroŋol múmbam, ᵽan abaj buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wa ᵽan nafa an o babajer mof mamu ᵽoomo mbiban nábbur enogen ni buroŋ babu bábaerit me ? Wa nájue asen min aallor bo ? ");
INSERT INTO bqj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maagen mamu, Añol Arafuhow ᵽan ájoul ni gasal gagu ró gaa Ᵽayol n’emalakaol dó, ban no ñer ᵽan abbañen me ánoan ti nakan me ni buroŋol nogor. ");
INSERT INTO bqj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Maagen, ínje ilobul yo : guce ni gailo maa tale mati gutoh guĉet bugo m’bajugut Añol Arafuhow aĉigul ni Jáviol ró. » ");
INSERT INTO bqj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","No gunah futoh ni fanur gúgat me, Yésu naŋar Ᵽier, Saak ni atiol Saaŋ, min gúᵽur jolil gujow iki gujiŋ bi fatiya firijaŋ fice fabbage. ");
INSERT INTO bqj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","No guĉih ró me, enilol nébahen eŋar ganogor gace bújoŋoril : buulol m’buhat m’biij ti bunaa, bisimool m’bútuen par ti balleñer baa gajaŋa. ");
INSERT INTO bqj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","To baenah Móis ni Elí n’gúᵽullil ban n’gúni n’galolobor ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ñer Ᵽier naŋar firim fafu min aah Yésu : « Ataw, fubambaŋ min wóli jíni tale n’aw ; umaŋ me, ᵽan jiilen tale gúggut gúfaji, fanur bi n’aw, fafu bi ni Móis, fupafo bi ni Elí. » ");
INSERT INTO bqj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O n’elob yay, ni baj gávuh gajaŋe gúkail gúggubil gúharo, ban firim ni fúogul dó : « Dáure Añolom o níbboli me ; ésumayom ᵽe ni o yom. Mbi juuttenol ! » ");
INSERT INTO bqj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","No ulagoraaw guun me firim faufu, gáholi gámah n’gunonil bireg n’gulo gugubo. ");
INSERT INTO bqj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ñer Yésu nalofil, aban nagoril naagil : « Jiilo, jambi júholi ! » ");
INSERT INTO bqj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","N’gúarul gúĉilil ban n’gujuh to Yésu bare. ");
INSERT INTO bqj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","No guomme n’éavul ni firijaŋ fafu, Yésu naĉafil naagil : « Wo jujuh mee, jambi julob wo me an bi no Añol Arafuhow ajae me eilo ni gaĉet me ! » ");
INSERT INTO bqj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ᵽúrto, ulagoraaw n’guroren Yésu guogol : « Wa uĉile úᵽajula gúboñ Aláemit bugagu nihi guoh Elí naate amundum ábbañul ? » ");
INSERT INTO bqj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Naagil : « Maagen Elí aate ábbañul bi ebet waf waw ᵽe ni ganab. ");
INSERT INTO bqj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bare niegul Elí najoulo aban ban bugan bugagu gútalloutol min gukanol ti súmil me. Mamu may Añol Arafuhow ᵽan álam me ni guñenil. » ");
INSERT INTO bqj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","No ñer, ulagoraaw n’gútallo búoh mala Saaŋ Batis nalobeil mee. ");
INSERT INTO bqj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","No Yésu ni ulagorol gúfaji bugagu gubbanno me gutoh bo fítiman fafu, ni baj ace áine ájoul ak’alo aya gújulol bújoŋor Yésu naagol : ");
INSERT INTO bqj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","« Ataw, enili erum áᵽurom aloe me gaay ! Nálamelam nár, ban ñammeŋe naloelo ni sambun, ñañuño nalo ni mal. ");
INSERT INTO bqj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niŋallolŋar ik’isen ulagorai, bare gújuut gukanol nahoy. » ");
INSERT INTO bqj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ñer Yésu naah : « Jabbah je jaa bugan gabajut gáinen ! Ukana-galego we ! Bi nay ᵽan íni to ni buru nih’imutenul ? Jiŋallom tale añil ahu. » ");
INSERT INTO bqj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","No guŋallol o me, Yésu nannur eseytane yay ni sembe, ban néᵽur ni o min ahoy to baenah. ");
INSERT INTO bqj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ᵽúrto, ulagoraaw n’gúloful Yésu min gúᵽur jolil, mbiban n’gurorenol guoh : « Wa uĉile wóli jújuut jiham eseytane yauyu ? » ");
INSERT INTO bqj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Naagil : « Gáinenul gatiti mee guĉile. Maagen, ínje ilobul yo : jibajen me gáinen garee ti jukol fuyaba, ᵽan jújuen juoh firijaŋ faufua : “Utennor taute bi baaba,” ban ᵽan may fitennor ; mati baj uce wo mati júju jikan.  ");
INSERT INTO bqj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ban siseytane sasu sáni me mee, galaw ni baor bare sújue súᵽuren so ni an. » ");
INSERT INTO bqj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Funah fice, no Yésu ni ulagorol guomme tiñ tanur ni mof mamu maa Gálile, naagil : « Añol Arafuhow ᵽan abeni ni guñen gaa bugan ; ");
INSERT INTO bqj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ᵽan gukanol naĉet, bare funah fúfatten ᵽan ailo ni gaĉet me. » Ñer ni mujogil faŋ iki gúgogor. ");
INSERT INTO bqj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","No Yésu ni ulagorol guĉih me Kaᵽerinaum, bugan bugagu gayabe me búalen babu baa gávi-Aláemit n’gulof Ᵽier min guogol : « Afanul til nd’acam búalen babu baa gávi-Aláemit ? » ");
INSERT INTO bqj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naagil : « Nacamecam ᵽe. » No Ᵽier anogen me ni yaŋ yay, Yésu namundum aŋar firim fafu min arorenol aagol : « Simoŋ, aw bu nuᵽinor to ? Uvíaw bugaa mof ni bugay nihi guyab búalen, ni guñolil ter ni sijaora sasu ? » ");
INSERT INTO bqj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Naagol : « Ni sijaora sasu ! » Ñer Yésu naagol : « Kan guñolil gulet ni gaᵽin. ");
INSERT INTO bqj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bare jambi uyogenail, ujow uk’ubet gabbut ni fal ; juol jítiar jo nujae me ejoh, úŋabul butum jo : ᵽan utoh ró éralam. Uŋárul yo íkiil usenil butum ínje ni aw. » ");
INSERT INTO bqj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ni tinah tautu, ulagoraaw n’gulof Yésu min guogol : « Ay ñer gufaŋ me n’gujoge jálo dó ni Jávi jaju jaa fatiya ? » ");
INSERT INTO bqj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ñer návogul añil ace, aban nailenol n’etulil min aagil : ");
INSERT INTO bqj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","« Maagen, ínje ilobul yo : jihalut me bakanerul baarat mee min jibbañ jíni ti uñil, mati júmus junogen ni Jávi jaju jaa fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yo eĉil me, ánoan ajae me ealenoro ák’áni ti añil ahume, an ahumu ᵽan afaŋ me bugagu ᵽe dó ni Jávi jaju jaa fatiya, ");
INSERT INTO bqj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ban ánoan ayabe añil ti ahume ni gajow gúmbam, ínje faŋaom nayabe. » ");
INSERT INTO bqj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","« An ajae me ebet ni gatil hani ace ni miñil me gáinen me n’ínje, an ahumu hóimol guhogol fuval fámah n’ehondor guban n’gútimenol ni fal. ");
INSERT INTO bqj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mof mamu mimmeŋe mataño min waf waw wabele me bugan bugagu ni gatil ummeŋ dó me ! Maagen, ebet ni gatil yauyu eote ebaj ; bare mataño míni ni an ahu ajae me ebet apalol ni gatil. ");
INSERT INTO bqj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yo eĉil me ñer, íni me gañeni ter gaali ban guĉili min ulo ni gatil, uᵽirih go ban nubelen go gúralii ; hóimi unogen ni buroŋ babu bábaerit me n’gañen ganur ter gaat ganur, so n’ebaj guñen gúuba ter guot gúuba ban nubeni ni sambun sábaerit. ");
INSERT INTO bqj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mb’íni me jíĉili ban jiĉili min ulo ni gatil, úloĉ jo ban nubelen jo jíralii ; hóimi unogen ni buroŋ babu bábaerit me ni jíĉil janur, so n’ebaj go ᵽoogo mbiban nubeni ni sambun sasu sajeh mee. » ");
INSERT INTO bqj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","« Jíkanum jambi juĉotihen hani ace ni miñil me ! Niegul n’émit emalakail gapoyeil me gujugejuh nánonan buul babu baa Ᵽayom aam dó me n’émit.  ");
INSERT INTO bqj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maagen Añol Arafuhow najoulojow bi eᵽagen bugan bugagu gallim me. ");
INSERT INTO bqj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bu jiᵽinore ni dáure : Iní me an nabaje ubbarum wono ekeme, mbiban ganur ni wo n’gullim, mati ᵽiaŋ ahato ni gurijaŋ gagu wawu ᵽoowo min ake eliᵽ ganur gagu gallim me ? ");
INSERT INTO bqj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ban, ake me araŋen go, maagen, ínje ilobul yo, ᵽan ásumaet mala go faŋ mala wawu ᵽe wallimut me. ");
INSERT INTO bqj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Manur mamu, Ᵽayul aamme fatiya mo namaŋut me may anur ni miñil maume allim. » ");
INSERT INTO bqj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","« Iní me atii natile ni aw, ujow uk’utogol buru éubaul min ugitenol gatilol ; áttuni me, nuffas búoh nubajol atiay. ");
INSERT INTO bqj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bare alat me éttuni, uŋar an anur ter gúuba min jujow jutogol, mamu elob yauyu ᵽan ebaŋi jon bújoŋor bugan gúuba ter gúfaji gamate no elobei me. ");
INSERT INTO bqj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Alat me ᵽoᵽ éttunil, ugiten yo jangu yay, mbi ñer aroŋ me n’elat yay, ujogol ti an abajut gáinen, ti ayaba-búalen. ");
INSERT INTO bqj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Maagen, ínje ilobul yo : wo jijae me ehoh ᵽe n’ettam uhogihoh fatiya uban, ban wo jijae me ejal ᵽe n’ettam ujalijal fatiya uban. ");
INSERT INTO bqj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Injé ilobul yo itajen búoh : eno gúuba ni buru guunore n’ettam min gulaw waf, Ᵽayom aamme fatiya ᵽan asenil wo, ");
INSERT INTO bqj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","mata tánotan to bugan gúuba, gúfaji guomunore ni gajow gúmbam, ínje umu to n’etulil. » ");
INSERT INTO bqj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ñer Ᵽier nalof Yésu aban naagol : « Ataw, bi ñono butumbu niote iboket atiom o batiler n’ínje ? Ñono futoh ni ñáuba ? » Yésu naagol : ");
INSERT INTO bqj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","« Ioguti bi ñono futoh ni ñáuba, bare bi ñono úvi gúfaji ni guñen sono futoh ni súuba. ");
INSERT INTO bqj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Niegul ñer, Jávi jaju jaa fatiya jínini ti nihi baj me ávi amaŋe ánoan n’urokaol agiten ganew gay naogore ni o. ");
INSERT INTO bqj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No ávi ahu aalo me eᵽin yay, n’guŋallol arokaol ace aogenol síralam sammemmeŋ, súuli ni súuli. ");
INSERT INTO bqj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nemme aroka ahumu abajut bi ecam ganew gaugu, ávi ahu naboñ ban gunnomenol, aĉila, aarol ni guñolol, ni ᵽoᵽ wo nabaj me ᵽe, bi ecam ganeol. ");
INSERT INTO bqj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ñer aroka ahu nalo n’ettam, naya gújul bújoŋor ávi ahu, aban naagol : “Avíom, uboket uirigenom, ᵽan icami ᵽe wo niogeni me.” ");
INSERT INTO bqj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aví ahu enilol nerumol bireg naboketol ganew gagu ban nahalol nakay. ");
INSERT INTO bqj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","O n’éᵽurul dó yaŋ ávi ahu, aroka ahu najuh apalol aroka ace aogenol may síralam siman butum ekeme. Nagagol ban naagol : “Ucam wo nuogenom me.” ");
INSERT INTO bqj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Apalol ahumu nalo to n’guolol, aban nalaol aagol : “Uboket uirigenom, ban ᵽan icami.” ");
INSERT INTO bqj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bare aĉila amaŋut aun min til aŋarol ák’árur ni fipeh bi no najae me eban elugenol wo naogenol me. ");
INSERT INTO bqj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","No bugagu uroka gujuh me wabaj me, ni mujogil faŋ bireg n’gujow iki gulob yo ávi ahu. ");
INSERT INTO bqj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ñer ávi ahu naboñ guvogulol aroka ahumu min aagol : “Aw aroka aarat om ! Niboketiboket ganei ᵽoogo mata nulaomlaw gaboket. ");
INSERT INTO bqj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ujúenut may urum apali enil ti ínje irumi me enil ?” ");
INSERT INTO bqj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ñer ávi ahu ni bitiña-fiiñol nasenol úlatiena-bugan gúrur ni fipeh bi no najae me elugen ᵽe wo naogenol me. ");
INSERT INTO bqj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mamu Ᵽayom aamme fatiya ajae mee ekan ánoan ni buru o balaler eboket atiol ni biinum bakure. » ");
INSERT INTO bqj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","No Yésu aban me elob gurim gaugu, náᵽur Gálile ajow bi ni mof mamu maa Yúde maamme ñagagu fal fafu fo guvoge me Suruden. ");
INSERT INTO bqj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gútiman gámah n’gulagenol bi bo, ban nasen úsotail gahoy. ");
INSERT INTO bqj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ni baj Eᵽárisie gulofulol bi ebelol gabbut n’guogol : « Sesen ᵽiaŋ ánaine min aham aarol mala gabajor gánogan go gubajore ? » ");
INSERT INTO bqj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Naagil : « Buru jijangaut ni Bahiĉer babu búoh ni buju babu, no Aláemit átul me waf waw ᵽe, náuweuwen arafuhow áni ánaine ni anaare ? ");
INSERT INTO bqj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mbiban naah : “Yo eĉil me ánaine ᵽan áᵽur ahat ᵽayol ni jaol min ak’aĉin bugo n’aarol, ban ñer bugo gúuba n’gúbbañul gúni enil yanur.” ");
INSERT INTO bqj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mamu, mati gubbañ gúni bugan gúuba, bare an anur. Kan arafuhow jambi ñer áfaculor wo Aláemit ajogor me. » ");
INSERT INTO bqj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","N’guogol : « Ñer wa uĉile Móis nasen n’gúboñol gaa búoh mbi ánaine asen aarol gahait gal evis búyabo, mbiban náju ñer ahamol ? » ");
INSERT INTO bqj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yésu naagil : « Eakul uinum eĉile min Móis ájiul min júju jiham waarul, bare ni fíĉilum fafu níenut mee. ");
INSERT INTO bqj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Injé ilobul yo : ánaine aham me aarol mbiban nayab ace, íni let mala ekan wo búyabo bífiren me náhamumol, áine ahumu natile gatil gaa búyabo. » ");
INSERT INTO bqj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ñer ulagorol n’guogol : « Eno dáuru duomme gailo ánaine bi ni aarol, kan gayabut gufafaŋ jáari. » ");
INSERT INTO bqj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yésu naagil : « Let bugan bugagu ᵽe gújue guyab firim faufu, bare bugagu bugo Aláemit asen yo me, bugo bareil. ");
INSERT INTO bqj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Baje waf wammeŋe wájue uĉil ánaine nanamo to m’bayabut : guce súfurah gom kábiriŋ dó ni gar sijail ; bugagu ni bakaner baa bugan bugagu gúnium mo ; bugaguil gulalat búyab min mbi gúju gurok mala Jávi jaju jaa fatiya. An áju me ayab wo gurim gauge gulob me, ayab wo. » ");
INSERT INTO bqj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ᵽúrto, ni baj bugan gúŋarul uñil min mbi Yésu arembenil guñenol min alaw molil. Bare ulagoraaw n’gunamo ennuril. ");
INSERT INTO bqj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ñer Yésu naagil : « Jihat uñiaw n’gújoul mbal ínje ! Jambi jífirenil yo, mata Jávi jaju jaa fatiya bugan bugagu gáni me ti bugo guĉil jo. » ");
INSERT INTO bqj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Narembenil guñenol, aban náᵽur to akay. ");
INSERT INTO bqj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Funah fice, ni baj ace áine alof Yésu naagol : « Aligena-bugan ahu, maaro may níarie ikan min ibaj buroŋ bábaerit ? » ");
INSERT INTO bqj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yésu naagol : « Wa uĉile nurorenom mala waf waw wáari me ? An anur bare áarie. Eno maagen mamu numaŋe enogen ni buroŋ babu bábaerit me, úkanum gúboñ gagu. » ");
INSERT INTO bqj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naagol : « Gay go ? » Yésu naagol : « Jamb’umuh an ; jamb’ufilen anaare o jíyavut ; jamb’úkuet ; jamb’ubij uteh apali ; ");
INSERT INTO bqj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","úkanum ᵽai ni jai, ban núbboli apali ti núbboli me fuhoi. » ");
INSERT INTO bqj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aíne ahu naagol : « Dáuru ᵽe níkanumdokanum. Wa uroŋom bo ñer ekan ? » ");
INSERT INTO bqj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yésu naagol : « Umaŋ me úni an árire bújoŋor Aláemit, ujow uk’unnomen wo nubaj me ᵽe, uban nuŋar síralam sasu usen galeh me ; mamu ᵽan ubaj fubaj n’émit. Ukan mo, mbiban nújoul ulagenom. » ");
INSERT INTO bqj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","No áine ahu aun me gurim gaugu, ni mujogol ak’ailo ajow akay, mata fubaj fámah nabaje. ");
INSERT INTO bqj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ñer Yésu naah ulagorol : « Maagen, ínje ilobul yo : táñitañi nár asanum enogen ni Jávi jaju jaa fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nífaro iogul, faŋe ésum eñokombo enogen ni gasun éguje éᵽur babu asanum enogen ni Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","No ulagorol guun me gurim gaugu, n’gujahali faŋ bireg n’guoh : « Ay ᵽiaŋ ñer ájue ayab gaᵽah ? » ");
INSERT INTO bqj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yésu nalujil aban naagil : « Ni bugan bugagu dáuru júut kano, bare n’Aláemit waf waw ᵽe újue ukano. » ");
INSERT INTO bqj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ñer Ᵽier naŋar firim fafu min aagol : « Uluj, wóli hum ubuge min jihatulo wafóli ᵽe min jilageni, wa jijae to ñer ebaj ? » ");
INSERT INTO bqj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yésu naagil : « Maagen, ínje ilobul yo : no Añol Arafuhow ajae me erobo n’efenjeŋ yay yaa Jáviol, no waf waw ᵽe ujae me ébuyi, buru may jalagenom me ᵽan jurobo ni sifenjeŋ sono guñen ni súuba, ban ᵽan juogen guil gagu gaamme guñen ni gúuba gal Israel. ");
INSERT INTO bqj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ban ánoan ahale yaŋol, gutiol, gúlinol, ᵽayol, jaol, guñolol, ettamol múmbam, ᵽan ayab meŋ iki an mát’áju aᵽin. Ban ᵽoᵽ Aláemit ᵽan ajisol buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jiffas búoh gammeŋe ni bugan bugagu gaamme gútiar ᵽan gúbbañul gúni gúsola, ban may gammeŋe ni gaamme gúsola ᵽan gúbbañul gúni gútiar. » ");
INSERT INTO bqj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yésu natajen aah : « Jávi jaju jaa fatiya maa jínie : baje an ala ettam ace áᵽuraliulo tima naliᵽ uroka bi ni úbiñu waw wola. ");
INSERT INTO bqj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","No najuh me guce, najamor ni bugo bi ecamil bacam babu baᵽi me nihi bucami an aroke etufunaha ek’ebao lám, aban naboñil bi ni gafat gagu gal úbiñu waw. ");
INSERT INTO bqj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","No tinah titebulo me maa, náᵽurul ban najuh uroka guce min gunave ni furobo ésuh yay fámah, m’balet n’ekan wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Naagil : “Buru ᵽoᵽ jujow iki jurok n’gafat úbiñu waw úmbam, ban ᵽan isenul wájahor me ni burok ti bo.” ");
INSERT INTO bqj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ñer bugo may n’gukay mbal úbiñu waw. No tinah tirih me ni ᵽoᵽ no títigo me, afan ahu nabbañ áᵽurul ak’akan manur mamu ni uroka guce. ");
INSERT INTO bqj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tiname mul, nabbañ áᵽurul ban najuh mul uroka guce gurobo to m’balet n’ekan wáfowaf. Ñer naagil : “Wa uĉile n’jinamo tale iki tujon m’bakanut wáfowaf ?” ");
INSERT INTO bqj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","N’guogol : “Jibajut an aŋaróli burok.” Naagil : “Kan buru may jujow iki jurok ni gafat úbiñu waw úmbam.” ");
INSERT INTO bqj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","No nuĉiga me gállim, afan ahu naah afan urokaol : “Uvógul urokaaw min ucamil ; mb’újogumul n’úsola waw uk’uban n’útiar waw.” ");
INSERT INTO bqj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ñer gajoulo me tiname n’guĉigul ; n’guyab ánoan bacam babu bal an aroke funah. ");
INSERT INTO bqj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mb’uĉiga búsol, útiar waw n’guĉigul. N’gaᵽinoril ᵽan guyab faŋ to, bare may n’guyab ánoan bacam babu banur babu. ");
INSERT INTO bqj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","No ubuge guyab me guban ánoan bacamol, n’gúmumunor mala wo afan ahu akanil me, ");
INSERT INTO bqj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","bireg n’guogol : “Jíeh ! Usólaaw min gurok me ᵽiout, bare wóli jayoh me n’jijen kábiriŋ m’bujom bi gállim, nucamóli jireen ni bugo !” ");
INSERT INTO bqj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ñer afan ahu naah ace ni bugo : “Apalom, ikanuti waf wáhojie. Ujamoruta mala ecami bacam baa funah fanur ? ");
INSERT INTO bqj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Uŋar bacam ejeni min ujow. Injé imaŋe isen ásola ahu areen n’aw. ");
INSERT INTO bqj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ijúut ᵽiaŋ ikan ni fubajom wásumom me ? Ter ban ulujom jíĉil jaarat mala músum mo nísume ?” » ");
INSERT INTO bqj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bi éuñen búnogor babu, Yésu natajen aagil : « Mamu, úsolaaw ᵽan gúbbañul me gúni útiar, min útiar waw gúbbañul gúni úsola. » ");
INSERT INTO bqj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","No gulo me m’bulago bi ejow mbaa Yérusalem, Yésu navoh ulagorol gúᵽur jolil min aagil : ");
INSERT INTO bqj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","« Juutten, wolal ubugi n’ejow mbaa Yérusalem, ban Añol Arafuhow ᵽan abeni ni guñen ufan uteŋenaaw ni úᵽajula gúboñ Aláemit bugagu. Ᵽan gúrurol n’eĉet, ");
INSERT INTO bqj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ban ᵽan gubenol ni guñen gaa bugan bugagu galet me Esúif min mbi gúfohulorol n’gutegol gusoh ban n’gubbaŋol n’ekurua. Bare funah fúfatten ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ni tinah tautu, aar Sebede n’úᵽurol dó nalof Yésu, aban náñuᵽ bújoŋorol bi écinol waf uce. ");
INSERT INTO bqj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ñer Yésu naagol : « Wa numaŋe ikani ? » Aare ahu naagol : « Ulob gaa búoh úᵽurom ubuge gaam maa gúuba mbi gurobo to n’aw, ahu n’gañeni gárib, ahuo n’gamai, no nujae me erobo ni Jávii. » ");
INSERT INTO bqj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ñer Yésu naagol : « Buru jiffasut wa juom n’écin. Jújue ᵽiaŋ jirem éremuma yay yaa sílam yo ínje ijae me erem ? » N’guogol : « Ey, jújue jirem yo. » ");
INSERT INTO bqj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naagil : « Maagen, ᵽan jirem éremumaom ; bare mala erobo ni gáribom ni gamayom, yo, let ínje iĉil yo esen : gurobo gaugu gubaŋibaŋ bi ni bugo Ᵽayom acokor go me. » ");
INSERT INTO bqj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","No uᵽotoraaw bugagu gaamme guñen guun me gurim gaugu, súmutil ni batiay babu gaamme gúuba. ");
INSERT INTO bqj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ñer Yésu navogulil bugo ᵽe, aban naagil : « Jiffase búoh ufan súsuh sasu guogenesowogen ni sembe ró, bugan bugagu búgamah gúvafenevafen n’eogen so. ");
INSERT INTO bqj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jambi ní mo ni buru. Anóan ni buru amaŋ me gujogol an ámah, amundum áni aroka olul ; ");
INSERT INTO bqj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ánoan ni buru amaŋ me éni átiar, áni arokaul buru ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mamu may, Añol Arafuhow najoulo mee, let min mb’abaj umigel, bare til min mbi aĉila faŋaol áni amigel ban nasen buroŋol bi eallor buroŋ bugan gammeŋe. » ");
INSERT INTO bqj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","No Yésu ni ulagorol gúᵽur me ésuh yay yo guvoge me Sériko, fítiman fámah ni fulagenil. ");
INSERT INTO bqj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ni baj úpima gúuba garove n’galam bulago babu. No guun me búoh Yésu aam n’égat, n’guoh fatiya : « Ataw, Añol David, enili erumóli ! » ");
INSERT INTO bqj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bugan bugagu n’gunamo ennuril tima n’guᵽanor, bare bugo n’gufaŋ n’gúᵽibe fatiya guoh : « Ataw, Añol David, enili erumóli ! » ");
INSERT INTO bqj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ñer Yésu nailen, aban navogulil naagil : « Wa jimaŋe ikanul ? » ");
INSERT INTO bqj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","N’guogol : « Ataw, ukanóli min jibbañ jujuh. » ");
INSERT INTO bqj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Enilol nerumil min ñer agor gúĉilil. To baenah, úpimaaw n’gujuh, ban n’gunamo elagenol. ");
INSERT INTO bqj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","No Yésu ni ulagorol gulof me Yérusalem iki guŋanden ésuh yay yo guvoge me Betufage, yaamme n’gacaĉ firijaŋ fafu fo guvoge me fal uoliv waw, Yésu naboñ ulagorol gúuba guyabol gayoŋ naagil : ");
INSERT INTO bqj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","« Jujow bi n’ésuh yauyu yaamme gayoŋul ; jiĉih me, ᵽan jifaen jujuh asum yaare yo guhoge ni juñol yo ró ; jíjalul so jiŋallom. ");
INSERT INTO bqj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","An arorenul me, n’juogol : “Ataw asohola so.” To baenah, ᵽan ahalul n’jíŋarul so. » ");
INSERT INTO bqj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ban dáuru ᵽe dibabaj min mbi wo Aláemit alob me ni butum aboñer ahu ukano, no naah me : ");
INSERT INTO bqj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","« Juoh bugaa Sioŋ : Juluj, áviul umu ájaeul mee mbaa buru, abubi, min arembore ni asum, ni juñol asum, juñol ehaj yaᵽulene bíteb. » ");
INSERT INTO bqj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ñer ulagoraaw gaamme gúuba n’gukay ban ni gukan wo Yésu aboñil me. ");
INSERT INTO bqj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","N’gúŋarul asum yay ni juñol yo, guban n’guremben újuoil ni so, mbiban Yésu narembor ni wo. ");
INSERT INTO bqj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gammeŋe ni fítiman fafu ᵽoᵽ n’gutal újuoil ni bulago babu ; guceil n’gúfaĉul uan n’ununuh waw gutalen ni bulago babu. ");
INSERT INTO bqj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ñer bugan bugagu ᵽe gátinene me Yésu, újogum ni gayab me gayoŋ bi ni garukeneol me, nihi guya uŋan guoh : « Hosanna, usalal añol David ! Aláemit ásonien an ahu ájaeul me ni gajaol ! Hosanna bi ró fatiya ! » ");
INSERT INTO bqj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","No Yésu anogen me Yérusalem, ésuh yay ᵽe negoror bireg bugan bugagu nihi guroren guoh : « Bare dáuru ay aamme ? » ");
INSERT INTO bqj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","N’guogil : « Dáuru Yésu, aboñer ahu áᵽullo me Nasaret babu Gálile. » ");
INSERT INTO bqj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ᵽúrto, Yésu nanogen ni gávi-Aláemit gagu. No naĉih ró me, naham unnomenaaw ni unnomaaw ᵽe gaamen dó me, narikul muĉag utita-síralam bugagu ni sujukut sasu sal unnomena sitalab bugagu. ");
INSERT INTO bqj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aban naagil : « Aláemit naage ni Bahiĉer babu : “Yaŋom ᵽan guvoh yo yaŋ yaa galaw.” Bare buru n’jíbahen yo éni fíemorum fal úku. » ");
INSERT INTO bqj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mbiban, ni baj úpima ni bugan gahaje gujow gutogol to naamme dó ni gávi-Aláemit gagu, ban nasenil gahoy. ");
INSERT INTO bqj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bare ufan uteŋenaaw ni úᵽajula gúboñ Aláemit bugagu, no gujuh me waf wauwu wajureruti mee wo nakan me ni ᵽoᵽ uñiaw gaŋane ró me nihi guoh « Hosanna Añol David », ni mujogil ");
INSERT INTO bqj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","bireg n’guogol : « Nuune wo uñiaw ubugi gulobe ? » Yésu naagil : « Ey, niune. Júmusut jijanga gurim gagu gaah me : “Nukane min gasali gúᵽurul n’utum uñiaw, hani ni waa uñil-guboŋ” ? » ");
INSERT INTO bqj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mbiban nahalil to min áᵽur ésuh yay ajow bi Betani ak’akan bo efuga yay. ");
INSERT INTO bqj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tihalen fo ni bujom, no Yésu ábbañeul me mbaa Yérusalem, bieb m’bujogol. ");
INSERT INTO bqj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O n’éjoul yay, najuh bífig galam bulago babu ; najow bi to, aĉih natoh ró utoj barebare. Ñer naah bo : « Bae, mati ñer ubbander ubuh mitiñ bi nánonan ! » Ban to baenah, bífig babu m’bullab buhay kak. ");
INSERT INTO bqj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","No ulagoraaw gujuh me dáuru, n’gujahali bireg n’guoh : « Bare bu jáorum me bífig babu m’bufaen buhay to baenah ? » ");
INSERT INTO bqj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ñer Yésu naagil : « Maagen, ínje ilobul yo : íni me jibaje gáinen mbiban jitehumorut, let wabaj me bífig baubu bare ᵽan júju jikan, bare ᵽoᵽ juoh me firijaŋ faufu : “Utennor to nuomme uk’ulo ni fal !” Ᵽan kano. ");
INSERT INTO bqj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wáfowaf wo jijae me écin ni galaw ni gáinen dó, ᵽan jiyab wo. » ");
INSERT INTO bqj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ᵽúrto, Yésu najow bi ni gávi-Aláemit gagu. No naamme n’eligen bugan bugagu, ufan uteŋenaaw ni ufan Esúif yay n’gúkail guogol : « Ni sembe say nukane mee waf wauwu ? Ay aseni so ? » Yésu naagil : ");
INSERT INTO bqj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","« Injé may ban irorenul eroren yanur pat, ban íni me jíbalom, ᵽan may ilobul ni sembe say nikane mee waf wauwu. ");
INSERT INTO bqj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoo, sembe sasu saa gábatise so Saaŋ Batis abaj me, bay súᵽullo : n’Aláemit ter ni an ? » N’gunamo ébahulor bugo bareil guoh : « Uogal me n’Aláemit sujoumulo, ᵽan aagolal : “Ñer wa uĉile jíinenut ni o ?” ");
INSERT INTO bqj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ban may uogal me ni an sujoumulo, haa... ! Fítiman fafu ᵽan fúbbañul bi ni wolal, mata bugo ᵽe gujojoh Saaŋ ti aboñer. » ");
INSERT INTO bqj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ñer n’guoh Yésu : « Wóli jiffasut. » O may naagil : « Kan ínje may mat’ilobul ni sembe say nikane mee waf wauwu. » ");
INSERT INTO bqj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mbiban Yésu naagil : « Aᵽaa julobom : Baje ace áine abaje úᵽur gúuba. Naah átiar : “Añúm, jama ujow uk’urok ni galagom.” ");
INSERT INTO bqj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naagol : “Imaŋut,” bare búsol nateh mahat min ajow. ");
INSERT INTO bqj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nábaho mbal áutten ahu nalobol elob yay yanur yay. Ahume naagol : “Ᵽayom, nimaŋe, ᵽan ijow,” bare aban akait bo. ");
INSERT INTO bqj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ni buru ñer, ay ni bugo gúuba akane wo ᵽail amaŋ me ? » N’guogol : « Atíar ahu. » Ñer Yésu naagil : « Maagen, ínje ilobul yo : uyaba-búalen bugagu ni sujobu sasu ᵽan guyabul gayoŋ ni Jávi jaju jal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maagen Saaŋ Batis najoulo mbaa buru bi egitenul bulago babu baĉol me, bare buru jíinenutol. Uyaba-búalen bugagu ni sujobu sasu, bugo gúinenolyinen, ban buru jamat yo me hani búsol jitegut mahat min jíinen ni o. » ");
INSERT INTO bqj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yésu natajen aah : « Juutten ᵽaa mul búnogor be : Baje ala ettam ace aroge úbiñu. Nasoen wo aban nacokor dó tiñ tal epucen bíñu yay, mbiban nateᵽ ró etah yaa gapoy. No naban me, nábahen úbiñu waw asen ucokora-bíñu guogen mbi nihi gúᵽunnol fugabol, min aĉila ake bújaor. ");
INSERT INTO bqj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","No tinah tulofulo me tal ealen mitiñ mamu, naboñ urokaol bi ni gaogen me úbiñu waw bi éyabul fugabol. ");
INSERT INTO bqj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bare ucokora-bíñu bugagu n’gujoh urokaaw, n’guteh átiar, áutten n’gumugol, áfatten, o, n’gutegol sival ak’aĉet. ");
INSERT INTO bqj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ala gafat gagu nabbañ aboñ uroka guce gafaŋe jammeŋ útiar waw. Bare gaogen me úbiñu waw n’gukanil manur mamu. ");
INSERT INTO bqj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Búsol, naboñ áᵽurol mbaa bugo ni gaᵽinor gagu ró gaa búoh nemme añolol om, ᵽan gúkanumol. ");
INSERT INTO bqj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bare no gujuh me áᵽur ahu o n’éjoul, n’guogoro : “Umu aĉil me gafumol. Ujaal umugalol, mamu gafumol ᵽan gúbbañul gúni gololal.” ");
INSERT INTO bqj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ñer n’gujogol gúful gúᵽuren tíyaŋ gafat gagu, guban n’gumugol. ");
INSERT INTO bqj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ñer maer ban irorenul : no ala gafat gagu ajae me éolul, bu najae me ekan ubugu gaogen me úbiñu waw ? » ");
INSERT INTO bqj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","N’guogol : « Ᵽan amugil hóji, bugan bugaubugi gaarat mee, aban ᵽan ábahen gafat gagu asen uroka guce guogen, gajae me esenol fugabol mitiñ mamu baaler. » ");
INSERT INTO bqj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yésu nabbañ aagil : « Baje Bahiĉer baage : “Ebírih yay yo uteᵽaaw gujunden me, yo ebbanno me éni yáamumma, yaĉil me yaŋ yay. Dó ᵽe búkanum bal Ataw ; ban ni wolal kakan waf wámah.” Bahiĉer baubu, júmusut jijanga bo ? ");
INSERT INTO bqj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yo eĉil me, ínje ilobul yo : Aláemit ᵽan aram Jáviol ni buru ábahen asen bugan guce gajae me eroŋ buroŋ bájahore.  ");
INSERT INTO bqj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Anóan ajae me eloŋen ébirih yauyu ᵽan alebbor, ban may ánoan o ejae me elo ni o, ᵽan epulujol. » ");
INSERT INTO bqj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","No ufan uteŋenaaw ni Eᵽárisie yay guun me únogor wauwu wo Yésu alob mee, n’guffas búoh molil nalobe mee ; ");
INSERT INTO bqj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ñer n’gumaŋen ejogol, bare n’gúholi fítiman fafu, mata bugan bugagu gujogoljoh ti aboñer. ");
INSERT INTO bqj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yésu nabbañ aŋar búnogor nalob ni bugo naagil : ");
INSERT INTO bqj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","« Jávi jaju jaa fatiya maa jínie : baje ávi ace aam n’ekan gaggan búyab áᵽurol. ");
INSERT INTO bqj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aví ahumu naboñ urokaol guke évogul bugan bugagu bugo nalob me búyab babu ; bare n’gulat éjoul. ");
INSERT INTO bqj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nabbañ aboñ uroka guce iki guoh gavogi me : “Nísile iban ; síbeom ni sihajom safat me sumugi siban, waf waw ᵽe úrire, jújoul bi fitiñ fafu !” ");
INSERT INTO bqj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bare gavogi me gúkanumut gavoh gagu min til gujow bulagoil gukay, ahu mbaa galagol, ahuo mbaa funnomenol, ");
INSERT INTO bqj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","bugaguil n’gujoh uroka ávi ahu gúlatien guban n’gumugil. ");
INSERT INTO bqj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ñer ávi ahu fiiñol ni fitiñ min aboñ ekosombilol iki gunemen umuga-bugan bugaubugi, guban n’guremen ésugil. ");
INSERT INTO bqj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aban naah urokaol : “Esíl yay ebae, bare gavogeni me gutogut eyab gavoh gaugu. ");
INSERT INTO bqj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jujow ñer bi n’újalingenor ulago waw, ban ánoan o jijae bo me ejuh juvogulol ákail fitiñ fafu.” ");
INSERT INTO bqj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ñer urokaaw n’gutey ulago waw ᵽe iki gúomenul bugan bugagu ᵽe bugo gutoh bo me, gáari me ni gaarat me, ban baŋ babu baa fitiñ fafu ni bimmeŋ kab bugan. ");
INSERT INTO bqj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","No ávi ahu anonulo ró me bi ejuh sijaoraol, naŋanden dó ace áine asimoe bisimo balet baa gaggan gaugu. ");
INSERT INTO bqj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Najow ak’atogol to naagol : “Abugeom, aw bu nunonulo dáre aw m’basimout bisimo baa gaggan gauge ?” Aíne ahu butum bilet. ");
INSERT INTO bqj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ñer ávi ahu naah urokaol : “Jujogol, juhoh guñenol ni guolol, mbiban n’júᵽunnol jibelen tíyaŋ n’emoĉ yay baamme ukoŋ ni ejoh émiremma.” » ");
INSERT INTO bqj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bi éuñen búnogor babu, Yésu natajen aagil : « Ey, gammeŋe guvogi, bare bugan guman guĉobi. » ");
INSERT INTO bqj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ᵽúrto, Eᵽárisie yay n’gujoj bi ejuh bu gujae me ekan min gujoh Yésu ni baloberol. ");
INSERT INTO bqj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ñer n’guboñ guce n’ulagorail bi ni o, manur ni guce bugaa gayoŋ gagu gaa Herod. No guĉih me, n’guogol : « Afanóli, jiffase búoh aw an om ala maagen, ban nuligeneligen bulago Aláemit ni maagen dó m’báhollut ánoan, mata ulujérit ni uul bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ulobóli ᵽaa ñer ter sesen min búalen bucami ávi ahu ámah ahu Sesar. » ");
INSERT INTO bqj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bare nemme Yésu naffase gaᵽinoril gaarat mee, naagil : « Bugan ge gálodit maagen, wa uĉile n’jimaŋ eralom gabbut ? ");
INSERT INTO bqj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jiŋallom ᵽaa éralam yay yo nihi jiŋar me n’jicam búalen babu ! » N’guŋallol yanur. ");
INSERT INTO bqj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Narorenil aagil : « Buul baube ni gajow gauge sal ay ? » ");
INSERT INTO bqj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","N’guogol : « Saa Sesar. » Ñer naagil : « Kan jisen Sesar wafol, ban may jisen Aláemit waamme wola. » ");
INSERT INTO bqj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","No guun me bábaler Yésu, n’gujahali bireg n’guhalol to min gukay. ");
INSERT INTO bqj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Funah fafu fanur fafu, ni baj Esáduke guce gujow iki gutoh Yésu. (Esáduke yay bugo nihi guoh me an aĉet me aban mat’ailoul n’eĉet yay.) ");
INSERT INTO bqj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","N’guogol : « Afanóli, gúboñ gagu gaa Móis guoge an ayab me anaare mbiban naĉet ajundenol o m’babajut añil, atiol ᵽan atunol min áju ahalol gátuh. ");
INSERT INTO bqj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yoo. Bajene ni wóli batiay baa wáine gono futoh ni gúuba. Atíar nayab aban naĉet. Nemme ahalut añil, atiol áutten natunol. ");
INSERT INTO bqj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aútten ahumu atunol me naĉet may m’babajut añil, áfatten ahu may mo, mamu bi ni akan me futoh ni gúuba. ");
INSERT INTO bqj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","No gubao me bugo ᵽooil, aare ahu may naĉet. ");
INSERT INTO bqj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ban ñer juroreni : no gaĉet me gujae me eilo, aare ahumu ᵽan ñer áni ala ay ni batiay babu baamme futoh ni gúuba, nemme bugo ᵽe gutoge guyabol ? » ");
INSERT INTO bqj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yésu naagil : « Buru jilimbe, dó ᵽe mata jujogut wo Bahiĉer babu bulobe, jujogut ᵽoᵽ bu sembe Aláemit siree. ");
INSERT INTO bqj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Maagen mamu, no gaĉet me gujae me eilo, ánaine mat’ayab, anaare mát’áyabo ; ᵽan til gúni ti emalakaay dó n’émit. ");
INSERT INTO bqj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mala eilo yay ni gaĉet me yo juunene mee, jijangaut ᵽiaŋ wo Aláemit alobul me ? Naage hum : ");
INSERT INTO bqj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Injé iomme Aláemit ahu o Aburaham, Isak ni Sakob gúinen me ni o.” Yo eĉil me jiffas búoh Aláemit alet ala gaĉet me, bare til ala garoŋ me. » ");
INSERT INTO bqj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ñer fítiman fafu ᵽe n’fimero baligener baubu baa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","No Eᵽárisie yay guun me búoh Yésu natotoj Esáduke yay utum, n’gujoj, ");
INSERT INTO bqj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","mbiban ace ni bugo, an abaje gaffas faŋ ni gúboñ gagu gal Aláemit, nak’aroren Yésu bi eralol gabbut naagol : ");
INSERT INTO bqj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","« Afanom, gáboñ gagu gafaŋ me wawu ᵽe, go guomme gay ? » ");
INSERT INTO bqj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yésu naagol : « Umaŋ Ataw aamme Aláemili n’éĉigiri ᵽe, ni biinumi ᵽe ni ᵽoᵽ ni gaᵽinori ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Go guomme gátiar, ban go gufaŋe gájalo. ");
INSERT INTO bqj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gáutten gagu uge, gabaj me may hámma ti go : “Ubbóli apali ti núbboli me fuhoi.” ");
INSERT INTO bqj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ubóñ wauwe waamme úuba úhage wo gúboñ gagu ᵽe ni uboñer waw gulob me. » ");
INSERT INTO bqj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nemme Eᵽárisie yay guomunorwomunor, Yésu narorenil eroren yauye : ");
INSERT INTO bqj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","« Wa jiᵽinore ni Kirista ahu ? Añol ay nam ? » N’guogol : « Añol David. » ");
INSERT INTO bqj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ñer Yésu naagil : « Bu jáorum me ñer David, ni búkanum baa Biinum Banabe, navogol \"Ataom\", no naah me : ");
INSERT INTO bqj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ataw Aláemit naage Ataom : Unamo ni gañenom gárib, bi no nijae me érur ulatori fattam uhagi” ? ");
INSERT INTO bqj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nemme David navogol \"Ataw\", bu Kirista ájue ñer áni Añol David tíj to ? » ");
INSERT INTO bqj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bajut an ájue ábalol hani firim fanur. Kábiriŋ funah faufu, an akañenut abbañ arorenol waf. ");
INSERT INTO bqj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ᵽúrto, Yésu nábaho mbaa fítiman fafu ni ᵽoᵽ ulagorol naagil : ");
INSERT INTO bqj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","« Uᵽájula gúboñ Aláemit bugagu ni Eᵽárisie yay, burokil bo buomme éᵽajul gúboñ gagu go Móis asen me. ");
INSERT INTO bqj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yo eĉile wáfowaf wo gujaeul me elob, jikan wo, ban n’jíkanum wo. Bare bakaneril, bo, jambi jilagen bo, mata gukanérit wo gulobe me. ");
INSERT INTO bqj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nihi gusekor bíteb báliie guremben n’uban bugan bugagu, ban bugo faŋail hani jisigil janur mati jirambenil n’gúarul bo. ");
INSERT INTO bqj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","N’gukane mee ᵽe min mbi bugan bugagu gujugil. Múhut mamu dó bugan bugagu gukane me gurim Aláemit guhoh n’gúringil ni subosohil, molil gukan mo mufaŋ gájalo, ban gutajene útar újuoil ufaŋ gahuli. ");
INSERT INTO bqj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nihi gumamaŋ erobo ni sujukut sasu sáamumma gaggan babajer, gumaŋemaŋ ᵽoᵽ enamo ni sujukut sasu saa gayoŋ ni saŋ sasu saa galaw. Ban may gumaŋemaŋ bugan bugagu nihi gusafil ni jammeŋ ni gákanum ró, ");
INSERT INTO bqj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","nihi ᵽoᵽ guvogil \"ufanóli\". ");
INSERT INTO bqj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bare buru, jambi jihalil n’guvogul \"ufanóli\", mata an anur pat o aamme Afanul, ban buru ᵽe batiay jom. ");
INSERT INTO bqj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jambi juvoh ánoan babe ni mof \"Ᵽayóli\", mata Ᵽaaya anur pat jibaje, aamme fatiya. ");
INSERT INTO bqj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jambi jihat me bugan bugagu n’guvogul \"úĉibbenaoli\", mata Aĉíbbena anur pat jibaje, o aamme Kirista ahu. ");
INSERT INTO bqj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","An ahu afaŋ me gájalo ni buru ᵽan áni arokaul. ");
INSERT INTO bqj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","An atebenoro me, ᵽan aaleni ; an aalenoro me, ᵽan atebeni. » ");
INSERT INTO bqj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","« Mataño míni ni buru, úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Jutojetoj bugan bugagu gánonum Jávi jaju jaa fatiya ; jilet ró n’enogen, mbiban jilet mul n’ehat gamaŋ me n’gunogen dó.  ");
INSERT INTO bqj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mataño míni ni buru, úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Jujogejoh utiña-sibara bugagu n’jiram wafil ᵽe, mbiban n’jiilo jilaw huli min bugan bugagu gujugul ; úru dijae me eĉil min jiyab gúteh gafaŋe n’gúliie. ");
INSERT INTO bqj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mataño míni ni buru, úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Ᵽan nihi jitey mof mamu ᵽoomo ni gal gagu ᵽoogo bi éñagul an anur júrur ni bulagoul, mbi jibajol me jiban, n’jíbahenol afaŋ ñono ñáuba gaarat buru, áni ñer an ajae elo ni sambun sasu sajeh mee sábaerit me. ");
INSERT INTO bqj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mataño míni ni buru, úĉibbena-e gápipim ! Buru nihi juoh : “An abbat me ni gajow gaa gávi gagu gal Aláemit, let wáfowaf ; bare abbat me ni gajow éurus yay yaa gávi gagu gal Aláemit, gabbatol gubaje hámma.” ");
INSERT INTO bqj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Min júguno me ban ni jípim ! Eúrus yay ni gávi gagu gáñaien yo me, yay ni so efaŋe gájalo ? ");
INSERT INTO bqj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Juoge bae mul : “An abbat me ni gajow gaa físimenum fafu, let wáfowaf ; bare an abbat me ni gajow gaa warembeni ró me bi éji Aláemit, gabbatol gubaje hámma.” ");
INSERT INTO bqj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Upíma-e ! Warembeni me ᵽe ni físimenum fafu bi éji Aláemit, ni fiĉila faŋafo fáñaien wo me, yay ni so efaŋe nebaje hámma ? ");
INSERT INTO bqj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","An abbat me ni gajow gaa físimenum fafu, ni gajow fo nabbate, fo ni warembeni ró me ᵽe ; ");
INSERT INTO bqj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","an abbat me ni gajow gaa gávi gagu gal Aláemit, ni gajow go nabbate, go ni gal Aláemit aĉin dó me. ");
INSERT INTO bqj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","An ᵽoᵽ abbat me ni gajow gal émit, nabbabat ni gajow gal efenjeŋ yay yal Aláemit ni gal aĉila faŋaol arobo ró me. ");
INSERT INTO bqj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mataño míni ni buru úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Nihi júᵽuren jisen Aláemit gakib ganur ni wono guñen ni wánowan bi ni wafaŋ me gamis wo juroge me n’ufalul, mbiban n’jihabo til wafaŋ me n’ubaje hámma ni gúboñ gagu waamme : ekan waĉol me, éju ñarum enil ni ebaj gáinen. Dáuru til juoten me jumundum jikan balama jike ekan uce úbuli. ");
INSERT INTO bqj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Uĉíbbena-e gápipim ! Buru nihi jiyeh juhola min til jímer eñokombo ! ");
INSERT INTO bqj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mataño míni ni buru úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Jínini ti síremuma ni uril sakure búsol so bare, ban ñáraruul gaᵽinorul ᵽe gákuet ni égotor waf bugan. ");
INSERT INTO bqj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Aw Aᵽárisie ahu ápim me, umundum ukuren ñáraru éremuma yay ni biril babu, mamu búsol so may ᵽan bukur. ");
INSERT INTO bqj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mataño míni ni buru, úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Jínini ti guyah go gulose tíyaŋ go túen uluj ni wári, bare ñáraru go gummemmeŋ suvul ni maᵽule mánoman. ");
INSERT INTO bqj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Buru mo jínie : gulujul me, n’gujogul bugan gaĉole, bare ñáraruul jibij ni búlaᵽut bare. ");
INSERT INTO bqj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mataño míni ni buru, úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay jálodit mee maagen ! Nihi jiteᵽ guyah uboñer waw, n’jísangen gaa bugan bugagu gaĉol me, ");
INSERT INTO bqj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","mbiban n’juoh : “Iníen me jimatene no sipayóli guomme m’buroŋ, mati jibbañen búsolil n’éyu físim uboñer waw.” ");
INSERT INTO bqj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mamu hum buru juom mee n’eheb gaa búoh buru guñol bugan bugagu gamuh me uboñer waw jom. ");
INSERT INTO bqj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jifaben hum burok sipayul ! ");
INSERT INTO bqj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sunuhunjaŋ se, gabugor ge gaa súᵽudum ! Bu jijae etey gúteh gagu gaa sambun sasu sábaerit me ? ");
INSERT INTO bqj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yo eĉil me ᵽan iboñulul uboñer, bugan galilloe ni uligena-bugan bugaa maagen, bare ᵽan jumuh guce ni bugo, bugagu ᵽan jibbaŋil ni sukurua, bugaguil, bugo, ᵽan jitegil gusoh gal ubaŋ ni saŋ sasu saa galaw solul, ban ᵽan jihatoril ésuh bi n’ésuh. ");
INSERT INTO bqj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mamu físim fafu ᵽe faa bugan bugagu gakanut me waf ᵽan fulo ni buru ; físim faufu fúuyo me ni mof mamu, újogum ni fal Abbel aamme an aĉole bi ni faa Sakari, añol Berekia, o buru jumuh me ñáraru gávi-Aláemit gagu, n’etut físimenum fafu ni tiñ talu táñai me. ");
INSERT INTO bqj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Maagen, ínje ilobul yo : gúteh gagu gaa maarat mamu ᵽe mo sipayul gufan gukan me ᵽan gulo ni buru bugaa jabbah je. » ");
INSERT INTO bqj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mbiban, Yésu náfaro aah : « Yérusalem, Yérusalem, aw amuge me uboñer waw, aw o nuh’uteh me sival bugan bugagu bugo Aláemit áboñeul me bi n’aw, iki guĉet : ñono butumbu nilige eomen bugani gulofom ti ehulol neh’eguben me bapu yo n’ubes yo ! Bare buru júmusut jimaŋ ! ");
INSERT INTO bqj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jíkanum, Aláemit ᵽan ajunden yaŋ yay yolul éni eᵽa erakel. ");
INSERT INTO bqj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Injé ilobul yo : mati jibbañ jujugom bi no jijae me eoh : “Aláemit ásonien an ahu ájaeul me ni gajow gola !” » ");
INSERT INTO bqj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","No Yésu aamme n’éᵽurul ni gávi-Aláemit gagu bi ekay, ulagorol n’gulofol bi emalen bateᵽer babu bala go. ");
INSERT INTO bqj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bare aĉila naagil : « Jujuge dáuru ᵽe ? Maagen, ínje ilobul yo, funah fice mati ŋaño to eval yanur yájutenore n’epayo, bare so ᵽe ᵽan sirikuli sibet. » ");
INSERT INTO bqj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mbiban najow bi ni firijaŋ fafu fal uoliv waw ak’arobo ró. Ulagoraaw n’gulagenol bugo bareil iki gutogol bo n’guogol : « Aᵽaa ulobóli, nay dáuru dijae ebaj, ban wa ujae egitenóli búoh aw umu n’ébbañul, gabao mof guĉige ? » ");
INSERT INTO bqj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yésu naagil : « Jíkanum jambi an abutul ! ");
INSERT INTO bqj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gammeŋe ᵽan gúoᵽoroul gajaom guĉigul n’guogul : “Injé iomme Kirista ahu.” Ban ᵽan gubut bugan gammeŋe. ");
INSERT INTO bqj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ᵽan juun baeler gutih ni balober buunen go. Jambi jitelenor : dó díarie diĉigul, bare mati ní ᵽan gabao mof mamu. ");
INSERT INTO bqj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Esúh ᵽan eiyul bi n’epayo ésuh, jávi ᵽan jiiyul bi ni jipajo jávi ; ᵽan baj bieb n’ulam uce, babubo mof mamu ᵽan mugoror bo. ");
INSERT INTO bqj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dáuru ᵽe ᵽan níme ᵽan buju babu baa sílam sasu ; sílam sausu ᵽan síni ti sal anaare aam ni gapegor. ");
INSERT INTO bqj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","No ñer ᵽan gúlatienul, ᵽan gumugul, ban gajaom ᵽan guĉil min súsuh sasu ᵽooso silalul. ");
INSERT INTO bqj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dáuru ᵽan dípegul me bugan gammeŋe ganegen gal ebbañ búsol ; ᵽan gunnomenor, ᵽan bugan-ó-bugan n’gujoh gupalil búlat. ");
INSERT INTO bqj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Uboñer gammeŋe galet bugaa maagen ᵽan gúᵽurul, ban ᵽan gubut bugan gammeŋe. ");
INSERT INTO bqj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Min búlaᵽut babu bujae me efaŋ m’bimmeŋe, mo may gábboli gagu gaa bugan gammeŋe gujae me ékasulo. ");
INSERT INTO bqj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bare an ajae me emuten iki bao, Aláemit ᵽan aᵽagenol. ");
INSERT INTO bqj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ban firim faufe fásum me faa Jávi Aláemit ᵽan fuvarei ni mof mamu ᵽoomo, min mbi súsuh sasu ᵽe suun fo. Bao me, no ñer gabao gagu gujae me eĉigul. ");
INSERT INTO bqj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jiffase wo aboñer ahu Dañel alobe ni Bahiĉer babu mala \"Maarat mamu mal ekan galego\" ; ajanga wo me mb’ákanum faŋ wa Bahiĉer baube bumaŋe elob ! No maarat maumu mujae me enogen tiñ talu táñai me, ");
INSERT INTO bqj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","no ñer gajae me éni ni mof mamu maa Yúde mbi gutey me bi ni gurijaŋ gagu. ");
INSERT INTO bqj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","An ajae me éni fatiya firihinjaŋ, jamb’áavul me aban naah ban amundum ake eŋar waf uce ñáraru yaŋol. ");
INSERT INTO bqj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","An ᵽoᵽ áni me n’ulah waw, jamb’aot me ake eŋar bisimool. ");
INSERT INTO bqj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mataño míni ni waareaw gajae me éni ni gar ni ᵽoᵽ ni bugagu gajae me éni n’garafen ni gunah gaugu. ");
INSERT INTO bqj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jilaw jambi eteyul ekan ñutot ñañu baĉigerul, ter funah faa fíiyay, ");
INSERT INTO bqj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","mata ᵽan baj sílam sáamah, so músut baj sice ti so kábiriŋ m’buju babu baa mof bi funah faa jama, ban ᵽoᵽ sañumut ebbañ sibaj ñice sitajen. ");
INSERT INTO bqj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ban, lelen me búoh Aláemit nákasulkasul gunah gaugu, an mat’aᵽah ; bare nákasul go mala bugo naĉob me. ");
INSERT INTO bqj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","An ñer aagul me Kirista ume ter umua, jambi jíinenol. ");
INSERT INTO bqj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ᵽan baj ukirista ni ᵽoᵽ uboñer galet bugaa maagen ; ᵽan gukan ugitenum wámah ni waf wajureruti bi elimben bugan bugagu bugo Aláemit aĉob me, ínien me júe kano. ");
INSERT INTO bqj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nílobaliul yo ihato. ");
INSERT INTO bqj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Guogul me ñer : “Kirista ahu umu babu ni gafit gámah,” jambi jike bo ; guogul me may : “Umu tiñ timan ni makoᵽe,” jambi jíinen yo. ");
INSERT INTO bqj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jiffas búoh ti émit neh’eijul me bo tinah túᵽureul me bi bo tuloe me, mo may ébbañul yay yal Añol Arafuhow ejae me éni. ");
INSERT INTO bqj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tánotan to efuluŋ yay ejae me éni, to may súgutum sasu sijae me eomunor. » ");
INSERT INTO bqj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","« Gunah gaugu gaa sílam go n’ebao tak, bunaa babu ᵽan bumoĉ, fieñ fafu ᵽan fúbbur gaŋanno gagu gala fo, suut sasu ᵽan sísarul fatiya émit súloul, ban sembe sasu ᵽe saa fatiya ᵽan sugoror. ");
INSERT INTO bqj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","No ñer ᵽan baj bigitenum búᵽurul n’émit yay bajae egiten búoh ébbañul yay yal Añol Arafuhow eĉige. Súsuh sasu ᵽe saa mof ᵽan sufotenor, ban ᵽan sujuh Añol Arafuhow áavul ni gápar émit, ni sembe sámah ni bájalo ró. ");
INSERT INTO bqj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","No gáturuᵽa gagu gajil me gujae me eogi, ᵽan áboñul emalakaol íkiil guomen buganol bugo naĉob me n’ulam waw ᵽe waa mof. ");
INSERT INTO bqj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jikan n’uinumul wo bubah nihi bigitenolal me : no uan bo úburiulo mbiban m’búyaul úsabul, jiffase búoh fujam fulofulo. ");
INSERT INTO bqj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Manur mamu may, no jijae me ejuh waf wauwu ᵽe uĉigul, jiffas búoh Añol Arafuhow nalofulo, naĉilo n’gánonum gagu. ");
INSERT INTO bqj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Maagen, ínje ilobul yo : bugan bugagu bugaa jama mati gutoh guĉet gubao dáuru ᵽe m’baĉigulat. ");
INSERT INTO bqj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Emít yay ni ettam yay ᵽan sibao, bare gurimom, go, mati gúmus gubao. ");
INSERT INTO bqj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mala effas funah fay ni tinah tay Añol Arafuhow ajae me ébbañul, ánoan affasut so, mele emalakaay gaam dó me n’émit, hani may Añil ahu ; Ᵽaaya o bareol affase. ");
INSERT INTO bqj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ti ni gunah gagu no Nóe aamen me m’buroŋ, mamu may ᵽan ní mee funah ébbañul yay yal Añol Arafuhow. ");
INSERT INTO bqj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ni gunah gagu balama báyuer mal mamu bámah babu, bugan bugagu fitiñ ni marem, búyab ni búyabo guomen n’ekan, bi funah fafu fo Nóe anogen me ni busana babu bámah babu. ");
INSERT INTO bqj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gútallout wáfowaf iki báyuer mal mamu bámah babu búkail buvurenil bújaenum ᵽe ; mo may ᵽan ní mee funah éjoul yay yal Añol Arafuhow. ");
INSERT INTO bqj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","No ñer, baj me wáine gúuba gaam ni galah, ahu ᵽan ájaenumi, ahuo nahali to. ");
INSERT INTO bqj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Waare gúuba gúni me n’étuŋ, ahu ᵽan ájaenumi, ahuo nahali to. ");
INSERT INTO bqj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jiilo ñer ni mujah ró, mata jiffasut fay funah Ataw ahu olul ajae ébbañul. ");
INSERT INTO bqj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jiffas dáure : Iní me afan yaŋ naffasene nay áku ᵽan anonulol, ᵽan apoy yo, mat’ahalol nánonul dó. ");
INSERT INTO bqj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yo eĉil me buru may jiilo ni majage, mata Añol Arafuhow ᵽan ájoul tinah to buru jiᵽinorenut. » ");
INSERT INTO bqj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","« Ñer ay aamme aroka ahu aĉol me aban najah ? O aamme ahumu o afanol abaŋ me ni fuhow buganol bi esen gupalol uroka gutiñ tinah baĉiger. ");
INSERT INTO bqj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Abaj gásumay, aroka ahumu o afanol ajae me etoh, o báolerul, áni n’ekan burokol ! ");
INSERT INTO bqj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Maagen, ínje ilobul yo : afanol ᵽan asenol wafol ᵽe wo nabaj me aogen. ");
INSERT INTO bqj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bare íni me aroka aarat om, ᵽan nah’aah m’biinumol afanol ᵽan aᵽioul, ");
INSERT INTO bqj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","min ñer anamo élatien bugagu uroka, eremor n’etiñor n’úhallaaw. ");
INSERT INTO bqj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aroka ahumu afanol ᵽan aĉigul funah fo aĉila aᵽinorut, tinah to naffasut ; ");
INSERT INTO bqj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ban no ñer afanol ᵽan ahamol ni yaŋ yay, aban nakanol wo nihi gukan me bugan bugagu ᵽe gaĉolut me : no ᵽan baj me ukoŋ ni ejoh émiremma. » ");
INSERT INTO bqj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yésu náfaro aah : « Jávi jaju jaa fatiya maa jínie : baje sújur gono guñen gaŋare sijaŋail n’gujow bi eke bíemor n’ayaba. ");
INSERT INTO bqj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Guce ni bugo gono futoh gujengulojengulo, bugagu futoh, bugo, gujengulout. ");
INSERT INTO bqj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bugagu gajengulout me, no guomme n’eŋar sijaŋail, gújaenumut míita mice ; ");
INSERT INTO bqj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","bare bugagu gajengulo me, bugo n’gújaenum sijaŋail ni mubara maa míita. ");
INSERT INTO bqj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nemme ayaba ahu naᵽioboᵽio, bugo ᵽe n’guŋoy iki gúmori. ");
INSERT INTO bqj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","No nuĉiga me n’etut fuh, ni baj firim fuoh fatiya : “Ayaba ahu ume, júᵽurul jiemor ni o.” ");
INSERT INTO bqj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ñer sújur sasu ᵽe n’guilo n’gúni n’ejjonen sijaŋail. ");
INSERT INTO bqj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bugagu gajengulout me n’guoh bugagu gajengulo me : “Jíjioli ni míitaul ! Sijaŋaóli usu n’efogo.” ");
INSERT INTO bqj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gajengulo me n’guogil : “A-a, mati jú toh bi ni wolal ᵽe ; jujow iki júnnomul ni gannomene mo me.” ");
INSERT INTO bqj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","No guomme ñer n’ejow yay bi eke mo énnomul, ayaba ahu naĉigul ; bugagu bugo wafil úrir me n’gunonor manur ni o bi eke emat búyabo babu ; mbiban ganegen gagu n’guffaŋi. ");
INSERT INTO bqj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ᵽio bo, bugagu gakaen me funnom fafu n’guĉigul ban n’guoh ayaba ahu : “Afanóli, Afanóli, úpeguloli.” ");
INSERT INTO bqj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bare naagulil dó : “Maagen, ínje ilobul yo : iffatul !” ");
INSERT INTO bqj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yo eĉil me niegul jambi júmori mata jiffasut funah fafu no Añol Arafuhow ajae me ébbañul. » ");
INSERT INTO bqj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","« Jávi jaju jaa fatiya maa jínie : baje ánaine aam n’eke bújaor ; návogul urokaol, aban nahat ni guñenil fubajol. ");
INSERT INTO bqj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nasen ahu síralam sal éurus sono futoh, ahuo sono súuba, áfatten yanur, ánoan min miñinganol mire me, aban nake bújaor babu. ");
INSERT INTO bqj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","To baenah, aroka ahu ayab me síralam sasu saamme futoh nakay, ban nakan so n’subugor iki síŋarul sice sono futoh. ");
INSERT INTO bqj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Manur mamu, ahu ayab me saamme súuba nakan so n’subugor sice mul súuba. ");
INSERT INTO bqj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bare ahuo ayab me yanur yay nak’aoh gasun n’ettam yay min akoen yo ró. ");
INSERT INTO bqj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Búsol, ᵽio bo, afan urokaaw náolul ban narorenil min ánoan ni bugo agitenol burokol bo nakan me ni síralamol so nayab me. ");
INSERT INTO bqj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ahu ayab me síralam sasu saamme futoh nalofol ni sice ró sono futoh, aban naah : “Afanom, síralam futoh nusenenom ; nibajulo sice sono futoh, use.” ");
INSERT INTO bqj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Afanol naagol : “Yoo, aw aroka om áarie o gújue gufium ni o. Nujoge guñen gaaro waf wareut miñ, kan ᵽan ihat ni guñeni waf wafaŋe gájalo. Ujóul úsumaet manur n’ínje !” ");
INSERT INTO bqj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ahuo may ayab me saamme súuba náloful aban naah may : “Afanom, síralam súuba nusenenom, sice mul súuba use so niballo maa.” ");
INSERT INTO bqj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Afanol naagol : “Yoo, aw aroka om áarie o gújue gufium ni o. Nujoge guñen gaaro waf wareut miñ, kan ᵽan ihat ni guñeni waf wafaŋe gájalo. Ujóul úsumaet manur n’ínje !” ");
INSERT INTO bqj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ᵽúrto aĉila, ahu ayab me éralam yanur náloful aban naah : “Afanom, niᵽiene niffas búoh aw an átañie : nuh’uᵽiᵽit to nurogut, nuh’uŋaŋar wo nurokut. ");
INSERT INTO bqj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Níholiholi niŋar éralami ik’ioh n’ettam nikoᵽen yo ró ; uye, uyab wafi.” ");
INSERT INTO bqj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ñer afanol naagol : “Aw aroka om aarat ban nuyuh ! Nuffasene búoh nih’iᵽiᵽit to nirogut me, ban ᵽoᵽ nih’iŋaŋar wo nirokut me, ");
INSERT INTO bqj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ᵽan ñer uŋaren síralamom usen garoke me ni síralam ; mamu, no nijae me éolul, ᵽan íŋarenul wafom manur ni wo ubugor me ᵽe.” ");
INSERT INTO bqj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mbiban naah gaam to me guram éralamol gusen ahu abaj me saamme guñen. ");
INSERT INTO bqj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Maagen, ínje ilobul yo : an ajoh me wári wo nabaj me, ᵽan ayab faŋ to, bare an ajogut me wári wo nabaj me, o ᵽan guramol ᵽee, hani bi ni jo náhagum me. ");
INSERT INTO bqj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nabbañ aagil gujoh aroka ahumu abajut mee nafa gural tíyaŋ n’emoĉ yay, bo ᵽan baj me ukoŋ ni ejoh émiremma. » ");
INSERT INTO bqj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","« No Añol Arafuhow ajae me éjoul ti ávi n’emalakaay ró ᵽe, ᵽan anamo n’efenjeŋol yaa Jávi jaju ; ");
INSERT INTO bqj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","bugan bugagu ᵽe bugaa mof ᵽan guomeni bújoŋorol. No ñer ᵽan áfaculoril gútiman gúuba, ti akoña náh’áfaculor me ubbarum waw ni sijamen sasu ; ");
INSERT INTO bqj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ᵽan abaŋ gaĉol me bo gañenol gárib guomme, gaĉolut me, bugo, nabbañenil ni gañenol gamay. ");
INSERT INTO bqj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ñer ávi ahu ᵽan aah bugagu gaamme ni gañenol gárib : “Jújoul, buru bugo Ᵽayom ásonien me, jiyab gafumul gaamme Jávi jaju jo naᵽi me nabaŋul kábiriŋ ni buju babu baa mof ! ");
INSERT INTO bqj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mata no nicareten me, jisenomsen itiñ ; no marem mujogenom me, jisenomsem irem ; no nínien me ajaora, jialenomwalen ; ");
INSERT INTO bqj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","no ninamoen me enil erakel, jisimomsim ; no nísoten me, jucokoromcokor ; no niomen me ni fipeh, jikeloke jiŋaloom.” ");
INSERT INTO bqj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ñer bugan bugagu gaĉol me ᵽan guogol : “Ataw, nay jujugi ucaret min jiseni utiñ, nay marem mujogi min jiseni urem ? ");
INSERT INTO bqj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nay núniene ajaora min jialeni, nay nunamoene enil erakel min jisimi ? ");
INSERT INTO bqj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nay jujugi úsomut ter úni ni fipeh, min wóli jíkail jiŋaloi ?” ");
INSERT INTO bqj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ñer ávi ahu ᵽan aagil : “Maagen, ínje ilobul yo : nánonan no jikane waf wauwu ace ni gutiom, hani afaŋ me natitie, ínje faŋaom jikan wo.” ");
INSERT INTO bqj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mbiban ᵽan ábaho mbaa bugagu gaamme ni gamayol min aagil : “Buru bugo Aláemit atab me, júᵽur tale n’ínje, jíraliom ! Jujow julo ni sambun sasu sabaŋi me bi ni Seytane ni emalakaol ! ");
INSERT INTO bqj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mata no nicareten me, jisenutom itiñ ; no marem mujogenom me, jisenutom irem ; ");
INSERT INTO bqj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","no nínien me ajaora, jialenutom ; no ninamoen me enil erakel, jisimutom ; no nísoten me, ban ᵽoᵽ no nínien me ni fipeh, jikelat jiŋaloom.” ");
INSERT INTO bqj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ñer ᵽan bugo may guogol : “Ataw, nay jujugi ucaret ter marem mujogi, úni ajaora ter unamo enil erakel, úsomut ter úni ni fipeh, mbiban jirambenuti ?” ");
INSERT INTO bqj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ᵽan ñer aagil : “Maagen, ínje ilobul yo : nánonan no jikanut yo ace ni gutiom, hani afaŋ me natitie, ínje faŋaom jikanut yo.” ");
INSERT INTO bqj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ñer ubuge ᵽan gujow bi ni gúteh gagu gábaerit me, bare bugagu gaĉol me, bugo, ᵽan gujow bi ni buroŋ babu bábaerit me. » ");
INSERT INTO bqj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","No Yésu aban me egiten gurim gaugu ᵽe gal eligenil, naah ulagorol : ");
INSERT INTO bqj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","« Jiffase búoh gunah gúuba guŋañoe min Paak yay eĉigul. Ban Añol Arafuhow ᵽan abeni ni guñen bugan bi ebbaŋi n’ekurua. » ");
INSERT INTO bqj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ni tinah tautu, ufan uteŋenaaw ni ufan Esúif yay n’guomunor ni fúlumet fafu fal afan uteŋenaaw ámah ahu o guvoge me Kayafa. ");
INSERT INTO bqj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","N’gujamor bi ejoh Yésu ni mutuho ró, mbiban n’gumugol. ");
INSERT INTO bqj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nihi guoh : « Jamb’ujogalol me no gaggan gagu gutiñe me, jambi gáguo gubaj n’ésuh yay. » ");
INSERT INTO bqj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nemme Yésu umuen Betani, yaŋ ace áine o háhae ejogene gajaol Simoŋ, ");
INSERT INTO bqj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ni baj ace aare alofol. Aare ahumu jibara jateᵽiteᵽ naogene jimmeŋ míĉir matiŋoe másumut funnom, ban no Yésu aamme ni fitiñ, aare ahu náulenol míĉir mamu ni fuhow. ");
INSERT INTO bqj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","No ulagoraaw gujuh me dáuru, súmutil n’guoh : « Ehajen yauyu, nafa yo yay ? ");
INSERT INTO bqj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Júene míĉir maumu munnomeni síralam sammeŋe, mbiban n’siseni galeh me. » ");
INSERT INTO bqj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yésu naffas gaᵽinoril, ban naagil : « Wa uĉile n’jíni n’eyogen aare ahumu ? Waf waaro nakanom ! ");
INSERT INTO bqj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Galeh me, bugo, ᵽan jibajil nánonan ni buru, bare ínje jilelom n’ebaj nánonan. ");
INSERT INTO bqj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aare ahume náyu mee míĉir mamu n’enilom bi gafoh gagu gúmbam. ");
INSERT INTO bqj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Maagen, ínje ilobul yo : ni mof mamu ᵽe, tánotan to Firim fafu Fásum me fujae me evarei, ᵽan may lobi mala wo aare ahume akan me ; mamu ᵽan auno bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ᵽúrto, ace ni uᵽotoraaw gaamme guñen ni gúuba, gajaol Yudas Isikariot, najow ak’atoh ufan uteŋenaaw ");
INSERT INTO bqj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","min aagil : « Wa jijaom esen ínje bakaner Yésu nalo ni guñenul ? » N’gujamor mala síralam saaᵽiaᵽ sono ávi ni guñen min gusenol so. ");
INSERT INTO bqj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kábiriŋ no, Yudas náni n’eŋes no jáhor me bi ekanol nalo n’guñenil. ");
INSERT INTO bqj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ni funah fafu fítiar fafu faa gaggan gagu gal unaĉ waw wabajut me lévir, ulagoraaw n’gúkail guoh Yésu : « Tay numaŋe iki jucokori fitiñ fafu faa Paak yay ? » ");
INSERT INTO bqj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Naagil : « Jujow bi nende hari, n’ésuh yay ; jiĉih n’juogol ínje afanul niege tinagom tulofe, ban yaŋol ᵽan itiñ me Paak yay n’ulagorom dó. » ");
INSERT INTO bqj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ulagoraaw n’gukan wo Yésu alobil me, min ñer gucokor may fitiñ fafu faa Paak yay. ");
INSERT INTO bqj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","No nuĉiga me gállim, Yésu nanamo ni bugo gaamme guñen ni gúuba n’gúni ni fitiñ. ");
INSERT INTO bqj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bugo ni fitiñ fafu, naagil : « Maagen, ínje ilobul yo : ace ni buru ᵽan annomenom. » ");
INSERT INTO bqj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","No guun me firim faufu, bugo ᵽe ni mujogil náar bireg ánoan ni bugo nanamo erorenol aah : « Ataw, ínje ᵽiaŋ ? » ");
INSERT INTO bqj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Naagil : « An ahu árur me manur n’ínje gañenol ni biril babu, o ajae ennomenom. ");
INSERT INTO bqj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Maagen, Añol Arafuhow ban aĉet ti hiĉi me ya ni o. Bare mataño míni ni an ahu ajaol me ennomen ! Faŋene jáari an ahumu jamb’abugi. » ");
INSERT INTO bqj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ñer Yudas annomeneol me naagol may : « Afanóli, ínje ᵽiaŋ ? » Yésu naagol : « Nulob yo uban. » ");
INSERT INTO bqj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bugo ni fitiñ fafu, Yésu naŋar ganaĉ, násonien go, namusul go aban nagabor go ulagoraaw naagil : « Jiyab jitiñ : úre enilom. » ");
INSERT INTO bqj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mbiban naŋar éremuma ; no nasal me Aláemit aban, nasenil yo naagil : « Jiyab jiremor buru ᵽe : ");
INSERT INTO bqj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","úre físimom, físim fafu faliŋen me babuge babu bo Aláemit ajogor me ni bugan bugagu, fáyui me mala gaboket gal util waa bugan gammeŋe. ");
INSERT INTO bqj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Injé ilobul yo : mat’ibbander iĉoen bíñu bi funah fafu fo nijae me eremor ni buru ece evugul ni Jávi jaju jaa Ᵽayom. » ");
INSERT INTO bqj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ᵽúrto, n’gúfoñ úfoñ wal esal Aláemit, mbiban n’gúᵽur gujow mbaa firijaŋ fafu fo guvoge me fal uoliv waw. ");
INSERT INTO bqj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ñer Yésu naah ulagorol : « N’efuga yauye, buru ᵽe ᵽan jibbañ búsol sílamom baĉigerul, ti Aláemit alob me ni Bahiĉer babu, no naah me : “Ᵽan iteh akoña ahu imuh, ban ubbarum waw wal ekore yay ᵽan uvisor uban babu ᵽe.” ");
INSERT INTO bqj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bare búsol eiloom ni gaĉet me, ᵽan iyabul gayoŋ mbaa Gálile. » ");
INSERT INTO bqj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ñer Ᵽier naŋar firim fafu min aagol : « Hani bugagu ᵽe gubbañe búsol, ínje mat’ímus ibbañ búsol. » ");
INSERT INTO bqj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bare Yésu naagol : « Maagen, ínje ilobi yo : n’efuga yauye réro, balama gáin guoh, ᵽan uoh ñono ñáfaji uffasutom. » ");
INSERT INTO bqj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ᵽier naagol : « Hani ᵽan iĉet manur n’aw, mat’ímus ioh iffasuti. » Bugagu ulagora ᵽoᵽ n’guyab dó bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ᵽúrto, Yésu najow n’ulagorol dó bi tiñ talu to guvoge me Getusemane. No guĉih me, naagil : « Jurobo tale min ínje itos maa ike galaw. » ");
INSERT INTO bqj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","N’ejaol, nájaenum Ᵽier ni úᵽur Sebede gaamme gúuba. Ᵽiout, gáholi ni gágogor ni sunonol. ");
INSERT INTO bqj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ñer naagil : « Gaᵽinor gumugom iki biinumom búguo. Jinamo tale n’ínje ban jambi júmori me ! » ");
INSERT INTO bqj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mbiban natos kan ráli maa, naya gújul aban náñuᵽ iki buulol buya n’ettam min alaw aah : « Ᵽayom, júen me kano, nufaren éremuma yauye yaa sílam éraliom ! Bare mánoman níe, jambi wo ínje imaŋ me ukano, bare til wo aw umaŋ me. » ");
INSERT INTO bqj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mbiban nábbañul mbal ulagoraaw gúfaji bugagu aĉigul natogil min gúmoe. Ñer naah Ᵽier : « Buenne ? Hani enamo jatiito manur n’ínje m’bámoit jújuut yo ? ");
INSERT INTO bqj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jambi júmori, bare jilaw jambi julo ni gabut ! Biinum arafuhow nihi bumamaŋ ekan maaro, bare enilol nd’ebaj sembe. » ");
INSERT INTO bqj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yésu náutten atos ahalil to, aban nalaw aah : « Ᵽayom, íni me éremuma yauye yaa sílam éjuut éraliom ínje m’baremut yo, kan wo aw umaŋ me ukano ! » ");
INSERT INTO bqj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nabbañ ábbañul aĉigul natogil min gubbañe gúmori ; maagen mamu umoil úliilii gámori. ");
INSERT INTO bqj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nabbañ ahalil to min atos, aban nalaw elaol éfatten n’elob gurim gagu ganur gagu. ");
INSERT INTO bqj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mbiban, nábbañul mbal ulagoraaw naagil : « Juroŋe n’gámori gagu ? Gáelo gom ? Juluj, tinah talu tulofulo no Añol Arafuhow ajae me ebeni ni guñen utilaaw. ");
INSERT INTO bqj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jiilo ujaal ! An ahu ajae me ennomenom nalofulo. » ");
INSERT INTO bqj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yésu o n’elob yay, Yudas ñer, aamme ace ni uᵽotoraaw gaamme guñen ni gúuba, naĉigul, ban nájaorul ni fítiman fámah faogene ufoje ni sugol. Bugan bugaubugi, ufan uteŋenaaw ni ufan Esúif yay guboñulil. ");
INSERT INTO bqj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas aamme n’ennomenol baje wo nalollil waamme : « An ahu o nijae me élloŋ, aĉila ; jujogol. » ");
INSERT INTO bqj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ñer nafaen alof Yésu naagol : « Nisafi, Afanom. » Aban nálloŋol. ");
INSERT INTO bqj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ñer Yésu naagol : « Apalom, waf waw waĉili me n’újoul, ukan wo. » To baenah, bugagu gajaorulo me ni Yudas n’gúloful ban n’gualen gujoh Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ñer, ace ni gaamen to me ni Yésu náñagul gafojeol ni gafon go ateh aroka ahu ala afan uteŋenaaw ámah ahu aᵽirih gannu. ");
INSERT INTO bqj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","No Yésu ajuh me dáuru, naagol : « Ubbañen gafojei ni gafon go ! Uffas búoh an ajae me étuh gafoje, go gujaol me emuh. ");
INSERT INTO bqj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nuoseh ᵽiaŋ íjuut ilaw Ᵽayom min aboñulom maer yauye uyoŋ wal emalaka wafaŋe wono guñen n’úuba ? ");
INSERT INTO bqj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bare ikan mo me, bu ñer Bahiĉer babu mbi bukano me, bo baah me maa ᵽan ní ? » ");
INSERT INTO bqj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ᵽúrto, Yésu naah fítiman fafu : « Jujoulo n’ufoje ró ni sugol bi ekelom fujoh ti nihi ní me akana-maarat jikelo fujoh. Gunah émit ᵽe ínje umuen n’eligen bugan bugagu ni gávi-Aláemit gagu, ban jujogutom. ");
INSERT INTO bqj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bare dó ᵽe dibabaj min mbi Bahiĉer uboñer waw bukano. » No ñer, ulagoraaw ᵽe n’gujundenol to min gúᵽur gutey gukay. ");
INSERT INTO bqj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gajoh me Yésu n’gújaenumol bi nende Kayafa aamme afan uteŋenaaw ámah ahu, dó úᵽajula gúboñ Aláemit bugagu ni ufan Esúif yay guomunor me. ");
INSERT INTO bqj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ᵽier nah’alagenulil ráli bi ró ni fúlumet afan uteŋenaaw ámah ahu. Nak’anamo to upoyaaw guomme bi ejuh bu jae me éuñen. ");
INSERT INTO bqj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ni tinah tautu, ufan uteŋenaaw ni fujoj Esúif yay fámah fafu n’gúni n’eliᵽ bagitener baa jibij bájue bukan min Yésu amugi. ");
INSERT INTO bqj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mánoman baje bugan gammeŋe galige etegol sulob, bare jogut. Búsol, ni baj bugan gúuba gúkail guoh : ");
INSERT INTO bqj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","« Ahumu naage : “Níjue ifum gávi gagu gal Aláemit, iban nibbañ iteᵽ go ni gunah gúfaji.” » ");
INSERT INTO bqj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ñer afan uteŋenaaw ámah ahu nailo naah Yésu : « Mat’úbal wáfowaf ? Uunut sulob se so gulobe maa guya n’aw ? » ");
INSERT INTO bqj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bare Yésu naᵽanor butumol. Ñer afan uteŋenaaw ámah ahu naagol : « Nilobi yo ni gajow gal Aláemit aroŋ me : ulobóli ter aw uomme Kirista ahu, Añol Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yésu naagol : « Aw faŋai nulob yo. Ban ᵽoᵽ ínje ilobul yo : ᵽúrto me maer ᵽan jujuh Añol Arafuhow min anave ni gárib Aláemit-Sembe, ban ᵽan jujugol áavul n’émit ni úpar waw. » ");
INSERT INTO bqj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","No afan uteŋenaaw ámah ahu aun me gurim gaugu, naĉaĉ bisimool aĉila faŋaol, aban naah : « Najele Aláemit. Wa mul ñer nusoholaale ugitena guce ? Juune maer yauye gújel gagu go najel me. ");
INSERT INTO bqj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bu ñer jiᵽinore ? » N’guogol : « Ᵽiloᵽilo min aĉet. » ");
INSERT INTO bqj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","No ñer, n’gumasenol ni buul ban ni gutegol sumoh. Bugaguil nihi gutegol simbej n’gúfohulorol n’guoh : ");
INSERT INTO bqj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","« E Kirista, ulobóli ᵽaa ay ategi ! » ");
INSERT INTO bqj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ni tinah tautu, Ᵽier umuen tíyaŋ ni fúlumet fafu nanave. Ni baj ace n’urokaaw waarema alofulol naagol : « Aw may buru juomen me ni Yésu ala Gálile. » ");
INSERT INTO bqj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bare Ᵽier naceŋ bújoŋor bugan bugagu ᵽe naah : « Iffasut wa numaŋe elob. » ");
INSERT INTO bqj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","No naamme n’ejow mbaa ganegen gagu bi éᵽur, aroka ace aare mul najugol naah gaamen to me : « Ahume bugo guomen me ni Yésu ala Nasaret. » ");
INSERT INTO bqj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ᵽier nabbañ aceŋ yo n’ebbat ró aah : « Iffasut áine ahumu. » ");
INSERT INTO bqj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ᵽio maa, gaamen to me n’gúloful Ᵽier n’guogol : « Ti maagen, aw buru bugom : baloberi bigitenyogiten. » ");
INSERT INTO bqj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bare Ᵽier nanamo etaboro ni ebbat aah : « Iffasut áine ahumu. » To baenah, gáin n’guoh. ");
INSERT INTO bqj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ñer naosen firim fafu fo Yésu alobenol me no naagol me : « Balama gáin guoh, ᵽan uoh ñono ñáfaji uffasutom. » Náᵽur tíyaŋ ban nanamo ukoŋ ni sembe n’eteh mahat ró. ");
INSERT INTO bqj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","M’bujom mej, ufan uteŋenaaw ni ufan Esúif yay ᵽe n’gujoh bugo ᵽooil firim faa jamuh Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","N’guhogol guban n’guŋarol iki gusen Ᵽilat, afan ahu o bugaa Rom gubaŋ to me. ");
INSERT INTO bqj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","No Yudas, aamme áine ahu annomen me Yésu, aun me búoh gujojoh bi emuh Yésu, nateh mahat ban nájaenum síralam sasu saamme ávi ni guñen ak’abbañen ufan uteŋenaaw ni ufan Esúif yay, ");
INSERT INTO bqj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ban naagil : « Injé ikane, nigengen an akanut waf ibet n’eĉet ! » Bare n’guogol : « Wóli utumóli ulebo ! Dáru barokeri ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ñer Yudas nabelen dó ni gávi-Aláemit gagu síralam sasu aban najow akay, ᵽúrto nak’amugoro árien. ");
INSERT INTO bqj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ufan uteŋenaaw n’gumuken síralam sasu ban n’guoh : « Gúboñolal gusenut min mbi síralam sausu sitegori ni saa gávi-Aláemit gagu, mata dáuru bacam baa físim bom. » ");
INSERT INTO bqj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ñer n’gujoh firim fanur min guŋar so gunnom galah gagu go guvoge me \"galah ateᵽa-sibara\", mbiban n’gúbahen go gukan guyah gaa sijaora. ");
INSERT INTO bqj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yo eĉile galah gaugu n’guvogi \"galah gaa físim\" bi funah faa jama. ");
INSERT INTO bqj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mo ñer gurim aboñer ahu Séremi gukanoe gaah me : « Guŋare síralam ávi ni guñen, saamme bacam babu baa funnomenol bo bugal Israel gujamor me min gubet bo mola, ");
INSERT INTO bqj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ban n’guŋar so iki gunnom galah ateᵽa-sibara ahu, ti may Atúla alob mo me. » ");
INSERT INTO bqj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ñer n’gújaenum Yésu bújoŋor afan mof mamu aamme Ᵽilat. Ume narorenol aah : « Aw uomme ávi ahu ala Esúif yay ? » Naagol : « Aw faŋai nulob yo uban. » ");
INSERT INTO bqj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ᵽúrto, ufan uteŋenaaw ni ufan Esúif yay n’gunamo mul etegol sulob, bare ábalut hani jatiito. ");
INSERT INTO bqj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ñer Ᵽilat naagol : « Aw ᵽiaŋ uunut sulob sause so gutegei maa ? » ");
INSERT INTO bqj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Min Yésu ábalutol me hani ñanur, Ᵽilat najahali nár. ");
INSERT INTO bqj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Emít-émit no gaggan gagu gaa Paak guĉilo, afan mof mamu nah’ahalenilhalen amigel ni bugo gukul me, ahu o fítiman fafu fumaŋ me ahanulil. ");
INSERT INTO bqj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ban bajene ni gunah gaugu amigel ace o gajaol guunoe faŋ, gajaol Yésu Barabas. ");
INSERT INTO bqj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nemme fítiman fafu ufu min fuomunore, Ᵽilat naagil : « Ay ni ubuge gaamme gúuba jimaŋe ihanulul ? Yésu Barabas, ter Yésu o guvoge me Kirista ? » ");
INSERT INTO bqj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nalob mee mata naffase búoh físil fiĉile min gújogul Yésu gusenol. ");
INSERT INTO bqj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ᵽilat o min anave dó gutaliŋe me bugan, aarol náboñul guogol : « Jamb’unogen me n’elob yay yal an ahumu akanut mee maarat mánoman ! N’efuga yauye nílalam faŋ ni síyeut so níyeute iya ni o. » ");
INSERT INTO bqj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ni tinah tautu, ufan uteŋenaaw ni ufan Esúif yay n’gutuñen fítiman fafu min fuoh Ᵽilat ahalenil Barabas, ban nakan Yésu naĉet. ");
INSERT INTO bqj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ᵽilat nabbañ narorenil naagil : « Ay ni bugo gúuba jimaŋe ihanulul ? » N’guogol : « Barabas. » ");
INSERT INTO bqj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Natajen arorenil aagil : « Ñer Yésu, o guvoge me Kirista ahu, ikanol bu ? » Bugo ᵽe n’guoh : « Abbaŋi n’ekurua ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naagil : « Min maarat may nakane ? » Bare bugo n’gufaŋ n’gúᵽibe fatiya guoh : « Abbaŋi n’ekurua ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","No Ᵽilat ajuh me búoh ájuut to wáfowaf, ban éᵽib yay efaŋefaŋ gájalo, naŋar mal naᵽos guñenol bújoŋor fítiman fafu naah : « Guñenom gukure ni físim fafu fal an ahume akanut mee wáfowaf. Babu ñer buru ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ñer bugan bugagu ᵽe n’guoh : « Wáfowaf wajae to me éᵽurul n’eĉelol mbi uya ni wóli ni gabugoróli ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ñer Ᵽilat nahanulil Barabas. Mbiban, naboñ guteh Yésu gusoh gal ubaŋ, aban nasenil o bi eke ebbaŋ n’ekurua. ");
INSERT INTO bqj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ekosombil yay n’gújaenum Yésu bi ró ni yaŋ afanil Ᵽilat, ban fuyoŋ fafu ᵽe fal ekosombil yay ni fúgolol fúharo. ");
INSERT INTO bqj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","N’gúᵽurenol wañol ban n’gukanol uce újugah. ");
INSERT INTO bqj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ᵽúrto, n’guŋar ulaliŋ waa sijeŋ gueĉ fugaŋ guoᵽol ni fuhow, ban n’gusenol egol átuh n’gañenol gárib. Guban n’guya gújulil bújoŋorol min gúfohulol guoh : « Jisafi, ávi Esúif yay ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","N’gumasenol guban n’guyab egol yay gutegol ni fuhow. ");
INSERT INTO bqj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","No gúfohulol me iki guᵽilo, n’guram wañ waw újugah waw wo gukanenol me, guban n’gubbañenol bisimool, mbiban n’gúᵽunnulol dó gújaenum bi eke ebbaŋol n’ekurua. ");
INSERT INTO bqj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bugo n’éᵽur ésuh yay, n’guemor n’ace áine ala ésuh yay yaa Siren gajaol Simoŋ ; n’gukanol ni sembe nateb ekurua yay yaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","No guĉih me tiñ talu to guvoge me Golugota (dóemme \"tiñ taa gasen\"), ");
INSERT INTO bqj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","n’gusen Yésu bíñu yáguñori n’erem yátalie bi marem ; no naĉoen yo me, nalat yo marem. ");
INSERT INTO bqj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","N’gubbaŋol n’ekurua yay, guban n’gulukor bisimool. ");
INSERT INTO bqj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mbiban, n’gunamo n’gúniol n’gapoy. ");
INSERT INTO bqj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","N’guŋar jibabar n’guhiĉ ró waĉil me Yésu namugi, waamme uwe : « Ume aamme Yésu, ávi ahu ala Esúif yay. » Mbiban n’guŋar jibabar jauju gubbaŋ n’ekurua yay fatiya fuhool. ");
INSERT INTO bqj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Baje ᵽoᵽ ukana-maarat gúuba bugo gubbaŋe ni sukurua manur ni o, ahu n’gañenol gárib, ahuo n’gamayol. ");
INSERT INTO bqj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bugan bugagu gaamme n’égat nihi gúlis guhoil n’gujelol nímoro n’guoh : ");
INSERT INTO bqj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","« Aw áju me ufum gávi-Aláemit gagu mbiban nubbañ uteᵽ go ni gunah gúfaji, uᵽagenoro ᵽaa fuhoi ! Iní maagen aw uomme Añol Aláemit, kan úavul n’ekuruai ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ufan uteŋenaaw, úᵽajula gúboñ Aláemit bugagu ni ufan Esúif yay, bugo ᵽe may n’gunamo éfohulol guoh : ");
INSERT INTO bqj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","« Nah’aᵽagen bugan aban ájuut aᵽagenoro ! Let aĉila ávi Israel nam ? Ñer áavul n’ekuruaol min úinenal ni o. ");
INSERT INTO bqj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Let gafiumol n’Aláemit gom ? Kan ñer maer Aláemit ákail aᵽagenol, íni me namaŋol ! Let naage o Añol Aláemit nam ? » ");
INSERT INTO bqj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ukana-maarat bugagu bugo gubbaŋor me manur ni o n’gunamo may ejelol ti bugagu gujeleol me. ");
INSERT INTO bqj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","No tinah tirih me, emoĉ néavul ni mof mamu ᵽoomo, ban néni to iki títigo. ");
INSERT INTO bqj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","No títigo me maa, Yésu náᵽib fatiya ni sembe aah : « Elí, Elí, lama sabahtani ? » Dóemme « Aláemilom, Aláemilom, wa uĉile nujundenom ? » ");
INSERT INTO bqj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Guce ni gaamen to me n’guunol ban n’guoh : « Aboñer ahu Elí navoge mee ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ace ni gaam to me natey to baenah ak’aŋar jurocob, nájeben jo bíñu yafire, aban naŋar gapil nahoh jo ró añuren Yésu min mb’acot jo. ");
INSERT INTO bqj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bare bugagu n’guogol : « Unah, umundumal ujugal ter Elí ᵽan ájoul ákiil aᵽagenol. » ");
INSERT INTO bqj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yésu nabbañ aya gáᵽib gámah, aban naĉet. ");
INSERT INTO bqj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ni tinah tautu, gábil gagu gaminden me tiñ talu táñai me dó ni gávi-Aláemit gagu n’guĉaĉo kábiriŋ fatiya go bi n’ettam go gukan uᵽeŋ úuba. Ni tinah talu tanur tatu, ettam yay negoror, ban sival sasu ni sireñ. ");
INSERT INTO bqj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ñer guyah gagu n’gúfogulo ban gammeŋe ni gáinen me n’Aláemit gaĉelen me n’gúbbañul gúni m’buroŋ, ");
INSERT INTO bqj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ban n’gúᵽurul n’guyagil. (Ᵽúrto gailo Yésu ni gaĉet me, n’gunogen dó Yérusalem, yaamme ésuh yay yanab me, dó bugan gammeŋe gujugil.) ");
INSERT INTO bqj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Afan ekosombil yay ni buganol gaamme n’gapoy Yésu manur ni o n’gujuh gagoror ettam yay ni wabaj me ᵽe ; ñer n’gúholi náar, ban n’guoh : « Maagen mamu aĉila aamme Añol Aláemit ! » ");
INSERT INTO bqj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bajene ᵽoᵽ waare gammeŋe gaiye ráli n’gúni n’eluj ; bugo gulagenulo me Yésu kábiriŋ Gálile nihi gucokorol nímoro. ");
INSERT INTO bqj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ni baj ni bugo Mari ala ésuh yay yaa Magudala, ni Mari jaw Saak bugo ni Susef, ni may jaw guñol Sebede. ");
INSERT INTO bqj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","No tinah tujon me, ni baj ace áine gajaol Susef áᵽullo Arimate ájoul ; áine ahumu nasanumetsanumet, ban o ᵽoᵽ alagora Yésu aamene. ");
INSERT INTO bqj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Najow ak’atoh Ᵽilat min ácinol efuluŋ yay yaa Yésu. Ñer Ᵽilat naboñ gusenol yo. ");
INSERT INTO bqj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Susef naŋar gábil gajaha min ággub efuluŋ yay, ");
INSERT INTO bqj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aban nabaŋ yo ñáraru fuyah fuvugul fo naoge bi ni o faŋaol faam n’gacaĉ erijaŋ ; mbiban nábaken fuval fámah atoj gánonum fuyah fafu, aban nakay. ");
INSERT INTO bqj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari ala Magudala ni Mari ahuo ubugien to n’gurove gúᵽimbor fuyah fafu. ");
INSERT INTO bqj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tihalen fo, faamme fíiyay Esúif yay, ufan uteŋenaaw ni Eᵽárisie yay n’gujow manur bi nende Ᵽilat ");
INSERT INTO bqj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","guĉih n’guogol : « Afanóli, wóli juosene búoh abija ahumu, no naamen me m’buroŋ, naage tale gunah gúfaji ᵽan ailo ni gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aᵽ’umaŋ ᵽaa usen búoh fuyah fafu fupoi bi ni funah fúfatten ! Kanut mo, ulagorol gújue gújoul iki gúkuet efuluŋ yay, mbi ᵽúrto n’guoh ésuh yay nailoe n’gaĉet me, ban jibij jauju júsola jo jijae me efaŋ gaarat jítiar jaju. » ");
INSERT INTO bqj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ᵽilat naagil : « Yoo. Jiŋar ekosombil bugaubuge bi gapoy gagu. Jujow, ban jikan min fuyah fafu fupoyi ti júju me. » ");
INSERT INTO bqj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ñer n’gujow iki gukan gapoy gagu gaa fuyah fafu : n’gumundum guŋar fuval fafu gutoj fíᵽ gánonum fo, guban n’gukan to fúffasum mbi an agor n’guffas. Mbiban n’gubaŋ to upoya. ");
INSERT INTO bqj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","No fíiyay Esúif yay fúgat me uk’uomal ni bujom babu baa funah fítiar fal esemen yay, Mari ala Magudala ni Mari ahuo n’guke bujuh fuyah fafu. ");
INSERT INTO bqj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ᵽiout, ettam yay negoror gagoror gámah ; ni baj amalaka Aláemit áavul fatiya émit ákail ábaken fuval fafu alalen, aban narobo ni fo. ");
INSERT INTO bqj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ganogorol n’guŋanno ti baijer émit, bisimool m’bútuen par ti bíbil. ");
INSERT INTO bqj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","No upoyaaw gujugol me, n’gújuhulo bireg n’gulo ti bugan gaĉeĉet. ");
INSERT INTO bqj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bare amalaka ahu naah waareaw : « Jambi júholi ! Niffase búoh Yésu o gubbaŋ me n’ekurua jiŋese. ");
INSERT INTO bqj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Alet tale ; naiye ni gaĉet me ti naᵽi me nalob yo ! Jújoul juluj tiñ talu to gubaŋenol me, ");
INSERT INTO bqj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","mbiban n’jujow cab iki juoh ulagorol naiye ni gaĉet me, nayabil gayoŋ mbaa Gálile, bo ᵽan gujugol me. Gurim gaugu nibaje bi elobul. » ");
INSERT INTO bqj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ñer waareaw n’gukay ni majase guhat fuyah fafu ni gáholi ró, bare ᵽoᵽ ni ésumay ró yámah, ban n’gutey guke egiten ulagoraaw elob yauyu. ");
INSERT INTO bqj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","To baenah, Yésu faŋaol nájoul guemor aban naagil : « Nisaful ! » N’gulofol, ban n’gulo to ni guolol min gunamo emigeletol. ");
INSERT INTO bqj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ñer naagil : « Jambi júholi ! Jujow iki juoh gutiom gujow bi Gálile ; bo ᵽan gujugom me. » ");
INSERT INTO bqj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waareaw n’ejow yay, guce ni ekosombil yay gaamen me ni gapoy fuyah fafu n’gunogen n’ésuh yay, guĉih n’gugiten ufan uteŋenaaw wabaj me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ñer ubuge n’guomunor manur n’ufan Esúif yay min gujoj, guban n’gusen ekosombil yay síralam sammeŋe ");
INSERT INTO bqj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","n’eogil nímoro : « Mbi juoh bugan bugagu ulagora Yésu gukelo ni fuh gúkuet efuluŋol buru n’gámori. ");
INSERT INTO bqj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iní me afan mof mamu nakae aun yo, wóli ᵽan jiffas bu jijae me elobol iki jugoñol jamb’ayogenul. » ");
INSERT INTO bqj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ñer ekosombil yay n’guŋar síralam sasu, ban ni gukan may ti gulobil me. Maumu, bagitener baubu bivisor me n’Esúif yay, ban guce ni bugo guroŋ bo n’éinen bi funah faa jama. ");
INSERT INTO bqj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ñer ulagoraaw gaamme guñen ni an anur n’gujow bi ni firijaŋ fafu baubu Gálile fo Yésu alobil me mala fo. ");
INSERT INTO bqj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","No guĉih bo me, n’gujugol, ban n’guya gújul bújoŋorol n’gumigeletol. Bare guce ni bugo n’guroŋ ᵽan n’etehumor jatiito. ");
INSERT INTO bqj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ñer Yésu nalofulil aban naagil : « Niyayab sembe sánosan fatiya n’émit ni babe n’ettam. ");
INSERT INTO bqj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jujow ñer ni súsuh sasu ᵽe saa mof, jikanil n’gúni ulagorom, ban ni jíbatiseil ni gajow gaa Ᵽaaya ni Añolol ni Biinum Banabe. ");
INSERT INTO bqj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jiligenil ékanum wo niligenul me ᵽe. Jiffas búoh : ínje umu nánonan ni buru bi no mof mamu mujae me ebao. »");
INSERT INTO bqj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Firim fafu fásum me faa Yésu Kirista, Añol Aláemit, maa fíĉili. ");
INSERT INTO bqj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","N’élebur yay yal aboñer ahu Esai, Aláemit naage : « Ᵽan iboñ ájaenumaom gahoŋen ayabi gayoŋ min mb’ateŋen bulago babu bi n’aw. » ");
INSERT INTO bqj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","« Firim fúᵽureul baubu n’eᵽarandaŋ yay nihi fuoh fatiya : “Jiteŋen fukaen bi ni Ataw ! Jiyaol ulago waĉole !” » ");
INSERT INTO bqj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ajáenuma-gahoŋen ahumu o aamme Saaŋ Batis. Babu ni gafit gagu gámah gagu náᵽullo nah’avare bugan bugagu naagil : « Jíbahen bakanerul min íbatiseul, min mbi Aláemit aboketul utilul. » ");
INSERT INTO bqj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bugaa mof mamu ᵽe maa Yúde bi ni bugaa Yérusalem ró ᵽooil nihi gujow gutogol bo, ban n’gugiten utilil bújoŋor ésuh yay ᵽe, min ñer Saaŋ ábatiseil ni fal fafu faa Suruden. ");
INSERT INTO bqj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Saaŋ ahumu bisimool ni bufal eñokombo bucokori, ban nah’ahogo gasinja gaa gabaŋ ni fuhoŋolol. Ujamen-émit ni múhum maa baha nah’atiñen. ");
INSERT INTO bqj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nah’avare aah : « An ahu afaŋom me sembe fúf umu n’éjoul búsolom, ban ínje iᵽilout bi éñuᵽ ijal unew sidalaol. ");
INSERT INTO bqj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Injé ni mal níbatiseeul, bare aĉila ᵽan ábatiseul ni Biinum Banabe. » ");
INSERT INTO bqj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ni gunah gaugu, Yésu náᵽurul Nasaret ni mof mamu maa Gálile ákail Saaŋ ábatiseol ni fal fafu faa Suruden. ");
INSERT INTO bqj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","No Yésu aamme n’éᵽurul ni mal mamu, najuh émit yay épegulo, ban Biinum Banabe m’búavul birembor ni o ti gálab. ");
INSERT INTO bqj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni baj firim fúᵽurul n’émit fuoh : « Aw uomme Añolom o nifaŋ me níbbolie ; ésumayom ᵽe ni aw yom. » ");
INSERT INTO bqj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","To baenah, Biinum Banabe m’biilen Yésu ajow bi ni gafit gagu gámah gagu. ");
INSERT INTO bqj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nanamo bo gunah úvi gúuba (40) ; ban ni gunah gaugu, Seytane náh’álingen gáinen gagu gola. Narobo bo o ni súnuhureŋ sasu saa baha, ban emalakaay nihi gucokorol bo. ");
INSERT INTO bqj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ni gunah gaugu, n’gujoh Saaŋ Batis gúrur ni fipeh. Ᵽúrto, Yésu najow bi Gálile ; navare bo Firim fafu Fásum me fal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nah’aah : « Tinah talu tabeli me tiĉige, Jávi Aláemit julofulo ! Jihat bakanerul baarat me min jíinen Firim fafu Fásum me ! » ");
INSERT INTO bqj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Funah fice, Yésu o n’ejow galam fal fafu fáᵽurut me faa Gálile, najuh umbala gúuba, Simoŋ ni atiol Andere, gubet simbalil dó ni fal faufu. ");
INSERT INTO bqj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naagil : « Jújoul jilagenom, ban ᵽan ikanul jíni umbala bugan. » ");
INSERT INTO bqj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","To baenah, n’guhato simbalil min gulagenol. ");
INSERT INTO bqj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","No Yésu abbañ me atos ráli maa, najuh Saak ni atiol Saaŋ, guñol Sebede, gúni m’busanail n’gaheten simbalil. ");
INSERT INTO bqj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","To baenah navogil ; n’guhat ᵽail ni urokaaw dó ni busana babu min gúᵽurul gujaor ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ᵽúrto, Yésu ni ulagorol n’gujow bi n’ésuh ece yo guvoge me Kaᵽerinaum. No fíiyay Esúif yay fiĉih me, Yésu nanogen ni yaŋ yay yaa galaw, aban nanamo éᵽajul ésuh yay gurim Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bugan bugagu n’gujahali baligenerol faŋ, mata naligeneligen ti an ayabe sembe, búli ni wo úᵽajula gúboñ Aláemit bugagu nihi guligen me. ");
INSERT INTO bqj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bajen dó ni yaŋ yauyu yaa galaw ace áine o eseytane enone ; áine ahumu náᵽib aah : ");
INSERT INTO bqj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","« Yésu ala Nasaret, wa numaŋe ni wóli ? Nukelo jabanóli ? Niffase ay nom : An ahu anab me ala Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yésu nannur yo aah : « Uᵽanor, ban núᵽur cab n’áine ahumu ! » ");
INSERT INTO bqj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ñer eseytane yay nekan áine ahu nailo avenjeŋor, mbiban néᵽur ni o n’eya nímoro gáᵽib gámah. ");
INSERT INTO bqj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bugo ᵽe gajahali n’gunonil iki nihi gurorenor guoh : « Dáuru wa uomme úru ? Baligener mul bice buvugul bal an ayabe sembe ! Hani may siseytane sasu nihi súttun wo nalobe so me. » ");
INSERT INTO bqj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ñer gajaol n’gufaen guuno ni mof mamu ᵽe maa Gálile. ");
INSERT INTO bqj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","No Yésu áᵽullo me ni yaŋ yay yaa galaw, najow bi yaŋ Simoŋ ni Andere, manur ni Saak ni Saaŋ. ");
INSERT INTO bqj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Toker aol Simoŋ aarema umuen dó min afiye bújusa bajogerol ; n’gufaen gulob Yésu mola. ");
INSERT INTO bqj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ñer Yésu nalofol, najogol n’gañen ailen, ban bújusa babu m’búᵽur to baenah ni o, min ñer aare ahu anamo ecokoril. ");
INSERT INTO bqj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mb’uĉiga gállim, no fíbiñel fulo me, n’guŋallol úsotaaw ᵽe ni bugagu bugo siseytane sunogen me. ");
INSERT INTO bqj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Esúh yay ᵽe n’gúᵽurul gúkail guomunor to bújoŋor ganegen yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ñer Yésu nasen gahoy bugan gammeŋe bugal úsomut wábuliore. Naham ᵽoᵽ siseytane sammeŋe, ban nemme siffasol, ahalut so min sulob. ");
INSERT INTO bqj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tinahurab, to m’basarerut, Yésu nailo aban náᵽurul ajow bi tiñ talikoe ak’anamo bo galaw. ");
INSERT INTO bqj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoŋ ni bugagu gaamen to me ni o, no guiyulo me, n’guilo guliᵽol. ");
INSERT INTO bqj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","No gujugol me, n’guogol : « Bugan bugagu ᵽe aw guliᵽe mee ! » ");
INSERT INTO bqj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naagil : « Utosal mbaa sasu súsuh salof me yauye, tima nivare bo may ; mata dáuru diĉile níjoul. » ");
INSERT INTO bqj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ᵽúrto, najow mof mamu maa Gálile ᵽoomo, nah’avare ni saŋ sasu saa galaw n’eham siseytane sasu nímoro. ");
INSERT INTO bqj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Funah fice, ni baj ánaine o háhae ejoge ájoul atoh Yésu. No nalofol me, nalo aya gújulol naagol n’efotenor dó : « Umaŋ me, nújue ukanom nihoy ijañ ti no ! » ");
INSERT INTO bqj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yésu enilol nerum áine ahumu bireg naalen gañenol agorol naagol : « Yoo, nimaŋe. Uhoy ujañ ! » ");
INSERT INTO bqj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","To baenah háhae yay néᵽur ni o, ban nakur. ");
INSERT INTO bqj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ñer Yésu nabbañenol akay n’eĉafol táñi nímoro ");
INSERT INTO bqj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","aah : « Ukánum ! Jamb’ulob yo me ánoan, bare ujow iki ateŋena ahu ajugi, ban nukan bíteŋen babu bo gúboñ gagu gaa Móis gulob me, min ugiten ésuh yay búoh nuhohoy. » ");
INSERT INTO bqj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bare áine ahu no náᵽullo to me, nanamo eamben fatiya elob yay aban babu ᵽe, bireg Yésu abbañut áju anogen n’ésuh m’babbuyut. Ñer náh’átij babu tíyaŋ tiñ talikoe, bare mánoman, bugan bugagu nihi gúᵽurul ulam waw ᵽoowo íkiil gutogol. ");
INSERT INTO bqj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ᵽúrto gunah guman, Yésu nábbañul bi Kaᵽerinaum. Bugan bugagu n’gufaen guun búoh umu súndo ");
INSERT INTO bqj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","min gúteil fuyoŋ íkiil guomunor dó, bireg gureut hani to n’gánonum gagu. Yésu nanamo egitenil Firim fafu Fásum me. ");
INSERT INTO bqj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ñer ni baj wáine gubbagir gútebul an abofoe mbaa ni o. ");
INSERT INTO bqj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nemme gújuut guĉih to naamme mala jammeŋ jaju jaa bugan bugagu, ñer n’gúhaful bimilum babu bíᵽimbor to Yésu ailo me, guban n’gúannul n’élu yauyu abofoa ahu ni gapeh gagu dó nafileni me. ");
INSERT INTO bqj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","No Yésu ajuh me gáinenil, naah abofoa ahu : « Añúm, utili uboketiboket. » ");
INSERT INTO bqj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bajene úᵽajula gúboñ Aláemit ganamoen to, ban nihi guᵽinor guoh : ");
INSERT INTO bqj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","« Aíne ahumu bu nájue alob mee ? Dáuru gújel Aláemit ! Arafuhow ay ájue aboket util, íni let Aláemit bareol ? » ");
INSERT INTO bqj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","To baenah, Yésu naffas gaᵽinoril min aagil : « Wa uĉile n’jibaj gaᵽinor ti gaugu ? ");
INSERT INTO bqj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Julobom ᵽaa, eoh abofoa ahu “Utili uboketiboket,” ter eogol “Uilo, uŋar gapegi min ujow,” wa ufaŋe ésum elob ? ");
INSERT INTO bqj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bare waf wanur nimaŋe jiffas : Añol Arafuhow nayayab babe ni mof sembe n’Aláemit sal eboket util bugan bugagu. » Naban nábaho mbal abofoa ahu naagol : ");
INSERT INTO bqj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","« Injé ilobi yo, uilo nuŋar gapegi min uot bi yaŋi. » ");
INSERT INTO bqj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ñer to baenah, abofoa ahu nailo, naŋar gapegol aban náᵽur bújoŋoril bugo ᵽe. Gajahali gámah n’gunonil bireg n’gunamo esalen Aláemit nihi guoh : « Júmusut jujuh waf ti wauwu. » ");
INSERT INTO bqj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ᵽúrto, Yésu nabbañ áᵽur ajow bi galam fal fafu fáᵽurut me faa Gálile ; ñer fítiman fafu ᵽe ni fújoul futogol bo min anamo gavareil. ");
INSERT INTO bqj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","No natos me maa, najuh ace áine gajaol Lévi, áᵽur Alife, arobo to nah’ayab me búalen. Yésu naagol : « Ulagenom ! » Ñer Lévi naiyul alagenol. ");
INSERT INTO bqj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Búsol, Lévi navoh Yésu ni ulagorol fitiñ yaŋol, manur n’uyaba-búalen gammeŋe, ni bugan bugo ujail uhajene may ; maagen bugan gammeŋe ti bugaubugi ubuguen n’elagen Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ñer úᵽajula gúboñ Aláemit bugagu bugaa gayoŋ gagu gal Eᵽárisie yay, no gujugol me áni n’etiñor ni bugan bugaubugi, n’guoh ulagorol : « Wa uĉile náni n’etiñor n’uyaba-búalen bugagu ni bugagu utila ? » ");
INSERT INTO bqj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nemme Yésu naune wo gulob me, naagil : « Let bugan bugagu gaamme apuñil guŋese ásotena, bare til úsotaaw. Mo may ijoulat bi evoh bugan bugagu gaĉol me, bare til utilaaw. » ");
INSERT INTO bqj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Funah fice, ulagora Saaŋ Batis ni Eᵽárisie yay n’gúni m’baor. Ñer bugan guce n’gúkail guoh Yésu : « Wa uĉile ulagora Saaŋ Batis ni Eᵽárisie yay nihi guor min búguiya mati nihi guor ? » ");
INSERT INTO bqj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yésu naagil : « Jíinene ᵽiaŋ búoh funah faa búyabo, ubuge ayaba ahu gújue ᵽiaŋ guor aĉila baamer to ni bugo ? Nánonan no naroŋ to ni bugo, gújuut guor. ");
INSERT INTO bqj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bare funah fice ᵽan fiĉigul no gujae me eram ayaba ahu n’guñenil ; no ñer ᵽan guor me. ");
INSERT INTO bqj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","An nd’aŋar gaĉaĉ gavugul gal épis ateh gaᵽoroh ni bisimo bufan ; akan mo me, gaĉaĉ gagu gavugul gagu ᵽan gunoĉul gafan gagu min til ñer élu yay efaŋ gauŋ. ");
INSERT INTO bqj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","An nd’aoren ᵽoᵽ bunuh bijeb ni siĉan sifan aban natoj so ; akan mo me, bunuh babu ᵽan bufaĉ so min ñer so ᵽooso súbburi. Bare til níh’íni mee nuoren bunuh babu bijeb babu ni siĉan sasu suvugul sasu. » ");
INSERT INTO bqj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Funah fice faa fíiyay, Yésu ni ulagorol n’gúni n’esat ulah waw. Bugo n’ejow yay, ulagorol n’gunamo eheŋ gukoñ gagu. ");
INSERT INTO bqj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ñer Eᵽárisie guce n’gúkail guogol : « Aᵽaa uluj ! Wa uĉile ulagorai n’gúni n’ekan waf wo gúfirene funah faa fíiyay ? » ");
INSERT INTO bqj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Naagil : « Buru til júmusut jijanga wo David akan me funah fice no bieb bujogil me, o ni galageneol me ? ");
INSERT INTO bqj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Leti nanogenogen ni Fúggut Aláemit, gannay gagu go Abiatar aamen me afan uteŋenaaw, aban náŋarul unaĉ waw wo gúji ró me Aláemit gutiñ aĉila ni galageneol me ? Ban unaĉ wauwu uteŋenaaw bugo bareil guote gutiñ wo. » ");
INSERT INTO bqj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aban naagil : « Fíiyay fukanikan bi ni arafuhow, bare let arafuhow akani bi ni fo. ");
INSERT INTO bqj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yo eĉil me Añol Arafuhow o aamme afan ahu ala fíiyay fafu fololal. » ");
INSERT INTO bqj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Funah fice, Yésu nabbañ anogen ni yaŋ yay yaa galaw. Ni baj ró ánaine ace ahaje ni gañenol. ");
INSERT INTO bqj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ñer Eᵽárisie yay gaam dó me n’gunamo elujor Yésu ter ᵽan asenol gahoy funah faufu faamme faa fíiyay, min mbi gúju gújogumol ni yo. ");
INSERT INTO bqj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yésu naah áine ahu ala gañen gagu : « Uilo tautu bújoŋor ésuh yay ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aban naagil : « Wa gúboñ gagu gulobe ekan funah faa fíiyay : maaro ter maarat ? Eᵽagen buroŋ an ter ehalol naĉet ? » N’guᵽanor to cem. ");
INSERT INTO bqj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ñer Yésu ni mujogol mala muak uinumil. Nailo abbaŋil gúĉil ni bitiña-fiiñ dó, aban naah áine ahu : « Uraw ᵽaa gañeni ! » Naraw go, ban n’guhoy to baenah. ");
INSERT INTO bqj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ñer Eᵽárisie yay n’gúᵽur tíyaŋ, n’gufaen gujugor to ni majase ni bugaa gayoŋ gagu gaa Herod bi effas bu gujae ekan min gunemen Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ᵽúrto, Yésu nañago abbañen mbaa fal fafu fáᵽurut me faa Gálile n’ulagorol dó. Fítiman fámah ni fulagenol, faa bugan gáᵽullo Gálile, Yúde, ");
INSERT INTO bqj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yérusalem, Idúme, súsuh sasu saamme ñagagu fal fafu faa Suruden, ni ulam waw waa Tir ni Sidoŋ. Fujoulojow bi ni o, mata fuuwun wo nakane me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ñer Yésu naah ulagorol guliᵽulol jisana jíni n’guñenol, mamu jambi fítiman fafu fugogenol. ");
INSERT INTO bqj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Maagen mamu, nemme násotenesoten bugan gammeŋe, bugan bugagu ᵽe gásomut me nihi guvunorul mbal aĉila bi egorol. ");
INSERT INTO bqj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bugan bugagu bugo siseytane sulo me gujugol me, ni sikanil n’guya gújul bújoŋorol n’gúᵽib fatiya guoh : « Aw uomme Añol Aláemit ! » ");
INSERT INTO bqj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bare o nah’annur so táñi bi éfiren so jambi súᵽunnol n’ésuh. ");
INSERT INTO bqj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mbiban, Yésu najiŋ n’erijaŋ ece yaamen galam gaugu ; navoh bugo namaŋ me n’gujow gutogol dó. ");
INSERT INTO bqj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naĉob ni bugo bugan gono guñen ni gúuba gajae me éni to ni o, ni ᵽoᵽ bi eboñil guke gavare, ");
INSERT INTO bqj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni sembe sasu ró sal eham siseytane sasu. ");
INSERT INTO bqj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bugo naĉob me, ujail uwe : Simoŋ, o natajen me gajow gagu gaa Ᵽier, ");
INSERT INTO bqj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saak ni atiol Saaŋ, guñol Sebede, bugo nasale me Boaneruges, dóemme \"guñol fuᵽaranu\", ");
INSERT INTO bqj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere, Fílip, Barutelemi, Mácie, Toma, Saak añol Alife, Tade, Simoŋ atigena ahu ");
INSERT INTO bqj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Yudas Isikariot, ajae me ennomen Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mbiban n’gúbbañul bi ni yaŋ yay. Fítiman fafu ni fubbañ fuomunor iki gubajout bi fitiñ. ");
INSERT INTO bqj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","No buganol guun yo me, n’gújoul bi ejogol gújaenum ni sembe, mata n’gaᵽinoril naliolio. ");
INSERT INTO bqj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ni baj úᵽajula gúboñ Aláemit gáᵽullo Yérusalem guoh : « Belisebul, aamme afan siseytane sasu, aam ni o ; o aĉile náju nah’aham so. » ");
INSERT INTO bqj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ñer Yésu navogulil, naŋar búnogor nalob ni bugo aah : « Bu Seytane ájue aham Seytane ? ");
INSERT INTO bqj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bugan gagume jávi gutigenoro me, jávi jauju ᵽan jinemo. ");
INSERT INTO bqj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ban may bugan gagume yaŋ gutigenoro me, yaŋ yauyu ᵽan enemo. ");
INSERT INTO bqj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iní me maagen Seytane naiyuloilo bi etigenoro, kan nagabogabor, ban añumut eᵽio ; mola ñer mubae. ");
INSERT INTO bqj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","An ájuut anogen ni yaŋ yal an abaje sembe ák’ákuet ró fubajol o m’bamundumut ajogol ahoh ; aban me, no ñer ᵽan áju me ákuet waamme ni yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Maagen, ínje ilobul yo, util waw ᵽe wo bugan bugagu gukane me újue uboketi, ti ᵽoᵽ ujel waw wo gujel me guya n’Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bare an ajel me Biinum Banabe, an ahumu mát’ámus ayab gaboket ; nabaje gatil go mati gúmus gunemo. » ");
INSERT INTO bqj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yésu nalobil mee mala min guoh me eseytane eom ni o. ");
INSERT INTO bqj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","No jaw Yésu ni gutiol guĉilo me, n’guilo bo tíyaŋ min guboñ guvogulol. ");
INSERT INTO bqj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Fítiman fafu funamonamo fúgolol fúharo ; ni baj an aagol : « Uutten ᵽaa, jai, gutii ni gúlini ubugi tíyaŋ, ban aw gumaŋe bujuh. » ");
INSERT INTO bqj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yésu naah : « Ay aamme jaom ? Bugay guomme gutiom ? » ");
INSERT INTO bqj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mbiban, nailo aluj abosor bugan bugagu ganamo me gúgolol, aban naah : « Jaom ni gutiom faŋ bugo guomme ubuge : ");
INSERT INTO bqj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ánoan akane wo Aláemit amaŋ me, an ahumu o aamme atiom, álinom, jaom. » ");
INSERT INTO bqj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ᵽúrto, Yésu nabbañ anamo gavare galam fal fafu fáᵽurut me. Fítiman fámah ni fúkail fuomunor to ni o bireg nájuᵽo ni busana min atos ahat fibil fal fafu. Fítiman fafu ᵽoofo fo ni fíni bo galam fal fafu. ");
INSERT INTO bqj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ñer naŋar búnogor min avareil waf wammeŋe nah’aagil : ");
INSERT INTO bqj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","« Juutten ! Baje abela-euh ace áᵽullo bi eke ebet euh. ");
INSERT INTO bqj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","O n’ebet euh yay, eceyo nelo n’galam bulago ; upu waw n’úkail utiñ yo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yayuyo nelo tiñ taa sival, to eus emmeŋut ; nefaen eil mata guar yo gújuut gunogen síki. ");
INSERT INTO bqj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bare no tinah talu tirabulo me, nepab ehay kak mala min guar yo gujout me síki. ");
INSERT INTO bqj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eceyo yo nelo tiñ taa sijeŋ. Sijeŋ sasu ni síbbagul iki súnumen yo, min ñer etogut ebuh mitiñ. ");
INSERT INTO bqj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ece nelo ni mof maaro ; eĉila nebbah wári iki ebuh mitiñ mimmeŋ : uhager uce n’ubugor wono ávi ni guñen, uce úvi gúfaji, wawu ekeme. » ");
INSERT INTO bqj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mbiban Yésu naah : « An abaj me gunnu gal eun, aun. » ");
INSERT INTO bqj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","No guŋaño to me bugo bareil, o, galofol me ni ulagorol gaamme guñen ni gúuba, ubuge n’gurorenol mala únogor wauwu wo nalob mee ni wo. ");
INSERT INTO bqj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naagil : « Buru Aláemit nájiulji min júju jujoh firim fafu faa Jáviol fásiki me ; bare bugagu gábuli me ni buru, waf waw ᵽe únini ni bugo ti urej tíj to. ");
INSERT INTO bqj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Maagen Bahiĉer babu buoge : “Mánoman guluje, mati gujuh, mánoman guuttene, mati gujoh, dó ᵽe jambi funah fice n’gúbbañul mbal Aláemit min guyab gaboket gal utilil.” » ");
INSERT INTO bqj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yésu natajen aagil : « Jujogut wo búnogor baube bulobe ? Bu ñer jijae éju jujoh wawu únogor ? ");
INSERT INTO bqj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yoo. Abela euh yay, Firim fafu Fásum me naam n’eroh. ");
INSERT INTO bqj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bugan bugagu bugo guomme ettam yay. Gaamme ti galam bulago babu dó firim fafu furogi me, bugo guomme gayañ me eun fo, bare ŋait Seytane naĉigul min áᵽuren warogi me ni bugo. ");
INSERT INTO bqj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bugagu gaamme ti tiñ taa sival, bugo guomme gaun fo me, ban n’gufaen guyab fo to baenah n’ésumay ró, ");
INSERT INTO bqj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bare fiilut guar ni bugo ; bugo bugan bugom gañumut eᵽio : no sílam sasu ni gálatien gagu sijae me eĉigul mala firim faufu, n’gufaen gubelen gáinenil. ");
INSERT INTO bqj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bugaguil gaamme ti tiñ taa sijeŋ, bugo guomme gaun fo me, ");
INSERT INTO bqj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mbiban gaᵽinor gagu gaa buroŋ be, gásibo fubaj, eliᵽ másume mánoman ni síkail súnumen fo min fújuut fubugor ni bugo. ");
INSERT INTO bqj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bugaguil gáni me ti mof maaro, bugo guomme gaune fo me, n’guyab fo wári mbiban, n’gúŋarul ni buroŋil waf waaro wammeŋe ti emano : uhager uce n’ubuh wono ávi ni guñen, wawu úvi gúfaji, ucewo wono ekeme. » ");
INSERT INTO bqj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yésu nabbañ aagil : « An nah’asaesaen ᵽiaŋ ejaŋa mbiban naŋar yo árur n’elaᵽ ter fattam bura ? Leti ᵽan aremben yo n’ebamba ? ");
INSERT INTO bqj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bajut waf wakoᵽeni wañumuti egiten ; bajut waf wafuli wañumuti éᵽuren ni maŋannoe. ");
INSERT INTO bqj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","An abaj me gunnu gal eun, aun. » ");
INSERT INTO bqj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Natajen aagil : « Jikan to uinumul ni wo juune me. Galigum gagu go jijae me eŋar n’jilih bugan bugagu, go may Aláemit ᵽan aligumul me ni go, mbiban ᵽan atajen anaᵽul to waf uce. ");
INSERT INTO bqj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","An abaj me, ᵽan ayab faŋ to ; bare an abajut me, o ᵽan guramol ᵽe bi ni jo náhagum me ró. » ");
INSERT INTO bqj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yésu nabbañ aagil : « Jávi Aláemit jínini ti an aam n’ebet euh n’ettam. ");
INSERT INTO bqj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Amóri-o, álio-o, min sufuga sasu ni sutufunaha sasu sígale me, euh yay ᵽan eil nebbah ék’éjalo o m’baffasut to wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ettam yo neh’ejjonenoro waf yo : ᵽan emundum ni gafos gagu, mbiban fukoñ fafu, balama búsol bahager babu m’bimmeŋen kab fukoñ fafu ; ");
INSERT INTO bqj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ban no mitiñ mamu mukae mual, nárur dó garusumol, mata eᵽit eĉige. » ");
INSERT INTO bqj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yésu nabbañ aah : « Jávi Aláemit ni wa ᵽiaŋ nújuale uligoral jo ? Búnogor bay ᵽiaŋ bújue búᵽajul jo ? ");
INSERT INTO bqj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jínini ti jukol buyaba jo guroge n’ettam. Jo jifaŋe gatiti mukol mamu ᵽe ; ");
INSERT INTO bqj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","bare no jurogi, ᵽan jiilul iki jifaŋ gabbah mununuh mamu ᵽe maam dó me ni gafat gagu, ban ᵽan jijef uan wájaloe ; mamu upu waw n’úju ulef ró. » ");
INSERT INTO bqj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Unógor wammeŋe ti baube Yésu nah’aŋar me min agitenil Firim fafu Fásum me, re ni wo gúju me gujoh. ");
INSERT INTO bqj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nd’alob ni bugo o m’baŋarut únogor ; bare gunamo me o ni ulagorol bugo bareil, náᵽajulil wo ᵽoowo. ");
INSERT INTO bqj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Funah faufu fanur fafu tinah n’eseor, Yésu naah ulagorol : « Utíᵽal fal fafu uloal ñagagu. » ");
INSERT INTO bqj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ñer n’guhato fítiman fafu min gújaenumol ni busana babu dó naamme ; ni baj ᵽoᵽ usana uce unaᵽ bola. ");
INSERT INTO bqj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ᵽiout, fúrus fámah ni fiiyulil ; gulongos gagu n’gúloul dó ni busana babu iki bufaen bíni n’emmeŋ mal. ");
INSERT INTO bqj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bare aĉila Yésu umuen ni fúrum busana babu min afiye áhag fuhool ni fúhagoum náni n’gámori. Ulagorol n’gúliol n’guogol : « Afanóli, buenne ? Butumi bilebo min uomal maa n’ejow bi eĉet ? » ");
INSERT INTO bqj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ñer nailo nannur fúrus fafu, aban naah fal fafu : « Uᵽanor ! Ulluhor ! » Ñer fúrus fafu ni fuhat, ban fal fafu ni fíjebi yem. ");
INSERT INTO bqj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mbiban naagil : « Wa uĉile n’júholi re me ? Bu jilet mee n’ebaj gáinen n’ínje bi maer ? » ");
INSERT INTO bqj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ñer gáholi gámah n’gunonil ban nihi guogoro : « An bu om umu, iki fúrus fafu ni fal fafu síkanumol ? » ");
INSERT INTO bqj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ñer Yésu ni ulagorol n’guke guya ñagagu fal fafu, ni mof mamu maa Gerasa. ");
INSERT INTO bqj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","No Yésu aavulo me ni busana babu, ni baj ace áine o eseytane enone áᵽurul ni guyah gagu ájoul ban guemor. ");
INSERT INTO bqj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aíne ahumu ni guyah gagu naĉine, ban an ájuutol ehoh, hani nah’aogen ñisel. ");
INSERT INTO bqj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ñammeŋe gukanol mañ ni guot, ban ᵽoᵽ gujekol ni ñisel, bare nasaresaren ñisel ñañu ban ᵽoᵽ natutuj mañ mamu, ban an abajut sembe sasu sal ekanol naluhor. ");
INSERT INTO bqj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nánonan, etufunaha ti efuga, nah’ayunor bo me ni guyah gagu babu ni gurijaŋ gagu, náh’áᵽib ban nah’aŋar sival nábukenoro. ");
INSERT INTO bqj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","No naŋanden me Yésu ráli, natey iki guemor, aban naya gújul bújoŋorol ");
INSERT INTO bqj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","min aah fatiya : « Yésu, Añol Aláemit-Fatiya, wa numaŋe n’ínje ? Nilai ni gajow gal Aláemit, jamb’úlamenom. » ");
INSERT INTO bqj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nalob mee mala min Yésu aah yo me : « Eseytane, úᵽur n’áine ahumu ! » ");
INSERT INTO bqj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mbiban naroren yo : « Gajai bu ? » Neogol : « Gajaom Fítiman, mata wóli jimmemmeŋ. » ");
INSERT INTO bqj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ñer to baenah, nelaw Yésu jambi aham so súᵽur mof mamu. ");
INSERT INTO bqj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ban bajen to galam erijaŋ yay ekore yámah yaa suhumba yaam ni gafen. ");
INSERT INTO bqj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ñer siseytane sasu ni silaw Yésu n’suogol : « Uhalóli n’junogen suhumba sausua. » ");
INSERT INTO bqj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Namaŋ. Ñer ni súᵽur sunogen suhumba sasu, ban ekore yay, yabaj me maageima suhumba sono súuli súuba (2 000), néᵽaᵽoul dó fitey fatiya mavaŋoe firijaŋ fafu eriŋoul bi ró ni fal fafu ek’elo ró enemo ᵽooyo. ");
INSERT INTO bqj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","No ukoña so gujuh me dáuru, n’gutey iki guvis elob yay n’ésuh yay bi babu n’ulah waw. Ñer bugan bugagu n’gúᵽurul gúkail bujuh wabaj me. ");
INSERT INTO bqj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","N’gújoul gutoh to Yésu, ban n’gujuh to ᵽoᵽ áine ahu alaen fítiman siseytane sasu, min anamoe masimoe ban apuñol jas. Ñer gáholi n’gunonil. ");
INSERT INTO bqj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bugagu gamat me wabaj me alaen siseytane sasu ni suhumba sasu n’guilo gugitenil wabaj me. ");
INSERT INTO bqj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ñer n’guilo gumanani Yésu tima náᵽur ahat ésugil. ");
INSERT INTO bqj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","No Yésu aamme n’éjuᵽo ni busana babu, áine ahu abajen me siseytane sasu nalaol tima nahalol narobo to ni o. ");
INSERT INTO bqj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bare Yésu naceŋol naagol : « Uot mbaa bugani, ban nugitenil waf waw ᵽe wo Ataw akani me, bu narumi me enil. » ");
INSERT INTO bqj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ñer áine ahu nakay, aban nanamo eamben ni mof maumu mo guvoge me Dekapolis wo Yésu akanol me. Bugan bugagu ᵽe n’gujahali. ");
INSERT INTO bqj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ᵽúrto, Yésu nabbañ asat alo ñagagu, ban manur mamu fítiman fámah ni fúkail fuomunor to ni o galam fal fafu fáᵽurut me to naamme. ");
INSERT INTO bqj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ñer ace n’ufan yaŋ yay yaa galaw yal Esúif yay, gajaol Yairus, nájoul. No najuh me Yésu, nalo to n’guolol ");
INSERT INTO bqj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aban nalaol to baenah naagol : « Bájurom umu n’eĉet. Ujóul urembenol guñeni tima nahoy min abbañ aroŋ. » ");
INSERT INTO bqj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ñer Yésu najaor ni o. Fítiman fámah ni fulagenol, ban ni fumaporol fúharo. ");
INSERT INTO bqj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ni baj dó anaare ace abaje gásomut gal ébbur físim kábiriŋ símit guñen ni súuba. ");
INSERT INTO bqj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Maagen mamu aare ahumu nayoge faŋ n’ejow guñen bi ni guñen gal úsotena gammeŋe. Nabelene fubajol ᵽe m’babajut gáhoyum gánogan ; gásomulol no til gufaŋe n’guĉimene. ");
INSERT INTO bqj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","No naun me gulob mala Yésu, nabbuyul búsolol dó ni fítiman fafu ákail agor bisimool. ");
INSERT INTO bqj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Maagen mamu nah’aah ni biinumol : « Ijú me igor bisimool barebare, ᵽan ihoy. » ");
INSERT INTO bqj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ñer to baenah ébbur físim yay yola nehat, ban najuh n’enilol búoh gásomulol guhoe. ");
INSERT INTO bqj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","To baenah, Yésu najuh búoh sembe sice súᵽure ni o. Ñer nábaho ró n’etut fítiman fafu, aban naah : « Ay agore bisimoom ? » ");
INSERT INTO bqj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ulagorol n’guogol : « Aw nujuge fítiman fafu faĉimenei maa, nubbañ mul uroren ay agori ! » ");
INSERT INTO bqj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bare Yésu nanamo eluj abosor to naamme bi ejuh ay akan mee burok baubu. ");
INSERT INTO bqj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ñer aare ahu, nemme naffase wabajol me, nanamo etelenor mala gáholi. Nájoul ákail alo to ni guot Yésu, aban nalobol maagen mamu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ñer Yésu naagol : « Bájurom, gáineni guᵽageni. Ujow ni gásumay, uhoy ujañ ni gásomuli. » ");
INSERT INTO bqj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","O n’elob yay, ni baj bugan gáᵽullo yaŋ Yairus, afan yaŋ yay yaa galaw, gúkail guoh Yairus : « Bájuri naĉele ! Jamb’uin bo nuke eyogen afan ahu utajen ! » ");
INSERT INTO bqj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bare Yésu akanut n’gaᵽin gurim gaugu, naah Yairus : « Jamb’úholi, úinen barebare. » ");
INSERT INTO bqj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mbiban ahalut ánoan nalagenol, íni let Ᵽier, Saak, ni atiol Saaŋ. ");
INSERT INTO bqj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","No guĉih me yaŋ Yairus, Yésu najuh bugan bugagu n’gújajasore me, n’gukoŋe me n’guya úᵽib nímoro. ");
INSERT INTO bqj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nanogen dó ni yaŋ yay, aban naagil : « Wa uĉile éjajasor yauye ni ukoŋ wauwe ? Añil ahu aĉelut, námorimori. » ");
INSERT INTO bqj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","N’gunamo éfohulol. Ñer náᵽunnulil bugo ᵽe, aban naŋar ᵽay añil ahu ni jaol ni ᵽoᵽ bugagu gajaorulo me ni o, min gunogen dó añil ahu aamme. ");
INSERT INTO bqj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","No naĉih ró me, najoh bájur babu ni gañen, aban naagol : « Talita kúmi ! » Dóemme : « Jújur jaju, niegi uilo ! » ");
INSERT INTO bqj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","To baenah, bájur babu nailo ban nanamo ejow. (Símit guñen ni súuba nabaje.) Ñer bugo ᵽe ánoan ajugut enilol, min gujahalie faŋ. ");
INSERT INTO bqj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ban Yésu naĉafil liŋ tir jambi an affas yo me, aban naagil gusenol atiñ. ");
INSERT INTO bqj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yésu náᵽur to abbañ bi ni mof mamu dó nabugi me, n’ulagorol dó. ");
INSERT INTO bqj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","No funah fafu faa fíiyay fiĉih me, nanamo eligen bugan bugagu ni yaŋ yay yaa galaw. Bugan gammeŋe ni gautteneol me n’gujahali n’guoh : « Bay naŋallo gaffas gaugu ? Ay asenol malillo maumu ? Bu nájue nah’akan waf waunderuti ti wauwu ? ");
INSERT INTO bqj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Leti dáuru acokora gurihinjaŋ ahu, añol Mari, ati Saak, Susef, Síd ni Simoŋ ? Leti gúlinol guom maa tale ni wolal ? » Ñer úru ᵽe n’diĉilil n’gulat éinen ni o. ");
INSERT INTO bqj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bare naagil : « Aboñer n’ésugol bare náh’ákeruli, ni buganol, dó ni yaŋol. » ");
INSERT INTO bqj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ñer, ᵽúrdo eremben guñenol úsota guman min guhoy, abbañut akan dó waf uce waunderuti. ");
INSERT INTO bqj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Najahali faŋ gáinenut gaugu golil. Ᵽúrto, Yésu najow súsuh sasu salof to me n’eligen bugan bugagu nímoro. ");
INSERT INTO bqj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mbiban, navoh uᵽotoraol gaamme guñen ni gúuba (12), aban naboñil gúuba-gúuba, ni sembe sasu ró sal éᵽuren siseytane. ");
INSERT INTO bqj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Naagil jambi an ni bugo aŋar bi bújaor babu ter mitiñay, ter baet, ter síralam so nahoge ni fuhoŋolol ; mb’aŋar egol bare. ");
INSERT INTO bqj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mbi may akano sidala, ban jambi aŋar bisimo búutten. ");
INSERT INTO bqj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nabbañ aagil : « Jiĉih me n’ésuh, yaŋ yánoyan dó junone min guyabul, jurobo ró bi no jijae me éᵽur tiñ tautu. ");
INSERT INTO bqj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Iní me jiĉige tice bugala ró n’gulat eyabul ni ᵽoᵽ euttenul, jifa bulagoul, ban n’ejaul mbi jiᵽaᵽ gulaul : dó ᵽan níme baĉaf babu bolil. » ");
INSERT INTO bqj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ñer n’gukay ban nihi guvare bugan bugagu mala eteh mahat ni ᵽoᵽ ébahen bakaneril. ");
INSERT INTO bqj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nihi guham siseytane sammeŋe, nihi ᵽoᵽ guñend úsota gammeŋe míĉir min gusenil gahoy. ");
INSERT INTO bqj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ñer ávi ahu Herod nabil aun mala Yésu. Maagen mamu gajow Yésu gufaŋefaŋ n’guunoe, ban bugan bugagu nihi guoh : « Dáuru Saaŋ Batis aiyulo mee ni gaĉet me, yo eĉil me nabaj sembe sausu sal ekan waf wajureruti. » ");
INSERT INTO bqj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bugagu nihi guoh aboñer ahu Elí om, guceil n’guoh ace n’uboñer waw bugaa no, o abbanno. ");
INSERT INTO bqj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bare Herod no naun me dáuru ᵽe naah : « Saaŋ Batis ahu o niboñ me guᵽirih fuhool, o aiyulo ni gaĉet me ! » ");
INSERT INTO bqj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maagen mamu, Herod faŋaol naboñemboñ gujoh Saaŋ Batis min guhogol ñisel ban n’guŋarol gúrur ni fipeh. Dáuru ᵽe mala Herodias aar atiol Fílip o nábahen me akan aarol, ");
INSERT INTO bqj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ban no Herod akane mo me Saaŋ naagolseh : « Senuti min uram aar atii ! » ");
INSERT INTO bqj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias nabaŋol ni fiiñ mala yo, ban nah’aliᵽ bi ekanol naĉet, bare ájuut ");
INSERT INTO bqj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mata Herod nákanukanum Saaŋ Batis ; naffase búoh an nam aĉole ban nanab. Nah’apoyol jambi an akanol maarat, ban nánonan no nauttenol, biinumol m’búguo faŋ, abbañut affas bu najae ekan ; bare bae nah’auttenol n’ésumay ró. ");
INSERT INTO bqj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Funah fice ni fiĉigul fájahore ni wo Herodias amaŋ me úju ukano ; fo fuomme no Herod aamme n’ekan gaggan gagu gaa funah fafu faa gabugiol úvulaol, ufan ekosombil yay ni ᵽoᵽ bugan bugagu búgamah bugaa mof mamu maa Gálile. ");
INSERT INTO bqj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Funah faufu, bájur Herodias nánonul dó guomme n’ekan gaggan gagu, aban nanamo eboh. Babogerol ni búsum faŋ ávi ahu Herod ni sijaoraol bireg naagol : « Ucínom wo numaŋ me, ban ᵽan iseni wo. » ");
INSERT INTO bqj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Náfaro aagol n’ebbat ró : « Wánowan wo nujae écinom, ᵽan iseni wo, hani níh’íni ban igabor jáviom gugab gúuba min iseni fafu. » ");
INSERT INTO bqj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ñer bájur babu náᵽurul aĉigul naroren jaol aagol : « Wa ᵽiaŋ mb’ícinol me ? » Naagol : « Ucínol fuhow Saaŋ Batis. » ");
INSERT INTO bqj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nafaen asommen abbañ anogen dó, aban naĉol bi n’ávi ahu Herod naagol : « Nimaŋe uŋallom maer yauye ni biril fuhow Saaŋ Batis. » ");
INSERT INTO bqj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ñer ávi ahu ni mujogol faŋ, bare nemme nabbabat aban bújoŋor sijaoraol, amaŋut abbañ ni firimol. ");
INSERT INTO bqj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nafaen aboñ ace n’upoyaol ni gahoŋen gagu ró gal éŋarul fuhow Saaŋ Batis. Apoya ahu najow bi ni fipeh fafu ak’aᵽirih Saaŋ Batis fuhow, ");
INSERT INTO bqj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","aban náŋarul fo ni biril aĉigul nasen fo bájur babu ; biĉila may m’búbahen fo bisen jaw bo. ");
INSERT INTO bqj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","No ulagora Saaŋ Batis guun yo me, n’gúkail guŋar efuluŋol iki gufoh ni fuyah. ");
INSERT INTO bqj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","No uᵽotoraaw gubbanno me m’bújaoril, n’gúkail guomunor to Yésu aamme min gunamo egitenol wo gukan me ᵽe ni ᵽoᵽ wo guvare me. ");
INSERT INTO bqj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ñer naagil : « Jújoul uñagoal bi tiñ talikoe min jíelo ᵽan jatiito. » Maagen mamu bugan gammeŋe ubugi n’éjoul n’gubbañ, nihi gubbator bireg bugo faŋail gubajout hani bi fitiñ. ");
INSERT INTO bqj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ñer n’gújuᵽo ni busana min gukay ban guñago mbaa tiñ talikoe. ");
INSERT INTO bqj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bare bugan gammeŋe n’gujugil bugo n’ejow yay, ban ni guffas bo gujae me. Ñer bugan bugagu n’gúᵽurul ni súsuh sasu ᵽe ni guot gutey guyabil gayoŋ mbaa to gujae me. ");
INSERT INTO bqj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","No Yésu ni ulagorol guĉih me iki guya min áavul ni busana babu, najuh fítiman fámah, ban enilol nerumil mata gúnini ti ubbarum wabajut akoña ; min ñer anamo eligenil waf wammeŋe. ");
INSERT INTO bqj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","No tinah tikay me, ulagorol n’gulofol n’guogol : « Tíñ taute tilikoliko nár, ban tinah tikae. ");
INSERT INTO bqj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ubbañenil gujow bi ni súsuh sasu salof me tale, tima n’gúju gunnom waf waa fitiñ. » ");
INSERT INTO bqj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bare Yésu naagil : « Buru faŋaul jisenil gutiñ. » N’guogol : « Jibaje ᵽiaŋ síralam saᵽiloe bi énnomul unaĉ íkiil jisenil gutiñ ? » ");
INSERT INTO bqj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naagil : « Jujow julujul ᵽaa unaĉ butumbu jibaje ? » N’gujow iki gúrorenul, guban n’guogol : « Unaĉ futoh ni muol múuba jibaje. » ");
INSERT INTO bqj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ñer naagil gúfaculor bugan bugagu mítiman-mítiman, mbiban n’gukanil n’gunamo n’efos yay ejeb yay ; ");
INSERT INTO bqj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","min ñer gunamo gukan ujit waa bugan ekeme (100) ni ᵽoᵽ waa bugan úvi gúuba ni guñen (50). ");
INSERT INTO bqj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ñer Yésu naŋar unaĉ waw waamme futoh ni muol mamu maamme múuba, náarul gúĉilol fatiya aban nalaw min ásonien so. Mbiban namusul unaĉ waw asen ulagorol gugabor bugan bugagu ᵽe. Nagaboril may muol mamu maamme múuba. ");
INSERT INTO bqj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bugo ᵽe n’gutiñ iki gupoñ guŋañen. ");
INSERT INTO bqj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ñer ulagoraaw n’guomen búŋañen babu baa miᵽirih unaĉ waw ni muol mamu iki ᵽilo utegel wono guñen n’úuba (12) ummeŋ kab. ");
INSERT INTO bqj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gatiñ me, guᵽiloe maageima bugan súuli futoh (5 000). ");
INSERT INTO bqj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","No ᵽúrto me, Yésu nafaen aah ulagorol gújuᵽo ni busana babu min guyabol gayoŋ mbal ésuh ece yaam ñagagu fal fafu yo guvoge me Betusaida, min mb’aĉila faŋaol abbañen fítiman fafu. ");
INSERT INTO bqj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","No nabbañen fo me aban, najow bi n’erijaŋ yay ake bo galaw. ");
INSERT INTO bqj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","No tinah tujon me, busana babu ñer baamer n’etut fal fafu, Yésu náni bo o nevonol. ");
INSERT INTO bqj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Najuh búoh ulagorol ubugu m’bútaj ni gaven, mata gallaj érus yay guom ni go. No nuĉigal me tinahurab, najow n’guot ni fal fafu mbaa bugo bi etobenil. ");
INSERT INTO bqj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","No gujugol me nájaeul mee ni fal fafu, n’guᵽinor búoh dáuru ayaul, min gunamo eya úᵽib. ");
INSERT INTO bqj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bugo ᵽe gujugol, ban gujugut sinilil. Ñer Yésu naramor aagil : « Jifilen uinumul, ínje om ! Jambi júholi ! » ");
INSERT INTO bqj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mbiban najiŋ atogil dó ni busana babu, ban érus yay neilen. Gajahali gámah n’gúni ni bugo : ");
INSERT INTO bqj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","bi maer gujogut ekan unaĉ waw n’ubugor yaunderuti me, mala uinumil waak mee. ");
INSERT INTO bqj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","No gútiᵽ me fal fafu gujow iki guĉih n’ésuh yay yo guvoge me Genesaret, n’guya. ");
INSERT INTO bqj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","No guavulo me ni busana babu, bugan bugagu n’gufaen gútallo Yésu, ");
INSERT INTO bqj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","min guilo gutey mof mamu ᵽoomo, nihi gútebul úsotaaw n’úbil bi tánotan to guune búoh to nam. ");
INSERT INTO bqj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ñer tánotan to nanone, n’ésuh yaa baha ter élulumay ter ni saŋ salikoe saa baha, n’gútebul úsotaaw bi ni funamo ésuh yay min gulaol aboket ahalil n’gugor hani gáñin bisimool bare. Ban bugan bugagu ᵽe gagorol me guyayab gahoy. ");
INSERT INTO bqj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Funah fice, guce n’Eᵽárisie yay ni guce n’úᵽajula gúboñ Aláemit bugagu gáᵽullo me Yérusalem n’guomunor gúgot Yésu gúharo. ");
INSERT INTO bqj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","N’gujuh búoh guce n’ulagorol ubugi ni fitiñ n’guñen gakurut, yoemme m’baᵽosut go ti bulagoil bulob yo me. ");
INSERT INTO bqj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Maagen, Eᵽárisie yay ni bugagu Esúif ᵽooil gúkanukanum mukanay mamu mo sipail gufan guhalil me : ndi gutiñ bugo m’baᵽosut guñenil gukur das. ");
INSERT INTO bqj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ban gúbbañul me marise, ndi gutiñ wáfowaf bugo m’bamundumut guᵽoso. Gúkanume may mukanay mice mammeŋe maa sipail, ti bakaner babu báari me baa gájellul síremuma, uril, uriloŋ.) ");
INSERT INTO bqj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ñer Eᵽárisie yay ni úᵽajula gúboñ Aláemit bugagu n’guroren Yésu guoh : « Bu kane ulagorai gulagenut mukanay mamu mo sipayolal gufan guhalolal me, min til nihi gutiñ sinaŋil ni guñen gakurut ? » ");
INSERT INTO bqj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yésu naagil : « Maagen mamu aboñer ahu Esai nabaje bakoŋ ni buru ! Buru bugan jom gálodit maagen, ti nahiĉ yo me aah : “Bugan bugaubugi ni gurim bare gusaleom, bare uinumil úraliomrali faŋ. ");
INSERT INTO bqj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bíteŋen babu bo gukaneom me burakel bom, mata wo guligene me bugan bugagu, mukanay mom mal arafuhow bare.” » ");
INSERT INTO bqj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yésu náfaro aagil : « Jibelembelen gúboñ gagu gal Aláemit, min jujoh liŋ tir mukanay mo bugan guhalul. » ");
INSERT INTO bqj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Natajen aah : « Maagen mamu buru gújin jom gal elat gúboñ Aláemit, min til jíni n’ejoh mukanay mamu molul ! ");
INSERT INTO bqj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Leti Móis naage : “Ukánum ᵽai ni jai” ? Naage ᵽoᵽ : “An ajel me ᵽayol ter jaol, an ahumu naate amugi.” ");
INSERT INTO bqj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bare buru jiligeneligen bugan bugagu gaa búoh íni me an naage ᵽayol ter jaol : “Wo níjuen me iseni min irambeni, wo uomme koruban” (dóemme \"esarah yabaŋi bi n’Aláemit\"), ");
INSERT INTO bqj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","an ahumu añumut me ebbañ aliᵽ ekan wáfowaf bi ni ᵽayol ter jaol, ban buru jihalol nakan mo. ");
INSERT INTO bqj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mamu, jibelene firim Aláemit, jitit fo ni mukanay mamu murakel maa sipayolal mo jiligene me bugagu. Ban jikanekan waf uce wammeŋe wanogore ti wo. » ");
INSERT INTO bqj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ᵽúrto, Yésu nabbañ alob ni fítiman fafu naagil : « Juuttenom buru ᵽe min mbi júju jujoh wo nijae me elobul. ");
INSERT INTO bqj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bajut waf ni waa tíyaŋ wanone me ni an wájue ukanol nasigo. Bare til wáᵽullo me ni an, wo nuh’ukanol nasigo.  ");
INSERT INTO bqj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","An abaj me gunnu gal eun, aun. » ");
INSERT INTO bqj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","No Yésu ahat me fítiman fafu min aot bi súndool, ulagorol n’gurorenol búnogor baubu wa bumaŋe egiten. ");
INSERT INTO bqj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Naagil : « Buru may ᵽoᵽ jujogut gurim gaugu ? Jiffasut búoh wáfowaf waa tíyaŋ wanonulo me ni an újuut ukanol nasigo ? ");
INSERT INTO bqj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yoemme waf wauwu let ni biinumol unone bare ni farol, uban n’úᵽur o bakaer m’bise. » Ni gurim gaugu Yésu agitene ñer búoh mitiñay mánoman mújue mitiñi. ");
INSERT INTO bqj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ban natajen aah : « Waf waw wáᵽureul me ñáraru an wo nuh’ukanol nasigo bújoŋor Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Maagen mamu, ni biinum an uᵽinor waw waarat me úᵽullo, wakaneol me min aroŋ n’ehajen úyabo bugan, n’gákuet, n’jamuh bugan, ");
INSERT INTO bqj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","n’gafilen waar bugan, n’emaŋ walewalet, ni búlaᵽut, n’ebut bugan, n’eroŋ buroŋ bajogout fuhow, n’ésilaet, n’gúmeñ bugan, n’etennoro ni búguno. ");
INSERT INTO bqj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Waf wauwu ᵽe waarat mee ñáraru an núh’úᵽurul, ban wo nuh’ukanol nasigo. » ");
INSERT INTO bqj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yésu náᵽur to naamme ajow bi ni mof mamu dó ésuh yay yaa Tir eomme. No naĉih bo me, nanogen ni yaŋ ece, ban namaŋ jambi an affas búoh aĉila umu ró, bare ájuut arobo makoᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ᵽiout, anaare ace o eseytane élamene bájurol naun gulob maa Yésu ; to baenah nájoul ak’alo to n’guolol. ");
INSERT INTO bqj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aare ahumu alet Asúif, ban ni mof mamu maa Siri-Ᵽenisi nabugi. Nalaw Yésu min aham eseytane yay éᵽur ni bájurol. ");
INSERT INTO bqj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bare Yésu naagol : « Umundum uhat uñiaw n’gutiñ gupoñ ; warat eŋar mitiñay uñiaw usen sujoba. » ");
INSERT INTO bqj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aare ahu naagol : « Ataw, nujuh mee, hani sujoba sasu sitiñetiñ baᵽoy uñiaw baloe me n’ettam. » ");
INSERT INTO bqj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ñer Yésu naagol : « Yoo. Nemme aw ume ábal maa, nújue uot : eseytane yay éᵽure ni bájuri. » ");
INSERT INTO bqj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ñer aare ahu naot, aĉih natoh ró añolol afileni ni bura babu, eseytane yay yo báᵽurer ni o. ");
INSERT INTO bqj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ᵽúrto, Yésu náᵽur mof mamu maa Tir ajow alo maa Sidoŋ, aban nágat mof mamu maa Dekapolis ajow mbaa fal fafu fáᵽurut me faa Gálile. ");
INSERT INTO bqj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","O n’ejow yay, n’guŋallol ánaine atopoe ataje n’elob, ban n’gulaol aremben guñenol ni o. ");
INSERT INTO bqj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ñer Yésu naŋarol min atos ráli fítiman fafu ; nárur gusigol ni gunnu áine ahu, aban naŋar gumasol agorol ni fírerum. ");
INSERT INTO bqj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ᵽúrto, náarul gúĉilol mbaa fatiya, naif liŋ ban naah áine ahu : « Efata ! » (Dóemme \"Upégulo !\") ");
INSERT INTO bqj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","To baenah gunnuol n’gútopulo, fírerumol ni fujalo, ban narobo elob ŋanno ca. ");
INSERT INTO bqj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yésu naah gamat me jambi gulob yo me an ; bare min afaŋe me naĉafil mola, mo may gufaŋe me evis elob yay. ");
INSERT INTO bqj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ban bugan bugagu n’gujahali faŋ n’guoh : « Wo nakan me ᵽe, maagen mamu úariari ! Nakane utopoa n’guun ni bugan gájuut elob n’gulob ! » ");
INSERT INTO bqj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ni gunah gaugu, ni bañ baj fítiman fámah fuomunor. Min bugan bugagu gubajut me wáfowaf bi fitiñ, Yésu návogul ulagorol aban naagil : ");
INSERT INTO bqj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","« Enilom erume bugan bugaubugi mata baje ñer gunah gúfaji bugo tale n’ínje, ban gubajut wáfowaf bi fitiñ. ");
INSERT INTO bqj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ibbañenil me guot mbaa súndoil gar gurakel, ᵽan guyogo m’bulago. Gammeŋe ni bugo gúᵽulloᵽur ráli. » ");
INSERT INTO bqj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ulagorol n’guogol : « Tay jújue jibaj waf uce bi esenil gutiñ iki gupoñ bin baube baliko maa ? » ");
INSERT INTO bqj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naagil : « Unaĉ butumbu jibaje ? » N’guogol : « Wono futoh n’úuba. » ");
INSERT INTO bqj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ñer naah bugan bugagu gurobo n’ettam, aban naŋar unaĉ waw waamme futoh n’úuba, nasal Aláemit, mbiban namusul wo asen ulagorol gugabor bugan bugagu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gubajene ᵽoᵽ mice muol matiito. Nasalen Aláemit mala muol maumu, ban naah ulagorol gugabor mo may. ");
INSERT INTO bqj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bugo ᵽe n’gutiñ iki gupoñ guŋañen miᵽirih ᵽilo utegel wono futoh n’úuba ummeŋ ulagoraaw guteb gújaenum. ");
INSERT INTO bqj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Gatiñ me, maageima bugan súuli sibbagir (4 000). No bao me, Yésu nabbañenil guot. ");
INSERT INTO bqj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","To baenah, Yésu nájuᵽo ni busana o n’ulagorol dó, min gukay bi ni mof mamu mo guvoge me Dalumanuta. ");
INSERT INTO bqj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","No guĉih me, Eᵽárisie yay n’guĉigul. N’gufaen gunamo síceŋor ni Yésu. Nemme ebelol gabbut gumaŋe, n’gurorenol bigitenum bo an ájuut akan, bajae egiten búoh aĉila n’émit náᵽullo. ");
INSERT INTO bqj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yésu naif liŋ aban naah : « Wa uĉile bugan bugagu bugaa jama n’guŋes ejuh bigitenum bo an ájuut akan ? Maagen, ínje ilobul yo : Aláemit mat’abbañ akan bugan bugaubugi n’gujuh bigitenum bánoban. » ");
INSERT INTO bqj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ᵽúrto, nahalil to min abbañ ák’ájuᵽo ni busana babu bi épino mbaa ñagagu. ");
INSERT INTO bqj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","N’ejail, ulagora Yésu n’gújumor eŋar unaĉ waᵽiloe ; ganur pat guogenen dó ni busana babu. ");
INSERT INTO bqj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ban Yésu nataril aagil : « Júludo ! Jíkanum lévir yay yal Eᵽárisie yay ni ᵽoᵽ yaa Herod. » ");
INSERT INTO bqj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ñer ulagoraaw n’guᵽinor guoh : « Nalob mee mala min uŋallatal me unaĉ wammeŋe. » ");
INSERT INTO bqj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yésu naffas gaᵽinoril ban naagil : « Wa uĉile n’jiᵽinor mala gabajutul unaĉ ? Bi maer jítalloerut ban ᵽoᵽ jujogerut ? Uinumul mo úliie ? ");
INSERT INTO bqj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jibaje gúĉil, jujugérit ? Jibaje gunnu, juunérit ? Juosenut wabaj me ? ");
INSERT INTO bqj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","No nimusul me unaĉ waw waamme futoh igabor bugan gono súuli futoh, utegel wammeŋe baᵽirih wono butumbu jitebe jíjaenum ? » N’guogol : « Guñen n’úuba. » ");
INSERT INTO bqj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Naagil : « Ban no nimusul me unaĉ waw waamme futoh n’úuba bi ni bugan bugagu gaamme súuli sibbagir, utegel wammeŋe baᵽirih wono butumbu jitebe jíjaenum ? » N’guogol : « Futoh n’úuba. » ");
INSERT INTO bqj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Naagil : « Ñer bi maer jujogerut ? » ");
INSERT INTO bqj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","N’guĉih n’ésuh yay yaa Betusaida. To, n’gúŋarul Yésu ápima, ban n’gulaol agorol. ");
INSERT INTO bqj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yésu nátugol n’gañen ban náĉibbenol ák’áᵽur ésuh yay. Mbiban naŋar gumasol alosol n’gúĉil, narembenol guñenol ban naagol : « Nujuge waf uce ? » ");
INSERT INTO bqj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Apíma ahu náarul gúĉilol aban naah : « Nijuge bugan, bare gúnini ti ununuh waam n’ejow. » ");
INSERT INTO bqj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ñer Yésu nabbañ aremben guñenol ni gúĉil áine ahu. No áine ahu abbañ me aluj gayoŋol, najuh ŋanno ca, o min ahoe. ");
INSERT INTO bqj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ñer Yésu nabbañenol aot bi súndool ban naagol : « Jamb’upil me tánotan, ban jamb’ulob yo me ánoan. » ");
INSERT INTO bqj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ᵽúrto, Yésu ni ulagorol n’gujow mbaa súsuh sasu salof me Sesare yaa Fílip. Bugo ni bulago, naagil : « Bugan bugagu guoge ínje iomme ay ? » ");
INSERT INTO bqj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","N’guogol : « Guce guoge aw uomme Saaŋ Batis, bugagu n’guoh aw uomme aboñer ahu Elí, guceil bugo guoge aw ace om ni uboñer waw bugaa no. » ");
INSERT INTO bqj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naagil : « Yoo. Ñer buru juoge ínje iomme ay ? » Ᵽier naagol : « Aw uomme Kirista ahu. » ");
INSERT INTO bqj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ñer Yésu naĉafil naagil jambi gulob me an mola. ");
INSERT INTO bqj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mbiban Yésu narobo egiten ulagorol aagil : « Añol Arafuhow naate álam mámah ; ufan súsuh sasu, ufan uteŋenaaw bi n’úᵽajula gúboñ Aláemit bugagu ró ᵽan gulalol iki gukanol naĉet. Bare ᵽúrto me gunah gúfaji, ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nagitenil yo ŋanno ca. Ñer Ᵽier navogol guilo jolil, aban nailo avaborol mala gurim gaugu. ");
INSERT INTO bqj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bare Yésu nábaho, naluj ulagorol aban nannur Ᵽier aagol : « Uᵽúr tale úraliom, Seytane ! Baᵽinoreri bujaorut ni bal Aláemit, bare bal arafuhow bom. » ");
INSERT INTO bqj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mbiban Yésu navoh fítiman fafu manur n’ulagorol naagil bugo ᵽe : « An amaŋ me alagenom, jambi abbañ aᵽinor mala fuhool : ateb ekuruaol min alagenom. ");
INSERT INTO bqj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maagen, an amaŋ me eᵽagen buroŋol, ᵽan ábbur bo ; bare an ábbur me buroŋol múmbam ni mala Firim fafu Fásum me, ᵽan abaj buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wa ᵽan nafa an o babajer mof mamu ᵽoomo, mbiban nábbur enogen ni buroŋ babu bábaerit me ? ");
INSERT INTO bqj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wa nájue asen min aallor bo ? ");
INSERT INTO bqj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iní me an nasuom ban nasu gurimom bíᵽimbor bugan bugagu bugaa buroŋ be galat mee éinen n’Aláemit ban n’gúni utila, ñer ínje Añol Arafuhow ᵽoᵽ ᵽan isuol no nijae me ébbañul ni gasal Ᵽayom dó, manur ni emalakaay ganab me. » ");
INSERT INTO bqj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yésu natajen aagil : « Maagen, ínje ilobul yo : guce ni gailo maa tale mati gutoh guĉet bugo m’bajugut Jávi Aláemit jiĉigul ni sembe ró. » ");
INSERT INTO bqj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","No gunah futoh ni fanur gúgat me, Yésu naŋar Ᵽier, Saak ni Saaŋ, min gúᵽur jolil gujow iki gujiŋ bi fatiya firijaŋ fice fabbage. No guĉih ró me, enilol nébahen eŋar ganogor gace bújoŋoril : ");
INSERT INTO bqj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bisimool m’buhat nihi biij, ban m’bútuen bátuener bo aᵽosa wañ ánoan ala babe ni mof mát’áju akan wañ n’útuen mamu. ");
INSERT INTO bqj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ban Elí ni Móis n’gúᵽullil, guban n’gúni n’galolobor ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ñer Ᵽier naŋar firim fafu min aah Yésu : « Afanóli, fubambaŋ min wóli jíni tale ; ban jiilen gúggut gúfaji, fanur bi n’aw, fafu bi ni Móis, fupafo bi ni Elí. » ");
INSERT INTO bqj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Affasut wa naam n’elob mala gáholi gagu ganonil me.) ");
INSERT INTO bqj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ni baj gávuh gúkail gúggubil gúharo, ban firim ni fúᵽurul dó fuoh : « Ume aamme Añolom o níbboli me. Juuttenol ! » ");
INSERT INTO bqj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","To baenah, ulagoraaw n’gunamo ejegor to guomme ᵽooto, bare gubbañut gujuh to an íni let Yésu bare ni bugo. ");
INSERT INTO bqj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","No guomme n’éavul ni firijaŋ fafu, Yésu naĉafil aagil jambi gulob me an wo gujuh me bi no Añol Arafuhow ajae me eilo ni gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","N’gukan ti nalobil me n’erorenor nímoro : « Eilo ni gaĉet me, dóemme ᵽiaŋ wa ? » ");
INSERT INTO bqj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ᵽúrto, n’gurorenol guoh : « Wa uĉile úᵽajula gúboñ Aláemit bugagu nihi guoh Elí naate amundum ábbañul ? » ");
INSERT INTO bqj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Naagil : « Maagen, Elí naate amundum ábbañul bi ebet waf waw ᵽe ni ganab. Ban bu jáorum me ñer ni hiĉi gaa búoh Añol Arafuhow ᵽan álam nár ban ᵽan aĉotiheni ? ");
INSERT INTO bqj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Niegul maa : Elí najoulo aban, ban gukanolkan ti súmil me, ti may Bahiĉer babu bulob me buya ni o. » ");
INSERT INTO bqj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","No gubbanno me bi to ulagoraaw bugagu guomme, n’gujuh fítiman fúgolil fúharo, ban ni baj úᵽajula gúboñ Aláemit gúni ni síceŋor ni bugo. ");
INSERT INTO bqj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","No bugan bugagu gujuh me Yésu, n’gujahali faŋ, n’gúteil bi esafol. ");
INSERT INTO bqj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ñer Yésu narorenil aah : « Mala wa jiceŋore mee ni bugo ? » ");
INSERT INTO bqj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ace áine naagulol dó ni fítiman fafu : « Afanom, áᵽurom niŋallo bi n’aw ; eseytane enonol, eĉilol mát’áju alob. ");
INSERT INTO bqj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tánotan to eiyulol, ᵽan etebol eral n’ettam ; añil ahu ᵽan agofen, natoñor ban nalo gaay ahay was. Nilaene ulagorai tima n’guham yo, bare gújuut. » ");
INSERT INTO bqj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ñer Yésu naagil : « Buru jabbah je jaa bugan gabajut gáinen, bi nay ᵽan íni to ni buru nih’imutenul ? Jiŋallom ᵽaa añil ahu ! » ");
INSERT INTO bqj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","N’guŋallol o. No añil ahu ajuh me Yésu, eseytane yay neilo ekanol navenjeŋor ; nalo n’ettam, aban náh’ábakor n’egofen nímoro. ");
INSERT INTO bqj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ñer Yésu naroren ᵽay añil ahu naagol : « Kábiriŋ nay nihi kanol mee ? » Naagol : « Kábiriŋ fiñileol. ");
INSERT INTO bqj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ban ñammeŋe eseytane yay ebelol ni sambun ni ᵽoᵽ ni mal bi emugol. Iní me nújue ukan to waf uce, enili erumóli min urambenóli. » ");
INSERT INTO bqj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yésu naagol : « Nuoge íni me níjue ! Wáfowaf újue ukano bi ni an áinene n’Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To baenah, ᵽay añil ahu naah fatiya : « Afanom, níinene ! Ujóul urambenom mata gáinenom gutogut ! » ");
INSERT INTO bqj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","No Yésu ajuh me fítiman fafu fúbaul mbaa bugo, nailo annur eseytane yay ni sembe aah : « Aw eseytane yay yakane me bugan mati gúju elob ban n’gutopo, ínje ilobi yo : úᵽur n’añil ahumu, ban jamb’ubbañ unogen ni o ! » ");
INSERT INTO bqj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ñer eseytane yay nekan añil ahu natelen ni sembe, mbiban néᵽur ni o n’eya úᵽib ró. Ñer náni me ti efuluŋ, bireg gammeŋe ni gamat me n’guoh naĉeĉet. ");
INSERT INTO bqj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bare Yésu najogol n’gañen ailen, ban nailo ahah. ");
INSERT INTO bqj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","No Yésu anogen me ni yaŋ yay ák’áni ró ni ulagorol bugo bareil, n’gurorenol guoh : « Wa uĉile wóli jújuut jiham eseytane yauyu ? » ");
INSERT INTO bqj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Naagil : « Siseytane sasu sáni me ti yo galaw bare gújue guham so. » ");
INSERT INTO bqj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","No ᵽúrto me, Yésu ni ulagorol n’guilo gujow gusat mof mamu maa Gálile, ban amaŋut an affas yo ; ");
INSERT INTO bqj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dáuru min mb’abajo bi eligenil. Nah’aagil : « Añol Arafuhow ᵽan abeni ni guñen gaa bugan ; ᵽan gukanol naĉet, bare gunah gúfaji búsol eĉelol, ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bare ulagoraaw gujogut gurim gaugu, ban gukañenut gurorenol. ");
INSERT INTO bqj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yésu ni uᵽotoraol n’gujow iki guĉih n’ésuh yay yo guvoge me Kaᵽerinaum. No gunogen me ni yaŋ yay, narorenil naagil : « Mala wa jiceŋorene mee m’bulago ? » ");
INSERT INTO bqj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","N’guᵽanor cem, mata no gújaeul me m’bulago, síceŋor guomene bi effas ay ni bugo afaŋ me bugagu. ");
INSERT INTO bqj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ñer Yésu nanamo, aban navoh uᵽotoraaw gaamme guñen ni gúuba (12) naagil : « Iní me an namaŋe áni átiar, áni ásola ala bugan bugagu ᵽe, ban ᵽoᵽ áni arokail. » ");
INSERT INTO bqj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aban naŋar añil ace ailen n’etulil, mbiban natebol naagil : ");
INSERT INTO bqj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","« Anóan ayabe ni gajow gúmbam ace ni uñiaw ubuge, ínje faŋaom nayabe. Ban an ayabom me, let ínje bare nayabe, bare ᵽoᵽ An ahu aboñulom me nayabe. » ");
INSERT INTO bqj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ñer Saaŋ naah Yésu : « Afanóli, jujuge ace áine nah’aham siseytane ni gajow gúiya. Bare jífirenolfiren ekan burok ti baubu mata alet ni gayoŋolal. » ");
INSERT INTO bqj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Naagil : « Jambi jífirenol, mata bajut an o mb’akan ni gajow gúmbam waf waunderuti, mbiban nafaen alob maarat aya n’ínje. ");
INSERT INTO bqj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maagen mamu, an alalutolal me, búsololal nabbañe. ");
INSERT INTO bqj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maagen, ínje ilobul yo : ánoan ájiul me gago gaa mal jirem mala min juomme bugan bugaa Kirista, an ahumu mát’ábbur bacamol. » ");
INSERT INTO bqj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yésu nabbañ aah : « An aĉil me jice ni miñil me gáinen me n’ínje min julo ni gatil, an ahumu hóimol guhogol fuval fámah n’ehondor gural ni fal. ");
INSERT INTO bqj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Iní me gañeni ban guĉili min ulo ni gatil, uᵽirih go ; hóimi unogen ni buroŋ babu bábaerit me ni gañen ganur so n’ebaj guñeni gúrir mbiban nubeni ni sambun sasu sajeh mee so ndi sufogo me.  ");
INSERT INTO bqj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Iní me gaali ban guĉili min ulo ni gatil, uᵽirih go ; hóimi unogen ni buroŋ babu bábaerit me mahaje so n’ebaj guoli gúrir mbiban nubeni ni sambun sasu sajeh me.  ");
INSERT INTO bqj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mb’íni me jíĉili ban jiĉili min ulo ni gatil, úᵽuren jo ubelen ; hóimi unogen ni Jávi Aláemit ni jíĉil janur so n’ebaj go ᵽoogo mbiban nubeni ni sambun sasu sajeh mee ");
INSERT INTO bqj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","dó suo mati siĉet me, ban ᵽoᵽ dó sambun sasu mati súmus me sufogo. ");
INSERT INTO bqj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maagen mamu, arafuhow ánoan ᵽan asisi ni sambun. ");
INSERT INTO bqj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Misis waf wom waaro, bare múbbur me gafira mo, wa ᵽan jiŋar me min jíbbañenul go ? Jibaj uinum wasisisis, ban gásumay gúni n’etulul. » ");
INSERT INTO bqj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yésu náᵽur to ajow mbaa mof mamu maa Yúde maamme ñagagu fal fafu faa Suruden. Ni baj fítiman mul fúkail fuomunor to naamme, ban nabbañ mul anamo eligenil, ti naᵽi me nah’akan. ");
INSERT INTO bqj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ñer Eᵽárisie guce n’gulofulol, mata ebelol gabbut gumaŋe ; n’gurorenol ter sesen min ánaine aham aarol. ");
INSERT INTO bqj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Naagil : « Móis gay gáboñ nahalul mala yo ? » ");
INSERT INTO bqj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","N’guogol : « Móis nájiji ánaine min amundum ahiĉ gahait gal evis búyabo, mbiban náju ñer aham aarol. » ");
INSERT INTO bqj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yésu naagil : « Eakul uinum eĉile min Móis ahiĉ gáboñ gaugu bi ni buru. ");
INSERT INTO bqj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bare ni buju babu, no Aláemit átul me waf waw ᵽe, náuweuwen arafuhow áni ánaine ni anaare. ");
INSERT INTO bqj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yo eĉil me ánaine ᵽan áᵽur ahat ᵽayol ni jaol min ak’aĉin bugo n’aarol, ");
INSERT INTO bqj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ban ñer bugo gúuba n’gúbbañul gúni enil yanur. Mamu, mati gubbañ gúni bugan gúuba, bare an anur. ");
INSERT INTO bqj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kan arafuhow jambi ñer áfaculor wo Aláemit ajogor me. » ");
INSERT INTO bqj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","No gunogen me ni yaŋ yay, ulagoraaw n’gubbañ gurorenol dó n’elob yauyu. ");
INSERT INTO bqj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naagil : « Anóan ahame aarol mbiban nayab ace, an ahumu natile gatil gaa búyabo n’átiar ahu. ");
INSERT INTO bqj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iní me may anaare nahane áinol mbiban náyabo n’ace, natile gatil gaa búyabo. » ");
INSERT INTO bqj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ni baj bugan gúŋarul uñil tima Yésu nagoril min ásonienil, bare ulagoraaw n’gunamo ennur bugan bugaubugu. ");
INSERT INTO bqj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","No Yésu ajuh me bakaneril, fiiñol ni fitiñ naagil : « Jihat uñiaw n’gújoul mbal ínje ! Jambi jífirenil yo, mata Jávi Aláemit bugan bugagu gáni me ti bugo guĉil jo. ");
INSERT INTO bqj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Maagen, ínje ilobul yo : an ayabut me Jávi Aláemit ti añil ayab jo me, an ahumu mát’ámus anogen dó. » ");
INSERT INTO bqj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mbiban naleb uñiaw, aban narembenil guñenol min ásonienil. ");
INSERT INTO bqj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ᵽúrto, Yésu náni n’ejow bulagool. Ni baj ace áine áteil aĉigul nahat nalo aya gújul bújoŋorol naagol : « Aligena-bugan ahu ásum me, wa níarie ikan min iyab buroŋ bábaerit ? » ");
INSERT INTO bqj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yésu naagol : « Nuvogom bu ? Asúm me ? Nuffase dóemme wa ? Bajut an ásume íni let Aláemit o bareol. ");
INSERT INTO bqj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yoo. Leti nuffase gúboñ gagu gaah me : “Jamb’umuh an ; jamb’ufilen anaare o jíyavut ; jamb’úkuet ; jamb’ubij ; jamb’uraf ánoan ; úkanum ᵽai ni jai” ? » ");
INSERT INTO bqj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aíne ahu naagol : « Afanom, dáuru ᵽe níkanumdokanum kábiriŋ ínje añil. » ");
INSERT INTO bqj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yésu nalujol ni súmol ; aban naagol : « Ŋañoi ekan waf wanur : ujow uk’unnomen wo nubaj me ᵽe, uban nuŋar síralam sasu usen galeh me ; mamu ᵽan ubaj fubaj n’émit. Ukan mo, mbiban nújoul ulagenom. » ");
INSERT INTO bqj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bare áine ahu no naun me gurim gaugu, násimbor ban najow akay n’égogor dó mata fubaj fámah nabaje. ");
INSERT INTO bqj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ñer Yésu nailo aluj abosor to naamme, aban naah ulagorol : « Min táñi me asanum enogen ni Jávi Aláemit ! » ");
INSERT INTO bqj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gurim gaugu n’gúñagen ulagoraaw nár. Nabbañ aagil : « Gúñum, min táñi me enogen ni Jávi Aláemit ! ");
INSERT INTO bqj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Faŋe ésum eñokombo élu ni gasun éguje éᵽur babu asanum enogen ni Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ñer ulagoraaw n’gufaŋ n’gujahalie ban nihi guogoro : « Ay ᵽiaŋ ñer ájue ayab gaᵽah ? » ");
INSERT INTO bqj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yésu nalujil aban naagil : « Ni bugan bugagu dáuru júut kano, bare n’Aláemit waf waw ᵽe újue ukano. » ");
INSERT INTO bqj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ñer Ᵽier nábahen aagol : « Uluj, wóli hum ubuge min jihatulo wafóli ᵽe min jilageni. » ");
INSERT INTO bqj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yésu naagol : « Maagen, ínje ilobul yo : Iní me an nahale yaŋol, gutiol, gúlinol, jaol, ᵽayol, guñolol, ettamol múmbam ni mala Firim fafu Fásum me, ");
INSERT INTO bqj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ᵽan ayab faŋ ñono ekeme ni buroŋ be, saŋ, gutiay, gúlinay, sijaay, uñil, ettam, hani ᵽan ní ni gálatien dó ; ᵽan ayab ᵽoᵽ, ni tinah tice tájaeul, buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jiffas búoh gammeŋe ni bugan bugagu gaamme útiar ᵽan gúbbañul gúni úsola, ban may gammeŋe ni gaamme úsola ᵽan gúbbañul gúni útiar. » ");
INSERT INTO bqj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ᵽúrto, Yésu ni galageneol me n’gulo m’bulago bi ejow mbaa Yérusalem ; Yésu atuje gayoŋ gagu. Ulagoraaw ni mujogil faŋ, ban bugagu galagene me búsolol gáholi n’gúni ni bugo. Ñer Yésu nabbañ aomen uᵽotoraaw gaamme guñen ni gúuba (12) to naamme, aban nanamo elobil wajae me ebajol. ");
INSERT INTO bqj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naagil : « Juluj : wolal ubugi n’ejow mbaa Yérusalem, ban Añol Arafuhow ᵽan abeni ni guñen ufan uteŋenaaw ni úᵽajula gúboñ Aláemit. Ᵽan gutaliŋol bataliŋ bal eĉet, mbiban n’gusenol bugan bugagu galet me Esúif, ");
INSERT INTO bqj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ᵽan gúfohulol, n’gumasenol, n’gutegol gusoh gal ubaŋ, ban ᵽan gumugol ; bare gunah gúfaji búsol eĉelol, ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ñer úᵽur Sebede, gaamme Saak ni Saaŋ, n’gulof Yésu n’guogol : « Afanóli, jimaŋe mb’ukanóli wo jijae maa écini. » ");
INSERT INTO bqj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naagil : « Wa jimaŋe ikanul ? » ");
INSERT INTO bqj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","N’guogol : « No nujae me erobo n’efenjeŋ yay yaa Jávii, újioli min jurobo ahu n’gañeni gárib, ahuo n’gamai. » ");
INSERT INTO bqj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naagil : « Buru jiffasut wa juom n’écin. Jújue ᵽiaŋ jirem éremuma yay yaa sílam yo ínje ijae me erem, ter jíbatisei gábatise gagu gaa sílam go gujaeom me ébatise ? » ");
INSERT INTO bqj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","N’guogol : « Ey, jújue ! » Naagil : « Maagen mamu, ᵽan jirem éremuma yay yo nijae me erem, ban ᵽoᵽ ᵽan jíbatisei gábatise gagu go nijae me ébatisei ; ");
INSERT INTO bqj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","bare mala erobo ni gáribom ter ni gamayom, yo let ínje iĉil yo esen : gurobo gaugu gurobo gom gaa bugan bugagu gaĉobi me guban bi ni go. » ");
INSERT INTO bqj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","No uᵽotoraaw bugagu gaamme guñen guun me gurim gaugu, súmutil ni Saak ni Saaŋ. ");
INSERT INTO bqj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ñer Yésu navogulil bugo ᵽe, aban naagil : « Jiffase ᵽe búoh bugan bugagu bugo nujogale me ti ufan súsuh, bugo gúcetene so me ; maagen, bugan bugagu búgamah gúvafenevafen n’eogen so. ");
INSERT INTO bqj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bare ni buru búlie : an ni buru amaŋ me gujogol an ámah, amundum áni aroka olul ; ");
INSERT INTO bqj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ban ᵽoᵽ an ni buru amaŋ me éni átiar, áni arokaul buru ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mamu may, Añol Arafuhow najoulo mee, let min mb’abaj umigel, bare til min mbi aĉila faŋaol áni amigel ban nasen buroŋol bi eallor buroŋ bugan gammeŋe. » ");
INSERT INTO bqj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ᵽúrto, Yésu ni ulagorol n’guĉih n’ésuh yay yo guvoge me Sériko. No naamme n’éᵽur ésuh yauyu manur n’ulagorol ni ᵽoᵽ fítiman fámah, ni baj ace áine ápime, gajaol Barutime, áᵽur Time, anamo ni galam bulago babu náni n’gúcin. ");
INSERT INTO bqj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","No naun me búoh Yésu ala Nasaret aam n’égat, nanamo éᵽib aah : « Yésu, Añol David, enili erumom ! » ");
INSERT INTO bqj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gammeŋe n’gunamo ennurol tima naᵽanor, bare aĉila nafaŋ náᵽibe aah : « Añol David, enili erumom ! » ");
INSERT INTO bqj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yésu nailen aban naah : « Juvogulol ! » Ñer n’gúvogul ápima ahu n’eogol nímoro : « Uaken, uilo, aw navoge mee. » ");
INSERT INTO bqj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ñer ápima ahu nabelen gaᵽalitoŋol, nailo ñanur puĉ aban najow mbaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","No naĉih to me, Yésu naagol : « Wa numaŋe ikani ? » Naagol : « Afanom, ukanom min ibbañ ijuh. » ");
INSERT INTO bqj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ñer Yésu naagol : « Ujow, gáineni guᵽageni. » To baenah áine ahu nabbañ ajuh, ban nanamo elagen Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","No Yésu ni ulagorol gulof me Yérusalem, bugo n’égat súsuh sasu saa Betufage ni Betani, saamme n’gacaĉ firijaŋ fafu fo guvoge me fal uoliv waw, naboñ gúuba n’ulagorol guyabol gayoŋ naagil : ");
INSERT INTO bqj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","« Jujow bi n’ésuh yauyu yaamme gayoŋul. No jijae ró me enogen, ᵽan jujuh jusum jahogihoh jo ᵽan an aremborerut ; jíjalul jo jiŋallom. ");
INSERT INTO bqj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Iní me an narorenul aagul : “Wa uĉile n’jikan mee ?” Juogol : “Ataw asohola jo, ban mati ᵽio nabbañenulul jo.” » ");
INSERT INTO bqj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ñer ulagoraaw gaamme gúuba n’gukay, guĉih n’gutoh jusum juhogi tíyaŋ ni bulago babu, lof ganegen yaŋ ece, n’gujal jo. ");
INSERT INTO bqj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Guce ni gaamen to me n’guogil : « Wa jikane mee ? Wa uĉile n’jijal jusum jaju ? » ");
INSERT INTO bqj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","N’gúbalil ti Yésu alobil me, ban n’guhalil n’gújaenum jo. ");
INSERT INTO bqj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","N’gúŋarul jo bi ni Yésu, guĉigul n’guŋar újuoil gutal ni jo min arembor dó. ");
INSERT INTO bqj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bugan gammeŋe n’gutal újuoil m’bulago babu, bugaguil n’gutal ubes ujeb wo guᵽikulo babu n’ulah waw. ");
INSERT INTO bqj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gayab me gayoŋ ni ᵽoᵽ galagene me búsol nihi guya uŋan guoh : « Hosanna ! Aláemit ásonien an ahu ájaeul me ni gajaol ! ");
INSERT INTO bqj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Asónien Jávi jaju jaamme n’éjoul, Jávi jaju jaa ᵽayolal David ! Hosanna bi ró fatiya ! » ");
INSERT INTO bqj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ᵽúrto, Yésu nanogen Yérusalem, ban najow bi ni gávi-Aláemit gagu. No naluj me joon wabaj me ᵽe aban, nemme tinah bakaer, naŋar uᵽotoraaw gaamme guñen ni gúuba min gúᵽur dó gujow bi Betani. ");
INSERT INTO bqj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tihalen fo, no gúᵽureul bo me, bieb m’bujoh Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","No naŋanden me bífig bice n’utoj bo ró, najow ake eluj ter ᵽan atoh ró waf, bare no nalof bo me, natoh ró utoj barebare, mata let tinah bo taa gabuh gúfig. ");
INSERT INTO bqj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ñer naah bo : « Jambi ñer an abbander atiñ mitiñi ! » Ban ulagorol n’guun min alob mee. ");
INSERT INTO bqj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","No guĉih me Yérusalem, Yésu nabbañ anogen ni gávi-Aláemit gagu. Nanamo eham unnomenaaw ni unnomaaw ᵽe gaamen dó me, narikul muĉag utita-síralam bugagu ni sujukut sasu sal unnomena sitalab bugagu. ");
INSERT INTO bqj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ahalut ánoan aogene waf najator dó ni gávi-Aláemit gagu. ");
INSERT INTO bqj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aban naagil bi etañil biinum : « Aláemit alobut ni Bahiĉer babu ᵽiaŋ búoh : “Yaŋom ᵽan guvoh yo yaŋ yaa galaw bi ni súsuh sasu ᵽe” ? Bare buru jíbahen yo éni fíemorum fal úku. » ");
INSERT INTO bqj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","No ufan uteŋenaaw ni úᵽajula gúboñ Aláemit bugagu guun me gurim gaugu, n’gúni n’eliᵽ bu gujae me ekan n’gunemenol ; gúhollolholi mata fítiman fafu ᵽe fírimbagorimbago ni bavareerol. ");
INSERT INTO bqj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","No nuĉigal me tiname, Yésu ni ulagorol n’gúᵽur ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","M’bujom, no guomme n’égat to bífig babu buomme, ulagoraaw n’gujuh bo min buhae bi to ni guar bo. ");
INSERT INTO bqj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ñer Ᵽier nemme naosene wabajen me, naah Yésu : « Afanom, uluj ᵽaa, bífig babu bo nutab me buhae. » ");
INSERT INTO bqj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yésu naŋar firim fafu naagil : « Jíinen n’Aláemit ! ");
INSERT INTO bqj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Maagen, ínje ilobul yo : an aah me firijaŋ faufu : “Utennor to nuomme uk’ulo ni fal,” ban náinen búoh wo nalob me ᵽan ukano o m’batehumorut ni biinumol, maagen ᵽan ukano. ");
INSERT INTO bqj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yo eĉil me niegul : Wáfowaf wo jijae me écin ni galaw ró, jíinen búoh jibaj wo jiban, ban maagen mamu ᵽan jibaj wo. ");
INSERT INTO bqj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ban jíni me n’galaw, íni me jibajorbajor ni an, juboketol, mamu may Ᵽayul aamme fatiya ᵽan aboketul utilul.  ");
INSERT INTO bqj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bare juboketut me gatil me ni buru, Ᵽayul aamme fatiya mati ᵽoᵽ aboketul utilul. » ");
INSERT INTO bqj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ᵽúrto, Yésu ni ulagorol n’gúbbañul bi Yérusalem. No guĉilo ró me, Yésu nanamo bújator dó ni gávi-Aláemit gagu. Ñer ufan uteŋenaaw, úᵽajula gúboñ Aláemit bugagu ni ufan waw bugal ésuh yay n’gújoul mbal aĉila ");
INSERT INTO bqj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","n’guogol : « Ni sembe say nukane mee waf wauwu ? Ay aseni so ? » ");
INSERT INTO bqj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Naagil : « Injé may ban irorenul eroren yanur pat ; jíbalom yo me, ᵽan may ilobul ni sembe say nikane mee waf wauwu. ");
INSERT INTO bqj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoo, sembe sasu saa gábatise so Saaŋ Batis abaj me, bay súᵽullo : n’Aláemit ter ni an ? Aᵽaa jíbalom ! » ");
INSERT INTO bqj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","N’gúbahulor gúbahulor n’guoh : « Uogal me n’Aláemit, ᵽan aagolal : “Wa uĉile ñer jíinenut ni o ?” ");
INSERT INTO bqj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ban uogal me ni an sujoumulo, haa... ! » Gúholiholi ésuh yay, mata bugan bugagu ᵽe gujojoh Saaŋ Batis ti aboñer ala maagen. ");
INSERT INTO bqj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ñer n’guoh Yésu : « Wóli jiffasut. » Naagil : « Kan ínje may mat’ilobul ni sembe say nikane mee waf wauwu. » ");
INSERT INTO bqj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ᵽúrto, Yésu nanamo elob ni bugan bugagu n’únogor naagil : « Baje ace áine aroge úbiñu. Nasoen wo aban nacokor tiñ tal epucen bíñu yay, mbiban nateᵽ etah yabbage yaa gapoy. No naban me, nábahen úbiñu waw asen ucokora-bíñu guogen mbi nihi gúᵽunnol fugabol, min aĉila ake bújaor. ");
INSERT INTO bqj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","No tinah tiĉih me tal ealen mitiñ mamu, naboñ arokaol ace bi ni gaogen me úbiñu waw bi éyabul fugabol. ");
INSERT INTO bqj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bare ucokora-bíñu bugagu n’gujogol n’gutegol mbiban n’guhamol aot guñen gurakel. ");
INSERT INTO bqj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nabbañ aboñ arokaol ace bi ni bugo : n’gutegol iki gúbuken ni fuhow, mbiban n’guilo guvaŋol ujel. ");
INSERT INTO bqj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nabbañ aboñ áfatten : n’gumugol. Ᵽúrto, natajen aboñ bo guce mul gammeŋe : n’gutegil mbiban n’gumugil. ");
INSERT INTO bqj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Niki ŋañool áᵽurol áamumma ; naboñol eboñ ésola mbaa bugo ni gaᵽinor gagu ró gaa búoh nemme añolol om, ᵽan gúkanumol. ");
INSERT INTO bqj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bare ucokora-bíñu bugagu no gujuh me áᵽur ahu o n’éjoul, n’guogoro : “Umu aĉil me gafumol. Ujaal umugalol, mamu gafumol ᵽan gúbbañul gúni gololal.” ");
INSERT INTO bqj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ñer n’gujogol gumuh mbiban n’gúᵽunnol dó gubelen tíyaŋ. » ");
INSERT INTO bqj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yésu natajen aagil : « Ñer bu ala úbiñu waw añum ekan ? Ᵽan ájoul mb’aĉigul namuh ucokora-bíñu bugagu ubugi ᵽe, aban nábahen wo asen guce. ");
INSERT INTO bqj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jijangaut Bahiĉer baube baah me : “Ebírih yay yo uteᵽaaw gujunden me, yo ebbanno me éni yáamumma, yaĉil me yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dó ᵽe búkanum bal Ataw, ban ni wolal kakan waf wámah.” » ");
INSERT INTO bqj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ñer n’gumaŋen ejoh Yésu mata guffase búoh búnogor baubu bo nalob mee, molil nálobum bo. Bare nemme gúholiholi fítiman fafu, n’guhalol to min gujow gukay. ");
INSERT INTO bqj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ᵽúrto, n’guboñ Eᵽárisie guce ni bugaa gayoŋ gagu gaa Herod bi ni Yésu bi eralol gabbut, tima n’gúju gujogol ni baloberol. ");
INSERT INTO bqj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","N’gújoul íkiil guogol : « Afanóli, jiffase búoh aw an ala maagen, ban úhollut ánoan ; ulujérit ni uul bugan bugagu, bare til nuvareeilvare bulago babu bal Aláemit ni maagen dó. Ulobóli ᵽaa ter sesen min búalen bucami ávi ahu ámah ahu Sesar ? Juote jicam, ter juotut jicam ? » ");
INSERT INTO bqj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yésu aᵽi me naffas gaᵽinoril gaarat mee, naagil : « Wa uĉile n’jimaŋ eralom gabbut ? Jiŋallom ᵽaa ece ni síralamolal min iluj yo. » ");
INSERT INTO bqj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","N’guŋallol ece ni so. Naagil : « Buul baube ni gajow gauge sal ay ? » N’guogol : « Saa Sesar. » ");
INSERT INTO bqj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Naagil : « Kan jisen Sesar wafol, ban may jisen Aláemit waamme wola. » Ñer bugo ᵽe n’gujahali mola. ");
INSERT INTO bqj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ni baj Esáduke guce gujow iki gutoh Yésu. (Esáduke yay bugo nihi guoh me an aĉet me aban mat’ailoul n’eĉet yay.) N’guogol : ");
INSERT INTO bqj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","« Afanóli, gúboñ gagu gaa Móis guoge an ayab me anaare mbiban naĉet ajundenol o m’babajut añil, atiol ᵽan atunol min áju ahalol gátuh. ");
INSERT INTO bqj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yoo. Bajene batiay baa wáine gono futoh ni gúuba. Atíar nayab aban naĉet m’bahalut añil. ");
INSERT INTO bqj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aútten ahu natun aare ahumu, aban naĉet ᵽoᵽ m’bahalutol gátuh. Afátten ahu may mo, ");
INSERT INTO bqj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","iki bugo gaamme futoh ni gúuba gubao ᵽee an ni bugo m’batogut ahat gátuh. Ᵽúrto, aare ahu may naĉet. ");
INSERT INTO bqj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ban ñer juroreni : no gaĉet me gujae me eilo, ᵽan ñer áni aar ay ni bugo, nemme bugo ᵽe gutoge guyabol ? » ");
INSERT INTO bqj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yésu naagil : « Dáure diĉil me min jibaj galim : jujogut wo Bahiĉer babu bulobe, jujogut ᵽoᵽ bu sembe sasu sal Aláemit siree. ");
INSERT INTO bqj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maagen mamu, no gaĉet me gujae me eilo, ánaine mat’ayab, anaare mát’áyabo ; ᵽan til gúni ti emalakaay dó n’émit. ");
INSERT INTO bqj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mala eilo yay ni gaĉet me yo juunene mee, jijangaut ᵽiaŋ n’élebur yay yaa Móis wo Aláemit alobol me galam jufokon jaju jaa sijeŋ jaamme n’esa ? Naagol ró : “Injé iomme Aláemit ahu o Aburaham, Isak ni Sakob gúinen me ni o.” ");
INSERT INTO bqj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yo eĉil me jiffas búoh Aláemit alet ala gaĉet me, bare til ala garoŋ me. Galimbul gújaloe. » ");
INSERT INTO bqj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ace n’úᵽajula gúboñ Aláemit bugagu, aunil me min guceŋore mee, ban najuh búoh Yésu nábabal Esáduke yay wári faf, náloful aban naagol : « Gay guomme gáboñ gagu gátiar n’úboñ waw ᵽe ? » ");
INSERT INTO bqj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yésu naagol : « Gátiar gagu go guomme uge : “Uutten, Israel, Atúla aamme Aláemilolal o bare aam Ataw. ");
INSERT INTO bqj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Umaŋ Ataw aamme Aláemili n’éĉigiri ᵽe, m’biinumi ᵽe, n’gaᵽinori ᵽe ni sembei ᵽe.” ");
INSERT INTO bqj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gáutten gagu uge : “Ubbóli apali ti núbboli me fuhoi.” Bajut gáboñ gace gafaŋe wauwe. » ");
INSERT INTO bqj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ñer áine ahu naah Yésu : « Yoo, Afanom, nuoge ni maagen dó Aláemit anur om ban bajut ace ábuli ni o, ");
INSERT INTO bqj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ban emaŋol n’éĉigiri ᵽe, ni mujagi ᵽoomo ni sembei ᵽooso, ni ᵽoᵽ ébboli apali ti aw faŋai, dáuru fafaŋ ekan Aláemit úteŋen waw ni úsimen waw ᵽee. » ");
INSERT INTO bqj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","No Yésu ajuh me búoh áine ahu nábabal ni malillo ró, naagol : « Uráliut enogen ni Jávi Aláemit. » Ban ñer an abbañut akañen arorenol. ");
INSERT INTO bqj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ᵽúrto, Yésu nanamo gavare bugan bugagu ni gávi-Aláemit gagu naagil : « Bu úᵽajula gúboñ Aláemit bugagu gújue guoh Kirista Añol David nam ? ");
INSERT INTO bqj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ni búkanum baa Biinum Banabe, David faŋaol naage : “Ataw Aláemit naage Ataom : Unamo ni gañenom gárib bi no nijae me érur ulatori fattam uhagi.” ");
INSERT INTO bqj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David faŋaol navogol Ataw ; bu ñer aĉila Ataw ájue áni añolol ? » Fítiman fámah fuomen n’eutten Yésu n’ésumay ró. ");
INSERT INTO bqj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nah’aagil ni galigen gagu go naamil me ni go : « Júludo úᵽajula gúboñ Aláemit bugagu ! Wo gumaŋ me ᵽe, ebelo újuo ujaha waave bi to n’guolil n’gujator min ésuh yay gujugil, eyab basaf ni jammeŋ ni gákanum ró, ");
INSERT INTO bqj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","erobo ni sujukut sasu saa gayoŋ ni saŋ sasu saa galaw, erobo ni sujukut sasu sáamumma gaggan babajer ; ");
INSERT INTO bqj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","nihi gujoh utiña-sibara bugagu waarema min guram wafil ᵽe, mbiban n’guilo bújoŋor bugan bugagu n’gulaw meŋ. Gúteh gagu go Aláemit ajae me etegil, go ᵽan gufaŋ me ᵽe gátañi gaa bugagu. » ");
INSERT INTO bqj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mbiban, Yésu nanamo ró ni gávi-Aláemit gagu áᵽimbor dó bugan bugagu guhalene me síralam, min ajuh bu guhalene so ró me eno. Usanum gammeŋe n’guhalen dó jálo. ");
INSERT INTO bqj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Najuh ᵽoᵽ atiña-ebara ace aleleh aŋar múralam múuba maᵽilout wáfowaf ahalen dó. ");
INSERT INTO bqj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ñer Yésu navoh ulagorol naagil : « Maagen, ínje ilobul yo : atiña-ebara ahumu aleh mee o afaŋe nasene bugan bugagu ᵽe gasen me ; ");
INSERT INTO bqj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","bugagu ᵽe wávaf me ni gubajil, wo guhalen dó, bare aĉila, waamen me ᵽe ni guñenol wo nahalen dó, wo nabajen me bi buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","No Yésu áᵽullo me ni gávi-Aláemit gagu, ace n’ulagorol naagol : « Afanom, uluj ᵽaa sival sijaha ! Bateᵽer baaro ! » ");
INSERT INTO bqj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yésu naagol : « Nujuge bateᵽer baubu bare mee ? Injé ilobul yo, funah fice mati ŋaño to eval yanur yájutenore n’epayo, bare so ᵽe ᵽan sirikuli sibet. » ");
INSERT INTO bqj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mbiban nak’anamo ni firijaŋ fafu fal uoliv waw bíᵽimbor gávi-Aláemit gagu. Ᵽier, Saak, Saaŋ ni Andere n’gukay gutogol bo, mbiban n’gurorenol guogol : ");
INSERT INTO bqj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","« Aᵽaa ulobóli, nay dáuru dijae ebaj, ban wa ujae egitenóli búoh waf wauwu ᵽe ban ukano ? » ");
INSERT INTO bqj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ñer Yésu naagil : « Jíkanum jambi an abutul. ");
INSERT INTO bqj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gammeŋe ᵽan gúoᵽoroul gajaom guĉigul n’guogul : “Injé iomme Aᵽagena ahu.” Ban ᵽan gubut bugan gammeŋe. ");
INSERT INTO bqj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","No jijae me eun baeler gutih ni balober buunen go, jambi jitelenor, mata dó díarie diĉigul. Bare mati ní ᵽan gabao mof mamu. ");
INSERT INTO bqj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Esúh ᵽan eiyul bi n’epayo ésuh, jávi ᵽan jiiyul bi ni jipajo jávi, ban ᵽan baj bin bo ettam yay ejae egoror, ᵽan ᵽoᵽ bieb búloul. Dáuru ᵽe ᵽan níme ᵽan buju babu baa sílam sasu ; sílam sausu ᵽan síni ti sal anaare aam ni gapegor. ");
INSERT INTO bqj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Buru faŋaul, jíkanum ! Ᵽan gubelul ni bataliŋ, ban ᵽan gutegul gusoh gal ubaŋ ni saŋ sasu saa galaw. Gajaom ᵽan guĉil min gújaenumul bújoŋor ufan súsuh ni úviaw, dó ᵽe min mbi bugo ᵽe guun bagitenerul. ");
INSERT INTO bqj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Firim fafu fásum me fuote fumundum fuvarei ni súsuh sasu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No gujae me ejogul gújaenum bi etaliŋul, jambi jifaen jilelegor mala wo jijae me elob ; mbi julob wajae me éjoul to baenah n’uinumul, mata mati ní ñer buru julobe, bare Biinum Banabe. ");
INSERT INTO bqj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","An ᵽan abet atiol n’eĉet, ᵽaaya ᵽoᵽ ᵽan abet añolol n’eĉet. Uñiaw ᵽan guiyul bi n’ubugail min gukanil n’guĉet. ");
INSERT INTO bqj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gajaom ᵽan guĉil min bugan bugagu ᵽe gulalul ; bare an ajae me emuten iki bao, Aláemit ᵽan aᵽagenol. ");
INSERT INTO bqj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jiffase wo Bahiĉer babu bulobe mala \"Maarat mamu mal ekan galego\" ; ajanga wo me mb’ákanum faŋ wa Bahiĉer baube bumaŋe elob ! No maarat maumu mujae me enogen to muotut me munogen, no ñer gajae me éni ni mof mamu maa Yúde mbi gutey me bi ni gurijaŋ gagu. ");
INSERT INTO bqj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","An ahu ajae me éni fatiya firihinjaŋ jamb’áavul me aban naah ban amundum ake eŋar waf uce ñáraru yaŋol ; ");
INSERT INTO bqj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ban ᵽoᵽ an ajae me éni n’ulah waw, jamb’aot me ake eŋar bisimool. ");
INSERT INTO bqj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mataño míni ni waareaw gajae me éni ni gar ni ᵽoᵽ ni bugagu gajae me éni n’garafen ni gunah gaugu ! ");
INSERT INTO bqj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jilaw jambi dáuru dibaj ñutot ñañu baĉigerul. ");
INSERT INTO bqj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gunah gaugu ᵽan gúni gunah gaa sílam sáamah, so músut baj sice ti so kábiriŋ m’buju babu no Aláemit átul me mof mamu, ban ᵽoᵽ sañumut ebbañ sibaj ñice sitajen. ");
INSERT INTO bqj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lelen me búoh Aláemit nákasulkasul gunah gaugu, an mat’aᵽah ; bare nákasul go mala bugo naĉob me gúni bugola. ");
INSERT INTO bqj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","No ñer, an aagul me Kirista ume ter umua, jambi jíinenol. ");
INSERT INTO bqj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ᵽan baj ukirista ni ᵽoᵽ uboñer galet bugaa maagen gúᵽurul ; ᵽan gukan ugitenum ni waf wajureruti bi elimben bugan bugagu bugo Aláemit aĉob me, ínien me júe kano. ");
INSERT INTO bqj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jíkanum ! Nílobaliullobali me waf wauwu ᵽe ihato. » ");
INSERT INTO bqj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","« Bare ni gunah gaugu, no sílam sausu sijae me ejow bi ebao, bunaa babu ᵽan bumoĉ, fieñ fafu ᵽan fúbbur gaŋanno gagu gala fo, ");
INSERT INTO bqj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","suut sasu ᵽan síᵽagul fatiya émit súloul, ban sembe sasu ᵽe saamme fatiya ᵽan sugoror. ");
INSERT INTO bqj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","No ñer ᵽan jugi me Añol Arafuhow áavul ni gápar ni sembe sámah ni bájalo ró. ");
INSERT INTO bqj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ñer ᵽan áboñul emalakaol íkiil guomen buganol bugo naĉob me n’ulam waw ᵽe waa mof. ");
INSERT INTO bqj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jikan n’uinumul wo bubah nihi bigitenolal me : no uan bo úburiulo mbiban m’búyaul úsabul, jiffase búoh fujam fulofulo. ");
INSERT INTO bqj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Manur mamu may, no jijae me ejuh waf wauwu ᵽe uĉigul, jiffas búoh Añol Arafuhow nalofulo, naĉilo n’gánonum gagu. ");
INSERT INTO bqj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Maagen, ínje ilobul yo : bugan bugagu bugaa jama mati gutoh gubao eĉet dáuru ᵽe m’baĉigulat. ");
INSERT INTO bqj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Emít yay ni ettam yay ᵽan sibao, bare gurimom, go, mati gúmus gubao. » ");
INSERT INTO bqj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","« Mala effas funah fay ni tinah tay Añol Arafuhow ajae me ébbañul, ánoan affasut so, mele emalakaay gaam dó me n’émit, hani may Añil ahu ; Ᵽaaya o bareol affase. ");
INSERT INTO bqj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jíkanum, jambi júmori, mata jiffasut nay jae ekano. ");
INSERT INTO bqj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ᵽan ní ti ánaine aam n’ehat yaŋol min ake bújaor. Fufaneol nábahen fo asen urokaol, ánoan burokol, aban naah apoya ahu o ñer apoy. ");
INSERT INTO bqj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jiilo ñer ni mujah ró, mata jiffasut nay ala yaŋ ajae ébbañul. Ter ᵽan aĉigul tiname, ter n’etut fuh, ter tinahurab, ter ni bujom ; ");
INSERT INTO bqj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","jamb’aĉigul namimenul n’gámori ! ");
INSERT INTO bqj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Waf wanur nilobeul, ban buru ᵽe nilobe wo : Jambi júmori ! » ");
INSERT INTO bqj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ŋañoe gunah gúuba min gaggan gagu gaa Paak guĉigul, gaamme may gal unaĉ waw wabajut me lévir. Ñer ufan uteŋenaaw ni úᵽajula gúboñ Aláemit bugagu n’gúni n’eŋes bu gujae ekan ni mutuho ró min gujoh Yésu guban n’gumugol. ");
INSERT INTO bqj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nihi guoh : « Jamb’ujogalol me no gaggan gagu gutiñe me, jambi gáguo gubaj n’ésuh yay. » ");
INSERT INTO bqj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","No Yésu aamme Betani, ni yaŋ ace áine o háhae ejogene gajaol Simoŋ, ni baj ace aare ánonul dó bugo baamer ni fitiñ. Aare ahumu naogen jibara jateᵽiteᵽ, dó míĉir muom mátañie ejuh ban músumut ebaj ; nasat butum jibara jauju aban nailo áulen míĉir mamu mala jo ni fuhow Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ñer guce ni gamat me ni mujogil bireg nihi guogoro : « Ehajen mee míĉir maumu bi wa ? ");
INSERT INTO bqj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mújuene munnomeni síralam sammeŋe faŋ, mbiban n’siseni galeh me. » Ban n’gúbaho bi n’aare ahu. ");
INSERT INTO bqj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bare Yésu naagil : « Jihalol. Wa uĉile n’jíniol n’eyogen ? Waf waaro nakanom ! ");
INSERT INTO bqj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Galeh me, bugo, ᵽan jibajil nánonan ni buru ; nánonan no jimaŋe, jújue jikanil maaro, bare ínje jilelom n’ebaj bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aare ahume, wo náju me, wo nakane ; nálosalilosali enilom bi gafoh gagu gúmbam. ");
INSERT INTO bqj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Maagen, ínje ilobul yo : ni mof mamu ᵽe, tánotan to Firim fafu Fásum me fujae me evarei, ᵽan may lobi mala wo aare ahume akan me ; mamu ᵽan auno bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ᵽúrto, Yudas Isikariot, aamme ace ni uᵽotoraaw gaamme guñen ni gúuba, najow ak’atoh ufan uteŋenaaw bi ekan Yésu nalo n’guñenil. ");
INSERT INTO bqj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","N’guuttenol n’ésumay ró, ban n’gulob bi esenol síralam. No ᵽúrto me, Yudas náni n’eŋes no jáhor me bi ekan Yésu nalo n’guñenil. ");
INSERT INTO bqj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","No funah fafu fítiar faa gaggan gagu gal unaĉ waw wabajut me lévir fiĉih me, fiĉila fo gabbarum gagu gaa Paak yay nihi gúsimeni me, ulagora Yésu n’guogol : « Tay numaŋe iki jucokori fitiñ fafu faa Paak yay ? » ");
INSERT INTO bqj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ñer naboñ gúuba ni ulagorol naagil : « Jujow junogen n’ésuh yay. Ᵽan baj ánaine ace atebe jifin jaa mal aemor ni buru ; jilagenol. ");
INSERT INTO bqj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","To najae me enogen, n’juoh ala yaŋ yay : “Afan ahu naage juroreni ni baŋ bay najae me etiñ Paak yay o ni ulagorol.” ");
INSERT INTO bqj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ᵽan ñer agganul futoŋ fámah fatiya yaŋ yay facokori wári ban ni fújahor. Dó mbi jucokor me fitiñ fafu bi ni wolal. » ");
INSERT INTO bqj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ñer ulagoraaw gaamme gúuba n’gukay, guĉih n’ésuh yay n’gutoh waf waw ᵽe may ti Yésu alobil yo me, min ñer gucokor fitiñ fafu faa Paak yay. ");
INSERT INTO bqj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","No nuĉigal me gállim, Yésu naĉigul dó ni uᵽotoraaw gaamme guñen ni gúuba ró. ");
INSERT INTO bqj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","No guomme ni fitiñ, naagil : « Maagen, ínje ilobul yo : ace ni buru atiñore maa n’ínje ᵽan annomenom. » ");
INSERT INTO bqj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ni mujogil bireg n’gunamo erorenol anur-anur guoh : « Injé ᵽiaŋ ? » ");
INSERT INTO bqj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Naagil : « Ace ni buru jaamme guñen ni gúuba, ahu árure maa manur n’ínje gañenol ni biril banur. ");
INSERT INTO bqj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Maagen, Añol Arafuhow ban aĉet ti hiĉi me ya ni o. Bare mataño míni ni an ahumu ajaol me ennomen ! Faŋene jáari jamb’abugi ! » ");
INSERT INTO bqj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bugo ni fitiñ fafu, Yésu naŋar ganaĉ, násonien go, namusul go aban nagaboril go naagil : « Jiyab jitiñ : úre enilom. » ");
INSERT INTO bqj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mbiban naŋar éremuma ; no nasal me Aláemit aban, nasenil yo guremor bugo ᵽooil, ");
INSERT INTO bqj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","aban naagil : « Dáure físimom, físim fafu fáyui me mala bugan gammeŋe bi étugen babuge babu bo Aláemit ajogor me ni bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Maagen, ínje ilobul yo : mat’ibbander iĉoen bíñu bi funah fafu fo nijae me erem ece evugul ni Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","No Yésu alob me gurim gaugu aban, n’gúfoñ úfoñ wal esal Aláemit, mbiban n’gúᵽur gujow mbaa firijaŋ fafu fo guvoge me fal uoliv waw. ");
INSERT INTO bqj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","No guĉih me, Yésu naah ulagorol : « Buru ᵽe ᵽan jibbañ búsol sílamom baĉigerul, ti Aláemit alob yo me ni Bahiĉer babu, no naah me : “Ᵽan iteh akoña ahu imuh, ban ubbarum waw ᵽan uvisor uban babu ᵽe.” ");
INSERT INTO bqj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bare búsol eiloom ni gaĉet me ᵽan iyabul gayoŋ mbaa Gálile. » ");
INSERT INTO bqj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ᵽier naagol : « Hani bugagu ᵽe gubbañe búsol, bare ínje mat’ikan mo. » ");
INSERT INTO bqj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ñer Yésu naagol : « Maagen, ínje ilobi yo : n’efuga yauye réro, balama gáin guoh gúutten, ᵽan uoh ñono ñáfaji uffasutom. » ");
INSERT INTO bqj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bare Ᵽier naĉimen aah fatiya : « Hani ᵽan iĉet manur n’aw, mat’ímus ioh iffasuti. » Bugo ᵽe n’guyab dó. ");
INSERT INTO bqj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ᵽúrto, Yésu ni ulagorol n’gujow bi tiñ talu to guvoge me Getusemane. No guĉih me, naagil : « Jurobo tale min ᵽan ínje ike galaw. » ");
INSERT INTO bqj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","N’ejaol nájaenum Ᵽier, Saak ni Saaŋ. Ᵽiout, gáholi n’gunonol n’etelenor dó. ");
INSERT INTO bqj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Naagil : « Gaᵽinor gumugom iki biinumom búguo. Jinamo tale ban jambi júmori me ! » ");
INSERT INTO bqj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mbiban natos kan ráli maa, naya gújul aban náñuᵽ iki buulol buya n’ettam min alaw gaa búoh íni me júe kano, tinah tautu n’tíraliol. ");
INSERT INTO bqj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nah’aah : « Ᵽaᵽa, aw áju me wáfowaf, nilai ufaren éremuma yauye yaa sílam éraliom ! Bare mánoman níe, jambi wo ínje imaŋ me ukano, bare til wo aw umaŋ me. » ");
INSERT INTO bqj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mbiban nábbañul mbal ulagoraaw gúfaji bugagu aĉigul natogil min gúmoe. Ñer naah Ᵽier : « Simoŋ, aw gámori ? Hani enamo jatiito m’bámoit újuut yo ? ");
INSERT INTO bqj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jambi júmori, bare jilaw jambi julo ni gabut. Biinum arafuhow nihi bumamaŋ ekan maaro, bare enilol nd’ebaj sembe. » ");
INSERT INTO bqj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nabbañ atos ahalil to, aban nanamo nalaw ni gurim gagu ganur gagu. ");
INSERT INTO bqj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nabbañ ábbañul aĉigul natogil min gubbañe gúmori ; maagen mamu umoil úliilii nár. Ñer guffasut wa gujaol ébal. ");
INSERT INTO bqj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","No nabbanno me ebbañulol éfatten, naagil : « Juroŋe n’gámori gagu ? Gáelo gom ? Kanoe ban ! Tinah talu tiĉige. Añol Arafuhow nabeni aban ni guñen utilaaw. ");
INSERT INTO bqj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jiilo ujaal ! An ahu ajae me ennomenom nalofulo. » ");
INSERT INTO bqj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","To baenah, o n’elob yay, Yudas, aamme ace ni uᵽotoraaw gaamme guñen ni gúuba, naĉigul. Nájaorul ni fítiman faogene ufoje ni sugol ; kan ufan uteŋenaaw, úᵽajula gúboñ Aláemit bugagu ni ufan ésuh yay guboñulo fo. ");
INSERT INTO bqj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas aamme n’ennomenol baje wo nalollil waamme : « An ahu o nijae me élloŋ, aĉila ; jujogol ban n’jíjaenumol ni gapoy gaaro. » ");
INSERT INTO bqj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","No naĉih me, nafaen alof Yésu naagol : « Afanom ! » Aban nálloŋol. ");
INSERT INTO bqj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ñer bugagu gajaorulo me ni o n’gualen gujogol. ");
INSERT INTO bqj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ace ni gaamen to me ni Yésu náñagul gafojeol ni gafon go ateh aroka ahu ala afan uteŋenaaw aᵽirih gannu. ");
INSERT INTO bqj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ñer Yésu nábaho mbaa fítiman fafu naagil : « Jujoulo n’ufoje ró ni sugol bi ekelom fujoh ti nihi ní me akana-maarat jikelo fujoh. ");
INSERT INTO bqj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gunah émit ᵽe ínje umuen ni buru, no niligene me bugan bugagu ni gávi-Aláemit gagu, ban jujogutom. Bare dó ᵽe min mbi wo Bahiĉer babu bulob me úju ukano. » ");
INSERT INTO bqj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ni tinah tautu, ulagoraaw ᵽe n’gujundenol to min gúᵽur gutey gukay. ");
INSERT INTO bqj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bare ni baj áᵽur ace asimoe gábil nah’alanol ; gábil gaugu go bare guomme bisimool. N’gualen bi ejogol, ");
INSERT INTO bqj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bare nahalen gábil gagu min atey akay eraᵽataŋ. ");
INSERT INTO bqj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ᵽúrto, n’gújaenum Yésu bi n’afan uteŋenaaw ámah ahu, to ufan uteŋenaaw, ufan ésuh yay ni úᵽajula gúboñ Aláemit bugagu nihi guomunor me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ᵽier nah’alagen Yésu ráli bi ró ñáraru fúlumet afan uteŋenaaw ámah ahu. Nak’anamo to upoyaaw guomme náni n’gáumo ni sambun. ");
INSERT INTO bqj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ni tinah tautu, ufan uteŋenaaw ni fujoj Esúif yay fámah fafu ᵽoofo n’gunamo eliᵽ bagitener bájue bukan min Yésu amugi. Guliᵽ mee gubajut. ");
INSERT INTO bqj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gammeŋe gubije gugiten guya ni o, bare bagiteneril bilet banur. ");
INSERT INTO bqj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ni baj guce guilo min gubij gugiten guya ni Yésu guoh : ");
INSERT INTO bqj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","« Juunol aah ᵽan afum gávi-Aláemit gaugu go guñen arafuhow guteᵽ me, ban ni gunah gúfaji ᵽan ateᵽ gace go guñen arafuhow guñumut eteᵽ. » ");
INSERT INTO bqj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bare hani bae ni elob yauye, bagiteneril bubbañut bíni banur. ");
INSERT INTO bqj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ñer afan uteŋenaaw ámah ahu nailo n’etut fujoj fafu min aroren Yésu aagol : « Mat’úbal wáfowaf ? Uunut sulob se so gulobe maa guya n’aw ? » ");
INSERT INTO bqj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bare Yésu naᵽanor butumol, ábalut wáfowaf. Afan uteŋenaaw ámah ahu nabbañ arorenol aagol : « Aw uomme Kirista ahu, Añol Aláemit ásonieni me ? » ");
INSERT INTO bqj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yésu naagol : « Ey, aĉila nem. Ban funah fice, ᵽan jujuh Añol Arafuhow min anave ni gárib Aláemit-Sembe, ban ᵽoᵽ ᵽan jujugol áavul ni úpar waw wal émit. » ");
INSERT INTO bqj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ñer afan uteŋenaaw ámah ahu naĉaĉ bisimool aĉila faŋaol, aban naah : « Ugitena mul bugay nusoholaale utajenal ? ");
INSERT INTO bqj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Buru faŋaul juune gújel gagu go najel me Aláemit. Bu ñer jiᵽinore ? » Bugo ᵽooil n’gujoh búoh ᵽiloᵽilo min aĉet. ");
INSERT INTO bqj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ñer guceil n’gunamo emasenol, efut buulol ni etegol sumoh n’guogol : « Ulobóli ᵽaa ay ategi ! » Upoyaaw may n’gutegol simbej. ");
INSERT INTO bqj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ᵽier o baroŋer to tíyaŋ ni fúlumet fafu, ni baj ace ni urokaaw waarema bugal afan uteŋenaaw ámah ahu ájoul. ");
INSERT INTO bqj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aroka ahumu najuh Ᵽier min áumoe mee ; náᵽimborol pím nalujol aban naagol : « Aw may buru juomen me ni Yésu ala Nasaret. » ");
INSERT INTO bqj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naceŋ fo aah : « Iffasut wa numaŋe elob, ijogut. » Mbiban najow bi éᵽur ni gánonum gámah. No ñer, gáin n’guoh. ");
INSERT INTO bqj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aroka ahu najugol ban nabbañ anamo elob gaamen to me aagil : « Ahumu bugo bugom. » ");
INSERT INTO bqj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ᵽier nabbañ aceŋ fo. Ᵽio maa, gaamen to me n’gubbañ guoh Ᵽier : « Ti maagen, aw may buru bugom ; aw ᵽoᵽ an ala Gálile, baloberul banur bom. » ");
INSERT INTO bqj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ñer nanamo egiten meŋ, ak’abbat aah : « Iffasut an ahu o julobe mee mola. » ");
INSERT INTO bqj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","To baenah, gáin n’guoh gúutten, ban Ᵽier naosen firim fafu fo Yésu alobenol me faah me : « Balama gáin guoh gúutten, ᵽan uoh ñono ñáfaji uffasutom. » Ñer nanamo to ukoŋ n’eteh mahat ró. ");
INSERT INTO bqj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tinah n’ehalen, ufan uteŋenaaw n’gujoj manur n’ufan ésuh yay ni úᵽajula gúboñ Aláemit bugagu, dóemme fujoj fafu fámah fafu ᵽoofo. No gujoj me guban, n’gujoh Yésu guhoh, mbiban n’gújaenumol iki gusen Ᵽilat. ");
INSERT INTO bqj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ñer Ᵽilat narorenol aah : « Aw uomme ávi Esúif yay ? » Yésu naagol : « Aw faŋai nulob yo uban. » ");
INSERT INTO bqj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ufan uteŋenaaw baje sulob sammeŋe so gutegol. ");
INSERT INTO bqj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ñer Ᵽilat nabbañ arorenol aah : « Mat’úbahul wáfowaf ? Nuune wo gulobe me ᵽe guya n’aw ? » ");
INSERT INTO bqj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bare Yésu abbañut ábal ; ni kan Ᵽilat gajahali. ");
INSERT INTO bqj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ni gaggan gánogan gaa Paak, Ᵽilat nah’ahalenilhalen ace ni umigel waw gakuli me o guogol me ahalenulil. ");
INSERT INTO bqj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ban bajene ace áine, gajaol Barabas, o gúrure ni fipeh manur ni úgua-ésuh guce, mata ni gáguo gace gumumuh an. ");
INSERT INTO bqj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Fítiman fafu ni fijiŋ bi ró yaŋ Ᵽilat, fiĉih ni funamo elaol wo naᵽi me nah’akanil. ");
INSERT INTO bqj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ᵽilat naagil : « Jimaŋe ihanulul ávi ahu ala Esúif yay ? » ");
INSERT INTO bqj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(Narorenil mee mata naffase búoh físil fiĉile min ufan uteŋenaaw gúŋarul Yésu bi ni o.) ");
INSERT INTO bqj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bare ufan uteŋenaaw n’guilen fítiman fafu min mbi Ᵽilat ahanulil til Barabas. ");
INSERT INTO bqj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ᵽilat nabbañ aagil : « Wa ñer jimaŋe ikan an ahu o buru juvoge me ávi ahu ala Esúif yay ? » ");
INSERT INTO bqj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","N’gubbañ gúᵽib guoh : « Ubbaŋol n’ekurua ! » ");
INSERT INTO bqj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Naagil : « Maarat ñer may nakane ? » Bare n’gufaŋ n’gúᵽibe guoh : « Ubbaŋol n’ekurua ! » ");
INSERT INTO bqj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ñer Ᵽilat, nemme namamaŋ aalen fiiñ fítiman fafu, nahanulil Barabas. Mbiban, naboñ guteh Yésu gusoh gal ubaŋ, aban nasenil o bi eke ebbaŋ n’ekurua. ");
INSERT INTO bqj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ñer ekosombil yay n’gújaenum Yésu bi ñáraru fúlumet fafu faa yaŋ Ᵽilat, guban n’gúvogul fuyoŋ fafu faa gupalil ekosombil ᵽoofo. ");
INSERT INTO bqj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","N’gusimol wañ újugah, guban n’guŋar ulaliŋ waa sijeŋ gueĉ fugaŋ guoᵽol ni fuhow. ");
INSERT INTO bqj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mbiban n’gunamo esafol guoh : « Jisafi, ávi Esúif yay ! » ");
INSERT INTO bqj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","N’gutegol egol ni fuhow, n’gumasenol ban n’guya gújul bújoŋorol ti nihi gumaŋ me emigeletol. ");
INSERT INTO bqj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","No gúfohulol me iki guᵽilo, n’guram wañ waw újugah waw wo gukanol me, guban n’gubbañenol bisimool, mbiban n’gúᵽunnol tíyaŋ bi eke ebbaŋ n’ekurua. ");
INSERT INTO bqj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","N’ejail, n’guemor n’ace áine aam ni búolul n’ulah ; gajaol Simoŋ, an ala Siren, ᵽay Alsandul ni Rufus. N’gukanol ni sembe min ateb ekurua yay yaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","N’gújaenum Yésu bi tiñ talu to guvoge me Golugota, dóemme \"tiñ taa gasen\". ");
INSERT INTO bqj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","N’gumaŋ esenol bíñu yo gúguñore ni míĉir arem, bare nalat yo marem. ");
INSERT INTO bqj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","N’gubbaŋol n’ekurua yay, guban n’gugabor bisimool n’elukor bo bi effas ánoan fugabol fo najae me eŋar. ");
INSERT INTO bqj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","No gubbaŋol me n’ekurua yay, tinah báraberul. ");
INSERT INTO bqj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jibabar jaju dó hiĉi me waĉil me Yésu namugi, maa julobe : \"Aví ahu ala Esúif yay\". ");
INSERT INTO bqj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Baje ᵽoᵽ ukana-maarat gúuba bugo gubbaŋe ni sukurua manur ni o, ahu n’gañenol gárib, ahuo n’gamayol.  ");
INSERT INTO bqj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mamu, wo Bahiĉer babu bulob me n’ukano baah me : « Guᵽinol ni ukana-maarat bugagu. » ");
INSERT INTO bqj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bugan bugagu gaamme n’égat nihi gúllis guhoil ban n’gujelol nímoro n’guoh : « Eé, aw áju me ufum gávi-Aláemit gagu mbiban nubbañ uteᵽ go ni gunah gúfaji, ");
INSERT INTO bqj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","uᵽagenoro núavul n’ekuruai ! » ");
INSERT INTO bqj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ufan uteŋenaaw may ni úᵽajula gúboñ Aláemit bugagu nihi ᵽoᵽ gúfohulol guoh : « Nah’aᵽagen bugan, aban ájuut aᵽagenoro ! ");
INSERT INTO bqj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iní me maagen o aamme Kirista ahu, ávi ahu ala Israel, áavul maer yauye n’ekuruaol wolal ujugal, ban ᵽan úinenal ! » Bugo gubbaŋor me ni sukuruail manur ni o n’gunamo may ejelol. ");
INSERT INTO bqj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","No tinah tirih me, emoĉ néavul ni mof mamu ᵽoomo, ban néni to iki títigo. ");
INSERT INTO bqj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","No títigo me maa, Yésu náᵽib fatiya ni sembe aah : « Elí, Elí, lama sabahtani ? » Dóemme : « Aláemilom, Aláemilom, wa uĉile nujundenom ? » ");
INSERT INTO bqj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Guce ni gaamen to me n’guunol ban n’guoh : « Juutten ᵽaa, aboñer ahu Elí navoge mee ! » ");
INSERT INTO bqj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ñer ace ni bugo natey ák’ájeben jurocob bíñu yafifir ahoh ni gapil, aban nañuren jo min mb’acot jo n’eoh nímoro : « Jinah, ᵽan ujugal ter Elí ᵽan ájoul ákiil aannulol n’ekurua yay. » ");
INSERT INTO bqj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bare Yésu naya gáᵽib gámah aban naĉet. ");
INSERT INTO bqj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","To baenah, gábil gagu gaminden me tiñ talu táñai me dó ni gávi-Aláemit gagu n’guĉaĉo kábiriŋ fatiya go bi n’ettam go gukan uᵽeŋ úuba. ");
INSERT INTO bqj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Afan ekosombil yay aiyen to me bújoŋor Yésu, no najuh me min aalo me nogor, naah : « Aíne ahumu maagen Añol Aláemit omene. » ");
INSERT INTO bqj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bajene ᵽoᵽ waare gammeŋe gaiye ráli n’gúni ni faluj. Baje ni bugo Mari ala ésuh yay yaa Magudala, Mari jaw Soses bugo ni Saak apuma ahu, ni Salome. ");
INSERT INTO bqj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bugo nihi gulagen me Yésu ban n’gucokorol kábiriŋ no naamen me Gálile. Ni baj to ᵽoᵽ waare guce gammeŋe gajaorulo n’aĉila bi Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Funah faufu funah fom fal ecokor wáari me bi fitiñ, yoemme fo tihalene me fíiyay Esúif yay. Ni baj ace áine gajaol Susef. O an om ala Arimate o gúkanume faŋ ni fujoj fafu fámah fal Esúif yay dó naamme ; o ᵽoᵽ Jávi jaju jal Aláemit naamen n’enah. Min ajuh me búoh tinah utu n’ejon, nabaj gakañen gagu gal ejow bi ni Ᵽilat ák’ácinol efuluŋ yay yaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ᵽilat najahali min Yésu afaen me aĉet ; naboñ gúvogul afan ekosombil yay min arorenol ter maagen mamu Yésu naĉeĉet. ");
INSERT INTO bqj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","No afan ekosombil yay aĉilo me ak’agitenol wabaj me, Ᵽilat nahat Susef nak’aŋar efuluŋ yay. ");
INSERT INTO bqj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ñer Susef nak’annom gábil, aban náannul efuluŋ Yésu n’ekurua yay naŋar gábil gagu ággub yo, aban nabaŋ yo ñáraru fuyah faogioh n’gacaĉ erijaŋ. Mbiban, nábaken fuval atoj gánonum fuyah fafu. ");
INSERT INTO bqj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari ala Magudala ni Mari jaw Soses n’gunamo n’gúni ni faluj to gubaŋe yo me. ");
INSERT INTO bqj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","No fíiyay Esúif yay fúgat me, Mari ala Magudala, Salome ni Mari jaw Saak n’gunnom batiŋoa bi eke elos efuluŋ Yésu. ");
INSERT INTO bqj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tihalen fíiyay faufu, m’bujom mej, n’gújaali bi ni fuyah fafu. ");
INSERT INTO bqj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","N’ejail nihi gurorenoro guoh : « Ay mb’ábakenolal me fuval fafu fatoj me gánonum fuyah fafu ? » ");
INSERT INTO bqj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","No guĉih me, n’gujuh búoh fuval fafu fare mee fúbakenibaken fulaleni. ");
INSERT INTO bqj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ñer n’gunogen dó ni fuyah fafu, ban n’gutoh ró ánaine asimoe gájuo gátuay gaave bi to n’guolol, anamo abbañ gañen gárib ; n’gúholi faŋ. ");
INSERT INTO bqj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bare áine ahu naagil : « Jambi jújuhulo ; leti Yésu ala Nasaret o gubbaŋ me n’ekurua yay jiŋese ? Naiye ni gaĉet me, alet tale ! Juluj, tiñ talu ute to gubaŋenol me. ");
INSERT INTO bqj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maer jujow iki juoh ulagorol ni ᵽoᵽ Ᵽier Yésu nayabul gayoŋ mbaa Gálile, bo ᵽan jujugol me ti naᵽi me nalobul yo. » ");
INSERT INTO bqj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ñer n’gúᵽurul ni fuyah fafu gutey gukay n’etelen dó májuhuloe ; gáholiil n’guĉilil gulobut yo ánoan m’bulago.  ");
INSERT INTO bqj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tihalen fíiyay faufu, ni bujom babu bo Yésu ailo me ni gaĉet me, Mari ala Magudala namundum me áᵽurul ; n’aĉila námus me aham siseytane sono futoh ni súuba. ");
INSERT INTO bqj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ñer Mari natey ak’agiten yo gaamen me ni Yésu, garoŋ dó me ni ñuhul ni ukoŋ. ");
INSERT INTO bqj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bare no guun me búoh Yésu narondoŋ ban aĉila Mari najugol, gúinenutol. ");
INSERT INTO bqj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ᵽúrto, Yésu naŋar ganogor gace gábulie min áᵽurul mul guce ni bugo gúuba, babu m’bulago bugo n’ejow bi n’ésuh ece yaa baha. ");
INSERT INTO bqj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bugo may gubbannobbañ íkiil gugiten yo bugagu ulagora, ban gúinenutil ᵽoᵽ. ");
INSERT INTO bqj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Búsol, Yésu náᵽurul uᵽotoraaw gaamme guñen ni an anur bugo ni fitiñ ; ban nannuril mala gáinenutil ni gaakil uinum, mala min gúinenut mee bugagu gajugol me búsol no nailo me ni gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aban naagil : « Jujow mof mamu ᵽoomo, jivare Firim fafu Fásum me bugan bugagu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","An áinen me, ban nábatisei, ᵽan aᵽah ; bare an alat me éinen ᵽan ake ni sambun. ");
INSERT INTO bqj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Waf wauwe waunderuti mee, wo ᵽan ukano me ni guñen gaa bugan bugagu gáinen me : ni gajow gúmbam ᵽan guham siseytane sasu ; ᵽan gulob balober bábulie ni bolil ; ");
INSERT INTO bqj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","gujoh me sunuhunjaŋ ni guñenil, ter gurem bisih, mati sújuil wáfowaf ; guremben me úsotaaw guñenil, ᵽan guhoy. » ");
INSERT INTO bqj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","No Ataw Yésu alobil me gurim gaugu aban, natebor akay mbal émit ak’anamo ró ni gárib Aláemit. ");
INSERT INTO bqj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ñer uᵽotoraaw n’gujow guban babu ᵽe guke gavare Firim fafu Fásum me. Ataw nah’arambenil m’burokil, ban nah’akan waf waunderuti n’ubaj bi egiten maagen mamu maa bavareeril.");
INSERT INTO bqj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Abugeom Teofil, nuffasale búoh bugan gammeŋe gulige ehiĉ waf wauwu ᵽe wájalo mee wabaj me n’etulóli. ");
INSERT INTO bqj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bugan bugaubugi gugitenóli wo guun me n’utum bugagu gajuh wo me táh kábiriŋ ni buju babu, gabbanno me gúni ugitena firim Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yo eĉil me, ínje may no niŋes me ik’iffas joon waf wauwu ᵽe bi ni fíĉilum wo, nibaj biinum baube bal ehiĉuli. Aw Teofil, o níkanum me, nihiĉuli wo ni ganab ti ujow me. ");
INSERT INTO bqj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nikanmokan min mb’úju uffas búoh waf waw wo guligeni me ubabaj ti maagen. ");
INSERT INTO bqj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","No Herod aamen me ávi mof mamu maa Yúde, bajene ace áine aĉil me bíteŋen babu, gajaol Sakari ; o ni fítiman fafu fal Abia nam. Aarol gajaol Elisabet, ban ni fiil fafu fal Aaroŋ náᵽullo, aamen me ateŋena ámah ala Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bugo éubail buroŋil búsusum Aláemit, ban ni’gúkanum faŋ gúboñ gagu ᵽe gal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bare gubajut añil, mata Elisabet affasut fufane, ban bugo éubail gúfanumfanum. ");
INSERT INTO bqj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Funah fice, Sakari náni n’ekan burokol ni gávi-Aláemit gagu mata fítiman fafu fola fiĉiggo. ");
INSERT INTO bqj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","N’gulukor ti guᵽi me nihi gukan, ni kan Sakari aĉiggo bi enogen ni gávi-Aláemit gagu ake esaen uyew waw wolil. ");
INSERT INTO bqj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","No naam wo me n’esaen, ésuh yay ᵽe n’guilo tíyaŋ n’gúni n’galaw. ");
INSERT INTO bqj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","To baenah ni baj amalaka ala Aláemit áᵽullol dó ni gávi-Aláemit gagu, nailo n’gañen gárib fúkanum-sambun fafu. ");
INSERT INTO bqj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakari no najugol me, ajugut enilol, gáholi n’gunonol. ");
INSERT INTO bqj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bare amalaka ahu naagol : « Sakari, jamb’úholi ! Aláemit nayayab galai. » Natajen aagol : « Aari Elisabet ᵽan abaji áᵽur, mb’ukanol gajow gagu gaa Saaŋ. ");
INSERT INTO bqj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O mb’akan me min biinumi bifilo, ban no najae me ebugi, bugan gammeŋe ᵽan súmil. ");
INSERT INTO bqj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ᵽan akan an ámah bújoŋor Aláemit, ban mat’arem erem yánoyan yo néh’éhallen. Kábiriŋ ni fuputeol, Biinum Banabe ᵽan bíni ni o. ");
INSERT INTO bqj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ᵽan ábbañenul gammeŋe ni bugal Israel mbal Aláemit aamme Atúlail. ");
INSERT INTO bqj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ᵽan abaj biinum ni sembe ti Elí aamen me aboñer ala Aláemit. Ᵽan ayab gayoŋ Aláemit bi ekan sipaya n’guunor ni guñolil ; bugan bugagu gamaŋérit me eun, ᵽan abbañulil gúni ti bugagu gaĉol me. Mamu, ᵽan aomen bugan guvugul bi ni Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bare Sakari naagol : « Bu nijae me ñer ekan min iffas búoh dáuru maagen ? Let ínje nífanumfanum, ban aarom ᵽoᵽ naake ? » ");
INSERT INTO bqj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Amalaka ahu naagol : « Injé iomme Gáburiel, o nihi ailo me bújoŋor Aláemit. O aboñulom bi egiteni firim faufu fásum mee. ");
INSERT INTO bqj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nemme úinenut firimom fajae me bae ekano funah fo baĉiger, mat’ubbañ úju elob bi funah fafu fo fujae me ebaj. » ");
INSERT INTO bqj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Min Sakari aᵽio ró me, ésuh yay ganageol me tíyaŋ n’gujahali. ");
INSERT INTO bqj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","No ñer náᵽullo me ni gávi-Aláemit gagu, abajut butum bal elob ni bugo ; naŋar guñenol min alih egitenil wabajol me. Ñer ésuh yay n’gútallo búoh babaj bujugum bo najugulo ró. ");
INSERT INTO bqj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","No gunagol gaa burok gubao me, Sakari naot mbal ésugol. ");
INSERT INTO bqj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ᵽúrto, aarol Elisabet naŋar far. Gueñ futoh o n’ekoᵽ n’enah nímoro nah’aah ni biinumol : ");
INSERT INTO bqj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","« Aláemit úre nakan maa bi n’ínje : naannulo gúĉilol bi n’ínje min áᵽuren ñusuom bújoŋor bugan bugagu. » ");
INSERT INTO bqj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","No baj me gueñ futoh ni fanur, Aláemit naboñ amalaka ahu Gáburiel bi n’ésuh ece yaa mof mamu maa Gálile, gajow yo Nasaret, ");
INSERT INTO bqj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","yaŋ bice bájur gajaol Mari. O ámusut affas ánaine, n’guᵽañol gusen ace áine gajaol Susef, áᵽullo me ni fiil ávi ahu David. ");
INSERT INTO bqj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ñer no amalaka ahu aĉih me, nanogen dó naah Mari : « Nisafi, aw ayab me gáji gámah. Aláemit umu ni aw. » ");
INSERT INTO bqj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Firim faufu ni fujahaliol nár iki arorenoro : « Basaf baubu, basaf bu bom ? » ");
INSERT INTO bqj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Amalaka ahu naagol : « Mari, jamb’úholi, mata gáji Aláemit ugu ni aw. ");
INSERT INTO bqj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Niege : ᵽan uŋar far uk’upegor áᵽur, mb’ukanol gajow gagu gaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ᵽan áni an ámah, ban ᵽan gusalol \"Añol Aláemit-Fatiya.\" Aláemit Atúla ᵽan asenol efenjeŋ yay yaa ᵽayol afan David. ");
INSERT INTO bqj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aĉila ajae me éni ávi ahu ala bugal Israel bi nánonan, ban fívietol mati fúmus fubao. » ");
INSERT INTO bqj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari naah amalaka ahu : « Bu ᵽan kano ínje m’baffasut ánaine ? » ");
INSERT INTO bqj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Naagol : « Biinum Banabe ᵽan búavul íkiil birembor n’aw, ban sembe sal Aláemit-Fatiya ᵽan súureni. Yo eĉil me añil ahu ajae me ebugi ᵽan anab, ban ᵽan guvogol \"Añol Aláemit\". ");
INSERT INTO bqj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nujuge ani Elisabet, aĉila may umu m’bíteb júᵽur ni fufaneol ; aĉila o guogen me o emotombo, maer umu ni fieñol fakan me futoh ni fanur. ");
INSERT INTO bqj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maagen mamu, bajut waf wo Aláemit ájuut ekan. » ");
INSERT INTO bqj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ñer Mari naah : « Injé amigel Aláemit nem. Wáfowaf wo nulob me uya n’ínje, mb’ukano ! » Mbiban, amalaka ahu nakay. ");
INSERT INTO bqj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ᵽúrto, Mari nailo asommen ajow ariŋen mbal ésuh Elisabet yaamme ni gurijaŋ gagu gaa Yúde. ");
INSERT INTO bqj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","No naĉih bo me, nanogen ni yaŋ Sakari nasaf Elisabet. ");
INSERT INTO bqj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","No Elisabet aun me Mari asafol, añil ahu nagoror ni farol. Ñer Biinum Banabe m’bunogen Elisabet ");
INSERT INTO bqj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","min alob fatiya aah : « Aw Aláemit násonienisonien faŋ waareaw ᵽe, ban gásonien gaugu ᵽan gúni n’añil ahu o nujae me ebaj. ");
INSERT INTO bqj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Injé niᵽiloe ᵽiaŋ bi ealen súndoom jaw áviom ? » ");
INSERT INTO bqj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Natajen aagol : « Nujuge, no niun me basaferi, ésumay nekan añil ahu aamme ni farom nagoror. ");
INSERT INTO bqj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gásumay gúni n’aw, mala min úinen me búoh wo Aláemit aboñulo me gulobi ᵽan ukano. » ");
INSERT INTO bqj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ñer Mari naah : « Biinumom bumaŋe esal Aláemit ! ");
INSERT INTO bqj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Eĉígirom emmemmeŋ ésumay mala Aláemit aamme aᵽagenaom, ");
INSERT INTO bqj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","min aannulo me gúĉilol aluj ínje aamme amigelol, ban itogut wáfowaf. Maagen, maer bi nánonan bugan bugagu ᵽan nihi gulob múmbam n’guoh : “Aare ahu abaj me gásumay.” ");
INSERT INTO bqj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mata Aláemit-Sembe nakakan waf waaro bi n’ínje. Gajow gagu gola, go barebare gunanab. ");
INSERT INTO bqj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jabbah bi ni jabbah, músumol májalo mee umu ni gákanumol me. ");
INSERT INTO bqj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nagitengiten gáju gagu gola ni sembeol, min avis me újiloraaw. ");
INSERT INTO bqj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Narikul úviaw ni sifenjeŋil, aban nateben galet me n’gaᵽin. ");
INSERT INTO bqj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gacaret me, nasenil fubaj, bare nabbañen usanum waw guñen gurakel. ");
INSERT INTO bqj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ti nalob me sipayolal, no najogor me babugeol baliŋ mee n’Aburaham bi ni gabugorol ᵽe, naosen bi nánonan wolal bugal Israel jákanumol me, min arumolal me enil. » ");
INSERT INTO bqj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ñer Mari nanamo n’guñen Elisabet butum gueñ gúfaji, ᵽúrto naot. ");
INSERT INTO bqj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet no funagol fiĉih me, napegor nabaj júᵽur. ");
INSERT INTO bqj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Buganol ni uĉindorol n’guun búoh Aláemit nagitenolgiten ñarumol enil ñájalo mee, ñer ni súmil nár manur ni o. ");
INSERT INTO bqj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","No añil ahu abaj me gunah futoh ni gúfaji, n’gújoul ᵽe gúkail gumat érurol búhut. N’gumaŋen eŋar gajow ᵽayol Sakari gukanol, ");
INSERT INTO bqj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","bare jaol naagil : « Hani ! Mb’uvogalol Saaŋ. » ");
INSERT INTO bqj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","N’guogol : « Bare bajut an ni fiil fafu fíya o ni’guvoh gajow gaugu ! » ");
INSERT INTO bqj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","N’gúbaho mbaa ᵽayma n’guŋar guñenil min gurorenol gay gajow namaŋe ekanol. ");
INSERT INTO bqj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ñer naagil guŋallol jibabar jal ehiĉ, min ahiĉ ró : « Gajaol Saaŋ. » N’gujahali bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","To baenah, Sakari nabbañ áju elob, min áni n’esalen Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ñer uĉindorol n’gúholi bugo ᵽe, iki tánotan ni gurijaŋ gagu gaa Yúde n’gúni n’galolobor mala yo. ");
INSERT INTO bqj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Anóan aun yo me náni n’eᵽinor bu añil ahumu ajae me éni gajem. Maagen mamu, sembe Aláemit usu ni o. ");
INSERT INTO bqj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ñer Biinum Banabe m’bunogen Sakari, ᵽay añil ahu, m’bisenol áni n’elob aah : ");
INSERT INTO bqj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","« Usalal Aláemit, Atúla ala bugal Israel, mata najegorolaljegor, ban naᵽagenolal, wolal bugo naĉob me. ");
INSERT INTO bqj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Náuwenulolal aᵽagena ala sembe, áᵽullo ni fiil David aamen me amigelol, ");
INSERT INTO bqj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ti nah’alobolal yo me n’utum uboñerol kábiriŋ m’buju babu. ");
INSERT INTO bqj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naagolal ᵽan aᵽagenolal ni ulatorolal, náᵽunnulolal ni guñen gaa bugan bugagu ᵽe gamaŋutolal me. ");
INSERT INTO bqj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nagitengiten sipayolal músumol, ban ájumorut babuge babu baliŋ mee ban ni bunab bo najogor me ni bugo, ");
INSERT INTO bqj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ti nabbat yo me bújoŋor ᵽayolal Aburaham. ");
INSERT INTO bqj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Naᵽagenolal ni fujoh fafu fal ulatorolal, min mb’újual umigeletaol gunah émit ᵽe m’báhollut. Mamu mb’únial bújoŋorol bugan bugaa maagen, bugan gaĉole. ");
INSERT INTO bqj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ñer aw, añolom, ᵽan guvogi aboñer Aláemit-Fatiya, mata aw ujae me eyabol gayoŋ bi eteŋen bulagool ; ");
INSERT INTO bqj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","aw mb’ugiten me bugan bugagu búoh ᵽan aᵽagenil min ajae me eboketil utilil, ");
INSERT INTO bqj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","mata Aláemilolal násusum, náju ñarum enil nímoro. Ᵽan akan gajaŋaol n’gufijigenulolal kábiriŋ dó fatiya, ganogor me ti gaa tinah to bajuer étebul, ");
INSERT INTO bqj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","dó ᵽe bi efijigen wolal jaamme n’emoĉ yay yal eĉet, bi ᵽoᵽ éĉibbenolal ni bulago babu baa gásumay. » ");
INSERT INTO bqj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Min añil ahu abbage me, mo may mujagol mutose me. Nanamo bo n’eᵽarandaŋ yay bi funah fafu fo najae me éᵽurul bújoŋor bugal Israel. ");
INSERT INTO bqj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gannay gaugu, ni baj gúboñ gáᵽullo ni ávi ahu ala mof mamu maa Rom, gajaol Sesar Ogis, bi eᵽin bugan bugagu ᵽe bugaa mofol. ");
INSERT INTO bqj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gaᵽin gaugu gátiar gukani no Kirinius aogen me mof mamu maa Siri. ");
INSERT INTO bqj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Min ñer bugan bugagu ᵽe ánoan nabbañ mbal ésugol iki guᵽinol bo. ");
INSERT INTO bqj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yo eĉil me, Susef may náᵽurul n’ésuh yay yaa Nasaret ni mof mamu maa Gálile, ajow bi ni mof mamu maa Yúde, bi n’ésuh yay yaa ᵽayol afan David, yaamme Betuleem, ");
INSERT INTO bqj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","min mbi guᵽinol bo, o ni aᵽañorol Mari aamme ni far. ");
INSERT INTO bqj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bugo neroŋ bo yay Betuleem, Mari funagol ni fiĉih. ");
INSERT INTO bqj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Min anogen nabaj añolol átiar áᵽur. Naŋar urocob ággubol, aban nafilenol ni gasium, mata gureut ró ni futoŋ fafu dó nihi gualen me sijaora. ");
INSERT INTO bqj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Efuga yauyu, ni baj ukoña ubbarum galam ésuh yay gaamen bo n’epoy sukoreil. ");
INSERT INTO bqj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ni baj amalaka ala Aláemit áᵽullil bo ni gajaŋa Aláemit ró, gakan me efuga yay neŋanno. N’gúholi nár. ");
INSERT INTO bqj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bare amalaka ahu naagil : « Jambi júholi, mata firim fásume niŋallul fajae me ekan ésuh yay ᵽe n’gúsumaet nár. ");
INSERT INTO bqj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Efuga yauye, aᵽagena ahu olul nabugi n’ésuh yay yaa David, o aamme Kirista ávi ahu. ");
INSERT INTO bqj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wajae me egitenul o, uwe : Ᵽan jutoh jiñil jajue ebugi, júggubi n’urocob ban n’jifileni ni gasium. » ");
INSERT INTO bqj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","To baenah, ni baj fítiman fal emalaka galam átiar ahu, n’gúni n’esalen Aláemit n’guoh : ");
INSERT INTO bqj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","« Gasal gúni n’Aláemit-Fatiya, gásumayol gúni ni mof, ni bugan bugagu bugo nábboli me. » ");
INSERT INTO bqj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","No emalakaay gubbañ me mbal émit, ukoñaaw n’guoh : « Ujaal mbaa Betuleem uk’ujugal táh waf wauwu wo Aláemit agitenolal mee. » ");
INSERT INTO bqj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","N’gusommen gujow bi bo, guĉih n’gutoh bo Mari ni Susef ni añil ahu afileni me ni gasium. ");
INSERT INTO bqj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","No gujuh me añil ahu, n’gunamo egiten wo amalaka ahu alobulil me mola. ");
INSERT INTO bqj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bugan bugagu ᵽe gauttenil me n’gujahali gurim gaugu go ukoñaaw gulobeil mee. ");
INSERT INTO bqj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari aĉila nabaŋ go m’biinumol náh’ábahulor go ró. ");
INSERT INTO bqj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ᵽúrto, ukoñaaw n’gúbaho bi ebbañ mbaa sukoreil, n’gúni n’esalen bájalo Aláemit min akanil mee n’guun ban ni gujuh waf waw wabaj me ; wo ᵽe ukanokano ti amalaka ahu alobil yo me. ");
INSERT INTO bqj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","No baj me gunah futoh ni gúfaji, enogen añil ahu búhut neĉih. N’gukanol gajow gagu gaa Yésu, ti amalaka ahu aᵽi me nalob yo balama jaol aŋar farol. ");
INSERT INTO bqj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jaol nanamo to m’bárurut ak’añil ahu abaj gunah úvi gúuba, balama árur ti gúboñ Móis gulob yo me. Ñer ubugaol n’gújaenumol bi n’gávi-Aláemit gagu gaamme Yérusalem bi eteŋenol bújoŋor Aláemit, ");
INSERT INTO bqj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","mata ni gúboñ Aláemit guhiĉdóhiĉ guoh : « Aᵽúr ánoan abugi átiar, mb’abaŋi bi n’Atúla. » ");
INSERT INTO bqj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bi ekanol bíteŋen babu baa gúboñ gagu, ᵽan guŋar sitalab súuba, ter múlab múuba. ");
INSERT INTO bqj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","No, baje ace áine baubu Yérusalem gajaol Simioŋ. Aíne ahumu naĉoĉol, nákanum Aláemit ban naam n’enah an ahu ajae me eᵽagen Israel. Biinum banabe m’bíni ni o, ");
INSERT INTO bqj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ban m’bigitenol búoh mat’aĉet o m’bajugut táh Kirista ahu o Aláemit ajae me éboñul. ");
INSERT INTO bqj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Funah faufu, Biinum Banabe m’bukanol najow bi n’gávi-Aláemit gagu. Ban ubuga Yésu n’guŋarulol ᵽoᵽ bi ró bi eteŋenol, ti guᵽi me nihi gukan gúboñ Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ñer Simioŋ naᵽem añil ahu nasalen Aláemit nímoro aah : ");
INSERT INTO bqj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","« Aláemit, wo númus me ulobom, ukanoe. Maer ñer nújue uhat ínje amigeli min eĉet yay éjaenumom ni gásumay, ");
INSERT INTO bqj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mata nijuge táh n’gúĉilom aᵽagena ahu o nuboñulo me, ");
INSERT INTO bqj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","o nubaŋ me bújoŋor súsuh sasu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","O aamme gajaŋa gagu gajae me efijigen so, gakan me Israel neuno. » ");
INSERT INTO bqj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ñer ubuga Yésu n’gujahali min Simioŋ alobe mee mala añolil. ");
INSERT INTO bqj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioŋ násonienil, aban naah jawma : « Aláemit naĉoĉob añil ahume ajae me erikul bugan gammeŋe abet, ban o ajae me may eilen bugan gammeŋe dáre Israel. Aĉila ᵽan áni me bigitenum Aláemit, ban ésuh yay ᵽan gulalol ; ");
INSERT INTO bqj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ᵽan ajaŋen uᵽinorum waw wakoᵽ me waa bugan gammeŋe. Ban aw Mari, gúnigo añoli ᵽan gutiñi ti an o guyae gafoje n’éĉigir. » ");
INSERT INTO bqj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Baj bo ᵽoᵽ aboñer ace anaare, gajaol Aana, añol Ᵽanuel, áᵽullo me ni fiil fafu faa Aser. Náfanum nár ; símit futoh ni súuba nabaje ni búyabool, ");
INSERT INTO bqj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","aban nanamo to etiñ ebara ak’aĉih símit úvi gubbagir ni sibbagir (84). Aare ahumu nd’áᵽur ni gávi-Aláemit gagu, ban nah’amigeletol etufunaha ebao, élima nebao ; nah’alaw ni gamorol dó. ");
INSERT INTO bqj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","O may natogil bo min anamo ᵽoᵽ esalen Aláemit. Aban náni n’egiten mala añil ahu bugan bugagu ᵽe gaamme n’enah min Aláemit aᵽagen Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","No ubuga Yésu guban me ekan waf waw ᵽe wo gúboñ Aláemit gulob me, n’gutebol n’guot mbaa Gálile, bi n’ésugil yaamme Nasaret. ");
INSERT INTO bqj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Añil ahu nabbah ni sembeol ró, nalillo faŋ, ban gáji Aláemit n’gúni ni o. ");
INSERT INTO bqj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Emít yánoyan, ubuga Yésu ᵽan gujow bi Yérusalem guke emat gaggan gagu gaa Paak. ");
INSERT INTO bqj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","No Yésu abaj me símit guñen ni súuba, n’gújaenumol ake go bo emat, ti ᵽi me nihi kani. ");
INSERT INTO bqj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","No gaggan gagu gubao me, n’guot. Bare Yésu nahalo bo Yérusalem ubugaol m’bátallout, ");
INSERT INTO bqj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","mata n’gaᵽinoril, ñace umuen ni gupalil gaamme m’búot. N’gujow funah iki fubao. No tinah tujon me, n’gúni n’eŋesol ni buganil ni ubugeil, ");
INSERT INTO bqj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","bare gujugutol. Ñer n’guvelo to gubbañ mbaa Yérusalem n’eliᵽ ró. ");
INSERT INTO bqj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","No tihalen me funagil fúfatten, n’guraŋenol bo n’gávi-Aláemit gagu, anamo n’etut úᵽajula gúboñ Aláemit, nah’auttenil narorenil nímoro. ");
INSERT INTO bqj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gaam to me ᵽe n’gujahali mala mujagol ni bábalerol gurim gagu. ");
INSERT INTO bqj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","No ubugaol guŋandenol me, n’gujoh n’utum. Mufaŋ jaol naagol : « Añúm, wa uĉile nukanóli mee ? Injé wóli ni ᵽai jiŋesiŋes iki mufaŋ ! » ");
INSERT INTO bqj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naagil : « Jiŋesom bi wa ? Jiffasut búoh níarie íni ni burok babu baa Ᵽayom ? » ");
INSERT INTO bqj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bare ubugaol gújuut gujoh wo añolil alobeil me. ");
INSERT INTO bqj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ᵽúrto, Yésu naiyul min guot mbaa Nasaret, ban nákanum ᵽayol ni jaol faŋ. Ñer jaol nabaŋ waf wauwu ᵽe ni biinumol. ");
INSERT INTO bqj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Min símit Yésu sígale me, mo may gaffasol gutose me, mo may ᵽoᵽ násume me Aláemit ni bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Emít yay yakan me símit gaat, mof mamu mo ni guñen Sesar ahu Tiber, Pons Ᵽilat o baamer ni fuhow mof mamu maa Yúde, Herod o naogen maa Gálile, atiol Fílip o naogen Itúre ni Turahonit, Lisañas naogen Abilen, ");
INSERT INTO bqj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","bajene may ufan uteŋenaaw gúuba gaamen dó, ahu gajaol Hanas, ᵽúrto ahu áutten naŋar, gajaol Kayafa. Gannay gaugu, firim Aláemit ni fujow iki futoh Saaŋ, añol Sakari, baubu n’eᵽarandaŋ yay yámah yay. ");
INSERT INTO bqj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Min ailo atey mof mamu ᵽe maamme galam fal fafu fo guvoge me Suruden. Nah’avare bugan bugagu aah : « Jíbahen bakanerul, mbi jiyab gábatise bi egiten búoh maer Aláemit naboketul utilul ! » ");
INSERT INTO bqj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mamu firim fafu fukano mee fo aboñer ahu aamme Esai aŋay me nahiĉ n’éleburol : « Firim fúᵽureul baubu n’eᵽarandaŋ yay nihi fuoh fatiya : “Jiteŋen fukaen bi ni Ataw ! Jiyaol ulago waĉole ! ");
INSERT INTO bqj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jii gúĉiĉilen gagu ᵽe, jíalenul gurijaŋ gagu iki re heb n’ettam yay, juĉolen may uŋof waw waa bulago babu, jufogen usun waw wala bo ! ");
INSERT INTO bqj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ñer ánoan ᵽan ajuh gaᵽagen gagu go Aláemit ajaeolal me !” » ");
INSERT INTO bqj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Esúh yay n’gújoul fuyoŋ bi ni Saaŋ tima nábatiseil. Naagil : « Buru gabugor súᵽudum ge ! Juoseh mamu jijae eᵽah bataliŋ Aláemit bájaeul me. Ay alobul mee ? ");
INSERT INTO bqj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mbi nihi jikan maaro bi egiten búoh ᵽan jíbahen bakanerul ! Jambi jinamo to nánonan eoh : “Nemme wóli gabulaken Aburaham jom, ᵽan jiᵽah.” Injé ilobul yo, leti jujuge sival sause ? Yoo, Aláemit áju me ábahen so síni gabugor gal Aburaham. ");
INSERT INTO bqj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Fínir fafu ufu to n’fubaŋi bi efar ununuh waw ; bununuh bánoban babugut mitiñ maaro ᵽan biᵽiki bibeni ni sambun. » ");
INSERT INTO bqj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ñer ésuh yay n’guogol : « Ñer ᵽiaŋ bu juñum me ekan ? » ");
INSERT INTO bqj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Naagil : « An abaj me újuo úuba, mb’áji gagu apalol abajut me. An ᵽoᵽ abaj me atiñ, mb’áji ahu abajut me. » ");
INSERT INTO bqj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ni baj may uyaba-búalen gújoul bi eyab gábatise ni Saaŋ, n’guogol : « Ñer wóli, bu jijae me ekan ? » ");
INSERT INTO bqj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naagil : « Leti jiffase wo búalen babu buroren me ? Jambi jiyab iki faŋ to ! » ");
INSERT INTO bqj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ekosombil yay n’gújoul may jolil ni suroren sasu sanur sasu ró, naagil : « Jambi ni’júhollen bugan ! Jambi ᵽoᵽ jigenil bi eram síralamil ! Mbi jujoh to m’bacamul re to. » ");
INSERT INTO bqj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Esúh yay n’gunamo enah Kirista ahu, ban ánoan ni bugo náni n’etehumor ter Saaŋ aamme Kirista ahumu. ");
INSERT INTO bqj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bare Saaŋ naagil bugo ᵽe : « Injé mal nih’iŋar níbatiseul. Bare ahu aamme n’éjoul nafaŋom sembe fúf. Iᵽilout bi ejal unew sidalaol hani jatiito. Aĉila ᵽan ábatiseul ni Biinum Banabe ni sambun. ");
INSERT INTO bqj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ᵽan aogen ni gañenol gárigol gal eey bi éfaculor emano yay ni emey yay. Emano yay, ᵽan abet yo ni bíjej, bare emey yay, yo, ᵽan akan yo fuñulen fañumut efogo. » ");
INSERT INTO bqj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mamu Saaŋ nah’atar ésuh yay utar waw ᵽe o n’egitenil Firim fafu Fásum me. ");
INSERT INTO bqj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herod aogen me Gálile naᵽi bo n’ekan maarat, ban narandam Herodias aamme aar atiol ayab. Ban no Saaŋ aĉafol me mala yo ni mala mamu maarat ᵽe, ");
INSERT INTO bqj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod nafaŋ nakane maarat : najogol árur ni fipeh. ");
INSERT INTO bqj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","No ésuh yay guyabe me gábatise, Yésu may nájoul ákail go eyab. O ni galaw, émit yay népegulo, ");
INSERT INTO bqj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","min Biinum Banabe buŋar enil m’búavul birembor ni o ti gálab. Ni baj firim fúᵽurul n’émit fuoh : « Aw uomme Añolom o nifaŋ me níbbolie ; ésumayom ᵽe ni aw yom. » ");
INSERT INTO bqj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yésu no náᵽullo me ni fuhay, o babajer símit butum ávi ni guñen (30). N’gujogol añil ala Susef. Gáu sipayol gufan maa gujow maa, újogum n’aĉila Susef bi to n’átiaril aamme Adam : Heli, ");
INSERT INTO bqj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat, Lévi, Meliki, Yanai, Susef, ");
INSERT INTO bqj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias, Amos, Naum, Esili, Nagai, ");
INSERT INTO bqj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat, Matatias, Semei, Susef, Yuda, ");
INSERT INTO bqj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoana, Resa, Sorobabel, Salatiel, Neri, ");
INSERT INTO bqj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Meliki, Adi, Kosam, Elimodam, Er, ");
INSERT INTO bqj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yose, Elieser, Yoreim, Matat, Lévi, ");
INSERT INTO bqj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simioŋ, Yuda, Susef, Yonan, Eleakim, ");
INSERT INTO bqj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleas, Mena, Matata, Natan, David, ");
INSERT INTO bqj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Yese, Obed, Boas, Sala, Naaĉon, ");
INSERT INTO bqj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab, Adumin, Aruni, Hesoron, Ᵽeres, Yuda, ");
INSERT INTO bqj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sakob, Isak, Aburaham, Tera, Nahor, ");
INSERT INTO bqj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sérug, Réu, Peleg, Eber, Ĉela, ");
INSERT INTO bqj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenan, Arupakaĉad, Sem, Nóe, Lameh, ");
INSERT INTO bqj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matuĉelah, Henok, Yered, Mahalalel, Kenan, ");
INSERT INTO bqj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Henok, Set, Adam, o Aláemit amundum me átul. ");
INSERT INTO bqj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","No Yésu áᵽureul me baubu Suruden, Biinum Banabe bo baĉiner ni o. M’bújaenumol mbaa gafit gace gámah ; ");
INSERT INTO bqj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","gunah úvi gúuba (40), Seytane n’élingen gáinen gagu gola n’Aláemit bi ekanol tima natil. Nemme gunah gaugu ᵽe atiñut, bieb m’bujogol nár. ");
INSERT INTO bqj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ñer Seytane naagol : « Iní me maagen aw uomme Añol Aláemit, uoh eval yauyu ébaho ganaĉ ! » ");
INSERT INTO bqj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yésu naagol : « Bahiĉer babu buoge : “Mitiñay bare miᵽilout bi buroŋ arafuhow.” » ");
INSERT INTO bqj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ᵽúrto, Seytane nájaenumol bi fatiya, nakanol naluj ñanur súsuh sasu ᵽe, ");
INSERT INTO bqj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","aban naagol : « Nujuge súsuh sausu ? Ᵽan iseni so ᵽe uogen ni ᵽoᵽ fubaj fafu faam dó me. So ᵽe, n’gañenom guhat so ; an o súmom me, nisenol so. ");
INSERT INTO bqj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Uya me gújul bújoŋorom, dáuru ᵽe ᵽan ní wafi. » ");
INSERT INTO bqj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yésu naagol : « Bahiĉer babu buoge : “Ᵽan uya gújul bújoŋor Aláemit aamme Atúlai, ban numigelet aĉila nevonol pat.” » ");
INSERT INTO bqj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seytane nabbañ ájaenumol bi Yérusalem, aĉih najingenol bi ró fatiya gávi-Aláemit ak’ailen ni fibil go fice, aban naagol : « Iní me maagen aw Añol Aláemit, úñag ᵽaa uk’uya n’ettam ; ");
INSERT INTO bqj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","leti Bahiĉer babu buoge : “Atúla ᵽan aboñ emalakaol gupoi.” ? ");
INSERT INTO bqj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Buoge ᵽoᵽ : “Ᵽan guyeni jambi guoli guteh n’eval.” » ");
INSERT INTO bqj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yésu naagol : « Bahiĉer babu buoge : “Jamb’urif Aláemit aamme Atúlai !” » ");
INSERT INTO bqj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","No Seytane ataj me ni Yésu iki mufaŋol, nahalol bo ᵽan. ");
INSERT INTO bqj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yésu nabbañ mbaa mof mamu maa Gálile ni sembe sasu ró saa Biinum Banabe, ban nauno aban babu ᵽe ni mof maumu. ");
INSERT INTO bqj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Náh’áᵽajulil Bahiĉer Gurim Aláemit ni saŋ sasu solil saa galaw, ban ésuh yay ᵽe nihi gumalenol. ");
INSERT INTO bqj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Funah fice, Yésu náffus Nasaret bo nahuri me. Funah fafu faa fíiyay, nanogen ni yaŋ yay yaa galaw ti naᵽi me nah’akan. No nailo me bi gajanga Bahiĉer Gurim Aláemit, ");
INSERT INTO bqj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","n’gusenol élebur yay yal aboñer ahu Esai. Nábboñul yo nalo to guhiĉ me gurim gauge : ");
INSERT INTO bqj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","« Biinum Atúla ubu n’ínje. Injé naĉobe bi egiten galeh me Firim fafu Fásum me. Naboñomboñ bi eoh gaamme ni fipeh : “Ᵽan jiᵽah !” Bi eoh ᵽoᵽ úpimaaw : “Ᵽan jibbañ jujuh !” Bugo gúlatiene me, ᵽan gúᵽur ni fujoh ; ");
INSERT INTO bqj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","naboñom bi egiten ésuh yay gannay gagu go Atúla ajae me egitenolal músumol. » ");
INSERT INTO bqj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","No naban me, nabboñ élebur yay abbañen aroka ahu ala ró, aban nanamo. Gamat me n’gúbahen gúĉilil ᵽe guya ni o. ");
INSERT INTO bqj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ñer nabbañ áarul aagil : « Gurim gauge go juun maa, funah fafu faa jama ti maagen gukanoe. » ");
INSERT INTO bqj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bugan bugagu ᵽe n’gúni n’egiten min guruhen me Yésu, n’gujahali nímoro gurim gaugu gásum mee gáᵽureul mee m’butumol, n’guogoro : « Leti dáuru áᵽur ahu ala Susef ? » ");
INSERT INTO bqj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nabbañ aagil : « Niffase búoh ᵽan julobom firim fafu faah me : “Uní me alah, úsotenoro ᵽaa fuhoi !” Ᵽan juogom may : “Juune gáilandiŋi gaa wo nukanno me baubu Kaᵽerinaum. Ukan mo may babe bo nubugi me !” » ");
INSERT INTO bqj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Natajen aagil : « Injé ilobul fo, ban maagen : aboñer ámusut aaleni súm ésugol. ");
INSERT INTO bqj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nífaro iogul : Elí o m’buroŋol, bajene utiña-sibara gammeŋe ni mof mamu maa Israel. Unnay wauwu émit yay elubut símit sífaji ni biremben, ban bieb bámah m’búloul dó ni mof mamu ᵽe ; ");
INSERT INTO bqj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","bare Atúla aboñut Elí bi n’ace ni waareaw ubugu, min til aboñol bi ni ace aare alet Asúif aĉine Sareputa, mof mice maam Sidoŋ. ");
INSERT INTO bqj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ᵽúrto, no aboñer ahu Elíse aamen me m’buroŋ, bajen dó may bugan gammeŋe bugo háhae ejogene ; bare bajut an ni bugo ayabe gahoy, íni let avasena ahu Naaman ala Siri. » ");
INSERT INTO bqj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gaam dó me ᵽe ni yaŋ yay yaa galaw, no guun me gurim gaugu, guiñil n’gutiñ faĉaw, ");
INSERT INTO bqj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","n’guilo manur gujogol gúᵽuren n’ésuh yay gújaenum iki gubaŋol ni fibil erijaŋ yay dó ésugil eteᵽi me, bi efakenol gúbenul. ");
INSERT INTO bqj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bare Yésu nágat n’etulil ajow akay. ");
INSERT INTO bqj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ᵽúrto, Yésu najow bi Kaᵽerinaum, ésuh yaam ni mof mamu maa Gálile. Funah fafu faa fíiyay, nanamo éᵽajul bugaa bo gurim Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Esúh yay n’gujahali baligenerol, mata gurimol gurim gom gal an ayabe sembe. ");
INSERT INTO bqj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ban bajen dó ni yaŋ yay yaa galaw ace áine o eseytane neh’ebet. Náᵽib aah : ");
INSERT INTO bqj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","« Wáy ! Yésu ala Nasaret, wa numaŋe ni wóli ? Nukelo jabanóli ? Niffase ay nom : aw uomme An ahu anab me o Aláemit aboñulo me. » ");
INSERT INTO bqj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yésu nannur eseytane yay aah : « Uᵽanor, ban n’úᵽur cab n’áine ahumu ! » Ñer neteb áine ahu ebet n’ettam bújoŋor ésuh yay ᵽe, eban néᵽur m’bakanutol mahojo. ");
INSERT INTO bqj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Gáholi n’gunonil bugo ᵽe iki nihi gurorenor guoh : « Dáru firim bu fom ? Ahumu ni sembe Aláemit nah’annur siseytane sasu, ni súᵽur ! » ");
INSERT INTO bqj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ñer gajaol n’gufaen guuno ni mof maumu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","No Yésu áᵽur me ni yaŋ yay yaa galaw, najow bi ni yaŋ Simoŋ. Aol Simoŋ aarema bújusa m’bibelol ; n’guroren Yésu ter nájue akan to waf uce. ");
INSERT INTO bqj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ñer Yésu nailo bíᵽimborol min annur bújusa babu, ban ni búᵽur to baenah ni o ; min ñer aare ahu anamo ecokoril. ");
INSERT INTO bqj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","No fíbiñu fafu fualo me, bugan bugagu ᵽe gaogen me úsota gabaje gásomut gánogan n’gutebulil bi ni Yésu. Ñer Yésu nagor ánoan ni bugo, ban n’guhoy bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Siseytane sasu sabele me gammeŋe ni bugo, ni súᵽur n’éᵽib ró suoh : « Aw Añol Aláemit om ! » Bare Yésu nah’annur so jambi sulob, mata so siffase búoh aĉila aamme Kirista ahu. ");
INSERT INTO bqj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tihalen fo m’bujom, náᵽur ajow ak’anamo tiñ talikoe. Ni baj fuyoŋ faa bugan gúni n’eŋesol. No gujugol me, n’gumaŋ gujogol jamb’akay. ");
INSERT INTO bqj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bare naagil : « Níarie ijow bi ni sasu súsuh ik’ivareil ᵽoᵽ Firim fafu Fásum me faa Jávi Aláemit, mata yauyu eteh me min Aláemit aboñulom. » ");
INSERT INTO bqj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ᵽúrto, nah’anogen ni saŋ sasu saa galaw saa mof mamu ᵽe maa Yúde min avareil. ");
INSERT INTO bqj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Funah fice, Yésu nailo n’galam fal fafu fáᵽurut me faa Genesaret. Fuyoŋ faa bugan ni fúgolol fúharo ni fíni n’eutten min áᵽajule me gurim Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Najuh to usana úuba galam fal fafu, bugala wo bayañer éavul dó min gúni n’eᵽos simbalil. ");
INSERT INTO bqj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yésu nájuᵽo ni bice ni wo, baamme baa Simoŋ, aban naagol : « Uhátulo ᵽaa jatiito ! » Mbiban, nanamo ró min áni n’gavare bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","No nalob me aban, naah Simoŋ : « Utos bi ni másikie mamu, aw ni gupali, n’jibet gumbalul ! » ");
INSERT INTO bqj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoŋ naagol : « Nuffase, jimbambal efuga yay ᵽe, ban jujogut hani juol. Bare nemme aw ulobom yo, ᵽan jibet go. » ");
INSERT INTO bqj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","N’gubet go. No guom go me n’eñah, n’gujoh ró suol faŋ iki gumbal gagu gúni n’eĉaĉo. ");
INSERT INTO bqj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","N’guvoh gupalil gaamme m’babu busana min gúkail gurambenil. No guĉilo me, n’gummeŋen usana waw waamme úuba uk’umaŋ étimo. ");
INSERT INTO bqj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","No Simoŋ Ᵽier ajuh me dáuru ᵽe, naya gújul bújoŋor Yésu naagol : « Uhátuloom, aw aamme afanom, mata ínje an atila nem. » ");
INSERT INTO bqj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Maagen mamu, Simoŋ ni gupalol gúñañag min gujoh mee suol sasu bajoger baubu. ");
INSERT INTO bqj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Guñol Sebede, Saak ni Saaŋ gátinenol me, bugo may gúñañag. Ñer Yésu naah Simoŋ : « Jamb’úholi ! Maer ᵽan úni ambala ala bugan. » ");
INSERT INTO bqj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ñer n’gúvenul usanail iki guya, guban n’guhat to wañil ᵽe n’gulagen Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Funah fice, Yésu o baamer n’ésuh ece, ni baj ace áine o háhae ehajene enilol ᵽe ájoul. No najuh me Yésu, náteil ak’alo bújoŋorol, naya fíringol n’ettam nalaol nímoro aah : « Ataw, umaŋ me, nújue ukanom nihoy ijañ ti no ! » ");
INSERT INTO bqj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ñer Yésu naalen gañenol agorol ban naagol : « Yoo, nimaŋe. Uhoy ujañ ! » To baenah, háhae yay néᵽur n’áine ahu. ");
INSERT INTO bqj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mbiban, Yésu naagol : « Jamb’ulob yo me ánoan, bare ᵽan umundum ujow bi n’ateŋena ahu min ajugi, mb’uban nukan bíteŋen babu bo gúboñ gagu gaa Móis gulob me, min ugiten ésuh yay búoh nuhohoy. » ");
INSERT INTO bqj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Min Yésu afaŋe me naunoe, mo bugan bugagu gújaeul me fuyoŋ iki gujoñor to ni o, bi euttenol ni ᵽoᵽ bi eŋes gahoy. ");
INSERT INTO bqj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ban Yésu néh’éni ñace nañago nevonol bi ni siᵽarandaŋ sasu min alaw bo. ");
INSERT INTO bqj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Funah fice, Yésu náni n’gavare ni yaŋ ece ; ni baj to Eᵽárisie ni úᵽajula gúboñ Aláemit gáᵽullo ni súsuh sasu ᵽe saa Gálile ni saa Yúde bi ni Yérusalem dó gamate. Sembe Aláemit ni síni ni Yésu mbi náh’áju akan bugan n’guhoy. ");
INSERT INTO bqj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ni baj guce gútebul ni gapeh an ájuut ejow. N’gumaŋen érurol iki gubaŋ bújoŋor Yésu, ");
INSERT INTO bqj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","bare gújuut mata fuyoŋ fafu fújalojalo. Ñer n’guhat min gujiŋ fatiya bimilum babu, n’gúhaful bo tice min gualen gapeh gagu dó ásota ahu aamme, bi ró bújoŋor Yésu n’etut bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","No Yésu ajuh me gáinen gaugu golil, naah ásota ahu : « Apalom, utili uboketiboket. » ");
INSERT INTO bqj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ñer úᵽajula gúboñ Aláemit bugagu bi ni Eᵽárisie yay ró n’guᵽinor guoh : « An ahumu, an bu om ajele mee Aláemit ? Arafuhow ay ájue aboket util an, íni let Aláemit bareol ? » ");
INSERT INTO bqj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nemme Yésu naffase gaᵽinoril, naagil : « Wa uĉile n’jibaj gaᵽinor ti gaugu ? ");
INSERT INTO bqj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Julobom ᵽaa, eoh abofoa ahu “Utili uboketiboket,” ter eogol “Uilo ujow,” wa ufaŋe ésum elob ? ");
INSERT INTO bqj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bare waf wanur nimaŋe jiffas : Añol Arafuhow nayayab babe ni mof sembe n’Aláemit sal eboket util waw waa bugan bugagu. » Naban nábaho mbal abofoa ahu naagol : « Injé ilobi yo, uilo nuŋar gapegi min uot bi yaŋi. » ");
INSERT INTO bqj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","To baenah, abofoa ahu nailo bújoŋor ésuh yay ᵽe, naŋar gapegol dó nafiyen me min akay n’esalen Aláemit nímoro. ");
INSERT INTO bqj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bugo ᵽe n’gujahali nár, ban n’gusalen Aláemit ; ni gáholiil n’guoh : « Jama nujugale waf wo nuunderutal. » ");
INSERT INTO bqj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ᵽúrto, Yésu náᵽurul n’ésuh yay. N’ejaol najuh ayaba-búalen ace gajaol Lévi arobo to nah’ayab bo me. Yésu naagol : « Ulagenom ! » ");
INSERT INTO bqj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ñer Lévi nailo ahat to wañol ᵽe min alagenol. ");
INSERT INTO bqj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mbiban, Lévi nakanol gaggan gámah súndool. Ni baj to gupalol uyaba-búalen gammeŋe, ni guce ᵽoᵽ gábulo, gakelo emat gaggan gaugu. ");
INSERT INTO bqj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bare Eᵽárisie yay ni úᵽajula gúboñ Aláemit bugagu súmutil n’guoh ulagora Yésu : « Wa uĉile nihi jitiñ n’jirem tiñ tanur n’uyaba-búalen bugagu ni bugagu utila ? » ");
INSERT INTO bqj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yésu naagil : « Let bugan bugagu gaamme apuñil guŋese ásotena, bare til úsotaaw. ");
INSERT INTO bqj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mo may, ijoulat bi eoh bugan bugagu gaĉol me mbi gúbahen bakaneril, bare til utilaaw. » ");
INSERT INTO bqj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ñer Eᵽárisie yay n’guoh Yésu : « Ulagora Saaŋ nihi guowor n’gulaw nímoro ti bugolóli. Bare búguiya, fitiñ ni marem barebare guom ni yo ! » ");
INSERT INTO bqj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yésu naagil : « Jíinene ᵽiaŋ búoh funah faa búyabo jújue jífiren bugan bugagu fitiñ, ayaba ahu o to ? Hani, júut ní me ! ");
INSERT INTO bqj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bare funah fice ᵽan fiĉigul no gujae me eram ayaba ahu n’guñenil ; no ñer ᵽan guor me. » ");
INSERT INTO bqj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bi éᵽajulil joon, Yésu naĉob búnogor baube naagil : « An nd’áᵽuren gaĉaĉ ni gájuo gavugul bi eteh gaᵽoroh n’gájuo gafan ; mata akan mo me, gavugul gagu guĉele, ban gaĉaĉ gagu mati gújahor ni gájuo gagu gafan gagu. ");
INSERT INTO bqj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","An nd’aoren ᵽoᵽ bunuh bijeb ni siĉan sifan aban natoj so ; akan mo me, bunuh babu ᵽan bufaĉ so min ñer so ᵽooso súbburi. ");
INSERT INTO bqj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bare til níh’íni mee nuoren bunuh babu bijeb babu ni siĉan sasu suvugul sasu. ");
INSERT INTO bqj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ban an o nah’arem bunuh bufan mat’amaŋ arem bunuh buvugul, mata ᵽan aah : “Bufan babu bufaŋe jáari.” » ");
INSERT INTO bqj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Funah fice faa fíiyay Esúif yay, Yésu ni ulagorol n’gúni n’esat ulah waw. Nihi gutujul gukoñ gagu gumoroj n’guñenil n’guŋar bakol babu guheŋ. ");
INSERT INTO bqj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ñer Eᵽárisie guce n’gúkail guogil : « Wa uĉile n’jikan mee ? Fírenifiren ekan dáuru ni funah ti faa jama. » ");
INSERT INTO bqj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yésu naagil : « Buru til júmusut jijanga wo David akan me funah fice no bieb bujogil me, o ni galageneol me ? ");
INSERT INTO bqj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Leti nanogenogen ni Fúggut Aláemit ák’áŋarul unaĉ waw ᵽe wo gúji ró me Aláemit agabor ni galageneol me, n’gutiñ ? Ban unaĉ wauwu uteŋenaaw bugo bareil guote gutiñ wo. » ");
INSERT INTO bqj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Natajen aagil : « Añol Arafuhow o aamme afan ahu ala fíiyay fafu fololal. » ");
INSERT INTO bqj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Funah fice faa may fíiyay, Yésu nanogen ni yaŋ yaa galaw ece min áni ró n’gavare. Ni baj ró ánaine ace ahaje ni gañenol gárib. ");
INSERT INTO bqj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ñer úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay n’gúni n’elujor Yésu ter ᵽan akan an nahoy funah faufu faamme faa fíiyay, mata gumamaŋ ebaj waa mbi gújogumol me ni wo. ");
INSERT INTO bqj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nemme Yésu naffase gaᵽinoril, naah áine ahu ala gañen gagu : « Uiyul bi tale n’etut ! » Aíne ahu naiyul ti nalobol me. ");
INSERT INTO bqj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ñer Yésu naagil : « Ban irorenul waf wauwe : Wa nuotale ukanal funah faa fíiyay ? Maaro, ter maarat ? Eᵽagen buroŋ an, ter enemen bo ? » ");
INSERT INTO bqj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nailo alujil anur-anur, aban naah ala gañen gagu : « Uraw ᵽaa gañeni ! » Naraw go, ban n’guhoy to baenah. ");
INSERT INTO bqj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ñer úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay guiñil n’gutiñ min gúni ni síceŋor bu gujae me eilo bi ni o. ");
INSERT INTO bqj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mb’uĉiga funah fice, Yésu nak’ajiŋ fatiya firijaŋ min áni ró n’galaw. Nanamo ró galaw Aláemit efuga yay lám. ");
INSERT INTO bqj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","No tihalen me, návogul ulagorol min aĉob ni bugo bugan guñen ni gúuba (12), aban nakanil gajow gagu gaa uᵽotora. ");
INSERT INTO bqj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bugo guomme : Simoŋ o natajen me avoh Ᵽier, ni atiol Andere ; Saak ni Saaŋ ; Fílip ni Barutelemi ; ");
INSERT INTO bqj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mácie ni Toma ; Saak añol Alife ni Simoŋ, atigena ahu ; ");
INSERT INTO bqj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda añol Saak ni Yudas Isikariot ajae me ennomen Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ᵽúrto, Yésu náavul ni firijaŋ fafu manur n’uᵽotoraol, ák’áelo tiñ taree heb. Ni bajen to ᵽoᵽ ulagorol gammeŋe ni fítiman fámah faa bugan gáᵽullo Yúde bi ni Yérusalem dó, ni may ulam waw waa Tir ni Sidoŋ, saamme súsuh saa galam fal fámah. ");
INSERT INTO bqj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bugan bugaubugu gujoulojow bi eutten Yésu ni ᵽoᵽ eliᵽ gahoy gal úsomulil. Bugo siseytane suyogene me, nakanil may n’guhoy. ");
INSERT INTO bqj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Anóan ni fuyoŋ fafu nalih bi egorol, mata babaj sembe sáᵽureul ni o. Ban maagen mamu nakanil n’guhoy bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ñer Yésu naluj ulagorol aluj naagil : « Gásumay gúni ni buru jaleh me, mata Jávi Aláemit jolul jom. ");
INSERT INTO bqj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gásumay gúni ni buru jacaret me maer, mata gajem ᵽan jibaj fupoñ fámah. Gásumay gúni ni buru jaamme n’ukoŋ jama, mata gajem ᵽan jibebberor. ");
INSERT INTO bqj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Gásumay gúni ni buru, no bugan bugagu gujaeul me elat, eham, ejel, émeñ, min jíinen me ni Añol Arafuhow. ");
INSERT INTO bqj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mbi jísangor dáuru baĉigerul, ban n’jíñagor n’ésumay ró, mata bacam bámah ubu bo m’bunageul fatiya n’émit. Maagen mamu, sipail gufan may maumu gúlatien mee may uboñer waw bugal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bare til mataño mbi míni ni buru jasanumet me, mata jiyabe basaforul jiban. ");
INSERT INTO bqj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mataño mbi míni ni buru jaamme ni fupoñ maer, mata ᵽan jíbbañul jicaret. Mataño mbi míni ni buru jaamme n’eber jama, mata gajem ᵽan jiĉagor n’ukoŋ ró. ");
INSERT INTO bqj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mataño mbi míni ni buru, no ésuh yay ᵽe gujaeul me esalen. Maagen mamu, sipail gufan maumu gukanen mee n’uboñer waw galet me uboñer gúfuh. » ");
INSERT INTO bqj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","« Buru jaamme n’euttenom, ínje umu n’elobul firim fe : Júbboli ulatorul ! Jikan maaro bugan bugagu galaleul me, ");
INSERT INTO bqj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","júsonien bugagu gatabeul me, ban n’jilaw ᵽoᵽ bi mala bugagu gálatieneul me ! ");
INSERT INTO bqj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","An ategi me ni garab, nusenol gáutten. An aram me gaᵽalitoŋi, nuhalol ᵽoᵽ naŋar gájuoi. ");
INSERT INTO bqj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Anóan ácini me waf, nusenol. An aŋar me wafi, jamb’urondopenol nabbañeni wo. ");
INSERT INTO bqj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mbi jikan nánonan bi ni bugagu ti jimaŋ me gukan bi ni buru. ");
INSERT INTO bqj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Iní me buru bi emaŋ gamaŋeul me bare, ñer enah bacam bice bi wa ? Hani gatile me nihi gumamaŋ gupalil. ");
INSERT INTO bqj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iní me buru bi ekan maaro bi ni bugagu gakaneul mo me, ñer enah bacam bice bi wa ? Gatile me gukanekan ti buru. ");
INSERT INTO bqj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iní me buru bi emagen bugagu bugo jíinen me búoh ᵽan gubbañenul, ñer enah bacam bice bi wa ? Gatile me gumagoremagor may, ban ᵽan gubbañenor umagil bi to. ");
INSERT INTO bqj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Niege til : Mbi júbboli ulatorul, jikanil maaro, ban n’jimagenil wáfowaf buru m’babajut gaᵽinor gal ebbañenulul wo ; mamu ᵽan jibaj bacam bámah. Ban ᵽan jíni guñol Aláemit-Fatiya, mata aĉila may maumu násum mee ni bugan bugagu galujérit me an bi ni gáĉelet me ró. ");
INSERT INTO bqj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mbi júju ñarum enil, ti Ᵽayul áju me ñarum enil. » ");
INSERT INTO bqj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","« Jambi jujogoro utaliŋa bugan, mamu may Aláemit mat’ataliŋul. Jambi jujoh bugan ni guiñ, mamu may Aláemit mat’ajogul ni fiiñ. Juboket bugan, mamu may Aláemit ᵽan aboketul. ");
INSERT INTO bqj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mbi nihi júᵽuren jisen, mamu may Aláemit ᵽan asenul. Maagen, ᵽan aligul gacoᵽ gaĉikiĉik iki gupus áulenul júluh, mata galigum gagu go jijae me eŋar n’jiligil, go may ᵽan aligumul me ni go. » ");
INSERT INTO bqj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mbiban, Yésu naŋar búnogor baube bi éᵽajulil naagil : « An ápipim nájue ᵽiaŋ áĉibben apalol ápima ? Leti bugo éubail ᵽan gulo ni gasun ? ");
INSERT INTO bqj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Bajut aligena afaŋe afanol aligeneol me, bare aligena ánoan no najae me eban, ᵽan are ni afanol. ");
INSERT INTO bqj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Wa uĉile núni n’eluj jikaw jaju jalo me n’jíĉil atii, min til ulet n’étallo fusos fafu faamme ni jíya ? ");
INSERT INTO bqj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bu nújue uoh atii : “Atiom, unah níᵽunni jikaw jaju jaamme n’jíĉili !” Aw m’bátallout fusos fafu faamme n’jíya ? Aᵽula-elob e ! Umundum ᵽan úᵽuren fusos fafu faamme n’jíĉili, mamu, ᵽan ujuh ŋanno bi éᵽuren jikaw jaju jaamme n’jíĉil atii. » ");
INSERT INTO bqj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","« Bununuh baaro ndi bubuh mitiñ maarat, ti may bununuh baarat ndi bubuh me mitiñ máariari. ");
INSERT INTO bqj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bununuh bánoban ni mitiñ bo buffasei : an ámusut ábajul gumangu ni bukoho, ban ᵽoᵽ an ámusut ábajul gueĉ ni bindikit. ");
INSERT INTO bqj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An aaro náh’áᵽureᵽuren máarie mamu maamme ni biinumol agiten ésuh yay ; bare aarat me, o, máhojie mamu maamme ni biinumol náh’áᵽuren agiten ésuh yay. Maagen mamu, ánoan wammeŋen me biinumol butumol ni’búᵽuren bulob. » ");
INSERT INTO bqj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","« Wa uĉile nihi juvogom “Ataw, Ataw,” ban jilet n’ekan wo nilobeul me ? ");
INSERT INTO bqj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","An ájoul me bi n’ínje ákail autten firimom ban nakan wo fulob me, an ahumu ban igitenul bu nanogore : ");
INSERT INTO bqj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nanogonogor ti an aoge síki min áteᵽul dó yaŋol. Yaŋ ti yauyu, fal fafu fo bámmeŋerul iki fuya ni yo, mati fúju fibet yo, mata naowoh síki balama ateᵽ yo. ");
INSERT INTO bqj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bare til an auttenom me ban mat’akan wo firimom fulob me, an ahumu nanogonogor ti an ateᵽe yaŋol fatiya eus yay o m’baogut. Yaŋ ti yauyu, fal fafu fo bámmeŋerul iki fuya ni yo, ᵽan fufaken yo to baenah fibet evisor ᵽooyo. » ");
INSERT INTO bqj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","No Yésu alob me ni fuyoŋ fafu aban, nakay mbaa Kaᵽerinaum. ");
INSERT INTO bqj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ni baj bo afan ekosombil ace alet Asúif abaj amigel o namaŋe nár ; ban amigel ahumu násomut ak’amaŋ eĉet. ");
INSERT INTO bqj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","No afan ekosombil yay aun me gulob mala Yésu, naboñ ufan Esúif guce bi n’aĉila bi elaol tima naboket ájoul íkiil akan amigelol nahoy. ");
INSERT INTO bqj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","No guĉih me, n’gúni n’ehehorol n’guogol : « An ahumu naᵽiloe min mb’urambenol, ");
INSERT INTO bqj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mata namamaŋ wolal Esúif yay mámah, ban aĉila aĉil me min yaŋ yay yóloli yaa galaw eteᵽi. » ");
INSERT INTO bqj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ñer Yésu nalagenil mbaa bo. No guomme n’elof yaŋ yay, afan ekosombil yay náboñul ubugeol guce iki guogol : « Ataw, jamb’uyoh n’énonul, mata iᵽilout min mb’unogen ni yaŋom. ");
INSERT INTO bqj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yo eĉil me ikañenut íjoul ínje faŋaom íkiil ijoŋor n’aw. Bare mb’ulob firim fanur pat min amigelom ahoy. ");
INSERT INTO bqj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nuffase, ínje faŋaom nibaje ufanom bugo níh’íttun, ti ᵽoᵽ ekosombil yay gaamme ni gañenom gúttuneom me. Ioh me an ni bugo : “Ujow !” Najow ; ioh me ᵽoᵽ ahu : “Ujóul !” Nájoul ; ioh me arokaom : “Ukan waf uman !” Nakan wo. » ");
INSERT INTO bqj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","No Yésu aun me gahoŋen gaugu, naruhen afan ekosombil yay bireg nábaho bi ni fuyoŋ fafu falageneol me naagil : « Maagen ínje ilobul yo, Israel ᵽooyo ímusut ijuh ró an o gáinenol gújaloe ti gal áine ahume. » ");
INSERT INTO bqj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","No bugaa gahoŋen gagu gubbañ me guĉih súndo, n’gutoh amigel ahu o bahoer. ");
INSERT INTO bqj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ᵽúrto, Yésu najow mbal ésuh ece gajow yo Nain, ban ulagorol ni fuyoŋ fámah n’gútinenol. ");
INSERT INTO bqj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","No naamme n’enogen n’ésuh yay, najugil gútebul efuluŋ bi eke gafoh tíyaŋ ; kan érimbani yom yal atiña-ebara ace. Bugal ésugol gammeŋe n’gútinenol ake gafoh añolol. ");
INSERT INTO bqj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","No Ataw Yésu ajuh me aare ahu, enilol nerumol naagol : « Jamb’ukoŋ. » ");
INSERT INTO bqj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aban najow ak’alof buhogen babu min agor bo. Gaamme n’eteb bo n’guilen. Yésu naah áᵽur ahu aĉet me : « Aᵽúr ahu, niegi uilo ! » ");
INSERT INTO bqj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ñer áᵽur ahu nailo arobo, aban náni n’elob. Min Yésu aŋarol ak’asen jaol. ");
INSERT INTO bqj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ñer gáholi n’gunonil ᵽe, n’gusalen Aláemit guoh : « Dáuru aboñer ámah áᵽullo maa n’etulolal. » N’gubbañ guoh : « Aláemit nakelo eᵽagen ésugol, wolal bugo naĉob me. » ");
INSERT INTO bqj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Elob yay neuno ni mof mamu ᵽe maa Yúde ek’efa bo bi ni sasu súsuh ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ban ulagora Saaŋ Batis n’gugitenol dáuru ᵽe. Ñer navoh bugan gúuba ni bugo, ");
INSERT INTO bqj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aban naboñil bi ni Ataw ni suroren sause ró : « Aw uomme an ahu aat me ájoul, ter juote jiirigen ace ábulo ? » ");
INSERT INTO bqj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","No guĉih to me ni Yésu, n’guogol : « Saaŋ Batis aboñulóli bi eroreni : Aw uomme an ahu aat me ájoul, ter juote jiirigen ace ábulo ? » ");
INSERT INTO bqj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tinah tautu Yésu o bánier n’ekan bugan gammeŋe n’guhoy n’úsomulil, náᵽuren ñatiñil, naᵽagen bugaa siseytane sasu, ban nakan úpima gammeŋe n’gujuh. ");
INSERT INTO bqj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ñer nábal bugaa gahoŋen gagu naagil : « Jujow iki jigiten Saaŋ wo jujuh me ni ᵽoᵽ wo juun me : gápim me gubbañe gujuh, gahaj me gujae ĉol, bugaa háhae yay guyabe gahoy, gatopo me gútopuloe, gaĉet me guiloe gubbañ guroŋ, gásugateno me guyabe Firim fafu Fásum me fal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gásumay gúni ni an ahu o bakanerom biĉilut me min ahabo gáinen gagu gola n’ínje ! » ");
INSERT INTO bqj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","No uboñer waw bugaa Saaŋ Batis gubbañ me, Yésu nanamo egiten fítiman fafu maa Saaŋ ahumu. Naagil : « Wa jikaene faluj baubu n’eᵽarandaŋ yay ? Fisisit ᵽiaŋ fo érus yay élisene ? ");
INSERT INTO bqj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ñer wa jikaen bo faluj ? Anáine ᵽiaŋ asimoe wañ ujaha ? Bare hum gasimoe me wañ ujaha ban n’gukan bugan gabaje, bugo ni saŋ úviaw gom ! ");
INSERT INTO bqj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ñer joon, wa jikaen bo faluj ? Aboñer ᵽiaŋ ? Ey, aĉila, ban ínje ilobul yo, fafaŋ sah aboñer. ");
INSERT INTO bqj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","O aamme an ahu o Bahiĉer Aláemit bulob mee mola buoh : “Ᵽan iboñ ájaenumaom gahoŋen ayabi gayoŋ min mb’ateŋen bulago babu bi n’aw.” » ");
INSERT INTO bqj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yésu natajen aagil : « Maagen, ínje ilobul yo : ni bugan bugagu ᵽe gabugi me babe ni mof, Saaŋ Batis afaŋil me ᵽe. Bare afaŋ me gatiti ni Jávi Aláemit, o nafaŋe Saaŋ fúf. » ");
INSERT INTO bqj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Esúh yay ᵽe gauttene me Saaŋ, bi ni uyaba-búalen bugagu ró, n’guraŋen maagen Aláemit, min gujow ák’ábatiseil. ");
INSERT INTO bqj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bare Eᵽárisie yay ni úᵽajula gúboñ Aláemit bugagu n’guceŋ gaᵽagen gagu go Aláemit amaŋen me bi ni bugo, min gulat Saaŋ ábatiseil. ");
INSERT INTO bqj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yésu nabbañ aagil : « Ni wa ᵽan ᵽiaŋ iligor me bugan bugagu bugaa jabbah je ? Ni wa ᵽiaŋ gunogore ? ");
INSERT INTO bqj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gúnini ti uñil garove to ésuh yay ni’guomunor me, min gúni m’búogor nihi guoh : “Uŋeh juogul mee, jimaŋut eboh ; mbi júfoñul ufuluŋ, n’jilat ukoŋ.” ");
INSERT INTO bqj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Maagen, Saaŋ Batis najoulo, nd’atiñ mitiñolal, nd’arem ᵽoᵽ eremolal, ban juoge eseytane enonol. ");
INSERT INTO bqj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Añol Arafuhow najoulo, nah’atiñ narem ban bugan bugagu n’guoh : “Jujugom sum áine ahumu : gaᵽinorol ᵽe fitiñ ni marem barebare, ni ᵽoᵽ ejaor n’utilaaw ni uyaba-búalen bugagu !” ");
INSERT INTO bqj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bare Malillo mamu mal Aláemit migitenigiten ĉol ni waf waw wo bugan bugagu gabaj mo me gukane me. » ");
INSERT INTO bqj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Funah fice, Aᵽárisie ace naah Yésu ak’atiñ yaŋol. No Yésu aĉih me bi fitiñ fafu, nanamo auloulo ti guᵽi me nihi gukan bugo ni fitiñ. ");
INSERT INTO bqj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ni baj dó n’ésuh yauyu ace aare o gajaol guhajene. No naun me búoh Yésu umu ni yaŋ Aᵽárisie ahumu, nájoul ni jibara ró jammeŋe míĉir. ");
INSERT INTO bqj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nak’ailo búsol Yésu nah’akoŋ iki mufuol nihi musot mulo n’guot Yésu. Ñer naŋar walol min áti go, aban nacot go ; mbiban, náĉir go míĉir mamu. ");
INSERT INTO bqj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aᵽárisie ahu avoh me Yésu fitiñ, no najuh me bakaner aare ahu, naah m’biinumol : « Iníen me áine ahumu aboñer om, ᵽan affasen aare ahumu agoreol mee an bu om : ᵽan affasen búoh ejobu yom. » ");
INSERT INTO bqj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ñer Yésu nábaho bi ni o naagol : « Simoŋ, nibaje waf wal elobi. » Naagol : « Yoo, ulob ! » ");
INSERT INTO bqj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yésu naagol : « Baje wáine gúuba gaogene síralam ace áine o nah’amagen. Atíar ahu naogenol súuli ekeme (100.000), ahu súuli guñen (50.000). ");
INSERT INTO bqj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","No bulugen babu biĉilo me, bugo éubail gújuut gucam. Ñer amagena ahu naboketil uneil bugo ᵽooil. Ban iroreni ñer : Ay ni bugo ajae me efaŋ namaŋol ? » ");
INSERT INTO bqj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoŋ naagol : « Níinene, o gamagol gufaŋ me n’gújaloe, ban n’guboketol go. » Yésu naagol : « Nulobe jon. » ");
INSERT INTO bqj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aban nábaho mbal aare ahu min aah Simoŋ : « Nujuge aare ahume ? No ninonulo me yaŋi, usenutom mal niᵽos guolom ; bare aĉila ni mufuol naᵽose guolom, aban naŋar walol náti go. ");
INSERT INTO bqj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aw ucolutom, bare aĉila, kábiriŋ no ninonulo me yaŋi bi maer, ahalut ecot guolom. ");
INSERT INTO bqj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aw úĉirut fuhoom hani édunen yafulut me, bare til aĉila náĉire guolom míĉir. ");
INSERT INTO bqj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yo eĉil me niegi : Utilol wammeŋ mee uboketi, yo eĉilol maa egiten gamaŋol gájalo mee. Bare an o gubokete jatiito, gamaŋ gatiito may nagitene. » ");
INSERT INTO bqj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aban naah aare ahu : « Utili uboketiboket. » ");
INSERT INTO bqj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Gaamen to me ni fitiñ manur n’aĉila n’guoh n’uinumil : « An bu om me umu, akañen mee gaboket util bugan ? » ");
INSERT INTO bqj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bare Yésu natajen aah aare ahu : « Gáineni guᵽageni ; ujow n’gásumay ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ᵽúrto, Yésu nah’ajow súsuh sasu ᵽooso, bi ni saa m’baha ró, nah’avare bo Firim fafu Fásum me faa Jávi Aláemit. Uᵽotoraol gaamme guñen ni gúuba n’gújaor ni o. ");
INSERT INTO bqj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ni baj ᵽoᵽ waare guman gunaᵽil, bugo naham me siseytaneil, ni bugo nakan me n’guhoy n’úsomulil. Bugo guomme Mari o guvoge me Mari ala Magudala, o naham me ni o siseytane futoh ni súuba, ");
INSERT INTO bqj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni Yoana aar Husa aamme aroka ámah ala Herod, áfatten gajaol Susan, ni ᵽoᵽ guce gammeŋe. Waareaw ubugi nihi gúᵽuren síralamil bi eramben Yésu ni uᵽotoraol. ");
INSERT INTO bqj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Funah fice, bugan bugagu gáᵽureul me ni súsuh sasu ᵽe n’gúkail bi ni Yésu gukan to fítiman fámah. Naŋar búnogor baube naagil : ");
INSERT INTO bqj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","« Juutten ! Baje abela-euh ace áᵽullo bi eke ebet euh. O n’ebet euh yay, eceyo nelo n’galam bulago ; bugan bugagu n’guhah yo, upu waw n’utiñ yo nímoro. ");
INSERT INTO bqj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yayu nelo tiñ tabaje sival ; no eil me, nellab, mata tiñ tautu túgufut. ");
INSERT INTO bqj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yayuyo nelo tiñ tabaje sijeŋ ; ni siilor mimanur, ban sijeŋ sasu ni súnumen euh yay. ");
INSERT INTO bqj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eceyo, yo nelo ni mof máarie. No eil me, nebugor nár, gahager ganur n’gubaj wono ekeme. » Mbiban, Yésu nalob fatiya aah : « An abaj me gunnu gal eun, aun ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ñer ulagorol n’gurorenol : « Búnogor baubu, wa bumaŋe éᵽajul ? » ");
INSERT INTO bqj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naagil : « Buru Aláemit nájiulji min júju jujoh firim fafu faa Jáviol fásiki mee ; bare bugagu, n’únogor nih’ilobil fo. Yo eĉil me, nihi guluj bare mati gujuh ; nihi guun bare mati gujoh. » ");
INSERT INTO bqj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aban naagil : « Búnogor baube, maa bumaŋe elob : Eugit yay, yo eomme firim Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Guce gaun fo me, gúnini ti bulago babu dó eugit yay elo me : ᵽan guutten fo, mbiban Seytane nájoul ákail áᵽuren fo n’uinumil jambi gúinen ; mamu mati gúju gubaj gaᵽagen gagu. ");
INSERT INTO bqj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bugagu uuttena gúnini ti tiñ talu tabaj me sival : ᵽan guutten fo n’guyab fo n’ésumay ró ; bare fiilut guar ni bugo. Ᵽan gúinen maa, mbi guke élam jatiito, n’gubelen gáinenil. ");
INSERT INTO bqj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bugaguil bugo gúnini ti tiñ talu taa sijeŋ : ᵽan guun fo, bare gaᵽinor, fubaj ni másume mamu maa buroŋ ni súnumen fo min ñer eugit yay mat’éju ebuh mitiñ iki mual. ");
INSERT INTO bqj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bugaguil gúnini ti tiñ talu táari me : Guun me firim fafu, ᵽan guyab fo gubaŋ n’uinumil wakur mee ban n’úari, min nihi gúŋarul ni buroŋil waf waaro. » ");
INSERT INTO bqj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yésu natajen aagil : « An asaen me ejaŋa, let bi érur yo ñáraru elaᵽ ter fattam bura ; ᵽan til aremben yo n’ebamba, min mbi bugan bugagu gánoneul me gúju gujuh gajaŋa gagu gala yo. ");
INSERT INTO bqj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Maagen, wáfowaf wakoᵽeni ᵽan ujugi. Wáfowaf waffasuti ᵽan uffasi, mata ᵽan úᵽurul ni maŋannoe. ");
INSERT INTO bqj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jíkanum faŋ bu nihi juutten me ! Mata an abaj to me waf, ᵽan ayab faŋ to ; bare an abajut me, ᵽan guramol ᵽe bi ni jo naᵽinor me búoh nabajjobaj ró. » ");
INSERT INTO bqj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ᵽúrto, jaw Yésu ni gutiol n’gújoul bi bujugol ; bare gújuut gúffus to naamme mala fítiman fafu fágolol mee fúharo. ");
INSERT INTO bqj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ñer n’guboñ guogol : « Uutten ᵽaa, jai ni gutii ubugi tíyaŋ, aw gumaŋe bujuh. » ");
INSERT INTO bqj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bare Yésu naah : « Jaom ni gutiom faŋ, bugo guomme gauttene me firim Aláemit ban nihi gúttun fo. » ");
INSERT INTO bqj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Funah fice, Yésu o baamer galam fal fafu fáᵽurut me faa Genesaret, naŋar busana min ájuᵽo ró, o ni ulagorol. Aban naagil : « Utíᵽal uloal ñagagu ! » Ñer n’gukay. ");
INSERT INTO bqj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bugo n’étiᵽ yay, Yésu nayabor. Ᵽiout, fúrus fámah ni fiiyulil ; fal fafu ni fiteh iki busana babu nihi bíij, ñer ulagorol n’gúholi nár ");
INSERT INTO bqj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","n’gulof Yésu min gúliol n’éᵽib ró n’guogol : « Afanóli, afanóli, wolal ubugi n’gabao ! » Yésu nálio nailo annur fúrus fafu ni gulongos gagu. Ñer fal fafu ni fúbbañul fíjebi yem. ");
INSERT INTO bqj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mbiban, nábaho mbal ulagorol naagil : « Gáinenul ugelo ? » N’gúholi, ban n’gujahali faŋ bireg n’guogoro : « An bu om umu ? Nah’alob ni gúrus gagu ni gulongos gagu, ban ni síkanumol ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","No gútiᵽ me fal fafu guban, Yésu ni ulagorol n’guĉih ni mof mamu maa Gerugesa, máᵽimbor me Gálile. ");
INSERT INTO bqj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","No Yésu aavulo me ni busana babu, ace áine ala ró ésuh yay nájoul bi etogol to. Aíne ahumu siseytane suom ni o. Ᵽio bo no nahale bisimo ; abbañut aĉin ni yaŋ, n’guyah náh’ámori. ");
INSERT INTO bqj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ñammeŋe eseytane yay neh’ebelolbet ; yo eĉil me nihi guŋar ñisel min gujek guñenol ni guolol jamb’ake ban. Bare áine ahu ᵽan asaren ñisel ñañu, mbiban eseytane yay néjaenumol bi tiñ taa gafit. No najuh me Yésu, nalo to n’guolol náᵽib nímoro aah fatiya : « Yésu, Añol Aláemit-Fatiya, wa numaŋe n’ínje ? Nilai jamb’úlamenom ! » Nalob mee mata Yésu nannunur eseytane yay min éᵽur ni o. ");
INSERT INTO bqj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mbiban, Yésu naah áine ahu : « Gajai bu ? » Naagol : « Gajaom Fítiman. » Nalob mee mata siseytane sammeŋe suom ni o. ");
INSERT INTO bqj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ñer ni siilo sufotenor bújoŋor Yésu ni suogol aboket jamb’abelen so ni gasun gagu gal élatien siseytane sasu. ");
INSERT INTO bqj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nemme bajen to ekore yámah yaa suhumba saam ni gafen ni firijaŋ fafu, siseytane sasu ni sufotenor suoh Yésu ahat so ni sunogen ni suhumba sausu. Yésu namaŋ. ");
INSERT INTO bqj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ñer ni súᵽurul n’áine ahu sunogen ni so, min ekore yay ᵽe éᵽaᵽoul dó fitey fatiya mavaŋoe firijaŋ fafu ek’elo ni fal fafu, min enemo ró. ");
INSERT INTO bqj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","No ukoña suhumba sasu gujuh me dáuru, n’gúᵽur gutey bi n’ésuh yay guke egiten wabaj me, n’gúᵽur to ᵽoᵽ bi ni sasu súsuh salof yo me. ");
INSERT INTO bqj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bugan bugagu n’gúteil gúkail bujuh wabaj me. No guĉilo me to Yésu aamme, n’gutoh to áine ahu o siseytane sasu suomen me ni o, anamo to n’guolol so báᵽurer ; maer umu nasimoe, apuñol jas. Ñer gáholi n’gunonil. ");
INSERT INTO bqj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bugagu gajuh yo me táh n’gúni n’egiten gupalil bu áine ahu ala siseytane sasu abbanno me ahoy. ");
INSERT INTO bqj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ñer bugan bugagu ᵽe bugala ró Gerugesa n’guoh Yésu aboket ajow áraliil, mata maagen mamu gúholiholi faŋ. Min Yésu ájuᵽo ni busana babu bi ebbañ. ");
INSERT INTO bqj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aíne ahu o Yésu aham me siseytaneol, nafotenor naagol aboket ahalol najow n’aĉila. Bare Yésu naceŋol naagol : ");
INSERT INTO bqj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","« Ubbañ mbaa yaŋi, mb’uĉih nugitenil wo Aláemit akan me ᵽe bi n’aw ! » Ñer áine ahu naot, mb’aĉih nagiten n’ésuh yay ᵽe wo Yésu akanol me. ");
INSERT INTO bqj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","No Yésu abbanno me ñagagu, fítiman fámah faa bugan gaamenol bo n’enah ni fuyabol. ");
INSERT INTO bqj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ni baj ánaine ace ájoul, gajaol Yairus ; aĉila afan yaŋ yaa galaw nam. Aíne ahumu nalo to n’guot Yésu naagol aboket ajow bi yaŋol, ");
INSERT INTO bqj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mata érimbani bájur nabaje aam n’eĉet, símilol guñen ni súuba. No guomme n’ejow yay, fítiman fafu ni fúgot Yésu ak’amaŋ emig. ");
INSERT INTO bqj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bajen to ᵽoᵽ anaare ásomute ; símit guñen ni súuba o n’ébbur físimol. Nabelene síralamol ᵽe n’úsotena waw, bare an ájuut akanol nahoy. ");
INSERT INTO bqj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aare ahumu nábosul búsol Yésu, mbiban nagor gáñin bisimool. To baenah nahoy. ");
INSERT INTO bqj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ñer Yésu narorenil : « Ay agorom ? » Min guceŋol mee ᵽe, Ᵽier naagol : « Afanóli, let nujuge jammeŋ jauje jágoli maa jíharo ? » ");
INSERT INTO bqj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bare Yésu naagol : « Baje bae an agorom, mata babaj sembe sáᵽure n’ínje. » ");
INSERT INTO bqj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","No aare ahu ajuh me búoh ájuut akoᵽ atajen, nájoul ákail alo to n’guot Yésu n’etelenor dó. Nailo agiten bújoŋor ésuh yay ᵽe waĉil me nákail agor Yésu, ni ᵽoᵽ bu nahoy me to baenah. ");
INSERT INTO bqj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ñer Yésu naagol : « Bájurom, gáineni go guĉili nuhoy. Ujow n’gásumay ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","O m’babanerut elob, ni baj an áᵽullo yaŋ afan yaŋ yay yaa galaw ákail aagol : « Yairus, bájuri naĉele. Jamb’uyogen afan ahu utajen ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nemme Yésu naune min alob mee, nábaho aah Yairus : « Jamb’úholi, úinen barebare, bájuri ᵽan aᵽah ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","No guĉih me ni yaŋ yay, Yésu náfiren ésuh yay enogen, iki ᵽúrdo Ᵽier, Saaŋ, Saak ni ᵽayma bugo ni jawma. ");
INSERT INTO bqj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","N’gutoh bugan bugagu ᵽe n’ukoŋ mala eĉet bájur babu. Yésu naagil : « Jambi jukoŋ, aĉelut. Námorimori. » ");
INSERT INTO bqj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ñer n’guilo gúfohulorol mata guffase búoh bájur babu naĉeĉet ti maagen. ");
INSERT INTO bqj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bare Yésu najoh bájur babu ni gañen naagol : « Bájurom, uilo ! » ");
INSERT INTO bqj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","To baenah nábbañul m’buroŋ, ban nafaen ailo. Ñer Yésu naagil gusenol atiñ. ");
INSERT INTO bqj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ubugaol n’gujahali faŋ. Bare Yésu naĉafil naagil jambi gugiten me an wabaj me. ");
INSERT INTO bqj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ᵽúrto, Yésu naomen uᵽotoraol gaamme guñen ni gúuba, aban nasenil sembe ni gakañen sal éᵽuren siseytane sasu ni ᵽoᵽ sal éᵽuren úsomut waw. ");
INSERT INTO bqj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mbiban naboñil guke egiten Firim fafu Fásum me faa Jávi Aláemit, ni ᵽoᵽ esen gásomut me gahoy. ");
INSERT INTO bqj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naagil : « Jambi jíjaenum wáfowaf buru n’ejow : let egol, let baet, let mitiñay, let síralam, ban ánoan ni buru jamb’aŋar bisimo búutten. ");
INSERT INTO bqj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tánotan to gujaeul me ealen, n’jinamo ni yaŋ yay bi no jijae me éᵽur to. ");
INSERT INTO bqj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bare tiñ to gujae me elat eannul, n’júᵽur n’ésuh yauyu ; n’ejaul mbi jiᵽaᵽ gulaul : dó ᵽan níme baĉaf babu bolil. » ");
INSERT INTO bqj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ñer n’gukay. Maagen nihi gujow ésuh bi n’ésuh, n’gugiten tánotan Firim fafu Fásum me faa Jávi Aláemit, n’gusen ᵽoᵽ gásomut me gahoy. ");
INSERT INTO bqj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ᵽiout, Herod aogen me mof mamu maa Gálile, naun walobei me ᵽee. Nah’aᵽinor, mat’ajoh. Baje gaage Saaŋ Batis aiyulo ni gaĉet me ; ");
INSERT INTO bqj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bugagu n’guoh Elí om, guceil bugo n’guoh, ace n’uboñer waw bugaa no, o abbanno. ");
INSERT INTO bqj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bare aĉila Herod nah’aah : « Saaŋ Batis, nibomboñ guᵽikol fuhow. Ñer áine ahumu o gulobeom maa mola, ay om ? » Ñer naŋes bi bujuh Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","No uᵽotoraaw gubbanno me, n’guilo gugiten Yésu wo gukan me ᵽe. Ñer Yésu naŋaril min guñago bugo bareil mbal ésuh ece gajow yo Betusaida. ");
INSERT INTO bqj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bare fítiman fafu ni fútallo min fulagenil. No guĉih bo me, Yésu naannil, aban nanamo elobil mala Jávi Aláemit, nasen ᵽoᵽ gásomut me gahoy. ");
INSERT INTO bqj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","No tinah tuomme n’ejon, uᵽotoraol n’gulofol n’guogol : « Ubbañen bugan bugaubugi gujow bi ni súsuh sasu salof me tale, tima n’gujuh tiñ to gújue gubaj gutiñ ni gúmori, mata ube bo nuomal maa, kakan bin balikoe. » ");
INSERT INTO bqj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bare Yésu naagil : « Buru faŋaul jisenil gutiñ ! » N’guogol : « Unaĉ wono futoh ni muol múuba bare jibaje. Jújue ᵽiaŋ ék’énnomul mitiñ matoge bi n’ebat yauyu ᵽe yailo mee ? » ");
INSERT INTO bqj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maagen bugan bugagu gaam to me wáineaw guᵽiloe bugan gono súuli futoh (5 000). Yésu naah uᵽotoraol : « Jífaculoril gukan mítiman, jánojan n’jibaj bugan gono úvi gúuba ni guñen (50), mbiban n’jikanil n’gunamo. » ");
INSERT INTO bqj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Uᵽotoraol n’gukan ti nalobil me, n’gukanil n’gunamo bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ñer Yésu naŋar unaĉ waw waamme futoh ni muol mamu múuba, náarul gúĉilol mbaa fatiya nasal Aláemit mala mitiñ maumu. Aban namusulor so asen uᵽotoraol guŋar gugabor ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bugo ᵽe n’gutiñ iki gupoñ guŋañen toh utegel wono guñen n’úuba ummeŋ kab. ");
INSERT INTO bqj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Funah fice, Yésu o baamer n’galaw nevonol, uᵽotoraol n’gulofol. Naagil : « Bugan bugagu guoge ínje iomme ay ? » ");
INSERT INTO bqj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","N’guogol : « Guce guoge aw uomme Saaŋ Batis ; bugaguil n’guoh aw Elí, guceil bugo guoge ace ni uboñer waw bugaa no, o abbanno. » ");
INSERT INTO bqj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naagil : « Ñer buru juoge ínje iomme ay ? » Ᵽier naagol : « Aw uomme Kirista ahu o Aláemit aboñulo me. » ");
INSERT INTO bqj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bare Yésu naĉafil naagil jambi gulob yo me an. ");
INSERT INTO bqj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mbiban náfaro aagil : « Añol Arafuhow naate álam mámah : ufan súsuh sasu, ufan uteŋenaaw bi n’úᵽajula gúboñ Aláemit bugagu ró ᵽan gulalol iki gukanol naĉet. Bare funah fúfatten ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mbiban, Yésu naah ésuh yay : « An amaŋ me alagenom, jambi abbañ aᵽinor mala fuhool : ateb funah-ó-funah ekuruaol min alagenom. ");
INSERT INTO bqj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Maagen, an amaŋ me eᵽagen buroŋol, ᵽan ábbur bo, bare an ábbur me buroŋol múmbam, ᵽan abaj buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wa ᵽan nafa an o babajer mof mamu ᵽoomo, mbiban nábbur buroŋol ter nahajenoro ? ");
INSERT INTO bqj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iní me an nasuom ban ᵽoᵽ nasu gurimom, kan ínje Añol Arafuhow ᵽan may isuol no nijae me éjoul ni bájalo babu bóloli ró : búmbam, baa Ᵽayom ni bal emalakaom. ");
INSERT INTO bqj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ban ínje ilobul yo : guce ni gailo maa tale mati gutoh guĉet bugo m’bajugut Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","No Yésu alob me gurim gaugu iki baj fíiyay, naŋar Ᵽier, Saaŋ ni Saak min gujiŋ bi fatiya firijaŋ fice ake ró galaw. ");
INSERT INTO bqj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","No naamme n’galaw gagu, buulol m’búbahen, bisimool m’bútuen par ti gajaŋa émit baijer. ");
INSERT INTO bqj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ni baj wáine gúuba gúni n’galolobor ni o, bugo guomme Móis ni Elí. ");
INSERT INTO bqj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bugo ᵽoᵽ sinilil ni sihat nihi siij, bugo n’galolobor gaugu ni Yésu mala eĉelol yájaeul me baubu Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ᵽier ni bugagu gaam to me, bugo bámoer guhay was. No gúlio me, n’gujuh bájalo Yésu ni wáineaw gaamme gúuba gaam to me ni o. ");
INSERT INTO bqj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","No Móis ni Elí guomme m’búhanor ni Yésu, Ᵽier naagol : « Afanóli, fubambaŋ min wóli jíni tale n’aw. Ban jiilen gúggut gúfaji, fanur bi n’aw, fafu bi ni Móis, fupafo bi ni Elí. » (Min alobe mee, affasenut wa naamen n’elob.) ");
INSERT INTO bqj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","O m’babanerut elob yay, ni baj gávuh guĉigul, ban ni gúggubil gúharo n’emoĉ yay yala go ; n’gúholi nár. ");
INSERT INTO bqj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ni baj firim fáᵽullo ró fuoh : « Ume aamme Añolom o niĉob me ; aĉila mbi juutten me ! » ");
INSERT INTO bqj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","No fulob me fuban, n’gútallo búoh Yésu o bareol aam to. Uᵽotoraaw n’guᵽanor cem, mbi ᵽúrto gunah gaugu gugitenut ánoan wo gujuh me. ");
INSERT INTO bqj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tihalen fo, Yésu ni uᵽotoraol gúfaji bugagu n’gúavul ni firijaŋ fafu. Fuyoŋ fámah ni fújoul bi bíemor ni bugo. ");
INSERT INTO bqj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ni baj ró ace áine náh’áᵽib ró aah : « Afanom, uboket uilo mala áᵽurom érimbaniom ! ");
INSERT INTO bqj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ñammeŋe eseytane ᵽan enonol, ban to baenah ᵽan neh’ekanol náᵽib navenjeŋor, ban gagof nihi gúᵽurul m’butumol. Eseytane yay néh’élatienollatien faŋ, ban neh’ehalol bujoŋoy. ");
INSERT INTO bqj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nilaene ulagorai tima n’guham yo, bare gújuut. » ");
INSERT INTO bqj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yésu naah : « Jabbah je jaa bugan gabajut gáinen ! Ukana-galego we ! Bi nay ᵽan íni to ni buru nih’imutenul ? » Aban naah áine ahu : « Uŋárul áᵽuri bi tale ! » ");
INSERT INTO bqj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","No añil ahu ájaeul me, eseytane yay nebelol n’ettam iki nah’afarat. Bare Yésu nannur yo ni sembe min asen mamu añil ahu gahoy, aban nabbañenol ᵽayol. ");
INSERT INTO bqj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bugan bugagu ᵽe n’gujahali n’guoh : « Maagen Aláemit nájalojalo ! » Nemme bugan bugagu guroŋ n’gajahali mala wo Yésu akan me ᵽe, naah ulagorol : ");
INSERT INTO bqj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","« Juutten joon min júju jujoh wo nijaeul me elob : Añol Arafuhow ᵽan abeni ni guñen gaa bugan. » ");
INSERT INTO bqj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bare ulagorol gujogut firim faufu mata fúhagihag jambi fuŋanno ni bugo. Ban gukañenut erorenol wa namaŋe elobil. ");
INSERT INTO bqj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ᵽúrto, ulagorol n’gúni ni síceŋor bi effas ay ni bugo afaŋ me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nemme Yésu naffase gaᵽinoril, naŋar añil ace ailen to naamme, ");
INSERT INTO bqj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aban naagil : « Anóan ayab me añil ahume ni gajow gúmbam, ínje faŋaom nayabe ; ban an ayabom me, aboñaom faŋaol nayabe. Yo eĉil me, afaŋ me gaalenoro ni buru, o afaŋul me ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ñer Saaŋ naah Yésu : « Afanóli, jujuge ace áine nah’aham siseytane ni gajow gúiya. Bare jífirenolfiren ekan burok ti baubu mata alet ni gayoŋolal. » ");
INSERT INTO bqj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Naagol : « Jambi jífirenol ! Jiffas búoh an alalutul me búsolul nabbañe. » ");
INSERT INTO bqj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","No tinagol tuomme n’eĉih tal ebbañ mbal émit, Yésu naban dáh bi ejow mbaa Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Namundum aboñ bugan guyabol gayoŋ gujow guke ecokor ejoulol. N’gujow iki guĉih ece ésuh yaam ni mof mamu maa Samari. ");
INSERT INTO bqj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","No guĉih bo me, bugal ésuh yay n’gulat ealenol, mata o ejow mbaa Yérusalem naam ni yo. ");
INSERT INTO bqj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ulagorol Saak ni Saaŋ no guun me dáuru, n’guogol : « Afanóli, íni me numaŋe, n’jikan maer min sambun síavul n’émit iki sinemen bugan bugaubugi ! » ");
INSERT INTO bqj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bare Yésu nábaho til mbaa bugo min annuril naagil : « Buru jiffasut bay biinum bisenul mee gaᵽinor gaugu. ");
INSERT INTO bqj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Añol Arafuhow ajoulat mala bi enemen saalor bugan, bare bi eᵽagen so. » Mbiban, n’gukay mbal ece ésuh. ");
INSERT INTO bqj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","No guomme n’ejow, ni baj ace áine ákail aah Yésu : « Tánotan to nujae, ᵽan ilageni bi to. » ");
INSERT INTO bqj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yésu naagol : « Usikin waw ubaje usun wo, upu waw ᵽoᵽ ubaje ulef wo ; bare Añol Arafuhow aĉila abajut tiñ taa gáelo. » ");
INSERT INTO bqj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aban naah áine ace : « Ulanom ! » Naagol : « Afanom, újiom min imundum ijow ik’ifoh ᵽayom. » ");
INSERT INTO bqj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yésu naagol : « Uhat gaĉet me n’gufoh buganil gaĉet me, min til újoul uk’ugiten Jávi Aláemit ! » ");
INSERT INTO bqj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ace mul nabbañ aah Yésu : « Afanom, nimaŋe ilani, bare ᵽan umundum újiom min ijow ik’ijuh yaŋom ejuh ésola. » ");
INSERT INTO bqj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yésu naagol : « An aam n’eañ, átuh me gajanduol, ban nah’ajegor nímoro búsolol, an ahumu aᵽilout bi burok mala Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","No dáuru dígat me, Ataw natajen aĉob ulagora guce gono úvi gúfaji ni guñen ni gúuba, naboñil gúuba-gúuba guyabol gayoŋ ni súsuh sasu ni ulam waw ᵽe bo aĉila faŋaol ajae me ejow. ");
INSERT INTO bqj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naagil : « Eᵽit yay yo jijae me éjalojalo, bare uᵽilaaw gummeŋut. Jícin ñer aĉil me eᵽit yay min áboñul uᵽila gatoge bi eᵽilol. ");
INSERT INTO bqj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jujow ! Ban iboñul ti muñol ubbarum makae munogen n’etut sujoba-baha. ");
INSERT INTO bqj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jambi jíjaenum hani éralam, baet, ter gadala. N’ejaul, jambi jiilen me m’bulago bi esaf bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yaŋ yánoyan dó jijae me enogen, mbi jumundum juoh : “Gásumay gúni ni yaŋ ye !” ");
INSERT INTO bqj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Baj ró me an ala gásumay, ᵽan gásumay gagu golul gunamo ni o ; mb’íni me bajut, mati gúju gunamo ró. ");
INSERT INTO bqj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Junogen me n’ésuh, ni yaŋ yanur ᵽan jialen, ban ni jireor dó. Jinamo ró ni yaŋ yauyu, n’jitiñ n’jirem wo gujaeul me esen, mata aroka ánoan naate ayab bacamol. ");
INSERT INTO bqj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Esúh yánoyan dó junogene, min guyabul, wáfowaf wo gusenul, n’jitiñ. ");
INSERT INTO bqj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jisen gahoy úsotaaw gaam dó me, ban n’juoh bugan bugagu ᵽe : “Jávi Aláemit uju jájaeul me bi eloful.” ");
INSERT INTO bqj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bare junogen me n’ésuh yo bugala yo gulale eyabul, júᵽur ni fuhay n’juogil : ");
INSERT INTO bqj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Gaᵽor gagu gal ésugul gahot me ni guolóli, ban jiᵽaᵽ go jibbañenul. Bare jíarie jiffas búoh Jávi Aláemit julofulolof !” ");
INSERT INTO bqj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Maagen, ínje ilobul yo : Funah fafu fo Aláemit ajae me bataliŋ bugan bugagu, bataliŋerol bugala ésuh yay yaa Sodom ᵽan buhoy baa bugal ésuh yauyu. » ");
INSERT INTO bqj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yésu nabbañ aah : « Mataño míni ni buru, bugaa Korasin ! Mataño míni ni buru, bugaa Betusaida ! Waf waw waunderuti me wo Aláemit akan me ni buru, ínien Tir ni Sidoŋ nakanen wo, bugala súsuh sausu bugo basimoener wañ waa gúnigo, n’gulosor bukugay bi egiten búoh gúbahembahen bakaneril. ");
INSERT INTO bqj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yo eĉil me, funah fafu faa bataliŋ babu fiĉigul me, bataliŋul ᵽan bufaŋ m’bútañie baa Tir ni Sidoŋ. ");
INSERT INTO bqj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Min buru may, bugaa Kaᵽerinaum, jíinene ᵽiaŋ búoh Aláemit ᵽan atebenul bi fatiya ? Múk ! Ᵽan jialeni bi ró n’ettam n’ufuga ! » ");
INSERT INTO bqj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yésu nabbañ ábaho mbal ulagorol naagil : « An auttenul me, ínje nauttene ; bare an alalul me eutten, ínje nalale. Ban alalom me, nalalat aboñulom me. » ");
INSERT INTO bqj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","No ulagora Yésu gaamme úvi gúfaji ni guñen ni gúuba gubbanno me, n’guogol n’ésumay ró : « Afanóli, siseytane sasu ᵽoᵽ sikañenutóli no junnur so me ni gajow gúiya. » ");
INSERT INTO bqj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Naagil : « Nijuge Seytane naloulo me n’émit ti fínir. ");
INSERT INTO bqj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jujuge : Nisenulsen sembe bi ehah sunuhunjaŋ sasu ni siakut sasu, bi ᵽoᵽ ehek sembe sasu ᵽe sal alatora ahu, ban waf mat’újuul ekan uce. ");
INSERT INTO bqj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jambi júsumaet mata búoh jihehek siseytane sasu, bare ᵽan júsumaet til mala min Aláemit ahiĉ me ujaul fatiya. » ");
INSERT INTO bqj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","To baenah, Biinum Banabe m’bimmeŋen Yésu ésumay naah : « Nisali, Aláemit Ᵽayom, aw aĉil me émit ni ettam, mala min ukoᵽen me waf wauwu bugan bugagu gabaj me gaffas ni bugagu galillo me, mbiban nugiten wo bugagu gáni me ti uñil. Maagen, Ᵽayom, nisali mata súmisum min ní mee. » ");
INSERT INTO bqj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","« Waf waw ᵽe Ᵽayom nahatwohat ni guñenom. Bajut an affase ínje Añil ahu íni let Ᵽaaya, ban may bajut an affase Ᵽaaya íni let ínje Añil ahu ni bugo nimaŋ me egitenol. » ");
INSERT INTO bqj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mbiban, Yésu nábaho mbal ulagorol min aagil bugo bare : « Gásumay gúni ni buru, min Aláemit ájiul me n’jujuh táh waf wauwu. ");
INSERT INTO bqj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Injé ilobul yo, uboñer ni úvi gammeŋe bugaa no gumaŋene gujuh wo buru jujuge me, bare gutogut gujuh wo, gumaŋene guun wo buru juune me, bare gutogut guun wo. » ");
INSERT INTO bqj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ñer áᵽajula gúboñ Aláemit ace namaŋ aral Yésu gabbut naagol : « Aligenaom, bu níarie ikan bi ebaj buroŋ bábaerit ? » ");
INSERT INTO bqj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yésu naagol : « Gúboñ Aláemit wa gulobe ? Wa nujoh ró ? » ");
INSERT INTO bqj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aíne ahu naagol : « Guoge : “Ᵽan umaŋ Ataw aamme Aláemili n’éĉigiri ᵽe, ni biinumi ᵽe, ni sembei ᵽe ni gaᵽinori ᵽe.” Guoge may : “Ᵽan úbboli apali ti núbboli me fuhoi.” » ");
INSERT INTO bqj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yésu naagol : « Núbale ĉol. Ukan me dáuru, ᵽan ubaj buroŋ babu. » ");
INSERT INTO bqj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bare áᵽajula gúboñ gagu namaŋ egiten búoh surorenol síariari naagol : « Ñer ay aamme apalom ? » ");
INSERT INTO bqj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yésu nasenol búnogor baube : « Baje ace áine áᵽullo Yérusalem bi ejow mbal ésuh yay yaa Sériko. Nalo ni guñen uminda bulago, min gubelol n’ettam, n’guram wafol, n’gutegol ak’amaŋ eĉet, guban n’guhalol to. ");
INSERT INTO bqj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ni baj ateŋena ace aam to n’égat. No najugol me, najjas min ajow bulagool. ");
INSERT INTO bqj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ni baj may ace áine aroke ᵽoᵽ ni gávi-Aláemit áni to n’égat. O may no najugol me, najjas min ajow bulagool. ");
INSERT INTO bqj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Búsol ma, ni baj an ala Samari aam n’égat. No najugol me, enilol nerum. ");
INSERT INTO bqj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Najow bi to naᵽos musola mamu, aban naŋar míita násotenol. Mbiban, narembenol ni asum yay yola n’gujow bi ni yaŋ yay dó nihi gualen me sijaora, min acokorol dó. ");
INSERT INTO bqj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","No tihalen me, náᵽuren síralam asen afan yaŋ yay naagol : “Mb’ucokoromol ! Iní me bacam babu butogut, íbbañul me nulobom min icami waŋaño me.” » ");
INSERT INTO bqj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yésu nabbañ aah áᵽajula gúboñ Aláemit : « Ni aw, bugaubugi gaamme gúfaji, ay ni bugo aamme apal áine ahu alo me ni guñen uminda bulago bugagu ? » ");
INSERT INTO bqj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naagol : « N’ínje, ah’arumol me enil. » Yésu naagol : « Ñer aw ujow nukan mo may ! » ");
INSERT INTO bqj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","N’ejail, Yésu ni ulagorol n’guĉih n’ésuh ece. Ni baj dó anaare ace gajaol Maruta aalenol ni yaŋol. ");
INSERT INTO bqj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nabaj atiay gajaol Mari akelo anamo to n’guot Ataw min áni n’euttenol. ");
INSERT INTO bqj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maruta o náni babu n’elilior molil. Mufaŋ nájoul bi to ni Yésu naagol : « Ataw, kanuti wáfowaf min atiom ahalom mee nih’ililior ma ínje nevonom ? Uogol aiyul arambenom ! » ");
INSERT INTO bqj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ataw navogol : « Maruta, Maruta, nulimbe faŋ ni biinumi, ban aw umu ájasasore mee mala waf wammeŋe. ");
INSERT INTO bqj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bare waf wanur pat uᵽiloe. Mari naĉoĉob wafaŋ me jáari, wo an añumut me eram ni o. » ");
INSERT INTO bqj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Funah fice, Yésu nañago bi tice náni n’galaw. No naban me, ace n’ulagorol naagol : « Afanóli, uligenóli may bu jijae me elaw, ti Saaŋ Batis aligen yo me ulagorol. » ");
INSERT INTO bqj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yésu naagil : « Jíni me n’galaw, n’juoh maa : Ᵽayóli ! Gajai gumaleni. Jávi jaju jíya jújoul. ");
INSERT INTO bqj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Usenóli mitiñ mamu maa funah-ó-funah. ");
INSERT INTO bqj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Uboketóli utilóli, ti may wóli jubokete me gatile me ni wóli. Ban jamb’uhalóli n’julo ni gabut. » ");
INSERT INTO bqj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yésu natajen aagil : « Ti may ace ni buru nah’abaj me abuge, najow n’etut fuh ak’atogol naagol : “Abugeom, uboket umanom ma unaĉ úfaji, ");
INSERT INTO bqj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mata ajaora anonulom to, ban ibajut wo nijaol esen.” ");
INSERT INTO bqj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jíinene ᵽiaŋ búoh abuge ahumu ᵽan ábalulol ñáraru aah : “Jamb’uyogenom ! Niffaŋe ganegenom iban, ínje ni guñolom junogenogen. Ijúut ibbañ iiyul ikeli esen waf.” ? ");
INSERT INTO bqj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A-a, ínje ilobul yo til : Abuge ahumu ᵽan aiyul ákail asenol wo namaŋ me ᵽe. Let babugeil bare bujae eĉilol nakan mo ; bare nakan mo jambi aĉila faŋaol asu. » ");
INSERT INTO bqj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","« Injé umu n’eogul : Jícin Aláemit, ban ᵽan asenul ! Jiŋes, ban ᵽan jujuh ! Jiteh ganegen gagu, ban Aláemit ᵽan ápegulul ! ");
INSERT INTO bqj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maagen, an ácin me, ᵽan ayab ; an aŋes me, ᵽan ajuh ; an ateh me ganegen, Aláemit ᵽan ápegulol. ");
INSERT INTO bqj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ay ni buru ᵽan abaj añil mb’ácinol juol nájogul enuhunjaŋ asenol ? ");
INSERT INTO bqj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ter nácinol fie, nájogul eakut asenol ? ");
INSERT INTO bqj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mánoman jínie bugan bugaa maarat, bare til jújue esen guñolul waf waaro. Ñer bu til Ᵽaaya aamme fatiya añumut esen Biinum Banabe bugan bugagu galaeol bo me ? » ");
INSERT INTO bqj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Funah fice, Yésu náᵽuren eseytane yaam n’ace áine akane émumune. No éᵽur me ni o, áine ahumu nanamo elob. Ñer fítiman fafu faam to me gajahali n’gunogen fo. ");
INSERT INTO bqj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bare guce n’gubunor n’guoh : « Dáru Belisebul, afan siseytane sasu, asenol sembe sausu sal eham sipaso. » ");
INSERT INTO bqj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bugagu n’gumaŋ ebelol gabbut n’guogol : « Ukan bújoŋoroli bigitenum bo an ájuut akan bajae egiten búoh aw n’émit núᵽullo ! » ");
INSERT INTO bqj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nemme Yésu naffase gaᵽinoril, naagil : « Bugan gagume jávi gutigenoro me, jávi jauju ᵽan jinemo, saŋil ᵽan nihi sulo siĉimen sipaso. ");
INSERT INTO bqj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ban buru juoge Belisebul asenom sembe sausu sal eham siseytane sasu. Yo eomme ñer, Seytane aam n’etigenoro ! Iní me mo, jáviol bu jújue juroŋ bi maer ? ");
INSERT INTO bqj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Buru jujoge búoh Belisebul aseneom sembe sasu so niŋare me niham siseytane sasu. Ñer gupalul ni sembe ay guhame so me ? Yo eĉil me bakaner gupalul ᵽan bigitenul me búoh jibibij. ");
INSERT INTO bqj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bare nemme sembe sausu sal eham siseytane sasu, Aláemit asenom so, dó giten me búoh Jávi Aláemit jiĉiloĉih tale ni buru. ");
INSERT INTO bqj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ti may an abaje sembe, mbiban naogen miñeh, íni me napoe yaŋol, mat’abaj gaᵽinor maa fubajol ; ");
INSERT INTO bqj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","bare baj me ace afaŋol sembe ájoul, ᵽan ahekol min aram miñegol mo nafium me ni mo, aban naŋar fubajol agabor babu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","An abbañut me búsolom, o alatorom nam ; an ᵽoᵽ aanenutom me niomen ekore yay, dóemme evis yo namaŋe. » ");
INSERT INTO bqj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","« Eseytane éᵽur me ni an o neh’ebet, ᵽan neh’eyanor bo mee bin babu bahay me, ᵽan neh’eŋes tiñ taa gáelo, ban mat’ebaj. Ñer ᵽan eoh : “Ban ibbañ bi ni yaŋom dó níᵽullo me.” ");
INSERT INTO bqj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","No eĉih ró me, nejuh búoh yaŋ yay eᵽa erakel, evuivu ban étugituh jon. ");
INSERT INTO bqj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ᵽan ñer ejow ék’éŋesul sice siseytane sono futoh ni súuba safaŋ yo búlaᵽut, min sújoul so ᵽe íkiil siĉin dó. Ᵽúrto, sílam an ahumu ᵽan sifaŋ saa no. » ");
INSERT INTO bqj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","No Yésu alob me ak’aya, ace aare aam dó ni fítiman fafu náagul fatiya : « Gásumay ugu n’aare ahu afareti me, aban narafeni ! » ");
INSERT INTO bqj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bare Yésu nábahul aah : « Gubaj til gásumay bugan bugagu gaun me firim Aláemit, ban n’gúttun fo. » ");
INSERT INTO bqj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Min bugan bugagu gúmmeŋeul me, Yésu ñer nailo aagil : « Bugan bugagu bugaa jama guarat ; bigitenum bo an ájuut akan nihi guŋes bi ejuh, bare Aláemit mat’abbañ akanil n’gujuh bigitenum bice íni let babu babaj me Sonas. ");
INSERT INTO bqj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti Sonas aamen me bigitenum bi ni bugaa Niniv, mamu may Añol Arafuhow ajae me éni bice bi ni bugan bugagu bugaa jama. ");
INSERT INTO bqj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No funah fafu faa bataliŋ fujae me eĉih, aseh ahu ala mof mamu maa Saba ni gailool ᵽan aceŋ bugan bugagu bugaa jama, mata aĉila náᵽulloᵽur ráli ákail autten gurim gagu gatajene me gaffas gal ávi ahu Salomoŋ ; ban ute to nuomal maa, baje an afaŋe Salomoŋ. ");
INSERT INTO bqj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Funah fafu faa bataliŋ babu, gailo gagu go bugaa Niniv gubajen me no, ᵽan may gugiten bugan bugagu bugaa jama búoh gubajut bakoŋ, mata bugo no guutten me baĉafer Sonas guban, gúbahembahen bakaneril ; ban ute to nuomal maa, baje an afaŋe Sonas. » ");
INSERT INTO bqj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yésu nabbañ aah : « An asaen me ejaŋa, let bi ekoᵽen yo ter eguben yo n’elaᵽ. Ᵽan til aremben yo n’ebamba min mbi bugan bugagu gánoneul me gúju gujuh gajaŋa gagu gala yo. ");
INSERT INTO bqj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gúĉili go guomme ejaŋa enili. No guom apuñ go, enili ᵽe ᵽan éni ni maŋannoe ; bare no gúsomute, enili ᵽan éni n’emoĉ. ");
INSERT INTO bqj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yo eĉil me, mb’útallo jambi gajaŋa gagu gaamme ni aw, gúbaho emoĉ. ");
INSERT INTO bqj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Enili efijigeni me ᵽe, ban bajut ni yo tiñ tamoĉe, yo ᵽe ᵽan éni ni maŋannoe, ti ejaŋa bafijigeneri ŋanno ca. » ");
INSERT INTO bqj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","No Yésu alob me ak’aya, Aᵽárisie ace navogol bi eke fitiñ yaŋol, min gukay. No guĉih me, nanogen nafa ak’anamo bi fitiñ. ");
INSERT INTO bqj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aᵽárisie ahu najahali min Yésu aᵽosut me guñenol balama atiñ. ");
INSERT INTO bqj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ñer Ataw naagol : « Buru Eᵽárisie yay, jínini ti síremuma ni uril sakure búsol so bare, ban ñáraruul gaᵽinorul ᵽe gákuet ni búlaᵽut. ");
INSERT INTO bqj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Buru uce jiffase ! Atúl me sinilul, leti nátutul ᵽoᵽ síĉigirul ? ");
INSERT INTO bqj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Júᵽuren ñer waŋaño me ñáraru jíji galeh me, mamu waf waw ᵽe ᵽan ukur ni buru. » ");
INSERT INTO bqj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","« Mataño míni ni buru, Eᵽárisie yay ! Mata nihi júᵽurenᵽuren jisen Aláemit gakib ganur ni wono guñen ni wánowan bi ni wafaŋ me gamis wo juroge me n’ufalul, min til jujunden emaŋ Aláemit ni ekan gupalul maaro. Dáuru til juoten me jumundum jikan balama jike ekan uce úbuli. ");
INSERT INTO bqj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mataño míni ni buru, Eᵽárisie yay ! Nánonan jimaŋe jurobo ni sujukut sasu saa gayoŋ ni saŋ sasu saa galaw, jimaŋe ᵽoᵽ nihi gusaful ni jammeŋ ni gákanum ró. ");
INSERT INTO bqj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mataño míni ni buru ! Jínini ti guyah gáñai me go an ajugut, min bugan bugagu nihi guhah go n’gúgat m’baffasut. » ");
INSERT INTO bqj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ace ni úᵽajula gúboñ Aláemit bugagu naagol : « Afanom, ulob me mee, nujejel bi ni wóli ró. » ");
INSERT INTO bqj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yésu naah : « Buru ᵽoᵽ, úᵽajula gúboñ Aláemit bugagu, mataño míni ni buru, mata nihi jikakan bugan bugagu n’guteb bíteb báliie faŋ, ban hani jisih an ni buru janur mati jirambenil n’gúarul bo ! ");
INSERT INTO bqj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mataño míni ni buru, mata jiteᵽe wári guyah uboñer waw bugo sipayul gufan gumuh me. ");
INSERT INTO bqj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bakaner baubu bolul bigitene búoh juruhenduhen wo sipayul gufan gukan me ; bugo gumugil, buru n’jiteᵽ guyagil. ");
INSERT INTO bqj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yo eĉil me, Aláemit ni gaffasol gájalo me, naah : “Ᵽan iboñulil uboñer ni uᵽotora, ban guce ni bugo, ᵽan gumugil, bugaguil n’gúlatienil.” ");
INSERT INTO bqj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mamu mbi jabbah jauje juroreni me mala físimil fáyui me kábiriŋ m’buju babu, ");
INSERT INTO bqj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","újogum ni físim Abbel bi ni faa Sakari, amugi me ñáraru gávi-Aláemit gagu, n’etut físimenum fafu ni tiñ talu táñai me. Maagen ínje ilobul yo, Aláemit ᵽan ataliŋ jabbah je mala dáuru ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mataño míni ni buru, úᵽajula gúboñ Aláemit bugagu ! Mata júloĉe éffaŋum yay yaa ganegen gagu gasene me gaffas juogen. Buru faŋaul jilalat enogen dó, mbiban n’jimin bugagu gamaŋ dó me enogen. » ");
INSERT INTO bqj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","No Yésu áᵽullo me ni yaŋ yay, guiñ úᵽajula gúboñ Aláemit bugagu ni Eᵽárisie yay n’gutiñ Yésu faŋ. N’gunamo erondopenol ni erorenol nímoro suroren simmeŋ ");
INSERT INTO bqj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mata ebelol gabbut gumaŋe, tima ñace nalob firim fice fo mbi gugoñol me ni fo. ");
INSERT INTO bqj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Min Yésu aamme n’elob yay, bugan súuli ni súuli n’gúkail gúgolol gúharo. Gummemmeŋ iki nihi guhagor ni guot. Ñer Yésu namundum alob n’ulagorol naagil : « Júludo jambi maarat Eᵽárisie yay mítiᵽ mulo ni buru min jíni bugan galet bugaa maagen ti bugo bugo ni’gukoᵽen mo me. ");
INSERT INTO bqj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bajut waf wakoᵽeni wañumuti éᵽuren ni maŋannoe, bajut waf waffasuti wañumuti effas. ");
INSERT INTO bqj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yo eĉil me, wo jijae me elob n’emoĉ, bugan bugagu ᵽan guun wo ni maŋannoe ca. Wo jijae me ebunor ñáraru butoŋ, bugan bugagu ᵽan gulob wo fatiya ni fuhay. » ");
INSERT INTO bqj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","« Buru ubugeom, ᵽan ilobul waf wauwe : Jambi júholi me bugan bugo nihi gunemen me enil mbiban mati gúju ekan to uce gutajen. ");
INSERT INTO bqj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ban ilobul ay jíarie júholi : Mbi júholi Aláemit, áju me abenul ni sambun o bamugerul aban. Injé ilobul yo, aĉila jíarie júholi. ");
INSERT INTO bqj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Leti mutaja mono futoh ni’gunnomen síralam súuba ? Bare bajut janur ni mo jo Aláemit ájumore. ");
INSERT INTO bqj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ban buru, walul faŋawo naᵽinwoᵽin ᵽe. Yo niegeul jambi júholi : hani fuyoŋ faa bataja, jifaŋfofaŋ. » ");
INSERT INTO bqj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","« Injé ilobul yo : An ailo me ni fuhay min aah bújoŋor bugan bugagu : “Yésu aĉilom,” ínje Añol Arafuhow ᵽan may iilo bújoŋor emalaka Aláemit min ioh : “An ahumu ínje iĉilol.” ");
INSERT INTO bqj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bare an alalom me bújoŋor bugan bugagu, ínje Añol Arafuhow ᵽan may ilalol bújoŋor emalaka Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","An alob me maarat aya ni Añol Arafuhow, an ahumu ᵽan áju ayab gaboket ; bare an ajel me Biinum Banabe, aĉila mat’ayab gaboket. ");
INSERT INTO bqj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","No gujaeul me éjaenum iki gutaliŋul ni saŋ sasu saa galaw ter bújoŋor ufan ésuh yay, jambi sinilul siteh mala bu jijae me ébal ter wo juñum me elob, ");
INSERT INTO bqj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","mata Biinum Banabe no ᵽan bigitenul me wo jijae me elob. » ");
INSERT INTO bqj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ni baj ró ni fítiman fafu ace aah Yésu : « Afanom, uoh ᵽaa atiom akan min jigabor fubaj ᵽayóli. » ");
INSERT INTO bqj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bare Yésu naagol : « Ijoulat tale bi ekan ataliŋa sulobul ter agabora fubajul ! » ");
INSERT INTO bqj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mbiban, nábaho mbaa fuyoŋ fafu naagil : « Jíkanum jambi nihi jiliᵽ eomen fubaj ! Buroŋ arafuhow bujoumulat ni fubajol, mánoman fújaloe. » ");
INSERT INTO bqj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ñer Yésu nagitenil búnogor baube naah : « Baje asanum ace abaj ulah uĉej. ");
INSERT INTO bqj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ñer naah m’biinumol : “Injé, bu nijae me ᵽiaŋ ekan ? Ibbañut ibaj tiñ tal ebet baᵽilerom.” ");
INSERT INTO bqj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ᵽúrto naah : “Yoo, nijoge wo nijae me ekan. Ᵽan ifum utongom min iteᵽ wo ufaŋ gájalo, mamu ᵽan íju ibet ró wo niᵽit me, ni ᵽoᵽ fubajom ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mbiban, ᵽan iogoro : ‹ Abuge, nubaje fubaj fámah faᵽiloi bi fitiñi símit sammemmeŋ. Maer ñer unamo núelo, nutiñ, nurem, núrasor ! ›” ");
INSERT INTO bqj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bare Aláemit naagol : “Aw núgunoguno ! Efuga yauye déro ᵽan uĉet. Ñer fubaj fafu fo nuomen me, ay ᵽiaŋ mb’aŋar fo me ?” » ");
INSERT INTO bqj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yésu natajen aagil : « Mamu jae mee éni bi ni ánoan aomene fubaj bi ni o nevonol babe n’ettam, ban bújoŋor Aláemit akanut asanum. » ");
INSERT INTO bqj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ᵽúrto, Yésu naah ulagorol : « Dáuru diĉil me niegul : Jambi jiĉagor mala buroŋul, mala fitiñul ni ᵽoᵽ mala bisimoul. ");
INSERT INTO bqj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Buroŋ bufafaŋ mitiñ, ti may enil efaŋ me bisimo. ");
INSERT INTO bqj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Juluj ᵽaa uganar waw : nd’uroh, nd’uᵽit, ubajut butoŋ hani bíjej, bare Aláemit bae nákumenewokumen. Ban buru jifafaŋ ebaj nafa upu waw mámah. ");
INSERT INTO bqj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ay ni buru gaĉagorol gújue gutajen gaᵽio buroŋol hani jatiito ? ");
INSERT INTO bqj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nemme buru jújuut ekan dáuru dafulut me, ñer gaĉagor mala uce bi wa ? ");
INSERT INTO bqj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Juluj ᵽaa mafos mamu bu nihi muya me ! Ndi mirien, ndi ᵽoᵽ mieĉ bisimo, bare ínje ilobul yo : Hani ávi ahu Salomoŋ faŋaol, mánoman fubajol fújaloe, ámusut abaj bisimo búari iki bire ni bayaer baa gace ni mafos maumu ! ");
INSERT INTO bqj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iní me Aláemit násangene wári re mamu mafos mamu maa siŋam sasu maroŋ me jama, ban gajem ᵽan mibeni ni sambun, bu ñer mat’afaŋ me nasime wári buru, bugan ge bugo gáinenil gutogut mee ? ");
INSERT INTO bqj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yo eĉil me, jambi jike buyoh n’eliᵽ nánonan wo jijae me fitiñ ter marem. ");
INSERT INTO bqj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dáru gabajut me gáinen n’Aláemit nihi guliᵽ mee waf wauwu m’báelout ; bare buru jibaje Ᵽaaya affase búoh buru jusoholawosohola ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jiŋes til Jáviol, mamu aĉila ᵽan atañul wajae bo me eŋaño. » ");
INSERT INTO bqj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","« Aw jukoreom jatiti me, jamb’úholi ! Ᵽayul súmolsum min asenul Jávi jaju. ");
INSERT INTO bqj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Junnomen fubajul ᵽe, mbiban n’jisen galeh me síralam sausu. Juomen fubaj fatiya n’émit, dó mati fúmus me fubao. Ᵽan níme ti nihi fíni me ni jiet jo ndi júlu ; úku waw gújuut gutoh fo ró, ban ᵽoᵽ balol babu mati búju fo ró etiñ. ");
INSERT INTO bqj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jiffas búoh : to fubajul fuomme, uinumul ᵽoᵽ uwu to. » ");
INSERT INTO bqj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","« Jiilo jon ti uroka, n’jisinja liŋ bisimoul, ban n’jisaen sijaŋaul jihato. ");
INSERT INTO bqj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jikan ti uroka gaam n’enah afanil o bakaer emat búyabo : ábbañul me o n’eteh ganegen, n’gufaen gúpegulol. ");
INSERT INTO bqj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Urokaaw ubugi, ᵽan gásumay gúni ni bugo, íni afanil naĉilo natogil bugo m’bámoit. Maagen, ínje ilobul yo : Aĉila faŋaol ᵽan asinja bisimool, aban nakanil n’gunamo nagabil gutiñ. ");
INSERT INTO bqj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iní ter afan ahu nabbanno n’etut fuh, ter etut fuh bágaler, ban natogulil maluje, urokaaw ubugu ᵽan gásumay gúni ni bugo. ");
INSERT INTO bqj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jiffas dáure : Iní me afan yaŋ naffasene nay áku ᵽan anonulol, mat’ahalol nánonul dó. ");
INSERT INTO bqj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Buru ᵽoᵽ, jiilo ni majage, mata Añol Arafuhow ᵽan ájoul tinah to buru jiᵽinorenut. » ");
INSERT INTO bqj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ñer Ᵽier naah Yésu : « Afanom, búnogor baubu bo nugitenóli mee, ter bi ni wóli barebare, ter bi n’ésuh yay ᵽe ? » ");
INSERT INTO bqj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ataw naagol : « Ñer ay aamme aroka ahu aĉol me aban najah ? O aamme ahumu o afanol ajae me ebaŋ bi gapoy yaŋol, ni ᵽoᵽ bi esen gupalol uroka gutiñ tinah baĉiger. ");
INSERT INTO bqj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Abaj gásumay, aroka ahumu o afanol ajae me etoh, o báolerul, áni n’ekan burokol. ");
INSERT INTO bqj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Maagen, ínje ilobul yo : afanol ᵽan asenol wafol ᵽe wo nabaj me aogen. ");
INSERT INTO bqj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bare íni me aroka ahu naage m’biinumol afanol ᵽan aᵽioul, ᵽan ñer náh’álatien gupalol uroka, aban nanamo fitiñ narem áhali. ");
INSERT INTO bqj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aroka ahumu afanol ᵽan aĉigul funah fo aĉila aᵽinorut, tinah to naffasut ; ban no ñer afanol ᵽan ahamol ni yaŋ yay, aban nakanol wo nihi gukan me bugan bugagu ᵽe gáinenerit me. ");
INSERT INTO bqj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aroka affas me wo afanol amaŋ me, ban ailout bi ekan wo, ᵽan ayab gúteh gammemmeŋ. ");
INSERT INTO bqj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bare aroka affasut me wo afanol amaŋe, ban nakan galejeh, gútegol mati gummeŋ. Aláemit áji me an jálo, ᵽan may arorenol jálo ; ban ᵽoᵽ asen me an fubaŋ fámah, ᵽan may arorenol fo faŋ gájalo. » ");
INSERT INTO bqj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yésu natajen aah : « Nijoulojow bi esaen sambun n’ettam ; min imaŋen me siᵽi bo n’sisa ! ");
INSERT INTO bqj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bare níarie imundum iyab gábatise gaa sílam, ban gaᵽinor gumugom bi no gujae me ekano. ");
INSERT INTO bqj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jíinene búoh gásumay nikelo esen ni mof ? Hani ! Let gaĉila, bare til búfaculor ! ");
INSERT INTO bqj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ujógum to funah faa jama, yaŋ yabaje bugan gono futoh, ᵽan gúfaculor : gúfaji jolil, gúuba jolil. ");
INSERT INTO bqj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ᵽayma mati gujamor ni áᵽurol, jawma mati gujamor ni bájurol, ti ᵽoᵽ ásabul ni asomol guñumut me ejamor. » ");
INSERT INTO bqj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yésu natajen aah fítiman fafu : « Nánonan no jujuge gápar gañuget gúᵽurul bo tinah tuloe me, leti n’juoh : “Emít yay ᵽan elubul” ? Ban may ni kano. ");
INSERT INTO bqj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Leti ᵽoᵽ no jujuge érus yay yaa ni fiye éᵽurul, n’juoh : “Esúᵽa yay uyu n’eĉigul” ? Ban may neĉigul ti maagen. ");
INSERT INTO bqj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Buru jilet bugan bugaa maagen ! Ganogor gánogan gabaje n’ettam ter n’émit, buru jiffas go. Ñer wa uĉile mati jítallo gauge gabaj maa maer ? » ");
INSERT INTO bqj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","« Wa uĉile buru guhoul mati juĉob wáari me min jikan wo ? ");
INSERT INTO bqj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iní me nubajore ni an, min jíni n’ejow bi bataliŋ, n’jugum bulago, ᵽan ukan tima n’juunor, mamu jambi ájaenumi bújoŋor ataliŋa ahu min til ábaheni asen bugal ubaŋ gúrur ni fipeh ! ");
INSERT INTO bqj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Injé ilobul yo : An ahumu mát’áᵽurul dó ni fipeh fafu o m’babanut ecam ganeol bi n’efaraku ésola. » ");
INSERT INTO bqj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","No, baje guce gakelo gugiten Yésu mala bugan guce bugaa Gálile bugo Ᵽilat amuge, iki físimil fúguñor ni faa sihaj sasu so guomen me n’ésimen bi n’Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yésu naagil : « Jíinene búoh min bugan bugaubugu gumugi me, dóemme utilil ufafaŋ gájalo waa bugaa Gálile ᵽe ? ");
INSERT INTO bqj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Niegul let mo. Ban buru ᵽoᵽ, íni me mati jíbahen bakanerul, ᵽan jiĉet ᵽe ti bugo. ");
INSERT INTO bqj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Juluj may bugan bugagu gaamme gaat ni gúfaji gaĉet me baubu Siloam no etah yay éhullo me min epulujil. Jíinene búoh bugo gufaŋe ekan maarat bugan bugagu ᵽe gaĉin dó me Yérusalem ? ");
INSERT INTO bqj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Niegul let mo. Ñer íni me mati jíbahen bakanerul, eĉet juñum buru ᵽe ti bugo. » ");
INSERT INTO bqj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ᵽúrto, Yésu naŋar búnogor baube min ataril naagil : « Baje ace áine aroge ni gafalol bífig. No nake ró me bi etuj gúfig, atogut ró waf. ");
INSERT INTO bqj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ñer naah arokaol : “Símit sífaji use níh’íjoul bi etuj gúfig, mat’ibaj. Ubet bo ! Jambi biilo to me bamotoŋ !” ");
INSERT INTO bqj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bare aroka ahu naagol : “Afanom, uboket uhat bo to émit yauye, min íjus fuhoŋol bo ibosen, mbiban níyu to bukugay. ");
INSERT INTO bqj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ñace toon ᵽan bubuh mitiñ ; let mo, nuboñ gubet bo.” » ");
INSERT INTO bqj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Funah fice faa fíiyay Esúif yay, Yésu náni n’gavare ni yaŋ yaa galaw ece. ");
INSERT INTO bqj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ni baj ró anaare ace ásomute : símit gaat ni sífaji, eseytane yay yaamme ni o netujol, mát’áju áallo. ");
INSERT INTO bqj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","No Yésu ajugol me, navogulol naagol : « Aare ahu, nuᵽage ni gásomuli. » ");
INSERT INTO bqj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nateb guñenol aremben ni o, to baenah náallo, aban nanamo esalen Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bare afan yaŋ yay yaa galaw ni mujogol min Yésu asen mee an gahoy funah fafu faa fíiyay. Naah ésuh yay : « Nubajale gunah futoh ni fanur gal ekan urokolal ; mbi nihi jújoul gunah gaugu bi eyab gahoy, bare let funah fafu faa fíiyay ! » ");
INSERT INTO bqj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ataw nábalol aah : « Buru jilet bugan bugaa maagen ! Funah faa fíiyay, ánoan ni buru nah’ajajal ébeol ter asumol ake garemen, leti mo ? ");
INSERT INTO bqj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ñer aare ahume aamme gabulaken Aburaham, o Seytane ahoh me símit gaat ni sífaji, áariut ajali, hani funah faa fíiyay ? » ");
INSERT INTO bqj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bábaler Yésu m’busuen ulatorol ᵽe ; bare ésuh yay ᵽe ni súmil mala maaro mamu mo nakane me. ");
INSERT INTO bqj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yésu naah : « Jávi Aláemit wa junogore ᵽiaŋ ? Ni wa níjue iligor jo ? ");
INSERT INTO bqj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yoo, jínini ti jukol buyaba jo an aroge n’gafalol min jiilul iki jikan buyaba, min upu waw nuh’ulef ró n’uan bo. » ");
INSERT INTO bqj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Natajen aah : « Ni wa mul níjue iligor Jávi Aláemit ? ");
INSERT INTO bqj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jínini ti lévir yo anaare atiĉe águñor ni ukib úfaji wal eᵽor ek’eilo ᵽooyo. » ");
INSERT INTO bqj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","No Yésu aamme n’ejow yay mbaa Yérusalem, náh’ágat ésuh bi n’ésuh navare nímoro. ");
INSERT INTO bqj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ni baj ace arorenol : « Afanom, bugan guman barebare gujae ᵽiaŋ eyab gaᵽah ? » Yésu naagil : ");
INSERT INTO bqj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","« Jiaken mbi junogen ni gánonum gagu gagog me ; ínje ilobul yo, bugan gammeŋe ᵽan gulih enogen to, ban mati gúju. ");
INSERT INTO bqj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","No ala yaŋ yay ajae me eilo min affaŋ ganegen gagu buru baroŋer bo tíyaŋ, ᵽan nihi jiteh go bo n’juoh : “Afanóli, uboket úpeguloli !” Ban aĉila ᵽan aagulul : “Buru, iffasut bay júᵽullo.” ");
INSERT INTO bqj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ñer buru bi eogol : “Wolal hum utiñoral me, nuremoral, ban nuvaree n’ulago waw wal ésugoli.” ");
INSERT INTO bqj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ᵽan abbañ aagulul : “Iffasut bay júᵽullo. Buru ukana-maarat we, jifaren m’baaba !” ");
INSERT INTO bqj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","To ñer jijae me ukoŋ n’jujoh émiremma, no jijae me ejuh Aburaham, Isak, Sakob ni uboñer waw ᵽe dó ni Jávi Aláemit, mbiban n’gubaŋul tíyaŋ. ");
INSERT INTO bqj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bugan ᵽan gúᵽurul n’ulam waw ᵽe waa mof íkiil gutiñ gaggan gagu dó ni Jávi Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ñer guce gaamme jama úsola, ᵽan gúni útiar, bugagu gaamme maer útiar, ᵽan gúni úsola. » ");
INSERT INTO bqj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ᵽúrto, Eᵽárisie guman n’gújoul iki gutoh to Yésu n’guogol : « Uᵽúr dáre, ujow mbaa bice, mata Herod namaŋe bi jamugi ! » ");
INSERT INTO bqj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yésu naagil : « Jujow iki juoh gasubut gagu Herod : “Injé umu n’éᵽuren siseytane, esen gásomut me gahoy jama ni gajem ; ban funah fúfatten, fiĉila nijae me ériren burokom.” ");
INSERT INTO bqj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bare jama, gajem bi ni funah fúfatten níarie ifa bulagoom ik’iĉih, mata jáhorut min aboñer anemeni tice túbuli Yérusalem. » ");
INSERT INTO bqj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","« Yérusalem, Yérusalem, aw amuge me uboñer waw, aw o nuh’uteh me sival bugan bugagu bugo Aláemit áboñeul me bi n’aw, iki guĉet : ñono butumbu nilige eomen bugani gulofom ti ehulol neh’eguben me bapu yo n’ubes yo ! Bare buru júmusut jimaŋ. ");
INSERT INTO bqj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Juluj, biĉin baube bolul Aláemit ᵽan ajunden bo. Ban ínje ilobul yo, mati jibbañ jujugom bi no jijae me eoh : “Aláemit ásonien an ahu ájaeul me ni gajow gola !” » ");
INSERT INTO bqj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Funah fice faa fíiyay, Yésu nanogen ni yaŋ afan Eᵽárisie yay ace bi eke ró fitiñ. Gaamen dó me n’gunamo gubajenbaj nihi gulujol. ");
INSERT INTO bqj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ni bajen dó ánaine ace o gásomut gagu gaa bulla gujoge. ");
INSERT INTO bqj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ñer Yésu naah Eᵽárisie yay ni úᵽajula gúboñ Aláemit bugagu : « Gúboñ gagu gololal gal Aláemit gújiolalji ter gújiutolal ekan ásota nahoy funah fafu faa fíiyay ? » ");
INSERT INTO bqj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","N’guᵽanor utumil. Ñer Yésu naŋar ásota ahu nakanol nahoy, aban naagol ajow. ");
INSERT INTO bqj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mbiban naagil : « Ay ni buru mb’abaj añil aloe n’éhaᵽa, ter ébe, mat’afaen áᵽunnulol ni majase, hani funah faa fíiyay ? » ");
INSERT INTO bqj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gubajut wa gujae ébalol. ");
INSERT INTO bqj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","No guomme n’erobo bi fitiñ, Yésu nátallo min guĉobe me gurobo gagu gáamumma. Ñer naŋar búnogor baube naagil : ");
INSERT INTO bqj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","« An avogi me fitiñ búyabo, jamb’uramor uk’unamo ni furobo fafu fáamumma : júe baj ace afaŋi o guvoge ᵽoᵽ aĉigul, ");
INSERT INTO bqj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","min an ahu avogulul me buru éubaul, ákail aagi : “Uilo nusen ahume furobo faufu !” No ñer ᵽan uilo me ni ñusui ró uk’unamo ni furobo fafu fátijum me. ");
INSERT INTO bqj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bare til níh’íni me an avogi, nuk’unamo ni furobo fafu fátijum me búsol, min mbi no avoguli me ajae me eĉigul, naagi : “Abugeom, úiyul mbaa gayoŋ uk’unamo tafaŋ me jáari !” No ñer ᵽan uyab me gasal bújoŋor ésuh yay ᵽe gaam to me ni fitiñ fafu. ");
INSERT INTO bqj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maagen, an atebenoro me ᵽan aaleni, bare an aalenoro me, o ᵽan atebeni. » ");
INSERT INTO bqj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mbiban, Yésu naah an ahu avogulol me : « Uní me n’ésil bugan gataw ter gájimel, jamb’uvoh gubugei, ter gutii, ter bugani, ter uĉindorai gabaje, mata bugo gújue may guvogi ñace bi bulugen. ");
INSERT INTO bqj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bare til úni me n’ésil gaggan, nuvoh galeh me, gahaj me, gájuut me ejow ni gápim me, ");
INSERT INTO bqj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","mamu ᵽan gásumay gúni ni aw, mata bugo gújuut gulugeni. Aláemit faŋaol ᵽan abbañeni wo no najae me ébbañenul bugan bugagu gakan me maaro gúni ni buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ace ni bugan bugagu gatiñore me ni Yésu, no naun me gurim gaugu, naagol : « Gásumay gúni ni ánoan ajae me fitiñ ni Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ñer Yésu naŋar búnogor baube min ábalol : « Baje ace áine ásile meŋ, aban navoh bugan gammeŋe bi fitiñ. ");
INSERT INTO bqj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","No tinah talu taa fitiñ tiĉih me, naboñ arokaol ak’aah bugo navoh me : “Jújoul, sinaŋ sasu suñuve !” ");
INSERT INTO bqj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bare bugo navoh me nihi guceŋol anur-anur. Atíar naagol : “Galah niju maa ennom, níarie ik’ijugul go. Nilai gaboket.” ");
INSERT INTO bqj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ahu naagol : “Ninnonom gújin gono guñen gal eañ, ᵽan ike go elih. Nilai gaboket.” ");
INSERT INTO bqj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ahuo naagol : “Injé nijuju búyab ; yo eĉil me mat’íju íjoul.” ");
INSERT INTO bqj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","No aroka ahu abbanno me, nagiten afanol dáuru ᵽe. Ñer ala yaŋ yay fiiñol ni fitiñ naah arokaol : “Ujow ni majase bi ni gurobo gagu ni gukaen gagu gal ésuh yay uk’uvogulom bugan bugagu galeh me, gahaj me, gápim me ni gájuut me ejow.” ");
INSERT INTO bqj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ᵽio maa, aroka ahu nákail aagol : “Nikane wo nulobom me, bare yaŋ yay eroŋe m’bammeŋerut.” ");
INSERT INTO bqj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ñer afan ahu nabbañ aagol : “Utey mbal ulago waw galam ulah waw úk’úᵽunnul bugan bugagu min mbi yaŋom emmeŋ.” ");
INSERT INTO bqj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Niegul : Hani an anur ni bugo nivoh me evoh étiar mat’aĉoen sinaŋom. » ");
INSERT INTO bqj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ᵽúrto, fítiman fámah ni fujaor ni Yésu. Nábaho naagil : ");
INSERT INTO bqj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","« An amaŋ me elagenom, náarie amaŋom iki faŋ ᵽayol, jaol, aarol, guñolol, gutiol, gúlinol, iki faŋ buroŋol faŋabo. Let mo, an ahumu mát’áju áni alagorom. ");
INSERT INTO bqj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","An atebut me ekurua yay yaa sílamol min alagenom, mát’áju áni alagorom. ");
INSERT INTO bqj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ay ni buru mb’amaŋ eteᵽ yaŋ, mat’amundum anamo naᵽinor síralam butumbu náarie áᵽuren, ter síralamol ᵽan súju siban yo lis ? ");
INSERT INTO bqj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Gáholi jambi áĉit yo aban mat’ebao, min gajae me ejuh báĉiler babu, guber ");
INSERT INTO bqj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","n’guoh : “Aíne ahumu náĉiĉit yaŋol, ban ájuut yo efaben !” ");
INSERT INTO bqj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mamu may, ay ávi mb’áni n’eke fitih n’apalol ávi, mat’amundum anamo naᵽinor aah : “Nibaje bugan súuli guñen (10 000). Guᵽiloe ᵽiaŋ eŋar nik’itih ni alatorom ájaeul me mbal ínje ni bugan súuli ávi (20 000) ?” ");
INSERT INTO bqj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iní me ájuut, ᵽan asommen aboñ bugan bi ni alatorol bi eŋes gajamor o baroŋer n’érali. » ");
INSERT INTO bqj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yésu natajen aagil : « Mamu ᵽan ní mee bi ni an ni buru o balaler ehat wo nabaj me ᵽe min alagenom ; an ahumu mát’áju áni alagorom. » ");
INSERT INTO bqj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","« Maagen, misis waf waaro faŋ, bare múbbur me gafira mo, bu mbi gubbañeni ni mo ? ");
INSERT INTO bqj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mati an abbañ aŋar mo bi ekan waf uce, hani eŋar mo akan bukugay ; ebelen barebare. An abaj me gunnu gal eun, aun ! » ");
INSERT INTO bqj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Uyaba-búalen ni bugagu bugo ujail uhajen me, nihi gulof Yésu bi euttenol. ");
INSERT INTO bqj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ñer Eᵽárisie yay ni úᵽajula gúboñ Aláemit bugagu n’gúmeñ Yésu guoh : « Aíne ahume nah’aalen utilaaw wári iki nah’atiñor ni bugo. » ");
INSERT INTO bqj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ñer Yésu naŋar búnogor baube naagil : ");
INSERT INTO bqj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","« An ni buru abaj me ubbarum wono ekeme min ganur ni wo gullim, leti ᵽan ahat to n’ulah waw wawu ᵽoowo, min ak’aliᵽul ganur gagu gallim me ak’ajugul go ? ");
INSERT INTO bqj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ban no najae go me ejuh, ᵽan súmol nateb go akan n’ubandol. ");
INSERT INTO bqj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ñer no najae me eĉigul súndool, ᵽan ávogul gupalol ni uĉindorol min aagil : “Júsumaet mimanur n’ínje, mata nijuge gabbarumom gallimen me.” ");
INSERT INTO bqj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mo may, ínje ilobul yo, ésumay yay yaa n’émit ᵽan efaŋ gájalo atila anur o bábahener bakanerol, faŋ yala bugan gono úvi gubbagir ni gaat ni gubbagir (99) gaĉole garorenut ébahen bakaneril. » ");
INSERT INTO bqj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","« Ti may anaare o babajer sifaraku sono guñen, mbiban yanur nellim, leti ᵽan asaen ejaŋa navu yaŋ yay, min abajenbaj naliᵽ efaraku yay iki ajuh yo ? ");
INSERT INTO bqj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ban no najae yo me ejuh, ᵽan ávogul gupalol ni uĉindorol min aagil : “Júsumaet mimanur n’ínje, mata nijuge efarakuom yallimen me.” ");
INSERT INTO bqj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mo may, ínje ilobul yo, emalaka Aláemit ᵽan gúsumaet mala atila anur o bábahener bakanerol. » ");
INSERT INTO bqj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yésu natajen aagil : « Baje ánaine abaje úᵽur gúuba. ");
INSERT INTO bqj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Apuma naah ᵽayol : “Ᵽaᵽa, usenom butumom ni faĉaw ni fubaj fafu fo nujaóli me ehat.” Min ᵽayma agaboril fo. ");
INSERT INTO bqj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ᵽúrto gunah guman, áᵽur ahu apuma nannomen fubajol ᵽe min akay mbal ésuh ece ráli. No naĉih bo me, nanamo búᵽoĉet min atiñ fubajol ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","No natiñ fo me aban, bieb bámah m’búloul dó n’ésuh yay, ban ñer abbañut abaj wo najae me fitiñ. ");
INSERT INTO bqj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Najow ak’ahamago yaŋ ace áine ala ró n’ésuh yay min áine ahu nah’aboñol gakoñ suhumbaol. ");
INSERT INTO bqj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Añil ahumu biinumol m’bíni ni mitiñ suhumba sasu, bare mati baj an abembol. ");
INSERT INTO bqj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ñer naᵽinor aah : “Uroka ᵽayom ubugi bo maa ni’gutiñ gupoñ iki guŋañen ; ínje o níkail íni tale nihi bieb bumuh. ");
INSERT INTO bqj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ᵽan iot mbaa yaŋ ᵽayom ; iĉih me, niogol : ‹ Ᵽaᵽa, nitile n’Aláemit ni ᵽoᵽ ni aw. ");
INSERT INTO bqj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iᵽilout min ubbañ ujogom ti añil úiya. Ujogom ti ñer níh’íni me arokai ace ! ›” ");
INSERT INTO bqj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Min ñer ailo ake búot mbaa yaŋ ᵽayol. O baroŋer n’érali yaŋil, ᵽayol naŋandenol, ban enilol nerumol faŋ. Náteil iki guemor, nálloŋol aban nacolol. ");
INSERT INTO bqj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aᵽúr ahu naagol : “Ᵽaᵽa, nitile n’Aláemit ni aw. Ibbañut iᵽilo min ujogom ti añil úiya.” ");
INSERT INTO bqj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bare ᵽayma naah urokaaw : “Jíŋarul ni majase gájuo gagu gafaŋ me jáari jikanol, jikanol ᵽoᵽ eĉela ni gañen ni udala ni guot. ");
INSERT INTO bqj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jújogul jíjin jaju jafaŋ me bali jumuh min ukanaol gaggan gámah, ");
INSERT INTO bqj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mata áᵽurom ume naĉelenĉet, mbiban nábbañul áni m’buroŋ, nallimenlim bare nibbañe iraŋenol.” Min ñer gunamo ekan gaggan n’ésumay ró. ");
INSERT INTO bqj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ni tinah tautu, afamma o bároŋerul m’burok n’ulah waw. No naotulo me ák’áloful yaŋil, naun min fóñe mee ni boge mee. ");
INSERT INTO bqj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Návogul ace n’urokaaw min arorenol wa ubaje ni yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aroka ahu naagol : “Atii nabbañulobbañ, ban naĉigul ni gásumay, yo eĉil me ᵽai namuh jíjin jaju jali me min akanol gaggan.” ");
INSERT INTO bqj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ñer afamma ahu fiiñol ni fitiñ nalat enogen ni yaŋ yay. Ᵽayol náᵽurul akelol esafor tima nanogen. ");
INSERT INTO bqj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bare afamma ahu naah ᵽayol : “Uutten, baje símit sammemmeŋ ínje n’eroki ti amigel, ímusut ilat ekan hani gúboñ ganur gúiya. Ban úmusut usenom mele jijamen jafulut me min ísil súm itiñ ni gupalom. ");
INSERT INTO bqj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bare no áᵽuri umua abbanno me, aŋar me fubaji ᵽe ak’abelen ni sujobu, nufaen umugol jíjin jaju jali me.” ");
INSERT INTO bqj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ᵽayol naagol : “Añúm, aw umu tale nánonan n’ínje, ban waf waw úmbam ᵽe, úiya uom may. ");
INSERT INTO bqj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bare ᵽiloᵽilo min ukanal gaggan ban núsumaetal, mata atii umu naĉelenĉet, mbiban nábbañul áni m’buroŋ, nallimene bare najugi.” » ");
INSERT INTO bqj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yésu naah may ulagorol : « Baje asanum ace abaje an aogenol fubajol. Funah fice, n’gúkail guoh asanum ahu arokaol nahajenehajen fubaj fafu. ");
INSERT INTO bqj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ñer asanum ahu navogol naagol : “Ulobom ᵽaa min iune maa gulob maarat guya n’aw. Usenom bahiĉer babu baa wáᵽur me ni wanonulo me ni fubajom, mata mat’úju ubbañ úni aogena fubajom.” ");
INSERT INTO bqj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ñer aroka ahu naagoro : “Nemme afanom ban áᵽurenom to nabaŋenom me, wa mb’ikan me ? Sembe silet bi ekan burok báliie, ban ᵽan isu ᵽoᵽ eke gúcin. ");
INSERT INTO bqj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yoo, niffase bu nijae me ekan min mbi bugan gualenom ni saŋil, afanom báᵽurenerom ni burokom.” ");
INSERT INTO bqj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ñer naboñ guvogulol bugan bugagu ᵽe gabaj me ganew n’afanol. Naah átiar : “Butumbu nuogene afanom ?” ");
INSERT INTO bqj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naagol : “Gubidoŋ ekeme (100) gal édunen.” Naagol : “Yoo, urobo ni majase nuŋar gahaili go nikaneni me, min uhiĉ dó gubidoŋ úvi gúuba ni guñen (50).” ");
INSERT INTO bqj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mbiban naah ahu : “Aw, butumbu nuogene afanom ?” Naagol : “Gubbote ekeme (100) gaa bálut.” Naagol : “Uŋar gahaili nuhiĉ dó úvi gubbagir (80).” ");
INSERT INTO bqj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Afan ahu namalen aroka ahumu aĉolut mee mata najengulojengulo. Maagen bugan bugagu bugaa mof gufaŋorefaŋor bajengulo iki faŋ guñol gajaŋa gagu. ");
INSERT INTO bqj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Injé ilobul yo : Jiŋar gubaj gagu gasige me min jiŋesoro gubuge ; mamu, no gubaj gaugu gujae me ebao ni buru, ᵽan guyabul ni biĉin babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","An aĉol me n’ekan waf waw watiti me, ᵽan ᵽoᵽ aĉol ni wauwu wájalo me. Mb’aĉolut me ni watiti me, mati may aĉol ni wájalo me. ");
INSERT INTO bqj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iní me juĉolut n’eogen gubaj gagu gasige me, ay mb’asenul me gagu gaa maagen ? ");
INSERT INTO bqj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mb’íni me juĉolut ni waf wal ace, ay ajaul esen waf waw wabaŋi me bi ni buru ? ");
INSERT INTO bqj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bajut aroka ájue arok bi ni ufan gúuba ni manur ; mata ᵽan alat anur min amaŋ ahu ; ᵽan ákanum anur, ahuo naĉotihenol. Jújuut jimigelet mimanur Aláemit ni Síralam. » ");
INSERT INTO bqj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ban Eᵽárisie yay no guun me gurim gaugu, n’gunamo éfohul Yésu mata kakan bugan gamaŋe síralam. ");
INSERT INTO bqj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bare Yésu naagil : « Buru jujogoroe ukana-maaro bújoŋor bugan bugagu, ban Aláemit naffase waamme n’uinumul. Jiffas búoh, wo bugan bugagu gujoge me ti waf wámah, ulet wáfowaf bújoŋor Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tinah talu taa gúboñ gagu gaa Móis ni bagitener uboñer waw, to tífaro me bi ni Saaŋ Batis. Kábiriŋ no, Firim fafu Fásum me faa Jávi Aláemit ufu n’egiteni, ban ánoan umu n’etaj tima nanogen ni Jávi jauju. ");
INSERT INTO bqj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Emít yay ni ettam yay ᵽan sifaŋ ejas enemo jirim jaju jafaŋ me gatiti jaam ni gúboñ Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","« Anáine ánoan aham me aarol, mbiban nayab anaare ace, natile gatil gaa búyabo. An may ayab me anaare o áinol ahame, natile gatil gaa búyabo. » ");
INSERT INTO bqj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","« Baje asanum ace nah’asimo wañ ujaha, ban funah-ó-funah yaŋol gaggan ni fitiñ súm nímoro. ");
INSERT INTO bqj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ni baj ᵽoᵽ an ace alege, gajaol Lasar, enilol ᵽe musola, nah’afilo to n’gánonum asanum ahu. ");
INSERT INTO bqj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aíne ahume nah’amaŋen amuruh atiñ wáᵽageul me ni biril asanum ahu ulo n’ettam. Sujoba sasu mul nihi síkail simesen musolaol. ");
INSERT INTO bqj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aíne ahu aleh me naĉet, ban emalakaay n’gutebol bi n’émit to Aburaham aamme. Asanum ahu may naĉet, n’gufogol. ");
INSERT INTO bqj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nálam ni sambun mámah ; náarul gúĉilol najuh ráli Aburaham, Lasar áni to n’gacaĉol. ");
INSERT INTO bqj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ñer nailo avoh : “Ᵽayom Aburaham, urumom enil min úboñul Lasar ákail aya fisigol ni mal min ájeben fírerumom ! Nílame mámah ni sambun sause.” ");
INSERT INTO bqj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bare Aburaham naagol : “Añúm, uosen búoh, ni buroŋi nuyabe wafi wáari me, ban Lasar o waarat me nayabe. Maer umu n’eyab basaforol, min aw úni n’eyab sílami. ");
INSERT INTO bqj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ban babaj busun bámah básikie baam n’etulolal, mamu an amaŋ me éᵽurul babe bi bo ni buru, mát’áju, ban ᵽoᵽ mati an áju áᵽurul bo buru juomme bi babe ni wóli.” ");
INSERT INTO bqj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Asanum ahu naagol : “Nemme mamu, Ammay, nilai uboket uboñ Lasar bi ni yaŋ ᵽayom, ");
INSERT INTO bqj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bo nihatulo me gutiom gaamme futoh. Ajow ák’átallenil jambi bugo may gújoul bi ni tiñ taute taam maa taa sílam.” ");
INSERT INTO bqj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aburaham naagol : “Bahiĉer Móis ni bal uboñer waw bújue bútallenil bugo bauttener bo.” ");
INSERT INTO bqj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bare asanum ahu naagol : “Ammay Aburaham, úru ᵽilout. Bare baj me an áᵽur ni gaĉet me ajow ak’atogil bo, no ᵽan gúinen me min gúbahen bakaneril.” ");
INSERT INTO bqj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naagol : “Gumaŋut me gúttun Móis ni uboñer waw, mati baj an ace o gujae éttun, hani nihi ailo ni gaĉet me.” » ");
INSERT INTO bqj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yésu natajen aah ulagorol : « Ᵽan baj nánonan waf wajae eĉil bugan bugagu n’gulo ni gabut. Bare mataño ᵽan míni ni an ahumu ajae me ebet gupalol ni gatil. ");
INSERT INTO bqj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ehoh an ahumu fuval fámah n’ehondor gural ni fal ehoe aĉila ebet ni gatil ace ni miñil me. ");
INSERT INTO bqj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jítallo ! Iní me atii natile, nuĉafol, mb’íni nabbanno ateh mahat, nuboketol. ");
INSERT INTO bqj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iní me natile n’aw bi ñono futoh ni ñáuba funah fanur, ban ᵽoᵽ naban nákail ñono futoh ni ñáuba aagi natege mahat, ᵽan uboketol. » ");
INSERT INTO bqj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Uᵽotoraaw n’guoh Ataw : « Utajen gáinenoli gufaŋ gájalo ! » ");
INSERT INTO bqj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ataw nábalil aah : « Iní me jibajene gáinen garee ti jukol fuyaba, ᵽan jújuen juoh bununuh baubu : “Ubbuĉoro, mbiban nuk’urogoro ni fal !” Ban ᵽan bukanen ti julob bo me. » ");
INSERT INTO bqj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yésu nabbañ aagil : « Iní me ace ni buru nabaje aroka nah’aañol ter nah’akoñol sukoreol, aju me éolul, ᵽan ᵽiaŋ afanol aagol : “Ukela fitiñ” ? ");
INSERT INTO bqj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A-a, ᵽan til aagol : “Uk’úsilom, uban núᵽuren wañi waa burok min úkail usenom itiñ nirem ; mbi no nijae me eban ᵽe, aw ñer núkail may utiñ nurem.” ");
INSERT INTO bqj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ay ᵽan asalen arokaol mata búoh nakakan wo narorenol me ? ");
INSERT INTO bqj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Manur mamu ni buru : Jikan me wo Aláemit arorenul me ᵽe jiban, n’juoh : “Wóli uroka gúfuh jom ; jikakan wo jíari me jikan.” » ");
INSERT INTO bqj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nemme Yésu bújaor naam ni bo mbaa Yérusalem, náni n’égat n’etut mof mamu maa Samari ni maa Gálile. ");
INSERT INTO bqj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","No nalof me ésuh ece, ni baj bugan gono guñen bugo háhae ejoge guilo ráli ");
INSERT INTO bqj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","n’gulob fatiya guoh : « Yésu, afan ahu, enili erumóli ! » ");
INSERT INTO bqj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Náallo alujil naagil : « Jujow bi n’uteŋenaaw min gujugul ! » Ban no guomme n’ejow yay, n’guhoy bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ace ni bugo, no najuh me búoh nahohoy, náveloul ábbañul, ban nanamo esal fatiya Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naya gújul to n’guot Yésu násilen bi n’ettam nasalol nímoro. Kan o an ala Samari om. ");
INSERT INTO bqj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ñer Yésu naah : « Leti bugan gono guñen guyabe gahoy ? Ñer bugagu gaamme futoh ni gubbagir, ubugelo ? ");
INSERT INTO bqj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wa uĉile bugagu gubbañulat gúkail esal Aláemit, min til ajaora ahume o ábbañul bare ? » ");
INSERT INTO bqj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aban naagol : « Uilo ujow ; gáineni guᵽageni ! » ");
INSERT INTO bqj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Eᵽárisie yay n’guroren Yésu nay Jávi Aláemit jijae me éjoul. Naagil : « Jávi Aláemit juñumut éjoul an aluj jo maa táh. ");
INSERT INTO bqj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Guñumut eoh : “Juluj, uje !” ter “Juluj, ujua !” Jiffas búoh Jávi Aláemit uju n’etulul. » ");
INSERT INTO bqj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aban naah ulagorol : « Tinah talu ᵽan tiĉigul to jijae me emaŋ jujuh Añol Arafuhow mele funah fanur, bare mati jujugol. ");
INSERT INTO bqj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ᵽan guogul : “Juluj taute ! Juluj tautua !” Bare niegul : Jambi jikebo, jambi jilagenil ! ");
INSERT INTO bqj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jiffas búoh funah fafu fo Añol Arafuhow ajae me éjoul, ᵽan ájoul ti baijer émit bo nihi bujaŋen me émit galam bi ni gagu. ");
INSERT INTO bqj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bare naate amundum álam nár, ᵽan bugan bugagu bugaa jama gulalol. ");
INSERT INTO bqj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ti ni gunah gagu no Nóe aamen me m’buroŋ, mamu may ᵽan ní mee funah ébbañul yay yal Añol Arafuhow. ");
INSERT INTO bqj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bugan bugagu fitiñ ni marem, búyab ni búyabo guomene, bi funah fafu fo Nóe anogen me ni busana babu bámah babu : no ñer báyuer mal mamu bámah babu biĉilo me min binemen bugagu bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ᵽan nogor may ti no Lot aamme m’buroŋ : bugan bugagu fitiñ ni marem, funnom ni funnomen, buroh ni gateᵽ guomene. ");
INSERT INTO bqj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bare funah fafu fo Lot áᵽullo me Sodom, sambun ni sival sajejeh ni súloul n’émit sinemen bugagu bugo ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Manur mamu mujae mee ebaj funah fafu fo Añol Arafuhow ajae me éraŋul. ");
INSERT INTO bqj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Funah faufu, an ajae me éni ni firihinjaŋ yaŋol, jamb’áavul bi eŋar wañol ñáraru balama atey, mo may ahu ajae me éni n’ulah waw, jamb’aot me mbaa yaŋol. ");
INSERT INTO bqj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Juosen wabaj me aar Lot ! ");
INSERT INTO bqj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","An alih me eᵽagen buroŋol, ᵽan ábbur bo, bare an ábbur me bola, ᵽan abaj buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Injé ilobul yo, n’efuga yauyu bugan gúuba gúni me ni bura banur, ahu ᵽan ájaenumi, ahuo nahali to. ");
INSERT INTO bqj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Waare gúuba ᵽoᵽ gúni me n’étuŋ tiñ tanur, ahu ᵽan ájaenumi, ahuo nahali to.  ");
INSERT INTO bqj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wáine gúuba may gúni me n’eañ, anur ᵽan ájaenumi, ahu nahali to. » ");
INSERT INTO bqj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ulagorol n’guogol : « Afanóli, dáuru tay jae mee ebaj ? » Naagil : « To efuluŋ yay ejae me éni, to may súgutum sasu sijae me eomunor. » ");
INSERT INTO bqj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mbiban, Yésu nalobil búnogor baube bi egitenil búoh guote nihi gulaw nánonan m’bállelenut. ");
INSERT INTO bqj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naagil : « Bajene n’ésuh ece ataliŋa áhollut Aláemit, ban ákanumut ánoan. ");
INSERT INTO bqj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bajen dó ᵽoᵽ atiña-ebara ace, nd’aful n’éjoul ákail atogol tima nataliŋil o ni ace ; nah’aagol : “Utaliŋóli !” ");
INSERT INTO bqj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Gunah ni gunah ataliŋa ahu nah’alat, bare búsol naagoro : “Maagen, íhollut Aláemit, ban ᵽoᵽ íkanumut ánoan, ");
INSERT INTO bqj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bare nemme atiña-ebara ahumu umu n’eyogenom, ᵽan ibbañenol bakoŋol, let mo, mat’ahat éjoul yay iki afumom fuhow.” » ");
INSERT INTO bqj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ataw natajen aagil : « Juuwun me balober ataliŋa ahumu aĉolut mee ! ");
INSERT INTO bqj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Min ᵽiaŋ Aláemit añumut esen bakoŋ bugo naĉob me, gavogeol me etufunaha ni efuga tima narambenil ? Ᵽan ᵽiaŋ aŋaen éttunil ? ");
INSERT INTO bqj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Injé ilobul yo : ᵽan asenil bakoŋ ni majase. Bare no Añol Arafuhow ajae me éjoul, ᵽan ᵽiaŋ atoh ni mof bugan gáinene ? » ");
INSERT INTO bqj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yésu natajen alobil búnogor baube mala bugan guce gajogoroe me bugan gaĉole bújoŋor Aláemit, ban nihi guĉotihen bugagu. ");
INSERT INTO bqj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Naagil : « Baje wáine gúuba gakae ni gávi-Aláemit gagu bi galaw : ahu Aᵽárisie, ahuo ayaba-búalen. ");
INSERT INTO bqj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aᵽárisie ahu náᵽur jola nalaw jaa guiloilo aah : “Aláemit, nisali mala min íniut me ti bugagu gaamme úku, ukana-maarat ni sujobu, ter ti ayaba-búalen ahumu. ");
INSERT INTO bqj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fíiyay bi ni fupafo, nih’iowor ñono ñáuba, ban nisenesen ᵽoᵽ gakib ganur ni wono guñen ni wánowan wo nibajulo me.” ");
INSERT INTO bqj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bare ayaba-búalen ahu o nailo ráli, hani eteben gúĉilol mbaa fatiya akañenut, najoh ni garab min aĉagor naah : “Aláemit, enili erumom, ínje aamme atila.” » ");
INSERT INTO bqj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yésu naagil : « Injé ilobul yo, áine ahume nabbañulo bi yaŋol majamore n’Aláemit, búli n’ahumua. Niege : ánoan atebenoro me ᵽan aaleni, bare ahu aalenoro me, o, ᵽan atebeni. » ");
INSERT INTO bqj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bugan bugagu nihi gúŋarul uñiaw gaputi me min Yésu agoril. No ulagorol gujuh me dáuru, n’gunamo ennuril. ");
INSERT INTO bqj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ñer Yésu nálofenul uñiaw aban naah : « Jihat uñiaw n’gújoul mbal ínje ! Jambi jífirenil yo, mata Jávi Aláemit bugan bugagu gáni me ti bugo guĉil jo. ");
INSERT INTO bqj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Maagen, ínje ilobul yo : an ayabut me Jávi Aláemit ti añil ayab jo me, an ahumu mát’ámus anogen dó. » ");
INSERT INTO bqj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Afan Esúif yay ace naah Yésu : « Aligena-bugan ahu ásum me, wa níarie ikan min iyab buroŋ bábaerit ? » ");
INSERT INTO bqj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yésu naagol : « Nuvogom bu ? Asúm me ? Nuffase dóemme wa ? Bajut an ásume íni let Aláemit o bareol. ");
INSERT INTO bqj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yoo. Leti nuffase gúboñ gagu gaah me : “Jamb’ufilen anaare o jíyavut ; jamb’umuh an ; jamb’úkuet ; jamb’ubij uteh apali ; úkanum ᵽai ni jai.” » ");
INSERT INTO bqj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aíne ahu naagol : « Dáuru ᵽe níkanumdokanum kábiriŋ ínje añil. » ");
INSERT INTO bqj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","No naun me gurim gaugu, Yésu naagol : « Ŋañoi ekan waf wanur : unnomen wo nubaj me ᵽe, uban nuŋar síralam sasu usen galeh me ; mamu ᵽan ubaj fubaj n’émit ; mbiban nújoul ulagenom. » ");
INSERT INTO bqj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","No áine ahu aun me gurim gaugu, nágogor mata kakan an abaje faŋ. ");
INSERT INTO bqj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","No Yésu ajugol me ágogor, naah : « Min táñi me asanum enogen ni Jávi Aláemit ! ");
INSERT INTO bqj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Faŋe ésum eñokombo élu ni gasun éguje éᵽur babu asanum enogen ni Jávi Aláemit ! » ");
INSERT INTO bqj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bugan bugagu gautteneol me n’guoh : « Ay ᵽiaŋ ñer ájue ayab gaᵽah ? » ");
INSERT INTO bqj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yésu naagil : « Wo bugan gújuut me ekan, Aláemit o nájue. » ");
INSERT INTO bqj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ñer Ᵽier naagol : « Uluj, wóli hum ubuge min jihatulo wafóli ᵽe min jilageni. » ");
INSERT INTO bqj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yésu naagil : « Maagen, ínje ilobul yo : Iní me an nahale yaŋol, aarol, gutiol, ubugaol, guñolol mala Jávi Aláemit, ");
INSERT INTO bqj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ᵽan abaj jálo faŋ wo nábbur me ni buroŋ babu baa jama, ban ᵽoᵽ ᵽan ayab buroŋ bábaerit gáyil gace gájaeul. » ");
INSERT INTO bqj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yésu navoh ulagorol gaamme guñen ni gúuba, aban naagil : « Juutten, ban ujaal bi Yérusalem, bo wo uboñer waw guhiĉ me ᵽe guya n’Añol Arafuhow ujae me ekano. ");
INSERT INTO bqj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ᵽan gubenol ni guñen gaa bugan bugagu galet me Esúif, ᵽan gujelol n’gúlatienol, ban n’gumasenol. ");
INSERT INTO bqj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ᵽan gutegol gusoh gal ubaŋ, guban n’gumugol. Bare funah fúfatten, ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bare ulagorol gujogut wáfowaf ni gurim gaugu mata gumomoĉ n’uinumil ; yo eĉil me gújuut guffas wa Yésu aamil n’elob. ");
INSERT INTO bqj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","No Yésu alof me ésuh yay yaa Sériko, ni baj ápima ace anamoe galam bulago babu náni n’gúcin. ");
INSERT INTO bqj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Apíma ahu naun fuyoŋ fafu min fúgale me, naroren wa ubaje. ");
INSERT INTO bqj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","N’gugitenol búoh Yésu ala Nasaret aam to n’égat. ");
INSERT INTO bqj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ñer naah fatiya : « Yésu, Añol David, enili erumom ! » ");
INSERT INTO bqj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bugan bugagu gayab me gayoŋ n’gunnurol n’guogol aᵽanor, bare aĉila nafaŋ nalobe fatiya aah : « Añol David, enili erumom ! » ");
INSERT INTO bqj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ñer Yésu nailen aban naboñ guŋarulol o. No ápima ahu alofulo me, Yésu narorenol : ");
INSERT INTO bqj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","« Wa numaŋe ikani ? » Naagol : « Ataw, ukan min ibbañ ijuh. » ");
INSERT INTO bqj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ñer Yésu naagol : « Ubbañ ujuh, gáineni guᵽageni. » ");
INSERT INTO bqj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","To baenah nabbañ ajuh, aban nalagen Yésu n’esal Aláemit nímoro. No fuyoŋ fafu ᵽe fujuh me dáuru, ni funamo may esal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","No Yésu anogen me Sériko, najow bi esat ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bajen dó asanum ace gajaol Saĉe ; o afan uyaba-búalen om. ");
INSERT INTO bqj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naliᵽ bi effas ay ni bugo aamme Yésu, bare nemme kakan an areore, ájuut ajugol mala fuyoŋ fafu falageneol me. ");
INSERT INTO bqj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ñer natey ayab gayoŋ ak’ajiŋ ni bununuh bice bi ejuh Yésu, mata to najae égat. ");
INSERT INTO bqj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","No Yésu aĉilo to me, náarul gúĉilol aban naah Saĉe : « Uávul ni majase, mata jama yaŋi nijae ealen. » ");
INSERT INTO bqj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ñer Saĉe náavul ni majase, aban nájaenumol bi yaŋol n’ésumay ró. ");
INSERT INTO bqj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","No bugan bugagu gujuh me dáuru, bugo ᵽe n’gúmumunor guoh : « Nakae aalen yaŋ atila. » ");
INSERT INTO bqj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","No guĉih me, Saĉe nailo bújoŋor Ataw naagol : « Uuttenom, afanom, ᵽan igabor fubajom gugab gúuba, mbiban nigabor galeh me fafu fugab. Mb’íni me ter nígotore ace, ᵽan ilugenol ñabbagir wo niŋarol me. » ");
INSERT INTO bqj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yésu naagol : « Jama Aláemit naᵽagene yaŋ ye, mata áine ahume maagen gabulaken gom may gal Aburaham. ");
INSERT INTO bqj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Maagen mamu, Añol Arafuhow najoulojow bi eŋes ni eᵽagen gallim me. » ");
INSERT INTO bqj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nemme Yésu nalofe Yérusalem, bugan bugagu guᵽinore búoh Jávi Aláemit ᵽan jíraŋul to baenah ; ñer natajen alob gautteneol me búnogor baube. ");
INSERT INTO bqj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naagil : « Baje ánaine áᵽullo ni fiil faa bugan búgamah aam n’ejow bi n’ésuh ece yáralie iki gúvienulol bo, aban nábbañul. ");
INSERT INTO bqj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Balama akay, návogul urokaol gono guñen nasenil ánoan efaraku yal éurus naagil : “Jikan so min subugor bi no nijae me ébbañul.” ");
INSERT INTO bqj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bare bugal ésuh áine ahumu ásumutil hani, n’guboñ gahoŋen bi ni gajae me évienol bi eogil bugo gumaŋut áni áviil. ");
INSERT INTO bqj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bare bae návienuli bo min áolul. No naĉilo me, navoh urokaaw bugo nasen me síralam sasu bi effas wa ánoan aroke ni sola. ");
INSERT INTO bqj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Atíar naĉigul naagol : “Afanom, ínje efaraku yay yo nusenom me ebugore sice sono guñen.” ");
INSERT INTO bqj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naagol : “Yoo, aroka ahu áari me, nemme nuĉole n’ekan waf wauwu watiti me, ban ibaŋi ni fuhow súsuh sono guñen.” ");
INSERT INTO bqj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aútten naĉigul naagol : “Afanom, efarakui ebugore sice sono futoh.” ");
INSERT INTO bqj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naagol : “Aw may, ban ibaŋi ni fuhow súsuh sono futoh.” ");
INSERT INTO bqj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ace aroka nájoul naah : “Afanom, efarakui uye ; ni garocob nítugen yo iŋar ibaŋ. ");
INSERT INTO bqj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nemme aw an átañie, níholiholi. Nuŋareŋar waf walet úiya, nuᵽileᵽit wo nurogut.” ");
INSERT INTO bqj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ñer ávi ahu naagol : “Aroka ahu aarat me, gurim gagu go nulob me, go mb’iŋar me min itegi. Nuffasene búoh ínje an átañie, o nah’aŋar waf walet wola, naᵽit wo narogut. ");
INSERT INTO bqj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ñer wa uĉile efarakuom uŋarut yo ubaŋ ni garoke me ni síralam ? Ti nibbanno maa, ᵽan íᵽunnenul yo ni wo ebugor me.” ");
INSERT INTO bqj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mbiban, ávi ahu naah bugan bugagu gaamen to me : “Jiram efaraku yauyu n’guñenol jíbahen jisen ahu abaj me sono guñen !” ");
INSERT INTO bqj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","N’guogol : “Afanóli, ahumu hum nabaje sammeŋe !” ");
INSERT INTO bqj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naagil : “Injé ilobul yo : an ajoh me wári wo nabaj me, ᵽan ayab faŋ to, bare an ajogut me wári wo nabaj me, o ᵽan guramol ᵽee, hani bi ni jo náhagum me ró. ");
INSERT INTO bqj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mala ulatorom gamaŋenut me íni áviil, jiŋarulil bi tale bújoŋorom, mbiban n’jiramulil.” » ");
INSERT INTO bqj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","No Yésu alob me gurim gaugu aban, nayabil gayoŋ min áfaro ejaol mbaa Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","No nalof me súsuh sasu saa Betufage ni Betani galam firijaŋ fafu fo guvoge me fal uoliv waw, naboñ ulagorol gúuba guyabol gayoŋ. ");
INSERT INTO bqj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Naagil : « Jujow bi n’ésuh yay yaamme gayoŋul. Jiĉih me, ᵽan jujuh jusum jahogihoh jo ᵽan an aremborerut. Jíjalul jo jíŋarul. ");
INSERT INTO bqj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Iní me an narorenul aah : “Wa uĉile n’jijal jo ?” Mbi juogol : “Ataw asohola jo.” » ");
INSERT INTO bqj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ñer bugo naboñ me n’gukay, ban ni gutoh waf waw ᵽe ti Yésu alob yo me. ");
INSERT INTO bqj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","No guomme n’ejal jusum jaju, bugala jo n’guogil : « Wa uĉile n’jíni n’ejal jusum jaju ? » ");
INSERT INTO bqj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","N’guogil : « Ataw asohola jo. » ");
INSERT INTO bqj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mbiban n’gúŋarul jo iki gusen Yésu ; n’guŋar újuoil guremben ni jo, guban n’gujingen dó Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Min ajae me, mo may bugan bugagu gutale me újuoil ni bulago babu. ");
INSERT INTO bqj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Min Yésu álofeul me Yérusalem ni bulago babu baavulo me ni firijaŋ fafu fal uoliv waw, fuyoŋ fafu fal ulagorol ni funamo esal fatiya Aláemit n’ésumay ró mala wajureruti me ᵽe wo gujuh mee. ");
INSERT INTO bqj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","N’guoh : « Aláemit ásonien ávi ahume ájaeul me ni gajow Ataw ! Gásumay gúni n’émit, ban gasal gúni n’Aláemit aamme fatiya ! » ");
INSERT INTO bqj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ñer Eᵽárisie guman gaamen dó ni fuyoŋ fafu n’guoh Yésu : « Afan ahu, uoh ulagorai guᵽanor ! » ");
INSERT INTO bqj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bare Yésu naagil : « Injé ilobul yo, íni me guᵽanore, sival sasu faŋaso ᵽan siŋan ! » ");
INSERT INTO bqj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","No Yésu alof me ésuh yay iki aŋanden yo, naĉagor mala yo ");
INSERT INTO bqj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aah : « Uffasen me aw ᵽoᵽ jama yauye wáju me useni gásumay ! Bare nemme maer ukokoᵽ, újuut ujuh wo ! ");
INSERT INTO bqj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Fubaŋuti, gunah guce ugu bo n’éjoul no ulatori gujae me esoeni gúharo, guban n’gúgoli min gunonuli ulam waw ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ᵽan gunemeni, aw ni bugani. Hani eval yanur guñumut yo ehat néjutenor n’ece ; dáuru ᵽe mata útallout no Aláemit ajoulo me bi eᵽageni. » ");
INSERT INTO bqj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","No Yésu anogen me ni gávi-Aláemit gagu, nanamo eham unnomenaaw gaamen dó me ");
INSERT INTO bqj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","naagil : « Bahiĉer babu buoge : “Yaŋom ᵽan éni yaŋ yaa galaw.” Bare buru n’jíbahen yo éni fíemorum fal úku. » ");
INSERT INTO bqj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Funah-ó-funah, Yésu nah’avare ni gávi-Aláemit gagu. Ufan uteŋenaaw, úᵽajula gúboñ Aláemit bugagu ni bugan bugagu búgamah bugal Esúif yay n’guliᵽ bi emuh Yésu, ");
INSERT INTO bqj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bare guffasut bu guñum ekan, mata fítiman fafu ᵽe gunnuil ᵽe n’aĉila gubet go. ");
INSERT INTO bqj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Funah fice, Yésu náni n’gavare ésuh yay ni gávi-Aláemit gagu, nah’agitenil Firim fafu Fásum me. Ᵽiout, ufan uteŋenaaw, úᵽajula gúboñ Aláemit bugagu ni ufan ésuh yay n’gufaen guĉigul. ");
INSERT INTO bqj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","N’guogol : « Ulobóli ᵽaa, sembe say nubaj mee sal ekan wo nukane mee, ay aseni sembe sausu ? » ");
INSERT INTO bqj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Naagil : « Injé may nibaje suroren sal erorenul : ");
INSERT INTO bqj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoo, sembe sasu saa gábatise so Saaŋ Batis abaj me, bay súᵽullo : n’Aláemit ter ni an ? » ");
INSERT INTO bqj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bare n’gúbahulor guoh : « Uogal me n’Aláemit, ᵽan aagolal : “Wa uĉile ñer jíinenut ni o ?” ");
INSERT INTO bqj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ban may uogal me ni an sujoumulo, ésuh yay ᵽe ᵽan guralolal sival uk’uĉelal, mata gúinene búoh Saaŋ Batis aboñer aamene. » ");
INSERT INTO bqj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ñer n’gúbalol guoh guffasut. ");
INSERT INTO bqj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yésu naagil : « Yoo, ínje may mat’ilobul ni sembe say nikane mee waf wauwu. » ");
INSERT INTO bqj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ᵽúrto, Yésu nanamo elob ésuh yay búnogor baube : « Baje ace áine aroh úbiñu, aban nábahen wo asen ucokora-bíñu guogen mbi nihi gúᵽunnol fugabol ; mbiban nakay bújaor bajae eᵽio. ");
INSERT INTO bqj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","No tinah tiĉih me tal ealen mitiñ mamu, naboñ aroka bi ni gaogen me úbiñu waw, bi éyabul fugabol. Bare ucokora-bíñu bugagu n’guteh aroka ahumu, guban n’guhamol aot guñen gurakel. ");
INSERT INTO bqj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ala úbiñu waw nabbañ aboñ ace aroka, bare n’gutegol may, n’gujelol guban n’guhamol aot guñen gurakel. ");
INSERT INTO bqj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Afan ahu natajen aboñ aroka áfatten ; o mul n’gúbukenol, mbiban n’guhamol. ");
INSERT INTO bqj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ala úbiñu waw naah : “Bu nijae ᵽiaŋ ekan ? Uhalom min iboñ áᵽurom áamumma, níinene aĉila ᵽan gúkanumol.” Ñer naboñol ajow. ");
INSERT INTO bqj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bare ucokora-biñu bugagu no gujugol me o n’éjoul, n’guogoro : “Umu aĉil me gafumol. Ujaal umugalol, mamu gafumol ᵽan gúbbañul gúni gololal.” ");
INSERT INTO bqj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","N’gúᵽunnol gubelen tíyaŋ guban n’gumugol. » Yésu natajen aagil : « Ala úbiñu waw ñer bu nañum me ekan bugan bugaubugi ? ");
INSERT INTO bqj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ᵽan ájoul, mb’aĉigul namugil, aban nábahen wo asen guce. » No bugan bugagu guun me gurim gaugu, n’guoh : « Urú jambi baj ! » ");
INSERT INTO bqj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bare Yésu nailo alujil aban naah : « Bahiĉer baube wa bulobe no buoh me : “Ebírih yay yo uteᵽaaw gujunden me, yo ebbanno me éni yáamumma, yaĉil me yaŋ yay” ? ");
INSERT INTO bqj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Anóan ajae me eloŋen ébirih yauyu ᵽan alebbor, ban may ánoan o ejae me elo ni o, ᵽan epulujol. » ");
INSERT INTO bqj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ñer úᵽajula gúboñ Aláemit bugagu ni ufan uteŋenaaw n’gumaŋen ejoh Yésu to baenah mata guffase búoh molil nálobum mee búnogor baubu, bare n’gúholi ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ñer n’gunamo elujorol. N’guboñ bugan gukan ti bugan gáinene n’Aláemit gujow bi ni o bi ebelol gabbut ni suroren ; mamu ᵽan gúju ñer gujogulol gusen afan ahu aogen me mofil ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bugan bugaubugu n’guĉigul n’guogol : « Afan ahu, jiffase búoh gurimi ni bavareeri suĉoĉol. Ulujérit ni uul bugan bugagu, ban nuvareevare bulago Aláemit ni maagen. ");
INSERT INTO bqj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ulobóli ᵽaa ter sesen min búalen bucami ávi ahu ámah ahu Sesar. » ");
INSERT INTO bqj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bare Yésu nemme nátalloe gabbut gagu go guralol mee ni suroren sausu, naagil : « Jiŋallom ᵽaa éralam ! » N’guŋallol yo. Nabbañ aagil : ");
INSERT INTO bqj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","« Buul baube ni gajow gauge sal ay ? » N’guogol : « Saa Sesar. » ");
INSERT INTO bqj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ñer naagil : « Kan jisen Sesar wafol, ban may jisen Aláemit waamme wola ! » ");
INSERT INTO bqj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gubajut ñer fay mbi gújogumol me ni fo bújoŋor ésuh yay. Nemme gujahalijahali min ábalil mee, gubbañut gulob to fice firim. ");
INSERT INTO bqj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ni baj Esáduke guce gujow iki gutoh Yésu. (Esáduke yay bugo nihi guoh me an aĉet me aban mat’ailoul n’eĉet yay.) N’guogol : ");
INSERT INTO bqj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","« Afanóli, gúboñ gagu gaa Móis guoge an ayab me anaare mbiban naĉet ajundenol o m’babajut añil, atiol ᵽan atunol min áju ahalol gátuh. ");
INSERT INTO bqj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yoo. Bajene batiay baa wáine gono futoh ni gúuba. Atíar nayab aban naĉet o m’babajut añil. ");
INSERT INTO bqj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aútten ahu ");
INSERT INTO bqj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ni áfatten ahu n’gutunol anur-anur. Mamu may bugo ᵽe gaamme futoh ni gúuba guyab mee aare ahu, ban ni guĉet bugo ᵽe m’babajut añil ni o. ");
INSERT INTO bqj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ᵽúrto, aare ahu may naĉet. ");
INSERT INTO bqj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ban ñer juroreni : no gaĉet me gujae me eilo, ᵽan ñer áni aar ay ni bugo, nemme bugo ᵽe gutoge guyabol ? » ");
INSERT INTO bqj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yésu naagil : « Bugan bugaa babe n’ettam guyabeyab, gúyaboeyabo. ");
INSERT INTO bqj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bare bugan bugagu gajae me éjahor bújoŋor Aláemit min abbañenulil gúni m’buroŋ babu bájaeul me, mati guyab ter gúyabo. ");
INSERT INTO bqj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Guñumut ᵽoᵽ ebbañ guĉet, mata ᵽan til gúni ti emalakaay. Bugo guñol Aláemit bugom mala min gubbañulo me gúni m’buroŋ. ");
INSERT INTO bqj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Móis may nagitenolal ŋanno ca búoh gaĉet me ᵽan gúbbañul gúni m’buroŋ : ni Bahiĉer babu dó nalob me mala jufokon jaju jaa sijeŋ jaamme n’esa, navoge Ataw \"Aláemit o Aburaham, Isak ni Sakob gúinen me ni o\". ");
INSERT INTO bqj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ban Aláemit alet Aláemit ala gaĉet me, bare til ala garoŋ me. Maagen, n’aĉila hani gúfaji bugaubugi gaĉet me gukakan bugan garoŋe. » ");
INSERT INTO bqj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ñer guce ni úᵽajula gúboñ Aláemit bugagu n’guogol : « Afanóli, nulobe jon. » ");
INSERT INTO bqj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gubbañut gukañen erorenol suroren sice. ");
INSERT INTO bqj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ᵽúrto, Yésu naagil : « Wa uĉile ésuh yay nihi guoh Kirista Añol David nam ? ");
INSERT INTO bqj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David faŋaol naage n’élebur yay yal Ufóñ waw : “Ataw Aláemit naage Ataom : Unamo ni gañenom gárib ");
INSERT INTO bqj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bi no nijae me ekan ulatori gúni fírembenum guoli.” ");
INSERT INTO bqj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nemme David navogol \"Ataw\", bu Kirista ájue ñer áni Añol David tíj to ? » ");
INSERT INTO bqj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Min ésuh yay ᵽe guomme n’euttenol, Yésu naah ulagorol : ");
INSERT INTO bqj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","« Júludo úᵽajula gúboñ Aláemit bugagu, bugo nihi gubelo me újuo ujaha waave bi to n’guolil n’gujator min ésuh yay gujugil, bugo nihi gumaŋ me gusafil ni jammeŋ ni gákanum ró, bugo nihi gusommen me erobo ni sujukut sasu saa gayoŋ ni saŋ sasu saa galaw, bugo ᵽoᵽ nihi gurobo me ni sujukut sasu sáamumma gaggan babajer. ");
INSERT INTO bqj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ᵽan nihi gúgotor utiña-sibara bugagu min guyab wo gubaj me ᵽe, mbiban n’gunamo galaw huli min mbi ésuh yay gujogil bugan gaaro. Bakaner baubu ᵽan biĉilil n’guyab gúteh gafaŋe gaa bugagu ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ñer Yésu naluj aluj najuh usanum gúni n’ehalen dó nihi haleni me wo guŋarulo me bi éji Aláemit dó ni gávi-Aláemit gagu. ");
INSERT INTO bqj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Najuh ᵽoᵽ atiña-ebara ace alege faŋ aŋar múralam múuba ahalen dó. ");
INSERT INTO bqj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ñer Yésu naah : « Maagen, ínje ilobul yo : atiña-ebara ahumu aleh mee o afaŋe nasene bugan bugagu ᵽe gasen me ; ");
INSERT INTO bqj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mata bugagu ᵽe, wávaf me ni wo gubaj me, wo gutebulo gukan dó ; bare aĉila naŋar ni bilegol ró wo nabajen me ᵽe bi buroŋol akan dó. » ");
INSERT INTO bqj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ni baj bugan guce gunamo emalen gávi-Aláemit gagu, jáari sival sasu so gúsangen go me, ni jala waf waw wo gúji ró me Aláemit. Bare Yésu naagil : ");
INSERT INTO bqj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","« Tinah tice ᵽan tiĉigul no waf wauwu ᵽe wo jujuge maa jama ujae me éhunduli ubet ; mele eval yanur yájutenore n’epayo eñumut to eŋaño, bare so ᵽe ᵽan sirikuli sibet. » ");
INSERT INTO bqj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","N’guoh Yésu : « Afanóli, úru nay ᵽan baj ? Wa ujae egitenóli min jiffas tinah tautu to baĉigerul ? » ");
INSERT INTO bqj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Naagil : « Jikan to uinumul jambi gubutul. Bugan gammeŋe ᵽan guoᵽoroul gajaom guĉigul n’guogul : “Injé iomme Kirista, tinah talu tiĉige.” Bare jambi jilagenil. ");
INSERT INTO bqj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No jijae me eun gulob mala gutih, gáguo, jambi júholi. Dáuru díarie dumundum diĉigul ; bare mati faen ní to baenah gabao mof mamu. » ");
INSERT INTO bqj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aban natajen aagil : « Esúh ᵽan eiyul bi n’epayo ésuh, jávi ᵽan jiiyul bi ni jipajo jávi, ");
INSERT INTO bqj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ettam yay ᵽan egoror bagororer báholenie faŋ, ban bieb ni bíyih ᵽan síni n’ulam wammeŋe ; ᵽan ᵽoᵽ baj waf wájuhulenie faŋ, ban bujugum bámah ᵽan búᵽurul n’émit yay. » ");
INSERT INTO bqj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","« Balama dáuru ᵽe dibaj, ᵽan gujogul ni gúlatienul. Ᵽan gújaenumul iki gutaliŋ ni saŋ sasu saa galaw, ban ᵽan gúrurul ni fipeh ; gajaom ᵽan guĉil min gújaenumul bújoŋor úviaw ni ufan waw bugaa súsuh. ");
INSERT INTO bqj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","No ñer ᵽan júju me julob múmbam. ");
INSERT INTO bqj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jambi juyoh bo n’eramor jiliᵽ gurim gagu go jijae me ébalil bi éholoro, ");
INSERT INTO bqj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mata ᵽan isen utumul gurim gaa mujah go hani anur n’ulatorul mati áju eceŋ. ");
INSERT INTO bqj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hani ubugaul, gutiul, buganul ni ubugeul ᵽan gubelul ni guñen ulatorul ; ban ᵽan gukan gammeŋe ni buru n’guĉet. ");
INSERT INTO bqj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gajaom ᵽan guĉil min bugan bugagu ᵽe gulalul. ");
INSERT INTO bqj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bare hani gal ganur gala guhoul mati gullim ; ");
INSERT INTO bqj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","mbi jumuten iki bao, mamu ᵽan júju me jiyab buroŋ babu baa maagen. » ");
INSERT INTO bqj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","« No jijae me ejuh gútiman gal ekosombil gúgot Yérusalem, no ᵽan jiffas me búoh efumo yo elofe. ");
INSERT INTO bqj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ñer bugan bugagu gaamme Yúde mbi gutey mbaa gurijaŋ gagu ; gaam dó me ñáraru Yérusalem mbi gúᵽur gúhatulo yo, ban bugagu gaamme babu n’ulah waw gure bo jambi gúnonul n’ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gunah gaugu ᵽan gúni gunah gaa gúteh, mamu wo Bahiĉer babu bulob me ᵽe n’ukano. ");
INSERT INTO bqj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mataño míni ni waareaw gajae me éni ni gar ni ᵽoᵽ ni bugagu gajae me éni n’garafen ni gunah gaugu, mata sílam sámah ᵽan síavul n’ésuh yauyu mala bitiña-fiiñ Aláemit baya me ni bugala yo. ");
INSERT INTO bqj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Guce ni gaĉin dó me, ufoje ᵽan guŋar n’gumugil, bugaguil ᵽan gujogil emigel gújaenum ni súsuh sasu ᵽe. Bugan gaffasut Aláemit ᵽan guhah Yérusalem bi no tinagil tijae me ebao. » ");
INSERT INTO bqj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","« Ᵽan baj bujugum búᵽurul ni tinah talu, ni fieñ fafu ni ᵽoᵽ ni suut sasu. Súsuh sasu saa mof ᵽan síni n’gáholi gámah mala bateger fal fafu bájalo me nár ni baa gulongos gagu. ");
INSERT INTO bqj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Gáholi gámah ᵽan gumuh bugan n’gaᵽinor mala wajae me ebaj n’ettam yay, mata sembe sasu ᵽe saa fatiya ᵽan sugoror. ");
INSERT INTO bqj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","No ñer ᵽan gujuh me Añol Arafuhow áavul ni gápar, ni sembe ró ni bájalo sámah. ");
INSERT INTO bqj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","No dáuru ᵽe dijae me eĉigul, jíallo n’jíhaken, mata gaᵽah gagu golul gulofulolof. » ");
INSERT INTO bqj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mbiban Yésu nalobil búnogor baube : « Juluj bubah ni wawu ununuh ᵽe : ");
INSERT INTO bqj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","no jujuh wo úyaul úsabul, jiffase búoh fujam fulofulo. ");
INSERT INTO bqj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Manur mamu may, no jijae me ejuh waf wauwu ᵽe uĉigul, jiffas búoh Jávi Aláemit julofulo. » ");
INSERT INTO bqj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","« Maagen, ínje ilobul yo : bugan bugagu bugaa jama mati gutoh guĉet gubao dáuru ᵽe m’baĉigulat. ");
INSERT INTO bqj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Emít yay ni ettam yay ᵽan sibao, bare gurimom, go, mati gúmus gubao. » ");
INSERT INTO bqj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","« Júludo ! Jambi uinumul úguo n’ekan uggan bi gúhali ni ᵽoᵽ gaĉagor mala buroŋul babe n’ettam ; let mo, ᵽan funah faufu fúñagenul ; ");
INSERT INTO bqj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ᵽan fúloul ti embal ni bugan bugagu gaĉin me ni mof mamu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yo eĉil me, jiilo ni mujah ró ban n’jilaw nánonan, tima n’jibaj sembe sasu sal eᵽah waf wauwu ᵽe wajae me eĉigul, ni ᵽoᵽ sal eilo bújoŋor Añol Arafuhow. » ");
INSERT INTO bqj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Uĉigal me tufunah, Yésu nah’avare ni gávi-Aláemit gagu, mb’uĉigal ni fuh, nák’ámori ni firijaŋ fafu fal uoliv waw. ");
INSERT INTO bqj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ban ésuh yay ᵽe, uĉigal me m’bujom mej, n’gújoul gutoh Yésu ni gávi-Aláemit gagu bi euttenol. ");
INSERT INTO bqj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gaggan gagu gal unaĉ waw wabajut me lévir, go guvoge me Paak, gulofulo. ");
INSERT INTO bqj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ñer ufan uteŋenaaw ni úᵽajula gúboñ Aláemit bugagu n’gúni n’eŋes bu gujae me ekan ni mutuho ró n’gumuh Yésu, mata gúholiholi gailo ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ban Seytane nanogen Yudas o guvoge me may Isikariot, ace ni uᵽotoraaw gaamme guñen ni gúuba. ");
INSERT INTO bqj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas najow ak’alob n’ufan uteŋenaaw ni ufan ekosombil yay gapoe me gávi-Aláemit gagu, bu najae me ekan min Yésu alo ni guñenil. ");
INSERT INTO bqj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ñer ni súmil nár mala yo iki gulob esenol síralam. ");
INSERT INTO bqj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas namaŋ, aban náni n’eŋes no jáhor me ekan Yésu nalo n’guñenil ésuh yay m’baffasut. ");
INSERT INTO bqj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Funah fafu fal unaĉ waw wabajut me lévir ni fiĉigul, no gabbarum gagu gaa Paak nihi gúsimeni me. ");
INSERT INTO bqj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yésu naboñ Ᵽier ni Saaŋ naagil : « Jujow iki jucokor Paak yay min mb’utiñal yo. » ");
INSERT INTO bqj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","N’guogol : « Tay numaŋe jucokor yo ? » ");
INSERT INTO bqj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Naagil : « Juutten : No jijae me enogen n’ésuh yay, ᵽan jiemor n’ace áine átebul jifin jaa mal ; jilagenol iki junogen ni yaŋ yay dó najae me enogen, ");
INSERT INTO bqj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ban n’juoh ala yaŋ yay : “Afan ahu naage juroreni ni baŋ bay najae me etiñ Paak yay o ni ulagorol ?” ");
INSERT INTO bqj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ᵽan agitenul ñer fatiya yaŋ yay futoŋ fámah, dó ᵽan jutoh wo nusoholaal me ᵽe. Dó mbi jucokor me Paak yay. » ");
INSERT INTO bqj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","N’gukay, guĉih n’gutoh waf waw ᵽe may ti Yésu alobil yo me, min ñer gucokor fitiñ fafu faa Paak yay. ");
INSERT INTO bqj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","No tinah talu tiĉih me taa fitiñ, Yésu ni uᵽotoraol n’gunamo. ");
INSERT INTO bqj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naagil : « Jiffasut bu nimaŋ me itiñ Paak ye ni buru balama ílam ! ");
INSERT INTO bqj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Niegul, mat’ímus ibbañ itiñ yo bi no ejae me ekano joon ni Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ñer naŋar éremuma, nasal Aláemit aban naagil : « Jiŋar dáure jigabor ; ");
INSERT INTO bqj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","niegul, ᵽúrto jama mat’ibbander irem bíñu bi no Jávi Aláemit jijae me eĉigul. » ");
INSERT INTO bqj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mbiban naŋar ganaĉ, násonien go, namusulor go aban nagaboril go naagil : « Dáure enilom yaseni me molul. Jikan mo min ni’juosenom. » ");
INSERT INTO bqj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","No gutiñ me guban, nasenil may éremuma yay naagil : « Erémuma yauye yoemme físimom fajae me éyui molul bi eliŋen gajogor gagu guvugul gagu go Aláemit ajogor me ni buru. ");
INSERT INTO bqj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bare juluj : an ahu aamme n’ennomenom, ume atiñore maa n’ínje. ");
INSERT INTO bqj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maagen, Añol Arafuhow ban aĉet ti Aláemit ajoh yo me ; bare mataño mámah míni ni an ahu ajaol me ennomen ! » ");
INSERT INTO bqj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ñer uᵽotoraaw n’gunamo erorenor ay ni bugo ajae me ekan dáuru. ");
INSERT INTO bqj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ulagorol n’gunamo síceŋor bi effas ay ni bugo aat me ajogi ti afaŋil me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ñer Yésu naagil : « Uvíaw bugaa súsuh sasu guogenesowogen ni sembe ró, mbiban n’gumaŋ min guvogil ukana-maaro. ");
INSERT INTO bqj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bare buru jambi jíni ti bugo. Ᵽan til afaŋ me gájalo ni buru áni ti afaŋ me gatiti, ban aamme ni fuhow fafu áni ti aroka. ");
INSERT INTO bqj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nirorenul ay afaŋ me gájalo : aamme ni fitiñ ter aseneol me atiñ ? Leti aamme ni fitiñ ? Yoo ! Injé hum ume aam maa n’etulul ti amigelul. ");
INSERT INTO bqj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Buru, buru juomme gamuten me mimanur n’ínje no táñiom me. ");
INSERT INTO bqj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yo eĉil me nisenul Jávi jaju juogen, ti may Ᵽayom asenom jo me, ");
INSERT INTO bqj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","min mbi jitiñ n’jirem tiñ tanur n’ínje ni Jáviom, ban n’jinamo ni sifenjeŋ úvi bi eogen guil gagu gal Israel gaamme guñen ni gúuba. » ");
INSERT INTO bqj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yésu naah Simoŋ : « Simoŋ, Simoŋ, uutten ᵽaa ! Seytane nácine mala min áju agorenul ti an nah’aey me bahager bi éᵽuren éful bo. ");
INSERT INTO bqj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bare nilalaw míya jambi gáinen gúralii. Ban no nujae me ébbañul mbal ínje, mb’utajen uinum gutii sembe. » ");
INSERT INTO bqj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naagol : « Afanom, to niilo maa nibamban dáh, hani ban unogen ni fipeh ter uĉet, wola. » ");
INSERT INTO bqj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yésu naagol : « Ᵽier, niegi maa, tale gajem m’bujom, balama gáin guoh, ᵽan uoh ñono ñáfaji uffasutom. » ");
INSERT INTO bqj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yésu nabbañ aah ulagorol : « No niboñul me m’baŋarut síralam, baet, sidala, baje ᵽiaŋ uce wo jibajut ? » N’guogol : « Bajut. » ");
INSERT INTO bqj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naagil : « Yoo. Bare maer, an abaj me síralam aŋar so, an abaj me baet aŋar bo, ban an abajut me gafoje, annomen bisimool min annom ganur. ");
INSERT INTO bqj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Injé ilobul yo, wo Bahiĉer babu bulob me buya n’ínje, uote ukano, min buoh me : “Guᵽinol ni ukana-maarat bugagu.” Ban walobi me ni Bahiĉer babu uya n’ínje, tinah wo tiĉige. » ");
INSERT INTO bqj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","N’guogol : « Afanóli, ufoje uwe úuba. » Naagil : « Uᵽiloe. » ");
INSERT INTO bqj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ñer Yésu náᵽur, aban najow bi ni firijaŋ fafu fal uoliv waw, ti naᵽi me nah’akan. Ulagorol n’gulagenol. ");
INSERT INTO bqj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","No naĉih me tiñ tautu, naagil : « Jilaw jambi julo ni gabut gaa Seytane ! » ");
INSERT INTO bqj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mbiban náhatuloil butum maageima garal gal eval, aban naya gújul min alaw ");
INSERT INTO bqj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","aah : « Ᵽaaya, umaŋ me, ᵽan ufaren éremuma yauye yaa sílam éraliom ! Bare mánoman níe, jambi wo ínje imaŋ me ukano, bare til wo aw umaŋ me. »  ");
INSERT INTO bqj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ñer ni baj amalaka aavulo n’émit áᵽullol bi etañol sembe. ");
INSERT INTO bqj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nemme gágogor gunonol, Yésu nafaŋ galaw iki ésuᵽaol neh’esot elo n’ettam ti gulas gaa físim. ");
INSERT INTO bqj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","No nalaw me aban, naiyul ábbañul mbal ulagorol, aĉigul natogil gúmori mala gádeum gaam ni bugo. ");
INSERT INTO bqj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naagil : « Wa uĉile n’jíni n’gámori ? Jiilo n’jilaw, jambi julo ni gabut gaa Seytane ! » ");
INSERT INTO bqj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yésu m’babanerut elob, ni baj fítiman fiĉigul. Yudas, aamme ace ni uᵽotoraaw gaamme guñen ni gúuba, o ayabulo gayoŋ ; nalof Yésu bi ecolol garab. ");
INSERT INTO bqj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ñer Yésu naagol : « Yudas, ecot yay nuom n’eŋar min unnomen Añol Arafuhow ? » ");
INSERT INTO bqj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","No ulagora Yésu gujuh me wajae me ebaj, n’guogol : « Afanóli, jiŋar ᵽiaŋ ufojeóli min jiham bugan bugaubugi ? » ");
INSERT INTO bqj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ñer ace ni gaamen to me ni Yésu nateh aroka afan uteŋenaaw ámah ahu, ban naᵽirih gannuol gárib. ");
INSERT INTO bqj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bare Yésu naah : « Jihame ! » Aban nagor gannu áine ahu min abbañen to ti tínien me. ");
INSERT INTO bqj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aban nábaho mbal afan uteŋenaaw ámah ahu, ufan upoya gávi gagu ni ufan ésuh yay gakelol me fujoh naagil : « Bu jujoulo mee n’ufoje ró ni sugol ti nihi jíkail me ejoh akana-maarat ? ");
INSERT INTO bqj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Funah-ó-funah ínje umuen ni buru dó ni gávi gagu, ban jujogutom. Bare tinah te, to tuomme tolul tom ni ᵽoᵽ taa Seytane, ávi emoĉ ahu. » ");
INSERT INTO bqj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","N’gujoh Yésu gújaenum bi yaŋ afan uteŋenaaw ámah ahu. Ᵽier nah’alagenil búsol ráli. ");
INSERT INTO bqj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","N’gusaen sambun n’etut fúlumet fafu, mbiban n’gunamo gúgot so. Ᵽier may nákail anamo to ni bugo. ");
INSERT INTO bqj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aroka ace aare najugol to nanamo me alof sambun sasu ; nalujol aluj naah : « Aíne ahumu may bugo ni’gujaor ! » ");
INSERT INTO bqj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bare Ᵽier naceŋol naagol : « Aare ahu, iffasutol. » ");
INSERT INTO bqj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ᵽúrto, ni baj ace ajugol naah : « Aw buru bugom. » Bare mul Ᵽier naah áine ahu : « Injé let wóli. » ");
INSERT INTO bqj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ᵽio maa, ace naĉimen aah : « Maagen, áine ahumu bugo bugom, mata an ala Gálile om. » ");
INSERT INTO bqj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ᵽier bae mul naah : « Aw iffasut wa numaŋe elob. » To baenah o baroŋer n’elob yay, gáin gagu n’guoh. ");
INSERT INTO bqj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","No ñer Ataw nábahoul aluj Ᵽier ; Ᵽier naosen firim fafu fo Ataw alobol me : « Balama gáin guoh jama, ᵽan uoh ñono ñáfaji uffasutom. » ");
INSERT INTO bqj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Náᵽur bi tíyaŋ aban nanamo ukoŋ ni sembe n’eteh mahat ró. ");
INSERT INTO bqj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ñer bugan bugagu gajoh me Yésu nihi gúfohulol n’gutegol. ");
INSERT INTO bqj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ᵽan ni’gufut buulol, mbiban n’gurorenol : « Ulobóli ᵽaa ay ategi ! » ");
INSERT INTO bqj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nihi ᵽoᵽ gulob sulob sammeŋe saa gújel guya ni o. ");
INSERT INTO bqj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","No tihalen me, fujoj fafu fataliŋe me ni fuomunor. Gaam dó me, bugo guomme ufan uteŋenaaw, úᵽajula gúboñ Aláemit bugagu ni ufan Esúif yay. N’guboñ gúŋarul Yésu bi to bújoŋor fujojil. ");
INSERT INTO bqj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mbiban n’gurorenol : « Ulobóli ᵽaa, aw uomme Kirista ? » Naagil : « Iogul me ey, mati jíinenom ; ");
INSERT INTO bqj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ban irorenul me, mati jíbahulom. ");
INSERT INTO bqj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bare maer ñer ᵽan Añol Arafuhow ak’anamo ni gañen gárib gal Aláemit-Sembe. » ");
INSERT INTO bqj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","N’guoh bugo ᵽe : « Kan hum aw uomme Añol Aláemit ? » Naagil : « Nemme buru julob yo : aĉila nem. » ");
INSERT INTO bqj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ñer n’guoh : « Usoholautal bagitener bice ! Wolal faŋaolal nuunale gurimol ! » ");
INSERT INTO bqj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mbiban, bugaa fujoj fafu n’guilo mimanur bugo ᵽe, guban n’gújaenum Yésu bújoŋor Ᵽilat. ");
INSERT INTO bqj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","No guĉih to me, n’gunamo etegol sulob n’guoh : « Aíne ahume jutogoltoh áni n’einnul ésuh yay jambi gucam búalen afan ahu Sesar, ban naage aĉila aamme Kirista, ávi. » ");
INSERT INTO bqj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ᵽilat narorenol aah : « Aw uomme ávi ahu ala Esúif yay ? » Yésu naagol : « Aw faŋai nulob yo uban. » ");
INSERT INTO bqj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ñer Ᵽilat naah ufan uteŋenaaw ni ésuh yay : « Ijugut gahajen gánogan go an ahume ahajene. » ");
INSERT INTO bqj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bare n’gufaŋ erondopenol ni sembe ró guoh : « Esúh yay naam n’eilen ni bavareerol, ni mof Esúif yay ᵽoomo, kábiriŋ Gálile bo najogulo me bi tale. » ");
INSERT INTO bqj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","No Ᵽilat aun me gurim gaugu, naroren ter áine ahumu an ala Gálile. ");
INSERT INTO bqj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","No guogol me ni mof mamu miĉila, mo Herod aamme ni fuhow mo, náᵽullo, naboñ gújaenumol gusen Herod. Ban Herod o baamer bo may Yérusalem gunah gaugu. ");
INSERT INTO bqj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","No najuh me Yésu, ni súmol nár, mata let jama naliᵽe ejugol mala wo naun me gulob guya ni o, ban namaŋene ajugol akan waf waunderuti. ");
INSERT INTO bqj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Narorenol suroren sammeŋe, bare Yésu ábalutol hani. ");
INSERT INTO bqj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ufan uteŋenaaw ni úᵽajula gúboñ Aláemit ubuguen to, ban n’gúnien to n’etegol sulob ni sembe. ");
INSERT INTO bqj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod ni ekosombilol ró nakanol suneni ; nanamo éfohulol ak’aŋar gájuo gaije salsal akanol, aban nabbañenol asen Ᵽilat. ");
INSERT INTO bqj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Fiĉila Ᵽilat ni Herod, gaᵽien me n’gúni ulator, gubbanno me gúni ubuge. ");
INSERT INTO bqj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ñer Ᵽilat návogul ufan uteŋenaaw, wawu ufan ni ésuh yay, ");
INSERT INTO bqj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","aban naagil : « Buru jiŋallom áine ahume n’juogom ésuh yay naam n’eilen. Maagen nirorenol bújoŋorul, ban ijugut n’aĉila hani gahajen ganur ni wo julob me ᵽe jiya ni o. ");
INSERT INTO bqj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ban Herod ᵽoᵽ ajugut ni o gahajen gánogan, yo eĉil me nabbañulolal o. Ŋannoŋanno búoh áine ahume akanut wáfowaf wájue uĉil namugi. ");
INSERT INTO bqj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ban iboñ gutegol, mbiban nihalenol. » ");
INSERT INTO bqj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kan ni gaggan gánogan gaa Paak, Ᵽilat nah’ahanulilhalen ace ni gaamme ni fipeh. ");
INSERT INTO bqj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","N’gúᵽib bugo ᵽe ni manur guoh : « Umugol nuhanulóli Barabas ! » ");
INSERT INTO bqj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas ahumu gupegolpeh mata ésuh yay nailene mbal ufan waw bugaa Rom gaogen me mofil, ban ᵽoᵽ namumuh an. ");
INSERT INTO bqj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nemme Ᵽilat gaᵽinorol ᵽe ehalen Yésu, nabbañ alob ni ésuh yay. ");
INSERT INTO bqj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bare nihi gúᵽib guoh : « Ubbaŋol n’ekurua ! Ubbaŋol n’ekurua ! » ");
INSERT INTO bqj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ñer Ᵽilat naagil áfatten : « Maarat may nakane ? Ijugut ni o wáfowaf wo nakane wájue ukan min amugi. Ban ñer iboñ gutegol, mbiban nihalenol. » ");
INSERT INTO bqj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bare n’gurondopenol n’éᵽib ró n’guogol abbaŋol n’ekurua. Maagen mamu úᵽibil n’uhekol. ");
INSERT INTO bqj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ñer Ᵽilat nasen gúboñ min mbi wo gumaŋ me ukano. ");
INSERT INTO bqj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Min ahalen áine ahu o guroren me, o gupegen me mala eilen ésuh yay ni jamuh an, aban nahat Yésu n’guñen ekosombilol min mbi gukanol ti ésuh yay gumaŋ me. ");
INSERT INTO bqj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","No guomme n’éjaenum Yésu bi jamugol, n’guemor n’ace áine ala Siren o n’ébbañul n’ulah, gajaol Simoŋ ; n’gujogol guban n’gukanol ni sembe nateb ekurua yay min ajow búsol Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Fítiman fámah faa bugan bugal ésuh yay ni ᵽoᵽ waare nihi fulagenol. Waareaw nihi guteh ugingil n’eĉagor dó mala Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ñer Yésu nábahoul mbaa waareaw ubugi, aban naagil : « Buru waare bugaa Yérusalem, jambi jukoŋ múmbam, bare til jukoŋ molul ni mala guñolul ; ");
INSERT INTO bqj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","mata gunah guce ᵽan guĉigul no bugan bugagu gujae me eoh : “Gubaj gásumay sumotombo sasu, waareaw gabugut me uñil ni gámusut me gurafen !” ");
INSERT INTO bqj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","No ñer bugan bugagu gujae me eoh : “Faŋe jáari gurijaŋ gagu gúhullo gulo ni wolal bi efogenolal gúharo !” ");
INSERT INTO bqj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Injé ilobul yo, gukan mo me ínje anogor me ti bununuh barondoŋ bo gusaene, ñer ᵽiaŋ bu ᵽan ní ni buru jáni mee ti ununuh wahahay ? » ");
INSERT INTO bqj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","N’gúni n’éjaenum uce wáine gúuba ukana-maarat bi emugil mimanur ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","No guĉih me tiñ talu to guvoge me \"tiñ taa gasen,\" n’gubbaŋil to éfajiil, ánoan n’ekuruaol ; ukana-maarat bugagu n’gubet Yésu n’etut, ahu n’gañenol gárib, ahuo n’gamayol. ");
INSERT INTO bqj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ñer Yésu naah : « Ammay, uboketil mata guffasut wa guom n’ekan. » Mbiban n’gulukor bisimool. ");
INSERT INTO bqj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Esúh yay ubuguen to n’guiye n’gúni n’eluj. Ufan Esúif yay nihi gúfohulol guoh : « Naᵽagene guce ; aᵽaa aᵽagenoro fuhool, íni maagen o aamme Kirista, o Aláemit aĉob me ! » ");
INSERT INTO bqj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ekosombil yay may n’gunamo éfohulol ; n’gulofol guban n’gusenol bíñu yafifir arem ");
INSERT INTO bqj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","guban n’guogol : « Iní me maagen aw uomme ávi ahu ala Esúif yay, kan uᵽagenoro fuhoi ! » ");
INSERT INTO bqj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bajene gurim gauge gahiĉi fatiya fuhool : « Dáre ávi ahu ala Esúif yay. » ");
INSERT INTO bqj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ace n’ukana-maarat bugagu nah’ajelulol dó fatiya ekuruaol aah : « Leti aw uomme Kirista ahu ? Uᵽagenoro fuhoi ni wóli ᵽoᵽ ! » ");
INSERT INTO bqj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bare ahuo nannurol naagol : « Aw ᵽiaŋ úhollut Aláemit, aw ayab maa gateh gagu ganur ni gola ? ");
INSERT INTO bqj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wola maagen bacam babu baa bakanerola nuyabae maa ; bare ahumu akanut maarat mánoman. » ");
INSERT INTO bqj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aban naah Yésu : « Yésu, mb’uosenom no nujae me enogen ni Jávii. » ");
INSERT INTO bqj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ñer Yésu naagol : « Maagen, ínje ilobi yo : Jama reor dó ᵽan úni manur n’ínje ni Aljana. » ");
INSERT INTO bqj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Maageima tufunah no tinah talu tillim mee. Mof mamu ᵽe ni míni n’emoĉ iki tinah títigo. Gábil gagu gámah gagu gaamme ñáraru gávi-Aláemit gagu bi eminden tiñ talu táñai me n’guĉaĉo n’etut go iki gúᵽubo. ");
INSERT INTO bqj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ñer Yésu naya gáᵽib gámah aah : « Ammay, ínje umu n’ebaŋ yaalorom ni guñeni. » No nalob me gurim gaugu aban, naalo. ");
INSERT INTO bqj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Afan ekosombil yay aamen to me, no najuh me dáuru ᵽe, nasal Aláemit aah : « Maagen, áine ahume an aĉole omene. » ");
INSERT INTO bqj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bugan bugagu ᵽe gajoulo me meŋ gúkail faluj, no gujuh me wabaj me, n’gúgogor bugo m’búot n’eteh ugingil ró. ");
INSERT INTO bqj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gaffas me Yésu ᵽe, ni waareaw ró galagenulol me kábiriŋ Gálile, n’guilo ráli nihi guluj wabaj me. ");
INSERT INTO bqj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Bajene ace áine gajaol Susef, o an ala ésuh Esúif yay yo guvoge me Arimate. Aíne ahumu kakan an ásume aban naĉol, ban nánien n’enah éjoul yay yaa Jávi Aláemit. Aĉila bugo guomme ni fujoj fafu fámah, bare ñañe aruhenut baᵽinorer babu ni bakaner babu baa gupalol gaam dó me ni fujoj faufu. ");
INSERT INTO bqj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aíne ahu aĉila najow ak’atoh Ᵽilat min ácinol efuluŋ Yésu bi efoh ; Ᵽilat namaŋ. ");
INSERT INTO bqj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ñer Susef náannul yo fatiya ekurua yay, nággub yo gábil, aban nabaŋ yo ñáraru fuyah fice fo guoge n’gacaĉ erijaŋ, dó an ámusut afogi. ");
INSERT INTO bqj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Funah faufu, fo fuomme fal ecokor wáari me bi etiñ fíiyay fafu fájaeul me gállim. ");
INSERT INTO bqj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Waareaw gáᵽullo me Gálile mimanur ni Yésu n’gujaor ni Susef iki gujuh fuyah fafu ni ᵽoᵽ gujuh bu efuluŋ Yésu ebaŋi ró nogor. ");
INSERT INTO bqj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mbiban, n’guot guke ecokor batiŋoa ni míĉir bi ekan efuluŋ yay. No fíiyail fiĉih me, n’gunamo n’gúelo, ti gúboñ Aláemit gulob yo me. ");
INSERT INTO bqj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Funah fítiar búsol fíiyay, waareaw n’guilo m’bujom mej gujow bi ni fuyah fafu faa Yésu ; n’ejail n’gújaenum batiŋoa babu ni míĉir mamu so gucokor me. ");
INSERT INTO bqj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","No guĉih me, n’gutoh fuval fafu fatojen me gánonum gagu fúbakeni fulaleni me. ");
INSERT INTO bqj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","N’gunogen dó, bare gutogut ró efuluŋ yay yal Ataw Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bugo ni gajahali gagu gaa gallim efuluŋ yay, wáine gúuba n’gúᵽullil gukano wañ wátuene par nuh’uij. ");
INSERT INTO bqj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Waareaw n’gúholi nár, mufaŋ n’gúsilen ; wáineaw n’guogil : « Wa uĉile n’jíni n’eŋes an ahu aroŋ me ni gaĉet me ? ");
INSERT INTO bqj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Alet tale, nabbañe áni m’buroŋ. Juosen wo nalobul me no naamen me Gálile, no nah’aagul me : ");
INSERT INTO bqj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Añol Arafuhow náarie alo ni guñen ukana-maarat min amugi n’ekurua, mb’uĉigal funah fúfatten nábbañul áni m’buroŋ.” » ");
INSERT INTO bqj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Maagen waareaw n’guosen gurim gaugu gaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","N’gúᵽurul ni fuyah fafu gujow guke egiten wabaj me ᵽe uᵽotoraaw gaamme guñen ni an anur, ni bugagu ᵽe gaam bo me. ");
INSERT INTO bqj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Waareaw ubugi bugo guomme Mari ala Magudala, Saan ni Mari jaw Saak. Bugagu waare gajaor me ni bugo n’gugiten manur mamu uᵽotoraaw. ");
INSERT INTO bqj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bare uᵽotoraaw n’gaᵽinoril bagitener waareaw kakan nan síyeut, min gulat éinenil. ");
INSERT INTO bqj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bare Ᵽier o nailo atey bi bo ni fuyah fafu. No naĉih to me áñuᵽ bi eluj, najuh ró útar bare. Mbiban náᵽurul aot mbaa yaŋol ni gajahali gámah ró mala dáuru ᵽe dabaj mee. ");
INSERT INTO bqj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ban funah faufu fanur fafu, ni baj ni ulagora Yésu guce gúuba gúni n’ejow mbal ésuh ece yo guvoge me Emaus. Eᵽúr Yérusalem bi bo ñagoe. ");
INSERT INTO bqj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","N’ejail n’gunamo elob mala wabaj me ᵽe gunah gaugu. ");
INSERT INTO bqj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bugo n’galolobor gaugu ni síceŋor ᵽoᵽ, Yésu natonnil min gúni n’ejaor ; ");
INSERT INTO bqj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","bare ni baj waf uĉil gúĉilil nihi gulujol mati gútallool. ");
INSERT INTO bqj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yésu naagil : « Mala wa jiceŋore mee buru n’ejow ? » Ñer n’guilen, ban uulil n’útañi. ");
INSERT INTO bqj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ace ni bugo, o guvoge me Kileopas, naagol : « Bugan bugagu ᵽe gaamen me Yérusalem guffase wabaj dó me gunah ge, ᵽúrdo aw nevoni pat ! » ");
INSERT INTO bqj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naagil : « Wa ubajene ? » N’guogol : « Wabaj me hum Yésu ala Nasaret. O aboñer oomene abaje sembe ni bakanerol ni gurimol bújoŋor Aláemit ni bugan bugagu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ufan uteŋenaolal ni ufan ésugolal gújaenumol iki gutaliŋ bataliŋ bal eĉet, ban ni gubbaŋol n’ekurua. ");
INSERT INTO bqj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wóli jíinene búoh o ajaene eᵽagen Israel, ban bi jama yauye baje ñer gunah gúfaji no dáuru ᵽe dibaje. ");
INSERT INTO bqj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Maagen waare guce ni gaamme ni wóli gukanóli gajahali faŋ : gujae jama ni bujom mej bi ni fuyah fafu, ");
INSERT INTO bqj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bare gutogut ró efuluŋol. No gubbanno me n’guogóli emalaka gúᵽullil dó n’guogil narondoŋ. ");
INSERT INTO bqj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ñer guce ni gupalóli gujojow bi bo ni fuyah fafu, ban ni gutoh waf waw ᵽe ti waareaw gulob yo me, bare bugo may, aĉila Yésu o gujugutol. » ");
INSERT INTO bqj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ñer Yésu naagil : « Maagen, buru bugan gájuut ejoh wáfowaf, ban n’jiŋay n’éinen waf waw ᵽe wo uboñer waw guᵽi me n’gulob ! ");
INSERT INTO bqj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kirista aarenat ᵽiaŋ amundum álam mamu, mbiban nanogen ñer ni gasalol ? » ");
INSERT INTO bqj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mbiban, nailo áᵽajulil walobi me uya ni o ni Bahiĉer babu ᵽe, újogul ni baa Móis bi ni baa bugagu uboñer ᵽe. ");
INSERT INTO bqj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","No gulof me ésuh yay dó ulagoraaw gujae me, Yésu nakan nan égat nan ni yo ; ");
INSERT INTO bqj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","bare n’gurondopenol n’guogol : « Upilul tale ni wóli, mata tinah títigoe, maer ni tujon. » Ñer Yésu napil anogen bi enamo to ni bugo. ");
INSERT INTO bqj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","No naamme n’etiñor ni bugo, naŋar ganaĉ gagu, nasal Aláemit, aban namusulor go agaboril. ");
INSERT INTO bqj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ñer to baenah gúĉilil n’gúpegulo min gútallool, bare nallim to bújoŋoril. ");
INSERT INTO bqj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ñer n’guogoro : « Leti nogorolanogor ti nihi sambun sisa me ñáraru sinilola, no nalobe mee ni wola m’bulago, náᵽajulola ᵽoᵽ Bahiĉer babu ? » ");
INSERT INTO bqj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ñer ulagorol gaamme gúuba n’gufaen guilo to baenah gubbañ mbaa Yérusalem. No guĉih me, n’gutoh bo uᵽotoraaw gaamme guñen ni an anur, tiñ tanur ni gupalil nihi guoh : ");
INSERT INTO bqj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","« Maagen, Ataw nabbannobbañ áni m’buroŋ ! Simoŋ najugol ! » ");
INSERT INTO bqj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ñer bugo may n’guilo gugitenil wabajil me m’bulago, ni may bu bugo gútallool me no namusulore me ganaĉ gagu bugo ni fitiñ. ");
INSERT INTO bqj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ulagoraaw m’babanerut egiten, Yésu faŋaol náᵽurul to n’etulil bugo ᵽe, aban naagil : « Gásumay gúni ni buru ᵽooul ! » ");
INSERT INTO bqj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gájuhulo ni etelenor yámah ni sunonil mata n’gaᵽinoril ayaul gujuge. ");
INSERT INTO bqj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bare Yésu naagil : « Wa uĉile n’júholi re me ? Wa uĉile n’jibaj sitehumor sausu ? ");
INSERT INTO bqj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Juluj guñenom ni guolom : injé om faŋaom ! Jimaenom min jujuh : ayaul nd’abaj enil ni suvul ti jujuh mee búoh ínje nibajsobaj ! » ");
INSERT INTO bqj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","O n’elob gurim gaugu, nañurenil guñenol ni guolol. ");
INSERT INTO bqj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nemme bi maer gúinenerut mala ésumay ni gajahali saamme ni bugo, naagil : « Jibaje ᵽiaŋ tale waf waa fitiñ ? » ");
INSERT INTO bqj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","N’guŋallol jítim jaa juol jasoisow. ");
INSERT INTO bqj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ñer naŋar jo aban natiñ jo to bújoŋoril. ");
INSERT INTO bqj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mbiban naagil : « Wo nilobul me no niomen me ni buru, mala walobi me uya n’ínje ni sílebur sasu saa Móis, ni Bahiĉer babu bal uboñer waw ni ᵽoᵽ bal élebur yay yal Ufóñ waw, wo ᵽe úariene ukano. » ");
INSERT INTO bqj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aban nápegul uinumil min ñer gúju gujoh wo Bahiĉer babu bulob me ");
INSERT INTO bqj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","naagil : « Hiĉihiĉ gaa búoh Kirista ᵽan álam, bare ᵽan ailo ni gaĉet me funah fúfatten. ");
INSERT INTO bqj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ban ᵽan guvare ni gajow gola min mbi bugan bugagu gúbahen bakaneril bi eyab gaboket gal util ni súsuh sasu ᵽe saa mof, újogum dáre Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Buru jamat me dáuru ᵽe, buru jijae me egiten yay. ");
INSERT INTO bqj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ban ínje faŋaom ᵽan íannul ni buru Biinum Banabe bo Ᵽayom alob me mala bo ; bare mbi jinamo dáre n’ésuh yay bi no jijae me eyab sembe sausu saa fatiya. » ");
INSERT INTO bqj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ᵽúrto, Yésu nájaenumil mbal ésuh yay yaa Betani, aban nateben guñenol fatiya min ásonienil. ");
INSERT INTO bqj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","O n’ésonien yay, natebor mbaa fatiya ahalil to. ");
INSERT INTO bqj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ñer bugo n’gúyaul to gújul n’esalol nímoro, mbiban n’gubbañ mbaa Yérusalem n’ésumay yámah ró. ");
INSERT INTO bqj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ban nánonan ubugi n’esalol ni gávi-Aláemit gagu.");
INSERT INTO bqj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ni fíĉilum fafu, Firim fubaje. Firim fafu ni fíni tiñ tanur n’Aláemit, ban Firim fafu Aláemit o faŋaol fom. ");
INSERT INTO bqj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Firim fafu n’Aláemit fuomene ni fíĉilum fafu. ");
INSERT INTO bqj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ni fiĉila Aláemit átulum me waf waw ᵽe, ban bajut uce wakani fo m’balet. ");
INSERT INTO bqj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Fiĉila furoŋen me waf waw ᵽe, ban buroŋ baubu bo buomme gajaŋa bi ni bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Gajaŋa gaugu n’gujaŋ n’emoĉ yay, ban emoĉ yay éggubut go. ");
INSERT INTO bqj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bajene an ace o Aláemit aboñulo, gajaol Saaŋ Batis. ");
INSERT INTO bqj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Najoulo bi egiten mala gajaŋa gaugu ; o mb’aĉil me min bugan bugagu ᵽe gubaj gáinen ni go. ");
INSERT INTO bqj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Let aĉila aamme gajaŋa gagu, bare bi egiten mala go najoulo mee. ");
INSERT INTO bqj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Gajaŋa gaugu go guomme gaa maagen, gafijigene me ánoan no guĉilo me ni mof. ");
INSERT INTO bqj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Firim fafu ufuen ni mof, ban ni fiĉila mof mamu mútulumi me ; bare til mof mamu mútallout fo. ");
INSERT INTO bqj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Funonulo n’ésuh fo, bare bugan bugagu bugala fo guyabut fo. ");
INSERT INTO bqj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ban gayab fo me ᵽe, dóemme gáinen me ni fo, fisenilsen sembe sasu sal éni guñol Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gúni me guñol Aláemit, dóemme let gabugi gal enil ter gamaŋ gace gal arafuhow guĉil dó, bare Aláemit faŋaol akanil n’gúni guñolol. ");
INSERT INTO bqj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Firim fafu ni fuŋar enil yal arafuhow min fúkail fiĉin n’etulolal, ni fimmeŋ gáji ni maagen. Ban nujugale bájalool ; bájalo babu biĉila nabaj bo mala min aamme Erímbani yay yal Aláemit Ᵽaaya. ");
INSERT INTO bqj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Saaŋ Batis nalobe bugan bugagu mala an ahumu aah fatiya : « Dáru aĉila o nilob mee mola ioh : “An ahumu ajae mee éjoul búsolom, o ayabom gayoŋ, mata namundom áni.” » ");
INSERT INTO bqj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ban wolal ᵽe nuyabale bímmeŋenum babu bola ; nuyabale gáji gunaᵽ gapago. ");
INSERT INTO bqj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aláemit ni Móis násenum me gúboñ gagu ; ban gáji ni maagen, so, ni Yésu Kirista siraŋulo. ");
INSERT INTO bqj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","An ámusut ajuh Aláemit ; bare Erímbani yay, aamme Aláemit ban najogor ni Ᵽaaya ti an anur, aĉila nakanolal min uffasalol. ");
INSERT INTO bqj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Funah fice, ufan Esúif yay n’gúboñul ufan uteŋenaaw ni ᵽoᵽ bugan bugaa fiil fafu faa Lévi kábiriŋ Yérusalem bi eroren Saaŋ Batis o aamme ay. ");
INSERT INTO bqj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Alalut ébalil, nalob ŋanno ca bújoŋoril ᵽe aah : « Let ínje iomme Kirista ahu. » ");
INSERT INTO bqj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","N’guogol : « Ñer aw uomme ay ? Aw uomme aboñer ahu Elí ? » Naagil : « Ilet aĉila. » N’guogol : « Aw uomme aboñer ahu o Móis alobóli me mola ? » Naagil : « A-a. » ");
INSERT INTO bqj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ñer n’guogol : « Aw uomme ay ? Ulobóli min mbi júju jíbal bugan bugagu gaboñulóli me. Wa nújue ulobóli míya ? » ");
INSERT INTO bqj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saaŋ naagil : « Injé iomme an ahu o aboñer ahu Esai alob me mola. Injé iomme an ahu o náh’áᵽib mee ni gafit gagu aah : “Jucokor Ataw bulago baĉolea !” » ");
INSERT INTO bqj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bugan bugaubugu bugo guboñulo me, Eᵽárisie bugom. ");
INSERT INTO bqj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","N’gubbañ gurorenol n’guogol : « Iní me ulet Kirista ahu, ulet Elí, ban ᵽoᵽ ulet aboñer ahumu, wa uĉile ñer núh’úbatise bugan bugagu ? » ");
INSERT INTO bqj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Saaŋ naagil : « Injé ni mal níh’íbatise bugan bugagu. Bare baje ace n’etulul o buru jiffasut ");
INSERT INTO bqj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","aam n’éjoul búsolom ; iᵽilout bi ejal ganew gadalaol. » ");
INSERT INTO bqj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dáuru ᵽe n’ésuh yay yo guvoge me Betani baj mee, yaamme ñagagu fal fafu fo guvoge me Suruden ; ni fal faufu Saaŋ náh’ábatise me bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tihalen fo, Saaŋ najuh Yésu o n’éjoul mbal aĉila, ñer naah : « Gabbarum gagu gal Aláemit uge, gáᵽurene me gatil gagu gaa mof. ");
INSERT INTO bqj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mola nilob mee no nioh me : “An ahu ajae me éjoul búsolom nafaŋom fúf mata o amundom áni.” ");
INSERT INTO bqj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ban ínje faŋaom iffasenutol, bare nikeloke íbatise ni mal bi ekan ésuh yay yal Israel min guffasol. » ");
INSERT INTO bqj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Saaŋ natajen aah : « Nijuge Biinum Banabe búavul n’émit ti gálab íkiil birembor ni o. ");
INSERT INTO bqj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No, iffasenutol, bare Aláemit aboñulom me íbatise ni mal, naagomseh : “An ahu o nujae me ejuh Biinum Banabe búavul iki birembor ni o, an ahumu ajae me ébatise ni Biinum Banabe.” ");
INSERT INTO bqj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ban ínje Saaŋ nijuhrójuh, yo eĉil me ñer nigiten búoh aĉila aamme Añol Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tihalen fo, Saaŋ nabbañ áni tiñ talu tanur tatu, manur ni ulagorol gúuba. ");
INSERT INTO bqj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","No najuh me Yésu áni n’égat, naah : « Gabbarum gagu gal Aláemit ugu. » ");
INSERT INTO bqj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ulagorol gaamme gúuba n’guun gurim gaugu, ban n’gulagen Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ñer Yésu nábahoul najuh búoh aĉila guom n’elagen naagil : « Wa jiliᵽe buru ? » N’guogol : « Rabbi (yaamme \"Aligena ahu\"), tay nuĉine ? » ");
INSERT INTO bqj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Naagil : « Jújoul, ban ᵽan jujuh. » N’gujow, ban may n’gujuh to naalen me ; ñer funah faufu n’gunamo to n’aĉila. Maageima tinah báruser, utaw batiñer uban. ");
INSERT INTO bqj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ace ni gaamme gúuba gaun me gurim gagu gaa Saaŋ, mbiban n’gulagen Yésu, gajaol Andere, ati Simoŋ Ᵽier. ");
INSERT INTO bqj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Namundum ak’atoh atiol Simoŋ naagol : « Wóli jujuge An ahu o Aláemit aĉob me » (yoemme Kirista ni gugerekay). ");
INSERT INTO bqj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aban nájaenumol bi ni Yésu. Yésu nalujol aluj naagol : « Aw uomme Simoŋ, añol Saaŋ ; ᵽan ivogi Kefas. » (Dóemme Ᵽier ni gugerekay, yaamme \"fuval\".) ");
INSERT INTO bqj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tihalen fo, Yésu najoh bi ejow mbaa mof mamu maa Gálile. N’ejaol naemor n’ace áine gajaol Fílip ban naagol : « Ulagenom ! » ");
INSERT INTO bqj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fílip ahumu an om ala Betusaida, ésuh yay bo ᵽoᵽ Andere ni Ᵽier gúᵽullo me. ");
INSERT INTO bqj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ñer Fílip nak’atoh apalol gajaol Natanael naagol : « Wóli jujuge an ahu o gulobe mee mola ni gúboñ gagu gaa Móis ni ᵽoᵽ ni bahiĉer bugagu uboñer, o aamme Yésu ala Nasaret, añol Susef. » ");
INSERT INTO bqj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael naagol : « Waf ᵽiaŋ waaro way újue úᵽurul Nasaret ? » Naagol : « Ujóul, ban ᵽan ujuh. » ");
INSERT INTO bqj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","No Yésu ajuh me Natanael min ájaeul mee, nalob mola aah : « An ala Israel ala maagen umu ; bajut ni o uce walet waa maagen. » ");
INSERT INTO bqj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ñer Natanael naagol : « Bu jáorum me nuffasom ? » Yésu naagol : « Injé imundum me ijugi no nuomen me fattam bífig babu, balama Fílip ákail avogi. » ");
INSERT INTO bqj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naagol : « Afanom, aw uomme Añol Aláemit, aw uomme ávi ahu ala Israel. » ");
INSERT INTO bqj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yésu naagol : « Nemme niegiseh nijugi fattam bífig babu, yo eĉil me núinen n’ínje ; ᵽan ujuh uce wafaŋe gájalo wauwe ! » ");
INSERT INTO bqj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Natajen aah : « Maagen, ínje ilobul yo : ᵽan jujuh émit yay épegulo, ban emalaka Aláemit ᵽan nihi gujiŋ n’gúavul fatiya Añol Arafuhow. » ");
INSERT INTO bqj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","No funah fúfatten fiĉih me, ni baj búyabo n’ésuh yay yaa Kana ni mof mamu maa Gálile. Jaw Yésu umuen to. ");
INSERT INTO bqj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yésu ᵽoᵽ guvogulolvoh, o ni ulagorol. ");
INSERT INTO bqj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","No gujuh me búoh bíñu yay ebaulo, jaol naagol : « Bíñuil ebae. » ");
INSERT INTO bqj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Naagol : « Aare ahu, yo nuogeom bu ? Tinagom turoŋe. » ");
INSERT INTO bqj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ñer jaol nábaho mbal urokaaw naagil : « Wáfowaf wo nalobul, n’jikan wo ! » ");
INSERT INTO bqj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ni baj to sibara sono futoh ni yanur, yánoyan ni eval eogi, saam to bi gaᵽoso Esúif yay ti mukanail mulob yo me ; yánoyan ni so ebaje butum sílitar ekeme (100). ");
INSERT INTO bqj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ñer Yésu naah urokaaw : « Jimmeŋen sibara sausu mal ! » N’gummeŋen so iki siyato toĉ. ");
INSERT INTO bqj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mbiban naagil : « Maer jíij ró iki jisen aĉil me fuhow gaggan gagu. » N’gúij iki gusenol. ");
INSERT INTO bqj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","No afan gaggan gagu ake me eĉoen mal mamu, ni kan bíñu. Najahali bay bíñu yauyu éᵽullo ; bare urokaaw gáijulo me mal mamu bugo guffase. Ñer navoh ayaba ahu ");
INSERT INTO bqj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","min aagol : « An níh’íni mee numundum úᵽuren bíñu yay yásum me usen sijaorai, mb’uĉigal búsol ésuh yay basitorer, núᵽunnul yásum me reto. Aw til nubaŋ yáamumma bi maer búsol ! » ");
INSERT INTO bqj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Bigitenum baubu bo Yésu akan mee baubu Kana ni mof mamu maa Gálile, bo buomme bigitenum bítiar baunderuti ni wawu ᵽe wo nakan me ; mamu nagitene bájalool, ban ulagorol n’gufaŋ éinen ni o. ");
INSERT INTO bqj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ᵽúrto, Yésu natos bi n’ésuh yay yo guvoge me Kaᵽerinaum, aĉila, jaol, gutiol ni ulagorol. N’gurobo bo gunah guman. ");
INSERT INTO bqj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","No gaggan gagu gal Esúif yay go guvoge me Paak gulof me, Yésu najow bi Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No naĉih me, natoh unnomena síbe, ubbarum ni sitalab, ni ᵽoᵽ utita síralam gunamo ró ni gávi-Aláemit gagu n’gúni n’ekan burokil. ");
INSERT INTO bqj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ñer naŋar gulaor alaw alaw ábahen fusoh, aban nahamil ᵽe gúᵽur tíyaŋ gávi gagu, manur n’ubbarum waw ni síbe sasu ; narikul muĉag utitaaw abet, síralamil ni sivisor, ");
INSERT INTO bqj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","aban naah unnomena sitalab bugagu : « Júᵽuren waf wauwu dáre ! Jambi jíbahen yaŋ Ᵽayom yaŋ yaa funnomen ! » ");
INSERT INTO bqj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ñer ulagorol n’guosen gurim gauge gaa Bahiĉer babu : « Aláemit, gamaŋ gagu go nimaŋ me yaŋi ᵽan gumugomc. » ");
INSERT INTO bqj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ñer Esúif yay n’guogol : « Waf waunderuti way nújue ukan bi egitenóli búoh nubaje sembe sasu sal ekan me ? » ");
INSERT INTO bqj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naagil : « Jufum gávi gauge, ban tale gunah gúfaji ᵽan ibbañ iilen go. » ");
INSERT INTO bqj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ñer Esúif yay n’guoh : « Símit úvi gúuba ni futoh ni yanur (46) gávi gauge guteᵽi, ñer aw nuoge ᵽan uilen go ni gunah gúfaji ? » ");
INSERT INTO bqj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kan gávi gagu go Yésu alobe mee mala go, dóemme enil yay yola. ");
INSERT INTO bqj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yo eĉil me, no nailo me ni gaĉet me, ulagorol n’guosen búoh nalobene gurim gaugu, ban ñer n’gúinen ni Bahiĉer babu ni ᵽoᵽ gurim gagu go naloben me. ");
INSERT INTO bqj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Gammeŋe n’gúinen ni Yésu no gujuh me waf waw ᵽe waunderuti me wo nakane bo me Yérusalem ni gaggan gagu gaa Paak. ");
INSERT INTO bqj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bare nemme bugo ᵽooil Yésu naffasil joon, afiumutil. ");
INSERT INTO bqj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Asoholaut min gulobol mala an, mata aĉila faŋaol naffase waamme m’biinum arafuhow. ");
INSERT INTO bqj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bajene ni gayoŋ Eᵽárisie yay afan Esúif yay ace, gajaol Nikodem. ");
INSERT INTO bqj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nájoul ni fuh ak’atoh Yésu naagol : « Afanom, wóli jiffase búoh Aláemit aboñuli bi egitenóli gaffas, mata an áfuh ájuut akan ti aw waf wauwu waunderuti mee Aláemit m’balet búsolol. » ");
INSERT INTO bqj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yésu naagol : « Maagen, ínje ilobi yo : An abbañut me abugi, mát’áju ajuh Jávi Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem naagol : « An bu nájue abugi áutten o báfanumer ? Ᵽan ᵽiaŋ abbañ anogen ni far jaol min abugi ? » ");
INSERT INTO bqj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yésu naagol : « Maagen, ínje ilobi yo : An abuguti me ni mal, abuguti me ni Biinum Banabe, mát’áju anogen ni Jávi Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wabugi me ni arafuhow, wo enil ; bare wabugi me ni Biinum Banabe, wo biinum bom. ");
INSERT INTO bqj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jamb’ujahali min iogi me : Jiaro jibbañ jubugi. ");
INSERT INTO bqj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Erús yay bánoban bo ébahen me, neteh ebbañen. Ᵽan uun bateger yo, bare mat’uffas bay éᵽureul ni bay eom n’ejow. Mamu níh’íni mee may ni ánoan abugi ni Biinum Banabe. » ");
INSERT INTO bqj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ñer Nikodem naagol : « Urú bu júe kano ? » ");
INSERT INTO bqj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yésu naagol : « Aw aamme aligena ámah dáure Israel, uffasut dáuru ? ");
INSERT INTO bqj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Maagen, ínje ilobi yo : Wóli julobeullob wo jiffas me, jigiteneulgiten ᵽoᵽ wo jujuh me, bare buru jilet n’eyab gurimóli. ");
INSERT INTO bqj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jíinenut me ínje baloberul mala waf waw waa babe n’ettam, bu jújue jíinen ínje baloberul ñer mala waa fatiya ? ");
INSERT INTO bqj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","An ámusut ajiŋ bi fatiya émit, bare baje an aavulo ró, aamme ínje Añol Arafuhow. ");
INSERT INTO bqj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ti Móis aŋar me enuhunjaŋ yay yaa mañ ahoh n’eom ailen bújoŋor ésuh yay baubu ni gafit gagu, mo may Añol Arafuhow ajai me ehoh n’eom atebeni mee, ");
INSERT INTO bqj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","min mbi ánoan áinen me ni o abaj buroŋ bábaerit. ");
INSERT INTO bqj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Aláemit namamaŋ bugan bugagu náar iki ájiil Añolol Erímbani yay, min mbi ánoan áinen me ni o jamb’ábbur bándor, bare abaj buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Maagen, let bi etaliŋ mof mamu Aláemit aboñulo mee Añolol, bare til bi eᵽagen mo. ");
INSERT INTO bqj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","An áinen me ni o, mat’ataliŋi. Bare an áinenut me ni o, bataliŋol bubae, mata o áinenut n’Añol Aláemit Erímbani yay. ");
INSERT INTO bqj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bataliŋ babu, bo buomme ube : gajaŋa gagu guĉiloĉih ni mof, bare bugan bugagu emoĉ yay gufaŋe n’gumaŋe, mata bakaneril buarat. ");
INSERT INTO bqj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maagen, ánoan akane maarat, gajaŋa nalale bujuh ; mat’amaŋ go elof jambi bakanerol buraŋ. ");
INSERT INTO bqj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bare til an ahu aamme ni maagen, o nah’alofgolof, mamu ᵽan jugi ŋanno ca búoh Aláemit áĉibbenol ni bakanerol. » ");
INSERT INTO bqj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ᵽúrto, Yésu ni ulagorol n’gujow bi ni mof mamu maa Yúde ; nanamo bo ni bugo ró, náh’ábatise bugan bugagu. ");
INSERT INTO bqj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saaŋ Batis, o náni babu n’ésuh yay yo guvoge me Ainon, yalof me yayu yo guvoge me Salim, náh’ábatise bo may, mata mal mimmeŋbommeŋ. Bugan bugagu nihi gújoul gutogol bo min ábatiseil. ");
INSERT INTO bqj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ni tinah tautu, Saaŋ m’bajogeruti ᵽan áruri ni fipeh. ");
INSERT INTO bqj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ni baj síceŋor tutor ulagora Saaŋ ni apalil Asúif ace mala mukanay mamu bi eᵽos enil ti bulagoil burorene yo me. ");
INSERT INTO bqj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","N’gujow iki gutoh Saaŋ min guogol : « Afanóli, nuosene áine ahu aamen me n’aw ñagagu fal fafu faa Suruden, áine ahu o nulob me mola ? Yoo, o may umu n’gábatise bugan, ban ésuh yay ᵽe ubugi n’etey mbal aĉila. » ");
INSERT INTO bqj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saaŋ naagil : « An ájuut abaj waf Aláemit m’basenutol wo. ");
INSERT INTO bqj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Buru faŋaul jimate no nioh me : “Injé ilet Kirista ahu, bare Aláemit naboñulomboñ iyabulol gayoŋ.” ");
INSERT INTO bqj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aĉil me áyava ahu, o aamme ayaba ahu ; ban abuge ayaba ahu o nah’ailo me alofol, nah’ababaj ésumay yámah o baunerol. Esúmay yauyu eomme n’ínje, ban maer uyu to n’gárira yo. ");
INSERT INTO bqj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aíne ahumu naate afaŋ najamoe, ínje niote ifaŋ níkasuloe. » ");
INSERT INTO bqj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","« An ahu áᵽullo me fatiya nafafaŋ bugan bugagu ᵽe. Ahu áᵽullo me n’ettam, ettam yay eĉilol, ban nah’alolob mala buroŋ be. An ahu áᵽullo me n’émit nafafaŋ bugan bugagu ᵽe, ");
INSERT INTO bqj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ᵽan nah’agiten wo najuh me ni wo naun me, bare an mat’ayab gurimol. ");
INSERT INTO bqj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bare an ayab go me ᵽan agiten mamu búoh Aláemit maagen nalobe. ");
INSERT INTO bqj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","An ahu o Aláemit aboñ me, gurim Aláemit nah’alob, mata Aláemit nammeŋenolmeŋen Biinum Banabe. ");
INSERT INTO bqj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ᵽaaya namamaŋ Añolol, ban nahahat waf waw ᵽe ni guñenol. ");
INSERT INTO bqj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","An áinen me n’Añolol ᵽan abaj buroŋ bábaerit ; an alat me éinen n’Añolol, mat’abaj buroŋ baubu, bare til bitiña-fiiñ Aláemit bujae eya ni o. » ");
INSERT INTO bqj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Eᵽárisie yay guune búoh Yésu nabajebaj ulagora iki faŋ Saaŋ Batis, ban nábatiseeilbatise. ");
INSERT INTO bqj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ban ni maagen mamu, let Yésu faŋaol náh’ábatise, bare til ulagorol.) ");
INSERT INTO bqj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","No Yésu aun me dáuru, náᵽur mof mamu maa Yúde ajow mbaa Gálile. ");
INSERT INTO bqj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ban balama aĉih bo Gálile, naate amundum asat mof mamu mo guvoge me Samari. ");
INSERT INTO bqj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Najow ak’aĉih ñer n’ésuh yay yo guvoge me Siĉar, dó Samari, lof galah gagu go Sakob asen me áᵽurol Susef. ");
INSERT INTO bqj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eháᵽa yay yaa Sakob dó yom. Yésu nemme bújaor babu bukanolkan nayoh, nak’anamo galam éhaᵽa yay. Maageima ñer tufunah. ");
INSERT INTO bqj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Tinah tautu, ulagorol bakaer n’ésuh yay funnom mitiñay. Ñer ni baj anaare ace ala Samari ákail gáij. Yésu naagol : « Ujíom mal irem. » ");
INSERT INTO bqj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aare ahu naagol : « Bu aw aamme Asúif újue urorenom marem, ínje an ala Samari ? » (Nalob mee mata Esúif yay gubajut garobo gánogan ni bugaa Samari.) ");
INSERT INTO bqj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yésu naagol : « Uffasen me gáji Aláemit, ni ᵽoᵽ an ahu aagei me újiol mal arem, aw ᵽan úcinenol bi marem, ban ᵽan aseneni mal maa buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naagol : « Alínom, uogenut wáfowaf waa gáij, ban éhaᵽa yay ésikisiki. Ñer bay ᵽan úŋarul mal maumu maa buroŋ ? ");
INSERT INTO bqj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nufafaŋ ᵽiaŋ ᵽayóli afan Sakob, asenóli me éhaᵽa yauye, ban aĉila faŋaol, guñolol ni sukoreol gurem dó ? » ");
INSERT INTO bqj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yésu naagol : « Anóan areme mal maumu, marem ᵽan mubbañ mujogol ; ");
INSERT INTO bqj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","bare an ajae me erem mal mamu mo ínje ijae me esenol, mati marem múmus mubbañ mujogol : mal mamu mo nijaol me esen ᵽan múbaho n’aĉila ébula mal dó buroŋ bábaerit bujae éᵽurul. » ");
INSERT INTO bqj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ñer aare ahu naagol : « Alínom, usenom mal maumu, tima marem jambi mubbañ mujogom, mamu mat’ibbañ íkail tale gáij. » ");
INSERT INTO bqj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Naagol : « Ujow, úk’úvogul áini, uban núbbañul bi tale. » ");
INSERT INTO bqj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aare ahu naagol : « Ibajut ánaine. » Ñer Yésu naagol : « Nulobe jon min uoh me ubajut ánaine : ");
INSERT INTO bqj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","wáine gono futoh nubajene, ban áine ahu o jurobo me maer alet áini. Maagen nulobe. » ");
INSERT INTO bqj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ñer aare ahu naagol : « Alínom, nijuge búoh aw aboñer nom. ");
INSERT INTO bqj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sipayóli gufan ni firijaŋ faufe gumigelete Aláemit ; bare buru Esúif yay juoge tiñ talu to Aláemit aat me amigeleti, utu Yérusalem. » ");
INSERT INTO bqj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yésu naagol : « Uínen firimom : tinah talu utu n’éjoul, no mati níme ter ni firijaŋ faufe, ter Yérusalem jijae emigelet Ᵽaaya Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Buru bugaa Samari jimigeletemigelet Aláemit m’baffasutol ; bare wóli Esúif yay jimigeleteolmigelet ban jiffasol, mata aᵽagena ahu ni Esúif yay náᵽullo. ");
INSERT INTO bqj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bare tinah talu utu n’éjoul, ban to tuomme ute to nuomal maa ni to, no umigeletaaw bugaa maagen gujae me emigelet Ᵽaaya ni garamben dó gaa Biinumol ni ᵽoᵽ ni maagen : umigeleta ti bugaubugi Ᵽaaya aliᵽe mee. ");
INSERT INTO bqj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Aláemit Biinum nam, ban gamigeleteol me guote gumigeletol ni garamben dó gaa Biinumol ni ᵽoᵽ ni maagen. » ");
INSERT INTO bqj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aare ahu naagol : « Niffase búoh An ahu o Aláemit aĉob me, o guvoge me Kirista, ᵽan ájoul. No najae me éjoul, ᵽan áᵽajuloli dáuru ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yésu naagol : « Injé iomme aĉila, ínje alobe maa n’aw. » ");
INSERT INTO bqj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","No ñer ulagora Yésu n’guĉigul, ban n’gujahali min aamme n’galolobor n’anaare. Bare ánoan ni bugo akañenut arorenol wa naŋese n’aare ahu, ter wa uĉile náni n’elob ni o. ");
INSERT INTO bqj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aare ahu ñer nahato jifinol min ajow bi n’ésuh yay ak’aah bugala yo : ");
INSERT INTO bqj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","« Jújoul ᵽaa jujugom áine ahume alobom maa wo nikan me ᵽe ! Let ᵽiaŋ aĉila aamme Kirista ahu ? » ");
INSERT INTO bqj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ñer n’gúᵽurul n’ésuh yay gújoul bi etoh Yésu to naamme. ");
INSERT INTO bqj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ni tinah tautu, ulagora Yésu n’gulaol guogol : « Afanóli, utiñ. » ");
INSERT INTO bqj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bare o naagil : « Nibaje bi fitiñ mitiñ mo buru jiffasut. » ");
INSERT INTO bqj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ñer ulagorol nihi guogoro : « Babaj ᵽiaŋ ace aŋallol waf waa fitiñ ? » ");
INSERT INTO bqj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Naagil : « Mitiñ mamu múmbam mo muomme ekan wo aboñulom me amaŋ me, ni efaben mamu burokol bo nahat me ni gañen gúmbam. ");
INSERT INTO bqj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Leti nihi juoh : “Tale gueñ gubbagir min eᵽit eĉigul” ? Bare ínje niegul : Juluj joon ulah waw ; emano yay eale, enah eᵽit bare ! ");
INSERT INTO bqj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","An ahu aamme n’eᵽit galagol nafaene ayab bacamol, ban ᵽoᵽ umu n’eomen bahager bi ni buroŋ bábaerit, mamu aaña ahu ni aᵽila ahu ᵽan gúsumaet ni manur. ");
INSERT INTO bqj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Firim faufe faa maagen fom : Ahu ᵽan aañ, ahuo naᵽit. ");
INSERT INTO bqj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Niboñulboñ eᵽit ni galah dó jurokut ; guce gurok ró, mbiban buru n’jitiñ ejenil. » ");
INSERT INTO bqj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bugaa Samari gammeŋe gaĉin dó me n’ésuh yauyu n’gúinen ni Yésu mala firim fo aare ahu alobe aah : « Nalobom wo nikan me ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yo eĉil me no bugaa Samari gujoulo me bi to ni Yésu, n’gulaol anamo to ni bugo ; min ñer akan to gunah gúuba. ");
INSERT INTO bqj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gáinen me n’gufaŋ ñer n’gummeŋe mala wo aĉila faŋaol Yésu alobe me, ");
INSERT INTO bqj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ban nihi guoh aare ahu : « Maer ñer let bagitener babu bíya bare biĉileóli n’jíinen, bare mala min wóli faŋaóli juuttenol me. Jiffase búoh maagen mamu aĉila aamme aᵽagena ahu ala mof. » ");
INSERT INTO bqj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","No gunah gagu gaamme gúuba gúgat me, Yésu náᵽur to ajow mbaa mof mamu maa Gálile. ");
INSERT INTO bqj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","O faŋaol nagitengiten gaa búoh aboñer ndi gúkanumol ni mof mamu dó nabugi me. ");
INSERT INTO bqj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","No naĉih me Gálile, bugala ró n’gualenol wári mata bugo may ni gaggan gagu gaa Paak bo Yérusalem gukaene, ban gujujuh wo nakan bo me ᵽe. ");
INSERT INTO bqj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ñer Yésu nabbañ bi n’ésuh yay yo guvoge me Kana dó ni mof mamu maa Gálile, bo námus me ábahen mal bíñu. Ni baj bo an ámah aroke bi n’ávi ahu áᵽullo n’ésuh yay yaa Kaᵽerinaum o áᵽurol ásote. ");
INSERT INTO bqj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","No naun me búoh Yésu náᵽullo Yúde bi Gálile, najow ak’atogol nalaol aboket ajow ak’asen gahoy áᵽurol ásomut me butum eĉet. ");
INSERT INTO bqj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yésu naagol : « Buru til, jujugut me waf wajureruti, mati júmus jíinen ? » ");
INSERT INTO bqj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aíne ahu naagol : « Afanom, újoul balama añolom aĉet. » ");
INSERT INTO bqj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ñer Yésu naagol : « Ujow, añoli ᵽan aroŋ. » Aíne ahu náinen firim Yésu min ñer akay. ");
INSERT INTO bqj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","O n’ebbañ yay, naemor ni urokaol n’guogol añolol nahoe. ");
INSERT INTO bqj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Narorenil tinah tay añolol áhoyum mee ; n’guogol : « Figen, tinah bajuer étigo, no bújusa babu búᵽure ni o. » ");
INSERT INTO bqj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ñer áine ahu nátallo búoh tinah tautu faŋ Yésu aagol me áᵽurol narondoŋ. Ban náinen ni o, aĉila ni bugaa yaŋol ᵽooil. ");
INSERT INTO bqj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Waf wauwu wo uomme ñer bigitenum Yésu búutten bo nakan me búsol ebbañulol Yúde bi Gálile. ");
INSERT INTO bqj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ᵽúrto, Esúif yay n’gubaj gaggan. Ñer Yésu nakay mbaa Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ban bajen dó Yérusalem busun babaje mal bo gurihinjaŋ gono futoh gaa surujen gúgole. Ni gúhiboriay nihi guvoh bo Betesuda, dóemme \"yaŋ yay yaa ñarum enil.\" Busun baubu bulolof gánonum ésuh yay go guvoge me \"gánonum gagu gal ubbarum waw\". ");
INSERT INTO bqj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Fattam gurihinjaŋ gaugu, baj dó úsota gammeŋe gafilo ró : gápipim, gahakaj, gabofobofo. Bugan bugaubugi ᵽe n’gúnien n’enah mal mamu min mugoror, ");
INSERT INTO bqj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ti ᵽi me nihi baj amalaka Aláemit áavul dó ni busun babu min agoren mo ; ban an ahu ajae me emundum aalo ró mal mamu bagoreneri muban, an ahumu ᵽan ahoy, hani nah’abaj gay gásomut. ");
INSERT INTO bqj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bajen to ni bugan bugaubugi ace áine ásote kábiriŋ símit ávi ni gaat ni sífaji (38). ");
INSERT INTO bqj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yésu najugol to nafilo mee, ban nemme naffase búoh áine ahumu naᵽioe nár tiñ tautu, naagol : « Numaŋe uhoy ? » ");
INSERT INTO bqj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Asóta ahu naagol : « Atiom, ibajut an ajae me mb’abenom ni mal mamu mo n’egoror ; ban ínje faŋaom ijow me, balama iĉih, ace namundom aalo ró. » ");
INSERT INTO bqj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ñer Yésu naagol : « Uilo nuŋar gapegi min ujow ! » ");
INSERT INTO bqj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","To baenah, abofoa ahu nahoy ; naŋar gapegol, ban nanamo ejow. Ban funah faufu funah fom faa fíiyay Esúif yay. ");
INSERT INTO bqj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ñer ufan Esúif yay n’guoh áine ahu ahoy me : « Jama fíiyay, uotut uteb me gapegi ! » ");
INSERT INTO bqj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naagil : « An ahu akanom me nihoy naagomseh iteb gapegom min ijow. » ");
INSERT INTO bqj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","N’guogol : « An ay aagi me uteb gapegi min ujow ? » ");
INSERT INTO bqj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bare áine ahu ahoy me affasut ay, ban Yésu o ballimer ni fítiman fafu faamen to me. ");
INSERT INTO bqj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ᵽúrto, Yésu natoh áine ahumu ni gávi-Aláemit gagu naagol : « Maer aw umu min uhoe. Jamb’ubbañ me ubaj gatil gace, let mo, waf ᵽan ubaji ufaŋ wauwu wabajeni me. » ");
INSERT INTO bqj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ᵽúrto, áine ahu najow ak’aah Esúif yay Yésu asenol mee gahoy gaugu. ");
INSERT INTO bqj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ñer Esúif yay n’gúlagenul Yésu mata funah faa fíiyay nakan mee waf wauwu. ");
INSERT INTO bqj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bare Yésu naagil : « Nánonan Ᵽayom umu m’burok ; yo eĉil me ínje may níni m’burok. » ");
INSERT INTO bqj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gurim gaugu n’guĉil Esúif yay n’gufaŋ n’guliᵽe jamugol : let mala gákanumutol fíiyay fafu barego, bare ᵽoᵽ mala min aah me Aláemit aamme Ᵽayol faŋaol, yaamme búoh o n’Aláemit gurere. ");
INSERT INTO bqj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yésu naŋar firim fafu naagil : « Maagen, ínje ilobul yo : Añil ahu ájuut ailo fuhool nevonol nakan waf ; wo najuh me Ᵽaaya akan, wo ᵽoᵽ nakane. Ban wáfowaf wo Ᵽaaya akane, Añil ahu may wo nakane. ");
INSERT INTO bqj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maagen mamu Ᵽaaya namamaŋ Añolol, ban nah’agitenolgiten wáfowaf wo nakane. Ᵽan agitenol waf wafaŋe mul gájalo wauwe ; ᵽan jijahali. ");
INSERT INTO bqj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maagen mamu, ti Ᵽaaya nah’ailen me gaĉet me gubbañ gúni m’buroŋ, mo may Añil ahu akane me ánoan o súmol me naroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ban ᵽoᵽ Ᵽaaya faŋaol nd’ataliŋ bugan ; bataliŋ babu ᵽe ubu ni guñen Añolol, ");
INSERT INTO bqj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mamu bugan bugagu ᵽe ᵽan gúkanumol ti gúkanum me Ᵽaaya. An ákanumut me Añil ahu, ákanumut ᵽoᵽ Ᵽaaya aboñulol me. » ");
INSERT INTO bqj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","« Maagen, ínje ilobul yo : an autten me firimom ban náinen ni An ahu aboñulom me, nabaje buroŋ bábaerit, ban mat’ataliŋi : o náᵽure aban n’eĉet alo ni buroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Maagen, ínje ilobul yo : tinah talu ᵽan tiĉigul, ban to tuomme taute to nuomal maa ni to, no gaĉet me gujae me eun gavoh Añol Aláemit ; ban gajae go me éttun, ᵽan guroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ti Ᵽaaya asene me buroŋ, mo may náji me Añolol min nah’asen buroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ban nasenolsen ᵽoᵽ sembe sasu sal etaliŋ bugan bugagu, mata o aamme Añol Arafuhow. ");
INSERT INTO bqj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jambi jijahali, tinah talu utu n’éĉigul no bugan bugagu ᵽe gaamme ni guyah gujae me eun gavogol. ");
INSERT INTO bqj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bugagu gakan me maaro ᵽan gúᵽurul dó ni eilo yay yal eyab buroŋ bábaerit ; bugagu gakan me maarat ᵽan guiyul dó eilo yaa bataliŋ. ");
INSERT INTO bqj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Injé fuhoom nevonom íjuut ikan wáfowaf : ti niun me ni Ᵽaaya, mo ᵽan italiŋ ; ban bataliŋerom buĉoĉol, mata nd’iliᵽ ekan wo ínje imaŋ me, bare til wo aboñulom me amaŋ me. » ");
INSERT INTO bqj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","« Iní me ínje bareom ban ilob múmbam, an mát’áinenom. ");
INSERT INTO bqj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Baje ace aam n’elob múmbam ; ban niffase búoh wo nalobe me aya n’ínje, maagen mom. ");
INSERT INTO bqj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Buru juboñe bugan iki gutoh Saaŋ Batis, ban nagitengiten maagen mamu. ");
INSERT INTO bqj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Isoholaut bagitener bal arafuhow bayae n’ínje ; nilolob mala Saaŋ Batis min júju jiyab gaᵽah. ");
INSERT INTO bqj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saaŋ Batis nánini ti ejaŋa yo gusaene min mb’ejaŋen, ban buru jimamaŋ ᵽan jísangor jatiito ni gajaŋa gagu gala yo. ");
INSERT INTO bqj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bare ínje nibaje waf wagitene múmbam wafaŋe Saaŋ bi egiten ay nem. Waf wauwu wo uomme burok babu bo Ᵽaaya asenom me bi ekan. Burok baubu bigitenegiten múmbam gaa búoh Ᵽaaya aboñulom. ");
INSERT INTO bqj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ban aĉila Ᵽaaya faŋaol aboñulom me nagitengiten múmbam. Júmusut juun firimol ter jujuh buulol, ");
INSERT INTO bqj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ban jikanut gurimol n’uinumul, mata jíinenut ni an ahu o naboñulo me. ");
INSERT INTO bqj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jílingenelingen Bahiĉer babu joon mata n’gaᵽinorul ᵽan jutoh ró buroŋ babu bábaerit me ; ban Bahiĉer baubu bulob me múmbam. ");
INSERT INTO bqj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bare til buru jimaŋut éjoul mbal ínje bi eyab buroŋ babu baa maagen. ");
INSERT INTO bqj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Iliᵽut gasal gajoumulo ni bugan. ");
INSERT INTO bqj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ᵽiᵽima, niffasul jon : jibajut gamaŋ gánogan gal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nijoulo ni gajow gaa Ᵽayom, ban jilelom n’eyab ; mbi ace ájoul ni gajow gaa fuhool, o til jiyabe me ! ");
INSERT INTO bqj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jiliᵽeliᵽ nánonan esalenor, bare jiliᵽérit eyab gasal gagu gáᵽureul me ni Aláemit o bare ; bu ñer jújue jíinenom ? ");
INSERT INTO bqj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bare jambi jiᵽinor gaa búoh ᵽan ivogul bataliŋ bújoŋor Ᵽayom ; Móis o mb’avogul me bataliŋ, aĉila o jibaŋ me gafiumul ni o. ");
INSERT INTO bqj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Maagen mamu, ínien me jíinene ni Móis, ᵽan jíinenen ᵽoᵽ n’ínje, mata nahiĉe múmbam. ");
INSERT INTO bqj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bare nemme jíinenut ni wo nahiĉ me, bu ñer jújue jíinen gurimom ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ᵽúrto, Yésu nátiᵽ alo ñagagu fal fafu fáᵽurut me faa Gálile (fo guvoge me may faa Tiberiad). ");
INSERT INTO bqj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Fítiman fámah ni fulagenol, mata fujujuh min asene me úsotaaw gahoy. ");
INSERT INTO bqj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ñer Yésu najiŋ n’erijaŋ aban nanamo ró, o ni ulagorol. ");
INSERT INTO bqj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ban gaggan gagu gal Esúif yay go guvoge me Paak gulofulo. ");
INSERT INTO bqj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ñer Yésu náarul gúĉilol najuh búoh fítiman fámah ufu n’éjoul mbal aĉila. Naah Fílip : « Bay ᵽiaŋ nujaale énnomul unaĉ bi esen bugan bugaubugi ᵽe gutiñ ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nalob mee gurim gaugu bi ejuh Fílip. (Aĉila faŋaol naffase bae bu najae me ekan.) ");
INSERT INTO bqj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fílip naagol : « Hani nubajenale síralam símmeŋ bu, mati siᵽilo ennom unaĉ iki ánoan ni bugo abaj dó jiᵽirih. » ");
INSERT INTO bqj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ñer ace n’ulagoraaw gajaol Andere, ati Simoŋ Ᵽier, naah Yésu : ");
INSERT INTO bqj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","« Baje tale áᵽur ace abaje unaĉ wono futoh ni muol múuba ; bare wa sutoge ebat yauyu ᵽe ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Bare Yésu naah : « Jikanil n’gunamo bugo ᵽe. » Tiñ tautu tibajene efos yammeŋe. Ñer n’gurobo. Ni gaam to me, wáineaw guᵽiloe butum bugan súuli futoh (5 000). ");
INSERT INTO bqj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ñer Yésu naŋar unaĉ waw, nasalen Aláemit, aban nagabor wo ganamo to me ; nakan manur mamu ni suol sasu, iki ᵽilo min gumaŋ me. ");
INSERT INTO bqj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","No bugo ᵽooil gutiñ me iki gupoñ, naah ulagorol : « Juomen miᵽirih mamu maŋaño me, jambi wáfowaf úbburi. » ");
INSERT INTO bqj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ñer n’guomen miᵽirih mamu maŋaño me mal unaĉ waw waamme futoh, iki gummeŋen utegel wono guñen n’úuba (12). ");
INSERT INTO bqj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","No bugan bugagu gujuh me waf wauwu wajureruti mee wo Yésu akan me, n’guoh : « Maagen áine ahumu aamme aboñer ahu aat me ájoul ni mof ! » ");
INSERT INTO bqj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ñer Yésu, nemme naffase búoh guᵽinore ékail gujogol gúvien, nabbañ añago abbañ bi n’erijaŋ yay o nevonol. ");
INSERT INTO bqj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","No tinah tiseor me, ulagora Yésu n’gujow bi galam fal fafu. ");
INSERT INTO bqj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","N’gújuᵽo ni busana min gútiᵽ bi Kaᵽerinaum yaamme ñagagu fal fafu. Toker emoĉ yay baĉigerul, ban Yésu m’bajaerulat atogil bo. ");
INSERT INTO bqj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ni baj fúrus faliŋe fiiyul, ban fal fafu ni fiteh. ");
INSERT INTO bqj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","No guven me butum simetar súuli futoh ni yanur (6 000), n’guŋanden Yésu nájaeul me ni mal mamu áni n’éloful busana babu ; ñer gáholi n’gunonil. ");
INSERT INTO bqj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bare Yésu naagil : « Jambi júholi ! Injé om ! » ");
INSERT INTO bqj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ñer n’gumaŋen éjuᵽol dó ni busana babu, bare m’bufaen buya to gujae me. ");
INSERT INTO bqj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tihalen fo, fítiman fafu fo guhatulo bo me ni fuosen búoh busana banur buomen to, ban Yésu ajingut ró manur n’ulagorol, bare bugo bareil gukae. ");
INSERT INTO bqj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ni baj usana uce wáᵽullo n’ésuh yay yo guvoge me Tiberiad uĉigul tiñ talu to Yésu asalenen me Aláemit aban nasen bugan bugagu unaĉ waw gutiñ. ");
INSERT INTO bqj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","No bugaa fítiman fafu gútallo me búoh hani Yésu, hani ulagorol gulelen to, bugo faŋail n’gújuᵽo n’usana wauwu min gukay mbaa Kaᵽerinaum filiᵽol. ");
INSERT INTO bqj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ñer bugan bugagu n’guke gutoh Yésu ñagagu fal fafu, ban n’guogol : « Afanóli, nay nujoulo mbaa babe ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Naagil : « Maagen, ínje ilobul yo : min jiŋeseom mee, let mata jujojoh wo ugitenum waw wo nikane me ulob me, bare mala min jitiñ me unaĉ waw iki jiyajen. ");
INSERT INTO bqj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jambi jurok mala mitiñay mamu majae me ehajen, bare mala mamu maᵽioe me, masene me buroŋ bábaerit. Mitiñay maumu Añol Arafuhow ᵽan asenul mo. N’aĉila Aláemit Ᵽaaya akiĉ me fúffasum fafu fola. » ");
INSERT INTO bqj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","N’guogol : « Wa juote jikan bi erok burok babu bo Aláemit amaŋ me ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Naagil : « Burok Aláemit banageul me, bo buomme jíinen ni an ahu o naboñulo me. » ");
INSERT INTO bqj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","N’guogol : « Waf way wajureruti nujae ñer ekanóli jujuh min jíineni ? Wa nujae ekan ? ");
INSERT INTO bqj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sipayóli gufan gutiñe mana yay baubu ni gafit gagu, ti Bahiĉer babu bulob yo me buoh : “Nasenil gutiñ ganaĉ gagu gaavulo me n’émit.” » ");
INSERT INTO bqj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ñer Yésu naagil : « Maagen, ínje ilobul yo : sipayolal gutitiñ ganaĉ gagu gaavulo me n’émit ; ganaĉ gaugu let Móis asenil go, bare Ᵽayom faŋaol. Ban Ᵽayom aamul n’esen maer ganaĉ gagu gaa maagen gaavulo me n’émit. ");
INSERT INTO bqj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jiffas búoh ganaĉ Aláemit go guomme gagu gaavulo me n’émit, ban nihi gusen mof mamu buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","N’guogol : « Afanóli, usenóli nánonan ganaĉ gaugu. » ");
INSERT INTO bqj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yésu naagil : « Injé iomme ganaĉ gagu gaa buroŋ. An ájoul me mbal ínje mát’ámus acaret, an áinen me n’ínje marem mati múmus mujogol. ");
INSERT INTO bqj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bare nilobul yo : jujugom, ban jilet n’éinen n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Anóan ni bugo Ᵽayom asenom me ᵽan ájoul mbal ínje, ban an ajoulo mbal ínje mat’ímus ibelenol tíyaŋ. ");
INSERT INTO bqj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iavulat n’émit bi ekan wo ínje imaŋ me, bare wo aboñulom me amaŋ me. ");
INSERT INTO bqj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ban aboñulom me úre namaŋe : jambi ace ni bugo nasenom me allim ni guñenom, bare til iilenil bugo ᵽe ni gaĉet me funah fúsola. ");
INSERT INTO bqj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maagen Ᵽayom dáure namaŋe : ánoan ajae me ejuh Añolol ban náinen ni o abaj buroŋ bábaerit ; ban ᵽan iilenol funah fúsola. » ");
INSERT INTO bqj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ñer Esúif yay n’gunamo émumunor mola mala min aah me aĉila aamme ganaĉ gagu gaavulo me n’émit. ");
INSERT INTO bqj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nihi guoh : « Ahumu leti Yésu, áᵽur Susef ? Nuffasale ᵽayol ni jaol. Bu ñer nájue aah n’émit naavulo ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yésu naagil : « Jambi júmumunor. ");
INSERT INTO bqj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","An ájuut ájoul mbal ínje íni Ᵽayom aboñulom me añagulatol, ban an ti ahumu ᵽan iilenol ni gaĉet me funah fúsola. ");
INSERT INTO bqj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Uboñer waw guhiĉe guoh : “Aláemit ᵽan aligen bugan bugagu ᵽe.” Anóan autten me Ᵽaaya ban nayab baligenerol, ᵽan ájoul mbal ínje. ");
INSERT INTO bqj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Let yo eomme ter baje ace ajuge Ᵽaaya ; an ahu bare áᵽullo me n’Aláemit Ᵽaaya, o ajugol. ");
INSERT INTO bqj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Maagen, ínje ilobul yo : An áinen me n’ínje nabaje buroŋ bábaerit. ");
INSERT INTO bqj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Injé iomme ganaĉ gagu gaa buroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sipayul gufan gutiñe mana yay baubu ni gafit gagu, bare mánoman guĉele. ");
INSERT INTO bqj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bare ganaĉ gagu gaavulo me n’émit, uge. An atiñ go me, mat’aĉet. ");
INSERT INTO bqj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Injé iomme ganaĉ gagu garoŋ me gaavulo me n’émit. An atiñ go me, ᵽan aroŋ bi nánonan. Ganaĉ gaugu go guomme enilom yo nijae me esen bi buroŋ mof mamu. » ");
INSERT INTO bqj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ñer Esúif yay n’gunamo síceŋor ni sembe n’guoh : « Aíne ahumu bu nájue asenolal enilol utiñal ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yésu naagil : « Maagen, ínje ilobul yo : jitiñut me enil yay yal Añol Arafuhow, ban ᵽoᵽ jiremut me físimol, buroŋ babu mati bíni ni buru. ");
INSERT INTO bqj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","An atiñ me enilom ban narem físimom, ᵽan abaj buroŋ bábaerit, ban ᵽan iilenol ni gaĉet me funah fúsola. ");
INSERT INTO bqj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jiffas búoh enilom mitiñay mom maa maagen, ban ᵽoᵽ físimom miremay mom maa maagen. ");
INSERT INTO bqj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","An atiñ me enilom ban narem físimom, ᵽan áni n’ínje, ban ínje ᵽoᵽ ᵽan íni ni o. ");
INSERT INTO bqj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ti Ᵽaaya aroŋ me aboñulom me, ban n’aĉila níroŋum me, mo may ánoan ajae me etiñom ajae me eroŋ n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ganaĉ gagu gaavulo me n’émit, uge. Gunogorut ni gagu go sipayul gufan gutiñ me : bugo guĉele, bare an atiñ me ganaĉ gauge, ᵽan aroŋ bi nánonan. » ");
INSERT INTO bqj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Gurim gaugu Yésu alob mee no naamen me n’eligen bugan bugagu ni yaŋ yay yaa galaw baubu Kaᵽerinaum. ");
INSERT INTO bqj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gammeŋe ni galagene me Yésu no guunol me alob gurim gaugu, n’guoh : « Tale ñer nágatene ! Ay ájue aruhen gurim ti gaugu ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nemme Yésu naffase búoh mala gurim gaugu gúmumunore mee, naagil : « Elob yauye etinenultinen ni guiñ ? ");
INSERT INTO bqj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ñer ᵽiaŋ jujuh me Añol Arafuhow o n’ejiŋ mbaa fatiya dó naamen me bítinar, bu ᵽan nogor ? ");
INSERT INTO bqj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Biinum Aláemit bo nihi bisen buroŋ ; arafuhow fumumol ájuut akan wáfowaf. Gurim gaugu go nilobul mee, ni Biinum baubu gujoumulo, ban gusenesen buroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bare baje ni buru guce gáinenut n’ínje. » (Maagen, kábiriŋ m’buju babu Yésu naffasene bugay gúinenut me ni ᵽoᵽ ay ajae me ebenol ni guñen ulatorol.) ");
INSERT INTO bqj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Natajen aah : « Yo eĉil me niegul an ájuut ájoul bi n’ínje Ᵽaaya m’bájiutol yo. » ");
INSERT INTO bqj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","No ᵽúrto me, gammeŋe ni galagene me Yésu n’gubbañ búsol ban n’guhat ejaor ni o. ");
INSERT INTO bqj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ñer naah to ulagorol gaamme guñen ni gúuba : « Buru may mati ᵽoᵽ jikay ti gupalul ? » ");
INSERT INTO bqj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoŋ Ᵽier naagol : « Ataw, mbal ay jijae me ejow ? Aw ubaj me gurim gagu gasene me buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wóli jíinene, ban jiffase búoh aw uomme An ahu Anab me o Aláemit aboñulo me. » ");
INSERT INTO bqj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yésu naagil : « Leti buru ᵽe jaamme guñen ni gúuba ínje iĉobul ? Bare ace ni buru eseytane nam ! » ");
INSERT INTO bqj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mala Yudas nalobe mee, añol Simoŋ Isikariot ; mánoman nánie ace ni ulagorol gaamme guñen ni gúuba, bare o ajaol me ebet ni guñen ulatorol. ");
INSERT INTO bqj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ᵽúrto, Yésu nanamo ejow mof mamu maa Gálile ᵽoomo. Amaŋut eke ni mof mamu maa Yúde, mata Esúif yay guliᵽeolliᵽ bo jamuh. ");
INSERT INTO bqj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nemme gaggan Esúif yay gaa gúggut gagu guĉiloĉih, ");
INSERT INTO bqj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","gutiol n’guogol : « Uᵽúr babe ujow mbaa Yúde, tima ulagorai may bugaa bo n’gujuh wo nukane me. ");
INSERT INTO bqj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","An umaŋ me guffasi mat’ukoᵽen buroki. Iní me nukanekan waf ti wauwu, ukan min ésuh yay ᵽe gujugi. » ");
INSERT INTO bqj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maagen mamu gutiol faŋail gúinenut ni o. ");
INSERT INTO bqj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yésu naagil : « Tinagom tiĉigerulat ; bare buru, nánonan no jimaŋe, jújue jujow. ");
INSERT INTO bqj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Esúh yay gújuut gujogul ni guiñ ; guiñil ínje ᵽan gutiñ mala min igiten me búoh bakaneril buarat. ");
INSERT INTO bqj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jujow mbaa gaggan gagu ; ínje ᵽan mat’ike bo mata tinagom tiĉigerulat. » ");
INSERT INTO bqj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","No nalobil me gurim gaugu aban, nanamo bo Gálile. ");
INSERT INTO bqj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","No gutiol gukay me ñer mbaa gaggan gagu, Yésu may nabbuy mbaa bo an m’baffasut. ");
INSERT INTO bqj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ufan Esúif yay n’gunamo eliᵽol ni gaggan gagu ni’guoh : « Umelo ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bajene gammeŋe ni fítiman fafu ni’gúmumunor mola. Bugagu nihi guoh : « Aíne ahumu an om aaro. » Bare bugaguil ni’guoh : « A-a, o til ebut bugan naam ni yo. » ");
INSERT INTO bqj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bare an akañenut alob mola ávasul, gáholi mala ufan Esúif yay. ");
INSERT INTO bqj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","No gaggan gagu gure me n’etut, Yésu najow bi ni gávi-Aláemit gagu, aban nanamo ró gavare. ");
INSERT INTO bqj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ñer bugan bugagu n’gujahali n’guoh : « Bu jáorume aĉila naffas waf wauwu ᵽe o m’baligenut wo ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yésu naagil : « Waf waw wo niligene me bugan bugagu let n’ínje ujoumulo, bare n’Aláemit aboñulom me. ");
INSERT INTO bqj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","An ailo me gailo gal ekan wo Aláemit amaŋ me, ᵽan affas ter wo nilobe me n’Aláemit ujoumulo, ter ni gajow gúmbam faŋaom nilobe. ");
INSERT INTO bqj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","An alobe ni gajow gola faŋaol, o gasal naliᵽe, bare ahu aliᵽ me gasal bi ni An ahu aboñulol me, nah’alolob maagen, ban wo nakane me ᵽe uĉoĉol. ");
INSERT INTO bqj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Leti Móis nasenulsen gúboñ gagu ? Ban ánoan ni buru alet n’ekan wo gúboñ gagu gulob me. Wa uĉile n’jiliᵽ jamugom ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","N’guogol : « Aw eseytane eom n’aw. Ay aliᵽe jamugi ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yésu naagil : « Waf wanur pat nikan mee, ban buru ubugu jajahali mee ! ");
INSERT INTO bqj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Móis nasenulsen gúboñ gagu gal érur guñolul búhut (joon joon let mata búoh aĉila aju bo, bare ni sipayol gufan bujoumulo). Buru ñer nihi júrur áᵽur búhut hani funah faa fíiyay. ");
INSERT INTO bqj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iní me jújue júrur áᵽur búhut funah faa fíiyay buru m’batilut ni gúboñ Móis, wa uĉile n’jujogom ni guiñ mala an o nisene gahoy enilol ᵽooyo funah faa fíiyay ? ");
INSERT INTO bqj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jambi nihi juluj ni buul min jitaliŋ, bare nihi jitaliŋ bataliŋ baĉole. » ");
INSERT INTO bqj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ni baj guce ni bugaa Yérusalem guoh : « Dáru let áine ahu o guliᵽe me jamuh ? ");
INSERT INTO bqj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ume hum alobe maa bújoŋor ésuh yay ᵽe, ban ánoan alobutol uce ! Min ᵽiaŋ ufan waw gujojoh maagen mamu búoh aĉila aamme Kirista ahu ? ");
INSERT INTO bqj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ume hum nuffasale bay náᵽullo ; bare Kirista ahu, no najae me éjoul, an mat’affas bay náᵽullo. » ");
INSERT INTO bqj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ñer Yésu, o ni gavare gagu dó ni gávi-Aláemit gagu, naah fatiya : « Juoge jiffasom, ban jiffase ᵽoᵽ bay níᵽullo ? Hani ! Iogul maa : ijaoroulat fuhoom ; Aláemit aboñulom me o aamme an ala maagen, ban buru jiffasutol. ");
INSERT INTO bqj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Injé niffasol, mata n’aĉila níᵽullo, ban o aboñulom. » ");
INSERT INTO bqj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ñer n’guliᵽ bi ejogol, bare an arembenutol gañen mata ᵽan tinagol tiĉigerulat. ");
INSERT INTO bqj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gammeŋe ni fítiman fafu n’gúinen ni o, ban n’guoh : « Kirista ahu no najae me éjoul, ᵽan ᵽiaŋ akan waf wajureruti iki faŋ wo ume akane me ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eᵽárisie yay n’guun wo fítiman fafu fúmumunore me mola. Ñer ufan uteŋenaaw ni Eᵽárisie yay n’guboñ guce ni upoyaaw bugaa gávi-Aláemit gagu gukaol fujoh. ");
INSERT INTO bqj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yésu naah : « Injé ᵽan umu to maa ni buru, bare mati ᵽio, ᵽan ibbañ bi ni An ahu aboñulom me. ");
INSERT INTO bqj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ᵽan jiliᵽom, bare mati jujugom ; ban to nijae me éni, mati júju jújoul bi to. » ");
INSERT INTO bqj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ñer bugan bugagu n’guogoro : « Mbaa ᵽiaŋ bay najae ejow bo wolal mat’újual me utogaol bo ? Ᵽan ᵽiaŋ ajow atoh bo Esúif yay gavisor me babu ni sasu súsuh min avare bo bugan bugagu ? ");
INSERT INTO bqj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Naagolal ᵽan uliᵽaol bare mati ujugaol, nabbañ aagolal to najae me éni, mat’újual ujaal bi to. Wa namaŋe elob ni gurim gaugu ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Funah fúsola faa gaggan gagu, faamme fáamumma, Yésu nailo nalob fatiya aah : « An marem mujogol me, ájoul bi n’ínje min arem. ");
INSERT INTO bqj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","An áinen me n’ínje, ᵽan áni ébula yo mal yo ᵽan misen buroŋ, ti Bahiĉer babu bulob yo me. » ");
INSERT INTO bqj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Yésu nalob mee, mala Biinum Banabe nalobe mee, bo bugagu gáinen me ni o gujae me eyab. Nemme ᵽan Aláemit agitenerut gasal Yésu, asenerut Biinum Banabe.) ");
INSERT INTO bqj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Guce ni fítiman fafu, no guun me gurim gaugu, n’guoh : « Maagen áine ahumu aamme aboñer ahu o Móis alob me mola. » ");
INSERT INTO bqj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bugaguil n’guoh : « Ahumu aamme Kirista ahu. » Guce mul n’guoh : « Kirista ahu añumut éᵽurul Gálile. ");
INSERT INTO bqj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Leti Bahiĉer babu buoge Kirista ahu ni gabulaken gagu gaa David ᵽan áᵽurul, n’ésuh yay yaa Betuleem dó David abuh me ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ñer búfaculor m’bubaj ni fítiman fafu mola. ");
INSERT INTO bqj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Guce ni bugo n’gumaŋ bi ejogol, bare an arembenutol gañen. ");
INSERT INTO bqj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ñer upoyaaw n’gubbañ bi ni ufan uteŋenaaw ni Eᵽárisie yay gaboñenil me. Ubuge n’guogil : « Wa uĉile jujolatol ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","N’guogil : « Músut baj arafuhow alob ti áine ahumu nah’alob me. » ");
INSERT INTO bqj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Eᵽárisie yay n’guogil : « Buru may julolo ni gabut gagu gola ? ");
INSERT INTO bqj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Baje ᵽiaŋ ace n’ufan waw ter n’Eᵽárisie yay áinene ni o ? ");
INSERT INTO bqj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bugan bugagu galageneol me, bugo guffasut gúboñ gagu gaa Móis ; dáuru bugan gatabitab ! » ");
INSERT INTO bqj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ñer Nikodem, aamme may Aᵽárisie ti bugo, ámus me abbuy ak’atoh Yésu, naagil : ");
INSERT INTO bqj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","« Gúboñolal gusesen ᵽiaŋ min utaliŋ an aw m’baunerutol ? » ");
INSERT INTO bqj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","N’guogol : « Níinene ᵽiaŋ may aw an om ala Gálile ! Ulíngen Bahiĉer babu : ᵽan ujuh búoh aboñer ánoan ámusut áᵽurul Gálile. »  ");
INSERT INTO bqj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mbiban, ánoan ni bugo naot mbaa yaŋol. ");
INSERT INTO bqj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yésu najow bi ni firijaŋ fafu fal uoliv waw. ");
INSERT INTO bqj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bare tihalen fo ni bujom mej, nabbañ bi ni gávi-Aláemit gagu, ban ésuh yay ᵽe n’gújoul mbal aĉila. Nanamo nániil n’gavare. ");
INSERT INTO bqj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ñer úᵽajula gúboñ Aláemit ni Eᵽárisie n’gúŋarul anaare ace o guminde n’gafilo. N’gubaŋol bújoŋor ésuh yay ᵽe, ");
INSERT INTO bqj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","guban n’guoh Yésu : « Afanóli, aare ahume jiminde n’gafilo. ");
INSERT INTO bqj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ban Móis ni gúboñ gagu gola naagolal mb’utegal waare ti ahumu sival iki guĉet. Ñer aw bu nuᵽinor to ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","N’gulob mee mata eralol gabbut gumaŋe, min mbi gúju gubelol ni bataliŋ. Yésu násilen aban naŋar fisigol nah’ahiĉ to n’ettam yay. ");
INSERT INTO bqj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Min guroŋ me n’erorenol yay, náallo, aban naagil : « An ni buru ámusut me atil, aĉila amundum aralol eval étiar. » ");
INSERT INTO bqj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aban nabbañ ásilen min áni n’ehiĉ to n’ettam yay. ");
INSERT INTO bqj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","No guun me gurim gaugu, n’gukay anur-anur, újogum n’ufamma, iki ŋaño to Yésu bare ni aare ahu, aroŋen to me naiye bújoŋorol. ");
INSERT INTO bqj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yésu náallo naagol : « Aare ahu, ubugelo ? Bajut an ategi ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naagol : « Afanom, an ategutom. » Ñer Yésu naagol : « Injé may mat’itegi. Ujow, ban jamb’ubbañ util. » ");
INSERT INTO bqj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yésu nabbañ aah fítiman fafu : « Injé iomme gajaŋa gagu gaa mof. An alagenom me, mat’ajow n’emoĉ, bare til ᵽan ayab gajaŋa gagu gaa buroŋ. » ");
INSERT INTO bqj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Eᵽárisie yay n’guogol : « Dáuru baloberi nevoni. Bajut waf wagiten dó búoh maagen nulobe. » ");
INSERT INTO bqj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Naagil : « Hani baloberom bom nevonom, baa maagen bom, mata ínje bare iffase bay níᵽullo ni bay nijae, bare buru jiffasut to wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Buru jitaliŋetaliŋ ti arafuhow ataliŋe me ; ínje italiŋut ánoan. ");
INSERT INTO bqj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mb’íni me nitaliŋe, bataliŋerom baa maagen bom, mata ilet nevonom : Ᵽayom aboñulom me umu n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ni gúboñ gagu golul hiĉihiĉ gaa búoh, ni bataliŋ, bugan gúuba gugiten me bagitener banur, bagitener baubu baa maagen bom. ");
INSERT INTO bqj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Injé nigitengiten múmbam, ban Ᵽaaya aboñulom me o ᵽoᵽ nagitengiten múmbam. » ");
INSERT INTO bqj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ñer n’guogol : « Ᵽai umelo ? » Naagil : « Jiffasutom, ban jiffasut ᵽoᵽ Ᵽayom. Iníen me jiffasom, ᵽan ᵽoᵽ jiffasen Ᵽayom. » ");
INSERT INTO bqj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Gurim gaugu Yésu alob mee no naamen me ni gavare ni gávi-Aláemit gagu, tiñ talu to nihi baŋi me waŋali me bi éji Aláemit. An ajogutol, mata tinagol ᵽan tiĉigerut. ");
INSERT INTO bqj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yésu natajen aagil : « Ᵽan ikay ; ᵽan jiliᵽom, bare ᵽan jiĉet ni gatilul ró. Jújuut jújoul bi bo ínje ijae me. » ");
INSERT INTO bqj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Esúif yay n’guoh : « Ban ᵽiaŋ amugoro, nemme o umu aah mee újuutal ujaal bi bo aĉila ajae me ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ñer Yésu naagil : « Buru bugan jom bugaa babe n’ettam, ínje fatiya níᵽullo. Buru bugan jom bugaa mof me, ínje ilet an ala mof maume. ");
INSERT INTO bqj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yo eĉil me niegul ᵽan jiĉet n’utilul ró. Iní me mati jíinen búoh ínje om, ᵽan jiĉet ti maagen n’utilul ró. » ");
INSERT INTO bqj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","N’guogol : « Aw uomme ay ? » Yésu naagil : « An ahu hum o nilobul me mola ni mútut. ");
INSERT INTO bqj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nibaje bi elobul ni etaliŋul waf wammeŋe. Ban igiten mof mamu wo niunulo me ni An ahu aboñulom me. Aĉila maagen bare nah’alob. » ");
INSERT INTO bqj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","N’guun mee gujogut búoh mala Aláemit Ᵽaaya nalobeil mee. ");
INSERT INTO bqj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ñer Yésu naagil : « No jijae me eteben Añol Arafuhow, no ñer ᵽan jiffas me ínje om, no ᵽoᵽ jijae me effas búoh wo nikane me let ni gaᵽinor gúmbam nikane wo : wo Ᵽaaya agitenom me, wo bare nih’ilob. ");
INSERT INTO bqj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","An ahu aboñulom me umu n’ínje ; ahalutom nevonom, mata ínje nikanekan nánonan wásumol me. » ");
INSERT INTO bqj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Min alobe mee gurim gaugu, gammeŋe n’gúinen ni o. ");
INSERT INTO bqj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ñer Yésu naah Esúif yay gaage me n’aĉila gúinene : « Iní me jútuge liŋ firim fafu fúmbam, maagen buru ulagorom jom. ");
INSERT INTO bqj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mamu ᵽan jiffas maagen mamu, ban mo ᵽan miĉilul n’jiᵽah ni fujoh fánofan. » ");
INSERT INTO bqj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","N’guogol : « Wóli gabulaken gal Aburaham jom, ban júmusut jíni ni fimigelet fal ánoan ; ñer ni bu nuogóli mee ᵽan jiᵽah ni fujoh ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yésu naagil : « Maagen, ínje ilobul yo : ánoan o nah’atil, aĉila amigel om ala gatil. ");
INSERT INTO bqj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ban amigel let bi nánonan nah’anamo ni yaŋ afanol, bare añil abugi ró, o, dó ᵽan anamo bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yo eĉil me, íni me Añol Aláemit naᵽagenul ni fujoh, ᵽan jiᵽah ti maagen. ");
INSERT INTO bqj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niffase bae búoh buru gabulaken gal Aburaham. Bare ínje jiliᵽe jamuh, dó ᵽe mata gurimom gunonutul. ");
INSERT INTO bqj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Injé wo nijugulo me ni Ᵽayom nih’ilob ; bare buru wo juun me ni ᵽayul, wo nihi jikan. » ");
INSERT INTO bqj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","N’guogol : « Wóli ᵽayóli o aamme Aburaham. » Naagil : « Jínien me guñol Aburaham, ᵽan jikanen ti nah’akanen me. ");
INSERT INTO bqj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bare buru til ínje jiliᵽe jamuh, ínje alobeul me maagen mamu mo niun me n’Aláemit. Ban waf ti wauwu, Aburaham mát’ámusen akan wo. ");
INSERT INTO bqj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Buru til, wo ᵽayul akane me, wo nihi jikan. » N’guogol : « Wóli jilet suñofah ! Ᵽaaya anur pat jibaje, aamme Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Bare Yésu naagil : « Iníen me Aláemit ᵽayul, ᵽan jimaŋenom, mata ínje n’aĉila níᵽullo, ban o atege níjoul. Ijaoroulat fuhoom, bare o aboñulom. ");
INSERT INTO bqj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wa uĉile jilet n’ejoh baloberom ? Dó ᵽe mala min jújuut me eutten firim fafu fúmbam ! ");
INSERT INTO bqj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Buru ᵽayul o aamme Seytane, ban jimaŋe nihi jikan wo aĉila amaŋ me. Ni mútut o amuga-bugan nam. Amúsut áni ni maagen, mata maagen mánoman milet ni o. Jibij jaju jo nabije me, ainut nah’abij jo, ganogorol gom ! Abija nam ák’áni ᵽaaya ala jibij jánojan. ");
INSERT INTO bqj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ban ínje nemme maagen nih’ilobul, jíinenutom. ");
INSERT INTO bqj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ay ni buru ájue agiten ni bakoŋol dó gatil go ínje ikane ? Nilobeul me maagen, buru jilelom n’éinen, wa uĉile ? ");
INSERT INTO bqj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","An o Aláemit aĉile nah’auttewutten baloberol. Buru jilet bo n’eutten, mata aĉilutul. » ");
INSERT INTO bqj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Esúif yay n’guoh Yésu : « Let ᵽiaŋ bakoŋóli min juoh me aw an áᵽullo Samari, ban eseytane eom n’aw ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Naagil : « Eseytane elet n’ínje, bare til Ᵽayom níkanume, ban buru jimaŋut ékanumom. ");
INSERT INTO bqj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Injé iliᵽut gasal gúmbam. Baje ace aliᵽeom go, ban an ahumu nah’atalitaliŋ. ");
INSERT INTO bqj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Maagen, ínje ilobul yo : an áttun me gurimom, mát’ámus aĉet. » ");
INSERT INTO bqj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Esúif yay n’guogol : « Maer ñer jiffas me búoh eseytane eom n’aw. Aburaham naĉele, uboñer waw ᵽe may mo, aw ñer nuoge an áttun me gurimi mát’ámus aĉet ? ");
INSERT INTO bqj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aw ᵽiaŋ nufafaŋ ᵽayóli afan Aburaham aĉet me ? Uboñer waw may guĉele. Aw ñer an bu numaŋe ejogoro ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Naagil : « Isalenoro me ínje faŋaom, mati ní bo gasal. Bare Ᵽayom umuom n’esalen, aĉila o buru juoge me aĉila aamme Aláemilul, ");
INSERT INTO bqj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ban jiffasutol. Injé niffasol. Iníen me niege iffatol, ᵽan ínien abija ti buru. Niffasolfas, ban níkanukanum gurimol. ");
INSERT INTO bqj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ᵽayul afan Aburaham nah’aᵽinor me mala ejuh funah éjoul yay yúmbam, ésumay nejogol iki nah’atelen. Najuh fo, ban násumaete mala fo. » ");
INSERT INTO bqj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ñer Esúif yay n’guogol : « Aw abajerut me ᵽan símit úvi gúuba ni guñen (50), nuoge aw nujuge Aburaham ? » ");
INSERT INTO bqj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yésu naagil : « Maagen, ínje ilobul yo : Balama Aburaham abugi, ínje min ínie. » ");
INSERT INTO bqj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","No guun me gurim gaugu, n’gumukul sival bi etegol. Bare Yésu nakoᵽ aban náᵽur ni gávi-Aláemit gagu. ");
INSERT INTO bqj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","No Yésu aamme n’égat, najuh ace áine abugi mápime. ");
INSERT INTO bqj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ulagorol n’guogol : « Afanóli, ay atile yaĉil me min áine ahumu abugi mápime : aĉila ter ubugaol ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Naagil : « Let ter aĉila atile ter ubugaol ; bípim babu bola bubabaj mala min burok Aláemit búju bujugi ni o. ");
INSERT INTO bqj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","No ᵽan roŋ me n’eŋanno, nuotale ukanal burok babu bal an ahu aboñulom me. Emoĉ uyu n’éjoul no an mát’áju me arok. ");
INSERT INTO bqj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No ᵽan niroŋe babe ni mof, ínje gajaŋa gagu gala mo nem. » ");
INSERT INTO bqj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","No nalob me gurim gaugu aban, namas n’ettam aban naᵽoroj gumasol iki kan élluh, mbiban naŋar élluh yauyu alos gúĉil ápima ahu, aban naagol : ");
INSERT INTO bqj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","« Ujow uk’uᵽos buuli ni garem gagu gaa Síloam. » (Síloam dóemme \"aboñer\".) Ñer ápima ahu najow bi bo aĉih naᵽos buulol, ban no nabbanno me, najuh. ");
INSERT INTO bqj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Uĉindorol ni bugagu bugo nihi gujugenol me o ni gúcin n’guoh : « Dáuru leti áine ahu o nah’anamo me min ácin ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Guce n’guoh : « Aĉila. » Bugagu n’guoh : « A-a, let aĉila ; anogorol om. » Aĉila faŋaol naagil : « Injé om ti maagen. » ");
INSERT INTO bqj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ñer n’guogol : « Bu jáorum me nuh’ujuh maer ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naagil : « Aíne ahu o guvoge me Yésu akane élluh aban nalosom yo ni gúĉil naagom ijow ik’iᵽos buulom ni garem gagu gaa Síloam. No nijow me bi bo ik’iᵽos bo, nijuh. » ");
INSERT INTO bqj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","N’guogol : « Aíne ahumu umelo ? » Naagil : « Iffasut bay nam. » ");
INSERT INTO bqj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ñer n’gújaenum áine ahu ápimen me bi ni Eᵽárisie yay. ");
INSERT INTO bqj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ban funah faufu, no Yésu akan mee élluh yay min ásotenol gúĉil, funah faa fíiyay fom. ");
INSERT INTO bqj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eᵽárisie yay may n’gurorenol bu jáorum me najuh. Naagil : « Ellúh naŋare alosom n’gúĉil, nik’iᵽos buulom, nijuh. » ");
INSERT INTO bqj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Guce n’Eᵽárisie yay n’guoh : « Aíne ahumu áᵽullat n’Aláemit, mata ákanumut fíiyay. » Bugaguil n’guoh : « Bu atila ájue akan waf wajureruti ti wauwu ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ñer búfaculor m’bubaj ni bugo. N’gubbañ guoh áine ahu ápimen me : « Aw bu nuᵽinore n’áine ahumu ásoteni mee ? » Naagil : « Aboñer nam. » ");
INSERT INTO bqj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bare ufan Esúif yay gumaŋut gúinen gaa búoh áine ahumu nápimenpim ban maer najugejuh. Yo eĉil me n’gúvogul ubugaol bi erorenil ");
INSERT INTO bqj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","n’guogil : « Maagen mamu dáuru añolul o juoh me mápime nabugi ? Ñer bu jáorum me maer najuh ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ubuga áine ahu n’guogil : « Wo jiffas me, uwe : dáure añolóli, ban mápime nabugi. ");
INSERT INTO bqj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bare bu jáorum me najuh, yo, jiffasut yo, ban ᵽoᵽ jiffasut ay akanol najuh. Juroren aĉila faŋaol, anafan nakane bi éju ábalul. » ");
INSERT INTO bqj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","N’gulob mee mala gáholi ufan Esúif yay. Maagen mamu ubuge gujamojamor bi eham ni yaŋ yay yaa galaw ánoan ajae me eoh Yésu aamme Kirista ahu. ");
INSERT INTO bqj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yauyu eĉil me min ubuga áine ahu guogil anafan nakane gurorenol. ");
INSERT INTO bqj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ñer Eᵽárisie yay n’guvoh áine ahu ápimen me gúutten min guogol : « Ulob maagen bújoŋor Aláemit ! Wóli jiffase búoh áine ahumu atila. » ");
INSERT INTO bqj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naagil : « Iffasut ter atila nam. Bare waf wanur niffase : nípimenpim, bare maer nijuge ŋanno ca. » ");
INSERT INTO bqj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","N’guogol : « Wa nakani ? Bu nápegule gúĉili ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naagil : « Nilobenul yo iban, bare juuttenutom. Wa uĉile n’jimaŋ eun yo jitajen ? Buru ᵽoᵽ, jimamaŋ ᵽiaŋ éni ulagorol ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","N’gujelol guoh : « Aw uomme alagora an ahumu, bare wóli ulagora bugaa Móis jom. ");
INSERT INTO bqj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wóli jiffase búoh Aláemit nalolob ni Móis ; bare ahumu, jiffasut bay náᵽullo. » ");
INSERT INTO bqj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ñer áine ahu ápimen me naagil : « Dáuru dijahaliom me min jiffasut mee bay náᵽullo, ban nápegulom gúĉilom. ");
INSERT INTO bqj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nuffasale búoh Aláemit nd’áttun galaw utilaaw ; bare an ahu ákanumeol me ban nah’akan wo namaŋ me, o náh’áttun me. ");
INSERT INTO bqj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Uunerutal bi jama guoh ace nápegule gúĉil an abugi mápime. ");
INSERT INTO bqj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","An ahumu ajoumenulat me n’Aláemit, mát’ájuen to wáfowaf. » ");
INSERT INTO bqj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","N’guogol : « Aw áuulo me ni gatili ró, aw nújue ugitenóli uce ? » Guban n’gujogol gúᵽuren tíyaŋ. ");
INSERT INTO bqj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yésu no naun me búoh gujojoh áine ahu gúᵽuren tíyaŋ, nájoul ak’atogol to naagol : « Aw núinene n’Añol Arafuhow ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naagol : « Afanom, ugitenom ay aamme, min íju íinen ni o. » ");
INSERT INTO bqj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yésu naagol : « O nuluje maa, an ahu alobe maa n’aw, aĉila om. » ");
INSERT INTO bqj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naagol : « Ataw, níinene. » Ban naya gújul bújoŋor Yésu min amigeletol. ");
INSERT INTO bqj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mbiban Yésu naah : « Nijoulojow ni mof tima bataliŋ m’bubaj, min mbi gápim me gujuh ŋanno ca, ban gajuge me, bugo n’gúpim. » ");
INSERT INTO bqj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bajene Eᵽárisie guman gaamen to ni o. No guun me gurim gaugu, n’guogol : « Wóli ᵽiaŋ jípipim may ? » ");
INSERT INTO bqj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Naagil : « Jínien me úpima, mati jibajen util. Bare buru nemme juoge jujujuh ŋanno ca, ᵽan jíni to me bugan bugal util. » ");
INSERT INTO bqj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yésu nabbañ aah : « Maagen, ínje ilobul yo : Baj me busoen ubbarum, min an anonut ni gánonum bo, min til ajiŋ galam bo gace alo ró, an ahumu áku, arama waf bugan. ");
INSERT INTO bqj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bare an ahu anogen me ni gánonum gagu gala bo, o aamme akoña ubbarum waw. ");
INSERT INTO bqj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Apoya gánonum gagu ᵽan ápegulol, ban ubbarum waw ᵽan uffas firimol. Ᵽan avoh ubbarumol ujow wo, aban náᵽuren wo tíyaŋ. ");
INSERT INTO bqj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aᵽúnnul wo me aban, ᵽan ayab wo gayoŋ min ulagenol, mata uffase firimol. ");
INSERT INTO bqj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ubbarum wauwu mat’úmus ulagen ajaora ; ᵽan til uteyol ráli, mata uffasut firim ajaora. » ");
INSERT INTO bqj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yésu búnogor baubu nalobil mee, bare gujogut wa namaŋe elobil. ");
INSERT INTO bqj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yo eĉil me natajen aagil : « Maagen, ínje ilobul yo : ínje iomme gánonum gagu gal ubbarum waw. ");
INSERT INTO bqj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bugagu ᵽe gajoulo me balama ínje úku bugom, urama waf bugan, ban ubbarum waw úttunutil. ");
INSERT INTO bqj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Injé iomme gánonum gagu. An anogen me n’ínje, ᵽan aᵽah ; ᵽan nah’anogen náᵽurul, ban ᵽan abaj tiñ taa gafen. ");
INSERT INTO bqj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Akú gákuet, jamuh ni gahajen náh’ákail bare. Injé nijoulojow min mbi bugan bugagu gubaj buroŋ, ban mbi gupoñ dó ni buroŋ baubu. ");
INSERT INTO bqj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Injé iomme akoña ahu ala maagen. Akoña ala maagen nah’asesen buroŋol bi mala ubbarum waw. ");
INSERT INTO bqj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bare an áᵽullo babu akoñe min mbi gucamol, alet akoña ahu aĉil me ubbarum waw, aŋanden me ejoba-baha yo n’éjoul, ᵽan ajunden ubbarum waw min atey akay, ban ejoba-baha yay ᵽan enogen wo min evis wo. ");
INSERT INTO bqj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ᵽan akan mo mata aĉila an om áᵽullo babu, ban butumol bilebo n’ubbarum waw. ");
INSERT INTO bqj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Injé iomme akoña ahu ala maagen. Niffase ubbarumom, ban ubbarumom uffasom ");
INSERT INTO bqj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ti Ᵽaaya affasom me, ban ínje ᵽoᵽ niffasol. Buroŋom ban isen bo bi mala ubbarumom. ");
INSERT INTO bqj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nibaje ᵽoᵽ ubbarum uce walet ni busoen baube ; uĉila niote may íomenul wo. Ᵽan núh’úttun firimom, ban ᵽan baj ñer ekore yanur ni akoña anur. ");
INSERT INTO bqj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ᵽaaya namaŋommaŋ, mala min iomme n’ejow bi esen buroŋom. Búsol ᵽan mb’ibbañ iyab bo. ");
INSERT INTO bqj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","An alet bo n’eram n’ínje, bare ínje faŋaom iom bo n’esen ; nibaje sembe sasu sal esen bo, ban nibaje may sal éyabul bo. Ᵽayom dáuru naboñulom mee ekan. » ");
INSERT INTO bqj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ñer búfaculor m’bubbañ bubaj n’etut Esúif yay mala gurim gaugu. ");
INSERT INTO bqj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gammeŋe ni bugo nihi guoh : « Eseytane eom ni o ; natetey ni fuhow, wa uĉile n’jíniol n’eutten ? » ");
INSERT INTO bqj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bugaguil n’guoh : « Gurim gaugu let gal an o eseytane enone. Eseytane éjue ᵽiaŋ ekan bugan gápipim min gujuh ? » ");
INSERT INTO bqj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tinah tautu tinah taa gúvagen, ban bugan bugagu n’gúni n’etiñ gaggan gagu go ni’guosen me gápegul gagu gaa gávi-Aláemit bo Yérusalem. ");
INSERT INTO bqj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yésu nah’ajow aya babu najow aya babu ni baŋ babu baa surujen sasu sateᵽi me bo guvoge me \"baŋ Salomoŋ\" dó ni gávi-Aláemit gagu. ");
INSERT INTO bqj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ñer Esúif yay n’gúgolol guban n’guogol : « Bi nay nujae ehalóli n’jíni mamu n’emoĉ ? Iní me aw uomme Kirista ahu, ufaĉóli yo ŋanno ca. » ");
INSERT INTO bqj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Naagil : « Nilobenul yo iban, bare jíinenutom. Wo nikane me ni gajow gaa Ᵽayom ugitengiten ínje ay nem. ");
INSERT INTO bqj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bare jíinenut mata jilet ró n’ubbarumom. ");
INSERT INTO bqj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ubbarumom nuh’uuttewutten firimom ; niffas wo, ban wo nuh’ulagenomlagen. ");
INSERT INTO bqj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nisen wo buroŋ babu bábaerit me ; mat’úmus ullim, ban an mat’aram wo ni guñenom. ");
INSERT INTO bqj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ᵽayom asenom wo me nafafaŋ waf waw ᵽe, ban ánoan ájuut aram waf uce ni guñen Ᵽayom. ");
INSERT INTO bqj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Injé ni Ᵽayom, an anur jom. » ");
INSERT INTO bqj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","No guun me gurim gaugu, n’gubbañ gumukul sival bi eteh so Yésu ak’aĉet. ");
INSERT INTO bqj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ñer náfaro aagil : « Nikakan bújoŋorul waf wammeŋe waaro wáᵽullo ni Ᵽaaya. Mala way ni wo jimaŋe mee etegom sival ? » ");
INSERT INTO bqj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","N’guogol : « Let mala waf uce waaro wo nukane jimaŋe mee etegi sival, bare mala gújel go nujele Aláemit : aw aamme arafuhow numaŋ ujogoro Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Naagil : « Leti hiĉihiĉ ni gúboñ gagu golul búoh Aláemit naage : “Uláemit jom” ? ");
INSERT INTO bqj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nuffasale búoh wo Bahiĉer babu bulob me újuut úᵽunni. Ban Aláemit navoge bugan bugagu bugo firimol fulob me molil \"úlaemit\". ");
INSERT INTO bqj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ban ínje Ᵽaaya naĉobomĉob aban naboñulom babe ni mof. Bu ñer jújue juoh nijejel Aláemit ínje baager ínje Añol Aláemit ? ");
INSERT INTO bqj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iní me ikanut waf waw waa Ᵽayom, jambi jíinenom. ");
INSERT INTO bqj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bare íni me wo nikane, hani ínje jíinenutom, jíinen n’uĉila, mamu n’júju jiffas ñanur bándor búoh Ᵽaaya umu n’ínje, ban may ínje umu ni Ᵽaaya. » ");
INSERT INTO bqj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ñer n’gubbañ guliᵽ ejogol, bare naᵽagil ni guñen. ");
INSERT INTO bqj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Púrto, Yésu nabbañ asat bi ñagagu fal fafu fo guvoge me Suruden ak’anamo tiñ talu to Saaŋ amunden me náh’ábatise. ");
INSERT INTO bqj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bugan gammeŋe n’gújoul mbal aĉila, ban nihi guoh : « Bajut waf uce wajureruti wo Saaŋ akane ; bare wo nalob me ᵽe aya n’áine ahume, maagen dom. » ");
INSERT INTO bqj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ban ñer gammeŋe n’gúinen ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Funah fice, ni baj ace áine gajaol Lasar ásomut. Lasar ahumu Betani nabuge, o ni gúlinol Mari ni Maruta. (Mari o aamme aare ahu ámus me áyu míĉir matiŋoe ni guot Ataw Yésu, aban naŋar walol náti go.) ");
INSERT INTO bqj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Batiay babu gaamme gúuba n’guboñ an ak’aah Yésu : « Ataw, abugei násomusomut. » ");
INSERT INTO bqj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","No Yésu aun me gahoŋen gaugu, naah : « Gásomut Lasar guñumutol eĉil naĉet ; ugu to bi egiten gasal gagu gal Añol Aláemit, mamu bájalo Aláemit ᵽan bujugi. » ");
INSERT INTO bqj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ban Yésu namamaŋ faŋ Maruta, Mari ni Lasar. ");
INSERT INTO bqj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hani min Yésu aun mee búoh Lasar násomusomut, nanamo gunah gúuba atajen tiñ talu to naamme. ");
INSERT INTO bqj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ᵽúrto naah ulagorol : « Ubbañal bi Yúde. » ");
INSERT INTO bqj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","N’guogol : « Afanóli, ᵽiout no bugaa Yúde gumaŋene etegi bo sival uk’uĉet, ban mul ubbañ bi bo ? » ");
INSERT INTO bqj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Naagil : « Leti etufunaha ebaje sílar sono guñen ni súuba ? An ajow me tufunah, mát’álaŋulor waf, mata najujuh gajaŋa gagu gaa mof maume ; ");
INSERT INTO bqj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","bare an ajow me ni fuh, ᵽan álaŋulor, mata gajaŋa gulet ni o. » ");
INSERT INTO bqj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","No nalob me gurim gaugu aban, naagil : « Abugeolal Lasar umu n’gámori ; bare ban ijow ík’íliol. » ");
INSERT INTO bqj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ulagoraaw n’guogol : « Ataw, íni me gámori naam ni go, ᵽan ahoy. » ");
INSERT INTO bqj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ban Yésu mala eĉet Lasar nalob mee ; bare bugo n’gaᵽinoril nalob mee mata Lasar nayaboyabor. ");
INSERT INTO bqj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ñer Yésu nalobil ávasul aah : « Lasar naĉele. ");
INSERT INTO bqj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ban nísumaete mala min ilelen to me, mamu wajae me ebaj ᵽan ukan min jíinen n’ínje. Ujaal utogaol bo. » ");
INSERT INTO bqj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ñer Toma, o guvoge me may \"Máuba\", naah gupalol ulagora : « Wolal may ujaal bi bo, min mb’uĉelal manur ni o ! » ");
INSERT INTO bqj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","No Yésu aĉih me, naun gaa búoh Lasar nafogi baje ñer gunah gubbagir. ");
INSERT INTO bqj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ban Betani éraliut ni Yérusalem, butum simetar súuli sífaji (3 000). ");
INSERT INTO bqj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Esúif gammeŋe gujoulojow gúkail eloden Maruta ni Mari mala eĉet álinil. ");
INSERT INTO bqj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","No Maruta aun me búoh Yésu nalofulo, najow ban guemor ; bare Mari, o, nanamo ró ni yaŋ yay. ");
INSERT INTO bqj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","No Maruta aemor me ni Yésu, naagol : « Ataw, únien to me, álinom mat’aĉelen. ");
INSERT INTO bqj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ban hani maer yauye niffase búoh wáfowaf wo núcine, Aláemit ᵽan aseni wo. » ");
INSERT INTO bqj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yésu naagol : « Alíni ᵽan ailo ni gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naagol : « Niffase búoh ᵽan ailo funah fúsola ni gailo gagu gaa gaĉet me. » ");
INSERT INTO bqj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yésu naagol : « Injé iilene me gaĉet me, ínje iomme buroŋ babu. An áinen me n’ínje, hani naĉele, ᵽan aroŋ. ");
INSERT INTO bqj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ban ánoan aroŋe, mbiban náinen n’ínje, mát’ámus aĉet. Núinene dáuru ? » ");
INSERT INTO bqj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naagol : « Ey, Ataw, níinene búoh aw uomme Kirista ahu, Añol Aláemit, aat me ájoul ni mof. » ");
INSERT INTO bqj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","No Maruta alob me gurim gaugu aban, nakay aĉih navoh atiol Mari min abbuen aagol : « Ataw umu dáre, aw narorene. » ");
INSERT INTO bqj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","No Mari aun me gurim gaugu, nailo ni majase ajow mbaa Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Toker Yésu m’banonerulat n’ésuh yay, bare o bároŋerul tiñ talu to Maruta aemor me ni o.) ");
INSERT INTO bqj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Esúif yay gaamen dó me ni yaŋ yay manur ni Mari bi elodenol n’gujugol ailo ni majase aban náᵽur ; ñer n’gulagenol, mata n’gaᵽinoril ban ajow bi ni fuyah fafu ake bo ukoŋ. ");
INSERT INTO bqj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","No Mari aĉih me to Yésu aamme ak’ajugol, nalo to n’guolol aban naagol : « Ataw, ínien me tale nuomene, álinom mat’aĉelen. » ");
INSERT INTO bqj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","No Yésu ajuh me Mari akoŋ, ban ᵽoᵽ Esúif yay galagenulol me ubugi n’ukoŋ may, ni mujogol náar iki biinumol búguo. ");
INSERT INTO bqj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Naagil : « Tay jufogol ? » N’guogol : « Ataw, újoul ban ᵽan ujuh. » ");
INSERT INTO bqj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yésu gúĉilol n’gutey mufu. ");
INSERT INTO bqj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ñer n’guoh : « Aᵽaa juluj min amaŋol me re me ! » ");
INSERT INTO bqj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Guce ni bugo n’guoh : « Aĉila akan me ápima najuh, ájuenut may akan Lasar jamb’aĉet ? » ");
INSERT INTO bqj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ñer biinum Yésu m’bubbañ búguo o n’elof fuyah fafu. Fuyah fafu kakan gauŋ go gúbakene fuval gutoj gánonum go. ");
INSERT INTO bqj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ñer Yésu naah : « Júᵽuren fuval fafu. » Maruta, álin aĉet me, naagol : « Ataw, jama funagol fubarigen, umu auĉete mee. » ");
INSERT INTO bqj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Bare Yésu naagol : « Let niegiseh íni núinene ᵽan ujuh bájalo Aláemit ? » ");
INSERT INTO bqj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ñer n’gúᵽuren fuval fafu. Yésu náarul gúĉilol fatiya naah : « Ᵽayom, ínje umu n’esaleni mala min úttunom me. ");
INSERT INTO bqj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Injé faŋaom niffase búoh nánonan núh’úttunomtun ; ujuh me nilob maa, mala fítiman bugan bugagu gailo maa tale, tima n’gúinen búoh maagen aw uboñulom. » ");
INSERT INTO bqj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","No nalob me gurim gaugu aban, naah fatiya : « Lasar, úᵽurul dáuru ! » ");
INSERT INTO bqj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ñer áine ahu aĉelen me náᵽurul, guolol ni guñenol min gubboñeni útar, gábil n’gufut buulol. Yésu naagil : « Jijalol, mbiban n’jihalol najow. » ");
INSERT INTO bqj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gammeŋe n’Esúif yay gakelo me n’ende Mari, no gujuh me wo Yésu akan me, n’gúinen ni o. ");
INSERT INTO bqj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bare guce ni bugo n’gujow iki gutoh Eᵽárisie yay min gugitenil wo nakan me. ");
INSERT INTO bqj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ñer ufan uteŋenaaw ni Eᵽárisie yay n’guvoh fujoj ufan waw fámah fafu, guban n’guoh : « Bu nuñumale ekan ? Aíne ahumu nakane waf wammeŋe wajureruti. ");
INSERT INTO bqj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Uhalaol me nakan, bugan bugagu ᵽe ᵽan gúinen ni o, ban bugaa Rom ᵽan gúkail guhajen tiñolal tanab me ni ᵽoᵽ buganolal. » ");
INSERT INTO bqj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ace ni bugo, gajaol Kayafa, aamen me gannay gaugu afan uteŋenaaw ᵽe, naagil : « Buru hum jilet n’étallo ! ");
INSERT INTO bqj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jujugut búoh faŋe jáari an anur aĉet mala ésuh yay balama ésuh yay ᵽe ebao. » ");
INSERT INTO bqj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nalobe mee, let waf wo naᵽinore fuhool, bare nemme gannay gaugu aĉila aamen me afan uteŋenaaw, yo eĉil me Aláemit nasenol biinum baubu bal eoh Yésu naate aĉet mala Esúif yay, ");
INSERT INTO bqj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ban let mala Esúif yay bareil, bare naate aĉet may min guñol Aláemit ᵽe gavisor me guomunor gúni buganur. ");
INSERT INTO bqj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kábiriŋ funah faufu, n’gujoh faa jamuh Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ñer Yésu nahat ejow ŋanno ca ni bugan bugagu ; náᵽur to ajow mbaa mof mice malofe gafit gagu gámah gagu, n’ésuh ece gajow yo Efuraim, ak’anamo bo o ni ulagorol. ");
INSERT INTO bqj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Paak yay yal Esúif yay elofulo ; ban bugan gammeŋe gáᵽullo ni súsuh sasu ᵽe n’gújaali mbaa Yérusalem balama Paak bi eke eᵽos sinilil. ");
INSERT INTO bqj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ñer n’gunamo eŋes Yésu ni gávi-Aláemit gagu nihi bugagu guoh gupalil : « Bu jiᵽinore ? Mati ᵽiaŋ ákail emat gaggan ge ? » ");
INSERT INTO bqj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Toker ufan uteŋenaaw ni Eᵽárisie yay bugo basener gúboñ gaa búoh an affas me bay Yésu am, nagiten min mbi gujogol. ");
INSERT INTO bqj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gunah futoh ni fanur balama Paak, Yésu nájoul bi Betani, ésuh Lasar o nailen me ni gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","No naĉih me, n’gúsilol ; Maruta aamen n’ecokor bugan bugagu, ban Lasar bugo guomen me n’etiñor ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari, o, naŋar jibara jaa míĉir mútut matiŋoe másumut funnom áyu ni guot Yésu, aban naŋar walol náti go ; gatiŋ míĉir mamu n’guram yaŋ yay ᵽooyo. ");
INSERT INTO bqj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ace n’ulagora Yésu, gajaol Yudas Isikariot ajae me ennomenol, naah ñer : ");
INSERT INTO bqj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","« Wa uĉile unnomenutal míĉir maumu síralam sammeŋe usenal galeh me ? » ");
INSERT INTO bqj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nalob mee, let gaa búoh ter enilol erundum galeh me, bare min aamme áku. Aĉila náh’átuh jiet jaju jolil dó gukane me síralamil, ban nah’aŋar waam dó me. ");
INSERT INTO bqj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Bare Yésu naagol : « Uhalol ! Nakan mee bi funah fafu faa gafogom. ");
INSERT INTO bqj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Galeh me, bugo, ᵽan jibajil nánonan ni buru, bare ínje jilelom n’ebaj nánonan. » ");
INSERT INTO bqj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Fítiman fal Esúif ni fuun búoh Yésu umu Betani. Ñer n’gujow bi bo, let mala Yésu bare, bare ᵽoᵽ bi ejuh Lasar o nailen me ni gaĉet me. ");
INSERT INTO bqj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ñer ufan uteŋenaaw n’gujoh bi may jamuh Lasar, ");
INSERT INTO bqj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mata aĉila aĉil me min Esúif gammeŋe gúhatuloil min gúinen ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tihalen fo, fítiman fafu fakelo me emat gaggan gagu gaa Paak ni fuun búoh Yésu umu n’éjoul mbaa Yérusalem ; ");
INSERT INTO bqj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ñer bugala fo n’guŋar ubes wal úit min gúᵽurul guemor ni o n’eŋan ró guoh : « Hosanna ! Aláemit ásonien an ahu ájaeul me ni gajaol, ásonien ávi ahu ala Israel ! » ");
INSERT INTO bqj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ñer Yésu natoh to jusum ; narembor ni jo, ti hiĉi me : ");
INSERT INTO bqj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","« Buru bugaa Yérusalem, jambi júholi ! Juluj, áviul umu ájaeul mee min anamoe ni jusum. » ");
INSERT INTO bqj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bítinar ᵽan, ulagorol gujogut dáuru ; bare búsol, no Yésu ailo me ni gaĉet me áni ni gasalol, no ñer guosen me búoh waf wauwu uhiĉihiĉ uya ni o, bi ni eyab yay ró yo guyabol me. ");
INSERT INTO bqj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bugan bugagu gaamen me ni Yésu no navogulo me Lasar áᵽunnul ni fuyah fafu min ailenol ni gaĉet me, n’gunamo egiten wo gujuh me. ");
INSERT INTO bqj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gammeŋe, nemme guune búoh Yésu nakakan waf wauwu wajureruti mee, n’gújoul guemor ni o. ");
INSERT INTO bqj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ñer Eᵽárisie yay nihi guogoro : « Jujuge búoh újuutal to wáfowaf. Juluj min ésuh yay ᵽe gukae mee mbal aĉila. » ");
INSERT INTO bqj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ni bugan bugagu gajoulo me gúkail esal Aláemit ni gaggan gagu, bajen dó bugan guman galet Esúif. ");
INSERT INTO bqj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","N’gújoul gutoh Fílip ala Betusaida yaa Gálile min guogol : « Afanóli, Yésu jimaŋene bujuh. » ");
INSERT INTO bqj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fílip najow ak’alob yo Andere, min gujaor iki gulob yo Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ñer Yésu naagil : « Tinah talu tiĉilo no Añol Arafuhow áari me asali. ");
INSERT INTO bqj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Maagen, ínje ilobul yo : Gaugit gulout me n’ettam ban ni guĉet, ᵽan gúni to nevongo. Bare guĉet me, ᵽan guogol. ");
INSERT INTO bqj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","An ahoten me ni buroŋol ni mof maume, ᵽan ábbur bo. Bare an alejehen me bola, ᵽan abaj buroŋ babu bábaerit me. ");
INSERT INTO bqj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iní me an amaŋe éni arokaom, mb’alagenom, ban to nijae me éni, arokaom ᵽoᵽ ᵽan áni to. Ban an áni me arokaom, Ᵽayom ᵽan ajogol guñen gúuba. ");
INSERT INTO bqj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Maer to niom maa, biinumom búguoe. Ᵽan ᵽiaŋ ioh : “Ᵽayom, uᵽagenom ni wajae me ebajom” ? Bare hum sílam sausu mala so nijoulo maa bi eteb so, ban tinah so tiĉige. ");
INSERT INTO bqj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ᵽayom, ugiten ñer bájaloi ! » Ñer firim ni fúᵽurul n’émit fuoh : « Nigitenen bo, ban ᵽan ibbañ igiten bo. » ");
INSERT INTO bqj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ñer guce ni fítiman fafu fautteneol me n’guoh : « Dáuru fuᵽaranu fiele. » Bugagu n’guoh : « Amalaka alobe ni o. » ");
INSERT INTO bqj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bare Yésu naah : « Firim faufu fauni mee, let múmbam fuunumi, bare molul. ");
INSERT INTO bqj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maer bataliŋ babu baa mof biĉige, ban Seytane aamme afan ahu ala mof ᵽan áᵽunni abeni tíyaŋ. ");
INSERT INTO bqj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ban ínje, no gujaeom me eteben mbaa fatiya, ᵽan íñagul bugan bugagu ᵽe bi n’ínje. » ");
INSERT INTO bqj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ni gurim gaugu go nalob maa, namaŋe egiten bu najae me eĉet nogor. ");
INSERT INTO bqj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fítiman fafu ni fuogol : « Juune ni Bahiĉer gúboñ gagu gaa búoh Kirista ahu ᵽan áni to bi nánonan. Ñer bu núogum me : Añol Arafuhow náarie atebeni mbaa fatiya ? Ay aamme Añol Arafuhow ahumu ? » ");
INSERT INTO bqj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yésu naagil : « Gajaŋa gagu guroŋ ᵽan ni buru jatiito. Jiaken n’jujow no guroŋ me ᵽan ni buru, balama emoĉ yay etobenul, mata ajaa n’emoĉ nd’affas mbaa bay naam n’ejow. ");
INSERT INTO bqj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nemme juroŋ n’ebaj gajaŋa gagu, jíinen ni go, tima n’jíni bugan bugaa gajaŋa. » No Yésu alob me firim faufu aban, nakay ak’akoᵽ áraliil. ");
INSERT INTO bqj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hani min akan me bújoŋor Esúif yay waf wammeŋe wajureruti, bare bae gúinenut ni o, ");
INSERT INTO bqj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mamu min mbi firim fafu fo aboñer ahu Esai alob me fukano faah me : « Atúla, ay áinene wo wóli julob me ? Ay nugitene sembei ? » ");
INSERT INTO bqj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gújuenut gúinen. Wa uĉile ? Esai faŋaol nalobe may mala gáinenutil no naah me : ");
INSERT INTO bqj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","« Aláemit nápimene gúĉilil, nakane uinumil n’uak ; mamu, jambi gúĉilil gujuh, jambi uinumil ujoh. Dó ᵽe jambi gúbahoul mbal ínje min isenil gahoy. » ");
INSERT INTO bqj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Min Esai alob maa, mala Yésu nalobe mee, o nájugali me bájalo babu bola. ");
INSERT INTO bqj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ni baj til gammeŋe n’ufan Esúif yay gúinen ni Yésu ; bare mala gáholi Eᵽárisie yay, gugitenut yo gúvasul jambi gúᵽunnil ni yaŋ yay yaa galaw, ");
INSERT INTO bqj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","mata gufaŋe eruhen eyab gasal gagu gaa bugan bugagu faŋ gal Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yésu naah fatiya : « An áinen me n’ínje, let n’ínje bareom náinene, bare ᵽoᵽ ni An ahu aboñulom me. ");
INSERT INTO bqj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","An ajugom me, aboñulom me ᵽoᵽ najuge. ");
INSERT INTO bqj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Injé aamme gajaŋa gagu nijoulojow ni mof min mbi ánoan áinen me n’ínje jamb’abbañ áni n’emoĉ. ");
INSERT INTO bqj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","An aun me gurimom, mbiban akanut wo gulob me, let ínje mb’italiŋol, mata ijoulat bi etaliŋ mof mamu, bare til bi eᵽagen mo. ");
INSERT INTO bqj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","An alalom me ban naceŋ eyab gurimom, an ahumu nabaje wajae me etaliŋol : gurim gagu go nilob me, guĉila mbi gutaliŋol me funah fúsola. ");
INSERT INTO bqj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gurim gagu go nilobe me gujoumulat n’ínje, bare Ᵽaaya faŋaol aboñulom me nagitenomgiten wo niot me ilob, ni ᵽoᵽ bu niot me ilob wo. ");
INSERT INTO bqj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ban niffase búoh waf waw wo naboñom me elob, wo úŋareul me buroŋ babu bábaerit me. Yo eĉil me, wo nilobe me, nilobewolob ti Ᵽaaya alobom wo me. » ");
INSERT INTO bqj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Balama gaggan gagu gaa Paak gunogen, Yésu naffase búoh tinagol tal éᵽur ni mof me min abbañ mbaa Ᵽaaya tiĉiloĉih. Ti naᵽi me nábboli ulagorol bugo najae me ehat ni mof, mo may nábboliil mee maagen mamu bi funagol fúsola babe ni mof. ");
INSERT INTO bqj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yésu ni ulagorol n’gúni ni fitiñ gájimel ; toker Seytane o bakaner aban ni biinum Yudas, añol Simoŋ Isikariot, gaa búoh aĉila mb’annomenol me. ");
INSERT INTO bqj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yésu naffas búoh Ᵽaaya nahahat waf waw ᵽe ni guñenol, naffas ᵽoᵽ búoh n’Aláemit náᵽullo, ban umu n’ebbañ bi ni o. ");
INSERT INTO bqj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ñer nailo to guomme ni fitiñ fafu, náᵽuren gájuool, aban naŋar gábil aŋoñ. ");
INSERT INTO bqj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mbiban naŋar mal áulen ni gatew aban nanamo eᵽos guot ulagorol ni éti go nímoro ni gábil gagu go naŋoñ me. ");
INSERT INTO bqj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","No naĉih me ni Simoŋ Ᵽier, Simoŋ Ᵽier naagol : « Ataw, aw ujae me eᵽos guolom ? » ");
INSERT INTO bqj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yésu naagol : « Wo nikane maa, újuut ujoh wo maer, bare búsol ᵽan ujoh wo. » ");
INSERT INTO bqj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Simoŋ Ᵽier naagol : « Múk ! Mat’úmus uᵽosom guot ! » Naagol : « Iᵽosut me guoli, mat’ubbañ úni an úmbam. » ");
INSERT INTO bqj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ñer Simoŋ Ᵽier naagol : « Ataw, mati ní ñer guolom reor dó, bare may mb’uᵽos bi ni guñenom ni fuhoom ró. » ");
INSERT INTO bqj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Naagol : « An auwoe aban asoholaut gaᵽoso atajen íni let eᵽos guolol, mata nakukur múmeol. Ban buru jukukur, bare let buru ᵽooul. » ");
INSERT INTO bqj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Maagen mamu, naffasene ay ajaol me ennomen ; yo eĉil me naah let bugo ᵽe gukure.) ");
INSERT INTO bqj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","No Yésu aᵽosil me guot aban, nabbañ akano gájuool, mbiban nanamo to guomme ni fitiñ naagil : « Wo nikanul maa, jujoh wo ? ");
INSERT INTO bqj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nihi juvogom ñace \"Afanóli\", ñañu n’juvogom \"Ataóli\", ban maagen, julobe jon, mata aĉila nem. ");
INSERT INTO bqj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jujuh me ínje aamme Afanul ni Ataul, niᵽos guolul, min ñer mbi buru may juᵽosor guot : bugan-ó-bugan n’guᵽos guot gupalil. ");
INSERT INTO bqj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nikanyokan jujuh min mbi buru may jikanor ti ínje ikanul me. ");
INSERT INTO bqj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Maagen, ínje ilobul yo : aroka nd’afaŋ afanol, ti may aboñer nd’afaŋ me gájalo an ahu aboñulol me. ");
INSERT INTO bqj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nemme maer jiffase waf wauwu, gásumay ᵽan gúni ni buru íni me jikane mamu. ");
INSERT INTO bqj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nilob maa let bi ni buru ᵽe. Niffasul buru ᵽe bugo niĉob me, bare Bahiĉer babu buote bukano baah me : “An ahu atiñore mee ganaĉ gagu n’ínje, naiyulo bi n’ínje.” ");
INSERT INTO bqj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ilobul yo maer balama ukano, mamu, no ujae me ekano, n’jíinen búoh maagen mamu ínje om. ");
INSERT INTO bqj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Maagen, ínje ilobul yo : ánoan ayab me an o ínje iboñe, ínje faŋaom nayabe, ban an ayabom me, aboñulom me nayabe. » ");
INSERT INTO bqj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","No Yésu alob me gurim gaugu aban, biinumol m’búguo. Naagil ŋanno ca : « Maagen, ínje ilobul yo : ace ni buru ᵽan annomenom. » ");
INSERT INTO bqj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ñer ulagoraaw nihi gulujor, ban n’gurorenoro ay ni bugo nalobe mee mola. ");
INSERT INTO bqj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ace n’ulagorol, ahu o Yésu ábboli me nár, umuen to nalofe Yésu to guomme ni fitiñ fafu. ");
INSERT INTO bqj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoŋ Ᵽier nábilol gañen min mb’aroren Yésu ay nalobe mee mola. ");
INSERT INTO bqj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ñer alagora ahu náñio mbaa Yésu min aagol : « Ataw, ay nulobe mee mola ? » ");
INSERT INTO bqj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yésu naagol : « An ahu o nijae me esen jiᵽirih jauje jo nijae maa ebboj. » Nabboj jo asen Yudas añol Simoŋ Isikariot. ");
INSERT INTO bqj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","No Yudas atiñ jo me, Seytane nanonol. Yésu naagol : « Wo nuot me ukan, usommen n’ekan wo. » ");
INSERT INTO bqj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ban ánoan ni gaamen to me ni fitiñ ajogut waĉil me nalob gurim gaugu. ");
INSERT INTO bqj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nemme Yudas o nah’aogen jiet jaju jaa síralam sasu, guce ni bugo guᵽinore búoh Yésu naagolseh ánnomul wo gusohola me bi ni gaggan gagu, ter asen galeh me waf. ");
INSERT INTO bqj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ban Yudas o min atiñe jiᵽirih jaju aban, náᵽur to baenah ; toker min tinah tujone. ");
INSERT INTO bqj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","No Yudas áᵽullo me, Yésu naah : « Maer ñer gasal Añol Arafuhow ᵽan guraŋ, ban may bájalo Aláemit ᵽan bujugi manur ni o. ");
INSERT INTO bqj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iní me bájalo Aláemit ban bujugi manur ni o, bal Añol Arafuhow ᵽan may buraŋ, ban mati ᵽio min buraŋ. ");
INSERT INTO bqj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gúñum, ínje ᵽan umu to ni buru, bare ñumut eᵽio. Ᵽan jiliᵽom ; bare ti nilob yo me bugagu, ban may ilobul yo maer : bo nijae me, buru jújuut jujow bi bo. ");
INSERT INTO bqj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gáboñ gavugul niseneul maa : júbbolior ! Ti ínje íbboliul me, buru may júbbolior. ");
INSERT INTO bqj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Júbbolior me joon, bugan bugagu ᵽe ᵽan gujuh búoh buru ulagorom jom. » ");
INSERT INTO bqj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ñer Simoŋ Ᵽier naagol : « Ataw, bay nujae bo ? » Yésu naagol : « Bo nijae me, maer ᵽan újuut ulagenom bi bo ; bare búsol, ᵽan ulanulom. » ");
INSERT INTO bqj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ᵽier naagol : « Afanom, wa uĉile mat’íju ilani maer ? Ᵽan isen buroŋom míya. » ");
INSERT INTO bqj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Bare Yésu naagol : « Nuoge ᵽan usen buroŋi múmbam ? Maagen, ínje ilobi yo : balama gáin guoh, ᵽan uoh ñono ñáfaji uffasutom. » ");
INSERT INTO bqj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yésu nabbañ aah ulagorol : « Jambi júholi. Jíinen n’Aláemit, ban ᵽoᵽ jíinen n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gutoŋ gagu gummeŋe dó ni yaŋ Ᵽayom ; kanenut mo me, mat’iogul ban ijow iki icokorul tiñ to jijae me erobo. ");
INSERT INTO bqj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ike me icokorul furobo fafu iban, ᵽan íbbañul, ban ᵽan iŋarorul min mbi to ínje iomme, buru may n’jíni to. ");
INSERT INTO bqj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ban to nijae me, jiffase bulago babu bajow me bi to. » ");
INSERT INTO bqj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma naagol : « Ataw, jiffasut hani bay nujae bo. Ñer bu jújue jiffas bulago babu ? » ");
INSERT INTO bqj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yésu naagol : « Injé iomme bulago babu, maagen mamu ni buroŋ babu. An ájuut ajow bi ni Ᵽaaya o m’bájoumut n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jiffasom me, ᵽan jiffas ᵽoᵽ Ᵽayom. Ban ñer maer jiffasol ban jujugol. » ");
INSERT INTO bqj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fílip naagol : « Ataw, ugitenóli Ᵽaaya min ᵽiloóli. » ");
INSERT INTO bqj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yésu naagol : « Ᵽioe faŋ no ínje iom ni buru, ñer aw Fílip uffaserutom ? An ajugom me, o Ᵽaaya najuh mee. Bu kane ñer nuogom igitenul Ᵽaaya ? ");
INSERT INTO bqj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Uínenut búoh ínje umu ni Ᵽaaya, ban Ᵽaaya umu n’ínje ? Gurim gagu go nilobeul me gujoumulat n’ínje, bare ni Ᵽaaya ; aĉila aamme n’ínje o aam n’ekan burokol. ");
INSERT INTO bqj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jíinenom ínje baager ínje umu ni Ᵽaaya ban Ᵽaaya umu n’ínje. Iní jíinenut gurimom, jíinenom ñer mala waf wauwu wo nikane mee. ");
INSERT INTO bqj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Maagen, ínje ilobul yo : an áinen me n’ínje ᵽan akan ᵽoᵽ waf waw wo nikane me. Ᵽan akan may wafaŋe gájalo, mata ban ijow bi ni Ᵽaaya. ");
INSERT INTO bqj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ñer wáfowaf wo jijae écin ni gajaom, ᵽan ikan wo, min mbi bájalo Ᵽaaya buraŋ ni búkanum bal Añolol. ");
INSERT INTO bqj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Injé ilobul yo, wáfowaf wo jícine ni gajaom, ᵽan ikan wo. » ");
INSERT INTO bqj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","« Iní júbboliom, ᵽan júttun gurim gagu go nilobeul me. ");
INSERT INTO bqj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ᵽan ícin Ᵽaaya min asenul an ace ajoulul me eramben, ban ᵽan áni to manur ni buru bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","O aamme Biinum babu baa maagen. Bugaa mof gújuut guyabol : gujugutol, ban ᵽoᵽ guffasutol. Bare buru jiffasol mata umu n’etulul, ban ᵽan áni ni ánoan ni buru bi nánonan. ");
INSERT INTO bqj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mat’ihalul nevonul ti úsugaten ; ᵽan íbbañul bi ni buru. ");
INSERT INTO bqj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mati ᵽio min bugaa mof mati gubbañ gujugom ; bare buru ᵽan jibbañ jujugom mata ínje umu m’buroŋ, ban buru ᵽan juroŋ ᵽoᵽ. ");
INSERT INTO bqj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Funah faufu ᵽan jiffas me búoh ínje ni Ᵽayom nem, ban may buru n’ínje jom ti ínje iomme ni buru. ");
INSERT INTO bqj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","An abaŋ me gurimom ni biinumol ban nákanum go, an ahumu ábboliom me. Ᵽayom ᵽan ábboli an ahu ábboliom me ; ínje faŋaom ᵽan íbboliol ban ᵽan ikanol min affasom. » ");
INSERT INTO bqj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ñer Yudas (ábulo me ni Yudas Isikariot) naagol : « Ataw, wa uĉile numaŋ ukanóli n’jiffasi, min uhabo bugagu ᵽe ? » ");
INSERT INTO bqj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yésu naagol : « An ábboliom me ᵽan ákanum gurimom. An ahumu Ᵽayom ᵽan ábboliol ; ínje ni Ᵽayom ᵽan jújoul bi ni o, ban ᵽan jíni ni o. ");
INSERT INTO bqj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","An ábboliutom me, mát’ákanum gurimom. Ban wo juunom me ilob, let n’ínje ujoumulo, bare ni Ᵽayom aboñulom me. ");
INSERT INTO bqj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Dáuru ᵽe nilobulyolob ínje ᵽan baroŋer ni buru. ");
INSERT INTO bqj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Arambena ahu, aamme Biinum Banabe o Ᵽaaya ajae me eboñulul ni gajaom, o ᵽan aligenul waf waw ᵽe, ban ᵽan aosenul ᵽeeᵽe wo nilobeul me. ");
INSERT INTO bqj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nihalul ni gásumay, nisenul gásumay gagu gúmbam. Gúmbam gunnamut ni gagu go bugaa mof gusene me. Jambi uinumul úguo, jambi júgogor ! ");
INSERT INTO bqj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Juunom min iogul me ínje umu n’ejow ban ᵽan íbbañul bi ni buru. Kan me júbboliomboli, juote jísangor min iomme n’ejow bi ni Ᵽaaya, mata Ᵽayom nafaŋom fúf. ");
INSERT INTO bqj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ilobul yo maer balama waf wauwu uĉigul, min mbi no ujae me eĉigul n’jíinen n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mat’ibbañ ilob ñammeŋe ni buru, mata Seytane aamme afan ahu ala mof umu n’éjoul bi ekan burokol. Abajut sembe sánosan n’ínje, ");
INSERT INTO bqj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","bare wajae me ebaj, ᵽan ubaj min mbi bugaa mof guffas búoh níbbolibboli Ᵽaaya, ban nikanekan ti nalobom yo me. Jiilo, úᵽural tale. » ");
INSERT INTO bqj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yésu nabbañ aah : « Injé iomme bíbiñu babu baa maagen, ban Ᵽayom o aamme acokora bo. ");
INSERT INTO bqj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Gaan gánogan gabugut me mitiñ, ban ni gúlan n’ínje, ᵽan amul go. Bare gagu gabuh me mitiñ, ᵽan áfosul go, mamu ᵽan gufaŋ ebuh. ");
INSERT INTO bqj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gurim gagu go nilobul me gúfosulul guban. ");
INSERT INTO bqj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jíni n’ínje ti ínje iomme ni buru. Ti gaan gújuut me gubuh mitiñ jala go go m’baholut ni bíbiñu babu, mamu may buru mati júju me jubuh mitiñ buru m’baholut n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Injé iomme bíbiñu babu, buru uan waw. An ahot me n’ínje ti ínje iholol me, ᵽan abuh mitiñ mammemmeŋ. Let me ínje, mati júju jikan wáfowaf. ");
INSERT INTO bqj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","An aholut me n’ínje, ᵽan abeni tíyaŋ ti gaan min ahay bo ; mbiban ᵽan gumuruh uan wauwu gubelen ni sambun, min usa. ");
INSERT INTO bqj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jíni me n’ínje ban gurimom n’guĉin ni buru, jilaw wánowan wo jimaŋ me, ban ᵽan jiyab wo. ");
INSERT INTO bqj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jubuh me mitiñ mammemmeŋ, ᵽan giten búoh ulagorom jom ; no ñer bájalo Ᵽayom ᵽan buraŋ me bújoŋor bugan bugagu ᵽe. ");
INSERT INTO bqj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ti Ᵽaaya ábboliom me, mo may ínje íbboliul me. Juroŋ ni gábboli gúmbam ! ");
INSERT INTO bqj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jíkanum me gurimom jon, ᵽan juroŋ ni gábboli gúmbam, ti may ínje íkanum me gurim Ᵽayom, min iroŋ ni gábboli gola. ");
INSERT INTO bqj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nilobul mee min mbi ésumayom éni ni buru, mamu yolul néjalo ék’étijen. ");
INSERT INTO bqj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gáboñ gagu gúmbam uge : Júbbolior ti ínje íbboliul me. ");
INSERT INTO bqj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","An ájuut abaj gábboli gace gújalo iki gufaŋ esen buroŋol bi ni gubugeol. ");
INSERT INTO bqj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jikan me wo nilobe me, dó ᵽan giten me búoh buru gubugeom. ");
INSERT INTO bqj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mat’ibbañ ijogul umigel ; amigel nd’affas wo afanol akane me. Bare nijoguljoh til ubugeom, mala min nih’igitenul me wo niffasulo me ᵽe ni Ᵽayom. ");
INSERT INTO bqj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Let buru juĉobom, bare til ínje iĉobe buru. Niboñul jujow ban n’jubuh mitiñ majae eᵽio. Mamu, wánowan wo jijae me elaw Ᵽaaya ni gajow gúmbam, nasenul wo. ");
INSERT INTO bqj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wo ñer nibaj me ilobul, uwe : Mbi júbbolior ! » ");
INSERT INTO bqj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","« Iní me bugaa mof gulalullat, jiffas búoh ínje gumundum me gulat. ");
INSERT INTO bqj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jínien me búsolil, ᵽan gumaŋenul, mata ᵽan jínien ñer bugolil. Bare nemme niĉobululĉob dó íᵽunnul, jibbañut jíni bugolil ; dáuru diĉil me n’gulalul. ");
INSERT INTO bqj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Juosen wo nilobul me : aroka nd’afaŋ afanol. Gúlatienom me, buru ᵽoᵽ ᵽan gúlatienul ; mb’íni me gúkanume firimom, ᵽan ᵽoᵽ gúkanum folul. ");
INSERT INTO bqj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dáuru ᵽe, ᵽan gukanul waf wauwu múmbam, mata guffasut An ahu aboñulom me. ");
INSERT INTO bqj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iníen me ijaenulat ik’ilob ni bugo, mati gubajen gatil. Bare maer bajut waf wo mb’usenil bakoŋ mala gatilil. ");
INSERT INTO bqj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","An alalom me, Ᵽayom ᵽoᵽ nalale. ");
INSERT INTO bqj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iníen me ikanenut n’etulil waf wo an ace ámusut akan, mati gubajen gatil. Bare maer gujuh wo, guban n’gulalóli ínje ni Ᵽayom. ");
INSERT INTO bqj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bare dáuru ᵽe dibabaj min mbi firim fafu fahiĉi me dó ni gúboñil fukano faah me : “Gulalomlat m’babajut bakoŋ.” ");
INSERT INTO bqj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Arambena ahu aamme ni Ᵽaaya o nijaeul me éboñul ᵽan ájoul. O ᵽan agitenul me múmbam, aĉila aamme Biinum babu baa maagen baa Ᵽaaya. ");
INSERT INTO bqj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ban buru ᵽoᵽ ᵽan jigiten múmbam, mata buru ubugi tiñ tanur n’ínje kábiriŋ m’buju babu. » ");
INSERT INTO bqj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","« Injé ilobul maa jambi jibelen gáinen gagu golul. ");
INSERT INTO bqj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ᵽan nihi guhamul ni saŋ sasu saa galaw, ban tinah tice ᵽan tiĉigul no ánoan ajae me emuh ace ni buru ᵽan aᵽinor me búoh nakanmokan bi eramben Aláemit. ");
INSERT INTO bqj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gaffasutil Ᵽaaya ni ínje go ᵽan guĉilil n’gukan mo. ");
INSERT INTO bqj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nilobulyolob min mbi júju juosen tinah tautu to baĉigerul búoh nilobenenul yo. Ilobutul yo m’buju babu, mata ínje umuen to ni buru. » ");
INSERT INTO bqj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","« Maer ban ibbañ bi ni Ᵽayom aboñulom me. Nilobeul mee an ni buru alelom n’eroren bay nijae bo. ");
INSERT INTO bqj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Min ilobul me maumu, yo eĉil me n’júgogor faŋ. ");
INSERT INTO bqj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nilobullob maagen : Wáriari bi ni buru min iom maa n’ekay ; mata íni me ikait, Arambena ahu mát’ájoul bi ni buru, bare ikay me, ᵽan iboñulul o. ");
INSERT INTO bqj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","No najae me éjoul, ᵽan agiten bugan bugagu ŋanno ca waamme gatil, waamme maĉole ni waamme bataliŋ : ");
INSERT INTO bqj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gatil gagu, go guomme min gúinenut me n’ínje ; ");
INSERT INTO bqj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","maĉole mamu, mo muomme min iomme n’ejow mbaa Ᵽaaya, ban mati jibbañ jujugom ; ");
INSERT INTO bqj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","bataliŋ babu, bo buomme min Seytane, aamme afan ahu ala mof, ataliŋi me aban. ");
INSERT INTO bqj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nibaje waf wammeŋe bi etajen ilobul, bare uinumul mati úju uteb wo. ");
INSERT INTO bqj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bare no Biinum babu baa maagen bujae me éjoul biĉila faŋabo, ᵽan bújaenumul ni maagen mamu ᵽe. Gurimol ndi gújoumul n’aĉila faŋaol, bare ᵽan alob wo naun me ᵽe, ban ᵽan agiten ᵽoᵽ wajae me ebaj. ");
INSERT INTO bqj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aĉila ᵽan agiten me bájaloom, min ajae me eyab waamme n’ínje aban nagitenul wo. ");
INSERT INTO bqj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wo Ᵽaaya aogen me ᵽe, úmbam. Yo eĉil me nioh Biinum babu ᵽan buyab waamme n’ínje buban m’bigitenul wo. » ");
INSERT INTO bqj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","« Mati ᵽio min mati jibbañ jujugom ; bare ᵽúrto me, mati ᵽoᵽ ᵽio min jibbañ jujugom. » ");
INSERT INTO bqj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Guce n’ulagorol n’guogoro : « Wa ᵽiaŋ namaŋolal elob naage me : “Mati ᵽio min mati jibbañ jujugom ; ᵽúrto me, mati ᵽio n’jujugom,” mbiban mul : “Ban ikay mbaa Ᵽaaya” ? ");
INSERT INTO bqj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","\"Mati ᵽio\" yay yo nalob me, dóemme wa ? Uffasutal hani jatiito wa namaŋe elob ! » ");
INSERT INTO bqj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ñer Yésu, nemme naffase búoh gumaŋene faŋ erorenol, naagil : « Buru ubugi n’erorenor mala min ilob mee ioh : “Mati ᵽio min mati jibbañ jujugom, ban ᵽúrto me, mati ᵽoᵽ ᵽio min jibbañ jujugom.” ");
INSERT INTO bqj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Maagen, ínje ilobul yo : ᵽan jukoŋ n’jiĉagor, bare bugan bugagu bugaa mof me bugo ᵽan gúsumaet ; ey, ᵽan júgogor, bare gágogorul ᵽan gúbaho ésumay. ");
INSERT INTO bqj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Anaare ajow me bi gapegor, nd’ajabben mata tinagol taa sílam tiĉiloĉih. Bare abuh me añolol aban, mat’abbañ aosen buyoh babu bo nayoh me, mala ésumay yay yo nabaj me n’ebuh añil ahumu. ");
INSERT INTO bqj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Buru may maer jijabbenut. Bare ᵽan íbbañul mbaa buru ; no ñer uinumul ᵽan ummeŋ me ésumay, ban ésumay yauyu ánoan mát’áju áᵽuren yo ni buru. ");
INSERT INTO bqj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","No funah faufu fujae me eĉigul, mati jibbañ ñer jurorenom suroren sice. Maagen, ínje ilobul yo : wáfowaf wo jijae me écin Ᵽaaya ni gajow gúmbam, ᵽan asenul wo. ");
INSERT INTO bqj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Bi ᵽan maer bajut waf wo jícine ni gajow gúmbam. Jícin, ban ᵽan jiyab, mamu ésumayul néju érir. » ");
INSERT INTO bqj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","« Unógor niŋare min ilobul dáuru ᵽee. Tinah talu utu n’eĉigul no mat’ibbañ me iŋar únogor nilob ni buru, bare til ᵽan nih’ilobul ívasul mala Ᵽaaya. ");
INSERT INTO bqj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Funah faufu, ᵽan jícin ni gajaom. Iogutul me ínje mbi nih’ilaw Ᵽaaya molul. ");
INSERT INTO bqj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aĉila Ᵽaaya faŋaol namaŋulmaŋ, mata buru jimaŋommaŋ ban jíineyinen búoh ínje n’aĉila níᵽullo. ");
INSERT INTO bqj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni Ᵽaaya níᵽullo íjoul bi ni mof ; maer, ban íᵽur ni mo ibbañ bi ni Ᵽaaya. » ");
INSERT INTO bqj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ñer ulagorol n’guogol : « Maer aw umu alobe mee ŋanno ca, bajut uce wo nulobe ni únogor. ");
INSERT INTO bqj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Maer ñer wóli jiffas me búoh aw nuffase waf waw ᵽe bi ni wo bugan bugagu gumaŋe me eroreni ró. Yo eĉil me wóli jíinene búoh aw n’Aláemit núᵽullo. » ");
INSERT INTO bqj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ñer Yésu naagil : « Juoge maer jíinene ? ");
INSERT INTO bqj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yoo, tinah talu utu n’éĉigul, ban tiĉiguloĉih tiban, no buru jijae me evisor ánoan galambol min jujundenom ; bare iñumut éni nevonom, mata Ᵽaaya umu n’ínje. ");
INSERT INTO bqj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nilobul mee min mbi gajogorul n’ínje guŋallul gásumay. Ᵽan jibaj sílam ni mof, bare jujoh liŋ, ínje niheke mof mamu. » ");
INSERT INTO bqj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","No Yésu aban me elob n’ulagorol, náarul gúĉilol fatiya naah : « Ᵽayom, tinah talu tiĉige. Ugiten bájalo Añoli, min mbi aĉila may agiten bíya. ");
INSERT INTO bqj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nújiolji sembe sal éĉibben ánoan, min mb’áju asen bugan bugagu ᵽe bugo nuhat me n’guñenol buroŋ bábaerit. ");
INSERT INTO bqj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Buroŋ bábaerit, bo buomme effasi, aw aamme Aláemit anur ahu ala maagen, ni ᵽoᵽ effas ínje Yésu Kirista o nuboñulo me. ");
INSERT INTO bqj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nigitene bájaloi babe ni mof mamu. Nibane burok babu bo nuboñom me ekan. ");
INSERT INTO bqj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ban maer, Ᵽayom, nemme n’ébbañul yay nem mbal aw, ubbañ usenom bájaloom bo nibajen me no niomen me n’aw balama mof mamu mútuli. ");
INSERT INTO bqj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nikane bugan bugagu bugo núᵽuren me jolil ni mof mamu uhat n’guñenom min guffasi. Búguiya guomene, uban núbahenil uhat n’guñenom, ban gúkanume firimi. ");
INSERT INTO bqj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Maer guffase búoh, wo nusenom me ᵽe, aw uĉil wo, ");
INSERT INTO bqj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mata nilobillob gurim gagu go nusenom me, n’gúttun go. Maagen mamu guffase búoh ínje ni aw níᵽullo, gúineyinen búoh aw uboñulom. ");
INSERT INTO bqj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mala bugo nilae maa ; ilaut bi ni bugaa mof, bare bi ni bugo nuhat me n’guñenom, mata búguiya bugom. ");
INSERT INTO bqj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Maagen, waamme úmbam, úiya om, ti may waamme úiya, úmbam om. Ban bájaloom bujugijuh ni bugo. ");
INSERT INTO bqj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mat’ibbañ íni ni mof, bare bugo ᵽan gúni ni mof. Injé umu n’éjoul mbal aw. Aw Ᵽayom anab me, upoil ni sembe sasu saa gajai, gajow gaugu go nusenom me, min gajogor gubaj n’etulul aw ni bugo jíni an anur ti wola únia me an anur. ");
INSERT INTO bqj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","No niomen me ni bugo, nipoilpoy ni sembe saa gajai go nusenom me. Nígadenilgaden ; hani an anur ni bugo allimut, íni let an ahu aat me allim, ti Bahiĉer babu banab me bulob yo me ᵽio bo. ");
INSERT INTO bqj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Maer ᵽan íjoul mbal aw ; maumu niom n’elob ínje ᵽan baroŋer ni mof, min mbi búgumbam gubaj ésumayom n’gárira yo. ");
INSERT INTO bqj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nilobillob firimi, ban mof mamu ni mulalil, mata gulet bugan bugaa mof, ti ínje ilet me may an ala mof. ");
INSERT INTO bqj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ilauti min úᵽurenil ni mof, bare bi epoil jambi gulo ni guñen gal An ahu Aarat me. ");
INSERT INTO bqj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gulet bugan bugaa mof, ti ínje ilet me may an ala mof. ");
INSERT INTO bqj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ukanil n’guffas maagen mamu min gúni bugan ganabe ; firimi fo fuomme maagen mamu. ");
INSERT INTO bqj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ti aw uboñulom me ni mof, mo may ínje iboñil me ni mof mamu. ");
INSERT INTO bqj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Molil nisenoroi fumumom, min mb’ukanil n’guffas maagen mamu, mamu n’gúni bugan ganabe. ");
INSERT INTO bqj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Let bi ni bugo barebare nilae maa, bare bi may ni bugagu gajae me éinen n’ínje mala gurimil. ");
INSERT INTO bqj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nilai min mbi gúni an anur. Ti aw Ᵽayom uomme n’ínje, ban ínje may níni n’aw, bugo ᵽoᵽ mbi gúni an anur ni wola. Mamu mof mamu ᵽan míinen búoh aw uboñulom. ");
INSERT INTO bqj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bájalo babu bo nusenom me, nisenilbosen may min mbi gúni an anur, ti may wola uoma me an anur. ");
INSERT INTO bqj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Injé ni bugo nem, aw n’ínje nom, min gúni maagen mamu an anur. Mamu, mof mamu ᵽan muffas búoh aw uboñulom ban núbboliilboli ti núbboli me ínje. ");
INSERT INTO bqj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ᵽayom, nimaŋe min bugan bugagu bugo nusenom me gúni to n’ínje tánotan to nem, min mbi gúju gujuh bájalo babu búmbam bo nusenom me, mata nuᵽie núbboliom balama mof mamu mútuli. ");
INSERT INTO bqj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aw Ᵽayom aĉol me, mof mamu muffasuti, bare ínje niffasi, ban ubuge guffase búoh aw uboñulom. ");
INSERT INTO bqj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nikanilkan n’guffas aw uomme ay, ban ᵽan ikanil n’gufaŋ n’guffasi, min mbi gábboli gagu go núbboliom me gúni ni bugo, ban ínje faŋaom níni ni bugo. » ");
INSERT INTO bqj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","No Yésu alob me gurim gaugu aban, najow n’ulagorol dó bi gag’galam gaa fíĉiĉilen fafu faa Keduron, iki gunogen bo ni gafat gace gaamen bo. ");
INSERT INTO bqj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas, ajaol me ennomen, naffasene tiñ tautu, mata Yésu ñammeŋe to náh’ábboli eomunor o ni ulagorol. ");
INSERT INTO bqj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ñer Yudas naŋar gayoŋ gal ekosombil ni upoya bugo ufan uteŋenaaw ni Eᵽárisie yay guboñulo, min gujow mbaa bo n’utirul dó wasasa, sijaŋa ni wañ waa fitih. ");
INSERT INTO bqj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yésu affas me wajae me ebajol ᵽe, nájoul ak’aemor ni bugo ban naagil : « Ay jiliᵽe ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","N’guogol : « Yésu ala Nasaret. » Naagil : « Injé faŋaom ume. » Yudas, annomeneol me, umuen to ni bugo naiye. ");
INSERT INTO bqj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","No Yésu aagil me : « Injé faŋaom ume », bugo ᵽe n’gubbañ búsol, ban n’gulo n’ettam. ");
INSERT INTO bqj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nabbañ arorenil : « Ay jiliᵽe ? » N’guogol : « Yésu ala Nasaret. » ");
INSERT INTO bqj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Naagil : « Niegulseh ínje faŋaom ume. Iní me maagen ínje jiŋese, jihat ubuge n’gujow. » ");
INSERT INTO bqj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Mamu firim fafu fo nalob me ahalen ni fukano faah me : « Hani anur ni bugo nusenom me allimut. ») ");
INSERT INTO bqj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ñer Simoŋ Ᵽier, abajen me gafoje, náñagul go ateh aroka ahu ala afan uteŋenaaw ámah ahu aᵽirih gannu gárib ; aroka ahumu gajaol Malikus. ");
INSERT INTO bqj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","No Yésu ajuh me dáuru, naah Simoŋ Ᵽier : « Ubbañen gafojei ni gafon go. Ᵽan ᵽiaŋ ilat erem éremuma yay yaa sílam yo Ᵽaaya asenom me ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ñer gayoŋ ekosombil yay bi n’afanil dó ni upoyaaw bugal ufan Esúif yay n’gujoh Yésu n’guhogol. ");
INSERT INTO bqj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Guban n’gumundum gújaenumol bi ni Hanas ; Hanas ahu aĉila aamme aol Kayafa, aamen me gannay gaugu afan ahu ámah ahu ala uteŋenaaw. ");
INSERT INTO bqj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ban Kayafa ahumu aĉila ámus me aah Esúif yay : « Hoe an anur aĉet mala ésuh yay ᵽe. » ");
INSERT INTO bqj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ñer Simoŋ Ᵽier ni apalol alagora ace nihi gúlagenul Yésu. Ban alagora ahumu, afan uteŋenaaw ámah ahu naffasolfas ; yo eĉile nanogen manur ni Yésu bi ñáraru fúlumet fafu fal afan uteŋenaaw ámah ahumu. ");
INSERT INTO bqj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bare Ᵽier nailo bo tíyaŋ alof gánonum gagu. Ñer alagora ahu o afan uteŋenaaw ámah ahu affas me náᵽurul ákail alob n’aare ahu apoe me gánonum gagu, min ahat Ᵽier nanogen. ");
INSERT INTO bqj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ñer aare ahu naah Ᵽier : « Aw may ulet ace n’ulagoraaw bugal áine ahumu ? » Naagol : « Ilet ace ni bugo. » ");
INSERT INTO bqj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ni tinah tautu, urokaaw ni upoyaaw n’guomen to n’gáumo ni sambun so gusaen to mata ñutot ñibajene. Ᵽier umuen to ᵽoᵽ ni bugo nánie n’gáumo. ");
INSERT INTO bqj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ñáraru yaŋ yay, afan uteŋenaaw ámah ahu naroren Yésu mala ulagorol ni ᵽoᵽ mala baligenerol. ");
INSERT INTO bqj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yésu naagol : « Nilolob bújoŋor ésuh yay ŋanno ca ; nánonan niligeneligen bugan ni saŋ sasu saa galaw ni gávi-Aláemit gagu, bo Esúif yay ᵽe nihi guomunor me. Bajut uce wo nilobe ikoᵽen. ");
INSERT INTO bqj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ñer wa uĉile núni n’eroren ínje ? Uroren gauttenom me mala wa nilobil ; bugo guffase wo ínje ilob me. » ");
INSERT INTO bqj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","No nalob me gurim gaugu, ace n’upoyaaw gaamen to me naᵽaᵽol embej naagol : « Mamu nujae ébal afan uteŋenaaw ámah ahu ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yésu naagol : « Iní me ilobut jon, ugitenom tay nihajene ; bare íni me nilolob jon, wa uĉile nutegom ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ᵽúrto, Hanas naboñol mahoge bi ni Kayafa, afan uteŋenaaw ámah ahu. ");
INSERT INTO bqj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoŋ Ᵽier, aĉila, naroŋen to naiye náni n’gáumo gagu. N’guogol : « Aw may ulet ace ni ulagorol ? » Naceŋil naagil : « Ilet ace ni bugo. » ");
INSERT INTO bqj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ace n’urokaaw bugal afan uteŋenaaw ámah ahu, aroka ahumu aamme ánaine ahu o Ᵽier aᵽirih me gannu, naagol : « Ijuguti n’aĉila babu ni gafat gagu ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bare Ᵽier nabbañ aceŋ. Ñer to baenah gáin n’guoh. ");
INSERT INTO bqj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","M’bujom mej, n’gúᵽur yaŋ Kayafa n’gújaenum Yésu yaŋ Ᵽilat aamme afan mof mamu o bugaa Rom gubaŋ ró me. Bare Esúif yay bugo faŋail gunonut ró jambi gusigo, mamu mbi gúju gutiñ Paak yay. ");
INSERT INTO bqj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ñer Ᵽilat náᵽurul atogil tíyaŋ naagil : « Gakalame gay jibaje n’áine ahume ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","N’guogol : « Alelen me akana-maarat, mati jiŋallenol íkiil jiseni. » ");
INSERT INTO bqj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Naagil : « Buru faŋaul jiŋarol iki jitaliŋ ti gúboñul gulob me. » N’guogol : « Jibajut sembe sausu sal ekan an naĉet. » ");
INSERT INTO bqj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mamu, firim fafu fo Yésu alob me ahalen n’fukano faamme fal egiten eĉet bu naate aĉet. ");
INSERT INTO bqj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ñer Ᵽilat nabbañ anogen dó ni yaŋol, aban návogul Yésu naagol : « Aw uomme ávi Esúif yay ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yésu naagol : « Wo nulob me, aw uᵽinor wo ter guce gulobi mo múmbam ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Naagol : « Injé ᵽiaŋ Asúif nem ? Bugal ésugi faŋail bi n’ufan uteŋenaaw bugolul ró gujoguli gusenom. Wa nukane ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yésu naagol : « Jáviom jilet jaa mof me. Jínien me jaa mof me, urokaom ᵽan gutigenen múmbam jambi ilo ni guñen ufan Esúif yay. Hani ! Jáviom jilet jaa babe n’ettam. » ");
INSERT INTO bqj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ñer Ᵽilat naagol : « Kan hum aw ávi nom ? » Yésu naagol : « Aw faŋai nulob yo uban : ínje ávi. Dáure diĉile nibugi, dó diĉile níjoul ni mof : bi egiten maagen mamu. Anóan áni me ni maagen ᵽan autten firimom. » ");
INSERT INTO bqj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ᵽilat naagol : « Wa uomme maagen ? » No nalob me aban, nabbañ áᵽurul atoh bo Esúif yay naagil : « Injé ijugut n’áine ahumu gahajen gánogan gájue guĉil min amugi. ");
INSERT INTO bqj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ujugal, nemme ᵽi to ni mukanayul nih’ihanulul an akuli ni gaggan gánogan gaa Paak, jimaŋe ñer ihanulul ávi ahu ala Esúif yay ? » ");
INSERT INTO bqj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","N’gunamo éᵽib guoh : « Wáo, jambi ní aĉila, bare Barabas ! » Ban Barabas ahumu akana-galego om. ");
INSERT INTO bqj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ñer Ᵽilat nabbañ anogen, aban naboñ gujoh Yésu min gutegol gusoh gal ubaŋ. ");
INSERT INTO bqj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ekosombil yay n’guŋar ulaliŋ waa sijeŋ gueĉ fugaŋ guoᵽol ni fuhow, guban n’gufulol gañ gájugah, ");
INSERT INTO bqj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mbiban n’gulofol n’gúfohulol guoh : « Jisafi, ávi Esúif yay ! » Ban n’gunamo etegol simbej. ");
INSERT INTO bqj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ᵽilat nabbañ áᵽur, aban naah Esúif yay : « Yoo, ban íᵽunnululol tíyaŋ min jiffas búoh ijugut n’aĉila gahajen gánogan gájue guĉil min amugi. » ");
INSERT INTO bqj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ñer Yésu náᵽurul min abaje fugaŋ fafu faa sijeŋ ni fuhool, ban nafuli gañ gagu gájugah gagu. Ñer Ᵽilat naagil : « An ahu ume ! » ");
INSERT INTO bqj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","No ufan uteŋenaaw ni upoyaaw gujugol me, n’gúᵽib guoh : « Ubbaŋol n’ekurua ! Ubbaŋol n’ekurua ! » Ᵽilat naagil : « Buru faŋaul jiŋarol iki jibbaŋ n’ekurua ! Injé ijugut ni o gahajen gánogan gájue guĉil min amugi. » ");
INSERT INTO bqj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Esúif yay n’guogol : « Wóli jibaje gúboñ, ban min gúboñoli gulob me, naate aĉet mata najogorojogoro Añol Aláemit. » ");
INSERT INTO bqj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","No Ᵽilat aun me firim faufu, nafaŋ náholle. ");
INSERT INTO bqj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nabbañ anogen ni yaŋol, aban naah Yésu : « Aw an ala bay ? » Bare Yésu ábalutol hani. Ñer Ᵽilat naagol : ");
INSERT INTO bqj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","« Mat’úttunom ? Uffasut búoh nibaje sembe sasu sal ehaleni, ban may nibaje sal ebbaŋi n’ekurua ? » ");
INSERT INTO bqj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yésu naagol : « Mat’ubajen sembe sánosan n’ínje íni me Aláemit asennati so kábiriŋ fatiya. Yo eĉil me, an ahu abelom me ni guñeni nabaje gatil gafaŋe gájalo gúiya. » ");
INSERT INTO bqj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kábiriŋ tinah tautu, Ᵽilat naliᵽ bi ehalen Yésu. Bare Esúif yay n’gúᵽib guoh : « Uhalenol me, yoemme aw ulet abuge ávi ahu Sesar. Anóan aage aĉila ávi, o alator Sesar nam. » ");
INSERT INTO bqj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","No Ᵽilat aun me gurim gaugu, náᵽunnul Yésu bi tíyaŋ, aban narobo to ataliŋa ahu nah’arobo me, tiñ talu to guvoge me \"taii me ni baval,\" ban ni gúhiboriay nihi guvoh to Gabata. ");
INSERT INTO bqj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ban funah faufu fuomme fal ecokor gaggan gagu gaa Paak, maageima tinah bariger. Ᵽilat naah Esúif yay : « Avíul ume ! » ");
INSERT INTO bqj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bare bugo n’gúᵽib guoh : « Aĉet ! Aĉet ! Ubbaŋol n’ekurua ! » Ᵽilat naagil : « Juoge ibbaŋ áviul n’ekurua ? » Ufan uteŋenaaw n’guogol : « Wóli jibajut ávi ace ábulie ni Sesar. » ");
INSERT INTO bqj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ñer nasenil o bi eke ebbaŋ n’ekurua. N’guŋar Yésu gújaenum, ");
INSERT INTO bqj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","n’gukanol nateb ekuruaol, min gúᵽur n’ésuh yay gujow mbaa tiñ talu to guvoge me Golugota ni gúhiboriay, dóemme \"tiñ taa gasen\". ");
INSERT INTO bqj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tiñ tautu gubbaŋol me n’ekurua yay, manur ni guce gúuba : ahu n’gañenol gárib, ahuo n’gamayol, aĉila náni n’etulil. ");
INSERT INTO bqj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ᵽilat naboñ guhiĉ ni jibabar guholen n’ekurua yay ; bahiĉer baubu buoge : « Yésu ala Nasaret, ávi ahu ala Esúif yay. » ");
INSERT INTO bqj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nemme tiñ talu to Yésu abbaŋi me n’ekurua yay tulolof ésuh yay, Esúif gammeŋe n’gujanga bahiĉer baubu. Bihiĉihiĉ ni gúhiboriay, ni gaa bugaa Rom ni ᵽoᵽ ni gaa bugaa Geres. ");
INSERT INTO bqj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ñer ufan uteŋenaaw bugal Esúif yay n’guoh Ᵽilat : « Jamb’uhiĉ uoh “ávi ahu ala Esúif yay ;” ᵽan til uoh : “Aíne ahume naage aĉila aamme ávi ahu ala Esúif yay.” » ");
INSERT INTO bqj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bare Ᵽilat naagil : « Wo nihiĉ me, nihiĉwohiĉ iban. » ");
INSERT INTO bqj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","No ekosombil yay gubbaŋ me Yésu n’ekurua yay guban, n’guŋar wañol, mbiban n’gugabor wo gugab gono gubbagir, fánofan bi n’akosombil anur. N’guŋar ᵽoᵽ gájuool gaa fatiya ; gájuo gaugu gubajut bahiker, gueĉiyeĉ ñanur fatiya bi n’ettam. ");
INSERT INTO bqj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ñer ekosombil yay n’guogoro : « Jamb’uĉaĉal gájuo gagu, bare ulukoral min uffasal ay ajae me eŋar go. » (Maumu firim fafu faa Bahiĉer babu fukano me faah me : « Gugabore bisimoom, ban gulukore gájuoom gaa fatiya. ») Maumu ekosombil yay gukan mee. ");
INSERT INTO bqj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","To n’galam ekurua yay yaa Yésu bajen to jaol, ati jaol, Mari aar Kulopas, ni Mari ala ésuh yay yaa Magudala min guiye. ");
INSERT INTO bqj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","No Yésu ajuh me jaol, najuh to ᵽoᵽ alagora ahu o namaŋ me nár ailo alofol. Ñer naah jaol : « Aare ahu, áᵽuri umu. » ");
INSERT INTO bqj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mbiban naah alagora ahu : « Jai umu. » Ñer alagora ahu naŋar Mari áni n’guñenol. ");
INSERT INTO bqj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ᵽúrto, nemme Yésu naᵽiᵽi naffas búoh maer waf waw ᵽe ukanoe uban, naah : « Marem mujogom. » Mamu wo Bahiĉer babu bulob me n’ukano. ");
INSERT INTO bqj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ban bajen to gatañ gammeŋe bíñu yafifir ; ñer ekosombil yay n’guŋar jurocob gubbojen ni erem yauyu, guban n’guhoh jo ni gaan gaa jununuhen jice gajow jo hisop, mbiban n’gulofen jo butum Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","No naĉoen me erem yauyu aban, naah : « Waf waw ᵽe ukanoe ! » Min ñer ásilen aban naĉet. ");
INSERT INTO bqj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nemme gállim gaugu Esúif yay ᵽan gúni ni fíiyail, ban fíiyay faufu kakan funah fabaje hámma faŋ, ufan Esúif yay gumaŋenut sufuluŋ sasu síni ró fatiya ni sukurua sasu funah faufu. Ñer n’gúcin Ᵽilat min aboñ gufum guot bugan bugagu gabbaŋi me ni sukurua sasu min mbi gujas n’eĉet, mbiban n’gúalenul sufuluŋil. ");
INSERT INTO bqj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ñer ekosombil yay n’gúkail gufum guot átiar ahu ni bugo gubbaŋor me ni sukurua manur ni Yésu, mbiban gal áutten ahu. ");
INSERT INTO bqj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","No guĉilo me ni Yésu, n’gutolol min aĉele ; yo eĉil me gufumutol guot. ");
INSERT INTO bqj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bare ace n’ekosombil yay naŋar ebbayol min áluol gacaĉ, ban físim ni mal ni súᵽurul to to baenah. ");
INSERT INTO bqj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","An ahu agiten me dáure najuhrójuh táh, ban bagitenerol baa maagen bom. Naffase búoh maagen nalobe, yo eĉil me nagiten bo tima buru may n’jíinen ni Yésu. ");
INSERT INTO bqj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mamu, firim fafu faa Bahiĉer babu fukano me faah me : « Mele evulol yanur mati gufum yo. » ");
INSERT INTO bqj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ban tice mul ni Bahiĉer babu tibbañe tuoh : « Ᵽan gúhaken an ahu o guya me gúlu. » ");
INSERT INTO bqj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ᵽúrto, ni baj ace áine gajaol Susef áᵽullo Arimate ájoul ak’atoh to Ᵽilat. Susef ahumu alagora Yésu aamene, bare nakoᵽenyokoᵽen mala gáholi ufan Esúif yay. Nácin Ᵽilat min asenol efuluŋ yay yaa Yésu ájaenum. Ᵽilat nahalol min aŋar yo. Ñer Susef nak’aŋar efuluŋ yay ájaenum. ");
INSERT INTO bqj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem, aamme áine ahu abbuy me ni fuh ak’atoh Yésu, nájoul ᵽoᵽ ban náŋarul búguñor baa míĉir ni múlosoruma mice gajow mo Aloes, butum sikilo ávi ni guñen. ");
INSERT INTO bqj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ñer bugo éubail n’guŋar efuluŋ yay yaa Yésu, n’gufut yo útar ujaha n’elos yo nímoro míĉir mamu matiŋo me, ti Esúif yay guᵽi me nihi gukan bugo baamer n’efoh sufuluŋil. ");
INSERT INTO bqj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Bajene gafat galofe tiñ talu to gubbaŋen me Yésu n’ekurua yay ; ban ni gafat gaugu bajen dó fuyah fuvugul dó gúmusut gufoh an. ");
INSERT INTO bqj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nemme fíiyay fafu mati ᵽio ni fiĉigul, ban fuyah fafu fulolof to, n’guŋar efuluŋ Yésu gubaŋ ró. ");
INSERT INTO bqj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tihalen fíiyay faufu m’bujom mej, tinah m’basarerut, Mari ala Magudala najow bi ni fuyah fafu. No naĉih to me, najuh búoh fuval fafu fatojen me gánonum fuyah fafu fúᵽunniᵽuren. ");
INSERT INTO bqj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Natey ñer ak’atoh Simoŋ Ᵽier ni ahu alagora, o Yésu amaŋ me nár, naagil : « Gúᵽurene efuluŋ Ataw ni fuyagol, ban jiffasut bay guŋar yo gubaŋ. » ");
INSERT INTO bqj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ñer Simoŋ Ᵽier ni ahu alagora n’guilo gutey mbaa fuyah fafu ");
INSERT INTO bqj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","bugo éubail. Nemme ahu alagora natetey faŋ mujas Ᵽier, namundol aĉih to ni fuyah fafu. ");
INSERT INTO bqj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Naŋalo ban najuh útar waw ubaŋi ró n’ettam, bare anogenut. ");
INSERT INTO bqj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","No Simoŋ Ᵽier aĉilo me, nanogen dó ni fuyah fafu. Najuh ró útar waw ");
INSERT INTO bqj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni ᵽoᵽ fímiᵽ fafu ; fo filelen tiñ tanur ni wo, bare fubboñibboñ fubaŋi jala fo. ");
INSERT INTO bqj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ñer ahu alagora, aamen me átiar eĉih ni fuyah fafu, nanogen ᵽoᵽ, najuh ban náinen. ");
INSERT INTO bqj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Maagen ulagoraaw bi funah faufu bugo m’bajogerut min Bahiĉer babu buoh mee Yésu naareno ailo ni gaĉet me.) ");
INSERT INTO bqj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ᵽúrto, ulagoraaw gaamme gúuba n’gubbañ bi súndoil. ");
INSERT INTO bqj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari, o, nailo to tíyaŋ malofe fuyah fafu náni n’ukoŋ. Min akoŋe me, náñuᵽ min aŋalo ró ni fuyah fafu. ");
INSERT INTO bqj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Najuh emalaka gúuba gusimo wañ útuay gurobo tiñ talu to gufilenen me efuluŋ Yésu, ahu bo fuhow fafu fuomen me, apalol bo guot gagu guomen me. ");
INSERT INTO bqj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Emalakaay n’guogol : « Aare ahu, wa nukoŋe ? » Naagil : « Gúᵽurene efuluŋ Ataom ni fuyagol, ban iffasut bay guŋar yo gubaŋ. » ");
INSERT INTO bqj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","No nalob me dáuru aban, nake ejegor najuh Yésu ailo to, bare átallout búoh aĉila om. ");
INSERT INTO bqj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yésu naagol : « Aare ahu, wa nukoŋe ? Ay nuŋese ? » Mari naᵽinorene búoh apoya gafat gagu om, yo eĉil me naagol : « Iní aw uŋarol, ulobom tay nubaŋol min ijow ik’ibbañulol. » ");
INSERT INTO bqj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ñer Yésu naagol : « Mari ! » Najegorol ban naagol : « Rabbuni ! » (Yoemme \"Aligenaom\" ni gúhiboriay.) ");
INSERT INTO bqj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yésu naagol : « Jamb’ujogom uhat tale, mata ijaerut ᵽan bi ni Ᵽayom. Bare ujow uk’uoh gutiom ínje umu n’ejow bi ni Ᵽayom aamme ᵽoᵽ Ᵽayul, bi ni Aláemit úmbam aamme ᵽoᵽ Aláemilul. » ");
INSERT INTO bqj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ñer Mari ala Magudala najow atoh bo ulagoraaw min aagil : « Nijuge Ataw ! » Ban nagitenil wo nalobol me. ");
INSERT INTO bqj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tiname yay yaa funah faufu fanur fafu faamme tihalen fíiyay, ulagoraaw n’guomunor dó ni yaŋ yay, n’gupeh n’guffaŋ unegen waw mata ufan Esúif yay gúholle. To baenah, Yésu nájoul ak’ailo n’etulil min aagil : « Gásumay gúni ni buru ! » ");
INSERT INTO bqj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","O n’elob yay, nagitenil guñenol ni gacaĉol. Ulagoraaw n’gummeŋ ésumay min gujuh me Ataw. ");
INSERT INTO bqj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yésu nabbañ aagil : « Gásumay gúni ni buru ! Ti Ᵽaaya aboñulom me, ínje ᵽoᵽ ban iboñul. » ");
INSERT INTO bqj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ᵽúrto gurim gaugu, náfulenil ban naagil : « Jiyab