﻿USE sofia;
DROP TABLE IF EXISTS sofia.bpx_vpl;
CREATE TABLE bpx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bpx_vpl WRITE;
INSERT INTO bpx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ईसु मसी ना आड़ा-बुड़ा नी नाम नी लीखली सुची नी कीताप, जे अब्‌राहम नी अवल्‌यात, अने दावुद नी अवल्‌यात हता। ");
INSERT INTO bpx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्‌राहम ईसाक नो सोरो हतो, अने ईसाक याकुब नो बाह हतो, अने याकुब यहुदा नो बाह हतो अने तीना भाय। ");
INSERT INTO bpx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","अने यहुदा फीरीस अने जोरह नो बाह हतो, तीमनी आय्‌ह तामार हती, फीरीस हीस्‌रोन नो बाह हतो, अने हीस्‌रोन एराम नो बाह हतो। ");
INSERT INTO bpx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एराम अम्‌मीनादाब नो बाह हतो, अने अम्‌मीनादाब नहसोन नो बाह हतो, नहसोन सलमोन नो बाह हतो। ");
INSERT INTO bpx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","अने सलमोन बोवाज नो बाह हतो, अने बोवज नी आय्‌ह राहब हती, बोवाज ओबेद नो बाह हतो, अने ओबेद नी आय्‌ह रुत हती, अने ओबेद यीसे नो बाह हतो। ");
INSERT INTO bpx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यीसे राजा दावुद नो बाह हतो। अने राजा दावुद सुलेमान नो बाह हतो, सुलेमान नी आय्‌ह उरीय्‌याह नी लाडी हती। ");
INSERT INTO bpx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","अने सुलेमान रहबाम नो बाह हतो। अने रहबाम अबीयाह नो बाह हतो, अने अबीयाह, आसा नो बाह हतो। ");
INSERT INTO bpx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसा यहोसाफात नो बाह हतो, यहोसाफात योराम नो बाह हतो, अने योराम उज्‌जीयाह नो बाह हतो, ");
INSERT INTO bpx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्‌जीयाह योताम नो बाह हतो, योताम आहज नो बाह हतो, अने आहज हीजकीयाह नो बाह हतो, ");
INSERT INTO bpx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हीजकीयाह मनसीह नो बाह हतो, मनसीह आमोन नो बाह हतो, अने आमोन योसीयाह नो बाह हतो; ");
INSERT INTO bpx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","अने ईस्‌रायल ना माणहु ने धरीन बेबीलोन मे लीजवा नी टेमे, योसीयाह यकुन्‌याह अने तीना भायु नो बाह हतो। ");
INSERT INTO bpx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","अने ईस्‌रायल ना माणहु ने धरीन बेबीलोन मे लीजवान बाद, यकुन्‌याह सलतीयेल नो बाह हतो, अने सलतीयेल जरुबाबील नो बाह हतो, ");
INSERT INTO bpx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुबाबील अबीहुद नो बाह हतो, अबीहुद ईल्‌याकीम नो बाह हतो, अने ईल्‌याकीम अजोर नो बाह हतो, ");
INSERT INTO bpx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर सदोक नो बाह हतो, सदोक अखीम नो बाह हतो, अने अखीम ईलीहुद नो बाह हतो, ");
INSERT INTO bpx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ईलीहुद एलीयाजार नो बाह हतो, एलीयाजार मत्‌तान नो बाह हतो, अने मत्‌तान याकुब नो बाह हतो। ");
INSERT INTO bpx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकुब युसुफ नो बाह हतो, जे मरीयम नो घोरवाळो हतो, अने आहयी मरीयम सी ईसु पयदा हयो, जे मसी केवाये। ");
INSERT INTO bpx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","आनी रीते आखी मेळीन अब्‌राहम गेथी दावुद लग चोवदे पीड़ी हयी, दावुद गेथी बेबीलोन मे धराय जवा नी टेमे लग चोवदे पीड़ी हयी, अने बेबीलोन मे धरीन लीजवा नी अळतेण लग गेथी ईसु मसी लग चोवदे पीड़ी हयी। ");
INSERT INTO bpx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ईसु मसी नी पयदावारी आसम हयी; जत्‌यार तीनी आय्‌ह मरीयम नी जोड़ावणी युसुफ ह़ाते हय जेली हती, अने अळतेण तीमना वेवा हय्‌न भेळा हयवा नी पेलेत मरीयम चोखली आत्‌मा नी लारे भारेपोगे हय जी। ");
INSERT INTO bpx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","मरीयम नो घोरवाळो युसुफ धरमी माणेह हतो अने माणहु अगळ मरीयम नु नामबद्‌दी नी करवा हींडतो हतो, एतरे होगोत तीने सोड़ देवा नो वीच्‌यार करवा बाज रेलो। ");
INSERT INTO bpx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","युसुफ आसम वीच्‌यार करीन ह़ुय ज्‌यो, तत्‌यारुत तीने ह़पना मे भगवान नो ह़रगदुत देखाव पड़ीन केदो, “ए युसुफ दावुद नी अवल्‌यात, मरीयम ने तारी लाडी बणावीन लाव्‌वा सी ना बीहे। काहाके तीहयी चोखली आत्‌मा नी लारे भारेपोगे हयली से। ");
INSERT INTO bpx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","अने तीहयी सोरु ने पयदा करहे अने तु तीनु नाम ईसु राखजे, काहाके तीहयो आपणा माणहु ने तीमना पापु सी सोड़ावहे।” ");
INSERT INTO bpx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","आहयु आखु आनीन करते हयु के जे बोल मालीक, भगवान वगे गेथी वात केण्‌या नी लारे केदलो, पुरो हये: ");
INSERT INTO bpx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ह़मळो एक कुवारी भारेपोगे हयहे अने तीहयी एक सोरु पयदा करहे, अने तीनु नाम ईम्‌मानुएल पाड़हे तीहयु नाम नु मतलब से; भगवान आपणी ह़ाते से।” ");
INSERT INTO bpx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","जत्‌यार युसुफ ह़ुवीन उठ्‌यो, तत्‌यार ह़पना मे भगवान नो ह़रगदुत केदो तेमेत कर्‌यो अने मरीयम ह़ाते वेवा करीन आह़फा ना घोर ली आयो; ");
INSERT INTO bpx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","बाखीन युसुफ तत्‌यार लग मरीयम नी ह़ाते नी ज्‌यो, जत्‌यार लग तीनु सोरु पयदा नी हयु। युसुफ सोरु नु नाम ईसु पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ईसु यहुदा देस ना बेतलहम गाम मे पयदा हयो। तत्‌यार हेरोद राजा राज करवा बाज र्‌यो हतो। तत्‌यार उगवणा गेथा तारा ने जाणवा वाळा जानकारु यरुसलेम ह़ेर मे आया। ");
INSERT INTO bpx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","अने माणहु ने पुसवा बाज ज्‌या, “युहदी माणहु नो राजा जे पयदा हयलो से तीहयो कां से? काहाके उगवणो गेथो तीनी सेलाणी नो तारो उगत्‌लो देखला से। अने आमु तीने वांदवा आवला से।” ");
INSERT INTO bpx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","आहयी वात ह़मळीन हेरोद राजा अने यरुसलेम ह़ेर मे रेण्‌या आखा माणहु घबराय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","एतरे हेरोद राजा युहदी ना डायला पुंजारा अने चोखली सास्‌तर ह़ीकाड़न्‌या ने अने आखा ने भेळा करीन आहयु पुछ्‌यो, मसी कां पयदा हयवा जोवे? ");
INSERT INTO bpx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","तीहया केदा, “यहुदा परदेस ना बेतलहम गाम मे; काहाके भगवान भणी गेथो केवा वाळो आना बारा मे केदलो से।” ");
INSERT INTO bpx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ए बेतलहम, तु यहुदा देस मे वाळा, काना बी मोट्‌ला ह़ेर मे गेथु नानु नी हय; काहाके तारी मे एवो राज करन्‌यो अदीकार्‌यो पयदा हय्‌न उजन्‌तो हयहे। जे मारा ईस्‌रायल ना माणहु नी देख-भाळ करहे।” ");
INSERT INTO bpx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","अळतेण तारा ने जाणवा वाळा जानकारु ने हेरोद राजा होगोत बोलायो अने तीमने पुसीन मालम कर लेदो के तारो कानी टेमे देखावा पड़लो। ");
INSERT INTO bpx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","अळतेण हेरोद राजा तीमने बेतलहम मोकल्‌यो अने हुकम आप्‌यो, “जावो, अने जाय्‌न सोरु ने ह़ोदो अने तीहयु सोरु जड़ जाय, ता मने खबर करजो, एतरे मे बी जाय्‌न तीना पोगे पड़ीन वांदही।” ");
INSERT INTO bpx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","तीहया राजा नी वात मानीन चाल पड़्‌या। अने जे तारा ने तीहया देखला हता, तीहयो तारो बी तीमनी अगळ-अगळ चाल पड़्‌यो, अने जां सोरु हतु तीहयात जागे जाय्‌न उबो री ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","तीहया तारा ने देख्‌या ता घण-जबर खुस हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","घोर मे मोय ज्‌या अने तीहयु, सोरु ने तीनी आय्‌ह मरीयम ह़ाते देख्‌या अने तीना पोगे पड़ीन वांद्‌या, अने तीहया आह़फा-आह़फा नी पेटारी मे गेथा नीकाळीन ईसु ने ह़ोनु, लोबान अने गंदायण्‌यु ईत्‌तर भेट कर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","काहाके भगवान तीहया जानकारु ने ह़पना मे चेताय देदलो के तमु हेरोद राजान तां नी जजो। एतरे तीहया बीजी वाट्‌ये पड़ीन आह़फाम ना देस जत र्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","तीहया जानकारु ने जवादीन मालीक नो दुत युसुफ ने ह़पना मे देखाव पड़्‌यो अने हुकम आपीन केदो, “उठ! सोरु अने तीनी आय्‌ह ने लीन मीसर देस नाह जा। जत्‌यार लग मे पासो चाल नी केम तत्‌यार लग तांत रेजे। काहाके हेरोद राजा मराय नाखवा करीन सोरु ने ह़ोदाड़वा वाळो से।” ");
INSERT INTO bpx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","आहयु ह़मळीन तीहयीत राते उठीन सोरु अने तीनी आय्‌ह ने लीन मीसर देस भणी चाल पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","तीहयो हेरोद राजा ने मरते लगण युसुफ मरीयम अने सोरु ह़ाते मीसर देस मेत र्‌यो, अळतेण मालीक भगवान वगे गेथी वात केण्‌या माणहु नी लारे केदली वात पुरी हये, “मे मारा सोरा ने मीसर देस मे गेथो बोलायो।” ");
INSERT INTO bpx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","अळतेण तारा ने जाणवा वाळा जानकारु मने धोको दीन जत र्‌या करीन हेरोद राजा ने घण-जबर रीह लागी। अने तीहयो सीपायड़ा ने आहयु कीन मोकल्‌यो के तारा ने जाणवा वाळा जानकारु नी केदली टेम पोर बेतलहम अने आड़े-धेड़े वाळा आखा सोरा ने मार नाखो, जे बे साल ना अने बे साल गेथा नाना से। ");
INSERT INTO bpx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","अने तत्‌यार भगवान वगे गेथा केण्‌या माणेह यीरम्‌या नी केदली वात पुरी हय जी, ");
INSERT INTO bpx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामा ह़ेर मे गीण आवे एवी अवाज ह़मळाय पड़ी, रड़वा अने नेहरा दीन रड़वु ह़मळाय पड़्‌यु। राहेल आह़फा सोरा नी करते रड़वा बाज री हती। काहाके तीहया हाव नी र्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोद ने मरवान बाद, मीसर देस मे युसुफ ने ह़पना मे मालीक नो दुत देखाव पड़ीन केदो, ");
INSERT INTO bpx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, सोरा ने अने तीनी आह्‌य ने लीन ईस्‌रायल ना देस मे जत रे, काहाके जे तारा सोरा ने मारवा हींडता हता, तीहया मर जेला से।” ");
INSERT INTO bpx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","तत्‌यार युसुफ नींदर मे गेथो जाग उठ्‌यो, अने सोरा ने अने तीनी आह्‌य ने ह़ाते लीन ईस्‌रायल ना देस मे पासो आयो। ");
INSERT INTO bpx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","तत्‌यार अरखीलाउस आह़फा ना बाह हेरोद ना जागे यहुद्‌या पोर राज करवा बाज र्‌यो, ईसम ह़मळीन तां जवा सी बीहतो हतो। अळतेण ह़पना मे भगवान सी खबर जड़ी अने गलील देस मे जत र्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अने नासरत नाम ना गाम मे जाय्‌न रेवा बाज ज्‌यो, काहाके तीहयो बोल पुरो हये, जे भगवान वगे गेथी वात केण्‌या माणहु नी लारे केदलो हतो: “तीहयो नासरी केवायहे।” ");
INSERT INTO bpx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","तीहया दाड़ा मे बपतीस्‌मा आपण्‌यो युहन्‌नो, युहदी जीला ना बड़ा मे आवीन, आड़ीन आहयु परच्‌यार करवा बाज ज्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“पापु ने सोड़ीन आह़फाम ना मन ने भगवान वगा वाळो, काहाके ह़रग नु राज ह़ातेत आय जेलु से।” ");
INSERT INTO bpx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","आहयो युहन्‌नो तीहयोत हतो, जीना बारा मे भगवान वगे गेथो वात केवा वाळो यसायो केदलो हतो: “उजाड़ी बड़ा मे आड़वा वाळा नी अवाज से: मालीक जुगु रोहो तीयार करो अने तीनी जुगु वाट ह़ुदी करो।” ");
INSERT INTO bpx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","आहयो युहन्‌नो ते उटड़ा ना नीम्‌बाळा ना लुगड़ा पेरत्‌लो अने केड़्‌या मे चामड़ा नो पट्‌टो बांदत्‌लो। तीनु खाणु टीड्‌या अने बड़ा मे नु मोद हतु। ");
INSERT INTO bpx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","यरुसलेम ह़ेर वाळा, आखा यहुद्‌या वाळा, अने यरदन नंदी ना आड़े-धेड़े ना गाम वाळा आखा माणहु युहन्‌नान तां आवता हता। ");
INSERT INTO bpx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","अने आपणा पापु ने मानीन यरदन नंदी मे तीना ह़ाते आया अने तीहयो बपतीस्‌मा आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","युहन्‌ना ढेरेत फरीसी माणहु ने अने सदुकी माणहु ने बपतीस्‌मा लेवा करीन आवत्‌ला देख्‌यो अने तीहयो तीमने केदो, “ए गड़हा ना बच्‌चा! तमु बपतीस्‌मा लेहु ता आव्‌वा वाळी गरा तमारी पोर गेथी टळ जहे ईसम तमने कोय की देदु? ");
INSERT INTO bpx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","आमु पाप भणी गेथा मन फीरवीन भगवान वगा वळ जेला से, ईसम जीवाय जीवीन आह़फा ने उजन्‌ता करो। ");
INSERT INTO bpx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","अने ‘आमु ते अब्‌राहम बाह नी अवल्‌यात से’ ईसम वीच्‌यारीन बेफीकर्‌या नी रेजो। मे तमने आहयु केम, भगवान दगड़ा मे गेथो बी अब्‌राहम वाटु सोरो उबजाड़ सके। ");
INSERT INTO bpx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","हाव झाड़ ना मुळ्‌या पोर कुराड़ी मेकाय जेली से। एतरे जे झाड़ वारु नी फाले, तीहयु झाड़ ने वाड देहे अने तीने आक्‌ठा मे धपाड़वा करीन नाख देहे। ");
INSERT INTO bpx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मे ते तमने पाप भणी गेथु मन फीरवीन भगवान वगा वळवा करीन पाणी सी बपतीस्‌मा आपु; बाखीन जे मारी अळतेण आव्‌वा वाळो से, तीहयो मारी गेथो घणो सक्‌ती वाळो से। मे तीना खाहड़ा उचलवा नी लायक बी नी हय। तीहयो तमने चोखली आत्‌मा अने आक्‌ठु सी बपतीस्‌मा आपहे। ");
INSERT INTO bpx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","तीहयो आह़फा नु ह़ुपड़ु तीना हात मे ली लेदलो से, अने तीहयो आह़फा ना खळा मे गम नीकाळीन चोखाळहे अने गम ने मोहटी मे भरहे, पण गम ना चारा ने आक्‌ठी मे नाख देहे जे कदी नी ओलाये।” ");
INSERT INTO bpx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","तीहयी टेमे, ईसु युहन्‌ना पांह बपतीस्‌मा लेवा करीन गलील जीला गेथो यरदन नंदी धेड़े ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","युहन्‌नो आहयु केतो जाय्‌न ईसु ने रोकवा बाज ज्‌यो, मने तारा हात सी बपतीस्‌मा लेवा नी जरवत से, अने तु मारीन्‌तां काहा आय र्‌यो? ");
INSERT INTO bpx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ईसु तीने जपाप आप्‌यो, “हमणे आहयु ईसमेत हयवा दे, आपणु ने, भगवान ने जे गमे तीने पुरु करवा करीन आहयुत करवा वारु से।” ता युहन्‌नो तेमेत हयवा देदो। ");
INSERT INTO bpx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ईसु तत्‌यारुत बपतीस्‌मा लीन पाणी मे गेथो उपर नीकळ्‌यो। ता तेतरी घड़ी ह़रग उगड़ी ज्‌यु, अने ईसु, भगवान नी आत्‌मा ने पारवान वेह मे आह़फा पोर उतरतली अने थांगत्‌ली देख्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अने तीना बारा मे ह़रग गेथो आहयो बोल ह़मळायो, आहयो मारो मोंगाळ्‌ळो सोरो से। जीनी सी घणो खुस से। ");
INSERT INTO bpx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ते वखत भुतड़ा सी ईसु नी पारख कराव्‌वा करीन आत्‌मा ईसु ने उजाड़ी बड़ा मे ली जी। ");
INSERT INTO bpx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ईसु चाळीह दाड़ा अने चाळीह रात उपाह़ करवा नी अळतेण तीने भुक वेला पाड़वा लागी। ");
INSERT INTO bpx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","अने पारखवा वाळो भुतड़ो आवीन ईसु ने केदो, कदीम तु भगवान नो सोरो हय, ता आहया दगड़ा ने हुकम आपीन कीदे, के तमु रोट्‌ला बण जावो। ");
INSERT INTO bpx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","पण ईसु भुतड़ा ने केदो, “सास्‌तर मे लीखलु से, ‘माणेह रोट्‌ला खाय्‌न नी जीवे पण तीहया भगवान ना मोडा मे गेथा नीकळवा वाळा एक-एक बोल सी जीवत्‌लो रेय।’” ");
INSERT INTO bpx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","भुतड़ो ईसु ने यरुसलेम मे ली ज्‌यो, जे चोखलु ह़ेर केवाये, अने मंदीर नी चोटली पोर उबो कर देदो। ");
INSERT INTO bpx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","अने भुतड़ो ईसु ने केदो, “कदीम तु भगवान नो सोरो हय, ता मंदीर नी चोटली पोर गेथो आह़फोत हेटो कुद पड़, काहाके चोखली सास्‌तर मे लीखलु से; भगवान तारी रखवाळी करवा करीन ह़रगदुत ने हुकम आपहे; तीहया तने उपरेत झेल लेहे, अने तारा पोगु मे दगड़ा नी ठेह नी लागवा देय।” ");
INSERT INTO bpx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ईसु, तीहया भुतड़ा ने अळी केदो, नेम सास्‌तर मे आहयु बी लीखलु से, तु आह़फा ना मालीक भगवान ने ना पारखे। ");
INSERT INTO bpx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","अळतेण भुतड़ो ईसु ने एक घणा उचा बड़ा पोर ली ज्‌यो अने तीने कळी ना आखा राज अने तीनु राज-पाट देखाड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","अने ईसु ने केदो, कदीम तु मने पोगे पड़ीन वांदे, अने मारी पुजा करे, ता मे तने आहयु आखु आप देही! ");
INSERT INTO bpx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तत्‌यार ईसु भुतड़ा ने केदो, “ए भुतड़ा, सेटो हय जा! काहाके चोखली सास्‌तर मे लीखलु से, तमु आह़फा ना मालीक भगवान ने वांद्‌या करो, अने नीस्‌ती तीनीत सेवा करो।” ");
INSERT INTO bpx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","अळतेण भुतड़ो, ईसु ने सोड़ीन जत र्‌यो, अने देखो ह़रगदुत आवीन तीनी चाकरी करवा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जत्‌यार ईसु आहयु ह़मळ्‌यो के बपतीस्‌मा आपण्‌यो युहन्‌ना धराय ज्‌यो, ता तीहयो गलील जीला मे जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","तीहयो नासरत ह़ेर ने सोड़ीन, कफरनहुम ह़ेर मे जे दर्‌या धेड़े जबुलुन अने नप्‌ताली ना देस मे जीन रेवा बाज ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","काहाके भगवान वगे गेथा केण्‌या यसाया नी लारे केदलु हतु तीहयु पुरु हये: ");
INSERT INTO bpx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबुलुन अने नप्‌ताली परगणा मे दर्‌या नी वाट्‌ये, यरदन नंदी नी बुडण्‌ला ईलाका वाळा, आड़जात्‌या ना देस गलील मे। ");
INSERT INTO bpx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","जे माणहु अंदारला मे जीव्‌वा बाज र्‌या हता। तीहया एक घणु मोटु वीजाळु देख्‌या, अने तीहया देस मे माणहु मोत ना साहळा मे जीवता हता, तीमनी पोर घणु मोटु वीजाळु हयु।” ");
INSERT INTO bpx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","तीहयी टेमे गेथो ईसु आहयु परच्‌यार करवा बाज ज्‌यो, पाप भणी गेथु मन फीरवीन भगवान वगा वळो। ह़रग नु राज ह़ाते आय लागलु से। ");
INSERT INTO bpx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","जत्‌यार ईसु गलील दर्‌या धेड़े माय्‌न जवा बाज र्‌यो हतो, ता बे भाय ने देख्‌यो, सीमोन ने, जे पतरस बी केवाये, अने तीना भाय अंदर्‌यास ने। तीहया दर्‌या मे जाळ नाख्‌वा बाज र्‌या हता काहाके तीहया काहर्‌या हता। ");
INSERT INTO bpx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ईसु तीमने केदो, “मारी ह़ाते चालो, मे तमने माणहु ने भगवान भणी कीकम लाव्‌वा ह़ीकाड़ही।” ");
INSERT INTO bpx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","अने तीहया तत्‌यारुत जाळ तांत रेवा दीन ईसु ह़ाते चाल पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","अने ईसु तां गेथो अगो ज्‌यो ता तां अळी बीजा बे भाय ने देख्‌यो, जब्‌दी ना सोरो याकुब ने अने तीना भाय युहन्‌ना ने तीहया आह़फाम ना बाह जब्‌दी ह़ाते ढुंड्‌या मे आह़फाम नी जाळ ह़ुदारता हता। ईसु तीमने बोलायो। ");
INSERT INTO bpx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","अने तीहया तत्‌यारुत ढुंड्‌या ने अने आह़फाम ना बाह ने सोड़ीन ईसु ह़ाते चाल पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ईसु गलील जीला मे फीरतो जाय्‌न भगवान ना भक्‌ती ना घोरु मे ह़ीकापण आप्‌तो र्‌यो, अने भगवान ना राज नी खुस-खबर परच्‌यार करतो र्‌यो। अने माणहु नी आखी भाती नी मंदवाड़ अने लुलखाय सेटी करीन आरगो कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","अने आखा सीरीया देस मे ईसु नी खबर फेल जी। माणहु फेपराळा माणहु ने, लखवा हयला माणहु ने अने एवा कंय भाती ना मंदवाड़ वाळा ने दुख मे पड़ला माणहु ने अने भुत लागला माणहु ने ईसुन्‌तां लावता हता अने तीहया आखा ने आरगा करतो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","अने गलील जीला मे गेथा, दीकापुलीस मे गेथा, यरुसलेम गेथा, युहद्‌या मे गेथा, अने यरदन नंदी नी ह़ेली धेड़े गेथा, माणहु ना मोटा-मोटा टोळो ईसु पसळ आवता हता। ");
INSERT INTO bpx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ईसु माणहु ना मेळा ने देखीन बड़ा पोर चड़ ज्‌यो, अने तां बह ज्‌यो। ता तीना चेला तीनीन्‌तां आया। ");
INSERT INTO bpx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","अने तीहयो तीमने आहयु केतो जाय्‌न ह़ीकापण आपवा बाज ज्‌यो; ");
INSERT INTO bpx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“जुगाळा से तीहया जे मन ना गरीब से! काहाके ह़रग नु राज तीमनुत से।” ");
INSERT INTO bpx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“जुगाळा से तीहया, जे दुखी हय्‌न रड़े काहाके तीमने सांती जड़हे।” ");
INSERT INTO bpx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“जुगाळा से तीहया जे नीचळा से! काहाके आहयी धरती ना हकदार्‌या से।” ");
INSERT INTO bpx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“जुगाळा से तीहया, जे धरमीपणा ना भुकला अने तरहेला से! काहाके भगवान तीमने नीरहा कर देहे।” ");
INSERT INTO bpx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“जुगाळा से तीहया, जे गीणाळ्‌ळा से! काहाके भगवान तीमनी पोर गीण करहे।” ");
INSERT INTO bpx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“जुगाळा से तीहया, जीमना मन चोखला से! काहाके तीहया भगवान ने देखहे।” ");
INSERT INTO bpx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“जुगाळा से तीहया, जे मेळ कराव्‌वा वाळा से! काहाके तीहया भगवान ना सोरा केवायहे।” ");
INSERT INTO bpx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“जुगाळा से तीहया, जे धरमीपणा ना कारण दुख झेले, काहाके ह़रग नु राज तीमनुत से।” ");
INSERT INTO bpx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“जुगाळा से तमु, जत्‌यार माणहु मारीन करते तमारी नामबद्‌दी करे अने वेला पाड़े, अने तमारी पोर आखी भातीन कुहराय करीन झुटो गुनो लगाड़े। ");
INSERT INTO bpx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तमु खुस रेजो अने खुसी मनावजो काहाके तमारी वाटु ह़रग मे घणु मोटु ईलाम से। काहाके आहयीत रीते भगवान वगे गेथा केण्‌या माणहु ने वेला पाड़ता हता।” ");
INSERT INTO bpx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","तमु धरती नु खारलु मीठु से। कदीम खारलु मीठु नु खारापण जत रेय, ता तीने कानी बी चीज वेर खारु नी कर सके, अने तीहयु कंय काम नु नी रेय। अने तीहयु बारथु नाखवा अने माणहु ना पोग तळे कचरायवा वाटु से। ");
INSERT INTO bpx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तमु कळी नु वीजाळु से। जे ह़ेर बड़ा पोर वहलु से तीहयु ह़ताये नी। ");
INSERT INTO bpx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","माणहु दीवो धपाड़ीन कांगणी तळे नी मेले, बाखीन दीवलाय पोर मेले, ता तीहयो दीवो आखा घोरल्‌या ने वीजाळु आपे। ");
INSERT INTO bpx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","दीवा नु वीजाळु नी तेम भबलीन तमारा भला काम बी माणहु अगळ उजन्‌ता हयवा देवो। तीनी सी तीहया तमारा भला काम ने देखीन ह़रगे वाळा तमारा भगवान बाह नी बड़ाय करे। ");
INSERT INTO bpx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","तमु ईसम ना ह़मजो के मुसान लीखली सास्‌तर ने अने भगवान वगे गेथा केण्‌या माणहुन सास्‌तर ने खत्‌तम करवा आवलो। मे तीमने खत्‌तम नी, बाखीन पुरी करवा आवलो से। ");
INSERT INTO bpx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","मे तमने ह़ाचलीन केम, के जत्‌यार लग ह़रग अने धरती खत्‌तम नी हय जाय, मुसा नी लीखली सास्‌तर ना बोल नी एकीक वात अने एकीक अक्‌सर पुरो हया वगर नी टळे। ");
INSERT INTO bpx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","एतरे जे कोय आहया हुकम मे गेथा काना बी नान्‌ला हुकम ने पाळवा सोड़ देय, तीहयो ह़रग राज मे नानो केवायहे। पण जे कोय तीहया हुकम ने पाळ्‌या करहे अने तीमने ह़ीकाड़हे, तीहयो ह़रग ना राज मे मोटो केवायहे। ");
INSERT INTO bpx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","मे तमने केम, कदीम तमु चोखली सास्‌तर ह़ीकाड़न्‌या गेथा अने फरीसी माणहु गेथा वदीन धरमपणा मे नी चालो ता तमु ह़रग राज मे नी भराय सके। ");
INSERT INTO bpx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","तमु ह़मळी लेदला से, तमारा आड़ा-बुड़ा ने आहयु केदलु हतु के मारजो नी, जे कोय मारहे ता कोरट-कचवरी मे नीयाव ना दाड़े डंड नी लायक ठेरहे। ");
INSERT INTO bpx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पण मे तमने केम जे कोय आह़फा ना भाय पोर रीह करहे तीने कोरट-कचवरी मे नीयाव ना दाड़े डंड नी लायक ठेरहे। अने कदीम कोय आह़फा ना भाय ने रीकामा, केहे तीहयो मोट्‌ली पंचु मे डंड नी लायक ठेरहे; अने जे कोय आह़फा ना भाय ने ए गांडा, केहे तीहयो नरक नी आक्‌ठी नो डंड नी लायक ठेरहे। ");
INSERT INTO bpx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","कदीम तमु वेदी पोर आह़फा नी भेट चड़ाव्‌वा लाय र्‌या हय, अने तां ह़ारीक तमने आहयु फोम आवे के मारा भाय ना मन मे मारी भणी गेथु कंय वीरोद से। ");
INSERT INTO bpx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ता तु आह़फा नी भेट तांत वेदी अगळ रेवा दीन पेले आह़फा भाय ह़ाते मेळ कर ले अने अळतेण आवीन भेट ने चड़ावो। ");
INSERT INTO bpx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","तारो वेरी तने थाणा मे लीन जवा वखत वाट्‌येत हय, ता तीने छोटोत आह़फा नो दोस्‌तीदार बणाय ले कंखर तीहयो तने नीयाव करन्‌या ना हात मे कर देय, अने नीयाव करन्‌यो तने सीपायड़ा ना हात मे कर देय, अने सीपायड़ा तने जेल मे कुंड देय। ");
INSERT INTO bpx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मे तने ह़ाचलीन केम, तु जेल सी तां लग नी छुट सकतो जांह तक तु पाय-पाय नी आप देय। ");
INSERT INTO bpx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","तमु जाणो के आहयु केदलु से, छीनाळु नी करजो, ");
INSERT INTO bpx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पण मे तमने केम, जे कोय कानी बयर भणी तीनी ह़ाते छीनाळु करवा नो वीच्‌यार करीन देखे, ता तीहयो आह़फा ना मन मे तीनी ह़ाते छीनाळु कर लेदलो से। ");
INSERT INTO bpx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","कदीम तमारो जमण्‌यो डोळो तमने पाप करावे, ता तीने काडीन नाख देवो। काहाके वारु ते आहयुत से के तमारा डील मे ना एक अंग खुट जाय, पण तमारु आखु डील नरक मे नी आक्‌ठी मे नी नखाये। ");
INSERT INTO bpx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अने कदीम तमारो जमण्‌यो हात पाप करे, ता तीने वाडीन नाख देवो; वारु आहयुत से के तमारा डील मे नु भले एक अंग खुट जाय, पण तमारु आखु डील नरक मे नी नखाये। ");
INSERT INTO bpx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","आहयु बी केदलु हतु के, जे कोय आह़फा नी लाडी ने सोड़े तीहयो तीने सोड़वा नी चीट्‌ठी लीखीन पुरावा भेळ आप देवा जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","बाखीन मे तमने केम, छीनाळा नी वात ने सोड़ीन काना बी बीजा कारण सी, जे आह़फा नी लाडी ने सोड़े; ता तीहयो तीने छीनाळु करावे, अने जे कोय तीहयी छुट्‌ली बयर सी वेवा करे, तीहयो बी छीनाळु करे। ");
INSERT INTO bpx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","तमु आहयु बी ह़मळी र्‌या के आड़ा-बुड़ा सी केदलु हतु के झुटी ह़ाम नी खाजो, पण मालीक सी करली ह़ाम ने पुरी करजो। ");
INSERT INTO bpx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पण मे तमने केम ह़ाम नी खाजो। ह़रग नी ह़ाम बी नी खाजो, काहाके ह़रग भगवान नी राजगादी से; ");
INSERT INTO bpx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","धरती नी ह़ाम नी खाजो, काहाके तीहयी तीनो पोग मेलवा नो पाटलो से। यरुसलेम नी ह़ाम नी खाजो, काहाके यरुसलेम मोट्‌ला राजा नु ह़ेर से। ");
INSERT INTO bpx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","अने आह़फा ना मुंडा नी बी ह़ाम नी खाजो, काहाके तमने मुंडा नो एक बी नीम्‌बाळा धोळा नीता काळा नी कराये। ");
INSERT INTO bpx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","कदीम तमारी वात “होव हय” ता “होव केजो” अने “नी” हय ता “नी” केजो। काहाके आनी गेथु वदु केय तीहयु बुराय मे गेथु से। ");
INSERT INTO bpx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“तमु आहयु बी ह़मळी र्‌या के केदलु हतु के ‘एक डोळा बदले, एक डोळो, अने एक दात बदले, एक दात।’” ");
INSERT INTO bpx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पण मे तमने केम, काना बी कुहर्‌या माणेह नो वीरोद ना करो; पण कदीम कोय तमारा जमणा गाल्‌या पोर थापड़ देय, ता तीनी भणी बीजु गाल्‌यु बी फीरवी देवो। ");
INSERT INTO bpx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","कदीम कोय तारी पोर जोर करीन तमारु डगलु मांगे ता तीने आह़फा नो कोट बी आप देवो। ");
INSERT INTO bpx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","अने कदीम कोय तमने जोर करीन एक कीलोमीटर ली जाय ता तीनी ह़ाते बे कीलोमीटर चालीन जावो। ");
INSERT INTO bpx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जे कोय तमारी पांह मांगे, ता तीने आप देवो, अने कोय तमारी पांह उदार मांगे, तीने नी ना केवो। ");
INSERT INTO bpx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","तमु ह़मळी र्‌या: केदलु हतु के आह़फा ना ह़ाते वाळा ने मोंग करो अने आह़फा ना वेरी सी रीह राखो। ");
INSERT INTO bpx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पण मे तमने केम, आह़फा ना वेरी ने मोंग करो। अने जे कोय तमने वेला पाड़े, तीमनी वाटु वीन्‌ती करो। ");
INSERT INTO bpx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ईसम करीन तमु आह़फा ना ह़रग वाळा भगवान बाह नी अवल्‌यात बण जहु; काहाके तीहयो भोळा अने कुहर्‌या बेम माणहु पोर आह़फा नु दाड़ो उगाड़े अने धरमी अने वण-धरमी बेम माणहु पोर पाणी पाड़े। ");
INSERT INTO bpx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","कदीम तमु तीमनेत मोंग करो, जे तमने मोंग करे, ता तमने ह़ु फोळ जड़हे? एवो मोंग ते फाळो लेवा वाळा बी नी करे। ");
INSERT INTO bpx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","अने कदीम तमु आह़फा ना भाय ने एतरोत वारु से, के करीन पुछो, ता तमु कानु मोटु काम कर र्‌या? आड़जात्‌या माणहु ईसम नी करे ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","एतरे तमु पुरा पाका बणो, जीसम तमारो ह़रग वाळो बाह पुरो पक्‌को से। ");
INSERT INTO bpx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","चेतीन रेवो! भगवान ने गमे तीहया धरम ना कामु ने माणहु अगळ देखाड़वा करीन ना करो, ईसम करहु ता तमने ह़रग वाळा बाह भणी गेथो फोळ कदी नी जड़े। ");
INSERT INTO bpx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","एतरे जत्‌यार तमु काना गरीब दुखी ने दान आपो, ता तीहयी वात ने आखा अगळ ना केवो, जीसम के भक्‌ती ना घोरु अने गळी मे ढोंगड़ा करन्‌या माणहु बीजा पांह बड़ाय हात करवा करीन करे। मे तमने ह़ाचलीन केम, तीमने तीमनी बड़ाय नी लारे पेलेत फोळ जड़ जेलु से। ");
INSERT INTO bpx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","एतरे जत्‌यार तमु दान आपो, ता तमारो डाखर्‌यो हात आहयु नी जाणवा जोवे के तमारो जमणो हात ह़ु करवा बाज र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","के तमारु दान ह़तायलु रेहे। ता तमारो भगवान बाह जे तु ह़ताड़ीन करे तीने बी देखे, तीहयो तने तीनु ईलाम आपहे। ");
INSERT INTO bpx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","अने जत्‌यार बी तमु वीन्‌ती करो, ता ढोंगड़ा करन्‌यान तेम ना करो। काहाके माणहु ने देखाड़वा नी लेदे भक्‌ती ना घोर-घोर अने वाट ना मेळ्‌या पोर उबा रीन वीन्‌ती करवा तीमने वारु लागे। मे तमने ह़ाचलीन केम, हीमनी बड़ाय नी लारे पेलेत हीमने फोळ जड़ जेलु से। ");
INSERT INTO bpx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पण जत्‌यार तु वीन्‌ती करे, ता आह़फा ना घोर मे जा अने झापलु दीन ह़ताय्‌न आपणा भगवान बाह सी वीन्‌ती कर। तत्‌यार तारो बाह जे ह़ताय्‌न देखे, तने फोळ आपहे। ");
INSERT INTO bpx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","वीन्‌ती करती वखत आड़जात्‌यान तेम जादा बोलु नी केजो। काहाके तीहया आहयु सोचे के नाम्‌बी वीन्‌ती करवा सी अमारी वीन्‌ती ह़मळहे। ");
INSERT INTO bpx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","एतरे तमु तीमनीन तेम ना बणो, काहाके तमारो बाह तमारी मांगवा सी पेलेत जाणे के तमने ह़ु-ह़ु जरवत से। ");
INSERT INTO bpx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","एतरे ईसम वीन्‌ती करो, “ए अमारा बाह, तु जे ह़रग मे से तारु नाम चोखलु मनाये। ");
INSERT INTO bpx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तारु राज आवे। तारी मरजी जीसम ह़रग मे पुरी हये, तेमेत आहयी धरती पोर बी पुरी हये। ");
INSERT INTO bpx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","दाड़ीन, आमने जोवे तेतरु खाणु आप्‌या कर। ");
INSERT INTO bpx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","अने जीसम आमु अमारा गुनेगार ने तीमना पाप ना लेदे माफी आपला से, तेमेत तु अमारा पाप ना लेदे आमने माफी आप; ");
INSERT INTO bpx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अने जत्‌यार पाप कराव्‌वा नी पारख आवे ता आमने पाप मे नी पड़वा देजे, पण बुराय सी बचाड़।” ");
INSERT INTO bpx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","कदीम तमु माणहु ने तीमना पाप नी लेदे तीमने माफी आपो, ता तमारो ह़रग वाळो बाह बी तमारा पाप नी लेदे तमने माफी आपहे ");
INSERT INTO bpx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","पण कदीम तमु माणहु ने तीमना पाप नी लेदे माफी नी आपो, ता तमारो ह़रग वाळो बाह बी तमारा पाप नी लेदे तमने माफी नी आपे। ");
INSERT INTO bpx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","जत्‌यार तमु उपाह़ करो, ता ढोंगड़ा करन्‌यान तेम तमारा मोडा पोर नुरपाणी नी रेय, काहाके तीहया आपणु मोडु बी नी धोवे, काहाके माणहु तीमने उपाह़ वाळो जाणे। मे तमने ह़ाचलीन केम, के तीमने आपणु ईलाम जड़ जेलु से। ");
INSERT INTO bpx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पण जत्‌यार तु उपाह़ करे ता आह़फा ना मुंडे तेल लगाड़ अने मोडु धोव, ");
INSERT INTO bpx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","काहाके माणहु नी पण तारो बाह जे ह़रग मे से, तने उपाह़ वाळो जाणे। ईसम रेवा मे जे तारो बाह ह़ताय्‌न देखे, तने तीनो फोळ आपहे। ");
INSERT INTO bpx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“आपणी जुगु धरती पोर धन एकठु ना करो, आञे ते कीड़ो अने वेदाय बगाड़त्‌ला से, अने आञे चोट्‌टा डाको डाले अने चोरी कर लेय। ");
INSERT INTO bpx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पण आपणी जुगु ह़रग मे धन एकठु करो तां नी ते कीड़ो अने नी वेदाय बगाड़े, अने तां चोट्‌टा नी डाको डाले अने नी चोरी करे। ");
INSERT INTO bpx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काहाके जां तमारु धन से तां तमारु मन बी लागलु रेहे।” ");
INSERT INTO bpx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“डील नो दीवो डोळा से: एतरे कदी तारा डोळा चोखा हय, ता तारु आखु डील बी वीजाळा मे रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","पण कदी तारा डोळा चोखा नी हय, ता तारु आखु डील बी चोखलु नी रेहे; आनीन करते तीहयु वीजाळु जे तारी मे से कदी अंदारलु हय ता तीहयु अंदारलु कीसम मोटु हहे।” ");
INSERT INTO bpx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","काना बी माणेह ने बे मालीक नी चाकरी नी कराये; काहाके तीहयो एक मालीक सी ह़ीगी करहे अने बीजा मालीक ने मोंग करहे; नीता एक मालीक ह़ाते मेळीन रेहे अने बीजा मालीक नो वाक काडहे। तमने भगवान नी अने धन-दवलत नी बेम नी सेवा नी कराये। ");
INSERT INTO bpx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","एतरे मे तमने केम के आह़फाम ना जीव ना लेदे आहयी फीकर नी करजो के आमु ह़ु खाहु अने ह़ु पीहु; अने नीता आह़फाम ना डील जुगु ह़ु पेरहु। ह़ु जीव खाणा सी, अने डील लुगड़ा सी मोटु नी हय ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","वादळा मेना चड़ा ने देखो! तीहया नी वेरे, नी वाडे, अने नी मोहटी मे भेळु करे, ते बी तमारो ह़रग वाळो बाह तीमने खवाड़े। ह़ु तमु तीमनी सी जादा कीमत नी राखो? ");
INSERT INTO bpx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तमारी मे गेथु आसम कोय से, जे फीकर करीन आह़फा नी जीवाय नी अमाळ बी उमर बड़ाय सके? ");
INSERT INTO bpx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“अने लुगड़ा जुगु ह़ुका फीकर करो? जंगल मे ना फुलु पोर ध्‌यान करो, के तीहया कीसम वदे, तीहया नी ते मेहनत करे, नी ते लुगड़ा बणावे। ");
INSERT INTO bpx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ते बी मे तमने ह़ाचलीन केम के सुलेमान आह़फा नी बड़ाय मे तीमनी माय्‌न कोयने तेम लुगड़ा पेरलो नी हतो। ");
INSERT INTO bpx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","एतरे जत्‌यार भगवान चोवगान ना चारा ने, जे आज से, अने काले आक्‌ठा मे नाख देहु, एवा लुगड़ा पेरावे, ता ए वण-भरहा वाळा, तमने तीहयो काहा नी पेरावे? ");
INSERT INTO bpx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","एतरे तमु फीकर करीन आहयु नी केजो, के आमु ह़ु खाहु, अने ह़ु पीहु अने ह़ु पेरहु। ");
INSERT INTO bpx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","काहाके आड़जात्‌या आहयी आखी चीज नी ह़ोद मे रेय, अने तमारा ह़रग वाळो बाह जाणे, के तने आहयी आखी चीज जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","एतरे पेले तमु भगवान ना राज नी अने धरमीपणा नी ह़ोद करो ता आहयी आखी चीज तमने जड़ जहे। ");
INSERT INTO bpx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","एतरे काले नी फीकर ना करो, काहाके काले नो दाड़ो आह़फा नी फीकर आह़फो कर लेहे; आज नी लेदे आज नोत दुख ढेरेत से। ");
INSERT INTO bpx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“गुनो ना लगाड़ो, ता गुनो तमारी पोर बी नी लगाड़े। ");
INSERT INTO bpx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","काहाके जे रीते तमु गुनो लगाड़ो, तीहयी रीते तमारी पोर बी गुनो लगाड़हे; अने जे माप सी तमु मापहु, ते माप सी तमारी वाटु बी मपायहे।” ");
INSERT INTO bpx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“तु ह़ुका तारा भाय ना डोळा मे वाळु कचरु देखे, अने तारा डोळा मे वाळु खटकु तने नी देखातु। ");
INSERT INTO bpx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","तु तारा भाय ने कीकम की सकत्‌लो, ‘लाव’ मे तारा डोळा मे गेथु कचरु नीकाळ देम, पण देख, खटकु ते तारा डोळा मे से?” ");
INSERT INTO bpx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ए ढोंगड़ा करन्‌या, पेले आह़फा ना डोळा मे वाळु खटकु नीकाळ ले, ता तारा भाय ना डोळा मे वाळु कचरु नीकाळवा करीन वारु देख सकही। ");
INSERT INTO bpx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“चोखली चीज कुतरा ने ना आपो, अने आह़फाम ना मोती ह़ुवर्‌या ना अगळ ना नाखो, कंखर ईसम नी हय जाय के तीहया तीने तीमना पोगु तळे डाबहे अने पासा फीरीन तमने फाड़ देहे।” ");
INSERT INTO bpx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","मांगहु ता तमने आपहे, ह़ोदहु ता जड़हे; झापलु ठोकहु, ता तमारी वाटु उगड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","काहाके जे कोय मांगे, तीने आपे; अने जे ह़ोदे, तीने जड़े; अने जे झापलु ठोके, तीनी जुगु झापलु उगाड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तमारी माय्‌न एवो कानो माणेह से, कदीम तीनो सोरो तीनी पांह रोट्‌लो मांगे, ता तीने दगड़ो आपे? ");
INSERT INTO bpx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","अने माछला मांगे, ता तीने गड़हो आपे? ");
INSERT INTO bpx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","कदीम तमु गांडा हय्‌न, बी तमारा सोरा ने वारली चीज आपवा जाणो, ता तमारो ह़रग वाळो बाह बी मांगवा वाळा ने वारली चीज काहा नी आपहे? ");
INSERT INTO bpx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","अने जे वेहवार नी हेर तमु बीजा सी कर र्‌या; तीहयो वेहवार तमु बीजा ह़ाते बी कर्‌या करो; काहाके मुसा नो नेम अने भगवान वगे गेथा केण्‌या नी ह़ीकापण आहयी से? ");
INSERT INTO bpx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ह़ाकड़ला झापले माय्‌न चालो, काहाके चवड़लो रोहो से तीहयो रोहो अळी वारु से तीहयो रोहो नास भणी लीजत्‌लो से; अने ढेरेत से जे तीनी सी चालत्‌ला से। ");
INSERT INTO bpx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","काहाके ह़ाकड़ु से तीहयु झापलु अने काठो से तीहयो रोहो जे जीव ने तां ली जाय; अने थोड़ाक से जे तीने हात करे। ");
INSERT INTO bpx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“झुटा भगवान वगे गेथी वात केण्‌या माणहु सी चेतीन रेवो, अने जे गाडरान तेम तमारी ह़ाते आवे, पण अळतेण फाड़वा वाळा लेंड्‌या से। ");
INSERT INTO bpx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","तीना फोळ सी तमु तीने ओळखी लेहु। माणहु कटाळस्‌या झाटवा सी अंगुर, नीता गोखरा काटान वेले गेथा गुलर तोड़े ह़ु। ");
INSERT INTO bpx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","एमेत कानु बी वारलु झाड़ वारलु फोळ लावे अने रीकामा झाड़ खोड़लो फोळ लावे। ");
INSERT INTO bpx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","वारलु झाड़ खोड़लु फोळ कदी नी लावे, अने नी खोड़लु झाड़ वारलु फोळ लावे। ");
INSERT INTO bpx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जे-जे झाड़ वारलु फोळ नी लावे तीहया झाड़ ने वाडीन आक्‌ठु मे नाखे। ");
INSERT INTO bpx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ता तीमना फोळ सी तमु तीमने ओळखी लेहु।” ");
INSERT INTO bpx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","जे मने “ए मालीक! ए मालीक! केय, तीमनी माय्‌न कोय बी ह़रग राज मे भराय नी सके, पण तीहया एतरा जे मारा ह़रग वाळा बाह नी मरजी पोर चाले।” ");
INSERT INTO bpx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","तीहया नीयाव ना दाड़े घणा ढेरका माणहु मने केहे, मालीक! आमु तारु नाम लीन भगवान वगे गेथी वात नी केदा ह़ु? तारु नाम लीन भुत ने नी नीकाळ्‌या ह़ु? अने तारु नाम लीन सक्‌ती ना काम नी कर्‌या ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तत्‌यार मे तीमने चोखुझण की देही, “मे तमने नी ओळखु। ए पाप करन्‌या! मारीन्‌तां गेथा सेटा हय जावो।” ");
INSERT INTO bpx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","जे मारी आहयी वात ने ह़मळीन तीनीन तेम जीवे, तीहयो तीना ह़मजदार माणेह ने तेम से, जे आह़फा नु घोर चाफर्‌या पोर वारु पायो खोदीन बणायो। ");
INSERT INTO bpx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","पाणी पड़्‌यो, अने नंदी आवी, अने आंजी बी आवी अने तीना घोर ने अफठायी। ते बी तीहयो घोर नी ओदर्‌यु; काहाके तीनो नीव चाफर्‌या मे खोदीन बणावलु हतु। ");
INSERT INTO bpx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","जे मारी आहयी वात ह़मळीन तीनीन तेम नी जीवे, तीहयो तीहया वण-अकल्‌या माणेह ह़रको से, जे रेत पोर पायो खोदीन आह़फा नु घोर बणायो। ");
INSERT INTO bpx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","पाणी पड़्‌यो, नंदी आवी, अने आंजी बी आवी अने तीना घोर ने अफठायी। तीहयु घोर ओदरी ज्‌यु अने खत्‌तम हय ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जत्‌यार ईसु आहयी वात की देदो, ता माणहु तीनी ह़ीकापण ह़मळीन वहराय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काहाके तीहयो चोखली सास्‌तर ह़ीकाड़न्‌यान तेम नी, पण एक अदीकारीन तेम ह़ीकापण आप्‌तो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जत्‌यार ईसु तीहया बड़ा पोर गेथो हेटो उतर्‌यो। ता एक घणो मोटो माणहु नो मेळो तीनी पसळ चाल पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","अने एक कुड़ावो माणेह ईसुन्‌तां आयो अने तीहयो तीना पोगे पड़ीन वांद्‌यो अने वीन्‌ती कर्‌यो, “ए मालीक। कदीम तारी मरजी हय ता मने चोखो कर दे।” ");
INSERT INTO bpx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ईसु हात अगो करीन ईसम केतो जीन तीने छीम्‌यो, मारी मरजी बी आहयी से के तु वारु हय्‌न चोखो हय जा। अने तत्‌यारुत तीहयो वारु हय्‌न चोखो हय ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","अने ईसु तीने केदो, ह़मळ आञे जे हयु तीहयु कोयने नी केजे। पण पुंजारान्‌तां जा, अने आह़फा नु डील ने देखाड़जे। अने मुसा ना कायदान लारे तीने भेट चड़ावजे; ता आखा माणहु जाणीन गवा बण जहे। ");
INSERT INTO bpx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जत्‌यार ईसु कफरनहुम ह़ेर मे आयो, ता तीनीन्‌तां एक रोमी राज नो सुबेदार आयो अने तीनी सी वीन्‌ती कर्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ए मालीक मारा पावोर ने लखवा नी बीमारी हय री, अने तीने वेला हय री तीहयो घोर मे दुखी हय्‌न पड़ र्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ईसु तीने केदो, “मे आवीन तीने आरगो कर देही।” ");
INSERT INTO bpx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सुबेदार केदो, “ए मालीक मे एतरो वारु नी हय के तु मारा घोर आवे। पण तु एकीत बोल कीदे ता मारो पावोर आरगो हय जहे।” ");
INSERT INTO bpx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","मे आहयी वात जाणु काहाके मे बी एक अदीकार्‌यो से, अने मारा हात मे सीपायड़ा रेय। जत्‌यार मे एक ने केम “जा” ता तीहयो जाय अने बीजा ने, आव, केय, ता तीहयो आवे अने मारा पावर्‌या ने, आहयु कर, केम ता, तीहयो तीहयुत करे। ");
INSERT INTO bpx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ईसु आहयु ह़मळीन वहराय ज्‌यो अने तीहयो आह़फा नी पसळ आवण्‌या ने केदो, मे तमने ह़ाचलीन केम, मे ईस्‌रायली माणहु मे बी कोयने एतरो मोटो भरहो करत्‌लो नी देख्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","मे तमने केम, ढेरेत आड़जात्‌या माणहु उगवणा अने बुडवणा गेथा आवीन अब्‌राहम, ईसाक अने याकुब भेळता ह़रग राज मे बठहे। ");
INSERT INTO bpx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पण राज्‌य नी अवल्‌यात ने बारथा अंदारला मे नाख देहे: तां रड़हे अने दातु ककड़ावता रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","अने सुबेदार ने ईसु केदो, जा जीसम तु भरहो करलो से, तेमेत तारी जुगु हय जाय। अने तेत्‌री घड़ी तीनो पावोर आरगो हय ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","पतरस ना घोर ईसु पुग्‌यो, ता तां पतरस नी ह़ाह़ु ने ताव चड़ रेलो देख्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ईसु तीनो हात छीम्‌यो, अने तीनो ताव उतर ज्‌यो, अने तीहयी उठीन तीमनी चाकरी करवा बाज ज्‌यी। ");
INSERT INTO bpx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ह़ान्‌ती टेमे माणहु, भुत लागला ढेरेत माणहु ने ईसुन्‌तां लाया। ईसु एकीत बोल कीन भुत ने माणहु मे गेथा नीकाळ्‌यो अने आखा मांदला ने वारु कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","भगवान वगे गेथी वात केण्‌या यसाया नी वात पुरी करवा करीन आहयु आखु हयु, तीहयो आखु लीखलो हतो: तीहयो अमारी आखी लुलखाय ने झेल लेदो, अने अमारी मंदवाड़ ने सेटी कर देदो। ");
INSERT INTO bpx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ईसु आह़फान नी च्‌यारो-मेर एक मोट्‌लो मेळो देखीन चेला ने दर्‌या नी ह़ेली धेड़े जवा नो हुकम आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तेतरी घड़ी एक चोखलु सास्‌तर ह़ीकाड़न्‌यो आवीन ईसु ने केदो, मास्‌तर! तु जां बी जही, तां-तां मे तारी पसळ आवही। ");
INSERT INTO bpx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ईसु तीने केदो, लेंड्‌या जुगु रेवा करीन तीमना दोर से अने ह़रग ना चड़ा जुगु तीमना पोतरा से, पण मनख्‌या ना सोरा जुगु मुंडु मेलवा लग जागो नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","चेला मे गेथो एक चेलो केदो, “ए मालीक मे तारी पसळ आवही, पण मने पेले मारा बाह ने गाड़वा करीन जवा दे।” ");
INSERT INTO bpx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","पण ईसु तीहया चेला ने केदो, मरला ने मरला माणहु गाड़हे पण तु मार ह़ाते चाल। ");
INSERT INTO bpx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जत्‌यार ईसु ढुंड्‌या मे बह ज्‌यो ता तीना चेला बी ह़ाते बह ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","अने तीहयी वखत दर्‌या मे उचकाहलुत घण-जबर आंजी आयी, अने दर्‌या नी झलक ढुंड्‌ये अफठाय्‌न ढुंड्‌या ने घेरवी री हती। पण ईसु ह़ुव्‌वा बाज र्‌यो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","चेला ह़ाते आवीन ईसु ने जगाड़्‌या अने केदा, मालीक आमने बचाड़! आमु मरवा बाज र्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ईसु तीमने केदो, ए, वण-भरह्‌या! तमु एतरी जबर ह़ुका बीही र्‌या? अळतेण तीहयो आंजी अने पाणी ने वड्‌यो अने आखु धीरु पड़ ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","आहयु देखीन तीहया वहराय ज्‌या, अने केदा, आहयो केवो माणेह से के आंजी अने दर्‌या लग हुकम माने। ");
INSERT INTO bpx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जत्‌यार ईसु दर्‌या नी ह़ेली धेड़े गदरेनीया देस मे पुग्‌यो, ता भुत चोटला बे अदमी मड़ाट्‌या मे गेथा नीकळीन ईसुन्‌तां आया। तीहया एतरा आकरा हता के तीहयी वाट्‌ये कोयने बी नी अवायतु-जवायतु हतु। ");
INSERT INTO bpx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","तीहया आड़ीन केदा, “ए भगवान ना सोरा! अमारी ह़ाते तारु ह़ु काम से? टेम नी आयी अने पेले गेथोत आमने वेला पाड़वा आय र्‌यो ह़ु?” ");
INSERT INTO bpx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","तां गेथो थोड़ोक सेटो ह़ुवर्‌या नो एक टोळो चरवा बाज र्‌यो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","भुत आहयु केता जाय्‌न वीन्‌ती कर्‌या, कदीम तु आमने नीकाळवा बाज र्‌यो, ता आमने ह़ुवर्‌या ना ह़ेला टोळा मे मोकली दे। ");
INSERT INTO bpx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ईसु तीमने हुकम आपीन केदो, जावो ता भुत तीहया माणहु मे गेथा नीकळीन ह़ुवर्‌या मे भराय ज्‌या अने तीहया आड़खे गेथा दर्‌या मे कुद पड़्‌या अने पाणी मे डुबीन मर ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","अने ह़ुवर्‌या ने चारन्‌या नाही पड़्‌या, अने तीहया जे हयु तीहयु आखु ह़ेर मे जाय्‌न की देदा। अने भुत चोटला माणहु नु ह़ु हयु तीहयु बी की देदा। ");
INSERT INTO bpx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","अने ह़ेर ना आखा माणहु ईसु ने भेटवा आया, अने जत्‌यार तीहया ईसु ने देख्‌या ता तीनी सी वीन्‌ती कर्‌या, तु अमारा देस मे गेथो जत रे। ");
INSERT INTO bpx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","अळतेण ईसु ढुंड्‌या मे बह ज्‌यो अने दर्‌या नी ह़ेली धेड़े तीना ह़ेर मे आयो। ");
INSERT INTO bpx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","तीहयी वखत थोड़ाक माणहु, लखवा मे पड़ला एक माणेह ने खाटला मे ह़ुवाड़ीन ईसुन्‌तां लाया। तीमनो भरहो देखीन ईसु तीहया लखवा मे पड़ला ने हुकम आपीन केदो, सोरा, हीमम्‌त राख! तारा पाप नी लेदे तने माफी जड़ जी। ");
INSERT INTO bpx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","थोड़ाक युहदी-धरम ह़ीकाड़न्‌या मन मे वीच्‌यार्‌या, हीय्‌यो ते भगवान नो वाक काडे। ");
INSERT INTO bpx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","तीमना मन ना वीच्‌यार जाणीन ईसु तीमने केदो, तमु तमारा मन मे एवा बुरा वीच्‌यार काहा कर र्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","जादा वारु ह़ु से? “तारा पाप नी लेदे तने माफी जड़ जी केवा वारु से के, ‘उठीन तारु खाटलु उचलीन चाल केवा वारु से?’” ");
INSERT INTO bpx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पण मे आहयु आसम करीन की र्‌यो के तमु आहयु जाण लेवो के मनख्‌या ना सोरा ने धरती पोर पाप नी लेदे माणहु ने माफी आपवा नो बी हक से। अळतेण ईसु लखवा मे पड़ला माणेह ने केदो, “उठ अने तारु खाटलु उचलीन तारा घोर जत रे।” ");
INSERT INTO bpx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","अने तीहयो उठीन तीना घोर जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","आहयु देखीन माणहु बीह ज्‌या, अने तीहया भगवान ना गुण गावीन बड़ाय करवा बाज ज्‌या, जे माणेह ने ईसम हक आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ईसु तां गेथो अगो ज्‌यो, अने तीहयो मत्‌ती नाम ना एक माणेह ने फाळो लेवा ना नाका पोर बह रेलो देख्‌यो, अने तीने केदो, मारी ह़ाते चाल। अने तीहयो उठीन तीनी ह़ाते चाल पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","एक दाड़ो ईसु आह़फा ना चेला ह़ाते मत्‌ती ना घोर मे खाणु, खावा बह्‌यो अने घणा ढेरका फाळो लेण्‌या अने बीजा पापी आवीन तीनी ह़ाते खाणु खावा बाज र्‌या हता। ");
INSERT INTO bpx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","अने आहयु देखीन फरीसी पंथवाळा ईसु ना चेला ने केदा, तमारो मास्‌तर फाळो लेण्‌या अने बीजा पापी भेळतो खाणु काहा खाय? ");
INSERT INTO bpx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ईसु आहयु ह़मळीन तीमने केदो, “आरगला ने दाक्‌तर नी जोवे, पण मांदला ने दाक्‌तर जोवे।” ");
INSERT INTO bpx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","एतरे जाय्‌न चोखली सास्‌तर मे लीखली आहयी वात ने ह़ीक लेवो के मने बादा नी जोवती, पण गीण जोय री ईनु मतलब ह़ु से, काहाके मे धरमी माणहु ने नी, पण पापी माणहु ने बोलाव्‌वा आवलो से। ");
INSERT INTO bpx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","अळतेण बपतीस्‌मा आपण्‌या युहन्‌ना ना चेला ईसुन्‌तां आया, अने आहयु केदा, आमु अने फरीसी पंथवाळा उपाह़ कर्‌या। पण तारा चेला उपाह़ काहा नी करता? ");
INSERT INTO bpx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ईसु तीमने केदो, जत्‌यार तक लाडो ह़ाते से, तत्‌यार तक वरात्‌या दुखी हयहे ह़ु? बाखीन तीहया दाड़ा बी आवह़े जत्‌यार लाडो तीमनीन्‌तां गेथो सेटो हय जाय, ता तीहया उपाह़ करहे। ");
INSERT INTO bpx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","नवलु थीगळु जुन्‌ला लुगड़ा पोर कोय नी लगाड़े; काहाके लुगड़ु धोवहे, ता तीहयो नवलु थीगळु उहटी जहे, अने जुन्‌ला लुगड़ा ने हापकीन जादा फाड़ देहे। ");
INSERT INTO bpx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अने नवला अंगुर नो रोह, जुन्‌ला चामड़ा ना कवड़्‌या मे कोय नी भरे, नीता अंगुर नो रोह चामड़ा ना कवड़्‌या ने फाड़ देहे। अने आसम करीन अंगुर नो रोह वय जहे अने चामड़ा नो कवड़्‌यो बी बगड़ी जहे। करीन नवला अंगुर नो रोह नवला चामड़ा ना कवड़्‌या मे भरे। अने तीहया बेम बचला रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ईसु तीमने आहयी वात केवात बाज रेलो हतो, के मुख्‌यो माणेह आयो अने तीहयो ढुंगो वळीन ईसु सी वीन्‌ती कर्‌यो, मारी सोरी हमणे मर जेली से। पण आवीन तीनी पोर हात मेक, अने तीहयी जीवती हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ईसु उठीन आह़फा ना चेला भेळतो तीनी पसळ चाल पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","अने देखो, एक बयर ने बारे साल नो पोगराळो दुख हतो, अने तीहयी पसळ गेथी आवीन ईसु ना लुगड़ा ना छेड़ा ने सीम लेदी। ");
INSERT INTO bpx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","काहाके तीहयी आह़फी ना मन मे केती हती, “कदीम मे ईसु ना लुगड़ा ने बी सीम लेही ता मे आरगी हय जही।” ");
INSERT INTO bpx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ईसु पासो फीरीन तीने देख्‌यो अने केदो, “बेटी हीम्‌मत राख; तारो भरहो तने वारु करलो से।” अळतेण तीहयी बयर तत्‌यारुत वारु हय जी। ");
INSERT INTO bpx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जत्‌यार ईसु तीहया मुख्‌या ना घोर मे पुग्‌यो अने फेपार्‌या वगाड़वा वाळा अने रड़वा बाज रेला देख्‌यो ता केदो। ");
INSERT INTO bpx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ईसु तीमने केदो, “सेटा हय जावो, सोरी मरी नी, पण ह़ुव्‌वा बाज री।” आसम केदो एतरोत अने तीहया ईसु नी हाही उडाड़वा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पण जत्‌यार माणहु नी गड़दी ने बारी नीकाळ देदा। ता ईसु घोर मे जाय्‌न सोरी नो हात धर्‌यो, अने तीहयी उठीन बह जी। ");
INSERT INTO bpx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","अने आहयी वात नी खबर तीहया आखा देस मे फेल जी। ");
INSERT INTO bpx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जत्‌यार ईसु तां गेथो अगो ज्‌यो, ता बे आंदळा ईसु पसळ आसम आड़ता जाय्‌न चाल पड़्‌या, “ए दावुद नी अवल्‌यात, अमारी पोर दया कर।” ");
INSERT INTO bpx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जत्‌यार तीहयो घोर मे पुग्‌यो, ता तीहया आंदळा ईसु ह़ाते आया, अने ईसु तीमने केदो, “के तमारो भरहो से के मे तमने वारु कर सकत्‌लो से?” तीहयो ईसु ने केदो, “होव, मालीक!” ");
INSERT INTO bpx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तत्‌यार ईसु तीमना डोळा सीमीन केदो, “तमारा भरहा नी लारे तमारी वाटु हय जाय।” ");
INSERT INTO bpx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अने तीमना डोळा उगड़ी ज्‌या अने ईसु तीमने चेतावीन केदो, “चेतीन रेवो। कोय आहयी वात ने नी जाणे।” ");
INSERT INTO bpx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पण तीहयो नीकळीन आखा देस मे तीहयी वात फेलाड़ देदो। ");
INSERT INTO bpx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जत्‌यार तीहयो बारो जवा बाज र्‌यो हतो, ता देखो, माणहु एक गुंगा ने भुत लागलो हतो, ईसुन्‌तां लाया; ");
INSERT INTO bpx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","अने जत्‌यार भुत ने नीकाळ देदलो, ता गुंगो बोलवा बाज ज्‌यो। अने माणहु नी गड़दी वहराय्‌न केवा बाज जी, “ईस्‌रायल देस मे एवु कदी नी देख्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पण फरीसी पंथवाळा केदा, “आहयो ते भुत ना डायला नी लारे भुत ने नीकाळत्‌लो से।” ");
INSERT INTO bpx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ईसु आखा ह़ेर मे अने गाम मे फीरतो र्‌यो अने युहद्‌या ना भक्‌ती ना घोरु मे माणहु ने ह़ीकाड़तो र्‌यो, अने भगवान ना राज नी खुस-खबर नो परच्‌यार करतो र्‌यो, अने आखी भातीन मंदवाड़ ने अने लुलखाय ने सेटी करतो र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जत्‌यार ईसु गड़दी ने देख्‌यो ता ईसु तीमनी पोर दया कर्‌यो, काहाके तीहया तीना गाडरान तेवा हता, तीमनो कोय गुवाळ्‌यो नी हतो, घबरायला हता अने भटकी जेला हता। ");
INSERT INTO bpx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तत्‌यार ईसु आह़फा चेला ने केदो, “मेर ते घणी से, पण मेर वाडवा वाळा दाड़क्‌या थोड़ाक से। ");
INSERT INTO bpx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","एतरे मेर ना मालीक सी वीन्‌ती करो के तीहयो आह़फा नी मेर वाडवा करीन दाड़क्‌या मोकल देय।” ");
INSERT INTO bpx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ईसु आह़फा ना बारे चेला ने बोलायो अने वीटळ्‌ळा आत्‌माम ने काडवा नो हक आप्‌यो, अने आखा भातीन मांदला ने आरगा करवा अने आखी लुलखाय सेटी करवा नो हक आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","बारे नेवताळा ना नाम आहया से: पेलो सीमोन, जे पतरस केवाये, अने पतरस नो भाय अंदर्‌यास; अने जब्‌दी नो सोरो याकुब अने याकुब नो भाय युहन्‌नो; ");
INSERT INTO bpx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","अने फीलीपुस, अने बरतुल्‌मे, अने थोमस, अने फाळो लेण्‌यो मत्‌ती; अने हलफाय नो सोरो याकुब, अने तद्‌दे; ");
INSERT INTO bpx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सीमोन कनानी, अने यहुदा ईस्‌करीयोती, जे ईसु ने धरायो। ");
INSERT INTO bpx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ईसु बारे जणा ने आहयो हुकम आपीन मोकल्‌यो, “आड़जात्‌या माणहु भणी नी जजो, अने सामरी माणहु ना ह़ेर मे नी जजो। ");
INSERT INTO bpx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","पण ईस्‌रायली जाती ना तीहया माणहु मे जावो, जे खोवायला गाडरान तेम हय जेला से। ");
INSERT INTO bpx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","अने वाट्‌ये चालता जाय्‌न ज्‌योरे आड़ीन ईसम परच्‌यार करो के ह़रग राज ह़ाते आय जेलु से। ");
INSERT INTO bpx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","मांदला ने आरगा करो, मरला ने जीवाड़ो, कुड़ावा ने आरगा करीन चोखा करो, भुत ने नीकाळ्‌ळो। तमने फोकट मे संयबरकत जड़ली से, एतरे आप देवो। ");
INSERT INTO bpx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","तमारी कोथळी मे ह़ोना ना, चांदी ना अने ताम्‌बा ना, पय्‌हा लग नी लीज्‌जो। ");
INSERT INTO bpx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","परच्‌यार करवा जाय ता, तमारी वाटु झोलो, बे डगला, खाहड़ा, अने डींगा नी लीज्‌जो; काहाके दाड़क्‌या ने खावा नु हक से।” ");
INSERT INTO bpx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","तमु काना बी ह़ेर नीता गाम मे जावो, ता तां पुगीन एक मदत करवा लायक माणेह नो पतो लगाड़ो, अने तां गेथा जता लग तीनीन्‌तां रेवो। ");
INSERT INTO bpx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","जीना बी घोर मे तमु जावो ता केजो, “आहया घोर ना माणहु ने सांती अने संयबरकत जड़े।” ");
INSERT INTO bpx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","कदीम तीना घोर ना माणहु सांती नी संयबरकत हात करे एवा हय ता सांती नी संयबरकत तीमनी पांह रेहे, पण तीमने सांती नी संयबरकत नी जोवती हय, ता सांती नी संयबरकत पासी आवती रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","कदीम कोय तमारो आव-भाव नी करे, अने तमारी वात नी ह़मळे, ता तीना घोर मे गेथा, नीता तीना ह़ेर मे गेथा नीकळे ता तमारा पोग नो कादो झटकी देजो। ");
INSERT INTO bpx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मे तमने ह़ाचलीन केम, “नीयाव ना दाड़े सदोम अने अमोरा देस ना माणहु गेथी बी तीहया देस ना माणहु ने जादा डंड जड़हे।” ");
INSERT INTO bpx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","देखो, मे तमने लेंड्‌या ह़रको माणहुन वच मे गाडरान तेम मोकलु। एतरे गड़हा ने तेम कदर्‌या अने पारवान तेम खरला बणो। ");
INSERT INTO bpx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“माणहु सी चेतीन रेवो। तीहया तमने ह़ड़का देवा करीन भगवान ना भक्‌ती ना घोर मे लीजहे, अने पंचु अगळ ली जाय्‌न ह़ड़का देहे। ");
INSERT INTO bpx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तमु मने मान र्‌या करीन तमने राज करन्‌या, अने राजा अगळ लीजहे, अने ईसम करीन तमु आड़जात्‌या अगळ मारा गवा बणहु। ");
INSERT INTO bpx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जत्‌यार तीहया तमने सीपायड़ा ना ह़ात मे ह़ोप देय, ता फीकर नी करजो के आमु ह़ु केहु। काहाके तमने ह़ु केवा जोवे तीहयु भगवान तीहयी टेमे की देहे। ");
INSERT INTO bpx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","काहाके बोलवा वाळा तमु नी हय, पण भगवान बाह नी आत्‌मा से, जे तमारा मन मे गेथी बोलहे।” ");
INSERT INTO bpx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","तीहया दाड़ा मे भाय आह़फा ना भाय ने मराय नाखहे अने बाह आह़फा ना सोरा-सोरी ने धराय देहे अने सोरा-सोरी आय्‌ह-बाहा ना वीरोद मे हय जहे अने तीमने मराय नाखहे। ");
INSERT INTO bpx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मारा नाम ना कारण आखा माणहु तमारी सी ह़ीगी करहे, पण जे मरते लग गम खाहे, तीमने छुटकारो जड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","कदीम तीहया तमने एक ह़ेर मे वेला पाड़े ता बीजा ह़ेर मे नाह जजो। काहाके मे तमने ह़ाचलीन केम, तमने ईस्‌रायली देस ना आखा ह़ेर मे फीरते-फीरते मनख्‌या नो सोरो आय लागहे। ");
INSERT INTO bpx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेलो, मास्‌तर गेथो मोटो नी हय अने चाकर्‌यो मालीक गेथो मोटो नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला ने मास्‌तर बराबर अने पावर्‌या ने मालीक बराबर हयवान घणु से; जत्‌यार तीहयो घोर ना मालीक ने बालजबुल केदो ता तीहया घोर वाळा ने काहा नी केय?” ");
INSERT INTO bpx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","एतरे माणहु सी ना बीहो। ईसम कंय बी ढकायलु नी हय, जे वीजाळा मे नी लवाये, अने ईसम कंय बी ह़तायलु नी हय, जे उजन्‌तु नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","मे तमने जे कंय अंदारला मे केम, तीने तमु वीजाळा मे ह़मळावो। अने जे कंय तमने होगोत केदलो से तीहयु तमु घोर ना पडाळ पोर चड़ीन ज्‌योरेत परच्‌यार करो। ");
INSERT INTO bpx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","तीमनी सी ना बीहो जे डील ने मार नाखहे पण जीव ने नी मार सके; बाखीन तीनी सी बीहो, जे डील अने जीव बेम ने नरक मे कर सके। ");
INSERT INTO bpx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","एक पय्‌हा मे बे घंचड़ी वेचाय, ते बी तमारा बाह नी मरजी वगर तीमनी माय्‌न एक बी धरती पोर पड़ीन नी मरे। ");
INSERT INTO bpx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","तमारा मुंडा ना एक-एक नीम्‌बाळा गणायला से। ");
INSERT INTO bpx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","एतरे ना बीहो। तमु ढेरेत घंचड़ा गेथा मोगा से। ");
INSERT INTO bpx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जे मने माणहु अगळ मान लेहे। तीने मे बी मारा ह़रग वाळा बाह अगळ मान लेही। ");
INSERT INTO bpx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","अने जे मने माणहु अगळ नीकारो करहे, तीने मे बी मारा ह़रग वाळा बाह अगळ नीकारो करही।” ");
INSERT INTO bpx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“आहयु ना ह़मजो के मे धरती पोर सांती लीन आवलो से। मे सांती लीन नी आयो बाखीन तलवार लीन आवलो से।” ");
INSERT INTO bpx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मे आनीन करीन आवलो से के बेटा ने बाह ना वीरोद मे करवा, अने ववेह ने ह़ाहु ना वीरोद मे करवा करीन आवलो से। ");
INSERT INTO bpx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","माणेह ना वेरी तीना घोर वाळा बण जहे। ");
INSERT INTO bpx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जे बेटो आह़फा ना बाह ने नीता आह़फा नी आय्‌ह ने मार गेथो जादा मोंग करे, तीहयो मारी लायक नी हय। अने जे बी बाह बेटा ने नीता बेटी ने मारी गेथो जादा मोंग करे तीहयो मार लायक नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","जे कोय आह़फा ना दुख नु कुरुस उचलीन मार पसळ नी चाले, तीहयो मार लायक नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जे आह़फा नो जीव बचाड़वा हींडे, तीहयो आह़फा ना जीव ने खोय देय; अने जे मारीन करते आह़फा नो जीव खोय नाखहे, तीहयो आह़फा ना जीव ने बचाड़ लेहे।” ");
INSERT INTO bpx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","जे तमारु आव-भाव करे, तीहयो मारो आव-भाव करे, अने जे मारो आव-भाव करे, तीहयो तने मोकलन्‌या नो आव-भाव करे। ");
INSERT INTO bpx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जे भगवान वगे गेथी वात केण्‌या माणहु नो आनीन करते आव-भाव करे के तीहयो भगवान वगे गेथी वात केण्‌यो माणेह से, ता तीने भगवान वगे गेथी वात केण्‌या ना ईलाम ने तेवुत ईलाम जड़े। अने जे धरमी नो आनी करते आव-भाव करे के तीहयो धरमी से, ता तीने भगवान वगे गेथी वात केण्‌या माणहु ना ईलाम ने तेवुत ईलाम जड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","अने जे कोय आहया नान्‌ला ह़ुदला चेला माय्‌न काना एक ने पीवा करीन टाडलु पाणी आसम करीन आपहे के तीहयो मारो चेलो से, ता मे तमने ह़ाचलीन केम के तीहयो आह़फा नु ईलाम हात करहेन करहे। ");
INSERT INTO bpx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जत्‌यार ईसु आह़फा ना बारे चेला ने आहयी ह़ीकापण आप चुक्‌यो अने गलील जीला ना ह़ेर-ह़ेर मे ह़ीकापण आपतो, अने परच्‌यार करतो जाय्‌न तां गेथो जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","जत्‌यार युहन्‌नो जेल मे रीन ईसु मसीन काम ना बारा मे खबर ह़मळीन अने आह़फा ना चेला ने तीने आहयु पुसवा मोकल्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“ह़ु आव्‌वा वाळो तुत से नीता आमु बीजा नी वाट जोवया?” ");
INSERT INTO bpx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ईसु तीने जपाप आप्‌यो, “जे कंय तमु ह़मळो अने देखो तीहयु आखु जाय्‌न युहन्‌ना ने की देजो, ");
INSERT INTO bpx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","के आंदळा देखे, अने लंगड़ा चाले, कुड़ावा आरगा हये, बेरा ह़मळे मरला जीवता हये, गरीब ने खुस-खबर ह़मळायो। ");
INSERT INTO bpx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","अने जुगाळो से तीहयो, जे मारी कारण सी ठोकर नी खाय?” ");
INSERT INTO bpx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जत्‌यार तीहया तां गेथा चाल पड़्‌या, ता ईसु युहन्‌ना ना बारा मे माणहु ने केवा बाज ज्‌यो, “तमु बड़ा मे ह़ु देखवा जेला हता? के वाहळु मे हीलत्‌ला वाहण्‌या ने? ");
INSERT INTO bpx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","अळी तमु ह़ु देखवा जेला हता? के नरम लुगड़ा पेरला माणेह ने? देखो, जे नरम लुगड़ा पेरे, तीहया राजा नी हवेली मे रेय। ");
INSERT INTO bpx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ता अळी काहा जेला हता? भगवान वगे गेथा केण्‌या माणेह ने देखवा करीन जेला ह़ु? होव, मे तमने केम के भगवान वगे गेथा केण्‌या गेथा बी मोट्‌ला माणेह ने देखवा जेला। ");
INSERT INTO bpx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","आहयो तीहयोत से, जीना बारा मे लीखलु से; के देख; मे मारा ह़रगदुत ने तार गेथो अगळ मोकलही। तीहयो तार अगळ तार जुगु रोहो तीयार करहे। ");
INSERT INTO bpx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मे तमने ह़ाचलीन केम के, जे आह्‌य सी पयदा हयलो से, तीमनी मे गेथो युहन्‌ना बपतीस्‌मा आपवा वाळा सी कोय मोटो नी हय, पण जे ह़रग राज मे नाना सी नानो से तीहयो बपतीस्‌मा आपण्‌या युहन्‌ना गेथो मोटो से। ");
INSERT INTO bpx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","युहन्‌ना बपतीस्‌मा आपण्‌यो आयो तां गेथात आज तक माणहु ह़रग राज मे ताखत भेळ भरायता रेता हता, अने ताखत वाळा तीने हापकी लेता हता। ");
INSERT INTO bpx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","भगवान वगे गेथी वात केण्‌यो माणेह अने मुसा नी लारे लीखली सास्‌तर, बपतीस्‌मा आपण्‌या युहन्‌ना ने आव्‌वा नी पेलेत भगवान वगे गेथी वात केता हता। ");
INSERT INTO bpx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","कदीम तमने जोवे ता मानो के एलीया जे आव्‌वा वाळो हतो तीहयो आहयो युहन्‌नो से।” ");
INSERT INTO bpx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जीना कान्‌टा हय, तीहयो ह़मळी लेय। ");
INSERT INTO bpx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","मे आहयी पीड़ी ना माणहु नी बराबरी मे कोय सी करु? तीहया हाट मे बहला तीहया सोराम नी तेवा से, जे एक-बीजा सी आड़ीन केता हता, ");
INSERT INTO bpx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","के आमु ते तमारी वाटु पीहो वगाड़्‌या, अने तमु नी नाच्‌या; आमु ते दुखी हया, अने तमु छाती नी पीट्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","काहाके बपतीस्‌मा आपण्‌यो युहन्‌नो नी ते रोट्‌ला खातो हतो अने नी पीतो हतो, अने तीहया केता हता के तीनी मे भुत से। ");
INSERT INTO bpx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","माणहु नो सोरो खातो-पीतो आयो, अने तीहयो केतो हतो के देखो, “खादड़्‌यो अने दारकुट्‌टो माणेह, फाळो लेण्‌या अने पापी नो दोस्‌तीदार से। पण जे माणहु ने भगवान नी अक्‌कल ह़ीकाड़े तीहया खरला से।” ");
INSERT INTO bpx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ता ईसु तीहया ह़ेर ना माणहु ने खीजवाय्‌न वडवा बाज ज्‌यो, तां ह़ारीक ईसु ढेरेत जुदा-काम कर्‌यो पण तीहया आहया काम देखीन बी पाप भणी गेथा मन फीरवीन भगवान वगा नी वळ्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ए खराजीन ह़ेर! ए बेतसेदा! तमारी वाटु दुख नी वात से; देख, जे सक्‌ती ना काम तमारी मे कर्‌यो, तीहया सुर अने सेदा मे करतो, ता तीहया ठेला ओडीन अने रोखड़ा मे बहीन पापु भणी गेथा मन फीरवीन भगवान वगा वळ जता। ");
INSERT INTO bpx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","एतरे मे तमने केम नीयाव ना दाड़े तमारी हालत सुर ह़ेर अने सेदा ह़ेर नी हालत सी बी जादा वेठवा जुगु हयहे। ");
INSERT INTO bpx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“अने ए कफरनहुम! ह़ु तु ह़रगे लग उचु हयही? नी! तु ते पताळ मे लग हेटो जही; जे सक्‌ती ना काम तारी मे करला से, कदीम तीहया सदोम मे करतो, ता तीहया आज लग बणीन रेता। ");
INSERT INTO bpx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","एतरे मे तमने केम, नीयाव ना दाड़े तमने सदोम गेथो जादा डंड जड़हे।” ");
INSERT INTO bpx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","तीहयी टेमे ईसु केदो, “बाह! ह़रग अने धरती ना मालीक! मे तारा गुण गावु; काहाके तु आहयी आखी वात ने अक्‌कल वाळा अने भणला माणहु गेथी ह़ताड़ीन भोळा सोरा ह़रका माणहु अगळ उजन्‌ती कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","होव बाह! तु आनी करते आसम कर्‌यो काहाके तने आहयुत वारु लाग्‌यु।” ");
INSERT INTO bpx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मारो बाह, मने आखु कंय आप देदलो से। बाह ने सोड़ीन कोय बी बेटा ने नी जाणतु। आहयीत रीते बेटा ने सोड़ीन बाह ने कोय नी जाणतु। अने तीहयो एतरोत बाह ने जाणे, जीमनी पोर बेटो बाह ने उजन्‌तो करे।” ");
INSERT INTO bpx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ए आखा काम करीन थाकला अने भार मे डबायला माणहु मारीन्‌तां आवो, मे तमने अराम आपही। ");
INSERT INTO bpx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मारो वळो आह़फा पोर मेक लेवो अने मार सी ह़ीको, काहाके मे नीचळो अने मन मे गरीब से। अने तमु तमारा मन मे अराम हात करहु, ");
INSERT INTO bpx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","काहाके मारो वळो वारु से, अने मारो भार फवरलो से।” ");
INSERT INTO bpx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ईसु काना अराम ना दाड़े गम ना खेतर माय्‌न जवा बाज रेलो। ता तीमना चेलाम ने भुक लागी, अने तीहया उंब्‌या तोड़ी-तोड़ीन खावा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","आहयु देखीन फरीसी पंथवाळा ईसु ने केदा, “देख, जे काम अराम ना दाड़े करवा वारु नी हय, तीहयुत काम तारा चेला कर र्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ईसु तीहया फरीसी माणहु ने केदो, “खरला सास्‌तर मे तमु नी भण्‌या ह़ु? के जत्‌यार दावुद राजा अने तीना ह़ाती ने भुक लागी ता तीहया ह़ु कर्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","तीहया भगवान ना तम्‌बु मे जाय्‌न भेट चड़ावला रोट्‌ला खादा, अने नीस्‌ता भगवान ना पुंजारा ने सोड़ीन तीने अने तीना ह़ाती ने रोट्‌ला खावा ताले नी हतु।” ");
INSERT INTO bpx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","नीता, मुसा नी लारे लीखली सास्‌तर मे तमु नी भण्‌या ह़ु? के भगवान ना मंदीर ना पुंजारा अराम ना दाड़ा नो नेम तोड़ीन बी तीहया वण-गुनाळ्‌ळा ठेर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“मे तमने केम, जे आञे ह़ारीक से तीहयो मंदीर गेथो बी मोटो से। ");
INSERT INTO bpx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","कदीम तमु सास्‌तर मे लीखली आहयी वात ह़मजी जता के ‘मे माणहु मे गीण देखवा हींडु, जानवरु ने मारीन बादा नी जोवती’ ता वण-गुनाळ्‌ळा ने गुनाळ्‌ळा नी ठेरावता। ");
INSERT INTO bpx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","काहाके मनख्‌या नो सोरो अराम ना दाड़ा नो मालीक से।” ");
INSERT INTO bpx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","अने अळतेण ईसु तां गेथो अगो ज्‌यो, अने भगवान ना भक्‌ती ना घोर मे ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","तां एक माणेह हतो, तीनो हात ह़ुक जेलो हतो। ईसु पोर गुनो लगाड़वा करीन फरीसी माणहु तीने पुछ्‌या, “अराम ना दाड़े कोयने वारु करवा तालेत से ह़ु?” ");
INSERT INTO bpx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ईसु तीमने केदो, “कदीम तमारु एकीत गाडरु हय, अने तीहयु खाडा मे पड़ जाय, ता तमारी माय्‌न एवु कोय से, जे अराम ना दाड़े तीने धरीन नी नीकाळे? ");
INSERT INTO bpx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","माणेह ते गाडरा गेथो घणो मोगो से। एतरे अराम ना दाड़े भलाय करवा तालेत से।” ");
INSERT INTO bpx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ता तीहयो ते माणेह ने केदो, “तारो हात नाम्‌बो कर।” अने तीहयो आह़फा नो हात नाम्‌बो कर्‌यो, अने तीहयो हात वारु हय ज्‌यो। अने बीजा वारला हात ने तेवो हय ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","एतरे फरीसी पंथवाळा बारथा नीकळीन ईसु ना वीरोद मे आहयो वीच्‌यार कर्‌या आमु आने कीसम करीन मारया? ");
INSERT INTO bpx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ईसु आहयु जाण ज्‌यो अने तां गेथो चाल पड़्‌यो। अने घण ढेरका माणहु ईसु पसळ चाल पड़्‌या। तीहयो आखा ने आरगो करतो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","बाखीन तीहयो तीमने आहयु कीन चेतावतो हतो के “तमु मारु नाम लीन बीजा माणहु अगळ उजन्‌तो नी करजो।” ");
INSERT INTO bpx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","आहयु एतरे हयु के भगवान वगे गेथी वात केण्‌या माणहु यसाया नी लारे जे मालीक केदलो हतो, तीहयु पुरु हये: ");
INSERT INTO bpx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","आहयो मारो चाकर्‌यो से, आने मे टाळलो से; आहयो मारो घणो मोंगाळ्‌ळो से, मे आनी पोर घणो खुस से। मे आनी मे मारी आत्‌मा भर देही। अने आहयो आखा देस ना माणहु ने ह़ाचलीन नीयाव नी खुस-खबर करहे। ");
INSERT INTO bpx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","तीहयो नी झगड़ो करे, अने नी धुम मचाड़हे; अने नी हाट मे कोय बी आनो बोल नी ह़मळे। ");
INSERT INTO bpx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","आहयो कचराय्‌ली वाहण ने नी तोड़े। अने ओलायत्‌ला दीवा ना बाम्‌ळा ने अगोत नी ओलवे। जत्‌यार लग आहयो ह़ाचलीन नीयाव करीन जीक नी अपाड़े, तां लग पासो नी सोड़े। ");
INSERT INTO bpx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","तत्‌यार आखा देस ना माणहु आना नाम नी आह करहे। ");
INSERT INTO bpx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","अळतेण माणहु एक आंदळा माणेह ने ईसुन्‌तां लाया, तीहयु गुंगु बी हतु। अने भुत लागलु हतु। ईसु तीने आरगो कर्‌यो। अने तीहयो बोलवा अने देखवा बाज ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","आखा माणहु वहराय्‌न ईसु ना बारा मे केवा बाज ज्‌या, “आहयो दावुद नी अवल्‌यात हयवा जोवे ह़ु?” ");
INSERT INTO bpx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पण आहयी वात ह़मळीन फरीसी पंथवाळा केदा, “आहयो ते भुत ना मुखी बालजबुल नी मदत सी भुत ने नीकाळे।” ");
INSERT INTO bpx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ईसु तीमना वीच्‌यार जाणीन तीमने केदो, “जे राज मे बेरजाव पड़ जाय तीहयु कदी नी टेके। एमेत तीहयु घोर नीता ह़ेर बी नी टेके, जीनी मे बेरजाव पड़ जाय। ");
INSERT INTO bpx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","कदीम भुतड़ोत आह़फा ना वीरोद मे हय जाय ता तीनु राज कीकम टेकलु रेहे? ");
INSERT INTO bpx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अने कदीम मे भुतड़ा नी मदत सी भुत ने काडु ता तमारा सोरा कोयनी मदत सी भुत काडे? एतरे तीहया तमारो नीयाव करहे। ");
INSERT INTO bpx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पण कदीम मे भगवान नी जीव आत्‌मा नी ज्‌योरे भुतड़ा ना जोमु ने काडु, ता जाण लेवो के भगवान नु राज तमारी वच मे आय जेलु से।” ");
INSERT INTO bpx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","कोय बी माणेह काना बी जोर वाळा माणेह ना घोर मे भराय्‌न ह़मान नी लुट सके जत्‌यार तक तीहया ते जोर वाळा माणेह ने बांद नी लेय। अने जत्‌यार तीहयो ते जोर वाळा ने बांद लेय, तत्‌यार तीहयो तीना घोर मे भराय्‌न ह़मान लुट सके। ");
INSERT INTO bpx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जे मारी ह़ाते नी हय, तीहयो मारा वीरोद मे से, अने जे मारी ह़ाते भगवान गेथा सेटा हयला माणहु ने भेळा नी करे, तीहयो तीमने रीवण्‌या-तीवण्‌या कर र्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","एतरे मे तमने केम, माणहु ने आखी भाती ना पाप नी लेदे माफी जड़ जहे; आंया लग के भगवान नो जबराण वाक काडे तीने बी माफी जड़ जहे, पण भगवान नी चोखली आत्‌मा नो वाक काडे ता तीने माफी नी जड़े। ");
INSERT INTO bpx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जे कोय मनख्‌या ना सोरा ना वीरोद मे कंय केहे, तीने माफी जड़ जहे। पण चोखली आत्‌मा ना वीरोद मे कंय केहे, तीने माफी नी जड़े। आहयी कळी मे बी माफी नी जड़े, अने आव्‌वा वाळी कळी मे बी माफी नी जड़े। ");
INSERT INTO bpx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","कदीम एक झाड़ वारु हय, ता तीना फोळ बी वारु रेहे, अने कदीम एक झाड़ खोड़लु रेय, ता तीनु फोळ बी खोड़लुत रेहे, काहाके एक झाड़ नी ओळखाण तीना फोळ सी हये। ");
INSERT INTO bpx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ए गड़हा ना सोरा! तमु बुरा हय्‌न बी वारली वात कीसम की सके? जे तमारा मन मे भरलु से, तीहयुत तमारा मोडा मे गेथु आवे। ");
INSERT INTO bpx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","वारलु माणेह आह़फा ना वारला मन ना खजाना मे गेथी वारली वात नीकाळे; अने खोड़लो माणेह आह़फा ना खोड़ला मन ना खजाना मे गेथी खोड़ली वात नीकाळे। ");
INSERT INTO bpx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","एतरे मे तमने केम, “नीयाव ना दाड़े माणहु ने आह़फाम नी एक-एक रीकामी वात नो लेखो आपु पड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","काहाके तमु आह़फाम नी वात नी लारेत वण-गुनाळ्‌ळा अने गुनाळ्‌ळा ठेरहु।” ");
INSERT INTO bpx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","तीहयी टेमे थोड़ाक चोखली सास्‌तर ह़ीकाड़न्‌या, अने फरीसी पंथवाळा ईसु ने केदा, “मास्‌तर! आमु तारी लारे एक उजन्‌ती सेलाणी देखवा हय र्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","पण ईसु तीमने केदो, “आहयी पीड़ी ना कुहर्‌या अने छीनाळ्‌या माणहुत एक सेलाणी देखवा हींडे, पण भगवान वगे गेथी वात केण्‌या माणेह योना नी सेलाणी ने सोड़ीन कानी बी सेलाणी आमने नी देखाव पड़े।” ");
INSERT INTO bpx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जीसम योना तीन दाड़ा मे अने तीन रात मे राकस माछला ना पेट मे रेलो, तेमेत मनख्‌या नो सोरो धरती मे रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीयाव ना दाड़े नीनवे ह़ेर ना माणहु आहयी पीड़ी ना माणहु ह़ाते जीवता हयहे, अने आमने गुनाळ्‌ळा ठेरावहे। काहाके तीहया योना नी लारे भगवान नी केदली वात ह़मळीन, पापु भणी गेथु मन फीरवीन भगवान गवा वळला हता, अने देखो, आञे ते योना गेथो बी घणो मोटो से। ");
INSERT INTO bpx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","नीयाव ना दाड़े दखणाव देस नी राणी आहयी पीड़ी ना माणहु ह़ाते जीवती हय जहे, अने आहयी पड़ी ना माणहु ने गुनाळ्‌ळा ठेरावहे; काहाके तीहयी सुलेमान राजा नी अक्‌कल वाळी वात ह़मळवा करीन धरती नी काकड़ गेथी आवली, अने देखो, आञे ते सुलेमान राजा गेथो बी मोटो से! ");
INSERT INTO bpx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“जत्‌यार वीटळ्‌ळी आत्‌मा माणेह मे गेथी नीकळी जाय, ता तीहयी अराम करवा करीन, ह़ुकला जागा मे, जागो ह़ोदती रेय; पण तीने अराम नी जड़े। ");
INSERT INTO bpx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ता तीहयो केय ‘जा गेथो नीकळ्‌ळो से, तांत मारा तीहया घोर मे पासो जही।’ अने भुतड़ा नो वीटळ्‌ळो जोम पासो आवे, ता तीने तीहयु घोर ह़ुन्‌लु, झाटकीन बारलु अने चापड़ु करीन घटाळु करलु देखाव पड़े। ");
INSERT INTO bpx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ता तीहयी वीटळ्‌ळी आत्‌मा पासी जत रेय अने जाय्‌न तीनी ह़ाते बीजी ह़ात कुहर्‌याण वीटळ्‌ळी आत्‌मा ने बी ली आवे। अने तीहया माणेह मे भराय्‌न तांत रेवा बाज जाय। अने तीहया माणेह नी पेले गेथी बी जादा वेला हय जाय। आवीत वेला आहया पीड़ी ना माणहु नी बी हयहे, जे कुहर्‌या से।” ");
INSERT INTO bpx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ईसु घोर मे माणहु ने ह़ीकाड़वा बाज र्‌यो हतो, तीहयीत टेमे तीनी आय्‌ह़ अने भाय आया। तीहया बारा उबा हय रेला, अने ईसु ने भेटवा हींडता हता। ");
INSERT INTO bpx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","कानो आवीन ईसु ने केदो, “देख! तारी आय्‌ह़ अने भाय बारथा उबा हय र्‌या, तीहया तारी ह़ाते वात करवा हींडे।” ");
INSERT INTO bpx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ईसु तीमने केदो, “कोय से मारी आय्‌ह़? अने कोय से मारो भाय?” ");
INSERT INTO bpx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","अने आह़फा ना चेला भणी हात नो अनसारो करीन तीहयो केदो, “देखो! आहया से मारा भाय अने मारी आय्‌ह़! ");
INSERT INTO bpx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","काहाके जे कोय मारा ह़रग वाळा बाह नी मरजीन अनसारे जीवे, तीहयोन-तीहयो मारो भाय, अने मारी बेनेह, अने मारी आय्‌ह़ से।” ");
INSERT INTO bpx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","तीहयात दाड़े ईसु घोर मे गेथो नीकळीन दर्‌या धेड़े जीन बह ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","अने दर्‌या धेड़े ईसुन्‌तां घणा ढेरका माणहु आय लाग्‌या अने तीहयो ढुंड्‌या पोर चड़ीन बह ज्‌यो, अने आखा माणहु दर्‌या धेड़े उबा हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","तीहयो दाखला ना लारे तीमने वात ह़ीकाड़्‌यो। अने तीहयो एक दाखलो केदो, “ह़मळो! कानो कीरसाण बीज वाव्‌वा ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","वाव्‌ता-वाव्‌ता मे थोड़ाक बीज वाट धेड़े पड़्‌या, अने चड़ा आवीन तीने खाय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","थोड़ाक बीजड़ा चाफर्‌या वाळा जागा मे पड़्‌या तां उतळो कादो हतो; एतरे तीहया छोटा उगी आया; अने मुळ्‌या उन्‌डे नी ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","एतरे दाहड़ु उगीन तोप लाग्‌यो ता तीहयु धान चीमाय्‌न ह़ुक ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","थोड़ाक बीज काटा वाळा झाटवा मे पड़्‌या, अने उग्‌या पण कटाळ्‌ळा झाटवा तीहया रोपा ने डाब देदा। ");
INSERT INTO bpx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","थोड़ाक बीजड़ा वारली जागा मे पड़्‌या अने उगीन मोटा हय्‌न काना ह़ोव गुणा, अने काना साट गुणा, अने काना तीस गुणा फोळ लाया।” ");
INSERT INTO bpx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जीनी पांह ह़मळवा ना कान्‌टा हय तीहयो ह़मळ लेय। ");
INSERT INTO bpx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ईसुन ना चेला ह़ाते आवीन तीने केदा, “तु काहा माणहु ने दाखला मे ह़ीकापण आपे?” ");
INSERT INTO bpx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ईसु तीमने जपाप आप्‌यो, “मे आनीन करीन दाखला मे देखाड़ु काहाके ह़रग राज ना बारा मे जाणवा नी ह़मज तमने भगवान आपलो से, पण हीय्‌या माणहु ने नी आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","काहाके जीनी पांह थोड़ीक आप्‌ली अक्‌कल से, तीनेत अळी आपहे अने तीना पांह ढेरेत अक्‌कल हय जहे। पण जीनी पांह कंय बी नी हय, तीनी पांह गेथी तीहयी अक्‌कल बी मांग लेहे।” ");
INSERT INTO bpx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","मे तीमने दाखला मे ह़ीकाड़ु काहाके हीय्‌या देखता जीन बी नी देखे, अने ह़मळता जीन बी नी ह़मळे अने नी ह़मजे। ");
INSERT INTO bpx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","यसायो आहयी बी वात भगवान वगे गेथी केदलो हतो, तीहयी वात तीहया माणहु मे तेम ने तेम पुरी हय री: तमु ह़मळह़ु, अने ह़मळ्‌यात करहु, पण तमने थोड़ीक बी नी ह़मजाये; अने तमु देखहु, पण तमने पल्‌ले नी पड़े। ");
INSERT INTO bpx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","काहाके आहया आह़फाम नु मन काठु कर लेदला से। आहया मन बेरा हय जेला से। अने आहया आह़फाम ना डोळा मीच लेदला से। आहया ईनीन करते आसम कर्‌या काहाके ईमने कंय बी नी देखायवा जोवे, अने ईमने कंय बी नी ह़मळाव्‌वा जोवे, अने ईमना मन ने कंय बी पल्‌ले नी पड़वा जोवे, अने कदी मारी भणी नी वळवा जोवे, काहाके मे ईमनो छुटकारो कर देही। ");
INSERT INTO bpx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","पण जुगाळा से तमारा डोळा, काहाके हीय्‌या देखे, अने जुगाळा से तमारा कान्‌टा, काहाके हीय्‌या ह़मळे! ");
INSERT INTO bpx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","मे तमने ह़ाचलीन केम, के ढेरेत भगवान वगे गेथी वात केण्‌या माणहु अने नीयाव करन्‌या हेर कर्‌या के, जे वात तमु देखो, देख्‌या पण नी देखाय; अने जे वात तमु ह़मळो, ह़मळ्‌या, पण नी ह़मळ्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","हाव तमु कीरसाण ना दाखला नो मतलब ह़मजो: ");
INSERT INTO bpx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","बीज वाव्‌वा नी टेमे जे बीज वाट धेड़े पड़्‌या, तीहया आहयी सेलाणी देखाड़े के कदीम कोय भगवान ना राज ना बोल ह़मळे, बाखीन ह़मजे नी, ता तीना मन मे जे वेरायलु से, तीने कुहर्‌यो भुतड़ो आवीन लीत्‌ती रेय। ");
INSERT INTO bpx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","चाफर्‌या वाळी जागा मे वाळा बीज तीहया माणेह नी सेलाणी से: तीहयो भगवान नो बोल ह़मळतेत खुस हय्‌न मानीन आवरे; ");
INSERT INTO bpx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पण तीनी मे मुळ्‌या उंडा नी हयवा सी तीहयो थोड़ाक दाड़ा लग भरहो करे, पण भगवान ना बोल नी लेदे तीनी पोर दुख अने वेला आय पड़े, ता तीहयो तत्‌यारुत भरहो सोड़ देय। ");
INSERT INTO bpx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जे बीज झाटवा वाळी जागा मे पड़्‌यु तीहयु ते माणेह नी सेलाणी से, जे भगवान ना बोलु ह़मळे ते खरो, पण तीने कळी मे वाळी जीवाय्‌न नी फीकर अने धन नी लालच भगवान ना बोलु ने पाळीन चालवा नी देय, अने तीहयो जीवाय्‌न फोळ नी लावे। ");
INSERT INTO bpx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","वारली जागा मे पड़लु बीज तीहया माणेह नी सेलाणी से: जे भगवान ना बोलु ह़मळे, अने ह़मजे, अने फोळ लावे। कानो ह़ोव गुणा फोळ लावे, कानो साट गुणा फोळ लावे, अने कानो तीस गुणा फोळ लावे। ");
INSERT INTO bpx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ईसु तीमनी अगळ एक अळी दाखलो केदो, “ह़रग नु राज तीहया माणेह नु ह़रकु से, जे आह़फा ना खेतर मे वारलु बीज वेर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पण जत्‌यार माणहु ह़ुव्‌वा बाज रेला, ता तीनो वेरी आयो, अने गम मे जंगली बीज ने वेरीन जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जत्‌यार ह़ुका फुट्‌या अने उंब्‌या नीकळ्‌या ता जंगली बीज देखाव पड़्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","एतरे पावर्‌या मालीक ना घोर आवीन मालीक ने केदा, “मालीक तु तारा खेतर मे वारलु बीज नी वेर्‌यो ह़ु? ता तीनी मे जंगली बीज कीकम उग आया?” ");
INSERT INTO bpx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","मालीक तीमने केदो, “आहयु काना वेरी नु काम से।” ता पावर्‌या तीने पुछ्‌या, “तारी मरजी हय ता आमु जाय्‌न जंगली बीज ने उखड़ दीया?” ");
INSERT INTO bpx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","मालीक केदो, “नी ईसम ना करो नीता कंय माय्‌न जंगली बीज ना झाटवा ह़ाते, गम बी नी उखड़ी जाय। ");
INSERT INTO bpx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","वाडणी आवते लग भेळात वदवा देवो। वाडवा नी टेम पोर वाडवा वाळा ने केही, ‘पेले जंगली बीज ना झाटवा भेळा करो अने धपाड़वा करीन हीमना पुळा बांदो। अने अळतेण गम ना दाणा ने मारी मोहटी मे भेळा करो।’” ");
INSERT INTO bpx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ईसु तीमने एक अळी दाखलो ह़मळायो, “ह़रग नु राज राय ना दाणान तेवु से, जीने लीन कानो माणेह आह़फा ना खेतर मे वेर देदो। ");
INSERT INTO bpx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","तीहयु ते बीजा आखा बीज मे गेथु नानु रेय, पण उगीन वदीन वाड़ी ना भाजी-पाला ना झाटवा गेथु मोटु हय जाय, अने एवु झाटवु बण जाय के ह़रग ना चड़ा आवीन तीना डाळ्‌या पोर पोतरा बांदीन रेवा बाज जाय।” ");
INSERT INTO bpx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ईसु तीमने अळी एक दाखलो ह़मळायो, “ह़रग नु राज तीहया खमीर ह़रकु से, जीने लीन कानी बयर तीन कांगणी लोट मे भेसकी अने आखो लोट खमीर वाळो हय ज्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ईसु आखी वात दाखला नी लारेत माणहु ने ह़मजाड़तो हतो। अने दाखला वगर कंय बी नी केतलो। ");
INSERT INTO bpx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","भगवान वगे गेथी वात केण्‌या माणहु नी लारे जे केदलु तीहयु पुरु करवा नी करतेत ईसु दाखला नी लारे वात करतो हतो: जेम भगवान केदलो, मे दाखलो केवा करीन मारु मोडु उगाड़ह़ी; अने कळ घड़ायली तां गेथा पेल्‌ना वारा नी ह़तायली वात उजन्‌ती करही। ");
INSERT INTO bpx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ईसु माणहु ने वळाय दीन पासो घोर आयो। तीना चेला तीनीन्‌तां आवीन केदा, “खेतर मे वाळा जंगली बीज ना दाखला नु मतलब ह़ु हये तीहयु आमने ह़मजाड़ दे।” ");
INSERT INTO bpx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ईसु तीमने केदो, “वारलु बीज वेरन्‌यो कीरसाण, मनख्‌या नो सोरो से; ");
INSERT INTO bpx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","अने खेतर आहयी कळी से: वारलु बीज भगवान ना राज ना माणहु से; अने जंगली बीज कुहर्‌या भुतड़ा ना माणहु से; ");
INSERT INTO bpx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","अने वेरवा वाळो वेरी भुतड़ो से; वाडणी कळजुग नु खत्‌तम हयणु से; वाडण्‌या ह़रगदुत से। ");
INSERT INTO bpx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","जीसम माणहु जंगली बीज ना झाटवा ने भेळा करीन आक्‌ठु मे धपाड़ देय, तेमेत आहयी कळजुग खत्‌तम हयहे। ");
INSERT INTO bpx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मनख्‌या नो सोरो ह़रगदुत ने मोकलहे अने तीहया तीना राज मे गेथा आखा पाप करन्‌या ने अने गलत काम करन्‌या माणहु ने भेळा करहे, ");
INSERT INTO bpx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","अने तीमने आक्‌ठु नी दर्‌या मे धकली देहे; अने तीहया माणहु तीहयी आक्‌ठु नी भाटी मे ढोळो-ढोळो अने फुकु-फुकु रड़हे ");
INSERT INTO bpx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तीना वारा मे धरमी माणहु आह़फा ना बाह ना राज मे दाड़ान तेम भबळहे। जीना कान्‌टा हय तीहयो ह़मळी लेय।” ");
INSERT INTO bpx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ह़रग नु राज खेतर मे खोवायला धन ने तेवु से, जे काना माणेह ने जड़्‌यु अने तीहयु माणहे ह़ताड़ देदु अने तीहयु खुस हय जाय अने आखु कंय वेचीन तीहया खेतर ने वेचातु लेदो।” ");
INSERT INTO bpx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“अळी ह़रग नु राज एक वेपारीन तेवु से जे वारला मोती नो ह़ोदवाळ्‌या हतो। ");
INSERT INTO bpx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जत्‌यार तीने एक मोगलो मोती जड़्‌यो ता तीहयो जाय्‌न आह़फा नु आखु कंय वेच देदो अने तीने वेचातु ली लेदो।” ");
INSERT INTO bpx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“अळी ह़रग नु राज तीहयी मोट्‌ली जाळ ने तेवु से तीहया दर्‌या मे नाख देदा, अने आखी भाती ना माछला हापकी लायो। ");
INSERT INTO bpx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","अने जत्‌यार जाळ भराय जी, ता काहर्‌या तीनी जाळ ने धेड़े हापकी लाया, अने बहीन वारु-वारु तां ठाहरा मे भेळा कर्‌या अने बगड़ला-बगड़ला माछला ने नाख देय। ");
INSERT INTO bpx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","कळ खत्‌तम हयवान टेमे बी एमेत हयहे। ह़रगदुत आवीन पापी माणहु ने धरमी माणहु मे गेथा सेटा करहे, ");
INSERT INTO bpx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अने तीमने आक्‌ठा ना खाडा मे नाखे। ता तीहया माणहु रड़हे अने दातु ककड़ावता रेहे।” ");
INSERT INTO bpx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ह़ु तमु आहयी आखी वात ने ह़मज्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ईसु तीमने केदो, “एतरे जे बी चोखली सास्‌तर नो कायदो ह़ीकाड़न्‌यो ह़रग राज नो चेलो बण्‌लो से, तीहयो तीहया घोर मालीक ह़रको से, जे आह़फा ना घोर ना खजाना मे गेथो नवला अने जुन्‌ला चीज नीकाळे।” ");
INSERT INTO bpx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जत्‌यार ईसु आहया आखा दाखला की देदो, ता तां गेथो जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","अने ईसु आह़फा ना ह़ेर मे आवीन तीहया भगवान ना भक्‌ती ना घोर मे जाय्‌न माणहु ने ह़ीकाड़वा बाज ज्‌यो। के तीहया घबराय्‌न केवा बाज ज्‌या, “अने आहयी अक्‌कल अने घणा जुदा-काम कां गेथा जड़्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","आहयो ह़ुतार नो सोरो नी हय ह़ु? अने ह़ु आनी आय्‌ह़ नु नाम मरीयम अने तीना भाय नु नाम याकुब, अने युसुफ अने सीमोन अने यहुदा आना भाय नी हय? ");
INSERT INTO bpx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","अने ह़ु आखा बेनेह आपणी वच मे नी रेय? अळी आने आहयी आखी अक्‌कल अने जोर कां गेथो जड़्‌यो?” ");
INSERT INTO bpx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","आनीन करता तीहयो ठोकर खादो, पण ईसु तीने केदो, “भगवान वगे गेथी वात करन्‌यो माणेह नी ईज्‌जत तीना गाम ने अने घोरन्‌या ने सोड़ीन आखी जागे हये।” ");
INSERT INTO bpx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","अने ईसु तां भरहो नी कर्‌या करीन जादा काम नी कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","तीहयी टेमे चोवथा देस नो राजा हेरोद ईसु ना बारा मे ह़मळ्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","अने आह़फा ना पावर्‌या ने केदो, आहयो ते बपतीस्‌मा आपण्‌यो युहन्‌ना से। हीय्‌यो मरला मे गेथो जीवतो हय जेलो से, एतरे तीनी सी सक्‌ती ना काम तीनी लारे हयत्‌ला से। ");
INSERT INTO bpx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","हेरोद राजा आह़फा नो भाय फीलीपुस नी लाडी हेरोदीयास ना कारण, बपतीस्‌मा आपण्‌या युहन्‌ना ने धरीन बांद्‌यो, अने जेल मे बंद कर देदलो हतो; ");
INSERT INTO bpx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","काहाके बपतीस्‌मा आपण्‌यो युहन्‌ना तीने केदलो हतो, के हीने राखवा तारी जुगु ताले नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","हेरोद राजा बपतीस्‌मा आपण्‌या युहन्‌ना ने मार नाखवा हींडतो हतो; ते बी माणहु ने देखीन बीहतो हतो, काहाके तीहया तीने भगवान वगे गेथो केवा वाळो माणेह मान्‌ता हता। ");
INSERT INTO bpx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पण जत्‌यार हेरोद नो पयदावारीन दाड़ो आयो, ता हेरोदीयास नी बेटी पोरणा अगळ नाचणु देखाड़ीन हेरोद ने खुस करी। ");
INSERT INTO bpx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","एतरे तीहयो ह़ाम खाय्‌न वायदो कर्‌यो, जे कंय तु मांगहे, मे तने तीहयु आप देही। ");
INSERT INTO bpx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","तीनी आय्‌ह तीने पेले गेथी केदली हती। एतरे तीहयी केदी, मने हमणे थाळी मे बपतीस्‌मा आपण्‌या युहन्‌ना नु मुंडु मंगाड़ दे। ");
INSERT INTO bpx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","हेरोद राजा ने दुख लाग्‌यो, पण आह़फा नी ह़ाम अने ह़ाते बहला माणहु ना कारण सी, हुकम आपीन केदो, हीने बपतीस्‌मा आपण्‌या युहन्‌ना नु मुंडु आप देवो। ");
INSERT INTO bpx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","अने सीपायड़ा ने मोकलीन तीहया जेल मे गेथु बपतीस्‌मा आपण्‌या युहन्‌ना नु मुंडु तोड़ाय देदो। ");
INSERT INTO bpx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","अने तीहया तीनु मुंडु थाळी मे ली आया, अने सोरी ने आप देदा, अने तीहयी ते मुंडु ने आह़फी नी आय्‌ह ने आप देदी। ");
INSERT INTO bpx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","अने युहन्‌ना ना चेला आवीन तीनु धोड़ ने ली जाय्‌न तीने गाड़ देदा, अने जाय्‌न ईसु ने खबर कर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ईसु युहन्‌ना नी मोत नी खबर ह़मळीन ढुंड्‌या मे बहीन तां गेथो एक ह़ुनह़ान जागा भणी जत र्‌यो। अने माणहु आहयु ह़मळीन ह़ेर-ह़ेर गेथा चालीन तीनी पसळ हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","अने ईसु ढुंड्‌या मे गेथो उतर्‌यो, ता एक घणो मोटो माणहु नो मेळो देख्‌यो; अने तीने तीहया माणहु पोर दया आय जी, अने तीहयो जे मांदला हता तीमने आरगा कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जत्‌यार ह़ांती टेमे ईसु ना चेला तीनीन्‌तां आवीन केदा, आहयो जागो ह़ुनकार से, अने दाहड़ु ढळ जेलु से। माणहु ने वळाय दे, अने आहया गाम मे जाय्‌न आह़फा वाटु खाणु वेचातु ली लेय। ");
INSERT INTO bpx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ईसु चेला ने केदो, हीमने जवा जरुड़ी नी हय, तमु हीमने खावा नु आपो। ");
INSERT INTO bpx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","पण चेला केदा, अमारी पांह पांच रोट्‌ला अने बे माछला सोड़ीन बीजु कंय बी नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ईसु केदो, हीय्‌या रोट्‌ला अने माछला मारीन्‌तां लावो। ");
INSERT INTO bpx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ईसु माणहु ने चारा पोर बहवा करीन केदो, तीहया पांच रोट्‌ला अने बे माछला हात मे धरीन ह़रग भणी भाळीन तु घणो वारु से केदो। अने रोट्‌ला भांगीन चेला ने आप्‌यो, अने चेला माणहु ने आप्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","आखा माणहु खाय्‌न आफरी ज्‌या, अने बचला रोट्‌ला ना टुकड़ा सी बारे चारली भराय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","अने खाणु खावा वाळा मे, बयरा अने सोरा ने सोड़ीन पांच हजार अदमड़ा हता। ");
INSERT INTO bpx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","अने ईसु तत्‌यारुत आह़फा ना चेला ने केदो, के तमु ढुंड्‌या मे बहीन दर्‌या नी ह़ेली धेड़े जत रेवो; तांह तक मे माणहु ने वळाय देम। ");
INSERT INTO bpx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ईसु माणहु ने वळाय दीन एखलो बहीन वीन्‌ती करवा करीन बड़ा पोर जत र्‌यो। अने ह़ांतो, तां तीहयो एखलो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तीहयी टेमे लग ढुंड्‌यु ढेरे नाम्‌बे जत रेलु हतु अने दर्‌या नी वच मे झलक सी डुलकी र्‌यु हतु, काहाके वाहळु अगळ नु हतु। ");
INSERT INTO bpx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","राते तीन बजे गेथो छोव बजे ईसु दर्‌या ना पाणी पोर चालतो जाय्‌न चेला भणी आयो। ");
INSERT INTO bpx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","जत्‌यार चेला ईसु ने दर्‌या पोर चालत्‌लो देख्‌या, ता, तीहया घबराय ज्‌या, अने केदा, आहयो ते कानो भुत से, अने तीहया बीहीन आड़ पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ईसु तत्‌यारुत तीमने केदो, हीम्‌मत राखो! मेत से, बीहो ना। ");
INSERT INTO bpx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस केदो, “ए मालीक! कदीम तुत से, ता मने पाणी पोर चालीन तारीन्‌तां आव्‌वा नो हुकम आप।” ");
INSERT INTO bpx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ईसु केदो, आव। अने पतरस ढुंड्‌या मे गेथो उतरीन पाणी पोर चालतो जाय्‌न ईसु भणी जवा बाज ज्‌यो; ");
INSERT INTO bpx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पण तीहयो ज्‌योरे आवत्‌लु वाहळु देखीन बीह ज्‌यो, अने तत्‌यारुत पाणी मे डुबवा बाज ज्‌यो, अने आड़वा बाज ज्‌यो, “ए मालीक! मने बचाड़।” ");
INSERT INTO bpx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ईसु तत्‌यारुत तीने हात अगो करीन धर लेदो, अने केदो, ए कम भरह्‌या! तु सण्‌का काहा कर्‌यो? ");
INSERT INTO bpx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जत्‌यार तीहया ढुंड्‌या मे चड़ ज्‌या ता वाहळु थांग ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","आहयु देखीन ढुंड्‌या मे वाळा माणहु ईसु नी भक्‌ती करीन केदा, तु ह़ाचलीन भगवान नो बेटो से। ");
INSERT INTO bpx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","अळतेण तीहया दर्‌या पार ह़ेली धेड़े गन्‌नेसरत ह़ेर मे पुग्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","तां वाळा माणहु ईसु ने ओळखी लेदा, अने आड़े-धेड़े ना आखा गाम मे आनी खबर फेलाय देदा। तीहया आखा मांदला ने ईसुन्‌तां ली आया। ");
INSERT INTO bpx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अने तीनी पांह वीन्‌ती कर्‌या के तु आमने तारा लुगड़ा नो सेड़ो एतरोत छीमवा दे। अने जेतरा तीने छीम्‌या, तीहया आखान-आखा आरगा हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","यरुसलेम ना थोड़ाक फरीसी पंथवाळा अने कायदा ह़ीकाड़न्‌या ईसुन्‌तां आवीन केदा, ");
INSERT INTO bpx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","तारा चेला डायला पुडार्‌या नी रीती-भाती काहा नी पाळता? हीय्‌या हाथ धोया वगर रोट्‌ला काहा खाय? ");
INSERT INTO bpx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ईसु तीमने केदो, तमु आह़फाम नीत रीती-भाती पाळवा करीन भगवान नो हुकम काहा तोड़ो? ");
INSERT INTO bpx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","भगवान केदलो हतो, “तमु आह़फा ना आय्‌ह़-बाहा नी ईज्‌जत करजो अने जे कोय आह़फा ना बाह ने नीता आय्‌ह़ ने गलत बोल केय, ता तीने मार नाखो।” ");
INSERT INTO bpx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पण तमु केय, कदीम कोय आह़फा ना आय्‌ह़-बाहा ने केय जेतरो बी तारो फायदो मारी सी हयतो हतो, तीहया आखु भगवान ने भेट अपाय जेलु से। ");
INSERT INTO bpx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ईनु मतलब आहयु नी हय, के आय्‌ह़-बाहा नी ईज्‌जत नी करवा जोवे। एमेत तमु तमारा डाह-डाहा नी रीती-भाती नी करते, जे तमु बणावला से; भगवान ना बोलु ने टाळ देवो। ");
INSERT INTO bpx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ए ढोंगड़ा करन्‌या! यसायो तमारा बारा मे भगवान वगे गेथी आहयी वात वारलोत केदलो से, ");
INSERT INTO bpx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","आहया माणहु मोडे-मोडे मारी ईज्‌जत करे, पण आमनु मन मारी गेथु घणु सेटु से। ");
INSERT INTO bpx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","आहया अमथात मारी भक्‌ती करे; काहाके तीमनी ह़ीकापण नीस्‌ती माणहु ना ह़ीकाड़ला नेम से। ");
INSERT INTO bpx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","अने अळतेण ईसु माणहु ने आह़फान तां बोलावीन केदो, ह़मळो अने ह़मजो। ");
INSERT INTO bpx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जे मोडा मे जाय, तीहयु माणहु ने नी वीटाळे, पण जे गलत बोलु माणहु मे गेथा नीकळे, तीहयात बोलु तीमने वीटाळ देय। ");
INSERT INTO bpx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","अळतेण चेला आवीन ईसु ने केदा, तारी आहयी वात ह़मळीन फरीसी माणहु ने वारु नी लाग्‌यु, आहयी वात तने मालम से ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ईसु चेला ने केदो, जे रोपो मारो ह़रग वाळो बाह नी चोप्‌यो, तीने उखड़ीन नाख देहे। ");
INSERT INTO bpx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","हीमने रेवा देवो; हीय्‌या आंदळानेत वाट देखाड़े। कदीम एक आंदळो, बीजा आंदळा ने वाट देखाड़े ता बेम जणा खाडा मे पड़ जहे। ");
INSERT INTO bpx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","आहयी वात ह़मळीन पतरस केदो, आमने दाखला ने ह़मजाड़ दे। ");
INSERT INTO bpx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ईसु केदो, तमने हजु बी नी ह़मजायतु ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","तमने आहयु नी मालम हय ह़ु? के, जे खाणु मोडा मे हय्‌न भराय, तीहयु पेट मे जत रेय, अने डील मे गेथु बारथु नीकळी जाय? ");
INSERT INTO bpx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पण जे मोडा मे गेथु नीकळे, तीहयु मन मे गेथु नीकळे, अने आहयुत माणहु ने वीटाळ देय। ");
INSERT INTO bpx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","काहाके गलत वीच्‌यार, हत्‌या, बीजी बयर ने राखवा, छीनाळु, चोरी, झुटी गवाय देवा, वाक काडवा ना आहया आखा वीच्‌यारु माणहु ना मन मे गेथात नीकळे। ");
INSERT INTO bpx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","आहयात माणहु ने वीटाळ देय। पण हाथ धोया वगर खाणु खावा सी माणेह नी वीटळे। ");
INSERT INTO bpx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ईसु तां गेथो नीकळीन सुर अने सेदा परगणा भणी चाल पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","तीहया परगणा नी कनानी जाती नी एक बयर आयी अने आड़ी-आड़ीन केवा बाज जी, “ए मालीक! दावुद नी अवल्‌यात! मारी पोर गीण कर। मारी सोरी ने भुत घण-जबर वेला पाड़ र्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पण ईसु तीने कंय नी केदो। अने ईसु ना चेला ईसुन्‌तां आवीन वीन्‌ती कर्‌या, हीनी वात मानीन हीने वळाय दे, काहाके हीय्‌यी आड़ती-आड़ती अमारी पसळ आय री। ");
INSERT INTO bpx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","पण ईसु केदो, भगवान मने ईस्‌रायली जाती ना माणहुन तां एतरोत मोकलो से, जे खोवायला गाडरान तेम से, अने भगवान गेथा सेटा हय जेला से। ");
INSERT INTO bpx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पण तीहयी बयर आवीन ईसु ना पोगे पड़ीन तीने केदी, “ए मालीक! मारी मदत कर।” ");
INSERT INTO bpx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","पण ईसु दाखलो कीन तीने जपाप आप्‌यो, सोरा पांह गेथो रोट्‌लो हापकीन कुतरा अगळ नाखवा वारु नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","तीहयी केदी, होव, मालीक! पण ते बी मालीक नी थाळी मे गेथु टेबल पोर गेथु हेटु पड़लु खाणु ते कुतरा खाय लेय। ");
INSERT INTO bpx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","तीनी वात ह़मळीन ईसु केदो, “ओ बयर! तारो भरहो घणो मोटो से, तारी मरजी पुरी हये।” अने तेतरी घड़ी तीनी बेटी वारु हय जी। ");
INSERT INTO bpx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ईसु तां गेथो जत र्‌यो, अने गलील जीला नी दर्‌या धेड़े पुगीन एक बड़ा पोर चड़ीन बह ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","अने मेळान-मेळा माणहु तीनीन्‌तां आव्‌वा बाज ज्‌या। तीहया लंगड़ा, लुल्‌ला, आंदळा, गुंगा, अने ढेरेत बीजी मंदवाड़ मे पड़ला माणहु ने ईसु ना पोगु अगळ ह़ाते लावीन मेक देदा, अने ईसु तीमने आरगा करतो र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","अने जत्‌यार माणहु देख्‌या, गुंगा बोले, पांगळा वारु हये, लंगड़ा चाले, अने आंदळा देखे, आहयु आखु देखीन माणहु चकराय ज्‌या, अने तीहया ईस्‌रायली जाती ना भगवान ना गुण गाव्‌वा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","तत्‌यार ईसु आह़फा ना चेला ने ह़ाते बोलावीन केदो, मने आहया माणहु पोर गीण आवे। आहया तीन दाड़ा ना मारी भेळता री र्‌या, अने ईमनी पांह खावा जुगु कंय बी नी हय। मे ईमने भुकला नी वळाव्‌वा हींडतो। कदी आहया थाक जहे अने वाट्‌येत थाकीन पड़ जहे। ");
INSERT INTO bpx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","चेला तीने केदा, आहयी उजाड़ी जागा मे आहया माणहु ने खवाड़वा करीन एतरा ढेरका रोट्‌ला कां गेथा लावया? ");
INSERT INTO bpx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ईसु तीमने पुछ्‌यो, “तमारी पांह केतरा रोट्‌ला से?” तीहया केदा, “ह़ात रोट्‌ला अने थोड़ाक झीन्‌ला माछला।” ");
INSERT INTO bpx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","अने माणहु ने भोयमे बहाड़ देवो, करीन ईसु चेला ने हुकम आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","अने तीहयो ह़ात रोट्‌ला, अने माछला हात मे लीन रोट्‌ला अने माछला जुगु भगवान ने तु घणो वारु से केदो, अने तीहयो माछला अने रोट्‌ला भांगी-भांगीन चेला ने आपतो ज्‌यो, अने चेला माणहु ने आप्‌ता ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","आखा खायलीन आफरी ज्‌या अने चेला बचला टुकड़ा सी ह़ात चार्‌या भरीन चुट्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","खाणु खावा वाळा मे बयरा-सोरा ने सोड़ीन च्‌यार हजार अदमड़ा हता। ");
INSERT INTO bpx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ईसु माणहु ने वळाय देदो, अने तीहयो ढुंड्‌या मे बहीन मगदन परगणा मे पुग्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरीसी पंथवाळा अने सदुकी पंथवाळा ईसुन्‌तां आया, अने तीने पारखवा करीन तीहया ह़रग मे गेथी कानी सेलाणी देखाड़। ");
INSERT INTO bpx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","पण ईसु केदो, “ह़ांती टेमे तमु केवो, सीजन वारु रेहे, काहाके ह़रग रातु से। ");
INSERT INTO bpx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","अने ह़वारे तमु केवो, ‘आज आंजी आवह़े काहाके ह़रग मे रात्‌लु वादळु सवायलु से, कदीम तमु ह़रग नी सेलाणी देखीन आहयु जाण लेवो के ह़ु हयवा वाळु से, ता तमु आहया दाड़ा मे हय रेली सेलाणी काहा नी ओळखो? ");
INSERT INTO bpx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","आहयी पीड़ी ना कुहर्‌या अने छीनाळ्‌या माणहु एक सेलाणी मांग र्‌या, पण आमने धरमी योना नी सेलाणी वगर कानी बी सेलाणी नी जड़े। आहयी वात कीदीन ईसु तीमने सोड़ीन जत र्‌यो।’” ");
INSERT INTO bpx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","दर्‌या नी ह़ेली धेड़े जवा नी टेमे चेला रोट्‌लो लेवा भुल जेला हता। ");
INSERT INTO bpx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","पण ईसु तीमने हुकम आपीन केदो, चेतीन रेवो! अने फरीसी माणहु अने सदुकी माणहु ना खमीर सी बचीन रेवो। ");
INSERT INTO bpx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ता तीहया-तीहयात केवा बाज ज्‌या, आपणु रोट्‌ला नी लाया, एतरे आहयो ईसम केय। ");
INSERT INTO bpx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ईसु तीमना वीच्‌यार जाणीन तीमने केदो, “ए कम भरह्‌या! तमु आहयु काहा वीच्‌यार कर र्‌या, के ‘आपणु रोट्‌ला नी लाया, एतरे आहयो आसम केय?’” ");
INSERT INTO bpx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","तमु हजु लग नी ह़मज्‌या ह़ु? मे तीहया पांच हजार माणहु ने पांच रोट्‌ला ढेरका करीन आफरीन खवाड़्‌यो तीहयु तमने मालम नी हय ह़ु? अने तीहयी टेमे तमु केतरा चार्‌या टुकड़ा चुटीन भरला? ");
INSERT INTO bpx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","मे तीहया च्‌यार हजार माणहु ने ह़ात रोट्‌ला वदाड़ीन, आफरीन खवाड़्‌यो, ता तमु तीहयी टेमे केतरा चार्‌या टुकड़ा चुटीन भरला? ");
INSERT INTO bpx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तमु काहा नी ह़मजता के मे तमने रोट्‌ला ना बारा मे आहयु नी केदो, पण मे ते फरीसी माणहु अने सदुकी माणहु ना खमीर गेथा चेतीन रेजो करीन केदलो? ");
INSERT INTO bpx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ता चेला ह़मजी ज्‌या के ईसु रोट्‌ला ना खमीर गेथा नी, बाखीन फरीसी माणहु ना अने सदुकी नी ह़ीकापण गेथा चेतीन रेवा करीन हुकम आपीन केदलो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ईसु केसर्‌या फीलीपुस ह़ेर मे आह़फा ना चेला ने पुछ्‌यो, माणहु मनख्‌या ना सोरा ने ह़ु केय? ");
INSERT INTO bpx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","तीहया केदा, “थोड़ाक माणहु केय, ‘बपतीस्‌मा आपण्‌यो युहन्‌नो से, थोड़ाक माणहु केय एलीया से, अने थोड़ाक माणहु केय, यीरम्‌या से नीता ता भगवान वगे गेथो केवा वाळा काना माणहु माय्‌न कानो एक से।’” ");
INSERT INTO bpx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","आहयु ह़मळीन ईसु केदो, पण तमारा वीच्‌यार सी मे कोय से? केवो? ");
INSERT INTO bpx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सीमोन पतरस केदो, तु मसी से, तु जीवतो रेण्‌या भगवान नो सोरो से। ");
INSERT INTO bpx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ता ईसु सीमोन ने केदो, ए सीमोन, योना ना सोरा! तु जुगाळो से, काहाके आहयी वात डील अने लोय मे रेण्‌यो कानो माणेह नी, बाखीन मारो ह़रग वाळो बाह तारी पोर उजन्‌ती करलो से। ");
INSERT INTO bpx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","एतरे मे बी तने केम, “तु पतरस से, अने मे आहया दगड़ा पोर मारी मंडळी बणावही अने पताळ नो झापला ने आनी अगळ टेकाये नी।” ");
INSERT INTO bpx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मे तने ह़रग राज ना कुच्‌या आपही। अने तु धरती पोर जे कंय बांदही, तीहयु ह़रग मे बी बंदाय जहे; अने जे कंय धरती पोर उगाड़हे तीहयु ह़रग मे बी उगड़ी जहे। ");
INSERT INTO bpx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तत्‌यार ईसु आह़फा ना चेला ने हुकम आप्‌यो के तमु कोयने बी नी केजो के हीय्‌यो मसी से। ");
INSERT INTO bpx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","तीहयी टेमे गेथो ईसु आह़फा ना चेला ने आहयु ह़मजाड़वा बाज ज्‌यो के मने यरुसलेम जवा नु से; तां डायला पुडारी, अने भगवान ना डायला पुंजारा, अने युहदी धरम ह़ीकाड़न्‌या मने वेला पाड़हे अने मने मार नाख्‌हे। पण मे तीसरा दाड़े पासो जीवतो हय जही। ");
INSERT INTO bpx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","पतरस ईसु ने आंग्‌ये ली ज्‌यो अने तीने आहयु कीन वड्‌यो, ए मालीक! तारी ह़ाते भगवान आसम नी करे तारी पोर आसम कदी नी हये। ");
INSERT INTO bpx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","पण ईसु पासो वळीन पतरस ने केदो, ए भुतड़ा! मारीन्‌तां गेथो सेटो जत रे! तु मारी वाट्‌ये अड़चन बण र्‌यो। काहाके तु भगवान नी वात पोर नी, पण माणहु नी वात पोर मन लगाड़े, ");
INSERT INTO bpx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","अळतेण ईसु आह़फा ना चेला ने केदो, जे कोय मारी पसळ आव्‌वा हींडे, तीहयो आह़फा ने वीहरी जवा जोवे, अने आह़फा नु कुरुस उचलीन मारी पसळ आवे। ");
INSERT INTO bpx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","काहाके जे आह़फा ने बचाड़हे तीहयो आह़फा ने खोय देहे अने जे कोय मारी जुगु, आह़फा नो जीव खोय देहे, तीहयो तीने बचाड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","कदीम माणेह आखी कळजुग ने हात कर लेय अने आह़फा नो जीव खोय देय तीहयु ह़ु काम नु? तीहयो आह़फा नो जीव बचाड़वा करीन आह़फा ना जीव नी अवजी पोर ह़ु आप्‌हे? ");
INSERT INTO bpx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","काहाके मनख्‌यान बेटो आह़फा ना ह़रगदुत नी ह़ाते आह़फा ना बाह नी बड़ाय भेळ आवहे, अने तीहयो आखा माणहु ने तीमना काम ना अनसारे फोळ आपहे। ");
INSERT INTO bpx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मे तने ह़ाचलीन केम, आञे ह़ारीक थोड़ाक आसवा माणहु बी हजुर से। जे तत्‌यार लग नी मरे जत्‌यार लग मनख्‌यान बेटा ने तीना राज मे आवत्‌लो नी देख लेय। ");
INSERT INTO bpx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छोव दाड़ा हय ज्‌या अने अळतेण ईसु, पतरस, याकुब अने तीना भाय युहन्‌ना ने तीनी ह़ाते ह़ुनकार जागा मे उचला बड़ा पोर ली ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","अने तां तीमनी अगळेत ईसु नो सीको बदली ज्‌यो। अने तीनु मोडु दाड़ुन तेम पपलवा बाज ज्‌यु, अने तीना लुगड़ा वीजाळान तेम उजळा हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","तीहयीत टेमे ईसु ना चेला ने मुसो अने एलीया तीनी ह़ाते वात करत्‌ला देखाव पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ता पतरस ईसु ने केदो, मालीक! आंया रेवा आपणी जुगु वारु से! तारी मरजी हय ता मे आञे तीन तम्‌बु बणाय देम, एक तारी जुगु एक मुसा जुगु अने एक एलीया जुगु। ");
INSERT INTO bpx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","तीहयो केवात बाज र्‌यो हतो तीहयीत टेमे पपलत्‌लु वादळु आवीन तीमने ढाक लेदु अने ह़रग मे गेथी आसम अवाज आवी, आहयोत मारो मोंगाळ्‌ळो सोरो से। मे आनी पोर घणो खुस से, आनीत वात ह़मळो! ");
INSERT INTO bpx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","आहयी वात ह़मळीन चेला मोडा ना भरहे पड़ ज्‌या, अने जबर बीही ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ता ईसु तीमनी ह़ाते आवीन तीमने छीम्‌यो अने केदो, “उठो, बीहो ना।” ");
INSERT INTO bpx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","जत्‌यार तीहया उचु भाळ्‌या, ता ईसु ने सोड़ीन तीमने कोय नी देखाव पड़्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","अने जत्‌यार ईसु बड़े गेथो उतरवा बाज र्‌यो हतो, ता तीमने हुकम आपीन आहयु केदो, जत्‌यार लग मनख्‌या नो सोरो मर्‌या-ह़र्‌या मे गेथो जीवतो नी हये, तत्‌यार लग जे कंय तमु आञे देखला से, तीहयु कोयने नी केजो। ");
INSERT INTO bpx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","एतरे तीना चेला ईसु ने पुछ्‌या, चोखली सास्‌तर ह़ीकाड़न्‌या आहयु काहा केय के पेले एलीया नु आवणु टकायलु से? ");
INSERT INTO bpx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ता ईसु केदो, एलीया ह़ाचलीन आखु कंय ह़ुदार करवा आवह़े। ");
INSERT INTO bpx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पण मे तमने की देम, के एलीया आय लागलो से। पण माणहु तीनी ह़ाते जेम गम्‌यु तेवो वेहवार कर्‌या। तेमेत मनख्‌या नो सोरो बी तीमना हाते दुख झेलहे। ");
INSERT INTO bpx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ता चेला आहयु ह़मज्‌या के ईसु तीमने बपतीस्‌मा आपण्‌या युहन्‌ना ना बारा मे केदो। ");
INSERT INTO bpx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","अने जत्‌यार ईसु माणहु ना मेळान तां पुग्‌यो, ता एक माणेह ईसुन्‌तां आयो, अने ईसु अगळ मांडा टेकीन केदो, ");
INSERT INTO bpx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“मालीक! मारा सोरा पोर गीण कर। हीने फेपरु आया करे। हीय्‌यो घण-जबर वेला कर्‌या करे; अने वळ-वळीन आक्‌ठु मे अने पाणी मे पड़ जाय। ");
INSERT INTO bpx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","मे हीने तारा चेलान्‌तां लावलो, पण तीहया हीने आरगु नी कर सक्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ईसु केदो, वण-भरह्‌या अने टीनाळ्‌ळी पीड़ी ना माणहु! कारु लग तमारी ह़ाते रेही अने मे तमने कां लग वेठतो रेम? हीय्‌या सोरा ने मारीन्‌तां ली आवो। ");
INSERT INTO bpx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ईसु ते भुत ने वड्‌यो, अने तीहयो भुत तीना सोरा मे गेथो नकळी ज्‌यो। अने तीहयु सोरु तेत्‌री घड़ी आरगु हय ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","अळतेण चेला एखलात ईसुन्‌तां आवीन पुछ्‌या, अमारी सी भुत काहा नी नीकळ्‌यो? ");
INSERT INTO bpx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ईसु तीमने केदो, तमारी पांह भरहो कमतो से; एतरे तमारी सी भुत नी नीकळ्‌यो। मे तमने ह़ाचलीन केम, कदी तमारो भरहो राय ना दाणा बराबर बी हतो, ता तमु आहया बड़ा ने बी केता के आञे गेथो ह़रकीन सेटो हय जा, ता आहयो बड़ो बी ह़रकीन सेटो हय जतो; अने तमारी जुगु कंय बी नी हय सके ईसम नी रेतु ");
INSERT INTO bpx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पण आवा भुत वीन्‌ती अने उपाह़ कर्‌या वगर नी नीकळे। ");
INSERT INTO bpx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जत्‌यार तीहया भेळा हय्‌न गलील जीला मे आया, ता ईसु आह़फा ना चेला ने केदो, मनख्‌यान बेटो माणहु ना हात मे धोका सी धरायवा वाळो से। ");
INSERT INTO bpx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","तीहयो तीने मार नाखहे, पण तीहयो तीसरा दाड़े जीवतो हय जहे। आहयु ह़मळीन चेला घणा दुखी हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जत्‌यार तीहया कफरनहुम ह़ेर मे आया, ता मंदीर नो फाळो लेवा वाळा पतरस ने तां आवीन पुछ्‌या, “ह़ु तमारो मास्‌तर मंदीर नो फाळो नी आपे?” ");
INSERT INTO bpx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पतरस केदो, “होव, आपत्‌लो।” जत्‌यार पतरस घोर आयो, ता ईसु तीने पुछते-पुछते पेलेत तीने केदो, “ए सीमोन! तु ह़ु ह़मजे? आहयी कळी ना राजा कोय पांह फाळो अने करजो लेय? आह़फा ना सोरा पांह के बीजा पांह?” ");
INSERT INTO bpx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस केदो, पारका माणहु पांह, तत्‌यार ईसु तीने केदो, ता ते बेटा ने फाळो आपवा नी पड़े। ");
INSERT INTO bpx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","पण ते बी आपणु हीय्‌या माणहु ने ठोकर नी खवाड़्‌या, एतरे तु दर्‌या धेड़े जाय्‌न गळी नाख, अने जे माछली गळी ना काटा मे पेले वळगहे तीने धर लेजे, अने तीनु मोडु उगाड़जे, ता तीनी मे तने एक सीक्‌को जड़हे। अने तीहया सीक्‌का ने लावीन मारी जुगु अने तमारी जुगु फाळो भर देजे। ");
INSERT INTO bpx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","तीहयी टेमे चेला ईसुन्‌तां आवीन पुछ्‌या, ह़रग राज मे आखा सी मोटु कोय से? ");
INSERT INTO bpx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ईसु एक नान्‌लु सोरु ने बोलायो अने तीने तीमनी वच मे उबो कर्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","अने केदो, मे तमने ह़ाचलीन केम, कदी तमु नी फीरो अने सोरान तेम नी बणो, तां तक ह़रग राज मे नी भराय सके। ");
INSERT INTO bpx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","एतरे जे कोय बी आह़फा ने आहयु नान्‌लु सोरुन तेम नीचळो बणावहे, तीहयो ह़रग राज मे आखा करते मोटो रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","अने जे कोय बी मारा नामे आवु नान्‌लु सोरु नो आव-भाव करे तीहयो मारोत आव-भाव करे। ");
INSERT INTO bpx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","जे कोय मारी पोर भरहो करवा वाळा आहया नान्‌ला मेना एक जुगु बी पाप नो जपाप बणे, तीनी जुगु आहयुत वारु से के तीना गळा मे घट्‌टी नो मोट्‌लो पोड़ बांदीन दर्‌या मे नाख देवा जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","आहयी कळी ना माणहु जुगु घणी दुख नी वात से, जे भगवान ना माणहु ने पाप मे पाड़वा नो जपाप बणे। पाप मे पड़वा नी पारख ते आया करहे, पण तीहया माणेह जुगु बी घणी दुख नी वात से, जे बीजा जुगु पाप नो जपाप बणे। ");
INSERT INTO bpx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","कदीम तमारो हात नीता तमारो पोग तमारी जुगु पाप नो जपाप बणे! ता तीने तोड़ीन नाख देवो। वारु आहयुत से के तमु लुल्‌ला नीता लंगड़ा हय्‌न बी अमरकाय अने जलमकी जीवाय हात कर लेवो, नीता कंखर माय्‌न आसम नी हय जाय के बेम हात अने बेम पोग रीन बी, तमु नी ओलायवा वाळी आक्‌ठी मे नखाय जावो। ");
INSERT INTO bpx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अने कदीम तमारो डोळो तमारी जुगु पाप नो ठोकर बणे, ता तीने काडीन नाख देवो। वारु ते आहयुत से के तमु काण्‌या हय्‌न बी, अमरकाय जीवाय हात कर लेवो, नीता कंखर माय्‌न आसम नी हय जाय के तमारा बेम डोळा हय्‌न बी, तमु नरक-आक्‌ठी मे नखाय जावो। ");
INSERT INTO bpx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","चेतीन रेवो! जे मारी पोर भरहो करे, तीमनी मे जे नान्‌ला से, तीमने बी तमु हेटा नी ह़मज्‌जो। काहाके मे तमने देखाड़ु के ह़रग मे आमना ह़रगदुत आमनी जुगु मारा बाह नी अगळ वीन्‌ती करवा नी लेदे हमेसा हजुर रेय। ");
INSERT INTO bpx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","मनख्‌या नो सोरो खोवाय जेला से, तीमने ह़ोदवा करीन आवलो से। ");
INSERT INTO bpx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","तमारो ह़ु वीच्‌यार से? मान लेवो कदीम कोयना एक ह़ोव गाडरा हय, अने तीमनी मेनु एक खोवाय जाय, ता तीहयो एक कम ह़ोव गाडरा ने बड़ी पोर रेवा दीन, तीहयु खोवायलु गाडरु ने ह़ोदवा नी जाय ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","अने कदीम तीहयु जड़ जाय ता मे ह़ाचलीन केम, के तीहयो तीहया एक कम ह़ोव गाडरान करते एतरो खुस नी हये, जेतरो खुस आहया जड़लु गाडरुन करता हयहे। ");
INSERT INTO bpx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","आसमेत तमारा ह़रग वाळा बाह नी आहयी मरजी से के तीनी पोर भरहो करे तीमनी नान्‌ला मे गेथो एक बी भगवान गेथो सेटो हयवा नी जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","कदीम तारो भाय तारा वीरोद मे पाप करे, ता तीने एखलो ली जाय्‌न ईसम पाप नी करवा जोवे, करीन ह़मजाड़ देवो, अने कदीम तीहयो तमारी वात मानीन भगवान वगे वळ जाय, ता तमु तमारा भाय ने बचाड़ लेदा केवाये। ");
INSERT INTO bpx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","कदीम तीहयो तमारी वात नी माने, ता अळी एक नीता बे जणा ने ह़ाते ली जावो, काहाके बे नीता तीन गवा नी लारे तीहयी आखी वात पुरी हय जाय। ");
INSERT INTO bpx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","कदीम तीहयो तीमनी बी नी ह़मळे, ता मंडळी ने की देवो, अने कदीम तीहयो मंडळी नी बी नी ह़मळे, ता तीने आड़जात्‌या नी अने फाळो लेवा वाळान तेम ह़मजो। ");
INSERT INTO bpx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","मे तमने ह़ाचलीन केम, तमु जे धरती पोर बांदहु तीहयी ह़रग मे बी बंदायहे, अने जे कंय धरती पोर छोड़हु तीहयु ह़रग मे बी छुटहे। ");
INSERT INTO bpx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","अळी मे तमने ह़ाचलीन केम, कदीम धरती पोर तमारी मे बे जणा एक-मन्‌या हय्‌न कंय बी मांगहे, ता तीहयु तीमने मारा ह़रग वाळा बाह वगे गेथु जड़हे; ");
INSERT INTO bpx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","काहाके जां बी बे जणा नीता तीन जणा मारा नाम सी भेळा हये, तां ह़ारीक मे तीमनी वच मे हजुर रेम। ");
INSERT INTO bpx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ता पतरस ह़ाते आवीन ईसु ने केदो, मालीक! कदीम मारो भाय मारा वीरोद मे गुनो करतोत जाय, ता तीने मे केतरी कावा माफी आपु? ह़ात कावा लग माफी आपु ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ईसु तीने केदो, “मे तने आहयु नी केतो, के ह़ात काव पण ह़ात कावा ना सत्‌तर गुणा तक।” ");
INSERT INTO bpx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","एतरे ह़रगे नु राज तीहया राजा ह़रकु से, जे आह़फा ना पावर्‌या नो लेखो लेवा हींड्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जत्‌यार तीहयो लेखो लेवा बाज ज्‌यो, ता एक जणा ने तीनी अगळ लायो जे करोड़ो रुप्‌या नो करजा वाळो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","जत्‌यार तीनी पांह करजो छुटवा जुगु कंय नी हतु, ता तीनो मालीक केदो, “आने अने आनी लाडी अने सोरा ने अने जे कंय आनु से आखु वेच देवो, अने तीहयो करजो छुटे।” ");
INSERT INTO bpx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","आहयु देखीन तीहयो पावर्‌यो पड़ीन तीने वांद्‌यो, अने केदो, “ए मालीक, दम धर, मे आखु कंय छुट देही। ");
INSERT INTO bpx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तत्‌यार तीहया पावर्‌या नो मालीक तीनी पोर गीण करीन तीने सोड़ देदो, अने तीनो करजो माफ कर देदो।” ");
INSERT INTO bpx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","पण जत्‌यार तीहयो पावर्‌यो बारो नीकळ्‌यो, ता तीना ह़ाती पावर्‌या मेनो एक तीने भेट्‌यो, जे तीनी पांह ह़ोव दीनार करजो लेदलो हतो; तीहयो तीने धर लेदो अने गळु चमदीन केदो, “जे कंय तु मारी पांह गेथो करजो लेदलो से तीहयो आप दे।” ");
INSERT INTO bpx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ता तीहयो पावर्‌यो तीना ह़ाती पावर्‌या ना पोगु पड़ीन वीन्‌ती करवा बाज ज्‌यो; दम धर मे आखु भर देही। ");
INSERT INTO bpx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पण तीहयो पावर्‌यो नी मान्‌यो, अने तीने ली जाय्‌न जेल मे कुंड देदो; के तीहयो जत्‌यार तक करजो नी छुट जाय तांह तक तीहयो तांत रेय। ");
INSERT INTO bpx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","तीना ह़ाते वाळा बीजा पावर्‌या आहयु देखीन घणा नराज हय ज्‌या अने जाय्‌न ह़ु-ह़ु हयु तीहयु आखु तीमना मालीक ने देखाड़ देदा। ");
INSERT INTO bpx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तत्‌यार तीनो मालीक तीने बोलावीन केदो, “ए वेरी चाकर्‌या, तु जे मारी पांह वीन्‌ती कर्‌यो, ता मे ते तारो पुरो करजो माफ कर्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","एतरे जेम मे तारी पोर दया कर्‌यो, तेमेत ह़ु तने तारा ह़ाते वाळा पावर्‌या पोर दया नी करवा जोवे ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","अने तीनो मालीक खीजवाय्‌न तीने डंड आपवा वाळा ना हात मे ह़ोप देदो, के जत्‌यार तक तीहयो आखो करजो छुटी नी जाय, तांह तक तीना हात मे रेय। ");
INSERT INTO bpx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“आहयीत रीते कदीम तमारी माय्‌न आखा आह़फा ना भाय ने मन सी माफ नी करे, ता मारो बाह जे ह़रग मे से, तमारी ह़ाते बी आसमेत करहे।” ");
INSERT INTO bpx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","आहयी वात कीदीन ईसु गलील जीला मे गेथो जत र्‌यो, अने यरदन नंदी ना ह़ेली धेड़े युहद्‌या देस मे पुग्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","एक घणो मोटो माणहु नो मेळो ईसु पसळ चाल पड़्‌यो, अने ईसु माणहु ने आरगा कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","फरीसी दलवाळा ईसुन्‌तां आया, अने तीनी पारख करता जाय्‌न, आहयी वात पुछ्‌या, “काना बी कारण सी आह़फा नी लाडी ने सोड़वा ताले से ह़ु?” ");
INSERT INTO bpx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ईसु केदो, “तमु चोखली सास्‌तर मे नी भण्‌या ह़ु, भगवान सुरु गेथोत तीमने एक बयर अने एक अदमी करीन बणायो। ");
INSERT INTO bpx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","अने भगवान केदलो, के आहया कारण सी, अदमी आह़फा ना आय्‌ह़-बाहा गेथो अलग हय जहे, अने तीनी लाडी ह़ाते रेहे, अने तीहया बे एक डील हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","एतरे हमणे गेथा तीहया बे नी, पण एक डील से: एतरे जीमने भगवान जोड़लो से, तीमने माणहु अलग नी करवा जोवे।” ");
INSERT INTO bpx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","तीहया ईसु ने पुछ्‌या, “ता मुसो ह़ुका सोड़वा नी चीट्‌ठी आपीन लाडी ने सोड़वा नो नेम आपलो?” ");
INSERT INTO bpx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ईसु तीमने केदो, “तमारा मन नी ठटाय जाणीन मुसो तमारी जुगु लाडी सोड़वा नो हुकम लीखीन आप्‌यो। पण सुरु गेथोत ईसम नेम नी हतो। ");
INSERT INTO bpx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","पण मे तमने केम, छीनाळु ने सोड़ीन काना बीजा बोना सी, जे आह़फा नी लाडी ने सोड़े, अने कानी बीजी बयर ह़ाते वेवा करे, तीहयो बी छीनाळु करे।” ");
INSERT INTO bpx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेला ईसु ने केदा, “कदीम अदमी नो बयर नी ह़ाते मेळ एमेत से, ता वेवा नी करवा वारु से।” ");
INSERT INTO bpx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ईसु तीमने केदो, “आखा आहयु बोल आवरी नी सके। पण भगवान जीने दान आपलो से, तीहया एतरात वेवा कर्‌या वगर जीव्‌वा नी वात ने ह़मजी सके। ");
INSERT INTO bpx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","काहाके थोड़ाक माणहु ईसम से जे आय्‌ह़ नी कोख मे गेथात हीजड़ा जणायला से, अने थोड़ाक माणहु ईसम से, जीमने बीजा माणहु हीजड़ा बणाय देदला से। अने थोड़ाक माणहु ईसम से जे ह़रग ना राज नी करता वेवा करे वगर जीव्‌वा करीन वात ठाण लेदला से। ईमने वेवा करे वगर जीव्‌वा नी ताखत जड़ली से, तीमने सड़लो रेवा जोवे।” ");
INSERT INTO bpx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तीहयी टेमे माणहु आह़फा-आह़फाम ना सोरा-सोरी ने ईसुन्‌तां आनीन करते लाया के तीहयो तीमनी पोर हात मेलीन वीन्‌ती करे करीन, पण सोरा ने ह़ु करवा लाय र्‌या करीन तीना चेला माणहु ने वड्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","बाखीन ईसु केदो, “सोरा ने मारीन्‌तां आव्‌वा देवो, अने हीमने ना रोको, काहाके ह़रग नु राज हीमनी ह़ारका नु से।” ");
INSERT INTO bpx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","अने तीहयो सोरा पोर हात मेकीन तीमने संयबरकत आप्‌यो अने तां गेथो जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","एक जणो ईसुन्‌तां आवीन केदो, “ए मास्‌तर! अमरकाय जीवाय हात करवा करीन मे कानु भलु काम करु?” ");
INSERT INTO bpx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ईसु तीमने केदो, “तु मने भलाय ना बारा मे काहा पुछे? भलो ते एकीत से, जे भलाय करे। कदीम तु जीवाय हात करवा केय ता हुकम मान।” ");
INSERT INTO bpx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","तीहयो ईसु ने पुछ्‌यो, “काना हुकम पाळु?” ईसु केदो, “हत्‌या नी करजे; छीनाळु नी करजे, चोरी नी करजे, झुटी गवाय नी देजे। ");
INSERT INTO bpx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘आह़फा ना आय्‌ह-बाहा नी ईज्‌जत करजे’ अने ‘जेम तु आह़फा ने मोंग करे तेमेत तारा ह़ाते वाळा ने बी मोंग करजे।’” ");
INSERT INTO bpx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","तीहयो जुवान्‌यो ईसु ने केदो, “मे आहया आखा हुकम ने पाळलो से। मारी मे अळी कानी वात नी कसर से?” ");
INSERT INTO bpx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ईसु तीहया जुवान्‌या ने केदो, “कदीम तने पुरो पक्‌को बणवा हय ता, जा! तारु आखु धन वेचीन गरीब ने आप दे, अने ह़रग मे तने मेल्‌लु धन जड़हे। अने अळतेण आवीन मारी पसळ चाल।” ");
INSERT INTO bpx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","आहयु ह़मळीन तीहयो जुवान्‌यो घणो ह़ोह़वाय्‌न जत र्‌यो, काहाके तीहयो घणो मालदार हतो। ");
INSERT INTO bpx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ता ईसु आह़फा ना चेला ने केदो, “मे तमने ह़ाचलीन केम, मालदार जुगु ह़रग राज मे भरायवा काठु से।” ");
INSERT INTO bpx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","मे अळी केम “के ह़ोय ना डुचा मे हय्‌न उटड़ा ने सरकवा नु सरल से, बाखीन मालदार ने भगवान ना राज मे भरायवा घणु काठु से।” ");
INSERT INTO bpx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","आहयु ह़मळीन चेला घणा वहराय ज्‌या अने केदा, “ता कोयने छुटकारो जड़हे?” ");
INSERT INTO bpx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ईसु तीमनी भणी भाळीन केदो, “माणहु जुगु ते आहयु, नी बणे एवु से। पण भगवान जुगु आखु कंय बण जाय।” ");
INSERT INTO bpx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ता पतरस ईसु ने केदो, “देख, आमु अमारु आखु कंय सोड़ीन तारा चेला बण जेला से। ता, आमने ह़ु जड़हे?” ");
INSERT INTO bpx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ईसु आह़फा ना चेला ने केदो, “मे तमने ह़ाचलीन केम, के नवली कळी मे जत्‌यार मनख्‌या नो सोरो पासो आवीन आह़फा नी बड़ाय सी भराय्‌न राजगादी पोर बठह़े, ता तमु बी बारे राजगादी पोर बहीन ईस्‌रायल ना बारे कुळी नो नीयाव करहु, काहाके तमु मारी वात मानीन, मारी पसळ चालवा बाज र्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अने जे मारा नाम ना लेदे आह़फा ना घोर ने नीता आह़फा ना सग्‌गा भाय ने अने बेनेह ने अने आय्‌ह-बाहा ने सोरा-सोरी ने, नीता खेतर वाड़ी मारा नाम नी करते सोड़ देदलो से, तीहयो ह़ोव गुणा हात करहे, अने तीहयो अमरकाय जीवाय नो हकदार्‌यो हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पण घण ढेरका माणहु जे पेला से तीहया पाछला हय जहे, अने जे पाछला से तीहया पेल्‌ना हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ह़रग नु राज तीहया घोर ना मालीक ह़रकु से, जे आह़फा नी अंगुर नी वाड़ी मे दाड़क्‌या लगाड़वा करीन ह़वारे नीकळ्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","तीहयो दाड़क्‌या ह़ाते एक दाड़ा नी दाड़की एक चांदी नो सीक्‌को ठेरायो अने तीमने अंगुर नी वाड़ी मे मोकल्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","दाड़ा नी नवेक बजे बारो नीकळ्‌यो, अने तीहयो हाट मे ढेरेत माणहु ने रीकामा उबा हय रेला देखीन, ");
INSERT INTO bpx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","तीमने केदो, “तमु बी मारी अंगुर नी वाड़ी मे जावो, मे तमने तालेत दाड़की आपही।” ");
INSERT INTO bpx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","अने तीहया बी वाड़ी मे काम करवा करीन जत र्‌या। अळी माथे दाड़े अने मांजणीक दाड़े बी तीहयो एमेत दाड़क्‌या ह़ोदवा करीन ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","अने तीहयो दाहड़ु बुडवा सी एक घंटो पेले अळी तीहयो बारो नीकळीन ज्‌यो अने अळी तां बीजा ने उबा हय रेला देखीन तीमने केदो, “तमु आञे ह़ारीक आखो दाड़ो रीकामा काहा उबा हय र्‌या?” ");
INSERT INTO bpx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","तीहया तीने केदा, “आमने कोय नी दाड़क्‌या लगाड़्‌या करीन आमु आञे ह़ारीक उबा हय र्‌या।” तीहयो तीमने केदो, “तमु बी मारी अंगुर नी वाड़ी मे काम करवा जावो।” ");
INSERT INTO bpx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ह़ांती टेमे अंगुर नी वाड़ी नो मालीक आह़फा ना मुनीम ने केदो, “दाड़क्‌या ने बोलाव” अळतेण पसळ वाळा ने लीन, पेले आव्‌वा वाळा तक, आखा ने दाड़की आप दे। ");
INSERT INTO bpx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जत्‌यार तीहया दाड़क्‌या आया, जे एक घंटो दाड़ु बुडवा मे री रेलुन लगाड़ला, ता तीमने एक-एक दीनार आप्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जत्‌यार जे पेले दाड़क्‌या आवला ता तीहया ह़मजी र्‌या हता, के आमने वदु जड़हे; बाखीन तीमने बी एक-एक दीनार आप्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जत्‌यार तीहया ली लेदा, ता लीन तीहया आहयु केता जाय्‌न मालीक नी वीरोद करवा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","तीहया केदा, “आहया पाछला दाड़क्‌या एक घंटो काम कर्‌या। ते बी तु अमारी बराबर दाड़की आप्‌यो, पण आमु आखो दाड़ो तोप मे काठी मेहनत कर्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","तीहयो तीमनी मेना एक ने आहयु केदो, “भाय! मे तमारी ह़ाते गलत नीयाव नी करतो, तमु मारी ह़ाते एक दाड़ो दीनार नी बोली नी कर्‌या ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","तारी दाड़की ले अने जत रे, मे आहया पाछला दाड़क्‌या ने बी तारीन तेतरु आपवा हींडु। ");
INSERT INTO bpx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ह़ु आहयु वारु नी हय के मारा धन ने मारी मरजी सी वापरु? तमु मारी भलाय ने देखीन मारी पोर काहा कुहराय र्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","आहयीत रीते जे पसळ से, तीहया अगळ हय जहे, अने जे अगळ से, तीहया पसळ हय जहे।” ");
INSERT INTO bpx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ईसु यरुसलेम नी वाट्‌ये अगो जवा बाज र्‌यो हतो। ता बारे चेला ने अगळ ली जाय्‌न तीहयो चालतो-चालतो तीमने केदो, ");
INSERT INTO bpx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देखो, आपणु यरुसलेम जवा बाज र्‌या। मनख्‌या नो सोरो डायला पुंजारा ना अने चोखली सास्‌तर ह़ीकाड़न्‌या ना हात मे धराय देहे। तीहया तीने मारवा नी सजा ह़मळावहे, ");
INSERT INTO bpx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","अने आड़जात्‌या माणहु ना हात मे ह़ोप देहे, जीनी सी तीहया माणहु तीनी हाही उडाड़ह़े, अने तीने चापका देहे अने कुरुस पोर चड़ावहे; बाखीन तीसरा दाड़े तीहयो जीवतो हय जहे।” ");
INSERT INTO bpx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","जत्‌यार जब्‌दी ना सोराम नी आय्‌ह आह़फा ना सोराम नी ह़ाते ईसुन्‌तां आवीन वांदी अने तीनी पांह कंय मांगवा बाज जी। ");
INSERT INTO bpx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ईसु तीने हुकम आपीन केदो, “ह़ु जोवे?” तीहयी केदी, “आहया मारा बे सोरा से। तु कीदे, के तारा राज मे एक तारी जमणी धेड़े अने एक तारी डखरी धेड़े बहे।” ");
INSERT INTO bpx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ईसु जपाप आप्‌यो, “तमु नी जाणता के तमु ह़ु मांगवा बाज र्‌या। जे दुख नो पीयालो मे पीवा वाळा से, तीहयो दुख नो पीयालो तमु पी लेहु ह़ु?” तीहया केदा, “होव मालीक।” ");
INSERT INTO bpx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","एतरा मे ईसु तीमने केदो, “ह़ाचलीन तमु तीहयो दुख नो पीयालो ते पी लेहु, पण तमने मारी जमणी धेड़े, नीता डखरी धेड़े बहाड़वा नो हक मारी पांह नी हय, मारी जमणी धेड़े अने डखरी ह़ोड़ नो जागो, तीहया माणहु जुगु से, जीमनी वाटु मार बाह तीयार करलो से।” ");
INSERT INTO bpx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","जत्‌यार दह़ चेला आहयी वात ह़मळ्‌या, ता तीहया बेम भाय पोर रीहवाय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ईसु आह़फा ना चेला ने ह़ाते बोलावीन केदो, “तमु जाणो के आखा देस ना माणहु पोर राज करन्‌या मुख्‌या, आह़फा ना असामी पोर राज करे, अने तीहया हक राखवा वाळा पोर अळी बीजा मोट्‌ला माणहु हक जमाड़े। ");
INSERT INTO bpx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पण तमारी मे आवा हक नो कायदो नी रेवा जोवे। जे तमारी मे मोटो बणवा हींडे तीहयो तमारो पावर्‌यो बणवा जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","अने तमारी मे डायलो बणवा हींडे, तीहयो तमारो पावर्‌यो बणवा जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","काहाके मनख्‌या नो सोरो बी आह़फा नी चाकरी कराव्‌वा करीन नी, बाखीन चाकरी करवा करीन अने ढेरेत जणा ने सोड़ाव्‌वा करीन आह़फा नो जीव आपवा आवलो से।” ");
INSERT INTO bpx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जत्‌यार तीहया यरीहो ह़ेर गेथा जवा बाज र्‌या हता, ता एक मोट्‌लो माणहु नो मेळो ईसु पसळ-पसळ चाल पड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अने तां ह़ारीक रोहा धेड़े बे आंदळा बह र्‌या हता। जत्‌यार तीहया आहयु ह़मळ्‌या के ईसु तीमनी अगळ माय्‌न जवा बाज र्‌यो, ता तीहया आड़ी-आड़ीन केवा बाज ज्‌या, “ए मालीक! दावुद नी अवल्‌यात! अमारी पोर गीण कर।” ");
INSERT INTO bpx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","माणहु तीहया आंदळा ने होगा री जावो करीन वड्‌या, पण तीहया अळी बी ज्‌योरेत आड़ीन केदा, “मालीक! दावुद नी अवल्‌यात! अमारी पोर गीण कर।” ");
INSERT INTO bpx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ईसु उबो रीन तीमने बोलायो अने केदो, “तमने ह़ु जोवे? मे तमारी जुगु ह़ु करु?” ");
INSERT INTO bpx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","तीहया केदा, “ए मालीक! आहयु के आमु देखवा बाज जीया।” ");
INSERT INTO bpx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ईसु गीण करीन तीमना डोळा छीम्‌यो, अने तेतरी घड़ी तीहया देखवा बाज ज्‌या, अने तीहया ईसु पसळ चाल पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जत्‌यार ईसु अने तीना चेला यरुसलेम नी ह़ाते पुग्‌या अने जेतुन बड़ा पोर वाळा बेतफगे गाम आय लाग्‌या, ता ईसु बे चेला ने आहयु कीन मोकल्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“तमु अगळ ना गाम मे जावो। तां पुगतेत तमने एक गदड़ी बांदली अने तीनी ह़ाते पाठड़ु गदड़ु बी देखाव पड़हे। तीने सोड़ीन मारीन्‌तां ली आवो। ");
INSERT INTO bpx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","कदीम कोय तमने कंय केय, ता तीने तमु आहयु की देजो, ‘मालीक ने आहया जोय र्‌या।’ अने तीहयो आमने छोटोत पासो ली मोकलहे।” ");
INSERT INTO bpx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","आहयु आनीन करते ईसम हयु के भगवान भणी गेथो केण्‌या नु आहयु केवा नु पुरु हय जाय: ");
INSERT INTO bpx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सीयोन ह़ेर मे रेवा वाळा माणहु ने केवो, देख, तारो राजा तारीन्‌तां आव्‌वा बाज र्‌यो; तीहयो नीचळो से, तीहयो गदड़ु पोर बह र्‌यो; हाव, गदड़ु नु बच्‌चु पोर बह र्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेला जाय्‌न जेम ईसु तीमने केदो तेम ने तेम कर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","गदड़ु ने अने तीनु बच्‌चु ने ली आया, अने तीहया तीहयु गदड़ु ने आह़फा ना लुगड़ा ओडाड़ देदा, अने ईसु तीनी पोर बहीन ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","अने घणा ढेरका माणहु ईसु नो आव-भाव करवा करीन आह़फा ना लुगड़ा वाट पोर आथरी देदा। अने थोड़ाक माणहु झाड़ ना डाळ्‌या वाडीन वाट पोर आथरी देदा। ");
INSERT INTO bpx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ईसु नी अगळ-अगळ जता जीन अने पसळ-पसळ आवता जीन माणहु ईसम की र्‌या हता, “दावुद नी अवल्‌यात ने होसन्‌ना! बरकत वाळो से तीहयो, जे भगवान मालीक ना नाम सी आवे। आखा मे उचा ह़रग मे रेवा वाळा नी होसन्‌ना!” ");
INSERT INTO bpx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जत्‌यार ईसु यरुसलेम मे आयो, ता आखा ह़ेर मे हुलड़ मच जी, अने माणहु केवा बाज ज्‌या, “आहयो कोय से?” ");
INSERT INTO bpx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","अने माणहु केता हता, “आहयो गलील जीला नो नासरत ह़ेर वाळो भगवान वगे गेथी वात केण्‌यो माणेह ईसु से!” ");
INSERT INTO bpx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ईसु मंदीर मे मोय ज्‌यो अने तां गेथा आखा वेचवा वाळा अने लेवा वाळा ने बारथा काड देदो। तीहयो पय्‌हा ना अदला-बदली करन्‌या ना टेबल्‌या ने अने पारवा वेचवा ना पाटला ने उथलाय देदो। ");
INSERT INTO bpx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अने तीमने केदो, “खरली सास्‌तर मे लीखलु से, ‘मारु घोर वीन्‌ती नु घोर केवायहे, पण तमु ईने चोट्‌टा नु घोर बणाय र्‌या।’” ");
INSERT INTO bpx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","मंदीर मे आंदळा अने लंगड़ा ईसुन्‌तां आया, अने तीहयो तीमने आरगा कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","जत्‌यार भगवान ना डायला पुंजारा अने चोखली सास्‌तर ह़ीकाड़न्‌या मास्‌तर्‌या ईसु ना भारी जुदा-काम देख्‌या, अने सोरा ने मंदीर मे आहयु केतला ह़मळ्‌या, “दावुद नी अवल्‌यात ने होसन्‌ना!” ता तीहया रीहवाय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","अने तीहया ईसु ने केदा, “आहया ह़ु केवा बाज र्‌या तीहयु तु ह़मळी र्‌यो ह़ु?” ईसु तीमने केदो, “होव, ह़मळी र्‌यो, पण तमु आहयु कदी नी भण्‌या ह़ु ‘सोरा अने दुत पीता नान्‌ला सोरा ना मोडे तु आह़फा नु गुण गवाड़लो से?’” ");
INSERT INTO bpx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","एतरु कीदीन ईसु तीमने सोड़ीन ह़ेर मे गेथु नीकळीन बेतन्‌या जत र्‌यो अने आखी रात तां र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","बीजा दाड़े ह़वारे वेगोत जत्‌यार ईसु पासो ह़ेर मे आव्‌वा बाज रेलो ता तीने भुक लागी। ");
INSERT INTO bpx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","तीहयो वाट धेड़े गुलर नु झाड़ देखीन तीनी ह़ाते आयो, तीने तीनी मे पान्‌टा वगर कंय नी जड़्‌यु, अने तीहयो तीहया गुलर ना झाड़ ने केदो, “तारी मे अळी कदी फोळ नी लागवा जोवे।” अने तेतरी घड़ी तीहयु गुलर नु झाड़ ह़ुक ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","आहयु देखीन चेला वहराय ज्‌या अने केदा, “आहयु गुलर नु झाड़ तत्‌यारुत कीसम ह़ुकाय ज्‌यु?” ");
INSERT INTO bpx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ईसु तीमने केदो, “मे तमने ह़ाचलीन केम, कदीम, तमारो भरहो हय अने तमु सण्‌का नी करो, ता मे गुलर ना झाड़ ने जीसम केदो तेमेत हय ज्‌यु, तेमेत तमु केहु, ते बी तेमेत हय जहे। पण कदीम तमु आहया बड़ा ने केहु, आञे गेथो ह़रकीन दर्‌या मे पड़ जा, ता आहयो बड़ो तमारी वात मान लेहे, अने तेमेत हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अने तमु जे कंय वीन्‌ती करीन भरहा सी मांगहु, तीहयु तमने आखु जड़ जहे।” ");
INSERT INTO bpx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","जत्‌यार ईसु भगवान ना मंदीर मे जीन ह़ीकापण आप्‌तो हतो, ता डायला पुंजारा अने डायला पुडार्‌या ईसुन्‌तां आवीन केदा, “तु काना हक सी आहयु आखु करवा बाज र्‌यो? कोय तने हक आप्‌यो?” ");
INSERT INTO bpx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ईसु तीमने केदो, “मे बी तमने एक सवाल पुछु, कदीम तमु मने तीनो जपाप आप देदा, ता मे बी तमने की देही के मे काना हक सी आहयु आखु करवा बाज र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","बपतीस्‌मा आपण्‌या युहन्‌ना ने बपतीस्‌मा आपवा नो हक कां गेथो जड़लो, भगवान वगे गेथो जड़लो के माणहु वगे गेथो जड़लो?” आहयी वात ह़मळीन तीहया वीच्‌यार कर्‌या के कदीम आमु केहु के भगवान वगे गेथो हक जड़लु से, ता हीय्‌यो केहे के तीनी पोर भरहो काहा नी कर्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","पण कदीम आमु केहु, “माणहु वगे गेथो जड़लो से, ता आहया माणहु नो धाक से; काहाके आहया आखा माणहु बपतीस्‌मा आपण्‌या युहन्‌ना ने भगवान वगे गेथी वात केण्‌यो माणेह माने।” ");
INSERT INTO bpx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","एतरे तीहया ईसु ने जपाप आप्‌या, “कय जाणु, आमु ने नी मालम हय?” एतरे ईसु तीमने केदो, “ता मे बी तमने नी केतो के मे काना हक सी आहयु आखु करु।” ");
INSERT INTO bpx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","तमारो ह़ु वीच्‌यार से? काना अदमी ना बे सोरा हता। तीहयो पेल्‌नान तां जीन हुकम आपीन केदो, “सोरा जा, आज अंगुर नी वाड़ी मे काम कर।” ");
INSERT INTO bpx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","पण सोरो जपाप आप्‌यो, मे नी जाम, पण अळतेण तीना मन मे अंगुर नी वाड़ी मे जवा नो वीच्‌यार आय ज्‌यो अने तीहयो अंगुर नी वाड़ी मे जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","अळतेण बाह बीजा सोरा नी तां जीन ईसमेत केदो, तीहयो केदो, “होव बाह, मे अंगुर नी वाड़ी मे जही। पण तीहयो अंगुर नी वाड़ी मे नी ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","हमणे तमु केवो, आहया बे जणा माय्‌न कोय बाह नी मरजी पुरी कर्‌यो?” तीहया ईसु ने केदा, “पेल्‌नो सोरो बाह नी मरजी पुरी कर्‌यो।” एतरा मे ईसु तीमने केदो, मे ह़ाचलीन केम, फाळो लेण्‌या अने रंड्‌या तमारी गेथा पेले भगवान ना राज मे जहे। ");
INSERT INTO bpx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","बपतीस्‌मा आपण्‌यो युहन्‌ना तमने धरम नी वाट देखाड़वा आयो, अने तमु तीनी पोर भरहो नी कर्‌या, बाखीन फाळो लेण्‌या अने रंड्‌या तीनी पोर भरहो कर्‌या। आहयु देखीन अळतेण बी तमु पाप भणी गेथा वळीन भगवान वगा हय्‌न तीनी वात पोर भरहो नी कर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","एक बीजो दाखलो ह़मळो: कानो कीरसाण अंगुर नी वाड़ी लगाड़्‌यो, तीना च्‌यारो-मेर वाड़ बांद्‌यो, अने तीहयी वाड़ी मे अंगुर नो रोह काडवा करीन एक खाडो खोदीन हळावो बणायो, अने वाड़ी मे एक पक्‌को माळो बणायो। अळतेण तीहयो अंगुर नी वाड़ी ने बीजा कीरसाण ने साजा मे आपीन ढेरेत नाम्‌बे बीजा देस मे जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","अंगुर नी मेर भेळी करवा नी टेम आयी, ता तीहयो वाटो लेवा करीन कीरसाण ने तां आह़फा ना पावर्‌या ने मोकल्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","बाखीन तीहया कीरसाण्‌या तीहया पावर्‌या ने धरीन काना ने ठोक्‌या; अने काना ने दगड़ाट्‌या, अने काना ने मार नाख्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","अळतेण एक कावा अळी तीहयो पेले गेथा ढेरका पावर्‌या ने मोकल्‌यो अने तीहया कीरसाण्‌या तीमनी ह़ाते तेवोत वेहवार कर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखरी कावा तीहयो आह़फा ना बेटा ने आहयु वीच्‌यारीन मोकल्‌यो के तीहया मारा बेटा नी ईज्‌जत करहेन करहे। ");
INSERT INTO bpx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","पण तीहया कीरसाण्‌या जत्‌यार मालीक कीरसाण ना बेटा ने देख्‌या ता एक-बीजा ने केदा, “आहयो ते वारीसदार से। आवो, आपणु आने मार नाखता अने आनी जागा पोर कब्‌जो कर लेता।” ");
INSERT INTO bpx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","तीहया तीने धर लेदा अने अंगुर नी वाड़ी मे गेथा बारथा नीकाळीन मार नाख्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","अळतेण ईसु तीमने पुछ्‌यो, “जत्‌यार अंगुर नी वाड़ी नो मालीक पासो आवहे, ता तीहयो ते कीरसाण्‌या नु ह़ु करहे?” ");
INSERT INTO bpx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","तीहया ईसु ने केदा, “तीहयो ते कुहर्‌या ने मारीन खत्‌तम कर नाखहे, अने आह़फा नी अंगुर नी वाड़ी बीजा कीरसाण ने साजा मे आप देहे, जे टेमे-टेमे अंगुर नी मेर नो वाटो आप्‌या करहे।” ");
INSERT INTO bpx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ईसु तीमने केदो, “तमु खरला सास्‌तर मे आहयु कदी भण्‌या नी ह़ु: ‘जे दगड़ा ने राज-मीस्‌तर्‌या रीकामो ह़मजीन बारथो नीकाळ देदा, तीहयो दगड़ोत घोर ना पाया ना, खुणे वाळो दगड़ो बण ज्‌यो? आहयु ते मालीक वगे गेथु हयु, आहयु ते अमारी नींगा मे सेल-भात्‌यु से।’” ");
INSERT INTO bpx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","एतरे मे तमने केम, भगवान, ह़रग नु राज तमारा हात मे गेथु हापकी लेहे अने राज्‌य ना माणहु ने आप देहे जे भगवान ना राज ना कायदा पाळीन जीवहे। ");
INSERT INTO bpx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“जे आहया दगड़ा पोर पड़ जहे, तीहयो टुकड़ा-टुकड़ा हय जहे, अने जीनी पोर आहयु दगड़ो पड़हे, तीने दळ देहे।” ");
INSERT INTO bpx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","डायला पुंजारा अने फरीसी पंथवाळा वाळा आहयो दाखलो ह़मळीन ह़मज ज्‌या के ईसु आहयु तीमनात बारा मे की र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","करीन तीहया ईसु ने धरवा नी कोसीत ते कर्‌या बाखीन तीमने माणहु नी बीक हती, काहाके माणहु ईसु ने भगवान वगे गेथो केवा वाळो ह़मजता हता। ");
INSERT INTO bpx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ईसु अळी तीमने दाखला ह़मळाव्‌वा बाज ज्‌यो। तीहयो केदो, ");
INSERT INTO bpx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ह़रग नु राज तीहया राजा ह़रकु से, जे आह़फा ना सोरा ना वेवा मे पंगात बहाड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","राजो आह़फा ना पावर्‌या ने नेवतु आपला माणहु ने बोलाव्‌वा करीन मोकल्‌यो, बाखीन तीहया आव्‌वा नी हींड्‌ता हता। ");
INSERT INTO bpx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","राजो नेवतु आपला माणहुन तां अळी बीजा पावर्‌या ने आहयु केतो जाय्‌न मोकल्‌यो, “नेवतु आपला तीहया माणहु ने की देवो, देखो! मे मारी पंगात नु खाणु तीयार कर देदलो से। मारा बोळद्‌या अने पाळ्‌ळा जानवरु मराय नाखलो से। अने खाणु तीयार से; वेवा नी पंगात मे आवो।” ");
INSERT INTO bpx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पण तीहया आहयी वात पोर धीयान नी देदा। कानो आह़फा ना खेतर भणी जत र्‌यो, अने कानो आह़फा नु वेपारु करवा जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","अने काना माणहु तीहया राजा ना पावर्‌या ह़ाते वारु वेहवार नी कर्‌या अने तीमने मार नाख्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","आहयी वात ह़मळीन राजा ने घणी रीह लागी। अने तीहयो आह़फा ना सीपायड़ा मोकलीन तीहया हत्‌यारा ने मराय नाख्‌यो अने तीमना ह़ेर ने धपाड़ नाख्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","अळतेण राजो आह़फा ना पावर्‌या ने केदो, “वेवा नी पंगात नी तीयारी ते हय जेली से, पण जीमने नेवतु आपलु हतु, तीहया आना लायक नी बण्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","एतरे वाट ना चोवराया पोर जावो, अने जेतरा बी माणहु जड़ जाय, तीहया आखाम ने वेवा नी पंगात मे बोलाय लावो। ");
INSERT INTO bpx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","अने पावर्‌या रोहा पोर ज्‌या, अने भला अने कुहर्‌या आखा माणहु ने बोलावीन ली आया अने वेवा नो घोर तीहया माणहु सी भराय ज्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","राजो पोरणा ने देखवा करीन आयो, तां तीनी नींगा एक एसवा माणेह पोर पड़ी, जे वेवा ना लुगड़ा नी पेरलो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","तीहयो तीने केदो, भाय वेवा ना लुगड़ा पेर्‌या वगर तु आञे केम आय लाग्‌यो? तीहयो माणेह होगो हय र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तत्‌यार राजो आह़फा ना पावर्‌या ने हुकम आपीन केदो, आना हात अने पोगु बांदीन आने बारथो अंदारला मे नाख देवो। तां तीहया माणहु रड़हे, अने दात ककड़ावहे। ");
INSERT INTO bpx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","काहाके बोलावला ते ढेरेत से, पण टाळला थोड़ाक से। ");
INSERT INTO bpx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तीहयी टेमे फरीसी पंथवाळा जाय्‌न भेळा हय्‌न वीच्‌यार काड्‌या के कीसम ईसु ने हीनी वात मे फसाड़या। ");
INSERT INTO bpx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","पण तीहयो आह़फा ना चेलाम ने हेरोद नी ह़ाते तीनीन्‌तां आहयु केवा मोकल्‌यो, “ए मास्‌तर आमु जाणया के तु खरलो से, अने भगवान नी वाट सच्‌चाय सी ह़ीकाड़े, अने कोय नी परवाय नी करत्‌लो, काहाके तु माणहु नु मोडु देखीन वात नी करत्‌लो। ");
INSERT INTO bpx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","एतरे आमने देखाड़ तु ह़ु सोचे? केसर ने फाळो आपवा वारु से के नी हय।” ");
INSERT INTO bpx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ईसु तीमनी वात जाणीन केदो, “ए ढोंगड़ा करन्‌या, मने काहा पारखो? ");
INSERT INTO bpx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","फाळा नो सीक्‌को मने देखाड़ो।” ता तीहया तीनीन्‌तां एक सीक्‌को लाया। ");
INSERT INTO bpx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","तीहयो तीने पुछ्‌यो, “आहयो छाप अने नाम कोय नु से?” ");
INSERT INTO bpx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","तीहया तीने केदा, “केसर नो।” तत्‌यार तीहयो तीने केदो, “जे केसर नु से, तीहयो केसर ने आपो; अने जे भगवान नु से, तीहयु भगवान ने आपो।” ");
INSERT INTO bpx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","आहयु ह़मळीन तीहया घबराय ज्‌या, अने तीने रेवा दीन जत र्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","तीहया दाड़े सदुकी पंथवाळा जे केता हता के मरला नु पासु जीवणु हयेत नी, तीनी ह़ाते आया अने तीने पुछ्‌या, ");
INSERT INTO bpx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ए मास्‌तर, मुसो केदलो हतो के कदी कोय माणेह वण-अवल्‌यात मर जाय, ता तीनो भाय तीनी लाडी सी वेवा करीन आह़फा ना भाय जुगु सोरा पयदा करे। ");
INSERT INTO bpx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","हाव अमारीन्‌तां ह़ात भाय हता; पेलो वेवा करीन मर ज्‌यो, अने सोरा नी हयवा ना कारण आह़फा नी लाडी ने आह़फा ना भाय नी करते सोड़ ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","आहयी रीते बीजो अने तीसरो बी कर्‌यो, अने ह़ातोव भाय लग आसमेत हयु। ");
INSERT INTO bpx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","आखान बाद मे आखरी मे तीहयी बयर बी मर जी। ");
INSERT INTO bpx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","एतरे पासा जीवता हयवा पोर तीहयी तीहया ह़ातोव भाय मे गेथी कोयनी लाडी हयहे? काहाके तीहयी आखा नी लाडी बणली हती।” ");
INSERT INTO bpx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ईसु तीमने जपाप आप्‌यो, “तमु चोखली सास्‌तर अने भगवान नी सक्‌ती ने नी जाणता; आना कारण सी भुल मे पड़ र्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","काहाके जीवता हयवा पोर वेवा नी हये पण ह़रग मे आखा ह़रगदुत ने तेम रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","पण मरला ने जीवता हयवा ना बारा मे ह़ु तमु आहयो बोल नी भण्‌या जे भगवान तमने केदो: ");
INSERT INTO bpx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘मे अब्‌राहम नो भगवान, अने ईसाक नो भगवान, अने याकुब नो भगवान से?’ तीहयो मरला नो नी, पण जीवता नो भगवान से।” ");
INSERT INTO bpx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","आहयु ह़मळीन माणहु तीनी ह़ीकापण सी घबराय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जत्‌यार फरीसी पंथवाळा आहयु ह़मळ्‌या के ईसु सदुकी ना मोडा बंद कर देदो, ता तीहया एखठा हया। ");
INSERT INTO bpx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","तीमनी मे गेथु एक कायदा पाळवा वाळो तीने पारखवा नी करते तीने पुछ्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ए मास्‌तर कायदा मे कानो हुकम आखा सी मोटो से?” ");
INSERT INTO bpx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","तीहयो तीने केदो, “तु तारा मालीक ने अने भगवान ने पुरा मन अने आह़फा ना पुरा जीव अने आह़फा नी आखी अक्‌कल नी भेळ मोंग कर। ");
INSERT INTO bpx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","आहयो आखा गेथो पेलो अने मोट्‌लो हुकम से। ");
INSERT INTO bpx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","अने तीनीन तेम आहयो बीजो हुकम से के तु आपणा ह़ाते वाळा सी आह़फान तेम मोंग राख। ");
INSERT INTO bpx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","आखा कायदा अने भगवान वगे गेथा केण्‌या माणहु ना कीताप्‌या आहयात बे हुकम पोर टेकला से।” ");
INSERT INTO bpx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जत्‌यार फरीसी पंथवाळा एखठा हता, ता ईसु तीमने पुछ्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसी ना बारा मे तमु ह़ु सोचो? तीहयो कोयनो सोरो से?” तीहया तीने केदा, “दावुद नो।” ");
INSERT INTO bpx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","तीहयो तीने पुछ्‌यो, “ता दावुद आत्‌मा मे हय्‌न हीने मालीक ह़ुका केय? ");
INSERT INTO bpx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘मालीक, मारा मालीक ने केदो, मारी जमणी ह़ोड़ बह, जत्‌यार लग मे तारा वेरी ने तारा पोगु तळे नी कर देम।’ ");
INSERT INTO bpx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","भलु, जत्‌यार दावुद हीने मालीक केय, ता हीय्‌यो हीनो सोरो केम केवायो?” ");
INSERT INTO bpx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","आना जपाप मे कोय बी एक वात नी की सक्‌यो। तीहया दाड़े गेथा कोयने अळतेण तीने कंय पुसवा नी हीम्‌मत नी हयी। ");
INSERT INTO bpx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तीहयी टेमे ईसु माणहु ने अने आह़फा ना चेला ने केदो, ");
INSERT INTO bpx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","चोखली सास्‌तर ह़ीकाड़न्‌या, अने फरीसी पंथवाळा मुसा नी गादी पोर हक लीन बह र्‌या, ");
INSERT INTO bpx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","एतरे तीहया तमने जे कंय बी हुकम आपीन केय, तीहयु करता अने मान्‌ता रेवो; बाखीन तीमनीन तेम काम नी करजो। काहाके हीय्‌या हुकम आपीन केय ते खरा, पण तेम करे नी। ");
INSERT INTO bpx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","तीहया एक भारी बोज ने जीने उचलवा काठु से, हीय्‌या तीने बांदीन माणहु ना खांदा पोर मेल देय, बाखीन आह़फा ते आंगळी बी नी टेकव्‌वा हींडे। ");
INSERT INTO bpx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","हीय्‌या आखा कामु माणहु ने देखाड़वा करीन करे। हीय्‌या देखाड़वा करीनेत आह़फाम ना सास्‌तर ना तावीज चवड़ा करीन बांदे अने आह़फाम ना लुगड़ा ना घुमचा नाम्‌बा कर देय। ");
INSERT INTO bpx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","हीमने पंगात मे पेल्‌नो जागो अने भगवान ना भक्‌ती ना घोर नो पेल्‌नो जागो गमे। ");
INSERT INTO bpx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हाट मे वारु से के अने माणहु अगळ गुरु केवाड़वा हीमने वारु गमे। ");
INSERT INTO bpx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“तमु ‘गुरु’ केवायवा करीन ना हुकारो, काहाके तमारो एकीत गुरु से, अने तमु आखान-आखा भाय से।” ");
INSERT INTO bpx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","धरती पोर वाळा ने कोयने “बाह” नी केजो, काहाके तमारो एकीत बाह से जे ह़रग मे से। ");
INSERT INTO bpx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","तमु “मालीक” बी नी केवाड़जो, काहाके तमारो एकीत मालीक से जे मसी से। ");
INSERT INTO bpx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जे तमारी मे आखान मोटो से, तीहयो आखा नो पावर्‌यो बणे। ");
INSERT INTO bpx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जे आह़फा ने मोटो मानहे, तीने भगवान नानो कर देहे, अने जे आह़फा ने नानो मानहे तीने भगवान मोटो कर देहे। ");
INSERT INTO bpx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ए ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमारी जुगु घणी दुख नी वात से! काहाके तमु ते माणहु ने ह़रग राज मे भरायवा सी रोक र्‌या। तमु आह़फा बी ह़रग राज मे नी भरायो, अने बीजा ने बी ह़रग राज मे नी भरायवा देवो। ");
INSERT INTO bpx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ए ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमु रंडायला बयरा ना घोर मे भराय्‌न तीमने धोको दीन ठग लेय, अने तीमना घोर ने उजाड़ देय, अने बीजा ने देखाड़वा करीन नाम्‌बी-नाम्‌बी घणी वार लग वीन्‌ती करे। एतरे तमने नीयाव नो डंड भगवान वगे गेथो जादात जड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ए ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमारी जुगु घणी दुख नी वात से! काहाके तमु एक जणा ने तमारा पंथ मे लाव्‌वा करीन दर्‌या पार करीन धरती ना बीजा खुणे जावो। अने जत्‌यार तमारा पंथ मे आवीन चेलो बण जाय, ता तीने आह़फा गेथो बी बे गुणा जादा गुनाळ्‌ळो बणाय देय, के तीहयो नरक-आक्‌ठी मे जाय। ");
INSERT INTO bpx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ए आंदळा अगळवाण्‌या! तमारी जुगु घणी दुख नी वात से! काहाके तमु केवो, “कदीम कोय भगवान ना मंदीर नी ह़ाम खाय, ता तीनी कंय नी खरी हय, पण कदीम कोय मंदीर ना ह़ोना नी ह़ाम खाय, ता तीनी वात खरली उतरी जाय।” ");
INSERT INTO bpx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ए वण-अकल्‌या आंदळा! कोय मोटु से? ह़ोनु मोटु के तीहयो भगवान नो मंदीर मोटो से? जीनी सी ह़ोनु चोखलु हय जाय? ");
INSERT INTO bpx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","तमु आहयु बी केवो, “कदीम कोय वेदी नी ह़ाम खाय, ता तीनी कंय नी खरी हय, पण कदीम तीहयो वेदी पोर मेल्‌ली भेट नी ह़ाम खाय, ता तीनी खरी उतरी जाय।” ");
INSERT INTO bpx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ए आंदळा! कोय मोटु से? भेट मोटी से के तीहयी वेदी मोटी से? जीनी सी भेट चोखी हय जाय? ");
INSERT INTO bpx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","एतरे खास वात आहयी से के, जे वेदी नी ह़ाम खाय, तीहयो ते वेदी पोर मेकायलु चीज नी बी ह़ाम खाय केवाये। ");
INSERT INTO bpx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","अने जे भगवान ना मंदीर नी ह़ाम खाय, तीहयी ते भगवान नी बी ह़ाम खाय केवाये, जे आह़फा ना मंदीर मे रेय। ");
INSERT INTO bpx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","अने जे ह़रग नी ह़ाम खाय, तीहयो भगवान नी राजगादी नी अने तीहयी राजगादी पोर बहण्‌या नी बी ह़ाम खाय केवाये। ");
INSERT INTO bpx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ए ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमारी जुगु घणी दुख नी वात से! काहाके तमु पुदीना नो, सोप नो अने जीरु नो दसवो वाटो ते भगवान ने आपो, बाखीन मुसा नी लारे लीखली सास्‌तर नी खास वात ने सोड़ देदा; होव, नीयाव, दया, अने भरहा नी खास वात ने टाळ देदा। तमु दसवो वाटो ते आप्‌या करजो, पण नीयाव नी, गीण नी, अने भरहा नी खास वात ने बी पाळ्‌यात करवा जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ए आंदळा अगळवाण्‌या! तमु मीचर्‌या ने ते झारो, बाखीन उटड़ा ने ते गळ जावो। ");
INSERT INTO bpx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमारी जुगु घणी दुख नी वात से! काहाके तमु वाटका ने अने थाळ्‌या ने उपर-उपर ते वारु उजाळे, बाखीन मोय गेथा नी उजाळे, तेमेत तमारु मन हाय अने आह़फात नु भलु करवा ना वीच्‌यार सी भराय्‌लु से। ");
INSERT INTO bpx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ए आंदळा फरीसी पंथवाळा! पेले वाटका ने मोय गेथा उजाळ लेवो, ता उपर बी उजळी जहे। ");
INSERT INTO bpx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमारी जुगु घणी दुख नी वात से! काहाके जेम तमु ते मड़ाट्‌या ह़रका से जे उपर-उपर चुना वेर पोताय करलु रेय, अने घटाळु देखाये, पण मोय मरला माणहु ना हाटका अने ह़ड़लु माह भरायलु रेय। ");
INSERT INTO bpx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ईसम तमु बी उपर गेथा माणहु ने धरमी देखाव पड़ो, बाखीन तमारा मन मे दगो अने कुहराय भरायली से। ");
INSERT INTO bpx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ए ढोंगड़ा करन्‌या चोखली सास्‌तर ह़ीकाड़न्‌या अने फरीसी पंथवाळा! तमारी जुगु घणी दुख नी वात से! काहाके तमु भगवान वगे गेथा केण्‌या माणहु ना मड़ाट्‌या ह़जाड़े, अने धरमी माणहु ना गाता बणावे। ");
INSERT INTO bpx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अने केवो, “कदीम आमु अमारा आड़ा-बुड़ा नी टेमे जीवत्‌ला हता, ता आमु भगवान वगे गेथा केण्‌या माणहु नु खुन नी करवा करीन अमारा डाह-डाहा ने सात नी देता।” ");
INSERT INTO bpx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ईसम कीन तमु आह़फाम नीत वीरोद मे आहयी गवा दी र्‌या के “आमु तीहया माणहु नी अवल्‌यात से, जे भगवान वगे गेथा केण्‌या माणहु नु खुन करला हता।” ");
INSERT INTO bpx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","एतरे तमु तमारा आड़ा-बुड़ा ना पाप नी कसर पुरी कर लेवो। ");
INSERT INTO bpx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ए गड़हा अने जेहर वाळा गड़हा ना बच्‌चा! तमु नरक कुंड ना डंड सी कीकम बचहु? ");
INSERT INTO bpx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","देखो! मे तमारीन्‌तां भगवान वगे गेथा केण्‌या माणेह ने, अक्‌कल वाळा ने, अने मास्‌तर्‌याम ने मोकलु। तमु तीमनी मे गेथा थोड़ाक ने मार नाखहु अने थोड़ाक ने कुरुस पोर चड़ावहु, अने थोड़ाक ने भगवान ना भक्‌ती ना घोर मे ह़ड़काटह़ु अने तीमने एक ह़ेर गेथा बीजा ह़ेर वेला पाड़ता फीरहु। ");
INSERT INTO bpx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","करीन धरती पोर जेतरा बी धरमी माणहु नु खुन हयु, तीहयु खुन तमारा माथे पड़हे। धरमी हाबील नु खुन गेथु लीन बीरीक्‌या ना बेटा जकर्‌याह ना खुन लग, जीने तमु भगवान ना मंदीर अने वेदी नी वच मे मार नाखला हता। ");
INSERT INTO bpx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मे तमने ह़ाचलीन केम, आहयु आखु आहयी पीड़ी ना माथे पड़हे अने आमनेत डंड भुगतवा पड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ए यरुसलेम! ए यरुसलेम! तु भगवान वगे गेथा केण्‌या माणहु ने मार नाखे अने जे माणहु ने भगवान तारीन्‌तां मोकले तीमने बी दगड़ाटीन मार नाखे। जेम कुकड़ी आह़फी ना पीच्‌या ने आह़फी ना पाखड़ा तळे भेळा कर लेय, तेमेत मे ढेरेत कावा तारी अवल्‌यात ने मारा पाखड़ा तळे भेळा करवा हींडतो हतो, पण तमु मारो नकारो कर देदा। ");
INSERT INTO bpx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देखो, भगवान तमारा यरुसलेम ना मंदीर ने सोड़ देहे, अने तीहयो ठारलो हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","मे तने केम, हमणे गेथा तमु मने जत्‌यार लग नी देखो, जत्‌यार लग तमु आहयु नी केय, “जुगाळो से तीहयो, जे मालीक भगवान ना नाम सी आवे।” ");
INSERT INTO bpx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ईसु मंदीर सी नीकळीन जवा बाज र्‌यो हतो ता तीना चेला मंदीर नी बणावट ने देखाड़वा करीन तीनी ह़ाते आया। ");
INSERT INTO bpx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","पण ईसु तीमने केदो, तमु आने ह़ुदा उबा हय रेला देख र्‌या? पण मे तमने ह़ाचलीन केम, आञे ह़ारीक आहया मंदीर ना दगड़ा पोर दगड़ो बी नी रेय। आहयु आखु ओदार नाखहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जत्‌यार ईसु जेतुन बड़ा पोर पुगीन बह ज्‌यो, ता चेला एक धेड़े ईसु ह़ाते आवीन केदा, आमने देखाड़, आहयु आखु कत्‌यार हयहे? अने तारी आव्‌वा नी अने कळजुग खत्‌तम हयवा नी सेलाणी ह़ु रेहे? ");
INSERT INTO bpx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ईसु तीमने जपाप आप्‌यो, चेतीन रेवो। कोय तमने धोको नी दी देय। ");
INSERT INTO bpx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","काहाके घणा माणहु मारु नाम लीन आवह़े अने केहे, “मेत मसी से, अने तीहया घणा ढेरका माणहु ने भटकाड़ देहे।” ");
INSERT INTO bpx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तमु लड़ाय अने झगड़ा नो हुकवाड़ो ह़मळह़ु। आहयी वात ह़मळीन तमु घबरायजो नी, काहाके ईसम ते हयहेन-हयहे। पण तीहयी टेमे खत्‌तम नी हये। ");
INSERT INTO bpx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","आखी जाती ना माणहु आंबा-सांबा झगड़ो करवा करीन हुहड़ीन जहे। एक राज्‌य ना माणहु बीजा राज्‌य ना माणहु भणी झुमायवा जहे। जां तां काळ पड़हे। अने जां तां भुकम्‌प हयहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","आहयु आखु आव्‌वा वाळी गरा नी सुरुवात से। ");
INSERT INTO bpx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","मारा नाम नी करते आखी जाती ना माणहु तमारी सी ह़ीगी करहे, अने तीहयी टेमे माणहु तमने वेला पड़ाव्‌वा करीन धरावह़े अने तीहया तमने मार नाखहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तीहयी टेमे घणा ढेरका माणहु मार पोर गेथो भरहो सोड़ देहे। अने तीहया एक-बीजा ने धरावह़े, अने एक-बीजा सी ह़ीगी करहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","अने ढेरेत झुटा भगवान वगे गेथा केण्‌या माणहु आय लागहे। अने घणा ढेरका माणहु ने भगवान ना भरहा गेथा सेटा कर देहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","पाप करन्‌या वदवा सी घणा ढेरका माणहु नो मोंग टाडो पड़ जहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","बाखीन जे आखरी लग दम धरहे, तीनेत छुटकारो जड़हे। ");
INSERT INTO bpx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","आहयी कळी ना आखी जाती ना माणहु ने खुस-खबर नी गवा राखवा करीन तीमनी मे भगवान ना राज नी आहयी खुस-खबर नु परच्‌यार हयहे, अने अळतेण कळजुग खत्‌तम हयवा नी टेम आय लागहे ");
INSERT INTO bpx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","एतरे जत्‌यार तमु खत्‌तम करवा वाळी चीज ने मंदीर ना चोखला जागा मे उबी हय रेली देखो, जीना बारा मे भगवान वगे गेथो केण्‌यो दानीयल केदलो हतो; भणवा वाळो ह़मजी लेवा जोवे के आनु मतलब ह़ु से? ");
INSERT INTO bpx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ता, तीहयी टेमे जे माणहु युहद्‌या मे हय, तीहया बड़ा पोर नाह जवा जोवे; ");
INSERT INTO bpx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","अने जे घोर नी छत पोर हय, तीहयो आह़फा ना घोर नु ह़मान लेवा हेटो नी उतरवा जोवे; ");
INSERT INTO bpx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","जे खेतर मे हय, तीहयो आह़फा ना लुगड़ा लेवा करीन पासो नी आव्‌वा जोवे। ");
INSERT INTO bpx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","तीहया दाड़ा मे जे बयर भारेपोगे हहे अने सोरु ने धाय धवाड़ती हहे, तीनी जुगु गरा ना दाड़ा केवायहे! ");
INSERT INTO bpx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","वीन्‌ती कर्‌या करो के ह़ीयाळा ना दाड़ा मे, नीता अराम ना दाड़े नाहवा नी पड़े; ");
INSERT INTO bpx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","काहाके तीहयी टेमे घण-जबर गरा आवह़े, भगवान कळ घड़्‌यो तत्‌यार गेथी हजु लग एतरी मोटी गरा नी आवी हय, एतरी मोटी गरा आवह़े। अने अळी एवी गरा कदी नी आवे। ");
INSERT INTO bpx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","कदीम मालीक तीहया दाड़ा ने कम नी करतो, ता एक बी जीव नी बचता; बाखीन टाळला माणहु नी करते जीमने तीहयो टाळलो से, तीहया गरा ना दाड़ा ने तीहयो कम कर देदलो से। ");
INSERT INTO bpx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","तीहयी टेमे कदीम कोय तमने केय, “देखो! मसी आञे से ता तमु भरहो नी करजो।” ");
INSERT INTO bpx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","काहाके झुटा मसी अने भगवान नु नाम लीन झुट मेकण्‌या माणहु देखाव पड़हे, अने एवी भारी सेलाणी अने सेल-भात्‌या कामु देखाड़हे, हय सके ता तीहया टाळला माणहु ने बी भगवान ना भरहा गेथा सेटा करवा नी कोसीत करहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देखो, आहयी आखी वात मे तमने पेले गेथोत की र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","कदीम तीहया तमने केय, देखो, ह़ेलो उजाड़ी बड़ा मे से, ता तमु तां नी जजो; नीता, तीहया केय, “तीहयो आञे ह़ारीक कोपरा मे से, ता भरहो नी करजो।” ");
INSERT INTO bpx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","काहाके जीसम वीजळी उगवणी गेथी नीकळीन बुडवणी लग वीजळे, तेमेत मनख्‌या नो सोरो बी उजन्‌तो आवह़े! ");
INSERT INTO bpx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जां बी धोड़ रेहे, तांत घुवड़्‌या बी भेळा हय जहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","तीहया दाड़ा मे जत्‌यार वेला पड़हे अने अळतेण दाहड़ु काळु पड़ जहे, चांद वीजाळु नी आपे, ह़रगे गेथा तारा हेटा पड़ जहे, अने ह़रग नी ताखत हीलाय देहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तीहयी टेमे ह़रगे गेथा मनख्‌या ना सोरा नी आव्‌वा नी सेलाणी देखाव पड़हे। धरती पोर रेण्‌या आखी जातीन माणहु फुकु-फुकु रड़हे, अने मनख्‌या ना सोरा ने मोटी ताखत भेळ, अने बड़ाय भेळ ह़रग ना वादळा पोर आवत्‌लो देखहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","तीहयो फेपार्‌या वाजा भेळे आह़फा ना ह़रगदुत ने मोकलहे अने तीहया आखी धरती पोर गेथा तीना टाळला माणहु ने भेळा करहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","गुलर ना झाड़ ना दाखला नी लारे कंय ह़ीको। जत्‌यार तीना डाळ्‌या मे कुमळ्‌ळा डीरा फुटवा बाज जाय अने नवला पान्‌टा नीकळवा बाज जाय, ता तमु जाण लेवो के उनाळो आव्‌वा बाज र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","आहयीत रीते जत्‌यार तमु मारी केदली आखी वात हयत्‌ली देखो, ता जाण लेवो के तीहयो ह़ाते से, अने झापलात पोर से। ");
INSERT INTO bpx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","मे तमने ह़ाचलीन केम के आहयी पीड़ी ना माणहु ने खत्‌तम हयवान पेलेत मारी केदली वात पुरी हयहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ह़रग अने धरती टळ जाय, पण मारी वात कदी नी टळे। ");
INSERT INTO bpx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","मनख्‌या ना सोरा नो आव्‌वा नो दाड़ो अने टेम ना बारा मे कोयने मालम नी हय, नीता ह़रगदुत ने अने नीता सोरा ने आहयो दाड़ो अने टेम नीस्‌तो भगवान बाह एतरोत जाणे। ");
INSERT INTO bpx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जीसम नुहा ना दाड़ा मे हयलु हतु, तेमेत मनख्‌या नो सोरो आवह़े, तीहया दाड़े बी हयहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","जे दाड़े तक नुहो मोट्‌ला ढुंड्‌या मे नी भरायो, तांह तक माणहु खाता-पीता, अने वेवा करता हता। ");
INSERT INTO bpx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अने उचकाहलोत पाणी आयो, अने तीहयो आखा ने डुबाड़ीन मार नाख्‌यो, तांह तक आनु कोयने कंय मालम नी पड़्‌यु तेमेत मनख्‌यान सोरा नु आवणु बी रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","तीहयी टेमे बे अदमी खेतर मे हहे, ता एक ने चुट लेहे, अने बीजो री जहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","बे बयरा घट्‌ये दळता हहे, एक जणी ने चुट लेहे, अने बीजी ने रेवा देहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","एतरे जागीन चेतीन रेवो, काहाके तमने नी मालम के तमारो मालीक काना दाड़े आवह़े। ");
INSERT INTO bpx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","आहयु वारु रीते ह़मजी लेवो, कदीम घोर ना मालीक ने मालम रेय के चोट्‌टो राते कानी टेमे आवह़े, ता तीहयो जागलो रेय अने आह़फा ना घोर मे चोरी नी हयवा देय। ");
INSERT INTO bpx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","एतरे तमु बी तीयार रेवो, काहाके जे घड़ी ना बारा मे तमु सोचो बी नी, तीहयी घड़ी मनख्‌या नो सोरो आय लागहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“एवो कोय ईमानदार अने अक्‌कल वाळो, चाकर्‌यो से, जीने तीनो मालीक आह़फा ना घोर ना पावर्‌या नो मुखी बणावे। अने केय के तु मारा पावर्‌या ने टेमे-टेमे खावा-पीवा नी चीज आप्‌या करजे? ");
INSERT INTO bpx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","जुगाळो से तीहयो पावर्‌यो, जीनो मालीक आवे, तत्‌यार तीहयो तीने ह़ोपलु काम करत्‌लो देखे। ");
INSERT INTO bpx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मे तमने ह़ाचलीन केम, तीहयो मालीक तीने, आह़फा ना आखा माल-धन पोर मुखी बणावीन ठेरावहे। ");
INSERT INTO bpx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पण कदीम तीहयो बेमान पावर्‌यो तीना मन मे आहयो वीच्‌यार करे के मारा मालीक नी आव्‌वा मे वार से। ");
INSERT INTO bpx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","करीन तीहयो बीजा ह़ाती पावर्‌या ने ठोकवा, अने बीजा ह़रांग्‌या ह़ाते खाय-पीय। ");
INSERT INTO bpx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ता तीहया पावर्‌या नो मालीक एवा दाड़े आवह़े, जत्‌यार तीहयो तीनी वाट नी जोय र्‌यो हय। अने एवी टेम मे आवह़े, जे तीने मालम नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","अने मालीक तीने घण भारी डंड आपहे, अने ढोंगड़ा करन्‌या ह़ाते भेसकी देहे, अने तीहया तां ह़ारीक फुकु-फुकु रड़हे अने दातु ककड़ावता रेहे।” ");
INSERT INTO bpx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","तीहयी टेमे ह़रग नु राज तीहयी दह़ कुवारी सोरीन तेवु रेहे, जे आह़फा ना दीवा लीन लाडा ने भेटवा करीन जी। ");
INSERT INTO bpx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","तीमनी मेनी पांच वण-अकल्‌याण हती अने पांच ह़मजदार हती। ");
INSERT INTO bpx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","तीहयी पांच वण-अकल्‌याण सोरी दीवा ते लेदी पण दीवा जुगु तेल नी लेदी। ");
INSERT INTO bpx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पण बीजी पांच ह़मजदार सोरी दीवा ह़ाते मग्‌गा मे तेल बी ली लेदी। ");
INSERT INTO bpx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","लाडा ने आव्‌वा मे वार हय जी, ता आखी कुवारी सोरी उंगायवा बाज जी अने ह़ुय जी। ");
INSERT INTO bpx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","अने अळतेण आरदी राते कचाट ह़मळायी, “देखो लाडो आव्‌वा बाज र्‌यो। तीने भेटवा करीन चालो।” ");
INSERT INTO bpx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ता तीहयी आखी कुवारी सोरी उठीन आह़फी ना दीवा ह़च करवा बाज जी। ");
INSERT INTO bpx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","वण-अकल्‌याण, ह़मजदार कुवारी सोरी ने केदी, “तमारा तेल मे गेथु थोड़ुक तेल आमने बी आप देवो, काहाके अमारा दीवा ओलायवा बाज र्‌या।” ");
INSERT INTO bpx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पण ह़मजदार कुवारी सोरी केदी, “कदीम, अमारी अने तमारी जुगु आहयु तेल पुरी नी पड़े। भलु आनीत मे से, के तमु वेचवा वाळान्‌तां जाय्‌न तमारी जुगु तेल वेचातु ली लेवो।” ");
INSERT INTO bpx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","अने तीहया कुवार्‌या सोर्‌या तेल लेवा जवात बाज र्‌या हता अने नवलो लाडो आय लाग्‌यो। तीहयीत टेमे जे तीयार हती, तीहयी तीनी ह़ाते वेवा वाळा घोर मे जत री, अने झापला दी देदा। ");
INSERT INTO bpx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","आनी बाद तीहया बीजा कुवार्‌या सोर्‌या बी आवीन केदा, “मालीक! ए मालीक! अमारी जुगु बी झापलु उगाड़ दे।” ");
INSERT INTO bpx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ता नवलो लाडो जपाप आप्‌यो, “मे तमने ह़ाचलीन केम, मे तमने नी जाणु।” ");
INSERT INTO bpx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","एतरे चेतीन रेवो, काहाके तमने मनख्‌या ना सोरा नी आव्‌वा नी टेम अने दाड़ो मालम नी हय। ");
INSERT INTO bpx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ह़रग राज तीहया माणेह ह़रकु से, जे पारका देस मे जवा नी टेमे आह़फा ना पावर्‌या ने बोलायो अने तीमने आह़फा नु धन ह़ोप देदो। ");
INSERT INTO bpx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","अने तीहयो एक पावर्‌या ने पांच हजार ह़ोना ना सीक्‌का, बीजा ने बे हजार ह़ोना ना सीक्‌का अने तीसरा ने एक हजार ह़ोना ना सीक्‌का आप्‌यो। मतलब आखा ने तीमनी ताखत देखीन आप देदो, अळतेण तीहयो पारका देस मे जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","जीने पांच हजार रुप्‌या आपला हता, तीहयो तत्‌यारुत जाय्‌न तीहया पय्‌हा नु लेणु-देणु कर्‌यो अने अळी पांच हजार रुप्‌या कमाय लेदो। ");
INSERT INTO bpx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","एमेत जीने बे हजार ह़ोना ना सीक्‌का आपला हता, तीहयो बी अळी बे हजार ह़ोना ना सीक्‌का कमाय लेदो। ");
INSERT INTO bpx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पण जीने एक हजार ह़ोना ना सीक्‌का आपला हता, तीहयो ज्‌यो, अने कादु मे खाडो खोदीन आह़फा ना मालीक ना ह़ोना ना सीक्‌का ह़ताड़ देदो। ");
INSERT INTO bpx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ढेरेत दाड़ा वीत ज्‌या अने अळतेण तीहया पावर्‌या नो मालीक पासो आवीन तीमनी पांह हीसाब लेवा बाज ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जीने पांच हजार ह़ोना ना सीक्‌का आप्‌या हता, तीहयो अळी पांच हजार कमाय्‌न लावीन केदो, “मालीक! तु मने पांच हजार ह़ोना ना सीक्‌का आपलो। देख, मे अळी पांच हजार ह़ोना ना सीक्‌का कमाय लायो।” ");
INSERT INTO bpx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","तीनो मालीक तीने केदो, “घणु वारु, भला अने भरहा लायक पावर्‌या! तु थोड़ुक मे भरहा लायक र्‌यो, मे तने ढेरकी चीज पोर हक आपही। तारा मालीक नी खुसी मे साजल्‌यो बण।” ");
INSERT INTO bpx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","अने जीने बे हजार ह़ोना ना सीक्‌का आपला हता। तीहयो केदो, “ए मालीक तु मने बे हजार ह़ोना ना सीक्‌का आपलो। देख, मे अळी बे हजार कमाय लायो।” ");
INSERT INTO bpx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","तीनो मालीक तीने केदो, “घणु वारु, भला अने भरहा लायक पावर्‌या! तु थोड़ुक मे भरहा लायक रेलो से, मे तने ढेरकी चीज पोर हक आपही। तारा मालीक नी खुसी मे साजल्‌यो बण।” ");
INSERT INTO bpx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तत्‌यार तीहयो आयो, जीने एक हजार रुप्‌या आपला हता। तीहयो केदो, “मालीक! मने मालम से के तु घणो वातड़ो से। तु जां नी वेर्‌यो, तां वाडे, अने जां नी छाट्‌यो, तां तु ह़ेमटे। ");
INSERT INTO bpx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","एतरे मे बीह ज्‌यो, अने जाय्‌न तारा रुप्‌या ने कादा मे डाटीन ह़ताड़ देदो, अने देख, आहया तारा ह़ोना ना सीक्‌का से, अने आहया पासा ली ले।” ");
INSERT INTO bpx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","तीनो मालीक तीने केदो, “ए वेरी अने ओगज्‌या पावर्‌या! तने मालम हतु के ‘मे जां नी वेर्‌यो, तां वाडु, अने जां नी छाट्‌यो, तां मे ह़ेमटु।’” ");
INSERT INTO bpx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ता तने मारु धन ह़ोवकार्‌यान तां ली जाय्‌न आप देवा हतु, ता मे पासो आवीन वीयाज भेळ मांग लेतो। ");
INSERT INTO bpx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","एतरे आहया एक हजार ह़ोना ना सीक्‌का आनी पांह गेथा मांग लेवो, अने जीनी पांह दह़ हजार ह़ोना ना सीक्‌का से, तीने आप देवो; ");
INSERT INTO bpx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","काहाके जीनी पांह कंय से, तीनेत अळी आपहे, अने तीनी पांह ढेरेत हय जहे; पण जीनी पांह कंय बी नी हय, तीनी पांह गेथु जे बी से तीहयु बी ली लेहे। ");
INSERT INTO bpx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","अने आहया रीकामा पावर्‌या ने बारथु ना अंदारला मे नाख देवो। तां ह़ारीक रड़वा अने दातु ककड़ाव्‌वा नु रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","जत्‌यार मनख्‌या नो सोरो आह़फा बड़ाय भेळ आवह़े, अने आखा ह़रगदुत तीनी ह़ाते आवहे ता तीहयो आह़फा नी बड़ाय नी राजगादी पोर बहलो रेहे। ");
INSERT INTO bpx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","अने आखा देस ना माणहु तीनी अगळ भेळा करहे। जीसम गुवाळ्‌यो गाडरा ने बोकड़ा मे गेथो अलग करे, तेमेत तीहयो आखा माणहु ने एक-बीजा गेथो अलग करहे। ");
INSERT INTO bpx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","तीहयो गाडरा ने आह़फा नी जमणी धेड़े अने बोकड़ा ने डाखरी धेड़े उबा करहे। ");
INSERT INTO bpx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ता राजो आह़फा ना जमणी धेड़े वाळा माणहु ने केहे, “ए मारा बाह ना जुगाळा माणहु! आवो, अने तीहया राज ना हकदार्‌या बणो, जे सुरु गेथु तमारी करते तीयार करलु से; ");
INSERT INTO bpx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","काहाके मे भुकलो हतो, अने तमु मने खवाड़्‌या; मे तरहेलो हतो, अने तमु मने पाणी पीवाड़ला; मे अंजाणो हतो, अने तमु मने तमारा घोर राख्‌या; ");
INSERT INTO bpx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मे नांगरलो हतो, अने तमु मने लुगड़ा पेराया मे मांदलो हतो, अने तमु मारा खबर्‌या आया; मे जेल मे हतो, अने तमु मने मळवा आया।” ");
INSERT INTO bpx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","आहयी वात ह़मळीन तीहया धरमी माणहु मालीक ने केहे, “ए मालीक! आमु कत्‌यार तने भुकलो देखला, अने खवाड़ला? कत्‌यार तरहेलो देखला, अने पाणी पीवाड़ला? ");
INSERT INTO bpx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","आमु कत्‌यार तने अंजाणो देखला अने अमारीन्‌तां राख्‌या? अने कत्‌यार नांगरलो देखला अने लुगड़ा पेरावला? ");
INSERT INTO bpx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","कत्‌यार तने मांदलो अने जेल मे देखला अने मळवा आवला?” ");
INSERT INTO bpx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","आहयु ह़मळीन राजो आहयो जपाप आपहे, “मे तमने ह़ाचलीन केम, तमु मारा आहया भायु मे काना नान्‌ला भाय जुगु बी, जे कंय कर्‌या, तीहयु मारी जुगु करला से।” ");
INSERT INTO bpx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ता तीहयो आह़फा ना डाखरी धेड़े वाळा माणहु ने केहे, ‘ए खोड़ला! मारीन्‌तां गेथा सेटा हय जावो। तीहयी जलमकी आक्‌ठी मे जावो, जे भुतड़ा जुगु ने तीना दुतु जुगु तीयार करलो से; ");
INSERT INTO bpx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","काहाके मे भुकलो हतो, अने तमु मने खाणु नी खवाड़्‌या; मे तरहेलो हतो, अने तमु मने पाणी नी पीवाड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मे अंजाणो हतो, अने तमु मने तमारीन्‌तां नी राख्‌या; मे नांगरलो हतो, अने तमु अने लुगड़ा नी पेराया, मे मांदलो हतो, अने तमु मारा खबर्‌या नी आया, मे जेल मे हतो अने तमु मने मळवा नी आया।’ ");
INSERT INTO bpx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","तत्‌यार तीहया बी तीने पुसहे, ‘मालीक! आमु कत्‌यार तने भुकलो, तरहेलो, अंजाणो, नांगरलो, मांदलो अने जेल मे कुंडायलो देखला अने तारी चाकरी नी कर्‌या?’” ");
INSERT INTO bpx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ता तीहयो तीमने जपाप आपहे, “मे तमने ह़ाचलीन केम, जे कंय तमु मारा आहया नान्‌ला गेथा बी नान्‌ला मेना एक जुगु बी नी कर्‌या, तीहयु मारी जुगु बी नी कर्‌या मुजुक से। ");
INSERT INTO bpx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","अने ईसम करीन आहया वेरी ने जलमको डंड जड़हे, पण धरमी ने अमरकाय जीवाय जड़हे।” ");
INSERT INTO bpx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","अने ईसु आखी वात कीदीन आह़फा ना चेला ने केदो, ");
INSERT INTO bpx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तमु जाणो के बे दाड़ान बाद फसह नो तीवार से। ता मनख्‌या ना सोरा ने कुरुस पोर चड़ावीन मारवा करीन माणहु धराय देहे।” ");
INSERT INTO bpx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तीहयी टेमे डायला पुंजारा अने डायला पुडारी केफा नाम ना डायला पुंजारा नी हवेली मे भेळा हया। ");
INSERT INTO bpx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अने तीहया आसम करीन वीच्‌यार कर्‌या के आमु केम करीन ईसु ने धराय्‌न मराय नाखीया। ");
INSERT INTO bpx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पण तीहया केता के “तीवार ना दाड़े आसम नी करवा जोवे, कंखर आसम नी हय जाय के आखा माणहु दंगो फसात करे।” ");
INSERT INTO bpx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जत्‌यार ईसु बेतन्‌या मे सीमोन कुड़ावा ना घोर मे हतो, ");
INSERT INTO bpx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ता एक बयर मोगला दगड़ा नी ह़ीही मे घण मोगलु ईत्‌तर लीन आयी। अने ईसु खाणु खावा बह र्‌यो हतो, ता ईसु ना मुंडा पोर रेड़ देदी। ");
INSERT INTO bpx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","आहयु देखीन ईसु ना चेला रीहवाय्‌न केदा, “आहयु ईत्‌तर ने उदड़ेत काहा बगाड़ देदी? ");
INSERT INTO bpx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","आहयु ईत्‌तर घणु मोगु वेचातु, अने जे रुप्‌या आवता तीहया रुप्‌या ने गरीब मे वाट देती ता वारु रेतु।” ");
INSERT INTO bpx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ईसु आहयु जाणीन, चेला ने केदो, “तमु आहयी बयर ने काहा दम र्‌या? आहयी मारी वाटु भलु काम करली से। ");
INSERT INTO bpx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब ते जलम तमारी ह़ाते रेहे, पण मे जलम तमारी ह़ाते नी री सकु। ");
INSERT INTO bpx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","आहयी मारा डील पोर जे ईत्‌तर रेड़ली से तीहयी मने गाड़वा करीन तीयार करली से। ");
INSERT INTO bpx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","मे तमने ह़ाचलीन केम, आखी कळी मे जां-जां मारी खुस-खबर ने परच्‌यार करहे, तां आहयी बयर नी फोम मे, आना काम ने बी नामलहे।” ");
INSERT INTO bpx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","अळतेण ईसु ना बारे चेला मेनो एक जणो, जीनु नाम यहुदा ईस्‌करीयोती हतु, तीहयो डायला पुंजारान तां ज्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","अने तीहयो केदो, “कदीम मे ईसु ने तमारा हात मे धराय देम, ता तमु मने ह़ु आपह़ु? तीहया तीने चांदी ना तीस रुप्‌या गणीन आप देदा।” ");
INSERT INTO bpx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","तीहयी टेमे गेथो यहुदा ईस्‌करयोती ईसु ने धराव्‌वा नो वारु मोखो ह़ोदतो र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","पण खमीर वगर ना रोट्‌ला ना तीवार ना पेल्‌ना दाड़े, ईसु ना चेला ईसु ने आवीन केदा, “तु फसह तीवार नु खाणु कां ह़ारो खावा हींड र्‌यो? तां ह़रा आमु जीया, तने तारी जुगु फसह ना तीवार नु खाणु तीयार करया?” ");
INSERT INTO bpx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","अने ईसु केदो, “ह़ेर मे तीहया अदमीन्‌तां जावो, अने तीने केवो, ‘मास्‌तर आहयु की र्‌यो के मारी टेमे ह़ाते आय जेली से, मे मारा चेला ह़ाते तारा घोर फसह तीवार नु खाणु खाही।’” ");
INSERT INTO bpx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","अने ईसु ना चेला जेम ईसु केदो, तेम कर्‌या, अने फसह ना तीवार नु खाणु तीयार कर्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","अने ह़ांती टेमे ईसु बारे चेला ह़ाते खाणु खावा बह्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","अने खाणु खावा नी टेमे ईसु तीमने केदो, “मे तमने ह़ाचलीन केम, तमारी मेनो एक जणो मने धोको दीन धराय देहे।” ");
INSERT INTO bpx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","अने तीहया चेला घणा ह़ोह़वाय ज्‌या। अने तीमनी मेना एक-एक जणो ईसु ने पुसवा बाज ज्‌या, “ए मालीक! ह़ु तीहयो मे से?” ");
INSERT INTO bpx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","तत्‌यार ईसु केदो, “जे मारी ह़ाते एक थाळी मे खाणु खाय तीहयो मने धोका सी धरावहे। ");
INSERT INTO bpx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मनख्‌या ना सोरा ने ते जवानुत से जेम तीना बारा मे लीखलु से; पण तीहया माणेह जुगु घणी दुख नी वात से, जे मनख्‌या ना सोरा ने धरायो! तीहयो माणेह पयदा नी हयतो ता वारु रेतु।” ");
INSERT INTO bpx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ता तीने धराव्‌वा वाळो यहुदा ईसु ने पुछ्‌यो, “ए मास्‌तर! तीहयो मे ते नी हय ह़ु? मे से?” ईसु तीने केदो, “होव, ह़ाचलीन तु की देदलो से।” ");
INSERT INTO bpx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जत्‌यार तीहया खाणु, खावा बाज र्‌या हता, ता ईसु हात मे रोट्‌लो धर्‌यो, अने रोट्‌ला जुगु तु घणो वारु से कीन रोट्‌लो भांगीन आह़फा ना चेला ने आप्‌तो जाय्‌न केदो, “लेवो, आहया रोट्‌ला ने खाय लेवो, आहयो रोट्‌लो मारु डील से।” ");
INSERT INTO bpx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","अळतेण ईसु पीयालो हात मे धरीन घणो वारु से कीन चेला ने आहयु केतो जाय्‌न आप्‌यो, “तमु आखा आनी मे गेथु पीवो। ");
INSERT INTO bpx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","काहाके आहयो पीयालो मारा वायदा नु लोय से, जे आखा माणहु ना पाप नी माफी नी लेदे वयवा वाळु से। ");
INSERT INTO bpx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मे तमने केम, हमणे गेथो जत्‌यार लग मारा बाह ना राज मे तमारी ह़ाते नवला अंगुर नो रोह नी पी लेम, तांह तक मे आहयु अंगुर नु नवलु रोह कदी नी पीम।” ");
INSERT INTO bpx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","अळतेण तीहया फसह तीवार नु भजन गावीन जेतुन ना बड़ा पोर जत र्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तीहयी टेमे ईसु तीमने केदो, “आज रातेत तमारो आखा नो भरहो मार पोर नी रेय। काहाके खरली सास्‌तर मे आहयु लीखलु से: मे गुवाळ्‌या ने मार नाखही, अने गाडरा नो टोळो रीवण्‌या-तीवण्‌या हय जहे, ");
INSERT INTO bpx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पण मे पासो जीवतो हय्‌न अळतेण तमारी गेथो पेले गलील जीला मे जत रेही।” ");
INSERT INTO bpx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","एतरा मे पतरस ईसु ने केदो, “भले, आखा तार पोर गेथा भरहो सोड़ देय, पण मे कदी नी सोड़ु।” ");
INSERT INTO bpx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ईसु पतरस ने केदो, “मे तने ह़ाचलीन केम, आहयीत राते, कुकड़ो वाहवान पेले, तु मने तीन काव नीकारो करही।” ");
INSERT INTO bpx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस अळी ईसु ने केदो, “कदीम तारी ह़ाते मने भले मरवा बी पड़े, ते बी मे तारो नीकारो नी करु।” अने आखा चेला हेमेत केदा। ");
INSERT INTO bpx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","जत्‌यार ईसु चेला ह़ाते गतसमनी नाम नी वाड़ी मे आयो, ता तीहयो आह़फा ना चेला ने केदो, “जत्‌यार लग मे ह़ेले जाय्‌न वीन्‌ती करीन पासो नी आवु, तत्‌यार लग तमु आञेत बहजो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","अळतेण ईसु पतरस ने अने जब्‌दी ना बे सोरा ने ह़ाते ली ज्‌यो, अने तीहयो ह़ोह़वाय्‌न अने घबरायवा बाज ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","अळतेण ईसु तीमने केदो, “मारो मन घण-जबर दुखी से, अने मारो जीव नीकळवा हींडे; तमु आञे रेवो, अने मारी ह़ाते चेतीन रीन जागला रेवो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ईसु थोड़ोक अगो जाय्‌न अळतेण तीहयो धरती पोर ढुंगो वळीन वीन्‌ती कर्‌यो, “ए मारा बाह! कदीम तारी मरजी हय, ता आहयो दुख नो पीयालो टाळ दे। ते बी मारी नी पण तारीत मरजी पुरी हये।” ");
INSERT INTO bpx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","अळतेण तीहयो आह़फा ना चेलान तां ज्‌यो, अने तीमने ह़ुवत्‌ला देख्‌यो। अने पतरस ने केदो, “तमने मारी ह़ाते एक घंटो बी नी जगायु ह़ु? ");
INSERT INTO bpx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागला रेवो अने वीन्‌ती करता रेवो, आनीन करते के तमु पारख मे नी पड़ो: आत्‌मा ते तीयार से, पण डील कमजोर से।” ");
INSERT INTO bpx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ईसु एक कावा अळी, जाय्‌न, आहयी वीन्‌ती कर्‌यो, “ए मारा बाह! कदीम आहयो पीयालो मारा पीया वगर नी टळे, ता तारीत मरजी पुरी हये।” ");
INSERT INTO bpx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","अळतेण ईसु अळी पासो आयो, ता तीहयो अळी आह़फा ना चेला ने ह़ुवत्‌ला देख्‌यो, काहाके तीहया नींदरायला हता। ");
INSERT INTO bpx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","तीहयो तीमने सोड़ीन अळी वीन्‌ती करवा ज्‌यो, अने वीन्‌ती ना तीहयात बोलु कीन तीसरी कावा वीन्‌ती कर्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","अळतेण ईसु आह़फा ना चेलान्‌तां आवीन तीमने केदो, “तमु हजु लग ह़ुवीन अरामेत करवा बाज र्‌या ह़ु? देखो! हाव तीहयी टेम आय जेली से, जत्‌यार मनख्‌या नो सोरो पापी माणहु ना हात मे ह़ोप देहे। ");
INSERT INTO bpx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठो! आपणु जीया, देखो, मने धोको दीन धराव्‌वा वाळो ह़ातेत आव्‌वा बाज र्‌यो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ईसु आहयु केवात बाज र्‌यो हतो के बारे चेला मेनो एक जणो, जीनु नाम यहुदा ईस्‌करीयोती हतु, तीहयो आय लाग्‌यो। तीनी ह़ाते ढेरेत माणहु तलवार्‌या अने डींगा लीन आय लाग्‌या। जीमने डायला पुंजारा अने डायला पुडार्‌या मोकल्‌ला हता। ");
INSERT INTO bpx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ईसु ने धोको दीन धराव्‌वा वाळो यहुदा तीमने आहयु कीन सेलाणी आपलो हतो, “मे जीने कुको देही, तीहयोत ईसु से। तीने धर लेजो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","अळतेण तीहयो यहुदा ईसुन्‌तां आवीन केदो, “ए मास्‌तर! वारलो से के?” अने तीहयो ईसु ने कुको देदो। ");
INSERT INTO bpx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ईसु तीने केदो, “दोस्‌तीदार! जे कामे तु आवलो से, तीहयु काम कर ले।” ता तीहया माणहु अगा आया, अने ईसु ने चपटीन धर लेदा। ");
INSERT INTO bpx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","अने एतरात मे ईसु ना ह़ाती मेनो एक जणो आह़फा नी तलवार मीयान मे गेथी नीकाळीन डायला पुंजारा ना पावर्‌यो नो झाटको दीन कान्‌टो तोड़ नाख्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तत्‌यार ईसु तीने केदो, “तलवार मीयान मे पासी घाल ले, काहाके जे तलवार्‌ये करीन बीजा माणहु ने झटकावे तीहया तलवार्‌ये सी मर जहे। ");
INSERT INTO bpx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","तमने आहयी वात ह़मज नी आवती ह़ु, के मे मारा बाह सी वीन्‌ती करही ता, तीहयो ह़रगदुत ना बारे टोळा गेथा बी जादा टोळा मोकली देहे? ");
INSERT INTO bpx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पण कदीम मे आसम वीन्‌ती करीन ह़रगदुत बोलाय लेही ता खरली सास्‌तर मे लीखली वात केम पुरी हयहे?” ");
INSERT INTO bpx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तीहयीत टेमे ईसु माणहु ने केदो, “तमु मने डाकु ह़मजीन, तलवार्‌या अने डींगा लीन मने धरवा आय र्‌या ह़ु? मे ते दाड़ीनेत मंदीर मे बहीन ह़ीकापण आप्‌या करतलो, तीहयी टेमे तमु मने काहा नी धर्‌या? ");
INSERT INTO bpx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","आहयु आखु आनीन करते हयु र्‌यु के भगवान वगे गेथा केण्‌या माणहु नी लारे जे बी केदलु हतु तीहयु आखु पुरु हय जाय।” अळतेण आखा चेला ईसु ने रेवा दीन नाह पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","अने ईसु ने धराव्‌वा वाळा, तीने धरीन डायला पुंजारा केफान तां, जां ह़रा डायला पुडारी अने चोखली सास्‌तर ह़ीकाड़न्‌या भेळा हय र्‌या हता। ");
INSERT INTO bpx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","अने पतरस बी थोड़ोक सेटो रीन ईसुन पसळ-पसळ आयो अने डायला पुंजारा ना घोर ना आंगणा मे ज्‌यो, अने ईसु ह़ाते हयत्‌लु तीहयु देखवा करीन रखवाळ्‌या पावर्‌या ह़ाते बह ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","डायला पुंजारा अने मोट्‌ली पंचु ना माणहु मेळीन ईसु ना वीरोद मे वाक काडीन मारवा करीन झुटा गवा ह़ोद र्‌या हता। ");
INSERT INTO bpx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पण तीमने ईसु नो वाक नी नीकळ्‌यो। भले झुटा गवा अगा आवीन झुटी गवा देदा। आखरी मे बे जणा अगा आया ");
INSERT INTO bpx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","अने केदा, “आहयो अदमी केदलो, ‘मे भगवान ना मंदीर ने ओदार देही, अने तीन दाड़ा मे तीने अळी उबो कर देही।’” ");
INSERT INTO bpx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","अळतेण डायलो पुंजारो उबो हय्‌न ईसु ने केदो, “आहया माणहु तारा वीरोद मे आहयी गवाय दी र्‌या, तीमना वीरोद मे कंय नी केणु हय ह़ु?” ");
INSERT INTO bpx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पण ईसु होगो हय र्‌यो। अळतेण डायलो पुंजारो ईसु ने केदो, “जीवत्‌ला भगवान नी तने आण घालु कदीम तु भगवान नो सोरो मसी हय, ता आमने कीदे।” ");
INSERT INTO bpx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ईसु केदो, “होव, तु केदो तेमेत से। मे तमने आहयु बी केम, हाव गेथा तमु नीस्‌ता मनख्‌या ना सोरा ने आखा मे जोरभर्‌या भगवान ना जमणी धेड़े बह रेलो अने ह़रग ना वादळा पोर आवत्‌लो देखहु।” ");
INSERT INTO bpx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","एतरु ह़मळीन डायलो पुंजारो आह़फा ना लुगड़ा फाड़ीन केदो, “आहयो भगवान नो वाक काडलो से। ता आमने गवा नु काम नी हय? हमणेत तमु आहया ईसु ने भगवान नो जबराण वाक काडत्‌लो ह़मळला से। ");
INSERT INTO bpx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तमु आखा नो ह़ु वीच्‌यार से?” तीहया केदा, “आहयो मोत नो डंड आपे एवो से।” ");
INSERT INTO bpx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","अळतेण तीहया ईसु ना मोडा पोर थुप्‌या अने तीने ढीक देदा, अने थोड़ाक माणहु तीने थपड़ाट्‌या, ");
INSERT INTO bpx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","अने आहयु केदा “ए मसी! कदीम तु भगवान वगे गेथी वात केण्‌यो माणेह हय, ता आमने कीदे के तने कोय देदु?” ");
INSERT INTO bpx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","अने पतरस तीहयी टेमे बारथो आंगणा मे बह र्‌यो हतो। अने एक पावर्‌याण सोरी ह़ाते आवीन तीने केदी, “तु बी गलील वाळा ईसु ह़ाते हतो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","पण पतरस आखा अगळ ईसु नो नीकारो करतो जाय्‌न केदो, “तु ह़ु केवा बाज री मे नी जाणतो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","अळतेण पतरस झापला नी पयड़ी भणी ज्‌यो, पण एक अळी बीजी पावर्‌याण तीने देखी अने तां ह़ारीक उबा हय रेला माणहु ने केदी, “आहयो अदमी बी ईसु नासरी ह़ाते हतो।” ");
INSERT INTO bpx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","एक काव अळी पतरस नीकारो कर्‌यो अने आण घालीन केदो, “मे हीय्‌या अदमी ने जाणु लग नी।” ");
INSERT INTO bpx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","अने थोड़ीक वार मे तां उबा हय रेला माणहु पतरस ने तां जाय्‌न केदा, “ह़ाचलीन, तु बी तीमनी मेनो एक जणो से; काहाके तारी बोली चोखीझण उजन्‌तो कर देय के तु तांत वाळो से।” ");
INSERT INTO bpx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","आहयी वात ह़मळीन पतरस भलु भुंडु कीन ह़ाम खाय्‌न केवा बाज ज्‌यो, “मे हीय्‌या अदमी ने जाणु लग नी।” अने तेतरी घड़ी कुकड़ो वाह देदो। ");
INSERT INTO bpx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","अने तत्‌यार पतरस ने ईसु जे केदलो तीहयु फोम आयु, “कुकड़ो वाहवान पेले तु मारो तीन कावा नीकारो करही।” अने तीहयो बारथो नीकळीन पुकु-पुकु रड़वा बाज ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ह़वारे वेगात डायला पुंजारा अने माणहु ना डायला पुडारी आखा मेळीन ईसु ने मार नाखवा नी योजना बणाया। ");
INSERT INTO bpx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","अने अळतेण तीहया ईसु ने बांदीन ली ज्‌या अने डायला अदीकारी पीलातुस ना हात मे ह़ोप देदा। ");
INSERT INTO bpx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जत्‌यार ईसु ने धराव्‌वा वाळो यहुदा आहयु देख्‌यो के तीहया ईसु ने गुनाळ्‌ळो ठेरावीन डंड आप देदा, ता यहुदा ने घणो दुख लाग्‌यो, अने तीहयो डायला पुंजारान्‌तां अने पुडार्‌यान्‌तां चांदी ना तीस रुप्‌या पासा आपवा ज्‌यो, ");
INSERT INTO bpx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","अने तीहयो केदो, “मे वण-गुनाळ्‌ळा माणेह ने मार नाखवा करीन धरावीन पाप करलो से।” पण तीहया माणहु केदा, “आमु ह़ु करया! हीय्‌यी वात तुत देख ले।” ");
INSERT INTO bpx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","आहयु ह़मळीन यहुदा चांदी ना सीक्‌का मंदीर मे नाख देदो अने जाय्‌न गळा मे दोड़ु बांदीन टंगाय्‌न मर ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","डायला पुंजारा चांदी ना रुप्‌या चुटीन केदा, “आहया रुप्‌या ने खजाना मे मेकवा वारु नी हय, आहया ते लोय ना दाम से।” ");
INSERT INTO bpx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","एतरे तीहया वीच्‌यार काड्‌या अने अळतेण तीहया रुप्‌या नो, माणहु ने गाड़वा करीन कुमायड़ा नु खेतर वेचातु ली लेदा। ");
INSERT INTO bpx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","एतरे तीहयो खेतर आज लग लोय नो खेतर केवाये। ");
INSERT INTO bpx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","आहयी रीते यीरम्‌या, भगवान वगे गेथो वात केण्‌या नो आहयो बोल पुरो हयो: “तीहया चांदी ना तीस रुप्‌या लीन ज्‌या, आहया रुप्‌या ईस्‌रायल ना माणहु आपवा करीन बोली करला हता। ");
INSERT INTO bpx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","अने जेम मालीक मने हुकम आपलो हतो तीनात अनसारे तीहया रुप्‌या आपीन कुमायड़ा नु खेतर वेचातु ली लेदा।” ");
INSERT INTO bpx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ईसु हाव रोमी अदीकारी पीलातुस अगळ उबो हय र्‌यो हतो। रोमी अदीकारी तीने पुछ्‌यो, “तु युहदी नो राजा से ह़ु?” ईसु केदो, “होव, जेम तु केदो तेमेत से।” ");
INSERT INTO bpx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","जत्‌यार डायला पुंजारा अने डायला पुडारी तीना पोर गुनो लगाड़ता हता, ता ईसु तीमने कंय नी केदो। ");
INSERT INTO bpx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","तत्‌यार पीलातुस ईसु ने पुछ्‌यो, “तने नी ह़मळायतु ह़ु के आहया तार पोर केतरा गुना लगाड़ र्‌या?” ");
INSERT INTO bpx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ते बी ईसु जपाप मे एक बोल बी नी केदो। आनीन करते रोमी अदीकारी घण-जबर वहराय ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","फसह ना तीवार ना दाड़े अदीकारी नी आहयी रीती हती के तीहयो आहया तीवार पोर काना बी एक केदड़ा ने माणहु नी मरजी नी अनसारे जेल मे गेथा छोड़्‌या करतो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","तीहयी टेमे तां ह़ारो एक बरब्‌बा नाम नो एक डामीस केदड़ो जेल मे हतो। ");
INSERT INTO bpx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","एतरे पीलातुस भेळा हय रेला माणहु ने केदो, “तमने ह़ु जोवे? मे तमारी जुगु कोयने सोड़ देम? बरब्‌बा ने के मसी केवायवा वाळा ईसु ने सोड़ु?” ");
INSERT INTO bpx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","पीलातुस ने मालम हतु, के तीहया ईसु मसी ने कुहराये धरावला से। ");
INSERT INTO bpx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","पीलातुस जत्‌यार नीयाव नी गादी पोर बह र्‌यो हतो ता तीनी घोरवाळी तीने आहयी खबर की मोकली, “हीय्‌या धरमी माणेह ने कंय बी डंड नी आप्‌जे, काहाके हीनात कारण सी मने आज राते ह़पना मे घणी वेला झेलवा पड़ली से।” ");
INSERT INTO bpx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","पण डायला पुंजारा अने डायला पुडारी माणहु ने मनवी लेदा के तमु पीलातुस ने केवो के तु बरब्‌बा ने सोड़ दे अने ईसु ने मराय नाख। ");
INSERT INTO bpx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","अदीकारी पीलातुस अळी तीमने पुछ्‌यो, “तमने ह़ु जोवे? मे आहया बे जणा मेना ने कोयने सोड़ देम?” तीहया केदा, “बरब्‌बा ने सोड़ दे।” ");
INSERT INTO bpx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","एतरे पीलातुस तीमने केदो, “ता मे ईसु नु ह़ु करु, जे मसी केवाये?” आखा की पड़्‌या, “ईने कुरुस पोर चड़ावो।” ");
INSERT INTO bpx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पण पीलातुस पुछ्‌यो, “काहा? हीय्‌यो कानो गुनो करलो से?” बाखीन तीहया अळी बी ज्‌योरे आड़ीन केदा, “ईने कुरुस पोर चड़ावो।” ");
INSERT INTO bpx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","पीलातुस आहयु देख्‌यो के आहया मारी वात नी ह़मळता अने उल्‌टो दंगो हय र्‌यो, ता तीहयो पाणी मांगीन माणहु अगळ हात धोयो अने केदो, “मे आहया धरमी माणेह ना लोय नो गुनाळ्‌ळो नी हय। आहयी वात ने तमुत जाणो।” ");
INSERT INTO bpx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","अने आखा माणहु जपाप आप्‌या, “आनु लोय वयाड़वा नो गुनो अमारी पोर, अने अमारी अवल्‌यात पोर पड़वा दे!” ");
INSERT INTO bpx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","अळतेण पीलातुस तीमनी जुगु बरब्‌बा ने सोड़ देदा, अने ईसु ने चपका दीन कुरुस पोर चड़ावो करीन सीपायड़ा ना हात मे ह़ोप देदो। ");
INSERT INTO bpx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","अळतेण रोमी अदीकारी पीलातुस ना सीपायड़ा ईसु ने हवेली ना आंगणा मे ली जाय्‌न तीनीन्‌तां आखा सीपायड़ा ना टोळा भेळा कर लेदा। ");
INSERT INTO bpx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","तीहया तीना लुगड़ा काडीन तीने रात्‌लु नाब्‌लु डगलु पेराया, ");
INSERT INTO bpx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","अने काटा वाळा झाटवा नु मुळ्‌यु गुथीन तीना मुंडा पोर मेल्‌या, अने तीना जमणा हात मे वाहण नी ह़ोटी धराय देदा। अने तीहया तीनी अगळ मांडा टेकीन आहयु केता जाय्‌न तीनी हाही उडाड़ता जीन केदा, “ए युहदी ना राजा वारलो से के!” ");
INSERT INTO bpx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","अने तीहया तीना मोडा पोर थुप्‌या अने तीना हात मे वाळी वाहण नी ह़ोटी तीना मुंडा पोर देता ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","अळतेण तीहया तीनी हाही कर चुक्‌या ता तीहया तीनु नाब्‌लु डगलु नीकाळ देदा अने तीने तीनात लुगड़ा पेराया अने तीने कुरुस पोर चड़ाव्‌वा करीन ली ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","जत्‌यार तीहया ह़ेर मे गेथा नीकळीन जवा बाज र्‌या हता, ता तीमने कुरेनी गाम मे रेण्‌यो सीमोन नाम नो एक माणेह भेट्‌यो। अने तीहया तीने ईसु नु कुरुस जोर करीन उचलाड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","तीहया गुलगुता नाम ना जागे पुग्‌या, जीनु मतलब से, “माणहु ना खोपड़ी नो जागो।” ");
INSERT INTO bpx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","तां तीहया माणहु ईसु ने कड़वलु भेसकायलु अंगुर नो रोह पीवा आप्‌या। तीहयो तीहया रोह ने चाखी ते लेदो, पण पीवा सी मना कर देदो। ");
INSERT INTO bpx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तत्‌यार तीहया ईसु ने कुरुस पोर चड़ाया, अने चीट्‌ठ्‌या नाखीन तीना लुगड़ा वाट लेदा। ");
INSERT INTO bpx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","अळतेण तीहया तां बहीन ईसु नो पहरो देवा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","अने तीहया ईसु ना मुंडा गेथी उपर कुरुस पोर गुनो लीखीन एक चीट्‌ठी ठोक देदा, के आहयु युहद्‌या नो राजा मसी से। ");
INSERT INTO bpx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तीहया ईसु ह़ाते बे चोट्‌टा ने बी कुरुस पोर चड़ाया, एक ने तीना जमणी धेड़े अने एक ने तीना डाखरी धेड़े चड़ाया। ");
INSERT INTO bpx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","अने तां माय्‌न आव्‌वा अने जवा वाळा माणहु मुंडु हीलावीन तीनी हाही उडाड़ता हता अने तीनो वाक काड्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","अने ईसम केता हता, “ए मंदीर ने ह़ुदारवा वाळा अने तीन दाड़ा मे तीने पासो बणाव्‌वा वाळा। कदी तु भगवान नो बेटो हय ता, आह़फा ने बचाड़, अने कुरुस पोर गेथो उतरीन आव।” ");
INSERT INTO bpx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","आहयी रीते, डायला पुंजारा बी चोखली सास्‌तर ह़ीकाड़न्‌या अने डायला पुडारी ह़ाते, ईसम केता जाय्‌न तीनी हाही उडाड़ता हता, ");
INSERT INTO bpx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“हीय्‌यो बीजा ने बचाड़्‌यो, पण आह़फा ने नी बचाड़ सक्‌यो। आहयो ते ईस्‌रायली माणहु नो राजा से। हाव कुरुस पोर गेथो उतरीन आव, ता आमु आनी पोर भरहो करहु। ");
INSERT INTO bpx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","आहयो भगवान पोर भरहो करे। कदीम भगवान हीने छुटकारो आपवा हींडतो हय, ता हीने सोड़ाय ले। काहाके आहयो केदलो हतो, ‘मे भगवान नो सोरो से।’” ");
INSERT INTO bpx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","आड़े-धेड़े कुरुस पोर चड़ावला डाकु बी आहयी रीते वाक काडीन हाही उडाड़ता हता। ");
INSERT INTO bpx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","माथे दाड़े सी मांजणीक दाड़े लग आखा देस मे अंदारु सवायलु र्‌यु। ");
INSERT INTO bpx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","मांजणीक दाड़े ईसु ज्‌योरेत आड़ीन केदो, “एली! एली! लमा सबक्‌तनी?” आनु मतलब “ए मारा भगवान, ए मारा भगवान, तु मने काहा सोड़ देदो?” ");
INSERT INTO bpx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जे तां उबा रेवा वाळा माणहु मे सी थोड़ाक आहयु ह़मळीन केवा बाज ज्‌या, आहयो ते एलीया ने आड़वा बाज र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","अने तीमनी मे गेथो एक ममार दवड़्‌यो, अने पोतु ने लीन अंगुर ना कड़वला रोह मे डुबाड़्‌यो अने वाहण ना टोकरा पोर मेलीन तीने चुहाड़्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","थोड़ाक माणहु केदा, रेवा दे! देखजे हीने एलीयो बचाड़वा आवे के नी आवे। ");
INSERT INTO bpx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","अने अळतेण ईसु ज्‌योरेत आड़्‌यो अने जीव सोड़ देदो। ");
INSERT INTO bpx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","तीहयी टेमे मंदीर नो पड़दो उपर गेथो हेटो लग, फाटीन बे ठेपाड़ा हय ज्‌यो, धरती हील जी अने चाफर्‌या फाट ज्‌या ");
INSERT INTO bpx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","अने तीहयी टेमे मड़ाट्‌या लग उगड़ी ज्‌या, अने भगवान ना मरला चोखला माणहु ना धोड़ु पासा जीवता हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","अने तीहया मड़ाट्‌या मे गेथा नकळी आया अने ईसु ने जीवतो हयवान अळतेण यरुसलेम ना चोखला ह़ेर मे जाय्‌न ढेरेत माणहु ने देखाव पड़्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","सुबेदार अने तीनी ह़ाते ईसु नो पेहरो देण्‌या सीपायड़ा धरती हीलीन धदड़नु अने जे कंय हयु तीहयु आखु देखीन घण-जबर बीही ज्‌या, अने की पड़्‌या, ह़ाचलीन! आहयो भगवान नो सोरो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","तां ढेरेत बयरा बी उबा हय र्‌या हता। तीहया ईसु नी सेवा-चाकरी करवा करीन गलील जीला मे गेथा तीमनी ह़ाते-ह़ाते आवला हता। ");
INSERT INTO bpx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","तीमनी मे मरीयम मगदलीनी, याकुब अने युसुफ नी आय्‌ह मरीयम, अने जब्‌दी ना सोरा नी आय्‌ह हती। ");
INSERT INTO bpx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ह़ांती टेमे अरीमीतीया ह़ेर नो एक मालदार अदमी आयो। तीनु नाम युसुफ हतु, अने तीहयु बी ईसु नो चेलो बण जेलो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","तीहयो पीलातुस नी तां जाय्‌न ईसु नो धोड़ मांग्‌यो, अने पीलातुस हुकम आप्‌यो के धोड़ युसुफ ने आप देवो। ");
INSERT INTO bpx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","युसुफ ईसु नो धोड़ ली ज्‌यो, अने तीना धोड़ ने एक धोळ्‌ला लुगड़ा मे लपट्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","अने आह़फा जुगु चाफर्‌या मे खोदाड़ीन बणावला मड़ाट्‌या मे तीहया धोड़ ने मेक देदो, अने तीहयो चाफर्‌या ना मड़ाट्‌या ना झापला पोर मोट्‌लो दगड़ो ढबळावीन जत र्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरीयम मगदलीनी अने बीजी मरीयम तां मड़ाट्‌या अगळ बही री हती। ");
INSERT INTO bpx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","अराम ना दाड़ा नी तीयारी ना बीजा दाड़े डायला पुंजारा अने फरीसी पंथवाळा भेळा हय्‌न पीलातुस नी तां ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","अने केदा, “ए मालीक! आमने फोम से के तीहयो धोको देवा वाळो जत्‌यार जीवत्‌लो हतो, ता केदलो हतो के ‘मे तीसरे दाड़े अळी पासो जीवतो हय जही।’ ");
INSERT INTO bpx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","एतरे तीन दाड़ा लग मड़ाट्‌या नी रखवाळी करवा नो हुकम आप। कदीम ईसम नी हय जाय, के तीना चेला हीने चोरी करीन लीत्‌ती रेय, अने माणहु सी केय के ईसु मरला मे गेथो पासो जीवतो हय ज्‌यो। आहयो पासलो धोको ते पेल्‌ना धोका गेथो बी जादा रद्‌दी हयहे।” ");
INSERT INTO bpx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पीलातुस केदो, “पहरो देण्‌या सीपायड़ा ने ली जावो, अने जीसम तमने ह़मज मे आवे तेमेत मड़ाट्‌या नी रखवाळी करजो।” ");
INSERT INTO bpx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तीहया ज्‌या अने मड़ाट्‌या ना झापला पोर लागला दगड़ा पोर सील लगाड़ देदा। अने मड़ाट्‌या नी रखवाळी करवा बाज ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","अराम ना दाड़ान बाद हप्‌ता ना दाड़े परगड़ फाटतेत मरीयम मगदलीनी अने बीजी मरीयम मड़ाट्‌या ने देखवा आयी। ");
INSERT INTO bpx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","अने देखो, धरती हीली, काहाके मालीक नो एक दुत ह़रगे गेथो उतर्‌यो अने ह़ाते आवीन तीहयो दगड़ा ने ढबळाय देदो, अने तीनी पोर बह ज्‌यो। ");
INSERT INTO bpx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","तीनो रुप वीजळीन तेम अने तीना लुगड़ा बरप ने तेम धोळा हता। ");
INSERT INTO bpx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","तीना बीक सी झापले पेहरो देण्‌या काप उठ्‌या, अने मरला ह़रका हय ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ह़रगदुत बयराम ने केदो, “ना बीहो, मे जाणु के तमु ईसु ने जे कुरुस पोर चड़ावला तीने ह़ोदवा बाज री ");
INSERT INTO bpx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","तीहयो आञे नी हय, पण आह़फा बोलु नी अनसारे जीवतो हयलो से। आवो, आहयो जागो देखो, जां ईसु मालीक ने मेकला हतो, ");
INSERT INTO bpx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अने ममार जाय्‌न तीमना चेलाम ने केवो के तीहयो मरला मे गेथो पासो जीवतो हय जेलो से, अने तीहयो तमारी गेथो पेले गलील मे जत र्‌यो, तां तीने देखहु! देखो, मे तमने देखाड़ देदो।” ");
INSERT INTO bpx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","अने तीहया बीक अने मोटी खुसी ह़ाते मड़ाट्‌या मे सी ममार पासी आवीन तीमना चेलाम ने खबर आपवा दवड़ी पड़ी। ");
INSERT INTO bpx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तत्‌यार ईसु तीमने भेट्‌यो। अने केदो, “सुखी रेवो” तीहया ह़ाते आवीन अने तीना पोग धरीन तीने वांद्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तत्‌यार ईसु तीमने केदो, “ना बीहो; मारा भायु सी जाय्‌न केवो के गलील मे जत रेय तां मने देख्‌हु।” ");
INSERT INTO bpx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","तीहयी जवात बाज री हती के पेहरो देण्‌या मे गेथा थोड़ाक माणहु ह़ेर मे आवीन आखी वात डायला पुंजारा ने ह़मळाया। ");
INSERT INTO bpx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तत्‌यार तीहया डायला पुडारी नी ह़ाते भेळा हय्‌न वीच्‌यारीन अने सीपायड़ा ने ढेरका चांदी ना सीक्‌का आप्‌या, ");
INSERT INTO bpx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","अने केदा, “आहयु केजो के राते जत्‌यार आमु ह़ुव्‌वा बाज रेला हता, तत्‌यार ईसु ना चेला आवीन तीना धोड़ ने चोरी कर ली ज्‌या। ");
INSERT INTO bpx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","अने आहयी वात मुखी-डायला ना कान्‌टा लग पुग जहे, ता आमु तीने ह़मजाड़ लेहु अने तने फीकर करवा सी बचाड़ लेहु।” ");
INSERT INTO bpx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","तीहया रुप्‌या लीन जेम ह़ीकाड़ला हता, तेमेत कर्‌या। आहयी वात आज लग युहद्‌या मे चाल री। ");
INSERT INTO bpx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ग्‌यारे चेला गलील मे तीहया बड़ा पोर ज्‌या, जीने ईसु तीमने देखाड़लो हतो। ");
INSERT INTO bpx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","जत्‌यार तीहया ईसु ने देख्‌या ता तीनी भक्‌ती कर्‌या। पण कोय-कोय ना मन मे सण्‌का हयी। ");
INSERT INTO bpx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ईसु तीमनी ह़ाते आवीन केदो, “ह़रग अने धरती नो आखो हक मने आपलो से। ");
INSERT INTO bpx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","आनीन करीन तमु जावो, आखा राज्‌य ना माणहु ने चेला बणावो; अने तीमने बाह, अने सोरा, अने चोखली आत्‌मा नी नाम सी बपतीस्‌मा आपो, ");
INSERT INTO bpx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","अने तीमने आखी वातु जे मे तमने हुकम आप्‌लो से, मानवा ह़ीकाड़ो: अने देखो, मे कळी ना आकरी लग सदा तमारी ह़ाते से।”");
ALTER TABLE bpx_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
