﻿USE sofia;
DROP TABLE IF EXISTS sofia.bps_vpl;
CREATE TABLE bps_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bps_vpl WRITE;
INSERT INTO bps_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Di katbuan, Dwata mimò langit na banwe. ");
INSERT INTO bps_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","I banwe ani landè fa too bawehan, du landè fa déén. Na di klamang i mahin too kmifu, na too mgal nus mdà di Tulus Dwata, mbal di tah i mahin ani. ");
INSERT INTO bps_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na di bang ani, mdek Dwata, manan, “Ani too nun lwa.” Na tamalwa nan. ");
INSERT INTO bps_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Di kite Dwata i lwa, lehew kenen. Kafnge én, santanin i lwa di kifu. ");
INSERT INTO bps_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Na dnagitan i lwa dunan “mduh”, na dnagitan i kifu dunan “butang”. Na mlius i butang na mlius i mduh, na tafnge i tnanin duh. ");
INSERT INTO bps_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kafnge én, mdek Dwata, manan, “Ani banlenggu di gutngà, fye nun yéél di tah i banwe, na nun di dungan.” ");
INSERT INTO bps_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","8","Di kagmanan ani gasil mgimò. Na i bleng nimoan ani dnagitan “langit”. Na langit i samtani i yéél di tahan na i yéél di dunganan. Na mlius i butang, na mlius i mduh, na tafnge i galwen duh. ");
INSERT INTO bps_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kafnge én, mdek Dwata, manan, “Ani mastifun i yéél dungan i langit, du fye nun gukafagan.” Di kagmanan ani gasil mgimò. ");
INSERT INTO bps_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Na dnagitan i gukafag ani dunan, “tanà”, na dnagitan i yéél tamastifun dunan, “mahin”. Di kite Dwata i mgimoan, lehew kenen. ");
INSERT INTO bps_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kafnge én, mdek Dwata, manan, “Ani dee bung dad tmabò di tah tanà na dee bung kayu. Na kdee di dale munge fye lêman tmabò.” Di kagmanan ani gasil mgimò. ");
INSERT INTO bps_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Na dee bung tmabò na dee bung dad kayu nun bunge lamnok di tah tanà. Di kite Dwata i mgimoan, lehew kenen. ");
INSERT INTO bps_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Na mlius i butang, na mlius i mduh, na tafnge i gatlun duh. ");
INSERT INTO bps_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kafnge én, mdek Dwata, manan, “Ani nun dad mneng msut di langit, du fye samtani i mduh di butang. Én i mlé ilè gugmadè i dad duh, na i dad fali, na i dad bang mangamfù di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Na dad mneng ani i msut di langit, du mneng na mlé kalwa di tanà.” Di kagmanan ani gasil mgimò. ");
INSERT INTO bps_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Na nimoan lwe malbang too mneng. Nimoan i duh, du mneng di mduh na nimoan i bulen du mneng di butang. Na nimoan i dad blatik. ");
INSERT INTO bps_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kdee ani fkah Dwata di langit du fye mlé kalwa di tanà. ");
INSERT INTO bps_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Én i gal mneng di mduh na butang, du fye mastani i lwa di kifu. Di kite Dwata i mgimoan, lehew kenen. ");
INSERT INTO bps_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Na mlius i butang, na mlius i mduh, na tafnge i gfatan duh. ");
INSERT INTO bps_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kafnge én, mdek Dwata, manan “Ani nun dee bung mnè di lam i mahin na di yéél, na nun dee bung dad anuk di bnas mayeng di tah i tanà.” ");
INSERT INTO bps_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Taman tamgimò Dwata i dad malbang, na dee dademe bung mnè di lam i mahin na di yéél, na dee bung dad anuk di bnas. Di kite Dwata i mgimoan, lehew kenen. ");
INSERT INTO bps_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Na nun kafye blén di kdee dad mgimoan ani, na manan di dad nalaf, “Mbel gamu, du fye mbaling gamu dee di klamang i mahin na yéél. Na manan di dad anuk di bnas, mbel gamu di klamang tanà.” ");
INSERT INTO bps_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Na mlius i butang, na mlius i mduh, na tafnge i glimen duh. ");
INSERT INTO bps_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kafnge én, man Dwata, “Ani nun dee bung lmanaf mnè di tah tanà, i dad lmanaf mnalam, na nun mlayal, na dad malbang, na dad malnak lmanaf.” Di kagmanan ani gasil mgimò. ");
INSERT INTO bps_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Na tamgimò Dwata kdee dad lmanaf ani gine. Di kiten i mgimoan, lehew kenen. ");
INSERT INTO bps_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kafnge én, man Dwata, “Ani mimò agu i dad to salngad i deg kagkah. Na fdatahgu ale di dad nalaf di mahin, di dad anuk di bnas, di kdee dad lmanaf, dad mnalam na dad mlayal, dad malbang na dad malnak. Na i dad to ani i magot kadang i kdee tamgimògu.” ");
INSERT INTO bps_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Taman tanimò Dwata i dad to. Nimoan ale salngad i kenen kagkah. Na tanimoan ale lagi na libun. ");
INSERT INTO bps_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kafnge én, nun kafye blén di dale, na manan, “Mbel gamu, du fye nun dad belyu mnè na mebe i klamang tanà. Gamu sa fagotgu i dad nalaf di mahin na yéél, na dad anuk di bnas gal mayeng, na i dad kdee dad lmanaf i mnè di tah i tanà, dad mnalam na dad mlayal.” ");
INSERT INTO bps_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Lêman talù Dwata, manan, “Blégu gamu kdee dad tmabò di tanà, na i kdee dad kayu nun bunge, du fye nun knaanyu. ");
INSERT INTO bps_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Lêman blégu di dad lmanaf na di dad anuk di bnas, i dad sabat na i dad doon i dad kayu, du fye nun knaan i kdee dad mnè di tah i tanà.” Di kagmanan ani gasil mgimò. ");
INSERT INTO bps_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Di kite Dwata i kdee mgimoan, too kenen lehew. Na mlius i butang, na mlius i mduh, na tafnge i gnaman duh. ");
INSERT INTO bps_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ani gine i kfagu Dwata di kgimoan i langit, i klamang banwe na i dad kdee i fkahan di mgimoan ani. ");
INSERT INTO bps_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na di kakel i gfitun duh, tatlag Dwata mimò, du tafnge i kdee mgimoan. ");
INSERT INTO bps_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Taman nun kafye gmanan gablà di gfitun duh, manan, “Nimògu duh ani too mabtas.” Gmanan ani, du i duh ani tatlag di kdee nimoan. ");
INSERT INTO bps_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Én sa i santulen gablà di kgimò Dwata i langit na i banwe. Di kimò Dwata i Amu, i langit na banwe, ");
INSERT INTO bps_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","landè fa fule tmabò di tanà, du là fa fulen Dwata i Amu, na landè fa to mimò di tanà. ");
INSERT INTO bps_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kabay balù landè ulen, tanun yéél tambul di lam i tanà du fye fafê i klamang tanà. ");
INSERT INTO bps_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kafnge én, mwè Dwata i Amu tanà, du nimoan to mdà di tanà ani. Kafnge én, nyufan i ilung i to ani, na gasil lamnawa, na tamto. ");
INSERT INTO bps_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kafnge én, tanun tukay banwe i gunun dad kayu, i nimò Dwata i Amu, gsen di gusut i duh dnagit Idén. Na ditù gufnean i to tanimoan. ");
INSERT INTO bps_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Na falnok Dwata i Amu, dee bung kayu déén. Too fye baweh dad kayu ani na i dad bungela too fye knaan. Na di gutngà i dad fule, tafule Dwata lwe kayu, satu kayu én, mlé nawa landè sen, na i satu, mlé gnadè gablà ku tan i fye na tan i sasè. ");
INSERT INTO bps_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Na nun satu yéél di Idén ani, maloh na myéél i dad fule déén. Mdà di Idén, yéél ani dee syatan, du masatngà di fat, na mbaling fat yéél. ");
INSERT INTO bps_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","I tnanin yéél dnagit Fison, na maloh salu di klamang banwe Habila. ");
INSERT INTO bps_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dini di banwe ani gumite i too glut blawen, na i fye bun litak di kayu, na dad batu mabtas. ");
INSERT INTO bps_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dagit i galwe yéél dunan Gihon, na maloh di klamang banwe dnagit Kus. ");
INSERT INTO bps_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na i gatlu yéél, dunan Tigris, maloh salu di gsen di gusut i duh di banwe dnagit Asirya. Na Yufratis i dagit i gfat yéél. ");
INSERT INTO bps_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Na dini di tukay banwe gunun kayu nimò Dwata, dnagit Idén, gufnean i to tamgimoan, du fye mimò kenen di tanà na mifat i dad fule déén. ");
INSERT INTO bps_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Na flalò Dwata i Amu i to ani, manan, “Fakay ge kmaan i bunge kdee dad kayu di gumneam ani, ");
INSERT INTO bps_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bay nang ge kmaan i bunge i kayu mlé gnadé gablà ku tan i fye na tan i sasè. Du ku kmaan ge i bungen, too ge mati.” ");
INSERT INTO bps_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Na lêman talù Dwata i Amu, manan, “Là sa fye ku i to aloan satu mnè. Taman mimò agu i demen salngad kenen, du fye nun tmabeng kenen.” ");
INSERT INTO bps_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kafnge én, nebe Dwata i Amu di to tamgimoan i kdee dad lmanaf, i kdee dad anuk di bnas, na i kdee dad tamgimoan mdà di tanà, du fimoan kenen dagitla. Na balù tan i dagitan i kat satu dad mto ani, én i dagitan. ");
INSERT INTO bps_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Na i to ani i mimò dagit i kdee bung lmanaf, na dad anuk di bnas. Kabay landè di dale blà kenen du nimò demen. ");
INSERT INTO bps_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Taman fkudang Dwata i Amu, i to ani, na too fye kakudangan laan falus tamwan, na klon kudang nwè Dwata i satu lohokan. Na kafngen sansuléan i ungad di gumwean i lohok to ani. ");
INSERT INTO bps_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na mdà di lohokan ani, nimò Dwata i Amu satu libun, na neben i libun ani di lagi. ");
INSERT INTO bps_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na man i lagi, “Kenen tagablà demegu, du i tulanan fdu di deg tulan, na i ungadan fdu di deg ungad, dnagitgu kenen libun, du mgimò mdà di lagi.” ");
INSERT INTO bps_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Na ani i duen i lagi tmagak i maan na yéan, na mbaling satu di yaanan, na i lwe ani mgimò satu. ");
INSERT INTO bps_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Balù flaweh i lagi na libun ani, là ale sa myà. ");
INSERT INTO bps_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na di kdee dad mlayal lmanaf mgimò Dwata i Amu, i ulad i too fulung mgaw. Taman satu duh man i ulad di libun, “Too glut kè, fnang gamu Dwata kmaan i balù tan bunge di dad kayu di dad fule ani?” ");
INSERT INTO bps_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Na tmimel i libun di ulad, manan, “Fakay gami sa kmaan bunge i dad kayu ani. ");
INSERT INTO bps_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kabay man Dwata nun satu kayu di gutngà i dad fule ani, i bungen làmi fakay knaan, na fnangan gami magot i bungen, du ku ani nimòmi mati gami.” ");
INSERT INTO bps_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kabay man i ulad, “Bong là, là gamu sa mati. ");
INSERT INTO bps_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Én gman Dwata di gamu, du gadean ku kmaan gamu bunge i kayu atù, mbaling gamu fulung faldam, na mbaling gamu salngad kenen, du balù gamu gmadè ku tan i fye na ku tan i sasè.” ");
INSERT INTO bps_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kafnge én, di kite i libun i bunge i kayu én too gablà knaan, na too fye bawehan, na fandaman fye ku mbaling kenen fulung faldam, taman nlifoan bunge i kayu én na knaanan. Na blén i dademe di yaanan, na knaanan. ");
INSERT INTO bps_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Di kakaanla bunge i kayu én, mbaling ale fulung faldam, na dilèla ale flaweh. Taman mwè ale dad doon i kayu fig, na nilolla na labédla di lawehla. ");
INSERT INTO bps_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Di fan kasdaf i duh lingela lduk i Amula Dwata magu di lam dad fule. Taman salbuni ale di lam i dad kayu. ");
INSERT INTO bps_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kabay Amula Dwata, tlon i lagi, manan, “Tanè ge?” ");
INSERT INTO bps_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Na tmimel i lagi, manan, “Lingegu i ldukam magu di lam i dad fule ani, na too agu likò, du flaweh agu, taman salbuni agu.” ");
INSERT INTO bps_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Na snalek Dwata kenen, manan, “Simto kè mangman flaweh ge? Kmaan ge kè bunge i kayu fnangta ge?” ");
INSERT INTO bps_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Na tmimel i lagi, manan, “I libun blém di deg, kenen sa mlé deg bunge i kayu én, na knaangu.” ");
INSERT INTO bps_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Na Amula Dwata, snalekan i libun, manan, “Tan kè i duenam mimò ani?” Tmimel i libun, manan, “Hae, du fangaw agu i ulad, taman gamkaan agu.” ");
INSERT INTO bps_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Taman man Dwata i Amu di ulad, “Fanlayamta ge du mdà di sasè nimoam ani. Di kdee dad lmanaf, i dad mnalam, na i dad mlayal, alò ge magu di kaflayam ani. Mdà ani, fulu ge di tanà, na too ge kmaan kfung di tanà kel di kfatim. ");
INSERT INTO bps_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Sanduengu gamu, ge na i libun, na i dad belan, na i dad belam, na mbaling gamu snang nawa kel di atuan. I belan ndakan kadang i ulum, na nakétam i takadan.” ");
INSERT INTO bps_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Na man Dwata di libun, “Tananùgu i kaflayamam fagu di ksut i dad ngaam. Di ksut i dad ngaam, too sasè katduk i lyom. Kabay balù fa ani i kaflayamam, knean là mgili i knayeam di yaanam. Na yaanam i mebe ge.” ");
INSERT INTO bps_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Na manan di lagi dnagit ku Adam, “Du flinge ge di yaanam, na kmaan ge bunge i kayu i fnangta ge, i tanà ani fakufgu di kaflayam. Kel di kfatim, too ge fgal mimò di tanà, du fye nun gablà knaanyu. ");
INSERT INTO bps_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Na dad samfinit na dademe sabat nun sual gal tmabò na lamnok di tanà. Na toom fanngabal kadang dademe kakaanyu i dad tmabò di bnas. ");
INSERT INTO bps_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Too ge fadlug mimò kel di kaloh i tum, du fye i dad fulem di tanà tmabò na lamnok, na ani i nimoam kel di kasfuléam di tanà i gufdum. Hae, du mgimò ge mdà di tanà, na kadang satu duh lêman ge sa mbaling tanà.” ");
INSERT INTO bps_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Di kagman Dwata kdee ani gine, dnagit Adam i yaanan, dunan Iba, du kenen mbaling yê di kdee dad to. ");
INSERT INTO bps_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Na mimò Dwata i Amu klaweh ale Adam na Iba mdà di kindal i dad lmanaf na kanlawehan ale. ");
INSERT INTO bps_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Na man Dwata i Amu, “I dad to ani tambaling ale salngad deg, du tagmadè ale i fye na i sasè. Taman là fakay ku nwèla i bunge i kayu mlé nawa landè sen, du ku gkaanla là ale mati kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Taman falwà ale Dwata di banwe Idén i gunun fule, du fimoan di tanà, i tanà gumdàla. ");
INSERT INTO bps_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Di kafalwà Dwata dale, dekan dad gambet kasaliganan gsen di gumsut i duh di banwe Idén, na fkahan sundang di gufusuk. Fadlug dminè i sundang na gal fatbiling flibut. Én i munung i dalan salu di kayu mlé nawa, du fye landè fakay fdadong déén. ");
INSERT INTO bps_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Na tasatlamin ale Adam na Iba. Na di là mlo mlalu kenen na mngà ale lagi, dnagitla Kain. Na man Iba, “Fagu di ktabeng i Amugu Dwata, tamngà agu i tingà lagi.” ");
INSERT INTO bps_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kafnge én, lêman mngà Iba i galwe tingaan lagi, dnagit ku Abél. Kafnge én, Abél mbaling to fulung mifat dad bilibili, na Kain kenen fulung mimò di tanà. ");
INSERT INTO bps_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Satu duh, gafat dad fule Kain, taman nun blén di Amun Dwata. ");
INSERT INTO bps_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kabay Abél kenen, nalékan i tingà bilibili i muna sut, na tnatéan na neben i fye ungad du mlé di Dwata. Na too lehew Dwata i Amu ku Abél na i gablén. ");
INSERT INTO bps_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kabay là lehew Dwata ku Kain na i gablén. Taman too blat i baweh Kain du too flabè. ");
INSERT INTO bps_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Taman man Dwata i Amu di kenen, “Tan i duenam flabè, na too blat i baweham? ");
INSERT INTO bps_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ku matlu i nimoam, lehew agu ge. Kabay ku là matlu i nimoam, i salà kaflingengu dun salngad i labè lmanaf fan mlaab ge. Hae, du gambet i sasè tulus tagatlagad fagsalà ge, na nimoan ge fasakan, bay toom kenen fnisan.” ");
INSERT INTO bps_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kafnge én, man Kain di flanekan Abél, “Magin ge deg di nligo.” Kakella di nligon fnatin i flanekan. ");
INSERT INTO bps_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Na snalek Dwata i Amu, Kain, manan, “Tanè sa i flanekam Abél?” Tmimel Kain, manan, “Làgu gadè dun. Kan dé, agu kè gal mifat i flanekgu?” ");
INSERT INTO bps_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Man Dwata i Amu di kenen, “Kan ku mimò ge i too sasè nimò ani? I litè i flanekam sadi tamlo deg mdà di tanà, du mni i balas. ");
INSERT INTO bps_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Na mdà ani fanlayamta ge. Talà ge fakay mimò di tanà, du tanà ani nsafan litè i flanekam i fnatim. ");
INSERT INTO bps_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ku lêman ge mule, là munge i fulem. Talandè too gumneam, alò ge lamngab di tah tanà ani.” ");
INSERT INTO bps_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Na man Kain di Dwata i Amu, “Too blat i flayamam deg ani, na làgu gagan tmayud dun. ");
INSERT INTO bps_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Neyem, mdà di duh ani laam agu faloh mimò di tanà, na dekam agu fawag di ge du agu lamngab di tah i tanà ani. Na balù simto mite deg, mati deg.” ");
INSERT INTO bps_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kabay tmimel Dwata i Amu kenen, manan “Là mkel di ge i manam ani, du ku nun mati ge fanlayamgu fitu dulê di kaflayamgu ge.” Taman nimò Dwata i Amu ilè di ku Kain, du fye là fnati i balù simto mite kenen. ");
INSERT INTO bps_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kafnge én, fawag Kain di muna Dwata i Amu, na mnè ditù di banwe Nad mdadong di Idén gsen di gusut i duh. ");
INSERT INTO bps_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kafnge én, tasatlamin Kain na yaanan. Na kafnge én, maltien yaanan na mngà kenen tingà lagi, dnagit ku Inok. Na di bang én, mimò Kain i bong banwe, na dnagitan i banwe ani Inok, dagit i tingaan. ");
INSERT INTO bps_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Na Inok ani i mà Irad. Na Irad ani i mà Méhudyaél. Na Méhudyaél i mà Lamék. ");
INSERT INTO bps_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Na Lamék ani nun lwe yaanan, dunan Adah na Silah. ");
INSERT INTO bps_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Na Adah ani i yê Dyabal, na mbaling Dyabal mà i kdee dad mifat dad lmanaf, na gal mnè ale di dad slung. ");
INSERT INTO bps_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na Dyabal ani nun twalin lagi dnagit ku Dyubal, na Dyubal mbaling mà i kdee gal fulung magaf dad slali, na i nun tafas dnagit alfa. ");
INSERT INTO bps_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Na Silah i yê Tubal Kain, na mbaling kenen fulung msel i tabaga na tek. Na nun flanekan libun dnagit ku Naamah. ");
INSERT INTO bps_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Na man Lamék di lwe yaanan, “E, Adah na Silah, flinge gamu deg dad yaangu, na ani i mangu di gamu. Gfatigu i lagi du bnunalan agu. Du là too tua i lagi munal deg, too nun galan, knean tagfatigu kenen. ");
INSERT INTO bps_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ku fitu dulê i ksasè kaflayam i Dwata di balù simto to mati ku Kain, salngad di to mati deg. Kabay mangu di gamu, i kaflayaman là alò fitu dulê, bay fitu falò fitu dulê i ksasean.” ");
INSERT INTO bps_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Na lêman mngà ale Adam na yaanan Iba lagi. Na man Iba, “Banlé agu Dwata tingà lagi i tlas Abél i fnati Kain.” Taman dnagitan i tingaan ani ku Sét. ");
INSERT INTO bps_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kafnge én, gamwè yaan Sét na mngà ale lagi, na dnagitan ku Inos. Na di bang ani, tambù i dad to dmasal na mangamfù di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Na tateen Dwata i too sasè nimò i kdee dad to di tah tanà, na tagadean i kdee fandamla na knayèla slame sasè. ");
INSERT INTO bps_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Na mdà di ksasè nimòla, msal Dwata di kgimoan i dad to na fnean ale dini di tah i tanà, na too nun klidù i nawan. ");
INSERT INTO bps_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Taman manan, “Falmogu i dad to tamgimògu dini di tah tanà, na fakufgu i dad lmanaf, na i dad anuk di bnas, du msal agu di kgimògu dale.” ");
INSERT INTO bps_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kabay too lehew Dwata ku Nowa. ");
INSERT INTO bps_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ani santulen gablà ku Nowa. Di kdee dad to alò Nowa i matlu, na landè sasè nimoan, na toon nimen knayè i Dwata. ");
INSERT INTO bps_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Na nun tlu dad ngaan lagi, Sém, Ham, na Dyafét. ");
INSERT INTO bps_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na bay i kdee dademe dad to di tah tanà too sasè di kite Dwata, na nun dee samuk di klamang i tanà. ");
INSERT INTO bps_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Na teenan i ksasean, du taalì i ksasè nimò i dad to. ");
INSERT INTO bps_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Taman manan ku Nowa, “Ani fandamgu, falmogu i kdee dad to di tah tanà ani, du di klamang tanà ani too fnò i sasè nimòla. Taman toogu ale falmo kadang na gakuf i kdee di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Taman fatlagad ge, mimò ge i bong aweng nun sibay mdà di mgal kayu. Sneletam di lam na di lwà. ");
INSERT INTO bps_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Na ani kiboam mimò dun, i ktahà i aweng nimoam mdadong fitu falò lime dife, na i kabalan mdadong sfalò lwe dife, na i kdatahan mdadong fitu dife. ");
INSERT INTO bps_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Na nimoam i atafan, na i kdatah di bleng i atafan na i didingan malsigu. Na nimoam i satu takab di lohokan, na nimoam tlu kansad i saalan. ");
INSERT INTO bps_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Na fdunukgu kadang i klamang tanà, du fye kdee i mto malmo. Kdee di tah tanà ani sdulê mati. ");
INSERT INTO bps_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kabay too nun kadang fakangta ge. Fusuk ge kadang di aweng na faginam yaanam, i dad ngaam lagi, na i dad yaanla. ");
INSERT INTO bps_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Na faginam i satu lagi na satu libun di kdee sahal bung lmanaf, na i dad anuk di bnas. Ani i kfagum, du fye là ale mati. ");
INSERT INTO bps_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Na mebe ge kdee bung gkaan, du fye i kdeeyu nun knaanyu.” ");
INSERT INTO bps_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Na nimò Nowa i kdee dek Dwata di kenen. ");
INSERT INTO bps_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Di kafnge Nowa mimò i aweng, man Dwata i Amu di kenen, “Fusuk ge di lam i aweng, na faginam i kdee malayam, du di kdee dad to di tah tanà, alò ge i teengu matlu. ");
INSERT INTO bps_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Faginam satu lagi na satu libun di kdee bung lmanaf i là fakay dsù di deg, bay faginam fitu i lagi na fitu i libun di kdee bung too fye lmanaf na anuk di bnas i fakay dsù di deg. Nimoam ani du fye kdee dad bung lmanaf na anuk di bnas là ale mati, bay mbel ale di kakubu i dunuk. ");
INSERT INTO bps_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Di kakubu i fitu duh kadang, fulengu di klamang tanà. Fat falò duh na fat falò butang i klon mulen. Ani kfagugu falmo i kdee dad mto mgimògu di tah tanà ani.” ");
INSERT INTO bps_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na nimò Nowa i kdee dek Dwata i Amu di kenen. ");
INSERT INTO bps_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tanam latu fali Nowa di kakel i dunuk. ");
INSERT INTO bps_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Di là fa kel i dunuk, fusuk Nowa di aweng, na i yaanan, i dad ngaan lagi, na i dad yaanla magin kenen, du fye là ale gakuf kadang di kalmo i kdee mdà di bong dunuk. ");
INSERT INTO bps_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Flulen Nowa di aweng i kdee bung lmanaf, na i dad anuk di bnas libun na lagi, balù fakay ku demen là fakay dsù di Dwata. Kdee ani salu di ku Nowa na fafusukan ale di aweng, du ani i dek Dwata kenen. ");
INSERT INTO bps_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na di kakubu i fitu duh, takel i dunuk di tah tanà. ");
INSERT INTO bps_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Di kgafat Nowa di nam latu fali, di gasfalò fitu duh di galwen bulen di fali én, én nan katbù i dunuk. I yéél di dungan i tanà samfut salu tah, na mgukà i langit du mulen. ");
INSERT INTO bps_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Na mulen fat falò duh na fat falò butang. ");
INSERT INTO bps_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Na di duh katbù i dunuk, Nowa na yaanan, i dad ngaan Sém, Ham, na Dyafét, na i dad yaanla, ditù ale di lam i aweng. ");
INSERT INTO bps_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Na tamagin di dale kdee bung lmanaf, mnalam na mlayal, dad malbang na dad malnak, na dad anuk di bnas. ");
INSERT INTO bps_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Na nun lagi na libun di kdee mto di tah tanà tasalu di ku Nowa, na tafafusukan ale di aweng, du ani i dek Dwata kenen. Na di kagfusuk i kdeela, Dwata i Amu, tmakab i takab. ");
INSERT INTO bps_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Na fadlug mulen fat falò duh na fat falò butang, na i yéél fadlug matnù i kngalaman kel talamtew i aweng. ");
INSERT INTO bps_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Na fadlug lamnok i bong yéél di tah tanà, na talamtew i aweng di tah i yéél. ");
INSERT INTO bps_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Na too lamnok i bong yéél du balù i dad mdatah bulul maglimun. ");
INSERT INTO bps_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Na lamnok fa kel di mdadong fat dife i kdatahan mdà di tah i dad bulul. ");
INSERT INTO bps_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","I kdee di tah tanà mlimas, balù dad anuk di bnas, na i kdee bung dad lmanaf, na kdee dad to. ");
INSERT INTO bps_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","I kdee mto di tah tanà slame mati. ");
INSERT INTO bps_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Falmo Dwata kdee dad to, na i kdee bung dad lmanaf, na i dad anuk di bnas. Alò Nowa i mto na dad magin kenen di lam i aweng. ");
INSERT INTO bps_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kel di mlatu lime falò duh, là mten i yéél. ");
INSERT INTO bps_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kabay là fbayà Dwata Nowa, na i kdee dad lmanaf i faginan fusuk di aweng. Taman fbalan i nus di tah tanà, na tambù mten i yéél. ");
INSERT INTO bps_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tanlag Dwata kasfut i yéél mdà di gusamfutan di dungan i tanà. Na snafangan gumukaan i langit, na fafanakan i ulen. ");
INSERT INTO bps_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Di lam i mlatu lime falò duh, fganag mten i yéél. ");
INSERT INTO bps_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Na di gasfaloan fitu duh di gfitun bulen di fali ani gine, gduung i aweng di bulul Ararat. ");
INSERT INTO bps_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Na fadlug mten i yéél, na di tnanin duh di gasfaloan bulen, tateen nan i ltut i dad bulul. ");
INSERT INTO bps_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Na kakubu i fat falò duh na fat falò butang, nukà Nowa i bintanà tanimoan di aweng, ");
INSERT INTO bps_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na fayengan i wak. Na là samfulê di aweng, bay fadlug kenen mayeng flibut kel too mten i dunuk. ");
INSERT INTO bps_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Na là mlo, fayeng Nowa lêman i abun, fye gadean ku mten i dunuk di tah tanà. ");
INSERT INTO bps_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kabay, abun ani laan teen i gumleenan, du maglimun fa yéél di tanà. Taman samfulê kenen di aweng, na nwè Nowa na fasfuléan di lam aweng. ");
INSERT INTO bps_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Na fatan Nowa kel fa di fitu duh, na lêmanan fayeng i abun. ");
INSERT INTO bps_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Di kakimalan samfulê i abun na nun doon i kayu olib falami maglifò tnukean na neben samfulê. Na én i gugmadè Nowa mten i yéél di tah tanà. ");
INSERT INTO bps_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kafnge én, fatan Nowa fitu duh fa, na lêmanan fayeng i abun, bay ani talà samfulê i abun. ");
INSERT INTO bps_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na di kgafat Nowa di nam latu satu fali i ktuan, di tnanin duh di tnanin bulen di fali én, tamten i yéél di tah tanà. Taman lanket Nowa i dademe ataf, na teenan talandè yéél, na tafan kafag i tanà. ");
INSERT INTO bps_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Na di kakelan di galwen falò fitu duh di galwen bulen, tatoo kafag i tanà. ");
INSERT INTO bps_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kafnge én, man Dwata di ku Nowa, ");
INSERT INTO bps_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ani fakay ge lamwà di aweng, na faginam i yaanam, i dad ngaam, na i dad yaanla. ");
INSERT INTO bps_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Na falwaam i dad anuk di bnas, na kdee bung dad lmanaf, mnalam na mlayal, du fye mbel ale na mbaling dee di tah tanà ani.” ");
INSERT INTO bps_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Taman lamwà Nowa di aweng, gagin kenen i dad malayan. ");
INSERT INTO bps_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kat bung i dad lmanaf, na i kdee bung dad anuk di bnas, slumbuk ale di dale bung, na satfulé ale lamwà. ");
INSERT INTO bps_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Di kagalwà Nowa di aweng, santifunan i dad batu, du mimò kenen i gudamsuan di Dwata i Amu. Kafnge én, nwean kat satu bung lmanaf na kat satu bung anuk di bnas i fakay dsù di Dwata, na sduléan snakuf, du dsuan di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","I bun i dsuan too gaflehew Dwata i Amu, na gman i nawan, manan, “Làgu lêman falmo i klamang tanà, du mdà di sasè nimò i dad to, balù gadègu mdà di ksutla nun sasè knayèla. Na làgu lêman falmo i kdee mto di tah tanà gambet i tamgimògu ani. ");
INSERT INTO bps_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Hae, du di klo fa nun banwe, nun bang kafla na kaktu, na bang tno na minit, na bang landè ulen na nun ulen, na bang mduh na butang.” ");
INSERT INTO bps_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Na banlé Dwata kafye Nowa na i dad ngaan na manan di dale, “Too gamu mngà du fye dee dad ngàyu, du fye mbaling dee belyu kadang mbel di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Na mdà ani, i kdee bung dad lmanaf na dad anuk di bnas, na dad nalaf, likò gamu. Na gamu magot i kdeela. ");
INSERT INTO bps_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Na tafakay gamu kmaan kdee bung dad lmanaf. Hae, du di muna fa, falohgu gamu kmaan dad tmabò di tanà, bay ani fakayyu knaan i kdee. ");
INSERT INTO bps_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Alò satu i làyu fakay knaan, dunan ungad ku là fa faloh i litean. Én duenan fnanggu ani, du i gumdà i dad kdee dad mto, dunan di litè. ");
INSERT INTO bps_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ku satu to manò i dademen to, fanlayamgu kenen. Na ku nun lmanaf mati to, kenen fnati. ");
INSERT INTO bps_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Dad to mgimò Dwata salngad i kenen kagkah, taman i to manò i dademen to kenen fnati. ");
INSERT INTO bps_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kabay gamu, too gamu mngà du fye dee dad ngàyu, du fye mbaling dee dad belyu kadang mbel di klamang banwe.” ");
INSERT INTO bps_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kafnge én, man Dwata di ku Nowa na di dad ngaan, ");
INSERT INTO bps_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ani, too nun fakanggu gamu kel di dad belyu kadang, ");
INSERT INTO bps_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na kel di dad kdee mto, dunan dad anuk di bnas, na kdee dad lmanaf, i kdee magin gamu lamwà di aweng. ");
INSERT INTO bps_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Na ani i fakanggu gamu. Làgu lêman falmo i dad kdee mto di tah tanà ani fagu di dunuk, na i klamang banwe ani, làgu lêman falmo fagu di dunuk.” ");
INSERT INTO bps_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Na fadlug talù Dwata, manan, “Ani nimògu ilè du fye gadèyu dnohògu i fakanggu gamu na i kdee i dad mto kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Fkahgu lawélawé ditù di dad labun, na ani ilè i fakanggu di kdee dad to mnè di tah i tanà. ");
INSERT INTO bps_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Klitgu flabun i langit na msut i lawélawé, ");
INSERT INTO bps_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","én i banggu faldam i tafakanggu di gamu na i kdee dad mto di tah tanà ani. Na làgu lêman falmo i kdee fagu di dunuk. ");
INSERT INTO bps_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Di ksut i lawélawé di dad labun, teengu kadang na fandamgu i fakanggu di kdee dad mto di tah tanà ani kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","“Ani sa i ilè i fakang i tafakanggu di kdee mnè di tah i tanà.” Én gman Dwata di ku Nowa. ");
INSERT INTO bps_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Na i dad ngà Nowa lamwà di aweng dunan, Sém, Ham, na Dyafét. (Na Ham i mà Kanaan.) ");
INSERT INTO bps_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","I dad tlu lagi tingà Nowa ani, i dad gutambul i kdee dad to mnè di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Na du Nowa too fulung mimò di tanà, kenen i muna mule i walad dnagit grép. ");
INSERT INTO bps_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Na di kinuman i binu i mgimoan mdà di grép, langal kenen, na mdà di klangalan flaweh kudang di slungan. ");
INSERT INTO bps_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Na Ham i mà Kanaan, toon neye i maan flaweh, na di keyen lamwà kenen na tnulenan i lwe flanekan. ");
INSERT INTO bps_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kabay Sém na Dyafét mwè i klaweh na dafatla di ftubungla na fudul ale fusuk di sibay màla na knayabla kenen. Là ale falê, du fye làla teen i màla flaweh. ");
INSERT INTO bps_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Na di kwas i klangal Nowa, na di kgadean i nimò Ham di kenen, ");
INSERT INTO bps_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","manan, “Kadang satu duh, fanlayam Dwata Kanaan, tingà Ham, na mbaling kenen mgimò lifan i dad flanekan. ");
INSERT INTO bps_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Dnayenito Dwata i Amu, i Dwata Sém. Kanaan moon mgimò kadang lifan Sém. ");
INSERT INTO bps_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Too fbel Dwata kadang moon i bel Dyafét. Na fnean ale moon di bel Sém. Kabay i bel Kanaan moon mgimò kadang lifan i bel Dyafét.” ");
INSERT INTO bps_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Di kakubu i dunuk mto fa Nowa kel di tlu latu lime falò fali. ");
INSERT INTO bps_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Na mati Nowa di syem latu lime falò falin. ");
INSERT INTO bps_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Di kagatbuan nun alò satu bung talù, i talù kdee dad to di klamang i banwe. ");
INSERT INTO bps_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Na di kalngabla, magu ale gsen di gusut i duh kel di too datal na mabal tanà di Sinar, na mnè ale déén. ");
INSERT INTO bps_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Na kafnge én, stulen i dad to én, manla, “Gasil ito nan santifun i fitak na fkafagito di luben, fye mbaling too kmegeng na mgal, du fye nun imoito gumnè.” Na du landè too batu di banwe atù, én baling santifunla fitak na fkafagla na fnadkatla i sfaltu. ");
INSERT INTO bps_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kafnge én, manla, “Ani mimò ito bong banwe i nun bong mdatah gumnè gafat di langit, fye too mdengeg i dagitito na là ito masbalét di klamang i banwe.” ");
INSERT INTO bps_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kabay Dwata i Amu, mdà kenen di langit, salu ditù du toon neye i bong banwe na i mdatah gumnè nimò i dad to ani. ");
INSERT INTO bps_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Na man Dwata i Amu, “I kdee dad to ani, du tasasatu nawala na alò satu talùla, ani fa alò katbù i fanla nimò. Na là mlo ani gaganla mimò i kdee kayèla nimò. ");
INSERT INTO bps_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Taman salu agu ditù na sansahalgu i talùla, du fye nun dee sahal talù, du fye là ale saglabat.” ");
INSERT INTO bps_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Taman sanbalét ale Dwata i Amu, mdà déén kel di klamang banwe, na én duenan tanlagla i kimòla i bong banwe. ");
INSERT INTO bps_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","I banwe ani dnagit ku Babél, du sansahal Dwata i Amu i talù dad to déén, du fye mgimò dee sahal talù. Na mdà di Babél, sanbalétan i dad to di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ani i dagit i dad bel Téra. Téra ani i mà Abram, Nahor, na Haran. Na Haran ani i mà Lat. ");
INSERT INTO bps_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Di là fa mati Téra, mati i tingaan lagi dunan Haran di banwe gusutan dnagit Ur di Kaldi. ");
INSERT INTO bps_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Na Abram na Nahor tamwè ale yaan. I dagit yaan Abram Saray, na Nahor kenen, i dagit yaanan Milka, i tingà Haran. Na nun fa tingà Haran lagi dnagit ku Iskah. ");
INSERT INTO bps_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na Saray ani là mngà, taman, landè dad ngaan. ");
INSERT INTO bps_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Na fagin Téra tingaan lagi Abram, na i fuan lagi Lat, tingà Haran, na tewen Saray yaan Abram. Na mdà ale di banwe Ur di Kaldi salu di banwe Kanaan. Kabay kakella di banwe Haran, mnè ale ditù. ");
INSERT INTO bps_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Na di banwe Haran gumati Téra. Di kfatin talwe latu lime i falin. ");
INSERT INTO bps_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Na man Dwata i Amu di ku Abram, “Tnagakam i banwem ani, na dad gakedam, na i dad malay i maam, na salu ge ditù di banwe tdògu ge. ");
INSERT INTO bps_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Na ditù di banwe atù kadang, toota ge fbel, na mbaling ale sbung dad to too mlabung, na banléta ge kadang kafye. Na toogu fdengeg i dagitam, du fye lê ge gamlé kafye di dademem to. ");
INSERT INTO bps_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Banlégu kadang kafye i dad to fafye ge, bay dnuengu i balù simto dmuen ge. Fagu di ge blégu kafye di kdee dad to di klamang banwe.” ");
INSERT INTO bps_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Taman kaklinge Abram i gman Dwata i Amu, nimenan i dek Dwata kenen, na mdà kenen na magin Lat. Na di bang atù di kdà Abram di Haran tafitu falò lime i falin. ");
INSERT INTO bps_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Faginan i yaanan Saray, na tingà i flanekan dnagit ku Lat, na i kdee dad knunan na kdee dad lifanan gwean di banwe Haran, na mdà ale salu di Kanaan. Na di kakella di banwe Kanaan, ");
INSERT INTO bps_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","fadlug ale Abram kel di satu bong kayu di Moré di banwe Sikim. Na di bang atù nun fa dad to di Kanaan mnè déén. ");
INSERT INTO bps_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Na déén gumsut Dwata i Amu di ku Abram, na manan di kenen, “Ani i tanà blégu kadang di dad belam.” Taman déén gumimò Abram i gudamsù i dad lmanaf, du blé di Dwata i msut di kenen. ");
INSERT INTO bps_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mdà déén, fadlug ale Abram salu di dad bulul gsen di gusut i duh mdadong di banwe Bétél, du mlawig di gutngà i banwe Bétél na banwe Ay. I banwe Bétél i gsen di gusdaf i duh, na i banwe Ay i gsen di gusut i duh. Na déén lêmanan nimò i gudamsù di Dwata i Amu, na mangamfù kenen di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kafnge én, fadlug magu ale Abram salu di banwe Négéb. ");
INSERT INTO bps_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Na di bang atù nun bong kbitil di banwe Kanaan, na én duenan fles ale Abram di banwe Idyif, du mnè ale déén là mlo. ");
INSERT INTO bps_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kagdadongla di banwe Idyif, man Abram di yaanan Saray, “Too fye i baweham. ");
INSERT INTO bps_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Hae, na kadang di kite ge i dad to di Idyif too dmalam i nawala ge i yaangu. Na fnatila agu kè, du fye gwèla ge. ");
INSERT INTO bps_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Fye fa ku manam dale flanekta ge, du fye làla agu fnati, bay balingla agu too fanse fanduf, du man nawala là ite satlamin.” ");
INSERT INTO bps_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kakel Abram di Idyif, kite i dad to déén too fye baweh i yaanan. ");
INSERT INTO bps_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kite i dad ganlal i harì ku Saray, tnulenla i harì gablà di kafye bawehan. Taman fnean Saray di bong gumnean. ");
INSERT INTO bps_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Too fanse fanduf harì ani Abram, du man nawan ise ale satlamin. Banlén Abram dee dad bilibili, dad kambing, dad baka, dad lmanaf dnagit dongki na kamél, na dad lifan, libun na lagi. ");
INSERT INTO bps_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kabay nun dad too sasè tduk flayam Dwata i Amu i harì na dad dademe to mnè di gumnean, du fnean Saray, yaan Abram di gumnean. ");
INSERT INTO bps_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Taman fafngén Abram, na snalékan kenen, manan, “Kan kè duenam mimò sasè di deg? Kan i duenam là tmulen deg Saray ani i yaanam? ");
INSERT INTO bps_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Du manam flanekam, na én sa duengu mwè kenen du yaangu. Na gani sa i yaanam, faginam kenen na mdà gamu nan.” ");
INSERT INTO bps_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kafnge én, dek harì i dad ton falwà ku Abram, yaanan, na dad kdee nfunan di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Taman mdà Abram, yaanan, na dad kdee nfunan di banwe Idyif salu di banwe Négéb. Na magin Lat dale. ");
INSERT INTO bps_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Nun nan bong knun Abram. Nun dad bilibilin, dad kambingan, dad bakan, na nun bong salafian na blawenan. ");
INSERT INTO bps_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Di kdaan di banwe Négéb, fadlug magu di sahal banwe. Kafnge én, kel di banwe Bétél di muna gumnean di gutngà i banwe Bétél na Ay, ");
INSERT INTO bps_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","sablà i gumimoan i gudamsù. Kakelan déén mangamfù kenen di Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na Lat i fadlug samnagin ku Abram. Na nun malayan, dad lifan, dad bilibili, dad kambing, na dad bakan. ");
INSERT INTO bps_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kabay du too dee dad lmanafla, na satnù ale, takulang nan i tanàla. ");
INSERT INTO bps_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Én baling i gumdà i kasbulaw i dad to Abram na dad to Lat, i dad mifat i dad lmanafla. Na di bang atù nun fa dad to mdà di Kanaan, na dad to mdà di Férisi mnè déén. ");
INSERT INTO bps_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Taman man Abram di ku Lat, “E Tò, là agu mayè ku sbulaw ite demen ku sbulaw dad tota gal mifat i dad lmanafta, du ge sa i asal tingàgu. ");
INSERT INTO bps_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Neyem, too mabal i tanà ani. Fye fa baling ku stani ite mnè. Ge malék i tanà i kayeam. Na ku nalékam i tanà gsen di ibeng, mili agu di tanà gsen di kwanan. Ku nalékam i tanà gsen di kwanan, mili agu di tanà gsen di ibeng.” ");
INSERT INTO bps_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Too neye Lat i klamang tanà, na teenan i datal tanà mdadong di yéél Dyordan kel di banwe Sor, slame too fye tanà, du too nun yéélan salngad baweh di kafye baweh i banwe mgimò Dwata di muna fa, na salngad baweh i banwe Idyif. Di bang atù là fa falmo Dwata i banwe Sodom na banwe Gomora. ");
INSERT INTO bps_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Taman malék Lat i klamang datal tanà mdadong di yéél Dyordan, na mdà kenen salu ditù gsen di gusut i duh. Na ani nan i bang stani mnè Abram na Lat. ");
INSERT INTO bps_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Na mnè fa Abram di banwe Kanaan, bay mili Lat baling mdadong di dad banwe di datal tanà na mnè mdadong di banwe Sodom. ");
INSERT INTO bps_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na i dad to mnè di banwe Sodom, too sasè nimòla. Na too ale gamsalà di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Na di ktani Lat, lêman talù Dwata i Amu di ku Abram, manan, “Toom neye i tanà mdà di gusut i duh, na di gustafan, na di glibutam. ");
INSERT INTO bps_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I klamang tanà teenam, én i blégu ge na di dad belam kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Toota ge fbel, i landè gmagan mse di tandà i kdeela, gambet kfung i tanà. Du mula fa mse i kfung di kse i dad belam. ");
INSERT INTO bps_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Na mdà ge nan na lanngabam i klamang tanà ani, du ani blégu ge.” ");
INSERT INTO bps_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kafnge én, mili Abram mdadong di gunun dad malbang kayu Mamri di banwe Hibron, na mnè déén. Na lêman mimò i gudamsù, du mangamfù kenen di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na di bang atù, Amrafél i harì di banwe Sinar, Ariok i harì di Élasar, Kadorlaomar i harì di Élam, na Tadal i harì di Goyim. ");
INSERT INTO bps_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Na i dad harì ani, sasatu fandamla sfati di lime dademe harì, dunan Bara harì di Sodom, Birsa harì di Gomora, Sinab harì di Adma, Sémébér harì di Séboyim, na harì di Béla, na i satu dagit i banwe én dunan Sor. ");
INSERT INTO bps_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Na lime dad harì gine sasatu fandamla, na stifun i dad sundalula di datal tanà mdadong di banwe Sidim, di sadni dagitan Lanaw Kahì. ");
INSERT INTO bps_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","I satu harì dunan Kadorlaomar, magot i dad lime harì ani gine di sfalò lwe fali. Kabay kakél di gasfalò tlu fali kalwela i kagotan dale. ");
INSERT INTO bps_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na kakel di gasfalò fat fali, Kadorlaomar ani na i dademe dad harì msen di kenen na lêman i dad sundalula, sanfatila dad to di dademe dad banwe. Na fnisanla dad to mdà di banwe Réfay ditù di banwe Astérot Karnaim. Na balù fnisanla i dad to mdà di banwe Susi ditù di banwe Ham, na i dad to mdà di banwe Émi ditù di banwe Sabék Kiritaim. ");
INSERT INTO bps_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Na fnisanla i dad to mdà di banwe Hori di dad bulul di Séir kel ditù di Él Faran mdadong di banwe gulandè to. ");
INSERT INTO bps_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kafnge én, samfulê ale di banwe Én Misfat, dunan Kadis i satu dagitan, na fnisanla i dad kdee dad to mnè di tanà i sbung dad to dnagit Amalék, na fnisanla i sbung dad to dnagit Amori i mnè di banwe Hasason Tamar. ");
INSERT INTO bps_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na fasfulê ito di dad lime harì gine di banwe Sidim. Na i dad harì ani mdà di dad banwe Sodom, Gomora, Adma, Séboyim, na Béla dunan Sor, na i dad sundalula, fatlagad ale di kasfati déén di datal tanà mdadong di Sidim. ");
INSERT INTO bps_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Na dad dademe harì sanfatila dunan Kadorlaomar i harì di Élam, Tadal i harì di Goyim, Amrafél i harì di Sinar, na Ariok, i harì di Élasar. Taman dad lime harì sanfati i dad fat harì ani gine. ");
INSERT INTO bps_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na i datal tanà mdadong di Sidim ani dee dad sol i nun too sadkat. Na di kila i dad harì di Sodom na Gomora du fisan ale, nun dademe i dad sundalula baling ale mtatek di dad sol ani, na i dademe gila di dad bulul. ");
INSERT INTO bps_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kafnge én, i dad fat harì gladla kdee knun, na balù i kakaan di banwe Sodom na Gomora, na mdà ale. ");
INSERT INTO bps_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Na balù Lat i asal tingà Abram kanfèla, na gladla i nfunan, du ditù sa i gumnean di Sodom. ");
INSERT INTO bps_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kabay kadì nun satu to galwà, na tnulenan Abram i Hibru, gablà di kdee ani gine. Du bang ani, mnè Abram mdadong di malbang dad kayu nfun Mamri, i satu to mdà di sbung to dnagit ku Amori. Na Mamri ani nun lwe flanekan lagi dnagit ku Éskol na Anér. Abram na i tlu ani gal ale stabeng. ");
INSERT INTO bps_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kaklinge Abram tamakfè i tingà i flanekan santifunan i kdee dad saligan i fulung sfati na lamnok di ifatan, na kdeela masdagub tlu latu sfalò walu. Na mdà ale tmafik i fat harì ani kel di banwe Dan. ");
INSERT INTO bps_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Na di butang én, faslumbuk Abram i dad ton, na natudla dad harì na fnisanla ale. Tmafik ale Abram dad harì na i dad sundalula kel di banwe Hoba di gufdu i sabnal di banwe Damaskus. ");
INSERT INTO bps_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Na gawì Abram i kdee knun i gladla. Na gafalwaan Lat di kakfè kenen, na fuléan ku Lat i kdee dad nfunan. Na dad libun na i dademe dad to tamakfè, gafalwà ale Abram. ");
INSERT INTO bps_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Di kulê Abram nan di kafngen misan ku Kadorlaomar na i dademen harì, snitong kenen i harì di banwe Sodom ditù di Datal Sabék, i satu dagitan dunan Datal i Harì. ");
INSERT INTO bps_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kafnge én, Mélkisidék, i harì di banwe Salém, smitong ku Abram. Mélkisidék ani i satu bà di Dwata i Too Mdatah. Na mebe kenen fan na binu di ku Abram. ");
INSERT INTO bps_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Na banlén kafye Abram, manan, “I Dwata Too Mdatah mlé kafye di ge, i Dwata tamimò i langit na i klamang banwe. ");
INSERT INTO bps_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","“Magdayen Dwata i Too Mdatah, du tnabengan ge di kfisanam i dad dmuen ge.” Kagmanan ani, blé Abram ku Mélkisidék i gasfalò i kdee gwean di dad fat harì i fnisanan. ");
INSERT INTO bps_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kafnge én, man i harì di Sodom, “Ge sa mfun i kdee nfunmi, i gweam di dad harì gladla mdà di gami. Kabay fuléam alò di deg i kdee dad togu.” ");
INSERT INTO bps_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kabay tmimel Abram, manan, “Tasmafà agu nan di Dwata i Amu, i Too Mdatah, i Mgimò i langit na i klamang banwe. ");
INSERT INTO bps_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Makang agu ge, landè balù tan i ge nfun, i làgu fulê di ge, balù fa i tukay sinulib ku demen ikat i lafin bliam, du fye laam fakay man kadang agu mbaling to nun du mdà di ge. ");
INSERT INTO bps_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Landè falus nwègu du nfungu. Én alò gdawatgu i tagkaan i dad togu, na én i làgu fulê. Kabay mni agu alel du blégu di dad to magin deg dunan Anér, Éskol, na Mamri.” ");
INSERT INTO bps_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kafnge én, nun kanteen Abram na lingen Dwata i Amu talù di kenen, manan, “E Abram, nang ge likò. Agu sa i klungam i kamlung ge. Na agu sa gumdà i too glut untungam.” ");
INSERT INTO bps_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kabay tmimel Abram, manan, “Dwata i Amu, i Magot i Kdee, landè gablém di deg i too gaflehew deg, du kel i ani landè fa tingàgu. Na di kfatigu, Élisar i to mdà di banwe Damaskus baling i mfun i kdee nfungu. ");
INSERT INTO bps_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Du laam agu sa banlé tingà, taman én i fangfungu i dad knungu i satu lifangu i mnè di gumnègu.” ");
INSERT INTO bps_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na lêmanan linge talù Dwata i Amu di kenen, manan, “Élisar ani ise mangfun i knunam, du nun tingaam lagi kadang na kenen sa mbaling mfun dun.” ");
INSERT INTO bps_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Na nebe kenen Dwata déén di lwà, na manan di kenen, “Neyem i langit, na nsem i dad blatik ku gaganam i mse dun. Na di satu duh kadang too dee dad belam salngad i kdee dad blatik atù.” ");
INSERT INTO bps_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Fnaglut Abram Dwata i Amu, na mdà di kafaglutan ani, matlu kenen di kite i Dwata. ");
INSERT INTO bps_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Lêman man Dwata, “Agu Dwata i Amu, mdek ge lamwà di banwe Ur di Kaldi, du fye blégu ge i klamang tanà ani.” ");
INSERT INTO bps_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kabay tmimel Abram, manan, “Amugu Dwata, i Magot i Kdee, tan i gugmadègu nfungu di satu duh kadang i tanà gmanam ani?” ");
INSERT INTO bps_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tmimel Dwata i Amu, manan, “Mebe ge deg satu baka, satu kambing, na i satu bilibili, slame ale tlu fali, na fakufam i satu abun na satu salafati.” ");
INSERT INTO bps_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Taman i kdee gman Dwata ani, fti nebe Abram di kenen, na fnatin, na sanbalin i dad lmanaf ani, na fansen snablà i fkah dun. Alò i dad anuk di bnas laan sanbali. ");
INSERT INTO bps_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kafnge én, mleen i dad malbang anuk di bnas di tasanbali lmanaf én, du fanla knaan, bay ndal ale Abram. ");
INSERT INTO bps_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Na di kasdaf i duh, too gkudang Abram, na kanteenan i mgat kmifu samlibut kenen, na too sè i klikoan. ");
INSERT INTO bps_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Taman lêman man Dwata i Amu di kenen, “Fye gadeam too gdohò i knè i dad belam di tanà nfun i dademe dad to na gfasak ale na faflayam ale kel di fat latu fali. ");
INSERT INTO bps_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kabay kafnge én, fanlayamgu i dad to masak dale, na galwà ale di agot i dad to én, na di kalwàla gamgebe ale i dee dad knun. ");
INSERT INTO bps_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kabay ge, landè sa smamuk ge du flawilta ge. Na di ktuam mati ge na fanse ge lbang. ");
INSERT INTO bps_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Na kel fa di fat tugad i belam, kohla fa gasfulê dini. Na i dad to dnagit Amori, i mnè dini di banwe Kanaan, làgu fa falwà, bay di kakel i bang too sasè i nimòla, fanlayamgu na falwàgu ale di banwe ani.” ");
INSERT INTO bps_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Na di takasdaf i duh, na mbaling kifu nan, makto teen Abram i msut i sadi satu bong kulang nun lifoh, na mbuk gagin i gansà too dminè. Na tì fatngà magu di bleng i dad lmanaf tamasbali én gine. ");
INSERT INTO bps_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hae, du di duh én, Dwata i Amu makang ku Abram, na manan, “Ani i fakanggu, satu duh blégu di dad belam i klamang tanà ani, mdà di yéél di banwe Idyif kel di bong yéél Yufratis. ");
INSERT INTO bps_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Lêgu blé di dale i tanà i gumnè i dee bung dad to dnagit ku Kéni, Kénisi, Kadmoni, ");
INSERT INTO bps_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti, Férisi, Réfay, ");
INSERT INTO bps_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaan, Girgasi, na Dyébusi.” ");
INSERT INTO bps_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Na Saray, yaan Abram, là mngà. Kabay nun libun lifanan i mdà di banwe Idyif dnagit ku Hagar. ");
INSERT INTO bps_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Taman man Saray di ku Abram, “Là faloh Amuta Dwata ku mngà agu, taman fye ku tanlaminam i lifangu, du ken nun belta fagu di kenen.” Na nagin Abram i knayè nawa yaanan Saray. ");
INSERT INTO bps_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Taman fatlamin Saray i lifanan Hagar di ku Abram, du nimò yaanan. Di bang atù, tasfalò fali i klo Abram mnè di banwe Kanaan. ");
INSERT INTO bps_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Na tasatlamin ale Hagar na Abram, na kafnge én maltien Hagar. Na di kgadè Hagar maltien kenen, too kenen fdag na toon sansilo Saray. ");
INSERT INTO bps_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Taman man Saray ku Abram, “Na ge banlégu salà duen Hagar samsilo deg. Deg i fatlamin dun ge, na di kgadean tamaltien kenen sansilon agu, na landè kafean deg. Dwata i Amu sa mukum gite.” ");
INSERT INTO bps_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tmimel Abram, manan, “Ku én kadì, na du lifanam nimoam di kenen i knayeam nimò.” Na sasè kibò Saray ku Hagar, taman mila kenen. ");
INSERT INTO bps_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Na nun kasaligan i Dwata smitong ku Hagar di satu sfuten di banwe landè to di kilil i dalan magu salu di banwe Sur. ");
INSERT INTO bps_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Na man kasaligan di kenen, “Hagar lifan Saray, nè gufdum, na nè gusalum?” Na tmimel Hagar, manan, “Mila agu di amugu Saray.” ");
INSERT INTO bps_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Man i kasaligan i Dwata i Amu, “Samfulê ge di kenen na nimenam i dekan ge.” ");
INSERT INTO bps_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Na fadlug talù i kasaligan, manan, “Toogu fbel i belam satu duh kadang, na là ale gagan nse du too dee. ");
INSERT INTO bps_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Du di là mlo ani, mngà ge lagi, na dnagitam ku Ismaél, du i gumtatek i dagitan ani dunan, fanlinge sa Dwata i kaftabengam. ");
INSERT INTO bps_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kabay i tingaam kadang gambet i satu lmanaf di bnas di là fa faknalam. Na là gdadong i kdee dad to di kenen, du mdà di klabean, na knang kenen i kdee dad to, na i kdee dad to mnang nawa kenen, na balù i dad flanekan knangan nawa.” ");
INSERT INTO bps_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Na én kdagit Hagar i Dwata i Amu i talù di kenen, dunan, “Ge i Dwata i mifat deg.” Manan ani du snalekan di nawan, manan, “Teengu kè gine Dwata i mifat deg?” ");
INSERT INTO bps_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Na ani i duen dmagit i ktufa én, Béér Lahay Roy, du i gumtatekan, dunan Ktufa Dwata i Mto na i Mifat Deg. Na i ktufa ani déén fa kel di bang ani di gutngà i banwe Kadis na Béréd. ");
INSERT INTO bps_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kafnge én, sut i tingà Hagar lagi na dnagit Abram ku Ismaél. ");
INSERT INTO bps_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Na di ksut Ismaél di ku Hagar tawalu falò nam fali Abram. ");
INSERT INTO bps_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Na kel tasyem falò syem i fali Abram, lêman msut Dwata i Amu, di kenen, na manan, “Agu Dwata Too Mtulus, mimen ge deg, na fadlug ge mimò i matlu nimò. ");
INSERT INTO bps_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na dnohògu i tafakanggu ge. Hae, toota ge fbel, du fye too dee dad belam.” ");
INSERT INTO bps_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kaklinge Abram ani, lkuad kenen na kudung di tanà, du nafean Dwata. Na lêman man Dwata, ");
INSERT INTO bps_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ani i fakanggu ge, nimòta ge mà i dee bung dad to. ");
INSERT INTO bps_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mdà ani talà ge matlo Abram, bay dnagitta ge Abraham, du nimòta ge mà i kdee bung dad to. ");
INSERT INTO bps_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Fdeegu i dad belam, du fye nun dee bung dad to. Nun kadang di dad belam mbaling ale harì. ");
INSERT INTO bps_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Toogu dnohò i fakanggu di ge ani, na kel di dad belam kel di landè sen. Agu Dwatam na Dwata i dad belam di fulé duh. ");
INSERT INTO bps_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I klamang tanà Kanaan i flo gumneam ani i blégu ge kadang na i dad belam, du fye gfunyu kel di landè sen. Na satu duh agu Dwatala.” ");
INSERT INTO bps_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Na lêman talù Dwata di ku Abraham, manan, “Nun ilè i fakanggu, na là fakay ku làyu nimò, ge na i dad belam di fulé duh. ");
INSERT INTO bps_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ani sa i ilè i nimòyu, ge na i dad belam, na tooyu dnohò ani, dunan i kdee dad lagi di gamu ftulìyu. ");
INSERT INTO bps_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ge sa ftulì, du én i ilè i fakangta ge. ");
INSERT INTO bps_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Na mdà ani, na kel di dad belam di fulé duh, tnulìyu i dad lagi ku tawalu duh klon sut, balù dad ngà lagi sut di dad lifanyu, balù sut di gumnèyu ku demen to tagbayadyu mdà di dademe dad to. ");
INSERT INTO bps_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hae, du dad ngà lagi sut di gumnèyu demen ku tagbayadyu di dademe dad to, kdee dad lagi too ftulì. Du mdà di ilè di dad lawehyu gadèyu i kfankanggu landè gusenan. ");
INSERT INTO bps_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Na ku simto di dad lagi i là ftulì, là gakuf kenen di gamu, du laan nimen i dek kenen gablà di kfakanggu.” ");
INSERT INTO bps_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Fadlug talù Dwata di ku Abraham, manan, “Nangam dnagit i yaanam Saray, bay mdà ani dnagitam kenen Sara. ");
INSERT INTO bps_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Banlégu kenen kafye na toota ge banlé i tingà lagi fagu di kenen. Banlégu kenen kafye na kenen sa mgimò yê i dee bung dad to. Na nun kadang mgimò harì mdà di dad belan.” ");
INSERT INTO bps_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kaklinge Abraham kdee ani, lkuad kenen na kudung di tanà na mulé di fandaman di kton, manan, “Tay, gafngà fa kè i to tamlatu fali? Na mngà fa kè Sara i tasyem falò falin?” ");
INSERT INTO bps_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Na man Abraham di Dwata, “Fye fa moon ku gamdawat Ismaél i dad fakangam di deg.” ");
INSERT INTO bps_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tmimel Dwata, manan, “Ise Ismaél gumlégu i fakanggu ge, du i yaanam Sara mngà kadang i tingaam lagi na dnagitam kenen Isaak. Dnohògu i fakanggu di kenen na i dad belan kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Lingegu i kafakdom gablà ku Ismaél, taman blégu di kenen kadang i kafye na banlégu kenen dee dad ngà na dee dad belan. Na i sfalò lwe di dad belan mgimò kadang dad ulu. Na mgimò i dad belan i satu bung dad to too mlabung. ");
INSERT INTO bps_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kabay di tingaam lagi Isaak gudmohògu i fakanggu. Sut kenen di yaanam Sara salngad di bang ani, di gamtadol fali.” ");
INSERT INTO bps_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kafnge Dwata stulen di ku Abraham tnagakan kenen. ");
INSERT INTO bps_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Na di duh atù, tnulì Abraham i tingaan Ismaél na kdee dad lagi sut di gumnean na balù i kdee lagi gbayadan mdà di dademe dad to, du én sa i gman Dwata di kenen. ");
INSERT INTO bps_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Di kaftulì Abraham tasyem falò syem falin, ");
INSERT INTO bps_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na i tingaan Ismaél tasfalò tlu falin di ktulì kenen. ");
INSERT INTO bps_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Di duh atù Abraham na i tingaan Ismaél, taftulìla i ktola, ");
INSERT INTO bps_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","na gakuf i kdee dad lifanan lagi. ");
INSERT INTO bps_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Satu duh, msut Dwata i Amu di ku Abraham di gunun malbang kayu nfun Mamri di ltu i duh klon sudeng di gufusuk di slungan. ");
INSERT INTO bps_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Na keye Abraham, nun teenan tlu dad lagi tadag mdadong déén. Di kiten dale sadlu smitong na lkuad du mafè dale. ");
INSERT INTO bps_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Na man Abraham di dale, manan “Lew, beg gamu slob. Nang gamu fadlug, du gani agu na tmabeng agu gamu. ");
INSERT INTO bps_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Fafwè agu yéél, du alob i blìyu. Na beg gamu fakay ftud di dungan i kayu ani. ");
INSERT INTO bps_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Fankaanta gamu, du fye nun galyu di là gamu fa fadlug di kaguyu. Lehew agu, du tanlauyyu agu na kayègu tmabeng gamu.” Na tmimel ale, manla, “Tay, too fye sa. Na nimoam i gmanam.” ");
INSERT INTO bps_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kaklinge Abraham i manla, gasil kenen fusuk di slungan di ku Sara, na manan, “Faflal ge. Nweam satu saku too fye arina na nimoam fan.” ");
INSERT INTO bps_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kafnge én, faflal Abraham salu di dad bakan, du kanfean i too fye guyà baka, ftatéan di saligan, na faflalan ftaga. ");
INSERT INTO bps_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Di kafnge ktaga i kdee blé Abraham di dad to én gine, na léan blé gatas, na satu bung gkaan nimò mdà di gatas. Klola kmaan dun, tadag kenen mdadong di dale di dungan i kayu. ");
INSERT INTO bps_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Slengla kmaan snalekla ku Abraham, manla, “Tanè i yaanam Sara?” Tnimelan ale, “Ditù kenen di slungmi.” ");
INSERT INTO bps_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kafnge én, man i satu di dad to tlang déén, dunan Dwata i Amu, manan, “Salngad ani bangan kadang di fulé fali, too agu samfulê na mngà yaanam Sara tingà lagi.” Na Sara kadì, tadag di gufusuk i slungla di gsen i kagol i to atù, na lingen i manan. ");
INSERT INTO bps_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Na Abraham na Sara tatoo tua nan, na taglius i bang Sara mngà. ");
INSERT INTO bps_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Taman mulé kenen, du manan di nawan, “Tatoo agu tua, na yaangu too tua nan. Tan kibò i klehew ani kel di deg?” ");
INSERT INTO bps_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Na man Dwata i Amu di ku Abraham, “Tan dé duen Sara mulé na manan di nawan ku tan i kiboan mngà du tatoo tua nan? ");
INSERT INTO bps_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nun kè i làgu gagan nimò? Landè sa! Salngad ani bangan di fulé fali samfulê agu, du mngà Sara tingaan lagi.” ");
INSERT INTO bps_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Na du likò Sara taman tmulen kéng, na manan, “Là agu mulé.” Kabay man Dwata, “Too glut mulé ge.” ");
INSERT INTO bps_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na di fan mdà dad lagi ani, meye ale ditù gsen di banwe Sodom na magin Abraham dale, du tdoan i dalanla. ");
INSERT INTO bps_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Klola magu man Dwata i Amu di kton, “Làgu buni di ku Abraham i fandamgu i fangu nimò, ");
INSERT INTO bps_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","du i dad belan too dee kadang, na mbaling sbung dad to too mdatah, na banlégu kafye i kdee bung dad to di klamang banwe du mdà di kenen. ");
INSERT INTO bps_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tamgalékgu Abraham, du fye tdoan i dad ngaan na i dad belan kibòla mimen deg, fagu di kimòla fye na matlu. Na ku én nimòla, dnohògu i kdee fakanggu di kenen.” ");
INSERT INTO bps_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kafnge én, man Dwata i Amu di ku Abraham, “Too dee tmulen di deg gablà di dad to di dad banwe Sodom na Gomora. Too blat kun i dad salàla. ");
INSERT INTO bps_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Taman salu agu ditù, du neyegu ku glut i kaklingegu ku là.” ");
INSERT INTO bps_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kafnge én, i lwe to mdà, na fadlug salu di banwe Sodom, na mnè Abraham di saféd i Amun Dwata. ");
INSERT INTO bps_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Na fdadong Abraham di Dwata na smalek, manan, “Di kafalmom i dad to sasè, fakufam kè i dad to matlu? ");
INSERT INTO bps_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kaflingenta dun, ku nun lime falò to i matlu ditù di Sodom, falmom fa kè i klamang syudad? Kandom kè i dad lime falò to matlu? ");
INSERT INTO bps_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Toogu fnaglut laam tì fnati i dad to matlu fakuf di dad to sasè. Laam kè nimò ani! Ku fanlayamam i dad to sasè laam fakuf i dad to matlu. Hae, du ge sa i mukum i kdee dad to na i kukumam too matlu.” ");
INSERT INTO bps_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Na tmimel Dwata i Amu, manan, “Ku nun lime falò dad to matlu ditù di Sodom, làgu falmo kadang i klamang syudad, duenan du mdà di dale.” ");
INSERT INTO bps_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Na lêman talù Abraham di Dwata, manan, “Balù alò agu to, na ge Dwata i Amu, toom beg fantahà i nawam di deg di kafadluggu stulen di ge. ");
INSERT INTO bps_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ken nun alò fat falò lime i dad to matlu, falmom fa i klamang syudad du kulang lime di lime falò gine?” Tmimel i Dwata, “Ku nun fat falò lime i dad to matlu, làgu falmo i syudad.” ");
INSERT INTO bps_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Na lêman talù Abraham, “Ken nun alò teenam fat falò?” Tmimel Dwata, manan, “Ku nun fat falò, làgu falmo dun.” ");
INSERT INTO bps_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Man Abraham, “Tabyà, balù ge i Amu, nang ge flabè di deg ku lêman agu talù. Kaflingenta dun, ku nun alò tlu falò teenam ditù?” Tmimel i Dwata, “Ku nun teengu tlu falò, làgu falmo dun.” ");
INSERT INTO bps_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Man Abraham, “Balù ge i Amu, fantahaam nawam di deg. Tan ku én alò teenam lwe falò dad to matlu?” Man Dwata, “Ku nun teengu lwe falò dad to matlu, làgu falmo dun.” ");
INSERT INTO bps_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Na lêman talù Abraham, manan, “Tabyà, ge i Amu, bay nang ge flabè di deg, du ani gusen i mangu. Tan kè ku én alò teenam sfalò?” Na tmimel i Dwata, “Ku nun teengu sfalò, làgu falmo dun.” ");
INSERT INTO bps_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kafnge Dwata i Amu na Abraham stulen, mdà Dwata na mulê Abraham. ");
INSERT INTO bps_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Di kakel i lwe to, dunan dad kasaligan i Dwata, ditù di banwe Sodom di kbutang én, sudeng Lat mdadong di gufusuk di syudad di gal gustifun i dad lagi. Di kiten dale, snitongan ale, na lkuad kenen du nafean ale, na manan, ");
INSERT INTO bps_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Lew, begyu slob di gumnègu. Smulu agu du falobyu i blìyu, na ditù i gukudangyu, na fakayyu fadlug di kaguyu fayah flafus.” Kabay tmimel ale, manla, “Too fye di ge, bay balù tadini di lwà i gal guftud dad to magu, ani i gukudangmi.” ");
INSERT INTO bps_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kabay fadlug Lat mlak dale, na taman gagin ale kenen ditù di gumnean. Na ftaga Lat i kakaan flabi, na ftagan fan i landè bol dun yés, na kmaan ale. ");
INSERT INTO bps_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Di là ale fa milè, sanlibut i gumnè Lat i kdee dad lagi, dad lamnok lagi na dad tua lagi mdà di Sodom. ");
INSERT INTO bps_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Tlola Lat, na snalekla, “Tanè i dad lagi magin ge di gumneam flabi ani? Falwaam ale dini di gami, du mimò gami i knayè i lawehmi di dale.” ");
INSERT INTO bps_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kaklinge Lat ani, lamwà kenen, na tnakaban i takab, ");
INSERT INTO bps_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","na manan, “Tabyà di gamu, nang gamu mimò én du too sasè. ");
INSERT INTO bps_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kabay du làgu gagan mngak gamu, na là agu mayè ku nun sasè gaslok i dad to tlang di deg ani, du agu sa mifat dale, taman, falohgu i dad lwe dad ngàgu libun landè fa yaan ani, na nimòyu i knayèyu di dale.” ");
INSERT INTO bps_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kabay balingla man ku Lat, “Nang ge déén, nang ge mlabet di fanmi nimò. Simto ge kè? Mnè ge dini, bay ise ge to mdà di banwe ani. Na ge baling i tamdò gami, ku tan i fakaymi nimò? Nangam banlabal i nimòmi, du fye là baling too sasè fa gaslokam di nimòmi di dale.” Na tuladla Lat, na fdadong ale di takab, du fanla lanbà. ");
INSERT INTO bps_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kabay i lwe kasaligan én, lanwala takab na gasilla dyol Lat salu ditù di lam, na tnakabla i takab. ");
INSERT INTO bps_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kafnge én, du mtulus ale, fbalingla butè i kdee dad lagi ditù di lwà, du fye talàla teen i gusablà i takab. ");
INSERT INTO bps_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Na snalek i lwe kasaligan i Dwata Lat, manla, “Nun kè dad gakedam mnè dini? Ku nun dad ngaam, dad tewem, na dademe dad tom, faginam ale na mdà gamu nan lamwà di banwe ani, ");
INSERT INTO bps_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","du falmomi kadang, du talinge Dwata i Amu, i tulen i dad to gablà di too sasè mgimò i dad to dini. Taman dekan gami dini, du falmo i banwe ani.” ");
INSERT INTO bps_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kaklinge Lat i manla, salu kenen ditù di dad lagi fan mwè i dad ngaan libun, na manan dale, “Faflal gamu lamwà di banwe ani, du fan falmo i Dwata.” Kabay làla fnaglut, du man nawala alò kasfuba Lat. ");
INSERT INTO bps_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Di fan mayè mwal, gnaga i dad kasaligan i Dwata manla, “Faflal ge, faginam i yaanam na lwe dad ngaam libun, na tnagakyu banwe ani, du fye là gamu gagin di kalmon.” ");
INSERT INTO bps_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kabay tì fléét Lat. Taman du Dwata too kamdo dale, damyol i lwe kasaliganan ku Lat, i yaanan, na i dad ngaan libun, na nebela ale ditù di lwà i banwe. ");
INSERT INTO bps_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Di kebela dale Lat ditù di lwà, man i satu kasaligan di dale, “Mila gamu, fye gafles gamu galwà. Nang gamu falê na nang gamu fafanak di gudatal ditù, bay mila gamu salu ditù di dad bulul, du fye là gamu mati.” ");
INSERT INTO bps_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kabay tmimel Lat, manan, “Tabyà di gamu, là agu gmagan. ");
INSERT INTO bps_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Balù too bong kagtabengyu deg, du fye là agu mati, baling agu mati. Là agu gmagan mila ditù di dad bulul, du too mawag. ");
INSERT INTO bps_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Neyeyu, nun banwe là mawag dini, too tukay i banwe atù, na gafat agu ditù du tamdadong. Taman begyu agu fsalu ditù, du fye là agu mati.” ");
INSERT INTO bps_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Na tmimel i kasaligan, manan, “Hae, agin agu i fnim, na làgu kadang fakuf di kalmo i banwe atù. ");
INSERT INTO bps_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kabay faflal ge mila nan, du landè mgimògu ku là ge fa kel ditù.” I banwe atù dnagit Sor, i gumtatekan tukay, du man Lat tukay banwe. ");
INSERT INTO bps_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kakel Lat di banwe Sor tamsut i duh. ");
INSERT INTO bps_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kakelan ditù, fulen Dwata i sandawà i too dminè mdà di langit di dad banwe Sodom na Gomora. ");
INSERT INTO bps_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hae, ani kibò Dwata falmo lwe banwe ani na i klamang datalan. Na i kdee dad to mnè ditù mati, na i kdee dad tmabò di tanà malmo. ");
INSERT INTO bps_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Na yaan Lat falê di dad banwe atù, na di kfaléan mbaling kenen kahì le. ");
INSERT INTO bps_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Di kakwalan too flafus, mték Abraham na samfulê kenen di gutadagan di muna i Dwata. ");
INSERT INTO bps_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Na neyen ditù di gusablà i dad banwe Sodom na Gomora, na di klamang datalan, na teenan i bong mgat buk salu tah mdà di tanà, gambet i buk di bong ntam fnuluk too mgat. ");
INSERT INTO bps_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kabay di kafalmo Dwata i dad banwe di bong datal én, gafaldaman Abraham, taman falwaan Lat di kafalmon i banwe gumnean, du fye là mati. ");
INSERT INTO bps_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Na nun kafye blé Dwata ku Sara, du dnohoan i tafakangan di kenen. ");
INSERT INTO bps_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Hae, du mbaling kenen maltien. Kafnge én, nun tingaan di ku Abraham, balù tatoo tua nan, du tasut i tingàla na lagi. Na sut i tingaan too gaslà di bang i fakang Dwata ku Abraham. ");
INSERT INTO bps_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Na dnagit Abraham i tingaan di ku Sara, dunan Isaak. ");
INSERT INTO bps_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Di gwalu du klon sut Isaak tnulì Abraham, du én i dek Dwata kenen. ");
INSERT INTO bps_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Na di ksut Isaak, mlatu fali Abraham. ");
INSERT INTO bps_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Na man Sara, “Tabanlé agu Dwata klehew, na balù simto mlinge gablà di deg, magin deg lehew.” ");
INSERT INTO bps_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Léan man, “Di muna, simto kè i fakay gamtulen di ku Abraham na satu duh fantutùgu i tingà? Balù tatoo kenen tua, mngà agu fa i tingaan lagi.” ");
INSERT INTO bps_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kafnge én, tatoo lamnok i tingàla Isaak, na taman sankahla tmutù. Di duh kaskahla kenen tmutù, mimò Abraham i bong fista. ");
INSERT INTO bps_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Na Ismaél, i tingà Abraham di ku Hagar, i libun mdà di Idyif, gal madoy i twalin Isaak. Na di kite Sara ani, ");
INSERT INTO bps_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","manan di ku Abraham, “Falwaam dini i lifanam libun na i tingaan, du là fakay ku tingà i lifan dmawat i alel di dad knunam di kfatim, du alò tingàgu i fakay mfun i kdee knunam.” ");
INSERT INTO bps_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na ani gumdà i bong klidù nawa Abraham, du Ismaél i tingaan. ");
INSERT INTO bps_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kabay man Dwata di kenen, “Nang ge too mlidù gablà di tingaam lagi na i lifanam libun Hagar. Fanlingem Sara, na naginam i knayean, du fagu alò di tingaam Isaak dnilègu i too glut dad belam. ");
INSERT INTO bps_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Lêgu banlé kadang i tingaam mdà di lifanam libun, dee dad belan, du fye mbaling ale dee na mgimò i satu bung dad to too mlabung, du kenen i tingaam.” ");
INSERT INTO bps_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Na di kakwalan too flafus, banlé Abraham Hagar knaan, na i gumkah yéél too fnò. Na ftiangan kenen, na fdaan kenen na i tingaan lagi. Mdà ale na salu di banwe landè to dnagit Bérsiba, na lamngab ale déén. ");
INSERT INTO bps_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Na di kti yéélla, tnagak Hagar i tingaan lagi di dungan i tukay kayu. ");
INSERT INTO bps_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Na mili kenen di gumdadongan, i nun kè satu nligo i kawagan, na sudeng kenen ditù. Na di ksudengan déén mlanu, du manan di nawan, manan, “Mati kè i tingàgu kadang, na là agu mayè meye i kfatin.” ");
INSERT INTO bps_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Na Dwata mlinge i kngel i tingaan. Na kaklingen dun, tlo kasaligan Dwata Hagar, mdà di langit, na manan, “Tan kè duenam mlidù? Nang ge likò, du talinge Dwata i klanu i tingaam na teenan i kagkahan. ");
INSERT INTO bps_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tadag ge, na salu ge ditù di tingaam, na nlalam kenen, du fandeegu kadang i dad belan, na mbaling ale sbung dad to too mlabung.” ");
INSERT INTO bps_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kafnge ani, fite Dwata ku Hagar i satu ktufa. Na fananoan i gumkahan yéél, na fninuman i tingaan lagi. ");
INSERT INTO bps_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Too nifat Dwata Ismaél ani kel di kalnokan. Na mnè kenen di gulandè to, na mbaling kenen satu to too fulung dmulak. ");
INSERT INTO bps_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Klon mnè di gulandè to dnagit ku Faran, nalék i yéan i satu libun di Idyif du nimoan yaanan. ");
INSERT INTO bps_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Midul i duh, midul i butang, na tnandak Dwata Abraham. Taman, satu duh tlo Dwata Abraham, manan, “E, Abraham.” Na tmimel Abraham, manan, “Hae Amu, gani agu.” ");
INSERT INTO bps_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Na man Dwata, “Gadègu toom kando Isaak, du kenen alò i tingaam di ku Sara. Kabay faginam, na salu gamu ditù di banwe dnagit Moraya. Ditù di banwe atù fitegu ge i satu bulul, na ditù gumatim kenen, na sduléam snakuf du dsuam di deg.” ");
INSERT INTO bps_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kaklinge Abraham ani, too flafus di kwalan én, tmifak kenen kayu, du dutungan i dsuan. Na nafidan i lmanaf gambet i kudà dnagit dongki, du gumlulenan dad neben. Na faginan Isaak na lwe saligan lagi, na mdà ale salu di banwe gumdek Dwata kenen. ");
INSERT INTO bps_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na di kakel i gatlu duh i kagula, teen Abraham i bulul tamdadong, i bulul gman Dwata kenen. ");
INSERT INTO bps_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Taman manan di dad saligan, “Fatan gamu dini, du neyeyu i dongkiito, du mnagad agu di bulul atù, na fagingu tingàgu, du mangamfù gami di Dwata. Na kafnge én, samfulê gami lêman dini.” ");
INSERT INTO bps_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kafnge én, ftiang Abraham ku Isaak kayu dutung, na mebe kenen i bansung na kisong du to lifoh. Klola magu, ");
INSERT INTO bps_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","talù Isaak di maan Abraham, manan, “E, Mà”. Na tmimel Abraham, manan, “Tan dun Tò?” Snalek Isaak, “Tanun sa dad kayu dutung na lifoh. Kabay landè sa i tingà bilibili fnatita na snakufta, du dsù di Dwata?” ");
INSERT INTO bps_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Na tmimel Abraham, “Tò, Dwata i mlé kadang i klidùta i tingà bilibili dsùta.” Kafnge én, fadlug ale magu. ");
INSERT INTO bps_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kakella di sablà i gman Dwata, mimò Abraham i gudamsù na toon fanse samlasud i dutung di tah i gudamsuan di Dwata. Kafnge én, nagotan Isaak na bnakusan kenen, na filean di tah i dutung. ");
INSERT INTO bps_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Na nwean i bansungan, du fanan fnati i tingaan. ");
INSERT INTO bps_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kabay di fanan kagu mati i tingaan, gasil tamlo kasaligan Dwata i Amu mdà di langit, manan, “E, Abraham, Abraham.” Tmimel Abraham, “Hae Amu, gani agu.” ");
INSERT INTO bps_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Man i kasaligan, “Nangam fanles fnati i tingaam. Ani nan, gadègu too sikof i kimenam Dwata, du balù fa Isaak i sen tingaam di ku Sara, fanam blé di deg.” ");
INSERT INTO bps_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Di keye Abraham di glibutan, teenan i lagi bilibili gasdang i sungketan di sabat. Nwean, bnakusan, fnatin, na sanduléan snakuf, du dsuan di Dwata tlas i tingaan. ");
INSERT INTO bps_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Dnagit Abraham i banwe atù na i gumtatek i dagitan dun, dunan, “Dwata i Amu sa Mlé”. Na balù di bang ani, nun mangman, “Di bulul Dwata, Dwata sa mlé.” ");
INSERT INTO bps_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Na lêman tamlo kasaligan Dwata i Amu, ku Abraham, mdà di langit, ");
INSERT INTO bps_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","na manan, “Du tanimenam agu, na fanam blé di deg i sen tingaam, nun fakanggu di ge ani i toogu dnohò, du deg sa Dwata i Amu i talù di ge. ");
INSERT INTO bps_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ani i fakanggu, toogu mlé i kafye di ge, na toota ge fbel. Na i dad belam kadang, salngad kdee i dad blatik di langit, na salngad kdee i dad falak di kilil i mahin. Satu duh gfisan i dad belam i dad to dmuen dale, na ale baling kadang magot i dad banwela. ");
INSERT INTO bps_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Na fagu di dad belam, mlé agu kafye di kdee dad to, du tanimenam i katedgu ge.” ");
INSERT INTO bps_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kagman Dwata ani, samfulê Abraham na Isaak di dad saligla, na mdà ale mulê salu di Bérsiba, na mnè ale déén. ");
INSERT INTO bps_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Midul i duh, midul i butang, na tatoo tua nan Abraham, na too kenen mablé Dwata i Amu kafye di kdee nimoan. ");
INSERT INTO bps_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Na di satu duh, fngé Abraham i ulu di kdee saligan, na kenen i gusmaligan i kdee nfunan, na manan di kenen, “Fkaham i kmalam di dungan i fuadgu, du ilè fye gadègu toom dnohò i flalògu ge ani. ");
INSERT INTO bps_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kayègu ku makang ge di deg, fagu di dagit Dwata di langit, na di tanà, di kafngabalam kadang i yaan i tingàgu lagi, là ge meye i libun mdà di banwe Kanaan i gumnègu ani. ");
INSERT INTO bps_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kabay salu ge ditù di banwegu, na di dad gakedgu, du ditù gumeyem libun yaan Isaak kadang.” ");
INSERT INTO bps_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kabay smalek i saligan, manan, “Kaflingengu dun, ku là mayè magin dini kadang i libun teengu? Fsalugu ditù kè i tingaam di banwe i gufdum?” ");
INSERT INTO bps_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Na tmimel Abraham, manan, “Nang sa. Nangam fsalu ditù i tingàgu. ");
INSERT INTO bps_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hae, du di muna fa, Dwata i Amu, i Dwata di langit, mdek deg tmagak i dad gaked i màgu, na i banwe gusutgu, na too kenen makang deg i kenen mlé i klamang tanà ani di dad belgu. Taman, Dwata sa febe kadang i kasaliganan malak ge di kagum, du fye ditù gumitem i libun yaan i tingàgu. ");
INSERT INTO bps_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kabay kaflingengu dun, ku là mayè kadang i libun teenam magin ge dini, balù laam dnohò i fankangam deg ani. Kabay balù tan i mkel, nangam fsalu ditù i tingàgu.” ");
INSERT INTO bps_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Taman fkah i saligan i kmalan di dungan i fuad i amun Abraham, na makang kenen toon dnohò i flalò Abraham kenen. ");
INSERT INTO bps_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kafnge én, fafngé i salig i sfalò kamél i amun Abraham, na dee dad fye kalyak, na mdà kenen salu ditù di banwe gumnè i flanek Abraham lagi dnagit ku Nahor déén di Mésofotamya. ");
INSERT INTO bps_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Di kakelan ditù, tatoo flabi nan, na bang i dad libun smulu yéél di ktufa di lwà i banwe ani. Taman déén gufaftudan i dad kamél, mdadong di ktufa. ");
INSERT INTO bps_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Na dmasal kenen, manan, “E, Dwata i Amu, Dwata i amugu Abraham, tnabengam agu, na tabyà dnohoam i fakangam di amugu Abraham, na fitem kenen i kakdom landè kgilin. ");
INSERT INTO bps_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Na tagani agu di ktufa gal gusmulu i dad sawang libun di banwe ani. ");
INSERT INTO bps_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kakella kadang, mni agu yéél di satu sawang libun, na mangu kadang di kenen, ‘Fakay kè ku beg agu minum di tibudam?’ Na ku manan kadang, ‘Hae, fakay ge minum, na agu smulu du finumgu dad kamélam.’ Fye ku ani moon i ilè kenen i tanalékam yaan i lifanam Isaak. Na ku gdohò ani kadang, gadègu tagdohò nan i fakangam di amugu Abraham, na tafitem kenen i kakdom landè kgilin.” ");
INSERT INTO bps_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Di laan fa fnge dmasal, takel i satu sawang libun dnagit ku Rébéka, tmiang i tibudan. Rébéka ani, tingà Bétuél, na Bétuél tingà Mélka lagi. Na Mélka i yaan Nahor, i flanek Abraham lagi. ");
INSERT INTO bps_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Too fye baweh Rébéka ani, na là fa magu di nun yaan. Tamasol kenen ditù di ktufa, na smulu i tibudan, na fanan kagu mulê. ");
INSERT INTO bps_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Taman faflal i salig Abraham smitong kenen, na manan, “Fakay kè ku beg agu minum di tibudam?” ");
INSERT INTO bps_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Na tmimel Rébéka, manan, “Hae amugu, fakay ge minum.” Na gasilan nwè i tibudan tniangan gine na finuman. ");
INSERT INTO bps_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Di kafngen minum, man Rébéka, “Na lêman agu smulu, du finumgu i dad kamélam kel di kabsol i nawala minum.” ");
INSERT INTO bps_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Na gasilan kok i gdè yéél di guminum dad kamél, na mila salu ditù di ktufa du lêman smulu, du fye gamginum i dad kdee kamél i salig. ");
INSERT INTO bps_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Na i salig Abraham tatì fanak, tatì too meye nimò i sawang libun ani, du fye gadean ku Dwata mlé kafye gukel i nagun ani. ");
INSERT INTO bps_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Di kafnge kinum i dad kamélan, mwè i salig i mabtas ulel blawen, fkah di ilung, na i lwe malbang glang blawen, na blén di ku Rébéka. ");
INSERT INTO bps_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Na snalekan kenen, “Libun, simto i maam? Tabyà tulenam deg, fakay kè ku beg gami flo mnè di gumnè maam. Sfayu gami kè i dad dademegu ani di gumnèyu, du fye fakay gami ftud kadang butang?” ");
INSERT INTO bps_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Na tmimel Rébéka, “Màgu dunan Bétuél, i tingà Nahor na Mélka.” ");
INSERT INTO bps_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Na lêmanan man, “Fakay sa ku mnè gamu di gami di butang ani, na nun kwat i gumilè dad kamél na knaan i fkaan dale.” ");
INSERT INTO bps_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kafnge én, lkuad i salig du mangamfù di Dwata i Amu, ");
INSERT INTO bps_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","manan, “Dnayengu Dwata i Amu, i Dwata i amugu Abraham, du too kenen gsalig, na nun kakdon landè kgilin, na dnohoan i fakangan di amugu, na kenen malak dagu di kagugu ditù di gumnè gaked i amugu.” ");
INSERT INTO bps_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Muna Rébéka mila mulê, na tnulenan i yéan na dademe gakedan gablà di kdee i mgimò di kenen. ");
INSERT INTO bps_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Na nun flanek Rébéka lagi dnagit ku Laban. Na faflal Laban smitong i salig Abraham ditù di ktufa. ");
INSERT INTO bps_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Du di kaklingen dun ani gine, na di kiten i ulel di ilungan, na i dad glang di sigal i flanekan, na i kaklingen i manan, gablà di gman i salig Abraham di kenen, taman faflalan snitong i salig ani, na teenan kenen saféd i dad kamélan mdadong di ktufa. ");
INSERT INTO bps_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Na manan di kenen, “Mablé ge Dwata i kafye. Magin ge deg ditù di gumnèmi. Na là gablà ku ge tatì mnè di lwà, du tafnatlagadgu i gumnèyu na gumkahyu i dad kamélam.” ");
INSERT INTO bps_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kaklinge i salig ani, salu ale di gumnèla, na nwèla i dad lulen di dad kamél, na fankaanla. Na banléla yéél i salig Abraham na i dad dademen magin kenen, du alob i dad blìla. ");
INSERT INTO bps_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Di kablé dale i kakaanla, man i salig Abraham, “Là agu kmaan ku làgu fa gtulen ku tan i nagugu.” Na Laban i talù, manan, “Na tulenam gami.” ");
INSERT INTO bps_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Taman man i salig, “Agu i salig Abraham. ");
INSERT INTO bps_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Too mablé Dwata i Amu kafye i amugu na mgimò kenen to nun. Banlén kenen dee dad bilibili, dad kambing, dad baka, dad salafì, dad blawen, dad lifan, dad kamél, na dad dongki. ");
INSERT INTO bps_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Di tatoo ktua Sara, i yaan i amugu, mngà kenen tingà lagi. Na di kenen gumlé amugu Abraham i kdee knunan. ");
INSERT INTO bps_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Fafakang agu i amugu i too dnohògu i flaloan dagu. Fnangan agu malék i libun, du yaan i tingaan, mdà di banwe Kanaan, i banwe gumnean. ");
INSERT INTO bps_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kabay dekan agu samfulê di dad gaked i maan, ditù di dad gutambulan, du ditù kun gumeyegu i libun nimò yaan i tingaan. ");
INSERT INTO bps_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Kafnge én, smalek agu mangu, ‘Kaflingengu dun, ku là mayè magin dini kadang i libun teengu?’ ");
INSERT INTO bps_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Na ani timelan dagu, ‘Dwata i Amu i galgu nimen, faginan i kasaliganan malak ge di kagum, du fye kenen mlé kafye gukel i nagum. Na gweam kadang i libun nimò yaan i tingàgu ditù di dad gutambulgu na i gaked i màgu. ");
INSERT INTO bps_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","“‘Kabay di kakelam ditù di dad gakedgu na ku là ale flinge ge, na ku làla faloh i libun fagin ge dini, balù laam dnohò i fakangam di deg.’ Ani gman amugu Abraham di deg. ");
INSERT INTO bps_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Na di duh ani gine, di kakelgu di ktufa, dmasal agu di Dwata, mangu, ‘E, Dwata i Amu, Dwata i amugu Abraham, ku fakay di ge, begam banlé kafye gukel i nagugu ani. ");
INSERT INTO bps_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tagani agu di ktufa. Na ku nun kadang sawang libun salu dini du smulu, na mangu di kenen, “Fakay kè ku beg agu minum di tibudam?” ");
INSERT INTO bps_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Na ku tnimelan, “Hae, fakay ge minum, na lêman agu smulu du finumgu i dad kamélam.” Fye ku ani moon i ilè kenen i tanalékam yaan i tingà amugu.’ ");
INSERT INTO bps_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Di là agu fa fnge dmasal di Dwata, takel Rébéka tmiang i tibudan salu ditù di ktufa du smulu. Na di kuléan fdu di ktufa mangu di kenen, ‘Libun, begam agu fninum.’ ");
INSERT INTO bps_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Na kaklingen i kafnigu kenen, gasilan nwè i tibud tniangan gine, na manan, ‘Minum ge sa, na lêman agu smulu du finumgu i dad kamélam.’ Taman minum agu, na fninuman i dad kamél. ");
INSERT INTO bps_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Na snalekgu kenen ku simto i maan. Na tmimel kenen manan i maan dunan Bétuél, i tingà Nahor na Mélka. Na kafnge én, nwègu i ulel na i dad glang na blégu kenen. ");
INSERT INTO bps_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Na lkuad agu, du mangamfù agu di Dwata i Amu. Dmayen agu Dwata i Amu, Dwata i amugu Abraham, du nalakan agu di glut dalan, du fye salu agu dini, du nwègu fù i flanek amugu, du nimò yaan i tingaan. ");
INSERT INTO bps_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Na ku kandoyu i amugu, na ku banléyu kenen kafye, tulenyu deg ani. Kabay ku là, lêyu tulen deg, du fye gadègu ku tan i nimògu.” ");
INSERT INTO bps_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Na man Laban na Bétuél, manla, “Tafite Dwata i Amu, i knayean, taman landè dademe gmanmi. ");
INSERT INTO bps_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Fye sa di gami ku nweam Rébéka ani, du fye kenen yaan tingà i amum, du ani sa i knayè Dwata i fiten di gito.” ");
INSERT INTO bps_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Di kaklinge i salig Abraham dun ani, lkuad kenen du nafean na dnayenan Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kafnge én, nukalan i dad kalyak neben, dunan dad kas mdà di salafì na blawen, na dad klaweh, na blén di ku Rébéka. Na blén dad mabtas kandeen di flanekan lagi na di yéan. ");
INSERT INTO bps_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Na kafnge ani, takmaan na minum i salig ani na i dad dademen magin kenen, na kudang ale déén di gumnèla. Na di ktékla di flafus man i salig Abraham, “Mbal agu di gamu, du fan agu mulê di amugu.” ");
INSERT INTO bps_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kabay tmimel i flanekan lagi na i yéan manla, “Faloham Rébéka mnè fa di safédmi kel di sfalò duh. Kafnge én, fakay gamu mdà.” ");
INSERT INTO bps_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kabay man i salig, “Nangyu gami nanggà, du tablé Dwata i Amu kafye gukel i nagugu ani. Kayègu moon ku falohyu gami mdà, du mulê di amugu.” ");
INSERT INTO bps_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Na tmimel ale, manla, “Fngémi funa Rébéka, na snalekmi ku tan i knayean.” ");
INSERT INTO bps_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Taman fafngéla Rébéka na snalekla, “Mayè ge kè nan magin i to ani?” Na tmimel kenen, manan, “Hae, magin agu nan.” ");
INSERT INTO bps_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Taman falohla Rébéka magin i salig Abraham na dad magin kenen. Na faginla i satu tua libun gal mifat ku Rébéka. ");
INSERT INTO bps_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Di là ale fa mdà, mni ale kafye mdà di Dwata, du blé di ku Rébéka, manla, “E, Dwata, begam moon banlé i flanekmi ani dee libu belan. Na fye moon too gfisan i dad belan kadang i kdee dad banwe i dademela sduen.” ");
INSERT INTO bps_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kafnge én, Rébéka na dad saligan libun magin kenen fatlagadla i lulenla. Na smakay ale nan di dad kamél, du magin ale nan i salig Abraham. Kafnge én, kdeela mdà. ");
INSERT INTO bps_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Na di bang ani, Isaak tatì mulê kenen mdà di banwe Bér Lahay Roy salu di banwe Négéb di gumnean. ");
INSERT INTO bps_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Na satu duh too flabi nan, salu kenen ditù di nligon du dmasal, na di ktukengan meye teenan i dad kamél fan kel déén. ");
INSERT INTO bps_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Na Rébéka meye na teenan Isaak. Na tnufan i kamél snakayan. ");
INSERT INTO bps_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Na snalekan i salig Abraham, manan, “Simto kè i déén di nligo i smitong gito.” Na tmimel i salig, “Kenen sa i amugu.” Taman snafang Rébéka i bawehan, du nafean Isaak. ");
INSERT INTO bps_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kafnge én tulen i salig ani ku Isaak i kdee tamgimoan di kagun. ");
INSERT INTO bps_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na nebe Isaak Rébéka ditù di gumnè i yéan Sara. Na kafnge én, sdeme ale, na too bong nawa Isaak ku Rébéka. Na tamaglala nan Isaak gablà di kfati yéan. ");
INSERT INTO bps_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Na ani i santulen gablà ku Isaak i tingà Abraham. ");
INSERT INTO bps_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Na tafat falò fali Isaak di kagwean i yaanan Rébéka, i tingà Bétuél. Bétuél ani, na Laban i flanek Rébéka, mnè ale di Aramaya di Mésofotamya. ");
INSERT INTO bps_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Na Rébéka là mngà, taman dmasal Isaak di Dwata i Amu gablà ani. Na linge Amun Dwata i kafnin, taman Rébéka mbaling maltien. ");
INSERT INTO bps_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Na fingin i kaltienan ani, na di là ale fa sut lyalon i kgal kalyak di lam i tienan. Taman snalekan di nawan, “Tan kè ku ani mgimò di deg?” Taman snalekan di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Na man Dwata i Amu di kenen, “Fingin i tingaam na mbaling ale kadang gutambul i lwe bung dad to. Na dad lwe bung to ani, là satu nawala, sduen ale, taman stani ale. Na kadang satu duh, i satu bung dad to ani nun enegla mdatah di eneg i satu. Na i tingaam twege glifan kadang di twalin.” ");
INSERT INTO bps_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Na kakel i bang i ksut dad ngaan, tasut i tingaan fingin slame lagi. ");
INSERT INTO bps_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","I muna sut too fulè na i lawehan too nun bulan, taman dnagitla kenen Isaw, du too nbul. ");
INSERT INTO bps_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kafnge én, di ksut i twalin, nagotan i takad i twegen, taman dnagitla kenen Dyékob, du dagitan ani fan salngad di satu talù takad. Na di ksutla tanam falò fali Isaak. ");
INSERT INTO bps_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Na talamnok i fingin ani na tasawang lagi ale nan. Na Isaw kenen tambaling kenen fulung dmulak, na lamngab di lam i dlag. Kabay Dyékob kenen fafanak mdadong di slung i gumnèla. ");
INSERT INTO bps_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Na bong nawa Isaak ku Isaw, du too mayè kmaan i dad lmanaf di bnas i gwè Isaw. Kabay bong nawa Rébéka baling ku Dyékob. ");
INSERT INTO bps_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Satu duh, smabew Dyékob i dad blangol fulè, du nimoan uten. Kel Isaw mdà di gumlokan, too kenen bitil. ");
INSERT INTO bps_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Taman manan di ku Dyékob, “Tò, gasilam agu banlé i fulè sabew én, du fan agu mati i kbitilgu.” (Én duenan satu dagit Isaw dunan Idom, gumtatekan fulè.) ");
INSERT INTO bps_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Na tmimel Dyékob, manan, “Làta ge sa banlé silang ku banlém agu untung i dnawatam kadang di kfati màta, du ge tingaan twege.” ");
INSERT INTO bps_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Man Isaw, “Hae, fye sa. Balù deg i tingaan twege, tan i gukmamugu i untung én ku mati agu di kbitilgu ani.” ");
INSERT INTO bps_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Man Dyékob, “Silanggu blé ge ku funa ge smafà na blém di deg i untung tagak màta di ge di kfatin kadang satu duh.” Taman smafà Isaw i blén kadang kun i untung mdà di maan di kfatin. ");
INSERT INTO bps_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kafnge én, banlé Dyékob Isaw fan gagin di sabew blangol. Kmaan na minum kenen, na kafnge én mdà. Taman laan knabas i untung tagak i maan kenen, én baling knabasan i sulê kakaan. ");
INSERT INTO bps_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kafnge en, di taktoo tua Isaak na talaan mite, fngén i tingaan twege Isaw na manan di kenen, “Tingàgu.” Tmimel Isaw, na manan, “Gani agu Mà.” ");
INSERT INTO bps_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Na man Isaak di kenen, “Tatua agu nan, na làgu gadè ku kilen kfatigu. ");
INSERT INTO bps_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Taman mdà ge, na nebem i boholam na sbatam, na ditù ge di bnas na dmulak ge deg. ");
INSERT INTO bps_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Na tnagam kadang én ktaga i toogu kayè, na nebem dini di deg du knaangu. Kafngegu kmaan, mni agu di Dwata, du fye mlé kenen kafye di ge. Ani kayègu nimò di là agu fa mati.” ");
INSERT INTO bps_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kabay Rébéka i yaan Isaak, mlinge i man yaanan di tingaan Isaw. Taman di kdà Isaw salu di bnas du dmulak, ");
INSERT INTO bps_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","man Rébéka di tingaan Dyékob, “Lingegu gine i gman maam di twegem Isaw. ");
INSERT INTO bps_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Na man maam di kenen, ‘Ditù ge di bnas na dmulak ge deg, na tnagam kadang én ktaga i toogu kayè, na nebem dini di deg du knaangu. Kafngegu kmaan, mni agu di Dwata, du fye mlé kenen kafye di ge. Ani kayègu nimò di là agu fa mati.’ Ani gman maam. ");
INSERT INTO bps_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Na Tò, too ge flinge deg, na nimoam i mangu di ge ani. ");
INSERT INTO bps_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ditù ge di dad lmanafito na mebe ge dini lwe mabu tingà kambing, du fye tnatêta na tnagagu kadang, én ktaga too kayè i maam. ");
INSERT INTO bps_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Na di ktagan fakay nebem di kenen, du fye ge baling gamdawat i kafye di kdasalan di Dwata, di là kenen fa mati.” ");
INSERT INTO bps_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kabay man Dyékob di yéan Rébéka, “Yê, gadeam i twegegu Isaw, too nbul, na là agu salngad kenen, du là agu nbul. ");
INSERT INTO bps_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kaflingengu dun, ku nagot agu mà, na ku gadean ise agu Isaw, na man nawan mgaw agu kenen, du flingu agu deg i twegegu, ken mni di Dwata baling kaflayam, na ise kafye i kel di deg.” ");
INSERT INTO bps_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Na tmimel i yéan, manan, “Tò, ku nun sasè kadang kel, ise sa kel di ge, bay di deg baling i gukelan. Taman nimoam i mangu di ge ani, na mebe ge di deg dad kambing.” ");
INSERT INTO bps_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Na taman nimò Dyékob i gman i yéan. Na tnaga i yéan i kambing, én ktaga i too kayè i maan. ");
INSERT INTO bps_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kafnge én, fnalsak i yéan Dyékob i klaweh Isaw too fye, i klaweh busekan déén di gumnèla. ");
INSERT INTO bps_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Na nlabédan dad sigal na lial Dyékob i nlanit kindal i dad kambing gine. ");
INSERT INTO bps_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Na blé i yéan ku Dyékob i fye uten na fan tnagan. ");
INSERT INTO bps_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Na salu Dyékob di maan, na kakelan ditù, manan, “E Mà.” Na tmimel Isaak, manan, “Hae Tò, simto ge kè?” ");
INSERT INTO bps_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Na man Dyékob, “Deg sa i tingaam twege Isaw. Tanimògu i fimoam deg. Beg ge mték mà, du kmaan ge i uten nebegu ge, du fye kadang mni ge di Dwata, du fye mlé kenen kafye di deg.” ");
INSERT INTO bps_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Na lêman talù Isaak, manan, “Tay sa Tò, klalam gamwè dmulak.” Man Dyékob, “Dwata i Amu i fnangamfuam i tmabeng deg.” ");
INSERT INTO bps_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Na kafnge én man Isaak di ku Dyékob, “Fdadong ge di deg du fye gagotta ge, du fye gadègu ge too glut tingàgu Isaw.” ");
INSERT INTO bps_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Na fdadong Dyékob di maan Isaak, na nagotan Dyékob, na manan, “I dad sigalam salngad i sigal Isaw. Kabay i taluam salngad i talù Dyékob.” ");
INSERT INTO bps_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Là dilè Isaak tingaan Dyékob, du i dad sigalan nbul, salngad i dad sigal Isaw. Taman fan mni Isaak i kafye mdà di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kabay di là fa mni Isaak snalekan Dyékob, manan, “Man Tò, too glut kè, ge i tingàgu Isaw?” Tmimel Dyékob, manan, “Hae sa Mà, too glut agu Isaw.” ");
INSERT INTO bps_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Man Isaak, “Na blém di deg i dademe uten nebem deg, du kmaan agu nan. Na kafnge én, mni agu di Dwata kafye blé ge.” Na tablé Dyékob i uten na kmaan maan, na neben di kenen i falami binu na minum. ");
INSERT INTO bps_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kafnge én, man Isaak, “Tò too ge fdadong di deg, na nalakam agu.” ");
INSERT INTO bps_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Di kafdadong Dyékob di maan nalakan kenen. Na kagbun Isaak i klaweh Isaw i lsak Dyékob, dmasal kenen, manan, “Too fye bun i tingàgu, salngad i bun i bnas i mablé Dwata kafye. ");
INSERT INTO bps_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Fnigu di Dwata ku fulenan i tanaam, na ku banlén ge mabu tanà, na ku banlén ge kadang bong ulê i dad flam, na too munge i dad fulem, du fye too gablà i kakaanam na ninumam mdà di tanaam. ");
INSERT INTO bps_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Na lêmangu fni di Dwata ku fdanaan i dee dad to di ge, na toola ge nafè, na ku ge moon mebe kadang i kdee dad bel i dad flanekam, na kdee i dad bel i yéam. Na fanlayam Dwata i kdee dad to madoy ge, na banlén kafye i kdee dad to fafye ge.” ");
INSERT INTO bps_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Na di kafnge Isaak mni kafye di Dwata mdà Dyékob. Na di kdaan, takel Isaw dmulak. ");
INSERT INTO bps_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Na tnatéan i gwean dmulak, na tnagan én ktaga i too kayè i maan, na neben di maan. Na manan di maan, “E, mà, tagani agu, beg ge mték na kmaan ge i gwègu dmulak. Na kafngem kmaan, fakay ge mni di Dwata na kenen i mlé di deg kafye.” ");
INSERT INTO bps_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Na smalek Isaak, “Tò, simto ge kè?” Tmimel Isaw, “Mà, deg sa Isaw, i tingaam twege.” ");
INSERT INTO bps_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Di kaklinge Isaak i tingaan, tatì too kankal du mdà di bong ktikengan. Na manan, “Ku ge Isaw, simto gine kè mebe deg i gwean dmulak kun. Tlabo ani kafngegu kmaan na tamni agu di Dwata du fye banlén kenen kafye, na talàgu fakay nawì i kablé Dwata kafye di kenen.” ");
INSERT INTO bps_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Na kaklinge Isaw ani too mlanu du bong klidù i nawan, na manan di maan, “Mà, lêman ge beg mni di Dwata, du fye mlé di deg kafye.” ");
INSERT INTO bps_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kabay tmimel Isaak, manan, “I twalim Dyékob salu di deg, na fangawan agu. Taman tafngegu mni di Dwata, na tagablé di kenen i kafye, én kafye i blé moon di ge.” ");
INSERT INTO bps_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Man Isaw, “I dagitan Dyékob (i satu gumtatek i dagitan dunan mgaw) too blà kenen, hae, du ani tagalwen dulê mwè i nfungu moon fagu di kafgaw. Di muna fa, tanwean di deg i untung gdawat kadang i tingaam twege di kfatim, na ani lêmanan nwè di deg i kafye dnawatgu moon mdà di Dwata. Mà, nun sa fa kè, beg ge fakay mni moon di Dwata, du fye banlén agu kafye?” ");
INSERT INTO bps_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Na tmimel Isaak, manan, “Tagafnigu di Dwata ku fdanaan ge di kenen, na tagafnigu ku i gakedan mbaling dad saligan. Na gafnigu di Dwata ku mablé kenen fye knê, du fye too bong i kantun na bong falami binun. Tò, talandè dademe kafye i fakaygu fni di Dwata du blén ge.” ");
INSERT INTO bps_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Fadlug Isaw smalek na fakdo di maan, manan, “Mà, too glut kè landè gdè balù satu kafye i fakayam fni di Dwata du fye blén deg?” Na lêman mlanu Isaw, mdà di bong klidù nawan. ");
INSERT INTO bps_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Na tmimel i maan Isaak, manan, “Satu duh mnè ge mawag di too fye tanà, na baling ge mnè di tanà là fafê i alù. ");
INSERT INTO bps_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kabay too ge labè di kasfati, na ani kadang i kfagu kagweam i kanliduam. Na kadang mbaling ge lifan flanekam. Kabay di là ge nan kadang gamtayud, galwà ge di falelan.” ");
INSERT INTO bps_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Na busek Isaw di nawan i knangan i twalin Dyékob, du tagdawat Dyékob i kafye mdà di Dwata i blé moon di kenen. Na man Isaw di kton, manan, “Là mlo mati mà. Na kafnge én, bnanògu twaligu Dyékob.” ");
INSERT INTO bps_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Na di kaklinge Rébéka i tafandam Isaw, fngén Dyékob, na manan di kenen, “Tò, fanlingem agu. I flanekam Isaw mayè malas i tamgimoam di kenen, du falan fandam fanan ge fnati. ");
INSERT INTO bps_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Na taman Tò, toom nimen i mangu di ge ani. Mila ge ditù di flanekgu lagi Laban di banwe Haran. ");
INSERT INTO bps_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Na flo ge mnè di safédan, kel di klana i kaflabè i flanekam ge. ");
INSERT INTO bps_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Na di klifetan kadang i kaflabean ge na i tamgimoam di kenen, nun dekgu i fgadè ge, du fye samfulê ge dini. Na mila ge, du là agu mayè ku lwe gamu sdulê mati di sduh.” ");
INSERT INTO bps_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kafnge én, salu Rébéka di yaanan Isaak, na manan, “Là agu gamtayud i tagnè nimò i dad teweta libun i dad yaan Isaw mdà di banwe Hiti. Ku mwè Dyékob i libun, du nimoan yaanan, gambet i dad yaan Isaw i libun mdà di banwe Hiti, fye fa ku mati agu.” ");
INSERT INTO bps_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kaklinge Isaak i gman Rébéka fngén Dyékob, na dnasalan du banlé kenen kafye na flaloan kenen, manan, “Nang ge mwè yaanam i libun mdà di banwe Kanaan ani. ");
INSERT INTO bps_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Bay baling ge fatlagad, na mdà ge nan salu ditù di banwe Mésofotamya, di gumnè i mà i yéam Bétuél. Ditù gumweam yaanam. Na i nweam yaanam di dad ngà libun Laban i lagi yéam. ");
INSERT INTO bps_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Na blé moon Dwata i too mtulus i kafye di ge, na banlén ge moon dee dad ngà, du mgimò ge mà i dee bung dad to. ");
INSERT INTO bps_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Na blén moon kafye di ge, na di dad belam i salngad kafye fakangan ku Abraham i fuam, du fye kadang di satu duh, gamu sa mfun i banwe i flo gumneito ani, i banwe gablé Dwata ku Abraham.” ");
INSERT INTO bps_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kafngen talù, fdaan Dyékob salu di Mésofotamya ditù di ku Laban tingà Bétuél i to mdà di banwe Aramaya. Na Laban ani lagi Rébéka, i yê Dyékob na Isaw. ");
INSERT INTO bps_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Na gadè Isaw i kdasal Isaak ku Dyékob, du fye blé Dwata kafye di kenen, na fsalun ditù di Mésofotamya, du fye gamwè yaanan ditù. Na gadean di kdasalan kenen fnangan ku Dyékob mwè yaan i libun mdà di Kanaan. ");
INSERT INTO bps_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Na lêman gadè Isaw nimen Dyékob i knayè i maan na yéan, na tamdà nan salu di Mésofotamya. ");
INSERT INTO bps_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ani glabat Isaw di maan i laan lehew i dad libun fdu di Kanaan. ");
INSERT INTO bps_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Taman salu kenen ditù di faan Ismaél tingà Abraham, na mwè fa satu yaanan dnagit ku Mahalat twali Nébayot i tingà Ismaél. ");
INSERT INTO bps_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Na tamdà Dyékob di banwe Bérsiba na salu ditù di banwe Haran. ");
INSERT INTO bps_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Na kakelan ditù di satu banwe, na ftud du takifu nan. Milè kenen na tamdanan di batu. ");
INSERT INTO bps_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Na kamna kenen, i knan ani teenan i bong yaut. Na yaut ani gafdak di tanà kel di tah i langit, na déén gumyak na gumnaul i dee kasaligan Dwata. ");
INSERT INTO bps_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Na teenan Dwata i Amu, tadag di tah i yaut na talù, manan, “Agu sa Dwata i Amu, Dwata i fuam Abraham na Dwata i maam Isaak. Blégu ge na i dad belam kadang i tanà gumileam ani. ");
INSERT INTO bps_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dee kadang i belam salngad i kfung di tanà du là gse. Na satu duh mbel gamu ditù di gusut i duh, na di gusdaf i duh, ditù di gufdu i sabnal, na ditù di gufdu i balat. Na fagu di ge, na i dad belam blégu kafye di kdee dad to di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na samnagin agu ge, na nifatta ge, balù nè i gusalum. Na fasfulêta ge dini di tanà ani. Làta ge tnagak kel di kagdohò i fakanggu di ge ani.” ");
INSERT INTO bps_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Na di kukat Dyékob manan di nawan, manan, “Too glut, dini Dwata i Amu di gusablàgu ani, bay di kakelgu làgu gadè dini kenen.” ");
INSERT INTO bps_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Na likò kenen, na manan, “Tay, gamlikò i gumnègu ani. Ani i too glut gumnè Dwata na ani i gufusuk salu di langit.” ");
INSERT INTO bps_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Na di kaflafusan, too flafus mték Dyékob na nwean i batu gutamdananan na fdakan du nimoan gufaldam i gnagun ani. Na kafnge én nkokan fngalo, du ilè ani i gumangamfù di Dwata. ");
INSERT INTO bps_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Na dnagitan i banwe ani Bétél, du i muna dagit i banwe ani dunan Lus. ");
INSERT INTO bps_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kafnge én, makang Dyékob di Dwata, na manan, “Ku samnagin ge deg na nifatam agu di kagugu, na banlém agu knaan na klaweh ");
INSERT INTO bps_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kel di kulêgu di gumnè i màgu di landè gaslokgu, dnilègu ge i too Dwatagu. ");
INSERT INTO bps_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Na i batu fdakgu gine du nimògu gufaldam i gnagugu ani, nimògu kadang gumangamfù di ge, na blégu di ge satu duh kadang i gasfalò i kdee di dad gablém deg.” Kafnge én, fadlug Dyékob salu ditù di gumnè i faan, di banwe Haran. Na di banwe ani, toon mlo mimò déén. Klon mnè déén nun fat yaanan, én lwe dad ngà i faan, dnagit ku Liya na Rakél. Kafnge én, dee dad ngaan, na too dee nfunan. Kakubu i lwe falò fali i klon di Haran, man Dwata di ku Dyékob, “Samfulê ge di ge banwe Kanaan, na samnagin agu ge.” Taman mdà Dyékob, na i magin kenen i dad yaanan, i dad ngaan, i dad saligan, na i kdee dad lmanafan, na nebela fa i dademe dad nfunan. ");
INSERT INTO bps_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Na fadlug ale Dyékob magu samfulê di banwen, na klo Dyékob magu nun smitong kenen dad kasaligan Dwata. ");
INSERT INTO bps_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Na di kiten dale, manan, “Ani sa i gumnè i dad sundalu Dwata.” Na dnagitan i gumnè ani dunan Mahanaim. ");
INSERT INTO bps_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Na nun dekan muna di flanekan Isaw déén di banwe Idom. ");
INSERT INTO bps_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Na mdek Dyékob, manan, “Di kakelyu kadang, ani manyu di flanekgu Isaw i nafègu, manyu, ‘Deg sa Dyékob i lifanam. Di klon ani, ditù gumnègu di saféd i fàta Laban, na là agu gulê di banweta kel ani. ");
INSERT INTO bps_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Sadni too dee dad bakagu, dad dongki, dad bilibili, na dad kambing, na nun fa dee dad lifangu. Na fgadègu di ge kdee ani i flanekgu, du fye kandom agu na too ge lehew moon smite deg.’ ” ");
INSERT INTO bps_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Na di kasfulê i dad to dek Dyékob, manla di kenen, “Tasalu gami ditù di flanekam Isaw. Na tadéén kenen smitong ge, na faginan fat latu dad lagi.” ");
INSERT INTO bps_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Na di kaklinge Dyékob i santulenla ani, too sè klikoan na too msamuk i nawan. Taman nalelan i dad to magin kenen di lwe lumbuk, na nalelan i dad bilibilin, dad kambingan, dad bakan, na i dad kamél di lwe lumbuk. ");
INSERT INTO bps_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Du i fandam Dyékob, “Ku fanngayu Isaw i slumbuk, ken galwà i satu lumbuk.” ");
INSERT INTO bps_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kafnge én, dmasal Dyékob di Dwata, manan, “Ge sa Dwata fnangamfù i fùgu Abraham, na i màgu Isaak. E, Dwata i Amu, tagmanam di deg samfulê agu di banwegu na di dad gakedgu, na fakangam deg nun blém deg kafye. ");
INSERT INTO bps_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Deg sa i lifanam. Là agu gablà dmawat i kafye tagablém deg, i kifatam na i kakdom landè kgilin. Di muna fa, di kilagu di banwegu na mifal agu i yéél Dyordan, landè nebegu galwà di tugadgu. Kabay ani, fye knègu du di kulêgu ani nun lwe lumbuk i dad lmanafgu na i dad ngàgu na i dad yaangu. ");
INSERT INTO bps_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Fakdogu di ge Dwata, begam agu falwà di falel i flanekgu Isaw. Too agu likò, du kenan gami fanngayu, na kenan agu fnati gakuf i dad yaangu na i dad ngàgu. ");
INSERT INTO bps_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kabay tafankangam di deg banlém agu kafye, na toom fdee i belgu gambet i falak di kilil mahin i là gse.” ");
INSERT INTO bps_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Di kdasal Dyékob di Dwata, déén gukudangan di kilil yéél Dyabok di butang én. Na di kwalan, nalékan i dademe di dad lmanafan, du fye nun dad blén kadang di flanekan Isaw. ");
INSERT INTO bps_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Na i tanalékan dunan, lwe latu libun kambing, na lwe falò i lagi, lwe latu libun bilibili, na lwe falò i lagi, ");
INSERT INTO bps_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tlu falò libun kamél gagin i dad ngàla, fat falò libun baka na sfalò i lagi, lwe falò libun dongki na sfalò i lagi. ");
INSERT INTO bps_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Na faslumbuk Dyékob i dad lmanaf ani, na nun dad lifanan fifatan i kat lumbuk. Na manan di dad lifanan ani, “Gamu i muna, na kat lumbuk stadol, bay beg gamu sawag.” ");
INSERT INTO bps_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Na manan di lifanan gsen muna di kdee, manan, “Di kagsitongyu i flanekgu Isaw, na ku snalekan gamu ku simto i uluyu, na nè gusaluyu, na simto mfun i dad lmanaf nebeyu, ");
INSERT INTO bps_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tooyu tnimel kadang manyu, ‘I dad lmanaf ani nfun i lifanam Dyékob. Feben i kdee ani du blén ge. Na tadéén i flanekam Dyékob di fulé.’” ");
INSERT INTO bps_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Na kafnge én i gmanan gine di satu lifanan, én sa manan di kdee dademe dad lifanan i gamtadaol déén i dad mebe i dad lmanaf atù, manan, “Di kagsitongyu i flanekgu kadang, ");
INSERT INTO bps_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ani tooyu man di kenen, ‘I lifanam Dyékob tadéén di fulé!’” Ani sa i kated Dyékob dale gine, du man i nawan, “I kdee blégu i febegu muna, gaflaneb moon i nawan. Na di ksitemi kadang, nlifetan moon i salàgu di kenen.” ");
INSERT INTO bps_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Taman dek Dyékob muna i dad lifanan mebe i dad blén di flanekan, bay mnè kenen fa déén di butang én. ");
INSERT INTO bps_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Di butang én, tafifal Dyékob di yéél Dyabok lwe yaanan, lwe lifanan libun, na i sfalò satu dad ngaan lagi. ");
INSERT INTO bps_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Takifalla, fifalan fa kdee nfunan. ");
INSERT INTO bps_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kabay kenen laan fa mifal, aloan satu ftagak déén. Kafnge én, nun msut di ku Dyékob, na nagotan kenen, na sbunù ale kel i fan mayè mwal. ");
INSERT INTO bps_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Di kgadè i to atù laan gagan misan ku Dyékob, nagotan di fangkulan na mbaling masléhê. ");
INSERT INTO bps_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na man i to én, “Kaham agu du fan mwal.” Kabay tmimel Dyékob, manan, “Silangta ge kah, ku funa ge mlé deg kafye.” ");
INSERT INTO bps_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Na smalek i to én, manan, “Simto dagitam kè?” Na man Dyékob, “Agu sa Dyékob.” ");
INSERT INTO bps_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Na man i to én, “Mdà ani ise ku Dyékob i katlo ge, bay Israél, du tasbunù ge Dwata na i dad to, na là ge gfisan.” ");
INSERT INTO bps_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Man Dyékob, “Begam tulen deg ku simto ge kè?” Kabay tmimel i to atù, manan, “Kan kè smalek ge deg ku simto agu.” Kafnge én, banlén kafye Dyékob. ");
INSERT INTO bps_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Taman dnagit Dyékob i banwe én dunan Finyél, du manan, “Tateengu baweh Dwata, bay knean là agu mati.” ");
INSERT INTO bps_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Di ksut i duh, mdà Dyékob di Finyél na magu dà sag, du masléhê i fangkulan. ");
INSERT INTO bps_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ani duenan, balù kel ani i bel Israél là kmaan i kalngat i fangkul i dad lmanaf knatêla, du déén gumagot Dwata ku Dyékob. ");
INSERT INTO bps_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Na meye Dyékob ditù di dalan, na teenan Isaw na i fat latu dad lagi magin kenen. Na di kite Dyékob, mawag fa, fifatan i dad ngaan di dad yaanan Liya, Rakél, na i lwe lifanan libun. ");
INSERT INTO bps_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Santadolan ale, fkahan di muna i dad lifanan libun na i dad ngàla, na gamtadol Liya na i dad ngaan, na Rakél na tingaan lagi, Dyosif, fkahan ditù di sangal fulé. ");
INSERT INTO bps_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kafnge én, muna Dyékob di kdeela. Na kagdadong Isaw smitong Dyékob, na lkuad kenen fitu dulê du mafè kenen. ");
INSERT INTO bps_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kabay Isaw, sadlu kenen smitong ku Dyékob na lkafan na nalakan. Na sngel ale. ");
INSERT INTO bps_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kafnge én, teen Isaw i dad libun na i dad ngà na snalekan, “Simto i dee dad to magin ge?” Na tmimel Dyékob, manan, “Flanekgu, ani sa i dad ngà blé Dwata di lifanam fagu di kakdon.” ");
INSERT INTO bps_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kafnge én, i dad lifanan libun na i dad ngàla fdadong di ku Isaw, na lkuad ale di munan, du mafè kenen. ");
INSERT INTO bps_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Na gamtadol Liya na i dad ngaan na lkuad ale di munan. Na sangal fulé Dyosif na Rakél, na balù ale lkuad di munan. ");
INSERT INTO bps_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Na lêman smalek Isaw, manan. “Gsitonggu gine too dee dad lmanaf, i tan i gukmamum dun?” Tmimel Dyékob, “Flanekgu, blégu ge du fye ken kandom agu, na too ge lehew moon smite deg.” ");
INSERT INTO bps_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kabay man Isaw, “Flanekgu, too dee sa i deg, taman ge nan mfun dale.” ");
INSERT INTO bps_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Man Dyékob, “Là, ku kandom agu dnawatam i bléta ge. I kagdawatam deg gine, sadi gambet i kagdawat Dwata deg, du too ge lehew baling smite deg. ");
INSERT INTO bps_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Begam dnawat i blégu ge, du tagablé Dwata di deg i kafye, na tagablén di deg kdee klidùgu.” Na du too fakdo Dyékob, dnawat Isaw i dad blén. ");
INSERT INTO bps_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kafnge én, mlak Isaw ku Dyékob, manan, “Na Lew, mdà ito nan, magin agu gamu.” ");
INSERT INTO bps_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kabay tmimel Dyékob, manan, “Flanekgu, gadeam i dad ngàgu, tukay ale fa, na nun fa dad bilibili na dad baka mliton, na là fakay ku làgu ale too nifat. Du ku nleges ale faflal magu balù alò sdu, mati i kdeela. ");
INSERT INTO bps_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Taman flanekgu, muna ge nan, na tì gami beg fléét mlalò ge. Én i tnagenmi i lal i dad lmanaf ani na i dad ngàgu kel di gnumahmi ge ditù di banwe Idom.” ");
INSERT INTO bps_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Na man Isaw, “Ku én, na tnagakgu ge i dad dademe dad togu du fsalngangu ge.” Kabay man Dyékob, “Bayaam sa, nangam fsamuk i nawam, balù alò gami magu. Du talehew agu nan, du gine too ge lehew smite deg.” ");
INSERT INTO bps_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Taman di duh én, mdà Isaw mulê di banwe Idom. ");
INSERT INTO bps_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kabay ale Dyékob baling fadlug ditù di banwe Sukot, na ditù mimò kenen gumnean na gufsilungan i dad lmanafan. Taman dnagit i banwe atù Sukot, du nun dad gufsilung i dad lmanaf. ");
INSERT INTO bps_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Na di kulê Dyékob mdà di banwe Mésofotamya, fadlug ditù di syudad Sikim di Kanaan, na landè sasè gaslokan di dalanan. Na mnè kenen flo di datal mdadong di syudad. ");
INSERT INTO bps_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Na bnayadan i tanà ani, na i btasan mlatu salafì di filakla. Na i dad to i gumwean dun, dunan i dad bel Hamor i mà Sikim. ");
INSERT INTO bps_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Na déén di tanà ani gumimoan i gudamsuan di Dwata, na dnagitan Él Élohi Israél, dunan i Dwata Israél. ");
INSERT INTO bps_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Na Dyékob tamnè di Kanaan, i banwe i gumnè i maan. ");
INSERT INTO bps_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Na ani i santulen gablà i dad ngà Dyékob. Na tasfalò fitu fali Dyosif, na tnabengan i dad twegen mifat i dad lmanaf i màla. Na dad twegen ani dad ngà di dademe yaan Dyékob dunan Bilha na Silfa. Satu duh, salu Dyosif di maan, du tulenan kenen gablà di sasè nimò i dad flanekan. ");
INSERT INTO bps_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na Israél, dunan Dyékob, di kdee dad ngaan, Dyosif i toon kando, du silang sut Dyosif di tatoo tua. Taman fimoan i too fye baweh tahà klaweh ku Dyosif, gal lafin di tah saulan. ");
INSERT INTO bps_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Na di kgadè dad flanek Dyosif, too kenen kando i màla mdatah fa di kakdon dale, mnang nawala kenen, na landè fye ktalùla di kenen. ");
INSERT INTO bps_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Di satu butang, kamna Dyosif. Na di ktulenan i dad flanekan lagi gablà di knan, too lumban fa i knang nawala kenen, ");
INSERT INTO bps_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","du manan, “Fanlingeyu gablà di knagu. ");
INSERT INTO bps_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kdee ito mimò di nligo, na bnatangito dad fali tamgateh. Na makto tadag i deg bnatang, na i gamu bnatang samlibut i deg bnatang, na lkuad ale du nafèla.” ");
INSERT INTO bps_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Na man i dad flanekan lagi, manla, “Tay, man nawam kè ku ge kadang i ulu magot gami?” Na too matnù i knang nawala kenen, du mdà di knan na i ktulenan dun di dale. ");
INSERT INTO bps_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Na satu butang lêman kamna Dyosif, na tulenan di dad flanekan lagi, manan, “Fanlingeyu, lêman agu kamna. Na ani knagu, i duh, bulen, na sfalò satu blatik lkuad di munagu, du nafèla agu.” ");
INSERT INTO bps_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Di ktulenan i knan di maan, nngak kenen i maan Dyékob manan, “Tan kè i gumtatek i knam ani? Kayeam man kè ku agu, na yéam, na i dad flanekam, slame gami kadang lkuad di munam du mafè ge?” ");
INSERT INTO bps_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Na dad flanek Dyosif ani, too mingà nawala kenen, bay i maan fadlug faldam ku tan i gumtatek i knan. ");
INSERT INTO bps_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Na satu duh, salu dad flanek Dyosif mdadong di Sikim, du ftebla dad lmanaf i màla. ");
INSERT INTO bps_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na talù Dyékob di ku Dyosif, manan, “Tò, ditù i dad flanekam di Sikim, du guftebla i dad lmanaf. Laloam ale du nlauyam.” Tmimel Dyosif manan, “Hae mà, fakay sa.” ");
INSERT INTO bps_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Na man Dyékob, “Toom ale nlauy, du neyem ku fye kagkahla.” Na neyem fa i dad lmanaf nifatla. Kafnge én, samfulê ge du fye gadègu i kagkahla. Taman mdà Dyosif di banwe Hibron salu di Sikim. Na di kakelan di Sikim, ");
INSERT INTO bps_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","nun to mite kenen lamngab di gal gufteb i dad lmanaf, du fanngabalan i dad flanekan. Na snalek i to ani Dyosif, manan, “Tan i fanngabalam?” ");
INSERT INTO bps_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Na tmimel Dyosif, manan, “Fanngabalgu i dad flanekgu. Gadeam kè ku nè gusablà guftebla i dad lmanaf?” ");
INSERT INTO bps_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Man i to én, manan, “Dini ale di muna, bay lingegu i manla mili ale kun di banwe Dotan.” Di kaklinge Dyosif ani, fadlug kenen salu di Dotan, na ditù gumiten i dad flanekan. ");
INSERT INTO bps_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Na balù mawag fa Dyosif, tateen kenen i dad flanekan, na fandamla ku tan kibòla mati kenen. ");
INSERT INTO bps_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Na stulen ale manla, “Tadéén i to gal kamna. ");
INSERT INTO bps_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Faflal ito, fnatiito kenen na ftatek di satu mngalam sol landè yéél. Manito kadang fnati i lmanaf di bnas. Hae, neyeito sa kun, ku gdohò i dad knan.” ");
INSERT INTO bps_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kaklinge Rubén i gman i dademe dad flanekan, kayean ku tnabengan Dyosif. Taman manan, “Nangito fnati. ");
INSERT INTO bps_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Nangito fatduk. Tatiito alò ftatek di gumngalam sol landè yéél dini di banwe landè to.” Na man Rubén ani, du kayean falwà kadang Dyosif, na neben mulê di maan. ");
INSERT INTO bps_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Taman di kakel Dyosif di dad flanekan atù gine, ktusla i too fye baweh klaweh lafinan di tah. ");
INSERT INTO bps_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kafnge én, nebela kenen di mngalam sol landè yéél, na ftatekla kenen di lam. ");
INSERT INTO bps_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kafngela mimò dun ani, di slengla kmaan, teenla dad to sbayad i dad bel Ismaél, mlius déén fdu di banwe Galaad. Na nun lulenla dad fablila di tah dad kamélla, dad anag, na dad bulung mdà di kayu, du nebela di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Na man Dyuda di dad dademe flanekan, manan, “Ku fnatiito na buniito, landè sa kagweito. ");
INSERT INTO bps_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kabay fye fa, ku fabliito di dad bel Ismaél atù. Là sa fakay ku fnatiito, du kenen sa flanekito na alò satu maito.” Na masnagin i nawala di fandam Dyuda. ");
INSERT INTO bps_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Taman di kakel i dad to sbayad, i mnè di banwe Midian, i dad flanek Dyosif mlakun kenen di tah, na fablila kenen. Alò lwe falò batu salafì i kbayad i dad bel Ismaél kenen. Na di kafablila kenen, fagin i dad to sbayad di Idyif. ");
INSERT INTO bps_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Du là gakuf Rubén di kafablila ku Dyosif, taman salu di mngalam sol, du fanan falwà Dyosif, bay landè teenan to ditù di lam. Taman knaséan i saulan, du mdà di sasè kliduan. ");
INSERT INTO bps_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Na salu kenen di dad flanekan, na manan, “Là sa déén Dyosif. Tan i kibògu?” ");
INSERT INTO bps_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kafnge én, fnatila i kambing na lnabla i klaweh Dyosif di litè kambing ani gine. ");
INSERT INTO bps_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Na nebela i too fye klaweh Dyosif ani mulê di màla, na manla, “Teenmi i klaweh ani. Ise kè klaweh Dyosif?” ");
INSERT INTO bps_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Na dilè Dyékob i klaweh én, na manan, “Hae, ku Dyosif ani. Nun kè beg lmanaf di bnas mati kenen, na sankan i lawehan.” ");
INSERT INTO bps_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Na knasè Dyékob i klawehan na dmaféng i saku, du gufiten i too sasè klidù nawan ku Dyosif. Na too mlo là gwe di nawan i kliduan. ");
INSERT INTO bps_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Na i kdee dad ngaan lagi na libun, salu di kenen du mlala kenen du fye magwè klidù i nawan. Kabay balingan man, “Du tamati sa Dyosif, là magwè di nawagu i klidùgu kel di kfatigu.” Taman fadlug mngel Dyékob ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Na samfuleito di ku Dyosif na i dad to mdà di Midian. Di kakella di banwe Idyif, fablila Dyosif di ku Fotifar i satu ganlal Faraon, i harì di banwe Idyif. Na Fotifar ani ulu di dad sundalu gal munung i bong gumnè Faraon. ");
INSERT INTO bps_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Na di kebe i dad bel Ismaél ku Dyosif ditù di banwe Idyif, fablila ku Fotifar. Fotifar ani satu ganlal Faraon, i harì di Idyif, na kenen ulu di dad sundalun. ");
INSERT INTO bps_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kabay Dwata i Amu, samnagin ku Dyosif, na i kdee nimoan slame fye. Na mnè kenen di gumnè i amun, Fotifar, to mdà di Idyif, du nlifan déén. ");
INSERT INTO bps_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Na teen Fotifar samnagin Dwata i Amu ku Dyosif. Hae, du mdà di kasnagin i Dwata kenen, én duenan too fye kgimoan i kdee nimoan. ");
INSERT INTO bps_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Taman too lehew Fotifar kenen, na nimoan kenen lifanan gal tmabeng kenen. Nimoan kenen to gusmaligan i kdee dad to di gumnean na i kdee dad nfunan. ");
INSERT INTO bps_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Na mdà én, fagu di ku Dyosif, banlé Dwata kafye Fotifar, taman matnù i nfunan, balù di gumnean ku demen di dad fulen demen i dad lmanafan. ");
INSERT INTO bps_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Di ku Dyosif i gusmaligan i kdee nfunan, na du saligan i kdee di kenen, landè dademe fandaman galwà di kakaanan. Na Dyosif satu too fye baweh lagi na mgal i lawehan. ");
INSERT INTO bps_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Taman là mlo, i yaan Fotifar mibal ku Dyosif, na manan kenen, “Sasatu ite milè.” ");
INSERT INTO bps_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kabay là mayè Dyosif, na tnimelan, manan, “Landè dademe fandam i amugu, du deg sa i lifanan. Na i kdee nfunan tagsaligan di deg. ");
INSERT INTO bps_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Sadi salngad i glalgu di kenen glal dini di gumnean ani. Na landè dini i klenan deg galwà ge, du ge sa i yaanan. Taman là agu mayè mimò i too sasè nimò, du là fakay ku gamsalà agu di Dwata.” ");
INSERT INTO bps_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na balù kat i duh too nlak yaan Fotifar Dyosif mimò knayè i lawehan, laan fanlinge, na laan nagin i knayè libun ani. ");
INSERT INTO bps_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kabay di satu duh, fusuk Dyosif di lam i gumnè én, du mimò i nimoan, na gaslà i ndè dademe dad lifan déén. ");
INSERT INTO bps_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kite i yaan Fotifar kenen, nafasan di lafin klawehan, na manan, “Magin ge deg milè.” Kagmanan ani, gtagak Dyosif i lafin klawehan di kmal i libun ani, du mila di gumnè. ");
INSERT INTO bps_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Di kite yaan Fotifar i tnagak Dyosif i saulan na mila, ");
INSERT INTO bps_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tlon i dad dademe lifan i mimò di gumnean, na manan di dale, “Neyeyu, i to Hibru tanebe i yaangu dini, fyaan gami. Fusuk kenen di sibaygu gine, du kayean mimò i knayean di deg, bay mkit agu. ");
INSERT INTO bps_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Di kaklingen i kitgu, mila kenen na gtagakan i saulan ani.” ");
INSERT INTO bps_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Na busek yaan Fotifar i saul Dyosif kel di kulê i yaanan. ");
INSERT INTO bps_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Na kakel i yaanan salngad i santulenan kenen, manan, “I lifan Hibru i tanebem dini, fusuk kenen di sibaygu, du kayean mimò sasè di deg. ");
INSERT INTO bps_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kabay, mkit agu, na taman gila na gtagakan i saulan ani.” ");
INSERT INTO bps_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Di kaklinge amu Dyosif i gman yaanan gablà di nimoan, too sasè i kaflabean ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Taman fakfean Dyosif na fbilangguan, fasbool di dad to bnilanggù i harì. Kabay klon déén di bilanggù, ");
INSERT INTO bps_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","là tlag kasnagin Dwata i Amu di kenen, na i kakdon landè kgilin fiten ku Dyosif, du balù i to gal munung i bilanggù too lehew ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Taman blén ku Dyosif glal mebe i kdee dad to bnilanggù, na balù i kdee nimò di lam i bilanggù kenen mebe. ");
INSERT INTO bps_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Na du Dyosif i magot i kdee di lam i bilanggù, landè ksamuk i nawa i to gal munung. Hae, du Dwata sa i samnagin ku Dyosif, taman slame fye i kdee nimoan. ");
INSERT INTO bps_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kafnge én, nun satu lifan i harì di Idyif, i gal mebe i binun di kenen, na nun satu lifanan gal tmaga fan. Na satu duh gamsalà ale di amula, dunan harì di Idyif. ");
INSERT INTO bps_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Na too flabè Faraon di lwe to ganlal ani. ");
INSERT INTO bps_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Taman fbilangguan ale ditù di gumnè i ulu di dad to gal munung déén di gumilanggù ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Na Dyosif blé i ulu di dad gal munung, di dad ganlal atù gine, du kenen mgimò saligla. Na too mlo ale bnilanggù déén. ");
INSERT INTO bps_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Na satu butang, kamna i to gal mebe binu, na kamna i to gal tmaga fan, na sahal i knala, na sahal i gumtatek i knala. ");
INSERT INTO bps_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na di klauy Dyosif dale di flafus, dilean sebe nun gamsamuk nawala. ");
INSERT INTO bps_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Taman snalekan ale, “Tan kè i gamsamuk i nawayu?” ");
INSERT INTO bps_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tmimel ale, manla, “Kamna gami, bay landè gamtulen gami ku tan i gumtatek i dad knami ani.” Na man Dyosif, “Alò Dwata fakay mlé gnagan di satu to, du fye kenen mubad i dad kna. Na sa kun, ku fakay tulenyu deg ku tan i knayu.” ");
INSERT INTO bps_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Na i gal mebe binu i muna tmulen i knan ku Dyosif, manan, “Ani i knagu, teengu di munagu i walad grép, ");
INSERT INTO bps_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","na di walad atù nun tlu fangan funa dmoon, mulek, munge, na mbaling taga i dad bungen. ");
INSERT INTO bps_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na i tabù Faraon nagotgu, na kafnge én, mifò agu i dad bunge grép, na fanlàgu i yéélan di tabù, na blégu tabù ku Faraon.” ");
INSERT INTO bps_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Na man Dyosif, “Gadègu i gumtatek i knam ani, na ani i dunan, i tlu fanga gumtatekan tlu duh. ");
INSERT INTO bps_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Du kubu kadang i tlu duh, fatlo ge Faraon, na nlifetan i salaam, falwaan ge di bilanggù, na fasfuléan ge di tagnè nimoam. Lêman ge mebe i binu di kenen. ");
INSERT INTO bps_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kadang di kafye kagkaham lêman, toom agu fandam, na kandom agu. Begam tnulen Faraon gablà di deg, du fye began agu falwà di bilanggù ani. ");
INSERT INTO bps_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hae, du tì agu tangal mdà di mawag banwe i gumnèmi gami dad to Hibru, na balù landè mgimògu sasè dini, bay knean dini agu bnilanggù di banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Na di kaklinge i to gal tmaga fan i harì, too fye gumtatek i kna i to gal mebe binu, manan di ku Dyosif, “Nun sa deg kna. Smudù agu kun i tlu balyas fan. ");
INSERT INTO bps_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I balyas too sangal tah nun dee bung fan kene Faraon, bay knaan i dad anuk di bnas.” ");
INSERT INTO bps_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Na tmimel Dyosif kenen, manan, “Ani i gumtatek i knam, i tlu balyas dunan tlu duh. ");
INSERT INTO bps_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kafnge tlu duh fatlo ge Faraon, na faklangan i ulum, fatlawéngan i laweham di kayu, na ungadam knaan i dad anuk di bnas.” ");
INSERT INTO bps_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Na di gatlun duh, fimò Faraon i fista i kdee dad ton nun glal, du duh ksutan. Na fatlon i to gal mebe i binu na i to gal tmaga fan ditù di muna i dad dademe ganlalan. ");
INSERT INTO bps_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Na i to gal mebe binu, fasfulé Faraon di tagnè nimoan, na lêman kenen mebe binu di ku Faraon. ");
INSERT INTO bps_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kabay i to gal tmaga fan, fatlawéng Faraon. Na i kdee gman Dyosif di dale tagdohò. ");
INSERT INTO bps_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kabay i to gal mebe binu gamlifet ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Na kakubu i lwe fali, kamna Faraon. Na di knan, di slengan tadag di kilil i yéél dnagit Nilu, ");
INSERT INTO bps_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","nun fitu baka too fye baweh na too mabù msut mdà di yéél, na mteb ale i dad sabat di kililan. ");
INSERT INTO bps_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kafnge én, lêman nun fitu baka msut mdà di yéél Nilu, bay too sasè baweh na too lahan, na samdan ale tadag di dad baka mabù di kilil i yéél. ");
INSERT INTO bps_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Na knaan i dad baka lahan atù gine, i dad baka mabù. Kafnge én, tagukat Faraon. ");
INSERT INTO bps_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kabay lêman gkudang kenen, na lêman kamna. Na di knan teenan sbung fali dnagit trigu, na di skigan nun fitu tlangan, na too malbang na too fye baweh. ");
INSERT INTO bps_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Là mlo nan, nun tmabò fitu tlanga, bay kufas mdà di too mgal na too minit i nus mbal fdu di banwe gulandè to. ");
INSERT INTO bps_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Na fanlo i fitu tlanga kufas gine, i fitu tlanga i too malbang. Kafnge én, mukat Faraon, na gadean kamna. ");
INSERT INTO bps_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kabay, di kaflafusan too msamuk i nawa Faraon mdà di knan. Taman fngén i kdee dad to fulung mubad i kna, na dademe dad fulung faldam déén di banwe Idyif. Tulenan dale i dad knan, bay landè balù satu di dale i gamtulen kenen ku tan i gumtatek i dad knan. ");
INSERT INTO bps_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kafnge én, man i to gal mebe i binu ku Faraon, manan, “Amu, ani gafaldamgu gablà di salàgu di muna. ");
INSERT INTO bps_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Muna fa, flabè ge di deg na di to gal tmaga fan, na fbilangguam gami, di gumnè i ulu di dad sundalu i gal munung. ");
INSERT INTO bps_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Na satu kifu kamna gami, bay i gumtatek i knami sahal. ");
INSERT INTO bps_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na nun satu sawang lagi Hibru ditù, lifan i ulu i dad sundalu gal munung i bong gumneam ani gbol di gami. Na tulenmi kenen i knami, na nubadan di gami. ");
INSERT INTO bps_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na kdee i gmanan too gdòhò, du agu gasfulê di tagnè nimò, na i to gal tmaga fan fatlawéngam.” ");
INSERT INTO bps_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Taman di kgadè Faraon ani, fngén Dyosif, na gasilla falwà di bilanggù. Di kafnge Dyosif mdis i kumin, na gamgili i klawehan, salu kenen di muna i harì. ");
INSERT INTO bps_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Na man Faraon ku Dyosif, “Satu butang kamna agu, na landè to gamtulen deg ku tan i gumtatekan. Kabay lingegu, ge gamgubad i dad kna.” ");
INSERT INTO bps_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tmimel Dyosif, “I kfulung mubad i dad kna ise mdà di deg, bay alò Dwata gafgadè ge i gumtatekan, du fye nun gufyem.” ");
INSERT INTO bps_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Na man Faraon, “Kamna agu tadag agu di kilil i yéél Nilu, na slenggu tadag déén, ");
INSERT INTO bps_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","nun fitu baka too mabù na fye baweh, msut mdà di yéél, na mteb sabat di kilil i yéél ani gine. ");
INSERT INTO bps_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Na lêman nun fitu baka msut mdà di yéél, bay too lahan na sasè baweh. Làgu lmen mite i too sasè klahan dad baka ani dini di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kafnge én, knaan dad baka lahan i dad fitu baka mabù. ");
INSERT INTO bps_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kabay balù mtila knaan, sadi landè knaanla, du lahan fa di kitegu dun. Kafnge én, gukat agu. ");
INSERT INTO bps_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Na lêman agu kamna, na teengu satu fali dnagit trigu, na fitu tlanga tmabò di skigan, na too malbang na fye baweh. ");
INSERT INTO bps_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kafnge én, lêmangu teen i fitu tlanga tmabò, bay mlanas na kufas tlangan, mdà di too mgal na minit i nus, mbal fdu di banwe gulandè to. ");
INSERT INTO bps_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Na fanlo i dad fitu tlanga kufas ani gine, i dad fitu tlanga too malabang. Na tulengu dad knagu ani, di dad to fulung mubad i dad kna, kabay landè di dale gmadè mubad dun.” ");
INSERT INTO bps_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Na man Dyosif di ku Faraon, “I lwe dad knam ani, satu alò gumtatekan. Tafgadè Dwata ge i fanan nimò. ");
INSERT INTO bps_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","I fitu too mabù baka, na fitu tlanga fali malbang, i gumtatekan fitu fali. Nun alò satu gumtatek i dad knam. ");
INSERT INTO bps_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na i fitu baka lahan gamtadol i fitu baka mabù, na i dad fitu tlanga i fali kufas, mdà di kgal na kinit i nus, fdu di banwe gulandè to, i gumtatekan fitu fali bong bitil. ");
INSERT INTO bps_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“I gmangu di ge gine, too glut mkel kadang. Tafgadè Dwata ge i fanan nimò. ");
INSERT INTO bps_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Du lam i fitu fali ani kadang, too bong gwè i dad to ulê i dad flala. Taman too lugel di klamang banwe Idyif klo fitu fali. ");
INSERT INTO bps_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kabay kakubu én, kel i fitu fali bong kbitil, na mdà di kbitil ani, i fitu fali i too lugel tamaglifet nan, du i banwe Idyif too malmo mdà di kbitil. ");
INSERT INTO bps_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Hae, i too lugel tamaglifet kadang, du too maflayam kadang, du mdà di bong kbitil ani. ");
INSERT INTO bps_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Na Faraon, fakna ge Dwata lwe dulê, du fye glabatam kenen sa too mimò kdee ani, na dnohoan là mlo ani. ");
INSERT INTO bps_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Taman fye ku fatlagad ge. Fye ku malék ge i to too fulung faldam, na too nun kaglabatan, na blém kenen i glal mebe i klamang banwe Idyif ani. ");
INSERT INTO bps_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Na fye ku malék ge dademe ganlal, du ale mwè kadang i glime alel, ku gafat dad fla i dad to di klamang Idyif, di klo i fitu fali i too lugel. ");
INSERT INTO bps_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Dekam ale too mwè i glime alel ani, klo i too lugel ani kadang, na blém di dale i glal samtifun, na musek i ulê i dad fla di kat man satu syudad, na funungla. ");
INSERT INTO bps_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Na i dad busekla atù, i knaan i dad to di kakel i fitu fali kbitil dini di banwe Idyif, du fye là mati i dad to mdà di kalnusla.” ");
INSERT INTO bps_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Na agin Faraon na i dademe dad ganlalan di fandam Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Taman man i harì di dale, “Landè to fakayito teen fye fa di ku Dyosif ani, du Dwata samnagin kenen.” ");
INSERT INTO bps_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Na man i harì di ku Dyosif, “Du tafgadè Dwata di ge gablà di kdee i fan kel ani, landè dademe to too fulung faldam na too nun kaglabatan salngad ge. ");
INSERT INTO bps_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Taman blégu ge glal di banwe ani. Na balù tan i dekam i dad to, too ale mimen. Alò deg mdatah di ge, du deg sa i harì.” ");
INSERT INTO bps_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Fadlug talù Faraon di ku Dyosif, manan, “Ani nalékta ge du mgimò gubirnador di klamang banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kafnge én, nwè i harì i tising di tnaloan, na falsakan di tnalò Dyosif, du ilè kenen mgimò ulu. Na falsakan i too mabtas klaweh, na faslan i sla blawen. ");
INSERT INTO bps_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Na fsakayan kenen i snakay gal dyol i kudà, gusmakay i mdatah salig i harì, na nun dad to dekan di muna Dyosif, du ale sa mkit, manla, “Falohyu kenen magu.” Na taman Dyosif i mgimò i gubrnador di klamang banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Na lêman man i harì di ku Dyosif, “Balù deg sa i harì, bay là fakay ku i dad togu dini di banwe Idyif, mimò balù tan ku laam ale faloh.” ");
INSERT INTO bps_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Na tanlas i harì dagit Dyosif, na dnagitan kenen Safénat Faniya. Fafwean kenen yaan i libun dnagit ku Asénat, i maan dnagit ku Fotiféras. Fotiféras ani, i mebe i dad to mangamfù di duh, déén di banwe On. Na du tagubirnador Dyosif, magu kenen du meye i klamang banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Na Dyosif tlu falò fali i ktuan di kablé i harì di kenen glal. Na mdà Dyosif di muna i harì, du lamngab na tlang kenen di kdee dad banwe di klamang banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na klo i fitu fali, too bong ulê i fla. ");
INSERT INTO bps_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Na fastifun Dyosif i lime alel di ulê i fla i dad to, na fbusekan di dad kat man satu syudad di klamang banwe Idyif. Na di kat man satu syudad nun santifun na busekla fdu di dee nligo di glibut di dale. ");
INSERT INTO bps_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Na too bong tafastifun Dyosif, i kalbongan gambet i falak di mahin, du là gagan i mse dun du too bong. Ani duen tlag Dyosif mse dun, du too bong. ");
INSERT INTO bps_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Na di là fa kel i kbitil, nun lwe dad ngà Dyosif lagi, du mngà Asénat. ");
INSERT INTO bps_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Dnagit Dyosif i twege dunan Manasas, du manan, “Flana Dwata di deg i kaflayamgu di muna, na klidù nawagu i màgu na i dad gakedgu.” ");
INSERT INTO bps_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Na dnagitan i twali dunan Ifraim, du manan, “Tablé Dwata di deg dad ngà dini di banwe ani, di gunun kaflayamgu.” ");
INSERT INTO bps_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Too glut sa i gman Dyosif, du di kakubu i fitu fali i too nun ulê i dad fla, tambù i bong kbitil. I kbitil ani, galngab di dad dademe banwe, bay nun bong kakaan di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Na ku too bitil i dad to di Idyif, mni ale knaanla di harìla. Kabay manan di dale, “Ditù gamu di ku Dyosif, na nimenyu i dekan gamu.” ");
INSERT INTO bps_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Di kbel i kbitil di klamang banwe Idyif, fukà Dyosif i dad gusamtifun i fali trigu, na fafablin i fali di dad to mnè di Idyif, du too sè i kbitil. ");
INSERT INTO bps_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Na du too sè i kbitil di klamang banwe, balù i dad to di dademe banwe salu ale di Idyif, du mayad ale fali di ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Na di kaklinge Dyékob, i mà Dyosif, nun sbung fali dnagit trigu di Idyif, manan di dad ngaan lagi, “Tan kè duenyu là mngabal i kakaanito? ");
INSERT INTO bps_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Lingegu nun bong fali di Idyif. Salu gamu gito ditù du mayad gamu, du fye là ito mati malnus.” ");
INSERT INTO bps_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Taman i sfalò twege Dyosif, salu di Idyif du mayad fali. ");
INSERT INTO bps_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kabay i twalila, i dnagit ku Bénhamin, là fagin Dyékob, du likò kenen ken nun sasè gaslokan. ");
INSERT INTO bps_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Na du nkel i kbitil di banwela Kanaan, én i duen dad ngà Dyékob salu di Idyif, magin i dee dad dademe to, du mayad ale fali. ");
INSERT INTO bps_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na du Dyosif i gubirnador di banwe Idyif, kenen i fabli fali di kdee dad to di dademe banwe. Na di kakel i dad flanekan, lkuad ale di munan, du mafè ale kenen. ");
INSERT INTO bps_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Na di kite Dyosif dale, nilean ku simto ale, bay flingu i laan ale dilè. Na too faltê talù di dad flanekan ani, manan, “Tanè gufduyu?” Na tmimel ale, manla, “Fdu gami di banwe Kanaan, na salu gami dini du mayad fali.” ");
INSERT INTO bps_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Na balù nilè ale Dyosif, làla kenen dilè. ");
INSERT INTO bps_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Na gafaldam Dyosif i dad knan di muna, gablà di dale, na manan di dale, “Ise kè duenyu salu dini du gamu i dad gal meye, na neyeyu ku nun gumlungay i banwemi ani, du fye fnisanyu gami.” ");
INSERT INTO bps_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tmimel ale, “Amumi, tabyà di ge, ise gami sa dad gal meye, bay gami dad lifanam. Alò gami salu dini du mayad gami fali. ");
INSERT INTO bps_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kdeemi ani saflanek, satu i màmi. Ise sa ku meye gami i gumlungay i banweyu, bay gami sa dad fye to.” ");
INSERT INTO bps_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Man Dyosif, “E là, là agu faglut i manyu. I duenyu salu dini, du neyeyu ku tan gumlungay i banwemi.” ");
INSERT INTO bps_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kaklingela ani, manla, “Di muna, i dad lifanam ani, sfalò lwe gami saflanek di satu mà, na mnè kenen di banwe Kanaan. Na i sangal twalimi ditù kenen di saféd i màmi, na satu flanekmi tamati.” ");
INSERT INTO bps_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Na man Dyosif di dale, “E, glut i mangu, gamu sa dad to gal meye. ");
INSERT INTO bps_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kabay ani i nimògu, du fye gadègu ku glut i manyu ku là. Fagu di dagit i harì, mangu di gamu, là gamu fakay mulê di banweyu, silang ku i twaliyu salu dini. ");
INSERT INTO bps_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Falohgu satu di gamu mulê, du nngén kenen, bay fbilanggùgu i dademe di gamu, kel i kgadègu ku glut i manyu. Ku là glut i manyu, mangu fagu di dagit i harì, gadègu kadang, gamu sa salu dini duenan, du neyeyu ku tan i gumlungay i banwemi, du fye fnisanyu.” ");
INSERT INTO bps_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Di kagmanan ani bnilangguan ale tlu duh. ");
INSERT INTO bps_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Di kakubu tlu duh man Dyosif di dale, “Too nun klikògu i Dwata, taman là gamu sa fnati ku nimenyu i mangu. ");
INSERT INTO bps_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ku glut i manyu, satu di gamu bnilanggù fa dini, na i dademe mulê, na mebe i fali bnayadyu, du fye là mati malayyu di kalnus. ");
INSERT INTO bps_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kabay tooyu fagin i twaliyu samfulê di deg, du fye gadègu ku glut i gmanyu deg. Na ku glut, làta gamu fafati.” Na naginla i gman Dyosif ani. ");
INSERT INTO bps_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kafnge én, stulen i saflanek, manla, “Ani kè i balas di gito di mgimoito di flanekito Dyosif. Du di kafakdon na di kafnin di gito tabeng, na balù teen ito i kaflayaman, là ito flinge. Ani duenan nun kaflayam ani kel di gito.” ");
INSERT INTO bps_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Na man Rubén, “Mangu gamu di muna, nangyu fatduk, bay làyu agu fanlinge. Taman ani i duenan nun kaflayamito, du mdà di kfatin.” ");
INSERT INTO bps_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Na glabat Dyosif i kdee kastulenla ani gine, bay làla gadè dun, du nun to mubad i talùla Hibru di ku Dyosif, na lê nun mubad i taluan, i talù dad to di Idyif di dale. ");
INSERT INTO bps_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kafnge én, tnagakan ale du fan mngel, mdà di bong klidù nawan. Na di kagtaluan lêman, samfulê di dale. Nalék Dyosif Simyon ftagak di bilanggù, na fbakusan di muna i kdeela. ");
INSERT INTO bps_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Di fan kdà i dad flanekan mulê, dek Dyosif i saligan, manan, “Fananoam dad sakula fali, na fuléam i filakla, bay bunim di gsen tah i saku i kat satu dale, na banlém ale bnatula di kagula.” Na nimen i lifan Dyosif i dekan kenen. ");
INSERT INTO bps_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kafnge én, lulen i dad flanekan i falila di dad dongkila, na mdà ale mulê. ");
INSERT INTO bps_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Na kakella di gukudangla di satu butang, satu di dale mukal i sakun, du fankaanan i dongki, na teenan i filakan di tah i sakun. ");
INSERT INTO bps_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Na tlon i dad flanekan, manan, “I filak bayadgu i fali tagani sa di tah sakugu ani, tafulê di deg.” Kaklingela ani makto i nawala, na too ale likò na stulen ale, manla, “Tan i gamu fandam i mgimò Dwata di gito ani?” ");
INSERT INTO bps_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kakella di gumnè i màla di Kanaan, tulenla kenen i kdee mgimò di dale di klola ditù di banwe Idyif, manla, ");
INSERT INTO bps_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“I gubirnador di Idyif too faltê talù di gami, na dnalaman gami, gami salu ditù kun, du neyemi i banwela, du fye fnisanmi. ");
INSERT INTO bps_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kabay tnimelmi, ‘Ise gami i dad gal meye, du landè sasè duenmi salu dini.’ ");
INSERT INTO bps_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tnulenmi kenen, sfalò lwe gami saflanek, na satu i màmi. Satu i twalimi tamati, na i sangal twalimi ditù kenen di saféd i màmi, déén di banwe Kanaan. Ani gmanmi di kenen. ");
INSERT INTO bps_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kabay man i gubirnador di gami, ‘Ani i nimògu, du fye gadègu ku glut i manyu ku là. Satu di gamu bnilanggù dini, na i dademe gamu mulê, na mebe gamu fali bnayadyu, du fye là mati malayyu di kalnus. ");
INSERT INTO bps_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kabay faginyu dini i twaliyu, du fye gadègu ise gamu i dad gal meye, bay glut i gmanyu, na landè sasè duenyu salu dini. Na fulêgu di gamu satu flanekyu, na fakay gamu mayad dini di banwe Idyif.’ Én gman i gubirnador di gami.” ");
INSERT INTO bps_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kafnge én, di kukal i dademe dad saflanek i sakula, teenla di kat satu sakula i filak bayadla i fali. Na di kitela i filak, Dyékob na kdee dad ngaan too ale likò. ");
INSERT INTO bps_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Na man i màla, “Fagu di gamu, tatì lana i dademe dad ngàgu. Tamati Dyosif, na Simyon tatnagakyu ditù di Idyif, na ani lêmanyu kayè ku faginyu Bénhamin. Tooyu agu banlé kaflayam.” ");
INSERT INTO bps_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Na tmimel Rubén i maan, manan, “Mà, nang ge mlidù, agu sa mifat ku Bénhamin. Na ku làgu kenen gebe samfulê, fakayam fnati i lwe dad ngàgu lagi, bay toogu nebe kenen samfulê di ge.” ");
INSERT INTO bps_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kabay man Dyékob, “Làgu faloh i tingàgu lagi ani magin gamu. I twegen tamati, na kenen alò i gdè. Du ku nun sasè gaslokan di dalanyu, én gamfati deg di bong klidù nawagu kenen.” ");
INSERT INTO bps_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Na too matnù i kbitil di banwe Kanaan. ");
INSERT INTO bps_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Na di kti fali trigu nebe dad ngaan mdà di Idyif, man Dyékob di dale, “Samfulê gamu di Idyif, na mayad gamu gito fali.” ");
INSERT INTO bps_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tmimel Dyuda, manan, “I to atù laan gami fasfulê ditù di kenen, silang ku faginmi i twalimi. ");
INSERT INTO bps_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ku faginam gami moon Bénhamin, na salu gami ditù mayad fali. ");
INSERT INTO bps_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kabay ku laam faloh kenen magin gami, landè kibòmi salu ditù, du i to atù toon man gami nang samfulê di kenen, silang ku faginmi i twalimi.” ");
INSERT INTO bps_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tmimel Israél, dunan Dyékob, manan, “Tan kè duenyu tmulen kenen nun twaliyu? Too gamu mlé deg ksamuk nawa.” ");
INSERT INTO bps_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tmimel ale, “I duenmi tmulen kenen, du fnadlugan snalek gablà di gami na i dad malaymi. Snalekan, manan, ‘Mto fa kè i màyu sadni? Na nun fa dademe flanekyu?’ Tatì alò tnimelmi i dad salekan. Làmi sa fandam ku manan gami too fagin i twalimi ani samfulê di kenen.” ");
INSERT INTO bps_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Na man Dyuda di maan, “Faginam gami twalimi Bénhamin, du fye mdà gami nan, du fye kdee ito, na i dad ngaito là mati malnus. ");
INSERT INTO bps_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Agu sa mifat ku Bénhamin, én i fakangta ge. Na ku làgu gebe samfulê, agu sa kmakif i salàgu, kel di kfatigu. ");
INSERT INTO bps_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ku laam klen moon i kmanmi dun di ge, na balù talwe dulê gami nan moon samfulê di Idyif.” ");
INSERT INTO bps_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Na man i màla, “Ku landè dademe kfagu fakay nan, bay mebe gamu i dad too fye bunge di tanaito, du bléyu di gubirnador atù. Mebe gamu dad bulung mdà di kayu, tukay tnab, dad anag, na dad bunge i dad kayu fistasio na aleméndras. ");
INSERT INTO bps_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Na nebeyu i filak fulê di gamu, na tananùyu fa salngad i kbong filak di muna nebeyu. Na fulêyu i fisus i teenyu di tah i sakuyu, du ken gsalà i gumkahla dun. ");
INSERT INTO bps_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Na faginyu sa nan i twaliyu, na faflal gamu samfulê di to di Idyif. ");
INSERT INTO bps_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Na dmasal agu di Dwata Too Mtulus, du fye too nun kakdo i ganlal gamu, na falohan moon i twegeyu Simyon na Bénhamin magin gamu mulê. Kabay ku ani kfagu Dwata mwè i dad ngàgu ani di dagu, kaman sa!” ");
INSERT INTO bps_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Taman faflal mdà dad ngà Dyékob salu di Idyif, na faginla Bénhamin, na nebela i bong filak gine, na i dad bléla ku Dyosif. Kakella ditù, salu ale di kenen. ");
INSERT INTO bps_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Na di kite Dyosif i twalin Bénhamin magin dale, manan di saligan, “Faginam dad lagi ani ditù di gumnègu. Kmatê ge lmanaf na tnagayu, na mimò gamu knaan, du kmaan ale kadang di safédgu di ltu duh ani.” ");
INSERT INTO bps_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Na mimen i saligan, na faginan i dad flanek Dyosif ditù di gumnean. ");
INSERT INTO bps_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Na di kfagin dale ditù di gumnè Dyosif, too ale likò, na stulen ale, manla, “Faginan ito dini, du mdà di filak fulê na gkah di lam i sakuito. Kenan ito kanfè, na nimoan ito dad lifanan, na nwean dad dongkiito.” ");
INSERT INTO bps_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Taman kakella di gufusuk i gumnè Dyosif, manla di saligan, manla, ");
INSERT INTO bps_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Tabyà, begam gami fanlinge. Salu gami dini di muna, du mayad fali. ");
INSERT INTO bps_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Na di dalanmi mulê, gilè gami di dalan, na nukalmi sakumi na teenmi filak i bayadmi fali di lam i sakumi. Na taman lêmanmi nebe samfulê. ");
INSERT INTO bps_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Na nebemi dademe filak du bayadmi lêman fali. Làmi gadè ku simto mkah filakmi déén di sakumi.” ");
INSERT INTO bps_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Na tmimel i salig ani, manan, “Nangyu fsamuk i nawayu, na nang gamu likò. I Dwata fnangamfùyu na i màyu i too mkah kè filak di lam sakuyu. Gamu sa mfun dun, du tagamdawat agu sa i filak bayadyu fali.” Kafnge én, fafngé i salig ani Simyon mdà di bilanggù, na faginan déén di dale. ");
INSERT INTO bps_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Na fagin ale i salig Dyosif di lam i gumnè, na banlén ale yéél du alob i blìla, na fafkaanan i dad dongkila. ");
INSERT INTO bps_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na tulenan dale, kmaan ale kadang di saféd Dyosif. Taman di klola fatan, fnatlagadla i bléla kenen. ");
INSERT INTO bps_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Di kulê Dyosif, bléla nan dad nebela kenen, na lkuad ale di munan, du nafèla kenen. ");
INSERT INTO bps_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Na snalek ale Dyosif, manan, “Tan i kagkahyu? Na di muna, i kdiniyu, tulenyu gablà di màyu. Na man, i màyu too tua, tan i kagkahan, mto fa kenen?” ");
INSERT INTO bps_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Na tmimel ale, manla, “I màmi i lifanam, mgal sa fa beg.” Na lêman ale lkuad, du nafèla kenen. ");
INSERT INTO bps_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Na di kfalê Dyosif, teenan i twalin Bénhamin, too tingà i yéan, na manan, “Ani kè i sangal twaliyu i gmanyu deg?” Na léan man ku Bénhamin, “Tò, kayègu ku Dwata i mlé di ge kafye.” ");
INSERT INTO bps_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kafnge én, fan mngel Dyosif, du bong kakdon i twalin, na too nun klehewan di kiten kenen. Taman du là gadnanan i kngelan, gasilan ale tnagak déén, na fusuk di lam i sibayan na mngel. ");
INSERT INTO bps_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kafnge én, di kagadnanan i lwakan, naloban i bawehan, na samfulê di safédla, na manan di dad saligan, “Malel gamu i knaan.” ");
INSERT INTO bps_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Stani i dad gukmaanla, du mahal i lamisa Dyosif, na i dad flanekan lê mahal i dale lamisa, na lê mahal i lamisa i gukmaan i dad to di Idyif, i dademela kmaan, du i dad to di Idyif ani, i ukumla là ale mayè kmaan di saféd i dad to Hibru, du too sasè di dale. ");
INSERT INTO bps_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","I lamisa gukmaan i dad flanek Dyosif, déén di muna i kenen gukmaan. Na snadfél Dyosif ale fsudeng, fandà di twege kel di sangal twali. Na di kitela i kibò fsudeng dale, seye ale du too ale tikeng. ");
INSERT INTO bps_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Fafwè Dyosif i knaan i dad flanekan di lamisa gukmaanan. Na di kdeela, fafalbongan alel Bénhamin lime dulê i kalbongan. Na kdeela kmaan, na minum kel di kabsolla. Na too ale lehew klola kmaan na minum. ");
INSERT INTO bps_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na di kafngela kmaan man Dyosif di saligan, “Fananoam i dad saku i dad lagi ani kalbong i gagan nebe i dad dongkila. Kafdu én, fuléam kdee filak nebela, na fkaham di tah di lam i saku i kat satu dale. ");
INSERT INTO bps_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Na di kafkaham kadang i filak di lam i saku i twalila, fakufam i tabùgu salafì.” Na nimen i salig Dyosif i dekan kenen. ");
INSERT INTO bps_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Na di kwal én too flafus, fdaan i dad saflanek ani. ");
INSERT INTO bps_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Di là ale fa too mawag di banwe én, man Dyosif di saligan, “Faflal ge, laloam ale. Na di kgumaham dale tulenam dale i mangu ani, manam, ‘Tan kè duenyu malas sasè di kafye mgimò i ganlal di gamu? ");
INSERT INTO bps_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tan kè duenyu tmaku i tabù salafì? I tabù én galan guminum, na galan gumeye fye gadean ku tan knayè i Dwata. I nimòyu ani too sasè.’ ” ");
INSERT INTO bps_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Na di kgumah i salig dale, tulenan dale i kdee gman Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kabay tmimel ale, manla, “Tabyà, tulenam gami tan kè duenam mangman ani? Gami i dad lifanan, là gami sa mimò én, làmi sa tnaku i tabù i ganlal. ");
INSERT INTO bps_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Gafaldamam sa kè i kasfulêmi di banwe Kanaan, i filak teenmi di lam i dad sakumi fulêmi sa. Taman tan ku mayè gami tmaku i salafì ku demen blawen di gumnè amum? ");
INSERT INTO bps_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tabyà ku teenam i tabù én di satu di gami, fakayam fnati, na dademe di gami nimoam lifanam.” ");
INSERT INTO bps_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Na tmimel i salig, manan, “Hae, nimògu i manyu ani gine. Balù di simto to gumitegu i tabù én, kenen alò nimògu lifangu. Na i dademe kadang fakay mulê.” ");
INSERT INTO bps_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Na fnaflal nawas i dad saflanek i dad saku di dad dongki na fkahla di tanà na nukalla. ");
INSERT INTO bps_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kafnge én, tanbù nan i salig too mngabal, fandaan di saku i sangal twege, kel di saku i sangal twali. Na i gumiten i tabù én baling di saku Bénhamin. ");
INSERT INTO bps_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Taman i saflanek ani knasêla i klawehla, du mdà di too sasè klidùla. Na lêmanla lulen dad saku di dad dongkila na samfulê ale di syudad Idyif. ");
INSERT INTO bps_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Na di kasfulê Dyuda na i dad flanekan di gumnè Dyosif, déén fa kenen, na gasil ale lkuad di munan. ");
INSERT INTO bps_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Na man Dyosif di dale, “Tan kè duenyu tmaku i tabùgu ani? Làyu kè gadè i dad ulu gambet deg gmagan gmadè i dad gbuni?” ");
INSERT INTO bps_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Na Dyuda tmimel, manan, “Landè kibòmi msen i ktomi, taman landè fakaymi man di ge, du tafite Dwata too nun salàmi. Kdeemi ani, i lifanam nan, là alò twalimi, i gumite i tabuam.” ");
INSERT INTO bps_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kabay man Dyosif, “Là agu mayè mimò gambet i manam gine. Alò i to gumite i tabùgu kadang i nimògu lifangu. Kabay i dademe di gamu fakay mulê di màyu.” ");
INSERT INTO bps_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kaklinge i saflanek i man Dyosif, fdadong Dyuda di kenen, na manan, “Amumi, là agu gablà talù di ge, du gadègu i glalam salngad i glal i harì. Bay begam agu faloh moon talù di ge. Na nang ge flabè deg i lifanam. ");
INSERT INTO bps_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Amu, gafaldamam kè aye di ksalekam gami ku nun màmi na ku nun dademe fa flanekmi lagi. ");
INSERT INTO bps_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na gmanmi di ge, nun màmi too tua nan, na nun twalimi sut di taktua màmi nan. Na smibi kenen tamati, taman alò kenen gdè di satu yaan mà, taman kenen too kando i màmi. ");
INSERT INTO bps_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Na di muna fa, toom fni di gami, gami i dad lifanam, ku faginmi dini twalimi, du fye sitem. ");
INSERT INTO bps_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na tatulenmi too malima di màmi ku faginmi twalimi dini, du ku faginmi, na nun gaslokan, én kadang gamfati i màmi. ");
INSERT INTO bps_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kafnge én, manam di gami, là gami fakay samfulê di ge, silang ku faginmi i twalimi. ");
INSERT INTO bps_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na di kulêmi di màmi, tulenmi kenen i kdee gmanam gami, ge i amumi. ");
INSERT INTO bps_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Na là mlo dek gami màmi samfulé dini di Idyif, du mayad fali. ");
INSERT INTO bps_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kabay manmi di kenen, là fakay, du là gami fakay samfulê di ge, silang ku magin gami i twalimi. ");
INSERT INTO bps_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Kafnge én, man i màmi di gami, ‘Gadèyu, alò lwe dad ngàgu lagi mdà di satu yaangu Rakél. ");
INSERT INTO bps_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Na tamati nan i satu, du fnati kè i labè lmanaf di bnas. Na kel sadni làgu kenen teen. ");
INSERT INTO bps_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na ani ku lêmanyu fagin i satu ani, na ku nun gaslokan di dalan, gamfati deg di bong klidù nawagu kenen.’ Ani gman màmi. ");
INSERT INTO bps_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Taman, ku samfulê agu ditù di màmi i lifanam, na teenan là gagin twalimi ani, mati sa kenen, du ani i tingaan toon kando. Na du too tua kenen, i klidù nawan ani kadang i gamfati kenen. ");
INSERT INTO bps_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Lêgu fakang di màgu, agu mifat i twaligu ani, du fye landè gaslokan. Na mangu fa ku làgu gebe samfulê, agu sa i kmakif i salàgu kel di kfatigu. Ani i gmangu di màgu aye. ");
INSERT INTO bps_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Na Amumi, fneam agu dini di ge, du fye nimoam agu lifanam tlas i twalimi. Na faloham kenen moon mulê gagin di dademe flanekgu. ");
INSERT INTO bps_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tan i kibògu mulê di màmi ku là gagin i twalimi? Landè kibògu! Là agu mayè mite kadang i bong klidù i nawa màgu.” ");
INSERT INTO bps_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Na talà nan gadnan Dyosif i nawan, taman fdaan i kdee i dad saligan, du fye landè di dale mite kenen. Landè dademe to déén di bang fgadè Dyosif i kton di dad flanekan. ");
INSERT INTO bps_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Na too kamwak Dyosif, taman linge i dad to di Idyif ditù di lwà, na nun tmulen di dad to di gumnè i harì. ");
INSERT INTO bps_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Na man Dyosif di dad flanekan, “Agu sa Dyosif i flanekyu! Too glut kè mto fa Mà?” Kabay di kaklinge i dad flanekan ani, làla gtimel Dyosif, du too sasè klikòla. ");
INSERT INTO bps_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Na man Dyosif, “Dini gamu, fdadong gamu di deg.” Na kagdadongla di kenen, manan di dale, “Agu sa flanekyu Dyosif i fabliyu di muna fa, di dad to sbayad, na tamgebe dini di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na nangyu fsamuk i nawayu, na nangyu banlé salà i ktoyu di kafabliyu dagu, du Dwata sa febe deg dini muna di gamu, du fye là gamu mati malnus. ");
INSERT INTO bps_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Hae, du tlabo galwe fali i kbitil ani, na nun fa lime fali landè ulê i dad fla. ");
INSERT INTO bps_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dwata sa febe deg muna dini, na too bong tabengan gamu, du kayean ku là gamu mati malnus, du fye fadlug ito fa mbel di tah tanà. ");
INSERT INTO bps_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ise sa gamu, bay Dwata febe deg dini. Dwata mlé di deg i mdatah glal, i glal gamtadol di harì. Agu sa gal mdek i kdee dad to i harì, na agu i magot i klamang banwe Idyif. Slame ani gablé Dwata dagu. ");
INSERT INTO bps_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Na faflal gamu mulê di màgu, na ani manyu kenen, ‘Ani i man i tingaam Dyosif, tafagot Dwata deg i klamang banwe Idyif. Mà, faflal ge salu dini di deg. ");
INSERT INTO bps_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Fnèta ge dini di banwe Gosén, du fye kdeeyu mdadong di deg, balù ge, dad ngaam, na i dad fuam, na i dad kambingam, i dad bilibilim, i dad bakam, na i kdee nfunam. ");
INSERT INTO bps_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Na agu sa mifat gamu ku dini gamu di Gosén. Du nun fa lime fali gdè kbitil ani, na kayègu ku dini ge mdadong di safédgu, du fye ge, na dad malayam, na i dad lmanafam là mati di kalnus.’ Ani i manyu kadang di ku Mà.” ");
INSERT INTO bps_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Na fadlug talù Dyosif di dale, manan. “Na i kdeeyu dad twegegu, na lê ge Bénhamin, tateenyu agu, na tadilèyu agu sa Dyosif i talù di gamu. ");
INSERT INTO bps_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Taman, tooyu tulen ku Mà gablà di kdatah glalgu dini di Idyif, na gablà di kdee teenyu dini. Na faflal gamu mulê na faginyu kenen dini.” ");
INSERT INTO bps_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Na di kagmanan ani, lkaf Dyosif i twalin Bénhamin na mngel, na lê mngel Bénhamin di kalkafan kenen. ");
INSERT INTO bps_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kafnge én, nkatan nalak i dad flanekan, na mngel di slengan lamkaf dale. Kafnge én, tambù ale stulen di kenen. ");
INSERT INTO bps_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na di takgadè i dad to ditù di bong gumnè i harì, takel nan i dad flanek Dyosif, lehew Faraon na i dad dademe ganlalan. ");
INSERT INTO bps_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Na man Faraon ku Dyosif, “Dekam i dad flanekam flulenla i dad dongkila na mulê di Kanaan, ");
INSERT INTO bps_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","du fye fngéla i maam na i dad malayla na samfulê dini, du blégu dale i too fye tanà dini di Idyif, na gamkaan ale kadang i fye kakaan. ");
INSERT INTO bps_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Na léam ale banlé i dademe dad kaditon mdà di Idyif, du fye nun gusmakay i dad ngàla na dad yaanla. Na toom fngé dale i maam. ");
INSERT INTO bps_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Manam dale, nangla fsamuk i nawala gablà i kandeenla tagakla kadang, du banlégu ale kadang i too fye di Idyif ani.” ");
INSERT INTO bps_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Na kdee i gman harì ani nimen i dad ngà Dyékob. Banlé ale Dyosif i dad kaditon, du ani i dek i harì di kenen, na léan banlé i bnatula di dalan. ");
INSERT INTO bps_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Banlén kat satu dale falami klaweh gumilila, bay banlén Bénhamin tlu latu salafì filak di dale, na lime klaweh gumilin. ");
INSERT INTO bps_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na fneben i maan sfalò dongki i gumlulen i too fye di Idyif, na léan fnebe sfalò dademe dongki slame libun gumlulen i bong fali trigu na fan, na i dademe fa gkaan, du bnatula di kulêla di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kafnge én, fdà Dyosif i dad flanekan, na di fan ale mdà manan di dale, “Nang gamu sdalam na sbulaw di slengyu magu.” ");
INSERT INTO bps_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Taman mdà ale di Idyif. Na di kakella di Kanaan di màla Dyékob, ");
INSERT INTO bps_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","manla, “Mà, mto fa Dyosif! Na kenen sa magot i klamang banwe Idyif”. Na too sè ktikeng i nawa Dyékob, na too maliman fnaglut i gmanla di kenen. ");
INSERT INTO bps_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kabay di ktulenla kenen i kdee gman Dyosif di dale, na di kiten i dee kaditon i feben kenen, du gusmakayan salu di Idyif, mulê i nawan na too kenen lehew. ");
INSERT INTO bps_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na manan. “Tafnaglutgu nan too glut mto fa i tingàgu Dyosif. Landè dademe kayègu. Salu agu ditù di kenen, fye site gami di là agu fa mati.” ");
INSERT INTO bps_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Taman flulen Dyékob i kdee nfunan, na mdà ale di Kanaan. Na di kakella di banwe Bérsiba dsù Dyékob dad lmanaf di Dwata, i Dwata maan Isaak. ");
INSERT INTO bps_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na di kakifun nun kanteen Dyékob, na tlo kenen Dwata, manan, “E Dyékob.” Na tmimel Dyékob, manan, “Hae, gani agu.” ");
INSERT INTO bps_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Na man Dwata, “Agu i Dwata, i Dwata i maam. Na nang ge likò salu di Idyif, du ditù kadang toogu fbel gamu, na gamu mgimò kadang i satu bung dad to too mlabung. ");
INSERT INTO bps_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Naginta ge salu ditù di Idyif, na kafnge én, nebegu i dad belam samfulê di banwe Kanaan. Na kadang di kfatim déén Dyosif di safédam.” Én gman Dwata di ku Dyékob. ");
INSERT INTO bps_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Na kafnge én, mdà ale Dyékob di Bérsiba, na fadlug ale di kagula. Fsakay i dad ngaan i màla, na i dad ngala, na i dad yaanla di dad kaditon febe Faraon, i harì di Idyif. ");
INSERT INTO bps_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Na nebela dad lmanafla, na i dad kandeenla gwèla di Kanaan, na salu ale di Idyif. Na fagin Dyékob di Idyif i kdee dad belan, ");
INSERT INTO bps_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","i dad ngaan lagi, i dad ngaan libun, na i kdee dad fuan lagi na libun. ");
INSERT INTO bps_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Na nam falò nam i kdee dad bel Dyékob magin kenen salu di Idyif. Na là gakuf di kse ani i dad yaan i dad ngaan lagi. ");
INSERT INTO bps_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Na nun lwe dad ngà Dyosif sut di Idyif, na taman i kdee dad malay Dyékob masdagub fitu falò di ksalula di Idyif. ");
INSERT INTO bps_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Na fsalu Dyékob i tingaan Dyuda muna ditù di ku Dyosif, du fatdoan i dalan salu di Gosén. Na di kakella mdadong nan di Gosén, ");
INSERT INTO bps_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","smakay Dyosif i snakayan fadyol i kudà, na salu di Gosén, du snitongan maan. Na di kakelan, lkafan i maan na too mlo mngel. ");
INSERT INTO bps_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Na man Dyékob di ku Dyosif, “Tò, balù kilen nan gatlagad agu mati. Hae, du tateenta ge na toogu gadè mto ge fa.” ");
INSERT INTO bps_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kafnge ani, man Dyosif di dad flanekan na i dad dademe dad malay i maan, manan, “Salu agu ditù di ku Faraon i harì, du tulengu kenen, takel gamu i dad flanekgu, na i dad dademe dad malay i màgu, mdà di banwe Kanaan. ");
INSERT INTO bps_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tulengu kenen kadang, gamu i dad gal mifat i dad bilibili, na dad baka, na tanebeyu dini i dad bilibiliyu, i dad kambingyu, na i dad bakayu, na i kdee nfunyu. ");
INSERT INTO bps_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Taman ku tlo gamu i harì na snalekan ku tan i galyu nimò, ");
INSERT INTO bps_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tooyu man di kenen, gamu i dad lifanan, gamu gal mifat i dad bilibili mdà fa di tingà gamu fa, salngad tamgimò i dad gutambulyu di muna. Ani manyu di kenen, du fye i gufnean gamu dini di Gosén, du dad to mnè di Idyif ani knangla dad to mifat bilibili.” ");
INSERT INTO bps_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Kafnge én, fagin Dyosif lime di dad flanekan, na salu ale ditù di harì. Man Dyosif di kenen, “Takel nan i màgu na dad flanekgu mdà di Kanaan, gagin di dale dad bilibilila na dademe dad lmanafla na i kdee dad nfunla. Na déén ale nan di Gosén.” Kagmanan ani, neben i dad lime flanekan di muna i harì. ");
INSERT INTO bps_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Na snalek ale Faraon, “I tan i galyu nimò?” Na tmimel ale, “Amu, gami i dad lifanam, gal gami mifat dad bilibili, salngad i tamgimò i dad gutambulmi di muna. ");
INSERT INTO bps_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Salu gami dini du kayèmi moon flo mnè dini, du too sasè i kbitil di banwe Kanaan, du balù i dad lmanafmi landè gumtebla nan. Na taman ku beg fakay di ge, gami dad lifanam, begam gami fnè di Gosén.” ");
INSERT INTO bps_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Na man i harì di ku Dyosif, “Too fye du takel nan i maam na i dad flanekam. ");
INSERT INTO bps_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Na du ge i magot i klamang banwe Idyif, fneam ale di Gosén, du nun too fye tanà ditù. Na ku nun dad to di dale too fulung mifat dad lmanaf, fifatam ale i dad lmanafgu.” ");
INSERT INTO bps_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kafnge én, nebe Dyosif i maan Dyékob di muna Faraon. Na dmasal Dyékob fye banlé Dwata kafye Faraon. Na di kdasal Dyékob ku Faraon, ");
INSERT INTO bps_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","snalek i harì, “Man, tan i ktuam?” ");
INSERT INTO bps_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Na tmimel Dyékob, manan, “Tamlatu tlu falò i klogu lamngab di dademe banwe. Là dee i dad faligu, bay i too malima gal i gnagugu. Kabay i dad faligu là fa gasngad di kdee fali i kalngab i dad gutambulgu di muna fa.” ");
INSERT INTO bps_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Na lêman dmasal Dyékob, fye banlé Dwata kafye Faraon, na kafdu én, mdà kenen di muna i harì. ");
INSERT INTO bps_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Na fnè Dyosif i maan, na dad flanekan, di banwe Idyif. Na i tanà blén dale too fye tanà na mdadong di syudad dnagit Ramases, du kdee ani dek Faraon ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Na banlé Dyosif knaan i maan na dad flanekan, na i dad kdee dad malay i maan, gakuf i kdee dad ngàla. ");
INSERT INTO bps_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Na i kbitil ani too sasè, i duenan du landè kakaan i dad to, du i kdee banwe, landè là nagu i bong bitil. Taman i dad to di Idyif na Kanaan mbaling ale mlungay di kbitilla. ");
INSERT INTO bps_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Santifun Dyosif i kdee filak bayad i dad to di Idyif na Kanaan i falila, na tundan i filak ani, ditù di bong gumnè Faraon. ");
INSERT INTO bps_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Na di takti i filak i dad to di Idyif na Kanaan, salu i dad to di Idyif di ku Dyosif, na manla di kenen, “Begam gami banlé fali, du fan gami mati malnus. Tnabengam gami, du landè nan beg filakmi.” ");
INSERT INTO bps_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Na tmimel Dyosif, manan, “Ku talandè nan filakyu, nebeyu dini i dad lmanafyu, du én i bayadyu fali.” ");
INSERT INTO bps_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Taman nebela i dad lmanaf di ku Dyosif, na bnayadan fali i dad kudàla, dad bilibilila, dad kambingla, dad bakala, na i dad dongkila. I kdee dad lmanafla bléla du bayadla fali, tì salfang di fali én. ");
INSERT INTO bps_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kabay di tmadol fali, lêman ale salu di ku Dyosif, na manla, “Amu, làmi buni dun di ge i tatoo mti nan beg i filakmi, na dad lmanafmi, du tage sa i mfun. Taman, talandè nan fakaymi blé di ge galwà alò i lawehmi na tanàmi. ");
INSERT INTO bps_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tabyà kandom gami na tnabengam, du fan gami mati malnus, na fan malmo i tanàmi. Begam bnayad fali i lawehmi na i tanàmi. Du tatì gami nan beg flifan di harì, na kenen nan mfun i tanàmi. Banlém gami fali, du fye là gami beg mati, na léam gami banlé bnê flami, du fye i tanàmi là malmo.” ");
INSERT INTO bps_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kafnge én, bnayad Dyosif i kdee tanà di Idyif kene harì. Kdee i dad to di Idyif bléla i tanàla, du too sasè i kbitil, taman i kdee tanà déén tanfun i harì. ");
INSERT INTO bps_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Na i dad to di klamang banwe Idyif, salig nan Dyosif di harì, du mbaling ale dad lifanan. ");
INSERT INTO bps_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kabay i tanà nfun i dad mebe i dad to mangamfù di duh di Idyif, là bnayad Dyosif. Làla blé i dale tanà, du gal ale nifat Faraon du galan ale banlé filak. ");
INSERT INTO bps_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Na man Dyosif di dad to, “Du tabnayadgu gamu na i dad tanàyu di harì, blégu gamu i bnê flayu. ");
INSERT INTO bps_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ku gafat kadang i faliyu, sansalelyu di lime na satu kene harì, na di fat alel gamu sa mfun dun, du gumwèyu bnê lêyu fla, na i dademe knaanyu na lê knaan i dad malayyu.” ");
INSERT INTO bps_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Na tmimel i dad to “Amu, du mdà di ktabengam gami, là gami nan mati. Too fye i mgimoam di gami. Na tamgimò gami nan lifan Faraon.” ");
INSERT INTO bps_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Na én flalò Dyosif i dad to di Idyif, di bang kgafat i falila sansalel i gwèla di lime alel, na i satu alel toola blé di harì. Na kel i ani fa toola nimen i flalò ani. Alò i tanà i dad mebe i dad to mangamfù di duh i là gfun i harì. ");
INSERT INTO bps_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Na i dad bel Dyékob, i satu dagitan Israél, tamnè di banwe Gosén di Idyif, na matnù i nfunla, na too ale mbel. ");
INSERT INTO bps_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Na sfalò fitu fali i klo Dyékob mnè ditù di Idyif, kel di mlatu fat falò fitu falin. ");
INSERT INTO bps_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na di kakel i bang fan nan kenen mati, fatlon i tingaan Dyosif, na manan di kenen, “Ku kandom agu, fkaham i falelam di dungan i fuadgu, fye gadègu dnohoam i fnigu di ge. Makang ge di deg ku nangam agu lbang dini di Idyif. ");
INSERT INTO bps_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","I kayègu baling, ku ditù gulambangam deg di saféd i dad gutambulgu. Taman di kfatigu nebem i lawehgu di gulambangla.” Na man Dyosif, “Hae Mà, toogu nimò i knayeam.” ");
INSERT INTO bps_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Man Dyékob, “Makang ge di deg toom dnohò i knayègu.” Taman makang Dyosif. Kafnge én, déén di gumilean kudung Dyékob na dnayenan Dwata. ");
INSERT INTO bps_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Na satu duh, nun tmulen ku Dyosif nun fdas i maan. Taman faginan lwe tingaan lagi, Manasas na Ifraim, du mlauy ku Dyékob. ");
INSERT INTO bps_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Na di ktulenla ku Dyékob kakel i tingaan Dyosif, du mlauy kenen, fangalan i nawan, na sudeng di gumilean. ");
INSERT INTO bps_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Na man Dyékob ku Dyosif, “Dwata, Too Mtulus, msut di deg di muna fa déén di banwe Lus di Kanaan, na banlén agu kafye. ");
INSERT INTO bps_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Hae, du manan di deg, ‘Toota ge fbel, du fye i dad belam mgimò i bong lumbuk i dad to, na blégu dale tanà ani, na nfunla kel di landè sen.’ Ani gman Dwata di deg. ");
INSERT INTO bps_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na i lwe tingaam lagi i sut dini di Idyif di là agu fa salu dini, fakufgu ale di dad ngàgu. Hae, Ifraim na Manasas fasngadgu i dad ngàgu lagi, na kalnawagu dale salngad i too glut dad ngàgu lagi gambet ku Rubén na Simyon. ");
INSERT INTO bps_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ku nun fa i dad ngaam sut tmadol dale làgu fakuf di dad ngàgu, bay gablà di tanà gdawat i dad belgu di kfatigu, gakuf ale di lumbuk fagu di dad twegela Manasas demen Ifraim. ");
INSERT INTO bps_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nimògu ani, du too bong nawagu i yéam Rakél. Bong klidù nawagu di kfatin di Kanaan, mdadong di Éfrata di kulêgu mdà di Mésofotamya. Na lbanggu kenen mdadong di dalan salu di Éfrata.” (Éfrata ani, sadni dagitan Bétléhém.) ");
INSERT INTO bps_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Di kite Dyékob i dad ngà Dyosif, smalek kenen, “Simto dad ngà ani?” ");
INSERT INTO bps_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Tmimel Dyosif, “Mà, ani i dad ngà i blé Dwata deg dini di Idyif.” Na man Dyékob, “Fdadongam ale dini di deg, du fnigu di Dwata, fye banlén ale kafye.” ");
INSERT INTO bps_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Takamwanal nan i kite Dyékob du mdà di taktuan, na én duenan là nan too mite. Taman fafdadong Dyosif i dad ngaan di maan, na lkafan na nalakan ale. ");
INSERT INTO bps_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Na man Dyékob di ku Dyosif, “Là agu faglut ku teenta ge fa, bay bong fye di Dwata, du falohan ite fa site na lêgu teen fa i dad ngaam.” ");
INSERT INTO bps_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nwè Dyosif i dad ngaan di saféd Dyékob, na lkuad kenen di muna i maan. ");
INSERT INTO bps_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Na nagotan i lwe dad ngaan, Ifraim gsen di ibeng Dyékob, na Manasas gsen di kwananan, na léan ale fdadong di kenen. ");
INSERT INTO bps_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kabay Dyékob balingan santaday i sigalan, taman i kmalan gsen di kwanan i agotan di tah ulu Ifraim, balù kenen i twali, na i ibengan di tah ulu Manasas, balù kenen i twege. ");
INSERT INTO bps_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kafnge én, mni di Dwata kafye ku Dyosif, manan, “E, Dwata, ge sa i Dwata lalò i fùgu Abraham na i màgu Isaak. Ge i Dwata malak dagu mdà di tukay agu kel i ani. ");
INSERT INTO bps_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ge i kasaligan i falwà dagu mdà di kdee dad fsasè dagu. Taman kayègu ku lê ge mlé moon kafye di dad sawang lagi ani. Na kayègu ku i dagitgu na i dagit i fùgu Abraham na i màgu Isaak, too magdengeg mdà di dad fùgu ani. Na lêgu kayè ku toom ale fbel di tah tanà ani.” ");
INSERT INTO bps_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Na di kite Dyosif i fkah maan i kmalan gsen di kwanan di ulu Ifraim, laan lehew dun, taman nilin i kmal i maan di ulu Manasas. ");
INSERT INTO bps_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Na manan di maan, “Mà, ise én, du ani i twege. Kenen ulu gumkaham i kwananam.” ");
INSERT INTO bps_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kabay là nagin maan i knayean, na manan, “Ngàgu, gadègu sa. I dad bel Manasas mbaling dee, bay i dad bel Ifraim, i twalin, mdatah fa di kenen, na i dad belan mgimò kadang dee sahal bung dad to too mlabung.” ");
INSERT INTO bps_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Taman di duh én, fadlug kenen mni di Dwata kafye di dad fuan ani, manan, “Gamu dagit i gafaldam i dad belgu, kadang satu duh, di kafnila kafye, manla, ‘Kayèmi ku ge Dwata mlé gami kafye salngad i kablém ku Ifraim na Manasas.’ ” Fagu di manan én, fdatah Dyékob Ifraim di twegen Manasas. ");
INSERT INTO bps_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Di kdasalan, man Dyékob di ku Dyosif, “Tò, tamdadong nan i duh i kfatigu, bay fadlug Dwata samnagin ge, na fasfuléan i dad belta kadang satu duh di banwe i gumnè i dad gutambulta. ");
INSERT INTO bps_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Blégu di ge, ise ku di dad flanekam, i tanàgu di Sikim. Too fye tanà ditù, tanwègu di dad to di Amori di kasfati ditù fagu di sudanggu na i boholgu.” ");
INSERT INTO bps_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Na dad sfalò lwe dad ngà Dyékob, mbaling ale i sfalò lwe dad lumbuk di bel Israél. Na mni Dyékob di Dwata fye banlén ale kafye, i kafye i gablà di kat man satu dale, na én gman i màla di dale. ");
INSERT INTO bps_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kafnge én, nun kated Dyékob i dad ngaan, manan, “Fan agu mlalò i dad gutambulgu i tamati. Na ku mati agu, lbangyu agu di gulambang i dad gutambulgu di ilib ditù di tanà nfun Ifron di muna, i mnè di Hiti, ");
INSERT INTO bps_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ditù di Makféla gsen di gusut i duh, mdadong di banwe Mamri di Kanaan. Na ilib na tanà ani bnayad Abraham mdà di Ifron, du nimoan gulambang. ");
INSERT INTO bps_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ditù gulambang ku Abraham na Sara, na balù dad tuagu Isaak na Rébéka, na déén gulambanggu i yaangu Liya. ");
INSERT INTO bps_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","I tanà na ilib ani, dunan tagbayad di dad to mnè di Hiti.” ");
INSERT INTO bps_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Di kafnge Dyékob kmated ani di dad ngaan, lê milè na fles nan mati. ");
INSERT INTO bps_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Di kfati Dyékob, lkaf Dyosif i maan, na nalakan na mngel kenen. ");
INSERT INTO bps_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kafnge ani, dek Dyosif i dad saligan i too fulung mulung, mulung i laweh i maan, du fye léét balok. Taman i dad to fulung mulung bnulungla i lawehan. ");
INSERT INTO bps_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Na i klola mulung i laweh maan gafat di fat falò duh, du ani gal i klo i kbulung i laweh i dad mati. Na i dad to di Idyif flidù i nawala klo i fitu falò duh. ");
INSERT INTO bps_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Na di kafto i dad butang i kaflidùla di kfati Dyékob, man Dyosif di dad salig i harì, “Ku kandoyu agu, tugadyu di ku Faraon i mangu ani. Manyu di kenen, ");
INSERT INTO bps_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Di kagu màgu mati, fakanggu di kenen lbanggu kenen ditù di gulambang tafalan fatlagad aye di Kanaan. Taman, ku fakay di ge moon, salu agu ditù du lambang agu ku Mà, na lê agu sa samfulê dini.’ ” ");
INSERT INTO bps_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Na di kgadè Faraon i snalek Dyosif, tnimelan kenen, manan, “Hae, salu ge ditù na lbangam i maam. Dnohoam i tafakangam di kenen.” ");
INSERT INTO bps_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Taman tamdà Dyosif du lambang i maan. Na i kdee dad ganlal Faraon, na i dad saligan di bong gumnean, na dademe to nun dengeg di banwe Idyif mti magin ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Na magin kenen i malayan, i dad flanekan, na i dad malay i maan. Alò i dad malnak dad ngàla, dad bilibilila, dad kambingla, na i dad bakala là magin, bay mtagak di Gosén. ");
INSERT INTO bps_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nun dademe i magin smakay dad kudà, na dademe smakay i snakay fadyol i kudà. Too dee dad to magin ku Dyosif du lambang i maan. ");
INSERT INTO bps_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Di kakella di gal gumlék fali di Atad, di faltù i yéél Dyordan, mlanu ale. Na ditù flidù Dyosif i nawan di maan, klo fitu duh. ");
INSERT INTO bps_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Na di kite i dad to di Kanaan i kaflidùla déén di gumlék fali di Atad, manla, “I dad to di Idyif too ale mlidù.” Taman i banwe gumimòla dun ani dnagitla Abél Misraim na i gumtatekan dunan, “I guflidù i dad to di Idyif.” Gumimòla ani di faltù di yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Too dnohò i dad ngà Dyékob i katedan dale. ");
INSERT INTO bps_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Hae, du nebela i lawehan di tanà ditù di Kanaan, na lbangla di ilib di Makféla i banwe mdadong di Mamri gsen di gusut i duh. Na ilib na tanà ani bnayad Abraham mdà di ku Ifron, to di Hiti, du nimoan gal gulambang. ");
INSERT INTO bps_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Na di kafnge Dyosif lambang i maan, samfulê kenen di Idyif, demen mulê i dad flanekan, na i kdee dademe dad to magin kenen lambang i maan. ");
INSERT INTO bps_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Na du tamati nan Dyékob, stulen i dad flanek Dyosif, manla, “Fadê ken nun fa ksasè fandam Dyosif gito, na ani ken malas gito du mdà di sasè mgimoito di kenen di muna.” ");
INSERT INTO bps_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Taman nun ftugadla i talùla di ku Dyosif, manla, “Di là fa mati Mà, ");
INSERT INTO bps_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","katedan gami, ku gami tmulen di ge i gmanan, na ani manan, ‘Begam nlifet i salà i dad flanekam mgimòla di ge di muna.’ Taman tabyà, begam nlifet i salà mgimòmi di ge, gami dad salig i Dwata, Dwata i maam.” Na di kaklinge Dyosif i kmanla, mngel kenen. ");
INSERT INTO bps_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kafnge én, salu i dad flanekan di kenen, na lkuad ale di kenen. Na manla, “Tadini gami nan, du fye nimoam gami dad lifanam.” ");
INSERT INTO bps_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kabay man Dyosif di dale, “Nang gamu likò, du ise deg mukum gamu, du alò Dwata fakay mukum. ");
INSERT INTO bps_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Du balù i knayèyu ku fansasèyu agu di muna, bay too fye kfagu Dwata, du fye dnohoan baling i knayean, fye là mati i dee dad to di kalnusla, na én duenan mto ito fa ani. ");
INSERT INTO bps_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Taman nang gamu likò. Nifatta gamu na i dad ngàyu.” Na ani kfagu Dyosif i taluan, du nlalan na flehewan i nawa i dad flanekan lagi. ");
INSERT INTO bps_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Na Dyosif na i malay i maan fadlug mnè di banwe Idyif. Na tamlatu sfalò falin di kfatin. ");
INSERT INTO bps_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Di là fa mati kenen, teenan fa i dad ngà i dad fuan, i dad fù Ifraim. Na léan teen i dad ngà Makir, i tingà Manasas, na di ksutla gagotan ale fa. ");
INSERT INTO bps_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Na satu duh, man Dyosif di dad flanekan, “Na mdadong nan i bang kfatigu, bay là gamu fbayà i Dwata. Hae, dnohoan i fakangan di dad gutambulito Abraham, Isaak, na Dyékob, du tnabengan gamu na neben gamu kadang, mdà di banwe ani salu di banwe tafakangan i dad belito.” ");
INSERT INTO bps_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kafnge én, nun kated Dyosif i dad dademe bel di Israél, manan, “Di kebe Dwata gamu samfulê di Kanaan, fnakangyu agu nebeyu mulê kadang balù i dad tulangu.” ");
INSERT INTO bps_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Na déén nan gumati Dyosif, na tamlatu sfalò i falin. Na bnulungla i lawehan, du fye léét balok, na fkahla kenen di lungunan déén di Idyif.");
INSERT INTO bps_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ani i dad ngà Dyékob lagi, i magin kenen deme i dad malayla, salu di Idyif, dunan, ");
INSERT INTO bps_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simyon, Libay, Dyuda, ");
INSERT INTO bps_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sabulun, Bénhamin, ");
INSERT INTO bps_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Néftali, Gad, na Asér. ");
INSERT INTO bps_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","I kdee i dad bel Dyékob i mili di banwe Idyif, mdà di Kanaan, masdagub fitu falò. I tingaan lagi Dyosif muna mnè di Idyif. ");
INSERT INTO bps_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kafnge én, tamati Dyosif, na i kdee dad flanekan, na i kdee dad dademela salngad ktua. ");
INSERT INTO bps_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kabay i dad bel Dyékob dnagit dad bel Israél, too mbel, na mgimò ale i bong lumbuk i dad to. Na i tanà gumilila déén di Idyif, mbaling too fnò i dad bella. ");
INSERT INTO bps_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kafnge én too mlo, nun to mbaling i falami harì di Idyif, bay là kenen gmadè gablà di kafye kimò Dyosif di banwe ani. ");
INSERT INTO bps_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Na satu duh man harì ani di dad ton, “Neyeyu dad bel Israél ani, alì ale dee. ");
INSERT INTO bps_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Taman mngabal ito kfagu, fye là fadlug matnù i kdeela, du ken kadang di bang i kasfati, fakuf ale di dad to demeito sduen, na gagin ale samfati gito, na baling ale galwà di banweito ani.” ");
INSERT INTO bps_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Taman nalékla i dad to labè, du ale mgimò ulu gal magot i dad bel Israél, du mleges dale mimò i blat nimò. Fafdakla dale i lwe syudad dnagit ku Fitom na Rameses, du déén gumusek i dad knaan na i dad knun Faraon, i harì di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kabay balù faflayam ale, knean dad bel Israél baling fadlug mbel. Taman kanlikò ale i dad to di Idyif. ");
INSERT INTO bps_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Na baling lumban fa i kaflayamla dale di blat nimò. ");
INSERT INTO bps_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Toola ale banlé kaflayam di knèla, fagu di kfimò dale i dad gumnè mdà di tanà sanbool i gambet lami fali, na yéél. Na fimò ale fa i dee dademe nimò di dad nligola. Na toola ale fanlayam, na landè kakdola dale. ");
INSERT INTO bps_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Na satu duh, fngé harì i lwe libun dnagit ku Sifra na Fua, du gal ale tmabeng i dad libun Hibru, dunan dad libun bel Israél, di ksut dad ngàla. ");
INSERT INTO bps_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","na manan di dale, “Di ktabengyu i dad libun Hibru, di ksut dad ngàla, na ku lagi fnatiyu, na ku libun bayàyu fnati.” ");
INSERT INTO bps_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kabay i dad libun ani, gal tmabeng sut tingà, nun klikòla na kafèla Dwata, taman làla nimen dek i harì dale, du làla fnati i dad ngà lagi. ");
INSERT INTO bps_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Na di kgadè i harì i nimòla, fatlon ale na snalekan, manan, “Kan ku làyu nimen i dekgu gamu, na fnati i dad ngà lagi?” ");
INSERT INTO bps_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Na tmimel ale ku Faraon, manla, “I dad libun Hibru, là salngad di dad libun Idyif. Hae, du too ale gal mgal na mlal mngà, na di là gami fa kel tasut i tingàla.” ");
INSERT INTO bps_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Taman du i dad libun ani, gal tmabeng sut tingà, too nun klikòla na kafèla Dwata, kamdo Dwata dale na banlén ale dad ngàla. Na i dad bel Israél baling fadlug too mbel na lumban ale too dee. ");
INSERT INTO bps_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kafnge én, dek Faraon i dad kdee dad ton, manan, “Batyu ditù di yéél Nilu i kdee dad ngà lagi falami sut di dad Hibru, bay nangyu fakuf i dad ngà libun.” Én man i harì. ");
INSERT INTO bps_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Na di bang én, nun lagi di bel Israél mdà di tingaan Libay, mwè yaan lêman mdà di bel Libay. ");
INSERT INTO bps_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Na satlamin ale, na mbaling maltien i libun, na mngà tingà lagi. Di kiten i too fye baweh tingà ani, na too fye lawehan, bunin klo i tlu bulen. ");
INSERT INTO bps_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kabay di talaan gagan i muni kenen, du tabong nan, nwean i balyas, nimò mdà di tablo, na sneletan di lam, du fye là fnusuk yéél. Na filean i tingaan di lam i balyas ani, na fkahan di lam i tablo di kilil i yéél. ");
INSERT INTO bps_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Na satu libun, i twege i tukay tingà lagi ani, tadag là too mawag di yéél ani, du neyen ku tan mkel di twalin ani gine. ");
INSERT INTO bps_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Na di bang ani, i tingà libun Faraon, salu di yéél du dyo. Kenen na i dad libun gal tmabeng kenen, magu ale di kilil i yéél. Na là mlo teenan i balyas di lam i tablo, na fafwean i lifanan libun. ");
INSERT INTO bps_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Di kukal tingà Faraon i balyas teenan i tingà kamwak. Na kandon i tingà ani, na manan, “I tingà ani kè Hibru.” ");
INSERT INTO bps_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Na i twege i tingà ani, fdadong di libun tingà Faraon, na manan, “Fakay agu kè meye satu libun Hibru mliton, du fye nun mliton dun ge?” ");
INSERT INTO bps_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Na tmimel tingà Faraon, manan, “Hae sa, meye ge deg.” Taman faflal mulê twege tukay tingà ani, na nngén i too glut yéan. ");
INSERT INTO bps_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kakella ditù, man tingà i harì di yê i tukay tingà, “Nebem i tingà ani, du nifatam deg na tnadenta ge.” Taman neben i tukay tingà na nifatan. ");
INSERT INTO bps_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Midul i duh na midul i butang, na tabong i tingà lagi ani. Taman nebe i too glut yéan samfulê, di libun tingà i harì. Na fandam i libun ani i tingà lagi ani salngad i kenen too tingà. Na dagitan kenen Mosis, du manan, “Nwègu tingà ani di yéél.” ");
INSERT INTO bps_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Satu duh, di taktua Mosis, nlauyan i dad ton Hibru, na teenan nleges ale fimò i too blat nimò. Na léan teen i satu to di dad ton Hibru too fatduk i to Idyif kel di kfatin. ");
INSERT INTO bps_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Falê Mosis di glibutan na di landè teenan dademe to, fnatin i to Idyif. Kafnge én, bunin na nlimunan falak. ");
INSERT INTO bps_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Na di gamtadol duh, lêmanan nlauy i dad ton na teenan i lwe Hibru saglà. Na manan di nun salà, “Nangam bnunal i flanekam Hibru.” ");
INSERT INTO bps_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Man i to ani di ku Mosis, “Simto ge kè, landè labetam mdek na mukum gami. Fanam agu fnati salngad kfatim i to di Idyif malfabi?” Di kgadè Mosis nun dad to gmadè i mgimoan too kenen likò. ");
INSERT INTO bps_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na di kgadè Faraon i mgimò Mosis, fakfean moon du kayean fnati. Kabay galwà Mosis di banwe Idyif, na mila di mawag banwe Midyan. Kakelan ditù, sudeng Mosis mdadong i satu ktufa. ");
INSERT INTO bps_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Na di bang ani, nun fitu libun, i dad ngà i satu tyà bà di Dwata di banwe Midyan, dnagit ku Dyétro, salu di ktufa ani, du smulu ale, du kokla di gal guminum i dad bilibili na kambing i màla. ");
INSERT INTO bps_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kabay di kakel i dad lagi mifat i dad dademe bilibili, ndalla dad libun ani gine. Taman di kite Mosis ani, tnabengan dad libun én, na balù kenen smulu, du finuman i dad lmanafla. ");
INSERT INTO bps_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Na di kasfulê i dad libun di màla, snalekan ale, manan, “Na kan ku mlal ksuluyu ninum i dad lmanafito?” ");
INSERT INTO bps_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Na tmimel ale, manla, “Satu to mdà di Idyif i tmabeng gami di kdal i dad lagi mifat i dad bilibili gami. Na balù fa kenen smulu gami, na fninuman i dad lmanafito.” ");
INSERT INTO bps_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Smalek i màla, manan, “Na tanean sa? Kan ku tnagakyu kenen ditù? Neyeyu sa kun, na faginyu dini, du fye kmaan kenen di safédito.” ");
INSERT INTO bps_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Na tamnè Mosis di safédla. Na blé Dyétro i tingaan dnagit ku Sifora, du nimoan yaan Mosis. ");
INSERT INTO bps_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kafnge én, mngà Sifora lagi na dnagit Mosis ku Gérson, du manan di nawan, “Dnagitgu kenen Gérson, du agu satu to alò gbat di banwe ani.” ");
INSERT INTO bps_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Tatoo mlo, mati i harì di Idyif. Na i dad bel Israél too maflayam fa mdà di kaglifanla. Too ale dmalong na mni ale tabeng di Dwata. ");
INSERT INTO bps_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Na fanlinge Dwata i dalongla, na laan glifet i fakangan di dad gutambulla, Abraham, Isaak, na Dyékob. ");
INSERT INTO bps_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Teenan i ksasè kaflayam i dad bel Israél, na too mlidù i nawan dale. ");
INSERT INTO bps_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Na satu duh, klo Mosis mifat i dad bilibili, na dad kambing i tewen Dyétro, i satu bà di Dwata di banwe Midyan, neben i dad lmanaf di faltù di banwe gulandè to, na kel ditù di bulul Sinay, dnagit bulul Dwata. ");
INSERT INTO bps_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Na ditù, gumsut i kasaligan Dwata i Amu di ku Mosis di lam i lifoh too dminè. Na teen Mosis i lifoh ani di lam i tukay kayu. Na dminè i kayu, bay laan sa sakuf. ");
INSERT INTO bps_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Taman, manan di nawan, “Kan ku là sakuf i kayu ani? Fdadong agu sa kun, du neyegu i bong gamtikeng ani.” ");
INSERT INTO bps_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kabay teen Dwata i Amu, i kafdadongan. Taman tamlo Dwata kenen mdà di lam i kayu ani, manan, “E, Mosis!” Na tnimel Mosis, manan, “Hae, dini agu.” ");
INSERT INTO bps_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Na man Dwata, “Nang ge too fdadong dini. Na nlusam i talumfaam, du fitem i kafeam deg, du dini agu di gutadagam. ");
INSERT INTO bps_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Agu sa Dwata, i Dwata fnangamfù dad gutambulam, i Dwata Abraham, Isaak, na Dyékob.” Di kaklinge Mosis ani, snafangan i bawehan, du likò meye di Dwata. ");
INSERT INTO bps_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Na kafnge én, man Dwata i Amu, “Tateengu i kaflayam i dad togu, i dad bel Israél, ditù di banwe Idyif. Na talingegu i dalongla, na i kafnila di dagu tabeng, du fye galwà ale di falel i dad to guglifanla. Gadègu too ale maflayam, na too mlidù i nawagu dale. ");
INSERT INTO bps_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Taman fdanà agu salu dini, du falwàgu ale di falel i dad to Idyif, na mebe dale ditù di satu too fye na too mabal tanà. Nebegu ale di banwe nun too mabù tanà. Di bang ani i banwe ani nanè i dad to di Kanaan, dad to Hiti, dad to Amori, dad to Férisi, dad to Hibiti, na dad to Dyébusi. ");
INSERT INTO bps_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Hae, talingegu i dalong i dad togu, i dad bel Israél, na teengu i kibò dad to Idyif mkut dale. ");
INSERT INTO bps_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Taman ani dekta ge di ku Faraon di Idyif, du fye gebem dad togu lamwà di banwe én.” Én man Dwata. ");
INSERT INTO bps_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kabay man Mosis di Dwata, “E, Amugu tabyà, simto agu kè, i dekam salu di ku Faraon du fye nebegu dad bel Israél lamwà di banwe Idyif? Ise agu i to fakay mebe i dad to.” ");
INSERT INTO bps_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Na tnimel kenen i Dwata, manan, “Magin agu ge, na di kebem i dad to lamwà di Idyif, fnangamfùyu agu dini di bulul ani, du ani i ilè i kaglut na agu mdek ge.” ");
INSERT INTO bps_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Man Mosis, “Ku salu agu di dad bel Israél na mangu dale, i Dwata fnangamfù dad gutambulla i mdek deg di dale, na ku smalek ale deg, manla, ‘Simto kè i dagitan?’, na tan sa i timelgu dale?” ");
INSERT INTO bps_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Na lêman talù Dwata di ku Mosis, manan, “Agu sa Dwata, i landè gutambùgu, na landè gusengu. Tulenam dale agu i mdek ge di dale. ");
INSERT INTO bps_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","“Manam di dad bel Israél, Dwata i Amu, i Dwata fnangamfù dad gutambulla Abraham, Isaak, na Dyékob, i mdek ge di dale. Ani i dagitgu kel di atuan landè sen. Ani i dagit là glifet i kdee dad fulé bel i dad to. ");
INSERT INTO bps_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Na ditù ge na santifunam i dad tua di dad bel Israél, na tnulenam ale, agu Dwata i Amu, i Dwata fnangamfù dad gutambulla Abraham, Isaak, na Dyékob tamsut di ge. Na manam di dale tagadègu na tateengu kibò i dad to Idyif mlayam dale. ");
INSERT INTO bps_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Too ale maflayam, taman ani i fakanggu dale, falwàgu ale mdà di kaglifanla di Idyif. Na nebegu ale di banwe nun too mabù tanà, ditù di banwe nanè i dad to Kanaan, dad to Hiti, dad to Amori, dad to Férisi, dad to Hibiti, na dad to Dyébusi.” ");
INSERT INTO bps_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Fadlug talù Dwata di ku Mosis, manan, “Di kaklinge i dad ulu i dad bel Israél i manam, too ale kadang flinge ge. Kafnge én, faginam ale kadang salu di harì di Idyif. Na ani i manyu kenen kadang, manyu, ‘Dwata i Amu, i Dwata fnangamfù dad Hibru, tamsut di gami. Na tabyà, faloham gami beg salu di banwe gulandè to, i tlu butang nagu, du damsù gami di kenen.’ Én manyu kadang di ku Faraon. ");
INSERT INTO bps_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kabay gadègu là gamu faloh i harì lamwà di Idyif, silang ku toogu kenen nleges. ");
INSERT INTO bps_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Taman mdà di bong gnagangu fanlayamgu kadang i dad to di Idyif fagu di dad tnikeng i nimògu. Kafnge én, falohan gamu lamwà. ");
INSERT INTO bps_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Mimò agu kfagu, fye nafè gamu i dad to Idyif, du fye di kalwàyu nun bléla gamu, du fye là gamu magu i landè gebeyu. ");
INSERT INTO bps_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Na kat satu libun di bel Israél, mni ale kadang di dad demela saldan na di dademe libun di Idyif i mnè di dale, i dad kas, salafì, blawen, na dad klaweh. Na falsakla kadang i dad ngàla dee ani. Na ani kfaguyu mebe knun i dad to Idyif.” Én gman Dwata di ku Mosis. ");
INSERT INTO bps_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Kabay tmimel Mosis, manan, “Kaflingengu dun, ku i dad bel Israél là faglut dagu, demen là flinge i mangu dale, na balingla man, ‘E, là lmen Dwata msut di ge.’ Ku ani manla tan sa i kibògu?” ");
INSERT INTO bps_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Na man Dwata di kenen, “Tan kè i nagotam?” Timel Mosis, manan, “Tugad sa ani.” ");
INSERT INTO bps_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Na man Dwata kenen, “Batam tugadam di tanà.” Taman bat Mosis na mbaling ulad, na knilan. ");
INSERT INTO bps_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kafnge én, lêman talù Dwata di kenen, manan, “Nagotam i ikongan.” Taman nagot Mosis na lêman mbaling tugad. ");
INSERT INTO bps_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Na taman man Dwata, “Nimoam kadang i gamtikeng ani, fye fnaglutla Dwata i Amu, i Dwata fnangamfù dad gutambulla Abraham, Isaak, na Dyékob, tatoo msut di ge.” ");
INSERT INTO bps_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Na man Dwata, “Na fafusukam i kmalam di lam i tahà sigalam.” Nimen Mosis na di kafalwaan i kmalan di saulan, too bukay, du tadankat i tduk tfig. ");
INSERT INTO bps_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Talù Dwata, manan, “Lêmanam fafusuk i kmalam di lam i tahà sigalam.” Lêman nimò Mosis ani, na kafalwaan i kmalan tamgulê nan. ");
INSERT INTO bps_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Na man Dwata i Amu di kenen, “Kadang ku là faglut ge i dad bel Israél di kimoam i muna tnikeng, ken di galwe tnikeng nimoam tafnaglutla. ");
INSERT INTO bps_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kabay, ku là ale fa faglut balù mgimoam i galwe tnikeng ani gine, na là ale flinge ge, mwè ge yéél di laweh yéél Nilu, na kokam di kafag tanà. Na i yéél nweam ditù, mbaling litè.” Én man Dwata. ");
INSERT INTO bps_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Na man Mosis di Dwata i Amu, “Tabyà Amugu, agu i to là fulung stulen, mdà fa di muna, kel di bang tamsut ge di deg. Léét i talùgu, na là agu fulung talù.” ");
INSERT INTO bps_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Na tmimel Dwata i Amu, manan, “Simto kè mgimò bà i dad to du fye talù ale ku là talù? Simto kè mgimò dad mata na dad klinge du fye mite ale ku là mite, demen mlinge ale ku là mlinge? Agu sa, Dwata i Amu, tamimò dun! ");
INSERT INTO bps_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Taman mdà ge, du agu tmabeng ge di ktaluam, na tdògu ge ku tan i kfagum stulen.” ");
INSERT INTO bps_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Kabay man Mosis lêman, “Amugu, ku fakay, satu to i dekam.” ");
INSERT INTO bps_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kaklinge Dwata i Amu i gman Mosis, mbaling too flabè, na manan di kenen, “Na nun flanekam Aron mdà di bel Libay, na gadègu too kenen fulung talù. Déén kenen di dalan salu dini, du smitong ge. Too kenen kadang lehew smite ge. ");
INSERT INTO bps_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Na agu sa tmulen ge i kmanam di kenen, na tnabengta gamu di ktalùyu, na tdògu gamu ku tan i nimòyu. ");
INSERT INTO bps_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aron kadang, i baam di dad to, na ge gambet dagu, du ge tamdò kenen ku tan i manan. ");
INSERT INTO bps_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Na toom nebe i tugad ani, du fagu di tugad ani, mimò ge dad tnikeng.” ");
INSERT INTO bps_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Na mulê Mosis di tewen Dyétro, na mbal di kenen, manan, “Ku fakay di ge, beg agu samfulê di dad togu di Idyif, du neyegu ku nun mto fa.” Na tmimel Dyétro, manan, “Hae, fakay sa, na Dwata mifat ge.” ");
INSERT INTO bps_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Na ditù fa Mosis di bulul di Midyan, tagman Dwata i Amu di kenen, gmanan, “Fakay samfulê ge di banwe Idyif, du i kdee dad to mayè mati ge, tamti ale mati nan.” ");
INSERT INTO bps_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Taman fagin Mosis yaanan na i dad ngaan lagi, na fsakayan ale di lmanaf gambet kudà, dnagit dongki, na mdà ale salu di banwe Idyif. Na neben i tugad man Dwata kenen. ");
INSERT INTO bps_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Na Dwata i Amu, lêman talù di ku Mosis, manan, “Di kakelam di Idyif, salu ge di ku Faraon, na nimoam i kdee dad tnikeng fagu di glal i tagablégu di ge. Kabay fgalgu i ulun, du fye laan falwà i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kafnge én, manam ku Faraon, ‘Agu Dwata i Amu, mangu, tamgalékgu i dad bel Israél mbaling dad togu, na mabtas ale di deg, salngad i kabtas i tingà lagi sangal twege. ");
INSERT INTO bps_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Na tagmangu di ge, falwaam i dad bel Israél, du fye fakay ale mangamfù di deg. Kabay du laam ale faloh, taman fnatigu i tingaam lagi sangal twege.’ Én manam kadang di harì.” ");
INSERT INTO bps_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Na satu butang di ksalu Mosis, yaanan, na dad ngaan, di Idyif, nun guslobla du ftud ale. Na klola déén msut Dwata i Amu di dale, na fan fnatin Mosis, du mdà di kaflabean kenen. ");
INSERT INTO bps_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Na Sifora, yaan Mosis, tagadean i duenan flabè Dwata ku Mosis, du laan nimen i dek Dwata, du laan fa ftulì i tingaan sangal twali. Taman nwean i batu too gamban, na tnulian i satu tingàla lagi, na i kindal gwean batan di dad blì Mosis. Na du i ktulì ani tagnè nimò i dad bel Israél, taman man Sifora di ku Mosis, “Làgu gadè duenan là fakay ku là mlitè i tingàta.” ");
INSERT INTO bps_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Na mdà di taktulì i tingàla lagi, là fnati Dwata Mosis. ");
INSERT INTO bps_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Na di bang ani, man Dwata i Amu di ku Aron, “Salu ge ditù di banwe gulandè to, du snitongam Mosis.” Taman salu ditù Aron, na smitong i twalin di bulul Dwata dunan Sinay. Na di ksitela nalakan kenen. ");
INSERT INTO bps_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Na tulen Mosis ku Aron i kdee gman Dwata i Amu di kenen, na i kdee dad tnikeng fimoan kenen. ");
INSERT INTO bps_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Na fadlug Mosis na Aron salu di Idyif. Kakella ditù santifunla i dad tua di bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Tulen Aron di dale i kdee gman Dwata i Amu, di ku Mosis. Na kafnge én, nimò Mosis i dad tnikeng di muna i dad to, ");
INSERT INTO bps_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","na fnaglutla dek ale Dwata di dale. Na kaklinge i dad tua too kamdo Dwata i Amu dad bel Israél, na tateenan i bong kaflayamla di falel i dad to Idyif, lkuad ale, du mangamfù ale kenen. ");
INSERT INTO bps_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Kafnge i kastulenla di dad tua di dad bel Israél, Mosis na Aron salu di ku Faraon, harì di Idyif, na manla, “Tabyà di ge, ani i man Dwata i Amu, i Dwata fnangamfù dad bel Israél, manan, ‘Faloham i dad togu salu di banwe gulandè to, du damsù na mangamfù ale di deg.’ ” ");
INSERT INTO bps_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Na tmimel i harì, manan, “Simto kè Dwata i Amu manyu ani? Na kan ku nimengu kenen na falohgu i dad bel Israél salu ditù? Làgu dilè Dwata i Amu, na toogu là faloh i dad bel Israél fsalu ditù.” ");
INSERT INTO bps_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Na tmimel ale Mosis, manla, “I Dwata fnangamfù dad to Hibru tamsut di gami. Tabyà, faloham gami magu tlu butang, salu di banwe gulandè to, du beg gami damsù di Dwata i Amu, i Dwatami. Du ku làmi nimò ani, fanlayaman gami fagu i dad tduk demen fnatin gami.” ");
INSERT INTO bps_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kabay lêman talù i harì di dale, manan, “Simto gamu kè, du fakayyu fafanak i dad to di dad nimòla? Samfulê gamu di nimòyu! ");
INSERT INTO bps_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","I dad toyu, i bel Israél, too dee ale fa di dad to Idyif, na kayèyu kè fatlag i nimòla? Là fakay!” Én man i harì. ");
INSERT INTO bps_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Di duh én, dek i harì i dad to Idyif, gal magot i dad lifan, na i dademe dad Hibru fagotla i dademela bel Israél di nimòla, manan, ");
INSERT INTO bps_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Nangyu banlé i dad to Hibru lami fali galla bol fitak imò dad brik. Ale fafwèyu i lami. ");
INSERT INTO bps_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Kabay fimòyu dale i salngad kdee dad brik di muna nimòla. Nangyu nsud i kdeen. Là kè gablà i nimòla, du mbal ale di deg lamwà dini, du fye fakay ale damsù di Dwatala. ");
INSERT INTO bps_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tananùyu fa baling i nimò i dad lagi, du fye fadlug ale mimò, na làla gaflinge i dad kakakéng tulen Mosis.” Én man Faraon. ");
INSERT INTO bps_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Taman i dad magot i dad lifan, lamwà ale di muna i harì na manla di dad bel Israél, manla, “Man i harì là gami nan mlé gamu lami. ");
INSERT INTO bps_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gamu i mngabal lami balù nè i gumngabalyu, bay làmi sa nsud i nimòyu. I kdee nimòyu di muna di kablémi gamu lami, én i kdee nimòyu ani.” ");
INSERT INTO bps_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Taman tì lamngab dad to di klamang Idyif, du mngabal ale lami. ");
INSERT INTO bps_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Na too ale gnaga i dad to Idyif, i magot i dad lifan na galla man, “Nimòyu ani, salngad kdee di galyu nimò di klit i duh di muna fa, di kablémi gamu lami.” ");
INSERT INTO bps_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Na i dad to Idyif, i magot i dad lifan, bnadasla i dad to Hibru, i fagotla i dademela bel Israél di nimòla. Snalekla ale, manla, “Kan ku talà gmagan i dad lifan ani mimò dee brik salngad di galla nimò?” ");
INSERT INTO bps_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Na i dad to Hibru, i fagotla i dademela bel Israél, salu di ku Faraon, du fakdo ale di kenen, manla, “Gumdatahmi, kan ku tananuam i nimò i dad lifanam? ");
INSERT INTO bps_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Dekam gami mimò brik, bay landè lami blé di gami dad lifanam. Na ani, too gami fa bnadas na landè sa salàmi, bay gsalà i dad to Idyif, i dad magot i dad lifanam.” ");
INSERT INTO bps_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tmimel i harì, manan, “Tay, too gamu mataka, taman fakdo gamu fye falohgu gamu lamwà di banwe ani, du fye damsù gamu di Amuyu Dwata. ");
INSERT INTO bps_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Na samfulê gamu di nimòyu. Landè lami blé gamu, bay balù én tooyu nimò i kdee brik salngad i nimòyu di muna di kablémi gamu lami.” Én man i harì. ");
INSERT INTO bps_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Di kaklinge i dad Hibru fagotla i dademela bel Israél, i gman i harì, gadèla too sasè kalima i kdeela, du là ale gmagan mimò i dek i harì. ");
INSERT INTO bps_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Di kdàla di muna Faraon, teenla Mosis na Aron fatan dale. ");
INSERT INTO bps_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Na manla di dale Mosis, manla, “Teen sa i Dwata i Amu, i mgimòyu ani, na fanlayaman gamu. Hae, du mdà di gamu i duen i harì na i dad ganlalan too knangla gami. Na fagu di nimòyu ani banléyu ale dalanla mati gami.” ");
INSERT INTO bps_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Na lêman talù Mosis di Dwata i Amu, manan, “E, Amugu Dwata, kan dé ku fanlayamam dad tom ani? Na kan kè i duenam mdek deg dini ku ani kiboam dale? ");
INSERT INTO bps_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Hae, du mdà di kastulengu di harì, du tulengu kenen i gmanam, too baling matnù i kafsasean i dad tom, na balù ani i kagkahla landè tabengam dale.” Én man Mosis di Dwata. ");
INSERT INTO bps_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Na talù Dwata i Amu di ku Mosis, manan, “Mdà ani kadang teenam i nimògu di ku Faraon. Mdà di bong gnagangu nlegesgu kenen na falohan i dad togu lamwà di banwe ani. Nlegesgu kenen, du fye kenen baling i falwà dale di banwen.” ");
INSERT INTO bps_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Fadlug Dwata talù di ku Mosis, manan, “Agu sa Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Di muna fa, tafitegu di ku Abraham, di ku Isaak, na di ku Dyékob deg i Dwata Too Mtulus, bay i dagitgu, dunan Dwata i Amu, làgu fgadè di dale. ");
INSERT INTO bps_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Tafakanggu di dale i blégu dale i banwe Kanaan, i banwe flo gumnèla di muna, i ise ale mfun dun. ");
INSERT INTO bps_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Na talingegu i dalong i dad togu, dad bel Israél, i nlifan i dad to Idyif, na làgu glifet i gfakanggu di dad gutambulla. ");
INSERT INTO bps_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Taman tnulenam ale i mangu, manam, ‘Agu Dwata i Amu, na falwàta gamu di falel i dad to Idyif. Falwàta gamu mdà di kaglifanyu di dale. Nsògu gamu di agotla, fagu di bong gnagangu i gfitegu, na fanlayamgu ale. ");
INSERT INTO bps_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Dnawatgu gamu i too dad togu, na deg sa i Dwata fnangamfùyu. Na gadèyu kadang deg sa Dwata i Amu, i Dwata tooyu fnangamfù, di kafalwàgu gamu di kaglifanyu di dad to Idyif. ");
INSERT INTO bps_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Na nebeta gamu di tanà i toogu fakang blé ku Abraham, Isaak, na Dyékob. Hae, blégu di gamu kadang, du fye nfunyu. Agu sa Dwata i Amu.’ Ani tulenam kadang di dad bel Israél.” ");
INSERT INTO bps_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Na taman tulen Mosis di dad bel Israél i gman Dwata, bay, là ale mayè flinge dun, du too sè klidùla, du mdà di kaglifanla di dad to Idyif. ");
INSERT INTO bps_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Na lêman man Dwata i Amu di ku Mosis, ");
INSERT INTO bps_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Salu ge lêman di ku Faraon, harì di Idyif, na tulenam kenen toon faloh i dad bel Israél lamwà di banwen Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kabay man Mosis di Dwata i Amu, “Ku là flinge di deg i dad dademegu bel Israél, lumban fa i harì là flinge, na labi fa, du là agu fulung talù.” ");
INSERT INTO bps_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Na Dwata i Amu talù di ku Mosis, manan, “Fanbalingta ge gambet deg di fandam Faraon, du ge tmulen i flanekam Aron ku tan i manan di harì ani. ");
INSERT INTO bps_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tnulenam Aron i kdee dad dekgu ge ani, na kenen i tmulen di ku Faraon toon faloh i dad bel Israél lamwà di banwen Idyif. ");
INSERT INTO bps_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Kabay fgalgu i ulun, na balù fa ku mimò agu i dee tnikeng, ");
INSERT INTO bps_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","knean laan flinge ge. Kafnge én, toogu fanlayam i dad to Idyif, na agu sa falwà i dad togu dad bel Israél di banwe Idyif, fagu i dad flayamgu di dad to Idyif. ");
INSERT INTO bps_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na di kaflayamgu i dad to Idyif, na di kebegu i dad bel Israél lamwà di banwela, gadèla agu sa Dwata i Amu.” Én man Dwata. ");
INSERT INTO bps_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Na kafnge én, nimen Mosis na Aron i dek Dwata i Amu dale. ");
INSERT INTO bps_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Di bang ktalùla di harì di Idyif, tawalu falò fali Mosis na Aron tawalu falò tlu fali. ");
INSERT INTO bps_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Na man Dwata i Amu di ku Mosis na Aron, ");
INSERT INTO bps_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ku fni Faraon kadang i gamtikeng di gamu, dekam ku Aron batan i tugadan di tanà di muna Faraon na mbaling ulad.” ");
INSERT INTO bps_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kafnge én, salu Mosis na Aron di ku Faraon, na nimenla i dek Dwata i Amu dale. Bat Aron i tugadan di muna Faraon na di dad ganlalan, na tì mbaling ulad. ");
INSERT INTO bps_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kafnge én, fatlo Faraon i kdee dad to nun gnadè, na dad dademe fulung mimò tnikeng, na fagu di dad gnadèla gamgimò ale salngad nimò Aron. ");
INSERT INTO bps_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Hae, di kbatla i dad tugadla mgimò dad ulad. Kabay i tugad Aron i mbaling ulad gine, fanlon i dademe dad ulad. ");
INSERT INTO bps_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kabay glut i gman Dwata i Amu, du balù ani tnikeng teenan, mgal fa ulu harì, na laan fanlinge ale Mosis. ");
INSERT INTO bps_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Na lêman man Dwata i Amu di ku Mosis, “I ulu Faraon too mgal, na laan faloh i dad bel Israél lamwà di banwe ani. ");
INSERT INTO bps_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Taman fayah flafus salu gamu di kenen di slaan salu di yéél Nilu. Na déén di kilil gufatanyu kenen, na nebeyu i tugad i tambaling ulad. ");
INSERT INTO bps_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Na manyu di kenen, manyu, ‘Dwata i Amu, i Dwata fnangamfù dad to Hibru, mdek gami dini di ge, du stulen di ge, fye faloham lamwà dini i dad ton, fye mangamfù ale di kenen di banwe gulandè to. Kabay kel ani là ge mayè flinge. ");
INSERT INTO bps_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Na man Dwata i Amu, fagu di fanan nimò, gadeam kadang kenen sa Dwata i Amu. Taman bunalgu i tugad ani di tah i yéél ani, na mbaling litè. ");
INSERT INTO bps_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Na di kimògu ani, i dad nalaf mti mati, na i yéél kadang mbaling bun balok, na i dad to Idyif là ale kadang gamginum i yéél ani.’ ” ");
INSERT INTO bps_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Na fadlug talù Dwata i Amu di ku Mosis, manan, “Tnulenam Aron tdoan kadang i tugadan di kdee dad yéél, i dad yéél maloh di gusambang i tanà, i dad ktufa, na dad tunà di Idyif ani, na i dad yéél ani mbaling litè. Maloh i litè ani kadang di klamang Idyif, balù i yéél di gumusekla mbaling litè.” ");
INSERT INTO bps_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Di kafnge talù Dwata, nimen Mosis na Aron i kdee dek Dwata i Amu dale. Di muna i harì na dad ganlalan bunal Aron i tugad di tah i yéél Nilu, na tì mbaling litè. ");
INSERT INTO bps_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Mti mati i dad nalaf, na i yéél ani mbaling litè gine too bun balok, taman i dad to Idyif talà gamginum i yéélan. Na maloh litè di klamang Idyif. ");
INSERT INTO bps_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kabay i dad to nun gnadè di Idyif, fagu di dale gnadè, gamgimò ale salngad nimò Aron. Taman glut i gman Dwata i Amu, du mgal fa ulu Faraon, na laan flinge ku Mosis na Aron. ");
INSERT INTO bps_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Baling samfulê i harì di bong gumnean, na fbayaan i mgimò ale Mosis gine. ");
INSERT INTO bps_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Na i dad to Idyif makol ale i dad ktufa di kilil i yéél Nilu, du fye gamwè ale yéél ninumla, du talà ginum sa i yéél mdà di laweh i yéél ani. ");
INSERT INTO bps_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Takubu i fitu duh, kafnge Dwata i Amu fbalingan litè i yéél. ");
INSERT INTO bps_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Na talù Dwata i Amu di ku Mosis, manan, “Samfulê gamu di ku Faraon na manyu di kenen i mangu ani, manyu, ‘Ani i man Dwata i Amu, “Faloham i dad togu lamwà, du fye mangamfù ale di deg. ");
INSERT INTO bps_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Du ku laam ale faloh lamwà, fanlayamgu i klamang banwem ani fagu di dee fak. ");
INSERT INTO bps_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","I yéél Nilu kadang fnò fak. Fusuk ale kadang di bong gumneam, di lam i sibayam, na kamyaf ale kadang di gumileam. Fusuk ale lêman di gumnè i dad ganlalam, na i dad tom, na balù di lam i kulangyu i gumimòyu knaan. ");
INSERT INTO bps_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kamyaf ale kadang di ge, di dad tom, na balù di kdee i dad ganlalam.” ’ ” ");
INSERT INTO bps_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Na fadlug talù Dwata i Amu di ku Mosis, manan, “Tnulenam Aron tdoan kadang i tugadan di tah i kdee dad yéél, dad yéél maloh di gusambang i tanà, na di dad tunà, na msut kadang i dee dad fak na mbel di klamang tanà Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Taman nimen ale Mosis i kdee gman Dwata dale. Na tdò Aron i tugadan di tah i kdee dad yéél di Idyif, na msut i dad dee fak na mbel di klamang tanà Idyif. ");
INSERT INTO bps_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Kabay i dad to nun gnadè, fagu di dale gnadè gamgimò ale salngad nimò Aron, na fsutla i dad fak mdà di yéél di tanà di Idyif. ");
INSERT INTO bps_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kafnge én, fngé Faraon Mosis na Aron, na manan, “Dmasal gamu di Dwata i Amu, fye nwean i dad fak ani, na falohgu i dad toyu lamwà, du fye damsù ale di Dwata i Amu.” ");
INSERT INTO bps_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Na tmimel Mosis, manan, “Tulenam deg ku kilen kayeam kdasalgu ge di Dwata i Amu, du mni tabeng di kenen gablà di ge, i dad ganlalam, na i dademe dad tom, du fye di kdasalgu, landè dad fak di klamang tanà, galwà alò di yéél Nilu.” ");
INSERT INTO bps_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Na tmimel Faraon, manan, “Fayah fdasalta ge.” Na man Mosis, “Nimògu i manam, du fye gadeam landè gasngad Dwata i Amu, i Dwata fnangamfùmi. ");
INSERT INTO bps_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Dad fak ani kadang tmagak gamu, na di dad gumnèyu, i dad ganlalam, na i dad tom, bay nun fa alò di yéél Nilu.” ");
INSERT INTO bps_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kafnge én, mdà Mosis na Aron di muna Faraon, na too fni Mosis tabeng di Dwata i Amu, du fye falwaan dad fak i tafeben di ku Faraon. ");
INSERT INTO bps_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Na nimò Dwata i Amu, i fni Mosis. I kdee dad fak mati ale di lam i dad gumnè i dad to, na di dad nasella, na ditù lêman di dad nligola. ");
INSERT INTO bps_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Na i dad to Idyif ludukla i dad fak tamati ani, taman i klamang banwe Idyif bun balok. ");
INSERT INTO bps_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Na glut i gman Dwata i Amu, du di kite Faraon talandè fak, talêman fgalan ulun, na laan flinge ku Mosis na Aron. ");
INSERT INTO bps_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kafnge én, lêman talù Dwata di ku Mosis, manan, “Tulenam ku Aron bunalan kadang di tanà i tugadan, na i kdee kfung di klamang banwe Idyif mbaling blabang.” ");
INSERT INTO bps_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Na nimenla i man Dwata ani. Na di kbunal Aron i tugadan i kfung di tanà, kdee kfung di banwe Idyif mbaling blabang, na mdon di dad to na di dad lmanafla. ");
INSERT INTO bps_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Na tilew i dad to nun gnadè, fsutla i dad blabang fagu di dale gnadè, bay là ale gmagan fsut dun. Na mdon i dad blabang di dad to na di dad lmanaf. ");
INSERT INTO bps_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Taman man i dad to nun gnadè di ku Faraon, manla, “Too glut nimò i Dwatala ani.” Kabay too glut i gman Dwata, du mgal fa i ulu i harì, na là kenen flinge. ");
INSERT INTO bps_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Na kafnge ani, talù lêman Dwata i Amu di ku Mosis, manan, “Fayah too flafus, lêmanam snite Faraon di ksalun di yéél, na manam di kenen, manam, ‘Ani man Dwata i Amu, “Faloham i dad togu lamwà di banwe ani, du fye fakay ale mangamfù di deg. ");
INSERT INTO bps_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Du ku laam ale faloh lamwà, fsutgu di ge, na di dad ganlalam, na di kdee dad tom, bong mlabung dad langad na salu ale di lam i dad gumnèyu. Na too fnò kadang i langad i dad gumnèyu, na balù fa di klamang i tanàyu. ");
INSERT INTO bps_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘ “Kabay i tanà Gosén, i gumnè i dad togu, làgu fakuf di kaflayam ani. Hae, du landè langad i febegu di dale. Nimògu ani, du fye gadeam agu, Dwata i Amu, mimò ani dini di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tnanigu i dad togu di ge dad to, na nimògu i tnikeng ani fayah.” ’ ” ");
INSERT INTO bps_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Na too dnohò Dwata i Amu, i kdee gmanan ani. Na fsutan too mlabung dad langad, na fusuk ale di bong gumnè Faraon, na di dad gumnè i dad ganlalan. Na mbel di klamang banwe Idyif, na malmo i banwela mdà di kdee i langad ani. ");
INSERT INTO bps_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kafnge én, fngé Faraon Mosis na Aron, na manan, “Mdà gamu, tafalohgu gamu damsù di Dwatayu dini di banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Kabay tmimel Mosis, manan, “Tabyà di ge, là fakay ku én nimòmi. Hae, du gadeam là salngad i tagneito nimò, du lmanaf dsùmi di Dwata i Amu, i Dwata fnangamfùmi, fnang i dad tom ani. Na ku én dsùmi, i dad tom di Idyif ani, balingla gami tnudà batu na mati gami. ");
INSERT INTO bps_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Taman là fakay ku là gami salu di gulandè to, i nagumi tlu butang, du damsù gami di Dwata i Amu, i Dwata fnangamfùmi, du ani i dekan gami.” ");
INSERT INTO bps_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Na man Faraon, “Hae, falohgu gamu salu di gulandè to, du damsù di Dwata i Amu, i Dwata fnangamfùyu, bay, nang gamu too fawag. Na dmasal gamu di Dwata i Amu, na fniyu tabeng gablà di gami, du fye falwaan i dee langad di banwemi ani.” ");
INSERT INTO bps_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Tmimel Mosis, manan, “Di kdàgu dini di ge, dnasalgu ge di Amugu Dwata, na fayah falwaan i dad langad di ge Faraon, na di ganlalam, na di dad tom. Kabay nangam gami lêman fangaw, na nangam klen i dad tomi lamwà di banwe ani, du fye fakay ale damsù di Dwata i Amu.” ");
INSERT INTO bps_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kafnge én, tagak Mosis i harì, na fnin di Dwata i Amu tabeng, fye falwaan i dad langad di banwe. ");
INSERT INTO bps_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Na tnimel Dwata i fni Mosis na tian falwà i dad langad mlayam Faraon, i dad ganlalan, na di dad ton, na landè langad gdè di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Kabay lêman fgal Faraon i ulun, na laan faloh i dad bel Israél lamwà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kafnge én, lêman talù Dwata i Amu di ku Mosis, manan, “Lêman gamu salu di ku Faraon i harì, na tulenyu i mangu ani, manyu, ‘Ani man Dwata i Amu, i Dwata fnangamfù dad to Hibru, manan, “Faloham i dad togu lamwà di banwe ani, du fye fakay ale mangamfù di dagu. ");
INSERT INTO bps_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Du ku laam ale faloh lamwà di banwe ani, ");
INSERT INTO bps_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","fanlayamgu gamu fagu di sasè tduk kel di dad lmanafyu, di dad kudàyu, di dad dongkiyu, di dad kamélyu, di dad bakayu, di dad bilibiliyu, na kel di dad kambingyu. ");
INSERT INTO bps_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kabay agu, Dwata i Amu, làgu fakuf kadang di kaflayam ani i dad lmanaf i dad bel Israél, alò i dad lmanaf i dad to Idyif gutadè i tduk ani. Bay, landè lmanaf i dad bel Israél mati kadang. ");
INSERT INTO bps_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Na fayah i kimògu dun ani.” ’ Én manyu kadang di harì.” ");
INSERT INTO bps_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na di gamtadol duh, too glut dnohò Dwata i Amu i gmanan. Taman i kdee dad lmanaf i dad to Idyif mti mati, bay landè balù satu lmanaf i dad bel Israél mati. ");
INSERT INTO bps_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Na dek Faraon i dad dademen to ditù, du neyela dad lmanaf i dad bel Israél, na fgadèla di kenen landè balù satu lmanafla mati. Bay, knean too mgal fa i ulun, na laan faloh i dad bel Israél lamwà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kafnge én, lêman talù Dwata i Amu di ku Mosis na Aron, manan, “Mwè gamu abu mdà di satu abu. Na Mosis, ge i smabul i abu ani salu tah di muna Faraon. ");
INSERT INTO bps_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","I abu ani mbaling kadang gambet kfung na sbalét di klamang Idyif. Na i dad to na balù dad lmanaf kadang fnisa mdà di abu gsabul di dale, na dad fisa én, mbaling malbang bkukang.” ");
INSERT INTO bps_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Taman di kafnge talù Dwata, mwè ale Mosis abu mdà di satu abu, na salu ale di ku Faraon. Na sabul Mosis salu tah di muna Faraon, na fnisa i dad to na i dad lmanaf na bankukang ale. ");
INSERT INTO bps_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Na i dad to nun gnadè là gamsalu di dale Mosis, du balù ale too nun bkukang di klamang i lawehla, salngad i kdee dad to Idyif. ");
INSERT INTO bps_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kabay Dwata i Amu, fgal i ulu Faraon na too glut i gman Dwata di ku Mosis, du laan fa fanlinge Mosis na Aron. ");
INSERT INTO bps_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Na fadlug talù Dwata i Amu di ku Mosis, manan, “Fayah flafus salu ge di ku Faraon, na manam di kenen ani, ‘Ani man Dwata i Amu, Dwata fnangamfù dad to Hibru, manan, “Faloham i dad togu lamwà di banwe ani, du fye fakay ale mangamfù di dagu. ");
INSERT INTO bps_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Du ku laam ale faloh lamwà, toogu fanlayam i dad ganlalam, na i dad tom, na balù ge, du fye gadeam landè nan dademe gasngad deg di klamang i banwe. ");
INSERT INTO bps_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Du di muna, ku tafitegu gamu i bong gnagangu mdà di kaflayamgu gamu fagu di satu tduk, tamati i kdeeyu nan. ");
INSERT INTO bps_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kabay flawilgu fa i nawayu, du fye mdà di kfisangu gamu fitegu i kdatahgu na i kgal i tulusgu, du fye i dengeggu mbel di kdee dad to di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kabay ani, toom fdatah fa i ktom, na laam faloh i dad togu lamwà di banwe ani. ");
INSERT INTO bps_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Taman fayah di salngad kagkah i duh ani, fulengu i dad lbatù tno i làyu fa lmen nagu di banwe Idyif mdà di kagatbuan kel ani, du too sasè. ");
INSERT INTO bps_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Taman ani, mdek ge i dad to fsilung i kdee dad lmanafyu na i dad lifanyu déén di dad nligoyu, du mulen kadang lbatù tno di kdee dad to na kdee dad lmanaf i làyu fsilung, na mati ale.” ’ ” ");
INSERT INTO bps_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Na di kaklinge i dad dademe ganlal i gman Dwata i Amu, likò ale. Na taman faflalla fsilung i dad lifanla na i dad lmanafla. ");
INSERT INTO bps_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kabay nun dademe làla kah dun di nawala i gman Dwata i Amu. Tìla fbayà di lwà di nligola i dad lifanla na i dad lmanafla. ");
INSERT INTO bps_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Na man Dwata i Amu di ku Mosis, “Kayangam i sigalam salu di langit, na fulengu kadang lbatù tno di klamang banwe Idyif, di dad to, di dad lmanaf, na balù di kdee dad fulela di nligola.” ");
INSERT INTO bps_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Na di kakayang Mosis i tugadan salu di langit, na fkilet Dwata i Amu, na fulenan dad lbatù tno, na smilà mdà di tah kel di tanà. Hae, fulen Dwata i Amu i dad lbatù tno di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Fulenan i dad lbatù tno, na fnaginan i malbang silà. Landè fa lmen salngad ani mdà di kgimò i banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Di klamang Idyif, i kdee i dad landè gugsilungla, dad to, na i dad lmanaf, tnadè ale i dad lbatù tno. Na balù i kdee dad fule i dad to na kdee dad kayu gutadè i dad lbatù tno, taman landè gdè i dad fanga i dad kayu. ");
INSERT INTO bps_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Alò i tanà di Gosén, i gumnè dad bel Israél, i là nulen dad lbatù tno. ");
INSERT INTO bps_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Na fngé Faraon Mosis na Aron, na manan, “Ani gamsalà agu, na too glut i nimò Dwata i Amu. Hae, agu na lêman i dad togu tagsalà. ");
INSERT INTO bps_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Dmasal gamu di Dwata i Amu, du fye fatlagan i kilet na i ulen lbatù tno, du glukas gami nan. Na ani falohgu gamu lamwà di banwe ani, na balù talà gamu mnè dini.” ");
INSERT INTO bps_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Na tmimel Mosis, manan, “Di kalwàgu di syudad ani kayanggu i dad sigalgu salu tah, na dmasal agu na fakdogu di Dwata i Amu, na fatlagan kadang i kilet na i ulen lbatù tno, du fye gadeam Dwata i Amu mfun i klamang banwe. ");
INSERT INTO bps_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kabay gadègu ge na i dad ganlalam là fa likò di Dwata i Amu.” Én gman Mosis di harì. ");
INSERT INTO bps_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I dad fule i dad to Idyif dnagit flak na barli, mti malmo, du tamulek i dad flak na tamunge i dad barli. ");
INSERT INTO bps_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Bay, i dad fule gambet fali dnagit wit na sfét là malmo, du là fa tmabò di tanà. ");
INSERT INTO bps_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kafnge én, mdà Mosis tnagakan Faraon na lamwà kenen di syudad. Na kayangan i dad sigalan salu tah di Dwata i Amu, na fnin tabeng di kenen. Na tatlag i kilet na ulen lbatù. Na talà mulen. ");
INSERT INTO bps_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Na di kite Faraon talà mulen na kmilet na talà fulen Dwata i lbatù tno, lêman gamsalà kenen. Kenen na lêman i dad ganlalan fgalla i dad ulula. ");
INSERT INTO bps_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Na too glut i gman Dwata i Amu di ku Mosis. Hae, du mgal i ulu Faraon, taman laan faloh i dad bel Israél lamwà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Na man Dwata i Amu di ku Mosis, “Lêman ge salu di harì. Tafgalgu i ulun na i dad ulu i dad ganlalan, du fye nun fa dad tnikeng nimògu, du fitegu di dale. ");
INSERT INTO bps_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nimògu ani, du fye satu duh, gtulenyu di dad ngàyu na dad fùyu ku tan i kibògu mlayam i dad to Idyif, fagu di dad tnikeng mgimògu di munala. Na i kdeeyu kadang gmadè Agu Dwata i Amu.” ");
INSERT INTO bps_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Taman salu Mosis na Aron ku Faraon na manla di kenen, manla, “Ani man Dwata i Amu, i Dwata fnangamfù dad to Hibru, manan, ‘Tay sa, bong klom là fdanà i ktom di deg. Faloham i dad togu lamwà di banwe ani, du fye fakay ale mangamfù di dagu. ");
INSERT INTO bps_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ku fadlug ge kamlen i dad togu na laam ale faloh lamwà, fayah fkelgu i mlabung tlangas dini di banwem ani. ");
INSERT INTO bps_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Là teen kadang i tanà, du maglimunla, du too dee ale. Knaanla i kdee i là malmo mdà di ulen lbatù, gakuf i dad kdee kayuyu. ");
INSERT INTO bps_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Too fnò kadang dad gumnèyu, i dad gumnè i dad ganlalam, na i dad gumnè i kdee dad to Idyif. Landè fa lmen teen i dad màyu, na balù dad muna toyu, i dee tlangas salngad ani mdà di knèla dini di banwe ani kel ani.’ ” Ani gine gman Mosis di ku Faraon. Na di kmanan ani mdà kenen na tnagakan Faraon. ");
INSERT INTO bps_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Di kdà Mosis, man i dad ganlal Faraon di kenen, manla, “Tan i klo Mosis kè smamuk gito? Faloham i dad bel Israél lamwà, du fye fakay ale mangamfù di Dwata i Amu, i Dwatala. Laam kè teen tamalmo i banweito ani?” ");
INSERT INTO bps_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kaklinge Faraon i gman i dad ganlalan ani, fngén Mosis na Aron. Na manan di dale, “Mdà gamu na mangamfù gamu di Dwata i Amu, i Dwatayu. Kabay simto di gamu lamwà kadang?” ");
INSERT INTO bps_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Tmimel Mosis, manan, “Kdeemi lamwà, dad ngàmi, na dad tuami, na dad bilibilimi, dad kambingmi, na dad bakami, du mimò gami i fista, du dmayen na damsù gami di Dwata i Amu.” ");
INSERT INTO bps_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Man Faraon di kenen, “Smafà agu di Dwata i Amu, làgu faloh i dad libun na i dad ngàyu magin lamwà, du too mbangal di deg i fan gamu mimò samuk. ");
INSERT INTO bps_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Na là fakay! Falohgu alò dad lagi lamwà, du mangamfù di Dwata i Amu, du ani fniyu di deg.” Kagtalù Faraon, falwaan Mosis na Aron di munan. ");
INSERT INTO bps_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Na man Dwata i Amu di ku Mosis, “Lêmanam kayang i sigalam salu di banwe Idyif ani, du fye salu dad tlangas dini na knaanla i kdee là malmo mdà di lbatù ulen.” ");
INSERT INTO bps_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Taman mimen Mosis Dwata, na kayangan i tugadan, na fbal Dwata i Amu i bong mgal nus, mdà di gumsut i duh, tayud i duh na tayud i butang. Di kaflafusan tanebe i nus i dad tlangas. ");
INSERT INTO bps_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Bong mlabung dad tlangas salu ditù na mdaf kdee di klamang banwe Idyif. Na là fa lmen teen i dad to i kalbong dee tlangas salngad ani, na talàla lêman teen salngad ani. ");
INSERT INTO bps_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tì msafang i klamang tanà kel di ktoo fitam tlangas. Knaanla i kdee dad là malmo di ulen lbatù, i gdè lamnok di dad nligo na i dad bunge i dad kayu. Na landè gdè dad mlunu doon di dad kayu demen i dad fule di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Na gasil fngé Faraon Mosis na Aron, na manan di dale, “Gamsalà agu di Dwata i Amu, i Dwatayu, na balù di gamu. ");
INSERT INTO bps_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tabyà, lêmanyu nlifet i salàgu, na dmasal gamu di Dwata i Amu, i Dwata fnangamfùyu, fye nwean i too blat kaflayam ani.” ");
INSERT INTO bps_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Taman tnagak Mosis Faraon na dmasal ale, du mni tabeng di Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Na fanlinge Dwata i Amu i dasalan. Taman fbalan lêman i bong mgal nus, bay fdu di gusdaf i duh, na falisan i dad tlangas di Fulè Mahin. Na talandè balù satu gdè tlangas di klamang Idyif. ");
INSERT INTO bps_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kabay fgal Dwata i Amu i ulu Faraon, na laan faloh lamwà di banwen i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Na lêman talù Dwata i Amu di ku Mosis, manan, “Kayangam i sigalam salu di langit, na febegu too kakifu di klamang Idyif ani. I kakifu i febegu too mgat.” ");
INSERT INTO bps_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mimen Mosis Dwata, taman kayangan i sigalan salu di langit na mbaling too kmifu i klamang Idyif, kel di tlu duh. ");
INSERT INTO bps_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Là site baweh i dad to Idyif, na landè galwà di gumnèla, du too kifu. Kabay too malwa di gumnè i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kafnge én, fngé Faraon Mosis, na manan di kenen, “Lamwà gamu di banwe ani, du mangamfù gamu di Dwata i Amu, na balù i dad libun na i dad ngàyu faginyu. Bay, i dad kambingyu, i dad bilibiliyu, na i dad bakayu i tagakyu dini.” ");
INSERT INTO bps_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Kabay tmimel Mosis, manan, “Là fakay, du ku én, ge sa i mlé gami i dad lmanaf i dsùmi na snakufmi, du blémi di Dwata i Amu, i Dwata fnangamfùmi. ");
INSERT INTO bps_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Taman là fakay ku làmi nebe i kdee dad lmanafmi, na balù satu làmi tnagak. Satu duenan, du i dad dsùmi di Dwata i Amu, i Dwata fnangamfùmi, làmi fa gadè ku i tan dad lmanaf fadsù Dwata gami, du silangmi gadè di kakelmi ditù.” ");
INSERT INTO bps_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kabay fgal Dwata i Amu i ulu Faraon, na laan ale faloh lamwà di banwe én. ");
INSERT INTO bps_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Balingan man di ku Mosis, “Fawag ge di munagu. Nang ge lêman salu di munagu, du ku lêmanta ge teen dini, fafatita ge.” ");
INSERT INTO bps_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Na tmimel Mosis, manan, “I knayeam nimengu. Hae, là agu lêman samfulê di ge.” ");
INSERT INTO bps_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Na tagman Dwata i Amu, di ku Mosis, “Febegu kadang di ku Faraon na di dad to Idyif i satu fa kaflayam. Na di kafnge én, falohan gamu lamwà dini. Hae, falwaan kadang i kdeeyu di banwe én. ");
INSERT INTO bps_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Taman manam di dad bel Israél, i kdeela mni di dademela saldan i dad kas nimò mdà di salafì na blawen.” ");
INSERT INTO bps_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Dwata i Amu tamimò i kfagu, fye nafè dad bel Israél i dad to Idyif. Na Mosis too mdengeg di kite i dad ganlal Faraon na di kite i dad to Idyif. ");
INSERT INTO bps_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Na di là fa mdà Mosis di muna Faraon, nun fa manan di kenen, “Ani i gman Dwata i Amu. Satu butang, di tngà butang, magu agu di klamang Idyif. ");
INSERT INTO bps_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Na di butang én, mati i kdee dad ngà lagi sangal twege di Idyif, mdà di tingà lagi sangal twege Faraon, i tamlas moon kenen kdatahan, kel di tingà lagi sangal twege i kdee dad to mdanà gambet i libun gmiling. Na balù i kdee dad lmanaf i sangal twege mati. ");
INSERT INTO bps_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Na kadang i sè klanu i dad to, linge i kdee dad to di klamang Idyif, na là ale fa lmen mlinge salngad ani, na là ale lêman mlinge klanu salngad ani. ");
INSERT INTO bps_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kabay i dad bel Israél làgu fakuf kadang di kaflayam ani. Landè fanlayam di dale balù i dad lmanaf landè mati, fye gadeam là salngad kibògu i dad to Idyif na i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Na kadang i kdee dad ganlalam ani, salu di deg na lkuad ale, du fakdo ale di deg, na manla kadang, ‘Tabyà, lamwà ge di banwemi ani, na faginam i dad to gal mlalò ge.’ Én man i dad ganlalam kadang, na kafnge én mdà agu di banwe ani.” Di klo Mosis talù ani, too sè i kaflabean, taman mdà kenen tmagak i harì. ");
INSERT INTO bps_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Tagman Dwata i Amu, di ku Mosis, “Là flinge ge i harì, du fye nun fa dad tnikeng nimògu dini di banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Na balù nimò Mosis na Aron i kdee tnikeng, mdà di Dwata, fgal Dwata i Amu i ulu Faraon, na laan faloh lamwà i dad bel Israél di banwen. ");
INSERT INTO bps_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Na ditù di banwe Idyif, lêman talù Dwata i Amu di ku Mosis na Aron, manan, ");
INSERT INTO bps_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mdà ani, i bulen ani i tnanin bulen i fali di gamu. ");
INSERT INTO bps_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Fgadeam di kdee dad bel Israél kadang di gasfaloan duh di bulen ani, kat satu lagi malék i tingà bilibili ku demen i tingà kambing i dsù kat malay. ");
INSERT INTO bps_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ku là dee di satu malay, na làla kè mti knaan i satu bilibili di sulê kmaan, fakay ku i satu malay saldan samtlaban kmaan ku gablà di kdeela. ");
INSERT INTO bps_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Na nalékyu i bilibili lagi, ku demen kambing lagi alò sfali i taklon sut na landè gukulangan. ");
INSERT INTO bps_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nifatyu ale, kel di gasfalò fat duh i bulen ani, na di too flabi, i dee dad bel Israél toola fnati i dad lmanaf ani. ");
INSERT INTO bps_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kafnge én, mwè ale dademe litè i lmanaf, na ihokla di lwe taldak i takab, na lêman di blabal di tah i takab di gumnè i gukmaanla dun. ");
INSERT INTO bps_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Di butang én, tnatêla di lifoh i ungad i lmanaf fnatila gine, na knaanla bol i dad anag féét, na gagin i fan landè falnok. ");
INSERT INTO bps_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nang gamu kadang kmaan i ungad matà demen snabew, bay i kdee tnatêyu di lifoh, balù mdà di ulun, dad blian, na dad kdee mnè di lam i tienan. ");
INSERT INTO bps_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Na tooyu fti knaan, na nangyu busek kel flafus. Ku nun gdè, snakufyu. ");
INSERT INTO bps_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Gambet ani kakaanyu dun. Lsakyu i klawehyu, i lafin blìyu, na magot gamu i tugadyu, na faflal gamu kmaan, du là sa mlo mdà gamu magu. Na i dagit i kakaan ani dunan, Duh Kaglius Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Di butang én, magu agu di klamang Idyif, na fnatigu i kdee dad ngà lagi sangal twege di dad to, na lêman di dad lmanaf. Na fanlayamgu i dad là glut mule i dad to Idyif. Agu alò Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Na i litè ihokyu di lwe taldak i takab, na lêman di blabal di tah i takabyu, ani i ilè i gamu gumnè. Na di kitegu kadang i litè, nliusgu gamu, na landè sasè kel di gamu di kaflayamgu i dad to di Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Fadlug talù Dwata di ku Mosis, manan, “Na i duh ani kadang, mgimò too mabtas di gamu, kel di dad belyu. Klit i fali gufaldamyu i mgimògu di gamu, na dnayenyu Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Fitu duh i kloyu kmaan fan landè falnok. Di tnanin duh, batyu i falnok i fan mdà di gumnèyu, du ku nun kmaan balù tan i nun falnok mdà di tnanin duh kel di gfitun duh, là kenen gakuf di dad togu dunan dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Di tnanin duh, na di gfitun duh, stifun gamu, du mangamfù gamu di deg. Nang gamu mimò di duh én, bay fakay gamu alò mimò knaanyu. ");
INSERT INTO bps_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Nimòyu i fista ani klit fali, i kakaan dad fan landè falnok, du fandamyu i duh kafalwàgu gamu di banwe Idyif. Fandamyu na i dad belyu i duh ani kel di atuan. ");
INSERT INTO bps_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mdà di too flabi i sfalò fat duh di tnanin bulen, kel di too flabi i lwe falò satu duh, fnanggu gamu kmaan fan i nun falnok. ");
INSERT INTO bps_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Nang gamu musek i falnok fan di gumnèyu di klo i fitu duh. Hae, du ku nun to, balù i bel Israél, ku demen i mahal to, kmaan balù tan i nun falnok, to én là gakuf di dad togu, dunan dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Taman nang gamu kmaan balù tan i nun falnok. Balù nè gamu, i fan knaanyu, alò i fan landè bol falnok.” Én gman Dwata. ");
INSERT INTO bps_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kafnge én, fatlo Mosis i kdee dad tua di dad bel Israél. Na manan di dale, “Malék gamu i tingà bilibili, ku demen kambing, di kat satu malay na tnatêyu na knaanyu di kakel i Duh Kaglius Dwata. ");
INSERT INTO bps_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mwè gamu i dad malnak fanga hisof, na lnabyu di tukung nun litè i bilibili demen kambing i tnatêyu, na ihokyu di lwe taldak i takab, na lêman di blabal di tah i takabyu. Na balù satu di gamu, nang lamwà di gumnèyu kel di flafus, ");
INSERT INTO bps_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","du magu Dwata i Amu di klamang banwe Idyif, du fnatin i dad ngà lagi sangal twege di dad to Idyif. Na di kiten kadang i litè di bà takabyu, nliusan i gumnèyu, na laan fafusuk i kasaliganan i dekan, du fnatin i dad ngà lagi sangal twege.” ");
INSERT INTO bps_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Na fadlug talù Mosis di dad tua di dad bel Israél, manan, “Mimen gamu i kdee gmangu gine, kel di dad belyu, na kel di atuan. ");
INSERT INTO bps_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Na di kakelyu kadang di satu duh, di banwe i fakang Dwata i Amu blé di gamu, tooyu fandam klit fali i Duh Kaglius Dwata di gamu. ");
INSERT INTO bps_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na ku smalek i dad ngàyu ku tan i duenan i Duh Kaglius Dwata too mabtas di gamu, na tan i duenan klit fali nun nimòyu gufaldamyu dun, ");
INSERT INTO bps_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","tulenyu di dale, ‘Ani damsù gami di Dwata i Amu, du ani i gufaldammi i kagliusan di knè i dad toito di banwe Idyif. Hae, du nliusan sa i dad gumnè i dad bel Israél, na laan fakuf di kfatin i kdee dad lagi sangal twege di dad to Idyif.’ Ani i tulenyu kadang di dad ngàyu.” Kagman Mosis ani, lkuad i dad bel Israél, du fnangamfùla i Dwata. ");
INSERT INTO bps_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kafnge én, nimenla i dek Dwata i Amu dale, fagu di ku Mosis na Aron. ");
INSERT INTO bps_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Na di tngà butang, fafati Dwata i Amu, i kdee dad lagi sangal twege di banwe Idyif, mdà di lagi sangal twege, tingà Faraon, i tamlas moon kenen kdatahan, kel di tingà twege i to bnilanggù. Na balù i kdee dad sangal twege i dad lmanaf mati. ");
INSERT INTO bps_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Di butang én, Faraon na i kdee dad ganlalan, na balù i kdee dad to Idyif, mgukat ale, du too nun mlanu di klamang Idyif, hae, du landè sa gumnè i landè to mati. ");
INSERT INTO bps_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Na di butang én fa, fngé Faraon Mosis na Aron, na manan di dale, “Mdà gamu, gamu na i dademeyu dad bel Israél. Mdà gamu di banwegu ani, na mangamfù gamu di Dwata i Amu, du ani sa i fniyu. ");
INSERT INTO bps_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Faginyu i dad bilibiliyu, dad kambingyu, na dad bakayu, na mdà gamu nan. Na dmasal gamu di Dwata, du fye blén di deg kafye.” ");
INSERT INTO bps_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Na gnaga i dad to Idyif i dad bel Israél, fye faflal ale mdà, lamwà di banwe Idyif, du manla, “Mati i kdeemi ku là gamu faflal lamwà.” ");
INSERT INTO bps_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Taman i dad bel Israél, tatìla fkah i harinala tamasbol nan, bay là nbol fa falnok, di gusamboolla dun, na fnungasla i dademe klawehla na tniangla. ");
INSERT INTO bps_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Tanimen i dad bel Israél i gman Mosis dale, du tamni ale di dad to Idyif i dad kas salafì na blawen, na lê dad klaweh. ");
INSERT INTO bps_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Tafkah Dwata i Amu, di nawa i dad to Idyif i kafèla i dad bel Israél, na taman bléla i dad fnila di dale. Na ani i kfagu i dad bel Israél gamgebe i dad knun i dad to Idyif. ");
INSERT INTO bps_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Na tamdà i dad bel Israél magu mdà di syudad Rameses di Gosén salu di Sukot. Na nam latu libu i kdee i dad lagi, na nun fa dee libun na dee dad ngà, lamwà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Na lê nun dee sahal dad to, na bong dee dad bilibili, dad kambing, na dad baka, i magin dale. ");
INSERT INTO bps_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Na tmaga ale fan i landè fa bol falnok, i nebela mdà di Idyif, du là ale gasleng fatlagad i kakaanla demen làla gbol i falnok di fan, du gnaga ale faflal lamwà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Fat latu tlu falò fali i klo dad bel Israél mnè di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na di duh ksikof i fat latu tlu falò fali, lamwà i kdee i dad to Dwata i Amu, di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Butang én, nunung Dwata i Amu, du fye galwà i kdee di banwe Idyif, taman i butang én too mabtas, na i dad bel Israél klit fali nimòla i butang gufaldamla i kafalwà Dwata i Amu dale, kel di atuan. Munung ale butang én, gambet i kunung Dwata i Amu dale, du dnayenla kenen. ");
INSERT INTO bps_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","18","Di kfaloh i harì di Idyif ku lamwà dad bel Israél di banwen, là ale nalak Dwata magu di dalan salu di tanà gumnè i dad to Filistin, balù én too gumdadong dalan mdà di Idyif salu di banwe Kanaan, i tanà i fakang Dwata blé dale. Hae, du balù nun tek nebela mdà di Idyif, man nawa Dwata, manan, “Ken mguman i fandam i dad togu, na samfulê ale di Idyif, ku teenla i dad to Filistin i dmuen dale, gatlagad samfati dale.” Taman nalakan ale flibut, fagu di dalan salu di banwe gulandè to, salu di Fulè Mahin. ");
INSERT INTO bps_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Na nebe Mosis i dad tulan Dyosif mdà di Idyif, du ani fafakang Dyosif di dad belan, du gmanan di dale di muna fa, manan, “Tnabeng gamu Dwata, du kadang satu duh, neben gamu lamwà di banwe Idyif salu di Kanaan, na di kebe Dwata gamu samfulê di Kanaan, tooyu nebe mulê i dad tulangu.” Én kated Dyosif di muna fa, di dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Na di kdà i dad bel Israél di banwe Sukot, mnè ale flo di banwe Étam, di kilil i banwe gulandè to. ");
INSERT INTO bps_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Na di mduh, Dwata i Amu malak dale, fagu di labun fkahan di munala. I labun ani, di mduh i kafbawehan tahà gambet i bong lahan gumnè, na di butang i kafbawehan gambet i lifoh tmuyal i dalanla, du fye fakay ale magu mduh demen butang. ");
INSERT INTO bps_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Na i labun na i lifoh ani, là lana di munala di mduh demen di butang. ");
INSERT INTO bps_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kafnge én, man Dwata i Amu ku Mosis, ");
INSERT INTO bps_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Manam di dad bel Israél, mdà ale di Étam, na magu ale di mahal dalan mdadong di banwe Fi Hahirot, na flo mnè déén di kagatngà di banwe dnagit Migdol na di mahin. Na flo mnè ale di kilil mahin mdadong di banwe Baal Sifon. ");
INSERT INTO bps_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Du fandam Faraon kadang tatlas i dad bel Israél, na glifut ale, du i banwe gulandè to gsen di fuléla, na i mahin gsen di munala. ");
INSERT INTO bps_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Na kadang fgalgu i ulu Faraon, du fye tnafikan gamu, du fye gdawatgu kadang kdayen di kite i dad to i bong gnagangu di kfisangu ku Faraon na i dad sundalun, na kadang gadè i dad to di Idyif, Agu Dwata i Amu.” Én gman Dwata. Taman nimen i dad bel Israél i dad dek Dwata dale, na mnè ale flo di kilil mahin. ");
INSERT INTO bps_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Di kaklinge i harì di Idyif, là samfulê i dad bel Israél di banwe Idyif di kakubu tlu duh, bay fadlug ale fawag di Idyif, mguman i fandam Faraon, na i dad ganlalan gablà di dale. Hae, du manla, “Kan ku falohito lamwà i dad bel Israél? Tay, tabaling landè dad lifanito.” ");
INSERT INTO bps_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Taman fafatlagad i harì i snakayan nun dad kudà, na faginan i dad sundalun. ");
INSERT INTO bps_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Na lê faginan nam latu i too fye snakay damyol dad kudà, gagin i dademe snakay nun kudà gusmakay i dad ganlalan. ");
INSERT INTO bps_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Na tafgal Dwata i Amu, i nawa Faraon, i harì di Idyif, na tnafikla dad bel Israél, i dad to galwà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Na i dad sundalu di Idyif, gagin i kdee dad kudà, na i dad snakay, na dad mebe i snakay, tnafikla i dad bel Israél, na gnumahla ale di guftudla di kilil i mahin, mdadong di banwe Fi Hahirot na i banwe Baal Sifon. ");
INSERT INTO bps_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Na di kite i dad bel Israél, i harì na i dad sundalun, salu di dale, too sasè klikòla, na mkit ale mni tabeng di Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Na manla ku Mosis, manla, “Nebem gami kè dini, du fye mati gami di banwe gulandè to, du talandè gulambangmi di Idyif. Tulenan gami ku tan i duenam mebe gami dini lamwà di banwe Idyif? ");
INSERT INTO bps_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Làmi kè gman di ge di kdéénito fa di Idyif, fye ku gami fbayà flifan di dad to Idyif? Fye fa ku gami fadlug flifan di dale, di mati gami dini di banwe gulandè to.” Én ugak i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Kabay man Mosis di dad to, “Nang gamu likò. Nang gamu mila, bay fanak gamu, na teenyu kadang di duh ani, i nimò Dwata i Amu, du falwaan gamu di falel i dad to Idyif. I dad to Idyif i teenyu ani, kadang talàyu ale lêman teen. ");
INSERT INTO bps_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Dwata i Amu, kenen sa tlasito samfati dale, alò ito tatì fanak.” Én gman Mosis. ");
INSERT INTO bps_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kafnge én, talù Dwata i Amu di ku Mosis, manan, “Kan ku fnim di deg tabeng? Manam di dad bel Israél fadlug magu. ");
INSERT INTO bps_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Na tayalam i tugadam di tah i mahin, na kadang masatngà i mahin, na i gufaféan kadang mbaling kafag, du fye gifal i dad bel Israél di gukafag tanà. ");
INSERT INTO bps_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Fgalgu ulu i dad to di Idyif, du fye tnafikla gamu, du fye gdawatgu kadang kdayen di kite i dad to i bong gnagangu di kfisangu ku Faraon, na i dad sundalun, na i dad snakayan, na i dad to smakay i dad kudaan. ");
INSERT INTO bps_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kadang, too gadè i dad to Idyif, agu i Dwata i Amu, di kitela i bong gnagangu di kfisangu ku Faraon, na i dad snakayan, na i dad to smakay i dad kudaan.” Én gman Dwata. ");
INSERT INTO bps_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kafnge én, i kasaligan i Dwata, gal muna di dad bel Israél, mili kenen di gsen fulé. Na i labun kafbaweh i bong lahan gumnè, lê mili di fuléla, ");
INSERT INTO bps_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","salu di gutngà i dad to Idyif, na i dad bel Israél. Na i labun gsen di dad to Idyif, too kifu, bay di balin, i labun gsen di dad bel Israél, too malwa. Taman tayud i butang là ale gasdadong. ");
INSERT INTO bps_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Na di butang én, tayal Mosis i sigalan di tah i mahin, na Dwata i Amu, lanwan i dalan di lam i mahin, du tayud i butang falyakan i mahin, fagu di kbal i bong nus fdu di gusut i duh. Na masatngà i mahin, na mbaling kafag i tanà di dalan én, ");
INSERT INTO bps_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","na magu i dad bel Israél di mahin, di kafag tanà mgimò Dwata. Na i mahin mgimò gambet i diding di sbalà i kilil i dalan gumagula. ");
INSERT INTO bps_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Na tnafik ale i dad to Idyif magu di dalan di mahin. Hae, kdee dad kudà Faraon, na dad snakayan, na i dad to smakay i dad kudaan, lalòla i dad bel Israél di dalan di mahin. ");
INSERT INTO bps_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Di là fa mwal, lngalung Dwata i Amu mdà di lifoh na labun di dad sundalu i Idyif, na snamukan ale. ");
INSERT INTO bps_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Hae, snamukan ale, fagu di fafgalan katbiling i dad kliling dad snakayla, taman malima di kfilala dun. Na man i dad to Idyif, manla, “Samfulê ito, du Dwata i Amu, demeito sfati, du nsenan ale, na dnuenan ito.” ");
INSERT INTO bps_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kafnge én, man Dwata i Amu di ku Mosis, “Lêmanam tayal i sigalam di tah i mahin, du fye masasulê i mahin na maglimun i dad to Idyif, na i dad snakayla, na i dad to smakay i dad kudà.” ");
INSERT INTO bps_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Taman tayal Mosis i sigalan di tah i mahin, na di kakwalan masasulê i mahin di tagnè kagkahan. Tilew i dad to Idyif mila di mahin, bay baling ale bat Dwata i Amu di mahin, na mlimas ale. ");
INSERT INTO bps_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Masasulê i mahin na mti maglimun i dad snakayla, na i dad kudàla. I kdee dad sundalu i harì i tmafik i dad bel Israél di lam i mahin, landè balù satu gdè mto, slame maglimun i mahin. ");
INSERT INTO bps_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kabay i dad bel Israél tagifal ale di gukafag tanà di gutngà i mahin. Na di kwananla na di ibengla, i mahin tamgimò gine gambet i diding di sbalà i kilil i dalan atù. ");
INSERT INTO bps_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Na én kfagu Dwata i Amu falwà i dad bel Israél, di falel i dad to Idyif di duh én. Na teenla dad to Idyif tamati tidol di kilil i mahin. ");
INSERT INTO bps_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na di kite i dad bel Israél, i bong gnagan Dwata i Amu, di kfisanan i dad to Idyif, mbaling ale likò kenen. Na taman smalig ale di kenen na di lifanan Mosis. ");
INSERT INTO bps_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kafnge én, mlingag Mosis na i dad bel Israél, i kdayenla Dwata i Amu. Na ani i lingagla, manla, “Mlingag agu di Dwata i Amu, du mdatah kenen na fagu di bong gnaganan, too kenen matu. Du i dad kudà na i dad snakay, tatian ale bat di lam i mahin. ");
INSERT INTO bps_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Dwata i Amu, i gumlingaggu na gumdà i galgu. Kenen i falwà deg di dad to dmuen deg. Kenen i Dwatagu, taman, dnayengu kenen. Kenen i Dwata fnangamfù dad gutambulgu, taman, dnayengu i kdatahan. ");
INSERT INTO bps_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Dwata i Amu, too fulung di kasfati, Dwata i Amu i dagitan. ");
INSERT INTO bps_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","I dad snakay Faraon, na i dad sundalun, tatian bat ditù di mahin. Na i dad mdatah ganlal Faraon tamlimas ale di Fulè Mahin. ");
INSERT INTO bps_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Maglimun ale i bong mngalam mahin, na galnab di too gumngalaman, gambet i batu. ");
INSERT INTO bps_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Amugu Dwata, i sigalam kwanan too nun gnaganan. Hae, du i sigalam kwanan gmagan misan, na falmo i dad to dmuen dagu. ");
INSERT INTO bps_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na di kdatah i katum, fnisanam i dad to dmuen ge. I kaflabeam too minit gambet i lifoh, taman, malmo ale gambet lami di lifoh. ");
INSERT INTO bps_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Tanyufam i mahin, na masatngà na mastifun salu tah. Na tadag i mahin gambet i diding, na mbaling kafag na mgal tanà di gumngalam i mahin. ");
INSERT INTO bps_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Na fdag i dad to dmuen gami du manla, “E, tnafikmi ale, na kanfèmi ale kadang Na sansalelmi i dad knunla, na i kalbong knayèmi nwè, nwèmi. Nsòmi fais di lumàmi, du nwèmi i kdee nfunla.” Én i kafdag i dad to dmuen gami. ");
INSERT INTO bps_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kabay di alò sulê kyufam, na maglimun ale i mahin. Tì ale galnab gambet i tamla bat di gumngalam i mahin. ");
INSERT INTO bps_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","E, Amugu Dwata, simto dad mule i gasngad ge? Simto i salngad ge, i ktium too mdatah? Simto i salngad ge, i bong knengam too gamtikeng? Simto i salngad ge, i bong gnaganam di kimoam dad tnikeng? ");
INSERT INTO bps_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tatayalam sigalam kwanan, na nlimun i mahin i dad to dmuen gami. ");
INSERT INTO bps_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Fagu di kakdom landè kgilin, dnohoam kadang i fakangam na nalakam i dad to tansoam mdà di falel i dad to dmuen dale. Fagu di bong gnaganam, gmagan ge malak dale di banwe i gumneam, i tagaam dale. ");
INSERT INTO bps_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Linge kadang, kdee bung dad to, gablà di kafalwaam gami di banwe Idyif, na kankal ale di klikòla. Na too sè klikò i dad to Filistin. ");
INSERT INTO bps_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","I dad ulu, i dad to di banwe Idom, too ale likò. Na i dad to, i too nun glal, di banwe Moab, kankal ale. Na kadang, i dad to di banwe Kanaan, lana i klabèla mdà di klikòla. ");
INSERT INTO bps_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Fisan ale i klikòla. E, Amugu Dwata, di kitela i bong gnaganam, là ale galyak, du mdà di sè klikòla, kel di klius i dad tom, i dad to tansoam mdà di kaglifanla. ");
INSERT INTO bps_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Satu du kadang, Amugu Dwata, nebem ale, na fneam ale di bululam i banwe tanalékam i gumneam, i gumneam i too mabtas, i gumneam ge mimò dun. ");
INSERT INTO bps_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","E, Amugu Dwata, ge i magot kadang i klamang banwe kel di landè sen.” Ani gine lingag Mosis. ");
INSERT INTO bps_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","I dad bel Israél tamagu di mahin di kafag tanà, di gumasatngà i mahin. Kabay di klalò i dad to Idyif, i mebe i dad snakay na i dad kudà, tasansulê Dwata i Amu i mahin, na maglimun ale. ");
INSERT INTO bps_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Na Miriam, satu tugad Dwata, i flanek Aron na Mosis libun, tufì mlingag. Nwean i satu bung agafla dnagit tamburin, na i kdee dad dademen libun lê mwè i dale tamburin, na mlalò Miriam magaf i dad agafla én na kdeela sayew dmayen Dwata. ");
INSERT INTO bps_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Na mlingag Miriam dale na ani i lingagan, manan, “Mlingag ito di Dwata i Amu, du mdatah kenen, na fagu di bong gnaganan, too kenen matu. Hae, du i dad kudà na i dad snakay mdà di Idyif tatian ale bat di lam i mahin.” ");
INSERT INTO bps_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Na di kdayenla Dwata, malak Mosis i dad bel Israél magu mdà di Fulè Mahin salu di banwe gulandè to dnagit Sur. Tlu du i klola magu déén di banwe gulandè to, na landè teenla yéél. ");
INSERT INTO bps_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kafnge én, kel ale di banwe Marah, bay là ale gamginum i yéélan, du too féét, taman dnagitla Marah, du gumtatek i dagitan féét. ");
INSERT INTO bps_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Taman, nugak i dad to Mosis, na snalekla, “Na, tan sa i ninumito?” ");
INSERT INTO bps_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Di kaklinge Mosis i ugakla, too kenen fakdo mni tabeng di Dwata i Amu, na fiten di kenen i kayu lbatù. Nwè Mosis kayu én, na batan ditù di yéél, na i yéél talaan nan féét. Klola mnè déén, banlé ale Dwata i Amu dad flalò gablà di knèla, na tnilewan i ksaligla di kenen. ");
INSERT INTO bps_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Na manan di dale, “Ku tooyu agu nimen, na i nimòyu too matlu di kitegu, na làyu fbayà bay nimenyu i dad flalògu gamu, làta gamu fanlayam di balù tan i tduk i taflayamgu aye i dad to Idyif. Agu sa Dwata i Amu, i fgulê gamu.” ");
INSERT INTO bps_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kafnge én, mdà ale na là mlo kel ale di satu banwe dnagit Ilim. Na di Ilim ani, nun sfalò lwe sfuten, na fitu falò kayu dnagit falmira. Na flo ale mnè mdadong di dad sfuten. ");
INSERT INTO bps_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kafnge én, i kdee i dad bel Israél mdà ale di Ilim, na di gasfalò lime duh di galwen bulen, mdà di kdàla lamwà di Idyif, kel ale di satu banwe gulandè to dnagit Sin, i mnè di gutngà Ilim na Sinay. ");
INSERT INTO bps_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Na di kakella di banwe gulandè to, kdeela lêman mugak ku Mosis na Aron. ");
INSERT INTO bps_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Na manla, “Fye fa baling, ku fnati gami Dwata i Amu, ditù di Idyif, du déén gamkaan gami bong uten, na dademe kakaan kel di gusen i kayèmi kmaan. Kabay balingyu gami nebe dini di banwe gulandè to, du fye fnatiyu i kdeemi fagu di kalnusmi.” ");
INSERT INTO bps_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kaklinge Dwata i Amu i gman i dad bel Israél, manan di ku Mosis, “Fulengu di gamu sbung knaan mdà di langit. Na klit i du santifun i dad to i knaan blégu, gablà alò knaanla di du én. Ani i kfagugu tmilew dale, du neyegu ku dnohòla i gmangu dale. ");
INSERT INTO bps_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Na di gnaman du, nwèla i gablà knaanla di lwe du, na i kwèla ani, falala fnatlagad du busekla.” Én gman Dwata. ");
INSERT INTO bps_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Taman, tulen Mosis na Aron i kdee dad bel Israél i gman Dwata, manla, “Di kifu ani tooyu gadè Dwata i Amu, kenen sa i falwà gamu mdà di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Hae, du di flafus kadang, teenyu i bong kneng Dwata i Amu. Talingen i ugakyu gablà di kenen. Hae, mugak gamu gablà di kenen, ise gami nugakyu, du gami alò mimen i dekan gami.” ");
INSERT INTO bps_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Lêman talù Mosis, manan, “Dwata i Amu, mlé gamu kadang uten di kifu, na di flafus banlén gamu sbung knaan too gablà di klidùyu. Hae, du talingen i ugakyu kenen. Hae, mugak gamu gablà di kenen, ise gami nugakyu.” ");
INSERT INTO bps_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Na kafnge én, man Mosis di ku Aron, “Manam di kdee dad to, fdadong ale dini, na tadag ale di muna i Dwata i Amu, du talingen i ugakla.” ");
INSERT INTO bps_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Sleng Aron stulen di kdee dad bel Israél, meye ale ditù gsen di banwe gulandè to, na teenla i bong kneng Dwata i Amu, msut di labun. ");
INSERT INTO bps_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Na man Dwata i Amu di ku Mosis, ");
INSERT INTO bps_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Talingegu dad ugak i dad bel Israél. Manam dale di kagun kifu mablé ale utenla, na di flafus mablé ale sbung knaan, du fye too ale bsol. Na kafnge én gadèla agu Dwata i Amu, i Dwata fnangamfùla.” ");
INSERT INTO bps_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Na di kagun kifu, too dee dad anuk di bnas msut di dad bel Israél, na maglimun i klamang tanà i guftudla. Na di flafus nun too mangfel alù di klamang tanà. ");
INSERT INTO bps_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Di kakafag i alù nun teenla di tanà, di banwe gulandè to, i dad too mngifi bukay, salngad kngifi i alù. ");
INSERT INTO bps_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Na di kite i dad bel Israél i dad too mngifi bukay ani, làla gadè ku tan ani. Taman, sasalek ale, manla, “Tan ani dé?” Na tmimel Mosis dale, manan, “Ani i sbung knaan blé Dwata i Amu di gamu.” ");
INSERT INTO bps_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Lêman talù Mosis, manan, “Ani i dek Dwata i Amu gito, gablà di knaan ani, na ani dunan, ‘Di kukuyu knaan ani ntukyu i kalbong knaan kat man satu gamu di sdu, na nukuyu alò salfang di kdeeyu di satu lawig, mdadong nam sufa kat to di sdu.’ ” ");
INSERT INTO bps_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Na di kaklinge i dad bel Israél i gman Mosis, mimen ale. Na nun mwè bong, na dademe tukay alò nwèla. ");
INSERT INTO bps_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Di takabtasla dun, i dad to muku bong landè lukasla, na i dad to muku tukay, là ale knulang. Kat satu dale gamwè i too gablà di klidùla. ");
INSERT INTO bps_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kafnge én, man Mosis di dale, “Nang gamu musek, balù tukay, kel flafus di tmadol du.” ");
INSERT INTO bps_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kabay i dademe là ale flinge ku Mosis, du nun busekla, du knaanla di flafus. Kabay di flafus baling snafat na balok. Na ani i guflabè Mosis dale. ");
INSERT INTO bps_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Na kat flafus nuku i dad to i knaan ani, i gablà di klidùla, na di kinit i du, mtunal sa i gdè di tanà. ");
INSERT INTO bps_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Di gnaman du, muku ale knaanla gablà dale di lwe du. Na én nukula di kat sat to mdadong sfalò lwe sufa. Na i dad tua di dad to salu di ku Mosis du tnulenla gablà di mgimòla ani. ");
INSERT INTO bps_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Na man Mosis di dad tua ani, “Ani i flalò Dwata i Amu gito. Fayah i du kaftud, i du Dwata i Amu. Taman, tnagayu i gamu kayè knaan di du ani, na busekyu i gdè knaan kel fayah.” ");
INSERT INTO bps_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Taman, nimenla i dek Mosis dale, na i gdè knaanla, busekla kel i tmadol du, na laan balok na laan snafat. ");
INSERT INTO bps_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Lêman talù Mosis, manan, “Knaanyu i knaan gdè malfabi di du ani. Du i du ani, i Du Kaftud, i du Dwata i Amu, na landè teenyu knaan di tanà di du ani. ");
INSERT INTO bps_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Du nam du gal gamu gamguku knaan, bay di gfitun du, i Du Kaftud, landè teenyu kakaanyu di tanà.” ");
INSERT INTO bps_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Balù én gman Mosis di dad to, di gfitun du, nun di dale mngabal i kakaanla, bay landè teenla. ");
INSERT INTO bps_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kafnge én, man Dwata i Amu di ku Mosis, “Kilen kè dé katlag i dad to là mimen dad flalògu dale? ");
INSERT INTO bps_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Fandamyu moon, agu sa i Dwata i Amu, i mlé di gamu i Du Kaftud, na ani i duengu mlé gamu kakaanyu di gnaman du, gablà knaanyu di lwe du. Na di gfitun du kayègu ku tatì gamu fanak na mnè, na nang gamu lamwà di lawigyu.” Én gman Dwata. ");
INSERT INTO bps_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Taman, di gfitun du, là mimò i dad to, du ftud ale. ");
INSERT INTO bps_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Na i sbung knaan blé Dwata dnagit dad bel Israél mana. I baweh i knaan ani, gambet i tukay bukay bnê na i neman gambet tnab. ");
INSERT INTO bps_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Na man Mosis di dad to, “Ani mdek Dwata gito. Busek ito tukay mana, mdadong nam sufa, di dad belito kadang, du fye teenla i baweh knaanito i blé Dwata gito kloito mnè di banwe gulandè to, di bang kafalwaan gito di banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Taman, man Mosis di ku Aron, “Mwè ge i tibud, na nlamam mana, nam sufa i kalbongan, na fkaham di muna i gumangamfuito Dwata i Amu, du fye busekito di dad belito.” ");
INSERT INTO bps_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Na mimen Aron i dek Dwata i Amu di ku Mosis, na kafnge én fkahan i mana di muna i bong kaban maglafin blawen, i gumkah i lwe batu gugsulat i sfalò flalò i Dwata, du busek. ");
INSERT INTO bps_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Kmaan i dad bel Israél mana klo fat falò fali, kel di kakella di banwe Kanaan, i too gumnèla. ");
INSERT INTO bps_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Na i kdee dad bel Israél mdà ale di banwe gulandè to dnagit Sin, na galla nili i gumnèla ku lê ale dek Dwata i Amu. Na satu duh, kel ale di banwe Rifidim, na mnè ale déén, bay di banwe ani, landè yéél ninum i dad to. ");
INSERT INTO bps_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Taman nugakla ku Mosis, na manla, “Banlém gami yéél.” Tmimel Mosis, manan, “Kan kè ku sanbulawyu agu? Kan kè ku tnilewyu Dwata i Amu? Neyeyu kè ku fantahaan nawan di gamu?” ");
INSERT INTO bps_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Du too malau i dad to, taman too ale mugak ku Mosis, manla, “Kan ku nebem gami lamwà di banwe Idyif? Nebem gami dini kè, du fye tatì mati gami, na dad ngàmi, na dad lmanafmi di kalaumi.” ");
INSERT INTO bps_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Na kaklinge Mosis i gman i dad to, too kenen dmasal di Dwata i Amu, manan, “E, Amugu Dwata, tan i kibògu i dad to ani? Fanla agu fnati, fagu di ktudàla deg batu.” ");
INSERT INTO bps_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Na tmimel Dwata i Amu, ku Mosis, manan, “Mdà ge na faginam i dademem dad tua i dad bel Israél, na magu gamu muna di dad to, na nebem i tugadam i bunalam di yéél Nilu, ");
INSERT INTO bps_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","du kadang, di kakelyu di bong batu di bulul Sinay, déén agu di munam. Di kakelyu ditù, bnunalam i batu i tugadam, na tambul i yéél mdà di batu, na yéél ani i guminum kadang i dad to.” Taman, nimò Mosis ani di mata i dad tua i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Na di sablà i gufimò Dwata ku Mosis ani, dnagitla Masah na Mériba, du i dad bel Israél nugakla Mosis, na du tnilewla Dwata i Amu, di kasbulawla gablà di kenen, du man i dademe samnagin Dwata i Amu dale, na dademe manla là. ");
INSERT INTO bps_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Klo fa i dad bel Israél di banwe Rifidim, natud ale i dad to Amalék. ");
INSERT INTO bps_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Taman man Mosis ku Dyaswa, “Malék ge dademe di dad toito ani, na fayah natudyu i dad to Amalék. Na fayah tadag agu di tah i bulul, na nagotgu i tugad blé Amugu Dwata dagu.” ");
INSERT INTO bps_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Taman nimò Dyaswa i gman Mosis kenen, na sfati ale i dad to Amalék. Na Mosis, Aron, na satu to dnagit Hur, salu di tah i bulul. ");
INSERT INTO bps_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Di kayang fa Mosis i dad sigalan, fadlug matu i dad bel Israél, bay ku mlungay i dad sigalan, na laan gkayang dun, na matu i dad to Amalék. ");
INSERT INTO bps_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Taman di klungay i dad sigal Mosis, mwè Aron na Hur i batu gufsudengla kenen, na tadag ale samdan kenen, du fkayangla i dad sigalan, taman gkayangan dad sigalan kel di kasdaf i duh. ");
INSERT INTO bps_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Taman, gfisan Dyaswa i dad sundalu Amalék. ");
INSERT INTO bps_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kafnge én, man Dwata i Amu di ku Mosis, “Sulatam gablà di katuyu ani, du fye i ktabenggu gamu gafaldam i dad bel Israél. Na tnulenam Dyaswa, di satu duh falmogu i kdee dad to Amalék.” ");
INSERT INTO bps_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kaklinge Mosis i gman Dwata, fdakan i satu gudamsù di Dwata, na dnagitan i gudamsù ani, Dwata i Amu i gumdà i katumi. ");
INSERT INTO bps_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Na manan di dad dademen to, “Tayalito i dad sigalito du dmayen ito Dwata i Amu, du tnabengan ito kel di landè sen, du kenen sa fadlug matu di dad Amalék kel di atuan.” ");
INSERT INTO bps_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Di tnanin duh, di gatlu bulen mdà di kagalwà i dad bel Israél di Idyif, lêman ale mdà. Di kdàla di banwe Rifidim, fadlug ale magu. Kafnge én, kel ale di banwe gulandè to dnagit Sinay, na flo ale mnè déén smalu di bulul. ");
INSERT INTO bps_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Na kafngela nimò ani, mnagad Mosis di bulul, du stulen di Dwata. Di knagadan di bulul, tlo kenen Dwata i Amu, na manan, “Ani tulenam di dad bel Dyékob, i dnagit dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Manam di dale, manam, ‘Tateenyu i mgimògu di dad to Idyif, na lêyu teen ku tan i bong gnagangu, di kebegu gamu di deg, gambet i kebe i malbang anuk di bnas i imfisan di fafakan. ");
INSERT INTO bps_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Na ku tooyu agu nimen, na satu nawayu di kimenyu i dad flalògu gamu, mbaling gamu dad togu too mabtas. Balù mfun agu i klamang banwe, bay gamu i dad to mgalékgu, ");
INSERT INTO bps_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","i dad to alò deg mfun dun. Na mimò agu gamu dad gal bà di deg, i dad to mangamfù di dagu!’ Na Mosis, ani i tulenam di dad bel Israél.” ");
INSERT INTO bps_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Taman masol Mosis na fatlon i dad tua di dad to, na tulenan i kdee i gman Dwata i Amu, i kdee dekan kenen. ");
INSERT INTO bps_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Na kaklinge i dad to kdee gman Dwata, salngan ale tmimel, manla, “Nimòmi i kdee i gman Amuito Dwata.” Kafnge én, tulen Mosis di Dwata i Amu, i timel i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Na lêman talù Dwata i Amu di ku Mosis, manan, “Kadang salu agu di ge, fagu di too mgat labun, du fye mlinge i dad to dagu stulen di ge, du fye toola ge fnaglut na nimen i galam man dale.” Kafnge én, tulen Mosis di Dwata i Amu i gman i dad to. ");
INSERT INTO bps_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Na talù Dwata i Amu di ku Mosis, manan, “Salu ge di dad to na tulenam dale toola nlaneb i ktola di duh ani, na lê fayah, na toom ale fafuk i klawehla, du mangamfù ale di deg. ");
INSERT INTO bps_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Too ale fatlagad di lwe duh, du di gatlun duh agu, Dwata i Amu, fdanà, mdà di langit, di bulul Sinay, du fye teen agu i kdee dad to. ");
INSERT INTO bps_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Na nimoam ilè glibut di bulul, i gufanakla magu, du fye là mlafà i dad to i ilè ani. Na manam di dale nang mnagad di bulul, ku demen nang mlafà i ilè i gufanakla, du ku simto mlafà ilè ani, to én, too fnati. ");
INSERT INTO bps_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hae, ku nun mlafà ilè i gufanakla magu, tnudà kenen batu kel di kfatin, ku demen fnanà, du fnanggu ku nun magot kenen. Salngad kibòyu to, ku demen lmanaf, too ale fnati ku nlafàla ilè i gufanakla. Kabay di kfuni i few, fakay ale mnagad di bulul.” ");
INSERT INTO bps_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Di kafnge talù Dwata di ku Mosis, lêman masol Mosis du fafatlagadan i dad to mangamfù di Dwata. Ani flaloan dale, nlanebla i ktola, na nfukla i klawehla. ");
INSERT INTO bps_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kafnge én, manan di dad to, “Fatlagad gamu, du fye gatlagad gamu di satu fayah. Na nangyu sansatu i lawehyu di yaanyu mdà ani, kel di duh i kfangamfùyu Dwata.” ");
INSERT INTO bps_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Na di flafus i gatlun duh, kmilet na smilà, na too mgat labun maglimun i tah i bulul, na là mlo linge i dad to i too bong uni i féw. Taman i kdee dad to déén, kankal ale di bong klikòla. ");
INSERT INTO bps_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kafnge én, nebe Mosis i dad to ditù, du fye smitong ale Dwata, na tadag ale di gugdak i bulul. ");
INSERT INTO bps_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","I klamang bulul maglimun i buk, du fdanà Dwata i Amu di lam i lifoh. Myak i buk gambet i buk mdà di bong fnuluk, na i klamang bulul too mingok, ");
INSERT INTO bps_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","na i uni i féw too matnù. Na kafnge én, talù Mosis, na tmimel Dwata gagin i kilet. ");
INSERT INTO bps_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Na talù Dwata, na ani i manan, ");
INSERT INTO bps_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Agu sa Dwata i Amu, i Dwatayu, i mebe gamu lamwà di banwe Idyif, mdà di kaglifanyu. ");
INSERT INTO bps_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nang gamu mangamfù di ise glut dwata, du agu alò i Dwatayu. ");
INSERT INTO bps_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Nang gamu mimò i alung kafbaweh balù tan i mnè di langit, di tah tanà ani, ku demen mnè di mahin na yéél, du gumangamfùyu. ");
INSERT INTO bps_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nang gamu lkuad di munala, ku demen mangamfù di dale, du agu sa alò Dwata i Amu, i Dwatayu, na landè dademe, na agu mfun gamu. Na fanlayamgu simto mlafà dagu. Fanlayamgu simto dmuen deg kel di gfat kansad dad bella. ");
INSERT INTO bps_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kabay i to kamdo deg, na mimen i flalògu, fitegu i kakdogu di dale, kel di file libu kansad dad bella. ");
INSERT INTO bps_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nang gamu dmagit i dagitgu di landè gukmamuyu dun, du agu Dwata i Amu, i Dwatayu. Balù simto to dmagit i dagitgu na landè gukmamun dun, fanlayamgu kenen. ");
INSERT INTO bps_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Tooyu fandam i Duh Kaftud, du én i duh ungulyu deg. ");
INSERT INTO bps_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mimò gamu i nimòyu klo i nam duh, ");
INSERT INTO bps_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","kabay di gfitun duh, i Duh Kaftud, én i duh i mfun Dwata i Amu, i Dwatayu. I gfitun duh ani, balù satu di gamu nang mimò, balù i dad ngàyu, i dad lifanyu, i dad lmanafyu, na balù i dad to ise di gamu i mnè di safédyu. ");
INSERT INTO bps_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Klo nam duh agu, Dwata i Amu, mimò i langit, tanà, mahin, na kdee i fkahgu di mgimògu ani, bay kel di gfitun duh, tlag agu nan mimò, du tafnge i kdee mgimògu. Taman, du landè nimògu di gfitun duh, nimògu i duh ani too mabtas, du i duh ani kafaldamyu dagu. ");
INSERT INTO bps_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tooyu nafè i màyu na yêyu, fye mlawil gamu dini di banwe blé di gamu. ");
INSERT INTO bps_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Nang gamu manò. ");
INSERT INTO bps_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nang gamu mlafà i yaanyu. ");
INSERT INTO bps_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Nang gamu tmaku. ");
INSERT INTO bps_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Nang gamu tmulen kéng gablà di dademeyu to. ");
INSERT INTO bps_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Nang gamu mibal knun i dademeyu to, na nang gamu mibal i yaanan, i dad lifanan, i dad lmanafan, na balù tan i nfunan.” Én i dad flalò blé Dwata di dad to, fagu di ku Mosis. ");
INSERT INTO bps_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Na di kaklinge i dad to i kilet, na i uni i féw, na teenla i silà na mbuk i bulul, too ale kankal du likò, na tadag ale ditù di gumawagan. ");
INSERT INTO bps_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Na di kafdadong Mosis di dale, manla di kenen, manla, “Ku ge moon talù di gami fanlingemi ge, du likò gami ku talù Dwata di gami, ken mati gami.” ");
INSERT INTO bps_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kabay man Mosis di dad to, “Nang gamu likò. Tasalu Dwata salu dini, du fiten di gamu i bong kdatahan, du fye mdà ani, too gamu likò gamsalà di kenen.” ");
INSERT INTO bps_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kabay i dad to fanak ditù di gumawag, na alò Mosis fdadong di too kmifu, na mgat i labun di gumnè Dwata. ");
INSERT INTO bps_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Di kagdadong Mosis di Dwata, man Dwata i Amu, “Tnulenam dad bel Israél ani, ‘Tagadèyu agu sa i talù di gamu mdà di langit. ");
INSERT INTO bps_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Taman nang gamu mimò dad dwatayu mdà di salafì ku demen blawen du fnangamfùyu. Nang gamu mimò na mangamfù di balù tan, galwà di dagu.’ ” ");
INSERT INTO bps_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Na lêman talù Dwata di ku Mosis, manan, “Mnagad ge dini di deg di bulul, na faginam Aron, na lwe dad ngaan lagi dunan, Nadab, Abihu, na i dad fitu falò dad tua di dad bel Israél. Di là gamu fa kel di tah, déén gamu fa di gumawagan fnangamfùyu agu, ");
INSERT INTO bps_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","du ge alò i fakay fdadong di dagu. I dad to magin ge là fakay fdadong di dagu. Na i dademem dad bel Israél là fakay balù mnagad di bulul.” Én gman Dwata. ");
INSERT INTO bps_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Na di kakel Mosis di dad to, tnulenan ale i kdee gman Dwata i Amu, na i kdee dekan dale, na salngan ale tmimel, manla, “I kdee gman Amumi Dwata, én nimòmi.” ");
INSERT INTO bps_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Na sulat Mosis i kdee gman Dwata i Amu. Na di too flafus di gamtadol duh, nimoan i gudamsù di gugdak i bulul, na ftadagan sfalò lwe batu déén, du gufaldam i sfalò lwe malay gumbel i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Kafnge én, nun dad lamnok lagi dekan, du snakufla i dad dsù di Dwata i Amu, na lê nun dad baka dsùla, du ani ilè masasatu ale di Dwata. ");
INSERT INTO bps_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Nwè Mosis i kagatngà i litè i dad lmanaf, du fkahan di lam i tukung, na i dademe litè sabulan di gudamsù. ");
INSERT INTO bps_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kafnge én, nwean i gugsulat i dad flalò Dwata dale, na bnasan di dad to. Na di kaklingela dun, manla, “Nimenmi Amumi Dwata na nimòmi i kdee flaloan gami.” ");
INSERT INTO bps_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Na nwean i tukung nun litè na sabulan di dad to. Na manan, “Litè ani i ilè nun kasfakang mgimò Amuito Dwata di gito, di kablén di gito i kdee dad flaloan ani.” ");
INSERT INTO bps_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Na kafnge én, Mosis, Aron, Nadab, Abihu, na fitu falò dad ulu di dad bel Israél, mnagad ale di bulul, ");
INSERT INTO bps_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na teenla Dwata, i Dwata fnangamfù dad bel Israél. Di dungan i blian, gambet i dalan too mneng na mlunu, salngad i satu batu dnagit safira, na too mtiu i klunun salngad klunu i langit. ");
INSERT INTO bps_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Balù teen i dad tua di dad bel Israél, Dwata, laan ale falmo. I kdeela kmaan na minum di muna i Dwata. ");
INSERT INTO bps_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Kafnge én, talù Dwata di ku Mosis, na manan, “Mnagad ge dini di dagu, na klom dini, blégu ge i lwe bong batu kufil, i gusmulatgu i dad flalògu du tdoam di dad to.” ");
INSERT INTO bps_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Taman fatlagad Mosis na i saligan Dyaswa, na mdà ale, na mnagad Mosis di bulul Dwata. ");
INSERT INTO bps_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Di là fa mdà man Mosis di dad tua i dad bel Israél, manan, “Fatanyu gami dini kel di kasfulêmi. Gani sa Aron na Hur i dademeyu, na ku nun kasbulawyu, ale sa smafye gamu.” ");
INSERT INTO bps_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Na di knagad Mosis di bulul, too mgat i labun, na maglimun i bulul. ");
INSERT INTO bps_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Na fdanà mdà di langit, i bong kneng Dwata i Amu, satu ilè tadéén kenen di bulul. Na di kite i dad bel Israél i kneng ani salngad i lifoh too dminè di tah i bulul. Na kel di nam duh, maglimun labun i bulul. Na di gfitun duh, tamlo Dwata i Amu ku Mosis, mdà di lam i labun. ");
INSERT INTO bps_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Taman di knagad Mosis di tah i bulul, fusuk kenen di lam i labun. Na mnè kenen ditù fat falò duh na fat falò butang. ");
INSERT INTO bps_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Di kafnge Dwata i Amu tmulen i kayean tulen di ku Mosis ditù di bulul Sinay, blén di kenen i lwe kufil batu i gugsulat dad flaloan, kenen i too smulat dun. ");
INSERT INTO bps_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Di kite i dad bel Israél tatoo mlo Mosis là masol di bulul, stifun ale na salu di ku Aron, na manla di kenen, manla, “Laito gadè ku tan i mkel di ku Mosis, i to mebe gito lamwà di banwe Idyif, taman mimò ge gami i dad dwata, du fye nun mebe gito.” ");
INSERT INTO bps_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Tmimel Aron, manan, “Nwèyu i dad ulel blawen di dad yaanyu na di dad ngàyu, na nebeyu dini di deg.” ");
INSERT INTO bps_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Taman nwè i kdee dad to i ulella, na nebela di ku Aron. ");
INSERT INTO bps_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nwean i dad ulel di dale, na tnunalan na kokan di gumimò dun, na fagu ani mgimoan i alung tingà baka. Kafnge én, man i dad to, manla, “Gito dad bel Israél, ani i dwataito, ani i gamgebe gito lamwà di banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Na kite Aron dun ani, nimoan i gudamsù di muna i alung tingà baka blawen, na fgadean di dad to, manan, “Fayah nun fista, du mafè ito Dwata i Amu.” ");
INSERT INTO bps_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Na too flafus di tmadol duh, nun dad lmanaf dsùla na snakufla, na nun dademe dad lmanaf bléla du dsùla, du ani ilè masasatu ale di Dwata. Na kafnge ani, kmaan ale na minum, na mimò ale i knayè i lawehla. ");
INSERT INTO bps_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Na man Dwata i Amu di ku Mosis, “Faflal ge masol, du i dad to nebem lamwà di banwe Idyif, gamsalà ale na knagolla agu. ");
INSERT INTO bps_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Too ale mlal samyat mdà di dalan i gumdekgu flalògu dale, na mgimòla i alung i satu tingà baka mdà di tnunal blawen. Na i alung baka gumangamfùla na gudamsùla, na gmanla, ‘Gito dad bel Israél, ani dwataito, ani i gamgebe gito lamwà di banwe Idyif.’ ");
INSERT INTO bps_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“Na gadègu too mgal ulu i dad to ani. ");
INSERT INTO bps_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Na fbayaam agu, du falmogu ale, du too dminè i kaflabègu dale. Kafnge én, ge na dad belam toogu fbel, fye mbaling gamu mgimò i sbung dad to too mlabung.” Én gman Dwata di ku Mosis. ");
INSERT INTO bps_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Kabay too fakdo Mosis di Dwata i Amu, i Dwatan, manan, “E, Amugu Dwata, tabyà, nangam fdinè i kaflabeam di dad tom i tafalwaam mdà di Idyif, fagu di bong enegam na di bong gnaganam. ");
INSERT INTO bps_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Du ku falmom ale, tan kadang man i dad to di Idyif? Ken manla kadang, tanebem i dad bel Israél lamwà di Idyif, du kayeam sduléam ale fnati di dad bulul. Tabyà, nangam moon fnadlug i kaflabeam dale, na begam tanlas i fandamam, na nangam fnadlug falmo dale. ");
INSERT INTO bps_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Fandamam moon i fakangam di dad lifanam Abraham, Isaak, na Dyékob, i snafaam fagu di dagitam. Fakangam di dale i blém di dale too dee dad bella, i kdeela salngad kdee i dad blatik, na lê blém di dad bella i tanà i tafakangam, i fafunam dale kel di landè sen.” Én kafakdo Mosis di Dwata. ");
INSERT INTO bps_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Taman, tanlas Dwata i Amu i fandaman, na laan fnadlug falmo i dad ton. ");
INSERT INTO bps_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kafnge i kastulenla, mdà Mosis masol, na neben i lwe batu gugsulat i dad flalò Dwata, snulatan di tah i dad batu na lê di dunganan. ");
INSERT INTO bps_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Alò Dwata sa mimò i dad batu ani, na i sulat déén, kenen sa smulat dun. ");
INSERT INTO bps_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Na di kasol Mosis na Dyaswa di bulul, linge Dyaswa i ugak i dad to, na manan ku Mosis, “Lingegu i uni ditù salngad i uni nun kasfati.” ");
INSERT INTO bps_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Kabay man Mosis, “I lingegu ise uni mdà di klehew i katu di kasfati, na ise uni mdà di klidù i kagfisan di kasfati, bay uni i lingegu, i uni di klingag.” ");
INSERT INTO bps_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Na di kagdadong Mosis di dad to, teenan i alung tingà baka mgimòla, na dad to sayew, na too sasè i kaflabean. Na taman déén di gugdak i bulul, tudaan di tanà i lwe batu kufil gusmulat Dwata i dad flaloan, na bgang ale. ");
INSERT INTO bps_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Na kafnge én, nwean i alung tingà baka i nimòla, na batan di lifoh, na ftunalan. Na ku tno nlunan, na bolan di yéél, na finuman di dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Na smalu Mosis ku Aron, na manan, “Tan i mgimò i dad to ani di ge, du ge mebe dale di too sasè nimò ani?” ");
INSERT INTO bps_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Na tmimel Aron, manan, “Nang ge flabè deg, du gadeam too mayè dad to ani mimò sasè. ");
INSERT INTO bps_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mugak ale di deg, manla, ‘Laito gadè ku tan i mkel di ku Mosis, i to i mebe gito lamwà di banwe Idyif, taman mimò ge gami dad dwata, du fye nun mebe gami.’ ");
INSERT INTO bps_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Taman fnigu di dale ku nebela di deg i dad kasla blawen, na i dad nun kas blawen nwèla na bléla di deg, na batgu di lifoh, na tay, tamsut sa i tingà baka!” ");
INSERT INTO bps_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Teen Mosis i là gagan Aron fnang i dad bel Israél, na i kdee nimòla falohan, na mbaling ale i dad to nulé i dad dademela sduen. ");
INSERT INTO bps_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Taman tadag Mosis di gufusuk di gumnè i kdeela na falbongan i taluan, manan, “I dad to msen di Dwata i Amu, salu gamu dini di deg.” Na salu di kenen i kdee dad to bel Libay. ");
INSERT INTO bps_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kafnge én, manan di dad bel Libay, “Ani i dek Dwata i Amu, i Dwata fnangamfù dad bel Israél, kat satu gamu dad lagi, tmakas i faisyu, na nlibutyu lamngab di dademeyu dad bel Israél, na fnatiyu balù i dademe i dad flanekyu lagi, i dademeyu sgalak, na dademe i dad demeyu saldan.” ");
INSERT INTO bps_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Nimen i dad to Libay i dek Mosis dale. Na di duh én mdadong tlu libu dad lagi i mati. ");
INSERT INTO bps_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Na kafnge én, man Mosis di dale, “Tmani gamu di dademe dad to, du di duh ani, tambaling gamu dad lifan Dwata i Amu, du tanimenyu i dek Dwata gamu, fagu di kfatiyu i dademeyu to i bel Israél, balù i gambet i dad ngàyu lagi, na gambet i dad flanekyu lagi. Taman di duh ani Dwata mlé gamu kafye.” ");
INSERT INTO bps_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Na di tmadol duh, man Mosis di dad to, “Gamgimò gamu i too blat salà. Kabay lêman agu mnagad di bulul, ditù di Dwata i Amu, du kengu gagan stulen di kenen, na nlifetan moon i salà mgimòyu di kenen.” ");
INSERT INTO bps_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Taman lêman samfulê Mosis mnagad ditù di Dwata, na manan, “E, Amugu Dwata, tay, too blat i salà tamgimò i dad to ani. Mimò ale i dwatala blawen du fnangamfùla. ");
INSERT INTO bps_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Kabay begam nlifet i salàla ani, bay ku laam nlifet i salàla, gnibum i dagitgu mdà di libru i gusmulatam i dagit i dad tom.” ");
INSERT INTO bps_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Kabay tmimel Dwata i Amu, manan, “I dagit i to gamsalà di deg i gnibugu. ");
INSERT INTO bps_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Mosis, mdà ge na nebem i dad to ani ditù di banwe gmangu di ge. Na nangam glifet, i kasaligangu i malak gamu di kaguyu. Kabay di kakel i banggu mlayam dale, toogu ale fanlayam mdà di kagsalàla di deg.” ");
INSERT INTO bps_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kafnge én, fanlayam Dwata i Amu i dad bel Israél, du feben i satu tduk di dad to, du fnangamfùla i alung tingà baka, i nlegesla fimò ku Aron. ");
INSERT INTO bps_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Lêman talù Dwata i Amu di ku Mosis, manan, “Tnagakam i banwe ani, ge na i dad to tanebem lamwà di Idyif, na salu gamu ditù di banwe i tafakanggu ku Abraham, Isaak, na Dyékob. Hae, du fakanggu dale i tanà én, du blégu di dad bella. ");
INSERT INTO bps_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Fasnagingu i satu kasaligangu malak gamu. Na falwàgu kadang di banwe blégu di gamu i dad to mnè déén, dunan i dad to Kanaan, i dad to Amori, i dad to Hiti, i dad to Férisi, i dad to Hibiti, na i dad to Dyébusi. ");
INSERT INTO bps_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Salu gamu di banwe ditù, i tanà too mabù, taman too nun kakaan. Kabay là agu magin gamu di kaguyu, ken falmogu gamu, du too mgal i uluyu.” ");
INSERT INTO bps_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Na di kaklinge i dad to i gman Dwata, too ale mlidù, na fitela i klidùla, du landè di dale lamsak i dad kasla. ");
INSERT INTO bps_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Hae, ani nimòla du tagman Dwata ku Mosis, manan, “Tnulenam i dad bel Israél ani, là agu magin dale, du ku magin agu, balù là mlo alò, ken sdulêgu ale falmo, du too mgal i ulula. Taman toola nwè i dad kasla di lawehla, na kafngen, neyegu ku tan i kibògu mukum dale.” ");
INSERT INTO bps_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Taman di kdàla di bulul Sinay, talà lamsak i kas i dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Na satu duh, man Mosis di Dwata i Amu, “Too glut dekam agu mebe i dad to ani salu di banwe i blém dale, bay laam fa tulen deg ku simto i fasnaginam dagu. Én senam alò gman, tagadeam agu, taman tanalékam agu na kanlehewam agu. ");
INSERT INTO bps_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kabay tabyà, ku lehew ge dagu, tdoam deg i kdee knayeam, du fye gadègu i knayeam ani, fye fadlug agu flehew ge. Na nangam glifet i dad to ani, ale i dad tom tamgalékam.” ");
INSERT INTO bps_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Na tmimel Dwata i Amu, na manan, “Agu sa samnagin gamu, kel di banwe gumdekgu gamu, na fagotgu gamu i banwe i tafakanggu gamu.” ");
INSERT INTO bps_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Na man Mosis di kenen, “Ku là ge magin gami, nangam gami fdà di banwe ani. ");
INSERT INTO bps_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Hae, du ku laam gami nagin, tan i kgadè i dademe dad to i kanlehewam agu na i dad tom? Na ku samnagin ge gami, dilèmi mahal gami di kdee dademe dad to.” ");
INSERT INTO bps_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Na man Dwata i Amu di ku Mosis, “I kdee fnim di deg ani, én i nimògu, du kanlehewta ge, na tanalékta ge.” ");
INSERT INTO bps_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na too fakdo Mosis di Dwata, manan, “Amugu Dwata, tabyà di ge, fitem di deg i bong knengam, i ilè tadini ge.” ");
INSERT INTO bps_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Tmimel Dwata i Amu, manan, “Hae, fitegu ge i kafyegu, bay alò fliusgu di munam, na lê di munam fgadègu ge ku simto agu. Du agu Dwata i Amu, na kandogu na mlé agu kafye di balù simto i nalékgu. ");
INSERT INTO bps_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kabay là fakay ku teenam i bawehgu, du balù simto to mite i bawehgu mati sa. ");
INSERT INTO bps_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Neyem, tadag ge di bong batu ani, mdadong di deg. ");
INSERT INTO bps_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Na di klius i bong knenggu, fkahta ge di gubsék i batu, na snafangta ge i kmalgu kel di kliusgu ge. ");
INSERT INTO bps_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kafnge én, nwègu kmalgu na teenam i kagolgu, bay là fakay ku teenam i bawehgu.” ");
INSERT INTO bps_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Na man Dwata di ku Mosis, “Knufilam lwe batu gablà gusmulat i dad flalògu, salngad i dad muna batu tabangangam, du déén lêmangu gusmulat i dad talùgu. ");
INSERT INTO bps_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Fatlagad ge, du fayah flafus mnagad ge di bulul Sinay, du snitem agu ditù di tah. ");
INSERT INTO bps_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Là fakay ku nun magin ge mnagad, na landè to fakay salu balù nè di bulul, na balù dad lmanaf, landè fakay mteb di gugdak i bulul.” ");
INSERT INTO bps_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Taman kmufil Mosis lwe batu, salngad i dad muna batu blé Dwata kenen. Na too flafus di tmadol duh, mnagad kenen di bulul Sinay, na neben i lwe batu ani, du ani sa i dek Dwata kenen. ");
INSERT INTO bps_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Na mdà di langit, fdanà Dwata i Amu maglimun i labun, na tadag di saféd Mosis, na fgadean kenen, kenen Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mlius kenen di muna Mosis, na di kliusan kenen, manan, “Agu Dwata i Amu, i Dwata too nun kakdo, na mlé kafye, na là lumak flabè, na too fnò i kakdo landè kgilin, na too gsalig. ");
INSERT INTO bps_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Na fitegu i kakdogu i là mgili, fagu di klifetgu i dad sasè nimò, i klafà i knayègu, na i dad salà i file libu dad to. Kabay i dad to mimò salà, làgu fbayà, bay toogu fanlayam, na i kaflayamgu dale ani, kel di dad fùla, na kel fa di dad ngà i fùla.” Én gman Dwata. ");
INSERT INTO bps_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Kaklinge Mosis i gman Dwata, gasil lkuad na fnangamfuan kenen, ");
INSERT INTO bps_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","na manan, “Amugu Dwata, ku too glut kanlehewam agu, fakdogu di ge, samnagin ge gami. Balù i dad to ani too mgal i ulula, bay begam nlifet i dad sasè nimòmi, na i dad salàmi, na dnawatam gami na fbalingam gami dad tom.” ");
INSERT INTO bps_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Tmimel Dwata i Amu, manan, “Hae, na makang agu di ge na di dad bel Israél. Nimògu gamu i bong dee tnikeng, i dad tnikeng là lmen mgimò di tah tanà ani, na kadang teen i kdee dad bel Israél ku tan i kalbong i gnagangu, agu Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Na nimenyu i kdee flalò blégu gamu kadang di duh ani, na toogu falwà i dad dademe bung dad to di banwe gusaluyu, dunan i dad to Amori, i dad to Kanaan, i dad to Hiti, i dad to Férisi, i dad to Hibiti, na i dad to Dyébusi. ");
INSERT INTO bps_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Na nang gamu mimò balù tan kasfakangyu i dad to di banwe gusaluyu, du ku én nimòyu tlaab gamu, du là mlo balingyu lalò i sasè nimòla. ");
INSERT INTO bps_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kabay di kakelyu, balingyu lanbà i dad gudamsùla, falmoyu i dad batu gumangamfùla, na fnugenyu i dad lahan i tamgimòla i dwatala dnagit ku Asira. ");
INSERT INTO bps_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Nang gamu mangamfù di balù tan galwà di deg, du agu alò Dwata i Amu, na agu alò mfun gamu, taman fanlayamgu simto mlafà dagu. ");
INSERT INTO bps_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Na nang gamu mimò balù tan kasfakang i dad to di banwe gusaluyu, du ku én nimòyu, di bang fnangamfùla i dad ise glut dwatala, na damsù ale di dwatala én, nlakla gamu magin dale, na ken gamu mtabug kmaan i dad knaan i tagabléla di dad ise glut dwatala. ");
INSERT INTO bps_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Na kafnge én, ken dnawatyu i dad ngàla libun, i dad mangamfù i dad ise glut dwata, du nimòyu yaan i dad ngàyu lagi. Na ku én, là mlo i dad ngàyu lagi mlafà dagu, du gagin ale di kfangamfù i dad yaanla i dad ise glut dwatala. ");
INSERT INTO bps_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Nang gamu mimò i alung i kafbaweh balù tan du gumangamfùyu” Én i gman Dwata di ku Mosis. ");
INSERT INTO bps_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Na di kafnge ktulen Dwata i Amu i kdee kayean tulen, manan fa di ku Mosis, “Sulatam i dad gmangu di ge, du ani gine i fakanggu di ge na di dad bel Israél. Na ku nimenyu i dad gmangu, toogu dnohò i fakanggu ge, na i dad bel Israél.” ");
INSERT INTO bps_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Na déén Mosis di saféd i Dwata i Amu klo fat falò duh na fat falò butang, na klon ditù là kmaan na là minum. Na di bang én, sulatan di dad lwe batu, i dad man Dwata gablà di fakangan, dunan i sfalò flalò. ");
INSERT INTO bps_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Na di kasol Mosis mdà di bulul Sinay, mebe kenen i lwe batu gugsulat i sfalò flalò, na laan gadè too mneng kadì i bawehan, du mdà di kastulenan di Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Na di kite Aron na i kdee dad bel Israél i baweh Mosis, na teenla too mneng, too ale likò fdadong di kenen. ");
INSERT INTO bps_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kabay tlo ale Mosis, taman Aron na i kdee dad tua i dad to, fdadong di kenen, na stulen Mosis di dale. ");
INSERT INTO bps_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kafnge én, stifun di glibutan i kdee dad bel Israél, na fgadè Mosis di dale i kdee dad flalò fgadè Dwata i Amu di kenen, ditù di bulul Sinay. ");
INSERT INTO bps_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Di kafnge Mosis stulen di dale, snafangan i bawehan, du fye là ale fakay meye i bawehan. ");
INSERT INTO bps_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kabay di gal kfusukan di gumangamfù di Dwata i Amu, du stulen di kenen, nwean i safang bawehan kel di kalwaan lêman. Na di kalwaan tulenan di dad bel Israél i kdee flalò Dwata di dale, ");
INSERT INTO bps_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","na teenla i kneng i bawehan. Kafnge én, lêmanan snafang i bawehan, kel di bangan lêman stulen di Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Na lêman talù Dwata i Amu, di ku Mosis, na manan, ");
INSERT INTO bps_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Di tnanin duh, di tnanin bulen, fdakyu i gumangamfùyu i galyu gustifun. ");
INSERT INTO bps_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Fkaham di lam i bong kaban nlafin blawen, i gumkah i lwe batu gugsulat i sfalò flalò, na tlawéngam i satu kurtina di munan. ");
INSERT INTO bps_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Nebem di lam i lamisa na fkaham i dad kandeenan di tahan. Kafnge én, nebem di lam i gumkah dad salò na fkaham i dad saloan. ");
INSERT INTO bps_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Na fkaham i gudamsù blawen, i gumtam i fye bun, di muna i bong kaban maglafin blawen, i gumkah i lwe batu gugsulat i sfalò flalò. Na léam tlawéng i satu kurtina di gufusuk di gumangamfù. ");
INSERT INTO bps_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Na fkaham i gudamsù i gusmakuf i dad lmanaf, di muna i gufusuk. ");
INSERT INTO bps_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Fkaham i gal gumalob di gutngà i gufusuk di gumangamfù, na i gal gudamsù, na nlamam yéél. ");
INSERT INTO bps_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kafnge én, nlanebam i glibut di lwà i gumangamfù, na tlawéngam i satu kurtina di gufusuk di nasel i gumlanebam ani. ");
INSERT INTO bps_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Na nweam i fngalo, i fngalo ilè i kablé di Dwata, na snabulam i gumangamfù ani, na i kdee kandeenan di lam. Én nimoam duh ani, dunan ilè kdee ani, agu mfun, agu Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Na kafnge én, salngad nimoam di gudamsù i gusmakuf i dad lmanaf, na i kdee kandeenan, du ilè i gudamsù ani agu mfun, agu Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Na léam snabul i fngalo ani, di gumalob na i gumkah dun, du ilè agu mfun nan, agu Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Kafnge én, faginam Aron na i dad ngaan lagi di gufusuk i gumangamfù na falobam ale. ");
INSERT INTO bps_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Na di kalobla falsakam Aron too fye klawehan, i klawehan lsakan di kadsuan di deg, na nlamogam kenen fngalo, na blém kenen di dagu, du ani ilè kenen mbaling i bàgu. ");
INSERT INTO bps_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Na i dad ngaan lagi, fdadongam déén, na léam falsak dale. ");
INSERT INTO bps_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Na nlamogam ale fngalo, salngad kiboam i màla, du fye mbaling ale gal bàgu, na mimò ale di dagu. Du di klamogam dale fngalo, i kgimòla gal bà, là tlag bay kel di kdee dad bella, kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Na nimò Mosis i kdee dek Dwata i Amu kenen. ");
INSERT INTO bps_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Taman di tnanin duh di tnanin bulen di galwen fali i kagalwàla mdà di banwe Idyif, fafdak Mosis i gumangamfù di Dwata i Amu, i galla gustifun. ");
INSERT INTO bps_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Di kafngela mimò i gumangamfù di Dwata galla gustifun, maglimun labun i gumangamfù ani, na di lam too fnò i bong kneng Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Du maglimun labun i gumangamfù galla gustifun, na du ditù di lam too fnò i bong kneng Dwata i Amu, là gfusuk Mosis. ");
INSERT INTO bps_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ku magket i labun na mgili mdà di gumangamfùla, lê magu i dad bel Israél, du lalòla. ");
INSERT INTO bps_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kabay ku là magket i labun di gumangamfùla, là ale magu, silang ku magket na mgili i labun. ");
INSERT INTO bps_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Taman i labun Dwata i Amu, mlimun i gumangamfùla di mduh, na di butang dminè i labun salngad i lifoh. Na di dad kagu i dad bel Israél, fakayla teen i kasnagin Dwata i Amu dale, du teenla i labun ani di mduh, na i labun ani dminè di butang.");
INSERT INTO bps_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Di muna, di landè fa harì i dad to di banwe Israél mkel i bong kbitil. Na nun satu lagi dnagit ku Élimélék mdà di lumbuk dnagit Éfrata mnè di banwe Bétléhém glam di banwe Dyuda. Élimélék na yaanan na lwe ngàla lagi dnagit ku Malon na Kilyon mili flo di banwe Moab, du mdà di kbitil. Na klola mnè déén, ");
INSERT INTO bps_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","baling mati Élimélék, na gtagak i yaanan Naomi na i lwe ngaan lagi. ");
INSERT INTO bps_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Na kafnge én, mwè i lwe ngaan lagi yaan mdà di Moab, na dagitla Orfa na Ruth. Di fan fnge i sfalò fali knèla déén, ");
INSERT INTO bps_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","mati Malon na Kilyon, na alò satu Naomi gtagak, talandè yaanan na dad ngaan. ");
INSERT INTO bps_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Na di kaklinge Naomi nun tabeng Dwata i Amu i dad ton di Israél fagu di kablén kafye ulê di dad fulela. Taman fatlagadan i kdaan di Moab gagin i dad tewen libun du mulê di banwe Bétléhém. ");
INSERT INTO bps_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Na tagakla i gumnèla déén na salngan ale mdà, du samfulê di banwe Dyuda, bay déén di dalan, ");
INSERT INTO bps_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","man Naomi di dad tewen, manan, “Fye fa baling ku mulê gamu di dad tuayu. Na fye ku Dwata i Amu malas gamu kafye salngad i kafafyeyu deg na i dad yaanyu tamati. ");
INSERT INTO bps_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Na fye ku Dwata i Amu tamlas i yaanyu, du fye nun fye knèyu.” Na di kmanan ani, nalakan ale na tatì ale sakwak, ");
INSERT INTO bps_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","na manla di ku Naomi, manla, “Là, du kayèmi magin ge mulê di dad tom.” ");
INSERT INTO bps_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Kabay man Naomi, “Dad ngàgu, fye fa ku samfulê gamu di dademeyu. Tan i duenyu mayè magin deg, du landè sa dademe ngàgu lagi i tlasgu yaanyu. ");
INSERT INTO bps_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Dad ngàgu, mulê gamu, du too agu tua nan, na là fakay ku lêman agu mwè yaan. Na balù fa ku fakay agu mwè yaan kadang butang ani na nun dad ngàmi lagi, ");
INSERT INTO bps_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","gamfatan gamu fa kè kel di kbongla na là gamu baling mayè i dademe? Ken là gamu gamfatan. Tay, fanlayam agu Dwata i Amu, na mlidù agu du gagin gamu di kaflayamgu.” ");
INSERT INTO bps_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kaklingela i man Naomi lêman ale sakwak. Kafnge én, nalak Orfa i tewen libun na mulê, bay Ruth lkafan Naomi du too mayè magin kenen. ");
INSERT INTO bps_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Taman man Naomi di kenen, “E tingàgu, neyem i lwayam tamulê di dad ton na di dwatan, fye ku magin ge kenen.” ");
INSERT INTO bps_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Kabay baling tmimel Ruth, manan, “Nangam agu ftagak ge. Faloham agu magin, du kayègu magin ge balù tanè i gusalum, na mnè balù tanè i gumneam. I dad tom mgimò kadang i dad togu, na Dwatam mgimò kadang i Dwatagu. ");
INSERT INTO bps_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Na balù tanè gumatim, déén kayègu gumati, na déén gulambang deg. Fye ku Dwata i Amu, toon agu fanlayam ku tnagakta ge di là fa fati i samkah gite.” ");
INSERT INTO bps_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Na di kdilè Naomi too mdà di nawa Ruth magin, laan kenen nleges mulê. ");
INSERT INTO bps_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Taman fadlug i lwe ani salu di Bétléhém. Na di kakella déén, dee gusalu nawa i dad to, du tikeng ale di kagkah Naomi du landè yaanan na dad ngaan. Na sasalek i dad libun, manla, “Naomi kè ani?” ");
INSERT INTO bps_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Na man Naomi di dale, manan, “Nangyu agu dnagit ku Naomi, i to lehew, bay balingyu agu dnagit Marah, i to mlidù, du too féét i gnagugu i kfagu deg Dwata Too Mtulus. ");
INSERT INTO bps_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Du di kdàgu dini di muna fa, too nun gebegu, bay di kafasfulê Dwata i Amu deg landè gebegu. Taman nangyu agu dnagit i to lehew, du knagol agu Dwata i Amu Too Mtulus, na fanlayaman agu.” ");
INSERT INTO bps_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Na ani kagkah i kulê Naomi mdà di banwe Moab gagin i tewen Ruth fdu di Moab. Na di kasfulêla di banwe Bétléhém tabang i kaktu satu fla dnagit barli. ");
INSERT INTO bps_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Na nun gaked Naomi gsen di yaanan Élimélék, dnagit ku Boas, i to too mgafè na too nun knunan. ");
INSERT INTO bps_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Na satu duh, man Ruth di ku Naomi, manan, “Begam agu faloh salu di nligo gukamtu i dad to, ken nun kamdo deg na falohan agu muku i barli gtagak i dad to kamtu.” Na tnimel Naomi, manan, “Hae tingàgu, fakay sa.” ");
INSERT INTO bps_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Taman salu kenen di satu nligo na laloan i dad to kamtu na nukun i barli gtagakla. Na too fye, du én gumukun di nligo Boas, i gaked Élimélék. ");
INSERT INTO bps_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Na là mlo kel Boas mdà di Bétléhém, na manan di dad to kamtu, “Fye ku Dwata i Amu samnagin gamu.” Na tnimella kenen, manla, “Fye ku Dwata i Amu mlé kafye di ge.” ");
INSERT INTO bps_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Na di kite Boas ku Ruth, snalekan i ulu di dad to kamtu, manan, “Simto i lamnok libun atù?” ");
INSERT INTO bps_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Tmimel i ulu, manan, “Dunan i libun mdà di banwe Moab magin ku Naomi. ");
INSERT INTO bps_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Mbal kenen di deg ku fakay kenen mlalò i dad to kamtu na muku i dad mtatekla. Na too kenen mimò mdà di flafus kel ani. Na alò kenen ftud là mlo di lawig.” ");
INSERT INTO bps_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Na fdadong Boas di ku Ruth, na manan, “E Tuy, fanlingem agu. Nang ge muku di nligo i dademe to. Dini i gumukum di saféd i dad saliggu libun. ");
INSERT INTO bps_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Neyem ku nè gukamtu i dad saliggu na laloam ale. Tatnalùgu i dad lagi nangla ge snamuk. Na ku malinum ge, tatì ge mwè yéél di dad tibud i tasulula.” ");
INSERT INTO bps_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Na di kaklinge Ruth i gman Boas, lkuad na kudung di blian, du fdanaan i kton di kenen, na manan, “Tan kè duenam too fafye deg? Gadeam sa kè, ise agu to mdà di banwe ani.” ");
INSERT INTO bps_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Na man Boas, “Talingegu ku tan i ktabengam i tewem mdà di bang i kfati yaanam kel ani. Na mdà di kakdom kenen tagakam i dad tuam, na i banwem, na mnè ge dini di saféd i dad to i laam gadè. ");
INSERT INTO bps_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Fye ku Dwata i Amu, i Dwata i dad bel Israél i gufaklungam, malas ge i kafye nimoam na smikof di ge i untungam.” ");
INSERT INTO bps_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Na man Ruth, “Tay i kafyem deg, Amugu, du tatangalam i nawagu di too fye ktaluam di deg, balù là agu gasngad di satu fasakam.” ");
INSERT INTO bps_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kel i bang kakaan, tlo Boas kenen, manan, “Dini ge na salngan ge gami kmaan i fan na lnabam di sabew.” Na di ksudengan di saféd i dad to kamtu, blé Boas kenen i knaan. Taman kmaan kenen kel di kabsolan na nun fa gdè knaanan. ");
INSERT INTO bps_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Na di kdaan salu di gumimoan man Boas di dad saligan, “Falohyu kenen muku i dademe di gumatangyu, na ndotyu fa dademe kigan di bnatangyu du tagakyu kenen, na nangyu kenen nngak.” ");
INSERT INTO bps_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Taman muku Ruth kel kifu. Na kafnge én, nlékan i tanukun na mlukas sfalò kilu i kalbongan. ");
INSERT INTO bps_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Na neben mulê di lunsud, na fiten di tewen libun i kalbong gukun na blén di kenen i gdè knaanan bong duh. ");
INSERT INTO bps_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Na tikeng i tewen libun i kalbong mgukun. Taman snalekan, manan, “Tanè gumukum gine na simto mfun dun? Fye ku Dwata i Amu mlé kafye di to kamdo ge.” Taman tulen Ruth di tewen i nligo gumimoan nfun i to dnagit Boas. ");
INSERT INTO bps_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Na man Naomi, “Fye ku Dwata i Amu mlé di kenen i bong kafye. Là ite kadì glifet Dwata i Amu, du galan dnohò i dad fakangan di dad to mto na balù di dad tamati. I lagi én too gakedta, taman là fakay ku laan ite nifat.” ");
INSERT INTO bps_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Na man Ruth, manan, “Too fye, du tagman Boas di deg fye ku samfulê agu na fadlug muku magin i dad saligan kel di kti i kantun.” ");
INSERT INTO bps_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Na man Naomi di ku Ruth, “Too fye sa tingàgu, fye ku laloam i dad salig Boas libun, du ku mimò ge di nligo i dademe to ken nun gusaseam.” ");
INSERT INTO bps_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Taman lalò Ruth i dad salig Boas libun, na fadlug muku kel di kti kaktu i barli na trigu. Na mnè fa kenen di saféd i tewen libun. ");
INSERT INTO bps_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Na di satu duh man Naomi di tewen Ruth, manan, “Tingàgu, tabanggu fanngabal ge yaan, du fye nun mifat ge. ");
INSERT INTO bps_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Na fandamam Boas i nun dad saligan gumaginam, kenen sa i gakedta. Taman fanlingem agu, kifu ani mlék kenen i barli. ");
INSERT INTO bps_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Taman funa ge dyo, na fkaham i fangbun, na lsakam i fye klaweh. Kafnge én, salu ge ditù di gumlékan, bay nang ge fgadè ku Boas ku déén ge, silang ku tafnge kenen kmaan na minum. ");
INSERT INTO bps_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Na toom neye ku tanè i gumilean, na ku takudang nketam i dafat i blian na milè ge gsen di blian. Na kadang tulenan ge ku tan i nimoam.” ");
INSERT INTO bps_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Na tmimel Ruth, manan, “Hae, nimengu i kdee manam.” ");
INSERT INTO bps_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Taman mdà Ruth na salu di gumlèk, na nimoan i kdee i gman tewen di kenen. ");
INSERT INTO bps_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Na di kafnge Boas kmaan na minum, too lehew i nawan, na milè kenen di saféd i dad barlin na kudang. Na too fganag fdadong Ruth di gumilean na nwean i dafat i blian na milè kenen gsen di blian. ");
INSERT INTO bps_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Di tatngà butang, makto mukat Boas, na neyen di glibutan na teenan i nun libun milè di blian. ");
INSERT INTO bps_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Na snalekan, “Simto ge kè?” Tmimel Ruth, manan, “Amu, agu sa i saligam Ruth. Na du ge sa i gakedgu fakay ku nsoam agu di kbalugu, taman begam kah i kilil saulam tahà di deg du ilè nweam deg du yaanam.” ");
INSERT INTO bps_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Na man Boas di kenen, “E Tuy, fye ku Dwata i Amu mlé di ge kafye, du di muna, toom kando i tewem libun Naomi, bay i kafye nimoam ani, mdatah fa di muna nimoam. Na gablà moon ku mngabal ge i lamnok lagi, balù landè knunan, bay knagolam i ge knayè. ");
INSERT INTO bps_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Na taman nangam fsamuk i nawam, du nimògu i kdee knayeam, du gadè sa i kdee dad to di Bétléhém na ge i too fye libun. ");
INSERT INTO bps_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Glut deg sa gaked i tewem lagi i tamati, na là fakay ku làta ge nifat, bay nun fa satu to i too mdadong i kgaked i tewem dun di deg. ");
INSERT INTO bps_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Na tatì ge milè dini kel mwal, na kadang flafus santulengu di satu gaked atù ken mayè mifat ge. Na ku nwean ge yaanan too fye, bay ku là, fagu di dagit Dwata i Amu nwèta ge yaangu.” ");
INSERT INTO bps_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Taman milè Ruth di blian, bay di là fa mwal mték kenen, du là mayè Boas ku nun to gmadè déén kenen. ");
INSERT INTO bps_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Di là fa mdà man Boas di kenen, “Nebem dini satu daféngam na nbelam.” Na di kagbelan dun, kok Boas déén mlukas lwe falò lime kilu barli na nketan du fsudù kenen. Kafnge én, mulê Ruth. ");
INSERT INTO bps_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Kakel Ruth di tewen libun, snalek i tewen, manan, “Tingàgu, tan i gukel i nimoam ditù di gumlék fali?” Na santulen Ruth gablà di kdee kafye mgimò Boas di kenen. ");
INSERT INTO bps_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Na manan fa, “Man Boas di deg fye ku di kulêgu nun gebegu, taman blén deg i bong barli ani.” ");
INSERT INTO bps_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Na man Naomi, “Tatiam fantahà i nawam kel di gadeam ku tan i gukel i nagu Boas. Du laan sa ftud di duh ani silang ku gadean tan gukel i kdee ani.” ");
INSERT INTO bps_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Na salu Boas di gustifun di gufusuk i lunsud na sudeng. Na di kakel satu gaked Élimélék, i to man Boas di ku Ruth, tlon, na manan, “Dini ge leg, sudeng ge.” Taman fdadong di kenen na sudeng. ");
INSERT INTO bps_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Na fatlo Boas sfalò di dad ulu mebe i lunsudla na fsudengan ale déén. ");
INSERT INTO bps_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Kafnge én, manan di gakedan, “Na du tasamfulê Naomi mdà di Moab, kayean ku fabli i tanà nfun i gakedta Élimélék. ");
INSERT INTO bps_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Fandamgu fye gadeam ani, taman tulengu ge di muna i dad to sudeng dini, du fye ku mayè ge, na bnayadam. Kabay ku là ge mayè, gasilam tulen deg fye gadègu, du landè dademe to fakay mwè i tanaan galwà di ge funa na kafnge én deg.” Na tmimel i to én, manan, “Hae, bnayadgu.” ");
INSERT INTO bps_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Na man Boas di kenen, “Ku bnayadam i tanà Naomi, gagin Ruth i libun mdà di Moab di kbayadam dun, du fye i tanà én là gwè i dademe to, bay gfun i dad bel Élimélék, i to tamati.” ");
INSERT INTO bps_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Na di kaklinge i to én i man Boas, manan, “Ku én, blégu di ge i kaglut ge fakay mayad dun. Du ku bnayadgu, i muna dad ngàgu là gamfun i tanà én. Taman ge mayad.” ");
INSERT INTO bps_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Na di bang atù, i tagnè nimò i dad bel Israél, ku nun mwè tanà ku demen mlé i kaglutan mwè dun, i to mlé i kaglutan mwè dun, nlusan i lafin blian na blén di to mwè i tanà. Ani kibòla fgadè tafye kastulenla. ");
INSERT INTO bps_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Taman di kman i to én di ku Boas, kenen i fakay mayad tanà gakedla, nlusan i talumfaan na blén di ku Boas. ");
INSERT INTO bps_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kafnge én, man Boas di dad sfalò ulu na di kdee dad to déén, manan, “Na di duh ani, tamite kdeeyu i kbayadgu di ku Naomi i tanà nfun i dad mati dunan Élimélék na dad ngaan Kilyon na Malon. ");
INSERT INTO bps_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Na gakuf di kbayadgu i tanà én, i libun balu mdà di Moab, dunan Ruth i yaan Malon. Na kenen nimògu yaangu, du fye gfun i dad bel Élimélék, i to tamati, i tanà én kel di atuan, na i dagit Élimélék là glifet i dad belan na i dad to di banwen. Na di duh ani, gamu sa tamite i kdee ani.” ");
INSERT INTO bps_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Tmimel i dad sfalò ulu na i kdee dad to déén, manla, “Hae, gami sa tamite i kdee. Fye ku fasngad Dwata i Amu i yaanam kadang di ku Rakél na Liya, du dee dad ngàla di ku Dyékob. Fye ku ge kadang satu mdatah to di lumbukam dunan dad bel Éfrata na mdengeg di banwe Bétlehém. ");
INSERT INTO bps_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Na fye ku mdatah i dad ngà blé Dwata i Amu kadang fagu di lamnok libun ani, salngad i kdatah i dad ngà i gutambulam Féris, i tingà lagi Dyuda na Tamar.” ");
INSERT INTO bps_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kafnge én, nwè Boas Ruth na nimoan yaanan. Na banlé Dwata i Amu kafye na mbaling maltien Ruth na lagi i tingaan. ");
INSERT INTO bps_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Taman man i dad libun di banwe ani di ku Naomi, manla, “Dnayenito Dwata i Amu, du di duh ani laan ge glifet, bay tablén ge i fuam lagi, du fye nun mifat ge. Na fye ku satu duh mdengeg kenen di klamang banwe Israél. ");
INSERT INTO bps_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Flehewan ge na nifatan ge di ktuam, du kenen i tingà i tewem libun i too mbong nawa ge. Na i kakdon ge, mdatah fa di fitu tingà lagi.” Ani man i dad libun di ku Naomi. ");
INSERT INTO bps_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kafnge én, nwè Naomi i fuan lagi na nifatan. ");
INSERT INTO bps_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Na man i dad libun demen saldan, “Tanun lêman tingà Naomi lagi.” Na dnagitla kenen Obéd. Na Obéd i mà Dyési i mà Dabid i harì. ");
INSERT INTO bps_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Taman ani i gumbel Féris kel di ku Dabid dunan: Féris i mà Hésron, Hésron i mà Ram, ");
INSERT INTO bps_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ram i mà Aminadab, ");
INSERT INTO bps_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab i mà Nason, Nason i mà Salmon, ");
INSERT INTO bps_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon i mà Boas, Boas i mà Obéd, ");
INSERT INTO bps_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obéd i mà Dyési, na Dyési i mà Harì Dabid.");
INSERT INTO bps_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Too nun kafye di to là magin di flau dad to sasè, na là sgalak di dad to gamsalà, na là makuf di kadoy i dad to landè gukmamula Dwata. ");
INSERT INTO bps_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Kabay én too gaflehew kenen i flalò Amuito Dwata; saflas mduh na butang galan fandam i flaun. ");
INSERT INTO bps_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Fye kagkahan, gambet i kayu fule mdadong di kilil i yéél munge di bang kbungen na là mlanas i doonan. I to gambet én, i kdee nimoan nun gukelan. ");
INSERT INTO bps_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Kabay i dad to sasè là gambet én i kagkahla, bay gambet ale baling i afa falis i nus na lana, ");
INSERT INTO bps_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","du mdà di ksasèla, di duh kukum Dwata, landè kagalwà i dad to sasè di kukuman, na là gakuf i dad to gamsalà di kastifun i dad to matlu di kanfe Dwata. ");
INSERT INTO bps_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Gadè Amuito Dwata i gumagu i dad to matlu, na nalakan ale di dalanla, bay i dalan gumagu i dad to sasè déén di gumalmola. ");
INSERT INTO bps_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Tan duen i dad to di sahal banwe mngabal i kfagu misan Dwata? Mngabal ale kfagu, bay landè gukelan. ");
INSERT INTO bps_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Sasatu nawa i dad harìla; i dad ulula, stulen ale i kibòla misan Dwata i Amu, na misan i harì mgalék Dwata magot i kdee. ");
INSERT INTO bps_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Manla, “Fantoito dad ikat ale Dwata gito, fye landè gumagotla gito. Hae, lamwà ito di kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Kabay Amuito Dwata tì mulé ditù di gusudengan di langit, na nadoyan ale. ");
INSERT INTO bps_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Na kafnge én, nngakan ale du too malbut; na too ale likò mdà di bong kalbutan dale. ");
INSERT INTO bps_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Man Dwata, “Ditù gufnègu i harì mgalékgu di deg bulul, dunan Sion.” ");
INSERT INTO bps_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Na man i harì mgalékan, “Tulengu i gman Dwata di deg. Én i gmanan di deg, ‘Ge i tingàgu, na di duh ani tafdatahta ge du tafgadègu agu i maam.’ ");
INSERT INTO bps_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Man Dwata, ‘Mni ge di deg na bléta ge i kdee banwe; gfunam i kdee di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Falmom kadang i dad dmuen ge fagu di kgal i kagotam, gambet kalmo i kulang tanà tudaam di tanà.’ ” ");
INSERT INTO bps_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Taman too gamu fgeye, gamu dad harì di tah tanà, ken falmo gamu i harì mgalék Dwata; fafulung gamu dad ulu di dad banwe. ");
INSERT INTO bps_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Fgal gamu mimò i knayè Dwata i Amu, na kanlikòyu kenen. ");
INSERT INTO bps_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Tooyu fdanà i ktoyu di kenen du fye laan gamu kalbut, na fye laan gamu fles fnati; du ken mlal kel di gamu i kalbutan. Kabay i dad to fdadong di kenen, du kenen i guflidungla too nun kafyela. ");
INSERT INTO bps_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Ani lingag Dabid di kilan mdà di tingaan Absalom. E Amugu Dwata, file i dad mnang nawa deg! Too dee nan dad mbaling dmuen deg! ");
INSERT INTO bps_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Dee mangman gablà di deg, “Là kenen tnabeng Dwata.” ");
INSERT INTO bps_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Kabay ge, Amugu Dwata, ge i klung di glibutgu; ge i fulê i dengeggu, na ge fulê i kgal nawagu. ");
INSERT INTO bps_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Tafalbonggu i katlogu di Amugu Dwata du ftabeng agu di kenen, na fanlingen agu mdà di bulul gumnean. ");
INSERT INTO bps_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Taman fakay agu milè na kudang na là agu likò; mukat agu na landè gaslokgu, du i Amugu Dwata i munung deg. ");
INSERT INTO bps_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Na balù nun sfalò libu to dmuen deg di glibutgu, là agu likò. ");
INSERT INTO bps_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Gasil ge, Amugu! Falwaam agu Dwatagu! Du ge falmo i dad to dmuen deg gambet kasféam i kakim dad lmanaf fan makét, na gambet katfoam i kifanla fye landè mgimòla. ");
INSERT INTO bps_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","I kagalwà mdà alò di Amuito Dwata. Banlém moon kafye i dad tom. ");
INSERT INTO bps_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Ani satu lingag Dabid. E Dwata, i msen deg di katlu nimògu, tnabengam agu di katlogu ge. Ge i gal falwà deg di kaflayamgu, taman begam agu kando na fanlingem i dasalgu. ");
INSERT INTO bps_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Gamu dad to, kel di kilen dé i kafalmoyu i fye dagitgu? Fadlug gamu dé di sasè nimòyu landè gukelan, di kbelyu i kakakéng gablà di deg? ");
INSERT INTO bps_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Fandamyu ani, i to mimen knayè i Amun Dwata, mgalékan du nun gukmamun dun, taman fanlinge Dwata i katlogu kenen. ");
INSERT INTO bps_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Gablà moon ku nun klikòyu, na nang gamu fadlug mimò sasè. Too gamu fanak na fandamyu ani, balù fa déén di gumilèyu. ");
INSERT INTO bps_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Na mlé gamu di Dwata i glut dsù, i knayean di salà mgimòyu, na smalig gamu di kenen. ");
INSERT INTO bps_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Dwata, dee to gal mni di ge, manla, “Simto dé kamdo gami? Kandom gami moon, na banlém gami, Amumi Dwata, i kafye.” ");
INSERT INTO bps_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Kabay deg, tagablém deg i klehew nawa mdatah fa di klehewla di dangan i bong kaktu, di landè gukulang i knaanla na ninumla. ");
INSERT INTO bps_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Milè agu na kudang na too nun ktanak nawagu. Amugu Dwata, mdà di ge alò landè sasè mkel di deg. ");
INSERT INTO bps_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Ani satu lingag Dabid. E Amugu Dwata, fanlingem i dasalgu, na balù i mnè fa di lam nawagu, i làgu gagan mangman dun, begam fanduf. ");
INSERT INTO bps_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ge i Harìgu na Dwatagu, fanlingem i kafnigu di ge, du alò ge i gudmasalgu. ");
INSERT INTO bps_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Amugu Dwata, di flafus lingem i talùgu, di ksut i duh dmasal agu di ge na fatangu i ktimelam deg. ");
INSERT INTO bps_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Gadègu ge i Dwata landè ayè i sasè nimò, na laam faloh ku nun sasè to mnè di safédam. ");
INSERT INTO bps_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","I to fdatah i kton là gtadag di kanfem, du toom knang nawa i kdee to mimò sasè. ");
INSERT INTO bps_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","I dad to gal tmulen kéng falmom; toom knang nawa i to mayè mati to na i to mlimbung. ");
INSERT INTO bps_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Kabay agu, fakay agu fusuk di gumneam du mdà di bong kakdom landè kgilin. Déén di gumangamfù di ge, di Bong Gumneam, fdanàgu i ktogu di ge gagin i klikògu. ");
INSERT INTO bps_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Amugu Dwata, begam agu nalak di matlu nimò salngad ge, du fye là agu fisan di dad dmuen deg. Tdoam deg ku tan i dalan knayeam gumagugu. ");
INSERT INTO bps_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Én fnigu du dad to dmuen deg, landè manla gsalig, na én alò kayèla falmo. I bàla gambet sol i lbang là maglimun, fagu di kafdagla ftatekla i demela to. ");
INSERT INTO bps_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Taman nukumam ale, Dwata, fye moon ku i dad sasè nimòla mulê di dale. Knagolam ale du tadee dulê nlafàla i knayeam, na taknagolla ge. ");
INSERT INTO bps_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Kabay i dad to smalig di ge, banlém ale klehew, fye too ale gal mlingag di klehewla. Kanlungam ale, na lehew di ge i dad to ani i mbong nawa ge. ");
INSERT INTO bps_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","E Amugu Dwata, ge i mlé kafye di dad to matlu, na i kakdom smafang dale gambet i klung. ");
INSERT INTO bps_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Ani satu lingag Dabid. E Amugu Dwata, nangam agu nngak fagu di sasè kalbutam; nangam agu fanlayam di slà too minit i kaflabeam. ");
INSERT INTO bps_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Kabay, Amugu Dwata, kandom agu du too agu mlungay; tangalam agu, du landè galgu. ");
INSERT INTO bps_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Too msamuk i nawagu. E Amugu Dwata, kilen dé i ktabengam deg? ");
INSERT INTO bps_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Lê ge fdadong di deg, Amugu Dwata, na falwaam agu di fati, du i kakdom landè kgilin. ");
INSERT INTO bps_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Du ku tamati i to landè kiboan faldam ge, na landè to dmayen ge déén di lam i lbang. ");
INSERT INTO bps_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Too agu mlungay nan di kablat klidù i nawagu; klit butang tì agu msabew i lwakgu, na too fafê i gumilègu mdà di kngelgu. ");
INSERT INTO bps_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Tafan agu là mite di kngelgu gambet i to too tua, du too sè klidù i nawagu mdà di kdee mnang nawa deg. ");
INSERT INTO bps_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Fawag gamu di deg, gamu dad to mimò sasè, du fanlinge Amugu Dwata i sdanangu na tnabengan agu. ");
INSERT INTO bps_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Fanlingen i kafnigu tabeng di kenen, na tnimelan i dasalgu. ");
INSERT INTO bps_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","I kdee to dmuen deg myà kadang, na làla gadè i nawala. Là mlo ani, nkel ale i kfisan, na mila ale di kyàla. ");
INSERT INTO bps_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Ani satu lingag nlingag Dabid du mdà di gman satu bel Bénhamin dnagit Kus. E Amu, ge i Dwatagu na ge i guflidunggu; kanlungam agu di kafsasè dad damlu deg, na falwaam agu di agotla, ");
INSERT INTO bps_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","ken én kibòla deg kadang, kanfèla, na sankahla agu, gambet nimò i labè lmanaf liyun, na landè dademe tmabeng deg. ");
INSERT INTO bps_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","E Amu, E Dwatagu, ku glut tagamsalà agu, ku glut mgimògu i salà manla, ");
INSERT INTO bps_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","hae, ku glut i manla gbalasgu sasè i fye nimò i demegu to di deg, na di landè gumdaan tatìgu fatduk i to dmuen deg, ");
INSERT INTO bps_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ku glut gambet én i nimògu, fakayla agu dlu na kanfè, na fakay ku fnatila, na fbayàla agu gtidol di tanà. ");
INSERT INTO bps_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","E Amugu Dwata, neyem i kagkahgu du i dad to dmuen deg too sè kalbutla deg. Fitem dale i kalbutam, na tnabengam agu; na ge mukum deg, Dwatagu, fagu di matlu kukum i knayeam. ");
INSERT INTO bps_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Hae, santifunam i kdee to di glibutam, na sudeng ge déén di gusudeng i too mdatah ganlal ditù di tah; ");
INSERT INTO bps_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","du ge, Amugu Dwata, i mukum i kdee to. Nukumam agu fagu di katlugu, na fitem di dad dmalam deg landè kaglut di kdalamla deg. ");
INSERT INTO bps_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Tanlagam moon i sasè nimò i dad to sasè, na tnabengam i dad to matlu di fye nimòla, du ge i Dwata too matlu, na ge i meye ku fye demen sasè i mnè di fandam na nawa i dad to. ");
INSERT INTO bps_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","I kamlung deg, dunan Dwata Too Mdatah, i falwà dad to matlu di lam nawala. ");
INSERT INTO bps_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Dwata, too matlu i kukuman; na klit i duh kalbutan dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Du ku là msal i to di salaan gambet néhê Dwata i faisan du fanlayam kenen, na bantulan i boholan, na fatlagadan i tunulan. ");
INSERT INTO bps_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","I dad tekan gamfati tasanan fatlagad, na tanlun di lifoh dad gsà i tunulan. ");
INSERT INTO bps_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","I to sasè salngad i to maltien: i bnê di lam tienan i sasè fandam, na fadlug lamnok i sasè én, di ksutan, klimbung na kakakéng. ");
INSERT INTO bps_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Na i to sasè lê gambet i to makol i too mngalam sol guftatekan i demen to, bay kenen baling i mtatek di sol nakolan. ");
INSERT INTO bps_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Hae, kenen kto gumulê i kafsasean i demen to, na baling kenen i tamduk mdà di klabean. ");
INSERT INTO bps_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Mlé agu fye di Amugu Dwata mdà di bong katlun, na mlingag agu dmayen i Amugu Too Mdatah. ");
INSERT INTO bps_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Ani satu lingag Dabid. E Amumi Dwata, ge gumdatahmi, too mdengeg i kdatah dagitam di klamang banwe; magdayen i kdataham kel ditù di tah langit. ");
INSERT INTO bps_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Tdoam dad ngà, na balù dad too malnak ngà, dmayen i kdataham; taman landè kibò dad to dmuen ge gafdadong di ge; fafanakam dad to dmuen ge na i dad to mnang nawa ge. ");
INSERT INTO bps_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Di galgu keye di langit, i tanimoam fagu di bong kfulungam, i bulen na blatik tafkaham di gugkahla, ");
INSERT INTO bps_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","gamsalek agu i ktogu ku tan i duenam gal faldam i dad to, na tan i duenam mifat dale, du alò to sa. ");
INSERT INTO bps_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Kabay tafdataham i dad to fan salngad di kdatah dad kasaliganam di langit, na tagablém di dale i bong kdatah na afè salngad i harì. ");
INSERT INTO bps_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Tafagotam dale kdee mgimoam, na i kdee slamem gsalig di dale: ");
INSERT INTO bps_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","kdee lmanaf di gumnè, na dad lmanaf di bnas, ");
INSERT INTO bps_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","na dad anuk di bnas, dad nalaf, na kdee mnè di lam i mahin. ");
INSERT INTO bps_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","E Amumi Dwata, ge gumdatahmi, too mdengeg i kdatah i dagitam di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Ani satu lingag Dabid Amugu Dwata, too mdà di nawagu mlé fye di ge; na santulengu di dad to i kdee gamtikeng tanimoam. ");
INSERT INTO bps_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Too mlaan i nawagu na lehew agu ge; mlingag agu dmayen ge, Dwata Too Mdatah. ");
INSERT INTO bps_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Dad dmuen deg, gal ale mila di kitela ge msen di deg, na fugen ale na fles mati di kanfem; ");
INSERT INTO bps_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","hae, du tansenam i nimògu du matlu di kitem; na tasudeng ge di gusudengam mukum na matlu i kukumam. ");
INSERT INTO bps_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Tanukumam i dad to là faglut di ge; na tafalmom i dad to mimò sasè; balù i dagitla taflanam di fandam dad to kel di landè sen; ");
INSERT INTO bps_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","i dad to dmuen deg di muna, talandè nan, na balù i dad malbang syudadla tafalmom; talandè nan gufaldam dale kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Kabay i Amugu Dwata, landè gusen i kagotan; tasudeng kenen di gusudengan mukum. ");
INSERT INTO bps_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Na du too matlu i kukuman, nukuman i kdee to di landè nsenan na fagu alò di kaglut. ");
INSERT INTO bps_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","I Amugu Dwata i gumila dad to mabkut, na di bang i samuk, kenen guflidungla. ");
INSERT INTO bps_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Amugu Dwata, i dad to dmilè ge, smalig ale di ge, du laam sa fbayà i dad to fdadong di ge. ");
INSERT INTO bps_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Mlingag ito dmayen i Amuito Dwata, i mnè di banwen Sion; na tnulenito i dad to di klamang banwe gablà di dad mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Fanlayam Dwata i dad to manò, na fandaman i dad to fanlayamla, na laan fbayà i katlola kenen. ");
INSERT INTO bps_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Taman begam agu kando, Amugu Dwata, na fandamam i kagkahgu, du fanlayam agu i dad to mnang nawa deg. Ge i falwà deg di fati, ");
INSERT INTO bps_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","taman falwaam agu du fye gtulengu di kdee tom ditù di syudadam Sion, i kdee kafyem di deg; na too agu lehew di kafalwaam deg. ");
INSERT INTO bps_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","I dad to là faglut di Dwata, salngad ale di dad to mtatek di mngalam sol nakolla du guftatekla i dad demela to; gambet mawel ale bay baling dale magfawel, du dale gumulê i kafsasèla i dad demela to. ");
INSERT INTO bps_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Gadeito i katlu Dwata fagu di kukuman dad to, bay gakfè i dad to sasè fagu di dale sasè nimò. ");
INSERT INTO bps_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Na én gukella di gumlayam dale, na balù fa i dad to là mayè faldam Dwata. ");
INSERT INTO bps_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Kabay dad to nun klidùla là mnè di klidùla kel di atuan; na i fanden i dad to landè, là tì lana kel di landè sen du gafaldam ale Dwata. ");
INSERT INTO bps_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","E Amugu Dwata, nangam faloh ku nun tmilew misan ge! Ftadagam i dad to là faglut di ge di munam, na nukumam ale. ");
INSERT INTO bps_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Amugu Dwata, banlém ale bong klikòla di ge, du fye dilèla ale sa alò to. ");
INSERT INTO bps_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","E Amugu Dwata, kan ku fawag ge di deg? Kan ku tatiam agu fbayà di kaflayamgu? ");
INSERT INTO bps_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Mdà di bong kafdatahla, too labè i dad to sasè mlayam i dad to landè; fye moon ku mfawel ale fagu di kibòla mawel i dademe to. ");
INSERT INTO bps_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Hae, du i dad to mimò sasè dagla i dad sasè knayè mnè di lam nawala, na i dad to lom i knun, mnang nawa na knagolla Dwata. ");
INSERT INTO bps_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","I to sasè, mdà di kafdatahan, laan fduf Dwata, na di fandaman landè Dwata gutmimelan. ");
INSERT INTO bps_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Too nun galan lubay di dad nimoan, na i kukum Dwata kenen kadang, mawag di fandaman; na i dee to dmuen kenen laan tatì kah di nawan. ");
INSERT INTO bps_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Na én mnè di nawan ku too fye i knean landè gusenan, na là nan gmaslok i kalima. ");
INSERT INTO bps_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Na én gal lamwà di baan dad kaflagi, kakakéng, na kbantak; mlaan i baan talù sasè na i too gafatduk nawa i dademe to. ");
INSERT INTO bps_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Na salbuni kenen mdadong di dad malnak banwe du gutmagaan dad to, na fnatin i dad to landè salà ditù di gulandè to mite dun; mdà di gusalbunin neyen ku nun mdanà to gaganan kanfè. ");
INSERT INTO bps_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Fatan kenen di gusalbunin, salngad di malbang lmanaf liyun fatan di ilib galan gusalbuni, du neyen ku nun to landè kwè du kanfean; na di kagakfean dyolan ditù di lam i galan gusalbuni. ");
INSERT INTO bps_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Na tatì fisan i mdanà to di bong gal i to kamfè kenen, na tatì gsudeng na fles fugen mdà di kafatdukan kenen. ");
INSERT INTO bps_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Én fandam i sasè to ani ku tatì fbayà Dwata; man nawan ku fnidang Dwata i matan di dad sasè mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","E Amu, E Dwata, tabyà fanlayamam i dad to sasè; nangam fbayà i dad to fansasè i dad demela to. ");
INSERT INTO bps_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Kan ku knagol i dad to sasè Dwata? Na kan ku manla di ktola laam fbayad dale i salàla? ");
INSERT INTO bps_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Mite ge sa, Dwata. Teenam sa i klidù na kaflayam dad to mdanà, na fanlayamam i dad mlayam dale. Ge i gusmalig i dad mdanà to, hae, du too ge mayè tmabeng i dad to landè kibòla tmabeng i ktola. ");
INSERT INTO bps_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Nweam i gal i dad to sasè di dad nimòla sasè, na fbayadam dale i kalbong kdee mgimòla, fye landè gtagak i là gbayadla. ");
INSERT INTO bps_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","I Amugu Dwata i harì, na landè gusen i kagotan; na i dad to dmuen kenen flanan kadang di banwe fakangan di dad ton. ");
INSERT INTO bps_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Amugu Dwata, gadeam sa i dasal mnè di nawa i dad mdanà to, na ge i tamgal nawala, na flinge i kafnila di ge. ");
INSERT INTO bps_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Hae, ge mlé kagalwà di dad to ilu na dad dademe to bankut, du fye landè to di tah tanà i fakay lêman mkut dale. ");
INSERT INTO bps_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Ani satu lingag Dabid. Amugu Dwata alò i guflidunggu ku kel i samuk, na kan ku manyu di deg, “Mila ge gambet i anuk mayeng ditù di dad bulul, ");
INSERT INTO bps_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","du tabantul i dad to sasè i boholla, na taskétla i dad tunulla, du fye tagàla i dad to fye di gukmifun.” ");
INSERT INTO bps_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Tan i fye nimò i to matlu ku kel i samuk na malbà i knè dad to? ");
INSERT INTO bps_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Knean ditù Amugu Dwata di kenen gumnè di langit; sudeng kenen di gusudeng i magot kdee; na toon neye dad to di tah tanà, na teenan i kdee nimòla. ");
INSERT INTO bps_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Tnandak i Amugu Dwata dad to matlu na i dad to sasè, bay dad to sasè na dad to too mayè smamuk i dademela to knangan ale nawa. ");
INSERT INTO bps_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Too blat kadang kaflayaman i dad to sasè, du gambet gnumah ale bong ulen bala lifoh na sandawà dminè, na maflayam ale di lyof init mdà di lifoh; ");
INSERT INTO bps_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","du i Amugu Dwata too matlu na én kayean i matlu nimò, taman dad to matlu mite kenen kadang. ");
INSERT INTO bps_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Ani satu lingag Dabid. Tmabeng ge, Amugu Dwata, du landè nan dad fye to gtagak, na talandè to gsalig di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","I kdeela stulen kakakéng, na safgaw ale fagu di dad kdayenla i dademela. ");
INSERT INTO bps_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Amugu Dwata, fafanakam moon i dad to gal mgaw fagu di kdayenla i dademela to, na snafangam dad bà i dad to fdatah, ");
INSERT INTO bps_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","i gal man, “Fagu di kfulungmi talù gwèmi balù tan i knayèmi; gami mfun i bàmi na simto gmagan fafanak gami di ktalùmi?” ");
INSERT INTO bps_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Na man i Amuito Dwata, manan, “I dad to landè too bankut na fanlayam i dademela to, taman là fakay ku làgu blé di dale i tabeng kayèla na là fakay ku làgu ale falwà di agot i dad to mlayam dale.” ");
INSERT INTO bps_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Na too glut gsalig dad fakang Dwata, gambet ale i too glut salafì maglaneb fagu di lifoh fitu dulê. ");
INSERT INTO bps_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Amugu Dwata, begam gami nifat, na kanlungam gami di dad to sasè di bang ani na kel di landè sen, ");
INSERT INTO bps_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","du too gami sanlibut i dad to sasè, na én toola dnayen na fdatah i dad sasè nimò. ");
INSERT INTO bps_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Ani satu lingag Dabid. Amugu Dwata, tan i klom fa mlifet deg? Kel kè di landè sen? Kel di kilen kafbayaam deg? ");
INSERT INTO bps_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Tan i klogu fa tmayud di klidù i nawagu? Mlidù nawagu tayud duh di kafsasè i dad to dmuen deg. ");
INSERT INTO bps_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Amugu Dwata, neyem i kagkahgu na tnabengam agu; fuléam di deg i kgalgu du fye là agu fles mati; ");
INSERT INTO bps_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","du ku fles agu mati ken manla, “Tagfisanmi kenen,” na lehew i dad mlayam deg di kagfisangu. ");
INSERT INTO bps_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Kabay smalig agu di kakdom i landè kgilin, na too agu lehew du falwaam agu kadang. ");
INSERT INTO bps_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Amugu Dwata, mlingag agu di ge du mdà di bong kafyem di deg. ");
INSERT INTO bps_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Ani satu lingag Dabid. I to ku manan di kton, “Landè Dwata,” too là fulung faldam, kdee fandam i to gambet én slame bigkò, na too sasè na magagyà i dad nimoan, na landè di dad to gambet én mimò fye! ");
INSERT INTO bps_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Meye i Amuito Dwata mdà di langit di kdee to, du neyen ku nun to fulung faldam, na ku nun to mayè gmadè kenen. ");
INSERT INTO bps_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Kabay teenan i kdee to tatlas ale di glut dalan; kdeela kulang i nimòla; landè di dale mimò fye, balù satu, landè. ");
INSERT INTO bps_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Na smalek i Amuito Dwata, manan, “Landè kè kaglabat i kdee to gal mimò sasè ani? Knalamla falmo dad togu na landè fandamla dmasal di deg.” ");
INSERT INTO bps_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Kabay nun duh nkel ale i bong klikòla, du Dwata sa i samnagin dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Kayèla snamuk i fan nimò dad mdanà to, bay Dwata sa guflidung i dad mdanà to. ");
INSERT INTO bps_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Too fye ku kel nan moon mdà di banwe Sion i kafalwà Dwata i dad ton, dunan i bel Israél. Too lehew kadang i bel Dyékob én, di kfulê i Amuito Dwata di dale i fye knèla. Too fye nan nawa i bel Israél. ");
INSERT INTO bps_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Ani satu lingag Dabid. E Amugu Dwata, simto gablà mnè di Bong Gumneam? Simto gablà mnè di bulul gumneam? ");
INSERT INTO bps_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Dunan i to too sikof kimenan i knayeam, na matlu i nimoan di kitem; too gsalig i galan man, du i kaglut too mnè di nawan. ");
INSERT INTO bps_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Na laan falmo i dademen to fagu di gmanan; laan fansasè i dademen to sgalak, na laan samtugad salék gablà di dademen. ");
INSERT INTO bps_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Toon knang i sasè to kmagol Dwata, bay toon nafè i to nun klikò di Amuito Dwata. Toon dnohò i dad tafakangan balù tan i kalima di kdohoan dun. ");
INSERT INTO bps_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Fdem kenen na laan fngà i fdeman. Na déén di gusfala laan banlé salà i to landè salà, balù nun to mayè tmaden kenen. Na nè i to mimò kdee ani, kenen i mnè di ifat Dwata kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Ani satu lingag Dabid. Dwata, kanlungam agu du ge i guflidunggu. ");
INSERT INTO bps_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Mangu di Amugu Dwata, “Ge i gumdatahgu; landè fye gfungu ku ise mdà di ge.” ");
INSERT INTO bps_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","I dad to Dwata mnè di tah tanà ani, too ale fye; na too nun klehewgu samnagin dale. ");
INSERT INTO bps_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","I dad to ftabeng di dad ise glut dwata, matnù baling i kaflayamla. Là agu makuf di dad kadsùla, na balù dagit i dad dwatala làgu tlo du ftabeng agu. ");
INSERT INTO bps_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Amugu Dwata, alò ge i amu tanalékgu, na ge i gumdà kdee kanlidùgu; i ktogu déén di falelam. ");
INSERT INTO bps_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","I alel gablém deg too fye di deg. Tay, kafye i gdawatgu mdà di ge. ");
INSERT INTO bps_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Dnayengu i Amugu Dwata du kenen i mngewe deg; na ku butang balù di lam i nawagu nun tamdò deg. ");
INSERT INTO bps_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Làgu tlag fdatah i Amugu Dwata di fandamgu, na du déén kenen di safédgu là agu galwà di ifatan. ");
INSERT INTO bps_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Taman too mlaan i nawagu, Amu, na too agu lehew; na balù i lawehgu saliggu di ifatam, ");
INSERT INTO bps_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","du balù mnè agu di agot i fati laam agu bayà; laam tnagak i to toom kando di lbang. ");
INSERT INTO bps_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ge i tamdò deg i dalan mfun falami nawa; i kafdadongam, én gumdà ksikof i klehewgu, na i dad tabengam gumdà i kafye landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Ani satu lingag Dabid. I langit là tlag fite i kdatah Dwata; toon fgamal fite i kafye mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Klit duh fiten, na klit butang fgadean i kdatahan. ");
INSERT INTO bps_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Là gtalù dad blatik ku demen i bulen, na taman landè manla, ");
INSERT INTO bps_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","bay knean fgadèla kdatah Dwata di klamang banwe, na i dad to di kdee banwe fakay gamlabat i fgadèla. Déén di langit nun gufnè Dwata i duh, ");
INSERT INTO bps_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","na klit flafus msut i duh gambet i lagi sandeme too fye baweh msut mdà di gumnean. Na gambet too nun ayè i duh magu salngad i ayè i mgal lagi gal makuf di skuya mila. ");
INSERT INTO bps_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Mdà magu i duh di gumsutan na là fanak kel di gusdafan; na landè di tah tanà ani i là gnumah i initan. ");
INSERT INTO bps_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","I dad flalò i Amuito Dwata too sikof, na too gatgal nawa i dad to. I gman Amuito Dwata too gsalig, na gamlé kfulung faldam balù di dad to landè gnadè. ");
INSERT INTO bps_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","I dad tdò i Amuito Dwata too matlu, na kdee mimen dun too nun klehewla. I dad dekan di dad to too mbangal, na lamwa fandam i dad to mimen dun. ");
INSERT INTO bps_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","I klikoito di Amuito Dwata too fye, na là tlag kel di landè sen. I kukuman too glut, na too gablà kafsalaan i dad to nukuman. ");
INSERT INTO bps_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","I gmanan too mabtas fa di blawen, balù tan fa i too kabtasan. I tnaluan too fye di nawagu, fye fa di nem i tnab tamdak mdà di banwe i sugen. ");
INSERT INTO bps_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Amugu Dwata, matdò i saligam fagu di dad tnaluam, na nun bong untung i dad to mimen dun. ");
INSERT INTO bps_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Kabay landè to fakay gmadè i kdee gugsalaan, taman falwaam agu di dad salà mgimògu i làgu gadè. ");
INSERT INTO bps_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Na fawagam i saligam di dad nimò tagadègu sasè, fye là agu mgebe i salà; du fye landè gukulanggu di kitem, na fye landè salàgu du landè nimògu sasè. ");
INSERT INTO bps_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Amugu Dwata, kayègu ku kdee talùgu na kdee fandamgu slame fye di ge, du ge gambet i batu guflidunggu, na ge i msò deg di salàgu. ");
INSERT INTO bps_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Ani satu lingag Dabid. E Dwatagu, Dwatagu, tan duenam tmagak deg? Too agu ftabeng ge moon bay laam linge i dalonggu, na laam agu tnabeng. ");
INSERT INTO bps_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","E Dwatagu, di mduh fakdo agu di ge fye tnabengam agu, bay laam agu tnabeng, di butang fakdo agu na landè kaftudgu. ");
INSERT INTO bps_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Kabay knean too ge mtiu, landè salaam. Déén ge di gumneam too mdatah, na ge i dnayen i dad tom, i bel Israél. ");
INSERT INTO bps_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Ge i gusmalig dad gutambulmi; smalig ale di ge na falwaam ale di kaflayamla. ");
INSERT INTO bps_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Tamlo ale di ge na galwà ale; smalig ale di ge na landè gugdanà nawala. ");
INSERT INTO bps_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Kabay agu, salngad agu i safat, ise to, du landè mafè deg, na knang agu nawa i kdee to. ");
INSERT INTO bps_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","I kdee to mite deg, toola agu nulé, na lamaméd ale du slame dalanla madoy deg. ");
INSERT INTO bps_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Manla, “A, én kun gusmalig to ani di Amun Dwata. Fadé neyeito ku tnabeng kenen i Amun! I Amun nan falwà kenen, ku glut toon kenen kando.” ");
INSERT INTO bps_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Kabay ge, Dwata, i fsut deg mdà di tien yêgu, na ge i mifat deg di ktutùgu fa di yêgu. ");
INSERT INTO bps_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Alò ge i gusmaliggu mdà di ksutgu kel ani, na landè dademe dwatagu, alò ge. ");
INSERT INTO bps_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Nang ge moon fawag di deg, du too mdadong i kaflayam di deg, na landè dademe fakay tmabeng. ");
INSERT INTO bps_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Too dee to mnang nawa samlibut deg, du fanla agu falmo. Salngad ale i dad labè lagi baka mdà di banwe Basan mayè falmo i dad to. ");
INSERT INTO bps_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Na salngad ale i dad malbang labè lmanaf liyun mngat i dad bàla du kagula makét na samkah deg, na gambet too ale mngal fite i klabèla. ");
INSERT INTO bps_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Taman too tì landè gal i lawehgu di klikògu, salngad di yéél mkok di tanà, tì landè sa. Lyalogu i dad tulangu mti mkah di gusagotla, na lêman i kafalyalogu i ktogu sadi mtunal di klikògu gambet i talu mtunal. ");
INSERT INTO bps_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Na i bkakonggu too kafag salngad di kfung, na damkat dilàgu di laflalgu. Ani i kagkahgu du gambet tatnagakam agu di kfung, di agot i fati. ");
INSERT INTO bps_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","I kibòla deg salngad i dad labè ayem samtlaban falmo deg, du nun dee to mimò sasè samlibut deg; na tatanbakla i dad kmalgu na dad blìgu. ");
INSERT INTO bps_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Too gfan kdee tulangu, na tatì meye dad to dmuen deg na too ale lehew di kaflayamgu. ");
INSERT INTO bps_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Sansalella i klawehgu; na fagu di kasbunut neyela ku simto gamfun dun. ");
INSERT INTO bps_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Kabay ge, Amugu Dwata, nang ge fawag di deg, du alò ge gumgal i nawagu. Gasil ge tmabeng deg! ");
INSERT INTO bps_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Falwaam agu di fati; falwaam i ktogu di agot dad to gambet i labè ayem mayè falmo deg, ");
INSERT INTO bps_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","falwaam agu mdà di dad to gambet i labè liyun na i dad mlayal lagi baka; falwaam agu du landè kibògu falwà i ktogu. ");
INSERT INTO bps_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Na tulengu kadang di dad togu i kafye mgimoam, na dnayenta ge déén di kastifun i kdee tom. ");
INSERT INTO bps_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Mangu di dale, “Kdeeyu nun klikò di Amuito Dwata, dnayenyu kenen. Fdatahyu kenen, gamu bel Dyékob; nafèyu kenen, gamu bel Israél. ");
INSERT INTO bps_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Hae, du laan tì tnagak i to maflayam, na laan fbayà di kaflayaman. Laan kenen knagol, bay galan kenen fanlinge ku tamlo du ftabeng di kenen.” ");
INSERT INTO bps_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Dwata, du too mdatah i mgimoam, toogu ge dnayen kadang di bong kastifun i kdee tom. Di kanfe i dademegu to i nun klikò di ge blégu di ge i dsù tafakanggu. ");
INSERT INTO bps_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Na di duh én, i dad to landè, gamkaan ale gusen i nawala; na i dad to fdadong di Amuito Dwata, dnayenla kenen. Kayègu ku banlé gamu Dwata fye knè na klehew i kdeeyu dad to landè na dad to maflayam, ");
INSERT INTO bps_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Na di duh én, gafaldam kdee to di klamang banwe i Amuito Dwata, na samfulê ale di kenen; i kdee to lkuad ale du mangamfù di kenen, ");
INSERT INTO bps_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","du i Amuito Dwata, kenen i too nun glal mebe i dad to, na kenen i mebe i kdee sahal bung dad to di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Balù dad to too mdatah di tah tanà ani fdanàla i ktola di kenen di duh én, na kel di kdee to i mto alò flo di tah tanà ani, fdanàla i ktola di kenen. ");
INSERT INTO bps_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Na i belito fa mamu ale kadang di Dwata; i dad tuala samtugad i tulen di dad ngàla i kafye mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Balù fa dad to là fa sut gutmulen kadang gablà di mgimò Dwata di kafalwaan i dad ton. ");
INSERT INTO bps_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ani satu lingag Dabid. I Amugu Dwata i mifat deg salngad satu to gal mifat bilibili, na landè gukulanggu. ");
INSERT INTO bps_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Salngad satu to mifat bilibili mebe dale di too fye gumtebla na faftudan ale déén, na neben ale di tukay yéél too mtiu guminumla, salngad én kifat Dwata deg. ");
INSERT INTO bps_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Kenen i tamgal deg di klungaygu, na galan agu nalak di matlu dalan du fye mgafè i dagitan. ");
INSERT INTO bps_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Na balù magu agu di too gukmifun gambet i fati là agu likò, du ge, Dwata, i samnagin deg, na ge i kamlung na malak deg, taman matgal i nawagu. ");
INSERT INTO bps_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","I dad dmuen deg mite i kdawatam deg du ludukam di munagu bong knaan; i kdawatam gambet i to too mgafè. Landè gukulanggu na lambés i basugu di afeam deg. ");
INSERT INTO bps_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Amugu Dwata, gadègu là tlag i kafyem na i kakdom deg di klogu mto, na mnè agu kadang di safédam kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Ani satu lingag Dabid. I Amuito Dwata mfun i klamang banwe na i kdee mnè déén; i tanà ani na i kdee mto di tah tanà slame nfun Dwata. ");
INSERT INTO bps_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Kenen i fdak i tanà déén di gumngalam yéél; na toon fangagid i gufdakan dun déén di mahin. ");
INSERT INTO bps_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Tay, kdatah Dwata, simto gablà mnagad di bulul Amuito Dwata na fusuk di kenen gumnè? Simto gablà tadag di kanfen? ");
INSERT INTO bps_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Én alò gablà tadag di kanfen i to landè using di tnaloan mdà di salà na matlu i fandaman, i to là magin di dad ise glut fnaglut, na i to ku silangan man, “Too tì glut i mangu ani,” ku too glut i manan. ");
INSERT INTO bps_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","I to gambet ani banlé i Amuito Dwata kafye, na dnagitan kenen matlu to, du Dwata i mlé kenen kagalwà. ");
INSERT INTO bps_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Ani gine i kagkah i dad to gablà fdadong di Dwata, i Dwata gusmalig i gutambulito Dyékob. ");
INSERT INTO bps_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Lanwayu i gufusuk i Mdatah Harì! Na tooyu lanwa dad labi takab i Bong Gumnè Dwata! Fafusukyu i too Mdatah Harì! ");
INSERT INTO bps_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Simto i too Mdatah Harì ani? Dunan Amuito Dwata, i nun gal matu di kasfati, na i là gfisan. ");
INSERT INTO bps_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Lanwayu i gufusuk i Mdatah Harì! Na tooyu lanwa dad labi takab i Bong Gumnè Dwata! Fafusukyu i too Mdatah Harì! ");
INSERT INTO bps_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Simto i too Mdatah Harì ani? Dunan Amuito Dwata, gumdatah i kdee di tah langit na tanà. Kenen sa i too Mdatah Harì! ");
INSERT INTO bps_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Ani satu lingag Dabid. Amugu Dwata i gumdà nawagu, na kenen i falwà deg mdà di kdee sasè, taman là agu likò. I Amugu Dwata i too kamlung deg, taman simto dé kanlikògu? Landè! ");
INSERT INTO bps_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Du di kafngayu i dad to mimò sasè du fanla agu fnati, baling ale gsindul; na fugen i dad mnang nawa na dmuen deg. ");
INSERT INTO bps_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Taman balù fa maglibut agu i bong dee sundalu, knean là agu likò; balù ditù agu di gutngà i kasfati too agu smalig di Dwata. ");
INSERT INTO bps_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Satu fnigu di Amugu Dwata i toogu knayè, dunan toogu kayè mnè di Gumnè Dwata di klogu mto; na di klogu mnè ditù kayègu ku toogu fandam i bong kafye Amugu Dwata, na fnigu moon ku nalakan agu. ");
INSERT INTO bps_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Du ku nkel agu i samuk, kenen i kamlung deg, too fye kbunin deg di lam i Bong Gumnean; gambet fnean agu di bong mdatah batu du fye landè gamgagot di deg. ");
INSERT INTO bps_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Fdatahan agu na là gnumah agu i dad to dmuen samlibut di deg, én duengu too mkit di klehewgu; na blégu i dsùgu di Amugu Dwata di Bong Gumnean, na mlingag agu dmayen kenen. ");
INSERT INTO bps_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Amugu Dwata, fanlingem agu di katlogu ge du mni agu tabeng; kandom agu na tnabengam. ");
INSERT INTO bps_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Tagmanam, “Too ge fdadong di deg.” Na mdà di nawagu tmimel agu ge, mangu, “Hae, Amugu Dwata, too agu fdadong di ge.” ");
INSERT INTO bps_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Nang ge fawag di deg, na nangam fanlabè na fbayà i saligam ani. Ge i gal tmabeng deg di kdee gnagugu, taman nangam agu knagol na nangam agu tnagak, du alò ge i falwà deg, Dwata! ");
INSERT INTO bps_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Du balù fa tatnagak agu i màgu na yêgu, Amugu Dwata i dmawat na mifat deg. ");
INSERT INTO bps_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","E Amugu Dwata, tdoam deg i dalanam du gumagugu, na nalakam agu di glut dalan, du too dee to dmuen deg meye dalan falmo deg. ");
INSERT INTO bps_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Nangam agu blé di falel i dad to dmuen deg, du nun dad dmalam deg, blaam kakakéng i manla du kayèla ku toola agu fanlayam. ");
INSERT INTO bps_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Kabay toogu fa fnaglut falwà agu i Amugu Dwata, du fye teengu i bong kafyen di deg dini di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Smalig gamu di Amuito Dwata na fatanyu i kafalwaan gamu; fangalyu nawayu na faglut gamu di kenen; hae, smalig gamu di Dwata na fatanyu i kafalwaan gamu. ");
INSERT INTO bps_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Ani satu lingag Dabid. Too nun kafye i to ku tamaglifet i dad salaan; too nun klehewan di ksafang Dwata i dad salaan én. ");
INSERT INTO bps_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Too nun kafye i to là nukum Dwata mdà di salaan, i to là muni ku nun salaan. ");
INSERT INTO bps_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Di làgu fa tulen i dad salàgu too msamuk i nawagu, na baling mten i lawehgu; tì agu dmalong landè gumanakan; ");
INSERT INTO bps_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","hae, Amugu Dwata, du mduh na butang snamukam agu mdà di blat nebegu ani, taman mti i galgu gambet di too kinit i duh. ");
INSERT INTO bps_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Kafnge én, dnawatgu i dad salàgu; talàgu nan buni i dad gugasyatgu di knayeam. Gmangu, “Tulengu i salàgu di Amugu Dwata.” Na mdà én tanlifetam i kdee sasè mgimògu. ");
INSERT INTO bps_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Na én duenan fye ku kdee tom dmasal di ge di là fa kel i samuk, du fye balù fan nkel ale i bong kaflayam gambet i bong dunuk laan gafles di dale. ");
INSERT INTO bps_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","E Dwata, ge i gusalbunigu; ge i smafang deg di dad sasè, taman too agu mlingag i kafalwaam deg mdà di salà. ");
INSERT INTO bps_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Na man Dwata, “Tdòta ge i dalan fye gumagum; fanngeweta ge na toota ge neye fye là ge gasyat. ");
INSERT INTO bps_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Nang ge gambet i kudà demen baka i landè kaglabat, du silang ale mimen ku knakang ale na nikat.” ");
INSERT INTO bps_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Én fatan i dad to gal mimò sasè i dee kaflayamla, bay i bong kakdo Dwata landè kgilin kamlung i dad to smalig di kenen. ");
INSERT INTO bps_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Taman gamu dad to matlu, too gamu flehew mdà di kdee mgimò Dwata di gamu; na mkit gamu di bong klehewyu gamu dad mimen kenen. ");
INSERT INTO bps_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Flehew gamu di kafye Amuito Dwata, kdeeyu dad to matlu! Én gablà nimò dad to mimen Dwata, dunan dmayen kenen. ");
INSERT INTO bps_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Dnayenyu Amuito Dwata fagu di too fye kakbityu i dad agafyu gambet i arfa na i dad dademe nun tafas. ");
INSERT INTO bps_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Lingagyu i falami lingag dmayen Dwata; na tooyu fanse i kagafyu faginyu di klingag dmayen di kenen; na mkit gamu di klehew, ");
INSERT INTO bps_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","du i kdee man Amuito Dwata too glut, na i kdee nimoan too gsalig. ");
INSERT INTO bps_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Too mabtas di Amuito Dwata i matlu nimò na matlu kukum. I bong kakdon landè kgilin gafat di kdee to di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Fagu alò di tnaluan mgimò Amuito Dwata i langit, duh, na bulen, na i kdee blatik. ");
INSERT INTO bps_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Tasansatun i dad yéél du nimoan mahin, na én gusamtifunan dun di gumngalaman. ");
INSERT INTO bps_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Kdeeito dad to di tah tanà, fdanà ito moon di Amuito Dwata, na kanlikoito i bong glalan, ");
INSERT INTO bps_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","du fagu alò di tnaluan mgimoan i banwe; alò fagu di kdekan tanun kdee mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","I Amuito Dwata gmagan falmo i fan nimò dad to là faglut di kenen; snamukan i knayèla nimò na landè gukel i nimòla. ");
INSERT INTO bps_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Kabay i kenen fan nimò dnohoan, na là matlas i fandaman kel di landè sen; na là mili i knayean di dad to kel di landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Nun kafye i banwe gumnè i dad to fdatahla i Amuito Dwata di nawala, i dad mgalékan du nfunan. ");
INSERT INTO bps_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Meye Amuito Dwata mdà di langit na teenan kdee dad to. ");
INSERT INTO bps_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Mdà di gusudengan gumagot i kdee, neyen i kdee to mnè di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Glabatan i kdee mnè di lam i fandamla du kenen i mimò dale, na gadean i kdee mgimòla. ");
INSERT INTO bps_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ise fagu di dee sundalun i là fisan satu harì, bay fagu di knayè Dwata. Ise fagu di bong gal satu sundalu galwà kenen di agot i dademen sfati. ");
INSERT INTO bps_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","I dad malbang kudà snakay di kasfati là gablà snalig du fye là fisan ito di kasfati, du balù i bong gal i kudà là gafalwà gito. ");
INSERT INTO bps_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","I Amuito Dwata i too meye na mifat dad to nun klikò di kenen, i dad to smalig di kakdon landè kgilin, ");
INSERT INTO bps_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","du fye falwaan ale di fati, balù ku nun kel bong kbitil. ");
INSERT INTO bps_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Alò Amuito Dwata i gusmaligito; kenen i tmabeng na kamlung gito. ");
INSERT INTO bps_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Du Dwata too mtiu, kenen i gusmaligito, na kenen gumdà i klehewito. ");
INSERT INTO bps_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Amumi Dwata, mulà moon ku i kakdom gami landè kgilin, du alò ge sa i gusmaligmi. ");
INSERT INTO bps_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Ani lingag Dabid di kaflingun book du fye galwà kenen di agot Abimélék, na glut falwaan kenen. Toogu là tlag mlé fye di Amugu Dwata, na là agu fanak dmayen kenen. ");
INSERT INTO bps_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Làgu fdag i ktogu, bay én fdaggu i Amugu Dwata. Too gamu flinge kdeeyu dad to fanlayam, na too gamu flehew. ");
INSERT INTO bps_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Magin gamu deg di kafdatahgu i Amuito Dwata; sasatu ito dmayen i dagitan. ");
INSERT INTO bps_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Dmasal agu di Amugu Dwata na tnimelan i dasalgu, na nwean kdee klikògu. ");
INSERT INTO bps_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Dad to ftabeng di Dwata too mlaan i bawehla, na landè gumadlàla. ");
INSERT INTO bps_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Landè dademe gamtabeng deg, taman tamlo agu di Amugu Dwata na tnabengan agu, na falwaan agu di kdee kaflayamgu. ");
INSERT INTO bps_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","I kasaligan Amugu Dwata munung i dad to nun klikò di Dwata, du fye falwaan ale di dad gamsasè dale. ");
INSERT INTO bps_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Taman tilewyu du fye teenyu sa i kafye Amuito Dwata! Too nun klehew i to glidung di Dwata. ");
INSERT INTO bps_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Kanlikòyu i Amuito Dwata, kdeeyu dad ton, du i dad to nun klikò di kenen tnabengan na landè gukulangla. ");
INSERT INTO bps_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Du balù i dad malbang liyun là fa tua, kulang ale di kakaanla na bitil, bay i dad to fdadong di Dwata du gusmaligla landè gukulangla di dad gufyela. ");
INSERT INTO bps_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Taman fdadong gamu dini na flinge gamu dad ngàgu; na tdòta gamu smalig na likò di Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Mayè gamu dé ku nun fye knèyu na ku mlawil gamu? Mayè gamu dé ku nun klehewyu? ");
INSERT INTO bps_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ani kibòyu, too fgeye du fye là gamu talù sasè; na nang gamu tmulen kéng. ");
INSERT INTO bps_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Tnagakyu dad sasè nimòyu na nimòyu i fye; na tooyu lalò i dalan kasaglabat na i ksasatu nawa. ");
INSERT INTO bps_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","I Amuito Dwata, toon neye i dad to matlu, na lingen i katlola kenen. ");
INSERT INTO bps_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Kabay i dad to mimò sasè toon knang, talaan ale fnalê, na di kfatila flifetan i dad to, du fye landè to di tah tanà faldam dale. ");
INSERT INTO bps_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Kabay linge i Amuito Dwata katlo i dad to matlu ftabeng di kenen, na falwaan ale di kdee kaflayamla. ");
INSERT INTO bps_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Tnabengan i dad to malbà i nawala, na i dad to too mlidù mdà di salàla falwaan. ");
INSERT INTO bps_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Dee kaflayam gnagu i to matlu, bay i Amuito Dwata tmabeng kenen di kdee. ");
INSERT INTO bps_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Balù dad tulanan fangeyen du fye landè tfò. ");
INSERT INTO bps_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","I nimò i dad to sasè, én i gamfati dale; na nukum kadang di salà i dad to mnang nawa i dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","I Amuito Dwata i msò dad saligan di agot i fati, na laan nukum di salà i dad to smalig di kenen. ");
INSERT INTO bps_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Ani satu lingag Dabid. Nangyu fsamuk i nawayu gablà di dad to sasè, na nang mingà nawayu i dee gwè i dad to mimò sasè; ");
INSERT INTO bps_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","hae, du mlal ale lana di mata salngad i bnas mlal kafag; na mlal mati salngad di dad fule mlanas. ");
INSERT INTO bps_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Kabay én nimòyu, too gamu smalig di Amuito Dwata na mimò fye, du fye nun fye knèyu na landè sasè kel di gamu. ");
INSERT INTO bps_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Én nimòyu klehewyu Amuito Dwata, na blén di gamu dad knayè i nawayu. ");
INSERT INTO bps_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Fagotyu i ktoyu na kdee nimòyu di Amuito Dwata; smalig gamu di kenen na tnabengan gamu. ");
INSERT INTO bps_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Na ku én nimòyu, fite Dwata i katluyu di kdee to; na i kfiten i klandè salàyu salngad i kfiten kneng i duh di kaltu i duh. ");
INSERT INTO bps_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Fanak gamu na fantahàyu i nawayu fatan i ktabeng Amuito Dwata gamu; na nangyu fsamuk i nawayu gablà di bong gwè i dad to sasè, na gablà di to too fulung dmohò i sasè fandaman. ");
INSERT INTO bps_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Nang gamu flabè, tagakyu i kalbut nawayu! Na nangyu fsamuk i nawayu du én i gamgebe gamu di sasè. ");
INSERT INTO bps_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Ani gmangu du nun duh kadang maklang i nimò dad to sasè, bay i dad to smalig di Amuito Dwata gfunla i banwe fakangan dale. ");
INSERT INTO bps_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Di là mlo ani, i dad to sasè, là ale teen dini di tah tanà ani; balù ku tooyu ale fanngabal, làyu teen. ");
INSERT INTO bps_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Kabay dad to nun kafdanà nawala i baling mfun kadang i banwe, na too nun klehewla na ktanak nawala di fye knèla ditù. ");
INSERT INTO bps_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","I dad to sasè galla fandam ku tan i kibòla mlayam i dad to matlu; nkabla i beengla mdà di knang nawala dale. ");
INSERT INTO bps_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Kabay nulé ale Dwata, du gadean sa na là mlo malmo ale. ");
INSERT INTO bps_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Nsò i dad to sasè i dad faisla, na bantulla i boholla du fye fnatila i dad to landè na i dad to matlu; ");
INSERT INTO bps_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","bay di ksòla i faisla tabaling dale i mati du dale sa baling i gugtibe i faisla, na i bohol i tabantulla baling tfò. ");
INSERT INTO bps_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","I tukay nfun i to matlu too mabtas fa di bong knun i dee to sasè, ");
INSERT INTO bps_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","du i gal i dad to mimò sasè nwè Dwata, bay tangalan i dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Klit i duh gadè i Amuito Dwata kagkah i dad to matlu, na nfunla i banwe fakangan di dale kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Na di bang i klandè, là ale madlà di ksaligla di Dwata, du balù kel i bong kbitil nun lukas i knaanla. ");
INSERT INTO bps_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Kabay dad to sasè mati ale; i dad dmuen Amuito Dwata mlal mati salngad i dad bulek di bnas, na mlal ale lana gambet i buk. ");
INSERT INTO bps_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","I dad to sasè gal mdem bay là gmagan tamlas i ndemla, bay i to fye too mayè mlé. ");
INSERT INTO bps_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Du dad to gumlé Dwata i kafye, dale gamfun i banwe fakang Dwata dale; bay i dad to knangan nawa, falwaan ale di banwe én. ");
INSERT INTO bps_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","I Amuito Dwata malak i satu to di kagun na di nimoan, na i dad to gaflehew kenen fgalan i klafàla di kdee nimòla; ");
INSERT INTO bps_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","du balù gsindul kenen laan tì gafles fugen, du i magot kenen i Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Ani tatua agu nan, bay mdà fa di tingà agu kel ani, landè fa teengu i to matlu ku tatì fbayà Dwata, na landè fa teengu ku i dad ngaan gal mni kakaanla mdà di klandèla. ");
INSERT INTO bps_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","I satu to matlu too mayè mlé na fdem di dademen to; na i dad ngaan mablé kafye. ");
INSERT INTO bps_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Taman knagolyu i sasè nimò na baling gamu mimò fye, du fye mnè gamu di banwe fakang Dwata kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Hae, du én alò kayè Amuito Dwata i katlu, na laan sa fbayà i dad to faglut di kenen kel di landè gusenan; bay i bel dad to mimò sasè falmon ale. ");
INSERT INTO bps_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Gfun i dad to matlu i banwe fakang Dwata dale, na én i gumnèla kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","I to matlu too nun gukmamu i galan man, na ku mukum kenen too glut i kukuman; ");
INSERT INTO bps_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","du i flalò Dwata déén di lam i nawan, na laan nlafà. ");
INSERT INTO bps_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","I to sasè toon neye i to matlu, du mngabal kfagun mati kenen. ");
INSERT INTO bps_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Kabay là fbayà Amuito Dwata i to fye di falel i dad to dmuen kenen; balù nebela kenen di kasfala là faloh Dwata ku nukumla kenen di salà. ");
INSERT INTO bps_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Smalig gamu di Amuito Dwata di kfatanyu kenen, na nimenyu i dad flaloan; na toon gamu fdatah fagu di kablén gamu i banwe fakangan di gamu, na teenyu kadang i kalmo dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Talmengu mite satu sasè to too fdatahan i kton; salngad kenen di satu mdatah kayu sidar di banwe Lébanon. ");
INSERT INTO bps_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Kabay di là mlo mlius agu lêman di gumnean na talaan déén, balù tan i kibògu mngabal kenen làgu nan teen. ");
INSERT INTO bps_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Tooyu neye i to landè salà, i to too matlu; i to mebe ktanak nawa nun belan. ");
INSERT INTO bps_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Kabay mahal kagkah i dad to mimò sasè du nun too falmo dale kadang, na balù i bella falmo. ");
INSERT INTO bps_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Én kagalwà i dad to matlu mdà di Amuito Dwata, na kenen i guflidungla di bang i samuk. ");
INSERT INTO bps_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Kenen i tmabeng dale na falwà dale mdà di falel i dad to sasè; falwaan ale du kenen i gusmaligla. ");
INSERT INTO bps_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Ani satu lingag Dabid. Tafantahàgu i nawagu fatan i tabeng Amugu Dwata, na tafanlingen i katlogu kenen. ");
INSERT INTO bps_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","I kaflayam gnagugu gambet ditù agu di lam i bong mngalam sol too gamlikò deg i nun fitak too lbu; bay fatunan agu, na fansen agu ftadag di tah i batu i gulandè gamsasè deg. ");
INSERT INTO bps_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Na tdoan agu mlingag i falami lingag, satu lingag dmayen Dwataito. Nun klikò dee to di kitela i ktabengan deg kadang, na én gumdàla smalig di Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Too nun klehew i to smalig di Amuito Dwata; too nun kafyen ku laan magin di dad to fdatah, na laan magin di dad to gasyat du mdà di ksaligla di dad ise glut dwata. ");
INSERT INTO bps_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","E Amugu Dwata, ge i Dwatagu, na too dee i tnikeng mgimoam di gami, na landè gasngad ge. I dad fye fandamam gablà di gami là gse; kayègu tulen kdee, bay làgu gagan dun du too dee. ");
INSERT INTO bps_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ise ku én i toom knayè i dad lmanaf dsù, na i dademe dsù i blé di ge; là ge mni i lmanaf snakuf di lifoh du dsù di ge ku demen i dademe dsù du fye bayad i dad salà; bay én toom knayè i fye kaflingegu na kimengu ge. ");
INSERT INTO bps_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Na taman mangu di ge, “Tadini agu du mimò i knayeam, i tagsulat di libru gugsulat i flaloam. ");
INSERT INTO bps_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","E Dwatagu, too agu lehew mimen i knayeam; tafkahgu i flaloam di lam nawagu.” ");
INSERT INTO bps_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Tagtulengu di dad to di bong kastifunla i fye tulen gablà di kagalwà; gadeam là agu sa tlag tmulen dun, Amugu Dwata. ");
INSERT INTO bps_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Làgu buni i fye tulen gablà di kafalwaam deg; gal agu tmulen na ge i too gsalig na too tmabeng. Làgu buni i kakdom landè kgilin na i kagsaligam, du là agu tì fanak ktulengu di bong kastifun i dad tom. ");
INSERT INTO bps_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","E Amugu Dwata, nangam beg tanlag i kakdom deg; fye moon ku i kakdom landè kgilin na i kagsaligam fadlug smafang deg mdà di kdee sasè. ");
INSERT INTO bps_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Kandom agu du maglibut agu i too dee gamsamuk nawagu làgu gagan nse; na mdà di too dee i dad salàgu tafan agu là mite, dee ale fa di dad balu i wakgu, na tafangu là gagan mebe i klidùgu. ");
INSERT INTO bps_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","E Amugu Dwata, falwaam agu di dee gamsamuk deg ani! Gasilam agu tnabeng! ");
INSERT INTO bps_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Fye moon ku i dad to mayè mati deg là gmadè i nawala, na là gadlug i knayèla nimò di deg. Na fye ku fafanakam i dad to lehew di kafsasèla deg, na fyaam ale mdà di nimòla. ");
INSERT INTO bps_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Fye moon ku bong klidù nawa i dad to madoy deg di kagfisanla agu. ");
INSERT INTO bps_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Kabay i dad to mayè fdadong di ge, fye ku flehew ale di kafyem, na i kdee to lehew mdà di kafalwaam dale, na fye ku là tlag i kdayenla ge na galla man, “Too mdatah Amuito Dwata!” ");
INSERT INTO bps_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Kabay deg, landè galgu na landè gumwègu di klandègu, bay i Amugu Dwata, là mlifet deg. Dwatagu, ge alò i tmabeng deg na falwà deg mdà di sasè kagkahgu; begam agu gasil tnabeng. ");
INSERT INTO bps_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ani satu lingag i bel Kora. Gambet i kalinum i uhe i yéél maloh, salngad ani i kalinumgu ge Dwata. ");
INSERT INTO bps_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Gambet too agu malau ge i too mto Dwata. Kilen kè lêman i kafdadonggu di ge du mangamfù agu? ");
INSERT INTO bps_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mngel agu mduh na butang na gambet alò lwakgu i ninumgu. Too agu gal snalek i dad to, manla, “Tanè sa i ktabeng Dwatam ge?” ");
INSERT INTO bps_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Too sè i klidù nawagu di kagafaldamgu i fye nimògu di muna, di kagingu fa i dee to salu ditù di Bong Gumnè Dwata. Agu i tukè muna di dale di kagumi na too lehew kdeemi; klomi magu mlingag gami na mkit dmayen na mlé fye di Dwata. ");
INSERT INTO bps_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Na mangu di ktogu, “Kan ku too agu mlidù? Na kan ku too msamuk i nawagu? Én fye nimògu, smalig agu di Dwata, na lêman agu dmayen kenen du kenen i falwà deg, na kenen i Dwatagu.” ");
INSERT INTO bps_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Kabay knean too agu mlidù dini di gumawagan, taman gafaldamta ge dini di banwe di saféd i yéél Dyordan mdadong di bulul Hérmon na di bulul Misar. ");
INSERT INTO bps_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","I ksamuk nawagu salngad ku fan agu galnab di gumngalam i mahin; i klidù nawagu gambet malbang lwek mlimun di tah ulugu. ");
INSERT INTO bps_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Di mduh fite Amugu Dwata deg i bong kakdon landè kgilin, na di butang nlingaggu kdayengu Dwata na dasalgu di kenen i mlé deg nawa. ");
INSERT INTO bps_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Mangu di Dwata du kenen i guflidunggu, “Kan ku tanlifetam agu? Na kan ku tmayud agu fa di kafsasè i dad to dmuen deg?” ");
INSERT INTO bps_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","I kadoy dad dmuen deg tamduk gambet tnibela agu, du galla man, “Tanè sa i ktabeng Dwatam ge?” ");
INSERT INTO bps_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Na mangu di ktogu, “Kan ku too agu mlidù? Na kan ku too msamuk i nawagu? Én fye nimògu, smalig agu di Dwata, na lêman agu dmayen kenen du kenen i falwà deg, na kenen i Dwatagu.” ");
INSERT INTO bps_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","E Dwata, neyem i nimògu na fdileam landè kaglut i kdalamla deg; nsenam agu di kduen dad to là faglut di ge, na falwaam agu di agot i dad to tmulen kéng na mimò sasè. ");
INSERT INTO bps_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Alò ge, Dwata, i guflidunggu; na kan ku tnagakam agu? Kan ku tmayud agu fa di kafsasè i dad to dmuen deg? ");
INSERT INTO bps_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Tuyalam deg i kalwam fye teengu i dalangu, na i kaglutam i malak deg na mebe deg samfulê di Bong Gumneam déén di bululam, Sion. ");
INSERT INTO bps_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Di duh kakelgu déén fusuk agu du fdadong di gustifun dad to mangamfù di ge du ge i too guflehewgu. Na dmayen agu ge, Dwata, fagu di kbitgu i arfagu, du ge i Dwata gusmaliggu. ");
INSERT INTO bps_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Na mangu di ktogu, “Kan ku too agu mlidù? Na kan ku too msamuk i nawagu? Én fye nimògu, smalig agu di Dwata, na lêman agu dmayen kenen du kenen i falwà deg, na kenen i Dwatagu.” ");
INSERT INTO bps_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Ani satu lingag i bel Kora. Dwata i guflidungito na gumdà galito; faflal kenen tmabeng gito di kakel i samuk. ");
INSERT INTO bps_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Én duenito là likò balù fa too mingok i tanà, na mtubak i dad bulul ditù di gumngalam i mahin. ");
INSERT INTO bps_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Balù fa too mluk na too mgal i dad lwek na mgingok i dad bulul mdà di bong kgal i mahin là ito likò. ");
INSERT INTO bps_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Nun gumdà klehew di syudad Dwata Too Mdatah na di lam i Gumnean salngad di satu bong yéél landè gumtin. ");
INSERT INTO bps_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Ditù i gumnè Dwata, taman landè gafalmo dun; na too mlal i ktabengan di dad to mnè ditù. ");
INSERT INTO bps_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Dad to di sahal banwe, sfati ale na fan malmo i dad banwela, bay Dwata, fagu alò di taluan mtunal i klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Amuito Dwata, i gumdatah i kdee di tah langit na tanà, dini kenen du nsenan ito; i Dwata gusmalig i gutambulito Dyékob i guflidungito. ");
INSERT INTO bps_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Salu gamu dini, na neyeyu i mgimò Dwata; neyeyu i bong gamtikeng mgimoan dini di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Hae, talaam nan faloh ku nun dad kasfati di klamang banwe, tanfoan i dad bohol na agas, na snakufan i dad klung i dad sundalu. ");
INSERT INTO bps_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Man Dwata, “Fanak gamu, fye gadèyu agu sa Dwata, agu i gumdatah i dad banwe; na i dad to di klamang banwe, fdatahla agu.” ");
INSERT INTO bps_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Amuito Dwata, i gumdatah i kdee di tah langit na tanà, dini kenen du nsenan ito; i Dwata gusmalig i gutambulito Dyékob i guflidungito. ");
INSERT INTO bps_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Ani satu lingag i bel Kora. Kdeeyu dad to, samdafì gamu falel di klehewyu! Mkit gamu dmayen Dwata, ");
INSERT INTO bps_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","du i Amuito Dwata Too Mdatah i gablà kanlikò; kenen i mdatah harì mebe kdee di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Tablén gito gnagan misan dad to di sahal banwe; tafkahan ale di dungan falel i bliito. ");
INSERT INTO bps_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Kenen i malék i tanà gumneito, i too mabtas nfun Dyékob i gutambulito toon kando. ");
INSERT INTO bps_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Samfulê Amuito Dwata di gumnean di tah gagin kit i dad to dmayen kenen na uni dad féw, du tagfisanan dad dmuen kenen. ");
INSERT INTO bps_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Mlingag ito dayenito Dwata, mlingag ito dayenito! Mlingag ito dayenito i Hariito, mlingag ito dayenito! ");
INSERT INTO bps_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Du Dwata, kenen i harì mebe kdee banwe di klamang tanà; dnayenito kenen fagu di klingag dad mabtas lingag. ");
INSERT INTO bps_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Dwata i magot dad banwe, na sudeng kenen ditù di mtiu gusudeng i mdatah harì. ");
INSERT INTO bps_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Balù dad mdatah to di dad sahal banwe stifun safédito dad to Dwata, du fdatah ale Dwata i gusmalig gutambulito Abraham; hae, du Dwata mfun kdee glal di tah tanà; too bong kdatahan! ");
INSERT INTO bps_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Ani satu lingag i bel Kora. Kdeeyu, fanlingeyu ani! Kdee to di kdee banwe di klamang tanà flinge gamu! ");
INSERT INTO bps_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Dad mdanà to na dad mdatah to, dad to nun knun na dad to landè, flinge gamu! ");
INSERT INTO bps_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Fandamgu i dad mabtas mngalam fandam, na talù agu i dad tnalù i nun gukmamu dun. ");
INSERT INTO bps_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Nun santulengu i too malima glabat, na fgadègu i gumtatekan fagu di klingag slenggu kambit i arfagu, na dunan ani: ");
INSERT INTO bps_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Là agu likò di bang i nun fan fsasè deg, balù maglibut agu i dad to mlayam deg, ");
INSERT INTO bps_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","dunan i dad to smalig di bong filakla, na fdag i bong knunla. ");
INSERT INTO bps_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Kabay balù simto to dun laan gagan msò i kton; laan gbayad di Dwata i knun nawan, ");
INSERT INTO bps_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","fye mto kenen kel di landè sen, na fye laan mati na lbang; hae, du too mabtas i bayad i nawa dad to; landè gablà bayadan dun. ");
INSERT INTO bps_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","I kdee to teenla na balù i dad to too fulung faldam mati, na salngad i dad to là fulung faldam na i dad to mgal ulu, kdeela mati, na gtagakla i knunla di dademe to. ");
INSERT INTO bps_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Man nawala i tanà gumnèla nfunla kel di landè sen, taman dagitla i tanàla sngad dale dagit, bay i kaglutan, i lbang gumnèla kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Balù nun kdatah i dad to, knean mati ale salngad i dad lmanaf. ");
INSERT INTO bps_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Tatìyu neye ku tan gukel i to smalig di kton, na fsen nawan di knunan. ");
INSERT INTO bps_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","I gukel dad to smalig di ktola mati salngad di dad bilibili nebe di gutmatê dale; fati i mebe dale ditù di lam i lbang. Na di là mlo mdanà ale di dad to matlu, du i fye kagkahla baling lana di kbalok i lawehla di lam i gumnèla di lbang. ");
INSERT INTO bps_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Kabay nsò agu Dwata mdà di agot i fati, du dnawatan agu. ");
INSERT INTO bps_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Taman nang ito fsamuk i nawaito gablà di to mbaling nun bong knunan, na ku baling matnù i kafye nfunan, ");
INSERT INTO bps_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","du di kfatin laan sa gebe i knunan; là magin di kenen i kdatahan ditù di lbang. ");
INSERT INTO bps_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Du balù fa too msen nawa satu to di knean di tah tanà ani, na too kenen dag i dademe to du mdà di bong gnaganan, ");
INSERT INTO bps_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","knean mati sa na mnè ditù di saféd i dad tuan, ditù di gukmifun kel di landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Balù nun kdatah i dad to, knean mati salngad i dad lmanaf. ");
INSERT INTO bps_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Ani lingag Harì Dabid di kafnge i tugad Dwata, Natan, tmalù kenen gablà di kwean ku Batsiba i yaan Yuraya. E Dwata, kandom agu du i kakdom landè kgilin; ge sa i too nun kakdo, taman begam nifu i kdee salàgu di gusmulatam dun. ");
INSERT INTO bps_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Na toom agu nalob mdà di kdee salàgu; nweam kdee sasè di lam nawagu fye too mlaneb. ");
INSERT INTO bps_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Du dilègu dad gukulanggu, na msamuk i nawagu du là agu gamlifet i dad salàgu. ");
INSERT INTO bps_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Di ge alò i gugamsalàgu, du i mgimògu too sasè di kitem; taman too glut i gutadagam dmalam deg, na too matlu i kdee kukumam. ");
INSERT INTO bps_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Too glut agu satu to gamsalà fandà fa di làgu fa sut. ");
INSERT INTO bps_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Én toom kayè di satu to, ku mnè i kaglut na ksalig di lam i nawan, taman tdoam deg du fye too nun kfulunggu faldam. ");
INSERT INTO bps_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Nlanebam agu mdà di dad salàgu, na nweam kalbong kdee kagsikgu fye too agu mlaneb. ");
INSERT INTO bps_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Fuléam di deg i klehewgu; du balù i kiboam deg salngad ku tatanfoam dad tulangu di kablat i salàgu, knean ku nlifetam lêman agu lehew. ");
INSERT INTO bps_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Snafangam matam fye laam teen i dad salàgu, na nifum i kdee sasè mgimògu di gusmulatam dun. ");
INSERT INTO bps_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Blém deg i falami nawa too mlaneb, na fneam déén i kagsalig. ");
INSERT INTO bps_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Nangam agu flana di safédam, na nangam nwè di deg i Mtiu Tulusam. ");
INSERT INTO bps_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Kabay fuléam di deg i klehew i to gmadè tagalwà kenen di agot i sasè, na banlém agu ayègu mimen ge. ");
INSERT INTO bps_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Na én nimògu, tdògu di dad gamsalà i knayeam di dale, na msal ale na fdadong di ge. ");
INSERT INTO bps_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Dwata, falwaam agu di kukum di fati, du alò ge i gafalwà deg, na too agu lehew tmulen di dademe to i kagalwà mdà di ge. ");
INSERT INTO bps_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","E Gumdatahgu, nweam i kyàgu talù, na toogu fdengeg i kafyem. ");
INSERT INTO bps_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ise ku én i toom knayè i kadsù dad lmanaf, du balù blégu ge lmanaf snakuf di lifoh là gaflehew ge. ");
INSERT INTO bps_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Kabay én dsù i toom knayè i kablégu ge i ksal too mdà di nawagu; laam knagol i to malbà i nawan, i to nun klidù nawan mdà di salaan. ");
INSERT INTO bps_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Na banlém kafye na tnabengam i dad tom di banwe Sion, na fdakam lêman i labat batu di glibut syudadam Dyérusalém. ");
INSERT INTO bps_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ku mgimò én, gaflehew ge nan i dad lmanaf dsù di ge, én dad lagi baka snakufmi di lifoh di tah i gudamsù di ge, du blé mdà di glut kimen nawa i mlé dun. ");
INSERT INTO bps_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Ani lingag Dabid di kadtuan di banwe gulandè to di bong banwe Dyudiya. E Dwata, ge i Dwatagu, na too sè klidùgu ge; i klidù nawagu ani, gambet too agu malau. Fanngabalta ge gambet i to mngabal yéél ninum di banwe too kafag na sasè tanà i landè yéél. ");
INSERT INTO bps_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Tagafdadong agu di ge déén di Bong Gumneam, na tateengu i bong enegam na kafyem. ");
INSERT INTO bps_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Du i kakdom landè kgilin too mabtas fa di nawagu ani, na én duengu dmayen ge. ");
INSERT INTO bps_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Mlé agu fye di ge di klogu mto fa, na kayanggu i dad sigalgu déén di ge du dmasal fagu di dagitam. ");
INSERT INTO bps_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Toogu fabsol i layefgu di kafyem, na di klehewgu mlingag agu dmayen ge. ");
INSERT INTO bps_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Di kilègu faldam agu ge; tayud i butang ge i fandamgu. ");
INSERT INTO bps_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Mnè agu di ifatam salngad di knè i anuk di dungan fafak i yéan, taman mlingag agu di klehewgu, du ge sa i tmabeng deg. ");
INSERT INTO bps_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Nlagafta ge na nagotam agu i kwananam du fye landè gaslokgu. ");
INSERT INTO bps_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Kabay dad to mayè mwè i nawagu gtufa kadang ditù di lam i banwe i dad to mati. ");
INSERT INTO bps_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Sdulê ale mati di kasfati, na i lawehla knaan i dad ayem di bnas. ");
INSERT INTO bps_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Kabay i harì ani flehew di kfisan Dwata i dad dmuen deg; na kdee to makang msen di deg flehew du tamaklang i talù dad to tmulen kéng ani. ");
INSERT INTO bps_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","I lingag ani satu lingag Dabid. E Dwata, gablà moon ku dnayenmi ge déén di banwem Sion, na dnohòmi i dad fakangmi di ge; ");
INSERT INTO bps_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","du ge i tmimel dad dasal, taman ge gufdadong dad to di klamang banwe du nun salàla. ");
INSERT INTO bps_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Di kagfisanmi di salàmi, nlifetam sa. ");
INSERT INTO bps_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Too nun kafye di gami i dad to tanalékam na fdadongam du fneam di gustifun dad to mangamfù di ge! Na i too gafnò nawami i kdee kafye di Bong Gumneam. ");
INSERT INTO bps_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","E Dwata, ge i falwà gami, na fagu di too gamtikeng nimoam tnimelam i dasalmi na falwaam gami; na i kdee to di klamang banwe na balù dad to di talà mahin, landè dademe gusmaligla. ");
INSERT INTO bps_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Tafitem i kbong ktulusam fagu di kagafdakam dad bulul di gufneam dale; na fagu di enegam tatangalam ale. ");
INSERT INTO bps_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ge fafanak i uni dad mahin, i luk i dad malbang lwek, na ksugak i dad to. ");
INSERT INTO bps_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Na taman too tikeng dad to di klamang banwe di gamtikeng mgimoam; mkit i dad to mdà di dad banwe di gusut i duh kel di gusdafan di klehewla. ");
INSERT INTO bps_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Fitem i kafdufam i tanà fagu di kfebem i ulen na di kfabuam i tanà; na fananoam yéél i dad sbang na blém i ulê i dad fule fagu di gamtikeng nimoam. ");
INSERT INTO bps_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Hae, banlém ulen i dad dnaru du fye too gsab i yéél di tanà; fatlitikam, du fye flumak i tanà na ftaboam i dad fule déén. ");
INSERT INTO bps_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Na mdà di bong kafyem too munge i dad fule, na landè gukulang balù nè gusalum. ");
INSERT INTO bps_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Balù i sasè tanà là fakay gumule fanbalingam i too fye gumteb du fnulenam; na salngad i dad bulul, too nun tmabò déén. ");
INSERT INTO bps_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Dad gumteb fnò i dad bilibili na dad datal fnò i dad fule; na kdee mkit na mlingag di klehewla. ");
INSERT INTO bps_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Ani satu lingag. E Dwata, kandom gami, na blém di gami kafye; toom fite i klehewam gami; ");
INSERT INTO bps_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","du fye gadè kdee to i knayeam, na i dad to di klamang banwe, gadèla i kagalwà mdà di ge. ");
INSERT INTO bps_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","E Dwata, mulà moon ku dnayen ge i dad to; i kdee to moon too dmayen ge. ");
INSERT INTO bps_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Flehew moon i dad to di sahal dad banwe na mlingag di klehewla, du i kebem i dad to too matlu na ge i mebe i kdee banwe. ");
INSERT INTO bps_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Dnayen ge moon i kdee to, Dwata; too ge moon dnayen. ");
INSERT INTO bps_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Na nun kadang bong ulê mdà di tanà du Dwata, kenen i Dwataito, na kenen sa i mlé gito kafye. ");
INSERT INTO bps_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Hae, du Dwata sa i mlé kafye, taman i kdee to di kdee banwe nun klikòla moon di kenen. ");
INSERT INTO bps_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Ani satu salmo Solomon E Dwata, banlém i harì kfulung mukum fagu di kaglut, na banlém i tingà i harì tmadol kenen i ge katlu, ");
INSERT INTO bps_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","du fye keben dad tom too matlu, na i kukuman dad mdanà to fagu di kaglut. ");
INSERT INTO bps_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Balù dad bulul gumule i dad tom nun bong ulê kadang i fulela déén, du mdà di matlu kagotan. ");
INSERT INTO bps_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Nsenan i kaglut i dad to landè knun, na falwaan dad to landè tmabeng dale di agot dad mkut dale, na toon fnisan dad mkut i dademela to. ");
INSERT INTO bps_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Na là tlag i kagotan di klo nun duh fa na bulen, na di klo i nun to di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","I ktabeng i kagotan salngad di ktabeng i ulen tatek di dad fule, na i tlitik tatek di tanà. ");
INSERT INTO bps_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Too matnù i katlu i dad to di klo i kagotan, na too nun ktanak i banwe landè gutlagan. ");
INSERT INTO bps_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Magot kenen i klamang banwe mdà di satu mahin kel ditù di satu mahin, mdà di bong yéél Yufratis kel ditù di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","I dad to dmuen kenen, lkuad fdanà di kenen kadang, na lamfan di tanà di munan. ");
INSERT INTO bps_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Dad harì di banwe Ésfanya na di dademe banwe di kilil i mahin mlé di kenen kadang, na kel di dad harì di banwe Arabya na Itiyofya mlé di kenen. ");
INSERT INTO bps_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Kdee harì lkuad kadang di munan, na kdee sahal dad to mimen i knayean; ");
INSERT INTO bps_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","du di kenen kagot kadang, falwaan i dad to landè di kalimala, na i dad to too nun kanlidù, na i kdee to landè tmabeng dale, ku ftabeng ale di kenen. ");
INSERT INTO bps_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","I dad to mlungay na dad to mdanà kandon, na falwaan i dad to landè tmabeng dale di fati. ");
INSERT INTO bps_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Hae, falwaan ale mdà di kabkut na kafsasè i dademe to dale, du too mabtas i nawala di kenen. ");
INSERT INTO bps_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Too mlawil moon i harì! Na mablé kenen kadang i blawen mdà di banwe Arabya. Na nun moon dad to fadlug dmasal kenen du fye mablé kenen kafye mdà di ge, Dwata, di klit duh. ");
INSERT INTO bps_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Tilub moon dad fule i tanà, na lamwek balù kel déén di tah i dad bulul, na too nun ulê i dad fule salngad di banwe Lébanon, na fnò i dad to i dad syudad salngad di bnas tmabò di nligo. ");
INSERT INTO bps_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Nang moon nlifet i dagit i harì kel di landè sen, i kdengegan too fadlug klo i nun duh. Mdà di kenen mablé dad to kafye, na dad to di kdee sahal banwe dmayen kenen! ");
INSERT INTO bps_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Dnayenito Amuito Dwata, i Dwata gusmalig i bel Israél, du alò kenen gmagan mimò dad gamtikeng nimò ani! ");
INSERT INTO bps_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Magdayen i kdatah dagitan kel di landè sen, na i kdee to di klamang banwe dmilè moon i kbong kdatahan. Amén! Amén! ");
INSERT INTO bps_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Ani gusen i dad dasal Harì Dabid, i tingà Dyési. ");
INSERT INTO bps_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Ani satu lingag Asaf. E ge i Mifat Dad Bel Israél, i malak dad to Dyosif gambet i kalak satu mifat dad bilibilin, begam gami fanlinge. Ge i sudeng di gusudeng i mdatah harì di tah i dad kafbaweh dad sérubim, fitem i kdataham na i bong knengam. ");
INSERT INTO bps_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Fitem i bong enegam di dad bel Ifraim, Bénhamin, na Manasas, na begam gami falwà di kaflayam nagumi. ");
INSERT INTO bps_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","E Dwata, fasfuléam gami di ifatam; fitem i kakdom di gami lêman du fye galwà gami. ");
INSERT INTO bps_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","E Amumi Dwata, gumdatah i kdee di tah langit na tanà, kel di kilen fa i kalbutam gami dad tom, na laam fanlinge i dad dasalmi? ");
INSERT INTO bps_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Gambet én knaan blém gami i lwakmi, na too fnò i tabù i lwak finumam gami mdà di klidù nawami. ");
INSERT INTO bps_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Mdà di kalbutam gami nadoy gami i dad to di dad masadfél banwe, na dad dmuen gami tì ale sulé gablà di gami. ");
INSERT INTO bps_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","E Dwata, gumdatah i kdee di tah langit na tanà, fasfuléam gami di ifatam, fitem i kakdom di gami lêman du fye galwà gami. ");
INSERT INTO bps_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Tansoam gami gambet i walad grép mdà di banwe Idyif, na tafalwaam i dademe to mdà di dad banwela, du én gufneam gami, salngad di kfulem walad grép di tanàla. ");
INSERT INTO bps_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Salngad tanlanebam i gumulem walad, na taman too fye kdalil i fulem na kmawal di klamang tanà. ");
INSERT INTO bps_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","I dad bulul tamgalung i walad, na i dad fanga i walad, nlimunla i dad malbang kayu sidar. ");
INSERT INTO bps_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","I dad fangan gafat ditù di mahin Méditéranyu, na i tubadan kel di yéél Yufratis. Salngad én i knèmi na kbelmi, gami dad tom, di banwe gufneam gami. ");
INSERT INTO bps_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Kabay di bang ani salngad ku talanbaam i labat glibut di fulem, du talaam gami nan nifat. Kayeam kè ku i kdee magu mlius mifò i bunge grépam? ");
INSERT INTO bps_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","I dad to dmuen, fansasèla na falmola gami salngad di sdè di bnas samdà i fule grép, na i kdee lmanaf di bnas kmaan dun. ");
INSERT INTO bps_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","15","E Dwata, gumdatah i kdee di tah langit na tanà, beg ge samfulê di gami; lanngalungam gami mdà di langit na neyem i kagkahmi, na fandufam gami i waladam grép tafule i kwananam, i salngad tingà too mgifat. ");
INSERT INTO bps_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","I kibò dad to dmuen gami salngad ku natela i walad grép fulem na snakufla di lifoh. Fye ku falmom ale fagu di kafablatam i baweham di dale. ");
INSERT INTO bps_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Kabay kanlungam i dad to tamgalékam du nfunam, i toom falnok fye too ale mgal. ");
INSERT INTO bps_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ku ani nimoam là gami lêman kmagol ge: tangalam gami lêman, na dmayen gami ge. ");
INSERT INTO bps_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Amumi Dwata, gumdatah i kdee di tah langit na tanà, fasfuléam gami di ifatam. Léam fite i kakdom di gami du fye galwà gami. ");
INSERT INTO bps_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Ani satu lingag i bel Kora. E Amugu Dwata, gumdatah i kdee di tah langit na tanà, too bong nawagu i Bong Gumneam. ");
INSERT INTO bps_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Too mayè i nawagu salu déén di gustifun dad to mangamfù di ge, du én too kayè i nawagu, fdadong di ge; mdà di foon i nawagu kayègu mlingag di klehewgu di too mto Dwata. ");
INSERT INTO bps_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Amugu Dwata, gumdatah i kdee di tah langit na tanà, balù dad malnak anuk di bnas, nimòla i salalla ditù di gudamsù di ge, na dad kalsidaw, ditù gumifatla dad ngàla di gumneam, harìgu na Dwatagu. ");
INSERT INTO bps_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Na too nun kafye i dad to mnè di Bong Gumneam; too ale gal mlingag du dmayen ge. ");
INSERT INTO bps_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Too nun kafye i dad to gamfun kgal mdà di ge; too nun ayèla salu di bululam Sion, du mangamfù di ge. ");
INSERT INTO bps_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Na di kagula salu ditù, di kifalla i too kafag banwe dnagit Baka, tì maloh déén dad sfuten, na di tnanin kulenan nun dee malnak kligu déén. ");
INSERT INTO bps_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Na mbaling matnù i galla di kagula, na kakella di Sion, tadag ale di kanfe Dwata. ");
INSERT INTO bps_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","E Amugu Dwata, gumdatah i kdee di tah langit na tanà, begam fanlinge i kdasalgu di ge; E Dwata, gusmalig i gutambulmi Dyékob, fanlingem agu. ");
INSERT INTO bps_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","E Dwata, banlém kafye harìmi, i mgalékam mebe gami. ");
INSERT INTO bps_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Balù ku alò sduhgu mnè di gustifun dad to mangamfù di ge, too fye fa i knègu ditù, di knègu di balù nean, balù ku kel di mlibu fali. Balù ku alògu tadag di bà gufusuk di Gumnè Dwatagu, too fye fa di deg di knègu di lam i gumnè i dad to mimò sasè, ");
INSERT INTO bps_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","du Amugu Dwata lamwa fandam i dad to na kamlung dale, na kenen mlé kafye na kdatah. Landè kafye i klenan di dad to matlu nimòla. ");
INSERT INTO bps_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","E Amugu Dwata, gumdatah i kdee di tah langit na tanà, too nun kafye i to smalig di ge. ");
INSERT INTO bps_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Ani satu lingag bel Kora Fimò Dwata i syudadan di kenen bulul, ");
INSERT INTO bps_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","na balù tan kalbong nawan i dademe banwe gumnè i bel Dyékob, too bong fa nawan i syudadan, Sion. ");
INSERT INTO bps_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Too fye na gamtikeng i dad gman gablà di Sion, i syudad Dwata. ");
INSERT INTO bps_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","I dad to gmadè Dwata mdà di dad banwe Idyif na Babilon, na mdà di dad banwe Filisya, Tiro, na Itiyofya, fakufan ale di dad to sut di banwe Sion. ");
INSERT INTO bps_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Na i gman gablà di dad to di banwe Sion, “Mdatah to, to ani ku demen to atù, du sut di banwe Sion,” du i Too Mdatah Dwata i mlé kafye knè di dad ton. ");
INSERT INTO bps_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Di ksulat Dwata dagit i dad ton, fakufan i dagit dad to gmadè kenen di dad to sut di banwen. ");
INSERT INTO bps_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Sayew ale na mlingag, manla, “Di Sion gumdà i kdee kafyeito.” ");
INSERT INTO bps_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","I smulat ani dunan Itan, satu to Israh Amugu Dwata, lingaggu kel di landè sen i bong kakdom landè kgilin, na là tlag i ktulengu di dad to, na ge too gsalig. ");
INSERT INTO bps_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Gadègu i kakdom, landè kgilin kel di landè sen, na i kagsaligam, knean i knean landè kgumanan salngad i langit. ");
INSERT INTO bps_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Tagmanam, “Tanimògu i fakang di mgalékgu, i saliggu Dabid; na ani fakanggu di kenen, mangu, ");
INSERT INTO bps_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Làgu faloh ku tlag i kagotam; nun di belam nimògu harì kel di landè sen.’ ” Én i man Dwata di harì mgalékan. ");
INSERT INTO bps_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Amugu Dwata, dmayen kdee mnè ditù di langit i dad gamtikeng mgimoam; mlingag dad kasaliganam dmayen i kagsaligam. ");
INSERT INTO bps_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Amugu Dwata, simto kè di klamang langit salngad ge? Landè dademe ditù di langit salngad ge, ");
INSERT INTO bps_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","du ge i too nafè dad kasaligan di bong kastifunla, na ge i toola kanlikò. ");
INSERT INTO bps_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Amugu Dwata, gumdatah i kdee di tah langit na tanà, landè gasngad i kbong ktulusam; na too ge gsalig di kdee nimoam. ");
INSERT INTO bps_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Balù dad malbang lwek di mahin, ge i magot dale; ku too mgal i lwek, ge sa i fafanak dun. ");
INSERT INTO bps_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Tafalmom Rahab, dunan i banwe Idyif, salngad di kafalmom satu lmanaf dmuen ge; na fagu di bong kgalam tasanbalétam i dad to dmuen ge. ");
INSERT INTO bps_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","I langit, ge i mfun dun, na i tanà nfunam; ge mimò i klamang banwe, na kdee gkah déén, ge i mimò dun. ");
INSERT INTO bps_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Mdà di gufdu i nus timul kel di gufdu i nus sabnal, ge mimò i kdee; mdà di bulul Tabor kel di bulul Hérmon too dnayen i kafye mgimoam. ");
INSERT INTO bps_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Tay, too bong i gnaganam, na bong i kgalam; too mdatah i ktulusam. ");
INSERT INTO bps_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","I katlu na kaglut i gugtadag i kagotam; i kdee nimoam fagu di kakdom landè kgilin na fagu di kagsaligam. ");
INSERT INTO bps_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Amugu Dwata, too nun kafye di dad to fulung dmayen ge, i dad to mnè di kakdom; ");
INSERT INTO bps_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","tayud duh flehew ale di kafyem, na dnayenla i katlum. ");
INSERT INTO bps_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Magdayen gami mdà di ge, du ge gumdà i kgalmi na katumi, mdà di kakdom fdataham gami. ");
INSERT INTO bps_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Hae, Amugu Dwata, du ge i kamlung gami; na ge, Dwata Landè Salà, gusmalig i gutambulmi Israél, na ge i mlé harìmi. ");
INSERT INTO bps_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Gtalù ge di muna fa fagu di kanteen di dad tom too gsalig, na gmanam, “Tanalékgu satu to gumlégu gal di kasfati; tanalékgu kenen mdà di dad mdanà to du fanbalinggu kenen harì. ");
INSERT INTO bps_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Dunan Dabid, i saliggu, na fihokgu kenen fngalo ilè kenen i tanalékgu mbaling harì. ");
INSERT INTO bps_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Là tlag i ktabenggu kenen, na i kgalgu i tamgal kenen. ");
INSERT INTO bps_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","I dad to dmuen kenen, làla kenen gfisan; i dad to sasè, là gamgatu kenen. ");
INSERT INTO bps_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Toogu falmo dad to dmuen kenen; dad to mnang nawa kenen, fnatigu. ");
INSERT INTO bps_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Làgu kenen tnagak, na mnè kenen di kakdogu landè kgilin; na matnù i kdatahan mdà di deg. ");
INSERT INTO bps_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Fabalgu i kagotan mdà di Mahin Méditéranyu kel ditù di bong yéél Yufratis. ");
INSERT INTO bps_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Na manan di deg, ‘Ge i Màgu na Dwatagu; ge i guflidunggu, na ge i Falwà deg.’ ");
INSERT INTO bps_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Na nimògu kenen i sangal twege tingàgu, i too mdatah harì di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Là mgili i kakdogu kenen kel di landè sen, na toogu dnohò i fakanggu di kenen. ");
INSERT INTO bps_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Nun di belan kadang nimògu harì kel di landè sen; fkelgu i kagotan di klo i langit. ");
INSERT INTO bps_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Kabay ku tnagak i belan dad flalògu, na làla lalò i gmangu, ");
INSERT INTO bps_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ku nlafàla i katedgu, na làla nimen i dekgu, ");
INSERT INTO bps_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","fanlayamgu ale mdà di salàla, na fatdukgu ale mdà di sasè nimòla. ");
INSERT INTO bps_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Kabay knean là mgili i kakdogu ku Dabid, na là fakay ku làgu dnohò i fakanggu di kenen du mdà di kagsaliggu. ");
INSERT INTO bps_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Làgu nlafà i fakanggu, na làgu nawì balù satu di kdee tafakanggu di kenen. ");
INSERT INTO bps_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","I fakanggu ani gafat kel di landè sen, du fakanggu fagu di katlugu, na too glut là agu tmulen kéng di ku Dabid. ");
INSERT INTO bps_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Too glut nun harì mdà di belan kel di landè sen, na fkelgu i kagotan di klo i duh. ");
INSERT INTO bps_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Salngad kagkah knè i bulen di langit, i knè kagotan kel di atuan; teen di bulen i kagkah knè i kagotan.” Én man Dwata. ");
INSERT INTO bps_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Kabay ani, Dwata, too sasè i kalbutam di to mgalékam harì; taknangam kenen na taknagolam. ");
INSERT INTO bps_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","I kiboam saligam gambet landè fakangam di kenen; salngad ku tagbatam i kyangenan di kfung. ");
INSERT INTO bps_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Tafalbaam labat i syudadan, na tafalmom i dad guflidungan mdà di dad mngayu. ");
INSERT INTO bps_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Balù simto to magu mlius di banwen tmaku i dad knunan, na nadoy kenen i dademen saldan. ");
INSERT INTO bps_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Tafatum i dad to dmuen kenen, na taflehewam ale. ");
INSERT INTO bps_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Talaam nimò gban i dad tekan, du laam kenen tnabeng di kasfati. ");
INSERT INTO bps_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","I bong kdatahan na kafyen tanweam di kenen; na tanweam i glalan. ");
INSERT INTO bps_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Mdà di dad kiboam kenen, tafanbalingam kenen too tua, balù ise fa bangan tua; na toom kenen fyà. ");
INSERT INTO bps_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","E Amugu Dwata, tan i klo tatiam fbayà i harì mgalékam? Kel di landè sen? Na kel di kilen fa i too kinit i kalbutam kenen? ");
INSERT INTO bps_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Amugu Dwata, fandamam i kfukal klawil i dad to. Landè dé gukmamum dad to, du tanimoam ale, bay kdeela mlal mati na landè alì fye gaganla? ");
INSERT INTO bps_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Simto to mto na landè kfatin? Landè to gmadè i kiboan fye laan mati. ");
INSERT INTO bps_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","E Amugu, tanè i kakdom landè kgilin tafitem di muna, i kakdom tafakangam di ku Dabid fagu di katlum? ");
INSERT INTO bps_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Fandamam i saligam ani, ku tan i kadoyla deg, na i ktayudgu i kafsasè i dad to mdà di dad sahal banwe. ");
INSERT INTO bps_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Amugu Dwata, i harì mgalékam toola tnamfayes; nadoyla kenen balù nè gusalun. ");
INSERT INTO bps_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Kabay balù ani i gmangu, knean toogu dnayen Amugu Dwata kel di landè sen! Amén. ");
INSERT INTO bps_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","I lingag ani satu dasal i salig Dwata dnagit ku Mosis Amugu, ge i tagnè guflidungmi, mdà di muna gutambulmi kel di duh ani. ");
INSERT INTO bps_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Di là fa mgimò i dad bulul na balù i tanà na i banwe ani, ge sa i Dwata landè gumdà na landè gusen. ");
INSERT INTO bps_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Tagmanam di dad to, “Samfulê gamu di gumdàyu,” na glut, di kfatila fasfuléam ale di kfung. ");
INSERT INTO bps_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Di ge, Dwata, i mlibu fali salngad di alò sduh i klon mlius, salngad di alò malfabi ku demen salngad di klo kunung satu to di butang di là mlo lê kenen tanlas. ");
INSERT INTO bps_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Nweam dad to mdà di tah tanà ani di klal kebe i dunuk; gafaldam ale salngad di kagafaldam i kna di kukat i to di flafus; mlal ale mati gambet i bnas, ");
INSERT INTO bps_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","du balù too fye taboan di flafus, là mlo mlanas na di kaflabin mati. ");
INSERT INTO bps_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","I kalbutam, fatimi; too sè klikòmi di kaflabeam. ");
INSERT INTO bps_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Hae, du toom neye i kdee gukulangmi, na balù dad salà bunimi, too gfan di ge; ");
INSERT INTO bps_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","na mdà di kalbutam i salàmi, là gami mlawil; midul i falimi na là mlo kafto i nawami. ");
INSERT INTO bps_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Alò fitu falò fali gal gusen i klawil dad to, na nun gafat di walu falò fali ku too ale mgal; bay slame klidù na kaflayam i gnagula di klola mto, na là mlo fto i nawala. ");
INSERT INTO bps_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Landè to too gmadè i kbong kinit kalbutam, na landè to too gablà i klikoan i kaflabeam. ");
INSERT INTO bps_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Tdoam gami fabtas i dad duhmi mimò di tah tanà ani, du fye fulung gami mebe i ktomi. ");
INSERT INTO bps_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","E Amugu Dwata, kilen dé gusen i kalbutam gami? Kandom gami dad saligam! ");
INSERT INTO bps_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Na fitem gami i kakdom landè kgilin kat flafus, du fye lehew gami kat i duh di klomi fa mto. ");
INSERT INTO bps_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Blém gami ani i klehew salngad kdee i klidù tagablém gami; i klidùmi tanlasam klehew kel di bong klo i dad fali ktayudmi i kaflayam. ");
INSERT INTO bps_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Fitem lêman di gami, dad saligam, i dad gamtikeng nimoam, na fitem di belmi i bong mdatah glalam. ");
INSERT INTO bps_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","E Amumi, E Dwatami, begam gami banlé i kafye mdà di ge, na banlém gami kfulung mimò i nimòmi, du fye too nun gukelan. ");
INSERT INTO bps_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Balù simto mnè di ifat Dwata Too Mdatah, kanlung sa du Dwata i Too Mtulus. ");
INSERT INTO bps_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Fakayan man di Amun Dwata, “Ge i guflidunggu na i kamlung deg; ge i Dwatagu na i gusmaliggu.” ");
INSERT INTO bps_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Gmanam én, du falwaan ge mdà di dad sasè gamfawel ge; na mdà di dad tduk magu i gamfati. ");
INSERT INTO bps_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Snafangan ge di dad gamsasè ge, salngad di anuk smafang i dad ngaan di dungan i fafakan, du fye landè sasè gafat di ge; kanlungan ge du too gsalig kenen. ");
INSERT INTO bps_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Taman landè duenam likò i too kanlikò mkel di butang, ku demen i gamsasè ge mkel di mduh, ");
INSERT INTO bps_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","ku demen i dad tduk tmadè ge di kifu, na demen i gamsasè gafalmo ge di ltu duh. ");
INSERT INTO bps_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Balù kel i bong gaslok na mlibu to mati mdadong di ge, na balù sfalò libu to mati di glibutam, bay là mkel di ge i sasè gaslok én. ");
INSERT INTO bps_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Teenam sa i flayam Dwata i dad to sasè, bay là ge gakuf, ");
INSERT INTO bps_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","du én gumneam, di ifat i Amum Dwata; i Too Mdatah i guflidungam. ");
INSERT INTO bps_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Taman là ge nkel i sasè gaslok, na là gafdadong di gumneam i gamsasè di ge, ");
INSERT INTO bps_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","du dek Dwata i dad kasaliganan mifat ge, fye kanlungla ge balù nè gusalum. ");
INSERT INTO bps_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Silungla ge i dad kmalla, du fye là gtadè di batu i bliam. ");
INSERT INTO bps_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Landè gaslokam balù magu ge di bleng i dad malbang lmanaf liyun, ku demen ndaam i dad saldafan, balù too labè i dad liyun demen too nun alas i dad ulad. ");
INSERT INTO bps_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Man Dwata, “Du bong nawan deg, falwàgu kenen di dad gamsasè kenen, na kanlunggu, du gadean na deg i Amun Dwata. ");
INSERT INTO bps_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Di katlon deg, tnabenggu kenen, na làgu kenen tnagak di bang i nun samuk, bay falwàgu na fdatahgu kenen. ");
INSERT INTO bps_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Fsengu i nawan di klawilan, na banlégu kenen kagalwà mdà di dad gamsasè kenen.” ");
INSERT INTO bps_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Amugu Dwata i harì! Kamlaweh kenen i bong kdatahan na enegan, du toon gfite di kgimoan i banwe; too mgagid i gufkahan dun, na laan mgingok. ");
INSERT INTO bps_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Amugu Dwata, ge magot kdee mdà di katbuan; na di là fa matbù i kdee, tagnè ge déén. ");
INSERT INTO bps_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Amugu Dwata, too lamyak i dad mahin; i luk i dad malbang lwekla too mgal. ");
INSERT INTO bps_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Kabay Amugu Dwata ditù di langit, too mgal i kagotam i kdee, mgal fa di luk i dad malbang yéél, mgal fa di malbang lwek di mahin. ");
INSERT INTO bps_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Kdee gmanam, landè kgumanan; na du matlu ge, Amugu Dwata, gablà ku matlu i kdee nimò di Bong Gumneam kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Salu gamu dini, mlingag ito di Amuito Dwata; flehew ito dmayen kenen, du kenen i guflidungito na i falwà gito. ");
INSERT INTO bps_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Mlé ito fye di kenen di ksaluito di munan; flehew ito mlingag dad lingag dmayen kenen. ");
INSERT INTO bps_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Du Amuito Dwata i too mdatah Dwata, kenen i harì mdatah fa di kdee dademe dwata gusmalig i dad to. ");
INSERT INTO bps_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Kenen i magot i klamang banwe; nagotan kdee mdà di gumngalam i tanà kel di tah i dad mdatah bulul. ");
INSERT INTO bps_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Nagotan i mahin na tanà; du kenen mimò dale. ");
INSERT INTO bps_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Taman fdadong ito na fdanaito ktoito du mangamfù di kenen; lkuad ito di muna Amuito Dwata, i mimò gito, ");
INSERT INTO bps_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","du kenen alò i Dwata gusmaligito, na gito i dad to nifatan salngad di kifat satu to mifat bilibili. E gamu, tooyu fanlinge i manan di gamu di duh ani, ");
INSERT INTO bps_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","manan, “Nangyu fgal i uluyu salngad di mgimò i dad to gutambulyu ditù di Mériba, na salngad di mgimòla di klola ditù di banwe gulandè to di Masah. ");
INSERT INTO bps_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Ditù tnandakla agu, neyela ku tan kaftahàgu i nawagu di landè ksaligla di deg, blaam tateenla i fye mgimògu di dale. ");
INSERT INTO bps_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Fat falò fali klo i kalbutgu i dad to én, na gmangu, ‘Dale i dad to fasyat i nawala; là ale mayè mimen i dad knayègu.’ ");
INSERT INTO bps_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Taman tatoo agu flabè na ani fakanggu na toogu dnohò, gmangu, ‘I dad to ani, talà ale nan gfusuk di banwe gufaftudgu moon dale.’ ” Én man Dwata. ");
INSERT INTO bps_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Mlingag gamu i falami lingag di Amuito Dwata; nlingagyu kenen i kdeeyu dad to di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Nlingagyu Amuito Dwata na dnayenyu kenen! Di kat duh tulenyu i fye tulen, kenen i gafalwà gito. ");
INSERT INTO bps_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Fgadèyu di kdee sahal banwe i kafye mgimoan; tulenyu di kdee bung dad to i dad gamtikeng nimoan. ");
INSERT INTO bps_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Du too mdatah Amuito Dwata, na too kenen gablà dnayen, kenen i too kanlikò mdatah fa di kdee dademe dwata gusmalig i dad to. ");
INSERT INTO bps_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","I kdee dademe dwata fnaglut i dad to, dunan i dad ise glut dwata; bay Amuito Dwata, kenen i mimò kdee di langit. ");
INSERT INTO bps_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Kdatah na afè déén di kenen; i ktulusan na kafyen too teen di Bong Gumnean. ");
INSERT INTO bps_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Dnayenyu Amuito Dwata, i kdeeyu dad to di tah tanà; dnayenyu i kdatahan na i galan. ");
INSERT INTO bps_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Too mdatah Amuito Dwata, taman tooyu dnayen i kdatahan; nebeyu i bléyu di kenen, na fusuk gamu di gustifun dad to mangamfù di kenen. ");
INSERT INTO bps_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Di kfangamfùyu di Amuito Dwata, i landè salà, fdanàyu i ktoyu di kenen, kankal gamu di munan kdeeyu dad to di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Manyu di kdee to di dad sahal banwe, “Amuito Dwata i harì! Tanimoan i banwe ani, na too mgagid i gufkahan dun, na laan mgingok. I kukuman i kdee to fagu di too glut kukum.” ");
INSERT INTO bps_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Flehew gamu kdeeyu mnè di langit na tanà, balù i dad mahin too gamu mluk, na kdeeyu mnè déén di lam mahin flehew gamu. ");
INSERT INTO bps_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Kdee tmabò di tanà na kdee kayu déén di dlag flehew mlingag, ");
INSERT INTO bps_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","du salu dini Amuito Dwata, salu kenen dini du nukuman i kdee to di klamang banwe, na i kukuman i dad to fagu di katlu na fagu di kaglut. ");
INSERT INTO bps_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","I lingag di kablé fye di Dwata Kdeeyu dad to di tah tanà, mkit gamu flehew di Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","I nimòyu di kenen faguyu di bong ayèyu mimò dun, na mlingag gamu di kafdadongyu di kenen. ");
INSERT INTO bps_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Dnawatam i kaglut alò Amuito Dwata i glut Dwata! Na kenen i mimò gito na mfun gito; gito i dad ton na toon ito nifat gambet i to mifat bilibili. ");
INSERT INTO bps_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Fusuk gamu di Bong Gumnean na mlé gamu fye di kenen; hae, fusuk gamu déén di gustifun dad to mangamfù di kenen na dnayenyu kenen; mlé gamu fye di kenen na dnayenyu kenen, ");
INSERT INTO bps_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","du too fye sa Amuito Dwata; i kakdon landè kgilin kel di landè sen, na gsalig i nimoan di kdee to mdà di muna fa na kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","I lingag Dabid Too mdà di nawagu mlé fye di Amugu Dwata; kayègu ku too sikof kdayengu Dwata too mtiu. ");
INSERT INTO bps_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Too mdà di nawagu mlé fye di Amugu Dwata, na làgu glifet i kdee kafye gablén di deg; ");
INSERT INTO bps_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","du kenen i mlifet i kdee salàgu, na kenen fgulê i kdee tdukgu. ");
INSERT INTO bps_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Kenen i msò deg mdà di fati na mlé deg kafye mdà di kakdon landè kgilin. ");
INSERT INTO bps_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Fananoan nawagu i dad fye blén deg di klogu mto, taman samfulê i galgu salngad di lamnok agu fa na salngad di gal i kablak. ");
INSERT INTO bps_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Amuito Dwata i falwà kdee to bankut; di kukuman banlén ale i dale kaglut. ");
INSERT INTO bps_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Fgadè Dwata i knayean nimò di ku Mosis, na gfiten di bel Israél i mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","I Amuito Dwata too kamdo, too bong nawan dad to; laan mlal flabè, na too bong i kakdon na landè kgilin. ");
INSERT INTO bps_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Laan tì fadlug mngak i landè gutlagan, na laan fles flabè kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Laan fanlayam i to gablà di kbong salaan, i kbalasan dad salaito là salngad di kbong ksasè i nimoito, ");
INSERT INTO bps_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","du i kakdon i dad to nun klikò di kenen, landè kgilin, na too là gagan mtas dun; salngad di kdatah i langit di tah tanà i kalbong nawan dale. ");
INSERT INTO bps_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Na laito gagan mtas i kawag i guflana Dwata i salaito mdà di gito, mawag fa di gusut i duh mdà di gusdafan. ");
INSERT INTO bps_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Too nun kakdon i dad to nun klikò di kenen, salngad kakdo i satu mà di kenen dad ngà. ");
INSERT INTO bps_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Du gadean i gumlungayito; laan glifet mgimò ito mdà alò di kfung. ");
INSERT INTO bps_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Gito dad to, là mlo i kneito di tah tanà ani salngad di bnas, na salngad di knè i dad fye baweh bulek di bnas, ");
INSERT INTO bps_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","du kbal i nus na mtatek i dad bulekan, na là mlo mlanas na landè lêman mite dun. ");
INSERT INTO bps_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Kabay i kakdo Amuito Dwata di dad to nun klikò di kenen, knean i knean, landè kgilin mdà di landè gutambuan kel di landè gusenan; i kafyen dale gafat di kdee tugad i bella, ");
INSERT INTO bps_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","i dad to mafè i kasfakangla Dwata, na too fkah di nawala i kimenla katedan. ");
INSERT INTO bps_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Ditù di langit gumagot i Amuito Dwata, na kenen i harì mebe i kdee. ");
INSERT INTO bps_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Mlé gamu fye di Amuito Dwata, gamu dad kasaliganan, gamu dad mtulus mimò i dad dekan na flinge i dad tnaluan. ");
INSERT INTO bps_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Mlé gamu fye di Amuito Dwata, kdeeyu mnè di langit, kdee saligan mimò i knayean. ");
INSERT INTO bps_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Mlé gamu fye di Amuito Dwata, kdeeyu mgimoan di klamang kagotan. Too mdà di nawagu mlé fye di Amugu Dwata! ");
INSERT INTO bps_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Too mdà di nawagu mlé fye di Amugu Dwata! E Amugu, E Dwatagu, too mdatah ge! I klaweham, dunan i bong kdataham na kafyem; ");
INSERT INTO bps_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","kamlaweh ge i bong knengam, du too teen i kdataham di mgimoam; hae, du tanbelam i langit salngad i bong ataf di tah i banwe. ");
INSERT INTO bps_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Tanimoam i gumneam ditù gsen di tah i dad nun yéél di langit. Én snakayam i dad labun na i mgal nus mebe ge salngad di fafak i anuk di bnas. ");
INSERT INTO bps_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Dekam i nus fgadè i knayeam salngad di dad kasaliganam; na i lifoh na silà nimoam dad saligam. ");
INSERT INTO bps_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Too mgagid i kagafdakam i banwe di gufkaham dun, na laan mgingok; ");
INSERT INTO bps_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","na di kafdakam dun snafangam i banwe i bong mahin gambet i klawehan, na maglimun yéél i dad bulul, ");
INSERT INTO bps_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","bay di kngakam, midul i yéél; gambet mila i yéél di bong taluam di kdekam dun. ");
INSERT INTO bps_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Mutù i dad bulul, na maloh i yéél mdà di tah i dad bulul ditù di dad gumdanaan di gumdekam dun. ");
INSERT INTO bps_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Na tanimoam i gusen i yéél i làla glius, du fye talà lêman maglimun i klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Fasfutam i dad sfuten déén di dad gusambangan, na maloh i dad yéél di dad gusambang di bleng i dad bulul. ");
INSERT INTO bps_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Na déén guminum dad lmanaf di dlag; dad mlayal dongki di bnas bnulungla i kalinumla déén. ");
INSERT INTO bps_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Di dad kayu mdadong déén gusmalal i dad anuk di bnas; talù ale déén di dad fangala. ");
INSERT INTO bps_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Mdà di gumneam di langit fulenam di dad bulul; na i tanà, too nun uléan mdà di nimoam. ");
INSERT INTO bps_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Ftaboam i bnas du nteb i dad lmanaf, na léam ftabò i dad fule dad to, du fye nun knaanla mdà di fulela di tanà, ");
INSERT INTO bps_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","nun bunge grép gumwèla i ninum gaflehew i nawala, nun fngalo bulung kindalla, na nun knaan gamlé dale gal. ");
INSERT INTO bps_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","I dad kayu Amuito Dwata, too gablà i yéélla; i dad malbang kayu sidar di banwe Lébanon, Dwata i mule dun. ");
INSERT INTO bps_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Ditù gusmalal i dad anuk di bnas, na balù i dad malbang anuk di dlag smalal di dad kayu mguu. ");
INSERT INTO bps_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","I dad mdatah bulul, gumnè i dad kambing di bnas, na di dad batu i gusalbuni dad malnak lmanaf. ");
INSERT INTO bps_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Tamgimoam i bulen du fdilè di gami i dangan i dad sahal nimòmi, na i duh, gal sdaf di too glut bangan kat duh. ");
INSERT INTO bps_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Tamgimoam i butang, na lamwà i dad lmanaf di bnas ku takifu. ");
INSERT INTO bps_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Bong talù i dad mgal liyun di kafngaballa i kanfèla; fanngaballa i knaanla di Dwata, i mlé dun di dale. ");
INSERT INTO bps_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Na di ksut i duh, mulê ale di dad gusalbunila du ftud ale; ");
INSERT INTO bps_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","bay i dad to, lamwà ale du nun nimòla kel di kifu. ");
INSERT INTO bps_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","E Amugu Dwata, tay, bong kdee i dad mgimoam! Too bong kfulungam mimò i kdeela; na too fnò i banwe i dad mgimoam. ");
INSERT INTO bps_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ditù i mahin too bong na too mabal, na too dee lmanaf mnè déén, là gse i kdeela, dad malbang na dad malnak. ");
INSERT INTO bps_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Magu déén i dad malbang kafal, na i too bong lmanaf di mahin dnagit Lebiatan tamgimoam du tì kenen magaf déén. ");
INSERT INTO bps_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","I kdee gmangu gine, smalig ale di ge, i mlé knaanla di bangla bitil. ");
INSERT INTO bps_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Di kablém dale knaan, kmaan ale, na bsol ale di kafye blém dale. ");
INSERT INTO bps_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Kabay ku laam banlé, landè kibòla; ku nawiam i nawala, mati ale, na mbaling ale kfung lêman. ");
INSERT INTO bps_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Kabay di kfebem i Tulusam mimò i dademe, nun lêman mto di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Kayègu ku landè gusen i kafye mgimò Amugu Dwata, na ku nun bong klehewan di kdee mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Fagu alò di keyen i tanà, mgingok; aloan tandel i bulul, na lamwà i buk. ");
INSERT INTO bps_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Nlingaggu i Amugu Dwata di klogu mto; nlingaggu dad kdayen i Dwatagu di klo i nun nawagu. ");
INSERT INTO bps_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Lehew moon kenen di kdee lingaggu ani, du kenen i kanlehewgu. ");
INSERT INTO bps_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Gablà ku malmo i kdee to gamsalà di tah tanà ani; na ku talandè nan dad to mimò sasè. Too mdà di nawagu mlé fye di Amugu Dwata! Dnayenito i Amuito Dwata! ");
INSERT INTO bps_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Mlé gamu fye di Amuito Dwata, na fdatahyu dagitan; fgadèyu di kdee to di dad sahal banwe i mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Mlingag gamu di kenen lingag i kdayenyu kenen, na tulenyu i kdee kafye mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Fdatahyu i dagit i Amuito Dwata; na flehew gamu i dad to mayè fdadong di kenen. ");
INSERT INTO bps_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Fdadong gamu di kenen na mni gamu gal mdà di kenen, na nang gamu tlag fdadong di kenen. ");
INSERT INTO bps_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","E gamu bel Abraham, i to salig Dwata, gamu bel Dyékob, i to mgalék Dwata, fandamyu i dad kafye mgimò Dwata, i dad gamtikeng mgimoan, na i dad kukuman i dad to dmuen kenen. ");
INSERT INTO bps_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","I Amuito Dwata, kenen i Dwata gusmaligito, na kenen i mukum kdee to di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","I fakangan, laan nlifet dun kel di landè sen; dnohoan i fakangan di dad to kel di file libu tugad i bella, ");
INSERT INTO bps_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","dunan i fakangan di ku Abraham, i too fakang Dwata lêman di ku Isaak. ");
INSERT INTO bps_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Na nulitan lêman di ku Dyékob, dunan Israél, i fakang én; fgadean kenen, landè gusen i fakangan, ");
INSERT INTO bps_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","manan, “Blégu di ge i banwe Kanaan, du nfunam.” ");
INSERT INTO bps_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Di bang i kfakangan ani là fa dee bel Israél; na tatì ale alò magu di banwe Kanaan. ");
INSERT INTO bps_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Alò ale lamngab di dad sahal banwe déén, mdà di banwe satu bung dad to, ditù di banwe satu bung dad to. ");
INSERT INTO bps_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Kabay balù ani kagkah knèla, là faloh Dwata ku nun mkut dale, nngakan dad harì mayè smamuk dale, ");
INSERT INTO bps_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","manan, “Nangyu fansasè i dad salig i tamgalékgu, na nangyu fanlayam i dad tugadgu.” ");
INSERT INTO bps_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Di kafkel Dwata i bong kbitil di banwe én, du nwean i kdee knaanla, ");
INSERT INTO bps_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","tafeben satu to muna di dale, dunan Dyosif i fablila na gfasak. ");
INSERT INTO bps_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Gseey i dad blian mdà di sangkalì ikatla di kenen, na nlabédla tek i lialan. ");
INSERT INTO bps_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Ani i dad ktandak Amuito Dwata ku Dyosif, kel di bang Dwata too dmohò i kubad Dyosif i dad kna. ");
INSERT INTO bps_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Kagdohò i dad kna, fafalwà kenen i harì di bilanggù, Én fafalwà kenen dunan i mebe i banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Na nimoan Dyosif ulu di kdee di bong gumnean, na fagotan fa kenen kdee nfunan. ");
INSERT INTO bps_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Nun glal Dyosif mdek i dad ganlal di banwe nagot i harì, na tamdò i dad tua gal mebe, fye nun kfulungla mebe. ");
INSERT INTO bps_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Na salu ale Dyékob di banwe Idyif, na mnè ale déén flo. ");
INSERT INTO bps_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Di klola déén too fbel Amuito Dwata i dad ton, na mbaling ale dee fa di dad to dmuen dale. ");
INSERT INTO bps_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","I nimò Dwata ani i gumdà dad to Idyif mbaling mnang nawa i dad to Dwata, na neyela dalanla mgaw dad salig Dwata ani. ");
INSERT INTO bps_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Kabay dek Dwata i saligan Mosis, na i mgalékan Aron salu ditù. ");
INSERT INTO bps_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Na fitela di dad to dad ilè i bong gnagan Dwata, na nimòla dad gamtikeng di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Na febe Dwata i kifu di klamang banwela, bay là mimen i dad to Idyif i manan di dale. ");
INSERT INTO bps_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Na fanbalingan litè i dad yéélla, na mati dad nalaf déén. ");
INSERT INTO bps_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Na kafnge én, i banwela tì fnò fak, balù di lam dad sibay i dad mebe i banwe di bong gumnè i harì. ");
INSERT INTO bps_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Kafnge én, talù Dwata, na mdà di kmanan tì msut i too dee dad langad na blabang di klamang banwela. ");
INSERT INTO bps_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Na ise ulen i fulenan di klamang banwela, bay én fulenan dad malbang lbatù tno magin i silà. ");
INSERT INTO bps_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Na én gafalmo i fulela grép na i fulela kayu fig, na dad fanga i dademe kayu di banwela mti tfò. ");
INSERT INTO bps_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Na lêman talù Dwata, na mdà di kmanan tì msut i bong dee tlangas i là gagan mse i kdeela. ");
INSERT INTO bps_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Na kdee fulela, mtila knaan; kdee bunge i fulela, knaan i dad tlangas. ");
INSERT INTO bps_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Na i kdee ngà lagi sangal twege di dad to Idyif, fnati Dwata; i tnanin ngàla, én fnatin. ");
INSERT INTO bps_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Na kafnge én, neben i bel Israél lamwà di banwe Idyif; nebela i dad kalyak nimò mdà di salafì na blawen, na kdeela too fye lawehla na mgal ale. ");
INSERT INTO bps_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Lehew i dad to Idyif di kalwà i bel Israél di banwela, du talikò ale di dale. ");
INSERT INTO bps_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Na di kagu i dad to Dwata gnalungan ale i labun; na banlén ale lifoh du tmuyal di butang. ");
INSERT INTO bps_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Mni ale, na fneben ale anuk di bnas, na banlén ale knaan mdà di langit dnagit mana du fabsol dale. ");
INSERT INTO bps_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Tafulétan satu batu, na fatbulan mdà déén i yéél; na maloh i yéél én salngad di satu bong yéél di kafag tanà di banwe gulandè to. ");
INSERT INTO bps_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Tanimò Dwata kdee ani, du laan nlifet i fakangan di saligan Abraham. ");
INSERT INTO bps_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Ani i kagkah keben i dad ton, i dad mgalékan, lamwà di banwe Idyif; na too ale mkit na mlingag di klehewla. ");
INSERT INTO bps_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Na tablén dale i tanà i dademe to mnè di banwe fakangan di ku Abraham, na déén gumwèla knaanla di fule dad to déén. ");
INSERT INTO bps_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Mgimò Dwata kdee ani du fye nun ayèla mlalò i manan dale, na fye nimenla i flaloan. Dnayenito Amuito Dwata! ");
INSERT INTO bps_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Too gamu mlé fye di Amuito Dwata, du too kenen fye; i kakdon, landè kgilin kel di landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Dnayenyu kenen, kdeeyu i tafalwaan. Gamu dad to tansoan mdà di kagot dad to dmuen gamu, fye ku tulenyu! ");
INSERT INTO bps_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Tulenyu sa, du tafasfuléan gamu di gamu banwe, mdà di gusambalétla gamu di dad banwe gsen di gusut i duh, na gsen di gusdafan, na mdà di dad banwe gsen di gufdu i nus sabnal na gsen di gufdu i nus timul. ");
INSERT INTO bps_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Nun dademe di dad to falwaan du tatì ale lamngab di banwe gulandè to, na landè teenla banwe fye gumnèla. ");
INSERT INTO bps_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Bitil ale na malau, na too mlungay i nawala. ");
INSERT INTO bps_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Bay di knèla fa di sasè kagkahla tlola Amuito Dwata, na falwaan ale di kaflayamla. ");
INSERT INTO bps_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Na nalakan ale di matlu dalan salu ditù di bong banwe gufnean dale. ");
INSERT INTO bps_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Taman fye ku too ale mlé bong fye di Amuito Dwata mdà di kakdon landè kgilin, na mdà di kafye mgimoan di dale, ");
INSERT INTO bps_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","du kenen i mlé ninum di dad to malau, na mlé fye knaan du fabsolan i dad to bitil. ");
INSERT INTO bps_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Nun dademe, salngad ku mnè ale di gukmifun, dunan i too sasè kaflayam; gakfè ale na mgikat ale di kaflayam, na lê mgikat i dad blìla sangkalì. ");
INSERT INTO bps_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Maflayam ale du taknagolla i kated Dwata, i Too Mdatah, na tanadoyla i flaun dale. ");
INSERT INTO bps_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Taman fdanà ale fagu di too blat fimòla dale; na di klungayla fugen ale, na landè to tmabeng dale. ");
INSERT INTO bps_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Bay di knèla fa di sasè kagkahla tlola Amuito Dwata, na falwaan ale di kaflayamla. ");
INSERT INTO bps_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Falwaan ale di gukmifun, na falwaan ale di dad gamgikat dale. ");
INSERT INTO bps_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Taman fye ku mlé ale bong fye di Amuito Dwata mdà di kakdon landè kgilin, na mdà di kafye mgimoan di dale, ");
INSERT INTO bps_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","du kenen i gmagan lambà dad takab tek, na tamfò i dad taldak tek gumilanggù dad to. ");
INSERT INTO bps_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Nun dademe mbaling fandas mdà di kgimòla sasè, na maflayam i lawehla mdà di sasè nimòla. ");
INSERT INTO bps_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Talandè ayèla kmaan balù tan bung gkaan, na tafan ale mati. ");
INSERT INTO bps_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Bay di knèla fa di sasè kagkahla tlola Amuito Dwata, na falwaan ale di kaflayamla. ");
INSERT INTO bps_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Na fagu alò di taluan fanguléan ale mdà di dad fdasla, na falwaan ale mdà di fati. ");
INSERT INTO bps_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Taman fye ku mlé ale bong fye di Amuito Dwata mdà di kakdon landè kgilin, na mdà di kafye mgimoan di dale, ");
INSERT INTO bps_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","na fye ku mlé ale fye di kenen fagu di kadsù, na ku tmulen ale gablà di kdee mgimò Dwata di dale fagu di lehew lingag. ");
INSERT INTO bps_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Nun dademe di dale maweng mifal di mahin; smakay ale di malbang kafal di kafngaballa klidùla. ");
INSERT INTO bps_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Na ditù di tah i mahin teenla lêman i dad mgimò i Amuito Dwata, na i dad gamtikeng mgimoan di gumngalam i mahin. ");
INSERT INTO bps_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Du dekan i mahin, na nun kel bong mgal nus, na mbaling malbang i dad lwek. ");
INSERT INTO bps_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Na i dad kafalla magket di tah mahin di kgal i nus, na lê gsulif salu di lam i gumngalaman, na landè nan fandamla ku galwà ale du mdà di klikòla. ");
INSERT INTO bps_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Fan ale fugen di kagula di kafal gambet i dad to langal, na landè nan gadèla nimò di kebela i kafal snakayla. ");
INSERT INTO bps_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Kabay di mnè ale fa di sasè kagkahla tlola i Amuito Dwata, na falwaan ale di kaflayamla. ");
INSERT INTO bps_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Na fafanakan i kgal i nus na mahin, na mbaling lanél i mahin. ");
INSERT INTO bps_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Na too ale lehew du talanél nan i mahin, na neben ale fsalu di gudmuung i kayèla gumafat. ");
INSERT INTO bps_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Taman fye ku mlé ale bong fye di Amuito Dwata mdà di kakdon landè kgilin, na mdà di kafye mgimoan di dale, ");
INSERT INTO bps_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","na fdatahla kenen di bong kastifun i dad to, na dnayenla di kastifun dad tua gal mebe dale. ");
INSERT INTO bps_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Too mtulus Amuito Dwata du fkafagan i dad malbang yéél, na fatlagan kaloh i dad sfuten du fye baling kafag i tanà di banwe i dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","I tanà mabù fanbalingan mahì, du mdà di ksasè i dad nimò dad to mnè ditù. ");
INSERT INTO bps_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Na i dad kafag banwe landè to mnè ditù, fanbalingan tanà nun dee kligu, na fatbulan i dad sfuten ditù, ");
INSERT INTO bps_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","du ditù gufnean dad to bnitil, na ditù gufdakla i syudadla du én banwe gumnèla. ");
INSERT INTO bps_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Na di banwe atù i gumlala, mule ale i walad grép, na too bong gwèla ulê i fulela. ");
INSERT INTO bps_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Na toon ale fbel fagu di dee kafye blén dale, na kel di dad lmanafla, landè gukulangla. ");
INSERT INTO bps_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Kabay di kbaling là dee i dad ton mdà di sasè kabkut i dad to dmuen na misan dale, mbaling ale too mdanà mdà di kaflayamla na klidù nawala. ");
INSERT INTO bps_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Taman fite Dwata i kaflabean i dad to mkut dale, na tatian ale falngab ditù di banwe landè to di landè too gugafatla. ");
INSERT INTO bps_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Kabay i dad to landè, i dad to bankut, falwaan ale di kaflayamla, na fbelan ale salngad di kbel dad lmanaf too fanse nifat. ");
INSERT INTO bps_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Di kite i dad to matlu i kifatan dale too ale lehew, bay i dad to mimò sasè, landè gmanla. ");
INSERT INTO bps_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Na balù simto to fulung faldam fye ku toon fandam i gmangu, na fye ku toon dnilè i bong kakdo Amuito Dwata landè kgilin. ");
INSERT INTO bps_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Man i Amuito Dwata di Amugu, manan, “Fagotgu ge i kdee, taman sudeng ge dini gsen di kwanangu; kel di kagfisangu dad dmuen ge, na i kafkahgu dale di dungan i falel bliam.” ");
INSERT INTO bps_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Amugu, mdà di banwe Sion, falbong Amuta Dwata i nagotam, na manan, “Nagotam nan i dad mnang nawa ge. ");
INSERT INTO bps_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Na di duh kasfatim i dad dmuen ge, i dad tom, too ale mayè tmabeng ge di kasfati; i ksalu i dad lamnok lagi déén di ge di bulul gumneam salngad di alù msut di too flafus.” ");
INSERT INTO bps_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Tamakang i Amuta Dwata, na laan nawì i fakangan, gmanan, “Tanalékta ge du mbaling bà i dad togu di deg kel di landè sen, salngad di ku Harì Mélkisidék, i bà di deg di muna na dad tmadol kenen.” ");
INSERT INTO bps_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Na balù tan i nimoam, déén i Amuta Dwata gsen di kwananam; na toon fnisan i dad harì dmuen ge di duh i sè kalbutan. ");
INSERT INTO bps_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Nukuman i dad to di dad sahal banwe, na too dee i dad to fnatin di kfisanan i dad harì di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Na kafnge én, minum i harì di yéél di kilil i dalan, na kanto nun galan, tadag kenen du tamatu kenen di kasfati. ");
INSERT INTO bps_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Amumi Dwata, ise di gami fye gumlé dad to dayen. Ise di gami! Alò ge i fye gumlé dayen du mdà di kakdom landè kgilin na too ge gsalig. ");
INSERT INTO bps_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","I dad to di dad sahal banwe, kan ku snalekla gami, manla, “Tanè i Dwatayu?” ");
INSERT INTO bps_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Én gami Dwata, ditù kenen di langit, na nimoan balù tan i knayean. ");
INSERT INTO bps_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Kabay i dad fnangamfù dad to i smalek gami, alò nimò mdà di salafì na blawen, dad ise glut dwata du nimò alò i dad to. ");
INSERT INTO bps_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Nun bàla, bay là ale gtalù, na nun matala, bay là ale mite. ");
INSERT INTO bps_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Nun klingela, bay là ale mlinge, na nun ilungla, bay là ale gambun. ");
INSERT INTO bps_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Nun kmalla, bay là ale gamgagot, na nun blìla, bay là ale gagu, na balù satu uni, landè di bkakongla. ");
INSERT INTO bps_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","I dad to mimò dun, mbaling dad to landè gukmamu salngad i dad dwata nimòla, na salngad kagkah i dad to smalig di dad ise glut dwata. ");
INSERT INTO bps_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","E gamu bel Israél, smalig gamu di Amuito Dwata, du kenen alò i gamtabeng na kamlung gamu. ");
INSERT INTO bps_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Gamu dad bàmi di Dwata, i bel Aron, smalig gamu di Amuito Dwata, du kenen alò i gamtabeng na kamlung gamu. ");
INSERT INTO bps_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Kdeeyu dad to nun klikò di Dwata, smalig gamu di kenen, du kenen alò i gamtabeng na kamlung gamu. ");
INSERT INTO bps_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","I Amuito Dwata là mlifet gito, na toon ito banlé kafye, banlén kafye i bel Israél, na banlén kafye i dad baito di Dwata, i bel Aron. ");
INSERT INTO bps_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Banlén kafye i dad to nun klikò di kenen, i dad to mdatah na dad to mdanà, salngad i kablén kafye di dale. ");
INSERT INTO bps_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Gamu, na kel di belyu, too fbel moon i Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","I Dwata mimò i langit na tanà, fye moon ku mlé kenen kafye di gamu. ");
INSERT INTO bps_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","I langit, alò Dwata mfun dun, bay i tanà, tablén di dad to. ");
INSERT INTO bps_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","I dad to mati, dunan i talà nan gtalù, là ale gamdayen i Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Kabay gito dad to mto, mlé ito fye di kenen, mdà di duh ani na kel di landè gusenan. Dnayenito i Amuito Dwata! ");
INSERT INTO bps_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Bong nawagu i Amugu Dwata, du fanlingen i katlogu kenen; fanlingen i dasalgu. ");
INSERT INTO bps_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Na du galan agu fanlinge, fadlug agu tamlo di kenen di klogu mto. ");
INSERT INTO bps_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Kantogu lyo na tatoo mdadong di deg i fati, i klikò i fati gamgagot deg; too msamuk i nawagu na too bong klidùgu. ");
INSERT INTO bps_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Na taman tamlo agu du ftabeng agu di Amugu Dwata, mangu, “E Amu, fakdogu di ge, begam agu falwà!” ");
INSERT INTO bps_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","I Amugu Dwata too kamdo, na too kenen matlu; i Dwatagu too fduf i dad ton. ");
INSERT INTO bps_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","I Amugu Dwata kamlung i dad to là gmagan mifat i ktola; du di fan agu mati, kenen i falwà deg. ");
INSERT INTO bps_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Taman fye ku manak nan i nawagu, du too bong i kafye blé Amugu Dwata di deg. ");
INSERT INTO bps_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Gmangu én du tafalwaan agu mdà di fati, na mdà di sè klidù nawa, gumdà i dee lwakgu maloh, na mdà di dad gafalmo deg di kagugu. ");
INSERT INTO bps_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Na ani, lalògu i knayè Amugu Dwata di kdee nimògu di klogu mto di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Balù gmangu, “Too sè kaflayamgu ani!” knean tafadlug agu di kafaglutgu. ");
INSERT INTO bps_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Mdà di ksamuk i nawagu, gmangu fa, “Landè dad to gsalig.” ");
INSERT INTO bps_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Kabay ani, én fandamgu ku tan i balasgu i Amugu Dwata di bong kafye blén di deg. ");
INSERT INTO bps_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Én nimògu, mlé agu fye di kenen fagu di kablégu i dsù gal blé dad to dmawat i kagalwà. ");
INSERT INTO bps_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Na blégu i fakanggu di kenen kadang di muna i kdee ton di bong kastifunla. ");
INSERT INTO bps_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Là fakay man ku landè di Amugu Dwata i kfati satu di dad ton, du too ale mabtas di kenen. ");
INSERT INTO bps_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","E Amugu Dwata, blégu i ktogu di nimoam, hae, blégu i ktogu di nimoam salngad di nimò yêgu, du tafalwaam agu di fati. ");
INSERT INTO bps_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Na nun kadang blégu dsù i kablé fye di ge, na dmasal agu fagu di dagitam, Amugu Dwata. ");
INSERT INTO bps_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Na blégu i fakanggu di Amugu Dwata, di muna i kdee ton di bong kastifunla; ");
INSERT INTO bps_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","déén di gustifun i dad to mangamfù di Amugu Dwata di Bong Gumnean di syudad Dyérusalém gumlégu dun. Dnayengu i Amugu Dwata! ");
INSERT INTO bps_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Mlé gamu fye di Amuito Dwata, du too kenen fye, na i kakdon landè kgilin kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Gamu bel Israél, manyu, “I kakdo Dwata, landè kgilin kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Gamu dad bàmi di Dwata, i bel Aron, manyu, “I kakdo Dwata, landè kgilin kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Gamu dad to nun klikò di Dwata, manyu, “I kakdo Dwata, landè kgilin kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Di knun kaflayamgu tlogu Amugu Dwata, na tnimelan agu na falwaan agu. ");
INSERT INTO bps_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Taman du Amugu Dwata msen deg, là agu likò; du landè gagan i dad to nimò di deg. ");
INSERT INTO bps_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","I Amugu Dwata dini di safédgu du tmabeng deg, na too glut gfisangu kadang i dad to mnang nawa deg. ");
INSERT INTO bps_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Fye fa ku Amuito Dwata i guflidungito, nang ku i ktabeng i dad to i gusmaligito. ");
INSERT INTO bps_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Fye fa ku Amuito Dwata i guflidungito, nang ku i ktabeng i dad ulu di tah tanà ani gusmaligito. ");
INSERT INTO bps_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Balù tamaglibut agu i dee to mdà di dee sahal banwe dmuen deg, knean gfisangu ale fagu di ktabeng i Amugu Dwata. ");
INSERT INTO bps_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Too glut tasanlibutla agu, bay fagu di ktabeng i Amugu Dwata gfisangu ale. ");
INSERT INTO bps_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Sanlibutla agu salngad di dlagan i sugen, bay balù too minit i kalbutla deg mlal magwè, du fagu di ktabeng i Amugu Dwata gfisangu ale. ");
INSERT INTO bps_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Tatoola agu sanfati, na fan agu fisan, bay i Amugu Dwata tmabeng deg. ");
INSERT INTO bps_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","I Amugu Dwata mlé deg eneg na gal; na kenen i falwà deg. ");
INSERT INTO bps_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Fadé fanlingeyu i kit dad to Dwata déén di slungla du lehew ale mdà di katula, manla, “Én bong ktulus Amuito Dwata i gamgimò ani! ");
INSERT INTO bps_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","I ktulusan i gumdaito matu; kenen sa i fatu gito di kasfati.” ");
INSERT INTO bps_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Tagmangu di ktogu, “Là agu mati di kasfati ani, mto agu, na tmulen agu kadang gablà di mgimò Amugu Dwata.” ");
INSERT INTO bps_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Na balù glut tatoo agu fanlayam i Amugu Dwata, bay laan agu blé di fati. ");
INSERT INTO bps_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Taman lanwayu deg i takab di Bong Gumnè Dwata, du fye gfusuk agu du mlé agu fye di Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Ani i gufusuk di Bong Gumnè Amuito Dwata, na én alò gfusuk dini i dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Mlé agu bong fye di ge, Amugu Dwata, du tatnimelam agu, na fatum agu. ");
INSERT INTO bps_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","I batu too knang i dad to fdak i gumnè batu, du di dale fandam landè gukmamu dun, én baling i batu too mabtas di kdee. ");
INSERT INTO bps_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Hae, ani mgimò i Amuito Dwata, na di kiteito, too gamtikeng i nimoan. ");
INSERT INTO bps_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Ani i duh katu mgimò i Amuito Dwata, taman flehew ito di mgimoan. ");
INSERT INTO bps_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","E Amumi Dwata, begam gami falwà; na begam gami banlé fye knè. ");
INSERT INTO bps_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Too nun kafye i to salu dini mebe i glal Amuito Dwata, mlé gami kafye di gamu dini di Bong Gumnè Dwata. ");
INSERT INTO bps_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","I Amuito Dwata, dunan i too glut Dwata, na tabanlén ito kafye; taman mebe gamu dad malnak fanga i kayu, na tambù gamu mimò i klehew, magu gamu mlibut di gumlé dsù di Dwata. ");
INSERT INTO bps_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Ge i Dwatagu na mlé agu fye di ge; ge i Dwatagu na tulengu di kdee to i bong kdataham. ");
INSERT INTO bps_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Mlé gamu fye di Amuito Dwata, du too kenen fye, na i kakdo Dwata landè kgilin kel di landè sen. ");
INSERT INTO bps_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Amugu Dwata, too mabtas di deg i dad flaloam; tayud i duh toogu gal fandam. ");
INSERT INTO bps_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Gal mnè di fandamgu i dad dekam gami; na én gumdàgu too fulung, mdatah fa di dad dmuen deg. ");
INSERT INTO bps_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Du toogu gal fandam i gmanam, na baling mdatah fa i deg gnadè di kdee to tamdò deg. ");
INSERT INTO bps_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Bong fa i kaglabatgu di kaglabat i dad tua, du nimengu i dad tdoam. ");
INSERT INTO bps_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Niwasgu i kdee sasè nimò, du fye mgimengu i tnaluam. ");
INSERT INTO bps_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Làgu nlifet i dad flaum deg, du ge sa i tamdò dun di deg. ");
INSERT INTO bps_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Too fye di deg i dad fakangam, fye fa di kafye nem i tnab too mi. ");
INSERT INTO bps_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Mdà di dad tdoam, matnù i kaglabatgu, én duengu too mnang nawa i dad sasè nimò. ");
INSERT INTO bps_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","I tnaluam gambet i salò tmuyal i dalangu, du fiten di deg i fye dalan gumagugu. ");
INSERT INTO bps_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Too matlu i dad flaloam; tamakang agu mimen dun, na toogu dnohò i fakanggu. ");
INSERT INTO bps_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Amugu Dwata, too sasè kaflayam nagugu ani; begam agu banlé i nawa tafakangam di tnaluam. ");
INSERT INTO bps_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Dnawatam i dasalgu dmayen ge, na tdoam deg i dad flaloam di dad to. ");
INSERT INTO bps_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Balù kilen, gatlagad agu fafati, na làgu glifet dad flaloam, ");
INSERT INTO bps_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","I dad to sasè tafatlagadla i fawel deg, bay là agu sa samyat di tdoam. ");
INSERT INTO bps_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Du i dad gmanam dnawatgu, na làgu tnagak kel di landè gusenan, du ani klehew i nawagu. ");
INSERT INTO bps_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Na taman toogu fangal i nawagu mimen i dad katedam di klogu mto. ");
INSERT INTO bps_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Too tì fye i dad gmanam, na toogu nimen mdà di nawagu. ");
INSERT INTO bps_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","I kafbel i dad tnaluam, lamwa fandam i dad to, na mlé kaglabat balù di dad to landè gnadè. ");
INSERT INTO bps_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Taman too knayè i nawagu mimen i dad dekam gami, gambet nun bong kbitilgu dun. ");
INSERT INTO bps_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Begam agu fanduf na kandom agu, salngad i mgimoam di kdee to kambong ge nawa. ");
INSERT INTO bps_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Nalakam i klafàgu fagu di tnaluam fye là agu tlaab, du én i fakangam; hae, nangam faloh ku mgebe agu i dad salà. ");
INSERT INTO bps_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Falwaam agu di dad to mkut deg, du fye glalògu i dad tdoam. ");
INSERT INTO bps_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Fitem i kakdom di saligam ani, na tdoam deg i dad katedam. ");
INSERT INTO bps_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Maloh i dad lwakgu gambet i kaloh i bong yéél, du i dad to là sa mimen i flaloam. ");
INSERT INTO bps_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Amugu Dwata, too ge matlu, na i dad flaloam too fye. ");
INSERT INTO bps_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","I dad gmanam, i guflaloam i dad to, too matlu, na too gsalig. ");
INSERT INTO bps_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Too dminè i kaflabègu salngad di lifoh, du i dad to mnang nawa deg là ale mimen i dad tnaluam. ");
INSERT INTO bps_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Too glut, dnohoam kdee fakangam, na i saligam ani too mbong nawa dale. ");
INSERT INTO bps_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Balù landè btasgu na nadoy agu fa, knean làgu glifet i dad tdoam. ");
INSERT INTO bps_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","I katlum, Dwata, landè gusenan, na too glut i flaloam. ");
INSERT INTO bps_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Nkel agu ksamuk na kaflayam, bay i dad dekam i gaflehew deg. ");
INSERT INTO bps_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","I kaglut i dad gmanam, là mgili kel di landè sen; banlém agu kaglabat du fye mlawil agu. ");
INSERT INTO bps_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Ani satu lingag i dad to salu di Bong Gumnè Dwata. Meye agu ditù di dad bulul, na snalekgu i ktogu ku tanè gumdà i ktabeng deg. ");
INSERT INTO bps_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Én tmabeng deg, dunan i Amugu Dwata, i mimò i langit na tanà. ");
INSERT INTO bps_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Laan faloh ku nun gamsasè ge, du i mifat ge là sa kudang. ");
INSERT INTO bps_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","I mifat bel Israél, laan gfilot na laan gkudang. ");
INSERT INTO bps_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","I Amuito Dwata i mifat ge; mnè kenen di safédam du guflidungam. ");
INSERT INTO bps_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","I duh là gamsasè ge di mduh, ku demen i bulen di butang. ");
INSERT INTO bps_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","I Amuito Dwata smafang ge mdà di kdee sasè; kanlungan ge fye landè gaslokam. ");
INSERT INTO bps_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Kenen i mifat ge balù nè gusalum, na balù nè gumneam, mdà ani kel di landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Ani satu lingag dad to salu di Bong Gumnè Dwata, mdà di bel Dabid. Toogu lehew di kmanla di deg, “Salu ito ditù di Bong Gumnè i Amuito Dwata.” ");
INSERT INTO bps_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Na ani, tadini gami, tadag di lam i dad bà gufusuk di syudad Dyérusalém. ");
INSERT INTO bps_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Di kimòla Dyérusalém, fansela nimò i syudad too fye baweh na too sgat i dad gumnean. ");
INSERT INTO bps_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Dini i gusalu dad to i Amuito Dwata, i dad sahal lumbuk bel Israél. Salu ale dini du mlé ale fye di kenen, du én i gmanan dale. ");
INSERT INTO bps_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Dini gumukum i kat harìla, i gumnè bel Harì Dabid di bangla magot. ");
INSERT INTO bps_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Dmasal gamu di Dwata na mni gamu du fye nun ktanak di syudad Dyérusalém, manyu, “Begam banlé fye knè i dad to mbong nawa Dyérusalém. ");
INSERT INTO bps_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Mlé ge ktanak di lam i syudad ani, mulà moon landè fsasè i dad to mnè dini na i dad to mebe i banwe ani.” ");
INSERT INTO bps_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Na du nun dad gakedgu na dad demegu bel Israél dini, mangu, “Gamu dad to di syudad Dyérusalém banlé gamu moon ktanak i knèyu.” ");
INSERT INTO bps_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Na du dini i Gumnè Amuito Dwata, én Dwata fnangamfuito, fnigu ku matnù i kafye blé Dwata di Dyérusalém ani. ");
INSERT INTO bps_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Ani satu lingag dad to salu di Bong Gumnè Amuito Dwata, mdà di ku Dabid. Ku talà msen gito i Amuito Dwata, tan dé i gukelito? Tmimel gamu, bel Israél! ");
INSERT INTO bps_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Hae, ku talà msen gito i Amuito Dwata, di kasfati i dad to dmuen gito, ");
INSERT INTO bps_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","tafnatila ito mdà di kadfo i bong kalbutla, hae, gambet i lmanaf fanla gito fanlo di mto ito fa. ");
INSERT INTO bps_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Nkel ito dad to samfati gito gambet glumfak ito i bong dunuk, na nlimun ito i yéél. ");
INSERT INTO bps_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Na tamlimas ito di kgal i aloh yéél, ku là nsen ito i Amuito Dwata. ");
INSERT INTO bps_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Taman, mlé ito kafye di Amuito Dwata, du laan ito faloh di kalmoito di kmal i dad to dmuen gito. ");
INSERT INTO bps_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Tagalwà ito di agotla, gambet satu anuk di bnas galwà di fawel i to mawel; hae, galwà ito du tfò dal i fawella. ");
INSERT INTO bps_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","I tmabeng gito dunan i Amuito Dwata, i mimò i langit na tanà. ");
INSERT INTO bps_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Ani satu lingag dad to salu di Bong Gumnè Amuito Dwata. Di kebe i Amuito Dwata gito samfulê di banwe Sion, gambet kamna ito i kafyen, ");
INSERT INTO bps_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","du tay i bong kuléito, na mkit ito di bong klehew! Na gman i dad to di dademe banwe, “Too gamtikeng i bong kafye mgimò i Amula Dwata di dale.” ");
INSERT INTO bps_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Na too glut, gamtikeng sa i mgimò Dwata di gito, na too ito lehew! ");
INSERT INTO bps_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Taman mni gami di ge, Amumi Dwata, ku fasfuléam gami di fye knèmi di muna, gambet i kfuléam i bong yéél di dad kafag sbang di banwe Négéb di kfulenam dun. ");
INSERT INTO bps_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","I dad to mngel di kaflala bnê, too mkit di klehewla kadang di kaktula! ");
INSERT INTO bps_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Hae, i dad to mngel di kebela i bnê di gumlala, mkit di klehewla kadang di kebela mulê i ulê di bang kaktula. ");
INSERT INTO bps_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Ani satu lingag dad to salu di Bong Gumnè i Amuito Dwata, mdà di ku Solomon. Ku là tmabeng Dwata di kafdak i gumnè, malmo i flayam i dad to fdak dun du landè gukelan. Na ku là tmabeng Dwata di kunung i banwe, malmo flayam i dad to là gkudang munung dun. ");
INSERT INTO bps_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Na balù i ktékyu too flafus na i kléétyu milè di butang, du fgal gamu meye i klidùyu, landè gukelan galwà di tabeng i Amuito Dwata, du kenen sa i mlé klidù i dad to kandon, na i fye kakudangla. ");
INSERT INTO bps_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Balù dad ngà, i Amuito Dwata i mlé dun di dad to; na too glut kafye i dad ngà blén di gito. ");
INSERT INTO bps_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Hae, i dad ngà blén di satu to di falami to fa kenen, gambet i dad fanà nebe satu to makuf di kasfati, ");
INSERT INTO bps_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","nun kafye di to too dee, du laan gfisan di ksiten i dad dmuen kenen balù déén di gususayla. ");
INSERT INTO bps_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Ani satu lingag i dad to salu di Bong Gumnè i Amuito Dwata. Amugu Dwata, di too sè klidù i nawagu, tamlo agu di ge. ");
INSERT INTO bps_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Amugu, begam agu fanlinge; fanlingem i katlogu ftabeng di ge. ");
INSERT INTO bps_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Amugu, ku galam too neye i kdee gugsalàmi, na laam nlifet, simto galwà di kukumam? Landè sa! ");
INSERT INTO bps_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Kabay nlifetam sa i salàmi, du fye toomi ge nafè na nimen. ");
INSERT INTO bps_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Toogu fatan i kafalwà Amugu Dwata deg, na smalig agu di tnaluan. ");
INSERT INTO bps_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Smasaw i nawagu fatan i tabeng i Amugu Dwata, mdatah fa di to munung di butang fatan i kakwalan. ");
INSERT INTO bps_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Gamu bel Israél, smalig gamu di Amuito Dwata, du i kakdon landè kgilin, na fdu di kenen i kagalwà landè gukulangan. ");
INSERT INTO bps_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Na kenen msò i bel Israél di kdee salàla. ");
INSERT INTO bps_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Ani satu lingag dad to salu di Bong Gumnè i Amuito Dwata Amumi Dwata, nangam nlifet Dabid, na i kdee kaflayam tnayudan. ");
INSERT INTO bps_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Fandamam i fakangan di ge, ge i Too Mtulus Dwata gusmalig i gutambulmi Dyékob, ");
INSERT INTO bps_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","du makang kenen, manan, “Là agu mulê di gumnègu, demen milè; ");
INSERT INTO bps_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","na là agu kudang; balù fidang matagu, là, ");
INSERT INTO bps_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","kel di kitegu tanun gumnè Amugu Dwata, i gumnè i Too Mtulus Dwata gusmalig i gutambulmi Dyékob.” Én fakang Dabid. ");
INSERT INTO bps_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Kantomi ditù di Bétléhém lingemi gablà di gufkahla kaban gumkah i dad batu gugsulat i dad flalò Dwata, na ditù gumitemi dun di lagad Dyar. ");
INSERT INTO bps_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Taman manmi, “Salu ito ditù di gumnè i Amuito Dwata, na mangamfù ito di muna i gusudeng i hariito Dwata.” ");
INSERT INTO bps_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","E Amumi Dwata, salu ge di gumneam, na fanak ge déén, ge na i kaban gumkah i dad flaloam, én gumite i bong enegam. ");
INSERT INTO bps_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Fnimi ku i dad bàmi di ge mebe i katlum, na mkit i kdee tom di klehewla. ");
INSERT INTO bps_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Amugu Dwata, du tamakang ge di saligam Dabid, taman nangam knagol i harì tamgalékam ani. ");
INSERT INTO bps_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Tatoo ge makang di ku Dabid, na laam nawì i fakangam, i tagmanam, “Nimògu harì satu di dad ngaam, na kenen i harì tmadol di ge. ");
INSERT INTO bps_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Ku nafè i dad ngaam lagi i tafakanggu di gamu na nimenla i kdee tdògu dale, nun di bella lagi kadang mbaling harì tmadol di ge kel di landè sen.” Én i fakangam di ku Dabid. ");
INSERT INTO bps_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Mgalék Amuito Dwata i banwe Sion, du kayean mnè ditù, ");
INSERT INTO bps_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","na manan, “Ani i gumanakgu kel di landè sen, du kayègu ku dini gumnègu. ");
INSERT INTO bps_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Blégu di dad to di Sion i kdee kanlidùla; balù i dad to landè knun, fabsolgu ale knaan. ");
INSERT INTO bps_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","I dad bàyu di deg mebe i kagalwà di salà mdà di deg, na mkit i kdee togu di klehewla. ");
INSERT INTO bps_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nimògu harì di Sion satu bel Dabid, na tangalgu na flawilgu kagot i harì mgalékgu. ");
INSERT INTO bps_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Toogu fyà i dad to dmuen kenen, bay too nun kafye i kenen kagot, gambet too mneng i kyangenan.” ");
INSERT INTO bps_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Ani satu lingag Dabid. Amugu Dwata, tatoom agu neye, na gadeam i kdee gablà di deg! ");
INSERT INTO bps_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Gadeam i kdee nimògu, ku sudeng agu ku demen tadag; gadeam kdee fandamgu balù too ge mawag. ");
INSERT INTO bps_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Fandamam ku nè gusalugu na ku nè gumilègu, na gadeam i kdee tagusalugu na kdee gnagugu. ");
INSERT INTO bps_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Amugu Dwata, balù ku làgu fa gman dun, tagneam gadè ku tan i mangu. ");
INSERT INTO bps_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Balù nè gumeyegu, déén ge, balù di munagu demen di kagolgu; na snafangam agu i kmalam. ");
INSERT INTO bps_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","I ksikof gnadeam too gamtikeng di deg; too mdatah i kgadeam na landè kibògu gamlabat i kdatahan. ");
INSERT INTO bps_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Nun kè gusalugu i là ge déén, ge i mnè di balù nean? Nun kè gusalbunigu gawag di ge? ");
INSERT INTO bps_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Landè, du ku salu agu ditù di langit, ditù ge! Ku baling agu milè di lam banwe i dad to mati, lê ge ditù! ");
INSERT INTO bps_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Ku nun kibògu mayeng, na mayeng agu salu di sen tù i gusut i duh, ku demen mnè agu di faltù i bong mahin di too gumawagan gsen di gusdaf i duh, ");
INSERT INTO bps_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","balù ditù, ge i malak deg, na ge i tmabeng deg. ");
INSERT INTO bps_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Ku kayègu salbuni di too gukmifun, na balù i kalbong kalwa tì mbaling kifu, ");
INSERT INTO bps_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","knean mite ge sa Dwata, du i kifu là sa kifu di ge, i butang salngad kalwan di bong kalwa di mduh; i kifu na kalwa salngad di ge. ");
INSERT INTO bps_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Ge sa i mimò i kdee di nawagu na lawehgu ani; ge i tmibuk deg déén di tien i yêgu. ");
INSERT INTO bps_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Dnayenta ge du too gamtikeng i kimoam deg, na too tì fye. I kdee nimoam too gamtikeng i kafyela! Too sikof i kgadeam deg; ");
INSERT INTO bps_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","hae, di kimò i lawehgu di gugbunin di lam tien i yêgu, di too fye kastugad i dad tulangu, là gbuni di ge. ");
INSERT INTO bps_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Tateenam agu déén di kamlità agu fa; tagsulatam di librum i gufsen i dad butanggu mto; i kdee butang alelam deg, tagsulatam di là agu fa mto. ");
INSERT INTO bps_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","E Dwata, too mabtas i kdee fandamam gablà di deg, na too tì dee i fandamam. ");
INSERT INTO bps_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Nsegu na too ale dee fa di dad falak, kafngegu mse, déén agu fa di safédam. ");
INSERT INTO bps_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","E Dwata, fye moon ku fnatim i dad to sasè, na fye moon ku talà agu nan snamuk i dad to mayè mati to. ");
INSERT INTO bps_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","I dad to én, talù ale sasè gablà di ge, na falmola i dagitam. ");
INSERT INTO bps_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","E Amugu Dwata, toogu mnang nawa i dad to mnang nawa ge; too mdà di nawagu mnang nawa i dad to dmuen ge. ");
INSERT INTO bps_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Too sikof i knanggu dale, na di fandamgu, lê gami sduen. ");
INSERT INTO bps_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","E Dwata, toom neye i nawagu ani, du fye toom agu gadè; tnandakam agu, fye gadeam i kdee mnè di fandamgu. ");
INSERT INTO bps_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Neyem ku nun sasè dini di deg i gaflidù ge, na nalakam agu, Dwata, di dalanam landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Dnayenyu i Amuito Dwata! Dnayenyu Dwata ditù di Bong Gumnean; dnayenyu kenen di mgagid gumnean ditù di langit. ");
INSERT INTO bps_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Dnayenyu kenen mdà di dad gamtikeng mgimoan; dnayenyu i bong kdatahan landè gasngad dun. ");
INSERT INTO bps_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Dnayenyu kenen fagu di kyufyu dad féwyu, na fagu di kbityu dad fuglung na arfayu. ");
INSERT INTO bps_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Dnayenyu kenen fagu di kbagulyu i dad kulintang na fagu di ksayewyu, na fagu di kbityu dee bung agaf nun tafas, na fagu di kyufyu dad slali. ");
INSERT INTO bps_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Dnayenyu kenen fagu di kbagulyu dad slagi; dnayenyu kenen fagu di kbagulyu dad malbang falimak. ");
INSERT INTO bps_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Kdee nun nawa, dnayenyu Amuito Dwata. Dnayenyu Amuito Dwata!");
INSERT INTO bps_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Na ani dad mabtas fngewe Solomon i tingà Dabid, na harì di banwe Israél. ");
INSERT INTO bps_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Sulatan i kdee ani, du tdoan i dad to, du fye gmadè ale i glut kfulung mdà di Dwata, na dnilèla i fyetdò, na glabatla i dad gal gman too mngalam gumtatekan, ");
INSERT INTO bps_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","du fye dnawatla na lalòla i gadèla fye, du fye matlu i nimòla di demela to, ");
INSERT INTO bps_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","du fye i dad to kulang i kfulung faldam là ale gasyat, na gmadè na fulung i dad lamnok mebe i ktola di fye, ");
INSERT INTO bps_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","gafatnù di gnadè i dad to fulung faldam, na malak i dad to nun kaglabat, ");
INSERT INTO bps_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","du fye glabatla i dad gal gman too mngalam gumtatekan, na i dad fléd gal gman i dad to nun gnadè. ");
INSERT INTO bps_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Silang ge mbaling to nun gnadè, ku funa nun klikoam di Dwata. I dad to là fulung faldam knangla kfulung, na là ale mayè ku nuntamdò dale. ");
INSERT INTO bps_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Tingàgu, toom lalò i kafngeweta ge, na nangam nlifet i tdò yéam. ");
INSERT INTO bps_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Du ku laloam i tdòmi ge, matnù i kafye ldamam, salngad ku lamsak ge i dad fye baweh kas, na matnù i kafyebaweham. ");
INSERT INTO bps_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","11","Tingàgu, nang ge magin dad to gamsalà di klakla ge, ku manla, “Flal ge, magin ge gami, meye ito to bnanoito, balù dad to landè salà meye ito dalan kiboito mlayam dale. ");
INSERT INTO bps_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","Di kiteito i dad to ani kadang mto ale fa, bay di kafngeito mlayam dale mati ale. ");
INSERT INTO bps_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","Na teenito kadang dee bung knun, na too fnò i gumneito kadang i tnakuito. ");
INSERT INTO bps_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Na, magin ge gami, na i kdee tnakuito kadang sansalelito.” Ani gman i dad to gamsalà. ");
INSERT INTO bps_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Kabay tingàgu, nang ge magin dad to gambet ani, fawag ge di dale, ");
INSERT INTO bps_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","du too ale mlal mimò sasè, na mlal ale manò. ");
INSERT INTO bps_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Neyem, ku nite i dad anuk i kimoam fawel, fulung ale fawag, ");
INSERT INTO bps_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","bay dad to gambet én mahal, du là ale fulung fawag di sasè nimò, bay baling dale taban i fawel nimòla na gafalmo dale. ");
INSERT INTO bps_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Taman i dad to mwè i knun demela to, fagu di klabè, nun kalmola. ");
INSERT INTO bps_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","I kfulung faldam flingen di satu to gal tamlo, na tamlo kenen di dalan di gunun dad to, na di fadyan, du kayeanku lingela i tdoan. ");
INSERT INTO bps_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","Falbongan i taluan di gufusuk banwe, na balù nè gustifun dad to, ");
INSERT INTO bps_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","na manan, “Gamu dad kulang kfulung faldam, kan ku fadlug gamu di làyu kfulung? Gamu dad madoy, kilen i katlagyu madoy? Gamu dad là fulung faldam, tan i kloyu mnang i glut kfulung? ");
INSERT INTO bps_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Ku flinge gamu i kngakgu gamu, nun fye fngewegu gamu mdà di fandamgu, na fgadègu gamu i kfulunggu faldam. ");
INSERT INTO bps_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Kabay du knagolyu agu di katlogu gamu, na landè flinge deg di kalakgu, ");
INSERT INTO bps_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","na fbayàyu i kafngewegu gamu, na làyu dnawat i kngakgu gamu, ");
INSERT INTO bps_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","taman di kakel i bong kaflayamyu nulégu gamu, na di kakel i bong klikòyu nadoygu gamu. ");
INSERT INTO bps_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","28","Na di kakel i too sè klikòyu, na too sè kaflayamyu, na too sè ksamuk mlibut di gamu, tloyu agu. Kabay di katloyu deg, là agu tmimel gamu, fanngabalyu agu, bay làyu agu teen. ");
INSERT INTO bps_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Du là gamu mayè gmadè i kaglut, na là gamu mayè mimen Dwata, ");
INSERT INTO bps_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","na tooyu knang i kafngewegu gamu, na làyu dnawat i kngakgu gamu, ");
INSERT INTO bps_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","taman du én kayèyu lalò gamu knayè, là fakay ku là mulê di gamu bunge di ksasè nimòyu. ");
INSERT INTO bps_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Du i dad to kulang kfulung, mlal ale mati, du là ale mayè fulungfaldam, na i dad là fulung faldam, du làla knabas i kfulung, gamdawat alekadang i kalmola. ");
INSERT INTO bps_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Kabay balù simto flinge di deg manak i knean, na galwà kenen kakel i sasè na landè gamlikòkenen.” Ani gman kfulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Tingàgu, flinge ge i tdògu ge, na nangam nlifet i kafngewegu ge. ");
INSERT INTO bps_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","Flinge ge i gman i kfulung faldam, na toom fkah di nawam na fnaglabatam di fandamam. ");
INSERT INTO bps_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","Hae, toom fni i kfulungam mebe ktom, na fadlug ge mni i kaglabat. ");
INSERT INTO bps_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","Na toom fanngabal i kfulung faldam, salngad i kafngabalam salafì demen i knun buni. ");
INSERT INTO bps_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","Du ku nimoam ani glabatam i klikò di Dwata, na nun gnadeam gablà di kenen. ");
INSERT INTO bps_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Du Dwata mlé kfulung faldam, na di kenen gumdà i gnadè na kaglabat. ");
INSERT INTO bps_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Mlé kenen tabeng di dad to matlu, na kenen i klungla. ");
INSERT INTO bps_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Hae, kenen kamlung i dad to mimò fye di demela to, na nalakan dad to i gsaligan di dalan gumagula. ");
INSERT INTO bps_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Na ku alò ge flinge deg, glabatam kadang ku tan i fye, na di kdee nimoam di demem to, too matlu. ");
INSERT INTO bps_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Du mbaling ge kadang to fulung faldam, na mdà di gnadeam nun klehewam. ");
INSERT INTO bps_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","I kfulungam mebe ktom na i kaglabatam i kamlung ge, ");
INSERT INTO bps_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","du fye gawag ge di nimò, na di talù i dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Dad to én, tagakla i matlu na malwa dalan, na magu ale di gukmifun. ");
INSERT INTO bps_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","Na too ale lehew mimò sasè na di kagsalàla, too ale baling flehew. ");
INSERT INTO bps_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Na dad to ani, bigkò i dalanla, na là ale gsalig. ");
INSERT INTO bps_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Na i too glut kfulung ani, fadnan ge di boyo i libun mkat lagi. ");
INSERT INTO bps_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","I libun gambet ani, kahan i yaanan, na nlifetan i fakangan di Dwata di ksongla. ");
INSERT INTO bps_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","Na ku salu ge ditù di gumnean, én gumagum di dalan fati, na i ksalum ditù, salngad ku salu ge ditù di gumnè i dad mati. ");
INSERT INTO bps_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Balù simto tlang di kenen, landè di dale gasfulê di fye knè. ");
INSERT INTO bps_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Taman tingàgu, toom lalò i ldam dad to matlu, na magu ge di matlu dalan. ");
INSERT INTO bps_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Du i dad to matlu, ale sa gamdawat i kafye blé Dwata, na mlawilale di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Kabay i dad to sasè, snabà Dwata mdà di tah tanà ani, na nsoan ale, gambet i ksò i dad bnas mdà di tanà. ");
INSERT INTO bps_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Tingàgu, nangam nlifet i tdògu ge, bay toom busek di nawam i dad fngewegu ge. ");
INSERT INTO bps_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Du i tdògu ge, én flawil ge, na mlé di ge kafye kneam. ");
INSERT INTO bps_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Nangam kah kakdom Dwata na kagsaligan ge, na toom fkah ani di fandamam, na di nawam du fye laam glifet. ");
INSERT INTO bps_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Ku ani nimoam, toom gaflehew Dwata, na nun dengegam di dad to. ");
INSERT INTO bps_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Too ge smalig di Dwata mdà di nawam, na nang ge smalig di ge kaglabat. ");
INSERT INTO bps_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Kabay di kdee nimoam funam Dwata, na fiten di ge i glut dalan. ");
INSERT INTO bps_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Nangam fandam ku too ge fulung, bay toom kanlikò Dwata, na knangam i kdee sasè. ");
INSERT INTO bps_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Na ku ani nimoam, mbaling fye laweham, na matnù i kgalam. ");
INSERT INTO bps_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Toom nafè Dwata fagu di kablém kenen i too fye di kdee mdà di ulê tanaam. ");
INSERT INTO bps_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Na ku ani nimoam, too fnò i folam na landè gusfayu i dademe, na i gufkaham ninumam gal sambél. ");
INSERT INTO bps_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Tingàgu, nangam knang i kaflayam mdà di Dwata, na nangam tatì fbayà i kngakan ge, ");
INSERT INTO bps_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","du Dwata, nngakan di gusasè i to kandon, gambet i kngak i satu mà di tingaan toon kando. ");
INSERT INTO bps_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Nun kafye di to ku nun kfulungan na kaglabatan, ");
INSERT INTO bps_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","du mdatah fa i gweam di kfulung i gweam di salafì, na mabtas fa di ge di blawen. ");
INSERT INTO bps_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Na i kfulung faldam, mabtas fa di kabtas i dad too fye kas, na landè dademe knayeam gufsalngadam dun du too mdatah. ");
INSERT INTO bps_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Mdà di kfulung gdawatam klawil, knun, na kafè. ");
INSERT INTO bps_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Na i dalanan dunan klehew, na i ktanak knè. ");
INSERT INTO bps_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","I to mbaling fulung nun gufyen, na mlawil kenen. ");
INSERT INTO bps_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Mgimò Dwata klamang tanà mdà di kfulungan, na mdà di bong gnadean tafkahan langit ditù di tah. ");
INSERT INTO bps_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Mdà di kfulungan tafalohan yéél, na mdà di kfulungan, ftatekan i alù mdà di dad labun. ");
INSERT INTO bps_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Tingàgu, toom fkah i kfulung faldam na i kfulung mebe ktom difandamam, du fye laam glifet dun, ");
INSERT INTO bps_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","du ku nun kfulungam faldam fye kagkah i nawam, na nun klehew i kneam. ");
INSERT INTO bps_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Na di kagum di dalan, landè sasè gaslokam, na là ge tlaab. ");
INSERT INTO bps_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Di kileam, too fye kakudangam, na landè gamlikò ge. ");
INSERT INTO bps_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Na landè klikoam i dad kaflayam makto i kakelan, ku demen i kalmo kel kadang di dad to sasè, ");
INSERT INTO bps_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","du Dwata i gusmaligam, na laan ge faloh ku mfawel i fawel. ");
INSERT INTO bps_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Ku nun kiboam, galam tnabeng i demem to nun klidù. ");
INSERT INTO bps_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Na nangam man di demem to, “E fayah ktabengta ge”, ku nun kiboam tmabeng dun di duh ani. ");
INSERT INTO bps_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Nang ge faldam mimò sasè di to demem saldan, du ge i gusmaligan. ");
INSERT INTO bps_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Nang ge dmalam i demem to, lumban i to landè sasè nimoan di ge. ");
INSERT INTO bps_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Nang mibal i knun i to labè, na nang ge mlalò i kenen nimò, ");
INSERT INTO bps_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","du Dwata too mnang nawan i dad to mimò sasè, bay fgadean i fandaman di dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Too mnè i kalbut Dwata di malay i dad to sasè, bay too mnè i kafye di malay i dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","I dad to madoy, knang Dwata, bay blén i kafye di dad to fdanà i ktola. ");
INSERT INTO bps_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","I dad to fulung faldam too mgafè, bay i dad to là fulung faldam tatì matnù i kyàla. ");
INSERT INTO bps_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Gamu dad ngà, flinge gamu i fngewe màyu gamu, na tooyu fandam, du fye nun kaglabatyu. ");
INSERT INTO bps_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Nangyu nlifet i tdògu gamu, du slame glut. ");
INSERT INTO bps_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Alògu satu tingà i màgu di satu yaanan, na di tukay agu fa, ");
INSERT INTO bps_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","màgu tamdò deg, na galan man di deg manan, “Toom fkah di nawam i mangu ge, na laloam i tdògu ge, du ku ani nimoam mlawil ge. ");
INSERT INTO bps_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Too ge mngabal kfulung na kaglabat, na nangam nlifet ku demen fbayà i mangu di ge. ");
INSERT INTO bps_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Toom fkah di nawam i kfulung du én kamlung ge, na knabasam du én mifat ge. ");
INSERT INTO bps_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Too ge mngabal i kfulung, du ani mabtas di kdee, na mngabal ge fa kaglabat, balù tan i btasan. ");
INSERT INTO bps_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Ku knabasam i kfulung mbaling ge mdatah, na ku busekam di nawam too ge mgafè. ");
INSERT INTO bps_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Na too ge dnilè i dad to ge i to nunkfulung.” Ani gman màgu di deg. ");
INSERT INTO bps_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Tingàgu, flinge ge di deg na dnawatam i mangu di ge, du fye too ge mlawil. ");
INSERT INTO bps_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Tagatdògu di ge i kfulung, na agu malak ge di matlu dalan. ");
INSERT INTO bps_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Na di kagum landè gablabal di dalanam, na di kilam là ge tlaab. ");
INSERT INTO bps_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Galam fandam i tdògu di ge, busekam di nawam, du ani sa mlé ge klawil. ");
INSERT INTO bps_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Na nang ge salu di gal gusalu i dad to sasè, na nang ge mlalò i dale dalan. ");
INSERT INTO bps_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Fawag ge di sasè dalanla, nang ge magu déén, niwasam na fadlug ge di ge dalan. ");
INSERT INTO bps_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Silang gkudang dad to sasè ku gamgimò ale sasè, na silang ale gaftud ku nun fanlayamla. ");
INSERT INTO bps_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","I sasè nimò i dad to labè, én knaanla, na én ninumla. ");
INSERT INTO bps_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","I dalan i dad to matlu gambet i ksut i duh, du too matnù i knengan kel di too kalwan. ");
INSERT INTO bps_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Kabay i dalan i dad to sasè mahal, du too kmifu, na tlaab ale, du làla teen i gutlaabla. ");
INSERT INTO bps_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Ngàgu, toom fandam i gmangu di ge, na too ge flinge i dad tulengu ge. ");
INSERT INTO bps_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Toom busek ani di fandamam, na toom busek di lam i nawam, du fye laam glifet dun. ");
INSERT INTO bps_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","I dad to too gamlabat i gmangu ani fye lawehla, na too ale mlawil. ");
INSERT INTO bps_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Toom neye ku tan fandam i nawam, du ku tan i mnè di nawam, én nimoam. ");
INSERT INTO bps_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Nang ge tmulen kéng, na ku nun manam toom man i glut. ");
INSERT INTO bps_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Tatì ge fatlu magu di matlu dalan, du fye landè gumyaam. ");
INSERT INTO bps_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Funam fandam i kdee nimoam, du fye too fye i gukelan. ");
INSERT INTO bps_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Fawag ge di sasè, na fadlug ge magu di matlu dalan, na nang ge samyat. ");
INSERT INTO bps_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Tingàgu, nangam fbayà i dad gmangu di ge, bay fanlingem i kfulunggu na i kaglabatgu. ");
INSERT INTO bps_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Du ku ani nimoam, gmadè ge i fye nimò, na di ktaluam i gumite i dademe to nun gnadeam. ");
INSERT INTO bps_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Na i kalak i libun mlafà yaanan, too mi salngad i tnab, na i taluan too mladal, salngad i fngalo, ");
INSERT INTO bps_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","bay di gusenan too nun kféétan, na too gamgebe di kaflayam. ");
INSERT INTO bps_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","I libun gambet ani, alò gamgebe ge di banwe i dad mati, na i dalan gumagun, dunan dalan salu di fati. ");
INSERT INTO bps_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Laan faldam i dalan gumlawilan, na laan gadè, bay i dalanan too bigkò. ");
INSERT INTO bps_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Dad ngàgu, too gamu flinge deg, na nangyu glifet i mangu di gamu ani. ");
INSERT INTO bps_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Too gamu fawag di libun gambet ani, na nang gamu fdadong di gumnean, ");
INSERT INTO bps_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","du ku salu gamu di kenen, lana i kgafè gamu, na là mlo malmo gamu di falel i dad to labè, i landè kakdo. ");
INSERT INTO bps_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","I dad to làyu dilè nwèla di gamu kdee dad knunyu, na too gamu faflayam mwè i knunyu, bay baling nfun i dademe. ");
INSERT INTO bps_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Na di fan kafto i nawayu kadang, mlanu gamu mdà di kalmo ilawehyu. ");
INSERT INTO bps_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Na msal gamu kadang manyu, “Fye moon di munafa, ku fanlingegu i tdò deg, na ku fanlingegu moon i kngak deg. ");
INSERT INTO bps_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Di muna, là agu mayè flinge i dad tamdò deg, tatìgu bayà i tdòla deg. ");
INSERT INTO bps_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Na ani gukelgu, nun sasè kyàgu di mata i dee dadto.” Ani manyu kadang. ");
INSERT INTO bps_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Kaflingengu dun, ku fkahta di kinum, én guminumyu di gamuguminum, én alòyu too kanbong nawa i gamu yaan. ");
INSERT INTO bps_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Landè gufyeyu di dad ngàyu di dademe libun ise yaanyu. ");
INSERT INTO bps_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","I dad ngàyu lamnok sa moon di ifatyu, na gamtabeng ale gamu, ise baling ku di dademe to gutmabengla. ");
INSERT INTO bps_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Taman flehew gamu di glut yaanyu, du too nun klehewyu di dale. ");
INSERT INTO bps_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Flehew gamu di kafye bawehla, na mdà di kakdola gamu na di kafye nimòla di gamu, i gamlé gamu klehew. ");
INSERT INTO bps_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Taman dad ngàgu, kan ku kandoyu i satu libun ise yaanyu? Na kan ku dnawatyu i kakdo mdà di libun yaan i dademe? ");
INSERT INTO bps_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Du teen Dwata i kdee nimòyu, na balù nè i gusaluyu, teenan gamu. ");
INSERT INTO bps_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","I dad salà i to sasè mbaling fawel, du i dad salaan, mawel kenen. ");
INSERT INTO bps_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Mati kenen du laan gagan damnan i kton, na du laan fulung faldam, én mebe kenen di fati. ");
INSERT INTO bps_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Tingàgu, ku makang ge na ge mayad uteng i demem to, ");
INSERT INTO bps_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","neyem ken mfawel ge di kfakangam. ");
INSERT INTO bps_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Tingàgu, ku tadéén ge di falel i demem to, ani nimoam, du fye galwà ge di kfakangam. Salu ge ditù di kenen na fdanaam i ktom, na toom fni di kenen ku began ge falwà di kfakangam di kenen. ");
INSERT INTO bps_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Nang ge kudang balù ftud silang ku tagalwà ge. ");
INSERT INTO bps_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Falwaam i ktom di fawel, gambet i kfulung i anuk falwà i kton difawel, ku demen uhe, falwaan i kton du mila i to dmulak. ");
INSERT INTO bps_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","I to là mayè mimò, fye ku fafulung kenen faldam salngad i dad gulam, du too ale mimò. ");
INSERT INTO bps_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Landè ulula mebe dale, ");
INSERT INTO bps_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","bay balù landè ulula, too ale musek i knaanla di bang i nungumwèla, du tagàla di bang klandèla. ");
INSERT INTO bps_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Kabay ge, i là mayè mimò, tan i klom kudang? Na kilen i kukatam? ");
INSERT INTO bps_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Tmimel i to là mayè mimò manan, “E ftud agu na kudang agu fa làmlo.” Ani gman i to là mayè mimò. ");
INSERT INTO bps_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","Kabay klon kudang makto kel di kenen klandean, salngad kakel i to tmaku mebe tek. ");
INSERT INTO bps_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","I to sasè landè gukmamu, balù nè gusalun gal tmulen kéng. ");
INSERT INTO bps_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Én gukmamun i dad matan, dad blian, na dad kmalan, falyakan du fye nun gafgawan. ");
INSERT INTO bps_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Na too fnò sasè di nawan, du toon fandam i kiboan mimò sasè, na balù nè gusalun, mebe kenen i ksamuk. ");
INSERT INTO bps_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Na du ani nimoan, makto kel i too sasè gaslokan, na landè gugalwaan. ");
INSERT INTO bps_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Nun nam too knang nawa Dwata, fitu kadì i knang nawan, na ani dunan, ");
INSERT INTO bps_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","i kafdatah, i ktulen kéng, i kbanò dad to landè salà, ");
INSERT INTO bps_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","i gal faldam kibò mimò sasè, i mlal mimò sasè, ");
INSERT INTO bps_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","i kdalam di salà, i mebe kasnang nawa i dad to sgalak. ");
INSERT INTO bps_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Tingàgu, toom lalò i kafngewe maam, na nangam nlifet i tdò yéam. ");
INSERT INTO bps_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Toom busek ani di fandamam, na toom busek di lam i nawam, du fye laam glifet kel di atuan. ");
INSERT INTO bps_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","I kafngewela i malak ge di dalan gumagum, na kamlung ge di kifu, na mngewe ge di mduh. ");
INSERT INTO bps_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Du i kafngewe ani, salngad i saloam tmuyal i dalanam, na i kngakla, tamdò ge i kiboam mebe i ktom. ");
INSERT INTO bps_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","I kafngewela, kamlung ge di boyo i libun mkat lagi, na gafadnan ge di kladal talù yaan i demem to. ");
INSERT INTO bps_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Nang ku én kibalam i kafye bawehan, too ge fgeye i ktabugan ge fagu di keyen di ge. ");
INSERT INTO bps_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","I libun mkat lagi, là mabtas i bayadam kenen, bay klafà i yaan, too bong i bayadam du gamgebe ge di gumalmom. ");
INSERT INTO bps_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Tan i fandamam, fakay ku lamkaf ge lifoh na là sakuf i klaweham? ");
INSERT INTO bps_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Na fakay ku mdà ge di minit bala, na là myu i bliam? ");
INSERT INTO bps_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Salngad gukelam ku nlafaam i yaanam, du balù simto mimò ani, là fakay ku là maflayam. ");
INSERT INTO bps_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Là mnang dad to i satu to tmaku i knaan, ku mdà di kbitilan. ");
INSERT INTO bps_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Kabay knean, ku makfè kenen fuléan di to mangfun fitu dulêkalbongan, kel di kti i kdee nfunan. ");
INSERT INTO bps_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Kabay mahal i satu to mlafà i yaanan, landè sa kaglabatan, na toon falmo i kton. ");
INSERT INTO bps_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Na i dengegan too malmo, na too kenen fatduk, na i bong kyaan là lana kel di atuan, ");
INSERT INTO bps_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","du yaan i libun ani, too malbut du mingà nawan, na landè gusen i kbalasan. ");
INSERT INTO bps_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Là magwè i kalbutan balù tan i kalbong bayadam na blém kenen, laan dnawat dun. ");
INSERT INTO bps_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Tingàgu, flinge ge i tdògu ge, na nangam nlifet i kafngewegu ge. ");
INSERT INTO bps_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Toom fkah di nawam fngewegu ge du fye mlawil ge, na toom fangeye i klaloam i dad tdògu ge, salngad i kafgeyem i dadmatam. ");
INSERT INTO bps_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Toom fkah di fandamam, na di nawam i dad tdògu ge, du fye laam glifet dun. ");
INSERT INTO bps_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Knabasam i kfulung, salngad i kakabasam i flanekam, na knabasam i kaglabat, salngad i kakabasam i demem sgalak, ");
INSERT INTO bps_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","du én kamlung ge di boyo i libun mlafà i yaanan, na gafadnan ge di kladal taluan. ");
INSERT INTO bps_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Satu duh meye agu di bintanà i gumnègu. ");
INSERT INTO bps_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","Na teengu dee sawang lagi na kulang kfulungla, bay teengu satu di dale i landè kaglabatan. ");
INSERT INTO bps_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","Magu kenen di dalan mdadong di gumnè i satu libun, na là mlo mdadong kenen di gumnean. ");
INSERT INTO bps_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","Na i kagkah i duh, fan sdaf, na tafan kifu. ");
INSERT INTO bps_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Na snitong i libun i lagi ani, na kamlaweh kenen i klaweh i libun mkat lagi, na tafandaman kiboan moyo kenen. ");
INSERT INTO bps_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Labè kenen na landè kyaan, na dee gal gusalun, na laan gal mnè di gumnean. ");
INSERT INTO bps_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Slaan déén kenen di kilil i dalan, slaan déén di fadyan di gunundad to, fatanan du neyen ku simto bnoyon. ");
INSERT INTO bps_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Na di kiten i lagi ani, lkafan, na nalakan, na too meye di kenen na manan, ");
INSERT INTO bps_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Duh ani tadnohògu i fakanggu, na nun utengu mdà di kadsùgu. ");
INSERT INTO bps_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Taman fanngabalta ge, na du teenta ge taman smitong agu. ");
INSERT INTO bps_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Na nlafingu i gumilègu i too fye baweh batak safut fdu di banwe Idyif. ");
INSERT INTO bps_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Na tankokgu fangbun i gumilègu i dnagit mira, alo, na sinamon. ");
INSERT INTO bps_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Taman magin ge deg du nimòta i knayèta i gaflehew gite kel mwal. ");
INSERT INTO bps_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Là déén yaangu di gumnè, du mawag gusalun. ");
INSERT INTO bps_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Neben sa bong filakan, taman laan mlal samfulê, lwe linggu fa.” Ani gman i libun mlafà i yaanan. ");
INSERT INTO bps_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Na tagboyon lagi ani fagu di kladal i dad gmanan. ");
INSERT INTO bps_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Taman fanlalan lalò i libun ani, salngad i baka dyol salu di gumatin, salngad i uhe mfawel di fawel, ");
INSERT INTO bps_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","na nun tbak di fufungan, salngad i anuk di bnas mayeng ditù di fawel, laan gadè i gukelan kadang di fati. ");
INSERT INTO bps_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Dad ngàgu, flinge gamu i tdògu gamu, na mimen gamu i mangu ani. ");
INSERT INTO bps_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Nangyu faloh i nawayu magin di ayè i libun gambet ani, na nang gamu mlalò i kenen dalan. ");
INSERT INTO bps_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Du tadee lagi falmon, na i dad lagi tamati du mdà di kenen, làyu gse dun du toodee. ");
INSERT INTO bps_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Na ku salu gamu di gumnean, én sa gusaluyu di banwe i dadmati, na i dalanyu ani salu di fati. ");
INSERT INTO bps_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Flinge gamu, du i kfulung na i kaglabat flingengu di satu to tamlo, na falbongan i katlon. ");
INSERT INTO bps_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Tamlo kfulung di bilil, na di gusite i dad dalan di gunun dee dad to, ");
INSERT INTO bps_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","na di gufusuk i banwe, falbongan taluan, manan, ");
INSERT INTO bps_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“Toogu fni di gamu dad to, fanlingeyu agu. Tamlo agu di kdee dad to di klamang banwe, du fye flinge gamu deg. ");
INSERT INTO bps_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Gamu kulang i kfulung faldam, flinge gamu du fye fulung gamufaldam, du fye là gamu gasyat, na gamu là fulung faldam, flinge gamu du fye gamlabat gamu. ");
INSERT INTO bps_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Fanlingeyu i kafye mangu, du kdee mangu di gamu too tlu, ");
INSERT INTO bps_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","du i mangu slame glut, na knanggu i kakakéng. ");
INSERT INTO bps_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","I kdee mangu slame matlu, là agu tmulen kéng, na landè bigkò di mangu. ");
INSERT INTO bps_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Na di to too nun kaglabatan, gadean too glut i mangu, na di to nun gnadean, gadean too matlu i mangu. ");
INSERT INTO bps_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Én nalékyu i dad tdògu ise ku salafì, nalékyu gnadè ise ku i too fye blawen, ");
INSERT INTO bps_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","du agu i kfulung na mabtas fa di kabtas i dad too fye kas, na balù tan i knayèyu di tah tanà ani, landè fsalngadyu di deg, dutoo agu mdatah. ");
INSERT INTO bps_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","Agu kfulung nun kaglabatgu, nun gnadègu, na fulung agu mebe i ktogu. ");
INSERT INTO bps_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","I to nun klikoan di Dwata, knangan i sasè. Na agu kfulung, mnang agu i kafdatah, i kafdag, i sasè nimò, na i kakakéng. ");
INSERT INTO bps_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Agu kfulung, fulung agu mngewe, na fulung agu tmabeng, nun kaglabatgu na nun glalgu. ");
INSERT INTO bps_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Mdà di deg i dad harì gmagan mebe i dad tola, na i dademe dad ulu fulung ale mimò i dad matlu urdin. ");
INSERT INTO bps_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Landè ulu di tah tanà ani fulung mebe i dad to di fye, ku ise agu tmabeng dale. ");
INSERT INTO bps_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Kandogu i dad kamdo deg, na dad to mngabal deg, teenla agu. ");
INSERT INTO bps_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Banlégu ale knun mlawil, afè, na kafye knè. ");
INSERT INTO bps_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","I gwèyu mdà di deg, mabtas fa di kabtas i too blawen, na di kabtas i too salafì. ");
INSERT INTO bps_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Magu agu di dalan matlu, na lalògu i matlu nimò. ");
INSERT INTO bps_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","Na i dad kamdo deg, banlégu ale knun, na tananùgu i mabtas knun i gumnèla. ");
INSERT INTO bps_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","Agu kfulung, muna mgimò Dwata, di laan fa mgimò i kdee di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Tagnè agu mdà fa di kagatbuan, di là fa mgimò i banwe ani. ");
INSERT INTO bps_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Tagnè agu di landè fa mahin, na dad sfuten i fnò yéél. ");
INSERT INTO bps_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Di là fa mgimò dad bulul, tagnè agu. ");
INSERT INTO bps_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Na di là fa mgimò Dwata i klamang banwe, na balù i kfung, tagnè agu déén. ");
INSERT INTO bps_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Déén agu di kafkah Dwata i langit ditù di tah, di kimoan i bleng i langit na mahin, ");
INSERT INTO bps_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","di kafkah Dwata i dad labun di langit, di dad sfuten di lam i mahin, ");
INSERT INTO bps_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","di kafkahan ilè di gusen i mahin, du fye là sambél di kafkahan dun, na di kimoan kgal i klamang banwe ani, déén agu. ");
INSERT INTO bps_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Déén agu di safédan, na magin agu kenen mimò. Na kat i duh flehew agu kenen, na lehew agu magin di kenen, ");
INSERT INTO bps_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","na lehew agu i banwen, na i dad to tamgimoan. ");
INSERT INTO bps_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","Taman dad ngàgu, fanlingeyu agu, nun klehewyu ku nimòyu i gmangu di gamu. ");
INSERT INTO bps_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Ku fanlingeyu i tdògu gamu, nun kfulungyu, na tooyu fkah di nawayu i gmangu ani. ");
INSERT INTO bps_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Nun kafye di to flinge deg, i to kat i duh mnè déén di bà i takabgu, i to fatan deg. ");
INSERT INTO bps_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Du i to mite deg too mlawil, na kanlehew kenen Dwata. ");
INSERT INTO bps_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","I to là mite deg fanlayaman i kton, na i to mnang deg, bong nawan i fati.” Kdee ani gine gman kfulung. ");
INSERT INTO bps_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Na i kfulung faldam flingengu di to fdak i gumnean, na nun fitu lahanan. ");
INSERT INTO bps_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Kmatê kenen i lmanaf du fnistan, na nun bolan fye nem dininuman, na tafnatlagadan i gukmaanan. ");
INSERT INTO bps_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Na dekan i dad saligan libun ditù di gunun dee to, du nlakla i dad to. ");
INSERT INTO bps_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","Na manla, “Na gamu dad kulang kfulung, salugamu dini, na gamu landè kaglabat, ");
INSERT INTO bps_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","salu gamu dini, du kmaan gamu i knaan na minum gamu i ninum i tafnatlagadan gamu. ");
INSERT INTO bps_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Tnagakyu i kulang kfulungyu, du fye mlawil gamu, na lalòyu i dalan kaglabat.” Ani gman kfulung fagu di dad saligan. ");
INSERT INTO bps_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Ku nngakam i to madoy, balingan ge fyà, na ku nngakam i to sasè, balingan ge fansasè. ");
INSERT INTO bps_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Nang ge mngak i to madoy, du knangan ge, bay ku nngakam i to fulung, toon ge nafè. ");
INSERT INTO bps_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","I fngewem di to fulung, gatnù i kfulungan, na i tdoam di to matlu, gatnù i gnadean. ");
INSERT INTO bps_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Du fye mbaling ge to nun kfulung, fye ku funa nun klikoam di Dwata. Du ku gmadè ge Dwata i Landè Salà, gfunam i kaglabat. ");
INSERT INTO bps_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Ku fulung ge faldam, én sa gamlawil ge. ");
INSERT INTO bps_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Du ku fulung ge faldam, ge gukel i kafye, bay ku knagolam i kfulung, ge gukel i kaflayam. ");
INSERT INTO bps_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Guflingengu i to là fulung faldam di satu libun too mugak, na landè gnadean, na landè kyaan. ");
INSERT INTO bps_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Déén gusudengan di bà takab i gumnean ku demen sudeng kenen di gugfan i banwe di gumite i dee dad tokenen, ");
INSERT INTO bps_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","na tamlo du nlakan i dad to magu mlius i dad to fadlug di kagula, ");
INSERT INTO bps_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","na manan di dad to landè kaglabat, manan, “Gamu dad kulang kfulung, fusuk gamu, ");
INSERT INTO bps_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","too mi fa i yéél tnaku, na fye fa nem i knaan ku kmaan ge di gugbunin.” Ani gman i libun là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Kabay i kdee mgeben di gumnean, làla gadè i gukella ku gfusukale déén, du dad muna mgeben tamati ale, na tasbool ale di gumnè i dad mati. ");
INSERT INTO bps_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Na ani dademe dad mabtas fngewe Solomon dunan: Gamlehew i mà i tingaan lagi ku fulung faldam, bay gamlé i klidù di yéan i tingaan lagi là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Landè gufyem di knun gweam fagu di klimbung, bay i katlu nimò i gafalwà ge di fati. ");
INSERT INTO bps_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Là faloh Dwata ku malnus i dad to matlu, na laan faloh ku gwè i dad to sasè i sasè kniballa. ");
INSERT INTO bps_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Ku là ge mayè mimò, én gaflandè ge, bay ku malgad ge mimò, én gafnun ge. ");
INSERT INTO bps_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","I to fulung faldam, kamtu kenen di bang i kaktu, bay magagyà i to ku én balingan nimò kudang di bang i kaktu. ");
INSERT INTO bps_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","I to matlu, nun kafye gdawatan, na i to sasè, gbunin i klabean fagu di kfulungan talù. ");
INSERT INTO bps_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","I to matlu, fnadlug gafaldam kenen balù tamlo nan mati, bay i to sasè, too malmo i dengegan na too kenen mlal glifet. ");
INSERT INTO bps_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","I to fulung faldam, too gamdawat i fye fngewe, bay i to talù là man, falmon i kton. ");
INSERT INTO bps_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","I to matlu landè klikoan du mdà di fye nimoan, bay i to mlimbung, gakfè di klimbungan. ");
INSERT INTO bps_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","I to muni i kaglut, én gumdà i ksamuk, bay i to labè mngak i to mimò sasè, kenen gafatlag i ksamuk. ");
INSERT INTO bps_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","I to matlu, galan man i gafye, na gatgal i dad to mlinge imanan, bay i to sasè, gbunin i klabean fagu di kfulungan talù. ");
INSERT INTO bps_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","I gukel i kasnang nawa, dunan samuk, bay gukel i kakdo, dunan klifet i kdee salà. ");
INSERT INTO bps_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Fagu di talù i to nun kaglabat, dnileam i kfulungan, bay i to landè kaglabatan, fye ku fanlayam kenen. ");
INSERT INTO bps_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","I dad to fulung faldam, làla fagfan i gnadèla du funala gal toofandam ku tan i manla, silang talù. bay ku talù i to là fulung faldam, too mlal i ksamuk. ");
INSERT INTO bps_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","I kamlung i to nun knun, dunan i knunan, bay i gafalmo i to landè, dunan i klandean. ");
INSERT INTO bps_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Mdà di untung i to matlu, nun klawilan, bay mdà di untung i to sasè, nun kaflayaman. ");
INSERT INTO bps_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","I to flinge ku nun mngak kenen, én i to mlawil, bay i to là dmawat i kagsalaan, nun sasè gdawatan. ");
INSERT INTO bps_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","I to muni i knang nawan, én i to tmulen kakakéng, na i to samtugad salék, én i to là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","I to too mayè stulen, slaan gsalà du mdà di dee manan, bay i to gadnanan i taluan, kenen i to fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","I dad talù i to matlu too mabtas, salngad i btas i glut salafì, bay i fandam i to sasè landè btasan. ");
INSERT INTO bps_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","I dad talù i to matlu, too gamtabeng i dee dad to, bay i to là fulung faldam, là mlawil du landè kaglabatan. ");
INSERT INTO bps_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Én gafnun i to mdà alò di kafye blé Dwata, na i kafye blén là gfun dun fagu di kalgad mimò. ");
INSERT INTO bps_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","I to là fulung faldam, too flehew di kimoan sasè, bay i to nun kaglabat, too flehew di kimoan fye fagu di kfulunganfaldam. ");
INSERT INTO bps_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","I kanlikò i to sasè, baling sa mkel di kenen, bay i to matlu, én sa mkel di kenen i knayean. ");
INSERT INTO bps_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Kakel i bong ulen na too mgal i nus fugen i to sasè, bay i to matlu kel di atuan là fisan di kgal i nus. ");
INSERT INTO bps_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Nangam fimò i to malwe mimò du baling smamuk ge, na sasèkafalyalom, salngad kafalyalom i kifanam ku mgihok i sukà ku demen kafdê matami buk. ");
INSERT INTO bps_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","I to nun klikoan di Dwata, mlawil kenen, bay i to sasè, mlal mati. ");
INSERT INTO bps_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","I fatan i to matlu, én gamlé kenen klehew, bay i fatan i to sasè, là gdawatan dun. ");
INSERT INTO bps_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Kanlung Dwata i to matlu, bay i to mimò sasè, falmon. ");
INSERT INTO bps_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","I to matlu, nun kenen kafye mdà di Dwata landè gutlagan, bay i to sasè, là mlawilan di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","I gman i to matlu gugmadè i kfulungan, bay i gman i to sasè, matlag sa kadang. ");
INSERT INTO bps_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Gadè i to matlu i dad fye man i là fatduk i demen to, bay i to sasè, galan fatduk i demen to fagu di sasè gmanan. ");
INSERT INTO bps_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Knang Dwata i to mlimbung di ktimbangan, bay i gulehewan i to tmimbang i glut ktimbang. ");
INSERT INTO bps_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","I to fdag, là mlo nun bong kyaan, bay i to fdanaan i kton nun kfulungan. ");
INSERT INTO bps_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","I katlu i to matlu, mebe kenen di katlun, bay i kabigkò i to sasè, mebe kenen di kalmon. ");
INSERT INTO bps_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","I dad knunam landè gukmamum di kakel i duh kfatim, bay i katlum, i gafalwà ge di sasè kfati. ");
INSERT INTO bps_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","I katlu i to fye, én gafye i knean, bay i ksasè i to sasè, én gafalmo kenen. ");
INSERT INTO bps_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","I katlu i to gsalig, i gafalwà kenen, bay i to là gsalig, tamgikat kenen di sasè knayean. ");
INSERT INTO bps_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Di kfati i to sasè, talandè i kdee imen nawan di tah tanà ani, na i ksaligan di knunan landè gukelan. ");
INSERT INTO bps_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","I to matlu, galwà di samuk, bay én baling nkel i samuk i to sasè. ");
INSERT INTO bps_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","I gman i to là faglut di Dwata, én gafalmo i demen to, bay i kfulung i to matlu, én gafalwà i demen to. ");
INSERT INTO bps_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Too kanlehew i dad to di banwe ku nun fye kel di dad to matlu, na toola kanlehew i kfati dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Fagu di nimò i dad to matlu mbaling mdengeg i banwe, bay fagu di talù i dad to sasè malmo i banwe. ");
INSERT INTO bps_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","I to madoy i demen to kulang kaglabatan, bay i to nun kaglabat landè manan. ");
INSERT INTO bps_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","I to samtugad salék, là gsalig gutmulen i santulenam di kenen, bay i to gsalig, là samtugad i santulenam di kenen. ");
INSERT INTO bps_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Malmo i banwe ku landè to fulung mebe dun, bay ku nun dee fulung mebe na fulung mngewe, nun ktanak di banwe. ");
INSERT INTO bps_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Nsalam kadang ku makang ge mayad uteng i to laam dilè, fye fa ku là ge makang di kenen. ");
INSERT INTO bps_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","I libun fye ldam, too mgafè, bay i lagi labè, landè mafè kenen, én aloan gwè i knun. ");
INSERT INTO bps_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Ku kamdo ge i demem to, én gafye i ktom, bay ku fansaseam i demem to, fansaseam sa i ktom. ");
INSERT INTO bps_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","I sasè to, landè fye untungan, bay i matlu to, nun fye untung toon gdawat. ");
INSERT INTO bps_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Mlawil i to ku too ndà di nawan mimò i tlu, bay i to too mayè mimò sasè, mlal mati. ");
INSERT INTO bps_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Knang Dwata i dad to sasè fandam, bay én toon kanlehew i dad to mimò matlu. ");
INSERT INTO bps_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","I kaglutan, là galwà i dad to sasè di kaflayam Dwata dale, bay i dad to matlu falwaan. ");
INSERT INTO bps_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Balù tan kafye baweh i libun, bay ku landè kaglabatan i fyenimò, salngad kenen i tising blawen di ilung sdè. ");
INSERT INTO bps_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","I to matlu, én fatanan alò i fye, bay i to sasè, én fatanan alò kalbut Dwata. ");
INSERT INTO bps_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","I to too mlé, too matnù i knunan, bay i to là mayè mlé mbaling kenen landè. ");
INSERT INTO bps_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Nun gufye di to too mlé, du ku tnabengan i dad demen to na lêla kenen tnabeng. ");
INSERT INTO bps_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Mnang nawa dad to i satu to fatan di kagket i btas mse klon fafabli dun, bay dagla i to fadlug fabli. ");
INSERT INTO bps_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Ku too ge mngabal fye, nafè ge, bay ku mngabal ge sasè, sasè sa i teenam. ");
INSERT INTO bps_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","I to smalig di knunan, sasè knean salngad i dad doon mlanas dibang minit, bay i to matlu, fye knean salngad i dad doon mbaling mlunu di bangulen. ");
INSERT INTO bps_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","I to mebe i ksamuk di malayan, di gusenan lana i knunan, na i to là fulung faldam, mbaling kenen fasak di to fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","I bunge i nimò i to matlu, én gamlawil i demen to, bay i klabè, én gafalmo dun. ");
INSERT INTO bps_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","I kaglutan, ku glut nun untung di mgimò i to matlu di tah tanàani, lumban fa nun untung di mgimò i to sasè na i to gamsalà. ");
INSERT INTO bps_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","I to mayè flinge i kngak kenen di gugsalaan mayè gmadè, bay i to là mayè flinge i kngak kenen di gugsalaan laan fulungfaldam. ");
INSERT INTO bps_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Kanlehew Dwata i to fye, bay i to falan fandam i sasè nimoan, nukum kenen Dwata. ");
INSERT INTO bps_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","I to sasè landè gutadagan du sasè nimoan, taman fugen, bay i to matlu nun gutadagan du fye nimoan, taman là kenen fugen. ");
INSERT INTO bps_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Lehew na dag i satu lagi i yaanan fye ldam, bay ku nun libun gafyà i yaanan, salngad kenen i satu tduk di dad tulan i yaanan na gafalmo kenen. ");
INSERT INTO bps_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","I fandam i to matlu gablà di demen to too tlu, bay i to sasè malak i demen to fagu di kafgawan. ");
INSERT INTO bps_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","I talù i dad to sasè gafalmo i demen to, bay i talù i dad to matlu gafalwà i dad to fanla falmo. ");
INSERT INTO bps_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","I dad to sasè mati, na landè tnagakla bella, bay i dad bel i dad to matlu, landè gusenla. ");
INSERT INTO bps_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","I to fulung faldam magdayen, bay i to là matlu fandaman mgadoy. ");
INSERT INTO bps_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Fye fa i to mdanà ku too malgad mimò du fye mto, di to baling tatì flingu kenen bong to, bay mnè kenen di kbitil. ");
INSERT INTO bps_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","I to matlu, too fye kifatan i dad lmanafan, bay i to sasè, too sasè kiboan i dad lmanafan. ");
INSERT INTO bps_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","I to too malgad mimò fule nun lukas i knaanan, bay i to mlalò i dad nimò landè gukmamu, landè kaglabatan. ");
INSERT INTO bps_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","I dad to sasè, én alò kayèla nimò i sasè, bay i dad to matlu, là mgili i kimòla fye. ");
INSERT INTO bps_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","I to sasè mfawel kenen fagu di sasè taluan, bay i to matlu galwà di ksamuk. ");
INSERT INTO bps_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","I to gamdawat i untung fagu di dad gmanan na i dadmgimoan. ");
INSERT INTO bps_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","I to là fulung faldam, fnaglutan slame fye i kdeenimoan, bay i to fulung faldam too flinge i fngewe. ");
INSERT INTO bps_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","I to là fulung faldam, laan gadnan i kaflabean, bay i to nun kaglabat, fbayaan i kafyà kenen. ");
INSERT INTO bps_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","I to tmulen i kaglut di gususay falwaan i kaglut, bay i to tmulen i là glut falwaan i kakakéng. ");
INSERT INTO bps_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","I to i là funa fandam i manan, i manan gamban salngad i kagban i fais, bay i to fulung faldam, i manan salngad i bulung dugafgulê. ");
INSERT INTO bps_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","I kakakéng là sa mlawil du nun gusenan, bay i kaglut mlawil landè gusenan. ");
INSERT INTO bps_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","I to faldam mimò sasè, klimbung i mnè di nawan, bay i to faldam mimò fye, klehew i mnè di nawan. ");
INSERT INTO bps_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Landè sasè mkel di to matlu, bay i to sasè gal nkel i samuk. ");
INSERT INTO bps_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Too knang Dwata i dad to tmulen kakakéng, bay toon kanlehew i dad to tmulen i kaglut na dmohò i manla. ");
INSERT INTO bps_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","I to fulung mebe i kton laan fdag i gnadean, bay i to là fulung faldam balingan fdilè i klandè gnadean fagu ditaluan. ");
INSERT INTO bps_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","I to malgad mimò, kenen mbaling to mebe i nimò, bay i to là mayè mimò, landè fye kel di kenen, bay mimò fagu dileges. ");
INSERT INTO bps_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","I to gal nun ksamuk i nawan landè klehewan, bay fagu di too fye talù i demen to, mbaling matgal i nawan. ");
INSERT INTO bps_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","I to matlu, kenen malak i dad demen sgalak di fye, bay i dalan i to sasè gafasyat dale. ");
INSERT INTO bps_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","I to là mayè mimò, laan gwè i knayean, bay i to malgad mimò, nun kafye gwean. ");
INSERT INTO bps_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","I matlu dalan salu di klawil, bay i bigkò dalan salu di fati. ");
INSERT INTO bps_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","I tingà fulung faldam too mayè flinge i fngewe i maan, bay i tingà madoy too là flinge i kngak kenen. ");
INSERT INTO bps_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","I to gamdawat kenen i fye untung fagu di dad fye gmanan, bay i to gal mgaw, gamdawat i untungan fagu di toon kayè mimòsamuk. ");
INSERT INTO bps_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","I to toon fangeye i dad manan, toon nifat i kton, bay i to talù laan funa fandam i manan, falmon i kton. ");
INSERT INTO bps_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","I to là mayè mimò, too dee knibalan, bay landè kiboan gamwè dun, bay i to too mayè mimò, gamwè balù tan i knayean. ");
INSERT INTO bps_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","I to matlu knangan i là glut, bay i to sasè, sasè na magagyà i nimoan. ");
INSERT INTO bps_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","I to matlu, én kamlung kenen i dad fye nimoan, bay i to gamsalà, én gafalmo kenen i dad sasè nimoan. ");
INSERT INTO bps_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Nun dad to flingu nun knunla balù landè, bay nun dademe dad to flingu landè knunla, balù nun bongknunla. ");
INSERT INTO bps_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","I to nun knun, i knunan gafalwà kenen di agot dad sasè tomantak kenen, bay i to landè, landè to mantak kenen. ");
INSERT INTO bps_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","I dad to matlu, gambet i kalwa too fye knengan, bay i dad to sasè, gambet i salò mudaf i nengan du kagunmati. ");
INSERT INTO bps_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","I to fdatah i kton, landè dademe gukelan ku là samuk, bay i to flinge i fngewe, kenen fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","I knun gwè mdà di mlal kfagu, too mlal sa lana, bay i knun gwè fagu di tu, too lamnok. ");
INSERT INTO bps_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Ku nun fatanam na là gdohò, too gdanà i nawam, bay ku gdohò i knayè nawam, too ge lehew. ");
INSERT INTO bps_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","I to knangan flalò Dwata, én gafalmo kenen, bay i to mlalò i flaloan nun gufyen. ");
INSERT INTO bps_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","I dad tdò i dad fulung faldam gamtabeng ge, gambet yéél mdà disfuten, na ku laloam, gafalwaan ge di ksasè i gamgebe ge di fati. ");
INSERT INTO bps_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","I to nun kaglabat too mgafè, bay i to là gsalig too malima gnagun. ");
INSERT INTO bps_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","I to fulung mebe i kton, funa faldam klon fa mimò, bay i to là fulung faldam, fiten di kdee i klandè kfulungan. ");
INSERT INTO bps_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","I to là gsalig dek ftulen i tulen, mlé sa i ksamuk, bay i to gsalig dek ftulen i tulen, én mlé ktanak. ");
INSERT INTO bps_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","I to là mayè flinge i fngewe kenen, kalima na kyà i mkel dikenen, bay i to flinge i kngak kenen, nafè i dad to. ");
INSERT INTO bps_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Ku gdohò i knayè nawam, too ge lehew, na dad to là fulung faldam là mayè tmagak i sasè. ");
INSERT INTO bps_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","I to sgalak i dad to fulung faldam, kenen mbaling fulung faldam, bay i to sgalak i dad to là fulung faldam nun kalmon. ");
INSERT INTO bps_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","I samuk samlalò i dad to gamsalà, bay i kafye, én samlalò i dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","I to fye, nun knunan tnagakan di dad ngà i dad ngaan, bay i knun i to gamsalà, gfun i dad to matlu kadang di satu duh. ");
INSERT INTO bps_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","I tanà là magligo, ku magligo na fanla, gamlé gablà knaan i dadto landè, bay dad to là matlu, làla faloh fafla. ");
INSERT INTO bps_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","I to là mlayam i tingaan di gugsalaan du fye matdò, landè kakdoni tingaan, bay i to nun kakdon i tingaan, fanlayaman du fye matdò kenen. ");
INSERT INTO bps_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","I dad to matlu, too gablà i knaanla, bay là tlag i kbitil i dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","I libun fulung faldam, too fye kifatan i malayan, taman toofye knèla, bay i libun là fulung faldam, falmon i malayan. ");
INSERT INTO bps_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","I to mimò matlu, nun klikoan di Dwata, bay i to gal mgaw toon fite landè klikoan di Dwata. ");
INSERT INTO bps_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","I kafdag i to là fulung faldam, gambet i bunalan i demen to nabalù kenen kto, bay i dad gman i to fulung faldam, én i klungan. ");
INSERT INTO bps_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Ku landè lmanaf damyol i daru, landè lam i lawigam, bay fagu di tabeng i lmanaf bong i kantum. ");
INSERT INTO bps_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","I to gsalig tmulen di gususay too tmulen i kaglut, bay i to là gsalig alò tmulen kakakéng. ");
INSERT INTO bps_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","I to gal madoy, mngabal i kfulung, bay landè teenan, bay i to nun kaglabatan, mlal kenen gambet. ");
INSERT INTO bps_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Fawag ge di to là fulung faldam, du landè fye gagbetam di kenen. ");
INSERT INTO bps_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","I kfulung i to fulung mebe i kton, gmadè sa kenen ku tan inimoan, bay i to là fulung faldam, én fandaman gmadè kenen ku tan inimoan, bay fangawan i kton. ");
INSERT INTO bps_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","I dad to là fulung faldam ku gamsalà tatì landè di dale, bay i dad to fye, mngabal ale kfagu klifet i dad salà. ");
INSERT INTO bps_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Landè to fakay too magin ge di sasè klidù nawam, na landè to fakay too magin ge di too klehew nawam. ");
INSERT INTO bps_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","I gumnè i to fye, sana ktadagan, balù tamlo nan malbà gumnè i to sasè. ");
INSERT INTO bps_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Nun dalan fandam i to too matlu, bay gusen i dalan ani di fati. ");
INSERT INTO bps_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","I klidù i to fakay bunin fagu di ulén, bay kafngen mulé déén fa i kliduan di nawan. ");
INSERT INTO bps_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","I to kmagol i fye nimò too gamdawat i balas di sasè mgimoan, bay i to mimò fye, mdà di fye mgimoan, nun kafye gdawatan. ");
INSERT INTO bps_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","I to kulang i kfulungan faldam, fnaglutan balù tan i lingen, bay i to fulung mebe i kton, toon fanlinge ku nun kaglutan. ");
INSERT INTO bps_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","I to fulung faldam, nun klikoan di Dwata na fawag di ksamuk, bay i to là fulung faldam, tatì mimò na là fgeye na sasè igukelan. ");
INSERT INTO bps_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","I to mlal malbut mlal gsalà, na knang i dad to i to mgaw i demen to. ");
INSERT INTO bps_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","I dad to kulang i kfulungla faldam, gamdawat i balas di klandèkfulungla, bay i dad to fulung mebe i ktola, matnù i gnadèla. ");
INSERT INTO bps_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Satu duh, i dad to sasè, lkuad di muna i dad to matlu, du fdanà ale na too ale fakdo mni tabeng. ");
INSERT INTO bps_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","I to landè, knang i dad to balù fa i demen saldan, bay i to nun bong knun, too dee samgalak kenen. ");
INSERT INTO bps_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Na balù simto mnang i to landè, gamsalà kenen, bay ku simto kamdo kenen nun kafyen. ");
INSERT INTO bps_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Ku falam fandam kimò sasè gsalà ge, bay ku falam fandam kimò fye nun dad to kamdo ge na smalig ge. ");
INSERT INTO bps_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Ku too ge mimò nun fye kneam, bay ku én nimoam alò tì stulen, mbaling ge to landè. ");
INSERT INTO bps_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","I to fulung faldam, i untungan dunan i kfulungan, bay i to là fulung faldam, i untungan dunan i klandè kfulungan. ");
INSERT INTO bps_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Ku i to tmulen i kaglut di gumusay, gafalwà kenen dee to difati, bay ku i to tmulen kéng dee to nangkalan. ");
INSERT INTO bps_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","I klikò di Dwata gamlé di to ksalig, na kamlung i dad ngaan. ");
INSERT INTO bps_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","I klikò di Dwata gamtabeng ge, gambet yéél mdà di sfuten, na gafalwaan ge di ksasè gamgebe ge di fati. ");
INSERT INTO bps_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","I eneg i satu harì fdu sa di nun dee dad ton, bay ku landè dad ton, landè sa enegan. ");
INSERT INTO bps_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","I to là mlal falbut, nun bong kaglabatan, bay i to mlal falbut, fdilean i klandè kaglabatan. ");
INSERT INTO bps_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","I to nun ktanak i nawan, én gafye i lawehan du gafgulê, bay i to nun kingà nawan, én gamsasè i lawehan du falmon. ");
INSERT INTO bps_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Ku bankutam i to landè, knangam Dwata i mimò kenen, bay ku tnabengam i to landè, mafè ge Dwata. ");
INSERT INTO bps_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","I falmo i to sasè i sasè nimoan, bay i kamlung i to matlu i kafyen. ");
INSERT INTO bps_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Nun kfulung mnè di nawa i to nun kaglabat, bay i to là fulung faldam, landè gnadean gablà di kfulung. ");
INSERT INTO bps_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","I katlu nimò i dad to, én fdatah i banwela, bay i ksasè nimò i dad to, én gafyà i banwela. ");
INSERT INTO bps_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Too lehew i harì i saligan fulung faldam, bay fanlayaman i saligan mimò magagyà nimò. ");
INSERT INTO bps_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","I mafganag timel gaflana i kaflabè, bay i makto timel i gafdinè dun. ");
INSERT INTO bps_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Ku nun man i to fulung faldam, too kayè i dademe ganbet, bay ku nun man i to là fulung faldam, landè gukmamu dun. ");
INSERT INTO bps_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","I kdee mgimò di klamang banwe teen Dwata, teenan i kdee nimoito balù fye ku demen sasè. ");
INSERT INTO bps_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","I fye talù gamlé klawil na ktanak nawa i dad to, bay i sasè talù gamlé tduk di nawa i dad to. ");
INSERT INTO bps_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","I to là fulung faldam là mayè flinge i tdò i maan, bay i to dmawat i kngak i maan, fiten i kfulungan mebe i kton. ");
INSERT INTO bps_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","I knun i to matlu là lana di kenen, bay i knun i to sasè tatì lana di kakel i kalima. ");
INSERT INTO bps_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","I kbel i gnadè fagu di to fulung faldam, ise ku fagu di to là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","I dsù blé i to sasè knang Dwata, bay i dasal i to matlu kanlehewan. ");
INSERT INTO bps_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","I nimò i to sasè knang Dwata, bay kanbongan nawa i to mimò i matlu. ");
INSERT INTO bps_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Ku gasyat i to di fye dalan, too blat i kaflayaman, na mati i to ku laan dmawat i kngak kenen di gugsalaan. ");
INSERT INTO bps_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Du gadè Dwata i kdee gablà di gumnè i dad mati, lumban fa kgadean i kdee gablà di nawa i dad to. ");
INSERT INTO bps_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","I to madoy là mayè ku nun mngak kenen, na là mayè mni fngewe di to fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","I to lehew, teenam i klehewan di bawehan, bay i to mlidù, teenam i klidù nawan di bawehan. ");
INSERT INTO bps_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","I to nun kaglabatan mayè gambet, bay i to là fulung faldam fnò i nawan i klandè kfulungan. ");
INSERT INTO bps_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","I knè i to mdanà too malima, bay i to nun klehew, too lehew i knean. ");
INSERT INTO bps_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Fye fa i to tukay knunan ku nun klikoan di Dwata, di to nun bong knunan i nun ksamuk. ");
INSERT INTO bps_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Fye fa ku tatì ge alò kmaan i gulay dmeme i demem sakdo, di kmaan ge i too fye nem uten, bay nun kasnang nawa. ");
INSERT INTO bps_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","I to mlal malbut kenen gumdà i ksugak, bay i to là mlal malbut fakay smafye i dad to sugak. ");
INSERT INTO bps_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","I to là mayè mimò, balù tanè, nun dad sual gablabal i dalanan, bay i to matlu landè gablabal i dalanan. ");
INSERT INTO bps_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","I tingà fulung faldam gaflehew i maan, bay i tingà là fulung faldam knangan i yéan. ");
INSERT INTO bps_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","I to landè kaglabatan toon sa kanlehew i sasè nimoan, bay i to nun kaglabatan, toon nimò i matlu nimò. ");
INSERT INTO bps_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","I tafandam i to là gdohò ku kulang i dad to mngewe, bay too gdohò fagu di dee dad to mngewe kenen. ");
INSERT INTO bps_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Lehew i to ku fye i ktimelan di bangan tmimel dun. ");
INSERT INTO bps_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","I to fulung faldam, mlalò i dalan salu di nawa landè sen, là mlalò i dalan salu di fati. ");
INSERT INTO bps_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Lanbà Dwata i gumnè i to fdatah, bay nifatan i tanà i libun balu. ");
INSERT INTO bps_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Knang Dwata i fandam i dad to sasè, bay kanlehewan i talù dad to mlaneb i nawala. ");
INSERT INTO bps_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","I to mlimbung fakufan sa i malayan di ksamuk, bay i to là dmawat i blé du fye msen di sasè, mlawil kenen. ");
INSERT INTO bps_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","I to matlu funan too faldam di laan fa tmimel, bay i to sasè mlal timelan, bay sasè i manan. ");
INSERT INTO bps_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","I dasal i to matlu too fanlinge Dwata, bay mawag Dwata di to sasè. ");
INSERT INTO bps_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Ku lehew i satu to, ge baling too lehew, na i fye tulen too gafgulê ge. ");
INSERT INTO bps_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Ku flinge i satu to i kngak kenen, mbaling kenen satu di dad to fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Ku i to là mayè fatdò, fanlayaman i kton, bay ku fanlingen i kngak kenen, matnù i kfulungan. ");
INSERT INTO bps_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","I klikò di Dwata, én gamlé di to i kfulung faldam, na silang nun mafè i to ku funan fdanà i kton. ");
INSERT INTO bps_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Fakay sa di to ku funan fandam i fanan nimò, bay mdà sa di knayè Dwata ku dnohoan ku là. ");
INSERT INTO bps_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Kdee nimò i to fandaman too fye, bay Dwata i mukum i knayè nawa i to, na i duenan mimò dun. ");
INSERT INTO bps_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Saligam di Dwata i kdee nimoam, na i kdee fandamam nimò, du fye gdohò. ");
INSERT INTO bps_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Nun tafandam Dwata gufkelan i kdee mgimoan, na balù i dad to sasè nun gukella dunan i kalmola. ");
INSERT INTO bps_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Too knang Dwata i kdee dad to fdatah, na i kaglutan, toon ale fanlayam. ");
INSERT INTO bps_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Ku ge satu to too gsalig Dwata, na nun kakdom kenen, nlifetan isalaam, na ku nun klikoam di Dwata niwasam i sasè. ");
INSERT INTO bps_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Di kimò i to i nimò gaflehew Dwata, én i smafye kenen di dad to balù dad dmuen kenen. ");
INSERT INTO bps_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Fye fa ku tukay knunam, syan fagu di matlu i kagweam dun, di bong knunam, bay gweam fagu di klimbung. ");
INSERT INTO bps_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","I to fakay faldam ku tan i fanan nimò, bay Dwata alò fakay malak kenen di kimoan dun. ");
INSERT INTO bps_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","I glal i harì mdà di Dwata, taman i kukuman mbaling matlu. ");
INSERT INTO bps_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Ani kayè Dwata di dad to fabli, ku là mlimbung i timbangla, na too matlu i kafablila. ");
INSERT INTO bps_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Knang i dad harì i sasè nimò, du én gutadag i kagotla i matlu nimò. ");
INSERT INTO bps_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","I dad harì mayè ale flinge i kaglut, na knabasla i to tmulen i kaglut. ");
INSERT INTO bps_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","I to fulung faldam, too fgal flehew i harì, du ku malbut i harì ken nun fafatin. ");
INSERT INTO bps_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Kabay ku lehew i harì, mlé kenen i kafye di dad to gaflehewkenen, salngad i ulen mlé fye di dad fule. ");
INSERT INTO bps_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Fye fa ku nun kfulungam faldam di nun blawenam, na fye fa ku nun kaglabatam di nun salafiam. ");
INSERT INTO bps_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","I to fye mlalò i dalan mawag di ksasè, na i to too fgeye ku tanè i gusalun, landè gaslokan. ");
INSERT INTO bps_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","I bunge i kafdatah na kafdag dunan kalmo. ");
INSERT INTO bps_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Fye fa i to ku fdanaan i nawan na fadlug di klandean, di gakuf kenen di dad to fdatah na nun alelan di dad tnakula. ");
INSERT INTO bps_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","I to too flinge i tdò kenen, nun gufyen, na nun kafye di to too smalig di Dwata. ");
INSERT INTO bps_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","I to fulung faldam dnagit to nun kaglabat, na i kafye taluan, én gmagan mebe i dad to. ");
INSERT INTO bps_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","I kfulung i to fulung faldam, én gafye na gatgal i nawan, bay i to là fulung faldam, landè gukmamu i katdò kenen. ");
INSERT INTO bps_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","I to fulung faldam, too funa faldam di laan fa talù, taman i taluan too fnaglut i demen to. ");
INSERT INTO bps_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","I fye talù, salngad i tnab too mi i neman, na gafye i laweh. ");
INSERT INTO bps_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Nun dalan fandam i to too matlu, bay i gusen i dalan ani di fati. ");
INSERT INTO bps_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","I to mimò mdà di kbitilan too fgal mimò, du kayean gamkaan. ");
INSERT INTO bps_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","I to sasè i landè gukmamu, galan neye i dalan kiboan fsasè idemen to, na i taluan too gafalmo, gambet i lifoh. ");
INSERT INTO bps_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","I to sasè, gal mbel i kastulen, na i kalsalékan gamgimò samuk na samkah i dad to sgalak. ");
INSERT INTO bps_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","I to labè, mgaw i demen sgalak, na malak kenen di sasè dalan. ");
INSERT INTO bps_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Fgeye ge i dad to flingu fye, fagu di kibòla meye di ge, du én dalanla fan mimò sasè. ");
INSERT INTO bps_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","I klawil, én untung i to matlu i nimoan, na i uben di wakan i gumgafean. ");
INSERT INTO bps_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Fye fa i to là mlal malbut di to nun bong enegan, na fye fa i to gmagan damnan i kton di to magot i syudad. ");
INSERT INTO bps_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Fakay dee nimò i dad to, du fye gadèla knayè Dwata, bay Dwata alò fakay dmohò i gukelan. ");
INSERT INTO bps_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Fye fa ku kmaan ge balù tan i tukay gdè knaan, syan nun ktanak di gumneam, di kmaan ge di bong fista di gumnè i nun ksamuk. ");
INSERT INTO bps_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","I salig fulung faldam, kenen kadang magot tingà i amun i landègukmamu, na nun kadang alelan di knun tagak i amun di dad ngaan di kfatin. ");
INSERT INTO bps_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","I to tmilew i blawen na salafì di lifoh, bay Dwata tnandakan nawa i to. ");
INSERT INTO bps_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","I to sasè, bayan flinge i dad sasè talù, na i to tmulen kéng, bayan flinge i talù gafalmo. ");
INSERT INTO bps_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","I to madoy i dad to landè, salngad nadoyan Dwata i mimò dale, na i to lehew di sasè gaslok i demen to, nun kaflayaman. ");
INSERT INTO bps_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","I dad tua mdag i dad fùla, na salngad i dad ngà du mdag ale i dad tuala. ");
INSERT INTO bps_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","I kafye talù là blà di to là fulung faldam, lumban i ktulen kéng là fakay blà i ulu di dad to. ");
INSERT INTO bps_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Én fandam i dademe to, ku mlé filak di gugbuni salngad i satuimò, du balù simto gumléla dun, gwèla i knayèla. ");
INSERT INTO bps_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Ku mayè i to too kando i dad to, nlifetan i dad salàla di kenen, bay ku galan sansulit man i salà i demen to, én gaskah i dadsgalak. ");
INSERT INTO bps_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","I to nun kaglabat, too mlal tdò balù fa alò fagu di sulê kngakkenen, di to i là fulung faldam, balù fa tamaskél mlatu dulê. ");
INSERT INTO bps_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","I to sasè gal mlét i dad to di banwe, taman nun ganlal i landè kakdo salu di kenen na bnalas i sasènimoan. ");
INSERT INTO bps_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Fye fa ku gamsitong ge i labè lmanaf béar tnaku i dad ngaan, di gamsitong ge i to là fulung faldam, di kimoan sasè i landègukmamu. ");
INSERT INTO bps_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Ku sasè baling balasam i fye, too là tlag i sasè di gumneam. ");
INSERT INTO bps_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","I katbù i ksugak, salngad kaloh yéél matbe di ksangam dun, taman fanlalam tanlag di là fa tambù, du fye là mbaling bong. ");
INSERT INTO bps_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","I to gal mukum falwà i to gamsalà, du fye là maflayam, nafanlayaman i to landè salà, i nimoan ani slame knang Dwata. ");
INSERT INTO bps_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","I to là fulung faldam, là mayè fulung, taman landè lubay fagbet kenen, du tatì falmo filak. ");
INSERT INTO bps_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","I dad to sgalak, toola fite i kasakdola, na landè gukmamu i kasaflanek ku là ale stabeng di bang nunkaflayam. ");
INSERT INTO bps_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","I to kulang kaglabat, makang kenen mayad dad uteng i demen to. ");
INSERT INTO bps_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","I to mayè sugak, mayè gamsalà, na i to too fdag, mayè ku malmo. ");
INSERT INTO bps_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","I to faldam sasè, landè fye fatanan, na i to talù sasè, sasè gukelan. ");
INSERT INTO bps_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","I tingà là fulung faldam, alò mlé klidù nawa i maan, na landè klehew i maan di tingaan là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","I klehew nawa, gafye i laweh, na i klidù nawa, gafsasè i laweh. ");
INSERT INTO bps_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","I to sasè i gal mukum i usay dmawat filak di gugbuni, na msang i kaglut. ");
INSERT INTO bps_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","I to nun kaglabat, kayean ku i kdee nimoan fagu di fye kfagu, bay i to là fulung faldam, sbalét i fandaman. ");
INSERT INTO bps_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","I tingà là fulung faldam, mlé klidù nawa di maan, na mlé ksal di yéan i fsut kenen. ");
INSERT INTO bps_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Là sa fye ku fanlayam i to landè salà, na là sa fye ku fanlayam i to fye na mgafè. ");
INSERT INTO bps_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","I to nun gnadè, toon funa fandam ku tan i manan, na i to nun kaglabat, là sukaf i nawan. ");
INSERT INTO bps_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Balù i to là fulung faldam ku tatì fanak na là talù, én fandam i dademe nun kfulungan na kaglabatan. ");
INSERT INTO bps_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","I to ku én alò fandaman gufye i kenen kto, laan magin di balù tan i fye fandam i dademe. ");
INSERT INTO bps_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","I to là fulung faldam, laan mayè gamlabat, bay aloan kayè fdag i gnadean. ");
INSERT INTO bps_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Ku gamsalà i satu to, nun knang na kadoy kenen, na ku malmo dengeg i satu to, alò kyà samnagin kenen. ");
INSERT INTO bps_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","I dad gman i to fulung faldam gumwè i dademe kfulungla, na too mngalam gambet i mahin, na too fye gambet kaloh i yéél. ");
INSERT INTO bps_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Là sa fye ku i to gal mukum msen di to nun salà, na là fakay ku laan banlé kagalwà i to landè salà. ");
INSERT INTO bps_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","I talù i to là fulung faldam, én gutambù i ksugak, na tatian mimò i tdukan. ");
INSERT INTO bps_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","I gafalmo i to là fulung faldam, dunan i dad galan gman, na mfawel sa mdà di kenen dad talù. ");
INSERT INTO bps_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","I kastugad salék too kanbayan fanlinge i dad to, di dale salngad knaan too fye i neman na too fye nawala mlo dun. ");
INSERT INTO bps_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","I to malwe mimò, salngad ksasè i to gal falmo. ");
INSERT INTO bps_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Dwata salngad i bong mgal gumnè i gal gumila i dad to matlu, du fye giwas ale di sasè. ");
INSERT INTO bps_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","I dad to nun knun, fandamla i knunla kamlung dale, salngad kaklung i bong mdatah labat batu glibut i syudad. ");
INSERT INTO bps_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","I to fdatah, falmon i kton, bay i to fdanaan i kton, too mgafè. ");
INSERT INTO bps_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","I to là funa flinge klon tmimel, kenen i to là fulung faldam na nimoan i gumyaan. ");
INSERT INTO bps_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","I to fangalan i nawan di bang i nun fdasan, ani i dalanantmabeng i kton, du fye mto, bay i to flungay i nawan di nun fdasan, landè imen nawan ku mto fakenen. ");
INSERT INTO bps_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","I to nun kaglabat too mayè ku matnù i gnadean, na i to fulung faldam too flinge, du fye matnù i gnadean. ");
INSERT INTO bps_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Ku mayè ge smite i satu bong to, mebe ge i blém kenen, fye mlal site. ");
INSERT INTO bps_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","I to muna talù di usay, fnaglutam glut i gmanan di là fa snalek i to demen susay. ");
INSERT INTO bps_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Ku nun lwe mdatah to i masbalà di usay, na malima musay, fakay sulat i dagitla na kanligong, na simto dagit i muna lamwà, kenen mgalék i nun kaglut, na anigmagan musay dale. ");
INSERT INTO bps_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","I flanekam tafatdukam i nawan, too malima samfulê di fye i nawange, na ku nugakam fa, én too gablabal di kasafyeyu. ");
INSERT INTO bps_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Ku tan gukel i kdee man i satu to, alò kenen sa tmimel dun. ");
INSERT INTO bps_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","I dad gman i satu to, én gafalwà i kton ku demen gafalmo i kton, taman là fakay ku laan tnimel ku tan gukel i dad manan. ");
INSERT INTO bps_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","I lagi ku tamite i fye yaan, teenan i kafye, du i kafye teenan tablé Dwata di kenen. ");
INSERT INTO bps_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Ku talù i to landè, too kenen fakdo talù, bay ku talù i to nun knun, too gamban i taluan. ");
INSERT INTO bps_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Nun dad dademe sgalak alò flingu nun kakdola, bay nun to samgalak i too kamdo i demen sgalak, mdatah fa di tooflanekan. ");
INSERT INTO bps_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Fye fa i to ku landè na matlu nimoan, di to là fulung faldam na tmulen kéng. ");
INSERT INTO bps_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Là sa fye ku nun nimoam na laam gadè dun, demen ku fnaflalam mimò na baling ge gsalà. ");
INSERT INTO bps_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Nun dad to falmola i ktola fagu di dad sasè nimòla, kafnge én, banléla salà Dwata. ");
INSERT INTO bps_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","I to nun knun, too dee demen sgalak, bay i to landè, tatì tnagak i demen sgalak. ");
INSERT INTO bps_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Ku là glut i ktulen i to tmulen di gususay, fanlayam kenen, na là galwà i to tmulen kéng. ");
INSERT INTO bps_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","I kdee to too mngabal i kfagu gaflehew nawa i mdatah to, na kdee to mayè samgalak i to gal mlé. ");
INSERT INTO bps_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Balù dad flanek i to landè là fduf kenen, labi fa kfawag i dad demen sgalak di kenen. Na balù toon fangal fakdo di dale, là ale fdadong di kenen. ");
INSERT INTO bps_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","I satu to ku fulung faldam magtabengan i kton, na ku toon fkah di nawan i kaglabatan nun gufyen. ");
INSERT INTO bps_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Ku là glut i ktulen i to tmulen di gususay, fanlayam kenen, na malmo i to tmulen kéng. ");
INSERT INTO bps_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","I kafye knè là blà i to là fulung faldam, na i to salig, là gablà ku kenen mdek i amun. ");
INSERT INTO bps_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","I to fulung faldam gadnanan i klabean, na ku nun gamsalà di kenen, ku tatian fbayà, na dnayen kenen i dadto. ");
INSERT INTO bps_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","I kaflabè i harì gaflikò salngad i bong ngal i lmanaf liyun, bay i kakdon too fye salngad i ulen tatì sanfatan. ");
INSERT INTO bps_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","I tingà là fulung faldam, gafalmo i maan, na i libun too mugak i yaanan too sasè fanlinge, salngad uni yééllà tlag tamdak. ");
INSERT INTO bps_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","I to gamfun i gumnè na filak mdà di dad tuan, bay alò Dwata i gmagan mlé kenen i yaan fulung mebe i kton. ");
INSERT INTO bps_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","I to malwe mimò tatì fadlug kudang, na i gukelan bitil. ");
INSERT INTO bps_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","I to mimen dad flalò Dwata, mlawil kenen, bay i to mnang i flaloan, mati kenen. ");
INSERT INTO bps_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","I to kamdo i to landè, salngad ku mlé kenen di Dwata, na Dwata malas kenen. ");
INSERT INTO bps_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Fanlayamam i tingaam di gugsalaan di muhad fa i nawan diklom fa fakay tamdò kenen, du ku laam nimò ani, baling ge sa tmabeng kenen falmo ikton. ");
INSERT INTO bps_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Én nimoam di to mlal malbut tatiam fbayà, fye kenen tmimelku tan i gukelan, du ku tnabengam kenen sulê, kamnalam kenen na là ge tlagtmabeng kenen. ");
INSERT INTO bps_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Flinge ge i fngewe na dnawatam i tdò ge, du fye kadang ge mbaling to fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Nun dee fala fandam i to ku tan i fanan nimò, bay knayè Dwata, én gdohò. ");
INSERT INTO bps_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Kayè i to ku nun kamdo kenen landè gusenan, na fye fa i to ku landè knunan, di to tmulen kakakéng. ");
INSERT INTO bps_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","I to nun klikoan di Dwata mlawil kenen, na nun ktanak nawan, na gawag kenen di ksasè. ");
INSERT INTO bps_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","I to là mayè mimò, balù fa smungit i knaan là mayè. ");
INSERT INTO bps_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Là fakay ku là fanlayam i to madoy, du fye matdò i to kulang ikfulungan faldam, fye fulung kenen mebe i kton, bay i to nun kaglabat, balù alò nngak, matnù i kaglabatan. ");
INSERT INTO bps_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","I tingà mimò sasè di maan na mdal i yéan di gumnean, too sasè na fyaan i dad tuan. ");
INSERT INTO bps_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Tingàgu, ku tanlagam i kagbetam, là mlo gasyat ge di tagadeam. ");
INSERT INTO bps_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","I to tmulen kéng di gumusay tatìan nadoy i matlu, na i to sasè, too mayè mimò sasè. ");
INSERT INTO bps_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","I to madoy, too fanlayam, na sankél i to là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","I ninum gamlangal, én gumdà i to madoy na saglà, na balù simto mgikat di kinuman, én i to là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","I kaflabè i harì gamlikò, salngad i bong ngal i lmanaf liyun, na ku faflabeam kenen, salngad ku tafafatim i ktom. ");
INSERT INTO bps_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","I to là makuf di ksugak, mgafè kenen, bay i to too mayè sugak, kenen i to là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","I to malwe mimò, i là mayè dmaru di bang kdaru, landè gwean di bang i kaktu. ");
INSERT INTO bps_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","I dad fandam i satu to too mngalam, gambet i too mngalam yéél, bay i to nun kaglabat, glabatan dad fandam i to mngalam fandamani, na kenen gmagan fafalwà dun. ");
INSERT INTO bps_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Dee dad to dagla i ktola, ale kun too kamdo na too gsalig, bay i kaglutan, too malima mite i to too glut gsalig. ");
INSERT INTO bps_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","I to matlu nun katlu i nimoan, na nun kafye gdawat i dad ngaan. ");
INSERT INTO bps_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Di ksudeng i harì di gumukuman, dilean sa i ksasè nukuman. ");
INSERT INTO bps_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Simto to fakayan man too mlaneb i fandaman na landè salaan? ");
INSERT INTO bps_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Knang Dwata i dad to tmimbang di timbang mlimbung, na masad di mlimbung gumasad. ");
INSERT INTO bps_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Balù i tingà dileam ku tan i ldaman fagu di dad mgimoan, ku gal mimò fye na matlu. ");
INSERT INTO bps_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Dwata mlé gito klinge, du fye flingeito, na mata, du fye neyeito. ");
INSERT INTO bps_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Ku tatì ge fadlug kudang mbaling ge to landè, taman too ge falgad, fye nun lukas knaanam. ");
INSERT INTO bps_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","I dad to mayad gal mugak gablà di kabtas i dad fabli, bay di kulêla dagla, du mdanà i kagwèla dun. ");
INSERT INTO bps_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Blawen na dad mabtas batu too mabtas, bay mdatah fa kabtas i gman i dad to nun gnadè. ");
INSERT INTO bps_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Ku nun to makang kenen mayad uteng i to laan gadè, fye ku nleges kenen smandà i knunan, kel di kagbayadan i utengan. ");
INSERT INTO bps_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","I to gamwè fagu di klimbung too lehew, salngad i klehew dikagneman i too fye knaan, bay i gukelan sasè, salngad ksasè i baan too fnò falak. ");
INSERT INTO bps_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Ku nun fandamam i fanam nimò, mni ge funa i fye fngewe, na ku fan ge salu di gusfati, mni ge funa i fye fngewe. ");
INSERT INTO bps_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","I to samtugad salék là gsalig, du fgadean i dad buni, taman fawag ge di to too mayè samtugad salék. ");
INSERT INTO bps_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","I to fanlagin i maan demen i yéan, fnati salngad i salò fnati di kifu. ");
INSERT INTO bps_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","I knun tatì gtagak di ge na gwè fagu di sasè kfagu, landè fye gweam déén kel di atuan. ");
INSERT INTO bps_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Nang ge makang malas i sasè mgimò di ge, bay baling ge smalig di Dwata, du kenen falwà ge. ");
INSERT INTO bps_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Knang Dwata na laan kanlehew i dad to tmimbang di timbang mlimbung. ");
INSERT INTO bps_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Dwata tagnè gmadè i gumagu i satu to, bay landè kibò i satu to gmadè i gumagun. ");
INSERT INTO bps_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Sasè ku laam too funa fandam di là ge fa makang ku nun blémdi Dwata, du ken laam dnohò dun. ");
INSERT INTO bps_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","I harì fulung faldam dmilè ku simto i dad to mimò sasè, na fanlayaman ale di landè kakdo. ");
INSERT INTO bps_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Tabanlé ito Dwata i fandam na kgadè i fye, taman landè gbuni di kenen. ");
INSERT INTO bps_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","I harì too mlawil i glalan ku neben i kagotan digumatlu, na ku kandon i kdee na landè fnalabin. ");
INSERT INTO bps_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","I dad lamnok to, too dag i dad to i kgalla, bay i dad tua to, too nafè i dad to. ");
INSERT INTO bps_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","I kaflayam fakay gamlaneb nawa i sasè to, du fagu di kaflayaman, numanan i nawan. ");
INSERT INTO bps_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Dwata malak fandam i harì, nalakan fagu di knayean, salngad kalakan i kaloh yéél. ");
INSERT INTO bps_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Kdee nimò i satu to di fandaman too fye, bay Dwata mukum ku tan i knayè nawa i to na i duenan mimò dun. ");
INSERT INTO bps_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Mabtas fa di Dwata i kimò fye na matlu di nun dsuam di kenen. ");
INSERT INTO bps_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","I dad to sasè, én mebe dale i kafdatahla na i kafdagla, na ani i gafsalà dale. ");
INSERT INTO bps_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","I to funan too fanse faldam ku tan i fanan nimò nun bonguntungan di nimoan, bay ku tatì kalyakan mimò, landè gwean. ");
INSERT INTO bps_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","I knun gwè fagu di klimbung tatì mlal lana na gamgebe i to di fati. ");
INSERT INTO bps_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","I dad to labè, malmo fagu di dale ksasè, du là ale sa mayè mimò i matlu nimò. ");
INSERT INTO bps_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Là matlu i dalan gumlalò i dad to nun salà, bay i dalan gumlalò i dad to fye ldam, too matlu. ");
INSERT INTO bps_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Fye fa ku i lagi nun yaan mnè di too tukay lawig di satnù di gumnè i yaanan mayè mugak. ");
INSERT INTO bps_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","I to sasè, toon knayè mimò sasè, na landè kakdon i demen to. ");
INSERT INTO bps_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Fagu di kaflayam i to madoy, én tamdò i to kulang i kfulunganfaldam, na di katdò i to fulung faldam, too matnù i gnadean. ");
INSERT INTO bps_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Dwata kenen too matlu, gadean i nimò i dad to sasè di lam igumnèla, na kenen sa i falmo dale. ");
INSERT INTO bps_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Ku nun to là flinge i kafakdo i dad to landè, kadang di satu duh, ku kenen i fakdo landè flinge kenen. ");
INSERT INTO bps_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Ku flabè i ganlal, magwè i kaflabean ku nun blé di kenen di gugbuni. ");
INSERT INTO bps_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Too lehew i dad to matlu di fye kukum, bay di dad to sasè, too sasè i fandamla dun, du gafalmo dale. ");
INSERT INTO bps_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","I to talà mlalò i dalan kaglabat, én gukelan kadang di gumnè i dad mati. ");
INSERT INTO bps_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","I to too mayè mimò i knayean i alò gaflehew kenen, mbalingkenen to landè, na i to too mayè minum i dad gamlangal na kmaan i dad toomabtas knaan, laan mbaling to nun bong knun. ");
INSERT INTO bps_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","I dad to sasè, maflayam ale fagu di knayèla mimò sasè di dadto matlu, du magbalas sa di sasè i nimòla. ");
INSERT INTO bps_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Fye fa i lagi nun yaan mnè di banwe landè to, di satnù i yaanan sukaf nawan na too mayè mugak. ");
INSERT INTO bps_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Di gumnè i to fulung faldam nun mabtas kandeen na fye nemknaan, bay i to là fulung faldam, too mlal i kafalmon i kdeeknunan. ");
INSERT INTO bps_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Ku kamdo ge i demem to na mimò ge i matlu nimò, mlawil ge, matlu ge, na nafè ge i dad to. ");
INSERT INTO bps_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","I to fulung faldam, gmagan mlad i satu syudad nsen i dad tonun kgal, na gmagan lambà i mgal labat batu i snaligla glibut isyudad. ");
INSERT INTO bps_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","I to là mayè gakuf di samuk, toon fangeye i manan. ");
INSERT INTO bps_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","I to fdatah na fdag i kton, nadoyan i demen to, na taalì i kafdagan. ");
INSERT INTO bps_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","I to là mayè mimò, too dee knibalan na i knibalan ani, én igamfati kenen, du là mayè mimò. ");
INSERT INTO bps_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Na i to là mayè mimò, tayud i duh aloan fandam i knibalan, bay i to matlu, fandaman i dademen to, du too kenen mayè mlé. ");
INSERT INTO bps_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","I dsù blé i to sasè, knang Dwata, lumban ku blén fagu di sasè knayè i nawan. ");
INSERT INTO bps_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","I to tmulen kéng di gususay, malmo kenen, bay i to fulung flinge na tmulen i kaglut, ssfanlinge i dad to i manan. ");
INSERT INTO bps_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","I to matlu, nun ksaligan i kton kenen matlu, bay i to sasè, alò tatì flingu kenen matlu. ");
INSERT INTO bps_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Balù nun kfulung i to na nun kaglabatan na nun fye kafngewen, bay ku knang kenen Dwata, i kdee ani là gamtabeng kenen. ");
INSERT INTO bps_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","I to fakayan fnatlagad i dad kudà nebe di kasfati, bay Dwata sa alò mlé i katu. ");
INSERT INTO bps_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Fye fa ku fye dengeg i satu to, di nun bong knunan, na i kafye dengegan mabtas fa di salafì na blawen. ");
INSERT INTO bps_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Nun gusalngad i dad to nun knun na i dad to landè, du slame Dwata mimò dale. ");
INSERT INTO bps_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","I to fulung mebe i kton, tagadean i samuk fan kel, taman funanniwas, bay i to kulang i kfulungan faldam, laan niwas i samuk, 2 tatì fadlug kel di kagdawatan i flayam bunge i nimoan. ");
INSERT INTO bps_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Ku nun klikoam di Dwata, na fdanaam i ktom di kenen, mlé kenen i dad knun, dengeg, na klawil. ");
INSERT INTO bps_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","I to kmabas i kton, fawag di dalan nun fawel, i fawel i dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Tdoam i tingà ku tan kiboan mebe i kton, du fye di ktuan laan glifet dun, klon mnè di tah tanà ani. ");
INSERT INTO bps_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","I to nun knun gal mebe i to landè, na i to gal mdem flifan di to gumdeman. ");
INSERT INTO bps_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","I to mla sasè, kamtu i kaflayam, na i kabkutan i dad to, nun gusenan. ");
INSERT INTO bps_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Nun kafye di to too mlé, du nalelan i knaanan di dad to landè. ");
INSERT INTO bps_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Falwaam i to gal madoy, du fye matlag i ksamuk, na matlag i kaswè talù na kasablé salà. ");
INSERT INTO bps_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","I to too mayè ku matlu nawan na fiten i kafean fagu di fyetaluan, gasgalak kenen i harì. ");
INSERT INTO bps_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","I kaglut gal man i to, too nifat Dwata, fagu di kablabalan i kakakéng gal sanman i to là gsalig. ");
INSERT INTO bps_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","I to là mayè mimò dee balibadan, du fye là mimò, du manan kun ku lamwà kenen di gumnean ken kanfè i lmanaf liyun, na knaanan. ");
INSERT INTO bps_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","I klafà yaan, salngad i fawel, na i dad to fanlabè Dwata, ale i mfawel. ");
INSERT INTO bps_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Én kagkah i dad ngà, gal ale mimò klandè ldam, bay ku tdoam fagu di kbadas dale di gugsalàla, tnagakla i klandèldamla. ");
INSERT INTO bps_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","I to mkut i dad to landè, du fye matnù i knunan, demen mlé di dad to nun, mbaling kenen to landè. ");
INSERT INTO bps_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Ani man i to fulung faldam, manan, Fanlingemagu na tdògu ge i dad gman i to fulung faldam, na toom fkah di nawam i tdògu, ");
INSERT INTO bps_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","du too fye ku gafaldamam, na fakayam tulen di dademe. ");
INSERT INTO bps_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Kayègu ku too ge smalig di Dwata, taman ani tdògu ge. ");
INSERT INTO bps_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Smulat agu tlu falò dad fye gman, du tulengu ge, na gakuf déén dad fye kafngewe na gnadè, ");
INSERT INTO bps_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","na dad gman ani gugmadeam i kaglut, du fye fulung ge tmimel i glut timel di to mdek ge dini. ");
INSERT INTO bps_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Nang ge mlimbung i dad to landè du landè ale, na nang ge mkut dale di gumusay, ");
INSERT INTO bps_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","du Dwata i msen dale, na fanlayaman i to mkut dale. ");
INSERT INTO bps_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Nang ge sgalak di to mlal malbut, na nang ge magin i to mlal flabè, ");
INSERT INTO bps_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","du ken mlalò ge i kenen ldam, na là ge fakay samfulê di fye. ");
INSERT INTO bps_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Nang ge makang na ge mayad dad uteng i demem to, ");
INSERT INTO bps_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","du ku là ge gambayad balù i gumileam snabàla na nwè di ge du bayad dun. ");
INSERT INTO bps_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Nang ge mili ilè gusableng i tanà gfun i dad muna tom i fkahla déén di muna fa. ");
INSERT INTO bps_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","I to too fulung mimò, mbaling kenen mdengeg na ise ku di mdanà to i gumimoan, bay di harì fakayan gumimò. ");
INSERT INTO bps_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Ku kmaan ge di saféd i mdatah to, toom fandam gablà di kton, ");
INSERT INTO bps_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","na ku too ge tyan kmaan, dnanam i ayeam kmaan. ");
INSERT INTO bps_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Nang ge too mibal di kafye nem i knaanan, du ken i knaanan ani i fawelan ge. ");
INSERT INTO bps_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Fandamam funa, na nangam faflungay i ktom mngabal i bong knunam, ");
INSERT INTO bps_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","du i knun tatì lana di mata, salngad klana i kablak ku mayeng ditù di mdatah bulul. ");
INSERT INTO bps_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Nang ge kmaan di saféd i to sasè ldam, demen nang ge too mibal kmaan i dad fye nem knaanan, ");
INSERT INTO bps_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","du kenen satu to gal faldam gablà di bong btas i knaanan. Namanan di ge, “Kmaan na minum ge,” bay i manan ani là mdà di nawan. ");
INSERT INTO bps_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Na ku gadeam i fandaman utaam i knaan fkaanan ge, na landè gukmamu i fye gmanam di kenen. ");
INSERT INTO bps_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Là knabas i to là fulung faldam i kabtas i gmanam di kenen, taman nang ge tamdò kenen. ");
INSERT INTO bps_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Nang mili ilè gusableng i tanà i kafkah di muna, na nang mlad i tanà i dad ilu, ");
INSERT INTO bps_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","du Dwata i too mtulus, msen di dale na kamlung dale. ");
INSERT INTO bps_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Flinge ge i to tamdò ge, na toom dnawat di nawam i tdoan ge. ");
INSERT INTO bps_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Nang ge gdè mlayam i tingaam, du laan sa mati ku sankélam di gugsalaan. ");
INSERT INTO bps_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Kabay balingam kenen gafalwà di lanaw lifoh du tdoam fagu di kbadasam kenen. ");
INSERT INTO bps_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Tingàgu, ku mbaling ge to fulung faldam, too lehew i nawagu. ");
INSERT INTO bps_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Too lehew i nawagu flinge i glut i galam man. ");
INSERT INTO bps_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Nang mibal nawam i knè i dad to gamsalà, bay balingam too kanlikò Dwata klom dini di tah tanà. ");
INSERT INTO bps_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Ku ani nimoam, nun gufyem di satu duh, na gdohò i kafye i galam fatan. ");
INSERT INTO bps_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Tingàgu, fanlingem agu, fafulung ge na mlalò ge i dalan matlu. ");
INSERT INTO bps_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Nang ge magin i dad to langal, demen i dad to too tyan kmaan, ");
INSERT INTO bps_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","du én gusen i dad langal na i dad tyan kmaan, dunan i klandèla, na ku tatì ge alò kudang du langal, én gukelam kadang alò kamlawehi lwék. ");
INSERT INTO bps_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Fanlingem i maam, du kenen mngà ge, na di ktua i yéam too ge mafè kenen. ");
INSERT INTO bps_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Toom fkah di nawam gambet i kaglut, kfulung, fye kafngewe, na kaglabat, na nangam fbayà bay toomknabas i kdee ani. ");
INSERT INTO bps_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","I mà i to matlu nun bong klehewan, na i tingà fulung faldam too kanlehew i maan. ");
INSERT INTO bps_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Fye ku lehew i dad tuam gablà di ge, na fye ku lehew i yéam i mngà ge. ");
INSERT INTO bps_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Tingàgu, too ge flinge deg, na mlalò ge i deg nimò. ");
INSERT INTO bps_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Fawag ge di libun mkat lagi, na di libun mlafà yaanan, dusalngad ale i fawel, na nun dalanla mawel ge. ");
INSERT INTO bps_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Dad libun gambet ani, salngad ale i dad to meye kfagu mlayam gedi dalanam, na dee dad lagi flafàla i yaanla. ");
INSERT INTO bps_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","30","I to too minum i gamlangal, na gal meye i dee bung gamlangal toosasè i kagkahan, du too nun kliduan, gal smamuk, na gal mugak na i matan too fulè, na lamyalo kenen tamduk, na laan moon gaslokani ku laan langal. ");
INSERT INTO bps_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Na di kakokla i gamlangal di basu, nang ge meye balù tan i kafye bawehan na balù too fye i lyalo i to di kaflon dun, nangam ftabug i ktom, ");
INSERT INTO bps_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","du ku minum ge na langal ge, na di kwas i klangalam, lyalom toosasè, salngad ku nakét ge ulad i gamfati. ");
INSERT INTO bps_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Na ku minum ge, nun dee teenam sasè na gamlikò na tatì book i fandamam. ");
INSERT INTO bps_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Na lyom sadi déén ge di aweng di mahin too lamwek, na sadi déén ge di tah layal du too msayug. ");
INSERT INTO bps_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Na du mdà di kdee ani, ani i manam, “Difandamgu snuntukla agu, na bnunalla agu, bay làgu gafaldam i nimòla. Too agu mayè mukat, du fye mngabal agu i ninumgu.” Ani manam kadang ku én nimoam. ");
INSERT INTO bps_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Nang mibal nawam i kagkah dad to sasè, na nang ge mayè dmeme dale, ");
INSERT INTO bps_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","du gal ale faldam i kibòla smamuk, na galla sanman gablà di kimòla sasè di demela to. ");
INSERT INTO bps_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Fagu di kfulung i satu to gafdakan i gumnè, na fagu di kaglabatan nun kgal i gumnean, ");
INSERT INTO bps_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","na du nun gnadean, nun mabtas na nun fye baweh kandeenan di dad sibayan. ");
INSERT INTO bps_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Fye fa i to fulung faldam di to too mgal, du too mdatah fa i gnagan i to nun gnadè di to nun kgal, ");
INSERT INTO bps_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","du ku fan ge salu di gusfati, mni ge funa i fye fngewe, na fagu di fye kafngewe i dee mebe, na matu ge sa di kasfati. ");
INSERT INTO bps_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","I mngalam talù i to fulung faldam là glabat i to là fulungfaldam, taman ku nun kastulen too mngalam, landè timelan du laan glabat. ");
INSERT INTO bps_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","I to funan fandam i kiboan mimò sasè, én kdagit kenen i to mimò samuk. ");
INSERT INTO bps_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","I ksamuk i gal fandam i to là fulung faldam, salà sa, na knang dad to i to gal madoy. ");
INSERT INTO bps_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Ku mlungay i nawam di nun samuk, too glut mlungay ge. ");
INSERT INTO bps_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Faflalam falwà i to landè gugsalaan, i fan fnati i dademe. ");
INSERT INTO bps_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Kabay ku balingam man, “Landè gadègu, nalandè labetgu di to atù,” bay gmadè Dwata ku tan i mnè di nawam, du kenen too meye ge, taman gadean i kdee, taman bnalasan ge di kdee dad nimoam. ");
INSERT INTO bps_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Tingàgu, minum ge tnab, du too fye neman, na tnab mdà di dalit i sugen too mi. ");
INSERT INTO bps_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Na too fye nem i tnab di baam, salngad i kafye i kfulung dinawam, taman toom fkah di nawam kfulung, du nun kadang gufyem di satu duh, na gdohò i kafye i galam fatan. ");
INSERT INTO bps_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Nang ge meye i kfagum mlayam i to matlu, salngad i nimò i tosasè du tmaku, na nangam falmo i gumnean, ");
INSERT INTO bps_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","du balù file dulê fnugen i to matlu lêman gték, bay i to sasè, di kakel i too sasè kalima, laan gték. ");
INSERT INTO bps_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Nang ge lehew ku nun sasè kel di to dmuen ge, na nang flehew i nawam di kfugenan, ");
INSERT INTO bps_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","du ku ani nimoam gadè sa Dwata na laan mayè dun, na ken laan baling fanlayam i to dmuen ge. ");
INSERT INTO bps_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Nangam fsamuk i nawam gablà di dad to sasè, demen nang mibal nawam i kagkahla, ");
INSERT INTO bps_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","du dad to sasè landè fatanla, na landè gufyela di satu duh. ");
INSERT INTO bps_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Tingàgu, fye ku nun klikoam di Dwata na i harì, na nang ge magin i dad to là mimen dale, ");
INSERT INTO bps_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","du dad to gambet ani nun kalmola tatì makto kel, du landè gmadè ku tan i flayam blé Dwata na i harì di dale. ");
INSERT INTO bps_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Ani i dad dademe gman i dad to fulung faldam: Là fye ku i to gal mukum nun nsenan di dad to nukuman. ");
INSERT INTO bps_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Du i to mukum, ku di kukuman i to gamsalà na manan landè salaan, fanlagi kenen i dad to na kdee dad to mnang nawala kenen. ");
INSERT INTO bps_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Kabay i to mukum, ku nukuman i to gamsalà na faflayaman i toani, nun gufyen na dnayen kenen i dad to. ");
INSERT INTO bps_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","I to tmimel i too glut timel, én ilè i to ani too fye deme sgalak. ");
INSERT INTO bps_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Funam fatlagad i nligom, du fye gadeam nun gumweam, kafnge én fdakam gumneam. ");
INSERT INTO bps_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Nang ge tmulen gablà di demem to di gususay ku landè duenan, na nang ge tmulen ise glut gablà di kenen. ");
INSERT INTO bps_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Na nangam man, “E, malas agu i sasè nimoan dideg.” ");
INSERT INTO bps_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Glius agu di satu nligo nfun i to malwe mimò na là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Na di klamang nligon tatmabò dad bnas nun sual, na salnok i dad dademe sabat, na tamalbà i labatan batu. ");
INSERT INTO bps_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Na di kitegu ani, toogu fkah di fandamgu, na nun kagbetgu. ");
INSERT INTO bps_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","I gagbetgu dini, fakay fadlug ge milè, na fadlug kudang, na fadlug ftud, ");
INSERT INTO bps_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","bay ku én alò i nimoam, klom kudang kel di ge klandeam, salngad kakel i satu to mebe tek du tmaku. ");
INSERT INTO bps_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Ani dademe dad mabtas fngewe Harì Solomon, i sulat dad to Hésékaya i harì di banwe Dyuda. Na ani dunan: ");
INSERT INTO bps_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Nafeito Dwata, du mdà di laan fa fgadè di gito, bay nafeito dad harì, du mdà di takafgadèla di gito. ");
INSERT INTO bps_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Là fakay gadè dad fandam i dad harì, du mdatah fa di gitofandam, du i fandamla mdatah gambet kdatah i langit na mngalam gambetkngalam i mahin. ");
INSERT INTO bps_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Funa fwè i gbol di salafì, klon fa mlé dun di to msel, du fye nun gimoan i fye baweh. ");
INSERT INTO bps_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Na salngad én, funa falwà di muna i harì i dad to sasèkafngewela, du fye i kagotan mbaling matlu. ");
INSERT INTO bps_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Ku déén ge di muna i harì, nangam fdatah i ktom, na nang ge sudeng di gusudeng i mdatah to, ");
INSERT INTO bps_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","du fye fa ku manan di ge, “Dini ge di too fyegusudeng,” di kafyaan ge fagu di kmanan, “Blém igusudengam di mdatah to ani.” ");
INSERT INTO bps_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Nang ge flal tmulen di gususay, balù nun teenam, du ken là glut, du ken nun dademe to tmulen na là salngad i ktulenyu, du ku là salngad, landè kiboam ku fyàla ge. ");
INSERT INTO bps_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Ku nun demem to na nun là gusalngad i nawayu, stulen gamu alògamu lwe, na nangam tulen di dademe to i dad santulenyu i là fakay tulen didale, ");
INSERT INTO bps_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","du ku gmadè i dademe to, talandè ksaligla ge, na baling ge myà, na sasè dengegam kel di atuan, du tmulen ge i là fakay moon gadè idademe to. ");
INSERT INTO bps_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Too fye fanlinge i talù too mastadè, salngad kafye i kafye falas di gumnè i harì. ");
INSERT INTO bps_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","I fngewe i to fulung faldam di to too fulung flinge, too mabtas fa di kas mgimò mdà di too glut blawen. ");
INSERT INTO bps_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","I to dek tmulen too gsalig, gafye nawa i to mdek kenen, salngad kafye nawa i to nun too tno yéél di kinit i duh di bangkaktu. ");
INSERT INTO bps_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","I to makang nun blén, bay laan gafles blé dun salngad too mlabun na too mnus, bay là gafles mulen. ");
INSERT INTO bps_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","I to fganag i taluan na ftahaan i nawan, gamguman nawa dad gumdatah i mgal ulu. ");
INSERT INTO bps_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Ku minum ge tnab, nang flukas, du ken utaam. ");
INSERT INTO bps_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Nang ge alì tlang di gumnè i demem to, du ken glukas na knangan ge. ");
INSERT INTO bps_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","I to tmulen kéng gablà di demen to di gususay gamfati salngad i bunal, sundang, na i sait gamban du gamfati. ");
INSERT INTO bps_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Én ksasè i to smalig di to là gsalig di bang nun ksamuk, salngad ksasè i kifan maglifò na i satu blì là gmagan du slamelandè gukmamu. ");
INSERT INTO bps_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","I to flehew mlingag di bang nun klidù nawa i demen to, salngad ku maglus i klaweh di bang katno demen ku nkah kahì i seey, du slame là fakay du mgutes i ksasean. ");
INSERT INTO bps_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Ku bitil i to dmuen gamu fankaanyu kenen, ku malinum banléyu kenen ninum, ");
INSERT INTO bps_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","du ku ani nimoam, mbaling kenen too myà mdà di kafsasean gamu, na gdawatyu untung mdà di Dwata. ");
INSERT INTO bps_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Ku bang i balat too gafles mulen salngad kagafles i kalbut ku nun malsalék. ");
INSERT INTO bps_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Fye fa ku i lagi nun yaan mnè di too tukay lawig di satnù di gumnè i yaanan mayè mugak. ");
INSERT INTO bps_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","I fye tulen mdà di gumawag banwe too fye di nawam salngad i kafye nawa i to malinum di kinuman i yéél tno. ");
INSERT INTO bps_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Too makakdo i to matlu ku naginan i to sasè, salngad i to gal magu ku kel di sfuten na di gal gusmulu na slamemalbal. ");
INSERT INTO bps_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Ku minum ge tnab, sasè ku flukasam, salngad i ksasè ku én fanngabalam i kdayen mdà di dad to. ");
INSERT INTO bps_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","I to là gadnanan i kton laan gtabeng i kton, salngad i syudad tamalbà i batu labatan, talandè kibò tmabeng idad to déén. ");
INSERT INTO bps_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Là gablà kel i bagyù di bang minit demen là gablaan moon mulen di bang kaktu, salngad i to là fulung faldam, là gablà dnayen kenen. ");
INSERT INTO bps_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Ku fanlagi i satu to i demen to na là glut i duenan mlagi kenen, landè gukel i kaflagin, salngad anuk di bnas ku landè gumleenan fadlug mayeng na landègukelan. ");
INSERT INTO bps_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Sankélam i kudà, na knakangam i donki, na fanlayamam i to là fulung faldam, du fye slame ale matdò. ");
INSERT INTO bps_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Ku tnimelam i salek i to là fulung faldam fagu di klandè ldam, baling ge là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Kabay fye ku tnimelam kenen di fye du fye gadean laan fulung fagu di ktimelam kenen. ");
INSERT INTO bps_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","I to mdek i to là fulung faldam ftulen i tulen, baling di kenengukel i sasè, salngad i ksasè ku kanlangan i kenen blì. ");
INSERT INTO bps_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","I mabtas fngewe i man i to là fulung faldam, landè gukmamu dun, salngad i dad blì i to kimay. ");
INSERT INTO bps_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","I kdayenam i to là fulung faldam, landè gukmamu, salngad i fintik, landè gukmamu ku batangam baling i batun. ");
INSERT INTO bps_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","I mabtas fngewe man i to là fulung faldam, sadi landè btasan dikenen, salngad i to langal magot i sual, du sadi laan nagot dun. ");
INSERT INTO bps_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","I to gal fimò i balù simto to i là fulung faldam, fsamukan i kdee dad demen. ");
INSERT INTO bps_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","I to là fulung faldam samfulê di kulang nimoan, salngad i ayem balù i utaan sanfuléan knaan. ");
INSERT INTO bps_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Fye fa i to là fulung faldam, di to i man nawan kenen too fulung. ");
INSERT INTO bps_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","I to là mayè mimò galan man, “Ku lamwà agu digumnègu ken nun labè liyun magu di dalan, na ken kamfèdeg,” ani balibadan du fye là mimò. ");
INSERT INTO bps_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Gambet i takab magsayug na landè guflesan, salngad i to là mayè mimò tatì blaling di gumilean na landègukelan. ");
INSERT INTO bps_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","I to là mayè mimò, balù fa smungit i knaan là mayè. ");
INSERT INTO bps_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","I to là mayè mimò, man nawan too kenen fulung fa di balù fitu lagi fulung tmimel. ");
INSERT INTO bps_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","I to flabet di ksugak i landè kenen labet nun gaslokan, salngad gaslok i satu to smabà klinge i ayem. ");
INSERT INTO bps_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","19","I to mgaw i demen to, na kafnge én manan alò kenen sfuba, nungusasean, salngad i to book agafan i tek gamfati. ");
INSERT INTO bps_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Landè gugadlug kdinè i lifoh ku landè dutungan, na i ksugak landè gugadlugan ku landè kalsalék. ");
INSERT INTO bps_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Là mati bala lifoh ku nun using, na là mati kdinè lifoh ku nundutungan, na là tlag i ksugak ku nun mayè sugak. ");
INSERT INTO bps_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","I kastugad salék, too kanbayan fanlinge i dad to, di dale salngad i knaan too fye neman na too fye nawala mlodun. ");
INSERT INTO bps_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Ku nun man i satu to, na bay ise én mnè di nawan fangawan idemen to, salngad i to mimò tibud tanà fangawan i demen to, du di kimoandun alò di lwà too fye baweh, bay di lam sasè i bawehan. ");
INSERT INTO bps_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","I to flingu muni i nun knang nawan fagu di fye taluan, bay busekan di nawan i kafgawan demen to. ");
INSERT INTO bps_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Balù too fulung kenen talù, nang ge faglut di kenen, du too fnò i nawan i knang nawa. ");
INSERT INTO bps_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Fakay sa ku laan fdilè nun knang nawan, bay i dad sasè nimoan teen i kdee. ");
INSERT INTO bps_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","I to mawel i demen to baling kenen mfawel i fawelan, na i to flulid i bong batu di demen to baling di kenengumlulidan. ");
INSERT INTO bps_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","I to tmulen kéng di demen to, du knangan nawa, én i gafatduknawa i demen to, na i to too dmayen i demen to fagu di dee fye manan bay kadìlà mdà di nawan, gafalmo kenen. ");
INSERT INTO bps_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Nang ge fdag gablà di nimoam fayah, du laam gadè ku tan fa kel di ge. ");
INSERT INTO bps_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Fye ku nun dademe dad to dmayen ge, nang ku ge dmayen i ktom. ");
INSERT INTO bps_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","I batu na falak too blat bay blat fa i ksamuk i nimò i to là fulung faldam. ");
INSERT INTO bps_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","I kaflabè gafatduk nawa i to na gafalmo, bay i kingà nawa too fa sasè gafalmo. ");
INSERT INTO bps_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Fye fa ku nngakam i satu to, du ku laam nngak ken man nawan landè kakabasam kenen. ");
INSERT INTO bps_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Fye fa i katduk nawam fagu di demem sgalak, du fakay smaligkenen, di kafafye i to dmuen ge du ken fangawan ge. ");
INSERT INTO bps_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","I to bsol, balù tnab laan mayè, bay i to bitil balù féét i neman mbaling mi. ");
INSERT INTO bps_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","I anuk di bnas tatì alò mayeng na là samfulê di fulalan, salngad i to ku tatì alò lamngab na là mnè di gumnean. ");
INSERT INTO bps_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Ku ungafam i fangbun, too ge lehew, na ku nun samuk, lana i ktanak nawam. ");
INSERT INTO bps_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Nang tatì fbayà i demem sgalak na i deme i maam sgalak, na ku nun smamuk ge, nangam ftabeng i flanekam mawag dige, fye fa ku ftabengam i demem saldan mdadong di ge di flanekammawag di ge. ");
INSERT INTO bps_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Tingàgu, fye ku mbaling ge to fulung faldam, du fye lehew inawagu, du ku ani nimoam na gadègu tmimel i dad to madoy deg. ");
INSERT INTO bps_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","I to fulung mebe i kton tagadean i samuk fan kel, taman funanniwas, bay i to kulang i kfulungan faldam laan niwas i samuk, tatì fadlugkel di kagdawatan i flayam bunge i nimoan. ");
INSERT INTO bps_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Ku nun to makang kenen mayad uteng i to laan gadè, fye ku nleges kenen smandà i knunan kel di kagbayadan i utengan. ");
INSERT INTO bps_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Ku nukatam i demem sgalak too flafus na too makto i taluam dikenen balù fye i manam, man nawan fanlagim kenen. ");
INSERT INTO bps_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Là too fye fanlinge uni i yéél tatì fadlug tamdak, salngad ksasè fanlinge i libun ku tatì fadlug too mugak i yaanan. ");
INSERT INTO bps_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Na là fakay fatlag i kugakan, salngad i nus là fakay fatlag, demen là fakay magot i fngalo di falelam. ");
INSERT INTO bps_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","I tek fakay néhê di tek, salngad i dad to du fakay ale séhê fandam. ");
INSERT INTO bps_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","I to mifat i kayu nun bunge, gamkaan sa i bungen, na salngad i satu salig mifat i amun, du gamdawat sa bunge inimoan. ");
INSERT INTO bps_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","I alung i satu to fakay teen di yéél, na fakay teen ku tan mnè di nawa i satu to fagu di galan nimò. ");
INSERT INTO bps_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Là bsol i fati na gumnè i dad mati, du gal fatan i dademe, salngad i to là bsol, du dee fa knibalan. ");
INSERT INTO bps_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Tnilew i salafì na blawen fagu di lifoh, du neye ku too glut, na tnilew i kafye ldam i satu to fagu di kdayen kenen, du neye kutoo glut fye i ldaman. ");
INSERT INTO bps_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Balù fa fakay ndak di sung i to là fulung faldam, knean là magwè di kenen i klandè kfulungan. ");
INSERT INTO bps_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Toom nifat i dad lmanafam, ");
INSERT INTO bps_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","du nun gusen i knun, na balù i to nun glal nun gusen i glalan. ");
INSERT INTO bps_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Ani i nimoam, nligom i bnas na santifunam du fkaanam i dadlmanafam klom fatan di lê ktabò i bnas. ");
INSERT INTO bps_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Na i bul dad lmanaf gambet bilibili, fakayam nimò klaweham, na i dad kambing fakay fabli na i gweam fakay bayadam tanà. ");
INSERT INTO bps_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Na i dademe dad kambingam gamlé gatas di ge na dad malayam, na balù dad saligam libun. ");
INSERT INTO bps_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","I to sasè, gal mila du nun klikoan, balù landè tmafik kenen, bay i to matlu là likò, gambet i lmanaf liyun landè klikoan. ");
INSERT INTO bps_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Ku sasè nimò i dad to di satu banwe, gal matlas i ulula, du làale gmagan mebe, bay i ulu nun gnadè na nun kaglabatan, kenen sa gmagan mebe i satubanwe di gufye. ");
INSERT INTO bps_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","I to nun glal mkut i dad to landè, kenen gambet i too bong ulen falmo i dad fule. ");
INSERT INTO bps_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","I dad to là kmabas i dad flalò, msen ale di dad to sasè, bay ku mimen ale i dad flalò, dmuen ale i dad to sasè. ");
INSERT INTO bps_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","I dad to sasè, là ale gamlabat i katlu nimò di dademe to, bay i dad to mayè gmadè knayè Dwata too ale gamlabat. ");
INSERT INTO bps_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Fye fa i to landè ku matlu i nimoan, di to nun knun bay mlimbung i demen to. ");
INSERT INTO bps_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","I tingà mimen i dad flalò nun kaglabatan, bay i tingà magin i dad to mimò sasè fyaan i maan. ");
INSERT INTO bps_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","I to mbaling nun knunan fagu di bong kafngaan i filak fdeman, i knunan ani baling gablé di to mayè mlé di dad to landè. ");
INSERT INTO bps_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","I to là flinge i flalò Dwata knang Dwata i dasalan na laan fanlinge. ");
INSERT INTO bps_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","I to fagsalà i satu to fye, kenen baling gamdawat i flayam, bay i to fye, gamdawat i kafye. ");
INSERT INTO bps_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Slaan di fandam i to nun knun, too glut nun kfulungan, bay i to landè i nun kaglabat, gmadè i kaglut ku glut fulung kudemen là. ");
INSERT INTO bps_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Ku nun satu to matlu mgimò ganlal too flehew i dad to, bay ku nun satu to sasè mgimò ganlal salbuni baling i dad to dulikò ale. ");
INSERT INTO bps_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Landè gufye i to gal muni i dad salaan, bay i to tmulen i dad salaan di Dwata na tnagakan, nlifet Dwata isalaan. ");
INSERT INTO bps_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Nun kafye di to gal mimen Dwata, bay i to fgal i ulun, nun kaflayaman kel di kenen. ");
INSERT INTO bps_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","I ukum i dad bong labè lmanaf dnagit liyun na béar ku bitil, salngad i ukum i sasè ganlal magot i dad to landè du slame ale tookanlikò. ");
INSERT INTO bps_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","I satu ganlal kulang kaglabat, landè sa kakdon, bay i ganlal là mayè mlimbung, du fye matnù i knunan, too mlawil iglalan. ");
INSERT INTO bps_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","I to manò i demen to, too msamuk i nawan, na tatì mimò i kalmon. Na tatiam kenen faloh. ");
INSERT INTO bps_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","I to mimò i matlu nimò maklung kenen di sasè, bay i to là mimò i matlu nimò laan twan i kfugenan di ksasè. ");
INSERT INTO bps_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","I to too mimò di tanaan nun bong knaanan, bay i to gal falmo i duh di landè fye nimoan, baling kenen tolandè. ");
INSERT INTO bps_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","I to gsalig nun gufyen, bay i to mayè mlal nun knunan fagu di klimbung, fanlayam kenen. ");
INSERT INTO bps_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Là fye ku i to gal mukum ku nun nsenan, bay nun dademe dad mukum mimò sasè, du fye nun gwèla balù alòtukay. ");
INSERT INTO bps_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","I to mademet too mayè ku mlal nun knunan, bay laan twan kakel i klandean. ");
INSERT INTO bps_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","I to mngak i demen to, too mabtas fa di satu to dmayen kenen fagu di dee manan, bay kadì là mdà dinawan. ");
INSERT INTO bps_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","I to tmaku di maan demen di yéan, na manan, “Ise sa salà inimògu,” salngad ku dmeme i to gal falmo i demen to. ");
INSERT INTO bps_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","I to lom too gal smamuk, bay i to smalig di Dwata nun gufyen. ");
INSERT INTO bps_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","I to smalig i kton, kenen sa i to là fulung faldam, bay i to mlalò i dalan kfulung, maklung kenen di sasè. ");
INSERT INTO bps_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","I to mlé di to landè landè gukulangan, bay i to là kamdo i to landè, fanlagi kenen i dad to. ");
INSERT INTO bps_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Ku nun satu to sasè, mgimò ganlal, salbuni baling i dad todu likò ale, bay ku talandè glal i sasè ganlal, matnù i dad to fye. ");
INSERT INTO bps_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Ku tadee dulê nngak i satu to, bay knean mgal fa i ulun, én sa gamgebe kenen di kalmo i landè gugalwaan. ");
INSERT INTO bps_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Ku matlu i to mebe i banwe, too lehew i dad to, bay ku sasè i to mebe i banwe, landè klehew i dad to mnè dééndu too ale maflayam. ");
INSERT INTO bps_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","I to kmabas i kfulung, flehewan i maan, bay i to samnagin i libun mkat lagi, falmon i filakan. ");
INSERT INTO bps_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Ku too fkah i harì di nawan i matlu kukum, too nun ktanak dibanwen, bay ku alò én fandaman i filak, toon falmo i banwen. ");
INSERT INTO bps_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Ku simto dmayen i demen sgalak, bay kadì ise mdà di nawan, tatian falmo i kton. ");
INSERT INTO bps_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","I to sasè, én kamfè kenen i salaan, bay i to matlu fakay mlingag na flehew. ");
INSERT INTO bps_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","I dad to matlu too gmadè kamdo na tmabeng i dad to landè digususay, bay i dad to sasè là mabtas di dale i dad to landè. ");
INSERT INTO bps_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","I dad to gal madoy fakay ale finit nawa i dad to di satu syudad, bay i dad to fulung faldam fakay fatlag klabè i dad to. ");
INSERT INTO bps_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Landè kibò musay i to fulung faldam na i to là fulung faldam, du ku ditù di gususay i to là fulung faldam là manak, alò kenenmadoy na flabè. ");
INSERT INTO bps_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","I dad to gal manò, knangla i matlu to, bay i dad to fye, toola nifat i to matlu. ");
INSERT INTO bps_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","I to là fulung faldam, toon falwà i kaflabean, bay i to fulung faldam, gadnanan i kton. ");
INSERT INTO bps_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Ku i satu ulu flinge i dad kakakéng na fnaglutan, mbaling sasè i kdee dad to tmabeng kenen. ");
INSERT INTO bps_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","I to landè na i to mkut i to landè, nun gusalngadla, du nun blé Dwata dale mata du fye mite ale. ");
INSERT INTO bps_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Ku glut kukum i harì i dad to landè, too mlawil i kagotan. ");
INSERT INTO bps_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Nun gufye i dad ngà ku tdò na fanlayam ale di gugsalàla, bay i dad ngà tatì fbayà di gugsalàla fyàla kadang i yêla. ");
INSERT INTO bps_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Ku sasè i dad ulu, too matnù i sasè, bay i kalmola teen i dad to matlu. ");
INSERT INTO bps_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Fanlayamam i tingaam di gugsalaan, na nun kadang ktanak i nawam, na flehewan i nawam. ");
INSERT INTO bps_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","I dad to là flinge Tnalù Dwata sasè, du tatìla nimò i knayèla dulandè malak dale, bay i dad to mimen i tdò Dwata nun kafyela. ");
INSERT INTO bps_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Dademe salig là fakay ku tdoam ale fagu di taluam, du balù glabatla i manam dale, là ale flinge. ");
INSERT INTO bps_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Fye fa i to là fulung faldam, di to i là funa faldam klon fa talù. ");
INSERT INTO bps_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Ku mdà di ktukay i saligam na faknalamam mlé i kdee knayean, là mlo i kdee nfunam nwean na mlé ge klidù nawam. ");
INSERT INTO bps_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","I to labè gal smamuk, na i to mlal malbut gal gamsalà. ");
INSERT INTO bps_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","I to fdatah i kton mdanà sa kadang di satu duh, bay i to fdanà i kton, mdatah sa kadang di satu duh. ");
INSERT INTO bps_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","I to samnagin i to gal tmaku toon fanlayam i kton, du ditù di gumusay, na ku tulenan i kaglut fanlayam kenen, na ku laan tulen i kaglut fanlayam kenen Dwata. ");
INSERT INTO bps_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Sasè ku fsamukam i nawam gablà di fandam i dad to gablà di ge duén gambet i fawel mawel ge, bay ku baling ge smalig di Dwata, kanlungan ge. ");
INSERT INTO bps_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Dee dad to mayè ku i ulula mimò fye di dale, bay i matlu nimò alò mdà sa di Dwata. ");
INSERT INTO bps_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","I to matlu knangan i to sasè, na i to sasè knangan i to matlu. ");
INSERT INTO bps_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Ani i dad fngewe Agur, i tingà Dyakeh fdu di banwe Masa, na talù kenen di ku Itil na Ukal, manan, ");
INSERT INTO bps_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","“Deg sa i to landè gnadè, na landè kaglabat, là gambet dademe to. ");
INSERT INTO bps_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Làgu lmen gambet du fye fulung, demen landè gnadègu gablà di Dwata, i Landè Salà. ");
INSERT INTO bps_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Nun kè to lmen magket salu di langit di gumnè Dwata, na samfulêdini fdu ditù? Nun kè to lmen samtifun i nus na nagotan di falelan? Nun kè to lmen mungas i klamang yéél na i klamang mahin di saulan? Nun kè to lmen mimò i klamang banwe na i dad gusablengla? Simto lmen mimò kdee ani, tan i dagitan na dagit i tingaan? Tulenam deg ku gadeam. ");
INSERT INTO bps_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Kdee tnalù Dwata too glut, landè là glut, na kanlungan i kdee fikit di kenen. ");
INSERT INTO bps_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Nang ge tamnù di tnaluan, du ku én nimoam nngakan ge na fgadean, ge to tmulenkéng.” Ani gman Agur. ");
INSERT INTO bps_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Fakdogu di ge Dwata, di là agu fa mati, dnohoam di deg moon lwe ani. ");
INSERT INTO bps_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Satu, tnabengam agu du fye là agu tmulen kakakéng, na i galwen, nangam blé di deg bong knun, na ku demen faloham di deg i klandè, tiam blé deg i gablà knaan di klit i duh, ");
INSERT INTO bps_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","du ku bong lukas i blém deg, ken mangu landè gukmamugu ge, demen ku landè agu, ken tmaku agu na gafalmogu dengeg Dwatagu. ");
INSERT INTO bps_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Nangam tulen di satu amu i kdalamam i satu saligan, du ku ani nimoam, fanlagin ge, na ge baling maflayam. ");
INSERT INTO bps_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Nun dad to mlagi i màla, na là mlé kafye di yêla. ");
INSERT INTO bps_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Nun dad to flingu too ale mlaneb bay i kaglutan, di lam i nawala too ale magagsik. ");
INSERT INTO bps_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Nun dad to fandamla too ale mdatah, na taman toola fdatah i ktola. ");
INSERT INTO bps_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Nun dad to too ale mkut i dad to landè, na kdee sasè nimò nimòla di dad to landè, du fye gwèla i knunla. ");
INSERT INTO bps_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","Nun satu to too lom, na nun lwe ngaan libun, na galla man, “Banlém gami,” bay balù tan i blém, là gabsol dale, taman salngad ale di fat ani, ");
INSERT INTO bps_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","dunan banwe i dad mati, i libun là fakay mngà, i tanà là alì nulen, na lifoh fadlug smakuf na là fakay fnati. ");
INSERT INTO bps_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","I to madoy i maan, na too là mayè mimen i yéan, fye ku tnukè i dad anuk di bnas i dad matan, na i lawehan knaan i dad kablak. ");
INSERT INTO bps_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Nun tlu tnikenggu, nun fat i làgu glabat, ");
INSERT INTO bps_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","kibò i kablak mayeng di langit, kibò i ulad fulu di tah i batu, kibò i kafal magu di talà mahin, na kibò i lagi kamdo i libun. ");
INSERT INTO bps_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Ani nimò i libun mlafà yaanan, di fandaman landè sasè nimoan, taman, manan, “Landè sa sasènimògu.” ");
INSERT INTO bps_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Nun tlu too sasè di fandam i dad to di tanà ani, nun fat i knangla, ");
INSERT INTO bps_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","i salig mbaling harì, i to là fulung faldam, i tanun kdee knayean knaan, ");
INSERT INTO bps_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","i libun sasè ldam na landè kamdo kenen, bay gamwè yaan, na i libun alò salig mbaling amu di gumnè i amun. ");
INSERT INTO bps_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Nun fat too malnak dini di tah tanà, bay knean too ale fulung, ");
INSERT INTO bps_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","i dad mamang balù too ale mlungay, knean santifunla i knaanla di bang nun gumwèla, du fatlagadlaknaanla di bang i klandèla, ");
INSERT INTO bps_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","i satu bung lmanaf dnagit kuni, too ale mlungay, knean gmagan ale mimò i gumnèla di gunun batu, ");
INSERT INTO bps_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","i dad tlangas, balù landè malak dale, knean stadol ale mayeng, ");
INSERT INTO bps_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","na i dad tikì balù fakay kanfè i kmalam, knean mnè ale di gumnè i dad harì. ");
INSERT INTO bps_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Nun tlu fye neye i kagula, du fulung ale magu, nun fat kadì, ");
INSERT INTO bps_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","kagu i liyun labè di kdee lmanaf, na landè klikoan, ");
INSERT INTO bps_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","kagu i masel smagégél i tinefen, kagu i lagi kambing fdadong di libun kambing, na kagu i harì di muna i dad sundalun. ");
INSERT INTO bps_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","Ku lmenam fdatah, du là ge fulung faldam, demen tafandamam i kiboam mimò sasè, tanlagam ani na fandamam i gukel i dad nimò gambet ani. ");
INSERT INTO bps_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Ku mlo kanligongam gatas msut i tabè, na i ilung, ku snuntukam mlitè, salngad i klabè, ku ninitam mbaling nun samuk. ");
INSERT INTO bps_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Ani i dad gman Harì Lémwél mdà di banwe Masa, i tdò yéan, na man yéan di kenen manan, ");
INSERT INTO bps_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","“E tingàgu, linge Dwata i kdasalgu, tamanblén ge di deg, na ani fngewegu ge. ");
INSERT INTO bps_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Nangam sa falmo i kgalam na filakam di dad libun, du én gafalmo ge, na balù dad harì tagafalmola. ");
INSERT INTO bps_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Fanlingem agu Lémwél, là gablà di dad harì, ku demen dad dademe ulu ku too ale mayè minum i dad gamlangal, ");
INSERT INTO bps_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","du ken di kinumla glifetla i dad flalò, na là ale kadang mimò i matlu nimò di dad to nun klidù. ");
INSERT INTO bps_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Kabay fakay finumam tukay di dad to tafan mati, demen i dad to too msamuk i nawala di klidùla, ");
INSERT INTO bps_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","du fye glifetla i klandèla na i klidùla. ");
INSERT INTO bps_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Nsenam i dad to landè kibò msen i ktola, na tnabengam i dad to landè kibò tmabeng i ktola. ");
INSERT INTO bps_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Nsenam i dad to landè na tanlum i kukumam dale na tnabengam i dad to landè na i dad to too nun klidù.” Ani gman i yê Harì Lémwél di kenen. ");
INSERT INTO bps_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Malima mite libun nun yaan too fye ldam, na bay ku nun teenam, mabtas fa kenen di too mabtas kas. ");
INSERT INTO bps_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","I yaanan too smalig di kenen, na landè gukulangan. ");
INSERT INTO bps_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Klo i libun ani mnè di tah tanà, too fye kiboan yaanan, na landè sasè nimoan di kenen. ");
INSERT INTO bps_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Too malgad kenen mimò klaweh mdà di bul bilibili. ");
INSERT INTO bps_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Gal matun kakaanan di gumawag banwe, na neben di gumnean, salngad nimò i kafal gal mebe kakaan mdà di gumawag banwe. ");
INSERT INTO bps_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Di là fa mwal mték kenen du nimoan knaan i malayan, na dekan dad saligan libun mimò dademe nimò. ");
INSERT INTO bps_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Salu kenen di satu tanà du neyen, na bnayadan, na fagu di filak gwean mdà di nimoan, bayadan bnê du fanlan i tanàén. ");
INSERT INTO bps_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Too mayè kenen mimò na too malgad, na nun kgalan di dad nimoan. ");
INSERT INTO bps_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Gadean i kabtas kdee nimoan, na balù kifu mimò kenen. ");
INSERT INTO bps_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Mimò kenen sinulib na mabal klawehla. ");
INSERT INTO bps_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Too kenen mayè mlé di dad to landè na di dad to nun klidù. ");
INSERT INTO bps_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Kel i bang katno, landè klikoan, du tanun klawehla fatlagadan. ");
INSERT INTO bps_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Nimoan dad kayabla, na too fye bung klawehan na too fye baweh i batakan. ");
INSERT INTO bps_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","I yaanan too mdengeg, du kenen satu ulu di banwela. ");
INSERT INTO bps_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","I fye libun ani, gal mimò i klaweh na fablin, na mimò dad galing, du fablin di dad to gal fabli. ");
INSERT INTO bps_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Too kenen mgal, na too mgafè, na landè klikoan balù tan kel di dale. ");
INSERT INTO bps_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Ku talù kenen dileam i kfulungan, na too glut i katdoan. ");
INSERT INTO bps_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Too kenen mimò, na toon nifat malayan di dad klidùla. ");
INSERT INTO bps_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Too mabtas kenen di dad ngaan, na dnayen kenen i yaanan. ");
INSERT INTO bps_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","Man i yaanan, manan, “Nun dee dad libunfye, bay ge too mdatah di kdee.” ");
INSERT INTO bps_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","I fye kalyak i libun slaan là glut, na i kafye bawehan mlallana, bay i libun too nun klikò di Dwata too magdayen. ");
INSERT INTO bps_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Fye ku blé di fye libun ani, i untung di kdee nimoan, na mdà di fye nimoan, dnayen kenen kdee dad to.");
INSERT INTO bps_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Na satu duh nun man Dwata i Amu di ku Dyona i tingà lagi Amitay, manan, ");
INSERT INTO bps_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Mdà ge salu ditù di bong syudad Ninibi, na tulenam di dad to tagadègu i kdee dad sasè mgimòla.” ");
INSERT INTO bps_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Kabay én baling gusalu Dyona di Sfén, i banwe too mawag di Ninibi, du nilan Dwata i Amu. Salu kenen funa di banwe Dyofa, na déén gumiten i satu aweng fan mdà salu di Sfén. Na di kbayadan i flétin, myak kenen di aweng gagin di dad mebe i aweng, na maweng salu di Sfén, du nilan Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Kabay febe Dwata i Amu i bong mgal nus di tah i mahin, na du kel i bong sasè mahin fan malbà i aweng. ");
INSERT INTO bps_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Na i dad to mebe i aweng ani, too ale likò. Taman kat satu dale tamlo mni tabeng di dad dwatala. Na batla i dad lulenla di mahin, du fye beg magwà blat i aweng. Kabay di kyak Dyona salu kenen ditù di lam i aweng na milè, na di bang ani tatoo kudang. ");
INSERT INTO bps_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Na i kafitan i mebe i aweng, mnaul di lam, na mukat ku Dyona, manan, “Tan i kagkudangam, bong sasè i mahin ani. Mték ge, na fnim tabeng di dwatam, ken kandon ito na là ito gafles mati.” ");
INSERT INTO bps_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Na sanman i dademe mebe i aweng, manla, “Neyeito sa kun ku simto i gumdà i bong sasè mkel di gito.” Na fagu di kasbunut gadèla Dyona gumdà i sasè mkel di dale. ");
INSERT INTO bps_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Taman snalekla Dyona, manla, “Tulenam gami tan i nimoam duen nun kaflayammi ani? Tan i duenam dini? Tan i banwe gumdaam? Na tan bung to ge?” ");
INSERT INTO bps_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Na tnimelan ale, manan, “Deg sa to Hibru, na i fnangamfùgu Dwata i Amu, i Dwata di langit, i mimò i mahin na tanà.” ");
INSERT INTO bps_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Na tulenan dale fa gablà di kilan i Dwata i Amu. Kaklingela i gman Dyona too ale likò, na manla, “Tay ge, too sasè i nimoam.” ");
INSERT INTO bps_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Na baling matnù i kalbang i lwek, taman snalekla Dyona, manla, “Tan i kibòmi ge, du fye fanak i mahin.” ");
INSERT INTO bps_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Na man Dyona, “Batyu agu ditù di mahin, na manak kadang i mahin, du gadègu mdà di sasè nimògu gakuf gamu di ksasè mahin ani.” ");
INSERT INTO bps_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Kabay balingla too fangal kamwa fye gafat ale di kilil mahin, bay làla gagan dun, du too mgal fa i lwek na i nus. ");
INSERT INTO bps_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Na kafnge ani, tamlo ale di glut Dwata, manla, “E Dwata i Amu, kandom gami. Nangam ku gami i gumlém salà kadang di kfati i to ani, du ise gami salà, du ge Dwata i Amu tamgimoam i knayeam.” ");
INSERT INTO bps_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Na kafnge én, batla Dyona di mahin, na manak sa. ");
INSERT INTO bps_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Na ani gumdà i bong klikòla di Dwata i Amu, taman damsù ale na nun dad fakangla di kenen. ");
INSERT INTO bps_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Na di kagbatla ku Dyona ditù di mahin, tanun fatlagad Dwata i Amu bong nalaf du faflo ku Dyona. Na tlu butang i klo Dyona di lam tien i nalaf. ");
INSERT INTO bps_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Na di lam i bong nalaf, dmasal Dyona di Dwata i Amun, ");
INSERT INTO bps_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","manan, “Di lam i bong kaflayamgu tamlo agu ge, Dwata i Amu na tatnimelam agu. Na mdà di gumnè i dad to mati tamlo agu ge du ftabeng, na tafanlingem agu. ");
INSERT INTO bps_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Tafbatam agu di lam i mahin, ditù di too gumngalaman, na sanlibut agu slil, na maglimun agu i dad malbang lwekam. ");
INSERT INTO bps_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Man nawagu tafalwaam agu di munam, na talàgu lêman teen i Bong Gumneam. ");
INSERT INTO bps_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","I lwek di mahin mlimun deg na fan agu saif, maglimun agu mahin, na i lamun glabéd di ulugu. ");
INSERT INTO bps_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ditù agu di gugafdak i dad bulul di gumngalaman, ditù di lam di banwe gumilanggù dad to mati, na landè gugalwàgu. Kabay Dwata i Amu, i Dwatagu tafalwaam agu di kfati. ");
INSERT INTO bps_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Di klandè imen nawagu ku mto agu, gafaldamgu ge, Amugu na too agu dmasal di ge, na ditù di Bong Gumneam talingem agu. ");
INSERT INTO bps_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","I dad to mangamfù di dad ise glut dwata landè gukmamu, taknagolla i kafye mdà di Dwata i Amu. ");
INSERT INTO bps_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Kabay deg, kadang mlingag agu dmayen ge, na mangamfù agu di ge fagu di kadsùgu, na dnohògu i fakanggu di ge, du i kagalwà mdà alò di ge Dwata i Amu!” ");
INSERT INTO bps_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Na kafnge i kdasal Dyona, dek Dwata i Amu i bong nalaf falwà ku Dyona. Taman lwaan kenen di kilil mahin. ");
INSERT INTO bps_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Na lêman talù Dwata i Amu di ku Dyona, manan, ");
INSERT INTO bps_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Salu ge ditù di bong syudad Ninibi, na tulenam di dad to i tagmangu di ge.” ");
INSERT INTO bps_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Taman mimen Dyona i gman Dwata i Amu, na salu kenen ditù di Ninibi. Na Ninibi ani satu bong syudad du tlu duh i klo mifal dun. ");
INSERT INTO bps_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Na sduh Dyona magu di syudad ani, na kafngse én, tambù nan kenen samtulen i gman Dwata i Amu, manan, “Takubu i fat falò butang ani, falmo Dwata i Amu banwe Ninibi.” ");
INSERT INTO bps_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Na i dad to mdà di Ninibi, faglut ale i gman Dwata fagu di ku Dyona. Taman sanmanla, “Fwasa ito.” Na kdeela mdà di mdatah to kel di mdanà to lamsak i klaweh mgimò mdà di saku, du fitela i ksalla i dad salàla. ");
INSERT INTO bps_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Na di kaklinge i harì di Ninibi i gman Dwata i Amu, mnaul kenen di gusudeng i gumdatah, na nlusan i klaweh i harì, na lsakan i saku na sudeng di abu, du fiten i ksalan. ");
INSERT INTO bps_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Na kafnge én, fangadè i harì na i dademe mebe i banwe Ninibi i kdee dad to, manla, “Nang gamu kmaan ku demen minum, na balù i dad lmanafyu nangyu fankaan na finum. ");
INSERT INTO bps_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kdeeyu lamsak i klaweh saku, na balù i dad lmanafyu fnalsakyu. Na kat man satu gamu dmasal di Dwata i Amu na tmagak i dad sasè ldamyu na dad sasè mgimòyu. ");
INSERT INTO bps_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ani i fye nimoito, du ken kandon ito, na matlas i fandaman, na talaan flabè gito, du fye là ito mati.” ");
INSERT INTO bps_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Na di kite Dwata i Amu i nimòla na i ktagakla i dad sasè ldamla, tanlasan i fandaman na laan fnadlug i gmanan gablà di kafalmon dale. ");
INSERT INTO bps_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Na di katlas Dwata i Amu i fandaman là gaflehew ku Dyona, bay baling gumdaan too flabè. ");
INSERT INTO bps_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Taman, dmasal kenen, manan, “E Dwata i Amu, mangu di làgu fa mdà di banwegu, ani i klikògu di ge ku matlas i fandamam. Én duen agu mayè mila ditù di Sfén, du gadègu too ge fye, na là mgili i kakdom, na nun ktahà i nawam, na too mula katlasam i fandamam di kafalmom i dad to. ");
INSERT INTO bps_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Taman Dwata i Amu, nweam i nawagu, du fye fa baling ku mati agu.” ");
INSERT INTO bps_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Kabay tmimel Dwata i Amu, manan, “Fandamam, landè duenam flabè.” ");
INSERT INTO bps_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Taman mdà Dyona lamwà di syudad gsen di gusut i duh, na sudeng kenen. Na ditù nimoan i tukay gufsilungan na sudeng di gugalungan du fatanan ku tan i mkel di Ninibi. ");
INSERT INTO bps_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Na nun ftabò Dwata i Amu walad nun doon, na falnokan di tah Dyona fye nun gamsalung kenen, du fye gamlé kenen kafye nawan. Na walad ani too gaflehew ku Dyona. ");
INSERT INTO bps_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Kabay di ksut i duh, dek Dwata i Amu satu safat du kmaan foon i walad, taman mlanas i doonan, na mati. ");
INSERT INTO bps_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Na di kneng i duh, fbal Dwata i Amu i nus mdà di gusut i duh, na too bong kinitan, taman fan mtafì Dyona mdà di kinit i duh too mneng di tah ulun. Taman kayean ku mati, na manan, “Fye fa baling ku mati agu.” ");
INSERT INTO bps_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kabay man Dwata i Amu di kenen, manan, “Fandamam, landè duenam flabè gablà di walad gamsalung ge.” Na tmimel Dyona, manan, “Too agu flabè fye fa ku mati agu.” ");
INSERT INTO bps_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Na man Dwata i Amu, manan, “Walad ani ftabògu na falnokgu di alò sbutang, na di tmadol butang mati. Landè sa flayamam ftabò na falnok dun, bay knean bong i kakdom dun. ");
INSERT INTO bps_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Kabay mdatah fa di walad i kakdogu i dad to di banwe Ninibi, du nun mlukas mlatu lwe falò libu dad ngà i là mimò sasè, na nun fa dad lmanaf. Taman làgu falmo dun.”");
INSERT INTO bps_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ani gugsulat i gutambul Dyisas Krayst, i bel Harì Dabid, na i bel Abraham di muna fa. ");
INSERT INTO bps_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham i mà Isaak, Isaak i mà Dyékob, Dyékob i mà Dyuda na dad flanekan, ");
INSERT INTO bps_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Dyuda i mà Féris na Sérah, na i yêla dunan Tamar. Féris i mà Hésron, Hésron i mà Ram, ");
INSERT INTO bps_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram i mà Aminadab, Aminadab i mà Nason, Nason i mà Salmon, ");
INSERT INTO bps_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon i mà Boas, na i yê Boas dunan Rahab, Boas i mà Obéd, na i yê Obéd dunan Ruth. Obéd i mà Dyési, ");
INSERT INTO bps_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Dyési i mà Harì Dabid, Dabid i mà Solomon, na i yê Solomon dunan i yaan Uraya. ");
INSERT INTO bps_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon i mà Rihoboam, Rihoboam i mà Abadya, Abadya i mà Asa, ");
INSERT INTO bps_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa i mà Dyihosafat, Dyihosafat i mà Dyoram, Dyoram i mà Usaya, ");
INSERT INTO bps_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya i mà Dyotam, Dyotam i mà Ahas, Ahas i mà Hésékaya, ");
INSERT INTO bps_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hésékaya i mà Manasi, Manasi i mà Amon, Amon i mà Dyosaya, ");
INSERT INTO bps_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Dyosaya i mà Dyékonaya na dad flanekan lagi. Di bang atù i kagakfè na kgebe i dad to mdà di banwe Israél ditù di banwe Babilon. ");
INSERT INTO bps_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Di kakella di Babilon, mngà Dyékonaya, na i tingaan dunan Saltiyél. Na Saltiyél i mà Sorubabél, ");
INSERT INTO bps_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorubabél i mà Abayud, Abayud i mà Ilaykim, Ilaykim i mà Asor, ");
INSERT INTO bps_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor i mà Sadok, Sadok i mà Akim, Akim i mà Ilayud, ");
INSERT INTO bps_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ilayud i mà Éliasar, Éliasar i mà Matan, Matan i mà Dyékob, ");
INSERT INTO bps_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dyékob i mà Dyosif, i yaan Méri, yê Dyisas i dnagitla Krayst, i To Mgalék Dwata. ");
INSERT INTO bps_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na masdagub nun sfalò fat gumastugad i bel mdà di ku Abraham kel di ku Harì Dabid. Na mdà di ku Harì Dabid kel di kgebe i dad to mdà di Israél salu di Babilon, sfalò fat gumastugad i bella. Na mdà di kgebe dale salu di Babilon kel di ksut Krayst, i To Mgalék Dwata, nun sfalò fat gumastugad i bella. ");
INSERT INTO bps_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ani i santulen gablà di ksut Dyisas Krayst. Yéan, Méri, bliwal satu to dnagit Dyosif, bay di là ale fa sdeme gadean tamaltien kenen fagu di Mtiu Tulus Dwata. ");
INSERT INTO bps_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na du Dyosif i to matlu, laan mayè ku fyaan Méri di muna i dee dad to, taman én fandaman, kahan Méri di landè to gmadè dun. ");
INSERT INTO bps_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kabay di slengan faldam ani, gkudang kenen, na nun kasaligan Dwata msut di kenen fagu di knan, na manan, “E Dyosif, bel Harì Dabid, nang ge likò fasdeme ku Méri, du i kaltienan fagu sa di Mtiu Tulus. ");
INSERT INTO bps_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mngà kenen lagi kadang, na i dagitam kenen, Dyisas, du kenen i to falwà i dad ton mdà di dad salàla.” ");
INSERT INTO bps_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na mkel kdee ani, du fye gdohò i gman Dwata fagu di satu tugadan, manan, ");
INSERT INTO bps_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nun kadang satu sawang libun maltien, na mngà kenen lagi. Na én katlola kenen, Imanyuél.” I gumtatek Imanyuél, dunan, “Tadini Dwata samnagin di gito.” ");
INSERT INTO bps_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Taman di kukat Dyosif nimenan i dek kasaligan Dwata na fasdeme ku Méri. ");
INSERT INTO bps_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kabay laan nutik Méri kel di ksut tingaan lagi. Na di ksut tingaan, én dagit Dyosif dun, Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na déén gusut Dyisas di tukay lunsud Bétléhém glam di banwe Dyudiya di bang i kagot Harì Hérod i banwe Dyudiya. Kafnge ksut Dyisas nun dad to too fulung meye kagu i dad blatik kel di syudad Dyérusalém mdà di banwe di gusut i duh. Na manla, ");
INSERT INTO bps_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Tanè gumnè i tingà falami sut, én mgimò kadang harì i dad Dyu? Tateenmi di gusut i duh i blatik ilè kakelan. Taman salu gami dini du mangamfù di kenen.” ");
INSERT INTO bps_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na di kaklinge Harì Hérod tasut satu falami harì, too msamuk i nawan kel di kdee dad to di kagotan déén di Dyérusalém. ");
INSERT INTO bps_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na én nimoan, fastifunan dad ganlal di kafaglut i dad Dyu, dunan i dad ulu i dad bà di Dwata na i dad to tamdò i dad flalò blé Dwata fagu di ku Mosis, na snalekan ale ku tanè gusut Krayst, i To Mgalék Dwata. ");
INSERT INTO bps_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na manla, “Déén di tukay banwe dnagit Bétléhém glam di banwe Dyudiya, du ani sulat i tugad Dwata, manan, ");
INSERT INTO bps_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ge Bétléhém, i tukay lunsud di banwe Dyudiya, balù too tukay ge too mdatah ge di kdee banwe di Dyudiya, du déén di ge kadang gumdà i satu ulu, na kenen mifat i dad togu, dad bel Israél.’ ” ");
INSERT INTO bps_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na di kaklinge Harì Hérod i gusut Krayst, fatlon i dad to too fulung meye i kagu dad blatik di landè to gmadè dun, du snalekan ale ku kilen ksut i blatik. ");
INSERT INTO bps_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kgadean dun, dekan ale ditù di Bétléhém, manan, “Mdà gamu na tooyu fanngabal i tingà én. Na ku teenyu kenen, samfulê gamu dini du fgadèyu deg i gusablaan, du fye salu agu ditù du mangamfù di kenen.” ");
INSERT INTO bps_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na di kaklingela i gman Harì Hérod, mdà ale. Na teenla i blatik tateenla ditù di gusut i duh magu gsen di munala kel di kfanakan déén di tah i sablà gumnè i tingà. ");
INSERT INTO bps_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Di kitela i blatik, too ale lehew! ");
INSERT INTO bps_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kakella di gumnè teenla i tingà di saféd i yéan Méri, na lkuad ale di munan du mangamfù ale di kenen. Na nukalla dad mabtas nebela du bléla di tingà, dunan blawen, na dad mabtas fangbun dnagit insénso na mira. ");
INSERT INTO bps_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kafnge én, mulê ale di banwela, bay mahal dalanla mulê du tafgadè Dwata di dale fagu di kna na fye ku nang ale samfulê di ku Harì Hérod. ");
INSERT INTO bps_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na di kakubu i dad to fulung meye kagu dad blatik, nun kasaligan Dwata lêman msut di ku Dyosif fagu di kna, na manan, “Mték ge, nebem i tingà na yéan, na mila gamu ditù di banwe Idyif, na mnè gamu ditù, du fan fanngabal Harì Hérod i tingà ani du fnatin. Silang gamu mulê ku mangu di gamu.” ");
INSERT INTO bps_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na taman mték Dyosif na neben i tingà na yéan, du mdà ale di butang én salu ditù di Idyif. ");
INSERT INTO bps_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na mnè ale déén kel di kfati Harì Hérod. Na fagu déén gdohò i gman Dwata fagu di satu tugadan, manan, “Tlogu tingàgu lamwà fdu di banwe Idyif.” ");
INSERT INTO bps_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na di kaglabat Harì Hérod mafgaw kenen du mdà di nimò dad to fulung meye kagu dad blatik, too kenen flabè. Taman dekan i dad ton fnati kdee dad ngà lagi falami sut kel di lwe fali i ktuala mnè di banwe Bétléhém na di dademe banwe mdadong déén. Laloan i gman dad to fulung meye kagu dad blatik ku tan i klo mdà di ksut i blatik, du én gugmadean kalnawa tingà fafatin. ");
INSERT INTO bps_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na mdà di kfati i kdee dad ngà ani too gdohò i gman Dwata fagu di tugadan Dyérimaya, manan, ");
INSERT INTO bps_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nun linge to di banwe Rama kamwak na mlanu. Nngel Rakél i dad ngaan, na landè gamlala nawan, du tamati dad ngaan.” ");
INSERT INTO bps_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kafnge i kfati Harì Hérod nun kasaligan msut di ku Dyosif déén di Idyif fagu di kna, na manan, ");
INSERT INTO bps_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mték ge, nebem i tingà na yéan, na samfulê gamu di banwe Israél, du tamati i dad to mayè mati i tingà.” ");
INSERT INTO bps_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na taman mték Dyosif, na neben i tingà na yéan mulê di banwe Israél. ");
INSERT INTO bps_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kabay di kaklinge Dyosif, na én tlas ku Harì Hérod magot i banwe Dyudiya dunan i tingaan Arkilas, likò kenen mnè ditù di Dyudiya. Na mdà di kafngewe Dwata kenen fagu di kna, baling ale salu di banwe Galili. ");
INSERT INTO bps_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na i gumnèla di Galili, dunan i tukay lunsud dnagit Nasarét. Na ani kagdohò i gman Dwata fagu di tugadan, manan, “I katlola kenen, to mdà di Nasarét.” ");
INSERT INTO bps_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na di file fali kubu, nun to dnagit ku Dyan Gal Munyag kel di banwe landè to mnè déén glam di banwe Dyudiya na tdoan i dad to salu déén di kenen. ");
INSERT INTO bps_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Na manan, “Msal gamu na tnagakyu dad sasè nimòyu, du tamdadong i kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na Dyan ani i santulen Dwata fagu di tugadan Isaya di muna fa, manan, “Nun to tamlo di banwe landè to mnè déén, manan, ‘Fatlagadyu i dalan i Amu, na tanluyu i gumagun.’ ” ");
INSERT INTO bps_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na i klaweh lsak Dyan dunan i bul kamél nanem, na i galingan kindal lmanaf. I knaanan tlangas na tnab. ");
INSERT INTO bps_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na dee dad to gal salu di kenen mdà di syudad Dyérusalém, na mdà di dademe banwe glam di banwe Dyudiya, na mdà di dad banwe mdadong di yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na tulenla kenen i dad salàla, na bnunyag ale Dyan di bong yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kabay di kiten nun dee dad to mdà di lwe bung fnaglut i dad Dyu dnagit Farisi na Sadusi fdadong di kenen du fan fbunyag, manan di dale, “Tay gamu! Salngad gamu i dad ulad mila mdà di lifoh. Simto kè tmulen gamu galwà gamu di flayam blé Dwata ku alò gamu fbunyag? ");
INSERT INTO bps_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ku tamsal gamu, fiteyu i ksalyu di dad salàyu fagu di fye nimòyu. ");
INSERT INTO bps_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nangyu man, ‘Balù ku là gami msal là gami gakuf di flayam blé Dwata, du gami bel Abraham.’ Tulengu gamu i kaglutan, balù mdà di dad batu ani gagan Dwata mimò bel Abraham ku kayean tamlas gamu. ");
INSERT INTO bps_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na i kukum Dwata too mdadong. Ku fkahito di to mbek kayu, tadéén i balyungan di foon i kayu, du tagatlagad mbek kdee kayu là munge fye bunge, na bat di lifoh. ");
INSERT INTO bps_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“I kbunyaggu ani fagu di yéél du ilè tamsal gamu, bay nun to tmadol deg too mdatah fa di deg, taman là agu gablà mebe i talumfaan, du too agu mdanà di kenen. I kbunyagan gamu fagu di Mtiu Tulus na di lifoh. ");
INSERT INTO bps_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na santanin dad to tlu na sasè salngad fali tnaaf. Tanagotan i taaf du tmaaf, na i fali tamagtaaf busekan di folan, bay i kdee afa snakufan di lifoh landè kfatin.” ");
INSERT INTO bps_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na salu Dyisas di yéél Dyordan fdu di banwe Galili, du fbunyag ku Dyan. ");
INSERT INTO bps_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kabay fan là mayè Dyan munyag kenen, na manan, “Gablà ku ge munyag deg. Kan ku ge baling fbunyag di deg?” ");
INSERT INTO bps_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na tmimel Dyisas, manan, “Faloham i nimòta ani, du fye gimenta i kdee knayè Dwata.” Taman nagin Dyan i knayean, na bnunyagan Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na di kafnge munyag, matun Dyisas mdà di yéél. Na mgukà i langit na teenan i Tulus Dwata fdanà na mdaf di kenen gambet abun. ");
INSERT INTO bps_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na nun talù mdà di langit, manan, “Ani tingàgu, toogu kando na too fye nawagu kenen.” ");
INSERT INTO bps_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na kafnge én, nebe Tulus Dwata Dyisas salu di banwe landè to mnè déén, du fye tnilew kenen Satanas. ");
INSERT INTO bps_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na di fat falò duh na butang là kmaan Dyisas, taman too bitil kenen. ");
INSERT INTO bps_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na fdadong di kenen Satanas du tnilewan, na manan, “Ku ge Tingà Dwata, fanbalingam fan dad batu ani.” ");
INSERT INTO bps_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kabay tmimel Dyisas, manan, “Nun gsulat di Tnalù Dwata, manan, ‘Ise ku alò knaan gamto i to, bay lê gamto i kat talù man Dwata.’ ” ");
INSERT INTO bps_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kafnge én, nebe Satanas Dyisas di syudad Dyérusalém na ftadagan kenen di sen tah i Bong Gumnè Dwata. ");
INSERT INTO bps_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na manan di kenen, “Ku ge Tingà Dwata, na kamyaf ge mdà dini, du nun gsulat di Tnalù Dwata, manan, ‘Dek Dwata i dad kasaliganan mifat ge. Snilungla ge i dad kmalla, du fye là gtudà di batu i bliam.’ ” ");
INSERT INTO bps_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kabay tmimel Dyisas, manan, “Nun lê gsulat di Tnalù Dwata, manan, ‘Nangam tnilew Amum Dwata.’ ” ");
INSERT INTO bps_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na lêman nebe Satanas kenen ditù di satu too mdatah bulul, na fiten kenen i kdee banwe nagot i dad to di tah tanà na i bong kafyela. ");
INSERT INTO bps_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na manan di ku Dyisas, “Blégu di ge i kdee teenam ani ku lkuad ge du mangamfù di deg.” ");
INSERT INTO bps_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kabay tmimel Dyisas, manan, “Nang ge dini Satanas! Gsulat di Tnalù Dwata, ‘Fnangamfuam Amum Dwata, na kenen alò i nimenam.’ ” ");
INSERT INTO bps_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na tnagak kenen Satanas, na nun dad kasaligan Dwata salu di kenen du nifatla. ");
INSERT INTO bps_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na di kaklinge Dyisas tabnilanggùla Dyan Gal Munyag, samfulê kenen di banwe Galili. ");
INSERT INTO bps_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kabay là kenen mnè di Nasarét, bay mili kenen di satu lunsud dnagit Kafernaum di kilil i bong lanaw Galili mdadong di dad banwe Sibulun na Néftali. ");
INSERT INTO bps_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na fagu di knean déén, gdohò i gman Dwata fagu di tugadan Isaya, manan, ");
INSERT INTO bps_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“I dad banwe Sibulun na Néftali, dunan i gumnè i dad to ise Dyu, mdadong di lanaw Galili di faltù i yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na i dad to déén, balù tagnè ale mnè di gukmifun, tamite ale i bong kalwa. Balù mlo ale mnè di kakifu i fati, tanun kagalwàla.” ");
INSERT INTO bps_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na mdà di bang én, tambù Dyisas tamdò, manan, “Msal gamu, na tnagakyu i dad sasè nimòyu du tamdadong i kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na satu duh magu Dyisas di kilil i bong lanaw Galili, na teenan lwe lagi saflanek, Simon i dnagitla Fiter na Andru. Mukut ale di lanaw, du ale i dad to gal mwè nalaf. ");
INSERT INTO bps_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na man Dyisas di dale, “Magin gamu deg, du balù ani galyu nimò meye nalaf, tdòta gamu meye i dad to du fye mlalò ale deg.” ");
INSERT INTO bps_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na di kmanan ani, tagakla i fukutla, na magin ale kenen. ");
INSERT INTO bps_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na di slengla magu teen Dyisas lwe lagi saflanek dnagit Dyém na Dyan, i dad ngà Sébidi. Déén ale di awengla magin i màla. Tambél ale i fukutla. Na di kite Dyisas dale tlon ale du faginan, ");
INSERT INTO bps_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na tnagakla awengla na màla du magin ale ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na lamngab ale Dyisas di dad banwe glam di Galili, du tamdò kenen di dad gal gusatdò dad Dyu i Fye Tulen gablà di kagot Dwata. Na fanguléan kdee bung tduk i dad to na dad gukulang i lawehla. ");
INSERT INTO bps_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na too mbel i santulen gablà di kenen di klamang banwe Sirya, taman nebela di kenen i kdee dad to nun dad sahal bung tduk, na dad to maflayam du mdà di sasè katduk, na dad to nun busaw, dad to bnabuy, na dad to là galyak lawehla, na fangulê Dyisas i kdeela. ");
INSERT INTO bps_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na too dee dad to mlalò kenen, dademe mdà di Galili, na mdà di dad sfalò banwe dnagit Dikafolis, na dademe mdà di syudad Dyérusalém na mdà di klamang Dyudiya na dademe mdà di dad banwe di faltù i bong yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na satu duh, di kite Dyisas i kdee dad to, mnagad kenen di bulul, na ditù gusudengan. Na stifun di safédan i dad to gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na tambù kenen tamdò dale, manan, ");
INSERT INTO bps_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nun kafye i dad to dmilè là ale gmagan mlalò Dwata ku ise mdà di tabengan, du gakuf ale di kagotan. ");
INSERT INTO bps_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nun kafye i dad to mlidù, du nlala ale Dwata. ");
INSERT INTO bps_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nun kafye i dad to fdanà i ktola, du gdawatla i tafakang Dwata di dale. ");
INSERT INTO bps_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nun kafye i dad to bitil na malinum i katlu Dwata, du fabsolan ale kadang. ");
INSERT INTO bps_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nun kafye i dad to kamdo i dademela to, du kando ale Dwata. ");
INSERT INTO bps_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nun kafye i dad to matlu i nawala, du site ale kadang Dwata. ");
INSERT INTO bps_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nun kafye i dad to smafye i dademela to, du matlo ale dad ngà Dwata. ");
INSERT INTO bps_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nun kafye i dad to fanlayam mdà di matlu nimòla, du gakuf ale di kagot Dwata. ");
INSERT INTO bps_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nun kafyeyu ku nadoy gamu i dad to, na fanlayam gamu, na ku dnalamla gamu di kdee bung sasè làyu nimò du mdà di ksasatuyu di deg. ");
INSERT INTO bps_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Salngad ani i kaflayamla dad tugad Dwata di muna, taman too gamu flehew du bong untungyu kadang di langit. ");
INSERT INTO bps_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamu dad togu, di kagbolyu di dad to di tah tanà gambet gamu i kahì du gamu gumdà i kafye di dale. Kabay ku magwè i nem i kahì, talandè kibò fye fasfulê i neman. Na ku én knè i kahì talandè gukmamu dun, tatì alò bat na ndà i dad to. ");
INSERT INTO bps_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Na di kagbolyu di dad to di tah tanà lê gamu gambet i salò. Ku fkahta di lunsud, ku ditù gugnean di tah i bulul là gbuni dun. ");
INSERT INTO bps_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na i to mtam i salò, laan snukub dun. Bay ku ntaman i salò, toon fagfan gufkahan, du fye mite i kdee dad to. ");
INSERT INTO bps_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Salngad én gamu, tooyu fneng i salòyu di kdee dad to, du fye teenla dad fye nimòyu, na dnayenla i Màyu di langit.” ");
INSERT INTO bps_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Na man fa Dyisas, “Nangyu fandam ku i duengu salu dini di tah tanà, du kayègu fnang dad flalò blé Dwata fagu di ku Mosis na i tdò i dad tugadan. Làgu sa fnang, bay fitegu i glut kimen dun. ");
INSERT INTO bps_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tulengu gamu i kaglutan, di klo i nun tanà na langit, landè lana di flalò Dwata balù tukay du mti gdohò i kdee. ");
INSERT INTO bps_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na taman balù simto mlafà balù alò satu flalò Dwata, na léan tdò di demen dad to i klafà dun, mdanà kenen di kdee to di kagot Dwata di langit. Kabay ku simto mimen kdee flalò Dwata na tdoan di demen to i kimen dun, too kenen mdatah to di kagot Dwata di langit. ");
INSERT INTO bps_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Taman mangu di gamu silang gamu gakuf di kagot Dwata ku mdatah fa i katluyu di katlu i dad to tamdò i flalò Dwata na i dad Farisi di kimenla i flalò Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na fadlug Dyisas tamdò, manan, “Talingeyu i gal tdò di dad to di muna fa, manan, ‘Nang gamu manò, na ku simto manò, nebeyu di gumukum du fye nukum.’ ");
INSERT INTO bps_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kabay ani mangu fa di gamu, balù simto to flabè i demen to gablà nukum di gal gumukumyu. Na lêman i to smilo i demen to, gablà nukum di dad mdatah mukum. Na lêman i to ku manan, ‘Landè kamu ge,’ du mdà di kalbutan satu to, gablà kenen fanlayam Dwata di lanaw lifoh. ");
INSERT INTO bps_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Taman ku tadéén ge di gudamsù di Dwata, na nun fanam blé di Dwata, bay nun gafaldamam salà tamgimoam di demem to, ");
INSERT INTO bps_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","funam tnagak i blém na mdà ge salu di to én na fnafyem klom samfulê du mlé i dsuam di Dwata. ");
INSERT INTO bps_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na ku nun to fsalà ge na neben ge di usay fye ku funa gamu stulen alò gamu du fye gasil sulê di gusafyeyu di là gamu fa gafat di ganlal, du ku takel ge ditù, ken blén ge di to mukum du kenen gmadè ku tan kiboan ge. Na i to mukum blén ge di dad fulis na i fulis fbilanggù ge. ");
INSERT INTO bps_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na tulengu gamu i kaglutan, ku mkel ani di ge, silang ge galwà di bilanggù ku taftim bnayad i salaam.” ");
INSERT INTO bps_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Na fadlug Dyisas tamdò, manan, “Talingeyu i gal tdò manan, ‘Nang ge mlafà i yaanam.’ ");
INSERT INTO bps_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kabay ani mangu di gamu, balù simto to meye di satu libun ise yaanan na nibalan tagamsalà kenen du tanlafaan yaanan di fandaman. ");
INSERT INTO bps_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Taman ku i matam kwanan mebe ge di kimò sasè, baling fye fa ku tanwilam na batam, du fye là ge fles mimò sasè. Fye fa ku lana satu matam na nun nawam landè sen, di sikof i laweham na baling ge bat di lanaw lifoh. ");
INSERT INTO bps_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na lêman ku i kmalam gsen di kwanan mebe ge di kimò sasè, baling fye fa ku kanlangam na batam, du fye là ge fles mimò sasè. Fye fa ku lana satu alel di laweham di sikof i laweham, bay baling ge gsalu di lanaw lifoh.” ");
INSERT INTO bps_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Na man Dyisas fa, “Na nun gal tdò di muna fa, ‘Balù simto to mkah i yaanan, là fakay ku laan blé di kenen i fafil gugmadè takahan kenen.’ ");
INSERT INTO bps_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kabay ani mangu di gamu, balù simto lagi mkah i yaanan i là mlafà kenen gamsalà di Dwata, du i kakahan kenen gumdà i yaanan mlafà kenen ku lêman mwè yaan i libun kahan. Na i lagi mwè i libun takah ani lê gakuf kenen di kagsalaan.” ");
INSERT INTO bps_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na fadlug Dyisas tamdò, manan, “Talingeyu i gal tdò di dad to, manan, ‘Ku smafà ge, nang tmulen kéng, bay toom dnohò i fakangam di Dwata.’ ");
INSERT INTO bps_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kabay ani mangu di gamu, nang gamu smafà. Hae, nang gamu smafà fagu di langit, du én sa i gusudeng Dwata di kagotan. ");
INSERT INTO bps_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na nang gamu smafà fagu di tanà, du én gumdà i blian. Na nang gamu smafà fagu di Dyérusalém, du én sa syudad Dwata i too mdatah harì. ");
INSERT INTO bps_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na nang gamu smafà fagu di uluyu, balù sbalu wakyu làyu gagan fbukay ku demen fafitam. ");
INSERT INTO bps_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kabay di ktimelyu ku mayè gamu, manyu ‘hae’, na ku là gamu mayè, manyu ‘là’, du ku smafà gamu fa én ksafà tnùyu fdu di ku Satanas.” ");
INSERT INTO bps_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Na man Dyisas fa, “Talingeyu i gal tdò di dad to, manan, ‘Ku nun to fatduk i satu matayu, fatdukyu satu kenen mata. Na ku nun to falmo satu kifanyu, lêyu falmo satu kifanan.’ ");
INSERT INTO bps_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kabay ani i mangu di gamu, nang gamu malas sasè di to mimò sasè di gamu. Kaflingenta dun ku nun to smamfak gamu di bali bawehyu di kwanan, lêyu nà i balin du fsamfakyu kenen. ");
INSERT INTO bps_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ku nun to mebe gamu di usay, du fye gwean saulyu, lêyu blé kenen i tahà sigalyu. ");
INSERT INTO bps_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na ku nun to mleges gamu mebe i knakifan kel di kawag i satu kilumitru, nebeyu kel di lwe. ");
INSERT INTO bps_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na ku nun to mni di gamu, banléyu kenen, na fandemyu i to mayè mdem di gamu.” ");
INSERT INTO bps_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na fadlug Dyisas tamdò, manan, “Talingeyu i gal tdò di dad to, manan, ‘Kandom i dad demem sgalak, na knangam nawa,’ kun, ‘i dad to dmuen ge.’ ");
INSERT INTO bps_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kabay ani mangu di gamu, kandoyu i dad dmuen gamu, na dnasalyu i dad to mlayam gamu. ");
INSERT INTO bps_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Na ku ani nimòyu too dnilè dad to na gamu dad ngà i Màyu di langit, du Dwata là alò di dad to matlu i gufnengan i duh na gumlén i ulen bay balù di dad to i là matlu na mimò sasè. ");
INSERT INTO bps_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nangyu fandam ku nun untung blé Dwata gamu ku én alòyu kando i dad to kamdo gamu. Landè gusahal i nimòyu di nimò dad to sasè gambet dad to gal mwè bayad buhis, du galla kando i dad to kamdo dale. ");
INSERT INTO bps_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na salngad én, ku alò én gustulenyu i dademeyu sgalak landè gusahal i nimòyu di nimò dad to là gmadè Dwata, du balù dad to là gmadè Dwata stulen ale di dademela sgalak. ");
INSERT INTO bps_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Taman tooyu snikof i kakdoyu di kdee dad to, du fye sikof i katluyu salngad di Màyu di langit.” ");
INSERT INTO bps_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Na fadlug Dyisas tamdò, manan, “Di kimòyu i dad nimòyu di Dwata too gamu fgeye, du fye ise én duenyu mimò dun du fite di dademe to, du ku én nimòyu, landè untung gdawatyu mdà di Màyu di langit. ");
INSERT INTO bps_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Taman ku nun tabeng bléyu di dad to landè knun, nangyu fgadè dun gambet i nimò dad to gal mféw di tafan ale mlé déén di gudee dad to di gal gusatdoito na di kilil dalan, du alòla kayè ku dag i dad to i nimòla. Na tulengu gamu i kaglutan, alò kdag i dad to gusen i untungla. ");
INSERT INTO bps_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kabay gamu, ku nun bléyu di dad to landè, nangyu fgadè balù di dademeyu sgalak, ");
INSERT INTO bps_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","du fye gbuni i kabléyu, na i Màyu di langit i mite kdee nimòyu di gugbunin, kenen sa i mlé gamu untung.” ");
INSERT INTO bps_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na fadlug Dyisas tamdò, manan, “Ku dmasal gamu di Dwata nangyu ganbet i dad to flingu ale fye to. Ku dmasal ale, too ale mayè tadag di gal gusatdoito dad Dyu, na di kilil i dalan fye teen dad to i nimòla. Na tulengu gamu i kaglutan, alò kdag i dad to gusen i untungla. ");
INSERT INTO bps_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kabay gamu, ku dmasal gamu fusuk gamu di sibayyu na tnakabyu, na dmasal gamu di Màyu i là teen. Na i Màyu mite kdee nimòyu di gugbunin, kenen sa i mlé gamu untung. ");
INSERT INTO bps_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na ku dmasal gamu nangyu fandee i manyu landè gukmamu gambet nimò i dad to dmasal di dad ise glut dwata, du fandamla too ale fanlinge ku fantahàla i dasalla. ");
INSERT INTO bps_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nangyu ale ganbet du tasana gadè i Màyu i kanlidùyu di là gamu fa mni di kenen. ");
INSERT INTO bps_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kabay gambet ani i fye kdasalyu, Màmi déén di tah langit, kayèmi moon ku kdee dad to mangamfù di ge. ");
INSERT INTO bps_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kayèmi ku ge magot i kdee dad to, na ku gdohò i kdee knayeam dini di tah tanà salngad kagdohoan déén di langit. ");
INSERT INTO bps_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Blém gami gablà knaanmi di duh ani. ");
INSERT INTO bps_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na nlifetam i dad salàmi, salngad klifetmi salà i dad to gamsalà di gami. ");
INSERT INTO bps_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nangam faloh di gami i dad tilew gamgebe gami di salà, bay falwaam gami di ku Satanas gumdà i kdee sasè. ");
INSERT INTO bps_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Na ku nlifetyu salà i dademe to gamsalà di gamu, nlifet i Màyu di langit gamu salà. ");
INSERT INTO bps_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kabay ku làyu nlifet salà i demeyu to là nlifet i Màyu di langit gamu salà. ");
INSERT INTO bps_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Na ku fwasa gamu, nangyu flidù bawehyu gambet i dad to gal flingu ale fye to, du én nimòla fitela di bawehla na too ale bitil, du fye dilè i dad to fwasa ale. Tulengu gamu i kaglutan, alò kdag i dad to gusen i untungla. ");
INSERT INTO bps_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kabay gamu ku fwasa gamu samwat gamu na lngauf, ");
INSERT INTO bps_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","du fye landè dad to dmilè i kafwasayu. Na i Màyu di langit i là teen mite i kdee nimòyu di gugbunin, na kenen i mlé gamu untung.” ");
INSERT INTO bps_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Na fadlug Dyisas tamdò, manan, “Nang gamu samtifun knun dini di tah tanà, du alò falmo i kanok na tnéé ku demen tnaku i dad to. ");
INSERT INTO bps_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kabay én gusamtifunyu knun ditù di langit, du ditù landè kanok gafalmo dun na laan tnéé, na landè to gfusuk du tmaku dun. ");
INSERT INTO bps_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hae, du ku nè gusamtifunyu i knun tooyu knabas, én sa gumnè i nawayu. ");
INSERT INTO bps_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“I matayu gambet i salò di lawehyu. Ku fye i keyeyu fakayyu man matlu i fandamyu, na gambet langub lwa klamang lawehyu, ");
INSERT INTO bps_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","bay ku sasè i keyeyu, sasè fandamyu na gambet langub kifu klamang lawehyu. Na ku sasè i keyeyu na fandamyu too gamu mnè di gukmifun. ");
INSERT INTO bps_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Landè kibò flifan di lwe amu, du ku lwe amu satu to knangan nawa satu na kanbongan nawa satu ku demen nimenan satu na snilon satu. Ku too bong nawayu i knun na làyu gimen Dwata du landè kibò flifan di lwe. ");
INSERT INTO bps_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Taman ani mangu di gamu, nangyu fsamuk i nawayu gablà di knèyu dini di tah tanà, i galyu knaan na ninum, na gablà di lawehyu ku tan klaweh galyu lsak. Mabtas fa i nawata di knaan, na i lawehta di klaweh. Na ku gablé Dwata di gamu i lawehyu na nawayu, kan ku fsamukyu nawayu gablà di knaan na klaweh? ");
INSERT INTO bps_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Fandamyu dad anuk di bnas mayeng di langit. Là ale mla ku demen kamtu, landè fol gumusekla i ulê i flala, bay fankaan ale i Màyu di langit. Na gamu too mabtas fa di dad anuk. ");
INSERT INTO bps_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nun kè di gamu tmugad i klawilan balù tukay fagu di kafsamuk i nawan gablà di kliduan? Landè sa. ");
INSERT INTO bps_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na tan fa ku fsamukyu nawayu gablà di klawehyu? Fandamyu dad bulek di bnas, ku tan kibò ktabòla. Là ale faflayam meye klidùla na là ale mimò klawehla. ");
INSERT INTO bps_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kabay ani mangu di gamu, balù Harì Solomon di too nun knunan, landè klawehan gasngad di kafye baweh i satu bulek nimò Dwata. ");
INSERT INTO bps_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na fandamyu, landè kabtas dad bulek di bnas mto duh ani bay fayah mlanas na bat di lifoh. Ku kanlaweh Dwata i dad bulek di kafye én, laan gamu kè kanlaweh du too gamu mabtas? Tay, too tukay i ksaligyu! ");
INSERT INTO bps_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Taman nangyu fsamuk nawayu, na nangyu man, ‘Tanè gumwèmi i knaanmi? Tanè gumwèmi ninummi? Tanè gumwèmi klawehmi?’ ");
INSERT INTO bps_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hae, du én nimò dad to là gmadè Dwata du toola fanngabal kdee ani, bay i Màyu di langit tasana gmadè i kdee klidùyu. ");
INSERT INTO bps_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kabay gamu, ani nimòyu, funayu fdatah di nawayu kagot Dwata gamu, na klalòyu katlun, na blén di gamu kdee kanlidùyu. ");
INSERT INTO bps_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Taman nangyu fsamuk nawayu gablà di klidù fayah, du dee i dad klidù di mduh ani. Silangyu fandam i dad klidùyu ku takel.” ");
INSERT INTO bps_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na fadlug Dyisas tamdò, manan, “Nang gamu mukum i demeyu to, du fye là gamu nukum Dwata. ");
INSERT INTO bps_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ku tan i ukumyu demeyu to salngad i ukum Dwata gamu, na ku tan kablat ukumyu i demeyu to salngad kablat ukum Dwata gamu. ");
INSERT INTO bps_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Kan ku neyem i tukay salà gambet fuling di mata i demem to, bay tatiam bayà i bong salà gambet i bateng di ge mata? ");
INSERT INTO bps_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na kan ku manam, ‘Nwègu kun i fulingam,’ na blaam nun bong bateng di ge mata. ");
INSERT INTO bps_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tay, tatì ge flingu fye to, funam nwè i bong bateng di ge mata, du fye, fye kitem di kweam fuling di mata i demem to. ");
INSERT INTO bps_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Na di ktulenyu i kaglut Dwata, ku nun to là mayè flinge nangyu fadlug tulen di dale. Hae, nangyu blé di dad ayem i nfun Dwata du kenla gamu baling nakét. Na nangyu bat di dad sdè dad too mabtas du balingla sa sandà. ");
INSERT INTO bps_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mni gamu di Dwata, na banlén gamu, mngabal gamu na fiten di gamu i fanngabalyu, na mbal gamu fusuk na lanwan di gamu i takab. ");
INSERT INTO bps_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Du balù simto mni di Dwata, gamdawat sa kenen, na balù simto mngabal, fite Dwata di kenen i fanngabalan, na balù simto mbal fusuk, lanwa Dwata di kenen i takab. ");
INSERT INTO bps_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Gamu dad lagi nun dad ngà, ku mni dad ngàyu fan, bléyu kè batu? ");
INSERT INTO bps_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ku mni nalaf, bléyu kè ulad? Là sa. ");
INSERT INTO bps_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Balù tagnè gamu dad gamsalà, knean fulung gamu mlé fye di dad ngàyu. Mdatah fa déén i kfulung Màyu di langit mlé kafye di dad mni di kenen.” ");
INSERT INTO bps_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Na ku tan kayèyu nimò i demeyu to di gamu, én nimòyu di dale, du én sa i gumtatek kdee flalò blé Dwata fagu di ku Mosis na i tdò i dademe tugadan.” ");
INSERT INTO bps_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Na fadlug Dyisas tamdò, manan, “Neyeyu du fye fusuk gamu di fital dalan salu di nawa landè sen, du mabal i gufusuk na too mula kagu déén di dalan salu di lanaw lifoh, na too dee dad to magu déén. ");
INSERT INTO bps_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kabay i dalan salu di nawa landè sen too fital i gufusukan na too malima nagu, na là dee to mite dun.” ");
INSERT INTO bps_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Na fadlug Dyisas tamdò, manan, “Too gamu fgeye du nun dad to flingu ale tugad mdà di Dwata. Salu ale di gamu gambet dad mnalam lmanaf bilibili, bay i too glut kagkahla salngad di labè ayem di bnas gal falmo. ");
INSERT INTO bps_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Én gudmilèyu ku fye ale di ulê nimòla, salngad di dad munge dilè di bungela. I walad banal là munge i bunge grép, na i samfinit là munge i bunge fig. ");
INSERT INTO bps_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Salngad én, i fye kayu, munge fye, na i sasè kayu, munge sasè. ");
INSERT INTO bps_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I fye kayu là gambunge sasè, na i sasè kayu là gambunge fye. ");
INSERT INTO bps_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na gukel kdee kayu là munge fye, nbek na ntam. ");
INSERT INTO bps_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Taman én gudmilèyu i dad ise glut tugad Dwata fagu di dad sasè nimòla. ");
INSERT INTO bps_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Di kdee dad to tamlo deg, ‘Amu,’ là ku i kdeela gfusuk di kagot Màgu di langit. Én alò gfusuk i dad to mimen i knayean. ");
INSERT INTO bps_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Di kakel i duh kukum kadang, dee dad to fakdo di deg, manla, ‘E Amu, làmi kè tdò i Tnalù Dwata, na fagu di dagitam falwàmi dad busaw, na gamgimò gami i dee tnikeng.’ ");
INSERT INTO bps_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kabay én mangu di dale, ‘Làta gamu dilè. Fawag gamu di deg, du gamu dad to mimò sasè.’ ");
INSERT INTO bps_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na taman kat to mlinge i dad tdògu na mimen dun, salngad ale di to too fulung faldam du déén gufdakan gumnean di bong batu. ");
INSERT INTO bps_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na kel i bong ulen, na dmunuk na mbal i bong nus fsalu di gumnean, bay laan fugen du déén gugafdak i dad lahan di tah batu. ");
INSERT INTO bps_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kabay kat to mlinge i tdògu, bay là mimen dun, salngad kenen di satu to là fulung faldam du déén gufdakan gumnean di falak. ");
INSERT INTO bps_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na kanto mulen na dmunuk na mbal i bong mgal nus fsalu di gumnean, tatì fugen na mti malbà.” ");
INSERT INTO bps_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na kafnge kman Dyisas ani too tikeng i kdee dad to di katdoan, ");
INSERT INTO bps_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","du too nun glalan di katdoan, là salngad di katdò i dad tamdò i dad flalò blé Dwata fagu di ku Mosis. ");
INSERT INTO bps_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na di kasol Dyisas mdà di bulul gutamdoan, too dee dad to mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na nun satu lagi tanfig fdadong di kenen, na lkuad di munan, manan, “Amu, ku beg ge mayè gaganam fgulê deg di tduk fagsik deg ani.” ");
INSERT INTO bps_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na nagot Dyisas kenen, manan, “Mayè agu sa. Mgulê ge nan.” Na too glut, tamgulê i tfigan. ");
INSERT INTO bps_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na man Dyisas di kenen, “Nangam tulen ani di balù simto to, bay én nimoam mdà ge, na fitem laweham di bà di Dwata na nebem di kenen i dsù di Dwata fgadè ku Mosis, du én i gugmadè i dad to too glut tamgulê ge.” ");
INSERT INTO bps_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na salu Dyisas di lunsud Kafernaum. Kakelan déén nun satu kafitan dad sundalu mdà di banwe Roma smite kenen du mni tabeng, ");
INSERT INTO bps_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","manan, “Amu, én lifangu tatì milè di gumnègu du là galyak lawehan na too sasè kaflayaman.” ");
INSERT INTO bps_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na man Dyisas di kenen, “Salu agu ditù du fye fangulêgu kenen.” ");
INSERT INTO bps_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kabay man i kafitan, “Amu, là agu gablà ku fusuk ge di gumnègu. Alò ge talù na mgulê i lifangu. ");
INSERT INTO bps_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gadègu ani, du balù agu mdanà di dad mdatah ganlal, nun sa dad sundalugu mdanà fa di deg, na ku nun dekgu mdà, mdà sa. Na ku dekgu salu dini, na gasil salu dini. Na ku nun dekgu lifangu mimò balù i tan déén, nimoan. Mdatah fa ge, ku nun manam, mgimò sa.” ");
INSERT INTO bps_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kaklinge Dyisas i manan, too kenen tikeng, na man Dyisas di dad to mlalò kenen, “Tulengu gamu i kaglutan, landè fa to teengu di bel Israél salngad ani i bong kafaglutan. ");
INSERT INTO bps_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na ani mangu gamu, kadang di fulé duh, nun dee dad to ise Dyu kel mdà di klamang banwe, mdà di gusut i duh na di gusdafan, na kmaan ale di saféd ale Abraham, Isaak, na Dyékob di kagot Dwata di langit. ");
INSERT INTO bps_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kabay dee dad Dyu gakuf moon di kagot Dwata du bel Israél, bay balingan ale bat di lwà di gukmifun, déén di gumlanula na gukminggat i kifanla.” ");
INSERT INTO bps_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na lêman talù Dyisas di kafitan dad sundalu, manan, “Fakay ge mulê, du tamgimò i fnaglutam.” Na glut sa, du salngan di kman Dyisas dun, tamgulê i lifan kafitan i dad sundalu. ");
INSERT INTO bps_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kafnge én salu ale Dyisas di gumnè Fiter. Di kfusukan teenan i tewe Fiter libun milè déén du too minit i lawehan. ");
INSERT INTO bps_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na fdadong Dyisas na nagotan i kmalan, na magwè i initan. Na gasil kenen mték, na fles mlé kenen knaan. ");
INSERT INTO bps_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na di kasdaf i duh, nebe i dad to di ku Dyisas dee dad to nun busaw, na falwaan i dad busaw fagu alò di taluan na fanguléan i kdee nun tduk. ");
INSERT INTO bps_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I nimò Dyisas ani dunan i gman Isaya, i tugad Dwata, manan, “Kenen mwè dad lyaloito, na fgulê dad tdukito.” ");
INSERT INTO bps_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na di satu duh, teen Dyisas too dee dad to stifun di safédan, taman manan di dad gal mlalò kenen, “Mifal ito i lanaw.” ");
INSERT INTO bps_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na di là ale fa mdà nun satu to gal tamdò dad flalò blé Dwata fagu di ku Mosis fdadong di kenen, na manan, “To Tamdò, magin agu ge balù nè gusalum.” ");
INSERT INTO bps_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na man Dyisas di kenen, “Fandamam i kalima di klalò deg, du i dad tuyun, nun ilib gumulêla, na dad anuk di bnas, nun fulalla, bay deg, i dnagit Tingà To, balù gumilègu, landè.” ");
INSERT INTO bps_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na nun satu to gal mlalò ku Dyisas, manan di kenen, “Amu, faloham agu mulê funa du lbanggu mà.” ");
INSERT INTO bps_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kabay man Dyisas, “Bayaam i tamati. Én lambang dun i dad to mati, i dad to là fa gamfun nawa landè sen. Kabay ge, fles ge mlalò deg.” ");
INSERT INTO bps_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na kafnge én, myak Dyisas di aweng na magin dad to gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na di kifalla i lanaw nkel ale i bong mgal nus di talà na maglam lwek i awengla, na fan fnò yéél. Kabay Dyisas, kudang. ");
INSERT INTO bps_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Taman fdadong dad mlalò kenen, du nukatla, manla, “E Amu, tnabengam gami! Tafan ito galnab, mlimas ito kadang!” ");
INSERT INTO bps_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na man Dyisas, “Kan ku likò gamu? Tukay kadì i ksaligyu.” Na tadag kenen na nngakan i nus na dad lwek, na mbaling too lanél i lanaw. ");
INSERT INTO bps_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kite dad lagi én, too ale tikeng, na sasalek ale, manla, “Tan bung to ani? Balù nus na lwek mimen kenen.” ");
INSERT INTO bps_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kakel ale Dyisas di banwe Gadara di faltù i lanaw, nun gsitongan lwe lagi nun busaw. Lamwà ale mdà di dad ilib gulambang i dad to. Na too ale labè, na taman landè to gal magu déén. ");
INSERT INTO bps_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na di ksitongla ku Dyisas mkit ale, manla, “Ge Tingà Dwata, tan i kiboam gami? Salu ge dini kè, du fanlayamam gami balù ise fa bangan?” ");
INSERT INTO bps_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na nun dee dad sdè nifat samwel mdadong déén. ");
INSERT INTO bps_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na fakdo i dad busaw, manla, “Ku falwaam gami, dekam gami fusuk di dad sdè ditù.” ");
INSERT INTO bps_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na man Dyisas, “Na, ditù gamu.” Taman lamwà ale di lwe to én, na fles fusuk di dad sdè. Na i kdee dad sdè mti mila masol di bilil na gtufa di lanaw, na sdulê mlimas. ");
INSERT INTO bps_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Di kite i dad to mifat i dad sdè ani, mila ale salu di lunsud, na tulenla kdee mgimò di dad sdè na di dad lagi nun busaw. ");
INSERT INTO bps_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na kdee dad to mdà di lunsud mlinge ani, salu ale ditù di ku Dyisas. Di kitela kenen fakdo ale fye ku tnagakan i banwela. ");
INSERT INTO bps_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na myak ale Dyisas lêman di aweng du salu di faltù i bong lanaw, du samfulê kenen di banwe galan gumnè. ");
INSERT INTO bps_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kulê Dyisas nun dad lagi kel. Nun nebela di kenen i to là galyak lawehan, milè di igeman. Na di kite Dyisas i bong kafaglutla di kenen, manan di to là galyak, “E Tò, fangalam i nawam. Tamaglifet dad salaam.” ");
INSERT INTO bps_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Di kaklinge i dad tamdò dad flalò blé Dwata fagu di ku Mosis i man Dyisas, manla di ktola, “Tay, to ani, falmon dengeg Dwata di gmanan én.” ");
INSERT INTO bps_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kabay gadè Dyisas i kdee mnè di fandamla, na manan di dale, “Kan ku sasè i fandamyu? ");
INSERT INTO bps_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nè i too malima man, ‘Maglifet i salaam,’ ku demen, ‘Tadag ge na magu?’ Salngad sa, du slame alò Dwata gmagan mimò dun. ");
INSERT INTO bps_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Taman fangulêgu to ani, du fye gadèyu agu, i dnagit Tingà To, nun glal di tah tanà ani mlifet dad salà i dad to.” Taman man Dyisas di to là galyak, “Tadag ge, nweam i gumileam, na mulê ge.” ");
INSERT INTO bps_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na glut, tadag i to én na mulê. ");
INSERT INTO bps_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Di kite i kdee dad to i nimò Dyisas, likò ale na dnayenla Dwata, du tablén i bong gnagan ani di satu to. ");
INSERT INTO bps_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kafnge én, mdà ale Dyisas na slengla magu nun teenan satu lagi dnagit ku Matyu sudeng di lam i gumimò i dad to gal mwè bayad buhis. Na man Dyisas di kenen, “Mlalò ge deg.” Na tadag Matyu na fles mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na kmaan ale Dyisas di gumnè Matyu. Di slengla kmaan nun kel dademe dad gal mwè bayad buhis na dademe gal mlafà dad flalò fnaglut dad Dyu na sudeng du kmaan di safédla. ");
INSERT INTO bps_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na nun dad to mdà di fnaglut Farisi mite kenen na snalekla dad to gal mlalò ku Dyisas, manla, “Kan ku kmaan Dyisas di saféd i dad to gal mwè bayad buhis na dademe to gamsalà?” ");
INSERT INTO bps_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na di klinge Dyisas i manla, tnimelan ale fagu di fléd, manan, “Hae, du i dad to nun tduk nun kamu i to mulung, bay i dad to landè tduk landè gukmamu i to mulung. ");
INSERT INTO bps_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na tooyu fandam i gumtatek i man Dwata ani, ‘Ise ku én toogu knayè i kabléyu dsù, bay én toogu knayè i kakdoyu i demeyu to.’ Na ise ku én duengu salu dini du fanngabalgu dad to tlu du fsalgu di dad salàla, bay dad to gamsalà i fanngabalgu.” ");
INSERT INTO bps_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kafnge én, nun di dad to gal mlalò ku Dyan Gal Munyag salu di ku Dyisas. Na smalek ale, manla, “Gami na i dad Farisi gal fwasa. Kan ku là fwasa i dad mlalò ge?” ");
INSERT INTO bps_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na tmimel Dyisas fagu di fléd, manan, “Ku fkahta di kasdeme, fwasa kè i dad to malò i kasdeme ku déén fa i lagi sandeme di safédla. Là sa. Salngad én i dad mlalò deg, bay nun duh kadang nwè di dale i lagi sandeme, na én i bangla fwasa.” ");
INSERT INTO bps_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na man Dyisas, “Tagadeito sasè ku klafang i falami safut di labi klaweh tabaltok, du i falami klafang kamsang na matnù baling kbong kasê i klaweh. ");
INSERT INTO bps_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Na salngad én, là fakay fkah i falami binu kmadok fa di lam i labi gufkah kindal, du btù sa, na mkok i binu na malmo i gufkah kindal. Taman én fye gufkah i falami binu di falami kindal, du fye là malmo.” ");
INSERT INTO bps_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Di sleng Dyisas talù ani nun salu di kenen satu ganlal i dad Dyu, na lkuad di muna Dyisas, manan, “Tlabo ani kafto nawa tingàgu libun, bay beg ge magin deg ditù na nagotam kenen du fye mto lêman.” ");
INSERT INTO bps_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Taman tadag Dyisas magin kenen na lê magin i dad gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na di kagula nun satu libun déén too maflayam mdà di tdukan, tatì maloh i tienan. Sfalò lwe fali klon lamyalo dun. Na fdadong kenen di kagol Dyisas, na nagotan i kilil klawehan, ");
INSERT INTO bps_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","du manan di kton, “Ku alògu gagot i klaweh Dyisas mgulê agu.” ");
INSERT INTO bps_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na di kagotan i klawehan falê Dyisas na teenan libun én, na man Dyisas, “Tingàgu, fangalam nawam, du mdà di kafaglutam tamgulê ge.” Na mdà di bang én, mgulê kenen. ");
INSERT INTO bps_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na di kakel ale Dyisas di gumnè i ganlal dad Dyu teenan dad to samlali gal magin lambang na dademe to madung too mlanu déén, ");
INSERT INTO bps_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","na manan di dale, “Lamwà gamu. Là mati i tingà, bay alò kudang.” Na toola kenen nulé. ");
INSERT INTO bps_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na di takalwà i dad to, fusuk Dyisas di gumilè i tingà, na nagotan i kmalan na mték kenen. ");
INSERT INTO bps_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na too mbel i santulen gablà di mgimò Dyisas di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na mdà ale Dyisas di banwe atù, na slengla magu nun lwe lagi butè tmadol ku Dyisas. Tlola kenen, manla, “E bel Harì Dabid, begam gami kando.” ");
INSERT INTO bps_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na di kagfusuk ale Dyisas di satu gumnè magin i lwe to butè, na snalekan ale, manan, “Faglut gamu kè gagangu fgulê gamu?” Manla, “Hae Amu.” ");
INSERT INTO bps_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na nagot Dyisas i matala, na manan, “Fagu di kafaglutyu mgulê gamu.” ");
INSERT INTO bps_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na mite ale lêman. Kabay fnang Dyisas dale, manan, “Nang gamu tmulen di balù simto to i mgimò di gamu ani.” ");
INSERT INTO bps_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kabay knean balingla santulen i mgimò Dyisas di klamang banwe. ");
INSERT INTO bps_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na di takdà i dad to én gine, nun dademe to kel mebe di ku Dyisas i satu lagi umu mdà di knè i busaw di kenen. ");
INSERT INTO bps_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na kafnge Dyisas falwà i busaw, gtalù sa. Na too tikeng i dad to, na manla, “Landè fa lmen teen i dad to gambet ani dini di banwe Israél.” ");
INSERT INTO bps_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kabay én baling man i dad Farisi, “Én mlé kenen gnagan falwà i dad busaw dunan Satanas i gumdatah i dad busaw.” ");
INSERT INTO bps_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kafnge én, magu Dyisas di kdee dad syudad na malnak banwe du tamdò kenen di dad gal gusatdò dad Dyu na santulenan i Fye Tulen gablà di kagot Dwata, na fanguléan dad to di kdee bung tduk. ");
INSERT INTO bps_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Di kite Dyisas i kdee dad to, toon ale kando du too ale maflayam na mlungay, salngad i dad bilibili landè to mifat dale. ");
INSERT INTO bps_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Taman manan di dad gal mlalò kenen, “Tadee dad to gatlagad dmawat i Fye Tulen. Salngad ale dnaru fali too mabal gablà kantu. Kabay kulang i dad kamtu. ");
INSERT INTO bps_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Taman dmasal gamu di Amuito Dwata, i mfun i fali, na fniyu ku dekan kamtu i dademe dad to.” ");
INSERT INTO bps_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na tlo Dyisas dad sfalò lwe gal mlalò kenen salu di safédan na banlén ale glal falwà dad busaw na fgulê i dad to di kdee bung tduk. ");
INSERT INTO bps_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na ani dad dagit i sfalò lwe to galan dek, Simon i dnagitan ku Fiter, Andru i flanek Simon, Dyém, na i flanekan Dyan i dad ngà Sébidi, ");
INSERT INTO bps_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filif, Bartolomyu, Tomas, Matyu i gal mwè bayad buhis, Dyém i tingà Alfyus, Tadyus, ");
INSERT INTO bps_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon i msen di banwen, na Dyudas Iskariyot i to mangkal kenen. ");
INSERT INTO bps_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na di kdek Dyisas i sfalò lwe dad to ani fanlaun ale, manan, “Nang gamu salu di dad to ise Dyu ku demen di dad banwe glam di Samériya. ");
INSERT INTO bps_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kabay én gusaluyu di dademeyu dad bel Israél, du salngad ale i dad bilibili tatlas. ");
INSERT INTO bps_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na di kaguyu, tamdò gamu, manyu, ‘Tamdadong nan i kagot Dwata.’ ");
INSERT INTO bps_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Na fangulêyu i dad to nun tduk, ntékyu i dad to mati, fangulêyu dad tanfig na falwàyu dad busaw. Nangyu fbayad i tabengyu dad to du i kdee gdawatyu mdà di Dwata laan fbayad gamu. ");
INSERT INTO bps_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kabay nang gamu mebe filak balù blawen, salafì ku demen tabaga. ");
INSERT INTO bps_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na di kaguyu nangyu nebe kuyut ku demen tugad. Na én alò saul na talumfà nebeyu i tagnè lsakyu du i to nun nimò gablà banlé i gulandean. ");
INSERT INTO bps_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na balù nè syudad ku demen tukay banwe gukelyu di kaguyu mngabal gamu i to mgafè i mayè fyak gamu di gumnean, na déén gumilèyu kel di kdàyu i banwen. ");
INSERT INTO bps_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na di kyakyu di gumnean manyu di dad to déén, ‘Fye ku i ktanak nawa mnè di gamu.’ ");
INSERT INTO bps_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na ku dnawatla gamu, mnè sa di dale ktanak nawa nebeyu, bay ku làla gamu dnawat gulê di gamu i fye gmanyu. ");
INSERT INTO bps_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na ku nun dad to là dmawat gamu na là flinge i tdòyu, kakesyu kfung i blìyu di kdàyu di gumnèla ku demen banwela. ");
INSERT INTO bps_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na tulengu gamu i kaglutan, di duh kukum Dwata dad to, balù too maflayam dad to sasè mdà di dad banwe Sodom na Gomora, mdatah fa kaflayam i dad to di banwe tnagakyu.” ");
INSERT INTO bps_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Na man Dyisas, “Flinge gamu! Dekta gamu di dad to mayè fsasè gamu. Salngad gamu bilibili gbol di dad labè ayem di bnas. Taman ganbetyu dad ulad too fulung meye i kagula, na ganbetyu dad abun too nun ldamla du fye landè gudmalam gamu. ");
INSERT INTO bps_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Hae, fafye gamu, du nun kadang dad to kamfè gamu, du nebela gamu di usay di dad mdatah ganlal, na sankélla gamu di lam i galla gusatdò. ");
INSERT INTO bps_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na mdà di ksasatuyu di deg nebela gamu di muna i dad mdatah mukum, én gubirnador na balù i harìla. Kabay én sa i dalanyu samtulen di dale na di dad to ise Dyu i Fye Tulen gablà di deg. ");
INSERT INTO bps_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na di kakfèla gamu nangyu fsamuk nawayu gablà di dad timelyu dale na i fye kmanyu dun, du di bang ktadagyu déén blé Dwata di gamu i fye timelyu. ");
INSERT INTO bps_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Du ise mdà di gamu fandam i dad manyu kadang, bay mdà di Tulus Màyu Dwata. ");
INSERT INTO bps_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na di bang én kadang, én nimò i dademe to bléla di fati balù i dad flanekla, na i dad mà bléla dad ngàla. Na i dademe dad ngà dnuenla dad tuala na fafatila. ");
INSERT INTO bps_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na knang gamu nawa i kdee dad to du gamu dad togu. Kabay ku simto gamtayud kel di gusenan, galwà kenen. ");
INSERT INTO bps_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na ku fanlayamla gamu di satu banwe mila gamu di dademe, du tulengu gamu i kaglutan, di là fa fnge i nimòyu di kdee dad banwe di Israél, takel agu i dnagit Tingà To. ");
INSERT INTO bps_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“I to tdò là mdatah di to tamdò kenen, na i lifan là mdatah di amun. ");
INSERT INTO bps_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Taman nang gamu tikeng ku sasè kibòla gamu salngad deg. Gablà ku salngad kibòla i dad to tdò di to tamdò dale na ku salngad kibòla i dad lifan di amula. Ku én katlola deg Bélsébul, dunan Satanas, tan fa ksasè katlola gamu dad togu. ");
INSERT INTO bps_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kabay balù én nang gamu likò dale, du i kdee gbuni, teen sa kadang, na i kdee là gadè di bang ani, gadè sa kadang. ");
INSERT INTO bps_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","I kdee tatulengu gamu di alò gito, tulenyu kadang di kdee dad to. I taungaggu di gamu, kityu kadang di kdee dad to di lwà. ");
INSERT INTO bps_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na nang gamu likò i dad to, du alò lawehyu i gfatila, bay làla gfati i layefyu. Kabay én kanlikòyu Dwata i to gafalmo i lawehyu na layefyu di lanaw lifoh. ");
INSERT INTO bps_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Fandamyu sa kun i kalsidaw galla fabli lwe bnayad alò file kadakù, bay silang tatek satu di dale ku faloh i Màyu Dwata. ");
INSERT INTO bps_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na gamu dad to, balù file balu wakyu, tagse Dwata kdeela. ");
INSERT INTO bps_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Taman nang gamu likò du di Dwata too gamu mabtas fa di dad kalsidaw. ");
INSERT INTO bps_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Na balù simto to mfun deg di muna i dad to, nfungu di muna i Màgu di langit. ");
INSERT INTO bps_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kabay i to là mfun deg di muna i dad to, làgu kenen nfun di muna i Magu di langit. ");
INSERT INTO bps_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nangyu fandam ku én duengu salu dini di tah tanà du mebe agu ksasatu nawa. Ise ku ksasatu nawa i nebegu dini, bay én nebegu sundang du baling snang nawa i dad to mdà di deg. ");
INSERT INTO bps_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mdà di ksalugu dini snang nawa i tingà lagi na maan, na i tingà libun na yêan, na i libun tmewe na tewen libun. ");
INSERT INTO bps_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na i too mnang nawa i dad togu kadang, dunan i dademela di gumnèla. ");
INSERT INTO bps_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na i to mbong nawan maan na yéan mdatah fa di kalbong nawan deg, là gablà nfungu, na salngad i to mbong nawa i tingaan mdatah di kalbong nawan deg, là gablà nfungu. ");
INSERT INTO bps_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na ku nun to là mebe i krusan na too mlalò deg, là gablà nfungu. ");
INSERT INTO bps_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kabay i to kmabas i nawan, knean lana di kenen. Kabay i to mati mdà di klaloan deg, gamdawat nawan landè sen. ");
INSERT INTO bps_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Na balù simto i dmawat gamu dnawatan agu. Na ku simto dmawat deg dnawatan i Màgu Dwata i mdek deg. ");
INSERT INTO bps_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na ku simto dmawat i tugad Dwata, mdà di kdek Dwata kenen, salngad untung gdawatan di gdawat i tugad Dwata. Na salngad én, ku simto dmawat i to matlu du mdà di katlun, salngad untungan di to matlu. ");
INSERT INTO bps_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na tulengu gamu i kaglutan, nun untung di fulé duh i to mlé balù alò satu basu yéél tno di satu mdanà to du kenen satu to mlalò deg.” ");
INSERT INTO bps_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kafnge Dyisas tamdò i dad sfalò lwe to gal mlalò kenen, mdà kenen du tamdò di dademe banwe mdadong déén. ");
INSERT INTO bps_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Dyan Gal Munyag, tabnilanggù kenen, na di kaklingen gablà di dad mgimò Krayst dekan dademe dad gal mlalò kenen di ku Dyisas, ");
INSERT INTO bps_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","du fsalekan ku Dyisas, manan, “Ge kè i to dek Dwata dini i sanfatanmi ku nun fa dademe fatanmi?” ");
INSERT INTO bps_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tmimel Dyisas, manan, “Samfulê gamu di ku Dyan na tulenyu kenen i kdee lingeyu na teenyu dini. ");
INSERT INTO bps_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mite i dad butè, gagu i dad kimay, landè ksik i dad to tanfig du mgulê, mlinge i dad bakong, mto lêman i dad mati, na tatulen di dad to landè i Fye Tulen mdà di Dwata. ");
INSERT INTO bps_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na manyu di ku Dyan, too nun kafye di dad to ku là lwe nawala di kafaglutla di deg.” ");
INSERT INTO bps_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na di kdà i dad to dek Dyan, tambù Dyisas talù di dad to déén gablà di ku Dyan, manan, “Di ksaluyu ditù di ku Dyan déén di banwe landè to mnè déén, tan i kayèyu teen? Ise sa ku én neyeyu kalon wal i nus. ");
INSERT INTO bps_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na du ise én, ken én taneyeyu satu to too fye klaweh. Kabay ise én kè, du dad to kamlaweh i too fye klaweh mnè di dad malbang gumnè i dad harì. ");
INSERT INTO bps_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na du ise én, tan sa neyeyu? Én kè neyeyu satu tugad Dwata? Na glut, satu tugad Dwata kenen, bay tulengu gamu, mdatah fa nimò Dyan di dademen tugad Dwata, ");
INSERT INTO bps_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","du Dyan ani i to gman Dwata di Tnaluan, manan, ‘Dekgu i saliggu muna di ge, du fatlagad i dalanam na fgadè i kakelam.’ ");
INSERT INTO bps_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na tulengu gamu i kaglutan, landè fa to lmen sut gasngad di kdatah Dyan Gal Munyag, bay balù mdatah Dyan di kdee dad to kel i ani, ku simto to gakuf di kagot Dwata, balù kel di too mdanà to faglut di deg, mdatah fa di ku Dyan. ");
INSERT INTO bps_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na tambù fa di katdò Dyan Gal Munyag kel ani too teen kgal kagot Dwata. Na dad to labè, too ale fgal fye gfusuk ale. ");
INSERT INTO bps_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hae, du i kdee Tnalù Dwata fagu di dad tugadan na i flaloan fagu di ku Mosis, toola santulen i kagot Dwata kel di bang Dyan ani. ");
INSERT INTO bps_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ku mayè gamu faglut i manla, tagadèyu moon i to salngad ku Ilaydya sanfatanito dunan Dyan. ");
INSERT INTO bps_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Taman flinge gamu ku nun klingeyu!” ");
INSERT INTO bps_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na fadlug Dyisas tamdò, manan, “Na tan guflingengu i dad to di bang ani? Flingengu ale di dad ngà sudeng di fadyan. Là ale mayè magin i dademela magaf, du tamlo dademe, manla, ");
INSERT INTO bps_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tamalandag gami i lingag i kasdeme, bay là gamu sayew. Na lingagmi i lingag kalbang, bay là gamu mngel.’ ");
INSERT INTO bps_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Salngad én i ksalu Dyan dini, gal kenen fwasa na là minum binu, bay là ale mayè na balingla man, kun, ‘Tabnusaw kenen.’ ");
INSERT INTO bps_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na agu, i dnagit Tingà To, salu agu dini na kmaan na minum, na én manla, kun, ‘Neyeyu i to ani, tyan kenen na gal flangal. Na i dademen sgalak, dunan i dad sasè to gal mwè bayad buhis na i dad to gal mlafà i flalò Dwata.’ Én manla, bay i gumiteyu na i nimò satu to mdà di kfulung Dwata, di ulê i nimoan.” ");
INSERT INTO bps_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na nngak Dyisas i dad to mdà di dad banwe gumimoan i dee tnikeng, du là ale fa msal di dad salàla, manan, ");
INSERT INTO bps_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Magakdo gamu dad to di banwe Korasin! Na gamu di banwe Bétsayda! Ku tateen i dad to ise Dyu di dad banwe Tiro na Sidon i dad tnikeng tanimògu déén di gamu, tamlo ale msal na lamsak i saku, na mubul i abu di ulula mdà di klidùla dad salàla, bay gamu là sa msal! ");
INSERT INTO bps_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taman mangu di gamu ani, balù blat kaflayam i dad to mdà di Tiro na Sidon, mlaan fa di gamu kaflayam di duh kukum Dwata. ");
INSERT INTO bps_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na gamu dad to di banwe Kafernaum, mayè gamu fdatah i ktoyu kel di langit. Kabay fan bat gamu baling di lanaw lifoh. Ku tateen i dad to sasè di banwe Sodom i dad tnikeng tanimògu déén di gamu, là malmo banwela kel ani. ");
INSERT INTO bps_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Taman mangu di gamu ani, balù blat kaflayam i dad to mdà di Sodom, mlaan fa di gamu kaflayam di duh kukum Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na di bang én dmasal Dyisas, manan, “E Mà, Amu magot i langit na tanà, mlé agu fye di ge du i bunim di dad to too fulung na i dad to mdatah gnadè, tafitem di dad to mdanà salngad i dad malnak ngà. ");
INSERT INTO bps_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hae Mà, mgimò ani, du ani knayeam.” ");
INSERT INTO bps_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na man Dyisas di dad to, “Tasalig Mà di deg i kdee. Na landè gmadè i Tingà Dwata, galwà di Maan. Na landè gmadè i Maan galwà di Tingaan na dad to kayègu gufgadè kenen.” ");
INSERT INTO bps_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“I kdeeyu mlungay mdà di blat nebeyu salu gamu di deg na banléta gamu kaftud. ");
INSERT INTO bps_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nimenyu i tdògu na ganbetyu agu, na nun sa kaftudyu du too nun kakdogu na kafdanà i ktogu. ");
INSERT INTO bps_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Là malima i flalògu gamu, na là blat i fimògu.” ");
INSERT INTO bps_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kafnge én, di satu Duh Kaftud i dad Dyu magu ale Dyisas di dalan di satu nligo. Na bitil dad gal mlalò kenen, taman di slengla magu beg ale kambang là dee dad kigan trigu, du knilewla. ");
INSERT INTO bps_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kabay di kite i dad Farisi i nimòla, manla di ku Dyisas, “Neyem i nimò dad gal mlalò ge! Nlafàla i flalò blé Dwata fagu di ku Mosis du baling ale kamtu di Duh Kaftud.” ");
INSERT INTO bps_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kabay tmimel Dyisas, manan, “Kan kè? Làyu lmen masa i nimò Harì Dabid du mdà di kbitilan na kbitil i dademen? ");
INSERT INTO bps_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Là kenen fansalà Dwata balù fusuk kenen di Gumnè Dwata na nwean i fan blé di Dwata, na blén di dad ton, na kdeela kmaan. Na blaam én alò fakay kmaan dun i dad baito di Dwata. ");
INSERT INTO bps_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na làyu kè lmen masa i sulat Mosis gablà di dad baito di Dwata mimò di Bong Gumnean klit Duh Kaftud, na landè salàla di klafàla i flalò Dwata gablà di Duh Kaftud. ");
INSERT INTO bps_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na ani mangu di gamu, nun to dini di munayu mabtas fa di Bong Gumnè Dwata. ");
INSERT INTO bps_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ani man di Tnalù Dwata, ‘Ise ku dsù lmanaf i knayègu, bay kasakdo.’ Ku glabatyu ani làyu moon dnalam i dad to landè salà, ");
INSERT INTO bps_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","du agu, i dnagit Tingà To, i nun glal mangman i fakay nimò di Duh Kaftud.” ");
INSERT INTO bps_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na mdà Dyisas na fles fusuk di gal gustifun dad Dyu. ");
INSERT INTO bps_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na nun lagi déén kengkeng bali kmalan. Na nun dad to déén meye dalanla dmalam ku Dyisas di salà, taman snalekla kenen, manla, “Fakay dé di flalò Dwata ku fangulê i to nun tduk di Duh Kaftud ku là?” ");
INSERT INTO bps_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kabay tmimel Dyisas dale, manan, “Ku nun bilibiliyu mtatek di mngalam sol di Duh Kaftud tan i nimòyu? Làyu kè falwà dun balù fa di Duh Kaftud? ");
INSERT INTO bps_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na too mabtas fa i to di bilibili! Taman snalekgu gamu, fakay dé di flalò Dwata ku tnabengito i demeito to di Duh Kaftud ku là?” ");
INSERT INTO bps_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kafnge én, man Dyisas di to kengkeng i kmalan, manan, “Bankem i kmalam.” Na banken. Na mgulê i kmalan na tasalngad di balin. ");
INSERT INTO bps_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kitela ani lamwà dad Farisi du stulen ku tan kfagula mati ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na du gadè Dyisas i ayè dad Farisi mati kenen, taman mdà kenen di banwe én. Kabay too dee dad to mlalò kenen na fanguléan i kdee dad to déén i nun tduk. ");
INSERT INTO bps_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kabay fnangan ale tmulen di dademe dad to ku simto kenen. ");
INSERT INTO bps_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I nimò Dyisas ani i kagdohò i gman Dwata fagu di tugadan Isaya, manan, ");
INSERT INTO bps_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ani saliggu tamgalékgu, toogu kenen kando na too fye nawagu kenen. Fnègu di kenen i Tulusgu, na fgadean di kdee dad to i kukumgu too matlu. ");
INSERT INTO bps_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na là kenen samdal dad dmuen kenen ku demen faltê, na laan falbong i taluan di dalan. ");
INSERT INTO bps_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I dad to mnè di klungay tnabengan; ku fkahta di law tabluk laan fles tanfò, na i salò fan mati laan fles fnati. Fantahaan i nawan, kel di bang katu i tlu nimò di kdee sasè. ");
INSERT INTO bps_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na nun fanden i dad to di klamang banwe du mdà di kenen.” ");
INSERT INTO bps_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na nun satu to nebela di ku Dyisas butè na umu du nun busawan, bay fanguléan kenen taman gtalù na mite. ");
INSERT INTO bps_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na too tikeng i kdee dad to na sasalek ale, manla, “Kenen dé i bel Harì Dabid galito fatan?” ");
INSERT INTO bps_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kabay di kaklinge dad Farisi ani, manla, “Ise! Gaganan falwà dad busaw fagu alò di tulus Bélsébul, i gumdatah dad busaw.” ");
INSERT INTO bps_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na gadè Dyisas i fandamla, taman manan dale, “Ku fkahta di kagot i satu harì ku sunay ale i dad ton, malmo baling i kagotan dale. Salngad ku fkahta di satu syudad ku demen di satu malay ku sfati slame ale, malmo baling i ksasatula. ");
INSERT INTO bps_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na ku glut i manyu na Satanas i fafalwà dad busaw nagotan, na snang ale nawa kadì, na là kè malmo i kagotan? ");
INSERT INTO bps_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na ku glut, Bélsébul i gumdà tulusgu falwà dad busaw, simto kè gumdà tulus i dad mlalò gamu gal falwà dad busaw? Gadèyu i tulusla mdà di Dwata, na én sa gugmadèyu gsalà i manyu gablà di deg. ");
INSERT INTO bps_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Taman du én kafalwàgu dad busaw mdà di Tulus Dwata, én sa i gugmadèyu takel i kagot Dwata di dad to. ");
INSERT INTO bps_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Tafnisangu Satanas du landè to fakay fusuk di gumnè i mgal to du mwè i knunan ku laan funa kenen bnakus, bay ku tabnakus fakayan nwè balù tan kayean di gumnè i mgal to. ");
INSERT INTO bps_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Balù simto to là msen deg, dmuen deg, na balù simto to là tmabeng samtifun i dad to, balingan ale sanbalét. ");
INSERT INTO bps_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Taman mangu di gamu fakay nlifet balù tan salà i dad to na balù tan sasè manla gablà di Dwata, bay ku nun to falmo dengeg i Mtiu Tulus fagu di ktaluan là nlifet Dwata i salaan. ");
INSERT INTO bps_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I to talù sasè gablà di deg, i dnagit Tingà To, fakay nlifet, bay i to talù sasè gablà di Mtiu Tulus là maglifet salaan balù duh ani na kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Na manan, “I kayu fye, fye kbungen, bay ku sasè i kayu, sasè kbungen. Én gudmilèyu i kayu ku fye ku demen sasè di kbungen. ");
INSERT INTO bps_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E gamu, gambet gamu ulad du alò sasè i mnè di nawayu. Landè kibòyu talù fye du sasè gamu! Hae, du ku tan i mnè di nawa i satu to, én i lamwà di baan. ");
INSERT INTO bps_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","I fye to, fye lamwà di baan du mdà di dad fye busekan di lam i nawan. I sasè to, sasè lamwà di baan du mdà di sasè busekan di nawan. ");
INSERT INTO bps_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na tulengu gamu, di Duh Kukum Dwata là fakay ku là tmimel kdee to di kenen di kat talùla i landè gukmamu. ");
INSERT INTO bps_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Du ku fye gmanyu laan gamu sa fanlayam. Bay ku sasè gmanyu fanlayaman gamu.” ");
INSERT INTO bps_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kafnge én, nun dad Farisi na dademe dad tamdò i dad flalò blé Dwata di ku Mosis, manla di ku Dyisas, “To Tamdò, kayèmi ku fnitem gami i tnikeng ilè ge i To Mgalék Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kabay tmimel Dyisas dale, manan, “Too sasè i dad to di bang ani. Takmagol ale Dwata na mni fa i tnikeng. Kabay landè tnikeng fite di gamu galwà di tnikeng teenyu kadang gambet gnagu i tugad Dwata Dyona. ");
INSERT INTO bps_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tlu duh na tlu butang klon di lam tien i bong nalaf na salngad én mkel di deg i dnagit Tingà To, du tlu duh na tlu butang mnè agu kadang di lam i tanà. ");
INSERT INTO bps_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Na di Duh Kukum Dwata kadang, tadag dad to mdà di banwe Ninibi du dmalam gamu du i nimòla di muna fa i satu gugmadè na gamu gablà fanlayam, du di kaklingela tdò Dyona msal ale di sasè nimòla, na i tamdò gamu ani mdatah fa di ku Dyona bay là gamu msal. ");
INSERT INTO bps_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na di Duh Kukum, lê tadag i réyna magot i banwe Siba du dmalam gamu dad to di bang ani, du i nimò libun ani di muna fa i gugmadè na gablà gamu fanlayam, du balù too mawag i gumdaan salu kenen di ku Harì Solomon du fye flinge i gnadean. Kabay nun mdatah gnadè di ku Harì Solomon dini di gamu ani, bay là gamu flinge.” ");
INSERT INTO bps_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Na fadlug Dyisas talù, manan, “Ku nun busaw talamwà di satu to, gal kenen magu di dad kafag banwe landè alì to du mngabal i gumanakan. Kabay ku landè teenan, ");
INSERT INTO bps_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","manan di kton, ‘Samfulê agu di tagnè gumnègu.’ Na kakelan di to tagnè gumnean, teenan landè mnè ditù na tamlaneb na maftifas. ");
INSERT INTO bps_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Taman mdà i busaw mngé i dademen, na faginan fitu dad busaw i mdatah fa ksasèla di kenen. Na sdulê ale fusuk na fles mnè di kenen. Taman matnù i ksasè kagkah to én di katbuan di là fa lamwà i busaw. Na ani kadang gukel i dad to sasè di tah tanà di bang ani.” ");
INSERT INTO bps_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Di sleng Dyisas talù fa di dad to déén, takel i yéan na dad flanekan lagi. Tadag ale di lwà du kayèla stulen di kenen. ");
INSERT INTO bps_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na nun to tmulen kenen, manan, “Taditù yéam na dad flanekam tadag di lwà, na mayè ale stulen di ge.” ");
INSERT INTO bps_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kabay tmimel Dyisas, manan, “Hae, bay simto kè yêgu, na simto dad flanekgu?” ");
INSERT INTO bps_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na tdoan dad to gal mlalò kenen, manan, “Ani sa i yêgu na dad flanekgu, ");
INSERT INTO bps_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","du ku simto mimò knayè i Màgu di langit, kenen i mgimò flanekgu lagi, na flanekgu libun na yêgu.” ");
INSERT INTO bps_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Di duh atù lamwà Dyisas na salu kenen di kilil i bong lanaw, na sudeng ditù. ");
INSERT INTO bps_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na du too dee dad to stifun di safédan, taman myak kenen di tah i satu aweng na sudeng kenen déén du tamdò, na tadag i dad to flinge di kilil lanaw. ");
INSERT INTO bps_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na too dee tulenan dale fagu di fléd, manan, “Nun to salu di nligon du smabul bnê. ");
INSERT INTO bps_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na di ksabulan dun, nun dademe gsabul di bà dalan, na fti tnukè i dad anuk di bnas. ");
INSERT INTO bps_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na nun dademe gsabul di gumngifi tanà di tah i batu. Na too mlal ktabòla du babu i tanà. ");
INSERT INTO bps_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kabay di ksut i duh, sakuf i tabòla, na du là alì dmalil mlanas ale. ");
INSERT INTO bps_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na nun dademe bnê gsabul di lam walad nun sual. Na tmabò, bay mlal kalnok i dad bnas, na mlimas i dad tabò i bnê. ");
INSERT INTO bps_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kabay nun dademe bnê sabul di gufye tanà, na too fye kbungen. Nun dademe mlatu uléan, nun nam falò uléan, na nun tlu falò uléan. ");
INSERT INTO bps_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Taman flinge gamu ku nun klingeyu!” ");
INSERT INTO bps_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na fdadong i dad gal mlalò ku Dyisas di kenen, na smalek ale, manla, “Kan du tamdò ge i dademe to fagu di fléd?” ");
INSERT INTO bps_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na tmimel Dyisas, manan, “Faglabatgu gamu dad mlalò deg i dad gbuni gablà di kagot Dwata, bay làgu faglabat dun di dademe dad to. ");
INSERT INTO bps_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Du i dad to nun kaglabat i tdògu, tananù Dwata du fye too bong. Kabay i dad to là fkah dun di nawala, nawì Dwata balù i tukay kaglabatla. ");
INSERT INTO bps_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Taman ani i duengu tamdò dale fagu di fléd du balù meye ale là ale mite, na balù flinge ale là ale mlinge, na là ale gamlabat. ");
INSERT INTO bps_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Én man Dwata fagu di tugadan Isaya tagdohò di dad to ani, du manan, ‘Balù too gamu flinge, knean là gamu gamlabat, na balù too gamu meye, là gamu mite, ");
INSERT INTO bps_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","du i dad to ani, tatoo mgal ulula, na gambet snafangla i klingela, na fnidangla matala, du fye là ale mite na là ale flinge, du ku là, gamlabat ale i kaglutan, na tagakla i dad sasè nimòla, du fye fangulêgu ale di dad salàla.’ ");
INSERT INTO bps_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kabay gamu dad gal mlalò deg, too nun kafye gdawatyu du too mite i dad matayu, na mlinge i dad klingeyu. ");
INSERT INTO bps_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","“Na tulengu gamu i kaglutan, mdà di muna fa too dee dad tugad Dwata na dademe dad to Dwata too mayè mite i tateenyu, bay landè kibòla mite dun, na mayè ale mlinge i lingeyu, bay landè kibòla mlinge dun.” ");
INSERT INTO bps_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na taman flinge gamu i gumtatek i fléd gablà di to smabul bnê. ");
INSERT INTO bps_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ku nun dad to mlinge i tdò gablà di kagot Dwata, bay làla glabat dun, gasil salu Satanas di dale du nwean di nawala i Tnalù Dwata talingela. I kagkah dad to ani salngad i dalan gugsabul dad bnê. ");
INSERT INTO bps_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na i mngifi tanà di tah batu gugsabul i dademe bnê, dunan i dad to too lehew dmawat Tnalù Dwata di kaklingela dun, ");
INSERT INTO bps_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","bay landè gudmalilan di nawala, taman là mlo ktayudla, du di kakel i kalima na kaflayam mdà di kdawatla i Tnalù Dwata, mlal ale tmagak i kafaglutla. ");
INSERT INTO bps_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na i tanà gugsabul bnê i gutmabò dad walad nun sual, dunan i dad to mlinge Tnalù Dwata, bay dee gusbalét i nawala gablà di knèla di tah tanà na i kiballa knun. Taman landè ulê Tnalù Dwata di dale. ");
INSERT INTO bps_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kabay i fye tanà gusmabul i dademe bnê, dunan i dad to mlinge na gamlabat Tnalù Dwata, na too nun uléan di nawala, nun mlatu i uléan, na dademe nam falò, na dademe tlu falò.” ");
INSERT INTO bps_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kafnge én nun tulen Dyisas satu fléd, manan, “Flingengu i kagot Dwata di satu to smabul i too fye bnê di nligon. ");
INSERT INTO bps_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kabay sleng i dad ton kudang, nun satu to mnang nawa kenen salu di nligon na én sabulan déén bnê i bnas na mdà. ");
INSERT INTO bps_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na silangla dilè i dad bnas, di ktabò i fule na tambù lamwà i dad kiganan. ");
INSERT INTO bps_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Na salu i dad salig i mfun i fule di kenen, na manla, ‘Amu, too fye kè i bnê sabulito di nligom taman nè gumdà i dad bnas ani?’ ");
INSERT INTO bps_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Na tmimel i mfun, manan, ‘Nun to mnang nawa deg smabul bnas ani.’ Na smalek ale lêman, manla, ‘Mayè ge kè ku nsòmi i dad bnas ani?’ ");
INSERT INTO bps_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Kabay manan, ‘Bayàyu nsò i dad bnas, ken balingyu gakuf nsò dad fule. ");
INSERT INTO bps_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Falohyu ale salnok kel di bang kamtu du mangu kadang di dad to kamtu, santifunyu funa i dad bnas, na bnatangyu du ntam. Kabay i fye, santifunyu na fkahyu di folgu.’ ” ");
INSERT INTO bps_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kafnge én, tulenan dale satu fléd, manan, “Satu guflingengu i kagot Dwata dunan i tukay bnê fule satu to di nligon. ");
INSERT INTO bps_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Na i bnê én tukay fa di kdee dademe bnê, bay di taktaboan, baling too bong di dademe fule du tamgimò bong kayu gusmalal i dad anuk di bnas di dad fangan.” ");
INSERT INTO bps_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na tnulenan ale i satu fléd, manan, “Satu guflingengu i kagot Dwata dunan i falnok fan nwè i satu libun du bolan di tlu gantang arina, na too masbool na too lamnok.” ");
INSERT INTO bps_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","I kdee tdò Dyisas di dee dad to slame fagun di fléd. Landè tdoan di dale ku laan fagu di fléd. ");
INSERT INTO bps_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I nimò Dyisas ani i kagdohò i gman Dwata fagu di tugadan, manan, “Tamdò agu fagu di fléd, na tulengu i dad gbuni mdà di kimò i banwe.” ");
INSERT INTO bps_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kafnge én, tnagak Dyisas i dee dad to déén, na fusuk kenen di lam i gumnè. Na fdadong i dad gal mlalò kenen, na manla, “Tulenam gami i gumtatek i fléd gablà di dad bnas di tanà i to smabul bnê.” ");
INSERT INTO bps_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Na tmimel Dyisas, manan, “I to smabul i fye bnê dunan agu, i dnagit Tingà To. ");
INSERT INTO bps_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I tanà gusmabul bnê dunan i klamang banwe, na i gumtatek i dad fye bnê dunan i dad to gakuf di kagot Dwata, na i dad bnas dunan i dad to nfun Satanas. ");
INSERT INTO bps_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na i to mnang nawa deg, i smabul i dad bnas, dunan Satanas. Na i bang kaktu dunan i gusen i banwe, na i dad kamtu dunan dad kasaligan Dwata. ");
INSERT INTO bps_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na i kibòla i dad bnas, santifun na snakufla di lifoh, dunan i kibòla kadang di gusen i banwe. ");
INSERT INTO bps_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Agu, i dnagit Tingà To, én nimògu di bang én, dekgu i dad kasaligangu du fye nwèla i kdee gamgebe i dad to di kagsalà na i kdee dad to mimò sasè gbol di dad to di kagotgu. ");
INSERT INTO bps_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na batla ale di too minit lifoh gumlanula na gukminggat i kifanla. ");
INSERT INTO bps_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kafnge én, i dad to matlu di kite Dwata too ale mneng di kagot i Màla Dwata gambet i kneng i duh. Taman fye flinge gamu, ku nun klingeyu! ");
INSERT INTO bps_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Satu guflingengu i kagot Dwata dunan i too mabtas knun lbang di tanà. Kanto gakol satu to, gasilan lbang lêman. Na too lehew i to ani, taman mulê kenen du fablin i kdee knunan fye gbayadan i tanà, du fye gwean i too mabtas knun.” ");
INSERT INTO bps_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Satu guflingengu i kagot Dwata, dunan i satu to gal mayad dad mata tising too mabtas dnagit férlas. Lamngab kenen mngabal dad too fye férlas. ");
INSERT INTO bps_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Di kiten i satu férlas too tatì fye, mulê kenen na fablin i kdee knunan, du bnayadan i too mabtas férlas. ");
INSERT INTO bps_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Satu guflingengu i kagot Dwata lêman, dunan i satu fukut ftatek ditù di bong lanaw gamwè i dee sahal bung nalaf. ");
INSERT INTO bps_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na di kafnò i fukut, dyol i dad to ditù di kilil lanaw, na sudeng ale déén du nalékla dad nalaf. I dad fye nalaf fkahla di lam alatla, na dad sasè batla. ");
INSERT INTO bps_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ani kagkah di gusen i banwe. Salu dini i dad kasaligan dek Dwata na tnanila i dad to sasè di dad to matlu. ");
INSERT INTO bps_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na i dad to sasè, bat ale di too minit lifoh, déén di gumlanula na gukminggat i kifanla.” ");
INSERT INTO bps_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na smalek Dyisas dale, manan, “Taglabatyu kè i kdee mangu gine?” Na tmimel ale, manla, “Hae.” ");
INSERT INTO bps_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Taman manan, “Ku glabatyu, glabatyu i kagkah i to tagnè gmadè i flalò blé Dwata fagu di ku Mosis, na ku lê kenen mlalò i kagot Dwata salngad kenen di satu to too nun knunan di gumnean. Nun labi na nun falami knunan fakayan gumwè ku nun gukmamun dun.” ");
INSERT INTO bps_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Di kafnge Dyisas tmulen dad fléd, tnagakan i banwe én, ");
INSERT INTO bps_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na samfulê kenen di banwe gulamnokan. Na tamdò kenen di gal gusatdò i dad Dyu. Na too tikeng i dad to déén mlinge dun, manla, “Nè gugamwean i gnadean ani? Na nè gumdà kfulungan mimò tnikeng? ");
INSERT INTO bps_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Laito kè dilè to ani? Ani kè tingà karfintiro atù? Ise kè Méri yéan na én dad flanekan Dyém, Dyosif, Simon, na Dyudas? ");
INSERT INTO bps_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na dad flanekan libun dini kè di banweito. Taman nè gumdà i bong kfulungan?” ");
INSERT INTO bps_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na i dad to di banwen, knangla kenen. Kabay man Dyisas di dale, “I tugad Dwata too mgafè balù tanè gugsalun, bay én alò là mafè kenen i dad to di kenen too banwe na di kenen too gumnè.” ");
INSERT INTO bps_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na là dee dad tnikeng nimoan di banwe én du là ale faglut di kenen. ");
INSERT INTO bps_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Di bang én nun linge Harì Hérod, i mdatah ganlal di banwe Galili, gablà di kdee tnikeng nimò Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na manan di dad saligan, “Dyisas ani, dunan Dyan Gal Munyag tamték mdà di fati, na én duen too kenen mtulus.” ");
INSERT INTO bps_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ani manan, du tafakfean Dyan, na fbakusan na fbilangguan du mdà di ku Hérodiyas, yaan i flanekan Filif. ");
INSERT INTO bps_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Fbilangguan du tagal man Dyan di kenen, “Là fakay nlad yaan i flanekam.” ");
INSERT INTO bps_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na kayean moon fnati Dyan, bay likò kenen di dad to, du én fandamla, Dyan satu tugad Dwata. ");
INSERT INTO bps_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kabay kel i duh kafaldam i ksut Hérod, sayew i tingà Hérodiyas libun di muna i kdee dad to malò i fista, na too mayè nawa Hérod meye dun. ");
INSERT INTO bps_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Taman makang kenen di libun sayew, na smafà, manan, “Balù tan i fnim, blégu ge!” ");
INSERT INTO bps_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na nimenan flau yéan, na manan di ku Hérod, “Én kayègu, blém deg ulu Dyan Gal Munyag, fafkaham di bong fligo.” ");
INSERT INTO bps_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Too mlidù nawa Harì Hérod di fni i tingà én, bay landè kiboan du makang kenen di muna i kdee dad to nlakan di fista, taman dekan i sundalu blé di tingà i fnin. ");
INSERT INTO bps_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Na faklangan ulu Dyan déén di bilanggù. ");
INSERT INTO bps_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na fkahla ulun di satu fligo, na nebela di tingà, na flesan nebe di yéan. ");
INSERT INTO bps_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na i dad gal mlalò ku Dyan beg ale salu ditù di bilanggù, na nwèla i lawehan du lbangla. Na kafnge én salu ale di ku Dyisas du tnulenla. ");
INSERT INTO bps_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na di kaklinge Dyisas tafnati Dyan, mdà ale na maweng salu di satu banwe gulandè to. Kabay di kaklinge i dad to i gusalun, mdà ale tmanà du fye lalòla kenen. ");
INSERT INTO bps_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Di ktufa Dyisas mdà di aweng, teenan i dee dad to déén. Na toon ale kando na fanguléan i dad to nun tduk. ");
INSERT INTO bps_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na di fan sdaf i duh salu dad gal mlalò ku Dyisas di safédan, na manla, “Taflabi nan, na landè gumnè mdadong dini. Fye ku fdaam i dad to du fye mngabal ale gumayadla knaan di dad malnak banwe mdadong dini.” ");
INSERT INTO bps_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kabay man Dyisas, “Balù là ale mdà. Gamu sa mlé dale knaan.” ");
INSERT INTO bps_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kabay manla di kenen, “Alò lime batù fanmi dini na lwe nalaf.” ");
INSERT INTO bps_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Man Dyisas, “Nebeyu dini di deg.” ");
INSERT INTO bps_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na fsudengan dad to di bnas, na nwean i lime batù fan na lwe batù nalaf. Na funan lngalà di langit du dmasal mlé fye di Dwata. Na snatngaan i fan, na blén di dad gal mlalò kenen na nalella di dad to. ");
INSERT INTO bps_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na gamkaan i kdeela na bsol ale. Na santifun i dad gal mlalò kenen i lukasan, na fnò i sfalò lwe been gdèla. ");
INSERT INTO bps_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na i kdee dad lagi kmaan mdadong lime libu, là gakuf nse i dad libun na dad ngà kmaan. ");
INSERT INTO bps_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kafnge én dek Dyisas muna dad gal mlalò kenen smakay aweng mifal i bong lanaw. Na ftagak Dyisas du fdaan i dad to. ");
INSERT INTO bps_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kafngen fdà i dad to, mnagad kenen di satu bulul aloan satu du dmasal. Di kasdaf i duh ditù fa Dyisas aloan satu. ");
INSERT INTO bps_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kabay di bang én, mawag di kilil lanaw i aweng dad gal mlalò kenen na glumfak lwek i awengla du gsitongla i nus. ");
INSERT INTO bps_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taman tamayè mwal salu Dyisas di dale tatì magu di tah lanaw. ");
INSERT INTO bps_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kabay di kitela kenen tatì magu di tah lanaw, too ale likò. Manla, “Lmagol sa atù!” Na mkit ale mdà di klikòla. ");
INSERT INTO bps_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kabay gasil talù Dyisas di dale, manan, “Fangalyu nawayu du agu sa ani. Nang gamu likò!” ");
INSERT INTO bps_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na talù Fiter, manan, “Amu, ku ge én, fagum agu di tah lanaw salu di ge.” ");
INSERT INTO bps_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Man Dyisas, “Salu ge dini.” Taman tufa Fiter di aweng na magu di tah lanaw salu di ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kabay kagalyalon kbal i nus, talikò kenen, na takagun galnab mkit kenen, manan, “E Amu, tnabengam agu!” ");
INSERT INTO bps_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na gasil nagot Dyisas na nketan. Man Dyisas, “Tay, too tukay ksaligam! Kan ku lwe nawam?” ");
INSERT INTO bps_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na di kyakla di aweng, manak i nus. ");
INSERT INTO bps_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na i dademen di lam i aweng, mangamfù ale di kenen, na manla, “Too glut kadì ge i Tingà Dwata!” ");
INSERT INTO bps_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na fles ale mifal di lanaw, na ditù gudmuungla di banwe Génésarét. ");
INSERT INTO bps_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na di kdilè i dad to déén ku Dyisas fafngéla i dad nun tduk mdà di klamang banwe, na nebela di kenen. ");
INSERT INTO bps_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na fakdo ale di ku Dyisas began fagot dale balù alò kilil i klawehan. Na balù simto magot dun, mgulê sa. ");
INSERT INTO bps_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na di slà én, nun dad Farisi na dad tamdò dad flalò blé Dwata fagu di ku Mosis mdà di syudad Dyérusalém salu di ku Dyisas na smalek, ");
INSERT INTO bps_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","manla, “Kan kè duen i dad gal mlalò ge mlafà i tdò flalò i dad gutambulito? Là ale malob di fan ale kmaan.” ");
INSERT INTO bps_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na tmimel Dyisas, manan, “Na gamu, kan kè duenyu mlafà i flalò Dwata, du fye gimenyu i gamu flalò? ");
INSERT INTO bps_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Du ani flalò Dwata, ‘Nafèyu i màyu na yêyu,’ na ‘Ku simto to talù sasè gablà di maan ku demen yéan fnati.’ ");
INSERT INTO bps_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nlafàyu sa du én balingyu tdò, ku nun tabeng fan blé satu to di dad tuan, na fakay kun, ku manan, ‘I fangu tabeng gamu tagablégu di Dwata.’ ");
INSERT INTO bps_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na fakay kun, ku talaan nan nafè i dad tuan fagu di tabeng én. Ani i kfaguyu kmagol i Tnalù Dwata du fye gimenyu gamu flalò. ");
INSERT INTO bps_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tay, gamu tatì flingu mimen Dwata! Too glut i man Dwata gablà di gamu fagu di tugadan Isaya, manan, ");
INSERT INTO bps_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘I dad to ani mafè deg bay alò di bàla, bay too mawag i nawala di deg. ");
INSERT INTO bps_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Taman landè gukmamu i kfangamfùla di deg, du i tdò manla mdà di Dwata, mdà alò di dad to.’ ” ");
INSERT INTO bps_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kafnge én, tlo Dyisas i dad to di safédan, na manan di dale, “Too gamu flinge na fnaglabatyu i mangu! ");
INSERT INTO bps_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ise én gafagsik i satu to i fkah di lam baan, bay én gafagsik kenen i sasè lamwà di baan.” ");
INSERT INTO bps_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na fdadong i dad gal mlalò kenen du snalekla, manla, “Gadeam kè tamduk nawa i dad Farisi ge mdà di gmanam gine?” ");
INSERT INTO bps_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na tmimel Dyisas fagu di fléd, manan, “I kdee fule i là fule i Màgu di langit nsò kadang gagin i dalilan. ");
INSERT INTO bps_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tatìyu ale fbayà, du balù ku malak ale i dademela to, salngad ale i dad to butè. Na ku i to butè malak i satu to butè, lwe ale baling tatek di sol.” ");
INSERT INTO bps_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kabay man Fiter di kenen, “Tabyà, nubadam di gami i gumtatek i fléd gine.” ");
INSERT INTO bps_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na man Dyisas, “Balù gamu, là gamu fa gamlabat? ");
INSERT INTO bps_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Làyu kè glabat, i fusuk di bà i satu to salu di tienan na fles lamwà di lawehan? ");
INSERT INTO bps_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kabay i kdee sasè lamwà di bà i satu to, fdu di nawan, na én sa i gafsalà kenen. ");
INSERT INTO bps_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Hae, du i nawa gumdà dad sasè fandam gamgebe i to di kbanò, klafà yaan, ksaféd i to ise yaanan, ktaku, ktulen kéng di usay, na ktalù sasè gablà di demen to. ");
INSERT INTO bps_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ani sa gafsalà i to, bay ku kmaan kenen di là fa malob ise én gafsalà kenen.” ");
INSERT INTO bps_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na tnagak Dyisas i banwe én, na fles salu di banwe mdadong di dad syudad Tiro na Sidon. ");
INSERT INTO bps_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na nun mnè déén satu libun ise Dyu mdà di banwe Kanaan. Na salu kenen di ku Dyisas, na toon falbong i taluan fakdo ku Dyisas, manan, “E Amu, bel Harì Dabid, kandom agu, du too maflayam tingàgu libun du nun busawan.” ");
INSERT INTO bps_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kabay là tmimel Dyisas, taman fdadong i dad gal mlalò kenen, na fnila, “Tabyà, blém di kenen i fnin, du fye mdà kenen du toon ito sanlalò na too mugak!” ");
INSERT INTO bps_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Na man Dyisas, “Kabay én alò gumdek Dwata deg di bel Israél, du salngad ale i dad bilibili lana.” ");
INSERT INTO bps_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kabay fdadong i libun na lkuad kenen di blian, manan, “Amu, begam agu tnabeng.” ");
INSERT INTO bps_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na tmimel Dyisas fagu di fléd, manan, “Là fakay nwè i knaan i dad ngà na blé di dad ayem.” ");
INSERT INTO bps_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na tmimel i libun, manan, “Hae, Amu, gadègu én, bay balù dad ayem gamkaan i samel mtatek mdà di gukmaan i dad funla.” ");
INSERT INTO bps_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na man Dyisas di kenen, “Libun, too bong i ksaligam! Blégu di ge i fnim.” Kmanan én, mgulê i tingaan. ");
INSERT INTO bps_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na tnagak Dyisas i banwe én, na magu di kilil i bong lanaw Galili. Na fles kenen mnagad di satu bulul, na déén gusudengan. ");
INSERT INTO bps_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na too dee dad to salu di kenen, na nebela i dad to kimay, dad fatok, dad butè, dad to umu, na dademe fa dad to nun tduk. Fnèla di saféd Dyisas, na fanguléan ale. ");
INSERT INTO bps_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Taman too tikeng i dee dad to di kitela i nimò Dyisas, du gtalù i dad to umu, sikof lêman i dad to fatok, gagu i dad to kimay, na mite i dad to butè. Na dnayenla i Dwata fnangamfù dad bel Israél. ");
INSERT INTO bps_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na tlo Dyisas i dad gal mlalò kenen di safédan, na manan, “Toogu kando i dad to stifun dini. Tatlu duhla fanak dini di safédgu, na talandè knaanla. Là agu mayè fdà dale ku landè knaanla, du ken mtafì ale di dalan.” ");
INSERT INTO bps_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na man dad gal mlalò kenen, “Nè gumwèmi knaan di banwe ani gablà fkaan i kdee dad to ani. Fye ku nun to mnè dini!” ");
INSERT INTO bps_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na smalek Dyisas, manan, “File batù fanyu?” Na manla, “Alò fitu, na nun malnak nalaf bay là dee.” ");
INSERT INTO bps_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na dek Dyisas i kdee dad to sudeng di tanà. ");
INSERT INTO bps_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na nwean i fitu batù fan na i dad nalaf na funa kenen dmasal mlé fye di Dwata. Kafnge én, snatngaan na blén di dad gal mlalò kenen, du fye nalella di kdee dad to. ");
INSERT INTO bps_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na kmaan i dad to, na bsol ale, na i gdè knaan nuku, fitu been fnò. ");
INSERT INTO bps_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na i kdee dad lagi kmaan nun fat libu, na là gakuf nse i dad libun na dad ngà kmaan. ");
INSERT INTO bps_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na kafnge Dyisas fdà dad to, smakay kenen aweng salu di banwe Magadan. ");
INSERT INTO bps_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nun dad Farisi na dad Sadusi salu di ku Dyisas du tnilewla kenen. Taman mni ale tnikeng mdà di langit gugmadèla kenen i dek Dwata. ");
INSERT INTO bps_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kabay ani timel Dyisas, manan, “Ku fan sdaf i duh na too fulè i langit, galyu man, ‘Too fye tanà fayah.’ ");
INSERT INTO bps_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kabay ku taflafus na fulè i langit, manyu, ‘Sasè tanà kadang du fulè i langit na labnang.’ Fulung gamu meye dad ilè di langit du fye gadèyu kagkah i tanà, bay là gamu fulung meye i dad ilè gugmadèyu i nimò Dwata di bang ani. ");
INSERT INTO bps_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Too sasè i dad to di bang ani! Alò dad to takmagol Dwata i mni fa i tnikeng, bay landè tnikeng fitegu di gamu galwà di tnikeng teenyu kadang, dunan i gnagugu gambet i gnagu Dyona.” Na kafnge én, tnagakan i dad Farisi na dad Sadusi na mdà kenen. ");
INSERT INTO bps_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Di kifal i dad gal mlalò ku Dyisas i bong lanaw, taglifetla mebe i fan bnatula. ");
INSERT INTO bps_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na fanngewe ale Dyisas, manan, “Tooyu fangeye i gambet bulung falnok fan dad Farisi na Sadusi.” ");
INSERT INTO bps_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na là ale gamlabat taman stulen ale, manla, “Manan én kè du landè fan nebeito.” ");
INSERT INTO bps_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kabay gadè Dyisas gsalà i kaglabatla, taman manan di dale, “Tay, ktukay i ksaligyu di deg! Kan ku stulen gamu gablà di làyu kgebe fan? ");
INSERT INTO bps_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Là gamu fa gamlabat kel ani? Taglifetyu kè i lime batù fan fkaangu i lime libu dad to? File kè been gukuyu i gdèla? ");
INSERT INTO bps_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Na taglifetyu kè i fitu batù fan fkaangu i fat libu dad to? File kè been gukuyu i gdè? ");
INSERT INTO bps_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Kan kè i duenyu là gamlabat na ise ku btal fan i mangu? Én mangu dunan ani, ‘Tooyu fangeye i gambet falnok fan dad Farisi na Sadusi.’ ” ");
INSERT INTO bps_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na ko fa i dad gal mlalò kenen gamlabat ise ku btal falnok fan i manan, bay én fye fangeyela i tdò dad Farisi na Sadusi. ");
INSERT INTO bps_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na salu ale Dyisas di dad malnak banwe mdadong di lunsud Sisariya Filifos, na ditù gusmalekan dad gal mlalò kenen, manan, “Tan man i dad to gablà di deg i dnagit Tingà To? Simto agu kun?” ");
INSERT INTO bps_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na manla, “Man dademe, ge kun Dyan Gal Munyag. Man dademe, Ilaydya. Na dademe, manla ge kun Dyérimaya ku demen satu di dademe tugad Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na man Dyisas di dale, “Kabay gamu, tan i manyu? Simto agu kè?” ");
INSERT INTO bps_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na tmimel Simon Fiter, manan, “Ge sa i Krayst, i Mgalék Dwata mebe i kagotan. Ge sa Tingà i too mto Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Man Dyisas di kenen, “Simon, tingà Dyona too nun kafyem mdà di Dwata, du ise ku to i faglabat dun di ge, bay Màgu di langit, i fgadè dun di ge. ");
INSERT INTO bps_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Taman dnagitgu ge Fiter du gambet ge i mgal batu. Na di batu ani gufdakgu gumnègu, dunan i dad to faglut di deg. Na landè gamfisan dale, balù fati. ");
INSERT INTO bps_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Blégu di ge i kaglut lamwa i dalan dad to salu di kagot Dwata, gambet ge magot i kunsì gamgukà i langit. Na ku tan i fnangam dini, fnang Dwata di langit, na ku tan i faloham dini di tah tanà, faloh Dwata di langit.” ");
INSERT INTO bps_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kafnge én, fnang Dyisas i dad mlalò kenen tmulen di balù simto to, ku kenen i Krayst, i Mgalék Dwata. ");
INSERT INTO bps_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mdà di bang én, tambù Dyisas fgadè di dad gal mlalò kenen gablà di fan mkel di kenen, manan, “Là fakay ku là agu salu di syudad Dyérusalém, na magu di dee kaflayam ditù mdà di dad tua gal mebe i dad to Dyu na i dad ulu i dad bà di Dwata na i dad tamdò i flalò blé Dwata fagu di ku Mosis. Fnatila agu, bay nték agu mdà di fati di gatlun duh.” ");
INSERT INTO bps_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na ani duen Fiter mebe kenen di kilil na nngakan, manan, “Amu, là faloh Dwata i manam. Là fakay ku én mkel di ge.” ");
INSERT INTO bps_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kabay falê Dyisas di ku Fiter, manan, “Fawag ge di deg, Satanas! Kayeam nsang i knayè Dwata, du ise di Dwata gumdà i fandamam bay di to.” ");
INSERT INTO bps_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kafnge én, talù Dyisas di dad gal mlalò kenen, manan, “Ku nun to mayè mlalò deg, là fakay ku laan knagol knayè i kton, na mebe i krusan, na too mlalò deg. ");
INSERT INTO bps_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Du ku simto kmabas i nawan, knean mati. Kabay ku simto mati du mdà di klaloan deg, nun nawan landè sen. ");
INSERT INTO bps_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Balù gfun satu to i kdee fye dini tah tanà, tan i gufyen ku baling lana di kenen i nawa landè sen? Landè, du landè fakayan blé du fye gbawian i nawan landè sen. ");
INSERT INTO bps_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Du là mlo i kasfulêgu, agu i dnagit Tingà To, magin i bong kdatah Màgu, na dad kasaliganan. Na di duh én bnalasgu i kdee tamgimò kat satu to. ");
INSERT INTO bps_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tulengu gamu i kaglutan, nun di gamu tadag dini là mati kel di kiteyu deg, i dnagit Tingà To, salu dini di kebegu i kagotgu.” ");
INSERT INTO bps_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kafnge i nam butang, fagin Dyisas Fiter, Dyém, na Dyan i flanek Dyém di satu mdatah bulul, na landè to ditù alò ale. ");
INSERT INTO bps_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na di klola meye di kenen mgili i bawehan. Too mneng i bawehan salngad i duh, na i klawehan mneng too bukay. ");
INSERT INTO bps_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na nun msut déén Mosis na Ilaydya stulen di kenen. ");
INSERT INTO bps_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na man Fiter di ku Dyisas, “Amu, too fye du dini gami. Ku mayè ge, fdak agu tlu slung dini, satu i ge, satu ku Mosis, na satu ku Ilaydya.” ");
INSERT INTO bps_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na di slengan fa talù, maglimun ale i labun too mneng, na nun talù mdà di labun, manan, “Ani i tingàgu toogu kanbong nawa, na too fye i nawagu kenen. Flinge gamu kenen!” ");
INSERT INTO bps_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kaklingela i talù mdà di labun, tatì ale lamfan di tanà mdà di klikòla. ");
INSERT INTO bps_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kabay fdadong Dyisas na nagotan ale, manan, “Tadag gamu na nang gamu likò.” ");
INSERT INTO bps_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na di ktukengla landè dademe to teenla alò Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na di kasolla mdà di bulul too ale nfang Dyisas, manan, “Nangyu tulen di balù simto i tateenyu ditù gine. Silangyu tulen ku tamték agu, i dnagit Tingà To, mdà di fati.” ");
INSERT INTO bps_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na smalek dad gal mlalò ku Dyisas, manla, “Kan ku gal man i dad to tamdò i flalò Dwata, na silang kel i To Mgalék Dwata ku takel lêman Ilaydya?” ");
INSERT INTO bps_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na man Dyisas, “Too glut, i muna kel i to gambet ku Ilaydya du fatlagadan i kdee. ");
INSERT INTO bps_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na tulengu gamu takel sa Ilaydya, bay là dnilè i dad to ku simto kenen, na balingla kenen fanlayam gusen i knayèla. Na salngad én kadang i nimòla di deg, agu i dnagit Tingà To.” ");
INSERT INTO bps_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na tlabo én kaglabat i dad gal mlalò kenen, i to manan ani dunan Dyan Gal Munyag. ");
INSERT INTO bps_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na di kasfulêla di kdee dad to stifun di dungan nun satu lagi salu di ku Dyisas na lkuad di munan, manan, ");
INSERT INTO bps_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Amu, begam kando tingàgu lagi! Bnabuy kenen na ku nkel i tdukan too kenen maflayam du fugen di lifoh ku demen di yéél. ");
INSERT INTO bps_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tanebegu kenen di dad gal mlalò ge, bay làla gagan fgulê kenen.” ");
INSERT INTO bps_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na tmimel Dyisas, manan, “E tay, gamu dad to di bang ani, landè kafaglutyu, na too gsalà i fandamyu. Bong klogu mnè di safédyu! Tan fa dé kaftahàgu i nawagu di gamu fye faglut gamu? Nebeyu dini i tingà.” ");
INSERT INTO bps_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na di kakel i tingà, nngak Dyisas i busawan, na lamwà, na tamgulê sa i tingà. ");
INSERT INTO bps_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na i dad gal mlalò ku Dyisas fdadong di kenen di alò ale déén du snalekla kenen, manla, “Tan duenmi là gmagan falwà i busaw gine?” ");
INSERT INTO bps_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na man Dyisas di dale, “Du là gablà i kafaglutyu. Tulengu gamu i kaglutan, balù tukay i kafaglutyu salngad kalbong i too tukay bnê mustasa gaganyu man di bulul ani, ‘Mili ge ditù!’ Na mili sa! Ku gambet én i kafaglutyu gaganyu mimò balù i tan! ");
INSERT INTO bps_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Kabay alò fagu di kdasal na i kafwasa gafalwàyu i busaw salngad ani.)” ");
INSERT INTO bps_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Di kastifun i kdee dad gal mlalò ku Dyisas di banwe Galili, man Dyisas di dale, “Tamdadong i kablé deg, i dnagit Tingà To, di agot i dad to, ");
INSERT INTO bps_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na fnatila agu, bay di gatlun duh nték mdà di fati.” Di kmanan ani, too mlidù nawa i dad gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Di kakel ale Dyisas di Kafernaum, nun dad to déén gal mwè bayad tabeng di Bong Gumnè Dwata fdadong di ku Fiter, na smalek ale, manla, “I to gal tamdò gamu, mlé kenen dé i bayad tabeng di Bong Gumnè Dwata?” ");
INSERT INTO bps_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na man Fiter, “Hae, mlé sa.” Na di kasfulê Fiter di gumnèla, i muna talù Dyisas, manan, “Simon, tan i ge fandam gablà ani? Dini di tah tanà, i dad harì, simto gal gumwèla i bayad knun blé di harì? Mdà di dad ngàla ku demen di dademe dad to mnè di banwela?” ");
INSERT INTO bps_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na man Fiter, “Di dademe dad to gumwèla.” Na man Dyisas, “Na ku én, balù là mlé dad ngà i harì. ");
INSERT INTO bps_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kabay balù fakay ku là agu mlé, knean mayad ite du ken mahal nawa dad to gal mwè i bayad. Taman salu ge di lanaw, na dmulé ge. Na i nalaf muna samkot, banngatam i baan du déén gumitem filak. Nweam na blém di dale i bayadta.” ");
INSERT INTO bps_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Di bang én fdadong di ku Dyisas i dad gal mlalò kenen na smalek ale, manla, “Simto i too mdatah to di kagot Dwata?” ");
INSERT INTO bps_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na tlo Dyisas satu tukay tingà di safédan du ftadagan di blengla, ");
INSERT INTO bps_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na manan, “Tulengu gamu i kaglutan, silang gamu gfusuk di kagot Dwata ku mguman i fandamyu na salngad i fandam dad malnak ngà, ");
INSERT INTO bps_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","du i too mdatah di kagot Dwata dunan i to too fdanà i kton salngad i tingà ani. ");
INSERT INTO bps_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Na ku simto dmawat i satu to gambet i tukay tingà ani du mdà di ksasatun di deg, dnawatan agu. ");
INSERT INTO bps_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kabay ku simto gumdà i satu to gamsalà, too kenen fanlayam. Fye fa ku mgikat di lialan i bong giling batu, na bat kenen di gumngalam i mahin, di laan fa mgebe di salà satu di dad to faglut di deg gambet tukay tingà ani. ");
INSERT INTO bps_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Magakdo i dad to di tah tanà du dee dad gamgebe dale di salà. Na landè gutlag ani, bay too sasè kagkah kadang i dad to gumdà i dademe to gamsalà. ");
INSERT INTO bps_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na ku i bali kmalam ku demen bali bliam mebe ge di kimò sasè, fye fa baling ku kanlangam na batam du fye là ge fles mimò sasè, du fye fa ku fatok ge ku demen kimay na nun nawam landè sen, di sikof kmalam na bliam bay baling ge bat di lifoh landè gusenan. ");
INSERT INTO bps_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na ku bali matam gamgebe ge di kimò sasè, baling fye fa ku tanwilam na batam du fye là ge fles mimò sasè. Fye fa ku alò satu matam, na nun nawam landè sen. Sasè ku balù sikof matam bay baling ge bat di lanaw lifoh.” ");
INSERT INTO bps_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Too gamu fgeye du fye là mdanà keyeyu i dad to gambet i dad ngà ani. Tulengu gamu i kaglutan, i dad kasaligan Dwata mifat dale gal mnè di saféd i Màgu déén di langit. ");
INSERT INTO bps_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Na agu, i dnagit Tingà To, i duengu salu dini di tah tanà du fye falwàgu i dad to lana di Dwata mdà di salàla.) ");
INSERT INTO bps_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Di gamu fandam, tan nimò i mfun mlatu bilibili ku lana i satu? Ise én nimoan kè, tnagakan i syem falò syem di bulul gumtebla, du fanngabalan i satu lana? ");
INSERT INTO bps_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na tulengu gamu i kaglutan, ku teenan, too lehew, mdatah fa i klehewan di syem falò syem i là lmen lana. ");
INSERT INTO bps_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na salngad én, là mayè i Màgu di langit ku lana di kenen balù alò satu to gambet dad ngà ani.” ");
INSERT INTO bps_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Na man Dyisas, “Ku nun flanekam di kafaglut gamsalà di ge, salu ge di kenen na tulenam kenen ku tan i gugsalaan di ge, bay nimoam ani di alò gamu lwe. Na ku fanlingen ge, gambet tagebem kenen lêman di kasaflanekyu. ");
INSERT INTO bps_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kabay ku laan ge fanlinge faginam satu ku demen lwe to, du fye nun lwe ku demen tlu to mlinge i kdee gmanyu. ");
INSERT INTO bps_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na ku laan ale fanlinge, tulenam di dad to faglut di kastifunyu. Na ku laan ale fanlinge, na i kibòyu kenen fsalngadyu di dad to là gmadè Dwata ku demen satu to gal mwè bayad buhis.” ");
INSERT INTO bps_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tulengu gamu i kaglutan, ku tan i fnangyu dini di tah tanà, fnang sa di langit, na ku tan i falohyu dini, faloh Dwata di langit. ");
INSERT INTO bps_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Na ani fa tulengu gamu, ku nun lwe di gamu dini di tah tanà nun ksasatu i nawayu gablà di satu fniyu, blé sa i Màgu di langit i fniyu, ");
INSERT INTO bps_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","du balù nè gustifun lwe demen tlu to du mdà di ksasatula di deg, déén agu di safédla.” ");
INSERT INTO bps_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na fdadong Fiter di ku Dyisas, na smalek kenen, manan, “Amu, file dulêgu nlifet i salà demegu to gamsalà di deg? Kel di fitu dulê dé?” ");
INSERT INTO bps_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kabay tmimel Dyisas, manan, “Ise ku alò fitu dulê, bay kel di fitu falò dulê fitu. ");
INSERT INTO bps_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Én duenan du i kagot Dwata dad ton salngad di nimò satu harì meye dad uteng i dad saligan di kenen. ");
INSERT INTO bps_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na di katbuan meye dad uteng ani nun nebe di kenen satu saligan gamguteng di kenen dee libu filak. ");
INSERT INTO bps_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na du laan gambayad i utengan, man i amun fafablin kenen salngad i fasak, na yaanan, dad ngaan, na kdee nfunan du bayad i bong utengan. ");
INSERT INTO bps_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kabay lkuad i salig di muna i amun du too fakdo, manan, ‘Amu, begam fantahà nawam di deg du bnayadgu i kdee utenggu.’ ");
INSERT INTO bps_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na kamdo i amun kenen, taman nlifetan i kdee utengan, na falwaan kenen. ");
INSERT INTO bps_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kabay di kalwà i to én, gsitongan satu di dademen salig nun tukay uteng di kenen. Di kiten kenen, fanlangan manan, ‘Bnayadam i utengam!’ ");
INSERT INTO bps_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Na lkuad i salig ani di munan na fakdo kenen, manan, ‘Begam fantahà nawam di deg du bnayadgu di ge.’ ");
INSERT INTO bps_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Kabay laan mayè, na tabalingan fbilanggù i demen salig kel di kbayadan i kdee utengan. ");
INSERT INTO bps_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Di kite i dad demen salig i mgimoan, too ale mlidù, taman salu ale di amula, na tulenla i kdee teenla. ");
INSERT INTO bps_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kaklinge i harì dun, fatlon i salig tafalwaan na manan di kenen, ‘Too ge sasè salig! Tanlifetgu i kdee utengam du fakdo ge di deg. ");
INSERT INTO bps_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gablà moon ku kandom i demem salig salngad i kakdogu ge.’ ");
INSERT INTO bps_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na too flabè i amun, taman fbilangguan i salig én, du fye fanlayam kel di kbayadan i kdee utengan. ");
INSERT INTO bps_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Salngad én i nimò Màgu di langit di kat satu gamu ku là mdà di nawayu mlifet salà i demeyu to.” ");
INSERT INTO bps_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kafnge Dyisas tamdò i kdee ani, tnagakan i banwe Galili na salu kenen di banwe Dyudiya di faltù i yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na too dee dad to mlalò kenen, na fanguléan déén i dad to nun tduk. ");
INSERT INTO bps_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na nun dad Farisi salu di kenen du neyela dalan dmalam kenen, taman smalek ale, manla, “Fakay dé di flalò Dwata ku kahito yaanito, balù tan i gumdaan?” ");
INSERT INTO bps_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Na tmimel Dyisas, manan, “Làyu kè bnasa gablà di nimò Dwata di katbuan di kimoan i banwe, du nimoan satu lagi na satu libun, ");
INSERT INTO bps_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","manan, ‘Ani duen i lagi lamwà di ifat i maan na yéan na mnè di saféd i yaanan du i lwe to ani mgimò satu?’ ");
INSERT INTO bps_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Taman taise ku lwe to i satlamin bay mbaling satu. Na taman là fakay ku sankah i dad to, i tasansatu Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Taman smalek dad Farisi, manla, “Ku én i kagkah, tan duen Mosis faloh i lagi kah i yaanan ku tafunan sulat di fafil gufgadè i kaskah?” ");
INSERT INTO bps_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na tmimel Dyisas, manan, “Hae, du too mgal uluyu! Ani sa duen Mosis faloh ku kahyu yaanyu. Kabay mdà di katbuan ise ani knayè Dwata. ");
INSERT INTO bps_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Taman mangu di gamu, balù simto to mkah yaanan i là mlafà kenen, gamsalà ku lêman mwè satu libun.” ");
INSERT INTO bps_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na man i dad gal mlalò ku Dyisas di kenen, manla, “Ku ani kagkah i satlamin, fye fa ku nang ito mwè yaan.” ");
INSERT INTO bps_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na tmimel Dyisas, manan, “Nun dad to banlé Dwata kgagan là mwè yaan, bay ise ku kdee dad to. ");
INSERT INTO bps_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Là salngad duen i dad to là mwè yaan. I dademe nun gukulang lawehla mdà di ksutla. Na dademe tnalin ale i dad to. Na dademe là mwè yaan mdà di kabléla i ktola di kafbel i kagot Dwata. Nè i to gmagan mimò ani, én fye dmawat i tdò ani.” ");
INSERT INTO bps_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na nun dad to mebe i dad ngà di ku Dyisas du fye nagotan ale na dnasalan. Kabay i dad mlalò ku Dyisas, balingla nngak i dad to én. ");
INSERT INTO bps_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kabay man Dyisas, “Falohyu dad ngà salu di deg, na nangyu ale fnang, du ku simto to nun ksalig salngad i dad ngà ani, gakuf ale di kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na kafngen magot na dmasal dale tamdà kenen. ");
INSERT INTO bps_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Di satu duh nun lagi salu di ku Dyisas, na smalek, manan, “E To Tamdò, tan i fye nimògu fye gfungu i nawa landè sen?” ");
INSERT INTO bps_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na man Dyisas, “Kan ku smalek ge deg ku tan i fye? Alò satu i fye, dunan Dwata. Nimenam kdee flalò Dwata ku mayè ge gamdawat nawa landè sen.” ");
INSERT INTO bps_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na smalek i lagi, manan, “I tan dad flalò manam én?” Na man Dyisas, “Nang ge manò, nang ge mlafà yaanam, nang ge tmaku, na nang ge tmulen kéng di usay, ");
INSERT INTO bps_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mafè ge i maam na yéam, na kandom i demem to salngad kakdom i ktom.” ");
INSERT INTO bps_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na tmimel i lagi, manan, “Tanimengu i kdee dad flalò én. Tan fa kè i gukulanggu?” ");
INSERT INTO bps_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na man Dyisas di kenen, “Ku mayè ge landè gukulangam, mdà ge na fablim i kdee dad knunam, na blém i bayadan di dad to landè. Na fagu déén nun bong knun gfunam di langit. Kafnge én, samfulê ge, na mlalò ge deg.” ");
INSERT INTO bps_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kabay di kaklinge i lagi i man Dyisas, mdà kenen na too mlidù nawan du too bong knunan. ");
INSERT INTO bps_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na man Dyisas di dad gal mlalò kenen, manan, “Tulengu gamu i kaglutan, too malima kagfusuk i to nun bong knun di kagot Dwata. ");
INSERT INTO bps_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Glut ani, malima fusuk i bong lmanaf kamél di sol i dalum, bay malima fa i satu to nun bong knun fusuk di kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kaklinge dad gal mlalò kenen ani, too ale tikeng, na smalek ale, manla, “Ku glut én, simto fakay galwà?” ");
INSERT INTO bps_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na meye Dyisas di dale, na manan, “Landè to gmagan mimò ani, bay gagan Dwata i kdee.” ");
INSERT INTO bps_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na tmimel Fiter, manan, “Neyem gami, tatnagakmi i kdee du mlalò gami ge, na tan i gdawatmi?” ");
INSERT INTO bps_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na man Dyisas di dale, manan, “Tulengu gamu i kaglutan, di bang kadang ku tafnalami Dwata i kdee, sudeng agu, i dnagit Tingà To, di gusudeng i gumdatah. Na di bang én, gamu dad gal mlalò deg nun sfalò lwe gusudengyu mukum, na mukum gamu i dad to mdà di sfalò lwe lumbuk bel Israél. ");
INSERT INTO bps_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na kat satu to tmagak i gumnean, ku demen i dad flanekan, ku demen i maan, ku demen i yéan, ku demen i dad ngaan, ku demen tanaan mdà di klaloan deg, too bong gdawatan mdà di Dwata kel di mlatu dulê i kbongan di tatnagakan. Na gdawatan fa i nawa landè sen. ");
INSERT INTO bps_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na nun dee dad to mdatah di bang ani, baling mdanà kadang di fulé duh. Na dad to mdanà di bang ani, mdatah kadang di fulé duh.” ");
INSERT INTO bps_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na man Dyisas, “Satu guflingengu i kagot Dwata di nimò satu to mfun tanà gumulen dad bunge grép. Too flafus kenen lamwà du meye dad to mimò di tanaan. ");
INSERT INTO bps_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na i kastulenla i tagnè taden di sduh na tamastandè ale, taman fimoan ale di tanaan. ");
INSERT INTO bps_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Na di tngà mnagad i duh lêman lamwà mfun i fule na nun teenan dad to di fadyan tatì tadag déén landè nimòla, ");
INSERT INTO bps_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","taman manan di dale, ‘Mimò gamu di tanàgu, na tnadengu gamu i gablà tadenyu kadang.’ ");
INSERT INTO bps_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Taman mdà ale du mimò ditù. “Na lamwà kenen di kaltu i duh na lêman di tngà masol i duh, na nun dad to fimoan di tanaan. ");
INSERT INTO bps_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na di fan kasdaf i duh, lamwà kenen lêman na teenan dademe to tì tadag déén, na manan, ‘Tan duenyu tadag dini tayud i duh landè nimòyu?’ ");
INSERT INTO bps_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Na manla, ‘Hae, du landè to fimò gami.’ “Na manan di dale, ‘Na ku én, mimò gamu di tanàgu.’ ");
INSERT INTO bps_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na di kasdaf i duh, man i mfun i fule di to magot i taden, manan, ‘Tlom i dad to mimò, na tnadenam ale. Funam tnaden i dad to fulé tambù mimò, na fafulém dad guna mimò.’ ");
INSERT INTO bps_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kakel i dad to tambù mimò mdà di fan sdaf i duh, na banlén kat satu dale i tagnè taden di sduh. ");
INSERT INTO bps_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taman di ktadenan i dad guna mimò, i man nawala bong fa déén i dale taden, bay salngad sa i tadenla. ");
INSERT INTO bps_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na di kagdawatla i tadenla too ale mugak di mfun i tanà. ");
INSERT INTO bps_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Manla, ‘I dad to gfulé tambù, alò satu uras klola mimò, bay fsalngadam ale di gami, blaam tatayud i duh mimò gami di bong kinit.’ ");
INSERT INTO bps_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Na tmimel kenen, manan di satu di dale, ‘Flanek, làta gamu nlangong. Ise én kè tagnè kastulenta di katbuam mimò, i tagnè taden di sduh i tadengu ge? ");
INSERT INTO bps_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dnawatyu i tadenyu, na mulê gamu. Én kayègu ku tan i blégu gamu salngad én i blégu di dad to fulé kel. ");
INSERT INTO bps_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Man, landè kè kaglutgu magot i filakgu? Ken mingà nawayu du too agu mayè mlé.’ ");
INSERT INTO bps_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Na salngad én, nun dad to fulé ani baling guna kadang di fulé duh. Na nun dad to muna ani baling gfulé kadang di fulé duh.” ");
INSERT INTO bps_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na mnagad ale Dyisas salu di syudad Dyérusalém. Di slengla magu fafdadong Dyisas i dad sfalò lwe gal mlalò kenen na klola magu manan di dale, ");
INSERT INTO bps_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Flinge gamu, du ani salu ito di Dyérusalém na ditù bléla agu, i dnagit Tingà To, di agot i dad ulu i dad bà di Dwata na dad tamdò i flalò blé Dwata fagu di ku Mosis na nukumla agu di fati. ");
INSERT INTO bps_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na kafnge én, bléla agu di dad to ise Dyu du fye snilola agu, na bnadasla, na flesla agu nlansang di krus. Kabay di gatlun duh nték agu Dwata mdà di fati.” ");
INSERT INTO bps_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kafnge én, fdadong di ku Dyisas i yaan Sébidi magin i lwe dad ngaan lagi, na lkuad kenen di munan du nun kayean fni di kenen. ");
INSERT INTO bps_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na smalek Dyisas, manan, “Tan i kayeam?” Na manan, “Ku tage magot i banwe di fulé duh, fsudengam i lwe dad ngàgu ani di safédam, satu gsen di kwananam na satu gsen di ibengam.” ");
INSERT INTO bps_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kabay tmimel Dyisas, manan, “Làyu gadè i fniyu. Gaganyu kè mebe i kaflayam salngad i bong kaflayam gnagugu kadang?” Manla, “Hae, gaganmi.” ");
INSERT INTO bps_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Man Dyisas, “Too glut, i kaflayam gnaguyu kadang salngad di kaflayam gnagugu. Kabay landè kaglutgu malék ku simto fsudeng gsen di kwanangu na di ibenggu, du én alò gsudeng déén i dad to tagutmagà i Màgu dun.” ");
INSERT INTO bps_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na di kaklinge i dademe sfalò gal mlalò ku Dyisas i fni dademela ani, flabè ale di lwe saflanek ani. ");
INSERT INTO bps_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kabay, tlo Dyisas kdeela di safédan, na manan, “Tagadèyu i gal nimò i dad ganlal i dad to di tah tanà ani. Toola bankut i dad to gdanà di dale. I dad to nun glal, toola gal dek i dad to. ");
INSERT INTO bps_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kabay gamu, ise én i kfaguyu, du ku nun di gamu mayè mbaling mdatah là fakay ku laan gal tnabeng i dademen. ");
INSERT INTO bps_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na ku nun di gamu mayè mdatah di kdee, là fakay ku laan flifan i kton di kdee dademen. ");
INSERT INTO bps_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Salngad deg, i dnagit Tingà To, làgu salu di tah tanà ani du én kayègu ku tnabeng agu i dad to, bay i duengu salu dini du tnabenggu i dad to na blégu i ktogu di fati, du bnayadgu dad salàla du fye dee dad to galwà.” ");
INSERT INTO bps_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na di kdà ale Dyisas di banwe Dyériko too dee dad to mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na nun lwe to butè sudeng di kilil dalan. Di kaklingela, i to mlius di dale, dunan Dyisas, tamlo ale, manla, “E Bel Harì Dabid, begam gami kando.” ");
INSERT INTO bps_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na dee to mngak dale, na manla dale fanak. Kabay baling matnù kakitla, manla, “E Amu, Bel Harì Dabid begam gami kando!” ");
INSERT INTO bps_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na tlag Dyisas magu du tlon ale di safédan, manan, “I tan kayèyu nimògu di gamu?” ");
INSERT INTO bps_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na manla, “Amu, kayèmi ku beg gami mite.” ");
INSERT INTO bps_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na too kamdo Dyisas dale, na nagotan i matala, na mite ale, na fles ale magin kenen. ");
INSERT INTO bps_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na di kagdadong ale Dyisas di syudad Dyérusalém, di kakella di banwe Bétfagi di dungan i bulul Olib, dekan muna lwe gal mlalò kenen, ");
INSERT INTO bps_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na manan di dale, “Fles gamu di banwe sen munaito. Kakelyu ditù, nun teenyu satu dongki ikat gagin i tingaan. Nbelyu ikatla na nebeyu dini di deg. ");
INSERT INTO bps_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na ku nun to smalek gamu, manyu, ‘Nun gukmamu i Amu dun.’ Na gasilan fulê di gamu kadang i dongki na tingaan.” ");
INSERT INTO bps_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","I tanimò Dyisas ani, du fye gdohò i gman Dwata fagu di satu tugadan, manan, ");
INSERT INTO bps_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fgadeam dad to di Sion, manam, ‘Neyeyu, du fan kel di gamu i Harìyu. Fdanaan i kton na smakay kenen di dongki, tingà dongki i snakayan.’ ” ");
INSERT INTO bps_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na tamdà i lwe dek Dyisas. Na nimenla i manan. ");
INSERT INTO bps_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Na nebela i dongki na tingaan di ku Dyisas, na afidla dun i dademe klawehla, na smakay Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na di slengla magu nun dee to mbel dademe klawehla di dalan gumagun na kamlang ale fa dad malnak fanga kayu nun doon, du filèla di dalan gumagu Dyisas du fitela afèla kenen. ");
INSERT INTO bps_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na tamlo i dad to di muna Dyisas, na tmimel dad to di fulé, manla, “Dnayenito i bel Harì Dabid. Too nun kafye i to salu dini mebe i glal Amuito Dwata. Dnayenyu Dwata kdeeyu mnè di tah langit!” ");
INSERT INTO bps_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na di kfusuk Dyisas di Dyérusalém kdee dad to di klamang syudad too tikeng, manla, “Simto to ani dé?” ");
INSERT INTO bps_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na tmimel i dad to magin ku Dyisas, manla, “Dyisas ani, satu tugad Dwata mdà di banwe Nasarét di Galili.” ");
INSERT INTO bps_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na fusuk Dyisas di Bong Gumnè Dwata, i gal gumangamfù dad Dyu. Na ndalan lamwà dad to sbayad déén. Fnugenan dad lamisa i dad to samfalit filak, na dad gusudeng i dad fabli salafati galla dsù. ");
INSERT INTO bps_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na manan di dale, “Tagsulat di Tnalù Dwata, manan, ‘Én gukmamu i Gumnègu gal gudmasal,’ bay tabalingyu nimò gumnè i dad to tmaku!” ");
INSERT INTO bps_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na nun dad to butè na dad to là gagu salu di kenen déén di lam i Bong Gumnè Dwata, na fanguléan ale. ");
INSERT INTO bps_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kabay too flabè i dad ulu i dad bà di Dwata na dad tamdò i flalò blé Dwata fagu di ku Mosis di kitela i dad tnikeng nimò Dyisas, na di kaklingela i kit dad ngà di lam i Bong Gumnè Dwata, di kmanla, “Dnayenito i bel Harì Dabid!” ");
INSERT INTO bps_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Taman smalek ale ku Dyisas, manla, “Laam kè linge i manla?” Na tmimel Dyisas, manan, “Hae sa. Làyu kè bnasa i man di Tnalù Dwata, manan, ‘Tdoam dad ngà, balù dad too malnak ngà dmayen kdataham?’ ” ");
INSERT INTO bps_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na tnagakan ale na lamwà di syudad, du salu kenen di Bétani, na déén gumilean di butang én. ");
INSERT INTO bps_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kakwalan én, di dalan Dyisas samfulê di syudad, tabitil kenen. ");
INSERT INTO bps_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na teenan satu kayu fig di kilil dalan, na fdadong kenen, bay kakelan déén alò doon i teenan landè bungen. Taman talù Dyisas di kayu, manan, “Fandà ani talà ge gambunge.” Na tatì mlanas i kayu. ");
INSERT INTO bps_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na di kite dad gal mlalò ku Dyisas mati i kayu, tikeng ale, na smalek ale, manla, “Kan ku mlal mlanas i kayu fig.” ");
INSERT INTO bps_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na tmimel Dyisas, manan, “Tulengu gamu i kaglutan, ku faglut gamu na là lwe i nawayu, gaganyu nimò i tanimògu di kayu ani, na ise ku alò ani, bay fakayyu man di bulul ani, ‘Magket ge na gbat di lam i mahin,’ na gdohò sa i manam. ");
INSERT INTO bps_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Du balù tan i fniyu di dasal gdawatyu.” ");
INSERT INTO bps_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na samfulê Dyisas di Bong Gumnè Dwata. Di slengan tamdò di lam, fdadong di kenen i dad ulu i dad bà di Dwata na i dad tua gal mebe dad Dyu, na smalek ale, manla, “Tan kè i kaglutam mimò i kdee nimoam, na simto mlé ge glal?” ");
INSERT INTO bps_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na tmimel kenen, manan, “Nun snalekgu gamu funa. Ku tmimel gamu, tulengu gamu i gumdà glalgu mimò ani. ");
INSERT INTO bps_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tulenyu deg, i kbunyag Dyan, nè gumdà i glalan, mdà di Dwata, ku demen mdà di to?” Na stulen ale ku tan fye timella, na manla, “Tan i timelito? Ku manito, ‘I glalan mdà di Dwata,’ snalekan ito, ‘Kan ku làyu fnaglut i manan?’ ");
INSERT INTO bps_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kabay ku manito, ‘Mdà di to,’ likò ito dad to, du i kdeela too fnaglut Dyan satu tugad Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Taman tmimel ale ku Dyisas, manla, “Làmi gadè.” Taman man Dyisas di dale, “Na, làgu tmulen gamu ku nè gumdà i glalgu mimò i nimògu.” ");
INSERT INTO bps_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na fadlug Dyisas talù di dad ganlal i dad Dyu, manan, “Tan i fandamyu gablà ani? Nun satu to lwe tingaan lagi. Na salu kenen di twege, na manan, ‘Tò, mdà ge du mimò ge di fule grép duh ani.’ ");
INSERT INTO bps_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Baling man i tingaan, ‘Là agu mayè.’ Kabay là mlo msal kenen na mdà du mimò ditù. ");
INSERT INTO bps_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Na salu i mà ani di tingaan twali na salngad i manan. Na tmimel i tingaan, manan, ‘Hae Mà,’ bay laan salu ditù. ");
INSERT INTO bps_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na di lwe dad ngà ani, simto i mimen knayè i màla?” Na tmimel ale, manla, “I twege.” Na man Dyisas, “Hae, na tulengu gamu i kaglutan, i dad to sasè, gambet i dad to mwè bayad buhis na i dad libun mkat lagi, muna fa di gamu fusuk di kagot Dwata. ");
INSERT INTO bps_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hae, du salu Dyan Gal Munyag dini di gamu du fiten di gamu i dalan du fye matlu gamu, bay là gamu faglut di kenen. Baling én faglut di manan i dad to mwè bayad i buhis na i dad libun mkat lagi. Kabay gamu, balù tateenyu i kafaglut dad to én, knean là gamu msal na faglut di tdoan.” ");
INSERT INTO bps_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na man Dyisas, “Flinge gamu di satu fléd ani. Nun satu to mule i walad dnagit grép di tanaan na nlabatan. Na makol kenen sol di bong batu du gumisà i bunge grép. Na fdakan satu mdatah gumnè i to munung dad fulen. Na kafnge én, fagotan i dad fulen di dademe to, du salu kenen di satu banwe. ");
INSERT INTO bps_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na di bang ktaga dad bungen, nun dekan dad saligan salu di dad to magot dun, du fwean kenen alel. ");
INSERT INTO bps_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kabay i dad to fagotan dun, balingla kanfè i dad saligan, na bnunalla i satu, fnatila i satu, na tnudàla batu i satu. ");
INSERT INTO bps_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na dekan lêman ditù dademe dad saligan, dee fa di dad muna dekan. Kabay salngad nimòla di dale. ");
INSERT INTO bps_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Di gusenan, dekan i tingaan, du manan, ‘Là fakay ku làla nafè i tingàgu.’ ");
INSERT INTO bps_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Kabay kantola teen i tingaan, stulen ale, manla, ‘Ani sa tingà i mfun i fule. Kenen i mfun kadang, taman snitongito kenen na fnatiito, du fye di kfati maan gito gamfun i fule.’ ");
INSERT INTO bps_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na taman kanfèla, na ditù gumbatla kenen di lwà i gumule i maan na flesla fnati.” ");
INSERT INTO bps_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na smalek Dyisas, manan, “Ku takel i mfun fule ditù, tan i nimoan di dad to gufagotan i fulen?” ");
INSERT INTO bps_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Manla, “Fnatin sa i dad to sasè én, na fagotan di dademe dad to mayè mlé i alelan ku tabang kgafat i bungen.” ");
INSERT INTO bps_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na man Dyisas di dale, “Làyu kè bnasa i man Dwata di Tnaluan? Manan, ‘I batu too knang i dad to fdak gumnè, du di dale fandam landè gukmamu dun, én baling i batu too mabtas di kdee. Hae, ani mgimò i Amuito Dwata, na di kitemi, too gamtikeng i nimoan.’ ");
INSERT INTO bps_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Taman tulengu gamu, i kagot Dwata nawì mdà di gamu na blé di dad to mimò knayean. ");
INSERT INTO bps_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Na ku simto gdauf di batu ani, tfò dad tulanan, bay ku simto tankan i batu, tatì mluna.”) ");
INSERT INTO bps_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na kaklinge dad ulu i dad bà di Dwata na dad Farisi i dad fléd Dyisas ani, glabatla ale gugtadè i manan. ");
INSERT INTO bps_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Taman too ale mngabal kfagu kamfè kenen di bang én, bay likò ale di dee dad to faglut na Dyisas i satu tugad Dwata. ");
INSERT INTO bps_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na tamdò Dyisas di dad to lêman fagu di fléd, manan, ");
INSERT INTO bps_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Satu guflingengu i kagot Dwata di satu harì mimò i bong fista di kasdeme i tingaan lagi. ");
INSERT INTO bps_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na dekan dad saligan di dad to tanlakan du fye nngéla ale, bay là ale mayè. ");
INSERT INTO bps_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Na taman dekan lêman dademe dad saligan, na manan, ‘Tooyu man di dad to tanlak, tagatlagad i kakaan. Tatnatê i dad malbang bakagu na dad ngà baka tafabù, tagatlagad i kdee. Na tooyu ale fsalu dini di fista i kasdeme tingàgu.’ ");
INSERT INTO bps_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kabay là fduf i dad to tanlakan i manan, na baling ale fadlug di dad nimòla, satu salu di nligon, na satu salu di tindan. ");
INSERT INTO bps_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na i dademe, kanfèla dad saligan, na fatdukla ale, na fnatila. ");
INSERT INTO bps_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na too flabè i harì, na dekan dad sundalun, du fye fnatila i dad to mati i dad saligan, na snakufan i syudad gumnèla. ");
INSERT INTO bps_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kafnge én, tlon i dademe dad saligan, na manan, ‘Tagatlagad fista i kasdeme, bay i dad to tamunagu nlak là ale gablà salu di fista ani. ");
INSERT INTO bps_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Taman mdà gamu salu di dad dalan di gusabù i dad to, na nlakyu i kdee dad to teenyu du salu di fistagu.’ ");
INSERT INTO bps_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na mdà i dad saligan salu di dad dalan, na santifunla i kdee dad to teenla, balù fye dad to ku demen sasè. Na tafnò dad to i bong gukmaan di fista i kasdeme. ");
INSERT INTO bps_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kabay di kfusuk i harì du neyen i dad to salu déén, nun teenan satu to là lamsak klaweh i kasdeme. ");
INSERT INTO bps_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na snalek kenen i harì, ‘E flanek, tan i kagfusukam dini du là ge lamsak klaweh i kasdeme?’ Kabay là gamtimel i to én. ");
INSERT INTO bps_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Na man i harì di dad saligan, manan, ‘Bnakusyu dad blian na dad sigalan, na batyu di lwà di gukmifun, déén di gumlanu dad to na gukminggat i kifanla.’ ");
INSERT INTO bps_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Hae, du dee dad to nlak Dwata, bay là dee i dad mgalékan.” ");
INSERT INTO bps_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na kafnge én, lamwà dad Farisi, du santulenla kfagula kamfè ku Dyisas fagu di salek. ");
INSERT INTO bps_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na én nimòla, dekla di ku Dyisas dademe to gal mlalò dale na dademe dad Dyu msen di ku Harì Hérod. Kakella ditù, manla, “To Tamdò, gadèmi ge satu to là tmulen kéng. Tamdò ge i kaglut gablà di knayè Dwata, du laam fkah di nawam i man dad to gablà di ge, na là mabtas di ge ku tan i glalla. ");
INSERT INTO bps_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Taman tulenam gami ku tan i fandamam. Fakay dé di flalò blé Dwata fagu di ku Mosis ku mlé gami i bayad buhis di ku Sisar, i gumdatah di banwe Roma ku demen là?” ");
INSERT INTO bps_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kabay gadè Dyisas i duenla smalek ani, taman manan, “Gamu dad to flingu mimò fye, kan ku tilewyu agu fnawel? ");
INSERT INTO bps_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fiteyu deg satu filak galyu bayad buhis.” Na nebela satu filak di kenen. ");
INSERT INTO bps_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na snalekan ale, manan, “Simto kè baweh na dagit i gkah di filak ani?” ");
INSERT INTO bps_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na manla, “Ku Sisar.” Taman man Dyisas di dale, “Na ku tan i nfun Sisar bléyu ku Sisar, na ku tan i nfun Dwata bléyu di Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Di kaklingela i manan, too ale tikeng, taman mdà ale tmagak kenen. ");
INSERT INTO bps_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na di duh én nun dad Sadusi salu di ku Dyisas, dunan dad Dyu i gal mangman kun, là mték i dad to mdà di fati. ");
INSERT INTO bps_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Na ani snalekla di kenen, manla, “To Tamdò, nun sulat Mosis di gito di muna fa, gman, ku mati satu lagi, bay landè tingàla yaanan, là fakay ku là nwè i flanekan i libun balu én, du fye nun bel i tamati fagu di kenen. ");
INSERT INTO bps_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na di muna kun, nun fitu lagi saflanek mnè dini. Na mwè yaan i twege, bay mati na landè tingàla, taman nwè i galwen. ");
INSERT INTO bps_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kabay salngad ani mkel di galwen na gatlun na di kdee dad fitu saflanek kel di sangal twali. ");
INSERT INTO bps_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kafnge én, mati i libun. ");
INSERT INTO bps_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na ani snalekmi, kadang di kték i dad mati, di dad fitu saflanek simto yaan i libun ani, du i kdeela slame mwè kenen?” ");
INSERT INTO bps_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na tnimel Dyisas, manan, “Gsalà i fandamyu du làyu gadè i Tnalù Dwata na làyu gadè i kbong tulusan. ");
INSERT INTO bps_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Du di kték i dad to mati di fulé duh, talandè swè yaan lagi ku demen libun, du én kagkahla salngad i dad kasaligan Dwata di langit. ");
INSERT INTO bps_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na gablà di fnaglutyu i là mték dad to mati, làyu kè lmen masa i man Dwata di gamu? ");
INSERT INTO bps_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Manan, ‘Agu i Dwata fnangamfù Abraham, Isaak, na Dyékob.’ I gman Dwata ani i satu gugmadeito balù tamati ale Abraham mto ale lêman, du Dwata i Dwata fnangamfù i dad to mto, ise dad to mati.” ");
INSERT INTO bps_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na di kaklinge i dad to i man Dyisas ani, too ale tikeng di katdoan. ");
INSERT INTO bps_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Di kaklinge i dad Farisi gablà di kfisan Dyisas i dad Sadusi, sdulê ale stifun di kenen. ");
INSERT INTO bps_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na nun satu di dale gal mubad dad flalò blé Dwata fagu di ku Mosis tmilew mawel kenen fagu di salek. ");
INSERT INTO bps_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Manan, “E To Tamdò, tan i too mdatah flalò di kdee flalò Dwata?” ");
INSERT INTO bps_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na tmimel Dyisas, manan, “ ‘Tooyu kando i Amuyu Dwata mdà di nawayu, na di kdee knayèyu, na di kdee fandamyu.’ ");
INSERT INTO bps_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ani i too mdatah flalò na mabtas di kdee. ");
INSERT INTO bps_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na i gamtadol, fan salngad di muna, dunan ani, ‘Kandoyu i demeyu to salngad kakdoyu i ktoyu.’ ");
INSERT INTO bps_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I lwe flalò ani, gumdà i kdee flalò blé Dwata di ku Mosis na i kdee tdò dad tugad Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Di kagastifun fa i dad Farisi, smalek Dyisas dale, ");
INSERT INTO bps_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","manan, “Tan fandamyu gablà ku Krayst, i Mgalék Dwata? Simto kè gutambulan?” Na tmimel ale, manla, “Kenen i bel Harì Dabid.” ");
INSERT INTO bps_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na man Dyisas, “Ku én, kan ku katlo Dabid kenen Amu fagu di kalak i Tulus Dwata? Hae, du ani gman Dabid, ");
INSERT INTO bps_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Man Amuito Dwata di Amugu, manan, “Fagotgu ge i kdee, taman sudeng ge dini gsen di kwanangu, kel di kagfisangu dad dmuen ge, na kafkahgu dale di dungan falel bliam.” ’ ");
INSERT INTO bps_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na du katlo Dabid, i To Mgalék Dwata dunan Amu, na kan ku én katloyu kenen bel Dabid?” ");
INSERT INTO bps_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na landè to gamtimel kenen, na mdà di duh én talandè mayè smalek kenen. ");
INSERT INTO bps_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na kafnge én, talù Dyisas di kdee dad to na di dad gal mlalò kenen, manan, ");
INSERT INTO bps_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“I dad to tamdò i dad flalò na dad Farisi, ale i nun glal mubad dad flalò blé Dwata fagu di ku Mosis, ");
INSERT INTO bps_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","taman là fakay ku làyu nimen i kdee tulenla gamu, bay nangyu ganbet i dad nimòla du làla nimen i galla tdò. ");
INSERT INTO bps_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dee flalòla i dad to too malima nimen, gambet fkakifla di dad to i dad too blat nebe, bay balù satu tnalò, làla agot du tmabeng mebe dun. ");
INSERT INTO bps_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“I kdee fye nimòla, nimòla du fye fite di dademe to. Falbangla i dad gumkahla dad gusmulat Tnalù Dwata batangla di ulula na sigalla. Na ftahàla i fayolla di kilil klawehla du fye dag i dad to i kimenla Dwata. ");
INSERT INTO bps_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na én kayèla di dad fista i dad gusudeng i dad to too mgafè, na déén di dad gusatdò kayèla i fye gusudeng di muna. ");
INSERT INTO bps_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ku salu ale di fadyan kayèla ku too ale nafè i dad to déén, na ku ‘To Tamdò’ i kdagit dale. ");
INSERT INTO bps_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kabay nangyu faloh ku én kdagit gamu ‘To Tamdò,’ du i kdeeyu salngad du saflanek, na alò satu tamdò gamu. ");
INSERT INTO bps_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na nang gamu dmagit i to dini di tah tanà, ‘Mà,’ du alò satu i Màyu, dunan Dwata ditù di langit. ");
INSERT INTO bps_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na nangyu faloh ku nun dmagit gamu, ‘Amu,’ du alò satu Amuyu, dunan agu i Mgalék Dwata. ");
INSERT INTO bps_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na én too mdatah di kdeeyu dunan i to flifan i kton di dademen. ");
INSERT INTO bps_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Du balù simto to fdatah i kton, fdanà sa kadang, na balù simto to fdanà i kton, fdatah sa kadang.” ");
INSERT INTO bps_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Magakdo gamu dad tamdò i flalò blé Dwata na gamu dad Farisi! Fanlayam gamu kadang du tatì gamu flingu gamu fye to, bay nsangyu i dalan dad to fusuk di kagot Dwata. Là gamu mayè fusuk na balù i dad to mayè, làyu faloh dun. ( ");
INSERT INTO bps_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Magakdo gamu dad tamdò i flalò blé Dwata na gamu dad Farisi! Tatì gamu flingu gamu fye to, bay mlangong gamu i dad to balu du fye gwèyu dad knunla, na fantahàyu dasalyu du fye là dilè i dad to i ksasèyu. Taman baling matnù i flayamyu di fulé duh!) ");
INSERT INTO bps_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Magakdo gamu dad tamdò dad flalò blé Dwata na gamu dad Farisi! Fanlayam gamu kadang du tatì gamu flingu gamu fye to! Hae, mifal gamu i mahin na magu gamu di gumawagan di klamang banwe du fye gebeyu dad to di tdòyu balù alò satu to. Kabay ku tagebeyu kenen, matnù fa i ksasean di gamu, na mdatah fa i kagablaan salu di lanaw lifoh. ");
INSERT INTO bps_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Magakdo gamu du tamdò gamu i dalan di demeyu to, bay salngad gamu to butè gal malak dademe to, du ani tdòyu, ‘Ku nun to smafà fagu di Bong Gumnè Dwata, fakay ku laan dnohò dun, bay ku smafà kenen fagu di blawen di lam i gumangamfù di Dwata là fakay ku laan dnohò.’ ");
INSERT INTO bps_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tay too gamu kulang na butè! Tan i too mabtas, i blawen ku demen i Bong Gumnè Dwata. Alò mabtas i blawen di Dwata du déén di Bong Gumnean. ");
INSERT INTO bps_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na tdòyu kun, ‘Ku nun to smafà fagu di gudamsù di Dwata fakay ku laan dnohò i fakangan, bay ku smafà kenen fagu di dsù di tah i gudamsù là fakay ku laan dnohò i fakangan.’ ");
INSERT INTO bps_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tay kbutèyu! Tan i too mabtas, i dsù bléyu ku demen i gudamsù di Dwata? Silang gablà dsù di Dwata, ku tamatfing di gudamsù di kenen. ");
INSERT INTO bps_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taman ku nun to smafà fagu di gudamsù di Dwata gakuf i kdee fkah di tahan. ");
INSERT INTO bps_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na ku nun to smafà fagu di Bong Gumnè Dwata gakuf Dwata i mnè di lam. ");
INSERT INTO bps_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na ku nun to smafà fagu di langit, gakuf di safaan i gusudeng Dwata di langit na Dwata i sudeng di tahan. ");
INSERT INTO bps_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Magakdo gamu dad tamdò i dad flalò blé Dwata na dad Farisi! Fanlayam gamu kadang du tatì gamu flingu gamu fye to. Galyu blé di Dwata i gasfalò alel balù di dad malnak bol utenyu. Kabay fbayàyu i dad mdatah nimò, dunan i tlu kibòyu i demeyu to, na i kakdo na kagsalig. Ani moon tooyu nimò, na fadlug fa i kimenyu i dademe flalò galyu nimen. ");
INSERT INTO bps_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gamu salngad i dad butè gal malak dademe to! Snalàyu i dad malnak ngà langad mdà di ninumyu du fye landè magagsik ginumyu, bay gambet fanloyu baling i dad malbang lmanaf kamél magagsik, du nimenyu dad là alì mabtas di Dwata, bay fbayàyu dad mabtas. ");
INSERT INTO bps_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Magakdo gamu dad tamdò i dad flalò blé Dwata na gamu dad Farisi. Fanlayam gamu kadang du tatì gamu flingu gamu fye to fagu di klalòyu dee flalò, bay di lam nawayu too fnò klangong na klom. Salngad ku nalobyu di lwà i tabù na fligo, bay ditù di lam sana kagsikan. ");
INSERT INTO bps_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Butè gamu dad Farisi! Én fye nimòyu, funayu nalob di lam i tabù na fligo, na fagu déén, lê mlaneb di lwaan. ");
INSERT INTO bps_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Magakdo gamu dad to tamdò i dad flalò blé Dwata na gamu dad Farisi. Fanlayam gamu kadang du tatì gamu flingu gamu fye to. Gambet gamu i dad lbang galla fnintura bukay. Di lwà, too fye neye, bay knean ditù di lam too fnò tulan i dad to mati na i dad magagsik. ");
INSERT INTO bps_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na salngad én i gamu kagkah du di kite i dad to, matlu gamu, bay di lam nawayu tatì fnò i kaflingu na dee bung sasè. ");
INSERT INTO bps_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Magakdo gamu dad tamdò dad flalò blé Dwata na gamu dad Farisi. Fanlayam gamu kadang du tatì gamu flingu gamu fye to! Nimòyu i too fye baweh gulambang i dad tugad Dwata fnati, na fanseyu fnalas dad lbang i dad muna to matlu. ");
INSERT INTO bps_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na én manyu, kun, ‘Ku mto gami di bang i dad gutambulito là gami magin mati i dad tugad Dwata. ");
INSERT INTO bps_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na fagu di manyu én, nfunyu kadì na gamu bel i dad manò dad tugad Dwata! ");
INSERT INTO bps_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na taman snikofyu sa i tatanbù i dad gutambulyu.’ ");
INSERT INTO bps_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Salngad gamu dad ulad na i gutambulyu ulad! Tan i kibòyu falwà i ktoyu fye là gamu fanlayam di lanaw lifoh? ");
INSERT INTO bps_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dekgu di gamu kadang i dad tugad Dwata, na dad to nun kfulung, na dad nun bong gnadè mdà di Dwata. Na én nimòyu kadang fnati dademe, nlansang di krus dademe, na sankél dademe di lam i galyu gusatdò, na dluyu ale, balù nè banwe gumilala. ");
INSERT INTO bps_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na ani duenan én flayam blé Dwata di dad to manò i kdee dad to landè salà slame sulé di tahyu, mdà di kbanò ku Abél kel di kbanò Sakaraya i tingà Barakaya, i bnanòla di bleng i gumangamfù di Dwata na i gudamsù di kenen. ");
INSERT INTO bps_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tulengu gamu i kaglutan, gamu dad to di bang ani mebe i kdee kaflayam di kbanò i kdee ani.” ");
INSERT INTO bps_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Na man Dyisas, “E gamu dad to di Dyérusalém, gamu dad to mati i dad tugad Dwata, na tmudà batu kel di kfati i dad saligan dekan di gamu! Tadee dulêgu mayè samtifun gamu di ifatgu gambet i anuk mliton santifunan i dad unsuyan di dungan fafakan, bay là gamu mayè. ");
INSERT INTO bps_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na taman tnagak gamu Dwata na falmo kadang i banweyu. ");
INSERT INTO bps_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Du tulengu gamu, silangyu agu lêman teen ku takel i bang i kmanyu, ‘Nun kafye di to salu dini mebe i glal mdà di Amuito Dwata.’ ” ");
INSERT INTO bps_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na lamwà Dyisas di Bong Gumnè Dwata, na di kdaan fdadong di kenen dad gal mlalò kenen, na tdòla di kenen i kdee gumnè glam di Bong Gumnè Dwata. ");
INSERT INTO bps_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na manan, “Hae, neyeyu i kdee ani, du tulengu gamu i kaglutan, malbà sa kadang na landè batu gtagak di tagnè gugkahan du sdulê malbà kdeela.” ");
INSERT INTO bps_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na fles Dyisas di bulul dnagit Olib, na sudeng déén, na fdadong di kenen dad gal mlalò kenen di alò ale déén, na manla, “Tulenam gami ku kilen kagdohò i manam gine, na i tan ilè gugmadèmi i bang kasfuléam na i gusen i banwe.” ");
INSERT INTO bps_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na tmimel Dyisas, manan, “Too gamu fgeye du fye là gamu mgebe i dad to tamdò kakakéng, ");
INSERT INTO bps_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","du dee kadang dad to kel flingu mebe i dagitgu, manla, ‘Agu sa Krayst, i Mgalék Dwata.’ Na too dee dad to kadang mafgaw mdà di manla. ");
INSERT INTO bps_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na lingeyu kadang nun dad kasfati mdadong di gamu na dad santulen gablà di kasfati di dademe banwe, bay nang gamu likò, du glut muna kel kdee ani, bay ise ku én gusen i banwe. ");
INSERT INTO bps_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hae, du sfati kadang dad sahal to na i dad sahal banwe. Na mkel i kbitil na dad linol di dademe dad banwe. ");
INSERT INTO bps_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kabay i kdee ani alò katbù i dad kaflayam, salngad di kagkah i libun maltien ku lyon lbanad i tienan, bay là fa kel i too katdukan. ");
INSERT INTO bps_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Na di bang én, kanfè gamu i dad to na nebela gamu di dad ganlalla du fanlayamla, na fnatila gamu. Knang gamu nawa i kdee to du gamu dad togu. ");
INSERT INTO bps_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na di bang én, nun dee to kmagol i kafaglutla di deg, na baling ale sangkal na snang nawa. ");
INSERT INTO bps_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na dee kel dad to flingu tmugad i Tnalù Dwata, na fangawla dee dad to. ");
INSERT INTO bps_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na du matnù i kdee sasè, taman tatno kasakdo i dee dad to. ");
INSERT INTO bps_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kabay ku simto gamtayud kel di gusenan, galwà kenen. ");
INSERT INTO bps_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na silang kel gusen i banwe ku tagatdò i Fye Tulen gablà di kagot Dwata di klamang banwe du fye mlinge kdee bung to di tah tanà i kaglutan.” ");
INSERT INTO bps_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na teenyu kadang i too gamlikò gal falmo, tadag di Gumnè Dwata, dunan i gman Dwata fagu di tugadan Danyél. (Gamu masa ani, tooyu fandam du fye glabatyu.) ");
INSERT INTO bps_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na ku teenyu i too gamlikò én, ku déén gamu di Dyudiya mila gamu di dad bulul. ");
INSERT INTO bps_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na ku nun to déén di lwà nang kenen fusuk di gumnean du mwè balù i tan. ");
INSERT INTO bps_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na salngad i to mimò di nligon, nang nan mulê funa du mwè i klawehan. ");
INSERT INTO bps_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Di bang én kadang, too magakdo i dad libun maltien na dad to nun malnak ngà tmutù. ");
INSERT INTO bps_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taman too gamu dmasal du fye là kel i kilayu di bang ksasè tanà ku demen di Duh Kaftud. ");
INSERT INTO bps_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Hae, du balù tan ksasè i dad kaflayam mkel mdà di katbù i banwe kel di duh ani, landè gasngad di ksasè ani. ");
INSERT INTO bps_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kabay fanfukal Dwata i klo i bong kaflayam ani, du ku là, landè to gtagak mto. I duenan fafukal i bang ani du too bong nawan i dad to tamgalékan. ");
INSERT INTO bps_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Di bang én ku nun to mangman di gamu, ‘Neyeyu, dini Krayst, i Mgalék Dwata!’ ku demen, manan, ‘Ditù kenen!’ nang gamu faglut, ");
INSERT INTO bps_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","du di bang én, dee to msut flingu na ale kun, Krayst, i Mgalék Dwata. Na man dademe, ale kun, tugad Dwata, bay ise. Na mimò ale dad bong tnikeng na dad ilè ktulusla, du ku nun kibòla kayèla ku mafgaw i kdee to balù i dad to mgalék Dwata. ");
INSERT INTO bps_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tagmangu kdee ani di gamu di laan fa kel, taman fgeye gamu. ");
INSERT INTO bps_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Na ku nun mangman di gamu, ‘Neyeyu, taditù Krayst di banwe landè to mnè déén,’ nang gamu salu ditù. Na ku manla, ‘Neyeyu, dini di lam gusalbunin,’ nangyu fnaglut. ");
INSERT INTO bps_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hae, du i kasfulêgu kadang, agu i dnagit Tingà To, too teen gambet i silà magtuyal i klamang langit mdà di gusut i duh kel di gusdafan. ");
INSERT INTO bps_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Too gdohò kdee i gmangu ani, du too glut i gal gman, ku nè gugilè i mati, déén sa i gustifun i dad wak du knaanla.” ");
INSERT INTO bps_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Na man Dyisas, “Kafnge i dad kaflayam én, mbaling kifu i duh, na là nan mneng i bulen, na tatek i dad blatik mdà di langit, na gasyat i kdee mnè di langit di tagnè dalanla. ");
INSERT INTO bps_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Kafnge én, msut di langit ilè kasfulê Tingà To, na sdulê mlanu dad to mdà di kdee banwe di tah tanà di kitela deg, i dnagit Tingà To, tufa di lam i labun di ksalugu dini magin i bong eneg na kneng mdà di kdatahgu. ");
INSERT INTO bps_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kafnge én, nun bong uni i twang na dekgu i dad kasaligan Dwata ditù di kdee suluk i banwe du santifunla i kdee dad to mgalék Dwata mdà di kdee banwe dini di tah tanà.” ");
INSERT INTO bps_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na man Dyisas, “Satu gugmadèyu kagkah i tanà di kayu fig. Ku tmubad na tambù dmoon gadèyu too mdadong nan i bang kafye tanà. ");
INSERT INTO bps_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na salngad én, ku tateenyu takel i dad ilè mangu gamu gine, gadèyu tamdadong nan i kasfulêgu, salngad ku tatadag agu di bà takab. ");
INSERT INTO bps_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tulengu gamu i kaglutan, kel kadang kdee ani di là fa mati i kdee dad to di bang ani. ");
INSERT INTO bps_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Matlas i langit na tanà, bay là matlas i tnalùgu kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kabay landè to gmadè i duh ku demen i too bang kasfulêgu, balù i dad kasaligan Dwata di langit ku demen deg, i Tingà Dwata, du alò Mà gmadè dun. ");
INSERT INTO bps_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","I kagkah i dad to di kasfulê i dnagit Tingà To, salngad i kagkah dad to di bang Nowa, ");
INSERT INTO bps_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","du di là fa kel i bong dunuk di dale landè fandam i dad to i fan kel, taman én nimòla kmaan, na minum, na mwè yaan, na fwèla yaan dad ngàla kel di kfusuk Nowa di bong awengan. ");
INSERT INTO bps_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Silang ale gmadè, di kakel i bong dunuk i mlimas dale. Na gambet ani kagkah di kasfulêgu, agu i dnagit Tingà To. ");
INSERT INTO bps_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Di kakelgu nun lwe to mimò di tanàla, na nwè satu, bay i satu mtagak. ");
INSERT INTO bps_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nun lwe libun gmiling, na nwè satu, bay i satu mtagak. ");
INSERT INTO bps_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Taman too gamu fgeye du làyu gadè ku kilen i duh kasfulêgu, agu i Amuyu. ");
INSERT INTO bps_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ani fandamyu, ku tagadè i mfun gumnè i bang kakel i to tmaku, laan kudang bay fgeye du fye là gfusuk i to tmaku di gumnean. ");
INSERT INTO bps_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Taman salngad gamu, too gamu fatlagad, du agu, i dnagit Tingà To, kel di bang i man nawayu ise fa bang kakelgu.” ");
INSERT INTO bps_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Na man Dyisas, “Simto i salig too gsalig na too fulung? Dunan i salig gufagot i amun i dademe dad saligan, du fye nalelan dale i knaanla ku tabang kablé dun. ");
INSERT INTO bps_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Too nun kafye i salig di kakel i amun ku teenan kenen mimò i fimò kenen. ");
INSERT INTO bps_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tulengu gamu i kaglutan, ku ani teenan, fagotan i saligan ani i kdee dad knunan. ");
INSERT INTO bps_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kabay, ku sasè baling i saligan ani, na manan di kton, ‘A, mlo fa kulê i amugu,’ ");
INSERT INTO bps_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na tanbuan fatduk i dademen dad salig, na too kenen kmaan na minum di saféd i dad to flangal. ");
INSERT INTO bps_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na ku én nimoan, ani sa mkel di kenen. Samfulê i amun di bang i laan gadè dun na laan fandam ku kel. ");
INSERT INTO bps_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na i kibò i amun kenen, toon fanlayam, na fakufan kenen di gaslok i dademe to flingu ale fye to, déén di gumlanula na gukminggat i kifanla.” ");
INSERT INTO bps_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na fadlug Dyisas talù, manan, “Én guflingengu i kagot Dwata di bang kasfulêgu, di sfalò sawang libun. Nwèla dad salòla, du snitongla i lagi sandeme. ");
INSERT INTO bps_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lime ale i là fulung faldam, na lime fulung faldam. ");
INSERT INTO bps_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I lime là fulung faldam, nebela i salòla, bay landè nebela tnù fngalola. ");
INSERT INTO bps_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kabay i dad libun fulung faldam nebela dad salòla na nun nebela tnù fngalo. ");
INSERT INTO bps_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na du léét kel i lagi sandeme snitongla, taman kdeela malkudang na fles ale kudang. ");
INSERT INTO bps_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na di tngà butang, nun lingela tamlo, manan, ‘Takel i lagi sandeme. Lamwà gamu na snitongyu!’ ");
INSERT INTO bps_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na mukat i dad sawang libun na fatlagadla i dad salòla. ");
INSERT INTO bps_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na talù i lime libun là fulung faldam di dademela fulung faldam, manla, ‘Banléyu gami tukay fngaloyu du tafan mati dad salòmi.’ ");
INSERT INTO bps_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Kabay tmimel dad fulung faldam, manla, ‘Landè kibòmi du ken là gablà i fngalomi ku banlémi gamu. Mdà gamu salu di dad to fabli du mayad fngalo, fye nun salòyu.’ ");
INSERT INTO bps_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Taman tamdà ale mayad fngalo, na di slengla ditù takel i lagi sandeme. Na i lime sawang libun tagatlagad, magin salu di kasdeme. Na di kagfusukla tnakab sa i takab. ");
INSERT INTO bps_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Na là mlo takel i dademe sawang libun, na manla, ‘E Amu! Amu, begam nukà gami i takab!’ ");
INSERT INTO bps_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Kabay tmimel kenen, manan, ‘Tulengu gamu i kaglutan, làgu gamu dilè!’ ” ");
INSERT INTO bps_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na man Dyisas, “Taman too gamu fgeye du salngad gamu ani, làyu gadè i duh na i too bang kasfulêgu.” ");
INSERT INTO bps_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na man Dyisas, “Nun fa guflingengu i kagot Dwata di satu to fan mdà magu, na tlon i dad saligan na fagotan dale dad knunan. ");
INSERT INTO bps_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Di satu blén lime libu filak, na di satu lwe libu, na di satu mlibu. Én blén kat to i kalbong gaganan nagot. Na kafnge én, mdà kenen. ");
INSERT INTO bps_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","I salig fagotan i lime libu gasil mdà na fagun filak di nimò, na i uléan lime libu. ");
INSERT INTO bps_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na salngad én kibò i to fagotan lwe libu filak, na i uléan lwe libu filak. ");
INSERT INTO bps_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kabay i to fagotan mlibu filak tabalingan buni. Makol kenen di tanà na lbangan i filak tafagot amun kenen. ");
INSERT INTO bps_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Na too mlo klo i amula mulê. Kakelan, neyen i filak tafagotan dad saligan. ");
INSERT INTO bps_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na i salig fagotan lime libu filak salu déén na blén i lime libu filak ulê i blé kenen. Na manan, ‘Amu, tafagotam deg lime libu filak, neyem ani i lime libu gatnùgu di filak blém deg.’ ");
INSERT INTO bps_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Na man i amun di kenen, ‘Too fye i nimoam! Too ge fye na gsalig. Too ge gsalig di tukay fagotgu ge, taman ani, fagotgu ge i bong. Fusuk ge dini, na fakuf ge di klehewgu.’ ");
INSERT INTO bps_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Na lêman salu ditù i to fagotan lwe libu, na manan, ‘Amu, tafagotam deg lwe libu filak, neyem ani lwe libu gatnùgu di filak blém deg.’ ");
INSERT INTO bps_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Na man i amun di kenen, ‘Too fye i nimoam! Too ge fye na gsalig. Too ge gsalig di tukay fagotgu ge, taman ani, fagotgu ge bong. Fusuk ge dini na fakuf ge di klehewgu.’ ");
INSERT INTO bps_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kafnge én, salu ditù di amun i to tafagotan i mlibu filak. Na manan, kun, ‘Amu, gadègu too ge labè. Hae, du kamtu ge ise ge fla, na galam nwè i ise ge fule. ");
INSERT INTO bps_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Taman likò agu ge, na bunigu i filak fagotam deg di lam i tanà. Neyem, ani filakam!’ ");
INSERT INTO bps_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na én man i amun di kenen, ‘Too ge sasè na mataka! Man nawam kadì kantugu i ise deg fla na nwègu i ise deg fule. ");
INSERT INTO bps_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na kan ku laam kah i filakgu di bangku du fye gasfulê di deg na nun tingaan? ");
INSERT INTO bps_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Nwèyu di kenen i mlibu, na bléyu di salig i nun sfalò libu. ");
INSERT INTO bps_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Du ku simto to gsalig di fagotgu kenen, tananùgu i fagotgu du fye too bong. Kabay ku simto là gsalig, nawì di kenen balù i tukay tafagot di kenen. ");
INSERT INTO bps_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na i salig landè gukmamu batyu ditù di lwà di gukmifun, déén di gumlanun na gukminggat i kifanan.’ ” ");
INSERT INTO bps_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na fadlug Dyisas talù, manan, “Di kasfulêgu kadang, agu i dnagit Tingà To gagin i bong kdatahgu, magin deg i dad kasaligan Dwata. Na di bang én, sudeng agu di gusudeng i mdatah harì. ");
INSERT INTO bps_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na i kdee dad to di tah tanà santifun di kanfegu. Na sansahalgu ale gambet i to mifat i bilibili ku sansahalan i dad bilibili di dad kambing. ");
INSERT INTO bps_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Én dad to matlu flingengu di bilibili fkahgu gsen di kwanangu, na i dad là matlu flingengu di dad kambing fkahgu gsen di ibenggu. ");
INSERT INTO bps_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kafnge én, agu, i Harì, talù agu di dad to gsen di kwanangu, mangu, ‘Gamu, dad gamdawat i kafye màgu, salu gamu dini di deg, na dnawatyu i kagot tagaan gamu mdà di kgimò i banwe. ");
INSERT INTO bps_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gdawatyu ani du di kbitilgu tafankaanyu agu, di kalinumgu tafninumyu agu, di là kdilèyu deg tafyakyu agu di gumnèyu, ");
INSERT INTO bps_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","di klandè klawehgu, tabanlèyu agu, di knun tdukgu, tanifatyu agu, di bnilanggù agu tanlauyyu agu.’ ");
INSERT INTO bps_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Na smalek i dad to matlu, manla, ‘Amu, kilen kitemi ge bitil na fankaanmi ge, ku demen malinum, na fninummi ge? ");
INSERT INTO bps_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kilen là kdilèmi ge na fyakmi ge di gumnèmi? Kilen klandè klaweham na banlémi ge? ");
INSERT INTO bps_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na kilen kitemi ge nun tduk ku demen bnilanggù na nlauymi ge?’ ");
INSERT INTO bps_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Na agu, i Harì, tmimel agu, mangu, ‘Tulengu gamu i kaglutan, ku tan i nimòyu di satu flanekgu balù ku too mdanà to, salngad ku di deg i gumimòyu dun.’ ");
INSERT INTO bps_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kafnge én, ani mangu di dad to gsen di ibenggu, ‘Fawag gamu di deg, gamu dad to sasè tanukum Dwata. Ditù gamu di lanaw lifoh landè gumatin tatagà Dwata du gumlayam ku Satanas na dad kasaliganan, ");
INSERT INTO bps_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","du di kbitilgu làyu agu fankaan, na di kalinumgu làyu agu fninum. ");
INSERT INTO bps_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Di là kdilè deg làyu agu fyak di gumnèyu. Di klandè klawehgu làyu agu banlé. Di knun tdukgu na bnilanggù agu, làyu agu nlauy.’ ");
INSERT INTO bps_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na i dad to én kadang, smalek ale, manla, ‘Amu, kilen kitemi ge bitil, demen malinum, demen di banwe landè dmilè ge, demen landè klaweh, demen nun tduk, ku demen bnilanggù, na làmi ge tnabeng?’ ");
INSERT INTO bps_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Na tnimelgu ale kadang, mangu, ‘Tulengu gamu i kaglutan, ku tan i làyu nimò di dad flanekgu balù too mdanà to, salngad ku làyu nimò di deg.’ Én mangu di dale. ");
INSERT INTO bps_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Na i dad to én, ditù gusalula di gumaflayamla landè sen, bay i dad to matlu banlé ale nawa landè sen.” ");
INSERT INTO bps_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Di kafnge Dyisas tamdò i kdee ani, manan di dad gal mlalò kenen, ");
INSERT INTO bps_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gadèyu lwe duh ani i fista Duh Kaglius, na agu, i dnagit Tingà To, blé di agot i dad to du fye nlansangla di krus.” ");
INSERT INTO bps_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na di bang kman Dyisas ani stifun i dad ulu i dad bà di Dwata na dad tua gal mebe dad Dyu déén di bong gumnè Kayafas, i gumdatah i dad bà di Dwata. ");
INSERT INTO bps_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Stulen ale ku tan i fye kibòla kamfè ku Dyisas du fye fnatila kenen di landè to gmadè dun. ");
INSERT INTO bps_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kabay manla, “Nangito nimò ani di bang i fista du ken flabè i dee dad to na too ale smamuk.” ");
INSERT INTO bps_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na déén Dyisas di tukay banwe Bétani di gumnè Simon, i to tanfig. ");
INSERT INTO bps_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na di slengla kmaan, nun satu libun kel déén mebe sabuy batu fnò fangbun too mabtas, na kokan ani di ulu Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kite i dad gal mlalò ku Dyisas i nimoan, flabè ale. Na manla, “Kan ku falmon i fangbun? ");
INSERT INTO bps_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Fye fa ku fablin, du bong gwean fakay blé di dad to landè.” ");
INSERT INTO bps_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kabay gadè Dyisas i manla, taman manan di dale, “Kan ku snamukyu libun ani? Du too fye nimoan di deg. ");
INSERT INTO bps_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gal nun dad to landè di safédyu fakayyu tnabeng, bay deg, là agu mlo mnè di safédyu. ");
INSERT INTO bps_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Di kakokan i fangbun gine di deg, falan fatlagad lawehgu du lbang. ");
INSERT INTO bps_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na tulengu gamu i kaglutan, balù nè gutamdò i Fye Tulen gablà di deg di tah tanà ani, lê tulen nimò libun ani du fye gafaldam kenen.” ");
INSERT INTO bps_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kafnge én, nun satu di dad sfalò lwe to gal mlalò ku Dyisas dnagit ku Dyudas Iskariyot salu di dad ulu i dad bà di Dwata, ");
INSERT INTO bps_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na manan, “Tan bléyu deg ku blégu di gamu Dyisas?” Na bléla kenen tlu falò batù filakla salafì. ");
INSERT INTO bps_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na mdà di bang én, mngabal Dyudas i kfagu mlé ku Dyisas di agotla. ");
INSERT INTO bps_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Di tnanin duh i Fista i Kakaan i Fan Landè Falnok Dun, fdadong dad gal mlalò ku Dyisas di kenen, na smalek ale, manla, “Nè kayeam gufatlagadmi knaan di Duh Kaglius?” ");
INSERT INTO bps_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na man Dyisas di dale, “Salu gamu di satu to mnè di syudad, na manyu di kenen, ‘Man i To Tamdò takel i bangan gdohò i kdee tagmanan, na én gukmaanan knaan i Duh Kaglius di gumneam magin dad gal mlalò kenen.’ ” ");
INSERT INTO bps_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na nimenla i kdee gman Dyisas di dale. Na ditù gufatlagadla knaanla i Duh Kaglius. ");
INSERT INTO bps_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na di butang én, sudeng Dyisas na dad sfalò lwe gal mlalò kenen du kmaan. ");
INSERT INTO bps_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na di slengla kmaan, talù Dyisas, manan, “Tulengu gamu i kaglutan, nun kadang satu di gamu mangkal deg di fati.” ");
INSERT INTO bps_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na too mlidù nawala, na kat satu dale smalek kenen, manla, “Amu, agu kè i manam?” ");
INSERT INTO bps_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na tmimel Dyisas, manan, “I to msong deg, én mangkal deg. ");
INSERT INTO bps_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Too glut, agu i dnagit Tingà To, gsalu di fati salngad i tagsulat gablà di deg. Kabay too magakdo kadang i to mangkal deg. Fye fa baling di to én ku laan sut.” ");
INSERT INTO bps_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na talù Dyudas, i mangkal ku Dyisas, manan, “Amu, agu dé i mangkal ge?” Na man Dyisas, “Tamanam sa.” ");
INSERT INTO bps_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na di slengla kmaan, nwè Dyisas i fan, na funa dmasal mlé fye di Dwata, na snatngaan na blén di dad gal mlalò kenen, manan, “Nwèyu ani, na knaanyu du ani lawehgu.” ");
INSERT INTO bps_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kafnge én, nwean i ninum, na mlé fye di Dwata, na blén di dale, manan, “Sansinumyu ani, kdeeyu, ");
INSERT INTO bps_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","du ani litègu falohgu du fye nlifet Dwata dad salà i dee dad to, du litègu i kaglut di falami dalan i fakang Dwata falwà i dad to. ");
INSERT INTO bps_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na tulengu gamu, là agu lêman minum i nimum ani kel di duh ksasatuito lêman di kagot i Màgu na minum ito i falami binu.” ");
INSERT INTO bps_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kafnge én mlingag ale i satu lingag dmayen Dwata na kafngela mlingag mdà ale salu di bulul Olib. ");
INSERT INTO bps_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na talù Dyisas di dad gal mlalò kenen, manan, “Kadang butang ani, kdeeyu baling mila na tmagak deg, du man Dwata di Tnaluan, manan, ‘Fnatigu i to gal mifat dad bilibili, na sbalét dad bilibilin.’ ");
INSERT INTO bps_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kabay ku tamték agu mdà di fati, muna agu di gamu salu di Galili.” ");
INSERT INTO bps_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na man Fiter di ku Dyisas, “Balù mila i kdee dademe, bay làta ge tagak.” ");
INSERT INTO bps_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Na man Dyisas di ku Fiter, “Tulengu ge i kaglutan, kadang butang ani, di là fa kamleet i anuk, tmulen ge tlu dulê i laam agu dilè.” ");
INSERT INTO bps_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kabay man Fiter, “Balù ku mati agu magin ge, là agu tmulen kéng i là agu dmilè ge.” Na salngad i man kdee dad gal mlalò ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na fadlug ale Dyisas salu di satu tanà dnagit Gétsémani, na manan di dad gal mlalò kenen, “Sudeng gamu dini di lamgu dmasal ditù.” ");
INSERT INTO bps_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na faginan Fiter na i lwe dad ngà Sébidi salu di gudmasalan. Na tambù én too mlidù na too msamuk nawan. ");
INSERT INTO bps_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na manan di tlu magin kenen, “I klidù nawagu ani too blat gambet tafan agu mati. Mnè gamu dini, na too gamu fgeye dmeme deg.” ");
INSERT INTO bps_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na salu kenen di là too mawag, na tatì kenen lamfan di tanà na dmasal, manan, “E Mà, gaganam i kdee, taman begam nwè i kaflayam fangu nagu ani. Kabay balù én i deg knayè, toom dnohò i ge knayè.” ");
INSERT INTO bps_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kafngen dmasal, samfulê kenen di dad gal mlalò kenen faginan gine, na teenan ale kudang. Na snalekan Fiter, manan, “Là ge kè gamtayud fgeye dmeme deg balù là mlo alò? ");
INSERT INTO bps_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Too gamu fgeye na dmasal fye là gamu fisan di tilew, du balù mayè i nawayu mimò fye, bay nun klungay i lawehyu mimò dun.” ");
INSERT INTO bps_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na lêman samfulê Dyisas di gudmasalan, na manan, “E Mà, ku landè kibò mwè i kaflayam fan kel ani silang ku nagugu, fye ku gdohò i ge knayè.” ");
INSERT INTO bps_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na lêman kenen samfulê na lêmanan ale teen gkudang du too ale malkudang. ");
INSERT INTO bps_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na lêman ale tnagak Dyisas, na dmasal di gatlun dulê na salngad i manan. ");
INSERT INTO bps_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na lêman samfulê Dyisas di safédla, na manan di dale, “Tan, kudang gamu fa na ftud? Neyeyu, takel i bang kablé deg, i dnagit Tingà To, di agot i dad to gamsalà. ");
INSERT INTO bps_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mték gamu du mdà ito. Neyeyu, tadini i to mangkal deg.” ");
INSERT INTO bps_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Di slengan fa talù takel Dyudas, satu di sfalò lwe gal mlalò kenen. Na too dee dad to magin kenen mebe dad sundang na dad bunal. Tamdek dale i dad ulu dad bà di Dwata na dad tua gal mebe dad Dyu. ");
INSERT INTO bps_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na nun ilè tatulen i to mangkal di dad to faginan kamfè ku Dyisas, manan, “I to nalakgu kadang, én i to fanngabalyu. Kanfèyu kenen!” ");
INSERT INTO bps_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Taman kakel ale Dyudas déén, gasil kenen fdadong di ku Dyisas, manan, “E Amu!” Na nalakan Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na man Dyisas di kenen, “Lew, fnaflalam i kayeam nimò.” Kafnge én, fdadong i dad to magin ku Dyudas, na kanfèla Dyisas na toola nafas. ");
INSERT INTO bps_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kabay satu to magin ku Dyisas nsoan i sundangan, na tniben i lifan i gumdatah dad bà di Dwata, na masfek i bali klingen. ");
INSERT INTO bps_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na man Dyisas di to én, “Fuléam di lumaan i sundangam du ku simto to magot tek, mati fagu di tek. ");
INSERT INTO bps_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Laam kè gadè ku mni agu tabeng di Màgu Dwata, feben sa dini dee libu dad kasaliganan du tmabeng deg? ");
INSERT INTO bps_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kabay ku én i nimògu, là gdohò i kdee gman Dwata di Tnaluan gablà di gnagugu.” ");
INSERT INTO bps_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na talù Dyisas di dee dad to kamfè kenen, manan, “Kan, to tmaku agu kè du mebe gamu sundang na bunal di kakfèyu deg? Klit duh sudeng agu tamdò di Bong Gumnè Dwata na làyu agu kanfè. ");
INSERT INTO bps_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kabay én duen mgimò kdee ani du fye gdohò i tagsulat dad tugad Dwata.” Na di kman Dyisas ani i kdee dad gal mlalò kenen tnagakla kenen na mila. ");
INSERT INTO bps_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na i dad to kamfè ku Dyisas nebela kenen di bong gumnè Kayafas, i gumdatah di dad bà di Dwata. Na tastifun déén i dad to gal mukum, dunan dad tamdò i dad flalò blé Dwata fagu di ku Mosis na i dad tua gal mebe dad Dyu. ");
INSERT INTO bps_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na mlalò Fiter kel di nasel i bong gumnè i gumdatah i dad bà di Dwata, bay fawag di fulé. Kakelan déén fusuk kenen na fasbool sudeng di saféd i dad to munung du fye gadean i mkel di ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na i dad ulu di dad bà di Dwata na i dademe ganlal gal mukum tastifun déén, mngabal ale kfagu fsalà ku Dyisas, balù là glut, gumdàla mati kenen. ");
INSERT INTO bps_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kabay balù too dee tmulen kakakéng gablà di ku Dyisas knean landè teenla salaan. Kabay di gusenan nun lwe to salu di muna, ");
INSERT INTO bps_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na manla, “Én gman i to ani, ‘Gagangu lambà i Bong Gumnè Dwata na lêman ftadag dun di lam tlu duh.’ ” ");
INSERT INTO bps_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kafnge én, tadag i gumdatah i dad bà di Dwata na snalekan Dyisas, manan, “Landè kè timelam di kdee tulenla salaam ani?” ");
INSERT INTO bps_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kabay là tmimel Dyisas balù landè salaan. Taman lêman talù i gumdatah dad bà di Dwata di kenen, manan, “Fagu di dagit Dwata too mto, smafà ge, na tulenam gami ku ge i Mgalék Dwata, dunan i Tingaan?” ");
INSERT INTO bps_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na man Dyisas di kenen, “Tagmanam sa! Kabay tulengu gamu, di fulé duh teenyu agu, i dnagit Tingà To, sudeng di kwanan i mdatah ganlal, dunan Dwata Too Mtulus, di ksalugu dini di lam i labun mdà di langit!” ");
INSERT INTO bps_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Na di kaklinge gumdatah i dad bà di Dwata i gman Dyisas ani, knaséan klawehan du ilè knangan i man Dyisas, na manan, “E tay, tafsalngadan kton di Dwata! Landè kamuito dademe to mlé kenen salà, du talingeyu kafalmon Dwata. ");
INSERT INTO bps_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","I tan sa kukumyu kenen?” Na tmimel i dademen, manla, “Gablà kenen fnati.” ");
INSERT INTO bps_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kafnge én, dnulàla i baweh Dyisas, na snuntukla, na dademe snafangla matan na snamfakla, ");
INSERT INTO bps_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na manla, “Na ge, Mgalék Dwata, manam sa kun ku simto smamfak ge!” ");
INSERT INTO bps_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na ditù fa gusudeng Fiter di nasel i gumnè. Na fdadong di kenen satu libun gal dek i gumdatah i dad bà di Dwata, na manan, “Ge i satu gal magin ku Dyisas mdà di Galili.” ");
INSERT INTO bps_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kabay baling malew Fiter di muna i kdee dad to déén, manan, “Làgu gadè i manam.” ");
INSERT INTO bps_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na salu Fiter di bà gufusuk i nasel. Na lêman nun libun gal dek mite kenen, na manan di dad to déén, “To ani satu gal magin ku Dyisas mdà di Nasarét.” ");
INSERT INTO bps_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kabay lêman malew Fiter na smafà, na manan, “Làgu dilè i to én!” ");
INSERT INTO bps_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na di là mlo nun dademe dad to tadag déén fdadong di ku Fiter, na manla, “Too glut sa, ge i satu di dale du dilèmi du mahal uni taluam.” ");
INSERT INTO bps_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na lêman kenen tambù smafà, manan, “Fanlayam agu i Dwata ku tmulen agu kéng. Làgu dilè i to én!” Na di kmanan én, kamleet i anuk, ");
INSERT INTO bps_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","na gafaldam Fiter i gman Dyisas di kenen, “Di là fa kamleet i anuk tatmulen ge tlu dulê laam agu dilè.” Na lamwà kenen na too mngel. ");
INSERT INTO bps_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na di too flafus stifun i kdee dad ulu i dad bà di Dwata na dad tua gal mebe dad Dyu du stulen ku i tan kfagula fafati ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na én nimòla, fbakusla kenen na nebela di ku Filat, i gubirnador, du fukumla kenen. ");
INSERT INTO bps_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na Dyudas, i mangkal ku Dyisas, di kgadean too glut tanukum Dyisas di fati too kenen msal, na fuléan i tlu falò batù filak salafì di dad ulu i dad bà di Dwata na dad tua gal mebe dad Dyu, ");
INSERT INTO bps_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","manan, “Gamsalà agu di kablégu i to landè salà di fati.” Na tmimel ale, manla, “Landè labetmi gami. Ge salà én!” ");
INSERT INTO bps_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Taman bat Dyudas i filak tabléla kenen di lam i Bong Gumnè Dwata na mdà. Na fles kenen mikat lial. ");
INSERT INTO bps_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na di kuku i dad ulu di dad bà di Dwata i filak tabat Dyudas, manla, “Mlafà ito i flalò Mosis ku fkahito filak ani di gal gumusek filak di Bong Gumnè Dwata, du ani bayad i kfati satu to.” ");
INSERT INTO bps_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Taman stulen ale i fye kfagula dun. Na bnayadla satu tanà i gal gumimò kulang tanà du fye gulambangla i dad to magu mdà di mahal banwe, ku mati ale déén. ");
INSERT INTO bps_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Taman én dagit i tanà én kel di duh ani, dunan i Tanà Litè. ");
INSERT INTO bps_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Taman gdohò sa i gman Dyérimaya i tugad Dwata, manan, “Nwèla i tlu falò batù filak salafì, i btas knayè dad bel Israél di kbayadla kenen. ");
INSERT INTO bps_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na én i bayadla i tanà gumimò kulang tanà, du én i flau Amugu deg.” ");
INSERT INTO bps_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na tadag Dyisas di muna Gubirnador Filat, na smalek Filat, manan, “Ge kè Harì i dad Dyu?” Na man Dyisas, “Tagmanam sa.” ");
INSERT INTO bps_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kabay laan tnimel i kdalam dad ulu i dad bà di Dwata na dad tua gal mebe dad Dyu. ");
INSERT INTO bps_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Taman man Filat di kenen, manan, “Man, laam kè linge i kdee dalamla ge?” ");
INSERT INTO bps_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kabay là tmimel Dyisas balù tan i dalamla kenen, na taman too tikeng i gubirnador. ");
INSERT INTO bps_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na klit fali di bang i fista Duh Kaglius, i tagnè nimò Filat falwaan satu to bnilanggù, ku simto knayè i dad Dyu, én i falwaan. ");
INSERT INTO bps_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na di bang én, nun satu to bnilanggù dnagit ku Barabas too mdengeg mdà di dad mgimoan. ");
INSERT INTO bps_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Taman di kagastifun i kdee dad to, snalek ale Filat, manan, “Simto kayèyu falwàgu gamu, Barabas ku demen Dyisas, i dnagit Krayst?” ");
INSERT INTO bps_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Én duenan smalek, du gadè Filat i duen dad ulu i dad Dyu mebe ku Dyisas di kenen du mingà nawala ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na di sleng Filat sudeng di gal gumukum nun febe i yaanan kenen fngewe, manan, “Nangam fanlayam i to én, du landè salaan. Hae, du malbutang kamna agu na too msamuk i nawagu gablà di kenen.” ");
INSERT INTO bps_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kabay i dad ulu i dad bà di Dwata na dad tua gal mebe i dad Dyu banlétla i dad to fye fnila di ku Filat falwà Barabas na fnati Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na lêman ale snalek Filat, manan, “Simto di lwe to ani kayèyu falwàgu di gamu?” Na manla, “Barabas!” ");
INSERT INTO bps_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na smalek Filat, manan, “Na tan i kibògu ku Dyisas, i dnagit Krayst?” Na tmimel kdeela, manla, “Flansangam di krus!” ");
INSERT INTO bps_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na smalek Filat, manan, “Kan? Tan i salaan?” Kabay baling matnù i kakitla, manla, “Flansangam kenen di krus!” ");
INSERT INTO bps_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Taman gadè Filat landè kiboan, du baling tambù nan mimò samuk i dad to. Na taman mwè kenen yéél na naloban i kmalan di muna i kdee dad to, na manan, “Ise deg tmimel di kfati i to ani. Déén i litean di gamu kmal.” ");
INSERT INTO bps_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na tmimel i kdee dad to, manla, “Hae, gami na dad belmi i tmimel gablà di kfati i to ani.” ");
INSERT INTO bps_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na taman nagin Filat i knayè dad Dyu, na falwaan Barabas di dale. Kabay Dyisas, funan too faskél, na kafnge én, blén di dad sundalun du flansang di krus. ");
INSERT INTO bps_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na i dad sundalu, nebela Dyisas di lam i bong gumnè Filat. Na santifunla i kdee dademe sundalu di glibutan. ");
INSERT INTO bps_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na nlusla dad klawehan na falsakla kenen i klaweh fulè, du fagbetla kenen harì. ");
INSERT INTO bps_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na nlikinla dad walad nun sual, na sukubla di ulun du nimòla kyangenan. Na fagotla kwananan satu tugad gambet i gal nagot i dad harì. Kafnge én, lkuad ale di munan, du snilola, manla, “Too ge mlawil Harì i dad Dyu.” ");
INSERT INTO bps_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na sandulàla kenen na nwèla lêman i tugad gine du skélla di ulun. ");
INSERT INTO bps_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Di kafngela smilo kenen lêmanla nlus i klaweh tafalsakla kenen, na falsakla lêman i tagnè klawehan. Na kafnge én, nebela kenen di gumlansangla di krus. ");
INSERT INTO bps_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Di kalwàla di Dyérusalém, gsitongla i satu lagi dnagit ku Simon mdà di banwe Sirini, na gnagala mebe i krus Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na salu ale di tukay bulul dnagit Golgota. Na i gumtatek Golgota, dunan banwe i tulan ulu. ");
INSERT INTO bps_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kakella ditù banléla kenen binu sanbool bulung féét, bay di kagneman dun, laan fles ninum. ");
INSERT INTO bps_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na kafngela mlansang kenen di krus, sansalella i klawehan fagu di kasbunut du neyela ku simto i dad gamfun dun. ");
INSERT INTO bps_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kafnge én, sudeng ale déén na nunungla kenen. ");
INSERT INTO bps_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na nun sulat tmulen i salà dalamla kenen fkahla di tah i ulun, manan, “Ani Dyisas, Harì i dad Dyu.” ");
INSERT INTO bps_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na nun lwe to tmaku nlansangla di saféd Dyisas satu gsen di kwananan na satu gsen di ibengan. ");
INSERT INTO bps_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na i dad to magu mlius déén toola snilo Dyisas na kmiling ale du fanngulêla kenen, ");
INSERT INTO bps_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","manla, “Ge kun, i to gmagan lambà i Bong Gumnè Dwata na lêman ftadag dun di lam tlu duh, taman falwaam i ktom ku gaganam. Ku ge i Tingà Dwata, tufa ge mdà di krus!” ");
INSERT INTO bps_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na salngad nimò i dad ulu di dad bà di Dwata, na dad tamdò dad flalò blé Dwata fagu di ku Mosis, na dad tua gal mebe dad Dyu, snilola kenen, ");
INSERT INTO bps_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","manla, “Galan falwà i dademe dad to, bay i kton laan gagan falwà. Kenen kun, i Harì di Israél! Ku gtufa kenen di krus, faglut ito di kenen. ");
INSERT INTO bps_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Smalig kenen di Dwata du manan kenen Tingà Dwata. Na neyeito ku mayè Dwata falwà kenen!” ");
INSERT INTO bps_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na balù i dad tmaku nlansang di safédan smilo kenen. ");
INSERT INTO bps_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na mdà di ltu i duh mbaling kifu di klamang banwe kel di tngà masol i duh. ");
INSERT INTO bps_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na mdadong di tngà masol i duh falbong Dyisas taluan, manan, “Iloy, Iloy, lama sabaktani?” I gumtatek ani dunan, “E Dwatagu, Dwatagu, tan i duenam tmagak deg?” ");
INSERT INTO bps_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na nun dad to tadag déén mlinge i talù Dyisas, na balingla man, “E tatlon Ilaydya.” ");
INSERT INTO bps_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na nun satu to déén faflal lamnab i galla fsaf yéél di masam binu, na fkahan di tukè i kayu, na ulukan di ku Dyisas fye ninuman. ");
INSERT INTO bps_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kabay man i dademe, “Tayò fa, neyeito funa ku salu dini Ilaydya du falwà kenen.” ");
INSERT INTO bps_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na lêman falbong Dyisas i taluan na fles mati. ");
INSERT INTO bps_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na salngan én, i bong kurtina déén di lam i Bong Gumnè Dwata matngà kasê mdà di tah kel di dungan. Na mlinol i tanà, na bgang dad malbang batu. ");
INSERT INTO bps_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mgukà i dad gulambang, na mték mdà di fati dee dad muna to faglut di Dwata. ");
INSERT INTO bps_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lamwà ale fdu di lam dad lbang na kafnge i kték Dyisas salu ale di Dyérusalém, na dee dad to mite dale. ");
INSERT INTO bps_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na i kafitan dad sundalu na dad sundalu magin kenen di kunungan ku Dyisas, lyola i bong linol, na teenla i kdee mkel, taman too ale likò, na manla, “Too glut, kenen i Tingà Dwata.” ");
INSERT INTO bps_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na nun fa dee libun ditù di gumawagan du beg ale meye ku Dyisas. Tagnè ale magin ku Dyisas mdà di Galili du galla kenen tnabeng. ");
INSERT INTO bps_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na gakuf di dad libun ani, Méri Magdalin, na Méri i yê Dyém na Dyosif, na yê i dad ngà Sébidi. ");
INSERT INTO bps_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Di tafan kasdaf i duh kel déén satu lagi i nun bong knun mdà di banwe Arimatiya dnagit ku Dyosif, na kenen satu gal mlalò ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Na salu kenen di ku Gubirnador Filat du fnin i laweh Dyisas du lbang. Na mdek Filat, fye blé lawehan di ku Dyosif. ");
INSERT INTO bps_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Taman nwè Dyosif i lawehan mdà di krus, na nlabédan falami safut bukay, ");
INSERT INTO bps_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na fkahan di kenen gulambang i falamin nsol di lfidas di gugdak i bulul. Kafnge én, flulidan déén satu bong batu du nsangan i bà gufusuk i lbang, na mdà kenen. ");
INSERT INTO bps_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Méri Magdalin na i satu Méri sudeng mdadong déén meye i nimòla di gulambang ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Di tmadol duh, dunan i Duh Kaftud, salu i dad ulu i dad bà di Dwata na dad Farisi di ku Filat. ");
INSERT INTO bps_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na manla, “Gafaldammi nun man i to gal mgaw atù di là fa mati, manan, ‘Nték agu di gatlun duh.’ ");
INSERT INTO bps_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Taman fye ku toom funung i lbangan kel di gatlun duh, du ken tnaku i dad mlalò kenen i lawehan, na kafnge én, tatìla man di dad to, tamték kenen mdà di fati. Na baling matnù fa kafgawla i dad to mdà di kéngla ani di muna kafgawla.” ");
INSERT INTO bps_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Taman man Filat di dale, “Na, faginyu ditù dad to munung, na tooyu fanse kafgagidyu i lbang.” ");
INSERT INTO bps_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na taman salu ale di lbang Dyisas du fangagidla. Fankahla i gafgat di batu sang i lbang gudmilèla ku nun mutik dun. Na tnagakla déén dad to munung. ");
INSERT INTO bps_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kafnge i Duh Kaftud di too flafus Linggu, mdà ale Méri Magdalin na i satu Méri salu di lbang du neyela. ");
INSERT INTO bps_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na nun bong linol du nun kasaligan Dwata fdanà mdà di langit, na flulidan i bong batu sang i lbang, na sudeng kenen di tahan. ");
INSERT INTO bps_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gambet silà i kbawehan na too bukay i klawehan. ");
INSERT INTO bps_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na i dad to munung i lbang tatì ale kankal mdà di klikòla kenen, na gambet ale i dad to mati. ");
INSERT INTO bps_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kabay man i kasaligan di lwe libun, “Nang gamu likò. Gadègu én fanngabalyu Dyisas, i tanlansangla di krus. ");
INSERT INTO bps_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Talaan dini du tamték mdà di fati, gambet i tagmanan di gamu. Salu gamu dini na neyeyu i gufilèla kenen, ");
INSERT INTO bps_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","na gasil gamu salu di dad gal mlalò kenen, na tnulenyu ale tamték kenen mdà di fati, na tamuna kenen di gamu salu di Galili. Ditù gusmiteyu kenen. Én sa i tulengu gamu.” ");
INSERT INTO bps_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Taman gasil mdà i dad libun mdà di lbang na likò ale, bay too ale lehew. Na sadlu ale du fye tnulenla i dad gal mlalò ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na tatì ale snitong Dyisas, na manan, “I ktanak nawa samnagin gamu!” Na fdadong ale di kenen na nagotla i dad blian, na mangamfù ale di kenen. ");
INSERT INTO bps_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na man Dyisas di dale, “Nang gamu likò, ditù gamu di dad flanekgu, na dekyu ale salu di Galili na ditù gusmitela deg.” ");
INSERT INTO bps_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na di sleng i dad libun magu, nun di dad to munung i lbang salu di syudad, na tnulenla dad ulu i dad bà di Dwata i kdee tamkel. ");
INSERT INTO bps_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Taman dad ulu i dad bà di Dwata, snitela dad tua i dad Dyu du stulen ale ku tan i kibòla. Na banléla dad to munung bong filak, ");
INSERT INTO bps_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na manla, “Tnulenyu i dad to, i laweh Dyisas tnaku i dad mlalò kenen di butang di lammi kudang. ");
INSERT INTO bps_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na ku linge i gubirnador ani, gami fafye stulen di kenen du fye laan flabè gamu.” ");
INSERT INTO bps_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Taman nwè i dad munung i filak na nimenla i gman di dale. Na i tulen i dad ulu dad Dyu tatoo mbel di dad Dyu kel di duh ani. ");
INSERT INTO bps_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na salu i dad sfalò satu gal mlalò ku Dyisas ditù di Galili di bulul i tagman gufsalu Dyisas dale. ");
INSERT INTO bps_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na di kitela kenen, mangamfù ale di kenen, bay nun di dale lwe nawala. ");
INSERT INTO bps_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na fdadong Dyisas di dale, na manan, “Tagablé di deg i kdee glal di tah langit na di tah tanà. ");
INSERT INTO bps_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Taman salu gamu di dad to di kdee dad banwe di tah tanà, na flalòyu ale deg. Na bnunyagyu ale di dagit Dwata Mà, na i Tingà, na i Mtiu Tulus. ");
INSERT INTO bps_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na tdòyu ale mimen kdee flalògu gamu. Na nangyu glifet samnagin agu gamu kel di gusen i banwe.”");
INSERT INTO bps_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ani kagatbù i Fye Tulen gablà ku Dyisas Krayst Tingà Dwata. ");
INSERT INTO bps_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nun man Dwata di Tingaan fsulatan tugadan Isaya i gman, “Dekgu saliggu muna di ge, du fatlagad i dalanam. ");
INSERT INTO bps_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tamlo kenen mdà di banwe landè to mnè déén, manan, ‘Fatlagadyu i dalan i Amu, na tanluyu i gumagun.’ ” ");
INSERT INTO bps_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Taman dek Dwata Dyan, i to gal munyag. Na mnè kenen di banwe landè to mnè déén. Na tdoan dad to stifun déén, fye msal ale na tmagak dad sasè nimòla na fbunyag, du fye nlifet Dwata dad salàla. ");
INSERT INTO bps_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na too dee dad to gal salu déén di kenen, mdà di klamang banwe Dyudiya, na mdà di syudad Dyérusalém. Na tulenla kenen i dad salàla, na bnunyag ale Dyan di bong yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na i klaweh lsak Dyan dunan i bul kamél nanem, na i galingan kindal lmanaf. Tlangas na tnab i knaanan. ");
INSERT INTO bps_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na ani galan santulen di dad to, manan, “Nun fan kel satu to tmadol deg. Too kenen mdatah fa di deg, taman là agu gablà balù lkuad na mbel ikat talumfaan. ");
INSERT INTO bps_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","I kbunyaggu gamu ani fagu alò di yéél, bay i kbunyag i to tmadol deg fagu di Mtiu Tulus blén gamu.” ");
INSERT INTO bps_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Là mlo ani, salu Dyisas di ku Dyan fdu di Nasarét déén di banwe Galili. Na fbunyag kenen ku Dyan di yéél Dyordan. ");
INSERT INTO bps_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na di kalwaan di lam yéél, teenan nun gumgukà i langit, na fdanà Tulus Dwata mdaf di kenen gambet abun. ");
INSERT INTO bps_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na nun talù mdà di langit, manan, “Ge tingàgu toogu kando, na too fye nawagu ge.” ");
INSERT INTO bps_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kafnge én, gasil fsalu Tulus Dwata Dyisas di banwe landè to mnè déén. ");
INSERT INTO bps_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Fat falò butangan mnè ditù, na di klon déén tnilew kenen Satanas. Na nun fa déén dad labè lmanaf di bnas, bay dad kasaligan Dwata mifat kenen. ");
INSERT INTO bps_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kafnge én, di kaglam Dyan di bilanggù samfulê Dyisas di banwe Galili du samtulen i Fye Tulen mdà di Dwata. ");
INSERT INTO bps_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na manan, “Ani bang kagdohò i gman di Tnalù Dwata, du tamdadong nan kagot Dwata. Taman msal gamu na tnagakyu dad sasè nimòyu, na faglut gamu di Fye Tulen mdà di Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na di kagun ani, magu Dyisas di kilil i bong lanaw Galili, na teenan lwe lagi saflanek, Simon na Andru. Mukut ale di lanaw du ale dad to gal mwè nalaf. ");
INSERT INTO bps_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na man Dyisas di dale, “Magin gamu deg, du balù ani galyu nimò meye nalaf, tdòta gamu meye dad to du fye mlalò ale deg.” ");
INSERT INTO bps_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na di kmanan ani, tagakla fukutla, na magin ale kenen. ");
INSERT INTO bps_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Di kagula là mlo teen Dyisas lwe saflanek, Dyém na Dyan, dad ngà Sébidi, di lam awengla. Tambél ale dad fukutla. ");
INSERT INTO bps_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na di kite Dyisas dale tlon ale du faginan, na tnagakla màla Sébidi na dad to tnadenla di lam awengla, du magin ale ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na di kagula, salu ale di tukay banwe Kafernaum. Na kakel i Duh Kaftud dad Dyu, fusuk Dyisas di gal gusatdò dad Dyu, na tamdò. ");
INSERT INTO bps_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Di kaklinge dad to i tdò Dyisas too ale tikeng, du too nun glal i katdoan, là salngad di dad to gal tamdò flalò blé Dwata fagu di ku Mosis. ");
INSERT INTO bps_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Di là fa fnge i katdò Dyisas nun satu lagi déén nun busaw. Na mkit kenen, ");
INSERT INTO bps_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","manan, “E Dyisas mdà di Nasarét, tan labetam gami? Fanam gami kè falmo? Gadègu ku simto ge! Ge sa To Landè Salà dek Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kabay nngak Dyisas i busaw, manan, “Fanak ge! Lamwà ge di to én.” ");
INSERT INTO bps_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na too fakakal i busaw lagi ani na mkit na lamwà. ");
INSERT INTO bps_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Too tikeng i kdee dad to déén, taman sasalek ale, manla, “Tan kè ani? Satu falami tdò ani dé? Hae, du nun glalan mdek dad busaw lamwà, na mimen ale!” ");
INSERT INTO bps_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na too mlal mbel santulen gablà ku Dyisas di klamang banwe Galili. ");
INSERT INTO bps_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na di kdà Dyisas di gusatdò dad Dyu, salu kenen di gumnè Simon na Andru. Na magin Dyém na Dyan. ");
INSERT INTO bps_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kakella déén tatì milè tewe Simon libun, du too minit lawehan. Na gasilla santulen ku Dyisas kagkahan. ");
INSERT INTO bps_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Di kaklinge Dyisas dun, fdadong kenen, na nagotan sigalan du ntékan. Di kték Dyisas kenen, magwè initan, na fles kenen mlé dale knaan. ");
INSERT INTO bps_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na mdà di kasdaf i duh di flabi én, nebe dad to di ku Dyisas kdee dademela nun tduk na dad to nun busaw, ");
INSERT INTO bps_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","na dee dad to mdà di lunsud stifun mdadong di gufusuk i gumnean. ");
INSERT INTO bps_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na dee dad to fanguléan mdà di dee bung tduk na falwaan dee busaw di dad to salu déén. Kabay là faloh Dyisas i dad busaw ku talù, du dilèla ku simto kenen. ");
INSERT INTO bps_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na di too flafus di tmadol duh kifu fa, mték Dyisas na mdà salu di satu banwe gulandè to aloan satu du dmasal. ");
INSERT INTO bps_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kabay lê mdà ale Simon du mngabal kenen. ");
INSERT INTO bps_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na di kitela kenen, manla, “Too dee dad to mngabal ge.” ");
INSERT INTO bps_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kabay man Dyisas, “Fles ito di dademe banwe mdadong dini du fye lêgu tdò i Fye Tulen di dad to ditù, du én sa duengu salu dini di tah tanà.” ");
INSERT INTO bps_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Taman lamngab ale Dyisas di dee banwe di klamang Galili, du tamdò di dad gal gusatdò dad Dyu, na falwaan dad busaw mdà di dad to. ");
INSERT INTO bps_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na satu duh nun to tanfig salu di ku Dyisas. Lkuad kenen di munan, na fakdo manan, “Ku beg ge mayè, gaganam fgulê deg di tduk fagsik deg ani.” ");
INSERT INTO bps_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Too bong kakdo Dyisas kenen, taman nagotan, na manan, “Mayè agu sa. Mgulê ge nan.” ");
INSERT INTO bps_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na too glut, tamgulê sa to tanfig, talandè tfigan. ");
INSERT INTO bps_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na gasil fdà Dyisas na toon dek, manan, ");
INSERT INTO bps_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nangam tulen ani di balù simto to, bay én nimoam, mdà ge na fitem laweham di bà di Dwata, na nebem di kenen dsuam di Dwata i fgadè ku Mosis, du én gugmadè dad to too glut tamgulê ge.” ");
INSERT INTO bps_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kabay di kdà i to tafangulê Dyisas, balingan tulen di kdee dad to i mgimò Dyisas di kenen, na nbelan santulen ani di klamang banwe. Taman talà gfite Dyisas di dademe dad banwe di lam Galili du alì dee dad to gal stifun di safédan. Baling kenen lamngab di dad banwe gulandè dee to. Kabay knean salu déén di kenen dad to mdà di kdee banwe déén. ");
INSERT INTO bps_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Di kafnge file duh, samfulê Dyisas di banwe Kafernaum, na linge i dad to tamulê kenen. ");
INSERT INTO bps_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na du dee dad to stifun, fnò i gumnean kel di naselan, taman landè kibò dademe to fdadong di kenen. Na én nimò Dyisas tamdò i dad to Tnalù Dwata. ");
INSERT INTO bps_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Klon tamdò, nun fat lagi kel samtiang i to là galyak lawehan. ");
INSERT INTO bps_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na landè dalanla fles salu di ku Dyisas du too dee dad to, taman nebela to là galyak lawehan di tah ataf na lanketla dademe ataf gsen di tah i gutamdò Dyisas, du fayolla kenen di muna Dyisas gagin gumilean. ");
INSERT INTO bps_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Di kite Dyisas i bong kafaglutla di kenen, manan di to là galyak, “E Tò, tamaglifet dad salaam.” ");
INSERT INTO bps_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na nun dad to gal tamdò i flalò Dwata sudeng déén. Na di kaklingela i man Dyisas snalekla di ktola, ");
INSERT INTO bps_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kan ku manan nlifetan salà i to gine? Falmon dengeg Dwata du manan én, du Dwata alò gmagan mlifet dad salà.” ");
INSERT INTO bps_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kabay gadè Dyisas i kdee mnè di nawala, na manan di dale, “Kan ku én fandamyu làgu gagan mimò dun? ");
INSERT INTO bps_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nè too malima man di to là galyak ani, ‘Maglifet salaam,’ ku demen, ‘Tadag ge, nweam i gumileam, na magu ge?’ Salngad sa, du slame alò Dwata gmagan mimò dun. ");
INSERT INTO bps_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Taman fangulêgu kenen, du fye gadèyu agu, i to dnagit Tingà To, nun glal di tah tanà ani mlifet dad salà i dad to.” Na manan di to là galyak lawehan, ");
INSERT INTO bps_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mangu di ge, tadag ge, nweam gumileam, na mulê ge.” ");
INSERT INTO bps_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na glut, gtadag i to là galyak gine. Na gasilan nwè gumilean, na mdà kenen. Mite kdee dad to déén, na too ale tikeng na dnayenla Dwata, manla, “Landè lmenito teen gambet ani.” ");
INSERT INTO bps_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na lêman mdà Dyisas salu di kilil i bong lanaw Galili. Na too dee dad to stifun déén di safédan, na tdoan ale. ");
INSERT INTO bps_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na di slengan magu, teenan satu to dnagit ku Libay, tingà Alfyus, sudeng di lam gumimò dad to gal mwè bayad buhis. Na man Dyisas di kenen, “Mlalò ge deg.” Na tadag Libay na fles mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na kmaan ale Dyisas di gumnè Libay. Di slengla kmaan nun dee dad to mwè bayad buhis na dademela gal mlafà dad flalò fnaglut dad Dyu sudeng di saféd Dyisas na dad mlalò kenen du dee ale gal samlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na di klo Dyisas kmaan di saféd i dad to di gumnè Libay, nun dad tamdò dad flalò Dwata mdà di dad Farisi mite kenen. Na snalekla dad gal mlalò ku Dyisas, manla, “Kan ku kmaan Dyisas di saféd i dad to gal mwè bayad buhis na dademe to gamsalà.” ");
INSERT INTO bps_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na di kaklinge Dyisas manla di dad gal mlalò kenen, tnimelan ale fagu di fléd, manan, “I dad to nun tduk, nun gukmamula to mulung, bay i dad to landè tduk, landè gukmamula i to mulung. Taman ise ku én duengu salu dini du fanngabalgu dad to tlu du fsalgu di dad salàla, bay dad to gamsalà fanngabalgu.” ");
INSERT INTO bps_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Di satu duh, fwasa i dad to gal mlalò ku Dyan Gal Munyag na dad Farisi. Na nun dad to salu di ku Dyisas, na smalek ale, manla, “I dad to gal mlalò ku Dyan na dad mlalò dad Farisi gal fwasa. Kan ku là fwasa dad mlalò ge?” ");
INSERT INTO bps_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na tmimel Dyisas dale fagu di fléd, manan, “Ku fkahta di kasdeme, fwasa kè dad malò i kasdeme ku déén fa i lagi sandeme di safédla? Ku déén kenen fa, là ale fwasa! ");
INSERT INTO bps_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kabay nun duh kadang, nwè di dale i lagi sandeme, na én bangla fwasa.” ");
INSERT INTO bps_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Na man Dyisas, “Tagadeito sasè ku klafang i falami safut di labi klaweh tabaltok, du falami klafang kamsang na magwè i falami mdà di labi na matnù baling kbong kasê i klaweh. ");
INSERT INTO bps_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na salngad én, là fakay sanbool i labi na falami ku fkahta di binu, du ku fkahito falami binu kmadok fa di lam i labi gufkah kindal, btù sa, na mkok i binu na malmo i gufkah kindal. Én fye gufkah falami binu di falami kindal.” ");
INSERT INTO bps_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na di satu Duh Kaftud dad Dyu, magu ale Dyisas di dalan di satu nligo. Na di slengla magu kambang dad mlalò ku Dyisas là dee kigan trigu fule déén, du knilewla. ");
INSERT INTO bps_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na di kite i dad Farisi dun, manla di ku Dyisas, “Neyem dad gal mlalò ge. Kan ku kamtu ale di Duh Kaftud? Là fakay sa, du fnang Dwata di flalò blén fagu di ku Mosis.” ");
INSERT INTO bps_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kabay tmimel Dyisas dale, manan, “Kan kè. Làyu lmen masa gablà di nimò Harì Dabid du mdà di kliduan na kbitilan na kbitil i dademen? ");
INSERT INTO bps_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Là kenen fansalà Dwata balù fusuk kenen di lam Gumnè Dwata na nwean i fan blé di Dwata, na blén di dad ton, na kdeela kmaan. Na blaam én alò fakay kmaan dun dad baito di Dwata. Mgimò ani di bang Abiatar gumdatah dad bà di Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na man Dyisas, “Én duen Dwata mimò i Duh Kaftud du tnabengan i dad to, du én funan nimò i dad to, na kafnge én, blén flalò gablà di Duh Kaftud. ");
INSERT INTO bps_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na agu, i dnagit Tingà To, i nun glal mangman fakay nimò di Duh Kaftud.” ");
INSERT INTO bps_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na di satu duh lêman fusuk Dyisas di gal gusatdò dad Dyu. Na nun lagi déén kengkeng bali kmalan. ");
INSERT INTO bps_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na nun dad to déén dmuen ku Dyisas, na toola neye ku fanguléan i to kengkeng di Duh Kaftud, du fye nun gutadagla dmalam kenen di salà ditù di dad ganlal. ");
INSERT INTO bps_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na man Dyisas di to kengkeng kmalan, “Tadag ge dini di muna.” ");
INSERT INTO bps_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kafnge én snalekan dad to dmuen kenen, “Tan man dad flalò Dwata i fakay nimò di Duh Kaftud, mimò fye di demeyu to, ku mlayam? Tan fye, tmabeng demeyu to ku mati to?” Kabay landè timella. ");
INSERT INTO bps_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na keye Dyisas di dale too kenen flabè na mlidù fa du too mgal ulula. Na kafnge én, man Dyisas di to kengkeng kmalan, “Bankem kmalam.” Na banken sa, na di kabken dun, tamgulê. ");
INSERT INTO bps_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na gasil lamwà dad Farisi du stifun magin dad to gsen di ku Harì Hérod, du fye stulen ku tan kfagula mati ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kafnge én tnagak Dyisas na dad gal mlalò kenen i banwe én, na salu ditù di kilil i bong lanaw. Na too dee dad to mlalò kenen stifun déén mdà di klamang dad banwe Galili na Dyudiya, ");
INSERT INTO bps_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kel di syudad Dyérusalém, na mdà di klamang banwe Idumya. Na nun dee dademe mdà di dad banwe di faltù i bong yéél Dyordan, na mdà di banwe mdadong di dad syudad Tiro na Sidon. Salu ale di ku Dyisas du talingela gablà di kdee nimoan. ");
INSERT INTO bps_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na too dee dad to samlibut ku Dyisas, taman dekan dad gal mlalò kenen fatlagad i aweng gumyakan du fye là kenen msikut i dad to. ");
INSERT INTO bps_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tadee dad to fanguléan mdà di tdukla, taman saglad dademe nun tduk fdadong, fye begla gagot kenen du fye mgulê ale. ");
INSERT INTO bps_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na di kite dad busaw ku Dyisas, lkuad ale lamfan di munan, na mkit, manla, “Ge sa Tingà Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kabay too ale fnang Dyisas tmulen ku simto kenen. ");
INSERT INTO bps_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kafnge én, salu Dyisas ditù di satu bulul, na fatlon déén dad to kayean fasnagin kenen. Na salu ale di kenen. ");
INSERT INTO bps_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na nalékan sfalò lwe dad to fye samnagin kenen na dekan ale tamdò di dad to i Fye Tulen mdà di Dwata, ");
INSERT INTO bps_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na banlén ale glal falwà dad busaw mnè di dad to. ");
INSERT INTO bps_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na ani dad dagit i sfalò lwe lagi nalék Dyisas, Simon i dnagitan ku Fiter, ");
INSERT INTO bps_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Dyém na flanekan Dyan, dad ngà Sébidi. Na lwe ani dnagit Dyisas Boanigis, na i gumtatekan dunan labè gambet kilet, ");
INSERT INTO bps_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Andru, Filif, Bartolomyu, Matyu, Tomas, Dyém tingà Alfyus, Tadyus, Simon msen di banwen, ");
INSERT INTO bps_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Dyudas Iskariyot to mangkal kenen. ");
INSERT INTO bps_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kafnge én, mulê Dyisas, na lêman too dee dad to stifun déén di kenen, taman talà gasleng Dyisas na i dad gal mlalò kenen kmaan. ");
INSERT INTO bps_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Di kaklinge i gaked Dyisas ani, salu ale ditù du nngéla kenen du man dademe to tabook. ");
INSERT INTO bps_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na nun dad tamdò flalò blé Dwata fagu di ku Mosis mdà di syudad Dyérusalém mite kafalwà Dyisas dad busaw. Na manla, “Bélsébul, gumdatah dad busaw mnè di kenen, na én sa mlé kenen tulus falwà dad busaw di dad to.” ");
INSERT INTO bps_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na taman tlo ale Dyisas di kenen du talù di dale fagu di fléd, manan, “Tan kibò Satanas falwà i kton? Landè sa, ");
INSERT INTO bps_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","du ku fkahta di kagot satu harì ku sunay ale dad ton, malmo baling kagotan dale. ");
INSERT INTO bps_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na salngad ku fkahta di satu malay ku sfati slame ale, malmo baling i ksasatula. ");
INSERT INTO bps_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na ku glut i manyu sanfati Satanas dad busaw samnagin kenen, na snang ale nawa, na là mlo, malmo baling kagotan dale. ");
INSERT INTO bps_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Én kaglutan tafnisangu Satanas, na én duengu gmagan falwà dad busaw galan dek, du landè to fakay fusuk di gumnè i mgal to du mwè knunan ku laan funa kenen bnakus, bay ku tabnakus fakayan nwè balù tan kayean di gumnè i mgal to. ");
INSERT INTO bps_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tulengu gamu kaglutan, nlifet Dwata i kdee dad salà i dad to balù dad sasè manla gablà di kenen. ");
INSERT INTO bps_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kabay i to falmo dengeg Mtiu Tulus di ktaluan là nlifet Dwata, na là maglifet salaan kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Man Dyisas ani, du dad to gine falmola dengeg Tulus Dwata, du manla kun, “Nun sasè tulus mnè di ku Dyisas.” ");
INSERT INTO bps_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na takel yê Dyisas na dad flanekan lagi di gutamdoan. Tadag ale di lwà, na fafngéla kenen. ");
INSERT INTO bps_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na dee dad to sudeng di glibutan na nun tmulen kenen, manla, “Taditù yéam na dad flanekam di lwà, na snalekla ge.” ");
INSERT INTO bps_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na tnimelan ale, manan, “Hae, bay simto kè yêgu na dad flanekgu?” ");
INSERT INTO bps_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na meye Dyisas di dad to di glibutan, na manan, “Ani sa yêgu na dad flanekgu, ");
INSERT INTO bps_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","du ku simto mimò knayè Dwata, kenen mgimò flanekgu lagi, flanekgu libun, na yêgu.” ");
INSERT INTO bps_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Satu duh lêman tamdò Dyisas ditù di kilil bong lanaw. Na too dee dad to stifun déén di safédan, taman myak kenen di tah satu aweng faltew di kilil lanaw na sudeng kenen déén du tamdò. Na tadag dad to flinge déén di kilil lanaw. ");
INSERT INTO bps_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na too dee tdoan dale fagu di fléd, na manan di dale, ");
INSERT INTO bps_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Too gamu flinge. Nun to salu di nligon du smabul bnê. ");
INSERT INTO bps_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na di ksabulan dun nun dademe gsabul di bà dalan, na fti tnukè dad anuk di bnas. ");
INSERT INTO bps_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na nun dademe gsabul di gumngifi tanà di tah batu. Na too mlal ktabòla du babu i tanà. ");
INSERT INTO bps_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kabay di ksut i duh, sakuf tabòla na du là alì dmalil mlanas ale. ");
INSERT INTO bps_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na nun dademe bnê gsabul di gutmabò walad nun sual. Na tmabò, bay mlal kalnok dad walad, na mlimas dad tabò i bnê, taman là ale munge. ");
INSERT INTO bps_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kabay dademe bnê sabul di gufye tanà, na midul ktaboan na midul kafye lnokan, taman too munge. Nun dademe tlu falò uléan, dademe nam falò, na dademe mlatu.” ");
INSERT INTO bps_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Taman flinge gamu, ku nun klingeyu!” ");
INSERT INTO bps_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na di kdà i dee dad to gine fdadong di ku Dyisas dad sfalò lwe gal mlalò kenen na dademen déén, na snalekla kenen gablà di dad fléd. ");
INSERT INTO bps_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na tnimelan ale, manan, “Faglabatgu gamu dad mlalò deg dad gbuni gablà di kagot Dwata. Kabay di dademe dad to fléd alò kibògu tamdò dale. ");
INSERT INTO bps_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Du fye, ‘balù meye ale là ale mite, na balù flinge ale knean là ale gamlabat, du ku glabatla ken tagakla dad sasè nimòla, na nlifet Dwata dad salàla.’ ” ");
INSERT INTO bps_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na man Dyisas di dale, “Ku làyu glabat gumtatek i fléd gine, tan kibòyu gamlabat i dademe dad fléd.” ");
INSERT INTO bps_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na nubadan di dale i fléd snalekla, manan, “Én to smabul bnê, dunan i to fbel Tnalù Dwata. ");
INSERT INTO bps_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na i dalan gugsabul i dad bnê, dunan i dad to tamlinge Tnalù Dwata, bay gasil Satanas salu di dale du nwean di nawala i talingela. ");
INSERT INTO bps_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Na salngad i bnê gsabul di mngifi tanà di tah batu i gugsabul i dademe bnê, dunan dad to too lehew dmawat Tnalù Dwata di kaklingela dun, ");
INSERT INTO bps_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bay landè gudmalilan di nawala, taman là mlo ktayudla, du di kakel i kalima na kaflayam mdà di kdawatla Tnalù Dwata, mlal ale tmagak kafaglutla. ");
INSERT INTO bps_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Na i tanà gugsabul bnê i gutmabò walad nun sual, dunan dad to mlinge Tnalù Dwata, ");
INSERT INTO bps_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bay dee gusbalét i nawala gablà di knèla di tah tanà, na kiballa knun, na dademe knayè ktola. Taman landè ulê Tnaluan di dale. ");
INSERT INTO bps_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Kabay i fye tanà gusmabul i dademe bnê, dunan dad to mlinge Tnalù Dwata na dmawat dun, na too nun kbungen di nawala. Nun tlu falò uléan, dademe nam falò, na dademe mlatu.” ");
INSERT INTO bps_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na manan di dale, “Ku nun to fusuk mebe salò, laan snukub been ku demen buni di dungan katri. Én gufkahan dun di gumefen. ");
INSERT INTO bps_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Salngad én, i kdee gbuni di mduh ani, teen sa kadang, na i là gadè ani, gadè sa kadang. ");
INSERT INTO bps_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Taman flinge gamu, ku nun klingeyu!” ");
INSERT INTO bps_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na man fa Dyisas, “Hae, tooyu fanse flinge i tdògu du salngad kdawatyu dun én kalbong kaglabat blé Dwata gamu. Ku fkahta di kasad, i kibòyu masad, salngad én kasad Dwata di kablén gamu, bay tananuan fa. ");
INSERT INTO bps_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Na dad to nun kaglabat i tdògu, tananù Dwata. Na dad to là fkah dun di nawala, nawì Dwata balù tukay man nawala glabatla.” ");
INSERT INTO bps_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na tulen Dyisas satu fléd, manan, “I kalnok kagot Dwata salngad satu to smabul bnê di nligon. ");
INSERT INTO bps_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Laan gadè ku tan kibò bnê én tmabò, du kafngen smabul dun di nligon, tatian tagak. Na di laman fadlug mimò i nimoan klit duh na kudang klit butang tmabò i bnê na lamnok. ");
INSERT INTO bps_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Du i tanà gumdàla tmabò na munge. I muna tmabò muhad foonan, na tmadol dad malnak fusuan, na kafnge én, dad bungen. ");
INSERT INTO bps_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na di ktagan, kamtu kenen, du tabang sa nan.” ");
INSERT INTO bps_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na lêman tamdò Dyisas satu fléd, manan, “I tan gufasngadgu i kagot Dwata? Tan fye guflingengu dun? ");
INSERT INTO bps_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Flingengu di satu too tukay bnê fule satu to di tanaan. ");
INSERT INTO bps_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na i bnê én tukay fa di kdee dademe bnê di tah tanà, bay ku fulem, tmabò na baling too bong di kdee dademe fule, na i malbang fangan gusmalal dad anuk di bnas fsilung déén.” ");
INSERT INTO bps_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na fagu di dee dad fléd faglabat Dyisas di dad to Tnalù Dwata, ku tan gaganla glabat, én tdoan dale. ");
INSERT INTO bps_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kdee fgadè Dyisas di dad to slame fagu di fléd, bay ku alò ale déén nubadan kdee di dad gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na di duh én di kakimalan tanlak Dyisas dad gal mlalò kenen, manan, “Mdà ito mifal lanaw.” ");
INSERT INTO bps_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Taman tnagakla kdee dad to déén, na faginla Dyisas smakay di aweng tagnè gusudengan tamdò. Na nun fa dademe aweng salngan dale. ");
INSERT INTO bps_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Klola déén di talà nkel ale bong mgal nus. Mgal lwek samfaw di awengla, na maglam yéél. ");
INSERT INTO bps_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kabay Dyisas déén kenen di ulin tamdanan du kudang. Na nukatla kenen, na manla, “E To Tamdò, tafan ito galnab! Mayè ge kè ku mlimas ito?” ");
INSERT INTO bps_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na mukat kenen na nngakan i nus na lwek, manan, “Fanak nan.” Na di kmanan én, manak i nus na too lanél i lanaw. ");
INSERT INTO bps_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na man Dyisas di dademen, “Tan duenyu likò? Landè fa kè ksaligyu di deg?” ");
INSERT INTO bps_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na too bong ktikengla, na stulen ale, manla, “Simto to ani? Balù nus na lwek mimen ale kenen.” ");
INSERT INTO bps_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na fles ale mifal lanaw kel di kagduungla di banwe dad to Gérasin. ");
INSERT INTO bps_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na di ktufala mdà di aweng, nun satu lagi bnusaw lamwà mdà di dad ilib gal gulambang dad to na smitong ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","I gumnè to ani di dad ilib galla gulambang dad to. Na to ani too nun galan, landè to gmagan makus kenen, balù ku sangkalì bakusla kenen. ");
INSERT INTO bps_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Too dee dulê bnakusla blian na sigalan, bay gaganan bangang dad tek afas i blian na smafto dad sangkalì. Na landè to gmagan mafas kenen du mdà di galan. ");
INSERT INTO bps_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mduh na butang tatian lamngab di dad gulambang na di dad bulul na mkit na sneey batu lawehan. ");
INSERT INTO bps_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na di kiten ku Dyisas mdà di gumawagan tatian mila smitong kenen na lkuad di munan, ");
INSERT INTO bps_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na mkit, manan, “E Dyisas, Tingà i Too Mdatah Dwata, tan kiboam deg? Fnigu ku makang ge di Dwata, laam agu fanlayam.” ");
INSERT INTO bps_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Manan ani, du tagman Dyisas di kenen, “E ge busaw, lamwà ge di to ani!” ");
INSERT INTO bps_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na snalek Dyisas kenen, manan, “Simto dagitam?” Tmimel busaw, manan, “Dee Libu dagitgu, du too gami dee.” ");
INSERT INTO bps_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na too fakdo dad busaw fye laan ale dek di dademe dad banwe. ");
INSERT INTO bps_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na nun dee dad sdè nifat mdadong déén samwel di bilil. ");
INSERT INTO bps_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na fakdo dad busaw di ku Dyisas, manla, “Dekam gami di dad sdè ditù na faloham gami fusuk di dale.” ");
INSERT INTO bps_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na falohan ale. Taman lamwà dad busaw di to én, na fles fusuk di dad sdè. Na kdee dad sdè mdadong lwe libu. Na kdeela mila masol di bilil na gtufa di lanaw, na sdulê mlimas. ");
INSERT INTO bps_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Di kite dad to mifat dad sdè i mkel ani, mila ale na tnulenla dad to di lunsud na di klamang banwe. Na i dad to mlinge, salu ale ditù du neyela i tamkel. ");
INSERT INTO bps_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kakella di ku Dyisas teenla i to gulamwà dee libu dad busaw sudeng di saféd Dyisas. Takamlaweh kenen, na tafye fandaman. Na too ale likò. ");
INSERT INTO bps_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na dad to mite nimò Dyisas, tulenla i mkel di to nun dee busaw gine na di dad sdè. ");
INSERT INTO bps_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Taman toola man di ku Dyisas fye ku tnagakan banwela. ");
INSERT INTO bps_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na di kyak Dyisas lêman di aweng, too fakdo di kenen i to nun busaw tafanguléan, du kayean magin, ");
INSERT INTO bps_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","bay fnang Dyisas, na manan, “Mulê ge, na tnulenam dademem ku tan kalbong mgimò Dwata di ge na bong kakdon ge.” ");
INSERT INTO bps_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na too glut, mdà to én mulê na tambù tmulen di dad to déén di dad banwe Dikafolis i kalbong nimò Dyisas di kenen. Na too tikeng dad to di kaklingela i manan. ");
INSERT INTO bps_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na lêman mifal ale Dyisas smakay di aweng. Na kagduungla di faltù, too dee to stifun glibut di kenen di kilil lanaw. ");
INSERT INTO bps_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na salu déén Dyairus, satu ganlal di gal gusatdò dad Dyu. Di kiten ku Dyisas lkuad kenen di saféd blian, ");
INSERT INTO bps_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","du fakdo kenen, manan, “Tafan mati tukay tingàgu libun, bay beg ge magin deg ditù, na nagotam kenen du fye mgulê na mto fa.” ");
INSERT INTO bps_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Taman magin Dyisas kenen. Na too dee dad to magin ku Dyisas, tatì sgat dad to magu. ");
INSERT INTO bps_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na di kagula nun satu libun déén too maflayam mdà di tdukan, tatì maloh tienan. Tasfalò lwe fali klon lamyalo dun. ");
INSERT INTO bps_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na bong kaflayaman mdà di dee to gufbulungan. Tamti dad kandeenan di kafbulungan, bay landè gumguléan, na baling matnù i tdukan. ");
INSERT INTO bps_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Talingen gablà di kafgulê Dyisas dad to nun tduk, taman tamguna kenen kdee dad to di kagol Dyisas, na nagotan klawehan, ");
INSERT INTO bps_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","du manan di kton, “Ku gagotgu alò i klaweh Dyisas mgulê agu.” ");
INSERT INTO bps_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na di kagotan dun, tlag kaloh tienan, na lyalon tamgulê i tdukan. ");
INSERT INTO bps_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na lyalo Dyisas nun eneg gafgulê lamwà di kenen, taman falê kenen di kdee dad to di glibutan, na manan, “Simto magot deg?” ");
INSERT INTO bps_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na man dad gal mlalò kenen, “Teenam dee dad to gihok di ge, na kan ku snalekam ku simto magot ge?” ");
INSERT INTO bps_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kabay lêmanan meye di glibutan du neyen ku simto magot kenen. ");
INSERT INTO bps_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kabay i libun, gadean ku tan mgimò di kenen di kagotan klaweh Dyisas, taman fdadong di ku Dyisas na lkuad di saféd blian. Kankal kenen di klikoan na tulenan kdee mgimò di kenen. ");
INSERT INTO bps_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na man Dyisas di kenen, “Tingàgu, mdà di kafaglutam tamgulê ge. Mulê ge na i ktanak nawa mnè di ge, du talandè nan tdukam.” ");
INSERT INTO bps_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na sleng Dyisas talù fa, nun to kel fdu di gumnè Dyairus, dunan ganlal i gusatdò dad Dyu. Na manla di kenen, “Nangam nan fafles To Tamdò ani di gumneam du talaam gnumah tingaam. Tamati nan.” ");
INSERT INTO bps_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kabay fbayà Dyisas i manla, na manan di ganlal di gusatdò dad Dyu, manan, “Nang ge likò. Alò ge fadlug faglut.” ");
INSERT INTO bps_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na landè to falohan magin dale, senan alò Fiter, Dyém, na Dyan flanek Dyém. ");
INSERT INTO bps_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na kakella di gumnè i ganlal, linge Dyisas ugak dee dad to déén na teenan dad to mlanu na kamwak. ");
INSERT INTO bps_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na di kfusuk Dyisas di gumnè, manan di dad to, “Kan ku mugak gamu na kamwak? Là mati tingà, bay alò kudang.” ");
INSERT INTO bps_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kaklingela i man Dyisas, toola kenen nulé, taman falwaan kdee dad to déén. Na faginan alò dad tua i tingà na tlu dademen fusuk di lam sibay gumilè i tingà, ");
INSERT INTO bps_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","na nagotan kmalan, manan, “Talita kumi,” i gumtatekan dunan, “Tuy, mangu di ge, mték ge.” ");
INSERT INTO bps_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na di kmanan én, mték i tingà na fles magu. Sfalò lwe falin. Na kitela én tatìla là gadè nawala mdà di ktikengla. ");
INSERT INTO bps_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na fnang ale Dyisas fgadè di dad to, na dekan dad tuan mlé knaan di tingà. ");
INSERT INTO bps_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na kafnge én, tnagak Dyisas banwe én, du mulê di kenen banwe, na magin dad gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na di kakel Duh Kaftud tamdò Dyisas di gal gusatdò dad Dyu. Na dee di dad to déén tikeng flinge katdoan, na snilola kenen, manla, “Nè gugamwean i gnadean ani? Na nè gumdà kfulungan? Tan kiboan mimò dad tnikeng? ");
INSERT INTO bps_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ise ani i karfintiro tingà Méri? I twege Dyém, Dyosis, Dyudas na Simon? Na i dad flanekan libun mnè dini kè di banweito.” Na én knangla kenen déén. ");
INSERT INTO bps_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na man Dyisas di dale, “I tugad Dwata too mgafè balù tanè gugsalun, bay alò là nafè kenen di kenen too banwe, na di gutngà i dad flanekan na di kenen too gumnè.” ");
INSERT INTO bps_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Taman du landè kafaglutla di kenen landè alì tnikeng gimò Dyisas di banwe én, aloan nagot là file dad to nun tduk du fanguléan ale. ");
INSERT INTO bps_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na tikeng Dyisas du dad to déén di kenen banwe là faglut di kenen. Taman mdà Dyisas magu di dademe dad malnak banwe di glibutla du tamdò. ");
INSERT INTO bps_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na santifun Dyisas i dad sfalò lwe to gal mlalò kenen du dekan ale lamngab tamdò man lwe to dale. Na banlén ale glal falwà dad busaw. ");
INSERT INTO bps_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na én flaun dale, “Nebeyu alò tugad di kaguyu, na nang mebe bnatu, kuyut, na balù filak. ");
INSERT INTO bps_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nlafinyu blìyu, bay nang mebe i dademe klaweh galwà di tagnè lsakyu.” ");
INSERT INTO bps_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na manan fa di dale, “Na ku takel gamu di banwe gutamdòyu, nè gumnè gufyakla gamu, déén gumnèyu kel di kdàyu di banwela. ");
INSERT INTO bps_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na ku nun banwe gutamdòyu na dad to déén là dmawat gamu na là flinge i tdòyu, mdà gamu di banwela, na kakesyu kfung di blìyu, du én ilè ale tmimel di Dwata i nimòla.” ");
INSERT INTO bps_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Taman kafnge én, mdà ale, na én tdòla, dunan fye msal i dad to na tmagak dad sasè nimòla. ");
INSERT INTO bps_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na falwàla dee busaw di dad to, na nihokla fngalo i dad to nun tduk du fangulêla ale. ");
INSERT INTO bps_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na linge Harì Hérod gablà di kdee nimò Dyisas, du tatoo mdengeg i dagit Dyisas. Man i dademe to kun, “Dyisas, dunan Dyan Gal Munyag tamték mdà di fati, na én duen too kenen mtulus.” ");
INSERT INTO bps_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kabay man dademe gablà ku Dyisas, “Kenen Ilaydya, tugad Dwata tasamfulê.” Na man dademe, “Dyisas ani, satu tugad Dwata salngad tugad Dwata di muna fa.” ");
INSERT INTO bps_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na di kaklinge Harì Hérod i man dad to, man nawan mték Dyan, na manan, “Dunan Dyan Gal Munyag. Tafaklanggu ulun, bay tamték mdà di fati.” ");
INSERT INTO bps_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ani manan, du tafakfean Dyan, na fbakusan, na fbilangguan, du mdà di ku Hérodiyas, yaan flanekan Filif, du balù yaan flanekan nwean. ");
INSERT INTO bps_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Na tagal man Dyan di kenen, “Là fakay nlad yaan flanekam.” ");
INSERT INTO bps_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","I manan ani duen Hérodiyas too mnang nawa kenen, na mayè mati kenen, bay landè fa dalanan, ");
INSERT INTO bps_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","du too nun klikò Harì Hérod ku Dyan, du toon dilè i katlu Dyan, na gadean landè sasè mgimoan. Taman là faloh Hérod ku fnati kenen. Na too mayè Hérod flinge i tdò Dyan, bay msamuk nawan di gal kaklingen dun. ");
INSERT INTO bps_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kabay teen Hérodiyas i kiboan fafati ku Dyan di duh kafaldam i ksut Harì Hérod, du mimò harì i bong fista. Na nlakan dademen dad ganlal di gubirnu, na dad ulu i dad sundalu na dademe mdatah dad to di banwe Galili. ");
INSERT INTO bps_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na nun tingà Hérodiyas libun fsayew Hérod di fistan. Na di kite kdee dad nlak di fista i tingà sayew, too ale mayè, na labi nan Hérod. Taman man Harì Hérod di tingà sayew, “Balù tan fnim di deg blégu ge.” ");
INSERT INTO bps_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na makang Hérod di kenen, manan, “Balù tan fnim kel di kagatngà i nagotgu, blégu ge.” ");
INSERT INTO bps_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na lamwà i tingà libun, na snalekan yéan ku tan fye fnin di ku Hérod. Na man yéan, “Fnim ulu Dyan Gal Munyag.” ");
INSERT INTO bps_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na gasil samfulê tingà libun di ku Hérod, na manan, “Én kayègu ku kaham ulu Dyan Gal Munyag di fligo na blém di deg.” ");
INSERT INTO bps_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Too mlidù nawa Harì Hérod di fni tingà én, bay landè kibò du makang kenen di muna kdee dad to nlak di fista na myà kenen ku laan dnohò dun. ");
INSERT INTO bps_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Taman dek Hérod satu sundalun mwè ulu Dyan. Na salu sundalu di bilanggù na kanlangan ulu Dyan, ");
INSERT INTO bps_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na fkahan ulun di satu fligo, na neben di libun, na flesan nebe di yéan. ");
INSERT INTO bps_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na kaklinge dad to gal mlalò ku Dyan ani kibòla kenen, beg ale salu di bilanggù, na nwèla lawehan du lbangla di ilib galla gulambang dad to mati. ");
INSERT INTO bps_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na samfulê di ku Dyisas dad sfalò lwe dekan tamdò, na santulenla di kenen kdee nimòla di kagula na kdee tdòla. ");
INSERT INTO bps_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kafnge én, man Dyisas di dale, “Salu ito di gulandè to du fye beg gamu gaftud.” Ani manan, du too dee dad to gal salu di dale balù kmaan talà ale gasleng. ");
INSERT INTO bps_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na mdà ale maweng du salu di satu banwe gulandè to du ftud. ");
INSERT INTO bps_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kabay dee dad to mite kdàla, na dilèla ale. Taman gasil ale tmanà mdà di kdee dad lunsud, na dad to én guna kel di gusalu ale Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na di ktufa Dyisas mdà di aweng, teenan dee dad to déén. Na toon ale kando du salngad ale i bilibili landè to mifat dun. Taman dee tdoan dale. ");
INSERT INTO bps_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na di kaflabin salu dad gal mlalò ku Dyisas di safédan, na manla, “Taflabi nan, na landè gumnè mdadong dini. ");
INSERT INTO bps_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Fye ku fdaam dad to du fye mngabal ale gumayadla knaan di dad gumnè na dad malnak banwe mdadong dini.” ");
INSERT INTO bps_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kabay tnimelan ale, manan, “Gamu sa mlé dale knaan.” Na manla di kenen, “Kayeam ku gami mayad knaan kdee dad to ani? Mti taden di walu bulen i bayad dun.” ");
INSERT INTO bps_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na man Dyisas, “File batù i fan nebeyu? Neyeyu sa kun.” Na di keyela dun manla, “Alò lime batù fan na lwe nalaf.” ");
INSERT INTO bps_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na dek Dyisas i dad to sudeng di bnas di dad sahal lumbuk. ");
INSERT INTO bps_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na slumbuk ale sudeng, nun mlatu to na nun lime falò dad to di kat lumbuk. ");
INSERT INTO bps_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na nwè Dyisas i lime batù fan na lwe nalaf, na lngalà kenen di langit du dmasal mlé fye di Dwata, na snatngaan i fan, na blén di dad gal mlalò kenen du nalella di dad to. Na nalelan lwe nalaf di kdeela. ");
INSERT INTO bps_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na gamkaan i kdeela, na bsol ale. ");
INSERT INTO bps_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na santifun dad gal mlalò kenen i lukasan, na fnò sfalò lwe been i gdèla fan na nalaf. ");
INSERT INTO bps_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na kdee dad lagi kmaan lime libu. ");
INSERT INTO bps_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kafngela kmaan dek Dyisas muna dad gal mlalò kenen maweng di banwe Bétsayda di faltù bong lanaw. Na kafnge én, fdaan dad to. ");
INSERT INTO bps_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kafngen fdà dad to, mnagad kenen di satu bulul du dmasal di Dwata. ");
INSERT INTO bps_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Di kbutangan, ditù fa i aweng dad gal mlalò kenen di talà lanaw, na Dyisas aloan satu gtagak di kilil. ");
INSERT INTO bps_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na teen Dyisas too maflayam dad gal mlalò kenen kamwa awengla du gsitongla i too mgal nus. Taman tamayè mwal salu Dyisas di dale tatì magu di tah lanaw, na tafanan ale nlius. ");
INSERT INTO bps_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kabay di kitela kenen tatì magu di tah lanaw, làla dilè, na man nawala lmagol kenen. Na mkit ale, ");
INSERT INTO bps_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","du kdeela mite kenen na too ale likò. Kabay gasil talù Dyisas di dale, manan, “Fangalyu nawayu du agu sa ani. Nang gamu likò.” ");
INSERT INTO bps_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na di kyak Dyisas di awengla, manak i nus. Na too tikeng dad gal mlalò kenen, na too msamuk fandamla tan duen tatì manak i nus. ");
INSERT INTO bps_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hae, du balù tateenla tnikeng nimò Dyisas di fan, knean là ale gamlabat du mgal ulula. ");
INSERT INTO bps_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na fles ale mifal di lanaw na ditù gudmuungla di banwe Génésarét, na ikatla awengla. ");
INSERT INTO bps_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na di ktufa ale Dyisas di aweng, dad to mnè déén dmilè kenen. ");
INSERT INTO bps_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na taman faflal ale fgadè kdee dad to nun tduk di klamang banwela, na balù nè lingela gusalun déén, nebela dad to nun tduk gagin gumilèla salu di kenen. ");
INSERT INTO bps_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na di kdee gusalu Dyisas, balù tukay banwe ku bong, galla sansebe dad nun tduk di kenen. Nebela di fadyanla na fakdo ale ku Dyisas ku beg alò magot di kilil klawehan i dad to nun tduk, na mgulê sa kdee gamgagot dun. ");
INSERT INTO bps_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na nun dad Farisi na dademe tamdò dad flalò blé Dwata fagu di ku Mosis mdà di Dyérusalém stifun di saféd Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na teenla dademe dad gal mlalò ku Dyisas mlafà i tdò flalò dad Dyu, du là ale funa malob kagula kmaan. Na di fnaglutla magagsik i to là malob. ");
INSERT INTO bps_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hae, du dad Farisi na kdee dademe dad Dyu, silang ale kmaan ku funala nalob i kmalla, du én tdò lalò dad gutambulla. ");
INSERT INTO bps_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na ku kel ale fdu di fadyan silang ale kmaan ku funala snabul yéél lawehla. Na nun fa dademe tdò toola nimen mdà di gutambulla gablà di kalob, salngad i kalobla dad tabù, dad kulang na dad fligo tabaga. ");
INSERT INTO bps_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na taman smalek dad Farisi na dad tamdò i flalò Dwata di ku Dyisas, manla, “Kan kè duen dad gal mlalò ge mlafà i tdò flalò dad gutambulito? Hae, du là ale funa malob di fan ale kmaan.” ");
INSERT INTO bps_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na tnimel ale Dyisas, manan, “Tay gamu dad to flingu mimen Dwata! Too glut man Dwata gablà di gamu fagu di tugadan Isaya, manan, ‘I dad to ani mafè deg alò di bàla, bay too mawag nawala di deg. ");
INSERT INTO bps_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Taman landè gukmamu i kfangamfùla di deg, du i tdò manla mdà di Dwata, mdà alò di to.’ ");
INSERT INTO bps_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Hae, knagolyu dad flalò Dwata na balingyu too nimen dad flalò i dad to.” ");
INSERT INTO bps_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na lêman man Dyisas, “Tay, kfulungyu kmagol i flalò blé Dwata du fye gimenyu gamu flalò. ");
INSERT INTO bps_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Du man Dwata fagu di ku Mosis, ‘Nafèyu màyu na yêyu,’ na manan, ‘Ku simto to talù sasè gablà di maan ku demen yéan fnatiyu.’ ");
INSERT INTO bps_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Hae, knagolyu du én balingyu tdò, ku nun tabeng fan blé satu to di dad tuan, na fakay kun, ku manan, ‘Korban,’ (Na i gumtatek ani dunan, i fangu tabeng gamu tagablégu di Dwata.) ");
INSERT INTO bps_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na mdà di manan én, làyu faloh kenen mafè dad tuan fagu di ktabengan dale. ");
INSERT INTO bps_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","I katdòyu i kimen dad flalò dad gutambulyu kfaguyu kmagol i Tnalù Dwata. Na ise alò ani nimòyu, bay dee dademe nimòyu salngad ani.” ");
INSERT INTO bps_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kafnge én, tlo Dyisas dad to di safédan lêman, na manan di dale, “Kdeeyu too flinge na fnaglabatyu i mangu. ");
INSERT INTO bps_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Landè di dad fkah i to di lam baan i gafagsik kenen, bay i sasè lamwà di bà i to i gafagsik kenen. ");
INSERT INTO bps_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Taman flinge gamu, ku nun klingeyu!” ");
INSERT INTO bps_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Na tnagak ale Dyisas i dad to déén na fusuk di lam i gumnè, na smalek dad gal mlalò kenen gablà di fléd gine. ");
INSERT INTO bps_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na man Dyisas di dale, “Balù gamu là gamu fa gamlabat? Làyu kè glabat, i fusuk di bà i to là gafsalà kenen, ");
INSERT INTO bps_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","du là sa fusuk di lam nawan bay di tienan na fles lamwà di lawehan.” (Di kman Dyisas ani, falohan balù tan bung knaan, talandè fnang du gafagsik.) ");
INSERT INTO bps_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na manan fa, “Kabay i kdee sasè lamwà di bà i to én gafsalà kenen, ");
INSERT INTO bps_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","du i lamwà di baan mdà sa di nawan. Na én gumdà i kdee bung salà gambet i sasè fandam, ksaféd i to ise yaanan, ktaku, kbanò, klafà yaan, ");
INSERT INTO bps_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","klom nawa di knun, ayè mimò sasè di dademe to, kafgaw, klandè kyà, kingà nawa, ktalù sasè gablà di dademe to, kafdatah kto, na klandè ldam. ");
INSERT INTO bps_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","I kdee sasè ani slame lamwà mdà di nawa i to, na ani sa gafsalà kenen.” ");
INSERT INTO bps_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kafnge én, tnagak Dyisas i banwe én, na fles kenen di banwe mdadong di lwe syudad Tiro na Sidon. Na fusuk kenen di satu gumnè, na kayean ku landè to gmadè déén kenen di lam, bay laan gagan muni i kton, ");
INSERT INTO bps_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","du di là mlo nun satu libun mlinge tadéén kenen. Na di kgadean dun gasil kenen salu di ku Dyisas na began lkuad di munan du nun tingaan libun nun busawan. ");
INSERT INTO bps_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na libun ani ise Dyu, bay satu to mdà di banwe Fonisya glam di Sirya. Na toon fakdo ku Dyisas, fye falwaan i busaw mnè di tingaan. ");
INSERT INTO bps_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na tmimel Dyisas fagu di fléd, manan, “Funagu fankaan dad ngà, du là fakay nwè knaan i dad ngà na blé di dad ayem.” ");
INSERT INTO bps_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na glabat i libun, ayem i guflingen Dyisas dad to ise Dyu, taman manan, “Hae Amu, gadègu én, bay balù dad ayem gamkaan samel mtatek di dungan i gukmaan dad ngà.” ");
INSERT INTO bps_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na man Dyisas di kenen, “Too fye timelam, taman fakay ge mulê du talamwà i busaw di tingaam.” ");
INSERT INTO bps_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na mdà mulê i libun. Na di kakelan di gumnean teenan tingaan milè di gumilean, du talamwà i busaw. ");
INSERT INTO bps_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na tnagak Dyisas i banwe Tiro. Na én dalanan di syudad Sidon na di banwe dnagit Dikafolis na fles kenen salu di bong lanaw Galili. ");
INSERT INTO bps_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na i dad to déén nebela satu to bakong na malima ktaluan di ku Dyisas. Na fnila ku nagot Dyisas kenen fye mgulê. ");
INSERT INTO bps_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na fagin Dyisas i to bakong mawag di dademe dad to. Na kafnge én, dogan tnaloan di sbalà klingen, na naféan ibal i tnaloan na ihokan di dilaan. ");
INSERT INTO bps_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na meye Dyisas di langit, na falbongan kalnawan. Kafnge én, manan, “Ifata.” I gumtatekan, “Mgukà nan.” ");
INSERT INTO bps_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Di kmanan én, mgukà i klinge i to én, na salngad ku tamagteh dilaan du mbangal i ktaluan. ");
INSERT INTO bps_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na fnang Dyisas i dad to mite, tmulen i mgimoan, bay balù lêan fnang, baling midul fa i ktulenla dun. ");
INSERT INTO bps_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na kdee dad to gmadè dun too ale tikeng, na manla, “Tay, kafye nimò to ani, du balù dad bakong faflingen, na to umu ftaluan.” ");
INSERT INTO bps_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Di satu duh tastifun lêman dee dad to di ku Dyisas. Na di klandè knaanla, tlo Dyisas dad gal mlalò kenen di safédan, na manan di dale, ");
INSERT INTO bps_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Toogu kando dad to stifun dini. Tatlu duhla fanak dini di safédgu, na talandè knaanla. ");
INSERT INTO bps_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ku fdàgu ale landè knaan, baling ale kadang mtafì di dalan, du mawag gumulê dademe.” ");
INSERT INTO bps_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na smalek dad gal mlalò kenen, “Nè gumwèmi knaan di banwe ani gablà fkaan kdee dad to ani? Fye ku nun dad to mnè dini!” ");
INSERT INTO bps_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na snalek Dyisas ale, manan, “File batù fanyu?” Na manla, “Alò fitu.” ");
INSERT INTO bps_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na dekan i dad to sudeng di tanà. Na nwean fitu batù fan na funa kenen dmasal mlé fye di Dwata. Kafnge én, snatngaan, na blén di dad gal mlalò kenen, du falelan dale di dad to. Na nalella di kdee dad to. ");
INSERT INTO bps_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na nun tukay nalafla bay là dee, na lêman dmasal Dyisas di Dwata, na lêmanan dek dad gal mlalò kenen malel dun di dad to. ");
INSERT INTO bps_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na kmaan dad to, na bsol ale. Na i gdè knaan santifunla fitu been fnò. ");
INSERT INTO bps_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na kdee dad to kmaan mdadong di fat libu. Kafngela kmaan fdà Dyisas dad to, ");
INSERT INTO bps_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na gasil myak di aweng magin dad gal mlalò kenen na salu ale di banwe Dalmanuta. ");
INSERT INTO bps_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na nun dad Farisi salu di ku Dyisas du samdal ale kenen. Fnila di kenen i tnikeng mdà di langit, du kfagula tmilew kenen ku glut kenen i dek Dwata. ");
INSERT INTO bps_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na falbongan i nawa, na manan, “Kan ku mni dad to di duh ani tnikeng? Tulengu gamu kaglutan, landè tnikeng fitegu di gamu.” ");
INSERT INTO bps_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kafnge én, tnagak Dyisas dad to déén, na lêman myak ale Dyisas di aweng, na mdà mifal di bong lanaw. ");
INSERT INTO bps_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na di kifalla taglifetla mebe fan bnatula di aweng, alò salbatù gebela. ");
INSERT INTO bps_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na fanngewen ale fagu di fléd, manan, “Tooyu fangeye én gambet bulung falnok fan dad Farisi na Harì Hérod.” ");
INSERT INTO bps_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na là ale gamlabat, taman stulen ale, manla, “Én kè manan, du landè fan nebeito.” ");
INSERT INTO bps_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kabay gadè Dyisas gsalà kaglabatla, taman manan di dale, “Kan ku stulen gamu gablà di làyu kgebe fan? Là gamu fa gamlabat kel ani? Mgal kè uluyu? ");
INSERT INTO bps_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nun matayu, bay là gamu mite? Nun klingeyu, bay là gamu kè mlinge? Làyu kè gafaldam i nimògu? ");
INSERT INTO bps_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Taglifetyu kè kasatngàgu i lime batù fan fkaangu lime libu dad to. File been gukuyu gdèla?” Na manla, “Sfalò lwe.” ");
INSERT INTO bps_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na man Dyisas, “Na i fitu batù fan fkaan fat libu dad to. File been gukuyu gdèla?” Na manla di kenen, “Fitu.” ");
INSERT INTO bps_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na manan, “Kan kè duenyu là gamlabat na ise ku btal fan i mangu?” ");
INSERT INTO bps_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na di kakella di tukay banwe Bétsayda nun satu lagi butè nebe dad to di ku Dyisas. Na fakdo ale fye nagotan du fye mgulê. ");
INSERT INTO bps_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na nagot Dyisas sigal i to butè na nalakan kenen lamwà di tukay banwe én, na dnulaan dad matan. Na di kafkahan kmalan di to én, snalekan, manan, “Nun teenam?” ");
INSERT INTO bps_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na tukeng to én, na manan, “Hae, teengu dad to, bay gambet dad kayu magu kitegu dale.” ");
INSERT INTO bps_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na lêman nagot Dyisas i matan. Na kafnge én, too meye to én, na too fye kiten du tamgulê. ");
INSERT INTO bps_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na dek Dyisas kenen mulê, na manan di kenen nang samfulê di tukay banwe én. ");
INSERT INTO bps_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na salu Dyisas na dad gal mlalò kenen di dad malnak banwe glam di banwe Sisariya Filifos. Na di lamla magu nun snalekan dale, manan, “Tan gal man dad to gablà di deg? Simto agu kun?” ");
INSERT INTO bps_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na tulenla kenen, “Man i dademe, ge kun Dyan Gal Munyag. Man dademe, Ilaydya, ku demen satu di dademe tugad Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na smalek Dyisas, manan, “Kabay gamu, tan manyu? Simto agu kè?” Na tmimel Fiter, manan, “Ge sa Krayst.” ");
INSERT INTO bps_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na too ale nfang Dyisas nang tmulen di balù simto to gablà di kenen. ");
INSERT INTO bps_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mdà di bang ani tambù Dyisas fgadè di dad gal mlalò kenen i fan kel di Tingà To. Na manan là fakay ku là kenen magu di dee bung kaflayam. Na dad tua gal mebe dad Dyu na dad ulu dad bà di Dwata na dad tamdò i flalò blé Dwata fagu di ku Mosis, knagolla kenen kadang na fnatila, bay nték kenen mdà di fati di gatlun duh. ");
INSERT INTO bps_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na too mbangal i man Dyisas di dale ani, taman nebe kenen Fiter di kilil, na nngakan du tagmanan, “Fnatila agu.” ");
INSERT INTO bps_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kabay falê Dyisas meye di dademe gal mlalò kenen, na nngakan Fiter, manan, “Fawag ge di deg Satanas! Ise di Dwata gumdà i fandamam bay di to!” ");
INSERT INTO bps_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na lêman tlo Dyisas di safédan dad gal mlalò kenen na i dee dad to déén, na manan di dale, “Ku nun to mayè too mlalò deg, là fakay ku laan knagol knayè i kton, na mebe krusan, na too mlalò deg. ");
INSERT INTO bps_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Du ku simto kmabas i nawan, knean mati. Kabay ku simto mati du mdà di klaloan deg ku demen mdà di kbelan i Fye Tulen gablà di deg, nun nawan landè sen. ");
INSERT INTO bps_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Balù gfun satu to i kdee fye dini tah tanà, tan gufyen ku lana di kenen nawa landè sen. Landè. ");
INSERT INTO bps_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Du landè fakayan blé du fye gbawian nawan landè sen. ");
INSERT INTO bps_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na sadni too dee dad to too gamsalà na knangla Dwata. Na i to gbol di dale i myà mfun deg ku demen tdògu, kyàgu kenen kadang, agu dnagit Tingà To, di kasfulêgu magin bong kdatah Màgu na magin dad kasaligan too mtiu.” ");
INSERT INTO bps_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na manan di dale, “Tulengu gamu i kaglutan, nun tadag dini là mati kel di kiteyu kdatah i kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kafnge i nam butang, fagin Dyisas Fiter, Dyém, na Dyan di satu mdatah bulul, na landè to ditù alò ale. Na di klola meye di kenen mgili bawehan. ");
INSERT INTO bps_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","I klawehan too mneng bukay landè to di klamang banwe gmagan fbukay salngad kbukayan. ");
INSERT INTO bps_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na msut déén Ilaydya na Mosis stulen di ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na man Fiter di ku Dyisas, “Amu, too fye du dini gami. Fye ku fdak gami tlu slung, satu i ge, satu ku Mosis, na satu ku Ilaydya.” ");
INSERT INTO bps_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ani gman Fiter du laan gadè i fye man du too ale likò. ");
INSERT INTO bps_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na di slengan talù maglimun ale labun, na nun talù mdà di bong labun, manan, “Ani tingàgu toogu kanbong nawa. Flinge gamu kenen!” ");
INSERT INTO bps_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na gasil ale meye di glibutla, bay landè dademe to teenla di safédla, alò Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na di kasolla mdà di bulul too ale nfang Dyisas, manan, “Nangyu tulen di balù simto to i teenyu ditù gine. Silangyu tulen ku mték agu, i dnagit Tingà To, mdà di fati.” ");
INSERT INTO bps_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na nimenla man Dyisas di dale, bay santulenla ku alò ale, i gumtatek i manan mték mdà di fati. ");
INSERT INTO bps_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na nun fa làla glabat, taman snalekla, manla, “Kan ku gal man i dad to tamdò flalò Dwata, na silang kel i To Mgalék Dwata ku takel lêman Ilaydya?” ");
INSERT INTO bps_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na man Dyisas, “Too glut, i muna kel i to gambet ku Ilaydya du fatlagadan kdee, bay nun fa gman di Tnalù Dwata gablà deg, i dnagit Tingà To. I gman déén dee kaflayam nagugu na knangla agu nawa.” ");
INSERT INTO bps_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na man Dyisas fa, “Na gablà ku Ilaydya, tulengu gamu, takel sa Ilaydya, na balingla kenen fanlayam gusen i knayèla gambet i fsulat Dwata di Tnaluan gablà di kenen.” ");
INSERT INTO bps_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na di kasfulê ale Dyisas di dademe dad gal mlalò kenen, teenla dee dad to stifun ditù. Na nun dad tamdò i flalò blé Dwata fagu di ku Mosis samdal dale. ");
INSERT INTO bps_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na kite dad to ku Dyisas too ale tikeng, na gasilla snitong kenen, na dnawatla kenen. ");
INSERT INTO bps_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na snalekan ale, manan, “Tan sandalyu?” ");
INSERT INTO bps_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na nun to mdà di dad to stifun déén tmimel, manan, “To Tamdò, tanebegu di ge i tingàgu lagi du nun busaw fumu kenen. ");
INSERT INTO bps_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na ku gal fusuk i busaw, galan sek di tanà tingàgu. Na gal mulak i baan, na kminggat kifanan, na mbaling kmeseg lawehan. Tabeg agu fakdo di dad gal mlalò ge du fye falwàla, bay làla gagan falwà dun.” ");
INSERT INTO bps_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na man Dyisas, “E tay, gamu dad to di bang ani, too landè kafaglutyu. Bong klogu mnè di safédyu! Tan fa dé kaftahàgu nawagu di gamu du fye faglut gamu? Nebeyu dini i tingà.” ");
INSERT INTO bps_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Taman nebela tingà di ku Dyisas. Na di kite busaw ku Dyisas toon fakakal i tingà na fafugenan di tanà. Na tatì glulid i tingà, na mulak baan. ");
INSERT INTO bps_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na snalek Dyisas mà i tingà, manan, “Tamlo kè tdukan?” Na man i maan, “Tagnè mdà di ktukayan. ");
INSERT INTO bps_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Too dee dulê batan di lam lifoh na yéél du kayean mati kenen, bay ku gaganam, toom gami kando, na tnabengam gami.” ");
INSERT INTO bps_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na man Dyisas, “Kan ku manam, ‘Ku gaganam?’ Gagan Dwata mimò balù tan di to faglut di kenen.” ");
INSERT INTO bps_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na falbong mà i tingà taluan, manan, “Faglut agu sa, bay begam snikof i kafaglutgu.” ");
INSERT INTO bps_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na teen Dyisas tadee dad to gasil salu di dale, taman nngakan i busaw, manan, “Ge busaw gal fbakong na fumu, mangu ge, lamwà di kenen, na nang ge lêman fusuk kel di landè sen.” ");
INSERT INTO bps_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na mkit i busaw na salngan én toon kfakakal i tingà, kafnge én, lamwà. Na i baweh tingà salngad i tidol, taman man dee dad to, “Tamati kenen.” ");
INSERT INTO bps_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kabay nagot Dyisas kmal i tingà na ntékan, na fles kenen tadag. ");
INSERT INTO bps_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Di kfusuk Dyisas na dad gal mlalò kenen di gumnè, nun snalekla kenen di alò ale déén, manla, “Tan duenmi là gmagan falwà i busaw gine?” ");
INSERT INTO bps_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na man Dyisas di dale, “Alò fagu di dasal gaganyu falwà i busaw salngad ani.” ");
INSERT INTO bps_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tnagakla banwe én, na déén dalanla di Galili. Na là mayè Dyisas ku nun gmadè ku nè gumagula, ");
INSERT INTO bps_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","du én tdoan i dad gal mlalò kenen gablà di fan kel, manan, “Tamdadong kablé deg, i dnagit Tingà To, di agot i dad to, na fnatila agu, bay balù fnatila agu, lêman agu sa mték di gatlun duh.” ");
INSERT INTO bps_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kabay làla glabat gumtatek i manan, na likò ale smalek dun. ");
INSERT INTO bps_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na di kakella di tukay banwe Kafernaum fusuk ale di gumnè na snalek Dyisas dad gal mlalò kenen, manan, “Tan santulenyu gine di dalan?” ");
INSERT INTO bps_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kabay là ale gamtimel, du i santulenla ku simto too mdatah di dale. ");
INSERT INTO bps_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Taman sudeng Dyisas, na tlon di kenen dad sfalò lwe, na manan, “Ku nun to mayè too mdatah di kdee, fye ku fdanaan i kton, na tnabengan i kdee.” ");
INSERT INTO bps_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na nwè Dyisas satu tingà du ftadagan di blengla na began lkaf, na manan di dale, ");
INSERT INTO bps_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ku simto dmawat satu tingà gambet ani du mdà di ksasatun di deg, dnawatan agu, na i dmawat deg, dnawatan Màgu Dwata, i mdek deg.” ");
INSERT INTO bps_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na man Dyan di ku Dyisas, “To Tamdò, nun teenmi satu lagi gal falwà dad busaw fagu di dagitam. Na fnangmi, du ise kenen satu dadememi gal mlalò ge.” ");
INSERT INTO bps_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kabay man Dyisas, “Nangyu kenen fnang du landè to mlal gamtalù sasè gablà di deg ku galan nimò tnikeng fagu di dagitgu, ");
INSERT INTO bps_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","du i to là mnang nawa gito msen gito. ");
INSERT INTO bps_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na tulengu gamu i kaglutan, nun untung sa di fulé duh én to mlé balù alò tukay yéél ninum di gamu du mdà di ksasatuyu di deg, dunan Krayst, i Mgalék Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Na man Dyisas fa, “Na ku simto gumdà i satu to gamsalà, too kenen fanlayam. Fye fa ku mgikat di lialan bong giling batu, na bat kenen di gumngalam mahin, di laan fa gebe di salà satu di dad to faglut di deg gambet tingà ani. ");
INSERT INTO bps_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kaflingenta dun, ku bali kmalam mebe ge di kimò sasè, fye fa baling ku kanlangam du fye là ge fles mimò sasè, du fye fa ku fatok ge na nun nawam landè sen di sikof kmalam bay baling ge bat di lanaw lifoh landè gusenan, ");
INSERT INTO bps_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","du ditù landè gumati dad safat, na landè gumati i lifoh. ");
INSERT INTO bps_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na ku bali bliam i mebe ge di kimò sasè, fye fa baling ku kanlangam, du fye là ge fles mimò sasè, du fye fa ku kimay ge na nun nawam landè sen di sikof bliam, bay baling ge bat di lanaw lifoh, ");
INSERT INTO bps_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","du ditù landè gumati dad safat, na landè gumati i lifoh. ");
INSERT INTO bps_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na ku bali matam mebe ge di kimò sasè fye fa ku balingam tanwil du fye là ge fles mimò sasè, du fye fa ku alò satu matam, na fakay ge gakuf di kagot Dwata, di sikof matam, bay baling ge bat di lanaw lifoh, ");
INSERT INTO bps_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","du ditù landè gumati dad safat, na landè gumati i lifoh. ");
INSERT INTO bps_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Na kdee dad to tnilew fagu di lifoh dunan i kaflayam. ");
INSERT INTO bps_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“I dad to mlalò deg gambet kahì mlé nem di knaan du ale gumdà i kafye di demela to, bay ku magwè i nem i kahì, talandè kibò fye lêman mahì. Taman fye ku gambet kahì mangnem i nimòyu, taman sansatuyu nawayu di dademeyu.” ");
INSERT INTO bps_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na tnagak Dyisas Kafernaum na salu di banwe Dyudiya. Kakelan ditù fles kenen di faltù i yéél Dyordan. Na lêman dee dad to stifun di kenen, na lêman kenen tamdò dale du én tagnè galan nimò. ");
INSERT INTO bps_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na nun dad Farisi salu di kenen du neyela dalan dmalam kenen, taman smalek ale, manla, “Fakay dé di flalò blé Dwata ku kahito yaanito?” ");
INSERT INTO bps_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na smalek Dyisas, manan, “Tan i flalò Mosis?” ");
INSERT INTO bps_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Manla, “Falohan ku kah i dad lagi yaanla ku tafunala sulat i fafil gufgadè i kaskah.” ");
INSERT INTO bps_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Man Dyisas, “Hae, du too mgal i uluyu. Ani sa duen Mosis smulat i flalò én. ");
INSERT INTO bps_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kabay ise gambet ani di katbuan di kimò Dwata i banwe, du man i Tnaluan, ‘Nimò Dwata satu lagi na satu libun.’ ");
INSERT INTO bps_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ani duen i lagi lamwà di ifat i maan na yéan na mnè di saféd i yaanan, ");
INSERT INTO bps_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","du lwe to ani mgimò satu.’ Taman taise ku lwe to i satlamin bay mbaling satu. ");
INSERT INTO bps_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Taman là fakay sankah dad to tasansatu Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na di kfusukla di lam gumnè, lêman smalek dad gal mlalò kenen gablà di kaskah yaan. ");
INSERT INTO bps_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na man Dyisas di dale, “Balù simto to mkah yaanan, na lêman mwè satu libun, tagamsalà du nlafaan i muna yaanan. ");
INSERT INTO bps_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Salngad i libun mkah yaanan, na mwè satu lagi, tagamsalà du nlafaan i muna yaanan.” ");
INSERT INTO bps_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na nun dad to mebe i dad ngà di ku Dyisas du fye nagotan ale na dnasalan. Kabay dad gal mlalò ku Dyisas balingla nngak dad to én. ");
INSERT INTO bps_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kabay di kite Dyisas nimòla, kalbutan dad gal mlalò kenen, na manan di dale, “Falohyu dad ngà salu di deg na nangyu ale fnang, du ku simto nun ksalig salngad dad ngà ani, gakuf ale di kagot Dwata. ");
INSERT INTO bps_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tulengu gamu kaglutan, ku i ksalig satu to là salngad di dad ngà ani, là kenen gakuf di kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na lkaf Dyisas i dad ngà, na fkahan kmalan di ulula du banlén ale kafye. ");
INSERT INTO bps_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na di kdà Dyisas magu nun to gasil salu di kenen na lkuad di munan, manan, “E To Tamdò, too ge tlu to, taman ani snalekgu di ge, tan nimògu fye gfungu nawa landè sen?” ");
INSERT INTO bps_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na man Dyisas di kenen, “Kan ku manam agu tlu to? Alò satu to tlu, dunan Dwata. ");
INSERT INTO bps_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tagadeam dad flalò blé Dwata fagu di ku Mosis i gman, ‘Nang ge manò, nang ge mlafà yaanam, nang ge tmaku, nang tmulen kéng di gususay, nang ge mlangong i demem to, na mafè ge maam na yéam.’ ” ");
INSERT INTO bps_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na man i to, “Hae To Tamdò, tanimengu i kdee flalò Dwata mdà fa di gutukaygu.” ");
INSERT INTO bps_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na meye Dyisas di to én na too bong kakdon kenen. Na manan di kenen, “Kabay nun fa satu gukulangam. Mdà ge, na fablim kdee dad knunam, na blém bayadan di dad to landè. Na fagu déén nun bong knun gfunam di langit. Kafnge én, samfulê ge, na mlalò ge deg.” ");
INSERT INTO bps_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kabay di kaklinge i lagi i man Dyisas, mbaling too blat bawehan, na mdà kenen na too mlidù nawan du too bong knunan. ");
INSERT INTO bps_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na falê Dyisas meye di dad gal mlalò kenen, na manan, “Too malima kagfusuk i to nun bong knun di kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na tikeng i dad gal mlalò kenen di kaklingela i manan. Kabay lêman man Dyisas di dale, “Mangu di gamu dad gal mlalò deg, too malima di balù simto to fusuk di kagot Dwata. ");
INSERT INTO bps_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E dad ngà, malima fusuk i bong lmanaf kamél di sol i dalum, bay malima fa i satu to nun bong knun fusuk di kagot Dwata.” ");
INSERT INTO bps_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaklingela én, matnù ktikengla, na manla, “Ku glut én, simto kè galwà?” ");
INSERT INTO bps_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na meye Dyisas di dale, na manan, “Landè to gmagan mimò ani, bay Dwata gmagan sa, du gagan Dwata kdee.” ");
INSERT INTO bps_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na man Fiter di kenen, “Neyem gami, tatnagakmi kdee du mlalò gami ge.” ");
INSERT INTO bps_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na man Dyisas, “Tulengu gamu kaglutan, ku nun to tmagak i gumnean, ku demen dad flanekan, ku demen dad tuan, ku demen dad ngaan, ku demen tanaan du mdà di ksasatun di deg na mdà di kdawatan i Fye Tulen, ");
INSERT INTO bps_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","too bong gdawatan mdà di Dwata di klon mnè di tah tanà, dunan dad gumnè, dad flanek lagi na libun, dad yê, dad ngà, na dad tanà, kel di mlatu dulê kbongan di gtagakan, na gagin dee dad kaflayam, na di fulé duh gamdawat kenen nawa landè sen. ");
INSERT INTO bps_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nun dee dad to mdatah di duh ani baling mdanà kadang di fulé duh. Na dee dad to mdanà di bang ani mdatah kadang di fulé duh.” ");
INSERT INTO bps_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Di dalan ale Dyisas mnagad salu di syudad Dyérusalém, magu Dyisas muna di dademe to magin kenen. Na tikeng i dad gal mlalò kenen du salu ale di syudad gumnè dad to dmuen kenen. Na likò dad to tmadol déén. Na lêman fafdadong Dyisas dad sfalò lwe galan dek, du fgadè dale gablà di fan kel di kenen. ");
INSERT INTO bps_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Na man Dyisas di dale, “Flinge gamu, du salu ito nan di Dyérusalém, na ditù bléla agu, i dnagit Tingà To, di agot dad ulu dad bà di Dwata na dad tamdò dad flalò blé Dwata fagu di ku Mosis na nukumla agu di fati. Na kafnge én, bléla agu di agot dad to ise Dyu du fafatila, ");
INSERT INTO bps_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na dad to én, toola agu kadang snilo, na dnulàla, na bnadasla, na flesla agu fnati, bay di gatlun duh mték agu mdà di fati.” ");
INSERT INTO bps_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na fdadong Dyém na Dyan, i lwe dad ngà Sébidi, na manla di ku Dyisas, “To Tamdò, nun kayèmi fni di ge.” ");
INSERT INTO bps_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na smalek Dyisas, manan, “Tan kayèyu mdà di deg?” ");
INSERT INTO bps_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na tmimel i lwe, “Ku tagdawatam kdataham kadang, kayèmi ku fsudengam gami di safédam satu gsen di kwananam na satu gsen di ibengam.” ");
INSERT INTO bps_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kabay man Dyisas, “Làyu gadè i fniyu. Gaganyu kè mebe i kaflayam salngad bong kaflayam gnagugu kadang? Gamtayud gamu i bong kalima salngad deg kalima?” ");
INSERT INTO bps_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Manla, “Hae, gaganmi.” Na man Dyisas di dale, “Too glut, i kaflayam gnaguyu, salngad di kaflayam gnagugu. ");
INSERT INTO bps_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kabay landè kaglutgu malék ku simto fsudeng gsen di kwanangu na di ibenggu, du én alò gsudeng déén i dad to tagutmagà i Màgu dun.” ");
INSERT INTO bps_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na di kaklinge i dademe sfalò gal mlalò ku Dyisas i fni dademela ani, flabè ale ku Dyém na Dyan. ");
INSERT INTO bps_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kabay tlo Dyisas kdeela di safédan, na manan di dale, “Tagadèyu i gal nimò i dad ganlal dad to di tah tanà ani. Toola bankut dad to gdanà di dale. I dad to nun glal, toola gal dek i dad to. ");
INSERT INTO bps_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kabay gamu, ise én kfaguyu, du ku nun di gamu mayè mbaling mdatah là fakay ku laan gal tnabeng i dademen. ");
INSERT INTO bps_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na ku nun di gamu mayè mdatah di kdee, là fakay ku laan flifan i kton di kdee dademen, ");
INSERT INTO bps_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","du balù agu, i dnagit Tingà To, làgu salu di tanà ani du én kayègu ku tnabeng agu i dad to, bay i duengu salu dini du tnabenggu dad to na blé ktogu di fati, du bnayadgu i dad salàla du fye dee dad to galwà.” ");
INSERT INTO bps_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na takel Dyisas na dad gal mlalò kenen di banwe Dyériko, na di kdàla lêman, nun dee dad to magin dale. Na nun to butè dnagit ku Bartimyus, tingà Timyus lagi, sudeng di kilil dalan du mni. ");
INSERT INTO bps_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Di kaklingen i to mlius di kenen dunan Dyisas mdà di Nasarét, tambù kenen tamlo, manan, “E Dyisas, Bel Harì Dabid, begam agu kando!” ");
INSERT INTO bps_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na dee to mngak na manla kenen fanak. Bay baling matnù kakitan, manan, “Bel Harì Dabid, begam agu kando!” ");
INSERT INTO bps_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na tlag Dyisas magu, manan, “Tloyu kenen dini.” Na katlola i to butè, manla, “Fangalam nawam, na tadag ge du tatlon ge.” ");
INSERT INTO bps_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na batan lafin klaweh began kalomboy, na gasil kenen tadag, na salu di ku Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na snalek Dyisas kenen, “Tan kayeam nimògu di ge?” Na tmimel i to butè, manan, “Amu, kayègu ku beg agu mite.” ");
INSERT INTO bps_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na man Dyisas di kenen, “Fakay ge mulê du mdà di kafaglutam tamgulê ge.” Na mite sa kenen, na fles magin ku Dyisas di kagun. ");
INSERT INTO bps_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na mdadong ale Dyisas di Dyérusalém du tafan ale kel di dad tukay banwe dnagit Bétfagi na Bétani déén di dungan bulul Olib. Na nun lwe gal mlalò kenen dekan muna. ");
INSERT INTO bps_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na manan di dale, “Fles gamu di banwe sen munaito. Kfusukyu ditù, nun teenyu satu nati dongki ikat landè to lmen smakay dun. Nbelyu ikatan na nebeyu dini. ");
INSERT INTO bps_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na ku nun to man di gamu, ‘Kan ku nimòyu én?’ manyu di kenen, ‘Nun gukmamu i Amu dun, na lêmanan gasil fulê di gamu.’ ” ");
INSERT INTO bps_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na tamdà ale, na kakella ditù nun teenla nati ikat déén di dalan di saféd takab gumnè. Na klola mbel ikat i nati, ");
INSERT INTO bps_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nun dad to tadag déén smalek, manla, “Kan ku nbelyu ikat nati én?” ");
INSERT INTO bps_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na tmimel ale salngad i man Dyisas di dale, na falohla ale mwè dun. ");
INSERT INTO bps_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na nebela nati di ku Dyisas, na nafidla i dademe klawehla, na smakay Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na dee dad to mbel dademe klawehla di dalan gumagun, na kamlang dademe dad fanga nun doon mdà di dad kayu di kilil dalan du filèla di gumagu Dyisas, du fitela afèla kenen. ");
INSERT INTO bps_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na tamlo dad to di muna na tmimel dad to di fulé, manla, “Dnayenito Dwata! Too nun kafye i to salu dini mebe i glal Amuito Dwata! ");
INSERT INTO bps_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Banlé Dwata kafye i kagot fan kel tafakang di tbulito Harì Dabid! Dnayenyu Dwata kdeeyu mnè di tah langit!” ");
INSERT INTO bps_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na di kakel Dyisas di Dyérusalém, fusuk kenen di Bong Gumnè Dwata. Na teenan kdee nimòla di lam, na du taflabi nan, samfulê kenen na i dad sfalò lwe gal mlalò kenen di banwe Bétani. ");
INSERT INTO bps_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na di tmadol duh, mdà ale di Bétani, na di lamla magu tabitil Dyisas. ");
INSERT INTO bps_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na mdà di gumawagan nun teenan satu kayu fig mlumbù doonan, taman salu kenen ditù du neyen ku nun bungen, bay kakelan déén alò doon teenan, du ise bangan munge. ");
INSERT INTO bps_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na talù Dyisas di kayu, manan, “Fandà ani landè nan gamkaan i bungem.” Na mlinge dad gal mlalò kenen. ");
INSERT INTO bps_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na di kakel ale Dyisas di syudad Dyérusalém fusuk kenen di Bong Gumnè Dwata, gal gumangamfù dad Dyu, na ndalan dad to sbayad déén. Fnugenan dad lamisa dad to samfalit filak, na dad gusudeng dad to fabli salafati galla dsù. ");
INSERT INTO bps_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na laan faloh dad to mebe dad kalyak balù alò magu di lam i Bong Gumnè Dwata. ");
INSERT INTO bps_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na tdò ale Dyisas, manan, “Tagsulat di Tnalù Dwata, manan, ‘Én gukmamu gumnègu gal gudmasal di deg i dad to mdà di kdee dad banwe.’ Én man Dwata, bay tabalingyu nimò gumnè dad to tmaku.” ");
INSERT INTO bps_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na linge dad ulu dad bà di Dwata na dad tamdò i flalò blé Dwata fagu di ku Mosis, taman mngabal ale kfagu mati ku Dyisas, du likò ale kenen, du too tikeng i dad to di katdoan. ");
INSERT INTO bps_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na di kasdaf i duh, lamwà ale Dyisas di syudad. ");
INSERT INTO bps_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na di flafus i tmadol duh, di kagula lêman, teenla i kayu fig tamlanas na mati kel di dalilan. ");
INSERT INTO bps_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na gafaldam Fiter i gman Dyisas di kayu, na manan, “Amu, neyem kayu tanngakam, tamlanas.” ");
INSERT INTO bps_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na tmimel Dyisas, “Hae, faglut gamu di Dwata, ");
INSERT INTO bps_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","du tulengu gamu kaglutan, balù simto to ku too kenen faglut na là lwe nawan di kdohò Dwata i fnin, toon dnohò di kenen. Na fakayan man di bulul ani, ‘Magket ge na gbat di lam mahin,’ na gdohò sa i manan. ");
INSERT INTO bps_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Taman tulengu gamu, balù tan fniyu di dasal, ku faglut gamu blé di gamu i fniyu, gdawatyu sa. ");
INSERT INTO bps_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kabay di kdasalyu ku nun ksasè nawayu di balù simto to, funayu nlifet salàla kloyu dmasal di Dwata du fye i Màyu di langit lê mlifet i salàyu, ( ");
INSERT INTO bps_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","du ku làyu nlifet salà demeyu to, na là nlifet Màyu di langit gamu salà.)” ");
INSERT INTO bps_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na di kakella di Dyérusalém lêman salu Dyisas di Bong Gumnè Dwata. Na di laman magu di lam, fdadong di kenen dad ulu dad bà di Dwata na dad tamdò i flalò blé Dwata fagu di ku Mosis, na dad tua gal mebe i dad Dyu. ");
INSERT INTO bps_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na smalek ale, manla, “Tan kè kaglutam mimò i kdee nimoam? Na simto kè mlé ge glal mimò dun?” ");
INSERT INTO bps_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na man Dyisas di dale, “Nun snalekgu gamu funa, na ku gtimelyu tulengu gamu gumdà glalgu mimò ani. ");
INSERT INTO bps_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tulenyu deg sa kun, nè gumdà glal Dyan munyag? Mdà di Dwata, ku demen mdà di to?” ");
INSERT INTO bps_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na stulen ale ku tan timella, manla, “I tan timelito? Ku manito, ‘I glalan mdà di Dwata,’ snalekan ito, ‘Kan ku làyu fnaglut i manan?’ ");
INSERT INTO bps_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kabay là fakay ku manito, ‘Mdà di dad to.’ ” (Hae, du likò ale i dad to du kdeela too faglut Dyan satu too glut tugad Dwata.) ");
INSERT INTO bps_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Taman tmimel ale ku Dyisas, manla, “Làmi gadè.” Taman man Dyisas di dale, “Na, làgu tulen gamu ku nè gumdà glalgu mimò i nimògu.” ");
INSERT INTO bps_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na tambù Dyisas tamdò dad to lêman fagu di fléd, manan, “Nun satu to mule dad walad dnagit grép di tanaan, na nlabatan. Na makol kenen sol di bong batu du gumisà bunge grép. Na fdakan satu too mdatah gumnè du gumunung dad fulen. Na kafnge én, fagotan dad fulen di dademe to, du salu kenen di satu banwe. ");
INSERT INTO bps_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na di bang ktaga dad bungen, nun dekan satu saligan salu di dad to magot dun, du fwean kenen alel. ");
INSERT INTO bps_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kabay i dad to fagotan dun, balingla kanfè saligan na bnunalla, na dekla kenen mulê, bay landè febela kenen. ");
INSERT INTO bps_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Na lêmanan dek satu saligan salu ditù, na sneeyla i ulun na toola fa fyà. ");
INSERT INTO bps_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na lêmanan dek satu, bay fnatila sa. Na dee fa dad to dek i mfun tanà, bay bnunalla dademe na fnatila dademe. ");
INSERT INTO bps_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Én alò i laan fa fsalu ditù i tingaan lagi toon kando, bay di sangalan, dekan di dale i tingaan, du manan, ‘Là fakay ku làla nafè tingàgu.’ ");
INSERT INTO bps_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Kabay kitela kenen, baling ale stulen, manla, ‘Ani sa tingà i mfun i fule. Kenen i mfun kadang, taman snitongito kenen na fnatiito, du fye di kfati maan gito gamfun i fule.’ ");
INSERT INTO bps_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na taman kanfèla, na fnatila, na batla di lwà gumule i maan.” ");
INSERT INTO bps_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na smalek Dyisas manan, “Tan dé kibò i mfun fule i dad to gufagotan dun? Én nimoan, salu ditù na fnatin kdeela, na fagotan di dademe dad to. ");
INSERT INTO bps_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Làyu kè gbasa i gman Dwata di Tnaluan? Manan, ‘I batu knang i dad to fdak i gumnè batu, du di dale fandam landè kamu dun, én baling i batu too mabtas di kdee. ");
INSERT INTO bps_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hae, ani mgimò Amuito Dwata, na di kitemi, too gamtikeng i nimoan.’ ” ");
INSERT INTO bps_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Di kaklinge i dad gal mebe dad Dyu i fléd Dyisas, glabatla ale gugtadè i manan, taman mngabal ale kfagu kamfè kenen, bay làla mgimò dun du likò ale i dad to. Taman tnagakla Dyisas déén, na mdà. ");
INSERT INTO bps_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na dekla dademe dad Farisi na dademe dad Dyu msen di ku Harì Hérod di ku Dyisas, du kayèla mawel kenen fagu di dad ksalek. ");
INSERT INTO bps_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na salu ale di ku Dyisas, na manla di kenen, “To Tamdò, gadèmi ge satu to là tmulen kéng. Tamdò ge i kaglut gablà di knayè Dwata, du laam fkah di nawam i man dad to gablà di ge, na là mabtas di ge ku tan glalla. Taman nun snalekmi ge. Fakay dé di flalò blé Dwata fagu di ku Mosis ku mlé gami bayad buhis di ku Sisar, gumdatah di banwe Roma? ");
INSERT INTO bps_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nun kaglutmi mayad dun ku demen landè?” Kabay gadè Dyisas alò flingu mimò fye i dad to ani, na kayèla kamfè kenen, taman snalekan ale, “Kan ku tilewyu agu fnawel? Nebeyu deg satu filak galyu bayad buhis du neyegu.” ");
INSERT INTO bps_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na nebela di kenen satu filak. Na snalekan ale, manan, “Simto kè baweh na dagit i gkah di filak ani?” Na manla, “Ku Sisar.” ");
INSERT INTO bps_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na man Dyisas di dale, “Na ku tan nfun Sisar bléyu ku Sisar, na ku tan nfun Dwata bléyu di Dwata.” Na too ale tikeng di timelan. ");
INSERT INTO bps_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na nun dad Sadusi salu di ku Dyisas, dunan dad Dyu i gal mangman kun, là mték dad to mdà di fati. Na ani snalekla di kenen, ");
INSERT INTO bps_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","manla, “To Tamdò, nun sulat Mosis di gito di muna gman, ku mati satu lagi, bay landè tingàla yaanan, là fakay ku là nwè i flanekan lagi i libun balu én, du fye nun bel i tamati fagu di kenen. ");
INSERT INTO bps_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na di muna kun, nun fitu lagi saflanek. Na mwè yaan i twege, bay mati na landè tingàla. ");
INSERT INTO bps_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Di kfatin, nwè i twalin tmadol kenen i yaanan, bay lêman mati flanekan, na landè tingàla. Na salngad kagkah di gatlun, ");
INSERT INTO bps_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","kel di sangal twali, i fitu saflanek, kdeela mati landè tingàla di libun ani. Na i sangalan mati libun. ");
INSERT INTO bps_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na ani snalekmi, kadang di kték i dad mati, simto di fitu saflanek i yaanan du kdeela mwè kenen.” ");
INSERT INTO bps_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na tmimel Dyisas, manan, “Gsalà fandamyu, na i duenan du làyu gadè i Tnalù Dwata, na làyu gadè kgal tulus Dwata. ");
INSERT INTO bps_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Du di kték i dad to mati, talandè swè yaan lagi ku demen libun, du én kagkahla salngad dad kasaligan Dwata di langit. ");
INSERT INTO bps_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na gablà di fnaglutyu i là mték dad to mati, làyu kè lmen masa i gsulat Mosis gablà di kayu dminè du ditù gugsulat i gman Dwata di ku Mosis, manan, ‘Agu i Dwata fnangamfù Abraham, Isaak, na Dyékob.’ ");
INSERT INTO bps_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I gman Dwata ani satu gugmadeito balù tamati ale Abraham mto ale lêman, du Dwata i Dwata fnangamfù i dad to mto, ise dad to mati. Taman too bong kagsalàyu ku man nawayu landè dad to mték mdà di fati.” ");
INSERT INTO bps_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na nun satu to tamdò flalò blé Dwata fagu di ku Mosis salu déén na lingen i kastulenla, na gadean too fye timel Dyisas dale, taman snalekan kenen, manan, “Tan too mdatah flalò di kdee flalò Dwata?” ");
INSERT INTO bps_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na tmimel Dyisas, manan, “I too mdatah flalò Dwata, dunan ani, ‘Flinge gamu kdeeyu dad bel Israél. I Amuito Dwata alò, i too glut Dwata, landè dademe. ");
INSERT INTO bps_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Taman tooyu kando Amuyu Dwata mdà di nawayu, na di kdee knayèyu, na di kdee fandamyu, na di kdee galyu.’ ");
INSERT INTO bps_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na i gamtadol too mdatah flalò dunan ani, ‘Tooyu kando i demeyu to salngad kakdoyu i ktoyu.’ Na landè dademe flalò mdatah fa di lwe ani.” ");
INSERT INTO bps_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kaklinge i to tamdò flalò Dwata i man Dyisas ani, manan, “Too glut manam, To Tamdò, én Dwataito alò i too glut Dwata na landè dademe Dwata galwà di kenen. ");
INSERT INTO bps_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na ku tooito kando kenen